﻿USE sofia;
DROP TABLE IF EXISTS sofia.bpr_vpl;
CREATE TABLE bpr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bpr_vpl WRITE;
INSERT INTO bpr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ani sén i dad dagit i gutambul Dyisas Krayst, i bel Harì Dabid, dunan i bel Abraham. ");
INSERT INTO bpr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Mdà Abraham, kenen i mà Isaak, na Isaak i mà Dyékob, na Dyékob i mà Dyuda na i dad flanekan. ");
INSERT INTO bpr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na Dyuda i mà Péris na Sérah, na yé dagit i yêla Tamar. Na mdà Péris, kenen i mà Hésron, i mà Ram. ");
INSERT INTO bpr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na Ram i mà Aminadab, na Aminadab i mà Nason, na Nason i mà Salmon. ");
INSERT INTO bpr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na Salmon i mà Boas, na yé dagit i yê Boas dunan Rahab. Na mdà Boas, kenen i mà Obéd, na yé dagit i yê Obéd dunan Rut. Na mdà Obéd, kenen i mà Dyési. ");
INSERT INTO bpr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na Dyési i mà Harì Dabid. Na mdà Harì Dabid, kenen i mà Solomon, na yé yê Solomon i yaan Uraya. ");
INSERT INTO bpr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na mdà Solomon, kenen i mà Rihoboam, na Rihoboam i mà Abadya, na Abadya i mà Asa. ");
INSERT INTO bpr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na Asa i mà Dyihosafat, na Dyihosafat i mà Dyoram, na Dyoram i mà Usaya. ");
INSERT INTO bpr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na Usaya i mà Dyotam, na Dyotam i mà Ahas, na Ahas i mà Hésékaya. ");
INSERT INTO bpr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na Hésékaya i mà Manasi, na Manasi i mà Amon, na Amon i mà Dyosaya. ");
INSERT INTO bpr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na Dyosaya i mà Dyékonaya, na i dad flanekan lagi. Di dad du atù, i dad to mdà di banwe Babilon, kanfèla ale gagin i dademela Dyu, na nebela ale ditù di Babilon. ");
INSERT INTO bpr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na kanto ale kel di Babilon, nun ngà Dyékonaya, na yé dagitan Saltiyél. Na Saltiyél i mà Sorubabél. ");
INSERT INTO bpr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na Sorubabél i mà Abayud, na Abayud i mà Ilaykim, na Ilaykim i mà Asor. ");
INSERT INTO bpr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na Asor i mà Sadok, na Sadok i mà Akim, na Akim i mà Ilayud. ");
INSERT INTO bpr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na Ilayud i mà Éliasar, na Éliasar i mà Matan, na Matan i mà Dyékob. ");
INSERT INTO bpr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na Dyékob i mà Dyosip, i yaan Méri, dunan i yê Dyisas, i dnagit Krayst. ");
INSERT INTO bpr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yé duenam man, yé kdee kastugad i to mdà di ku Abraham kel di ku Harì Dabid dunan sfalò fat. Na mdà di ku Harì Dabid kel di kgebe i dad to Israél salu ditù di Babilon, yé kdee kastugad i to lê sfalò fat. Na mdà di kgebe i dad to Israél salu di Babilon kel di ksut Dyisas Krayst, lê sfalò fat i kdee kastugad. ");
INSERT INTO bpr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ani santulen gablà di ksut Dyisas Krayst. Mdà i yêan, Méri, nun yaan ton, yé dagitan Dyosip. Bay di lamla là swè, gadèan ta maltien kenen fagu di Mtiu Tulus Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na Dyosip i satu to too tluh, bay là mayèan ku fyàan Méri di kanfe i kdee dad to, taman, yé fandaman là fanlesan dun di landè dademe to gmadè. ");
INSERT INTO bpr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bay di lam Dyosip famdam ani, nun satu kasaligan i Dwata msut di kenen fagu di kna, manan, “E Dyosip, bel Harì Dabid, nang ge likò msong ku Méri du i ngà lantienan mdà di Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mngà kenen lagi, na yé dagitam dun Dyisas, du falwàan i dad ton di dad salàla.” ");
INSERT INTO bpr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na mgimò i kdee ayé du fye gdohò i ta gman Dwata di munan fagu di satu tugadan, manan, ");
INSERT INTO bpr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tadè maltien i satu sawang libun, na mngà kenen lagi, na yé katlola kenen Imanyuél.” Na yé gumtatek Imanyuél dunan, “Ta dini Dwata sagin di gito.” ");
INSERT INTO bpr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kanto mukat Dyosip, ta nimenan i flau i kasaligan Dwata di kenen na nsongan Méri. ");
INSERT INTO bpr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bay silang sgafat i lawehla ta fnge sut i ngà Méri. Na kanto sut i ngà ayé, yé dagit Dyosip dun Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na sut Dyisas ditù di Bétléhém, i satu lunsud glam di Dyudiya di dad du i kagot Harì Hérod. Na kanto kenen sut, nun dad to salu ditù di Dyérusalém mdà di gusut i du fulung meye dad blatik. ");
INSERT INTO bpr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na kanto ale kel di Dyérusalém, smalek ale, manla, “Nè gumnè i ngà sut, i mgimò Harì i dad Dyu? Ta teenmi i blatik di gusut i du ilè i ta ksutan. Na yé duenmi salu dini du mangamfù gami di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na kanto linge Harì Hérod ani, too msamuk i nawan, na balù i kdee dademe dad to di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na fastifun Harì Hérod i kdee dad ganlal di kafaglut i dad Dyu, na lê man i dad to gal tamdò dad uldin Dwata fagu di ku Mosis du snalekan ale, manan, “Nè gusut i Mgalék Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na tmimel ale, manla, “Ditù di Bétléhém glam di Dyudiya, du ani man i tugad Dwata di sulatan di munan, ");
INSERT INTO bpr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ge, Bétléhém, glam di banwe Dyuda, ise ku ge i too mdanà di kdee dad banwe nagot i dad ganlal di Dyuda du too nun btasam, du mdà di ge i satu ulu, na kenen malak i dad togu, dunan Israél.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na fatlo Harì Hérod i dad to too fulung ayé di landè to gmadè dun, du snalekan ale ku kilen kitela i blatik. ");
INSERT INTO bpr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na dekan ale salu ditù di Bétléhém, na manan dale, “Mdà gamu, na tooyu fanngabal i ngà ayé. Na ku ta teenyu, fgadèyu di do i gusablàan du fye lê agu do gatù mangamfù di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na kantola linge i man Harì Hérod, ta mdà ale. Na i blatik ta teenla di gusut i du, magu gsen munala, na silang fanak di sablà gumnè i ngà. ");
INSERT INTO bpr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na di kitela i blatik ayé, too ale lehew. ");
INSERT INTO bpr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na kanto ale kel di gumnè ayé, teenla i ngà di saféd i yêan Méri, na lkuad ale mangamfù di kenen. Na nukalla i dad mabtas nebela du bléla di ngà ayé. Yé bléla dun blawen, na dad fangbun dnagit insénso, na mira. ");
INSERT INTO bpr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na kafnge ayé, mulê ale di banwela, bay ta mahal i dalanla du ta fgadè Dwata di dale fagu di kna nang ale samfulê di ku Harì Hérod. ");
INSERT INTO bpr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na kanto mdà i dad to fulung ayé, nun kasaligan i Dwata msut di ku Dyosip fagu di kna, manan, “Mték ge. Nebem i ngà na i yêan, na milah gamu ditù di banwe Idyip du fanngabal Hérod i ngà du kayèan fnati. Silang gamu mulê dini ku ta man-gu di gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na yé duenam man, mték Dyosip, na neben i ngà na yêan, na mdà ale milah di lam i kifuh salu ditù di Idyip. ");
INSERT INTO bpr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na déé gufanakla kel di kfati Hérod. Na fagu déé, gdohò i man Dwata fagu di tugadan di munan, “Tlogu i Ngàgu lamwà fdu di banwe Idyip.” ");
INSERT INTO bpr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na yé duenam man, kanto gadè Harì Hérod ta mafgaw kenen du mdà di nimò i dad to fulung meye dad blatik, too kenen malbut. Na fafatin i kdee dad ngà lagi mdà di dad ngà falami sut kel di dad ngà lwe fali i ktuala mnè di Bétléhém, na lê man di dademe banwe mdadong déé. Lalòan i man dad to fulung meye dad blatik du fye gadèan ku dét ta kalbong i ngà kayèan fafati. ");
INSERT INTO bpr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na mdà di kfati i kdee dad ngà ayé, ta gdohò i man Dwata di munan fagu di satu tugadan dnagit Dyérimaya, manan, ");
INSERT INTO bpr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nun mugak linge di banwe Rama du nun dad to too mngel na lmanu. Nngel Rakél i dad ngàan, na landè gamlala kenen du ta mati ale.” ");
INSERT INTO bpr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kanto mati Hérod, nun kasaligan i Dwata msut di ku Dyosip déé di Idyip fagu di kna, ");
INSERT INTO bpr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na manan, “Mték ge, nebem i ngà na i yêan, na mulê gamu ditù di banwe Israél du ta mati i dad to mayè fmati i ngà ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na yé duenam man, mték Dyosip, na neben i ngà na yêan, na mulê ale ditù di Israél. ");
INSERT INTO bpr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bay linge Dyosip ta yé tamlas ku Harì Hérod di kagotan di Dyudiya dunan i ngàan Arkilas, na yé duenam man, likò kenen mnè ditù di Dyudiya. Na mdà di kaflau Dwata kenen fagu di kna, baling ale salu ditù di banwe Galili. ");
INSERT INTO bpr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na yé banwe balingla gumnè di Galili dunan i lunsud Nasarét. Na fagu déé, gdohò i man Dwata fagu di dad tugadan di munan, “Yé katlola kenen to Nasarét.” ");
INSERT INTO bpr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na di dad du atù, nun to gatù di Dyudiya di banwe landè to mnè ditù, yé dagitan Dyan. Tdòan i dad to salu di kenen, ");
INSERT INTO bpr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","na manan, “Nsalyu na tnagakyu i dad salàyu, du ta mdadong i Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na Dyan ayé i ta man Dwata fagu di ku Isaya, i satu tugadan di munan, “Nun to tamlo di banwe landè to mnè ditù, ani manan fagu di fléd, ‘Fatlagadyu i dalan i Amu, na tanluhyu i gumagun.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yé gal lsak Dyan bul i lmanaf kamél, na yé galingan kulit lmanaf. Na yé knaanan tlangas na tnab. ");
INSERT INTO bpr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na nun dad to salu déé di gutamdò Dyan mdà di Dyérusalém na di kabal probinsya Dyudiya, na balù kel di kdee dad banwe mdadong di Éél Dyordan. ");
INSERT INTO bpr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na kanto ale kel déé, tulenla i dad salàla, na fbunyag ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bay nun dee dad to mdà di lwe kafaglut i dad Dyu, dunan i dad Farisi na dad Sadusi, na fdadong ale ditù du mayè ale fbunyag di kenen. Na di kiten dale, manan, “Gamu dad ulad. Simto man dun di gamu na galwà gamu di flayam fan kel febe Dwata ku lo gamu fbunyag? ");
INSERT INTO bpr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ku ta msal gamu di dad salàyu, fiteyu i ta ksalyu fagu di dad fye nimòyu. ");
INSERT INTO bpr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na nangyu fdatah i ktoyu di kmanyu dun, ‘Gami bel Abraham, na balù là msal gami, là gagin gami di flayam febe Dwata.’ Ani man-gu di gamu, balù fa i dad batu ani, gagan Dwata fambaling dale bel Abraham ku kayèan tamlas gamu. ");
INSERT INTO bpr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ku fkahta di to mbek kayu, ta déé i balyung di foon i kayu. Na kat satu kayu là menge fye, nbekan na snakufan di lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bnunyagta gamu di éél du ilè i ta ksalyu, bay nun tmadol di do. Là gablà agu kmitin talumfàan du too agu mdanà di kenen. Kenen i munyag gamu di Mtiu Tulus na di lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na fakayta man ta sanan nagot i taaf du tmaaf. I fali ta magtaaf, busekan di folan, bay i kdee dad afa, snakufan di lifoh landè sen.” ");
INSERT INTO bpr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na lê salu Dyisas di Éél Dyordan mdà di Galili du fye fbunyag ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bay fan là mayè Dyan munyag dun, na manan, “Gablà ge i munyag do. Kan ku baling ge fbunyag di do?” ");
INSERT INTO bpr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na tmimel Dyisas, manan, “Faloham i knayègu du fye gimenta i kdee knayè Dwata.” Na yé duenam man, ta mayè Dyan, na bnunyagan Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na kanto fbunyag Dyisas, di kalwàan di lam éél, tadè mgukà i langit, na teenan i Tulus Dwata tufa na mdaf di kenen gambet abun. ");
INSERT INTO bpr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na nun talù mdà di langit, manan, “Ani Ngàgu i toogu kando. Too fye nawagu dun.” ");
INSERT INTO bpr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na kafnge ayé, nebe i Mtiu Tulus Dyisas salu di banwe landè to mnè ditù du tnilew Satanas kenen. ");
INSERT INTO bpr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na fat falò du na fat falò butang là kmaan Dyisas, taman ta bitil kenen. ");
INSERT INTO bpr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na kafnge ayé, salu Satanas di kenen du tnilewan, manan dun, “Ku ge Ngà i Dwata, fagu di talùam, fanbalingam fan i dad batu ani.” ");
INSERT INTO bpr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bay tmimel Dyisas, manan, “Ta gsulat di Tnalù i Dwata, ‘Ise ku lo knaan gamlawil i dad to, bay lê man i tnalù Dwata.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na kafnge ayé, lê nebe Satanas kenen salu di Dyérusalém, na ftadagan kenen di sangal tah ataf i Bong Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na manan di kenen, “Ku ge i Ngà Dwata, kamyaf ge mdà dini, du ta gsulat sa di Tnalù Dwata, ‘Dek Dwata i dad kasaliganan mifat ge, du snamalla ge fye là gtadè i blìam di dad batu, na landè glumfakam.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bay tmimel Dyisas, manan, “Ta lê gsulat sa di Tnalù Dwata, manan, ‘Nangam tnilew i Amu, dunan i Dwatam.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na lê nebe Satanas kenen di satu bulul too mdatah, na fiten dun i kdee dad banwe nagot i dad to di tah tanà, na i bong kafyela. ");
INSERT INTO bpr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na manan di ku Dyisas, “Blégu di ge i kdee ani syan ku lkuad ge, na mangamfù ge di do.” ");
INSERT INTO bpr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bay tmimel Dyisas, manan, “Nang ge dini, Satanas! Du ta lê gsulat sa di Tnalù i Dwata, manan, ‘Mangamfù ge di Amu, dunan i Dwatam, na lo kenen i nimenam.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na kafnge ayé, tnagak Satanas Dyisas, na nun dad kasaligan Dwata kel du nifatla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Di là mlo, fablanggùla Dyan. Na kanto gadè Dyisas, samfulê kenen di Galili. ");
INSERT INTO bpr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na ta là mnèan di Nasarét, bay ditù gumnèan di lunsud Kapernaum di kilil i bong lanaw Galili mdadong di Sibulun na Néftali. ");
INSERT INTO bpr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na fagu déé gdohò i man Dwata fagu di ku Isaya di munan, ");
INSERT INTO bpr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Déé di Sibulun na Néftali, yé gumnè i dad to ise Dyu mdadong di bong lanaw Galili ditù di faltù Dyordan. ");
INSERT INTO bpr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na i dad to ayé, balù ku tagnè ale mnè di gukmifuhan, teenla i bong lwa. Na balù ku mlo ale mnè di kakifuh i fati, ta gafat di dale i neng salò.” ");
INSERT INTO bpr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na mdà di du ayé, tambù Dyisas tamdò, manan, “Msal gamu du ta mdadong i Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Di satu du, magu Dyisas di kilil i bong lanaw Galili, na nun teenan lwe lagi saflanek. Yé dagit i satu Simon Piter, na i flanekan Andru. Na yé nimòla fmukat ale du yé knalamla nimò. ");
INSERT INTO bpr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na man Dyisas di dale, “Yé galyu nimò ani fmukat nalaf. Fye fa ku baling gamu magin di do du tdòta gamu fmukat dad to du fye magin ale di do.” ");
INSERT INTO bpr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na di kman Dyisas ayé, tadèla tnagak i dad fukatla, na magin ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na kanto ale fles magu, lê nun teen Dyisas lwe lagi saflanek. Yé dagitla Dyém na Dyan, i dad ngà Sébidi. Na yé gusudengla di aweng magin di màla du fatlagadla dad fukatla. Lê tlo Dyisas ale, ");
INSERT INTO bpr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na tadèla tnagak i aweng na i màla du magin ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na lanngab Dyisas i probinsya Galili du tamdò di dad gumnè gal gustifun i dad Dyu. Yé tdòan i Fye Tulen gablà di Kagot i Dwata na fan-gulêan i kdee dad to nun sahal tduk. ");
INSERT INTO bpr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na mbel i santulen gablà di kenen di kabal i probinsya Sirya. Na yé duenam man, nebela di kenen i kdee dad to nun sahal tduk, na i dad to maflayam du mdà di sasè katduk, na i dad nun busaw, na i dad banlak, na i dad to là galyak i lawehla, na fan-gulê Dyisas ale. ");
INSERT INTO bpr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na too dee dad to magin di ku Dyisas mdà di dad sahal banwe. Nun mdà di Galili, na Dikapolis, na Dyérusalém, na Dyudiya, na lê man dademe dad banwe di faltù i Éél Dyordan. ");
INSERT INTO bpr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na kanto teen Dyisas i kdee dad to, mnagad kenen di satu bulul, na sudeng déé. Na stifun di safédan i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na tambù kenen tamdò di dale, manan, ");
INSERT INTO bpr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nun kafye i dad to dmilè i ktola na landè dale gnagan lmalò di Dwata, du gagin ale di Kagotan ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nun kafye i dad to mlidù nawa du lnala Dwata ale. ");
INSERT INTO bpr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nun kafye i dad to fdanà i ktola, du gdawatla i ta fakang Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nun kafye i dad to bitil na malinum di katluh Dwata, du fabsol Dwata ale. ");
INSERT INTO bpr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nun kafye i dad to kamdo i dademe to du lê ale man kando. ");
INSERT INTO bpr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nun kafye i dad to tluh i nawala, du site ale i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nun kafye i dad to samfye i dademe to, du matlo ale dad ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nun kafye i dad to falnayam mdà di tluh nimòla, du gagin ale di Kagot i Dwata ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nun kafyeyu ku baling nadoy dad to gamu, na falnayamla gamu, na dnalamla gamu di kdee dad sasè nimò du mdà di ksasatuyu di do. ");
INSERT INTO bpr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Du yé nimòla di dad tugad Dwata di munan. Yé duenam man, too gamu flehew du bong lubayyu ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Di kagbolyu di dad to di tah tanà, salngad gamu kahì. Bay i kahì, ku ta là mahìan, ta landè kibò lê fahì dun. Yé duenam man, fakay bat na glék i dad to. ");
INSERT INTO bpr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Na di kagbolyu di dad to di tah tanà ani, lê gamu salngad salò. Ku nun syudad di tah bulul, là ti gbunin. ");
INSERT INTO bpr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na ku nun to mtam salò, là sa snukuban dun been. Bay kahan di gumefen du fye mite i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na yé duenam man, tooyu fneng i salòyu di bleng i dad to, du fye teenla i dad fye nimòyu na dnayenla i Màyu ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nangyu fandam ku yé duen-gu salu dini di tah tanà ku falmogu i dad uldin Dwata fagu di ku Mosis na dad tugadan di munan. Là sa falmogu dun, bay fitegu i glut kfagu mimen dun. ");
INSERT INTO bpr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na too glut i man-gu di gamu ani, di laman nun tanà na langit, landè ti lnius di dad uldin Dwata, balù tukay, du mti gdohò i kalbong kdee. ");
INSERT INTO bpr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na ku simto lmafà i satu uldin Dwata, balù ku too tukay, na ku lêan tdò i dademe lmafà dun, too kenen mdanà di Kagot i Dwata ditù di langit. Bay ku simto mimen i kdee dad uldin Dwata na ku lêan tdò i dademe mimen dun, too kenen mdatah di Kagot i Dwata ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na ani man-gu di gamu, silang gamu gfusuk di Kagot Dwata ditù di langit ku midul fa i gamu katluh di katluh i dad Farisi na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ta lingeyu sa i man Dwata di dad to di munan, ‘Nang ge manò. Ku simto manò, là fakay ku là falnayam kenen.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bay ani i man-gu di gamu. Ku simto falbut di dademe to, gablà kenen falnayam. Na ku simto talù di dademe, na manan, ‘Snawang ge,’ gablà kenen nukum i dad ganlal. Na ku simto talù di dademe to, na manan, ‘Kaldam ge lmanaf,’ gablà kenen falnayam Dwata ditù di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Na yé duenam man, ku gatù ge di gudamsù du nun blém di Dwata, bay nun gafaldamam salàam di dademe to, ");
INSERT INTO bpr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tnagakam déé funa i blém ayé. Gatù ge di to ayé na safye gamu klom samfulê na blém i dsùam di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na ku nun to fan tmifù ge di ganlal, fye ku mlal gamu safye. Yé fye, stulen gamu di lamyu là fa gafat di gusukum tàan ge blé di to mukum, na i to mukum, faflesan ge di pulis, na i pulis tmusuk ge di blanggù. ");
INSERT INTO bpr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na too glut i man-gu di gamu ani, ku ta yé mkel di ge, silang ge galwà di blanggù ku ta fngem bnayad i salàam. ");
INSERT INTO bpr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ta lingeyu sa i man Dwata di dad to di munan, ‘Nang ge lmafà yaan.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bay ani i man-gu di gamu. Ku simto meye di satu libun na nibalan, salngad kenen lmafà yaan di fandaman. ");
INSERT INTO bpr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na kaflingenta dun, ku i matam gsen di kwanan mebe ge di kagsalà, yé baling fye ku tanwilam na batam. Tumù fa ku lanah i satu alel di laweham na nun nawam landè sen, bay too ti sasè ku sikof i laweham, na baling ditù gugtadèam di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na kaflingenta dun, ku i sigalam gsen di kwanan mebe ge di kagsalà, yé baling fye ku kanlangam na batam. Tumù fa ku lanah i satu alel di laweham na nun nawam landè sen, bay too sasè ku sikof i laweham, na baling ditù gugtadèam di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ta lingeyu sa i galla flau, ‘Ku nè i lagi mkah yaanan, là fakay ku là blén di kenen i kalatas gugsulat gugmadè dun ta kahan.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bay ani i man-gu di gamu, ku nun lagi, kahan i yaanan, na là lmen i libun lmafà dun, gamsalà i lagi ayé di Dwata. Yé duenan gamsalà du ku lê nun lagi mwè i libun ayé yaan, ta glafà i libun ayé i muna yaanan du mdà di kakahan dun. Na i lagi mwè i libun ayé, lê kenen gamsalà. ");
INSERT INTO bpr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ta lingeyu sa i galla flau, ‘Ku samdagè ge, toom dnohò i ta gmanam di Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bay ani i man-gu di gamu, nang gamu samdagè. Là fakay ku yé dnagityu i langit di kasdagèyu, du déé gusudeng Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Là fakay ku yé dnagityu i tanà di kasdagèyu, du déé gumlékan. Na là fakay ku yé dnagityu Dyérusalém di kasdagèyu, du yé syudad Dwata, dunan i too mdatah Harì. ");
INSERT INTO bpr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na là fakay ku yé dnagityu i uluyu di kasdagèyu, du là ti gaganyu fafitam ku demen fbukay i wakyu. ");
INSERT INTO bpr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bay ku mayè gamu, yé manyu, ‘Hee,’ na ku là, yé manyu, ‘Là,’ du ku samdagè gamu, yé gumdà i tnùyu ayé di ku Satanas. ");
INSERT INTO bpr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ta lingeyu sa i galla flau, ‘I to fatduk mata i dademe to, lê fatduk i kenen mata. Na i to falmo kifan i dademe to, lê falmo i kenen kifan.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bay ani i man-gu di gamu, nang gamu malas sasè di to mimò sasè di gamu. Bay ku nun dmafì di bali bawehyu, lêyu fdafì i balin. ");
INSERT INTO bpr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ku nun to mebe gamu di kasfala du fye gwèan i saulyu fukal sigal, lêyu fagin blé i saulyu tahà sigal. ");
INSERT INTO bpr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ku nun to fmeges gamu mebe i kalyakan satu kilumitru i kawagan, nebeyu dun lwe kilumitru. ");
INSERT INTO bpr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ku nun to mni di gamu, banléyu kenen. Na fandemyu i to mayè mdem di gamu. ");
INSERT INTO bpr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ta lingeyu sa i galla flau, ‘Kandoyu i dademeyu sgalak, na knangyu nawa i to mnang gamu nawa.’ ");
INSERT INTO bpr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bay ani i man-gu di gamu, kandoyu i dad to mnang gamu nawa, na dnasalyu i dad to falmayam gamu. ");
INSERT INTO bpr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ku yé nimòyu, too dilè na ngà gamu i Dwata di langit. Du i Dwata, fnengan i du na fulenan di dad to tluh na lê di dad to sasè. ");
INSERT INTO bpr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kaflingenta dun, ku lo yé kandoyu i dad to kamdo gamu, landè lubayyu di nimòyu ayé, du balù i dad to too gamsalà gambet i dad to mwè bayad i buhis, yé kandola i dad to kamdo dale. ");
INSERT INTO bpr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na ku lo yé dademeyu stulen i to dademeyu sgalak, landè sa gusahalan di nimò i dad to too gamsalà, du balù i dad to là gmadè i Dwata, stulen ale sa di dademela sgalak. ");
INSERT INTO bpr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yé duenam man, too gamu fatluh du i Màyu ditù di langit too tluh.” ");
INSERT INTO bpr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na fadlug Dyisas tamdò, manan, “Ku mimò gamu i dad nimò i dad to ftoo, là fakay ku yé duenyu mimò ayé du loyu fite di dad to, du ku yé duenan, landè lubay gdawatyu mdà di Màyu di tah langit. ");
INSERT INTO bpr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Yé duenam man, ku tnabengyu i dad to landè knun, nangyu dag salngad i nimò dad to fagdag di kabléla di dad gumnè gal gustifun i dad to, na di kilil dalan. Lo yé duenla mimò dun du fye dag i dad to ale. Bay too glut i man-gu di gamu ani, ta gdawatla i kdee lubayla. ");
INSERT INTO bpr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bay gamu, ku tnabengyu i dad to landè knun, nangyu fgadè di dademe to, balù di dademeyu sgalak, ");
INSERT INTO bpr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","du fye gbuni i kabléyu. Na ku yé nimòyu, banlé Màyu gamu lubay du teenan i kdee nimòyu di gugbunin. ");
INSERT INTO bpr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ku dmasal gamu, nangyu ganbet i dad to flingu, du ku dmasal ale, too ale mayè tadag di dad gumnè gal gustifun i dad to, na di kilil dalan du dee dad to mite dale. Na too glut i man-gu di gamu ani, ta gdawatla i kdee lubayla. ");
INSERT INTO bpr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bay ku dmasal gamu, fusuk gamu di snifilyu, na tnakabyu, na dmasal gamu di Màyu Dwata i là teen. Na fagu déé, yé mite i nimòyu di gugbunin i Màyu, na banlén gamu lubay. ");
INSERT INTO bpr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na ku dmasal gamu, nangyu too fdee dad talùyu gambet i dad to dmasal di ise glut dwata, du yé man nawala ku fdeela i dad talùla, toon ale falninge. ");
INSERT INTO bpr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nangyu ale ganbet du ta sana gadè Màyu i kalnidùyu balù di lamyu là fa mni di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bay gambet ani i fye kdasalyu, ‘Màmi di tah i langit, kayèmi moon ku mangamfù di ge i kdee. ");
INSERT INTO bpr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na kayèmi ku ge magot i kdee, na ku gdohò i kdee knayèam dini di tah tanà salngad i kagdohòan déé di tah langit. ");
INSERT INTO bpr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Blém di gami i gablà knaanmi di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fnasinsyam i dad salàmi, salngad i kfasinsyami salà i dad to gamsalà di gami. ");
INSERT INTO bpr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nangam faloh di gami i dad tilew gamgebe gami di salà, bay kanlungam gami di ku Satanas, gumdà i kdee sasè.’ ");
INSERT INTO bpr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ku fnasinsyayu salà i dad to ta gamsalà di gamu, lê fnasinsya Màyu di langit i gamu salà. ");
INSERT INTO bpr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bay ku là fnasinsyayu salà i dad to ta gamsalà di gamu, là lê fnasinsya Màyu i gamu salà. ");
INSERT INTO bpr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Na ku fwasa gamu, nangyu flidù i bawehyu gambet i dad to flingu, du yé nimòla fdilèla di bawehla na bitil ale du fye dilè i dad to ta fwasa ale. Bay too glut i man-gu di gamu ani, ta gdawatla i kdee lubayla. ");
INSERT INTO bpr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bay ku fwasa ge, samwat ge na flauf ge, ");
INSERT INTO bpr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","du fye là dilè i dad to i kafwasam. Na ku yé nimòam, lo yé gmadè i kafwasam i Màam dunan Dwata là teen. Na yé duenam man, banlén ge lubay du teenan i kdee dad nimòam di gugbunin. ");
INSERT INTO bpr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nang gamu samtifun knun dini di tah tanà, du falmo i kanok na tnéé na tnaku i dad to. ");
INSERT INTO bpr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bay yé fye gusamtifunyu knun ditù di tah langit du ditù landè kanok falmo dun, na là tnéén, na landè to gfusuk ku tmaku dun. ");
INSERT INTO bpr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yé fye nimòyu du ku nè gusamtifunyu i knunyu, yé gal gumnè i fandamyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","I matam, yé gambet salò di laweham. Ku mtiu i keyem, fakayta man na langub lwa i kabal laweham. ");
INSERT INTO bpr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bay ku sasè i keyem, fakayta man na langub kmifuh i kabal laweham. Yé duenam man, ku ta kmifuh i salò mnè di nawam, ta too ti sasè kakifuhan. ");
INSERT INTO bpr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Landè kibò fafasak di lwe amu, du magfeges kenen malék ku simto di dale i nutehan nawa na i kanbongan nawa, satu di dale nimenan na satu i dnuenan. Landè kibòyu fafasak di Dwata, na lê man di knun. ");
INSERT INTO bpr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yé duenam man, ani man-gu di gamu, nang gamu mlidù gablà di knèyu dini di tah tanà na i knaanyu na i ninumyu dini. Na nang gamu mlidù gablà di lawehyu na di klaweh lsakyu. Du ku fandamyu dad kalnidùyu di knèyu di tah tanà, nun sa too mabtas fa di knaan. Na ku fandamyu i kdee dad kalnidùyu di laweh, nun sa too mabtas fa di klaweh lsakyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fandamyu dad anuk mayeng. Là sa mlah ale, na là kamtu ale, na landè fol galla gusamtifun i ulê dad flahla. Bay yé famkaan dale dunan i Màyu di langit. Na gamu too mabtas fa di dad anuk. ");
INSERT INTO bpr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Là ti gaganyu tmugad i lawilyu di tah tanà ani, balù lo sudaf klon fagu di kafdamyu i dad kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na nang gamu mlidù gablà di dad klawehyu. Fandamyu dad bulek tmabò di lam bnas. Là talbahò ale, na là mimò ale falnas fye nun klawehla. ");
INSERT INTO bpr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bay ani man-gu di gamu, balù Harì Solomon di kafye knèan, landè klawehan salngad di kafye baweh i satu bulek. ");
INSERT INTO bpr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ani kagkah i bulek. Di mdu ani, too fye kbelan, bay fayah ta mlanas na fakay ntam. Na ku nifat Dwata dad bulek i là too mabtas, midul déé fa i kablén gamu klaweh. Tay, too kulang i ksaligyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Na yé duenam man, nang gamu mlidù gablà di knaanyu, ku demen i ninumyu, na i klawehyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Du i dad to là ftoo di Dwata, yé sén i fandamla dale, bay ta sana gadè i Màyu na yé kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bay ani fye nimòyu. Funayu fnè di nawayu i Kagot Dwata na i katluhan, na blén di gamu i kdee kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Na yé duenam man, nang gamu flidù gablà di du fayah, du dee i dad klidùyu di mdu ani. Silangyu fandam i dad klidùyu ku ta kel.” ");
INSERT INTO bpr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na fadlug Dyisas tamdò, manan, “Nangyu nukum i dademe to du fye là nukum Dwata gamu. ");
INSERT INTO bpr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ku dét ukumyu di dademe to, yé lê ukum Dwata gamu. Na ku dét kablat ukumyu i dademe dad to, yé lê kablat i ukum Dwata gamu. ");
INSERT INTO bpr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kan ku neyem i fuling di mata i flanekam, bay tadèam bayà i bateng di ge mata? ");
INSERT INTO bpr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kan dé ku manam, ‘E, nwèta kun i fulingam,’ na blaam sana kdéé i bong bateng di ge mata? ");
INSERT INTO bpr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sasè ge. Funam nwè i bateng di matam alì too fye kitem mwè fuling i flanekam. ");
INSERT INTO bpr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nangyu blé di dad ayem i dad mtiu knun nfun Dwata, du keng balingla gamu nakét. Na nangyu blé di dad sdè i dad mabtas slah dnagit pérlas, du keng balingla sanslék. ");
INSERT INTO bpr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mni gamu di Dwata na banlén gamu. Mngabal gamu na fiten gamu i fanngabalyu. Mbal gamu fusuk na nukàan di gamu i takab. ");
INSERT INTO bpr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ku simto mni di Dwata, gamdawat kenen. Na ku simto mngabal, fite Dwata di kenen i fanngabalan. Na ku simto mbal fusuk, nukà Dwata dun i takab. ");
INSERT INTO bpr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gamu dad lagi nun ngà, ku mni i ngàyu fan, ise ku yé bléyu di kenen batu. ");
INSERT INTO bpr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na ku mni kenen nalaf, ise ku yé bléyu di kenen ulad. ");
INSERT INTO bpr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na balù ku sasè gamu, knèan fulung gamu mlé fye di dad ngàyu. Na mdà ayé, midul fa déé kfulung i Màyu di langit mlé kafye di dad to mni di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ku dét i kayèyu fye nimò i dademe dad to di gamu, yé funayu nimò di dale, du yé gumtatek i gsulat di uldin Dwata fagu di ku Mosis na i dademe dad tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tooyu fdà di nawayu magu fusuk di tukay takab du mabal i gufusuk na mlahil i dalan salu di lanaw lifoh, na dee dad to i magu déé. ");
INSERT INTO bpr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bay du tukay i gufusuk na mlimah i dalan salu di nawa landè sen, na là dee dad to magu déé. ");
INSERT INTO bpr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Too gamu fgeye du nun dad to flingu tmulen i Tnalù Dwata. Gambet ale i mnalam agaf dnagit bilibili, bay yé too glut kagkahla, salngad ale i dad tuyun. ");
INSERT INTO bpr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ku fkahta di kayu, yé gudmilè i kayu di bengen. I awi, là ti mengen grép, na i banal, là ti mengen fig. ");
INSERT INTO bpr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na salngad ayé, i fye kayu menge fye, na i sasè kayu lê menge sasè. ");
INSERT INTO bpr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I kayu fye, là mengen sasè. Na i sasè kayu, là mengen fye. ");
INSERT INTO bpr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na kat satu kayu là menge fye, fakay nbek na bat di lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yé duenam man, yé gudmilè i dad to flingu di dad nimòla. ");
INSERT INTO bpr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Là ti sdulê gfusuk di Kagot Dwata di langit i kdee dad to tamlo do ‘Amu,’ bay lo yé gfusuk i dad to mimò knayè Màgu di langit. ");
INSERT INTO bpr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na ku ta kel i du Dwata mukum, bong dee dad to fakdo, manla di do, ‘E Amu, ta tdòmi i Tnalù Dwata fagu di dagitam, na ta falwàmi dad busaw, na ta gamgimò gami dad tnikeng.’ ");
INSERT INTO bpr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bay yé man-gu di dale, ‘Là ti dilèta gamu. Fawag gamu di do, gamu dad to gamsalà.’ ");
INSERT INTO bpr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Yé duenam man, i kdee dad to lminge i dad man-gu ani na ku nimenla, salngad ale di to too fulung fdak gumnè du yé gufdakan dun di tah batu. ");
INSERT INTO bpr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na kanto fnge i gumnè, nun kel bong ulen na ta dmunuk, na too kamgis i nus sloban i gumnè ani. Bay là ti bekan du yé gugafdakan di tah batu. ");
INSERT INTO bpr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bay i kdee dad to lminge i dad man-gu ani na ku là nimenla dun, salngad ale di satu to snawang du yé gufdakan dun di falak. ");
INSERT INTO bpr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na kanto fnge i gumnè, nun kel ulen, na ta dmunuk, na too kamgis i nus sloban i gumnè ani. Na ta bek i gumnè na mti malbà.” ");
INSERT INTO bpr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na kafnge Dyisas man ayé, too tikeng i dad to di katdòan ");
INSERT INTO bpr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","du ku tamdò, too dilè i kaltulusan, na là salngadan di dad to gal tamdò i uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na kanto flasok Dyisas di bulul gutamdòan, na too dee dad to magin di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na nun satu lagi nun fdas mumuh salu di kenen, na lkuad di munan, manan, “Amu, gadègu gaganam agu fan-gulê ku beg ge mayè du fye too mlaneb i kulitgu.” ");
INSERT INTO bpr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na nagot Dyisas kenen, na manan, “Mayè agu sa. Mgulê ge nan.” Na tadè mkah i fdasan mumuh ayé. ");
INSERT INTO bpr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na fnge, dek Dyisas kenen, manan, “Nangam ti tulen ani balù simto dun. Bay mdà ge, na fitem i laweham di ganlal di kafaglut gal damsù, na nebem ditù i dsùam gambet i dek Dwata di dad sulat Mosis. I dsù nebem, yé gugmadè i kdee dad to dun na ta mgulê ge na ta mlaneb i kulitam.” ");
INSERT INTO bpr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na salu Dyisas di Kapernaum. Na kanto kel déé, nun satu ganlal i dad sundalu mdà di Roma samsite di ku Dyisas du mni tabeng di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Na manan, “E Amu, là gték i fasakgu ditù di gumnè du là galyakan i lawehan, na too sasè kaflayaman.” ");
INSERT INTO bpr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na man Dyisas di kenen, “Salu agu déé du fan-gulêgu.” ");
INSERT INTO bpr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bay man i ganlal ayé, “E Amu, là gablà agu fafusuk ge di gumnègu. Bay lo ge talù, na fagu di talùam mgulê sa i fasakgu. ");
INSERT INTO bpr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gadègu ani, du balù do, nun ganlal mdatah di do, na lê nun dad sundalugu mdanà di do. Ku dekgu i sundalugu magu, mdà sa kenen. Na ku man-gu di satu, ‘Gadini ge,’ na mimen sa kenen. Na balù dét fimògu di satu, yé nimòan.” ");
INSERT INTO bpr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na kanto linge Dyisas i manan ayé, too kenen tikeng, na manan di kdee dad to magin di kenen, “Too glut i man-gu di gamu ani, là lmen-gu mite di dad to Israél i kaftoo salngad di bong kaftoo i to ani di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na ani manta gamu, kadang di fulé du, nun dee dad to ise Dyu kel mdà di klamang banwe, mdà di gusut i du na di gusdafan, na kmaan ale di saféd Abraham, na Isaak, na Dyékob di Kagot Dwata di langit. ");
INSERT INTO bpr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","I dad Dyu moon i mnè di langit, bay baling bat Dwata ale di lwà di gukmifuhan, na déé gumngella na gukminggat i kifanla.” ");
INSERT INTO bpr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na kafnge ayé, lê talù Dyisas di ganlal i dad sundalu ayé, manan di kenen, “Mulê ge, du mgimò sa i ta fantoom ayé.” Na gdohò i man Dyisas du salngan di kmanan dun, tadè mgulê fasak i ganlal. ");
INSERT INTO bpr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na salu Dyisas di gumnè Piter. Kanto fusuk déé, teenan i tewe Piter libun. Milè kenen du too ti minit i lawehan. ");
INSERT INTO bpr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na fdadong Dyisas di kenen, na nagotan i sigalan. Na tadè mkah i kinitan, na mdà ayé, mték na fles mimò dale knaan. ");
INSERT INTO bpr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na di kasdaf i du, nun dee dad to nun busaw nebela di ku Dyisas. Falwàan i dad busaw fagu di talùan na fan-gulêan i kdee dad to nun dad sahal tduk. ");
INSERT INTO bpr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yé duenan mkel ayé du fye gdohò i man Dwata fagu di ku Isaya, “Fan-gulêan ato du nwèan i dad fdasto.” ");
INSERT INTO bpr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na di satu du, kanto teen Dyisas i kdee dad to stifun di safédan, yé manan di dad to galan tdò, “Mdà ato mifal di lanaw.” ");
INSERT INTO bpr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bay salu di kenen satu to gal tamdò dad uldin Dwata fagu di ku Mosis, na manan, “E Sér, magin agu di ge balù nè gusalum.” ");
INSERT INTO bpr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bay tmimel Dyisas, manan, “I dad balos, nun gumulêla, na i dad anuk mayeng, nun fulalla. Bay do, i dnagit Ngà To, landè gumnègu, balù gumilè, landèan.” ");
INSERT INTO bpr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na lê nun fa satu to di dad tdòan, manan ku Dyisas, “Amu, faloham agu mulê funa du lbanggu mà.” ");
INSERT INTO bpr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bay man Dyisas di kenen, “Bayàam i to mati. Yé lambang dun i dad to sawe mati. Bay ge, fles ge magin do.” ");
INSERT INTO bpr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na kafnge ayé, ta myak Dyisas di aweng, na magin dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na di lamla maweng, ta nkel ale too kamgis nus di talà, na ta nuléh lwek i awengla. Bay ta kudang Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na i dad to galan tdò, nukatla kenen, na manla, “E Amu, tnabengam gami! Ta fan ato mlimas!” ");
INSERT INTO bpr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na talù Dyisas, manan, “Kan ku likò gamu? Too tukay ksaligyu.” Na kafnge ayé, mték kenen, na nngakan i nus na dad lwek, na ta too mtanak i lanaw. ");
INSERT INTO bpr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Too tikeng i dad lagi ayé, na sasalek ale, manla, “Dét klasi to ani? Balù i nus na lê malbang lwek, nimenla.” ");
INSERT INTO bpr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kanto kel ale Dyisas di banwe Gadara ditù di faltù i lanaw, nun smitong dun lwe lagi nun busaw. Yé gumdàla di dad ilib gulambang i dad to. Too ale labè, taman, landè to gagu di dalan ayé. ");
INSERT INTO bpr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tadè ale mkit, manla, “E Ngà Dwata, dét i kibòam gami? Keng yé duenam salu dini du falnayamam gami balù là fa kel i bangmi maflayam.” ");
INSERT INTO bpr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na là too mawag déé, nun dee dad sdè mateb. ");
INSERT INTO bpr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na fakdo dad busaw, manla, “Ku falwàam gami, dekam gami fusuk di dad sdè.” ");
INSERT INTO bpr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na man Dyisas di dale, “Mdà gamu.” Taman lamwà i dad busaw di dad lagi ayé, na fles ale fusuk di dad sdè, na mti milah i dad sdè flasok di bilil, na tatek ale di lanaw, na sdulê ale mlimas. ");
INSERT INTO bpr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Milah i dad to mifat i dad sdè ayé salu di lunsud, na tulenla i kdee na i ta mkel di dad lagi nun busaw. ");
INSERT INTO bpr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na i kdee dad to mdà di lunsud ayé, salu ale ditù di ku Dyisas. Na kitela kenen, fakdo ale du fye tnagakan i banwela. ");
INSERT INTO bpr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Di satu du, lê smakay ale Dyisas di aweng, na nifalla i bong lanaw ayé, na salu ale di banwe gumdàan. ");
INSERT INTO bpr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na nun dad lagi kel déé, na nun nebela satu to là galyakan i lawehan, milè di igeman. Na kanto teen Dyisas i bong ksalig i dad to mebe dun, manan di to ayé, “E Tò, fan-galam i nawam. Ta magfasinsya nan dad salàam.” ");
INSERT INTO bpr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na nun dad to tamdò dad uldin Dwata fagu di ku Mosis déé. Na di kman Dyisas ayé, yé mnè di fandamla, “Ta nladan i kdatah Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Na gadè Dyisas i mnè di fandamla. Na yé duenam man, manan di dale, “Kan ku baling sasè i mnè di fandamyu? ");
INSERT INTO bpr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Man nawayu ku landè glalgu fmasinsya salà i to ani? Bay yé too ilè na nun glalgu ku ta man-gu di kenen, ‘Mték ge na magu ge,’ na gagu kenen. ");
INSERT INTO bpr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na yé kayègu ku gadèyu na do, dunan i dnagit Ngà To, nun glalgu dini di tah tanà fmasinsya salà.” Na kafnge Dyisas man ayé di dale, ta talù di to là galyak, na manan, “Mték ge, nwèam i gumilèam, na mulê ge.” ");
INSERT INTO bpr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na tadè tadag i to ayé na mulê. ");
INSERT INTO bpr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kanto teen i kdee dad to i nimò Dyisas ayé, too ale likò na dnayenla i Dwata du mdà di kablén gnagan salngad ani di satu to. ");
INSERT INTO bpr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na lê mdà ale Dyisas, na ligòla magu, nun teenan satu lagi, yé dagitan Matyu. Déé kenen di gutalbahò i dad to gal mwè bayad i buhis du yé sén i knalaman nimò. Na man Dyisas di kenen, “Magin ge do.” Na ta tadag Matyu, na fles magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na kmaan ale Dyisas di gumnè Matyu. Na di ligòla kmaan, lê nun kel déé dademe dad to gal mwè bayad i buhis na i dademe dad to gal lmafà i uldin Dwata, na kmaan ale di saféd Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na lê nun dad Farisi déé, na kantola teen ayé, snalekla i dad to gal tdò Dyisas, manla, “Kan ku kmaan i to tamdò gamu di saféd i dad to gal mwè bayad i buhis na i dademe dad to lmafà i uldin Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na linge Dyisas i manla ayé, na manan, “I to fandas, nun gukmamun i to mulung. Bay i to landè fdasan, landè gukmamun i to mulung. ");
INSERT INTO bpr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na tooyu fandam i gumtatek i man ani di Tnalù i Dwata, ‘Ise ku yé toogu knayè i kabléyu dad dsù, bay yé kayègu i kasakdoyu.’ Ise ku i dad to tluh i fanngabalgu, bay yé fanngabalgu i dad to gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na nun dad to gal tdò Dyan Gal Munyag, salu ale di ku Dyisas, na smalek ale, manla, “Kan ku là fwasa i dad to galam tdò? Bay gami na i dad Farisi, gal gami fwasa.” ");
INSERT INTO bpr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na tmimel Dyisas fagu di fléd, manan, “Ku fkahta di dad to nlak magin samsong, là mlidù ale ku sana kdéé di safédla i lagi sansong. Bay nun du kadang ku ta là dini di safédla i lagi sansong ani, na yé klola fwasa. ");
INSERT INTO bpr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Là fakay klafang i falami falnas di labi klaweh ta baltok du ku saksang i klafang ayé, na ta baling bong i kasêan. ");
INSERT INTO bpr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na là fakay kah di lam i labi kulit i falami binu, du keng btù i kulit na malmo i binu na lê man i kulit. Yé duenam man, yé gumkah i falami binu di falami kulit.” ");
INSERT INTO bpr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Di lam Dyisas talù, nun fdadong di kenen satu ulu di gumnè gal gustifun i dad Dyu. Na kanto kel déé, lkuad kenen di muna Dyisas, manan, “Falami mati i ngàgu libun. Beg ge magin do, na nagotam kenen du fye mték.” ");
INSERT INTO bpr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na tadag Dyisas du magin, na lê man dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na di kagula, nun satu libun déé ta sfalò lwe fali klon sigi maloh i litèan. Fdadong kenen di kagol Dyisas, na nagotan kilil i saulan, ");
INSERT INTO bpr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","du yé fandaman, “Ku logu gagot i saulan, mgulê agu.” ");
INSERT INTO bpr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na di kagotan i saul Dyisas, kmangél Dyisas, na manan dun, “Fan-galam i nawam. Ta mgulê ge du mdà di nun kaftoom di do.” Na di kman Dyisas ayé, tadè mgulê i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na kanto kel ale Dyisas di gumnè Dyairus, dunan i ulu di gumnè gal gustifun i dad Dyu, fusuk kenen, na teenan i dad to salmali gal magin di kalbang, na i dademe dad to mugak mdà di klidùla. ");
INSERT INTO bpr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na manan di dale, “Lamwà gamu. Là sa mati i ngà ani, bay lo kudang.” Na balingla kenen nadoy. ");
INSERT INTO bpr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kanto lamwà dad to, fles Dyisas fusuk di snifil gumilè i ngà ayé klon magot i sigalan, na tadè mték i ngà. ");
INSERT INTO bpr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na too mbel i santulen gablà di nimò Dyisas di kabal i banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Fles ale Dyisas magu mdà di banwe ayé. Na di kagula, nun lwe lagi butè tmadol ku Dyisas, manla, “E bel Dabid, begam gami kando.” ");
INSERT INTO bpr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na kanto fusuk ale Dyisas di satu gumnè, lê magin i lwe butè ayé. Na snalekan ale, manan, “Ftoo gamu kè na gaganta gamu fan-gulê?” Na tmimel ale, manla, “Hee, Amu.” ");
INSERT INTO bpr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na nagotan i dad matala, na manan, “Mgulê gamu du mdà di kaftooyu.” ");
INSERT INTO bpr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na mdà déé, ta mite ale. Bay too falnau Dyisas ale, manan, “Là fakay ku tulenyu ani di balù simto dun.” ");
INSERT INTO bpr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bay knèan, baling ale magu di kabal i banwe ayé du tulenla i ta mkel di dale. ");
INSERT INTO bpr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na di ta kdà i dad lagi ayé, lê nun dademe dad to kel du nun nebela di ku Dyisas satu lagi umu du mdà di knè i busaw di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na kafnge Dyisas falwà i busaw ayé, ta gtalù i to ayé. Na too tikeng i kdee dad to, na manla, “Landè fa lmento teen gambet ani di kabal i banwe Israél.” ");
INSERT INTO bpr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bay talù i dad Farisi, manla, “Yé mlé kenen glal falwà dad busaw dunan i gumdatah i dad busaw.” ");
INSERT INTO bpr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na magu Dyisas di kdee dad syudad na dad malnak banwe du tamdò kenen di dad gumnè galla gustifun. Yé tdòan i Fye Tulen gablà di Kagot Dwata, na fan-gulêan i kdee dad to di dad sahal tdukla. ");
INSERT INTO bpr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na kanton teen i kdee dad to, too sè kakdon dale du too ale maflayam na magakdo ale, na salngad ale i dad bilibili landè to mifat dale. ");
INSERT INTO bpr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na man Dyisas di dad to galan tdò, “Too mabal i kantu, bay kulang i dad to kamtu. ");
INSERT INTO bpr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yé duenam man, mni gamu di Amuto, dunan i mfun i tanà, du fye nun dademe dekan kamtu.” ");
INSERT INTO bpr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na tlo Dyisas di safédan i dad sfalò lwe to galan tdò, na banlén ale glal falwà dad busaw mnè di dad to, na famgulê i dad to nun sahal tduk. ");
INSERT INTO bpr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ani dagit i dad sfalò lwe to dekan. Yé tnaninan Simon, dunan i dnagit Piter, na i flanekan Andru, na Dyém na Dyan, dunan i dad ngà Sébidi, ");
INSERT INTO bpr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na lê Filip, na Bartolomyu, na Tomas, na Matyu, dunan i satu to gal mwè bayad i buhis, na Dyém, dunan i ngà Alfyus, na Tadyus, ");
INSERT INTO bpr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na lê Simon, dunan i msen i banwen, na Dyudas Iskariyot, dunan i baling makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na di kdek Dyisas i dad sfalò lwe to ayé, ani fngewen dale, manan, “Nang gamu salu di dad to ise Dyu na lê man di dad banwe glam di Samarya. ");
INSERT INTO bpr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bay yé gusaluyu di dademeyu Dyu, dunan i bel Israél du salngad ale di dad bilibili ta tlas. ");
INSERT INTO bpr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na di kaguyu, tamdò gamu, manyu, ‘Ta mdadong i Kagot Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Na ani i nimòyu, fan-gulêyu i dad to nun tduk, na ntékyu i dad to mati, na fan-gulêyu i dad to nun fdas mumuh du fye mlaneb i kulitla, na falwàyu i dad busaw. Du ta gamdawat gamu landè bayad, taman lê gamu mlé di landè bayad. ");
INSERT INTO bpr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na nang gamu mebe filak, i baling filak blawen, ku demen filak blawen bukay, ku demen filak tambaga. ");
INSERT INTO bpr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na di kaguyu, nang gamu mebe kuyut, ku demen tugad. Na lo yé nebeyu saul na talumfà i tagnè lsakyu, du i to talbahò, là fakay ku là banlé kenen lubay. ");
INSERT INTO bpr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na ku nè lunsud ku demen tukay banwe gugtadèyu, mngabal gamu to mgafè i mayè dmawat gamu, na déé gufanakyu kel di lêyu kdà. ");
INSERT INTO bpr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ku fusuk gamu di satu gumnè, manyu di mfun gumnè, ‘Mulà moon mnè di gamu i ktanak nawa.’ ");
INSERT INTO bpr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ku dnawatla gamu, mnè di dale i ktanak nawa nebeyu ayé. Bay ku là dnawatla gamu, mulê di gamu i fye manyu ayé. ");
INSERT INTO bpr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na ku là dnawatla gamu na là mayè ale flinge di tdòyu, di ktagakyu i banwe ku demen gumnè ayé, kakesyu i kfung di blìyu. ");
INSERT INTO bpr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na too glut i man-gu di gamu ani, di Du Kukum Dwata i dad to, ku maflayam i dad to di Sodom na Gomora, midul déé fa kaflayam i dad to di banwe ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Na lê talù Dyisas, manan, “Flinge gamu. Dekta gamu salu di dad labè to, du salngad gamu i dad bilibili gbol di dad tuyun. Taman, too gamu fafulung salngad i ulad, na fnunyu ldamyu salngad i abun. ");
INSERT INTO bpr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na too gamu fgeye du kanfèla gamu, na bléla gamu di dad to mukum, na nfasla gamu di lam i dad gumnè gal gustifun. ");
INSERT INTO bpr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na mdà di ksasatuyu di do, ftadagla gamu di muna i dad gubirnador na lê man i dad harì. Yé kadang i kdalanyu tmulen di dale na lê man di dad to ise Dyu gablà di dad nimò Dwata di gamu. ");
INSERT INTO bpr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bay ku kanfèla gamu, nang gamu mlidù ku dét i fye timelyu dale, ku demen i fye kibòyu man dun di dale, du di ktadagyu déé, blé Dwata di gamu i fye timelyu. ");
INSERT INTO bpr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Du ise ku mdà di gamu i dad timelyu, bay mdà di Tulus i Màyu Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Na di dad du ayé, nun dademe dad to, bléla di fati i dad flanekla na dad ngàla. Na i dademe dad ngà, knagolla i dad tuala, na fafatila ale. ");
INSERT INTO bpr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na nang nawa i kdee dad to gamu du mdà di ksasatuyu di do. Bay ku simto i gamtayud kel di gusenan, galwà kenen. ");
INSERT INTO bpr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na kaflingenta dun, ku falnayamla gamu di satu banwe, milah gamu di dademe banwe. Na too glut i man-gu di gamu ani, na là fa galngabyu i kdee dad syudad di Israél, ta kel agu, dunan i dnagit Ngà To. ");
INSERT INTO bpr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mdatah i to tamdò di to tdòan, na mdatah i amu di fasakan. ");
INSERT INTO bpr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yé duenam man, gablà moon ku fye nawa i to tdò ku glalòan i to tamdò kenen. Na i fasak, gablà moon ku fye nawan ku glalòan i amun. Na do sa i Amuyu, na yé katlola do Bélsébul, Taman, too sasè fa i katlola gamu, dunan i dad to nfun-gu. ");
INSERT INTO bpr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Na yé duenam man, nang gamu likò di dale. I kdee dad gbuni di mdu ani, nun du kadang teen, na i kdee là gadè di mdu ani, nun du kadang gadè. ");
INSERT INTO bpr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ku dét man-gu di gamu di gukmifuhan, tulenyu di gumalwan, na ku dét i ta lingeyu di gugbunin, tooyu falbong i talùyu di ktulenyu dun di lwà. ");
INSERT INTO bpr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nang gamu likò di dad to, du lo yé gaganla fnati i lawehyu, bay là gaganla falmo i layefyu. Bay yé gablà kalnikòyu i Dwata du gaganan falmo i lawehyu na lê man i layefyu di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Fandamyu kun i dad kalsidaw galla fabli di fadyan. Too tukay i btasla. Bay balù ayé, silang nun tatek di tanà ku faloh i Màyu di langit. ");
INSERT INTO bpr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na gamu dad to, balù i kdee wakyu, ta gse Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Taman, nang gamu likò du di fandam Dwata, mas mabtas gamu fa di dad kalsidaw. ");
INSERT INTO bpr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ku simto i fgadè dun di kanfe i dad to na do i mfun kenen, lêgu fgadè di kanfe i Màgu di langit na kenen i nfun-gu. ");
INSERT INTO bpr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bay ku simto i là fgadè di kanfe i dad to na kenen i nfun-gu, là lêgu dun fgadè di kanfe i Màgu di langit na kenen i nfun-gu.” ");
INSERT INTO bpr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na fadlug Dyisas tamdò, manan, “Na nangyu fandam ku yé duen-gu salu dini di tah tanà ku mebe agu ksasatu nawa. Ise, bay yé nebegu sundang du baling snang nawa i dad to mdà di do. ");
INSERT INTO bpr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mdà di ksalugu dini, i ngà lagi dnuenan màan, na i ngà libun dnuenan yêan, na i libun tmewe, dnuenan tewen libun. ");
INSERT INTO bpr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na yé kadang baling too dmuen i dad to nfun-gu dunan i dad to glam di familyala. ");
INSERT INTO bpr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“I to kamdo i màan na yêan midul di kakdon do, là gablàan mgimò togu. Na i to kamdo i ngàan lagi ku demen i ngàan libun midul di kakdon do, lê là gablàan mgimò togu. ");
INSERT INTO bpr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na ku nun to là mayè lmifet i kton na tmiang i krusan, lê là gablàan mgimò togu. ");
INSERT INTO bpr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na ku simto kambong nawa i kton, baling lanah i nawan. Bay ku simto mati du mdà di kaginan di do, nun nawan landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ku simto i dmawat gamu, lêan agu dnawat. Na ku simto i dmawat do, lêan dnawat i Màgu, dunan i mdek do. ");
INSERT INTO bpr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na ku nun dnawatyu tugad i Dwata du mdà di kdek Dwata kenen, lê nun gdawatyu lubay gablà blé di dad tugad i Dwata. Na ku nun dnawatyu to tluh du mdà di katluhan, lê nun gdawatyu lubay gablà blé di dad to tluh. ");
INSERT INTO bpr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nangyu glifet ani. Ku nun bléyu di satu mdanà to magin di do, balù ku lo satu basù éél tno, nun lubay gdawatyu.” ");
INSERT INTO bpr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Di kafnge Dyisas falmau i dad sfalò lwe to galan tdò, ta mdà kenen tamdò di dademe dad banwe mdadong déé. ");
INSERT INTO bpr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Dyan Gal Munyag, ta blanggù kenen. Na kanton linge gablà di dad nimò Krayst, ta dekan dademe dad to tdòan salu ditù. ");
INSERT INTO bpr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Na ani snalekla di kenen, “Ge kè sanfatanmi i ta gman Dyan, ku demen ise?” ");
INSERT INTO bpr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na tmimel Dyisas, manan, “Samfulê gamu di ku Dyan, na tulenyu kenen i kdee ta lingeyu na i ta teenyu. ");
INSERT INTO bpr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mite i dad butè, na gagu dad kimay, na mgulê i dad to nun fdas mumuh, na lminge i dad bakong, na mték i dad mati, na i dad to landè knun, lingela i Fye Tulen. ");
INSERT INTO bpr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na manyu di ku Dyan na ku simto là lwe nawan di kaftoon di do, nun kafye gfunan.” ");
INSERT INTO bpr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na di kdà dad to dek Dyan, talù Dyisas di dad to stifun déé gablà di ku Dyan, manan, “Di munan, di ksaluyu di banwe landè to mnè ditù, dét kayèyu teen? Ise ku yé fanngabalyu i kalon wal i nus. ");
INSERT INTO bpr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Du ise yé i fanngabalyu, dét i kayèyu teen? Là sa mngabal gamu lagi kalmaweh fye du yé gufanak i dad to kalmaweh fye di dad malbang gumnè i dad harì. ");
INSERT INTO bpr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bay dét i kayèyu teen ditù? Satu tugad i Dwata kè? Dunan, satu tugad i Dwata kenen, bay mdatah kenen fa di dademe dad tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dyan i ta fala tulen di sulat ani mdà di Tnalù i Dwata, manan, ‘Dekgu i snaliggu muna di ge na fatlagadan i dalanam.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na fadlug Dyisas talù, manan, “Ani tulenta gamu, na di kdee dad to sut di tah tanà, landè gamsngad di kdatah Dyan Gal Munyag. Bay ku simto i gfusuk di Kagot Dwata balù kel di to too mdanà, mdatah kenen di ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mdà di katbù Dyan tamdò kel ani, too teen kgis i Kagot Dwata. Na i dad to labè, too ale fgal du fye gfusuk ale. ");
INSERT INTO bpr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na balù i Tnalù Dwata fagun di dad tugadan na lê man i uldin fagun di ku Mosis, toola santulen i Kagot Dwata di lam Dyan là sut. ");
INSERT INTO bpr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ku loyu fantoo moon i manla di munan, ta gadèyu na yé to manla fan kel gaflingen di ku Ilaydya dunan Dyan. ");
INSERT INTO bpr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ku simto i nun klinge, fye ku too flinge.” ");
INSERT INTO bpr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na talù Dyisas, manan, “Dét i fye guflingen-gu i dad to di mdu ani? Yé guflingen-gu dale i dademe dad ngà sudeng di fadyan. Là mayè ale magin sagwas, na ani man i dademela di dale, ");
INSERT INTO bpr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Fmalandag gami di klehew, bay knèan là magin gamu madal. Lingagmi i lingag di mati, bay là mngel gamu.’ ");
INSERT INTO bpr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Salngad gamu i dad ngà là mayè magin ayé. Fandamyu Dyan. Gal kenen fwasa, na là minuman binu, bay yé manyu gablà di kenen bnusaw. ");
INSERT INTO bpr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na do, i dnagit Ngà To, kmaan agu, na minum, na yé manyu gablà di do, ‘Neyeyu, tyan kenen, na gal flangal, na yé dademen sakdo i dad sasè to mwè bayad i buhis na dad lo lmafà i dad uldin Dwata.’ Bay, déé gumite i gnadè Dwata di ulê i dad nimòan.” ");
INSERT INTO bpr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na kafnge ayé, nngak Dyisas i dad to di dad banwe gumimòan dee tnikeng du là ti msal ale, manan, ");
INSERT INTO bpr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Magakdo gamu, dad to di banwe Korasin na lê man di banwe Bétsayda. Kaflingenta dun, i dad to di dad banwe Tiro na Sidon, ku dale mite i dad tnikeng ta gfite di gamu, ta msal ale, na ta sanala fite i ksalla fagu di kalsakla saul sakù na i kbubulla abu di tah ulula. ");
INSERT INTO bpr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Balù ku maflayam dad to mdà di dad banwe Tiro na Sidon di Du Kukum Dwata, bay gamu di Korasin na Bétsayda, midul déé i kaflayamyu. ");
INSERT INTO bpr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na gamu dad to di banwe Kapernaum, too gamu mayè mbatun, bay knèan fan gamu gtufa salu di lanaw lifoh. Kaflingenta dun, i dad to di banwe Sodom, ku dale mite i dad tnikeng ta gfite di gamu, ta msal ale na kel ani là malmo i banwela. ");
INSERT INTO bpr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yé duenam man, man-gu di gamu, ku maflayam dad to di banwe Sodom di Du Kukum Dwata i dad to, bay gamu di Kapernaum, midul déé i kaflayamyu.” ");
INSERT INTO bpr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na di du ayé, dmasal Dyisas, manan, “E Mà, ge i Amu, dunan magot i langit na i tanà. Dnayenta ge du ku dét i ta bunim di dad mdatah to too gmadè na i dad to too fulung, yé ta fgadèam di dad to mdanà salngad i dad malnak ngà. ");
INSERT INTO bpr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yé duenam mimò ani du ani knayèam.” ");
INSERT INTO bpr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na ta lê talù Dyisas di dad to, manan, “Ta salig Mà di do i kalbong kdee. Lo yé gmadè i Ngà dunan i Màan. Na lo yé gmadè i Mà dunan i Ngàan na lê man i dad to knayèan gufdilè i Màan. ");
INSERT INTO bpr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gamu dad to ta mlungay mdà di blat nebeyu, salu gamu di do na banléta gamu kaftud. ");
INSERT INTO bpr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lakatyu i kukunggu na fatdò gamu di do du fye balugu na toogu fdanà i ktogu. Ku yé nimòyu, nun sa fye kaftudyu, ");
INSERT INTO bpr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","du too fye i kukunggu, na là blat i ftianggu gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na di satu Du Kaftud i dad Dyu, magu ale Dyisas di satu lnigo. Na i dad to galan tdò, ta bitil ale, taman, beg ale kambang là dee dad kigan trigo, na fnilula du knilewla i msehan. ");
INSERT INTO bpr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na kanto teen dad Farisi i nimòla, manla di ku Dyisas, “Neyem. Kamtu dad to tdòam di Du Kaftud. Là fakay ayé, du fnang Dwata di uldin fagun di ku Mosis.” ");
INSERT INTO bpr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bay man Dyisas di dale, “Kan kè? Là lmenyu masa gablà di nimò Dabid du mdà di kbitilan na i dademen? ");
INSERT INTO bpr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ani i nimòan. Fusuk kenen di Bong Gumnè Gumangamfù di Dwata, na nwèan i fan gal blé di Dwata. Na blaam, yé lo fakay kmaan i fan ayé i dad ganlal di kafaglut, bay knèan kmaan Dabid i fan ayé, na banlén i dademen. ");
INSERT INTO bpr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na keng là gbasayu di uldin i nimò dad ganlal di kafaglut. Kat Du Kaftud, galla lnafà i uldin gablà di Du Kaftud, bay landè salàla di nimòla ayé. ");
INSERT INTO bpr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ani man-gu di gamu na nun to dini mabtas fa di Bong Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ani man di Tnalù i Dwata, ‘Ise ku dsù i dad lmanaf i kayègu, bay kasakdo.’ Ku loyu glabat moon, là ti falnayamyu i dad to landè salà, ");
INSERT INTO bpr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","du yé magot i Du Kaftud dunan i Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na ta mdà Dyisas, na fles kenen fusuk di satu gumnè gal gustifun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na nun lagi déé fikot i sigalan. Nun dad to déé mayè tmifù ku Dyisas, taman, snalekla kenen, manla, “Mdà di uldin Dwata fagu di ku Mosis, fakay famgulê di Du Kaftud, ku là?” ");
INSERT INTO bpr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na tmimel Dyisas, manan, “Ku nun bilibiliyu mtatek di mngalam sol di Du Kaftud, là kè falwàyu dun? ");
INSERT INTO bpr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na too mabtas fa i satu to di bilibili. Na yé duenam man, fakay di uldin Dwata fagu di ku Mosis ku tnabengto i dademe to.” ");
INSERT INTO bpr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na kafnge ayé, manan di to fikot i sigalan, “Bankeham i sigalam.” Na kanton bankeh, tin tadè bkeh salngad di balin. ");
INSERT INTO bpr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bay i dad Farisi, lamwà ale, na santulenla ku dét kibò kfatila ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na kanto gadè Dyisas i ayèla fmati kenen, ta mdà di banwe ayé. Na too dee dad to magin dun, na fan-gulêan i dad to nun tduk, ");
INSERT INTO bpr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na yé fnangan dale nangla tulen ku simto kenen. ");
INSERT INTO bpr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Na fagu déé gdohò i man Dwata fagu di ku Isaya, ");
INSERT INTO bpr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ani i snaliggu ta mgalékgu. Toogu kenen kanbong nawa, na fye nawagu dun. Fnègu i Tulusgu di kenen, na fgadèan di kdee dad to gablà di kukumgu too tluh. ");
INSERT INTO bpr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Là ti mbetan sbalew, na là faltêan, na là sa falbongan i talùan di dalan. ");
INSERT INTO bpr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na i dad to mnè di klungay, tnabengan salngad i law ta bluk là flesan tanfò dun, na i salò fan mati là sa nyufan dun. Fantahàan i nawan kel di bang i katluh fmisan i sasè. ");
INSERT INTO bpr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kenen i fanden i kdee dad to di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na nun nebela di ku Dyisas satu to nun busawan. Butè kenen na umu mdà di busaw, bay fan-gulê Dyisas kenen du fye gtalù na mite. ");
INSERT INTO bpr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na too ti tikeng i kdee dad to, na smalek ale, manla, “Dunan ani kè i bel Dabid?” ");
INSERT INTO bpr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na kanto linge dad Farisi ani, manla, “Yé duenan gmagan falwà i dad busaw du mdà di ku Bélsébul, i gumdatah i dad busaw.” ");
INSERT INTO bpr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta gadè Dyisas i fandamla, na manan dale, “Ku fkahta di satu banwe, ku baling sfati i dad to slame dale, malmo i banwe ayé. Na ku fkahta di satu syudad ku demen familya, ku gal ale sfati, baling malbà i kasgalakla. ");
INSERT INTO bpr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na kaflingenta dun, ku sanfati Satanas i kton, masbalét i dad ton, na malmo i kagotan. ");
INSERT INTO bpr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kaflingenta dun, ku falwàgu i dad busaw fagu di kgagan blé Bélsébul, dét i fakayyu man gablà di kgagan i dad to galyu tdò? Lê man mdà di ku Bélsébul i dale kgagan kè? Na yé duenam man, ta gfitela di gamu na gsalà i manyu du ise ku Bélsébul i gumdà i kgagan-gu. ");
INSERT INTO bpr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bay ta gfite di gamu nan na ta kel i bang Dwata magot dad ton du falwàgu i dad busaw fagu di kaltulus i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Na nun tulen Dyisas satu fléd, manan, “Ku nun to kamgis na bnantayan i gumnèan, landè gamwè i knunan. Silang nun gamwè dun ku funan bnakus i to kamgis. ");
INSERT INTO bpr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ku simto là msen do, knangan agu. Na ku simto là tmabeng do samtifun i dad to, balingan ale sanbalét. ");
INSERT INTO bpr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yé duenam man, man-gu di gamu na balù dét salà i satu to ku demen dad sasè manan, gagan fnasinsya Dwata. Bay i to talù sasè gablà di Mtiu Tulus, là ti fnasinsya Dwata i salàan. ");
INSERT INTO bpr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Balù simto to talù sasè gablà di Ngà To, fakay fnasinsya i salàan. Bay ku simto talù sasè gablà di Mtiu Tulus, là ti fnasinsya Dwata i salàan, balù di mdu ani na kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ku nun fye kayu, lê fye bengen. Na ku nun sasè kayu, lê sasè i bengen, du yé gudmilè i kayu di bengen. ");
INSERT INTO bpr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gambet gamu dad ulad du lo slame sasè i mnè di nawayu. Yé duenam man, landè kibòyu talù fye du ku dét i mnè di nawa satu to, yé lamwà di bàan. ");
INSERT INTO bpr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","I fye to, slame fye lamwà di bàan du yé gumdàan di kdee fye busekan di nawan. Na i sasè to, slame sasè lamwà di bàan du yé gumdàan di kdee sasè busekan di nawan. ");
INSERT INTO bpr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bay ani man-gu di gamu na di Du Kukum, toon snalek i dad to gablà di kdee dad talùla landè gukel. ");
INSERT INTO bpr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Du ku fye i talùyu, là sa falnayaman gamu. Bay ku sasè i talùyu, falnayaman gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na kafnge ayé, nun dad Farisi na dademe dad to gal tamdò dad uldin Dwata fagu di ku Mosis, na talù ale di kenen, manla, “E Sér, yé kayèmi teen ku mimò ge tnikeng.” ");
INSERT INTO bpr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bay tmimel kenen, manan, “Too ti sasè i dad to di mdu ani. Gal ale mni tnikeng bay landè fitegu ani, senan satu ilè gambet i mkel di ku Dyona, i satu tugad i Dwata di munan. ");
INSERT INTO bpr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yé klo Dyona di lam i tien i bong nalaf tlu du na tlu butang. Na salngad ayé i mkel di do, i dnagit Ngà To, du tlu du na tlu butang i klogu mnè lam tanà. ");
INSERT INTO bpr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Di munan, i dad to di banwe Ninibi, msal ale mdà di katdò Dyona dale. Na di Du Kukum Dwata kadang, lê mték i dad to ayé, na mgimò ilè di dad to di mdu ani gugmadèyu na gablà gamu falnayam du là gamu msal di katdòta gamu. Na blaam, mdatah agu sa di ku Dyona. ");
INSERT INTO bpr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na lê man di munan, nun satu harì libun mdà di banwe Siba, na balù mawag i gumdàan, knèan salu kenen di ku Harì Solomon du fye falningen i gnadè Solomon. Na di Du Kukum Dwata kadang, mték i harì libun, na mgimò ilè di dad to di mdu ani gugmadèyu na gablà gamu falnayam du là gamu msal di katdòta gamu. Na blaam, mdatah agu sa di ku Harì Solomon. ");
INSERT INTO bpr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ku nun busaw lamwà di satu to, ani nimòan. Mngabal kenen gufanakan di dad banwe kafag. Bay ku landè teenan, ");
INSERT INTO bpr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ani manan di kton, ‘Lê agu samfulê di tagnè gumnègu.’ Na ku ta kel i busaw di to ayé gine, teenan na sawe salngad kenen i gumnè landè ton na too mlaneb na maftifas. ");
INSERT INTO bpr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na yé duenam man, lê mdà i busaw là mlo, na lê nun faginan fitu dad busaw midul fa i ksasèla di kenen. Na sdulê ale fusuk di to ayé, na fles ale mnè di kenen. Na yé gukel i to ayé, matnù fa i ksasèan di fa là lamwà i busaw di katbùan. I dad sasè to mnè di tah tanà di mdu ani, salngad ayé i mkel di dale.” ");
INSERT INTO bpr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lam Dyisas tamdò di dad to stifun déé, tadag yêan na i dad flanekan ditù di lwà du mayè ale stulen di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na nun tmulen di ku Dyisas, manan, “Ta déé yêam na dad flanekam di lwà, du kayèla stulen di ge.” ");
INSERT INTO bpr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Na man Dyisas di dad to ayé, “Simto kè i yêgu na dad flanekgu?” ");
INSERT INTO bpr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na tdòan dad to gal magin di kenen, manan, “Ani i yêgu na dad flanekgu. ");
INSERT INTO bpr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Du ku simto mimò i knayè Mà, yé mgimò flanekgu lagi na flanekgu libun na yêgu.” ");
INSERT INTO bpr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na di du atù, ta lamwà Dyisas di gumnè, na sudeng kenen di kilil i bong lanaw. ");
INSERT INTO bpr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Too dee dad to stifun di safédan, taman myak kenen di satu aweng du déé gusudengan, na tadag dad to di kilil i lanaw. ");
INSERT INTO bpr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na too dee tulenan di dale fagu di dad fléd. Ani manan, “Nun to salu di dnarun du smabul bnê. ");
INSERT INTO bpr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kanton sabul, nun dademe dad bnê gtadè di bà dalan, na fti tnukè dad anuk mayeng. ");
INSERT INTO bpr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na nun dademe bnê gtadè di gudee batu na landè alì tanàan. Too mlal msut di tah i tabòla du mngifi i tanàan. ");
INSERT INTO bpr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bay kanto msut i du, ta mlanas du là toon dmalil. ");
INSERT INTO bpr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na nun dademe dad bnê gtadè di lam bnas nun sual. Na kanto tahà i bnas, ta mlimas dad tabò i dad bnê. ");
INSERT INTO bpr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bay nun dademe dad bnê gtadè di gufye i tanà. Too tmabò i dad bnê ani, na yé ulêan mlatuh i dademe, na nam falò i dademe, na tlu falò i dademe.” ");
INSERT INTO bpr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na kafngen tmulen i fléd, manan, “Ku simto i nun klinge, fye ku too flinge.” ");
INSERT INTO bpr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na fdadong i dad to galan tdò di kenen, na smalek ale, manla, “Dét i duenam tamdò di dad to fagu di dad fléd?” ");
INSERT INTO bpr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na tmimel Dyisas, manan, “Faglabatgu di gamu i dad gbuni gablà di Kagot Dwata, bay là faglabatgu dun di dademe. ");
INSERT INTO bpr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ku simto fkah di nawan i ta gadèan, lê tananù Dwata i blén di kenen, du fye too ti bong. Bay ku simto là fkah dun di nawan i ta gadèan, lê nawì Dwata balù i tukay ta glabatan. ");
INSERT INTO bpr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ani i duen-gu tamdò dale fagu di fléd “Du fye balù meye ale, knèan là mite ale, na balù ku flinge ale, là lminge ale na là galmabat ale.” ");
INSERT INTO bpr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na fagu déé, gdohò i man Dwata fagu di ku Isaya, ‘Balù ku too gamu flinge, knèan là sa galmabat gamu. Na balù ku too gamu meye, là sa mite gamu. ");
INSERT INTO bpr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Du i dad to ani, ta too magéng ulula, na ta balingla nsang dad klingela, na ta fafidangla dad matala fye là mite ale. Ku ise ani moon nimòla, fakay ale mite, na lminge, na galmabat, na fagu déé, fakay ku msal ale du fye fan-gulêgu ale.’ ");
INSERT INTO bpr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bay gamu dad to galgu tdò, too nun kafye gdawatyu du gal mite dad matayu na gal lminge dad klingeyu. ");
INSERT INTO bpr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Du too glut i man-gu di gamu ani, nun dee dad tugad i Dwata di munan na dademe dad to i Dwata, toola kayè teen i ta teenyu gamu, bay landè kibòla mite dun, na toola kayè linge i ta lingeyu gamu, bay landè kibòla lminge dun. ");
INSERT INTO bpr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yé duenam man, tooyu falninge na fan-glabat i gumtatek i fléd gablà di to smabul bnê. ");
INSERT INTO bpr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I tanà di bà dalan gugsabul i dademe dad bnê, dunan i dad to lminge i tdò gablà di Kagot i Dwata, bay là glabatla dun. Salu Satanas di dale na nwèan i ta gsabul di nawala. ");
INSERT INTO bpr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","I tanà gugsabul i dademe dad bnê di gudee batu, dunan i dad to too gasil dmawat i Tnalù Dwata di kaklingela dun na too ale lehew di katbùan. ");
INSERT INTO bpr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bay landè too dalilla, taman là too ale mlo ftoo du ku ta nkel ale i klimah ku demen kaflayam du mdà di kdawatla i Tnalù Dwata, knagolla i kaftoola. ");
INSERT INTO bpr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na i tanà gugsabul i dademe dad bnê gtadè lam bnas nun sual, dunan i dad to lminge i Tnalù Dwata, bay mlimas i Tnalù i Dwata di nawala du mdà di klidù nawala, na i kiballa i knun. Na mdà déé, là menge i Tnalù Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bay i fye tanà gugsabul i dademe dad bnê, dunan i dad to galmabat i Tnalù Dwata di kaklingela dun. Too fye ulêla, slaan mlatuh, slaan nam falò, na slaan tlu falò.” ");
INSERT INTO bpr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na lê nun tulen Dyisas satu fléd, manan, “Yé guflingen-gu i Kagot Dwata di satu to mlah too fye bnê di tanàan. ");
INSERT INTO bpr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bay di lamla kudang di satu kifuh, nun satu to muteh dun nawa salu déé di tanà ayé, na snabulan benge bnas too sasè, na kafnge ayé klon mdà. ");
INSERT INTO bpr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanto tmabò dad bnê na ta fan mbugal i fusùan, yé klom dmilè bnas. ");
INSERT INTO bpr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na ta fdadong i dad snaligan di kenen, na smalek ale, manla, ‘Sér, fye bnê i ta flaham di tanàam. Bay nè gumdà i dad bnas ani?’ ");
INSERT INTO bpr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na tmimel kenen, manan, ‘Nun to muteh do nawa, kenen i smabul bnas ani.’ Na lê smalek i dad snaligan, manla, ‘Mayè ge kè ku ndotmi i dad bnas ani?’ ");
INSERT INTO bpr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bay tmimel kenen, manan, ‘Nang, du ku ndotyu dad bnas ani, keng gagin i dademe dad flahgu. ");
INSERT INTO bpr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Falohyu ale salnok kel di bang kamtu. Na di bang ayé, fakaygu flau di dad to kamtu fye funala santifun i dad bnas na bnakasla klola smakuf dun, bay i ulê i dad flahgu, nebela di lam i folgu.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Lê nun tulenan dale satu fléd, manan, “I Kagot Dwata salngad di too tukay lam mustasa fele satu to di tanàan. ");
INSERT INTO bpr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Balù ku too tukay i bnê ani di kdee dad bnê, bay kanto tmabò, ta mbaling too bong fa di kdee dad fele na déé gumdaf na gusmalal i dad anuk mayeng di dad fangan.” ");
INSERT INTO bpr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Lê nun tulenan dale satu fléd, manan, “I Kagot Dwata salngad bulung falnok fan nwè i libun du bolan di sgantang arina di kimòan fan du fye too lamnok.” ");
INSERT INTO bpr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I kdee tdò Dyisas di dale slame fagun di fléd, na landè tdòan di dale ku là fagun di fléd. ");
INSERT INTO bpr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na fagu déé, gdohò i man satu tugad i Dwata di munan, “Yé katdògu fagu di dad fléd, na tulen-gu i dad gbuni mdà di kimò Dwata i klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na kafnge ayé, ta tnagakan i gudee dad to, na fusuk kenen di lam i gumnè. Na fdadong i dad to galan tdò, manla, “Tulenam gami ku dét i gumtatek i fléd gablà di dad bnas di tanà i to mlah bnê.” ");
INSERT INTO bpr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na tmimel Dyisas, manan, “Yé mlah i fye bnê dunan i dnagit Ngà To. ");
INSERT INTO bpr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na yé tanà gumlahan i bnê dunan i klamang banwe, na yé gumtatek i dad fye bnê dunan i dad to magin di Kagot Dwata. Na yé gumtatek i dad bnas dunan i dad to nfun Satanas. ");
INSERT INTO bpr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na i to muteh do nawa, dunan Satanas, i smabul dad benge bnas too sasè. Na yé gumtatek i kaktu dunan gusen i banwe, na yé kamtu dunan dad kasaligan i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","I dad bnas santifunla na snakufla di lifoh, salngad ayé i mkel di gusen i banwe. ");
INSERT INTO bpr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ani nimò i dnagit Ngà To. Dekan i dad kasaliganan du fye nwèla i kdee gamgebe i dad to di kagsalà na i kdee dad to mimò sasè. ");
INSERT INTO bpr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Batla ale di lifoh too minit, na déé gumngella na gukminggat i kifanla. ");
INSERT INTO bpr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na kafnge ayé, i dad to tluh di kite Dwata, too ale mneng di Kagot i Màla Dwata gambet neng i du. Ku simto nun klinge, fye ku too flinge. ");
INSERT INTO bpr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“I Kagot Dwata salngad di satu too mabtas knun lbang di tanà. Kanto nun to gamgakol dun, lêan lnimun na too bong klehewan fabli i kdee knunan du fye gbayadan i tanà ayé na fagu déé gwèan i too mabtas knun. ");
INSERT INTO bpr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“I Kagot Dwata salngad di satu to gal mayad dad slah too mabtas. ");
INSERT INTO bpr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kanto nun teenan satu slah too ti mabtas, ta fablin i kdee dad knunan du fye gbayadan i too ti mabtas slah ayé. ");
INSERT INTO bpr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“I Kagot Dwata salngad di fukat ftatekla di bong lanaw na baling gamwè dad sahal nalaf. ");
INSERT INTO bpr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na kanto fnò i fukatla, ta dyolla salu di kilil lanaw. Na kafnge ayé, ta sudeng ale du sansahalla dad nalaf. I dad fye nalaf, kahla di lam alatla, bay dad sasè nalaf, batla. ");
INSERT INTO bpr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na yé i kagkah di gusen i banwe. Salu dini dad kasaligan dek Dwata, na sansahalla i dad to sasè na i dad to fye. ");
INSERT INTO bpr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na i dad sasè to, batla ale di lifoh too minit, na déé gumngella na gukminggat i kifanla.” ");
INSERT INTO bpr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na smalek Dyisas, manan, “Ta glabatyu kè i kdee ani gine?” Na tmimel ale, manla, “Hee.” ");
INSERT INTO bpr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yé duenam man, ta manan dale, “Ku nun satu to tagnè tamdò dad uldin Dwata fagu di ku Mosis, bay ku ta magin di Kagot i Dwata, salngad kenen di satu to nun dee knunan di lam i gumnèan. Nun falami fakayan gnamit, na lê nun labi.” ");
INSERT INTO bpr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na kanto fnge Dyisas tmulen i dad fléd, ta tnagakan i banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na samfulê kenen di banwe gulamnokan. Tamdò kenen di gumnè galla gustifun, na too tikeng i dad to lminge dun. Sasalek ale, manla, “Nè gugamwèan i gnadèan ani? Na nè gumdà i kfulungan mimò dad tnikeng? ");
INSERT INTO bpr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dunan ani kè i ngà fanday atù? Ise Méri kè i yêan, na Dyém, na Dyosip, na Simon, na Dyudas i dad flanekan? ");
INSERT INTO bpr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sana kdini kdee dad flanekan libun. Nè gumwèan i kfulungan ani?” ");
INSERT INTO bpr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na i dad to di banwe ayé, knangla kenen. Bay man Dyisas di dale, “Lo yé gulà mgafè i satu tugad i Dwata di kenen banwe di bleng i dademen.” ");
INSERT INTO bpr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na là dee dad tnikeng nimòan di banwe ayé du là too ale ftoo di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na di dad du ayé, ta linge Harì Hérod, i gumdatah di banwe Galili, gablà di kdee mgimò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na manan di dad to snaligan, “Ta mték Dyan Gal Munyag di fati. Yé duenam man, gaganan mimò dad tnikeng.” ");
INSERT INTO bpr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Di munan, ta fakfè Hérod Dyan, na ta fikatan na fablanggùan. Yé duenan mimò ani du mdà di ku Hérodiyas, yaan i flanekan Filip. ");
INSERT INTO bpr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ta gal man Dyan di ku Hérod, “Là fakayam nlad yaan i flanekam.” ");
INSERT INTO bpr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Taman, too mayè Hérod fmati ku Dyan, bay likò kenen di dad to, du yé kafaldamla ku Dyan na kenen i satu tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na kanto kel i du kafaldam i ksut Harì Hérod, sayew i ngà Hérodiyas libun, na too bayan Hérod meye dun. ");
INSERT INTO bpr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Na yé duenam man, makang kenen di ngà libun ayé, manan, “Ani sdagègu, balù dét i fnim, blégu di ge.” ");
INSERT INTO bpr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na nimenan i flau yêan di kenen, manan di ku Hérod, “Yé kayègu blém do i ulu Dyan Gal Munyag, kaham di tah fligo.” ");
INSERT INTO bpr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Too mlidù nawa Harì Hérod di kafni i ngà ayé, bay landè kibòan là mayè du ta guna i kasdagèan, na myà ku là dnohòan i fakangan du ta linge i kdee dad to kmaan di safédan. Yé duenam man, dekan i dad snaligan du fye gablén i fni ngà ayé, ");
INSERT INTO bpr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","na faklangan i ulu Dyan déé di blanggù. ");
INSERT INTO bpr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na fkahla i ulu Dyan di tah i satu fligo, na bléla di ngà libun ayé, na flesan nebe di ku yêan. ");
INSERT INTO bpr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na kanto linge i dad to gal tdò Dyan ayé gine, salu ale déé na nwèla i lawehan na lbangla. Na kafnge ayé, mdà ale du tulenla ku Dyisas i ta mkel di ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na kanto linge Dyisas gablà di kfati Dyan, ta mdà kenen maweng du salu di satu banwe lon satu. Bay kanto gadè dad to i gusalun, ta mdà ale tmanà lmalò kenen. ");
INSERT INTO bpr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na kanto dmuung déé, teenan i kdee dad to stifun, na too sè kakdon dale, na fan-gulêan i dad to nun dad sahal tduk. ");
INSERT INTO bpr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Di ta fan kasdaf i du, fdadong di kenen i sfalò lwe to galan tdò, na manla, “Ta flabi nan, na landè gumnè mdadong dini. Fye ku dekam dad to ani salu di dad malnak banwe du fye mayad ale knaanla.” ");
INSERT INTO bpr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bay tmimel Dyisas, manan, “Balù là mdà ale. Gamu i famkaan dale.” ");
INSERT INTO bpr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na manla di kenen, “Nun dini lo lime batù fan, na lwe batù nalaf.” ");
INSERT INTO bpr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na man Dyisas di dale, “Nebeyu dini di do.” ");
INSERT INTO bpr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na fsudengan dad to di bnas, klon mwè i lime batù fan na i lwe batù nalaf, na lngalà kenen di langit du fasalamat di Dwata. Falnakan i fan na nalelan di dad sfalò lwe to galan tdò, na dale i lê malel dun di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na kmaan i kdee dad to déé, na bsol ale. Na ta santifun i dad to galan tdò i lukasla, na fnò i sfalò lwe been. ");
INSERT INTO bpr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yé kdee dad lagi déé mdadong lime libu, na lê nun dad libun na i dad ngà gagin kmaan, bay là faginla ale nse. ");
INSERT INTO bpr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Na kafnge ayé, dek Dyisas i dad to galan tdò muna maweng mifal di bong lanaw. Na ftagak Dyisas du fdàan i dad to. ");
INSERT INTO bpr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na kafngen fdà dad to, mnagad kenen di satu bulul lon satu du dmasal. Kel di kifuh lo kenen déé. ");
INSERT INTO bpr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na kanto ale ditù di talà, ta sankusu lwek i awengla du gsitongla i nus. ");
INSERT INTO bpr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Di mayè fayah, salu Dyisas di dale, na tadè kenen magu di tah i lanaw. ");
INSERT INTO bpr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na kantola teen kenen magu di tah i lanaw, too ale ti likò, na manla, “Kyò. Lmagol sa ayé.” Na mkit ale mdà di klikòla. ");
INSERT INTO bpr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bay talù Dyisas di dale, manan, “Fan-galyu nawayu. Do sa ani. Nang gamu likò.” ");
INSERT INTO bpr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na talù Piter, manan, “Amu, ku ge ayé, fsalum agu déé di ge magu di tah i lanaw.” ");
INSERT INTO bpr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na man Dyisas, “Flal ge!” Yé duenam man, ta tufa Piter di aweng, na tambù kenen magu di tah i lanaw salu di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bay kanton galyalo kamgis i nus, ta likò kenen, na ta tanbùan galnab. Na manan, “E Amu, tnabengam agu!” ");
INSERT INTO bpr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na gasil snabà Dyisas i sigal Piter na dyolan, manan dun, “Tay, too tukay i ksaligam. Kan ku lwe nawam?” ");
INSERT INTO bpr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na ta myak ale di aweng, na ta fanak i nus. ");
INSERT INTO bpr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","I dademe dad to gal tdò Dyisas sudeng di aweng, too ale mangamfù di ku Dyisas, manla, “Too ti glut kadì, ge i Ngà Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na fles ale mifal di lanaw, na dmuung ale di banwe Génésarét. ");
INSERT INTO bpr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na dilè i dad to déé Dyisas. Taman, nngéla i dad to nun tduk mdà di dad sahal banwe glibut déé du nebela ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na fakdo ale di ku Dyisas fye ku began ale fagot balù lo di kilil i saulan. Na ku simto gmagot i saulan, mgulê. ");
INSERT INTO bpr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na kafnge ayé, nun dad Farisi na dademe dad to gal tamdò i dad uldin Dwata fagu di ku Mosis mdà di Dyérusalém salu di ku Dyisas. Smalek ale, manla, ");
INSERT INTO bpr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kan ku lnafà dad to tdòam i adat i dad gutambulto? Là funa ale malob di kakaanla.” ");
INSERT INTO bpr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na tmimel Dyisas, manan, “Na balù gamu, kan sa ku tnagakyu i uldin Dwata du fye gimenyu i adatyu? ");
INSERT INTO bpr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ani uldin Dwata, ‘Nafèyu màyu na yêyu,’ na ‘Ku simto to talù sasè di màan ku demen i yêan, là fakay ku là fnati dun.’ ");
INSERT INTO bpr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bay yé galyu tdò na ku nun tabeng fan blé satu to di dad tuan, fakayan man, ‘Kene Dwata ani.’ ");
INSERT INTO bpr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na ku yé manan, balù ta là fiten i afèan di dale fagu di tabengan ani. Yé duenam man, ta knagolyu i Tnalù Dwata du fye lalòyu i dad adatyu. ");
INSERT INTO bpr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mdà di katdòyu i gamu adat, ta flandèyu btas i Tnalù Dwata. Too ti glut i man Dwata fagu di ku Isaya gablà di gamu. Ani i fsulatan, ");
INSERT INTO bpr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘I dad to ani, nafèla agu fagu di talùla, bay too mawag i fandamla di do. ");
INSERT INTO bpr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Landè gukmamu i kfangamfùla di do, du yé gumdà i dad flaula di dad to balù ku yé manla mdà di Dwata.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na ta tlo Dyisas i dad to di safédan na talù kenen fagu di fléd, manan, “Too gamu flinge na tooyu fan-glabat ani di ktoyu. ");
INSERT INTO bpr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ise ku yé gamfagsik i satu to i fusuk di bàan. Bay yé gamfagsik kenen i lamwà di bàan.” ");
INSERT INTO bpr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na too fdadong dad to galan tdò di kenen, manla, “Tamduk nawa i dad Farisi mdà di gmanam gine.” ");
INSERT INTO bpr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na tmimel Dyisas fagu di fléd, manan, “Ku dét i ise fele Mà, nsò kadang gagin i dalilan. ");
INSERT INTO bpr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bayàyu dad Farisi ayé. Balù ku malak ale, salngad ale i dad to butè malak i dademela butè. Na ku yé salak slame butè, sdulê ale tatek di sol.” ");
INSERT INTO bpr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na talù Piter, manan, “Na kun. Begam nubad di gami i flédam gine.” ");
INSERT INTO bpr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na tmimel Dyisas, manan, “Balù gamu, là fa kadì galmabat. ");
INSERT INTO bpr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gablà ku ta gadèyu na ku dét i fusuk di bà i satu to, yé guflesan di tienan, na fnge lê lamwà. ");
INSERT INTO bpr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bay i kdee lamwà di bà i satu to, yé gumdàan di nawan, na yé gamfagsik kenen. ");
INSERT INTO bpr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Du mdà di nawan, nun dad sasè fandam, na i kbanò, i klafà yaan, i ksaféd di to ise yaanan, i ktaku, i ktulen kéng, na i ktalù sasè gablà di dademe to. ");
INSERT INTO bpr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yé gamfagsik i satu to. Bay ku là funan malob di kakaanan, ise ku yé i gamfagsik kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na tnagak Dyisas i banwe ayé, na fles kenen ditù di banwe mdadong di dad syudad Tiro na Sidon. ");
INSERT INTO bpr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nun libun mnè déé, na ise kenen Dyu, bay yé gumdàan di banwe Kanaan. Fdadong kenen di ku Dyisas, manan, “E Sér, Bel Dabid, begam agu kando du nun busaw i ngàgu libun, na too sasè kagkahan.” ");
INSERT INTO bpr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bay là talù Dyisas di kenen. Taman, ta fdadong dad to galan tdò, na manla di kenen, “Gasilam blé di kenen i fnin du fye gasil mdà, du toon ato lalò na sigi kenen mugak.” ");
INSERT INTO bpr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na tnimel Dyisas i libun ayé fagu di fléd, manan, “Lo yé gumdek Dwata do di dad bilibili ta lanah di Israél.” ");
INSERT INTO bpr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na kanton linge i man Dyisas ayé, lkuad kenen di saféd blìan, manan, “Amu, begam agu tnabeng.” ");
INSERT INTO bpr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bay lê talù Dyisas fagu di fléd, manan, “Là fakay nwè i knaan i dad ngà ku blé di dad ayem.” ");
INSERT INTO bpr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na tmimel i libun, manan, “Hee, Amu, gadègu ayé. Bay balù i dad ayem, beg nun gwèla du gamkaan ale samel mtatek mdà di lamisa gukmaan i dad funla.” ");
INSERT INTO bpr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na talù Dyisas di libun ayé, manan, “Too bong ksaligam. Blégu di ge i fnim.” Na mdà déé, ta mgulê i ngàan. ");
INSERT INTO bpr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na lê tnagak Dyisas i banwe ayé, na magu kenen di kilil i Lanaw Galili. Na fles kenen mnagad di satu bulul na déé gusudengan. ");
INSERT INTO bpr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na too dee dad to salu di kenen, na nebela dad to là galyak i lawehla, na dad butè, na dad kimay, na dad umu, na balù dademe. Fkahla i dad to ani di saféd Dyisas, na fan-gulêan ale. ");
INSERT INTO bpr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na too tikeng i dad to du yé teenla na ta gtalù dad umu, na ta mgulê dad kimay, na ta gagu dad to là galyak i lawehla, na ta mite dad butè. Na toola dnayen Dwata i dad to Israél. ");
INSERT INTO bpr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na tlo Dyisas i dad to galan tdò, na manan di dale, “Toogu kando i dad to stifun ani, du ta tlu dula fanak di safédgu, na ta landè knaanla. Là mayè agu fulê dale ku landè knaanla du keng bek ale di dalan mdà di kbitilla.” ");
INSERT INTO bpr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na smalek dad to galan tdò, manla, “Nè gumngabalto knaan di banwe ani i gablà fkaan i kdee dad to ani? Fye ku nun dad to mnè mdadong dini.” ");
INSERT INTO bpr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na lê smalek Dyisas, manan, “File batù fanyu déé?” Na tmimel ale, manla, “Fitu batù, na nun dad malnak nalaf, bay là deen.” ");
INSERT INTO bpr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na dekan sudeng di tanà i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na kafnge ayé, ta nwèan i fitu batù fan na lê man i dad nalaf, na kafngen fasalamat di Dwata, falnakan na blén di dad to galan tdò, na dale lê malel dun di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na ta kmaan i kdeela na bsol ale. Na ta santifun i dad to galan tdò i lukas. Na yé kdeen, fitu been fnò. ");
INSERT INTO bpr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yé kdee dad lagi kmaan fat libu, na lê gagin kmaan dad libun na dad ngà, bay là faginla ale nse. ");
INSERT INTO bpr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na kafnge Dyisas fdà i dad to ayé, smakay kenen aweng salu di banwe Magadan. ");
INSERT INTO bpr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na nun dad Farisi na dad Sadusi salu di ku Dyisas du tnilewla kenen fagu di kafnila tnikeng du gugmadèla dun na yé gumdàan di langit. ");
INSERT INTO bpr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na tmimel kenen, manan, “Ku fan sdaf i du, galyu man, ‘Too fye tanà fayah du fulè i langit.’ ");
INSERT INTO bpr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na di flafus, galyu man, ‘Sasè tanà kadang du fulè i langit na too lmabun.’ Ta fulung gamu meye di langit du fye gadèyu i kagkah i tanà, bay là fulung gamu meye dad ilè nimò Dwata gugmadèyu i fan mkel. ");
INSERT INTO bpr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tay, too ti sasè i dad to di mdu ani, na landè kaftoola di Dwata. Mni gamu tnikeng di do, bay landè fitegu di gamu, senan lo satu ilè gambet i ta mkel di ku Dyona, i satu to di munan.” Na kafnge ayé, lê tnagak Dyisas ale na mdà kenen. ");
INSERT INTO bpr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bay kanto ale mdà mifal i bong lanaw, ta glifet i dad to gal tdò Dyisas mebe bnatu. ");
INSERT INTO bpr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na talù Dyisas fagun di fléd, manan dale, “Fan-geyeyu i galò bulung falnok fan mdà di dad Farisi na di dad Sadusi.” ");
INSERT INTO bpr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na stulen ale lo dale, na manla, “Yé duen Dyisas man ani du là mebe ato bnatu.” ");
INSERT INTO bpr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gadè Dyisas i santulenla, na manan dale, “Kan ku santulenyu i klandè bnatuyu? Tay, too tukay i ksaligyu. ");
INSERT INTO bpr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Là kè galmabat gamu? Ta glifetyu gablà di lime batù fan, na kakaan i dad lime libu dad to, na i kdee been fananòyu mdà di lukasla? ");
INSERT INTO bpr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na ta glifetyu kè gablà di fitu batù fan na kakaan i fat libu dad to, na i kdee dad been fananòyu lê man mdà di lukasla? ");
INSERT INTO bpr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kan ku là glabatyu dun na ise ku btal fan i man-gu di gamu ani? Bay yé man-gu di gamu, fan-geyeyu i gambet bulung falnok fan i dad Farisi na dad Sadusi.” ");
INSERT INTO bpr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na yé klola galmabat ise ku btal bulung falnok fan i manan, bay yé fye fan-geyela i tdò dad Farisi na dad Sadusi. ");
INSERT INTO bpr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na kafnge ayé, salu ale Dyisas di dad malnak banwe mdadong di lunsud Sisarya Filipus. Na snalekan i dad to galan tdò, manan, “Dét man i dademe dad to gablà di do? Simto agu kun?” ");
INSERT INTO bpr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na tmimel ale, manla, “Yé man dademe ge Dyan Gal Munyag, na i dademe, manla ge Ilaydya, na i dademe, manla ge Dyérimaya, ku demen satu di dademe tugad Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na lêan ale snalek, manan, “Na gamu. Di fandamyu, simto agu kè?” ");
INSERT INTO bpr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na tmimel Simon Piter, manan, “Ge sa i Krayst, dunan i Mgalék Dwata. Na ge sa Ngà i Dwata too mto.” ");
INSERT INTO bpr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na talù Dyisas, manan, “Simon, ngà Dyona, too nun kafyem mdà di Dwata, du ise ku to i faglabat dun di ge, bay i Màgu ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na ani man-gu di ge. Ge Piter i satu batu, na di batu gufdak ani i guftadaggu i gumnègu. Na landè ti gamfisan dun, balù i fati. ");
INSERT INTO bpr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na blégu di ge i kunsì i Kagot Dwata di langit. Ku dét i fnangam dini di tah tanà, yé lê fnang Dwata di langit. Na ku dét i faloham dini di tah tanà, yé lê faloh Dwata di langit.” ");
INSERT INTO bpr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na kafnge ayé, lê fnang Dyisas ale tmulen di balù simto dun na kenen i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na mdà di du ayé, tambù Dyisas fgadè di dad to galan tdò gablà di fan mkel di kenen, manan, “Là ti fakay ku là gatù agu di Dyérusalém, na dee kaflayam mkel di do ditù mdà di dad tua gal mebe i dad to, na i dad ganlal di kafaglut, na dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. Na fnati dad to agu, bay lê agu mték di gatlun du.” ");
INSERT INTO bpr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na nebe Piter kenen di kilil, na nngakan, manan, “Nangam man ayé. Là fakay ku yé mkel di ge, Amu.” ");
INSERT INTO bpr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bay kmangél Dyisas, na manan di ku Piter, “Fawag ge di do, Satanas. Fanam nsang i knayè Dwata du ise mdà di Dwata i fandamam ayé, bay mdà di dad to.” ");
INSERT INTO bpr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na kafnge ayé, man Dyisas di dad to galan tdò, “Ku simto mayè magin di do, là fakay ku là lnifetan i kton, na tniangan i krusan, na magin do. ");
INSERT INTO bpr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Du ku simto kmabas i nawan, baling lanah di kenen. Bay ku simto mati du mdà di kaginan di do, nun nawan landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dét i fye untung i satu to ku gfunan i klamang banwe, bay là gfunan i nawa landè sen? Landè fakayan blé ku lulukan i nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Do, i dnagit Ngà To, fan agu samfulê, na mnè i kdatah Màgu di do, na magin dad kasaliganan. Na di du ayé, bnalasgu kat satu to mdà di dad nimòan. ");
INSERT INTO bpr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Too glut i man-gu di gamu ani. Nun dademe dad to tadag dini, là mati ale kel di kakel i Ngà To mgimò Harì.” ");
INSERT INTO bpr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na kafnge nam butang, lo yé fagin Dyisas Piter, Dyém, na Dyan, dunan i flanek Dyém, du salu ale di tah i satu mdatah bulul, lo dale. ");
INSERT INTO bpr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na tadè mgilih i baweh Dyisas déé di kitela dun. Too mneng i bawehan salngad neng i du, na tadè bukay i klawehan na samfilà. ");
INSERT INTO bpr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na tadè nun msut déé di dale lwe to, dunan Mosis na Ilaydya, na stulen ale Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na man Piter di ku Dyisas, “Amu, too fye du dini gami. Ku mayè ge, fdak agu tlu slung dini, satu di ge, satu ku Mosis, na lê satu ku Ilaydya.” ");
INSERT INTO bpr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na lam Piter talù, nun labun too mneng tadè lmimun dale. Na nun talù mdà di labun ayé, manan, “Ani i Ngàgu, i toogu kanbong nawa. Too fye nawagu dun. Falningeyu kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kantola linge i talù ayé, too ale likò, na tadè ale bek, na galfan ale di tanà mdà di klikòla. ");
INSERT INTO bpr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bay fdadong Dyisas, na nagotan ale, na manan, “Mték gamu. Nang gamu likò.” ");
INSERT INTO bpr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na kanto ale meye, ta lo Dyisas i teenla. ");
INSERT INTO bpr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Di kaflasokla di bulul, man Dyisas di dale, “Nangyu tayò tulen i ta teenyu ayé gine. Silangyu tulen ku ta mték agu di fati, dunan i dnagit Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na smalek dad to galan tdò di kenen, manla, “Dét duen man i dad to gal tamdò dad uldin Dwata fagu di ku Mosis na too mabtas ku muna kel Ilaydya klo i Mgalék Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na tmimel Dyisas, manan, “Too sa na yé muna kel Ilaydya du fatlagadan i kdee. ");
INSERT INTO bpr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bay ani man-gu di gamu, ta kel sa Ilaydya na là gadèla ku simto kenen, na ta nimòla di kenen i kdee knayèla nimò di kaflayamla kenen. Na salngad ayé i nimò dad to di do, dunan i dnagit Ngà To, du lêla agu falnayam.” ");
INSERT INTO bpr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na kanto linge dad to galan tdò i manan ayé, man nawala ku Dyan Gal Munyag i manan. ");
INSERT INTO bpr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na kanto ale samfulê di kdee dad to stifun, nun lagi fdadong di ku Dyisas, na lkuad di munan, manan, ");
INSERT INTO bpr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“E Amu, begam kando i ngàgu. Banlak kenen, na too sasè kaflayaman di tdukan ani, du tadè gal bek di lifoh na di lam éél. ");
INSERT INTO bpr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ta nebegu di dad to galam tdò, bay là gaganla dun.” ");
INSERT INTO bpr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na talù Dyisas, manan, “E tay gamu dad to là ftoo, too gamu gamsalà. Ta là manam i klogu fanak di safédyu, na toogu fantahà i nawagu di gamu, bay knèan, sana là fa kaftooyu. Nebeyu di do i ngà ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na kanto kel i ngà ayé di saféd Dyisas, dek Dyisas i busaw lamwà, na ta lamwà, na mgulê sa i ngà. ");
INSERT INTO bpr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na fdadong i dad to gal tdò Dyisas di kenen, lo dale, na smalek ale, manla, “Dét i duenmi là gmagan falwà i busaw atù gine?” ");
INSERT INTO bpr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na tmimel Dyisas, manan, “Du too tukay i ksaligyu. Too glut i man-gu di gamu ani, balù ku lo yé kalbong ksaligyu salngad i too tukay bnê mustasa, fakayyu man di bulul ani, ‘Mgilih ge mdà dini salu ditù,’ na mgimò i manyu ayé. Ku gambet ayé ksaligyu, gaganyu i kdee. ");
INSERT INTO bpr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Bay lo fagu di kdasal na di kafwasa gafalwàyu i busaw salngad ayé.”) ");
INSERT INTO bpr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na kanto stifun i kdee dad to gal tdò Dyisas di Galili, manan di dale, “Do, i dnagit Ngà To, fanla agu blé di kagot i dad to, ");
INSERT INTO bpr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na fnatila agu, bay di gatlun du, lê agu mték di fati.” Na yé duenam man, too mlidù nawa i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Salu Dyisas na i dad to galan tdò ditù di Kapernaum. Na nun dad to déé gal mwè i tabeng di Bong Gumnè Gumangamfù di Dwata, na smalek ale di ku Piter, manla, “I to gal tamdò gamu, gal kenen mlé tabeng di Bong Gumnè i Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na tmimel Piter, manan, “Mlé sa.” Na kanto fusuk Piter di lam i gumnè gufanakla, yé muna talù Dyisas, manan, “Simon, dét i ge fandam? Dini di tah tanà, simto i gal mlé bayad i buhis di harì, i dad ngàan ku demen i dademe dad to mnè di banwe ayé?” ");
INSERT INTO bpr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na tmimel Piter, manan, “I dademe dad to mnè di banwe ayé.” Na man Dyisas, “Ku yé, balù ta là mlé i dad ngà Harì. ");
INSERT INTO bpr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bay là mayè ate ku mahal fandam i dad to mwè tabeng ani. Taman, gatù ge di lanaw, na dmulé ge. Na dyolam i tnanin nalaf gwèam, na banngatam i bàan, du déé gumitem filak bléta. Nwèam na blém di dale.” ");
INSERT INTO bpr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na di du ayé, fdadong dad to gal tdò Dyisas di kenen, na smalek ale, manla, “Simto i too mdatah di Kagot i Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na tlo Dyisas satu tukay ngà, na ftadagan di blengla, ");
INSERT INTO bpr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na manan, “Too glut i man-gu di gamu ani. Silang gamu gfusuk di Kagot Dwata di langit ku matlas i ktoyu na salngad gamu i dad malnak ngà. ");
INSERT INTO bpr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yé too mdatah di Kagot Dwata dunan i to toon fdanà i kton salngad i ngà ani. ");
INSERT INTO bpr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na ku simto dmawat i satu ngà gambet ani du mdà di ksasatun di do, lêan agu dnawat. ");
INSERT INTO bpr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ku simto i baling gumdà i dademe gamsalà, too kenen falnayam. Kaflingenta dun, di laman là fa gamsalà i satu to mdà di kenen, balù i dad mdanà to, baling fye fa ku ikat di lialan i giling batu na fnge bat kenen di talà mahin. ");
INSERT INTO bpr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Magakdo i dad to di klamang banwe du nun gal gamftatek dale di salà. Bay too magakdo i to gumdà i dademe dad to baling gamsalà, du too kenen falnayam. ");
INSERT INTO bpr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na kaflingenta dun, ku bali sigalam ku demen bali blìam mebe ge di kagsalà, yé baling fye ku kanlangam na batam. Tumù fa ku fatok ge na nun nawam landè sen, bay too sasè ku sikof i sigalam na blìam, na baling ditù gugtadèam di lanaw lifoh landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na ku bali matam mebe ge di kagsalà, yé baling fye ku tanwilam na batam. Tumù fa ku landè i bali matam na nun nawam landè sen, bay too sasè ku sikof i matam, na baling ditù gugtadèam di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Too gamu fgeye du fye là mdanà keyeyu i dad ngà gambet ani. I dad kasaliganla ditù di langit, klola to mnè di saféd Màgu. ");
INSERT INTO bpr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Na do, i dnagit Ngà To, yé duen-gu salu dini di tah tanà du falwàgu i dad to ta lanah.) ");
INSERT INTO bpr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Di gamu fandam, dét i nimò satu to ku mlatuh i kdee dad bilibilin na baling lanah i satu? Tnagakan i syem falò syem di gumatebla du fanngabalan i lanah. ");
INSERT INTO bpr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na too glut i man-gu di gamu ani, ku teenan i satu bilibili ayé, too kenen lehew. Baling tukay fa klehewan di syem falò syem i là lanah. ");
INSERT INTO bpr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na salngad ayé, là mayè Màyu di langit ku nun lanah di dad ngà gambet ani.” ");
INSERT INTO bpr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ku nun dademe to gamsalà di ge, gatù ge di kenen, na faglabatam dun di lo gamu lwe ku dét i gugamsalàan di ge. Ku falningen ge, ta gebem i flanekam ayé. ");
INSERT INTO bpr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bay ku là falningen ge, mebe ge satu ku demen lwe dademe dad to, na samfulê ge di kenen du fye nun lwe ku demen tlu to glam di kastulenyu. ");
INSERT INTO bpr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ku là falningen ale, tulenam di dad to ftoo. Na ku là falningen i dad to ftoo, yé fye kibòyu dun fasalngadyu di dad to là ftoo ku demen dad to gal mwè bayad i buhis. ");
INSERT INTO bpr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Too glut i man-gu di gamu ani, ku dét i fnangyu dini di tah tanà, yé lê fnang Dwata ditù di langit. Na ku dét i falohyu dini di tah tanà, yé lê faloh Dwata ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na lêgu tulen di gamu, ku lwe gamu dini di tah tanà nun ksasatu nawayu gablà di satu fniyu, blé i Màyu di langit i fniyu ayé. ");
INSERT INTO bpr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Du balù nè gustifun i lwe ku demen tlu to du mdà di ksasatula di do, déé agu di safédla.” ");
INSERT INTO bpr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na fdadong Piter di ku Dyisas, na smalek kenen, manan, “E Amu, file dulêgu fmasinsya salà i dademe to? Fitu dulê kè?” ");
INSERT INTO bpr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Bay tmimel Dyisas, manan, “Ise ku lo fitu dulê, bay kel di fitu falò dulêan fitu. ");
INSERT INTO bpr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yé duenan du i Kagot Dwata nun gusalngadan di satu harì meye dad uteng i dad snaligan di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na di katbùan meye dad uteng ani, nun nebela satu snaligan di kenen. Yé utengan dad file lagsà filak. ");
INSERT INTO bpr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na kanto là gbayadan i utengan ani, taman yé flau i amun di dademe dad to na fablila i to nun uteng ani salngad i fasak, magin yaanan, na dad ngàla, na balù i kdee knunla du bayad i bong utengan. ");
INSERT INTO bpr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bay lkuad i snalig ani di muna i amun, na too fakdo, manan, ‘Begam fantahà i nawam di do du bnayadgu i kdee utenggu.’ ");
INSERT INTO bpr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na kando i amun, taman fnasinsyan i kdee utengan, na falwàan kenen. ");
INSERT INTO bpr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na ta mdà i satu snalig ani, na nun gsitongan satu di dademen snalig nun tukay utengan di kenen. Fanlangan i snalig ani, na manan, ‘Bnayadam i utengam di do!’ ");
INSERT INTO bpr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na lkuad i snalig ani di munan, na fakdo kenen, manan, ‘Begam fantahà i nawam di do du bnayadta ge.’ ");
INSERT INTO bpr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bay là mayèan, na yé balingan nimò fablanggùan i snalig ani kel di kagbayadan i utengan. ");
INSERT INTO bpr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Na kanto gadè dademe dad snalig gablà di mkel ayé, too ale mlidù, na gatù ale di amula du tulenla. ");
INSERT INTO bpr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na ta fatlo amu i tnanin snaligan ayé, na manan, ‘Landè gukelam. Ta fnasinsyagu i too bong utengam lo mdà di kafakdom di do. ");
INSERT INTO bpr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na gablà ku lêam kando i dademem, salngad kakdogu ge.’ ");
INSERT INTO bpr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Too ti flabè i amu, na fablanggùan i snaligan ayé fye maflayam kenen kel di kagbayadan i kdee utengan.” ");
INSERT INTO bpr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na kafnge Dyisas tmulen i fléd ani, manan, “Salngad ayé nimò i Màgu di langit di kat satu gamu ku là mdà di nawayu fmasinsya salà i dademe to.” ");
INSERT INTO bpr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kafnge Dyisas tamdò, tnagakan Galili, na salu kenen ditù di Dyudiya di faltù Éél Dyordan. ");
INSERT INTO bpr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na dee dad to lmalò kenen, na fan-gulêan dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na nun dad Farisi salu di kenen du snalekla, manla, “Fakay kè ku i lagi kahan i yaanan, balù dét i duenan?” Snalekla ani du ani nimòla dalan tmifù ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na man Dyisas di dale, “Là lmenyu kè masa gablà di nimò Dwata di kimòan i klamang banwe di munan? Di katbùan, nimò Dwata lagi na libun. ");
INSERT INTO bpr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ani manan, ‘Ani duen i lagi tmagak i màan na yêan na sasatu kenen di yaanan, na lwe ale mgimò satu. ");
INSERT INTO bpr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na ta ise ku lwe ale, bay ta lo ale satu. Yé duenam man, ku dét i ta sansatu Dwata, là fakay ku nun to samkah dale.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Na lê smalek i dad Farisi, manla, “Ku yé kagkah, dét duen Mosis faloh i lagi smulat di yaanan gugmadè dun na ta kahan na kafnge ayé, fakayan fdà?” ");
INSERT INTO bpr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na tmimel Dyisas, manan, “Yé duen Mosis faloh gamu mkah yaanyu du magéng uluyu. Bay mdà di katbù i klamang banwe, ise ku yé kgagun. ");
INSERT INTO bpr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na yé duenam man, man-gu di gamu, nè i lagi mkah i yaanan na lê mwè mahal libun balù là lnafà yaanan dun, kenen i lmafà.” ");
INSERT INTO bpr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na man dad to galan tdò di kenen, “Ku gambet ayé i kagkah, tumù fa nang ato mwè yaan.” ");
INSERT INTO bpr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na tmimel Dyisas, manan, “I manyu ayé, là gdawat dademe dad to dun. Lo yé gmagan lmalò i manyu ayé i dad to gumlé Dwata dun. ");
INSERT INTO bpr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Du nun dad sahal duen i dad to là mwè yaan. I dademe, nun gukulang di lawehla mdà di ksutla. Na nun dademe knafun. Na nun dademe, là mwè ale yaan du mdà di kabléla i ktola di Kagot i Dwata. Na ku simto gmagan mimò ani, fye ku dnawatan i tdògu ani.” ");
INSERT INTO bpr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na kafnge ayé, nun dad to mebe dad ngàla di ku Dyisas du fye nagotan ale na dnasalan. Bay i dad to galan tdò, nngakla i dad to ayé. ");
INSERT INTO bpr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na man Dyisas, “Falohyu i dad ngà salu di do na nangyu ale fnang du i dad to nun ksalig salngad i dad ngà ani, gfusuk ale di Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na kafngen magot dale du banlén ale kafye, ta lê mdà. ");
INSERT INTO bpr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Di satu du, nun lagi salu di ku Dyisas, na smalek kenen, manan, “Sér, dét i fye nimògu fye gfun-gu i nawa landè sen?” ");
INSERT INTO bpr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na tmimel Dyisas, manan, “Dét i duenam smalek do ku dét i fye? Lo satu i fye, dunan Dwata. Ku mayè ge gamdawat nawa landè sen, nimenam i kdee dad uldin Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na smalek kenen, manan, “Dét i dad uldin i manam ayé?” Na tmimel Dyisas, manan, “Nang ge manò, nang ge lmafà yaan, nang ge tmaku, na nang ge tmulen kéng. ");
INSERT INTO bpr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nafèam i màam na yêam, na kanbongam nawa i dademe to salngad kalbong nawam i ktom.” ");
INSERT INTO bpr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na man i lagi ayé, “Ta nimen-gu i kdee uldin ayé. Dét fa i gdè nimògu?” ");
INSERT INTO bpr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na tmimel Dyisas, manan, “Ku mayè ge na too ge tluh, mdà ge na fablim i kdee dad knunam, na blém i wèan di dad to landè knun. Na mdà déé, nun bong knunam ditù di langit. Na kafnge ayé, magin ge di do.” ");
INSERT INTO bpr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bay i to ayé, kanton linge i man Dyisas, ta mdà kenen na mlidù nawan du too bong knunan. ");
INSERT INTO bpr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na yé duenam man, man Dyisas di dad to galan tdò, “Too ti glut i man-gu di gamu ani. Too mlimah gfusuk di Kagot Dwata di langit i dad to nun bong knun. ");
INSERT INTO bpr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Glut ani, du ku mlimah di satu bong lmanaf dnagit kamél fusuk di sol i dalum, mas mlimah fa i satu to nun bong knun gfusuk di Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na kantola linge i manan ayé, too ale tngah, na smalek ale, manla, “Ku gambet ayé, simto i fakay galwà?” ");
INSERT INTO bpr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na too meye Dyisas di dale, na manan, “Di dad to, là gagan ani, bay di Dwata gagan i kdee.” ");
INSERT INTO bpr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na talù Piter, manan, “Neyem, ta tnagakmi kdee du magin gami di ge. Dét i gdawatmi?” ");
INSERT INTO bpr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na tmimel Dyisas, manan, “Too glut i man-gu di gamu ani. Di kfalami Dwata i kdee, na do dnagit Ngà To, sudeng agu di trunugu. Na di bang ayé, gamu dad to galgu tdò, lê gamu sudeng di sfalò lwe dademe trunu du gamu mukum i dad to mdà di dad sfalò lwe lumbuk bel Israél. ");
INSERT INTO bpr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na nè i to tmagak i gumnèan, ku demen i dad flanekan, ku demen màan, ku demen yêan, ku demen dad ngàan, ku demen tanàan du mdà di ksasatun di do, too ti bong gdawatan di du ani, na kadang di fulé du, gamdawat kenen nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bay dee dad to mdatah di mdu ani mbaling ale mdanà kadang di fulé du. Na dee dad to mdanà di mdu ani mbaling ale mdatah kadang di fulé du. ");
INSERT INTO bpr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“I Kagot Dwata di langit salngad di kagot satu to mfun tanà gumelen dad benge grép. Lamwà kenen di too flafus, na nun nalékan dademe dad to fakayan fatalbahò di tanàan. ");
INSERT INTO bpr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yé fakangan di dale na yé kalbong sukéyla i gal sukéy di sdu, na dekan ale tambù i nimòla di tanàan ayé. ");
INSERT INTO bpr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na kanto tngà mnagad i du, lê kenen lamwà, na nun teenan dad to di fadyan, lo tadè ale tadag na landè nimòla. ");
INSERT INTO bpr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na talù kenen di dale, manan, ‘Magin gamu talbahò di tanàgu, na tanblàgu i sukéyta gamu.’ ");
INSERT INTO bpr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Taman, ta mdà ale. Na di ltu du na lê man di tngà masol i du, lê salngad ayé i nimòan di dademe dad to teenan. ");
INSERT INTO bpr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na di fan kasdaf i du, lê kenen salu di fadyan, na lê nun teenan dademe dad to lo tadè tadag na landè nimòla. Na snalekan ale, manan, ‘Dét i duenyu lo fanak tnadak i du?’ ");
INSERT INTO bpr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na tmimel ale, manla, ‘Du landè fatalbahò gami.’ Na manan dale, ‘Magin gamu talbahò di tanàgu.’ ");
INSERT INTO bpr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na kanto kifuh, man i amu di to magot i sukéy, ‘Tlom dad to talbahò na snukéyam ale. Funam snukéy i dad fulé tambù na sngé kel di dad muna tambù.’ ");
INSERT INTO bpr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na kanto kel dad to tambù talbahò di ta fan kasdaf i du, yé sukéy gwèla i gal sukéy di sdu. ");
INSERT INTO bpr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taman, kanto kel dad to muna tambù di flafus, yé fandamla ku bong fa déé i dale sukéy. Bay kat satu dale, yé gwèla i gal sukéy di sdu. ");
INSERT INTO bpr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na di kdawatla dun, ta tambù ale sungag gablà di nimò i to mfun i tanà. ");
INSERT INTO bpr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Manla, ‘I dad to fulé tambù, lo satu oras i klola talbahò, bay fasalngadam ale di gami, na blaam ta tnadakmi i du talbahò di bong kinit.’ ");
INSERT INTO bpr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bay tmimel kenen, manan di satu di dale, ‘Flanek, là sa lnumìta gamu. Ise glut kè, na yé kasafnèto na i gal sukéy di sdu, yé sukéyta gamu? ");
INSERT INTO bpr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nwèyu sukéyyu na mdà gamu. Yé kayègu ku dét i blégu di gamu, yé lêgu blé di dad to fulé kel. ");
INSERT INTO bpr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Landè ktoogu kè magot i filakgu? Mafè nawayu kè du too agu mayè mlé?’ ");
INSERT INTO bpr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yé duenam man, nun dad to fulé baling dale guna, na nun dad to muna baling dale gfulé.” ");
INSERT INTO bpr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na mnagad ale Dyisas ditù di Dyérusalém. Na di laman magu, neben fatfing i dad sfalò lwe to galan tdò, na manan di dale, ");
INSERT INTO bpr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ta fan ato kel di Dyérusalém, na do, i dnagit Ngà To, bléla agu di kagot i dad ganlal di kafaglut i dad Dyu na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na nukumla agu di fati. ");
INSERT INTO bpr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na bléla agu di dad to ise Dyu, du nadoyla agu, na nfasla agu, na fnatakla agu di krus. Bay di gatlun du, lê agu mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na kafnge ayé, fdadong di ku Dyisas i yaan Sébidi, dunan i yê Dyém na Dyan, na magin dad ngàan. Lkuad kenen di muna Dyisas na fakdo di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na smalek Dyisas, manan, “Dét i kayèam?” Na manan, “Makang ge di do na yé gufsudengam i lwe ngàgu ani di safédam ku ta gdawatam i kdataham kadang di fulé du, satu gsen di kwananam na satu gsen di bibengam.” ");
INSERT INTO bpr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bay man Dyisas di dale, “Là gadèyu ku dét i fniyu. Gaganyu kè tmufì minum di basù guminumgu, dunan i dad kaflayam gnagugu?” Na tmimel ale, manla, “Gaganmi sa.” ");
INSERT INTO bpr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na man Dyisas di dale Dyém na Dyan, “Too glut, gamginum gamu di basù guminumgu, bay landè ktoogu fsudeng ku simto gsen di kwanan-gu na gsen di bibenggu. I dad gusudeng ani lo tagà Mà di dad to gutmagàan dun.” ");
INSERT INTO bpr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kanto gadè i sfalò dademe dad to gal tdò Dyisas gablà di fnila ayé, lanbutla i lwe saflanek ani. ");
INSERT INTO bpr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na santifun Dyisas i kdeela, na manan di dale, “Ta gadèyu i gal nimò dad ganlal dini di tah tanà. Galla lnumì i dad to mdanà, na toola ale gal dek. ");
INSERT INTO bpr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bay fye ku mahal i nimòyu gamu. Ku simto mayè mdatah, là fakay ku landè nimòan di dademe. ");
INSERT INTO bpr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na ku simto i mayè mdatah, là fakay ku là fafasakan i kton di dademe. ");
INSERT INTO bpr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Du balù do i dnagit Ngà To, ise ku yé duen-gu salu dini di tah tanà ku fifat agu di dad to. Bay yé duen-gu salu dini du do mifat i dad to na blégu i ktogu di fati mayad dad salà du fye dee dad to galwà.” ");
INSERT INTO bpr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na mdà ale Dyisas fdu di banwe Dyériko, na nun mlabung dad to magin di dale. ");
INSERT INTO bpr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na nun lwe to butè sudeng di kilil dalan. Kantola linge na Dyisas i magu déé, mkit ale, manla, “E Amu, Bel i Harì Dabid, begam gami kando.” ");
INSERT INTO bpr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bay nngak i dad to ale du kayèla ku fanak ale, bay baling midul kbong kitla, manla, “E Amu, Bel Dabid, begam gami kando.” ");
INSERT INTO bpr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na yé duenam man, tadè fanak Dyisas, na tlon ale, klon smalek dale, manan, “Dét i kayèyu nimògu di gamu?” ");
INSERT INTO bpr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na tmimel ale, manla, “Amu, yé kayèmi moon ku mite gami.” ");
INSERT INTO bpr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na kando Dyisas ale, na nagotan dad matala. Na tadè ale mite, na fles ale magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ta mdadong ale Dyisas di Dyérusalém, na ta kel ale di tukay banwe Bétfagi di Bulul Olib. Na dek Dyisas muna lwe dad to galan tdò, ");
INSERT INTO bpr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na manan di dale, “Fles gamu di tukay banwe gsen munayu, na ku ta kel gamu ditù, nun teenyu dongki batangla déé magin i ngàan. Ntehyu ale, na nebeyu dini. ");
INSERT INTO bpr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na ku nun to smalek gamu, manyu dun, ‘Nun gukmamu i Amu dun,’ na yé klon mayà dun gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yé duenan mkel ani du fye gdohò i man Dwata fagu di satu tugadan di munan, ");
INSERT INTO bpr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fgadèam di dad to di Dyérusalém, manam, ‘Neyeyu, du kel i Harìyu di gamu. Toon fdanà i kton, na yé snakayan ngà i dongki.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na ta mdà dad to dekan ayé, na nimenla i man Dyisas di dale. ");
INSERT INTO bpr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nebela i dongki na i ngàan salu di ku Dyisas, na yé afidla dun i dademe dad klawehla, na ta smakay Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Di lamla magu, nun dee dad to mbel i klawehla di bà dalan, na i dademe, nkahla dad fanga kayu du mdà di kdayenla di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nun dad to muna di ku Dyisas na nun dademe tmadol, na tamlo ale, manla, “Dnayento i Bel Dabid! Magdayen i To salu dini di dagit i Dwata! Magdayen i Dwata du too mdatah.” ");
INSERT INTO bpr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na kanto kel ale Dyisas di Dyérusalém, too tikeng i dad to déé, na smalek ale, manla, “Simto i to ani?” ");
INSERT INTO bpr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na tmimel i dad to magin, manla, “Dyisas ani, i Tugad Dwata mdà di Nasarét di Galili.” ");
INSERT INTO bpr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Fusuk Dyisas di Bong Gumnè Gumangamfù di Dwata, na ndalan lamwà i kdee dad to sbayad déé. Na lugadan dad lamisa i dad to sasambì filak na lê man gusudeng i dad to gal fabli dad abun galla dsù. ");
INSERT INTO bpr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na manan di dale, “Ta gsulat di Tnalù Dwata, manan, ‘I Gumnègu ani, yé gukmamu dun gal gudmasal,’ bay ta fanbalingyu gumnè i dad to lmimbung.” ");
INSERT INTO bpr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na nun dad butè na dad kimay fdadong di kenen déé di gumnè ayé, na fan-gulêan ale. ");
INSERT INTO bpr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bay baling malbut dad ganlal di kafaglut i dad Dyu na dad to gal tamdò dad uldin Dwata fagu di ku Mosis. Yé duenla malbut du ta teenla dad tnikeng nimòan, na ta lingela i katlo dad ngà di kmanla, “Magdayen i Bel Dabid.” ");
INSERT INTO bpr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Na smalek ale di ku Dyisas, manla, “Là lingem kè i man dad ngà ani?” Na tmimel Dyisas, manan, “Hee sa. Sawe là lmenyu masa ani di Tnalù i Dwata, manan, ‘Tdò Dwata dad ngà, balù i dad too malnak, du fye dnayenla kenen.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na tnagakan ale, na lamwà kenen di syudad du fles ditù di banwe Bétani, na déé gumilèan di kifuh. ");
INSERT INTO bpr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Di too flafus, ta mdà ale Dyisas samfulê di Dyérusalém. Na di kagun gatù, ta bitil kenen. ");
INSERT INTO bpr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na nun teenan kayu dnagit fig di saféd dalan, na fdadong kenen déé, bay landè benge teenan lo doon. Na man Dyisas di kayu ayé, “Ta là fakay ge menge.” Na di kmanan ayé, tadè mlanas i kayu ayé. ");
INSERT INTO bpr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kite dad to galan tdò ayé, tikeng ale, na smalek ale, manla, “Dét duen i kayu ani too mlal mlanas?” ");
INSERT INTO bpr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na tmimel Dyisas, manan, “Too glut i man-gu di gamu ani, ku ftoo gamu na là lwe nawayu, gaganyu nimò i ta nimògu di kayu ani gine. Na ise ku lo ayé, bay fakayyu man di bulul ani, ‘Magket ge na mgilih ge gatù di talà mahin,’ na gdohò i manyu ayé. ");
INSERT INTO bpr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ku ftoo gamu, balù dét i fniyu di dasalyu, gdawatyu.” ");
INSERT INTO bpr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lê samfulê ale Dyisas di lam i Bong Gumnè Gumangamfù di Dwata. Na di laman tamdò, salu di kenen i dad ganlal di kafaglut i dad Dyu, na i dad tua gal mebe i dad Dyu. Na smalek ale, manla, “Dét i ktoom mimò i kdee nimòam dini? Na simto mlé ge glal?” ");
INSERT INTO bpr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na tmimel Dyisas, manan, “Lê nun snalekgu di gamu. Na ku gtimelyu, lêgu tulen di gamu ku dét i ktoogu mimò ani. ");
INSERT INTO bpr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gablà di kbunyag Dyan, nè gumdà i glalan kenen, mdà di Dwata di langit, ku demen mdà di dad to di tah tanà?” Na stulen ale, manla, “Ku yé manto, ‘Mdà di Dwata di langit,’ snalekan gito, na manan, ‘Kan ku là fantooyu Dyan?’ ");
INSERT INTO bpr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bay là fakay ku yé manto, ‘Mdà di dad to,’ du likò ato di dademe dad to du yé man i kdeela na Dyan i satu tugad Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yé duenam man, tmimel ale, manla, “Là gadèmi dun.” Na manan di dale, “Lê là tulenta gamu ku dét ktoogu mimò i dad nimògu. ");
INSERT INTO bpr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Dét i fandamyu gablà ani? Nun satu lagi, lwe ngàan. Manan di twege, ‘Tò, mdà ge talbahò di tanàgu.’ ");
INSERT INTO bpr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na tmimel i ngàan, manan, ‘Là mayè agu,’ bay baling matlas i fandaman na mdà kenen talbahò. ");
INSERT INTO bpr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na lê salngad man i lagi di ngàan twali. Na tmimel i ngàan ayé, manan, ‘Hee, Mà,’ bay là nimòan dun. ");
INSERT INTO bpr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Di dad lwe ngà ani, simto i mimen di knayè i màla?” Tmimel ale, manla, ‘I twege.’ Na man Dyisas di dale, “Too glut i man-gu di gamu ani, i dad to man nawayu too sasè gambet i dad to mwè bayad i buhis na i dad libun gal mkat lagi, muna ale di gamu gfusuk di Kagot Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Du Dyan Gal Munyag, yé duenan salu dini du fye fiten di gamu dalan i katluh, bay là fantooyu dun. Baling yé ftoo di manan i dad to mwè bayad i buhis na i dad libun gal mkat lagi. Na balù teenyu i dale kaftoo, knèan là msal gamu na là ftoo gamu di tdòan. ");
INSERT INTO bpr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Lê gamu flinge di satu fléd. Nun satu lagi mfun tanà, na mele kenen walad dnagit grép. Lnabatan i dad felen, na makol kenen di bong batu du gumlék i bengen. Na lêan fdak i mdatah gumnè gufanak i to mantay i dad felen ani. Na kafnge ayé, fagotan i dad felen di dademe dad to du salu kenen di satu banwe. ");
INSERT INTO bpr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na kanto kel di bangla mles i bengen, dekan i dad fasakan salu ditù di tanàan du fye nwèla i kenen alel. ");
INSERT INTO bpr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bay i dad to gufagotan i felen, kanfèla dad fasakan. Nfasla satu, fnatila satu, na ndakla batu i satu. ");
INSERT INTO bpr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na lêan dek dademe dad fasakan, ta too ale dee, na lê salngad i nimòla di dale. ");
INSERT INTO bpr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na kanto kel di gusenan, dekan i ngàan salu di dale. Na yé manan di kton, ‘Nafèla sa i ngàgu.’ ");
INSERT INTO bpr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bay kantola teen i ngàan, stulen ale, manla, ‘Ani ngà i to mfun dad fele. Fnatito kenen du fye ku ta mati màan, ta gito gamfun i dad felen.’ ");
INSERT INTO bpr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yé duenam man, kanfèla kenen, na nebela ditù di lwà i tanà gumele grép klola fmati dun.” ");
INSERT INTO bpr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na smalek Dyisas, manan, “Ku ta kel i mfun fele ani, dét kè kibòan i dad to gufagotan i felen?” ");
INSERT INTO bpr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na tmimel ale, manla, “Yé nimòan di dad sasè to ani, fnatin i dad to gufagotan dad felen, na tanlasan ale. Na yé tlasan dunan dad to mayè mlé i kenen alel.” ");
INSERT INTO bpr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na lê talù Dyisas di dale, manan, “Sawe là lmenyu masa i fléd di Tnalù Dwata, manan, ‘Nun gumnè slame batu, na i satu batu déé too mabtas, yé baling knang i dad to fdak gumnè. Blaam, i batu ani, yé gumdàan di Dwata, na too ti gamtikeng.’ ");
INSERT INTO bpr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na yé duenam man, ani man-gu di gamu, lê nawì i Kagot Dwata di gamu na blén di dad to menge fye. ");
INSERT INTO bpr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ku simto gdauf di batu ani, malmo kenen, na ku simto tankan i batu ani, mlunah kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na kanto linge dad ganlal di kafaglut i dad Dyu na dad Farisi i dad fléd Dyisas ani, gadèla na dale i gugtadèan. ");
INSERT INTO bpr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mngabal ale kfagu kamfè ku Dyisas, bay likò ale di dademe dad to du yé manla na kenen satu tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na lê talù Dyisas fagu di fléd, manan, ");
INSERT INTO bpr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“I Kagot Dwata di langit salngad di satu harì mimò fista di ksong i ngàan lagi. ");
INSERT INTO bpr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dekan dad snaligan du nngéla dad to nlakan, bay là mayè ale. ");
INSERT INTO bpr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na kafnge ayé, ta lêan dek dademe dad snaligan, manan di dale, ‘Tooyu tulen di dale na ta gatlagad i bong knaan. Ta ftatêgu i dad malbang safìgu na lê man i dad ngà safì ta fabùgu. Ta gatlagad i kdee. Tooyu ale fagin gadini.’ ");
INSERT INTO bpr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bay là falningela i dad snaligan ani, na baling ale mdà. I satu salu di tanàan, na i satu di tindan. ");
INSERT INTO bpr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na i dademe, kanfèla dad snaligan, na fatdukla ale, na fnatila ale. ");
INSERT INTO bpr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na too malbut i harì ani. Dekan dad sundalun fmati dad to ani, na mtam i syudad gumnèla. ");
INSERT INTO bpr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na kafnge ayé, ta manan di dad snaligan, ‘Ta gatlagad i knaan di ksong ani, bay i dad to munagu nlak, là gten ale magin. ");
INSERT INTO bpr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gatù gamu di dad dalan, na nlakyu i kdee dad to teenyu.’ ");
INSERT INTO bpr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yé duenam man, ta mdà dad snaligan ani, na salu ale di dad dalan du santifunla i kdee teenla, balù fye to ku demen sasè to, na ta fnò to i gumnè gufista. ");
INSERT INTO bpr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Na ta fusuk i harì du dnawatan i dad to salu déé, bay nun teenan satu to là lamsakan klaweh di ksong. ");
INSERT INTO bpr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na manan, ‘E flanek, dét kibò kagfusukam dini du là lamsak ge klaweh di ksong?’ Na là gtalù i to ayé. ");
INSERT INTO bpr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na tlo harì i dad snaligan, manan, ‘Bnakusyu dad sigal na dad blì i to ani, na batyu kenen ditù di lwà di gukmifuhan, dunan di gumngel dad to na gukminggat i kifanla.’ ");
INSERT INTO bpr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na fannge Dyisas i flédan, manan, “Dee dad to nlak, bay là dee i mgalék.” ");
INSERT INTO bpr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na kafnge ayé, lamwà dad Farisi du santulenla i kfagula kamfè ku Dyisas fagu di ksalekla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dekla dademe dad to galla tdò na lê man dademe dad to gal msen ku Hérod. Na i dad to dekla ayé, yé manla di ku Dyisas, “E Sér, ge satu to too gsalig, na too ti glut i katdòam i dalan Dwata. Là fkaham di nawam i man dad to di ge du là sa mabtas di ge ku dét i glalla. ");
INSERT INTO bpr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dét i fandamam? Fakay kè di uldin Dwata fagu di ku Mosis ku mlé gami bayad i buhis di ku Sisar, i gumdatah di Roma, ku demen là?” ");
INSERT INTO bpr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bay gadè Dyisas i sasè fandamla, taman manan, “Gamu dad to flingu. Kan ku lnimanyu agu? ");
INSERT INTO bpr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Fiteyu do i satu filak galyu bayad i buhis di Roma.” Na mwè ale satu filak na fitela ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na snalekan ale, manan, “Simto i to teenyu di filak ani, na simto mfun dagit i ta gsulat dini?” ");
INSERT INTO bpr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na tmimel ale, manla, “Ku Sisar.” Na manan di dale, “Ku dét i nfun Sisar, bléyu ku Sisar, na ku dét i nfun Dwata, blêyu di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Na kantola linge i timelan ayé, too ale tikeng. Na yé duenam man, tnagakla kenen na ta mdà ale. ");
INSERT INTO bpr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na di du ayé, nun dad Sadusi salu di ku Dyisas. (Dale i dad to man dun na landè mték di fati.) ");
INSERT INTO bpr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Na smalek ale, manla, “E Sér, di munan, smulat Mosis, na yé flaun ku nun lagi mati bay landè ngàla, là fakay ku là nwè twalin lagi i libun ayé du fye nun tubad i twegen. ");
INSERT INTO bpr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na di munan kun, nun fitu lagi saflanek. Mwè yaan i twege, bay mati na landè ngàla. Na yé duenam man, lê nwè i twalin. ");
INSERT INTO bpr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Salngad ayé i lê mkel di twalin ayé na di galwen na sngé kel di sangal twali. ");
INSERT INTO bpr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na kafnge ayé, ta mati i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ani i snalekmi. Di kték i dad mati, simto i too yaan i libun ayé di fitu lagi saflanek?” ");
INSERT INTO bpr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na tmimel Dyisas, manan, “Too gsalà i fandamyu du là gadèyu i Tnalù Dwata na i kaltulusan. ");
INSERT INTO bpr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ku ta mték i dad mati kadang di fulé du, ta landè swè yaan, balù lagi ku demen libun. Bay yé ta kagkahla salngad ale di dad kasaligan di langit. ");
INSERT INTO bpr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na gablà di kték i dad mati, sawe là lmenyu masa man Dwata ani di gamu, ");
INSERT INTO bpr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Do i Dwata fnangamfù Abraham, Isaak na Dyékob.’ Na yé kayèan man dini kenen Dwata fnangamfù i dad to mlawil fa, ise ku i dad mati.” ");
INSERT INTO bpr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na kanto linge i kdee dad to ayé, too ale tikeng di katdòan. ");
INSERT INTO bpr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na kafnge ayé, ta stifun dad Farisi du ta lingela na ta là gtalù i dad Sadusi du mdà di dad timel Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na nun satu di dale i too gmadè dad uldin Dwata. Tnilewan Dyisas fagu di salek, manan, ");
INSERT INTO bpr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“E Sér, di kdee dad uldin Dwata, nè i too mabtas dé?” ");
INSERT INTO bpr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na tmimel Dyisas, manan, “ ‘Kanbongyu nawa i Amuyu Dwata mdà di nawayu, na di fandamyu, na di kaglabatyu.’ ");
INSERT INTO bpr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ani i too mdatah na too mabtas di kdee uldin Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na i gamtadol uldin too mabtas, nun gusalngadan di muna, na dunan ani, ‘Kanbongyu nawa i dademe to salngad kalbong nawayu i gamu kto.’ ");
INSERT INTO bpr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I lwe uldin ani, yé gumdà i kdee dademe dad uldin Dwata fagu di ku Mosis, na lê man dademe dad tdò i dad tugad Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na di tlabo stifun i dad Farisi, snalek Dyisas ale, manan, ");
INSERT INTO bpr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Dét i fandamyu gablà di Mgalék Dwata? Simto gutambulan?” Na tmimel ale, manla, “Kenen i Bel Dabid.” ");
INSERT INTO bpr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na manan di dale, “Ku gambet ayé, kan ku nalak Tulus Dwata Dabid tamlo di kenen ‘Amu’? Ani i manan di munan, ");
INSERT INTO bpr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Man Dwata di Amugu, “Sudeng ge gsen di kwanan-gu, dunan i gufdatahta ge, kel di kafkahgu i dad to muteh ge nawa di dungan falel blìam.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ku yé katlo Dabid di Mgalék Dwata, ‘Amu,’ kan ku yé katloyu kenen Bel Dabid?” ");
INSERT INTO bpr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na landè gamtimel, na mdà di du ayé, ta landè lê mlas smalek kenen. ");
INSERT INTO bpr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na kafnge ayé, talù Dyisas di mlabung dad to, na lê man di dad to galan tdò, manan, ");
INSERT INTO bpr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I dad to gal tamdò dad uldin Dwata fagu di ku Mosis na lê man dad Farisi, dale i nun glal mubad i dad uldin Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yé duenam man, là fakay ku là nimenyu i kdee dad uldinla. Bay, nangyu ganbet dad nimòla du là maslalò i nimòla di dad tdòla. ");
INSERT INTO bpr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Salngad ku nun blat ftiangla di dad to, bay là ti tnabengla ale mebe, balù tukay. ");
INSERT INTO bpr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Toola falbang dad gufkahla i gusmulatla Tnalù Dwata galla batang di ulula na di sigalla. Na ftahàla i fayolla di kilil i klawehla. Yé duenla mimò i kdee ani du lola fite di dad to. ");
INSERT INTO bpr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na yé kayèla ku nafè i dad to ale fagu di kafsudengla dale di gusudeng i dad to mdatah di dad fista na di dad gumnè gal gustifun i dad to. ");
INSERT INTO bpr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na yé toola kanbayan ku nafè i dad to ale di fadyan, na ku yé katlo dale ‘Sér.’ ");
INSERT INTO bpr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bay là fakay ku yé katlo dad to gamu, ‘Sér,’ du saflanek gamu na lo satu i Tamdò gamu. ");
INSERT INTO bpr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na là fakay ku yé katloyu di dademe to ‘Mà,’ du lo satu Màyu, dunan i mnè di tah langit. ");
INSERT INTO bpr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na lê là fakay ku yé katlo dad to gamu, ‘Amu,’ du lo satu Amuyu, dunan i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yé too mdatah di kdeeyu, dunan i to fafasak di gamu. ");
INSERT INTO bpr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ku simto fdatah i kton, yé baling mdanà, na ku simto fdanà i kton, yé baling mdatah.” ");
INSERT INTO bpr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Na man Dyisas, “Magakdo gamu, dad to gal tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam mdà di kaflinguyu. Nsangyu i dalan dad to fusuk di Kagot Dwata di langit. Là mayè gamu fusuk na ku simto i mayè, là ti falohyu dun. ");
INSERT INTO bpr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Magakdo gamu, dad to tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi du too gamu flingu. Lnumìyu dad libun balu du fye gwèyu dad knunla, na flingu gamu mimò fye fagu di tahà dasalyu. Na yé duenam man, too ti sasè i kaflayamyu kadang.) ");
INSERT INTO bpr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Magakdo gamu, dad to gal tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam mdà di kaflinguyu. Gal gamu magu di tah tanà na di talà i mahin du fye gamgebe gamu to. Bay ku ta nun gebeyu, matnù fa i ksasèan di gamu, na midul i kagtenan salu ditù di lanaw lifoh. ");
INSERT INTO bpr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Magakdo gamu, du salngad gamu di to butè gal malak i dademe to. Ani tdòyu, ‘Ku nun to samdagè, na yé kbagal i sdagèan i Bong Gumnè Gumangamfù di Dwata, balù ku là dnohòan dun. Bay ku yé kbagal i sdagèan i blawen di lam i Bong Gumnè ayé, là fakay ku là dnohòan dun.’ ");
INSERT INTO bpr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Salngad gamu di to butè, na landè kaglabatyu. Dét i mabtas, i blawen, ku demen i Bong Gumnè Gumangamfù di Dwata gumdà i blawen matfing? ");
INSERT INTO bpr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na ani i lêyu tdò, ‘Ku nun to samdagè na yé kbagal i sdagèan i gudamsù, balù ku là dnohòan dun. Bay ku yé kbagal i sdagèan i blé ta mlasà di tah i gudamsù ayé, là fakay ku là dnohòan dun.’ ");
INSERT INTO bpr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Too gamu butè. Dét i mabtas, i blé mlasà di tah i gudamsù, ku demen i gudamsù gumdàan matfing i blé ayé? ");
INSERT INTO bpr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na yé duenam man, ku simto samdagè fagu di gudamsù, ise ku lo yé fakufan i gudamsù, bay lê man i kdee mlasà di tahan. ");
INSERT INTO bpr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na ku simto samdagè fagu di Bong Gumnè Gumangamfù di Dwata, ise ku lo yé fakufan i Bong Gumnè ayé, bay lê man i Dwata mnè di laman. ");
INSERT INTO bpr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ku simto samdagè na yé kbagal sdagèan i langit, lêan fakuf i trunu Dwata na lê man i Dwata sudeng di tahan. ");
INSERT INTO bpr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Magakdo gamu, dad to gal tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam du mdà di kaflinguyu. Gal gamu mlé gasfalò di Dwata mdà di malnak bol utenyu, bay ta tnagakyu i katluh na i kakdo na i kagsalig. Fye moon ku too gamu tluh, na ku fulung gamu kamdo, na ku gsalig gamu, na lê gamu fadlug di kabléyu di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Salngad gamu di to butè gal malak i dademe to. Yé guflingen-gu i nimòyu di satu to ku tnafisan i dad lifat di ninuman, bay flohan i bong lmanaf dnagit kamél. ");
INSERT INTO bpr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Magakdo gamu, dad to tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam du mdà di kaflinguyu. Galyu nalob i basù na fligo di kililan, bay ditù di laman, sana kagsikan, du too gamu lmumì na lom gamu. ");
INSERT INTO bpr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Too gamu butè, dad Farisi. Yé fye nimòyu, funayu nalob lam i basù na i fligo, na fagu déé lê mlaneb i kililan. ");
INSERT INTO bpr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Magakdo gamu dad to gal tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam du mdà di kaflinguyu. Salngad gamu i fantyun gutmusuk i lungun na fninturala bukay du too fye baweh mite dun di lwà, bay ditù di lam fnò tulan i dad to mati na i kdee ta balok. ");
INSERT INTO bpr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na salngad ayé i gamu, du di kite i dad to gamu, too gamu tluh, bay ditù di lam i nawayu too bong i kaflinguyu na too gamu gamsalà. ");
INSERT INTO bpr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Magakdo gamu dad to gal tamdò dad uldin Dwata fagu di ku Mosis na dad Farisi. Too gamu falnayam du mdà di kaflinguyu. Yé galyu nimò fandakyu ilè gulambang i dad tugad Dwata, na nkasyu dad lbang i dad muna to too tluh. ");
INSERT INTO bpr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na ani galyu man, ‘Ku lo gami gasalngan moon di dad gutambulto ayé, là sa magin gami fmati dad tugad Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na fagu di manyu ayé, nfunyu na gamu bel i dad to manò dad tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na yé duenam man, fadlugyu snikof i ta tanbù dad gutambulyu. ");
INSERT INTO bpr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Salngad gamu dad ulad du yé gutambulyu di dad ulad. Yé man nawayu kè ku gaganyu niwas i lanaw lifoh? ");
INSERT INTO bpr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yé duenam man, dekgu gadéé di gamu i dad tugad Dwata na dad to too fulung na dad to tamdò. Nun dademe di dale, balingyu fnatak di krus, ku demen fnatiyu ale. I dademe, balingyu ale nfas di dad gumnè galyu gustifun, na dluhyu ale balù nè gusalula milah. ");
INSERT INTO bpr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na fagu déé, falnayam Dwata gamu du gagin gamu di galla kfafati i kdee dad to landè gumaslen, mdà di ku Abél na kel di ku Sakaraya, i ngà Barakaya, dunan i bnanòla di bleng i gudamsù na i gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na too glut i man-gu di gamu ani, i kaflayam Dwata i dad to di mdu ani too ti gdohò kadang di fulé du.” ");
INSERT INTO bpr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“E, dad to di Dyérusalém, gamu i gal fmati dad tugad Dwata, na mdak batu i dad to dek Dwata salu di gamu. Ta dee dulêgu nan mayè samtifun gamu gambet i anuk mliton du lanfanan i dad ngàan. Bay là ti mayè gamu. ");
INSERT INTO bpr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bay neyeyu du ta fan bayà Dwata di gamu i banweyu ani, ");
INSERT INTO bpr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","na silangyu agu lê teen ku ta kel i bang kmanyu dun, ‘Magdayen i To salu dini di dagit Dwata.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na lamwà Dyisas di Bong Gumnè Gumangamfù di Dwata, na di kdàan, i dad to galan tdò fdadong ale na tdòla di kenen i dad gumnè glam di Bong Gumnè ayé. ");
INSERT INTO bpr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bay manan di dale, “Fye du teenyu kdee ani. Too glut i man-gu di gamu, nun du kel kadang, landè batu gtagak di guglakatan du sdulê malbà i kdeen.” ");
INSERT INTO bpr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na fles Dyisas di Bulul Olib, na sudeng déé. Na fdadong dad to galan tdò di landè dademe to lminge dun, manla, “Begam tulen gami ku kilen kagdohò i manam ayé, na ku dét mkel gugmadèmi kasfulêam na gusen i banwe.” ");
INSERT INTO bpr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na tmimel Dyisas, manan, “Too gamu fgeye du fye là mafgaw gamu. ");
INSERT INTO bpr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Du bong dee dad to kel kadang di fulé du, na tamdò ale fagu di dagitgu, ‘Do sa Krayst, dunan i Mgalék Dwata,’ na fagu déé, dee dad to mafgaw. ");
INSERT INTO bpr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nun lingeyu dad kasfati ta kel, na lingeyu i dad santulen gablà di dademe dad kasfati fan kel, bay nang gamu likò. Là fakay ku là funa kel i kdee ayé, bay balù ku ta gdohò ayé, ise ku yé i ta gusenan. ");
INSERT INTO bpr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sfati dad sahal to, na lê man dad malbang banwe. Na mkel i kbitil na dad linol di dee dad banwe. ");
INSERT INTO bpr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bay i kdee ayé lo katbù i dad ilè na ta fan mkel i gusenan salngad di libun maltien ta tamduk i tienan du fan sut i ngàan. ");
INSERT INTO bpr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kafnge ayé, kanfè dad to gamu, na nebela gamu di dad to mukum du falnayamla gamu na fnatila gamu. Na i dad to di kdee dad banwe, knangla gamu nawa du mdà di ksasatuyu di do. ");
INSERT INTO bpr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na di dad du ayé, nun dee dad to kmagol i kaftoola di Dwata. Na dademe, sakal ale, na snang ale nawa. ");
INSERT INTO bpr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na lê nun dee dad to flingu tmugad i Tnalù Dwata na dee dad to mafgaw. ");
INSERT INTO bpr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Du ta matnù i kdee dad sasè, yé duenam man, dee dad to, ta tno i kakdola. ");
INSERT INTO bpr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bay ku simto i gamtayud kel di gusenan galwà kenen. ");
INSERT INTO bpr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na funa gatdò i Fye Tulen gablà di Kagot Dwata du fye magtulen i kdee dad to di kdee dad banwe, na yé klon kel i gusenan. ");
INSERT INTO bpr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na nun teenyu too sasè kalnikò gamfalmo tadag di Bong Gumnè Gumangamfù di Dwata, dunan i ta fala man Dwata fagu di ku Danyél, i satu tugadan di munan. Ku simto masa ani, fye ku toon fan-glabat di fandaman. ");
INSERT INTO bpr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na ku teenyu ayé, fye ku milah i kdee dad to di Dyudiya ditù di dad bulul. ");
INSERT INTO bpr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na ku nun to ditù di tah ataf i gumnèan, fye ku ta nang kenen lê tufa du mwè i dad knunan. ");
INSERT INTO bpr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na ku nun to ditù di dnarun, fye ku ta nang mulê du mwè i saulan tahà sigal. ");
INSERT INTO bpr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Di du ayé, magakdo i dad libun maltien, na dad libun ftutù ngà. ");
INSERT INTO bpr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taman, too gamu dmasal du fye là kelan di bang ksasè i tanà ku demen di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Balù dét ksasè i dad mkel mdà di kagatbù i klamang banwe sngé kel di mdu ani, là gasalngadan i ksasè i mkel ani. ");
INSERT INTO bpr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bay fanfukal Dwata i bang ayé, du ku là fanfukalan dun, ta landè nan gdè to mlawil di tah tanà. Yé duenan famfukal dun du mdà di kalbong nawan di dad to ta mgalékan. ");
INSERT INTO bpr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na di dad du ayé, ku nun to man di gamu, ‘Neyeyu, ta dini Krayst, i Mgalék Dwata,’ ku demen manan, ‘Ta ditù’ nangyu fantoo. ");
INSERT INTO bpr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Du msut dee dad to flingu, na manla dale kun Mgalék Dwata, blaam ise. Na yé man dademe na dale kun i dademe dad tugad Dwata, blaam ise. Na mimò ale dad gamtikeng du fan-gawla i dad to, balù i dad to ta mgalék Dwata ku gagan, bay là. ");
INSERT INTO bpr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ani nangyu glifet, ta falagu tulen di gamu i kdee ani di laman là mkel. ");
INSERT INTO bpr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na yé duenam man, ku nun to man di gamu, ‘Ta ditù kenen di banwe landè to mnè ditù,’ nang gamu gatù. Na ku nun man di gamu, ‘Ta dini kenen di lam snifil,’ nangyu fantoo. ");
INSERT INTO bpr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","I kakel Ngà To, salngad di silà mkal mdà di gusut i du kel di gusdafan. ");
INSERT INTO bpr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na yé satu guflingen-gu dun, ku nè gumlasà i mati, déé gustifun i dad wak du knaanla. ");
INSERT INTO bpr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na kafnge i bong klimah ayé, tin tadè kmifuh i du, na ta là mneng i bulen. Na mtatek dad blatik mdà di langit, na gasyat i kdee dad mnè di langit. ");
INSERT INTO bpr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na yé klon msut di langit ilè i kasfulê Ngà To, na sdulê mngel i kdee bung to di tah tanà. Na teenla Ngà To kel fagin di dad labun, na too kenen maltulus na mneng. ");
INSERT INTO bpr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na salngan di bong uni féw dekan i dad kasaliganan gatù di kdee sahal banwe di tah tanà, balù nè gusablàla, du santifunla i dad to ta mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ganbetyu nan i tdògu ani mdà di kayu fig. Ku tmubad i kayu ani na lê dmoon, yé gugmadèyu dun na ta fan kel i minit du. ");
INSERT INTO bpr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gambet ayé, ku ta teenyu ta kel dad ta falagu tulen di gamu, yé gugmadèyu dun na too mdadong nan i kakel Ngà To. ");
INSERT INTO bpr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Too glut i man-gu di gamu ani. Là sa sdulê mati kdee dad to di bang ani. Silang ale mati ku ta gdohò i kdee dad tulen-gu. ");
INSERT INTO bpr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Matlas i langit na tanà, bay i Tnalùgu là matlasan kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Landè gmadè i du na i bang kasfulêgu, balù i dad kasaligan di langit, ku demen i Ngà Dwata. Bay lo yé gmadè dun Mà. ");
INSERT INTO bpr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","I mkel di dad to di bang kasfulê i dnagit Ngà To, salngad di ta mkel di dad to di du Nowa di munan. ");
INSERT INTO bpr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Di laman là kel i dunuk, lo yé nimò i dad to kmaan na minum. I dad lagi, mwè ale yaan, na dad libun, nwèla ale yaan kel di kfusuk Nowa di bong aweng. ");
INSERT INTO bpr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na là ti gadèla ku dét i fan mkel. Galì ale tamwan ta kel i bong dunuk na tangalan ale. Gambet ayé kagkahan ku ta samfulê i Ngà To. ");
INSERT INTO bpr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nun lwe lagi di dnaru. Nwè i satu na tagak i satu. ");
INSERT INTO bpr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nun lwe libun gmiling. Nwè i satu na tagak i satu. ");
INSERT INTO bpr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yé duenam man, too gamu fgeye du là ti gadèyu ku dét i du kasfulê i Amuyu. ");
INSERT INTO bpr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fan-glabatyu ani di fandamyu. Ku gadè i to mfun gumnè i bang i to tmaku kel di lam i kifuh, too kenen fgeye moon fye là gfusuk i to tmaku. ");
INSERT INTO bpr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yé duenam man, too gamu fgeye, du do, i dnagit Ngà To, yé kasfulêgu di du i là kfatanyu do. ");
INSERT INTO bpr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Simto kè snalig too fduf na too fulung? Dunan i snalig gufagot i amun kdee dademe dad snaligan du fye nalelan dale i knaanla ku ta kel i bang. ");
INSERT INTO bpr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Too fye nawa i snalig ku ta kel i amun, na teenan kenen talbahò. ");
INSERT INTO bpr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Too glut man-gu di gamu, i snalig ani, kenen gufagot i amun i kdee knunan. ");
INSERT INTO bpr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bay kaflingenta dun, ku sasè balu i snalig ani, na manan di kton, ‘Tay kléét i amugu,’ ");
INSERT INTO bpr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na balingan fatduk i dademen dad snalig, na lo tadè kmaan na minum di saféd i dad to flangal, ani mkel di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yé kakel i amun di du i là kfatanan, dunan bang i làan lyalo dun. ");
INSERT INTO bpr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na ani kibò i amun kenen, toon kenen falnayam, du fnèan kenen di saféd i dad to flingu, dunan di gumngel na gukminggat i kifanla.” ");
INSERT INTO bpr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na fadlug Dyisas talù, manan, “Di fulé du kadang, yé gusalngad i Kagot Dwata di sfalò sawang libun mebe dad salòla du snitongla i lagi sansong. ");
INSERT INTO bpr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","I lime libun, là fulung ale. Bay i lime, fulung ale. ");
INSERT INTO bpr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I dad là fulung, nebela salòla, bay là fatlagad ale tnù i fngalola. ");
INSERT INTO bpr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bay dad libun too fulung, nebela dad salòla, na lê ale fatlagad tnù i fngalola. ");
INSERT INTO bpr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Léét kel i lagi sansong, na yé duenam man, ta gfilot ale, na fles ale gkudang. ");
INSERT INTO bpr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na kanto ta tngà butang, nun lingela tamlo, manan, ‘Ta déé i lagi sansong. Lamwà gamu, na snitongyu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na mukat i kdee dad sawang libun ani, na fatlagadla dad salòla. ");
INSERT INTO bpr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na talù dad libun là fulung di dad libun fulung, manla, ‘Banléyu gami fngalo du ta fan mati dad salòmi.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bay tmimel ale, manla, ‘Landè kibò du keng kulang i gami ku banlémi gamu. Bay mdà gamu mngabal gumayadyu fngalo.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na yé duenam man, ta mdà ale. Na di lamla ditù, ta kel i lagi sansong, na ta magin dad libun ta gatlagad salu di ksong. Na kanto ale fusuk déé, ta tmakab i lagi sansong. ");
INSERT INTO bpr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na di là mlo, ta lê kel i lime libun là gatlagad, manla, ‘E Sér, begam nukà gami i takab.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bay tmimel kenen, manan, ‘Là ti dilèta gamu.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na fadlug Dyisas talù, manan, “Yé duenam man, too gamu fatlagad du là sa gadèyu i du ku demen i bang kasfulêgu.” ");
INSERT INTO bpr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na lê talù Dyisas, manan, “Di fulé du kadang, yé gusalngad i Kagot Dwata di satu lagi mdà magu. Na di laman là mdà, fatlon dad snaligan du fagotan dale i dad knunan. ");
INSERT INTO bpr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yé blén di satu, lime libu filak, na ye blén di galwen lwe libu, na di gatlun mlibu. Yé gufdàan mlé dale di kagsalig dale magot filak. Na kafnge ayé, ta mdà kenen. ");
INSERT INTO bpr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","I snalig fnagotan lime libu, gasil mdà dmagang, na yé untungan lê man lime libu. ");
INSERT INTO bpr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na lê salngad ayé i snalig fnagotan lwe libu, fagu di kdagangan, yé untungan lê lwe libu. ");
INSERT INTO bpr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bay i snalig fnagotan mlibu, mdà kenen, makol di tanà, na lbangan i filak ta fagot i amun dun. ");
INSERT INTO bpr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na kanto mlo, ta mulê i amula du situng ale. ");
INSERT INTO bpr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na i snaligan fnagotan lime libu, neben i lime libu untung i ta nimòan, na manan di amun, ‘Sér, yé fagotam do lime libu, na neyem, yé untungan lê lime libu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na tmimel i amun, manan, ‘Too fye nimòam. Too ge fye na gsalig. Du gsalig ge di tukay nimò, falbonggu i fagotta ge. Fusuk ge dini, na magin ge di klehewgu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na lê kel i snalig fnagotan lwe libu, na manan, ‘Sér, yé fagotam do lwe libu, na neyem, yé untungan lê lwe libu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na tmimel i amun, manan, ‘Too fye nimòam. Too ge fye na gsalig. Du gsalig ge di tukay nimò, falbonggu i fagotta ge. Fusuk ge dini, na magin ge di klehewgu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Na kafnge ayé, ta kel i snalig fnagotan mlibu, na manan, ‘Sér, gadègu na too ge labè. Galam nwè i ise ge nfun, na kantum i ise ge fele. ");
INSERT INTO bpr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yé duenam man, likò agu na balinggu lbang i filakam di lam i tanà. Neyem, ani filakam.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na talù i amun di kenen, manan, ‘Too ge sasè, na too ge malweh. Ta gadèam sa na too agu labè na galgu nwè i ise do nfun, na kantugu i ise do fele. ");
INSERT INTO bpr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na kan ku là fngàam i filakgu di bangku du fye di kulêgu, ta nun ngàan. ");
INSERT INTO bpr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nwèyu i filak di kenen, na lêyu blé di to snalig i ta nun sfalò libu. ");
INSERT INTO bpr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Du ku simto i fulung magot i ta nfunan, lê tananù glukas fa di kalnidùan. Bay ku simto là fulung magot i tukay nfunan, lê nwè di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na batyu i snalig landè gukel ayé ditù di gukmifuhan di lwà na déé gumngelan na gukminggat kifanan.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na fadlug Dyisas talù, manan, “Ku samfulê i Ngà To di bong kdatahan, magin i kdee dad kasaligan, sudeng di trunun du kenen i Harì. ");
INSERT INTO bpr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na i dad to mdà di kdee dad banwe, santifunan ale di kanfen, na sansahalan i dad to salngad di nimò i to mifat bilibili du fahalan i dad bilibili di dad kambing. ");
INSERT INTO bpr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I dad bilibili, kahan gsen di kwananan. Bay i dad kambing, kahan gsen di bibengan. ");
INSERT INTO bpr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na talù i Harì di dad to gsen di kwananan, manan, ‘Flal gamu, du too nun kafyeyu mdà ku Mà. Dnawatyu i kagot tagàan gamu mdà di kagatbù i banwe. ");
INSERT INTO bpr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Du di kbitilgu, fankaanyu agu, na di kalinumgu, finumyu agu. Na kantogu kel di banweyu, balù mahal to agu, fyakyu agu. ");
INSERT INTO bpr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kanto landè klawehgu, banléyu agu klaweh, na di kafdasgu, nifatyu agu, na di kablanggùgu, lnauyyu agu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na tmimel dad to tluh ani, manla, ‘Amu, kilen i ta kitemi ge bitil na fankaanmi ge, ku demen malinum na finummi ge? ");
INSERT INTO bpr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kilen i ksalum di banwemi, na balù mahal to ge, ta fyakmi ge? Kilen i klandè klaweham na banlémi ge? ");
INSERT INTO bpr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kilen i kitemi ge fandas ku demen blanggù na lnauymi ge?’ ");
INSERT INTO bpr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na tmimel i Harì, manan, ‘Too glut i man-gu di gamu ani, na ku dét i nimòyu di dad flanekgu balù ku too ale mdanà to, salngad ku di do i gumimòyu dun.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Na kafnge ayé, talù i Harì di dad to gsen di bibengan, manan, ‘Fawag gamu di do, du gablà gamu falnayam, na ditù gusaluyu di lanaw lifoh landè sen ta tagà Dwata di ku Satanas na lê dad snaligan. ");
INSERT INTO bpr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Du di kbitilgu, là ti fankaanyu agu, na di kalinumgu, là ti finumyu agu. ");
INSERT INTO bpr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na kantogu kel di banweyu, là ti fyakyu agu du mahal to agu. Di klandè klawehgu, là ti banléyu agu, na di kafdasgu, na di kablanggùgu, là ti lnauyyu agu.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na tmimel dad to ani, manla, ‘Amu, kilen i ta kitemi ge bitil ku demen malinum ku demen mahal to ku demen landè klaweh ku demen nun fdas ku demen blanggù, na là tnabengmi ge?’ ");
INSERT INTO bpr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na tmimel i Harì, manan, ‘Too glut i man-gu di gamu ani, na ku dét i là nimòyu di dademe dad togu too mdanà, salngad ku là nimòyu dun di do.’ ");
INSERT INTO bpr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na i dad to ayé, faflesan ale salu di gumaflayamla kel di landè sen, bay i dad to tluh, ditù gufaflesan dale di nawa landè sen.” ");
INSERT INTO bpr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kanto fnge Dyisas tamdò i kdee ayé gine, ta manan di dad to galan tdò, ");
INSERT INTO bpr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ta gadèyu na lo lwe butang mdà ani kel i Du Kaglius, na do, i dnagit Ngà To, bléla agu di kagot i dad to du fnatakla agu di krus.” ");
INSERT INTO bpr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na i dad ganlal di kafaglut i dad Dyu na i dad tua gal mebe i dad Dyu, stifun ale di bong gumnè Kayafas, dunan i ulu i dad ganlal di kafaglutla. ");
INSERT INTO bpr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na yé santulenla déé ku dét i fye kibòla kamfè ku Dyisas du fafatila di landè to gmadè dun. ");
INSERT INTO bpr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bay yé manla, “Nangto nimò ani di lam i fista du keng falbut i dad to, na balingla gumdà too smamuk.” ");
INSERT INTO bpr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na déé Dyisas di tukay banwe Bétani di gumnè Simon, dunan i to nun fdas mumuh di munan. ");
INSERT INTO bpr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na di lam Dyisas kmaan, nun libun fdadong di kenen, na nun neben sabuy malung fnò fangbun too mabtas. Kokan i fangbun ayé di ulu Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na kanto teen dad to galan tdò, too ale malbut, na manla, “Kan ku falmon i fangbun ayé? ");
INSERT INTO bpr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tumù fa ku fablin du too bong wèan, na fakayan blé i wèan di dad to landè knun. ");
INSERT INTO bpr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bay gadè Dyisas i manla, na tmimel kenen, manan, “Kan ku nangawyu i libun ani? Too fye sa i nimòan di do.” ");
INSERT INTO bpr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Du gal nun dad to landè knun di safédyu, na fakayyu ale tnabeng balù ku dét du. Bay do, ta là mlo i knègu dini di safédyu. ");
INSERT INTO bpr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Di kakokan i fangbun di do, falan fatlagad i lawehgu di lbang. ");
INSERT INTO bpr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Too glut i man-gu di gamu ani, na balù nè gutamdò i Fye Tulen di klamang banwe, lêla tulen i nimò libun ani du fye gafaldamla kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na kafnge ayé, nun satu di dad sfalò lwe to gal tdò Dyisas, yé dagitan Dyudas Iskariyot, na salu kenen di dad ganlal di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na smalek kenen, manan, “Dét i bléyu do ku blégu di gamu Dyisas?” Na mse ale tlu falò batù di filakla du bléla ku Dyudas. ");
INSERT INTO bpr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na mdà di du ayé, mngabal kenen kfagu mlé ku Dyisas di dale. ");
INSERT INTO bpr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Di tnanin du i Fista Kakaan i Fan Landè Bulung Falnok Dun, fdadong ku Dyisas i dad to galan tdò, na smalek ale, manla, “Nè gumdekam gami fatlagad knaanto di Du Kaglius?” ");
INSERT INTO bpr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na man Dyisas di dale, “Mdà gamu salu di satu lagi mnè di syudad, na manyu di kenen, ‘Yé man i To Tamdò na ta kel i bangan dmohò i kdee ta gmanan, na yé gukmaanan kun di lam gumnèam magin dad to galan tdò.” ");
INSERT INTO bpr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na nimenla i man Dyisas, na fatlagadla i knaan di Fista i Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na kanto kifuh, ta sudeng Dyisas na i dad sfalò lwe to galan tdò du kmaan ale. ");
INSERT INTO bpr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na lamla kmaan, talù Dyisas, manan, “Too glut i man-gu di gamu ani, nun satu di gamu i makal do.” ");
INSERT INTO bpr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na too mlidù nawala, na man kat satu di kenen, “Ise do, man, Amu?” ");
INSERT INTO bpr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na tmimel Dyisas, manan, “I to song di do lamnab fan di tukung, yé makal do. ");
INSERT INTO bpr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Do, i dnagit Ngà To, mati agu salngad i ta gsulat gablà di do. Bay magakdo i lagi makal do du too kenen maflayam. Baling fye fa to ayé ku là sutan.” ");
INSERT INTO bpr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na lê talù Dyudas, dunan i makal kenen, manan, “Ise do kè, Sér?” Na tmimel Dyisas, manan, “Hee, dunan sa, ge.” ");
INSERT INTO bpr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na lamla kmaan, nwè Dyisas fan, na fasalamat kenen di Dwata, klon falnak dun, na blén di dad to galan tdò, manan, “Nwèyu ani na knaanyu. Ani lawehgu.” ");
INSERT INTO bpr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na kafnge ayé, lêan nwè i basù nun binu, na fasalamat kenen di Dwata, klon mlé dun di dale, na manan, “I kdeeyu, sansinumyu ani. ");
INSERT INTO bpr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ani i litègu falohgu du fye fnasinsya Dwata salà i dee dad to du yé fambagal i kasafnè Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na too glut i man-gu di gamu, mdà ani, ta là lê agu minum binu ani. Silang agu lê minum ku ta kel i du kinumgu i falami binu di Kagot Màgu, na gamu i dademegu. ");
INSERT INTO bpr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kafngela lmingag dmayen di Dwata, ta lamwà ale, na salu ale di Bulul Olib. ");
INSERT INTO bpr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na talù Dyisas di dale, manan, “Kadang kifuh, i kdeeyu baling milah na tnagakyu agu, du ta gsulat di Tnalù Dwata, manan, ‘Fnatigu i to gal mifat dad bilibili, na masbalét i dad bilibilin.’ ");
INSERT INTO bpr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bay ku ta mték agu mdà di fati, muna agu di gamu ditù di Galili.” ");
INSERT INTO bpr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na man Piter di ku Dyisas, “Balù ku milah i kdee, bay do, là ti tnagakta ge.” ");
INSERT INTO bpr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bay tmimel Dyisas, manan, “Too glut i man-gu di ge ani na kadang kifuh, di là fa kalmeet i anuk, ta sanam agu bnalew tlu dulê di kmanam dun na làam agu dilè.” ");
INSERT INTO bpr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bay too sansulit Piter i manan ayé, “Balù ku mati agu magin ge, là ti bnalewta ge.” Na lê salngad ayé i man dademe dad to tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na salu Dyisas na i dad to galan tdò di satu tanà dnagit Gétsémani. Na manan dale, “Sudeng gamu dini du salu agu ditù du dmasal.” ");
INSERT INTO bpr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na faginan Piter na i lwe ngà Sébidi salu di gudmasalan. Na too flunuh Dyisas na mlidù i nawan. ");
INSERT INTO bpr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na manan di dale, “Yé kagkahgu ani ta fan agu mati di klidùgu. Fanak gamu dini na too gamu fgeye magin do.” ");
INSERT INTO bpr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na fles kenen magu, là mawagan di dale, na tadè lamfan di tanà, na dmasal, manan, “E Mà, ku nun kibò, begam nwè i kaflayam fan mkel di do ani. Bay yé mgimò i ge knayè, ise i do.” ");
INSERT INTO bpr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na lê kenen samfulê di dale Piter, na teenan ale gkudang. Na snalekan Piter, manan, “Kan? Là gaganyu famgal nawayu di kaginyu di do di là mlo? ");
INSERT INTO bpr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Too gamu fgeye na dmasal du fye là gamu gfisan di tilew. Du mayè i nawa, bay gal mlungay i laweh.” ");
INSERT INTO bpr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na lê kenen mdà du dmasal, manan, “E Mà, ku landè kibò mwè i kaflayamgu ani, du silang magwè ku ta gnagugu, ge knayè i gdohò.” ");
INSERT INTO bpr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na kafnge ayé, lê man kenen samfulê di dale na ta lêan ale teen kudang, du too ale malkudang. ");
INSERT INTO bpr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na lê man kenen mdà dmasal di gatlun dulê, na lê salngad i dasalan. ");
INSERT INTO bpr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na kafngen dmasal di gatlun dulê, samfulê kenen di dad to galan tdò, na manan, “Kan, sana kakudangyu na sana kaftudyu? Neyeyu du ta kel nan i bang, na do i dnagit Ngà To, nakalla na bléla agu di kagot i dad to gamsalà. ");
INSERT INTO bpr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mték gamu du mdà ato. Ta mdadong i to makal do di fati.” ");
INSERT INTO bpr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na di lam Dyisas talù, ta kel Dyudas, satu di dad sfalò lwe to galan tdò. Na dee dad to magin di kenen dek dad ganlal di kafaglut i dad Dyu, na dad tua gal mebe i dad Dyu. Na mebe ale sundang na bunal. ");
INSERT INTO bpr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na i to makal ayé, ta falan tulen dale ku dét ilè fgadè dale ku simto Dyisas. Ani ta falan man, “I to nalakgu di bawehan, yé dunan. Kenen i kanfèyu.” ");
INSERT INTO bpr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na fdadong Dyudas di ku Dyisas, manan, “E Amu, fye kifuh,” na ta nalakan i bawehan. ");
INSERT INTO bpr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na talù Dyisas, manan, “Leg, fabaltikam nimò i knayèam.” Na kafnge ayé, ta fdadong i dademe magin ku Dyudas, na nagotla Dyisas du kanfèla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na satu di dad to magin di ku Dyisas, nwèan sundangan, na tnibehan fasak i ulu dad ganlal di kafaglut i dad Dyu, na masfek bali klingen. ");
INSERT INTO bpr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na man Dyisas di to ayé, “Tusukam di lumàan i sundangam, du ku simto gmamit tek, lê mati di tek. ");
INSERT INTO bpr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Là kè gadèam dun na fakay agu ftabeng di ku Mà fye dekan gadini dee libu dad kasaliganan tmabeng do? ");
INSERT INTO bpr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bay ku yé nimògu, là ti gdohò i ta gsulat di Tnalù Dwata gablà di kfatigu.” ");
INSERT INTO bpr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na kafnge ayé, talù Dyisas di kdee dad to ayé, manan, “Kan, to tmaku agu kè du mebe gamu sundang na bunal di kakfèyu do? Kat dugu sudeng na tamdò déé di Bong Gumnè Gumangamfù di Dwata, na là sa kanfèyu agu. ");
INSERT INTO bpr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bay yé duenan kel ani du fye gdohò i ta gsulat i dad tugad Dwata.” Na kafnge ayé, i kdee dad to galan tdò, tnagakla kenen na mdà ale milah. ");
INSERT INTO bpr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mdà i dad to kamfè ku Dyisas, nebela kenen salu di gumnè Kayafas, ulu i dad ganlal di kafaglut i dad Dyu. Na ta stifun déé i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na dad tua gal mebe i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na lê lmalò Piter, bay kibò kenen fawag kel di nasel gumnè Kayafas. Fusuk kenen déé na sudeng di saféd i dad to mantay du fye gadèan ku dét i mkel. ");
INSERT INTO bpr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na i dad ganlal di kafaglut i dad Dyu na kdee dademe dad ganlal, too ale meye kfagu gutadagla tmifù na fafati ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bay landè teenla salàan, bay du nun dad to tmulen kéng gablà di kenen. Na di gusenan, nun lwe to fdadong, ");
INSERT INTO bpr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na manla, “Yé man i to ani, ‘Lanbàgu i Gumnè Gumangamfù di Dwata, na lêgu ftadag di lam i tlu du.’ ” ");
INSERT INTO bpr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na i ulu dad ganlal di kafaglut i dad Dyu, ta tadag kenen, na snalekan Dyisas, manan, “Landè timelam kè? Dét i duenla talù gambet ani gablà di ge?” ");
INSERT INTO bpr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bay là talù Dyisas balù ku landè salàan. Mdà ayé, lê smalek i ulu dad ganlal di kafaglut i dad Dyu, na manan di ku Dyisas, “Fagu di dagit i too mdatah Dwata, samdagè ge na tulenam gami ku ge i Mgalék Dwata, dunan i Ngàan.” ");
INSERT INTO bpr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na tmimel Dyisas, manan, “Dunan i manam. Na man-gu di gamu, di fulé du kadang teenyu agu, dunan i dnagit Ngà To, na sudeng agu di kwanan i Dwata too maltulus, na kel agu mdà di langit fagin di dad labun.” ");
INSERT INTO bpr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bay knasê i ulu dad ganlal di kafaglut i dad Dyu i kenen saul du too sè kalbutan, na manan di dad to, “Nladan i kdatah Dwata! Ta landè kamuto smalek i dademe dad to gablà di kenen du ta lingeyu i sasè manan. ");
INSERT INTO bpr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dét i fandamyu gamu?” Na yé timel i dad to, manla, “Gablà kenen fnati.” ");
INSERT INTO bpr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na kafnge ayé, dnulàla i bawehan, na snuntukla kenen. Nun dademe tamfiling kenen, ");
INSERT INTO bpr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na manla, “Ku ge Mgalék Dwata, tansabam ku simto tamfiling ge.” ");
INSERT INTO bpr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na sana ksudeng Piter di nasel. Na nun libun fasak salu di kenen, manan, “Ge sa i satu to gal magin di ku Dyisas mdà di Galili.” ");
INSERT INTO bpr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bay malew Piter di kdeela déé, manan, “Là gadègu i manam ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na salu Piter gatù di bà takab. Na lê nun satu libun fasak mite kenen, na manan di dad to déé, “I to ani, lê kenen magin di ku Dyisas mdà di Nasarét.” ");
INSERT INTO bpr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bay lê malew Piter, na samdagè kenen, manan, “Là dilègu i lagi ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na di là mlo, i dad to tadag déé, fdadong ale di ku Piter, manla, “Dunan sa, ge satu di dale du dilèmi talùam.” ");
INSERT INTO bpr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Baling kenen samdagè, manan, “Falnayam Dwata agu ku tmulen agu kéng. Là dilègu i lagi ayé.” Na ta kalmeet i anuk. ");
INSERT INTO bpr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Na gafaldam Piter i ta man Dyisas di kenen, “Di là fa kalmeet i anuk, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” Na yé duenam man, ta lamwà kenen na too ti mngel. ");
INSERT INTO bpr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kanto flafus, i kdee dad ganlal di kafaglut i dad Dyu, na dad tua gal mebe i dad Dyu, yé fnaleh nawala fafatila Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na bnakusla kenen, na nebela ditù di ku Pilato, dunan i gubirnador, du bléla di kagotan. ");
INSERT INTO bpr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na Dyudas, dunan i makal ku Dyisas, kanton gadè na ta nukumla Dyisas di fati, gsal kenen, na fulêan i tlu falò batù filak di dad ganlal di kafaglut i dad Dyu na di dad tua gal mebe i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Manan di dale, “Ta gamsalà agu du ta nakalgu i to landè salà.” Bay tmimel ale, manla, “Landè labetmi déé. Ge i gmadè ayé.” ");
INSERT INTO bpr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na bat Dyudas i filak ayé di lam i Gumnè Gumangamfù di Dwata klon mdà. Na di kdàan, ta fles mikat lial. ");
INSERT INTO bpr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na dad ganlal di kafaglut i dad Dyu, nulutla filak ayé, na manla, “Là fakay ku tnùto i filak ani di filak galto busek di Gumnè Gumangamfù di Dwata, du i filak ani bayad lawil i satu to.” ");
INSERT INTO bpr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na yé duenam man, yé fnaleh nawala yé gukmamula i filak ani bayadla tanà gal gumakol i dad to mimò kulang du fye nun gulambangla dad to mdà di dad mahal banwe ku déé gumatila di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Na yé duenam man, yé dagit i tanà ayé kel di du ani, dunan, “I tanà bnayad litè.” ");
INSERT INTO bpr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na fagu déé gdohò i man Dyérimaya, i satu tugad i Dwata di munan, “Nwèla i tlu falò batù filak, dunan i btas kayè blé dad to bel Israél di kbayadla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na yé gukmamula dun bayadla tanà gal gumakol i dad to mimò kulang, du yé dek i Amugu di do.” ");
INSERT INTO bpr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na kantola nebe Dyisas salu di gubirnador, tadag kenen di munan, na snalek Pilato kenen, manan, “Ge kè Harì i dad Dyu?” Na tmimel Dyisas, manan, “Ta manam sa.” ");
INSERT INTO bpr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na dad ganlal di kafaglut i dad Dyu, na dad tua gal mebe i dad Dyu, tnifùla Dyisas, bay là tmimelan. ");
INSERT INTO bpr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na smalek Pilato, manan, “Là lingem i kdee sasè manla ayé gablà di ge?” ");
INSERT INTO bpr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bay là tmimel Dyisas balù dét tifùla dun. Na yé duenam man, too tngah i gubirnador ayé. ");
INSERT INTO bpr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na yé gal nimò Pilato di fista falwàan satu to di blanggù. Ku simto knayè i kdee dad to, yé falwàan. ");
INSERT INTO bpr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na di bang ayé, nun satu to di blanggù too gadè i kdee dad to, yé dagitan Barabas. ");
INSERT INTO bpr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na yé duenam man, kanto stifun i kdee dad to, snalek Pilato ale, manan, “Simto knayèyu falwàgu, Barabas ku demen Dyisas, i dnagit Krayst?” ");
INSERT INTO bpr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yé duenan smalek dad to du ta gadèan na yé duen i dad ganlal di kafaglut i dad Dyu mlé ku Dyisas di kagot Pilato du mafè nawala ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na di ksudeng Pilato di gusudeng i to mukum, nun sulat febe yaanan di kenen, manan, “Nang ge lmabet di to ayé du landè salàan. Balbutang too agu maflayam di kaknagu kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bay dad ganlal di kafaglut i dad Dyu, na dad tua gal mebe i dad Dyu, banlétla i dad to du fye yé fnila falwà Barabas na fafatila Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na lê smalek i gubirnador, manan, “Simto di lwe ani kayèyu falwàgu?” Na tmimel ale, manla, “Barabas.” ");
INSERT INTO bpr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na smalek Pilato, manan, “Dét i fye kibògu ku Dyisas, i dnagit Krayst?” Na tmimel i kdeela, manla, “Fnatakam di krus.” ");
INSERT INTO bpr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na smalek Pilato, manan, “Kan? Dét i salàan?” Bay baling matnù kakitla, manla, “Fnatakam kenen di krus.” ");
INSERT INTO bpr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na gadè Pilato na landè kibòan du fan ale mimò samuk mdà di kalbutla. Na yé duenam man, mwè Pilato éél, na naloban tnalòan di muna i kdee dad to, manan, “Landè labetgu di kfati to ani. Gamu nan i gmadè.” ");
INSERT INTO bpr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na tmimel dad to, manla, “Hee, gami na dad belmi i tmimel gablà di kfati i to ani.” ");
INSERT INTO bpr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na kafnge ayé, falwàan Barabas di dale. Bay fafasan Dyisas, na blén kenen di dad sundalun, du fnatakla di krus. ");
INSERT INTO bpr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na nebe dad sundalu Dyisas fusuk di bong gumnè Pilato, na ta salnibutla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na nlusla dad klawehan, na nun falsakla dun klaweh mitam fulè du fagbetla kenen harì. ");
INSERT INTO bpr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na mwè ale walad nun sual, na salnabédla du nimòla kyangen na sukubla di ulun. Na lêla kenen banlé tugad gambet i gal nagot dad harì, na lkuad ale di munan, na nadoyla kenen, manla, “Kumusta ge, harì i dad Dyu!” ");
INSERT INTO bpr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na dnulàla kenen, na lêla nwè i tugad du bagulla di ulun. ");
INSERT INTO bpr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na kafngela madoy kenen, lêla nlus i klaweh mitam fulè, na falsakla dun i kenen klaweh. Na kafnge ayé, nebela kenen lamwà du fnatakla di krus. ");
INSERT INTO bpr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na di kalwàla, nun lagi gsitongla, yé dagitan Simon mdà di banwe Sirini. Fnegesla kenen mebe i krus Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na yé gusalula di satu banwe dnagit Golgota. Yé gumtatek Golgota, dunan banwe klakub ulu. ");
INSERT INTO bpr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na banléla kenen binu sanboolla bulung féét, bay kanto tilew Dyisas, là ninuman dun. ");
INSERT INTO bpr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na kafngela fmatak kenen di krus, nalel dad sundalu i dad klawehan fagu di kasbunut, du fye gadèla ku dét gwè kat satu di dale. ");
INSERT INTO bpr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na kafnge ayé, sudeng ale du bnantayla kenen. ");
INSERT INTO bpr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nun sulat kahla gsen tah i ulun tifùla kenen, manan, “Ani Dyisas, Harì i dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na nun lwe to tmaku lêla fnatak di safédan, satu gsen di kwananan na satu gsen di bibengan. ");
INSERT INTO bpr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na i dad to magu déé, lêla kenen nadoy, na kmiling ale, manla, ");
INSERT INTO bpr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ha, ge i to mayè lambà i Bong Gumnè Gumangamfù di Dwata na lê ftadag dun di lam i tlu du, falwàam i ktom, na tufa ge mdà di krus ku ge Ngà i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na lê salngad ayé nimò i dad ganlal di kafaglut i dad Dyu, na i dad to gal tamdò dad uldin Dwata fagu di ku Mosis, na dad tua gal mebe i dad Dyu, du toola kenen nadoy. ");
INSERT INTO bpr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ani manla, “Galan falwà dademe dad to, bay kenen kto là gafalwàan dun. Kenen i Harì di Israél kun. Ku tufa kenen mdà di krus, fantooto kenen. ");
INSERT INTO bpr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Toon ti snalig i Dwata na yé manan Ngà i Dwata kun. Na neyeto ku falwà Dwata kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na balù dad to tmaku i gagin fnatak di krus, lêla nadoy. ");
INSERT INTO bpr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na mdà di ltu du kel di tngà masol i du, tadè kmifuh i klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na kanto tngà masol i du, too falbong Dyisas i talùan, manan, “Iloy, iloy, lama sabaktani?” Yé gumtatek ani, “E Dwatagu, Dwatagu, dét duenam kmagol do?” ");
INSERT INTO bpr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kanto linge dademe to tadag déé i manan ayé, manla, “Ta tlon Ilaydya.” ");
INSERT INTO bpr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na gasil mwè falnas i satu to, lnaban di sukà, na fkahan di tukè i kayu du ulukan di bà Dyisas na fsafan dun. ");
INSERT INTO bpr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na man dademe, “Bayàyu kenen. Neyeto ku kel Ilaydya na falwàan kenen.” ");
INSERT INTO bpr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na mkit Dyisas, na ta ftoh i nawan. ");
INSERT INTO bpr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na tadè kasê di gutngàan i bong kurtina di Gumnè Gumangamfù di Dwata mdà di tah kel di dungan. Na kmangkal i tanà, na btù dad batu. ");
INSERT INTO bpr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na mgukà i dademe lbang, na mték mdà di fati i dademe dad to Dwata. ");
INSERT INTO bpr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lamwà ale di lbangla, na kafnge i kték Dyisas di fati, salu ale di Dyérusalém du fitela i ktola di dee dad to. ");
INSERT INTO bpr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I ulu dad sundalu na lê i dad sundalun magin dun di kbantayla ku Dyisas, kantola galyalo kmangkal i tanà na teenla i kdee dademe mkel, too ale likò, na manla, “Too glut, kenen Ngà i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na nun dee dad libun déé damweng mdà di gumawagan. Tagnè ale magin di ku Dyisas fdu di Galili du galla kenen tnabeng. ");
INSERT INTO bpr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Magin déé Méri Magdalin, na Méri i yê Dyém na Dyosip, na yê dad ngà Sébidi. ");
INSERT INTO bpr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kanto kifuh, nun satu lagi kel, yé dagitan Dyosip mdà di banwe dnagit Arimatiya. Too bong knunan, na kenen satu to gal tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Salu kenen di ku Pilato, na fnin i laweh Dyisas. Yé duenam man, mdek Pilato du fye bléla i laweh Dyisas di ku Dyosip. ");
INSERT INTO bpr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na ta nwè Dyosip i laweh Dyisas, na lnabédan falnas bukay. ");
INSERT INTO bpr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nun lbang ta fala fakol Dyosip di lfidas gugdak i bulul du gulambangla ku Dyosip ku ta mati. Na déé gutmusukan i laweh Dyisas. Na nun lulidan bong batu du sangan di bà i gufusuk di lbang na kafnge ayé, ta mdà kenen. ");
INSERT INTO bpr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Méri Magdalin na lê man i satu Méri, teenla i nimò Dyosip du déé gusudengla mdadong di lbang. ");
INSERT INTO bpr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na di tmadol du, dunan i Du Kaftud, salu di ku Pilato i dad ganlal di kafaglut i dad Dyu, na dad Farisi. ");
INSERT INTO bpr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na manla, “Sér, gafaldammi na di là fa mati i to tmulen kéng ayé, yé manan, ‘Kafnge tlu du, lê agu mték.’ ");
INSERT INTO bpr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yé duenam man, fye ku fbantayam i lbang kel di tlu du tà tnaku i dad to galan tdò i lawehan na fnge ayé, yé manla di dad to, ‘Ta mték kenen di fati.’ Ku dee mgebe di kéngla di munan, midul kadang di bong kéngla di fulé ani.” ");
INSERT INTO bpr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na man Pilato di dale, “Mebe gamu dad to mantay ditù di lbang na tooyu fanbagal i lbang na tooyu bnantay.” ");
INSERT INTO bpr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na yé duenam man, gatù ale di lbang du fye fan-gatla. Nsangla batu i bà lbang, na tnagakla déé i dad to mantay. ");
INSERT INTO bpr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kafnge i Du Kaftud, di too flafus Linggu, mdà Méri Magdalin na i satu Méri salu di lbang du neyela. ");
INSERT INTO bpr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na tin tadè lminol du nun kasaligan Dwata mdà di langit tufa déé di lbang. Na lulidan i bong batu di bà i lbang, na sudeng kenen di tahan. ");
INSERT INTO bpr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yé kbawehan gambet silà, na too ti bukay i klawehan. ");
INSERT INTO bpr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na kankal i dad to mantay mdà di klikòla di kasaligan ayé, na gambet ale dad to mati. ");
INSERT INTO bpr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na man i kasaligan di dad libun, “Nang gamu likò, du gadègu na yé fanngabalyu Dyisas, dunan i fnatakla di krus. ");
INSERT INTO bpr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ta là dinin du ta mték mdà di fati salngad i ta manan di gamu. Flal gamu. Neyeyu i gufilèla dun. ");
INSERT INTO bpr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na gasil gamu salu di dad to galan tdò, na manyu di dale, ‘Ta nték kenen mdà di fati, na muna kenen di gamu salu di Galili. Ditù gumiteyu dun.’ Yé man-gu di gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na yé duenam man, gasil mdà dad libun fdu di lbang. Likò ale, bay lê ale too lehew. Too ale sadluh du fye tulenla di dad to gal tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na snitong Dyisas ale, manan, “I ktanak nawa samnagin di gamu.” Na fdadong ale di kenen, na nagotla i blìan mangamfù di kenen. ");
INSERT INTO bpr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na man Dyisas di dad libun ayé, “Nang gamu likò. Mdà gamu, na dekyu dad flanekgu fye gatù ale di Galili, du ditù gusamsitegu dale.” ");
INSERT INTO bpr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Di lamla magu, nun dademe dad to mantay salu di syudad du tulenla di dad ganlal di kafaglut i dad Dyu i kdee ta mkel. ");
INSERT INTO bpr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na dad ganlal ayé, stulen ale di dad tua gal mebe i dad Dyu, na nun fnaleh nawala. Banléla dad sundalu mantay too bong filak, ");
INSERT INTO bpr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na yé flaula dale, “Ani manyu, ‘Di lammi kudang di kifuh, ta kel dad to galan tdò na tnakula i lawehan.’ ");
INSERT INTO bpr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na ku linge i gubirnador ani, fansyemi stulen di kenen du fye là falnabèan gamu.” ");
INSERT INTO bpr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yé duenam man, nwè dad sundalu mantay i filak, na nimenla i flau dad ganlal di dale. Na i tulen dad ganlal ayé, ta too mbel di dad Dyu, balù kel di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na ta mdà dad sfalò satu to galan tdò gatù di Galili. Na fles ale di bulul i ta fala man Dyisas dale. ");
INSERT INTO bpr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na di kitela dun, mangamfù ale di kenen, bay nun di dale lwe nawa. ");
INSERT INTO bpr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na fdadong Dyisas di dale, manan, “Ta blé Dwata di do i kdee glal di tah langit na di tah tanà. ");
INSERT INTO bpr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yé duenam man, mdà gamu gatù di dad to di kdee dad banwe di tah tanà, na fanbalingyu ale dad to tdògu. Na bnunyagyu ale di dagit i Mà, na i Ngà, na i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na lêyu ale tdò du fye nimenla i kdee dad dekgu di gamu. Na nangyu glifet na gal agu samnagin di gamu kel di gusen i banwe.”");
INSERT INTO bpr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ani i katbù i Fye Tulen gablà ku Dyisas Krayst, dunan Ngà i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Du ani i fsulat Dwata ku Isaya, i satu tugadan di munan, gtadè di Ngàan, manan, “Dekgu i snaliggu muna di ge du fatlagadan i dalanam. ");
INSERT INTO bpr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Di banwe landè to mnè ditù, tamlo kenen, ani manan fagu di fléd, ‘Fatlagadyu i dalan i Amu, na tanluhyu i gumagun!’ ” ");
INSERT INTO bpr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na i to ayé, dunan Dyan. Tamdò kenen di banwe landè to mnè ditù, na manan di dad to, “Nsalyu na tnagakyu i dad salàyu, na fbunyag gamu, na ku yé nimòyu fnasinsya Dwata dad salàyu.” ");
INSERT INTO bpr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na yé duenam man, nun dee dad to salu déé di gutamdò Dyan mdà di banwe Dyudiya, na lê man mdà di syudad Dyérusalém. Na tulenla i dad salàla, na fbunyag ale di Éél Dyordan. ");
INSERT INTO bpr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yé gal lsak Dyan bul i lmanaf dnagit kamél, na yé galingan kulit lmanaf. Na yé knaanan dunan tlangas na tnab. ");
INSERT INTO bpr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na ani man Dyan di dad to, “Nun kel satu to tmadol di do, na too kenen mdatah di do. Là gablà agu mteh i ikat talumfàan du too agu mdanà di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bnunyagta gamu di éél, bay kenen i munyag gamu fagu di Mtiu Tulus.” ");
INSERT INTO bpr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Là mlon, salu Dyisas di Éél Dyordan, na yé gumdàan di Nasarét glam di banwe Galili. Na fbunyag kenen di ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kanto kenen fbunyag, di kalwàan di lam éél, ta teenan i langit mgukà. Na lêan teen i Mtiu Tulus tufa na mdaf di kenen gambet abun. ");
INSERT INTO bpr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na nun talù mdà di langit, manan, “Ge i Ngàgu i toogu kando. Too fye nawagu di ge.” ");
INSERT INTO bpr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na gasil nebe i Mtiu Tulus Dyisas salu di banwe landè to mnè ditù. ");
INSERT INTO bpr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na fat falò butangan déé, na tnilew Satanas kenen. Na lê nun dad lmanaf labè di banwe ayé, bay yé mifat ku Dyisas i dad kasaligan Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Di là mlo, fablanggù Harì Hérod Dyan, na samfulê Dyisas di Galili, du tdòan i Fye Tulen mdà di Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ani man Dyisas, “Ani ta kel nan i du kagdohò gman di Tnalù i Dwata di munan du ta mdadong nan i Kagot Dwata. Nsalyu i dad salàyu, na tnagakyu i dad sasè nimòyu, na ftoo gamu di Fye Tulen.” ");
INSERT INTO bpr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na di satu du, magu Dyisas di kilil i bong lanaw Galili, na nun teenan lwe lagi saflanek, yé dagitla Simon na Andru. Yé nimòla fmukat ale du yé talbahòla. ");
INSERT INTO bpr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Man Dyisas di dale, “Yé galyu nimò ani, fmukat nalaf. Fye fa ku baling gamu magin di do du tdòta gamu fmukat dad to du fye magin ale di do.” ");
INSERT INTO bpr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na di kman Dyisas ayé, tadèla tnagak i dad fukatla, na magin ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na kanto fles ale Dyisas magu, lê nun teenan lwe lagi saflanek, yé dagitla Dyém na Dyan, i dad ngà Sébidi. Na yé gusudengla di awengla. Yé nimòla, fatlagadla dad fukatla. ");
INSERT INTO bpr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tadè tlo Dyisas ale, na tnagakla déé di aweng i màla Sébidi na i dad to snukéy du magin ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Di kagula, salu ale di lunsud Kapernaum. Kanto kel i Du Kaftud i dad Dyu, fusuk Dyisas di gumnè gal gustifun i dad Dyu na tamdò. ");
INSERT INTO bpr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Too tngah i dad to di katdòan du là salngadan di katdò i dad to gal tamdò i uldin Dwata fagu di ku Mosis. Bay Dyisas kenen, too nun kaltulusan di katdòan. ");
INSERT INTO bpr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lam Dyisas tamdò, nun satu lagi tadè kel nun busawan. Mkit kenen, manan, ");
INSERT INTO bpr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“E Dyisas mdà di Nasarét, landè labetam di gami. Fanam gami falmo kè? Gadègu ku simto ge. Ge sa i Too Mtiu mdà di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bay nngak Dyisas i busaw, na manan, “Fanak ge. Lamwà ge di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Too fakakal i busaw i lagi ayé, na mkit klon lamwà. ");
INSERT INTO bpr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Too ti tngah i kdee dad to, na sansmanla, “Too ti tnikeng ani. Nun falami tdò dini na magin déé i knun kaltulusan. Dekan i dad busaw, na mimen ale.” ");
INSERT INTO bpr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na too mlal mbel i santulen gablà ku Dyisas di kabal Galili. ");
INSERT INTO bpr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na mdà ale Dyisas di gumnè gal gustifun i dad Dyu, na salu ale ditù di gumnè Simon na Andru. Na lê magin Dyém na Dyan. ");
INSERT INTO bpr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na milè tewe Simon libun du too ti minit i lawehan. Na gasilla tulen ani di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Fdadong kenen di libun ayé, na nagotan i sigalan, na ntékan kenen. Tadè mkah i kinitan, na fles mimò dale knaan. ");
INSERT INTO bpr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Di kasdaf i du, nebe dad to déé di ku Dyisas i kdee dademela nun tduk, na i dad to nun busaw. ");
INSERT INTO bpr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na too ti dee dad to mdà di banwe ayé stifun di saféd i gufusuk di gumnè ayé. ");
INSERT INTO bpr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na yé duenam man, nun dee dad to fan-gulê Dyisas di dad sahal tduk. Na lêan falwà dee busaw. Na là ftalùan ale du gadèla ku simto kenen. ");
INSERT INTO bpr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na too flafus di tmadol du, di fa làan too malwa, ta mték Dyisas, na mdà kenen salu di satu banwe landè to mnè ditù du dmasal. ");
INSERT INTO bpr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na ta lê mdà ale Simon du fanngaballa kenen. ");
INSERT INTO bpr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na di ta kitela dun, manla, “Fanngabal i kdee dad to ge.” ");
INSERT INTO bpr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bay man Dyisas di dale, “Fles ato di dademe dad banwe mdadong dini du fye lêgu tdò i Fye Tulen ditù, du yé sa i duen-gu salu dini di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na taman, lanngab Dyisas i banwe Galili. Tamdò kenen di dad gumnè gal gustifun i dad Dyu, na falwàan dad busaw di dad to. ");
INSERT INTO bpr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na nun satu lagi nun fdasan mumuh salu di ku Dyisas, na lkuad di munan, na too fakdo, manan, “Ku beg ge mayè, gadègu gaganam agu fan-gulê du fye too mlaneb i kulitgu.” ");
INSERT INTO bpr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Too bong kakdo Dyisas dun, taman nagotan, na manan, “Mayè agu sa. Mgulê ge nan.” ");
INSERT INTO bpr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na tadè mkah i fdasan mumuh ayé, na ta too mlaneb i kulitan. ");
INSERT INTO bpr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Gasil Dyisas fdà kenen, na toon ti dek, manan, ");
INSERT INTO bpr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nangam ti tulen ani balù simto dun, bay mdà ge, na fitem i laweham di ganlal di kafaglut gal damsù, na nebem ditù i dsùam gambet i uldin Dwata di dad sulat Mosis. I dsù nebem, yé gugmadè i kdee dad to dun na ta mgulê ge na ta mlaneb i kulitam.” ");
INSERT INTO bpr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bay di kdà i lagi ayé, balingan too tulen gablà di kgulêan, na too ti mbel i santulen ani. Yé duenam man, ta là too gfite Dyisas di dad banwe du gal dee dad to stifun di safédan. Lon gal salu di dad banwe gulà dee dad to, bay knèan gal dee dad to salu di kenen mdà di dad sahal banwe. ");
INSERT INTO bpr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na kafnge file du, lê samfulê Dyisas di Kapernaum. Na linge i dad to déé na ta lê kenen kel. ");
INSERT INTO bpr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yé duenam man, too ti dee dad to stifun déé, na fital i gumnè kel di lwà. Na tdò Dyisas ale i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na nun fat lagi kel déé, na nun nebela to là galyakan i lawehan, santiangla magin i gumilèan. ");
INSERT INTO bpr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Du landè kibòla fdadong di ku Dyisas du mdà di kdee dad to stifun, lanketla i dademe ataf gsen tah i gutamdò Dyisas klola fayol kenen magin i gumilèan. ");
INSERT INTO bpr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na kanto teen Dyisas i bong ksaligla, manan di to là galyak, “E Tò, ta magfasinsya nan i dad salàam.” ");
INSERT INTO bpr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na nun dad to sudeng déé i gal tamdò i dad uldin Dwata fagu di ku Mosis, yé mnè di fandamla, ");
INSERT INTO bpr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kan ku talù i to ani gambet ayé? Mlad kenen du landè dademe gmagan fmasinsya i salà, lo senan Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na ta gadè Dyisas i mnè di fandamla, na manan di dale, “Kan ku ani fandamyu? ");
INSERT INTO bpr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nun klahilan ku yé man-gu, ‘Ta magfasinsya nan i dad salàam.’ Bay baling mlimah ku yé man-gu di to là galyak, ‘Mték ge, nwèam i gumilèam, na magu ge,’ du fakayyu gadè ku nun glalgu demen ku landè. ");
INSERT INTO bpr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na yé kayègu ku gadèyu na do, dunan i dnagit Ngà To, nun glalgu dini di tah tanà fmasinsya salà.” Na kafnge Dyisas man ayé di dale, ta talù di to là galyak, na manan, ");
INSERT INTO bpr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Dekta ge, mték ge, nwèam i gumilèam, na mulê ge.” ");
INSERT INTO bpr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na tadè tadag i to ayé, na ta nwèan i gumilèan, na lamwà di bleng i kdee dad to. Na tngah i dad to déé, na dnayenla i Dwata, manla, “Landè lmento teen galò ani.” ");
INSERT INTO bpr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na lê mdà Dyisas salu di kilil i bong lanaw. Na too dee dad to stifun di safédan, na tdòan ale. ");
INSERT INTO bpr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Di laman magu, nun teenan satu to dnagit Libay, i ngà Alfyus. Déé kenen di gutalbahò i dad to gal mwè bayad i buhis du yé sa i knalaman nimò. Na man Dyisas di kenen, “Magin ge di do.” Na ta tadag Libay, na fles magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na kmaan ale Dyisas di gumnè Libay. Na yé kmaan di saféd Dyisas na i dad to galan tdò dee dademe dad to gal mwè bayad i buhis, na lê dademe dad to lmafà dad uldin Dwata du ta dee ale i gal magin di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na i dademe dad to gal tamdò dad uldin Dwata fagu di ku Mosis i glam di dad Farisi, kantola teen na yé dademe ale Dyisas kmaan i dad to gal mwè bayad i buhis na dademe to gal lmafà i uldin Dwata, manla di dad to tdòan, “Kan ku kmaan Dyisas di saféd i dad to gal mwè bayad i buhis na dademe to gal lmafà i uldin Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kanto linge Dyisas i manla ayé, tmimel kenen fagu di fléd, manan, “I to fandas, nun gukmamun i to mulung. Bay i to landè fdasan, landè gukmamun i to mulung. Ise ku i dad to tluh i fanngabalgu, bay i dad to gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Di satu du, fwasa i dad to gal tdò Dyan na lê man i dad to gal tdò i dad Farisi. Nun dademe dad to salu di ku Dyisas, na smalek ale, manla, “Mdà dad to gal tdò Dyan Gal Munyag, na balù i dad to gal tdò dad Farisi, gal ale fwasa. Bay i dad to tdòam ge, kan ku là fwasa ale?” ");
INSERT INTO bpr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tmimel Dyisas fagu di fléd, manan, “Ku fkahta di dad to nlak magin samsong, fwasa ale kè ku sana kdéé di safédla i lagi sansong? Là. Là tayò ale fwasa ku sana kdéé i lagi sansong. ");
INSERT INTO bpr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bay nun du kadang ku ta là dini di safédla i lagi sansong, na yé klola fwasa. ");
INSERT INTO bpr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Là fakay klafang i falami falnas di labi klaweh ta baltok du tà saksang i klafang ayé, na ta baling bong i kasêan. ");
INSERT INTO bpr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na là fakay kah di lam i labi kulit i falami binu du keng btù i kulit du kmadok fa i binu, na malmo i binu na lê man i kulit. Yé duenam man, yé gumkah i falami binu di falami kulit.” ");
INSERT INTO bpr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Di satu Du Kaftud i dad Dyu, magu ale Dyisas di satu lnigo. Di lamla magu, yé nimò i dad to galan tdò beg ale kambang là dee dad kigan trigo. ");
INSERT INTO bpr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na man dad Farisi di ku Dyisas, “Neyem. Ta kamtu dad to tdòam di Du Kaftud. Là fakay ayé, du fnang Dwata di uldinan fagu di ku Mosis.” ");
INSERT INTO bpr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na man Dyisas di dale, “Kan kè? Là lmenyu masa gablà di nimò Dabid du mdà di kbitilan na i dademen? ");
INSERT INTO bpr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Di kagot Abiatar, dunan i ulu i dad ganlal di kafaglut di munan, ani nimò Dabid. Fusuk kenen di Bong Gumnè Gumangamfù di Dwata, na nwèan i fan gal blé di Dwata. Na blaam, yé lo fakay kmaan i fan ayé i dad ganlal di kafaglut, bay knèan kmaan Dabid i fan ayé, na ta banlén i dademen.” ");
INSERT INTO bpr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na fadlug Dyisas talù, manan, “Yé duen Dwata mimò i Du Kaftud du tabengan di dad to. Du yé funan nimò dunan i dad to, na fnge, blén i uldinan gablà di Du Kaftud. Yé gugmadèto dun na mabtas fa i dad to di dad uldin. ");
INSERT INTO bpr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yé duenam man, yé magot i Du Kaftud dunan i Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Di satu du, lê fusuk Dyisas di gumnè gal gustifun i dad Dyu. Nun teenan déé satu lagi fikot i bali tnalòan. ");
INSERT INTO bpr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na nun dademe dad to déé, too ale meye kfagu du fye nun gutadagla tmifù ku Dyisas, taman, toola kenen tnanul du neyela ku fan-gulêan i to ayé di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na talù Dyisas di lagi fikot i tnalòan, na manan, “Tadag ge di muna.” ");
INSERT INTO bpr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na smalek Dyisas di dad to, manan, “Dét man i uldin Dwata fagu di ku Mosis? Dét i fye nimò di Du Kaftud, fye ku sasè? Tnabengto i dademe to, ku demen fnatito ale?” Bay tadè ale fanak. ");
INSERT INTO bpr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tamduk nawa Dyisas meye dale. Na sasè nawan du magéng ulula. Na manan di lagi fikot i sigalan ayé, “Bankeham i sigalam.” Kanton bankeh, tin tadè bkeh na ta mgulê. ");
INSERT INTO bpr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bay gasil lamwà dad Farisi, na stifun ale magin di dad to gsen di ku Harì Hérod, du santulenla ku dét i kibòla fmati ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mdà ale Dyisas na i dad to galan tdò di banwe ayé, na salu ale di bong lanaw. Na too dee dad to magin di dale mdà di dademe dad banwe, dunan mdà di Galili, ");
INSERT INTO bpr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na di Dyudiya, na di syudad Dyérusalém, na di banwe Idumya, na balù fa di dademe banwe mdà di faltù i Éél Dyordan, na mdadong di dad banwe dnagit Tiro na Sidon. Yé duenla salu gatù du ta lingela gablà di dad nimò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Du too dee dad to déé, ta dek Dyisas i dad to galan tdò fye ku nun falala tagà dun aweng i fakayan gumyak tà kenen fital. ");
INSERT INTO bpr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta dee nan i dad to fan-gulêan, taman gal saglad i dad to nun tduk magot di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na i dad to nun busaw, ku teenla kenen, gal ale lkuad lamfan, na mkit ale, manla, “Ge Ngà i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bay too fnang Dyisas ale tmulen ku simto kenen. ");
INSERT INTO bpr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na mnagad Dyisas di satu bulul, na tlon di safédan i dad to nalékan, na fdadong ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yé nalékan sfalò lwe to, yé katlon dale dad to galan dek. Mgimò ale dad to gal samnagin di kenen, na lêan ale dek tamdò i Fye Tulen di dademe banwe. ");
INSERT INTO bpr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na lêan ale banlé glal falwà dad busaw mnè di dad to. ");
INSERT INTO bpr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ani dagit i dad sfalò lwe to nalékan, Simon, dunan i dnagit Dyisas Piter, ");
INSERT INTO bpr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na lê Dyém, na i flanekan Dyan, dunan i dad ngà Sébidi. Dnagit Dyisas ale Boanigis, yé gumtatekan dunan i dad to gambet kilet. ");
INSERT INTO bpr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na lêan fagin nalék Andru, na Filip, na Bartolomyu, na Matyu, na Tomas, na Dyém dunan i ngà Alfyus, na Tadyus, na Simon dunan i msen i banwen. ");
INSERT INTO bpr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na lêan nalék Dyudas Iskariyot, dunan i makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na ta lê mulê Dyisas di banwe gumdàan. Na lê nun dee dad to stifun déé, na yé duenam man là gasleng Dyisas kmaan na i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kanto gadè dad flanekan ani, salu ale di kenen du nngéla, du yé man dademe dad to gablà di kenen ta book kun. ");
INSERT INTO bpr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na lê nun kel fdu di Dyérusalém i dademe dad to gal tamdò i uldin Dwata fagu di ku Mosis. Yé manla gablà di ku Dyisas, “Yé ta mnè di kenen Bélsébul, i gumdatah i dad busaw, na yé duenan gmagan falwà i dad busaw.” ");
INSERT INTO bpr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yé duenam man, tlo Dyisas ale, du talù di dale fagu di dad fléd, manan, “Là gagan Satanas falwà i kton. ");
INSERT INTO bpr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ku fkahta di satu banwe, ku baling sfati i dad to slame dale, malmo i banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na ku fkahta di satu familya, ku gal ale sfati, baling malbà i familya ayé. ");
INSERT INTO bpr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na salngad ku Satanas, ku sanfatin i kton, ta maskah kenen. Ta là gmaganan, na yé ta gusen i kagotan. ");
INSERT INTO bpr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ku nun to kamgis na bnantayan i gumnèan, landè gamwè i knunan. Silang nun gamwè dun ku funan bnakus i to kamgis ayé. ");
INSERT INTO bpr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Too glut i man-gu di gamu ani, gagan Dwata fmasinsya i kdee salà i dad to na i kdee sasè manla gablà di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bay i to talù sasè gablà di Mtiu Tulus i Dwata, là fnasinsya i salàan, balù kel di landè sen. Too blat i salàan, gten kenen falnayam kel di landè sen.” ");
INSERT INTO bpr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yé duen Dyisas man ani du yé ta manla gablà di kenen na nun busawan. ");
INSERT INTO bpr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na di lam Dyisas tamdò, ta kel i yêan na dad flanekan. Tadag ale di lwà, na fngéla kenen. ");
INSERT INTO bpr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na nun dee dad to sudeng di safédan, na manla, “Ta déé yêam na dad flanekam di lwà, na snalekla ge.” ");
INSERT INTO bpr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na man Dyisas di dad to ayé, “Simto kè i yêgu na i dad flanekgu?” ");
INSERT INTO bpr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Neyen i dad to sudeng di safédan, na manan, “Ani i yêgu na dad flanekgu. ");
INSERT INTO bpr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Du ku simto mimò i knayè Màgu, yé mgimò flanekgu lagi, na flanekgu libun, na i yêgu.” ");
INSERT INTO bpr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na lê tamdò Dyisas di kilil i bong lanaw, na too dee dad to stifun déé. Taman, myak kenen di aweng du déé gusudengan na lamtew i aweng ayé. Na déé dad to di kilil i lanaw. ");
INSERT INTO bpr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na dee dad tdò Dyisas di dale fagu di dad fléd. Ani manan, ");
INSERT INTO bpr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Too gamu flinge. Nun to salu di dnarun du smabul bnê. ");
INSERT INTO bpr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kanton sabul, nun dademe dad bnê gtadè di bà dalan, na fti tnukè dad anuk mayeng. ");
INSERT INTO bpr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nun dademe dad bnê gtadè di gudee batu, na landè alì tanàan. Too mlal msut di tah i dad tabòla, du mngifi i tanàan. ");
INSERT INTO bpr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bay kanto msut i du, ta mlanas na mati du là too ale dmalil. ");
INSERT INTO bpr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lê nun dademe dad bnê gtadè di lam dad bnas nun sual. Na kanto tahà i bnas, ta mlimas dad tabò i dad bnê. Taman là menge ale. ");
INSERT INTO bpr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bay nun dademe dad bnê gtadè di gufye i tanà. Too tmabò i dad bnê ani, na mlal tahà, na too menge. Yé ulê i dademe dad bnê ani tlu falò, na dademe nam falò, na dademe mlatuh.” ");
INSERT INTO bpr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na kafnge Dyisas tmulen i fléd ayé, manan, “Ku simto i nun klinge, fye ku too flinge.” ");
INSERT INTO bpr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kanto là dee dad to, ta fdadong i sfalò lwe to galan tdò na lê man dademe dad to, na snalekla Dyisas gablà di dad fléd. ");
INSERT INTO bpr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na man Dyisas di dale, “Faglabatgu di gamu i dad gbuni gablà di Kagot i Dwata. Bay di dademe dad to, fagugu di fléd i dad tdògu, ");
INSERT INTO bpr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","du fye balù ku meye ale, knèan là mite ale, na balù ku lminge ale, knèan là galmabat ale, tà ale msal na fnasinsya Dwata i dad salàla.” ");
INSERT INTO bpr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na smalek Dyisas, manan, “Là gadèyu gumtatek i fléd ayé? Ku là glabatyu dun, dét kibòyu galmabat i dademe dad fléd?” ");
INSERT INTO bpr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na nubadan di dale i fléd ayé gine, manan, “I bnê sabul i to ayé dunan Tnalù i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I tanà di bà dalan gugsabul i dademe dad bnê, dunan i dad to lminge i Tnalù i Dwata, bay di là mlo salu Satanas déé na nwèan i Tnalù ta gsabul di nawala. ");
INSERT INTO bpr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na i tanà gugsabul i dademe dad bnê gunun dee batu, dunan i dademe dad to too mlal dmawat i Tnalù Dwata di kaklingela dun, na too ale lehew di katbùan. ");
INSERT INTO bpr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bay là ale too dmalil, taman, là too ale mlo ftoo du ku ta nkel ale i klimah ku demen kaflayam du mdà di kdawatla i Tnalù i Dwata, knagolla i kaftoola. ");
INSERT INTO bpr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na i tanà gugsabul i dademe dad bnê gtadè lam bnas nun sual, dunan i dademe dad to lminge i Tnalù i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bay mlimas i Tnalù Dwata di nawala du mdà di klidù nawala, na i kiballa knun, na dademe knayè i ktola. Taman, là menge i Tnalù Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bay i fye tanà gugsabul i dademe dad bnê, dunan dad to dmawat i Tnalù Dwata di kaklingela dun, na too fye kbengen. Nun dademe, tlu falò i ulêla, na nun dademe nam falò, na dademe mlatuh i ulêla.” ");
INSERT INTO bpr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na fadlug Dyisas talù, manan, “Ku nun to fusuk mebe salò, là snukuban dun been, na là kahan dun di dungan i katri. Bay yé nimòan, kahan di gumefen. ");
INSERT INTO bpr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na salngad ayé, i kdee dad gbuni di mdu ani, teen kadang di satu du na gadè i kdee là fa gadè di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ku simto i nun klinge, fye ku too flinge.” ");
INSERT INTO bpr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na fadlug Dyisas talù, manan, “Tooyu fkah di nawayu i lingeyu, du nè kalbong kaglabat dnawatyu, yé sa kalbong kaglabat blé Dwata di gamu, na lêan tananù. ");
INSERT INTO bpr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ku simto fkah di nawan i ta gadèan, lê tananù Dwata i blén di kenen. Bay ku simto là fkah dun di nawan i ta gadèan, lê nawì Dwata balù i tukay ta glabatan.” ");
INSERT INTO bpr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na lê talù Dyisas fagu di fléd, manan, “Yé guflingen-gu i kbel i Kagot Dwata di ktabò i bnê sabul i satu to di tanàan. ");
INSERT INTO bpr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Laman kudang di kifuh na laman bliwal di mdu, ta tmabò i bnê ayé na lamnok, bay là gadè i to ayé i kibòan lamnok. ");
INSERT INTO bpr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yé gumdàan lamnok du mdà di knèan di tanà. Yé muna msut i muhad foonan, na tmadol i fusùan, kafnge ayé, i bengen. ");
INSERT INTO bpr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ku ta tagah i bengen, yé klo kamtu dun du ta kel i bulenan gafat.” ");
INSERT INTO bpr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Lê talù Dyisas, manan, “Dét guflingenta i Kagot Dwata? Ku demen, dét fye fléd fbateng dun? ");
INSERT INTO bpr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I kagotan gambet i bnê too tukay dnagit mustasa fele i satu to di tanàan. ");
INSERT INTO bpr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tmabò i bnê ani, na mbaling bong kayu. Too ti malbang i dad fangan, na déé gufgalung i dad anuk mayeng, na gusmalalla.” ");
INSERT INTO bpr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na fagu di dee dad fléd gambet ayé tdò Dyisas i Tnalù Dwata. Ku dét i gaganla ganbet, yé tdòan di dale. ");
INSERT INTO bpr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Landè tdòan di gudee dad to ku là fagun di fléd. Bay ku ta lo yé dademen i dad to galan tdò, ta nubadan di dale gumtatek i dad fléd. ");
INSERT INTO bpr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kanto sdaf i du, talù Dyisas di dad to galan tdò, manan, “Mdà ato mifal i lanaw.” ");
INSERT INTO bpr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na yé duenam man, tnagakla i dad to déé, na smakay ale di aweng tagnè gusudeng Dyisas, na faginla kenen. Na lê nun dademe dad to maweng magin dale. ");
INSERT INTO bpr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Di lamla maweng, ta nkel ale i kamgis nus di talà lanaw. Kanto mbugal i malbang lwek gtadè di awengla, ta fan fnò éél. ");
INSERT INTO bpr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bay déé Dyisas di ulin i aweng. Kudang kenen na kmama. Ta nukatla na manla, “E Sér, ta fan ato galnab. Mayè ge kè ku mlimas ato?” ");
INSERT INTO bpr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na yé duenam man, ta mték Dyisas, na nngakan i nus na lê i dad lwek, manan, “Ta batongyu nan.” Na tadè fanak i nus na mtanak i lanaw. ");
INSERT INTO bpr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na manan di dad to galan tdò, “Kan dé ku likò gamu? Là smalig gamu kè?” ");
INSERT INTO bpr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Too ale tngah, na sasalek ale, manla, “Simto i to ani? Balù i nus na lê i malbang lwek mimen di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na fles ale mifal di lanaw kel di banwe i dad to di Gérasin. ");
INSERT INTO bpr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na di ktufa Dyisas di aweng, snitong i satu lagi nun busaw. Yé gumdà i lagi ayé di dad ilib gulambang i dad to mati. ");
INSERT INTO bpr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na yé gufanak i lagi ayé di dad ilib gulambang, na landè kibòla mikat kenen, balù sangkalì. ");
INSERT INTO bpr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ta dee dulêla bnakus kenen di blìan na di sigalan, bay tadèan gal fantoh i dad sangkalì di sigalan, na tanfòan i dad tek di blìan. Na landè to gmagan mafas dun. ");
INSERT INTO bpr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Di kifuh na di mdu, déé kenen di dad gulambang na di dad bulul, na gal kenen mkit na sneeyan batu i lawehan. ");
INSERT INTO bpr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tlabo mawag fa, ta teenan Dyisas, na gasilan snitong, na fles lkuad di munan. ");
INSERT INTO bpr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Na mkit kenen, manan, “Dyisas, Ngà i Too Mdatah Dwata, dét i kibòam do? Samdagè ge di do fagu di dagit i Dwata na là falnayamam agu.” ");
INSERT INTO bpr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yé duenan man ayé du ta man Dyisas di busaw, “Lamwà ge di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na snalek Dyisas kenen, manan, “Dét i dagitam?” Na tmimel kenen, manan, “Yé dagitgu salagsà du too gami dee.” ");
INSERT INTO bpr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na too kenen fakdo du fye là dek Dyisas ale lamwà di banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na nun mdadong déé di dale dee dad sdè mateb di bulul. ");
INSERT INTO bpr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na fakdo i dad busaw di ku Dyisas, manla, “Dekam gami gatù di dad sdè ayé na fafusukam gami di dale.” ");
INSERT INTO bpr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na falohan ale, taman, ta lamwà ale di lagi ayé, na fles ale fusuk di dad sdè. Mdadong di lwe libu i kdee dad sdè ayé, na mti ale milah flasok di bilil, na kamyaf ale di kbe, na fles di lanaw, na sdulê ale mlimas. ");
INSERT INTO bpr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Milah dad to gal mifat i dad sdè ayé salu di lam i lunsud na di lwà i lunsud du tulenla i ta mkel ayé. Na i dad to gutmulenla dun, gasil ale gatù du neyela. ");
INSERT INTO bpr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na kanto ale kel di ku Dyisas, teenla i lagi gulamwà i dad busaw, na tadè kenen sudeng déé, na ta kalmaweh, na ta fye fandaman. Na too ale likò. ");
INSERT INTO bpr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na i dad to ta mite i dad mgimò di lagi ayé na lê man di dad sdè, tulenla di dad to falami kel. ");
INSERT INTO bpr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na yé duenam man, too fakdo dad to di ku Dyisas du fye tnagakan i banwela. ");
INSERT INTO bpr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na di kyak Dyisas di aweng, too fakdo i lagi gulamwà i dad busaw du kayèan magin. ");
INSERT INTO bpr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bay fnang Dyisas kenen, manan dun, “Mulê ge di dademem, na tulenam dale i kdee dad nimò Dwata di ge na i bong kakdon ge.” ");
INSERT INTO bpr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yé duenam man, ta mdà i lagi ayé, na tulenan di banwe dnagit Dikapolis i dad nimò Dyisas di kenen. Na too ti tikeng i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kanto lê mifal Dyisas di lanaw, nun dee dad to stifun déé di safédan. Déé kenen fa di kilil i lanaw, ");
INSERT INTO bpr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","na fdadong di kenen i satu ulu di gumnè gal gustifun i dad Dyu yé dagitan Dyairus. Na kanto kel déé, ta fles lamfan di saféd blì Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Na too kenen fakdo, manan, “Ta fan mati i tukay ngàgu libun. Beg ge magin do, na nagotam kenen du fye mgulê.” ");
INSERT INTO bpr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na yé duenam man, magin Dyisas di kenen. Lê nun dee dad to lmalò ku Dyisas, na fan là gagun du mdà di kasgat i dad to. ");
INSERT INTO bpr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na nun satu libun magin ta sfalò lwe fali klo i litèan sigi maloh. ");
INSERT INTO bpr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta too sasè kaflayaman feye i tdukan di dad to mulung, na ta mti i filakan. Bay là sa mkah tdukan, na ta baling matnù i ksasèan. ");
INSERT INTO bpr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ta lingen gablà ku Dyisas, taman, fdadong kenen di kagolan, na nagotan i saulan, ");
INSERT INTO bpr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","du yé fandaman, “Ku logu gagot i saulan, mgulê agu.” ");
INSERT INTO bpr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kanton gagot i saul Dyisas, tadè tlag kaloh i litèan, na galyalon na ta mkah i tdukan. ");
INSERT INTO bpr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na lyalo Dyisas ta nun kgagan lamwà di kenen. Yé duenan kmangél di dad to glibut di kenen, na smalek kenen, manan, “Simto magot di saulgu?” ");
INSERT INTO bpr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na tmimel i dad to galan tdò, manla, “Gadèam na dee dad to gihok di ge mdà di kasgatla, na kan dé ku snalekam ku simto magot ge?” ");
INSERT INTO bpr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bay too meye Dyisas du fye teenan ku simto i ta magot di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na gadè i libun ayé i ta mkel di kenen, na fdadong di ku Dyisas, na lamfan di saféd i blìan. Kankal kenen di klikòan, na tulenan i kdee. ");
INSERT INTO bpr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Man Dyisas di kenen, “Ta mgulê ge du mdà di nun kaftoom di do. Mulê ge, na i ktanak nawa mnè di ge du ta landè tdukam.” ");
INSERT INTO bpr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na di lam Dyisas talù, nun dademe dad to kel fdu di gumnè Dyairus, dunan i ulu di gumnè gal gustifun i dad Dyu, manla di ku Dyairus, “E Sér, ta là gumaham i ngàam du ta lanah. Ta nangam snamuk nan i To Tamdò.” ");
INSERT INTO bpr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bay tadè bayà Dyisas i manla, na manan di ku Dyairus, “Nang ge likò, bay lo ge ftoo.” ");
INSERT INTO bpr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kafnge ayé, ta lo yé falohan magin dunan Piter, na Dyém, na Dyan, dunan i flanek Dyém. ");
INSERT INTO bpr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kanto ale kel di gumnè Dyairus, linge Dyisas i ugak i dad to. Nun dee dad to mngel na lmanu. ");
INSERT INTO bpr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na fusuk Dyisas, na manan dale, “Kan ku mugak gamu na mngel? Là sa mati i ngà ayé, bay lo kudang.” ");
INSERT INTO bpr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na nadoyla kenen. Dek Dyisas i dad to ayé lamwà, bay neben fusuk dad tua i ngà ayé, na lê man i dad tlu to tdòan. Fusuk ale di snifil gumilè i ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nagot Dyisas i sigalan, na manan dun, “Talitha koum.” Yé gumtatekan dunan, “Bì, man-gu di ge, mték ge.” ");
INSERT INTO bpr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tadè mték i ngà ayé, na fles magu. Ta sfalò lwe falin. Too tikeng i dad to. ");
INSERT INTO bpr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bay too fnang Dyisas ale tmulen di dad to, na dekan i dad tuan mlé knaan di ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na mdà Dyisas salu di banwe gulamnokan, na magin dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kanto kel i Du Kaftud i dad Dyu, tamdò kenen di gumnè gal gustifun i dad Dyu, na too tikeng i dad to lminge i katdòan. Sasalek ale, manla, “Nè gugamwèan i gnadèan ani? Nè gumdà i kfulungan? Dét kibòan mimò dad gamtikeng ayé? ");
INSERT INTO bpr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ise ani kè i fanday ayé, i ngà Méri, na i flanek ale Dyém na Dyosis na Dyudas na Simon? Sana kdini di gito i dad flanekan libun.” Na i dad to déé, knangla kenen. ");
INSERT INTO bpr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bay man Dyisas di dale, “Lo yé gulà mgafè i satu tugad Dwata di kenen banwe di bleng i dad flanekan na i dademen.” ");
INSERT INTO bpr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na là toon gamgimò dad tnikeng di banwe ayé. Lon nagot i dademe to nun tduk du fan-gulêan ale. ");
INSERT INTO bpr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na too tikeng Dyisas du là ftoo ale di kenen. Na kafnge ayé, magu Dyisas di dad malnak banwe du tamdò. ");
INSERT INTO bpr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na tlo Dyisas i sfalò lwe to galan tdò, na dekan ale mdà men lwe, na banlén ale glal falwà i dad busaw mnè di dad to. ");
INSERT INTO bpr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na yé flaun dale, na lo tugad i fakay nebela di kagula. Nang ale mebe bnatu, ku demen kuyut, ku demen filak. ");
INSERT INTO bpr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Falohan ale tmalumfà, bay fnangan ale mebe galwe saul. ");
INSERT INTO bpr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na ani lêan flau dale, manan, “Ku nè gumnè gufusukyu, fanak gamu déé kel di lêyu kdà. ");
INSERT INTO bpr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na ku là dnawatla gamu di satu banwe, na ku là mayè ale flinge di tdòyu, di kdàyu, kakesyu i kfung di blìyu du yé ilè dun na dale tmimel i sasè nimòla di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yé duenam man, ta mdà ale tamdò, manla, “Msal gamu na tnagakyu dad sasè nimòyu.” ");
INSERT INTO bpr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na dee dad busaw falwàla mdà di dad to, na dee dad to nun tduk nkokla fngalo du fan-gulêla ale. ");
INSERT INTO bpr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Linge Harì Hérod gablà di kdee mgimò Dyisas, du ta too tatel i dagit Dyisas. Na yé man dademe dad to na yé kun gumdà i kgaganan di ku Dyan Gal Munyag du ta mték kenen mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na yé man dademe to gablà ku Dyisas, “Kenen Ilaydya, i satu tugad i Dwata di munan.” Na nun dademe yé manla, “Kenen i satu tugad i Dwata gambet dademe tugad i Dwata di munan.” ");
INSERT INTO bpr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bay di kaklinge Harì Hérod gablà ayé, manan, “Dyan Gal Munyag sa ayé. Ta faklanggu ulun, bay ta lê mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Du di munan, ta fakfè Hérod Dyan, na ta fikatan na fablanggùan. Yé duenan mimò ani du mdà di atul Hérodiyas, yaan i flanekan Filip. Du ta nlad Harì Hérod sa Hérodiyas ayé. ");
INSERT INTO bpr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Du gal man Dyan di ku Hérod, “Là fakayam nlad yaan i flanekam.” ");
INSERT INTO bpr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na yé duenan too nang nawa Hérodiyas ku Dyan, na kayèan fmati kenen, bay landè kibòan. ");
INSERT INTO bpr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Du mdà di klikò Harì Hérod, yé duenam man tnamangan Dyan du gadèan na kenen i satu to too tluh na too mtiu. Too mayè Hérod gal flinge di ku Dyan, bay lê gal msamuk i nawan. ");
INSERT INTO bpr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bay ta kel i du fatan Hérodiyas, na nimòan i knayèan, dunan slà di du kafaldam i ksut Harì Hérod. Ta mimò Hérod bong fista, na nlakan dad ganlal di gubirnu, na ulu i dad sundalu, na dademe mdatah to di banwe Galili. ");
INSERT INTO bpr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fusuk i ngà Hérodiyas libun, na sayew kenen, na too ti bayan ale Hérod. Na manan di ngà ayé, “Dét kayèam fni? Balù détan, blégu di ge.” ");
INSERT INTO bpr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na samdagè kenen, manan, “Fakanggu di ge na balù dét i fnim, kel di tngà i kdee dad nagotgu, blégu di ge.” ");
INSERT INTO bpr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na lamwà i ngà ayé, na snalekan yêan, manan, “Dét i fnigu kè?” Tmimel i yêan, manan, “Yé fnim i ulu Dyan Gal Munyag.” ");
INSERT INTO bpr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na gasil samfulê i ngà ayé di harì, na manan dun, “Yé kayègu blém do i ulu Dyan Gal Munyag, kaham di fligo.” ");
INSERT INTO bpr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Too mlidù nawa Harì Hérod di kafni i ngà ayé, bay landè kibòan du ta guna i kasdagèan na ta linge i dad to kmaan di safédan. ");
INSERT INTO bpr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na yé duenam man, gasilan dek i satu sundalun mwè i ulu Dyan. Na ta mdà i sundalu, na kanlangan i ulu Dyan di blanggù, ");
INSERT INTO bpr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na kahan di fligo, na neben déé, klon mlé dun di ngà libun ayé. Na mdà i ngà ayé, ta blén di yêan. ");
INSERT INTO bpr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na kanto linge i dad to gal tdò Dyan ayé, ta salu ale déé du nwèla i lawehan, na lbangla di ilib gal gulambang i dad to mati. ");
INSERT INTO bpr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kanto mulê i dad sfalò lwe to gal dek Dyisas, tulenla di kenen i kdee dad mgimòla na i kdee dad tdòla. ");
INSERT INTO bpr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na mdà di gal kdee dad to magin di dale, là gaslengla kmaan. Yé duenam man, man Dyisas di dale, “Fatfing ato gito di satu banwe mtanak du fye gaftud gamu.” ");
INSERT INTO bpr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na ta mdà ale maweng salu di satu banwe landè to mnè déé. ");
INSERT INTO bpr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bay nun dee dad to ta mite i kdà ale Dyisas, na du dilèla ale, ta gasil ale tmanà mdà di kdee dad lunsud déé, na ta baling dale muna kel. ");
INSERT INTO bpr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na kanto dmuung ale Dyisas, teenan i kdee dad to ayé, na too sè kakdon dale. Salngad ale i dad bilibili landè to mifat dale. Na yé duenam man, dee dad tdòan di dale. ");
INSERT INTO bpr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanto flabi, ta salu di ku Dyisas i dad to galan tdò. Manla di kenen, “Ta flabi nan, na landè gumnè mdadong dini. ");
INSERT INTO bpr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dekam dad to ayé mdà du fye mayad ale knaanla di dad gumnè na di dad malnak banwe ditù.” ");
INSERT INTO bpr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bay man Dyisas di dale, “Gamu i famkaan dale.” Smalek ale, manla, “Mayè ge kè ku mayad gami knaan gablà fkaan di kdee dad to ani? Ku yé nimòmi, i btas i knaan salngad di sukéy i satu to di lwe latuh du klon.” ");
INSERT INTO bpr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na snalekan ale, manan, “File batù fanyu? Mdà gamu na neyeyu.” Kantola neye, samfulê ale, na manla, “Lime batù fan, na lo lwe batù nalaf.” ");
INSERT INTO bpr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na man Dyisas di dad to galan tdò, “Fsudengyu dad to di bnas di dad sahal lumbuk.” ");
INSERT INTO bpr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na slumbuk ale sudeng, men mlatuh i dademe na men lime falò i dademe. ");
INSERT INTO bpr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na nwè Dyisas i lime batù fan na i lwe batù nalaf, na lngalà kenen di langit, na fasalamat di Dwata klon falnak dun, na blén di dad to galan tdò du fye nalella di dad to. Na lêan nalel i lwe batù nalaf di kdeela. ");
INSERT INTO bpr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na ta kmaan i kdeela, na bsol ale. ");
INSERT INTO bpr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na ta santifun i dad to gal tdò Dyisas i lukas fan na nalaf. Na yé kdeen, sfalò lwe been fnò. ");
INSERT INTO bpr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na yé kdee dad lagi kmaan lime libu. ");
INSERT INTO bpr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na kafnge ayé, gasil dek Dyisas i dad to galan tdò muna maweng mifal di bong lanaw salu di banwe Bétsayda. Na ftagak Dyisas du fdàan i dad to. ");
INSERT INTO bpr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na kafngen fdà dad to, mnagad kenen di satu bulul lon satu du dmasal. ");
INSERT INTO bpr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na kanto kifuh, ta ditù i dad to maweng di talà i lanaw, na lo satu Dyisas déé di kilil. ");
INSERT INTO bpr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na teenan dad to galan tdò, na too sasè kaflayamla kamwah i awengla du gsitongla i nus. Kanto mayè fayah, salu Dyisas di dale, na tadè kenen magu di tah i lanaw. Na ta fanan ale lnius. ");
INSERT INTO bpr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bay kantola teen kenen magu di tah i lanaw, man nawala ku lmagol, na mkit ale, ");
INSERT INTO bpr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","du ta kdeela mite dun, na too ale likò. Bay gasil talù Dyisas di dale, manan, “Fan-galyu nawayu. Do sa ani. Nang gamu likò.” ");
INSERT INTO bpr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na myak kenen di aweng magin dale, na tin tadè fanak i nus. Na too ale tikeng, ");
INSERT INTO bpr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","du balù ta teenla i gamtikeng nimòan di fan ayé, bay là glabatla, du là fa mgukà i fandamla. ");
INSERT INTO bpr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na fles ale mifal di lanaw, na dmuung ale di banwe Génésarét, na ikatla i awengla. ");
INSERT INTO bpr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanto ale tufa di aweng, dilè i dad to di banwe ayé Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na balù nè gusalun di banwe ayé, gasilla nwè dad to nun tduk, na nebela ale magin i dad gumilèla salu di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na balù nè gusalun di dad malnak banwe, ku demen di dad lunsud, na di dad gumnè, nebela i dademela nun tduk salu di gal gustifun i dad to. Na fakdo ale di ku Dyisas du fye began ale fagot balù lo di kilil i saulan. Na ku simto gmagot i saulan, mgulê. ");
INSERT INTO bpr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na ta kel fdu di Dyérusalem dademe dad Farisi na i dad to gal tamdò i uldin Dwata fagu di ku Mosis, na stifun ale di saféd Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Teenla kakaan i dademe to gal tdò Dyisas, là funa ale malob du là lalòla i tdò dad Farisi. ");
INSERT INTO bpr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Du silang kmaan i dad Farisi na lê man i kdee dademe Dyu ku funala too nalob i tnalòla du yé knalamla nimò glalòla di dad gutambulla. ");
INSERT INTO bpr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na ku kel ale fdu di fadyan, silang ale kmaan ku funa ale too malob. Na lê nun dee dademe nimòla, salngad kalob i dad basùla, na i dad tabùla, na i dad kulangla. ");
INSERT INTO bpr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yé duenam man, smalek i dad Farisi na i dademe to gal tamdò i uldin Dwata fagu di ku Mosis, manla ku Dyisas, “Là funa malob i dad to galam tdò di kakaanla. Kan ku là lalòla i flau dad gutambulto?” ");
INSERT INTO bpr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tmimel Dyisas, manan, “Too glut i man Dwata fagu di ku Isaya di munan gablà di gamu dad to flingu. Ani i fsulatan, ‘I dad to ani, toola agu nafè fagu di talùla, bay too mawag i fandamla di do. ");
INSERT INTO bpr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Landè gukmamu i kfangamfùla di do du yé gumdà i dad flaula di dad to balù ku yé manla kun mdà di Dwata.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na fanles Dyisas i manan di dale, “Ta tnagakyu i uldin Dwata, na yé lalòyu i flau dad to. ");
INSERT INTO bpr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tay kfulungyu tmagak i uldin Dwata du fye glalòyu i adatyu. ");
INSERT INTO bpr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kaflingenta dun, yé uldin Dwata fagu di ku Mosis, manan, ‘Nafèyu i màyu na i yêyu,’ na ‘ku simto to talù sasè di màan ku demen di yêan, là fakay ku là fnati dun.’ ");
INSERT INTO bpr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bay yé galyu tdò ku nun tabeng fan blé satu to di dad tuan, fakayan man di dale, ‘Korban,’ yé gumtatekan, ‘I fan-gu blé di gamu, ta balinggu blé di Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na mdà di manan ayé, ta galyu faloh kenen balù ku là fiten i afèan di dale fagu di tabengan ani. ");
INSERT INTO bpr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mdà di katdòyu i gamu adat, ta flandèyu btas i Tnalù Dwata. Na nun fa dademe nimòyu salngad ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na lê tlo Dyisas i dad to di safédan, na talù di dale fagu di fléd, manan, “I kdeeyu, too gamu flinge, na tooyu fan-glabat ani di ktoyu. ");
INSERT INTO bpr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ise ku yé gamfagsik i satu to i fusuk di bàan. Bay yé gamfagsik kenen i lamwà di bàan. ");
INSERT INTO bpr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ku simto i nun klinge, fye ku too flinge.” ");
INSERT INTO bpr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tnagak Dyisas i dad to, na fusuk kenen di lam i gumnè. Magin dad to galan tdò, na smalek ale gablà di fléd ayé gine. ");
INSERT INTO bpr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na man Dyisas di dale, “Balù gamu, là fa kadì galmabat. Gablà ku ta gadèyu na ise ku i fusuk di bà i satu to i gamfagsik kenen. ");
INSERT INTO bpr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Du ku dét fusuk di bà i satu to, yé guflesan di tienan, na fnge lê lamwà. Na ise ku yé dalanan di nawan.” Di kman Dyisas ayé tulenan dale na landè magsik di kdee dad knaan. ");
INSERT INTO bpr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na fanlesan i talùan, manan, “Yé gamfagsik i satu to i lamwà di bàan. ");
INSERT INTO bpr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Du mdà di lam i nawan, nun dad sasè fandam, na i ksaféd di to ise yaanan, i ktaku, i kbanò, ");
INSERT INTO bpr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","i klafà yaan, i klom, i ayè mimò sasè di dademe to, i kafgaw, i klandè kyà, i kafè nawa, i ktalù sasè gablà di dademe to, i kafdatahan i kton, na i klandè ldam. ");
INSERT INTO bpr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yé gumdà i kdee sasè ani di nawa i satu to. Yé gamfagsik kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kafnge ayé, tnagak Dyisas i banwe ayé, na fles kenen di banwe mdadong di syudad Tiro. Fusuk kenen di satu gumnè, na yé kayèan ku landè gmadè na déé kenen di lam, bay là gbunin i kton. ");
INSERT INTO bpr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na nun satu libun déé, nun ngàan libun nun busaw. Kanto linge i yêan na déé Dyisas, ta gasil kenen salu déé na lkuad lamfan di saféd i blì Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na ise Dyu i libun ayé du ise ku Israél i gumdàan, bay di banwe dnagit Fonisya glam di Sirya. Na fakdo kenen di ku Dyisas fye falwàan i busaw di ngàan ayé. ");
INSERT INTO bpr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bay tmimel Dyisas fagu di fléd, manan, “Fye ku funagu fankaan i dad ngà, du là fakay nwè i knaan i dad ngà na blé di dad ayem.” ");
INSERT INTO bpr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na man i libun ayé, “Hee Amu, gadègu ayé. Bay balù i dad ayem, beg nun gwèla du gamkaan ale samel mtatek mdà di lamisa gukmaan i dad ngà.” ");
INSERT INTO bpr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na man Dyisas di kenen, “Du mdà di kafye i manam, mulê ge nan du ta lamwà i busaw di ngàam.” ");
INSERT INTO bpr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta mulê i libun ayé, na kakelan di gumnèan teenan i ngàan lo milè du ta lamwà i busaw. ");
INSERT INTO bpr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kafnge ayé, ta tnagak Dyisas Tiro, na yé dalanan magu kamlang di banwe Sidon, na fles kenen di Lanaw Galili, na yé dalanan salu ditù magu di Dikapolis. ");
INSERT INTO bpr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","I dad to déé, nebela di ku Dyisas i satu lagi bakong na mlimah ktalùan. Na yé fnila ku nagot Dyisas kenen fye mgulê. ");
INSERT INTO bpr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yé duenam man, nebe Dyisas kenen mdà di dad to, na klilukan i dad knamatan di sbalà klinge i bakong ayé. Na fnge, fnafêan ibal i dad tnalòan, na ihokan di dilàan. ");
INSERT INTO bpr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lngalà Dyisas di langit, na falbongan kalnawan, na manan, “Ifata.” Yé gumtatekan, “Mgukà nan.” ");
INSERT INTO bpr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Di kmanan ayé, tadè mgukà i klinge i bakong ayé, na salngad ku ta magteh i dilàan du ta fye i ktalùan. ");
INSERT INTO bpr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Fnang Dyisas ale tmulen i dad nimòan ayé. Bay balù ku galan ale fnang, baling midul fa i ktulenla dun. ");
INSERT INTO bpr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na too ti tikeng i kdee dad to lminge gablà di mkel ani, na manla, “Too ti fye i kdee dad nimòan. Balù i dad bakong na i dad umu fan-gulêan.” ");
INSERT INTO bpr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Di satu du, ta lê nun dee dad to stifun. Na du landè knaanla, tlo Dyisas i dad to galan tdò, na manan di dale, ");
INSERT INTO bpr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Toogu kando i dad to stifun ani, du ta tlu dula fanak di safédgu, na ta landè knaanla. ");
INSERT INTO bpr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ku fulêgu ale di là ale fa kmaan, keng bek ale mdà di kbitilla du mawag gumulê dademe.” ");
INSERT INTO bpr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na smalek i dad to galan tdò, manla, “Nè gumwèto knaan di banwe ani i gablà fkaan i kdee dad to ani? Fye ku nun dad to mnè mdadong dini.” ");
INSERT INTO bpr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na lê smalek Dyisas, manan, “File batù fanyu déé?” Tmimel ale, manla, “Fitu batù.” ");
INSERT INTO bpr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na dekan sudeng i dad to di tanà. Na kafnge ayé, ta nwèan i fitu batù fan, na fasalamat di Dwata klon falnak dun na blén di dad to galan tdò du fye dale i malel dun. Na ta nwèla i fan ayé, na nalella di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na lê nun dad malnak nalaf, bay là deen. Lêan fnasalamat i nalaf ani klon falel dun. ");
INSERT INTO bpr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na ta kmaan i kdeela na bsol ale. Na ta santifun i dad to gal tdò Dyisas i lukas. Na yé kdeen, fitu been fnò. ");
INSERT INTO bpr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yé kdee dad to kmaan nun dad fat libu. Na kafnge ayé, ta fdà Dyisas ale. ");
INSERT INTO bpr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na gasil myak Dyisas di aweng magin dad to galan tdò, na salu ale di banwe Dalmanuta. ");
INSERT INTO bpr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na nun dad Farisi salu di ku Dyisas, na sanbalewla kenen. Tnilewla kenen fagu di kafnila tnikeng du gugmadèla dun na yé gumdàan di langit. ");
INSERT INTO bpr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Falbongan i kalnawan, na manan, “Kan ku mni i dad to di du ani dad tnikeng? Too glut i man-gu ani na landè tnikeng fitegu di gamu.” ");
INSERT INTO bpr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na kafnge ayé, lê tnagak Dyisas ale, na myak di aweng du mifal di bong lanaw. ");
INSERT INTO bpr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na glifet i dad to gal tdò Dyisas mebe bnatu di aweng. Lo salbatù fan i nebela. ");
INSERT INTO bpr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na talù Dyisas fagun di fléd, manan dale, “Fan-geyeyu i gambet bulung falnok fan mdà di dad Farisi na mdà di ku Harì Hérod.” ");
INSERT INTO bpr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na stulen ale lo dale, na manla, “Yé duen Dyisas man ani du là mebe ato bnatu.” ");
INSERT INTO bpr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gadè Dyisas i santulenla, na manan dale, “Kan ku santulenyu i klandè bnatuyu? Fa là gadèyu dun kè? Magéng uluyu fa? ");
INSERT INTO bpr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nun sa matayu, bay sawe là mite gamu. Nun sa klingeyu, bay sawe là lminge gamu. Kan? Là gafaldamyu dun kè? ");
INSERT INTO bpr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Di kafalnakgu i lime batù fan du fkaan di lime libu dad to, file been fananòyu?” Na tmimel ale, manla, “Sfalò lwe.” ");
INSERT INTO bpr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na lê kenen smalek, manan, “Na di kafalnakgu i fitu batù fan du fkaan di fat libu dad to, file been fananòyu?” Na tmimel ale, manla, “Fitu.” ");
INSERT INTO bpr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na man Dyisas di dale, “Na kan ku là fa glabatyu?” ");
INSERT INTO bpr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kafnge ayé, ta salu ale Dyisas di Bétsayda, na nun dademe dad to déé, nebela i satu lagi butè di ku Dyisas. Na fakdo ale fye nagotan na fan-gulêan. ");
INSERT INTO bpr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nagot Dyisas sigal i butè ayé, na nalakan kenen lamwà di tukay banwe ayé. Nihokan ibal i matan, na nagotan kenen. Na kafnge ayé, ta snalek Dyisas kenen, manan, “Nun teenam?” ");
INSERT INTO bpr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na kanto tukeng i butè ayé, manan, “Nun teen-gu dad to, bay yé kitegu dale gambet i dad kayu magu.” ");
INSERT INTO bpr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lê man nagot Dyisas i dad matan. Too meye i lagi, na ta mgulê, na ta too mtiu i kiten. ");
INSERT INTO bpr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na dek Dyisas kenen mulê, na manan dun, “Nang ge lê samfulê di tukay banwe ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na kafnge ayé, ta mdà Dyisas na dad to galan tdò. Salu ale di dad malnak banwe glam di Sisarya Filipus. Na di kagula salu ditù, snalekan ale, manan, “Dét man i dademe dad to gablà di do? Simto agu kun?” ");
INSERT INTO bpr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na tmimel ale, manla, “Yé man dademe to na ge Dyan Gal Munyag, na i dademe, manla ge Ilaydya, na i dademe, manla ge i satu tugad i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na lêan ale snalek, manan, “Na gamu? Di fandamyu, simto agu kè?” Na tmimel Piter, manan, “Ge sa i Krayst, dunan i Mgalék Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na fnang Dyisas ale tmulen di balù simto dun. ");
INSERT INTO bpr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na tambù kenen fgadè di dad to galan tdò gablà di fan mkel di kenen, manan, “Là ti fakay ku là dee kaflayam mkel di do, dunan i dnagit Ngà To. Na i dad tua gal mebe i dad to, na i dad ganlal di kafaglut, na dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, knagolla agu, na fnatila agu, bay di gatlun du, lê agu mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na toon fbateng i manan ayé di dale. Na yé duenam man, nebe Piter kenen di kilil na nngakan. ");
INSERT INTO bpr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bay kanto kmangél Dyisas, na teenan dademe to galan tdò, ta nngakan Piter, na manan, “Fawag ge di do, Satanas, du ise mdà di Dwata i fandamam ayé, bay mdà di dad to.” ");
INSERT INTO bpr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na ta tlo Dyisas dee dad to, na lê déé dad to galan tdò. Na manan di kdeela, “Ku simto mayè magin di do, là fakay ku là lnifetan i kton, na tniangan i krusan, na magin do. ");
INSERT INTO bpr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ku simto kmabas i nawan, baling lanah di kenen. Bay ku simto mati du mdà di kaginan di do na i kaftoon di Fye Tulen, nun nawan landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dét i fye untung i satu to ku gfunan i klamang banwe bay là gfunan i nawa landè sen? ");
INSERT INTO bpr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Landè fakayan blé ku lulukan i nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nun dee dad to di bang ani mimò sasè na knangla i Dwata. Na ku nun to ftoo di do gbol di dad to ayé, na kyàan agu na i dad dekgu, do i dnagit Ngà To, lêgu kenen kyà ku ta samfulê agu di kdatahgu na i kdatah Màgu na i dad kasaligan too mtiu.” ");
INSERT INTO bpr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na fadlug Dyisas talù, manan di dale, “Too glut i man-gu di gamu ani, nun dademe dad to tadag dini, na silang ale mati ku ta teenla i kaltulus i Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kafnge nam butang, fagin Dyisas Piter na Dyém na Dyan, du salu ale di tah i satu mdatah bulul, lo dale. Na tadè mgilih i baweh Dyisas déé di kitela dun. ");
INSERT INTO bpr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na samfilà i klawehan di kbukay. Landè to di klamang banwe gmagan fbukay klaweh salngad ayé. ");
INSERT INTO bpr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na tadè msut déé di dale lwe to, dunan Ilaydya na Mosis, na stulen ale Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na man Piter di ku Dyisas, “Amu, too fye du dini gami. Fye ku fdak gami tlu slung, satu di ge, satu ku Mosis, na lê satu ku Ilaydya.” ");
INSERT INTO bpr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yé duen Piter man ayé du là gadèan ku dét i fye manan du too ale likò. ");
INSERT INTO bpr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na lam Piter talù, makto kel i labun déé, na lnimunan ale. Na nun talù mdà di labun ayé, manan, “Ani Ngàgu toogu kanbong nawa. Falningeyu kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na gasil ale meye lmibut, na ta landè dademe dad to teenla, lo Dyisas déé di safédla. ");
INSERT INTO bpr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Di kaflasokla di bulul, man Dyisas di dale, “Nangyu tayò tulen i ta teenyu ayé gine. Silangyu tulen ku ta mték agu di fati, dunan i dnagit Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na nimenla i man Dyisas ayé, bay ku ta lo dale, ta yé galla santulen ku dét gumtatek i manan ayé, “Mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na smalek dad to galan tdò di kenen, manla, “Dét duen i dad to gal tamdò dad uldin Dwata fagu di ku Mosis man dun na too mabtas ku muna kel Ilaydya klo i Mgalék Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na tmimel Dyisas, manan, “Too sa, na yé muna kel Ilaydya du fatlagadan i kdee. Bay, dét kè duen i dad tugad Dwata di munan fala smulat gablà di do, i dnagit Ngà To, na manla là fakay ku là dee kaflayam i mkel di do na lê knang nawa i dad to agu? ");
INSERT INTO bpr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ani i man-gu di gamu, ta kel sa Ilaydya, na ta nimòla di kenen i kdee knayèla nimò di kaflayamla kenen gambet i ta fala fsulat Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kanto samfulê ale Dyisas di saféd i dademela, ta nun dee dad to stifun déé. Na yé nimò i dad to gal tamdò i uldin Dwata fagu di ku Mosis, sanbalewla i dad to gal tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kanto teen i dad to Dyisas, too ale tikeng, na gasilla snitong na dnawatla kenen. ");
INSERT INTO bpr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na snalek Dyisas ale, manan, “Dét i sanbalewyu?” ");
INSERT INTO bpr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na nun satu lagi gbol di kdee dad to ayé, manan, “Sér, ta nebegu i ngàgu di ge du nun busaw i gamfumu dun. ");
INSERT INTO bpr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ku ta gal fnusuk i busaw kenen, tadèan gal tudà di tanà. Na gal mulak i bàan, na kminggat i kifanan, na tadè magéng i lawehan. Ta beg agu fakdo di dad to galam tdò du fye falwàla i busaw, bay là gaganla dun.” ");
INSERT INTO bpr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na man Dyisas di kdeela déé, “E tay gamu dad to là ftoo. Ta là manam i klogu fanak di safédyu, na toogu fantahà i nawagu di gamu, bay knèan sana là kaftooyu. Nebeyu di do i ngà ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na ta nebela kenen di ku Dyisas. Kanto teen i busaw Dyisas, fakakalan i ngà ayé, na tadè kenen bek, na flulid di tanà, na mulak i bàan. ");
INSERT INTO bpr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na snalek Dyisas mà i ngà ayé, manan, “Ta mlo kè i tdukan?” Tmimel i màan, manan, “Tagnè mdà di ktukayan. ");
INSERT INTO bpr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta dee dulêan gbat di lifoh na di lam i éél du kayè i busaw fmati dun. Bay ku gaganam, begam gami kando na tnabengam gami.” ");
INSERT INTO bpr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na man Dyisas di lagi ayé, “Kan dé ku manam, ‘Ku gaganam?’ Gagan Dwata mimò balù détan di dad to ftoo di kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na falbong i lagi ayé i talùan, manan, “Ftoo agu sa, bay là fa sikofan. Taman, toom agu tnabeng du fye matnù i kaftoogu.” ");
INSERT INTO bpr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na kanto teen Dyisas na ta dee dad to gasil salu di kenen, ta nngakan i busaw, manan, “Ge busaw fbakong na fumu, man-gu di ge, lamwà ge di kenen, na ta nang ge lê samfulê.” ");
INSERT INTO bpr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta mkit i busaw, na fakakalan i ngà ayé, klon lamwà. Man nawam ku ta mati i ngà ayé. Na man dee dad to, “Ta kfatin sa ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bay nagot Dyisas sigalan du ntékan, na ta fles tadag i ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kanto fusuk Dyisas di lam i gumnè, na ta lo kenen na i dad to galan tdò déé, ta smalek ale, manla, “Dét i duenmi là gmagan falwà i busaw atù gine?” ");
INSERT INTO bpr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na tmimel Dyisas, manan, “Lo fagu di kdasal gaganyu falwà i busaw salngad ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tnagakla i banwe ayé, na yé dalanla magu di Galili. Là mayè Dyisas ku nun dademe dad to gmadè, ");
INSERT INTO bpr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","du ta lo yé tdòan i dad to galan dek, manan dale, “Do, i dnagit Ngà To, fanla agu blé di kagot i dad to, na fnatila agu, bay di gatlun du lê agu mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bay là glabatla gumtatek i manan ayé, na likò ale smalek dun. ");
INSERT INTO bpr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kafnge ayé, ta salu ale di Kapernaum. Na kanto fusuk ale Dyisas di lam i gumnè, snalekan i dad to galan tdò, manan, “Dét i san-gilyu gine di dalan?” ");
INSERT INTO bpr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bay tadè ale fanak du yé san-gilla di dalan du san-gladla ku simto di dale i too mdatah di kdeela. ");
INSERT INTO bpr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanto sudeng Dyisas, tlon dad sfalò lwe to galan dek, na manan, “Ku simto i mayè mdatah, fye ku fdanàan i kton, na tnabengan i kdee.” ");
INSERT INTO bpr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na mwè kenen ngà du ftadagan di kanfela. Na kafnge ayé, lkafan i ngà, na manan di dale, ");
INSERT INTO bpr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ku simto dmawat satu ngà gambet ani du mdà di ksasatun di do, ta lêan agu dnawat. Na ku simto dmawat do, ta lêan dnawat i Màgu, dunan i mdek do.” ");
INSERT INTO bpr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na man Dyan di ku Dyisas, “Sér, nun teenmi satu lagi, na falwàan i dad busaw fagu di dagitam. Fanmi fnang du là glaman di gito.” ");
INSERT INTO bpr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bay man Dyisas, “Nangyu kenen fnang du ku simto mimò tnikeng fagu di dagitgu, mlimah di kenen talù sasè gablà di do. ");
INSERT INTO bpr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Du ku simto là mnang gito, nsenan ato. ");
INSERT INTO bpr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Too glut i man-gu di gamu ani, ku simto mlé gamu balù lo satu basù éél tno du mdà di ksasatuyu di do, dunan i Mgalék Dwata, nun lubay gdawatan. ");
INSERT INTO bpr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ku simto i baling gumdà i dademe gamsalà, too kenen falnayam. Kaflingenta dun, di laman là fa gamsalà i satu to mdà di kenen, balù i dad mdanà to, baling fye fa ku ikat di lialan i giling batu na bat kenen di mahin. ");
INSERT INTO bpr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaflingenta dun, ku bali sigalam mebe ge di kagsalà, yé baling fye ku kanlangam. Tumù fa ku fatok ge na nun nawam landè sen, bay too sasè ku sikof i sigalam, na baling ditù gugtadèam di lanaw lifoh landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Du ditù di lanaw lifoh là sa mati dad safat, na là mati i lifoh. ");
INSERT INTO bpr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na ku bali blìam mebe ge di kagsalà, yé baling fye ku kanlangam. Tumù fa ku fatok ge na nun nawam landè sen, bay too sasè ku sikof i blìam, na baling ditù gugtadèam di lanaw lifoh landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Du ditù di lanaw lifoh là sa mati dad safat, na là mati i lifoh. ");
INSERT INTO bpr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na ku bali matam mebe ge di kagsalà, yé baling fye ku tanwilam. Tumù fa ku landè bali matam na nun nawam landè sen, bay too sasè ku sikof i matam, na baling ditù gugtadèam di lanaw lifoh landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Du ditù di lanaw lifoh là sa mati dad safat, na là mati i lifoh. ");
INSERT INTO bpr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","I kdee dad to tnilew ale fagu di lifoh. ");
INSERT INTO bpr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","I kahì too fye, bay ku ta là mahìan ta landè kibò lê fahì dun. Fye ku salngad gamu di kahì mangnem, ku demen fye ku sansatuyu nawayu di dademeyu.” ");
INSERT INTO bpr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kafnge ayé, tnagak Dyisas Kapernaum, na salu kenen ditù di Dyudiya di faltù Dyordan. Na lê dee dad to stifun di safédan, na tdòan ale du yé knalaman nimò. ");
INSERT INTO bpr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na nun dad Farisi salu di kenen du snalekla, manla dun, “Fakay kè ku i lagi kahan i yaanan?” Snalekla ani du ani nimòla dalan tmifù ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tmimel Dyisas fagu di salek, manan, “Dét man i uldin Mosis di gamu?” ");
INSERT INTO bpr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na tmimel ale, manla, “Falohan i lagi smulat di kalatas du yé gugmadè dun na ta kahan i yaanan, na kafnge ayé, fakayan fdà.” ");
INSERT INTO bpr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na man Dyisas di dale, “Yé duen Mosis man ayé du magéng uluyu. ");
INSERT INTO bpr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bay mdà di kimò Dwata i kdee ta nimòan di kagatbùan, yé kibòan mimò i to satu lagi na satu libun. ");
INSERT INTO bpr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ani duen i lagi tmagak i màan na i yêan na sasatu kenen di yaanan, ");
INSERT INTO bpr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na lwe ale ta mbaling lo satu. Na ta ise ku lwe ale, bay ta lo ale satu. ");
INSERT INTO bpr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yé duenam man, ku dét i ta sansatu Dwata, là fakay ku nun to samkah dale.” ");
INSERT INTO bpr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na di kfusukla di lam i gumnè, ta lê smalek i dad to galan tdò gablà di manan ayé. ");
INSERT INTO bpr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na man Dyisas di dale, “Nè i lagi mkah i yaanan na lê mwè mahal libun, ta gamsalà du lnafàan i muna yaanan. ");
INSERT INTO bpr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na salngad i libun, ku kahan i yaanan na lê mwè satu lagi, ta gamsalà du lnafàan i muna yaanan.” ");
INSERT INTO bpr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na nun dad to mebe dad ngàla di ku Dyisas du fye nagotan ale, bay i dad to galan tdò, nngakla ale. ");
INSERT INTO bpr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kanto teen Dyisas ayé, malbut kenen, na manan dale, “Falohyu i dad ngà salu di do, na nangyu ale fnang, du i dad to nun ksalig gambet i dad ngà ani, gfusuk ale di Kagot i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na too glut i man-gu di gamu ani, ku i ksalig satu to, là salngadan di ksalig i dad ngà ani, là glaman di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na kafnge ayé, lkafan i dad ngà ayé, na nagotan ale du banlén ale kafye. ");
INSERT INTO bpr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Di ta kdà Dyisas magu, nun satu lagi gasil salu di kenen, na lkuad di munan, na smalek, manan, “E Sér, too fye balum. Dét i fye nimògu fye gfun-gu i nawa landè sen?” ");
INSERT INTO bpr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na tmimel Dyisas, manan, “Dét i duenam man do fye agu? Lo satu i fye, dunan Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ta gadèam i dad uldin Dwata, dunan nang ge manò, nang ge lmafà yaan, nang ge tmaku, nang ge tmulen kéng, nang ge lmumì, na nafèam i màam na yêam.” ");
INSERT INTO bpr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na man i lagi ayé, “Sér, ta nimen-gu i kdee manam ayé mdà di ktukaygu.” ");
INSERT INTO bpr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na kanto neye Dyisas kenen, toon kando, na manan, “Lo satu gukulangam. Mdà ge, na fablim i kdee dad knunam, na blém i wèan di dad to landè knun. Na mdà ayé, nun bong knunam ditù di langit. Na kafnge ayé, magin ge di do.” ");
INSERT INTO bpr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Too blat baweh i to ayé du mdà di man Dyisas. Ta mdà kenen na too mlidù i nawan du too bong knunan. ");
INSERT INTO bpr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na meye Dyisas lmibut, na manan di dad to galan tdò, “Tay klimah i dad to nun bong knun gfusuk di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tikeng i dad to galan tdò du mdà di talùan. Na man Dyisas di dale, “E dad ngà, too mlimah fusuk di Kagot i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ku mlimah di satu bong lmanaf dnagit kamél fusuk di sol i dalum, mas mlimah fa di satu to nun bong knun gfusuk di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na too ale tngah, na sasalek ale, manla, “Ku gambet ayé, simto i fakay galwà?” ");
INSERT INTO bpr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na meye Dyisas di dale, manan, “Di dad to, là gagan ani, bay di Dwata gagan, du gagan Dwata mimò i kdee.” ");
INSERT INTO bpr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na man Piter di ku Dyisas, “Neyem, ta tnagakmi i kdee du magin gami di ge.” ");
INSERT INTO bpr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na man Dyisas, “Too glut i man-gu di gamu ani. Nè i to tmagak i gumnèan, ku demen i dad flanekan lagi, ku demen i dad flanekan libun, ku demen i yêan, ku demen i màan, ku demen i dad ngàan, ku demen i tanàan du mdà di ksasatun di do na i kdawatan i Fye Tulen, ");
INSERT INTO bpr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","too ti dee fa i gdawatan di nawan ani, dunan i dad gumnè, na i dad flanek lagi na libun, na i dad yê, na i dad ngà, na i tanà, na gagin i dee dad kaflayam. Bay kadang di fulé du, gamdawat kenen nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nun dee dad to mdatah di nawan ani mbaling ale mdanà kadang di fulé du. Na dee dad to mdanà di nawan ani mbaling ale mdatah kadang di fulé du.” ");
INSERT INTO bpr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Di kagula mnagad salu ditù di Dyérusalém, muna Dyisas di dale. Tikeng i dad to galan tdò, bay dademe dad to tmadol, likò ale. Na lamla magu, lêan nebe fatfing i dad sfalò lwe to galan tdò du fgadèan i fan kel di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Manan dale, “Too gamu flinge du ta fan ato kel di Dyérusalém, na do, i dnagit Ngà To, bléla agu di kagot i dad ganlal di kafaglut i dad Dyu na i dad to tamdò i dad uldin Dwata fagu di ku Mosis, na nukumla agu di fati, na bléla agu di dad to ise Dyu, ");
INSERT INTO bpr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","du nadoyla agu, na dnulàla agu, na nfasla agu, na fnatila agu. Bay di gatlun du, lê agu mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na fdadong Dyém na Dyan di ku Dyisas, i dad ngà Sébidi. Manla di kenen, “Sér, nun kayèmi fimò ge.” ");
INSERT INTO bpr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na snalekan ale, manan, “Dét kè i kayèyu fimò do?” ");
INSERT INTO bpr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na manla di kenen, “Fsudengam gami di safédam, satu gsen di kwananam na satu gsen di bibengam ku ta gdawatam i kdataham.” ");
INSERT INTO bpr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bay man Dyisas di dale, “Là ti gadèyu ku dét i fniyu. Gaganyu kè tmufì minum di basù guminumgu, dunan i dad kaflayam gnagugu? Na gaganyu kè magin fbunyag di gufbunyaggu, dunan i dad klimahgu?” ");
INSERT INTO bpr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na tmimel ale, manla, “Gaganmi sa.” Man Dyisas di dale, “Too glut, gamginum gamu di basù guminumgu, na gafbunyag gamu di gufbunyaggu. ");
INSERT INTO bpr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bay landè ktoogu fsudeng ku simto gsen di kwanan-gu na gsen di bibenggu. I dad gusudeng ani lo tagà Mà di dad to gutmagàan dun.” ");
INSERT INTO bpr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kanto gadè i sfalò dademe to gal tdò Dyisas gablà di fnila ayé, ta lanbutla Dyém na Dyan. ");
INSERT INTO bpr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na santifun Dyisas i kdeela, na manan di dale, “Ta gadèyu i gal nimò dad ganlal dini di tah tanà. Galla lnumì i dad to mdanà, na toola ale gal dek. ");
INSERT INTO bpr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bay fye ku mahal i nimòyu gamu. Ku simto i mayè mdatah, là fakay ku landè nimòan di dademe. ");
INSERT INTO bpr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na ku simto mayè mdatah, là fakay ku là fafasakan i kton di kdee. ");
INSERT INTO bpr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Du balù do i dnagit Ngà To, ise ku yé duen-gu salu dini di tah tanà ku fifat agu di dad to. Bay yé duen-gu salu dini du do mifat i dad to na blégu i ktogu di fati mayad dad salà du fye dee dad to galwà.” ");
INSERT INTO bpr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na ta kel ale di banwe Dyériko. Na kafnge ayé, ta fles Dyisas na i dad to galan tdò na i mlabung dad to. Na nun lagi butè sudeng di kilil i dalan du gal mni. Yé dagitan Bartimyu, na yé gumtatekan ngà Timyu. ");
INSERT INTO bpr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kanton linge na Dyisas mdà di Nasarét i magu déé, ta mkit kenen, na manan, “E Dyisas, i bel Harì Dabid, begam agu kando.” ");
INSERT INTO bpr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dee ale mngak i butè ayé kayèla ku fanak. Bay too baling mkit, manan, “Bel Harì Dabid, begam agu kando.” ");
INSERT INTO bpr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na yé duenam man, tadè fanak Dyisas, na manan, “Tloyu kenen.” Taman, tlola i to butè ayé, manla, “Fan-galam nawam. Tadag ge. Tlo Dyisas ge.” ");
INSERT INTO bpr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kanton bat i lafin saulan, gasil kenen tadag na fdadong di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na snalek Dyisas kenen, manan, “Dét kè kayèam nimògu di ge?” Tmimel i butè, manan, “Amu, yé kayègu moon ku lê agu mite.” ");
INSERT INTO bpr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Man Dyisas di kenen, “Mdà ge nan. Ta mgulê ge mdà di kaftoom.” Na ta lê kenen mite, na fles magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na kanto ale mdadong di Dyérusalém na di kakella di dad malnak banwe Bétfagi na Bétani di Bulul Olib, dek Dyisas muna lwe dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na manan dale, “Fles gamu di tukay banwe gsen munayu, na ku ta kel gamu ditù, nun teenyu ngà dongki là fa lmen snakay batangla déé. Ntehyu na nebeyu dini. ");
INSERT INTO bpr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na ku nun to smalek gamu, na manan, ‘Kan ku nimòyu ayé?’ ani manyu di kenen, ‘Nun gukmamu i Amu dun, na lêan fulê dini kadang.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na ta mdà i dad to dekan ayé, na ta teenla i ngà dongki batang di saféd i bà gufusuk di satu gumnè di kilil dalan, na ntehla. Na lamla mteh dun, ");
INSERT INTO bpr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","smalek i dademe to tadag déé, manla, “Kan ku ntehyu i ngà dongki ayé?” ");
INSERT INTO bpr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na tmimel ale salngad di man Dyisas na ta bayà i dad to ale. ");
INSERT INTO bpr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na nebela i dongki ayé salu di ku Dyisas, na yé afidla dun i dademe dad klawehla, na ta smakay Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na dee dad to mbel i klawehla di bà dalan. Na i dademe to, nkahla doon ta nwèla di bulul du yé dale kfite i kdayenla di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nun dad to muna di ku Dyisas, na nun dademe tmadol, na falbongla i talùla, manla, “Dnayento i Dwata. Magdayen i To salu dini di dagit Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Banlé Dwata kafye i kagot fan kel ta fakang di munan di gutambulto Harì Dabid. Magdayen i Dwata di too gumdatah.” ");
INSERT INTO bpr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na kafnge ayé, ta kel Dyisas di Dyérusalém, na fusuk kenen di Bong Gumnè Gumangamfù di Dwata. Neyen i kdee mgimò déé bay du ta flabi nan, lê man kenen lamwà salu di Bétani, na magin i sfalò lwe dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na di tmadol du, ta mdà ale di Bétani. Na di lamla magu, ta bitil Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na nun teenan kayu dnagit fig di kibòan beg gumawag, too ti mlabung i doonan. Yé duenam man, ta fdadong kenen déé du mngabal bengen. Bay kanto kel di kayu ayé, landè benge teenan, lo doon, du ise bangan fa menge. ");
INSERT INTO bpr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na man Dyisas di kayu ayé, “Ta landè lê gamkaan i bengem nan.” Na linge dad to galan tdò i manan ayé. ");
INSERT INTO bpr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na kanto kel ale Dyisas di Dyérusalém, ta fusuk kenen di Bong Gumnè Gumangamfù di Dwata, na ndalan lamwà i dad to gal sbayad di laman. Na lugadan i dad lamisa i dad to sasambì filak, na lê man i dad gusudeng i dad to fabli dad abun galla dsù. ");
INSERT INTO bpr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na fnang Dyisas i dad to mebe dad kalyakla magu déé di Bong Gumnè ayé. ");
INSERT INTO bpr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na tamdò Dyisas di dad to, manan, “Ta gsulat di Tnalù i Dwata, manan, ‘I Gumnègu ani, yé gukmamu dun gal gudmasal i dad to mdà di kdee dad banwe,’ bay ta fanbalingyu gumnè i dad to lmimbung.” ");
INSERT INTO bpr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na kanto linge i dad ganlal di kafaglut i dad Dyu na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis i man Dyisas ayé, mngabal ale kfagu fmati kenen. Likò ale di ku Dyisas du too tikeng i kdee dad to di katdòan. ");
INSERT INTO bpr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na kanto kifuh, lamwà ale Dyisas di syudad ayé. ");
INSERT INTO bpr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na too flafus di tmadol du, ta lê ale magu di sablà i kayu fig ayé, na teenla ta mlanas na mati kel di dalilan. ");
INSERT INTO bpr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na gafaldam Piter i ta nimò Dyisas, na manan di kenen, “Sér, neyem. Ta mlanas sa i kayu tnalùam ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na man Dyisas di dale, “Ku ftoo gamu di Dwata, ");
INSERT INTO bpr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","too glut i man-gu di gamu ani. Ku simto i man di bulul ayé, ‘Magket ge na mgilih ge gatù di talà mahin,’ ku là lwe nawan bay fantoon na mgimò i manan, gdohò sa i manan ayé. ");
INSERT INTO bpr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yé duenam man, ani man-gu di gamu, di kdasalyu, ku nun fniyu di Dwata, yé fye fantooyu na ta gdawatyu du fye gfunyu. ");
INSERT INTO bpr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na ku dmasal gamu, fnasinsyayu i kdee dad salà gafaldamyu ta nimò i dademe dad to du fye lê fnasinsya i Màyu ditù di langit i dad salàyu. ");
INSERT INTO bpr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Du ku là fnasinsyayu dad salà i dademe to, là lê fnasinsya i Màyu di langit i dad salàyu.” ");
INSERT INTO bpr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kafnge ayé, ta lê ale samfulê di Dyérusalém. Na lam Dyisas magu di lam i Bong Gumnè Gumangamfù di Dwata, salu di kenen i dad ganlal di kafaglut i dad Dyu, na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na i dad tua gal mebe i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na smalek ale, manla, “Dét i ktoom mimò i kdee nimòam dini? Na simto mlé ge i glal?” ");
INSERT INTO bpr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na tmimel Dyisas, manan, “Lê nun snalekgu di gamu. Na ku gtimelyu, lêgu tulen di gamu ku dét i ktoogu mimò ani. ");
INSERT INTO bpr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gablà di kbunyag Dyan, nè gumdà i glalan kenen, mdà di Dwata di langit, ku demen mdà di dad to di tah tanà? Tnimelyu agu kun.” ");
INSERT INTO bpr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na stulen ale, manla, “Ku yé manto, ‘Mdà di Dwata di langit,’ lêan ato snalek, manan, ‘Kan ku là fantooyu Dyan?’ ");
INSERT INTO bpr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bay là fakay ku yé manto, ‘Mdà di dad to.’ (Likò ale di dad to du yé man i kdee dad to na Dyan satu tugad i Dwata). ");
INSERT INTO bpr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yé duenam man, tmimel ale, manla, “Là gadèmi dun.” Na man Dyisas di dale, “Là lêgu tulen gamu ku dét i ktoogu mimò i dad nimògu.” ");
INSERT INTO bpr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na tamdò Dyisas di dad to fagu di dad fléd, manan, “Nun satu lagi mele walad dnagit grép di tanàan. Lnabatan i dad felen, na makol kenen di bong batu du gumlék i bengen. Na lêan fdak i mdatah gumnè gufanak i to mantay i dad felen ani. Na kafnge ayé, fagotan i dad felen di dademe dad to du salu kenen di satu banwe. ");
INSERT INTO bpr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na kanto tagah i dad bengen, dekan i satu fasakan di dad to gufagotan i felen, du fwèan i kenen alel. ");
INSERT INTO bpr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bay i dad to gufagotan i dad felen, kanfèla i fasak ani, na nfasla na fnge dekla kenen mulê, na landè gwèan. ");
INSERT INTO bpr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na lê nun dekan, na kanto kel déé, bnagulla i ulun, na fyàla kenen. ");
INSERT INTO bpr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na ta lê nun dekan, bay kanto kel déé, ta balingla fnati. Lê nun dee dademe dekan. Nfasla dademe, na flesla fnati dademe. ");
INSERT INTO bpr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na nun lo satu i làan fa dek, dunan i ngàan toon kanbong nawa. Kenen i too sangal fulé dekan salu di dale, du yé manan di kton, ‘Nafèla sa i ngàgu.’ ");
INSERT INTO bpr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bay baling ale stulen, manla, ‘Ani ngà i to mfun i dad fele. Fnatito kenen du fye di kfati màan, ta gito gamfun i dad felen.’ ");
INSERT INTO bpr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mdà ayé, kanfèla kenen, na fnatila, na batla i lawehan di lwà i tanà gumele i dad grép. ");
INSERT INTO bpr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Dét nimò i to mfun fele? Yé nimòan, salu kenen ditù di dad to gufagotan i felen, na fnatin na tanlasan ale. ");
INSERT INTO bpr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sawe là lmenyu masa i fléd di Tnalù Dwata, manan, ‘Nun gumnè slame batu, na i satu batu déé too mabtas, yé baling knang i dad to fdak dun, du man nawala ku là mabtasan. ");
INSERT INTO bpr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Blaam, i batu ani, yé gumdàan di Dwata, na too ti gamtikeng.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na i dademe dad ganlal i dad Dyu, mngabal ale kfagu kamfè ku Dyisas, du gadèla na dale gugtadè i fléd ayé. Bay likò ale di dad to, na yé duenla mdà na tnagakla Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na dekla salu di ku Dyisas dademe Farisi na dademe dad to gal msen ku Harì Hérod du mngabal ale kfagu kamfè kenen fagu di talùan. ");
INSERT INTO bpr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kanto ale kel di kenen, manla, “E Sér, ge i satu to too gsalig, na too ti glut i katdòam i dalan Dwata. Là fkaham di nawam i man dad to di ge du là sa mabtas di ge ku dét i glalla. Nun snalekmi. Fakay kè di uldin Dwata fagu di ku Mosis ku mlé gami bayad i buhis di ku Sisar, i gumdatah di Roma, ku demen là? Dét i fye nimòmi, mayad gami ku là?” ");
INSERT INTO bpr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bay gadè Dyisas na lo ale flingu, taman, manan di dale, “Kan ku kayèyu agu lniman? Fiteyu do i satu filak galyu bayad i buhis di banwe Roma.” ");
INSERT INTO bpr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na mwè ale filak na fitela di ku Dyisas. Na snalekan ale, manan, “Simto i to teenyu di filak ani, na simto mfun dagit i ta gsulat dini?” Na tmimel ale, manla, “Ku Sisar.” ");
INSERT INTO bpr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na man Dyisas di dale, “Ku dét i nfun Sisar, bléyu di ku Sisar, na ku dét i nfun Dwata, lêyu blé di Dwata.” Na tikeng ale du mdà di timelan. ");
INSERT INTO bpr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na nun dad Sadusi salu di ku Dyisas, dunan i dad to gal man landè mték mdà di fati. Na snalekla kenen, manla, ");
INSERT INTO bpr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sér, di munan, smulat Mosis, na yé flaun ku nun lagi mati bay landè ngàla yaanan, là fakay ku là nwè i twalin lagi i libun ayé du fye nun tubad i twegen. ");
INSERT INTO bpr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na di munan kun, nun fitu lagi saflanek. Mwè yaan i twege, bay kel di kfatin landè ngàla. ");
INSERT INTO bpr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na kanto mati i twege ayé, yé lê mwè i libun ayé dunan i galwen, bay landè ngàla. Na kanto lê mati i galwen, ta yé lê mwè dun i gatlun, bay lê landè ngàla. ");
INSERT INTO bpr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na salngad i fitu lagi saflanek ayé du santufìla nwè yaan i libun ayé, na sdulê mati i dad lagi ayé, bay landè ngàla. Na kafngen, ta lê mati i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ani i snalekmi. Di kték i dad mati, simto i too yaan i libun ayé di fitu lagi saflanek?” ");
INSERT INTO bpr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na tmimel Dyisas, manan, “Too gsalà i fandamyu ani du là gadèyu i Tnalù Dwata na i kaltulusan. ");
INSERT INTO bpr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ku ta mték i dad mati kadang di fulé du, ta landè swè yaan. Bay yé ta kagkahla ta salngad ale di dad kasaligan di langit. ");
INSERT INTO bpr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na gablà di kték i dad mati, sawe là lmenyu masa i man Dwata di ku Mosis gablà di kayu dminè, du ani i manan, ‘Do i Dwata fnangamfù Abraham na Isaak na Dyékob.’ ");
INSERT INTO bpr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na yé kayèan man dini, balù ku ta mati ale, sana knèla di fandam Dwata du yé galla katlo dun kenen i Dwata gal fnangamfù i dad to mlawil fa. Too gsalà i kaftooyu.” ");
INSERT INTO bpr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na lê salu di ku Dyisas satu to gal tamdò i dad uldin Dwata fagu di ku Mosis, na lingen i kastulenla. Kanton gadè na too fye timel Dyisas, snalekan kenen, manan, “Di kdee dad uldin Dwata, nè i too mabtas dé?” ");
INSERT INTO bpr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na tmimel Dyisas, manan, “Ani i too mabtas di kdee dad uldinan. ‘Flinge gamu, dad to mdà di Israél. Too mdatah i Amuto Dwata, na lo kenen i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mdà ayé, kanbongyu nawa Amuyu Dwata mdà di nawayu, na di fandamyu, na di kaglabatyu, na di kgisyu.’ ");
INSERT INTO bpr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na i gamtadol uldin too mabtas dunan ani. ‘Kanbongyu nawa i dademe to salngad kalbong nawayu i ktoyu.’ Ta landè dademe nan uldin mabtas fa di dad lwe ani.” ");
INSERT INTO bpr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na man i lagi ayé, “Too fye i manam, Sér. Too glut i manam na lo satu Dwata, na landè dademe. ");
INSERT INTO bpr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na là fakay ku i to là kanbongan nawa Dwata mdà di nawan, na di fandaman, na di kaglabatan, na di kgisan. Na lê là fakay ku là kanbongan nawa i dademe to salngad i kton. Balù ku mabtas di Dwata i kdee dad agaf snakufto na dad dsùto di kenen, bay yé too mabtas di kenen dunan i kimento i dad lwe uldinan ani.” ");
INSERT INTO bpr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kanto gadè Dyisas na too fye timel i lagi ayé, manan dun, “Là mawag ge di Kagot i Dwata.” Na mdà ayé, ta landè to gamlas smalek ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na kafnge ayé, tamdò Dyisas di Bong Gumnè Gumangamfù di Dwata, na di katdòan smalek kenen, manan, “Mdà i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, dét i duenla man dun i Mgalék Dwata Bel Dabid? ");
INSERT INTO bpr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Fagu di kalak i Mtiu Tulus i Dwata, ani man Dabid di munan, ‘Man Dwata di Amugu, “Sudeng ge gsen di kwanan-gu, dunan i gufdatahta ge, kel di kafkahgu i dad to muteh ge nawa di dungan i falel blìam.” ’ ");
INSERT INTO bpr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ku yé katlo Dabid di Mgalék i Dwata ‘Amu,’ kan ku yé katloyu kenen Bel Dabid?” Na bayan i kdee dad to flinge di ktalù Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na di katdò Dyisas, manan di dad to, “Tooyu fan-geye i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. Bayan ale kalmaweh too fye ku magu ale, na kayèla ku too nafè i dad to ale di fadyan. ");
INSERT INTO bpr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na yé kayèla ku nafè i dad to ale fagu di kafsudengla dale di gusudeng i dad to mdatah di gumnè gal gustifun, na di dad fista. ");
INSERT INTO bpr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Blaam, ani i nimòla. Lnufigla dad libun balu du fye gwèla dad knunla, na flingu ale mimò fye fagu di kaftahàla i dasalla. Too maflayam i dad to ayé kadang.” ");
INSERT INTO bpr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Di satu du, sudeng Dyisas di Bong Gumnè Gumangamfù di Dwata di saféd i galla gumkah i filak blé di Dwata, na neyen i dad to gal mlé déé. Bong blé i dad to nun bong knun. ");
INSERT INTO bpr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bay lê nun kel satu libun balu landè knunan, na yé ftatekan déé lo beg lwe lad. ");
INSERT INTO bpr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na tlo Dyisas dad to galan tdò, na manan dale, “Too glut i man-gu di gamu ani, balù ku bong blé dademe dad to, mas bong fa blé i balu ani. ");
INSERT INTO bpr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Du yé blé dademe to i lukas i bong knunla. Bay yé blé i libun balu ani i ta sen knunan.” ");
INSERT INTO bpr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kafnge ayé, di kdà Dyisas di Bong Gumnè Gumangamfù di Dwata, too tikeng i satu to galan tdò di kiten i malbang gumnè glam di gumangamfù ayé, na manan, “Sér, neyem. Tay kalbong i dad gumnè ani na i dad batu didingla.” ");
INSERT INTO bpr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bay man Dyisas di kenen, “Teenam i dad malbang gumnè ani, man? Bay nun du kel kadang, landè batu gtagak di guglakatan du sdulê malbà i kdeen.” ");
INSERT INTO bpr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na fles Dyisas di Bulul Olib, stimbang di Bong Gumnè Gumangamfù di Dwata, na sudeng kenen déé. Na salu Piter na Dyém na Dyan na Andru ku Dyisas, na snalekla di landè dademe to lminge dun, manla, ");
INSERT INTO bpr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Begam tulen gami ku kilen i kagdohò i manam ayé? Dét i ilè gugmadèmi dun na ta fan kel?” ");
INSERT INTO bpr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na tmimel Dyisas, manan, “Too gamu fgeye du fye là mafgaw gamu. ");
INSERT INTO bpr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Du bong dee dad to kel kadang di fulé du, na tamdò ale fagu di dagitgu, manla, ‘Do sa Krayst, dunan i Mgalék Dwata,’ na fagu déé, dee dad to mafgaw. ");
INSERT INTO bpr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na ku lingeyu gablà di dad kasfati ta mkel, na lingeyu i dad santulen gablà di dademe dad kasfati i fan kel, nang gamu likò. Là fakay ku là funa kel i kdee ayé, bay balù ku ta gdohò, ise ku yé i ta gusenan. ");
INSERT INTO bpr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sfati i dad sahal to, na lê man i dad malbang banwe. Na mkel i linol di dee dad banwe, na i kbitil. Bay i kdee ayé lo katbù i dad ilè na ta fan kel i gusenan salngad di libun maltien ta tamduk i tienan du ta fan sut i ngàan. ");
INSERT INTO bpr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Bay too gamu fgeye, du nebela gamu di dad ganlal gal mukum, na nfasla gamu di dad gumnè gal gustifun i dad to. Na lêla gamu ftadag di muna i dad gubirnador na lê man i dad harì du mdà di ksasatuyu di do. Yé kadang i kdalanyu tmulen dale gablà di dad nimò Dwata di gamu. ");
INSERT INTO bpr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na là fakay ku là funa gatdò i Fye Tulen di dad to di kdee dad banwe. ");
INSERT INTO bpr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bay ku kanfèla na nukumla gamu, nang gamu mlidù ku dét i fye timelyu dale. Bay yé tulenyu dunan i blé Dwata di gamu di ktadagyu di muna i dad ganlal ayé du ise ku mdà di gamu i dad timelyu, bay mdà di Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na di dad du ayé, nun dademe dad to, bléla di fati i dad flanekla na dad ngàla. Na i dademe dad ngà, knagolla i dad tuala na fafatila ale. ");
INSERT INTO bpr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na i kdee dad to, knangla gamu nawa du mdà di ksasatuyu di do. Bay ku simto i gamtayud kel di gusenan, galwà kenen. ");
INSERT INTO bpr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na nun teenyu too sasè kalnikò gamfalmo tadag di ise gutadagan, dunan di Bong Gumnè Gumangamfù di Dwata. Na ku teenyu ayé, fye ku milah i kdee dad to mdà di Dyudiya salu di dad bulul. Ku simto masa ani, fye ku toon fan-glabat di fandaman. ");
INSERT INTO bpr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na di du ayé, ku nun to ditù di tah ataf i gumnèan, fye ku ta nang lê tufa ku demen fusuk di lam i gumnèan du mwè i dad knunan. ");
INSERT INTO bpr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ku nun to ditù di dnarun, fye ku nang lê mulê du mwè i saulan tahà sigal. ");
INSERT INTO bpr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Di du ayé, magakdo i dad libun maltien, na i dad libun ftutù ngà. ");
INSERT INTO bpr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taman, too gamu dmasal du fye là kel ani di bang ksasè i tanà. ");
INSERT INTO bpr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Balù dét ksasè i dad mkel mdà di kimò Dwata i klamang banwe di kagatbùan sngé kel di du ani, là gasalngadan ksasè i mkel ani. ");
INSERT INTO bpr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bay fanfukal Dwata i bang ayé, du ku là fanfukalan dun, ta landè nan gdè to mlawil di tah tanà. Yé duenan famfukal dun du mdà di kalbong nawan di dad to ta mgalékan. ");
INSERT INTO bpr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na di dad du ayé, ku nun to man di gamu, ‘Neyeyu, ta dini Krayst, i Mgalék Dwata,’ ku demen manan, ‘Ta ditù,’ nangyu fantoo. ");
INSERT INTO bpr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Du msut dee dad to flingu, na manla dale kun i Mgalék Dwata, blaam ise. Na yé man dademe na dale kun i dademe tugad i Dwata, blaam ise. Na mimò ale dad gamtikeng du fye mafgaw i dad to, na ku gagan, balù i dad to ta mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bay too gamu fgeye du ta falagu tulen di gamu i kdee ani di laman là kel. ");
INSERT INTO bpr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na di dad du di kafnge i bong klimah ayé, tin tadè kmifuh i du, na ta là mneng i bulen. ");
INSERT INTO bpr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na tatek i dad blatik mdà di langit, na gasyat i kdee dad mnè di langit. ");
INSERT INTO bpr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na di kakel i Ngà To, teen i kdee dad to di labun nun kaltulusan na mneng. ");
INSERT INTO bpr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na dekan i dad kasaliganan salu di kdee dad sahal banwe ‘R’ di tah tanà, balù nè gusablàla, du santifunla i dad to ta mgalékan mdà di kdee dad banwe di tah tanà. ");
INSERT INTO bpr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ganbetyu nan i tdògu ani mdà di kayu fig. Ku tmubad i kayu ani na lê dmoon, yé ilè gugmadèyu dun na ta fan kel i minit du. ");
INSERT INTO bpr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gambet ayé, ku teenyu ta kel i dad ta falagu tulen di gamu, yé gugmadèyu dun na ta too mdadong nan i kakel Ngà To. ");
INSERT INTO bpr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Too glut i man-gu di gamu ani. Là sa sdulê mati i kdee dad to di bang ani. Silang ale mati ku gdohò i kdee dad tulen-gu ani. ");
INSERT INTO bpr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Matlas i langit na i tanà, bay i Tnalùgu là matlasan kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Landè gmadè i du na i bang kasfulêgu, balù i dad kasaligan di langit, ku demen i Ngà Dwata. Bay lo yé gmadè dun i Mà. ");
INSERT INTO bpr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Too gamu fatlagad na fgeye du là gadèyu i kakel i du ayé. ");
INSERT INTO bpr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yé guflingen-gu dun di satu to magu. Di fa làan tnagak i gumnèan, malék kenen dad snaligan munung dun. Kat satu di dale, nun fimòan dun. Na falnaun i to funungan di bà takab di gumnè ayé, manan, ‘Too ge fgeye.’ ");
INSERT INTO bpr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yé duenam man, too gamu fgeye du là gadèyu ku kilen kakel i mfun i gumnè, ku di kifuh, demen di tngà butang, demen ku ta kalmeet i anuk di ta fan fayah, ku demen di ksut i du. ");
INSERT INTO bpr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ku mlal kenen kel, too mabtas ku là gumahan gamu kudang. ");
INSERT INTO bpr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ku dét i man-gu di gamu, salngad ayé i man-gu di kdee dad to, na dunan ani, ‘Too gamu fgeye.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na ta lo lwe butang gdè kakel i Du Kaglius na i Fista Kakaan i Fan Landè Bulung Falnok Dun. Na mdà dad ganlal di kafaglut i dad Dyu na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, mngabal ale kfagu kamfè ku Dyisas na fmati kenen di landè to gmadè dun. ");
INSERT INTO bpr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bay manla, “Nangto nimò ani di lam i fista du keng falbut i dad to, na baling ale mimò samuk.” ");
INSERT INTO bpr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na déé Dyisas di Bétani di gumnè Simon, dunan i to nun fdas mumuh di munan. Na laman kmaan, nun kel satu libun mebe sabuy batu malung nlam fangbun too mabtas dnagit nardo, na landè ti bolan. Bantùan i sabuy, na kokan i fangbun di ulu Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mdà ayé, malbut i dademe dad to déé, na stulen ale, manla, “Kan ku falmon i fangbun ayé? ");
INSERT INTO bpr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tumù fa ku fablin na blén i wèan di dad to landè, du balù ku bong gwè i satu to sukéy di sfali, bong fa i btas i fangbun ayé ku fabli.” Na mdà ayé, toola nngak i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bay man Dyisas di dale, “Bayàyu kenen. Kan kè ku nangawyu? Too fye sa nimòan di do. ");
INSERT INTO bpr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Du gal nun dad to landè di safédyu, na fakayyu ale tnabeng balù ku dét du. Bay do, ta là mlo i knègu dini di safédyu. ");
INSERT INTO bpr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I libun ani nimòan i sen gaganan. Di kakokan i fangbun di do, falan fatlagad i lawehgu di lbang. ");
INSERT INTO bpr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Too glut i man-gu di gamu ani, na balù nè gutamdò i Fye Tulen di klamang banwe, lêla tulen i nimò i libun ani du fye gafaldamla kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na kafnge ayé, nun satu di dad sfalò lwe to gal tdò Dyisas, yé dagitan Dyudas Iskariyot, salu kenen di dad ganlal di kafaglut i dad Dyu du santulenla ku dét i kibòan makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kanto linge i dad ganlal di kafaglut i dad Dyu ayé, too ale lehew na makang ale mlé filak ku Dyudas. Na tambù Dyudas mngabal kfagu makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kanto tambù i Fista Kakaan i Fan Landè Bulung Falnok Dun, ta yé ktatêla i ngà bilibili du fatlagadla di kaftoh i Du Kaglius. Na smalek dad to gal tdò Dyisas, manla di kenen, “Nè gumdekam gami fatlagad knaanto di Du Kaglius?” ");
INSERT INTO bpr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na dek Dyisas lwe di dale, manan, “Salu gamu di syudad, na nun gsitongyu lagi mebe namuh fnò éél. Magin gamu di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na ku kel gamu di gumnè gufusukan, manyu di to mfun i gumnè ayé, ‘Yé snalek i to gal tamdò, “Nè snifil i fakaymi gukmaan di fista i Du Kaglius magin i dad to galgu tdò?” ’ ");
INSERT INTO bpr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na ani i nimò i to ayé kadang. Tdòan gamu satu bong snifil ta gatlagad ditù di tah. Na ta ditù nan i kdee dad gnamityu. Ditù gufatlagadyu i knaanto.” ");
INSERT INTO bpr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na kafnge ayé, ta mdà i dad lwe to salu di syudad, na di kakella déé, teenla too glut i kdee man Dyisas gine, na fatlagadla i knaan di Fista i Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na kanto kifuh, ta salu déé Dyisas, na yé dademen dad sfalò lwe to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lamla sudeng na kmaan déé, man Dyisas di dale, “Too glut i man-gu di gamu ani, na nun satu di gamu fan makal do i kmaan dini di safédgu.” ");
INSERT INTO bpr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na yé duenam man, mlidù nawala, na man i kat satu di kenen, “Ise do sa, man?” ");
INSERT INTO bpr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na manan di dale, “Di sfalò lwe gamu, i to song di do lamnab fan di tukung, yé makal do. ");
INSERT INTO bpr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Do, i dnagit Ngà To, mati agu salngad i ta gsulat gablà di do. Bay magakdo i lagi makal do du too kenen maflayam. Baling fye fa i to ayé ku là sutan.” ");
INSERT INTO bpr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na lamla kmaan, mwè Dyisas fan, na fasalamat di Dwata, klon falnak dun na blén di dad to galan tdò, na manan dale, “Mwè gamu. Ani i lawehgu.” ");
INSERT INTO bpr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lêan nwè i basù nun binu, na fasalamat di Dwata, klon mlé dun di dale, na sansinumla. ");
INSERT INTO bpr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na manan dale, “Ani i litègu falohgu du fye fnasinsya Dwata salà i dee dad to du yé fambagal i kasafnè Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Too glut i man-gu di gamu, mdà ani, ta là lê agu man minum binu ani. Silang agu lê minum ku ta kel i du i kinumgu i falami binu di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kafngela lmingag dmayen i Dwata, ta lamwà ale na salu ale di Bulul Olib. ");
INSERT INTO bpr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na man Dyisas di dad to galan tdò, “I kdeeyu fan tmagak do, du ta gsulat di Tnalù i Dwata, manan, ‘Fnatigu i to gal mifat i dad bilibili, na masbalét i dad bilibilin.’ ");
INSERT INTO bpr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bay ku ta mték agu mdà di fati, muna agu di gamu ditù di Galili.” ");
INSERT INTO bpr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na man Piter di ku Dyisas, “Balù ku milah i kdee, bay do, là ti tnagakta ge.” ");
INSERT INTO bpr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Bay man Dyisas di kenen, “Too glut i man-gu di ge ani, na kadang kifuh di là fa kalmeet i anuk lwe dulê, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” ");
INSERT INTO bpr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bay too sansulit Piter i manan ayé, “Balù ku mati agu magin ge, là ti bnalewta ge.” Na lê salngad ayé i man dademe dad to tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na salu ale di satu tanà dnagit Gétsémani. Na man Dyisas di dad to galan tdò, “Sudeng gamu dini lamgu dmasal.” ");
INSERT INTO bpr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na faginan Piter na Dyém na Dyan salu di gudmasalan. Na too kenen flunuh na mlidù i nawan. ");
INSERT INTO bpr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na man Dyisas di dale, “Yé kagkahgu ani ta fan agu mati di klidùgu. Fanak gamu dini, na too gamu fgeye.” ");
INSERT INTO bpr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na fles kenen magu, là mawag di dale, na tadè lamfan di tanà. Na dmasal kenen, yé fnin ku là gafles i kaflayaman ku nun kibò. ");
INSERT INTO bpr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na fles dmasal, manan, “E Mà, gaganam i kdee. Begam nwè i kaflayam fan kel di do. Bay yé mgimò i ge knayè, ise i do.” ");
INSERT INTO bpr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na lê kenen samfulê di dad tlu to galan tdò, na teenan ale kudang. Na manan di ku Piter, “Kan kè, Simon? Kudang ge? Là gmagan ge fgeye balù là mlo? ");
INSERT INTO bpr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Too gamu fgeye na dmasal du fye là gamu gfisan di tilew. Du mayè i nawa, bay gal mlungay i laweh.” ");
INSERT INTO bpr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na lê kenen mdà du dmasal, na salngad sa i dasalan gine. ");
INSERT INTO bpr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na kafnge ayé, lê man kenen samfulê di dale, na ta lêan ale teen gkudang, du too ale malkudang. Na kanto ale mukat, là gadèla ku dét i fye timella di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na kafngen dmasal di gatlun dulê, samfulê kenen di dad tlu to tdòan, manan, “Kan, sana kakudangyu na sana kaftudyu? Ta gablàyu ayé. Ta kel nan i bang, na do i dnagit Ngà To, nakalla agu na bléla agu di kagot i dad to gamsalà. ");
INSERT INTO bpr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mték gamu nan du mdà ato. Ta mdadong nan i to makal do di fati.” ");
INSERT INTO bpr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na di laman talù, ta kel Dyudas, satu di dad sfalò lwe to galan tdò. Nun dee dad to magin di kenen dek dad ganlal di kafaglut i dad Dyu, na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na i dad tua gal mebe i dad Dyu. Na mebe ale sundang na bunal. ");
INSERT INTO bpr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na i to makal ayé, ta falan tulen di dale ku dét i ilè fgadè dale ku simto Dyisas. Ani ta manan, “I to nalakgu di bawehan, yé dunan. Kenen i kanfèyu, na tooyu fan-geye i kebeyu dun.” ");
INSERT INTO bpr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na kakelan di ku Dyisas, ta fandadongan, na manan, “E Amu,” na ta nalakan i bawehan. ");
INSERT INTO bpr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na kafnge ayé, nagotla Dyisas du kanfèla kenen. ");
INSERT INTO bpr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bay satu di dad to magin ku Dyisas, nwèan sundangan, na tnibehan i fasak i ulu i dad ganlal di kafaglut i dad Dyu, na masfek i bali klingen. ");
INSERT INTO bpr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na man Dyisas di dad to déé, “Kan? To tmaku agu kè du mebe gamu sundang na bunal di kakfèyu do? ");
INSERT INTO bpr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kat du déé agu sa di safédyu di Bong Gumnè Gumangamfù di Dwata du tamdò agu, bay là sa kanfèyu agu. Bay yé duenan kel ani du fye gdohò i man di Tnalù Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na kafnge ayé, tnagak i kdee dademen kenen, na mdà ale milah. ");
INSERT INTO bpr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na lê nun satu lamnok lagi lmalò di ku Dyisas, na lo yé lsakan falnas bukay labédan di awekan. Fanla kanfè, ");
INSERT INTO bpr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bay milah kenen, na gtagak i falnasan ayé, na ta flaweh. ");
INSERT INTO bpr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na kafnge ayé, nebela Dyisas salu di ulu i dad ganlal di kafaglut i dad Dyu. Na ta stifun déé i kdee dad ganlal di kafaglut i dad Dyu, na i dad tua gal mebe i dad Dyu, na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na lê lmalò Piter, kibò fawag kenen, kel di nasel i ulu i dad ganlal di kafaglut i dad Dyu. Na sudeng kenen di saféd i dad to gal mantay déé na mnalang di lifohla. ");
INSERT INTO bpr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na i dad ganlal di kafaglut i dad Dyu na kdee dademe dad ganlal, too ale meye kfagu du fye nun gutadagla tmifù ku Dyisas, na fafati dun, bay landè teenla salà di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na nun dee dad to tmulen kéng gablà di kenen, bay du là maslalò i manla. ");
INSERT INTO bpr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na lê nun dademe to tadag déé, na tmulen ale kéng gablà di kenen, manla, ");
INSERT INTO bpr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ani lingemi, manan, ‘Lanbàgu i Bong Gumnè Gumangamfù di Dwata ani i nimò i dad to, na di tlu du lêgu man tanlas, na yé tlasgu dun ise nimò i dad to.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bay balù i tulen i dad to ani, là maslalò i manla. ");
INSERT INTO bpr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na lê tadag i ulu i dad ganlal di kafaglut i dad Dyu, na snalekan Dyisas, manan, “Là tmimel ge kè? Dét i duenla talù gambet ani gablà di ge?” ");
INSERT INTO bpr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bay là talù Dyisas balù ku landè salàan. Na yé duenam man, lê man smalek i ulu i dad ganlal di kafaglut i dad Dyu, na manan di ku Dyisas, “Ge kè i Mgalék Dwata, na Ngà i Too Magdayen Dwata?” ");
INSERT INTO bpr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na tmimel Dyisas, manan, “Do sa ayé, na di fulé du kadang teenyu agu, i Ngà To, sudeng di kwanan i Dwata too maltulus, na tufa agu mdà di langit fagin di dad labun.” ");
INSERT INTO bpr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bay i ulu i dad ganlal di kafaglut i dad Dyu knasêan i kenen saul du too sè kalbutan, na manan di dad to, “Ta landè kamuto smalek i dademe dad to gablà di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ta lingeyu i sasè manan. Nladan i kdatah Dwata. Dét fandamyu dé?” Na yé timel i kdee dad to gablà kenen fnati. ");
INSERT INTO bpr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na mdà dademe dnulàla kenen. Snafangla i matan, na snuntukla, manla, “Tulenam di gami ku simto smuntuk ge.” Na balù i dad to gal mantay, lêla tanfiling kenen. ");
INSERT INTO bpr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na sana kdéé Piter di nasel, gsen dungan i gusmalekla ku Dyisas. Na nun satu libun fasak i ulu i dad ganlal di kafaglut i dad Dyu magu déé. ");
INSERT INTO bpr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na di kiten ku Piter mnalang, toon kenen neye. Na manan dun, “Ge sa i lê satu to gal magin di ku Dyisas mdà di Nasarét.” ");
INSERT INTO bpr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bay malew Piter, manan, “Là gadègu na là glabatgu i manam ayé.” Na ta fles gatù di bà i takab, na ta sulê i anuk kalmeet. ");
INSERT INTO bpr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na i libun ayé, lêan teen Piter, na manan di dademe dad to tadag déé, “I to ani, gal magin ku Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bay lê malew Piter. Na di là mlo, man dademe to di ku Piter, “Too sa. Ge i satu to gal magin ku Dyisas du yé gumdàam di Galili.” ");
INSERT INTO bpr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Baling kenen samdagè, manan, “Falnayam Dwata agu ku tmulen agu kéng. Là sa dilègu i lagi manyu ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na ta kalmeet i anuk di galwen dulê. Na gafaldam Piter i ta man Dyisas di kenen, “Di fa là kalmeet i anuk lwe dulê, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” Na yé duenam man, too kenen mngel. ");
INSERT INTO bpr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na di too flafus, gasil stulen i dad ganlal di kafaglut i dad Dyu, na i dad tua gal mebe i dad Dyu, na i dad to gal tamdò i dad uldin i Dwata fagu di ku Mosis, na i kdee dademe dad ganlal. Na fnge, bnakusla Dyisas, na nebela di ku Pilato, dunan i gubirnador du bléla di kagotan. ");
INSERT INTO bpr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na snalek Pilato kenen, manan, “Ge kè i Harì i dad Dyu?” Na tmimel Dyisas, manan, “Ta manam sa.” ");
INSERT INTO bpr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na i dad ganlal di kafaglut i dad Dyu, tnifùla Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na lê smalek Pilato, manan, “Landè timelam kè di kdee dad tifùla ge?” ");
INSERT INTO bpr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bay ta là tmimel Dyisas, taman tngah Pilato. ");
INSERT INTO bpr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na yé gal nimò Pilato di fista falwàan satu to di blanggù. Ku simto knayè i kdee dad to, yé falwàan. ");
INSERT INTO bpr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na di bang ayé, nun satu to blanggù, yé dagitan Barabas. Sanfatin i dad to magot i banwe ayé, na ta nun bnanòan. ");
INSERT INTO bpr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na salu i dad Dyu di ku Pilato du kayèla fimò di kenen i galan nimò, dunan falwà satu to blanggù. ");
INSERT INTO bpr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na smalek Pilato di dad to, manan, “Kayèyu kè na yé falwàgu Dyisas, Harì i dad Dyu?” ");
INSERT INTO bpr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yé duenan smalek dad to du ta gadèan na yé duen i dad ganlal di kafaglut i dad Dyu mlé ku Dyisas di kagotan du mafè nawala ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bay i dad ganlal di kafaglut i dad Dyu, banlétla i kdee dad to du fye yé fnila falwà, Barabas, na ise ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na lê smalek Pilato di dad to ayé, manan, “Dét i fye kibògu ku Dyisas, i tloyu Harì i dad Dyu?” ");
INSERT INTO bpr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na mkit ale, manla, “Fnati kenen! Fnatak di krus!” ");
INSERT INTO bpr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bay smalek Pilato, manan, “Kan? Dét i salàan?” Na baling matnù kakitla, manla, “Fnatak kenen di krus.” ");
INSERT INTO bpr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na du mayè Pilato flehew i dad to ayé, yé duenan falwà ku Barabas di dale. Bay kafngen fafas ku Dyisas, blén kenen di dad sundalu ayé, du fnatakla di krus. ");
INSERT INTO bpr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na nebe dad sundalu Dyisas ditù di nasel i gubirnador, na fastifunla i dademe sundalu. ");
INSERT INTO bpr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na falsakla ku Dyisas klaweh mitam fulè du fagbetla kenen harì. Na salmabéd ale walad nun sual du nimòla kyangen na sukubla di ulun. ");
INSERT INTO bpr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na flingu ale mangamfù ku Dyisas, manla, “Kumusta ge, harì i dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na bnagulla i ulun tugad, na dnulàla kenen. Na lkuad ale du flingu ale mangamfù di kenen. ");
INSERT INTO bpr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na kafngela madoy kenen, lêla nlus i klaweh mitam fulè, na falsakla dun i kenen klaweh. Na kafnge ayé, nebela kenen lamwà du fnatakla di krus. ");
INSERT INTO bpr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na di kagula gatù, nun lagi gsitongla, yé dagitan Simon i mà Alihandru na Rufus mdà di banwe Sirini. Di kagsitongla dun, yé gufdun di bulul. Na fnegesla kenen mebe i krus Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na nebela Dyisas salu di banwe Golgota. Yé gumtatek i Golgota ani, dunan i banwe klakub ulu. ");
INSERT INTO bpr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na kanto ale kel di Golgota, banléla kenen binu sanboolla bulung féét dnagit mira, bay là ninum Dyisas dun. ");
INSERT INTO bpr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na kafnge ayé, fnatakla kenen di krus, na nalel i dad sundalu i dad klaweh Dyisas fagu di kasbunut, du fye gadèla ku dét gwè kat satu di dale. ");
INSERT INTO bpr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta tngà mnagad i du i kfatakla ku Dyisas di krus. ");
INSERT INTO bpr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na sulatla gsen tah i ulun i tifùla di kenen, manan, “I Harì i dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na nun lwe to tmaku lêla fnatak di safédan, satu gsen di kwananan na satu gsen di bibengan. ");
INSERT INTO bpr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na di kibòla kenen ayé, ta gdohò nan i man di Tnalù Dwata di munan, “Gagin kenen di dad to too gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na i dad to magu déé, kmiling ale, manla, “Ha, ge i to mayè lambà i Bong Gumnè Gumangamfù di Dwata na lê ftadag dun di lam i tlu du. ");
INSERT INTO bpr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Falwàam i ktom na tufa ge di krus ayé.” ");
INSERT INTO bpr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na lê salngad ayé nimò i dad ganlal di kafaglut i dad Dyu na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, nadoyla kenen, manla, “Galan falwà dademe dad to, bay là gafalwàan i kenen kto.” ");
INSERT INTO bpr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na manla, “Fye ku i Mgalék Dwata, dunan i Harì di Israél, tufa mdà di krus du fye teento na fantooto.” Na balù dad to tmaku i gagin fnatak di krus lê madoy kenen. ");
INSERT INTO bpr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na di kaltu i du, tadè kmifuh i klamang banwe kel di tngà masol i du. ");
INSERT INTO bpr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na kanto tngà masol i du, tamlo Dyisas di too bong talù, manan, “Iloy, iloy, lama sabaktani?” Yé gumtatekan, “E Dwatagu, Dwatagu, dét i duenam kmagol do?” ");
INSERT INTO bpr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kanto linge i dademe to tadag déé i manan ayé, manla, “Falningeyu, ta tlon Ilaydya.” ");
INSERT INTO bpr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na gasil satu to mwè falnas, lnaban di sukà, na fkahan di tukè i kayu du ulukan di bà Dyisas na fsafan dun, na manan, “Bayàyu kenen. Neyeto ku kel Ilaydya na falwàan kenen.” ");
INSERT INTO bpr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na mkit Dyisas na ta ftoh nawan. ");
INSERT INTO bpr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na i bong kurtina di gutngà i Bong Gumnè Gumangamfù di Dwata, tadè kasê di gutngàan mdà di tah kel di dungan. ");
INSERT INTO bpr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na nun satu ulu i dad sundalu tadag déé, na smalu di ku Dyisas. Di kiten i kibò Dyisas mkit na mati, manan, “Too glut, kenen Ngà Dwata.” ");
INSERT INTO bpr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lê nun dademe libun damweng mdà di gumawagan. Magin déé Méri Magdalin, na Méri i yê tukay Dyém, na i yê Dyosis, na lê Salomi. ");
INSERT INTO bpr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na tagnè ale magin di ku Dyisas di Galili, na galla kenen tnabeng. Na lê nun dee dademe dad libun déé ta magin di kenen di ksalun di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","I du kfati Dyisas, yé du kafatlagadla di Du Kaftud. Kanto kifuh, nun satu lagi yé dagitan Dyosip mdà di banwe Arimatiya, na kenen satu mgafè di dad ganlal. Lêan fatan i Kagot Dwata. Na fan-galan i nawan salu di ku Pilato du fnin i laweh Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Du mayè Pilato gmadè ku ta mati Dyisas, fngén i ulu i dad sundalu, na snalekan ku ta mati kenen. ");
INSERT INTO bpr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na kanton gadè na ta mati Dyisas, bayàan Dyosip mwè i lawehan. ");
INSERT INTO bpr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na mdà ayé, mli Dyosip falnas bukay, na kanton nwè i laweh Dyisas mdà di krus, ta labédan dun i falnas bukay ayé, klon mkah dun di lbang nakol di lfidas gugdak i bulul, na lulidan i bong batu du sangan di bà i gufusuk. ");
INSERT INTO bpr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na damweng Méri Magdalin na Méri i yê Dyosis du fye gadèla ku nè gulambangla ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na kafnge i Du Kaftud, mli Méri Magdalin, na Méri i yê Dyém, na lê Salomi i dad fangbun du salu ale di lbang Dyisas, du ihokla di lawehan. ");
INSERT INTO bpr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na di too flafus, di du Linggu di ksut i du, salu ale ditù di lbang. ");
INSERT INTO bpr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na di lamla magu, stulen ale, manla, “Simto kè i tmabeng gito lmulid i batu mdà di bà i lbang?” ");
INSERT INTO bpr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bay kanto ale kel di lbang ayé, teenla ta mgidul i bong batu di bà i lbang ayé. ");
INSERT INTO bpr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na kanto ale fusuk di lam, nun teenla satu lagi lamnok sudeng gsen di kwananla, na yé klawehan bukay. Na too ale tngah, ");
INSERT INTO bpr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","bay manan di dale, “Nang gamu tngah. Yé fanngabalyu Dyisas mdà di Nasarét, dunan i ta fnatakla di krus. Ta mték kenen, na ta là dinin. Neyeyu i gumlasàan. ");
INSERT INTO bpr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mdà gamu, na tulenyu ani di dad to galan tdò, balù di ku Piter. Ani i manyu, ‘Ta muna Dyisas ditù di Galili. Ditù gumiteyu dun salngad i ta manan di gamu di munan.’ ” ");
INSERT INTO bpr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na milah i dad libun ayé fdu di lbang du too ale tngah na kankal di klikò. Na landè manla di dademe to du mdà di klikòla. ");
INSERT INTO bpr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na kanto mték Dyisas di du Linggu, yé muna gufiten i kton di ku Méri Magdalin, dunan i libun gufalwàan fitu busaw di munan. ");
INSERT INTO bpr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na salu Méri di dad to gal tdò Dyisas. Di kakelan ditù, too ale mngel na mugak du mlidù nawala. Na kafnge ayé, ta tulen Méri dale ta mték Dyisas. ");
INSERT INTO bpr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bay kantola linge na ta lê mték Dyisas mdà di fati, là fantoola dun. ");
INSERT INTO bpr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kafnge ayé, nun lwe to magu di bulul, na tadè msut Dyisas di dale, na ta mgilih i bawehan. ");
INSERT INTO bpr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tulenla ayé di dademela, bay knèan là fantoola dun. ");
INSERT INTO bpr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kafnge ayé, fite Dyisas i kton di sfalò satu gdè to galan tdò di lamla kmaan. Nngakan ale du là ftoo ale di man i dad to ta mite kenen du magéng ulula. ");
INSERT INTO bpr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na man Dyisas di dale, “Gatù gamu di klamang banwe, na tdòyu i Fye Tulen di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ku simto ftoo na fbunyag, galwà kenen. Bay ku simto i là ftoo, maflayam kenen kadang di fulé du. ");
INSERT INTO bpr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ani i dad ilè i kaltulus gdawat i dad to ftoo. Fagu di dagitgu, falwàla dad busaw di dad to, na talù ale di dad sahal talù. ");
INSERT INTO bpr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Balù ku gagotla i dad ulad, na balù ku gamginum ale kilu, landè sasè mkel di dale. Na lêla nagot i dad to nun tduk na mgulê ale.” ");
INSERT INTO bpr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mdà ayé, kafnge Dyisas talù di dale, tadè kenen magket di langit, na sudeng gsen di kwanan i Dwata. ");
INSERT INTO bpr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bay i dad to ayé gine, kanto ale mdà, tdòla i Fye Tulen di kdee dad to di dad banwe gusalula. Na lê tmabeng i Amuto Dyisas fagu di dad tnikeng nimòan du yé ilèan na glut i Tnalùan. Amén.");
INSERT INTO bpr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mabtas Tyufilu, Ta dee nan i dad to tmilew smulat gablà di dad mkel di blengto, balù kel di dad mgimò Dyisas di safédto. ");
INSERT INTO bpr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Na i dad sulatla ayé, ta tulen i dad to gal mite dun mdà di kagatbùan, na dale i dad to gal tmulen i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","E Tyufilu, ta toogu fandam na ta gadègu i dad mgimò Dyisas mdà di kagatbùan. Na yé duenam man, fandamgu fye ku lê agu do smulat du fye toogu fansye tmulen di ge. ");
INSERT INTO bpr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yé duen-gu smulat ani du fye toom gadè i kaglut i dad tdò di ge. ");
INSERT INTO bpr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Di munan, yé magot i banwe Dyudiya dunan Harì Hérod. Na nun satu ganlal di kafaglut i dad Dyu glam di lumbuk Abadya, yé dagitan Sakaraya. Yé dagit yaanan Ilisabét mdà di bel Aron, lê satu ganlal di kafaglut i dad Dyu di munan. ");
INSERT INTO bpr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Lwe ale Sakaraya na i yaanan, too ale tluh di kanfe Dwata du too ale mimen di kdee dad uldin Dwata na landè gumaslenla. ");
INSERT INTO bpr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bay landè ngàla du tagnè là mngà Ilisabét, na ta tua ale Sakaraya. ");
INSERT INTO bpr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na di satu du, nimò Sakaraya i kenen alel di kfangamfùan di kanfe Dwata du ganlal kenen di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yé nimò i dad ganlal, gal ale malék ku simto di dale i fusuk di Bong Gumnè Gumangamfù di Dwata na mtam i falbuk fye bun, na yé kalékla fagu di kasbunut. Na di du ayé, Sakaraya i mgalékla na mdà ayé, fusuk kenen déé di lam. ");
INSERT INTO bpr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na di bangan mtam i falbuk, nun dee dad to stifun di lwà du dmasal ale. ");
INSERT INTO bpr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na nun kasaligan i Dwata tadè msut déé di ku Sakaraya na tadag gsen di bibengan. ");
INSERT INTO bpr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Di kite Sakaraya i kasaligan, taknal kenen na likò. ");
INSERT INTO bpr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bay man i kasaligan di kenen, “Sakaraya, nang ge likò du ta linge Dwata i dasalam. Na i yaanam, dunan Ilisabét, mngà kenen lagi na yé dagitam dun Dyan. ");
INSERT INTO bpr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na too bong klehewyu di ksutan, na i dademe dad to, lê ale magin flehew di gamu, ");
INSERT INTO bpr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","du mgimò kenen mdatah di kanfe Dwata. Na là fakay kenen minum i dad gamflangal. Bay di laman fa là sut, yé mebe kenen dunan i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na di ktulenan i Tnalù i Dwata, nun dee bel Israél geben samfulê di kaftoola di Amu, dunan i Dwatala. ");
INSERT INTO bpr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na Dyan i muna di Amu fan kel. Na salngad i gnagan blé i Tulus Dwata di kenen di gnagan gablé di satu tugad i Dwata di muna, dunan Ilaydya. Na sanfyen i smà na sngà, na i dad to là mimen di Dwata, neben ale di tluh dalan du fye fulung ale faldam gambet i dad to tluh. Yé nimò Dyan kadang du falan fatlagad i fandam i dad to di kakel i Amu.” ");
INSERT INTO bpr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bay smalek Sakaraya na manan, “Dét i ilègu dun, na glut i manam, du ta tua gami yaan-gu na landè kibòan mngà?” ");
INSERT INTO bpr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na tmimel i kasaligan, manan, “Do sa Gabriél, i satu snalig Dwata gal tadag di kanfen. Yé duenam man, dekan agu salu dini du fye fgadègu di ge i fye tulen ani. ");
INSERT INTO bpr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bay ge, Sakaraya, du là fantoom i tulenta ge ani, mdà ani baling ge umu. Silang ge gtalù ku ta kel i du kagdohò i man-gu gine. Na i tulenta ge gine, gdohò kadang di satu du ku ta bangan kel.” ");
INSERT INTO bpr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na i dad to di lwà, sana kfatanla ku Sakaraya na tikeng ale du too kenen mlo di lam i Bong Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na kanto lamwà Sakaraya, ta là gtalùan. Na gadèla ta nun fite Dwata kenen di lam i Bong Gumnè ayé du sigi kenen sminyas du ta là gtalùan. ");
INSERT INTO bpr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na kanto fnge Sakaraya i nimòan di Bong Gumnè Gumangamfù di Dwata, ta mulê kenen. ");
INSERT INTO bpr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na di là mlo kafnge ayé, ta mlalu i yaanan, dunan Ilisabét, na lime bulen klon fanak di lam gumnèla. ");
INSERT INTO bpr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na man Ilisabét, “Yé duen Dwata mimò ani du kandon agu. Ta nwèan i gamlé do kyà di kanfe i dad to.” ");
INSERT INTO bpr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kanto nam bulen i tien Ilisabét, ta lê dek Dwata Gabriél salu di Nasarét, i satu lunsud glam di probinsya Galili. ");
INSERT INTO bpr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yé gusalun di satu sawang libun dnagit Méri, i yaan to Dyosip, satu bel Harì Dabid. ");
INSERT INTO bpr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na kanto kel Gabriél di ku Méri, manan di kenen, “Flehew ge. Too kando Dwata ge na kenen i magin ge.” ");
INSERT INTO bpr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Bay kaklinge Méri i man i kasaligan, too msamuk i nawan na toon fandam ku dét gumtatek i manan. ");
INSERT INTO bpr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bay man i kasaligan di kenen, “Méri, nang ge likò du banlé Dwata ge kafye. ");
INSERT INTO bpr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tadè ge maltien, na lagi i ngàam, na yé dagitam dun Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Too kenen mdatah na tlo kenen Ngà i Too Mdatah Dwata. Na i Amuto Dwata mlé kenen glal magot i kdee salngad di kagot i gutambulan, Harì Dabid. ");
INSERT INTO bpr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na neben kel di landè sen i dad bel Dyékob na landè gusen i kagotan.” ");
INSERT INTO bpr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bay smalek Méri, manan, “Dét i kibògu mngà ani du sawang libun agu fa?” ");
INSERT INTO bpr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na tnimel i kasaligan kenen, manan, “Salu i Mtiu Tulus di ge du fite Dwata di ge i kgaganan. Na yé duenam man, i ngà ayé, too kenen mtiu du landè salàan na yé katlo kenen Ngà i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na fandamam i satu flanekam Ilisabét, manla là mngàan na ta tua, bay ta maltien. Ta nam bulen i tienan. ");
INSERT INTO bpr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Du landè ti là gnagan Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na man Méri, “Fasak agu i Dwata. Mulà moon mkel di do i kdee manam ayé.” Na kafnge ayé, ta tnagak i kasaligan kenen. ");
INSERT INTO bpr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Di là mlo, ftifas Méri klon mdà du sagwê kenen salu di satu lunsud di dad bulul di probinsya Dyudiya. ");
INSERT INTO bpr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na fusuk kenen di gumnè Sakaraya, du stulen ale Ilisabét. ");
INSERT INTO bpr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na kanto linge Ilisabét i talù Méri, lamyak i ngà di lam tienan na fnò Ilisabét i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na falbongan i talùan, manan, “Di kdee dad libun, ge i gumlé Dwata too bong kafye. Na lê banlé Dwata kafye i Ngà lantienam. ");
INSERT INTO bpr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sawe là gtenan ku yé lmauy do yê i Amugu. ");
INSERT INTO bpr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kantogu linge i talùam gine, ta lamyak i ngà di lam tien-gu du mdà di klehewan. ");
INSERT INTO bpr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Banlé Dwata ge kafye du fantoom i ta fgadèan di ge.” ");
INSERT INTO bpr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na talù Méri, manan, “Toogu dnayen i Amugu Dwata mdà di nawagu, ");
INSERT INTO bpr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na too bong klehewgu mdà di Dwata, i Falwà do, ");
INSERT INTO bpr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","du balù ku logu fasak na too agu mdanà, bay gafaldaman agu. Na yé duenam man mdà ani, yé man i kdee dad to gablà di do na do i gumlé Dwata too bong kafye ");
INSERT INTO bpr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","du too bong mgimòan di do. Too maltulus i Dwata na too kenen tluh. ");
INSERT INTO bpr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mdà di kagatbùan kel di gusenan, toon fite i kakdon di dad to mafè kenen. ");
INSERT INTO bpr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ta gfiten i bong mgimòan fagu di kaltulusan. Na i dad to fdatah i ktola, ta snamukan i fandamla. ");
INSERT INTO bpr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I dad mdatah to nun glal, fdanàan ale, bay fdatahan i dad to mdanà. ");
INSERT INTO bpr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ta fabsolan i dad bitil fagu di dad fye blén di dale, bay i dad to bong knun, landè blé Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ta tnabengan i dad snaligan, dunan i bel Israél, na là glifetan fite i kakdon di ku Abraham na i belan kel di landè sen, du dnohòan i fakangan di dad gutambulto.” ");
INSERT INTO bpr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na fanak Méri di saféd Ilisabét kel di tlu bulen klon na kafnge ayè, ta mulê kenen. ");
INSERT INTO bpr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na kanto kel i bangan sut ngà Ilisabét, yé ngàan lagi. ");
INSERT INTO bpr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I dademen saldan na i dad flanekan, lingela i ta kfite Dwata i bong kakdon di kenen, na magin ale di klehewan. ");
INSERT INTO bpr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Di gwalun du mdà di ksut i ngà ayé, stifun i dad to déé du fimòla ilè di lawehan. Na yé fandamla, dnagitla kenen Sakaraya du fasngadénla di màan. ");
INSERT INTO bpr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bay talù i yêan, manan, “Ise, bay yé dagitan Dyan.” ");
INSERT INTO bpr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na manla di kenen, “Bay landè dademeyu dnagit salngad ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na kafnge ayé, sminyas ale di màan, dunan Sakaraya, du snalekla ku dét i kayèan dagit dun. ");
INSERT INTO bpr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yé duenam man, sminyas Sakaraya du fwè gusmulat na smulat kenen, manan, “Yé dagitan Dyan.” Na too ti tikeng i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na ta lê gtalù Sakaraya na flesan dnayen i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Too likò i dademela saldan. Na mbel i santulen gablà di mgimò ayé di kdee dad bulul di Dyudiya. ");
INSERT INTO bpr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na i kdee dad to lminge gablà di mgimò ayé, too ale faldam, na smalek ale, manla, “Dét kagkah i ngà ani kadang?” Manla ayé du too gadè na yé magin dun i kaltulus Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na i mà Dyan, dunan Sakaraya, fnò kenen i Mtiu Tulus, na tulenan i Tnalù Dwata, manan, ");
INSERT INTO bpr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dnayento i Amuto Dwata, dunan i fnangamfù i bel Israél, du ta kel kenen di dad ton na banlén ato kagalwà. ");
INSERT INTO bpr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta nun dek Dwata Falwà too maltulus. Na yé gutambulan ku Dabid, i snalig Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yé fakang Dwata fagu di dad tugadan mtiu di munan. ");
INSERT INTO bpr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Falwàan ato di dad to dmuen gito na di kagot i dad to muteh gito nawa. ");
INSERT INTO bpr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Fite Dwata i kakdon di dad gutambulto, na fandaman i fakangan too ti tluh. ");
INSERT INTO bpr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ani fakangan di ku Abraham, dunan i gutambulto, na falwàan ato di kagot i dad to dmuen gito du fye gmagan ato mimò i knayèan di landè klikòto. ");
INSERT INTO bpr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Du yé kayèan ku mtiu ato na tluh ato di kanfen kel di gusen i knèto dini di tah tanà. ");
INSERT INTO bpr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na ge, ngàgu, matlo ge tugad i Too Mdatah Dwata du muna ge di Amuto fye fatlagadam i dalanan, ");
INSERT INTO bpr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","du fgadèam di dad to i Dwata gablà di kagalwà fagu di kfasinsya Dwata i dad salàla. ");
INSERT INTO bpr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yé nimò Dwata du too kenen kamdo, na i kakelan dini di gito salngad di ksut i du, ");
INSERT INTO bpr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","du kenen i tmuyal i dad to mnè di gukmifuhan na di fati, na neben ato di ktanak nawa.” Yé man Sakaraya. ");
INSERT INTO bpr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na lamnok Dyan, dunan i ngà ayé, na baling matnù i ksaligan di Dwata. Na fanak kenen di banwe landè to mnè ditù kel di katbùan tamdò di dademen Dyu, dunan i dademe dad bel Israél. ");
INSERT INTO bpr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na di dad du atù, yé gumdatah di banwe Roma dunan Sisar Agustus. Na yé uldinan di dad to di kdee dad banwe nagotan, fsulatla i dagitla du nsen ale. ");
INSERT INTO bpr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ani tnanin kafsulatla dagit i kdee dad to. Na di slà ayé, yé gubirnador di probinsya Sirya dunan Kirinyus. ");
INSERT INTO bpr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na i kdee dad to, salu ale di banwe gusutla, du fsulatla i dagitla. ");
INSERT INTO bpr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na Dyosip, yé gutambulan di ku Harì Dabid. Na yé duenan mdà kenen di lunsud Nasarét glam di Galili na salu ditù di lunsud Bétléhém glam di Dyudiya, dunan i banwe Harì Dabid. ");
INSERT INTO bpr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na di ksalun ditù, faginan Méri, du fsulatla i dagitla. Na Méri i yaan to Dyosip ta maltien. ");
INSERT INTO bpr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na lamla déé di Bétléhém, ta kel nan i bang ksut i ngà Méri. ");
INSERT INTO bpr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yé duenam man, ta sut i tnanin ngàan na lagi. Na lnabédan falnas i laweh i ngà, na yé gufilèan dun di gufamkaan i dad lmanaf, du ta là sfayu ale di gal gumnè gumilè i dad to magu. ");
INSERT INTO bpr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na mdadong di Bétléhém, nun dad to mifat dad bilibilila di kifuh di galla gufateb dale. ");
INSERT INTO bpr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na tadè msut déé satu kasaligan i Dwata, na nun mneng glibut di dale ilè i bong kaltulus Dwata, na too ale likò. ");
INSERT INTO bpr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bay man i kasaligan di dale, “Nang gamu likò. Nun fgadègu di gamu too fye tulen i gamflehew i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Di mdu ani, ta sut di banwe Dabid i Falwà, dunan Krayst i Amuto. ");
INSERT INTO bpr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ani ilè gugmadèyu dun na dunan kenen. Teenyu i Ngà, ta lnabédla falnas na ta filèla kenen di gufamkaan i dad agaf.” ");
INSERT INTO bpr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na tadè msut déé i dee dademe dad kasaligan di safédan, na too ale dmayen i Dwata, manla, ");
INSERT INTO bpr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dnayento i Dwata ditù di tah langit du banlén ktanak nawa i dad to kalnehewan dini di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na kanto mulê i dad kasaligan ditù di langit, stulen i dad to mifat dad bilibili, na manla, “Mdà ato nan salu di Bétléhém du fye neyeto i ta mkel ani, dunan i fafgadè Amuto di gito.” ");
INSERT INTO bpr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yé duenam man, gasil ale mdà salu ditù, na kanto ale kel, teenla Méri na Dyosip na lê man i tukay Ngà ta milè di gufamkaan i dad agaf. ");
INSERT INTO bpr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na kantola teen i Ngà ayé, toola tulen i kdee ta lingela gablà di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na i kdee dad to lminge i tulen dad to mifat dad bilibili, too ale tikeng. ");
INSERT INTO bpr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bay Méri, toon kah di nawan i tulenla ayé na toon gal fandam. ");
INSERT INTO bpr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na samfulê nan i dad to mifat dad bilibili, na too ale dmayen di Dwata du mdà di kdee ta lingela na ta teenla du ta gdohò i man i kasaligan di dale. ");
INSERT INTO bpr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Di gwalun du mdà di ksutan, yé bangla fimò ilè di lawehan. Na dnagitla kenen Dyisas, du yé dagit tulen i kasaligan di là fa maltien Méri. ");
INSERT INTO bpr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na ta kel nan i bang ale Méri na Dyosip salu di Bong Gumnè Gumangamfù di Dwata di Dyérusalém du lalòla i uldin Dwata fagu di ku Mosis gablà di klaneb i libun ku falami sut i ngàan. Na kanto ale salu ditù, lêla nebe Dyisas du bléla kenen di Dwata, ");
INSERT INTO bpr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","du lalòla i uldin Dwata, manan, “I too twege ngà, ku lagi, là fakay ku là blé dun di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na yé dsù bléla du mdà di uldin Dwata dunan ani, “Lwe abun ku demen lwe lmuk malnak fa.” ");
INSERT INTO bpr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na nun satu lagi di Dyérusalém, yé dagitan Simyon, na too kenen fye to na nafèan i Dwata. Ta gnèan sanfatan i kafalwà Dwata i dad to bel Israél, na yé samnagin di kenen i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na ta fakang i Mtiu Tulus di kenen na silang kenen mati ku ta teenan Krayst, i dek i Amuto Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na mdà di kalak i Tulus i Dwata ku Simyon, salu kenen déé di Bong Gumnè Gumangamfù di Dwata. Na kanto nebe i dad tuan Dyisas salu déé du mdà di kimenla i uldin Dwata, ");
INSERT INTO bpr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","di kite Simyon ku Dyisas, nwèan na flesan dnayen i Dwata, manan, ");
INSERT INTO bpr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“E Amu, du ta teen-gu i kagdohò i fakangam di do, ta fakay nan ku faloham agu mati na faftudam agu, ");
INSERT INTO bpr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","du ta teen i matagu i dalan kagalwà ta blém di dad to. ");
INSERT INTO bpr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kenen i tagàam du fitem di kdee dad to, ");
INSERT INTO bpr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","i salò tmuyal di dad to ise Dyu. na i gumdà kdatah i dad tom, dunan i bel Israél.” ");
INSERT INTO bpr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na too tikeng i dad tua Dyisas di kaklingela i man Simyon gablà di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na kafnge ayé, dnasal Simyon ale du fye banlé Dwata ale kafye, na manan di ku Méri, i yê Dyisas, “Mgalék Dwata i Ngàam ani du mgimò kenen fye gumeye i dad to di banwe Israél. Di kitela kenen, nun dademe di dale, knangla nawa, na yé duenam man nun kaflayamla. Bay lê nun dademe i dmawat kenen, na yé duenam man nun kagalwàla. Balù ku kenen i ilè fite Dwata, knèan dee to kamnang dun nawa. ");
INSERT INTO bpr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na yé duenam man, too ti gadè i kdee gbuni i dad to. Na balù ge, Méri, too sè klidùam, sawe lnahul ge sundang.” ");
INSERT INTO bpr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Na nun libun, satu tugad i Dwata, yé dagitan Ana. Yé dagit màan Fanwél, na yé gutambulla ku Aser. Mdà di knun yaanan kel di fitu fali klon, ta mgimò kenen balu kel di walu falò fat fali. Ta too kenen tua nan. Na là sa tnagakan i Bong Gumnè Gumangamfù di Dwata, bay mangamfù kenen di Dwata mdu na kifuh fagu di kafwasa na kdasal. ");
INSERT INTO bpr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na di knè ale Méri déé, ta fdadong kenen di dale, na fasalamat di Dwata klon tmulen gablà di Ngà ayé di kdee dad to fatan i kafalwà Dwata i dad to di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na kafnge ale Dyosip na Méri mimò i kdee man i uldin Dwata fagu di ku Mosis, ta mulê ale di lunsud gumdàla, dunan Nasarét glam di Galili. ");
INSERT INTO bpr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na lamnok i Ngà ayè, dunan Dyisas, na midul i kgisan. Na too kenen fnò di kfulung, na i kafye Dwata mnè di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Di kat fali, i dad tua Dyisas, salu ale di Dyérusalém du magin ale di Fista i Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na kanto sfalò lwe fali Dyisas, salu ale ditù di fista du yé knalamla nimò. ");
INSERT INTO bpr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na kanto fnge i fista, ta mdà ale mulê, bay ftagak Dyisas di Dyérusalém na là gadè dad tuan dun. ");
INSERT INTO bpr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yé man nawala ku gagin kenen di dademela magu, na silangla fanngabal di bleng i dad flanekla na i dademela sgalak ta sdu i klola magu. ");
INSERT INTO bpr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bay là teenla dun. Yé duenam man, lê ale samfulê ditù di Dyérusalém du fanngaballa ditù. ");
INSERT INTO bpr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Silangla kenen teen di gatlun du ditù di lam i Bong Gumnè Gumangamfù di Dwata. Yé gusudengan di saféd i dad to gal tamdò, na tadè kenen flinge na snalekan ale. ");
INSERT INTO bpr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na i kdee dad to lminge kenen, too ale tngah du too kenen gmadè na too fulung tmimel. ");
INSERT INTO bpr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na kanto teen i dad tuan kenen, too ale tikeng, na man yêan, “E Tò, kan ku ani nimòam di gami màam? Too gami mlidù mngabal ge.” ");
INSERT INTO bpr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na tmimel Dyisas, manan, “Dét i duenyu mngabal do? Là kè gadèyu dun na too mabtas ku fanak agu dini di gumnè Màgu?” ");
INSERT INTO bpr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bay là glabatla ku dét i knayèan man di dale. ");
INSERT INTO bpr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na kafnge ayé, mdà kenen magin dale mulê di Nasarét na nimenan ale. Na i yêan, toon kah di nawan i kalbong kdee lingen na teenan gablà ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na baling matnù i kfulung Dyisas, na lamnok kenen, na toon flehew i Dwata na i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Di gasfalò lime fali di kagot Tibiryus Sisar, yé ganlal di Dyudiya dunan Pontyus Pilato, na yé ganlal di Galili dunan Harì Hérod. Di dad banwe Ituriya na Trakonitis, yé ganlal déé dunan i twalin dnagit Filip. Na yé ganlal di banwe Abilin dunan Lisanyas. ");
INSERT INTO bpr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na gasalngan di dale, yé dad ulu i dad ganlal di kafaglut i dad Dyu dunan Anas na Kayafas. Na di dad du atù, talù Dwata di ku Dyan, i ngà Sakaraya, di banwe landè to mnè ditù. ");
INSERT INTO bpr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na yé duenam man, lanngaban i kdee dad banwe mdadong di Éél Dyordan na tamdò kenen, manan dale, “Msal gamu na tnagakyu i dad sasè nimòyu na fbunyag gamu, na ku yé nimòyu fnasinsya Dwata dad salàyu.” ");
INSERT INTO bpr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na yé klon gdohò i sulat Isaya, satu tugad i Dwata di munan, manan, “Nun to tamlo di banwe landè to mnè ditù, manan, ‘Fatlagadyu i dalan i Amu, na tanluhyu i gumagun fagu di kafatlagadyu i ktoyu. ");
INSERT INTO bpr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lnimunyu i kdee dad sbang na sandatalyu i dad bulul. Tanluhyu i dad dalan kigò, na lnimunyu i dad dalan magbang. ");
INSERT INTO bpr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na teen i kdee dad to i dalan kagalwà blé Dwata.’ ” Yé ta fala fgadè Isaya di muna gablà ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na nun dee dad to salu di ku Dyan du fbunyag ale. Na kanto ale kel déé, man Dyan di dale, “Gamu dad ulad. Simto man dun di gamu na galwà gamu di flayam fan kel febe Dwata ku lo gamu fbunyag? ");
INSERT INTO bpr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ku ta msal gamu di dad salàyu, fiteyu i ta ksalyu fagu di dad fye nimòyu. Na nang gamu fagdag di kmanyu dun, ‘Gami bel Abraham. Balù ku là msal gami, là gagin gami di flayam febe Dwata.’ Ani man-gu di gamu, balù fa i dad batu ani, gagan Dwata fambaling dale bel Abraham ku kayèan tamlas gamu. ");
INSERT INTO bpr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","I flayam febe Dwata, ta too mdadong nan. Ku fkahta di to mbek kayu, ta déé i balyung di foon i kayu. Na kat satu kayu là menge fye, nbekan na snakufan di lifoh.” ");
INSERT INTO bpr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na smalek i dad to ayé di ku Dyan, manla, “Na ku ayé, dét i fye nimòmi kè?” ");
INSERT INTO bpr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na tmimel Dyan, manan, “I to ku lwe saulan blén i satu di to landè saul, na i to nun knaanan, fye ku began banlé i dad to landè knaan.” ");
INSERT INTO bpr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na nun dad to kel déé gal mwè bayad i buhis di dad to. Yé duenla salu déé du mayè ale fbunyag na smalek ale, manla, “Sér, dét i fye nimòmi gami?” ");
INSERT INTO bpr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na tmimel kenen, manan, “Lo ayé nwèyu di dademeyu to i man i uldin i gubirnu.” ");
INSERT INTO bpr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na lê nun dad sundalu kel déé na smalek ale, manla, “Na gami, dét i nimòmi?” Na tmimel Dyan, manan, “Nang gamu mwè filak fagu di kfeges ku demen fagu di kdalamyu i dademeyu to. Na fye ku gablà di nawayu i sukéyyu.” ");
INSERT INTO bpr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","I kdee dad to stifun déé, ta toola fatan kakel i Mgalék Dwata. Na yé duenam man, kantola linge i katdò Dyan, yé mnè di nawala na keng kenen. ");
INSERT INTO bpr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bay man Dyan di dale, “Nun kel satu too mdatah di do. Là gablà agu mteh i ikat talumfàan du too agu mdanà di kenen. Bnunyagta gamu fagu di éél, bay kenen i munyag gamu fagu di Mtiu Tulus na di lifoh. ");
INSERT INTO bpr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sansahalan i dad to salngad i to tmaaf fali. Na fakayta man na ta sanan nagot i taaf du tmaaf. I fali ta magtaaf, busekan di folan, bay i kdee dad afa, snakufan di lifoh kel di landè sen.” ");
INSERT INTO bpr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na di lam Dyan tamdò i Fye Tulen, dee kfagun falmau i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Di satu du, nngak Dyan Harì Hérod du snafédan yaan i flanekan, dunan Hérodiyas, na lêan nngak di dademe sasè nimòan. ");
INSERT INTO bpr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na yé duenam man, Harì Hérod, balingan tananù i ksasè nimòan du fablanggùan Dyan. ");
INSERT INTO bpr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Di lam là blanggù Dyan, di galan kbunyag i dad to, ta lê fbunyag Dyisas. Na kafngen fbunyag, dmasal na tadè mgukà i langit. ");
INSERT INTO bpr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na ta tufa i Mtiu Tulus gambet abun na mnè di kenen. Na nun talù mdà di langit, manan, “Ge i Ngàgu toogu kando. Too fye nawagu ge.” ");
INSERT INTO bpr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na Dyisas, keng ta tlu falò fali i ta ktuan, yé katbùan tamdò. Na di fandam i dad to, kenen i ngà Dyosip, dunan i ngà Hili. ");
INSERT INTO bpr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Na Hili i ngà Matat, dunan i ngà Libay, dunan i ngà Mélkay, dunan i ngà Dyani, dunan i ngà Dyosip. ");
INSERT INTO bpr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na Dyosip i ngà Matatyas, dunan i ngà Amos, dunan i ngà Nahum, dunan i ngà Isli, dunan i ngà Nagay. ");
INSERT INTO bpr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na Nagay i ngà Maat, dunan i ngà Matatyas, dunan i ngà Simin, dunan i ngà Dyosik, dunan i ngà Dyoda. ");
INSERT INTO bpr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na Dyoda i ngà Dyoanan, dunan i ngà Risa, dunan i ngà Sorubabél, dunan i ngà Saltiyél, dunan i ngà Néri. ");
INSERT INTO bpr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Na Néri i ngà Mélkay, dunan i ngà Adi, dunan i ngà Kosam, dunan i ngà Ilmadam, dunan i ngà Ir. ");
INSERT INTO bpr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na Ir i ngà Dyaswa, dunan i ngà Élisar, dunan i ngà Dyoram, dunan i ngà Matat, dunan i ngà Libay. ");
INSERT INTO bpr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na Libay i ngà Simyon, dunan i ngà Dyuda, dunan i ngà Dyosip, dunan i ngà Dyonam, dunan i ngà Ilaykim. ");
INSERT INTO bpr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na Ilaykim i ngà Milya, dunan i ngà Mina, dunan i ngà Matata, dunan i ngà Natan, dunan i ngà Harì Dabid. ");
INSERT INTO bpr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na Harì Dabid i ngà Dyési, dunan i ngà Obéd, dunan i ngà Boas, dunan i ngà Salmon, dunan i ngà Nason. ");
INSERT INTO bpr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na Nason i ngà Aminadab, dunan i ngà Admin, dunan i ngà Arni, dunan i ngà Hésron, dunan i ngà Péris, dunan i ngà Dyuda. ");
INSERT INTO bpr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Na Dyuda i ngà Dyékob, dunan i ngà Isaak, dunan i ngà Abraham, dunan i ngà Téra, dunan i ngà Nahor. ");
INSERT INTO bpr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na Nahor i ngà Sirug, dunan i ngà Ru, dunan i ngà Pilig, dunan i ngà Ibir, dunan i ngà Sila. ");
INSERT INTO bpr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Na Sila i ngà Kainan, dunan i ngà Arfaksad, dunan i ngà Sém, dunan i ngà Nowa, dunan i ngà Lamik. ");
INSERT INTO bpr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na Lamik i ngà Métusila, dunan i ngà Inok, dunan i ngà Dyaréd, dunan i ngà Mahalalil, dunan i ngà Kainan. ");
INSERT INTO bpr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Na Kainan i ngà Inos, dunan i ngà Sét, dunan i ngà Adan, dunan i ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na di kasfulê Dyisas fdu di gufbunyagan di Éél Dyordan, mnè di kenen i Mtiu Tulus, na nebe i Mtiu Tulus salu di banwe landè to mnè ditù. ");
INSERT INTO bpr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Fat falò butangan fanak déé, na tnilew Satanas kenen. Di bang ayé, là ti kmaan Dyisas, na yé duenam man kanto kel di gusenan, ta bitil kenen. ");
INSERT INTO bpr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na man Satanas di kenen, “Ku ge Ngà i Dwata, fagu di talùam, fanbalingam fan i batu ani.” ");
INSERT INTO bpr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bay tmimel Dyisas, manan, “Ta gsulat di Tnalù i Dwata, manan, ‘Ise ku lo knaan gamlawil i dad to.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na lê nebe Satanas kenen di too mdatah bulul na di lo sudaf fiten dun i kdee dad banwe nagot i dad to di tah tanà. ");
INSERT INTO bpr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na manan ku Dyisas, “Ta gablé di do i glal na kdatah magot i klamang banwe, na fakaygu fagot di balù simto kayègu. Na ani, blégu di ge i glal na i kdatah magot i kalbong kdee ta teenam. ");
INSERT INTO bpr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Blégu di ge i kdee ani syan ku mangamfù ge di do.” ");
INSERT INTO bpr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bay man Dyisas, “Ta gsulat di Tnalù i Dwata, manan, ‘Mangamfù ge di Amu, dunan i Dwatam, na lo kenen i nimenam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na ta lê nebe Satanas kenen salu di Dyérusalém, na ftadagan kenen di sangal tah ataf i Bong Gumnè Gumangamfù di Dwata déé. Na manan ku Dyisas, “Ku ge Ngà i Dwata, kamyaf ge mdà dini, ");
INSERT INTO bpr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","du ta gsulat di Tnalù i Dwata, ‘Dek Dwata i dad kasaliganan mifat ge, ");
INSERT INTO bpr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","du snamalla ge fye là gtadè i blìam di dad batu na landè glumfakam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bay lê tmimel Dyisas, manan, “Ta lê gsulat di Tnalù i Dwata, manan, ‘Nangam tnilew i Amu, dunan i Dwatam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kanto mti kfagu Satanas tmilew ku Dyisas, gadèan na landè kibòan ftatek ku Dyisas di salà. Yé duenam man, tnagakan Dyisas na fatanan i dademe du i lêan ktilew dun. ");
INSERT INTO bpr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kafnge ayé, ta mulê Dyisas di Galili na yé gumdà i gaganan di Mtiu Tulus, na mbel i dad santulen gablà di kenen di kabal i banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Too kenen tamdò di dad gumnè gal gustifun i dad Dyu na too dnayen i dad to kenen. ");
INSERT INTO bpr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na fles Dyisas di lunsud Nasarét, dunan i banwe gulamnokan. Kanto kel i Du Kaftud, fusuk kenen di gumnè gal gustifun i dad Dyu déé, du yé knalaman nimò. Na ta tadag kenen du masa di Tnalù i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na yé bléla di kenen i sulat Isaya, satu tugad i Dwata. Na nbelan i sulat lnulun, na teenan gugsulat i gmanan ani, ");
INSERT INTO bpr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yé samnagin di do i Mtiu Tulus du ta nalékan agu tamdò i Fye Tulen di dad to landè. Ta dekan agu tmulen gablà di kagalwà i dad to di blanggù na gablà di kafgulê i dad to butè. Na ta dekan agu tmabeng i dad to maflayam. ");
INSERT INTO bpr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na lêgu tulen gablà di kakel i bang Amu fite i kakdon.” ");
INSERT INTO bpr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na kafnge ayé, ta lêan lnulun i sulat, na fulêan di to magot dun klon sudeng du fan tamdò. Na i kdee dad to di lam i gustifun ayé, toola kenen neye. ");
INSERT INTO bpr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na kafnge ayé, ta lê kenen talù, manan, “Di mdu ani, di kaklingeyu i bnasagu mdà di Tnalù i Dwata, ta gdohò nan.” ");
INSERT INTO bpr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na i kdee dad to déé, too fye i manla gablà di kenen, na tikeng ale du mdà di kafye i dad talùan. Na sasalek ale, manla, “Dunan ani kè i ngà Dyosip?” ");
INSERT INTO bpr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na man Dyisas di dale, “Ta fanyu man di do i galla fléd ani, manan, ‘Ku fulung ge mulung, bnulungam i ktom. Na mimò ge tnikeng dini di gumdàam gambet i nimòam kun ditù di Kapernaum.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na fadlug kenen talù, manan, “Bay tulenta gamu i kaglutan. I tugad Dwata, là dnawatla dun di banwe gumdàan. ");
INSERT INTO bpr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Too ti glut i man-gu ani di gamu. Di munan, di knè Ilaydya di Israél, tlu fali tngà là mulenan, na mdà ayé, too bong i kbitil déé di kabal banwe. Na di dad du ayé, dee dad libun balu di Israél. ");
INSERT INTO bpr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bay ise ku déé gumdek Dwata ku Ilaydya, bay dekan kenen ditù di satu libun balu di banwe Sarifta di Sidon. ");
INSERT INTO bpr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na lê dee i dad to nun fdas mumuh di Israél di bang i satu tugad i Dwata, dnagit Ilaysya. Bay landè di dale mgulê, lo senan satu lagi mdà ditù di banwe Sirya dnagit Néman.” ");
INSERT INTO bpr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na kanto linge dad to di gustifun i dad Dyu i man Dyisas ayé, too ale malbut. ");
INSERT INTO bpr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tadag ale, na falwàla Dyisas di lunsud klola mebe kenen ditù di tfad i bulul gugdak i lunsudla du fnuléhla kenen di kbe. ");
INSERT INTO bpr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bay tadè kenen magu di bleng i dad to ayé na fles mdà. ");
INSERT INTO bpr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na salu Dyisas ditù di Kapernaum, satu lunsud di Galili, na kanto kel i Du Kaftud, tamdò kenen di dad to. ");
INSERT INTO bpr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Too ale tngah gablà di katdòan du too gamban i ktalùan. ");
INSERT INTO bpr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na déé di gumnè gal gustifun i dad Dyu, nun teenan lagi nun busawan. Mkit i busaw fagu di lagi ayé, manan, ");
INSERT INTO bpr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“E, Dyisas mdà di Nasarét, landè labetam di gami. Fanam gami falmo kè? Gadègu ku simto ge. Ge sa i Too Mtiu mdà di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bay nngak Dyisas i busaw ayé, manan, “Fanak ge. Lamwà ge di kenen.” Na bat busaw i to ayé di kite i kdee dad to, na lamwà kenen, na là fatdukan dun. ");
INSERT INTO bpr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na too ti tngah i kdee dad to, na sasalek ale, manla, “Too ti tnikeng i tdò ani. Di glal na kaltulus, dekan i dad busaw lamwà, na mimen ale.” ");
INSERT INTO bpr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na too mbel i santulen gablà di ku Dyisas di kabal banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na mdà Dyisas fdu di gumnè gal gustifun i dad Dyu, na salu kenen di gumnè satu lagi dnagit Simon. Na i tewe Simon libun, too ti minit i lawehan, na mdà ayé fnila i tabeng Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na fdadong Dyisas déé di gumilèan, na dekan lamwà i init i libun ayé, na ta mkah i kinitan. Tadè kenen mték, na fles mimò dale knaan. ");
INSERT INTO bpr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na di kasdaf i du, i dad to déé, nebela di ku Dyisas i kdee dademela nun dad sahal tduk. Na nagotan kat satu dale, du fan-gulêan ale. ");
INSERT INTO bpr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na lêan falwà dad busaw di dademe dad to. Na mkit i dad busaw, manla, “Ge sa Ngà i Dwata.” Bay nngakan ale, na là ftalùan ale du gadèla na kenen i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na di ksut i du, mdà Dyisas salu di satu banwe landè to mnè ditù. Na too fanngabal i dad to kenen. Na kantola teen, yé kayèla ku fles kenen fanak déé. ");
INSERT INTO bpr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bay manan dale, “Là fakay ku là lê agu tamdò i Fye Tulen gablà di Kagot i Dwata di dademe dad lunsud du yé dek Dwata do.” ");
INSERT INTO bpr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na fadlug kenen tamdò di dad gumnè gal gustifun i dad Dyu di Dyudiya. ");
INSERT INTO bpr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Di satu du, tadag Dyisas di kilil i bong lanaw dnagit Génésarét. Na too sfital i kdee dad to di safédan du falningela i katdòan Tnalù i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na nun teenan déé lwe aweng tnagak i dad to gal fmukat nalaf. Yé nimò i dad to ayé, lnanebla i dad fukat. ");
INSERT INTO bpr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na myak Dyisas di aweng Simon, na fulukan dun i aweng du fye beg fawag di kilil. Na sudeng Dyisas du tdòan i dad to mdà di aweng. ");
INSERT INTO bpr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kanton fnge tamdò, manan di ku Simon, “Ftalà gamu na ftatekyu i dad fukat du fye nun gwèyu.” ");
INSERT INTO bpr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na man Simon, “Amu, ta tnadakmi i butang na landè gwèmi. Bay du manam, lêmi ftatek i dad fukatmi.” ");
INSERT INTO bpr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na kantola ftatek, too ti bong i gwèla nalaf na ta baling fan kasê i dad fukatla. ");
INSERT INTO bpr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na yé duenam man, knabilla i dademela di satu aweng du ftabengla ale. Na kanto fdadong i dademela, fananòla i lwe aweng nalaf, na ta fan ale galnab. ");
INSERT INTO bpr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na kanto teen Simon Piter ayé, lkuad kenen di muna Dyisas, na manan, “E Amu, beg ge fawag di do du too agu gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yé duen Simon man ayé du too ale tikeng du too ti dee gwèla nalaf. ");
INSERT INTO bpr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na balù i dademe Simon dnagit Dyém na Dyan, dunan i dad ngà Sébidi, lê ale tikeng. Bay man Dyisas di ku Simon, “Nang ge likò. Mdà ani, yé fnukatyu dad to.” ");
INSERT INTO bpr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na yé duenam man, kanto ale dmuung, ta tnagakla i kdee nfunla déé, na magin ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Di satu du, déé Dyisas di satu lunsud, na nun lagi too sasè i fdasan mumuh. Kanton teen Dyisas, lkuad kenen na lamfan, na fakdo kenen, manan, “Amu, gadègu gaganam agu fan-gulê du fye too mlaneb i kulitgu, ku mayè ge.” ");
INSERT INTO bpr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na nagot Dyisas kenen, na manan, “Mayè agu sa. Mgulê ge nan.” Na tadè mkah i fdasan mumuh ayé. ");
INSERT INTO bpr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na fnge, dek Dyisas kenen, manan, “Nangam ti tulen ani balù simto dun. Bay mdà ge, na fitem i laweham di ganlal di kafaglut gal damsù, na nebem ditù i dsùam gambet i uldin Dwata fagu ku Mosis. I dsù nebem, yé gugmadè i kdee dad to dun na ta mgulê ge na ta mlaneb i kulitam.” ");
INSERT INTO bpr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Balù ku ta fnang Dyisas kenen tmulen gablà di kgulêan, bay baling too mbel fa i santulen gablà ku Dyisas, na mdà ayé, too dee dad to gal stifun di munan du falningela i tdòan na fafgulêla di kenen i dad tdukla. ");
INSERT INTO bpr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bay gal salu Dyisas di dad banwe landè to mnè ditù du dmasal. ");
INSERT INTO bpr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Di satu du lam Dyisas tamdò, nun sudeng déé dad Farisi na lê man i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. Yé gumdàla di kdee dad malnak banwe di Galili na Dyudiya. Na lê nun dademe mdà di syudad Dyérusalém. Na mnè di ku Dyisas i kaltulus Dwata du fye gafgulêan i dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na nun dad lagi kel déé, na nun nebela to là galyakan i lawehan, santiangla magin i gumilèan. Tilewla nebe kenen fusuk di lam i gumnè gutamdò Dyisas du fye kahla di sen munan. ");
INSERT INTO bpr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bay kantola teen na landè dalanla du mdà di kdee dad to stifun, myak ale di tah i ataf na lanketla i dademe ataf klola fayol kenen magin i gumilèan déé di muna Dyisas di bleng i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na kanto teen Dyisas i bong ksaligla, manan di to ayé, “E Leg, ta magfasinsya nan i dad salàam.” ");
INSERT INTO bpr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bay i dad Farisi na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, kantola linge i man Dyisas ayé, yé mnè di fandamla, “Simto i ta mlad ani du landè dademe gmagan fmasinsya i salà, lo senan Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bay ta gadè Dyisas i mnè di fandamla, na manan dale, “Kan ku yé mnè di nawayu? ");
INSERT INTO bpr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Man nawayu kè ku landè glalgu fmasinsya salà i to ani? Bay yé too ilè na nun glalgu ku ta man-gu di kenen, ‘Mték ge na magu ge,’ na gagu kenen. ");
INSERT INTO bpr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na yé kayègu ku gadèyu na do, dunan i dnagit Ngà To, nun glalgu dini di tah tanà fmasinsya salà.” Na kafnge Dyisas man ayé di dale, ta talù di to là galyak ayé, na manan, “Dekta ge, mték ge, nwèam i gumilèam, na mulê ge.” ");
INSERT INTO bpr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na tadè tadag i to ayé di bleng i dad to, na ta nwèan i gumilèan na mulê, na toon dnayen i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Too ti tikeng i kdee dad to, na dmayen ale di Dwata. Tngah ale, na manla, “Too tnikeng i teento ani gine.” ");
INSERT INTO bpr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kafnge ayé, ta mdà Dyisas magu, na nun teenan satu to gal mwè bayad i buhis, yé dagitan Libay. Teen Dyisas kenen sudeng di gutalbahòan, manan, “Magin ge di do.” ");
INSERT INTO bpr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na ta tadag Libay, na tnagakan i kdee dad knunan déé du magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na fimò Libay bong knaan di gumnèan du fkaanan dale Dyisas. Na yé kmaan di safédla dee dademe dad to gal mwè bayad i buhis na lê dademe dad to. ");
INSERT INTO bpr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na mdà ayé, sungag i dad Farisi na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na manla di dad to tdò Dyisas, “Kan ku kmaan gamu di saféd i dad to gal mwè bayad i buhis na i dademe dad to lmafà i dad uldin Dwata?” ");
INSERT INTO bpr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na tmimel Dyisas fagu di fléd, manan, “I to fandas, nun gukmamun i to mulung. Bay i to landè fdasan, landè gukmamun i to mulung. ");
INSERT INTO bpr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ise ku i dad to tluh i fanngabalgu, bay i dad to gamsalà du fye msal ale.” ");
INSERT INTO bpr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na lê nun dad to talù di ku Dyisas, manla, “I dad to gal tdò Dyan Gal Munyag, na balù i dad to tdò dad Farisi, gal ale fwasa na dmasal. Bay i dad to tdòam ge, là gal ale fwasa.” ");
INSERT INTO bpr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na man Dyisas di dale, “Ku fkahta di dad to nlak magin samsong, là tayò ale fwasa ku sana kdéé di safédla i lagi sansong. ");
INSERT INTO bpr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bay nun du kadang ku ta là dini di safédla i lagi sansong ani, na yé klola fwasa.” ");
INSERT INTO bpr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na lê nun tulen Dyisas dale i dad guflingen ani, manan, “Là fakay mwè falami falnas ku klafang di labi klaweh. Ku nimòam ayé, malmo i falami falnas, na i falami falnas là gtenan klafang di klaweh ta labi. ");
INSERT INTO bpr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na là fakay kah di lam i labi kulit i falami binu, du keng btù i kulit ayé, na malmo i binu na lê man i kulit. ");
INSERT INTO bpr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yé duenam man, yé gumkah i falami binu di falami kulit. ");
INSERT INTO bpr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na landè to mayè minum falami binu ku ta gamginum i labi du manan, ‘Too ti fye nem i labi.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Di satu Du Kaftud i dad Dyu, magu ale Dyisas di satu lnigo. Na i dad to galan tdò, beg ale kambang là dee kigan trigo, na fnilula du knilewla i msehan. ");
INSERT INTO bpr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na man i dademe dad Farisi, “Kan ku kamtu gamu di Du Kaftud? Là fakay ayé, du fnang Dwata di uldinan fagu di ku Mosis.” ");
INSERT INTO bpr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na tmimel Dyisas, manan, “Kan kè? Là lmenyu masa gablà di nimò Dabid du mdà di kbitilan na i dademen? ");
INSERT INTO bpr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ani nimòan. Fusuk kenen di Bong Gumnè Gumangamfù di Dwata, na nwèan i fan gal blé di Dwata. Na blaam, yé lo fakay kmaan i fan ayé i dad ganlal di kafaglut, bay knèan kmaan Dabid i fan ayé, na banlén i dademen.” ");
INSERT INTO bpr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na fadlug Dyisas talù, manan, “Yé magot i Du Kaftud dunan i Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na lê man di satu Du Kaftud, fusuk Dyisas di gumnè gal gustifun i dad Dyu du tamdò. Na nun lagi déé, fikot sigalan gsen di kwanan. ");
INSERT INTO bpr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na i dad Farisi na i dad to gal tamdò i uldin Dwata fagu di ku Mosis, too ale meye kfagu du fye nun gutadagla tmifù ku Dyisas na mdà ayé, toola kenen tnanul du neyela ku nun to fan-gulêan di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bay Dyisas, ta gadèan ku dét i mnè di fandam i dad to ayé. Na yé duenam man, manan di lagi ayé, “Tadag ge di muna i kdee dad to ani.” Na ta tadag kenen. ");
INSERT INTO bpr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na snalek Dyisas ale, manan, “Snalekta gamu kun. Dét man i uldin Dwata fagu di ku Mosis? Dét i fye nimò di Du Kaftud, fye ku sasè? Tnabengto i dademeto to ku fnatito ale?” ");
INSERT INTO bpr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na meye Dyisas di kdee dad to ayé, na fnge manan di lagi fikot, “Bankeham i sigalam.” Kanton bankeh, tin tadè bkeh na ta mgulê. ");
INSERT INTO bpr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bay too ti falbut i dad Farisi na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na santulenla ku dét fanla kibò ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Di satu du, mnagad Dyisas di bulul du dmasal. Na tnadakan i butang dmasal di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kanto flafus, tlon i dad to galan tdò du malék kenen sfalò lwe i fakayan dnagit dad to galan dek. ");
INSERT INTO bpr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ani dagitla, Simon, dunan i dnagit Dyisas Piter, na Andru, i flanek Simon, na Dyém, na Dyan, na Filip, na Bartolomyu, ");
INSERT INTO bpr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na lê Matyu, na Tomas, na Dyém i ngà Alfyus, na Simon, dunan i msen i banwen, ");
INSERT INTO bpr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na lê Dyudas, i ngà Dyém, na Dyudas Iskariyot, dunan i makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na flasok ale Dyisas di bulul ayé, na tadag kenen di datal. Na nun dee dad to galan tdò, na dee dademe dad to mdà di kabal Dyudiya, na Dyérusalém, na i dad banwe Tiro na Sidon mdadong di mahin. ");
INSERT INTO bpr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Salu ale déé du falningela i tdòan na fafgulêla kenen i dad fdasla. Na fan-gulêan i dad to nun busaw. ");
INSERT INTO bpr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na i kdee dad to, mayè ale magot ku Dyisas du fagu di kaltulusan, fan-gulêan i kdeela. ");
INSERT INTO bpr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na meye Dyisas di dad to tdòan, na manan, “Nun kafyeyu, gamu dad to landè du gagin gamu di Kagot i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nun kafyeyu, gamu dad to bitil ani, du bsol gamu kadang. Nun kafyeyu, gamu dad to mngel ani du mulé gamu kadang. ");
INSERT INTO bpr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nun kafyeyu ku nuteh nawa i dad to gamu na ku knangla gamu, na ku nadoyla gamu, na ku fansasèla gamu du mdà di ksasatuyu di do, i dnagit Ngà To. ");
INSERT INTO bpr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yé lê kibò i dad gutambulla di dad tugad i Dwata. Yé duenam man, too gamu flehew di bang i dad klimahyu ani du too ti bong i lubayyu kadang di langit. ");
INSERT INTO bpr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bay magakdo gamu i dad to bong knun, du ta gdawatyu nan i kafyeyu. ");
INSERT INTO bpr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Na magakdo gamu dad to gal bsol ani du bitil gamu kadang. Magakdo gamu dad to mulé ani du mlidù gamu na mngel kadang. ");
INSERT INTO bpr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Na magakdo gamu ku i kdee dad to dnayenla gamu du yé sén nimò i dad gutambulla di ise glut tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Bay, ani kayègu man di gamu, dunan i dad to flinge di do. Kanbongyu nawa i dad to dmuen gamu, na mimò gamu fye di dad to mnang gamu nawa. ");
INSERT INTO bpr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mni gamu di Dwata du fye banlén kafye i dad to falmagi gamu, na dnasalyu i dad to famsasè gamu. ");
INSERT INTO bpr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ku nun to dmafì gamu di bali bawehyu, nàyu i balin. Ku nun to mwè i saulyu tahà sigal, lêyu fagin blé i saulyu fukal sigal. ");
INSERT INTO bpr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Banléyu i kdee dad to mni di gamu, na ku nun to mwè dad knunyu, nangyu lê tan-gaad nawì. ");
INSERT INTO bpr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ku dét i kayèyu fye nimò i dademe dad to di gamu, yé funayu nimò di dale. ");
INSERT INTO bpr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kaflingenta dun, ku lo yé kandoyu i dad to kamdo gamu, landè lubayyu di nimòyu ayé, du balù i dad to gamsalà, kandola i dad to kamdo dale. ");
INSERT INTO bpr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na ku lo yé gumimòyu fye di dad to mimò fye di gamu, landè lubayyu di nimòyu ayé, du balù i dad to gamsalà, nun kakdola di dad to mimò fye di dale. ");
INSERT INTO bpr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na ku lo yé gufutengyu di dad to gambayad i uteng, landè lubayyu di nimòyu ayé, du balù i dad to gamsalà, futeng ale di dademela na fatanla kbayad i uteng. ");
INSERT INTO bpr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bay ani nimòyu. Kanbongyu nawa i dad to dmuen gamu, na mimò gamu fye di dale, na futeng gamu, bay nangyu ntuk i bayad. Ku yé nimòyu, too bong lubayyu na gfiteyu gamu dad ngà i Too Mdatah Dwata, du balù i dad sasè to na i dad to là fulung fasalamat, kanbong nawa Dwata ale. ");
INSERT INTO bpr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kanbongyu nawa i kdee dad to salngad i kalbong nawa Màyu i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nangyu nukum i dademeyu to du fye là nukum Dwata gamu. Nangyu falnayam i dademeyu to du fye là falnayam Dwata gamu. Bay fnasinsyayu salà i dademeyu du fye lê fnasinsya Dwata i dad salàyu. ");
INSERT INTO bpr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Banléyu i dademeyu to na banlé Dwata gamu. Too ti bong i blén di gamu. Fakayta man nasakan na ningokan na falbésan i kafye blén di gamu. Ku dét kalbong bléyu di dademeyu to, salngad ayé i kalbong blé Dwata di gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na lê talù Dyisas fagu di fléd, manan, “I to butè, landè kibòan malak i lê satu to butè. Ku yé nimòan, lwe ale baling tatek di sol. ");
INSERT INTO bpr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mdatah i to tamdò di to tdòan, bay ku nun to ta too sikof i kagbetan, ta gasalngadan i to tamdò kenen. ");
INSERT INTO bpr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kan ku neyem i tukay salà gambet fuling di mata i flanekam, bay tadèam bayà i bong salà gambet bateng di ge mata. ");
INSERT INTO bpr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kan dé ku manam, ‘E flanek, nwèta kun i fulingam,’ na blaam sana kdéé i bong bateng di ge mata? Sasè ge. Funam nwè i bateng di matam alì fye kitem mwè fuling i flanekam. ");
INSERT INTO bpr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“I kayu fye, là mengen sasè. Na i sasè kayu, là mengen fye. ");
INSERT INTO bpr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yé gudmilè i kayu di bengen. I awi, là ti mengen fig. Na i banal, là mengen grép. ");
INSERT INTO bpr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na salngad ayé i dad to. I fye to, slame fye lamwà di bàan du yé gumdàan di kdee fye busekan di nawan. Na i sasè to, slame sasè lamwà di bàan du yé gumdàan di kdee sasè busekan di nawan. Ku dét i mnè di nawa satu to, yé lamwà di bàan. ");
INSERT INTO bpr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kan ku tloyu agu ‘Amu,’ bay là nimenyu i man-gu. ");
INSERT INTO bpr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nun guflingen-gu i to salu di do na falningen i man-gu na nimenan. ");
INSERT INTO bpr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Salngad kenen i to too fulung fdak gumnè. Ani kibòan, fngalaman i kakolan na fdakan dad lahan di batu. Na kanto fnge i gumnè, nun kel bong dunuk, na sloban i gumnè ani, bay là bekan du too mbagal i gugafdakan. ");
INSERT INTO bpr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bay lê nun guflingen-gu i to flinge i man-gu ku là nimenan. Salngad kenen i to là fulung fdak gumnè. Ani kibòan kenen. Landè batu gufdakan i lahan. Na kanto kel i dunuk, tadè bek i gumnè ani na mti malbà.” ");
INSERT INTO bpr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Di kafnge Dyisas tamdò kdee ayé gine di dad to, salu kenen di Kapernaum. ");
INSERT INTO bpr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na nun satu ganlal i dad sundalu déé mdà di Roma, na nun satu fasakan i toon kando. Fandas i fasakan ayé, na fan mati. ");
INSERT INTO bpr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na kanto linge i ganlal ayé gablà ku Dyisas, ta dekan i dademe dad tua gal mebe dad Dyu du fakdo ale ku Dyisas du fye magin kenen di dale. Yé kayè i ganlal ayé ku gadéé Dyisas fye fan-gulêan i fasakan. ");
INSERT INTO bpr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na kanto ale salu di ku Dyisas, too ale fakdo di kenen, manla, “Gablà tnabeng i to ani, ");
INSERT INTO bpr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","du kandon gito dad Dyu, na fafdakan fa i gumnè galto gustifun.” ");
INSERT INTO bpr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na yé duenam man, magin Dyisas di dad tua mngé kenen. Kanto mdadong ale Dyisas di gumnè, lê dek i ganlal i dademen sgalak fsitong ku Dyisas. Na kanto kel i dad to dekan di ku Dyisas, manla di kenen, “Amu, yé fnè i to mdek gami nang ge faflayam kun. Nang ge fles du là gablàan kun fafusuk ge di gumnèan. ");
INSERT INTO bpr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yé duenan kun là samsite ge du mdanà kenen di ge. Bay ku lo ge talù kun, fagu di talùam ayé, mgulê sa i fasakan. ");
INSERT INTO bpr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gadèan ani kun du balù kenen, nun ganlal mdatah di kenen na lê nun dad sundalu mdanà di kenen. Ku nun dekan sundalu mdà, mdà kenen sa. Na ku manan di satu, ‘Salu ge dini,’ na mimen kenen. Na balù dét i fimòan di satu, yé nimòan. Na matnù fa kun i ge glal, du balù dét i kayèam, gaganam nimò balù ku lo fagu di ktalùam.” ");
INSERT INTO bpr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na kanto linge Dyisas i fnè i ganlal, too kenen tikeng na blaling kenen di kdee dad to magin di kenen, na manan, “Ani i man-gu di gamu, na là lmen-gu mite di dad to Israél i kaftoo salngad di bong kaftoo i to ani di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na i dad to dek i ganlal, lê ale mulê na kanto ale kel déé, teenla na ta mgulê i fasakan. ");
INSERT INTO bpr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Di là mlo, salu Dyisas di satu banwe, yé dagitan Nain, na magin i dad to tdòan na lê dee dademe dad to. ");
INSERT INTO bpr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na kanto kenen kel di takab i labat di banwe ayé, nun gsitongan dademe dad to, na nebela lamwà satu lagi ta mati. Ta balu i yêan, na landè dademe ngàan. Na too dee dad to magin di balu ayé. ");
INSERT INTO bpr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na kanto teen Amuto Dyisas kenen, toon kando, na manan, “Nang ge mngel.” ");
INSERT INTO bpr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na fdadong Dyisas di guflasàla i mati ayé, na nagotan i guflasàla dun. Tadè fanak i dad to mebe dun, na man Dyisas, “E tò, mték ge.” ");
INSERT INTO bpr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na ta mték i to mati ayé, na talù kenen. Na fulê Dyisas kenen di yêan. ");
INSERT INTO bpr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na too likò i kdee dad to déé, na dmayen ale di Dwata, manla, “Ta nun kel di blengto satu tugad i Dwata too maltulus. Ta kel Dwata dini du banlén kagalwà i dad ton.” ");
INSERT INTO bpr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Too mbel i santulenla ani gablà ku Dyisas di kabal Dyudiya na di dademe dad banwe glibut déé. ");
INSERT INTO bpr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na ta nun dad to gal tdò Dyan, na lingela gablà di dademe dad nimò Dyisas, na tulenla ku Dyan. Na tlo Dyan i lwe dad tdòan, ");
INSERT INTO bpr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na dekan ale salu di ku Dyisas du fsalekan ku kenen i sanfatanla, ku demen ise. ");
INSERT INTO bpr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na i dad lagi ayé, kanto ale kel di ku Dyisas, manla di kenen, “Dek Dyan Gal Munyag gami salu dini du fye snalekmi ge ku ge i Mgalék Dwata i sanfatanmi ku demen mahal to.” ");
INSERT INTO bpr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na di du ayé, too dee fan-gulê Dyisas dad to nun tduk, na i dademe nun busaw, na balù fa i dad butè du fye mite ale. ");
INSERT INTO bpr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na mdà ayé, tnimelan i dad to dek Dyan, manan, “Samfulê gamu di ku Dyan, na tulenyu kenen i kdee ta teenyu na i ta lingeyu. Mite i dad butè, na gagu i dad kimay, na mgulê i dad to nun fdas mumuh, na lminge i dad bakong, na mték i dad mati, na i dad to landè, lingela i Fye Tulen. ");
INSERT INTO bpr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na manyu di ku Dyan na ku simto là lwe nawan di kaftoon di do, nun kafye gfunan.” ");
INSERT INTO bpr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na kanto mdà i dad to dek Dyan, talù Dyisas di dad to stifun déé gablà di ku Dyan, manan, “Di munan, di ksaluyu di banwe landè to mnè ditù, dét kayèyu teen? Ise ku yé fanngabalyu i kalon wal i nus. ");
INSERT INTO bpr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na du ise ayé i fanngabalyu, dét i kayèyu teen? Là sa mngabal gamu lagi kalmaweh fye du yé gufanak i dad to kalmaweh fye na i dad to too fye kagkahla, dunan di dad malbang gumnè i dad harì, ise ku di banwe landè to. ");
INSERT INTO bpr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bay dét i kayèyu teen ditù? Satu tugad i Dwata kè? Dunan, satu tugad i Dwata kenen, bay mdatah kenen fa di dademe dad tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dyan i ta fala tulen di sulat ani mdà di Tnalù i Dwata, manan, ‘Dekgu i snaliggu muna di ge na fatlagadan i dalanam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na fadlug Dyisas talù, manan, “Ani tulenta gamu, na di kdee dad to sut di tah tanà, landè gamsngad di kdatah Dyan. Bay ku simto i gagin di Kagot i Dwata balù kel di to too mdanà, mdatah kenen di ku Dyan.” ");
INSERT INTO bpr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na i kdee dad to, balù kel di dad to gal mwè bayad i buhis, kantola linge i man Dyisas, gadèla na too fye mimen di Dwata. Na i dad to ayé, ta fbunyag ale di ku Dyan di munan. ");
INSERT INTO bpr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bay i dad Farisi na i dademe dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, balingla knagol i knayè Dwata di dale na là fbunyag ale di ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na talù Dyisas, manan, “Dét i fye guflingen-gu i dad to di mdu ani? Dét i gusalngadla? ");
INSERT INTO bpr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yé guflingen-gu dale i dademe dad ngà sudeng di fadyan. Là mayè ale magin sagwas, na ani man i dademela di dale, ‘Fmalandag gami di klehew, bay knèan là magin gamu madal. Lingagmi i lingag di mati, bay là mngel gamu.’ ");
INSERT INTO bpr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Salngad gamu di dad ngà là mayè magin ayé. Fandamyu Dyan Gal Munyag. Gal kenen fwasa na là minuman binu, bay yé manyu gablà di kenen bnusaw. ");
INSERT INTO bpr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na do, i dnagit Ngà To, kmaan agu na minum, na yé manyu gablà di do, ‘Neyeyu. Tyan kenen na gal flangal, na yé dademen sakdo i dad sasè to gal mwè bayad i buhis na dad to lmafà i dad uldin Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bay déé gumite i gnadè Dwata di nimò i dad ngàan.” ");
INSERT INTO bpr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na nun satu Farisi mlak ku Dyisas kmaan di safédan, na mdà ayé fusuk Dyisas di gumnèan na ta sudeng du kmaan. ");
INSERT INTO bpr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na lê nun libun too gamsalà mnè di lunsud ayé, na kanton linge na déé gukmaan Dyisas di gumnè i Farisi ayé, salu kenen déé na nun neben too mabtas sabuy fnò fangbun. ");
INSERT INTO bpr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na kanto fusuk di gumnè ayé, fdadong kenen di ku Dyisas, na lkuad di saféd i blìan. Na too kenen mngel, na fatdakan i lwakan di blì Dyisas. Na yé ifun dun wakan, na nalakan i blì Dyisas, klon mkok dun fangbun. ");
INSERT INTO bpr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na i Farisi ta mlak ku Dyisas kmaan, kanton teen i nimò i libun ayé, man i nawan, “Ku i to ani too glut tugad i Dwata, ta sanan gadè moon ldam i libun ani ta magot di kenen, du i libun ani too gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bay talù Dyisas di Farisi ayé, manan, “Simon, nun kayègu man di ge.” Na man i Farisi, “Dét manam, Sér?” ");
INSERT INTO bpr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na man Dyisas, “Nun lwe to muteng di satu to gal futeng. Mdà i satu, yé utengan lime latuh, na yé uteng i satu lime falò. ");
INSERT INTO bpr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lwe ale too landè kibòla mayad i utengla. Na yé duenam man, tadèan lnifet i utengla. Na, di fandamam, mdà di ktabeng i to futeng ayé, simto i too mbong dun nawa, i to bong uteng ku i to tukay uteng?” ");
INSERT INTO bpr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na tmimel Simon, manan, “Yé too kambong nawa kenen dunan i to bong utengan du balù ku bong, ta lnifet i to futeng.” Na tmimel Dyisas, manan, “Glut i manam.” ");
INSERT INTO bpr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na kafnge ayé, meye Dyisas di libun ayé, na manan ku Simon, “Teenam i libun ani? Ta fusuk agu di gumnèam, bay là banlém agu éél du alob i blìgu. Bay i libun ani, ta naloban blìgu i lwakan, na yé ifun dun i wakan. ");
INSERT INTO bpr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na di kfafusukam do gine, là ti nalakam agu gambet i galto nimò, bay i libun ani, mdà di kakelgu dini, là ti tlagan malak i blìgu. ");
INSERT INTO bpr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ge, là nkaham fngalo i ulugu di kdawatam do, bay i libun ani, nkokan fangbun i blìgu. ");
INSERT INTO bpr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yé duenam man, too glut i manta ge ani, balù too dee dad salàan, ta magfasinsya nan, na yé gugmadè dun, ta fiten i bong kakdon. Bay i to là dee salàan balù ta magfasinsya, tukay sa i kakdon.” ");
INSERT INTO bpr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na kafnge ayé, man Dyisas di libun ayé, “Ta fnasinsya nan i dad salàam.” ");
INSERT INTO bpr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bay i dademe dad to kmaan déé, stulen ale, manla, “Simto i lagi ani? Balù i kfasinsya salà, gaganan.” ");
INSERT INTO bpr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na lê talù Dyisas di libun, manan, “Ta galwà ge du mdà di kaftoom di do. Mulê ge nan, na i ktanak nawa mnè di ge.” ");
INSERT INTO bpr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kafnge ayé, mdà Dyisas magu salu di dad sahal syudad na lê man i dad malnak banwe du tulenan i Fye Tulen gablà di Kagot i Dwata. Na magin di kenen i sfalò lwe to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na lê nun magin di dale dad libun ta mgulê di kfusuk i busaw dale na i dad sahal tduk. Yé dagit i satu libun ayé Méri Magdalin, i gufalwà Dyisas fitu busaw. ");
INSERT INTO bpr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na yé lê dagit i satu Dyoana, i yaan i mdatah snalig di gumnè Harì Hérod dnagit Kusa. Na yé dagit i satu Susana, na nun fa dee dademe. I kdee dad libun ayé, tnabengla ale Dyisas fagu di dad knunla. ");
INSERT INTO bpr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na nun dee dad to stifun di saféd Dyisas mdà di dad sahal lunsud, na nun tulenan dale satu fléd, manan, ");
INSERT INTO bpr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nun to salu di dnarun du smabul bnê. Kanton sabul, nun dademe dad bnê gtadè di bà dalan, na glékla, na fti tnukè dad anuk mayeng. ");
INSERT INTO bpr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na nun dademe dad bnê gtadè di tanà gunun dee batu, na kanto tmabò i dad bnê ani, mlal mlanas i tabòan du kafag i tanà. ");
INSERT INTO bpr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na nun dademe dad bnê gtadè di lam bnas nun sual. Salngan tmabò i dad bnê na i bnas ani, bay mlimas di bnas i dad tabò i bnê ani. ");
INSERT INTO bpr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bay nun dademe dad bnê gtadè di gufye i tanà. Too tmabò i dad bnê ani, na too fye ulêan, kel di mlatuh.” Na kafnge Dyisas man ayé, falbongan i talùan, manan, “Ku simto i nun klinge, fye ku flinge kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na smalek i dad to galan tdò ku dét gumtatek i fléd ayé gine. ");
INSERT INTO bpr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na talù Dyisas, manan, “Faglabatgu di gamu i dad gbuni gablà di Kagot i Dwata. Bay di dademe dad to, fagugu di fléd i dad tdògu du fye balù ku meye ale, là mite ale, na balù ku lminge ale, là galmabat ale. ");
INSERT INTO bpr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ani gumtatek i fléd. I bnê, dunan i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I tanà di bà dalan gugsabul i dademe dad bnê, dunan i dademe dad to ta lminge i Tnalù Dwata, bay di là mlo salu Satanas déé na nwèan di nawala du fye landè kibòla ftoo tà ale galwà. ");
INSERT INTO bpr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na i tanà gugsabul i dademe dad bnê gunun dee batu dunan i dademe dad to too lehew dmawat i Tnalù Dwata di kaklingela, bay landè too dalilla. Là mlo ale ftoo du ku ta nkel ale i tilew, knagolla i kaftoola. ");
INSERT INTO bpr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na i tanà gugsabul i dademe dad bnê gbol di dad bnas nun sual, dunan i dademe dad to ta lminge i Tnalù Dwata, bay mlimas i Tnalù Dwata di nawala du mdà di klidù nawala, na i kiballa i knun, na i dademe knayè i ktola. Na mdà ayé, landè ktagah i bengela. ");
INSERT INTO bpr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bay i fye tanà gugsabul i dademe dad bnê, dunan i dad to too gsalig na tluh i nawala, du di kaklingela i Tnalù Dwata, fkahla di nawala, na gamtayud ale du fye nun ulê i nimòla.” ");
INSERT INTO bpr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na lê talù Dyisas, manan, “Landè teenam to ku ntaman i salòan na fnge snukuban been. Na là bunin dun di dungan i katri. Bay yé nimòan, kahan di gumefen du fye magtuyal i kdee dad to fusuk déé. ");
INSERT INTO bpr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na salngad ayé, i kdee dad gbuni di mdu ani, teen kadang di satu du na gadè i kdee là fa gadè di mdu ani, du mti magtuyal i kalbong kdee kadang di satu du. ");
INSERT INTO bpr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yé duenam man, tooyu fkah di nawayu i lingeyu, du ku simto to fkahan di nawan i ta gadèan, lê tananù Dwata i blén di kenen. Bay ku simto là fkahan di nawan i ta gadèan, lê nawì Dwata balù i tukay man nawan ta glabatan.” ");
INSERT INTO bpr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lam Dyisas tamdò, ta kel yêan na dad flanekan du mayè ale samsite kenen, bay là gafdadong ale du too dee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na nun tmulen di ku Dyisas, manan, “Ta déé yêam na dad flanekam di lwà du kayèla ge sansite.” ");
INSERT INTO bpr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na man Dyisas, “I dad to lminge i Tnalù Dwata na fkahla di nawala, yé mgimò yêgu na dad flanekgu.” ");
INSERT INTO bpr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Di satu du, man Dyisas di dad to galan tdò, “Mdà ato mifal i lanaw.” Na yé duenam man, mdà ale smakay aweng. ");
INSERT INTO bpr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na lamla maweng, ta kudang Dyisas. Na ta nkel ale kamgis nus di talà. Ta maglam éél i awengla, na ta fan ale galnab. ");
INSERT INTO bpr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na i dad to gal tdò Dyisas, nukatla kenen, na manla, “E Amu, Amu, ta fan ato mlimas.” Ta mték Dyisas, na nngakan i nus na i dad malbang lwek. Na tadè fanak i nus na ta mtanak i lanaw. ");
INSERT INTO bpr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na manan di dad to galan tdò, “Kan ku là smalig gamu?” Too ale likò na tikeng, na sasalek ale, manla, “Simto i to ani? Balù i nus na i malbang lwek, nngakan, na mimen ale.” ");
INSERT INTO bpr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na fles ale maweng kel di banwe i dad to Gérasin stimbang di Galili. ");
INSERT INTO bpr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na kanto ale dmuung déé, ta tufa Dyisas na gsitongan i satu lagi mdà di lunsud nun dad busawan. Ta bong mlo, là kalmawehan na landè gumnè gufanakan, bay yé galan gufanak di dad ilib gulambang i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na kanton teen Dyisas, mkit kenen na lamfan di blì Dyisas, na falbongan i talùan, manan, “Dyisas, Ngà i Too Mdatah Dwata, dét i kibòam do? Fnigu di ge, nangam agu falnayam.” ");
INSERT INTO bpr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yé duenan man ayé du ta dek Dyisas i busaw lamwà di lagi ayé. Ta dee dulêan fusuk di kenen, na balù ku bnakusla i sigalan na i blìan sangkalì, na balù bnantayla kenen fa, gaganan famtoh dun, na gal nebe i busaw kenen salu di dad banwe landè to mnè ditù. ");
INSERT INTO bpr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na smalek Dyisas, manan, “Dét i dagitam?” Na tmimel kenen, manan, “Salagsà,” du ta too ti dee busaw fusuk di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na too fakdo i dad busaw du fye là batan ale di sol landè gusenan, dunan i gufalmayam Dwata dale. ");
INSERT INTO bpr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na mdadong di dale, nun dee dad sdè mateb di bulul. Na fakdo i dad busaw du fye faloh Dyisas ale fusuk di dad sdè ayé na falohan ale. ");
INSERT INTO bpr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yé duenam man, lamwà i dad busaw di lagi ayé, na fles ale fusuk di dad sdè na mti milah i dad sdè, flasok di bilil, na tatek ale di lanaw, na sdulê ale mlimas. ");
INSERT INTO bpr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na kanto teen i dad to mifat dad sdè i mkel ayé, milah ale salu di lunsud na di dad bulul du tulenla. ");
INSERT INTO bpr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na i dad to gutmulenla ayé, gasil ale gatù du neyela i mkel ayé. Na kanto ale kel di ku Dyisas, teenla i lagi gulamwà i dad busaw, na tadè kenen sudeng di saféd blì Dyisas, na ta kalmaweh, na ta fye fandaman. Na too ale likò. ");
INSERT INTO bpr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na i dad to ta mite i mgimò Dyisas, tulenla gablà di kafalwà Dyisas i dad busaw di lagi ayé. ");
INSERT INTO bpr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na i kdee dad to di banwe i dad Gérasin, fakdo ale ku Dyisas du fye tnagakan i banwela du too sasè klikòla. Na mdà ayé, ta mdà Dyisas smakay di aweng. ");
INSERT INTO bpr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bay i lagi gulamwà i dad busaw fakdo di ku Dyisas du kayèan magin, bay là fagin Dyisas dun. Bay manan di kenen, ");
INSERT INTO bpr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mulê ge na tulenam i kdee dad nimò Dwata di ge.” Na yé duenam man, ta mdà i lagi ayé, na tulenan di kdee dad to di lunsud i dad nimò Dyisas di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na lê samfulê ale Dyisas mifal di lanaw ayé, na kanto ale kel di faltùan, nun dee dad to dmawat kenen, du yé sanfatanla. ");
INSERT INTO bpr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na nun satu ulu di gumnè gal gustifun i dad Dyu, yé dagitan Dyairus. Fdadong kenen di ku Dyisas, na lamfan di saféd blìan, na too fakdo du fye magin Dyisas salu di gumnèan. ");
INSERT INTO bpr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yé duenan fakdo di ku Dyisas du i sen ngàan libun, ta sfalò lwe falin, ta fan mati. Na di kagula salu ditù, fan là gagu Dyisas du mdà di too kasgat i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na nun satu libun magin ta sfalò lwe fali klon sigi maloh i litèan, na ta ftin i filakan di dad mulung, bay landè gamfgulê kenen. ");
INSERT INTO bpr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na fdadong kenen di kagol Dyisas, na nagotan i kilil i saulan, na tadè tlag kaloh i litèan. ");
INSERT INTO bpr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na smalek Dyisas, manan, “Simto magot do?” Bay man i kdee dad to, “Là nagotmi ge.” Na talù Piter di ku Dyisas, manan, “Amu, bong dee dad to gihok di ge du mdà di kasgatla.” ");
INSERT INTO bpr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bay man Dyisas, “Nun magot do. Lyalogu na nun kgagan i ta lamwà di do gine.” ");
INSERT INTO bpr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na i libun ayé, kanton teen na landè kibòan muni dun, ta kankal kenen di klikòan, na lamfan kenen di saféd i blì Dyisas. Di bleng i kdee dad to ayé, tulenan ku dét duenan magot ku Dyisas na gablà di ta kgulêan. ");
INSERT INTO bpr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na man Dyisas di kenen, “Ta mgulê ge du mdà di nun kaftoom di do. Mulê ge, na i ktanak nawa mnè di ge.” ");
INSERT INTO bpr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na di lam Dyisas talù fa, nun satu to kel déé fdu di gumnè Dyairus, dunan i ulu di gumnè gal gustifun i dad Dyu, na manan di ku Dyairus, “E Sér, ta là gumaham i ngàam du ta ftoh. Ta nangam snamuk nan i To Tamdò.” ");
INSERT INTO bpr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bay kanto linge Dyisas i manan ayé, manan di ku Dyairus, “Nang ge likò. Bay lo ge ftoo na mgulê i ngàam ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na kanto ale kel di gumnè Dyairus, landè dademe fagin Dyisas fusuk, senan lo Piter na Dyan na Dyém na i dad tua i ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na i kdee dad to déé, too ale mngel du mlidù i nawala gablà di ngà ayé. Bay man Dyisas, “Nang gamu mngel du i ngà, là matin bay lo kudang.” ");
INSERT INTO bpr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na ta balingla kenen nadoy du gadèla na ta mati i ngà. ");
INSERT INTO bpr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bay nagot Dyisas i sigalan, na manan dun, “E ngà, mték ge.” ");
INSERT INTO bpr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta samfulê di kenen i nawan, na gasil kenen tadag, na dek Dyisas i dad tuan mlé knaan di ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na too tikeng i dad tuan, bay fnang Dyisas ale tmulen gablà di mgimò di ngàla. ");
INSERT INTO bpr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na santifun Dyisas i sfalò lwe to galan dek, na banlén ale glal na kgagan du fye gafalwàla i dad busaw na lêla gafgulê i dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na dekan ale tamdò gablà di Kagot i Dwata na famgulê i dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na manan dale, “Di kaguyu ani, nang gamu mebe balù détan, balù tugad, ku demen kuyut, ku demen bnatu, ku demen filak. Na lo yé nebeyu i klaweh damkat di lawehyu. ");
INSERT INTO bpr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na ku kel gamu di satu lunsud, ku dét gumnè gufusukyu, fanak gamu déé kel di lêyu kdà. ");
INSERT INTO bpr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bay ku là dnawatla gamu di satu lunsud, di kdàyu, kakesyu i kfung di blìyu du yé ilè dun na dale i tmimel i sasè nimòla di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yé duenam man, ta mdà ale magu di dad banwe, na tdòla i Fye Tulen, na fan-gulêla i dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na kanto linge Harì Hérod, dunan i gumdatah di Galili, gablà di kdee mgimò Dyisas, too libug fandaman du man dademe dad to na yé gumdà i kgaganan di ku Dyan Gal Munyag du ta mték kenen kun mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na yé man dademe ta samfulê Ilaydya, satu tugad i Dwata di munan, na man dademe na keng satu di dademe dad tugad i Dwata i ta mték. ");
INSERT INTO bpr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bay man Hérod, “Ise Dyan ani du ta faklanggu i ulu Dyan. Bay simto i to ani kè du too dee lingegu gablà di kenen?” Na too kayè Hérod samsite ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na kanto mulê di ku Dyisas i dad to dekan, tulenla di kenen i kdee mgimòla. Na fnge faginan ale salu di satu lunsud dnagit Bétsayda lo dale. ");
INSERT INTO bpr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bay linge i kdee dad to ku nè gusalu ale Dyisas, na mdà ayé lmalò ale. Dnawat Dyisas ale, na tmulen kenen gablà di Kagot i Dwata, na fan-gulêan i dad to nun tduk. ");
INSERT INTO bpr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Di ta fan kasdaf i du, fdadong di ku Dyisas i sfalò lwe to galan tdò, na manla, “Fye ku dekam ale salu di dad malnak banwe na di dad lunsud du fye mngabal ale knaanla na gumilèla du landè gumwèla dini du landè to mnè dini.” ");
INSERT INTO bpr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na man Dyisas di dale, “Gamu i famkaan dale.” Bay manla, “Nun lo lime batù fan na lwe batù nalaf dini. Mayè ge kè ku mdà gami mayad knaan du fye nun fkaanmi di kdee dad to ani?” ");
INSERT INTO bpr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yé kdee dad lagi déé dad lime libu, na lê nun dad libun na i dad ngà. Bay knèan, man Dyisas di dad to galan tdò, “Fsudengyu i dad to ani, men lime falò di kat lumbuk.” ");
INSERT INTO bpr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na mimen i dad to galan tdò na ta fsudengla i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na ta nwè Dyisas i lime batù fan na i lwe batù nalaf, na lngalà kenen di langit, na fasalamat di Dwata klon falnak dun na blén di dad to galan tdò du fye nalella di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na ta kmaan i kdeela na ta bsol ale. Na ta santifun i dad to gal tdò Dyisas i lukas. Na yé kdeen, sfalò lwe been fnò. ");
INSERT INTO bpr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Di satu du, dmasal Dyisas lon satu, na déé i dad to galan tdò. Na snalekan ale, manan, “Dét man i dademe dad to gablà di do? Simto agu kun?” ");
INSERT INTO bpr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na tmimel ale, manla, “Yé man dademe na ge Dyan Gal Munyag. Na i dademe, manla ge Ilaydya, na i dademe manla ge i satu tugad i Dwata mdà di muna ta mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na lêan ale snalek, manan, “Na gamu? Di fandamyu, simto agu kè?” Na tmimel Piter, manan, “Ge sa Krayst, dunan i Mgalék i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na fnang Dyisas ale tmulen ayé di balù simto dun. ");
INSERT INTO bpr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na man Dyisas, “Là ti fakay ku là dee kaflayam mkel di do, dunan i dnagit Ngà To. Na i dad tua gal mebe i dad to, na i dad ganlal di kafaglut, na dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, knagolla agu na fnatila agu, bay di gatlun du, lê agu mték di fati.” ");
INSERT INTO bpr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na lêan man di kdeela, “Ku nun to mayè magin di do, là fakay ku là lnifetan i kton, na tiangan i krusan di kat du, na too magin di do. ");
INSERT INTO bpr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ku simto kmabas i nawan, baling lanah di kenen. Bay ku simto mati du mdà di kaginan di do, nun nawan landè sen. ");
INSERT INTO bpr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dét i fye gwè i satu to ku gfunan i klamang banwe, bay là gfunan i nawa landè sen? ");
INSERT INTO bpr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ku nun to myà mdà di do na i dad dekgu, do i dnagit Ngà To, lêgu kenen kyà ku ta samfulê agu di kdatahgu na i kdatah Màgu Dwata na i dad kasaligan too mtiu. ");
INSERT INTO bpr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Too ti glut i man-gu di gamu, na nun dademe tadag dini, na silang ale mati ku ta teenla i Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kafnge Dyisas man ayé gine, walu butang mlius, yé klon mebe dale Piter, Dyan, na Dyém du mnagad ale di satu bulul na dmasal. ");
INSERT INTO bpr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na laman dmasal déé, tadè mgilih i bawehan, na samfilà i klawehan di kbukay. ");
INSERT INTO bpr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na tadè nun msut déé lwe to, dunan Mosis na Ilaydya, na stulen ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Lê ale too samfilà. Na yé santulenla i kfati Dyisas, dunan i fanan dnohò di syudad Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na ta kudang ale Piter, Dyém, na Dyan, bay kanto ale mukat, teenla i kneng Dyisas na i dad lwe to tadag di safédan. ");
INSERT INTO bpr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Di fan kdà ale Mosis na Ilaydya tmagak ku Dyisas, man Piter di ku Dyisas, “Amu, too fye du dini gami. Fye ku fdak gami tlu slung, satu di ge, satu di ku Mosis, na satu di ku Ilaydya.” Yé duen Piter man ayé du là gadèan ku dét i fye manan. ");
INSERT INTO bpr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na lam Piter talù, makto kel i labun déé, na lnimunan ale, na yé duenam man too likò ale Piter. ");
INSERT INTO bpr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na nun talù mdà di labun ayé, manan, “Ani Ngàgu, dunan i ta nalékgu. Falningeyu kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na kafngela lminge i talù, teenla ta lo Dyisas i gtagak déé. Na toola fkah di fandamla i teenla na là tayòla tulen dun di du ayé. ");
INSERT INTO bpr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Di tmadol du, kanto ale flasok di bulul ayé, nun dee dad to smitong ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na nun satu lagi tamlo, manan, “E Sér, begam kando i ngàgu. Fye ku là lon satu. ");
INSERT INTO bpr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ku ta gal fnusuk i busaw kenen, tin tadè gkit na fles fakakal na mulak i bàan. Toon fatduk i lawehan, na matukul i ktagakan dun. ");
INSERT INTO bpr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ta beg agu fakdo di dad to galam tdò du fye falwàla i busaw, bay là gaganla dun.” ");
INSERT INTO bpr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na man Dyisas, “E tay gamu dad to là ftoo, too gamu gamsalà. Ta là manam i klogu fanak di safédyu, na toogu fantahà i nawagu di gamu bay knèan, sana là kaftooyu. Nebem dini i ngàam.” ");
INSERT INTO bpr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na kanto mdadong i ngà ayé di ku Dyisas, ta lê nbek i busaw kenen di tanà, na fakakal. Bay nngak Dyisas i busaw, na fan-gulêan i ngà, klon fulê dun di màan. ");
INSERT INTO bpr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na tikeng i kdee dad to du mdà di kaltulus i Dwata. Na yé duenam man, di ktikengla, ta talù Dyisas di dad to galan tdò, manan, ");
INSERT INTO bpr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Too gamu flinge di man-gu ani. Do, i dnagit Ngà To, ta fanla agu blé di kagot i dad to.” ");
INSERT INTO bpr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bay là glabatla gumtatek i manan ayé. Gbuni di dale i kayèan man du fye là glabatla dun. Na likò ale smalek kenen. ");
INSERT INTO bpr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na sbalew i dad to galan tdò. Yé sanbalewla ku simto di dale too mdatah. ");
INSERT INTO bpr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na gadè Dyisas i mnè di fandamla na yé duenam man, ta mwè kenen ngà du ftadagan di safédan. ");
INSERT INTO bpr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Klon man di dale, “Ku simto i dmawat satu ngà gambet ani du mdà di ksasatun di do, ta lêan agu dnawat. Na ku simto dmawat do. ta lêan dnawat i Màgu, dunan ‘i mdek do. Na ku simto di gamu too fdanà i kton, kenen i too fdatah Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na talù Dyan, manan, “Amu, nun teenmi satu lagi, na falwàan i dad busaw fagu di dagitam. Fanmi kenen fnang du là glaman di gito.” ");
INSERT INTO bpr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bay man Dyisas, “Nangyu kenen fnang, du ku simto là mnang gamu, nsenan gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na ta là mlo nan i kbatun Dyisas ditù di langit, na mdà ayé, toon fkah di fandaman i fanan ksalu di syudad Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na funan dek i dad snaligan, na kanto ale kel di satu banwe di Samarya, fan ale fatlagad di kakelan déé. ");
INSERT INTO bpr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bay i dad to déé, là mayè ale dmawat kenen du yé too gusalun di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na ale Dyém na Dyan, kantola gadè ayé, snalekla Dyisas, manla, “Amu, mayè ge kè ku mni gami di Dwata ftatekan i lifoh mdà di langit du fye falmon ale?” ");
INSERT INTO bpr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bay neye Dyisas ale, na nngakan ale. ");
INSERT INTO bpr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na kafnge ayé, ta fles ale Dyisas di satu banwe. ");
INSERT INTO bpr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na lamla magu di dalan, nun lagi talù di ku Dyisas, manan, “Magin agu di ge balù nè gusalum.” ");
INSERT INTO bpr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bay tmimel Dyisas, manan, “I dad balos, nun gumulêla, na i dad anuk mayeng, nun fulalla. Bay do, i dnagit Ngà To, landè gumnègu, balù gumilè, landèan.” ");
INSERT INTO bpr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na nun nlakan satu lagi, manan, “Magin ge do.” Bay tmimel i lagi, manan, “Amu, ku mfakay di ge, funagu beg mulê du lbanggu mà.” ");
INSERT INTO bpr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bay man Dyisas di kenen, “Bayàam i to mati. Yé lambang dun i sawe mati. Bay ge, mdà ge tmulen gablà di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na lê nun satu to talù di ku Dyisas, manan, “Amu, fan agu magin di ge, bay funa agu mulê di gumnèmi du beg agu mbal di dademegu.” ");
INSERT INTO bpr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bay tmimel Dyisas, manan, “Ku fkahta di to dmaru, nè i to kmangél, là gablàan magin di Kagot i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na kafnge ayé, lê man malék Dyisas fitu falò lwe to, na dekan ale muna, men lwe, salu di kdee dad lunsud na dademe dad banwe i fanan gusalu. ");
INSERT INTO bpr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Manan di dale, “Ku fkahta di kaktu i fali, too mabal i kantu, bay kulang i dad to kamtu. Taman, mni gamu di Amuto, dunan i mfun i tanà, du fye nun dademe dekan kamtu. ");
INSERT INTO bpr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mdà gamu nan. Dekta gamu salu di dad labè to, du salngad gamu i dad ngà bilibili gbol di dad tuyun. ");
INSERT INTO bpr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na di kaguyu, nang gamu mebe gumkah filak ku demen kuyut. Na lo yé talumfà nebeyu i lsakyu. Na ku nun to gsitongyu di dalan, nangyu ale nbet stulen. ");
INSERT INTO bpr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na ku nun gumnè gufusukyu, di kfusukyu, ani manyu, ‘Mulà moon i ktanak nawa mnè di gamu.’ ");
INSERT INTO bpr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na ku i to mnè déé mayè dmawat i ktanak nawa, mnè di kenen sa i ktanak nawa. Bay, ku là mayèan dun, samfulê ayé di gamu. ");
INSERT INTO bpr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fanak gamu di gumnè i ta gufusukyu ayé, na ku dét i fkaanla na ku dét i finumla gamu, dnawatyu, du i to talbahò là fakay ku là banlé kenen lubay. Na nang gamu milih di dademe gumnè. ");
INSERT INTO bpr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na di kakelyu di satu lunsud, ku dnawatla gamu, balù dét i fkaanla gamu, knaanyu. ");
INSERT INTO bpr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lamyu déé, fan-gulêyu i dad to nun tduk na manyu dale, ‘Ta too mdadong di gamu i Kagot Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bay ku nun lunsud gutadèyu, na là dnawatla gamu, gatù gamu di dad dalan, na fgadèyu di dad to déé, manyu, ");
INSERT INTO bpr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Balù i kfung di banweyu ani ta damkat di blìmi kakesmi nan du yé ilè na gamu i tmimel i sasè nimòyu di Dwata. Nangyu glifet na ta too mdadong i Kagot Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ani man-gu di gamu. I dad to di dad banwe gambet ayé, too blat i kaflayam Dwata dale di Du Kukuman. Baling fye nawam fa i dad to mdà di banwe Sodom i falnayam Dwata di munan. ");
INSERT INTO bpr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Magakdo gamu, dad to di banwe Korasin na lê man gamu di banwe Bétsayda. Kaflingenta dun, i dad to di dad banwe Tiro na Sidon, ku dale mite i dad tnikeng ta gfite di gamu, ta msal ale na ta sanala fite i ksalla fagu di kalsakla saul sakù na i kbubulla abu i ulula. Bay gamu, là msal gamu. ");
INSERT INTO bpr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Balù ku maflayam dad to mdà di dad banwe Tiro na Sidon di Du Kukum Dwata, bay gamu di Korasin na Bétsayda, midul déé i gamu kaflayam. ");
INSERT INTO bpr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na gamu dad to di banwe Kapernaum, too gamu mayè mbatun, bay knèan fan gamu gtufa salu di lanaw lifoh.” ");
INSERT INTO bpr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na ta lê talù Dyisas di dad to dekan, manan, “Nè i to falminge gamu, lêan agu falninge. Bay nè i to mnang gamu, lêan agu knang. Na nè i to mnang do, lêan knang i Màgu, dunan i mdek do.” ");
INSERT INTO bpr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na ta mdà magu i dad fitu falò lwe to, na nimenla i dad flau Dyisas dale. Na di kulêla, too ale lehew, na manla, “Amu, balù i dad busaw, dekmi ale lamwà fagu di dagitam, na mimen ale.” ");
INSERT INTO bpr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na man Dyisas, “Teen-gu Satanas mtatek salngad i silà mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Flinge gamu. Ta banléta gamu kaltulus du fye balù ku gamlék gamu ulad ku demen sifit, landè gamsasè gamu du ta gfisanyu i kalbong kdee mgimò Satanas, dunan i dmuen gito. ");
INSERT INTO bpr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bay knèan, nang gamu flehew lo mdà di kimen i dad busaw gamu. Bay yé duenyu flehew du ta gsulat i dagityu di libru Dwata ditù di langit.” ");
INSERT INTO bpr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na di du ayé, too lehew Dyisas fagu di Mtiu Tulus, na dmasal kenen, manan, “E Mà, Ge i Amu, dunan i magot i langit na i tanà. Dnayenta ge du ku dét i ta bunim di dad mdatah to too gmadè na di dad to too fulung, yé ta fgadèam di dad to mdanà salngad i dad malnak ngà. Yé duenam mimò ani du ani knayèam.” ");
INSERT INTO bpr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Na ta lê talù Dyisas di dad to, manan, “Ta salig Mà di do i kalbong kdee. Lo yé gmadè i Ngà dunan i Màan. Na lo yé gmadè i Mà dunan i Ngàan na i dad to kayèan gufdilè i Màan.” ");
INSERT INTO bpr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na ta lêan neye i dad to galan tdò, na manan di lo dale, “Gamu dad to ta mite i dad mgimògu, ta too gamu banlé kafye. ");
INSERT INTO bpr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ani man-gu di gamu. Nun dee dad tugad i Dwata di munan na balù i dad harì, too ale mayè mite i dad teenyu, na mayè ale lminge i dad lingeyu, bay landè kibòla.” ");
INSERT INTO bpr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Di satu du, tadag i satu to gal tamdò dad uldin Dwata fagu di ku Mosis du tnilewan Dyisas. Na manan, “E Sér, dét i fye nimògu du fye gfun-gu i nawa landè sen?” ");
INSERT INTO bpr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na tmimel Dyisas, manan, “Dét man i dad uldin Dwata fagu di ku Mosis? Dét i kaglabatam dun?” ");
INSERT INTO bpr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na tmimel i to ayé, manan, “Kanbongyu nawa i Amuyu Dwata mdà di nawayu, na di fandamyu, na di kgisyu, na di kaglabatyu. Na kanbongyu nawa i dademeyu to salngad kalbong nawayu i ktoyu.” ");
INSERT INTO bpr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na man Dyisas, “Too ti glut i timelam. Yé nimòam du fye gfunam nawa landè sen.” ");
INSERT INTO bpr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bay i to ayé mayè fite i katluhan, na snalekan Dyisas, manan, “Simto kè i dademegu dad to gablàgu kanbong nawa?” ");
INSERT INTO bpr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na tmimel Dyisas fagu di fléd, manan, “Nun lagi fdu di Dyérusalém flasok salu ditù di banwe Dyériko, na lnifut kenen i dad to tmaku. Nlusla i dad klawehan, na sanbunalla kenen, na silangla tnagak, ta fan mati. ");
INSERT INTO bpr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na nun ganlal di kafaglut magu déé di dalan, na kanton teen i lagi ayé, niwasan kenen. ");
INSERT INTO bpr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na lê nun to mdà di dad bel Libay, kanto kel di sablà i lagi ayé, teenan kenen na lê man miwas. ");
INSERT INTO bpr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bay nun to mdà di Samarya, na ise kenen Dyu. Lê magu déé di sablà i lagi ayé, na kiten kenen, toon kenen kando. ");
INSERT INTO bpr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Fdadong kenen di lagi ayé, na bnulungan fngalo na binu i dad seeyan klon matang dun. Na fsakayan di dongkin, du neben di gumnè gal gumilè i dad to magu, na déé gumifatan dun. ");
INSERT INTO bpr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na di tmadol du, banlén filak i to mfun i gumnè ayé, na manan dun, ‘Begam nifat do i lagi ani, na ku dét i gatnùam di kifatam kenen, tanlasgu di ge di kasfulêgu dini.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na smalek Dyisas di to ayé gine, manan, “Di fandamam, simto di dad tlu to ani fite i kalbong nawan di to lnifut ani?” ");
INSERT INTO bpr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na tmimel i to gal tamdò dad uldin Dwata, manan, “Yé dunan i to kamdo dun.” Na man Dyisas, “Mdà ge, na ganbetam kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na di kagu ale Dyisas na i dad to galan tdò, kanto ale kel di satu lunsud, nun libun dmawat dale, yé dagitan Marta. ");
INSERT INTO bpr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na nun flanek Marta, yé dagitan Méri, na tadè kenen sudeng di saféd i blì Dyisas na toon falninge i kdee tdòan. ");
INSERT INTO bpr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bay Marta, fan là gadèan i nimòan di kafatlagadan mifat dale Dyisas. Na fdadong kenen di ku Dyisas, manan, “Amu, là msamuk i nawam kè di kitem i flanekgu ani? Tadèan agu bayà fatlagad na logu satu. Fye ku manam dun began agu tnabeng.” ");
INSERT INTO bpr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bay man Dyisas, “Tay ge, Marta. Dee kalnidùam na gamsamuk i nawam. ");
INSERT INTO bpr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yé fye, kaham di nawam i too mabtas nimò. Too ti fye i nimò ta nalék Méri, na landè gamwè dun di kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Di satu du, dmasal Dyisas di satu banwe. Na kafngen dmasal, satu di dad to galan tdò, manan ku Dyisas, “Amu, tdòam gami dmasal gambet i gal nimò Dyan Gal Munyag di dad to tdòan.” ");
INSERT INTO bpr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na man Dyisas, “Ku dmasal gamu, gambet ani manyu, ‘Mà, kayèmi moon ku mangamfù di ge i kdee. Na kayèmi ku ge magot i kdee. ");
INSERT INTO bpr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Blém di gami i gablà knaanmi di kat du. ");
INSERT INTO bpr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fnasinsyam i dad salàmi du fnasinsyami i salà i kdee dad to gamsalà di gami. Na nangam faloh di gami i dad mlimah tilew gamgebe gami di salà.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na lêan man di dale, “Kaflingenta dun, ku nun demem sgalak na gatù ge di gumnèan di tngà butang na manam, ‘E leg, begam agu fandem tukay knaan, ");
INSERT INTO bpr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","du nun demegu sgalak ta kel di gumnègu, na landè beggu fkaan dun.’ ");
INSERT INTO bpr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na i to di lam i gumnèan, keng ani timelan ge, ‘Nangam agu snamuk. Ta magtakab nan i gumnèmi, na ta milè gami. Ta là fakay agu mték fdem ge knaan.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na fadlug Dyisas talù, manan, “Ani i man-gu di gamu, balù ku là mnè di nawan i kamdo ge, bay mdà di sigim kafni, yé duenam man fnegesan i kton mték du fandeman ge. ");
INSERT INTO bpr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yé duenam man, man-gu di gamu, mni gamu di Dwata na banlén gamu. Mngabal gamu, na fite Dwata di gamu i fanngabalyu. Na mbal gamu fusuk na nukàan di gamu i takab. ");
INSERT INTO bpr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na ku simto mni di Dwata, gamdawat kenen. Na ku simto mngabal, fite Dwata di kenen i fanngabalan. Na ku simto mbal fusuk, nukà Dwata dun i takab. ");
INSERT INTO bpr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gamu i dad lagi nun ngà, ku mni i ngàyu nalaf, ise ku yé bléyu dun ulad. ");
INSERT INTO bpr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na ku mni kenen ngà anuk, ise ku yé bléyu dun sifit. ");
INSERT INTO bpr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na balù ku sasè gamu knèan fulung gamu mlé fye di dad ngàyu. Na mdà ayé, midul déé fa kfulung i Màyu di langit kablén i Mtiu Tulus di dad to mni di kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na nun falwà Dyisas busaw di satu to umu. Na kanto lamwà i busaw, ta gtalù i umu, na too tikeng i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bay nun dad to déé, manla, “Yé duenan gmagan falwà i dad busaw du yé mnè di kenen i gumdatah i dad busaw, dunan Bélsébul.” ");
INSERT INTO bpr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na nun dademe déé, toola kenen tnilew du mni ale tnikeng du yé gugmadèla dun na mdà kenen di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bay ta gadè Dyisas i fandamla, na manan dale, “Ku fkahta di satu banwe, ku baling sfati i dad to slame dale, malmo i banwe ayé. Na ku fkahta di satu familya, ku gal ale sfati, baling malbà i familya ayé. ");
INSERT INTO bpr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na Satanas, ku sanfatin i kton, malmo sa i kagotan. Yé duen-gu man ani di gamu du yé manyu di do na yé duen-gu gmagan falwà i dad busaw du yé mnè di do Bélsébul. ");
INSERT INTO bpr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, kaflingenta dun, ku falwàgu i dad busaw fagu di kgagan blé Bélsébul, dét i fakayyu man gablà di kgagan i dad to galyu tdò? Lê man mdà di ku Bélsébul kè i dale kgagan? Na yé duenam man, ta gfitela di gamu na gsalà i manyu du ise ku Bélsébul i gumdà i kgagan-gu. ");
INSERT INTO bpr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bay ta gfite di gamu nan na ta kel i bang Dwata magot dad ton du falwàgu i dad busaw fagu di kaltulus i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ku nun to kamgis mebe tek na bnantayan i gumnèan, landè gamwè i knunan. ");
INSERT INTO bpr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bay ku nun to too kamgis fa di to ani gine, fakayan sanfati kenen, na ku ta gfisanan, gaganan nwè i tekan na i dad knunan du flesan nalel di dad ton. ");
INSERT INTO bpr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mdà ayé, nè i to là msen do, knangan agu. Na nè i là tmabeng do samtifun i dad to, balingan ale sanbalét. ");
INSERT INTO bpr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ku nun busaw lamwà di satu to, ani nimòan, mngabal kenen gufanakan di dad banwe kafag. Bay ku landè teenan, ani manan di kton, ‘Lê agu samfulê di tagnè gumnègu.’ ");
INSERT INTO bpr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na ku ta kel i busaw di to ayé gine, teenan na sawe salngad kenen i gumnè mlaneb na maftifas. ");
INSERT INTO bpr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na yé duenam man, lê mdà i busaw là mlo, na lê nun faginan fitu dad busaw midul fa i ksasèla di kenen. Na sdulê ale fusuk di to ayé na fles ale mnè di kenen. Na yé gukel i to ayé, matnù fa i ksasèan di fa là lamwà i busaw di katbùan.” ");
INSERT INTO bpr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na di lam Dyisas tamdò, nun satu libun déé, tlon Dyisas, manan, “Too banlé Dwata kafye i libun fsut ge na ftutù ge.” ");
INSERT INTO bpr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bay tmimel Dyisas, manan, “Yé banlé kafye i to flinge na mimen di Tnalù i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Baling matnù i dad to stifun di saféd Dyisas na di du ayé, talù kenen, manan, “Too ti sasè i dad to di mdu ani. Gal ale mni tnikeng, bay landè fitegu ani, senan lo satu ilè gambet i mkel di ku Dyona i satu to di munan. ");
INSERT INTO bpr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dyona, mdà di gnagun, mgimò kenen ilè di dad to di banwe Ninibi. Na salngad ayé, do, i Ngà To, mgimò agu ilè di dad to di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Di munan, nun satu harì libun mdà di banwe Siba, na balù mawag i gumdàan, knèan salu kenen ditù di ku Harì Solomon du falningen i gnadè Solomon. Na di Du Kukum Dwata kadang, mték i harì libun ayé, na mgimò ilè di dad to di mdu ani gugmadèyu na gablà gamu falnayam du là gamu msal di katdòta gamu. Na blaam do, mdatah agu sa di ku Harì Solomon. ");
INSERT INTO bpr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na lê man di munan, i dad to di banwe Ninibi, msal ale di katdò Dyona dale. Na di Du Kukum Dwata kadang, lê mték i dad to ayé, na mgimò ilè di dad to di mdu ani gugmadèyu na gablà gamu falnayam du là gamu msal di katdòta gamu. Na blaam do, mdatah agu sa di ku Dyona. ");
INSERT INTO bpr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ku nun to mtam salò, là sa bunin na là snafangan dun been. Bay yé nimòan, kahan di gumefen du fye balù simto i fusuk déé di gumnè, magtuyal kenen. ");
INSERT INTO bpr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I matayu, yé sawe salò di lawehyu. Ku fye i keyeyu, fakayta man na langub lwa i kabal lawehyu. Bay ku sasè i keyeyu, fakayta man na langub kmifuh i kabal lawehyu. ");
INSERT INTO bpr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yé duenam man, too gamu fgeye du keng man nawayu malwa i keyeyu, bay kifuh kadì. ");
INSERT INTO bpr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mdà ayé, ku langub lwa i lawehyu na landè gukmifuhan, baling gamu malwa salngad ku nun salò tmuyal di gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kanto fnge Dyisas talù, nun satu Farisi, nlakan kenen kmaan di safédan. Mdà ayé, fusuk Dyisas déé du kmaan. ");
INSERT INTO bpr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na kanto teen i Farisi là funa malob Dyisas di kakaanan, too kenen tikeng du yé knalam i dad Farisi, gal ale malob di lamla là kmaan. ");
INSERT INTO bpr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na man Dyisas di kenen, “Gamu dad Farisi, salngad gamu i to malob tabù na fligo, yé lon nalob i kililan, bay ditù di lam, sana kagsikan, du too gamu lom na sasè. ");
INSERT INTO bpr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Too kulang i fandamyu. Lo satu Dwata, na kenen mimò i laweh na i nawa. ");
INSERT INTO bpr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bay ani fye nimòyu, banléyu i dad to landè mdà di nawayu ilè na ta mlaneb i lawehyu na lê man i nawayu. ");
INSERT INTO bpr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Magakdo gamu, dad Farisi, du falnayam gamu kadang, du balù ku mlé gamu gasfalò di Dwata mdà di kdee dad kantuyu, balù kel di dad malnak bol uten, knèan ta tnagakyu i katluh na i kakdo di Dwata. Fye moon ku too gamu tluh, na ku too gamu kamdo, na lê gamu fadlug di kabléyu di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Magakdo gamu, dad Farisi, du falnayam gamu kadang, du tooyu nibal i afè i dad to. Ku fusuk gamu di gumnè gal gustifun, yé kayèyu gusudeng di gusudeng gal tagà di dad mdatah to. Na ku salu gamu di fadyan, yé kayèyu ku nafè i dad to gamu. ");
INSERT INTO bpr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Magakdo gamu du falnayam gamu kadang, du balù too fye mite gamu di lwà, too gamu magsik di lam. Salngad gamu di lbang ku glék i dad to du landè ilè na nun lbang déé.” ");
INSERT INTO bpr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na nun déé satu to gal tamdò i dad uldin Dwata, na manan di ku Dyisas, “Sér, toom gami ti fyà di ktalùam ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na lê talù Dyisas, manan, “Gamu i dad to tamdò i dad uldin Dwata fagu di ku Mosis, magakdo gamu du falnayam gamu kadang. Dee flauyu di dad to. Salngad ku febeyu ale blat, bay là tnabengyu ale. ");
INSERT INTO bpr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Magakdo gamu du falnayam gamu kadang. Yé galyu nimò galyu fandak ilè i gulambang i dad tugad Dwata, na blaam yé fmati dale i dad gutambulyu. ");
INSERT INTO bpr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na mdà ayé, ta gfiteyu na nun ksasatu nawayu di nimò i dad gutambulyu du fnatila i dad tugad Dwata, na gamu, galyu fandak ilè i dad lbangla. ");
INSERT INTO bpr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na yé duenam man, mdà di kgadè Dwata, ani manan, ‘Banlégu ale dademe dad tugadgu, na i dademe dad to dekgu. Bay balingla fnati i dademe na falnayamla i dademe.’ ");
INSERT INTO bpr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yé duenam man, falnayam Dwata gamu du gagin gamu di kfafati i kdee dad tugad i Dwata mdà fa di kagatbù i banwe kel di mdu ani, ");
INSERT INTO bpr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mdà di kfati Abél na lê man kel di kfati Sakaraya, dunan i bnanòla di bleng i gudamsù na i gumangamfù di Dwata. Too ti glut i man-gu di gamu ani. Gamu dad to di mdu ani, maflayam gamu du mdà di kfati i dad to ayé. ");
INSERT INTO bpr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Magakdo gamu dad to tamdò i dad uldin Dwata du ta buniyu di dad to i kaglut mdà di Dwata. Là mayè gamu dmawat i kaglut, na ta lêyu fnang i dad to mayè dmawat dun.” ");
INSERT INTO bpr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kanto fan mdà Dyisas, i dad Farisi na i dad to tamdò i dad uldin Dwata, toola dnuen Dyisas na sigi ale smalek, ");
INSERT INTO bpr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","du too ale mayè ku nun gugamkfèla kenen fagu di dad timelan. ");
INSERT INTO bpr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na nun file libu dad to stifun déé du flinge ale di tdò Dyisas, na baling ale sagaslob du mdà di kasgatla. Na funa tambù Dyisas talù di dad to galan tdò, manan, “Fan-geyeyu i dad Farisi du too ale flingu, tà gamu kanfit di kaflingula. Yé guflingen i kaflingula di bulung falnok fan du mlal lamnok. ");
INSERT INTO bpr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","I kdee gbuni di mdu ani, teen di satu du, na i kdee là gadè di mdu ani, gadè kadang di satu du. ");
INSERT INTO bpr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nè i manyu di gukmifuhan, linge kadang di gumalwan, na nè i sansutabyu di snifil magtakab, linge kadang ditù di lwà. ");
INSERT INTO bpr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Dad flanek, ani man-gu di gamu, nang gamu likò di dad to, du lo yé gaganla fnati i lawehyu, bay kafnge ayé, landè gdè gaganla nimò di gamu. ");
INSERT INTO bpr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bay tulenta gamu ku simto i gablà kalnikò. Yé kalnikòyu i Dwata, du gaganan gamu fnati, na lê kenen gmagan mbat i layefyu di lanaw lifoh. Yé duenam man, kenen i gablà kalnikòyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Fandamyu kun i dad kalsidaw galla fabli di fadyan. Too tukay i btasla. Bay balù ayé, là glifet Dwata balù satu di dad anuk ayé. ");
INSERT INTO bpr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na gamu dad to, balù i kdee balu wakyu, ta gse Dwata. Mdà ayé, nang gamu likò du di fandam Dwata mas mabtas gamu fa di dad kalsidaw. ");
INSERT INTO bpr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ani man-gu di gamu, ku simto i fgadè dun di kanfe i dad to na do, dunan Ngà To, i mfun kenen, lêgu fgadè di kanfe i dad kasaligan na kenen i nfun-gu. ");
INSERT INTO bpr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bay ku simto i là fgadè di kanfe i dad to na kenen i nfun-gu, là lêgu fgadè di kanfe i dad kasaligan i Dwata na kenen i nfun-gu. ");
INSERT INTO bpr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na nè to talù sasè gablà di Ngà To, fakay fnasinsya i salàan. Bay nè to talù sasè gablà di Mtiu Tulus, là fnasinsya i salàan. ");
INSERT INTO bpr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Na ku nun to mebe gamu di dad gumnè gal gustifun du fukumla gamu di dad ulu na di dad ganlal du mdà di kaftooyu di do, nang gamu mlidù gablà di kibòyu msen i ktoyu ku demen i timelyu di dale, ");
INSERT INTO bpr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","du i Mtiu Tulus i fgadè dun di gamu i fakayyu man di du ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nun satu to glam di dad to stifun déé, manan, “Sér, manam di flanekgu fye ku blén di do i do alel di knun tnagak mà gami.” ");
INSERT INTO bpr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bay tmimel Dyisas, manan, “E leg, landè labetgu samfala di kalelyu i knunyu.” ");
INSERT INTO bpr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na kafnge ayé, man Dyisas di dad to déé, “Too gamu fgeye du fye là lom gamu. I kafye nawa satu to, ise mdà di kalbong knunan.” ");
INSERT INTO bpr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na nun tulenan dale satu fléd, manan, “Nun satu to too bong knunan, na kanto kenen kamtu di tanàan, too ti bong i ulêan. ");
INSERT INTO bpr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na manan di kton, ‘Dét i fye nimògu? Ta landè fakay gusamtifun-gu i ulê i dad felegu ani.’ ");
INSERT INTO bpr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na i to ani, ani manan di kton, ‘Ani i fye nimògu. Lanbàgu i dad labi folgu, na tanlasgu bong, na yé gusamtifun-gu i kdee ulê i dad felegu. ");
INSERT INTO bpr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na fakaygu man di ktogu, “Ta too bong knun santifunam, na là ti mtin kel di file fali. Tadè ge ftud nan, na kmaan, na minum, na flehew.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bay man Dwata di to ani, ‘Book ge. Kadang kifuh, mati ge. Na simto kè i mfun i dad knun ta santifunam? Ta ise ge.’ ");
INSERT INTO bpr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yé kagkah i kdee dad to ku santifunla i dad knunla di tah tanà, bay landè santifunla knun di saféd i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na man Dyisas di dad to galan tdò, “Yé duenam man, nang gamu mlidù gablà di knèyu dini di tah tanà na i knaanyu. Na n ang gamu mlidù gablà di lawehyu na i klaweh lsakyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Di knèyu dini di tah tanà, nun sa too mabtas fa di knaan. Na nun too mabtas fa di klaweh lsakyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fandamyu dad wak. Là sa mlah ale, na là kamtu ale, na landè fol galla gusamtifun i ulê i dad flalah. Bay yé famkaan dale dunan Dwata. Na gamu, too gamu mabtas fa di dad wak. ");
INSERT INTO bpr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Là ti gaganyu tmugad i lawilyu dini di tah tanà, balù lo sudaf klon fagu di kafdamyu i kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ku là gaganyu tmugad i lawilyu dini di tah tanà ani balù di lo sudaf klon, kan ku baling dee gufsaluyu i nawayu gablà di dad kalnidùyu? ");
INSERT INTO bpr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Fandamyu dad bulek tmabò di lam bnas. Là talbahò ale, na là mimò ale falnas fye nun klawehla. Bay ani man-gu di gamu, balù Harì Solomon di kafye knèan, landè klawehan gamsngad i kafye baweh i satu bulek. ");
INSERT INTO bpr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ani kagkah i bulek. Di mdu ani too fye kbelan, bay fayah ta mlanas na fakay ntam. Na ku nifat Dwata dad bulek i landè alì btas, midul déé fa i kablén gamu klaweh. Tay, too kulang i ksaligyu! ");
INSERT INTO bpr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nangyu flidù nawayu di kafngabalyu knaan na i ninumyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Du i dad to là ftoo di Dwata, yé fandamla dale. Bay ta sana gadè i Màyu na yé kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bay ani fye nimòyu. Funayu fnè di nawayu i Kagot Dwata, na blén di gamu i kdee kalnidùyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Na nang gamu likò, balù ku là gamu dee, du i Màyu, lehew kenen fagin gamu di Kagotan. ");
INSERT INTO bpr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yé duenam man, ani fye nimòyu. Fabliyu i dad knunyu na banléyu i dad to landè. Na yé kibòyu samtifun knun landè kalmon, dunan i too bong knun ditù di langit du landè ktin. Na là gfusuk déé i dad to mayè tmaku, na landè kanok gamfalmo dun. ");
INSERT INTO bpr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Du ku nè gusamtifunyu i knunyu, yé lê gal gumnè i fandamyu. ");
INSERT INTO bpr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Fatlagad gamu di kasfulêgu salngad i dad snalig fatan i kasfulê i amula fdu di ksong. Ani falala nimò, smaul ale na mtam ale salò, du fye ku ta kel kenen fakayla gasil nukà i takab di kbalan, du ta sana ale gatlagad. ");
INSERT INTO bpr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Fye nawa i dad snaligan ani du gatlagad ale di kakel i amula. Tulenta gamu i kaglutan, lsakan i saul lufadan, na fsudengan ale du kenen i famkaan dale. ");
INSERT INTO bpr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Too fye nawa i dad snaligan ani di kite i amula dale, du ta sana ale gatlagad balù ku tngà butang ku demen too flafus i kakelan. ");
INSERT INTO bpr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bay tooyu fandam ani. I to mfun i gumnè, ku ta gadèan moon i du i kakel i to tmaku, fakay kenen fatlagad du fye là gafit i to tmaku dun. ");
INSERT INTO bpr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na salngad di gamu, too gamu fala fatlagad, du do, i dnagit Ngà To, yé kakelgu di du i là kfatanyu do.” ");
INSERT INTO bpr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na smalek Piter, manan, “Amu, simto gutmulenam i fléd ani, lo di gami, ku demen di kdee dad to?” ");
INSERT INTO bpr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na tmimel Dyisas, manan, “Simto kè i snalig too fduf na too fulung? Dunan i snalig gufagot i amun i kdee dademe dad snaligan du fye nalelan dale i knaanla ku ta kel i bang. ");
INSERT INTO bpr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Too fye nawa i snalig ku ta kel i amun, na teenan kenen talbahò. ");
INSERT INTO bpr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Too glut i man-gu di gamu, i snalig ani, kenen gufagot i amun i kdee knunan. ");
INSERT INTO bpr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bay kaflingenta dun, ku man i snaligan di kton, ‘Tay kléét i amugu,’ na balingan fatduk i dademen dad snalig, balù lagi ku demen libun, na lo tadè kenen kmaan na minum na flangal, ");
INSERT INTO bpr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ani mkel di kenen. Yé kakel i amun di du i là kfatanan dun, dunan di bang i làan twan. Na ani kibò i amun kenen, toon falnayam du fnèan kenen di saféd i dademe dad to là ftoo. ");
INSERT INTO bpr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ku nè snalig gmadè i knayè i amun, bay knèan là fatlagadan ku demen là nimenan i knayè amun, too falnayam i amun kenen. ");
INSERT INTO bpr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bay nè snalig là gmadè na gamsalà, lê kenen falnayam bay là too blat i flayaman dun. Nè i to banlé dee, lê dee ntuk di kenen. Na nè i to too dee fagot dun, lê too dee i ntuk di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Salu agu dini du nun nebegu salngad lifoh dminè di tah tanà ani. Na ani kayègu moon ku ta sana dminè di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bay nun satu bunyag fan-gu dnawat, dunan i kagugu di kaflayam, na too malbà i fandamgu kel di kaglius i kaflayamgu ani. ");
INSERT INTO bpr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Man nawayu kè na yé duen-gu salu dini di tah tanà du mebe agu ksasatu nawa, bay ise. Yé duen-gu salu dini du mebe agu kasgalel fandam. ");
INSERT INTO bpr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mdà ani, ku lime i kdee dad to di satu familya, masgalel i fandamla. I tlu, là sasatu nawala di lwe, na i lwe, là sasatu nawala di tlu. ");
INSERT INTO bpr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Masgalel fandam i smà na sngà lagi, na masgalel fandam i syê na sngà libun, na lê masgalel fandam i stewe libun.” ");
INSERT INTO bpr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na lê talù Dyisas di kdee dad to stifun déé, manan, “Ku nun teenyu labun fitam fdu di gusdaf i du, ta galyu man, ‘Ta fan mulen,’ na glut ta baling mulen. ");
INSERT INTO bpr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na ku lyaloyu i nus sabnal, manyu, ‘Minit i du,’ na glut sa. ");
INSERT INTO bpr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kuh, gamu dad to flingu! Fulung gamu meye i dad ilè di tanà na di langit, bay là fulung gamu meye i dad ilè di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na kan ku là ganbetyu i fye nimò di mdu ani? ");
INSERT INTO bpr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kaflingenta dun, ku nun dmuen ge na neben ge salu di kasfala, funa ge meye kfagu du fye safye gamu i demem sduen ayé balù di lamyu magu salu ditù. Yé duen-gu man ani du ku là safye gamu, keng blén ge di to magot kasfala, na i to ayé, lêan ge blé di dad sundalu, na i dad sundalu, fablanggùla ge. ");
INSERT INTO bpr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na tulenta ge i kaglutan, silang ge galwà di blanggù ku ta too sikof bayad i salàam ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na di du atù, nun dad to tmulen ku Dyisas gablà di mgimò di dademe dad to mdà di Galili. Ta fafati Pilato ale lamla damsù di Dwata. Na i litèla masbool di litè i dad agaf dsùla. ");
INSERT INTO bpr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na man Dyisas di dale, “Du mati ale bnanò, keng man nawayu na i dad to ayé, too blat fa i dale salà di salà i dademe dad to mdà di Galili. ");
INSERT INTO bpr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bay ise glut fandamyu. Na ku là msal gamu, lê gamu mati gambet dale. ");
INSERT INTO bpr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na di munan, nun sfalò walu mati matkan i too mdatah gumnè di banwe Silom. Fandamyu ale kun. Too ti blat fa i dale salà kè di salà i dademe dad to di Dyérusalém? ");
INSERT INTO bpr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Là sa. Bay ku là msal gamu, lê gamu mati gambet dale.” ");
INSERT INTO bpr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na kafnge ayé, lê tulen Dyisas satu fléd, manan, “Nun satu to, nun kayun fig di tanàan, na kanto mngabal benge, landè teenan. ");
INSERT INTO bpr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na mdà ayé, manan di to gal mifat i dad felen, ‘Ta tlu fali i klogu mngabal benge di kayu ani, na landè teen-gu bengen. Nbekam nan du lon ti falmo i tanà.’ ");
INSERT INTO bpr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bay tmimel i snaligan ani, manan, ‘Sér, fatanta sfali gdè, du funagu lanbud na nkahgu bunu. ");
INSERT INTO bpr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na ku menge glam di sfali ani, too fye, bay ku là, fakayta nbek.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Di satu Du Kaftud i dad Dyu, tamdò Dyisas di satu gumnè galla gustifun. ");
INSERT INTO bpr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na nun déé satu libun ta sfalò walu fali klon bkug mdà di busaw. ");
INSERT INTO bpr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na kanto teen Dyisas i libun ayé, tlon kenen, na manan dun, “Ta mgulê ge nan di tdukam.” ");
INSERT INTO bpr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na nagot Dyisas kenen, na tadè tluh i kagolan, na flesan dnayen i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bay i ganlal di gumnè gal gustifun ayé, kanton teen na ta fan-gulê Dyisas i libun bkug ayé di Du Kaftud, malbut kenen na manan di dad to, “Nun nam du di slinggu i fakay katalbahò, na yé bangyu salu dini ku mayè gamu mgulê, du là fakay ayé di Du Kaftud.” ");
INSERT INTO bpr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bay tmimel i Amuto Dyisas, manan, “Gamu i dad to flingu! Là kè galyu nteh i ikat i dad safìyu na dad dongkiyu, du finumyu ale di Du Kaftud? ");
INSERT INTO bpr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na i libun ani, kenen satu bel Abraham, na ta sfalò walu fali ta klo Satanas mikat kenen. Là fakay kè ku ntehgu i ikatan ayé di Du Kaftud?” ");
INSERT INTO bpr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na kanto man Dyisas ayé, too ti myà i kdee dad to dmuen kenen, bay i dademe dad to flinge, lehew ale gablà di kdee dad fye nimòan. ");
INSERT INTO bpr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na smalek Dyisas, manan, “Dét kè i fye guflingen-gu i Kagot Dwata? ");
INSERT INTO bpr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I Kagotan gambet i bnê too tukay dnagit mustasa fele satu to di tanàan. Tmabò i bnê ani, na mbaling bong kayu fakay gufmulal i dad anuk mayeng.” ");
INSERT INTO bpr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na lê kenen smalek, manan, “Dét kè i guflingen-gu i Kagot Dwata? ");
INSERT INTO bpr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I Kagotan gambet i bulung falnok nwè i libun du bolan di tlu gantang arina di kimòan fan. Na baling too masbool i bulung ani di arina na mdà ayé, too lamnok i fan.” ");
INSERT INTO bpr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na fles Dyisas magu salu di Dyérusalém, na slob kenen tamdò di dad malbang na dad malnak banwe di dalan. ");
INSERT INTO bpr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na nun smalek kenen, manan, “Amu, keng là dee to galwà di salàla?” Na tmimel Dyisas, manan, ");
INSERT INTO bpr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tooyu fdà di nawayu magu fusuk di tukay takab du lo yé dalan salu di nawa landè sen. Na ani man-gu di gamu, nun dee dad to, tilewla fusuk déé, bay là ti gfusuk ale. ");
INSERT INTO bpr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Na ku fkahta di gumnè, ku ta tnakab i to mfun dun, tadè gamu fanak déé di lwà na fakdo du mayè gamu fusuk, manyu, ‘E Amu, begam nukà gami i takab.’ Bay baling tmimel i Amu, na manan, ‘Là dilèta gamu, na là gadègu ku nè gumdàyu.’ ");
INSERT INTO bpr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na ani lêyu talù kadang, ‘Bay, Amu, too gami sgalak di ge du kmaan gami di safédam, na minum gami na ta gal ge tamdò di banwemi.’ ");
INSERT INTO bpr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bay ani lê timel i Amu gamu kadang, ‘Là dilèta gamu, na là gadègu ku nè gumdàyu. Fawag gamu di do, gamu i sasè dad to.’ ");
INSERT INTO bpr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na ditù di gukelyu ayé, too gamu mngel na kminggat i kifanyu mdà di klidùyu, du teenyu ale Abraham na Isaak na Dyékob na i kdee dad tugad i Dwata i ta gfusuk di banwe nagot i Dwata. Bay gamu, tagak gamu ditù di lwà. ");
INSERT INTO bpr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na lê nun dad to mdà di klamang banwe, dunan mdà di gusut i du na lê mdà di gusdafan na mdà di gufdu i sabnal na mdà di gufdu i nus mahin. Na ku ta kel ale déé, sudeng ale du kmaan di bong fista di Kagot i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na di bang ayé, nun dad to gfulé di mdu ani ta mbaling guna, na nun dademe guna di mdu ani, mbaling ale gfulé.” ");
INSERT INTO bpr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na di du ayé, nun dad Farisi salu di ku Dyisas, na manla di kenen, “Tnagakam i banwe ani, na mdà ge salu di dademe dad banwe du mayè Harì Hérod fmati ge.” ");
INSERT INTO bpr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bay man Dyisas, “Mdà gamu salu di ku Hérod, dunan i to gal famgaw. Na tulenyu di kenen na funagu falwà dad busaw na fan-gulêgu i dad to di mdu ani na lê di mdu fayah. Bay lwe ani, ta yé kafngegu nan i dad nimògu. ");
INSERT INTO bpr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na too agu fadlug di mdu ani na fayah na kel lwe ani di kakelgu di Dyérusalém du là fakay fnati i dad tugad Dwata di lwà Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","E, gamu dad to di Dyérusalém i gal fmati dad tugad i Dwata, na mdak batu i dad to dek Dwata salu di gamu. Ta dee dulêgu nan mayè samtifun gamu gambet i anuk mliton ku lanfanan i dad ngàan. Bay là ti mayè gamu. ");
INSERT INTO bpr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bay neyeyu du ta fan bayà Dwata di gamu i banweyu ani, na silangyu agu lê teen ku ta kel i bang i kmanyu dun, ‘Magdayen i To salu dini di dagit i Dwata.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Di satu Du Kaftud, salu Dyisas di gumnè satu Farisi nun glal du kmaan kenen déé. Na too tnanul i dad to kenen. ");
INSERT INTO bpr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na nun satu lagi déé, balak i lawehan. ");
INSERT INTO bpr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na snalek Dyisas i dad Farisi na i dademe gal tamdò i dad uldin Dwata fagu di ku Mosis, manan, “Fakay kè di dad uldin Dwata famgulê di Du Kaftud, ku là?” ");
INSERT INTO bpr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bay tadè ale fanak. Mdà ayé, nagot Dyisas kenen, na fan-gulêan klon mdek dun mdà. ");
INSERT INTO bpr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na snalek Dyisas ale, manan, “Ku nun ngàyu ku demen nun safìyu mtatek di mngalam sol di Du Kaftud, falwàyu kè ku là?” ");
INSERT INTO bpr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bay là gtalù ale. ");
INSERT INTO bpr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na nun dademe dad to kel déé, na nalékla dad fye gusudeng i gal tagà di dad to mdatah. Na mdà déé, nun tulen Dyisas satu fléd, manan, ");
INSERT INTO bpr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ku nun mlak ge di ksong, nangam nalék i fye gusudeng gal tagà di dad mdatah to, du keng nun to kel déé mdatah di ge. ");
INSERT INTO bpr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na ku yé mkel, fdadong di ge i to mlak, na manan, ‘Blém i gusudengam ani di kenen.’ Na baling ge myà du ta baling yé tlas gusudengam i gusudeng i dad to mdanà. ");
INSERT INTO bpr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bay ku nun mlak ge, ani fye nimòam, nalékam i gusudeng i dad to too mdanà du fye i to mlak, fdadong kenen di ge, na manan, ‘E leg, beg ge milih di fye gusudeng.’ Na baling ge too mgafè di kite i kdee dad to nlakan. ");
INSERT INTO bpr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Du nè i to fdatahan i kton, mbaling mdanà, na nè i to fdanàan i kton, mbaling mdatah.” ");
INSERT INTO bpr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na lê talù Dyisas di to mlak kenen, manan, “Ku mimò ge knaan, balù di ltu du ku demen di kifuh, nangam nlak i dademem sgalak, na i dad flanekam, na i dademem saldan bong knun, du ku yé nimòam lêla gbalas i klakam dale. ");
INSERT INTO bpr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bay ku mimò ge knaan, yé nlakam i dad to landè knun, na i dad là galyak i lawehla, na i dad kimay, na i dad butè. ");
INSERT INTO bpr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na ku yé nimòam, too nun kafye mkel di ge mdà di Dwata, du balù ku là gambalas ale, Dwata malas i kafye nimòam di kték i dad to tluh.” ");
INSERT INTO bpr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na nun satu to déé, kanton linge i man Dyisas, manan, “Too nun kafye i to kmaan di bong fista nimò Dwata di langit.” ");
INSERT INTO bpr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na ta lê talù Dyisas, manan, “Nun satu lagi fimò bong knaan, na dee dad to nlakan. ");
INSERT INTO bpr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na kanto kel du i fista, dekan i satu fasakan du fafgadèan di dad to na ta gatlagad i kdee, du fye beg ale salu déé. ");
INSERT INTO bpr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bay yé nimòla, baling ale lmasun. Mdà i tnaninan, manan, ‘Falami agu mayad tanà, na too mabtas ku lnauygu. Yé duenam man, begam agu fnasinsya.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na lê man i satu, ‘Falami agu mayad sfalò batù safì, na fan agu mdà du tilewgu ale daru. Yé duenam man, begam agu fnasinsya.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na lê man i satu, ‘Falami agu mwè yaan, na là beg agu gagin.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na ta lê kel i fasak ani, na tulenan i kdee ani di amun, na too malbut i amun, na lêan dek i fasakan, manan, ‘Sagwê ge mdà salu di dad kalsada na dademe dalan di syudad, na nebem dini i dad to landè knun, na i dad to là gagu, na dad butè, na dad kimay.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na di là mlon, ta lê kel i fasakan, manan, ‘E amu, ta nimen-gu i kdee manam, na ta kel ale, bay nun fa gdè gusudeng.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na lê mdek i amun, manan di fasakan, ‘Lê ge mdà salu di dad dalan di bulul, na toom ale nlak salu dini du fye fnò i gumnègu. ");
INSERT INTO bpr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bay tulenta ge, landè balù satu di dad to munagu nlak gamtilew i bong knaan ta fatlagadgu ani.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nun dee dad to magin ku Dyisas magu, na meye kenen di dale, manan, ");
INSERT INTO bpr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ku nun to mayè magin di do, bay tukay nawan do, na baling yé gubong nawan di màan na yêan, di yaanan, na dad ngàan, di dad flanekan, na balù kel di kton, là fakay kenen mgimò satu to galgu tdò. ");
INSERT INTO bpr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na i to là lmifet knayèan na tmiang i krusan mdà di klalòam do, là fakay kenen mgimò satu to galgu tdò. ");
INSERT INTO bpr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Na kaflingenta dun, ku nun di gamu mayè fdak bong gumnè, yé nimòan, funan fanak na nintungan ku file filak i btasan du fye gadèan ku gablà filakan kel di kafngen dun. ");
INSERT INTO bpr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Du fa dé ku ta fdakan bay là gafngen dun, ta baling kenen nadoy i kdee dad to mite dun. ");
INSERT INTO bpr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na ani manla, ‘Neyeyu i to ani. Tambù kenen fdak gumnè, bay là gafngen dun.’ ");
INSERT INTO bpr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Na ku fkahta di harì fan samfati i satu harì, yé nimòan funan fanak, na fandaman fye gadèan ku gmagan kenen balù ku lo sfalò libu i dad sundalun, na yé kdee sundalu i satu harì lwe falò libu. ");
INSERT INTO bpr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na ku yé man nawan na là gmaganan, mdek kenen to di lam là kel i satu harì du kayèan ku safye ale du fye là gafles i kasfatila ayé. ");
INSERT INTO bpr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na salngad ayé, ku nun di gamu là tnagakan i kdee dademe knabasan, là fakayan mgimò satu to galgu tdò. ");
INSERT INTO bpr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“I kahì too fye, bay ku ta là mahìan, ta landè kibò lê fahì dun. ");
INSERT INTO bpr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ta landè gukmamu dun, balù di tanà ku mgimò bunu. Ta fakay bat nan. Ku simto i nun klinge, fye ku flinge kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na di satu du, i dad to gal mwè bayad i buhis na i dad to gal lmafà i dad uldin Dwata fagu di ku Mosis, stifun ale du falningela i tdò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bay i dad Farisi na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, too ale sungag, na manla, “I to ani, dnawatan i dad to gamsalà, na kmaan kenen di safédla.” ");
INSERT INTO bpr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na yé duenam man, nun tulen Dyisas dale satu fléd, manan, ");
INSERT INTO bpr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ku nun to, nun bilibilin, mlatuh i kdeen, na baling lanah i satu, dét i nimòan? Tnagakan i syem falò syem di gumatebla du fanngabalan i lanah kel di kiten dun. ");
INSERT INTO bpr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na ku ta teenan, too kenen flehew na tiangan mulê. ");
INSERT INTO bpr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na di kakelan di gumnèan, santifunan i dademen sgalak na i dademen saldan, na manan dale, ‘Flehew gamu magin di do, du ta teen-gu i bilibiligu lanah.’ ");
INSERT INTO bpr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na ani man-gu di gamu. Salngad ayé i kalbong klehew i kdee mnè ditù di langit ku nun satu to too gamsalà na nsalan i salàan. Baling tukay klehew gablà di syem falò syem dad to landè duenla msal du landè salàla kun. ");
INSERT INTO bpr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Na ku nun libun, nun sfalò batù filakan too mabtas, na baling lanah i satu, dét i nimòan? Yé nimòan, mtam kenen salò du toon fanngabal, na silangan kah mngabal dun ku ta teenan. ");
INSERT INTO bpr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na ku ta teenan i filakan ani, santifunan i dademen sgalak, na i dademen saldan, na manan dale, ‘Flehew gamu magin di do du ta teen-gu i filakgu lanah.’ ");
INSERT INTO bpr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na ani man-gu di gamu. Salngad ayé i kalbong klehew i dad kasaligan i Dwata ku i satu to too gamsalà nsalan i salàan.” ");
INSERT INTO bpr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na fadlug Dyisas talù, manan, “Nun satu to, na nun lwe ngàan slame lagi. ");
INSERT INTO bpr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na mdà i ngàan twali, manan ku màan, ‘Mà, blém do nan i do alel di knunam.’ Na mdà ayé, ta nalelan i knunan di dad ngàan ayé. ");
INSERT INTO bpr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na di là mlo, santifun i ngàan twali i kdee dad knunan, na mdà kenen salu di satu banwe too mawag, na falmon i filakan fagu di dad nimòan i landè gukmamu dun. ");
INSERT INTO bpr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na kanto mti i kdee dad knunan, na nun mkel too sasè kbitil di kabal i banwe ayé, na too kenen mlimah. ");
INSERT INTO bpr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na yé duenam man, fusuk kenen talbahò di satu to mnè di banwe ayé. Na i to ayé, dekan kenen di gumkahan dad sdèan du tong famkaan dale. ");
INSERT INTO bpr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na mdà di too sè kbitilan, too kenen mayè kmaan moon, balù i dad benge kayu i galan fkaan di dad sdè ayé, bay du landè to famkaan kenen. ");
INSERT INTO bpr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bay du ta faldam kenen, na manan di kton, ‘I kdee dad to gal talbahò ku mà, glukas fa i knaanla, bay do, ta fan agu malnus. ");
INSERT INTO bpr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Fye fa ku ani nimògu. Mdà agu mulê, na man-gu di ku mà, “E mà, ta gamsalà agu di Dwata na lê man di ge. ");
INSERT INTO bpr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta là agu gten ku tlom agu ngàam. Flamam agu di dad to snukéyam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na kafnge ayé, ta mdà kenen mulê. Bay di laman mawag, ta teen i màan na toon kenen kando. Na fabaltikan snitong i ngàan, na lkafan na nalakan. ");
INSERT INTO bpr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na man i ngàan, ‘Mà, ta gamsalà agu di Dwata, na lê man di ge. Ta là agu gten ku tlom agu ngàam.’ ");
INSERT INTO bpr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bay tlo i màan dad fasakan, na manan di dale, ‘Sagwê gamu. Nebeyu dini i too fye saul, na falsakyu kenen. Falsakyu dun tising na talumfà. ");
INSERT INTO bpr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nwèyu i ngà safì ta fabù na tnatêyu. Mimò ato fista, na too ato flehew, ");
INSERT INTO bpr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","du i ngàgu ani, sawe mati kenen bay ani, ta lê man mto. Sawe ta lanah kenen, bay ani, ta lêgu teen.’ Na yé duenam man, too ale flehew. ");
INSERT INTO bpr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na di du ayé, ditù fa i ngàan twege di tanà gutalbahòan. Di kulêan, kanto mdadong di gumnè, ta lingen i lingag, na teenan i dad to madal. ");
INSERT INTO bpr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na tlon i satu fasak du snalekan ku dét i nimòla déé. ");
INSERT INTO bpr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na tmimel i fasak, manan, ‘Ta kel i twalim, na ta ftatê màam i ngà safì ta fabù. Lehew kenen du ta kel i twalim na landè gbunùan.’ ");
INSERT INTO bpr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bay baling falbut i ngàan twege, na là mayèan magin fusuk. Na mdà ayé, ta lamwà i màan na fakdo di kenen. ");
INSERT INTO bpr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bay manan di màan, ‘Fandamam ani. Ta file faligu talbahò dini, na i kdee manam do, slame nimen-gu. Bay là lmenam mlé do balù satu ngà kambing ku tnatêgu du fye nun klehewgu magin di dademegu sgalak. ");
INSERT INTO bpr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bay i ngàam ayé, ta falmon i knunam bayadan i dad libun. Na di kulêan, baling yé i ta ktatêam i ngà safì ta fabù.’ ");
INSERT INTO bpr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lê talù i màan, manan, ‘E tò, fye nawam ge, du klom to mnè dini di safédgu, na i kdee dad knun-gu, slame ge sa mfun dun. ");
INSERT INTO bpr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bay too mabtas ku mimò ato fista na flehew ato du sawe mati i twalim ani na ta lê kenen mto. Sawe lanah kenen, na ta lêgu teen.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na lê nun tulen Dyisas satu fléd di dad to galan tdò, manan, “Nun satu to too bong knunan, na nun snaligan gufagotan dun. Di satu du, lingen na ta baling falmo i snaligan i knunan ayé. ");
INSERT INTO bpr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mdà ayé, fatlon i snaligan, na snalekan kenen, manan, ‘Dét i lingegu ani gablà di ge? Nwèam dini kun i gugsulat gablà di kagotam i knun-gu, du ta là gsaligta ge.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na man i snalig di kton, ‘Dét i kibògu ani nan du i amugu, fanan agu falwà. Là gagan-gu talbahò du ta mlungay agu, na myà agu mni. ");
INSERT INTO bpr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, ta gadègu ku dét i fye nimògu du fye balù ku falwàan agu, knèan nun dee dademegu sgalak fakay fyak do di dad gumnèla.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yé duenam man, tlon i kdee dad to ta muteng di amun. Na kanto kel i satu, snalekan kenen, manan, ‘File i utengam di amugu?’ ");
INSERT INTO bpr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na tmimel i to ayé, manan, ‘Mlatuh lata fngalo.’ Na man i snalig, ‘Ani i gugsulat i utengam ayé. Sudeng ge. Sagwêam tanlas di lo lime falò lata.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na lêan snalek i satu, manan, ‘File utengam ge?’ Tmimel kenen, manan, ‘Mlibu been mseh.’ Na man i snalig, ‘Ani i gugsulat i utengam ayé. Sudeng ge. Sagwêam tanlas di lo walu latuh.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na kanto linge i amun gablà di nimòan ayé, dnayenan i snalig lmimbung ayé di kfulungan meye kfagu i dad nimòan. Du ku fulung mimò kfagu i dad to mnè di kalwa di kebela i dademela to, midul déé kfulung i dad to nfun i banwe. ");
INSERT INTO bpr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ani man-gu di gamu. Gnamityu i knunyu di ktabengyu i dad to du fye nun kamdo gamu, na balù ku ta mti i knunyu, dnawat Dwata gamu di gumnèan landè sen. ");
INSERT INTO bpr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","I to gsalig di tukay, lê kenen gsalig di bong. Na i to là gsalig di tukay, là lêan gsalig di bong. ");
INSERT INTO bpr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mdà ayé, ku là gsalig gamu di kagotyu i knun dini di tah tanà, lê là gsalig gamu magot i too glut knun di tah langit. ");
INSERT INTO bpr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na ku là gsalig gamu magot knun i dademe, là ti blé di gamu i gamu knun. ");
INSERT INTO bpr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Landè kibò fafasak di lwe amu, du magfeges kenen malék ku simto di dale i nutehan nawa na i kanbongan nawa, satu di dale nimenan na satu i knangan. Landè kibòyu fafasak di Dwata na lê man di knun.” ");
INSERT INTO bpr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","I dad Farisi, toola gal knabas i knunla. Na yé duenam man, kantola linge i man Dyisas, nadoyla kenen. ");
INSERT INTO bpr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bay manan di dale, “Gamu i dad to tadè mimò fye di kanfe i dad to, bay gadè Dwata i mnè di nawayu. Nè i too knabas i dad to, yé landè btas di kanfe Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Di munan, lo yé gal tdò dunan i ta gsulat di dad uldin Dwata fagu di ku Mosis, na lê man i sulat i dad muna tugad i Dwata. Bay kanto tambù Dyan Gal Munyag tamdò, ta yé tlas tdò i fye tulen gablà di Kagot i Dwata, na mdà di kaklinge i dad to dun, too ale fgal du fye gfusuk ale. ");
INSERT INTO bpr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mlal mlanas i langit na i tanà, bay balù dét i ktukay i gsulat glam di dad uldin di Tnalù i Dwata, là ti matlasan. ");
INSERT INTO bpr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nè i lagi mkah i yaanan na lê mwè satu libun, ta gamsalà du lnafàan i muna yaanan. Na i lagi mwè libun ta kah i yaanan, lê kenen gamsalà du lnafàan i muna yaan i libun ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Na lê talù Dyisas, manan, “Nun satu datù nun bong knunan gal kalmaweh i too fye baweh na too mabtas. Na kat du too fye kakaanan. ");
INSERT INTO bpr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na déé di takab i labat gufusuk di gumnè i to ayé, nun to, yé dagitan Lasarus. Fnò kenen seey, na yé nimòan gal kenen mni. ");
INSERT INTO bpr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Too kenen mibal kmaan, balù ku lo i dad samel tatek mdà di lamisa i datù. Too sasè kagkahan du balù i dad ayem, gal ale salu di gumni Lasarus du dnilàla dad seeyan. ");
INSERT INTO bpr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na nè nèan, ta mati i to mni ayé, na nebe i dad kasaligan i Dwata i layefan salu ditù di saféd Abraham. Na lê mati i datù, na lbangla i lawehan. ");
INSERT INTO bpr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na i layefan, ditù gugtadèan di banwe i dad mati dnagit Hadis, na too kenen maflayam. Na lngalà kenen, na teenan Abraham di gumawagan, na Lasarus déé di safédan. ");
INSERT INTO bpr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na tlon Abraham, manan, ‘E màgu, begam agu kando, na dekam Lasarus lamnab i tukè knamatan di éél du fye fatdakan di tukè i dilàgu du too sè kaflayamgu di lifoh ani.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bay tmimel Abraham, manan, ‘E tò, fandamam kun i knèam di tah tanà. Too fye i kagkaham atù, bay Lasarus, too kenen maflayam. Bay kanto ani, too maglala Lasarus, bay ge, too ge maflayam. ");
INSERT INTO bpr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na lê nun gambleng gito du fye landè gifal mdà dini salu déé di ge, na landè lê gifal mdà déé salu dini di gami.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na lê talù i to ayé, manan, ‘Ku yé kagkahan, mà, begam dek Lasarus samfulê ditù di gumnèmi, ");
INSERT INTO bpr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","du nun lime flanekgu. Fye ku began ale flau du fye là gsalu ale dini di banwe gumaflayamgu ani.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bay tmimel Abraham, manan, ‘Fakay ale flinge di dad tdò i uldin Dwata fagu di ku Mosis, na di dad tdò i dad tugad i Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bay man i to ayé, ‘Là sa, màgu Abraham, là gablà ayé. Bay ku nun to mték mdà di fati, na yé tmulen dale, msal ale.’ ");
INSERT INTO bpr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bay man Abraham, ‘Ku là flinge ale di dad tdò i uldin Dwata fagu di ku Mosis na di dad tdò i dad tugad i Dwata, là mgebe ale balù ku nun mték mdà di fati.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na talù Dyisas di dad to galan tdò, manan, “Gal nun gamftatek i dad to di salà, bay magakdo i to gumdà i dademen dad to baling gamsalà, du too kenen falnayam. ");
INSERT INTO bpr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kaflingenta dun, di laman là fa gamsalà i satu to mdà di kenen, balù i dad mdanà to, baling fye fa ku ikat di lialan i giling batu na bat kenen di mahin. ");
INSERT INTO bpr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taman, too gamu fgeye. Ku gamsalà i flanekam, nngakam. Na ku msal kenen, fnasinsyam. ");
INSERT INTO bpr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Balù ku fitu dulê di sdu i kagsalàan di ge, na ku fitu dulêan lê msal, fnasinsyam.” ");
INSERT INTO bpr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na lê talù i dad to gal dek Dyisas, manla, “Amu, tananùam i kaftoomi.” ");
INSERT INTO bpr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bay tmimel Dyisas, manan, “Balù ku too tukay i kaftooyu, salngad kalbong i too tukay bnê, gaganyu dek i bong kayu ani na manyu, ‘Magdot ge na milih ge ditù di mahin,’ na mgimò sa i manyu ayé. ");
INSERT INTO bpr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kaflingenta dun, ku nun fasakam dmaru ku demen mifat dad bilibilim, dét i nimòam ku ta kel kenen fdu di gutalbahòan? Nlakam kenen kè sudeng na kmaan? Là. ");
INSERT INTO bpr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bay yé gal kibòyu, dekyu kenen mimò knaan, na fnge fatlagad kenen, klon malel i knaanyu. Na kafngeyu kmaan, yé klon kenen kmaan. ");
INSERT INTO bpr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Fasalamat gamu kè di fasakyu du mdà di kimenan i dad dekyu? Là sa. ");
INSERT INTO bpr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na salngad ayé sa moon i kibòyu, du ku ta ftiyu nimen i kdee dek Dwata gamu, ani fye manyu, ‘Gami i dad fasak too mdanà, na lo yé nimòmi i gami alel.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na ta mdà Dyisas salu di Dyérusalém, na yé dalanan magu di bleng Samarya na Galili. ");
INSERT INTO bpr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na kanto kel di satu tukay banwe, nun sfalò lagi smitong kenen, nun fdasla mumuh. Tadag ale di gumawagan, ");
INSERT INTO bpr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na tamlo ale, manla, “E Dyisas, i Amumi, begam gami kando.” ");
INSERT INTO bpr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na kanton ale teen, manan, “Mdà gamu. Fiteyu i lawehyu di dad ganlal di kafaglut.” Na di dalanla salu ditù, ta mgulê ale, na tadè mlaneb i kulitla. ");
INSERT INTO bpr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na satu di dale, kanton teen na ta mgulê kenen, lê samfulê di ku Dyisas, na toon falbong i talùan dmayen di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tadè kenen lkuad na lamfan di saféd i blì Dyisas na fasalamat. Na i to ayé, ise kenen Dyu, bay mdà kenen di Samarya. ");
INSERT INTO bpr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na smalek Dyisas, manan, “Ise sfalò kè i kdee to ta mgulê? Ta nè sa gumnè i syem? ");
INSERT INTO bpr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lo i to ani kè mdà di mahal banwe i samfulê dmayen di Dwata?” ");
INSERT INTO bpr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na lê man talù Dyisas di to ayé, manan, “Tadag ge na mdà ge. Ta mgulê ge du mdà di kaftoom.” ");
INSERT INTO bpr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Di satu du, smalek i dad Farisi ku kilen kakel i Kagot Dwata. Na tmimel Dyisas, manan, “I kakel Kagot i Dwata, là teento dun. ");
INSERT INTO bpr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na là fakayto man dun, ‘Neyem, ta dini i Kagot Dwata,’ ku demen, ‘E, ta déé i Kagotan,’ du i Kagot Dwata déé di lam nawa i dad to.” ");
INSERT INTO bpr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na kafnge ayé, ta lê talù Dyisas di dad to galan tdò, manan, “Nun du kadang, na too gamu mayè ku teenyu i du kakelgu, dunan i dnagit Ngà To, bay là teenyu dun. ");
INSERT INTO bpr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nun dad to kadang i man dun di gamu, ‘Déé kenen,’ na i dademe, manla, ‘Dini kenen.’ Bay nangyu ale fantoo. ");
INSERT INTO bpr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Du di du ayé, i kakel Ngà To, salngad di silà mkal mdà di gusut i du kel di gusdafan. ");
INSERT INTO bpr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bay yé mabtas ku funagu maflayam na i dad to di bang ani, knagolla agu. ");
INSERT INTO bpr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","I mkel di dad to di bang kasfulê i dnagit Ngà To, salngad di mkel di dad to di du Nowa di munan. ");
INSERT INTO bpr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lo sigi kmaan dad to na minum. Na i dad lagi, mwè ale yaan, na dad libun, nwèla ale yaan kel di kfusuk Nowa di bong aweng. Na kanto kel i bong dunuk, mti ale mlimas. ");
INSERT INTO bpr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na lê salngad di bang Lat. Lo sigi kmaan i dad to na minum. Sbayad ale. Mlah ale na fdak ale gumnè. ");
INSERT INTO bpr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bay kanto kel i du Lat tmagak i banwe Sodom, fulen Dwata lifoh salngad sandawà, na mti ale maglà. ");
INSERT INTO bpr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gambet ayé kadang i kagkah dad to ku ta kel i Ngà To. ");
INSERT INTO bpr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Di du ayé, ku nun to ditù di tah ataf i gumnèan, fye ku ta nang lê tufa mwè i dad knunan. Na i to ditù di tanàan, fye ku nang lê mulê mwè i knunan. ");
INSERT INTO bpr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fandamyu i mkel di yaan Lat, du mbaling kenen kahì di kakangélan meye i banwe ta tnagakla, ");
INSERT INTO bpr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","du nè i to knabasan i kton, baling lanah di kenen i falami nawa. Bay nè i to là knabasan i kton, balingan gdawat i falami nawa. ");
INSERT INTO bpr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ani man-gu di gamu, di kifuh ayé, nun lwe to sdalol milè. Nwè i satu, na tagak i satu. ");
INSERT INTO bpr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nun lwe libun gmiling. Nwè i satu, na tagak i satu. ");
INSERT INTO bpr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nun lwe lagi ditù di dnaru. Nwè i satu, na tagak i satu.” ");
INSERT INTO bpr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na smalek i dad to galan tdò, manla, “Amu, nè gumgimò ani dé?” Na tmimel Dyisas fagu di fléd, manan, “Ku nè gumlasà i mati, déé gustifun i dad wak du knaanla.” ");
INSERT INTO bpr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na nun tulen Dyisas satu fléd di dad to galan tdò du fgadèan dale na too mabtas ku too dmasal i dad to, na nang ale ftakas. ");
INSERT INTO bpr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Manan, “Di satu banwe nun to mukum landè klikòan di Dwata, na landè afèan di dad to. ");
INSERT INTO bpr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na lê nun déé satu libun balu sigi salu di kenen du fakdo, manan, ‘Nsenam agu di kasfalami i to dmuen do.’ ");
INSERT INTO bpr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Di tnaninan, là mayè i to mukum tmabeng. Bay kanto ta beg mlo, manan di kton, ‘Balù ku là likò agu di Dwata na là kandogu i dad to, ");
INSERT INTO bpr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","knèan fye fa ku tnabenggu i libun balu ani du toon agu snamuk. Ta fan agu tmakas.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na fadlug i Amuto Dyisas talù, manan, “Tooyu fandam i man i to mukum ani balù ku gamsalà kenen. ");
INSERT INTO bpr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na i Dwata, tnabengan sa i dad to ta mgalékan, ku fakdo ale di kenen mdu na kifuh. Na là fgangàan. ");
INSERT INTO bpr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ani man-gu di gamu, toon fabaltik tnabeng i dad ton. Bay ku ta kel agu, dunan i dnagit Ngà To, là dee ftoo di do dini di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na lê nun tulen Dyisas satu fléd di dad to smalig di katluhla na galla nadoy i dademe dad to. ");
INSERT INTO bpr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Manan, “Nun lwe lagi salu di Gumnè Gal Gumangamfù di Dwata du dmasal ale. Satu di dale, Farisi kenen, na i satu gal mwè bayad i buhis. ");
INSERT INTO bpr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na tadag i Farisi kenen na dmasal, manan, ‘Dwata, fasalamat agu di ge du là salngad agu di dademe dad to, gambet i dad to lmimbung, na i dad to kigò, na i dad to lmafà i yaanla, na balù i to ani gal mwè bayad i buhis. ");
INSERT INTO bpr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gal agu fwasa lwe dulê di slinggu, na di kdee gwègu, blégu di ge i gasfalòan.’ ");
INSERT INTO bpr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bay i to gal mwè bayad i buhis, tadag kenen di gumawagan. Kudung kenen, na ntungan i kfen mdà di sasè klidùan, na manan, ‘E Dwata, begam agu kando du too agu gamsalà.’ ");
INSERT INTO bpr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na tulenta gamu ani. I to ani, mulê kenen, ta tluh di mata Dwata, bay i satu, là. Du nè i to fdatahan i kton, baling fdanà Dwata kenen, na nè i to fdanàan i kton, baling fdatah Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lê nun dad to mebe i dad malnak ngàla di ku Dyisas du fye nagotan ale. Bay kanto teen i dad to gal tdò Dyisas, nngakla i dad to mebe i dad ngà ayé. ");
INSERT INTO bpr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bay tlo Dyisas i dad ngà ayé, na manan di dad to tdòan, “Falohyu i dad ngà salu di do, na nangyu ale fnang, du i dad to nun ksalig gambet i dad ngà ani, gagin ale di Kagot Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na too glut i man-gu di gamu. Ku i ksalig i satu to, là salngadan di ksalig i dad ngà ani, là gaginan di Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nun ganlal smalek ku Dyisas, manan, “E Sér, too fye balum. Dét i fye nimògu du fye gfun-gu i nawa landè sen?” ");
INSERT INTO bpr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na tmimel Dyisas, manan, “Dét i duenam man do fye agu? Lo satu i fye, dunan Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ta gadèam i dad uldin Dwata, dunan nang ge lmafà yaan, nang ge manò, nang ge tmaku, nang ge tmulen kéng, na nafèan i màam na i yêam.” ");
INSERT INTO bpr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na man i lagi ayé, “Ta nimen-gu i kdee manam mdà di ktukaygu.” ");
INSERT INTO bpr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na kanto linge Dyisas ayé, manan di kenen, “Lo satu gukulangam. Mdà ge, na fablim i kdee dad knunam, na blém i wèan di dad to landè knun. Na mdà ayé, nun bong knunam ditù di langit. Na kafnge ayé, magin ge di do.” ");
INSERT INTO bpr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bay i to ayé, kanton linge i man Dyisas, ta too mlidù kenen du too bong knunan. ");
INSERT INTO bpr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Neye Dyisas kenen, na manan, “Tay klimah i dad to nun bong knun gfusuk di Kagot Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ku mlimah di satu bong lmanaf dnagit kamél fusuk di sol i dalum, too mlimah fa i satu to nun bong knun gfusuk di Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na i dad to lminge ayé, smalek ale, manla, “Ku gambet ayé, simto i fakay galwà?” ");
INSERT INTO bpr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na tmimel Dyisas, manan, “Nè i là gagan nimò i dad to, gagan Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na talù Piter, manan, “Neyem, ta tnagakmi kdee du magin gami di ge.” ");
INSERT INTO bpr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na man Dyisas, “Too glut i man-gu di gamu ani. Nè i to tmagak i gumnèan, ku demen i yaanan, ku demen i dad flanekan, ku demen i dad tuan, ku demen i dad ngàan du mdà di kaginan di Kagot Dwata, ");
INSERT INTO bpr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","matnù fa i gdawatan di du ani, na kadang di fulé du, gamdawat kenen nawa landè sen.” ");
INSERT INTO bpr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na santifun Dyisas i sfalò lwe dad to galan dek, na manan dale, “Too gamu flinge du ta fan ato gatù di Dyérusalém du ditù gugdohò i kdee ta gsulat i dad tugad Dwata gablà di do, dunan i dnagit Ngà To. ");
INSERT INTO bpr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gablé agu di kagot i dad to ise Dyu. Nadoyla agu, fyàla agu, dnulàla agu, nfasla agu, na fnatila agu. ");
INSERT INTO bpr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bay di gatlun du, lê agu mték mdà di fati.” ");
INSERT INTO bpr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na i dad to galan tdò ayé, là glabatla i manan. Gbuni di dale i gumtatekan na là gadèla i kayèan man. ");
INSERT INTO bpr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ta mdadong ale Dyisas di banwe Dyériko, na nun lagi butè sudeng di kilil dalan du mni. ");
INSERT INTO bpr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kanton linge lduk i kdee dad to magu déé, ta smalek, manan, “Dét ani?” ");
INSERT INTO bpr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na tmimel ale, manla, “Dyisas mdà di Nasarét i magu dini.” ");
INSERT INTO bpr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na falbongan i talùan, manan, “E Dyisas, Bel Harì Dabid, begam agu kando.” ");
INSERT INTO bpr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I dad to muna di ku Dyisas, nngakla i butè, du kayèla ku fanak. Bay baling mkit, manan, “Bel Harì Dabid, begam agu kando.” ");
INSERT INTO bpr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na yé duenam man, tadè fanak Dyisas, na fngén i butè. Na kanto kel i butè di safédan, snalek Dyisas kenen, manan, ");
INSERT INTO bpr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Dét i kayèam nimògu di ge?” Na tmimel i butè, manan, “Amu, yé kayègu moon ku lê agu beg mite.” ");
INSERT INTO bpr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na man Dyisas di kenen, “Mite ge nan. Ta mgulê ge mdà di kaftoom.” ");
INSERT INTO bpr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tadè mite kenen, na fles magin ku Dyisas, na toon dnayen i Dwata. Na kanto teen i kdee dad to i kiten, lêla dnayen i Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na ta kel Dyisas di syudad Dyériko. Di laman magu déé, ");
INSERT INTO bpr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nun lagi déé, yé dagitan Sakiyus. Kenen satu ganlal i dad to gal mwè bayad i buhis, na too bong knunan. ");
INSERT INTO bpr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kayèan teen ku simto Dyisas, bay landè kibòan du fukal kenen, na too sgat dad to. ");
INSERT INTO bpr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yé duenam man, fabaltik kenen milah di tukè muna, na mkef di kayu dnagit sikomoro du fye teenan Dyisas, du yé dalan Dyisas magu. ");
INSERT INTO bpr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na kanto kel Dyisas di dungan i kayu ayé, lngalà kenen, na manan dun, “Sakiyus, gasil ge tufa. Là fakay ku là salu agu di gumnèam di mdu ani.” ");
INSERT INTO bpr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Taman, fabaltik Sakiyus tufa, na too kenen lehew dmawat ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bay i kdee dad to, teenla i nimò Dyisas ayé, na sungag ale, manla, “Tlang kenen di gumnè i to too gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bay tadag Sakiyus, na manan ku Dyisas, “E Amu, ani blégu i kagatngà i kdee knun-gu di dad to landè, na ku simto i glimbunggu, fulêgu di kenen fat dulê bkut.” ");
INSERT INTO bpr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na man Dyisas di kenen, “Mdà di mdu ani, ta kel i kagalwà di dad to di gumnè ani, du i to ani satu bel Abraham mdà di kaftoon di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na do, i dnagit Ngà To, yé duen-gu salu dini di tah tanà du fanngabalgu na falwàgu i dad to lanah.” ");
INSERT INTO bpr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lamla falminge ayé, lê fadlug Dyisas tmulen dale satu fléd. Yé duenan tmulen i fléd ani du man nawa i dad to ku ta fan kel i Kagot Dwata du ta mdadong kenen di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Man Dyisas, “Nun mdatah to salu di satu banwe du fbaling kenen harì, na kafngen mgimò harì, na yé klon lê mulê. ");
INSERT INTO bpr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na mdà ayé, di laman là mdà, tlon sfalò fasakan, na banlén ale filak, men mlatuh di kat satu dale. Na manan dale, ‘Fngàyu i filak ani kel di kasfulêgu.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bay i dad to di banwe gumdàan, toola kenen nuteh nawa, na là mayè ale ku mbaling harì. Yé duenam man, mdek ale dademe dad to lmalò du fgadèla na là mayè ale. ");
INSERT INTO bpr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bay knèan, mgimò kenen harì, klon lê mulê. Kanto kel déé, fatlon i dad fasak gumlén i filak du fye gadèan ku file ngà i filak. ");
INSERT INTO bpr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kanto kel i satu, manan, ‘Amu, i mlatuh fagotam do, ta mngà mlibu.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na talù i harì, manan, ‘Too fye nimòam. Too ge fye fasak. Du gsalig ge di tukay nimò, yé duenam man fagotta ge sfalò syudad.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na lê kel i satu, manan, ‘Amu, i mlatuh fagotam do, ta mngà lime latuh.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na talù i harì, manan, ‘Fagotta ge lime syudad.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na lê nun kel déé, manan, ‘Amu, ani i mlatuh filak fagotam do. Ta fnungasgu masala du busekgu. ");
INSERT INTO bpr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Likò agu di ge du too ge labè. Galam nwè i ise ge nfun, na kantum i ise ge fele.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na lê talù i harì, manan, ‘Falnayamta ge mdà di dad talùam du too ge sasè fasak. Gadèam na too agu labè, na galgu nwè i ise do nfun, na kantugu i ise do fele. ");
INSERT INTO bpr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na kan ku là fngàam i filakgu di bangku du fye di kulêgu, di kwègu i filak ayé, nun ngàan.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na lê kenen talù di dad to di safédan, manan, ‘Nwèam i filak di fasak ayé na lêam blé di to magot mlibu.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bay talù i dad to ayé, manla, ‘Amu, ta mlibu sa i filakan.’ ");
INSERT INTO bpr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bay tmimel i amula, manan, ‘Tulenta gamu i kaglutan na ku simto gsalig magot i ta blé di kenen, lê tananù i fagot dun. Bay ku simto là gsalig magot i tukay, balù i too tukay déé di kenen, lê nawì. ");
INSERT INTO bpr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na i dad to muteh do nawa, dunan i là mayè ku mgimò agu harì, nebeyu ale dini na fnatiyu ale di kanfegu.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kafnge Dyisas man ayé gine, ta muna kenen fles salu ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na kanto ale mdadong di dad malnak banwe Bétfagi na Bétani di Bulul Olib, dekan muna i lwe to galan tdò, manan, ");
INSERT INTO bpr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Fles gamu di tukay banwe gsen munayu, na ku ta kel gamu ditù, nun teenyu ngà dongki là fa lmen snakay batang déé. Ntehyu na nebeyu dini. ");
INSERT INTO bpr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na ku nun to smalek gamu, na manan, ‘Kan ku ntehyu i ngà dongki ayé?’ ani manyu di kenen, ‘Nun gukmamu i Amu dun.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","I dad to dekan ayé, ta mdà ale, na i kdee teenla too ti salngad di ta falan man dale. ");
INSERT INTO bpr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na lamla mteh dun, snalek i funan ale, manan, “Kan ku ntehyu i ngà dongki ayé?” ");
INSERT INTO bpr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na tmimel ale, manla, “Nun gukmamu i Amu dun.” ");
INSERT INTO bpr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na kafnge ayé, nebela i dongki ayé di ku Dyisas, na yé afidla dun i dademe dad klawehla, na fsakayla Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na laman magu, i dademe dad to, nbella i dademe dad klawehla di bà dalan gumagu Dyisas du mdà di kdayenla kenen. ");
INSERT INTO bpr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na kanto ale mdadong di Dyérusalém di guflasok i dalan fdu di Bulul Olib, i kdee dad to galan tdò, too ale lehew, na falbongla i talùla du dnayenla i Dwata du mdà di kdee tnikeng ta teenla. ");
INSERT INTO bpr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Na manla, “Magdayen i Harì salu dini di dagit i Dwata. Ta nun ktanak nawa febe Dwata mdà di langit. Magdayen i Dwata di toon gumdatah.” ");
INSERT INTO bpr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na nun dademe dad Farisi gbol di dad to, talù ale di ku Dyisas, manla, “Sér, nngakam i dad to galam tdò, fye ku nangla man ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bay tmimel Dyisas, manan, “Ani man-gu di gamu, balù ku fnanggu ale dmayen do, fakay mkit i dad batu ani du dale baling dmayen do.” ");
INSERT INTO bpr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na kanto kenen mdadong di syudad Dyérusalém, di kagadwengan dun, ta mngel kenen, ");
INSERT INTO bpr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","manan, “Mulà moon ku gamu, i dad to di Dyérusalém, ta gadèyu i gamlé ktanak nawa, bay là teenyu dun du gbuni di matayu. ");
INSERT INTO bpr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nun du kel kadang na i dad to dmuen gamu, lnibutla labat i syudad, na i dad sundalula, salnibutla gamu. ");
INSERT INTO bpr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Fnatila gamu di lam i syudadyu, balù kel di dad ngàyu. Na di kdee dad gumnè, landè balù satu batu gtagak di guglakatla du mti malbà, du là dnilèyu ku ani i du kakel Dwata di gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na kafnge ayé, fusuk Dyisas di Bong Gumnè Gumangamfù di Dwata, na ndalan lamwà i dad to fabli déé. ");
INSERT INTO bpr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na manan dale, “Ta gsulat di Tnalù i Dwata, manan, ‘I Gumnègu ani, yé gukmamu dun gal gudmasal,’ bay ta fanbalingyu gumnè i dad to lmimbung.” ");
INSERT INTO bpr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kafnge ayé, tamdò kenen kat du di Bong Gumnè Gumangamfù ayé, bay i dad ganlal di kafaglut i dad Dyu, na dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na i dademe to gal mebe i dad Dyu, kayèla kenen fnati. ");
INSERT INTO bpr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bay landè mgimòla, du i kdee dad to, toola dnawat i dad talù Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Di satu du lam Dyisas tamdò na tmulen gablà di Fye Tulen di Bong Gumnè Gumangamfù di Dwata, i dad ganlal di kafaglut i dad Dyu, na dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na dad tua gal mebe i dad Dyu, salu ale di kenen, manla, ");
INSERT INTO bpr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Tulenam gami ku dét i ktoom mimò i kdee nimòam dini? Simto mlé ge i glal ani?” ");
INSERT INTO bpr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na tmimel kenen, manan, “Lê nun snalekgu di gamu. Tulenyu do kun. ");
INSERT INTO bpr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Gablà di kbunyag Dyan, nè gumdà i glalan kenen, mdà di Dwata di langit, ku demen mdà di dad to di tah tanà?” ");
INSERT INTO bpr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na stulen ale, manla, “Ku yé manto, ‘Mdà di Dwata di langit,’ snalekan gito na manan, ‘Kan ku là fantooyu Dyan?’ ");
INSERT INTO bpr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bay ku yé manto, ‘Mdà di dad to,’ i kdee dad to, balingla gito ndak batu, du man nawala ku Dyan satu tugad i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yé duenam man, tmimel ale, manla, “Là gadèmi ku nè gumdàan.” ");
INSERT INTO bpr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na man Dyisas di dale, “Lê là tulenta gamu ku dét i ktoogu mimò i dad nimògu.” ");
INSERT INTO bpr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na fadlug Dyisas talù, na tulenan satu fléd, manan, “Nun satu lagi mele walad dnagit grép di tanàan. Na kafnge ayé, fagotan i dad felen di dademe dad to du salu kenen di satu banwe kel di too mlo. ");
INSERT INTO bpr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na kanto tagah i bengen ani ta dekan i satu fasakan salu di dad to gufagotan i dad felen, du fye begla kenen banlé. Bay i dad to gufagotan i dad felen, balingla nfas i dekan ani, na fnge dekla kenen mulê, na landè gwèan. ");
INSERT INTO bpr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mdà ayé, lêan man dek satu fasakan, bay lêla kenen nfas, na fyàla, klola mdek dun mulê, na landè gwèan. ");
INSERT INTO bpr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na lê nun dekan, na kanto kel déé, sneeyla kenen, na batla ditù di lwà i tanà gumnè i benge ani. ");
INSERT INTO bpr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na kafnge ayé, smalek i mfun i dad fele, manan di kton, ‘Dét i kibògu ani? Yé fye nimògu dekgu i ngàgu, dunan i toogu kanbong nawa. Keng kenen i nafèla.’ ");
INSERT INTO bpr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bay kantola teen i ngàan ani, stulen ale, manla, ‘Ani ngà i to mfun i dad fele. Fnatito kenen du fye di kfati màan, ta gito gamfun i dad felen.’ ");
INSERT INTO bpr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mdà ayé, ditù gumbatla dun di lwà i tanà gumnè dad grép klola fmati dun. Dét nimò i mfun dad fele di dad to ani? ");
INSERT INTO bpr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yé nimòan, salu kenen ditù di dad to gufagotan i dad felen, na fnatin ale, na tanlasan ale.” Na kanto linge dad to i fléd ayé, glabatla i gumtatekan, na manla, “Talya!” ");
INSERT INTO bpr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bay neye Dyisas ale, manan, “Dét gumtatek i fléd gsulat di Tnalù i Dwata, manan, ‘Nun gumnè slame batu, na i satu batu déé too mabtas, yé baling knang i dad to fdak gumnè, du man nawala ku là mabtasan.’ ");
INSERT INTO bpr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nè to gdauf di batu ani, malmo kenen, na nè i to tankan i batu ani, mlunah kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","I dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, na i dad ganlal di kafaglut i dad Dyu, mngabal ale kfagu kamfè ku Dyisas, du gadèla na dale gugtadè i fléd ayé. Bay likò ale di dad to. ");
INSERT INTO bpr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na i dad ganlal ayé, toola tnanul Dyisas, na nun dad to dekla flingu mimò fye, na snukéyla ale. Yé kayèla ku gakfèla Dyisas fagu di ktimelan du fye bléla kenen di lam falel i gubirnador. ");
INSERT INTO bpr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na yé duenam man, yé man i dad to dekla di ku Dyisas, “E Sér, gadèmi na là tmulen ge kéng, na landè to nungulam, bay yé galam nimò tdòam i kaglutan di dad to gablà di knayè i Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nun snalekmi. Fakay kè di uldin Dwata fagu di ku Mosis ku mlé gami bayad i buhis di ku Sisar, i gumdatah di Roma, ku demen là?” ");
INSERT INTO bpr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bay gadè Dyisas i kaflingula, na manan dale, ");
INSERT INTO bpr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fiteyu do i satu filak i galyu bayad i buhis di banwe Roma. Simto i to teenyu di filak ani, na simto mfun dagit i ta gsulat déé?” ");
INSERT INTO bpr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na tmimel ale, manla, “Ku Sisar.” Na manan dale, “Ku dét i nfun Sisar, bléyu di ku Sisar, na ku dét i nfun Dwata, bléyu di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na là gakfèla kenen fagu di ktimelan déé di kanfe i kdee dad to. Na tadè ale fanak, du too ale tikeng. ");
INSERT INTO bpr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na nun dademe Sadusi salu di ku Dyisas, dunan i dad to gal man landè mték mdà di fati. Na snalekla kenen, manla, ");
INSERT INTO bpr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“E Sér, di munan, smulat Mosis, na yé flaun ku nun lagi mati bay landè ngàla yaanan, là fakay ku là nwè i twalin lagi i libun ayé du fye nun tubad i twegen. ");
INSERT INTO bpr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na di munan kun, nun fitu lagi saflanek. Mwè yaan i twege, na kel di kfatin landè ngàla. ");
INSERT INTO bpr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na kanto mati i twege ayé, yé lê mwè i libun ayé dunan i galwen. ");
INSERT INTO bpr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na kafnge ayé, kanto mati i galwen, ta yé mwè dun i gatlun. Na salngad i fitu lagi saflanek ayé du i kdeela sdulê mwè i libun ayé yaan, na sdulê mati i dad lagi ayé, bay landè ngàla. ");
INSERT INTO bpr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na kafngen, ta lê mati i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ani i snalekmi. Di kték i dad mati, simto i too yaan i libun ayé di fitu lagi saflanek?” ");
INSERT INTO bpr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na tmimel Dyisas, manan, “Mdà i dad to di bang ani, i dad lagi, gal ale mwè yaan, na i dad libun, lêla ale nwè yaan. ");
INSERT INTO bpr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bay i dad to gagin di kték i dad mati, ta là swè ale yaan. ");
INSERT INTO bpr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na ta là mati ale du gambet ale i dad kasaligan i Dwata. Ngà ale i Dwata du mték ale mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na fandamyu i man Mosis di munan di saféd i kayu dminè. Ani gugmadèto dun na gadè Mosis na lê mték i dad mati, du yé katlon Dwata dunan ‘I Dwata fnangamfù Abraham na Isaak na Dyékob.’ ");
INSERT INTO bpr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na yé kayèan man dini, balù ku ta mati ale, sana knèla di fandam Dwata du yé galla katlo dun kenen i Dwata gal fnangamfù i dad to mlawil fa. Na di Dwata, sana klawil i kdee dad to.” ");
INSERT INTO bpr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na nun dademe dad to gal tamdò i uldin Dwata fagu di ku Mosis, manla, “Too fye timelam, Sér.” ");
INSERT INTO bpr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na ta landè to gamlas smalek kenen. ");
INSERT INTO bpr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Bay lê man talù Dyisas, manan, “Mdà i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis, dét i duenla man dun na Krayst, dunan i Mgalék Dwata, i Bel Dabid? ");
INSERT INTO bpr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Du balù Dabid, smulat kenen di libru Salmo, manan, ‘Man Dwata di Amugu, “Sudeng ge gsen di kwanan-gu, dunan i gufdatahta ge ");
INSERT INTO bpr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kel di kafkahgu i dad to muteh ge nawa di dungan i falel blìam.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ku yé katlo Dabid di Mgalék i Dwata, ‘Amu,’ kan ku yé katloyu kenen Bel Dabid?” ");
INSERT INTO bpr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Di sleng i kdee dad to flinge, man Dyisas di dad to galan tdò, ");
INSERT INTO bpr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tooyu fan-geye i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. Bayan ale kalmaweh too fye ku magu ale, na kayèla ku too nafè i dad to ale di fadyan. Na fatanla afè i dad to fagu di kafsudengla dale di gusudeng i dad mdatah to di gumnè gal gustifun, na di dad fista. ");
INSERT INTO bpr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Blaam, ani nimòla. Lnufigla dad balu du fye gwèla dad knunla, na flingu ale fagu di kaftahàla i dasalla. Too maflayam i dad to ayé kadang.” ");
INSERT INTO bpr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na lam Dyisas déé di Bong Gumnè Gal Gumangamfù di Dwata, teenan i dad to bong knun, na nun ftatekla di gal gumkah i filak blé di Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na lê nun teenan satu libun balu landè knunan, na yé ftatekan déé lo beg lwe lad. ");
INSERT INTO bpr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na talù Dyisas, manan, “Too glut i man-gu di gamu ani, balù ku bong blé i dademe dad to, mas bong i blé i balu ani. ");
INSERT INTO bpr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Du yé blé dademe to i lukas i bong knunla. Bay yé blé i libun balu ani ta sen knunan.” ");
INSERT INTO bpr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na nun dad to gal tdò Dyisas déé, santulenla kafye i Bong Gumnè Gumangamfù di Dwata du too fye baweh i dad batu gnamitla di kafdakla dun, na nun déé dademe blé dad to di Dwata. Bay talù Dyisas, manan, ");
INSERT INTO bpr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“I kdee teenyu ani, nun du kel kadang, landè batu gtagak di guglakatan du sdulê malbà i kdeen.” ");
INSERT INTO bpr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na smalek ale, manla, “Sér, kilen kagdohò i manam ayé? Dét ilè gugmadèmi dun na ta fan kel?” ");
INSERT INTO bpr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na tmimel Dyisas, manan, “Too gamu fgeye du fye là mafgaw gamu. Du bong dee dad to kel kadang di fulé du, na tamdò ale fagu di dagitgu, manla, ‘Do sa Krayst dunan i Mgalék Dwata,’ na manla, ‘Ta fan kel nan gusen i banwe ani.’ Bay nangyu ale fantoo. ");
INSERT INTO bpr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na ku lingeyu gablà di dad kasfati na dad samuk, nang gamu likò. Là fakay ku là muna kel i kdee ayé, bay balù ku ta gdohò, ise ku yé i ta gusenan.” ");
INSERT INTO bpr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na fadlug kenen talù, manan, “Sfati i dad sahal to, na lê man dad malbang banwe. ");
INSERT INTO bpr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na mkel i linol na kbitil na dad sasè tduk di dee dad banwe. Na lê nun dad malbang tnikeng too gamlikò mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Bay di laman là gdohò ayé, kanfèla gamu na falnayamla gamu. Nebela gamu di dad ganlal mukum di dad gumnè gal gustifun, na fablanggùla gamu, na lêla gamu ftadag di muna i dad harì, na dademe dad ganlal du mdà di ksasatuyu di do. ");
INSERT INTO bpr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yé kadang i kdalanyu tmulen dale gablà di dad nimò Dwata di gamu. ");
INSERT INTO bpr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bay nang gamu mlidù ku dét fye timelyu dale, ");
INSERT INTO bpr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","du blégu di gamu i fye timel na kfulung du fye i dad to mnang gamu nawa, là gamtimel ale na là gaganla gamu fankéng. ");
INSERT INTO bpr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na balù dad tuayu, na dad flanekyu, na dademeyu, na dademeyu sgalak, nun di dale i mlé gamu di dad ganlal. Na nun di gamu fnatila. ");
INSERT INTO bpr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na i kdee dad to, knangla gamu nawa du mdà di ksasatuyu di do. ");
INSERT INTO bpr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bay balù ku fnatila gamu, landè sa lanah di gamu, balù sbalu wakyu. ");
INSERT INTO bpr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bay too gamu fbagal, du fagu dini galwà gamu. ");
INSERT INTO bpr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Na ku teenyu di syudad Dyérusalém ani, ta salnibut i dad sundalu, gadèyu na ta là mlo nan i kalmon. ");
INSERT INTO bpr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na ku ta teenyu ayé, fye ku milah i kdee dad to mdà di Dyudiya salu di dad bulul, na fye ku lamwà i kdee dad to mnè di syudad, na i dad to mnè di bulul, nang ale salu di syudad. ");
INSERT INTO bpr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Du yé bang Dwata falmayam i dad to kmagol di kenen du dnohòan kdee ta fsulatan. ");
INSERT INTO bpr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Di du ayé, magakdo i dad libun maltien, na dad libun ftutù ngà. Too sasè klimah i dad to di tah tanà, na too falnayam Dwata i dad to Dyu. ");
INSERT INTO bpr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nun dademe dad Dyu, mati ale bnanò, na i dademe kanfè i dademe dad to ale, na nebela di dad sahal banwe. Na i dad to ise Dyu, fnisanla i dad Dyu di Dyérusalém, na nagotla i banwe ayé kel di gusen kfaloh Dwata dale. ");
INSERT INTO bpr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Na nun dad ilè di du na di bulen na di dad blatik. Na dini di tah tanà, too likò na too msamuk nawa i dad to gablà di malbang lwek na i bong luk mahin. ");
INSERT INTO bpr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na tadè bek dad to mdà di sasè klikòla di lamla fatan ku dét mkel di klamang banwe du balù i dad mnè di tah kmawang, gasyat ale di dalanla. ");
INSERT INTO bpr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na di kakel Ngà To, teenla di labun, nun kaltulusan na mneng. ");
INSERT INTO bpr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na ku ta tambù i kagdohò i kdee ilè ani, fan-galyu nawayu na flehew gamu du ta là mlo nan i kagalwàyu.” ");
INSERT INTO bpr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na lê nun tulen Dyisas dale satu fléd, manan, “Neyeyu i kayu fig ani, na i kdee dademe dad kayu. ");
INSERT INTO bpr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ku ta dmoon i kayu, yé gugmadè dun ta fan kel i kafye tanà. ");
INSERT INTO bpr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na gambet ayé, ku ta teenyu mkel i ta falagu tulen di gamu, yé gugmadèyu dun ta mdadong nan i Kagot Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Too glut man-gu di gamu ani. Là sa sdulê mati kdee dad to di bang ani. Silang ale mati ku gdohò i kdee dad tulen-gu ani. ");
INSERT INTO bpr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Matlas i langit na tanà, bay i Tnalùgu, là sa matlasan kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bay too gamu fgeye du fye là fsenyu i nawayu di kakaan, na di kaflangal, na di knèyu dini di tah tanà, du ku yé nimòyu, keng taknal gamu di kakel i du ayé. ");
INSERT INTO bpr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na i kdee ani makto kel di dad to di klamang banwe salngad kabkeh liman. ");
INSERT INTO bpr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yé duenam man, too gamu fgeye, na too gamu dmasal du fye nun kgaganyu di kgaguyu i dad kaflayam ani du fye là myà gamu di ktadagyu di kanfegu, dunan i dnagit Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na kat du, tamdò Dyisas di lam i Bong Gumnè Gal Gumangamfù di Dwata, na kat kifuh lamwà kenen du déé gumilèan di Bulul Olib. ");
INSERT INTO bpr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na kat flafus, i kdee dad to, gal ale salu di Bong Gumnè Gal Gumangamfù di Dwata du falningela i tdòan. ");
INSERT INTO bpr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na di bang ayé, ta mdadong nan i fista dnagit Du Kaglius, na yé gal kakaan dad Dyu i fan landè bulung falnok dun. ");
INSERT INTO bpr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na mdà dad ganlal di kafaglut i dad Dyu, na i dad to gal tamdò i uldin Dwata fagu di ku Mosis, mngabal ale kfagu fmati ku Dyisas di landè to gmadè dun du likò ale di dad to. ");
INSERT INTO bpr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na fusuk Satanas di satu di dad sfalò lwe to gal dek Dyisas, dunan Dyudas Iskariyot. ");
INSERT INTO bpr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na salu kenen di dad ganlal di kafaglut i dad Dyu, na di dad ganlal gal mantay di Bong Gumnè Gal Gumangamfù di Dwata, du stulen di dale gablà di fanan kibò makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Too lehew i dad ganlal ayé, na makang ale mlé filak di ku Dyudas. ");
INSERT INTO bpr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na mayè Dyudas tmabeng dale, na tambù kenen mngabal kfagu mlé ku Dyisas di kagotla di là dee to mite dun. ");
INSERT INTO bpr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kanto tambù i Fista Kakaan i Fan Landè Bulung Falnok Dun, ta yé ktatêla i ngà bilibili du fatlagadla di kaftoh i Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na dek Dyisas ale Piter na Dyan, manan, “Mdà gamu, fatlagadyu i knaanto di Du Kaglius.” ");
INSERT INTO bpr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na smalek ale, manla, “Nè gufatlagadmi dun?” ");
INSERT INTO bpr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na tmimel Dyisas, manan, “Ku salu gamu di syudad, nun gsitongyu lagi mebe namuh fnò éél. Magin gamu di kenen salu di gumnè gufusukan. ");
INSERT INTO bpr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na ku ta kel gamu déé, manyu di to mfun i gumnè, ‘Yé snalek i To gal tamdò, “Nè snifil i fakaymi gukmaan di fista i Du Kaglius magin i dad to galgu tdò?’ ” ");
INSERT INTO bpr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na ani nimò i to ayé kadang. Tdòan gamu satu bong snifil ta gatlagad ditù di tah. Na ditù gufatlagadyu i knaanto.” ");
INSERT INTO bpr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na kafnge ayé, ta mdà ale Piter na Dyan, na kanto ale kel déé, teenla kagdohò i kdee man Dyisas gine, na fatlagadla i knaan di Fista i Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na kanto kel i bang, ta sudeng Dyisas na i dad to galan tdò du kmaan ale. ");
INSERT INTO bpr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na man Dyisas di dale, “Too mdà di nawagu kmaan di safédyu di Fista i Du Kaglius ani di lamgu là falnayam. ");
INSERT INTO bpr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na ani man-gu di gamu, mdà ani ta là tayò agu lê kmaan di Fista i Du Kaglius. Silang agu lê kmaan salngad ani ku ta gdohò i gumtatek i Du Kaglius di Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na lêan nwè i basù nun binu, na fasalamat kenen di Dwata, klon man di dademen, “Nwèyu ani na sansinumyu. ");
INSERT INTO bpr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ani man-gu di gamu, mdà ani, ta là tayò agu lê minum binu. Silang agu lê minum ku ta kel i Kagot Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na mwè kenen fan, na fasalamat di Dwata klon falnak dun, na blén dale, na manan, “Ani i lawehgu blégu du mdà di gamu. Gal gamu kmaan salngad ani du fye gumdàyu gamfaldam do.” ");
INSERT INTO bpr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na lê salngad kibòan i basù nun binu. Kafngela kmaan, manan, “I binu ani ilè i falami kasafnè fagu di litè falohgu du mdà di gamu. ");
INSERT INTO bpr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bay i to fan makal do, ta sudeng kenen di safédgu. ");
INSERT INTO bpr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Do sa i Ngà To, na fnatila agu gambet i man Dwata, bay magakdo i to makal do du too sasè kaflayaman.” ");
INSERT INTO bpr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na tambù ale sasalek ku simto di dale i fan makal kenen. ");
INSERT INTO bpr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na ta sgil i dad to gal tdò Dyisas ku simto di dale too mdatah. ");
INSERT INTO bpr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na man Dyisas di dale, “I dad harì dini di tah tanà, toola lnumì i dad to mdanà di dale, na blaam yé knayèla ku yé katlo i dad to dale i dad fye ganlal gumloh i dad to. ");
INSERT INTO bpr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bay fye ku mahal i nimòyu gamu. Nè i mdatah di gamu, fye ku too kenen fdanà, na nè i nun glal, fye ku fafasak kenen. ");
INSERT INTO bpr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Simto kè i mdatah, i to sudeng na kmaan, ku i to malel i knaan? Yé tagnè mdatah i to sudeng na kmaan. Bay do sa i Amuyu, na do i baling fdanà i ktogu du mdà di ktabenggu gamu. ");
INSERT INTO bpr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gamu sa i tagnè magin do di lamgu gmagu i dad tilew. ");
INSERT INTO bpr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I Màgu, banlén agu glal magot. Na salngad ayé, banléta gamu glal magot, ");
INSERT INTO bpr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","du fye kmaan gamu na minum gamu di safédgu kadang di kagotgu. Na lê gamu sudeng ditù di gusudeng i dad ganlal du nukumyu i dad bel i dad sfalò lwe ngà Israél.” ");
INSERT INTO bpr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na man Dyisas di ku Simon Piter, “E Simon, ta mbal Satanas, kayèan gamu tnilew salngad i to tmaaf fali. ");
INSERT INTO bpr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bay ta sanata ge dnasal, Simon, du fye là mgilih i ksaligam. Na ku ta samfulê ge di do, tan-galam nawa i dad flanekam.” ");
INSERT INTO bpr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bay talù Simon Piter, manan di ku Dyisas, “Amu, ta gatlagad agu magin di ge salu di blanggù na balù kel di fati.” ");
INSERT INTO bpr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bay man Dyisas di kenen, “Ani man-gu di ge, Piter, di laman là kalmeet i anuk, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” ");
INSERT INTO bpr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na kafnge ayé, lê snalek Dyisas ale, manan, “Di kdekta gamu di muna, landè nebeyu, balù gufkah filak, ku demen kuyut, ku demen dademe talumfà. Nun kè gukulangyu?” Na tmimel ale, manla, “Landèan.” ");
INSERT INTO bpr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na manan dale, “Bay ani, ta mahal nan, du ku nun gufkah filakyu, fye ku nebeyu di kaguyu, na lê gamu mebe kuyut. Na ku landè sundangyu fabliyu i saulyu tahà sigal du yé bliyu sundang. ");
INSERT INTO bpr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na gdohò i gsulat di Tnalù Dwata gablà di do, manan, ‘Gagin kenen di dad to too gamsalà.’ Ani man-gu di gamu là fakay ku là gdohò i gsulat ayé gablà di do.” ");
INSERT INTO bpr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na talù i dad to galan tdò, manla, “E Amu, neyem. Ta lwe sundangmi.” Na man Dyisas di dale, “Ta gablà ayé.” ");
INSERT INTO bpr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na mdà Dyisas salu di Bulul Olib salngad i knalaman nimò, na magin i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na kanto ale kel déé, manan dale, “Dmasal gamu du fye là gfisan i tilew gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na tnagakan ale, yé kawag Dyisas di dale gnumah ndak batu, na lkuad kenen du dmasal, manan, ");
INSERT INTO bpr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“E Mà, ku mfakay di ge, begam flius i kaflayam fan kel di do ani. Bay yé mgimò i ge knayè, ise i do.” ");
INSERT INTO bpr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na nun kasaligan mdà di langit msut di kenen, na tan-galan i nawan. ");
INSERT INTO bpr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na mdà di too sè klidùan, too kenen fgal dmasal, na i tuhan salngad litè tamdak di tanà. ");
INSERT INTO bpr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na kanto tadag di kafngen dmasal, ta samfulê kenen di dad to galan tdò, na teenan ale kudang, du too ale mlungay mdà di klidùla. ");
INSERT INTO bpr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na snalek Dyisas ale, manan, “Kan ku kudang gamu? Mték gamu na dmasal gamu du fye là gfisan i tilew gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na laman talù, nun kel dee dad to. Na i satu lagi, yé dagitan Dyudas, satu di dad sfalò lwe, kenen i mebe dale. Fdadong kenen di ku Dyisas du nalakan i bawehan. ");
INSERT INTO bpr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bay snalek Dyisas kenen, manan, “Dyudas, nakalam kè i dnagit Ngà To fagu di alak?” ");
INSERT INTO bpr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na i dad to magin ku Dyisas, kantola teen i fan mkel, manla, “Amu, nun sa sundangmi. Mayè ge kè ku tnibehmi ale?” ");
INSERT INTO bpr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na satu di dale, tnibehan i fasak i ulu dad ganlal di kafaglut i dad Dyu, na masfek i bali klingen gsen di kwananan. ");
INSERT INTO bpr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bay tmimel Dyisas, manan, “Ta tongan ayé.” Na nagotan i klinge i fasak ayé, na fan-gulêan. ");
INSERT INTO bpr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na kafnge ayé, talù Dyisas di dad ganlal di kafaglut i dad Dyu, na i dad to gal mantay di Bong Gumnè Gal Gumangamfù di Dwata, na balù i dad tua gal mebe i dad Dyu, dunan i dad to mngé kenen, manan, “Kan? To tmaku agu kè du mebe gamu sundang na bunal di kakfèyu do? ");
INSERT INTO bpr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kat du déé agu sa di safédyu di Bong Gumnè Gumangamfù di Dwata, na là sa kanfèyu agu. Bay ani bangyu mimò dun du fye gdohò i knayè Satanas, dunan ulu magot i gukmifuhan.” ");
INSERT INTO bpr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na kanfèla Dyisas du nebela kenen salu di gumnè i ulu i dad ganlal di kafaglut i dad Dyu. Na lê lmalò Piter, kibò beg fawag kenen. ");
INSERT INTO bpr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bay i dad to mantay ta dmutung ale lifoh di gutngà i nasel, klola sudeng. Na lê sudeng Piter di safédla. ");
INSERT INTO bpr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na nun satu libun fasak, teenan Piter sudeng déé du magtuyal kenen i dinè lifoh. Na toon kenen neye, na manan, “I to ani, gal magin ku Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bay malew Piter, manan, “E, là dilègu dun.” ");
INSERT INTO bpr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Di là mlo, lê nun to mite ku Piter, na manan, “Ge i satu dademen.” Bay tmimel Piter, manan, “Ise do.” ");
INSERT INTO bpr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na kafnge dad satu oras gdè, lê nun to talù, manan, “Too sa, i to ani gal magin ku Dyisas du mdà kenen di Galili.” ");
INSERT INTO bpr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bay tmimel Piter, manan, “E leg, là gadègu i manam ayé.” Na laman talù, ta kalmeet i anuk. ");
INSERT INTO bpr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na kmangél Dyisas du neyen Piter. Na ta gafaldam Piter i ta fala man Dyisas gine, “Di laman là kalmeet i anuk di mdu ani, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” ");
INSERT INTO bpr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na lamwà Piter, na too kenen mngel du mdà di kalbà nawan. ");
INSERT INTO bpr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na i dad to mantay ku Dyisas, tanbùla kenen nadoy, na nfasla kenen. ");
INSERT INTO bpr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na snafangla i matan, na ku dnafìla kenen, manla, “Tulenam gami kun. Simto dmafì ge?” ");
INSERT INTO bpr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na dee fa dademe manla gamfyà ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na kanto flafus, stifun i dad tua gal mebe i dad Dyu, dunan i dad ganlal di kafaglutla, na i dad to gal tamdò i uldin Dwata fagu di ku Mosis. Na i dad sundalu, nebela Dyisas di kanfe i dad ganlal ayé. ");
INSERT INTO bpr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na manla di ku Dyisas, “Ku ge Krayst, i Mgalék Dwata, tulenam gami.” Na tmimel Dyisas, manan, “Balù ku tulen-gu di gamu, sana là kaftooyu. ");
INSERT INTO bpr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na balù ku snalekta gamu, là tnimelyu agu. ");
INSERT INTO bpr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bay mdà ani, do, i dnagit Ngà To, déé gusudenggu di kwanan i Dwata too maltulus.” ");
INSERT INTO bpr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na smalek ale, manla, “Ngà i Dwata ge kè?” Na tmimel kenen, manan, “Ta manyu sa.” ");
INSERT INTO bpr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na kafnge ayé, lê ale stulen, manla, “Ta landè duento smalek i dademe dad to gablà di salàan, du ta lingeto i manan.” ");
INSERT INTO bpr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na kafnge ayé, i kdee dad ganlal stifun déé, sdulê ale tadag, na nebela Dyisas salu di kanfe Gubirnador Pilato. ");
INSERT INTO bpr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na tanbùla tmifù kenen, manla, “Ta gnumahmi i to ani. Fagasyatan i dadememi Dyu, na manan là fakay mlé bayad buhis di ku Sisar, i ganlal di Roma, na yé manan kenen i Mgalék Dwata mgimò harìmi.” ");
INSERT INTO bpr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mdà ayé, snalek Pilato kenen, manan, “Ge kè Harì i dad Dyu?” Na tmimel Dyisas, manan, “Ta manam sa.” ");
INSERT INTO bpr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na fgadè Pilato di dad ganlal di kafaglut i dad Dyu na kel di dademe dad to, manan, “Landè gadègu salàan ku gumdàgu falmayam dun.” ");
INSERT INTO bpr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bay baling midul kakitla, manla, “Snamukan i kdee dad to di kabal Dyudiya fagu di dad tdòan. Yé gutambùan di Galili, na ta gafat i katdòan dini.” ");
INSERT INTO bpr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na kanto linge Pilato ayé, smalek kenen, manan, “Nè gumdà i to ani kè, mdà di Galili?” ");
INSERT INTO bpr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na kanto gadè na yé gumdàan di Galili, dunan i banwe nagot Harì Hérod, ta feben Dyisas salu ditù di ku Hérod, du lê déé Hérod di Dyérusalém di du ayé. ");
INSERT INTO bpr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na kanto teen Hérod Dyisas, too kenen lehew du ta dee lingen gablà ku Dyisas na ta too mlo nan kayèan sansite. Na yé kayèan ku nun nimò Dyisas tnikeng. ");
INSERT INTO bpr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na too smalek Hérod, bay là tmimel Dyisas, balù ku landè salàan. ");
INSERT INTO bpr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na i dad ganlal di kafaglut i dad Dyu, na dad to gal tamdò i uldin Dwata fagu di ku Mosis, tadag ale na toola tnifù Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na Hérod na dad sundalun, toola kenen fyà, na nadoyla kenen. Falsakla ku Dyisas i saul too fye baweh, klola lê fulê dun gatù di ku Pilato. ");
INSERT INTO bpr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na di du ayé, yé katbù ale Hérod na Pilato sakdo, du tagnè ale suteh nawa di munan. ");
INSERT INTO bpr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na mdà Pilato, santifunan i dad ganlal di kafaglut i dad Dyu, na i dademe dad ganlal, na balù i dad btal to. ");
INSERT INTO bpr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na manan di dale, “Ta nebeyu dini i to ani na manyu fagasyatan i dad to. Bay ta toogu kenen snalek di kanfeyu, na landè sa teen-gu salàan ku gumdàgu falmayam kenen. ");
INSERT INTO bpr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na balù Hérod, landè teenan salàan, du ta lêan man fulê di gito. Salngad i teenyu ani, too landè salà Dyisas ku gumdàgu fafati kenen. ");
INSERT INTO bpr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Taman, logu fafas, klogu falwà kenen.” ");
INSERT INTO bpr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yé duen Pilato man ayé du kat fali di Fista Du Kaglius, galan falwà satu to di blanggù. ");
INSERT INTO bpr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bay salngan mkit i dad to, manla, “Fnati Dyisas ayé, na yé falwàam gami Barabas.” ");
INSERT INTO bpr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","I to manla Barabas ayé, blanggù kenen du sanfatin i dad to magot i banwe ayé, na ta gambanò kenen. ");
INSERT INTO bpr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na too fakdo Pilato di dad to du yé kayèan ku falwàan Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bay too ale mkit, manla, “Fnati kenen! Fnatak di krus!” ");
INSERT INTO bpr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na ta lê talù Pilato di gatlun dulê, manan, “Kan? Dét salàan? Landè teen-gu salàan ku gumdàgu fafati kenen. Yé duenam man, logu faflayam klogu falwà dun.” ");
INSERT INTO bpr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bay too ale mkit du too ale mayè fafatak ku Dyisas di krus, na fagu di kakitla, gfisanla Pilato. ");
INSERT INTO bpr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na mdà ayé, ta nagin Pilato i knayèla. ");
INSERT INTO bpr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta falwàan Barabas, i to blanggù du mdà di kasfatin i dad to magot i banwe ayé, na mdà di kbanòan, du yé fnila. Na blén Dyisas di dale du nimòla i knayèla. ");
INSERT INTO bpr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na kantola nebe Dyisas, nun to gsitongla, yé dagitan Simon, na mdà kenen di banwe Sirini. Salu kenen di syudad, na yé gufdun di bulul. Na kantola gsitong, fnegesla kenen mebe i krus Dyisas, na ftadolla kenen ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na nun dee dad to tmadol ku Dyisas. Nun dad libun, too ale mngel du mdà di kalbà nawala kenen. ");
INSERT INTO bpr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bay kmangél Dyisas, manan, “E dad libun mdà di Dyérusalém, nangyu agu nngel. Yé nngelyu moon i ktoyu na dad ngàyu. ");
INSERT INTO bpr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Du nun du kel kadang na baling man dad to, ‘Fye nawa i dad to là lmen maltien, dunan i dad libun là lmen mngà na tnutù ngà.’ ");
INSERT INTO bpr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na di bang ayé, baling man i dad to di dad malbang bulul, ‘Tankanyu gami.’ Na manla di dad malnak bulul, ‘Lnimunyu gami fye mati gami.’ ");
INSERT INTO bpr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Du ku gaganla mbek i kayu matà, matnù fa kgaganla mbek i dad kayu ta dafuk.” ");
INSERT INTO bpr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na lê nun lwe sasè to, nebela ale ditù du fnatila salngan di kfatila ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na ta kel ale di bulul dnagit Banwe Klakub Ulu, na fnatakla Dyisas di krus gagin dad lwe sasè to ayé, satu gsen di bibengan na satu gsen di kwananan. ");
INSERT INTO bpr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na dnasal Dyisas i dad to fmati kenen, manan, “E Mà, fnasinsyam i salàla, du là glabatla i nimòla.” Na sansalel i dad sundalu i klawehan fagu di kasbunut. ");
INSERT INTO bpr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na nun dee dad to tadag déé du damweng ale, na balù i dad ganlal, nadoyla kenen, manla, “Ta falwàan i dademe dad to. Fye ku lêan falwà i kton ku kenen sa Krayst, i Mgalék Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na lê fdadong déé i dad sundalu, na nadoyla kenen. Na fsafla kenen binu masam, ");
INSERT INTO bpr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na manla, “Ku ge i Harì dad Dyu, falwàam i ktom.” ");
INSERT INTO bpr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na nun sulatla gsen tah i ulun, manan, “Ani i Harì i dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na satu di dad sasè to gagin fnatak di krus, nadoyan Dyisas, manan, “Ise ge kè Mgalék Dwata? Falwàam i ktom na lê man gami.” ");
INSERT INTO bpr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na mdà i satu, nngakan, na manan, “Kan? Landè klikòam di Dwata? Tlu ato slame nukum di fati. ");
INSERT INTO bpr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Na gite i gablà fnati salngad ani du nun salàta. Bay i to ani, landè salàan.” ");
INSERT INTO bpr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na lê kenen talù di ku Dyisas, manan, “Dyisas, begam agu fandam ku ta kel ge di banwe nagotam.” ");
INSERT INTO bpr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na tmimel Dyisas, manan, “Tulenta ge i kaglutan. Di mdu ani, ta mnè ge di safédgu di Paraiso, dunan i fan-gu gusalu.” ");
INSERT INTO bpr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na di kaltu i du, tadè kmifuh i klamang banwe kel di tngà masol i du, ");
INSERT INTO bpr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","du ta là mneng i du. Na i bong kurtina di gutngà i Bong Gumnè Gal Gumangamfù di Dwata, tadè kasê di gutngàan. ");
INSERT INTO bpr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na falbong Dyisas i talùan, manan, “Mà, fagotta ge i nawagu ani.” Na kanton man ayé, ta ftoh i nawan. ");
INSERT INTO bpr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na i ulu i dad sundalu, kanton teen i mgimò ayé, dnayenan i Dwata, manan, “Di kaglutan, i to ani too ti tluh.” ");
INSERT INTO bpr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na i dad to stifun déé na damweng, kantola teen i mgimò ayé, ntungla kfela du mdà di sasè klidùla, na ta mdà ale mulê. ");
INSERT INTO bpr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na i kdee dad to gmadè kenen, kel di dad libun tmadol di kenen mdà di Galili, tadag ale di gumawagan du fye teenla i kdee mkel. ");
INSERT INTO bpr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na nun satu lagi, yé dagitan Dyosip. Too kenen tluh to, na balù ku kenen satu di dad to gal mukum i dad Dyu, ");
INSERT INTO bpr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","là naginan i ayèla fmati ku Dyisas. Yé gumdàan di Arimatiya, satu banwe i dad Dyu, na fatanan i Kagot Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na salu kenen di ku Pilato, na mbal kenen du nwèan i laweh Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na kafnge ayé, ta nwèan i laweh Dyisas mdà di krus, na lnabédan falnas bukay, klon mkah dun di satu ilib fakay gulambang ta fala fnge nakol di gugdak i bulul, na landè lmen lbang déé. ");
INSERT INTO bpr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na i du kfati Dyisas, yé dula fatlagad di Du Kaftud. Na ta fan tambù i Du Kaftud nan, du ta fan sdaf i du. ");
INSERT INTO bpr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na i dad libun ta magin ku Dyisas mdà di Galili, magin ale ku Dyosip, na teenla ilib na balù i kibò Dyosip lambang dun déé. ");
INSERT INTO bpr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na kafnge ayé, ta mulê ale du fatlagadla dad fangbun i fakayla lunà di laweh Dyisas. Bay di du ayé, ftud ale du nimenla i uldin Dwata fagu di ku Mosis gablà di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Di too flafus di du Linggu, ta nwè i dad libun ayé i dad fangbun ta fatlagadla, na mdà ale salu di lbang. ");
INSERT INTO bpr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na kanto ale kel déé, teenla ta mgukà i lbang du i batu sangla dun, ta mlulid. ");
INSERT INTO bpr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bay kanto ale fusuk déé, ta là teenla i laweh Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Libug i fandamla gablà ayé. Na lamla faldam, tadè nun tadag déé di safédla lwe to smaul bukay na samfilà. ");
INSERT INTO bpr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na kantola teen i lwe to ayé, lkuad ale na lamfan mdà di klikòla. Bay man i dad to ayé di dale, “Kan dé ku yé gumngabalyu i to mlawil di gulambang i dad to mati? ");
INSERT INTO bpr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ta là dinin du ta mték. Fandamyu i manan gamu di laman ditù di Galili, du ani manan, ");
INSERT INTO bpr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Do, i dnagit Ngà To, là fakay ku là bléla agu di kagot i dad to too gamsalà, na fnatakla agu di krus, bay di gatlun du, lê agu mték mdà di fati.’ ” ");
INSERT INTO bpr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na yé klo i dad libun ayé gamfaldam i manan. ");
INSERT INTO bpr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na kafnge ayé, ta mulê ale fdu di lbang, na tulenla i kdee teenla di dad sfalò satu to gal tdò Dyisas, na lê man di kdee dademela déé. ");
INSERT INTO bpr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na ani dagit i dad libun tmulen di dad sfalò satu, dunan Méri Magdalin, na Dyoana, na Méri, i yê Dyém, na i dademe magin di dale. ");
INSERT INTO bpr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bay i dad sfalò satu, là ftoo ale di man i dad libun ayé di dale, du di fandamla lo kbook i tulenla. ");
INSERT INTO bpr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bay, Piter, ta tadag kenen du sagwê salu ditù di lbang. Na kanto kel ditù, fkagò kenen, na snanilan, na lo yé teenan tagak déé i dad falnas labéd di laweh Dyisas. Mdà ayé, mulê kenen, na too kenen tikeng gablà di dad mkel. ");
INSERT INTO bpr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na di du ayé, nun lwe to gal tdò Dyisas, salu ale ditù di banwe dnagit Imaus. Keng sfalò satu kilumitru i kawagan mdà di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Di slengla magu, yé santulenla i kdee ta mkel. ");
INSERT INTO bpr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na lamla stulen gablà ayé, fdadong Dyisas di safédla, na fles kenen magin di dale. ");
INSERT INTO bpr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bay balù teenla, là dilèla dun du nun smafang i fandamla. ");
INSERT INTO bpr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na snalekan ale, manan, “Dét i santulenyu gine di lamyu magu?” Na tadè ale ftual tadag di bà dalan, na too ale mlidù. ");
INSERT INTO bpr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na satu di dale, yé dagitan Klifas, talù kenen, manan, “Di kdee dad to mnè di Dyérusalém, lo ge kè i là gmadè i mkel déé falami ani.” ");
INSERT INTO bpr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na smalek Dyisas, manan, “Dét i dad manyu ta mkel?” Na tmimel ale, manla, “Nun Tugad i Dwata, yé dagitan Dyisas, mdà di Nasarét. Too kenen maltulus fagu di dad talùan, na di dad nimòan di kanfe i Dwata, na di kanfe i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bay i dad ganlal di kafaglutto na i dad ganlal di banwe, bléla kenen di dad ganlal du nukumla di fati, na fnatakla kenen di krus. ");
INSERT INTO bpr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yé kayèmi moon ku falwàan ato i dad Dyu mdà di dad to dmuen gito. Bay blaam, ta tlu butangan mati. ");
INSERT INTO bpr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na ani, too gami tikeng di teen i dad libun gal magin di gami. Gine di flafus, mdà ale salu di ilib gulambang ku Dyisas, ");
INSERT INTO bpr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bay là teenla i lawehan. Lê ale mulê na tulenla gami na nun kun teenla dad kasaligan msut di dale, na i dad kasaligan ayé, ta fgadèla di dale na ta mték kun Dyisas. ");
INSERT INTO bpr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na i dadememi lagi, salu ale di lbang, na teenla too ti salngad di man i dad libun ayé, bay là teenla Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na man Dyisas di dale, “Tay gamu. Too kulang i fandamyu, na léét gamu ftoo di gman i dad tugad Dwata di muna du. ");
INSERT INTO bpr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Là fakay ku là falnayam i Mgalék Dwata di laman là magdayen di langit.” ");
INSERT INTO bpr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na tambù kenen di dad sulat Mosis na di dad sulat i dademe dad tugad i Dwata, du faglabatan dale i man di Tnalù i Dwata gablà di kton. ");
INSERT INTO bpr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na kanto ale mdadong di tukay banwe gusalula, ta fan fles Dyisas magu. ");
INSERT INTO bpr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bay klenla kenen, manla, “Dini gumilèam di safédmi, du ta fan kifuh nan. Ta flabi sa ani.” Mdà ayé, fusuk kenen magin di dale. ");
INSERT INTO bpr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na kanto ale sudeng, ta mwè kenen fan na dmasal, klon falnak dun na banlén ale. ");
INSERT INTO bpr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na ta mgukà i fandamla du fye dilèla kenen. Na kafnge ayé, tadè kenen lanah di matala. ");
INSERT INTO bpr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na stulen ale, manla, “Taman du minit nawata laman stulen di gite di bà dalan, na di kafaglabatan gite i Tnalù Dwata.” ");
INSERT INTO bpr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kafnge ayé, tadag i lwe to ayé du lê ale samfulê ditù di Dyérusalém. Na kanto ale kel déé, teenla i dad sfalò satu to gal tdò Dyisas, na lê i dademe dad to stifun déé. ");
INSERT INTO bpr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na i dad to ta stifun déé, toola fbateng i talùla, na manla, “Too sa. Ta mték i Amuto, na ta fiten i lawehan di ku Simon Piter.” ");
INSERT INTO bpr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na i lwe to ayé, tulenla i dad teenla di bà dalan, na i kafdilè Dyisas fagu di kafalnakan i fan. ");
INSERT INTO bpr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na di lamla samtulen ayé, tadè msut Dyisas déé, na manan, “I ktanak nawa mnè di gamu.” ");
INSERT INTO bpr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Taknal ale na likò du man nawala ku yé teenla lmagol. ");
INSERT INTO bpr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bay man Dyisas di dale, “Kan dé ku msamuk i fandamyu? Na kan ku lwe nawayu? ");
INSERT INTO bpr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Neyeyu i lwe falelgu ani na i dad blìgu. Do sa ani. Nagotyu agu, na neyeyu du fye gadèyu na ise agu lmagol. Landè ti ungad na tulan i lmagol kenen, gambet i teenyu di do.” ");
INSERT INTO bpr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Na kanton man ayé, fiten di dale i dad falelan na blìan. ");
INSERT INTO bpr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bay knèan, sawe là ftoo ale du too ale lehew na tngah. Mdà ayé, smalek kenen, manan, “Nun knaanyu dini kè?” ");
INSERT INTO bpr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na banléla kenen tnatê nalaf. ");
INSERT INTO bpr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na kanton nwè, ta knaanan di safédla. ");
INSERT INTO bpr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na kafnge ayé, man Dyisas di dale, “Ani man-gu di gamu di lamgu déé fa di safédyu. Ta fgadègu di gamu na là fakay ku là gdohò i gsulat gablà di do di uldin Dwata fagu di ku Mosis, na di sulat i dad tugad i Dwata, na lê i gsulat di Salmo.” ");
INSERT INTO bpr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na kafnge ayé, nukà Dyisas i fandamla du fye glabatla i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na manan dale, “Ani gsulat di Tnalù i Dwata, manan, ‘Maflayam i Mgalék Dwata na fles mati na lê man mték di gatlun du.’ ");
INSERT INTO bpr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na ta gman di Tnalù i Dwata tamdò gamu di kdee dad banwe fagu di dagitgu. Tdòyu ale msal. Na ku msal ale, fnasinsya Dwata i dad salàla. Na dini di Dyérusalém i funayu gutamdò. ");
INSERT INTO bpr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamu i fakay tmulen ani du gamu sa ta muna mite dun. ");
INSERT INTO bpr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na ta fan-gu dek gadini i ta fala fakang Mà di gamu. Bay funa gamu fanak dini di Dyérusalém, na silang gamu tambù tmulen ku ta gdawatyu i Mtiu Tulus du banlén gamu kgagan.” ");
INSERT INTO bpr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na neben ale lamwà di Dyérusalém. Na kanto ale mdadong di Bétani, ta kayangan i dad sigalan, na banlén ale kafye. ");
INSERT INTO bpr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na di laman mlé dale kafye, ta flesan kdà mbatun di langit. ");
INSERT INTO bpr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dnayenla kenen fagu di kfangamfùla, na kafnge ayé, samfulê ale di Dyérusalém na too ale lehew. ");
INSERT INTO bpr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na gal ale salu di Bong Gumnè Gal Gumangamfù di Dwata, na toola kenen dnayen.");
INSERT INTO bpr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Di kyeh, di fa landè mgimò balù détan, ta sana nun Tnalù. Sagin ale i Dwata, na Dwata kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I Tnalù ayé, sagin ale i Dwata mdà di kagatbùan. ");
INSERT INTO bpr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na fagu di Tnalù ayé, nimò Dwata i kalbong kdee. Landè nimòan balù détan ku là fagun di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kenen gutambul i nawa, na i nawa ayé, dunan i Salò tmuyal di dad to. ");
INSERT INTO bpr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na mneng i Salò ayé di gukmifuhan, na i kifuh, là gfisanan neng i Salò. ");
INSERT INTO bpr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nun satu to dek Dwata dnagit Dyan, ");
INSERT INTO bpr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","du tmulen di dad to gablà di Salò ayé du fye ftoo ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Na ise ku Dyan i Salò, bay lon tmulen gablà di Salò. ");
INSERT INTO bpr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ani sa i too glut Salò salu dini di tah tanà tmuyal di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na ta dini sa i Tnalù di tah tanà di munan, na fagu di kenen nimò Dwata i klamang banwe, bay knèan là dnilè i dad to kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na salu kenen di banwen, bay là dnawat i dademen dun. ");
INSERT INTO bpr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bay nun sa dademe dad to dmawat na ftoo di kenen, taman banlén ale ktoo mbaling dad ngà i Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na là ti mbaling ale dad ngà i Dwata fagu di ksutla, ku demen fagu di knayè i to, ku demen fagu di nimòla. Bay Dwata i mimò dale dad ngàan. ");
INSERT INTO bpr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na kanto mbaling to i Tnalù ayé, ta mnè kenen di safédmi na ta teenmi i kdatahan, na too sikof i kafyen na i kaglutan. Gdawatan i kdatah ani du lo kenen sen Ngà Màan. ");
INSERT INTO bpr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Na ani tulen Dyan gablà di kenen. Falbongan i talùan, manan, “Ani ta man-gu gamu. I to tmadol di do, too kenen mdatah di do du di lamgu fa là sut, ta sana mto kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na mdà di bong kafyen, landè ti gusen i kafye galan blé di gito. ");
INSERT INTO bpr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Du blé Dwata i dad uldinan fagu di ku Mosis, bay kel i kafye na i kaglut fagu di ku Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Landè to lmen mite i Dwata. Bay i sen Ngàan, dunan i too kanbong nawa i Mà, kenen i fdilè dun di gito, du Dwata kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na di satu du, i dad ulu i dad Dyu di Dyérusalém, dekla i dad ganlal di kafaglut, na lê dad bel Libay du fsalekla ku Dyan ku simto kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Na tulen Dyan dale i kaglutan, manan, “Ise do Krayst, i Mgalék Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na lêla snalek kenen, manla, “Bay simto ge? Ge kè Ilaydya?” Bay tmimel Dyan, manan, “Ise.” Na lêla man snalek kenen, manla, “Ge kè i Tugad Dwata?” Bay lê tmimel Dyan, manan, “Ise.” ");
INSERT INTO bpr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Taman, smalek ale, manla, “Na ku yé, simto ge kè? Tulenam gami du fye nun tulenmi di dad to mdek gami. Dét i manam gablà di ktom?” ");
INSERT INTO bpr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Na tmimel Dyan fagu di dad talù Isaya, satu tugad i Dwata, manan, “Do i to tamlo di banwe landè to mnè ditù, manan, ‘Tanluhyu i dalan gumagu i Amu.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na yé mdek dale dunan i dad Farisi. ");
INSERT INTO bpr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Na ta lê ale smalek, manla, “Ku ise ge Krayst, i Mgalék Dwata, ku demen Ilaydya, ku demen i Tugad Dwata, kan sa ku gal ge munyag?” ");
INSERT INTO bpr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na tmimel Dyan, manan, “Munyag agu lo fagu di éél. Bay nun satu di blengyu, na là dilèyu dun. ");
INSERT INTO bpr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kel kenen tmadol di do, bay too mdatah kenen di do. Là gablà agu mteh ikat talumfàan du too agu mdanà di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mgimò kdeen ayé di satu tukay banwe dnagit Bétani di faltù Éél Dyordan, dunan i gal gumunyag Dyan. ");
INSERT INTO bpr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Di tmadol du, teen Dyan Dyisas fdadong di kenen, na manan di dad to, “Neyeyu, ta déé Ngà Bilibili i Dwata mwè salà i dad to di klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dunan ani i ta tulen-gu di gamu, ‘Nun satu to, na balù tmadol kenen di do, bay too mdatah kenen di do, du di lamgu fa là sut, ta sana mto kenen.’ ");
INSERT INTO bpr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Balù do di munan, là dilègu dun, bay knèan gadini agu munyag di éél du fye fdilègu kenen di dad to Israél.” ");
INSERT INTO bpr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na lê talù Dyan, manan, “Teen-gu Tulus i Dwata tufa mdà di langit gambet abun, na mnè di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Di munan, là dilègu kenen, bay Dwata, i mdek do munyag fagu di éél, i man dun di do, ‘Teenam i Tulus mdaf na mnè di satu to, na yé sa i munyag fagu di Mtiu Tulus.’ ");
INSERT INTO bpr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na ta teen-gu i ilè ayé, na ani tulen-gu di gamu, kenen sa Ngà i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Di tmadol du, ta lê déé Dyan na i lwe dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na kanto meye Dyan, teenan Dyisas magu, na manan di dale, “Neyeyu, ta déé Ngà Bilibili i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na kanto linge i lwe to gal tdò Dyan i manan, ta mdà ale magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na kanto kmangél Dyisas, teenan ale magin di kenen, na snalekan ale, manan, “Dét i fanngabalyu?” Na manla di kenen, “Rabay, nè gumnèam?” (Na yé gumtatek Rabay ani dunan “To Tamdò.”) ");
INSERT INTO bpr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Na man Dyisas di dale, “Flal gamu du fye teenyu.” Na fles ale magin di kenen, na teenla i gumnè gufanakan. Na fanak ale là mlo di safédan du ta tngà masol i du. ");
INSERT INTO bpr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na yé satu di lwe dad to lminge ku Dyan na magin ku Dyisas, dunan Andru, i flanek Simon Piter. ");
INSERT INTO bpr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na gasilan fanngabal Simon, i flanekan. Na kanton teen, manan dun, “Ta teenmi i Mésaya.” (Na yé gumtatek Mésaya dunan Krayst, i Mgalék Dwata.) ");
INSERT INTO bpr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na nebe Andru Simon salu ku Dyisas. Na kakella ditù, too falnunu Dyisas Simon, na manan, “Ge sa Simon i ngà Dyan. Bay mdà ani, yé dagitam Sifas.” (Salngad i gumtatek i dad dagit Piter na Sifas, dunan “Batu.”) ");
INSERT INTO bpr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na di tmadol du, ta sansatu Dyisas nawan salu ditù di probinsya Galili, na kanton teen Filip, manan dun, “Magin ge do.” ");
INSERT INTO bpr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na yé gumdà Filip di banwe dnagit Bétsayda, dunan i gumdà ale Andru na Piter. ");
INSERT INTO bpr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na fanngabal Filip Natanyél. Na kanton teen, manan dun, “Ta teenmi i to man Mosis di ksulatan i uldin Dwata, na lê man i dademe tugad i Dwata di munan, dunan Dyisas mdà di banwe Nasarét, i ngà Dyosip.” ");
INSERT INTO bpr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na man Natanyél di kenen, “Nun kè fye to mdà di Nasarét?” Na man Filip di kenen, “Flal ge. Neyem.” ");
INSERT INTO bpr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na di kafdadongla ditù di ku Dyisas, ta teen Dyisas Natanyél, na ta manan gablà di kenen, “Too glut Dyu i to ani du là fulungan malew.” ");
INSERT INTO bpr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na smalek Natanyél, manan, “Kan dé ku dilèam agu?” Na tmimel Dyisas, manan di kenen, “Di là fa tlo Filip ge, ta sanata ge teen di dungan i kayu fig.” ");
INSERT INTO bpr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na man Natanyél di kenen, “Sér, ge sa Ngà i Dwata, na ge sa i Harì di Israél.” ");
INSERT INTO bpr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na man Dyisas di kenen, “Ftoo ge kè du mdà di kman-gu dun ta teenta ge di dungan i kayu fig? Midul fa déé i dad tnikeng nimò teenam.” ");
INSERT INTO bpr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na manan di dale, “Too glut i man-gu di gamu, na nun du kadang, teenyu i langit ta mgukà, na myak na lê tufa i dad kasaligan i Dwata salu di do, i dnagit Ngà To.” ");
INSERT INTO bpr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Di gatlun du, nun song di lunsud Kana ditù di probinsya Galili. Na ditù i yê Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na lêla nlak Dyisas na i dad to galan tdò, taman lê ale magin. ");
INSERT INTO bpr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na kanto mti i binu, ta man yêan di kenen, “Ta landè sa binula.” ");
INSERT INTO bpr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bay baling man Dyisas di yêan, “Libun, nang ge lmabet di nimògu. Là fa kel i bang kfitegu i kdatahgu.” ");
INSERT INTO bpr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na man i yêan di dad snalig, “Nimenyu balù dét dekan gamu.” ");
INSERT INTO bpr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na nun nam namuh déé galla gumkah éél du alob i dad Dyu du yé lalòla di kafaglutla. Na kat satu namuh ayé, lime ku demen nam lata i laman. ");
INSERT INTO bpr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na yé duenam man, ta man Dyisas di dad snalig ayé, “Fananòyu éél i dad namuh ani.” Na fananòla. ");
INSERT INTO bpr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Na fnge man Dyisas di dale, “Mwè gamu, na bléyu di to magot i song.” Na ta banléla di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na ta tilew i to magot i song i éél ta mbaling binu. Là sa gadèan gumdà i binu ayé. (Bay lo yé gmadè dun i dad snalig mwè i éél gine). Taman, ta tlon i lagi sansong, ");
INSERT INTO bpr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na manan di kenen, “Yé galla nimò di dad song funala blé i binu too fye, na ku ta bong ginum i dad to, yé klola mlé i binu là too fye neman. Bay ge, ani klom baling falwà i too fye binu.” ");
INSERT INTO bpr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yé tnanin tnikeng nimò Dyisas du fye fiten i kdatahan, taman, ta ftoo di kenen i dad to galan tdò. Na ditù gumimòan dun di lunsud Kana di Galili. ");
INSERT INTO bpr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na kafnge ayé, ta mdà Dyisas salu di Kapernaum, na magin i yêan, na dad flanekan, na lê man dad to galan tdò, na mnè ale ditù di Kapernaum di là mlo. ");
INSERT INTO bpr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na ta mdadong nan i fista dnagit dad Dyu Fista Du Kaglius, taman, fles Dyisas ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na kanto kel ditù, ta fusuk di Bong Gumnè Gumangamfù di Dwata, na nun teenan dad to fabli dad safì, bilibili, na abun. Na lê sudeng déé i dad to gal sasambì filak. ");
INSERT INTO bpr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na mimò Dyisas fas tali, na ndalan i kdee mnè di gumnè ayé, balù i dad bilibili na i dad safì. Na lugadan dad lamisa i dad to sasambì filak, na sabulan i dad filakla. ");
INSERT INTO bpr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na klon blaling di dad to fabli abun, na manan, “Nebeyu lamwà i dad fabliyu ani. Nangyu fanbaling fadyan i gumnè Màgu.” ");
INSERT INTO bpr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na di kaklinge i dad to galan tdò ayé, ta gafaldamla i sulat di Tnalù Dwata, manan, “I kalbong nawagu i Gumnèam dminè salngad lifoh di lam nawagu.” ");
INSERT INTO bpr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na kanto teen dad ganlal i dad Dyu i nimò Dyisas ayé, snalekla kenen, manla, “Nun tnikeng gaganam nimò kè du gudmilèmi dun na nun ktoom mimò ayé?” ");
INSERT INTO bpr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na tmimel Dyisas, manan, “Lanbàyu i Gumnè Dwata ani, na lêgu man fdak di lam i tlu du.” ");
INSERT INTO bpr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na manla di kenen, “Fat falò nam fali klo mimò i Gumnè Dwata ani, na lom lê fdak di lam i tlu du?” ");
INSERT INTO bpr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bay i gumnè man Dyisas ani dunan i lawehan. ");
INSERT INTO bpr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na yé duenam man, kanto mték Dyisas di fati, ta gafaldam dad to galan tdò i manan ayé, na ta fantoola i gsulat di Tnalù Dwata, na i man Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na di klo Dyisas fanak di Dyérusalém di lam i Fista Du Kaglius, nun dee dad to ftoo di kenen du mdà di kitela dad tnikeng nimòan. ");
INSERT INTO bpr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bay Dyisas, là ti snaligan ale du ta sanan gadè i fandam i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na balù landè tmulen kenen ku dét mnè di fandam i dad to, du ta sanan gadè i fandamla. ");
INSERT INTO bpr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na nun satu ganlal di dad Dyu, yé dagitan Nikodimus, na kenen satu Farisi. ");
INSERT INTO bpr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Di satu kifuh, salu kenen di ku Dyisas, na manan dun, “E Sér, gadèmi na ge i satu to tamdò mdà di Dwata, du landè to gmagan mimò dad tnikeng gambet i teenmi dini ku ise Dwata i magin di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na man Dyisas di kenen, “Too ti glut i man-gu di ge ani, na landè to mite i Kagot Dwata ku là lêan sut samfulê.” ");
INSERT INTO bpr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na smalek Nikodimus, manan, “Dét kibò i satu to lê sut samfulê ku ta tua kenen? Landè kibòan samfulê di lam tien i yêan du fye lê man sut.” ");
INSERT INTO bpr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na tmimel Dyisas, manan, “Too ti glut i man-gu di ge. Silang gfusuk i satu to di Kagot i Dwata ku sut kenen fagu di éél na di Tulus i Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Du nè sut di to, to kenen, na nè sut di Tulus i Dwata, lmalò di Tulus Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taman, nang ge tikeng di kman-gu dun di ge, là fakay ku là lê gamu sut samfulê. ");
INSERT INTO bpr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kaflingenta dun, i nus, mbal tati fiho i gusalun, lingem i lukan, bay knèan là gadè ku nè gufdun, na i gusalun. Salngad ani kdee dad to sut fagu di Tulus i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Na smalek Nikodimus, manan, “Det kè i kfagu na mgimò ani?” ");
INSERT INTO bpr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na tmimel Dyisas, manan, “Ge i satu to tamdò i dad to Israél, na làam kadì glabat ani? ");
INSERT INTO bpr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Too ti glut i man-gu di ge. Nè i gadèmi, yé tdòmi, na nè i teenmi, yé tulenmi, bay knèan sana là kaftooyu dad manmi. ");
INSERT INTO bpr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ku là fantoom i ta tulen-gu di ge gablà di kagkah dini di tah tanà, dét i kibò kaftoom ku ye tulen-gu di ge i kagkah ditù di langit? ");
INSERT INTO bpr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Landè ti to lmen gfusuk di langit, bay lo do dnagit Ngà To, du yé gumdàgu di langit. ");
INSERT INTO bpr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Di munan, tlawéng Mosis i ulad tambaga di banwe landè to mnè ditù na nketan fdatah. Na do, i dnagit Ngà To, salngad ayé kadang i kagkahgu du tlawéngla agu di kayu, na nketla agu fdatah, ");
INSERT INTO bpr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","du fye i kdee dad to ftoo di do gfunla nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Du mdà di too kalbong nawa Dwata i kdee dad to di klamang banwe, blén i sen Ngàan du fye nè i to ftoo di kenen, là ti malmon, bay gfunan nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ise ku yé duen Dwata mdek i Ngàan salu di tah tanà ku falnayaman i dad to, bay falwàan ale. ");
INSERT INTO bpr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Na nè to ftoo di Ngà i Dwata, ta là falnayam Dwata dun, bay nè to là ftoo di kenen, ta nukum di kaflayam du là fantoon i sen Ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na ani duen Dwata falmayam du ta salu dini i Salò di tah tanà, bay i dad to, knangla i Salò du yé kanbongla nawa i kifuh du tà teen i dad sasè nimòla. ");
INSERT INTO bpr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Du i to mimò sasè, knangan i Salò, na là mayèan fdadong di Salò tà teen i dad sasè nimòan. ");
INSERT INTO bpr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bay i to tluh nimòan, fdadong kenen di Salò du fye teen na i kdee dad nimòan slame mdà di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kafnge ayé, ta mdà Dyisas na i dad to galan tdò salu di probinsya Dyudiya. Fanak kenen déé là mlo, na munyag. ");
INSERT INTO bpr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na lê munyag Dyan ditù di satu tukay banwe dnagit Énon mdadong di Salim du nun bong éél ditù. Na nun dee dad to salu di kenen du fbunyag ale, ");
INSERT INTO bpr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","du di du atù, là fa blanggù Dyan. ");
INSERT INTO bpr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na di satu du, i dad to gal tdò Dyan, sgil ale i satu Dyu gablà di kafbunyag. ");
INSERT INTO bpr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Taman, ta salu ale di ku Dyan, na manla di kenen, “E Sér, gafaldamam i demem gal sgalak ditù di faltù Dyordan, dunan i galam tulen? Gal kenen munyag, na ta too dee dad to magin di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Na man Dyan di dale, “I to tanà, landè gnaganan ku là blé Dwata dun di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Balù gamu sa, ta lingeyu i man-gu di gamu na ise do Krayst, i Mgalék Dwata, bay dek Dwata agu muna di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ku nun sansong, yé gumagin i libun di demen song. Na mdà i to mnè di bleng, fatanan ktalù i lagi sansong. Na ku ta lingen, too bong i klehewan. Na do i mnè di bleng, salngad ayé ksikof i do klehew. ");
INSERT INTO bpr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Là fakay ku là midul i kenen kdatah, na do, too midul i kdanàgu. ");
INSERT INTO bpr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ku nè mdà di langit, kenen mdatah di kdee. Nè mdà di tah tanà, lo to tanà kenen, na yé santulenan i kagkah di tah tanà. Bay nè mdà di langit, mdatah kenen di kdee. ");
INSERT INTO bpr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Na balù ku tulenan i ta teenan na i ta lingen, bay knèan, là dee ftoo di tulenan. ");
INSERT INTO bpr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bay nè to dmawat i tulenan, yé fgadèan na Dwata too ti glut. ");
INSERT INTO bpr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na i to ta dek Dwata, lo yé manan i tnalù Dwata du là gagan bantas i kablé Dwata i Tulusan di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bong nawa Mà i Ngàan, taman ta fagotan di kenen i kalbong kdee. ");
INSERT INTO bpr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na nè to ftoo di Ngà Dwata, gamdawat nawa landè sen. Bay nè i to là ftoo di Ngà Dwata, là gamdawatan nawa landè sen, bay klonto mnè di tahan i kalbut Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ta linge dad Farisi mas dee i dad to gebe na bnunyag Dyisas di ku Dyan. ");
INSERT INTO bpr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Bay di ktoon, ise ku Dyisas i munyag, bay i dad to galan tdò). ");
INSERT INTO bpr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na kanto linge Dyisas i man dad Farisi ayé, tnagakan Dyudiya, na samfulê di Galili. ");
INSERT INTO bpr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na là fakay ku là magun di Samarya. ");
INSERT INTO bpr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na manak Dyisas magu, ta kel di satu tukay banwe dnagit Sikar glam di Samarya mdadong di tanà ta blé tdohan Dyékob di ku Dyosip, i ngàan. ");
INSERT INTO bpr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na déé i sana sol éél Dyékob. Kanto ltu i du, ta sudeng Dyisas di saféd i sol éél ayé du ta mlungay magu. ");
INSERT INTO bpr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Bay là déé dad to gal tdò Dyisas du ta fles ale mayad knaan di lunsud). Na là mlo mdà ayé, ta nun satu libun mdà di Samarya kel di sol éél ayé du smulu. Ta man Dyisas di kenen, “Begam agu finum.” ");
INSERT INTO bpr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na tnimel i libun ayé Dyisas, manan, “Ge satu Dyu, na do satu libun mdà di Samarya. Kan kè ku mni ge éél di do?” (Yé duenan man ayé du suteh nawa i dad Dyu na i dad to di Samarya). ");
INSERT INTO bpr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na lê tmimel Dyisas, manan, “Ku lom gadè moon i knayè Dwata blé di ge na ku dilèam i to mni éél di ge, ta ge i baling mni di do du banléta ge éél mlé falami nawa.” ");
INSERT INTO bpr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na man i libun ayé di kenen, “Bay Sér, landè sa wèam éél, na too mngalam i sol éél ani. Nè gumwèam dé i manam éél ayé mlé falami nawa? ");
INSERT INTO bpr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yé mlé i sol éél ani di gami i gutambulmi, Dyékob. Di munan, dini galla gumwè ninumla i dad ngàan na dad lmanafan. Kan? Mas mdatah ge kè di ku Dyékob?” ");
INSERT INTO bpr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na tmimel Dyisas, manan di kenen, “Nè i to minum di éél ani, lê malinuman. ");
INSERT INTO bpr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bay nè i to minum i éél blégu, ta là lê man malinuman kel di landè sen, du i éél blégu ayé mgimò sfut di lam i nawan na mlé kenen nawa landè sen.” ");
INSERT INTO bpr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na man i libun ayé di ku Dyisas, “E Sér, banlém agu éél manam ayé du fye ta là malinumgu, na fye ta là lê agu samfulê smulu dini.” ");
INSERT INTO bpr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na man Dyisas di kenen, “Mdà ge. Nngém yaanam, na samfulê ge dini.” ");
INSERT INTO bpr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na tmimel i libun ayé, manan, “Landè sa yaan-gu.” Na man Dyisas di kenen, “Too i manam ayé na landè yaanam. ");
INSERT INTO bpr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bay ta lime sa i kdee yaanam, na i lagi demem ani, ise yaanam. Too i manam ayé.” ");
INSERT INTO bpr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na man i libun ayé di kenen, “Fantoogu na ge satu tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I dad gutambulmi, yé gumangamfùla di Dwata di bulul ani, bay gamu dad Dyu, yé manyu Dyérusalém i gumangamfù di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Bay man Dyisas di kenen, “Fye ku fantoom i man-gu di ge ani. Kel i du ta ise di bulul ani ku demen di Dyérusalém i gumangamfù di Mà. ");
INSERT INTO bpr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamu dad to di Samarya, là dilèyu i fnangamfùyu. Bay gami dad Dyu, dilèmi i fnangamfùmi du yé sa gumdà i kagalwà di dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bay fan kel i du, na ani ta dini, i dad to too dunan mangamfù di Dwata, mangamfù ale mdà di nawala na di ktoon. Ani i kfangamfù di Dwata knayè Mà di dad to mangamfù di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","I Dwata, Tulus kenen, na yé duenam man, nè i to mangamfù di kenen, là fakay ku là mangamfùan mdà di nawan na di ktoon.” ");
INSERT INTO bpr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na man i libun ayé di kenen, “Gadègu gadini i Mgalék Dwata, i dnagit Krayst, na ku ta kel kenen, fbatengan fgadè i kdee.” ");
INSERT INTO bpr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na man Dyisas di kenen, “Do sa i manam ayé, dunan i ta stulen di ge ani.” ");
INSERT INTO bpr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na kafnge ayé, ta lê kel i dad to galan tdò, na tikeng ale du ta yé demen stulen libun. Bay landè balù satu di dale gamlas smalek ku dét i knayèan, na ku dét i duenan stulen di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bay i libun ayé, tnagakan i namuhan, na ta samfulê di lunsud du tnulenan i dademen, ");
INSERT INTO bpr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","na manan, “Flal gamu na neyeyu. Nun to ditù ta tulenan do i kdee dad nimògu. Keng kenen Krayst, i Mgalék Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na ta mdà ale lamwà di lunsud ayé du salu ale ditù di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na di lam i dad to ayé là fa kel di ku Dyisas, fakdo dad to galan tdò di kenen, manla, “Amu, beg ge kmaan.” ");
INSERT INTO bpr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bay man Dyisas di dale, “Nun sa do knaan i làyu gadè dun.” ");
INSERT INTO bpr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na sasalek i dad to galan tdò, manla, “Keng ta nun tmunda dun knaan?” ");
INSERT INTO bpr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na man Dyisas di dale, “Yé do knaan dunan i kimen-gu i knayè Mà, dunan i mdek do, na i kafngegu i fimòan do. ");
INSERT INTO bpr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ise yé galyu man, ‘Fat bulen klon kel i bang kamtu?’ Bay ani man-gu di gamu. Neyeyu i dad fele du ta tagah, na ta gablà ale kantu. ");
INSERT INTO bpr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","I to kamtu, nun sukéyan, na santifunan i dad ulê du fye gfunla i nawa landè sen. Na yé duenam man, i to mlah na i to kamtu, sasatu ale flehew. ");
INSERT INTO bpr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Taman, too glut i galla man, ‘Mahal i to mlah, na mahal i to kamtu.’ ");
INSERT INTO bpr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta dekta gamu kamtu di ise gamu fanlah. Dademe i mlah dun, bay gamu gamdawat lubayla.” ");
INSERT INTO bpr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na nun dee dad to ftoo di ku Dyisas mdà di lunsud ayé di Samarya du mdà di ktulen i libun ayé, du manan, “Ta tulenan do i kdee dad nimògu.” ");
INSERT INTO bpr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na kanto kel i dad to ayé di ku Dyisas, beg ale fakdo di kenen du fye fanak di safédla, taman fanak kenen ditù lwe butang klon. ");
INSERT INTO bpr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na nun fa dee dademe to ftoo di kenen du di laman fanak di banwela, gal kenen tamdò. ");
INSERT INTO bpr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na man i dad to di libun ayé, “I kaftoomi ise ku lo mdà di ktulenam dun di gami, bay ta toomi linge di kenen, na ta gadèmi kenen i Falwà i dad to di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na kafnge lwe butang, ta mdà Dyisas mulê di Galili. ");
INSERT INTO bpr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yé man Dyisas, “I tugad Dwata là sa nafè i dad to dun di kenen banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bay kakelan di Galili, toola kenen dnawat, du ta ale di Fista Du Kaglius di Dyérusalém, na ta teenla kdee dad nimòan ditù. ");
INSERT INTO bpr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na kafnge ayé, ta samfulê Dyisas di Kana di Galili, dunan i banwe gufambalingan binu i éél. Na nun satu ganlal déé nun tduk i ngàan lagi ditù di Kapernaum. ");
INSERT INTO bpr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na kanto linge i ganlal ayé na ta kel Dyisas di Galili fdu di Dyudiya, salu kenen di ku Dyisas na fakdo di kenen du fye gatù Dyisas di Kapernaum fye fan-gulêan i ngàan du ta fan mati. ");
INSERT INTO bpr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Bay man Dyisas di kenen, “Balù man ge, leg. Landè di gamu ftoo di do, silang ku teenyu i tnikeng nimògu na ilè i kdatahgu.” ");
INSERT INTO bpr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bay man i ganlal ayé di ku Dyisas, “E Amu, beg ge salu gatù di lam i ngàgu là fa mati.” ");
INSERT INTO bpr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na man Dyisas di kenen, “Mulê ge nan du ta mgulê i ngàam.” Na fantoo i ganlal ayé i man Dyisas di kenen, na ta mdà mulê. ");
INSERT INTO bpr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na di kulêan, snitong dad fasakan kenen, na manla, “Ta mgulê i ngàam.” ");
INSERT INTO bpr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Taman, snalekan ale, manan, “Dét kibò du kgulê i ngàgu.” Na tmimel ale, manla, “Ta kléh i du balfabi kakah i initan.” ");
INSERT INTO bpr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na i ganlal ayé, ta gafaldaman i kman Dyisas dun di kenen di ta kléh i du, “Ta mgulê i ngàam.” Na ta toon fantoo Dyisas, na lê magin i kdee dademen di gumnèan. ");
INSERT INTO bpr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na yé galwe tnikeng nimò Dyisas, na déé gumimòan dun di Galili di kakelan fdu di Dyudiya. ");
INSERT INTO bpr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na kafnge ayé, nun fista i dad Dyu di Dyérusalém, na salu Dyisas ditù. ");
INSERT INTO bpr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na nun lanaw déé di Dyérusalém, na yé dagit dun di talù Hibru Bétsata. Na déé gumnè i lanaw ayé di saféd i gufusuk i dad bilibili, na nun lime dalan tufa i nun slung. ");
INSERT INTO bpr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na nun dee dad to milè déé sahal tdukla. Nun dad butè, na kimay, na dad to là galyak i lawehla. Na tadè ale fanak déé du fatanla i ksambug i éél. ");
INSERT INTO bpr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Du slaan nun satu kasaligan i Dwata gal tufa salu di lanaw ayé, na snambugan i éél. Na di kafnge i kasaligan smambug, nè i guna falnab, yé mgulê balù dét i tdukan. ");
INSERT INTO bpr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na nun satu to déé ta tlu falò walu fali i ta klon fandas. ");
INSERT INTO bpr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na kanto teen Dyisas kenen di gumilèan, gadèan na ta mlo nan i tduk i to ayé, na manan di kenen, “E leg, mayè ge kè mgulê?” ");
INSERT INTO bpr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na tmimel i to ayé, manan, “E Sér, landè tmabeng do falnab di éél ku ta magsambug, na di lamgu là fa gafalnab, ta gal guna i dademe.” ");
INSERT INTO bpr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Bay man Dyisas di kenen, “Tadag ge, fantifasam i gumilèam, na magu ge.” ");
INSERT INTO bpr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na di kman Dyisas ayé, tadè mgulê i to ayé, na ta fantifasan i gumilèan, na ta mdà magu. Na mgimò ayé di Du Kaftud i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Taman, man i dad Dyu di to ayé, “Du Kaftud sa ani, na là fakay di uldin Dwata gito ku nebem i gumilèam di Du Kaftud.” ");
INSERT INTO bpr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na tmimel kenen, manan, “I to famgulê do, yé i man do, ‘Fantifasam i gumilèam na magu ge.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na snalekla kenen, manla, “Simto kè i mdek ge mebe i gumilèam na mdek ge magu?” ");
INSERT INTO bpr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bay là gadè i to ayé ku simto i famgulê dun du ta dee dad to stifun déé, na ta talgunus Dyisas mdà. ");
INSERT INTO bpr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bay kafnge ayé, teen Dyisas kenen di Bong Gumnè Gumangamfù di Dwata, na manan dun, “Na ani, du ta mgulê ge, ta nang ge lê fagsalà tà lê man matnù i ksasè mkel di ge.” ");
INSERT INTO bpr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na ta mdà i to ayé, na tnulenan dad ganlal i dad Dyu na Dyisas i famgulê kenen. ");
INSERT INTO bpr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Taman, tanbùla falnayam Dyisas du ta fan-gulêan i to ayé di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bay man Dyisas di dale, “Là ftud i Màgu kenen mimò kel ani. Na yé duenam man, lê agu do mimò.” ");
INSERT INTO bpr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Taman, too midul kayè i dad ganlal i dad Dyu meye kfagu kfatila kenen du yé fandamla, ta lwe salàan. Ise ku lo lnafàan i uldin gablà di Du Kaftud, bay di kmanan dun na Dwata kun i Màan, ta fasalngadan i kton di Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bay tmimel Dyisas, manan di dale, “Too ti glut i man-gu di gamu na do i Ngà Dwata, landè gnagan-gu nimò ku lo do. Lo yé nimògu i teen-gu di ku Mà, na nè i nimò Mà kenen, yé lêgu do nimò. ");
INSERT INTO bpr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Du mdà di kalbong nawa Mà do, galan fite di do i kdee nimòan. Na nun fa dademe i fanan fite di do i mas gamtikeng di ta muna nimòan du fye too gamu tikeng. ");
INSERT INTO bpr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Du gal nték Màgu i dad mati na banlén ale nawa, lê salngad ayé, banlégu nawa ku simto i knayègu banlé. ");
INSERT INTO bpr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na landè nukum Mà, balù simto dun. Bay ta blén di do i kdatah mukum i kalbong kdee, ");
INSERT INTO bpr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","du fye i kdee dad to, nafèla agu salngad kafèla di ku Mà. Ku nè to là mafè do, là lêan nafè Màgu, i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Too ti glut i man-gu di gamu, na nè to flinge di Tnalùgu na ftoo di mdek do, nun nawan landè sen, na ta là kenen falnayam, du ta gifal mdà di fati salu di nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Too ti glut i man-gu di gamu. Fan kel i du, na ani ta dini, ta linge dad to mati di dad salàla i talù i Ngà Dwata. Na nè to too flinge, mlawil kenen. ");
INSERT INTO bpr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","I Màgu Dwata, kenen gutambul i nawa, na ta lêan agu nimò gutambul i nawa. ");
INSERT INTO bpr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na ta lê blé Màgu di do i kdatah na ktoo mukum du do sa dnagit Ngà To. ");
INSERT INTO bpr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bay nang gamu tikeng di kman-gu ani, kel i du na i kdee dad mati déé di lbangla, lingela i talùgu. ");
INSERT INTO bpr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na lamwà ale di dad lbangla, na nè dad to mimò fye, mték ale na mlawil. Na nè dad to sasè nimòla, mték ale na falnayam. ");
INSERT INTO bpr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Landè gnagan-gu nimò ku lo do. Bay mukum agu lmalò di man Mà di do. Taman, tluh i kukumgu du ise ku do knayè i nimen-gu, bay i knayè Mà, du kenen i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na ku lo do i tmulen gablà di ktogu, balù là fantooyu agu. ");
INSERT INTO bpr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bay nun fa satu tmulen gablà di do, na gadègu na i kdee manan gablà di do slame glut. ");
INSERT INTO bpr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gamu sa i mdek dad to di ku Dyan du fsalekyu kenen, na ta tulenan i kaglutan. ");
INSERT INTO bpr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bay ise ku yé gusmaliggu i man dad to gablà di do, bay logu man ani du fye galwà gamu. ");
INSERT INTO bpr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Na Dyan, gambet kenen salò mneng na tmuyal di gamu, na flehew gamu là mlo di nengan. ");
INSERT INTO bpr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Bay nun tmulen gablà di do too mdatah fa di ktulen Dyan. I dad nimò ta fimò Mà do, yé tmulen gablà di do na ilè na dek Mà agu. ");
INSERT INTO bpr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Mà, i mdek do, lê kenen i tmulen gablà di do. Bay gamu, là lmenyu lminge i talùan, na là lêyu lmen mite i bawehan. ");
INSERT INTO bpr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na yé duen là mnab di nawayu i Tnalùan du là fantooyu i ta dekan. ");
INSERT INTO bpr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Na galyu ganbet i Tnalù Dwata du yé man nawayu mdà déé gamfun gamu nawa landè sen, na blaam yé tmulen gablà di do. ");
INSERT INTO bpr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bay knèan, là mayè gamu salu di do du fye gfunyu i nawa. ");
INSERT INTO bpr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na ise ku yé fanngabalgu i kdayen i dad to, ");
INSERT INTO bpr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","bay gadègu gamu, na gadègu là kanbongyu nawa i Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Salu agu dini fagu di dagit Mà, bay làyu agu dnawat. Bay ku nun to salu dini di kenen dagit, baling yé dnawatyu. ");
INSERT INTO bpr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Na yé knayèyu i kdayen i dademeyu to, bay làyu nusal kdayen mdà di too glut Dwata. Taman, landè kibòyu ftoo. ");
INSERT INTO bpr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bay nangyu fandam ku do i tmulen gamu di Màgu, bay Mosis, i gumgal nawayu, yé sa tmulen gamu. ");
INSERT INTO bpr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ku glut ftoo gamu di man Mosis, lê gamu ftoo moon di do du smulat Mosis gablà di do. ");
INSERT INTO bpr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bay du là fantooyu i dad sulat Mosis, dét kibòyu ftoo di dad man-gu?” ");
INSERT INTO bpr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kafnge ayé, ta mifal Dyisas di Lanaw Galili, ku demen Tibiryas. ");
INSERT INTO bpr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na dee dad to lmalò kenen du ta teenla i dad tnikeng nimòan, dunan i kafgulêan dad to fandas. ");
INSERT INTO bpr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bay mnagad Dyisas di satu bulul, na sudeng ditù magin i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na ta mdadong nan i fista i dad Dyu dnagit Fista Du Kaglius. ");
INSERT INTO bpr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kanto tukeng Dyisas na meye, teenan i dee dad to salu di kenen. Ta manan ku Filip, “Nè gumayadto knaan gablà fkaan di kdee dad to ani?” ");
INSERT INTO bpr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yé duen Dyisas smalek ani gine du lon tnilew Filip, du ta sanan gadè ku dét i fanan nimò). ");
INSERT INTO bpr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na tmimel Filip, manan, “Balù ku yé btas knaan salngad di sukéy i satu to di lwe latuh du klon talbahò, là ti kat kdee dad to ani, balù ku too tukay i knaanla.” ");
INSERT INTO bpr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na lê talù satu to gal tdò Dyisas, dunan Andru, i flanek Simon Piter, na manan di ku Dyisas, ");
INSERT INTO bpr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nun ngà lagi dini, na nun neben lime batù fan na lwe batù nalaf, bay dét gukmamu ani di kdee dad to ani?” ");
INSERT INTO bpr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Bay man Dyisas di dad to galan tdò, “Fsudengyu i dad to ani.” (Na nun dee bnas déé). Taman, ta sudeng i dad lagi, nun dad lime libu i kdeela. ");
INSERT INTO bpr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na ta nwè Dyisas i fan na fasalamat di Dwata, klon malel dun di dad to sudeng. Na lê salngad ayé i nimòan di nalaf. Na kmaan i kdee dad to ayé kel di kabsolla. ");
INSERT INTO bpr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na kanto ale bsol, man Dyisas di dad to galan tdò, “Santifunyu i lukasla tà malmo.” ");
INSERT INTO bpr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na yé duenam man, ta santifunla lukas i fan mdà di lime batù fan fkaan Dyisas di dad to ayé, na yé kdeen sfalò lwe been fnò. ");
INSERT INTO bpr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na kanto teen i dad to kmaan ayé i tnikeng nimò Dyisas, manla, “Ani i tugad Dwata sanfatanto dek Dwata salu di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na gadè Dyisas na fan ale salu di kenen du fye nwèla na gnagala nimò harìla. Taman, ta mdà kenen salu di bulul lon satu. ");
INSERT INTO bpr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na di kasdaf i du, ta salu i dad to galan tdò ditù di lanaw. ");
INSERT INTO bpr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na ta smakay ale aweng, na mifal ale di lanaw salu di Kapernaum. Ta kifuh nan, bay là fa kel Dyisas di dale. ");
INSERT INTO bpr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na ta malbang lwek mdà di kbal i nus. ");
INSERT INTO bpr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na kanto lime ku demen nam kilumitru i kawagla di kilil, ta teenla Dyisas, na tadè kenen magu di tah i lanaw salu di dale. Na too ale likò. ");
INSERT INTO bpr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bay man Dyisas di dale, “Nang gamu likò du do sa ani.” ");
INSERT INTO bpr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na mdà ayé, too ale lehew fsakay kenen. Galì ale lamyalo, ta dmuung ale di gusalula. ");
INSERT INTO bpr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na di tmadol du, sana kfanak i dademe dad to di faltù i lanaw. Tagnèla teen na lo satu aweng déé, dunan i ta snakay dad gal to tdò Dyisas, na lêla gadè di ta kdà i dad tdòan mifal, là magin Dyisas kenen. ");
INSERT INTO bpr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bay nun dad aweng mdà di banwe Tibiryas dmuung déé di saféd i gukmaan dad to i fan di ta kafnge i Amuto fasalamat. ");
INSERT INTO bpr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na kanto teen i dad to ayé na ta là déé Dyisas na i dad to galan tdò, ta mdà ale maweng salu di Kapernaum du fanngaballa Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na kantola teen Dyisas ditù di faltù, ta snalekla, manla, “E Sér, kilen kakelam dini?” ");
INSERT INTO bpr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na tmimel Dyisas, manan, “Too ti glut i man-gu di gamu ani. Yé duenyu mngabal do du ta gamkaan gamu fan, na ta bsol gamu. Ise ku yé duenyu mngabal do ku mdà di kaglabatyu i tnikeng nimògu. ");
INSERT INTO bpr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nang gamu faflayam mngabal i knaan mlal mlanas, bay yé gufaflayamyu mngabal i knaan là mlanas mlé nawa landè sen. I knaan ani, yé mlé dun di gamu i dnagit Ngà To, du Dwata Mà, ta fankahan ilè i kdatah ta blén dun.” ");
INSERT INTO bpr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na snalekla Dyisas, manla di kenen, “Dét i nimòmi fye nimenmi knayè i Dwata?” ");
INSERT INTO bpr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na tmimel Dyisas, manan di dale, “Ani i nimò fimò Dwata gamu, ftoo gamu di dekan.” ");
INSERT INTO bpr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Taman, manla dun, “Dét i tnikeng nimòam fitem gami du fye ftoo gami di ge? ");
INSERT INTO bpr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Di munan, gamkaan i dad gutambulmi di banwe landè to mnè ditù i knaan dnagit mana salngad di ta gsulat di Tnalù i Dwata, manan, ‘Banlén ale knaan mdà di langit du fkaanan dale.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bay man Dyisas di dale, “Too ti glut i man-gu di gamu, ise ku Mosis i mlé knaan atù mdà di langit, bay Màgu i gal mlé i too knaan mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Du yé knaan blé Dwata dunan i tufa mdà di langit na mlé nawa di dad to di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Taman, manla di kenen, “E Sér, sigim gami banlé i knaan manam ayé.” ");
INSERT INTO bpr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na man Dyisas di dale, “Do sa i knaan mlé nawa. Nè i to salu di do, ta là ti bitilan, na nè i to ftoo di do, ta là malinuman. ");
INSERT INTO bpr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Bay ta man-gu di gamu, balù ta teenyu agu, knèan sana là kaftooyu. ");
INSERT INTO bpr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bay i kdee dad to blé Mà di do, salu ale di do, na nè i to salu di do, là sa nang agu dun. ");
INSERT INTO bpr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na ise ku yé duen-gu tufa mdà di langit ku nimògu i do knayè, bay nimògu i knayè i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na ani knayèan, nang nun flanahgu balù satu di kdee dad to blén di do, du yé kayèan ku sdulêgu ale nték di fulé du. ");
INSERT INTO bpr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Du ani knayè i Màgu na kdee meye di do i Ngàan na ftoo di do, gamdawat nawa landè sen, na ntékgu ale kadang di fulé du.” ");
INSERT INTO bpr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mungag i dad Dyu du man Dyisas, “Do i knaan tufa mdà di langit.” ");
INSERT INTO bpr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Manla, “Ise kenen kè Dyisas, i ngà Dyosip? Dilèto sa màan na yêan. Na kan ku manan kenen tufa mdà di langit?” ");
INSERT INTO bpr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na yé duenam man, man Dyisas di dale, “Nang gamu sigi mungag. ");
INSERT INTO bpr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Landè to gsalu di do silang ku Mà, i mdek do, mebe kenen, na do i mték dun di fulé du. ");
INSERT INTO bpr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ta smulat i dad tugad i Dwata, manla, ‘I kdee dad to, tdò Dwata ale,’ taman, nè i to flinge na gamwè tdò mdà di ku Mà salu di do. ");
INSERT INTO bpr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Na ise ku yé kayègu man ku ta nun to lmen mite ku Mà, du lo do i mdà di Dwata i ta mite ku Mà. ");
INSERT INTO bpr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Too ti glut i man-gu di gamu, nè i ftoo, nun nawan landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Do sa i knaan mlé nawa. ");
INSERT INTO bpr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I dad gutambulyu, kmaan ale mana di banwe landè to mnè ditù, bay knèan mati ale. ");
INSERT INTO bpr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bay mahal i knaan tufa mdà di langit, du nè i to kmaan dun, là sa matin. ");
INSERT INTO bpr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Do sa i knaan tufa mdà di langit, i mlé nawa. Na nè i to kmaan i knaan ani, mlawil kel di landè sen. Na yé knaan blégu dunan i lawehgu du fye mlawil i dad to di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na yé gumdàan too minit kasbalew i dad Dyu, manla, “Dét kibò i to ani mlé di gito i lawehan du knaanto?” ");
INSERT INTO bpr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na man Dyisas di dale, “Too ti glut i man-gu di gamu, ku là knaanyu i ungad i dnagit Ngà To, na ku là ninumyu i litèan, là gamdawat gamu nawa. ");
INSERT INTO bpr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bay nè i to kmaan i ungadgu na minum i litègu, ta nun nawan landè sen, na ntékgu kenen di fulé du, ");
INSERT INTO bpr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","du i ungadgu too glut knaan, na i litègu too glut ninum. ");
INSERT INTO bpr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na nè i to kmaan i ungadgu na minum i litègu, mnè kenen di do na lê agu mnè di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yé mdek do Mà, dunan gutambul i nawa, taman, lê nun nawagu mdà di kenen. Na nè i to kmaan do, nun nawan fagu di do. ");
INSERT INTO bpr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yé knaan mdà di langit. Là ti salngadan di mana knaan i dad gutambulyu di munan du balù kmaan ale, knèan mati ale. Bay nè i to kmaan i knaan man-gu ani, mlawil kel di landè sen.” ");
INSERT INTO bpr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yé man Dyisas di katdòan di gumnè gal gustifun i dad Dyu di Kapernaum. ");
INSERT INTO bpr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na kanto linge dademe dad to gal tdò Dyisas i manan ayé, manla, “Too blat kastulen ani, na too mlimah dmawat dun.” ");
INSERT INTO bpr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tadèan gadè na mungag ale gablà di manan gine, na manan di dale, “Kan? Gamfatno nawayu kè i man-gu ani? ");
INSERT INTO bpr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kaflingenta dun, ku teenyu agu, i dnagit Ngà To magket samfulê di gumdàgu, sana katno i nawayu fa? ");
INSERT INTO bpr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lo i Tulus Dwata gamlé nawa, ise ku gnagan i dad to. I dad tnalù man-gu di gamu, mdà di Tulus i Dwata, na gamlé lawil. ");
INSERT INTO bpr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bay nun dademe di gamu là ftoo.” (Yé man Dyisas du mdà di kagatbùan, ta sanan gadè ku simto i dad to là ftoo di kenen, na ku simto i fan makal kenen di fati). ");
INSERT INTO bpr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na lê kenen talù, manan, “Yé duen-gu man di gamu landè to gsalu di do silang ku kdàan di ku Mà.” ");
INSERT INTO bpr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Taman, dee dad to galan tdò tmagak kenen, na ta là magin ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Na yé duenam man, snalek Dyisas i sfalò lwe, manan, “Na, gamu? Lêyu agu tnagak kè?” ");
INSERT INTO bpr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Na tmimel Simon Piter, manan di ku Dyisas, “Amu, landè dademe gusalumi ku là di ge, du ge gumdà i dad tnalù mlé nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta ftoo gami, na ta gadèmi na ge i Mtiu mdà di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na man Dyisas di dale, “Do i malék gamu dad sfalò lwe, bay knèan i satu di gamu nun busawan.” ");
INSERT INTO bpr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yé manan ani Dyudas, satu di dad sfalò lwe, i ngà Simon Iskariyot, i fan makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kafnge ayé, lanngab Dyisas i probinsya Galili. Ta là mayèan lamngab di Dyudiya du fanngabal kenen i dad ganlal i dad Dyu du kayèla fnati. ");
INSERT INTO bpr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na ta mdadong nan i kimò dad Dyu Fista i dad Slung. ");
INSERT INTO bpr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na yé duenam man, stulen i dad flanekan di kenen, manla dun, “Tnagakam i banwe ani, na salu ge ditù di Dyudiya du fye teen i dad to galam tdò i dad tnikeng nimòam. ");
INSERT INTO bpr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Du ku nun to knayèan dilè i dad to, là ti bunin i dad nimòan. Na ge, du gaganam mimò i kdee dad tnikeng ani, fitem i kgaganam di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Yé man dad flanekan du là fa ftoo ale di kenen). ");
INSERT INTO bpr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bay man Dyisas di dale, “Là fa kel i bang kfitegu i kdatahgu. Bay gamu, balù dét oras fakayyu nimò i knayèyu. ");
INSERT INTO bpr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I dad to nfun i banwe ani, là nang nawala gamu, bay do i knangla du sigigu fite di dale i ksasè i dad nimòla. ");
INSERT INTO bpr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Muna gamu gatù nan di fista. Là tayò agu do gatù du là fa kel i banggu.” ");
INSERT INTO bpr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Di kafngen man ayé, ftagak kenen déé di Galili di là mlo. ");
INSERT INTO bpr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kanto gatù i dad flanekan di fista, yé klo Dyisas lê salu gatù, na là toon fgadè dun. ");
INSERT INTO bpr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bay fanngabal kenen i dad ganlal i dad Dyu déé di fista, na too ale smalek, manla, “Ta nè gumnè Dyisas?” ");
INSERT INTO bpr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na nun dee dad to déé sutab gablà ku Dyisas. Yé man dademe, “Fye kenen to,” bay man dademe, “Ise glut ayé, bay lon fan-gaw i dad to.” ");
INSERT INTO bpr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bay landè to mlas tmulen i fandaman gablà ku Dyisas, du likò ale di dad ganlal i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na mdadong di kagatngà i fista, salu Dyisas di Gumnè Gal Gumangamfù di Dwata, du tamdò. ");
INSERT INTO bpr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na too tikeng i dad ganlal i dad Dyu, na manla, “Kan ani ku too gmadè i to ani, na blaam landè skulan?” ");
INSERT INTO bpr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na tmimel Dyisas, manan, “Ise ku do gumdà i tdògu, bay yé gumdàan di Dwata, i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Du nè to mayè mimò knayè i Dwata, gadèan ku nè gumdà dad tdògu, ku mdà di Dwata, ku demen lo mdà di do kto. ");
INSERT INTO bpr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Du nè to talù mdà di kenen kto, yé kayèan ku dag i dad to kenen. Bay i to mayè ku magdayen i mdek dun, gsalig na là ti tmulenan kéng. ");
INSERT INTO bpr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Dunan sa, Mosis i mlé gamu i uldin Dwata, bay landè satu di gamu mimen dun. Kan ku nusalyu agu fnati?” ");
INSERT INTO bpr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na tmimel i dad to ayé, manla, “Keng ta nun busawam. Simto kè i musal fmati ge?” ");
INSERT INTO bpr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Na tmimel Dyisas, manan dale, “Lo satu i tnikeng nimògu, bay ta too ti tikeng i kdeeyu. ");
INSERT INTO bpr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ta dek Mosis gamu fimò ilè di laweh i dad ngàyu lagi, bay blaam ise kenen i too gumdàan, bay mdà di dad gutambulyu. Taman, galyu fimò ilè di laweh i dad ngàyu, balù di Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ku fimò gamu ilè di dad ngàyu di Du Kaftud mdà di kimenyu i uldin Mosis, kan ku lanbutyu agu di kafgulêgu i satu to di Du Kaftud? ");
INSERT INTO bpr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ta nang gamu mukum mdà di teen i matayu. Yé fye ku glalò di too glut kukum.” ");
INSERT INTO bpr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na stulen dademe to déé di Dyérusalém, manla, “Sawe dunan ani i to fanngaballa du knayèla fnati. ");
INSERT INTO bpr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bay neyeyu. Ta talù kenen di bleng i dad to, na landè talù balù satu ku kamnang dun. Keng ta gadè dad ganlalto na kenen i Mgalék Dwata? ");
INSERT INTO bpr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bay ku ta kel i Mgalék Dwata, landè to gmadè ku nè gumdàan, bay to ani, gadèto i gumdàan.” ");
INSERT INTO bpr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na di katdò Dyisas di Gumnè Gal Gumangamfù di Dwata, falbongan i talùan, manan, “Ta tooyu agu dilè kè, na ta tooyu gadè ku nè gumdàgu? I ksalugu dini, ise ku mdà di do knayè. I mdek do, too glut kenen, bay là dnilèyu dun. ");
INSERT INTO bpr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bay do, dilègu kenen du kenen sa i gumdàgu na kenen i mdek do.” ");
INSERT INTO bpr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Taman, tilewla kamfè kenen, bay landè gaganla nimò du là fa kel i bangan. ");
INSERT INTO bpr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dee dademe to ftoo di kenen, na manla, “Di kakel i Mgalék Dwata, là ti midul i dad tnikeng nimòan di nimò i to ani.” ");
INSERT INTO bpr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na linge dad Farisi i ksutab i kdee dad to gablà ku Dyisas. Taman, i dad Farisi na i dad ganlal di kafaglut i dad Dyu, mdek ale dad sundalu du kanfèla Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yé duenam man, man Dyisas di dad to stifun déé, “Ta là mlo i knègu di safédyu du ta fan agu samfulê di mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na ku ta mdà agu, balù ku fanngabalyu agu, knèan là teenyu agu, du là ti gafat gamu di gusalugu.” ");
INSERT INTO bpr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Taman, sasalek dad ganlal i dad Dyu, manla, “Nè fan gusalu i to ani kè du manan là teento dun? Keng salu ditù di banwe i dad Grik gumnè i dademe Dyu du lê tamdò di dad to ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Du yé sa manan gine, ‘Ku ta mdà agu, balù ku fanngabalyu agu, knèan là teenyu agu, du là gafat gamu di gusalugu.’ Dét i kayèan man ayé?” ");
INSERT INTO bpr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na i gusen du di fista ayé, yé too mabtas du. Na di du ayé, tadag Dyisas, na falbongan i talùan, manan, “Nè to malinum, salu di do na minum. ");
INSERT INTO bpr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Du ani gsulat di Tnalù Dwata, ‘Mdà di nawa i to ftoo di do, samfut di kenen éél mlé nawa.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(I éél manan ayé dunan i guflingen di Tulus Dwata ta fan gdawat i dad to ftoo di kenen. Bay di du atù, là fa gablé i Tulus Dwata du là fa too gdawat Dyisas i kdatahan). ");
INSERT INTO bpr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na dee dad to lminge i man Dyisas ayé, manla, “Dunan ani Tugad i Dwata sanfatanto.” ");
INSERT INTO bpr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na man dademe, “Ani i Mgalék Dwata.” Bay man dademe, “I Mgalék Dwata, ise ku mdà di Galili, ");
INSERT INTO bpr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","du yé ta gsulat di Tnalù Dwata na i Mgalék Dwata i satu bel Harì Dabid, na yé gusutan di Bétléhém, dunan i lunsud gumnè Dabid di munan.” ");
INSERT INTO bpr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taman, sahal fandam i dad to gablà ku Dyisas, ");
INSERT INTO bpr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","na mayè dademe to kamfè kenen, bay landè gaganla nimò. ");
INSERT INTO bpr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na samfulê i dad sundalu di dad Farisi na i dad ganlal di kafaglut i dad Dyu, na snalek i dad ganlal ale, manla, “Kan ku là nebeyu dun dini?” ");
INSERT INTO bpr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na tmimel i dad sundalu ayé, manla, “Landè to lmen talù salngad kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na smalek dad Farisi, manla, “Kan kè? Ta lê gamu mafgaw? ");
INSERT INTO bpr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ta nun kè gadèyu to mdà di dad ganlal i dad Dyu, ku demen mdà di dad Farisi ku ftoo di kenen? ");
INSERT INTO bpr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Landèan, bay lo yé ftoo di kenen i dad to là gmadè i uldin Dwata fagu di ku Mosis, taman, falnayam Dwata ale.” ");
INSERT INTO bpr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na déé Nikodimus, i satu Farisi i ta salu di ku Dyisas di munan. Manan, ");
INSERT INTO bpr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bay di dad uldin Dwata di gito, silang nukum satu to ku ta lingeto i dad tdòan, na ku ta teento i dad nimòan.” ");
INSERT INTO bpr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bay tmimel ale, manla di kenen, “Kan? Lê ge mdà di Galili kè? Toom bnasa i ta gsulat di Tnalù Dwata du fye gadèam na landè tugad i Dwata ku mdà di Galili.” ");
INSERT INTO bpr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na kafnge ayé, kat satu to ta mdà mulê. Bay Dyisas, salu kenen ditù di Bulul Olib. ");
INSERT INTO bpr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kanto mték flafus di tmadol du, samfulê Dyisas di Gumnè Gal Gumangamfù di Dwata. Na nun dee dad to salu di kenen, na yé duenam man, ta sudeng du tdòan ale. ");
INSERT INTO bpr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na di laman tamdò, ta kel dad to gal tamdò i dad uldin Dwata fagu di ku Mosis na i dad Farisi, na nebela di ku Dyisas i satu libun gumahla di klafàan i yaanan di satu lagi, na ftadagla di bleng i dad to. ");
INSERT INTO bpr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na manla di ku Dyisas, “E Sér, ta gumahmi i libun ani di satu lagi. ");
INSERT INTO bpr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Di uldin Dwata fagu di ku Mosis di gito, manan ndak batu i mimò salngad ani kel di kfatin. Na dét i ge man?” ");
INSERT INTO bpr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Manla ayé du limanla ku Dyisas, fye nun gumdàla tmifù kenen. Bay baling lkatot Dyisas, na smulat di tanà, gnamitan i tnalòan. ");
INSERT INTO bpr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bay sana ktadagla déé du sigi ale smalek fa, na yé duenam man, ta lê tadag Dyisas, na manan di dale, “Nè i to landè salà di gamu, yé muna mdak dun batu.” ");
INSERT INTO bpr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na lê kenen lkatot, na smulat di tanà. ");
INSERT INTO bpr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na kantola linge i man Dyisas ayé, sginut ale mdà. Yé muna mdà i dad tua, klo i dademe. Na ta lo yé tagak déé Dyisas na i libun ayé. ");
INSERT INTO bpr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na ta lê tadag Dyisas na manan di libun ayé, “E bì, ta nè gumnè i dad to mayè falmayam ge? Ta landè tagak kè?” ");
INSERT INTO bpr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na tmimel i libun ayé di ku Dyisas, manan, “Ta landèan, Sér.” Na man Dyisas di kenen, “Ku yé, balù do, là sa falnayamta ge. Mulê ge na ta nang ge mimò salà.” ");
INSERT INTO bpr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na lê talù Dyisas di dad to stifun déé, manan, “Do i Salò mneng di dad to di klamang banwe. Nè i to lmalò di do, là sa magun di gukmifuhan, bay ta déé di kenen neng i Salò mlé nawa.” ");
INSERT INTO bpr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Taman, man dad Farisi di ku Dyisas, “Lom satu tmulen gablà di ktom. Là gablà fantoo dun.” ");
INSERT INTO bpr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na tmimel Dyisas, manan di dale, “Balù ku logu satu i tmulen gablà di ktogu, slame glut i kdee tulen-gu du gadègu i gumdàgu na i gusalugu. Bay gamu, là gadèyu i gumdàgu na i gusalugu. ");
INSERT INTO bpr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ku mukum gamu, yé gufdàyu dun di kfagu i to tanà, bay do, landè nukumgu, balù simto. ");
INSERT INTO bpr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bay ku do i mukum, tadè i kukumgu, du ise ku logu satu i mukum, bay lwe gami Mà, i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na ta gsulat di uldin ta blé Dwata di gamu na ku masalngad i tulen lwe to, glut i tulenla. ");
INSERT INTO bpr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tmulen agu gablà di ktogu, na Mà i mdek do, lê kenen tmulen gablà di do.” ");
INSERT INTO bpr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Taman, too ale smalek, manla, “Nè gumnè i Màam?” Na tmimel Dyisas, manan, “Là dilèyu agu, na là lêyu dilè Mà, du ku ta dilèyu agu, lêyu dilè Mà.” ");
INSERT INTO bpr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Man Dyisas i kdee ani di katdòan di lam Gumnè Gal Gumangamfù di Dwata di gugkah i galla guftatek filak blé di Dwata. Bay blaam, landè to gamkfè dun du là fa kel i bangan. ");
INSERT INTO bpr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na lê man Dyisas di dad Dyu, “Nun du, mdà agu, na fanngabalyu agu, na mati gamu di kagsalàyu. Yé duenam man, là gafat gamu di gusalugu.” ");
INSERT INTO bpr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yé duenam man, sasalek i dad ganlal i dad Dyu ayé, manla, “Dét gumtatek i manan ayé, ‘Là gafat gamu di gusalugu?’ Kan? Fan kenen mikat lial kè?” ");
INSERT INTO bpr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na man Dyisas di dale, “To tanàyu gamu, bay do, yé gumdàgu di tah langit. Yé gumdàyu di banwe ani, bay do, ise. ");
INSERT INTO bpr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yé duen-gu man di gamu na mati gamu di kagsalàyu. Na too gdohò ayé ku là fantooyu na ‘Do sa Dunan Do.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na toola kenen snalek, manla, “Simto ge kè?” Na tnimelan ale, manan, “I ta sanagu tulen di gamu sa di muna. ");
INSERT INTO bpr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dee fa kayègu man na nukum di gamu. Bay too glut i mdek do, na nè i lingegu di kenen, yé tulen-gu di dad to di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na là glabatla na yé manan di dale i Màan. ");
INSERT INTO bpr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na lê talù Dyisas, manan dale, “Ku ta nketyu agu, i dnagit Ngà To, yé kloyu gmadè na ‘Do sa Dunan Do,’ na lêyu gadè na landè nimògu di logu satu, na lo yé tulen-gu i tdò Mà do. ");
INSERT INTO bpr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na fikit di do i mdek do. Là ti bayàan agu di logu satu, du yé nimògu i gamflehew kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nun dee to lminge i dad manan ta ftoo di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Taman, man Dyisas di dad to ftoo di kenen, “Ku fkahyu di nawayu i Tnalùgu, na nimenyu, ta mbaling gamu dad to tdògu. ");
INSERT INTO bpr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na gadèyu i kaglut, na i kaglut falwà gamu di kagfasakyu.” ");
INSERT INTO bpr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bay manla di kenen, “Dad bel Abraham gami, na landè lmen fmasak gami. Kan ku manam galwà gami di kagfasakmi?” ");
INSERT INTO bpr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na tmimel Dyisas, manan di dale, “Too ti glut i man-gu di gamu, nè to gamsalà, fasak i salà. ");
INSERT INTO bpr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I fasak, là ti glaman di familya, bay i ngà, glam kenen kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yé duen-gu man ku yé mlé gamu kagalwà Ngà i Dwata, too ti glut galwà gamu. ");
INSERT INTO bpr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gadègu na gamu i dad bel Abraham, bay knèan tooyu agu kayè fnati du là mnab i Tnalùgu di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yé man-gu i fite Mà do, bay yé nimòyu gamu, i man màyu gamu.” ");
INSERT INTO bpr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na manla di ku Dyisas, “Abraham sa i gutambulmi.” Bay man Dyisas di dale, “Ku glut gamu dad bel Abraham, ta lalòyu moon i dad nimòan. ");
INSERT INTO bpr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yé logu nimò tulen-gu gamu i kaglut mdà di Dwata, bay blaam kayèyu agu fnati. Bay ise yé sa i nimò Abraham kenen. ");
INSERT INTO bpr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yé duenam man, salngad nimòyu màyu.” Na manla di kenen, “Ise gami ngà magu dungan, bay lo satu i Màmi, dunan Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Bay man Dyisas di dale, “Ku glut, na Dwata Màyu, ta kanbongyu agu nawa du salu agu dini mdà di Dwata. I ksalugu dini, ise do knayè, bay dekan agu. ");
INSERT INTO bpr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dét i duenyu là galmabat i tdògu? Yé duenan du là flinge gamu di man-gu. ");
INSERT INTO bpr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Du dad ngà gamu i màyu Satanas, na yé galyu nimen i sasè knayè màyu. Mdà di kagatbùan, sigi kenen manò, na là lmenan msen i kaglutan du landè sa kaglut déé di kenen. Ku tmulen kéng, lon lalò i kenen kagkah du sigi tmulen kéng, du kenen gutambul i kdee kéng. ");
INSERT INTO bpr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bay do, yé tulenta gamu i kaglutan, na yé duenam man, là fantooyu agu. ");
INSERT INTO bpr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nun di gamu kè lmen mite do gamsalà? Ku yé man-gu i kaglutan, kan ku là ftoo gamu di do? ");
INSERT INTO bpr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","I ngà Dwata, flinge di Tnalù Dwata. Bay gamu, ise gamu dad ngà Dwata, na yé duenyu là flinge.” ");
INSERT INTO bpr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na lê tmimel i dad Dyu, manla, “Là kè glut i manmi na yé gumdàam di Samarya, na nun busawam?” ");
INSERT INTO bpr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na tmimel Dyisas, manan, “Landè busawgu do. Di kaglutan, galgu nafè Mà, bay balingyu agu too fyà. ");
INSERT INTO bpr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ise ku yé fanngabalgu i kdayen i dad to. Bay yé knayè i Dwata ku dnayen i dad to agu, na kenen sa i mukum. ");
INSERT INTO bpr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na too ti glut i man-gu di gamu. Nè i to toon fkah di nawan i Tnalùgu, là matin.” ");
INSERT INTO bpr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bay man i dad Dyu di kenen, “Ani ta too mbateng di gami na nun busawam. Ta mati Abraham na i dad tugad i Dwata di munan, bay knèan, balingam man, ‘Nè i to toon fkah di nawan i Tnalùgu, là matin.’ ");
INSERT INTO bpr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kan? Mdatah ge di ku Abraham, i gutambulmi? Ta mati kenen na i dad tugad Dwata. Di fandamam, simto ge kè?” ");
INSERT INTO bpr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na man Dyisas di dale, “Ku do dmayen i ktogu, landè btasan. Bay yé dmayen do Mà, i manyu Dwatayu. ");
INSERT INTO bpr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Là ti dilèyu kenen, bay do, dilègu. Ku yé man-gu là dilègu dun, ta tmulen agu kéng gambet gamu. Bay di kaglutan, dilègu kenen, na nimen-gu Tnalùan. ");
INSERT INTO bpr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I gutambulyu Abraham, lehew kenen mite i du ksalugu dini. Na di kiten dun, too kenen lehew.” ");
INSERT INTO bpr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na man i dad Dyu di kenen, “Là fa gafat ge lime falò fali, na yé manam ta teenam Abraham?” ");
INSERT INTO bpr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na man Dyisas di dale, “Too ti glut i man-gu di gamu, di là fa sut Abraham ta sana Do sa i Dunan Do.” ");
INSERT INTO bpr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yé duenam man, mulut ale batu du ndakla kenen. Bay salbuni Dyisas, na tnagakan i Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na di lam Dyisas magu, nun teenan satu lagi butè mdà di ksutan. ");
INSERT INTO bpr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na smalek i dad to gal tdò Dyisas, manla, “E Sér, dét duen i to ani sut butè? Simto gamsalà, kenen ku dad tuan?” ");
INSERT INTO bpr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na tmimel Dyisas, manan, “Ise ku yé duenan sut butè ku mdà di salàan ku demen mdà di salà i dad tuan. Bay yé duenan du fye teen i kaltulus Dwata fagu di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Di tlabo mdu, tooto nimò i fimò mdek do, du ku ta kel i kifuh, ta landè kibòto mimò. ");
INSERT INTO bpr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Di lamgu dini di tah tanà, do i Salò mneng di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Na kafnge Dyisas man ayé, dmulà kenen di tanà, na sanboolan tanà i dulàan mimò fitak, na lunalan di mata i to butè ayé. ");
INSERT INTO bpr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na dekan i butè, manan, “Mdà ge, na flauf ge di Lanaw Silom.” (Yé gumtatek Silom, “Mdek.”) Na ta mdà i to ayé, na flauf. Na di kulêan, ta mite kenen. ");
INSERT INTO bpr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mdà i dademen saldan na i dad to gal mite dun mni di laman là fa mite, kantola teen kenen, manla, “Ise ani to gal sudeng na mni?” ");
INSERT INTO bpr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na man dademe, “Hee, dunan sa ayé.” Bay man dademe, “Ise kenen, bay lo salngad bawehla.” Bay man i to ayé, “Dunan, do sa.” ");
INSERT INTO bpr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Taman, snalekla kenen, manla, “Dét i duenam ta mite?” ");
INSERT INTO bpr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na tmimel kenen, manan, “Satu lagi, yé dagitan Dyisas, mimò kenen fitak, na lunalan di matagu, na dekan agu flauf di Silom. Na kantogu flauf, ta mite agu.” ");
INSERT INTO bpr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Na lêla kenen snalek, manla, “Ta nè gumnè i to manam ayé?” Na manan di dale, “Wanta. Ta là gadègu dun.” ");
INSERT INTO bpr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kafnge ayé, nebela i to ayé salu di dad Farisi. ");
INSERT INTO bpr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na yé du Dyisas mimò i fitak du fan-gulêan i to butè dunan i Du Kaftud i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Taman, lê smalek i dad Farisi i gumdàan mite, na manan di dale, “Lnunalan fitak i matagu, na flauf agu, na ani ta mite agu.” ");
INSERT INTO bpr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na yé man i dademe dad Farisi déé, “Ise mdà di Dwata i lagi ayé, du là nimenan i uldin Dwata gablà di Du Kaftud.” Bay yé man dademe, “Dét kgagan i to gamsalà mimò tnikeng salngad ani?” Na là salngad fandam i dad Farisi gablà ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na kafnge ayé, lêla snalek i to ayé, manla, “Dét i gmanam gablà di kenen du ta manam sa kenen famgulê i matam?” Na tmimel kenen, manan, “Kenen sa satu tugad i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bay là ftoo dad ganlal i dad Dyu ku i to ayé tagnè butè, bay ani ta mite, silang ta fngéla i dad tuan. ");
INSERT INTO bpr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na snalekla i dad tuan, manla, “Ani kè i ngàyu, i manyu tagnè butè mdà di ksutan? Kan ani ku ta mite?” ");
INSERT INTO bpr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na tmimel dad tuan, manla, “Glut ngàmi kenen, na glut sut butè, ");
INSERT INTO bpr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","bay i gumdàan mite, là gadèmi dun. Na là gadèmi ku simto i famgulê dun. Fye ku kenen i snalekyu du ta bong kenen, na fulung tmimel gablà di kton.” ");
INSERT INTO bpr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yé duen i dad tuan tmimel gambet ayé du likò ale di dad ganlal i dad Dyu du ta sansatula i nawala di kmanla dun, na ku nè i to man dun na Dyisas i Mgalék Dwata, ta là dnilèla dun mimbro di gumnè gustifun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Na yé duen i dad tuan man dun gine, “Ta bong kenen. Fye ku kenen i snalekyu.” ");
INSERT INTO bpr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na yé duenam man, ta lêla tlo i to ayé, manla dun, “Tulenam i kaglutan di kanfe Dwata, du gadèmi i to ayé lo satu to gamsalà.” ");
INSERT INTO bpr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na tmimel i to ayé, manan, “Là gadègu ku gamsalà kenen ku demen là. Lo yé gadègu, di munan butè agu, bay ani ta mite agu.” ");
INSERT INTO bpr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na lêla kenen snalek, manla, “Dét i nimòan di ge? Dét i kibòan mukà matam?” ");
INSERT INTO bpr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na tmimel kenen, manan di dale, “Ta tulenta gamu sa, bay là flinge gamu. Dét duenyu lê mayè flinge? Kan? Mayè gamu mgimò dad tdòan?” ");
INSERT INTO bpr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na mdà di kalbutla, ta nadoyla kenen, manla, “Ge i satu tdòan, bay gami i dad tdò Mosis. ");
INSERT INTO bpr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gadèmi ta talù Dwata di ku Mosis, bay i to ayé, balù i gumdàan, là gadèmi dun.” ");
INSERT INTO bpr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na tmimel i to ayé, manan, “Too tnikeng ani sa, du là gadèyu i gumdàan, bay ta nukàan i matagu. ");
INSERT INTO bpr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Na gadèto i Dwata, là falningen i dad to gamsalà, bay lo yé falningen i dad to mafè kenen, na lmalò di knayèan. ");
INSERT INTO bpr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mdà di kagatbù i banwe, landè lmento linge ku nun gmagan mukà mata i to sut butè. ");
INSERT INTO bpr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Landè gnagan i to ani nimò, ku là mdàan di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na manla di kenen, “Tagnè ge too gamsalà mdà di ksutam, na là gtenan ku ge tamdò gami.” Na ta falwàla kenen mdà di gumnè gustifun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na ta linge Dyisas na ta falwàla i to ayé mdà di gumnè gustifun i dad Dyu. Na kanton teen kenen, ta snalekan, manan dun, “Fantoom kè i Ngà To?” ");
INSERT INTO bpr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na tmimel kenen, manan, “Sér, tulenam do ku simto kenen du fye ftoo agu di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na man Dyisas di kenen, “Ta teenam sa Ngà To, du dunan i demem stulen ani.” ");
INSERT INTO bpr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na manan di ku Dyisas, “Fantoota ge, Amu,” na mangamfù kenen di kanfe Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na man Dyisas, “Salu agu dini di tah tanà du mukum. Nè i to là mite, tnabenggu kenen fye mite. Bay nè i to man nawan ta mite, bnutègu.” ");
INSERT INTO bpr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na nun dademe Farisi magin di to ayé, na kantola linge i man Dyisas ayé, ta manla di kenen, “Kan? Lê gami butè?” ");
INSERT INTO bpr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na man Dyisas di dale, “Ku too glut butè gamu, landè moon salàyu. Bay du manyu mite gamu, taman sana knun salàyu. ");
INSERT INTO bpr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Too ti glut i man-gu di gamu, nè to là magu di bà takab i kukub dad bilibili, bay baling mkef, i to ani tmaku na tulisan. ");
INSERT INTO bpr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bay i to fusuk di bà takab i kukub dad bilibili, kenen mifat dale. ");
INSERT INTO bpr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na mdà i to mantay takab, nukàan du fafusukan i to mifat dad bilibili. Na falninge dad bilibili i talùan, na tlon dagit i kat satu bilibilin, na nalakan ale lamwà. ");
INSERT INTO bpr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na di kalakan dale lamwà, mnè kenen tukè munala, na tmadol dad bilibili ani di kenen, du ta dilèla sa i talùan. ");
INSERT INTO bpr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bay là ti tmadol dad bilibili ani di mahal to, bay baling ale milah du là dilèla i talùan.” ");
INSERT INTO bpr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yé fléd tulen Dyisas di dad to, bay knèan là glabatla i gumtatekan. ");
INSERT INTO bpr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Taman, ta lê talù Dyisas di dale, manan, “Too ti glut i man-gu di gamu, na do sa bà takab kukub i dad bilibili. ");
INSERT INTO bpr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I kdee dad muna di do salu dini, dad tmaku na tulisan. Taman, là falninge dad bilibili i talùla. ");
INSERT INTO bpr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Do sa bà takab du nè to fusuk fagu di do, galwà di dad salàan. Fusuk kenen, na lamwà di kukub du fye mite gumateban. ");
INSERT INTO bpr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yé duen i to tmaku salu dini du tmaku, na fmati, na falmo. Bay do, salu agu dini du fye gamdawat dad to i nawa too fnò. ");
INSERT INTO bpr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Do i fye mifat dad bilibili du i fye mifat, gatlagad mlé i kton di fati du mdà di dad bilibili. ");
INSERT INTO bpr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I to snukéy mifat dad bilibili na ise kenen mfun dale, di kiten i tuyun salu di dad bilibili, milah na tnagakan ale. Taman, nakét i tuyun ale, na sanbalétan ale. ");
INSERT INTO bpr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yé duenan milah du lo kenen snukéy, na là mabtas i dad bilibili di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Do i fye mifat dad bilibili. Ku nè kasdilèmi Mà, salngad ayé kasdilèmi dad bilibiligu, na gatlagad agu mlé i ktogu di fati du mdà di dale. ");
INSERT INTO bpr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lê nun fa dademe bilibiligu, là fa dini ale di lam kukub ani. Yé duenam man, toogu ale lê nebe dini du nifatgu ale. Na flinge ale di talùgu, na mgimò ale lo satu lumbuk, di lo satu mifat dale. ");
INSERT INTO bpr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na bong nawa Mà do, du gatlagad agu mlé i ktogu di fati du fye lêgu gdawat samfulê. ");
INSERT INTO bpr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Landè to gmagan fmati do, bay tadègu tan-gaad mlé i ktogu di fati. Nun kdatahgu mlé dun, na lê nun kdatahgu mawì dun, du ani i dek Mà do.” ");
INSERT INTO bpr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kanto linge dad Dyu i man Dyisas ayé, ta lê sahal i fandamla. ");
INSERT INTO bpr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dee di dale i man dun, “Nun busawan, na ta book. Kan ku flinge gamu di kenen?” ");
INSERT INTO bpr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bay yé man dademe, “I to nun busaw, ise gambet ayé i talùan. Na landè kibò i busaw famgulè i dad butè.” ");
INSERT INTO bpr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nun satu fista dnagit Kaftiu i Bong Gumnè Gumangamfù di Dwata di Dyérusalém, na gaslà di dangan i katno. ");
INSERT INTO bpr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na salu Dyisas di gumnè ayé, na lmalan magu di Balkun Solomon déé. ");
INSERT INTO bpr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na salnibut dad Dyu Dyisas, na manla di kenen, “Kilen kè ktulenam gami i kaglutan? Ku ge i Mgalék Dwata, fbatengam di gami.” ");
INSERT INTO bpr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na tmimel Dyisas, manan, “Ta tulen-gu sa di gamu, bay knèan là ftoo gamu di do. I dad nimògu di dagit Mà, yé tmulen gablà di do. ");
INSERT INTO bpr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bay là sa ftoo gamu du ise gamu dad bilibiligu, ");
INSERT INTO bpr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","du i dad bilibiligu, falningela i talùgu, na dilègu ale, na tmadol ale di do. ");
INSERT INTO bpr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na banlégu ale nawa landè sen, na là ti malmo ale, na landè gamlad dale mdà di lam falelgu. ");
INSERT INTO bpr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mà i mlé dale di do, na too kenen mdatah di kdee, na landè gamlad dale mdà di lam falelan. ");
INSERT INTO bpr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mà na do, lo satu.” ");
INSERT INTO bpr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Taman, lê mulut dad Dyu batu du dakla ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Bay man Dyisas di dale, “Ta dee fitegu di gamu i dad fye nimò ta dek Mà do. Nè kè di dad nimò ani gumdàyu mdak do batu?” ");
INSERT INTO bpr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na tmimel dad Dyu ayé, manla di kenen, “Ise ku dad fye nimòam i duenmi mdak ge. Bay yé salàam nladam i kdatah Dwata, du lo ge to, na fasalngadam i ktom di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bay tmimel Dyisas, manan, “Ta fsulat Dwata fagu di satu tugadan, manan, ‘Gamu i dad dwata.’ ");
INSERT INTO bpr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gadèto na là gsalà i Tnalù Dwata. Ku yé katlon dad to gumlén i Tnalùan dad dwata, ");
INSERT INTO bpr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","na kan ku manyu gablà di do i Mgalék Mà na i dekan dini di tah tanà, na nladgu kdatah i Dwata di logu kman dun do Ngà Dwata? ");
INSERT INTO bpr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taman, nang gamu ftoo di do ku làgu nimò i dad nimò Mà. ");
INSERT INTO bpr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kabay ku ta nimògu i kdee ayé, fantooyu i dad nimògu fye gadèyu na Mà mnè di do, na do, mnè agu di ku Mà.” ");
INSERT INTO bpr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na lêla kanfè moon Dyisas, bay lamwà kenen di blengla. ");
INSERT INTO bpr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na ta lê mdà Dyisas mifal di Dyordan, dunan i gumunyag Dyan di muna, na mnè kenen ditù di là mlo. ");
INSERT INTO bpr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na nun dee dad to salu di kenen, na manla, “Landè tnikeng nimò Dyan di munan, kabay i kdee tulenan gablà di to ani, slame glut.” ");
INSERT INTO bpr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na too dee dad to ditù ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na nun to fandas, yé dagitan Lasarus mdà di Bétani, i lunsud Marta na Méri, i flanekan. ");
INSERT INTO bpr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Dunan ani i Méri mkok fye bun di blì Dyisas, na nifun wakan. Na kenen sa i libun Lasarus. ");
INSERT INTO bpr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Taman, ta febe Méri na Marta i tulen ani di ku Dyisas, “Fandas i flanekam toom deme sakdo.” ");
INSERT INTO bpr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na kanto linge Dyisas ayé, manan, “Ise yé gukel i fdas ani ku fati, bay yé gukelan ani du fye magdayen i Dwata, na lê magdayen Ngà i Dwata fagu dini.” ");
INSERT INTO bpr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kando Dyisas Marta na Méri na Lasarus. ");
INSERT INTO bpr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kanton linge fandas Lasarus, funan baling fanak déé lwe butang klon gatù di dale. ");
INSERT INTO bpr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na kafnge ayé, man Dyisas di dad to galan tdò, “Samfulê ato di Dyudiya.” ");
INSERT INTO bpr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bay man dad to galan tdò di kenen, “Sér, falami ani kayè i dad Dyu mdak ge batu. Na kan ku kayèam samfulê ditù?” ");
INSERT INTO bpr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na tmimel Dyisas, manan, “Yé sa galyu man sfalò lwe oras di sdu? Taman, i to magu di mdu, là ti gsungkulan du malwa sa. ");
INSERT INTO bpr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bay ku kifuh i kagun, gsungkul du kmifuh sa.” ");
INSERT INTO bpr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yé man Dyisas, kafnge ayé lêan man, “Ta kudang i flanekto, Lasarus, bay gatù agu du fye nukatgu kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na tmimel dad to galan tdò, manla, “Amu, ku lon kudang, mgulê kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bay yé knayèan fgadè na ta mati Lasarus, na man nawala ku lo btal kakudang i man Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Na yé duenam man, ta fbateng Dyisas di dale, manan, “Ta mati nan Lasarus. ");
INSERT INTO bpr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Du mdà di gamu, lehew agu du là gumahgu kenen mto du fagu dini fye ftoo gamu. Mdà ato nan gatù di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na talù Tomas, i dnagitla Sfangê, manan di dademen to gal tdò Dyisas, “Mdà ato nan gatù fye magin ato mati di Amuto.” ");
INSERT INTO bpr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kanto kel ale Dyisas di Bétani, ta gadè Dyisas na ta sana fat butang Lasarus ditù di lam lbang. ");
INSERT INTO bpr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mdadong Bétani di Dyérusalém, nun tlu kilumitru kè i kawagan. ");
INSERT INTO bpr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na nun dee dad Dyu lmauy dale Marta na Méri du lnalala ale du mdà di kfati i lagila. ");
INSERT INTO bpr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na kanto linge Marta na ta fan kel Dyisas, ta gasil kenen lamwà du snitongan, bay fanak Méri di lam i gumnè. ");
INSERT INTO bpr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na man Marta di ku Dyisas, “E Amu, ku lo ge dini di kafdas i lagigu, là ti matin moon. ");
INSERT INTO bpr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bay gadègu, balù ani, ku dét fnim di Dwata, blén di ge.” ");
INSERT INTO bpr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Na man Dyisas di kenen, “Lê mték sa i lagim.” ");
INSERT INTO bpr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na man Marta di kenen, “Gadègu na mték kenen di fulé du.” ");
INSERT INTO bpr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Bay man Dyisas di ku Marta, “Do i gumdà i kték, na i lawil. Nè i to ftoo di do, balù mati kenen, lê man mték. ");
INSERT INTO bpr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na nè i to mto na ftoo di do, nun nawan landè sen. Fantoom kè i man-gu ani?” ");
INSERT INTO bpr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na tmimel Marta, manan di kenen, “Hee Amu, ftoo agu na ge i Mgalék Dwata, i Ngàan salu dini di tah tanà.” ");
INSERT INTO bpr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na kafnge Marta man dun ayé, ta mdà kenen, na tlon Méri di lo dale, na manan di kenen, “Ta dini Sér, na fanngabalan ge.” ");
INSERT INTO bpr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Di kaklinge Méri, ta tadag, na sagwê lamwà du snitongan Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Là fa gafat Dyisas di lunsud, bay sana kdéén di gusmitong Marta dun. ");
INSERT INTO bpr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na i dad Dyu lmala dale Méri, teenla i ktadag Méri na i kalwàan smitong ku Dyisas, na ta magin ale di kenen du yé man nawala ku lê kenen samfulê di lbang i lagin na mngel ditù. ");
INSERT INTO bpr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na kanto kel Méri di ku Dyisas, di kiten dun, ta lkuad di saféd blì Dyisas, na manan, “E Amu, ku lo ge dini di kafdas i lagigu, là matin moon.” ");
INSERT INTO bpr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na mngel Méri na i dad Dyu magin di kenen. Na kanto teen Dyisas ayé, matdel nawan na too kenen mlidù. ");
INSERT INTO bpr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na smalek Dyisas, manan, “Nè gulambangyu dun?” Klola man, “Flal ge, Amu. Neyem.” ");
INSERT INTO bpr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na mngel Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na kanto teen dad Dyu i kngelan, manla, “Neyeyu, too bong nawan ku Lasarus.” ");
INSERT INTO bpr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bay talù i dademe, manla, “Kenen sa i famgulê i to butè. Là kè gaganan nsang i kfati Lasarus?” ");
INSERT INTO bpr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ta lê matdel nawa Dyisas, na ta gatù di ilib gulambangla ku Lasarus. Yé sangla di bà ilib ayé bong batu. ");
INSERT INTO bpr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Na man Dyisas di dale, “Kahyu i batu ayé.” Na tmimel Marta, i libun i mati ayé, manan, “Amu, ta fat butang i kalbangmi kenen. Ta balok nan.” ");
INSERT INTO bpr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Bay man Dyisas di kenen, “Ta manta ge sa ku ftoo ge, ta kitem i kaltulus Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yé duenam man, ta kahla i batu, klo Dyisas lngalà, manan, “Mà, fasalamat agu di ge du ta falningem agu. ");
INSERT INTO bpr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na gadègu galam agu falninge, bay yé duen-gu man ani du mdà di dad to tadag dini, fye ftoo ale na ge i mdek do.” ");
INSERT INTO bpr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Na kafngen man ayé, ta falbongan talùan, manan, “E Lasarus, lamwà ge.” ");
INSERT INTO bpr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na ta lamwà Lasarus di lbang, maglabéd dad falnas i dad blìan na sigalan, na lê man i masala labéd di bawehan. Taman, man Dyisas di dale, “Nbelyu kenen na faguyu.” ");
INSERT INTO bpr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na dee dad Dyu lmauy dale Méri, kantola teen i nimò Dyisas, ftoo ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bay i dademe, salu ale di dad Farisi, na tulenla dale i dad nimò Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Na yé duenam man, stifun dad ganlal di kafaglut i dad Dyu na i dad Farisi magin di dad mdatah mukum, na stulen ale, manla, “Dét i fye nimòto dé? Ta dee tnikeng nimò i to ayé. ");
INSERT INTO bpr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ku bayàto kenen, ftoo di kenen i kdee dad to, na salu dini dad ganlal di Roma, na lanbàla i Gumnè Gumangamfùto di Dwata, na falmola i banweto.” ");
INSERT INTO bpr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yé ulu i dad ganlal di kafaglut i dad Dyu di fali atù Kayafas. Lê kenen talù, manan, “Too landè gnadèyu. ");
INSERT INTO bpr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Là gadèyu dun kè mas gamfye di gamu ku lo satu mati di kdee to tah di malmo i kdee.” ");
INSERT INTO bpr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I manan ani ise ku mdà di kenen knayè, bay du kenen ulu i dad ganlal di kafaglut i dad Dyu di fali atù, ta falan fgadè na ta fan mati Dyisas di dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na ise ku mati Dyisas lo di dad Dyu, bay yé duenan mati du fye santifunan na sansatun i kdee dad ngà i Dwata ta sbalét. ");
INSERT INTO bpr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na mdà di du atù, mngabal kfagu i dad ganlal i dad Dyu fmati ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na yé duen Dyisas ta là magu di gumite i dee dad Dyu dun, bay baling salu di syudad dnagit Ifraim mdadong di banwe landè to mnè ditù. Na déé gufanakan magin i dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na ta là mlo nan i Fista Du Kaglius, na nun dee dad to mdà di dademe banwe salu di Dyérusalém du fye nimenla i uldin Dwata di dad Dyu gablà di klanebla i ktola di là ale fa mangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na toola fanngabal Dyisas, na sasalek ale di Gumnè Gal Gumangamfù di Dwata, manla, “Dét fandamyu gamu? Là ti salun dini di fista, man?” ");
INSERT INTO bpr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na i dad ganlal di kafaglut i dad Dyu na i dad Farisi, yé fgadèla di dad to, ku nè to mite i gufanak Dyisas, tulenan du kanfèla. ");
INSERT INTO bpr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nam butang gdè klon kel i Fista Du Kaglius, salu Dyisas ditù di Bétani, i banwe Lasarus, i to ta ntékan di fati. ");
INSERT INTO bpr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Fatlagad ale dun knaan. Marta i malel, na magin Lasarus ku Dyisas kmaan. ");
INSERT INTO bpr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na mwè Méri tngà kilu i too mabtas fangbun, na kokan di blì Dyisas, na yé ifun dun wakan. Na lngab i gumnè ayé i kafye bunan. ");
INSERT INTO bpr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na talù Dyudas Iskariyot, satu di dad to gal tdò Dyisas, i to fan makal kenen, ");
INSERT INTO bpr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","manan, “Kan ku là baling fabli i fangbun ani, na blé i wèan di dad to landè knun. Yé btasan fan salngad di sukéy i satu to di sfalin talbahò.” ");
INSERT INTO bpr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ise ku yé duen Dyudas man ayé ku kandon i dad to landè knun, bay du to tmaku kenen, na kenen sa i magot i filak ale Dyisas, na galan nwè i dademen. ");
INSERT INTO bpr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Taman, man Dyisas, “Bayàyu kenen du tagàan ani di du i kalbangla do, ");
INSERT INTO bpr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","du kloyu to site dad to landè knun, bay do, là mlogu di safédyu.” ");
INSERT INTO bpr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na dee dad Dyu, kantola linge na ditù Dyisas di Bétani, ta gatù ale. Na ise ku lo Dyisas i duenla gatù, bay kayèla neye Lasarus, i to ta ntékan mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yé duenam man, i dad ganlal di kafaglut i dad Dyu, lêla santulen i kibò fmati ku Lasarus, ");
INSERT INTO bpr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","du mdà di kenen, ta dee Dyu tmagak i dad ganlalla, na baling ale ftoo ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na di tmadol du, dee dad to ta salu di Fista Du Kaglius di Dyérusalém, lingela ta fan kel Dyisas déé. ");
INSERT INTO bpr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Na mwè ale dad taglang, klola smitong kenen, na mkit ale, manla, “Magdayen i Dwata. Banlé Dwata kafye i To salu dini di dagit i Amu, i Harì di Israél.” ");
INSERT INTO bpr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na yé snakay Dyisas ngà dongki. Taman, gdohò i ta fala fsulat Dwata di munan, manan, ");
INSERT INTO bpr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“E syudad Sayun, nang ge likò. Neyem du ani i Harìam smakay ngà dongki.” ");
INSERT INTO bpr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Di du atù, fa là glabat i dad to gal tdò Dyisas ani, bay kanto mték na magket di langit, ta gafaldamla i ta sulat dad tugad i Dwata na ani kadì nimòla di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na i dad to ta magin ku Dyisas di ktékan ku Lasarus mdà di lbang, ta tulenla i ta mgimò ku Lasarus. ");
INSERT INTO bpr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na ani duen i dee dad to smitong ku Dyisas di dun kel di Dyérusalém du lingela ta nimòan i bong tnikeng ayé. ");
INSERT INTO bpr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Taman, ta stulen dad Farisi, manla, “Neyeyu. Ta landè mgimòto, du ta magin di kenen i kdee.” ");
INSERT INTO bpr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na lê nun dee dad Grik magin di fista di Dyérusalém du mangamfù ale di Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na salu ale di ku Filip, manla dun, “E Sér, kayèmi teen Dyisas.” (Ditù gumdà Filip di Bétsayda glam di Galili). ");
INSERT INTO bpr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na mdà Filip, tulenan ku Andru, na lwe ale salu ku Dyisas du fgadèla di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na tnimel Dyisas ale, manan, “Ta kel i bang too kagdayen i Ngà To. ");
INSERT INTO bpr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Too ti glut i man-gu di gamu, silang mbel i salbatù bnê ku lbang di tanà na mati. ");
INSERT INTO bpr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ku simto kambong nawa i lawilan, knèan ta baling lanah, bay ku simto là kmabas i lawilan dini di tah tanà, gamfun nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nè to mayè fafasak di do, là fakay ku làan tmadol di do, du fye balù ku nè agu, déé kenen di safédgu. Na nè to fafasak di do, dag Mà kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Na ta lê man Dyisas, “Too mlidù i nawagu. Dét i fye man-gu? Fnigu di ku Mà du fye falwàan agu di kaflayam ani? Là fakay, du yé duen-gu salu dini di tah tanà du nagugu i kaflayam ani.” ");
INSERT INTO bpr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na man Dyisas, “Mà, nimòam i gumagdayen i dagitam.” Na nun talù mdà di langit, manan, “Ta dnayen-gu sa i dagitgu, na ani, lêgu man dnayen.” ");
INSERT INTO bpr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na linge i dad to tadag déé i talù ayé, na ta manla, “Ta lmugung,” bay i dademe, manla, “Nun kasaligan stulen di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bay man Dyisas di dale, “Ise ku do i duenan talù ayé, bay gamu, fye lingeyu i manan. ");
INSERT INTO bpr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta kel nan i du kukum i klamang banwe. Satanas magot i banwe ani, bay bat ditù di lwà. ");
INSERT INTO bpr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na do, ku ta nketla agu fdatah, nebegu di do i kdee sahal lumbuk to.” ");
INSERT INTO bpr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yé duenan man ayé du guflingenan i kfatin di krus. ");
INSERT INTO bpr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bay tmimel i dad to, manla, “Yé lingemi mdà di uldin Dwata na i Mgalék Dwata nun nawan landè sen. Na kan ku manam na nket fdatah i Ngà To? Simto kè i Ngà To manam ayé?” ");
INSERT INTO bpr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na tmimel Dyisas fagu di fléd, manan di dale, “Ta là mlo knè i Salò di safédyu. Yé duenam man, di laman magin di gamu i Salò, fadlug gamu magu di knengan fye là gnumah gamu i kifuh, du nè i magu di kifuh, là gadèan i gusalun. ");
INSERT INTO bpr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Taman, fantooyu i Salò di laman mnè di safédyu du fye mgimò gamu dad ton.” Kafnge Dyisas man ayé, mdà kenen salbuni. ");
INSERT INTO bpr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na balù ku ta dee dad tnikeng nimò Dyisas di kanfe i dad to, knèan là ftoo ale di kenen, ");
INSERT INTO bpr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","du fye gdohò i man Isaya, satu tugad i Dwata di munan, “E Amu, simto ta ftoo di ktulenmi i Tnalùam? Simto i ta gufitem i kaltulusam.” ");
INSERT INTO bpr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na salngad di ta tulen Isaya, là ti gaftoo ale, du manan, ");
INSERT INTO bpr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ta bnutè Dwata i matala tà ale mite, na ta snafangan i fandamla tà ale galmabat du fye là gsalu ale di do fye fan-gulêgu ale.” ");
INSERT INTO bpr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yé duen Isaya man ayé du ta teenan i kdatah Dyisas, na yé tulenan. ");
INSERT INTO bpr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bay balù ayé, knèan nun dee ganlal i dad Dyu ta ftoo di ku Dyisas, bay mdà di klikòla di dad Farisi, là tulenla dun tàla ale fnang fusuk di gumnè gal gustifun i dad Dyu, ");
INSERT INTO bpr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","du yé kayèla i kdag i dad to, ise ku i kdag Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na fan-gal Dyisas i talùan, manan, “Nè to ftoo di do, ise ku lo do i fantoon, bay lêan fantoo i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nè to mite do, lêan teen i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Do sa i Salò salu dini di tah tanà du fye i to ftoo di do, ta là mnèan di gukmifuhan. ");
INSERT INTO bpr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na nè to lminge i Tnalùgu na là nimenan, là falnayamgu dun, du ise ku yé duen-gu salu dini ku falnayamgu i dad to, bay du falwàgu ale. ");
INSERT INTO bpr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bay nè to kmagol di do, na là dnawatan i Tnalùgu, nun sa falmayam dun, du i talù ta man-gu, yé falmayam dun di fulé du. ");
INSERT INTO bpr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na ise ku mdà di do i tulen-gu, bay Mà i mdek do, du kenen mlé di do i kdee man-gu na i kdee tdògu. ");
INSERT INTO bpr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na gadègu na i dad talùgu i gumdà nawa landè sen. Mdà ayé, nè i flau Mà do, yé logu man.” ");
INSERT INTO bpr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lo sbutang gdè klo kel Fista Du Kaglius, na ta gadè Dyisas na ta fan kel i bangan tmagak i banwe ani du salu ditù di ku Mà. Too bong nawan i dad ton di tah tanà. Kanbongan ale nawa kel di gusenan. ");
INSERT INTO bpr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na kmaan Dyisas magin di dad to galan tdò. Bay ta fkah Satanas di nawa Dyudas, i ngà Simon Iskariyot, i ayè makal ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ta gadè Dyisas ta blé Màan di kenen i kdee kdatah. Na lêan gadè na Dwata i gumdàan na i gusamfulêam. ");
INSERT INTO bpr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na tadag Dyisas na nlusan i lafin saulan, na mwè twalya du daféngan. ");
INSERT INTO bpr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Klon mkok éél di falanggana, na naloban blì i dad to galan tdò, na yé ifun dun i twalya daféngan. ");
INSERT INTO bpr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na kanton kel di ku Simon Piter, ta man Piter di kenen, “E Amu, ge kè malob i blìgu?” ");
INSERT INTO bpr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na tmimel Dyisas, manan di kenen, “Là fa glabatam i nimògu, bay là mlon mdà ani, glabatam.” ");
INSERT INTO bpr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na man Piter, “Là ti mayè agu ku nalobam i blìgu.” Bay tmimel Dyisas, manan di kenen, “Ku là nalobgu i blìam, ta ise ge to nfun-gu.” ");
INSERT INTO bpr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Taman, man Piter, “Amu, ku gambet ayé, nang lo blìgu i nalobam, bay lê man sigalgu na i ulugu.” ");
INSERT INTO bpr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Bay tmimel Dyisas fagu di fléd, manan, “Nè to ta fnge dyoh, lo yé naloban dunan i blìan, du ta mlaneb kenen. Na ta mlaneb gamu, bay ise ku kdeeyu.” ");
INSERT INTO bpr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yé duen Dyisas man, “Ise ku kdeeyu,” du gadèan na nun satu di dale i makal kenen. ");
INSERT INTO bpr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Taman, kafngen malob dad blìla, ta lsakan i lafin saulan, na lê samfulê di gusudengan. Na manan di dale, “Glabatyu kè i nimògu di gamu gine? ");
INSERT INTO bpr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yé katloyu do, ‘Sér’ na ‘Amu,’ na too sa i manyu du do sa i dunan. ");
INSERT INTO bpr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na do, i Amuyu na i Séryu, ta fdanàgu i ktogu du nalobgu dad blìyu gine. Na yé duenam man, fye ku too gamu salob blì. ");
INSERT INTO bpr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta fitegu di gamu i nimògu du fye ganbetyu. ");
INSERT INTO bpr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Too ti glut i man-gu di gamu. Là ti mdatah i fasak di amun, na là mdatah i to dek di to mdek kenen. ");
INSERT INTO bpr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Du ta glabatyu i tdògu di gamu ani, lehew gamu ku nimòyu. ");
INSERT INTO bpr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Bay ise ku kdeeyu i man-gu ani, du ta gadègu ku dét mnè di fandamyu, gamu i dad mgalékgu. Bay là fakay ku là gdohò i gman di Tnalù Dwata gablà di to makal do, du ani manan, ‘I to song do kmaan, kenen mnang do nawa.’ ");
INSERT INTO bpr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Falagu fgadè di gamu i fan mkel du fye ku ta gdohò, fantooyu na Do sa i Dunan Do. ");
INSERT INTO bpr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Too ti glut i man-gu di gamu. Nè to dmawat balù simto i dekgu, ta dnawatan agu. Na nè to dmawat do, ta dnawatan i mdek do.” ");
INSERT INTO bpr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kafnge Dyisas man ayé, ta mlidù i nawan, na manan di dad to galan tdò, “Too ti glut i man-gu di gamu. Nun satu di gamu makal do.” ");
INSERT INTO bpr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na kanton man ayé, seye ale du makto nawala ku simto di dale i manan ayé. ");
INSERT INTO bpr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na satu di dale, i to too kanbong nawa Dyisas, fihil di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na knatuk Simon Piter i to ayé, manan, “Begam snalek gite ku simto i manan ayé.” ");
INSERT INTO bpr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na i to too kanbong nawa Dyisas, lê man fihil di ku Dyisas, na snalekan, manan, “Amu, simto kè i manam ayé?” ");
INSERT INTO bpr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Na tmimel Dyisas, manan, “Lnabgu i fan ani di tukung. Ku nè to gumlégu dun, yé dunan.” Na di kafngen man ayé, ta mwè fan, lnaban di tukung, na blén di ku Dyudas, i ngà Simon Iskariyot. ");
INSERT INTO bpr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na di kafnge Dyudas dmawat i fan, ta fusuk Satanas di kenen. Taman, man Dyisas di kenen, “Gasilam nimò i knayèam.” ");
INSERT INTO bpr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bay balù satu di gukmaanla ayé, landè gmadè gumtatek i man Dyisas ayé di ku Dyudas. ");
INSERT INTO bpr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Du Dyudas sa magot i filakla, taman, yé man nawa i dademen ku dek Dyisas kenen mayad i dad kalnidùla di fista, ku demen dekan mlé di dad to landè knun. ");
INSERT INTO bpr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Taman, di ta kafnge Dyudas dmawat i fan, ta gasil lamwà. Na ta kifuh nan. ");
INSERT INTO bpr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na di kafnge Dyudas lamwà, man Dyisas di dademe tagak déé, “Ani ta kite kdatah i dnagit Ngà To, na lê i kdatah i Dwata fagu di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na du teen i kdatah Dwata fagu di Ngà To, lê fite Dwata i kdatah Ngà To, na mlal i kimòan dun. ");
INSERT INTO bpr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","E dad ngàgu, ta là mlo agu dini di safédyu. Na ku ta là agu dini, fanngabalyu agu. I man-gu di gamu, salngad i ta man-gu di dad Dyu du là ti gsalu gamu di gusalugu. ");
INSERT INTO bpr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bay ani, nun falami uldin blégu di gamu, sakdo gamu. Ku dét i kakdogu di gamu, yé kasakdoyu, ");
INSERT INTO bpr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","du ku sakdo gamu, gadè i kdee na gamu i dad to tdògu.” ");
INSERT INTO bpr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na smalek Simon Piter di kenen, manan, “Amu, nè fanam gusalu?” Na tmimel Dyisas, manan, “Là fa tayò ge gagin di gusalugu, bay lmalò ge di satu du.” ");
INSERT INTO bpr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na man Piter di kenen, “Amu, dét i duenan là tayò agu gagin ge? Ta gatlagad agu fafati di ge.” ");
INSERT INTO bpr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Bay tmimel Dyisas, manan di kenen, “Too kè i manam na ta gatlagad ge fafati di do? Too ti glut i man-gu di ge, di laman là fa kalmeet i anuk, ta sanam agu bnalew tlu dulê di kmanam dun làam agu dilè.” ");
INSERT INTO bpr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na lê talù Dyisas di dad to galan tdò, manan, “Nangyu flidù i nawayu. Bay ftoo gamu di Dwata, na lê gamu ftoo di do. ");
INSERT INTO bpr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nun dee dad snifil di gumnè Mà, na gatù agu du fatlagadgu i gumnèyu. Ku ise glut ani, là ti man-gu dun di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ku gatù agu du fatlagadgu i gumnèyu, lê agu samfulê du nngéta gamu du fye balù ku nè i gumnègu, lê gamu ditù. ");
INSERT INTO bpr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na, ta gadèyu i dalan salu di gusalugu.” ");
INSERT INTO bpr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Bay man Tomas, “E Amu, là gadèmi i gusalum, na dét kibò kgadèmi i dalan salu gatù?” ");
INSERT INTO bpr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Na man Dyisas di kenen, “Do sa i dalan, na i kaglutan, na i nawa. Landè to gsalu di ku Mà ku là funan magu di do. ");
INSERT INTO bpr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na ani, du ta dilèyu agu, ta lêyu dilè Mà. Na mdà ani, ta dilèyu Mà, na lêyu kenen teen.” ");
INSERT INTO bpr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na man Filip di ku Dyisas, “E Amu, fitem gami i Mà, du fye dsal nawami.” ");
INSERT INTO bpr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Bay man Dyisas di kenen, “Filip, ta mlo agu sa dini di safédyu, bay sana là toom kdilè do? Nè to mite do, ta lêan teen Mà. Na kan ku manam di do, ‘Fitem gami i Mà?’ ");
INSERT INTO bpr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kan? Là ftoo ge kè na mnè agu di ku Mà na Mà mnè di do? Ise mdà di do i dad man-gu di gamu, bay mdà di ku Mà, i mnè di do, du kenen mimò i kdee. ");
INSERT INTO bpr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Fantooyu na mnè agu di ku Mà na i Mà mnè di do. Ku là fantooyu dun, ftoo gamu di do mdà di dad tnikeng nimògu. ");
INSERT INTO bpr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Too ti glut i man-gu di gamu. Nè to ftoo di do, nimòan ku dét i nimògu, na midul dini i kenen nimò du gatù agu di ku Mà. ");
INSERT INTO bpr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Balù dét fniyu fagu di dagitgu, nimògu du fye magdayen Mà fagu di Ngàan. ");
INSERT INTO bpr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na balù dét i fniyu fagu di dagitgu, do i mimò dun. ");
INSERT INTO bpr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ku bong nawayu do, nimenyu i dad flaugu. ");
INSERT INTO bpr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na mni agu di Mà, na banlén gamu i lê satu Tmabeng, dunan Tulus i Kaglut, du fye samsagin gamu kel di landè sen. ");
INSERT INTO bpr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I dad to nfun i banwe ani, là gdawatla dun du là gadèla ku simto kenen, na là dilèla dun. Bay gamu, ta dilèyu du samsagin gamu na mnè di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na là ti tnagakta gamu salngad ngà ilu, bay lê agu samfulê di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Di là mlo ani, i dad to nfun i banwe, ta là teenla agu. Bay gamu, teenyu agu, na du mlawil agu, lê gamu mlawil. ");
INSERT INTO bpr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Di kakel i du ayé, ta gadèyu nan na mnè agu di ku Mà, na mnè gamu di do, na lê agu mnè di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nè to gmadè na mimen i dad flaugu, bong nawan do. Na nè to bong nawan do, kanbong Mà nawa. Na lêgu kanbong nawa i to ayé, na fdilègu i ktogu di kenen.” ");
INSERT INTO bpr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na man Dyudas di kenen, (ise ku Dyudas Iskariyot), “Amu, kan ku gami gufdilèam i ktom, na ise di dad to nfun i banwe?” ");
INSERT INTO bpr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na tmimel Dyisas, manan di kenen, “Nè to bong nawan do, nimenan i dad flaugu. Na lê kanbong Mà nawa, na lwe gami Mà mnè di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bay nè to là bong nawan do, là nimenan i dad flaugu. Na i tdò ta lingeyu ani ise mdà di do, bay mdà di ku Mà i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ta tulen-gu gamu sa i kdee ani di lamgu mnè di blengyu. ");
INSERT INTO bpr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","I Tmabeng, dunan i Mtiu Tulus dek Mà fagu di dagitgu, tdòan gamu i kdee, na ftin fafaldam i kdee dad man-gu di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tagakta gamu i ktanak nawa. Na yé blégu gamu i do ktanak nawa. Là salngadan di ktanak nawa blé i banwe. Nangyu flidù i nawayu, na nang gamu likò. ");
INSERT INTO bpr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ta man-gu di gamu sa, na mdà agu bay lê agu samfulê di gamu. Ku bong nawayu do, ta lehew gamu du gatù agu di ku Mà, du mdatah kenen di do. ");
INSERT INTO bpr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na falagu fgadè di gamu i kdee ani di laman là kel du fye ku ta kel, ftoo gamu. ");
INSERT INTO bpr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ta là mlo nan i kastulen-gu di gamu ani, du ta fan kel i magot i klamang banwe ani, bay là ti gmaganan di do. ");
INSERT INTO bpr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bay fye ku too gadè i kdee dad to di tah tanà na bong nawagu ku Mà. Taman nimògu kdee dekan do. Mdà ato nan. ");
INSERT INTO bpr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Do i glut laweh i grép, na Mà i mifat dun. ");
INSERT INTO bpr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kanlang Mà i kdee dad fanga là menge. Bay nè i dad fanga menge, tanfulan na lnaneban du fye midul i kdee bengela. ");
INSERT INTO bpr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta mlaneb gamu nan fagu di dad tnalùgu i ta tulenta gamu. ");
INSERT INTO bpr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Too gamu mnè di do, na lê agu mnè di gamu, du i fanga, là ti gambengen ku là gagotan di lawehan. Salngad ayé i gamu kagkah du là ti gambenge gamu ku là mnè gamu di do. ");
INSERT INTO bpr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Do sa i laweh, na gamu i dad fanga. Ku mnè gamu di do, lê agu mnè di gamu, taman, too gamu gambenge du landè gaganyu nimò ku ise do. ");
INSERT INTO bpr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nè to là mnè di do, bat di lwà salngad di dad fanga ta kafag. Santifunla dad fanga ani, na batla ale di lifoh du snakufla. ");
INSERT INTO bpr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bay, ku mnè gamu di do na i dad tnalùgu mnè di nawayu, fniyu ku dét i knayèyu, du blégu gamu. ");
INSERT INTO bpr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Too magdayen Mà ku too gamu menge, na fagu dini, yé fbateng dun na gamu i dad to tdògu. ");
INSERT INTO bpr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kanbongta gamu nawa salngad i kalbong nawa Mà do. Mnè gamu nan di kalbong nawagu gamu. ");
INSERT INTO bpr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ku nimenyu i dad flaugu, mnè gamu di kalbong nawagu. Salngad do, nimen-gu i dad flau Mà, na mnè agu di kalbong nawan. ");
INSERT INTO bpr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ta man-gu ani di gamu du fye mnè i klehewgu di gamu, na fagu déé too sikof i klehewyu. ");
INSERT INTO bpr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ani flaugu di gamu, salbong gamu nawa salngad di kalbong nawagu gamu. ");
INSERT INTO bpr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yé too mdatah kalbong nawa fite i satu to di dademen sgalak dunan kablén i kton di fati du mdà di kakdon dale. ");
INSERT INTO bpr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gamu i dademegu sgalak ku nimenyu balù dét flaugu di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ta là tlota gamu dad fasakgu du là ti gadè i fasak nimò i amun. Bay yé ta katlogu gamu dademegu sgalak du ta fgadègu di gamu i kdee dad lingegu mdà di ku Mà. ");
INSERT INTO bpr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ise ku gamu i malék do, bay do i malék gamu. Ta nalékta gamu du fye mdà gamu magu, na fye menge gamu, na i bengeyu too mlawil. Taman, blé Mà di gamu balù dét i fniyu di kenen fagu di dagitgu. ");
INSERT INTO bpr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yé duenam man, ani flaugu di gamu, salbong gamu nawa. ");
INSERT INTO bpr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ku nuteh gamu nawa i dad to nfun i banwe ani, fandamyu na do i munala nuteh nawa. ");
INSERT INTO bpr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ku nfun gamu i banwe ani, kandola gamu. Bay du ta nalékta gamu, ta ise gamu nfun i banwe. Yé duenam man, nutehla gamu nawa. ");
INSERT INTO bpr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fandamyu i ta man-gu di gamu. Landè fasak mdatah di amun. Du fansasèla agu, lêla gamu fansasè. Ku nimenla i man-gu, lêla nimen i gamu man. ");
INSERT INTO bpr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bay yé duenla famsasè gamu du ftoo gamu di do, na là dilèla i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Landè moon salàla ku là ta salu agu dini na talù di dale. Kabay, ta là gmanla dun ku landè salàla. ");
INSERT INTO bpr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na nè to muteh do nawa, lêan nuteh nawa Mà. ");
INSERT INTO bpr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Landè moon salàla ku là ta nimògu dad tnikeng i là fa lmen mgimò. Bay ani, ta teenla sa i dad nimògu, na knèan, do na Mà, nutehla gami nawa. ");
INSERT INTO bpr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bay, là fakay ku là mkel ani fye gdohò i ta gsulat di uldin blé Dwata di dale, manan, ‘Nutehla agu nawa di landè gumdàan.’ ");
INSERT INTO bpr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ku ta dekgu salu dini mdà di ku Mà i Tmabeng, dunan i Tulus fite i kaglut mdà di ku Mà, kenen i tmulen gablà di do. ");
INSERT INTO bpr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na lê gamu tmulen gablà di do, du mdà di kagatbùan sa i kaginyu do. ");
INSERT INTO bpr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yé duen-gu man ani di gamu du fye là mlungay i ksaligyu di do. ");
INSERT INTO bpr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Na falwàla gamu mdà di dad gumnè gustifun. Na kel i du, nè to fmati gamu, man nawan ku yé nimòan knayè i Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bay yé duenla mimò ayé du là dilèla gami Mà. ");
INSERT INTO bpr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na ta falagu fgadè ani di gamu du fye ku ta nimòla i kdee ani, gafaldamyu i ta man-gu di gamu. “Yé duen-gu là tayò fgadè ani di gamu mdà di kagatbùan du dini agu fa di safédyu. ");
INSERT INTO bpr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bay ani, ta fan agu salu di ku Mà i mdek do, na landè di gamu smalek ku nè i gusalugu. ");
INSERT INTO bpr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bay kantogu tulen di gamu, ta baling gamu mlidù. ");
INSERT INTO bpr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bay tulen-gu gamu i kaglutan. I kdàgu gamfye di gamu, du ku là mdà agu, là salu dini di gamu i Tmabeng. Bay ku ta mdà agu, dekgu kenen salu di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na ku ta kel kenen dini, fgadèan di dad to nfun i banwe i dad salàla, na i katluh, na i kukum Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Fgadèan di dale i dad salàla du là ftoo ale di do. ");
INSERT INTO bpr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na fgadèan di dale i katluh du salu agu di ku Mà, na ta là teenyu agu. ");
INSERT INTO bpr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na fgadèan di dale i kukum Dwata du i dmatù mebe i klamang banwe, ta nukum Dwata kenen di kaflayam. ");
INSERT INTO bpr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Dee fa dad kayègu man di gamu, bay là fa gdawatyu dun. ");
INSERT INTO bpr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bay ku ta kel i Tulus fite i Kaglut, nalakan gamu di kdee kaglut. Na ise ku mdà di kenen knayè i dad fgadèan di gamu, bay yé tulenan di gamu i kdee lingen na i dad fan mkel. ");
INSERT INTO bpr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na lêan agu dnayen du dnawatan i blégu di kenen, na tulenan di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","I kdee nfun Mà, slame nfun-gu. Na dnawat Mtiu Tulus i blégu di kenen, na tulenan di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Di là mlo, ta làyu agu teen, kabay di là lêan mlo, ta lêyu agu teen.” ");
INSERT INTO bpr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Taman, stulen i dad to galan tdò, manla, “Dét gumtatek i manan ayé, na di là mlo ani ta làto dun teen, na di là lêan mlo, ta lêto kenen teen, na balù i manan ta fan kenen mulê di Màan?” ");
INSERT INTO bpr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na sasalek ale, manla, “Dét gumtatek i manan ayé ‘di là mlo?’ Là glabatto i manan.” ");
INSERT INTO bpr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na ta gadè Dyisas na mayè ale smalek di kenen. Na manan di dale, “Sasalek gamu kè gablà di kman-gu ayé, na di là mlo ani, ta làyu agu teen, bay di là lêan mlo, ta lêyu agu teen? ");
INSERT INTO bpr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Too ti glut i man-gu di gamu. Kel i du, mngel na lmanu gamu, bay i dad to nfun i banwe ani, flehew ale dale. Mlidù nawayu, bay mbaling klehew i klidùyu. ");
INSERT INTO bpr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I satu libun maltien, too sasè i klidùan ku ta fan sut i ngàan du galyalon i kaflayaman. Bay, ku ta sut i ngàan, ta glifetan i kaflayaman mdà di klehewan du ta sut i ngàan. ");
INSERT INTO bpr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na salngad ayé i mkel di gamu du mlidù gamu ani. Bay di satu du, lê ato site, na baling too bong i klehewyu, na landè to gamlad dun di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na ku ta kel i du ayé, ta là smalek gamu di do balù détan. Too ti glut i man-gu di gamu. Balù dét i fniyu di ku Mà fagu di dagitgu, blén di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kel ani, landè lmenyu fni di do. Mni gamu nan, na gamdawat gamu du fye too sikof i klehewyu. ");
INSERT INTO bpr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Di du ani, fagugu di fléd i dad tulen-gu di gamu, bay kel i du, toogu fbateng i ktulen-gu gamu gablà di ku Mà, ta ise fagu di fléd. ");
INSERT INTO bpr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na ku ta kel i du ayé, ta gamu nan i mni di ku Mà fagu di dagitgu. Ta ise do i mni di ku Mà gablà di gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bong nawa Mà gamu du bong nawayu do, na du fantooyu yé gumdàgu di Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Glut sa, yé gumdàgu di ku Mà, na ta salu agu dini di tah tanà. Bay di là mlo, lêgu tnagak i banwe ani du samfulê agu di ku Mà.” ");
INSERT INTO bpr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na ta lê talù dad to galan tdò di kenen, manla, “Ani, ta too mbateng i dad tulenam di gami, du ta là fagum di fléd. ");
INSERT INTO bpr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na ta gadèmi nan na gadèam i kdee. Balù ta landè galà smalek ge du ta sanam gadè ku dét i knayèmi snalek. Mdà ani, ta fantoomi yé gumdàam di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na tmimel Dyisas, manan, “Ta ftoo gamu. ");
INSERT INTO bpr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bay neyeyu du fan kel i du, ani ta dini nan, masbalét i kdeeyu, na kat satu di gamu mulê di kenen gumnè, na tnagakyu agu logu satu, bay ise ku logu satu du Mà magin di do. ");
INSERT INTO bpr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ta tulen-gu gamu ani du fye nun ktanak nawayu fagu di ksasatuyu di do. Nun dad kaflayamyu di tah tanà, bay fan-galyu nawayu du ta fnisan-gu i dad sasè di banwe ani.” ");
INSERT INTO bpr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na di kafnge Dyisas man ayé, lngalà di langit, na dmasal, manan, “E Mà, ta kel nan i bang. Fdataham Ngàam, du fye lêan ge fdatah. ");
INSERT INTO bpr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Du ta blém di do i kdatah magot i kdee dad to, du fye banlégu nawa landè sen i kdee dad to ta blém di do. ");
INSERT INTO bpr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ani gumtatek i nawa landè sen, dunan i kdilèla ge, i too glut Dwata, na lê man do, Dyisas Krayst, i dekam. ");
INSERT INTO bpr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ta fdatahta ge di tah tanà ani na ta fngegu nimò i dad fimòam do. ");
INSERT INTO bpr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na ani, Mà, fulêam di do i kdatah tagnè gfun-gu di safédam di là fa mgimò i klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ta fdilèta ge di dad to ta saligam di do mdà di banwe ani. Ge i mfun dale, bay ta saligam ale di do, na fkahla di nawala i Tnalùam. ");
INSERT INTO bpr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na ta gadèla na i kdee ta blém di do slame mdà di ge. ");
INSERT INTO bpr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na ta tulen-gu dale i manam do, na ta dnawatla sa. Na ta gadèla i ktoon na ge i gumdàgu. Na ftoo ale na ge i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na ani, dnasalgu ale. Ise ku dad to nfun i banwe ani i dnasalgu, bay i dad to ta saligam di do, du ge mfun dale. ");
INSERT INTO bpr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ge mfun i dad nfun-gu, na lê do mfun i kdee dad nfunam. Na ta magdayen agu fagu di dale. ");
INSERT INTO bpr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na ani, ta fan agu samfulê di ge, na ta là mlo agu dini di tah tanà. Bay i dad tota ani, tlabo ale dini di tah tanà. E Mà Mtiu, nifatam ale fagu di kaltulus i dagitam, dunan i dagit ta blém di do du fye sasatu ale salngad i gite ksasatu. ");
INSERT INTO bpr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Di knègu dini di safédla, nifatgu ale fagu di kaltulus i dagitam ta blém di do. Ta nifatgu ale, na landè lanah, bay lo satu, i tagnè lanah, du fye gdohò i Tnalùam. ");
INSERT INTO bpr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na ani, samfulê agu déé di ge, na man-gu ani lamgu dini di tah tanà, du fye too ale lehew magin do. ");
INSERT INTO bpr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ta blégu di dale i Tnalùam. I dad to nfun i banwe ani, nutehla ale nawa du ise i banwe ani mfun dale salngad di do, ise ku i banwe ani mfun do. ");
INSERT INTO bpr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na ise ku yé fnigu di ge ku nwèam ale mdà di banwe ani, bay yé fnigu di ge, kanlungam ale mdà di ku Satanas. ");
INSERT INTO bpr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ise ku i banwe ani i mfun dale, na salngad di do, ise ku i banwe ani mfun do. ");
INSERT INTO bpr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tanfingam i dad tota fagu di kaglut, du i Tnalùam, yé i kaglut. ");
INSERT INTO bpr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Du ta dekam agu di tah tanà, lêgu ale dek di klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na mdà di dale, sdulêgu blé i ktogu di ge du fye lêla sdulê blé i ktola di ge. ");
INSERT INTO bpr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na ise ku lo dale i dnasalgu, bay lê man i kdee dad to ftoo di do mdà di katdòla. ");
INSERT INTO bpr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dmasal agu du fye masasatu i kdeela salngad di gite, du ge, Mà, mnè di do, na do mnè di ge. Na dmasal agu fye lê ale mnè di gite, du fye mdà di ksasatula, fantoo dad to di tah tanà na ge i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ta banlégu ale kdatah salngad i kdatah ta blém di do du fye masasatu ale salngad gite. ");
INSERT INTO bpr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Do mnè di dale, na ge mnè di do, du fye too sikof i ksasatula. Na ani gumdà i dad to di klamang banwe gmadè na ge i mdek do, na bong nawam dale salngad i kalbong nawam do. ");
INSERT INTO bpr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mà, ta blém di do sa i dad to ani. Yé kayègu ku magin ale di do balù nè gumnègu du fye teenla i kdatah ta blém di do du ta sana bong nawam do di laman là fa mgimò i klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","E Mà, too ge tluh, na i dad to nfun i banwe ani, là dilèla ge. Bay do, ta dilèta ge, na gadè i dad to ta saligam di do na ge i mdek do. ");
INSERT INTO bpr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ta fdilèta ge di dale, na fanlesgu mimò dun du fye gdawatla i kalbong nawam do, na mnè agu di dale.” ");
INSERT INTO bpr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Di kafnge Dyisas dmasal, mdà kenen magin i dad to galan tdò mifal di Sbang Kidron. Na nun gbang ditù, na déé gusalun magin dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Dyudas, i to makal ku Dyisas, ta teenan i banwe ayé du ta dee dulêla slabat déé. ");
INSERT INTO bpr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Taman, gatù Dyudas, na faginan dee sundalu na dademe to mantay di Bong Gumnè Gumangamfù di Dwata du ta dek dad mdatah ganlal di kafaglut na dad Farisi ale. Na mebe ale dad tek na dad falitan na dad salò bnakas. ");
INSERT INTO bpr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na ta gadè Dyisas i kdee fan mkel di kenen, taman snitongan ale, na manan di dale, “Simto i fanngabalyu?” ");
INSERT INTO bpr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na tmimel ale, manla, “Dyisas mdà di Nasarét.” Na man Dyisas di dale, “Do sa i dunan.” Na Dyudas, i to makal ku Dyisas, tadag déé di safédla. ");
INSERT INTO bpr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na kanto man Dyisas di dale, “Do sa i dunan,” gfudul ale, na sdulê ale bek di tanà. ");
INSERT INTO bpr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na lê snalek Dyisas ale, manan, “Simto i fanngabalyu kè?” Na manla, “Dyisas mdà di Nasarét.” ");
INSERT INTO bpr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na tmimel Dyisas, manan, “Ta man-gu di gamu gine na do sa i dunan. Taman, ku do i fanngabalyu, falohyu i dademegu mdà.” ");
INSERT INTO bpr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yé duenan man ayé du fye gdohò i ta manan, “Landè lanah di dad to ta saligam di do.” ");
INSERT INTO bpr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na kafnge ayé, ta nsò Simon Piter i sundangan, na tnibehan fasak i ulu dad ganlal di kafaglut i dad Dyu, na masfek i bali klingen gsen di kwanan. Na yé dagit i fasak ayé Malkus. ");
INSERT INTO bpr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bay man Dyisas di ku Piter, “Fulêam di lumàan i sundangam. Man nawam kè ku là dnawatgu i kaflayam blé Mà di do?” ");
INSERT INTO bpr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na mdà i dad sundalu na i ulula na lê i dademe mantay, kanfèla Dyisas na bnakusla kenen. ");
INSERT INTO bpr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na nebela kenen funa di ku Anas. Anas i tewe Kayafas, dunan i ulu i dad ganlal di kafaglut i dad Dyu di fali atù. ");
INSERT INTO bpr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na Kayafas i man di dad ulu i dad Dyu na mas fye fa ku lo satu mati di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na lê lmalò di ku Dyisas Simon Piter na i satu di dademe to gal tdò Dyisas. Na i to ayé, dilè i ulu i dad ganlal di kafaglut i dad Dyu, taman, magin kenen ku Dyisas fles di nasel i ganlal ayé. ");
INSERT INTO bpr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bay tagak Piter kenen di lwà di saféd i takab. Kafnge ayé, lê lamwà i to dilè i ganlal, na stulen di libun mantay di takab, klon mebe ku Piter ditù di lam. ");
INSERT INTO bpr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na smalek i libun mantay di takab, manan ku Piter, “Ise ge kè satu di dad to gal tdò i to ayé?” Na tmimel Piter, manan, “Ay, ise do.” ");
INSERT INTO bpr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na mdà di katno déé, i dad fasak na dad mantay, mimò ale lifoh, yé dutungla uling, na tadag ale déé du mnalang ale. Na lê fdadong Piter déé du mnalang. ");
INSERT INTO bpr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na i ulu dad ganlal di kafaglut i dad Dyu, snalekan Dyisas gablà di dad to galan tdò na i dad tdòan. ");
INSERT INTO bpr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na tmimel Dyisas, manan, “Yé sa gutamdògu i dad to di gumefen. Yé galgu gutamdò di lam dad gumnè gustifun na di Gumnè Gumangamfù di Dwata. Na là ti tamdò agu di gugbunin. ");
INSERT INTO bpr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na kan ku do i snalekam? Fye fa ku yé snalekam i dad to ta lminge do du ta gadèla i dad man-gu.” ");
INSERT INTO bpr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kafngen man ayé, mdà i satu mantay, tanfilingan Dyisas, na manan, “Kan ku talù ge salngad ayé di ulu i dad ganlal di kafaglut?” ");
INSERT INTO bpr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Na tmimel Dyisas, manan, “Ku nun man-gu sasè, tulenam di dad to i ksasègu, bay ku fye i man-gu, dét i duenam tamfiling do?” ");
INSERT INTO bpr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na kafnge ayé, sana kagbakus Dyisas, na febe Anas kenen di ku Kayafas, i ulu dad ganlal di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sana kdéé Piter di gumnalangan. Na snalek dademe to kenen, manla, “Sawe ge sa i satu tdòan?” Bay tmimel Piter, manan, “Ay, ise do.” ");
INSERT INTO bpr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na lê talù satu fasak i ulu dad ganlal di kafaglut i dad Dyu, dunan i flanek i to tnibeh Piter i bali klingen, na snalekan Piter, manan, “Ise ge kè i to teen-gu magin dun di gbang?” ");
INSERT INTO bpr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bay lê man malew Piter, na manan, “Ise do.” Na ta kalmeet i anuk. ");
INSERT INTO bpr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Di too flafus, ta mdà ale di gumnè Kayafas, na nebela Dyisas di bong gumnè Pilato, i gubirnador. Bay là fusuk i dad Dyu di bong gumnèan ayé, tà ale magsik di kite Dwata, na là gagin ale di kakaan di Fista Du Kaglius, du ise Dyu Pilato. ");
INSERT INTO bpr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Taman, lamwà Pilato, na snalekan ale, manan, “Dét i salàan duenyu mebe dun dini?” ");
INSERT INTO bpr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na tmimel ale, manla di kenen, “Ku là gamsalà i to ayé, là ti nebemi dun gadini.” ");
INSERT INTO bpr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bay man Pilato di dale, “Gamu i kamfè dun, na gamu i mukum dun mdà di uldinyu.” Bay man dad Dyu di kenen, “Là fakay di uldinmi ku gami dad Dyu mukum dadememi di fati.” ");
INSERT INTO bpr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yé duenan mgimò ani du fye gdohò i ta fala fgadè Dyisas gablà di kibòan mati. ");
INSERT INTO bpr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kafnge ayé, lê fusuk Pilato di lam i bong gumnèan, na tlon Dyisas, na snalekan kenen, manan, “Ge kè Harì i dad Dyu?” ");
INSERT INTO bpr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na tmimel Dyisas, manan, “Nè gumdà i manam ayé, mdà di ge fandam, ku mdà di lingem di dademe to?” ");
INSERT INTO bpr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Na tmimel Pilato, manan, “Man nawam kè ku Dyu agu? I dademem Dyu na i dad ganlal di kafaglutyu, yé mebe ge dini di do. Dét i ta nimòam?” ");
INSERT INTO bpr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na tmimel Dyisas, manan, “I banwe nagotgu ise di tah tanà ani. Ku banwe di tah tanà ani i nagotgu, fakay matu dad togu du fye là gakfè i dad Dyu agu. Bay, ise dini di tah tanà ani i banwe nagotgu.” ");
INSERT INTO bpr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na lê snalek Pilato kenen, manan, “Kan? Harì ge kè?” Na tmimel Dyisas, manan, “Ta manam sa. Harì agu. Yé duen-gu sut na salu dini di tah tanà du fgadègu gablà di kaglut. Nè to msen i kaglutan, flinge di do.” ");
INSERT INTO bpr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na smalek Pilato, manan, “Dét kè i kaglut manam ayé?” Na di kafngen man ayé, lê lamwà salu di dad Dyu, na manan di dale, “Landè teen-gu salà di to ayé. ");
INSERT INTO bpr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bay yé ta knalamyu, falwàgu gamu satu to blanggù di kat Fista Du Kaglius. Mayè gamu kè ku yé falwàgu Harì i dad Dyu?” ");
INSERT INTO bpr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bay mkit i kdeela, manla, “Ise kenen. Barabas i falwàam.” (Na Barabas, kenen satu ribildi). ");
INSERT INTO bpr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kafnge ayé, blé Pilato Dyisas di dad to du nfasla. ");
INSERT INTO bpr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na i dad sundalu, mwè ale walad nun sual, na salnabédla du nimòla kyangen, na sukubla di ulun. Na falsakla dun klaweh mitam fulè du fagbetla kenen harì. ");
INSERT INTO bpr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Klola madoy kenen, manla, “Kumusta ge, harì i dad Dyu.” Na fnge fdadong ale di kenen, na tanfilingla. ");
INSERT INTO bpr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Na lê lamwà Pilato, na manan di dad Dyu stifun déé, “Na sén. Nebegu Dyisas di gamu du fye gadèyu na landè teen-gu salàan.” ");
INSERT INTO bpr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na ta lê lamwà Dyisas na sana knè sual sukubla di ulun na i klaweh mitam fulè i falsakla dun. Na man Pilato di dale, “Neyeyu i to ani.” ");
INSERT INTO bpr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bay i dad ganlal di kafaglut i dad Dyu na i dad mantay, kantola teen Dyisas, mkit ale, manla, “Fnatak di krus. Fnatak di krus.” Na ta man Pilato di dale, “Nwèyu, na fnatakyu di krus, du landè teen-gu salàan.” ");
INSERT INTO bpr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na tmimel dad Dyu, manla, “Nun uldin tnadagmi na gten kenen fnati du ye manan kenen i Ngà Dwata.” ");
INSERT INTO bpr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na kanto linge Pilato ayé, ta too sasè i klikòan. ");
INSERT INTO bpr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na lê fusuk kenen di lam i gumnèan, na snalekan Dyisas, manan, “Nè gumdàam?” Bay là tmimel Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Taman, man Pilato di kenen, “Dét duenam là tmimel do? Là gadèam dun kè na nun ktoogu fafatak ge di krus, na nun ktoogu falwà ge?” ");
INSERT INTO bpr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Bay tmimel Dyisas, manan, “Landè ktoom mimò balù détan ku là gablé Dwata dun di ge. Yé sa duen-gu man na i to makal do, mas blat fa i kenen salà di ge.” ");
INSERT INTO bpr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na kanto linge Pilato i man Dyisas ayé, ta mngabal kenen kfagu du fye falwàan Dyisas, bay baling too mkit dad Dyu, manla ku Pilato, “Ku falwàam i to ayé, ta ise ge deme Sisar sgalak, du nè i to man dun na harì kenen, knangan Sisar, i too mdatah ganlal.” ");
INSERT INTO bpr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na kanto linge Pilato i manla ayé, neben Dyisas lamwà, na sudeng kenen di gusudeng i to mukum dnagit Saal Batu. Yé kdagit dad Hibru dun, Gabata. ");
INSERT INTO bpr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na ta fan ltu du nan di du i kafatlagad i kakaan di Fista Du Kaglius. Na man Pilato di dale, “Neyeyu. Ani harìyu.” ");
INSERT INTO bpr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bay mkit dad to ayé, manla, “Fnati kenen! Fnatak kenen!” Bay snalek Pilato ale, manan, “Fnatakgu di krus kè i harìyu?” Na tmimel dad ganlal di kafaglut i dad Dyu, manla, “Landè dademe harìmi, lo senan Sisar.” ");
INSERT INTO bpr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Taman, ta blé Pilato Dyisas di dale du fye fnatakla di krus. Taman, ta nwèla Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na lamwà Dyisas tmiang krusan salu di satu banwe dnagit Klakub Ulu, yé dagitan di talù i dad Dyu, Golgota. ");
INSERT INTO bpr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na kanto ale kel déé, ta fnatakla Dyisas di krus, na lê nun fnatakla lwe to, satu gsen di kwananan, na satu gsen di bibengan, na déé Dyisas di gutngàla. ");
INSERT INTO bpr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na smulat Pilato i fgadèan, fkahan di krus Dyisas. Na ani man i sulatan, “Dyisas mdà di Nasarét, i Harì i dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sulatla ayé di Hibru, Latin, na Grik. Taman, dee dad Dyu gambasa dun du mdadong di Dyérusalém i gufmatakla ku Dyisas di krus. ");
INSERT INTO bpr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Taman, i dad ganlal di kafaglut i dad Dyu, manla di ku Pilato, “Nang ayé sulatam, ‘Harì i dad Dyu,’ bay yé tlasam dun, ‘Kenen kun Harì i dad Dyu.’ ” ");
INSERT INTO bpr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bay man Pilato di dale, “I ta gsulatgu, là fakay tanlas dun.” ");
INSERT INTO bpr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na kafnge i dad sundalu fmatak kenen di krus, ta nwèla i dad klawehan, na nalella di fat, du fye kat satu di dale nun alelan. Na lêla nwè i tahà klawehan, tadè nabal landè tbél. ");
INSERT INTO bpr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na stulen dad sundalu ayé, manla, “Nangto knasê i tahà klawehan ani, bay neyeto ku simto gamwè dun fagu di kasbunut.” Mgimò ayé du fye gdohò i fsulat Dwata di munan, manan, “Sansalella dad klawehgu, na neyela ku simto gamwè i tahà klawehgu fagu di kasbunut.” Na yé nimò dad sundalu ayé. ");
INSERT INTO bpr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na nun dad libun tadag déé di saféd krus Dyisas, dunan i yêan, na flanek yêan, na lê Méri, dunan yaan i satu lagi dnagit Klofas, na lê Méri Magdalin. ");
INSERT INTO bpr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na kanto teen Dyisas i yêan na i satu to galan tdò i toon kanbong nawa, manan di yêan, “Libun, yé sa i ngàam.” ");
INSERT INTO bpr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na lêan man di galan tdò, “Yé sa yêam.” Na mdà di kman Dyisas ayé, ta nwè i to ayé i yê Dyisas, na neben di kenen gumnè. ");
INSERT INTO bpr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kafnge ayé, kanto gadè Dyisas na ta gdohò i kdeen, ta manan, “Malinum agu,” du fye gdohò i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na nun déé satu tukung fnò sukà, na kantola lnab falnas di sukà ayé, fkahla di tukè i fanga hisop, na ulukla salu di bà Dyisas du fsafla dun. ");
INSERT INTO bpr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na kanton gafloh i sukà, ta lê talù, manan, “Ta fnge nan.” Na kudung kenen, na ta ftoh i nawan. ");
INSERT INTO bpr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ta flabi nan di du kafatlagad di là fa tambù i Fista Du Kaglius, na i tmadol du dunan i Du Kaftud too mdatah. Taman, salu dad ganlal i dad Dyu di ku Pilato, na mbal ale du tanfòla blì i dad to ta fnatak di krus, du fye mlal ale mati na nwèla ale mdà di krus di laman là kel i Du Kaftud. ");
INSERT INTO bpr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Taman, falohan dad sundalu gatù, na tanfòla blì i dad to fnatak magin ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bay kanto ale kel di ku Dyisas, teenla na ta mati, taman, là tanfòla i kenen blì. ");
INSERT INTO bpr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bay satu di dad sundalu ayé, fnahukan agas i lohok Dyisas, na tadè samfut litè na éél. ");
INSERT INTO bpr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Do Dyan i to mite i mkel ani, dunan i to tmulen. Glut, gsalig i man-gu, na yé duen-gu tmulen dun du fye ftoo gamu. ");
INSERT INTO bpr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yé duenan mkel kdee ani du fye gdohò i ta gsulat di Tnalù i Dwata, manan, “Landè tulanan tanfò, balù satu.” ");
INSERT INTO bpr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na lê nun fa satu gsulat di Tnalù i Dwata, manan, “Meye ale di to fnahukla.” ");
INSERT INTO bpr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na nun satu lagi gal magin ku Dyisas, bay là fgadèan dun du mdà di klikòan di dad Dyu. Yé dagitan Dyosip mdà di Arimatiya. Salu kenen di ku Pilato, na fnin i laweh Dyisas. Kanto faloh Pilato Dyosip, ta gatù kenen, na nwèan i laweh Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na magin Nikodimus, i to salu ku Dyisas di satu kifuh di munan. Mebe kenen dad fangbun dnagit mira na alo, nun dad lime falò kilu i kablatan. ");
INSERT INTO bpr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kafnge ayé, nwèla i laweh Dyisas, na lnabédla falnas, na faginla i dad fangbun, du yé kafatlagad i dad Dyu laweh i to mati ku lbang. ");
INSERT INTO bpr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na nun gbang mdadong di gufmatila ku Dyisas, na di gbang ayé, nun ilib gulambang, bay landè to lmen lbang déé. ");
INSERT INTO bpr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na ta fan kel i Du Kaftud i dad Dyu, na yé duenam man, déé nan i gulambangla ku Dyisas du mdadong di gumatin. ");
INSERT INTO bpr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na di too flafus Linggu, ta mdà Méri Magdalin salu di lbang Dyisas, bay kakelan déé, teenan ta mlulid i bong batu mdà di bà i ilib. ");
INSERT INTO bpr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Taman, milah kenen salu di ku Simon Piter, na lê i satu to gal tdò Dyisas i toon kanbong nawa. Na di kakelan déé, manan di dale, “Ta nwèla laweh i Amuto, na là gadèmi ku nè gumkahla dun.” ");
INSERT INTO bpr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kafnge ayé, ta mdà Piter na i satu to tdò Dyisas, na gatù ale di lbang. ");
INSERT INTO bpr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lwe ale sadluh gatù, bay kibò baltik i satu, na muna kenen kel di lbang. ");
INSERT INTO bpr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na fkagò kenen du smanil, na teenan i dad falnas bukay, bay là fusukan. ");
INSERT INTO bpr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kafnge ayé, ta lê kel Simon Piter, na fles kenen fusuk di lbang, na teenan dad falnas bukay mlasà déé. ");
INSERT INTO bpr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Maglulun i falnas labéd di ulun. Mahal gumlasà i falnas ayé, na mahal gumlasà i falnas labéd di lawehan. ");
INSERT INTO bpr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na kafnge ayé, ta lê fusuk i satu to galan tdò, dunan i muna kel gine di lbang, na kanton teen i kalbong kdee ani, ta ftoo kenen. ");
INSERT INTO bpr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Blaam là fa glabatla i gumanan dun di Tnalù Dwata là fakay ku là mték Dyisas mdà di fati.) ");
INSERT INTO bpr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na i dad lwe tdò Dyisas, ta mdà ale mulê. ");
INSERT INTO bpr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bay Méri, fanak kenen di lwà i ilib gulambang, na mngel. Na fkagò kenen smanil di lam i lbang. ");
INSERT INTO bpr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na nun teenan lwe kasaligan i Dwata smaul bukay sudeng di gufkahla i laweh Dyisas, satu gsen di ulun, na satu gsen di blìan. ");
INSERT INTO bpr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na snalekla Méri, manla, “Dét i nngelam?” Na tmimel kenen, manan, “Du ta nwèla laweh i Amugu na là gadègu ku nè gufkahla dun.” ");
INSERT INTO bpr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na kafnge Méri man ani, kmangél kenen, na ta teenan Dyisas tadag déé, bay là dilèan dun. ");
INSERT INTO bpr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na man Dyisas di kenen, “Dét i nngelam? Simto i fanngabalam dé?” Bay man nawa Méri ku kenen i to gal mifat dad fele déé, na manan dun, “Sér, ku ge mwè i lawehan, begam tulen do ku nè gufkaham dun du nwègu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Na man Dyisas di kenen, “Méri.” Na smalu kenen di ku Dyisas, na manan di Hibru, “Raboni.” Yé gumtatekan dunan, “To Tamdò.” ");
INSERT INTO bpr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Na man Dyisas di kenen, “Nangam agu tayò nagot du là fa mbatun agu salu di ku Mà. Bay gatù ge di dad to galgu tdò, na tulenam dale na ta fan agu mbatun salu di ku Mà, dunan i Màyu, i Dwatagu, dunan i Dwatayu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na ta mdà Méri Magdalin salu di dad to gal tdò Dyisas, na tulenan dale na ta teenan i Amu, na lêan tulen dale i kdee man Dyisas di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na di kifuh Linggu, stifun dad to gal tdò Dyisas, na tnakabla i gufusuk du mdà di klikòla di dad ganlal i dad Dyu. Na tadè msut Dyisas, na tadag déé di blengla, na manan di dale, “I ktanak nawa mnè di gamu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na kafngen man ayé, ta fiten di dale i dad falelan na i lohokan. Na too ale flehew du ta teenla i Amula. ");
INSERT INTO bpr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na lê man nulit Dyisas i manan di dale, “I ktanak nawa mnè di gamu. Dekta gamu salngad di kdek Mà do.” ");
INSERT INTO bpr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na kafngen man ayé di dale, nyufan ale, na manan, “Dnawatyu i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na nè i dad salà i dad to fnasinsyayu, lê fnasinsya Dwata, bay nè i dad salà i dad to là fnasinsyayu, lê là fnasinsya Dwata dun.” ");
INSERT INTO bpr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Tomas, satu di dad sfalò lwe, i dnagit Sfangê, là sa déén di kfite Dyisas di dale. ");
INSERT INTO bpr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Taman, man dademen di kenen, “Ta teenmi i Amuto.” Bay baling man Tomas di dale, “Silang agu ftoo na ta mték kenen ku teen-gu i dad seey di falelan, na doggu i tnalògu, na lêgu dog i tnalògu di seey di lohokan.” ");
INSERT INTO bpr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na kafnge walu butang, ta lê man stifun di lam i gumnè dad to gal tdò Dyisas, na déé Tomas. Na tadè lê msut Dyisas déé tadag di blengla balù ku magtakab i dad takab, na manan di dale, “I ktanak nawa mnè di gamu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na manan ku Tomas, “Dogam i tnalòam di seey i dad falelgu, na dogam i tnalòam di seey i lohokgu. Na nangam falwe nawam, bay too ge ftoo.” ");
INSERT INTO bpr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Na man Tomas di kenen, “Amugu na Dwatagu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na man Dyisas di kenen, “Yé duenam ftoo di do du ta teenam agu. Bay too nun kafye i dad to ftoo di do balù ku là fa teenla agu.” ");
INSERT INTO bpr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nun dee dademe dad tnikeng nimò Dyisas di kanfe i dad to galan tdò, i là gagin sulat di libru ani. ");
INSERT INTO bpr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bay ta sulatgu dad mgimò ani du fye ftoo gamu na Dyisas i Mgalék Dwata, dunan i Ngà Dwata, na mdà di kaftooyu, gamdawat gamu nawa landè sen déé di kenen. ");
INSERT INTO bpr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kafnge ayé, ta lê fite Dyisas di dad to galan tdò di Lanaw Tibiryas. Na ani i kfagun fite i kton. ");
INSERT INTO bpr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yé stifun déé Simon Piter, na Tomas, dunan i dnagit Sfangê, na Natanyél mdà di Kana di Galili, na i dad lwe ngà Sébidi, na lê man lwe dademe dad to galan tdò. ");
INSERT INTO bpr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na man Simon Piter di dale, “Mdà agu fmukat.” Na manla di kenen, “Magin gami di ge.” Na ta mdà ale maweng, na tnadakla i butang fmukat, bay landè gwèla. ");
INSERT INTO bpr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na di ta fan malwa, tadag Dyisas di kilil i lanaw, bay man nawa i dad tdòan ku ise kenen. ");
INSERT INTO bpr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Taman, snalek Dyisas ale, manan, “Man, dad flanek, nun gwèyu?” Na manla, “Too ti landèan.” ");
INSERT INTO bpr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na man Dyisas di dale, “Ftatekyu i fukatyu gsen di kwanan i aweng du fye nun gwèyu.” Taman, lêla ftatek i fukat, bay ta là gaganla mket dun du ta dee nalaf bkehla. ");
INSERT INTO bpr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na i satu to too kanbong nawa Dyisas, manan ku Piter, “Amuto sa ayé.” Na kanto gadè Simon Piter na Dyisas kadì i tadag déé, ta lsakan i saulan, (du là smaulan gine), na faltò di lam i éél, na fles kmahung salu di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na fles maweng i dademe, dyolla i fukatla fnò nalaf du ta mdadong ale di kilil, nun dad syem falò mitru kè i kawagan. ");
INSERT INTO bpr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na di kduungla, ta nun teenla dad bala lifoh, na tnatê nalaf, na lê nun teenla dad fan. ");
INSERT INTO bpr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na man Dyisas di dale, “Nebeyu dini i dademe nalaf gwèyu.” ");
INSERT INTO bpr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na myak Simon Piter di aweng, na dyolan i fukat fnò malbang nalaf kel di kilil i lanaw. Mlatuh lime falò tlu i kdeen, bay balù ku too ale dee, là kasê i fukatla. ");
INSERT INTO bpr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Na man Dyisas di dale, “Flal gamu, na kmaanyu.” Na landè di dad to galan tdò smalek ku simto kenen du ta gadèla na kenen i Amula. ");
INSERT INTO bpr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Taman, fdadong Dyisas di dale, mwè fan, banlén ale, na lêan ale banlé nalaf. ");
INSERT INTO bpr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na yé ta gatlun dulê fite i kton di dale mdà di ktékan di fati. ");
INSERT INTO bpr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na kafngela kmaan, snalek Dyisas Piter, manan, “Simon, ngà Dyan, bong nawam do mdatah fa di kalbong nawam i dademe ani?” Na tmimel Piter, manan, “Hee, Amu, gadèam na kandota ge.” Na man Dyisas di kenen, “Ku kandom agu, nifatam do i dad ngà bilibiligu.” ");
INSERT INTO bpr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na lê smalek Dyisas di galwen dulê, manan, “Simon, ngà Dyan, bong nawam do kè?” Na lê tmimel Piter, manan, “Hee, Amu, gadèam na kandota ge.” Na man Dyisas di kenen, “Ku kandom agu, nifatam do i dad bilibiligu.” ");
INSERT INTO bpr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Na lê smalek Dyisas di gatlun dulê, manan, “E Simon, ngà Dyan, kandom agu kè?” Na too mlidù Piter du di gatlun dulê smalek kenen, yé salekan, “Kandom agu kè?” Na man Piter di ku Dyisas, “E Amu, gadèam i kdee, taman, gadèam na kandota ge.” Na man Dyisas di kenen, “Ku kandom agu, nifatam do dad ngà bilibiligu. ");
INSERT INTO bpr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Too ti glut i man-gu di ge, di lamam fa lamnok, ge sa mkas i ktom, na fakay ge magu balù nè kayèam gusalu. Bay ku ta tua ge, tadè ge lo dmife, na mahal to i mkas ge, na nebela ge di là kayèam gusalu.” ");
INSERT INTO bpr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yé man Dyisas di ku Piter du fgadèan di kenen i fan kibò Piter mati du fye magdayen i Dwata. Na fnge, ta manan di ku Piter, “Too ge magin di do.” ");
INSERT INTO bpr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bay kanto kmangél Piter, ta teenan i satu to too kanbong Dyisas nawa, dunan i fihil di ku Dyisas na smalek di lamla kmaan ku simto i makal kenen. ");
INSERT INTO bpr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na kanto teen Piter i to ayé, snalek Piter Dyisas, manan, “E Amu, dét i kenen gugafat?” ");
INSERT INTO bpr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Na tmimel Dyisas, manan, “Ku yé kayègu na mlawil kenen kel di kasfulêgu, landè labetam ge. Bay ge, tadè ge lo magin do.” ");
INSERT INTO bpr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Taman, yé man nawala ku landè kfati i to ayé. Bay blaam, ise ku yé man Dyisas di ku Piter na là matin, bay lo ayé manan, “Ku yé kayègu na mlawil kenen kel di kasfulêgu, landè labetam.” ");
INSERT INTO bpr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Do i to galan tdò tmulen gablà di dad mgimò ani fagu di sulat. Na gadèmi na too ti glut i kdee dad tulen-gu. ");
INSERT INTO bpr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na nun fa dee dademe nimò Dyisas là gagin sulat dini. Ku sandulêgu sulat i kdee dad nimòan, là gablàan di klamang banwe ani gufkah i kdee dad libru ani. Na yé duenam man, ani gusen i man-gu.");
INSERT INTO bpr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mabtas Tyufilu, di muna sulatgu di ge, ta tulen-gu gablà di kdee dad nimò na i dad tdò Dyisas mdà di kagatbùan, ");
INSERT INTO bpr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kel di du kbatunan. Di laman là fa mbatun, nun dad flaun fagu di Mtiu Tulus di dad to galan dek, dunan i dad to ta mgalékan. ");
INSERT INTO bpr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kafngen mati, fat falò butang klon fite i kton di dad to ayé, na nun fiten di dale dad ilè gugmadèla dun ta lê mték kenen mdà di fati. Teenla kenen, na lêan ale tdò gablà di Kagot i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na di satu du, lamla stifun di safédan, falnaun ale, manan, “Nangyu tayò tnagak Dyérusalém, bay fatanyu i tadè blé ta fakang Màgu i ta falagu tulen gamu di munan. ");
INSERT INTO bpr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Du munyag Dyan fagu di éél, bay di là mlon, bnunyag gamu fagu di Mtiu Tulus.” ");
INSERT INTO bpr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na di kastifunla ayé, ta snalek i dad to dekan kenen, manla, “Amu, ani nan kè i du kfulêam i kagot banwe Israél di dad ton?” ");
INSERT INTO bpr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bay tmimel Dyisas, manan, “I dad dangan na i dad du ta fala mgalék Mà fagu di kdatahan, landè gamu labet gmadè ku kilen i kakelan. ");
INSERT INTO bpr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bay ku ta kel di gamu i Mtiu Tulus, gamdawat gamu gal. Na gamu mgimò dad tmulen gablà di do di dad to dini di Dyérusalém, na di kabal i dad probinsya Dyudiya, na Samarya, na kel ditù di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Na kafngen man ayé, di lamla meye, tadè kenen magket mdà di blengla, na ta là teenla dun du ta glidung di labun. ");
INSERT INTO bpr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na lamla falmunu di langit di kagket Dyisas, tadè nun lwe to smaul bukay msut na tadag di safédla. ");
INSERT INTO bpr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na man i dad to ayé di dale, “E dad to mdà di Galili, kan ku sigi gamu tadag dini lngalà di langit? Dyisas, i ta magket mdà di safédyu, lê kenen samfulê dini di tah tanà salngad i ta kagketan ditù di langit.” ");
INSERT INTO bpr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na kafnge ayé, ta samfulê ale di Dyérusalém fdu di Bulul Olib. I bulul ayé, mdadong di Dyérusalém, nun dad satu kilumitru kè i kawagan. ");
INSERT INTO bpr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na di kakella di Dyérusalém, ta fusuk ale di satu gumnè, na fles ale di satu snifil ditù di tah i galla gufanak. Yé kdeela déé dunan Piter, Dyan, Dyém, Andru, Filip, Tomas, Bartolomyu, Matyu, Dyém dunan i ngà Alfyus, Simon dunan i to msen i banwen, na Dyudas i ngà Dyém. ");
INSERT INTO bpr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Na stifun i kdeela du sigi ale dmasal, na magin Méri, i yê Dyisas, na i dademe libun, na i dad flanek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na di satu du, lam i dad to ftoo di ku Dyisas stifun, nun kè dad mlatuh lwe falò i kdeela, na tadag Piter di blengla, manan, ");
INSERT INTO bpr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“E dad flanek, là fakay ku là gdohò i fala fgadè i Mtiu Tulus fagu di ku Dabid di munan gablà ku Dyudas, i mebe dad to kamfè ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kenen i satu di gito di munan du mgalék kenen du fye glam di nimòto.” ");
INSERT INTO bpr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","I filak gwè Dyudas di sasè nimòan, bayadan tanà. Na déé i gutatekan, guna i ulun, btù i tienan, na lamwà i tnain, na fles mati. ");
INSERT INTO bpr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na linge i kdee dad to di Dyérusalém i ta mkel di ku Dyudas. Taman, yé katlola i tanà ayé di dale talù, dunan Akildama, na yé gumtatekan Tanà Litè. ");
INSERT INTO bpr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na fadlug Piter talù, manan, “Ta gsulat di libru Salmo, manan, ‘Mulà moon ku tadè tnagak i gumnèan, na ku ta landè to mnè déé.’ Na lê nun sulat, manan, ‘Fye ku lê nun tlasan di nimòan.’ ");
INSERT INTO bpr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Na yé duenam man, là fakay ku landè tlas Dyudas, i satu to fakay tmulen gablà di kték i Amuto Dyisas di fati. Là fakay ku ise kenen satu to mdà di dad to gal magin di gito lamto magin ku Dyisas, balù mdà di kbunyag Dyan kel di kbatun Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Taman, malék ale lwe lagi, dunan Matyas na lê man Dyosip, i galla tlo Barsabas, na yé lê satu dagitla dun Dyustu. ");
INSERT INTO bpr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na kafnge ayé, dmasal ale, manla, “E Amu, gadèam i mnè di nawa i kdee dad to. Begam fgadè di gami ku nè di lwe to ani i ta nalékam, ");
INSERT INTO bpr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","du mgimò kenen tlas Dyudas, dunan i to tmagak i nimòan di galam kdek dun du salu kenen di banwe gten di kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na kafngela dmasal, ta munut ale, na yé mgalék dunan Matyas. Taman, ta gatnù kenen di dad sfalò satu to gal dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na di kakel Du Péntikus, déé gustifun i kdee dad to ftoo di ku Dyisas di satu gumnè. ");
INSERT INTO bpr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na tadè nun lingela bong luk mdà di langit gambet i too kamgis nus, na i luk ayé, lngaban i kabal gumnè gustifunla ayé. ");
INSERT INTO bpr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na nun teenla sawe malnak dinè, na sbalét ale na mdon di kat satu dale. ");
INSERT INTO bpr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na i kdee, ta fnò ale i Mtiu Tulus, na tambù ale talù i dad sahal talù mdà di kablé i Mtiu Tulus dun di dale. ");
INSERT INTO bpr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na di bang ayé, nun dad Dyu déé di Dyérusalém too fduf mangamfù di Dwata mdà di kdee dad sahal banwe di tah tanà. ");
INSERT INTO bpr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na kantola linge i luk na ugak fdu di lam i gumnè ayé, ta too dee dad to stifun déé. Na too ale tikeng du kat satu di dale, lingela i dale talù mdà di dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na yé duenam man, too ale tngah, na manla, “Ise glut kè yé gumdà kdee dad to talù ani di Galili? ");
INSERT INTO bpr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na kan dé ku fulung ale talù di gito talù? ");
INSERT INTO bpr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Du sahal sa i dad banwe gumdàto. Nun mdà di Parsya, Midya, Ilam, Mésopotamya, Dyudiya, Kapadosya, Pontu, Asya, ");
INSERT INTO bpr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigya, Pamfilya, Idyip, na dad banwe di Libya mdadong di Sirini. Na nun dademe dini lmauy mdà di banwe Roma. ");
INSERT INTO bpr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na nun dademe di gito tagnè Dyu, na i dademe, ta mulê ale di Dyu. Nun mdà di Krit, na nun lê man mdà di Arabya. Bay knèan, lingeto di gito talù gablà di dad nimò Dwata too gamtikeng.” ");
INSERT INTO bpr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mdà di ktikengla na klibugla, ta sasalek ale, manla, “Dét gumtatek i ta mkel ani?” ");
INSERT INTO bpr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bay nun dademe dad to déé, nadoyla ale, manla, “A, ta langal i dad to ani.” ");
INSERT INTO bpr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na kafnge ayé, ta tadag Piter magin di dademe dad sfalò satu dek Dyisas, na falbongan i talùan, manan, “E dad flanekgu Dyu, na i kdeeyu dini di Dyérusalém, too gamu beg flinge du nun kayègu faglabat di gamu. ");
INSERT INTO bpr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Man nawayu ku langal i dad to ani, bay là du tlabo tngà mnagad fa i du. ");
INSERT INTO bpr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bay ani kagdohò i man Dyowél, satu tugad i Dwata di munan, ");
INSERT INTO bpr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Man Dwata, “Ani nimògu kadang di fulé du. Bulusgu di kdee dad to i Tulusgu. Na i dad ngàyu, tugadla i tnalù Dwata, na i dad ngàyu sawang lagi, fnite Dwata ale dad kanteen, na i dad tua lagi di gamu, kamna ale mdà di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na di bang ayé, balù lagi na libun, lêgu bulus di dale i Tulusgu du fye tugadla i tnalùgu. ");
INSERT INTO bpr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na mimò agu dad gamtikeng di langit, na fitegu i dad ilè di tah tanà gambet litè, lifoh, na too mangfel buk. ");
INSERT INTO bpr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na kmifuh i du, na mbaling fulè i bulen gambet litè. Yé mkel di laman là fa kel Du i Amuto, dunan i du too mabtas na too tatel. ");
INSERT INTO bpr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na ku simto mni tabeng di Amuto, yé galwà.’ ”” ");
INSERT INTO bpr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na fadlug Piter talù, manan, “E dad to Israél, too gamu flinge. Ta too mbateng di gamu na Dyisas mdà di Nasarét, yé mdek dun i Dwata du mdà di dad tnikeng nimò Dwata fagu di kenen na i dad ilè i kdatahan. Ta tooyu gadè ani du dini gumgimòan di blengyu. ");
INSERT INTO bpr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mdà di gnadè na knayè Dwata, ta sansatun i nawan fye gablé Dyisas di gamu, na lêyu blé di dad to gamsalà du fafatiyu kenen fagu di kfatakla dun di krus. ");
INSERT INTO bpr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bay nték Dwata Dyisas mdà di fati, na falwàan kenen di gnagan i fati du landè kibò i fati mafas dun. ");
INSERT INTO bpr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na ani man Dabid gablà di kenen, ‘Sigigu teen i Amugu dini di safédgu. Dini kenen di kwanan-gu, du fye là bek nawagu. ");
INSERT INTO bpr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yé duenam man, too lehew i nawagu, na slame klehew lamwà di bàgu. Na balù ku mati agu, knèan nun sa fanden-gu, ");
INSERT INTO bpr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","du là sa bayàam i layefgu di banwe i dad mati, na là sa faloham ku balok laweh i Snaligam Too Tluh. ");
INSERT INTO bpr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta fitem di do i dad dalan fsalu di klawil, na fagu di kasnaginam di do, ta fnò agu i klehew.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Na fadlug Piter talù, manan, “E dad flanek, toogu faglabat gamu gablà ku Dabid, i gutambulto. Ta mati kenen, na ta lbangla, na sana knè i gulambangla dun di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Du Dabid i satu tugad Dwata, gadèan i fakang Dwata di kenen. Yé fakang Dwata di kenen nimòan harì i satu belan salngad kenen. ");
INSERT INTO bpr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ta fala gadè Dabid i fan nimò Dwata, taman tulenan gablà di kték i Mgalék Dwata, manan, ‘Là bayàan dun di lbang, na là balok i lawehan.’ ");
INSERT INTO bpr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na Dyisas Krayst i man-gu ani, ta nték Dwata kenen di fati, na i kdeemi mite dun. ");
INSERT INTO bpr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na ani, ta fdatah Dwata kenen du ta ditù kenen gsen di kwananan. Na ta gdawatan i Mtiu Tulus, i fakang Màan di kenen. Na i ta teenyu na i lingeyu ani, yé ta blén di gami du ta bulusan di gami i Tulusan. ");
INSERT INTO bpr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Du là sa mbatun Dabid kenen, bay ani manan, ‘Man Amu di Amugu, “Sudeng ge gsen di kwanan-gu, dunan i gufdatahta ge, ");
INSERT INTO bpr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kel di kafkahgu i dad to muteh ge nawa di dungan i falel blìam.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Yé duenam man, fye ku too gadè i kdee dad to di Israél na Dyisas, i fafatakyu di krus, kenen i ta nimò Dwata Amu na Krayst.” ");
INSERT INTO bpr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na kanto linge dad to i man Piter ayé, too malbà i nawala, na snalekla ale Piter na i dademe dad to dek Dyisas, manla, “E dad flanek, dét i fye nimòmi?” ");
INSERT INTO bpr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na tmimel Piter, manan, “I kdeeyu, msal, na fbunyag gamu fagu di dagit Dyisas Krayst du fye fnasinsya Dwata i dad salàyu, na gdawatyu i tadè blé Dwata, dunan i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yé gugtadè i fakang ani di gamu na di dad ngàyu na balù i dad to mnè di gumawagan, dunan i kdee ta tlo i Amuto Dwata di kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na dee fa man Piter di dale du toon ale fanngewe, manan, “Nang gamu magin di dad sasè nimò i dad to du fye là gagin gamu di kaflayam Dwata dale.” ");
INSERT INTO bpr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na dee dad to dmawat i manan ayé, ta fbunyag ale, na nun dad tlu libu i kdee gatnù di dad to ftoo di du ayé. ");
INSERT INTO bpr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na toola fabtas i kaflingela di tdò dad to dek Dyisas, na i kasgalakla. Na sasatu ale kmaan fan di kafaldamla ku Dyisas, na too ale dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na dee tnikeng na ilè mgimò fagu di dad to dek Dyisas, taman too tngah na likò i kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na i kdee dad to ftoo di ku Dyisas, fadlug ale di ksasatula, na i knun i kdee dad to, sansalel i kat satu. ");
INSERT INTO bpr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na fablila i dad knunla, na bléla i wèan di dad to nun kalnidù. ");
INSERT INTO bpr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na kat du, fadlug ale stifun di Bong Gumnè Gumangamfù di Dwata. Na sasatu ale kmaan di dad gumnèla fandamla i kfati Dyisas. Na di kakaanla, too ale lehew, na toola fdanà i ktola. ");
INSERT INTO bpr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na toola dnayen i Dwata, na i kdee dad to, toola ale nafè. Na kat du, nun dad to galwà tnù Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Di satu du di tngà masol i du di ta bang kdasal, gatù ale Piter na Dyan di Bong Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na déé di takab dnagit Fye Baweh, nun satu lagi kimay mdà di ksutan. Kat du, tundala kenen déé du mni filak di dad to fusuk. ");
INSERT INTO bpr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na kanton teen ale Piter na Dyan fusuk di Bong Gumnè ayé, ta mni filak di dale. ");
INSERT INTO bpr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na toola kenen falnunu, na man Piter di kenen, “Meye ge di gami.” ");
INSERT INTO bpr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na meye kenen di dale du yé man nawan ku banléla. ");
INSERT INTO bpr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bay man Piter di kenen, “Landè filakgu, ku demen blawen, bay ku dét i gunun-gu, yé bléta ge. Di dagit Dyisas Krayst mdà di Nasarét, magu ge.” ");
INSERT INTO bpr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na nagot Piter i sigalan gsen di kwanan, na ftadagan kenen, na tadè kamgis i blì na bukul blì i lagi kimay ayé. ");
INSERT INTO bpr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na tadè fabkeh tadag, na fkak na fles magu. Kafnge ayé, magin kenen di dale Piter fusuk di Bong Gumnè ayé. Na di kaginan dale, sigi kenen lmafà na fkak dmayen di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","I kdee dad to mite kenen magu na dmayen di Dwata, ");
INSERT INTO bpr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","gadèla na kenen i lagi tagnè sudeng di takab Fye Baweh di Bong Gumnè ayé du mni, na too tikeng na tngah i kdeela di kitela i ta mkel di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sana kagot i lagi ayé di ku Piter na Dyan kel di kgafatla di Balkun Solomon. Na tikeng i kdee dad to, na sadluh ale salu déé. ");
INSERT INTO bpr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na kanto teen Piter ayé, manan di dale, “E dad to di Israél, kan ku tikeng gamu mdà di teenyu ani? Kan ku tooyu gami falnunu? Yé man nawayu kè ku mdà di gami gnagan ku demen mdà di katluhmi i kgulê i lagi ani? Ise. ");
INSERT INTO bpr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bay i Dwata Abraham, Isaak, na Dyékob, dunan i Dwata dad gutambulto, kenen i ta fdatah ku Dyisas, i dekan. Gamu i mlé dun di dad ganlal, na là ti nsenyu dun di kanfe Pilato, balù ku yé kayè Pilato falwàan Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kenen i Mtiu na Tluh, bay là dnawatyu dun. Bay yé balingyu fni ku Pilato, yé falwàan i to manò. ");
INSERT INTO bpr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ta fnatiyu i gutambul i nawa, bay ta nték Dwata kenen di fati. Gami ta mite dun, na tulenmi di gamu. ");
INSERT INTO bpr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Fagu di kaftoo di dagit Dyisas, i lagi teenyu ani na dilèyu, ta kamgis na ta gagu. Na i kaftoo di ku Dyisas, yé i gamfgulê kenen, dunan i ta teenyu ani. ");
INSERT INTO bpr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Na ani, dad flanek, gadègu na yé duenyu mimò sasè ku Dyisas du là glabatyu i nimòyu salngad di dad ganlalyu. ");
INSERT INTO bpr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bay ta fala fgadè Dwata fagu di kdee dad tugadan di munan maflayam i Mgalékan, na ani kibò Dwata dmohò dun fagu di nimòyu ayé. ");
INSERT INTO bpr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yé duenam man, msal gamu na samfulê gamu di Dwata du fye Inanasan i dad salàyu, ");
INSERT INTO bpr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","du fye kel di gamu i dangan i falami kgis mdà di Amu, na dekan Dyisas, i ta falan nalék tmabeng gamu. ");
INSERT INTO bpr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Na Dyisas kenen, là fakay ku là funan mnè di langit kel di du kfalami Dwata i kdee, gambet i ta falan fgadè di munan fagu di dad tugadan too mtiu. ");
INSERT INTO bpr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Du ani man Mosis, ‘Di satu du, mdà i Amuyu Dwata, dekan di gamu satu tugadan, salngad di ta kdekan do. Kenen i satu dademeyu, na là fakay ku là falningeyu i kdee manan gamu. ");
INSERT INTO bpr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nè i to là mimen di man i tugad ayé, là flam Dwata dun di dad ton, bay falmon.’ ");
INSERT INTO bpr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na i kdee dad tugad i Dwata, mdà fa di ku Samwél, tulenla gablà di dad du ani. ");
INSERT INTO bpr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mdà i dad fakang Dwata blén fagu di dad tugadan, gamu i mfun dun, na nun alelyu di kasafnèla i dad gutambulyu. Salngad di ta manan ku Abraham, ‘Fagu di belam banlégu kafye i kdee dad to di tah tanà.’ ");
INSERT INTO bpr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Taman, ta nalék Dwata i Snaligan, na funan dek di gamu du fye banlén gamu kafye di kafkagolan gamu i dad sasè nimòyu.” ");
INSERT INTO bpr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Di lam Piter na Dyan talù, ta fdadong di dale i dad ganlal di kafaglut i dad Dyu, na i ulu i dad to gal mantay di Bong Gumnè Gumangamfù di Dwata, na i dad Sadusi. ");
INSERT INTO bpr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Na too ale falbut du yé tdò Piter na Dyan di dad to na mték i dad to mati fagu di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Taman, kanfèla Piter na Dyan, na fablanggùla ale kel di flafus du ta kifuh sa. ");
INSERT INTO bpr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bay dee dad to lminge i tdò Piter, na ta ftoo ale. Nun kè dad lime libu i kdee dad lagi. ");
INSERT INTO bpr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na di tmadol du, stifun di Dyérusalém i dad ganlal i dad Dyu, na i dad tua gal mebe i dad Dyu, na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na déé Anas, i ulu i dad ganlal di kafaglut i dad Dyu, na lê man Kayafas, na Dyan, na lê man Alihandru, na i dad flanek i ulu dad ganlal di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na fatlola Piter na Dyan, na snalekla ale, manla, “Nè gumdà i kgaganyu mimò tnikeng, na simto mfun dagit i gnamityu?” ");
INSERT INTO bpr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Piter, fnò i Mtiu Tulus, tnimelan ale, manan, “E dad ganlal na dad tua, ");
INSERT INTO bpr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ku gami snalekyu gablà di fye na gamtikeng nimòmi di to kimay, na i kgulêan, ");
INSERT INTO bpr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","fye ku gamu na i kdee dademe dad to Israél too gmadè ani. Ta tadag i to ani di blengyu, na sikof i kgulêan fagu di kaltulus i dagit Dyisas Krayst mdà di Nasarét, dunan i ta fnatakyu di krus, bay lê nték Dwata di fati. ");
INSERT INTO bpr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na Dyisas sa i tulen di Tnalù Dwata, manan, ‘Nun gumnè slame batu, na i satu batu déé too mabtas, yé balingyu knang gamu dad to fdak gumnè.’ ");
INSERT INTO bpr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","I kagalwà, lo déé gumite dun di ku Dyisas Krayst, du landè dademe dagit di klamang banwe blé Dwata di dad to ku gamfalwà gito.” ");
INSERT INTO bpr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Too tikeng i dad ganlal ayé du teenla i klabè Piter na Dyan, na gadèla na lo ale btal to na landè sankulla. Yé klola too gmadè dun na Piter na Dyan i dademe Dyisas sagin di munan. ");
INSERT INTO bpr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bay landè gmanla du toola teen i to ta mgulê ayé tadag di saféd ale Piter na Dyan. ");
INSERT INTO bpr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na yé duenam man, ta dalugla ale Piter lamwà di snifil gumukum dad too mdatah ganlal, na yé klola sasalek, manla, ");
INSERT INTO bpr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Dét fye kibòto i dad to ani? I kdee dad to mnè di Dyérusalém slame gmadè na too gamtikeng i mgimòla, na landè kibòto famkéng dun. ");
INSERT INTO bpr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bay ani nimòto, fnangto i dad to ayé tamdò di dagit Dyisas du fye là too mbel i santulen gablà di ta mkel ani.” ");
INSERT INTO bpr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na yé duenam man, ta lêla fatlo Piter na Dyan, na toola ale fnang tmulen na tamdò di dagit Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bay tmimel Piter na Dyan, manla, “Fandamyu kun ku dét i tluh nimò di kanfe i Dwata, gamu i nimenmi, ku demen Dwata i nimenmi. ");
INSERT INTO bpr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Du là gaganmi damnan i ktomi ku là tulenmi i ta teenmi na i ta lingemi.” ");
INSERT INTO bpr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bay ta baling too midul i kafnangla dale Piter na Dyan, na yé klola falwà dale. Landè kibòla falmayam dale du i kdee dad to, toola dnayen i Dwata du mdà di ta mkel di lagi ayé. ");
INSERT INTO bpr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yé ta ktua i lagi mgulê fagu di tnikeng nimò mlukas fat falò fali. ");
INSERT INTO bpr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na kanto galwà Piter na Dyan, ta samfulê ale di dademela, na tulenla dale i kdee man dad ganlal di kafaglut na i dad tua di dale. ");
INSERT INTO bpr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na kanto linge i dademela, sasatu ale dmasal di Dwata, manla, “E Too Mdatah Amu, ge sa mimò i langit, tanà, mahin, na i kdee mnè di lamla. ");
INSERT INTO bpr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fagu di Mtiu Tulus, talù ge fagu di snaligam, Dabid, dunan i gutambulmi, manam, ‘Kan ku falbut i dad to ise Dyu? Na kan ku yé fandam i dad to i dad nimò landè gukel? ");
INSERT INTO bpr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Fatlagad i dad harì di tah tanà, na stifun i dad ganlal du sansatula i nawala samfati i Dwata na i Mgalékan.’ ");
INSERT INTO bpr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na glut, dini di syudad ani gustifun ale Harì Hérod na Pontyus Pilato magin di dad to ise Dyu, na lê man i dad Dyu mdà di Israél du sasatu ale dmuen i Snaligam Too Mtiu, dunan i Mgalékam. ");
INSERT INTO bpr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na fagu déé, ta balingla gimò i kdee ta fala mnè di nawam fagu di kaltulusam na i knayèam. ");
INSERT INTO bpr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na ani, Amu, gadèam i dad kaflikòla gami. Gami dad fasakam. Banlém gami klabè tamdò i Tnalùam. ");
INSERT INTO bpr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bantalam i sigalam famgulê na mimò dad tnikeng na ilè fagu di dagit Dyisas, i Snaligam Too Mtiu.” ");
INSERT INTO bpr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na kafngela dmasal, ta mgingok i gumnè gustifunla. Na i kdeela fnò i Mtiu Tulus, na ta baling midul i klabèla tamdò Tnalù i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na i kdee dad to ftoo di ku Dyisas, too sasatu nawala na i fandamla. Na landè di dale famdam ku lo kenen mfun i knunan. Bay sablé i kdeela di kdee dad knunla. ");
INSERT INTO bpr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Fagu di bong gnagan blé Mtiu Tulus di dad to dek Dyisas, fadlug ale tmulen gablà di kték i Amuto Dyisas, na nun bong kafye Dwata kel di kdee dad to. ");
INSERT INTO bpr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na landè di dale ku nun dè kalnidùan du i dad to mfun i dad gumnè na dad tanà, fablila na nebela i wèan ");
INSERT INTO bpr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","di dad to dek Dyisas du fye nalella di kat satu dad to nun kalnidù. ");
INSERT INTO bpr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na Dyosip i satu di dale, i dnagit dad to dek Dyisas Barnabas (yé gumtatekan To Tamgal Nawa). Mdà kenen di dad bel Libay, na déé gusutan di Sipru. ");
INSERT INTO bpr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na fablin i satu alel tanàan, na blén i wèan di dad to dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na lê nun satu lagi, yé dagitan Ananayas, na yé yaanan Safira. Na fablila satu alel tanàla. ");
INSERT INTO bpr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na kanto gwè Ananayas i wèan, busekan i dademe wèan, na nè i gdè, yé blén di dad to dek Dyisas. Na i kdee nimòan ayé, slame gadè i yaanan. ");
INSERT INTO bpr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na smalek Piter, manan, “Ananayas, kan ku fgebe ge ku Satanas fagu di ktulenam kéng di Mtiu Tulus na di kbusekam i dademe wèan. ");
INSERT INTO bpr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Di lamam là fabli i tanàam, ge sa i mfun dun. Na kantom fabli, ge mfun i wèan, na balù dét i kayèam kibò dun, fakay sa. Dét i duenam mimò ani? Ise ku yé gutmulenam kéng di dad to, bay di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na kanto linge Ananayas i man Piter ayé, tin tadè bek, na fles mati. Na too ti likò i kdee dad to lminge i ta mkel di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na kafnge ayé, ta nun fusuk déé dad lamnok lagi du fnungasla i lawehan, na santiangla lamwà du lbangla. ");
INSERT INTO bpr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na kafnge dad tlu oras, ta lê fusuk i yaanan, bay là gadèan i ta mkel di ku Ananayas. ");
INSERT INTO bpr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na snalek Piter kenen, manan, “Tnimelam i salekgu di ge ani. Ta senan ani kè i wè i tanà fabliyu?” Na tmimel kenen, manan, “Hee, senan sa ayé.” ");
INSERT INTO bpr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na man Piter di kenen, “Kan ku sansatuyu i nawayu tmilew i Tulus Dwata? Neyem. I dad lagi lambang i yaanam, ta déé ale di bà takab du lêla ge lbang.” ");
INSERT INTO bpr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na di kman Piter ayé, tadè lê bek Safira kenen di saféd i blì Piter, na fles mati. Na i dad lagi ayé, ta lê ale fusuk, na kantola teen na ta mati kenen, ta lêla santiang du lbangla di saféd i yaanan. ");
INSERT INTO bpr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na too ti likò i kdee dad to ftoo di ku Dyisas na kel di kdee dad to lminge gablà di dad mgimò ayé. ");
INSERT INTO bpr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na too dee dad tnikeng na dad ilè nimò i dad to dek Dyisas di kanfe i dad to. Na gal stifun i kdee dad to ftoo di ku Dyisas déé di Balkun Solomon di Bong Gumnè Gumangamfù di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nun dademe dad to là ftoo, là glasla magin di dale du mdà di klikòla, balù toola ale nafè. ");
INSERT INTO bpr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bay baling too midul i kdee dad lagi na libun ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na mdà di nimò dad to dek Dyisas, nebe dad to i dademela nun tduk di dad dalan, na filèla ale di dad katri na dad igem du fye ku ta magu Piter déé, gtadè di dale i alungan, na mgulê ale. ");
INSERT INTO bpr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na too dee dad to mdà di dad lunsud glibut di Dyérusalém, lê ale stifun déé, na nebela i dademela nun tduk na i dad to fnusuk busaw. Na i kdee dad to nebela ayé, sdulê ale mgulê. ");
INSERT INTO bpr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Bay, i ulu dad ganlal di kafaglut i dad Dyu na lê man i dademen, dunan i dad to glam di dad Sadusi, mafè nawala. Taman, meye ale kfagu msang dale. ");
INSERT INTO bpr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kanfèla i dad to dek Dyisas du fablanggùla ale. ");
INSERT INTO bpr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bay kanto kifuh, nun kasaligan i Dwata kel déé di blanggù du nukàan i dad takab, na neben ale lamwà. ");
INSERT INTO bpr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Na man i kasaligan di dale, “Salu gamu di Bong Gumnè Gumangamfù di Dwata, na tadag gamu déé, na tulenyu gablà di falami nawa.” ");
INSERT INTO bpr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na mimen i dad to dek Dyisas du di too flafus, ta fusuk ale di Bong Gumnè ayé, na tambù ale tamdò. I ulu i dad ganlal di kafaglut i dad Dyu na i dademen, santifunla i dad tua i dad Dyu, dunan i dad too mdatah ganlalla gal mukum, na fatlola i dad to dek Dyisas di blanggù. ");
INSERT INTO bpr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bay kanto ale kel di blanggù, là teenla ale Piter déé. Taman, ta lê ale samfulê di dad to mdek dale, na tulenla dale, manla, ");
INSERT INTO bpr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Di kakelmi di blanggù, teenmi too fye kagtakaban, na sana ktadag déé i dad to mantay, bay kantomi nukà i takab, landè to teenmi di lam.” ");
INSERT INTO bpr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na i ulu dad to mantay di Bong Gumnè Gumangamfù di Dwata na i dad ganlal di kafaglut i dad Dyu, kantola linge i man dad to dekla, libug fandamla ku dét i ta mkel di dale Piter. ");
INSERT INTO bpr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na nun to kel déé, manan dale, “I dad lagi ta tusukyu di blanggù, ta lê ale tadag du tamdò di Bong Gumnè Gumangamfù di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na kantola linge ayé, ta mdà i ulu i dad mantay na i dademen salu ditù di Bong Gumnè ayé, na nebela samfulê i dad to dek Dyisas. Bay là falnayamla ale du likò ale di dad to keng ndakla ale batu. ");
INSERT INTO bpr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na kantola nebe i dad to dek Dyisas di gustifunla, ftadagla ale di kanfe i dad ganlal, na snalek i ulu i dad ganlal di kafaglut i dad Dyu ale. ");
INSERT INTO bpr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Na man i ulu ayé di dad to dek Dyisas, “Ta toomi gamu fnang tamdò di dagit Dyisas. Bay neyeyu i nimòyu ani. Ta baling too mbel i katdòyu dini di Dyérusalém, na duenyu di gami i kfati Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bay tmimel Piter na i dademe to tdò Dyisas, manla, “Yé too mabtas nimenmi i Dwata, ise ku to. ");
INSERT INTO bpr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I Dwata fnangamfù i dad gutambulto, kenen i mték ku Dyisas kafngeyu fmati kenen fagu di kfatakyu dun di krus. ");
INSERT INTO bpr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na fdatah Dwata kenen fagu di kafsudengan dun di kwananan, na nimòan kenen Ulu na Falwà. Yé duenan mimò ayé du banlén dalan i dad to di Israél msal du fye fnasinsya Dwata i dad salàla. ");
INSERT INTO bpr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gami sa i ta mite na tmulen i kdee ayé, na lê man i Mtiu Tulus, i tadè blé Dwata di dad to mimen kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na kanto linge dad ganlal i man Piter, too ale falbut, na kayèla fafati i dad to dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bay nun satu Farisi, yé dagitan Gamalyél. Satu kenen tamdò i dad uldin Dwata fagu di ku Mosis, na too nafè i dad to kenen. Ta tadag, na dekan i dad to, nebela lamwà i dad to dek Dyisas là mlo. ");
INSERT INTO bpr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Klon man di dademen ganlal déé, “E dad to di Israél, tooyu fan-geye i nimòyu di dad to ayé. ");
INSERT INTO bpr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nun satu to di munan, yé dagitan Tudas, na flingu bong to, na nun dad fat latuh i kdee dad to magin dun. Bay di là mlo, nun fmati kenen, na ta sbalét i kdee dad ton, na landè gukel i dad nimòan. ");
INSERT INTO bpr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na kafnge ayé, ta lê nun to mdà di Galili, yé dagitan Dyudas. Msut kenen di slà kse i dad to. Na dee dad to magin di kenen, bay kanto kenen fnati, ta lê sbalét i dad ton. ");
INSERT INTO bpr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na yé duenam man, ani fngewegu di gamu gablà di dad to ani. Tiyu ale bayà. Falwàyu ale. Ku yé gumdà i tdòla di to, lê landè gukelan. ");
INSERT INTO bpr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bay ku yé gumdàan di Dwata, là gaganyu ale fnang, du yé balingyu sanfati i Dwata.” Na nagin dad ganlal i flau Gamalyél. ");
INSERT INTO bpr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yé duenam man, ta lêla fatlo i dad to dek Dyisas, na fafasla ale. Na kafnge ayé, toola ale fnang tamdò di dagit Dyisas, na klola falwà dale. ");
INSERT INTO bpr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na ta mdà i dad to dek Dyisas fdu di gustifun i dad ganlal ayé, na too ale lehew du di kite Dwata dale, gten ale maflayam di kyà du mdà di dagit Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na kat du, ditù ale di Bong Gumnè Gumangamfù di Dwata na lê man di dad gumnè, du fadlug ale tamdò na tmulen i Fye Tulen gablà ku Dyisas, i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta midul i kdee dad to ftoo di ku Dyisas. Na di slà ayé, i dad Dyu talù Grik, mugak ale gablà di nimò i dad Dyu talù Hibru du là gagin banlé i dale dad libun balu di kalel i dad gastu kat du. ");
INSERT INTO bpr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yé duenam man, i sfalò lwe to dek Dyisas, santifunla i kdee dad to ftoo, na manla, “Là gtenan ku gami i malel i dad gastu, keng gtagakmi i katdò Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Taman, dad flanek, malék gamu fitu lagi mgafè na fnò i Mtiu Tulus na kfulung, na dale fimòmi dun, ");
INSERT INTO bpr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","du fye lo yé nimòmi dmasal na tamdò i Tnalù Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na too mayè i kdee dad to di manla ayé. Na yé nalékla Stifén, satu lagi too ftoo di ku Dyisas, na fnò i Mtiu Tulus, na lê man Filip, na Prokoru, na Nikanor, na Timon, na Parminas, na lê man Nikolas mdà di banwe Antyuk, i satu to ise Dyu, bay ta mgebe di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na nebela i dad fitu lagi ayé di dad to dek Dyisas, na mdà i dad to dek Dyisas, fkahla i falella di dale, na dnasalla ale. ");
INSERT INTO bpr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Taman, ta too mbel i Tnalù Dwata, na ta baling midul i kdee dad to ftoo di ku Dyisas di Dyérusalém, na ta lê dee i dad ganlal di kafaglut i dad Dyu magin ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na Stifén, too kenen fnò kafye blé Dwata na kgagan mimò dad malbang ilè na tnikeng di kanfe i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bay nun dad to mnang ku Stifén, dunan i dad Dyu mdà di gustifun dnagit Gustifun i Dad Fasak Ta Falwà. Yé gumdàla di Sirini na Alihandriya na lê man i dademe dad banwe di Silisya na Asya. Dale i sambalew ku Stifén, ");
INSERT INTO bpr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","bay du banlé i Mtiu Tulus Stifén kfulung, yé duenam man, là gmagan ale di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bay falnaula i dademe dad to magu lam, du fye tmulen ale kéng. Na ani man i dad to ayé, “Ta lingemi i sasè kastulenan ku Mosis na i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na fagu déé, banlétla nawa i dad to, na i dad tua gal mebe i dad Dyu, na i dad to gal tamdò i dad uldin Dwata fagu di ku Mosis. Na kanfèla Stifén, na nebela di gustifun i dad too mdatah ganlal i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na nun dad to ftalùla déé i too tmulen kéng tmifù ku Stifén, “I to ani, too sasè ktalùan gablà di Bong Gumnè Gumangamfù di Dwata, na i dad uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na lingemi i kmanan dun, Dyisas mdà di Nasarét, lanbàan kun i Bong Gumnè, na tanlasan i dad uldin Dwata tagak Mosis di gito. ");
INSERT INTO bpr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na i kdee dad ganlal, falnunula Stifén, na teenla i bawehan salngad baweh i satu kasaligan. ");
INSERT INTO bpr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na i ulu dad ganlal di kafaglut i dad Dyu, snalekan Stifén, manan, “Glut kè i kdee man dad to ani?” ");
INSERT INTO bpr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na tmimel Stifén, manan, “E dad flanek na dad tua, tooyu beg falninge i man-gu. Di munan, di laman là fa milih i gutambulto, dunan Abraham, ditù di Haran, yé gumnèan di Mésopotamya. Na di laman mnè déé, fite di kenen i Dwata Too Mdatah na Maltulus, manan, ");
INSERT INTO bpr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Tnagakam i banwem na dad flanekam, na mdà ge salu ditù di banwe fiteta ge.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na yé duenam man, ta mdà kenen di Kaldiya, na milih ditù di Haran. Na kafnge i kfati màan, ta dek Dwata kenen fles di banwe ani, dunan i ta gumnèyu ani. ");
INSERT INTO bpr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Landè fa blé Dwata di ku Abraham alel i tanà, balù salngad tah falel. Bay ta makang i Dwata di kenen na blén dun i tanà ani, du fye ta kenen nan mfun dun kel di dad belan. Na di kfakang Dwata ayé, fa landè ngà Abraham. ");
INSERT INTO bpr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na ani man Dwata di kenen, ‘I dad belam, mnè ale di mahal banwe, na nimòla ale fasak, na toola ale falnayam di lam i fat latuh fali klon. ");
INSERT INTO bpr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bay falnayamgu i dad to fmasak dale, na kafnge ayé, lamwà ale di banwe ayé, na mangamfù ale di do di banwe ani.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na kafnge ayé, ta dek Dwata Abraham gablà di kfimò ilè di laweh i dad lagi, du yé ilè i kasafnèla. Na ta sut Isaak, na mimò Abraham ilè di lawehan di gwalun du kafngen sut. Na salngad ku Dyékob kafngen sut, lê nimò Isaak ilè di lawehan, na kel di dad sfalò lwe ngà Dyékob, i dad gutambulto. ");
INSERT INTO bpr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na mafè nawa i dad flanek Dyosip di kenen, na fablila kenen mgimò fasak di Idyip. Bay Dwata magin kenen, ");
INSERT INTO bpr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na falwàan kenen di kaflayaman. Di ktadag Dyosip di kanfe Féro, i harì di Idyip, bayan Féro di kafye balun na di kfulungan. Na nimò Féro kenen gubirnador di banwen ayé na kel di gumnèan. ");
INSERT INTO bpr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na kafnge ayé, nun kel bong kbitil di kabal i banwe Idyip na Kanaan, taman, too ti sè kaflayam i dad to di dangan ayé. Balù i dad gutambulto, ta landè gumwèla knaan. ");
INSERT INTO bpr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na kanto linge Dyékob nun ulê i dad fele di Idyip, ta dekan i dademe dad ngàan salu ditù, dunan i dad gutambulto. Na yé tnanin ksalula ditù. ");
INSERT INTO bpr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na di galwe dulêla salu gatù, ta fdilè Dyosip i kton di dad flanekan, na di là mlon, ta gadè Féro gablà di dad flanek Dyosip. ");
INSERT INTO bpr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Taman, fan-gadè Dyosip i màan Dyékob, na fngén kenen na i dad flanekan gatù di Idyip. Na fitu falò lime i kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na kafnge ayé, ta milih ale Dyékob ditù di Idyip, na ditù ta gumatin na i dad gutambulto. ");
INSERT INTO bpr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na nebela ale samfulê di Sikim, na lbangla ale di ilib ta fala bnayad Abraham di dad bel Hamor. ");
INSERT INTO bpr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na kanto mdadong i kdohò Dwata i fakangan ku Abraham, ta baling too matnù i kdee dad gutambulto di Idyip. ");
INSERT INTO bpr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na kanto matlas i harì di Idyip, là dilèan Dyosip. ");
INSERT INTO bpr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na i harì ayé, toon lnumì i dad gutambulto, na falnayaman ale du fnegesan ale tmagak i dad malnak ngàla ditù di lwà fye mati ale. ");
INSERT INTO bpr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na di slà i kaflayam ayé, sut Mosis. Bayan Dwata kenen, na too ti fye bawehan. Na tlu bulen i klola mifat dun di gumnè màan. ");
INSERT INTO bpr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na kantola tnagak Mosis ditù di lwà, mdà i ngà Féro libun, talnamòan du fanbalingan ngàan. ");
INSERT INTO bpr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tdòla kenen di kdee kanfulung i dad to di Idyip, na mgimò kenen tatel fagu di dad talùan na di dad nimòan. ");
INSERT INTO bpr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na kanto fat falò fali ktua Mosis, yé gtulen nawan lmauy i dademen Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na kanto kel Mosis déé, nun teenan Dyu falnayam i satu to mdà di Idyip, na nsenan i Dyu ayé, na fnatin i to mdà di Idyip. ");
INSERT INTO bpr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Yé mnè di nawa Mosis ta gadè i dademen Dyu na kenen i gnamit Dwata falwà dale di Idyip, bay là ti gadèla dun). ");
INSERT INTO bpr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na di tmadol du, nun teen Mosis lwe Dyu, sfati ale. Mayè kenen samfye dale, na manan dale, ‘E dad flanek, kan ku sfati slame gamu?’ ");
INSERT INTO bpr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Bay i lagi mbet sfati, lugadan Mosis, manan, ‘Simto mimò ge bong to na mukum gami? ");
INSERT INTO bpr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yé kayèam kè ku fnatim agu gambet i kfatim i to mdà di Idyip balfabi?’ ");
INSERT INTO bpr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na kanto linge Mosis i manan ayé, ta milah ditù di Midyan na ditù gumnèan, na mwè yaan. Na déé gusut i lwe ngàla, slame lagi. ");
INSERT INTO bpr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Na kanto fat falò fali mlius, ditù Mosis di banwe landè to mnè ditù mdadong di Bulul Sinay. Nun kasaligan i Dwata tadè msut di kenen di lam kayu dminè. ");
INSERT INTO bpr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Na too kenen tikeng di teenan ayé. Na fdadong déé du neyen. Na di kafdadongan, ta lingen i talù Dwata. Ani manan, ");
INSERT INTO bpr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Do i Dwata fnangamfù i dad gutambulam, dunan Abraham, na Isaak, na Dyékob.’ Na tadè kankal Mosis di klikòan, na là glasan meye dun. ");
INSERT INTO bpr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na man Dwata di kenen, ‘Nlusam i talumfàam du mtiu i tanà gutadagam ayé. ");
INSERT INTO bpr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ta teen-gu i kaflayam gnagu i dad togu di Idyip. Ta lingegu i dalongla, na ta tufa agu du falwàgu ale. Na. Flal ge du dekta ge gatù di Idyip.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na Mosis ani, i knang dad to Israél di munan, manla di kenen, ‘Simto mimò ge bong to na mukum gami?’ Kenen dek Dwata mebe na falwà i dad to ayé fagu di ktabeng i kasaligan fite di kenen di kayu dminè. ");
INSERT INTO bpr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na nebe Mosis ale lamwà di Idyip, na nun dad tnikeng na dad ilè nimòan di Idyip, na di Fulè Mahin, na lê man di banwe landè to mnè ditù di lam fat falò fali klon. ");
INSERT INTO bpr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na Mosis sa i man dun di dad to Israél, ‘Nun satu tugad Dwata mdà di dademeyu dekan di gamu salngad do.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na Mosis i magin di kastifun i dad to Israél di banwe landè to mnè ditù, di saféd i dad gutambulto na balù i kasaligan Dwata, i talù di kenen di Bulul Sinay. Na gdawatan mdà di Dwata i mlawil tdò du fye lêan fafles di gito. ");
INSERT INTO bpr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Bay i dad gutambulto, là nimenla dun. Balingla kenen knagol, na yé kayèla ku lê ale samfulê ditù di Idyip. ");
INSERT INTO bpr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na di lam Mosis ditù di tah i Bulul Sinay, manla di ku Aron, i satu bong tola, ‘Mimò ge gami dad dwata fye mnè tukè munami, du Mosis, i mebe gami lamwà di Idyip, ta là gadèmi ku dét i ta mkel di kenen.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Taman, ta nun nimòla dwata, yé kbawehan ngà safì. Na damsù ale di kenen, na fnistala. ");
INSERT INTO bpr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bay knagol Dwata ale, na bayàan ale mangamfù di dad blatik. Na gdohò i sulat satu tugad i Dwata di munan, manan, ‘Gamu dad to Israél, ise ku do i gumdamsùyu na i gumléyu di kloyu mnè di banwe landè to mnè ditù di lam i fat falò fali klon. ");
INSERT INTO bpr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bay yé balingyu nebe i tukay gumnè i dwata dnagit Molok, na lê man Rifan, i kbaweh blatik. Na yé dad dwata fnangamfùyu. Yé duenam man, falnayamta gamu du febeta gamu ditù di satu banwe sentù Babilon.’ ");
INSERT INTO bpr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Di kagu i dad gutambulto di banwe landè to mnè ditù, nun slung di safédla gusamsitela i Dwata. Ta nimò Mosis i slung ayé du yé dek Dwata dun, na lalòan i baweh ta fite Dwata di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Na kafnge ayé, yé tamlas mebe i slung ayé dunan i dad gutambulto magin ku Dyaswa mwè i tanà mdà di dad to ta filih Dwata di kanfela. Na i slung ayé, sana knèan déé kel di kagot Harì Dabid. ");
INSERT INTO bpr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kanto gamdawat Dabid kafye mdà di Dwata, yé fnin di kenen, falohan kenen fdak gumnè blén di Dwata, dunan i lê Dwata Dyékob. ");
INSERT INTO bpr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bay Solomon i ngà Dabid, yé baling fdak i gumnè ayé. ");
INSERT INTO bpr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bay di kaglutan, i Too Mdatah Dwata, là sa mnèan di dad gumnè fdak i dad to tanà, du ani man satu tugad i Dwata, ");
INSERT INTO bpr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘I langit, yé gusudenggu, na i tanà, yé gumlékgu. Dét klasi gumnè i fdakyu do? Na nè man nawayu gten guftudgu? ");
INSERT INTO bpr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ise do kè mimò kalbong kdee?’ ” ");
INSERT INTO bpr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Na fadlug Stifén talù, manan, “Bay gamu dini, too magéng uluyu, na là falningeyu i man Dwata. Salngad gamu di dad gutambulyu du galyu knang i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nun kè tugad i Dwata là falnayam i dad gutambulyu? Landèan, du fnatila i dad to dek Dwata di munan, kel di dad to ta fala fgadè gablà di kakel i Snaligan Too Tluh. Na kanto kel i To manla ayé, ta nakalyu, na fnatiyu. ");
INSERT INTO bpr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gamu gamdawat i dad uldin Dwata fagu di dad kasaliganan, bay là nimenyu dun.” ");
INSERT INTO bpr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na di lam i dad ganlal flinge di man Stifén, san-gakétla beengla di kalbutla dun. ");
INSERT INTO bpr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bay Stifén, fnò kenen i Mtiu Tulus, ta lngalà di langit, na teenan kneng i kaltulus Dwata, na teenan Dyisas tadag gsen di kwanan i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na man Stifén, “Neyeyu. Teen-gu i langit ta mgukà, na i Ngà To tadag gsen di kwanan i Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Taman, ta nsangla dad klingela, na mkit ale, na sdulêla dnauf. ");
INSERT INTO bpr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na dyolla kenen lamwà di syudad, na ndakla batu. Na i dad to tmifù dun, yé fbantayla i dad saulla Sol, i satu lamnok lagi. ");
INSERT INTO bpr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na lamla sigi mdak ku Stifén batu, ta dmasal kenen, manan, “E Amugu Dyisas, dnawatam i nawagu ani.” ");
INSERT INTO bpr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na kafnge ayé, ta lkuad kenen, na tamlo, manan, “E Amu, nangam ntuk di dale i salà nimòla ani.” Na di kafngen man ayé, ta ftoh nawan. ");
INSERT INTO bpr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na nagin Sol i ayè i dad to fmati ku Stifén. Na di du kfatila ku Stifén, yé ta katbù i too sasè kaflayam i dad to ftoo di ku Dyisas di Dyérusalém. Taman, ta sbalét i kdeela di dad probinsya di Dyudiya na Samarya, na lo yé tagak di Dyérusalém i dad to dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na nun dad to too mangamfù di Dwata, lbangla Stifén, na toola kenen lnanu. ");
INSERT INTO bpr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bay too kayè Sol falmo i dad to ftoo di ku Dyisas. Nkatan fnusuk i dad gumnèla, na kanfèan i dad lagi na libun, du fablanggùan ale. ");
INSERT INTO bpr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na i kdee dad to ftoo i ta masbalét ayé, gatù ale di dad sahal banwe du tdòla i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na mdà Filip, salu kenen di satu syudad di Samarya, na tamdò kenen déé gablà ku Krayst. ");
INSERT INTO bpr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na kanto linge dad to i man Filip, na teenla i dad tnikeng nimòan, toola fansye flinge di manan. ");
INSERT INTO bpr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na dee dad busaw lamwà di dad to magin i kitla, na lê dee dad to là galyakla i lawehla, na dad kimay, na mgulê i kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taman, too ti lehew i dad to di syudad ayé. ");
INSERT INTO bpr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na di syudad ayé, nun satu lagi mnè déé, yé dagitan Simon. Ta mlo kenen lmoos, na too tikeng i kdee dad to di Samarya du mdà di kloosan. Toon ftatel i kton di kmanan dun maltulus kenen. ");
INSERT INTO bpr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na i kdee dad to, balù mdanà ku demen mdatah, toola fansye flinge di kenen, na yé manla, “Kenen i tulus Dwata dnagit, ‘I bong tulus.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ta mlo ale tikeng di kloosan, taman toola kenen falninge. ");
INSERT INTO bpr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bay kanto ftoo dad to di tdò Filip i Fye Tulen gablà di Kagot Dwata, na i dagit Dyisas Krayst, ta fbunyag i dad lagi na dad libun. ");
INSERT INTO bpr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na balù Simon, ta baling kenen lê ftoo di ku Dyisas na fbunyag. Na là tlagan magin di ku Filip, na too kenen tikeng mdà di dad ilè na gamtikeng nimò Filip. ");
INSERT INTO bpr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na i dad to dek Dyisas i tagak di Dyérusalém, lingela ta dnawat i dad to di Samarya i Tnalù Dwata, taman ta dekla Piter na Dyan salu ditù. ");
INSERT INTO bpr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na kanto ale kel ditù, ta dnasalla i dad to ftoo ayé du fye gdawatla i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ani duen i Mtiu Tulus là fa tufa di dale du lo yé gumagbunyagla di dagit i Amuto Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bay fkah Piter na Dyan i dad falella di dad to ayé, na yé klola gamdawat i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na teen Simon ta gdawat dad to i Mtiu Tulus fagu di kafkah ale Piter i dad falella di dale. Na yé duenam man, kayèan ku banlén filak ale Piter, na manan dale, ");
INSERT INTO bpr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Bléyu do i gnagan ayé du fye i kdee dad to gufkahgu falelgu, gdawatla i Mtiu Tulus.” ");
INSERT INTO bpr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bay tmimel Piter, manan, “Mulà moon ku malmo ge gagin di filakam, du yé man nawam ku fakay bnayad i tadè blé Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Landè alelam di nimò ani du teen Dwata là tluh i mnè di nawam. ");
INSERT INTO bpr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nsalam i sasè mnè di nawam ani, na dmasal ge di Amu, du fye fnasinsyan ge di sasè fandamam. ");
INSERT INTO bpr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Du yé teen-gu di ge na too mafè nawam, na mbakus ge di salàam.” ");
INSERT INTO bpr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Na man Simon di dale Piter, “Begyu agu dnasal di Amu du fye là gafat di do i manyu ayé.” ");
INSERT INTO bpr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na kafnge Piter na Dyan tamdò i Tnalù Dwata, ta mdà ale mulê ditù di Dyérusalém. Na di dalanla mulê, dee dad baryu di Samarya nagula, na tdòla i Fye tulen. ");
INSERT INTO bpr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bay stulen satu kasaligan i Dwata di ku Filip, “Mdà ge, lalòam i dalan mdà di Dyérusalém salu di Gasa.” (Ta là too nagu i dalan ani du landè to mnè déé). ");
INSERT INTO bpr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na yé duenam man, ta mdà Filip, na di laman magu, nun teenan satu lagi kafun mdà di Ityupya. Fdu kenen di Dyérusalém du ta mangamfù di Dwata. Na i lagi ayé, satu mdatah ganlal du nagotan i filak Kandis, dunan i harì libun di Ityupya. ");
INSERT INTO bpr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na di kulêan, smakay kenen kalisa, na laman magu, yé nimòan bnasan i sulat Isaya, i satu tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na man i Mtiu Tulus di ku Filip, “Fdadong ge, na saldan ge magu di kalisa ayé.” ");
INSERT INTO bpr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Taman, sadluh Filip fdadong di kalisa, na lingen kbasa i lagi ayé mdà di sulat Isaya. Na smalek Filip, manan dun, “Glabatam kè i bnasam ayé?” ");
INSERT INTO bpr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na tmimel i ganlal ayé, manan, “Dét kibògu galmabat i bnasagu ani ku landè to faglabat dun di do?” Na ta nlakan Filip smakay sudeng di safédan. ");
INSERT INTO bpr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na ani bnasa i ganlal ayé, manan, “Gambet kenen i bilibili nebe du tnatê, na gambet kenen i ngà bilibili là kamwakan ku nkih i bulan, du là ti talùan. ");
INSERT INTO bpr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Toola kenen fyà, na là sa tluh i kukumla dun. Na ta landè tmulen gablà di dad belan du ta baling kenen fnati dini di tah tanà.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na man i ganlal, “Begam tulen do ku simto kayèan man ani, kenen kto ku demen mahal to.” ");
INSERT INTO bpr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yé duenam man, ta tnulen Filip i ganlal ayé i Fye Tulen gablà ku Dyisas, na yé gumdàan tmulen dun di ta bnasan gine. ");
INSERT INTO bpr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na di kafadlugla magu, ta kel ale di satu éél, na man i ganlal, “Neyem, nun sa éél dini. Nun kè gukulanggu i duen-gu là fakay fbunyag?” ");
INSERT INTO bpr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Na man Filip di kenen, “Ku mdà di nawam i kaftoom, fakayta ge bnunyag.” Na tmimel i ganlal, manan, “Hee, ftoo agu sa na Dyisas Krayst i Ngà Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na kafnge ayé, fafanak ganlal i kalisa, na lwe ale Filip tufa, na fles ale di éél du bnunyag Filip kenen. ");
INSERT INTO bpr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na kanto ale matun di tubéh, tadè nwè i Tulus Dwata Filip, na ta là teen i ganlal dun. Bay fles i ganlal di kagun, na too lehew. ");
INSERT INTO bpr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na galì lamyalo Filip, ta kel di Asutu, na mdà déé, nkatan i kdee dad banwe kel di Sisarya tamdò i Fye Tulen. ");
INSERT INTO bpr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bay di dad du ayé, fadlug Sol falmayam na falmikò i dad to ftoo di ku Dyisas. Na salu kenen di ulu i dad ganlal di kafaglut i dad Dyu, ");
INSERT INTO bpr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","du mni sulat fakayan fite ditù di dad gustifun i dad Dyu di Damaskus du fagu déé ku nun teenan dad to ftoo ku Dyisas, i baling lagi na libun, fakayan ale kanfè, na fablanggùan ale ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na ta mdà kenen salu ditù di syudad Damaskus. Na kanto mdadong di syudad ayé, tadè nun bong neng mdà di langit glibut di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na ti tadè bek Sol, na nun lingen talù, manan, “E Sol, Sol, kan dé ku falnayamam agu?” ");
INSERT INTO bpr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na smalek Sol, manan, “Simto ge kè, Amu?” Na tmimel i talù ayé, manan, “Do sa Dyisas, i galam falnayam. ");
INSERT INTO bpr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bay mték ge nan, na fles ge di syudad, na ku ta kel ge ditù, nun tmulen ge ku dét i fye nimòam.” ");
INSERT INTO bpr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na i dad lagi magin ku Sol, tgeneng ale du ta lingela gine i talù, bay landè to teenla. ");
INSERT INTO bpr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na ta mték Sol, bay kanto meye, ta là miten. Taman, ta nalak i dademen kenen fles di Damaskus. ");
INSERT INTO bpr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na tlu butangan là mite, na là ti kmaanan, na là minuman. ");
INSERT INTO bpr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na nun satu to ftoo di ku Dyisas déé di Damaskus, yé dagitan Ananayas. Na yé kanteenan ta tlo Dwata kenen, manan, “Ananayas.” Na tmimel kenen, manan, “Dét ayé, Amu?” ");
INSERT INTO bpr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na man i Amu di kenen, “Gatù ge di gumnè Dyudas déé di dalan dnagit Tluh Dalan, na fanngabalam i satu to mdà di Tarsu yé dagitan Sol. Yé nimòan di nawan ani, dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na ta nun kanteen Sol satu lagi, yé dagitan Ananayas salu déé di kenen, na fkah Ananayas i falelan di kenen fye lê mite.” ");
INSERT INTO bpr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Bay tmimel Ananayas, manan, “Amu, ta dee dad to gulmingegu gablà di lagi ayé, na i kdee dad sasè nimòan di dad tom ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na yé duenan salu dini di Damaskus du nun ktoon mdà di dad ganlal di kafaglut i dad Dyu di Dyérusalém kamfè i kdee dad to tamlo di dagitam.” ");
INSERT INTO bpr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bay tnimel i Amu Ananayas, manan, “Mdà ge salu ditù di lagi ayé, du ta nalékgu kenen fgadè i dagitgu di dad to ise Dyu, kel di dad ganlalla, na lê man i dad Dyu mdà di Israél. ");
INSERT INTO bpr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na fitegu di kenen i kalbong kdee dad kaflayam nagun du mdà di kafgadèan i dagitgu.” ");
INSERT INTO bpr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Taman, ta gatù Ananayas, na fusuk di gumnè gufanak Sol. Na fkahan i falelan di ku Sol, manan dun, “E flanekgu Sol, i Amuta Dyisas, dunan i ta fite di ge di dalanam salu dini, dekan agu samsite ge du fye lê ge man mite, na fnò ge i Mtiu Tulus.” ");
INSERT INTO bpr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na kanto man Ananayas ayé, tadè nun tatek mdà di mata Sol i salngad nél nalaf, na ta lê kenen mite. Na ta mték kenen, na fbunyag. ");
INSERT INTO bpr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na kafnge ayé, ta kmaan kenen, na ta lê kamgis. Na fanak Sol dad file butang di saféd i dad to ftoo ku Dyisas déé di Damaskus. ");
INSERT INTO bpr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na kafnge ayé, ta gatù Sol di dad gumnè gustifun i dad Dyu du tamdò. Yé tdòan na Dyisas Krayst Ngà i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na i kdee dad to lminge i manan, too ale tikeng, na smalek ale, manla, “Ise ani kè i to smamuk i dad to ftoo di ku Dyisas ditù di Dyérusalém? Na yé duenan salu dini kun du kanfèan i dad to ftoo di ku Dyisas, na neben ale di dad ganlal di kafaglut ditù di Dyérusalém.” ");
INSERT INTO bpr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bay baling matnù i kfulung Sol tamdò, na too mbagal i gutadagan tmulen na Dyisas Mgalék i Dwata, taman i dad Dyu déé di Damaskus, là gamtimel ale. ");
INSERT INTO bpr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na kafnge i dee du mlius, ta satul i dad Dyu du fnatila Sol, ");
INSERT INTO bpr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","bay ta gadèan i knayèla nimò ayé. Mdu na kifuh nun dad to mantay di gufusuk di syudad du fye gfatila Sol. ");
INSERT INTO bpr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bay di satu kifuh, i dad to gal magin ku Sol, fsudengla kenen di satu bong baskit, na fayolla kenen, yé gufagula dun di sol labat i syudad du fye galwà. ");
INSERT INTO bpr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na salu Sol ditù di Dyérusalém. Na kanto kel ditù, mayè kenen magin stifun di dad to ftoo di ku Dyisas, bay likò ale dun du yé man nawala ku sana là kaftoon ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bay nun satu to, yé dagitan Barnabas. Tnabengan Sol du neben di dad to dek Dyisas, na tulenan dale gablà di ta kite Sol i Amuto Dyisas ditù di dalan. Na lêan tulen dale gablà di klabè Sol tamdò di dagit Dyisas ditù di Damaskus. ");
INSERT INTO bpr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Taman, fanak Sol di safédla, na magin kenen di dale lamngab di Dyérusalém, du fakgis tamdò di dagit i Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na stulen kenen di dad Dyu talù Grik, na salyu ale man, bay baling ale mngabal kfagu fmati kenen. ");
INSERT INTO bpr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na kanto gadè i dad flanek Sol di kaftoo gablà ayé, nebela kenen ditù di Sisarya, na fulêla ditù di Tarsu. ");
INSERT INTO bpr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na i dad to ftoo di ku Dyisas di kabal i dad banwe Dyudiya, Galili, na Samarya, ta nun ktanak knèla. Na ta baling ale mbagal, na matnù i kdee dad to ftoo ku Dyisas fagu di tabeng i Mtiu Tulus. Na fadlug ale mnè di nun klikòla di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na Piter, dee dad banwe lanngaban. Di satu du, gatù kenen di banwe dnagit Lida du lnauyan i dad to Dwata ditù. ");
INSERT INTO bpr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na teenan ditù Aniyas, i satu lagi là galyakan i lawehan. Ta walu fali i klon sigi milè. ");
INSERT INTO bpr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na kanto kel Piter déé, manan di kenen, “Aniyas, ta fan-gulê Dyisas Krayst ge. Taman mték ge, na fantifasam i gumilèam.” Na tadè mték Aniyas. ");
INSERT INTO bpr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na i kdee dad to mnè déé di Lida na lê man di banwe dnagit Saron, teenla i to ta mgulê ayé, na ta ftoo ale di Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na ditù di banwe dnagit Dyopa, nun satu libun ftoo ku Dyisas, yé dagitan Tabita. Di Grik, yé dagitan Dorkas, yé gumtatekan uhe. Too ti fye i nimòan du galan tnabeng i dad to landè knun. ");
INSERT INTO bpr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na di slà ayé, nun tduk Dorkas, na fles mati. Danyohla i lawehan, na filèla di snifil di tah. ");
INSERT INTO bpr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na là mawag Dyopa mdà di Lida. Taman, kanto linge i dad to ftoo ku Dyisas di Dyopa na ta déé Piter di Lida, dekla lwe to salu di ku Piter du fakdo di kenen, manla dun, “Beg ge fabaltik salu ditù di gami.” ");
INSERT INTO bpr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na ta mdà Piter magin di dale. Na kanto kel déé, nebela kenen myak di snifil. Na nun dee dad libun balu tadag di safédan. Too ale mngel, na fitela ku Piter i dad klaweh ta fnge tanbél Dorkas di laman là fa mati. ");
INSERT INTO bpr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na dek Piter i kdee dad to lamwà di snifil. Na kafnge ayé, lkuad kenen dmasal. Na kanto smalu di mati, ta manan dun, “Tabita, mték ge.” Na ta meye i libun ayé, na di kiten ku Piter, ta mték, na fles sudeng. ");
INSERT INTO bpr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na nagot Piter i sigal Dorkas, na tnabengan kenen tadag. Na kafnge ayé, ta tlo Piter i dad to ftoo di ku Dyisas, gagin i dad balu gine, na fiten di dale ta mték Dorkas. ");
INSERT INTO bpr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I ta mkel ani, too mbel di kabal i banwe Dyopa, taman ta dee dad to ftoo di Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na beg mlo Piter fanak di Dyopa di saféd Simon, i satu lagi gal tambél kulit lmanaf. ");
INSERT INTO bpr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na nun satu lagi, yé dagitan Kornilyu, na ditù gumnèan di Sisarya. Kenen kapitan i dad sundalu di Roma glam di Lumbuk Itali. ");
INSERT INTO bpr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilyu na i familyan, toola nafè i Dwata, na nun klikòla dun. Na too bong tabengan di dad Dyu landè knun, na too kenen fduf dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na di satu du, kanto tngà masol i du, nun kanteenan satu kasaligan i Dwata fdadong di kenen, manan, “E Kornilyu.” ");
INSERT INTO bpr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na too neye Kornilyu i kasaligan ayé magin i klikòan, na snalekan kenen, manan, “Détan kè, Sér?” Na tmimel i kasaligan, manan, “Too lehew Dwata gablà di dad dasalam, na i dad blém di dad to landè knun, na yé duenam man, toon ge fandam. ");
INSERT INTO bpr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na ani, mdek ge dad lagi salu ditù di Dyopa du nngéla satu lagi dnagit Simon Piter. ");
INSERT INTO bpr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yé gufanakan di kilil mahin di lam gumnè Simon, dunan i to tambél kulit lmanaf.” ");
INSERT INTO bpr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na kanto mdà i kasaligan ayé, ta tlo Kornilyu i satu sundalun mafè i Dwata, na lê man lwe fasakan. ");
INSERT INTO bpr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na tulenan dale i kdee ta mkel, klon mdek dale salu ditù di Dyopa. ");
INSERT INTO bpr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Di tmadol du, kanto fan ltu du, ta mdadong ale di Dyopa. Na Piter, myak kenen di tah ataf i gumnè du dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na ta too kenen bitil, na mayè kmaan. Na di lamla mimò i knaan, nun kanteenan. ");
INSERT INTO bpr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yé teenan ta mgukà i langit, na nun gambet bong kayab nikat di sbalà syungan fayol kel di tanà. ");
INSERT INTO bpr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na nun dad sahal lmanaf, na dad kmamang, na dad anuk di bnas mnè di laman. ");
INSERT INTO bpr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na nun lingen talù di kenen, manan, “Piter, tadag ge. Tmatê ge, na knaanam.” ");
INSERT INTO bpr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bay tmimel Piter, manan, “E Amu, là fakayan. Là ti lmen-gu do kmaan i dad magsik gambet ayé, ku demen i là fakaymi dnawat.” ");
INSERT INTO bpr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na ta lêan linge i talù ayé, manan di kenen, “Nangam man ku magsik i ta lnaneb Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tlu dulêan mkel di ku Piter, na kafnge ayé, ta lê magket i kayab ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na di lam Piter famdam ku dét gumtatek i kanteenan, ta kel déé di Dyopa i dad lagi dek Kornilyu, na snalekla gusablà i gumnè Simon, klola fles di bà labat i gumnè gufanakan. ");
INSERT INTO bpr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na tamlo ale, na snalekla ku déé gufanak Simon Piter. ");
INSERT INTO bpr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na di lam Piter famdam i kanteenan, ta talù i Mtiu Tulus di kenen, manan, “Nun tlu lagi mngabal ge. ");
INSERT INTO bpr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Taman, tadag ge, na tufa. Na nangam falwe nawam magin dale du do mdek dale.” ");
INSERT INTO bpr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na ta tufa Piter, na manan dale, “Do sa i fanngabalyu. Dét i fandufyu dini?” ");
INSERT INTO bpr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na tmimel ale, manla, “Yé mdek gami Kapitan Kornilyu. Tluh to kenen, na toon nafè i Dwata, na lê nafè i dad Dyu kenen. Na yé man satu kasaligan i Dwata di kenen, fngén ge kun du fye falningen i manam di kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na kafnge ayé, ta nlak Piter ale myak di gumnè gufanakan, na déé gumilèla di kifuh. Na di tmadol du, mdà Piter magin dale, na nun magin dademe dad to ftoo mdà di Dyopa. ");
INSERT INTO bpr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na di galwen du, ta kel ale di Sisarya. Fatan Kornilyu ale, na ta falan santifun i dad flanekan na dademen sgalak. ");
INSERT INTO bpr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na kanto fusuk Piter di gumnè ayé, ta snitong Kornilyu kenen, na fles lkuad di saféd blì Piter du fnangamfùan. ");
INSERT INTO bpr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bay man Piter di kenen, “Nang ge mangamfù di do. Tadag ge, du salngad ate to.” ");
INSERT INTO bpr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na di lam ale Piter magu fusuk di gumnè, sigi kenen stulen ku Kornilyu, na ta teen Piter i dee dad to stifun déé. ");
INSERT INTO bpr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na man Piter di dale, “Ta tooyu gadè sa na là fakay ku gami dad Dyu sgalak ku demen lmauy di dad to ise Dyu du yé fnang di gami. Bay yé ta fite Dwata di do na là fakay ku yé fandamgu di dademe dad to na magsik ale ku demen là fakay dnawat. ");
INSERT INTO bpr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na yé duenam man, di kngéla do, là sa lwe nawagu salu dini na sgalak di gamu. Bay nun snalekgu di gamu. Dét i duenyu fngé do?” ");
INSERT INTO bpr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Na tmimel Kornilyu, manan, “Ta tlu butang mlius, di tngà masol i du gambet ani i oras, dmasal agu di lam gumnègu. Na tadè nun to tadag di munagu, too samfilà i klawehan, ");
INSERT INTO bpr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","yé manan, ‘Kornilyu, ta tnimel Dwata i dasalam, na là ti glifetan i dad tabengam di dad to landè knun. ");
INSERT INTO bpr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fngém satu to dnagit Simon Piter ditù di Dyopa. Yé gufanakan di kilil mahin di lam gumnè Simon, dunan i to tambél kulit lmanaf.’ ");
INSERT INTO bpr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na yé duenam man, gasilta ge fngé, na bong salamat du gadini ge. Na ani, ta stifun gami di kanfe i Dwata du falningemi i tnalù Dwata ftulenan ge.” ");
INSERT INTO bpr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na ta tambù Piter tamdò, manan, “Ani, ta toogu gadè na too ti glut na landè to nungul Dwata, ");
INSERT INTO bpr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","bay dnawatan i dad to mdà di kdee dad banwe, syan ku nafèla kenen, na mimò ale tluh. ");
INSERT INTO bpr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ani fgadè Dwata di dad to di Israél, dunan i katdò i Fye Tulen gablà di ktanak nawa fagu ku Dyisas Krayst, dunan i Amu i kdee. ");
INSERT INTO bpr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Na ta gadèyu sa i mgimò di kabal banwe Dyudiya tambù di Galili, di kafnge Dyan tamdò gablà di kbunyag. ");
INSERT INTO bpr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ta gadèyu gablà di ku Dyisas Krayst mdà di Nasarét, i gumlé Dwata gnagan na i Mtiu Tulus. Na ta lêyu gadè na lamngab kenen mimò fye, na fan-gulêan i kdee dad to snamuk i busaw du too samnagin Dwata di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ta teenmi i kdee dad nimòan di banwe i dad Dyu kel di Dyérusalém. Na yé nimòla, fnatila kenen fagu di kfatakla dun di krus, ");
INSERT INTO bpr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","bay di gatlun du, nték Dwata mdà di fati, na fiten di gami. ");
INSERT INTO bpr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Là ti kdee to mite kenen, bay lo gami i dad to ta nalék Dwata gufiten dun, dunan i kmaan na minum di safédan kafngen mték mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na dekan gami tamdò di dad to na tmulen na Dyisas Mgalék i Dwata mukum dad to mlawil fa, na i dad to ta mati. ");
INSERT INTO bpr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na i kdee tugad Dwata, yé sansmanla gablà di kenen na nè kun i to ftoo di kenen, fnasinsya Dwata i dad salàan fagu di dagitan.” ");
INSERT INTO bpr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na di lam Piter tamdò, i kdee dad to lminge i tdòan, tadè mnè i Mtiu Tulus di dale. ");
INSERT INTO bpr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I dad Dyu ftoo ku Dyisas magin ku Piter mdà di Dyopa, too ale tikeng du ta blé Dwata i Mtiu Tulusan di dad to ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Du ta lingela i ktalù i dad to ise Dyu di dad sahal talù, na i kdayenla i kaltulus Dwata. Na ta man Piter di dademen Dyu, ");
INSERT INTO bpr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Landè to gamfnang i dad to ani fbunyag di éél du ta gdawatla sa i Mtiu Tulus salngad di gito.” ");
INSERT INTO bpr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na yé duenam man, yé dek Piter, fbunyag ale fagu di dagit Dyisas Krayst. Na kafnge ayé, fakdo ale di ku Piter fye fanak kenen di safédla dad file butang. ");
INSERT INTO bpr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ta linge i dad to dek Dyisas na dademe dad to ftoo di kenen di kabal i probinsya Dyudiya ta nun dad to ise Dyu lê dmawat i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Yé duenam man, kanto samfulê Piter di Dyérusalém, i dad Dyu ta ftoo di ku Dyisas, toola kenen nadoy, ");
INSERT INTO bpr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","flesla man ku Piter, “Kan ku myak ge di gumnè i dad to ise Dyu? Kan ku kmaan ge di safédla?” ");
INSERT INTO bpr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Taman, too tulen Piter di dale i kdee ta mkel mdà di kagatbùan, manan, ");
INSERT INTO bpr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ditù agu di Dyopa, na di lamgu dmasal, nun kanteen-gu. Yé teen-gu nun gambet bong kayab nikat di sbalà syungan fayol mdà di langit, na fanak di sablàgu. ");
INSERT INTO bpr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na kantogu meye di laman, ta teen-gu i kdee dad sahal mnalam na labè lmanaf, na dad kmamang, na dad anuk di bnas. ");
INSERT INTO bpr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na kafnge ayé, nun lingegu talù, manan, ‘Piter, tadag ge. Tmatê ge, na knaanam.’ ");
INSERT INTO bpr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Bay tmimel agu, man-gu, ‘E Amu, là fakayan. Là ti lmen-gu do kmaan i dad magsik, ku demen i là fakaymi dnawat.’ ");
INSERT INTO bpr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na ta lêgu linge i talù ayé mdà di langit, manan do, ‘Nangam man ku magsik i ta lnaneb Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tlu dulêan mkel, na kafnge ayé, ta lê magket i kayab ditù di langit. ");
INSERT INTO bpr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na di oras ayé, nun tlu lagi kel di gumnè gufanakgu mdà di Sisarya dek Kornilyu mngé do. ");
INSERT INTO bpr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na yé man i Mtiu Tulus di do, ‘Nangam falwe nawam magin dale.’ Nam i dad to ftoo di ku Dyisas magin do, na yé gutadèmi di gumnè Kornilyu. ");
INSERT INTO bpr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na kafnge ayé, tulenan gami gablà di kanteenan di gumnèan, dunan i satu kasaligan, na ani man i kasaligan di kenen, ‘Mdek ge to gatù di Dyopa, na fngém Simon Piter. ");
INSERT INTO bpr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nun tulenan ge i gamfalwà ge, kel di familyam.’ ");
INSERT INTO bpr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Na di katbùgu tamdò, tadè mnè i Mtiu Tulus di dale salngad i knèan di gito di munan. ");
INSERT INTO bpr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na ta gafaldamgu i man Amuto Dyisas di munan, ‘Dyan i munyag di éél, bay gamu bnunyag di Mtiu Tulus.’ ");
INSERT INTO bpr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ku ta blé Dwata i Tulusan di dad to ise Dyu salngad i kablén dun di gito mdà di kaftooto di Amuto Dyisas Krayst, landè ktoogu msang i Dwata di nimòan ani.” ");
INSERT INTO bpr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na i dad Dyu ayé, kantola linge i man Piter, ta là madoy ale, bay balingla too dnayen i Dwata, manla, “Taman, ta banlé Dwata i dad to ise Dyu ayèla msal du fye gfunla falami nawa, na galwà ale.” ");
INSERT INTO bpr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Di kasbalét i dad to ftoo ku Dyisas du mdà di kaflayam ta tambù di du kfati Stifén, nun di dale gafat di Fonisya, Sipru, na Antyuk, na lo yé tdòla i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bay i dademe mdà di Sipru na Sirini, salu ale ditù di Antyuk, na tdòla i Fye Tulen gablà di Amuto Dyisas di dad to ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na déé i gnagan Amuto di dale, na too dee dad to ftoo di Amuto du ta matlas i fandamla. ");
INSERT INTO bpr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na i dad to ftoo di ku Dyisas di Dyérusalém, kantola linge i ta mkel ani, ta dekla Barnabas gatù di Antyuk. ");
INSERT INTO bpr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na kanto kel ditù, ta teenan i kafye Dwata di dad to, na too lehew kenen. Tan-galan i nawala du fye too ale fduf di klalòla ku Dyisas mdà di nawala. ");
INSERT INTO bpr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Na Barnabas, too kenen fye to, na fnò kenen i Mtiu Tulus, na too ftoo. Taman, dee dad to geben ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na kafnge ayé, ta mdà Barnabas salu ditù di Tarsu du fanngabalan Sol. ");
INSERT INTO bpr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na kanton teen Sol, ta faginan samfulê ditù di Antyuk. Na sfalila sagin déé di dad to ftoo ku Dyisas. Na too dee dad to tdòla. Na déé di Antyuk i tnanin gudmagitla i dad to ftoo di ku Dyisas Krayst, “I Dad To Ta Nfun Krayst.” ");
INSERT INTO bpr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na di bang ayé, nun dad tugad i Dwata salu di Antyuk mdà di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na satu di dale, yé dagitan Agabu. Tadag kenen, na fagu di gnagan i Mtiu Tulus, falan fgadè na nun kun fan kel bong kbitil di kdee dad banwe nagot i dad ganlal di Roma. (Na gdohò sa i manan ayé di kagot i satu ganlal, yé dagitan Klawdyu). ");
INSERT INTO bpr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na mdà di fgadè Agabu, yé gusamsatu nawa i dad to ftoo di ku Dyisas di Antyuk, ku nè sen gagan i kat satu, febela di dad flanekla ditù di Dyudiya. ");
INSERT INTO bpr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Taman, yé nimòla, na i tabeng bléla di dad to ditù di Dyudiya, febela di dale Barnabas na Sol, na ftadèla di dad ganlal i dad to ftoo ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na di bang ayé, tambù Harì Hérod falmayam i dademe dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Na faklangan ulu Dyém, i flanek Dyan. ");
INSERT INTO bpr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na kanto gadè Hérod ta lehew i dad Dyu di nimòan ayé, ta lêan fakfè Piter salngan di Fista i Fan Landè Bulung Falnok Dun. ");
INSERT INTO bpr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na kafngela kamfè kenen, ta fablanggùla, na sfalò nam i kdee sundalu mantay dun. Na sbaluh ale mantay, kat men fat. Na yé fandam Hérod di kafnge i Fista Du Kaglius, nukuman Piter di fati. ");
INSERT INTO bpr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na di kablanggùla ku Piter, yé nimò i dad to ftoo di ku Dyisas, toola kenen dnasal. ");
INSERT INTO bpr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na ta kifuh nan, na ta kudang Piter di bleng i lwe to mantay. Nikatla kenen lwe sangkalì, na nun fa dademe dad sundalu mantay di bà gufusuk di blanggù. Na yé mnè di fandam Hérod blén Piter di dad to ku ta flafus. ");
INSERT INTO bpr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na tadè msut di kenen kasaligan i Dwata, na ta mneng di lam i blanggù. Na ningok i kasaligan Piter du nukatan, na manan dun, “Sagwê ge mték.” Na tadè magbel i dad sangkalì di dad sigal Piter. ");
INSERT INTO bpr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na man i kasaligan di kenen, “Smaul ge, na lsakam talumfàam.” Na nimen Piter i manan. Na lê man i kasaligan, “Lêam lsak i saulam tahà sigal, na tnadolam agu.” ");
INSERT INTO bpr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na tmadol Piter di kasaligan lamwà di blanggù, bay là ti gadèan dun ku too glut i nimò i kasaligan di kenen, du yé man nawan ku lon kanteen. ");
INSERT INTO bpr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lniusla i tnanin mantay na di galwen, na fles ale di bong takab tek gulamwà salu di syudad. Na kanto ale kel di takab ayé, tadè mgukà, na ta lamwà ale. Na kanto ale kel di syat i dalan, tadè tnagak i kasaligan Piter. ");
INSERT INTO bpr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Na yé klo Piter gmadè dun na too glut kadì i ta mkel di kenen, manan, “Ani, ta toogu gadè dek Dwata i kasaliganan falwà do di ku Harì Hérod na kel di kdee kayè i dad Dyu nimò di do.” ");
INSERT INTO bpr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na kanto gafaldam Piter too glut i ta mkel di kenen, ta salu ditù di gumnè Méri, dunan i yê Dyan Mark. Na dee dad to stifun di gumnè ayé du dmasal ale. ");
INSERT INTO bpr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na di kakel Piter di gumnè ayé, tmutuk kenen di takab ditù di lwà. Na mdà satu ngà libun gal dek, yé dagitan Roda, falningen ku simto i tmutuk. ");
INSERT INTO bpr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na di kdilèan i talù Piter, too kenen lehew, na ta là gbal nawan mukà i takab, bay baling fabaltik samfulê di dad to di lam, na manan di dale, “Ta déé sa Piter di lwà.” ");
INSERT INTO bpr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Balingla man di kenen, “Bal bu snawang ge.” Bay toon uluk i manan, “Too glut i man-gu ani. Piter sa ayé.” Taman, stulen ale, manla, “Keng kasaligan mifat dun ayé.” ");
INSERT INTO bpr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na sigi tmutuk Piter di takab kel di kukàla dun. Na di kitela ku Piter, ta too ale tikeng. ");
INSERT INTO bpr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na ftadag Piter sigalan du fafanakan ale, na tulenan dale gablà di kafalwà i Amuto dun di blanggù. Na manan dale, “Begyu tugad do di ku Dyém, na di kdee dad flanekto.” Na kafnge ayé, ta mdà kenen fles di dademe banwe. ");
INSERT INTO bpr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na kanto flafus, too slaf nawa i dad sundalu mantay di blanggù, na sasalek ale, manla, “Dét i ta mkel di ku Piter?” ");
INSERT INTO bpr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na too fafngabal Harì Hérod Piter, bay du là teenla dun, taman, toon snalek i dad sundalu mantay, kafnge ayé, fafatin ale. Na ta mdà Harì Hérod di Dyudiya gatù di Sisarya, na fanak kenen déé là mlo. ");
INSERT INTO bpr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na di bang ayé, ta malbut Harì Hérod di dad to mdà di banwe Tiro na Sidon. Yé kayè nawala ku stulen ale di harì du déé gumwèla i knaan di banwen. Yé to nlakla samfye dale Blastu, i mdatah to di gumnè i harì. ");
INSERT INTO bpr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na kanto kel i du ta falala nalék, ta lsak Harì Hérod i tahà saulan too fye bawehan, na sudeng di trunun. Na talù kenen di kdee dad to stifun déé. ");
INSERT INTO bpr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na mkit i dad to, manla, “Ise ku lo btal to ani, bay kenen sa satu dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na tadè falnayam kasaligan i Dwata Harì Hérod du là dnayenan i Dwata. Na tin tadè snafat, na fles mati. ");
INSERT INTO bpr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na ta baling too midul kbel i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kanto fnge Barnabas na Sol i dad nimòla, ta mulê ale fdu di Dyérusalém, na faginla Dyan Mark. ");
INSERT INTO bpr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na déé di simbahan di Antyuk, nun dad tugad i Dwata na dad to tamdò i Tnalù Dwata. Ani i dad dagitla, Barnabas, na Simyon, (yé satu dagit dun Fitam To), na Lusyu (mdà di banwe Sirini), na Manaén (i deme Harì Hérod salnok), na Sol. ");
INSERT INTO bpr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na i dad to ayé, di lamla mangamfù di Dwata na fwasa, ta man i Mtiu Tulus di dale, “Fatfingyu do ale Barnabas na Sol du nun mabtas fimògu dale.” ");
INSERT INTO bpr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Na yé duenam man, kafngela dmasal na fwasa, ta fkahla dad falella di dale Barnabas na Sol, klola mdek dale. ");
INSERT INTO bpr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Di kdek i Mtiu Tulus dale Barnabas na Sol, salu ale di Silisya, klola fles maweng gatù di fungul Sipru. ");
INSERT INTO bpr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na kanto ale kel di satu banwe, yé dagitan Salamis, tdòla i Tnalù Dwata déé di dad gumnè gustifun i dad Dyu. Na magin Dyan Mark dale du tnabengan ale. ");
INSERT INTO bpr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Na ftila nagu kabal i fungul ayé kel di banwe Pafos. Na déé gugamsitongla satu Dyu, yé dagitan Bar-Dyisas. Lmoos kenen, na gal flingu tmugad i dad talù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yé demen sgalak Sirgyu Pawlu, i gubirnador di fungul ayé. Kenen i satu to too fulung. Fngé i gubirnador ale Barnabas na Sol du kayèan falninge i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bay i to lmoos ayé, (yé dagitan di Grik Ilimas), nsangan ale, du là mayèan ku ftoo i gubirnador. ");
INSERT INTO bpr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na Sol, (yé satu dagitan Pol), fnò kenen i Mtiu Tulus, toon neye Ilimas, ");
INSERT INTO bpr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na manan dun, “Ngà Satanas ge du knangam i kdee tluh. Too ge fulung famgaw i dad to, na slame sasè i kdee nimòam. Lo yé kayèam, fankéngam i kaglut Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na ani, falnayam Dwata ge. Butè ge, na mlo fa i kitem neng du.” Na di kman Sol ayé, ti tadè butè Ilimas, na fles migef mngabal to malak dun. ");
INSERT INTO bpr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Na kanto teen i gubirnador i mkel di ku Ilimas, ta ftoo kenen di ku Dyisas du too tikeng di katdò ale Sol gablà di Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na ta mdà ale Pol na i dademen fdu di Pafos, na maweng ale salu ditù di satu banwe dnagit Pirga, glam di Pamfilya. Bay ta tnagak Dyan Mark ale déé du samfulê ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na lê ale fles fdu di Pirga salu ditù di satu banwe dnagit Antyuk glam di Pisidya. Na kanto kel i Du Kaftud, ta fusuk ale di gumnè gustifun i dad Dyu, na sudeng ale. ");
INSERT INTO bpr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kafnge kbasa i uldin Dwata fagu di ku Mosis, na i dad sulat i dademe dad tugad Dwata di munan, nun dek i dad ganlal di gumnè gustifun ayé, ftalùla ale Pol na Barnabas, manla, “E dad flanek, ku nun tdòyu gamfinit nawa i dad to ani, fakay gamu talù.” ");
INSERT INTO bpr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ta tadag Pol, na ftadagan sigalan du fafanakan ale, manan, “E dad flanekgu mdà di Israél, na dad to ise Dyu gal mangamfù di Dwata, flinge gamu. ");
INSERT INTO bpr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Dwata dad to di Israél, kenen malék i dad gutambulto, na toon ale fdee na ftatelan di lamla mnè di Idyip. Na fagu di bong gnagan, neben ale lamwà di Idyip. ");
INSERT INTO bpr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na di lam i fat falò fali klon, fantahàan i nawan di dad sasè nimòla déé di banwe landè to mnè ditù. ");
INSERT INTO bpr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na fnisan Dwata i fitu lumbuk dad to di Kanaan, na blén di dad ton i tanàla. ");
INSERT INTO bpr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na yé ta klo Dwata tmabeng dale 450 fali. Na kafnge ayé, nun dad to nalék Dwata du fagotan dale i dad ton kel di bang i satu tugad Dwata, yé dagitan Samwél. ");
INSERT INTO bpr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Na kafnge ayé, yé fni i dad to di Dwata nun moon harìla, na yé dek Dwata Sol, i ngà satu to, yé dagitan Kis. Mdà kenen di lumbuk Bénhamin, na yé klo i kagotan kenen fat falò fali. ");
INSERT INTO bpr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Di kafnge Dwata falwà ku Sol di kagotan, ta yé nimòan harì Dabid. Na ani manan gablà ku Dabid, ‘Yé kitegu ku Dabid, i ngà Dyési, salngad nawan di do, na toon nimen i kdee kayègu fimò dun.’ ");
INSERT INTO bpr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na Dyisas, kenen satu bel Dabid. Nimò Dwata kenen Falwà di dad to Israél du yé ta fakangan. ");
INSERT INTO bpr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na balù di lam Dyisas là kel dini di tah tanà, ta tamdò Dyan di kdee dad to Israél du fye msal ale di salàla, na fbunyag ale. ");
INSERT INTO bpr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na kanto fan fnge Dyan i nimòan, ta manan di dad to, ‘Di fandamyu, simto agu kè? Ise ku do i sanfatanyu. Tmadol kenen di do, bay là gablà agu mlus i talumfàan du too agu mdanà di kenen.’ ");
INSERT INTO bpr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“E dad flanekgu, dad bel Abraham, na lê man i dad to ise Dyu i too mangamfù di Dwata, i tdò ani gablà di kagalwà, ta fgafatan di gito. ");
INSERT INTO bpr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Du i dad to mnè di Dyérusalém na kel di dad ganlalla, là gadèla na Dyisas i Falwà, na là glabatla sulat i dad tugad Dwata galla bnasa di kat Du Kaftud. Bay kantola falnayam Dyisas, yé gugdohò i man dad tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na balù landè teenla gufdàla falmayam ku Dyisas di fati, knèan baling ale fakdo ku Pilato na fafatin Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na kafngela mimò i kdee man di Tnalù Dwata gablà di kenen, ta nwèla i lawehan di krus, na lbangla di ilib. ");
INSERT INTO bpr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bay lê nték Dwata kenen di fati. ");
INSERT INTO bpr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Di lam i dee du, lêan fite i kton di dad to tagnè magin di kenen fdu di Galili salu di Dyérusalém. Na dale tmulen gablà di kenen di dad to Israél. ");
INSERT INTO bpr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na yé duenmi salu dini du nebemi di gamu i Fye Tulen, dunan i ta fakang Dwata di dad gutambulto. ");
INSERT INTO bpr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Na Dwata dmohò dun di gito dad bella fagu di ktékan ku Dyisas di fati, salngad i ta gsulat di galwe Salmo, manan, ‘Ge i Ngàgu, na do i Màam.’ ");
INSERT INTO bpr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na gablà di ktékan ku Dyisas di fati du fye là balok i lawehan, ani man i Dwata, ‘Blégu di ge i kafye too mtiu na gsalig salngad i ta fakanggu di ku Dabid.’ ");
INSERT INTO bpr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na lê nun sulat Dabid di Salmo, manan, ‘Là ti faloham ku balok laweh i Snaligam Too Tluh.’ ");
INSERT INTO bpr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Kanto fnge Dabid i kdee fimò Dwata dun di knèan dini di tah tanà, ta mati kenen, na lbangla di saféd i dad gutambulan, na balok i lawehan. ");
INSERT INTO bpr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bay Dyisas, i nték Dwata di fati, landè kbalok i kenen laweh. ");
INSERT INTO bpr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yé duenam man, dad flanekgu, fye ku tooyu gadè ani, na fagu di ku Dyisas ta gatdò di gamu i kfasinsya i dad salà. ");
INSERT INTO bpr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Na ise ku yé gugalwàyu fagu di kimenyu dad uldin Dwata blén ku Mosis, bay lo fagu di kaftooyu ku Dyisas Krayst, ta galwà gamu di kdee dad salàyu. ");
INSERT INTO bpr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Too gamu fgeye du fye là kel di gamu i ta fala sulat i dad tugad Dwata di munan, du ani manla, ");
INSERT INTO bpr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Fgeye gamu, dad to madoy i Dwata. Keng taknal gamu, na malmo gamu. Nun nimògu di blengyu i là fantooyu dun, balù ku nun to tmulen dun di gamu.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na kafnge ayé, di kalwà ale Pol na Barnabas fdu di gumnè gustifun i dad Dyu, ta nlak i dad to ale lê samfulê di tmadol Du Kaftud du fye tnugadla i tdòla ayé. ");
INSERT INTO bpr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kafnge i kastifun ayé, nun dad Dyu na lê dademe dad to ta mulê di Dyu lmalò di dale Pol na Barnabas. Na stulen ale di dad to ayé, na toola ale falnau du fye fadlug ale mnè di kafye Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na kanto lê kel i Du Kaftud, fan sdulê i kdee dad to di syudad stifun du falningela i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bay i dad Dyu là ftoo di ku Dyisas, kantola teen i kdee dad to stifun, ta too mafè nawala, fankéngla i tdò Pol, na nadoyla kenen. ");
INSERT INTO bpr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bay baling too midul kinit nawa ale Pol na Barnabas, na manla di dad Dyu, “Là fakay ku ise gamu i funami tdò i Tnalù Dwata. Bay ani, du knangyu, na là fandamyu i ktoyu gablà gamu gamdawat nawa landè sen, taman, yé balingmi gusalu di dad to ise Dyu du dale i tnulenmi. ");
INSERT INTO bpr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Du ani dek i Amu di gami, manan, ‘Nimòta ge salò di dad to ise Dyu, du fye fagu di ge gafat i kagalwà di dad to di klamang banwe.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na kanto lminge i dad to ise Dyu, too ale lehew. Na i kdee dad to ta mgalék Dwata banlé nawa landè sen, ta mbaling ale ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na too mbel i Tnalù Dwata di kabal i banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bay i dad Dyu là ftoo di ku Dyisas, banlétla i dad ganlal, na i dad libun ise Dyu gal mangamfù di Dwata. Na falnayamla ale Pol na Barnabas, na dalugla ale lamwà di banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na yé duenam man, kanto mdà ale Pol na Barnabas, kakesla i kfung di blìla du yé ilè dun di dad to ayé na dale tmimel i sasè nimòla di Dwata. Na ta fles ale Pol gatù di Ikonyum. ");
INSERT INTO bpr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na i dad to ftoo di ku Dyisas di Antyuk, too ale lehew, na fnò ale i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na kanto kel ale Pol na Barnabas di Ikonyum, salu ale di gumnè gustifun i dad Dyu salngad i galla nimò. Na too ti fye i katdòla, taman, ta dee dad to ftoo di ku Dyisas, i dad Dyu na lê man i dad to ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bay nun dademe dad Dyu là ftoo, na banlétla i dad to ise Dyu déé du fye sasè kitela i dad to ta ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na yé duenam man, mlo ale Pol na Barnabas déé, na landè ti klikòla tamdò gablà di Amuto. Na fite i Amuto na glut i tdòla fagu di kablén dale kgagan mimò dad tnikeng. ");
INSERT INTO bpr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bay dad to di syudad ayé, là masalngad ale. I dademe, nsenla i dad Dyu là ftoo ku Dyisas, na i dademe, yé dale nsen i dad to dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na yé gusasatu nawa i dademe dad Dyu na lê dad to ise Dyu, gagin i dad ganlalla, fansasèla ale Pol na Barnabas, na ndakla ale batu. ");
INSERT INTO bpr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bay kanto gadè ale Pol ani, ta milah ale ditù di dad syudad dnagit Listra na Dirbi glam di Likonya, na lê man di dademe dad banwe mdadong déé. ");
INSERT INTO bpr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na fles ale tamdò i Fye Tulen di dad banwe ayé. ");
INSERT INTO bpr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na ditù di Listra, nun satu lagi kimay i blìan mdà di ksutan, na là ti lmenan magu. ");
INSERT INTO bpr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Na di katdò Pol, toon kenen falninge. Na falnunu Pol kenen, na dilèan nun kaftoon. ");
INSERT INTO bpr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na tamlo Pol, manan, “Tadag ge.” Na di kman Pol ayé, ta tadag na magu i kimay ayé. ");
INSERT INTO bpr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Na i dad to stifun déé, kantola teen i nimò Pol, mkit ale di dale talù, na manla, “Ta tufa i dad dwata kafbaweh to tanà.” ");
INSERT INTO bpr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na yé katlola ku Barnabas Sus, na yé katlola ku Pol Hérmis du kenen i gal tamdò. ");
INSERT INTO bpr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na nun satu ganlal di kafaglutla ku Sus, i dwatala. Na nun gumnè gumangamfùla di ku Sus ditù di lwà i syudad. Na mebe i ganlal ayé dad safì lagi balniag bulek salu di bà gufusuk di syudad, du yé knayèan magin i dad to di kenen, na dsùla i dad safì ayé di dale Pol na Barnabas. ");
INSERT INTO bpr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na kanto gadè Barnabas na Pol ayé, ta knasêla i dad saulla mdà di klidù nawala, na gasilla snitong i dad to ayé, na mkit ale di blengla, manla, ");
INSERT INTO bpr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“E dad to di Listra, kan dé ku ani nimòyu? Slame ato dad to tanà. Gadini gami du tamdò gami i Fye Tulen du fye knagolyu i dad ise glut dwatayu, na blaling gamu di too glut Dwata, dunan i mimò i langit, i tanà, i mahin, na i kdee mnè di lamla. ");
INSERT INTO bpr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Di munan, falohan i kdee dad to lmalò di dale knayè. ");
INSERT INTO bpr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bay knèan, ta toon tulen gablà di kton fagu di dad fye nimòan du banlén gamu ulen mdà di langit, na ulê i dad feleyu di danganla gafat. Na lêan gamu banlé knaan, na flehewan gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na balù ku too tulen ale Pol ayé di dad to, knèan fanla ale là gagan fnang damsù di dale. ");
INSERT INTO bpr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na kafnge ayé, ta nun dad Dyu là ftoo kel déé fdu di Antyuk glam di Pisidya na lê man mdà di Ikonyum, na mgebela i dad to di Listra. Taman, ta ndakla Pol batu, na dyolla kenen lamwà di syudad du yé man nawala ku ta mati. ");
INSERT INTO bpr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bay, kanto stifun i dad to ftoo di ku Dyisas di safédan, ta mték kenen klon samfulê di syudad. Na di tmadol du, ta mdà ale Pol na Barnabas salu ditù di Dirbi. ");
INSERT INTO bpr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Na kanto ale kel di Dirbi, tdòla i Fye Tulen, na too dee dad to mgebela di kaftoo di ku Dyisas. Na kafnge ayé, ta lê ale samfulê di Listra, Ikonyum, na Antyuk glam di Pisidya, ");
INSERT INTO bpr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","du tan-galla nawa i dad to ftoo. Yé flaula dale fadlug ale di kaftoola di ku Dyisas, manla, “Di lam ato là fusuk di Kagot i Dwata, funato gnagu i dee dad kaflayam.” ");
INSERT INTO bpr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na malék ale Pol dad to nimòla ulu di kat simbahan déé. Na kafnge ayé, fwasa ale, na dmasal ale du bléla ale di Amu, i gusmaligla. ");
INSERT INTO bpr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Na gatù ale di Pamfilya, na yé dalanla kamlang di Pisidya. ");
INSERT INTO bpr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Na kafnge ayé, lê ale salu di Pirga du tdòla i Tnalù Dwata déé klola flasok di Atalya. ");
INSERT INTO bpr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na ta lê ale maweng fdu di Atalya mulê ditù di Antyuk, dunan i banwe gudmasal dad to dale di kabléla dale di ifat Dwata di munan di kdàla mimò i ta gafngela nimò. ");
INSERT INTO bpr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na kanto ale kel di Antyuk, ta santifunla i dad to ftoo di ku Dyisas, na tulenla i kdee dad nimò Dwata fagu di dale, na i kukà Dwata i dalanla salu di dad to ise Dyu du fye ftoo ale di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na too ale mlo mnè di saféd i dad to ftoo di ku Dyisas déé di Antyuk. ");
INSERT INTO bpr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Na nun dad to mdà di Dyudiya salu ditù di Antyuk, na yé tdòla di dad to ftoo di ku Dyisas déé, manla, “Ku là fimò gamu ilè di lawehyu lmalò di uldin Dwata fagu di ku Mosis, là ti galwà gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Taman, Pol na Barnabas, toola sanbalew i dad Dyu tamdò i tdò ani. Na i dad to ftoo di Antyuk, dekla ale Pol na Barnabas magin i dademe dad to ftoo di ku Dyisas gatù di Dyérusalém du fye stulen ale di dad to dek Dyisas na i dademe dad ulu ditù gablà di tdò ani. ");
INSERT INTO bpr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na ta fdàla ale Pol, na di kagula di Fonisya na Samarya, tulenla di dale i ta kaftoo dad to ise Dyu. Na di kaklinge dad to ftoo di ku Dyisas, too ale lehew. ");
INSERT INTO bpr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Na kanto kel ale Pol di Dyérusalém, mdà i dad to dek Dyisas, na i dad to ftoo, na i dad ulula, too fye kdawatla dale Pol. Na tulen ale Pol di dad to i kdee dad nimò Dwata fagu di dale. ");
INSERT INTO bpr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bay nun dademe di dad to ftoo di ku Dyisas glam di lumbuk i dad Farisi. Tadag ale, manla, “I dad to ise Dyu, là fakay ku là fimò ale ilè di lawehla, na ku là nimenla i dad uldin Dwata fagu di ku Mosis.” ");
INSERT INTO bpr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na ta stifun i dad to dek Dyisas na i dad ulu i dad to ftoo déé, na yé santulenla i klidù ayé. ");
INSERT INTO bpr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Na mlo ale stulen. Kafnge ayé, ta tadag Piter, manan dale, “E dad flanek, ta gadèyu sa di kdeeto gito dad Dyu, do i mgalék Dwata tamdò i Fye Tulen di dad to ise Dyu du fye lminge ale na ftoo. ");
INSERT INTO bpr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Dwata gmadè i mnè di nawa i dad to, na kenen fite i kdawatan i dad to ise Dyu fagu di kablén dale i Mtiu Tulus, salngad i kablén dun di gito dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","I Dwata, salngad kiten na kafdufan i dad Dyu na i dad ise Dyu, du balù i dad ise Dyu, ta lêan ale lnaneb sa du mdà di ta kaftoola ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Taman ani, kan ku nimòyu kalbut Dwata fagu di kaftiangyu i blat di dad to ftoo ku Dyisas i là gagan dad gutambulto tiang na balù gito, là gaganto dun. ");
INSERT INTO bpr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bay yé fantooto galwà ato fagu di Amuto Dyisas, na salngad ayé di dale.” ");
INSERT INTO bpr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Na i dad to stifun déé, ta fanak ale, na toola falninge i man ale Pol na Barnabas gablà di kdee dad tnikeng na dad ilè nimò Dwata di dad to ise Dyu fagu di dale. ");
INSERT INTO bpr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Na kanto fnge ale Pol na Barnabas talù, ta lê talù Dyém, manan, “E dad flanek, too gamu flinge. ");
INSERT INTO bpr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ta tulen Simon Piter di gito gablà di tnanin kfite Dwata i kakdon di dad to ise Dyu du nun dad to nalékan di blengla i knayèan nfun. ");
INSERT INTO bpr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na fagu déé, ta gdohò i sulat dad tugad Dwata, du ani manla, ");
INSERT INTO bpr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ani man i Dwata, “Kafnge ani, samfulê agu, na ftadaggu i gumnè Dabid ta bek. Ntékgu ani, na lêgu fanbagal, ");
INSERT INTO bpr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","du fye gsalu di Amu i kdee dademe to di tah tanà ani, dunan i dad ise Dyu ta nfun-gu. ");
INSERT INTO bpr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yé man Dwata, i ta fgadè ani mdà di munan.’ ”” ");
INSERT INTO bpr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Na fadlug Dyém talù, manan, “Di fandamgu, nangto banlat i dad to ise Dyu ta dmawat Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bay ani fye nimòto. Snulatto ale, na yé fnangto dale knaan i ta dsù di dad ise glut dwata du magsik, na i dad lmanaf na anuk fanlang, na i litè, na nang ale mimò sasè knayè i lawehla. ");
INSERT INTO bpr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Du mdà di kagatbùan, ta galto bnasa na tdòto i dad sulat Mosis di dad gumnè gustifun i dad Dyu di kdee dad banwe di kat Du Kaftud.” ");
INSERT INTO bpr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Na kafnge ayé, i dad to dek Dyisas, na i dademe dad ulu di simbahan déé, na kel di kdee dad to ftoo di ku Dyisas, malék ale mdà di dademela ftoo du fye dekla ale magin dale Pol na Barnabas gatù di Antyuk. Yé nalékla Dyudas, yé katlola dun Barsabas, na lê man Silas, i lwe to too mgafè i dad to ftoo. ");
INSERT INTO bpr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na nun febela dale sulat ditù di Antyuk, ani manan, “Gami dad to dek Dyisas, na lê man i dad ulu di simbahan dini di Dyérusalém, gami i dad flanekyu, i smulat di gamu dad to ise Dyu ftoo di ku Dyisas mnè di Antyuk, Sirya, na Silisya, na manmi kumusta di kdeeyu. ");
INSERT INTO bpr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ta nun tmulen di gami dini nun dad to mdà di gami balù là dekmi ale, bay tadè ale salu déé di gamu, na snamukla na flibugla i fandamyu fagu di tdòla. ");
INSERT INTO bpr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Taman, ta sansatumi i nawami, na ta malék gami dad to dekmi gadéé di gamu magin dale Pol na Barnabas, i dad flanekto too mabtas, ");
INSERT INTO bpr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","i ta mlé ktola du fye mimò ale ku Dyisas Krayst, i Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na yé duenam man, dekmi ale Dyudas na Silas du fye fbatengla di gamu i mnè di lam sulat ani. ");
INSERT INTO bpr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I Mtiu Tulus na gami, ta sasatu nawami na landè dademe blat ftiangmi gamu, lo senan ani. ");
INSERT INTO bpr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nang gamu kmaan i ta dsù di dad ise glut dwata, na nang gamu kmaan litè, na nang gamu kmaan lmanaf na anuk fanlang, na nang gamu mimò sasè knayè i lawehyu. Fye ku tooyu lalò ani. Ani gusen i manmi di gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na kafnge ayé, ta fdàla i dad to tmunda i sulat. Na kanto ale kel di Antyuk, ta santifunla i dad to ftoo di ku Dyisas, na bléla di dale i sulat. ");
INSERT INTO bpr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na di kbasa dad to i sulat ayé, too ale lehew du too gamfinit nawala i dad talù mnè di laman. ");
INSERT INTO bpr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Dyudas na Silas, lê tugad i Dwata ale, taman, dee i dad manla di dad to i gamfinit nawala na gamfbagal dale. ");
INSERT INTO bpr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Na fanak ale déé dad file butang, klo i dad to ftoo fdà dale, manla, “I kafye Dwata magin gamu.” Na ta mdà ale mulê di dad to mdek dale. ");
INSERT INTO bpr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bay ftagak Silas kenen. ");
INSERT INTO bpr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na beg mlo ale Pol na Barnabas fanak déé di Antyuk, na dee dad to magin dale tamdò i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Na kafnge dad file du, man Pol di ku Barnabas, “Mdà ate lmauy i dademeta ftoo di ku Dyisas di kdee dad banwe gufduta tamdò i Tnalù Dwata, na neyeta ku dét i ta kagkahla.” ");
INSERT INTO bpr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Na yé kayè Barnabas faginan Dyan Mark. ");
INSERT INTO bpr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bay Pol, là mayèan ku magin Dyan Mark du ta tnagakan ale di muna kagula ditù di Pamfilya, na là flesan magin dale di nimòla. ");
INSERT INTO bpr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Na ta baling sbalew ale Pol na Barnabas, taman, stagak ale. Na fagin Barnabas Dyan Mark, na maweng ale salu ditù di Sipru. ");
INSERT INTO bpr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bay yé fagin Pol kenen Silas, na dnasal i dad to ftoo, du bléla ale di ifat Dwata, na yé klola mdà. ");
INSERT INTO bpr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na yé dalan ale Pol magu di Sirya na Silisya du tan-galla i dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Na fles ale Pol di Dirbi, na fnge lê man di Listra. Na déé di Listra, nun satu to ftoo, yé dagitan Timoti. Na lê ftoo yêan, na Dyu kenen. Bay màan, Grik. ");
INSERT INTO bpr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","I kdee dad to ftoo di ku Dyisas di Listra na di Ikonyum, toola dag Timoti. ");
INSERT INTO bpr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Na yé kayè Pol faginan Timoti di kagula. Taman, nimòan ilè di laweh Timoti du gadè i kdee dad Dyu na Grik i màan. ");
INSERT INTO bpr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Di kagula di dad lunsud, tulenla di dad to ftoo i dad fnang ta gusasatu nawa i dad to dek Dyisas na lê dad ulu di simbahan di Dyérusalém, na falnaula ale du fye nimenla. ");
INSERT INTO bpr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Taman, ta midul kakgis i dad to ta tanfing Dwata, na di kat du, matnù i kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","I Mtiu Tulus, fnangan ale Pol tamdò di Asya. Na ta mdà ale magu di Frigya na Galasya. ");
INSERT INTO bpr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na di kakella di Misya, ta fan ale fles di Bitinya, bay i Mtiu Tulus Dyisas, fnangan ale. ");
INSERT INTO bpr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Taman, magu ale di Misya, na flasok ale salu di Troas. ");
INSERT INTO bpr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na kanto kifuh, nun kanteen Pol. Yé kanteenan, nun satu lagi mdà di probinsya Masidunya tadag, na fakdo di ku Pol, manan, “Salu ge dini di Masidunya, du tnabengam gami.” ");
INSERT INTO bpr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Na kafnge Pol mite i kanteenan ayé, ta ftifas gami du salu gami ditù di Masidunya du ta too mbateng kgadèmi dun na ta dek Dwata gami tamdò i Fye Tulen di dad to ditù. ");
INSERT INTO bpr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Na yé duenam man, ta mdà gami di Troas, na maweng gami gatù di Samutrés. Na di tmadol du, yé klomi fles ditù di Niyapulis. ");
INSERT INTO bpr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Na kafnge ayé, lê gami fles di Filipus, i too bong syudad di Masidunya. Nun dee dad to mdà di Roma mnè déé. Na fanak gami déé dad file butang. ");
INSERT INTO bpr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Di Du Kaftud, lamwà gami di syudad, na salu gami di kilil éél, du yé fandammi nun gustifun i dad Dyu ditù galla gudmasal. Na sudeng gami di saféd i dad libun ta stifun déé du stulen gami di dale. ");
INSERT INTO bpr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na satu di dale flinge di gami, yé dagitan Lidya mdà di Tiyatira, na gal fabli falnas malung fulè. Nafèan Dwata, na nukà Dwata i fandaman fye dnawatan i tdò Pol. ");
INSERT INTO bpr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Na ta fbunyag kenen magin i kdeela mnè di gumnèan. Na nlakan gami salu di gumnèan, manan, “Ku fantooyu na ta ftoo agu di Amu, fusuk gamu di gumnègu, na fanak gamu déé.” Na too minit i klakan, na là gnang gami. ");
INSERT INTO bpr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na di satu du, di dalanmi salu di galla gudmasal, nun libun fasak smitong gami. Lmoos kenen, taman nun gnaganan tmulen ku dét i fan mkel. Ta too ti bong filak gwè i dad amun mdà di gnaganan. ");
INSERT INTO bpr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na i libun ayé, tnadolan ale Pol, na mkit, manan, “I dad lagi ani, fasak ale i Too Mdatah Dwata, na yé tulenla gamu i dalan kagalwà.” ");
INSERT INTO bpr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na too dee dulêan mimò ani, na kanto tmakas Pol, ta blaling di kenen, manan di loosan, “Di dagit Dyisas Krayst, lamwà ge di kenen.” Na di kmanan ayé, ta tnagak loosan. ");
INSERT INTO bpr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na kanto gadè i dad amun na ta landè kibòla gamwè filak fagu di kenen, ta kanfèla ale Pol na Silas, na dyolla ale salu di gumukum i dad ganlal. ");
INSERT INTO bpr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na kanto ale kel di dad mdatah mukum mdà di Roma, ta man dad amu i libun ayé, “Dyu i dad lagi ani, na too ale smamuk di syudadto, ");
INSERT INTO bpr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","du i tdòla, là fakay di gito uldin. Taman, gito dad to mdà di Roma, là fakayto dnawat na nimen i dale tdò.” ");
INSERT INTO bpr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na i dad to stifun déé, ta lê ale magin falbut di dale Pol na Silas. Knasê na nlus i dad to mukum i klaweh ale Pol, na klola fafas dale. ");
INSERT INTO bpr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Na di kafngela mfas dale, ta fablanggùla ale, na yé flau i dad mukum di to mantay di blanggù toon fan-gat i blanggù na fansyen mantay dale. ");
INSERT INTO bpr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Taman, déé gumkahla dale di snifil blanggù di toon gumgat, na fnantungla i dad blìla. ");
INSERT INTO bpr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Keng ta tngà butang, dmasal ale Pol na Silas na lmingag dmayen di Dwata, na flinge i dademe dad to blanggù. ");
INSERT INTO bpr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Na tadè kel i bong linol, na msayug i blanggù, na ta mgukà i dad takab, na tadè mkah i dad sangkalì ikat i dad to blanggù. ");
INSERT INTO bpr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na ta mukat i to mantay, na kanton teen na ta mgukà i dad takab, yé man nawan ku ta milah i dad to blanggù, taman, ta nsòan i sundangan du fanan fnati i kton. ");
INSERT INTO bpr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bay faltê Pol, manan, “Nangam fnati i ktom. Sana kdinimi.” ");
INSERT INTO bpr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na kafnge ayé, ta fwè salò i to mantay, na fabaltik kenen fusuk. Lkuad kenen kankal di saféd ale Pol na Silas. ");
INSERT INTO bpr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na neben ale Pol na Silas lamwà, na snalekan ale, manan, “Sér, dét i fye nimògu du fye galwà agu di dad salàgu?” ");
INSERT INTO bpr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na tmimel ale Pol, manla, “Ftoo ge di ku Dyisas, i Amu, du fye galwà ge, na salngad ayé i familyam.” ");
INSERT INTO bpr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na kafnge ayé, ta tamdò ale Pol i Tnalù Dwata di lagi ayé kel di kdee dad to di lam gumnèan. ");
INSERT INTO bpr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na di lam kifuh ayé, ta nalob to mantay dad seey ale Pol na Silas, na gasil kenen fbunyag magin i familyan. ");
INSERT INTO bpr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na kafnge ayé, ta neben fusuk ale Pol di gumnèan, na fankaanan ale, na too ti lehew kenen na i familyan du ta ftoo kenen di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na kanto flafus, i dad to mukum, dekla i dademe dad mdatah pulis salu di to mantay di blanggù, manla dun, “Falwàam dad to blanggù ayé.” ");
INSERT INTO bpr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Na ta fgadè i to mantay di dale Pol na Silas, manan, “Yé man i dad to mukum, falwàta gamu kun. Taman, mdà gamu. I kafye Dwata magin gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bay man Pol di dad mdatah pulis, “Ta fafasla gami di kanfe i dad to balù ku landè salàmi. Na lêla gami fablanggù, na blaam gami dad to glam di Roma. Na yé kayèla ku bunila i kafalwàla gami. Là fakay ayé. Silang gami lamwà ku dale salu dini, na falwàla gami.” ");
INSERT INTO bpr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na ta tugad dad mdatah pulis i man Pol di dad to mukum. Na kanto gadè i dad to mukum na glam ale Pol na Silas di Roma, ta too ale likò. ");
INSERT INTO bpr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Na ta gatù i dad to mukum di blanggù du mni fasinsya di dale Pol, na nebela ale lamwà, na fakdo di dale, manla, “Beg gamu lamwà di syudad ani.” ");
INSERT INTO bpr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Na ta lamwà Pol na Silas di blanggù, na lê ale samfulê di gumnè Lidya, na lnabatla i dad to ftoo déé, na tan-galla i nawala. Na kafnge ayé, ta lê ale mdà. ");
INSERT INTO bpr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na yé dalan ale Pol na Silas magu di dad banwe dnagit Amfipolis na Apolonya, na ta kel ale di Tésalonika. Na nun gumnè gustifun i dad Dyu déé. ");
INSERT INTO bpr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Na gambet i gal nimò Pol, fusuk kenen di gumnè gustifunla, na di lam i tlu fadyan di kat Du Kaftud, too kenen stulen di dad to déé mdà di Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Na fbatengan di dale i Tnalù Dwata, na fiten i kaglutan na là fakay ku là maflayam Krayst, i Mgalék Dwata, na lê mték di fati. Na ani man Pol di dale, “Dyisas, i tdògu ani di gamu, kenen sa i Mgalék Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Na nun dademe dad Dyu déé, na dad Grik i mangamfù di Dwata, na lê dee dad libun mgafè, mgebe ale. ");
INSERT INTO bpr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bay mafè nawa i dad Dyu là ftoo di ku Dyisas, taman, ta santifunla i dad sasè to di fadyan, na dekla ale mimò samuk di syudad ayé. Na dnuludla i gumnè Dyason du fanngaballa ale Pol na Silas du nebela ale di dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bay du là teenla ale Pol, ta yé balingla kanfè ale Dyason na i dademe dad to ftoo, na dyolla ale salu di dad ganlal di syudad, na mkit ale, manla, “I dad to mebe samuk di dademe dad banwe, ta gafat ale di syudadto ani, ");
INSERT INTO bpr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na ta fyak Dyason ale di gumnèan du nifatan ale. I kdeela lmafà ku Sisar, i ulu di Roma, du yé manla nun kun mahal harì, yé dagitan Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Na kantola linge i kit i dad sasè to ayé, ta too msamuk i dad ganlal na lê man i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Na kafnge ayé, fananila ale Dyason filak du sòla i ktola, na yé klola galwà. ");
INSERT INTO bpr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Na di kifuh ayé, ta dek i dad to ftoo di ku Dyisas ale Pol na Silas salu di banwe, yé dagitan Birya. Na kanto ale kel ditù, fles ale di gumnè gustifun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na too mlahil santulen i dad to di Birya tah di dad to di Tésalonika, du too minit nawala flinge di tdò Pol, na kat du, toola bnasa Tnalù Dwata du fye gadèla ku glut i tdò Pol. ");
INSERT INTO bpr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Taman, ta dee dad Dyu, na dad lagi, na lê dad libun Grik too mgafè, ta ftoo ale ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bay kanto linge i dad Dyu là ftoo di Tésalonika ta lê tamdò Pol i Tnalù Dwata ditù di Birya, ta gatù ale, du banlétla i dad to mimò samuk. ");
INSERT INTO bpr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Taman, i dad to ftoo déé, gasilla fdà Pol salu di kilil mahin, bay ftagak ale Silas na Timoti déé di Birya. ");
INSERT INTO bpr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na i dad to tmunda ku Pol, naginla kenen kel di syudad Atén, na di kdàla mulê, yé kated Pol di dale gasil malò ale Silas na Timoti. ");
INSERT INTO bpr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na di lam Pol fatan dale Silas na Timoti déé di Atén, too mlidù i nawan du teenan too dee baweh i dad ise glut dwata i nimò dad to di syudad ayé. ");
INSERT INTO bpr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Taman, too kenen stulen di dad Dyu na di dad to ise Dyu gal mangamfù di Dwata déé di gumnè gustifun, na lê man di dad to gal magu di gumfayahan kat du. ");
INSERT INTO bpr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Na nun dademe dad to tamdò i fantoo dnagitla Ipikuriyan na Stowik, na sanbalewla Pol, bay ta fnisan Pol ale. Na nun di dale smalek, manla, “Dét man i to ani? Lo kenen sigi talù, bay landè sa gnadèan.” Na yé man dademe, “Yé tdòan i kfangamfù di mahal dwata.” Yé duenla man ayé du tamdò Pol i Fye Tulen gablà ku Dyisas na di ktékan di fati. ");
INSERT INTO bpr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Taman, nebela kenen di gustifun i dad to mukum dnagit Ariyapagu, na manla di kenen, “Nè kè gumdà i falami tdòam ani? ");
INSERT INTO bpr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Falami di gami i dad tdòam ani, taman kayèmi gadè ku dét i gumtatekan.” ");
INSERT INTO bpr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yé manla ku Pol du i dad to mdà di Atén na i dad to mdà di dademe banwe mnè déé, too ale bayan stulen na flinge di dad falami tdò i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na ta tadag Pol di muna i dad to mukum di gustifunla, na manan, “E dad to dini di Atén, ta toogu teen na nun kaftooyu. ");
INSERT INTO bpr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Balù di kagugu dini di syudadyu, ta teen-gu i dad gumangamfùyu di dad dwatayu. Na yé satu gumangamfù ta teen-gu, nun sa sulatan, manan, ‘Dini Gumangamfù Di Dwata Là Dilèmi Dun.’ I dwata fnangamfùyu balù là dilèyu dun, yé i fdilègu di gamu. ");
INSERT INTO bpr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dwata mimò i klamang banwe na i kdee mnè di laman, na kenen i Amu di langit na di tanà, na là ti fanakan di dad gumnè gumangamfù nimò dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na landè kibòto tmabeng dun du landè kalnidùan, du kenen mlé i lawil, i nawa, na i kdee kafye di dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Na mdà di satu to, nimò Dwata i kdee dad sahal to du fye mnè ale di klamang banwe ani. Na ta falan nalék i bangla sut na ku nè gufkahan dale. ");
INSERT INTO bpr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ani duen Dwata mimò ayé du fye fanngabal i dad to kenen kel di kitela dun. Bay di kaglutan, là ti mawag Dwata di gito. ");
INSERT INTO bpr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Du ‘Mdà di kenen mlawil ato, na lamyak ato, na mnè ato dini di tah tanà.’ Na gambet i man dademeyu gal flalok, ‘Gito dad ngà i Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Na yé duenam man, ku ta ngà ato i Dwata, nangto dè fandam ku yé kagkahan salngad i nimò dad to mdà di blawen, filak, na batu, du i nimòla ayé lo mdà di gnadè na kfulung i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Di munan, du là fa gadè dad to i kaglutan, taman, fantahà Dwata i nawan di nimòla. Bay ani, dekan i kdee dad to di klamang banwe msal na tmagak i dad sasè nimòla. ");
INSERT INTO bpr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ta fala nalék Dwata i du kukuman i dad to di klamang banwe. Too ti tluh i kukuman, na fagun di To ta mgalékan. Na ani ilè fiten di kdee, du ta ntékan i To ayé di fati.” ");
INSERT INTO bpr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na kantola linge i man Pol gablà di kték mdà di fati, nun dademe di dale madoy, bay yé man dademe, “Mayè gami lê flinge gablà di tdòam ani.” ");
INSERT INTO bpr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na kafnge ayé, ta mdà Pol. ");
INSERT INTO bpr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na nun dademe dad to déé ta magin di kenen du ta ftoo ale di ku Dyisas. Yé dagit i satu Dyunisyu, satu di dad mukum dnagit Ariyapagu, na lê nun satu libun, yé dagitan Damaris, na nun fa dademe. ");
INSERT INTO bpr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kafnge ayé, ta mdà Pol di Atén, na salu ditù di Korintu. ");
INSERT INTO bpr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na kanto kel ditù, teenan Akwila, i satu Dyu. Mdà kenen di Pontu, na falami kenen kel fdu di Itali, na magin Prisila, i yaanan. Yé duenla tmagak i banwela du Klawdyu, i too mdatah di Roma, ta dekan lamwà di Roma i dad Dyu. Na yé duenam man, lnauy Pol ale déé di Korintu, ");
INSERT INTO bpr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na fanak di safédla du magin dale di talbahòla, du yé talbahò Pol mimò dad turda, salngad di dale Akwila. ");
INSERT INTO bpr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Di kat Du Kaftud, salu Pol di gumnè gustifun i dad Dyu, du fbatengan di dad to i Tnalù Dwata du fye mgeben di kaftoo ku Dyisas i dad Dyu na dad Grik. ");
INSERT INTO bpr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Na kanto kel ale Silas na Timoti fdu di Masidunya, ta landè dademe nimò Pol, lo tamdò, na yé tulenan di dad Dyu na Dyisas i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bay, dnuen i dad Dyu Pol, na talù ale sasè gablà di kenen. Taman, kakesan i kfung di klawehan du gugmadèla dun na dale tmimel di Dwata i ksasè nimòla, na flesan man dale, “Gamu salà ku là galwà gamu. Landè labetgu. Mdà ani, ta yé gutamdògu di dad to ise Dyu.” ");
INSERT INTO bpr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Taman, ta tnagak Pol i dad to ayé, na salu kenen di gumnè Titus Dyustu, i satu to ise Dyu gal mangamfù di Dwata. I gumnèan mdadong di gumnè gustifun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na i ulu di gumnè gustifun i dad Dyu, yé dagitan Krispu. Ta ftoo kenen di ku Dyisas magin i kdee dad to di lam gumnèan. Na nun fa dademe dad to déé di Korintu, lê ale ftoo na fbunyag. ");
INSERT INTO bpr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Di satu kifuh, stulen Dwata di ku Pol fagu di kanteen, manan, “Nang ge likò, bay fles ge di katdòam. Na nang ge fanak balù dét i mkel di ge, ");
INSERT INTO bpr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","du dini agu di safédam, na landè falmayam ge du dee dad to ta falagu nalék di syudad ani.” ");
INSERT INTO bpr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Taman, yé klo Pol fanak déé sfali tngà, na tdòan ale i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na di bang ayé, yé gubirnador di probinsya Akaya Galyu. Na ta sansatu dad Dyu i nawala kamfè ku Pol, na nebela kenen di gumukum. ");
INSERT INTO bpr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na ani dalamla kenen, manla, “I to ani, nlakan i dad to mangamfù di Dwata, bay là glalòan i uldin Dwata di gito dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kanto ta fan talù Pol, man Galyu di dad Dyu, “Ku yé lnafàan uldin i gubirnu, fakayta gamu tnabeng. ");
INSERT INTO bpr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bay, yé sanbalewyu i dad talù, na dad dagit, na dad uldinyu, taman, gamu i sgadè. Là ti nukumgu gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na yé duenam man, ta falwàan ale di gumukum. ");
INSERT INTO bpr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na mdà di kalbutla, ta kanfèla Sostinis, i ulu di gumnè gustifun i dad Dyu, na fatdukla di lwà gumnè gumukum, bay tadè bayà Galyu ale. ");
INSERT INTO bpr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Na beg mlo Pol fanak di Korintu, klon tmagak i dad to ftoo di ku Dyisas déé, na maweng kenen salu ditù di Sirya magin di dale Prisila na Akwila. Na di lam Pol là mdà, fkihan i wakan di banwe Sinkriya du yé ilè na nun fakangan di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Na kanto ale kel di Ifisu, ta tnagak Pol ale Prisila na Akwila, na lê kenen fusuk di gumnè gustifun i dad Dyu du stulen di dale. ");
INSERT INTO bpr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na fakdo ale di kenen fye mlo fanak déé, bay là mayèan. ");
INSERT INTO bpr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bay di kdàan, makang kenen di dale, manan, “Ku mayè Dwata, lê agu samfulê dini.” Na kafnge ayé, ta mdà kenen di Ifisu smakay aweng. ");
INSERT INTO bpr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na kanto dmuung di Sisarya, ta gatù di Dyérusalém du lnauyan i dad to ftoo di ku Dyisas, klon fles di Antyuk. ");
INSERT INTO bpr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Na kafnge i file butangan déé, ta lê mdà, na nkatan nagu i dad banwe glam di Galasya na Frigya, du tan-galan nawa i kdee dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na di bang ayé, nun satu Dyu kel di Ifisu, yé dagitan Apulus. Yé gumdàan di banwe Alihandriya. Too kenen fulung talù, na dee gadèan gablà di Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ta nun tamdò dun gablà di Dalan i Amuto, na too minit nawan tamdò gablà ku Dyisas, na glut i tdòan. Bay lo satu gadèan bunyag, senan i kbunyag Dyan. ");
INSERT INTO bpr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Na too labè Apulus tamdò di gumnè gustifun i dad Dyu. Na kanto linge ale Prisila na Akwila i katdòan, ta nlakla kenen salu di gumnèla, na tanluhla i kaglabatan gablà di Dalan i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Na kanto mayè Apulus salu ditù di Akaya, i dad to ftoo di ku Dyisas di Ifisu, tnabengla kenen fagu di kfebela sulat di dad to ftoo di Akaya du fye dnawatla kenen. Na kanto kel ditù di Akaya, too bong tabengan di dad to ftoo di ku Dyisas mdà di kafye Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na gfisan Apulus i dad Dyu di kastulenla du too mbagal i gutadagan tmulen mdà di Tnalù Dwata na Dyisas i Mgalék Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na di lam Apulus fanak déé di Korintu, yé dalan Pol salu di Ifisu kamlang magu lagad. Na nun teenan dad to ftoo di ku Dyisas ditù. ");
INSERT INTO bpr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na snalekan ale, manan, “Di kaftooyu ku Dyisas, ta gdawatyu i Mtiu Tulus?” Na tmimel ale, manla, “Là, là sa gadèmi dun ku nun Mtiu Tulus.” ");
INSERT INTO bpr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Na smalek Pol, manan, “Dét i bunyag ta gufbunyagyu?” Na tmimel ale, manla, “I bunyag Dyan.” ");
INSERT INTO bpr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Na man Pol di dale, “I bunyag Dyan, ilè dun di dad to ta msal. Na yé manan dale là fakay ku là fantoola i To ta fan kel tmadol kenen, dunan Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Na kantola linge i man Pol, ta fbunyag ale di dagit i Amuto Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na di kafkah Pol i falelan di dale, ta fnò ale i Tulus, na ta talù ale dad sahal talù, na tulenla i Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nun dad sfalò lwe kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na tlu bulen Pol sigi fusuk di gumnè gustifun i dad Dyu. Na too kenen labè stulen di dad to gablà di Kagot i Dwata du yé kayè i nawan ku mgebe ale. ");
INSERT INTO bpr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bay nun dademe déé, too magéng ulula, na là mayè ale ftoo di ku Dyisas, bay baling ale talù sasè di kanfe i dad to gablà di Dalan i Amuto. Taman, ta tnagak Pol ale, na faginan i dad to ftoo di ku Dyisas, na fusuk ale di snifil gal gustifun ale Tiranu, na déé gustulenla di dad to kat du. ");
INSERT INTO bpr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lwe fali i klon mimò ayé, taman i kdee dad to di kabal Asya, sdulê ale lminge i Tnalù Dwata, dad Dyu na dad ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Na nimò Dwata dad malbang tnikeng fagu di ku Pol. ");
INSERT INTO bpr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Na balù ku lo masala na falnas labédan di awekan, i feben di dad to nun tduk, tadè ale mgulê, na lamwà dad busaw di dale. ");
INSERT INTO bpr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na nun dad Dyu gal magu du falwàla i dad busaw. Na tilewla falwà dad busaw fagu di kgamitla i dagit Dyisas, i Amuto, manla, “Di dagit Dyisas, i gal tdò Pol, lamwà gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yé mimò ayé dunan i fitu dad ngà Skiba lagi, i satu ganlal di kafaglut i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bay tmimel i busaw, manan dale, “Dilègu Dyisas, na dilègu Pol, bay simto gamu kè?” ");
INSERT INTO bpr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na kafnge ayé, i lagi nanè busaw, tadèan ale sanbunù, na fnisanan ale. Taman, ta milah ale lamwà di gumnè ayé, na ta gseey ale, na ta landè klawehla. ");
INSERT INTO bpr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Na i kdee dad Dyu na dad to ise Dyu mnè di Ifisu, kantola linge gablà di mkel ayé, ta too ale likò, na ta toola dnayen i dagit Dyisas, i Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na nun dee dad to ta ftoo ku Dyisas kel déé, na tulenla di kanfe dad to i dad sasè nimòla. ");
INSERT INTO bpr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na nun dee dad lmoos, mdà di kaftoola di ku Dyisas, ta santifunla dad libru galla gnamit du snakufla di kanfe i kdee dad to. Na kantola santifun i kdee dad libru ayé, yé btasan di dale filak dad lime falò libu. ");
INSERT INTO bpr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na yé gumdà i Tnalù Dwata too mbel, na matnù i kdee dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kafnge ayé, yé knayè nawa Pol magu di Masidunya na Akaya, klon fles di Dyérusalém. Manan, “Mdà di Dyérusalém, là fakay ku là salu agu di Roma.” ");
INSERT INTO bpr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Na nun lwe to gal tmabeng kenen, na dekan ale muna gatù di Masidunya. Yé dagit i dad to ayé dunan Timoti na Irastu. Bay Pol, funa kenen fanak di Asya là mlo. ");
INSERT INTO bpr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na di slà ayé, ta nun bong samuk di Ifisu du mdà di Dalan i Amuto. ");
INSERT INTO bpr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Na nun satu lagi, yé dagitan Dimitriyu, to fanday tmunal filak. Na mdà di filak tnunalan ayé, gal mimò malnak gumnè salngad di baweh i gumnè gumangamfù ku Dayana, i dwatala libun. Na too bong kagwè dad to talbahò di kenen du dee dad to gal mli di dale. ");
INSERT INTO bpr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Na santifun Dimitriyu i dad to talbahò di kenen, na lê man i dad to fanday salngad kenen, na manan dale, “Ta gadèyu sa gal bong kagwèto di nimòto ani. ");
INSERT INTO bpr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Na ta teenyu na lingeyu i nimò Pol du yé tdòan na i dad dwata nimò dad to ise ku too glut dwata kun. Na fan-gawan i dad to, na ta dee mgeben dini di Ifisu, na ta fan sdulê di kabal Asya. ");
INSERT INTO bpr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na yé kalnikòto, keng malmo i gumwèto klawil mdà di kafalmola dun. Na ise ku lo ayé, bay lê sasè kastulenla di gumnè gumangamfùto di tatel dwata libun, Dayana, ta landè gukmamu dun. Baling ale talù sasè na ta lanah i ktatel i gal fnangamfù i kdee dini di Asya na di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Na kantola linge i man Dimitriyu, too ale falbut di katdò Pol, na mkit ale, manla, “Too mdatah Dayana, i dwata fnangamfù i dad to di Ifisu.” ");
INSERT INTO bpr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ta too mbel i samuk di kabal i syudad, na kanfèla ale Gayus na Aristarku, lwe to mdà di Masidunya i magin ku Pol. Na gasilla ale nebe ditù di galla gustifun. ");
INSERT INTO bpr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na mayè Pol talù di dad to, bay fnang i dad to ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na lê nun dademe dad ganlal di Asya, dunan i dademe Pol sakdo, yé katedla ku Pol nang kenen salu di galla gustifun ayé. ");
INSERT INTO bpr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Na di slà ayé, too masabwel i dad to stifun déé. Mkit i kdeela, bay sahal i manla, du là gadèla i duenla stifun déé. ");
INSERT INTO bpr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yé man nawa i dademe ku Alihandru gumdà i samuk du kenen sa lugad i dad Dyu gsen muna i dad to. Na ftadagan sigalan du fafanakan ale, du fan kenen talù msen i kton. ");
INSERT INTO bpr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bay kantola gadè na Dyu kenen, ta salngan ale mkit kel di lwe oras klon, manla, “Too mdatah Dayana, i dwata fnangamfù i dad to di Ifisu.” ");
INSERT INTO bpr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Di gusenan, i to magot i syudad ayé, ta fafanakan i dad to, na manan dale, “E dad to dini di Ifisu, ta gadè i kdee dad to na gito sa dini di syudad Ifisu i mifat i gumnè gumangamfù di ku Dayana, i mdatah dwata, na lê man i batu mtiu ta mtatek mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yé duenam man, du landè kibò famkéng ani, yé fye, fanak gamu na nangyu fsukaf nawayu. ");
INSERT INTO bpr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","I dad to ta nebeyu dini, là sa tmaku ale di dad gumnè gumangamfùto, na là sa sasè talùla di dwatato. ");
INSERT INTO bpr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na kaflingenta dun, Dimitriyu na i dad talbahò di kenen, ku nun teenla sasè nimò di balù simto dun, nun sa gumukum na dad ganlalto i fakayla gutmulen dun. ");
INSERT INTO bpr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bay ku nun kayèyu fukum, silangto santulen ku ta kel i du gal sukum. ");
INSERT INTO bpr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Keng baling gito gudmuenla i samuk ta mkel ani, na landè fye timelto dale.” ");
INSERT INTO bpr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Na kafnge i ganlal man ayé, ta dekan mulê i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Na kanto fnge i samuk ayé, ta santifun Pol i dad to ftoo di ku Dyisas di Ifisu du tan-galan i nawala. Na kafnge ayé, mbal kenen di dale du fles ditù di Masidunya. ");
INSERT INTO bpr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Lanngaban nagu i dad banwe ditù du tan-galan nawa i dad to ftoo, na kafnge ayé, ta lê fles di Grisya, ");
INSERT INTO bpr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na tlu bulen i klon fanak déé. Fatlagad kenen salu ditù di Sirya, bay kanton gadè fnaleh dad Dyu fnati kenen, ta yé balingan dalan magu di Masidunya. ");
INSERT INTO bpr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ani dagit i dad to magin di kenen di kagun, Sopatar, i ngà Piru mdà di Birya, na Aristarku na Sigundu, dunan i dad to mdà di Tésalonika, na Gayus mdà di Dirbi, na Timoti, na lê man Tikiku na Trofimu, dunan i dad to mdà di Asya. ");
INSERT INTO bpr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Muna ale du fatanla gami di Troas. ");
INSERT INTO bpr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na kafnge Fista i Fan Landè Bulung Falnok Dun, ta maweng gami mdà di Filipus, na kafnge lime butang gumahmi ale di Troas, na fitu butangmi fanak déé. ");
INSERT INTO bpr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na di kifuh Sabadu, stifun gami kmaan fan gumdàmi famdam ku Dyisas, na tamdò Pol kel di tngà butang du di kaflafusan mdà kenen. ");
INSERT INTO bpr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na nun dee salò di snifil gustifunmi di tah. ");
INSERT INTO bpr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nun satu lamnok lagi sudeng di bintanà, yé dagitan Yutiku. Di lam Pol tamdò, ta gkudang Yutiku, na fuléh mdà di gatlu kansad saal. Galìla gtabeng, ta mati. ");
INSERT INTO bpr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Na ta tufa Pol, lanfanan na lkafan Yutiku, na manan, “Nang gamu mlidù du ta lê mlawil kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Na ta lê myak Pol, na falnakan i fan, na ta kmaan gami. Na stulen kenen di dale kel di flafus, na yé klon mdà. ");
INSERT INTO bpr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Na nebela mulê Yutiku, na too ale lehew. ");
INSERT INTO bpr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na ta muna gami mdà maweng salu di Asu du fye slobmi Pol, du yé manan tmanà kenen. ");
INSERT INTO bpr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Na kantomi gsitong kenen di Asu, ta flesmi fsakay kenen di aweng, na fles gami di banwe Mitilini. ");
INSERT INTO bpr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ta lê gami mdà maweng, na di tmadol du, kel gami di sablà i fungul dnagit Kyus. Na di kfayahan, salu gami di fungul dnagit Samu. Na di tmadol du, ta lê gami fles di Militu. ");
INSERT INTO bpr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Na yé knayè nawa Pol, là sloban di Ifisu tà ganggà di Asya du sagwê kenen fles ditù di Dyérusalém du kayèan kel ditù di laman là fa kel i Du Péntikus. ");
INSERT INTO bpr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Di lam Pol déé di Militu, ta fngén i dad ganlal di simbahan di Ifisu du fye snitongla kenen. ");
INSERT INTO bpr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Na kanto kel dad ganlal déé, man Pol di dale, “Ta gadèyu sa i ldamgu mdà di du kakelgu di Asya mnè di safédyu. ");
INSERT INTO bpr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Di kimògu i nimò Dwata, toogu fdanà i ktogu, na maloh i lwakgu, na too agu maflayam mdà di dad sasè nimò i dad Dyu di do. ");
INSERT INTO bpr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Na ta gadèyu sa ta mtigu tdò di gamu i kdee gamtabeng gamu di bleng i dad to di dad gustifunyu na lê man di dad gumnèyu. ");
INSERT INTO bpr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yé ta fnigu di dad Dyu na di dad to ise Dyu fye msal ale di salàla na salu ale di Dwata, na ftoo ale di Amuto Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Na ani, salu agu ditù di Dyérusalém du dek i Mtiu Tulus agu, na là gadègu ku dét i mkel di do ditù. ");
INSERT INTO bpr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bay lo yé gadègu i fgadè i Mtiu Tulus di do na di kat banwe gusalugu, yé fatan do i blanggù na i samuk. ");
INSERT INTO bpr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bay knèan, fandamgu landè btas i knègu dini di tah tanà. Lo yé mabtas ku gafngegu i nimò blé i Amuto Dyisas do, dunan i ktulen-gu i Fye Tulen gablà di kafye Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ta lnauygu i kdeeyu, na tdògu gablà di Kagot i Dwata. Na ta gadègu mdà ani ta là dè ato site samfulê. ");
INSERT INTO bpr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Na yé duenam man, ani man-gu di gamu di mdu ani, na ku nun to là galwàan, nangan agu nsal, ");
INSERT INTO bpr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","du ta sdulêgu tulen di gamu i kdee knayè Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bay neyeyu i ktoyu, na lêyu neye i kdee dad to ta salig i Mtiu Tulus di gamu. Tooyu nifat i dad to ta tanfing Dwata du ta bnayadan ale fagu di litè i Ngàan. ");
INSERT INTO bpr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na gadègu ku ta mdà agu, nun salu di gamu salngad i dad tuyun too labè, na landè lniusla di dad to ta ftoo. ");
INSERT INTO bpr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na lê nun dad to mdà di gamu tamdò kéng nebela samyat i dad to ftoo. ");
INSERT INTO bpr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Na yé duenam man, too gamu fgeye. Na nangyu glifet ta tlu fali klogu sigi tamdò gamu kifuh na mdu, na là ti tlag agu falmau gamu, na nun lwakgu maloh. ");
INSERT INTO bpr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Na ani, bléta gamu di ifat Dwata na di kafyen i ta tdògu di gamu du Dwata i fambagal gamu, na mlé gamu i kafye tagàan di kdee dad to ta tanfingan. ");
INSERT INTO bpr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Na là ti lmen-gu mibal filak, blawen, na i klaweh di balù simto dun di gamu. ");
INSERT INTO bpr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bay gadèyu na yé duen-gu fakgis talbahò du fye gwègu i dad kalnidùgu, na lêgu gtabeng i dademegu fagu di kablégu dale dad kalnidùla. ");
INSERT INTO bpr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na di kdee dad nimògu, ta gfitegu di gamu na yé fye too ato falgad talbahò du fye gtabengto i dad to mnè di klimah. Na fandamto i man Amuto Dyisas, ‘Mas fye fa i mlé tah i dmawat.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Na kafngen man ayé, ta lkuad i kdeela du dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Na lkafla kenen, na nalakla, na sdulê ale mngel. ");
INSERT INTO bpr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Yé duenla too mlidù du mdà di ta kmanan dale na ta là lê ale site. Na ta tundala kenen di aweng. ");
INSERT INTO bpr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Na kafngemi mbal di dale, ta mdà gami maweng gatù di banwe dnagit Kos. Na di tmadol du, ta lê gami fles salu di banwe Rodas, na fnge lê gami salu ditù di banwe Patara. ");
INSERT INTO bpr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Na nun teenmi aweng salu di banwe Fonisya, na taman, ta smakay gami. ");
INSERT INTO bpr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Na kantomi gadweng Sipru, ta niwasmi gsen di bibeng, du fles gami gatù di Sirya. Na dmuung i aweng di Tiro, na tufa gami du ftufala déé i dademe lulen. ");
INSERT INTO bpr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Fanngabalmi dad to ftoo di ku Dyisas déé, na kantomi ale teen, ta fanak gami di safédla kel di fitu butang. Na mdà di alak i Mtiu Tulus, nubugla Pol fye là flesan ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kanto ftoh i fitu butangmi mnè déé, ta lê gami fles di kagumi. Na di kdàmi, i kdee dad lagi na libun na dad ngàla, sdulê ale matad gami kel di lwà i syudad. Na kanto gami kel di kilil mahin, ta lkuad i kdeemi du dmasal. ");
INSERT INTO bpr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Na kafngemi mbal di dale, ta myak gami di aweng, na ta lê ale dale mulê. ");
INSERT INTO bpr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Na fles gami mdà di Tiro salu ditù di banwe Tolimiyas, na kantomi kel ditù, lnauymi i dad to ftoo di ku Dyisas, na sdumi fanak déé di safédla. ");
INSERT INTO bpr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Na di tmadol du, ta fles gami kel di Sisarya, na fanak gami di gumnè Filip, i satu to gal tamdò i Fye Tulen glam di dad fitu to ta mgalékla di Dyérusalém tmabeng di dad to dek Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","I to ayé, fat ngàan sawang libun gal tmulen Tnalù Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Na di lammi fanak déé dad file butang, ta nun to kel fdu di Dyudiya, yé dagitan Agabu. Kenen satu tugad i Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Fdadong kenen di gami, na nwèan i galing Pol. Kafnge ayé, bakusan di kenen sigal na di blìan, na manan, “Ani man i Mtiu Tulus, ‘Galò ani kbakus i dad Dyu di Dyérusalém i to mfun galing ani, na fnge bléla kenen di kagot i dad to ise Dyu.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Na kantomi linge i man Agabu, gami na i dad to déé, nubugmi Pol fye là flesan ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bay tmimel Pol, manan, “Kan dé ku mngel gamu, na flidùyu i nawagu? Ta gatlagad agu sa, ise ku lo bnakus, bay lê fafati di Dyérusalém du mdà di Amuto Dyisas.” ");
INSERT INTO bpr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Na du là gaganmi tamlas i fandaman, ta bayàmi kenen, na manmi, “Yé mgimò i knayè Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Na kafnge i file du mlius, ftifas gami na ta mdà gami gatù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Na nun dad to ftoo di ku Dyisas mdà di Sisarya magin di gami, na tundala gami di gumnè Mnason, i gufanakmi. Yé gumdàan di Sipru, na kenen satu di dad to muna ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Na kanto gami kel di Dyérusalém, i dad to ftoo di ku Dyisas déé, too ale lehew dmawat gami. ");
INSERT INTO bpr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na di tmadol du, magin Pol di gami du kayèan sansite Dyém. Na lê salu déé i dad ganlal di simbahan. ");
INSERT INTO bpr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Na kafnge Pol mlé kumusta di kdeela, ta tulenan i kdee dad nimò Dwata di dad to ise Dyu fagu di katdòan. ");
INSERT INTO bpr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Na kantola linge i man Pol, dnayenla i Dwata. Na manla di ku Pol, “E flanekmi, gadèam sa ta file libu i dad Dyu ftoo di ku Dyisas, bay sana kinit nawala mimen i dad uldin Dwata fagu di ku Mosis. ");
INSERT INTO bpr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Na ta nun tmulen dale, na yé galam tdò kun di kdee dad Dyu mnè di dad banwe i dad to ise Dyu tnagakla i dad uldin Mosis, na nangla fimò ilè di laweh i dad ngàla lagi, na nangla lalò i dad adat i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Di là mlo ani, gadèla na ta dini ge. Dét i fye nimòto? ");
INSERT INTO bpr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bay, ani fye nimòam. Nun fat lagi dini nun fakangla di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Magin ge di dale, na flam ge di kaflanebla i ktola di kanfe i Dwata. Na di kaginam dale, ge mayad dad kalnidùla du fye gafkihla i wakla. Na fagu di nimòam ani, fitem i kimenam di uldin Dwata fagu di ku Mosis du fye gadè i kdee dad to na kéng i ta lingela gablà di ge. ");
INSERT INTO bpr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Na gablà di dad to ise Dyu ta ftoo di ku Dyisas, ta snulatmi ale du tulenmi dale i mnè di fandammi. Yé fnangmi dale knaan i ta dsù di dad ise glut dwata, na i litè, na i dad lmanaf na anuk fanlang, na nang ale mimò sasè knayè i lawehla.” ");
INSERT INTO bpr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Na di tmadol du, ta mdà Pol magin di dad fat lagi ayé, na flam kenen flaneb di kanfe i Dwata. Na kafnge ayé, ta fles Pol salu di Bong Gumnè Gumangamfù di Dwata du fgadèan déé ku kilen kafnge i kaflanebla, du yé klon mlé dad dsù di Dwata tabengan di kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Na kanto fan mlius i fitu du ayé, nun dad Dyu mdà di Asya, teenla Pol di lam i Bong Gumnè Gumangamfù di Dwata. Na banlétla i dad to déé fye mimò ale samuk, na kanfèla Pol. ");
INSERT INTO bpr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na mkit ale, manla, “E dad to Israél, tnabengyu gami. Dunan ani i to gal lamngab di kdee dad banwe du tamdò sasè di kdee dad to gablà di gito dad Dyu, na i uldin blé Dwata fagu ku Mosis, na i Gumnè Gumangamfùto di Dwata. Na ani, ta lê kenen mebe dad to ise Dyu fusuk dini, na fagu déé, ta fagsikan i Gumnè Gumangamfùto di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Yé duenla man ayé du ta teenla Trofimu, satu to mdà di Ifisu magin ku Pol magu di Dyérusalém. Na yé man nawala ku ta nebe Pol kenen fusuk di Gumnè Gumangamfù di Dwata). ");
INSERT INTO bpr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Na ta too mbel i samuk di kabal i syudad, na sadluh i kdee dad to salu di ku Pol, na kanfèla na dyolla lamwà di Gumnè Gumangamfù di Dwata klola tmakab i gumnè ayé. ");
INSERT INTO bpr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Na di ta fanla kfati ku Pol, ta nun tmulen di kernél i dad sundalu di Roma, ta msamuk i kabal Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Na fabaltik kenen mwè dad sundalu na dad ganlalla, na neben ale di gustifun i dad to. Na kanto teen i dad to fan fmati ku Pol i dad sundalu ayé, ta fanak ale maug ku Pol. ");
INSERT INTO bpr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Na fdadong kernél ayé di ku Pol, na kanfèan klon fbakus dun lwe sangkalì. Na kafnge ayé, ta snalekan i dad to, manan, “Simto i to ani, na dét kè i ta nimòan?” ");
INSERT INTO bpr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Na sahal timel dad to di kakitla. Na mdà di kdee ugakla, là gadè i kernél ku dét i ta mkel, taman dekan i dad sundalun mebe ku Pol di barak. ");
INSERT INTO bpr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Na kanto kel ale Pol di aut, ta mfeges i dad sundalu mket kenen du mdà di too sasè ksamuk i dad to. ");
INSERT INTO bpr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Na too mkit i dad to tmadol dale, manla, “Fnatiyu kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kantola fan fafusuk Pol di lam i barak, ta manan di ulu i dad sundalu, “Fakay beg nun man-gu di ge?” Na tmimel i kernél ayé, manan, “Fulung ge talù Grik? ");
INSERT INTO bpr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Na ku ayé, ise ge kadì i to mdà di Idyip mimò samuk falami ani i mebe fat libu dad sasè to nun tek salu di banwe landè to mnè ditù!” ");
INSERT INTO bpr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Na tmimel Pol, manan, “Dyu agu, na yé gusutgu di Tarsu, i satu bong syudad di Silisya. Ku mfakay, begam agu faloh talù di dad to.” ");
INSERT INTO bpr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Na faloh i kernél kenen talù, na ta tadag Pol déé di aut, na ftadagan i sigalan du fafanakan i dad to. Na kanto ale fanak, ta talù kenen Hibru di dale. ");
INSERT INTO bpr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ani man Pol, “E dad flanek na dad tua, tooyu falninge i talùgu msen i ktogu.” ");
INSERT INTO bpr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Na kantola linge i ktalùan Hibru, ta too ale fanak. Na fadlug Pol talù, manan, ");
INSERT INTO bpr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Dyu agu do sa, na ditù gusutgu di Tarsu glam di Silisya, bay dini gulamnokgu di Dyérusalém. Do satu tdò Gamalyél, na too fye katdòan do i dad uldin Dwata di dad gutambulto, na too minit nawagu mimen di Dwata salngad gamu di mdu ani. ");
INSERT INTO bpr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na yé nimògu di munan, falnayamgu i dad to lmalò di Dalan i Amu kel di kfatila du kanfègu dad lagi na dad libun, na fablanggùgu ale. ");
INSERT INTO bpr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","I ulu di kafaglut i dad Dyu na i kdee dad mdatah ganlal, fakayla tulen na glut i man-gu ani. Na ta bléla di do dad sulatla di dad flanekla Dyu di Damaskus mlé do ktoo kamfè i dad to ftoo, na mebe dale dini di Dyérusalém fye falnayam ale. ");
INSERT INTO bpr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Kantogu mdadong di Damaskus, tadè nun bong neng glibut do mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Na tadè agu bek di tanà, na nun lingegu talù, manan do, ‘E Sol! E Sol, kan dé ku falnayamam agu?’ ");
INSERT INTO bpr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na smalek agu, man-gu, ‘E Amu, simto ge kè?’ Na tnimelan agu, manan, ‘Do sa Dyisas mdà di Nasarét, i galam falnayam.’ ");
INSERT INTO bpr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Na i dademegu magu, teenla i bong neng ayé, bay là lingela i kastulenan di do. ");
INSERT INTO bpr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na smalek agu, man-gu dun, ‘Dét nimògu, Amu?’ Na tmimel kenen, manan, ‘Mték ge, na fles ge ditù di Damaskus. Na di kakelam ditù, nun tmulen kdee fimò Dwata ge.’ ");
INSERT INTO bpr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Na ta butè agu mdà di gban i neng ayé, taman i dademegu, nalakla agu fles di Damaskus. ");
INSERT INTO bpr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Na nun satu lagi ditù, yé dagitan Ananayas, toon nimen i dad uldin Dwata, na i kdee dad Dyu mnè di Damaskus, toola kenen nafè. ");
INSERT INTO bpr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Salu kenen di do, na tadag di safédgu, manan, ‘E flanekgu Sol, lê ge man mite.’ Na di kmanan ayé, ta lê agu mite, na teen-gu kenen. ");
INSERT INTO bpr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Na lêan man di do, ‘I Dwata fnangamfù i dad gutambulto, ta nalékan ge du fye toom gadè i knayèan, na teenam i Snaligan Too Tluh, na lêam linge talù lamwà di bàan. ");
INSERT INTO bpr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Na ge mgimò snaligan tmulen di kdee dad to i kdee ta teenam na lingem. ");
INSERT INTO bpr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na ani, nang ge fganggà. Mték ge, na fbunyag ge, na fagu di katlom i dagitan, falobam i dad salàam.’ ");
INSERT INTO bpr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Na kafngen man ayé, ta mdà agu mulê dini di Dyérusalém, na dmasal agu di Gumnè Gumangamfù di Dwata. Na di lamgu dmasal, nun kanteen-gu. ");
INSERT INTO bpr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Yé kanteen-gu, stulen Dyisas di do, manan, ‘Fabaltik ge mdà. Tnagakam i syudad Dyérusalém ani, du là sa dnawatla i ktulenam gablà di do di dale.’ ");
INSERT INTO bpr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na tmimel agu, man-gu, ‘Ta gadè dad to dini i tagnè nimògu, dunan nkatgu nagu i dad gumnè gustifun i dad Dyu du kanfègu na nfasgu i dad to ftoo di ge. ");
INSERT INTO bpr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na di kfatila ku Stifén, i snaligam, déé agu, na magin agu di knayèla fmati dun, na do fa mantay i dad saulla.’ ");
INSERT INTO bpr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bay ani i timelan do, manan, ‘Mdà ge nan, du fgatùta ge di mawag banwe di dad to ise Dyu.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Di kman Pol ayé, ta déé gusen dad to flinge di kenen. Na mkit ale, manla, “Fnati kenen! Là gtenan mnè di tah tanà!” ");
INSERT INTO bpr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na too ale mkit, na walla i dad saulla, na smabul ale kfung. ");
INSERT INTO bpr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yé dek kernél i dad sundalu di dad ton nebela Pol di lam i barak, na nfasla fye tulenan ku dét duen dad Dyu kenen i gumdàla mkit. ");
INSERT INTO bpr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Na di ta kbakusla ku Pol du ta fanla nfas, ta snalekan i kapitan i dad sundalu, manan, “Fakayyu nfas i to Roma ku là fa gadèyu i salàan?” ");
INSERT INTO bpr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Na kanto linge i kapitan ayé, ta mdà kenen salu di kernélla, na tulenan i man Pol. Na snalekan kenen, manan, “Dét i fanam nimò di to ayé? To Roma kenen kadì.” ");
INSERT INTO bpr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Na ta salu i kernélla ayé di ku Pol, na snalekan kenen, manan, “Tulenam do kun. To Roma ge kè?” Na tmimel Pol, manan, “Hee.” ");
INSERT INTO bpr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Na man i kernél, “Too bong bayadgu do klogu mgimò to Roma.” Na man Pol, “Bay do, mdà di ksutgu to Roma agu.” ");
INSERT INTO bpr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Na i dad to fan smalek ku Pol, ta tnagakla kenen. Na kanto gadè i kernél ayé i to ta fbakusan, to Roma, too kenen likò. ");
INSERT INTO bpr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na yé kayè i kernél ayé ku gadèan ku dét salà Pol di dale. Taman, di tmadol du, ta ftehan dad sangkalì bakusla ku Pol, na fastifunan i dad ganlal di kafaglutla na i kdee dad mdatah ganlal, na neben Pol déé du ftadagan di munala. ");
INSERT INTO bpr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Na meye Pol di dad mdatah ganlal ayé, na manan, “E dad flanekgu, ta landè gumsamuk nawagu gablà di ktogu mdà di munan kel di mdu ani.” ");
INSERT INTO bpr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Di kafnge Pol man ayé, i ulu dad ganlal di kafaglut i dad Dyu, dekan i dad to tadag di saféd Pol smamfak bàan. ");
INSERT INTO bpr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Na man Pol di kenen, “Snamfak Dwata ge du mdà di kaflingum. Yé duenam sudeng déé du nukumam agu mdà di dad uldin blé Dwata fagu di ku Mosis, bay ta glafàam i dad uldin ayé fagu di kafsamfakam do.” ");
INSERT INTO bpr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Na man i dad to tadag di saféd Pol, “Kan ku talù ge sasè di ganlal ta mgalék Dwata?” ");
INSERT INTO bpr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Na tmimel Pol, manan, “Dad flanekgu, là gadègu ku ganlal kenen, du yé man di Tnalù Dwata, ‘Nangyu talù sasè di ganlalyu.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Na kanto gadè Pol na nun dad Sadusi na dad Farisi déé, ta falbongan i talùan di dad mdatah ganlal, manan, “Dad flanekgu, Farisi agu, na ngà agu fa i satu Farisi. Na yé duenla mukum do ani du fantoogu na nték i dad mati.” ");
INSERT INTO bpr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Na mdà di kmanan ayé, ta baling sbalew i dad Farisi na dad Sadusi, na ta masgalel i kdeela stifun déé. ");
INSERT INTO bpr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Du i dad Sadusi, yé manla dale na landè nték di fati, na landè layef i dad to, na landè kasaligan i Dwata. Bay i dad Farisi dale, yé fantoola na nun kdee ani). ");
INSERT INTO bpr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Na baling midul i kasbalewla, na tadag i dademe dad to tamdò i dad uldin blé Dwata fagu di ku Mosis glam di dad Farisi, na nsenla Pol, manla, “Landè teenmi sasè nimò i to ani. Keng ta nun lmagol ku demen kasaligan talù di kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na mdà di kinit kasbalew i dad to ayé, yé kalnikò i kernél i dad sundalu keng sanktangla Pol. Na yé duenam man, dekan i dad sundalun mwè ku Pol na nebela fusuk di barak. ");
INSERT INTO bpr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na di kifuh ayé, tadè msut i Amu di saféd Pol, na manan dun, “Fan-galam i nawam du ku dét i kibòam tmulen gablà di do dini di Dyérusalém, salngad ayé i ktulenam ditù di Roma.” ");
INSERT INTO bpr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na kanto flafus, nun dad Dyu stifun, yé santulenla kfatila ku Pol. Na yé sdagèla silang ale kmaan na minum ku ta gfatila kenen. ");
INSERT INTO bpr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Yé kdee dad lagi ayé mlukas fat falò. ");
INSERT INTO bpr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Na salu ale di dad ganlal di kafaglut i dad Dyu na di dad tua gal mebe dad Dyu, na manla, “Yé sdagèmi silang gami kmaan ku ta gfatimi Pol. ");
INSERT INTO bpr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Taman, ani fye nimòyu magin i dad mdatah ganlal. Katedyu di kernél i dad sundalu di Roma feben Pol dini du nun fa kayèyu gadè gablà di kenen. Na gami fmati kenen di laman là gafat dini.” ");
INSERT INTO bpr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bay, i ngà libun Pol lagi, lingen i kastulenla, na yé duenam man, fusuk kenen di barak du tulenan ku Pol. ");
INSERT INTO bpr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Na tlo Pol i satu ganlal i dad sundalu, manan dun, “Begam nagin i lamnok lagi ani salu ditù di kernél du nun kayèan man dun.” ");
INSERT INTO bpr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Na ta naginan i lamnok lagi ayé salu di kernél. Na kanto ale kel ditù, ta man i ganlal ayé di kernélla, “I satu to di blanggù, dunan Pol, yé fnin nagin-gu gadini di ge i lamnok lagi ani du nun kayèan man di ge.” ");
INSERT INTO bpr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Na i kernél ayé, nagotan sigal i lamnok lagi ayé, na neben fawag, na snalekan, manan, “Dét kè i kayèam man di do?” ");
INSERT INTO bpr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na tmimel i lamnok lagi ayé, manan, “Yé ta gusasatu nawa i dad Dyu fnila di ge febem dale fayah Pol salu di kanfe i dad mdatah ganlal du manla na nun fa kun kayèla gadè gablà di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bay nangam fantoo i manla ayé du mlukas fat falò i dad lagi fmakét di dalan du fnatila kenen. Ta samdagè ale na silang ale kmaan na minum ku ta gfatila Pol. Ta gatlagad ale ani, na lo yé fatanla ku dét i manam.” ");
INSERT INTO bpr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Na kafnge ayé, ta dekan mdà i lamnok lagi ayé, na manan dun, “Nangam tulen di balù simto dun i ta tulenam di do ani.” ");
INSERT INTO bpr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Na kafnge ayé, ta tlo kernél ayé lwe kapitan i dad sundalu, na dekan ale, manan, “Fatlagad gamu lwe latuh i dad sundalu, na fitu falò dad sundalu smakay kudà, na lwe latuh i dademe mebe agas du kadang alas nuwébi di kifuh mdà gamu salu di Sisarya. ");
INSERT INTO bpr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Na fatlagadyu dad kudà gusmakay Pol, na too gamu fgeye di kebeyu dun fye gafat di Gubirnador Filik na landè sasè mkel di kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na smulat i kernél di gubirnador, ani manan, ");
INSERT INTO bpr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Do, Klawdyu Lisyas, i smulat ani di ge, mgafè Gubirnador Filik. Kumusta ge déé. ");
INSERT INTO bpr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ta kanfè dad Dyu i to ani, na fanla kenen fnati, bay kantogu gadè to Roma kenen, ta fagin-gu i dad sundalugu, na falwàgu kenen. ");
INSERT INTO bpr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Du kayègu gadè ku dét i salàan, taman, ta nebegu kenen di gustifun i dad mdatah ganlalla. ");
INSERT INTO bpr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Na déé ta gugmadègu dun landè salàan ku gablà kenen fnati ku demen fablanggù. Bay lo yé salàan kun, lnafàan i uldin blé Dwata di dale. ");
INSERT INTO bpr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na kanto nun tmulen do gablà di ayèla fmati kenen, ta gasilgu ftunda di ge. Na ta yé man-gu di dad to tmifù kenen, tulenla ge ku dét i salàan.” ");
INSERT INTO bpr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Taman, di kifuh ayé, ta nwè dad sundalu Pol, na nebela kenen di banwe Antipatris du nimenla i dek di dale. ");
INSERT INTO bpr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na di tmadol du, i dad sundalu tmanà, samfulê ale ditù di barak, bay i dad sundalu kmudà, yé i fles tmunda ku Pol. ");
INSERT INTO bpr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na kanto ale kel ditù di Sisarya, ta bléla i sulat di gubirnador, na bléla Pol di kagotan. ");
INSERT INTO bpr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Na ta bnasa i gubirnador i sulat ayé, na snalekan ku dét probinsya gumdà Pol. Na kanton gadè na yé gumdàan di Silisya, ");
INSERT INTO bpr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ta manan ku Pol, “Falningeta ge ku ta kel i dad tmifù ge.” Na dekan i dad sundalu fye bnantayla Pol di gumnè Harì Hérod. ");
INSERT INTO bpr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na kafnge lime butang, ta salu Ananayas, i ulu dad ganlal di kafaglut i dad Dyu ditù di Sisarya, na faginan dademe dad tua gal mebe dad Dyu na Tirtulu, i abugadu. Na tadag ale di kanfe i gubirnador, du tulenla di kenen i manla dad salà Pol. ");
INSERT INTO bpr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ta fatlo i gubirnador Pol, na kanto kel déé, ta tambù Tirtulu tmifù ku Pol, manan, “Too mgafè Gubirnador, ta mlo nan nun bong kgilih i mgimòam gamfye di banweto. ");
INSERT INTO bpr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Là fanak gami dmilè ani balù nèan, na too gami fasalamat di ge. ");
INSERT INTO bpr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bay ani, là fantahàgu i talùgu du tà ge ganggà, bay lo yé fnigu di ge, ku mfakay, begam gami falninge là mlo. ");
INSERT INTO bpr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Teenmi Pol, kenen i mebe samuk du banlétan i dad Dyu mimò samuk di klamang banwe. Na kenen i ulu di fantoo i dad to di Nasarét. ");
INSERT INTO bpr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na kayèan fagsik i Gumnè Gumangamfù di Dwata, taman, ta kanfèmi kenen, du kayèmi nukum glalò di uldinmi. ");
INSERT INTO bpr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Bay kel Kernél Lisyas, na nladan di gami. ");
INSERT INTO bpr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na dekan i kdee tmifù di kenen salu di ge. Ku toom kenen snalek, glabatam i kdee tifùmi kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na nagin dad Dyu déé i tifùla ku Pol, na manla slame glut i kdee manan ayé. ");
INSERT INTO bpr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na kafnge ayé, sninyas i gubirnador Pol du ftalùan. Na man Pol, “Gadègu ta dee falim mukum di banwe ani, taman, too agu lehew msen i ktogu di kanfem. ");
INSERT INTO bpr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ku toom snalek i dad to, gadèam na là fa gafatan sfalò lwe butang, i ta kgatùgu di Dyérusalém du mangamfù agu di Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","I dad to tmifù do, teenla na là mbet agu sbalew di Gumnè Gumangamfù di Dwata, na là banlétgu i dad to di dad gumnè gustifun i dad Dyu ku demen balù nèan di syudad ayé. ");
INSERT INTO bpr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na landè gfitela di ge ku yé gugmadèam dun na glut i tifùla do. ");
INSERT INTO bpr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bay di kaglutan, yé tulen-gu di ge na mangamfù agu di Dwata, dunan i fnangamfù dad gutambulmi fagu di klalògu i Dalan Amu, i manla satu fantoo là glut. Na lêgu fantoo i kdee dad uldin blé Dwata fagu di ku Mosis na i kdee dademe dad tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Na salngad i dad to ani, yé fanden-gu di Dwata na nun du ntékan i kdee dad to mati, fye ku demen sasè. ");
INSERT INTO bpr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Na yé duenam man, toogu fan-geye i ktogu du fye landè gumaslen-gu di kanfe i Dwata na lê man di dad to. ");
INSERT INTO bpr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Dee faligu là ditù di Dyérusalém, kafnge ayé, ta lê agu ditù du nun nebegu filak tabeng di dademegu Dyu i mnè di klimah, na nun dad dsù blégu di Dwata ditù. ");
INSERT INTO bpr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Di kitela do di Bong Gumnè Gumangamfù di Dwata, sanagu fnge flaneb glalò di uldin Dwata fagu di ku Mosis. Là dee gami ditù, na là mimò gami samuk. ");
INSERT INTO bpr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bay nun dad Dyu mdà di Asya ditù. Dale moon i gablà smalu di ge na tmulen i salàgu, ku nun sa. ");
INSERT INTO bpr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ku demen i dad to ani i ftulenam i salàgu di kaftadagla do di kanfe i dad mdatah ganlal. ");
INSERT INTO bpr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Lo yé duenla malbut di do du ta falbonggu talùgu, na man-gu dale ani, ‘Yé duenyu mukum do du fantoogu na nték i dad mati.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Na Filik, toon gadè gablà di Dalan i Amuto, taman, fafanakan i kasfala, manan, “Silanggu nukum i to ani ku ta kel Kernél Lisyas.” ");
INSERT INTO bpr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Na yé flaun di satu kapitan i dad sundalu, bnantayla Pol, bay falohla kenen mimò i knayèan, na falohla i dademen lmauy kenen du fye banléla kenen i dad kalnidùan. ");
INSERT INTO bpr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Na kafnge dad file du, ta lê kel Filik, na magin i yaanan Drusila, i satu Dyu. Fngén Pol, na falningen i ktulenan gablà di kaftoo ku Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Na di lam Pol tmulen gablà di katluh, na i kadnan nawa, na i Du Kukum, ta likò Filik, na manan, “Ta gablà ayé. Fakay ge mdà. Na ku lê nun gugaslenggu, lêta ge fngé.” ");
INSERT INTO bpr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Bay di kaglutan, yé kayè nawan ku banlé Pol kenen filak du fye falwàan. Na yé duenam man, galan fngé Pol du stulen ale. ");
INSERT INTO bpr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Na kanto mlius i lwe fali, yé tamlas ku Filik dunan Porsyu Fistu. Bay là falwà Filik Pol di blanggù du yé kayèan ku lehew i dad Dyu mdà di nimòan. ");
INSERT INTO bpr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tlu butang i klo Fistu kel di probinsya, ta mdà kenen di Sisarya salu ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Na i dad ganlal di kafaglut i dad Dyu na i dademe dad ganlal di gubirnu, tulenla di kenen i dad salà Pol. ");
INSERT INTO bpr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Na fakdo ale di ku Fistu, yé fnila ku nilihan Pol di Dyérusalém mdà di Sisarya du fatlagad ale fmakét di dalan fmati kenen. ");
INSERT INTO bpr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bay tmimel Fistu, manan di dale, “Ditù ta gublanggù Pol di Sisarya, na là mlo i kasfulêgu ditù. ");
INSERT INTO bpr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Taman, faginyu do i dademe dad ganlalyu du dale tmulen i salà Pol, ku nun sa salàan.” ");
INSERT INTO bpr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Na nun dad walu ku demen sfalò butang klo Fistu déé di Dyérusalém, na kafnge ayé, ta lê samfulê ditù di Sisarya. Na di tmadol du, ta sudeng kenen di gumukuman, na fatlon Pol. ");
INSERT INTO bpr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Na kanto kel Pol déé, i dad Dyu ta salu déé mdà di Dyérusalém, ta salnibutla, na dee dad blat tifùla kenen, bay landè fitela gugmadè dun ku glut i manla. ");
INSERT INTO bpr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Na kafnge ayé, ta tmimel Pol, manan, “Landè glafàgu di dad uldin i dad Dyu, na i dad uldin di Gumnè Gumangamfù di Dwata, na i uldin Sisar, i ulu di Roma.” ");
INSERT INTO bpr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bay yé kayè Fistu ku lehew i dad Dyu mdà di nimòan, taman, snalekan Pol, manan, “Mayè ge salu ditù di Dyérusalém, na ditù gumukumta ge?” ");
INSERT INTO bpr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Na tmimel Pol, manan, “Ta dini agu di gal gumukum Sisar, na ani i gablà gumukum do. Na ta sanam gadè sa na landè salàgu di dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ku nun uldin glafàgu i gablà gufmati do, là milah agu. Bay ku landè kaglut i tifùla do, landè balù simto dun i fakay mlé do di dale. Na ani, yé fnigu ku Sisar mukum do.” ");
INSERT INTO bpr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Na kafnge Fistu stulen di dad to gal falmau kenen, ta manan ku Pol, “Du yé fnim ku Sisar i mukum ge, taman ditù gusalum di ku Sisar.” ");
INSERT INTO bpr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Na kafnge dad file butang, ta kel Harì Agripa na Bérnis déé du fitela kdawatla ku Fistu. ");
INSERT INTO bpr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na du dee butangla déé, stulen Fistu ku Harì Agripa gablà di kasfala Pol. Manan dun, “Nun satu to blanggù dini i là falwà Filik. ");
INSERT INTO bpr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na di ksalugu ditù di Dyérusalém, i dad ganlal di kafaglut i dad Dyu na i dad tua gal mebe dad Dyu, tnifùla kenen, na yé fnila di do falnayamgu. ");
INSERT INTO bpr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Bay yé ta man-gu di dale, ise ayé adat di Roma ku falnayam i satu to di laman là fa samsite dad to tmifù kenen, na là fa gtimelan i dad tifùla dun. ");
INSERT INTO bpr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Taman kanto ale kel dini di Sisarya, ta là fganggà agu, bay di tmadol flafus ta fngégu kenen salu di gumukum. ");
INSERT INTO bpr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Na di ktalù i dad to tmifù kenen, yé man nawagu ku nun blat tifùla kenen, bay landèan. ");
INSERT INTO bpr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bay lo yé sanbalewla di kenen gablà di fantoola na gablà ku Dyisas, i satu lagi ta mati, na man Pol ta mték kun. ");
INSERT INTO bpr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Na du là gadègu ku dét kibò kukumgu di kasfala ani, taman, snalekgu kenen ku mayè salu ditù di Dyérusalém na ditù gumukumgu dun. ");
INSERT INTO bpr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bay du yé fni Pol yé kayèan mukum dun Sisar na kayèan fbantay, taman ta dekgu i dad sundalu mantay kenen kel di kfebegu dun ditù di ku Sisar.” ");
INSERT INTO bpr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Na man Agripa di ku Fistu, “Mayè agu do flinge i man i lagi ayé.” Na tmimel Fistu, manan, “Fayah i kaflingem dun.” ");
INSERT INTO bpr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Na yé duenam man di tmadol du, ta kel ale Agripa na Bérnis, na toola fite i kdatahla. Na fusuk ale di gumukum magin i dad kapitan i dad sundalu na i dademe dad lagi nun glal di syudad ayé. Na fngé Fistu Pol, na nebela déé. ");
INSERT INTO bpr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Na man Fistu, “Harì Agripa na i kdeeyu stifun dini, ta dini i lagi ani tnifù i kdee dad Dyu ditù di Dyérusalém na lê man dini di Sisarya. Na mkit ale, manla, ‘Gablà kenen fnati.’ ");
INSERT INTO bpr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bay landè teen-gu salàan ku gumdà fmati kenen, bay du yé ta fnin ku Sisar i mukum kenen, fan-gu febe kenen gatù di Roma. ");
INSERT INTO bpr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bay landè gadègu man di sulatgu di ku Sisar gablà ku Pol. Yé duenam man, ta nebegu kenen dini di ge, Harì Agripa, na di kdeeyu ta stifun dini, du fye fagu di ksalekto kenen, nun fakaygu man di sulatgu di ku Sisar. ");
INSERT INTO bpr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Du di fandamgu, là fakay ku nun to blanggù febegu salu ditù di gumdatahto ku landè too mbateng tifù kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Na man Agripa di ku Pol, “Ta fakay ge talù msen i ktom.” Na ftadag Pol i sigalan, na manan, ");
INSERT INTO bpr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Harì Agripa, too fye bagìgu di mdu ani du tadag agu di kanfem talù msen i ktogu gablà di kdee dad tifù i dad Dyu di do. ");
INSERT INTO bpr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Midul déé du ta toom gadè i kdee adat na i dad tdò gulà salngad i dad Dyu. Na yé duenam man, too agu beg fakdo di ge, ku mfakay, toom fantahà i nawam falminge do. ");
INSERT INTO bpr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ta gadè i dad Dyu i kebegu i ktogu mdà di ktukaygu ditù di banwegu, na kel di knègu ditù di Dyérusalém. ");
INSERT INTO bpr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ta mlola gadè na glam agu di dad Farisi, i lumbuk di kafaglut i dad Dyu too minit lmalò di dad uldin blé Dwata fagu ku Mosis. Ku lo ale mayè, ta tulenla ge moon. ");
INSERT INTO bpr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na yé duen-gu dini du nukum agu mdà di kaftoogu i fakang Dwata di dad gutambulmi, ");
INSERT INTO bpr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","dunan i fakang sanfatan i dad sfalò lwe lumbuk i dad toto di lamla mangamfù di Dwata mdu na kifuh. Na ani, Mgafè Harì, mdà di kafden-gu ani, ta balingla agu tnifù. ");
INSERT INTO bpr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kan dé ku là ftoo gamu na nték Dwata i dad to mati? ");
INSERT INTO bpr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Na yé man nawagu do di munan, do ktoo mimò i kdee gnagan-gu dmuen i dagit Dyisas mdà di Nasarét. ");
INSERT INTO bpr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na yé nimògu di Dyérusalém, banlé i dad ganlal di kafaglut i dad Dyu agu ktoo fablanggù dad to ftoo di ku Dyisas, na ku ta nukum ale di fati, nagin-gu i kukum ayé. ");
INSERT INTO bpr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Na dee dulêgu faflayam dale di dad gumnè gustifun i dad Dyu, na fnegesgu ale tmagak i kaftoola. Na mdà di too sasè kalbutgu dale, ta lalògu ale di dad syudad di dademe banwe. ");
INSERT INTO bpr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Na yé duen-gu salu ditù di Damaskus du ta nun ktoogu mdà di dad ganlal di kafaglut i dad Dyu, na dale i ta mdek do. ");
INSERT INTO bpr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mgafè Harì, kanto di ltu du, di lamgu magu, teen-gu mdà di langit i bong neng gamban fa di neng du glibut di kdeemi magu. ");
INSERT INTO bpr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ta bek gami di tanà, na nun lingegu talù, manan do di talù Hibru, ‘E Sol! E Sol, kan dé ku falnayamam agu? Falnayamam i ktom di nimòam ani salngad i safì smifà i talam sulè.’ ");
INSERT INTO bpr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Na smalek agu, man-gu, ‘Amu, simto ge kè?’ Na tmimel kenen, manan, ‘Do sa Dyisas, i galam falnayam. ");
INSERT INTO bpr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bay mték ge, na tadag ge du yé duen-gu fite di ge du nimòta ge fasakgu. Ge tmulen i ta teenam mdà ani na i dad tmadol fiteta ge. ");
INSERT INTO bpr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Falwàta ge mdà di falel i dad Dyu na i dad to ise Dyu, du yé dad to gumdekta ge. ");
INSERT INTO bpr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ge mukà i fandamla, du fye tnagakla i gukmifuhan salu di gumalwan, na tnagakla i kagot Satanas salu di Dwata, du fye magfasinsya i dad salàla, na gdawatla i dale alel gagin di dademe dad to ta mgalék Dwata.’ ");
INSERT INTO bpr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Na yé duenam man, Harì Agripa, ta nimen-gu i kanteen-gu mdà di langit. ");
INSERT INTO bpr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Yé tnanin banwe gutamdògu di Damaskus, na kafnge ayé, di Dyérusalém na di kabal banwe i dad Dyu, na i dad to ise Dyu. Na yé tdògu dale nsalla i dad salàla, na smalu ale di Dwata, na mimò ale dad fye nimò ilè dun na ta msal ale. ");
INSERT INTO bpr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na yé duen i dad Dyu kamfè do di Gumnè Gumangamfù di Dwata, na fanla agu fnati. ");
INSERT INTO bpr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bay kel di mdu ani i ktabeng Dwata do, taman dini agu tmulen di kdee dad to, baling mdanà ku demen mdatah. Lo yé tulen-gu i tagnè man i dad tugad Dwata, na lê man Mosis, ");
INSERT INTO bpr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","dunan là fakay ku là falnayam i Mgalék Dwata, na kenen i muna nték di fati, du fye tulenan gablà di salò mlé kagalwà di dad Dyu na di dad to ise Dyu.” ");
INSERT INTO bpr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Na di lam Pol talù, ta mkit Fistu, manan, “Pol, ta book ge! Yé ta gambook ge mdà di kalbong gnadèam.” ");
INSERT INTO bpr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Na tmimel Pol, manan, “Gubirnador Fistu, là sa book agu. I man-gu too ti glut na tluh. ");
INSERT INTO bpr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gadè harì sa i kdee ani, taman là lngawè agu stulen di kenen. Na fantoogu ta gadèan i kdee du ise ayé gumgimò i kdee ani di gugbunin. ");
INSERT INTO bpr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","E Harì Agripa, fantoom kè i man dad tugad i Dwata? Ta gadègu fantoom ale.” ");
INSERT INTO bpr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Na tmimel Harì Agripa, manan, “Yé man nawam kè ku mlalam agu mgebe di kaftoo di ku Dyisas Krayst?” ");
INSERT INTO bpr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Na tmimel Pol, manan, “Baling mlo ku demen là, yé dasalgu di Dwata, ge na i dademem lminge i man-gu ani, mgimò gamu salngad do, bay ise ku nikat sangkalì.” ");
INSERT INTO bpr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Na ta tadag Harì Agripa, Gubirnador Fistu, Bérnis, na i kdee dad to flinge. ");
INSERT INTO bpr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Na kanto ale lamwà di gustifun ayé, ta stulen ale, manla, “Là gten i to ani blanggù demen fnati du landè sasè nimòan.” ");
INSERT INTO bpr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na man Agripa di ku Fistu, “Ta galwà i to ayé moon, ku là balingan fni Sisar mukum kenen.” ");
INSERT INTO bpr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kanto yé gusasatu nawala, febela gami ditù di Itali, ta bléla ale Pol na i dademe to blanggù di ku Dyulyu, i kapitan i dad sundalu Roma glam di lumbuk dnagit Dad Sundalu Ulu. ");
INSERT INTO bpr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Aweng mdà di Adramityum i snakaymi, ta fan mdà slob di dad banwe mdadong di kilil mahin glam di Asya. Na ta mdà gami nan, na yé satu to magin di gami Aristarku. To Masidunya kenen, na yé gumdàan di syudad Tésalonika. ");
INSERT INTO bpr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na di tmadol du, ta dmuung gami di Sidon, na mdà di kakdo Dyulyu, ta falohan Pol lmauy di dademen sgalak déé du fye banléla kenen i dad kalnidùan. ");
INSERT INTO bpr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Na lê gami fles maweng, bay du gsunsungmi i kamgis nus, taman yé dalanmi di guglidung nus di fungul Sipru. ");
INSERT INTO bpr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Na ta nifalmi i mahin sablà Silisya na Pamfilya, na dmuung gami di Mira glam di banwe Lisya. ");
INSERT INTO bpr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Na déé gumite kapitan i dad sundalu satu aweng mdà di Alihandriya salu di Itali, na déé lêan gufsakay gami. ");
INSERT INTO bpr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Di lam i file du, too mlimah na léét kagu awengmi kel di kgafatmi di banwe Knidu. Na mdà di nus, là gafles gami, taman, yé dalanmi di guglidung i nus di fungul Krit sablà i banwe Salmoni. ");
INSERT INTO bpr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Fkilil gami, bay too ti mlimah i kagumi, na manak magu i aweng, ta kel gami di satu banwe, dnagit Fye Gudmuung, mdadong di lunsud Lasya. ");
INSERT INTO bpr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Too gami mlo di kagumi, na ta gnumah i dangan sasè mahin gami, du ta glius i kafwasa i dad Dyu. Na yé duenam man, falnau Pol ale, manan, ");
INSERT INTO bpr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“E leg, gadègu ku fles ato di kaguto ani, baling nun gaslokto, na malmo i awengto, na lê man i dad lulen, na balù kel di gito, lê ato man maglà.” ");
INSERT INTO bpr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bay i kapitan i dad sundalu, là falningen i man Pol, bay baling yé nimenan i flau i to mebe aweng, na i to mfun dun. ");
INSERT INTO bpr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","I gudmuungmi ayé, sasè gufanak di dangan tno, taman yé kayè i gudeen, fles gami na fan-galmi nawami gmafat di Finik, du fye déé gufanakmi di dangan tno. Finik i satu gudmuung glam di Krit, gsen di gusdaf du, na là gfanan di nus sabnal di dangan tno. ");
INSERT INTO bpr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ta tambù mbal i nus mahin, bay mganag, na yé fandamla ku gamtabeng di kebela i aweng. Taman, ta dyolla salu tah i blangaw, na fkilil ale di fungul Krit. ");
INSERT INTO bpr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bay, di là mlo, ta mbal i too kamgis nus fdu di fungul ayé. ");
INSERT INTO bpr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Na landè kibò smunsung i aweng du ta too kamgis i nus, taman ta balingmi fnagin. ");
INSERT INTO bpr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Na kagablàmi di tukay fungul dnagit Kawda, kantomi glidung, ta bnatunmi i tukay boti aweng ayé, bay beg gami maflayam. ");
INSERT INTO bpr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Na di kagbatun i tukay boti di tah i aweng, ta bnatangla i aweng bong tali du fye mbagal. Na lnulunla i layal, na tadè ale fanul du likò ale keng gaskét di falak di sablà Libya. ");
INSERT INTO bpr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Na du là fanak i kamgis nus, di tmadol du, ta batla i dademe dad lulen di mahin du fye là too blat i aweng. ");
INSERT INTO bpr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na lê di tmadol du, ta balingla bat i dad kalyak i aweng di mahin. ");
INSERT INTO bpr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Na dee butangmi là mite i mata du na i dad blatik, na là tlag i kamgis nus. Ta là fandenmi dun ku dè gami mto. ");
INSERT INTO bpr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Na kafnge dad file du i dad to là kmaan, ta tadag Pol, manan, “E dad flanek, ku loyu agu nimen moon, na nang ato baling fles di Krit, là ti gambet ani i gaslokto. ");
INSERT INTO bpr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bay ani fnigu di gamu, fan-galyu i nawayu du landè balù satu di gamu mati. Bay lo ayé malmo i aweng. ");
INSERT INTO bpr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Balbutang, i Dwata mfun do, na fnangamfùgu, mdek kasaligan salu di do. ");
INSERT INTO bpr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Na manan, ‘Pol, nang ge likò. Là fakay ku là tadag ge di kanfe Sisar. Mdà di kafye Dwata, falwàan i kdeeyu du mdà di ge.’ ");
INSERT INTO bpr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Na yé duenam man, nang gwè nawayu, du yé snaliggu dnohò Dwata i ta manan di do. ");
INSERT INTO bpr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bay gadkal ato ditù di satu fungul.” ");
INSERT INTO bpr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na di gasfalòan fat butang, sana kebe i nus gami mifal di mahin Méditerényan. Na mdadong di tngà butang, yé fandam i dad to mebe i aweng, ku ta mdadong gami di kilil. ");
INSERT INTO bpr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Na bantasla i kngalam mahin ta gukelmi, na yé kngalaman lwe falò dife. Na di là mlo, ta lêla bantas, na yé kngalaman sfalò lime dife. ");
INSERT INTO bpr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Na likò ale keng gaslob i aweng i dad batu di kilil, taman ftatekla fat blangaw di ulin, na dmasal ale fye gasil malwa. ");
INSERT INTO bpr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Na i dad to mebe i aweng, flingu ale ftatek dademe dad blangaw, bay di kaglutan ftufala i tukay boti du milah ale. ");
INSERT INTO bpr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bay man Pol di kapitan i dad sundalu na di dad sundalun, “Silang gamu galwà ku là tnagak i dad lagi ani i aweng.” ");
INSERT INTO bpr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Taman, i dad sundalu, fantohla i dad ikat i tukay boti, na tadèla bayà manul. ");
INSERT INTO bpr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na kanto fan flafus, nlak Pol ale kmaan. Manan dale, “Ta sfalò fat butangyu too likò, na là ti kmaan gamu. ");
INSERT INTO bpr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Na ani fnigu di gamu, beg gamu kmaan du fye nun kgisyu. Na landè lanah, balù sbalu wakyu.” ");
INSERT INTO bpr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Na kafngen man ayé, ta mwè fan, na fasalamat di Dwata di kanfe i kdee dad to ayé. Na falnakan i fan, na ta tambù kenen kmaan. ");
INSERT INTO bpr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Na ta matgal i nawala, na ta kmaan i kdeela. ");
INSERT INTO bpr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Na yé kdeemi smakay di aweng ayé 276. ");
INSERT INTO bpr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Na kanto ale bsol, ta batla i gdè mseh trigo di mahin du fye là too blat i aweng. ");
INSERT INTO bpr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Na kanto flafus, là dilèla i banwe gugadkalla, bay nun teenla lgù nun falak di kililan, na yé fnaleh nawala déé gufadkalla i aweng, ku nun kibò. ");
INSERT INTO bpr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Na fantohla i dad ikat blangaw du tnagakla di mahin, na lêla nbel i dad malbang tali di ulin. Na nbella i layal di dulung gsen di sumengan du fye nebe i nus ale salu di kilil. ");
INSERT INTO bpr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bay baling gasdang i aweng di bong buntud falak, na gsungal i sumengan di falak, na là gaganmi falwà dun. Na i sfo i aweng gsen di ulinan, ta malbà mdà di kgis i lwek. ");
INSERT INTO bpr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Na yé fandam i dad sundalu, fnatila i dad to blanggù du fye landè di dale gamkahung kel di kilil na milah. ");
INSERT INTO bpr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bay i kapitan, fnangan ale du kayèan tnabeng Pol. Na nè i dad to fulung kmahung, dekan ale muna kamyaf fye kmahung kel di kilil. ");
INSERT INTO bpr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na i dademe dad to, magot ale di kayu lamtew mdà di kalbà i aweng, na fagu déé, sdulê gami gafat di kilil. ");
INSERT INTO bpr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Na kanto gami galwà di sasè gaslokmi, na ta kel gami di kilil, ta nun tmulen gami na yé dagit i fungul ayé Malta. ");
INSERT INTO bpr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Na i dad to déé, too fye balula di gami. Dmutung ale lifoh, na mnalang gami du sigi mulen na tno, na nifatla i kdeemi. ");
INSERT INTO bpr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Na mukuh Pol snuk du dutungan. Na di kafkahan dun di lifoh, nun ulad lamwà di sol i snuk du too minit, na lnabédan i sigal Pol. ");
INSERT INTO bpr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Na i dad to mdà di Malta, kantola teen i ulad gatlawéng di sigal Pol, stulen ale, manla, “Keng manò i to ani du balù ku ta galwà kenen di mahin, bay i bagìan, là falohan dun mlawil.” ");
INSERT INTO bpr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bay filik Pol i ulad di lifoh, na landè sasè mkel di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Fatanla ku balak i lawehan ku demen makto mati. Bay kanto ale mlo fatan, na landè sasè kel di kenen, ta tanlasla i fandamla, na ta yé balingla man, “Kenen satu dwata.” ");
INSERT INTO bpr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nun tanà mdadong déé nfun Publiyu, i ulu di fungul ayé. Too fye kdawatan gami, na tlu butangan mifat gami di lam i gumnèan. ");
INSERT INTO bpr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Na i mà Publiyu, là gtékan du minit i lawehan, na milong litè. Na lnauy Pol kenen, na fkahan i falelan di kenen du dnasalan, na ta mgulê. ");
INSERT INTO bpr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Na kanto mgimò ayé, lê salu di ku Pol i dademe dad to fandas di fungul ayé, na lê ale mgulê. ");
INSERT INTO bpr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Too dee nimòla gudmilè i kafèla gami, na kanto gami fan mdà, bléla gami i kdee dad kalnidùmi. ");
INSERT INTO bpr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Na kafnge tlu bulen, ta lê gami mdà. Na yé snakaymi satu aweng mdà di Alihandriya funa fanak déé di Malta di dangan tno. Na yé dagitan “Dwata Sfangê.” ");
INSERT INTO bpr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Na dmuung gami di satu syudad, yé dagitan Siraku, na yé klomi déé tlu butang. ");
INSERT INTO bpr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Na lê gami mdà déé du salu gami di syudad Rigyum. Na di tmadol du, ta mbal i nus mahin, taman, di galwen du, ta kel gami di lunsud Putyoli. ");
INSERT INTO bpr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Na kanto gami kel déé, nun teenmi dademe dad to ftoo di ku Dyisas, na nlakla gami fanak di safédla fitu butang. Na kafnge ayé, ta fles gami di Roma. ");
INSERT INTO bpr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Na i dad to ftoo di ku Dyisas di Roma, ta lingela gablà di gami, na salu ale di fadyan dnagit Apya, na di dad tlu gumnè gal gumilè i dad to magu du lnabatla gami. Na kanto teen Pol i dad to ayé, fasalamat kenen di Dwata, na ta matgal i nawan. ");
INSERT INTO bpr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Na kanto gami kel di Roma, falohla Pol mnè di satu gumnè, na lo yé dademen i satu sundalu mantay kenen. ");
INSERT INTO bpr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Na kafnge tlu du, fastifun Pol i dad ganlal i dad Dyu, na manan dale, “E dad flanekgu, balù landè salàgu di dademegu Dyu, na di dad adat ta glalòto mdà di dad gutambulto, knèan blanggùla agu di Dyérusalém, na bléla agu di kagot i dad ganlal mdà di Roma. ");
INSERT INTO bpr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Toola agu snalek, na bulugla agu falwà du gadèla landè salàgu gumdàla fmati do. ");
INSERT INTO bpr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Bay kanto là mayè i dad Dyu ku galwà agu, ta mfeges agu mni yé mukum do Sisar. Bay knèan, là tamduk nawagu di dademegu Dyu. ");
INSERT INTO bpr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Na yé duen-gu mni samsite na stulen di gamu. Ani duen-gu nikat sangkalì ani du mdà di gumgal nawa Israél.” ");
INSERT INTO bpr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Na tmimel ale, manla, “Landè sulat gdawatmi mdà di Dyudiya gablà di ge, na i dad to ftoo di ku Dyisas ta kel dini, landè sa manla sasè gablà di ge. ");
INSERT INTO bpr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Bay yé kayèmi gadè ku dét i fandamam du gadèmi nun dad to di klamang banwe gal dmuen i kaftoo gumaginam.” ");
INSERT INTO bpr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Na mimò ale butang salu di ku Pol du falningela kenen. Na kanto kel i du ayé, dee dad to salu déé di gumnè gufanakan. Na mdà di flafus kel di kifuh, toon tulen na faglabatan di dale gablà di Kagot i Dwata, du yé kayèan ku mgeben ale di ku Dyisas fagu di katdòan mdà di dad uldin Dwata fagu di ku Mosis, na i sulat dad tugad Dwata. ");
INSERT INTO bpr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Na nun dademe, mgebe ale di kaftoo mdà di katdò Pol, bay i dademe, là. ");
INSERT INTO bpr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Là sasatu nawala, na ta mdà i dademe di kafnge Pol man dun, “Too ti glut i man Mtiu Tulus di dad gutambulyu fagu di ku Isaya, satu tugad i Dwata. Ani manan, ");
INSERT INTO bpr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Gatù ge di dad to ayé, na ani manam di dale, “Balù dét i kaflingeyu, là ti galmabat gamu. Balù dét i keyeyu, là ti mite gamu.” ");
INSERT INTO bpr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Du i dad to ani, magéng ulula, na nsangla i klingela, na fafidangla i matala. Ku ise ani moon nimòla, mite ale, na lminge, na galmabat, na mloh ale di do du fye fan-gulêgu.’ ” ");
INSERT INTO bpr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Na fannge Pol i manan, “Yé duenam man, fye ku gadèyu ta gatdò di dad to ise Dyu i tdò gablà di kagalwà blé Dwata, na ta toola falninge.” ");
INSERT INTO bpr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Di kafnge Pol man ayé, ta mulê i dad Dyu, na sigi ale sgil. ");
INSERT INTO bpr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Lwe fali klo Pol fanak di gumnè gal fbayad, na dnawatan i kdee dad to gal lmauy di kenen. ");
INSERT INTO bpr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Na too mgal i nawan, na landè to famnang kenen tamdò gablà di Kagot i Dwata, na Dyisas Krayst, i Amuto.");
INSERT INTO bpr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Do, Pol, gumdà i sulat ani, satu snalig Krayst Dyisas, na satu dek ta nalék na ta tlo Dwata tamdò i Fye Tulen. ");
INSERT INTO bpr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","I Fye Tulen ani, fakang Dwata di munan fagu di dad tugadan salngad i ta gsulat di Mtiu Tnalùan ");
INSERT INTO bpr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","gablà di Ngàan, i Amuto Dyisas Krayst. Di kafbalingan to, sut di bel Dabid. ");
INSERT INTO bpr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Na gablà di ktiun di kadwatan, yé gugmadèto dun kenen i Ngà Dwata maltulus du ta mték mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Fagu di kenen, na mdà di dagitan, banlé Dwata agu ktoo mgimò dekan du fye mgebegu di kaftoo na di kimen i dad to mdà di kdee banwe. ");
INSERT INTO bpr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Na gamu déé di Roma, ta flam Dwata gamu du fye nfun Dyisas Krayst gamu. ");
INSERT INTO bpr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Taman, smulat agu di kdeeyu déé di Roma i kanbong nawa na ta tlo Dwata du fye mgimò dad ton. Mulà moon i Màto Dwata na i Amuto Dyisas Krayst mlé gamu kafye na ktanak nawa. ");
INSERT INTO bpr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Muna di kdee, fasalamat agu di Dwata fagu di ku Dyisas Krayst gablà di kdeeyu du ta mbel di klamang banwe i kaftooyu. ");
INSERT INTO bpr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Gadè Dwata kaglut i man-gu, dunan i Dwata gutalbahògu mdà di nawagu fagu di katdògu i Fye Tulen gablà di Ngàan. Na gadè Dwata là glifetgu flam gamu di dad dasalgu. ");
INSERT INTO bpr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Fnigu di Dwata falohan agu moon lmauy gamu. ");
INSERT INTO bpr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Du too agu mayè samsite gamu du nun blégu gamu mdà di Mtiu Tulus i gamfbagal gamu. ");
INSERT INTO bpr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ani kayègu man, satgal ato di kaftoo. ");
INSERT INTO bpr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Dad flanekgu, nangyu glifet ta dee dulêgu maleh lmauy gamu, bay nun gamsang do. Kayègu ku lê nun di gamu nebegu di kaftoo salngad di nimògu di dademe ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Du nun utenggu di kdee dad to, i baling dad to syudad, na i dad to di lagad, i baling dad to nun gnadè, na i dad to landè gnadè. ");
INSERT INTO bpr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Taman, minit nawagu tamdò i Fye Tulen di gamu déé di Roma. ");
INSERT INTO bpr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Là kanyàgu i Fye Tulen, du yé gumite i kdatah Dwata falwà i kdee dad to ftoo, muna i dad Dyu, na lê man i dad ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Du fite i Fye Tulen i kfagu Dwata tamluh i dad to. Slame fagu di kaftoo mdà di katbùan kel di gusenan. Salngad man di Tnalù Dwata, “I to ta tanluh Dwata, mto fagu di kaftoon.” ");
INSERT INTO bpr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Fite Dwata mdà di langit i kalbutan di salà na di dad sasè nimò i dad to, du fagu di sasè nimòla, magsang i kaglut. ");
INSERT INTO bpr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","I ta gadèto gablà di Dwata, ta toon fbateng di dale. ");
INSERT INTO bpr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mdà di kimò Dwata i klamang banwe, ta too teen kagkahan, balù i là gagan teen salngad i kaltulusan landè sen na i kadwatan, du yé gumite dun di kdee ta nimòan. Taman, landè dawala. ");
INSERT INTO bpr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Balù dilèla i Dwata, bay là dnayenla i kadwatan, na là fnasalamatla kenen. Baling yé fandamla i landè gukel, na kmifuh i fandamla. ");
INSERT INTO bpr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Manla fulung ale, bay kadì sawe book ale. ");
INSERT INTO bpr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Là ti fnangamfùla i Dwata landè fati, baling yé fnangamfùla dad nimòla kbaweh to, anuk, lmanaf, na kmadaw. ");
INSERT INTO bpr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Na mdà di kbook i dad to ani, tadè bayà Dwata ale mimò i dad magsik knayè i nawala, na nimòla di dademela to i dad magyà nimò. ");
INSERT INTO bpr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ta knagolla i kaglut gablà di Dwata, yé tlasla dun i kakéng. Baling yé fnangamfùla i dad nimò Dwata, ise ku i mimò kdee ayé, na kenen gten magdayen kel di landè sen. Amén. ");
INSERT INTO bpr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Na mdà di nimòla ayé, tadè bayà Dwata ale di dad magyà nibal i ungad. Du balù dad libun, ta là lalòla i tagnè adat kgamit i klibunla. ");
INSERT INTO bpr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Na salngad i dad lagi, ta là snafédla i dad libun, bay ta yé balingla snaféd i dademela lagi mdà di kaklantugla. I dad slame lagi, simò ale magyà nimò. Taman, yé flayam gdawatla i gten di nimòla. ");
INSERT INTO bpr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Na mdà di knang i dad to dmawat i glut kaglabat gablà di Dwata, tadèan ale bayà di magsik fandam du nimòla i là gtenla nimò. ");
INSERT INTO bpr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Tmunà ale di kdee bung sasè, na dad magsik nimò, na dad salà, na i klom, na i dad bisyu. Lê ale tmunà di ksafè nawa, di kasbanò, di kasbalew, di ksakal, na di dademe sasè nimò. Lê ale samtugad salék, ");
INSERT INTO bpr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","safalmo ale, nutehla nawa i Dwata, fite ale dag, fdatahla i ktola. Sigi ale meye kfagu mimò sasè, na là nimenla i dad tuala. ");
INSERT INTO bpr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ta landè fye fandamla, na là dnohòla i dad fakangla, na landè kakdola, na landè klayù nawala. ");
INSERT INTO bpr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Gadèla na yé man i uldin Dwata i to mimò gambet ayé, gten fnati. Bay baling ale fadlug mimò i kdee sasè nimò ani, na yé too sasè du lêla dag i dad to mimò gambet ani. ");
INSERT INTO bpr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Balù simto ge fa, landè ktoom mukum i dademe. Du ku nukumam i dademem, bay salngad i nimòam, ta lêam nukum i ktom. ");
INSERT INTO bpr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Gadèto tluh i kukum Dwata di dad to mimò sasè i man-gu ayé gine. ");
INSERT INTO bpr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Man nawam kè galwà ge di kukum Dwata ku yé nimòam i nimò dad to ta nukumam? ");
INSERT INTO bpr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Tay, sawe landè btas di ge i kakdo, klayù nawa, na ktahà nawa Dwata. Là kè gadèam dun i kakdo Dwata, yé malak ge du fye msal ge moon? ");
INSERT INTO bpr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Bay too magéng ulum. Ta baling ge tamnù kablat flayam gdawatam kadang di du kfite Dwata i kalbutan na i tluh ukuman. ");
INSERT INTO bpr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Du Dwata mlé ulê nimò i kat satu to. ");
INSERT INTO bpr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nun dad to fadlug mimò fye, na nusalla kdatah, afè, na lawil landè fati mdà di Dwata. Na banlén ale kafye landè sen. ");
INSERT INTO bpr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Bay kok Dwata i katduk nawan na i kalbutan di dad to lom na kmagol i fye, du lo yé nimòla i sasè. ");
INSERT INTO bpr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Falnayam na fatduk i kdee dad mimò sasè, yé muna i dad Dyu, kafnge ayé, i dad ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Bay banlé Dwata kdatah, na afè, na ktanak nawa i kdee mimò fye, yé muna i dad Dyu, kafnge ayé, i dad ise Dyu, ");
INSERT INTO bpr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","du i Dwata, là ti mungulan. ");
INSERT INTO bpr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","I dad ise Dyu gamsalà, nukum ale, bay là fdàan dun di uldin Mosis du ise dale gugtadèan. Bay i dad Dyu gamsalà, yé gufdàan i kukuman dale di uldin, du dale gugtadèan. ");
INSERT INTO bpr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Du ise dad to lo flinge di uldin mgimò tluh di kanfe Dwata, bay i dad to mimen. ");
INSERT INTO bpr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","I dad to ise Dyu, ise dale gugtadè i uldin, bay ku mdà di klaan nawala mimò man i uldin, yé ta mgimò uldinla, balù ku landè dale uldin. ");
INSERT INTO bpr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Fagu di ldamla, gfitela na ta gsulat i uldin di nawala. I fandamla lê gfite i kaglut i man-gu ani, du slaan nsenan ale, na slaan knangan ale. ");
INSERT INTO bpr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Man i Fye Tulen tdògu, ani mkel kadang di fulé du, i dad fandam buni dad to, nukum Dwata fagu ku Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Na ge? Manam Dyu ge, na yé snaligam i uldin, na dagam i kaftoom di Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ta gadèam ku dét fimò Dwata ge mdà di uldin. Ta gadèam i tluh. ");
INSERT INTO bpr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Yé fandamam, ge tong malak i dad butè, na lwa ge di gukmifuhan. ");
INSERT INTO bpr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Na ge satu to tamdò di dad to landè gnadè, na di dad ngà. Ta gadèam déé di uldin i sikof gnadè na kaglutan. ");
INSERT INTO bpr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tdòam i dademe. Kan ku là tdòam i ktom? Yé tdòam, là fakay tmaku. Kan ku sana ktakum? ");
INSERT INTO bpr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Yé tdòam là fakay lmafà yaan. Kan ku sana klafàam yaanam? Ise yé manam niwasam i dad ise glut dwata? Bay kan ku tmaku ge di dad gumangamfùla? ");
INSERT INTO bpr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Fdag ge du ge gugtadè i uldin. Kan ku fyàam Dwata fagu di klafàam i uldinan ayé? ");
INSERT INTO bpr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Du yé man i Tnalù Dwata, “Sanlen i dad ise Dyu i dagit Dwata du mdà di gamu dad Dyu.” ");
INSERT INTO bpr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ku nimenam i uldin, nun gukmamu i ilè di laweh i lagi. Bay ku lnafàam i uldin, fye fa nang ge fimò ilè di laweham. ");
INSERT INTO bpr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","I dad ise Dyu landè ilè di lawehla, ku sikof kimenla i uldin, di kite Dwata dale, ta nun ilè di lawehla. ");
INSERT INTO bpr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Taman, gamu dad Dyu, yé mukum gamu dad ise Dyu du lnafàyu i uldin balù ku gamu gugtadèan na ta nun ilè di lawehyu. Bay dale, nimenla i uldin balù landè ilè di dale laweh. ");
INSERT INTO bpr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","I glut Dyu, ise ku mdà di katbulan ku demen i kfimò ilè di lawehan. ");
INSERT INTO bpr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","I glut Dyu, dunan i to falami i fandaman mdà di Tulus Dwata, ise fagu di uldin ta gsulat. Dwata i dmayen kenen, ise ku to. ");
INSERT INTO bpr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nun kè gufye i dad Dyu di dad ise Dyu? Na nun kè gukmamu i kfimò ilè di laweh? ");
INSERT INTO bpr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nun sa. Muna di kdee, dad Dyu gusmalig Dwata i Tnalùan. ");
INSERT INTO bpr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Dét kibò du i dademe, là gsalig ale? Yé kayèan man ani kè mdà di là kimenla, ta là dnohò Dwata i fakangan? ");
INSERT INTO bpr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ise! Gsalig Dwata balù ku sdulê tmulen kéng i kdee dad to. Salngad i man di Tnalù Dwata, “Di kdee manam, fitem i katluham. Ge gmagan ku nukumla ge.” ");
INSERT INTO bpr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bay ku i sasè nimòto balingan gfite i katluh Dwata, fakayto man kè là tluh Dwata di kaflayaman gito? (Lo kastulen to ani). ");
INSERT INTO bpr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Là fakay man na là tluh Dwata, du kaflingenta dun, ku là tluhan, ta là gtenan mukum i dad to di klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Bay ku fagu di ktulento kéng, baling midul kite kdatah Dwata mdà di toon kafbateng i katluhan, kan ku nukuman ato salngad i to gamsalà? ");
INSERT INTO bpr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kan ku là balingto man, “Mimò ato sasè du fye lamwà i fye?” Nun dad to tmifù do, du yé galgu tdò kun. Fye ku too ale falnayam gten di dale. ");
INSERT INTO bpr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Dét? Mas fye kè kagkahto gito dad Dyu di dad ise Dyu? Là. Du ta man-gu di muna i kdee dad to slame magfasak di salà, balù ku Dyu ku demen ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Du ani man di Tnalù i Dwata, “Landè to tluh di kite Dwata, balù satu. ");
INSERT INTO bpr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Landè galmabat, na landè mngabal i Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Gsalà i kdee, na ta tnagakla i Dwata. Landè mimò fye, balù satu. ");
INSERT INTO bpr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","I bkakongla, salngad i lbang mgukà. Gnamitla i dilàla lmimbung. Na samfut di salékla i alas ulad. ");
INSERT INTO bpr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Fnò i dad bàla dad féét flagi. ");
INSERT INTO bpr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Na too ale mlal manò. ");
INSERT INTO bpr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Na too ale mebe kalmo na ksamuk, balù nè gusalula. ");
INSERT INTO bpr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Na là dnawatla dalan i ktanak. ");
INSERT INTO bpr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Na là fulung ale likò di Dwata.” ");
INSERT INTO bpr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ani, ta gadèto i kdee dek i uldin, yé gugtadèan di dad to mimen i uldin du fye landè dawato, na glam di kukum Dwata i klamang banwe. ");
INSERT INTO bpr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Du landè to mgimò tluh di kanfe Dwata fagu di kimenan i uldin. Lo yé nimò i uldin, dunan fdilèan di dad to i ta kagsalàla. ");
INSERT INTO bpr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Bay ani, ta fite Dwata i dalanan mimò tluh i dad to. Ise ku yé gufagun dun di uldin. I uldin na i dad tugad Dwata fbateng i dalan ani. ");
INSERT INTO bpr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nimò Dwata tluh i dad to fagu di kaftoola di ku Dyisas Krayst. Nimòan ani di kdee ftoo di ku Krayst du landè gusahal i kdee dad to, ");
INSERT INTO bpr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ta gamsalà i kdee, na gawag ale di knayè Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bay mdà di kafye Dwata, mgimò ale tluh fagu di ku Krayst Dyisas, i falwà dale. ");
INSERT INTO bpr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Blé Dwata Krayst du fye fagu di kfalohan i litèan, magfasinsya dad salà i dad to ftoo di kenen. Yé duen Dwata mimò ani du fye fiten i katluhan. Di muna, tadèan bayà i salà du mdà di ktahà nawan. ");
INSERT INTO bpr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Bay ani, ta là bayàan i salà du fye fiten katluh i kukuman di ta nawan ani, du too kenen tluh, na kenen i lê mimò tluh i kdee ftoo di ku Dyisas. Bay ani, ta là bayàan i salà du fye fiten i katluhan. Na nimòan tluh i kdee ftoo di ku Dyisas. ");
INSERT INTO bpr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Taman, nun kè gumdàto fagdag? Landèan. Fakay kè ku fagdag ato mdà di kimento i uldin? Là. Yé duento là gafagdag du ta tanluhan ato lo fagu di kaftooto. ");
INSERT INTO bpr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Salngad i ta man-gu, nimò Dwata tluh i dad to lo mdà di kaftoola, ise mdà di kimenla i uldin. ");
INSERT INTO bpr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","I Dwata, lo Dwata i dad Dyu kè? Ise. Lê kenen Dwata i dad ise Dyu, du kenen Dwata i kdee. ");
INSERT INTO bpr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Du lo satu i Dwata di kdee dad to, i baling Dyu ku demen ise Dyu, du nimòan ale tluh mdà di kaftoola ku Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yé kayèmi man kè ta tnagakmi i uldin du ta ftoo gami? Là, bay balingmi too fanbagal. ");
INSERT INTO bpr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Taman, dét i gmanto gablà ku Abraham i gutambulto? ");
INSERT INTO bpr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ku ta tluh Abraham mdà di nimòan, fakay kenen fagdag, bay landè gutadagan fagdag di kanfe Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Du man i Tnalù Dwata, “Ftoo Abraham di Dwata, na mdà di kaftoon, ta man Dwata tluh kenen.” ");
INSERT INTO bpr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Snukéy i to talbahò, bay i sukéy ise ku tadè blé, du ulê i kaflayaman. ");
INSERT INTO bpr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Bay i to là smaligan di nimòan, bay fantoon i Dwata mimò i dad gamsalà tluh, mdà di kaftoon ayé, man Dwata ta tluh kenen. ");
INSERT INTO bpr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Yé gumtatek i man Dabid di ktulenan gablà di klehew galyalo i dad to ta man Dwata tluh ise mdà di balù dét i nimòla, salngad i manan di tmadol ani, ");
INSERT INTO bpr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Too fye nawa i dad to ta lnifet Dwata i kaglafàla, na i dad salàla, ta flanasan. ");
INSERT INTO bpr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Too fye nawa i to ta là fandam Dwata i dad salàan.” ");
INSERT INTO bpr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Lo yé kè gamfun i kafye nawa man Dabid ani i dad to ta fimò ilè di lawehla? Là, bay lê man i dad to landè ilè. Du salngad i man-gu gine mdà di Tnalu Dwata, “Ftoo Abraham di Dwata, na mdà di kaftoon, ta man Dwata tluh kenen.” ");
INSERT INTO bpr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kilen i kgimò Dwata ani di kenen? Di lam Abraham là fimò ilè di lawehan, ku demen di ta kafngen? Dunan, di laman là fimò ilè di lawehan. ");
INSERT INTO bpr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Muna i kaftoon, gfulé i kfimòan ilè. Na i ilè ayé gugmadè dun ta sana tluh kenen di kite Dwata mdà di kaftoon. Taman, Abraham mà i kdee ftoo, balù dad to landè ilè di lawehla. Na fagu di kaftoola, ta mgimò ale tluh di kite Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Na lê kenen mà i dad to ta fimò ilè di lawehla, ise ku yé duenan du mdà di kfimòla ilè, bay du ta ftoo ale salngad di kaftoo Abraham di laman là fa fimò ilè di lawehan. ");
INSERT INTO bpr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Yé fakang Dwata ku Abraham na di dad belan, gfunla i banwe. Ise mdà di kimenan i uldin, bay mdà di kaftoon di Dwata, ta man Dwata tluh kenen. ");
INSERT INTO bpr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Du ku yé gudmohò Dwata i dad fakangan di dad to mimen i uldin, landè gukmamu i kaftoo, na landè btas i fakang. ");
INSERT INTO bpr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kel i kalbut Dwata mdà di uldin, du landè lnafà moon ku landè uldin. ");
INSERT INTO bpr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Taman, yé gufdà mlé i fakang di kaftoo du fye too gadè tadè blé ani di kdee dad bel Abraham, ise ku lo di dad to mimen i uldin, bay lê man di kdee dad to ftoo salngad ku Abraham. Du Abraham mà i kdee dad to ftoo. ");
INSERT INTO bpr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Salngad i man di Tnalù Dwata, “Nimòta ge mà i dee bung to.” Taman, Abraham i màto di kanfe i Dwata fantoon, dunan i Dwata mték dad mati, na mimò i kalbong kdee fagu di talùan. ");
INSERT INTO bpr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ftoo na fatan Abraham balù ta landè fandenan du ta tua. Na fagu déé, mgimò kenen mà i dee dad to salngad man di Tnalù Dwata, “Mdà di ge, mbel i dee dad to salngad i kdee blatik di langit.” ");
INSERT INTO bpr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ta fan mlatuh fali ktua Abraham, bay là magsud i kaftoon balù ta là gaganan fngà i yaanan Sara du ta tua kenen, na Sara, tagnè là mngàan. ");
INSERT INTO bpr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Là magsud i kaftoon, na là lwe nawan dnohò Dwata i fakangan di kenen. Du i kaftoon mlé kenen kgis, taman dnayenan i Dwata, ");
INSERT INTO bpr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","du landè ti kalwe nawan di kdohò Dwata i fakangan. ");
INSERT INTO bpr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Taman, man Dwata tluh Abraham mdà di kaftoon. ");
INSERT INTO bpr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","I talù, “Man Dwata, tluh kenen,” ise ku lo kenen gugtadèan. ");
INSERT INTO bpr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","I sulat ani lê gtadè di gito i ta nimò Dwata tluh du ta fantooto i mték ku Dyisas, i Amuto, mdà di fati. ");
INSERT INTO bpr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Blén Dyisas di fati mdà di dad salàto, na ntékan kenen du fye gimò Dwata ato tluh. ");
INSERT INTO bpr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ani, du ta nimò Dwata ato tluh mdà di kaftooto, ta safye ato i Dwata fagu di Amuto Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Mdà di kaftooto, neben ato di kafye i Dwata i ta gumnèto ani. Taman, lehew ato famden i kgaginto di kdatahan. ");
INSERT INTO bpr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Lê ato too lehew di dad kaflayamto, du gadèto i dad kaflayam, yé tamdò gito fagtayud. ");
INSERT INTO bpr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","I kagtayud gamflehew i Dwata, na i klehewan mlé gito fangden. ");
INSERT INTO bpr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","I fangden ani, là fyàan ato, du ta kok Dwata i kakdon di nawato fagu di kafnèan di gito i Mtiu Tulus, i ta blén di gito. ");
INSERT INTO bpr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Di muna, landè kibòto tmabeng i ktoto, bay kanto kel i bang ta fala nalék, fafati Krayst di dad to gamsalà. ");
INSERT INTO bpr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Matukul i mayè fafati mdà di kakdon i satu to tluh. Keng nun mayè fafati mdà di kakdon i satu to fye balun. ");
INSERT INTO bpr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bay fite Dwata i kalbong nawan gito, du di lamto gamsalà, fafati Krayst di gito. ");
INSERT INTO bpr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Fagu di kfalohan i litèan, ta mgimò ato tluh di kanfe Dwata. Taman, ta tooto gadè galwà ato di kalbut Dwata fagu di kenen. ");
INSERT INTO bpr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Di muna, dnuento i Dwata, bay ani ta nimòan ato i dademen sakdo fagu di kfati i Ngàan. Taman, ta tooto gadè galwà ato fagu di kték Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ise ku lo ayé, bay lê ato flehew du mdà di nimò Dwata fagu ku Dyisas Krayst, dunan i ta samfye gito di Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Yé katbù i salà dini di tah tanà fagu di satu to, na i salàan mebe fati. Na mdà dini, ta gafat i fati di kdee dad to, du ta gamsalà i kdee. ");
INSERT INTO bpr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Tagnè nun salà dini di tah tanà di lam Dwata là mlé i uldin. Bay di laman landè uldin, tadèan bayà i dad salà. ");
INSERT INTO bpr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Bay mdà di du Adan kel di du Mosis, mati i dad to, balù ku là salngad salà nimòla di salà Adan di klafàan i man Dwata di kenen. Na Adan gugaflingen i sanfatanla. ");
INSERT INTO bpr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Bay là salngad ale du là fakayto sansngad i salà Adan na i tadè blé Dwata. Balù dee mati mdà di salà i satu to, bay too bong kafye Dwata na i tadèan blé fagu di kafye Dyisas Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Mahal i ulê tadè blé Dwata, na mahal i ulê salà Adan. I ulê i salà Adan dunan i kaflayam. Bay i ulê i tadè blé Dwata dunan ta lnifetan i dee salà nimò i dad to. ");
INSERT INTO bpr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Na glut sa, gafat i fati di kdee dad to fagu di salà i satu to. Bay too bong ulê i nimò satu To, dunan Dyisas Krayst, du i kdee dmawat i kafye Dwata na ta safye di kenen, fdatahan ale fagu ku Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Taman, mdà di salà i satu to, dunan Adan, maflayam i kdee, na salngad déé, mdà di fye nimò i satu To, dunan Krayst, gamdawat kagalwà na nawa i kdee dad to ftoo. ");
INSERT INTO bpr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na mdà di là kimen i satu to, mgimò gamsalà i kdee dad to. Na salngad déé, mdà di kimen i satu, mgimò tluh i kdee dad to ftoo. ");
INSERT INTO bpr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kanto nun uldin, ta baling midul i kaglafàla, bay ku nè gubong i salà, baling too bong fa i kafye Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Taman, yé gnamit salà mebe gito i fati, bay yé gnamit i kafye Dwata mebe gito i katluh, na neben ato di nawa landè sen fagu ku Dyisas Krayst, i Amuto. ");
INSERT INTO bpr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ku gambet ayé, dét i fakay man? Fadlug ato di kimò salà du fye midul i kafye Dwata? ");
INSERT INTO bpr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Là fakay, du gablà di salà, ta mati ato. Dét kibòto fadlug mnè di salà? ");
INSERT INTO bpr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Du ta gadèyu i kdeeto ta fbunyag di ku Krayst Dyisas, ta lê ato sasatu di kenen di kfatin. ");
INSERT INTO bpr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Di kaglutan, ta mati ato na lbang magin di kenen fagu di kbunyag, du fye ku dét kibò i Mà mték ku Krayst fagu di kaltulusan, salngad ayé i ktékan gito di falami nawa. ");
INSERT INTO bpr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Du ta sasatu ato di kfatin, ta lê ato sasatu di ktékan. ");
INSERT INTO bpr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Na gadèto ta fnatak i labi ktoto magin ku Krayst du fye mati i ungadto fnò salà, na ta là fnasak i salà ato. ");
INSERT INTO bpr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Du ta landè gagan i salà di to ta mati. ");
INSERT INTO bpr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Du ta mati ato magin ku Krayst, fantooto lê ato mto magin kenen. ");
INSERT INTO bpr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Du gadèto Krayst ta nték di fati, na ta là lêan mati, na ta landè gnagan i fati di kenen. ");
INSERT INTO bpr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Lo sulêan mati di salà i kdee, na i lawilan ani, gnamitan flehew i Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Salngad déé, yé fye fandamyu gablà di salà, ta mati gamu, bay di Dwata, mto gamu fagu ku Krayst Dyisas. ");
INSERT INTO bpr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Taman, nangyu faloh i salà mebe i lawehyu nun fati, tàyu gimen sasè knayè i ungadyu. ");
INSERT INTO bpr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Na nangyu lê blé balù dét alel i lawehyu du gnamit di kimò salà. Bay bléyu i ktoyu di Dwata, du fye gnamit di tluh nimò, du ta nték gamu di fati. ");
INSERT INTO bpr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nang gamu fafasak di salà, du ta ise i uldin Mosis mebe gamu, bay i kafye Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ku gambet ayé, dét i fakayto man? Mimò ato salà du ta ise uldin mebe gito, bay i kafye Dwata? Là fakay! ");
INSERT INTO bpr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ta gadèyu sa, ku nè i gufafasakyu, yé amuyu. Ku yé nimenyu i salà, fasak gamu i salà, na yé ulêan fati. Ku yé nimenyu i Dwata, yé ulêan, nimòan gamu tluh. ");
INSERT INTO bpr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bay salamat di Dwata du balù fasak gamu i salà di muna, bay ani, ta nimenyu mdà di nawayu i dad tdò ta dnawatyu. ");
INSERT INTO bpr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ta galwà gamu di kagfasakyu di salà, na ta mgimò gamu dad fasak i katluh. ");
INSERT INTO bpr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Mdà di klungay i ungadyu, gnamitgu btal kastulen i to tanà). Di munan, yé gumléyu i ktoyu di dad magsik na dad sasè nimò. Na fye ku salngad ayé i kabléyu i ktoyu di Dwata du fye mgimò gamu dad fasak i tluh nimò na i mtiu knayè Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Di tlabo gamu fasak i salà, ise gamu fasak i katluh. ");
INSERT INTO bpr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Nun kè fye gaktuyu mdà di sasè nimòyu di muna i ta kyàyu ani? Landèan, lo fati. ");
INSERT INTO bpr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Bay ani, ta galwà gamu mdà di kagfasakyu di salà, na ta fafasak gamu di Dwata. Na yé balas gdawatyu dunan i ktiu, na yé ulêan nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Du i ulê i kimò salà dunan i fati, bay i tadè blé Dwata dunan nawa landè sen fagu di ku Krayst Dyisas, i Amuto. ");
INSERT INTO bpr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Dad flanekgu ftoo, di ktoon ta gadèyu i fan-gu man, du ta gadèyu i uldin. Yé klo i uldin mebe dad to di klola mto. ");
INSERT INTO bpr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kaflingenta dun, i libun nun yaan, man i uldin mnè kenen di lam falel i yaanan di laman mto. Bay ku ta mati i yaanan, ta galwà kenen di uldin gablà di kaswè yaan. ");
INSERT INTO bpr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Taman, ku magin kenen di mahal lagi di laman fa mto i yaanan, yé katlo dun lmafà. Bay ku ta mati i yaanan, galwà kenen, na là lmafàan balù ku nun mahal lagi i mwè dun yaan. ");
INSERT INTO bpr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Salngad ayé i gamu kagkah, dad flanekgu. Gablà di uldin, ta mati gamu du glam gamu di laweh Krayst, na ta kenen mfun gamu, dunan i ta mték mdà di fati du fye nun gukmamu Dwata gito. ");
INSERT INTO bpr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Du di lamto lmalò i nimò knalam i ungadto, mdà di kgadèto i uldin, baling midul i ayèto mimò sasè. Na yé gugafatto di fati. ");
INSERT INTO bpr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Bay ani, ta galwà ato di uldin du ta là magfasak ato déé. Ta ise labi uldin i lalòto, bay i falami kto blé i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ku gambet ayé, dét i fakayto man? Sasè kè i uldin? Là. Balù do, ku ise mdà di uldin, là dilègu i salà. Ku là man i uldin, “Nang ge mibal,” là gadègu moon ku sasè i mibal. ");
INSERT INTO bpr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Fagu di uldin, ta tlana i salà mukat i sahal kibal di ktogu. Yé mlé lawil di salà i uldin. ");
INSERT INTO bpr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Do di muna, di lamgu là gmadè i uldin, di fandamgu, mto agu. Bay kanto kel i uldin, ta msut i salà, na ta gadègu mati agu. ");
INSERT INTO bpr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Yé gukmamu i uldin moon mlé nawa, bay balingan agu nebe di fati. ");
INSERT INTO bpr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Du i salà, lnimbungan agu fagu di uldin, na lê fagu di uldin, fnatin agu. ");
INSERT INTO bpr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Mtiu i uldin, na i dek i uldin lê mtiu, tluh, na fye. ");
INSERT INTO bpr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yé kè knayèan man ayé, yé mebe do di fati i fye? Là. Bay gnamit salà i fye mebe fati di do du fye too gadè i glut adat i salà. Taman, fagu di dad dek i uldin, ta too teen ksasè i salà. ");
INSERT INTO bpr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ta gadèto i uldin, mdà di Dwata, na too fye. Bay do, lo agu btal to fasak di salà. ");
INSERT INTO bpr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Là glabatgu i ktogu, du là nimògu i knayègu nimò. Baling yé nimògu i kdee là knayègu. ");
INSERT INTO bpr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Taman, ku knanggu i sasè nimògu ani, yé gumite dun na i kafaldamgu tluh i uldin. ");
INSERT INTO bpr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Taman, ise ku do i mimò ani, bay i salà mnè di do. ");
INSERT INTO bpr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Gadègu landè fye dini di do, dunan di labi ktogu, du balù nun ayègu mimò fye, là gagan-gu mimò dun. ");
INSERT INTO bpr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Là sa gimògu i fye kayègu nimò. Yé ta balinggu gimò i sasè là knayègu nimò. ");
INSERT INTO bpr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ku nimògu i là knayègu nimò, yé kayègu man, ise ku do mimò dun, bay i salà mnè di do. ");
INSERT INTO bpr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Taman, teen-gu satu gulmalò i ktogu. Ku mayè agu mimò fye, faglad i sasè, na yé balinggu gimò i là knayègu. ");
INSERT INTO bpr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mdà di lam i nawagu, too agu mayè di uldin Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Bay lê dini di do i satu magot, i samfati knayègu, na yé fmasak do di kgis i salà di lam i lawehgu. ");
INSERT INTO bpr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Too agu magakdo! Simto falwà do di lawehgu ani i mebe do di fati. ");
INSERT INTO bpr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Salamat di Dwata du kenen i falwà do fagu di Amuto Dyisas Krayst. Taman, ani kagkahgu: Dini di fandamgu, nimen-gu i Dwata, bay i lawehgu, nimenan i salà. ");
INSERT INTO bpr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Taman, ta landè flayam i dad to ta sasatu di ku Krayst Dyisas. ");
INSERT INTO bpr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Du i kagot i Mtiu Tulus, yé mlé gito nawa fagu di ksasatuto ku Krayst Dyisas, na ta lêan agu falwà di kagot i salà na fati. ");
INSERT INTO bpr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","I là gimò i uldin du mdà di klungay i to tanà, yé nimò Dwata. Nukuman i salàto fagu di kdekan i Ngàan salu dini du fbaling to tanà du fye gafalmon i salà. ");
INSERT INTO bpr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nimò Dwata ayé du fye gablé i fni i uldin dini di gito i lmalò di knayè i Mtiu Tulus, ise knayè i labi ktoto. ");
INSERT INTO bpr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Nè to lmalò di knayè i labi kton, lo yé fandaman i kdee knayè i labi kton. Bay nè to lmalò di knayè i Mtiu Tulus, lo yé fandaman knayè i Mtiu Tulus. ");
INSERT INTO bpr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","I to, lo yé fandaman i knayè i labi kton, yé gugafatan i fati. Bay i to, lo yé fandaman i knayè Dwata, yé gugafatan nun nawan na nun ktanakan. ");
INSERT INTO bpr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Taman, i to, ku lo yé fandaman i knayè i labi kton, knangan i Dwata, du là nimenan i uldin Dwata, na too ti landè kibòan mimen dun. ");
INSERT INTO bpr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","I to lmalò di knayè i labi kton, là gaflehewan i Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Bay ta là lmalò gamu di knayè i labi ktoyu du ta yé lalòyu i Mtiu Tulus, ku glut ta déé i Tulus Dwata di gamu. Na i to là mnè di kenen i Tulus Krayst, ise kenen nfun Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Bay ku mnè Krayst di gamu, balù ta mati i lawehyu ulê i salà, bay mto i layefyu du ta nimò Dwata gamu tluh. ");
INSERT INTO bpr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ku i Tulus Dwata ta mték ku Dyisas Krayst ta mnè di gamu, i Dwata ayé lê mlé nawa di dad lawehyu fagu di Mtiu Tulus i mnè di gamu. ");
INSERT INTO bpr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Taman, ta landè ktooto lmalò i labi ktoto du ta nsò Dwata ato. ");
INSERT INTO bpr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Du ku yé lalòyu i labi ktoyu, yé gukelyu di fati. Bay ku fnatiyu i dad sasè nimò ungadyu fagu di Mtiu Tulus, yé gukelyu di nawa landè sen. ");
INSERT INTO bpr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","I kdee nalak i Tulus Dwata, yé i dad ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Du i Tulus blé Dwata di gamu, là nimòan gamu fasak mgikat di klikò, bay nimòan gamu dad ngà Dwata. Na mdà dini, ta fakayto mni tabeng di Dwata di kmanto dun, “E Mà.” ");
INSERT INTO bpr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","I Tulus ayé sasatu di nawato du fgadèan ta dad ngà Dwata ato. ");
INSERT INTO bpr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Du ta ngà Dwata ato, taman gfunto i kdee kafye tagàan di dad ton, na lêto gfun i tagàan di ku Krayst, du ku gagin ato di dad kaflayam Krayst, lê ato gagin di kdatahan. ");
INSERT INTO bpr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Di fandamgu, i kdee kaflayam gnaguto di nawan ani, là gwèan i bong kdatah fite di gito kadang. ");
INSERT INTO bpr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","I kdee nimò i Dwata, too minit nawala fatan i du Dwata fite i dad ngàan, ");
INSERT INTO bpr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","du i kdee nimò Dwata, ta gakuf di kalmo, ise ku mdà di dale knayè, bay mdà di knayè Dwata. Bay balù ku yé kagkahla, nun fandenla, ");
INSERT INTO bpr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kel i du, falwàan i kdee ta nimòan di kagfasakla di kalmo, na gakuf ale di bong kafye gdawat i dad ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Na gadèto i kdee dad nimò Dwata, dmalong di katduk salngad i libun fan sut ngàan. ");
INSERT INTO bpr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Na ise ku lo i dad nimò Dwata ayé i dmalong, bay lê man gito i ta gamdawat i Tulusan, dunan i ta funa blé Dwata gito, du too ato dmalong lamto fatan i ksikof i kafalwàan gito, na i kfalamin i lawehto. ");
INSERT INTO bpr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Du galwà ato mdà di knun fandento. Bay ku ta sanato teen i fandento, ta là tlo dun fanden, du ta teen. ");
INSERT INTO bpr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bay ku fandento i là fa teento, fantahàto nawato fatan dun. ");
INSERT INTO bpr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Salngad ayé i kibò Mtiu Tulus tmabeng gito di klungayto. Du là gadèto ku dét i gtento fni, taman i Mtiu Tulus tmabeng gito mni di Dwata magin dingasan, na gnamitan i dad talù là gaganto man. ");
INSERT INTO bpr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Na gadè Dwata i mnè di nawato, na gadèan ku dét fandam i Mtiu Tulus du dnasal Tulus i dad ton di Dwata lmalò di knayèan. ");
INSERT INTO bpr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Gadèto i kdee gnaguto gnamit Dwata du gamfye di gito i kambong dun nawa, dunan i kdee ta tlo mdà di knayèan. ");
INSERT INTO bpr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","I dad to ta falan nalék, ta lêan tanfing du fye salngad ale di Ngàan du fye i Ngàan mgimò i too twege di kdeela saflanek. ");
INSERT INTO bpr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Taman, tlo Dwata i dad to ta falan tanfing. Ise ku lon ale tlo, bay lêan ale nimò tluh, na faginan ale di kdatahan. ");
INSERT INTO bpr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Du ta gadèto i kdee ayé, dét i gmanto? Du Dwata i msen gito, simto i gmagan falmo gito? ");
INSERT INTO bpr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Du là klen Dwata i Ngàan, bay balingan blé di fati mdà di kdeeto, baling yé klenan kè di gito i kdee fnito? ");
INSERT INTO bpr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Simto i gamlas tmifù i dad to ta nalék Dwata? Dwata man dun landè salàla. ");
INSERT INTO bpr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Taman, simto i mukum na falmayam dale? Ise ku Krayst Dyisas, du kenen i fafati, na nték, na ditù kenen gsen di kwanan Dwata du mni di Dwata gablà di gito. ");
INSERT INTO bpr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Dét gmagan samkah gito di kalbong nawa Krayst gito? Ksamuk kè, ku demen klimah, ku kaflayam, ku kbitil, ku klandè, ku klikò, ku kfati? ");
INSERT INTO bpr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Salngad ayé i man di Tnalù Dwata, “Du mdà di ksasatumi di ge, fanla gami fnati tnadak du. Yé kibòla gami, salngad dad bilibili fanla tnatê.” ");
INSERT INTO bpr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Knèan, di lamto gmagu i kdee ani, nun sikof katuto fagu di kambong gito nawa. ");
INSERT INTO bpr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Du toogu gadè landè balù dét samkah gito di kakdon, balù i fati, demen i lawil, demen dad kasaligan Dwata, demen i dad busaw, demen i kdee di mdu ani, na i dad mkel di fulé du. ");
INSERT INTO bpr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Na balù di tah kmawang, ku demen di lam i tanà, landè balù dét di kdee nimò Dwata i gmagan samkah gito di kakdo Dwata ta gfunto fagu ku Krayst Dyisas, i Amuto. ");
INSERT INTO bpr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Krayst ta mfun do, taman glut i man-gu. Là tmulen agu kéng. I fandamgu tnuyal i Mtiu Tulus, na yé fgadè i là ktulen-gu kéng. ");
INSERT INTO bpr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Too sè klidùgu na malbà nawagu, ");
INSERT INTO bpr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","du mdà di dad flanekgu, dunan i dad Dyu. Yé fandamgu baling fye ku do i falnayam Dwata, na sankahan agu mdà ku Krayst, syan galwà ale dale. ");
INSERT INTO bpr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Dale i bel Israél. Ta tnabò Dwata ale, ta fiten i kdatahan di dale, na ta mimò kenen kasafnè magin dale, na ta blén dale i uldin. Dale gutamdòan i glut kfagu mangamfù di kenen, na ta gdawatla i dad fakangan. ");
INSERT INTO bpr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Dale dad bel Abraham na i dademe gutambulla, na mdà di dad bella, sut Krayst, i Dwata magot kalbong kdee na magdayen kel di landè sen. Amén. ");
INSERT INTO bpr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ise yé man-gu ku là gdohò i fakang Dwata du là ti kdee bel Israél ngà Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Na ise ayé man-gu ku kdee bel Abraham i dad ngà Dwata. Bay yé man Dwata di ku Abraham, “Lo dad bel Isaak i dnilègu belam.” ");
INSERT INTO bpr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yé gumtatekan i dad to sut di tagnè kagkah i to tanà, ise i dad ngà Dwata. Bay i dad sut mdà di fakang Dwata, dale dnilè dad glut bel. ");
INSERT INTO bpr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Du i fakang Dwata, dunan ani: “Ku ta ftoh i butang, samfulê agu, na mngà Sara lagi.” ");
INSERT INTO bpr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Na ise ku lo ayé, bay too midul i kbatengan di ksut i lwe ngà ale Rébéka na Isaak, i gutambulto. ");
INSERT INTO bpr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Di là fa sut i dad ngà ayé, na taman là fa gamgimò ale fye demen sasè du gdohò i knayè Dwata di kalékan dad to. Ise mdà di nimò, bay mdà di katlo Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Ta manan di ku Rébéka, “I twege talbahò di twalin.” ");
INSERT INTO bpr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Man i Tnalù Dwata, “Bong nawagu ku Dyékob, tukay nawagu ku Isaw.” ");
INSERT INTO bpr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Fakayto man kè là tluh Dwata du nun nungulan? Là. ");
INSERT INTO bpr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Du ani man Dwata di ku Mosis, “Kandogu i knayègu kando, na kanbonggu nawa i knayègu kanbong nawa.” ");
INSERT INTO bpr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Taman, i kalék Dwata, là fdàan dun di knayè ku demen di nimò i dad to, bay fdàan di kakdon. ");
INSERT INTO bpr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Du man i Tnalù Dwata di harì di Idyip, “Ta nimòta ge harì du fye fitegu i kaltulusgu fagu di ge, na fye fdilègu i dagitgu di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Taman, kando Dwata i knayèan kando, na fagéngan i knayèan fagéng. ");
INSERT INTO bpr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Keng nun tmimel i man-gu ayé gine, manan, “Kan ku dnuen Dwata i dad to? Nun kè to gamsang di knayè Dwata nimò?” ");
INSERT INTO bpr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Simto ge kè smumal di Dwata? Lo ge to. I kulang tanà, là fakayan man di to mifil dun, “Kan ku ani kibòam do?” ");
INSERT INTO bpr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","I to mifil kulang, nun ktoon tamngà i tanà nifilan, i satu too mabtas, na i satu, là. ");
INSERT INTO bpr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Na salngad ayé i nimò Dwata. Yé kayèan, fiten i kalbutan, na fdilèan i kaltulusan di dad to gten falnayam, bay flon fantahà i nawan di dale. ");
INSERT INTO bpr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Kayèan lê fite i kdatahan ta kokan di gito dad kandon, dunan i dad to fatlagadan dmawat i kdatahan. ");
INSERT INTO bpr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Gito i dad to ta tlon, ise ku lo mdà di dad Dyu, bay lê man mdà di dad ise Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ani manan di libru Hosiya, “Dnilègu dad togu i ise dad togu di muna, na lêgu kanbong nawa i dad to là kanbonggu nawa di muna. ");
INSERT INTO bpr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na i dad to di banwe gumanan dun dale, ‘Ise dad tota gamu,’ bay ani, ta tlo ale dad ngà i mto Dwata.” ");
INSERT INTO bpr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ani lê fgadè Isaya gablà di dad bel Israél, manan, “Balù ku yé kdee dad bel Israél salngad falak di kilil mahin, bay là dee i galwà. ");
INSERT INTO bpr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Too mlal gdohò i kablé Dwata i ukuman di klamang banwe.” ");
INSERT INTO bpr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Too gdohò i fala man Isaya, “I Amu too maltulus, ku sandulêan falmo i dad belto, ta salngad ato moon di Sodom na Gomora.” ");
INSERT INTO bpr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Taman, ani i fakayto man. I dad to ise Dyu là fakgis mngabal i katluh di kanfe Dwata, baling gamdawat fagu di kaftoo. ");
INSERT INTO bpr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Bay i dad Dyu fakgis du fye mgimò ale tluh fagu di kimen i uldin, baling dale là gamdawat katluh. ");
INSERT INTO bpr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kan? Du i kafakgisla, là fdàla dun di kaftoo, bay di fye nimò. Gsungkul ale di batu, ");
INSERT INTO bpr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","du yé man di Tnalù Dwata, “Kahgu di Sayun i satu batu gugsungkul i dad to, i batu gafaglakob dale. Bay i ftoo di kenen, là gsalan.” ");
INSERT INTO bpr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","E dad flanekgu, yé too kayè i nawagu galwà i dademegu Dyu, na fakgisgu ale dnasal di Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Balù do, gadègu too ale mayè lmalò di Dwata, bay i klalòla, là fdàla dun di too glut tdò. ");
INSERT INTO bpr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Là gadèla i kfagu Dwata mimò dad to tluh. Yé balingla gnamit i dale kfagu. Taman, là lmalò ale di kfagu Dwata mimò dad to tluh. ");
INSERT INTO bpr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Du Krayst ta dmohò i uldin du fye i kdee ftoo, mgimò tluh di kanfe Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ani i sulat Mosis gablà di dad to mayè mgimò tluh fagu di kimenla i uldin, “Nè to mimen man i uldin, klonto lmalò dun.” ");
INSERT INTO bpr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Bay ani man i Tnalù Dwata gablà di dad to mgimò tluh fagu di kaftoo, “Nang man nawam, simto i myak di langit du fye neben Krayst tufa?” ");
INSERT INTO bpr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Na nang man nawam, simto i tufa di Hadis du fye ntékan Krayst mdà di fati?” ");
INSERT INTO bpr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Bay ani i manan, “Mdadong di ge i Tnalù Dwata du déé di salékam na di nawam.” Yé kayèan man, i Tnalù tdòmi gablà di kaftoo. ");
INSERT INTO bpr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Galwà ge ku tulenam Dyisas i Amu, na fantoom mdà di nawam ta nték Dwata kenen di fati. ");
INSERT INTO bpr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Du mdà di nawato i kaftooto, na yé ulêan ta tluh ato di kanfe Dwata na ta galwà ato du tulento i fantooto. ");
INSERT INTO bpr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Du yé man di Tnalù Dwata, “I ftoo di kenen, là gsalan.” ");
INSERT INTO bpr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","I kdee glam dini, du landè gusahal i dad Dyu na i dad ise Dyu. Du i Dwata, Amu i kdee, kenen mlé kafye di kdee tamlo di kenen. ");
INSERT INTO bpr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Du ani man di Tnalù i Dwata, “I kdee tamlo di dagit i Amu, galwà ale.” ");
INSERT INTO bpr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bay dét kibòla tamlo di kenen ku là ftoo ale? Na dét kibòla ftoo ku là lingela i Tnalù Dwata? Na dét kibòla lminge ku landè tamdò dun di dale? ");
INSERT INTO bpr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na dét kibò katdò i Tnalù Dwata ku landè mdek to tamdò? Man i Tnalù Dwata, “Too fye mite i dad to tamdò i Fye Tulen.” ");
INSERT INTO bpr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Bay nun là dmawat i Fye Tulen, salngad i man Isaya, “Simto ftoo di tdòmi?” ");
INSERT INTO bpr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Taman, yé gumdà i kaftoo di kaflinge i Fye Tulen fagu di katdò gablà ku Krayst. ");
INSERT INTO bpr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Bay nun snalekgu. Glut kè, là lingela i tdò? Yé man i Tnalù Dwata ta lingela, “Ta gafat di klamang banwe i talùla, na i tdòla.” ");
INSERT INTO bpr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ani lêgu snalek. Là kè galmabat i dad to Israél? Tmimel Mosis fagu di Tnalù Dwata, manan, “Gnamitgu dad to là fakay matlo satu banwe du fye mafè nawayu dale, na fagu di kakdogu i dad to landè gnadè, nimògu i kalbutyu dale.” ");
INSERT INTO bpr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Na là likò Isaya tmulen i man Dwata ani, “I dad to là mngabal do, ta teenla agu. Ta fite agu di dad to là smalek gablà di do.” ");
INSERT INTO bpr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Bay ani man Isaya fagu di Tnalù Dwata gablà di dad bel Israél, “Kat du, sigigu mni di dad to là mimen na magéng ulu fye fdadong ale di do.” ");
INSERT INTO bpr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Taman, lêgu snalek. Ta knang Dwata kè i dad Dyu? Là! Balù do, to Israél agu, na satu bel Abraham, na tubad Bénhamin. ");
INSERT INTO bpr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Là ti knang Dwata i dad to ta nalékan mdà di kagatbùan. Gadèyu i man di Tnalù Dwata gablà di ku Ilaydya di ktulenan di Dwata i sasè nimò dad to Israél. ");
INSERT INTO bpr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Man Ilaydya, “E Amu, ta fnatila i dad tugadam na ta lanbàla i dad gudamsù di ge. Ta lo do i tagak, na kayèla agu fnati.” ");
INSERT INTO bpr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Na dét i timel Dwata di kenen? “Ta nun fitu libu dad lagi nahalgu i là mangamfù ku Baal, i ise glut dwata.” ");
INSERT INTO bpr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Na lê salngad ayé i mkel di mdu ani. Nun, là dee, i nalék Dwata mdà di kakdon. ");
INSERT INTO bpr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Yé gufdà Dwata i kalékan dale mdà di kakdon, ise di nimòla. Du ku yé gufdàan dun di nimòla, ise untù kakdo. ");
INSERT INTO bpr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Taman, dét i fakayto man? Là kdee dad to Israél mite i fanngaballa, bay lo tukay i ta nalék Dwata. I dademe, là falningela i katlo Dwata. ");
INSERT INTO bpr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Salngad i man di Tnalù Dwata, “Fkifuh Dwata i fandamla, na kel di mdu ani, là mite ale, na là lminge ale.” ");
INSERT INTO bpr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Na man Dabid, “Magliman ale moon di kdee kanbayan i nawala. Glakob ale moon, na falnayam. ");
INSERT INTO bpr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Butè ale moon du fye là mite ale, na mbaling ale bukug kel di landè sen.” ");
INSERT INTO bpr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Lê nun snalekgu. Di kaglakob i dad Dyu, ta malmo ale kè? Là! Mdà di kafagsalàla, baling yé gamdawat kagalwà i dad ise Dyu, du fye mafè nawa dad Dyu dale. ");
INSERT INTO bpr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ku mdà di kagsalà i dad Dyu, gamdawat kafye i dad to di klamang banwe, na i kgawagla di Dwata gamlé kafye di dad ise Dyu, midul déé i kafye gdawatla ku ta sikof kasfulê i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ani man-gu di gamu dad ise Dyu. Fasalamat agu di Dwata du dekan agu tamdò di gamu, ");
INSERT INTO bpr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","du fye mafè nawa i dademegu Dyu, na nun di dale mgebegu di kagalwà. ");
INSERT INTO bpr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Du ku fagu di knang Dwata dale, yé gumdà dad ise Dyu safye di Dwata, dét kè i ulêan ku ta dnawatan ale? Salngad ku ta banlén lawil i dad to ta mati. ");
INSERT INTO bpr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ku mtiu i tnanin tiles fan dsù di Dwata, lê mtiu sa i kalbongan. Na ku mtiu i dad dalil i kayu, lê mtiu sa i dad fangan. ");
INSERT INTO bpr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ta kanlang i dademe dad fanga mdà di olib ta fele, na tugad dini i fanga mdà di kayu tadè tmabò. Gamu dad ise Dyu, salngad ayé kagkahyu, du ta gdawatyu i kafye gfun i dad Dyu. ");
INSERT INTO bpr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Taman, nangyu nadoy i dad fanga ta kanlang. Kan ku fagdag gamu? Lo gamu fanga. Ise gamu mlé lawil di dalil, bay i dalil i lmawil gamu. ");
INSERT INTO bpr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Bay keng manam, “Hee, bay ta kanlang i dad fanga ayé du fye nun gugagotgu.” ");
INSERT INTO bpr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Too ayé, kanlang Dwata ale du là ftoo ale, bay gamu, sana kdééyu mdà di kaftooyu. Taman, nang gamu fdatah. Gten ku likò gamu. ");
INSERT INTO bpr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ku là knabas Dwata i dad tagnè fanga, baling ge kè i knabasan? ");
INSERT INTO bpr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Dini gumiteto dun i kakdo Dwata na i klabèan. Flabè kenen di dad to kanlangan ayé, bay kandon gamu ku fles gamu mnè di kakdon. Na ku là, lêan gamu kanlang. ");
INSERT INTO bpr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na ku ftoo dad Dyu, lêan ale tugad samfulê di gumdàla, du i Dwata, gaganan mimò ani. ");
INSERT INTO bpr_vpl VALUES ("