﻿USE sofia;
DROP TABLE IF EXISTS sofia.boxNT_vpl;
CREATE TABLE boxNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES boxNT_vpl WRITE;
INSERT INTO boxNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","O Yeesu *Krista nɔnkãni lé dìo kà: O Yeesu Krista nɔnkãni can o *Daviide yi, ó o Daviide nɔnkãni ɓɛ̀n can o *Abarahaamu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ó o Abarahaamu lé o *Izaaki ɓàn maá. Ó o Izaaki za lé o *Zakoobu, ó o Zakoobu za lé o *Zudaa lè mín zàwa, ");
INSERT INTO boxNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ó o Zudaa zàwa na ó o yú là a Tamaare lé o Farɛɛsi là a Zeraa, ó o Farɛɛsi za lé o Hɛsiron, ó o Hɛsiron za lé o Araamu, ");
INSERT INTO boxNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ó o Araamu za lé o Aminadaabu, ó o Aminadaabu za lé o Naasɔ̃n, ó o Naasɔ̃n za lé o Salamɔn, ");
INSERT INTO boxNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ó o Salamɔn za lé o Buaze na ó o yú là a Arahaabu, ó o Buaze za lé o Obɛɛde na ó o yú là a Uruute, ó o Obɛɛde za lé o Zesee, ");
INSERT INTO boxNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ó o Zesee za lé o bɛ́ɛ Daviide. Ó o bɛ́ɛ Daviide za lé o *Salomɔn na ó o yú là a Uuri ɓàn hã́a, ");
INSERT INTO boxNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ó o Salomɔn za lé o Orobuamu, ó o Orobuamu za lé o Abia, ó o Abia za lé o Azaafe, ");
INSERT INTO boxNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ó o Azaafe za lé o Zozafaa, ó o Zozafaa za lé o Zoraamu, ó o Zoraamu za lé o Oziasi, ");
INSERT INTO boxNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ó o Oziasi za lé o Zuataamu, ó o Zuataamu za lé o Akazaa, ó o Akazaa za lé o Ezekiasi, ");
INSERT INTO boxNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ó o Ezekiasi za lé o Manasee, ó o Manasee za lé o Amɔɔsi, ó o Amɔɔsi za lé o Zoziasi, ");
INSERT INTO boxNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ó o Zoziasi za lé o Zekonia lè mín zàwa. Bṹn wó ká a *Isirayɛɛle nìpomu á ho *Babiloonasa kĩ̀kã́a yi á ɓa vaá wee kàyá ɓa kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bìo ɓa wi ho Babiloona yi mu kàyámu yi ó o Zekonia ton o Salasiɛle, ó o Salasiɛle za ɓɛ̀n lé o Zorobabɛɛle, ");
INSERT INTO boxNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ó o Zorobabɛɛle za lé o Abiyuude, ó o Abiyuude za lé o Eliakiimu, ó o Eliakiimu za lé o Azoore, ");
INSERT INTO boxNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ó o Azoore za lé o Sadooki, ó o Sadooki za lé o Akiimu, ó o Akiimu za lé o Eliyuude, ");
INSERT INTO boxNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ó o Eliyuude za lé o Eliazaare, ó o Eliazaare za lé o Matan, ó o Matan za lé o Zakoobu, ");
INSERT INTO boxNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ó o *Zakoobu za lé o Zozɛɛfu, o Mari ɓàn báa. O Mari mu lé wón ton o Yeesu na ɓa le *Krista. ");
INSERT INTO boxNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Á wã́a lá a *Abarahaamu ɲii wán à ɓuee ɓúe o *Daviide yi, á ɓa maáwà na sã̀ mín á yú ho pírú náa. Ó o Daviide ɲii à ɓuee ɓúe ho pã̀ahṹ na ó o *Isirayɛɛle nìpomu á ho Babiloonasa kĩ̀kã́a yi á ɓa vaá wee kàyá ɓa kɔ̃hṹ yi, á maáwà na sã̀ mín á yú ho pírú náa. À ɓɛ̀n lá bìo ɓa wi mu kàyámu yi ɲii wán à ɓuee ɓúe o Krista yi, á maáwà na sã̀ mín á mún yú ho pírú náa. ");
INSERT INTO boxNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bìo kà lé bìo ó o Yeesu bìo wóráa á vaá ɓó a teró yi. Ɓàn nu Mari fũaamu hĩ́a bò nɔn o Zozɛɛfu yi. Ká sã́ni ɓa ya mín, à bṹn ò o sù lè sãní lè le Dónbeenì Hácírí pànká. ");
INSERT INTO boxNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ɓàn fũaalè Zozɛɛfu fù lée nùpue na térénna. O fù yí wi ò o dé nìyio mín fũaalè Mari yi, ó o wi ò o sànka ɓúe mu fũaamu. ");
INSERT INTO boxNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bìo mu wi o sĩi yi kà, ó o Ɲúhṹso Dónbeenì wáayi tonkaro bía làa wo hã kònkórá yi: «*Daviide mɔ̀nmàníi Zozɛɛfu, yí hézɔ̃́n o Mari fé yaró. Le sãní na wi o wán kà ó o sù lè le Dónbeenì Hácírí pànká. ");
INSERT INTO boxNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O ò te o za báa. Fo ò cé o yèni làa Yeesu. Orɛ́n lé yìa á à kã̀ní mín nìpomu mí bè-kora yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mu ɓúenɓúen wó bèra a na à bìo ó o Ɲúhṹso bía lè mí ɲi-cúa fɛɛro ɲii à yìo lé. ");
INSERT INTO boxNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","O bía: «Yìa yí zũ báa á à sì le sãní á à te o za, á ɓa wé è ve làa Emanuwɛɛle. Bṹn kúará le: ‹Le Dónbeenì wi làa wɛn›.» ");
INSERT INTO boxNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bìo ó o Zozɛɛfu sĩ̀na, ó o wó bìo le Dónbeenì wáayi tonkaro le o wé. O fó a Mari á yan. ");
INSERT INTO boxNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ká a Zozɛɛfu màhã́ yí wó a làa hã́a yí mɔn fúaa bìo ó o ton mí za, ó o Zozɛɛfu mu có a yèni làa Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O Yeesu hĩ́a ton ho *Zudee kɔ̃hṹ lóhó na ɓa le Betelehɛɛmu yi. Mu pã̀ahṹ ká a *Heroode lé o bɛ́ɛ. O Yeesu mu teró mɔ́ndɛ́n, á ɓa nùpua ɓúi na kàránna zũ mu bìo á zũ hã mànàayio lè mí kúaráwa, á ló lè le wii hɛ̀ɛníi ɓueé dɔ̃n ho Zeruzalɛɛmu lóhó, ");
INSERT INTO boxNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","á ɓa tùara: «Ɓa *zúifùwa bɛ́ɛ na ton á wi wen? Le mànàayiire ɓúi hà lè le wii hɛ̀ɛníi, á zéenía a bìo, á wa ló ɓuara wà ɓueé ɓùaaní a.» ");
INSERT INTO boxNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bìo ó o bɛ́ɛ Heroode ɲá mu, ó orɛ́n lè ho Zeruzalɛɛmusa ɓúenɓúen yilera lùnkaa. ");
INSERT INTO boxNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ó o von le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa ɓúenɓúen na wi o nìpomu yi á kúaa mín wán. Ò o tùara ɓa yi làa hen na ó o kã̀nílo á ko ò o te yi. ");
INSERT INTO boxNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Á ɓa bía nɔn wo yi: «O ko ò o te ho Zudee kɔ̃hṹ lóhó na ɓa le Betelehɛɛmu yi. Lé bìo á bìo kà lé bìo á le *Dónbeenì ɲi-cúa fɛɛro túara: ");
INSERT INTO boxNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Betelehɛɛmu, fo yínɔń ho *Zudaa kɔ̃hṹ lórá ɓúenɓúen ɓàn ló-za. Lé fo ó o Ɲúhṹso na à dí ũ nìpomu *Isirayɛɛle yahó á à lé yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ó o *Heroode wã́a sànkaa von ɓa bè-zũńlowà mu, ò o tùara ɓa yi á zũńnanáa ho pã̀ahṹ binbirì na ɓa mɔn le mànàayiire yi. ");
INSERT INTO boxNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bṹn mɔ́n ó o le ɓa lɛ́n va ho Betelehɛɛmu, ò o bía nɔn ɓa yi: «Mi va a tùaka o háyónza mu bìo sese. Ká mi yú a mɔn, à mi bĩní ɓuee bío mu na miì, á ĩnɛ́n mún vaá ɓùaaní a.» ");
INSERT INTO boxNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bìo ɓa ɲá hɔ̃́n bíoní so o bɛ́ɛ mu cɔ̃́n vó, á ɓa wà. Á ɓa bĩnía wee mi le mànàayiire na ɓa nɔ̀nzoǹ mɔn lè le wii hɛ̀ɛníi, à le wà á ɓa bò yi. Pã̀ahṹ na le vaá dɔ̃n ho lahó na ó o háyónza mu wi yi, á le dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bìo ɓa mɔn le mànàayiire kà síi, á mu wó sĩ-wɛɛ ɓa cɔ̃́n làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Á ɓa yòó zon le zĩi yi, á zoó mɔn o háyónza mu lè mín nu Mari. Á ɓa lií fárá mí nɔnkóɲúná wán à ɓa ɓùaanía a háyónza. Bṹn mɔ́n á ɓa feera mí sĩ̀a à ɓa hɔ̃n wo lè ho sã́nú lè mu bìowa ɓúi na sãmu sĩ, ho *ã́nsã́n lè ho *míìrè. ");
INSERT INTO boxNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bṹn mɔ́n le Dónbeenì ɲà ɓa zeǹ wán hã kònkórá yi le ɓa yí bĩní yí vaa lé o Heroode wán. Á ɓa wã́a lá wã-veere á vannáa mín kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ɓa bè-zũńlowà lɛ́nló mɔ́n, á le Dónbeenì wáayi tonkaro ɓúi ɓuara a Zozɛɛfu cɔ̃́n hã kònkórá yi, á bía nɔn wo yi: «Hĩ́ní fé o háyónza lè mín nu à ũ lùwí va ho *Ezipite kɔ̃hṹ. Va a kɛɛní bĩ́n fúuu fúaa ká ĩ khíi le ũ bĩní ɓuen. Lé bìo ó o bɛ́ɛ *Heroode á à bío le ɓa cànka a háyónza mu ɓúe.» ");
INSERT INTO boxNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ó o Zozɛɛfu wã́a hĩ́nɔn ho tĩ́nàahṹ á fó a háyónza lè mín nu ò o ɲɔn ho Ezipite kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","21","Ká a Heroode zũna le ɓa bè-zũńlowà khà a, ó o sĩi cã̀ làa sòobɛ́ɛ. Ó o nɔn le ɲii le ɓa ɓúe ɓa zà-báawa ɓúenɓúen na ho Betelehɛɛmu lóhó yi, làa hĩ̀a bã́makaa ho yi. À wã́a lá bìa lúlúio yú hã bìo ɲun ɲii à liiráa, à héha lè ho pã̀ahṹ na ɓa bè-zũńlowà zéenía le mí mɔn le mànàayiire yi. Bṹn lé bìo á le *Dónbeenì ɲi-cúa fɛɛro Zeremii bìo na ó o bía á wóráa ɲii sú. O bía: «Wãamakaa ɓúi sã ɲá ho Aramaa lóhó yi. Mu wó lè minka wɛ́ɛ. Lé o Arasɛɛle wee wá mí zàwa bìo yi. O yí tà le ɓa yanka mí lé bìo ɓa ɲúhṹ ɓó.» O Zozɛɛfu là a háyónza lè mín nu kará ho Ezipite yi fúuu fúaa bìo ó o Heroode húrun. O *Heroode húmú mɔ́ndɛ́n, ó o Ɲúhṹso wáayi tonkaro bĩnía ɓuara a Zozɛɛfu cɔ̃́n hã kònkórá yi, á ɓueé bía nɔn wo yi: «Hĩ́ní fé o háyónza lè mín nu, à ũ bĩní va ho *Isirayɛɛle kɔ̃hṹ yi. Lé bìo á bìa lá wee cà a háyónza mu á à ɓúe wã́a húrun.» Ó o Zozɛɛfu hĩ́nɔn á fó a háyónza lè mín nu á bĩnía ɓuararáa ho Isirayɛɛle kɔ̃hṹ yi. Mu wó kà síi bèra a na à bìo ó o Ɲúhṹso bía lè mí ɲi-cúa fɛɛro ɲii à yìo lé. O bía: «Ĩ von ĩ za léra ho *Ezipite kɔ̃hṹ yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bìo ó o Zozɛɛfu ɲá à ɓa le o Aakelayuusi lé yìa zon mín maá Heroode lahó á lé o bɛ́ɛ ho *Zudee kɔ̃hṹ yi, ó o zã́na ho vaa kɛɛníló bĩ́n. Bìo á bìo ó o ò wé á zéenía nɔn wo yi hã kònkórá yi, á ɓa wà ɲɔn ho Kalilee kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɓa vaá kará ho lóhó ɓúi na ɓa le Nazarɛɛte yi. Mu wó kà síi, bèra a na à bìo le *Dónbeenì ɲi-cúa fɛɛrowà yánkaa bía à ɲii sí. Bán yánkaa le ɓa khíi wé è ve o làa Nazarɛɛte nìi. ");
INSERT INTO boxNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pã̀ahṹ ɓúi ɓueé dɔ̃n, ó o Zãn Batiisi bìo ɓa zũna le o wi ho *Zudee kɔ̃hṹ dùure yi, á wee bue le Dónbeenì bíonì. O wee bío na ɓa nùpua yi: ");
INSERT INTO boxNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Mi khí mu bè-kora wéró yi, à bè le Dónbeenì yi, lé bìo le *Dónbeenì bɛ́ɛnì ɓueé ɓó.» ");
INSERT INTO boxNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lé orɛ́n Zãn mu á le *Dónbeenì ɲi-cúa fɛɛro *Ezayii á bía bìo kà síi: «Nìi ɓúi wee bío pɔ̃́npɔ̃́n le dùure yi kà síi: ‹Mi wíoka ho wɔ̃hṹ ká a Ɲúhṹso o ɓuen. Mi muin ho wɔ̃hṹ na ò o bè.›» ");
INSERT INTO boxNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","O Zãn dà-zĩ́nii tã́ là a cón-ɲúmúkũ̀ varà, á ku-cɛɛ̀níi wó lè ho sãahṹ. O bè-dínii lé ɓa hawà lè hã sò-kĩa sòró. ");
INSERT INTO boxNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ho Zeruzalɛɛmu lóhósa, lè ho Zudee kɔ̃hṹ nìpomu, làa bìa ɓó ho muhṹ na ɓa le Zurudɛ̃n yi ɓúenɓúen á wee ɓuen o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓa wee zéení mí bè-kora ɓa nùpua yahó, ò o Zãn bátízé ɓa ho Zurudɛ̃n mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bìo ó o mɔn à ɓa *Farizĩɛwa lè ɓa *Sadusĩɛwa wee lé ɓuen o *bátɛ́ɛ̀mù lahó yi, ó o bía nɔn ɓa yi: «Mi yí mɔn miten le, díhioni zàwa yɛ́n! Le Dónbeenì sĩ-cĩ̀ílè na yòó lua á mi so wee leéka le mi dà à fé miten níi yi le? Lé o yɛ́n bía mu nɔn mia? ");
INSERT INTO boxNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Héyìi! Mi wé wé hã wárá na se, hĩ̀a wee zéení le mi khú mu bè-kora wéró yi á bò le Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mi yí leéka le bìo mi lé o *Abarahaamu mɔ̀nmànía á bṹn mí dòn wã́a à yí dɛ́. Le ĩ bío mu na mia: Mi yí mɔn hã huaa na ká le? Hɔ̃́n le Dónbeenì yàá pá dà á à wé là a Abarahaamu zàwa. ");
INSERT INTO boxNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Á mi cén pa miten bìo sese. Lé le dóorè hónhónía ɓuan hã vĩ̀nsĩ̀a kúioró bìo yi. Vĩ̀ndɛ̀ɛ lée vĩ̀ndɛ̀ɛ na yí máa ha hã bia na sĩ, á dén ǹ kúii á à sía à kúee mín wán á à cĩ̀í. ");
INSERT INTO boxNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ĩnɛ́n wee bátízé mia lè mu ɲumu lé bìo mi khú mu bè-kora wéró á bò le Dónbeenì yi. Ká yìa á à ɓuen ĩnɛ́n mɔ́n, wón á à bátízé mia lè le Dónbeenì Hácírí, lè ho dɔ̃hṹ. O po mi. Ĩ yàá yí ko là a nakãa tɛnló hùúu. ");
INSERT INTO boxNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O ɓuan mí vɛ́ɛró dɛ̀ɛ mí níi yi á ɓueé vɛ́ɛráa mí dĩ́nló. Á hìa lé ho dĩ́n-poni o ò khuii á à kúee mí nání yi. Ká hã ɲáakã́a hɔ̃́n o ò cĩ̀í ho dɔ̃hṹ na máa hí hùúu yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mu pã̀ahṹ, ó o Yeesu ló ho Kalilee kɔ̃hṹ yi á ɓuara ho muhṹ na ɓa le Zurudɛ̃n yi. O ɓuara a Zãn cɔ̃́n le wón bátízé mí. ");
INSERT INTO boxNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ó o Zãn pã́, ò o bía nɔn wo yi: «Ũnɛ́n lé fo lá ko á ũ bátízé mi, á lée webio ɓɛ̀n nɔn á ũ le ĩnɛ́n bátízéráa fo?» ");
INSERT INTO boxNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ká a Yeesu màhã́ bía nɔn wo yi: «Día le mu wé làa bṹn. Lé kà síi á wa ko à wa wéráa à tiíráa le Dónbeenì sĩi bìo ɲii.» Ó o Zãn wã́a tà. ");
INSERT INTO boxNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bìo ó o Zãn bátízéra a Yeesu vó ó o Yeesu ló mu ɲumu yi. Ho pɔ̃̀n-kéní mu yi, á ho wáayi ɲii hɛ́ra, ó o mɔn le Dónbeenì Hácírí à le lion lòn háponi o wán á lií wi làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Á mu tãmu ɓúi sã ɲá ho wáayi á bía: «Yìa kà lé ĩ Za na á ĩ bò ĩ tàká wán. O bìo sĩ miì.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bṹn mɔ́n á le Dónbeenì Hácírí ɓuan o Yeesu vannáa le dùure yi bèra a na ò o *Satãni khà a loń. ");
INSERT INTO boxNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hã wizooní ɓúará-ɲun lè mí tĩ́nɔ̀nna ɓúará-ɲun ó o Yeesu wó ò o yí dú, á le hĩni dà a. ");
INSERT INTO boxNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ó o Satãni vá ɓueé ɓó a yi, á bía nɔn wo yi: «Hã huaa na kà fo yí mɔn lé? Ká fo lé le Dónbeenì Za bìo bon kɛ̃́nkɛ̃́n, à ũ bío le hã huaa na kà yèrèmá wé ho dĩ́nló.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ó o Yeesu bía: «Bìo kà lé bìo túara le Dónbeenì bíonì vũahṹ yi: ‹Dĩ́nló mí dòn yí máa na mukãnì nùpue yi. O nùpue màkóo mún wi le Dónbeenì bíonì na le wee bío yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bṹn mɔ́n ó o Satãni mu fó a vannáa ho Zeruzalɛɛmu, á vaá yòó dĩ̀nía wo le *Dónbeenì zĩ-beenì ɲún-tĩ́ahṹ, ");
INSERT INTO boxNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ò o bía nɔn wo yi: «Ká fo lé le Dónbeenì Za bìo bon kɛ̃́nkɛ̃́n, à ũ yén lii ho tá yi, lé bìo mu túara: ‹Le Dónbeenì á à na le ɲii mí wáayi tonkarowà yi á ɓa à cɔ̃n fo á lií wíoka à bàrá, bèra a na à ũ zeǹ yí tṹii làa huee ɓúi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ó o Yeesu bía nɔn wo yi. «Mu mún túara le Dónbeenì bíonì vũahṹ yi kà: ‹Yí vĩ́ vĩ́ yí khũaa ũ Ɲúhṹso Dónbeenì ɲii yi hàrí lòn wizoǹ-kéní.›» ");
INSERT INTO boxNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ó o Satãni mu pá bĩnía fó a yòoraráa le ɓúee ɓúi na dɔ̃ndɔ̃n wán, á yòó zéenía ho tá kãna ɓúenɓúen, lè mí nàfòró, lè mí semu na wi hã yi làa wo, ");
INSERT INTO boxNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ò o bía nɔn wo yi: «Ĩ ì na bìo kà ɓúenɓúen foǹ ká fo tà lií fárá ũ nɔnkóɲúná wán à ũ ɓùaanía mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ó o Yeesu wã́a bía nɔn wo yi: «Lé bĩ́n, Satãni! Mu túara le Dónbeenì bíonì vũahṹ yi: ‹Ũ Ɲúhṹso Dónbeenì lé yìa á ũ ko à ũ ɓùaaní, à mún sá na orɛ́n mí dòn yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ó o Satãni wã́a wà ò o día a Yeesu. Á le Dónbeenì wáayi tonkarowà ɓuara a cɔ̃́n, á ɓueé wó bìo ó o màkóo wi yi nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wizonle ɓúi, ó o Yeesu ɲá le o Zãn ɓa dó ho kàsó yi, ó o wà van ho Kalilee kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O yí kará ho Nazarɛɛte yi, ò o wà van vaá kará ho *Kapɛɛnayuumu lóhó yi. Ho lóhó mu wi ho Kalilee vũ-beenì ɲii, ho Zabulon lè ho Nɛfutalii lùa na bĩ́n yi. ");
INSERT INTO boxNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mu wó kà síi, à hã bíoní na le *Dónbeenì ɲi-cúa fɛɛro *Ezayii bía à ɲii sí. O bía: ");
INSERT INTO boxNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ũnɛ́n Zabulon lè ũnɛ́n Nɛfutalii kãna na wi lè ho vũ-beenì cɔ̃́n ho Zurudɛ̃n ɲúhṹ yi. Ũnɛ́n Kalilee na lé bìa yínɔń ɓa *zúifùwa kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Minɛ́n nìpomu na lá wi le tíbírí yi á mɔn mu khon-beenì. Minɛ́n na lá kará mu húmú kɔ̃hṹ yi mu yuumu yi á mu khoomu ló wán.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lé bṹn ɲii wán ó o Yeesu wã́a ɓúakáa wee bue le Dónbeenì bíonì. Bìo kà lé bìo ó o hĩ́a wee bío: «Mi khí mu bè-kora wéró yi à bè le Dónbeenì yi. Lé le *Dónbeenì bɛ́ɛnì ɓueé ɓó.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bìo ó o Yeesu hĩ́a wee vará á bã́ ho Kalilee vũ-beenì, ó o mɔn ɓa ce-pawà nùwã ɲun. Ɓa lée maá zàwa, o Simɔn na ɓa mún wee ve làa Piɛre, lè mín za Ãndere. Ɓa wee yénní mí zùán dé mu ɲumu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ó o Yeesu bía nɔn ɓa yi: «Mi ɓuee bè miì, á ĩ wé á ɓa nùpua lé bìa á mi wé è yí á à ɓua à ɓuennáa ĩ cɔ̃́n làa bìo mi wee paráa ɓa cewà bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Á ɓa dɛ̀ɛnía kúaará mí zùánwà à ɓa bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bìo ó o vá van cĩ́inú, ó o tĩ́n mɔn maá zàwa nùwã ɲun ɓúi. Ɓa lé o Zebedee nùwã, o Zaaki là a Zãn. Ɓa wi mí woohṹ yi lè mín maá, á wee wíoka mí zùánwà. Ó o Yeesu von ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mí lahó yi, á ɓa ló día mí woohṹ lè mín maá, à ɓa bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O Yeesu hĩ́a wee vará ho Kalilee kɔ̃hṹ ɓúenɓúen yi, á wee kàrán ɓa nùpua ɓa *zúifùwa kàránló zĩní na wi bĩ́n yi, á wee bue le *Dónbeenì bɛ́ɛnì bín-tente. O wee wɛɛ́ ɓa nùpua na mu vã́mú lè mí sìíwà ɓúenɓúen tò. ");
INSERT INTO boxNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","O Yeesu yèni ló fò ho Siirii kɔ̃hṹ ɓúenɓúen. Á ɓa wee ɓua bìa mu vã́mú lè mí sìíwà wee beé lò, làa bìa sãnía wee ɲí bìo cɛ̀rɛ̀ɛ bìo yi à ɓuennáa o cɔ̃́n: Bìa ɓa cĩ́náwa wi yi, làa bìa á le dàndàhíonì wi yi, lè ɓa mùamúawà, ó o Yeesu wee wɛɛ́ ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɓa zã̀amá-kúii hĩ́a wee bè o yi. Ɓa wee lé ho Kalilee lè hã Lórá Bìo Pírú kãna yi, lè ho Zeruzalɛɛmu lóhó yi, lè ho Zudee kɔ̃hṹ yi, lè hã kãna na khíi lè ho Zurudɛ̃n muhṹ mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ká a Yeesu mɔn bán minka nì-kúii so, ó o yòora le ɓúee yòó kará. Ó o nì-kenínia wà ɓueé ɓó a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ó o wã́a lá le bíonì ò o wee kàrán ɓa kà síi: ");
INSERT INTO boxNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Bìa zũ le mí khon mí yiwa bán ɲúná sĩ, lé bìo le Dónbeenì bɛ́ɛnì á ɓa níní wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bìa wee wá, bán ɲúná sĩ, lé bìo le Dónbeenì khíi hĩ̀í ɓa sĩa. ");
INSERT INTO boxNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bìa wayika bán ɲúná sĩ, lé bìo ho tá na le Dónbeenì dó mí ɲii le mí ì na, á bìo á à sĩ̀ ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bìa le Dónbeenì sĩi bìo wéró poni wee ɓúe, bán ɲúná sĩ, lé bìo á bìo ɓa wee ca á ɓa à yí á mu ɲii ì sí. ");
INSERT INTO boxNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bìa zũ mí ninzàwa màkárí bán ɲúná sĩ, lé bìo le Dónbeenì mún khíi zũń ɓa màkárí. ");
INSERT INTO boxNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bìa hácírí bò le Dónbeenì bìo mí dòn wán bán ɲúná sĩ, lé bìo ɓa khíi mi le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bìa wee wé à ho hɛ́ɛrà kɛń bìa làa ba páanía wi pã̀ahṹ bán ɲúná sĩ, lé bìo le Dónbeenì khíi ve ɓa le mí zàwa. ");
INSERT INTO boxNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bìa ɓa wee beé lò lé bìo ɓa wee wé bìo le Dónbeenì sĩi vá yi bán ɲúná sĩ, lé bìo ho wáayi bɛ́ɛnì bìo sã̀ ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ká ɓa nùpua wee là mia, á wee beé mi lò, á wee fũ̀aa hã sabíoní lè mi sìíwà mi dã́ní yi ĩnɛ́n bìo yi, se mi ɲúná sĩ. ");
INSERT INTO boxNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mi zã̀maka, mi le mi sĩa wa làa sòobɛ́ɛ, lé bìo le Dónbeenì bũ̀iá beenì pan mia ho wáayi mu bìo yi. Mu bon, lé kà síi á ɓa beéraráa le *Dónbeenì ɲi-cúa fɛɛrowà na dú mi yahó lò. ");
INSERT INTO boxNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Minɛ́n ka lòn yámú ho dĩ́míɲá nùpua tĩ́ahṹ. Ká mu yámú yonyoró ló mu yi, á ɓa à wé kaka á mu ù bĩní ì zoráa. Mu cũ̀nú máa kɛń ká mu yínɔń à lée yénní mu kúia à ɓa nùpua wé yonka. ");
INSERT INTO boxNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Minɛ́n ka lòn khoomu ho dĩ́míɲá nùpua tĩ́ahṹ. Ho lóhó na son le ɓúee wán wé dĩ̀n dɛnkhɛɛn. ");
INSERT INTO boxNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɓa máa wé dé fĩ̀ntã́ní à ɓún yi làa láahó. Ɓa wé dé le bàrá hen na le ko le bàrá yi, à bìa wi le zĩi yi ɓúenɓúen kɛń mu khoomu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Minɛ́n mún ko mi kɛń lòn khoomu ɓa nùpua yahó, bèra a na ká ɓa mɔn mu bè-tentewà na mi wee wé, à ɓa ɓùaaní mìn Maá na wi ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Mi yí leéka le ĩ ɓuara á wà ɓueé ɓúe o *Mɔyiize làndá lè ɓa ɲi-cúa fɛɛrowà kàránló ɲúhṹ dɛ́. Ɓùeé. Ĩ wà ɓueé tií mu ɲii lé bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Le ĩ mì ho tũ̀iá na mia: Hàrí ho wáayi lè ho tá à mía kaka, á ho làndá ɓàn bín-za na khúekhúe á máa fá ho ɲii, fúaa mu bìo ɓúenɓúen véró. ");
INSERT INTO boxNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lé bṹn nɔn ká yìa wó khon hã làndáwá mu ɓàn dà-za ɓúi dã́ní yi, á wee kàrán ɓa nùpua le ɓa wé wé làa bṹn, wón ɓànso khíi kɛń cĩ́inú ho wáayi bɛ́ɛnì yi. Ká yìa ɓɛ̀n wee tà bè ho làndá yi, á wee kàrán ɓa nùpua le ɓa wé wé làa bṹn wón ɓànso khíi wé o nì-beenì ho wáayi bá-zàmu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Le ĩ bío mu na mia: Ká mi yí máa bè bìo le Dónbeenì le mi wé yi á yí po ho *làndá bìo zéenílowa lè ɓa *Farizĩɛwa, á mi máa dàń máa kɛń ho wáayi bá-zàmu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Mi ɲá à ɓa bía bìo kà nɔn wàn ɓùaawa yi: ‹Yí ɓúe nùpue.› Yìa wó nì-ɓúe á ɓànso ɓa à ɓua á à varáa le cítíi fĩ̀iníi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ká ĩnɛ́n màhã́ à bío á à na mia: Yìa sĩi cã̀ mín za yi, wón ɓa à ɓua á à varáa le cítíi fĩ̀iníi. Yìa bía le mín za lée bɔ̃́nbú, wón ɓànso á ho làndá tũ̀iá fɛɛrowà ko ɓa cítí. Á yìa bía le mín za lé o khéero, wón ɓànso ko ò o dé le Dofĩ́ní dɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Ká fo wà ɓueé wé mu hãmu á à na le Dónbeenì yi mu hãmu cĩ̀íníi lahó yi, ká ũ hácírí ɓuara le fo wó khon lè mi ninza ó o sĩi wee cĩ̀ foǹ, ");
INSERT INTO boxNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","à ũ bàrá ũ hãmu mu hãmu cĩ̀íníi lahó yi, ká ũ lɛ́n va a cɔ̃́n à mi vaá véení mu. Ká bṹn wó vó, à ũ màhã́ ɓuee wé ũ hãmu à na le Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«O ɓúi lá le fo wó khon làa mí síi, ó o von fo le cítíi fĩ̀iníi, à ũnɛ́n na wó khon à fèn wé le ɲii dà-kéní làa wo ho wɔ̃hṹ wán ká mi dĩǹ yí vaá dɔ̃n. Ká bṹn mía á wón vaá dé fo o cítí-fĩ̀ níi yi, á wón ɓɛ̀n á à yèrèmá khíi dé fo o paro níi yi o ò dé ho kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Le ĩ mì ho tũ̀iá na foǹ: Ho kàsó mu á fo máa lé yi hùúu, ká ũ yí wã́ le wárí na á fo ko à ũ na ɓúenɓúen á yí tiíra ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Mi ɲá à ɓa bía bìo kà: ‹Yí wé hã́-fé tàá bá-fé.› ");
INSERT INTO boxNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ká ĩnɛ́n màhã́ à bío bìo kà á à na mia: Yìa lora mín za ɓàn hã́a á sĩi vá a yi, se ɓànso fó a vó mí yilera yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ká mu lé ũ nín-tĩánì yère wee dé fo mu bè-kohó wéró yi, à ũ còkon le lèe día. Mu sṹaaní à ũ sãnía bìo ɓúi yí kɛń bĩ́n, á po bìo hã ɲii sú à ɓa lèera dó le Dofĩ́ní dɔ̃hṹ na máa hí lùe yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ká mu lé ũ nín-tĩánì níi wee dé fo mu bè-kohó wéró yi, à ũ kúii le lèe día. Mu sṹaaní à ũ sãnía bìo ɓúi yí kɛń bĩ́n á po bìo hã ɲii sú á fo ò zoráa le Dofĩ́ní dɔ̃hṹ na máa hí lùe yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Mu túara: ‹Yìa le mí ì ɲa mín hã́a, á ɓànso ko ò o wé mu yaamu fáaró vũahṹ à na a yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ká ĩnɛ́n màhã́ wee bío mu na mia: Báa na día mín hã́a, à ɓàn hã́a mu ɲɔn yí fó báa, ká a wà vaá yan bá-veere, se lé ɓàn báa mu dó a ho bá-fénló yi. Á yìa mún fó a hã́a na ɓàn báa día wo á yan, wón mún lé o hã́-fé. ");
INSERT INTO boxNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Mi mún ɲá à ɓa bía nɔn wàn ɓùaawa yi: ‹Bìo fo báa le Dónbeenì yahó le fo ò wé à ũ yí khíní yi. Wé mu.› ");
INSERT INTO boxNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ká ĩnɛ́n màhã́ wee bío mu na mia: Mi yí báa hùúu. Mi yí báa lè ho wáayi, lé bìo á bĩ́n lé le *Dónbeenì bɛ́ɛnì lùe. ");
INSERT INTO boxNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mi yí báa lè ho tá, lé bìo á hón lé le Dónbeenì zení bèeníi. Mi yí báa lè ho Zeruzalɛɛmu, lé bìo á hón lé ɓa bá-zàwa bɛ́ɛ lóhó. ");
INSERT INTO boxNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yàá mún pá yí báa lè ũ ɲúhṹ, lé bìo le ɲún-vãní dà-kéní mí dòn ɓàn cemu lè le ɓàn bímú á fo yí dà máa wé. ");
INSERT INTO boxNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mi wé le ũuu, à mi dĩ̀n bṹn wán. Ká mi le ɓùeé, à mi dĩ̀n bṹn wán. Ká bìo mi wee bĩní báa à bè mu wán bṹn wee lé o *Satãni yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Mi ɲá à ɓa bía: ‹Ká yìa fía mí ninza yère á ɓa mún ǹ fío ɓànso yère. Yìa kéra mí ninza ɲin-kéza á ɓa mún kén ɓànso ɲin-kéza.› ");
INSERT INTO boxNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ká ĩnɛ́n màhã́ wee bío na mia le ká a nì-sũmúi wi ò o wé mu bè-kora làa mia, à mi día le o wé. Hen ká a ɓúi dó ũ nín-tĩánì sáahó yi, ũ ɲì mu yi ká ũ yèrèmá hìa so dá a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hen ká a ɓúi le mí ì cítí làa fo á à féráa ũ báká, ũ bè ũ kánɓun ho wán na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ká ho pànká ton-sá ɓúi kĩ̀kã́a foǹ le ũ sè bìo ɓúi à varákaráa ho kilomɛɛtere dà-kéní, à ũ sè mu à varákaráa hã kilomɛɛterewa bìo ɲun làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yìa fìora bìo ũ cɔ̃́n, à ũ na mu wo yi. Yìa le mí ì ke bìo ũ cɔ̃́n à ũ yí pĩ́. ");
INSERT INTO boxNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Mi ɲá à ɓa bía: ‹Fo ko à ũ wań mí ninza ká ũ ɲin ũ zúkúso.› ");
INSERT INTO boxNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɛ̀ɛ ká ĩnɛ́n wón wee bío mu na mia: Mi wań mi zúkúsa. Mi wé fìo na bìa wee beé mi lò yi, ");
INSERT INTO boxNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","lé bṹn á à zéení le mi lé mìn Maá na wi ho wáayi zàwa. Orɛ́n lé yìa wee wé à le wii hà ɓa nì-sũmáa lè ɓa nì-tentewà wán. O wee wé à ho viohó tè bìa térénna làa bìa yí térénna cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ká bìa wa mia lé bán mí dòn á mi wa, á mi wee leéka le mi so pá à bĩní ì yí cũ̀nú mu mɔ́n le? Hàrí ɓa *lànpó féwá wee wé kà síi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ká mìn zàwa lè mìn hĩ́nni lé bán mí dòn mi wee tɛ̀ɛní yi, se mi so pá yú bìo wó lé? Hàrí bìa yí zũ le Dónbeenì wee wé kà síi. ");
INSERT INTO boxNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mi wé ɓa nùpua na ɲii tun làa bìo á mìn Maá na wi ho wáayi tentemu ɲii tunnáa bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Héyìi! Hen ká mi wé le mi ì wé bìo le Dónbeenì làndá bò, à mi yí wé mu le ɓa nùpua mi. Ká mi wó mu ɓa mɔn, á mi máa yí cũ̀nú mìn Maá na wi ho wáayi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hen ká fo wé le fo ò hã mu bìo lè ɓa nì-khenia, à ũ yí yényéní mu le ɓa nùpua ɲí làa bìo ɓa nì-khàwa wee wéráa mu ho kàránló zĩní lè hã ɓonfúaa yi bìo síi. Ɓa wee wé mu à cà lè le yèni. Le ĩ mì ho tũ̀iá na mia: Bánsowa so yú mí cũ̀nú vó. ");
INSERT INTO boxNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ɛ̀ɛ ká ũnɛ́n, fo wé le fo o hã mu bìo lè ɓa nì-khenia, à ũ yí le hàrí mìn bɔ̃́nlo binbirì à zũń dɛ̀ɛ ɓúi mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Le mu hãmu mu à wé bìo na sànkaa wó. Á mìn Maá na wee mi mu bìo na sànkaa á à na mu cũ̀nú foǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Hen ká mi wé wee fìo, à mi yí wé lè ɓa nì-khàwa bìo síi. Bán wee wé dĩ̀n ho kàránló zĩní làa hen na hã wãna fò mín yi à wéráa mí fìoró, bèra a na à ɓa nùpua ɓúenɓúen wé mi ɓa. Le ĩ mì ho tũ̀iá na mia: Ɓa yú mi cũ̀nú vó. ");
INSERT INTO boxNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɛ̀ɛ ká ũnɛ́n wé le fo o fìo, à ũ yòo zo ũ zĩi à pe ho zũaɲii, à ũ fìo mìn Maá Dónbeenì yi. Le làa fo páanía zoó wi bĩ́n. Á lerɛ́n na zũ bìo fo zoó wee wé á à na mu cũ̀nú foǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Hen ká mi wé wee fìo, à mi yí dĩ̀n la hã minka bíoní yi làa bìo á bìa yí zũ le Dónbeenì wee wéráa mu. Ɓa wee leéka le ká mí yí bía cɛ̀rɛ̀ɛ á le Dónbeenì máa ɲí mí cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mi yí wé bìo ɓa wee wé ɓàn síi, lé bìo á mìn Maá Dónbeenì á fèra zũ bìo mi màkóo wi yi vó, ká mi dĩǹ yí fìora. ");
INSERT INTO boxNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Mi wé wee fìo, à mi fìo kà síi: Wàn Maá na wi ho wáayi, wé à ɓa nùpua zũń le fo lé le Dónbeenì na ɓàn síi mía. ");
INSERT INTO boxNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dí ũ bɛ́ɛnì hã lùa ɓúenɓúen yi. Le ũ sĩi bìo wé ho tá wán làa bìo mu wee wéráa ho wáayi bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hã wɛn lè mu bè-dínii na ko làa wɛn ho zuia. ");
INSERT INTO boxNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sɛ́n wa bè-kora día, làa bìo á warɛ́n mún wee tà sɛ́n día à na bìa wó khon làa wɛn yi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pa wɛn bìo wee khà wɛn dé mu bè-kohó wéró yi bìo yi. Kã̀ní wɛn o *Satãni níi yi. Le bɛ́ɛnì, lè ho dàńló, lè ho cùkú bìo sã̀ foǹ fɛ́ɛɛ. *Amiina. ");
INSERT INTO boxNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ká bìa wó khon làa mia bìo á mi wee tà sɛ́n día, á mìn Maá na wi ho wáayi mún wé è sɛ́n mi bè-kora á à día. ");
INSERT INTO boxNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ká mi yí máa tà sɛ́n día na ɓa yi, á mìn Maá na wi ho wáayi mún máa wé è sɛ́n mi bè-kora máa día. ");
INSERT INTO boxNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Hen ká mi wé lù mi ɲiní, à mi yí sè mi yara làa bìo á ɓa nì-khàwa wee wé wéráa mu. Ɓa wee wé sè mí yara à ɓa nùpua ɓúenɓúen zũń le ɓa lù mí ɲiní. Le ĩ mì ho tũ̀iá na mia: Ɓa yú mí cũ̀nú vó. ");
INSERT INTO boxNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ɛ̀ɛ ká ũnɛ́n wé le fo ò lì ũ ɲii à ũ sɛɛ ũ yahó, à wíoka ũ ɲúhṹ sese, ");
INSERT INTO boxNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bèra a na à ɓa nùpua yí zũń le fo lù ũ ɲii. Mìn Maá Dónbeenì mí dòn na wi le lùe na sànkaa yi á mɔn bìo fo sànkaa wó. Orɛ́n lé yìa á à na ho cũ̀nú foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Mi yí sá ho nàfòró ká lè miten ho dĩ́míɲá yi. Ɓa sũnɓowa lè ɓa làkàbṹaawa wi bĩ́n á à yáa ho. Ɓa kɔ̃̀nlowà wee wé háaka hã wonna ká ɓa zoo ɲuaa ho. ");
INSERT INTO boxNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ho wáayi lé bĩ́n á mi sá ho nàfòró binbirì bàrá yi à ká lè miten. Bĩ́n á sũnɓowa tàá làkàbṹaawa máa yí ho máa yáa. Kɔ̃̀nlowà mún yí dà máa yòó háa woohṹ bĩ́n á máa ɲuaa bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mu bon, hen na á ũ nàfòró wi yi lé bĩ́n á ũ sĩi ɓúenɓúen á à dé yi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«O nùpue yìo lé o sãnía fĩ̀ntã́ní. Ká ũ yìo se, á ũ sãnía ɓúenɓúen á à kɛń mu khoomu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ká ũ yìo yí se, á ũ sãnía ɓúenɓúen á à kɛń le tíbírí yi. Hen ká mu khoomu na wi foǹ hĩ́a yèrèmáa wó le tíbírí, à ũ loń bìo le tíbírí mu á à kɛńnáa cícící.» ");
INSERT INTO boxNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nìi woon yí dà máa sá máa na ɲúnása nùwã ɲun yi. O ò ɲin o nì-kéní ká a wań yìa so. O wé è ɲí o nì-kéní bíonì, ká yìa so ó o máa kɔ̃̀nbi. Mi yí dà máa sá máa na le Dónbeenì yi ká mi mún pá henía le wárí càró bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Lé bṹn nɔn á ĩ wee bíoráa bìo kà á à na mia: Mi wé yí yáa mi yilera mi mukãnì bìo yi, le mi ì yí mu bè-dínii lè mu bè-ɲunii wen, tàá mi sãnía bìo yi, le mi ì yí hã sĩ̀-zĩ́nia wen á à zĩ́. Le mukãnì bìo po mu bè-dínii, á hã sãnía bìo po hã sĩ̀-zĩ́nia, mu so yí bon le? ");
INSERT INTO boxNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mi loń ɓa ɲínzàwa. Ɓa yí máa dì bìo á mún yí máa lá dĩ́nló. Ɓa náa mía, ká mìn Maá na wi ho wáayi màhã́ pá wee díiní ɓa. Á minɛ́n so bìo ɲúhṹ yí wi yí po ɓa ɲínzàwa le? ");
INSERT INTO boxNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Minɛ́n tĩ́ahṹ á yìa dà mí mukãnì wizooní á à dé wán cĩ́inú mí yilera yáaró bìo yi so wi le? ");
INSERT INTO boxNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Á mi yilera yáaró hã sĩ̀-zĩ́nia bìo yi so ɲúhṹ wi le? Mi loń le pũ̀iílè. Le yí máa sá dɛ̀ɛ, á mún yí máa tĩ́ sĩ̀a. ");
INSERT INTO boxNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Le ĩ bío mu na mia: Hàrí o *Salomɔn lè mí cùkú ɓúenɓúen ká wón pá yí zã́ sĩ̀a na se yú lerɛ́n ɓúi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ká le Dónbeenì wee donkhueé le ɲíní kà síi, dìo wé kɛń ho zuia ká ho yìró à ɓa cĩ̀í le, à sɔ̃̀nkú minɛ́n á le è wé kaka máa zĩ́iní. Mi sĩadéró le Dónbeenì yi ɓɛ̀ntĩ́n fòora. ");
INSERT INTO boxNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Àwa, á mi wé yí yáa mi yilera à dĩ̀n bío le lée webio mi ì dí tàá lée webio mi ì ɲu, tàá le mi ì yí hã sĩ̀a wen á à zĩ́. ");
INSERT INTO boxNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mu bon, bìa yí zũ le Dónbeenì ɓúenɓúen wee dĩ̀n cà bṹn fɛ́ɛɛ, ká minɛ́n mìn Maá na wi ho wáayi wón zũ bìo ko làa mia. ");
INSERT INTO boxNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mi le mi yara sĩ́ le Dónbeenì bɛ́ɛnì bìo làa bìo térénna le cɔ̃́n, á bìo ká ɓúenɓúen á le Dónbeenì á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mi cén yí yáa mi hácírí ho yìró bìo yi. Lé ho yìró bìo wi lè mi wɔ̃hṹ. Hã wizooní lè mí dà-kéní kéní bè-wénia á à kã́ɲa hã.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Mi wé yí cítí nùpue à síiní ɲúhṹ, á le Dónbeenì mún máa cítíi mia á máa síinía ɲúná. ");
INSERT INTO boxNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lé bìo á bìo mi wee síiní lè ɓa nùpua ɲúná, lé bṹn ɓàn síi le Dónbeenì khíi síinínáa mi ɲúná. Le wĩ̀ló dɛ̀ɛ na á mi wee mɔ̀nzã́ lè mu bìo, lé dén ɓàn síi á le Dónbeenì á à mɔ̀nzã́ lè mí bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Le zóore na wi ũ yère yi á fo yí zũ bìo, à le zàn-dɛ̀ɛ na wi mi ninza yère yi á fo màhã́ mɔn wee zéení. ");
INSERT INTO boxNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Fo dà à wé kaka à bío le mi ninza día le ũ lén le zàn-dɛ̀ɛ na wi o yère yi, ká le zóore na wi ũnɛ́n yère yi á fo yí zũ bìo le? ");
INSERT INTO boxNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yí mɔn á ũten na le! Le zóore na wi ũ yère yi lé dìo á ũ ko à ũ lén vé, á ũ yìo màhã́ à mi wéréwéré á à dàń ǹ lénnáa le zàn-dɛ̀ɛ na wi mi ninza yère yi. ");
INSERT INTO boxNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Mi yí lá mu bìo na bìo sã̀ le Dónbeenì yi à na ɓa booní yi. Ɲún-sĩ, á ɓa dà à yèrèmá à cũ̀aaka mia. Mi mún yí kúia ho lóró na yàwá here ɓa nɔ̀nbùɛɛní tá le ɓa yonka.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Mi wé fìo le Dónbeenì cɔ̃́n, á le è hã mia. Mi wé cànka mu bìo le Dónbeenì cɔ̃́n, á mi ì yí. Mi wé ɓúanɓúa ho woohṹ á le è hɛ́n ho mi ì zo. ");
INSERT INTO boxNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lé bìo á yìa wee fìo á le è hã, yìa wee cà bìo le cɔ̃́n, ó ò yí mu, yìa wee ɓúanɓúa ho woohṹ á le è hɛ́n ho ó ò zo. ");
INSERT INTO boxNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Minɛ́n tĩ́ahṹ ó o ɓúi za fìora ho búurú o cɔ̃́n, ó o so ò na huee wo yi le? ");
INSERT INTO boxNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tàá ká a fìora a ceza o cɔ̃́n ó o so na háa wo yi? ");
INSERT INTO boxNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Àwa, á bìo minɛ́n na yí seka á zũ bìo se naló mi zàwa yi, à sɔ̃̀nkú mìn Maá na wi ho wáayi á à wé kaka máa nanáa mu bè-tentewà bìa wee fìo mu o cɔ̃́n yi? ");
INSERT INTO boxNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Bìo mi wi à ɓa nì-vio wé na mia ɓúenɓúen à mi mún wé mu ɓàn síi na ɓa yi. Bṹn lé bìo ó o Mɔyiize làndá lè le *Dónbeenì ɲi-cúa fɛɛrowà zéenía.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Mi zo lè ho zũaɲii na fĩ́nía. Lé bìo á hìa ɓùaa wɔ̃hṹ bèró sĩ, ká ɓa nùpua na màhã́ wee bè ho á à hí mu húmú binbirì. Bìa wee bè ho á boo. ");
INSERT INTO boxNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ho zũaɲii na fĩ́nía hón wɔ̃hṹ bèró do, ká bìa màhã́ wee bè ho á à yí le mukãnì binbirì na máa vé. Bìa wee bè ho á yí tà yí boo sese.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Bìa le mí lé le *Dónbeenì ɲi-cúa fɛɛrowà ká mu yí bon, á mi pa miten bìo yi. Ɓa wee wayií miten lòn pia bìo síi, ká ɓa yiwa yí se lòn dakhĩ́nkhĩ́nwa. ");
INSERT INTO boxNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mi ì zũń ɓa bìo ɓa wárá yi. Ɲia máa wé khé kíkahó wán. Á lunkúnsòró mún máa wé fáa ɓódíohó wán. ");
INSERT INTO boxNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Le vĩ̀ndɛ̀ɛ na se wee wé ha hã bia na se. Á le vĩ̀ndɛ̀ɛ na yí se wee wé ha hã bia na yí se. ");
INSERT INTO boxNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Le vĩ̀ndɛ̀ɛ na se máa wé ha bia na yí se, á le vĩ̀ndɛ̀ɛ na yí se máa we ha bia na se. ");
INSERT INTO boxNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vĩ̀ndɛ̀ɛ lée vĩ̀ndɛ̀ɛ na yí máa ha hã bia na se, dén ǹ kúii á à sía à kúee mín wán á à cĩ̀í. ");
INSERT INTO boxNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lé kà síi á mi ì zũńnáa bìa le mí lé ɓa ɲi-cúa fɛɛrowà à ɓa yí nɔn ɓa, hã wárá na ɓa wee wé yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Bìa ɓúenɓúen na wee ve mi le ‹Ɲúhṹso! Ɲúhṹso!› yínɔń bìa khíi kɛń le Dónbeenì bɛ́ɛnì yi. Bìa wee wé wàn Maá na wi ho wáayi sĩi bìo lé bán khíi kɛń mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Le cítíi fĩ̀ nɔ̀nzoǹ, á nùpua cɛ̀rɛ̀ɛ á à bío ò na miì: ‹Ɲúhṹso, wa buera le Dónbeenì bíonì, á ɲɔn ɓa cĩ́náwa léra ɓa nùpua yi, á wó mu yéréké bìowa cɛ̀rɛ̀ɛ lè ũ yèni.› ");
INSERT INTO boxNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Á ĩ wã́a à bío ò na ɓa yi: Ĩ yí zũ mia hùúu. Mi vá lé ĩ nìsã́ní, bè-kora wérowà yɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Àwa. Nùpue lée nùpue na wee ɲí ĩ bíoní à bè hã yi wón ɓànso bìo ɓonmín làa nùpue na hácírí wi, á son mí zĩi ho ɓúaahó wán. ");
INSERT INTO boxNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ho viohó ɓueé tò, á hã bònnáa sú cáa, á ho pinpiró và lè mí pànká le zĩi mu wán à le yí tò, lé bìo le ɲúhṹ fárá ho ɓúaahó wán. ");
INSERT INTO boxNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ká nùpue lée nùpue na wee ɲí ĩ bíoní, ò o yí máa bè hã yi, wón ɓànso bìo ɓonmín là a nùpue na lé o bɔ̃́nbú, á son mí zĩi le hɔ̃̀nlè wán. ");
INSERT INTO boxNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ho viohó ɓueé tò, á hã bònnáa sú cáa, á ho pinpiró và lè mí pànká le zĩi mu wán, á le tò pùpɛ̀.» ");
INSERT INTO boxNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bìo ó o Yeesu bía vó, á ɓa zã̀amáa wó coon làa sòobɛ́ɛ bìo ó o wee kàrán lè ɓa nùpua bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Lé bìo ó o yí kàránna ɓa nùpua lè ho *làndá bìo zéenílowa bìo síi. Orɛ́n wó mu lè ho pànká na le Dónbeenì nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","O Yeesu yòó ló le ɓúee wán lion, á ɓa zã̀amá-kúii bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ó o *ɓùeré ɓúi vá ɓueé ɓó a yi, á lií fárá mí nɔnkóɲúná wán o yahó, ò o bía: «Ɲúhṹso, fo dà à wɛɛ́ mi ká fo tà.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ó o Yeesu lií bò mi níi o wán ò o bía nɔn wo yi: «Ĩ tà mu, wã́a wa.» Mí lahó yi, ó o nìi dɛ̀ɛnía wan. ");
INSERT INTO boxNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bṹn mɔ́n ó o Yeesu bía nɔn wo yi: «Bìo wó foǹ á ũ yí bío le nùpue ɲí. Ká ũ màhã́ vaa zéení ũten lè le *Dónbeenì yankaro. À ũ mún wé mu hãmu bìo na ó o *Mɔyiize bò le ɓa wé wé mu dã́ní yi, à ɓa ɓúenɓúen zũń ká ũ wan bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bìo ó o Yeesu vaá wee zo ho *Kapɛɛnayuumu lóhó yi, á ho Oroomu dásíwá ɲúhṹso ɓúi vá ɓueé ɓó a yi, á fìora a le o séení mí. ");
INSERT INTO boxNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O bía: «Ɲúhṹso, ĩ ton-sá dũmaná le zĩi yi. O lé o mùamúa, á lò wee be dàkhĩína.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ó o Yeesu bía nɔn wo yi: «Ĩ ɓueé wɛɛ́ wo.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Á ɓa dásíwá ɲúhṹso bía nɔn wo yi: «Ɲúhṹso, ũ ɓuenló ĩ zĩi lée bìo na á ĩ yí koráa. Na le ɲii mí dòn, á ĩ ton-sá pá à wa. ");
INSERT INTO boxNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ĩnɛ́n ĩ bɛɛre ɲúnása wi á ĩ wee bè bíoní yi. Á ĩnɛ́n mún wi ɓa ɓúi ɲúhṹ wán, á bán mún wee ɲí ĩ cɔ̃́n. Ĩ le yìa va hen à wón va bĩ́n. Ĩ le o ɓúi ɓuen ò o dɛ̀ɛní ɓuen. Ĩ le ĩ ton-sá wé bìo na, ò o dɛ̀ɛní wé mu mí lahó yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bìo ó o Yeesu ɲá hɔ̃́n bíoní so, ó o wó coon, ò o bía nɔn bìa bò a yi: «Le ĩ mì ho tũ̀iá na mia: O *Isirayɛɛle nìpomu ɓúenɓúen yi á ĩ dĩǹ yí fò mín làa nùpue na sĩidéró miì yú yìa kà yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nùpua cɛ̀rɛ̀ɛ khíi lé lè le wii hɛ̀ɛníi lè le tèeníi, á ɓueé kɛɛní ká ɓa à dí ho sã́nú le *Dónbeenì bɛ́ɛnì díiníi là a *Abarahaamu, là a *Izaaki, là a *Zakoobu. ");
INSERT INTO boxNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ká bìa lá ko à ɓa níní kɛń le Dónbeenì bɛ́ɛnì yi, bán ɓa à ɲa lée kúia ho khũuhũ le tíbírí yi, á ɓa lée wá á yiwa à vá bĩ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bṹn mɔ́n ó o Yeesu wã́a bía nɔn ɓa dásíwá ɲúhṹso yi: «Lɛ́n khíɓo, bìo fo fìora á à wé, lé bìo fo dó ũ sĩi miì.» Lé hón pɔ̃̀n-kéní so yi, á ɓa dásíwá ɲúhṹso ton-sá á wan yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","O Yeesu van o Piɛre zĩi. O vaá yú a Piɛre mu ɓàn hio hã́a le dãmu dɛ̀ɛ yi à le tɛ̀ɛnì wee zɛ̀ɛ́ wo. ");
INSERT INTO boxNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ó o Yeesu ɓuan o níi yi á le tɛ̀ɛnì khĩína. Ó o hã́a mu dɛ̀ɛnía hĩ́nɔn nɔn ho dĩ́nló wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ho tá yuuní, á ɓa ɓuan ɓa nùpua cɛ̀rɛ̀ɛ na ɓa cĩ́náwa wi yi á ɓuararáa o Yeesu cɔ̃́n, ó o wee bío à ɲa ɓa cĩ́náwa lén ɓa yi. O mún wɛɛ́ra ɓa vánvárowà ɓúenɓúen na ɓa ɓuan ɓuararáa o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O wó mu bèra a na à le *Dónbeenì ɲi-cúa fɛɛro *Ezayii bìo na ó o bía à wé: «O lá wa lònbee. O fó wa vã́mú bò mí wán.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","O Yeesu mɔn ɓa zã̀amáa na kĩ́nía wo yi, ó o nɔn le ɲii mí nì-kenínia yi le ɓa le mí khí lè ho vũ-beenì mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Á ho làndá bìo zéenílo ɓúi ɓueé ɓó a yi, á bía nɔn wo yi: «Nì-kàránlo, ĩ ì bè foǹ á à varáa hã lùa ɓúenɓúen na á ũ wee va yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ó o Yeesu bía nɔn wo yi: «Ɓa cawanwà yú hã kãna wee zo. Á ɓa ɲínzàwa mún yú mí lɛnna. Ká a *Nùpue Za wón màhã́ yí yú ho lahó na ó o dà à vũń yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ó o nì-kenínia nì-kéní ɓúi bía nɔn wo yi: «Ĩ ì bè foǹ. Ká ũ màhã́ día le ĩ vaa nùu wàn maá vé.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ó o Yeesu bía nɔn wo yi: «Día le ɓa nì-hía à nùu mí nì-hía, ká ũnɛ́n ɓuee bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","O Yeesu yòó zon ho woohṹ lè mí nì-kenínia á ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cúa-yɛn à ho pinpi-beenì wee và ho vũ-beenì wán á wee yànbónka mu ɲumu kúee ho woohṹ yi fúaa ho wi ho lí. Mu wee wé ká a Yeesu dũma. ");
INSERT INTO boxNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ó o nì-kenínia vá ɓueé ɓó a yi, á sĩ̀nía wo, à ɓa bía nɔn wo yi: «Ɲúhṹso, wa à hí. Kã̀ní wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ó o Yeesu bía nɔn ɓa yi: «Lée webio nɔn á mi zã́nanáa? Mi sĩ̀a déró miì ɓɛ̀ntĩ́n fòora.» Ò o wã́a lií hĩ́nɔn, á yòó nàmakaa ho pinpiró lè mu ɲumu na wee yànbónka yi, á mu wó tɛ́tɛ́tɛ́. ");
INSERT INTO boxNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓa ɓúenɓúen á mu wó coon, á ɓa wee bío mín yi: «Páa! O nùpue mu lé o yɛ́n síi kà? Hàrí ho pinpiró lè mu ɲumu ó o bíaráa, á mu pá bò a bíonì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bìo ó o Yeesu khíi dɔ̃n ho Kadaraa kɔ̃hṹ yi, á nùpua nùwã ɲun ɓúi ló ɓa nì-hía nùuníi wee sĩ́ a yahó. Ɓa nùpua mu ɓa cĩ́náwa wi yi á ɓa zã́níi wi fúaa nìi woon yí máa khà miten à lá ho wɔ̃hṹ mu. ");
INSERT INTO boxNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bìo ɓa mɔn o Yeesu á ɓa wee bío kà pɔ̃́npɔ̃́n: «Dónbeenì Za, lée webio fo lon làa wɛn. Fo ɓuara wà ɓueé beé wa lò ká mu pã̀ahṹ dĩǹ yí dɔ̃n le?» ");
INSERT INTO boxNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mu wee wé à nɔ̀nbùɛ-ɓoohṹ ɓúi khɛ̀ra vaá wee dí. ");
INSERT INTO boxNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Á ɓa cĩ́náwa mu yankaa o Yeesu kà síi: «Hen ká ũ wi ũ ɲa wɛn, ũ wã́a bío le wa vaa zo ho nɔ̀nbùɛ-ɓoohṹ na kà yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ó o Yeesu le ɓa vaa zo. À ɓa cĩ́náwa mu ló ɓa nùpua nùwã ɲun mu yi á vaá zon ɓa nɔ̀nbùɛɛní yi. Á ɓa ɓúenɓúen yòó lùwa le ɓúee wán á kùenkaa lií zon ho vũ-beenì yi á húrun. ");
INSERT INTO boxNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Á bìa lá wee pa ɓa á lùwá lion ho lóhó, á lií lá bìo wó ɓúenɓúen á fɛɛra, sɔ̃̀nkú bìo wó ɓa nùpua nùwã ɲun na ɓa cĩ́náwa lá wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Á ho lóhó nùpua ɓúenɓúen ló wà lée sĩ́ a Yeesu yahó. Bìo ɓa lée yú a, á ɓa yanka wo le o sábéré ò o lé mín kɔ̃hṹ yi à lɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","O Yeesu yòó zon ho woohṹ á yèrèmáa kã́a ho vũ-beenì á khú mí lóhó. ");
INSERT INTO boxNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Á ɓa ɓuan o mùamúa ɓúi lè mí dãmu dɛ̀ɛ á ɓuararáa o cɔ̃́n. Bìo ó o Yeesu mɔn bìo ɓa dóráa mí sĩa wo yi, ó o bía nɔn o nìi mu yi: «Wàn bɔ̃́nlo, hení ũ sĩi, ũ bè-kora sɛ́ra día.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Á ho *làndá bìo zéenílowa nùwã yɛn ɓúi wee bío mín yi: «O nìi na kà wee màní míten lè le Dónbeenì.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ó o Yeesu zũna ɓa yilera ó o bía nɔn ɓa yi: «Lée webio nɔn á hã yile-kora wiráa mia. ");
INSERT INTO boxNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lé mu yɛ́n bíoró wayi? Lé à bío le o bè-kora sɛ́ra día lée, tàá lé à bío le o hĩ́ní varáka? ");
INSERT INTO boxNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ká ĩ màhã́ wi mi zũń le o *Nùpue Za yú ho pànká ho tá wán à sɛ́nnáa mu bè-kora día.» Ò o wã́a bía bìo kà nɔn o mùamúa yi: «Lii hĩ́ní, lá ũ dãmu dɛ̀ɛ à ũ khíɓo.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ó o nìi mu hĩ́nɔn yòó dĩ̀n, á wà van mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bìo ɓa zã̀amáa mɔn mu, á ɓa zã́na, á wee khòoní le Dónbeenì ho pànká na kà ɓàn síi na le nɔn ɓa nùpua yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bṹn mɔ́n ó o Yeesu ló hón lahó so yi wà. Bìo ó o wee khĩí, ó o mɔn o nìi ɓúi na ɓa le Matiye ká a kará mí tonló lahó yi, á wee fé ho lànpó. Ó o bía nɔn wo yi: «Hĩ́ní bè miì.» Ó o Matiye lií hĩ́nɔn bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","O Matiye von o Yeesu lè ho dĩ́nló mí zĩi. Ho *lànpó féwá lè ɓa nì-kora cɛ̀rɛ̀ɛ wi ho dĩ́nló mu díiníi là a Yeesu lè mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bìo ɓa *Farizĩɛwa mɔn mu kà, á ɓa bía nɔn o nì-kenínia yi: «Lée webio nɔn á mi nì-kàránlo wee dí lè ho lànpó féwá lè ɓa nì-kora na kà?» ");
INSERT INTO boxNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ó o Yeesu ɲá bìo ɓa bía, ó o bía nɔn ɓa yi: «Héyìi! Minɛ́n! Nùpua na lò hereka so wee wé cà tĩni ɓànso dã́ní le? Ɓùeé. Ɓa vánvárowà lé bìa wee wé cà a dã́ní. ");
INSERT INTO boxNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mi lɛ́n vaa kàrán le Dónbeenì bíonì na kà à zũń kúará: ‹Bìo á ĩ màkóo wi yi lé le yi na se. Ká ɓa bà-kùio na ɓa wee wé lè mu hãmu á ĩ pã́ bìo.› Mi zũń mu sese. Ĩnɛ́n yí ɓuara bìa wee leéka le mí térénna bìo yi dɛ́. Bìa zũ le mí lé ɓa bè-kora wérowà lé bìa á ĩ ɓuara bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","O Zãn Batiisi nì-kenínia vá ɓueé ɓó a Yeesu yi à ɓa wee tùa wo yi: «Lée webio nɔn á warɛ́n lè ɓa *Farizĩɛwa wee lì wa ɲiní túntún, ũnɛ́n nì-kenínia yí máa lì mí ɲiní?» ");
INSERT INTO boxNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ó o Yeesu bía nɔn ɓa yi: «Mi wee leéka le bìa ɓa von mu yaamu sã́nú díiníi yara so dà à sè ká a hã́-fĩa ɓàn báa làa ba páanía wi le? Bṹn yí dà máa wé. Ɛ̀ɛ ká pã̀ahṹ ɓúi khíi dã, ó o hã́-fĩa ɓàn báa ɓa à lén ɓa tĩ́ahṹ, bṹn ká ɓa màhã́ wé è lì mí ɲiní. ");
INSERT INTO boxNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nùpue máa lá nín-ké-fĩnle bìo ɓúi máa la làa báká kĩ́nle. Lé bìo ká a wó mu, á le nín-ké-fĩnle á a wíoka a lɛ̀ɛ ho. ");
INSERT INTO boxNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Làa bṹn síi, nùpue máa wé kúee *dìvɛ̃́n fĩa sṹmàni-kĩ́a yi. Lé bìo ká a kúaa ho bĩ́n, ká ho hĩ́a wee za, á hã à nàma, á ho dìvɛ̃́n á à kúia, á hã sṹmàniwa mún ǹ yáa. Ho dìvɛ̃́n fĩa ɓa wé kúee hã sṹmàni-fĩa yi. Ká mu wó kà, á mu ɓúenɓúen á à wé se.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pã̀ahṹ na ó o Yeesu wee bío lè ɓa nùpua yi, à bṹn ɓa *zúifùwa ya-dí ɓúi ɓueé dɔ̃n, á ɓueé lií ɓúrá a tá ò o bía: «Ĩ hĩ́nló húrun yí míana, ká ũ màhã́ ɓuen ɓuee bè ũ níi o wán o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ó o Yeesu lè mí nì-kenínia hĩ́nɔn bò làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hón pã̀ahṹ so yi, à bṹn ò o hã́a ɓúi wee mi mí sɛɛró fɛ́ɛɛ á dɔ̃n hã lúlúio pírú ɲun à ho máa fĩ̀, á vá ɓueé ɓó a yi, á zoó tṹaa o dà-zĩ́nii ɲi-kã́ní yi là a mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","O wee bío bìo kà mí yi: «Hen ká ĩ dàńna tṹaa o dà-zĩ́nii yi mí dòn, á ĩ ì wa.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bìo ó o Yeesu yèrèmáa khíi mɔn wo, ó o bía: «Wàn hĩ́nló, yí zɔ̃́n dɛ̀ɛ. Bìo fo dó ũ sĩi miì, lé bṹn wɛɛ́ra fo.» Ó o hã́a mu dɛ̀ɛnía wan mí lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bìo ó o Yeesu wã́a vaá dɔ̃n ɓa zúifùwa ya-dí zĩi, ó o wã́a mɔn ɓa sĩ̀-ɓúawá à ɓa wíokaa míten vó o nì-hío nùuló bìo yi, lè ɓa zã̀amáa na wee wá ká ɓa a zúnzúrá. ");
INSERT INTO boxNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ó o bía: «Mi lé lè ho khũuhũ. O hĩ́nzo-za mu yí húrun, o lée yìa na dũma.» Á ɓa wee yáa mí ɲiní yi na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bìo ɓa zã̀amáa ló vó, ó o Yeesu yòó zon le zĩi yi, á zoó fù o hĩ́nzo-za níi yi, ó o lií hĩ́nɔn, ");
INSERT INTO boxNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","á mu ɲá ho kɔ̃hṹ ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bṹn mɔ́n ó o Yeesu ló bĩ́n wà. Bìo ó o wee khĩí, á muiiwà nùwã ɲun ɓúi bò a yi ká ɓa a wãamaka: «*Daviide Za, màkárí wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bìo ó o Yeesu vaá dɔ̃n le zĩi, á ɓa muiiwà mu ɓueé ɓó a yi, ó o tùara ɓa yi: «Mi láa mu yi le ĩ dà wee wɛɛ́ mia le?» Á ɓa le: «Ũuu, Ɲúhṹso, fo dà mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ó o Yeesu wã́a dɔ̃n ɓa yìo, ò o bía: «Le mu wé làa bìo mi láaráa mu yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Á ɓa yìo dɛ̀ɛnía wee mi. Ó o Yeesu henía bìo kà nɔn ɓa yi: «Háyà, nùpue yí ko ò o ɲí bìo wó mia kà.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ká bìo ɓa wà, á ɓa wee bío o Yeesu bìo ho kɔ̃hṹ ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pã̀ahṹ na á bán wee lɛ́n yi, à bṹn ɓa ɓuan o nìi ɓúi ɓuararáa o Yeesu cɔ̃́n, cĩ́ná ɓúi wi o yi, ó o yí dà máa bío. ");
INSERT INTO boxNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ó o Yeesu ɲɔn o cĩ́ná mu léra, ó o nìi ɲii dɛ̀ɛnía fá á wee bío. Á ɓa zã̀amáa wó coon mu bìo yi, á ɓa wee bío: «Warɛ́n *Isirayɛɛle nìpomu yi á wa dĩǹ yí mɔn bìo kà ɓàn síi hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ká ɓa *Farizĩɛwa bán ɓɛ̀n wee bío: «Mu lé ɓa cĩ́náwa ɲúhṹso lé yìa wee na ho dàńló wo yi ò o ɲa lè ɓa cĩ́náwa lén bìa ɓa wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","O Yeesu wee hɛ́ɛ lé hã ló-beera lè hã ló-zàwa yi, á wee kàrán ɓa nùpua ɓa *zúifùwa kàránló zĩní yi. O wee bue le *Dónbeenì bɛ́ɛnì bín-tente, ká a wɛɛ́ mu vã́mú lè mí sìíwà ɓúenɓúen na tò ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ɓa zã̀amáa na ó o wee mi á màkárí ɓuan wo yi. Lé bìo ó o mɔn à ɓa san, á yilera lùnkaa. Ɓa ka lòn pia na paro mía. ");
INSERT INTO boxNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ó o wã́a bía nɔn mí nì-kenínia yi: «Ho dĩ́nló bon dĩ̀n cɛ̀rɛ̀ɛ, ká ho lárowà lé bìa yí boo. ");
INSERT INTO boxNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Àwa. Á mi fìo o mɔhṹ ɓànso yi le o wíoka na ɓa ton-sáwá le ɓa lá ho.» ");
INSERT INTO boxNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O Yeesu hueekaa mí nì-kenínia pírú ɲun á nɔn ho dàńló ɓa yi à ɓa wé ɲa lè ɓa cĩ́náwa lén bìa ɓa wi yi à mún wɛɛ́ lè mu vã́mú lè mí sìíwà ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hĩ̀a kà lé o tonkarowà pírú ɲun yènnáa: O nín-yání tonkaro lé o Simɔn, na ɓa mún có yèni làa Piɛre, lè mín za Ãndere, là a Zaaki lè mín za Zãn na lé o Zebedee zàwa. ");
INSERT INTO boxNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","À dé o Filiipu là a Baatelemii, o Toma là a lànpó fé Matiye, o Alifee za Zaaki là a Tade, ");
INSERT INTO boxNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","o Simɔn na lé ɓa Zelootewa kuure nùpua nì-kéní, là a Zudaa Isikariote na khíi dé o Yeesu mí zúkúsa níi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bán báawa pírú ɲun so lé bìa ó o tonkaa, á henía bìo kà nɔn yi: «Mi yí va hã kãna na á bìa yínɔń ɓa *zúifùwa kará yi, à mún yí zo ho *Samarii kɔ̃hṹ lórá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","O *Isirayɛɛle nìpomu na ka lòn pia na vṹnun bán lé bìa mi va cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mi lá ho wɔ̃hṹ wà, à bìo kà lè bìo mi wé bue: Le *Dónbeenì bɛ́ɛnì á sùaráa. ");
INSERT INTO boxNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mi wɛɛ́ ɓa vánvárowà. Bìa húrun á mi vèení. Ɓa ɓùeréwà à mi wɛɛ́, à ɲa ɓa cĩ́náwa lén bìa ɓa wi yi. Mi yú mu làa kã́amáa, à mi ɓɛ̀n mún wé na mu làa kã́amáa. ");
INSERT INTO boxNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mi yí lɛ́n làa sã́nú, tàá wárí. Hàrí le wɛ́n-wĩ́níwà à mi yí ɓua. ");
INSERT INTO boxNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mi yí ɓua puure. O ɓúi yí ɓua báká tàá nakãa à séení hĩ̀a ó o zã́. O ɓúi yí ɓua bũ̀in-za. Ĩ bía bṹn lé bìo ó o ton-sá ko lè mí ɲii dĩ́nló. ");
INSERT INTO boxNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mi wé vaá zon lóhó lée lóhó yi, à mi cà yìa á à tà mi ì làa o wán, à kɛɛní wón ɓànso cɔ̃́n fúaa mi léró ho lóhó mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mi wé vaá zon zĩi lée zĩi na yi, à mi bío le ho hɛ́ɛrà à kɛń le zĩi mu nùpua wán. ");
INSERT INTO boxNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ká bìa wi le yi á tà mi bìo, á mi hɛ́ɛrà á à kɛń ɓa wán. Ká ɓa pã́ mi bìo, à mi fé mi hɛ́ɛrà tɛ̀ɛníi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi wé vaá zon zĩi, tàá lóhó na yi, ká bìa wi bĩ́n pã́ mi bìo á le mí máa ɲí mi cɔ̃́n, ká mi wee lé bĩ́n, à mi púaa mi zení khṹnkhũnì kúia. ");
INSERT INTO boxNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Le ĩ mì ho tũ̀iá na mia: Le cítíi fĩ̀ nɔ̀nzoǹ, á hón lóhó so nùpua bìo na khíi sá ɓa yi á à poń bìo sá ho *Sodɔɔmu lè ho Komɔɔre lórása yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Mi ɲí bìo kà: Ĩ wee tonka mia. Mi ka lòn pia na wà vaá zo ɓa dakhĩ́nkhĩ́nwa tĩ́ahṹ. Mi zũń miten ɓuaró làa bìo ɓa háwá zũnáa míten ɓuaró bìo síi, à wé ɓa nùpua na wayika lè ɓa ɓùaaɓúuní bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mi pa miten bìo. Ɓa nùpua khíi wé è ɓua mia á à varáa ho pànká ɓànsowà cɔ̃́n á bán vaá cítí mia. Ɓa wé è ha mia lè hã làbàaní ɓa *zúifùwa kàránló zĩní yi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɓa wé è ɓua mia á vaá dĩ̀ní hã kãna ɲúnása lè ɓa bá-zàwa yahó bìo mi tà miì bìo yi. Lé bṹn mi ì bè yi á à zéenínáa ĩ bìo lè ɓarɛ́n làa bìa yínɔń ɓa zúifùwa. ");
INSERT INTO boxNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","«Hen ká ɓa khíi wé ɓuan mia vannáa le cítíi fĩ̀iníi, à mi yí le mi yiwa dè bìo mi ì láráa mi ɲi-cúa làa bìo mi ì bío bìo yi. Mi ì yí hã bíoní na mi ì bío ho pã̀ahṹ mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hã bíoní mu máa wé mi kùrú bíoní. Mìn Maá Dónbeenì Hácírí lé dìo á à dé hã mi ɲiní yi á mi ì bío. ");
INSERT INTO boxNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ɓa nùpua ɓúi wé è dé mín kùrú zàwa á à na ɓa à ɓúe. Hàrí ɓa maáwà ɓúi á à wé mu ɓàn síi lè mí zàwa. Ɓa zàwa ɓúi mún ǹ hĩ́ní mín maáwà wán, á à na ɓa ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɓa nùpua ɓúenɓúen á à ɲin mia bìo mi tà miì bìo yi. Ká yìa màhã́ hã̀ mí sĩi fúaa mu véeníi, wón á à fen. ");
INSERT INTO boxNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hen ká ɓa khíi wee beé mi lò lóhó na yi, à mi lùwí va dà-veere yi. Le ĩ mì ho tũ̀iá na mia: O *Isirayɛɛle kɔ̃hṹ lórá ɓúenɓúen á mi máa bèeni máa vé ká a *Nùpue Za yí ɓuara. ");
INSERT INTO boxNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Nì-kenínii na po yìa wee kení a wón mía. Á ton-sá na po mí ɲúhṹso wón mún mía. ");
INSERT INTO boxNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ká a nì-kenínii hĩ́a ka làa yìa kenía wo bìo, se bṹn á à kã́ɲa. Ká a ton-sá mún hĩ́a ka le mí ɲúhṹso bìo, se bṹn á à kã́ɲa. Ká le zĩ-ɲúhṹ nì-kĩ́nle ɓa hĩ́a wee ve là a *Bɛlezebuule, á se o zĩi nùpua á ɓa a ve lè hã yènnáa na yí seka po dén. ");
INSERT INTO boxNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Mi cén wé yí zɔ̃́n ɓa nùpua. Mu bìo na sànkaa ɓúenɓúen khíi mi, á bìo sà yi ɓúenɓúen mún khíi zũń. ");
INSERT INTO boxNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bìo á ĩ bía nɔn mia le tíbírí yi, à mi mì wéréwéré le ɓa nùpua ɲí. Bìo á ĩ hũmɔnkaa làa mia à mi yòo bue hã lòra. ");
INSERT INTO boxNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mi wé yí zɔ̃́n bìa wee ɓúe o nùpue ká ɓa yí dà máa ɓúe o mànákã̀. Le Dónbeenì na dà a yáa hã sãnía lè ho mànákã̀ le Dofĩ́ní dɔ̃hṹ na máa hí yi, dén lé dìo mi wé zɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ɓa ɲínzà-wĩ́níwà bùaa ɲun so yí máa wé yɛ̀ɛ́ ho tɔ̃mɔ́n dà-kéní le? Ɛ̀ɛ ká hàrí ɓa yà-kéní máa kùen ká mìn Maá Dónbeenì yí zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ká mu lé minɛ́n, hàrí mi ɲún-vãní ɓúenɓúen á le Dónbeenì zũ ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mi wã́a yí zɔ̃́n dɛ̀ɛ, lé mi bìo ɲúhṹ wi po ɓa minka ɲínzà-wĩ́níwà. ");
INSERT INTO boxNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Yìa dĩ̀n ɓa nùpua yahó ò o bía wéréwéré le mí bìo sã̀ miì, á ĩnɛ́n mún khíi bío mu wéréwéré wàn Maá na wi ho wáayi yahó le ɓànso bìo sã̀ miì. ");
INSERT INTO boxNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ká yìa ɓɛ̀n bía wéréwéré ɓa nùpua yahó le mí yí zũ mi, á ĩnɛ́n mún khíi bío wàn Maá na wi ho wáayi yahó le ĩ yí zũ ɓànso. ");
INSERT INTO boxNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Mi yí leéka le ĩ ɓuara wà ɓueé dé ho hɛ́ɛrà ho dĩ́míɲá yi. Ɓùeé. Ĩ yí wà ɓueé dé hɛ́ɛrà ho yi. Hã fio lé hĩ̀a á ĩ wà ɓueé dé. ");
INSERT INTO boxNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ĩ wà ɓueé khɛɛ́ o za lè mín maá, á à khɛɛ́ o nu lè mí hĩ́nló, là a ɓùaa hã́a lè mí yàró hã́a. ");
INSERT INTO boxNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","O nùpue ɓàn zĩi nùpua lé bán á à yèrèmá à wé o zúkúsa. ");
INSERT INTO boxNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yìa wa mín maá tàá mín nu á po mi, wón ɓànso yí dà máa páaní làa mi. Á yìa wa mí za tàá mí hĩ́nló á po mi, wón ɓànso yí dà máa páaní làa mi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yìa yí máa lá mí *kùrùwá pĩ̀ à bèráa miì, wón ɓànso mún yí dà máa páaní làa mi. ");
INSERT INTO boxNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yìa wi ò o pa mí mukãnì bìo wón á à vĩ́iní le. Ká yìa màhã́ vĩ́inía mí mukãnì ĩnɛ́n bìo yi, wón á à bĩní ì yí le. ");
INSERT INTO boxNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Yìa ɓuan mia sese, se lé ĩnɛ́n á ɓànso ɓuan sese. Á yìa ɓuan mi se, se lé yìa tonkaa mi á ɓànso mún ɓuan se. ");
INSERT INTO boxNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hen ká yìa ɓuan le *Dónbeenì ɲi-cúa fɛɛro ɓúi se lé bìo ó o lé le Dónbeenì ɲi-cúa fɛɛro, á ɓànso khíi yí ɓa ɲi-cúa fɛɛrowà cũ̀nú na ɓa à yí. Hen ká a ɓúi ɓuan o nùpue na térénna lé bìo ó o térénna, ó o khíi yí bìa térénna cũ̀nú na ɓa à yí. ");
INSERT INTO boxNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ká nùpue nɔn hàrí ho kóo-za yimù cúee ɲun-wia bìa wi hen na ɲúhṹ mía nì-kéní ɓúi yi, lé bìo ó o lé ĩ nì-kenínii, wón ɓànso á à yí mu cũ̀nú máa khí.» ");
INSERT INTO boxNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bìo ó o Yeesu zéenía mí nì-kenínia vó, ó o ló bĩ́n wà, á wà vaá kàrán ɓa nùpua ká a bue le Dónbeenì bìo ho kɔ̃hṹ mu lórá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bìo ó o Zãn Batiisi wi ho kàsó yi, ó o ɲá bìo ó o *Krista wee wé, ó o tonkaa mí nì-kenínia nùwã yɛn ɓúi ");
INSERT INTO boxNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","le ɓa va a tùa wo yi: «Ũnɛ́n lé fo á wa ɲá bìo le fo ko ũ ɓuen lée, tàá wa pá ko à wa lòoní nì-veere?» ");
INSERT INTO boxNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ó o Yeesu bía nɔn ɓa yi: «Bìo mi wee ɲí làa bìo mi wee mi á mi vaa bío na a Zãn yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ɓa muiiwà yìo wee mi, á ɓa mùamúawà hĩ́nɔn wee varáka. Ɓa ɓùeréwà wee wa. Ɓa bekewà ɲikɔ̃nna wee ɲí mu bìo. Ɓa nì-hía wee vèe. Á le bín-tente wee bue na ɓa nì-khenia yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yìa yí pã́ ĩ bìo ká a tà mu yi, se wón ɓànso ɲúhṹ sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bìo ó o Zãn nì-kenínia bĩnía wà, ó o Yeesu wee bío o Zãn mu bìo lè ɓa zã̀amáa kà síi: «Lée webio á mi van vaá lora le dùure yi? Lée ho konkohó na ho pinpiró wee hɛ́ɛ vĩ́nvã lée? Ɓùeé. ");
INSERT INTO boxNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Á lée webio mí vaá lora? Lée nùpue ɓúi na sĩ̀a hɔ̃̀nbɔ̃̀nɔ̀n le? Bìa wee zĩ́ hɔ̃́n sĩ̀-seníso á wi ɓa pã̀amá-beera zĩní yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","À lé o yɛ́n mi van bìo yi? Lé le *Dónbeenì ɲi-cúa fɛɛro ɓúi le? Ká mu lé wón, se mi tũ̀iá sĩ. O yàá pá po wón, le ĩ bío mu na mia. ");
INSERT INTO boxNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","O Zãn mu lé yìa á le Dónbeenì bíonì vũahṹ bía bìo kà síi: ‹Ĩ ì tonka ĩ tonkaro ò o dí ũ yahó á ɓueé wíoka ũ wɔ̃hṹ›. ");
INSERT INTO boxNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Le ĩ mì ho tũ̀iá na mia: ɓa nùpua na wi ho dĩ́míɲá yi ɓúenɓúen á yìa bìo ɲúhṹ wi po a Zãn wón mía. Ɛ̀ɛ ká le *Dónbeenì bɛ́ɛnì zàwa mɔ́n-dí màhã́ pá po a. ");
INSERT INTO boxNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pã̀ahṹ na ó o Zãn Batiisi wee zéení le Dónbeenì bìo yi à ɓuee ɓúe ho zuia yi, á le Dónbeenì bɛ́ɛnì bìo á ɓa wee firáa lè mi sòobɛ́ɛ. Á bìa wee fi làa bṹn wi ɓa fé mu lè ho pànká. ");
INSERT INTO boxNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Le Dónbeenì ɲi-cúa fɛɛrowà ɓúenɓúen là a *Mɔyiize làndá á bía le Dónbeenì bɛ́ɛnì bìo yi fúuu á ɓueé ɓó a Zãn Batiisi pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ká mi tà le bìo bía ɓúenɓúen bon, se o Zãn mu lé yìa lé o *Elii na ɓuenló bìo fèra bía. ");
INSERT INTO boxNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yìa wee ɲí bìo, à wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","O Yeesu pá bĩnía bía: «Ho zuia nùpua á ĩ dà à tèé lè ɓa yɛ́n? Ɓa ka lè ɓa háyúwá na lée kará ɓa nùpua fèmínló lahó yi, à ɓa wee háaní na mí ninzàwa na zoó le ɓonfónii yi kà: ");
INSERT INTO boxNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Wa ɓúa hã sĩ̀a san, à mi le mi máa lée yo. Wa bó le yèni, á mi le mi máa wá.› ");
INSERT INTO boxNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mi loń. Bìo ó o Zãn ɓuara, á yí máa dí dĩ́n-poni, á mún yí máa ɲu dìvɛ̃́n, á ɓa le o cĩ́ná wi o yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ó o *Nùpue Za ɓɛ̀n ɓuara, á ɓueé wee dí ká a ɲu, á ɓa wee bío bìo kà: ‹Mi loń. O nìi na kà yí máa wé bìo ɓúi ká mu yínɔń dĩ́nló díró làa dìvɛ̃́n ɲuló. O lé ɓa *lànpó féwá lè ɓa nì-kora ɓàn bɔ̃́nlo.›» Ɛ̀ɛ ká le Dónbeenì bè-zũńminì wee zéení mí térénló ɓa bè-zũńlowà bè-wénia yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bṹn mɔ́n, ó o Yeesu wee zá lè hã lórá na ó o wó mu yéréké bìowa cɛ̀rɛ̀ɛ yi, lé bìo á ɓa nùpua na wi hã yi á yí yèrèmáa mi yilera lè mi wárá. O wee bío bìo kà: ");
INSERT INTO boxNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ũnɛ́n Korazɛ̃n lóhó lè ũnɛ́n Bɛtesayidaa lóhó, ho yéréké á à sá mia. Lé bìo ká mu yéréké bìowa na wó mi cɔ̃́n ɓàn síi lá wó ho Tiire lè ho Sidɔ̃n lórá yi, se hã lórá mu nùpua lá hĩ́nɔn hàánì á khuiira hã pórókówá zã́ á kúaa le sãni mi wán, á zéeníanáa le mí wi à mí khí mu bè-kora wéró yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lé bṹn nɔn á ĩ wee bíoráa mu na mia: Le cítíi fĩ̀ nɔ̀nzoǹ á ho Tiire lè ho Sidɔ̃n lórá lònbee na a yí hã, á à wé làa yi minɛ́n lònbee yi. ");
INSERT INTO boxNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Ɛ̀ɛ ká ũnɛ́n *Kapɛɛnayuumu, fo wee leéka le ɓa khíi lá fo á à yòoráa ho wáayi yi le? Ɓùeé. Ho nì-hɔ̃́nbó-lóhó lé hìa ɓa khíi lií dé fo yi. Lé bìo ká mu yéréké bìowa na wó ũ cɔ̃́n ɓàn síi lá wó ho *Sodɔɔmu yi, se ho lóhó mu pá lá wi hàrí lòn zuia. ");
INSERT INTO boxNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lé bṹn nɔn á ĩ wee bíoráa mu na mia: Le cítíi fĩ̀ nɔ̀nzoǹ á ho Sodɔɔmu bìo á à wé làa yi ũnɛ́n bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cĩ́inú bṹn mɔ́n, ó o Yeesu bĩnía wee bío bìo kà: «Ĩ Maá, ũnɛ́n lé ho wáayi lè ho tá Ɲúhṹso, ĩ wee dé ũ bárákà. Lé bìo mu bìo na fo sà mu bè-zũńminì ɓànsowà lè le hácírí ɓànsowà yi á fo tà zéenía làa bìa bìo ɲúhṹ mía. ");
INSERT INTO boxNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ĩ Maá, mu bon. Bìo mu wóráa kà lé bìo sĩ foǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Ĩ Maá dó mu bìo ɓúenɓúen ĩ níi yi. Nìi woon yí zũ a Za, ká mu yínɔń o Maá. Á nìi woon mún yí zũ a Maá, ká mu yínɔń o Za, làa bìa ó o Za mu wi ò o zéení làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Minɛ́n ɓúenɓúen na ho sèró na lì wee beé lò, mi ɓuen ĩ cɔ̃́n, á ĩ na hã vũńnà mia. ");
INSERT INTO boxNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mi lá ĩ zúu bè mi wán à día le ĩ kàrán mia. Lé bìo á ĩnɛ́n wayi, á wee liiní ĩten, á minɛ́n mi bɛɛre á à yí hã vũńnà. ");
INSERT INTO boxNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ĩ zúu na á ĩ bè mi wán á yí lì, á ho sèró na á ĩ bè mi wán á mún záyi.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Cĩ́inú bṹn mɔ́n, ó o Yeesu wee kã́a hã mana ɓúi yi ho *Sabaa zoǹ. Á le hĩni dà a nì-kenínia, á ɓa wee khé ho dĩ́nló na bon dĩ̀n à là. ");
INSERT INTO boxNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bìo ɓa *Farizĩɛwa mɔn mu á ɓa wee bío là a Yeesu: «Loń ũ nì-kenínia. Bìo ɓa wee wé yí ko làa wéró ho Sabaa zoǹ. Wa làndá hò mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ó o Yeesu bía nɔn ɓa yi: «Bìo ó o *Daviide yankaa wó ká arɛ́n lè mí nùpua le hĩni dà á mi dĩǹ yí kàránna yí mɔn le? ");
INSERT INTO boxNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O wà zon le Dónbeenì pɔ̃nsòni bùkú yi, á zoó lá ho búurú na ɓa wó lè mu hãmu á ɓa là. Ká ɓa ɲɔn lá yí ko à ɓa là ho. Le *Dónbeenì yankarowà mí dòn lé bìa á ho làró níi nɔn yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tàá mi so dĩǹ yí kàránna mu o *Mɔyiize làndá yi, le le Dónbeenì yankarowà na wee sá le Dónbeenì pɔ̃nsòni bùkú yi, á máa wé bè ho Sabaa làndá yi ká mu ɲɔǹ pá yí nɔn wé khe le? ");
INSERT INTO boxNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Le ĩ bío mu na mia: Bìo wi hen á ɲúhṹ wi po le Dónbeenì pɔ̃nsòni bùkú. ");
INSERT INTO boxNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ká le Dónbeenì bíonì vũahṹ bíoní na le bía le mínɛ́n màkóo wi le yi na se yi, ká ɓa bà-kùio na ɓa wee wé lè mu hãmu á mí pã́ bìo, á mi lá zũ kúará, se bìa yí wó yí khon á mi lá máa síiní ɲúná. ");
INSERT INTO boxNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lé bìo ó o *Nùpue Za lé yìa á ho Sabaa bìo wi níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bṹn mɔ́n ó o Yeesu ló bĩ́n á wà van ɓa *zúifùwa mu kàránló zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu zoǹ à nìi ɓúi wi bĩ́n á bàhó húrun. Á bìa wi bĩ́n wi ɓa kooní a Yeesu yi. Lé bṹn nɔn á ɓa tùara a yi kà: «Wa làndá yi á nùpue so dà wee wɛɛ́ *Sabaa zoǹ le?» ");
INSERT INTO boxNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ó o Yeesu bía nɔn ɓa yi: «Minɛ́n ó o ɓúi pio yà-kéní mí dòn lá wi síi, á wó wó kùera zon le buii yi ho Sabaa zoǹ, ó o so máa lií lén wo le? ");
INSERT INTO boxNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Á bìo ó o nùpue bìo ɲúhṹ màhã́ wi po a pio hã́. À bṹn wa làndá yi, á nùpue dà à wé tentemu làa nùpue ho Sabaa zoǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bṹn mɔ́n, ó o Yeesu yèrèmáa bía là a nìi: «Hóoní ũ bàhó.» Ó o nìi hóonía mí bàhó, á ho dɛ̀ɛnía wan dĩ̀n làa hìa so bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Á ɓa *Farizĩɛwa wà ló, á bìo ɓa à wé á à yíráa o Yeesu á à ɓúe lé bṹn ɓa lée wee wã̀aní wán. ");
INSERT INTO boxNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bìo ó o Yeesu zũna mu, ó o ló bĩ́n wà. Á ɓa minka zã̀amáa bò a yi. Ó o wɛɛ́ra ɓa vánvárowà ɓúenɓúen na wi bĩ́n, ");
INSERT INTO boxNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ká a màhã́ henía mu nɔn ɓa yi le ɓa yí bá mí bìo na nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mu wó kà síi, bèra a na ò o ɲi-cúa fɛɛro *Ezayii bíoní na kà à ɲii sí. ");
INSERT INTO boxNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Le le Dónbeenì bía: «Yìa kà lé ĩ ton-sá na á ĩ mɔn léra, yìa á ĩ bò ĩ tàká wán. Ĩ sĩi wan o bìo yi. Ĩ ì liiní ĩ Hácírí o wán, o ò bue ĩ cítíi bìo á à na hã sìíwà yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O làa nùpue máa wã̀aní. O máa wãamaka bìo. Ɓa máa ɲí a sã ɓonfúaa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Le nàaninle na ɲumaa ó o máa khé máa día. Á le fĩ̀ntã́ní na wee hí ó o mún máa ɓúe. O ò ɓua míten kà síi, fúaa bìo ó o térénló bìo yòó có ló, ");
INSERT INTO boxNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","á hã sìíwà ɓúenɓúen màhã́ à dé mí sĩa wo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɓa ɓuan o nìi ɓúi ɓuararáa o Yeesu cɔ̃́n ò o cĩ́ná wi o yi, ó o lé o muii á mún yí dà máa bío. Ó o Yeesu wɛɛ́ra a, ó o ɲii dɛ̀ɛnía fá á wee bío, á mún wee mi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Á ɓa zã̀amáa wó coon mu bìo yi, á ɓa wee bío: «Yìa kà màhã́ lé o *Daviide Za lée?» ");
INSERT INTO boxNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ká bìo ɓa *Farizĩɛwa ɲá mu, á ɓa wee bío: «O nìi na kà á wee ɲa ɓa cĩ́náwa lén bìa ɓa wi yi là a *Bɛlezebuule pànká, yìa lé ɓa cĩ́náwa ɲúhṹso.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ká a Yeesu màhã́ zũna ɓa yilera, ó o bía nɔn ɓa yi: «Kɔ̃hṹ lée kɔ̃hṹ na nùpua wee fi mín yi á à fì ì vé. Lóhó lée lóhó, tàá zĩi lée zĩi na nùpua wee fi mín yi á ɲúhṹ á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ká bìo ó o *Satãni te ó o wee bĩní ɲa se o wee fi lè míten. Á bìa bìo sã̀ a yi ɲúhṹ so máa ɓúe le? ");
INSERT INTO boxNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","«Mi wee bío le ĩ wee ɲa ɓa cĩ́náwa lé bìo ó o Bɛlezebuule wee na mu ɓàn pànká miì. Ká lé bṹn mu wóráa, á yìa ɓɛ̀n wee na ho pànká minɛ́n nùpua yi à ɓa ɲa lè ɓa cĩ́náwa lé o yɛ́n? Bìa làa mia lée dà-kéní bán mí bɛɛre yàá wee zéení le mi bìo yí bon. ");
INSERT INTO boxNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ká le Dónbeenì Hácírí lé dìo wee na ho pànká ĩnɛ́n yi, à ĩ ɲa lè ɓa cĩ́náwa, se bṹn wee zéení le le *Dónbeenì bɛ́ɛnì á dɛ̀ɛnía ɓueé ɓó mia. ");
INSERT INTO boxNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Nìi woon yí dà máa zo pànká ɓànso zĩi á máa zoó khuii o níi bìo, ká a yí can o pànká ɓànso mu yí vó. Ká a màhã́ can wo vó, ó o zoó khuii bìo wi o zĩi ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Yìa yí wi làa mi, se wón wee fi làa mi. Á yìa mún yí máa séení mi ho vá kúeemínwánló yi, se wón wee saawaní. ");
INSERT INTO boxNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Lé bṹn nɔn á ĩ wee bío mu na mia: Ɓa nùpua bè-kora na ɓa wó ɓúenɓúen lè hã bín-kora na ɓa bía ɓúenɓúen, á bìo khíi sɛ́n ǹ día á à na ɓa yi. Ká yìa bía khon le Dónbeenì Hácírí dã́ní yi, wón ɓa khíi máa sɛ́n bìo máa día. ");
INSERT INTO boxNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yìa bía le bín-kohó o *Nùpue Za dã́ní yi, wón ɓa à sɛ́n ǹ día á à na yi. Ká yìa bía khon le Dónbeenì Hácírí dã́ní yi, wón ɓa khíi máa sɛ́n máa día máa na yi, hàrí ho zuia.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Hen ká le vĩ̀ndɛ̀ɛ se, à le bìa wé sĩ. Ká le vĩ̀ndɛ̀ɛ yí se, à le bìa máa wé sĩ. Le vĩ̀ndɛ̀ɛ semu wé zũ hã bìa na lé wee ha yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Díhioni yɛ́n! Bìo mi yí se, á mi dà à wé kaka á à bíoráa mu bìo na se. O nùpue bìo na wi o sĩi yi, bṹn lé bìo ó o wee wé bío. ");
INSERT INTO boxNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","O nùpue na se wón wee wé bío hã bín-tentewà, lé bìo á bìo wi o sĩi yi se. Ká yìa yí se wón wee wé bío hã bín-kora lé bìo á bìo wi o sĩi yi yí se. ");
INSERT INTO boxNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Le ĩ mì ho tũ̀iá na mia: Le Dónbeenì cítíi fĩ̀ nɔ̀nzoǹ, á hã bín-conconwà na ɓa nùpua bía á ɓa à zéení ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lé bìo á ũ ɲi-cúa lé hĩ̀a ɓa à dĩ̀n wán á à fĩ̀náa le cítíi á à zũńnáa ká ũ térénna, tàá ká ũ yí térénna.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Á ho *làndá bìo zéenílowa lè ɓa *Farizĩɛwa nùwã yɛn ɓúi wã́a bía nɔn o Yeesu yi: «Nì-kàránlo, wa wi à ũ wé bìo ɓúi à wa mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ó o Yeesu bía nɔn ɓa yi: «Ho zuia nùpua na yí se, na wee bĩní le Dónbeenì mɔ́n à wé mu bè-kora, á wee cà à ɓa mi yéréké bìo. Ɛ̀ɛ ká ɓa máa mi yéréké bìo ɓúi ká mu yínɔń le *Dónbeenì ɲi-cúa fɛɛro Zonaasi bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mu bon. O Zonaasi wó hã wizooní bìo tĩn lè mí tĩ́nɔ̀nna bìo tĩn o ceza píohó yi. Lé kà síi ó o Nùpue Za mún khíi wéráa hã wizooní bìo tĩn lè hã tĩ́nɔ̀nna bìo tĩn ho tá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ho Niniivesa yèrèmáa mí yilera lè mí wárá, lé bìo ɓa ɲá a Zonaasi bíonì. À yìa wi minɛ́n tĩ́ahṹ, wón bìo ɲúhṹ wi po a Zonaasi. Lé bṹn nɔn á le Dónbeenì cítíi fĩ̀ nɔ̀nzoǹ, á ho Niniivesa mu á à hĩ́ní ì dĩ̀n ho lònbìo nùpua yahó, á à kooní ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","O bɛ́ɛ hã́a na hĩ́a wi ho Saba kɔ̃hṹ ɲúhṹ wán á hĩ́a ló lùe na dã́ní nà yi làa sòobɛ́ɛ, á ɓueé ɲá a *Salomɔn bè-zũńminì bíoní. À yìa wi minɛ́n tĩ́ahṹ, wón bìo ɲúhṹ wi po a Salomɔn. Lé bṹn nɔn á le Dónbeenì cítíi fĩ̀ nɔ̀nzoǹ, ó o bɛ́ɛ hã́a mu á à hĩni ì dĩ̀n ho lònbìo nùpua yahó á à kooní ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Hen ká a cĩ́ná ló a nùpue na ó o lá wi yi, ò o vaa hɛ́ɛ vará le dùure yi, à cà ho lahó na ó ò kɛɛní á à vũń yi ká a máa yí ho. Ká a hĩ́a cà san, ");
INSERT INTO boxNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ò o bío mí yi: ‹Ĩ ì bĩní ì va hen na á ĩ ló yi.› Ká a bĩnía van bĩ́n ò o vaa yí ho lahó mu mí kã́amáa ká ho sàara, á wíokaa sesese. ");
INSERT INTO boxNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ká a mɔn mu, ò o bĩní vaa fé ɓa cĩ́náwa bùaa hèɲun na ɓɛ̀n ɲii po arɛ́n, à ɓa páaní ɓuee zoo kɛɛní cìcàkà ho lahó mu yi. Ká mu wó kà, à wón nùpue so bìo wíoka yáa poń bìo mu fù karáa. Lé làa bṹn síi á ho lònbìo nùpua na yí se bìo khíi wéráa.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","O Yeesu wee bío lè ɓa zã̀amáa, à bṹn à ɓàn nu lè ɓàn zàwa ɓueé dɔ̃n. Ɓa lée dĩ̀n ho khũuhũ, á wi ɓa bío làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ó o ɓúi bía là a Yeesu: «Loń. Mìn nu lè mìn zàwa lée dĩ̀n ho khũuhũ á wi ɓa bío làa fo.» ");
INSERT INTO boxNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ó o Yeesu bía lè ɓànso: «Wàn nu lé o yɛ́n? Á wàn zàwa lé ɓa yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bṹn mɔ́n ó o dá mí níi mí nì-kenínia yi ò o bía. «Mi loń. Wàn nu lè wàn zàwa wi hen. ");
INSERT INTO boxNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lé bìo á yìa wee wé wàn Maá na wi ho wáayi sĩi bìo, wón lé wàn za, lè wàn hĩ́nló, lè wàn nu.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bṹn zoǹ ó o Yeesu hĩ́nɔn le zĩi yi ló, à wà vaá kará ho vũ-beenì ɲii, á wee kàrán ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɓa minka zã̀amáa kĩ́nía wo yi, ó o wó san zon ho woohṹ á zoó kará, à ɓa zã̀amáa bán dĩ̀n mu ɲumu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O wee wà hã wàhio à kàránnáa ɓa nùpua làa bìo cɛ̀rɛ̀ɛ. O bía: «Nìi ɓúi ló van mí mɔhṹ yi, á wà vaá dé mí bè-dà. ");
INSERT INTO boxNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bìo ó o wee dé mu á mu ɓúi lion ho wɔ̃hṹ nìsã́ní, á ɓa ɲínzàwa sèekaa bṹn vã̀. ");
INSERT INTO boxNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mu ɓúi lion ho ɓúaahó na le tĩ́ní wi wán ká le yí lì, á mu dɛ̀ɛnía ló, lé bìo le tĩ́ní yí boo bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bìo le wii ɲá lè mí sòobɛ́ɛ, á ho dĩ́nló na ló wĩ́níwĩ́ní á hon, lé bìo ho naní yí vá yí lion. ");
INSERT INTO boxNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mu ɓúi lion hen na hã kíkara bia hɛ́ra yi, á mu ló, á hɔ̃́n kíkara so hĩ́nɔn yòó pà mu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mu ɓúi bṹn lion ho tá na se yi, á mu ló, á yòó han mí bia. Hã ɓúi yú khĩmàni khĩmàni, hã ɓúi yú ɓúará-tĩn tĩn, hã ɓúi yú ɓóní làa pírú pírú.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","O Yeesu pá bĩnía bía bò mu wán: «Yìa wi ò o ɲí bìo, á wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ó o nì-kenínia vá ɓueé ɓó a yi, á wee tùa wo yi. «Lée webio nɔn fo wee wàráa hã wàhio na ɓa yi?» ");
INSERT INTO boxNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ó o Yeesu bía nɔn ɓa yi: «Le Dónbeenì wó á le bɛ́ɛnì bìo na sà yi á mi yú zũna, à ɓa nì-vio yí zũna mu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lé bìo á yìa bìo wi á ɓa khíi bĩní yòó bè mu ɓúi wán á à na a yi, ó o bìo á à wé boo. Ká yìa dɛ̀ɛ ɓúi mía, wón á hàrí mu bè-za na ó o wee leéka le mu wi mi cɔ̃́n á ɓa pá à fé. ");
INSERT INTO boxNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lé bṹn nɔn á ĩ wee wàráa hã wàhio na ɓa yi. Ɓa wee loń coon, ká ɓa yí máa mi. Ɓa wee ɲí mu bìo ká ɓa yí máa ɓua mu à zũń kúará. ");
INSERT INTO boxNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lé kà síi á le *Dónbeenì ɲi-cúa fɛɛro *Ezayii bìo na ó o bía ɓa dã́ní yi á ɲii súráa. O bía bìo kà: ‹Mi khíi wee ɲí mu bìo ká mi máa zũń mu kúará. Mi khíi wé è loń coon ká mi máa mi hàrí dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mu nìpomu na kà ɓɛ̀ntĩ́n bɔ̃́nbúra. Ɓa tun mí ɲikɔ̃nna, á muunía mí yìo. Ɓa yí wi à ɓa mi bìo. Ɓa mún yí wi à ɓa ɲí bìo. Ɓa yí wi à ɓa zũń mu bìo à yèrèmá ɓuen ĩnɛ́n Dónbeenì cɔ̃́n à ĩ wɛɛ́ ɓa.› ");
INSERT INTO boxNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ɛ̀ɛ ká minɛ́n bán ɲúná sĩ. Mi yìo wee mi, á ɲikɔ̃nna mún wee ɲí mu bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Le ĩ mì ho tũ̀iá na mia: Le Dónbeenì ɲi-cúa fɛɛrowà cɛ̀rɛ̀ɛ lè ɓa nùpua ɓúi na térénna á sĩa hĩ́a vá à ɓa mi bìo minɛ́n wee mi, à ɓa yí mɔn mu. Ɓa sĩa hĩ́a vá à ɓa ɲí bìo minɛ́n wee ɲí, à ɓa yí ɲá mu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Mi wã́a ɲí yìa wee dé mu bè-dà wàhiire kúará. ");
INSERT INTO boxNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bìa wee ɲí le *Dónbeenì bɛ́ɛnì bìo á ɓa yí zũ mu kúará á ka lè ho wɔ̃hṹ nìsã́ní na mu bè-dà lion yi. O *Satãni wee ɓuee lén mu ɓa sĩa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɓa ɓúi ka lòn ɓúaahó. Ɓa wee ɲí le Dónbeenì bíonì, à tà le yi fùafùa, à zã̀maka le bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ká ɓa màhã́ yí máa día à le zo ɓa. Ɓa wee tà le bìo ho pã̀ahṹ na cĩ́inú yi mí dòn. Ká le lònbee, tàá ho kúará lénló yú ɓa le Dónbeenì bíonì bìo yi, à ɓa dɛ̀ɛní pĩ́ le Dónbeenì bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɓa ɓúi ka lè ho tá na hã kíkara bia hɛ́ra yi á mu bè-dà lion yi. Ɓa ɲá le Dónbeenì bíonì, ká ho dĩ́míɲá bìo yilera, lè ho nàfòró poni na wee khà ɓa nùpua, á wee hè le bíonì mu, à le máa wé bìo ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓa ɓúi ɓɛ̀n ka lè ho tá na se bìo, na mu bè-dà lion yi. Ɓa wee ɲí le Dónbeenì bíonì, à zũń le kúará, á ɓa ɓɛ̀n wee ha hã bia. Ɓa ɓúi khĩmàni khĩmàni, ɓa ɓúi ɓúará-tĩn tĩn, ɓa ɓúi ɓóní làa pírú pírú.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","O Yeesu bĩnía wà le wàhiire ɓúi nɔn ɓa yi: «Ho wáayi bɛ́ɛnì bìo ɓonmín làa bìo kà: Nìi ɓúi dó mu bè-dà tente mí mɔhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Á ho tĩ́nàahṹ ɓúi ká ɓa nùpua ɓúenɓúen dũma, ó o nìi mu zúkúso ɓuara, á ɓueé dó le ɲíní bia ho mɔhṹ mu yi, ò o bĩnía wà. ");
INSERT INTO boxNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pã̀ahṹ na ho dĩ́nló ló á yòó wee te yi, á le ɲíní mún lií ló. ");
INSERT INTO boxNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Á ho mɔhṹ ɓànso ton-sáwá bía nɔn wo yi: ‹Ɲúhṹso, fo yí dó mu bè-dà tente ũ mɔhṹ yi le? Á le ɲíní ɓɛ̀n ló wen bĩ́n.› ");
INSERT INTO boxNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ó o bía nɔn ɓa yi: ‹Lé ĩ zúkúso wó mu.› Ó o ton-sáwá bía: ‹Fo wi à wa vaa dɛɛ le ɲíní mu le?› ");
INSERT INTO boxNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Á ho mɔhṹ ɓànso bía nɔn ɓa yi: ‹Ɓùeé. Mi día, lé bìo ká mi le mi ì dɛɛ le ɲíní ká mi yí wó sese á mi ì dɛɛ le á à lɛɛ́ lè ho dĩ́nló. ");
INSERT INTO boxNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mi día le mu páaní dã fúaa ho dĩ́nló láró pã̀ahṹ. Hón pã̀ahṹ so yi, ká ĩ bío ò na ɓa ton-sáwá na à lá ho dĩ́nló yi le ɓa dɛɛ le ɲíní vé, à kúia lè mí kúnkúwá à cĩ̀í. Bṹn mɔ́n à ɓa màhã́ lá ho dĩ́nló kúee ĩ nání yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O Yeesu tĩ́n bĩnía wà le wàhiire ɓúi nɔn ɓa yi: «*Le Dónbeenì bɛ́ɛnì bìo ɓonmín lè ho mútáàdè bɛɛre na ó o nìi ɓúi vaá dù mí mɔhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lé ka cĩ́inú po hã bia na ká ɓúenɓúen. Ká le màhã́ ló, à le dã poń ho zen-ɓuahó bè-vànii ɓúenɓúen, à wé mí vĩ̀ndɛ̀-kùure, à ɓa ɲínzàwa wé ɓuee tá mí lɛnna lakara wán.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O Yeesu bĩnía wà le wàhi-veere ɓúi nɔn ɓa yi: «Ho wáayi bɛ́ɛnì bìo ɓonmín lè le ɲa-fĩni na ó o hã́a ɓúi zúnzúio kúaa mu dũmu kiloowa ɓóní làa hònú yi á khan bàrá á mu ló.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bṹn ɓúenɓúen ó o Yeesu wee wà lè hã wàhio à na ɓa zã̀amáa yi. O hĩ́a yí máa wé kàrán ɓa ká a yí wà wàhio. O hĩ́a wee wé kà síi, ");
INSERT INTO boxNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","bèra a na à le *Dónbeenì ɲi-cúa fɛɛro bìo na ó o bía à ɲii sí: «Ĩ khíi wé è bío làa ba lè hã wàhio. Mu bìo na sà yi hàrí ho dĩ́míɲá ɲúhṹ ɓúɛɛníi á ĩ khíi zéení yara làa ba.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bṹn mɔ́n ó o Yeesu wà vaá zon le zĩi yi ò o día ɓa zã̀amáa. Ó o nì-kenínia wà zon o cɔ̃́n, á zoó bía làa wo: «Le ɲíní na ló ho mɔhṹ yi wàhiire kúará á ũ zéení làa wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ó o Yeesu bía nɔn ɓa yi: «Yìa wee dé mu bè-dà tente lé o *Nùpue Za. ");
INSERT INTO boxNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ká ho mɔhṹ lé ho dĩ́míɲá. Mu bè-dà tente lé bìa bìo sã̀ le Dónbeenì bɛ́ɛnì yi. Ká le ɲí-kohó lé bìa bìo sã̀ o *Satãni yi. ");
INSERT INTO boxNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O zúkúso na dó le ɲí-kohó bia lé o Satãni. Ho dĩ́nló láró wee zéení ho dĩ́míɲá véró bìo. Ká ɓa ton-sáwá na wee lá ho dĩ́nló lé le Dónbeenì wáayi tonkarowà. ");
INSERT INTO boxNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bìo ɓa wee dɛɛráa le ɲíní à kúee ho dɔ̃hṹ yi, lé bṹn ɓàn síi mu khíi wéráa ho dĩ́míɲá véró pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","O Nùpue Za khíi tonka mí wáayi tonkarowà, á ɓa ɓueé lén bìa wee khà bìa ká dé mu bè-kora wéró yi, làa bìa wee wé mu bè-kora. ");
INSERT INTO boxNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ɓa khíi kúee ɓa ho dã-sũmúi yi, hen na le minka yi vɛ́ɛ wi yi, á ɓa à wá bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ká bìa térénna bán á à ɲuiíka lè le wii bìo síi mín Maá Dónbeenì bɛ́ɛnì yi. Yìa wi ò o ɲí bìo, à ɓànso ɲí bìo bía sese. ");
INSERT INTO boxNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ho wáayi bɛ́ɛnì bìo ɓonmín lè mu bè-senì ɓúi na ɓa lú ho mɔhṹ yi. Ó o ɓúi zũna mu dã́ní vaá khɛ́ra á bĩnía sã̀ vaá lú. O sĩi wan wan, á vaá yɛ̀ɛ́ra bìo wi o cɔ̃́n ɓúenɓúen, ò o ɓueé yà ho mɔhṹ mu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ho wáayi bɛ́ɛnì bìo ɓonmín là a duanlo ɓúi na wee cà ho lóró na yàwá here. ");
INSERT INTO boxNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bìo ó o yú ho ɓúi na yàwá here, ó o vaá yɛ̀ɛ́ra bìo wi o cɔ̃́n ɓúenɓúen, ò o yà ho lóró mu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ho wáayi bɛ́ɛnì bìo pá bĩnía ɓonmín lè ho zùán na ɓa wee lèe dé ho muhṹ yi à vĩnáa ɓa cewà lè mí sìíwà. ");
INSERT INTO boxNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ká ho sú, à ɓa ce-pawà vá ho léráa mu ɲumu ɲii, à lée kɛɛní ká ɓa hueeka ɓa. Á bìa se ɓa wee kúee mí sàkíwá yi, ká bìa yí se bán ɓa wee kúia. ");
INSERT INTO boxNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lé bṹn ɓàn síi khíi wé ho dĩ́míɲá véró pã̀ahṹ. Le Dónbeenì wáayi tonkarowà á ɓueé lén bìa yí térénna bìa térénna tĩ́ahṹ, ");
INSERT INTO boxNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","á à kúee ho dã-sũmúi yi, hen na le minka yi vɛ́ɛ wi yi, á ɓa à wá bĩ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bṹn mɔ́n ó o Yeesu tùara ɓa yi: «Bìo kà ɓúenɓúen mi zũ kúará le?» Á ɓa le ũuu. ");
INSERT INTO boxNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ó o Yeesu wã́a bía nɔn ɓa yi: «*Làndá bìo zéenílo lée làndá bìo zéenílo na kenía míten á zũ ho wáayi bɛ́ɛnì bìo ɲúhṹ á ka lòn zĩi ɓànso ɓúi na nàfòró á mu bè-fĩa lè mu bè-kĩ́a wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bìo ó o Yeesu wà hɔ̃́n wàhio so vó, ó o ló bĩ́n, ");
INSERT INTO boxNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","á wà van ho lóhó na ó o dɔ̃n yi. O wà vaá wee kàrán ɓa nùpua ɓa *zúifùwa kàránló zĩní yi. Á ɓa nùpua na wi bĩ́n ɓúenɓúen wó coon á ɓa wee bío: «Bṹn bè-zũńminì so ó o yú wen? O wó kaka wee wéráa mu yéréké bìowa na kà? ");
INSERT INTO boxNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yínɔń o ɓùɛn-khɛ̀ɛro te mí za le? Á ɓàn nu yínɔń o Mari le? O Zaaki là a Zozɛɛfu là a Simɔn là a Zude so yínɔń ɓàn zàwa le? ");
INSERT INTO boxNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Á ɓàn hĩ́nni so làa wɛn yí wi mín wán hen le? Á lé wen ó o yú hón pànká so ɓúenɓúen yi?» ");
INSERT INTO boxNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lé bṹn bìo yi á ɓa yí wi à ɓa dé mí sĩa wo yi. Ó o Yeesu wã́a bía nɔn ɓa yi: «Le *Dónbeenì ɲi-cúa fɛɛro wé yí le kɔ̃̀nbii hã lùa ɓúenɓúen yi. Ká ɓa lóhósa lè ɓàn kùrú zĩi nùpua bán máa wé kɔ̃̀nbi o.» ");
INSERT INTO boxNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","O Yeesu yí dàńna yí wó yéréké bìo cɛ̀rɛ̀ɛ bĩ́n lé bìo ɓa sĩadéró wo yi fòora. ");
INSERT INTO boxNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mu pã̀ahṹ ó o *Heroode na wi ho Kalilee kɔ̃hṹ ɲúhṹ wán á ɲá bìo ɓa wee bío o Yeesu dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ó o bía nɔn mí mɔ́nsa na làa wo páanía wi yi: «O nùpue mu na kà lé o Zãn bĩnía vèera. Lé bṹn nɔn ó o dà wee wéráa mu yéréké bìowa.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mu bon. O Heroode hĩ́a nɔn le ɲii le ɓa wìi o Zãn. Á ɓa wìira a can dó ho kàsó yi. O Heroode wó mu lé bìo ó o Zãn bía nɔn wo yi le o lá yí ko ò o fé mín za Filiipu ɓàn hã́a Herodiade à ya. ");
INSERT INTO boxNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O Heroode lá wi ò o ɓúe o Zãn ká a màhã́ zã́na ɓa zã̀amáa lé bìo ɓa ɓúenɓúen wee leéka le o Zãn lé le *Dónbeenì ɲi-cúa fɛɛro. ");
INSERT INTO boxNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɛ̀ɛ ká a Heroode teró wizonle sã́nú díró yi, ó o Herodiade hĩ́nló yon bìa ɓa von yahó. Ó o Heroode mu sĩi wan mu yi, ");
INSERT INTO boxNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ó o báa le ká a hĩ́nzoró mu fìora bìo na mí cɔ̃́n á mí ì na mu wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ó o hĩ́nzoró vaá bía mu nɔn mín nu yi, á ɓàn nu le o bío le o Zãn Batiisi ɲúhṹ lé hìa à ɓa dé ho lɛnɓuɛn yi à na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bìo ó o hĩ́nzoró ɓueé bía mu, ó o bɛ́ɛ sãnía tò mu bìo yi. Ká bìo ó o báa bìa ó o von yahó, ó o nɔn le ɲii le ɓa wé mu na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ò o tonkaa o ɓúi le o va ho kàsó yi à vaa kúii o Zãn Batiisi ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Á ɓa vaá kúio ho dó ho lɛnɓuɛn yi ɓueé nɔn o hĩ́nzoró yi ó o ɓuan vaá nɔn mín nu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ó o Zãn mu nì-kenínia ɓueé lá a nùuna, à ɓa wà vaá bía bìo mu wóráa á nɔn o Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bìo ó o Yeesu ɲá bìo wó kà, ó o zon ho woohṹ wà, á wi ò orɛ́n mí dòn va ho lahó ɓúi na á nùpue mía yi. Ká ɓa nùpua màhã́ zũna mu. Á ɓa lóka hã lórá yi á vará mu ɲumu ɲii bò a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pã̀ahṹ na ó o zoó ló ho woohṹ yi, ó o mɔn ɓa minka zã̀amáa. Á ɓa màkárí ɓuan wo yi, ó o ɓúakáa wee wɛɛ́ ɓa vánvárowà na wi ɓa tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bìo ho zĩihṹ dɔ̃n, ó o nì-kenínia wà ɓueé ɓó a yi, á bía nɔn wo yi: «Le wii tò, à ho lahó na kà á bìo ɓúi mún mía yi. Bío le ɓa nùpua lɛ́n va hã lórá yi, à vaa yí mu bìo yà dí.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ó o Yeesu bía nɔn ɓa yi: «Ɓa varó bĩ́n ɲúhṹ mía. Minɛ́n miten na mu bè-dínii ɓa yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Á ɓa bía nɔn wo yi: «Bìo wi wa cɔ̃́n hen, lée búurú bi-zàwa bìo hònú làa cezàwa bùaa ɲun.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ó o Yeesu bía: «Mi ɓua mu ɓuennáa.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ò o bía nɔn ɓa zã̀amáa yi le ɓa lií kɛɛní le ɲíní wán. Ò o fó ho búurú bìo hònú lè ɓa cezàwa bùaa ɲun, ò o hóonía mí yahó ho wáayi, ò o dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho búurú nɔn mí nì-kenínia yi. Á bán fó sankaa nɔn ɓa zã̀amáa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Á ɓa ɓúenɓúen dú sù. Á bìo dú ká ɓa khuiira á mu sú hã sàkíwá pírú ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bìa ɓúenɓúen na dú mu, á ɓa báawa mí dòn á à yí ho muaaseé hònú síi, ká ɓa hã́awa lè ɓa háyúwá níi ló. ");
INSERT INTO boxNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bṹn mɔ́n, ó o Yeesu dɛ̀ɛnía kĩ̀kã́a mí nì-kenínia yi le ɓa zo ho woohṹ dí mí yahó khí ho vũ-beenì mɔ́n ká mínɛ́n ǹ na ho wɔ̃hṹ ɓa zã̀amáa yi á ɓa à ɓoka. ");
INSERT INTO boxNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bìo ó o wó bṹn vó, ó o wà yòora le ɓúee wán mí dòn, á yòó wee wé mí fìoró á ho tá hũn yú bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bṹn pã̀ahṹ à ho woohṹ vá zon mu ɲumu yi, á ho pinpi-beenì hĩ́nɔn wee và lè mí pànká á wee lá mu ɲumu ɓuee hénka lè ho woohṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hã tá-tĩa yi, ó o Yeesu zoó wee varáka mu ɲumu wán á mà mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bìo ɓa mɔn wo ò o wee varáka mu ɲumu wán, á ɓa zã́na dàkhĩína, á ɓa wee bío: «O lée nì-hɔ̃́nbóní.» À ɓa wee wãamaka. ");
INSERT INTO boxNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ó o Yeesu dɛ̀ɛnía bía kà síi nɔn ɓa yi: «Mi hení mí sĩa, mu lé ĩnɛ́n, mi yí zɔ̃́n bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ó o Piɛre wã́a bía nɔn wo yi: «Ɲúhṹso, ká mu lé fo bìo bon, ũ bío le ĩ varáka mu ɲumu wán à ɓuen ũ cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ó o Yeesu bía nɔn wo yi: «Ɓuen!» Ó o Piɛre ló wee varáka mu ɲumu wán á wee va a Yeesu cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ká bìo ó o mɔn bìo ho pinpiró wee wéráa ó o zã́na. Á bìo ó o wà lií lí mu ɲumu yi, ó o wãamaa: «Ɲúhṹso fení mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ó o Yeesu dɛ̀ɛnía dá mí níi cãna a, ò o bía nɔn wo yi: «Ũ sĩidéró fòora. Lée webio nɔn á fo titikaaráa?» ");
INSERT INTO boxNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bìo ɓa mí nùwã ɲun yòó zon ho woohṹ yi, á ho pinpiró dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Á ɓa nì-kenínia na wi ho woohṹ yi á fárá mí nɔnkóɲúná wán o Yeesu yahó, à ɓa bía nɔn wo yi: «Fo ɓɛ̀ntĩ́n lé le Dónbeenì Za bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bìo ɓa kã́a ho vũ-beenì khíi dɔ̃n ho Zenɛzarɛɛte kɔ̃hṹ, ");
INSERT INTO boxNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","á ɓa nùpua na wi bĩ́n zũna a Yeesu, á ɓa bía a ɓuenló bìo nɔn bìa sùarákaa bĩ́n ɓúenɓúen yi. Á ɓa ɓuan ɓa vánvárowà ɓúenɓúen ɓuararáa o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","À ɓa wee fìo wo le o día le ɓa pá wã́a yí o dà-zĩ́nii ɲi-kã́ní tṹii yi. Á bìa ɓúenɓúen na wee yí le tṹii yi á wee wa. ");
INSERT INTO boxNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɓa *Farizĩɛwa ɓúi lè ho *làndá bìo zéenílowa ɓúi ló ho Zeruzalɛɛmu yi ɓuara a Yeesu cɔ̃́n á ɓueé tùara a yi: ");
INSERT INTO boxNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Lée webio nɔn á ũ nì-kenínia yí máa wé bìo á wàn maáwà bò nɔn wɛn le wa wé wé? Ɓa yí máa sɛɛ mí níní à bè yi díráa làa bìo mu koráa.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ó o Yeesu bía nɔn ɓa yi: «Lée webio nɔn á minɛ́n ɓɛ̀n yí máa wé bìo le Dónbeenì henía nɔn mia, à mi bò mi kùrú kàránló yi? ");
INSERT INTO boxNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Le Dónbeenì bía bìo kà: ‹Kɔ̃̀nbi mìn maá lè mìn nu› le mún bía: ‹Yìa bía khon mín maá tàá mín nu dã́ní yi, wón ko làa ɓúeró.› ");
INSERT INTO boxNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ká minɛ́n wee kàrán ɓa nùpua le ká a ɓúi ɓàn maá lè ɓàn nu ó o bía bìo kà nɔn yi: ‹Bìo á ĩ ko à ĩ na à séení làa fo á ĩ hɔ̃n lè le Dónbeenì,› ");
INSERT INTO boxNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","se wón ɓànso màkóo mía ò o séení mín maá. Mi wee pĩ́ le Dónbeenì bíonì kà síi à wé le làa bè-kã́amáa ká mi bè mi kùrú kàránló yi. ");
INSERT INTO boxNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi yí mɔn miten na le? Yaa o *Ezayii tũ̀iá sĩ mi wán pã̀ahṹ na ó o fɛɛra le *Dónbeenì ɲi-cúa na kà mi dã́ní yi: ");
INSERT INTO boxNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Ɓa nùpua na kà wee ɓùaaní mi lè mí ɲiní ká ɓa yiwa yi á ɓa khɛ̀ra làa mi. ");
INSERT INTO boxNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Le ɓùaaníi na ɓa wee na miì ɲúhṹ mía. Lé bìo ɓa nùpua làndáwá lé hĩ̀a ɓa wee kàrán làa mín.›» ");
INSERT INTO boxNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bṹn mɔ́n ó o Yeesu von ɓa zã̀amáa á bía nɔn ɓa yi: «Mi ɲí bìo kà à zũń kúará. ");
INSERT INTO boxNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bìo wee zo a nùpue ɲii yí máa tií wo. Hã bíoní na wee lé là a nùpue ɲii, hɔ̃́n lé hĩ̀a wee tií wo.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ó o Yeesu nì-kenínia vá ɓueé ɓó a yi, á bía nɔn wo yi: «Fo zũ le ũ bíoní mu á vá ɓa *Farizĩɛwa yi le?» ");
INSERT INTO boxNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ó o Yeesu bía nɔn ɓa yi: «Bè-fánii lée bè-fánii na á ĩ Maá na wi ho wáayi á yí fá, á khíi dɛɛ á à kúia. ");
INSERT INTO boxNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mi día ɓa. Ɓa lé ɓa muiiwà na tò ɓa muiiwà bũ̀aa wán. Ká a muii tò mí ninza muii bũ̀ini wán, á ɓa à páaní vaá zo ho kɔ̃hṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ó o Piɛre wã́a bía nɔn wo yi: «Zéení le wàhiire mu kúará làa wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ó o Yeesu bía nɔn wo yi «Éee! Lé minɛ́n pá dĩǹ yí zũ mu bìowa yara le? ");
INSERT INTO boxNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mu bìo ɓúenɓúen na wee zo a nùpue ɲii, à lii zo a píohó yi, bṹn ó o wee bĩní lée ní kúia. ");
INSERT INTO boxNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ɛ̀ɛ ká hã bíoní na ó o wee bío lè mí ɲii, á wee lé o sĩi yi, hɔ̃́n lé hĩ̀a wee tií o nùpue. ");
INSERT INTO boxNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mu bon. Hã yile-kora wee lé le sĩi yi. Lé bṹn te le nì-ɓúee, lè ho hã́-fénló lè ho bá-fénló lè mí sìíwà, lè ho kɔ̃̀nló, làa bìo yí bon bíoró o nùpue ɲii, lè ɓa nùpua yènnáa yáaró. ");
INSERT INTO boxNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bṹn bìowa so lé bío wee tií o nùpue, ká ho dí le hã níní na yí sɛɛra, bṹn yí máa tií nùpue.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bṹn mɔ́n ó o Yeesu ló bĩ́n wà, á van ho kɔ̃hṹ ɓúi na sùaráa ho Tiire lè ho Sidɔ̃n lórá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Á ho Kanan kɔ̃hṹ hã́a ɓúi na wi ho kɔ̃hṹ mu yi, á wà ɓuara a cɔ̃́n, á ɓueé wee bío pɔ̃́npɔ̃́n kà síi: «Ɲúhṹso, *Daviide Za, màkárí miì. Ĩ hĩ́nló á cĩ́ná ɓúi wi yi á wee beé o lò làa sòobɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ó o Yeesu yí dó mí ɲii wo yi. Ó o nì-kenínia vá ɓueé ɓó a yi, á wee bío làa wo: «O hã́a mu na bò wá mɔ́n wee wãamaka fɛ́ɛɛ á ũ bío le o bĩní.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ó o Yeesu bía: «O *Isirayɛɛle nìpomu na ka lòn pia na vṹnun lé bán ɓa tonkaa mi bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ó o hã́a yàá wã́a wà ɓueé lií fárá mí nɔnkóɲúná wán o Yeesu yahó, ò o bía: «Ɲúhṹso, séení mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ó o Yeesu bía nɔn wo yi: «Mu yí se à ɓa lá ɓa háyónzàwa dĩ́nló à yénní kúia na ɓa booní yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ó o hã́a bía nɔn wo yi: «Ɲúhṹso, bṹn bon. Ɛ̀ɛ ká ɓa booní wee wé sèeka ho dĩ́nló na wee kùenka lii kúia mín so tá à dí.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ó o Yeesu wã́a bía nɔn o hã́a mu yi: «Fo ɓɛ̀ntĩ́n dó ũ sĩi miì làa sòobɛ́ɛ.» Mu ù wé làa bìo fo lonnáa mu. Ó o hĩ́nló dɛ̀ɛnía wan bṹn wán. ");
INSERT INTO boxNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bṹn mɔ́n ó o Yeesu ló hón lahó so yi á van ho Kalilee vũ-beenì ɲii, á vaá yòora le ɓúee wán yòó kará. ");
INSERT INTO boxNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Á ɓa minka zã̀amáa ɓuara a cɔ̃́n lè ɓa lóní, lè ɓa muiiwà, làa bìa sãnía bìo ɓúi mía bĩ́n, lè ɓa bekewà, lè ɓa vánvárowà cɛ̀rɛ̀ɛ ɓúi. Ɓa ɓueé bàráka ɓa o Yeesu tá, ó o wɛɛ́ra ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bìo ɓa zã̀amáa mɔn à ɓa bekewà na lá yí dà máa bío á wee bío, á mɔn à bìa sãnía bìo ɓúi lá mía bĩ́n á wan, á mɔn à bìa lá lé ɓa lóní wee varáka sese, á mɔn à bìa lá lé ɓa muiiwà á wee mi, á mu wó ɓa coon dàkhĩína, á ɓa wee ɓùaaní o *Isirayɛɛle ɓàn Dónbeenì yèni. ");
INSERT INTO boxNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","O Yeesu von mí nì-kenínia á bía nɔn ɓa yi: «Ɓa nùpua na kà màkárí ɓuan miì. Bìo kà lé ɓa wizooní tĩn ká ɓa wi làa mi, á ɓa bè-dínii wã́a vó. Ĩ yí wi à ĩ día ɓa à ɓa ɓo ká ɓa yí yú bìo yí dú. Lé bìo ɓa dà vaá lé è lùiorá ho wɔ̃hṹ wán lé le hĩni.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ó o nì-kenínia tùara a yi: «Wa à yí mu bè-dínii wen le dùure na kà yi á à na bán minka zã̀amáa so yi?» ");
INSERT INTO boxNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ó o Yeesu tùara ɓa yi: «Lée búurú bìo yɛn wi mi cɔ̃́n?» Á ɓa bía nɔn wo yi: «Lée búurú bìo hèɲun làa cezàwa bùaa yɛn ɓúi.» ");
INSERT INTO boxNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ó o Yeesu wã́a bía nɔn ɓa zã̀amáa yi le ɓa lii kɛɛní, ");
INSERT INTO boxNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ò o fó ho búurú bìo hèɲun lè ɓa cezàwa, ò o dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa mu nɔn mí nì-kenínia yi á bán sankaa nɔn ɓa zã̀amáa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓa ɓúenɓúen dú sù, ó o nì-kenínia khuiira bìo ká, á mu sú hã sàkíwá bìo hèɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bìa ɓúenɓúen na dú mu, á ɓa báawa mí dòn á à yí muaaseé náa síi, ká ɓa hã́awa lè ɓa háyúwá níi ló. ");
INSERT INTO boxNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bṹn mɔ́n ó o Yeesu nɔn ho wɔ̃hṹ ɓa zã̀amáa yi le ɓa ɓoka, ò o zon ho woohṹ mí dòn á van ho Makadan kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɓa *Farizĩɛwa lè ɓa *Sadusĩɛwa wi à ɓa khũaa o Yeesu ɲii yi, á ɓa vá ɓueé ɓó a Yeesu yi á bía nɔn wo yi le o wé yéréké bìo ɓúi na wee zéení le o dàńló ló le Dónbeenì cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ó o Yeesu bía nɔn ɓa yi: «Hen ká le wii lií wee zo, á ho wáayi mùia, à mi le ho tá hĩ́a wé se. ");
INSERT INTO boxNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ká le yìnbíi bùirìi, ká ho wáayi mùiamu á dó mí yuumu, à mi le ho viohó á à ɓuen. Ká mi wee loń ho wáayi à zũńnáa bìo a à wé, á lée webio nɔn á bìo wee zéení bìo wee wé bìo kà wán á mi yí zũ? ");
INSERT INTO boxNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ho zuia nùpua na yí se, na wee bĩní le Dónbeenì mɔ́n à wé mu bè-kora wee cà à ɓa mi yéréké bìo. Ɛ̀ɛ ká ɓa máa mi yéréké bìo ɓúi ká mu yínɔń le *Dónbeenì ɲi-cúa fɛɛro Zonaasi bìo.» Bṹn mɔ́n ó o wà ò o día ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bìo ɓa nì-kenínia wee khí lè ho vũ-beenì mɔ́n o Yeesu cɔ̃́n, á ɓa nɔnsãa yí ɓuan ho búurú. ");
INSERT INTO boxNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ó o Yeesu wã́a bía làa ba: «Mi pa miten ɓa *Farizĩɛwa lè ɓa *Sadusĩɛwa bìo yi. Ɓa bìo ɓonmín lè le ɲa-fĩni.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ó o nì-kenínia wee bío làa mín: «O wee bío kà síi lé bìo wa yí ɓuan ho búurú.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ó o Yeesu zũna bìo ɓa wee bío, ó o tùara ɓa yi: «Lée webio nɔn mi wee bíoráa le lé bìo mi yí ɓuan ho búurú? Mi sĩadéró miì ɓɛ̀ntĩ́n fòora. ");
INSERT INTO boxNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mi pá dĩǹ yí máa ɲí mu bìo à zũń mu kúará le? Ho búurú bìo hònú na á ĩ cɛ̀ɛkaa nɔn ɓa báawa muaaseé hònú yi, lè hã sàkíwá na mi khuiira bìo ká kúaa yi ɲii á mi nɔnsãa bìo yi le? ");
INSERT INTO boxNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Á ho búurú bìo hèɲun na á ĩ cɛ̀ɛkaa nɔn ɓa báawa muaaseé náa yi, lè hã sàkíwá na mi khuiira bìo ká kúaa yi ɲii á mi nɔnsãa bìo yi le? ");
INSERT INTO boxNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Á lée webio nɔn á mi le mu lé ho búurú bìo á ĩ wee bío? Mi pa miten ɓa Farizĩɛwa lè ɓa Sadusĩɛwa na bìo ka lòn ɲa-fĩni bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ó o nì-kenínia màhã́ wã́a zũna le o lá yí bía le ɓa pa míten le ɲa-fĩni na ɓa wee wé lè ho búurú bìo yi, ká lé ɓa Farizĩɛwa lè ɓa Sadusĩɛwa kàránló na ɓa wee na ó o le ɓa pa míten bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","O Yeesu wà van ho kɔ̃hṹ na sùaráa là a Filiipu ló-fáránii na ɓa le *Sezaaree yi. Ó o tùara mí nì-kenínia yi: «Ɓa nùpua wee bío webio o *Nùpue Za dã́ní yi?» ");
INSERT INTO boxNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Á ɓa bía nɔn wo yi: «Ɓa ɓúi le fo lé o Zãn Batiisi. Ɓa ɓúi le fo lé o *Elii. Ɓa ɓúi yàá ɓɛ̀n le fo lé o Zeremii, tàá le *Dónbeenì ɲi-cúa fɛɛro ɓúi.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ó o Yeesu tùara ɓa yi: «Minɛ́n cɔ̃́n á ĩ ɓɛ̀n lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ó o Simɔn Piɛre bía nɔn wo yi: «Fo lé o *Krista, le Dónbeenì na wi fɛ́ɛɛ Za.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ó o Yeesu wã́a bía nɔn wo yi: «Zãn za Simɔn, ũ ɲúhṹ sĩ. Mu yínɔń nùpue zéenía ho tũ̀iá poni na kà làa fo. Lé wàn Maá na wi ho wáayi á zéenía mu làa fo. ");
INSERT INTO boxNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Á ĩnɛ́n ɓɛ̀n ǹ bío bìo kà á à na foǹ: Fo lé o Piɛre bṹn kúará le huee. Á lé dén huee so á ĩ ì fárá ĩ kuure wán, á hàrí mu húmú máa dàń bìo ɓúi máa wé làa de. ");
INSERT INTO boxNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ho wáayi bɛ́ɛnì won-zàwa á ĩ ì na foǹ. Bìo lée bìo na á fo khíi wé pã́ bìo ho tá wán, á le Dónbeenì mún ǹ pĩ́ mu bìo ho wáayi. Á bìo na fo khíi wé tà bìo ho tá wán, á le Dónbeenì mún ǹ tà mu bìo ho wáayi.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ò o Yeesu wã́a henía mu nɔn mí nì-kenínia yi le ɓa yí bío le mí lé o Krista. ");
INSERT INTO boxNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","À lá bṹn ɲii wán, ó o Yeesu ɓúakáa wee bío bìo kà wéréwéré lè mí nì-kenínia: «Ĩ ko à ĩ va ho Zeruzalɛɛmu, à lò vaa be bĩ́n làa sòobɛ́ɛ ɓa *nì-kĩ́a, lè ɓa yankarowà ɲúnása lè ho *làndá bìo zéenílowa níi yi. Ɓa à ɓúe mi, ká hã wizooní tĩn zoǹ á ĩ ì vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ó o Piɛre wã́a fó a ɓa vá ló, ò o wee bío: «Ébé! Ɲúhṹso, bṹn máa wé làa fo. Le Dónbeenì á à kã̀ní fo mu yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ká a Yeesu màhã́ yèrèmáa bía nɔn wo yi: «Vá lé ĩ nìsã́ní lè ũ *Satãni bíoní. Fo wee bũmaka ĩ tonló. Ũ yilera yínɔń Dónbeenì yilera. Hã lé ɓa nùpua yilera.» ");
INSERT INTO boxNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bṹn mɔ́n ó o Yeesu bía nɔn mí nì-kenínia yi: «Yìa wi ò o bè miì, à ɓànso khí mí kùrú sĩi bìo wéró yi, ká a wé lá mí *kùrùwá pĩ̀ à bèráa miì. ");
INSERT INTO boxNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lé bìo á yìa wi ò o kã̀ní mí mukãnì wón á à vĩ́iní le. Ká yìa màhã́ tà le mí ì vĩ́iní le ĩnɛ́n bìo yi, wón á à yí le. ");
INSERT INTO boxNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","O nùpue lá yú ho dĩ́míɲá bìo ɓúenɓúen, ò o khon le mukãnì binbirì yi, se lé ho cũ̀nú yɛ́n á ɓànso yú? O nùpue lá khon le mukãnì binbirì yi, ó o so dà à na bìo ɓúi á à bĩní ì yíráa le le? ");
INSERT INTO boxNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mu bon. O *Nùpue Za khíi ɓuen mín Maá cùkú beenì yi lè mí wáayi tonkarowà, á ɓueé sàání ɓa nùpua nì-kéní kéní yi, á à héha làa bìo ɓa wó. ");
INSERT INTO boxNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Le ĩ mì ho tũ̀iá na mia: Ɓa nùwã yɛn zàwa ɓúi na wi bìa hen tĩ́ahṹ máa hí ká ɓa yí mɔn o Nùpue Za ɓuenló lè mí bɛ́ɛnì.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wizooní bìo hèzĩ̀n bṹn mɔ́n, ó o Yeesu fó a Piɛre là a Zaaki là a Zãn na ló o Zaaki ɓàn za á yòoraráa le ɓúee ɓúi na dɔ̃n wán. Bìo ɓa yòó wi bĩ́n mí dòn, ");
INSERT INTO boxNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ó o Yeesu miníkaa ɓa yìo yi, á yahó wee ɲuiíka lè le wii bìo síi, á sĩ̀-zĩ́nia ka pṹiapṹia lòn khoomu. ");
INSERT INTO boxNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Á ɓa nì-kenínia le mí ì loń, á ɓa mɔn o *Mɔyiize là a *Elii à ɓa dĩ̀n wee tà hã láakáwá là a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ó o Piɛre wã́a bía nɔn o Yeesu yi: «Ɲúhṹso, mu wó se á wa wi hen. Ká fo tà á ĩ ì tá hã bùkú zàwa bìo tĩn. Ũnɛ́n dà-kéní, o Mɔyiize dà-kéní, o Elii dà-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bìo ó o wee bío, à bṹn le dùndúure ɓúi na wee ɲuiíka á yòó ló lií pon ɓa yi. Á mu tãmu ɓúi sã ɲá le dùndúure mu yi: «Yìa kà lé ĩ Za na á ĩ bò ĩ tàká wán. O bìo sĩ miì. Mi wé ɲí a cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bìo ó o nì-kenínia ɲá mu tãmu mu sã, á ɓa zɔ̃́nkaa dàkhĩína, á lií ɓúrá mí yara ho tá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ó o Yeesu ɓueé ɓó ɓa yi, á bò mí níi ɓa wán, ò o bía: «Mi lii hĩ́ní. Mi yí zɔ̃́n bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Á ɓa wã́a hóonía mí yara á ɓa yí mɔn nùpue ká yínɔń o Yeesu mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bìo ɓa ló le ɓúee wán wee lii, ó o Yeesu henía bìo kà nɔn ɓa yi: «Bìo mi mɔn kà à mi yí bío le nùpue ɲí fúaa o *Nùpue Za húrun á vèera ló ɓa nì-hía tĩ́ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ó o nì-kenínia tùara a yi: «Lée webio nɔn ho *làndá bìo zéenílowa le o Elii ko ò o ɓuen ho yahó?» ");
INSERT INTO boxNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ó o bía nɔn ɓa yi: «Mu bon. O Elii ko ò o ɓuen vé, à ɓuee kúee mu bìowa ɓúenɓúen mí lara yi. ");
INSERT INTO boxNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Le ĩ bío mu na mia: O Elii mu yàá ɓuara vó. Ká ɓa nùpua màhã́ yí zũna le lé orɛ́n. Á ɓa wó a làa bìo ɓa sĩa vá yi. Lé bṹn síi ɓa mún ǹ beéráa o Nùpue Za lò.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ó o nì-kenínia wã́a zũna le lé o Zãn Batiisi ó o wee bío bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bìo ɓa lií dɔ̃n hen na ɓa zã̀amáa wi yi, ó o nìi ɓúi vá ɓueé ɓó a Yeesu yi á lií fárá mí nɔnkóɲúná wán o yahó, ò o bía: ");
INSERT INTO boxNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Nì-kàránlo, loń ĩ za màkárí yi. Le dàndàhíonì wi o yi. Le wee beé o lò. Pɔ̃̀nna cɛ̀rɛ̀ɛ le wee lá a dé ho dɔ̃hṹ tàá mu ɲumu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Á ĩ ɓuan wo ɓuararáa ũ nì-kenínia cɔ̃́n, ká ɓa màhã́ yí dàńna yí wɛɛ́ra a.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ó o Yeesu wãamaa: «Éee! Mi zuia nùpua ɓɛ̀ntĩ́n yí máa dé mí sĩa le Dónbeenì yi bìo bon, á mi mún yí máa ɲí hàrí dɛ̀ɛ. Mi wee leéka le ĩ kɛɛní làa mia á wé è kàrán mia fúuu le? Mi ɓua a háyónza mu ɓuennáa.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bìo ɓa ɓuara làa wo, ó o Yeesu nàmakaa o cĩ́ná yi, ó o ló. Ó o háyónza dɛ̀ɛnía wan mí lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bṹn mɔ́n ó o Yeesu wà. Ó o nì-kenínia wà vaá ɓó a yi à ɓa tùara a yi: «Lée webio nɔn á warɛ́n yí dàńna yí ɲɔnnáa o cĩ́ná mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ó o Yeesu bía nɔn ɓa yi: «Lé bìo mi sĩidéró miì ka cĩ́inú dàkhĩína. Le ĩ mì ho tũ̀iá na mia: Hen ká mi sĩadéró miì na khúekhúe lè ho mútáàdè bɛɛre bìo á mi yàá pá lá tà le miì wé làa bìo, á mi lá dà à bío ò na le ɓúee na kà yi le le lé ho lahó na le wi yi, à va lòn-veere, á mu ù wé. Bìo woon á mi lá máa wé è wé máa sa. ");
INSERT INTO boxNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɛ̀ɛ ká mu màhã́ lé ho fìoró lè le ɲii lìró mí dòn lé bìo dà à ɲa a cĩ́ná na kà ɓàn síi á à lén.» ");
INSERT INTO boxNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wizonle ɓúi ká a Yeesu lè mí nì-kenínia ɓúenɓúen páanía wi ho Kalilee kɔ̃hṹ yi, ó o bía nɔn ɓa yi: «O *Nùpue Za á ɓa à dé ɓa nùpua níní yi. ");
INSERT INTO boxNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɓa à ɓúe o, ká mu wizooní tĩn zoǹ o ò vèe.» Á ɓa nì-kenínia yilera yáara làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","O Yeesu lè mí nì-kenínia wà van ho *Kapɛɛnayuumu lóhó. Á le *Dónbeenì zĩ-beenì *lànpó féwá wà ɓueé ɓó a Piɛre yi à ɓa tùara a yi: «Mi nì-kàránlo so wee sàání le Dónbeenì zĩ-beenì lànpó le?» ");
INSERT INTO boxNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ó o Piɛre bía: «Ũuu o wee sàání ho.» Pã̀ahṹ na ó o Piɛre wà vaá zo le zĩi na ó o Yeesu wi yi, ó o Yeesu dɛ̀ɛnía wee tùa wo yi: «Simɔn, lée wée ko ò o wé sàání ho lànpó lè mí sìíwà à na ho dĩ́míɲá na kà bá-zàwa yi? Fo wee leéka webio mu dã́ní yi? Lé ho kɔ̃hṹ nùpua mí bɛɛre lée tàá lé bìa ɓa funnáa á dàńna?» Ó o Piɛre le lé bìa ɓa dàńna. ");
INSERT INTO boxNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ó o Yeesu bía nɔn wo yi: «Àwa, bṹn wee zéení le ho kɔ̃hṹ nùpua yí ko ɓa wé sàání ho lànpó. ");
INSERT INTO boxNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɛ̀ɛ ká wa màhã́ máa lùnka ɓa nùpua mu yilera. Lɛ́n lii ho vũ-beenì yi, à lii pa le ce-hĩnì. Ò o nín-yání ceza na fo ò vĩ à ũ lén à lée hɛ́n ɲii, á fo ò yí le wɛ́n-hɔ̃nló le yi na dà warɛ́n wa nùwã ɲun lànpó á à sàání. À ũ wã́a ɓua dén à ũ va ɓa cɔ̃́n vaa sàání wa lànpó.» ");
INSERT INTO boxNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hón pã̀ahṹ so yi, ó o Yeesu nì-kenínia wà ɓueé ɓó a yi, à ɓa wee tùa wo yi: «Yìa bìo ɲúhṹ wi po bìa ká le Dónbeenì bɛ́ɛnì yi lé o yɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ó o Yeesu von o háyónza ɓueé dĩ̀nía ɓa yahó, ");
INSERT INTO boxNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ò o bía: «Le ĩ mì ho tũ̀iá na mia: Hen ká mi yí yèrèmáa á yí ka lè ɓa háyúwá bìo síi, á mi máa zo le *Dónbeenì bɛ́ɛnì yi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yìa bìo ɲúhṹ wi po bìa ká le Dónbeenì bɛ́ɛnì yi lé yìa wee liiní míten à wé là a háyónza na kà bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yìa ɓuan háyónza ɓúi na ka làa yìa kà bìo síi sese, se mu lé ĩnɛ́n ĩ bɛɛre á ɓànso ɓuan sese. ");
INSERT INTO boxNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ɓa háyúwá na dó mí sĩa miì nì-kéní á nùpue khà dó mu bè-kora wéró yi, se mu sṹaaní á ɓa ca le hue-beenì ɓànso fonle yi à lèe dé ho mu-beenì yi ò o lii lí. ");
INSERT INTO boxNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ho dĩ́míɲá á ho yéréké khíi sá yi, lé bìo á bìo wee khà ɓa nùpua dé mu bè-kora wéró yi á wi ho yi. Mu bon, mu lée bìo na wéró máa khí ho yi. Ɛ̀ɛ ká yìa níi wee bè mu, á ho yéréké khíi sá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ká mu lé ũ níi tàá ũ zeǹ wee dé fo mu bè-kora wéró yi, ũ kúio hã lèe kúia. Fo zon le mukãnì na máa vé lùe yi lè ũ nín-kéní tàá lè ũ zeǹ-kéní, se mu sṹaaní bìo ɓa à lèe fo á à dé ho dɔ̃hṹ na máa hí máa mi yi lè ũ níní mí bìo ɲun tàá ũ zení mí bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ká mu lé ũ yère wee dé fo mu bè-kora wéró yi, ũ còkon le lèe día. Fo zon le mukãnì na máa vé lùe yi lè ũ yèn-kéní, se mu sṹaaní bìo ɓa à lèe fo ò dé le *Dofĩ́ní dɔ̃hṹ yi lè ũ yìo mí bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Mi pa miten bìo, à ɓa háyúwá na kà nì-kéní ò o ɓúi yí zùań yi. Lé bìo ɓa háyúwá mu wáayi tonkarowà wi lè wàn Maá Dónbeenì fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","O *Nùpue Za ɓuara wà ɓueé cà bìa khɛ̀ra lè le Dónbeenì á à fení. ");
INSERT INTO boxNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Le ĩ tùa mia. Hen ká a ɓúi pia khĩmàni lá wi síi, ó o yà-kéní wó wó sɛ́ra vṹnun, ó o so máa kúia ɓa khĩmàni yà-kéní mía na ká le ɓúee yi ká a máa cànka yìa vṹnun le? ");
INSERT INTO boxNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Le ĩ bío mu na mia: Ká a hĩ́a yú a, ó o sĩi á à wa wa a bìo yi á à poń ɓa khĩmàni yà-kéní mía na yí vṹnun. ");
INSERT INTO boxNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lé làa bṹn síi á mìn Maá na wi ho wáayi mún yí wi à ɓa háyúwá na kà nì-kéní à vĩ́. ");
INSERT INTO boxNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Hen ká mìn za wó khon làa fo, à ũ vaa zéení a wékheró na a yi, ũnɛ́n làa wo mi nùwã ɲun mi dòn. Ká a tà, á mi ì bĩní ì wé ɓa zàwa. ");
INSERT INTO boxNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ká a pã́, à ũ cà nùpue nì-kéní tàá nùwã ɲun dé ũ wán, à héha làa bìo le Dónbeenì bíonì vũahṹ bíaráa mu: ‹Mu bìo ɓúenɓúen á wa à lén yìo ɓa sɛɛ́ràsa nùwã ɲun tàá nùwã tĩn bè-bíonii wán.› ");
INSERT INTO boxNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ká a pá pã́ le mí máa ɲí bán cɔ̃́n, à ũ bío mu lè mìn zàwa na kúaa mín wán. Ká a pã́ le mí máa ɲí ɓàn cɔ̃́n, à ũ wã́a wé o lòn lànpó fé, tàá nì-veere ɓúi na yí zũ Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Le ĩ mì ho tũ̀iá na mia: Bìo lée bìo na mi khíi wé pã́ bìo ho tá wán, á le Dónbeenì mún ǹ pĩ́ mu bìo ho wáayi. Á bìo lée bìo na á mi khíi wé tà bìo ho tá wán, á le Dónbeenì mún ǹ tà mu bìo ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Le ĩ mún bío mu na mia. Hen ká nùwã ɲun ɓúi wé ló mi tĩ́ahṹ á ɓunɓuaa fìora bìo lée bìo ho tá wán, á wàn Maá na wi ho wáayi á à na mu ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mu bon, hen na á nùwã ɲun tàá nùwã tĩn kúaa mín wán yi ĩ yèni yi, se ĩ wi ɓa tĩ́ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ó o Piɛre wã́a vá ɓueé ɓó a Yeesu yi ò o tùara a yi: «Ɲúhṹso, ká wàn za wee wé khe làa mi fɛ́ɛɛ, á ĩ ko à ĩ sɛ́n día na a yi cúa-yɛn? Lée cúa-hèɲun lée?» ");
INSERT INTO boxNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ó o Yeesu le ɓùeé. «Ĩ yí bía le cúa-hèɲun mí dòn. Ĩ le ɓúará-tĩn làa pírú pírú cúa-hèɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lé bṹn nɔn á ĩ ì tèé ho wáayi bɛ́ɛnì làa bìo kà: Bɛ́ɛ ɓúi le mí ì càtí mí kení na wi mí ton-sáwá yi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bìo ó o ɓúakáa wee càtí hã, á ɓa ɓuan o ɓúi ɓuararáa, à le wárí na ó o ko o ò wĩ́ mí ɲúhṹso yi á boo dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","O nìi mu yí dà le máa wĩ́. Á ɓa ɲúhṹso nɔn le ɲii le ɓa wã́a yɛ̀ɛ́ wo ò o wé o wobá-nìi, à yɛ̀ɛ́ ɓàn hã́a, là a zàwa, làa bìo wi o cɔ̃́n ɓúenɓúen, à màhã́ wĩ́náa le kee. ");
INSERT INTO boxNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ó o ton-sá mu lií fárá mí nɔnkóɲúná wán mí ɲúhṹso yahó ò o wee yanka a: ‹Sabéré ũ ɲì ũ yi. Ĩ ì wĩ́ le kee mu ɓúenɓúen.› ");
INSERT INTO boxNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Á ɓa ɲúhṹso zũna a màkárí, ó o sɛ́ra mu día nɔn wo yi ò o le o lɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ó o ton-sá mu wà lée sã́ mí ninza ɓúi yahó ò orɛ́n kee ɓɛ̀n wi wón yi. Le lée wɛ́n-hãani khĩmàni. Ó o wìira mí ninza mu tun kɔ̃̀nlè ò o wee bío: ‹Ĩ wárí na wi foǹ á ũ wĩ́.› ");
INSERT INTO boxNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Á ɓa ninza mu lií ɓúrá à tá, á wee yanka a kà: ‹Sábéré ũ ɲì ũ yi. Ĩ ì wĩ́ le kee mu.› ");
INSERT INTO boxNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ká a màhã́ pã́, ò o vaá dó a ho kàsó yi á pannáa o kee wĩ́ló. ");
INSERT INTO boxNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bìo ɓa ton-sáwá na ká mɔn bìo wó, á mu vá ɓa yi làa sòobɛ́ɛ. Á ɓa wà vaá lá mu ɓúenɓúen fɛɛra nɔn mí ɲúhṹso yi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Á ɓa ɲúhṹso von o ton-sá mu á ɓueé bía nɔn yi: ‹Yí kohó ɓànso yɛ́n! Ũnɛ́n á ĩ sɛ́ra bìo día lé bìo fo yankaa mi. ");
INSERT INTO boxNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fo ɓɛ̀n mún lá ko à ũ zũń mi ninza màkárí làa bìo á ĩnɛ́n zũnanáa à ũ màkárí.› ");
INSERT INTO boxNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɓa ɲúhṹso sĩi cã̀ dàkhĩína, ó o le ɓa ɓua a ton-sá mu vaa dé ho kàsó yi à pa le kee na wi o yi ɓúenɓúen wĩ́ véró.» ");
INSERT INTO boxNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Bṹn mɔ́n ó o Yeesu bĩnía bía: «Lé kà síi á wàn Maá na wi ho wáayi á khíi wé làa mia, ká mi yí máa tà sɛ́n día na mìn zàwa lè mìn hĩ́nni yi lè mi sĩa ɓúenɓúen.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bìo ó o Yeesu kàránna ɓa nùpua kà síi vó, ó o ló ho Kalilee kɔ̃hṹ yi á wà khú ho *Zudee kɔ̃hṹ sɔ̃́n-kéní na wi ho Zurudɛ̃n muhṹ mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nùpua cɛ̀rɛ̀ɛ ɲɔn o mɔ́n khú bĩ́n lè mí vánvárowà, ó o wɛɛ́ra ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Á ɓa *Farizĩɛwa ɓúi wi ɓa khũaa o Yeesu ɲii yi, á ɓa wà ɓueé ɓó a yi, à ɓa tùara a yi: «Wa làndá yi, ká nùpue ɓàn hã́a dá wó khon làa wo, á níi so nɔn wo yi ò o dɛ̀ɛní ɲa a le?» ");
INSERT INTO boxNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ó o Yeesu bía nɔn ɓa yi: «Mi so yí kàránna bìo kà yí mɔn le Dónbeenì bíonì vũahṹ yi le? ‹Mu ɲúhṹ ɓúɛɛníi, á le Dónbeenì léra a báa á léra a hã́a.› ");
INSERT INTO boxNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lé bṹn nɔn ó o báa á à día mín maá lè mín nu, ká à lɛɛ́ lè mín hã́a. Á ɓa mí nùwã ɲun á à wé sãnía dà-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɓa wã́a yí nɔn nùwã ɲun, ɓa lée nì-kéní. Bìo le Dónbeenì cɛɛ́ra mín yi à nùpue yí fáa.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Á ɓa *Farizĩɛwa bía nɔn wo yi: «Lée webio nɔn ó o Mɔyiize bíaráa le ká báa le mí ì ɲa mín hã́a, o ò wé mu yaamu fáaró vũahṹ na a yi?» ");
INSERT INTO boxNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ó o Yeesu bía nɔn ɓa yi: «O Mɔyiize nɔn le níi le mi dà a ɲa mi hã́nání, lé bìo mi yí máa ɲí dɛ̀ɛ. Ɛ̀ɛ ká mu ɲúhṹ ɓúɛɛníi á mu lá yí ka kà síi. ");
INSERT INTO boxNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Le ĩ bío mu na mia: Báa na día mín hã́a à ɓàn hã́a mu ɲɔǹ yí fó báa, ò o kũn fó hã́-veere yan, se wón lée hã́-fé.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ó o Yeesu nì-kenínia bía nɔn wo yi: «Ká mu lé kà síi ó o báa ko ò o ɓuaráa miten mín hã́a dã́ní yi, ká nùpue wã́a yí yan se mu sṹaaní.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ó o Yeesu bía nɔn ɓa yi: «Hón kàránló so na kà á báawa ɓúenɓúen yí dà máa tà yi. Bìa le Dónbeenì nɔn mu pànká yi, bán mí dòn lé bìa dà à tà mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bìo wee hè ɓa báawa ɓúi à ɓa máa ya á sìíwà boo. Ɓa ɓúi wee te ká ɓa bámu húrun. Ɓa ɓúi lé ɓa nùpua ɓó ɓa bámu. Ɓa ɓúi ɓɛ̀n wee pĩ́ mu hã́-yaamu ho wáayi bɛ́ɛnì bìo yi. Yìa dà hón kàránló so á à tà yi, à wón tà ho yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nùpua ɓúi ɓuan ɓa háyúwá ɓuararáa o Yeesu cɔ̃́n le o bè mí níní ɓa wán, ò o fìo na ɓa yi. Ó o nì-kenínia wee zá làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ó o Yeesu wã́a bía nɔn ɓa yi: «Mi día ɓa háyúwá le ɓa ɓuen ĩ cɔ̃́n. Mi yí hè ɓa. Lé bìo ho wáayi bɛ́ɛnì bìo sã̀ bìa ka lè ɓa bìo síi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ò o Yeesu wã́a bò mí níní ɓa wán. Bṹn mɔ́n ó o ló hón lahó so yi wà. ");
INSERT INTO boxNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yìo ɓueé tĩ, à nùpue ɓúi vaá vá ɓueé ɓó a Yeesu yi, á tùara a yi: «Nì-kàránlo, lée webio á ĩ ko à ĩ wé ká mu se à yíráa le mukãnì binbirì na máa vé?» ");
INSERT INTO boxNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ó o Yeesu bía nɔn wo yi: «Lée webio nɔn á fo wee tùaráa miì lè mu bìo na se bìo? Le Dónbeenì mí dòn lé dìo se. Ká fo wi à ũ yí le mukãnì binbirì na máa vé, à le Dónbeenì bíoní na le henía bìo à ũ bè yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ó o nìi tùara: «Hɔ̃́n lé hã bíoní yɛ́n?» Ó o Yeesu bía: «Yí ɓúe nùpue. Yí wé hã́-fénló tàá bá-fénló. Yí ɲuaa bìo. Yí fĩ̀ sabéré mi ninza ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kɔ̃̀nbi mìn maá lè mìn nu. Wań mi ninza làa bìo á fo waráa ũten bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ó o yàrónza bía nɔn o Yeesu yi: «Bṹn ɓúenɓúen á ĩ bò yi. Lé mu yɛ́n á ĩ pá bĩnía ko à ĩ wé.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ó o Yeesu bía nɔn wo yi: «Ká fo wi ũ wé o nùpue na bìo ɲii sú, à ũ lɛ́n vaa yɛ̀ɛ́ bìo wi ũ cɔ̃́n ɓúenɓúen, à na wárí ɓa nì-khenia yi, á fo khíi yí ho nàfòró ho wáayi. Bṹn mɔ́n à ũ bĩní ɓuee bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bìo ó o yàrónza ɲá hɔ̃́n bíoní so, ó o bĩnía wà ká a sãnía tò, lé bìo ó o níi bìo boo dà. ");
INSERT INTO boxNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ó o Yeesu bía nɔn mí nì-kenínia yi: «Le ĩ mì ho tũ̀iá na mia: Ho nàfòró ɓànso zoró le *Dónbeenì bɛ́ɛnì yi ɓɛ̀ntĩ́n do. ");
INSERT INTO boxNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ĩ pá à bĩní ì bío bìo kà á à na mia: O cón-ɲúmúkũ̀ zoró lè ho mísĩ̀mí kɔ̃hṹ á à wé wayi á à poń o nàfòró ɓànso zoró le Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bìo ɓa nì-kenínia ɲá hã bíoní mu, á ɓa wó coon dàkhĩína, á ɓa bía: «Éee! Á yìa wã́a dà à fen lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ó o Yeesu yòó fá mí yìo ɓa yi ò o bía: «Ɓa nùpua cɔ̃́n á mu yí dà máa wé, ɛ̀ɛ ká le Dónbeenì cɔ̃́n á bìo ɓúenɓúen dà wee wé.» ");
INSERT INTO boxNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ó o Piɛre wã́a bía nɔn o Yeesu yi: «Loń, warɛ́n ló día bìo lá wi wa cɔ̃́n ɓúenɓúen à wà bò foǹ, á wa bìo khíi wé kaka?» ");
INSERT INTO boxNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Hen ká a *Nùpue Za khíi kará mí cùkú beenì kanmúiní wán ho dĩ́míɲá fĩnle yi, á minɛ́n pírú ɲun na bò miì á mún ǹ kɛɛní ɓa bá-zàwa kanmúiní wán, á à cítíráa o *Isirayɛɛle zĩ-ɲúná pírú ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Á bìa ɓúenɓúen na ló día mí zĩní, lè mín zàwa, lè mín hĩ́nni, lè mín maáwà, lè mín nuwà, lè mí zàwa tàá mí manawà ĩnɛ́n bìo yi, bán khíi yí mu ɓàn cúa-khĩmàni khĩmàni á mún ǹ yí le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɛ̀ɛ ká bìa dú ho yahó hã làa na ká wán, á cɛ̀rɛ̀ɛ khíi wé ɓa mɔ́n-díwá. Á bìa dú ho mɔ́n hã làa na ká wán, á cɛ̀rɛ̀ɛ khíi wé ɓa ya-díwá. ");
INSERT INTO boxNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Mi loń, ho wáayi bɛ́ɛnì bìo ka làa bìo ó o nìi ɓúi na èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó wi á hĩ́a wó. Wizonle ɓúi ó o fèra hĩ́nɔn ló le yìnbíi bùirìi, á wà lée cà ɓa vàrowà á à kúee mí èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Á ɓa vàrowà mu làa wo wã̀anía tò le wɛ́n-hɔ̃nló dà-kéní na lé o nùpue nì-kéní wizon-kùure sámú sàáníi wán, ó o le ɓa wã́a vaa sá mí èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bṹn mɔ́n ó o bĩnía ló le yìnbí-wi-bee yi, á lée yú ɓa ɓúi ɓa nùpua fèmínló lahó yi à ɓa yí máa wé dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ó o bía nɔn ɓa yi: ‹Minɛ́n mún lɛ́n vaa sá ĩ èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó yi, ká ĩ na le wizon-kùure sámú sàáníi mi nì-kéní kéní yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Á bán wà van. Bṹn mɔ́n á ho mɔhṹ ɓànso tĩ́n bĩnía ló ká le wii yòó fárá, á kũn ló le wi-háarè, á lée wó bìo ó o wó khĩína ɓàn síi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mu véeníi ó o bĩnía ló ho zĩihṹ ɲii, á tĩ́n lée yú ɓa nùpua ɓúi ho fèmínló lahó yi. Ó o tùara ɓa yi: ‹Mi kará hen á tò le wii kã́amáa le we?› ");
INSERT INTO boxNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Á bán bía nɔn wo yi: ‹Lé bìo á nùpue yí lá wɛn.› Á ho mɔhṹ ɓànso bía nɔn ɓa yi: ‹Minɛ́n mún lɛ́n vaa sá ĩ mɔhṹ yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Bìo le wii tò, á ho mɔhṹ ɓànso bía nɔn mi ton-sáwá ɲúhṹso yi le o ve ɓa vàrowà ɓuee sàání yi. Le o ɓúaká làa bìa ɓuara ho mɔ́n, à vaa véení làa bìa ɓuara ho yahó. ");
INSERT INTO boxNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Á bìa van ho mɔhṹ yi ho zĩihṹ á ɓuara. Á ɓa lè mí nì-kéní kéní yú le wɛ́n-hãani dà-kéní kéní. ");
INSERT INTO boxNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Á bìa van ho mɔhṹ yi ho yahó wee leéka le mínɛ́n ǹ yí á à poń ɓa. Bìo ɓa ɓuara, á ho mɔhṹ ɓànso mún nɔn le wɛ́n-hãani dà-kéní kéní ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bìo ɓa fó mí sàáníi, á ɓa sĩa yí wan le bìo yi, ");
INSERT INTO boxNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","á ɓa wee bío là a mɔhṹ ɓànso: ‹Bìa kà sá ho zĩihṹ ɲii mí dòn. À ũ pá sàánía ɓa yi á mànía lè warɛ́n na tà le wizon-kùure sámú lònbee yi le wiso-hádɔ̃hṹ yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Á ho mɔhṹ ɓànso bía nɔn ɓa vàrowà mu nì-kéní yi: ‹Wàn bɔ̃́nlo, ĩ yí tò ũ wán. Wa so fù yí wã̀anía yí tò le wɛ́n-hɔ̃nló dà-kéní wán le wizon-kùure sámú bìo yi le? ");
INSERT INTO boxNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Àwa, fé ũ wárí ũ lɛ́n. Yìa ɓuara ho mɔ́n á ĩ mún wi à ĩ sàání yi à màní lè ũnɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ĩnɛ́n lé yìa te ĩ wárí. Ká ĩ le ĩ wé le làa bìo na, á ĩ ì wé. Tàá lé bìo á ĩ wó mu sãamu lé bṹn wee vá foǹ le?›» ");
INSERT INTO boxNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ò o Yeesu bĩnía bìa bò mu wán: «Ɓa mɔ́n-díwá khíi wé ɓa ya-díwá, á ɓa ya-díwá khíi wé ɓa mɔ́n-díwá.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bìo ó o Yeesu wee va ho Zeruzalɛɛmu, ó o fó mí nì-kenínia pírú ɲun mí ɲii yi, á wee bíoráa làa bìo kà ká ɓa wi ho wɔ̃hṹ wán varákaa wà: ");
INSERT INTO boxNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Mi loń, wa wee yòo ho Zeruzalɛɛmu. Lé bĩ́n ó o *Nùpue Za ɓa à dé le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa níi yi. Ɓa à síiní a ɲúhṹ á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ɓa à na a bìa yí zũ le Dónbeenì yi á ɓa à zùańka yi, á à ha a lè hã làbàaní. Bṹn mɔ́n, á ɓa à ɓúɛɛ wo ho *kùrùwá wán o ò hí. Ká mu wizooní tĩn zoǹ o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","O Zebedee ɓàn hã́a lè mí zàwa nùwã ɲun wà ɓueé ɓó a Yeesu yi, ó o hã́a mu lií fárá mí nɔnkóɲúná wán o yahó, á wi ò o fìo bìo ɓúi o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ó o Yeesu bía nɔn wo yi: «Lée webio á ũ màkóo wi yi?» Ó o bía: «Dé ũ ɲii na miì le ĩ zàwa nùwã ɲun na kà ò o nì-kéní khíi kɛń ũ nín-tĩánì, ká a nì-kéní kɛń ũ nín-káahó ũ bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ó o Yeesu bía nɔn ɓa yi: «Bìo mi wee fìo mi yí zũ. Le lònbee na á ĩ ì lá ɓàn síi á mi so dà à lá le?» Á ɓa le ũuu le mí dà mu. ");
INSERT INTO boxNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ó o Yeesu bía nɔn ɓa yi: «Mu bon, mi lò á à be. Ká ĩnɛ́n màhã́ yí dà máa bío wéréwéré le lé yìa kà á à kɛɛní ĩ nín-tĩánì tàá ĩ nín-káahó. Hɔ̃́n lùa so bìo sã̀ bìa á wàn Maá wíokaa hã káráa yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bìo ɓa nì-kenínia nùwã pírú na ká ɲá mu, á ɓa sĩa cã̀ ɓa nùwã ɲun mu yi làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ó o Yeesu wã́a von ɓa ɓúenɓúen á bía nɔn yi: «Mi zũ le hã kãna ɲúnása wee wé mí pànká bìa ɓa wi ɲúhṹ yi wán. Á bìa lé ɓa nì-beera wee zéení làa bìa ká le mí po ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ɛ̀ɛ ká minɛ́n bìo yí ko mu wé kà síi. Hen ká minɛ́n nì-kéní ɓúi wi ò o bìo ɲúhṹ wé poń bìa ká, ó o ko ò o wé ɓa ton-sá. ");
INSERT INTO boxNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ká minɛ́n nì-kéní ɓúi wi ò o dí bìa ká yahó, á ɓànso ko ò o wé mi wobá-nìi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lé kà síi ó o *Nùpue Za bìo karáa. O yí ɓuara à ɓa sá na a yi. O ɓuara wà ɓueé sá á à na ɓa nùpua yi, á mún ǹ na mí mukãnì á à lénnáa ɓa nùpua cɛ̀rɛ̀ɛ ɲúná.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bìo ɓa ló ho Zerikoo lóhó yi, á ɓa zã̀amá-kúii bò a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mu wee wé à muiiwà nùwã ɲun ɓúi kará ho wɔ̃hṹ nìsã́ní, á ɲá à ɓa le o Yeesu wee khĩí. Á ɓa wee bío pɔ̃́npɔ̃́n: «Ɲúhṹso, *Daviide Za, màkárí wɛn!» ");
INSERT INTO boxNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Á ɓa zã̀amáa wee zá làa ba le ɓa wé tɛ́tɛ́. Á ɓa yàá wã́a wíokaa wee bío pɔ̃́npɔ̃́n: «Ɲúhṹso, Daviide Za, màkárí wɛn!» ");
INSERT INTO boxNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ó o Yeesu dĩ̀n ò o von ɓa tùara yi: «Lée webio á mi wi à ĩ wé na mia?» ");
INSERT INTO boxNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Á ɓa bía: «Ɲúhṹso, wé le wa yìo à wé mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Á ɓa màkárí ɓuan o Yeesu yi, ó o dɔ̃n ɓa yìo lè mí níní. Mí lahó yi á ɓa yìo dɛ̀ɛnía wee mi, á ɓa bò a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","O Yeesu lè mí nì-kenínia vaá sùaráa ho Zeruzalɛɛmu yi. Bìo ɓa wi le ɓúee na ɓa le Oliivewa vĩ̀nsĩ̀a ɓúee wán, ho Bɛtefazee lóhó ɲii, ó o fèra tonkaa mí nì-kenínia nùwã ɲun á bía nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Mi lɛ́n va ho lóhó na vaá mi yahó yi. Mi vaa dɛ̃ɛníi bĩ́n, á mi ì mi sũ̀npɛ̀-nu ká a can dĩ̀n lè mí za. Mi fee ɓa ɓuee na miì.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ká ɓa tùara mia à mi bío le o Ɲúhṹso màkóo wi ɓa yi, á ɓa à dɛ̀ɛní ì día ɓa mi ì lɛ́nnáa. ");
INSERT INTO boxNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bṹn wó kà síi bèra a na le *Dónbeenì ɲi-cúa fɛɛro bíoní na kà à bìo wéráa. ");
INSERT INTO boxNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Mi bío na ho Sion lóhó nìpomu yi: ‹Loń, lé ũ bɛ́ɛ na bò o ɓuen ũ cɔ̃́n. O wayi. O yòora a sũ̀npɛ̀-nu lè mí za.›» ");
INSERT INTO boxNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Á ɓa nì-kenínia wã́a wà, á vaá wó bìo ó o Yeesu le ɓa wé. ");
INSERT INTO boxNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓa vaá ɓuan o sũ̀npɛ̀-nu lè mí za ɓuararáa, á bò mí kánɓunwà ɓa wán ó o Yeesu yòó kará wán. ");
INSERT INTO boxNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɓa minka zã̀amáa na bò a yi á ɓa cɛ̀rɛ̀ɛ wee bá mí kánɓunwà ho wɔ̃hṹ wán o yahó. Ɓa ɓúi lé hã vĩ̀nsĩ̀a vɔ̃nna ɓa wee khé à bá. ");
INSERT INTO boxNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɓa minka zã̀amáa na varákaa dú a Yeesu yahó làa bìa bò a yi á wee bío pɔ̃́npɔ̃́n: «Le ho cùkú à dé o *Daviide Za yi. Le le Dónbeenì wé mu bè-tentewà làa yìa bò o ɓuen o Ɲúhṹso yèni yi. Le le Dónbeenì na wi ho wáayi à ho cùkú dé yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bìo ó o Yeesu vaá zon ho Zeruzalɛɛmu, á ho nìpomu ɓúenɓúen kánkáa. Ɓa wee tùaka mín yi: «Yìa kà lée wée kà?» ");
INSERT INTO boxNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Á ɓa nùpua wee bío: «O lé o Yeesu, le *Dónbeenì ɲi-cúa fɛɛro. O ló ho Kalilee kɔ̃hṹ lóhó na ɓa le Nazarɛɛte yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","O Yeesu vaá zon le *Dónbeenì zĩ-beenì yi, á zoó ɲɔn bìa wee yɛ̀ɛ́ mu bìo làa bìa wee yà mu bĩ́n. Ɓa wɛ́n-pùarílowà tàbáríwa làa bìa wee yɛ̀ɛ́ ɓa ɓùaaɓúuní kanmúiní ó o dónkaa kúaa, ");
INSERT INTO boxNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ò o bía nɔn ɓa yi: «Le Dónbeenì bíonì vũahṹ bía bìo kà: ‹Ĩ zĩi ɓa wé è ve làa fìoró zĩi.›» Ò o bĩnía bía: «Á minɛ́n ɓɛ̀n wó le lè ɓa kɔ̃̀nlowà lùe hã́?» ");
INSERT INTO boxNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɓa muiiwà lè ɓa mùamúawà ɓúi wà ɓueé ɓó a Yeesu yi, ó o wɛɛ́ra ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Á ɓa yankarowà ɲúnása lè ho *làndá bìo zéenílowa yiwa cã̀ bìo ɓa mɔn ò o Yeesu wee wé mu yéréké bìowa bìo yi làa bìo ɓa háyúwá wee bío pɔ̃́npɔ̃́n kà síi bìo yi: «Ho cùkú à dé o *Daviide Za yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Á ɓa wã́a bía nɔn o Yeesu yi: «Fo wee ɲí bìo ɓa wee bío le?» Ó o Yeesu le: «Ũuu, ĩ wee ɲí mu. Minɛ́n so yí kàránna bìo kà le Dónbeenì bíonì vũahṹ yi yí mɔn le? ‹Fo wó, á hàrí ɓa háyúwá lè ɓa kúnkúzàwa wee khòoní fo.›» ");
INSERT INTO boxNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bṹn mɔ́n ó o ló ho lóhó yi wà día ɓa, á van ho Betanii lóhó vaá cãana bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mu tá na lée tɔ̃n yìnbíi, ká a Yeesu bĩnía bò o ɓuen ho Zeruzalɛɛmu, á le hĩni dà a. ");
INSERT INTO boxNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ó o mɔn le vĩ̀ndɛ̀ɛ ɓúi na ɓa le *fíkíyée ho wɔ̃hṹ nìsã́ní. Ó o wà vaá ɓó le yi, ká a màhã́ yí yú bìa le wán, lée vɔ̃nna mí dòn. Ó o wã́a bía nɔn le yi: «Fo máa bĩní máa ha bìa hùúu.» Á le vĩ̀ndɛ̀ɛ mu dɛ̀ɛnía hon mí lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bìo ó o nì-kenínia mɔn mu, á mu wó ɓa coon. Á ɓa tùara a Yeesu yi: «Le vĩ̀ndɛ̀ɛ mu dɛ̀ɛnía wó kaka honnáa kà?» ");
INSERT INTO boxNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Hen ká mi dó mi sĩa miì, á yí máa titika, á bìo á ĩ wó lè le vĩ̀ndɛ̀ɛ na kà ɓàn síi á mi wé è wé. Ká mi mún pá dà à bío ò na le ɓúee na kà yi: ‹Hĩ́ní hen na fo wi yi à vaa zo ho mu-beenì yi›, á mu ù wé. ");
INSERT INTO boxNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ká mi dó mi sĩa miì, á bìo ɓúenɓúen na mi wee fìo le Dónbeenì cɔ̃́n, á mi ì yí.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","O Yeesu yòó zon le *Dónbeenì zĩ-beenì yi zoó wee kàrán ɓa nùpua. Á ɓa yankarowà ɲúnása lè ɓa *zúifùwa *nì-kĩ́a wà ɓueé ɓó a yi, à ɓa tùara a yi: «Fo yú le níi wen wee wéráa bìo kà? Lé wée nɔn mu wéró níi foǹ?» ");
INSERT INTO boxNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ó o Yeesu bía nɔn ɓa yi: «Ĩnɛ́n ɓɛ̀n mún ǹ tùa mia làa bìo dà-kéní mí dòn. Ká mi zéenía mu, á ĩnɛ́n mún ǹ zéení yìa nɔn le níi miì á ĩ wee wéráa bìo kà. ");
INSERT INTO boxNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yìa tonkaa o Zãn le o wé bátízé ɓa nùpua lée wée? Lé le Dónbeenì lée, tàá lé ɓa nùpua?» Á ɓa dĩ̀n wee wã̀aní mín yi: «Ká wa le lé le Dónbeenì tonkaa wo, o ò bío le lée webio nɔn á wa yí tàráa o bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ká wa mún le lé ɓa nùpua tonkaa wo, á ɓa zã̀amáa máa día wɛn. Lé bìo ɓa ɓúenɓúen wee leéka le o Zãn lé le *Dónbeenì ɲi-cúa fɛɛro.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Á ɓa wã́a bía nɔn o Yeesu yi: «Wa yí zũ yìa tonkaa wo.» Ó o Yeesu bía nɔn ɓa yi: «Àwa, á ĩnɛ́n mún máa zéení yìa nɔn le níi miì á ĩ wee wéráa bìo kà.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","O Yeesu pá bĩnía bía: «Mi ɲí bìo kà: Nìi ɓúi zàwa nùwã ɲun hĩ́a wi. Ó o von o nì-kéní á bía nɔn yi: ‹Ĩ za, lɛ́n vaa và ho èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó yi ho zuia.› ");
INSERT INTO boxNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ó o le mí máa va. Ò o hĩ́a bĩnía lon mi yi, ó o wà van á vaá và. ");
INSERT INTO boxNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bṹn mɔ́n, ó o maá mu bía mu bìo dà-kéní mu làa yìa so. Á wón le mí ì va, ò o màhã́ yí van. ");
INSERT INTO boxNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Àwa, ɓa nùwã ɲun mu tĩ́ahṹ, á lé o yɛ́n wó bìo á ɓàn maá lá wee cà?» Á ɓa bía: «Lé yìa ó o bíaráa ho yahó.» Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Ɓa *lànpó féwá lè ɓa hã́awa na wee yɛ̀ɛ́ míten á à zo le *Dónbeenì bɛ́ɛnì yi á à dí mi yahó. ");
INSERT INTO boxNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Lé bìo ó o Zãn Batiisi ɓuara, á ɓueé wee zéení ho wã-tente bìo làa mia, á mi yí tà mu yi. Ká ɓa lànpó féwá lè ɓa hã́awa na wee yɛ̀ɛ́ míten bán tà mu yi. Á bìo mi yàá pá mɔn bṹn, à mi pá yí yèrèmáa mi yilera lè mi wárá, á yí tà a bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Mi wíoka ɲí wàhiire ɓúi: Mɔhṹ ɓànso ɓúi hĩ́a fá ho èrézɛ̃́n vĩ̀nsĩ̀a mí mɔhṹ yi, á son ho dándá kĩ́nía yi. Ò o có ho kɔ̃hṹ á wíokaa, hìa ho èrézɛ̃́n wee ɲaa yi. O mún son o paro lùe. Bṹn mɔ́n ó o wã̀anía tò lè ɓa nùpua ɓúi na à và ho, ò orɛ́n wà van le khúii. ");
INSERT INTO boxNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pã̀ahṹ na ho èrézɛ̃́n wee be yi, ó o tonkaa mí ton-sáwá le ɓa va ɓa nùpua mu cɔ̃́n le ɓa khé bìo bìo sã̀ mí yi à na. ");
INSERT INTO boxNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ká ɓa nùpua mu màhã́ vaá wìikaa ɓa, á han o nì-kéní, á ɓó a ɲun níi so, á mún lèekaa o tĩn níi so lè hã huaa ɓó. ");
INSERT INTO boxNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ó o mɔhṹ ɓànso bĩnía tonkaa ɓa ton-sáwá mu ɓúi. Bán boo po bìa lè ho yahó. Ká ɓa nùpua mu màhã́ vaá wó bán làa bìo ɓa wó làa bìa so. ");
INSERT INTO boxNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mu véeníi, ó o tonkaa mí za, ò o wee leéka: ‹Ĩ za wón ɓa à kɔ̃̀nbi.› ");
INSERT INTO boxNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ká bìo ɓa nùpua mu yère dá a wán, á ɓa wee bío mín yi: ‹Yìa lua kà lé yìa á ho mɔhṹ bìo khíi sĩ̀ yi. Mi wa ɓúe o, á ho mɔhṹ bìo wã́a à sĩ̀ wɛn›. ");
INSERT INTO boxNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","À ɓa hĩ́nɔn wìira a, á khɛ̀ra lée ɓó día.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ó o Yeesu tùara ɓa yi: «Àwa, ká a mɔhṹ ɓànso khíi ɓuara, ó o ɓueé wé ɓa nùpua mu kaka?» ");
INSERT INTO boxNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Á ɓa bía nɔn wo yi: «O máa cɛ̀ɛ ɓa bìo máa día. Ɓa nì-sũmáa mu o ò ɓúe, ká a cà nì-vio á à kúee mí mɔhṹ mu yi. Ó orɛ́n làa bán á à wã̀aní ì tè bìo ɓa khíi na a yi wán, ho pã̀ahṹ na ɓa dó nɔn mín yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bṹn mɔ́n, ó o Yeesu bía nɔn ɓa yi: «Mi dĩǹ yí kàránna bìo kà yí mɔn hùúu le Dónbeenì bíonì vũahṹ yi le? ‹Le huee na ɓa so-sowa fù pã́ día lé dìo hĩ́a ɓuee ɓuan ho soró dĩ̀nía. Bìo kà lé bìo ó o Ɲúhṹso Dónbeenì wó, mu lée bè-tente wa yèn-dã́ní yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","O Yeesu pá bĩnía bía: «Lé bṹn nɔn á ĩ ì bíoráa mu á à na mia. Le *Dónbeenì bɛ́ɛnì á à fé mi cɔ̃́n á à na nì-vio yi, bìa á à ha le bɛ́ɛnì mu ɓàn bia mí bɛɛre. ");
INSERT INTO boxNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yìa lùwá le huee mu wán, á ɓànso sãnía á à yáa. Ká yìa á le ɓɛ̀n kùera lion wán, á ɓànso á à fùfúuka.» ");
INSERT INTO boxNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bìo ɓa yankarowà ɲúnása lè ɓa *Farizĩɛwa ɲá a Yeesu wàhio na ó o wà, á ɓa zũna le lé ɓarɛ́n ó o wee bío bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Á ɓa wã́a wee cà bìo ɓa à wé wé á à ɓúeráa wo, ká ɓa màhã́ zã́na ɓa zã̀amáa na wee lá a Yeesu lè le *Dónbeenì ɲi-cúa fɛɛro. ");
INSERT INTO boxNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","O Yeesu pá bĩnía wà hã wàhio á bíaráa làa bìa wee ɲí a cɔ̃́n. O bía bìo kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ho wáayi bɛ́ɛnì bìo ɓonmín làa bìo kà: Bɛ́ɛ ɓúi sá ho dĩ́nló mí za yaamu yi. ");
INSERT INTO boxNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ó o tonkaa mí ton-sáwá le ɓa vaa yí bìa ó o vonka ho dĩ́nló mu bìo yi le ɓa ɓuen. Ká ɓa màhã́ yí wi ɓa ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ó o bĩnía tonkaa mí ton-sáwá ɓúi á nɔn le ɲii na kà ɓa yi: ‹Mi vaa bío bìo kà à na bìa á ĩ von yi: Ĩ dãaní lè ĩ bùaa na ɲini wi á fũ̀aana, ĩ dĩ́nló bìo ɓúenɓúen wíokaa vó. Mi wã́a ɓuen mu yaamu sã́nú dĩ́nló díiníi.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ká bìa ɓa von màhã́ yí càtío mu, á ɓa wà vaá wee sáka mí tonni. Ɓa ɓúi vanka mí mana. Ɓa ɓúi vaá wee duan. ");
INSERT INTO boxNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Á bìa ká wìira ɓa ton-sáwá mu han lè mí sòobɛ́ɛ, à ɓa ɓó ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ó o bɛ́ɛ sĩi cã̀, ó o tonkaa mí dásíwá le ɓa vaa ɓúe bìa wó mu, à cĩ̀í ɓa lóhó. ");
INSERT INTO boxNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bṹn mɔ́n ó o bía nɔn mí ton-sáwá yi: ‹Mu yaamu sã́nú dĩ́nló sá vó, ká bìa á ĩ von lé bìa yí ko ɓa dí ho. ");
INSERT INTO boxNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mi wã́a lɛ́n zo ho lóhó ɓonfúaa yi, à bìa mi zoó yí bĩ́n ɓúenɓúen à mi ve le ɓa ɓuee dí ho dĩ́nló mu.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Á ɓa ton-sáwá wà zoó von bìa ɓa fòráa mín ɓúenɓúen, ɓa nì-kora lè ɓa nì-tentewà. Á ho sã́nú díiníi zĩi ɓueé sú lè ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ó o bɛ́ɛ yòó zon le zĩi yi, á zoó wee loń bìa ɓa vonka. Ó o mɔn o nì-kéní ɓúi ɓa tĩ́ahṹ ò o yí zã́ ho sã́nú báká. ");
INSERT INTO boxNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ó o bía nɔn wo yi: ‹Wàn bɔ̃́nlo, fo wó kaka zonnáa hen à ũ yí zã́ ho sã́nú báká?› Ó o nìi yí dàńna dɛ̀ɛ yí bía. ");
INSERT INTO boxNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ó o bɛ́ɛ nɔn le ɲii mí ton-sáwá yi: ‹Mi wìi wo ca zení là a níní, à lée lèe día ho khũuhũ le tíbírí yi, hen na le wɛ́ɛ lè le minka yi vɛ́ɛ wi yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ò o Yeesu bĩnía bía «Bìa von boo. Ká bìa hueekaa bán yí tà yí boo.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɓa *Farizĩɛwa wà vaá wã̀anía tò bìo ɓa à tùa là a Yeesu yi wán, á à yíráa o níi ì ɓua yi. ");
INSERT INTO boxNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Á ɓa tonkaa mí nì-kenínia nùwã yɛn ɓúi là á *Heroode mɔ́n nùpua nùwã yɛn le ɓa vaa bío bìo kà na a Yeesu yi: «Nì-kàránlo, wa zũ le fo wee mì ho tũ̀iá. Bìo le Dónbeenì le ɓa nùpua ɓua lè miten, lé bṹn ɓàn kàránló binbirì á fo wee na. Fo yí máa zɔ̃́n nùpue. Fo mún yí máa kà nùpue yìo. ");
INSERT INTO boxNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Àwa, á ũ zéení bìo fo wee leéka bìo kà dã́ní yi: Wa làndá yi á ho lànpó ko ho wé cã na ho Oroomu bɛ́ɛ yi lée, tàá mu yí ko làa wéró?» ");
INSERT INTO boxNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ó o Yeesu zũna hã yile-kora na wi ɓa yi, ó o bía nɔn ɓa yi: «Mi yí mɔn miten le. Mi wee cà ĩ níi á à ɓua yi le we? ");
INSERT INTO boxNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Le wárí na á mi wee sàání lè ho lànpó á mi na le ĩ loń.» Á ɓa ɓuan le wɛ́n-hɔ̃nló ɓueé nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ó o Yeesu tùara ɓa yi: «Ho yahó lè le yèni na wi le wɛ́n-hɔ̃nló mu wán á wée te?» ");
INSERT INTO boxNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Á ɓa bía: «Lé o bɛ́ɛ Sezaare.» Ó o Yeesu wã́a bía nɔn ɓa yi: «Àwa. Bìo sã̀ a bɛ́ɛ yi, à mi na mu wo yi. Ká bìo ɓɛ̀n sã̀ le Dónbeenì yi, à mi na bṹn dén yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bìo ɓa ɲá bìo ó o Yeesu bía kà, á ɓa wó coon, á ɓa wã́a día wo à ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mu zoǹ, á ɓa *Sadusĩɛwa wà ɓuara a Yeesu cɔ̃́n. (Ɓarɛ́n lé bìa le ɓa nì-hía máa vèe.) ");
INSERT INTO boxNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓa tùara a Yeesu yi làa bìo kà: «Nì-kàránlo, bìo kà lé bìo ó o *Mɔyiize bía: ‹Hen ká báa ɓúi yan mín hã́a á húrun ò o yí yú za làa wo, á ɓàn za ɓúi ko ò o ya a mahã́a mu, à te ɓa zàwa yi mín za mu yèni yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mu ù wé à zàwa nùwã hèɲun ɓúi hĩ́a wi làa wɛn. Yìa nín-yání yan á húrun ò o yí yú za lè mín hã́a. ");
INSERT INTO boxNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Á yìa sã̀ fó a mahã́a mu yan á wón húrun. Ó o tĩn níi so fó a, á wón mún húrun. Ɓa mí nùwã hèɲun ɓúenɓúen yan wo bèenia á húrunka. ");
INSERT INTO boxNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bìo ɓa ɓúenɓúen húrun, ó o hã́a mu mún húrun. ");
INSERT INTO boxNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Àwa, á ɓa nì-hía vèe nɔ̀nzoǹ ó o hã́a mu bìo á à sĩ̀ a yɛ́n yi ɓa nùwã hèɲun mu tĩ́ahṹ? Bìo ɓa ɓúenɓúen màhã́ yan wo bèenia.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ó o Yeesu bía nɔn ɓa yi: «Mi wee vĩ́iní miten. Mi yí zũ hàrí dɛ̀ɛ le Dónbeenì bíonì vũahṹ bìo dã́ní yi. Mi mún yí zũ le le Dónbeenì dà bìo ɓúenɓúen wee wé. ");
INSERT INTO boxNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bìo wi bĩ́n, hen ká ɓa nì-hía khíi vèera, á ɓa báawa lè ɓa hã́awa máa ya mín. Ɓa à wé lè le Dónbeenì wáayi tonkarowà bìo síi ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɓa nì-hía vèeró bìo dã́ní yi, á mi so dĩǹ yí kàránna bìo le Dónbeenì bía nɔn mia le? ");
INSERT INTO boxNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Le bía le minɛ́n lé o *Abarahaamu, là á *Izaaki, là á *Zakoobu ɓàn Dónbeenì. Le Dónbeenì lé bìa yìo wi lua ɓàn Dónbeenì. Le yínɔń nì-hía ɓàn Dónbeenì.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓa zã̀amáa na ɲá a bíoní á wó coon o kàránló bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bìo ɓa *Farizĩɛwa ɲá ò o Yeesu bía ɓó ɓa *Sadusĩɛwa ɲúhṹ, á ɓa kúaa mín wán. ");
INSERT INTO boxNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Á ɓa nì-kéní na lé ho làndá bìo zéenílo wi ò o yí o níi ɓua yi, ó o tùara a yi: ");
INSERT INTO boxNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Nì-kàránlo, hã bíoní na bìo henía ho làndá yi, á lé le yɛ́n ɲúhṹ wi po hĩ̀a ká?» ");
INSERT INTO boxNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ó o Yeesu bía nɔn ɓa yi: «‹Fo ko ũ wań ũ Ɲúhṹso Dónbeenì lè ũ sĩi ɓúenɓúen, lè ũ mànákã̀ ɓúenɓúen, lè ũ yilera ɓúenɓúen.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dén lé dìo bìo here, á ɲúhṹ wi po hĩ̀a ká. ");
INSERT INTO boxNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dìo sã̀ le yi na mún ɲúhṹ wi lè lerɛ́n bìo síi lé dìo kà: ‹Fo ko ũ wań mi ninza làa bìo á fo waráa ũten bìo síi.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","O *Mɔyiize làndá ɓúenɓúen, lè le *Dónbeenì ɲi-cúa fɛɛrowà kàránló ɓúenɓúen, á can hã bíoní bìo ɲun na bò henía kà yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bìo ɓa *Farizĩɛwa kúaa mín wán, ó o Yeesu tùara ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Mi wee leéka le *Yìa le Dónbeenì mɔn léra nɔnkãni can wen?» Á ɓa bía nɔn wo yi: «O lé o *Daviide mɔ̀nmàníi.» ");
INSERT INTO boxNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ó o Yeesu bía nɔn ɓa yi: «Á bìo le Dónbeenì Hácírí dú a Daviide yahó, ó o ɓɛ̀n wó kaka vonnáa wo le mí Ɲúhṹso? Bìo kà lé bìo ó o Daviide bía: ");
INSERT INTO boxNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹O Ɲúhṹso Dónbeenì bía nɔn ĩ Ɲúhṹso yi: Ɓuee kɛɛní ĩ nín-tĩánì fúaa ká ĩ ɓúrá ũ zúkúsa ũ tá, á ũ bò ũ zení wán.› ");
INSERT INTO boxNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ká a Daviide wã́a wee ve o Yìa le Dónbeenì mɔn léra le mí Ɲúhṹso, ó o wé o Ɲúhṹso ká a mún pá à bĩní ì wé o mɔ̀nmàníi kaka?» ");
INSERT INTO boxNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Á ɓa nìi woon yí dàńna dɛ̀ɛ yí bía. À lá bṹn zoǹ ó o ɓúi yí bĩnía yí khà míten yí tùara a yi làa bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ó o Yeesu wã́a yèrèmáa wee bío lè ɓa zã̀amáa lè mí nì-kenínia: ");
INSERT INTO boxNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ho *làndá bìo zéenílowa lè ɓa *Farizĩɛwa wee kàrán o *Mɔyiize làndá làa mia. Hón lé ɓa tonló. ");
INSERT INTO boxNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mi ko mi wé ɲí ɓa cɔ̃́n, à bè bìo ɓa wee bío na mia ɓúenɓúen yi. Ká ɓa wárá hɔ̃́n mi yí dé miten yi. Lé bìo á bìo ɓa wee kàrán làa mia ɓa yí máa wé. ");
INSERT INTO boxNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓa wee ɲì ho sèró na lì ɓa nùpua bà-ɲúná wán, ká ɓarɛ́n mí bɛɛre màhã́ yí máa dé mí níní hàrí cĩ́inú à séení ɓa sèráa ho. ");
INSERT INTO boxNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ɓa wee wé mí bìo ɓúenɓúen à zéenínáa míten. O Mɔyiize làndá bíoní ɓúi kúeeníi lùakùa zàwa na ɓa wee ca mí ɓuráa lè mí bàra yi á ɓarɛ́n wee wé à hã wé ɓùaaka. Ɓa kánɓunwà ɲi-kã́a dùɓúaaní á wee kɛń khèekhàa. ");
INSERT INTO boxNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ho dĩ́nló díiníi kɛɛnínía na seka, lè ho kàránló zĩní yahón lùa, á ɓa wa kɛɛníló. ");
INSERT INTO boxNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɓa wa à ɓa nùpua wé tɛ̀ɛní ɓa yi lè le kɔ̃̀nbii ɓa zã̀amáa fèmínló lara yi, á mún wa à ɓa nùpua wé ve ɓa làa nì-kàránlowà. ");
INSERT INTO boxNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ɛ̀ɛ ká minɛ́n ó o ɓúi yí tà le ɓa ve o làa nì-kàránlo. Mi ɓúenɓúen lè ɓa zàwa mín yi, á mi nì-kàránlo mún lé o nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mi wé yí ve nìi woon lè mìn maá ho tá wán. Lé bìo á mìn Maá lé o nì-kéní, wón wi ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","O ɓúi yí tà le ɓa ve o làa ɲúhṹso. Lé bìo mi ɲúhṹso lé o nì-kéní. Wón lé o *Krista. ");
INSERT INTO boxNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yìa po mi ɓúenɓúen ko ò o wé mi ton-sá. ");
INSERT INTO boxNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yìa yòonía míten, á wón ɓa à liiní. Ká yìa liinía míten, á wón ɓa à yòoní. ");
INSERT INTO boxNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Minɛ́n *làndá bìo zéenílowa lè minɛ́n *Farizĩɛwa nì-khàwa yɛ́n! Ho yéréké khíi sá mia. Lé bìo mi wee hè ɓa nùpua lè ho wáayi bɛ́ɛnì díró. Minɛ́n mi bɛɛre yí dà máa dí le, á bìa wi ɓa dí le á mi mún wee hè. ");
INSERT INTO boxNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Nì-khàwa yɛ́n! Ho yéréké khíi sá mia. Mi wee fé ɓa mahã́awa níi bìo ɓúenɓúen véení, ká mi pá bĩní wé ho fìoró na túee à zéenínáa le mi térénna. Lé bṹn nɔn á minɛ́n cítíi khíi wé here làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Nì-khàwa yɛ́n! Ho yéréké khíi sá mia. Mi wee vará ho tá lùa ɓúenɓúen yi, à pà hã muna hɛ́ɛ cà ɓa nùpua le ɓa yèrèmá mí yilera lè mí wárá. Ká mi yú a nì-kéní sãanì à mi wé ò o bìo sĩ̀ le *Dofĩ́ní dɔ̃hṹ yi poń minɛ́n làa cúa-ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Minɛ́n ya-dí muiiwà yɛ́n! Ho yéréké khíi sá mia. Lé bìo mi wee bío bìo kà: Yìa báa lè le *Dónbeenì zĩ-beenì yèni, se bṹn dɛ̀ɛ ɓúi mía. Ká a màhã́ báa lè le Dónbeenì zĩ-beenì ɓàn sã́nú yèni, se bṹn yí dà máa día kà. ");
INSERT INTO boxNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mi lé ɓa bɔ̃́nbúwá, á lé ɓa muiiwà. Lé mu yɛ́n ɲúhṹ wi po mu yɛ́n? Lé ho sã́nú lée, tàá lé le Dónbeenì zĩ-beenì na nɔn á ho sã́nú mu bìo sã̀náa le Dónbeenì yi? ");
INSERT INTO boxNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mi mún wee bío le yìa báa lè mu hãmu cĩ̀íníi ɓàn yèni, se bṹn dɛ̀ɛ ɓúi mía. Ká a màhã́ báa lè mu hãmu na wi le wán yèni, se mu máa día kà. ");
INSERT INTO boxNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Muiiwà yɛ́n! Lé mu yɛ́n ɲúhṹ wi po mu yɛ́n? Lé mu hãmu lée, tàá lé mu ɓàn cĩ̀íníi na nɔn á mu hãmu mu bìo sã̀náa le Dónbeenì yi? ");
INSERT INTO boxNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yìa cén báa lè mu hãmu cĩ̀íníi, se ɓànso báa làa bìo ɓúenɓúen na wi le wán yèni. ");
INSERT INTO boxNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Á yìa báa lè le Dónbeenì zĩ-beenì yèni, se ɓànso báa lè le zĩ-beenì mu, á mún báa lè le Dónbeenì na wi le yi yèni. ");
INSERT INTO boxNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Á yìa mún báa lè ho wáayi yèni, se ɓànso báa lè le *Dónbeenì bɛ́ɛnì kanmúiní yèni, á báa lè le Dónbeenì mí bɛɛre na kará lè wán yèni. ");
INSERT INTO boxNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Minɛ́n làndá bìo zéenílowa lè minɛ́n Farizĩɛwa nì-khàwa yɛ́n! Ho yéréké khíi sá mia. Lé bìo hã vɔ̃n-zà-wĩ́níwà lè mí sìíwà na ɓa wee kúee le zeení yi á mi wee na ɓàn cúa-pírú níi, à ho làndá kàránló na ɲúhṹ wi á mi màhã́ wee pɔ̃́n día. Bṹn na lé ho térénló, lè le hii, lè le Dónbeenì bìo tàró. À bṹn lé bìo mi ɲɔǹ lá ko mi wé wé, ká mi mún yí nɔnsã bìo ká wéró yi. ");
INSERT INTO boxNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ya-dí muiiwà yɛ́n! Mi wee líi mi bè-ɲunii à lén o dònwĩ́a día, ká a cón-ɲúmúkũ̀ wón mi màhã́ wee vĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Minɛ́n *làndá bìo zéenílowa lè minɛ́n Farizĩɛwa nì-khàwa yɛ́n! Ho yéréké khíi sá mia. Lé bìo mi wee sɛɛ mu ɲumu ɲuuníi lè ho dĩ́nló díiníi sĩ̀a ɓàn máa, ká hã yiwa màhã́ zoó sú lè mí kɔ̃̀nló bìo, lè mi yile-kora. ");
INSERT INTO boxNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizĩɛ muii yɛ́n! Ũ yi lé dìo ũ ceé vé, lé bṹn á à na ká bìo ho khũuhũ á à ce. ");
INSERT INTO boxNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Minɛ́n làndá bìo zéenílowa lè minɛ́n Farizĩɛwa, nì-khàwa. Ho yéréké khíi sá mia. Mi ka lè hã búráa na ɓa khũunía máa á hã se, ká hã yiwa màhã́ zoó sú lè ɓa nì-hía hũaa lè mu bè-sooní lè mi sìíwà. ");
INSERT INTO boxNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Minɛ́n mún ka kà síi. Ho khũuhũ á mi ka lè mi lé ɓa nì-tentewà ɓa nùpua yahó, ká mi yiwa hɔ̃́n sú lè ho nì-khɛ̀nló lè mu bè-kora lè mi sìíwà. ");
INSERT INTO boxNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Minɛ́n làndá bìo zéenílowa lè minɛ́n Farizĩɛwa nì-khàwa yɛ́n! Ho yéréké khíi sá mia, lé bìo mi wee so le *Dónbeenì ɲi-cúa fɛɛrowà na húrun búráa, á wee donkhueé bìa fù térénna miten búráa. ");
INSERT INTO boxNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mi wee bío: Ká wàn maáwà pã̀ahṹ á warɛ́n lá yánkaa wi yi, se ɓa ɲi-cúa fɛɛrowà ɓúeró bìo á wa níní mía yi. ");
INSERT INTO boxNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","À bṹn mi bíoní lè mi wárá wee zéení le bìa ɓó le Dónbeenì ɲi-cúa fɛɛrowà, bán mɔ̀nmànía lé minɛ́n mi bɛɛre. ");
INSERT INTO boxNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Àwa á mìn maáwà mu bìo na á ɓa ɓúa ɲúhṹ á mi wã́a bánbá tií ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mi ka lòn háwá, díhioni yɛ́n! Mi wee leéka le mi dà a kã̀ní le Dofĩ́ní dɔ̃hṹ yi le? ");
INSERT INTO boxNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lé bṹn nɔn, á ĩnɛ́n á à tonka ɓa ɲi-cúa fɛɛrowà lè mu bè-zũńminì ɓànsowà, làa bìa kàránna dɔ̃n mi cɔ̃́n. Á mi ì ɓúe ɓa ɓúi, ká ɓa ɓúi mi ì ɓúɛɛ hã *kùrùwáwá wán. Ɓa ɓúi bán mi ì ha lè hã làbàaní mi kàránló zĩní yi, á wé è ɲaka ɓa hã lórá yi á à beé lò. ");
INSERT INTO boxNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lé bṹn á à na ká bìa minɛ́n lè mìn ɓùaawa ɓó ká ɓa bè-yáanii mía, lònbee na wi ɓa ɓúeró mɔ́n á à yí mia. Le nì-ɓúee mu ɓúakáa o *Abɛɛle nì-tente ɓúero ɲii wán, á ɓueé ɓó a Barasii za Zakari yi, wón na ɓa ɓó le sòobá-lùe lè mu hãmu cĩ̀íníi pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Le ĩ mì ho tũ̀iá na mia: Ho zuia nùpua lé bán á le lònbee na wi dén nì-ɓúee so mɔ́n á à yí.» ");
INSERT INTO boxNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Éee Zeruzalɛɛmusa! Minɛ́n na wee ɓúe le *Dónbeenì ɲi-cúa fɛɛrowà, á wee lèeka bìa le Dónbeenì tonkaa mi cɔ̃́n lè hã huaa à ɓúe. Lée zen cúa-yɛn á ĩ wi à ĩ ve mia kúee mín wán làa bìo ó o kùeerè wee wé veráa mí zàwa kúee mí mía tá bìo síi à mi yí tà mu. ");
INSERT INTO boxNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Àwa, le Dónbeenì á à pĩ́ mia á mi zĩi á à dĩ̀n coon. ");
INSERT INTO boxNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Le ĩ bío mu na mia: À lá ho zuia ɲii wán, á mi máa bĩní máa mi mi, fúaa nɔ̀nzoǹ na mi khíi wee bío bìo kà: ‹Le le Dónbeenì dúɓua yìa bò o ɓuen o Ɲúhṹso yèni yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bṹn mɔ́n ó o Yeesu ló le *Dónbeenì zĩ-beenì lún yi. Bìo ó o wee lɛ́n, ó o nì-kenínia vá ɓueé ɓó a yi à ɓa wíokaa wee zéení bìo le Dónbeenì zĩ-beenì sonnáa sìí làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ó o Yeesu wã́a bía nɔn ɓa yi: «Bìo kà ɓúenɓúen mi yí mɔn le? Le ĩ mì ho tũ̀iá na mia: Mu ɓúenɓúen khíi fì, á hàrí huee máa kɛń mí ninza huee wán.» ");
INSERT INTO boxNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","O Yeesu yòó kará hã Oliivewa vĩ̀nsĩ̀a ɓúee wán, ó o nì-kenínia mí ɲii yi vá ɓueé ɓó a yi, à ɓa tùara a yi: «Zéení ho pã̀ahṹ na le Dónbeenì zĩ-beenì mu á à fì yi làa wɛn. Lé mu bìowa yɛ́n khíi zéení ũ ɓuenló pã̀ahṹ lè ho dĩ́míɲá véró pã̀ahṹ?» ");
INSERT INTO boxNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ó o Yeesu bía nɔn ɓa yi: «Mi pa miten bìo. Mi yí día le nùpue khà mia. ");
INSERT INTO boxNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lé bìo á nùpua cɛ̀rɛ̀ɛ khíi ɓuen ĩ yèni yi á à bío le mí lé o *Krista. Ɓa à khà ɓa nùpua cɛ̀rɛ̀ɛ á à vĩ́iní. ");
INSERT INTO boxNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hã hĩa táró á mi khíi wé è ɲí sã, hĩ̀a ɓó mia làa hĩ̀a khɛ̀ra. Ká mi màhã́ yí zɔ̃́n. Lé bìo á bṹn bìowa so ko mu wé ho yahó. Ɛ̀ɛ ká bṹn dɛ̀ɛnía máa wé ho dĩ́míɲá véró. ");
INSERT INTO boxNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ho sìí ɓúi khíi wé è lé vaá fi làa sìí veere. Á ho kɔ̃hṹ ɓúi khíi wé è lé vaá fi lè ho kã-veere. Le hĩni, lè ho tá dèkéró á khíi wé è wé hã lùa ɓúi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bṹn bìowa so ɓúenɓúen wéró á khíi kɛń làa bìo ó o hã́-sãníso sãní vía wee wé ɓúakáráa bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Hón pã̀ahṹ so yi, á ɓa nùpua á à dé mia á à na ɓa à beé lò, á à ɓúe. Hã sìíwà nùpua ɓúenɓúen khíi ɲin mia bìo mi tà miì bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hón pã̀ahṹ so yi, á nùpua cɛ̀rɛ̀ɛ á à khíní mí sĩadéró miì. Ɓa wé è bĩní mín máa, á wé è ɲin mín. ");
INSERT INTO boxNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bìa le mí lé le *Dónbeenì ɲi-cúa fɛɛrowà ká mu yí bon á khíi kɛń cɛ̀rɛ̀ɛ. Ɓa à vĩ́iní nùpua cɛ̀rɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mu bè-kora khíi dé wán, á ɓa nùpua cɛ̀rɛ̀ɛ waminì á à tĩ̀ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ká yìa màhã́ hã̀ mí sĩi fúaa mu véeníi, wón á à fen. ");
INSERT INTO boxNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Le *Dónbeenì bɛ́ɛnì bín-tente mu ko le bue ho dĩ́míɲá lùa ɓúenɓúen yi, à hã sìíwà ɓúenɓúen ɲí le, à ho dĩ́míɲá màhã́ bè yi véráa. ");
INSERT INTO boxNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Mi khíi mi mu bè-sũmúi na wee yáa mu bìo ká mu wi le Dónbeenì zĩ-beenì yi, bìo á le *Dónbeenì ɲi-cúa fɛɛro Daniyɛɛle bía bìo. (Yìa wee kàrán bìo kà, à zũń mu kúará sese.) ");
INSERT INTO boxNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hón pã̀ahṹ so yi ká bìa wi ho Zudee yi à bán lùwí yòo hã ɓúaa. ");
INSERT INTO boxNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yìa á à kɛń mí zĩi lòho yí ko ò o lii zoo lá mí bìo ɓúi mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yìa á à kɛń hã mana yi mu pã̀ahṹ yí ko ò o bĩní ɓo à lii lá mí kánɓun mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ho yéréké khíi sá ɓa hã́-sɛ̃ɛnasa lè ɓa hã́-ɲàawa yi mu zoǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mi fìo le Dónbeenì yi à mi lùwíló mu yí wé hã yio pã̀ahṹ, tàá ho *Sabaa zoǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lé bìo á hón pã̀ahṹ so yi ká le lònbee á à wé ɓùaa á à poń dìo khĩína, à lá ho dĩ́míɲá ɲúhṹ ɓúɛɛníi na le Dónbeenì léra mu bìo ɓúenɓúen yi à ɓuee ɓúe ho zuia yi. Á le ɓàn síi mún máa bĩní máa kɛń hùúu. ");
INSERT INTO boxNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ká le Dónbeenì lá yí khò hã wizooní mu yi, á nìi woon lá máa kã̀ní. Ɛ̀ɛ ká le màhã́ khò hã yi ɓa nùpua na le hueekaa bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ká a ɓúi khíi bía nɔn mia: «Mi loń, lé o *Krista na hen, tàá nín-yìa vaá hen, à mi yí tà mu. ");
INSERT INTO boxNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mu bon. Ɓa kristawa lè ɓa ɲi-cúa fɛɛrowà na bìo yí bon khíi kɛń. Ɓa khíi wé è wé mu yéréké bìowa lè mí sìíwà na ka lè mu wee zéení le Dónbeenì pànká á à vĩ́inínáa ɓa nùpua. Hàrí bìa le Dónbeenì hueekaa ká mu lá dà à wé, á ɓa mún ǹ vĩ́iní bán. ");
INSERT INTO boxNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Àwa, ĩ ɓɛ̀n wã́a fèra bía mu nɔn mia. ");
INSERT INTO boxNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ká ɓa wã́a khíi bía nɔn mia le o Krista wi ho tá henì yi, à mi yí va bĩ́n. Tàá ká ɓa bía le lé hen kà ó o sànkaa míten yi, à mi yí tà mu. ");
INSERT INTO boxNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Làa bìo ká ho viohó ɲuiína ho wáayi lùe ɓúi à mu khoomu dɛ̀ɛní kɛń lùa ɓúenɓúen, lé bṹn ɓàn síi ó o *Nùpue Za bĩní ɓuenló bìo khíi wéráa. ");
INSERT INTO boxNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hen na ó o yà-hínii día yi, lé bĩ́n ɓa dùɓúawá wee wé fè mín yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hɔ̃́n wizooní so ɓàn lònbee khĩíló mɔ́n, á le wii á à dé mí yuumu. Ho pĩihṹ khoomu máa bĩní máa kɛń. Hã mànàayio á à kùenka à lii. Ho wáayi bìo ɓúenɓúen á à dèké. ");
INSERT INTO boxNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bṹn ká bìo wee zéení a Nùpue Za ɓuenló á à mi ho wáayi. Á ho dĩ́míɲá nùpua ɓúenɓúen wé è wá ká ɓa à zúnzúrá. Ɓa à mi a Nùpue Za ɓuenló hã dùndúio wán ho wáayi lè mí dàńló lè mí cùkú beenì. ");
INSERT INTO boxNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Le bũaa-beenì sã á à ɲí. O mún ǹ tonka mí wáayi tonkarowà ho tá kónɓúaa mí bìo náa yi, á ɓa à ve bìa le Dónbeenì hueekaa á à kúee mín wán. ");
INSERT INTO boxNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Mi loń ho fíkíyée vĩ̀ndɛ̀ɛ bìo le wee wéráa. Hen ká le ɓàn lakara hĩ́a wee nàma, á wee sà mí vɔ̃n-yórówà, se mi zũ le ho viohó tèró dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lé làa bṹn síi ká mi khíi wee mi bṹn bìowa so ɓúenɓúen wéró, à mi mún zũń le o Nùpue Za ɓuenló sùaráa. O ò ɓuen máa khí. ");
INSERT INTO boxNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Le ĩ mì ho tũ̀iá na mia: Ho pã̀ahṹ na kà nùpua máa hí máa vé ká bṹn bìo so ɓúenɓúen yí wó. ");
INSERT INTO boxNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ho wáayi lè ho tá khíi vé, ká ĩ bíoní hɔ̃́n ǹ kɛń bĩ́n fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Nìi woon yí zũ ho dĩ́míɲá véró wizonle lè ho pã̀ahṹ máa zéení. Le Dónbeenì wáayi tonkarowà yí zũ mu, hàrí le Dónbeenì Za mí bɛɛre yàá pá yí zũ mu. O Maá mí dòn lé yìa zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bìo wó a Nɔwee pã̀ahṹ lé bìo ɓàn síi khíi wé o *Nùpue Za bĩní ɓuenló pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pã̀ahṹ na mu ɲun-beenì dĩǹ yí ɓuara, ká ɓa nùpua wee dí ká ɓa a ɲu, á wee ya mín ká ɓa a yɛɛ́ mí hĩ́nni. Fúaa nɔ̀nzoǹ na ó o Nɔwee zon ho won-beenì yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓa yí zũna bìo ɓúi yahó fúaa bìo mu ɲun-beenì ɓuara ɓueé lá ɓa ɓúenɓúen. Lé bṹn ɓàn síi mún khíi wé o Nùpue Za ɓuenló pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mu pã̀ahṹ ká báawa nùwã ɲun wi mana yi, ó o nì-kéní á à fé è lɛ́nnáa, ká yìa so á à día. ");
INSERT INTO boxNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ká hã́awa nùwã ɲun páanía dĩ̀n wee ni mu bìo, ó o nì-kéní á à fé, ká yìa so á à día. ");
INSERT INTO boxNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mi cén tĩní mí yìo, lé bìo mi yí zũ le wizonle na mi Ɲúhṹso á à ɓuen yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mi zũ mu le ká le zĩi ɓànso lá wee wé zũń o kɔ̃̀nlo ɓuenló bìo ho tĩ́nàahṹ, se o lá wée tĩní mí yìo, á máa día ó o máa zo a zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lé bṹn nɔn á minɛ́n mún tĩní mi yìo, lé bìo ó o Nùpue Za khíi ɓuen ho pã̀ahṹ na mi yí máa dé le o ò ɓuen yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«O ton-sá na yí máa lé mí ɲúhṹso mɔ́n, na hácírí wi lé o yɛ́n? Lé yìa ɓa ɲúhṹso dó ɓa ton-sáwá na ká bìo níi yi, ò o wé na ho dĩ́nló ɓa yi ho pã̀ahṹ na mu ko yi, ");
INSERT INTO boxNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ó o wee sá ho tonló mu á ɓa ɲúhṹso bĩnía ɓueé kúaa wán. O ton-sá mu ɲúhṹ sĩ. ");
INSERT INTO boxNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Le ĩ mì ho tũ̀iá na mia: O ɲúhṹso mu á à bàrá a mí bìo ɓúenɓúen ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ɛ̀ɛ ká a lé o ton-sá kohó, ó o wé è bío bìo kà mí yi: ‹Ĩ ɲúhṹso míana ò o máa ɓuen›. ");
INSERT INTO boxNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ká à hĩ́ní wé è ha mí ninzàwa ton-sáwá, ká à dí ká à ɲu lè ɓa ɲa-ɲuwà. ");
INSERT INTO boxNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wón ton-sá so ɓa ɲúhṹso khíi ɓuen le wizonle na ó o yí zũ yi, lè ho pã̀ahṹ na ó o yí dó yi. ");
INSERT INTO boxNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ká a khíi ɓueé dɔ̃n, ó o ɓueé beé o lò làa sòobɛ́ɛ, á à dé o ɓa ton-sáwá na ló mí ɲúhṹso mɔ́n tĩ́ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ho wáayi bɛ́ɛnì bìo ɓonmín làa bìo kà: Hĩ́nni nùwã pírú ɓúi hĩ́a ɓuan mí fĩ̀ntɛ̃́ɛna wà vaá sĩ́náa o hã́-fĩa ɓàn báa yahó. ");
INSERT INTO boxNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ɓa nùwã hònú lé ɓa bɔ̃́nbúwá ká ɓa nùwã hònú na ká lé ɓa hénlowà. ");
INSERT INTO boxNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bìa lé ɓa bɔ̃́nbúwá á ɓuan mí fĩ̀ntɛ̃́ɛna à ɓa yí ɓuan ho ɲiló yí séenía. ");
INSERT INTO boxNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","À ɓa hénlowà bán ɓuan ho ɲiló á séenía hìa wi ɓa fĩ̀ntɛ̃́ɛna yi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bìo ó o hã́-fĩa ɓàn báa yuaanía ò o máa ɓuen, á ɓa hĩ́nni mí nùwã pírú ɓúenɓúen dũma á mu dãmu ɓó. ");
INSERT INTO boxNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ho tá tĩ́ahṹ á le zèerè sã ɲá: ‹Lé o hã́-fĩa ɓàn báa lua, mi lé lée sĩ́ a yahó›. ");
INSERT INTO boxNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Á ɓa hĩ́nni mí nùwã pírú sĩ̀nkaa, á wee wíoka mí fĩ̀ntɛ̃́ɛna. ");
INSERT INTO boxNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Á ɓa bɔ̃́nbúwá wee bío làa bìa hénkaa: ‹Mi hã wɛn lè mí ɲiló cĩ́inú. Wa fĩ̀ntɛ̃́ɛna wee hí.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Á bán bía nɔn ɓa yi: ‹Ɓùeé. Wa máa wé mu. Ho ɲiló na wa ɓuan máa yí warɛ́n làa mia. Mu sṹaaní à mi va ɓa ɲi-yɛ̀ɛ́rowà cɔ̃́n vaa yà mi ɲiló.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Á ɓa bɔ̃́nbúwá wã́a hĩ́nɔn wà van ho ɲiló yɛ̀ɛníi. Ɓa lɛ́nló mɔ́n, ó o hã́-fĩa ɓàn báa ɓuara. Á ɓa hĩ́nni nùwã hònú na wíokaa mí fĩ̀ntɛ̃́ɛna vó pan wo, á páanía yòó zon làa wo mu yaamu sã́nú díiníi zĩi. Á ɓa pon ho zũaɲii á dó. ");
INSERT INTO boxNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mu ù dé mí yi, à bṹn ɓa hĩ́nni na so ɓɛ̀n ɓueé dɔ̃n, á ɓueé wee wãamaka: ‹Ɲúhṹso, Ɲúhṹso, hɛ́n le wa zo.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ó o hã́-fĩa ɓàn báa bía nɔn ɓa yi: ‹Le ĩ mì ho tũ̀iá na mia: Ĩ yí zũ mia.›» ");
INSERT INTO boxNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ó o Yeesu bĩnía bía bò mu wán. «Mi cén tĩní mi yìo. Lé bìo mi yí zũ le wizonle lè ho pã̀ahṹ na ó o *Nùpue Za á à ɓuen yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ho wáayi bɛ́ɛnì bìo ɓonmín làa bìo kà: Nìi ɓúi le mí ì va le khúii, ó o von mí ton-sáwá á kàràfáa mí níi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O nì-kéní ó o nɔn ho sã́nú kùráa khĩá-hònú yi. Á yìa sã̀ ó o nɔn hã kùráa khĩá-ɲun yi. Ò o tĩn níi so wón ó o nɔn hã kùráa khĩmàni yi. Ɓa nì-kéní kéní yú á héhaa làa bìo ɓa dà wee sáráa. Bṹn mɔ́n ó o wà. ");
INSERT INTO boxNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Á yìa yú hã kùráa khĩá-hònú dɛ̀ɛnía hĩ́nɔn wee duan làa hã, á yú hã kùráa khĩá-hònú bò hã wán. ");
INSERT INTO boxNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yìa yú hã kùráa khĩá-ɲun mún wó làa bṹn bìo síi, ó o yú hã kùráa khĩá-ɲun séenía. ");
INSERT INTO boxNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ká yìa yú hã kùráa khĩmàni wón wà vaá có ho kɔ̃hṹ á lú mí ɲúhṹso sã́nú kùráa yi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Mu míana, bṹn mɔ́n á ɓa ton-sáwá mu ɲúhṹso bĩnía ɓuara. Ó o wã́a le ɓa zéení bìo mí sã́nú bìo wóráa. ");
INSERT INTO boxNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ó o ton-sá na ó o nɔn hã kùráa khĩá-hònú yi ɓuara, á ɓueé zéenía hã kùráa khĩá-hònú na ó o bĩnía yú ò o bía: ‹Ɲúhṹso, fo hĩ́a nɔn ho sã́nú kùráa khĩá-hònú miì. Loń, lé hã khĩá-hònú na á ĩ bĩnía yú.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Á ɓa ɲúhṹso bía nɔn wo yi: ‹Foɓúa, fo wó se. Fo lée ton-sá tente. Bìo fo térénna mu bìo na ɲúhṹ tà mía bìo yi, lé bṹn nɔn á bìo ɲúhṹ wi po bṹn á ĩ khíi kàràfá foǹ. Ɓuen ɓuee zã̀maka làa mi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Bṹn mɔ́n á yìa yú hã kùráa khĩá-ɲun ɓuara á bía: ‹Ɲúhṹso, fo hĩ́a nɔn ho sã́nú kùráa khĩá-ɲun miì. Loń, lé hã khĩá-ɲun ɓúi na á ĩ bĩnía yú.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Á ɓa ɲúhṹso bía nɔn wo yi: ‹Foɓúa, fo wó se, fo lée ton-sá tente. Bìo fo térénna mu bìo na ɲúhṹ tà mía bìo yi, lé bṹn nɔn á bìo ɲúhṹ wi po bṹn á ĩ khíi kàràfá foǹ. Ɓuen ɓuee zã̀maka làa mi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Á yìa yú hã kùráa khĩmàni ɓɛ̀n ɓuara, á ɓueé bía: ‹Ɲúhṹso, ĩ zũ le fo lé o nùpue na lònbee wi. Fo wee lá ho dĩ́nló ho lahó na fo yí te yi, à lá ho dĩ́nló hen na fo yí dù yi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Á ĩ zã́na, á ĩ vaá lú ũ sã́nú kùráa ho tá yi. Àwa, fé ũ sã́nú.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Á ɓa ɲúhṹso bía nɔn wo yi: ‹Ton-sá kohó yɛ́n! Fo lé o pa-dí. Bìo fo zũ à ĩ wee wé lá ho dĩ́nló ho lahó na á ĩ yí dù yi, ");
INSERT INTO boxNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","á fo so lá yí ko ũ vaa bàrá ĩ wárí ho banki yi le? Se bìo á ĩ ɓuara, á ĩ lá vaá fé lé lè le ɓàn cũ̀nú. ");
INSERT INTO boxNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Àwa, mi fé ho sã́nú kùráa khĩmàni mu o cɔ̃́n, à na yìa hã kùráa khĩá-pírú wi cɔ̃́n yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","«Yìa bìo wi á ɓa à na mu ɓúi ɓànso yi yòó bè, o ò yí á à puuní. Ká yìa bìo mía, á hàrí mu bè-za na wi o cɔ̃́n, á ɓa pa à fé. ");
INSERT INTO boxNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ká a ton-sá na dà-ɲìánii mía á mi lá lée lèe día ho khũuhũ, le tíbí-cũaá yi, hen na le minka yi vɛ́ɛ lè lé wɛ́ɛ wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ká a *Nùpue Za khíi bĩnía bò lè mí wáayi tonkarowà ɓúenɓúen ɓuara lè mí cùkú beenì, ó o ɓueé kɛɛní mí bá-zàmu kanmúiní wán á à fĩ̀náa le cítíi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Á hã sìíwà nùpua ɓúenɓúen á à kúee mín wán o yahó, ó o wã́a à sanka ɓa nùpua mín yi, làa bìo ó o pi-pa wee wé sɛ́nnáa ɓa pia lén ɓa via yi bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Á ɓa pia ó ò kúee lè mí nín-tĩánì, ká ɓa via ó ò kúee lè mí nín-káahó. ");
INSERT INTO boxNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bṹn mɔ́n ó o bɛ́ɛ á à bío á à na bìa wi là á nín-tĩánì yi: ‹Minɛ́n na á wàn Maá dúɓua yi, mi ɓuen ɓuee fé le bɛ́ɛnì kĩ́a na wíokaa mi bìo yi hàrí ho dĩ́míɲá lénló pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mu bon. Le hĩni hĩ́a dà mi á mi nɔn ho dĩ́nló miì. Á le ɲu-hãní dà mi á mi nɔn mu ɲumu miì. Á bìo á ĩ lé o nì-hãni á mi tà á ĩ huera mi wán. ");
INSERT INTO boxNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Á bìo á ĩ fù wee vará ĩ bírí á mi nɔn le dà-zĩ́nii miì. Ĩ lò fù yí here á mi ɓuan mi sese. Ĩ fù wi ho kàsó yi, á mi ɓueé ɓúɛɛkío mi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Á bìa térénna á à bío bìo kà: ‹Ɲúhṹso, lé wen wa mɔn fo yi à le hĩni dà fo á wa nɔn ho dĩ́nló foǹ, tàá lè ɲu-hãní dà fo á wa nɔn mu ɲumu foǹ á ũ ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lé ho pã̀ahṹ yɛ́n á wa mɔn à ũ lé o nì-hãni á wa tà á ũ huera wa wán. Tàá lé wen á wa mɔn fo à ũ wee vará ũ bírí á wa nɔn le dà-zĩ́nii foǹ. ");
INSERT INTO boxNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lé ho pɔ̃̀n-yɛ́n á ũ lò yí here, tàá á ũ zon ho kàsó yi á wa vaá ɓúɛɛkío fo.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ó o bɛ́ɛ á à bío ò na ɓa yi. Le ĩ mì ho tũ̀iá na mia: Mi wé sansan wó mu nɔn wàn zàwa nì-kéní ɓúi na cĩ́inú yi, se mu lé ĩnɛ́n á mi wó mu nɔn yi. ");
INSERT INTO boxNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Bṹn mɔ́n ó o bɛ́ɛ á à bío ò na bìa wi là a nín-káahó yi: ‹Minɛ́n na le Dónbeenì dánkánía, mi khɛ̀n làa mi. Mi lɛ́n vaa zo ho dɔ̃hṹ na máa hí máa mi yi, hìa lò á pan o *Satãni lè mí tonkarowà. ");
INSERT INTO boxNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mu bon, le hĩni fù dà mi, á mi yí nɔn ho dĩ́nló miì. Le ɲu-hãní fù dà mi, á mi yí nɔn mu ɲumu miì. ");
INSERT INTO boxNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ĩ fù lé o nì-hãni á mi yí tà á ĩ yí huera mi wán. Ĩ fù wee vará ĩ bírí, á mi yí nɔn le dà-zĩ́nii miì. Ĩ lò fù yí here, á fù wi ho kàsó yi, á mi yí ɓúɛɛkío mi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Á ɓa wã́a à bío bìo kà: ‹Ɲúhṹso, lé wen wa mɔn fo yi à le hĩni lè le ɲu-hãní dà fo, à ũ lé o nì-hãni, à ũ wee vará ũ bírí, à ũ lò yí here, à ũ wi ho kàsó yi, á warɛ́n yí séenía fo?› ");
INSERT INTO boxNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ó o bɛ́ɛ á à bío ò na ɓa yi: ‹Le ĩ mì ho tũ̀iá na mia: Mi wé sansan yí wó mu yí nɔn bìa wĩ́níwĩ́ní kà nì-kéní ɓúi yi, se mu lé ĩnɛ́n á mi yí wó mu yí nɔn yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bán nùpua so á à va le lònbee na máa vé lahó yi. Ká bìa térénna bán á à va le mukãnì binbirì na máa vé lahó yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o bía nɔn mí nì-kenínia yi: ");
INSERT INTO boxNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Mi zũ le hen làa wizooní bìo ɲun ká ho *Paaki sã́nú á à dí. Ó o *Nùpue Za ɓa à dé á à na ɓa à ɓúɛɛ ho *kùrùwá wán.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Á ɓa yankarowà ɲúnása lè ɓa *zúifùwa nì-kĩ́a wã́a kúaa mín wán ɓa yankarowà ɲúhṹso beenì na ɓa le Kayiifu lún yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓa wã̀anía tò le mí ì wìi o Yeesu ká mu yí zũ, á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɓa wee bío: «Wa yí ko wa wìi wo ho sã́nú pã̀ahṹ. Ká wa wó mu, á ɓa zã̀amáa á à kánká mu bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bìo ó o Yeesu wi ho Betanii lóhó yi o Simɔn na hĩ́a lé o *ɓùeré nìi zĩi á wee dí, ");
INSERT INTO boxNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ó o hã́a ɓúi ɓueé zon ká a ɓuan ho dṹukó-za na sú lè ho ɲiló na sãmu sĩ á yàwá here. O hã́a mu vá ɓueé ɓó a Yeesu yi, ò o kúaa ho ɲiló mu o ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bìo ó o nì-kenínia mɔn mu, á ɓa yiwa cã̀ mu yi, á ɓa wee bío: «Bìo kà yí nɔn bè-yáarè le? ");
INSERT INTO boxNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ho ɲiló mu ɲɔǹ lá dà à yɛ̀ɛ́ ho yàwá na here yi á à sanka ɓàn wárí á à na ɓa nì-khenia yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ó o Yeesu zũna bìo ɓa wee bío, ó o bía nɔn ɓa yi: «Mi wee zá là a hã́a mu le we? Bìo ó o wó làa mi á se. ");
INSERT INTO boxNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ɓa nì-khenia bán làa mia á a kɛń mín wán fɛ́ɛɛ, ɛ̀ɛ ká ĩnɛ́n wón máa kɛń làa mia fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ho ɲiló mu ó o kúaa ĩ wán á fèra wíokaaráa ĩ sãnía ĩ nùuló bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Le ĩ mì ho tũ̀iá na mia: Le Dónbeenì bín-tente wé buera lùe lée lùe yi, ho dĩ́míɲá ɓúenɓúen yi á ɓa à bío bìo ó o hã́a na kà wó, á ɓa à leéka a bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lé mu ó o Yeesu nì-kenínia pírú ɲun nì-kéní na ɓa le Zudaa Isikariote wà van ɓa yankarowà ɲúnása cɔ̃́n, á vaá bía nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«Hen ká ĩ dó a Yeesu nɔn mia, á mi ì na webio miì?» Á ɓa mà le wɛ́n-hãani ɓóní làa pírú nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","À lá bṹn ɲii wán ó o Zudaa wã́a wee cà bìo ó ò wé wé è déráa o Yeesu ɓa níi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ho *búurú na á ɲa-fĩni yí dó yi sã́nú díró ɓàn nín-yání wizonle zoǹ, ó o Yeesu nì-kenínia wà ɓueé tùara a yi: «Lé wen á fo wi à wa wíoka ho *Paaki sã́nú dĩ́nló bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ó o Yeesu wã́a bía nɔn ɓa yi: «Mi lɛ́n zo ho lóhó yi, ká mi zoó fò mín làa nùpue na, à mi bío na ɓànso yi: O Ɲúhṹso bía le mí pã̀ahṹ dɔ̃n, á lé ũnɛ́n cɔ̃́n á mí ɓueé dí ho Paaki sã́nú yi lè mí nì-kenínia.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Á ɓa nì-kenínia wó bìo ó o Yeesu bía le ɓa wé, á wíokaa ho Paaki dĩ́nló bìo. ");
INSERT INTO boxNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bìo ho zĩihṹ dɔ̃n, ó o Yeesu lè mí nì-kenínia pírú ɲun kará ho dĩ́nló ɲúhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bìo ɓa wee dí, ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Minɛ́n nì-kéní lé yìa á à dé mi ì na.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ó o nì-kenínia yilera lùnkaa mu bìo yi làa sòobɛ́ɛ, á ɓa ɓúakáa wee tùa wo yi lè mí nì-kéní kéní. À yìa le: «Ɲúhṹso, mu lé mínɛ́n le?» À yìa le: «Mu lé mínɛ́n le?» ");
INSERT INTO boxNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ó o Yeesu bía nɔn ɓa yi: «Yìa páanía zoó cã̀ làa mi, wón lé yìa á à dé mi ì na. ");
INSERT INTO boxNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","O *Nùpue Za á à hí làa bìo le Dónbeenì bíonì vũahṹ bíaráa mu. Ká yìa màhã́ níi ì bè mu á ho yéréké è zo ɲúhṹ. Ɓànso yàá lá yí ton, se mu sṹaaní.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ó o Zudaa na á à dé wo ò na á lá le bíonì ò o tùara: «Nì-kàránlo, á lé ĩnɛ́n le, tàá?» Ó o Yeesu bía nɔn wo yi: «Ũnɛ́n lé yìa bía mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bìo ɓa wee dí, ó o Yeesu lá ho búurú, á dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho nɔn mí nì-kenínia yi ò o bía: «Mi fé là. Hón lé ĩ sãnía.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bṹn mɔ́n ó o lá le ɲuuníi dɛ̀ɛ na ho *dìvɛ̃́n wi yi, á dó le Dónbeenì bárákà ò o nɔn ho ɓa yi ó o bía: «Mi ɓúenɓúen fé ɲuka. ");
INSERT INTO boxNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dén lé ĩ cãni na wíokaa wee zéení le Dónbeenì páaníi na le bò bìo, dén lé ĩ cãni na kúaará ɓa nùpua cɛ̀rɛ̀ɛ bè-kora sɛ́ndíaró bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Le ĩ bío mu na mia: À lá bìo kà ɲii wán, á ĩ máa bĩní máa ɲu ho dìvɛ̃́n mu, fúaa nɔ̀nzoǹ na á ĩ khíi bĩní ì ɲu ho wàn Maá Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bṹn mɔ́n, á ɓa sía ho sã́nú lení à ɓa wà yòora hã Oliivewa vĩ̀nsĩ̀a ɓúee wán. ");
INSERT INTO boxNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","O Yeesu wã́a bía nɔn mí nì-kenínia yi: «Ho tĩ́nɔ̀n-kéní na kà yi, ká mi ɓúenɓúen á à pĩ́ ĩ bìo. Mu bon. Mu túara le Dónbeenì bíonì vũahṹ yi kà síi á ɓa wee kàrán: ‹Ĩ ì ɓúe o pi-pa, á ho pi-ɓoohṹ pia á à kɛ́nná à lɛ́n ǹ va hã lùa ɓúenɓúen yi.› ");
INSERT INTO boxNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ɛ̀ɛ ká ĩ vèeró mɔ́n, á ĩ ì dí mí yahó vaá pa mia ho Kalilee kɔ̃hṹ yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ó o Piɛre lá le bíonì á bía nɔn wo yi: «Hàrí à bìa ká ɓúenɓúen pĩ́ ũ bìo, á ĩnɛ́n wón máa pĩ́ mu hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ó o Yeesu bía nɔn wo yi: «Le ĩ mì ho tũ̀iá na foǹ: Ho tĩ́nɔ̀n-kéní na kà yi, ó o kò-bɛ́ɛ máa wá, ká ũnɛ́n bía hã cúa-tĩn le fo yí zũ mi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ó o Piɛre bía: «Ĩ máa bío le ĩ yí zũ fo hùúu, hàrí ká ĩ ko á ĩ hí làa fo.» Á ɓa nì-kenínia na ká ɓúenɓúen bía mu bìo dà-kéní mu. ");
INSERT INTO boxNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ó o Yeesu lè mí nì-kenínia wã́a vaá dɔ̃n le lùe ɓúi na ɓa le Zɛtesemanii, ó o bía nɔn ɓa yi: «Mi kɛɛní hen, ká ĩnɛ́n wón á à lɛ́n ǹ va vaá hen, á vaá fìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ò o fó a Piɛre là a Zebedee zàwa nùwã ɲun wàráa. Ó o yi wã́a ɓúakáa wee dè, á hácírí yáara. ");
INSERT INTO boxNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ó o bía nɔn ɓa yi: «Ĩ hácírí yáara dàkhĩína. Ĩ ka lè ĩ máa fen. Mi kɛɛní hen làa mi à tĩní mí yìo.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bṹn mɔ́n ó o wã́a vá van cĩ́inú, á vaá lií ɓúrá, ò o wee fìo kà síi: «Ĩ Maá, ká mu lá dà à wé, à ũ yí le le lònbee na kà à yí mi. Ɛ̀ɛ ká ɓùeé. Ĩ yí le ĩnɛ́n sĩi bìo wé. Ũnɛ́n lé yìa sĩi bìo wé.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ò o bĩnía ɓuara mí nì-kenínia nùwã tĩn mu cɔ̃́n, á ɓueé yú ɓa à mu dãmu ɓó ɓa. Ó o bía nɔn o Piɛre yi: «Éee minɛ́n, le lɛ́ɛ̀rè dà-kéní na miì fání mi yìo yi á à fìo làa mi lé bṹn mí yí dàńna yí wó lon? ");
INSERT INTO boxNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mi fání mi yìo, à fìo, bèra a na à mi yí zo mu bè-kora wéró yi. O nùpue sĩi wee wé vá mu bè-tente wéro yi, ɛ̀ɛ ká ho pànká na ó o ò wé làa bũ lé hìa mia.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ó o Yeesu bĩnía wà mu cúa-ɲun níi, á vaá wee fìo kà síi: «Ĩ Maá, hen ká le lònbee na kà yí dà máa dà ĩ wán ká le yí yú mi, à ũnɛ́n lé fo sĩi bìo pá wé.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ò o tĩ́n bĩnía ɓuara mí nì-kenínia cɔ̃́n, á ɓueé yú ɓa à mu dãmu ɓó ɓa. Ɓa yí dàńna yí fánía mí yìo. ");
INSERT INTO boxNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mu cúa-tĩn níi, ó o bĩnía wà, á tĩ́n vaá fìora mu bìo dà-kéní mu. ");
INSERT INTO boxNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bṹn mɔ́n, ó o bĩnía ɓuara mí nì-kenínia cɔ̃́n, á ɓueé bía nɔn ɓa yi: «Mi dũma wee vũńka le? Mi loń, ho pã̀ahṹ dɔ̃n. O *Nùpue Za á ɓa à dé ɓa bè-kora wérowà níi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mi hĩ́ní wa lɛ́n. Yìa á à dé mi ì na ɓueé dɔ̃n.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pã̀ahṹ na ó o Yeesu wee bío yi, à bṹn ó o Zudaa ɓueé dɔ̃n. O lé ɓa nì-kenínia pírú ɲun nì-kéní. Ɓa zã̀amáa na bò làa wó á ɓuan hã khà-túa lè hã bũ̀aa. Lé le *Dónbeenì yankarowà ɲúnása lè ɓa *zúifùwa *nì-kĩ́a lé bán tonkaa ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","O Zudaa, yìa á à dé o Yeesu mu á à na, á zéenía bìo ɓa zã̀amáa á à zũńnáa wo. O bía: «Ĩ hĩ́a vaá tɛ̀ɛnía nùpue na yi lè le kɔ̃̀nbii, se wón lé yìa mi wee cà, à ɓa wã́a wìi wo.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ò o dɛ̀ɛnía wà ɓueé ɓó a Yeesu yi ò o bía nɔn wo yi: «Nì-kàránlo, foó.» Ò o tɛ̀ɛnía wo yi lè le kɔ̃̀nbii. ");
INSERT INTO boxNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ó o Yeesu bía nɔn wo yi: «Wàn bɔ̃́nlo, bìo fo wà ɓueé wé hen, à ũ wã́a wé.» Á bìa ká wà ɓueé ɓó a yi, á wìira a. ");
INSERT INTO boxNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Á bìa wi là a Yeesu mu nì-kéní ɓúi dò mí khà-tóní ò o hà le Dónbeenì yankarowà ɲúhṹso beenì ton-sá nín-tĩánì ɲikãahṹ kúio. ");
INSERT INTO boxNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ó o Yeesu wã́a bía nɔn wo yi: «Dé ũ khà-tóní mí lóorè yi. Lé bìo á bìa wee khuii hã khà-túa ɓúenɓúen khíi hí làa hã. ");
INSERT INTO boxNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fo yí zũ ká ĩ lá dà à ve ĩ Maá le o ɓuee séení mi le? Ó o lá à dɛ̀ɛní ì tonka mí wáayi tonkarowà hĩn-táwá ká ɓa po kuio pírú ɲun le? ");
INSERT INTO boxNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ɛ̀ɛ ká mu wó kà, á bìo túara le Dónbeenì bíonì vũahṹ yi á à wé kaka ɲii ì síráa? Mu bon, ho vũahṹ mu yi á mu bía le lé kà síi á mu ko mu wéráa.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bṹn mɔ́n ó o Yeesu bía nɔn ɓa zã̀amáa yi: «Mi so lá ko mi ɓua khà-túa làa bũ̀aa ɓuee wìiráa mi lòn nì-kã́anii le? Làa wizooní ɓúenɓúen ká ĩ lá wee wé kɛɛní le *Dónbeenì zĩ-beenì yi à kàrán ɓa nùpua á mi yí wìira mi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ɛ̀ɛ ká bṹn ɓúenɓúen wó lée bèra a na, à le *Dónbeenì ɲi-cúa fɛɛrowà bìo na ɓa bía le Dónbeenì bíonì vũahṹ yi à ɲii sí.» Á ɓa nì-kenínia ɓúenɓúen wã́a lùwa ɓa día a. ");
INSERT INTO boxNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bìa wìira a Yeesu á ɓuan wo vannáa ɓa yankarowà ɲúhṹso na ɓa le Kayiifu cɔ̃́n. Lé bĩ́n á ho *làndá bìo zéenílowa lè ɓa *zúifùwa nì-kĩ́a kúaa mín wán yi. ");
INSERT INTO boxNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","O Piɛre khɛ̀ra bò a Yeesu mɔ́n fúaa o Kayiifu lún, á vaá zoó páanía kará lè ɓa parowà, á wee loń bìo mu hĩ́a wéráa. ");
INSERT INTO boxNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ɓa yankarowà ɲúnása, lè ho làndá tũ̀iá fɛɛrowà ɓúenɓúen wee cà bìo ɓa à koonínáa o Yeesu yi á à bè yi ì síinínáa o ɲúhṹ á à na ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ká ɓa màhã́ yí yú bìo ɓúi, hàrí bìo ɓa nùpua cɛ̀rɛ̀ɛ pá wã́a ɓuara ɓueé koonía o yi mí cúee. Mu véeníi, á nùpua nùwã ɲun ɓúi ");
INSERT INTO boxNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɓuara ɓueé bía bìo kà: «O nìi mu bía le mí dà à fío le Dónbeenì zĩ-beenì á à bĩní ì so hã wizooní bìo tĩn yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Á ɓa yankarowà ɲúhṹso lií hĩ́nɔn yòó dĩ̀n ò o bía nɔn o Yeesu yi: «Bìo ɓa nùpua mu wee bío ũ dã́ní yi á fo le fo yí máa bío dɛ̀ɛ ɓúi yi le?» ");
INSERT INTO boxNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ó o Yeesu cɛ̀kɛ̀ ò o dĩ̀n. Á ɓa yankarowà ɲúhṹso wã́a bía nɔn wo yi: «Ĩ wee fìo fo, le Dónbeenì na wi fɛ́ɛɛ yèni yi, ká fo lé o *Krista, le Dónbeenì Za, ũ bío mu na wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ó o Yeesu bía nɔn wo yi: «Lé fo bía mu. Le ĩ mì ho tũ̀iá na mia: Á lá bìo kà wán, á mi ì mi a Nùpue Za ká a kará le Dónbeenì na dà mu bìo ɓúenɓúen nín-tĩánì. Mi mún khíi mi a ká a kará hã dùndúio wán wà à ɓuen.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Á ɓa yankarowà ɲúhṹso wã́a lɛ̀ɛkaa mí dà-zĩ́nii lé bìo mu vá a yi dàkhĩína, ò o bía: «Lé le Dónbeenì ó o là. Wa màkóo yàá wã́a mía sɛɛ́ràsa yi. Mi ɲá bìo ó o là lè le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Àwa, á lé mu yɛ́n á mi wee leéka?» Á ɓa bía: «O wó khon, ó o ko ò o ɓúe.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","À ɓa wee pũ̀iní mí ɲinsãní kúee o yahó wán, ká ɓa a vṹaa wo lè mí nín-kuio. Ɓa ɓúi wee fío o sáarà, ");
INSERT INTO boxNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ká ɓa a bío: «Ũnɛ́n Krista, wã́a zéení yìa vĩ́na fo làa wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hón pã̀ahṹ so yi, ò o Piɛre pá kará ho lún yi, á ɓa yankarowà ɲúhṹso beenì ton-sá hã́a nì-kéní vá ɓueé ɓó a yi, á bía nɔn wo yi: «Ũnɛ́n mún lá wi là a Kalilee nìi Yeesu.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ká a Piɛre màhã́ pã́ mu ɓa nùpua ɓúenɓúen yìo yi, ò o bía: «Bìo fo wee bío kà á ĩnɛ́n yí zũ.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ò o wà vaá dĩ̀n ho lún zũaɲii. Ó o ton-sá hã́a nì-kéní tĩ́n mɔn wo, á wón bía làa bìa wi bĩ́n: «Yìa kà là a Nazarɛɛte nìi Yeesu lá páanía wi.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ó o Piɛre tĩ́n pã́ mu ò o báa: «O nìi na kà a ĩnɛ́n yí zũ.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mu dó mi yi cĩ́inú, á bìa bĩ́n vá ɓueé ɓó a Piɛre yi, à ɓa bía nɔn wo yi: «Mu bon kɛ̃́nkɛ̃́n. Fo lé ɓa nì-kéní ɓúi. Ũ bíonì wee zéení mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ó o Piɛre wíokaa báa lè mí sòobɛ́ɛ á bía: «O nìi na kà á ĩ yí zũ hùúu.» Ho pɔ̃̀n-kéní mu yi, ó o kò-bɛ́ɛ wá. ");
INSERT INTO boxNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ó o Piɛre hácírí màhã́ bĩnía ɓuara bìo ó o Yeesu bía nɔn wo yi wán: Sã́ni ò o kò-bɛ́ɛ wá, bṹn ká ũnɛ́n pã́ le fo yí zũ mi á dɔ̃n hã cúa-tĩn. Ó o Piɛre ló, á lée wá bùbùbù. ");
INSERT INTO boxNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Le yìnbíi bùirìi á le *Dónbeenì yankarowà ɲúnása, lè ɓa *zúifùwa nì-kĩ́a ɓúenɓúen páanía wó le ɲii le mí ì na a Yeesu ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Á ɓa nɔn le ɲii le ɓa ca a, à ɓua varáa o *Pilaate cɔ̃́n, yìa ho *Oroomu bɛ́ɛ bàrá ho Zudee kɔ̃hṹ ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bìo ó o Zudaa, yìa dó a nɔn á mɔn ò o Yeesu ɓa síinía ɲúhṹ le mí ì ɓúe, ó o zũna le mí wó khon, ó o yilera yáara, ó o ɓuan le wɛ́n-hãani ɓóní làa pírú á bĩnía ɓueé nɔn le Dónbeenì yankarowà ɲúnása lè ɓa nì-kĩ́a yi, ");
INSERT INTO boxNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ò o bía: «Ĩ ɓɛ̀ntĩ́n wó khon lé bìo á ĩ nɔn yìa yí yáara dɛ̀ɛ le ɓa ɓúe.» Ká bán màhã́ bía nɔn wo yi: «Á bṹn ciran warɛ́n le? Ũnɛ́n lé yìa làa bũ.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ó o Zudaa mìina le wárí kúaará le *Dónbeenì zĩ-beenì yi, ò o ló lée wà, á vaá lù ho hũló zon. ");
INSERT INTO boxNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Á le Dónbeenì yankarowà ɲúnása khuiira le wárí, à ɓa bía: «Wa làndá yi, á dén wárí so síi yí ko le kúee le Dónbeenì zĩ-beenì wárí wán, lé bìo á le lé le cãni wárí.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Á ɓa wã̀anía tò, à ɓa yà ho mɔhṹ ɓúi na ɓa wee ve làa «Có-mí Mɔhṹ» làa de, á wó lè ɓa nì-hãní nùuníi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lé bṹn te bìo ɓa wee veráa ho mɔhṹ mu làa cãni mɔhṹ hàrí lòn zuia. ");
INSERT INTO boxNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Á le *Dónbeenì ɲi-cúa fɛɛro Zeremii bìo na ó o bía á ɲii súráa: «Ɓa khuiira le wɛ́n-hãani ɓóní làa pírú, dén na lé le wárí na ó o *Isirayɛɛle nìpomu héhaa là a yàamu ");
INSERT INTO boxNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","á yà là a có-mí mɔhṹ làa bìo ó o ɲúhṹso bíaráa mu nɔn miì.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bìo ɓa ɓuan o Yeesu vannáa o *Pilaate cɔ̃́n, á wón tùara a yi: «Lé ũnɛ́n lé ɓa *zúifùwa bɛ́ɛ le?» Ó o Yeesu bía nɔn wo yi: «Fo bía mu.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bṹn mɔ́n, á bìo ɓa yankarowà ɲúnása lè ɓa nì-kĩ́a wee kooní a yi, ó o yí bía dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ó o Pilaate wã́a bía nɔn wo yi: «Bìo ɓa wee bío ũ ɲii ɓúenɓúen á fo yí máa ɲí le?» ");
INSERT INTO boxNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ó o Yeesu yí bía dɛ̀ɛ mu ɓúi dã́ní yi. Á mu wó a Pilaate coon dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ho *Paaki sã́nú lée Paaki sã́nú díró yi, à yìa ho *Oroomu bɛ́ɛ bàrá ho Zudee kɔ̃hṹ ɲúhṹ wán à lén o kàsó nìi ɓúi día, yìa ɓa zã̀amáa le o día. ");
INSERT INTO boxNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mu ù wé à kàsó nìi ɓúi wi bĩ́n á yèni ló. Ɓa wee ve o làa Yeesu Barabaasi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ó o Pilaate wã́a tùara ɓa zã̀amáa na kúaa mín wán yi: «Lé o yɛ́n á mi wi à ĩ lén día? Lé o Yeesu Barabaasi lée tàá lé o Yeesu na ɓa le *Krista?» ");
INSERT INTO boxNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","O Pilaate zũ kɛ̃́nkɛ̃́n le ɓa dó a Yeesu nɔn mí yi lé bìo le yandee wi ɓa yi o bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pã̀ahṹ na ó o Pilaate wi le cítíi fĩ̀iníi lahó yi, á ɓàn hã́a le ɓa ɓuee bío bìo kà na a yi: «Yí dé ũ ɲii o nìi mu bìo ɓúi yi. Lé o yí wó yí khon. Ho tĩ́nàahṹ, á ĩ ɓɛ̀ntĩ́n lò bon hã kònkórá yi o bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Á le *Dónbeenì yankarowà ɲúnása lè ɓa *zúifùwa nì-kĩ́a á bía ɓó ɓa zã̀amáa ɲúhṹ, le ɓa fìo o Barabaasi lén díaró ká ɓa ɓúe o Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ó o Pilaate lá le bíonì ò o tùara ɓa yi: «Ɓa nùwã ɲun na kà tĩ́ahṹ, á lé o yɛ́n á mi le ĩ día?» Á ɓa bía nɔn wo yi: «Día a Barabaasi.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ó o Pilaate tùara ɓa yi: «Ká a Yeesu na ɓa le Krista á mi le ĩ wé kakaráa?» Á ɓa ɓúenɓúen bía: «Ɓúɛɛ wo ho *kùrùwá wán ò o hí.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Á wón tùara ɓa yi: «Lée webio ó o wó khon yi?» Á ɓa wíokaa wee bío pɔ̃́npɔ̃́n: «Ɓúɛɛ wo ho kùrùwá wán ò o hí.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bìo ó o Pilaate mɔn ò o yí dà bìo ɓúi máa wé, à ɓa nùpua hoorà wíokaa wee dé wán, ó o lá mu ɲumu ò o sɛɛra mí níní ɓa zã̀amáa yahó ò o bía: «Ĩ níi ló a nìi na kà ɓúeró bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Á ɓa zã̀amáa ɓúenɓúen bía: «Le o húmú bìo sánsá warɛ́n lè wa zàwa.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ó o Pilaate wã́a léra a Barabaasi día, ò o le ɓa ha a Yeesu lè hã làbàaní. Ò o nɔn wo le ɓa ɓúɛɛ ho kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","O Pilaate dásíwá ɓuan o Yeesu zonnáa le zĩ-beenì lún yi, à ɓa von mí ninzàwa na ká ɓúenɓúen á ɓa ɓueé kĩ́nía wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Bìo ɓa le mí ì zùańka a yi, á ɓa tɛra a sĩ̀-zĩ́nia, à ɓa zĩ́inía wo lè ho kánɓun muhṹ. Ɓa tã́ ho ɲúhṹ kìrí lè hã kíkara á yòó bò a ɲúhṹ wán á wó là a bá-zàmu khɔ̃̀nlúee, à ɓa dó le kã́anì o nín-tĩánì, á wee lii fárá mí nɔnkóɲúná wán o yahó, ká ɓa a bío: «Zúifùwa bɛ́ɛ, foó!» ");
INSERT INTO boxNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓa wee pũ̀iní mí ɲinsãní kúee o wán, á wee fé le kã́anì vĩ́n là a ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bìo ɓa zùańkaa wo yi vó, á ɓa tɛra ho kánɓun muhṹ, à ɓa bĩnía zĩ́inía wo là a kùrú sĩ̀a, á ɓuan wo wà vaá ɓúɛɛ ho kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bìo ɓa zoó wee lé ho lóhó yi, á ɓa fò mín làa nìi ɓúi na ɓa le Simɔn. O wee lé ho Sirɛɛna lóhó yi. Á ɓa dásíwá kĩ̀kã́a wo yi le o fé o Yeesu kùrùwá pĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bìo ɓa vaá dɔ̃n ho lahó na ɓa wee ve làa Kolokota, bṹn kúará le «ɲún-ɓòkuee lahó,» ");
INSERT INTO boxNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","á ɓa nɔn ho *dìvɛ̃́n na ɓa lùnkaa lè mu bìo ɓúi na hɛɛ o Yeesu yi le o ɲu. Ká a díndío mu, ó o pã́ le mí máa ɲu mu. ");
INSERT INTO boxNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bìo ɓa ɓúaa wo ho kùrùwá wán vó, á ɓa wó le ɲún-sĩni bìo á sankaaráa o sĩ̀-zĩ́nia, ");
INSERT INTO boxNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","à ɓa kará bĩ́n pan wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓa túara bìo nɔn ɓa síiníanáa o ɲúhṹ ho pɛnpɛrɛn wán á yòó ɓúaa o ɲúhṹ yi: Yìa kà lé o Yeesu, ɓa zúifùwa bɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nì-wànna nùwã ɲun ɓa mún ɓúaa hã kùrùwáwá wán là a Yeesu. O nì-kéní wi là a nín-tĩánì, ó o nì-kéní wi là a nín-káahó. ");
INSERT INTO boxNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓa nùpua na wee khĩí làa bĩ́n wee kìɓón mí ɲúná ká ɓa à là a, ");
INSERT INTO boxNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ká ɓa a bío na a yi: «Ũnɛ́n na lá wi à ũ fío le *Dónbeenì zĩ-beenì à bĩní so le ɓàn dà-veere hã wizooní bìo tĩn yi, wã́a fení ũten. Ká fo lé le Dónbeenì Za, à ũ lé ho *kùrùwá wán lii.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hàrí le Dónbeenì yankarowà, lè ho làndá bìo zéenílowa, lè ɓa nì-kĩ́a wee yáa mí ɲiní yi na a yi ká ɓa a bío: ");
INSERT INTO boxNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«O fenía ɓa ɓúi, ò orɛ́n màhã́ yí dà máa fení míten. O yí le mí lé o Isirayɛɛle nìpomu bɛ́ɛ le? Ó o wã́a lé ho kùrùwá wán lii, á wa à dé wa sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O dó mí sĩi le Dónbeenì yi, á bía le mí lé le Dónbeenì Za. Àwa, ká le Dónbeenì mu wa a, à le wã́a fení a.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɓa nì-wànna na ɓa ɓúaa hã kùrùwáwá wán o nìsã́a mún wee là a làa bṹn síi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Le wii yòo fáráló pã̀ahṹ, á ho kɔ̃hṹ ɓúenɓúen dĩ̀ndĩ̀n wó le tíbírí, á míana fúuu fúaa le wi-háarè. ");
INSERT INTO boxNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Le wi-háarè mu pã̀ahṹ, ó o Yeesu bía bìo kà pɔ̃́npɔ̃́n: «Elii, Elii, lama sabatanii?» (Bṹn kúará le «wàn Dónbeenì, wàn Dónbeenì, fo pã́ mi día le we?») ");
INSERT INTO boxNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Á bìa wi bĩ́n nùwã yɛn ɓúi ɲá mu, á ɓa bía: O wee ve o *Elii. ");
INSERT INTO boxNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Á ɓa nì-kéní lùwa vaá lá le dɛ̀ɛ ɓúi na wee kũ̀iní mu ɲumu ɓua, á ɓueé zìíra mu bè-ɲia yi, á can le ɓùaahiire yi yòó dá a Yeesu yi le o ɲu. ");
INSERT INTO boxNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɓa ɓúi bán ɓɛ̀n wee bío: «Mi día le wa loń le o Elii ɓueé fení a le?» ");
INSERT INTO boxNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ó o Yeesu wíokaa wãamaa pɔ̃́npɔ̃́n, ò o húrun. ");
INSERT INTO boxNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hón pã̀ahṹ so yi, á ho pɔ̃nsò-beenì na zoó céra le Dónbeenì zĩ-beenì yi á yòó lɛ̀ɛra mí tĩ́ahṹ lií ló. Á ho tá dèkío, á hã ɓúaarà bɛnkaa. ");
INSERT INTO boxNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hã búráa ɲiní hɛ́nkaa, á le Dónbeenì nùpua cɛ̀rɛ̀ɛ ɓúi na lá húrun á vèera. ");
INSERT INTO boxNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓa ló hã búráa yi, ó o Yeesu vèeró mɔ́n, á ɓa lií zon le Dónbeenì lóhó Zeruzalɛɛmu yi. Á ɓa nùpua cɛ̀rɛ̀ɛ mɔn ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Á ho Oroomu dásíwá ɲúhṹso lè ɓa dásíwá na lá pan o Yeesu yi á mɔn ho tá dèkéró làa bìo wó, á ɓa zã́na dàkhĩína, á ɓa wee bío: «O ɓɛ̀ntĩ́n lá lé le le Dónbeenì Za binbirì.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hã́awa cɛ̀rɛ̀ɛ mún kɛra bĩ́n, á khɛ̀ra dĩ̀n wee loń. Ɓa lé bìa bò a Yeesu yi hàrí ho Kalilee yi, á wee sá na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ɓa hã́awa mu tĩ́ahṹ ó o Makadala Mari, là a Zaaki là a Zozɛɛfu ɓàn nu Mari, là a Zebedee nùwã ɓàn nu á wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bìo ho zĩihṹ dɔ̃n, á ho Arimatee lóhó nìi ɓúi na lé o nàfòró ɓànso á wà ɓuara. O yèni ɓa le Zozɛɛfu. O mún lá lé o Yeesu nì-kenínia nì-kéní ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wón lé yìa wà vaá fìora a Yeesu nì-hínmu o *Pilaate cɔ̃́n. Ó o Pilaate le ɓa día le o lá. ");
INSERT INTO boxNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ó o Zozɛɛfu lá hã, á bá lè ho pɔ̃nsò-fĩnle, ");
INSERT INTO boxNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","á dó mí kùrú búure yi na ó o có ho ɓúaahó yi. Ò o bĩ̀inía le hue-beenì á pon le ɲii, ò o wà. ");
INSERT INTO boxNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mu wee wé ò o Makadala Mari lè mí yèn-ɓua Mari na so á kará sánsáa le búure. ");
INSERT INTO boxNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mu tá na lée tɔ̃n, ho *Sabaa zoǹ, á ɓa yankarowà ɲúnása, lè ɓa *Farizĩɛwa páanía van o Pilaate cɔ̃́n, ");
INSERT INTO boxNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","á vaá bía nɔn wo yi: «Cùkúso Pilaate, o sabín-fũ̀aalo mu bíonì ɓúi á wa hácírí ɓuara wán. Bìo ó o yìo lá wi lua, ó o bía le mí húmú wizooní tĩn zoǹ ká mí ì vèe. ");
INSERT INTO boxNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cén na le ɲii le ɓa pa le búure yi fúaa mu wizooní tĩn níi, bèra a na ò o nì-kenínia yí ɓuee lén o sãnía ká ɓa bío na ɓa zã̀amáa yi le o vèera. Á dén sabéré so á à poń dìo ho yahó.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ó o Pilaate bía nɔn ɓa yi: «Ɓa dásíwá na a pa le búure yi wi hen, nín-bìa. Mi fé ɓa à mi lɛ́n vaa pa le yi làa bìo mi dà à wé làa bũ.» ");
INSERT INTO boxNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Á ɓa wã́a wà vaá léra le búure mu paró bìo yìo. Le hue-beenì na pon le búure ɲii á ɓa wíokaa pon kũinkũin, á bàrá ɓa dásíwá le ɓa pa le yi. ");
INSERT INTO boxNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ho dimaasi zoǹ tá-tĩa yi, ká ho *Sabaa khĩína, ó o Makadala Mari lè mí yèn-ɓua Mari na so á wà van le búure wán. ");
INSERT INTO boxNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yìo ɓueé tĩ, à ho tá dèkío lè mí pànká, ó o Ɲúhṹso Dónbeenì wáayi tonkaro ɓúi yòó ló lií bĩ̀inía le huee khíi bàrá á yòó kará wán. ");
INSERT INTO boxNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","O wee ɲuiíka lè ho viohó ɲuiíkaró bìo síi, á sĩ̀-zĩ́nia ka pṹiapṹiapṹia. ");
INSERT INTO boxNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɓa parowà zã́na fúaa ɓa wee zà, á ka lè ɓa húrun. ");
INSERT INTO boxNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Á ho wáayi tonkaro lá le bíonì, ò o bía nɔn ɓa hã́awa yi: «Minɛ́n hã́awa mu, mi yí zɔ̃́n. Ĩ zũ le mi wee cà a Yeesu, yìa ɓa ɓúaa ho *kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O mía hen, o vèera làa bìo ó o hĩ́a bíaráa mu. Mi ɓuen ɓuee loń ho lahó na ó o lá dũma yi. ");
INSERT INTO boxNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mi bánbá vaa bío na a nì-kenínia yi le o vèera. Á bìo kà wán, ó o dú ɓa yahó van ho Kalilee kɔ̃hṹ, lé bĩ́n ɓa vaá mi a yi. Bṹn lé bìo á ĩ lá wi à ĩ bío na mia.» ");
INSERT INTO boxNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Á ɓa dɛ̀ɛnía bĩnía fùafùa ká ɓa zɔ̃́nkaa, á ɓa sĩa mún pá wan làa sòobɛ́ɛ, á lùwa vaá bía mu là a Yeesu nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yìo ɓueé tĩ, ò o Yeesu wee sĩ́ ɓa yahó, á bía làa ba: «Mi foó.» Á ɓa vá ɓueé ɓó a yi, á lií ɓuan o zení yi à ɓa ɓùaanía wo. ");
INSERT INTO boxNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ó o Yeesu wã́a bía nɔn ɓa yi: «Mi yí zɔ̃́n. Mi lɛ́n vaa bío na wàn zàwa yi le ɓa lɛ́n va ho Kalilee kɔ̃hṹ, lé bĩ́n ɓa à mi mi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bìo ɓa hã́awa wi ho wɔ̃hṹ wán wà, á ɓa dásíwá nùwã yɛn ɓúi na lá pan le búure yi ɓɛ̀n wà lion ho lóhó yi, á lií bía bìo wó ɓúenɓúen nɔn ɓa yankarowà ɲúnása yi. ");
INSERT INTO boxNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Le *Dónbeenì yankarowà ɲúnása kúaa mín wán lè ɓa *nì-kĩ́a á wã̀anía tò, à ɓa nɔn le wárí na boo ɓa dásíwá yi, ");
INSERT INTO boxNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","à ɓa bía nɔn ɓa yi: «Mi bío le o nì-kenínia ɓueé ɲuaana a ho tá tĩ́ahṹ ká mi dũma. ");
INSERT INTO boxNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hàrí ká a *Pilaate wó wó ɲá mu, á wa à zũń bìo wa à bío á à ɓúeráa o ɲúhṹ, á mi ɲúná á à lé.» ");
INSERT INTO boxNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Á ɓa parowà fó le wárí, à ɓa wó làa bìo ɓa bíaráa mu nɔn ɓa yi. Á mu bɛ̀nbɛ́ra fò hã lùa ɓúenɓúen ɓa *zúifùwa cɔ̃́n á ɓueé ɓó ho zuia yi. ");
INSERT INTO boxNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɓa nì-kenínia pírú dòn wà van ho Kalilee kɔ̃hṹ, le ɓúe-za na ó o Yeesu zéenía làa ba wán. ");
INSERT INTO boxNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bìo ɓa mɔn wo, á ɓa ɓùaanía wo, ká ɓa ɓúi wi ɓa tĩ́ahṹ pá titikaa. ");
INSERT INTO boxNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ó o Yeesu vá ɓuara, ò o bía nɔn ɓa yi: «Mu bìo ɓúenɓúen wéró ho wáayi lè ho tá wán á le Dónbeenì nɔn pànká miì. ");
INSERT INTO boxNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mi wã́a lɛ́n va hã sìíwà nùpua ɓúenɓúen cɔ̃́n, à vaa wé ɓa lè ĩ nì-kenínia. Mi bátízé ɓa o Maá là a Za lè le Dónbeenì Hácírí yèni yi. ");
INSERT INTO boxNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mi kàrán ɓa à ɓa wé bè bìo ɓúenɓúen na á ĩ henía nɔn mia yi. Mi zũń mu, ĩ ì kɛń làa mia hã wizooní ɓúenɓúen yi fúaa ho dĩ́míɲá véró.»");
INSERT INTO boxNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dìo kà lé le bín-tente, dìo wee zéení le Dónbeenì Za Yeesu *Krista bìo ɲúhṹ ɓúɛɛníi ");
INSERT INTO boxNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","làa bìo le Dónbeenì bía mí ɲi-cúa fɛɛro *Ezayii vũahṹ yi: «Ĩ ì tonka ĩ tonkaro o ò dí ũ yahó á ɓueé wíoka ũ wɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nìi ɓúi wee bío pɔ̃́npɔ̃́n le dùure yi kà síi: ‹Mi wíoka ho wɔ̃hṹ ká a Ɲúhṹso ò ɓuen. Mi muin ho wɔ̃hṹ na o ò bè.›» ");
INSERT INTO boxNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Á lé bṹn mu ɓɛ̀n wóráa. O nìi ɓúi na ɓa le Zãn hĩ́a wi le dùure yi, á bìo kà lé bìo ó o wee bue: «Mi ɓuen à ĩ bátízé mia, lé bṹn á à zéení le mi khú mu bè-kora wéró yi, á bò le Dónbeenì yi, á le è sɛ́n mi bè-kora á à día.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ho Zudee kɔ̃hṹ nùpua lè ho Zeruzalɛɛmu lóhósa ɓúenɓúen wee lé ɓuen o cɔ̃́n. Ɓa wee zéení mí bè-kora ɓa nùpua yahó, ò o Zãn bátízé ɓa ho Zurudɛ̃n muhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","O Zãn dà-zĩ́nii tã́ là a cón-ɲúmúkũ̀ varà, á ku-cɛɛ̀níi wó lè ho sãahṹ. O bè-dínii lé ɓa hawà lè hã sò-kĩa sòró. ");
INSERT INTO boxNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bìo kà lé bìo ó o hĩ́a wee bue na ɓa zã̀amáa yi: «Nùpue ɓúi wi ĩ mɔ́n wà a ɓuen, wón po mi. Ĩ yàá yí ko là a nakãa tɛnló hùúu. ");
INSERT INTO boxNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ĩnɛ́n bátízéra mia lè mu ɲumu yi, ká arɛ́n wón khíi bátízé mia lè le Dónbeenì Hácírí.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","O Yeesu wã́a ló ho Kalilee kɔ̃hṹ lóhó na ɓa le Nazarɛɛte yi á van o Zãn cɔ̃́n, á wón bátízéra a ho Zurudɛ̃n muhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","O Yeesu zoo léeníi mu ɲumu yi, ó o mɔn ho wáayi à ho ɲii hɛ́ra lè mí pànká, á le Dónbeenì Hácírí lion lòn háponi o wán. ");
INSERT INTO boxNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Á mu tãmu ɓúi sã ɲá ho wáayi, á bía: «Fo lé ĩ Za na á ĩ bò ĩ tàká wán, ũ bìo sĩ miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bṹn mɔ́n á le Dónbeenì Hácírí dɛ̀ɛnía ɲàana a vannáa le dùure yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O wó hã wizooní ɓúará-ɲun bĩ́n. Lé hón pã̀ahṹ so ɓúenɓúen ó o Satãni khà a yi lońna. O kɛra ɓa naɲuwà tĩ́ahṹ bĩ́n á bìo ó o màkóo wi yi, á ho wáayi tonkarowà wee wé na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","O Zãn déró ho kàsó yi mɔ́n, ó o Yeesu wà van ho Kalilee kɔ̃hṹ á vaá wee bue le Dónbeenì bín-tente na ɓa nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","O wee bío na ɓa yi: «Ho pã̀ahṹ ɲii tun, le *Dónbeenì bɛ́ɛnì ɓueé ɓó. Mi khí mu bè-kora wéró yi à bè le Dónbeenì yi, à mi tà le bín-tente bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bìo ó o Yeesu hĩ́a bã́ ho Kalilee vũ-beenì ɲii wà, ó o vaá mɔn ɓa ce-pawà nùwã ɲun. Ɓa lé o Simɔn lè mín za Ãndere. Ɓa wee yénní mí zùán dé mu ɲumu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ó o Yeesu bía nɔn ɓa yi: «Mi ɓuee bè miì, á ĩ wé á ɓa nùpua lé bìa mi wé è yí á à ɓua à ɓuennáa ĩ cɔ̃́n làa bìo mi wee paráa ɓa cewà bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Á ɓa dɛ̀ɛnía kúaará mi zùánwà à ɓa bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O Yeesu dá vá van mí yahó, ó o mɔn o nìi ɓúi na ɓa le Zebedee zàwa, o Zaaki lè mín za Zãn à ɓa wi mí woohṹ yi wee wíoka mí zùánwà. ");
INSERT INTO boxNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ó o Yeesu dɛ̀ɛnía von ɓa, á ɓa ló día mín maá Zebedee lè ɓa ton-sáwá ho woohṹ yi, à ɓa bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","O Yeesu lè mí nì-kenínia wà van ho *Kapɛɛnayuumu lóhó yi. Ɓa *zúifùwa vũńló wizonle na ɓa le *Sabaa zoǹ ó o zon ɓa kàránló zĩi yi, á zoó wee kàrán ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Á bìa ɲá a bíoní wó coon làa sòobɛ́ɛ. Lé bìo ó o yí kàránna ɓa nùpua lè ho *làndá bìo zéenílowa bìo síi. Orɛ́n wó mu lè ho pànká na le Dónbeenì nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mu pã̀ahṹ mí bɛɛre yi, à bṹn ò o nìi ɓúi na ó o cĩ́ná wi yi ɓueé zon ɓa zúifùwa kàránló zĩi yi, á bía pɔ̃́npɔ̃́n: ");
INSERT INTO boxNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Nazarɛɛte nìi Yeesu! Lée webio á ũ wà ɓueé cà wa cɔ̃́n hen? Fo ɓuara wa yáaró bìo yi lée? Ɓa le ĩ yí zũ fo le? Ũnɛ́n lé yìa lé le Dónbeenì nùpue na le tonkaa.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ó o Yeesu nàmakaa wo yi: «Wé tɛ́tɛ́. Lé o nìi mu yi lònbìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ó o cĩ́ná zɛ̀kɛ́ra a nìi lè ho pànká, ò o ló a yi ká a wãamaa pɔ̃́npɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Á ɓa nùpua wó coon dàkhĩína, fúaa ɓa wee bío mín yi: «Éee! Bìo kà lée webio? Ho lée kàránló fĩnle na pànká wi. Hàrí ɓa cĩ́náwa ó o nùpue mu wee na le ɲii yi, à ɓa wé bìo ó o wi à ɓa wé.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ó o Yeesu yèni dɛ̀ɛnía ló fùafùa ho Kalilee kɔ̃hṹ ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bṹn mɔ́n ó o Yeesu ló ɓa *zúifùwa kàránló zĩi á bò mín là a Zaaki là a Zãn á térénna van o Simɔn là a Ãndere ɓàn zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mu wó ò o Simɔn ɓàn hio hã́a wi le dãmu dɛ̀ɛ yi, lé bìo le tɛ̀ɛnì wee zɛ̀ɛ́ wo. O Yeesu ɓuee dɛ̃ɛníi á ɓa bía a bìo làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ó o Yeesu vá vaá dĩ̀n o ɲúhṹ yi, ò o lií fù a níi yi hóonía làa wo, á le tɛ̀ɛnì khĩína ó o dɛ̀ɛnía hĩ́nɔn nɔn ho dĩ́nló ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Le wii zoró mɔ́n, ho tá yuuní, á ɓa nùpua ɓuan mi vánvárowà làa bìa ɓa cĩ́náwa wi yi ɓúenɓúen ɓuararáa o Yeesu cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ho lóhó nìpomu ɓúenɓúen ló ɓueé kúaa mín wán le zĩi zũaɲii. ");
INSERT INTO boxNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O Yeesu wɛɛ́ra ɓa nùpua cɛ̀rɛ̀ɛ na mu vã́mú lè mi sìíwà lá wee beé lò, á mún ɲɔn ɓa cĩ́náwa cɛ̀rɛ̀ɛ léra bìa ɓa wi yi. O yí máa día à ɓa cĩ́náwa mu bío, lé bìo ɓa zũ a sìí. ");
INSERT INTO boxNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mu tá na lée tɔ̃n yìnbíi bùirìi, ká ho tá ka yùiíi, ó o Yeesu hĩ́nɔn le zĩi yi, á wà ló ho lóhó mɔ́n le lùe ɓúi na á nùpue mía yi, á lée wee fìo le Dónbeenì yi bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ó o Simɔn lè mi ninzàwa ló lée wee cà a. ");
INSERT INTO boxNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bìo ɓa vaá yú a, á ɓa bía nɔn wo yi: «Loń, ɓa nùpua ɓúenɓúen wee cà fo.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ká a Yeesu màhã́ bía nɔn ɓa yi: «Mi wa lɛ́n va hã lórá na bã́makaa yi. Ĩ mún ko à ĩ vaa bue le bín-tente bĩ́n, lé bìo á bṹn lé ĩ ɓuenló ɲúhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ò o wã́a hĩ́nɔn tò ho Kalilee kɔ̃hṹ ɓúenɓúen yi wà, á wee bue le Dónbeenì bíonì na ɓa nùpua yi ɓa *zúifùwa kàránló zĩní yi, á mún wee ɲa ɓa cĩ́náwa lén bìa ɓa wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","*Ɓùeré ɓúi wà ɓuara a Yeesu cɔ̃́n, á ɓueé lií fárá mí nɔnkóɲúná wán ò o wee yanka a kà síi: «Fo dà à wɛɛ́ mi ká fo tà.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ó o nìi màkárí ɓuan o Yeesu yi dàkhĩína. Ó o lií bò mi níi o wán ò o bía nɔn wo yi: «Ĩ tà mu, wã́a wa.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ó o ɓùeré sãahṹ dɛ̀ɛnía bĩnía se dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ó o Yeesu le o lɛ́n, ò o henía bìo kà nɔn wo yi: ");
INSERT INTO boxNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Háyà. Bìo wó foǹ á ũ yí bío le nùpue ɲí. Ká ũ màhã́ vaa zéení ũten lè le *Dónbeenì yankaro. À ũ mún wé mu hãmu bìo na ó o *Mɔyiize bò le ɓa wé wé mu dã́ní yi, à ɓa ɓúenɓúen zũń ká ũ wan bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ká bìo ó o nìi mu wà ó o wee yényéní bìo wó a yi hã lùa ɓúenɓúen yi. Lé bṹn nɔn ó o Yeesu yí máa tà zo lóhó à nùpue mi, ò o wee khɛ̀n kɛɛní ho donkĩ́ahṹ lùe ɓúi na á nùpue mía yi. Á ɓa nùpua wee lé lùa ɓúenɓúen yi à ɓuen o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wizooní bìo yɛn bṹn mɔ́n, ó o Yeesu bĩnía ɓuara ho *Kapɛɛnayuumu. Á ɓa ɲá a sã le o wi le zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Á ɓa zã̀amáa ɓueé fò mín ɓùiríɓùirí á lùe yí ká, hàrí ho zũaɲii. Ó o Yeesu wee zéení le Dónbeenì bíonì na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Á ɓa nùpua nùwã yɛn ɓúi vaá ló wee ɓuen. Ɓa nùwã náa ɓa tĩ́ahṹ ɓuan o mùamúa. ");
INSERT INTO boxNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ká ɓa màhã́ yí dà máa zoó bàrá a o Yeesu yahó ɓa nùpua booró bìo yi. Á ɓa yòó kara ho lòho sánsáa hen na ó o Yeesu wi yi. Lé hón kɔ̃hṹ so á ɓa dó a mùamúa yi lè hã hũni á liinía ká a dũma mí dãmu dɛ̀ɛ wán. ");
INSERT INTO boxNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bìo ó o Yeesu mɔn bìo ɓa dóráa mí sĩa wo yi, ó o bía nɔn o mùamúa mu yi: «Wàn bɔ̃́nlo, ũ bè-kora sɛ́ra día.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Á ho *làndá bìo zéenílowa na wi bĩ́n wee bío mí yiwa. ");
INSERT INTO boxNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«O nùpue mu wee bío kà síi le we? O wee màní míten lè le Dónbeenì. Lée wée dà à sɛ́n mu bè-kora á à día ká mu yínɔń lè Dónbeenì mí dòn.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ó o Yeesu dɛ̀ɛnía zũna ɓa yilera ó o bía nɔn ɓa yi: «Lée webio nɔn á hã yilera na kà síi wiráa mia? ");
INSERT INTO boxNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lé mu yɛ́n bíoró wayi? Lé à bío na a mùamúa yi le o bè-kora sɛ́ra día lée, tàá lé à bío na a yi le o hĩ́ní lá mí dãmu dɛ̀ɛ ò o varáka? ");
INSERT INTO boxNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ká ĩ màhã́ wi á mi zũń na lé o *Nùpue Za yú ho pànká ho tá wán à sɛ́nnáa mu bè-kora día.» Ò o wã́a bía bìo kà nɔn o mùamúa yi: ");
INSERT INTO boxNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Le ĩ bío mu na foǹ, lii hĩ́ní, lá ũ dãmu dɛ̀ɛ á ũ khíɓo.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mí lahó yi ó o nìi mu dɛ̀ɛnía hĩ́nɔn yòó dĩ̀n, á lií lá mí dãmu dɛ̀ɛ ò o lée wà ká ɓa ɓúenɓúen dĩ̀n wee loń. Á ɓa ɓúenɓúen wó coon mu bìo yi. Á ɓa wee khòoní le Dónbeenì kà síi: «Bìo kà ɓàn síi wa dĩǹ yí mɔn hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","O Yeesu yèrèmáa van lè ho Kalilee vũ-beenì ɲii. Á ɓa zã̀amáa wee ɓuen ò o kàrán ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","O wee khĩí, ó o mɔn o nìi ɓúi na ɓa le Alifee za Levii ká a kará mí tonló lùe yi, á wee fé ho lànpó. Ó o Yeesu bía nɔn wo yi: «Hĩ́ní bè miì.» Ó o Levii lií hĩ́nɔn bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","O Levii von o Yeesu lè ho dĩ́nló mí zĩi. Ho *lànpó féwá lè ɓa nì-kora cɛ̀rɛ̀ɛ wi ho dĩ́nló mu díiníi là a Yeesu lè mí nì-kenínia. Mu bon. Ɓa nùpua cɛ̀rɛ̀ɛ na hĩ́a wee bè làa wo lé bán nùpua so síi. ");
INSERT INTO boxNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ho *làndá bìo zéenílowa na lé ɓa *Farizĩɛwa kuure nùpua ɓúi á mɔn ò o Yeesu wee dí lè ɓa nì-kora lè ho lànpó féwá, á ɓa bía nɔn o nì-kenínia yi: «Lée webio nɔn ó o wee díráa làa bán nùpua so síi?» ");
INSERT INTO boxNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ó o Yeesu ɲá bìo ɓa bía, ó o bía nɔn ɓa yi: «Héyìi! Minɛ́n! Nùpua na lò hereka so wee wé cà tĩni ɓànso dã́ní le? Ɓùeé. Ɓa vánvárowà lé bìa wee wé cà a dã́ní. Ĩnɛ́n yí ɓuara bìa wee leéka le mí térénna bìo yi dɛ́. Bìa zũ le mí lé ɓa bè-kora wérowà lé bìa á ĩ ɓuara bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wizonle ɓúi ó o Zãn Batiisi nì-kenínia lè ɓa *Farizĩɛwa nì-kenínia lù mí ɲiní. Á ɓa nùpua ɓúi wà ɓueé tùara a Yeesu yi: «Lée webio nɔn ó o Zãn Batiisi nì-kenínia lè ɓa Farizĩɛwa nì-kenínia wee lì mí ɲiní à ũnɛ́n nì-kenínia ɓɛ̀n yí máa wé mu?» ");
INSERT INTO boxNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ó o Yeesu bía nɔn ɓa yi: «Mi wee leéka le bìa ɓa von mu yaamu sã́nú díró yi á ɓa so dà a bío le ɓa lì mí ɲiní ká a hã́-fĩa ɓàn báa làa ba wi mín wán le? Bṹn yí dà máa wé. ");
INSERT INTO boxNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɛ̀ɛ ká pã̀ahṹ ɓúi khíi dã, ó o hã́-fĩa ɓàn báa ɓa à lén ɓa tĩ́ahṹ, bṹn ká ɓa màhã́ wé è lì mí ɲiní. ");
INSERT INTO boxNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Nùpue máa lá nín-ké-fĩnle bìo ɓúi máa la làa báká kĩ́nle. Lé bìo ká a wó mu, á le nín-ké-fĩnle á à wíoka à lɛ̀ɛ ho. ");
INSERT INTO boxNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Làa bṹn síi, á nùpue máa kúee *dìvɛ̃́n fĩa sṹmàni-kĩ́a yi. Lé bìo ká a kúaa ho bĩ́n, ká ho hĩ́a wee za, á hã à nàma. Á ho dìvɛ̃́n lè hã sṹmàniwa á à páaní ì yáa. Ho dìvɛ̃́n fĩa ko ho kúee hã sṹmàni-fĩa yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ho *Sabaa ɓúi zoǹ ká a Yeesu wee kã́a hã mana ɓúi yi, ó o nì-kenínia wee khé ho dĩ́nló ho wɔ̃hṹ nìsã́ní à là. ");
INSERT INTO boxNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Á ɓa *Farizĩɛwa wee bío là a Yeesu. «Loń, lée webio nɔn á ũ nì-kenínia wee sáráa ho Sabaa zoǹ ká wa làndá ɲɔǹ hò mu?» ");
INSERT INTO boxNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ó o Yeesu bía nɔn ɓa yi: «Bìo ó o *Daviide yánkaa wó á mi dĩǹ yí kàránna yí mɔn le? Mu wó le *Dónbeenì yankarowà ɲúhṹso beenì Abiataare pã̀ahṹ. O Daviide lè mí ninzàwa á le hĩni hĩ́a dà á ɓa yí yú bìo ɓa à dí. Ó orɛ́n mí bɛɛre zon le Dónbeenì zĩi yi á zoó lá le Dónbeenì hãmu búurú là, ò o mún ɓuan ho ɓúi lée nɔn mí ninzàwa yi, ká le Dónbeenì yankarowà mí dòn lé bìa ɲɔǹ lá ko ɓa wé là ho làa bìo ho làndá bòráa mu.» ");
INSERT INTO boxNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ó o Yeesu pá bĩnía bía nɔn ɓa yi: «Ho Sabaa bàrá ò o nùpue bìo wé se, ká nùpue yí léra Sabaa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lé bṹn nɔn ó o Nùpue Za á ho Sabaa bìo mún wi níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bṹn mɔ́n ó o Yeesu bĩnía van ɓa *zúifùwa kàránló zĩi yi. Mu zoǹ à nìi ɓúi wi bĩ́n á bàhó húrun. ");
INSERT INTO boxNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Á ɓa *Farizĩɛwa na wi bĩ́n bò mí yìo o Yeesu wán le mí ì loń ká a wɛɛ́ o nìi mu ho *Sabaa zoǹ, lé bìo ɓa wi ɓa zéení a Yeesu mu wékheró bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ó o Yeesu bía nɔn o nìi na bàhó húrun yi: «Lii hĩ́ní ɓuee lée dĩ̀n ɓa nùpua ɓúenɓúen yahó le ɓa mi fo.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bṹn mɔ́n ó o Yeesu tùara bìa wi bĩ́n yi: «Wa làndá yi á lé mu yɛ́n ó o nùpue ko ò o wé ho Sabaa zoǹ? Lée bè-tente lée, tàá lée bè-kohó? Lé ho kã̀ní a nùpue lée, tàá lé ho día ò o hí?» Á bìa wi bĩ́n yí bía dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ó o Yeesu lońna ɓa ɓúenɓúen yi khíi fò lè le sĩ-cĩ̀ílè. O mún yi wee vá lè mi sòobɛ́ɛ bìo ɓa yiwa tunka bìo yi. Ó o wã́a bía nɔn o nìi yi: «Hóoní ũ bàhó.» Ó o nìi hóonía ho á ho dɛ̀ɛnía wan. ");
INSERT INTO boxNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Á ɓa Farizĩɛwa fó mín à ɓa ló á dɛ̀ɛnía lée kúaa mín wán là a *Heroode kuure nùpua, à ɓa wee loń bìo ɓa à wé á à ɓúeráa o Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","O Yeesu lè mí nì-kenínia wà van ho Kalilee vũ-beenì ɲii á ɓa minka zã̀amáa bò a yi. Ɓa nùpua mu ɓúi ló ho Kalilee kɔ̃hṹ yi. Ɓa ɓúi ló ho Zudee kɔ̃hṹ lóhó na ɓa le Zeruzalɛɛmu yi, lè ho kɔ̃hṹ mu lórá ɓúi yi mún. Ɓa ɓúi ló ho Idumɛɛ kɔ̃hṹ yi, lè ho Zurudɛ̃n muhṹ mɔ́n. Ɓa ɓúi ló hã ló-zàwa na bã́makaa ho Tiire lè ho Sidɔ̃n lórá yi. Bán zã̀amá-kúii so hĩ́a wee ɓuen o Yeesu cɔ̃́n, lé bìo ɓa ɲá bìo ó o wee wé ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ó o Yeesu wã́a le mí nì-kenínia ɓua ho woohṹ ɓúi ɓuennáa bèra a na ká ɓa zã̀amáa hĩ́a wee hénka a, ò o zo hon. ");
INSERT INTO boxNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mu bon. Bìo ó o wee wɛɛ́ ɓa nùpua cɛ̀rɛ̀ɛ kà síi, á bìa mu vã́mú wee beé lò wee ɲàa mín o wán, bèra à na ò o yí ɓa tṹii yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ɓa nùpua na ɓa cĩ́náwa wi yi ká ɓa sansan mɔn o Yeesu, à ɓa lé lùiorá a tá, à wé wãamaka ká ɓa à bío: «Fo lé le Dónbeenì Za.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ká a Yeesu màhã́ wee hení mu na ɓa yi le ɓa yí bá mí bìo na nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bṹn mɔ́n ó o Yeesu yòora le ɓúee ɓúi wán, ò o von ɓa nùpua ɓúi á ɓa ɓueé yòora a cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ó o hueekaa ɓa pírú ɲun ɓa tĩ́ahṹ á có yèni làa tonkarowà. O hueekaa ɓa à ɓa kɛń mín wán làa wo ò o wé tonka à ɓa bue le Dónbeenì bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","O mún nɔn ho pànká ɓa yi à ɓa wé ɲa lè ɓa cĩ́náwa lén bìa ɓa wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bìa ó o hueekaa yènnáa lé hĩ̀a kà: O Simɔn, yìa ó o có yèni làa Piɛre. ");
INSERT INTO boxNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","O Zaaki lè mín za Zãn na lé o Zebedee zàwa. O Yeesu có ɓa yèni làa Buanɛzɛɛsi, bṹn kúará le «nùpua na ka lòn viohó na wee nàmaka.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","O Ãndere, o Filiipu là a Baatelemii, o Matiye là a Toma, o Zaaki na lé o Alifee za, o Tade, o Simɔn na lé ɓa Zelootewa kuure nùpua nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","O Zudaa Isikariote na khíi dé o Yeesu mí zúkúsa níi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bṹn mɔ́n ó o Yeesu bĩnía ɓueé lion le zĩi yi. Á ɓa minka zã̀amáa tĩ́n ɓueé fò mín fúaa o Yeesu lè mí nì-kenínia yàá yí yú pã̀ahṹ máa díráa. ");
INSERT INTO boxNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bìo á ɓàn nùwã ɲá mu, á ɓa ló wà ɓueé fé o, à ɓa wee bío le o ɲúhṹ mía bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ho *làndá bìo zéenílowa na ló ho Zeruzalɛɛmu yi ɓuara bĩ́n bán ɓɛ̀n wee bío: «Mu lé ɓa cĩ́náwa ɲúhṹso na ɓa le *Bɛlezebuule lé yìa wi o yi. Lé wón nɔn ho pànká wo yi ó o dà wee ɲanáa ɓa cĩ́náwa lén bìa ɓa wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ó o Yeesu wã́a von ɓa wee bíoráa lè hã wàhio: «O *Satãni yí dà máa ɲa mí ninzàwa cĩ́náwa. ");
INSERT INTO boxNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ká kɔ̃hṹ dà-kéní nùpua hĩ́a wee fi mín yi, se hón kɔ̃hṹ so máa va yahó. ");
INSERT INTO boxNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ká zĩ-ɲúhṹ dà-kéní nùpua hĩ́a wee fi mín yi, á hón zĩ-ɲúhṹ so máa va yahó. ");
INSERT INTO boxNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ká a Satãni hĩ́a wee fi lè mí ninzàwa cĩ́náwa, ká a bɛ́ɛnì sankaa, ó o pànká máa va yahó ká ho ò yáa. ");
INSERT INTO boxNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nìi woon yí dà máa zo pànká ɓànso zĩi á máa zoó khuii o níi bìo ká a yí can o pànká ɓànso mu yí vó. Ká a màhã́ can wo vó, ó o zoó khuii o zĩi bìo ɓúenɓúen á à lɛ́nnáa. ");
INSERT INTO boxNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Le ĩ mì ho tũ̀iá na mia: Ɓa nùpua bè-kora lè ɓa bín-kora na ɓa à bío le Dónbeenì dã́ní yi ɓúenɓúen á le Dónbeenì dà khíi sɛ́n ǹ día á à na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ká yìa màhã́ khíi bía le bín-kohó á lɛɛ́ra le Dónbeenì Hácírí yi, wón bìo á le Dónbeenì máa sɛ́n máa día máa mi hùúu. Mu ù ɲì a ɲúhṹ yi fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","O Yeesu bía kà síi nɔn ɓa yi, lé bìo ɓa wee bío le o cĩ́ná wi o yi. ");
INSERT INTO boxNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bìo ó o Yeesu ɓàn nu lè ɓàn zàwa wã́a ɓueé dɔ̃n, á ɓa lée dĩ̀n ho khũuhũ, à ɓa tonkaa o ɓúi le wón zoo ve o. ");
INSERT INTO boxNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɓa nùpua na kará kĩ́nía o Yeesu yi boo, à bṹn à yìa ɓa tonkaa ɓueé wee bío làa wo: «Loń, mìn nu lè mìn zàwa lè mìn hĩ́nni wee cà fo, ɓa lée wi ho khũuhũ.» ");
INSERT INTO boxNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ó o Yeesu bía: «Lé o yɛ́n lé wàn nu? Á wàn zàwa lé ɓa yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ò o lońna bìa kará kĩ́nía wo yi khíi fò, ò o bía: «Mi loń! Wàn nu lè wàn zàwa wi hen. ");
INSERT INTO boxNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Lé bìo á yìa wee wé le Dónbeenì sĩi bìo se wón lé wàn za, tàá wàn hĩ́nló, tàá wàn nu.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","O Yeesu tĩ́n wíokaa wee kàrán ɓa nùpua ho Kalilee vũ-beenì ɲii. Ɓa minka zã̀amáa kĩ́nía wo yi, ó o wó san zon ho woohṹ á zoó kará. Ho woohṹ mu wi mu ɲumu yi, ká ɓa zã̀amáa bán lée wi le ɓónɓóore yi mu ɲumu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O hĩ́a wee wà hã wàhio à kàránnáa ɓa nùpua làa bìo cɛ̀rɛ̀ɛ. Bìo kà lé bìo ó o kàránna làa ba: ");
INSERT INTO boxNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Mi tántá mi ɲikɔ̃nna. Nìi ɓúi ló van mí mɔhṹ yi, á wà vaá dé mí bè-dà. ");
INSERT INTO boxNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bìo ó o wee dé mu, á mu ɓúi lion ho wɔ̃hṹ nìsã́ní, á ɓa ɲínzàwa sèekaa bṹn vã̀. ");
INSERT INTO boxNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mu ɓúi lion ho ɓúaahó na le tĩ́ní wi wán ká le yí lì, á mu dɛ̀ɛnía ló, lé bìo le tĩ́ní yí boo bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bìo le wii ɲá mu lè mí sòobɛ́ɛ, á mu hon, lé bìo mu naní yí zon ho tá yi sese. ");
INSERT INTO boxNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mu ɓúi lion hen na hã kíkara bia hɛ́ra yi, á mu ló, á hɔ̃́n kíkara so hĩ́nɔn yòó pà mu, á mu yí yú bia hùúu. ");
INSERT INTO boxNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mu ɓúi bṹn lion ho tá na se yi, á mu ló, á yòó dɔ̃n, á yú hã bia ɓóní làa pírú pírú, ɓúará-tĩn tĩn, khĩmàni khĩmàni.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bṹn mɔ́n ó o bía nɔn ɓa yi: «Yìa wee ɲí bìo, à wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bìo ó o Yeesu páanía wi làa bìa yí máa tà lé o mɔ́n là a nì-kenínia pírú ɲun, á ɓa fìora a le o zéení hã wàhio mu kúará làa mí. ");
INSERT INTO boxNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ó o bía nɔn ɓa yi: «*Le Dónbeenì bɛ́ɛnì bìo na kúará lá dĩǹ yí zũ á minɛ́n yú zũna. Ká ɓa nì-vio wee ɲí mu bìo ɓúenɓúen lòn wàhio. ");
INSERT INTO boxNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lé bṹn nɔn ‹á ɓa lé ɓa nùpua na yìo wi ká ɓa yí máa mi sese. Ɓa mún wee ɲí mu bìo, ká ɓa yí máa zũń mu ɓàn kúará binbirì. Ká bṹn mía se ɓa lá á à yèrèmá à ɓuen le Dónbeenì cɔ̃́n, á dén lá à sɛ́n ǹ día á à na ɓa yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bṹn mɔ́n ó o Yeesu bía nɔn ɓa yi: «Ká le wàhiire na kà ɓàn kúará á mi yí zũ, á mi ì wé kaka á à zũńnáa hã wàhio ɓúenɓúen na ká ɓàn kúaráwa? ");
INSERT INTO boxNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Le Dónbeenì bíonì ka lè mu bè-dà na ó o dìro wee dé. ");
INSERT INTO boxNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓa nùpua ɓúi ka lè ho wɔ̃hṹ nìsã́ní na le bíonì lion yi. Hen ká ɓa ɲá le Dónbeenì bíonì, ò o Satãni dɛ̀ɛní lén le ɓa yiwa. ");
INSERT INTO boxNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓa ɓúi ka lè ho ɓúaahó na le tĩ́ní wi wán ká le yí lì. Hen ká ɓa ɲá le Dónbeenì bíonì, à ɓa tà le yi, à zã̀maka le bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ká ɓa màhã́ yí máa tà à le bíonì mu wìi ɓa sese à va yahó. Ká le lònbee, tàá ho kúará lénló yú ɓa le Dónbeenì bíonì bìo yi, à ɓa dɛ̀ɛní pĩ́ le Dónbeenì bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓa ɓúi ka lè ho tá na á hã kíkara bia hɛ́ra yi á mu bè-dà lion yi. Ɓa ɲá le Dónbeenì bíonì, ");
INSERT INTO boxNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɛ̀ɛ ká ho yìró bìo yilera, lè ho nàfòró sĩmu na wee vĩ́iní ɓa nùpua, lè mu bìowa sìíwà cɛ̀rɛ̀ɛ na ɓa nùpua sĩa wee vá yi, bṹn wee wìi ɓa, à hè le bíonì mu à le máa dàń dɛ̀ɛ ɓúi wé. ");
INSERT INTO boxNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓa ɓúi ɓɛ̀n ka lè ho tá na se bìo. Ɓa wee ɲí le Dónbeenì bíonì à tà le yi. Bán ka lòn dĩ́nló na yòó ton, á ho ɓúi yú hã bia ɓóní làa pírú pírú, ɓúará-tĩn tĩn, khĩmàni khĩmàni.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bṹn mɔ́n ó o Yeesu bĩnía bía nɔn ɓa yi: «O ɓúi so wee wé dé fĩ̀ntã́ní à bĩní lá láahó ɓún yi le? Tàá ɓànso so wee wé dé le zoo bàrá kàtà tá le? Ɓùeé. Ɓa wé dé le bàrá hen na le ko le bàrá yi. ");
INSERT INTO boxNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mu bìo na sànkaa ɓúenɓúen khíi mi. Á bìo sà yi ɓúenɓúen bìo khíi zũń. ");
INSERT INTO boxNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yìa wee ɲí bìo, à ɓànso ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O Yeesu pá bĩnía bía bìo kà nɔn ɓa yi: «Mi wé ɲí bìo wee bío na mia sese. Le wĩ̀ló dɛ̀ɛ na mi wee mɔ̀nzã́ lè mu bìo, lé dén ɓàn síi á le Dónbeenì á à mɔ̀nzã́ lè mí bìo á à wíoka à bè mu ɓúi wán á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lé bìo á yìa bìo wi á le è bĩní ì na mu ɓúi wo yi á à bè mu wán. Ká yìa dɛ̀ɛ ɓúi mía, á hàrí mu bè-za na ó o wee leéka le mu wi mí cɔ̃́n, á le pá à fé.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O Yeesu tĩ́n bĩnía bía: «*Le Dónbeenì bɛ́ɛnì bìo ɓonmín làa bìo kà: Nìi ɓúi dó mí bè-dà mí mɔhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","O wee da à lée sĩ̀n làa wizooní. Hón pã̀ahṹ so ká hã bia wee hàa à yòo lé ká a yí zũ bìo mu wee wéráa. ");
INSERT INTO boxNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ho tá míten wee wé à mu bìo na dó à lé, à wé mí mùuní, à te, à kúee mí yìo. ");
INSERT INTO boxNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ká ho dĩ́nló hĩ́a bon, á láró dɔ̃n, ò o mɔhṹ ɓànso dɛ̀ɛní lá mí khɔ̃́nle ká a khè ho.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Bṹn mɔ́n ó o Yeesu tĩ́n pá bĩnía bía: «Lé mu yɛ́n á wa dà à tèé lè le Dónbeenì bɛ́ɛnì? Lé le wàhiire yɛ́n á wa à dĩ̀n wán á à zéenínáa le bɛ́ɛnì mu bìo? ");
INSERT INTO boxNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mu bìo dà à tèé lè le vĩ̀ndɛ̀ɛ na ɓa le mútáàdè ɓàn bɛɛre. Le ka cĩ́inú á po hã bia ɓúenɓúen na ho dĩ́míɲá yi. ");
INSERT INTO boxNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ká ɓa dù le à le lé, à dã poń ho zen-ɓuahó bè-vànii ɓúenɓúen, à lakara kɛń á tàró wé, à ɓa ɲínzàwa wé dàń tá mí lɛnna yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lé kà síi ó o Yeesu hĩ́a wee wàráa hã wàhio cɛ̀rɛ̀ɛ làa hĩ̀a kà ɓàn síi bìo, à zéenínáa le Dónbeenì bíonì na ɓa nùpua yi. O hĩ́a wee kàrán ɓa à héha làa bìo á bìa wee ɲí a cɔ̃́n dà à zũńnáa hã kúará. ");
INSERT INTO boxNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O hĩ́a máa wé bío lè ɓa zã̀amáa ká a yí máa wà wàhio. Ká pã̀ahṹ na ó orɛ́n lè mí nì-kenínia wi mí dòn, ò o zéení hã kúará na bán yi. ");
INSERT INTO boxNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mu nɔ̀nzoǹ mí bɛɛre zĩihṹ, ó o Yeesu bía nɔn mí nì-kenínia yi: «Mi wa khí lè ho vũ-beenì mɔ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Á ɓa wã́a wà día ɓa zã̀amáa. Ho woohṹ na ó o Yeesu lá wi yi lé hìa ó o nì-kenínia zon làa wo á ɓa wà. Hã wonna ɓúi mún sùaráa yi làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cúa-yɛn à ho pinpi-beenì hĩ́nɔn wee và, á mu ɲumu wee yànbónka zo ho woohṹ. Lònbìo à ho yòó wee sí lè mu ɲumu. ");
INSERT INTO boxNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mu wee wé ò o Yeesu lií dũma ho woohṹ fĩ̀kɔ̃hṹ sã́ mí ɲúhṹ á mu dãmu ɓó. Ó o nì-kenínia sĩ̀nía wo á bía nɔn wo yi: «Ɲúhṹso, wa à hí. Mu so lée bìo na yí ciran fo lée?» ");
INSERT INTO boxNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ó o Yeesu sĩ̀na nàmakaa ho pinpiró yi, ò o bía nɔn ho vũ-beenì ɲumu yi: «Wé tɛ́tɛ́.» Á ho pinpiró dɛ̀ɛnía dĩ̀n. Á mu ɓúenɓúen wó tɛ́tɛ́tɛ́. ");
INSERT INTO boxNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ó o Yeesu bía nɔn mí nì-kenínia yi: «Lée webio nɔn á mi zã́nanáa? Á lé minɛ́n pá dĩǹ yí dó mí sĩa miì lon?» ");
INSERT INTO boxNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ká bìo ɓa zã́na dàkhĩína, á ɓa wee bío mín yi: «Páa! O nùpue mu lé o yɛ́n síi kà? Hàrí ho pinpiró lè mu ɲumu ó o bíaráa, á mu pá bò a bíonì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bṹn mɔ́n á ɓa wà khíi dɔ̃n ho Kalilee vũ-beenì mɔ́n ho Zerasaa kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bìo ó o zoó ló ho woohṹ yi lée wee dĩ̀n, à bṹn ò o nìi ɓúi ló ɓa nì-hía nùuníi á wee sĩ́ a yahó. O cĩ́ná ɓúi wi o nìi mu yi á wee beé o lò. ");
INSERT INTO boxNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","O wee cãa ɓa nì-hía nùuníi. Nùpue yí dà máa bĩní máa ca a làa dɛ̀ɛ woon, hàrí lè hã zúakùaríwà. ");
INSERT INTO boxNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pɔ̃̀nna cɛ̀rɛ̀ɛ ɓa can wo lè hã zúakùaríwà. Ká a màhã́ wee wé khòo hã zúakùaríwà, à háaka hã cĩ́aní na wi o zení yi. Pànká ɓànso na dà a bìo wón mía. ");
INSERT INTO boxNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Fúuu lè hã wizooní, ká lé ɓa nì-hía nùuníi lè hã ɓúaa ó o wi yi, á wee wãamaka ká a hṹaa míten ɓóoníka yi lè hã huaa. ");
INSERT INTO boxNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","O nìi mu khɛ̀ra mɔn o Yeesu ó o lùwa ɓuara á ɓueé lií ɓúrá a tá ");
INSERT INTO boxNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ò o wee bío bìo kà pɔ̃́npɔ̃́n: «Dónbeenì na wi mu bìo ɓúenɓúen ɲúhṹ wán Za Yeesu! Lée webio fo lon làa mi? Sábéré, ĩ wee yanka fo le Dónbeenì yèni yi, yí yáa ĩ bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O bía bṹn, lé bìo ó o Yeesu wee kĩ̀kã́ a cĩ́ná na wi o yi le o lé. ");
INSERT INTO boxNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ó o Yeesu tùara a yi: «Ũ yèni ɓa le we?» Ó o bía: «Ĩ yèni ɓa le Zã̀amáa, lé bìo wa boo.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ò o wee yanka a le o yí ɲa mí lén ho kɔ̃hṹ mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mu wee wé à nɔ̀nbùɛ-ɓoohṹ ɓúi wee dí le ɓúee nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Á ɓa cĩ́náwa mu yankaa o Yeesu kà: «Na ho wɔ̃hṹ wɛn le wa vaa zo ɓa nɔ̀nbùɛɛní na kà yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ó o Yeesu nɔn mu wɔ̃hṹ ɓa yi. Á ɓa cĩ́náwa mu ló a nìi yi á vaá zon ɓa nɔ̀nbùɛɛní yi. Á ɓa ɓúenɓúen yòó lùwa le ɓúe wán á kùenkaa lií zon ho vũ-beenì yi á húrun. Ɓa à yí lòn muaaseé ɲun síi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Á bìa lá wee pa ɓa lùwa vaá bía mu nɔn bìa wi mí manawà yi, á bía mu nɔn bìa wi ho lóhó yi. Á ɓa nùpua ló wà ɓueé loń bìo wó. ");
INSERT INTO boxNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bìo ɓa ɓueé dɔ̃n hen na ó o Yeesu wi yi, á ɓa mɔn o nìi na ɓa minka cĩ́náwa lá wi yi, ò o wó mí nì-tente á zã́ mí sĩ̀a kará, á ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Á bìa mu wó yìo yi lá bìo wó a nìi na ɓa cĩ́náwa lá wi yi làa bìo wó ɓa nɔ̀nbùɛɛní yi á fɛɛra nɔn bìa ló ɓuaraka yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Á ɓa wee yanka a Yeesu le o sábéré ò o lɛ́n día mí. ");
INSERT INTO boxNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pã̀ahṹ na ó o Yeesu bĩnía wà yòó zo ho woohṹ yi, ó o nìi na yú míten ɓa cĩ́náwa níi yi yankaa wo le o día le mí bè làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ó o Yeesu pã́ ò o bía nɔn wo yi: «Bĩní va mìn zĩi à vaa bío ũ màkárí na ó o Ɲúhṹso zũńna, làa bìo ó o wó nɔn foǹ ɓúenɓúen à na ɓa nùpua yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ó o nìi mu ɓɛ̀n wã́a wà á tò hã Lórá Bìo Pírú kɔ̃hṹ yi ká a wee yényéní bìo ɓúenɓúen na ó o Yeesu wó nɔn wo yi. Á bìa ɓúenɓúen na ɲá mu á mu wó coon dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bṹn mɔ́n ó o Yeesu zon ho woohṹ, á yèrèmáa khú ho vũ-beenì mɔ́n, hen na ó o ló yi ɓuararáa. Á ɓa minka zã̀amáa ɓueé kĩ́nía wo yi ká a wi mu ɲumu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hón pã̀ahṹ so yi à bṹn ɓa *zúifùwa kàránló zĩi ya-dí ɓúi na yèni ɓa le Zayiruusi ɓueé dɔ̃n. Bìo ó o ɓueé ɓó a Yeesu yi ó o lií ɓúrá a tá, ");
INSERT INTO boxNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","á wee ɓónɓóní a kà síi: «Ĩ hĩ́nló máa fen, ĩ wee fìo fo, sábéré à ũ ɓuee bè ũ níi o wán ò o lò fá.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ó o Yeesu wã́a bò làa wo á ɓa wà. Á ɓa minka nùpua ɓura bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hã́a ɓúi wi ɓa tĩ́ahṹ á wee mi mí sɛɛró fɛ́ɛɛ á dɔ̃n hã lúlúio pírú ɲun à ho máa fĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O lò bon làa sòobɛ́ɛ le tĩni ɓànsowà níní yi, á níi bìo ɓúenɓúen vó. Ká a màhã́ pá yí yú míten. O vã́mú yàá wíokaa wee dé wán. ");
INSERT INTO boxNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","O hã́a mu hĩ́a ɲá a Yeesu bìo, lé bṹn nɔn ó o ɓueé zon ɓa zã̀amáa yi, á ɲàana zoó ɓo a Yeesu yi, á tṹaa o dà-zĩ́nii yi là a mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","O lá wee bío bìo kà mí yi: «Hen ká ĩ dàńna tṹaa o dà-zĩ́nii yi, á ĩ ì wa.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bìo ó o ɓɛ̀n yú zoó tṹaa o dà-zĩ́nii yi, ó o sɛɛró dɛ̀ɛnía dĩ̀n, ó o zũna mu mí sãnía yi le mí wan. ");
INSERT INTO boxNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mí lahó yi, ó o Yeesu zũna le pànká ɓúi ló mí yi, ó o yèrèmáa dĩ̀n ɓa zã̀amáa yi ò o tùara: «Lée wée tṹaa ĩ dà-zĩ́nii yi?» ");
INSERT INTO boxNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ó o nì-kenínia bía nɔn wo yi: «Fo yí mɔn bìo ɓa nùpua ɓuraráa foǹ á wee ɲàa mín le? À ũ pá wee tùa le lée wée tṹaa foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ká a Yeesu wi ò o zũń yìa wó mu, ó o wee loń mí nìsã́a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ó o hã́a zã́na, ó o wee zà, lé bìo ó o zũ bìo wó a yi. Ó o wà ɓueé lií ɓúrá a Yeesu tá, ò o fɛɛra bìo mu wóráa ɓúenɓúen nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ó o Yeesu bía nɔn wo yi: «Wàn hĩ́nló, bìo fo dó ũ sĩi miì, lé bṹn wɛɛ́ra fo. Wã́a lɛ́n, vaa yí hɛ́ɛrà. Fo wan mu vóráa.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bìo ó o Yeesu wee bío kà síi à bṹn ɓa tonkarowà ɓúi ló a Zayiruusi zĩi ɲɔn o mɔ́n á ɓueé wee bío làa wo: «Ũ hĩ́nló wã́a húrun. Fo tĩ́n pa à sɛɛ́ o nì-kàránlo le?» ");
INSERT INTO boxNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ká a Yeesu màhã́ yí lońna lè ɓa cɔ̃́n ò o bía nɔn o Zayiruusi yi: «Yí titika, dé ũ sĩi miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O Yeesu yí tà le nùpue lɛ̀ɛní mí ká mu yínɔń o Piɛre là a Zaaki lè mín za Zãn. ");
INSERT INTO boxNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bìo ó o vaá dɔ̃n o Zayiruusi mu zĩi, ó o Yeesu mɔn bìo le lùe kánkáa dĩ̀nnáa. Ɓa nùpua wee wá pɔ̃́npɔ̃́npɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ó o Yeesu yòó zon le zĩi yi ò o bía nɔn ɓa yi: «Lée webio te hɔ̃́n minka kánkáa so. Lée webio nɔn mi wee wáráa kà síi? O hĩ́nzo-za mu yí húrun, o lée yìa na dũma.» ");
INSERT INTO boxNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Á ɓa wee zùańka a yi. Ó o wã́a le ɓa ɓúenɓúen lé, ò o fó a hĩ́nzo-za ɓàn maá lè ɓàn nu lè mí nì-kenínia nùwã tĩn á zonnáa hen na ó o hĩ́nzo-za wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ò o lií fù a níi yi ò o bía: «Talita kumi.» (Bṹn kúará le «hĩ́nzo-za, le ĩ bío mu na foǹ, lii hĩ́ní»). ");
INSERT INTO boxNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ó o hĩ́nzo-za dɛ̀ɛnía lií hĩ́nɔn wee varáka. O teró lúlúio yú pírú ɲun. Bìo ɓa mɔn mu kà síi á ɓa wó coon dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ká a Yeesu màhã́ henía mu nɔn ɓa yi le ɓa yí bío mu le nùpue ɲí. Ò o bĩnía bía le ɓa na mu bìo wo yi le o dí. ");
INSERT INTO boxNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bṹn mɔ́n ó o Yeesu ló hón lahó so yi á wà van ho lóhó na ó o dɔ̃n yi. Ó o nì-kenínia bò làa wó. ");
INSERT INTO boxNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bìo ho Sabaa dɔ̃n ó o zoó kàránna ɓa nùpua ɓa *zúifùwa kàránló zĩi yi. Ɓa minka nùpua na ɲá a bíoní á wó coon dàkhĩína. Á ɓa wee bío: «Bìo kà ɓúenɓúen ó o yú wen? O bè-zũńminì lè mu yéréké bìowa na ó o wee wé ó o yú wen? ");
INSERT INTO boxNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yínɔń orɛ́n lé o ɓùɛn-khɛ̀ɛro le? Á ɓàn nu yínɔń o Mari le? O Zaaki là a Zozee là a Zude là a Simɔn, bán so yínɔń ɓàn zàwa le? Á ɓàn hĩ́nni làa wɛn yí wi mín wán hen le?» Lé bṹn nɔn á ɓa yí tàráa o Yeesu bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ká a Yeesu màhã́ bía nɔn ɓa yi: «Le *Dónbeenì ɲi-cúa fɛɛro wé yí le kɔ̃̀nbii lùa ɓúenɓúen yi. Ká ɓàn kùrú lóhó mí bɛɛre nùpua, lè ɓàn temínlowà lè ɓàn zĩ-ɲúhṹ nùpua bán máa wé kɔ̃̀nbi o.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","O Yeesu yí wó yéréké bìo bĩ́n, ká mu yínɔń ɓa vánvárowà nùwã yɛn na ó o bò mí níní wán á wɛɛ́ra. ");
INSERT INTO boxNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bìo ɓa yí dó mí sĩa wo yi á wó a coon. Bṹn mɔ́n ó o Yeesu tò hã lórá na bã́makaa bĩ́n yi, á wee kàrán ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","O von mí nì-kenínia pírú ɲun á wee tonka lè ɓa nùwã ɲun ɲun. O nɔn ho dàńló ɓa yi, à ɓa wé kĩ̀kã́náa ɓa cĩ́náwa yi, ");
INSERT INTO boxNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","á bía bìo kà nɔn ɓa yi: «Mi yí ɓua dɛ̀ɛ à láráa ho wɔ̃hṹ ká mu yínɔń le bũ̀in-za mí dòn. Mi yí ɓua bè-dínii, tàá puure. Mi yàá pá yí ɓua wárí. ");
INSERT INTO boxNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mi zĩ́ hã nakãa ká a ɓúi yí ɓua báká ɓúi à séení hìa ó o zã́.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ò o bĩnía bía: «Mi wé vaá zon lóhó lée lóhó yi, à le zĩi na mí làara yi lé bĩ́n à mi kɛɛní yi fúaa mi léró ho lóhó mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ká lóhó na sa wé pã́ le mi máa làa mí wán, tàá ká ɓa pã́ le mí máa ɲí mí cɔ̃́n, ká mi wee lé ho yi, à mi púaa mi zení khṹnkhũnì kúia bĩ́n. Á bṹn ǹ zéení làa bán le ɓa wó khon.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Á ɓa ɓɛ̀n wà dén ɲii so wán, á vaá wee hɛ́ɛ bue mu na ɓa nùpua yi le ɓa yèrèmá mí yilera lè mí wárá. ");
INSERT INTO boxNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɓa cĩ́náwa cɛ̀rɛ̀ɛ ɓa wee ɲa lén bìa ɓa wi yi, á mún wee khìi ho ɲiló lè ɓa vánvárowà cɛ̀rɛ̀ɛ, à wɛɛ́ ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bṹn ǹ wé ò o bɛ́ɛ *Heroode ɲá a Yeesu bìo, lé bìo ó o yèni ló hã lùa ɓúenɓúen yi. Ɓa nùpua ɓúi wee bío le lé o Zãn Batiisi á vèera, le lé bṹn nɔn ó o dà mu yéréké bìo wee wéráa. ");
INSERT INTO boxNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ká ɓa ɓúi bán ɓɛ̀n wee bío le mu lé o *Elii. Ɓa ɓúi yàá ɓɛ̀n wee bío le mu lé le *Dónbeenì ɲi-cúa fɛɛrowà na yáanía nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bìo ó o Heroode ɲá mu kà, ó o le éee! Le o Zãn Batiisi na mínɛ́n nɔn le ɲii ɓa kúio ɲúhṹ lé wón bĩnía vèera le. ");
INSERT INTO boxNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Bìo kà lé bìo mu wóráa: O Heroode hĩ́a fó mín za Filiipu ɓàn hã́a Herodiade yan. Ó o Zãn bía nɔn wo yi: «Mìn za ɓàn hã́a á fo yí ko à ũ fé ya.» Bìo ó o Herodiade ɲá mu ó o sĩi cã̀ a Zãn yi, á wi ò o cà a ɓúeró yahó ká a màhã́ yí dàńna mu yí wó, lé bìo ó o Heroode mu fù wee hézɔ̃́n o Zãn. O zũ le o lée nì-tente na bìo sã̀ le Dónbeenì yi, ó o ɓɛ̀ntĩ́n fù pan o bìo. Hen ká a wee ɲí a bíoní, ò o máa zũń bìo o ò wé sese, ò o ɲɔǹ pá wa a bíoní ɲíló. Ká bṹn pá yí hò bìo ó o nɔn le ɲii á ɓa wìira a Zãn mu can dó ho kàsó yi, á wɛɛ́raráa o Herodiade sĩi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Á nɔ̀nzoǹ na ó o Heroode mu teró wizonle bánbáa ɓueé dɔ̃n yi, ó o Herodiade wã́a bò bṹn yi á wóráa bìo ó o lá wee leéka. Mu zoǹ ó o Heroode wó ho sɔ̃́n-beenì ò o von mí bɛ́ɛnì nì-beera, á von ɓa dásíwá ɲúnása lè ho Kalilee kɔ̃hṹ bá-zàwa. ");
INSERT INTO boxNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mu zoǹ ó o Herodiade hĩ́nló á wà zon hen na ɓa wee dí ho sã́nú yi, á zoó yon. Ó o bìo wɛɛ́ra a Heroode làa bìa ó o von sĩa. Ó o Heroode wã́a bía nɔn o hĩ́nzoró yi: «Bìo fo le fo ò cà à ũ zéení, á ĩ na mu foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Fúaa o hĩ́a báa á bía bìo kà: «Bìo ɓúenɓúen na á fo le fo o cà á ĩ ì na foǹ, hàrí mu wé ĩ bɛ́ɛnì ɓàn sanka màní, á ĩ pá à na mu foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ó o hĩ́nzoró wã́a wà lée tùara mín nu yi: «Lé mu yɛ́n á ĩ ko à ĩ bío le o *Heroode na miì coon?» Á wón bía nɔn mí hĩ́nló yi: «Lɛ́n zo o bío le o Zãn Batiisi ɲúhṹ lé hìa ò o na foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ó o hĩ́nzoró dɛ̀ɛnía yèrèmáa bánbáa zon o bɛ́ɛ cɔ̃́n á zoó bía bìo kà nɔn wo yi: «O Zãn Batiisi ɲúhṹ lé hìa à ũ wã́a dé ho lɛnɓuɛn yi na miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ó o bɛ́ɛ sãnía ɓúenɓúen yòó tò. Ká a màhã́ yí wi ò o pĩ́ bìa ó o von yahó bìo ó o báa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mí lahó yi ó o dɛ̀ɛnía tonkaa mí dásí nì-kéní, á nɔn le ɲii yi le o vaa kúii o Zãn Batiisi ɲúhṹ ɓua ɓuennáa. Ó o dásí nìi wà van ho kàsó zĩi yi, á vaá kúio o Zãn Batiisi ɲúhṹ, ");
INSERT INTO boxNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","á dó ho lɛnɓuɛn yi á ɓueé nɔn o hĩ́nzoró yi, á wón ɓuan vaá nɔn mín nu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bìo ó o Zãn Batiisi nì-kenínia ɲá mu, á ɓa ɓueé lá a vaá nùuna. ");
INSERT INTO boxNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɓa tonkarowà vaá bĩnía ɓuara a Yeesu cɔ̃́n, á ɓueé fɛɛra bìo ɓa wó làa bìo ɓa kàránna ɓúenɓúen lè ɓa nùpua á nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ɓa nùpua na wee ɓuen ká ɓa bĩní lɛ́n á boo dà, fúaa o Yeesu lè mi tonkarowà yí yú ho pã̀ahṹ máa díráa. Lé bṹn nɔn ó o bíaráa bìo kà nɔn ɓa yi: «Mi ɓuen le wa khɛ̀n lé à mi lée yí vũń cĩ́inú.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Á ɓarɛ́n mí dòn wã́a zon ho woohṹ á khɛ̀ra ló van hen na á nùpue mía yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ká nùpua cɛ̀rɛ̀ɛ màhã́ mɔn ɓa lɛ́nló, á zũna ɓa. Á ɓa lóka hã lórá ɓúenɓúen yi á ɓùunia dú a Yeesu lè mí tonkarowà yahó van ho lahó mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bìo ó o Yeesu zoó ló ho woohṹ yi, ó o mɔn ɓa minka zã̀amáa. Á ɓa màkárí ɓuan wo yi, lé bìo ɓa ɓonmín lòn pia na paro mía. Ó o wã́a kàránna ɓa làa bìo cɛ̀rɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bìo le wii wee tè, ó o Yeesu nì-kenínia vá ɓueé ɓó a yi á bía nɔn wo yi: «Le wii tò, à hen na wa wi yi, á nùpue mía yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bío le ɓa nùpua mu lɛ́n va hã manawà lè hã lórá na sùarákaa hen, à vaa yà mu bìo dí.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ó o Yeesu bía nɔn ɓa yi: «Minɛ́n miten na mu bè-dínii ɓa yi.» Á ɓa bía nɔn wo yi: «Hàrí wa vaa yà wɛ́n-hãani khĩá-ɲun búurú ɓuee na ɓa yi, á hon pá máa yí ɓa.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ó o Yeesu bía nɔn ɓa yi: «Mi vaa loń le lée búurú bìo yɛn ká mi cɔ̃́n.» Bìo ɓa van ɓuara, á ɓa bía nɔn wo yi: «Lée búurú bi-zàwa bìo hònú làa cezàwa bùaa ɲun.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ó o Yeesu wã́a nɔn le ɲii mí nì-kenínia yi le ɓa sanka ɓa nùpua le ɓa kɛɛní lè mi kuio le ɲí-sio wán. ");
INSERT INTO boxNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Á ɓa kará lè mí kuio. Ɓa ɓúi lé ho khĩmàni khĩmàni, ɓa ɓúi lé ho ɓúará-ɲun làa pírú pírú. ");
INSERT INTO boxNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ó o Yeesu wã́a fó ho búurú bi-zàwa bìo hònú lè ɓa cezàwa bùaa ɲun ɓuan, ò o hóonía mí yahó ho wáayi á wee fìo, ò o dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho nɔn mí nì-kenínia yi le ɓa sanka na ɓa nùpua yi. O mún sankaa ɓa cezàwa bùaa ɲun nɔn ɓa ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓa lè mi nì-kéní kéní yú dú á sù. ");
INSERT INTO boxNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ho búurú lè ɓa cezàwa na là ká á ɓa nì-kenínia khuiira, á mu sú hã sàkíwá pírú ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bìa dú mu, á ɓa báawa mí dòn á yú ho muaaseé hònú. ");
INSERT INTO boxNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bṹn mɔ́n ó o Yeesu dɛ̀ɛnía kĩ̀kã́a mí nì-kenínia yi le ɓa zo ho woohṹ à dí mí yahó khí ho vũ-beenì mɔ́n lè ho Bɛtesayidaa lóhó cɔ̃́n, ká minɛ́n ǹ na ho wɔ̃hṹ ɓa zã̀amáa yi á ɓa à ɓoka. ");
INSERT INTO boxNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bìo ɓa saawaa mín yi vó, ó o vaá yòora le ɓúee ɓúi wán á wà yòó fìo le Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ho tá á à bío le mí ì hĩ, à bṹn ho woohṹ na ó o nì-kenínia zon á zoó wi ho vũ-beenì sĩi yi. Ò o Yeesu mí dòn lée dĩ̀n le ɓónɓóore yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ó o mɔn ò o nì-kenínia lò wee be lè ho woohṹ pàró, lé bìo ho pinpiró wee sĩ́ ɓa yahó. Hã tá-tĩa yi, ó o Yeesu wee varáka mu ɲumu wán á mà ɓa, á wà vaá nikhĩí ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bìo ɓa mɔn wo ò o wee varáka mu ɲumu wán, á ɓa wee leéka le o lée nì-hɔ̃́nbóní. Á ɓa wee wãamaka. ");
INSERT INTO boxNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɓa ɓúenɓúen á yìa yí mɔn wo mía. Á ɓa zɔ̃́nkaa dàkhĩína. Ká a Yeesu dɛ̀ɛnía bía làa ba: «Mi hení mi sĩa, mu lé ĩnɛ́n, mi yí zɔ̃́n bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ò o yòó zon ho woohṹ yi làa ba, á ho pinpiró dĩ̀n. Ó o nì-kenínia wó coon dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ɓa yí zũna mu yéréké bìo na ó o wó lè ho búurú ɓàn kúará, lé bìo ɓa tun mí yiwa. ");
INSERT INTO boxNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓa kã́a ho vũ-beenì khíi dɔ̃n ho lahó na ɓa le Zenɛzarɛɛte kɔ̃hṹ, á ɓa can mí woohṹ mu ɲumu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bìo ɓa zoó ló ho woohṹ yi á ɓa nùpua na mɔn o Yeesu dɛ̀ɛnía zũna a, ");
INSERT INTO boxNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","á ɓa hɛ́ɛra bía a bìo. Á ɓa nùpua wee lé lùa ɓúenɓúen yi à ɓua mí vánvárowà ká ɓa wi mí dãmu sĩ̀a wán, à varáa o cɔ̃́n hen na ɓa wee ɲí le o wi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lùa ɓúenɓúen na ó o Yeesu wee va yi, hã ló-zàwa lè hã ló-beera lè hã manawà, á ɓa nùpua wee ɓua mí vánvárowà à varáa ho fèmínló lara yi ká ɓa yanka a le o día le ɓa tṹiika a dà-zĩ́nii ɲi-kã́a yi. Á bìa wee yí le tṹii yi, bán ɓúenɓúen wee wa. ");
INSERT INTO boxNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɓa *Farizĩɛwa lè ho *làndá bìo zéenílowa nùwã yɛn ɓúi na ló ho Zeruzalɛɛmu yi, á ɓueé kúaa mín wán kĩ́nía o Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓa lońna mɔn ò o nì-kenínia ɓúi wee dí à ɓa yí sɛɛra mí níní á yí ceéraráa míten làa bìo ho làndá bòráa mu. ");
INSERT INTO boxNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mu bon, ɓa Farizĩɛwa lè ɓa *zúifùwa ɓúenɓúen á wee bè ho làndá na á ɓàn maáwà zéenía nɔn ɓa yi. Ɓa máa wé dí ká ɓa yí sɛɛra mí níní sese. ");
INSERT INTO boxNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ká ɓa vaá ló ho yàwá yi à ɓa máa dí ká ɓa yí sɛɛra míten. *Làndáwá cɛ̀rɛ̀ɛ na ɓa yú mín maáwà cɔ̃́n á ɓa wee bè yi: Hã ɲuuníi sĩ̀a, lè hã dṹunà lè hã bã́námáwá, bìo na á hã ko à hã wé sɛɛráa. ");
INSERT INTO boxNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Á ɓa Farizĩɛwa lè ho làndá bìo zéenílowa wã́a tùara a Yeesu yi: «Lée webio nɔn á ũ nì-kenínia yí máa bèráa ho kàránló na á wàn maáwà nɔn wɛn yi, á wee dí ká ɓa níní yí sɛɛra làa bìo ho làndá bòráa mu?» ");
INSERT INTO boxNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ó o Yeesu wã́a bía nɔn ɓa yi: «Nì-khàwa yɛ́n! O *Ezayii tũ̀iá sĩ mí wán pã̀ahṹ na ó o fɛɛra le *Dónbeenì ɲi-cúa na kà mi dã́ní yi. Bìo kà lé bìo ó o hĩ́a túara: ‹Ɓa nùpua na kà wee ɓùaaní mi lè mí ɲiní, ká ɓa yiwa yi, á ɓa khɛ̀ra làa mi. ");
INSERT INTO boxNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Le ɓùaaníi na ɓa wee na miì ɲúhṹ mía. Lé bìo ɓa nùpua làndáwá lé hĩ̀a ɓa wee kàrán làa mín.›» ");
INSERT INTO boxNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ò o Yeesu bĩnía bía: «Le Dónbeenì làndáwá á mi wee pĩ́ día, ká mi bè ɓa nùpua kàránló yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ò o pá bĩnía bía: «Bìo mi pã́ le Dónbeenì làndáwá à mi bò mín kùrú làndáwá yi lée bìo na se mi cɔ̃́n sá! ");
INSERT INTO boxNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mu bon. O *Mɔyiize bía: ‹Kɔ̃̀nbi mìn maá lè mìn nu.› Mu mún bía: ‹Yìa bía khon mín maá tàá mín nu dã́ní yi, wón ko làa ɓúeró.› ");
INSERT INTO boxNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ká minɛ́n bán wee kàrán ɓa nùpua le ká nùpue bía nɔn mín maá yi tàá mín nu yi le mí níi bìo na mí lá ko à mí séení làa wo lée Koroban. (Bṹn kúará le hãmu na bìo sã̀ le Dónbeenì yi.) ");
INSERT INTO boxNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Se mi nɔn le níi wo yi ò o yí séení mín maá tàá mín nu. ");
INSERT INTO boxNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ká mi wee wé kà síi se lé le Dónbeenì bíonì ɓàn báhɛ́ɛ á mi wee lén le wán lè mi kùrú làndáwá na mi wee zéení làa mín. Bṹn ɓàn sìíwà cɛ̀rɛ̀ɛ á mi wee wé.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bṹn mɔ́n ó o Yeesu von ɓa zã̀amáa á bía nɔn yi: «Mi ɓúenɓúen ɲí bìo kà à zũń kúará: ");
INSERT INTO boxNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bìo ó o nùpue wee dí, bṹn dɛ̀ɛ woon yí máa tií wo. Bìo wee lé o sĩi yi, bṹn lé bìo wee wé tií wo. ");
INSERT INTO boxNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yìa wee ɲí bìo à wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bìo ó o Yeesu wà día ɓa zã̀amáa ó o vaá zon le zĩi yi, ó o nì-kenínia zoó wee tùa wo yi lè le wàhiire mu ɓàn kúará. ");
INSERT INTO boxNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ó o bía nɔn ɓa yi: «Minɛ́n mún yí zũ mu bìowa mu yara le? Mi yí zũ le bìo ó o nùpue wee dí dɛ̀ɛ woon yí máa tií wo le? ");
INSERT INTO boxNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mu yí máa zo a sĩi yi, ká mu wee zo a píohó yi ò o bĩní lée ní kúia.» O Yeesu wee zéení làa hɔ̃́n bíoní so le ho dĩ́nló ɓúenɓúen dà wee dí. ");
INSERT INTO boxNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O pá bĩnía bía: «Bìo wee lé o nùpue sĩi yi lé bìo wee tií wo. ");
INSERT INTO boxNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lé bìo ó o nùpue sĩi lé bĩ́n á hã yile-kora wee lé yi à dé o ho hã́-fénló lè ho bá-fénló lè mí sìíwà yi, lè ho kɔ̃̀nló lè le nì-ɓúee yi. ");
INSERT INTO boxNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Hã wee na ò o wé o bá-fé tàá o hã́-fé, à sĩi wé vá ɓa nùpua bìowa yi, à wé o nì-sũmúi, à wé khà ɓa nùpua vĩ́iní. O yú bìo na ò o wé. Le yandee wee kɛń wo yi. O wé yáa ɓa nùpua yèni, à wé ɓùaaní míten, à wé o bɔ̃́nbú. ");
INSERT INTO boxNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bṹn bìowa so ɓúenɓúen wee lé o nùpue sĩi yi. Bṹn lé bìo wee tií wo.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bṹn mɔ́n ó o Yeesu ló dén lùe so yi á wà van ho kɔ̃hṹ na sùaráa yi lè ho Tiire lóhó. O vaá zon le zĩi ɓúi yi, á yí wi à ɓa zũń o bìo. Ká a màhã́ yí sà míten yí yú. ");
INSERT INTO boxNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Hã́a ɓúi na hĩ́nló ó o cĩ́ná wi yi á ɲá a sã. Ó o dɛ̀ɛnía wà ɓuara a cɔ̃́n á ɓueé lií ɓúrá a tá, ");
INSERT INTO boxNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ò o fìora a Yeesu le o ɲa a cĩ́ná lén mí hĩ́nló yi. O hã́a mu yínɔń zúifù, o ló ho Siiro-Fenisii kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ó o Yeesu bía làa wo: «Día le ɓa háyúwá dí vé. Mu yí se à ɓa lá ɓa háyónzàwa dĩ́nló yénní kúia na ɓa booní yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ó o hã́a bía nɔn wo yi: «Ɲúhṹso, mu bon. Ɛ̀ɛ ká ɓa booní ɲɔǹ mún pá wee wé sèeka ho dĩ́nló na ɓa háyónzàwa wee dí ká ho ò kùenka.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ó o Yeesu wã́a bía nɔn wo yi: «Ũ bíonì na á ũ bía kà bìo yi, á ĩ ɲɔn o cĩ́ná léra ũ hĩ́nló yi vó. Wã́a hĩ́ní lɛ́n va ũ zĩi.» ");
INSERT INTO boxNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ó o hã́a ɓɛ̀n bĩnía wà van mí zĩi, á vaá yú mí hĩ́nló ò o dũma le dãmu dɛ̀ɛ wán, ò o cĩ́ná ló a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bṹn mɔ́n ó o Yeesu ló ho kɔ̃hṹ na á ho Tiire lóhó wi yi, á ló ho Sidɔ̃n lóhó yi, á kã́a hã Lórá Bìo Pírú kɔ̃hṹ yi bĩnía ɓuararáa lè ho Kalilee vũ-beenì cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Á ɓa bò là a nìi ɓúi ɓuararáa o cɔ̃́n ò o lé o beke, á bíonì mún yí máa ɲí. Ɓa fìora a Yeesu le o bè mí níní o wán. ");
INSERT INTO boxNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ó o Yeesu wã́a fó arɛ́n mí dòn wàráa á khɛ̀ra lè ɓa zã̀amáa, ò o kúaa mí nín-kízàwa o ɲikɔ̃nna yi. Bṹn mɔ́n ó o bò mí ɲinsãní o nìi dɛnle wán, ");
INSERT INTO boxNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ò o hóonía mí yahó ho wáayi á wee fìo, ò o vũuna sùɛɛ ò o bía nɔn o nìi yi: «Efata.» (Mu kúará le «hɛ́n»). ");
INSERT INTO boxNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mí lahó yi ó o nìi ɲikɔ̃nna dɛ̀ɛnía wee ɲí mu bìo, á dɛnle fá, á wee bío sese. ");
INSERT INTO boxNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ó o Yeesu henía mu nɔn bìa wi bĩ́n ɓúenɓúen yi le ɓa yí bío bìo wó kà à na nùpue yi. Ká bìo ó o hò ɓa kà síi, á ɓa wã́a wíokaa wee yényéní mu. ");
INSERT INTO boxNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓa nùpua wó coon mu bìo yi dàkhĩína. Ɓa wee bío: «Bìo ó o wee wé ɓúenɓúen ɓɛ̀ntĩ́n se. Hàrí ɓa bekewà ɲikɔ̃nna wee ɲí mu bìo. Á bìa bíoní lá yí máa ɲí wee bío sese.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hón pã̀ahṹ so yi á ɓa minka zã̀amáa tĩ́n wà ɓueé kúaa mín wán. Bìo á bìo ɓa à dí mía, ó o Yeesu von mí nì-kenínia á bía bìo kà nɔn yi: ");
INSERT INTO boxNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ɓa nùpua na kà màkárí ɓuan miì. Bìo kà lé ɓa wizooní tĩn ká ɓa wi làa mi, á ɓa bè-dínii wã́a vó. ");
INSERT INTO boxNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ká ĩ día ɓa kà síi ɓa wà, á ɓa wé è lé è lùiorá ho wɔ̃hṹ wán lé le hĩni. Lé bìo ɓa cɛ̀rɛ̀ɛ léenía nà yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ó o nì-kenínia bía nɔn wo yi: «Wa à yí mu bè-dínii wen le dùure na kà yi á à na bán minka zã̀amáa so yi?» ");
INSERT INTO boxNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ó o Yeesu tùara ɓa yi: «Lée búurú bìo yɛn wi mi cɔ̃́n?» Á ɓa bía nɔn wo yi: «Lée búurú bìo hèɲun.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ó o bía nɔn ɓa zã̀amáa yi le ɓa lii kɛɛní. Ò o fó ho búurú bìo hèɲun, ò o dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho nɔn mí nì-kenínia yi le ɓa sanka na ɓa zã̀amáa yi, á ɓa sankaa ho nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Cezàwa bùaa yɛn ɓúi mún lá ká ɓa cɔ̃́n. Ó o Yeesu dó le Dónbeenì bárákà ɓa cezàwa mu bìo yi, ò o le ɓa nì-kenínia mún sanka bán na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓa ɓúenɓúen dú sù, ó o nì-kenínia khuiira bìo ká, á mu sú hã sàkíwá bìo hèɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ɓa báawa na kɛra bĩ́n á à yí muaaseé náa síi. Bṹn mɔ́n ó o Yeesu nɔn ho wɔ̃hṹ ɓa yi le ɓa ɓoka. ");
INSERT INTO boxNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ò o yòó zon ho woohṹ bṹn wán lè mí nì-kenínia á ɲɔn ho Dalamanuta kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Á ɓa *Farizĩɛwa ɓuara ɓueé wee wã̀aní là a Yeesu. Ɓa wi ɓa khũaa o ɲii yi, á ɓa le o wé mu yéréké bìo ɓúi na wee zéení le o dàńló ló le Dónbeenì cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ó o Yeesu yòó vũuna sùɛɛ ò o bía: «Lée webio nɔn á ho zuia nùpua wee càráa mu yéréké bìo? Le ĩ mì ho tũ̀iá na mia: Yéréké bìo dɛ̀ɛ woon máa zéení làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ò Yeesu wà día ɓa, á bĩnía yòó zon ho woohṹ lè mí nì-kenínia á ɲɔn lè ho vũ-beenì mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","O Yeesu nì-kenínia nɔnsãa á yí ɓuan mu bè-dínii. Búurú bi-za dà-kéní mí dòn lé hìa wi ɓa cɔ̃́n ho woohṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ó o Yeesu wã́a bía bìo kà henía nɔn ɓa yi: «Mi fání mí yìo, à pa miten bìo ɓa *Farizĩɛwa là a *Heroode bìo yi. Ɓa bìo ɓonmín lè le ɲa-fĩni.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ó o nì-kenínia wee bío mín yi: «O wee bío kà síi lé bìo wa yí ɓuan ho búurú.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ó o Yeesu zũna bìo ɓa wee bío, ó o tùara ɓa yi: «Lée webio nɔn mi wee bíoráa le lé bìo mi yí ɓuan ho búurú? Mi pá dĩǹ yí máa ɲí mu bìo à zũń mu kúará le? Mi tun mi yiwa le? ");
INSERT INTO boxNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mi lée muiiwà lée, tàá mi yí máa ɲí bìo. Mi so yí máa leéka mi yiwa bìo kà wán le: ");
INSERT INTO boxNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bìo á ĩ cɛ̀ɛkaa ho búurú bìo hònú nɔn ɓa báawa muaaseé hònú yi, á bìo dú ká na mi khuiira wàráa sú sàkíwá bìo yɛn?» Á ɓa bía: «Lée sàkíwá pírú ɲun.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ó o bĩnía tùara ɓa yi: «Á bìo á ĩ cɛ̀ɛkaa ho búurú bìo hèɲun á nɔn ɓa báawa muaaseé náa yi, á bìo dú ká na mi khuiira wàráa á sú sàkíwá bìo yɛn?» Á ɓa bía: «Lée sàkíwá bìo hèɲun.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ó o Yeesu wã́a bía nɔn ɓa yi: «Ó, o! À hàrí lòn zuia à mi pá yí zũ mu bìo yara le?» ");
INSERT INTO boxNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bṹn mɔ́n á ɓa wà vaá dɔ̃n ho Bɛtesayidaa lóhó. Á ɓa ɓúi ɓuan o muii ɓuararáa o Yeesu cɔ̃́n à ɓa fìora a le o tṹii wo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ó o Yeesu tò a muii mu níi yi á lóráa ho donkĩ́ahṹ, á lée bò mí ɲinsãní o yìo wán, ò o bò mí níní o wán ò o tùara a yi: «Fo wee mi bìo ɓúi le?» ");
INSERT INTO boxNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ó o muii yòó lońna ò o bía: «Ĩ wee mi ɓa nùpua. Ɓa wee varáka, ká ɓa màhã́ ka lòn vĩ̀nsĩ̀a.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ó o Yeesu pá bĩnía bò mí níní o yìo wán, ó o lońna sese á mɔn mu bìo wéréwéré. O wan á wee mi mu bìo ɓúenɓúen wɛ̃̀ɛn. ");
INSERT INTO boxNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ó o Yeesu wã́a le o lɛ́n va mí zĩi, ká a yí lii zo lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bṹn mɔ́n ó o Yeesu lè mí nì-kenínia wà ɲɔn lè hã lórá na sùaráa yi là a Filiipu ló-fáránii cɔ̃́n, hìa ɓa le Sezaaree. Bìo ɓa lá ho wɔ̃hṹ wà, ó o Yeesu tùara ɓa yi: «Lée webio ɓa nùpua wee bío ĩ dã́ní yi?» ");
INSERT INTO boxNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Á ɓa bía: «Ɓa ɓúi le fo lé o Zãn Batiisi. Ɓa ɓúi le fo lé o *Elii. Ɓa ɓúi bán ɓɛ̀n le fo lé *Dónbeenì ɲi-cúa fɛɛrowà ɓúi na yáanía nì-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ó o bĩnía tùara: «Ká minɛ́n bán ɓɛ̀n le ĩ lée wée?» Ó o Piɛre bía nɔn wo yi: «Ũnɛ́n lé yìa le Dónbeenì mɔn léra.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ó o Yeesu wã́a henía mu nɔn ɓa yi le ɓa yí bío mu na nùpue yi. ");
INSERT INTO boxNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bṹn mɔ́n ó o Yeesu wee kàrán mí nì-kenínia ká a bío: «O *Nùpue Za ko ò o lò be làa sòobɛ́ɛ. Ɓa *nì-kĩ́a, lè le *Dónbeenì yankarowà ɲúnása, lè ho *làndá bìo zéenílowa á à pĩ́ a bìo. Ɓa nùpua à ɓúe o ká hã wizooní tĩn zoǹ o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O hĩ́a wee bío mu na ɓa yi wéréwéré. Ó o Piɛre wã́a fó a á ɓa vá ló, á lée wee bío làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ká a Yeesu màhã́ yèrèmáa khíi lońna mí nì-kenínia yi ò o nàmakaa o Piɛre yi kà síi: «Va lé ĩ nìsã́ní lè ũ *Satãni bíoní. Ũ yilera yínɔń Dónbeenì yilera. Hã lé ɓa nùpua yilera.» ");
INSERT INTO boxNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bṹn mɔ́n ó o Yeesu von ɓa zã̀amáa lè mí nì-kenínia á bía nɔn yi: «Yìa wi ò o bè miì, à ɓànso khí mí kùrú sĩi bìo wéro yi, ká a wé lá mí *kùrùwá pĩ̀ à bèráa miì. ");
INSERT INTO boxNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","O nùpue na wi ò o kã̀ní mí mukãnì wón á à vĩ́iní le. Ká yìa màhã́ tà le mí ì vĩ́iní le ĩnɛ́n lè le Dónbeenì bín-tente bìo yi, wón á à kã̀ní le. ");
INSERT INTO boxNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","O nùpue lá yú ho dĩ́míɲá bìo ɓúenɓúen ò o khon le mukãnì binbirì yi, se lé ho cũ̀nú yɛ́n á ɓànso yú? ");
INSERT INTO boxNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Lée webio ó o nùpue dà à kã̀ní lè mí mànákã̀? ");
INSERT INTO boxNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yìa wee nìyi ĩnɛ́n lè ĩ bíoní bìo yi ho zuia nùpua tĩ́ahṹ, bìa wee bĩní le Dónbeenì mɔ́n à wé mu bè-kora, ó o Nùpue Za ɓɛ̀n mún khíi nìyi ɓànso bìo yi ká a khíi bĩnía ɓuara mín Maá Dónbeenì cùkú beenì yi lè le Dónbeenì wáayi tonkarowà.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O Yeesu pá bĩnía bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Ɓa nùwã yɛn ɓúi wi hen á máa hí ká ɓa yí mɔn le *Dónbeenì bɛ́ɛnì láró lè ho pànká.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wizooní bìo hèzĩ̀n bṹn mɔ́n, ó o Yeesu fó a Piɛre là a Zaaki là a Zãn á yòoraráa le ɓúee ɓúi na dɔ̃n wán á ɓa yòó wi bĩ́n mí dòn. Ó o Yeesu dĩ̀ndĩ̀n miníkaa ɓa yahó, ");
INSERT INTO boxNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","á sĩ̀-zĩ́nia wee ɲuiíka kũ̀iákũ̀iá, á ka pṹiapṹia. Hã cemu ɓàn síi a nùpue na dà à ceé làa sĩ̀a ho dĩ́míɲá yi wón mía. ");
INSERT INTO boxNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yìo ɓueé tĩ, ò o *Elii là a *Mɔyiize dĩ̀ndĩ̀n ló ɓueé wee bío là a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ó o Piɛre wã́a bía nɔn o Yeesu yi: «Nì-kàránlo, mu wó se á wa wi hen. Wa à tá hã bùkú zàwa bìo tĩn: Ũnɛ́n dà-kéní, o Mɔyiize dà-kéní, o Elii dà-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O yí zũ bìo o ò bío lé bìo ɓa ninzàwa là arɛ́n mí bɛɛre á zã́na dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Á le dùndúure ɓúi yòó ló lií pon ɓa yi á mu tãmu ɓúi sã wee ɲí le dùndúure mu yi: «Yìa kà lé ĩ Za na á ĩ bò ĩ tàká wán, mi wé ɲí a cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mí lahó yi á ɓa nì-kenínia lońkaa mí nìsã́a yi, à ɓa màhã́ yí mɔn nì-veere ká yínɔń o Yeesu mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bìo ɓa ló le ɓúee wán wee lii, ó o Yeesu bía nɔn ɓa yi: «Bìo mi mɔn kà á mi yí bío le nùpua ɲí, ká mu yínɔń o *Nùpue Za húmú là a vèeró mɔ́ndɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Á ɓa tà bìo ó o bía yi ká ɓa màhã́ wee tùaka mín yi: «Ho vèeró mu húmú mɔ́ndɛ́n ɓàn kúará lé mu yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Á ɓa tùara a Yeesu yi: «Lée webio nɔn á ho *làndá bìo zéenílowa le o Elii ko ò o ɓuen ho yahó?» ");
INSERT INTO boxNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ó o bía nɔn ɓa yi: «Mu bon. O Elii ko ò o ɓuen ho yahó à ɓuee kúee mu bìowa mí lara yi. Ɛ̀ɛ ká lée webio ɓɛ̀n mún nɔn á mu túararáa le Dónbeenì bíonì vũahṹ yi le o Nùpue Za lò ò be làa sòobɛ́ɛ, á ɓa mún máa mì a máa dé dɛ̀ɛ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Àwa, á le ĩ bío mu na mia: O *Elii mu ɓuara ho yahó, á ɓa nùpua wó a làa bìo ɓa sĩa vá yi làa bìo mu túararáa le Dónbeenì bíonì vũahṹ yi o dã́ní yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bìo ɓa ɓueé dɔ̃n ɓa nì-kenínia na ká, á ɓa ɓueé yú à ɓa zã̀amáa kĩ́nía ɓa yi, á ho *làndá bìo zéenílowa ɓúi dĩ̀n wee wã̀aní làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ɓa nùpua miiníi là a Yeesu á mu vĩ̀níkaa ɓa. Á ɓa ɓùunia wà ɓueé tɛ̀ɛní a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ó o Yeesu tùara mí nì-kenínia yi: «Lée webio mi wee wã̀aní wán làa ba?» ");
INSERT INTO boxNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ó o ɓúi ló ɓa zã̀amáa yi á bía nɔn wo yi: «Nì-kàránlo, ĩ lá ɓuan ĩ za ɓuararáa ũ cɔ̃́n, cĩ́ná ɓúi wi o yi á wee beé o lò. O wee hè o ò o máa bío yí. ");
INSERT INTO boxNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lùe lée lùe ká a bìo mu hĩ́nɔn o wán, ò o cĩ́ná mu fé o dé ho tá yi, ò o ɲinsã-khùankhúa wé lé, à wé là mí ɲia, à pà día. Á ĩ fìora ũ nì-kenínia le ɓa ɲa a cĩ́ná mu lén wo yi, ká ɓa màhã́ yí dàńna mu.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ó o Yeesu bía nɔn ɓa yi: «Mi zuia nùpua ɓɛ̀ntĩ́n yí dó mí sĩa le Dónbeenì yi bìo bon. Ĩ màhã́ wã́a à ɲì ĩ yi mi bìo yi, á wé è kàrán mia vaá dã ho pã̀ahṹ yɛ́n coon? Mi ɓua a háyónza mu ɓuennáa.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Á ɓa ɓuan wo ɓuararáa. O cĩ́ná miiníi là a Yeesu ó o zɛ̀kɛ́ra a háyónza lè mí pànká. Á wón lií lùwá ho tá yi, á wee birónka, á ɲinsã-khùankhúa wee lé. ");
INSERT INTO boxNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ó o Yeesu tùara a háyónza ɓàn maá yi: «Mu wee wé o yi míana lée tàá lé lònbìo?» Á ɓàn maá bía: «Lé o kúnkúzàmu pã̀ahṹ á mu ɓúakáa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pɔ̃̀nna cɛ̀rɛ̀ɛ yi ó o cĩ́ná mu wé lá a à dé ho dɔ̃hṹ yi tàá mu ɲumu yi le mí ì ɓúe. Ká fo dà à wé bìo ɓúi, à ũ màkárí wɛn à ũ séení wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ó o Yeesu bía nɔn wo yi: «Fo bía le ká ĩ dà mu. Yìa dó mí sĩi miì á bìo ɓúenɓúen dà wee wé cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mí lahó yi ó o háyónza ɓàn maá dɛ̀ɛnía zoó wãamaa: «Ĩ dó ĩ sĩi foǹ ká ũ màhã́ séení mi à ĩ yí titika.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ó o Yeesu mɔn à ɓa zã̀amáa ɓùunia wà ɓueé ɓúe ɓa yi, ó o wee zá là a cĩ́ná kà síi: «Ũnɛ́n cĩ́ná na wee wé ò o nùpue máa bío yí, à mún máa ɲí mu bìo, le ĩ bío mu na foǹ, lé o háyónza mu yi, à yí bĩní yí zo a yi hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ó o cĩ́ná wee wãama, ò o zɛ̀kɛ́ra a háyónza lè mí pànká ò o ló. Ó o háyónza día lòn nùpue na húrun. Fúaa bìa wi bĩ́n cɛ̀rɛ̀ɛ wee bío le o húrun. ");
INSERT INTO boxNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ká a Yeesu màhã́ lií fù a níi yi á hóonía làa wo ó o yòó dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bìo ó o Yeesu wà van le zĩi yi á lè mí nì-kenínia mí dòn páanía wi, á ɓa tùara a yi: «Lée webio nɔn á warɛ́n yí dàńna yí ɲɔnnáa o cĩ́ná mu?» ");
INSERT INTO boxNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ó o Yeesu bía nɔn ɓa yi: «Ho fìoró mí dòn lé hìa dà à ɲa a cĩ́ná na kà ɓàn síi á à lén.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bṹn mɔ́n ó o Yeesu lè mí nì-kenínia ló dén lùe so yi á kã́a ho Kalilee kɔ̃hṹ wà. O Yeesu yí wi à ɓa nùpua zũń o dã́ní, ");
INSERT INTO boxNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","lé bìo ó o wee kàrán mí nì-kenínia. O wee bío na ɓa yi: «O *Nùpue Za á ɓa à dé ɓa nùpua níní yi á ɓa à ɓúe. Ó o húmú mɔ́n wizooní tĩn ká a vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ká a nì-kenínia màhã́ yí zũna a bíonì mu kúará. Á ɓa mún zã́na, á yí wi ɓa tùa wo yi lè mu ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bṹn mɔ́n ó o Yeesu lè mí nì-kenínia wà vaá dɔ̃n ho *Kapɛɛnayuumu lóhó. Bìo á ɓa wà van le zĩi yi ó o tùara ɓa yi: «Lée webio mi lá wee wã̀aní wán ho wɔ̃hṹ wán?» ");
INSERT INTO boxNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Á ɓa wó tɛ́tɛ́, lé bìo ɓa lá wee wã̀aní, á wi ɓa zũń yìa po ɓarɛ́n na ká. ");
INSERT INTO boxNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ó o Yeesu wã́a lií kará ò o von ɓa mí pírú ɲun á bía nɔn yi: «Hen ká yìa wi ò o kɛń bìa ká ɲúhṹ wán, à ɓànso liiní míten ɓa ɓúenɓúen yahó, à wé ɓa ɓúenɓúen ton-sá.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ò o fó a háyónza ɓúi ɓueé dĩ̀nía ɓa yahó, á lií lá a yòó ɓuan ò o bía: ");
INSERT INTO boxNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Nùpue lée nùpue na ɓuan o háyónza na kà ɓàn síi sese ĩnɛ́n bìo yi, se le ĩnɛ́n ĩ bɛɛre á ɓànso ɓuan sese. Á yìa ɓuan mi sese, se mu yínɔń ĩnɛ́n á ɓànso ɓuan sese, mu lé yìa tonkaa mi ó o ɓuan sese.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ó o Zãn bía nɔn o Yeesu yi: «Nì-kàránlo, wa mɔn o nìi ɓúi ò o wee ɲa ɓa cĩ́náwa lè ũ yèni, á wa lá wi à wa hè o, lé bìo ó o mía wa kuure yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ká a Yeesu màhã́ bía nɔn ɓa yi: «Mi yí hè o, lé bìo á Nùpue na wó yéréké bìo lè ĩ yèni á yí dà máa bío bín-kohó ĩ dã́ní yi mí lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yìa yí máa fi làa wɛn se wón làa wɛn lée dà-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Le ĩ mì ho tũ̀iá na mia: Yìa nɔn mu ɲumu kóo-cúe mia lé bìo mi bìo sã̀ yìa le Dónbeenì mɔn léra yi, wón ɓànso á à yí mu cũ̀nú máa khí. ");
INSERT INTO boxNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ɓa háyúwá na dó mí sĩa miì á yìa khà dó mu bè-kohó wéró yi, wón ɓànso á ɓa lá can le hue-beenì fonle yi á lèera dó ho muhṹ yi, bṹn pá à wé sṹaaní le lònbee na à yí o. ");
INSERT INTO boxNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ká mu lé ũ níi wee dé fo mu bè-kora wéró yi, à ũ kúii le día. Fo yú le mukãnì binbirì na máa vé lè ũ níi dà-kéní bṹn sṹaaní bìo ɓa à dé fo le Dofĩ́ní dɔ̃hṹ na máa hí lùe yi lè ũ níní bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‹Ɓa sũnɓowa na wee là hã sãnía wi bĩ́n, ɓa yí máa hí. Á ho dɔ̃hṹ mún yí máa hí bĩ́n hùúu.› ");
INSERT INTO boxNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ká mu lé ũ zeǹ wee dé fo mu bè-kora wéró yi, à ũ kúii le día. Fo yú le mukãnì binbirì na máa vé lè ũ zeǹ kéní bṹn sṹaaní bìo ɓa à dé fo le Dofĩ́ní dɔ̃hṹ na máa hí lùe yi lè ũ zení mí bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‹Ɓa sũnɓowa na wee là hã sãnía wi bĩ́n, ɓa yí máa hí, á ho dɔ̃hṹ mún yí máa hí bĩ́n hùúu.› ");
INSERT INTO boxNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ká mu mún lé ũ yère wee dé fo mu bè-kora wéró yi, à ũ còkon le lén día. Fo yú le *Dónbeenì bɛ́ɛnì lè ũ yèn-kéní bṹn sṹaaní bìo ɓa à dé fo le Dofĩ́ní dɔ̃hṹ na máa hí lùe yi lè ũ yìo mí bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‹Ɓa sũnɓowa na wee là hã sãnía wi bĩ́n, ɓa yí máa hí. Á ho dɔ̃hṹ mún yí máa hí bĩ́n hùúu.› ");
INSERT INTO boxNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Nùpue lée nùpue á le Dónbeenì khíi khɛ́n kúará lè le lònbee na ka lòn dɔ̃hṹ bìo, á à ceéráa wo, làa bìo ɓa hĩ́a wee wé kúeeráa mu yámú mu hãmu wán à ceéráa mu bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mu yámú yoo. Ɛ̀ɛ ká mu yámú yonyoró hĩ́a ló mu yi, á ɓa à wé kaka á mu ù bĩní ì zoráa? Minɛ́n mi bɛɛre kɛń lòn yámú na yonyoró wi. Mi kɛń mín wán làa hɛ́ɛrà.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bṹn mɔ́n ó o Yeesu ló bĩ́n á wà van ho *Zudee kɔ̃hṹ, á khú ho Zurudɛ̃n muhṹ mɔ́n. Á ɓa zã̀amáa tĩ́n kúaaka mín wán hen na ó o wi yi. Ó o wee kàrán ɓa làa bìo ó o lá wee wé wéráa mu. ");
INSERT INTO boxNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Á ɓa *Farizĩɛwa nùwã yɛn ɓúi vá ɓueé ɓó a yi. Ɓa wi à ɓa yí o níi ɓua yi, á ɓa tùara a yi: «Wa làndá wee na níi báa yi ò o ɲa mín hã́a le?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ó o Yeesu mún tùara ɓa yi: «Lé mu yɛ́n ó o *Mɔyiize làndá henía nɔn mia mu dã́ní yi?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Á ɓa bía: «O Mɔyiize nɔn le níi le ká báa wi ò o día mín hã́a ò o lɛ́n, ò o wé mu yaamu fáaró vũahṹ vé à bè yi díaráa wo.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ó o Yeesu wã́a bía nɔn ɓa yi: «O Mɔyiize mà bṹn lé bìo mi yí máa ɲí dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bṹn mía á mu ɲúhṹ ɓúɛɛníi ká mu lá yí ka kà. Mu bìo ɓúenɓúen lénló pã̀ahṹ, á le Dónbeenì ‹léra a báa, á léra a hã́a.› ");
INSERT INTO boxNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‹Bṹn bìo yi ó o báa á à día mín maá lè mín nu ká à lɛɛ́ lè mín hã́a, ");
INSERT INTO boxNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","á ɓa mí nùwã ɲun á à wé sãnía dà-kéní.› Ɓa wã́a yínɔń nùwã ɲun, ɓa lée nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bìo le Dónbeenì cɛɛ́ra mín yi à nùpue yí fáa.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Á bìo ó o Yeesu lè mí nì-kenínia hĩ́a zon le zĩi yi, á ɓa wíokaa tùara a yi mu bìo mu dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ó o bía nɔn ɓa yi: «Báa na día mín hã́a ò o kũn fó hã́-veere yan, se wón lée hã́-fé ɓàn nín-yání hã́a cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mu lée dà-kéní là a hã́a na día mín báa ò o wà vaá yan bá-veere. Wón mún lée bá-fé.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓa nùpua ɓúi ɓuan mí háyúwá ɓuararáa o Yeesu cɔ̃́n le o bè mí níní ɓa wán. Ó o nì-kenínia wee zá làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ká bìo ó o Yeesu mɔn mu, ó o sĩi cã̀ ó o bía nɔn mí nì-kenínia yi: «Mi wé día le ɓa háyúwá ɓuen ĩ cɔ̃́n. Mi yí hè ɓa. Mu bon, bìa ka lè ɓa háyúwá na kà bìo síi, lé bán á à kɛń le Dónbeenì bá-zàmu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Le ĩ mì ho tũ̀iá na mia: Yìa yí tà le *Dónbeenì bɛ́ɛnì bìo là a háyónza bìo síi á ɓànso yí dà máa zo le yi hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bṹn mɔ́n ó o wee láka ɓa ɓua ò o bò mí níní ɓa nì-kéní kéní wán ò o fara le le Dónbeenì wé mu bè-tentewà làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bìo ó o Yeesu wee lá ho wɔ̃hṹ á à lɛ́n, à bṹn ò o nìi ɓúi lùwá mà a, á ɓueé lií fárá mí nɔnkóɲúná wán o yahó ò o tùara a yi: «Nì-kàránlo tente, lée webio á ĩ ko á ĩ wé à yíráa le mukãnì binbirì na máa vé?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ó o Yeesu bía nɔn wo yi: «Lée webio nɔn fo wee veráa mi làa nì-tente? Nì-tente mía ká mu yínɔń le Dónbeenì mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fo zũ le Dónbeenì làndáwá na kà: Yí ɓúe nùpue, yí wé hã́-fénló tàá bá-fénló, yí ɲuaa bìo, yí fĩ̀ sabéré nùpue ɲii, yí khà nùpue à fé bìo, kɔ̃̀nbi mìn maá lè mìn nu.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ó o nìi bía: «Nì-kàránlo, bṹn ɓúenɓúen á ĩ bò yi hàrí ĩ yàrónzàmu pã̀ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ó o Yeesu lońna a yi, á wara a. Ó o bía nɔn wo yi: «Bìo dà-kéní ká á fo yí wó. Lɛ́n vaa yɛ̀ɛ́ bìo wi ũ cɔ̃́n ɓúenɓúen à sanka ɓàn wárí na ɓa nì-khenia yi, bṹn ká le Dónbeenì kĩ́a na ho wáayi á fo ò yí. Bṹn mɔ́n à ũ bĩní ɓuee bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ká a nìi ɲá hɔ̃́n bíoní so, ó o sãnía tò, á yèrèmáa wà ká a yilera yáara, lé bìo ó o níi bìo boo. ");
INSERT INTO boxNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ó o Yeesu lońna mí nì-kenínia na kĩ́nía wo yi ò o bía: «Ho nàfòró ɓànsowà zoró le *Dónbeenì bɛ́ɛnì yi ɓɛ̀ntĩ́n lònbee wi.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hã bíoní mu yáara ɓa hácírí làa sòobɛ́ɛ. Ó o Yeesu pá bĩnía bía nɔn ɓa yi: «Wàn bɔ̃́nlowà, ho zoró le Dónbeenì bɛ́ɛnì yi ɓɛ̀ntĩ́n lònbee wi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","O cón-ɲúmúkũ̀ zoró lè ho mísĩ̀mí kɔ̃hṹ á à wé wayi á à poń o nàfòró ɓànso zoró le Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɓa nì-kenínia wó coon dàkhĩína hã bíoní mu bìo yi. Á ɓa wee tùaka mín yi: «Éee! Á yìa wã́a dà à fen lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ó o Yeesu lońna ɓa yi ò o bía: «Bìo yí dà máa wé ɓa nùpua cɔ̃́n á dà wee wé le Dónbeenì cɔ̃́n. Lé bìo le Dónbeenì dà bìo ɓúenɓúen wee wé.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ó o Piɛre bía nɔn wo yi: «Loń, warɛ́n ló día bìo lá wi wa cɔ̃́n ɓúenɓúen à wa bò foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Yìa ló día mí zĩi, lè mín zàwa, lè mín hĩ́nni, lè mín nu, lè mín maá, lè mí zàwa, lè mí manawà ĩnɛ́n lè ĩ bín-tente bìo yi, ");
INSERT INTO boxNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","á ɓànso ò yí hã zĩní, lè mín zàwa, lè mín hĩ́nni, lè ɓa nuwà, á à yí ɓa zàwa, lè hã manawà. Á le lònbee mún ǹ yí o. Mu ɓàn khĩmàni khĩmàni á ɓànso ò yí ho pã̀ahṹ na wa wi yi. Á mún ǹ yí le mukãnì binbirì na máa vé ho pã̀ahṹ na wà à ɓuen yi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɛ̀ɛ ká bìa dú ho yahó bìo kà wán á cɛ̀rɛ̀ɛ khíi wé ɓa mɔ́n-díwá. Á bìa dú ho mɔ́n bìo kà wán á khíi wé ɓa ya-díwá.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","O Yeesu làa bìa làa wo bò mín wã́a lá ho wɔ̃hṹ wee yòo ho Zeruzalɛɛmu. Ó o varákaa dú mí nì-kenínia yahó. Ó o nì-kenínia hácírí yáara, á bìa làa ba bò mín zã́na. Ó o Yeesu tĩn bĩnía fó mí nì-kenínia pírú ɲun, ò o wee bío bìo ko mu wé o yi hen làa cĩ́inú à na ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Mi loń, wa wee yòo ho Zeruzalɛɛmu, hen na ó o *Nùpue Za ɓa à dé le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa níi yi. Ɓa à síiní a ɲúhṹ, á à na bìa yínɔń ɓa *zúifùwa yi á ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bán á à zùańka a yi, á à pũ̀iní mí ɲinsãní ì kúee o wán, á à ha a lè hã làbàaní, á à ɓúe o. Ká hã wizooní tĩn zoǹ o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bṹn mɔ́n ó o Zebedee zàwa Zaaki là a Zãn á ɓueé ɓó a Yeesu yi á bía nɔn wo yi: «Nì-kàránlo, wa wi à ũ wé bìo wa à fìo ũ cɔ̃́n à na wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ó o Yeesu tùara ɓa yi: «Lé mu yɛ́n á mi le ĩ wé na mia?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Á ɓa bía nɔn wo yi: «Hen ká ũ khíi wi ũ bɛ́ɛnì cùkú yi, à ũ tà día le wa kɛɛní ũ nìsã́a. O nì-kéní kɛń lè ũ nín-tĩánì, à yìa so kɛń lè ũ nín-káahó.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ó o Yeesu bía nɔn ɓa yi: «Bìo mi wee fìo á mi yí zũ ɲúhṹ. Mi so dà a lá le lònbee na à dé mi mu húmú yi làa mi le?» ");
INSERT INTO boxNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Á ɓa le ũuu le mí dà mu. Ó o Yeesu bía nɔn ɓa yi: «Mu bon. Le lònbee na à yí mi ɓàn síi á à yí mia. Mi ì zo le lònbee mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ká mu màhã́ yínɔń ĩnɛ́n á à bío le yìa kà ɓànso à kɛɛní ĩ nín-tĩánì tàá ĩ nín-káahó. Hɔ̃́n lùa so bìo sã̀ bìa le Dónbeenì wíokaa hã karáa yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ká bìo ɓa nì-kenínia nùwã pírú na ká ɲá mu, á ɓa sĩa cã̀ a Zaaki là a Zãn yi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ó o Yeesu von ɓa ɓúenɓúen á bía nɔn yi: «Mi zũ mu le bìa ɓa nùpua yìo wi wán le ɓa lé hã kãna ɲúnása, bán ɲúnása so á wee wé zéení mí pànká ɓa nùpua wán. Á ɓa nì-beera wee wé zéení làa bìa ká le mí po ɓa. ");
INSERT INTO boxNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ɛ̀ɛ ká minɛ́n bìo lá yí ko mu wé kà síi. Hen ká mi nì-kéní ɓúi wi ò o bìo ɲúhṹ wé poń bìa ká, à ɓànso wé minɛ́n na ká ton-sá. ");
INSERT INTO boxNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hen ká mi nì-kéní ɓúi wi ò o dí bìa ká yahó, á ɓànso ko o ò wé mi ɓúenɓúen wobá-nìi. ");
INSERT INTO boxNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","O Nùpue Za mí bɛɛre yàá yí ɓuara à ɓa sá na a yi. O ɓuara wà ɓueé sá à na ɓa nùpua yi, á mún ǹ na mí mukãnì á à lénnáa ɓa nùpua cɛ̀rɛ̀ɛ ɲúná.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","O Yeesu lè mí nì-kenínia lè ɓa zã̀amáa vaá dɔ̃n ho Zerikoo lóhó. Bìo ɓa wee lé ho yi, à bṹn ò o muii ɓúi na ɓa le Baatimɛɛ á kará ho wɔ̃hṹ nìsã́ní wee fìoka. Ɓàn maá ɓa le Timɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bìo ó o ɲá le mu lé o Nazarɛɛte nìi Yeesu, ó o bía pɔ̃́npɔ̃́n: «*Daviide Za, Yeesu, màkárí miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Á ɓa nùpua cɛ̀rɛ̀ɛ wee zá làa wo le o wé tɛ́tɛ́. Ó o yàá wã́a wíokaa wee bío pɔ̃́npɔ̃́n: «Daviide za, màkárí miì.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ó o Yeesu dĩ̀n ò o bía: «Mi ve o le o ɓuen.» Á ɓa bía nɔn o muii mu yi: «Hení ũ sĩi, lii hĩ́ní, lé o wee ve fo.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ó o wã́a lèera mí kánɓun día, ò o lií tá hĩ́nɔn á mà a Yeesu wee ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ó o Yeesu tùara a yi: «Lée webio á fo le ĩ wé na foǹ?» Ó o muii bía nɔn wo yi: «Nì-kàránlo wé le ĩ yìo à wé mi.» ");
INSERT INTO boxNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ó o Yeesu bía nɔn wo yi: «Lɛ́n, bìo fo dó ũ sĩi miì lé bṹn á ĩ wɛɛ́raráa fo.» Mí lahó yi ó o dɛ̀ɛnía wee mi á bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bìo ó o Yeesu lè mí nì-kenínia vaá sùaráa ho Zeruzalɛɛmu yi, ho Bɛtefazee lè ho Betanii lórá nìsã́ní, lè hã Oliivewa vĩ̀nsĩ̀a ɓúee cɔ̃́n, ó o Yeesu tonkaa mí nì-kenínia nùwã ɲun le ɓa dí mí yahó, ");
INSERT INTO boxNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","á bía nɔn ɓa yi: «Mi lɛ́n va ho lóhó na vaá mi yahó yi. Mi vaa dɛ̃ɛníi á mi ì dɛ̀ɛní ì mi sũ̀npɛ̀-bòohṹ ɓúi na á nùpue dĩ̀n yí yòora yí mɔn hùúu ká a can dĩ̀n. Mi fee wo à ɓua ɓuee na miì. ");
INSERT INTO boxNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ká a ɓúi tùara mia le lée webio nɔn mi wee feeráa wo, à mi bío na ɓànso yi le o Ɲúhṹso màkóo wi o yi, ó o mún ǹ bĩní ì ɓuen làa wo lònbìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Á ɓa wà van á vaá zoó yú a sũ̀npɛ̀-bòohṹ ɓúi le ɓonfónii ho wɔ̃hṹ nìsã́ní ká a can dĩ̀n le zĩi ɓúi zũaɲii. Á ɓa feera a. ");
INSERT INTO boxNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Á ɓa nùpua nùwã yɛn ɓúi na wi bĩ́n á tùara ɓa yi: «Lée webio mi wó kà? Mi feera o sũ̀npɛ̀ɛnì mu le we?» ");
INSERT INTO boxNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Á bìo ó o Yeesu lá bía nɔn ɓa yi lé bṹn á ɓa bía nɔn ɓa nùpua mu yi. Á ɓa día ɓa á ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓa ɓuan o sũ̀npɛ̀ɛnì mu ɓueé nɔn o Yeesu yi, à ɓa bò mí kánɓunwà o mání wán, ó o Yeesu yòó kará wán. ");
INSERT INTO boxNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓa nùpua cɛ̀rɛ̀ɛ wee bá mí kánɓunwà ho wɔ̃hṹ wán o yahó. Ɓa ɓúi lé hã vĩ̀nsĩ̀a vɔ̃nna na ɓa khó hã mana yi á ɓa wee bá. ");
INSERT INTO boxNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bìa dú a yahó làa bìa dú a mɔ́n á wee bío bìo kà pɔ̃́npɔ̃́n: «Le ho cùkú à bìo sĩ̀ le Dónbeenì yi. Le le Dónbeenì wé mu bè-tentewà làa yìa bò o ɓuen o Ɲúhṹso Dónbeenì yèni yi. ");
INSERT INTO boxNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Le le Dónbeenì wé mu bè-tentewà làa yìa wà ɓueé fárá wàn ɓùaa *Daviide bɛ́ɛnì á à dĩ̀ní. Le ho cùkú à bìo sĩ̀ le Dónbeenì na dà mu bìo ɓúenɓúen wán yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bìo ó o Yeesu vaá dɔ̃n ho Zeruzalɛɛmu, ó o wà van le *Dónbeenì zĩ-beenì lún yi, á zoó lońkaa le khíi fò. Bṹn mɔ́n ó o fó mí nì-kenínia pírú ɲun à ɓa bĩnía ɲɔn ho Betanii. À bṹn à le wii wã́a tò. ");
INSERT INTO boxNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mu tá na lée tɔ̃n, pã̀ahṹ na ɓa wee lé ho Betanii yi á à lɛ́n, à bṹn ò o Yeesu á le hĩni dà. ");
INSERT INTO boxNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O khɛ̀ra mɔn le vĩ̀ndɛ̀ɛ na ɓa le fíkíyée à le sà dĩ̀n. Ó o wà le mí vaá loń le mí ì yí bia le wán lé. Ó o vaá yú à lée vɔ̃nna mí ɲii yi, lé bìo mu yí wó hã vĩ̀nsĩ̀a mu haró pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ó o Yeesu wã́a bía nɔn le vĩ̀ndɛ̀ɛ mu yi: «Fo máa bĩní máa ha bia hùúu á nùpue máa dí.» Ó o nì-kenínia ɲá bìo ó o bía. ");
INSERT INTO boxNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɓa vaá dɔ̃n ho Zeruzalɛɛmu ó o Yeesu wà vaá zon le *Dónbeenì zĩ-beenì lún yi á zoó wee ɲa ɓa bè-yɛ̀ɛ́rowà lè ɓa bè-yàwa. Ɓa wɛ́n-pùarílowà tàbáríwa, làa bìa wee yɛ̀ɛ́ ɓa ɓùaaɓúuní kanmúiní ó o dónkaa kúaa. ");
INSERT INTO boxNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O wee hè ɓa le nùpue yí ɓua dɛ̀ɛ à kã́anáa ho lún mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ò o màhã́ wã́a wee kàrán ɓa nùpua làa bìo kà: «Le Dónbeenì bíonì vũahṹ yi á mu bía: ‹Ĩ zĩi ɓa wé è ve le kãna nùpua ɓúenɓúen fìoró zĩi.›» Ò o Yeesu bĩnía bía: «Á minɛ́n wó le lè ɓa kɔ̃̀nlowà lùe hã́?» ");
INSERT INTO boxNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Á le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa ɲá mu á ɓa wee cà bìo ɓa à wé wé è ɓúeráa o Yeesu. Ɓa zã́na a lé bìo ó o kàránló á ɓa zã̀amáa ɓúenɓúen sĩa wee wa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bìo le wii tò ó o Yeesu lè mí nì-kenínia á ló ho lóhó yi lée wà. ");
INSERT INTO boxNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mu tá na lée tɔ̃n yìnbíi bùirìi ká ɓa lá ho wɔ̃hṹ wà, á ɓa vaá mɔn ho fíkíyée mu à ho hon lè mí naní ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ó o Piɛre leékaa bìo wó khĩína bìo, ó o bía nɔn o Yeesu yi: «Nì-kàránlo, loń. Ho fíkíyée na fo dánkánía á hon.» ");
INSERT INTO boxNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ó o Yeesu wã́a bía nɔn mí nì-kenínia yi: «Mi dé mi sĩa le Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Le ĩ mì ho tũ̀iá na mia: Ká a ɓúi lá bía lè le ɓúee na kà: ‹Hĩ́ní hen na fo wi yi à vaa zo ho mu-beenì yi.› Ká ɓànso yí titikaa ò o dó mí sĩi le Dónbeenì yi le bìo mí bía á à wé, á mún ǹ wé á à na a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lé bṹn nɔn á ĩ wee bíoráa mu á à na mia: Hen ká mi wé wee fìo bìo ɓúi le Dónbeenì cɔ̃́n à mi láa mu yi le mu yú vó. Le è wé mu á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mi wé sansan wee fìo, ká a ɓúi wó khon làa mia á mi sĩa wee cĩ̀ bìo yi, à mi sɛ́n mu día. Bṹn ká mìn Maá Dónbeenì á mún ǹ sɛ́n mi bè-kora á à día.» ");
INSERT INTO boxNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ká mi yí máa tà sɛ́n día na ɓa yi, á mìn Maá na wi ho wáayi mún máa wé è sɛ́n mi bè-kora máa día. ");
INSERT INTO boxNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bṹn mɔ́n á ɓa wã́a ɲɔn ho Zeruzalɛɛmu. Bìo ó o Yeesu zoó wee varáka le *Dónbeenì zĩ-beenì lún yi, á ɓa yankarowà ɲúnása lè ho *làndá bìo zéenílowa lè ɓa nì-kĩ́a á wà ɓueé ɓó a yi ");
INSERT INTO boxNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","à ɓa tùara a yi: «Fo yú le níi wen wee wéráa bìo kà? Lée wée nɔn mu wéró níi foǹ?» ");
INSERT INTO boxNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ó o Yeesu bía nɔn ɓa yi: «Ĩnɛ́n mún ǹ tùa mia làa bìo dà-kéní. Ká mi tà á zéenía mu, á ĩ ɓɛ̀n mún ǹ zéení yìa nɔn mu bìowa mu ɓàn wéró níi miì làa mia. ");
INSERT INTO boxNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yìa nɔn le níi o Zãn yi le o wé bátízé ɓa nùpua lée wée? Lé le Dónbeenì lée, tàá lé ɓa nùpua? Mi bío lon!» ");
INSERT INTO boxNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Á ɓa yèrèmáa wee wã̀aní mín yi: «Ká wa le lé le Dónbeenì tonkaa wo, o ò bío le lée webio nɔn á wa yí tàráa o bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tàá ká wa ɓɛ̀n le lé ɓa nùpua tonkaa wo, á mu ù wé kaka?» Ɓa zã́na ɓa zã̀amáa lé bìo á bán ɓúenɓúen wee leéka le o Zãn hĩ́a lé le *Dónbeenì ɲi-cúa fɛɛro binbirì. ");
INSERT INTO boxNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Á ɓa wã́a bía nɔn o Yeesu yi: «Wa yí zũ yìa tonkaa wo.» Ó o Yeesu bía nɔn ɓa yi: «Àwa, á ĩnɛ́n mún máa zéení yìa nɔn le níi miì á ĩ wee wéráa bìo kà.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bṹn mɔ́n ó o Yeesu wã́a wee bío làa ba lè hã wàhio: «Nìi ɓúi hĩ́a léra ho èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó á son ho dándá kĩ́nía yi, á có ho kɔ̃hṹ na ó o wé è ɲaa ho èrézɛ̃́n yi. O mún son o paro lùe. Bṹn mɔ́n ó o wã̀anía tò lè ɓa nùpua ɓúi na à và ho, ò orɛ́n wà van le khúii. ");
INSERT INTO boxNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pã̀ahṹ na ho èrézɛ̃́n wee be yi, ó o tonkaa mí ton-sá nì-kéní le o va ɓa nùpua mu cɔ̃́n le ɓa khé bìo bìo sã̀ mí yi à na. ");
INSERT INTO boxNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Á ɓa nùpua mu vaá han wo á día ó o wà lè mí níi kã́amáa. ");
INSERT INTO boxNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ó o mɔhṹ ɓànso bĩnía tonkaa mí ton-sá veere. Á wón ɓa vaá vṹaana vṹaana ɲúhṹ, à ɓa là là a. ");
INSERT INTO boxNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ó o mɔhṹ ɓànso tĩ́n pá bĩnía tonkaa nì-veere. Á ɓa vaá ɓó wón. Lé kà síi ɓa wó lè ɓa ton-sáwá cɛ̀rɛ̀ɛ na ó o mɔhṹ ɓànso tonkaa. Ɓa ɓúi ɓa han, à ɓa ɓúi ɓa ɓó. ");
INSERT INTO boxNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","O mɔhṹ ɓànso za na ó o bò mí tàká wán lé yìa wã́a ká a cɔ̃́n. Á wón lé yìa ó o tonkaa, ò o wee leéka: Ĩ za wón ɓa à kɔ̃̀nbi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bìo ɓa nùpua mu yère dá a wán, á ɓa wee bío mín yi: ‹Yìa lua kà lé yìa á ho mɔhṹ bìo khíi sĩ̀ yi. Mi wa ɓúe o á ho mɔhṹ bìo wã́a à sĩ̀ wɛn.› ");
INSERT INTO boxNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","À ɓa hĩ́nɔn wìira a za mu ɓó, á lá lée lèera día lè ho soró mɔ́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ó o Yeesu wã́a tùara ɓa yi: «Lé mu yɛ́n á ho mɔhṹ ɓànso wã́a à wé? Ò o ò ɓuen ɓueé ɓúe ɓa nùpua mu, ká a cà nì-vio á à kúee mí mɔhṹ mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Le bíonì na kà á mi so dĩǹ yí kàránna le Dónbeenì bíonì vũahṹ yi yí mɔn le? ‹Le huee na ɓa so-sowa fù pã́ día lé dìo hĩ́a ɓueé ɓuan ho soró dĩ̀nía. ");
INSERT INTO boxNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bìo kà lé bìo ó o Ɲúhṹso Dónbeenì wó, mu lée bè-tente wa yèn-dã́ní yi.›» ");
INSERT INTO boxNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɓa *zúifùwa ɲúnása wee cà bìo ɓa a dĩ̀n wán á à wìiráa o Yeesu, lé bìo ɓa zũ le lé ɓarɛ́n á le wàhiire mu wà bò wán. Ɛ̀ɛ ká bìo ɓa zã́na ɓa zã̀amáa, á ɓa día wo à ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bṹn mɔ́n á ɓa tonkaa ɓa *Farizĩɛwa nùwã yɛn ɓúi là a *Heroode kuure nùpua nùwã yɛn ɓúi o Yeesu cɔ̃́n le ɓa ɓuee tùa wo yi, à yíráa o níi ɓua yi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Á ɓa ɓueé bía nɔn wo yi: «Nì-kàránlo, wa zũ le fo wee mì ho tũ̀iá. Fo yí máa zɔ̃́n nùpue. Fo mún yí máa kà nùpue yìo. Bìo le Dónbeenì le ɓa nùpua wé ɓua lè míten lé bṹn ɓàn kàránló binbirì á fo wee na. Àwa, á ũ bío na wɛn. Wa làndá yi á ho lànpó ko ho wé cã na ho Oroomu kɔ̃hṹ bɛ́ɛ yi lée, tàá mu yí ko làa wéró? Wa ko wa wé cã ho lée, tàá wa wé yí cã ho?» ");
INSERT INTO boxNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ó o Yeesu zũna le bìo ɓa lon binbirì á ɓa yí bía. Ó o wã́a bía nɔn ɓa yi: «Mi wi mi khũaa ĩ ɲii yi à yíráa ĩ níi ɓua yi le we? Mi cà le wɛ́n-hɔ̃nló ɓúi na miì le ĩ loń.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Á ɓa cà le ɓueé nɔn wo yi. Ó o Yeesu tùara ɓa yi: «Ho yahó lè le yèni na wi le wɛ́n-hɔ̃nló mu wán á wée te?» Á ɓa bía: «Lé ho Oroomu bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ó o Yeesu wã́a bía nɔn ɓa yi: «Àwa. Bìo sã̀ ho Oroomu bɛ́ɛ yi à mi na mu wo yi. Ká bìo ɓɛ̀n sã̀ le Dónbeenì yi à mi na mu le yi.» Á ɓa wó coon bìo ó o bía bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɓa *Sadusĩɛwa lé bìa le ɓa nì-hía máa vèe. Wizonle ɓúi, á ɓa ɓúi á ɓueé ɓó a Yeesu yi á tùara a yi kà: ");
INSERT INTO boxNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Nì-kàránlo, bìo ó o *Mɔyiize túara henía nɔn wɛn lé bìo kà: ‹Hen ká a ɓúi yan mín hã́a á húrun ò o yí yú za làa wo, á ɓàn za ko ò o fé ɓàn hã́a ya à te ɓa zàwa yi mín za mu yèni yi.› ");
INSERT INTO boxNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Àwa. Ka lòn nùpua nùwã hèɲun ɓúi yánkaa lée zàwa síi. Ó o yahón so yan mín hã́a á húrun ò o yí yú za làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ó o ɲun níi so fó a mahã́a mu yan á húrun ò o yí yú za làa wo. Lé bṹn ó o tĩn níi so bìo mún wóráa. ");
INSERT INTO boxNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɓa mí nùwã hèɲun yan wo bèenia á húrunka ò o ɓúi yí yú za làa wo. Mu ɓàn véeníi ó o hã́a mu mún húrun. ");
INSERT INTO boxNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Àwa. Nɔ̀nzoǹ na ɓa nì-hía á à vèe yi ó o hã́a mu bìo á à sĩ̀ a yɛ́n yi? Bìo ɓa mí nùwã hèɲun màhã́ yan wo bèenia.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ó o Yeesu bía nɔn ɓa yi: «Mi wee vĩ́iní miten. Ĩ bía bṹn lé bìo mi yí zũ le Dónbeenì bíonì vũahṹ bíoní kúará. Mi mún yí zũ le le Dónbeenì dà bìo ɓúenɓúen wee wé. ");
INSERT INTO boxNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mu bon. Ɓa nì-hía khíi vèera á ɓa báawa lè ɓa hã́awa máa bĩní máa ya mín. Ɓa à ɓonmín lè le Dónbeenì wáayi tonkarowà ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɓa nì-hía vèeró dã́ní yi á mi so dĩǹ yí kàránna ho lahó na wee bío le vĩ̀ndɛ̀-za na ho dɔ̃hṹ wi yi bìo o Mɔyiize vũahṹ yi yí mɔn le? Mu túara bĩ́n le le Dónbeenì bía nɔn o Mɔyiize yi: ‹Ĩnɛ́n lé o *Abarahaamu là a *Izaaki là a *Zakoobu ɓàn Dónbeenì.›» ");
INSERT INTO boxNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ó o Yeesu wã́a bía: «Le Dónbeenì lé bìa yìo wi lua ɓàn Dónbeenì ká le yínɔń nì-hía ɓàn Dónbeenì. Mi sòobáa wee vĩ́iní miten dà.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ho *làndá bìo zéenílo ɓúi ɲá ɓa wã̀aníi. Ó o mɔn ò o Yeesu bía se nɔn ɓa Sadusĩɛwa yi ó o vá ɓueé ɓó a yi ò o tùara a yi: «Le Dónbeenì làndáwá ɓúenɓúen tĩ́ahṹ á lé ho yɛ́n bìo here po hĩ̀a ká?» ");
INSERT INTO boxNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ó o Yeesu bía nɔn wo yi: «Le Dónbeenì làndáwá yi á hìa kà lé hìa bìo here po hĩ̀a ká: ‹*Isirayɛɛle nìpomu, ɲí bìo kà: Wa Ɲúhṹso Dónbeenì lé o Ɲúhṹso mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Fo ko à ũ wań ũ Ɲúhṹso Dónbeenì lè ũ sĩi ɓúenɓúen, lè ũ mànákã̀ ɓúenɓúen, lè ũ yilera ɓúenɓúen, lè ũ pànká ɓúenɓúen.› ");
INSERT INTO boxNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hìa sã̀ ho yi lé hìa kà: ‹Fo ko à ũ wań mí ninza làa bìo fo waráa ũten bìo síi.› *Làndáwá na kũn bìo here á po hã bìo ɲun na kà hɔ̃́n mía.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Á ho làndá bìo zéenílo wã́a bía nɔn o Yeesu yi: «Nì-kàránlo mu se, bìo fo bía lé ho tũ̀iá. O Ɲúhṹso lé le Dónbeenì mí dòn. Dónbeenì ɓúi kũn mía ká mu yínɔń lerɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","À wań le Dónbeenì lè ũ sĩi ɓúenɓúen, lè ũ yilera ɓúenɓúen lè ũ pànká ɓúenɓúen, à mún wań mi ninza lè ũten bìo síi, bṹn sṹaaní mu hãmu na ɓa wee wé na le Dónbeenì yi lè ɓa bà-kùio na ɓa wee ya lè le muinì na le Dónbeenì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ó o Yeesu mɔn ò o nìi mu bía ɓa bè-zũńlowà bíoní ó o bía nɔn wo yi: «Hen làa cĩ́inú ká fo ò kɛń le Dónbeenì bá-zàmu yi.» Bṹn mɔ́n ó o ɓúi wã́a yí bĩnía yí khà míten yí tùara a yi làa bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mu wó ká a Yeesu wee kàrán ɓa nùpua le *Dónbeenì zĩ-beenì yi, ó o tùara bìo kà: «Ho *làndá bìo zéenílowa dà a wé kaka a bíoráa le yìa le Dónbeenì mɔn léra lé o *Daviide mɔ̀nmàníi? ");
INSERT INTO boxNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lé bìo ó o *Daviide mí bɛɛre á le Dónbeenì Hácírí wó ó o bía bìo kà: ‹O Ɲúhṹso Dónbeenì bía nɔn ĩ Ɲúhṹso yi: Ɓuee kɛɛní ĩ nín-tĩánì fúaa ká ĩ ɓúrá ũ zúkúsa ũ tá á ũ bò ũ zení wán.› ");
INSERT INTO boxNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Bìo ó o *Daviide wee ve yìa le Dónbeenì mɔn léra le mí Ɲúhṹso. Ó o wé o Ɲúhṹso ká a mún pá à wé o mɔ̀nmàníi kaka?» Ɓa zã̀amáa wee ɲí a Yeesu cɔ̃́n lè le sĩ-wɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bìo ó o Yeesu wee kàrán ɓa zã̀amáa ó o wee bío na ɓa yi: «Mi yí wé lè ho *làndá bìo zéenílowa bìo. Bán na wa hã báká-beera zĩ́ló à wé hɛ́ɛkaráa. Ɓa wi ɓa nùpua wé tɛ̀ɛní ɓa yi lè le kɔ̃̀nbii ɓa zã̀amáa fèmínló lara yi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɓa *zúifùwa kàránló zĩní yahón kanmúiní lè ho dĩ́nló díiníi kɛɛnínía na seka á ɓa wé hueeka kɛɛní yi. ");
INSERT INTO boxNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɓa wee khà ɓa mahã́awa à fé níi bìo ɓúenɓúen. Ɓa mún wa ho fìoró na túee wéró à wé lè ɓa térénna. Ɓarɛ́n cítíi khíi wee here le Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","O Yeesu kará le *Dónbeenì zĩ-beenì hãmu ɓonkonì nìsã́ní á wee loń bìo ɓa zã̀amáa wee kúeeráa le wárí le yi. Ho nàfòró ɓànsowà cɛ̀rɛ̀ɛ wee ɓuee kúee le wárí na boo. ");
INSERT INTO boxNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mahã́-khenii ɓúi mún ɓueé kúaa mí tɔ̃mɔ́nwà bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ó o Yeesu wã́a von mí nì-kenínia á bía nɔn yi: «Le ĩ mì ho tũ̀iá na mia: O mahã́-khenii na kà bìo na ó o kúaa á boo po bìa ká ɓúenɓúen bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Lé bìo le wárí na ɓa ɓúenɓúen wó lè mu hãmu lé dìo ɓa yú puunía. Ò orɛ́n lè mí khemu, ò o pá kúaa bìo wi o cɔ̃́n ɓúenɓúen na ó o lá wé è dí.» ");
INSERT INTO boxNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bìo ó o Yeesu zoó ló le *Dónbeenì zĩ-beenì lún yi, ó o nì-kenínia nì-kéní bía nɔn wo yi: «Nì-kàránlo, hã huaa na kà ɓɛ̀ntĩ́n seka, á hã mún ɓùaaka. Hã soni dãamu yàá!» ");
INSERT INTO boxNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ó o Yeesu bía nɔn wo yi: «Fo mɔn hã dãamu lon? Ɛ̀ɛ ká huee khíi máa kɛń mí ninza huee wán. Mu ɓúenɓúen khíi fì.» ");
INSERT INTO boxNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bṹn mɔ́n ó o Yeesu yòó kará hã Oliivewa vĩ̀nsĩ̀a ɓúee wán á sánsáa le Dónbeenì zĩ-beenì. Ó o Piɛre là a Zaaki là a Zãn là a Ãndere na wi làa wo mí dòn á tùara a yi: ");
INSERT INTO boxNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Lé ho pã̀ahṹ yɛ́n á mu bìo mu ù wé yi? Á lé mu bìo yɛ́n khíi zéení le mu wéró pã̀ahṹ dɔ̃n?» ");
INSERT INTO boxNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ó o Yeesu wã́a bía nɔn ɓa yi: «Mi pa miten bìo. Mi yí día le nùpue khà mia. ");
INSERT INTO boxNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nùpua cɛ̀rɛ̀ɛ khíi ɓuen ĩ yèni yi á à bío: ‹Ĩ lé o Krista.› Ɓa à khà nùpua cɛ̀rɛ̀ɛ á à vĩ́iní. ");
INSERT INTO boxNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ká mi khíi wee ɲí hã hĩa táró sã, hĩ̀a lúio yi làa hĩ̀a khɛ̀ra làa mia à mi yí le mi yiwa dé, lé bìo á bṹn bìowa so ko mu wé ho yahó. Ká bṹn dɛ̀ɛnía máa wé ho dĩ́míɲá véró. ");
INSERT INTO boxNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ho sìí ɓúi khíi wé è lé vaá fi lè ho sìí veere. Á ho kɔ̃hṹ ɓúi khíi wé è lé vaá fi lè ho kã-veere. Ho tá dèkéró khíi wé hã lùa ɓúi yi. Á le hĩni khíi lé. Mu ù wé làa bìo o hã́-sãníso sãní vía wee wé ɓúakáráa bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ɛ̀ɛ ká minɛ́n pa miten bìo. Ɓa nùpua khíi wé è ɓua mia á à varáa ho pànká ɓànsowà cɔ̃́n á bán vaá cítí mia. Ɓa wé è ha mia ɓa *zúifùwa kàránló zĩní yi. Ɓa wé è ɓua mia á vaá dĩ̀ní hã kãna ɲúnása lè ɓa bá-zàwa yahó bìo mi tà miì bìo yi. Lé bṹn mi ì bè yi á à zéenínáa ĩ bìo làa ba. ");
INSERT INTO boxNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mu bon, sã́ni ho dĩ́míɲá vé, á le Dónbeenì bín-tente ko le bue à na hã sìíwà ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hen ká ɓa khíi wé wìikaa mia á ɓuan vannáa le cítíi yi à mi yí le mi yiwa fèn dè bìo mi vaá bío bìo yi. Hón pã̀ahṹ so yi á hã bíoní na à bío ò na mia lé hĩ̀a à mi bío. Lé bìo á hã máa lé minɛ́n mi bɛɛre yi. Mu lé le Dónbeenì Hácírí á à dé hã mi ɲiní yi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ɓa nùpua ɓúi wé è dé mín kùrú zàwa á à na ɓa à ɓúe. Hàrí ɓa maáwà ɓúi á à wé mu ɓàn síi lè mí zàwa. Ɓa zàwa ɓúi mún ǹ hĩ́ní mín maáwà wán, á à na ɓa ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓa nùpua ɓúenɓúen á à ɲin mia bìo mi tà miì bìo yi. Ká yìa màhã́ hã̀ mí sĩi fúaa mu véeníi, wón á à fen. ");
INSERT INTO boxNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Mi khíi mi mu bè-sũmúi na wee yáa mu bìo ká mu wi hen na mu yí ko mu kɛń yi. (Yìa wee kàrán bìo kà à zũń mu kúará sese.) Hón pã̀ahṹ so yi ká bìa wi ho Zudee yi à bán lùwí yòo hã ɓúaa. ");
INSERT INTO boxNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yìa á à kɛń mí zĩi lòho yí ko ò o lii zoo lá bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yìa á à kɛń hã mana yi mu pã̀ahṹ yí ko ò o bĩní ɓo à lii lá mí kánɓun mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ho yéréké khíi sá ɓa hã́-sɛ̃ɛnasa lè ɓa hã́-ɲàawa yi mu zoǹ. ");
INSERT INTO boxNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mi fìo le Dónbeenì yi à mu bìowa mu wéró yí lì hã yio yi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lé bìo ho pã̀ahṹ mu ɓàn lònbee á à wé ɓùaa á à poń dìo khĩína. Hàrí ho dĩ́míɲá ɲúhṹ ɓúaró pã̀ahṹ na le Dónbeenì léra mu bìo ɓúenɓúen yi à ɓuee ɓúe ho zuia yi, á le lònbee mu síi yí kɛra yí mɔn. Á le ɓàn síi mún máa bĩní máa kɛń hùúu. ");
INSERT INTO boxNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","O Ɲúhṹso lá yí khò le lònbee mu wizooní yi, á nìi woon lá máa kã̀ní. Ká a màhã́ khò hã yi ɓa nùpua na ó o hueekaa à ɓa wé làa wo bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ká a ɓúi bía nɔn mia kà síi: ‹Mi loń. Lé o *Krista na hen, tàá nín-yìa vaá hen›, à mi yí tà mu. ");
INSERT INTO boxNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mu bon, ɓa Kristawa lè le Dónbeenì ɲi-cúa fɛɛrowà na bìo yí bon khíi kɛń. Ɓa à wé mu yéréké bìowa lè mí sìíwà na ka lè mu wee zéení le Dónbeenì pànká á à vĩ́inínáa ɓa nùpua. Hàrí bìa le Dónbeenì hueekaa ká mu lá dà à wé, á ɓa mún ǹ vĩ́iní bán. ");
INSERT INTO boxNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Àwa. Á minɛ́n cén pa miten bìo. Ĩ fèra bía mu ɓúenɓúen nɔn mia vó. ");
INSERT INTO boxNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Le lònbee khĩíló mɔ́ndɛ́n á ‹le wii á à dé mí yuumu. Ho pĩihṹ khoomu máa bĩní máa kɛń. ");
INSERT INTO boxNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hã mànàayio á à kùenka à lii. Bìo ɓuan ho wáayi bìowa dĩ̀nía ɓúenɓúen á à dèké.› ");
INSERT INTO boxNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hón pã̀ahṹ so yi á ɓa à mi a Nùpue Za ɓuenló hã dùndúio wán lè mí dàńló lè mí cùkú beenì. ");
INSERT INTO boxNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O khíi tonka le Dónbeenì wáayi tonkarowà ho tá kónɓúaa bìo náa yi lè ho dĩ́míɲá ɓúenɓúen yi á ɓa a ve bìa le Dónbeenì hueekaa á à kúee mín wán. ");
INSERT INTO boxNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Mi loń ho *fíkíyée vĩ̀ndɛ̀ɛ bìo le wee wéráa. Hen ká le ɓàn lakara hĩ́a wee nàma á wee sà mí vɔ̃n-yórówà, se mi zũ le ho viohó tèró dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lé làa bṹn síi ká mi khíi wee mi mu bìowa mu wéró, à mi mún zũń le o *Nùpue Za ɓuenló sùaráa. O ò ɓuen máa khí. ");
INSERT INTO boxNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Le ĩ mì ho tũ̀iá na mia: Ho pã̀ahṹ na kà nùpua máa hí máa vé ká bṹn bìowa so ɓúenɓúen yí wó. ");
INSERT INTO boxNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ho wáayi lè ho tá khíi vé, ká ĩ bíoní hɔ̃́n ǹ kɛń bĩ́n fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nìi woon yí zũ ho dĩ́míɲá véró wizonle lè ho pã̀ahṹ máa zéení. Le Dónbeenì wáayi tonkarowà yí zũ mu, hàrí le Dónbeenì Za mí bɛɛre yàá pá yí zũ mu. O Maá mí dòn lé yìa zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","«Mi pa miten bìo. Mi yí wé lòn nùpua na dũma. Lé bìo mi yí zũ ho pã̀ahṹ na mu ù wé yi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mu bìo ɓonmín làa bìo kà: Nìi ɓúi le mí ì va le khúii. Ó o kàràfáa mí zĩi mí ton-sáwá yi, á sankaa hã tonni nɔn ɓa lè mí nì-kéní kéní yi. Bṹn mɔ́n ó o bía nɔn o paro yi le o tĩní mí yìo. ");
INSERT INTO boxNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Minɛ́n mún tĩní mí yìo, lé bìo mi yí zũ a zĩi ɓànso bĩní ɓuenló pã̀ahṹ. O dà à ɓuen zĩihṹ tàá tá tĩ́ahṹ, tàá kò-bá-wɛ́ɛ yi, tàá yìnbíi. ");
INSERT INTO boxNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ká a khíi dĩ̀ndĩ̀n ɓuara ò o yí ɓuee yí mia ká mi ka lòn nùpua na dũma. ");
INSERT INTO boxNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bìo á ĩ wee bío na mia kà, á yahó sã́ ɓa nùpua ɓúenɓúen. Mi yí wé lòn nùpua na dũma.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wizooní bìo ɲun wã́a ká ho Paaki sã́nú díró lè ho *búurú na á ɲa-fĩni yí dó yi sã́nú díró yi. Á le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa wee cà bìo ɓa à wé wé è wìiráa o Yeesu ká mu yí zũ, á à na ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɓa wee bío: «Wa yí dà máa wìi wo ho sã́nú díró yi. Ká wa wó mu á ɓa zã̀amáa á à kánká mu bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","O Yeesu kɛra ho Betanii lóhó yi o Simɔn na hĩ́a lé o *ɓùeré nìi zĩi. Pã̀ahṹ na ó o kará wee dí à bṹn à hã́a ɓúi ɓueé wee zo, á ɓuan mí dṹukó-za ɓúi na wó lè le huee na ɓa le alibaatere à ho sú làa ɲiló ɓúi na sãmu sĩ. Ho ɲiló mu ɓa le náàrè á yàwá here làa sòobɛ́ɛ. Bìo ó o ɓueé ɓó a Yeesu yi ó o pũ̀ina ho dṹukó-za mu ɲii, ò o kúaa ho ɲiló mu o Yeesu ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Á bìa wi bĩ́n ɓúi sĩa cã̀. Á ɓa wee bío mín yi: «Ho ɲiló na kà yáaró ɲúhṹ lé mu yɛ́n? ");
INSERT INTO boxNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ho ɲɔǹ lá dà à yɛ̀ɛ́ á à yí hã wɛ́n-hãani khĩá-tĩn á à sanka a na ɓa nì-khenia yi.» À ɓa lan wee zá làa wo. ");
INSERT INTO boxNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ó o Yeesu wã́a bía: «O hã́a mu mi día bìo. Mi wee zá làa wó le we? Bìo ó o wó làa mi á se. ");
INSERT INTO boxNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ɓa nì-khenia bán làa mia á à kɛń mín wán fɛ́ɛɛ. Á pã̀ahṹ lée pã̀ahṹ á mi dà wé è wé mu sãamu làa ba ká mi tà. Ɛ̀ɛ ká ĩnɛ́n wón máa kɛń làa mia fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bìo ó o dà à wé lé bìo ó o wó. O kúaa ho ɲiló na sãmu sĩ ĩ sãnía wán à fèn wíokaráa hã paráa hã nùuló. ");
INSERT INTO boxNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Le ĩ mì ho tũ̀iá na mia: Le Dónbeenì bín-tente wé buera lùe lée lùe yi ho dĩ́míɲá ɓúenɓúen yi, á ɓa à bío bìo ó o hã́a na kà wó, á ɓa à leéka a bìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","O Yeesu nì-kenínia pírú ɲun nì-kéní na ɓa le Zudaa Isikariote á wà vaá bía nɔn ɓa yankarowà ɲúnása yi le mí wi à mí dé o Yeesu na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Á bán sĩa wan wan á dó mí ɲiní nɔn le mí ì na le wárí wo yi. Ó o wã́a wee cà ho pã̀ahṹ na o ò dàń ǹ wé mu yi, á à déráa wo ɓa níní yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ho *búurú na á ɲa-fĩni yí dó yi sã́nú díró ɓàn nín-yání wizonle zoǹ, dìo ɓa wee wé fũ̀aa ho Paaki piozàwa yi, ó o Yeesu nì-kenínia tùara a yi: «Lé wen á fo wi à wa vaa wíoka ho Paaki dĩ́nló yi?» ");
INSERT INTO boxNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ó o tonkaa mí nì-kenínia nùwã ɲun á bía nɔn yi: «Mi lɛ́n zo ho lóhó yi, á mi zoó sĩ́ a nìi ɓúi yahó ká a sò mu ɲumu lè ho dṹuhṹ. Mi bè o yi, ");
INSERT INTO boxNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ká a vaá zon zĩi na yi à mi bío na le zĩi mu ɓànso yi: O nì-kàránlo le wa tùa foǹ: Ho lahó na á ĩnɛ́n lè ĩ nì-kenínia á à dí ho Paaki dĩ́nló yi lé ho yɛ́n? ");
INSERT INTO boxNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","O ò zéení la-beenì ɓúi làa mia ho nɔ́nwíohṹ yi na sĩ̀a bàráka vó. Lé bĩ́n à mi wíoka wa Paaki dĩ́nló bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Á ɓa wà vaá zon ho lóhó yi, á zoó yú mu ɓúenɓúen làa bìo ó o Yeesu bíaráa mu. Á ɓa wíokaa ho Paaki dĩ́nló bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bìo le wii tò, ó o Yeesu lè mí nì-kenínia pírú ɲun ɓuara. ");
INSERT INTO boxNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bìo ɓa kará wee dí ó o Yeesu bía: «Le ĩ mì ho tũ̀iá na mia: Minɛ́n na làa mi páanía kará ho dĩ́nló ɲúhṹ yi nì-kéní á à dé mi ì na.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ó o nì-kenínia yilera lùnkaa, á ɓa wee tùaka a yi lè mí nì-kéní kéní. À yìa le: «Mu lé ĩnɛ́n le?» À yìa le: «Mu lé ĩnɛ́n lé?» ");
INSERT INTO boxNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ó o Yeesu bía nɔn ɓa yi: «Mu lé minɛ́n pírú ɲun nì-kéní, yìa làa mi páanía wà zoó cĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mu bon. O *Nùpue Za á à hí làa bìo le Dónbeenì bíonì vũahṹ bíaráa mu. Ká yìa màhã́ níi ì bè mu á ho yéréké è zo ɲúhṹ. Ɓànso yàá lá yí ton se mu sṹaaní.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bìo ɓa wee dí, ó o Yeesu lá ho búurú á dó le Dónbeenì bárákà. Ò o wee cɛ̀ɛka ho na mí nì-kenínia yi ká à bío: «Mi fé là, hón lé ĩ sãnía.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ò o bĩnía lá le ɲuuníi dɛ̀ɛ na ho *dìvɛ̃́n wi yi ò o dó le Dónbeenì bárákà. Ò o nɔn ho ɓa yi á ɓa ɓúenɓúen ɲun. ");
INSERT INTO boxNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ò o bía nɔn ɓa yi: «Dén lé ĩ cãni na wíokaa wee zéení le Dónbeenì páaníi na le bò bìo, dén lé ĩ cãni na kúaará ɓa nùpua cɛ̀rɛ̀ɛ bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Le ĩ mì ho tũ̀iá na mia: Ĩ máa bĩní máa ɲu dìvɛ̃́n hùúu fúaa ho pã̀ahṹ na á ĩ khíi ɲu ho ɓàn bè-fĩa yi le Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bṹn mɔ́n á ɓa sía ho sã́nú lení, à ɓa wà yòora hã Oliivewa vĩ̀nsĩ̀a ɓúee wán. ");
INSERT INTO boxNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","O Yeesu bía nɔn mí nì-kenínia yi: «Mi ɓúenɓúen á à lùwí ì día mi. Làa bìo le Dónbeenì bíoráa mu mí bíonì vũahṹ yi kà síi: ‹Ĩ ì ɓúe o pi-pa á ɓa pia á à kɛ́nná à lɛ́n ǹ va hã lùa ɓúenɓúen.› ");
INSERT INTO boxNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ɛ̀ɛ ká ĩ vèeró mɔ́n, á ĩ ì dí mí yahó vaá pa mia ho Kalilee kɔ̃hṹ yi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ó o Piɛre bía: «Hàrí à bìa ká ɓúenɓúen pĩ́ ũ bìo, á ĩnɛ́n wón máa pĩ́ mu hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ó o Yeesu bía nɔn wo yi: «Le ĩ mì ho tũ̀iá na foǹ. Ho tĩ́nɔ̀n-kéní na kà yi, sã́ni ò o kò-bɛ́ɛ wá hã cúa-ɲun, bṹn ká ũnɛ́n bía le fo yí zũ mi á dɔ̃n hã cúa-tĩn.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ó o Piɛre pá bĩnía wíokaa tĩ̀ína mí bíonì yi: «Ĩ máa bío le ĩ yí zũ fo máa mi hùúu, hàrí ká ĩ ko à ĩ hí làa fo.» Á ɓa nì-kenínia na ká ɓúenɓúen bía mu bìo dà-kéní mu. ");
INSERT INTO boxNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bṹn mɔ́n á ɓa wà vaá dɔ̃n le lùe ɓúi na ɓa le Zɛtesemanii. Ó o Yeesu bía nɔn mí nì-kenínia yi: «Mi kɛɛní hen le ĩ lɛ́n vaa fìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ò o fó a Piɛre là a Zaaki là a Zãn á bòráa. O ɓúakáa zã́na á yi wee dè ");
INSERT INTO boxNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ó o bía nɔn ɓa yi: «Ĩ hácírí yáara dàkhĩína. Ĩ ka le ĩ máa fen. Mi kɛɛní hen, á tĩní mi yìo.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bṹn mɔ́n ó o wã́a vá van cĩ́inú, á vaá lií ɓúrá ò o fìora le ká mu dà à wé, à le lònbee na kà à yí yí mí. ");
INSERT INTO boxNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O bía bìo kà: «Ĩ Maá, fo dà bìo ɓúenɓúen wee wé. Yí le le lònbee na kà à yí mi. Ɛ̀ɛ ká mu yí wé ĩnɛ́n sĩi bìo. Le ũnɛ́n lé yìa sĩi bìo à wé.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ò o bĩnía ɓuara mí nì-kenínia cɔ̃́n á ɓueé yú ɓa à mu dãmu ɓó ɓa. Ó o bía nɔn o Piɛre yi: «Simɔn, dãmu ɓó fo le? Fo yí dà máa tĩní ũ yìo hàrí le lɛ́ɛ̀rè dà-kéní yi le? ");
INSERT INTO boxNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mi fání mi yìo à wé fìo bèra a na à mi yí zo mu bè-kora wéró yi. O nùpue sĩi wee wé vá mu bè-tente wéró yi, ɛ̀ɛ ká ho pànká na ó o ò wé làa bṹn lé hìa mía.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ò o tĩ́n wíokaa khɛ̀ra vaá fìora ò o bía hã bíoní dà-kéní mu. ");
INSERT INTO boxNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bṹn mɔ́n ó o bĩnía ɓuara mí nì-kenínia cɔ̃́n á ɓueé yú ɓa à mu dãmu ɓó ɓa. Ɓa yí dàńna yí fánía mí yìo. Á bìo ɓa wã́a à bío á à na a Yeesu yi á ɓa yí zũ. ");
INSERT INTO boxNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bìo ó o Yeesu wà á bĩnía ɓuara mún cúa-tĩn níi yi, ó o ɓueé bía nɔn ɓa yi: «Mi pá dũma wee vũńka lon? Mu wã́a vó. Ho pã̀ahṹ dɔ̃n. O *Nùpue Za á ɓa à dé ɓa bè-kora wérowà níi yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mi hĩ́ní wa lɛ́n. Yìa á à dé mi ì na ɓueé dɔ̃n.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pã̀ahṹ na ó o Yeesu wee bío yi, à bṹn ò o Zudaa ɓueé dɔ̃n. O lé ɓa nì-kenínia pírú ɲun nì-kéní. Ɓa zã̀amáa na bò làa wo á ɓuan hã khà-túa lè hã bũ̀aa. Bìa tonkaa ɓa lé le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa lè ɓa nì-kĩ́a. ");
INSERT INTO boxNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","O Zudaa, yìa á à dé o Yeesu mu á à na, á zéenía bìo ɓa zã̀amáa á à zũńnáa wo. O bía: «Ĩ hĩ́a vaá tɛ̀ɛnía nùpue na yi lè le kɔ̃̀nbii, se wón lé yìa mi wee cà. À mi wã́a wìi wo à ɓua sese lɛ́nnáa.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","O Zudaa ɓuee dɛ̃ɛníi ó o wà vaá ɓó a Yeesu yi ò o bía nɔn wo yi: «Nì-kàránlo.» Ò o tɛ̀ɛnía wo yi lè le kɔ̃̀nbii. ");
INSERT INTO boxNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Á bìa làa wo bò mín wã́a wìira a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Á ɓa nì-kéní ɓúi dò mí khà-tóní á hà lè le *Dónbeenì yankarowà ɲúhṹso beenì ton-sá nì-kéní ɲikãahṹ kúio. ");
INSERT INTO boxNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ó o Yeesu bía nɔn bìa wà ɓueé wìi wo yi: «Mi so lá ko à mi ɓua khà-túa làa bũ̀aa à ɓuee wìiráa mi le? Ĩ lée nì-kã́anii le? ");
INSERT INTO boxNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ĩ làa mia lá wee kɛń mín wán túntún, á wee kàrán ɓa nùpua le *Dónbeenì zĩ-beenì lún yi á mi yí wìira mi. Ɛ̀ɛ ká mu wó kà, à le Dónbeenì bíonì vũahṹ bìo ɲii síráa.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ó o nì-kenínia ɓúenɓúen wã́a lùwa wà à ɓa día a. ");
INSERT INTO boxNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yàrónza ɓúi lé yìa bò a Yeesu yi. Lée ɓunló mí dòn wi o wán. Ɓa le mí ì wìi wo, á ɓa ɓuan o ɓunló yi, ");
INSERT INTO boxNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ó o kueera ho día, ò o lùwa wà mí kã́amáa. ");
INSERT INTO boxNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bṹn mɔ́n á ɓa ɓuan o Yeesu vannáa le *Dónbeenì yankarowà ɲúhṹso zĩi, hen na ɓa yankarowà ɲúnása lè ɓa nì-kĩ́a lè ho *làndá bìo zéenílowa ɓúenɓúen kúaa mín wán yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","O Piɛre khɛ̀ra bò a Yeesu mɔ́n. O ɓueé zon ɓa yankarowà ɲúhṹso lún yi, á zoó páanía kará lè ɓa parowà á wee huee ho dɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɓa yankarowà ɲúnása lè ɓa *zúifùwa tũ̀iá fɛɛrowà ɓúenɓúen wee cà bìo ɓa à koonínáa o Yeesu yi á à bè yi ì síinínáa o ɲúhṹ á à na ɓa à ɓúe. Ká ɓa màhã́ yí yú bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nùpua cɛ̀rɛ̀ɛ wee ɓuee fũ̀aa hã sabíoní o ɲii, ká ɓa màhã́ wee bĩní kán mín. ");
INSERT INTO boxNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Á ɓa nùwã yɛ́n ɓúi wã́a hĩ́nɔn koonía o yi lè le sabéré na kà: ");
INSERT INTO boxNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Wa ɲá ò o bía le mí ì fío le Dónbeenì zĩi na ɓa nùpua son, á à bĩní ì so le ɓúi hã wizooní tĩn yi ká dén á nùpua máa so.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hàrí bṹn á ɓa yàá pá wee kán mín wán. ");
INSERT INTO boxNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Á ɓa yankarowà ɲúhṹso wã́a lii hĩ́nɔn yòó dĩ̀n ɓa ɓúenɓúen yahó ò o tùara a Yeesu yi: «Bìo ɓa nùpua wee bío ũ dã́ní yi á fo le fo máa bío dɛ̀ɛ ɓúi yi le?» ");
INSERT INTO boxNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ó o Yeesu cɛ̀kɛ̀ ò o dĩ̀n. Á ɓa yankarowà ɲúhṹso wíokaa tùara a yi: «Le ũnɛ́n lé o Krista, le Dónbeenì na wa wee khòoní za le?» ");
INSERT INTO boxNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ó o Yeesu bía: «Ũuu, ĩ lé orɛ́n. Mi ɓúenɓúen á à mi a *Nùpue Za ká a kará le Dónbeenì na dà mu bìo ɓúenɓúen nín-tĩánì. Mi mún khíi mi a ká a kará hã dùndúio wán bò ò ɓuen.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Á ɓa yankarowà ɲúhṹso wã́a lɛ̀ɛkaa mí dà-zĩ́nii lé bìo mu vá a yi dàkhĩína, ò o bía: «Wa màkóo wã́a mía sɛɛ́ràsa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hã bín-kora na ò o mà lɛɛ́ra le Dónbeenì yi á mi ɲá. Àwa, á lé mu yɛ́n á mi wee leéka?» Á ɓa ɓúenɓúen le o wó khon ó o ko ò o ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɓa nùwã yɛn zàwa ɓúi ɓa tĩ́ahṹ á ɓúakáa wee khàani kúee o Yeesu wán. Ɓa pon o yahó yi à ɓa wee vṹaa wo lè mí nín-kuio ká ɓa à tùa wo yi le o zéení yìa wó mu làa wo. Le *Dónbeenì yankarowà ɲúhṹso lún parowà fó a, á wee dé sáarà yi. ");
INSERT INTO boxNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pã̀ahṹ na ó o Piɛre pá lií wi ho lún yi, à bṹn le Dónbeenì yankarowà ɲúhṹso beenì ton-sá hã́awa nì-kéní ɓúi ɓueé dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bìo ó o mɔn o Piɛre ò o wee huee ho dɔ̃hṹ, ó o wíokaa lońna a yi sese ò o bía: «Ũnɛ́n mún lá wi là a Nazarɛɛte nìi Yeesu mu.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ó o Piɛre pã́ mu ò o bía: «Bìo á fo wee bío kà á ĩ yí zũ.» Bṹn mɔ́n ó o wà vaá bã́nía dĩ̀n ho lún zũaɲii. Ó o kò-bɛ́ɛ wá. ");
INSERT INTO boxNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bìo ó o ton-sá hã́a mu mɔn o vaa bã́níló, ó o wee bío làa bìa wi bĩ́n: «O nùpue na kà lé ɓarɛ́n nì-kéní ɓúi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ó o Piɛre tĩ́n pã́. Mu yàá yí míana, à bṹn à bía wi bĩ́n tĩ́n bía nɔn o Piɛre mu yi: «Ho tũ̀iá poni. Fo lé ɓarɛ́n ɓúi. Ũnɛ́n mún lé o Kalilee nìi.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ó o Piɛre wã́a bía: «Ká ĩ fã̀ sabéré à le Dónbeenì le ĩ mi mu. Ĩ ì báa mu ɲii wán, o nùpue na mi wee bío bìo á ĩ yí zũ.» ");
INSERT INTO boxNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hón pã̀ahṹ so yi ó o kò-bɛ́ɛ wá hã cúa-ɲun níi. Ó o Piɛre hácírí màhã́ bĩnía ɓuara bìo ó o Yeesu fù bía làa wo yi wán: «Sã́ni ò o kò-bɛ́ɛ wá hã cúa-ɲun bṹn ká ũnɛ́n pã́ le fo yí zũ mi á dɔ̃n hã cúa-tĩn.» Ó o Piɛre wã́a wee wá. ");
INSERT INTO boxNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Le yìnbíi bùirìi á ɓa *yankarowà ɲúnása, lè ɓa nì-kĩ́a, lè ho *làndá bìo zéenílowa, bán ɓúenɓúen na lè ɓa *zúifùwa tũ̀iá fɛɛrowà á kúaa mín wán, bèra a na à ɓa bío tè bìo dà-kéní wán. Ɓa can o Yeesu, á ɓuan ɓueé nɔn o *Pilaate yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ó o Pilaate tùara a yi: «Lé ũnɛ́n lé ɓa zúifùwa bɛ́ɛ le?» Ó o Yeesu bía nɔn wo yi: «Fo bía mu.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɓa yankarowà ɲúnása wee kooní a Yeesu yi làa bìo cɛ̀rɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ó o Pilaate wíokaa tùara a yi: «Fo le fo máa bío dɛ̀ɛ le? Bìo ɓa wee bío ũ ɲii á fo yí máa ɲí le?» ");
INSERT INTO boxNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ká a Yeesu màhã́ yí bĩnía yí bía dɛ̀ɛ. Bṹn wó a Pilaate coon. ");
INSERT INTO boxNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hen ká ho *Paaki sã́nú sansan dɔ̃n, ò o Pilaate lén o kàsó nìi ɓúi día, yìa ɓa zã̀amáa le o día. ");
INSERT INTO boxNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mu ù wé à nìi ɓúi na ɓa le Barabaasi páanía wi ho kàsó yi lè ɓa ɓúi na làa wo kã́a á ɓó a nìi ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Á ɓa zã̀amáa wã́a wà van o Pilaate cɔ̃́n á vaá wee fìo wo ò o wé bìo ó o lá wee wé na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ó o Pilaate bía nɔn ɓa yi: «Mi wi à ɓa zúifùwa bɛ́ɛ lé yìa à ĩ día le?» ");
INSERT INTO boxNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","O Pilaate zũ kɛ̃́nkɛ̃́n le ɓa yankarowà ɲúnása dó a Yeesu nɔn mí yi lé bìo le yandee wi ɓa yi o bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ká ɓa yankarowà ɲúnása màhã́ súkúra ɓa zã̀amáa le ɓa fìo o Pilaate cɔ̃́n le o Barabaasi lé yìa ò o día. ");
INSERT INTO boxNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ó o Pilaate wíokaa tùara ɓa zã̀amáa yi: «Lé mu yɛ́n mi le ĩ wé làa yìa mi wee ve làa zúifùwa bɛ́ɛ?» ");
INSERT INTO boxNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Á ɓa wee bío na a yi ká ɓa a wãamaka: «Ɓúɛɛ wo ho *kùrùwá wán ò o hí.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ó o Pilaate tùara ɓa yi: «O wékhe lé ho yɛ́n?» Á ɓa yàá wíokaa wee wãamaka pɔ̃́npɔ̃́n: «Ɓúɛɛ wo ho kùrùwá wán ò o hí.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","O Pilaate wi ò o wɛɛ́ ɓa zã̀amáa sĩi, ó o léra o Barabaasi día, ò o le ɓa ha a Yeesu lè hã làbàaní, ò o nɔn wo le ɓa ɓúɛɛ ho kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Á ɓa dásíwá ɓuan wo zonnáa ho *Zudee kɔ̃hṹ bɛ́ɛ lún yi, à ɓa von mí ninzàwa na ká ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓa zĩ́inía o Yeesu lè le dà-muhṹ, á tã́ ho kìrí lè hã kíkara á dó a ɲúhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bṹn mɔ́n á ɓa wee tɛ̀ɛní a yi kà: «*Zúifùwa bɛ́ɛ, foó!» ");
INSERT INTO boxNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɓa wee vṹaa o ɲúhṹ lè le kã́anì, á wee khàani kúee o wán ká ɓa à fárá mí nɔnkóɲúná wán à lii ɓúrá a yahó. ");
INSERT INTO boxNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bìo ɓa zùańkaa wo yi vó, á ɓa tɛra le dà-muhṹ o wán, à ɓa zĩ́inía wo là a kùrú sĩ̀a. Bṹn mɔ́n á ɓa ɓuan wo lóráa ho donkĩ́ahṹ á wà lée ɓúɛɛ ho *kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","O Sirɛɛna nìi Simɔn na lé o Alɛkisãndere là a Urufuusi ɓàn maá, á ló hã mana yi bò ho wɔ̃hṹ ɓueé wee khĩí, á ɓa dásíwá ɓueé kĩ̀kã́a yi le o fé o Yeesu kùrùwá pĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓa ɓuan o Yeesu vannáa lahó ɓúi na ɓa le Kolokota yi, bṹn kúará le «ɲún-ɓòkuee lahó.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓa lùnkaa ho *dìvɛ̃́n lè mu bìo ɓúi na ɓa le míìrè á wi ɓa na a Yeesu yi ò o ɲu, ká a màhã́ yí ɲun mu. ");
INSERT INTO boxNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bṹn mɔ́n á ɓa ɓúaa wo ho kùrùwá wán. Ɓa le mí ì sanka a sĩ̀-zĩ́nia á ɓa wó le ɲún-sĩni bìo à zũńnáa dìo á à sĩ̀ yìa làa yìa yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Le wi-bee pã̀ahṹ lé bìo ɓa ɓúaa wo yi ho *kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bìo ɓa túara le dɛ̀ɛ wán, bìo wee zéení bìo nɔn ɓa ɓúaaráa wo lé bìo kà: «Zúifùwa bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓa mún ɓúaa ɓa nì-wànna nùwã ɲun ɓúi là a Yeesu. O nì-kéní wi là a nín-tĩánì ká a nì-kéní wi là a nín-káahó. ");
INSERT INTO boxNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bṹn wó à le Dónbeenì bíonì vũahṹ bíoní na kà a ɲii sí: «Ɓa mà a dó ɓa nì-kora tĩ́ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓa nùpua na wee khĩí làa bĩ́n wee kìɓón mí ɲúná ká ɓa a là a. Ɓa wee bío: «Fo yí mɔn mu le. Ũnɛ́n na lá le fo ò fío le *Dónbeenì zĩ-beenì á à bĩní ì so le ɓàn dà-veere hã wizooní bìo tĩn yi, ");
INSERT INTO boxNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wã́a fení ũten. Lii ho *kùrùwá wán le wa loń.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Le *Dónbeenì yankarowà ɲúnása lè ho *làndá bìo zéenílowa mún wee yáa mí ɲiní yi na a yi ká ɓa a bío làa mín: «O fenía ɓa ɓúi ò orɛ́n màhã́ yí dà máa fení míten. ");
INSERT INTO boxNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Le o Krista, o *Isirayɛɛle bɛ́ɛ, à lé ho kùrùwá wán lii. Ká wa mɔn mu á wa à dé wa sĩa wo yi.» Bìa páanía ɓúaa hã kùrùwáwá wán là a Yeesu bán mún wee là a. ");
INSERT INTO boxNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Le wii yòo fáráló pã̀ahṹ á ho kɔ̃hṹ ɓúenɓúen dĩ̀ndĩ̀n wó le tíbírí. Mu míana fúuu fúaa le wi-háarè. ");
INSERT INTO boxNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Le wi-háarè mu pã̀ahṹ, ó o Yeesu bía bìo kà pɔ̃́npɔ̃́n: «Eloyii, Eloyii, lama sabatanii?» Bṹn kúará le «Wàn Dónbeenì, wàn Dónbeenì, fo pã́ mi día le we?» ");
INSERT INTO boxNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Á bìa wi bĩ́n nùwã yɛn ɓúi ɲá mu á ɓa bía: «Mi loń, o wee ve o *Elii.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Á ɓa nì-kéní ɓúi lùwa vaá lá le dɛ̀ɛ ɓúi na wee kũ̀iní mu ɲumu á zìíra mu bè-ɲia yi á can le ɓùaahiire ɲii yi á yòó dá a Yeesu yi le o yɛ̀ɛ, ò o bía: «Mi dĩ̀n, wa à loń ká a Elii ɓueé liiní a ho *kùrùwá wán.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lé bṹn pã̀ahṹ ó o Yeesu wãamaa yi pɔ̃́npɔ̃́n, ò o húrun. ");
INSERT INTO boxNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Á ho pɔ̃nsò-beenì na zoó céra le *Dónbeenì zĩ-beenì á yòó lɛ̀ɛra mí tĩ́ahṹ lií ló. ");
INSERT INTO boxNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ho Oroomu dásíwá ɲúhṹso na dĩ̀n o Yeesu yahó á mɔn bìo ó o húrunnáa ó o bía: «O nùpue na kà ɓɛ̀ntĩ́n lá lé le Dónbeenì Za binbirì.» ");
INSERT INTO boxNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hã́awa nùwã yɛn ɓúi mún hĩ́a wi bĩ́n á khɛ̀ra dĩ̀n wee loń. Ɓa hã́awa mu tĩ́ahṹ ó o Mari wi yi, yìa wee lé ho Makadala lóhó yi. À séení a Mari na lé o Zaaki háyónza là a Zozee ɓàn nu, là a Salomɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓa hĩ́a wee bè o Yeesu yi ká a wi ho Kalilee yi á wee séení a. Hã́awa cɛ̀rɛ̀ɛ ɓúi mún hĩ́a wi ɓa hã́awa mu tĩ́ahṹ á bò là a Yeesu ɓuara ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","O Yeesu hí-nɔ̀nzoǹ ho zĩihṹ ɲii, à bìo á lé bṹn zoǹ á ɓa wee wíoka míten ho *Sabaa bìo yi, ");
INSERT INTO boxNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ó o Zozɛɛfu na wee lé ho Arimatee lóhó yi á ɓuara. O fù lé ɓa *zúifùwa tũ̀iá fɛɛrowà nì-kéní na ɓa ninzàwa wee kɔ̃̀nbi. Wón mún lá wee lòoní le Dónbeenì bɛ́ɛnì láró pã̀ahṹ. O henía mí sĩi ò o van o *Pilaate cɔ̃́n á vaá fìora a Yeesu nì-hínmu. ");
INSERT INTO boxNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ká a Pilaate ɲá bìo ó o Yeesu dɛ̀ɛnía húrun ó o wó coon mu bìo yi. Ó o von ɓa dásíwá ɲúhṹso á ɓueé tùara yi le o Yeesu mu húrun míana le. ");
INSERT INTO boxNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Á bìo ó o ɲá mu ɓa dásíwá ɲúhṹso cɔ̃́n vó, ó o nɔn le ɲii o Zozɛɛfu yi le o lá a sãnía. ");
INSERT INTO boxNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ó o Zozɛɛfu yà ho ɓun-senì dà-poni ò o liinía o Yeesu ho *kùrùwá wán á lií bá lè ho ɓunló ɓuan vaá dó le búure yi, dìo ɓa lá có ho ɓúaahó yi día. Bṹn mɔ́n ó o bĩ̀inía le hue-beenì pon le búure mu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","O Makadala Mari là a Zozee ɓàn nu Mari á dĩ̀n mɔn hen na ó o dó a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bìo ho *Sabaa khĩína, ó o Makadala Mari là a Zaaki ɓàn nu Mari là a Salomɛɛ á yà ho ɲiló na sãmu sĩ le mí vaá khìi làa Yeesu sãnía. ");
INSERT INTO boxNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ho dimaasi zoǹ yìnbíi bùirìi, le wii hàró pã̀ahṹ, á ɓa hĩ́nɔn wà ɲɔn le búure. ");
INSERT INTO boxNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓa wee bío mín yi: «Lé wée yàá vaá bĩ̀iní le hue-beenì na pon le búure ɲii á à na wɛn coon?» ");
INSERT INTO boxNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ká bìo ɓa vaá dɔ̃n, á ɓa le mí ì loń, à le hue-be-beenì bĩ̀inía ló le búure ɲii á khíi día le nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Á ɓa wà vaá zon le yi, á zoó mɔn yàrónza ɓúi ò o kará lè le nín-tĩánì, á zã́ ho báká poni na túee. Á ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ká a yàrónza mu màhã́ bía nɔn ɓa yi: «Mi yí zɔ̃́n. Ĩ zũ le lé o Nazarɛɛte nìi Yeesu na ɓa ɓúaa ho *kùrùwá wán á mi wee cà. O mía hen, o vèera. Mi loń. Lé ho lahó na kà á ɓa lá bàrá a yi. ");
INSERT INTO boxNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mi lɛ́n vaa bío mu na a Piɛre là a Yeesu mu nì-kenínia na ká yi le o dú ɓa yahó van ho Kalilee kɔ̃hṹ. Lé bĩ́n ɓa vaá mi a yi làa bìo ó o bíaráa mu.» ");
INSERT INTO boxNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Á ɓa yilera lùnkaa, á ɓa wee zà. Á ɓa ló á lée lùwa wà. Ɓa yí bía dɛ̀ɛ yí nɔn nùpue yi lé bìo ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","O Yeesu vèeró mɔ́n ho dimaasi zoǹ yìnbíi á mu nín-yání, ó o zéenía míten là a Makadala Mari, wón na ó o hĩ́a ɲɔn ɓa cĩ́náwa bùaa hèɲun léra yi. ");
INSERT INTO boxNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ó o Mari wà van bìa là a Yeesu lá páanía wi cɔ̃́n, á vaá yú ɓa à ɓa yara sò á wee wá, ó o bía làa ba le mí mɔn o Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ká bìo ɓa ɲá bìo ó o Mari bía le o Yeesu vèera, ó o mún mɔn wo, á ɓa yí tà mu. ");
INSERT INTO boxNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bṹn mɔ́n ó o Yeesu zéenía míten làa sìí veere lè mí nì-kenínia nùwã ɲun ká ɓa ɲɔn hã mana. ");
INSERT INTO boxNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Á ɓa bĩnía ɓueé bía mu lè ɓa nì-kenínia na ká á bán mún yí tà mu yi. ");
INSERT INTO boxNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mu ɓàn mɔ́n, ó o Yeesu zéenía míten lè ɓa nì-kenínia pírú dòn ká ɓa wee dí. O zá làa ba bìo ɓa yí dó mí sĩa wo yi, làa bìo ɓa tun mí yiwa á yí tà bìa bía le mí mɔn wo ò o vèera bìo. ");
INSERT INTO boxNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ó o wã́a bía nɔn ɓa yi: «Mi lɛ́n va ho dĩ́míɲá lùa ɓúenɓúen yi à vaa bue le Dónbeenì bín-tente na ɓa nùpua ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yìa á à dé mí sĩi le yi, á ɓa à bátízé, wón á à fen. Ká yìa yí dó mí sĩi le yi, wón ɲúhṹ á à sí. ");
INSERT INTO boxNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bìa dó mí sĩa le yi wé è wé mu yéréké bìowa na wee zéení le Dónbeenì pànká: Ɓa à ɲa ɓa cĩ́náwa á à lén bìa ɓa wi yi lè ĩ yèni; ɓa a bío hã sìí-viò bíoní; ");
INSERT INTO boxNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yìa wé ɓuan háa yi, tàá ká a ɲun bè-ɲunii ɓúi na dà a ɓúe nùpue, á dɛ̀ɛ woon máa wé ɓànso; ɓa à bè mí níní ɓa vánvárowà wán á bán á à wa.» ");
INSERT INTO boxNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bìo ó o bía bṹn vó, ó o Ɲúhṹso Yeesu ɓuan yòora ho wáayi á yòó kará le Dónbeenì nín-tĩánì. ");
INSERT INTO boxNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Á ɓa nì-kenínia wà vaá wee bue le bín-tente hã lùa ɓúenɓúen yi. O Ɲúhṹso wee séení ɓa, á ɓa wee wé mu yéréké bìowa na wee zéení le Dónbeenì pànká à zéení le bìo ɓa wee bío á lée tũ̀iá poni.");
INSERT INTO boxNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Tiofiile, bìo wó khĩína wa cɔ̃́n lè mí dà-kéní kéní ɓúenɓúen le Dónbeenì dã́ní yi à lá mu ɲúhṹ ɓúɛɛníi á ɓa ɓúi mɔn á lé mu sɛɛ́ràsa, bán lé bìa wó le Dónbeenì bín-buerowà na zéenía mu làa wɛn. Ɓa cɛ̀rɛ̀ɛ wi à ɓa kúeeka mu mín wán à túa hã vɔ̃nna yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Á bìo á ĩnɛ́n mún wi á ĩ túa mu lè ɓa bìo síi, á ĩ tùakaa mu cinciíra bìa mɔn mu lè mí nì-kéní kéní cɔ̃́n á zũńnanáa mu ya-tente. Á bìo mu sã̀maanáa lé bṹn á ĩ wi à ĩ túaráa mu à na ũnɛ́n Tiofiile cùkúso yi, ");
INSERT INTO boxNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","bṹn lé bìo o na á fo ò zũń kɛ̃́nkɛ̃́n ká bìo á ɓa fù kàránna làa fo ɓúenɓúen lé ho tũ̀iá poni. ");
INSERT INTO boxNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ho Zudee kɔ̃hṹ bɛ́ɛ *Heroode pã̀ahṹ, á le Dónbeenì yankaro ɓúi fù wi bĩ́n á yèni ɓa le Zakari. O lé o Abia kuure nùpue ɓúi. Ɓàn hã́a yèni ɓa le Elizabɛɛti. Wón fù lé le *Dónbeenì yankarowà ɲúhṹso *Aaron nɔnkãni hĩ́nló ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓa mí nùwã ɲun fù lée nùpua na térénna le Dónbeenì yahó, ó o Ɲúhṹso làndáwá là a bè-zéenínia lè mí dà-kéní kéní ɓúenɓúen á ɓa wee bè yi lè mí ɲi-kã́a. ");
INSERT INTO boxNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɓa lá dĩǹ yí yú za lé bìo ó o Elizabɛɛti hĩ́ana yí máa te, à ɓa mí nùwã ɲun mún kĩ́nkaa. ");
INSERT INTO boxNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wizonle ɓúi, ó o Zakari zon le *Dónbeenì zĩ-beenì yi lé bìo á ɓa kuure nùpua lé bán ho yankaró pã̀ahṹ yèrèmáa ɓueé dɔ̃n, ");
INSERT INTO boxNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","á bìo ɓa le mí ì cà yìa zoó cĩ̀í mu bìo na sãmu sĩ le *sòobá-lùe yi làa bìo mu bòráa le Dónbeenì yankarowà làndá yi á ɓa wó le ɲún-sĩni bìo, ó orɛ́n lé yìa ó o Ɲúhṹso léra. ");
INSERT INTO boxNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hón pã̀ahṹ so yi, ká ɓa zã̀amáa lée dĩ̀n ho khũuhũ á wee wé ho fìoró. ");
INSERT INTO boxNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yìo ɓueé tĩ ò o Ɲúhṹso wáayi tonkaro lií dĩ̀n o yahó mu bìo na sãmu sĩ cĩ̀íníi dɛ̀ɛ nìsã́ní ɓàn nín-tĩánì. ");
INSERT INTO boxNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pã̀ahṹ na ó o Zakari mɔn wo, ó o zã́na làa sòobɛ́ɛ á wee zà wàwàwà. ");
INSERT INTO boxNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ká a tonkaro màhã́ bía làa wo: «Zakari, yí zɔ̃́n dɛ̀ɛ, le Dónbeenì ɲá ũ fìoró. Mìn hã́a Elizabɛɛti á à sì le sãní á à te o za báa; ká a khíi ton à ũ cé o yèni le Zãn. ");
INSERT INTO boxNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O bìo khíi wé hã zã̀makaa lè le sĩ-wɛɛ ũ cɔ̃́n, á nùpua cɛ̀rɛ̀ɛ mún khíi zã̀maka a teró bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lé bìo ó o khíi wé nì-beenì o Ɲúhṹso yèn-dã́ní yi. Bè-ɲunii na dà a vĩ́ hã yìo ó o máa bè mí ɲii yi hùúu, á le Dónbeenì Hácírí á à fèn ǹ kɛń wo yi ká a yàá dĩǹ yí ton. ");
INSERT INTO boxNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Orɛ́n lé yìa khíi bĩní ì fé o *Isirayɛɛle nìpomu cɛ̀rɛ̀ɛ á ɓa à yèrèmá à ɓuen ɓa Ɲúhṹso Dónbeenì cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Orɛ́n mí bɛɛre lé yìa khíi fèn ǹ wíoka a Ɲúhṹso wɔ̃hṹ lè le Hácírí lè ho dàńló na le Dónbeenì yánkaa nɔn mí ɲi-cúa fɛɛro *Elii yi. Ũ za mu lé yìa khíi véení hã bíoní na wi ɓa maáwà lè mí zàwa pã̀ahṹ, á mún ǹ yèrèmá bìa pã́ le Dónbeenì bíonì sĩa á ɓa à wé lè ɓa nùpua na térénna lè ɓa bè-zũńlowà bìo síi. Lé kà síi o ò wíokaráa ɓa nùpua á à paráa o Ɲúhṹso ɓuenló.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ó o Zakari bía nɔn le Dónbeenì tonkaro mu yi: «Bìo ò wé á ĩ tàráa mu yi lé mu yɛ́n? Bìo á ĩ màhã́ kĩ́na, á wàn hã́a mún yìo tɔ̃n yú.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Á le Dónbeenì tonkaro bía: «Ĩnɛ́n na dĩ̀n ũ yahó kà lé o Kabiriyɛɛle. Ĩ wi le Dónbeenì nìsã́ní á wee sá na le yi. Lerɛ́n lé dìo tonkaa mi le ĩ ɓuee bío le bín-tente na kà na foǹ. ");
INSERT INTO boxNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Àwa! Á bìo fo yí tà ĩ bíonì yi, lé bṹn nɔn á ũ ɲii á à lì á máa bĩní máa bío fúaa ũ za báa mu te nɔ̀nzoǹ. Loń mu sese, bìo á ĩ bía làa fo ɓúenɓúen á à wé ho pã̀ahṹ na le Dónbeenì le mu ko yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hón pã̀ahṹ so yi ká ɓa zã̀amáa pá lée dĩ̀n ho khũuhũ á pan o Zakari. Ho pɔ̃̀n-tóní na ó o zoó wó le sòobá-lùe yi á lùnkaa ɓa yilera. ");
INSERT INTO boxNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pã̀ahṹ na ó o wà ɓueé lé yi, à bṹn ò o ɲii lù, ó o wee bío lè ɓa nùpua lè mí níní. Á ɓa dɛ̀ɛnía zũna mu le o bìo mu yínɔń kã́amáa, Dónbeenì zéenía bìo ɓúi làa wó zoó le sòobá-lùe mu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nɔ̀nzoǹ na ó o Zakari mu tonló vó yi, ó o wà van mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lé bṹn mɔ́n á ɓàn hã́a Elizabɛɛti sùráa mí sãní. Bìo ó o zũna mí sãní mu bìo, ó o wó hã pĩina bìo hònú ɓúenɓúen ká a yí máa tà lé khũuhũ. Hón pã̀ahṹ so yi ó o wee bío mí yi: ");
INSERT INTO boxNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Pátì! Bìo kà yàá dĩ̀n yí bon. O za máa teró bìo na fù wee wé bío na miì fɛ́ɛɛ á wã́a vó ho zuia. O Ɲúhṹso na pànká wi á zũna ĩ màkárí á hóonía ĩ ɲúhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pĩina bìo hèzĩ̀n bṹn mɔ́n, á le Dónbeenì bía nɔn mí tonkaro Kabiriyɛɛle yi le o tĩ́n lɛ́n va ho Kalilee kɔ̃hṹ lóhó ɓúi na ɓa le Nazarɛɛte yi, o hĩ́nzo-sínii ɓúi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","O hĩ́nzoró mu fũaamu á bò nɔn o bɛ́ɛ *Daviide nɔnkãni nùpue ɓúi na yèni ɓa le Zozɛɛfu yi. O hĩ́nzo-sínii mu yèni ɓa le Mari. ");
INSERT INTO boxNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bìo ó o Kabiriyɛɛle vaá zon o zĩi yi ó o tɛ̀ɛnía a yi: «Mari, foó. O Ɲúhṹso Dónbeenì wó mí sãamu làa fo: Orɛ́n mí bɛɛre mún wi làa fo. Wã́a zã̀maka.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ó o Mari kará coon á yilera yáara. O wee le mí yi, le dén tɛ̀ɛníi so ɲúhṹ lé mu yɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Á le Dónbeenì tonkaro bía: «Mari, yí zɔ̃́n dɛ̀ɛ woon, le Dónbeenì sãamu á dɔ̃n fo. ");
INSERT INTO boxNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Loń! Bìo fo kará wán á fo ò sì le sãní á a te o za báa, ká ũ le fo ò cé o yèni à ũ bío le Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O khíi wé nùpue na ɲúhṹ wi á ɓa wé è ve o lè le Dónbeenì na wi mu bìo ɓúenɓúen ɲúhṹ wán Za. Á le Dónbeenì mún khíi bàrá a ɓàn ɓùaa Daviide bá-zàmu kanmúiní wán. ");
INSERT INTO boxNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O khíi lá lé bɛ́ɛnì o *Zakoobu nìpomu zĩi, á bá-zàmu máa ve máa mi.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ó o Mari bía nɔn wo yi: «Mu dà a wé kaka? Bìo á ĩ màhã́ yí zũ báa.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Á ho wáayi tonkaro zéenía mu ya-tente làa wo: «Le Dónbeenì Hácírí á à lii ũ wàn, á le Dónbeenì na wi mu bìo ɓúenɓúen ɲúhṹ wán dàńló á à ɓún foǹ lè ho tàró bìo síi. Lé bṹn nɔn ó o za na á ũ khíi te á ɓa wé è ve le yi poni ɓànso, làa Dónbeenì Za. ");
INSERT INTO boxNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Loń! O Elizabɛɛti na làa fo te mín pá sù le sãní lè mí hã́-kĩ́nmu; wón na ɓa fù le o hĩ́ana yí máa te, nín-yìa sãní pĩina yú hã bìo hèzĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Lé bìo á bìo na le Dónbeenì á à wé è sa bṹn bìo so mía hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hón pã̀ahṹ so yi ó o Mari bía nɔn ho wáayi tonkaro yi: «Ĩ wi o Ɲúhṹso níi yi ho zuia, ĩ wi o níi yi ho yìró. Le mu wé miì làa bìo fo bíaráa mu.» Á ho wáayi tonkaro zoó ló lée wà ò o día a Mari. ");
INSERT INTO boxNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wizooní bìo yɛn bṹn mɔ́n, ó o Mari hĩ́nɔn bánbáa ɲɔn ho lóhó ɓúi na wi ho *Zudaa kɔ̃hṹ ɓúaa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bìo ó o vaá dɔ̃n ó o térénna vaá zon o Zakari zĩi, á zoó tɛ̀ɛnía a Elizabɛɛti yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bìo ó o Elizabɛɛti ɲá a Mari tɛ̀ɛníi sã, ó o za dɛ̀ɛnía zoó kùrúnna a yi, á le Dónbeenì Hácírí wã́a sú a Elizabɛɛti mu, ");
INSERT INTO boxNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ó o zoó bía pɔ̃́npɔ̃́n: «Ɓa hã́awa ɓúenɓúen tĩ́ahṹ ũnɛ́n lé yìa le Dónbeenì dúɓuaa wi wán, ó o za na sãní wi ũ wán á le mún dúɓuaa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ĩnɛ́n lée wée á ĩ Ɲúhṹso ɓàn nu ló ɓuararáa ĩ cɔ̃́n! ");
INSERT INTO boxNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Loń! Pã̀ahṹ na á ĩ ɲá ũ tɛ̀ɛníi sã, á ĩ za sĩi wan wan á kùrúnna ĩ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yìa tà le bìo ó o Ɲúhṹso bía nɔn mí yi á à wé máa khí ɓɛ̀ntĩ́n bìo se.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ó o Mari wã́a bía: Ĩnɛ́n wee dé o Ɲúhṹso yèni wán, ");
INSERT INTO boxNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","á ĩ sĩi mún wan le Dónbeenì na lé ĩ kã̀nílo bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Lé bìo le lora mí ton-sá hã́a na bìo ɲúhṹ mía. Bìo kà wán á ɓa nùpua ɓúenɓúen na wee te lè mí pɔ̃̀nna á à bío lé ĩ bìo se. ");
INSERT INTO boxNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lé bìo le Dónbeenì na dà mu bìo ɓúenɓúen á wó mu bè-beera nɔn miì. Le yèni po hã yènnáa ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Le sãamu á bɛ̀nbɛ́ra fò ɓa nùpua na wa le á wee kɔ̃̀nbi hã pɔ̃̀nna ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Le wee wé zéení mí pànká bìa wee ɓùaaní míten wán á ɲa ɓa vĩ́nvĩ́ná. ");
INSERT INTO boxNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Le wee wé liiní ɓa bá-zàwa mí kanmúiní wán à hóoní ɓa yídàwa ɲúná. ");
INSERT INTO boxNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bìa le hĩni wee ɓúe á le wee wé síiní níní lè mu bè-tentewà cɛ̀rɛ̀ɛ, à ɲa ho nàfòró ɓànsowà á ɓa lɛ́n lè mí nín-kã́amáa. ");
INSERT INTO boxNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Le séenía mí ton-sá *Isirayɛɛle, à zéenínáa le le yi yí nɔnsãa mu sãamu ");
INSERT INTO boxNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","na le wee wé là a *Abarahaamu lè mí mɔ́n yi fúuu, làa bìo le hĩ́a dóráa mí ɲii nɔn wàn maáwà yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ó o Mari wã́a kará là a Elizabɛɛti á yú hã pĩina tĩn síi, bṹn mɔ́n ó o bĩnía wà ɓon. ");
INSERT INTO boxNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bìo ó o Elizabɛɛti teró dɔ̃n, ó o ton mí za báa. ");
INSERT INTO boxNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Á bìa làa wó kará ɓó mín yi lè ɓàn temínlowà ɲá le o Ɲúhṹso wó mí sãamu làa wo, á ɓa páanía wee zã̀maka làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","O kúnkúza mu teró wizooní bìo hètĩn zoǹ á ɓa ɓuan wo ɓueé *kúio, à ɓa le mí ì cé ɓàn maá Zakari yèni á à na a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Á ɓàn nu Elizabɛɛti pã́ ò o bía: «Ɓùeé. O yèni ɓa le Zãn.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Á ɓa bía nɔn wo yi; «Lée webio? Le yèni mu ɓa yèn-ɓua mía mìn zĩi.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Á ɓa wã́a wee tùa ɓàn maá yi lè mí níní le lé le yèni yɛ́n ó o le mí ì cé á à na mí za yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ó o Zakari le ɓa lá le dɛ̀ɛ na wee túa wán na mí yi, á bìo kà lé bìo ó o túara: «O yèni ɓa le Zãn.» Á mu wó ɓa coon. ");
INSERT INTO boxNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lé bṹn wán ó o Zakari ɲii dɛ̀ɛnía feera wee bío, á wee ɓùaaní le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Á bìa sùarákaa bĩ́n ɓúenɓúen zã́na, á ho *Zudee kɔ̃hṹ ɓúaa lùa ɓúenɓúen yi á ɓa wee bío bìo wó. ");
INSERT INTO boxNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Á bìa wee ɲí mu ɓúenɓúen wee ɓua mu mí sĩa yi. Ɓa wee tùa míten yi: «O kúnkúza mu bìo khíi wé kaka coon?» O Ɲúhṹso pànká ɓɛ̀ntĩ́n wi làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ó o kúnkúza mu ɓàn maá Zakari á le Dónbeenì Hácírí sú á le le o bío hã bíoní na kà: ");
INSERT INTO boxNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mi wé sío ɓùaaní a Isirayɛɛle nìpomu ɓàn Dónbeenì na lé o Ɲúhṹso. Lé bìo le ɓuara kã̀nía mí nìpomu á mu wi míten. ");
INSERT INTO boxNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Le nɔn ò kã̀nílo na pànká wi wɛn na ló le ton-sá *Daviide zĩ-ɲúhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Le yánkaa bía bìo kà hàánì mí ɲi-cúa fɛɛrowà ɲiní yi: ");
INSERT INTO boxNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ĩ khíi kã̀ní mia mi zúkúsa làa bìa ɲina mia ɓúenɓúen níní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Bṹn sãamu so lé bìo le hĩ́a wó, le hĩ́a wó mu á nɔn wàn ɓùaawa yi. Le yi pá yí nɔnsãa bìo lerɛ́n làa ba ɲiní tò wán le mí ì ɓua làa mín yi. Le yáanía báa lè wàn ɓùaa *Abarahaamu ");
INSERT INTO boxNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","le mí ì fé wɛn wà zúkúsa níní yi, Á wa à dàń ǹ dĩ̀n wé è sá a na le yi wa mukãnì wizooní ɓúenɓúen yi. Mu húaaràmu lè mu tentemu yi le yahó ká zã́níi mía wɛn. ");
INSERT INTO boxNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ũnɛ́n háyónza mu, ɓa khíi ve làa yìa dà mu bìo ɓúenɓúen wán ɲi-cúa fɛɛro. Fo khíi dí o Ɲúhṹso yahó loo á à wíoka a wɔ̃hṹ á à na a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ò o nìpomu à zũń ho fenló bìo ɓa bè-kora sɛ́ndíaró bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wàn Dónbeenì sĩi se, á hii wi le lée waminì ɓànso. Le wó á mu khoomu ló ho wáayi lè le wii na lií hà bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Le khoomu mu ù lé á à kúia bìa kará le tíbírí yi wán làa bìa na wi mu húmú yuumu yi, á à dí wa yahó ho hɛ́ɛrà wɔ̃hṹ wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ó o háyónza mu wã́a wee dã á hácírí wee dé wán ká le wà. Ò o ò kɛɛní hã mana tá henì yi fúaa nɔ̀nzoǹ na ó o khíi dĩ̀n o Isirayɛɛle nìpomu yahó á ɓa a mi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","O Zãn mu teró pã̀ahṹ lé bṹn á ho *Oroomu bɛ́ɛ Okusite á nɔn lè ɲii, le hã kãna na bìo sã̀ mí yi à ɓa túa nùpua ɓúenɓúen yènnáa à mí zũń ɲii. ");
INSERT INTO boxNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hón nín-yání mìló so wó ká a Kiriniyuusi lé yìa ó o bàrá ho Siirii kɔ̃hṹ ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lé bṹn nɔn ká nùpue na nɔnkãni can lóhó na yi ò o lɛ́n va bĩ́n à vaa túa mí yèni. ");
INSERT INTO boxNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ó o Zozɛɛfu mún hĩ́nɔn ló ho Kalilee lóhó na ɓa le Nazarɛɛte yi á wà van ho Zudee kɔ̃hṹ lóhó yi, hìa yèni ɓa le Betelehɛɛmu. Lé bĩ́n ó o bɛ́ɛ *Daviide ton yi. O Zozɛɛfu mu lé o Daviide mɔ̀nmàníi ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ó o Zozɛɛfu mu lè mín fũaalè Mari hĩ́nɔn páanía bò mín á wà vaá túa mí yènnáa bĩ́n. Hón pã̀ahṹ so yi ká ɓàn fũaalè mu sãní dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bìo ɓa vaá wi ho Betelehɛɛmu yi, ó o Mari teró pã̀ahṹ dɔ̃n, ");
INSERT INTO boxNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ó o ton mí hínbíi za á ɓa bá a lè ho pɔ̃nsòró á dó ho boohó yi, lé bìo ɓa yí yú le lùe ɓa nì-hãní làaníi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mu wee wé ká ɓa pi-pawà khɛ̀ra vaá wee pa mí pia fé mín yi hã mana na sùaráa bĩ́n yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yìo ɓueé tĩ à le Dónbeenì wáayi tonkaro ɓúi dĩ̀n ɓa yahó, ó o Ɲúhṹso khon-be-beenì lion ɓa wán lè mí pànká á ɓa yiwa lɛ̀ɛkaa á zã́na dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ká ho wáayi tonkaro màhã́ bía á hĩ̀ína ɓa sĩa: «Mì yí zɔ̃́n wà. Lée bín-tente á ĩ bío á à na mia. Le bìo á à wé hã zã̀maka-beenì mìn nìpomu ɓúenɓúen cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mi yú a kã̀nílo, o ton ho tĩ́nàahṹ na kà yi o Daviide ɓa lóhó yi. O lé o *Krista á lé o Ɲúhṹso. ");
INSERT INTO boxNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bìo mi ì zũńnáa wo lé bìo kà: Mi wã́a lɛ́n, ká mi hĩ́a vaá mɔn kúnkúza yìa ká a dũma ho boohó yi á bá lè ho pɔ̃nsòró se wón lé orɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mí lahó yi à bṹn à ho wáayi tonkarowà ku-beenì ɓúi yòó ló lion o cɔ̃́n á ɓa páanía wee khòoní le Dónbeenì: ");
INSERT INTO boxNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ho cùkú lè le yèn-beenì à bìo sĩ̀ le Dónbeenì na dà mu bìo ɓúenɓúen ɲúhṹ wán yi! Ò o hɛ́ɛrà na ó o wee na ɓa nùpua na bìo sĩ a yi à yí mí pànká ho tá wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bṹn mɔ́n á ho wáayi tonkarowà bĩnía yòó wà à ɓa día ɓa pi-pawà, á ɓa yèrèmáa wee bío mín yi: «Mi hĩ́ní le wa bánbá va ho Betelehɛɛmu yi à vaa mi bìo ó o Ɲúhṹso zéenía làa wɛn à zũń mu yahó.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mí lahó yi á ɓa dɛ̀ɛnía hĩ́nɔn bánbáa vaá yú à Mari là a Zozɛɛfu là a kúnkúza yìa mu ká a dũma ho boohó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bìo ɓa mɔn wo kà síi, á ɓa dɛ̀ɛnía lan wee bío bìo ho wáayi tonkaro bía nɔn ɓa yi o kúnkúza mu bìo yi à na bìa wi bĩ́n yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Á bìa ɲá ɓa pi-pawà mu ɲi-cúa ɓúenɓúen á dĩ̀n coon mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ò o Mari wón ɓɛ̀n ɓuan hã bíoní mu mí yi, á wee le mí yi hã bìo yi fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bìo ɓa vaá mɔn o wán vó, á ɓa bĩnía wà ká ɓa wee ɓùaaní le Dónbeenì yèni, á wee khòoní le bìo ɓa ɲá làa bìo ɓa mɔn ɓúenɓúen bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","O teró wizooní bìo hètĩn níi zoǹ á ɓa *kúio wo, á có yèni le Yeesu. Dén yèni so le dìo á ho wáayi tonkaro hĩ́a zéenía lè ɓàn nu ká a sãní yàá dĩǹ yí sù. ");
INSERT INTO boxNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bṹn mɔ́n á bìo ɓa ceéra míten vó làa bìo mu bòráa o *Mɔyiize làndá yi, ó o Mari là a Zozɛɛfu ɓuan mí za Yeesu vannáa ho Zeruzalɛɛmu á wà vaá na a ɲúhṹso yi, ");
INSERT INTO boxNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","làa bìo mu túararáa o ɲúhṹso làndá vũahṹ yi: «Ɓa nùpua hínbíi zà-báawa lè ɓa sároń bùaa nín-yání zà-tenia bà-báa ɓúenɓúen bìo sã̀ a Ɲúhṹso yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓa mún ko ɓa na ɓa ɓùaaɓúuní bùaa ɲun, ká bán yí yú, á ɓa a na ɓa háponí bùaa ɲun à á wé lè mu hãmu, làa bìo mu túararáa o Ɲúhṹso làndá vũahṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bṹn pã̀ahṹ ká a nì-kĩ́nle ɓúi fù wi ho Zeruzalɛɛmu yi á yèni ɓa le Simiɔn. Le Dónbeenì Hácírí fù wi làa wo. O lée nùpue na fù térénna ɓa nùpua yahó, á dó mí sĩi le Dónbeenì yi, á mún bò le làndáwá lè mí dà-kéní kéní yi. O fù kará wee lòoní yìa wà ɓueé kã̀ní a *Isirayɛɛle nìpomu mí wobámu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Le Dónbeenì Hácírí yánkaa bía nɔn wo yi: «Fo máa hí ká fo yí mɔn o *Krista na lé le Dónbeenì tonkaro lè ũ yìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ho pã̀ahṹ na ó o Yeesu ɓàn nùwã ɓuan wo wà ɓueé tiíráa o Ɲúhṹso làndá ɲii, lé hón pã̀ahṹ so yi á le Dónbeenì Hácírí dà-kéní kéní mu á ɲàana a Simiɔn ɓuararáa le *Dónbeenì zĩ-beenì yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bìo ó o mɔn o kúnkúza mu ó o dɛ̀ɛnía vaá fó a ɓuan mí bàra yi, ò o wee khòoní le Dónbeenì kà síi: ");
INSERT INTO boxNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ɲúhṹso, bìo á ũ fù bía ɛ̀ɛ lé mu wã́a wó ho zuia. Lònbìo ũ ton-sá à ũ wã́a día o ò yí níi à hí làa hɛ́ɛrà. ");
INSERT INTO boxNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","O kã̀nílo á ĩ yìo á wã́a mɔn, ");
INSERT INTO boxNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yìa ũ fèra wíokaa bàrá hã sìíwà ɓúenɓúen yahó loo, o ò wé yìa wé è dé hã khoomu. ");
INSERT INTO boxNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Orɛ́n lé yìa á à wé mu khoomu á hã sìíwà nùpua á à bè yi ì zũńnáa fo o ò wé ũ nìpomu *Isirayɛɛle cùkú lè ho yèni loo. ");
INSERT INTO boxNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ó o Yeesu ɓàn maá lè ɓàn nu wó coon hã bíoní na ó o Simiɔn bía ɓa za dã́ní yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Bṹn mɔ́n ó o Simiɔn dúɓuaa ɓa yi, ò o bía nɔn o Yeesu ɓàn nu Mari yi: «Àwa! Le ĩ fèn bío mu na foǹ: Ũ za mu na kà bìo khíi wé hã kánkáa o Isirayɛɛle nìpomu ɓúenɓúen cɔ̃́n. Orɛ́n bìo yi, á le Dónbeenì khíi síiní ɓa cɛ̀rɛ̀ɛ ɲúná, á lé orɛ́n bìo yi, á le mún ǹ lén ɓa cɛ̀rɛ̀ɛ ɓúi ɲúná. O ò wé yìa wé è zéení le Dónbeenì bìo, ká ɓa nùpua màhã́ máa tà a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bṹn lé bìo á à na ká ɓa nùpua cɛ̀rɛ̀ɛ sĩa bìo na fù tun yi á à lé ho khũuhũ. Ɛ̀ɛ ká ũnɛ́n Mari, le lònbee na à yí fo á à kɛń lòn cànɓúa na ɓa cú lè ũ kosĩi.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hón pã̀ahṹ so yi ò o hã́-kĩ́nle ɓúi mún ɓueé dɔ̃n. O lé le *Dónbeenì ɲi-cúa fɛɛro. O yèni ɓa le Aana, ká ɓàn maá lé o Fanuwɛɛle na ló a Azɛɛre nùwã zĩi. Ɓàn báa na ó o hĩ́a yan lè mí hĩ́nmu ó o karáráa dɔ̃n hã lúlúio bìo hèɲun. ");
INSERT INTO boxNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bìo á wón húrun ó o yí bĩnía yí yan á teró lúlúio yòó yú ho ɓúará-náa làa bìo náa. O fù wee wé ɓuen le *Dónbeenì zĩ-beenì yi túntún à ɓuee sá na le yi lè mí ɲii lìró lè mí fìoró le wisoni lè ho tĩ́nàahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bìo ó o mɔn o kúnkúza Yeesu ká ɓàn nùwã ɓuan wo, ó o dɛ̀ɛnía wee khòoní le Dónbeenì ká a bío o háyónza yìa mu bìo à na bìa ɓúenɓúen na fù wee lòoní ho pã̀ahṹ na le Dónbeenì á à kã̀ní ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bìo ó o Yeesu ɓàn nùwã wó bìo ó o Ɲúhṹso làndá lé ɓa bè yi á mu ɓúenɓúen ɲii tun vó, bṹn mɔ́ndɛ́n á ɓa van ho Kalilee kɔ̃hṹ yi, ho Nazarɛɛte lóhó na ɓa lá wi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ó o háyónza mu wee dã ká a lìíka, á hácírí wee dé wán. O fù sú lè mu bè-zũńminì á le Dónbeenì dúɓuaa mún fù wi o wán. ");
INSERT INTO boxNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lúlúure lée lúlúure ká a Yeesu ɓàn nùwã fù wee wé va ho Paaki sã́nú díiníi ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bìo ho pã̀ahṹ mu yèrèmáa ɓueé dɔ̃n, á ɓa le mí ì va bĩ́n làa bìo ɓa lá wee wé wéráa mu. Hón pã̀ahṹ so yi, ò o Yeesu lúlúio wã́a yú ho pírú ɲun ó o bò lè mín nùwã van ho sã́nú mu díiníi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bìo ho Paaki sã́nú mu vaá dú vó, á ɓa bĩnía wee ɓo, à ɓa za Yeesu wón pá kará ho Zeruzalɛɛmu yi ká ɓa yí zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓarɛ́n hácírí yi á ɓa wee leéka le o wi mí ninzàwa tĩ́ahṹ. Lé ɓa wizon-kùure vɛɛnì mɔ́n, á ɓa màhã́ zũńnanáa mu ká a yí bò làa bán. Á ɓa màhã́ wã́a wee hɛ́ɛ tùaka a bìo mín temínlowà lè mí nì-zũńlowà cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Á bìo ɓa tùakaa san, á ɓa bĩnía lá ho wɔ̃hṹ van ho Zeruzalɛɛmu á vaá wee cànka a bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mu wizooní tĩn níi zoǹ á ɓa vaá zoó yú a le *Dónbeenì zĩ-beenì yi ká a páanía kará lè ho làndá zũńlowà á wee ɲí ɓa cɔ̃́n ká a tùaka ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Á bìa wee ɲí a bíoní ɓúenɓúen wee wé coon le hácírí na ó o wee cikonnáa mu bìo dã́ní yi, làa bìo ó o wee bĩní zéenínáa mu yara bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bìo ó o Yeesu ɓàn maá le ɓàn nu zoó mɔn wo bĩ́n á ɓa dĩ̀n concáan. À ɓàn nu bía làa wo: «Éee! Ũnɛ́n, fo wó wɛn kà le we? Loń! Mìn maá làa mi cànkaa fo hã lùa ɓúenɓúen yi san à wa yí mɔn fo, á wa hácírí yáara làa sòobɛ́ɛ ũ bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ó o Yeesu bía nɔn ɓa yi: «À mi lá wee cànka mi le we? Mi so yí zũ ká ĩ ko à ĩ pa bìo bìo sã̀ wàn Maá yi sese à wé o sĩi bìo le?» ");
INSERT INTO boxNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Á ɓàn nùwã yí zũna a bíonì mu kúará. ");
INSERT INTO boxNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bṹn mɔ́n ó o Yeesu hĩ́nɔn bò ɓa yi vannáa ho Nazarɛɛte á vaá wee bè ɓa bíoní yi. Bṹn bìowa so na wee wé lè mí dà-kéní kéní ɓúenɓúen á ɓàn nu fù wee ɓua mí sĩi yi, á wee le mí yi mu wán fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ó o Yeesu wã́a wíokaa wee dã ká a lìíka. O hácírí là a bè-zũńminì wee dé wán ká mu wà. Lé bṹn nɔn ó o bìo wɛɛ́raráa le Dónbeenì lè ɓa nùpua sĩa. ");
INSERT INTO boxNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bṹn pã̀ahṹ ká ɓa bá-zàwa bɛ́ɛ Tibɛɛre wi mí pànká láró lúlúio pírú hònú níi yi. Á bìo kà lé bìo ó o bàráka lè mí nùpua hã kãna ɓúi na bìo sã̀ a yi ɲúná wán: O *Pɔ̃nsi Pilaate lé ho Zudee á wón wi ɲúhṹ wán; ká a *Heroode lé ho Kalilee. Ɓàn kĩ́nle Filiipu lé ho Ituree lè ho Tarakoniite á wón wi ɲúná wán; ò o Lizaniasi ɓɛ̀n lé ho Abilɛnɛ á wón wi ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bìa hĩ́a lé le *Dónbeenì yankarowà ɲúnása mu pã̀ahṹ lé o Aana là a Kayiifu. Lé hón pã̀ahṹ so yi á le Dónbeenì dó mí bíonì o Zakari za Zãn ɲii yi ká a wi hã mana yi ho tá henì yi. ");
INSERT INTO boxNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ó o wã́a hĩ́nɔn tò hã lórá na bã́ ho Zurudɛ̃n muhṹ á wee bue bìo kà na ɓa nùpua yi: «Mi ɓuen à ĩ bátízé mia, lé bṹn á à zéení le mi khú mu bè-kora wéró yi, á bò le Dónbeenì yi, á le è sɛ́n mi bè-kora á à día.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bṹn lé bìo wee zéení le le *Dónbeenì ɲi-cúa fɛɛro *Ezayii bìo mu na ó o yánkaa túara mí vũahṹ yi kà wéró dɔ̃n: «Nìi ɓúi wee bío pɔ̃́npɔ̃́n le dùure yi kà síi: ‹Mi wíoka ho wɔ̃hṹ ká a Ɲúhṹso o ɓuen. Mi muin ho wɔ̃hṹ na o ò bè. ");
INSERT INTO boxNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hĩ̀a lée bonconí à mi ti hã. Hã ɓúaa lè hã ɓúe-zàwa à mi dà le hã màní. Hã wãna na kunka à mi bĩní térén. Hã wã-zàwa na kùarànkúarán à mi bĩní wíoka. ");
INSERT INTO boxNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hón pã̀ahṹ so yi á ɓa nùpua na wi ho sìí yi ɓúenɓúen á à mi bìo le Dónbeenì wi à le kã̀nínáa ɓa.›» ");
INSERT INTO boxNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Á bìo ɓa zã̀amáa lè mí kuio wee lé ɓuen o Zãn mu cɔ̃́n bèra a na o ò bátízé ɓa, ó o wee bío na ɓa yi: «Mi yí mɔn miten le, díhioni zàwa yɛ́n! Le Dónbeenì sĩ-cĩ̀ílè na yòó lua á mi so wee leéka le mi dà a fé miten níi yi le? Lé o yɛ́n bía mu nɔn mia? ");
INSERT INTO boxNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Héyìi! Mi wé wé hã wárá na se, hĩ̀a wee zéení le mi khú mu bè-kora wéró yi á bò le Dónbeenì yi. Mi yí bío mi yiwa le bìo mi lé o *Abarahaamu mɔ̀nmànía á bṹn mí dòn wã́a à yí dɛ́. Le ĩ bío mu na mia: Mi yí mɔn hã huaa na kà le? Hɔ̃́n le Dónbeenì yàá pá dà à yèrèmá à wé là a Abarahaamu zàwa. ");
INSERT INTO boxNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Á mi cén pa miten bìo sese. Lé le dóorè hónhónía ɓuan hã vĩ̀nsĩ̀a kúioró bìo yi. Vĩ̀ndɛ̀ɛ lée vĩ̀ndɛ̀ɛ na yí máa ha hã bia na sĩ, á dén ǹ kúii á à sía à kúee mín wán á à cĩ̀í.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Á bìa wi bĩ́n ɓúi túara a yi: «Àwa! Á bìo wa wã́a ko wa wé lé mu yɛ́n coon?» ");
INSERT INTO boxNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Á bìo kà lé bìo ó o bía nɔn ɓa yi: «Hen ká yìa bákáwá lée bìo ɲun ká a mɔn mí ninza ɓúi na báká mía hùúu, ó o ko ò o na ho ɓúi wo yi. Ká yìa bè-dínii wi ò o mún páaní sanka mu làa yìa bè-dínii woon mía máa dí.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɓa *lànpó féwá ɓúi mún ɓuara a Zãn mu cɔ̃́n á wà ɓueé bátízé. Á bán mún tùara a yi: «Nì-kàránlo, lé mu yɛ́n á warɛ́n ɓɛ̀n ko wa wé?» ");
INSERT INTO boxNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ó o bía nɔn ɓa yi: «Mi yí fé ho lànpó à yòo poń bìo ho làndá zéenía làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Á ɓa dásíwá mún ɓuara á ɓueé tùara a yi làa bìo á ɓarɛ́n ɓɛ̀n ko ɓa wé. Ó o bía nɔn ɓa yi: «Mi wé yí hìhíika ɓa nùpua à fé wárí, à mún yí bàká nùpue woon yi le sábéré ɲii wán, ká mi sàáníi lé dìo à mi kã́ɲa yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bṹn ɓúenɓúen yi ká ɓa nùpua kará dó mí sĩa wee lòoní bìo le Dónbeenì le mí ì wé. Ɓa mí nì-kéní kéní wee leéka le ɲúhṹ sĩ ó o Zãn mu lé yìa lé o *Krista. ");
INSERT INTO boxNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ká a màhã́ bía nɔn ɓa yi: «Ĩnɛ́n wee bátízé mia lè mu ɲumu, ɛ̀ɛ ká a ɓúi na ɓɛ̀n pànká po ĩnɛ́n á wi lè ho mɔ́n bò o ɓuen. Ĩ yàá yí ko là a nakãa tɛnló hùúu. Wón lé yìa ɓueé bátízé mia lè le Dónbeenì Hácírí lè ho dɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O ɓuan mí vɛ́ɛró dɛ̀ɛ mí níi yi á ɓueé vɛ́ɛráa mí dĩ́nló. Á hìa lé ho dĩ́n-poni o ò khuii á à kúee mí nání yi. Ká hã ɲáakã́a hɔ̃́n o ò cĩ̀í ho dɔ̃hṹ na máa hí hùúu yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","O Zãn mún pá kũn hĩ́a bía bíoní cɛ̀rɛ̀ɛ làa bṹn ɓàn síi á nɔn ɓa nùpua yi á mún zéenía le Dónbeenì bín-tente bìo làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bṹn wee wé ká a *Heroode, yìa wi ho Kalilee kɔ̃hṹ ɲúhṹ wán á fó mín kĩ́nle ɓàn hã́a Herodiade yan. O mún lá wee wé hã wén-kora lè mí sìíwà á séenía bìo kà. Bṹn ɓúenɓúen lé bìo ó o Zãn ɲá ó o vaá yú a á bía nɔn wo yi le o lá yí ko ò o wé mu. ");
INSERT INTO boxNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ó o yàá wíoka dó mu wán, ò o le ɓa fé o Zãn vaa pe ɲii ho kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bìo ɓa nùpua hĩ́a wee lé ɓuen o Zãn cɔ̃́n à ɓuee bátízé, ó o Yeesu mún ɓuara ó o Zãn bátízéra a. Bìo o Zãn bátízéra a vó ó o Yeesu wee fìo. Lé hón pã̀ahṹ so á ho wáayi ɲii hɛ́ra ");
INSERT INTO boxNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","á le Dónbeenì Hácírí lá a háponi sìí, á lion o wán. Á mu tãmu ɓúi sã ɲá ho wáayi á bía: «Fo lé ĩ Za na á ĩ bò ĩ tàká wán, ũ bìo sĩ miì.» ");
INSERT INTO boxNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pã̀ahṹ na ó o Yeesu hĩ́a wee ɓúa mí tonló ɲúhṹ yi ká a teró lúlúio wee yí ho ɓóní làa pírú síi. Á bìo ɓa yánkaa wee leéka làa bṹn ó o hĩ́a lé o Zozɛɛfu za, ká a Zozɛɛfu mu ɓàn maá ɓɛ̀n lé o Helii, ");
INSERT INTO boxNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ó o Helii ɓàn maá lé o Mataate, ó o Mataate ɓàn maá lé o Levii, ó o Levii ɓàn maá lé o Mɛliki, ó o Mɛliki ɓàn maá lé o Zanayii, ó o Zanayii ɓàn maá lé o Zozɛɛfu, ");
INSERT INTO boxNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ó o Zozɛɛfu ɓàn maá lé o Matatiasi, ó o Matatiasi ɓàn maá lé o Amɔɔsi, ó o Amɔɔsi ɓàn maá lé o Nahuumu, ó o Nahuumu ɓàn maá lé o Hɛsilii, ó o Hɛsilii ɓàn maá lé o Nakayii, ");
INSERT INTO boxNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ó o Nakayii ɓàn maá lé o Maate, ó o Maate ɓàn maá lé o Matatiasi, ó o Matatiasi ɓàn maá lé o Semɛɲɛɛ, ó o Semɛɲɛɛ ɓàn maá lé o Zozɛɛki, ó o Zozɛɛki ɓàn maá lé o Zodaa, ");
INSERT INTO boxNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ó o Zodaa ɓàn maá lé o Yuanan, ó o Yuanan ɓàn maá lé o Erezaa, ó o Erezaa ɓàn maá lé o Zorobabɛɛle, ó o Zorobabɛɛle ɓàn maá lé o Salasiɛle, ó o Salasiɛle ɓàn maá lé o Nɛrii, ");
INSERT INTO boxNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ó o Nɛrii ɓàn maá lé o Mɛliki, ó o Mɛliki ɓàn maá lé o Adii, ó o Adii ɓàn maá lé o Kosaamu, ó o Kosaamu ɓàn maá lé o Ɛlemadamu, ó o Ɛlemadamu ɓàn maá lé o Ɛɛre, ");
INSERT INTO boxNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ó o Ɛɛre ɓàn maá lé o Zozue, ó o Zozue ɓàn maá lé o Eliyezɛɛre, ó o Eliyezɛɛre ɓàn maá lé o Zoriimu, ó o Zoriimu ɓàn maá lé o Mataate, ó o Mataate ɓàn maá lé o Levii, ");
INSERT INTO boxNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ó o Levii ɓàn maá lé o Simiɔn, ó o Simiɔn ɓàn maá lé o Zudaa, ó o Zudaa ɓàn maá lé o Zozɛɛfu, ó o Zozɛɛfu ɓàn maá lé o Zonaamu, ó o Zonaamu ɓàn maá lé o Eliakiimu, ");
INSERT INTO boxNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ó o Eliakiimu ɓàn maá lé o Mɛleyaa, ó o Mɛleyaa ɓàn maá lé o Mɛnaa, ó o Mɛnaa ɓàn maá lé o Matataa, ó o Matataa ɓàn maá lé o Natãn, ó o Natãn ɓàn maá lé o *Daviide, ");
INSERT INTO boxNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ó o *Daviide ɓàn maá lé o Zesee, ó o Zesee ɓàn maá lé o Obɛɛde, ó o Obɛɛde ɓàn maá lé o Buaze, ó o Buaze ɓàn maá lé o Sala, ó o Sala ɓàn maá lé o Naasɔ̃n, ");
INSERT INTO boxNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ó o Naasɔ̃n ɓàn maá lé o Aminadaabu, ó o Aminadaabu ɓàn maá lé o Ademɛn, ó o Ademɛn ɓàn maá lé o Aanii, ó o Aanii ɓàn maá lé o Hɛsiron, ó o Hɛsiron ɓàn maá lé o Farɛɛsi, ó o Farɛɛsi ɓàn maá lé o *Zudaa, ");
INSERT INTO boxNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ó o Zudaa ɓàn maá lé o *Zakoobu, ó o Zakoobu ɓàn maá lé o *Izaaki, ó o Izaaki ɓàn maá lé o *Abarahaamu, ó o Abarahaamu ɓàn maá lé o Teraa, ó o Teraa ɓàn maá lé o Nahoore, ");
INSERT INTO boxNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ó o Nahoore ɓàn maá lé o Seruuki, ó o Seruuki ɓàn maá lé o Arakoo, ó o Arakoo ɓàn maá lé o Falɛki, ó o Falɛki ɓàn maá lé o Ebɛɛre, ó o Ebɛɛre ɓàn maá lé o Sala, ");
INSERT INTO boxNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ó o Sala ɓàn maá lé o Kayinaamu, ó o Kayinaamu ɓàn maá lé o Aafakisaade, ó o Aafakisaade ɓàn maá lé o Sɛɛmu, ó o Sɛɛmu ɓàn maá lé o Nɔwee, ó o Nɔwee ɓàn maá lé o Lamɛɛki, ");
INSERT INTO boxNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ó o Lamɛɛki ɓàn maá lé o Matuzala, ó o Matuzala ɓàn maá lé o Enɔɔki, ó o Enɔɔki ɓàn maá lé o Yarɛɛde, ó o Yarɛɛde ɓàn maá lé o Maleleyɛɛle, ó o Maleleyɛɛle ɓàn maá lé o Kayinaamu, ");
INSERT INTO boxNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ó o Kayinaamu ɓàn maá lé o Enɔɔsi, ó o Enɔɔsi ɓàn maá lé o Sɛɛte, ó o Sɛɛte ɓàn maá lé o Adãma, ó o Adãma ɓàn maá lé le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Le Dónbeenì Hácírí pànká wi o Yeesu wán. Ó o wã́a ló ho Zurudɛ̃n yi lée wà, á le Dónbeenì Hácírí lɛ̀ɛnía wo vannáa le dùure yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Á mu yú wizooní ɓúará-ɲun ká a *Satãni wee khà a loń bĩ́n. Hɔ̃́n wizooní so yi ɓúenɓúen ó o yí dú bìo hùúu. Hã wizooní mu vaa véeníi, á le hĩni dà a. ");
INSERT INTO boxNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bìo ó o Satãni mɔn mu kà, ó o bía nɔn wo yi: «Le huee na kà á fo yí mɔn le? Ká fo lé le Dónbeenì Za bìo bon kɛ̃́nkɛ̃́n, à ũ bío le le huee na kà yèrèmá wé ho dĩ́nló.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ó o Yeesu bía nɔn wo yi: «Bìo kà lé bìo túara le Dónbeenì bíonì vũahṹ yi: ‹Dĩ́nló mí dòn yí máa na mukãnì nùpue yi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bṹn mɔ́n ó o Satãni mu fó a yòoraráa le ɓúee ɓúi na dɔ̃n wán á yòó dĩ̀n ò o zéenía ho tá kãna ɓúenɓúen làa wo le cúekúee wán, ");
INSERT INTO boxNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ò o bía nɔn wo yi: «Ĩ ì na ho pànká foǹ á fo ò kɛń hã ɲúhṹ wán, á à na hã nàfòró lè hã semu na wi hã yi foǹ, lé bìo le Dónbeenì nɔn hã miì. Ĩ dà a na hã yìa á ĩ sĩi vá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ká fo tà á lií fárá ũ nɔnkóɲúná wán à ũ ɓùaanía mi, á hã bìo ò sĩ̀ foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ó o Yeesu bía nɔn wo yi: «Mu túara le Dónbeenì bíonì vũahṹ yi: ‹Ũ Ɲúhṹso Dónbeenì lé yìa á ũ ko à ũ ɓùaaní à mún sá na orɛ́n mí dòn yi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bṹn mɔ́n ó o Satãni mu pá bĩnía fó a vannáa ho Zeruzalɛɛmu, á vaá yòó dĩ̀nía wo le *Dónbeenì zĩ-beenì ɲún-tĩ́ahṹ, ò o bía nɔn wo yi: «Ká fo lé le Dónbeenì Za bìo bon kɛ̃́nkɛ̃́n, à ũ yén lii ho tá yi, ");
INSERT INTO boxNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","lé bìo mu túara: ‹Le Dónbeenì á a na le ɲii mí wáayi tonkarowà yi le ɓa pa ũ bìo sese.› ");
INSERT INTO boxNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Á mu mún bĩnía túara: ‹Ɓa à cɔ̃n fo á lií wíoka à bàrá, bèra a na ũ zeǹ yí tṹii làa huee ɓúi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ó o Yeesu bía nɔn wo yi: «Mu mún túara lè Dónbeenì bíonì vũahṹ yi: ‹Yí vĩ́ vĩ́ yí khũaa ũ Ɲúhṹso Dónbeenì ɲii yi hàrí lòn wizoǹ-kéní.›» ");
INSERT INTO boxNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bìo ó o Satãni mu khà a làa bìo ɓúenɓúen san ó o wà ò o día a, á pannáa pɔ̃̀n-veere. ");
INSERT INTO boxNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bìo á bṹn ɓúenɓúen wó khĩína, ó o Yeesu wà van ho Kalilee kɔ̃hṹ ká le Dónbeenì Hácírí pànká wi o wán. O yèni ló ho Kalilee mu kɔ̃hṹ lórá ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O fù wee wé kàrán ɓa nùpua ɓa *zúifùwa kàránló zĩní yi. Á ɓa ɓúenɓúen ɓɛ̀ntĩ́n fù wee wíoka a yèni. ");
INSERT INTO boxNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bṹn mɔ́n ó o wà van ho Nazarɛɛte, hen na ó o dɔ̃n yi. Ho *Sabaa zoǹ ó o van ɓa zúifùwa kàránló zĩi làa bìo ó o lá wee wé wéráa mu. Bìo ó o le mí ì kàrán le Dónbeenì bíonì vũahṹ, ó o lií hĩ́nɔn yòó dĩ̀n, ");
INSERT INTO boxNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","á ɓa lá le *Dónbeenì ɲi-cúa fɛɛro *Ezayii vũahṹ nɔn wo yi. Ó o fó ho bɛra á fò mín làa bìo kà: ");
INSERT INTO boxNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«O Ɲúhṹso Hácírí á wi miì. Lé bìo ó o léra mi le ĩ vaa bío le bín-tente bìo à na bìa lé ɓa nì-khenia yi. Le tonkaa mi le ĩ bío na ɓa kàsósa yi le ɓa à kɛń míten, à ĩ mún bío na ɓa muiiwà yi le ɓa yìo á à bĩní wé è mi. À ĩ na hã sãní-wia bìa ɓa wee beé lò yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","À ĩ mún bue le lúlúure na ó o Ɲúhṹso sãamu bìo ò wé yi bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bṹn mɔ́n ó o bun ho vũahṹ á khíi nɔn ho kàránló zĩi ton-sá yi ò o lií kará á wee zéení hã bíoní mu ɲúná làa ba. Á bìa wi le zĩi yi ɓúenɓúen fá mí yìo o yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bìo ó o ɲii zoó wee hɛn á bìo kà lé bìo ó o bía nɔn ɓa yi ho yahó: «Mi yí mɔn le? Le Dónbeenì ɲi-cúa fɛɛro bíoní na mi ɲá lé hɔ̃́n bìo lan wee wé ho zuia.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bìa wee ɲí hã bíoní mu ɓúenɓúen wee wíoka a yèni á mún wó coon hã bìo yi. Ɓa lá yí máa dé le hɔ̃́n bín-tentewà so na kà ó o dà wee bío. Á ɓa wee bío mín yi: «Yìa kà kũ̀aní yínɔń o Zozɛɛfu yàró na wa ɓúenɓúen zũ lé wón wee bío hã bíoní mu na kà.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ó o Yeesu bía nɔn ɓa yi: «Mi tũ̀iá sĩ, mi dà à wà le wàhiire na kà á à na miì: ‹Tĩni ɓànso wɛɛ́ ũten ũten.› Lé bṹn nɔn á mi yàá pá dà à bĩní ì bíoráa bìo kà á à na miì: ‹Bìo á fo wó ho *Kapɛɛnayuumu yi ɓúenɓúen á wa ɲá, á ũ ɓɛ̀n wé mu ɓàn síi hen kà mìn kùrú lóhó yi le wa mi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ó o Yeesu pá bĩnía bía: «Le ĩ mì ho tũ̀iá na mia: Le Dónbeenì ɲi-cúa fɛɛro na dà à yí le yèn-tente mín kùrú lóhó yi, wón mía. ");
INSERT INTO boxNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Le ĩ mì ho tũ̀iá poni na mia: Le Dónbeenì ɲi-cúa fɛɛro *Elii pã̀ahṹ, á ho viohó hĩ́a dĩ̀n á yí máa tè á dɔ̃n hã lúlúio bìo tĩn lè mí pĩina bìo hèzĩ̀n, á le hĩni ló ho kɔ̃hṹ ɓúenɓúen yi. Bṹn pã̀ahṹ ká ɓa mahã́awa mún boo o *Isirayɛɛle nìpomu tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ká le Dónbeenì màhã́ pá yí tonkaa o Elii ɓa nì-kéní woon cɔ̃́n, ká yínɔń ho Sidɔ̃n kɔ̃hṹ lóhó ɓúi na ɓa le Sarɛputaa mahã́a mí dòn cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɓa ɓùeréwà mún hĩ́a boo o Isirayɛɛle nìpomu tĩ́ahṹ le Dónbeenì ɲi-cúa fɛɛro Elize pã̀ahṹ, à ɓa nì-kéní woon ó o ɓúi sãnía yí wan ká yínɔń o Siirii nìi Naaman mí dòn.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hɔ̃́n bíoní so bío vaa véeníi, à bṹn à bìa wi le zĩi yi ɓúenɓúen hĩ́nɔn yòó dĩ̀n lé le sĩ-cĩ̀ílè. ");
INSERT INTO boxNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lé bṹn ɓa dɛ̀ɛnía wìira a wán, á vá lóráa lée líikaa lóráa ho lóhó mɔ́n, á vaá yòora le ɓúee mu na ho lóhó son wán ɓàn ɲún-tĩ́ahṹ le mí ì dón wo ò dé ho kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ó o dĩ̀ndĩ̀n fó míten ɓa níní yi á lée wà ò o día ɓa. ");
INSERT INTO boxNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bṹn mɔ́n ó o wà van ho Kalilee lóhó, hìa ɓa le *Kapɛɛnayuumu. Ká ɓa *zúifùwa vũńló wizonle na ɓa le *Sabaa dɔ̃n, ò o kàrán ɓa ɓa kàránló zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Á bìa ɲá a bíoní wó coon làa sòobɛ́ɛ lé bìo ó o bíoní pànká wi binbirì. ");
INSERT INTO boxNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu zoǹ ò o nìi ɓúi na ó o cĩ́ná wi yi á wi ɓa kàránló zĩi mu yi. Á wón zoó bía bìo kà pɔ̃́npɔ̃́n: ");
INSERT INTO boxNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Éee! Nazarɛɛte nìi Yeesu, lée webio á ũ wà ɓueé cà wa cɔ̃́n hen? Fo ɓuara wa yáaró bìo yi lée? Ɓa le ĩ yí zũ fo le? Ũnɛ́n lé yìa lé le Dónbeenì nùpue na le tonkaa.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ó o Yeesu nàmakaa wo yi: «Wé tɛ́tɛ́, lé o nìi mu yi lònbìo!» Ó o cĩ́ná mu dɛ̀ɛnía fó a dó ho tá yi ɓa nùpua na wi bĩ́n ɓúenɓúen tĩ́ahṹ ò o ló a yi ká a màhã́ yí yú a yí ɓóonía yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Á bìa kɛra bĩ́n na mɔn mu wéró bán ɓúenɓúen zɔ̃́nkaa kará concáan. Cúa-yɛn, à ɓa yèrèmáa wee bío mín yi: «Pátì! Dìo kà lé le bíonì yɛ́n síi kà? O nùpue mu wee na le ɲii ɓa cĩ́náwa yi lè ho pànká, à ɓa máa dàń kán wo ká ɓa dɛ̀ɛní wé bìo ó o le ɓa wé.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ó o Yeesu yèni dɛ̀ɛnía ló hã lórá na bã́makaa bĩ́n ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bìo ó o zoó ló ho kàránló zĩi, ó o térénna van o Simɔn zĩi. O vaa dɛ̃ɛníi à bṹn ɓa wee bío làa wo le o Simɔn ɓàn hio hã́a le tɛ̀ɛnì wee zɛ̀ɛ́. Á ɓa fìora a le o wɛɛ́ wo. ");
INSERT INTO boxNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ó o vaá zon á lií lúnlúrá a ɲúhṹ yi ò o bía le le tɛ̀ɛnì lé o yi, á le dɛ̀ɛnía ló. Mí lahó yi ó o hĩ́nɔn nɔn ho dĩ́nló ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bìo le wii lií zon, á bìa ɓúenɓúen na ɓa vánvárowà lè mí sìíwà wi cɔ̃́n á ɓuan ɓa ɓuararáa. Ó o bò mí níní ɓa nì-kéní kéní wán á ɓa wan. ");
INSERT INTO boxNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɓa nùpua cɛ̀rɛ̀ɛ na ɓa cĩ́náwa wi yi á ɓa wee lé yi ká ɓa a bío pɔ̃́npɔ̃́n: «Ũnɛ́n lé yìa lé le Dónbeenì Za.» Ká a Yeesu wón màhã́ wee zá làa ba le ɓa yí bío. Lé bìo ɓarɛ́n mí bɛɛre yàá zũ mu le o lé *Yìa le Dónbeenì mɔn léra. ");
INSERT INTO boxNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bṹn ɓàn tá lée tɔ̃n yìnbíi bùirìi, ó o Yeesu hĩ́nɔn khɛ̀ra ló van le lùe ɓúi na a nùpue mía yi, á vaá kará mí dòn. Bìo ɓa nùpua sĩ̀na yí mɔn wo, á ɓa wee cànka a. Bìo ɓa vaá yú a, á ɓa wã́a yí wi à ɓa bĩní día ò o khɛ̀n làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ó o Yeesu bía nɔn ɓa yi: «Ó, o! Ĩ mún ko à ĩ va hã lórá na ká yi à vaa bue le *Dónbeenì bɛ́ɛnì bín-tente bĩ́n, lé bìo á bṹn lé bìo le Dónbeenì tonkaa mi bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ò o hĩ́nɔn wà, á vaá wee bue le bín-tente ɓa *zúifùwa kàránló zĩní yi ho *Zudee kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wizonle ɓúi ká a Yeesu wi ho Zenɛzarɛɛte vũ-beenì ɲii á ɓa zã̀amáa kĩ́nía yi wee ɲàa mín, lé bìo ɓa wi ɓa ɲí le Dónbeenì bíonì, ó o mɔn hã wonna bìo ɲun ká hã dĩ̀n mín nìsã́a mu ɲumu ɲii. ");
INSERT INTO boxNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɓa ce-pawà na zon hã ɓuararáa ɓúenɓúen ló lée dĩ̀n wee sɛɛ mí zùánwà. ");
INSERT INTO boxNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hã wonna mu ɓàn dà-kéní lé o Simɔn te ho, á hón lé hìa ó o Yeesu fìora zon, ò o bía nɔn wo yi le o ɲàa zo mu ɲumu yi cĩ́inú, bṹn mɔ́n ó o lií kará ò o wee kàrán ɓa zã̀amáa na dĩ̀n bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pã̀ahṹ na ó o bía vó yi, ó o khíi wee bío là a Simɔn: «Wã́a vá zo mu ɲumu na boo yi, à ũnɛ́n lè mí ninzàwa na páanía wee sá à yénní mí zùánwà kúee mu ɲumu yi à mi wìika ɓa cewà.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ó o Simɔn bía làa wo: «Éee! Ũnɛ́n! Loń! Wa púia mu ɲumu yi cãana à wa yí fò hàrí ceza. Ɛ̀ɛ ká ũ bíonì ɲii wán, á ĩ yénní hã á à kúee.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Á ɓa yénnía hã kúaa mu ɲumu yi á hã lií vũn ɓa cewà cɛ̀rɛ̀ɛ, lée cĩ́inú ká hã zùánwà hũni lá à fáa. ");
INSERT INTO boxNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Á ɓa von mí ninzàwa ce-pawà na wi ho won-veere yi le ɓa ɓuee séení mí. Á bán ɓuara ɓueé séenía ɓa á hã wonna mí bìo ɲun sú lè ɓa cewà fúaa hã wi hã lii lí mu ɲumu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bìo ó o Simɔn Piɛre mɔn mu kà síi, ó o lií ɓúrá a Yeesu tá ò o bía nɔn wo yi: «Ɓúi! Ɲúhṹso, ĩ yàá ɓɛ̀ntĩ́n lá yí ko à ĩ sùará foǹ lé bìo á ĩ lé o bè-kora wéro.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","O Simɔn wee bío kà síi lé bìo ɓa ce-kuii na ɓa vũn kà bìo zã́nía wo dàkhĩína, orɛ́n làa bìa páanía wi ho woohṹ yi làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hàrí o Zebedee nùwã Zaaki làa Zãn na mún lé ɓa ce-pawà, bán mún zã́na lè ɓa bìo síi. Ó o Yeesu bía nɔn o Simɔn mu yi: «Áyì! Yí zɔ̃́n dɛ̀ɛ woon. Lii hĩ́ní. À lá ho zuia ɲii wán, á ɓa nùpua lé bìa fo wé è yí á à ɓua à ɓuennáa ĩ cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bṹn mɔ́n á ɓa vá mí wonna ɓueé dĩ̀nía mu ɲumu ɲii, à ɓa kúará mí bìo ɓúenɓúen bĩ́n, à ɓa bò là a Yeesu wà. ");
INSERT INTO boxNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wizonle ɓúi ká a Yeesu wi ho lóhó ɓúi yi, ó o fò mín là a *ɓùeré nìi ɓúi. Bìo ó o mɔn o Yeesu ó o dɛ̀ɛnía lií ɓúrá à yahó á ɓuure ɓó ho tá yi. Ò o fìora a yi kà: «Ɲúhṹso! Fo dà à wɛɛ́ mi ká fo tà.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ó o Yeesu lií bò mi níi o wán ò o bía nɔn wo yi: «Ĩ tà mu, wã́a wa.» Mí lahó yi ó o nìi dɛ̀ɛnía wan. ");
INSERT INTO boxNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bṹn mɔ́n ó o Yeesu henía bìo kà làa sòobɛ́ɛ nɔn wo yi: «Bìo wo foǹ á ũ yí bío le nùpue ɲí. Ká ũ màhã́ vaa zéení ũten lè le *Dónbeenì yankaro. À ũ mún wé mu hãmu bìo na ó o *Mɔyiize bò le ɓa wé wé mu dã́ní yi à ɓa ɓúenɓúen zũń ká ũ wan bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ká bṹn yí hò bìo ɓa wíokaa wee bío o Yeesu bìo hã lùa ɓúenɓúen yi. Á ɓa nùpua cɛ̀rɛ̀ɛ wee vá kúee mín wán à ɲínáa o bíoní à mún ɓua mí vánvárowà lè mí sìíwà à ɓuennáa ó cɔ̃́n le o wɛɛ́. ");
INSERT INTO boxNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ká a Yeesu wón màhã́ wee wé wé ká a lɛ́n mí dòn vaa fìo le lùe ɓúi na wan ɓúirín yi ká a bĩní ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wizonle ɓúi ò o Yeesu wee kàrán ɓa nùpua. Mu nɔ̀nzoǹ ká ɓa *Farizĩɛwa lè ho *làndá bìo zéenílowa wi bĩ́n á kará ɓó a yi. Ɓa ló ho Kalilee lè ho *Zudee lórá cɛ̀rɛ̀ɛ yi. Ɓa ɓúi yàá pá ló ho Zeruzalɛɛmu lóhó yi. O Ɲúhṹso Dónbeenì pànká na wi o Yeesu yi lé hìa nɔn ó o wee wɛɛ́ráa ɓa vánvárowà. ");
INSERT INTO boxNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yìo ɓuee tĩ, à nùpua ɓúi sò mí mùamúa luaráa ká a wi mí dãmu dɛ̀ɛ wán. Bìo ɓa ɓueé dɔ̃n á ɓa wi ɓa zo le zĩi yi làa wó à zoó bàrá a Yeesu yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Á ɓa wó fúuu san lé bìo ɓa nùpua boo dà. Á ɓa día ɓa yòora làa wó le zĩi mu lòho, á yòó kara ho sɔ̃́n-kéní à ɓa can hã hũni o mùamúa mu dãmu dɛ̀ɛ yi á liinía làa wó lií bàrá a Yeesu yahó bìa wi bĩ́n ɓúenɓúen tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bìo ó o Yeesu mɔn bìo ɓa dóráa mí sĩa wo yi, ó o bía nɔn o mùamúa yi: «Wàn bɔ̃́nlo, ũ bè-kora sɛ́ra día.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bìo ó o bía bṹn kà á ho làndá bìo zéenílowa lè ɓa Farizĩɛwa á wee bío mí yiwa: «O nùpue mu lée wée á wee màní míten lè le Dónbeenì kà síi? Lé wée dà a sɛ́n mu bè-kora á à día ká yínɔń le Dónbeenì mí dòn.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ká a Yeesu màhã́ zũna ɓa yilera ó o bía nɔn ɓa yi: «Lée webio nɔn á hã yilera na kà síi wiráa mia? ");
INSERT INTO boxNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lé mu yɛ́n bíoró wayi? Lé à bío le o bè-kora sɛ́ra día lée tàá lé à bío le o hĩ́ní varáka? ");
INSERT INTO boxNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ká ĩ màhã́ wi á mi zũń le o *Nùpue Za yú ho pànká ho tá wán à sɛ́nnáa mu bè-kora día.» Ò o wã́a bía bìo kà nɔn o mùamúa yi: «Le ĩ bío mu na foǹ, lii hĩ́ní, lá ũ dãmu dɛ̀ɛ á ũ khíɓo.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ó o nìi mu dɛ̀ɛnía hĩ́nɔn yòó dĩ̀n bṹn wán ɓa ɓúenɓúen yìo yi á lií lá mí dãmu dɛ̀ɛ ò o wee ɓùaaní le Dónbeenì ká a wà ɲɔn mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Á ɓa ɓúenɓúen wó coon mu bìo yi. Á ɓa zã́na à ɓa pá wee khòoní le Dónbeenì kà síi: «Wa ɓɛ̀ntĩ́n mɔn yéréké bè-bárákáwá zuia.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bṹn mɔ́n ó o Yeesu ló lée wà. O vaá wee khĩí ó o mɔn o lànpó fé ɓúi na ɓa le Levii ká a kará mí tonló lùe yi. Ó o bía nɔn wo yi: «Hĩ́ní bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ó o Levii dɛ̀ɛnía hĩ́nɔn día mí tonló lè mí bìo ɓúenɓúen, ò o bò a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","O Levii sá ho dĩ́nló o Yeesu bìo yi, ò o von wo mí zĩi. O mún von ɓa nùpua ɓúi ɓa ɓueé páanía kará wee dí. Ɓa cɛ̀rɛ̀ɛ lé ɓa ninzàwa *lànpó féwá. ");
INSERT INTO boxNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Á bìo ɓa Farizĩɛwa lè ho làndá bìo zéenílowa na bìo sã̀ ɓa yi mɔn mu á ɓa wee khí mí kío yi. Á ɓa tùara a Yeesu nì-kenínia yi: «Lée webio nɔn á mi pá tà wee dí ká mi ì ɲu lè ɓa lànpó féwá lè ɓa nì-kora na kà?» ");
INSERT INTO boxNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ó o Yeesu bía nɔn ɓa yi: «Héyìi! Minɛ́n! Nùpua na lò hereka so wee wé cà tĩni ɓànso dã́ní le? Ɓùeé, ɓa vánvárowà lé bìa wee wé cà a dã́ní. ");
INSERT INTO boxNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ĩnɛ́n yí ɓuara bìa wee leéka le mí térénna bìo yi dɛ́. Bìa zũ le mí lé ɓa bè-kora wérowà lé bìa á ĩ ɓuara bìo yi, bèra a na à ɓa khí mu bè-kora wéro yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bṹn mɔ́n á ɓa nùpua ɓúi tùara a Yeesu yi: «O Zãn nì-kenínia wee wé lì mí ɲiní à mún wé mí fìoró, á ɓa Farizĩɛwa nì-kenínia mún wee wé kà síi. À ũnɛ́n nùpua bán ɓɛ̀n wee dí ká ɓa a ɲu lée webio?» ");
INSERT INTO boxNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ó o Yeesu bía nɔn ɓa yi: «Mi yí mɔn le: Pã̀ahṹ na ɓa nùpua wi mu yaamu sã́nú díró yi là a hã́-fĩa ɓàn báa á ɓa so dà à bío le ɓa lì mí ɲiní le? ");
INSERT INTO boxNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ho pã̀ahṹ ɓúi khíi dã ó o hã́-fĩa ɓàn báa ɓa a lén ɓa tĩ́ahṹ, bṹn ká ɓa màhã́ wé è lì mí ɲiní.» ");
INSERT INTO boxNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ó o mún bĩnía wà le wàhiire na kà nɔn ɓa yi: «Nùpue na a lá mí báká fĩnle á à kúii bìo ɓúi á à la lè mí báká kĩ́nle na lɛ̀ɛra wón mía. Lé bìo ká a wó mu, á ho dà-fĩnle á à yáa. Á bìo lan mín yi mún máa wìi mín. ");
INSERT INTO boxNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Làa bṹn síi, nùpue máa kúee *dìvɛ̃́n fĩa sṹmàni-kĩ́a yi. Lé bìo ká a kúaa ho bĩ́n ká ho hĩ́a wee za, á hã à nàma, á ho dìvɛ̃́n á à kúia, á hã sṹmàniwa mún ǹ yáa. ");
INSERT INTO boxNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ho dìvɛ̃́n fĩa ko ho kúee hã sṹmàni-fĩa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Á nùpue mún máa día dìvɛ̃́n kĩ́a ká a máa ɲu dìvɛ̃́n fĩa. Lé bìo á ɓa wee bío le ho dìvɛ̃́n kĩ́a lé hìa sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mu wó ká a Yeesu wee kã́a hã mana ɓúi yi ho *vũńló wizonle na ɓa le Sabaa zoǹ, ó o nì-kenínia wee báará zoo khé ho dĩ́nló lée pùká là. ");
INSERT INTO boxNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Á ɓa *Farizĩɛwa ɓúi mɔn mu á ɓa wee bío làa ba: «Lée webio nɔn mí wee wéráa bìo kà? Wa làndá hò mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ó o Yeesu bía nɔn ɓa yi: «Bìo ó o *Daviide yánkaa wó ká arɛ́n lè mí nùpua á le hĩni dà á mi dĩǹ yí kàránna yí mɔn le? ");
INSERT INTO boxNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Orɛ́n míten zon le Dónbeenì zĩi á zoó lá le Dónbeenì hãmu búurú á là, ò o ɓuan ho ɓúi lée nɔn bìa làa wó bò mín yi. Ká a ɲɔǹ lá yí ko ò o wé mu, lé bìo le *Dónbeenì yankarowà mí dòn lé bán wee wé là ho.» ");
INSERT INTO boxNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ò o tĩ́n pá bĩnía bía nɔn ɓa yi: «O *Nùpue Za lé yìa á ho Sabaa bìo wi níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ho Sabaa mu ɓúi zoǹ ó o Yeesu van ho kàránló zĩi yi á vaá zoó wee kàrán ɓa nùpua. Mu zoǹ à nìi ɓúi wi bĩ́n á nín-tĩánì bàhó húrun. ");
INSERT INTO boxNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Á ho *làndá bìo zéenílowa lè ɓa Farizĩɛwa bò mí yìo o Yeesu wán le mí ì loń ká a pá à wɛɛ́ nùpue ho Sabaa zoǹ, lé bṹn ɓa à dĩ̀n wán á à yíráa wo ò kooní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ó o Yeesu zũna ɓa yilera ò o pá bía nɔn o nìi na bàhó húrun yi: «Lii hĩ́ní vá ɓueé lée dĩ̀n hen kà ɓa nùpua yahó le ɓa mi fo.» Ó o nìi lií hĩ́nɔn á vá ɓueé lée dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ó o Yeesu bía làa ba: «Le ĩ tùa mia làa bìo ɓúi: Lé mu yɛ́n ó o nùpue ko ò o wé ho Sabaa zoǹ? Lée bè-tente lée, tàá lée bè-kohó? Lé ho kã̀ní a nùpue lée, tàá lé ho ɓúe o?» ");
INSERT INTO boxNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ò o Yeesu lora ɓa ɓúenɓúen yi khíi fò ò o bía nɔn o nìi yi: «Hóoní ũ bàhó.» Ó o nìi hóonía ho á ho dɛ̀ɛnía wan. ");
INSERT INTO boxNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Á ho làndá bìo zéenílowa lè ɓa Farizĩɛwa sĩa cã̀ mu yi làa sòobɛ́ɛ, á ɓa wee wã̀aní mín yi: «Lée webio á wa yàá à wé á à yíráa wo ò fì níi yi coon?» ");
INSERT INTO boxNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wizonle ɓúi ó o Yeesu hĩ́nɔn le mí yòó wé mí fìoró le ɓúee wán, ó o yòó fìora le Dónbeenì yi bĩ́n fúuu cãana. ");
INSERT INTO boxNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bìo ho tá tɔ̃n, ó o von mí nì-kenínia kúaa mín wán, á hueekaa ɓa pírú ɲun ɓa tĩ́ahṹ á có yèni làa tonkarowà. Hĩ̀a kà lé ɓa yènnáa: ");
INSERT INTO boxNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","O Simɔn na ó o có yèni làa Piɛre, o Ãndere na lé o Simɔn mu ɓàn za, o Zaaki là a Zãn, o Filiipu là a Baatelemii, ");
INSERT INTO boxNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","o Matiye là a Toma, o Alifee za Zaaki, o Simɔn na lé ɓa Zelootewa kuure nùpua nì-kéní, ");
INSERT INTO boxNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","o Zaaki za Zudaa, là a Zudaa Isikariote na khíi dé o Yeesu o zúkúsa níi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bṹn mɔ́n, ó o Yeesu bĩnía bò lè mí nì-kenínia lion ho tá pɛ̀ɛrú yi hen na ó o mɔ́n-bèwa cɛ̀rɛ̀ɛ dĩ̀n yi. Ɓa minka zã̀amáa mún wi bĩ́n. Ɓa ló ɓa *zúifùwa kɔ̃hṹ kùaráa ɓúenɓúen yi, ho Zeruzalɛɛmu lóhó, lè ho Tiire lè ho Sidɔ̃n lórá na wi mu yámú ɲumu ɲii ló-zàwa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓa ɓúenɓúen wà ɓuee ɲí a Yeesu cɔ̃́n á mún ǹ cànka ò o wɛɛ́ ɓa vɛ̃́ɛna. Bìa ɓa cĩ́náwa wee beé lò wee yí míten. ");
INSERT INTO boxNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓa nùpua ɓúenɓúen wee cànka à ɓa yí o túii yi, lé bìo le Dónbeenì pànká na wi o yi á wee lé lée wɛɛ́ ɓa nùpua ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ó o Yeesu wã́a yòó lora mí nì-kenínia yi ò o bía: «Minɛ́n na lé ɓa nì-khenia, mi ɲúná sĩ, lé bìo le Dónbeenì bɛ́ɛnì á mi níní wi yi! ");
INSERT INTO boxNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Minɛ́n na le hĩni wee ɓúe ho zuia, mi ɲúná sĩ, lé bìo á bìo mi wee ca á mi ì yí á mu ɲii ì sí! Minɛ́n na wee wá ho zuia, mi ɲúná sĩ lé bìo mi khíi dĩ hã konsĩní! ");
INSERT INTO boxNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Ká ɓa nùpua khíi ɲina mia, á pã́ mia, á wee là mia, á wee yáa mi yèni o *Nùpue Za bìo yi, se mi ɲúná sĩ. ");
INSERT INTO boxNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mi zã̀maka à wé coronka lé bìo le Dónbeenì bũ̀iá beenì pan mia ho wáayi mu bìo yi. Mu bon, lé kà síi á ɓarɛ́n ɓàn ɓùaawa mún yánkaa beéraráa le *Dónbeenì ɲi-cúa fɛɛrowà lò. ");
INSERT INTO boxNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ɛ̀ɛ ká minɛ́n nàfòró ɓànsowà á ho yéréké khíi sá yi, lé bìo á mu bìo ɓúenɓúen mí yú vó, á bìo máa bĩní máa bè mu wán máa na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Minɛ́n na wee dí bùubaa ho zuia á ho yéréké khíi sá yi, lé bìo á bìo cɛ̀rɛ̀ɛ hĩni khíi tè mia. Minɛ́n na wee dĩ hã konsĩní ho zuia á ho yéréké khíi sá yi, lé bìo mí bìo khíi wé ho yahó sèró lè le wɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Minɛ́n na ɓa nùpua wee wíoka yèni á ho yéréké khíi sá yi, lé bìo á lé kà síi á ɓàn ɓùaawa mún yánkaa wó làa bìa fù le mí lé le Dónbeenì ɲi-cúa fɛɛrowà ká mu ɲɔǹ yí bon. ");
INSERT INTO boxNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Àwa, minɛ́n na wã́a dĩ̀n wee ɲí ĩ cɔ̃́n ɓúenɓúen lé minɛ́n á ĩ wee bío bìo kà a na yi: Mi wań mi zúkúsa. Bìa ɲina mia à mi wé mu bè-tentewà na yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bìa wee dánkání mia à mi wé dúɓua yi. Bìa wee yáa mi yèni à mi wé fìo na yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hàrí ká a ɓúi dó ũ sáahó yi, à ũ yèrèmá hìa so dá a yi. Ká a ɓúi fó ũ kánɓun, à ũ mún día le o fé ũ báká. ");
INSERT INTO boxNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yìa fìora bìo ũ cɔ̃́n, ũ na mu wo yi. Yìa lá ũ bìo, à ũ día le o ɓua. ");
INSERT INTO boxNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bìo mi wi à ɓa nì-vio wé na mia, à mi wé mu ɓàn síi à na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ká bìa wa mia lé bán mí dòn á mi wa, á mi wee leéka le mi so pá à bĩní ì yí bìo mu mɔ́n le? Hàrí ɓa bè-kora wérowà mún wa bìa wa ɓa. ");
INSERT INTO boxNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ká bìa wee wé mu bè-tentewà na mia lé bán mí dòn mi wee wé mu ɓàn síi na yi, á mi wee leéka le mi so pá à bĩní ì yí bìo mu mɔ́n le? Hàrí ɓa bè-kora wérowà mún wee wé bṹn. ");
INSERT INTO boxNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ká bìa khíi dàń mu á à wĩ́ mia, lé bán mí dòn á mi wee ke lè mí bìo, á mi wee leéka le mi so pá à bĩní ì yí bìo mu mɔ́n le? Hàrí ɓa bè-kora wérowà mún wee ke mín bìowa làa mín làa bṹn síi à paráa mu khíi wĩ́ló. ");
INSERT INTO boxNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɛ̀ɛ ká minɛ́n yí wé bṹn. Mi wań mi zúkúsa, mi wé wé mu bè-tente na ɓa yi. Ká nùpue kon ũ bìo, ũ yí dé ũ sĩi mu khíi bĩní wĩ́ló yi. Lé bṹn ǹ na ká mi ì wé le Dónbeenì na wi mu bìo ɓúenɓúen ɲúhṹ wán zàwa, lé bìo á ɓa bè-yízũńlowà lè ɓa nì-sũmáa á le wee wé mu bè-tentewà na yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mi zũń le hii wéró làa bìo á mìn Maá Dónbeenì zũnáa le hii wéró bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Mi wé yí cítí nùpue, á le Dónbeenì mún máa cítí mia. Mi yí síiní nùpue ɲúhṹ, á le Dónbeenì mún máa síiní mí ɲúná. Mi wé sɛ́n día na mín yi, á le Dónbeenì mún wé è sɛ́n ǹ día á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mi wé hã mu bìo, á le Dónbeenì mún wé è hã mia. Mu bìo na le Dónbeenì á à hã làa mia á à wé bìo na à kúee mí dɛ̀ɛ yi á à dìdíi fúaa ká mu sú cáa pùuu. Lé bìo le wĩ̀ló dɛ̀ɛ na mi wee mɔ̀nzã́ lè mu bìo, lé dén ɓàn síi á le Dónbeenì á à mɔ̀nzã́ lè mí bìo á à na mia.» ");
INSERT INTO boxNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O bĩnía wà le wàhiire na kà: «Muii so dà a tè mí ninza muii bũ̀ini wán le? Ɓùeé. Lé bìo ká ɓa vaá dɔ̃n ho kɔ̃hṹ á ɓa mí nùwã ɲun á à páaní ì zo ho. ");
INSERT INTO boxNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nì-kenínii na po yìa wee kení a wón mía. Nùpue lée nùpue na kenía dɔ̃n ó o dà à wé làa yìa kenía wo bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Lée webio nɔn á le zóore na wi ũ yère yi á fo yí zũ bìo, à le zàn-dɛ̀ɛ na wi mi ninza yère yi á fo màhã́ mɔn wee zéení? ");
INSERT INTO boxNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Fo dà a wé kaka à bío le mi ninza día le ũ lén le zàn-dɛ̀ɛ na wi o yère yi, ká le zóore na wi ũnɛ́n yère yi á fo yí zũ bìo le? Yí mɔn ũten na le! Le zóore na wi á ũ yère yi lé dìo á ũ ko à ũ lén vé, á ũ yìo màhã́ à mi wéréwéré á à dàń ǹ lénnáa le zàn-dɛ̀ɛ na wi mi ninza yère yi. ");
INSERT INTO boxNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Vĩ̀ndɛ̀ɛ na se máa wé ha bia na yí se, á le vĩ̀ndɛ̀ɛ na yí se mún máa wé ha bia na se. ");
INSERT INTO boxNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mu bon, le vĩ̀ndɛ̀ɛ bia lé hɔ̃́n ɓa wee wé bè yi à zũńnáa le sìí. Lunkúnsòró máa wé fáa ɓódíohó wán. Á ɲia mún máa wé khé kíkahó wán. ");
INSERT INTO boxNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","O nùpue na se wón wee wé bío hã bín-tentewà lè bìo á bìo wi o sĩi yi se. Ká yìa yí se wón wee wé bío hã bín-kora, lé bìo á bìo wi o sĩi yi yí se. O nùpue bìo na wi o sĩi yi, lé bṹn wee wé lé là a ɲii. ");
INSERT INTO boxNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mi wee ve mi le ‹Ɲúhṹso! Ɲúhṹso!› à mi màhã́ yí máa wé bìo á ĩ wee bío na mia á mu ɲúhṹ so wi le? ");
INSERT INTO boxNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi dĩ̀n le ĩ zéení a nùpue na wee ɓuen ĩ cɔ̃́n, à ɲí ĩ bíoní, à mún bè hã yi bìo ó o bìo ɓonnáa mín làa mia. ");
INSERT INTO boxNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","O bìo ɓonmín làa nùpue ɓúi na le mí ì so mí zĩi ó o náana ho tá á líi ɓó le huee yi a màhã́ bò yi fáráráa le ɲúhṹ. Hã vi-beera tèró pã̀ahṹ á mu ɲun-beenì ɓueé dèkío le à le pá dĩ̀n. Le yí tò lé bìo le ɲúhṹ fárá se. ");
INSERT INTO boxNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɛ̀ɛ ká yìa wee ɲí ĩ bíoní ò o yí máa bè hã yi, wón ɓànso bìo ɓonmín làa nùpue ɓúi na fárá mí zĩi ɲúhṹ ho tá kã́amáa yi á son. Bìo ho vi-beenì tò á mu ɲun-beenì ɓuara ɓueé ɓó le yi, à le dɛ̀ɛnía tò pùpɛ̀.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bìo ó o Yeesu bía hɔ̃́n bíoní so ɓúenɓúen á nɔn ɓa zã̀amáa yi vó, ó o wà van ho *Kapɛɛnayuumu. ");
INSERT INTO boxNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mu pã̀ahṹ ká ho *Oroomu dásíwá ɲúhṹso ɓúi wi bĩ́n á ton-sá nì-kéní na ó o ɓɛ̀ntĩ́n wa làa sòobɛ́ɛ á lò yí here día mu húmú ɲii wán. ");
INSERT INTO boxNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bìo ɓa dásíwá ɲúhṹso mu ɲá a Yeesu bìo, ó o tonkaa ɓa *zúifùwa nì-kĩ́a nùwã yɛn ɓúi le ɓa vaa fìo wo le o ɓuee wɛɛ́ mí ton-sá. ");
INSERT INTO boxNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Á bán wà van o Yeesu cɔ̃́n á vaá wee ɓónɓóní a ká ɓa à bío làa wo: «O nìi mu na tonkaa wɛn ɓɛ̀ntĩ́n ko lè ũ séeníi, ");
INSERT INTO boxNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","lé bìo ó o wa wa nìpomu. Orɛ́n lé yìa léra mí níi yi á séenía wɛn á sonnáa wa kàránló zĩi.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ó o Yeesu dɛ̀ɛnía bò làa ba á ɓa wà. Bìo ɓa vaá sùaráa o nìi mu zĩi à bṹn ò o tĩ́n tonkaa mín bɔ̃́nlowà le ɓa lée bío na a yi: «Ɲúhṹso, yí sɛɛ́ ũten ĩ bìo yi. Ũ ɓuenló ĩ zĩi yi lée bìo na á ĩ yí koráa. ");
INSERT INTO boxNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Lé bṹn bìo yi á ĩ yí heníanáa ĩ sĩi á yí ɓuara ũ cɔ̃́n ĩten. Na le ɲii á ĩ ton-sá pa à wa. ");
INSERT INTO boxNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ĩnɛ́n ĩ bɛɛre ɲúnása wi á ĩ wee bè bíoní yi. Á ĩnɛ́n mún wi ɓa ɓúi ɲúhṹ wán, á bán mún wee ɲí ĩ cɔ̃́n. Ĩ le yìa va hen à wón va bĩ́n, ĩ le o ɓúi ɓuen ò o dɛ̀ɛní ɓuen. Ĩ le ĩ ton-sá wé bìo na, ò o dɛ̀ɛní wé mu mí lahó yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bìo ó o Yeesu ɲá hɔ̃́n bíoní so, ó o wó coon o nìi mu bìo yi, ó o yèrèmáa khíi bía lè ɓa zã̀amáa na bò a yi: «Le ĩ bío na mia: O *Isirayɛɛle nìpomu ɓúenɓúen yi á ĩ dĩǹ yí fò mín làa nùpue na sĩidéró miì yú yìa kà yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Á ɓa dásíwá ɲúhṹso ɓàn bɔ̃́nlowà bĩnía khíɓon á vaá yú ò o ton-sá mu wan. ");
INSERT INTO boxNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bṹn mɔ́n ó o Yeesu wà wee va ho lóhó ɓúi na ɓa le Naɲɛɛ. Ó o nì-kenínia lè ɓa zã̀amá-kúii bò làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bìo ó o vaá dɔ̃n ho lóhó ɲii, ó o fò mín làa nùpua ɓúi à ɓa ɓuan mí nì-hío wà vaá nùu. Yìa húrun lée mahã́a ɓúi te mí za kéní. Ho lóhó nùpua cɛ̀rɛ̀ɛ ló á bò là a hã́a mu. ");
INSERT INTO boxNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bìo ó o Ɲúhṹso mɔn o hã́a mu ó o màkárí ɓuan wo yi. Ó o bía làa wo: «Hã́a mu, yí yáa ũ yilera.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ò o wà vaá ɓó ɓa yi á lá mí níi bò le khã̀are wán á bìa ɓuan o nì-hío dĩ̀n. Ó o Yeesu bía: «Yàrónza, lii hĩ́ní, lé mi bía mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ó o dɛ̀ɛnía lií hĩ́nɔn yòó kará wee bío. Ó o Yeesu hóonía wo yòó dó ɓàn nu níi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Á bìa wi bĩ́n ɓúenɓúen zã́na á ɓa wee khòoní le Dónbeenì kà síi: «Yìa kà màhã́ lé le *Dónbeenì ɲi-cúa fɛɛro binbirì á wa yú. Le Dónbeenì ló ɓuara á wà ɓueé fení mí nìpomu.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","O Yeesu bìo na ó o wó kà dɛ̀ɛnía ɲá ɓa *zúifùwa kɔ̃hṹ ɓúenɓúen yi á dà khíi zon hĩ̀a làa ba ɓó mín yi mún. ");
INSERT INTO boxNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","O Zãn Batiisi nì-kenínia vaá bía bìo wó ɓúenɓúen á nɔn wo yi. Bṹn mɔ́n ó o von ɓa nùwã ɲun ɓúi ɓa tĩ́ahṹ ");
INSERT INTO boxNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","á tonkaa le ɓa vaa tùa o Yeesu yi: «Ũnɛ́n lé yìa á wa ɲá bìo le fo ko ũ ɓuen lée, tàá wa pá ko à wa lòoní nì-veere?» ");
INSERT INTO boxNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Á bán wà vaá yú a Yeesu á bía nɔn wo yi: «O Zãn Batiisi tonkaa wɛn ũ cɔ̃́n le wa ɓuee tùa foǹ le lé fo lé yìa ko ũ ɓuen lée, tàá wà pa nì-veere?» ");
INSERT INTO boxNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Á mu wã́a wó se à ɓa ɓueé dɔ̃n ò o lan wee wɛɛ́ ɓa nùpua cɛ̀rɛ̀ɛ na mu vã́mú lè mí sìíwà tò. O mún wee ɲa ɓa cĩ́náwa lén bìa ɓa wi yi, á mún wee hɛ́n ɓa muiiwà yìo à hã mi wéréwéré. ");
INSERT INTO boxNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bṹn wéró mɔ́n, ó o màhã́ yèrèmáa wee bío là a Zãn tonkarowà: «Mi lɛ́n vaa zéení bìo mí mɔn làa bìo mí ɲá à na a Zãn yi: Lé ɓa muiiwà yìo wee mi, á ɓa mùamúawà hĩ́nɔn wee varáka, ɓa ɓùeréwà wan, ɓa bekewà ɲikɔ̃nna wee ɲí mu bìo, ɓa nì-hía wee vèe, á le bín-tente wee bue na ɓa nì-khenia yi. ");
INSERT INTO boxNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yìa yí pã́ ĩ bìo ká a tà mu yi se wón ɓànso ɲúhṹ sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bìo ó o Zãn tonkarowà bĩnía wà, ó o Yeesu wã́a wee bío o Zãn mu bìo lè ɓa zã̀amáa kà síi: «Lée webio á mi van vaá lora le dùure yi? Lé ho konkohó na ho pinpiró wee hɛ́ɛ vĩ́nvã lée? Ɓùeé. ");
INSERT INTO boxNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Á lée webio mi vaá lora? Lée nùpue ɓúi na sĩ̀a hɔ̃̀nbɔ̃̀nɔ̀n le? Hɔ̃́n sĩ̀-sení ɓànsowà so lé ɓa pã̀amá-beera zĩní á ɓa wi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Á lé o yɛ́n mi van bìo yi? Lé le *Dónbeenì ɲi-cúa fɛɛro lée? Ká mu lé wón se mi tũ̀iá sĩ. O yàá pá po wón, le ĩ bío mu na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Orɛ́n lé yìa le Dónbeenì fèra bía bìo mí vɔ̃nna yi: ‹Ĩ ì tonka ĩ tonkaro o ò dí ũ yahó á ɓueé wíoka ũ wɔ̃hṹ.› ");
INSERT INTO boxNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Le ĩ bío mu na mia: Ɓa nùpua na ho dĩ́míɲá yi ɓúenɓúen á yìa ɲúhṹ wi po a Zãn wón mía. Ɛ̀ɛ ká le *Dónbeenì bɛ́ɛnì zàwa mɔ́n-dí màhã́ pá po a. ");
INSERT INTO boxNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Ɓa nùpua ɓúenɓúen, hàrí ho *lànpó féwá á hĩ́a wee ɓuee ɲí a Zãn cɔ̃́n. Á ɓa tà zũńna le le Dónbeenì bìo bon á ɓa wee ɓuen o cɔ̃́n ò o bátízé ɓa. ");
INSERT INTO boxNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ká ɓa *Farizĩɛwa lè ho *làndá bìo zéenílowa bán yí tà bìo le Dónbeenì le mí ì wé è na ɓa yi, á ɓa ɓɛ̀n mún pã́ à Zãn *bátɛ́ɛ̀mù bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ó o Yeesu bĩnía bía: «Ho zuia nùpua na kà á ĩ dà à tèé lè ɓa yɛ́n? Lé ɓa yɛ́n á ɓa bìo ɓonnáa mín? ");
INSERT INTO boxNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ɓa ka lè ɓa háyúwá na lée kará ɓa nùpua fèmínló lahó yi, á wee háaní na mí ninzàwa na zoó le ɓonfónii yi kà: Wa ɓúa hã sĩ̀a san, à mi le mi máa lée yo. Wa bó le yèni, á mi le mi máa wá. ");
INSERT INTO boxNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bìo ó o Zãn Batiisi ɓuara á yí máa dí dĩ́n-poni, á mún yí máa ɲu *dìvɛ̃́n, á mi le o cĩ́ná wi o yi. ");
INSERT INTO boxNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Á bìo ó o *Nùpue Za ɓɛ̀n ɓuara wee dí, á mún wee ɲu ho dìvɛ̃́n á mi mún yí tà bṹn, à mi wee bío bìo kà: ‹Mi loń! O nìi na kà yí máa wé bìo ɓúi ká mu yínɔń dĩ́nló díró làa ɲa-ɲunló. O lé ɓa *lànpó féwá lè ɓa bè-kora wérowà ɓàn bɔ̃́nlo.› ");
INSERT INTO boxNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ɛ̀ɛ ká bìa ɓúenɓúen na mu bè-zũńminì wi yi bìo bon, bán wé è wé mu bè-zũńminì mu ɓàn wárá.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wizonle ɓúi ó o Farizĩɛ ɓúi von o Yeesu le o ɓuee dí mí zĩi. Ó o Yeesu van á ɓa vaá khónkaa dũmaka wee dí. ");
INSERT INTO boxNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hón pã̀ahṹ so yi ò o hã́a ɓúi na á ho lóhó nùpua ɓúenɓúen zũ bá-fénló bìo á ɲá bìo ó o Yeesu wi o nìi mu zĩi, ó o ɓuan mí dɛ̀ɛ ɓúi na yàwá here na sú lè ho ɲiló na sãmu sĩ á ɓuararáa bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bìo ó o ɓueé zon, ó o bánbáa khíi hùerá a Yeesu mɔ́n ò o wee wá, ó o yèn-caa wee lii o Yeesu mu zení wán. Ó o ɲún-vãní lé dìo ó o wee bĩní sùuka làa hã, bṹn mɔ́n ó o wee bĩní yɛ̀ɛ hã ká a kúee ho ɲiló mu hã wán. ");
INSERT INTO boxNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Á bìo ó o Farizĩɛ na ó o wi zĩi á mɔn mu, ó o wee bío mi yi: «Yìa kà cén lá lée Dónbeenì ɲi-cúa fɛɛro kɛ̃́nkɛ̃́n, ó o lá a zũń o hã́a mu na wee lanláka a zení léeníi, là a bè-wénia.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ó o Yeesu bía nɔn wo yi: «Simɔn, ĩ ì bío bìo ɓúi á à na foǹ.» Ó o Simɔn le: «Ɲúhṹso, bío.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ó o bía làa wo: «Nùpua nùwã ɲun hĩ́a kon nàfòró ɓànso ɓúi wárí. O nì-kéní lée wɛ́n-hãani khĩá-hònú, ò o nì-kéní na so lée wɛ́n-hãani ɓúará-ɲun làa pírú. ");
INSERT INTO boxNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bìo á yìa ɓa kon le cɔ̃́n zũ à ɓa yí dà le máa wĩ́, ó o ɓó ɓa mí nùwã ɲun kení. Àwa! Ɓa nùwã ɲun mu tĩ́ahṹ, á ũ wee leéka le lé o yɛ́n ǹ wań o nìi mu á à poń mí ninza.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ó o Simɔn bía: «Ĩ wee leéka le lé yìa ó o día le kee na ɓùaa nɔn yi.» Ó o Yeesu le: «Ũ bìo bon, fo mà ho tũ̀iá.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ò o yèrèmáa khíi sánsáa o hã́a mu ò o wee bío là a Simɔn: «Fo yí mɔn le: ĩ ɓueé zon hen coon à ũ yí le ɓa ɓua mu ɲumu ɓuee sɛɛ le ĩ zení, ò o hã́a na kà wón wá siinía hã á bĩnía sùukaa lè mí ɲún-vãní. ");
INSERT INTO boxNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bìo á ĩ ɓueé dɔ̃n ũ zĩi, á ũ yí hĩ́nɔn yí wìira mi á yí yɛ̀ɛra níi, ò orɛ́n lè mí ɓuee zoró hen á ĩ zení lé hón ó o wìira lè ho yɛ̀ɛró. ");
INSERT INTO boxNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fo mún yí kúaa ɲiló ĩ ɲúhṹ wán á yí dóráa ho cùkú miì, ò orɛ́n wón lé ho ɲiló na sãmu sĩ ó o kúaa ĩ zení wán. ");
INSERT INTO boxNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lé bṹn nɔn à ĩ ì bío mu á à na foǹ: Bìo ó o hã́a mu ɓa sɛ́ra bè-kora cɛ̀rɛ̀ɛ día lé bṹn nɔn ó o waminì wárá booráa. Ɛ̀ɛ ká yìa bè-kora na sɛ́ra día ka cĩ́inú, wón waminì wárá na o ò zéení à ɓɛ̀n ǹ kɛń cĩ́inú.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bṹn mɔ́n ó o Yeesu bía nɔn o hã́a yi: «Ũ bè-kora sɛ́ra día.» ");
INSERT INTO boxNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Á bìa làa wo páanía wee dí wee bío mí yiwa: «O nùpue mu lée wée á wee hení mí sĩi à bío le mu bè-kora sɛ́ra día?» ");
INSERT INTO boxNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ó o Yeesu bía nɔn o hã́a yi: «Fo wã́a yú ho hɛ́ɛrà, hĩ́ní lɛ́n, ũ sĩidéró miì á fenía fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bṹn mɔ́n ó o Yeesu hĩ́nɔn tò hã ló-beera lè hã ló-zàwa yi á wee bue le *Dónbeenì bɛ́ɛnì bín-tente. Bìa bò làa wó lé o nì-kenínia pírú ɲun, ");
INSERT INTO boxNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","lè ɓa hã́awa nùwã yɛn ɓúi, bìa ó o ɲɔn ɓa cĩ́náwa léra yi á mún wɛɛ́ra vɛ̃́ɛna. Ɓa lé o Mari na ɓa wee ve làa Makadala Mari, yìa ó o ɲɔn ɓa cĩ́náwa bùaa hèɲun léra yi, ");
INSERT INTO boxNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","là a Kuza na ó o *Heroode bàrá mí zĩi tonni ɲúhṹ wán ɓàn hã́a Zaana, là a Suzaana. Hã́awa cɛ̀rɛ̀ɛ mún hĩ́a wi bĩ́n á séenía ɓarɛ́n á fù wee wé lén mí níi bìo à séení là a Yeesu lè mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓa nùpua hĩ́a wee léka hã lórá yi ɓuen o Yeesu cɔ̃́n. Bìo ɓa kĩ́nía wo yi boo, ó o wà le wàhiire na kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Nìi ɓúi hĩ́a ló van mí mɔhṹ yi, á wà vaá dé mí bè-dà. Bìo ó o vaá wee dé mu á mu ɓúi lée lion ho wɔ̃hṹ wán, á ɓa wã-bèwa yonkaa, à mu ɓúi á ɓa ɲínzàwa ɓɛ̀n sèekaa vã̀. ");
INSERT INTO boxNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mu ɓúi lion hã huaa yi hen na le tĩ́ní yí boo yi, á mu ló ká mu dɛ̀ɛnía bĩnía hon, lé bìo á ho hĩ́nló mía bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mu ɓúi bṹn lion hen na hã kíkara bia hɛ́ra yi, á mu ló á yòó zon mín yi làa hã, á hɔ̃́n pà mu. ");
INSERT INTO boxNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mu ɓúi bṹn lion ho tá na se yi, á mu ló á yòó dɔ̃n á han mí bia, á hã lè mí dà-kéní kéní á yú hã bia khĩmàni khĩmàni.» Bṹn mɔ́n ó o pá bĩnía bía bìo kà nɔn ɓa yi: «Yìa wee ɲí bìo, à wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ó o Yeesu nì-kenínia tùara a yi: «Le wàhiire mu kúará lé mu yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ó o bía nɔn ɓa yi: «Le Dónbeenì bɛ́ɛnì bìo na ó o nùpue yí zũ kúará á le wee zéení à ceé na minɛ́n mi dòn yi. Ká ɓa nùpua na ká wee ɲí mu lòn wàhio kã́amáa, lé bṹn nɔn á ɓa lé ɓa nùpua na yìo wi ká hã yí máa mi, á mún wee ɲí mu bìo ká ɓa yí máa zũń mu kúará. ");
INSERT INTO boxNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Le wàhiire mu kúará lé bìo kà: Mu bè-dà lé le Dónbeenì bíonì. ");
INSERT INTO boxNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bìo lion ho wɔ̃hṹ wán lé ɓa nùpua na ká ɓa ɲá le Dónbeenì bíonì à ɓa máa yí tà le yi, ká a *Satãni dɛ̀ɛní bánbá ɓuee lén le ɓa yiwa yi, à mún ti ɓa kã̀níló wɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bìo lion hã huaa na le tĩ́ní yí boo yi lé ɓa nùpua na ká ɓa ɲá le Dónbeenì bíonì à ɓa tà le yi, à zã̀maka le bìo yi, ká ho kúará lénló yú ɓa pã̀ahṹ na yi, à ɓa dɛ̀ɛní lé lè mí mɔ́n, lé bìo á le bíonì mu yí wìira ɓa sese. ");
INSERT INTO boxNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bìo lion hã kíkara yi lé bìa wee ɲí le Dónbeenì bíonì ká ɓa ɲún-sèró, lè ho dĩ́míɲá nàfòró, lè ho ɓàn sĩmu á wee hè le à le máa dàń ha hã bia na dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bìo ɓɛ̀n lion ho tá na se yi lé bìa wee ɲí le Dónbeenì bíonì à ɓua le lè le sĩi na se, dìo púaara día. Ɓa yí máa bĩní lé lè mí mɔ́n. Bṹn lé bìo nɔn á ɓa wee haráa hã bia na se. ");
INSERT INTO boxNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Nùpue na à dé le fĩ̀ntã́ní mí zĩi á à bĩní ì lá le dɛ̀ɛ ɓúi á à pe yi, tàá ká a dó le vó o ò lá le zoó bàrá mí kàtà tá wón mía. Ɓa wé dé le bàrá hen na le ko le bàrá yi, à bìa wee zo le zĩi wé mi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mu bè-sànkanii na mu khoomu khíi máa lé wán bṹn mía. Hàrí bìo kúará yí zũń ɓúenɓúen bìo khíi bío yi le wizoǹ-kéní. ");
INSERT INTO boxNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Á mi cén wé ɲí bìo wee bío na mia sese, lé bìo á yìa bìo wi á ɓa à bĩní ì na mu ɓúi wo yi á à bè mu wán. Ká yìa dɛ̀ɛ ɓúi mía, á hàrí mu bè-za bìo na ó o wee leéka le mu wi mí cɔ̃́n á ɓa pa à fé.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","O Yeesu ɓàn nu lè ɓàn zàwa ɓuara a cɔ̃́n à ɓa màhã́ yí dà máa zoó ɓúe o yi, lé bìo ɓa nùpua boo dà. ");
INSERT INTO boxNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ó o ɓúi bía mu nɔn wo yi: «Mìn nu lè mìn zàwa wi ɓa mi ũ wán, ɓa lée dĩ̀n ho khũuhũ pan fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ó o Yeesu bía nɔn bìa wi bĩ́n ɓúenɓúen yi: «Bìa wee ɲí le Dónbeenì bíonì à bè le yi, bán lé wàn nu lè wàn zàwa.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wizonle ɓúi, ó o Yeesu zon ho woohṹ lè mí nì-kenínia, ò o bía nɔn ɓa yi: «Mi wa khí lè ho vũ-beenì mɔ́n.» Á ɓa dɛ̀ɛnía zoó wà mu ɲumu yi bṹn wán. ");
INSERT INTO boxNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bìo ɓa vá zon yú, á ho pinpi-beenì hĩ́nɔn wee và lè mí pànká ho vũ-beenì wán, á mu ɲumu wee yànbón zo ho woohṹ, lònbìo à ho yòó wee sí lè mu ɲumu. Bṹn ɓúenɓúen wee wé ká a Yeesu wón mu dãmu ɓó. ");
INSERT INTO boxNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ó o nì-kenínia vaá wee sĩ̀ní a ká ɓa à bío bìo kà: «Ɲúhṹso! Ɲúhṹso! Wa à hí.» Bìo ó o sĩ̀na, ó o lií hĩ́nɔn á nàmakaa ho pinpiró lè mu ɲumu na wee yànbónka yi á mu ɓúenɓúen dĩ̀n wó tɛ́tɛ́tɛ́. ");
INSERT INTO boxNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ó o Yeesu bía làa ba: «Mi sĩ̀a déró miì wã́a wi wen?» Á ɓa ɓúenɓúen zɔ̃́nkaa dĩ̀n concáan, á wee bío mín yi: «Páa! O nùpue mu lé o yɛ́n síi kà? Hàrí ho pinpiró lè mu ɲumu ó o bíaráa, á mu pá bò a bíonì yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Á ɓa khíi dɔ̃n ho Zerasaa kɔ̃hṹ, hìa sánsáa mín lè ho Kalilee kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bìo ó o Yeesu ló ho woohṹ yi lií le mí ì dĩ̀n, à bṹn ho lóhó na ɓa wi yi nùpue ɓúi na ɓa cĩ́náwa wi yi á wee sĩ́ a yahó. O wee vará mí bírí míana. O mún yí máa da zĩi yi, lé ɓa nì-hía nùuníi ó o wee da yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Pɔ̃̀nna cɛ̀rɛ̀ɛ ká ɓa cĩ́náwa mu hĩ́nɔn o wán, à ɓa sĩ́ sa ca a níní là a zení lè hã zúakùaríwà ò o yí dàń yí va lùe. Ká a màhã́ wee khòo hã ɓúenɓúen kúia, à ɓa cĩ́náwa na wi o yi ɲa a dé hã mana yi. Ó o Yeesu nɔn le ɲii ɓa cĩ́náwa na wi o yi le ɓa lé. Lé bṹn nɔn ó o miiníi là a Yeesu mu, ó o lií ɓúrá a tá ò o wee bío bìo kà pɔ̃́npɔ̃́n: «Dónbeenì na wi mu bìo ɓúenɓúen ɲúhṹ wán Za Yeesu, lée webio á ũ lon làa mi? Sábéré, ĩ wee yanka fo, yí yáa ĩ bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bṹn mɔ́n ó o Yeesu tùara a nìi mu yi: «Ũ yèni ɓa le we?» Ó o bía: «Ĩ yèni ɓa le Zã̀amáa.» Lé bìo ɓa cĩ́náwa na wi o yi á boo dà. ");
INSERT INTO boxNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Á bán lé bìa wee yanka a Yeesu le o yí ɲa mí vaa kúee ɓa cĩ́náwa kɔ̃hṹ na nàyiló ɲii mía yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mu wee wé à nɔ̀nbùɛ-ɓoohṹ ɓúi yòó wee dí le ɓúee yi. Á ɓa cĩ́náwa mu yankaa o Yeesu le o sábéré ò o na ho wɔ̃hṹ mí yi, à mí vaa yòo zo bán yi. Ó o nɔn mu wɔ̃hṹ ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lé bṹn wán ɓa cĩ́náwa mu ló a nìi mu yi á vaá zon ɓa nɔ̀nbùɛɛní yi. Á ɓa ɓúenɓúen yòó lùwa le ɓúee wán á kùenkaa lií zon ho vũ-beenì yi á húrun. ");
INSERT INTO boxNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bìo á bìa lá wee pa ɓa mɔn bìo wó kà, á ɓa lùwa vaá bía mu nɔn bìa wi mí manawà yi, á bía mu nɔn bìa wi ho lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Á ɓa nùpua ló le mí ɓueé loń bìo wó. Bìo ɓa ɓueé dɔ̃n o Yeesu, á ɓa mɔn o nìi mu na ɓa cĩ́náwa lá wi yi, ò o wó a nì-tente á zã́ mí sĩ̀a kará a Yeesu tá. Á ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Á bìa mu wó yìo yi wee bío bìo ó o nìi mu wó wó wannáa làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ho Zerasaa kɔ̃hṹ nìpomu yi á yìa yí zã́na mu bìo mu wón mía, fúaa ɓa wee yanka a Yeesu le o sábéré ò o lɛ́n día mí. Ó o Yeesu wà vaá zon ho woohṹ le mí ì bĩní ì lɛ́n ǹ va hen na ó o ló yi, ");
INSERT INTO boxNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ó o nìi na yú míten ɓa cĩ́náwa níi yi yankaa wo le o día le mí bè làa wo. Ó o Yeesu pã́ ò o bía nɔn wo yi: ");
INSERT INTO boxNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Lɛ́n va mìn zĩi à vaa bío bìo ɓúenɓúen na le Dónbeenì wó nɔn foǹ à na ɓa nùpua yi.» Ó o nìi mu bĩnía wà á vaá wee yényéní bìo ɓúenɓúen na ó o Yeesu wó nɔn wo yi ho lóhó ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bìo ó o Yeesu bĩnía khíi dɔ̃n hen na ó o ló yi ɓuararáa, ó o khíi yú ɓa nùpua cɛ̀rɛ̀ɛ à ɓa wee zã̀maka a bĩní ɓuenló bìo yi. Ɓa ɓúenɓúen lá wee lòoní a. ");
INSERT INTO boxNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hón pã̀ahṹ so yi à bṹn ò o nìi ɓúi na lé ɓa *zúifùwa kàránló zĩi ya-dí na yèni ɓa le Zayiruusi ɓueé dɔ̃n, á ɓueé lií ɓúrá a Yeesu tá ò o wee yanka a le o bè làa mí va mí zĩi, ");
INSERT INTO boxNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","lé bìo ó o hĩ́nló yà-kéní na ó o yú á wee hí. O lúlúio wã́a lá wee yí ho pírú ɲun síi. Bìo ó o Yeesu bò làa wo wà a va a zĩi, á ɓa minka nùpua ɓura bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hã́a ɓúi wi ɓa tĩ́ahṹ á wee mi mí sɛɛró fɛ́ɛɛ á dɔ̃n hã lúlúio pírú ɲun à ho máa fĩ̀. O níi bìo yáara le tĩni ɓànsowà cɛ̀rɛ̀ɛ cɔ̃́n ká bán ɓúenɓúen màhã́ yí dàńna a yí wɛɛ́ra. ");
INSERT INTO boxNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bìo ó o vá zoó ɓó a Yeesu yi, ó o zoó tṹaa o dà-zĩ́nii ɲi-kã́ní yi là a mɔ́n. Ó o sɛɛró dɛ̀ɛnía dĩ̀n bṹn wán. ");
INSERT INTO boxNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ó o Yeesu dĩ̀n ò o tùara: «Lé o yɛ́n tṹaa miì?» Á bìa ɓó a yi ɓúenɓúen à yìa le mí yí tṹaa wo yi, à yìa le mí yí tṹaa wo yi. Ó o Piɛre lé yìa bía làa wo: «Éee! Ɲúhṹso! Fo yí mɔn bìo ɓa nùpua ɓuraráa foǹ á wee ɲàa mín le?» ");
INSERT INTO boxNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ó o Yeesu le: «Ĩ mɔn mu, ká a ɓúi màhã́ pá tṹaa miì. Lé bìo á ĩ zũna mu le pànká ɓúi ló miì.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bìo ó o hã́a mu mɔn ò o zũna a bìo ó o wà ɓuara ká a wee zàka á ɓueé lií ɓúrá a Yeesu tá, ò o zéenía bìo nɔn ó o tṹaanáa wo yi, làa bìo ó o wó wó wannáa mí lahó yi bìa wi bĩ́n ɓúenɓúen yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ó o Yeesu bía nɔn wo yi: «Wàn hĩ́nló, bìo fo dó ũ sĩi miì, lé bṹn wɛɛ́ra fo. Wã́a lɛ́n, vaa yí hɛ́ɛrà.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bìo ó o Yeesu wee bío ó o ɲii yàá yí tò, à bṹn ò o tonkaro ɓúi ló a Zayiruusi zĩi á ɲɔn o mɔ́n ɓueé dɔ̃n á ɓueé wee bío làa wo: «Ũ hĩ́nló wã́a húrun. Wã́a yí sɛɛ́ o nì-kàránlo.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bìo ó o Yeesu ɲá mu, ó o bía nɔn o Zayiruusi yi: «Yí titika, dé ũ sĩi miì, á ũ hĩ́nló á à wa.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bìo ɓa vaá dɔ̃n, ó o le bìa ká dĩ̀n ho khũuhũ, ò o Piɛre là a Zãn là a Zaaki là a hĩ́nzo-za ɓàn maá lè ɓàn nu lé bán ó o fó zonnáa le zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓa nùpua ɓúenɓúen wee wá kùaará a hĩ́nzo-za mu bìo yi. Ó o Yeesu bía: «Mi yí wá bìo. O hĩ́nzo-za mu yí húrun, o lée yìa na dũma.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Á ɓa nùpua wee zùańka a yi lé bìo ɓa zũ kɛ̃́nkɛ̃́n le o húrun. ");
INSERT INTO boxNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ó o Yeesu lii fù a níi yi, ò o von wo pɔ̃́npɔ̃́n: «Ĩ hĩ́nló, lii hĩ́ní.» ");
INSERT INTO boxNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ó o vèera á dɛ̀ɛnía lií hĩ́nɔn. Ó o Yeesu bía le ɓa na mu bìo wo yi le o dí. ");
INSERT INTO boxNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Á ɓàn nùwã can dĩ̀n coon mu bìo yi. Ká a Yeesu màhã́ henía mu nɔn ɓa yi le ɓa yí bío bìo wó kà le nùpue ɲí. ");
INSERT INTO boxNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","O Yeesu von mí nì-kenínia pírú ɲun á nɔn ho dàńló lè le ɲii ɓa yi, à ɓa wé kĩ̀kã́náa ɓa cĩ́náwa yi á mún wɛɛ́ráa mu vã́mú lè mí sìíwà. ");
INSERT INTO boxNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O tonkaa ɓa le ɓa vaa bue le *Dónbeenì bɛ́ɛnì bìo à mún wɛɛ́ ɓa vánvárowà. ");
INSERT INTO boxNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bìo kà lé bìo ó o henía nɔn ɓa yi: «Mi yí ɓua hàrí dɛ̀ɛ à láráa ho wɔ̃hṹ. O ɓúi yí ɓua bũ̀in-za, tàá puure, tàá bè-dínii. Mi yàá pá yí ɓua wárí. O ɓúi yí ɓua báká ɓúi à séení hìa ó o zã́. ");
INSERT INTO boxNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mi wé vaá làara nùpue na wán, à wón zĩi lé dìo mi kɛɛní yi fúaa mi léró ho lóhó mu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mi wé vaá zon lóhó na yi, ká bìa wi ho yi pã́ mi bìo, ká mi wee lé ho yi, à mi púaa mi zení khṹnkhũnì kúia bĩ́n. Á bṹn ǹ zéení làa bán le ɓa wó khon.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Á ɓa ɓɛ̀n wà dén ɲii so wán á vaá wee hɛ́ɛ bue le Dónbeenì bín-tente, á mún wee wɛɛ́ ɓa vánvárowà hã lórá lè mí dà-kéní kéní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bṹn bìowa so na wee wé kà ɓúenɓúen ó o *Heroode na ɓa bàrá ho kɔ̃hṹ ɲúhṹ wán ɲá á mu lùnkaa o yilera, lé bìo ɓa ɓúi wee bío le lé o Zãn Batiisi vèera. ");
INSERT INTO boxNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɓa ɓúi ɓɛ̀n le lé o *Elii bĩnía ɓuara. Ɓa ɓúi yàá ɓɛ̀n wee bío le mu lé le *Dónbeenì ɲi-cúa fɛɛrowà na yáanía nì-kéní lé yìa vèera. ");
INSERT INTO boxNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ká a Heroode wón wee bío mí yi: «O Zãn á ĩnɛ́n ĩ bɛɛre nɔn le ɲii á ɓa kúio ɲúhṹ. Ó o nìi mu na ɓɛ̀n wee wé bṹn bè-beera so na à ĩ ɲá bìo lée wée coon?» Ò o wã́a wee cà ò o mi a Yeesu wán konloon. ");
INSERT INTO boxNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bìo ó o Yeesu tonkarowà bĩnía ɓueé dɔ̃n á bìo ɓa wó ɓúenɓúen á ɓa lá fɛɛra nɔn wo yi. Bṹn mɔ́n ó o fó ɓarɛ́n mí dòn á ɓa khɛ̀ra van lè ho lóhó ɓúi na ɓa le Bɛtesayidaa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Á bìo ɓa zã̀amáa zũna mu, á ɓa bò a mɔ́n. Ó o Yeesu mɔn ɓa ó o yèrèmáa sã́ ɓa yahó, á wee bío le Dónbeenì bɛ́ɛnì bìo na ɓa yi. Á bìa wee cà le lòn-heɓúee ó o mún wɛɛ́ra. ");
INSERT INTO boxNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bìo ó o nì-kenínia pírú ɲun mɔn à le wii wee tè, á ɓa vá ɓueé ɓó a yi à ɓa bía làa wo: «Bío na ɓa zã̀amáa yi le ɓa lɛ́n va hã ló-zàwa lè hã manawà na sùaráa hen à vaa làa, à mún yí mu bìo dí. Lé bìo á hen na wa wi yi á lóhó yí sùaráa yi, dɛ̀ɛ woon mía hen.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ó o Yeesu bía nɔn ɓa yi: «Minɛ́n miten na mu bè-dínii ɓa yi.» Á ɓa bía nɔn wo yi: «Búurú bi-zàwa bìo hònú làa cezàwa bùaa ɲun mí dòn lé bṹn wi wa cɔ̃́n hen, tàá fo le wa lɛ́n vaá yà ho dĩ́nló à ɓuee na ɓa nì-kúii na kà yi le?» ");
INSERT INTO boxNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Lé bìo á ɓa báawa na wi bĩ́n mí dòn mu zoǹ á à yí ho muaaseé hònú síi. Ó o Yeesu bía nɔn mí nì-kenínia yi: «Mi sanka ɓa nùpua le ɓa kɛɛní lè mí kuio ho ɓúará-ɲun làa pírú pírú wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Á ɓa hĩ́nɔn sankaa ɓa á ɓa ɓúenɓúen karáka. ");
INSERT INTO boxNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ó o Yeesu wã́a fó ho búurú bìo hònú lè ɓa cezàwa bùaa ɲun mu á ɓuan ò o hóonía mí yahó yòó dá ho wáayi, ò o dó le Dónbeenì bárákà mu bìo yi. Bṹn mɔ́n ó o cɛ̀ɛkaa mu nɔn mí nì-kenínia yi le ɓa dá lè ɓa zã̀amáa. ");
INSERT INTO boxNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Á ɓa ɓúenɓúen dú sù, á bìo ká á ɓa khuiira á mu sú hã sàkíwá pírú ɲun. ");
INSERT INTO boxNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wizonle ɓúi, ó o Yeesu khɛ̀ra vaá wee fìo, ò o nì-kenínia wi bĩ́n, ó o tùara ɓa yi: «Ɓa nùpua wee bío webio ĩ dã́ní yi?» ");
INSERT INTO boxNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Á ɓa bía: «Ɓa ɓúi le fo lé o Zãn Batiisi, ɓa ɓúi le fo lé o Elii. Ɓa ɓúi bán ɓɛ̀n le fo lé le Dónbeenì ɲi-cúa fɛɛrowà na yáanía nì-kéní ɓúi na vèera.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ó o Yeesu bĩnía tùara ɓa yi: «Ká minɛ́n cɔ̃́n á mi le ĩ lée wée?» Ó o Piɛre bía: «Fo lé o *Krista na le Dónbeenì tonkaa.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ó o bía bìo kà henía nɔn ɓa yi: «Mi yí vĩ́ vĩ́ bío mu le nùpue ɲí dɛ́.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ò o pá bĩnía bía nɔn ɓa yi: «O *Nùpue Za ko ò o lò be. Ɓa nì-kĩ́a, lè le *Dónbeenì yankarowà ɲúnása, lè ho *làndá bìo zéenílowa á à pĩ́ a. Ɓa à na a ɓa à ɓúe, ká hã wizooní tĩn zoǹ ó ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bṹn mɔ́n ó o yèrèmáa wee bío làa bìa wi bĩ́n ɓúenɓúen: «Yìa wi ò o bè miì, à ɓànso khí mí kùrú sĩi bìo wéro yi, ká a wé lá mí *kùrùwá pĩ̀ lè hã wizooní ɓúenɓúen, à bèráa miì. ");
INSERT INTO boxNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","O nùpue na wi ò o kã̀ní mí mukãnì, wón á à vĩ́iní le. Ká yìa màhã́ tà le mí ì vĩ́iní le ĩnɛ́n bìo yi, wón á à kã̀ní le. ");
INSERT INTO boxNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","O nùpue lá yú ho dĩ́míɲá bìo ɓúenɓúen ò o khon le mukãnì binbirì yi, tàá o bìo yáara ɓúenɓúen, se lé ho cũ̀nú yɛ́n á ɓànso yú? ");
INSERT INTO boxNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yìa wee nìyi ĩnɛ́n lè ĩ bíoní bìo yi, ó o Nùpue Za ɓɛ̀n mún khíi nìyi ɓànso bìo yi ká a khíi bĩnía ɓuara lè mí cùkú beenì, là a Maá Dónbeenì lè mí wáayi tonkarowà cùkú beenì yi. ");
INSERT INTO boxNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Le ĩ mì ho tũ̀iá na mia: Bìa wi hen tĩ́ahṹ, á ɓa ɓúi wi yi á máa hí ká ɓa yí mɔn le *Dónbeenì bɛ́ɛnì.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bìo á bṹn ɓúenɓúen bía khĩína, wizooní bìo hètĩn bṹn mɔ́n ó o fó a Piɛre là a Zãn, là a Zaaki á yòoraráa le ɓúee wán á wà yòó fìo. ");
INSERT INTO boxNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pã̀ahṹ na ó o wee fìo yi, ó o yahó dĩ̀ndĩ̀n miníkaa, á sĩ̀-zĩ́nia mún yèrèmáa wee ɲuiíka kũ̀iákũ̀iá. ");
INSERT INTO boxNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yìo ɓueé tĩ à nùpua nùwã ɲun ɓúi dĩ̀n là a Yeesu ho wáayi cùkú beenì yi á wee tà hã láakáwá làa wo. *Ɓa lé o Mɔyiize là a *Elii. Hã láakáwá na ɓa wee tà lé o Yeesu bìo na ó o ò va ho Zeruzalɛɛmu á vaá hí á à tiíráa ho tonló na ó o ɓuara bìo yi ɲii. ");
INSERT INTO boxNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bṹn ɓúenɓúen wee wé ká a Piɛre lè mí ninzàwa dũma kákáká. Bìo ɓa sĩ̀na á ɓa mɔn o Yeesu cùkú beenì lè ɓa nùpua nùwã ɲun na páanía dĩ̀n làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pã̀ahṹ na á ɓa nùpua mu le mí ì lɛ́n, ó o Piɛre wã́a yí zũ bìo o ò bío, ó o bía nɔn o Yeesu yi: «Ɲúhṹso, mu wó se á wa wi hen. Wà à tá hã bùkú-zàwa bìo tĩn: Ũnɛ́n dà-kéní, o Mɔyiize dà-kéní, o Elii dà-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pã̀ahṹ na ó o wee bío yi, á le dùndúure ɓúi yòó ló lii pon ɓa yi. Bìo ó o nì-kenínia mɔn bṹn, á ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Á mu tãmu ɓúi sã wee ɲí le dùndúure mu yi: «Yìa kà lé ĩ za na á ĩ mɔn léra. Mi wé ɲí a cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bṹn tãmu so bío vaa véeníi, á ɓa le mí ì loń ò o Yeesu dĩ̀n mí dòn. À lá bṹn ɲii wán á ɓarɛ́n ó o ɓúi yí bía bìo ɓa mɔn yí nɔn nùpue yi hùúu. ");
INSERT INTO boxNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mu ɓàn tá na lée tɔ̃n ká ɓa ló le ɓúee wán wee lii, á ɓa zã̀amáa lée sã́ a Yeesu yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ɓa nì-kúii mu tĩ́ahṹ á nìi ɓúi dĩ̀n dĩ̀n ò o wãamaa yi: «Nì-kàránlo! Ĩ wee yanka fo, loń ĩ za bìo yahó yi; lé orɛ́n mí dòn lé yìa á ĩ ton kã́ɲaa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cĩ́ná ɓúi wi o yi, á wee dĩ̀n dĩ̀n fé wo dé, ò o wé wãama ká a táará, à ɲinsã-khùankhúa wé lé. Mu wee wé hĩ́ní o wán túntún. Hen ká mu hĩ́nɔn o yi à mu bío le mí ì khĩí ká a día sùrɛ̀n lòn nì-hío. ");
INSERT INTO boxNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Á ũ nì-kenínia á ĩ yàá fèra yú á yankaa le ɓa ɲa a lén wo yi, ká ɓa màhã́ yí dàńna mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ó o Yeesu bía: «Mi zuia nùpua ɓɛ̀ntĩ́n yí máa dé mi sĩa le Dónbeenì yi bìo bon, á mi mún yí máa ɲí hàrí dɛ̀ɛ. Mi wee leéka le ĩ kɛɛní làa mia á wé è kàrán mia fúuu le?» Bṹn mɔ́n ó o mún bía là a nìi: «Ɓua ũ za mu à ũ ɓuen le ĩ loń.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bìo ó o háyónza vá wà ɓueé sùará a yi, ó o cĩ́ná mu tĩ́n fó a dó ho tá yi ó o lii wee dá kɛ̀kɛ̀kɛ̀. Ó o Yeesu kĩ̀kã́a o cĩ́ná mu yi le o lé, ò o wɛɛ́ra a yàrónza nɔn ɓàn maá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Á bìa wi bĩ́n ɓúenɓúen can dĩ̀n le Dónbeenì na dá mu bìo ɓúenɓúen pànká na ɓa mɔn bìo yi. Bìo ɓa lè mí nì-kéní kéní dĩ̀n wee loń mu bè-beera na ó o Yeesu wó kà, ó o yèrèmáa wee bío lè mí nì-kenínia: ");
INSERT INTO boxNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Hã bíoní na á ĩ ì bío ò na mia á mi ɲí à ɓua mi yiwa: O *Nùpue Za á ɓa à dé ɓa nùpua níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Le bíonì mu ó o nì-kenínia yí ɲá ɲúhṹ sese, le kúará á tun ɓa yi, lé bṹn nɔn á ɓa yí zũ le ɓàn ya-tente, á ɓa mún hézã́na mu bĩní tùaró làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","O Yeesu nì-kenínia wee wã̀aní mín yi á à zũńnáa yìa po ɓa ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bìo ó o Yeesu zũna ɓa yilera, ó o vaá fó a háyónza ɓúi ɓueé bàrá mí nìsã́ní ");
INSERT INTO boxNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ò o wee bío làa ba: «Nùpue lée nùpue na ɓuan o háyónza na kà sese ĩnɛ́n bìo yi, se lé ĩnɛ́n á ɓànso mún ɓuan sese. Á yìa ɓuan mi se, se wón mún ɓuan yìa tonkaa Mi sese. Lé bìo á yìa bìo ɲúhṹ mía mi ɓúenɓúen tĩ́ahṹ wón lé yìa po minɛ́n na ká.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ó o Zãn lá le bíonì ò o bía: «Ɲúhṹso, wa mɔn o nìi ɓúi ò o wee ɲa ɓa cĩ́náwa lè ũ yèni, á wa lá wi wa hè o, lé bìo ó o mía wa kuure yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ó o Yeesu bía bìo kà nɔn ɓa yi: «Mi yí hè o, lé bìo á yìa yí máa fi làa mia se wón làa mia lée dà-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bìo ó o Yeesu léró ho dĩ́míɲá yi pã̀ahṹ wà ɓueé sùará, ó o hã̀ mí sĩi ò o le mí wã́a à lɛ́n á à va ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ó o fèra tonkaa ɓa nùpua á ɓa dú a yahó. Á ɓa wà vaá zon ho *Samarii lóhó ɓúi yi le mí zoó wíoka le lùe á à ká làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Á ho lóhó mu nùpua pã́ le o máa làa mí wán, lé bìo ó o vɛɛnì yahó sã́ ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bìo ó o Zaaki là a Zãn mɔn mu kà, á ɓa bía nɔn o Yeesu yi: «Ɲúhṹso, fo le wa bío le ho dɔ̃hṹ lé ho wáayi à lii cĩ̀í ɓa ɓúe ɲúhṹ le?» ");
INSERT INTO boxNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ó o Yeesu yèrèmáa khíi zá làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bṹn mɔ́n á ɓa wà van ló-veere. ");
INSERT INTO boxNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pã̀ahṹ na á ɓa wi ho wɔ̃hṹ wán, ó o nìi ɓúi vaá ló ɓueé wee bío là a Yeesu: «Ĩ ì bè foǹ á à varáa hã lùa ɓúenɓúen na á ũ wee va yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ó o Yeesu bía nɔn wo yi: «Ɓa cawanwà yú hã kãna wee zo, á ɓa ɲínzàwa mún yú hã lɛnna. Ká a *Nùpue Za wón màhã́ yí yú ho lahó na ó o dà à vũń yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ó o Yeesu bĩnía bía làa ɓúi: «Ɓuee bè miì.» Á wón bía làa wo: «Ĩ ì bè foǹ. Ká ũ màhã́ día le ĩ vaa nùu wàn maá vé.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ó o Yeesu bía nɔn wo yi: «Día le ɓa nì-hía à nùu mí nì-hía, ká ũnɛ́n vaa bue le Dónbeenì bɛ́ɛnì bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ó o ɓúi pá bĩnía bía làa wo: «Ɲúhṹso, ĩ ì bè foǹ, ká ũ màhã́ día le ĩ vaa dé wàn nùwã cãawése vé à ĩ bĩní ɓuen.» ");
INSERT INTO boxNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ó o Yeesu bía làa wo: «Yìa wee và lè mí nàwa sũ̀nɓúahó ká a yèrèmá khíi loń lè mí mɔ́n, wón yí ko lè le *Dónbeenì bɛ́ɛnì.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bṹn mɔ́n ó o Ɲúhṹso pá bĩnía hueekaa ɓa nùpua ɓúará-tĩn làa pírú làa nùwã ɲun ɓúi á tonkaa lè ɓa nùwã ɲun ɲun le ɓa dí mí yahó va hã ló-beera lè hã lùa ɓúenɓúen na ó orɛ́n mí bɛɛre ko ò o va dã. ");
INSERT INTO boxNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ó o bía nɔn ɓa yi: «Ho dĩ́nló bon dĩ̀n cɛ̀rɛ̀ɛ, ká ho lárowà lé bìa yí boo. Àwa. Á mi fìo o mɔhṹ ɓànso yi le o wíoka na ɓa ton-sáwá le ɓa lá ho. ");
INSERT INTO boxNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mi lɛ́n! Ká mi ɲí bìo kà: Ĩ wee tonka mia. Mi ka lòn piozàwa na wà vaá zo ɓa dakhĩ́nkhĩ́nwa tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mi yí ɓua wárí, mi yí ɓua puure, hàrí nakãa. Mi yí dĩ̀n la ɓa nùpua tɛ̀ɛníló yi ho wɔ̃hṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Mi wé vaá zon zĩi lée zĩi, à mi fèn bío le ho hɛ́ɛrà kɛń le zĩi mu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ká nùpue na ko lè ho hɛ́ɛrà wi le yi, á mí hɛ́ɛrà á à dã ɓànso. Ká a ɓɛ̀n yí ko làa ho, á ho máa dã a. ");
INSERT INTO boxNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dén zĩi so lé dìo à mi kɛɛní yi, ká mi wé yí làa zĩi yi à bĩní lé vaa làa le ɓúi yi. Ɓa wé yú bìo na nɔn mia à mi dí bṹn. Ĩ bía bṹn lé bìo ó o ton-sá ko lè mí ɲii dĩ́nló. ");
INSERT INTO boxNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Lóhó lée lóhó na mi wé vaá zon yi, ká ɓa tà ɓuan mia, ká ɓa wé yú bìo na bàrá mi tá, à mi dí bṹn. ");
INSERT INTO boxNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","À ɓa vánvárowà na wi ho lóhó mu yi à mi wɛɛ́, à mi mún bío na ho nùpua yi le le *Dónbeenì bɛ́ɛnì ɓueé ɓó ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ká lóhó na mi vaá zon yi ká ho nùpua yí tà mi bìo, à mi zoo dĩ̀n ho lóhó mu sĩi yi ká mi bío bìo kà na ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Mi lóhó khṹnkhũnì na fà wa zení á wa à púaa á à kúee mi wán, ká mi màhã́ pá zũń mu le le Dónbeenì bɛ́ɛnì ɓueé ɓó.›» ");
INSERT INTO boxNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Le ĩ bío mu na mia: Le cítíi fĩ̀ nɔ̀nzoǹ, á hón lóhó so nùpua bìo na khíi sá ɓa yi á à poń bìo sá ho *Sodɔɔmu lóhósa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Ũnɛ́n Korazɛ̃n lóhó lè ũnɛ́n Bɛtesayidaa lóhó, ho yéréké á à sá mia. Lé bìo á ho yéréké bè-beera na wó minɛ́n cɔ̃́n ɓàn síi lé bṹn lá wó ho Tiire lè ho Sidɔ̃n lórá yi, se hã lórá mu nùpua lá hĩ́nɔn hàánì á khuiira hã pórókówá zã́, á kúaa le sãni mí wán, á zéeníanáa le mí wi à mí khí mu bè-kora wéró yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lé bṹn nɔn le cítíi fĩ̀ nɔ̀nzoǹ á ho Tiire lè ho Sidɔ̃n lórá lònbee na à yí hã á à wé làa yi minɛ́n lònbee yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɛ̀ɛ ká ũnɛ́n *Kapɛɛnayuumu, fo wee leéka le ɓa khíi lá fo á à yòoráa ho wáayi le? Ɓùeé. Ho nì-hɔ̃́nbó-lóhó lé hìa ɓa khíi lií dé fo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ò o wee bío lè mí nì-kenínia: «Yìa wee ɲí mí cɔ̃́n, se ɓànso mún wee ɲí ĩ cɔ̃́n. Á yìa pã́ mia se wón mún pã́ mi. Á yìa pã́ mi, se lé yìa tonkaa mi ó o mún pã́.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bìa ó o tonkaa mí ɓúará-tĩn làa pírú làa nùwã ɲun bĩnía ɓuara à ɓa sĩa wan làa sòobɛ́ɛ, á ɓa bía nɔn o Yeesu yi: «Ɲúhṹso, hàrí ɓa cĩ́náwa ká wà von ũ yèni le ɓa wé bìo na, à ɓa wé mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ó o Yeesu bía nɔn ɓa yi: «Ĩ lá wee wé mi a *Satãni, ɓa cĩ́náwa ɲúhṹso ká a yòó kùera ho wáayi wee lii lè ho viohó na ɲuiína bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mi loń! Ĩ nɔn ho pànká mia, hìa mi wé è varákaráa ɓa háwá, lè ɓa naawà wán, à mún pùpúuráa o zúkúso pànká ɓúenɓúen, ká dɛ̀ɛ woon máa yí mia. ");
INSERT INTO boxNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɛ̀ɛ ká mi màhã́ yí zã̀maka bìo mí yú ho pànká ɓa cĩ́náwa wán bìo yi, ká mi zã̀maka lé bìo á mi yènnáa túara ho wáayi le Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hón pã̀ahṹ dà-kéní so yi á le Dónbeenì Hácírí wɛɛ́ra Yeesu sĩi, ó o wee bío bìo kà: «Éee! Ĩ Maá, ũnɛ́n lé ho wáayi lè ho tá Ɲúhṹso, ĩ wee dé ũ bárákà. Lé bìo mu bìo na fo sà mu bè-zũńminì ɓànsowà lè le hácírí ɓànsowà yi á fo tà zéenía làa bìa bìo ɲúhṹ mía. Ĩ Maá, mu bon. Bìo mu wóráa kà lé bìo sĩ foǹ. ");
INSERT INTO boxNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ĩ Maá dó mu bìo ɓúenɓúen ĩ níi yi. Nìi woon yí zũ a Za, ká mu yínɔń o Maá. Á nìi woon mún yí zũ a Maá, ká mu yínɔń o Za, làa bìa ó o Za mu wi ò o zéení làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bṹn mɔ́n ó o yèrèmáa wee bío lè mí nì-kenínia mí ɲúhṹ wán: «Minɛ́n na wee mi bìo kà lè mí yìo, mi ɲúná ɓɛ̀ntĩ́n sĩ. ");
INSERT INTO boxNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lé bìo le *Dónbeenì ɲi-cúa fɛɛrowà lè ɓa bá-zàwa cɛ̀rɛ̀ɛ sĩa hĩ́a vá à ɓa mi bìo mínɛ́n wee mi à ɓa yí mɔn mu. Ɓa sĩa hĩ́a vá à ɲí bìo minɛ́n wee ɲí, à ɓa yí ɲá mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ho *làndá bìo zéenílo ɓúi wi ò o yí o Yeesu níi ɓua yi, ó o tùara a yi: «Nì-kàránlo, ĩ ko à ĩ wé kaka à bè yi yíráa ho yìrón mukãnì na máa vé?» ");
INSERT INTO boxNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ó o Yeesu bía nɔn wo yi: «Lé mu yɛ́n tùara wa làndá vũahṹ yi? Fo wee ɲí mu kaka?» ");
INSERT INTO boxNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ó o nìi bía nɔn wo yi: «Fo ko ũ wań ũ Ɲúhṹso Dónbeenì lé ũ sĩi ɓúenɓúen, lè ũ mànákã̀ ɓúenɓúen, lè ũ pànká ɓúenɓúen, lè ũ yilera ɓúenɓúen à ũ mún wań mi ninza làa bìo á fo waráa ũten bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ó o Yeesu bía nɔn wo yi: «Fo bía se. Bánbá ũ wé bṹn, á fo ò yí le mukãnì.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ó o nìi pá wi ò o cà ho tũ̀iá sĩni, ó o bĩnía tùara a yi: «Lé o yɛ́n lé wa ninza?» ");
INSERT INTO boxNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ó o Yeesu bía nɔn wo yi: «Nìi ɓúi hĩ́a ló ho Zeruzalɛɛmu yi á wee va ho Zerikoo, á ɓa wã-tiwa vaá tun wo ho wɔ̃hṹ kuio yi á fó sĩa, à ɓa han wo ɓóonía yi ó o yuunia día, à ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mu wó fò mín à le *Dónbeenì yankaro ɓúi lá ho wɔ̃hṹ mu. Bìo ó o ɓueé mɔn o nìi mu ò o día ó o hà yòó ló á khíi lá mí wɔ̃hṹ wà. ");
INSERT INTO boxNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ó o *Levii nùwã nì-kéní ɓúi mún lá ho wɔ̃hṹ mu á ɓueé mɔn o nìi mu ò o día, á wón mún hà yòó ló á khíi wà. ");
INSERT INTO boxNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bṹn mɔ́n ó o *Samarii nìi ɓúi mún lá ho wɔ̃hṹ dà-kéní mu. Bìo ó o ɓueé mɔn o nìi ó o màkárí ɓuan wo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ó o vaá ɓó a yi, á kúaa ho dìvɛ̃́n lè ho ɲiló o dokuaa wán á bá, ò o lá a yòó bò mí yà-yòonii wán á vannáa ɓa nì-hãní làaníi zĩi, á vaá wee loń wo yi ká a váaní a. ");
INSERT INTO boxNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mu tá na lée tɔ̃n yìnbíi ó o léra le wɛ́n-hãani bìo ɲun á nɔn le zĩi ɓànso yi, ò o bía: ‹O nìi mu á ũ pa bìo sese, ká ĩ khíi bĩnía wà ɓueé khĩí hen, ká bìo fo wó a bìo yi á po le wárí na á ĩ nɔn foǹ, á ĩ ì sàání mu.›» ");
INSERT INTO boxNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ò o Yeesu màhã́ bĩnía wee tùa wo yi: «Ɓa nùwã tĩn mu tĩ́ahṹ ó o yɛ́n lé yìa zéenía le o nùpue na ɓa wã-tiwa tun lé mí ninza?» ");
INSERT INTO boxNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Á ho làndá bìo zéenílo bía: «Lé yìa wó le hii làa wo.» Ó o Yeesu bía nɔn wo yi: «Wã́a lɛ́n à wé vaa wé làa bṹn síi.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bìo ó o Yeesu lè mí nì-kenínia wi ho wɔ̃hṹ wán wà, ó o vaá dɔ̃n ho lóhó ɓúi, ó o zoó làara a hã́a ɓúi na ɓa le Maate zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","O hã́a mu ɓàn hĩ́nló ɓúi wi bĩ́n á yèni ɓa le Mari. Bìo ó o mɔn o Yeesu ó o wà ɓueé kará a tá á wee ɲí a bíoní. ");
INSERT INTO boxNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hón pã̀ahṹ so yi, ò o Maate wón ɓɛ̀n yahó bon mí zĩi tonni sáró yi. Bìo ó o mɔn mín hĩ́nló mu ò o kará, ó o wà ɓueé wee bío là a Yeesu: «Ɲúhṹso, wàn hĩ́nló bìo ó o kará yí máa séení mi á fo yí mɔn le? Bío le o hĩ́ní dé mí níi miì.» ");
INSERT INTO boxNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ó o Yeesu bía nɔn wo yi; «Héyìi, Maate. Fo wee yáa ũ yilera ká ũ hɛ́ɛ tã̀má mu bìo cɛ̀rɛ̀ɛ wéró yi, ");
INSERT INTO boxNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ká bìo dà-kéní lé bìo bìo here. O Mari léra bìo se po mu ɓúenɓúen, bìo á nùpue yí dà máa fé o cɔ̃́n máa yí.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wizonle ɓúi ó o Yeesu vaá wee wé mí fìoró le lùe ɓúi. Á bìo ó o fìora vó, ó o nì-kenínia nì-kéní bía làa wo: «Ɲúhṹso, kení wɛn lè ho fìoró làa bìo ó o Zãn Batiisi keníanáa mí nì-kenínia.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ó o Yeesu bía nɔn ɓa yi: «Hen ká mi wé wee fìo, à mi bío kà: Wàn Maá, wé à ɓa nùpua zũń le fo lé le Dónbeenì na ɓàn síi mia. Dí ũ bɛ́ɛnì hã lùa ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hã wɛn lè mu bè-dínii na ko làa wɛn hã wizooní lè mí dà-kéní kéní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sɛ́n wa bè-kora día, làa bìo á warɛ́n mún wee tà sɛ́n día à na bìa wó khon làa wɛn yi. Pa wɛn bìo wee khà wɛn dé mu bè-kohó wéró yi bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ò o pá bĩnía bía nɔn ɓa yi: «O ɓúi ɓàn bɔ̃́nlo wã́a lá wi síi. Wizonle ɓúi ó o hĩ́nɔn vaá yú a ho tá tĩ́ahṹ á bía nɔn yi: ‹Ĩ bɔ̃́nlo, ke mi làa búurú bi-zàwa bìo tĩn, ");
INSERT INTO boxNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wàn bɔ̃́nlo nì-kéní ɓúi ló le kúii yi á ɓueé ló ĩ wán, à bè-dínii mía ĩ cɔ̃́n máa na a yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Á yìa zoó le zĩi yi ɓɛ̀n bía bìo kà: ‹Día mi, yí bũmaka mi. Ho woohṹ pon, á ĩ zàwa làa mi dũma vó. Ĩ yí dà máa hĩ́ní máa na búurú foǹ. Bɔ̃́nlo na à wé bṹn mía.› ");
INSERT INTO boxNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Le ĩ mì ho tũ̀iá na mia: Hàrí ká a pã́ le mí máa hĩ́ní máa na ho búurú mu wo yi ɓa bɔ̃́nmu bìo yi, á bìo ó o yí wi ò o yèni yáa, ó o pá hĩ́a hĩ́ní á à na bìo ó o wee cà ɓúenɓúen wo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Ĩnɛ́n wee bío mu na mia: Mi wé fìo le Dónbeenì cɔ̃́n, á le è hã mia. Mi wé cànka mu bìo le Dónbeenì cɔ̃́n, á mi ì yí. Mi wé ɓúanɓúa ho woohṹ á le è hɛ́n ho mi ì zo. ");
INSERT INTO boxNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lé bìo á yìa wee fìo á le è hã, yìa wee cà bìo le cɔ̃́n, ó o yí mu, yìa wee ɓúanɓúa ho woohṹ á le è hɛ́n ho ó ò zo. ");
INSERT INTO boxNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Minɛ́n tĩ́ahṹ ó o ɓúi za fìora a ceza o cɔ̃́n, ó o so o na háa wo yi le? ");
INSERT INTO boxNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tàá ká a fìora le fũaale ó o so o na naa wo yi le? ");
INSERT INTO boxNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Àwa, á bìo minɛ́n na yí seka á zũ bìo se naló mi zàwa yi, à sɔ̃̀nkú mìn Maá na wi ho wáayi á à wé kaka máa nanáa mí Hácírí bìa wee fìo le o cɔ̃́n yi?» ");
INSERT INTO boxNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wizonle ɓúi ò o Yeesu wee ɲa a cĩ́ná á à lén o nìi ɓúi na ó o cĩ́ná mu wó ó o yí dà máa bío yi. Bìo ó o ló a yi vó, ó o nìi ɲii dɛ̀ɛnía fá á wee bío. Á ɓa zã̀amáa wó coon mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ká ɓa nì-kéní kéníwà ɓúi màhã́ pá wee bío: «Mu lé ɓa cĩ́náwa ɲúhṹso *Bɛlezebuule lé yìa nɔn ho pànká wo yi, ó o dà wee ɲanáa ɓa cĩ́náwa lén bìa ɓa wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɓa ɓúi bán ɓɛ̀n le miì khũaa o ɲii yi, á ɓa bía nɔn wo yi: «Wé ho yéréké bìo ɓúi na wee zéení le ũ dàńló ló le Dónbeenì cɔ̃́n le wa mi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ká a Yeesu màhã́ zũna ɓa yilera, ó o bía nɔn ɓa yi: «Kɔ̃hṹ lée kɔ̃hṹ na nùpua wee fi mín yi, á à fì ì vé. Á zĩ-ɲúhṹ na nùpua mún wee fi mín yi á ɲúhṹ á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ká a *Satãni hĩ́a bĩnía wee fi lè míten ó o bɛ́ɛnì á à wé kaka à kɛńnáa? Bìo á mi màhã́ wee bío le mu lé o Bɛlezebuule lé wón nɔn ho pànká miì á ĩ wee ɲa lè ɓa cĩ́náwa. ");
INSERT INTO boxNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ká lé bṹn mu wóráa, á bìa làa mia lé le dà-kéní ɓɛ̀n wee ɲa ɓa cĩ́náwa mu lè ho pànká yɛ́n? Bán mí bɛɛre wee zéení le mi bìo yí bon. ");
INSERT INTO boxNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Le ĩ mì ho tũ̀iá na mia: Lé le Dónbeenì pànká lé hìa á ĩ wee ɲa lè ɓa cĩ́náwa. Bṹn wee zéení le le Dónbeenì mu bɛ́ɛnì wã́a ɓueé ɓó mia. ");
INSERT INTO boxNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ká a pànká ɓànso ɓúi á hĩa sĩa wi ó o kará pannáa mí lùe yi, ó o níi bìo á dɛ̀ɛ ɓúi máa wé. ");
INSERT INTO boxNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ɛ̀ɛ ká yìa pànká wi po a vaá ló ɓuara ɓueé dàńna a han, o ò fé o hĩa sĩa na ó o lá dó mí sĩi yi, á mún ǹ khuii o níi bìo á à sanka. ");
INSERT INTO boxNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Yìa yí tà ĩ bìo se wón lé ĩ zúkúso, á yìa mún yí máa séení mi ho kúeemínwánló bìo yi, se wón wee saawaní. ");
INSERT INTO boxNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Hen ká a cĩ́ná ló a nùpue na ó o lá wi yi, ò o vaa hɛ́ɛ vará le dùure yi, à cà ho lahó na ó ò kɛɛní á à vũń yi ká a máa yí ho. Ká a wó san ò o bío mí yi: ‹Mu sṹaaní à ĩ bĩní va hen na á ĩ ló yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ká á bĩnía van bĩ́n, ò o vaa yí ho lahó mu ká ho sàara á wíokaa sesese. ");
INSERT INTO boxNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ká a mɔn mu, ò o bĩní vaa fé ɓa cĩ́náwa bùaa hèɲun na ɓɛ̀n ɲii po arɛ́n à ɓa páaní ɓuee zoo kɛɛní cìcàkà ho lahó mu yi. Ká mu wó kà, à wón nùpue so bìo wíoka yáa poń bìo mu fù karáa.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bìo ó o Yeesu dĩ̀n wee bío, à bṹn ò o hã́a ɓúi na wi ɓa zã̀amáa tĩ́ahṹ bía nɔn wo yi pɔ̃́npɔ̃́n: «O hã́a na ton fo á yɛ̀ɛnía ɓɛ̀ntĩ́n ɲúhṹ sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ó o Yeesu bía nɔn wo yi: «Bìa ɲúná sĩ lé bìa wee ɲí le Dónbeenì bíonì à mún tà bè le yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pã̀ahṹ na ɓa zã̀amáa kĩ́nía o Yeesu yi wee ɲàa mín, ó o wee bío làa ba: «Ho lònbìo nùpua yiwa yí se. Ɓa wi à ĩ wé yéréké bìo ɓúi à ɓa mi. Ɛ̀ɛ ká ɓa máa mi yéréké bìo ɓúi ká mu yínɔń le *Dónbeenì ɲi-cúa fɛɛro Zonaasi bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bìo ó o Zonaasi bìo hĩ́a zéeníanáa ho Niniivesa, lé bṹn ɓàn síi ó o *Nùpue Za bìo mún khíi zéenínáa ho lònbìo nùpua. ");
INSERT INTO boxNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","«O bɛ́ɛ hã́a na hĩ́a wi ho Sabaa kɔ̃hṹ ɲúhṹ wán á hĩ́a ló le lùe na dã́ní nàyi làa sòobɛ́ɛ á ɓueé ɲá a Salomɔn bè-zũńminì bíoní. À bìo wi minɛ́n tĩ́ahṹ bṹn ɓɛ̀n po a Salomɔn. Lé bṹn nɔn á le Dónbeenì cítíi fĩ̀ nɔ̀nzoǹ ó o bɛ́ɛ hã́a mu á à hĩ́ní ì dĩ̀n ho lònbìo nùpua yahó á à kooní ɓa yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","«Ho Niniivesa khú mu bè-kora wéró yi lé bìo ɓa ɲá a Zonaasi bíonì. À bìo wi minɛ́n tĩ́ahṹ bṹn ɓɛ̀n po a Zonaasi. Lé bṹn nɔn á le Dónbeenì cítíi fĩ̀ nɔ̀nzoǹ á ho Niniivesa mu á à hĩ́ní ì dĩ̀n ho lònbìo nùpua yahó á à kooní ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Nùpue máa dé fĩ̀ntã́ní á máa sànka, ó o mún máa ɓún le yi làa láahó. Ɓa wé dé le bàrá hen na le ko le bàrá yi, à bìa wee zo le zĩi wé mi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","«Ũ yìo lé ũ sãnía fĩ̀ntã́ní. Ká ũ yìo se, á ũ sãnía ɓúenɓúen á à kɛń mu khoomu yi. Ká ũ yìo yáara á ũ sãnía á à kɛń le tíbírí yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Àwa! Á ũ cén pa ũten bìo, à ũ khoomu à yí wé le tíbírí. ");
INSERT INTO boxNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ká ũnɛ́n ũ bɛɛre á wi mu khoomu yi á bìo ɓúi yúii mía yi, á fo ò dĩ̀n wé è mi làa bìo ká fo dĩ̀n le fĩ̀ntã́ní khoomu yi à ũ mináa bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pã̀ahṹ na ó o Yeesu bía vó yi, ó o *Farizĩɛ ɓúi ɓueé von wo lè ho dĩ́nló mí zĩi. Ó o Yeesu hĩ́nɔn á vaá zoó kará wee dí. ");
INSERT INTO boxNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","O Farizĩɛ mu na von wo á wó coon bìo ó o wee dí ò o yí sɛɛkaa míten làa bìo ɓa wee wé wéráa mu. ");
INSERT INTO boxNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ó o Ɲúhṹso bía nɔn wo yi: «Minɛ́n Farizĩɛwa, mi ka lè mu ɲumu ɲuuníi lè ho dĩ́nló díiníi sĩ̀a na máa mí dòn wee ce wéréwéré, ká mi yiwa hɔ̃́n màhã́ sú lè ho kɔ̃̀nló lè mu sũnsũmámu. ");
INSERT INTO boxNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mi lé ɓa bɔ̃́nbúwá. Le Dónbeenì na wó bìo wee mi ho khũuhũ á so mún yí wó bìo wi lè ho yi le? ");
INSERT INTO boxNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mu hãmu wéró se, ká mi yiwa naló le Dónbeenì yi à mi yí nɔnsã yi, lé bṹn ǹ na ká mu bìo ɓúenɓúen á à ce wéréwéré. ");
INSERT INTO boxNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ká minɛ́n Farizĩɛwa, ho yéréké khíi sá mia, lé bìo á hàrí hã vɔ̃n-zà-wĩ́níwà na ɓa wee kúee le zéení yi ɓúenɓúen á mi wee na ɓàn cúa-pírú níi, à mu húaaràmu lè le Dónbeenì waminì á mi màhã́ wee pɔ̃́n día, à bṹn lé bìo mi ɲɔǹ lá ko à mi wé wé ká mi yiwa mún yí nɔnsã bìo ká wéró yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ho dɔ̃hṹ khíi cĩ̀ minɛ́n Farizĩɛwa, lé bìo mi wa ho yahón lùa kɛɛníló ho kàránló zĩní yi, á mún wa à ɓa nùpua wé tɛ̀ɛní mia lè le kɔ̃̀nbii ɓa zã̀amáa fèmínló lara yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ho yéréké khíi sá mia, lé bìo mi ka lòn búráa na yí máa mi sese na ɓa wee vará wán à ɓa yí zũ mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Á ho *làndá bìo zéenílo nì-kéní bía làa wo: «Nì-kàránlo, fo wee bío kà, se lé warɛ́n fo mún wee là.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ó o Yeesu bía nɔn wo yi: «Minɛ́n làndá bìo zéenílowa á ho dɔ̃hṹ mún khíi cĩ̀, lé bìo á mi wee ɲì ho sèró na lì ɓa nùpua wán, à mi màhã́ yí máa dé mi níní ho sèró bìo yi hàrí cĩ́inú. ");
INSERT INTO boxNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ho yéréké khíi sá mia, lé bìo á ɓa ɲi-cúa fɛɛrowà na á mìn maáwà ɓó bán búráa lé hɔ̃́n á minɛ́n wee so. ");
INSERT INTO boxNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bṹn wee zéení le bìo á mìn maáwà mu wó á mí tà á nɔn mi wee soráa ɓa ɲi-cúa fɛɛrowà mu na ɓa ɓó búráa. ");
INSERT INTO boxNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","«Lé bṹn nɔn le Dónbeenì bè-zũńminì bíaráa bìo kà: ‹Ĩ ì tonka ɓa ɲi-cúa fɛɛrowà lè ɓa tonkarowà ɓa cɔ̃́n, á ɓa ɓúi ɓa à ɓúe ɓa tĩ́ahṹ, ká ɓa ɓúi ɓa à beé lò.› ");
INSERT INTO boxNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ho dĩ́míɲá ɲúhṹ fáráló pã̀ahṹ, á ɓa ɲi-cúa fɛɛrowà na ɓa ɓó ɓúenɓúen á ho zuia nùpua lé bán á le lònbee na wi ɓa húmú mɔ́n á à ɲì wán. ");
INSERT INTO boxNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","À lá a *Abɛɛle ɓúeró pã̀ahṹ à ɓuee dã a Zakari ɓúeró yi, wón na ɓa ɓó le *Dónbeenì zĩ-beenì yi mu hãmu wéeníi lahó lè le *sòobá-lùe pã̀ahṹ. Le ĩ mì ho tũ̀iá na mia: Dén cãni so na kúará ɓúenɓúen lé ho lònbìo nùpua lé bán á le lònbee na wi mu mɔ́n á à ɲì wán. ");
INSERT INTO boxNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Minɛ́n làndá bìo zéenílowa: Ho yéréké khíi sá mia, lé bìo le Dónbeenì zũńló binbirì wɔ̃hṹ á mi tun. Minɛ́n mi bɛɛre á yí bò ho, á bìa le mí ì bè ho á mi mún hò.» ");
INSERT INTO boxNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bìo ó o Yeesu ló le zĩi yi, à bìo ho làndá bìo zéenílowa mu lè ɓa Farizĩɛwa sĩa wee cĩ̀ a yi làa sòobɛ́ɛ, á ɓa lée wee tùaka a yi mu bìowa lè mí sìíwà dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ɓa le mí ì ɲí a ɲii yi ká a hĩ́a bía khon à ɓa yí o níi ɓua yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mu wee wé ká ɓa nùpua fò mín bĩ́n ɓùiríɓùiríɓùirí fúaa ɓa wee yonka mín zení lé ɓa booró. Ó o Yeesu wã́a sánsáa mi nì-kenínia á wee bíoráa: «Héyìi! Mi pa miten ɓa *Farizĩɛwa bìo yi. Ɓa bìo ɓonmín lè le ɲa-fĩni. Bìo ɓa wee kàrán lè ɓa nùpua á ɓarɛ́n mí bɛɛre yí máa bè yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mu bìo na sànkaa ɓúenɓúen khíi mi, á bìo sà yi ɓúenɓúen mún khíi zũń. ");
INSERT INTO boxNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lé bṹn nɔn á bìo mi ì bío le tíbírí yi, á ɓa nùpua khíi mì wéréwéré. Bìo mi wee hũmɔnka kúee mín ɲikɔ̃nna yi hã zĩní fĩ̀kãna á mún khíi bue hã lòra. ");
INSERT INTO boxNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Wàn bɔ̃́nlowà, ĩ ì bío mu ù na mia. Mi wé yí zɔ̃́n bìa wee ɓúe o nùpue ká ɓa máa bĩní dàń mu ɓúi wé. ");
INSERT INTO boxNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yìa mi ko à mi wé zɔ̃́n á ĩ ì zéení làa mia. Mi wé zɔ̃́n le Dónbeenì na dà à dé mia le Dofĩ́ní dɔ̃hṹ na máa hí yi mu húmú mɔ́n. Le ĩ bío mu na mia: Dén le dìo mi ko mi wé zɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ɓa ɲínzà-wĩ́níwà bùaa hònú so yi máa yɛ̀ɛ́ hã tɔ̃mɔ́nwà bìo ɲun le? À le Dónbeenì yi pá yí máa nɔnsã bán yà-kéní ɓúi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hàrí mi ɲún-vãní ɓúenɓúen á le Dónbeenì zũ ɲii. Mi wã́a yí zɔ̃́n dɛ̀ɛ, lé mi bìo ɲúhṹ wi po ɓa minka ɲínzà-wĩ́níwà. ");
INSERT INTO boxNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Le ĩ bío mu na mia: Yìa dĩ̀n ɓa nùpua yahó ò o bía wéréwéré le mí bìo sã̀ miì, ó o *Nùpue Za mún khíi bío le Dónbeenì wáayi tonkarowà yahó le ɓànso bìo sã̀ mí yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ká yìa ɓɛ̀n bía wéréwéré ɓa nùpua yahó le mí yí zũ mi, ó o Nùpue Za mún khíi bío le Dónbeenì wáayi tonkarowà yahó le mí yí zũ ɓànso. ");
INSERT INTO boxNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nùpue na bía le bín-kohó o Nùpue Za dã́ní yi, á wón ɓànso á ɓa à sɛ́n ǹ día á à na yi. Ká yìa khíi bía le bín-kohó le Dónbeenì Hácírí dã́ní yi, á wón ɓànso máa yí mu ɓàn sɛ́ndíaró. ");
INSERT INTO boxNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Hen ká ɓa khíi wé ɓuan mia vannáa ɓa *zúifùwa kàránló zĩní yi, tàá ho pànká ɓànsowà yahó à bán cítí mia, à mi yí le mi yiwa dè bìo mi ì láráa mi ɲi-cúa làa bìo mi ì bío bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lé bìo á bìo mí vaá bío á le Dónbeenì Hácírí á à zéení làa mia hón pã̀ahṹ so yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","O nìi ɓúi bía nɔn o Yeesu yi ɓa zã̀amáa tĩ́ahṹ: «Nì-kàránlo, bío na wàn za yi le o sanka wàn kĩ́a ò o na ĩ bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ó o Yeesu bía nɔn wo yi: «Wàn bɔ̃́nlo, lée wée dó mi le ĩ fáa mìn tũ̀iáwà à mún sanka mìn kĩ́a na mia?» ");
INSERT INTO boxNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bṹn mɔ́n ó o wee bío làa bìa wi bĩ́n ɓúenɓúen: «Mi pa miten bìo. Mi yí wé nùpua na yìo yí máa sì làa bìo, lé bìo hàrí ò o nùpue níi bìo wé boo kaka, á so o mukãnì pá po mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ò o wã́a wà le wàhiire na kà nɔn ɓa yi: «Nìi ɓúi na nàfòró wi hĩ́a ɓó ho dĩ́nló làa sòobɛ́ɛ mí mɔhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ó o lon mí yi, ò o wee bío bìo kà lè mí sĩi: ‹Lé mu yɛ́n á ĩ ko à ĩ wé? Ĩ dĩ́nló na á ĩ yú á máa zo ĩ náa.› ");
INSERT INTO boxNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Á bìo kà lé bìo ó o wã́a le mí ì wé: ‹Ĩ ì fì ĩ náa ɓúenɓúen, ká ĩ bĩní ì so hĩ̀a ɓùaaka á à khuii ĩ dĩ́nló le ĩ bìo ɓúenɓúen á à kúee yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bṹn mɔ́n á ĩ wã́a à bío ĩ sĩi yi: ‹Áyì, wàzaa, à ũ bìo ɓɛ̀ntĩ́n se. Fo ò wé hã́ lúlúio zànzàn ká dɛ̀ɛ ɓúi máa fòo foǹ. Wã́a wé vũń, wé dí, wé ɲu ká ũ wé bìo sĩ foǹ.› ");
INSERT INTO boxNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ká le Dónbeenì màhã́ bía nɔn wo yi: ‹Fo lé o bɔ̃́nbú. Ho tĩ́nàahṹ na kà lé hón á ĩ ì fé ũ mukãnì yi. Àwa, hón pã̀ahṹ so yi, ká ũ bìo na á ũ khuiira zoó bàrá pan yi á bìo á à sĩ̀ wée yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Lé kà síi á yìa wee khuii ho nàfòró zoo pa yi ká a máa cà hìa le Dónbeenì cɔ̃́n á bìo khíi wéráa.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bṹn mɔ́n ó o wee bío lè mí nì-kenínia: «Lé bṹn nɔn á ĩ wee bíoráa bìo kà á à na mia: Mi wé yí yáa mi yilera mi mukãnì bìo yi, le mi ì yí mu bè-dínii wen à á dí, tàá mi sãnía bìo yi, le mi ì yí hã sĩ̀-zĩ́nia wen á à zĩ́. ");
INSERT INTO boxNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mu bon. Le mukãnì bìo po mu bè-dínii, á hã sãnía bìo po hã sĩ̀-zĩ́nia. ");
INSERT INTO boxNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mi loń ɓa khànkhonwà, ɓa yí máa dì bìo, á mún yí máa lá dĩ́nló. Ɓa náa mía, ká le Dónbeenì màhã́ pá wee díiní ɓa. À bìo mínɛ́n bìo ɲúhṹ màhã́ wi po ɓa ɲínzàwa. ");
INSERT INTO boxNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Minɛ́n tĩ́ahṹ á yìa dà mí mukãnì wizooní á à dé wán cĩ́inú mí yilera yáaró bìo yi so wi le? ");
INSERT INTO boxNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Á bìo mí yí dà dɛ̀ɛ woon máa wé bìo cĩ́inú bìo yi, á mí wee yáa mi yilera bìo kà dã́ní yi le we? ");
INSERT INTO boxNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mi loń le pũ̀iílè. Le yí máa sá dɛ̀ɛ, á mún yí máa tĩ́ sĩ̀a. Le ĩ bío mu na mia: hàrí o *Salomɔn lè mí cùkú ɓúenɓúen ká wón pá yí zã́ sĩ̀a na se yú lerɛ́n ɓúi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ká le Dónbeenì wee donkhueé le ɲíní kà síi, dìo wé kɛń ho zuia ká ho yìró à ɓa cĩ̀í le, à sɔ̃̀nkú minɛ́n á le è wé kaka máa zĩ́iní. Mi sĩadéró le Dónbeenì yi ɓɛ̀ntĩ́n fòora. ");
INSERT INTO boxNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mi wé yí yáa mi yilera à wé dĩ̀n cà bìo mi ì dí làa bìo mi ì ɲu. ");
INSERT INTO boxNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mu bon, bìa yí zũ le Dónbeenì ho dĩ́míɲá yi lé bán wee wé dĩ̀n cà bṹn ɓúenɓúen fɛ́ɛɛ. Ɛ̀ɛ ká minɛ́n mìn Maá Dónbeenì wón zũ bìo ko làa mia. ");
INSERT INTO boxNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mi le mi yara sĩ́ le Dónbeenì bɛ́ɛnì bìo, á bìo ká á le Dónbeenì á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Minɛ́n nùwã yɛn zàwa na á ĩ pan bìo, mi yí zɔ̃́n dɛ̀ɛ, lé bìo á mu wó sĩna mìn Maá Dónbeenì yi à le na mí bɛ́ɛnì mia. ");
INSERT INTO boxNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Mi yɛ̀ɛ́ mi níi bìo à sanka wárí na mi yú à na ɓa nì-khenia yi. Mi cà ho nàfòró binbirì na máa vé bàrá ho wáayi ká lè miten. Bĩ́n á ɓa kɔ̃̀nlowà máa ɲuaa ho, á bùaa mún máa yáa ho. ");
INSERT INTO boxNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mu bon, hen na mi nàfòró wi yi lé bĩ́n á mi sĩa ɓúenɓúen á à dé yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Mi zĩ́ mí tonló sĩ̀a, à zã̀ní mí fĩ̀ntɛ̃́ɛna wíoka dĩ̀nnáa. ");
INSERT INTO boxNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mi wé lè ɓa nùpua na pan mí ɲúhṹso na van mu yaamu cɛɛníi bìo. Ká a ɓueé dɔ̃n pã̀ahṹ na yi, á ɓúanɓúaa ho woohṹ à ɓa dɛ̀ɛní hɛ́n ho. ");
INSERT INTO boxNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bán ton-sáwá so na á ɓa ɲúhṹso ɓueé yú à ɓa fánía mí yìo pan wo ɓɛ̀ntĩ́n ɲúná sĩ. Le ĩ mì ho tũ̀iá na mia: O ɲúhṹso mí bɛɛre á à lá mí tonló sĩ̀a á à zĩ́ ká a bío le ɓa kɛɛní, ká a lá ho dĩ́nló á à sanka à na ɓa yi ɓa à dí. ");
INSERT INTO boxNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hàrí ò o ɲúhṹso mu ɓuee dã ho tá tĩ́ahṹ tàá mu yàá dà bṹn wán, ká a ɓueé yú ɓa ká ɓa yìo fá á kará pan wo, se bán ton-sáwá so ɲúná ɓɛ̀ntĩ́n sĩ. ");
INSERT INTO boxNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Mi zũ le ká le zĩi ɓànso lá wee wé zũń o kɔ̃̀nlo ɓuenló pã̀ahṹ, ó o lá máa wé è día ó o máa zo a zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Minɛ́n mún tĩní mí yìo, lé bìo ó o *Nùpue Za khíi ɓuen ho pã̀ahṹ na á mí yí máa dé le o ɓuen yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ó o Piɛre tùara a yi: «Ɲúhṹso, le wàhiire mu á ũ wà nɔn warɛ́n wa dòn yi lée, tàá lé ɓa nùpua ɓúenɓúen á le wà nɔn yi?» ");
INSERT INTO boxNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ó o Yeesu bía nɔn wo yi: «O ton-sá na yí máa lé mí ɲúhṹso mɔ́n, na hácírí wi le o yɛ́n? Lé yìa ó o ɲúhṹso á à bàrá mí zĩi tonni ɲúhṹ wán, le o wé sanka ho dĩ́nló na mí zĩi nùpua lè mí nì-kéní kéní yi ho pã̀ahṹ na mu ko yi, ");
INSERT INTO boxNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ó o wee sá ho tonló mu ó o ɲúhṹso bĩnía ɓueé kúaa wán. O ton-sá mu ɲúhṹ sĩ. ");
INSERT INTO boxNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Le ĩ mì ho tũ̀iá na mia: O ɲúhṹso á à bàrá a mí bìo ɓúenɓúen ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","«Ká a ton-sá mu día ò o wee bío mí yi: ‹Ĩ ɲúhṹso míana ò o máa ɓuen.› Ò o wã́a hĩ́nɔn wee ha mí ninzàwa ton-sáwá, ɓa báawa lè ɓa hã́awa, á wee dí ká a ɲu khée, ");
INSERT INTO boxNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","wón ton-sá so ɓa ɲúhṹso khíi ɓuen le wizonle na ó o yí zũ yi, lè ho pã̀ahṹ na ó o yí dó yi. Ká a ɲúhṹso mu khíi ɓuee dɔ̃n, ó o ɓueé beé o lò làa sòobɛ́ɛ, ká a pá à dé o ɓa ton-sáwá na ló mí ɲúhṹso mɔ́n tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«O ton-sá na zũ mí ɲúhṹso sĩi bìo, ò o yí wíokaa míten á yí wó mu làa bìo ó o lonnáa mu, wón á ho haró ò ɲí. ");
INSERT INTO boxNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ká yìa yí zũ mí ɲúhṹso sĩi bìo, ò o wó hã wén-kora á ɓa ko ɓa ha, wón haró máa tà máa ɲí a làa yìa so bìo. Yìa ɓa nɔn mu bìo na boo yi, á ɓa khíi fé bìo boo cɔ̃́n, á yìa ɓa kàràfáa mu bìo na boo yi, á ɓa khíi tùa yi làa bìo po bṹn. ");
INSERT INTO boxNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Lé ho dɔ̃hṹ á ĩ ɓuan wa ɓueé dé ho tá yi, á ĩ ɓɛ̀ntĩ́n lá wi à ho dɛ̀ɛní zà! ");
INSERT INTO boxNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ká ĩ màhã́ ko à ĩ kã́a lònbe-beenì ɓúi yi, á ĩ hácírí ɓɛ̀ntĩ́n lùnkaa mu bìo yi, ká mu yí wó yí vó, á ĩ máa yí ĩten. ");
INSERT INTO boxNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Mi wee leéka le ĩ ɓuara wà ɓueé dé hɛ́ɛrà ho dĩ́míɲá yi le? Ɓùeé. Le ĩ bío mu na mia: Lé hã bíoní á ĩ wà ɓueé kúee á à khɛɛ́ráa ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bìo kà wán á ɓa nùpua nùwã hònú na wi le zĩi dà-kéní yi á à kha. Ɓa nùwã tĩn á à fi lè ɓa nùwã ɲun na so, á ɓa nùwã ɲun á mún ǹ fi lè ɓa nùwã tĩn mu. ");
INSERT INTO boxNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","O maá máa wé sĩ lè mí za, ó o za mún máa wé sĩ lè mín maá. O nu máa wé sĩ lè mí hĩ́nló, ó o hĩ́nló mún máa wé sĩ lè mín nu. O ɓùaa hã́a máa wé sĩ lè mí yàró hã́a, ó o yàró hã́a mún máa wé sĩ lè mín ɓùaa hã́a.» ");
INSERT INTO boxNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bṹn mɔ́n ó o wee bío lè ɓa zã̀amáa: «Hen ká mi mɔn ká hã dùndúio wee vá kúee mín wán lè le wii tèeníi, à mi le ho viohó ò tè, à mu ɓɛ̀n wé làa bṹn. ");
INSERT INTO boxNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hen ká mi mɔn ká ho pinpiró wee lé lè le wii hɛ̀ɛníi ɓàn nín-káahó à ɓuen, à mi le ho wunwuró ò kɛń, à mu ɓɛ̀n wé làa bṹn. ");
INSERT INTO boxNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nì-khàwa yɛ́n! Mi wee loń ho tá lè ho wáayi à zũńnáa bìo wee wé pɔ̃̀nna. Á lée webio nɔn á mu bìo na wee wé lònbìo á mí yí zũ máa zéení kúará? ");
INSERT INTO boxNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Lée webio nɔn á mínɛ́n mi bɛɛre yí dà máa hueeka mu bìowa mín yi à zũńnáa bìo térénna. ");
INSERT INTO boxNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","O ɓúi lá wó khon lè mi ninza síi, ó o von fo le cítíi yi, à ũnɛ́n na wó khon bánbá à ũ fèn wé le ɲii dà-kéní lè mi ninza mu ho wɔ̃hṹ wán ká mi dĩǹ yí vaá dɔ̃n. Ká bṹn mía ó o vaá dé fo o cítí-fĩ̀ níi yi, á wón ɓɛ̀n á à yèrèmá khíi dé o paro níi yi, á wón ǹ dé ho kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Le ĩ bío mu na mia: Ho kàsó mu á fo máa lé yi hùúu ká ũ yí wã́ le wárí na fo ko á ũ na ɓúenɓúen á yí tiíra ɲii.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu pã̀ahṹ, á nùpua nùwã yɛn ɓúi ló ɓueé wee bío ho Kalileesa ɓúi bìo là a Yeesu, bìa ó o *Pilaate na wi ho *Zudee kɔ̃hṹ ɲúhṹ wán á nɔn le ɲii ɓa ɓó ká ɓa dĩ̀n wee wé mu hãmu. ");
INSERT INTO boxNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ó o Yeesu bía nɔn ɓa yi: «Mi wee leéka le bán nùpua so lé bìa hĩ́a wee wé mu bè-kora po ho Kalileesa na ká á nɔn ɓa bìo wóráa kà síi le? ");
INSERT INTO boxNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɓùeé. Ká minɛ́n mún yí khú mu bè-kora wéró yi, á mi ì hí lè ɓa bìo, le ĩ bío mu na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tàá mi wee leéka le ɓa nùpua pírú hètĩn na ho Silowee nɔ́nwíohṹ hĩ́a tò ɲà yi á ɓa húrun lé bán hĩ́a wee wé mu bè-kora po ho Zeruzalɛɛmu nùpua na ká le? ");
INSERT INTO boxNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɓùeé. Ká minɛ́n mún yí khú mu bè-kora wéró yi, á mi ì hí lè ɓa bìo, le ĩ bío mu na mia.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bṹn mɔ́n ó o wà le wàhiire na kà nɔn ɓa yi: «Nìi ɓúi hĩ́a fá le vĩ̀ndɛ̀ɛ ɓúi na ɓa le *fíkíyée mí vĩ̀nsĩ̀a ɓuahó yi. Wizonle ɓúi ó o le mí ɓueé loń le mí ì yí bia ho wán á à khòo lè, ó o ɓueé khon. ");
INSERT INTO boxNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ó o wã́a wee bío le mí ton-sá: ‹Bìo kà le mu lúlúio bìo tĩn ká ĩ sansan le ĩ ɓueé khòo le vĩ̀ndɛ̀ɛ mu na kà bia, à ĩ ɓuee khe. Mu ɲúhṹ mía à ĩ día le à le fé le lùe kã́amáa. Ɓúe le.› ");
INSERT INTO boxNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ó o ton-sá bía nɔn wo yi: ‹ɲúhṹso, día lé ho dueera loń, ká ĩ ì búnbú le ɲúhṹ á à kúee ho duioró yi. ");
INSERT INTO boxNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ɲún-sĩ á lóhóló ká le è ha. Ká le wã́a yí han làa bṹn, à ũ màhã́ ɓúe le.›» ");
INSERT INTO boxNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu hĩ́a wó *Sabaa ɓúi zoǹ ká a Yeesu wee kàrán ɓa nùpua ho kàránló zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mu zoǹ à hã́a ɓúi wi bĩ́n á lò yí here yú hã lúlúio pírú hètĩn. O cĩ́ná ɓúi wó a là a mɔ́nkú ó o yí dà máa hĩ́ní máa yòó muin. ");
INSERT INTO boxNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bìo ó o Yeesu mɔn wo, ó o von wo á ɓueé bía bìo kà nɔn yi: «Hã́a mu, fo wã́a yú ũten ũ vã́mú níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ò o yòó bò mí níní o wán, ó o dɛ̀ɛnía hĩ́nɔn yòó muina dĩ̀n á wee ɓùaaní le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ká ho kàránló zĩi ɲúhṹso màhã́ yí wara mu, lé bìo ó o Yeesu wɛɛ́ra vánváro ho Sabaa zoǹ, ó o bía nɔn ɓa zã̀amáa yi: «Hã wizooní bìo hèzĩ̀n lé hɔ̃́n á ho tonló ko à ho wé sá yi ho yàwá ɲúhṹ yi, á mí wé ɓuen le ɓa wɛɛ́ mia hón pã̀ahṹ so yi, ká mi yí wé mu hã wizooní bìo hèɲun níi na le ho Sabaa zoǹ yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ó o Ɲúhṹso bía nɔn wo yi: «Nì-khàwa yɛ́n! Minɛ́n á yìa yí máa fee mí nàa tàá mí sũ̀npɛ̀ɛnì à lée ɲuií ho Sabaa zon lée wée? ");
INSERT INTO boxNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","O hã́a na kà na lé o *Abarahaamu mɔ̀nmàníi ɓúi na ó o *Satãni can hã lúlúio pírú hètĩn yi á so lá yí ko ò o fee día ho Sabaa zoǹ le?» ");
INSERT INTO boxNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dén bíonì so na ó o Yeesu bía á dó hã nìyio bìa làa wo wee wã̀aní yi. Ká ɓa zã̀amáa na wi bĩ́n ɓúenɓúen bán ɓɛ̀n wee zã̀maka mu bè-tentewà na ó o wee wé bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","O Yeesu bĩnía bía bìo kà: «Le *Dónbeenì bɛ́ɛnì á ɓonmín làa webio? Lée webio á ĩ dà à tèé làa de? ");
INSERT INTO boxNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Le bìo ɓonmín lè ho mútáàdè bɛɛre na ó o nìi ɓúi dù mí vĩ̀nsĩ̀a ɓuahó yi, á le ló á hĩ́nɔn yòó wó mí vĩ̀ndɛ̀-beenì, á ɓa ɲínzàwa wee tá mí lɛnna yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ò o pá bĩní bía bìo kà: «Lée webio á ĩ dà à tèé lè le Dónbeenì bɛ́ɛnì? ");
INSERT INTO boxNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Le bìo ɓonmín lè le ɲa-fĩni na ó o hã́a ɓúi zúnzúio kúaa mu dũmu kiloowa ɓóní làa hònú yi á khan bàrá á mu ló.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","O Yeesu hĩ́a tò hã ló-beera lè hã ló-zàwa yi á wee kàrán ɓa nùpua ká a va lè ho Zeruzalɛɛmu cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ó o ɓúi tùara a yi: «Ɲúhṹso, bìa á à kã̀ní yínɔń ɓa à wé ɓa nì-dòndáa le?» Ó o bía nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Mi bánbá à mi zo lè ho zũaɲii na fĩ́nía. Le ĩ bío mu na mia: Ɓa nùpua cɛ̀rɛ̀ɛ khíi cà ho zoró yahó ká mu yìo máa lé. ");
INSERT INTO boxNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ká a zĩi ɓànso khíi hĩ́nɔn á vá mí woohṹ pon á dó, à bṹn minɛ́n lée wi ho khũuhũ á wee ɓúanɓúa ká mi ì bío bìo kà: ‹Ɲúhṹso, hɛ́n le wa zo.› O ò bío o na mia: ‹Ĩ yí zũ mi léeníi.› ");
INSERT INTO boxNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Á mi ɓɛ̀n á à bío o na a yi: ‹Éee! Ká wa ɲɔǹ páanía dú á ɲun làa fo, á fo mún kàránna ɓa nùpua wa lóhó ɓonfúaa yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ó o tĩ́n á à bío ò na mia: ‹Mi vá lé ĩ nìsã́ní, bè-kora wérowà yɛ́n! Ĩ yí zũ mi léeníi.› ");
INSERT INTO boxNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Ká mi khíi mɔn o Abarahaamu là a *Izaaki là a *Zakoobu lè le Dónbeenì ɲi-cúa fɛɛrowà ɓúenɓúen le Dónbeenì bá-zàmu yi à minɛ́n ɓa lée kúaará ho khũuhũ, á mi ì wá á yiwa à vá bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɓa nùpua khíi lé ho dĩ́míɲá kùaráa ɓúenɓúen yi á ɓueé kɛɛní ká ɓa à dí ho sã́nú le Dónbeenì bɛ́ɛnì díiníi. ");
INSERT INTO boxNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bṹn ká bìa dú ho mɔ́n ho zuia khíi wé ɓa ya-díwá, ká bìa dú ho yahó ho zuia ɓɛ̀n khíi wé ɓa mɔ́n-díwá.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hón pã̀ahṹ so yi á ɓa *Farizĩɛwa nùwã yɛn ɓúi vá ɓueé ɓó a Yeesu yi á wee bío làa wo: «Héyìi! Hĩ́ní lɛ́n hen à va lòn-veere, lé bìo ó o *Heroode wi ò o ɓúe fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ó o bía nɔn ɓa yi: «Mi lɛ́n va à bío na wón cawan so yi: ‹Ĩ wee ɲa ɓa cĩ́náwa á mún wee wɛɛ́ ɓa vánvárowà ho zuia lè ho yìró, ká mu wizooní tĩn zoǹ á ĩ tií ĩ tonló ɲii. ");
INSERT INTO boxNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ká ĩ màhã́ ko à ĩ lá ĩ wɔ̃hṹ lɛ́n ho zuia lè ho yìró lè ho yìró níi ló, lé bìo mu yí se à le *Dónbeenì ɲi-cúa fɛɛro hí lòn-veere ká mu yínɔń ho Zeruzalɛɛmu yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Éee Zeruzalɛɛmusa! Minɛ́n na wee ɓúe le Dónbeenì ɲi-cúa fɛɛrowà, á wee lèeka bìa le Dónbeenì wee tonka mi cɔ̃́n lè hã huaa à ɓúe. Lée zen cúa-yɛn á ĩ wi à ĩ vá mia kúee mín wán làa bìo ó o kùeerè wee wé veráa mí zàwa kúee mí mía tá bìo síi à mi yí tà mu! ");
INSERT INTO boxNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Àwa! Le Dónbeenì á à pĩ́ mia hùúu. Le ĩ bío mu na mia: Mi máa bĩní máa mi mi fúaa nɔ̀nzoǹ na mi khíi wee bío bìo kà: ‹Le le Dónbeenì dúɓua yìa bò o ɓuen o Ɲúhṹso yèni yi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ho *Sabaa ɓúi zoǹ ó o Yeesu á ɓa *Farizĩɛwa ɲúhṹso ɓúi von lè ho dĩ́nló mí zĩi. Á bìa wi bĩ́n fá mí yìo wo yi le mí ì loń bìo o ò wé. ");
INSERT INTO boxNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","À bṹn ò o nìi ɓúi na mu vã́mú ɓúi tò ó o sãnía lon á dĩ̀n o yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ó o Yeesu lá le bíonì ò o tùara ho *làndá bìo zéenílowa lè ɓa Farizĩɛwa yi: «Wa làndá yi á nùpue so dà à wɛɛ́ vánváro ho Sabaa zoǹ le?» ");
INSERT INTO boxNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Á ɓa yí bía, à ɓa dĩ̀n ɓúirín. Ó o Yeesu wã́a ɓuan wo yi, á wɛɛ́ra, ò o le o lɛ́n khíɓo. ");
INSERT INTO boxNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bṹn mɔ́n ó o wee bío làa bìa wi bĩ́n: «Minɛ́n á yìa za tàá o nàa tò le buii yi ó o máa dɛ̀ɛní máa suee wo fùafùa hàrí mu wé ho Sabaa zoǹ lé o yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ó o ɓúi mún yí dàńna dɛ̀ɛ yí bía mu dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bṹn mɔ́n á bìo ó o Yeesu mɔn à bía ɓa von wee yì ho yahón lùa à kɛɛní yi, ó o wà le wàhiire na kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Hen ká a ɓúi von fo mí yaamu sã́nú díiníi, à ũ yí dɛ̀ɛní yí vaa kɛɛní ho yahó, lé bìo mu dà a wé le o ɓúi na ɲúhṹ wi po fo á ɓa mún von. ");
INSERT INTO boxNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Á fo ò kɛɛní ũ zàamu ká yìa von mia mi nùwã ɲun á ɓueé wee bío làa fo: ‹Hĩ́ní à ũ na le lùe yìa kà yi.› Á fo màhã́ à còoní ì hĩ́ní lé ũ nìyio á à lɛ́n khíi kɛɛní ho mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɓa wé von fo làa bṹn síi, à ũ ɓuee khĩí lii kɛɛní ho mɔ́n, ká yìa von fo ɓuee dɔ̃n, o ò bío ò na foǹ: ‹Wàn bɔ̃́nlo, hĩ́ní ɓuee yòo kɛɛní ho yahó.› Hón pã̀ahṹ so yi bṹn ká bìa ɓa von mu yaamu sã́nú díiníi ɓúenɓúen á à mi bìo ɓa ɓùaaníanáa fo. ");
INSERT INTO boxNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lé bìo á nùpue lée nùpue na wee yòoní míten wón à le Dónbeenì á à liiní. Ká yìa wee liiní míten wón à le è yòoní.» ");
INSERT INTO boxNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bṹn mɔ́n ó o yèrèmáa wee bío làa yìa von wo: «Hen ká fo wé le fo ò ve nùpua à ɓa ɓuee dí ũ cɔ̃́n, à mu wé wisoni yi tàá ho tĩ́nàahṹ, à ũ yí le mu wé mìn bɔ̃́nlowà, lè mìn zàwa lè mìn temínlowà, tàá mi ninzàwa bío ɓànsowà. Lé bìo ɓa khíi dàń fo ò ve làa bṹn bìo síi á à dé bìo fo wó nɔn ɓa yi lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ká fo wíokaa ho dĩ́nló ho sã́nú bìo yi á le fo o ve lè ɓa nùpua, à ɓa nì-khenia, lè ɓa mùamúawà, lè ɓa lóní lè ɓa muiiwà lé bán à ũ ve. ");
INSERT INTO boxNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ká fo wó bṹn, á ũ bìo á à wé se, lé bìo á bán yí dà mu síi máa wé máa na foǹ. Le Dónbeenì le dìo khíi sàání foǹ bìa wó mu bè-tentewà vèeró zoǹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bìo á bìa làa wo páanía wee dí nì-kéní ɲá hɔ̃́n bíoní so, ó o bía nɔn o Yeesu yi: «Yìa khíi kɛń le *Dónbeenì bɛ́ɛnì dĩ́nló díiníi ɓɛ̀ntĩ́n bìo se.» ");
INSERT INTO boxNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ó o Yeesu bía nɔn wo yi: «Nùpue ɓúi hĩ́a le mí ì dí sɔ̃́n-beenì, ó o fèra bía mu nɔn ɓa nùpua cɛ̀rɛ̀ɛ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bìo ho dĩ́nló mu díró pã̀ahṹ dɔ̃n, ó o le mí ton-sá vaa bío na bìa ó o von yi: ‹Mi hĩ́ní ɓuen, lé ho dĩ́nló wíokaa vó pan mia.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Á ɓa lè mí nì-kéní kéní yú bìo ɓa à bío máa ɓuennáa. O nín-yání nùpue bía nɔn o ton-sá yi: ‹Sábéré, ĩ ɓɛ̀ntĩ́n yí dà máa ɓuen; ĩ yà ho mɔhṹ lònbìo, á ĩ ko à ĩ vaa loń ho.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ò o ɓúi wón bía nɔn wo yi: ‹Sábéré, ĩ yà ho vàró nàwa bùaa pírú, lé bán á ĩ wi à ĩ díndí loń.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ò o nì-kéní wón ɓɛ̀n bía: ‹Ĩ yan lònbìo á ĩ ɓɛ̀ntĩ́n yí dà máa ɓuen.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ó o ton-sá mu bĩnía ɓueé bía mu ɓúenɓúen nɔn mí ɲúhṹso yi, á wón sĩi cã̀, ó o bía nɔn wo yi: ‹Wã́a bánbá lɛ́n va ɓa nùpua fèmínló lara yi, à zo ho lóhó ɓonfúaa yi, à ɓa nì-khenia, ɓa mùamúawà, ɓa muiiwà lè ɓa lóní na fo ò fèráa mín bĩ́n à ũ ɓua ɓuennáa.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mu ù dé mí yi, ò o ton-sá bĩnía ɓueé wee bío lè mí ɲúhṹso: ‹Bìo fo le ĩ wé á ĩ wó ká hã lùa ɓúi màhã́ pá ká.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ó o bía nɔn mí ton-sá yi: ‹Wã́a hɛ́ɛ lá hã wãna, à léka hã manawà yi loń, ká ũ fò mín làa nùpua na, à ũ bío ɓúe ɓa ɲúná le ɓa ɓuen ĩ zĩi, bèra a na à le sí. ");
INSERT INTO boxNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Le ĩ bío mu na mia: Bìa á ĩ von ho yahó ɓúenɓúen á nì-kéní kà á ĩ dĩ́nló mu máa zo ɲii.›» ");
INSERT INTO boxNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pã̀ahṹ ɓúi ó o Yeesu lá ho wɔ̃hṹ á ɓa zã̀amáa bò a yi, ó o yèrèmáa wee bío làa ba: ");
INSERT INTO boxNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Yìa le mí ì ɓuen ĩ cɔ̃́n, ká ɓànso yí pã́ mín maá, lè mín nu, á yí pã́ mín hã́a lè mí zàwa, á yí pã́ mín zàwa lè mín hĩ́nni, á yàá pá yí pã́ míten mí bɛɛre, á ɓànso yí dà máa wé ĩ nì-kenínii. ");
INSERT INTO boxNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yìa yí máa lá mí *kùrùwá pĩ̀ à bèráa miì, wón ɓànso yí dà máa wé ĩ nì-kenínii. ");
INSERT INTO boxNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hen ká minɛ́n ó o ɓúi lá le mí ì so le zĩ-beenì, ó o so máa kɛɛní ká a máa le mí yi le wárí na o ò dé le yi bìo yi, à loń ká dìo wi o cɔ̃́n á dà le wee so á à ɓueé le? ");
INSERT INTO boxNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ká bṹn pã́ ká a fárá le ɲúhṹ á le yí dàńna yí ɓon, ɲún-sĩ á bìa wee mi le wé è yáa mí ɲiní yi á à na a yi ká ɓa à bío: ");
INSERT INTO boxNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹O nìi na kà son mí zĩi hũ̀inía yi ò o yí dàńna le yí ɓueéra.› ");
INSERT INTO boxNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Mu mún lée dà-kéní là a bɛ́ɛ ɓúi na á ɓa ninza bɛ́ɛ ló wà ɓueé tá le hã hĩ́a. O so máa kɛɛní ká a máa loń le mí dásíwá muaaseé pírú á dà wee sánsá mí zúkúso dásíwá muaaseé ɓóní na wà ɓueé fi làa wo le? ");
INSERT INTO boxNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ká a zũ le mí yí dà mu, o ò fèn ǹ tonka ɓa nùpua á ɓa à khɛ̀n vaá sĩ́ a yahó á à tùa wo yi làa bìo ó o ko ò o wé na a yi, à bè yi yíráa ho hɛ́ɛrà.» ");
INSERT INTO boxNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ò o Yeesu wã́a bía: «Mi le mi yiwa sese. Minɛ́n ó o ɓúi yí dà máa wé ĩ nì-kenínii ká ɓànso yí pã́ bìo wi o cɔ̃́n ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mu yámú yoo. Ɛ̀ɛ ká mu yámú yonyoró hĩ́a ló mu yi, á ɓa à wé kaka á mu ù bĩní ì zoráa. ");
INSERT INTO boxNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mu cũ̀nú wã́a mía, mu yí dà máa yèrèmá máa wé bìo ɓúi ho tá yi, á mu mún yí dà máa wé duioró. Ɓa wé yénní mu kúia. Yìa wee ɲí bìo, à wón ɲí bìo bía sese.» ");
INSERT INTO boxNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wizonle ɓúi á ho *lànpó féwá lè ɓa bè-kora wérowà vá ɓueé kĩ́nía o Yeesu yi á wee ɲí a bíoní. ");
INSERT INTO boxNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bìo ɓa *Farizĩɛwa lè ho *làndá bìo zéenílowa mɔn mu á ɓa sĩa wee cĩ̀ á ɓa wee bío mín yi: «Mi loń, o nùpue mu mána mín lè ɓa bè-kora wérowà á wee dí làa ba.» ");
INSERT INTO boxNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ó o Yeesu wà le wàhiire na kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Minɛ́n ó o ɓúi pia khĩmàni lá wi, ó o yà-kéní wó wó sɛ́ra vṹnun, ó o so máa kúia ɓa khĩmàni yà-kéní mía na ká le dùure yi ká a máa vaá cànka yìa vṹnun fúaa o yú a le? ");
INSERT INTO boxNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ká a hĩ́a vaá yú a, ó o sĩi ì wa wa á à lá a yòó pĩ̀ á à khíɓoráa. ");
INSERT INTO boxNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","O ɓuee dɛ̃ɛníi o ò ve mín bɔ̃́nlowà làa bìa làa wó ɓó mín yi á à bío ò na yi: ‹Ĩ pio yà-kéní na lá vṹnun á ĩ wã́a cà yú. Mi le wa páaní zã̀maka mu bìo yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Le ĩ bío mu na mia: Lé kà síi á le sĩ-wɛɛ mún ǹ wéráa hen na le Dónbeenì lè mí tonkarowà yòó wi yi, o nùpue nì-kéní na khú mu bè-kora wéró yi bìo yi, á à poń ɓa nì-tentewà khĩmàni nì-kéní mía na màkóo mía ho yèrèmáló yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Tàá ká a hã́a ɓúi wɛ́n-hãani bìo pírú lá wi, ó o wó wó vĩ́inía le dà-kéní, ó o so máa dé le fĩ̀ntã́ní á máa sàa mí zĩi ká a cà le kùaráa ɓúenɓúen yi fúaa o yú le le? ");
INSERT INTO boxNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ká a yú le o ò ve mín bɔ̃́nlowà làa bìa làa wó ɓó mín yi á à bío ó na yi: ‹Ĩ wɛ́n-hɔ̃nló na lá vṹnun á ĩ yú. Á mí le wa páaní zã̀maka mu bìo yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Le ĩ bío mu na mia: Lé kà síi á le Dónbeenì wáayi tonkarowà sĩa á à waráa o bè-kora wéro nì-kéní na khú mu bè-kora wéró yi bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bṹn mɔ́n ó o Yeesu pa bĩnía bía bìo kà: «Nìi ɓúi zàwa nùwã ɲun hĩ́a wi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wizonle ɓúi ó o fɛ̀ɛso bía nɔn mín maá yi: ‹Ĩ maá, sanka wàn kĩ́a à ũ na ĩnɛ́n bìo.› Ó o maá ɓɛ̀n sankaa mí nàfòró á nɔn mí zàwa nùwã ɲun mu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Wizooní bìo yɛn bṹn mɔ́n, ó o fɛ̀ɛso yɛ̀ɛ́ra bìo ó o yú ɓúenɓúen á lá wárí ò o wà van ho kɔ̃hṹ ɓúi na dã́ní nàyi. Bìo ó o vaá wi bĩ́n ó o zon mu koomu yi á yáara mí wárí ɓúenɓúen véenía. ");
INSERT INTO boxNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pã̀ahṹ na ó o wárí mu yáara vó yi, à bṹn le hĩn-sũmúi ɓúi ló ho kɔ̃hṹ mu yi, á mu bìo ɓúenɓúen hĩni wee tè o. ");
INSERT INTO boxNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ó o vaá yú ho kɔ̃hṹ mu nùpue ɓúi á wón le o wé vaa pa mí nɔ̀nbùɛɛní mí mɔhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Á ɓa nɔ̀nbùɛɛní dĩ́nló ó o sĩi wee bĩní vá yi lè ho díró ká nùpue màhã́ yí máa na ho wo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Ó o hácírí bĩnía ɓuara bìo ó o wó khĩína wán, ó o zũna le mí wó khon, ó o wee bío mí yi: ‹Wàn maá ton-sáwá ɓúenɓúen wee dí ho dĩ́nló sa míten, à ĩnɛ́n wón ɓueé wee hí hen lè le hĩni. ");
INSERT INTO boxNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ĩ ì bĩní ì va wàn maá cɔ̃́n á vaá bío ò na a yi: Ĩ maá, ĩ ɓɛ̀ntĩ́n wó khon lè le Dónbeenì á mún wó khon làa fo, ");
INSERT INTO boxNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","á ĩ wã́a yí ko à ũ bĩní ɓua mi lè ũ kùrú za tenii bìo, ká ũ ɓua mi lè ũ ton-sá bìo síi.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ò o wã́a hĩ́nɔn wà ɲɔn mín maá zĩi. Bìo ó o khɛ̀ra yòó ló lua, á ɓàn maá fèra mɔn wo, ó o màkárí ɓuan wo yi làa sòobɛ́ɛ, ó o lùwa wee sĩ́ mí za mu yahó á vaá wìira a kùkà á wee bɛ̀ɛ́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ó o za wee bío làa wo: ‹Ĩ maá, ĩ wó khon lè le Dónbeenì á mún wó khon làa fo. Ĩ yí ko à ũ bĩní ɓua mi lè ũ kùrú za bìo síi.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ká ɓàn maá màhã́ bía nɔn mí ton-sáwá yi: ‹Mi bánbá zoo lońka à mi lén ho báká beenì na se po hĩ̀a ká à ɓuee lée zĩ́iní làa wo. À mi dé le nín-kízà-fĩ́bɛɛre o nín-kíza yi, à mún zĩ́iní a lè hã nakãa. ");
INSERT INTO boxNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mi lée lén o nɔ̀n-bòohṹ na ɲini wi à ɓúe à wà dí ho sã́nú à wɛɛ́ wa sĩa. ");
INSERT INTO boxNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Lé bìo, á ĩ za mu lá ka lòn nìi na húrun ká a bĩnía vèera. O lá vṹnun, á ĩ bĩnía yú.› À ɓa wã́a cũ̀aana ho sã́nú díró. ");
INSERT INTO boxNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Bṹn ɓúenɓúen wee wé ká a nìi mu za kĩ́nle so van hã mana. Bìo ó o ló hã mana yi ɓueé wee sùará mín zĩi, ó o wee ɲí hã sĩ̀a lè ho yoró sã. ");
INSERT INTO boxNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ó o dĩ̀n ò o von o ton-sá ɓúi tùara yi làa bìo wee wé ɓàn lún yi. ");
INSERT INTO boxNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ó o ton-sá bía nɔn wo yi: ‹Lé mìn fɛ̀ɛ bĩnía ɓuara, á mìn maá léra a nɔ̀n-bòohṹ na ɲini wi á ɓó, lé bìo ó o za bĩnía ɓuara lè le lòn-heɓúee.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ó o kĩ́nle so dɛ̀ɛnía sĩi cã̀ bṹn wán á hɛnɓuaa le mi máa zo. Á ɓàn maá ló le mi lée yanka a ò o ɓuee zo. ");
INSERT INTO boxNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ká a màhã́ bía nɔn mín maá yi: ‹Loń, ĩnɛ́n sá nɔn foǹ hã lúlúio cɛ̀rɛ̀ɛ yi, á hàrí wizoǹ-kéní á ĩ dĩǹ yí pã́ ũ ɲii, ò o vio za sãanì á ũ yàá pá dĩǹ yí nɔn miì le ĩ dí lè ho sã́nú lè wàn bɔ̃́nlowà. ");
INSERT INTO boxNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","À ũnɛ́n za na lá ũ níi bìo vaá yáara véenía ɓa hã́-kora wán bĩnía ɓuara, á ũ màhã́ le ɓa lén o nɔ̀n-bòohṹ na ɲini wi ɓúe.› ");
INSERT INTO boxNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Á ɓàn maá bía nɔn wo yi: ‹Ĩ za, ĩnɛ́n làa fo páanía wi mín wán fɛ́ɛɛ, á bìo á ĩ te ɓúenɓúen bìo sã̀ foǹ. ");
INSERT INTO boxNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ká wa màhã́ ko wa dí ho sã́nú à wɛɛ́ wa sĩa, lé bìo á mìn fɛ̀ɛ mu lá ka lòn nìi na húrun á bĩnía vèera. O lá vṹnun á ĩ bĩnía yú.›» ");
INSERT INTO boxNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bṹn mɔ́n ó o Yeesu wee bío lè mí nì-kenínia: «Nàfòró ɓànso ɓúi hĩ́a lá nùpue ɓúi bàrá mí tonni ɲúhṹ wán. Wizonle ɓúi á ɓa ɓueé bía nɔn wo yi le o ton-sá mu wee yáa o níi bìo dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ó o von wo ɓueé wee bíoráa: ‹Bìo á ĩ ɲá ũ dã́ní yi á so bon le? Wã́a wa lá bìo á ũ wó ɓúenɓúen ɓàn càtíi, bṹn mɔ́n á wa à kúia mín. À ũ tonló vó ĩ cɔ̃́n zuia.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ó o nìi wee bío mí yi: ‹Éee! Ĩ ɲúhṹso wã́a léra mi mí tonni sáró yi á ĩ ì wé kaka? Bìo ho vàró á ĩ yí dà bìo, á ho hɛ́ɛ fìo mún nìyio wi miì. ");
INSERT INTO boxNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Àwa, ĩ wã́a zũ bìo á ĩ wé ká ĩ tonló yáara á ĩ pá à yí ɓa ɓúi na à ɓua mi.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Á bìa ɓúenɓúen na ɓa ɲúhṹso kení wi yi ó o von lè mí nì-kéní kéní. Á yìa ɓuara ho yahó ó o tùara yi: ‹Ĩ ɲúhṹso kee na wi foǹ lé le yɛ́n?› ");
INSERT INTO boxNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Á wón bía: ‹Lée oliivewa bia ɲiló bàrìkónwa khĩmàni.› Ó o bía nɔn wo yi: ‹Lii kɛɛní fùafùa. Fé ũ kee vũahṹ à ũ túa: Ɲiló bàrìkónwa ɓúará-ɲun làa pírú.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ó o bĩnía tùara a ɓúi yi: ‹À ũnɛ́n ɓɛ̀n kee lé le yɛ́n?› Á wón bía: ‹Lée dĩ́nló pórókówá khĩá-hònú.› Ó o bía nɔn wo yi: ‹Fé ũ kee vũahṹ à ũ túa: Dĩ́nló pórókówá khĩá-náa.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bìo ó o ton-sá mu yí térénna ká ɓa ɲúhṹso màhã́ pá khòonía wo hã hénní na ó o yú bìo yi. Lé bìo á ho dĩ́míɲá na kà nùpua zũ mín ɓuaró á po mu khoomu nùpua.» ");
INSERT INTO boxNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ó o Yeesu mu bĩnía bía: «Le ĩ bío mu na mia: Mi wé yú ho dĩ́míɲá nàfòró à mi wé wé bìo mi ì yíráa ɓa bɔ̃́nlowà làa ho, ká ho khíi vó mi cɔ̃́n, á ɓa à fé mia á à zoráa le mukãnì na máa vé lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yìa yú mu bìo na cĩ́inú ó o zũna mu ɓuaró, wón ɓa nɔn bìo boo yi ó o mún ǹ zũń mu ɓuaró. Yìa yí térénna mu bìo na cĩ́inú yi, ó o mún máa térén mu bè-beera yi. ");
INSERT INTO boxNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ká mi yú ho dĩ́míɲá nàfòró á mi yí zũna hón ɓuaró, á lée wée á à tá à na ho nàfòró tente mia? ");
INSERT INTO boxNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","O nì-veere bìo na ɓa kàràfáa mia á mi yí zũna ɓuaró, á mi kùrú bìo á ɓa mún máa na mia. ");
INSERT INTO boxNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ton-sá woon yí dà máa sá máa na ɲúnása nùwã ɲun yi. O ò ɲin o nì-kéní, ká a wań yìa so. O wé è ɲí a nì-kéní bíonì, ká yìa so ó o máa kɔ̃̀nbi. Mi yí dà máa sá máa na le Dónbeenì yi ká mi mún pá henía le wárí càró bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bìo ɓa *Farizĩɛwa ɲá hã bíoní mu, á ɓa wee yáa mí ɲiní yi na a Yeesu yi, lé bìo á ɓa dó mí sĩa le wárí càró yi dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ká a Yeesu màhã́ bía nɔn ɓa yi: «Minɛ́n wee wé míten lè ɓa nì-tentewà ɓa nùpua yahó, ɛ̀ɛ ká le Dónbeenì dén zũ bìo wi mi yiwa, lé bìo á bìo ɓa nùpua wee mi à wé lè mu bè-beenì á le Dónbeenì yí máa tà yi. ");
INSERT INTO boxNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«O *Mɔyiize làndá lè le *Dónbeenì ɲi-cúa fɛɛrowà vɔ̃nna á pã̀ahṹ wà fɛ́ɛɛ ɓueé ɓó a Zãn Batiisi ɓuenló yi. Wón ɓuenló ɲii lé bṹn á le *Dónbeenì bɛ́ɛnì bìo bueró ɲúhṹ ɓúa yi, á ɓa nùpua lè mí nì-kéní kéní wee ɲàa mín le bɛ́ɛnì mu zoró yi wán. ");
INSERT INTO boxNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","«Ho wáayi lè ho tá véró á wayi po ho làndá bín-za dɛ̀ɛ na cĩ́inú vĩ́ló. ");
INSERT INTO boxNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Báa na día mín hã́a ò o bĩnía fó hã́-veere yan lée hã́-fé. Á yìa fó a hã́a na ɓàn báa día wo á yan mún lé o hã́-fé.» ");
INSERT INTO boxNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Bṹn mɔ́n ó o Yeesu pá bĩnía bía bìo kà: «Nùpue ɓúi hĩ́a wi bĩ́n á nàfòró wi á wee zĩ́ hã sĩ̀-sení na yàwá here. Wizooní ɓúenɓúen lée sã́nú díró o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nì-khenii ɓúi na yèni ɓa le Lazaare, na sãnía ɓúenɓúen vó lè hã dokuaa á hĩ́a wee ɓuee da a nàfòró ɓànso mu khũuhũ. ");
INSERT INTO boxNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","O sĩi yàá wee wé vá a nìi mu dĩ́nló na wee kùenka lii kúia yi lè ho díró. À bè bṹn wán, á ɓa booní wee wé ɓuee dɛnka a dokuaa. ");
INSERT INTO boxNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wizonle ɓúi ó o nì-khenii mu húrun, á le Dónbeenì wáayi tonkarowà ɓueé lií lá a yòó bàrá a *Abarahaamu nìsã́ní. Bṹn mɔ́n ó o nàfòró ɓànso mún húrun á ɓa nùuna. ");
INSERT INTO boxNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bìo ó o wi ho nì-hɔ̃́nbó-lóhó yi, ó o lò wee be dàkhĩína. Ó o hóonía mí yahó le mí ì loń, ó o khɛ̀ra mɔn o Abarahaamu ò o Lazaare kará a nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","«Ó o von wo pɔ̃́npɔ̃́n: ‹Wàn ɓùaa Abarahaamu, loń ĩ màkárí yi à ũ tonka a Lazaare le o dé mí nín-kíza ɲúhṹ mu ɲumu yi, à ɓuee wɛɛ́ lè ĩ dɛnle, lé bìo á ĩ lò ɓɛ̀ntĩ́n wee be ho dɔ̃hṹ na kà yi dàkhĩína.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ká a Abarahaamu màhã́ bía nɔn wo yi: ‹Ĩ za, le ũ yi, bìo á ũ yìo fù lua á ũ yú mu bè-sení cɛ̀rɛ̀ɛ á wɛɛ́ra lè ũ sĩi, ò o Lazaare bìo wó hã yinyio. Ho zuia á wón yú mí lònbee cũ̀nú à ũnɛ́n ɓɛ̀n yú le lònbee. ");
INSERT INTO boxNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bṹn pá níi ló, á ho kã-be-beenì wi warɛ́n làa mia pã̀ahṹ, bèra a na ká bìa le mí ì lé hen á à khí mí cɔ̃́n à ɓa yí dàń mu. Á nùpue mún yí dà máa lé hen na á ũ khíi wi yi máa ɓuen wa cɔ̃́n.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ó o nàfòró ɓànso bía nɔn wo yi: ‹Ĩ pá à bĩní ì fìo fo. Sábéré à ũ tonka a Lazaare mu ò o lii wàn maá zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Wàn zàwa nùwã hònú lií wi bĩ́n, ò o lii ɲì ɓa zeǹ wán à bán wã́a yí ɓuee zo le lònbe-beenì na kà lahó yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ó o Abarahaamu bía nɔn wo yi: ‹O *Mɔyiize làndá lè le *Dónbeenì ɲi-cúa fɛɛrowà bíoní wi bĩ́n, le mìn zàwa mu wé ɲí hɔ̃́n.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ó o nàfòró ɓànso bía: ‹Wàn ɓùaa Abarahaamu, bṹn pá máa yí ɓa. Hen ká bìa húrun nì-kéní ɓúi lá ló lion ɓa cɔ̃́n á ɓa à yèrèmá wárá.› ");
INSERT INTO boxNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ká a Abarahaamu màhã́ bía nɔn wo yi: ‹Ká ɓa yí máa ɲí a Mɔyiize lè le Dónbeenì ɲi-cúa fɛɛrowà cɔ̃́n, á hàrí à nì-hío ɓúi vèe, á ɓa pá máa tà.›» ");
INSERT INTO boxNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Bṹn mɔ́n ó o Yeesu bía nɔn mí nì-kenínia yi: «Bìo wee vá a nùpue dé mu bè-kohó wéró yi bṹn yí dà máa hè hùúu. Ɛ̀ɛ ká yìa màhã́ níi bò mu bìo, wón á ho yéréké è sá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hàrí ɓa ca le hue-beenì o fonle yi à lèe dé ho muhṹ yi, bṹn pá à wé wayi á à poń le lònbee na à yí o ká mu lé orɛ́n nɔn á ɓa háyúwá na kà nì-kéní ɓúi wó mu bè-kohó. ");
INSERT INTO boxNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mi cén pa miten bìo sese. «Hen ká mi ninza ɓúi wó khon làa fo à ũ zéení a wékheró na a yi. Ká a tà le mí ì khí mu yi, à ũ sɛ́n mu día na a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ká a wó khon làa fo le wizon-kùure yi hã zen cúa-hèɲun, à mu lè mí dà-kéní kéní ó o wee ɓuee dĩ̀n ũ yahó le mí ì khí mu yi, à ũ sɛ́n mu día na a yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɓa tonkarowà bía nɔn wo yi: «Ɲúhṹso, dé wa sĩidéró wàn.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ó o Ɲúhṹso bía: «Hen ká mi sĩidéró na khúekhúe lè ho mútáàdè bɛɛre bìo á mi yàá pá lá tà le mí ì wé làa bìo, á mi lá dà à bío ò na le vĩ̀ndɛ̀ɛ na kà yi: ‹Dè ho lahó na ũ wi yi a vaa zoo fá ũten ho muhṹ yi›, á le è wé mu. ");
INSERT INTO boxNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Hen ká minɛ́n ó o ɓúi ton-sá lá wi á wee và a mɔhṹ tàá o wee pa a sároń bùaa síi, ká a ló hã mana yi ɓuara, á mi ì bío le o dɛ̀ɛní ɓuee kɛɛní ò o dí le? ");
INSERT INTO boxNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yínɔń bìo kà mi ì bío ò na a yi le: ‹Sá ho dĩ́nló na miì, wíoka ũten à ũ lá ho ɓuennáa le ĩ dí à ĩ ɲu. Bṹn mɔ́n á ũnɛ́n màhã́ à dí ká ũ ɲu.› ");
INSERT INTO boxNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","O so o tɛ̀ɛní mí ton-sá mu yi bìo ɓa le o wé ó o wó bìo yi le? Ɓùeé. ");
INSERT INTO boxNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Minɛ́n bìo làa bṹn mún lée dà-kéní. Bìo le Dónbeenì le mi wé ká mi wó mu vó, à mi bío bìo kà: ‹Wa lée ton-sáwá na á nùpue yí ko ò o na bìo yi. Bìo ɓa le wa wé lé bṹn mí dòn á wa wó.›» ");
INSERT INTO boxNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bìo ó o Yeesu wee va ho Zeruzalɛɛmu, ó o bò le sṹii na wi ho *Samarii lè ho Kalilee pã̀ahṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ó o vaá wee sùará ho lóhó ɓúi yi, à *ɓùeréwà nùwã pírú wee sĩ́ a yahó. Á ɓa khɛ̀ra dĩ̀n ");
INSERT INTO boxNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","à ɓa wee wãamaka pɔ̃́npɔ̃́n: «Yeesu! Nì-kàránlo! Zũń wa màkárí.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bìo ó o Yeesu mɔn ɓa, ó o bía nɔn ɓa yi: «Mi lɛ́n vaa zéení míten lè le *Dónbeenì yankarowà.» Á bìo ɓa bò mín wee va bĩ́n, á ɓa wan. ");
INSERT INTO boxNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bìo ɓa nì-kéní mɔn ò o wan, ó o bĩnía tò mí laà yi á wee khòoní le Dónbeenì pɔ̃́npɔ̃́n ká a ɓuen, ");
INSERT INTO boxNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","á ɓueé lií ɓúrá a Yeesu tá, á yahó ɓó ho tá yi, ò o wee dé o bárákà. O lée Samarii nìi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ó o Yeesu wã́a bía: «Ɓa mí nùwã pírú ɓúenɓúen yí wan le? Á ɓa nùwã dènú na ká ɓɛ̀n zon wen? ");
INSERT INTO boxNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bán tĩ́ahṹ ó o ɓúi yí leékaa ò o bĩní ɓuee ɓùaaní le Dónbeenì ká mu yínɔń ho sìí veere nùpue na kà mí dòn le?» ");
INSERT INTO boxNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bṹn mɔ́n ó o Yeesu bía nɔn wo yi: «Lii hĩ́ní lɛ́n, à ũ sĩidéró miì wɛɛ́ra fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wizonle ɓúi á ɓa *Farizĩɛwa tùara a Yeesu yi le lé ho pã̀ahṹ yɛ́n á le *Dónbeenì bɛ́ɛnì á à ɓuen yi. Ó o bía nɔn ɓa yi: «Le Dónbeenì bɛ́ɛnì ɓuenló yínɔń bìo na wee mi làa yìo. ");
INSERT INTO boxNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɓa máa bío le: ‹Mí loń, mu wi hen› tàá ‹Lé vaá hen á mu wi yi.› Lé bìo á mi ko à mi zũń mu le le Dónbeenì bɛ́ɛnì wi làa mia vó.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bṹn mɔ́n ó o bía nɔn mí nì-kenínia yi: «Pã̀ahṹ ɓúi ɓueé dã ó o *Nùpue Za wizooní dà-kéní ɓúi á mi sĩa á à vá yi lè ho miló ká mi máa mi le. ");
INSERT INTO boxNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","«Ɓa à bío ò na mia: ‹O wi hen› tàá ‹Lé vaá làa hen ó o wi yi.› Ɛ̀ɛ ká mi yí va bĩ́n, mi yí lùwí mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Làa bìo ká ho viohó ɲuiína ho wáayi lùe ɓúi à mu khoomu dɛ̀ɛní kɛń lùa ɓúenɓúen, lé bṹn ɓàn síi ó o Nùpue Za bĩní ɓuenló wizonle bìo khíi wéráa. ");
INSERT INTO boxNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ɛ̀ɛ ká a màhã́ ko ò o lò be làa sòobɛ́ɛ vé, à ho pã̀ahṹ na kà nùpua pĩ́ a bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Bìo wó a Nɔwee pã̀ahṹ lé bìo ɓàn síi khíi wé o *Nùpue Za bĩní ɓuenló pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓa nùpua hĩ́a wee dí ká ɓa à ɲu, á wee ya mín ká ɓa a yɛɛ́ mí zàwa mín yi fúaa nɔ̀nzoǹ na ó o Nɔwee zon ho won-beenì yi á mu ɲun-beenì ɓuara ɓueé ɓó ɓa ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mu mún khíi wé làa bìo hĩ́a wó a Loote pã̀ahṹ. Ɓa nùpua hĩ́a wee dí á wee ɲu, á wee yà ká ɓa a yɛ̀ɛ́ mí bìowa, á wee dì ká ɓa a so. ");
INSERT INTO boxNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ɛ̀ɛ ká nɔ̀nzoǹ na ó o Loote ló ho Sodɔɔmu yi, á ho dɔ̃hṹ lè ho kìríbì ló ho wáayi á tò ɓa wán, á ɓó ɓa véenía. ");
INSERT INTO boxNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lé bṹn ɓàn síi mún khíi wé nɔ̀nzoǹ na ó o Nùpue Za ko ò o mi wán. ");
INSERT INTO boxNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mu zoǹ à yìa wi mí zĩi lòho yí bío le mí ì lii á zoó khuii mí sĩ̀a, à yìa hã mana yi mún yí bío le mí ì bĩní ì ɓuen mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mi leéka a Loote ɓàn hã́a bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yìa wi ò o fení mí mukãnì wón á à vĩ́iní le. Ká yìa vĩ́inía mí mukãnì wón á à yí le. ");
INSERT INTO boxNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Le ĩ bío mu na mia: Mu zoǹ tĩ́nàahṹ á ɓa nùpua nùwã ɲun na páanía dũma le dãmu dɛ̀ɛ dà-kéní wán, ó o nì-kéní á à fé è lɛ́nnáa, ká yìa so á à día. ");
INSERT INTO boxNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɓa hã́awa nùwã ɲun na páanía wee ni mu bìo, ó o nì-kéní á à fé è lɛ́nnáa, ká yìa so á à día. ");
INSERT INTO boxNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɓa báawa nùwã ɲun na wi hã mana yi, ó o nì-kéní ɓa à fé è lɛ́nnáa, ká ɓa à día a nì-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ó o nì-kenínia tùara a yi: «Ɲúhṹso, lé wen á mu ù wé yi?» Ó o bía nɔn ɓa yi: «Hen na ó o yà-hínii día yi, lé bĩ́n á ɓa dùɓúawá wee wé fè mín yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bìo ó o Yeesu wi ò o zéení lè mí nì-kenínia le ɓa ko ɓa wé fìo fɛ́ɛɛ à bàra yí tè hùúu, ó o wà le wàhiire na kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Cítí-fĩ̀ ɓúi hĩ́a wi lóhó ɓúi yi. O yí máa zɔ̃́n Dónbeenì, á mún yí máa kɔ̃̀nbi nùpue. ");
INSERT INTO boxNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mahã́a ɓúi mún hĩ́a wi ho ló-kéní mu yi á wee ɓuen o nìi mu cɔ̃́n fɛ́ɛɛ à ɓuee bío bìo kà na a yi: ‹Mì ĩnɛ́n le ĩ fioso tũ̀iá.› ");
INSERT INTO boxNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","O wó mu míana ò o nìi mu wee pĩ́ a bìo. Ká mu màhã́ a va à yí, ò o sã́ san ó o wee bío mí yi: ‹Ĩ yí máa zɔ̃́n le Dónbeenì, á ĩ mún yí máa kɔ̃̀nbi nùpue bṹn bon, ");
INSERT INTO boxNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ká a mahã́a na kà ɓɛ̀ntĩ́n lan miì dàkhĩína. Ĩ ì wé bìo ó o wee cà, ò o wé yí ɓuee dĩ̀n sɛɛ́ mi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ò o Ɲúhṹso bĩnía bía nɔn ɓa yi: «Mi loń bìo ó o cítí-fĩ̀-kohó mu na kà wó. ");
INSERT INTO boxNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mi wee leéka le le Dónbeenì so máa na ho tũ̀iá sĩni bìa le hueekaa yi na wee ve le pɔ̃́npɔ̃́n le wisoni lè ho tĩ́nàahṹ yi le? ");
INSERT INTO boxNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Le ĩ bío mu na mia: Le è na ho tũ̀iá sĩni ɓa yi ho pã̀ahṹ na mu ko yi. Ɛ̀ɛ ká a *Nùpue Za màhã́ khíi bĩnía ɓuara, ó o ɓueé yí ɓa nùpua na dó mí sĩa le Dónbeenì yi ho tá wán le?» ");
INSERT INTO boxNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","O mún bĩnía wà le wàhiire ɓúi á bò bìa wee leéka le mí térénna à ɓa wee zùań bìa ká yi wán: ");
INSERT INTO boxNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nùpua nùwã ɲun ɓúi hĩ́a wà yòó wé ho fìoró le *Dónbeenì zĩ-beenì yi. O nì-kéní lée *Farizĩɛ ká yìa so lée *lànpó fé. ");
INSERT INTO boxNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ó o Farizĩɛ zoó fárá dĩ̀n ho wáayi á wee fìo mí yi kà: ‹Dónbeenì, ĩ wee dé ũ bárákà, lé bìo á ĩ yí ka lè ɓa nùpua na ká bìo. Ɓa wee tè ɓa nùpua wán, á wee ɲuaa, á lé ɓa hã́-féwá, sɔ̃̀nkú o lànpó fé na kà. ");
INSERT INTO boxNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ĩnɛ́n wee lì ĩ ɲii hã cúa-ɲun ho yàwá ɲúhṹ dà-kéní yi, á bìo á ĩ wee yí ɓàn cúa-pírú níi á ĩ mún wee na foǹ.› ");
INSERT INTO boxNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ò o lànpó fé wón vá lií dĩ̀n le kùɛɛ́rè yi á yàá yí wi ò o hóoní mí yahó ho wáayi á wee hiimika ká a bío mí ɲi-kã́a yi kà: ‹Dónbeenì, màkárí miì, ĩ lée bè-kora wéro.›» ");
INSERT INTO boxNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ó o Yeesu bĩnía bía bìo kà: «Le ĩ bío mu na mia: Ɓa nùwã ɲun mu tĩ́ahṹ ó o lànpó fé lé yìa bĩnía van mí zĩi ká a térénna le Dónbeenì yahó. Lé bìo á yìa wee yòoní míten á le Dónbeenì á à liiní, ká yìa wee liiní míten á le è yòoní.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hàrí ɓa háyúwá á nùpua ɓúi ɓuan ɓuararáa o Yeesu cɔ̃́n le o bè mí níní ɓa wán. Bìo ó o nì-kenínia mɔn mu, á ɓa wee zá làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ká a Yeesu màhã́ von ɓa, ò o bía: «Mi día le ɓa háyúwá wé ɓuen ĩ cɔ̃́n, mi yí hè ɓa, lé bìo le *Dónbeenì bɛ́ɛnì bìo sã̀ bìa ka lè ɓa bìo síi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Le ĩ mì ho tũ̀iá na mia: Yìa yí tà le Dónbeenì bɛ́ɛnì bìo là a háyónza bìo síi, á ɓànso yí dà máa zo le yi hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ɓa *zúifùwa ɲúnása nì-kéní ɓúi tùara a Yeesu yi: «Nì-kàránlo tente, ĩ ko à ĩ wé mu yɛ́n à yíráa le mukãnì na máa vé.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ó o Yeesu bía nɔn wo yi: «Lée webio nɔn á fo wee veráa mi làa nì-tente? Nì-tente mía ká mu yínɔń le Dónbeenì mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fo zũ le Dónbeenì làndáwá na kà: Yí wé hã́-fénló tàá bá-fénló, yí ɓúe nùpue, yí ɲuaa bìo, yí fĩ̀ sábéré mi ninza ɲii, kɔ̃̀nbi mìn maá le mìn nu.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ó o nìi bía nɔn wo yi: «Bṹn ɓúenɓúen á ĩ bò yi hàrí ĩ yàrónzàmu pã̀ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bìo ó o Yeesu ɲá a ɲi-cúa vó, ó o bía nɔn wo yi: «Bìo dà-kéní pá fòora foǹ. Vaa yɛ̀ɛ́ bìo wi ũ cɔ̃́n ɓúenɓúen à sanka ɓàn wárí na ɓa nì-khenia yi, bṹn ká fo ò yí ho nàfòró ho wáayi. Bṹn mɔ́n à ũ bĩní ɓuee bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ká a nìi mu ɲá hã bíoní mu, ó o sãnía tò, lé bìo ó o níi bìo boo dà. ");
INSERT INTO boxNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bìo ó o Yeesu mɔn ò o yahó so, ó o bía bìo kà: «Ho nàfòró ɓànsowà zoró le Dónbeenì bɛ́ɛnì yi ɓɛ̀ntĩ́n á à wé here. ");
INSERT INTO boxNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","O cón-ɲúmúkũ̀ zoró lè ho mísĩ̀mí kɔ̃hṹ á à wé wayi á à poń o nàfòró ɓànso zoró le Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Á bìa dĩ̀n wee ɲí a bíoní tùara a yi: «Éee! Á yìa wã́a dà à fen lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ó o Yeesu bía nɔn ɓa yi: «Bìo yí dà máa wé ɓa nùpua cɔ̃́n á dà wee wé le Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bṹn mɔ́n ó o Piɛre bía nɔn wo yi: «Loń, warɛ́n ló día bìo lá wi wa cɔ̃́n à wa bò foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Yìa ló día mí zĩi, tàá mín hã́a, lè mín zàwa, lè mín nùwã, lè mí zàwa le Dónbeenì bɛ́ɛnì bìo yi, ");
INSERT INTO boxNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ó ò yí bìo cɛ̀rɛ̀ɛ á à poń bṹn ho pã̀ahṹ na wa wi yi, á mún pá à yí le mukãnì na máa vé ho yìró na lua yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","O Yeesu fó mí nì-kenínia pírú ɲun mí ɲúhṹ wán á bía nɔn ɓa yi: «Mi loń, wa wee yòo ho Zeruzalɛɛmu, á bìo ɓúenɓúen na le *Dónbeenì ɲi-cúa fɛɛrowà túara o *Nùpue Za dã́ní yi á ɲii yòó sí bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lé bìo ɓa à dé o bìa yí zũ le Dónbeenì níi yi, á bán ǹ zùań yi, á à là, á à pũ̀iní mí ɲinsãní ì kúee o wán. ");
INSERT INTO boxNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ɓa à ha a lè hã làbàaní, á à ɓúe o. Ká mu wizooní tĩn zoǹ, o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ká a nì-kenínia màhã́ yí zũna dɛ̀ɛ woon mu yi. Hã bíoní mu ɓàn kúará á sà ɓa yi á ɓa yí zũ bìo ó o Yeesu wi ò o bío ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bìo ó o Yeesu vaá wee sùará ho Zerikoo yi, à bṹn ò o muii ɓúi kará ho wɔ̃hṹ nìsã́ní wee fìoka. ");
INSERT INTO boxNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bìo ó o ɲá ɓa zã̀amáa na wee khĩí sã, ó o tùara bìo wee wé. ");
INSERT INTO boxNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Á ɓa bía nɔn wo yi le lé o Nazarɛɛte nìi Yeesu lé yìa wee khĩí. ");
INSERT INTO boxNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ó o wee bío pɔ̃́npɔ̃́n: «*Daviide Za, Yeesu, màkárí miì!» ");
INSERT INTO boxNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Á bìa wi ho yahó wee nàmaka a yi le o wé tɛ́tɛ́. Ká a yàá wíokaa wee wãama lè mí sòobɛ́ɛ: «Daviide Za, màkárí miì!» ");
INSERT INTO boxNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ó o Yeesu dĩ̀n ò o le ɓa ɓua a muii mu ɓuennáa. Bìo ó o ɓueé dɔ̃n, ó o tùara a yi: ");
INSERT INTO boxNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Lée webio á fo le ĩ wé na foǹ?» Ó o bía: «Ɲúhṹso, wé le ĩ yìo à wé mi.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ó o Yeesu bía nɔn wo yi: «Wã́a mi, bìo fo dó ũ sĩi miì lé bṹn á ĩ wɛɛ́raráa fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mí lahó yi ó o dɛ̀ɛnía wee mi, á bò a Yeesu yi á wee khòoní le Dónbeenì. Á ɓa zã̀amáa ɓúenɓúen mɔn mu á ɓa mún wee khòoní le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bìo ó o Yeesu vaá zon ho Zerikoo, ó o tò ho yi wee kã́a. ");
INSERT INTO boxNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","O nìi ɓúi wi ho lóhó mu yi á yèni ɓa le Zasee. O lé ho *lànpó féwá ɲúhṹso ɓúi, á nàfòró wi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","O wee cà ò o mi a Yeesu à zũń, ó o wó san, lé bìo ɓa nùpua boo dà, ò o mún lé o nì-ɓúinɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ó o lùwa dú ho yahó á vaá yòora le vĩ̀ndɛ̀-beenì ɓúi na ɓa le sikomɔɔre, na dĩ̀n hen na ó o Yeesu wà ɓuee khĩí yi, ò o dàń mináa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bìo ó o Yeesu ɓueé dɔ̃n le lùe mu, ó o hóonía mí yahó ò o von wo: «Zasee, ɓuee lii fùafùa. Lé fo á ĩ ko à ĩ làa wán ho zuia.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ó o Zasee dɛ̀ɛnía bánbáa lion, á lií fó a Yeesu vannáa mí zĩi lè hã zã̀makaa. ");
INSERT INTO boxNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Á bìa ɓúenɓúen na mɔn mu á mu yí sĩ yi á ɓa wee hũ̀ahṹaaka: «O nùpue mu vaá làara a bè-kora wéro wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ká a Zasee wón màhã́ hĩ́nɔn yòó dĩ̀n o Yeesu yahó ò o wee bío: «Ɲúhṹso, loń, ĩ níi bìo ɓàn sanka màní á ĩ ì na ɓa nì-khenia yi, ká ĩ mún tò a ɓúi wán mu ɓúi yi, á ĩ ì na mu ɓàn cúa-náa ɓànso yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ó o Yeesu bía nɔn wo yi: «Le zĩi na kà nùpua wã́a kã̀nía ho zuia, lé bìo ó o nìi na kà mún lé o *Abarahaamu mɔ̀nmàníi ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lé bìo ó o *Nùpue Za ɓuara wà ɓueé cà bìa khɛ̀ra lè le Dónbeenì, á à fení.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ó o Yeesu bĩnía wà le wàhiire dà-kéní á nɔn bìa dĩ̀n ɲá hã bíoní mu yi. Lé bìo ó o sùaráa lè ho Zeruzalɛɛmu, á ɓa mún wee leéka le le *Dónbeenì bɛ́ɛnì á à dɛ̀ɛní ì zéení míten mí lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bìo kà lé bìo ó o bía: «Nìi ɓúi na sã̀ se mín zĩi á ko ò o lá le bɛ́ɛnì, ó o ló van ho kɔ̃hṹ ɓúi na dã́ní nàyi á wà vaá lá le bĩ́n ká a bĩní ì ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sã́ni ò o lɛ́n, ó o von mí ton-sáwá nùwã pírú á sankaa ho sã́nú kùráa dà-kéní kéní nɔn yi, ò o bía: ‹Mi bánbá duan làa ho ká ĩ ì ɓuen.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ká ɓa kɔ̃hṹsa màhã́ ɲina a á ɓa tonkaa ɓa nùpua le ɓa ɲa a mɔ́n à vaa bío bìo kà: ‹Wa yí wi ò o nìi mu wé wa bɛ́ɛ.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Bìo ó o vaá lá mí bɛ́ɛnì bĩnía ɓuara mín kɔ̃hṹ, ó o von ɓa ton-sáwá na ó o kàràfáa mí sã́nú yi. O wi ò o zũń bìo ɓa sá yú làa ho. ");
INSERT INTO boxNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Ó o nín-yání nùpue ɓuara á bía: ‹Ɲúhṹso, ũ sã́nú kùúrè na á ũ nɔn miì á ĩ bĩnía yú hã kùráa bìo pírú séenía.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ó o bɛ́ɛ bía nɔn wo yi: ‹Foɓúa, fo wó se. Fo lée ton-sá tente, bìo á fo térénna mu bè-wĩ́níwà yi, á ĩ ì bàrá fo hã ló-beera bìo pírú ɲúhṹ wán.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Á yìa sã̀ ɓuara ɓueé bía: ‹Ɲúhṹso, ũ sã́nú kùúrè na á ũ nɔn miì á ĩ bĩnía yú hã kùráa bìo hònú séenía.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ó o bɛ́ɛ bía nɔn wo yi: ‹À ũnɛ́n á ĩ ì bàrá hã ló-beera bìo hònú ɲúhṹ wán.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ó o ɓúi bĩnía ɓuara ɓueé bía: ‹Ɲúhṹso, ũ sã́nú kùúrè na á ũ nɔn miì, nín-dìo. Ĩ lá dó le le nín-kéní yi bàrá, ");
INSERT INTO boxNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","lé bìo á ĩ zã́na fo. Fo lé o nùpue na mukãní ɲii. Fo wee lá bìo á ũ yí bàrá, á wee lá ho dĩ́nló na á ũ yí dù.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Ó o bɛ́ɛ bía nɔn wo yi: ‹Ton-sá kohó yɛ́n! Ĩ ì cítí fo ũ kùrú ɲi-cúa wán. Fo fù zũ le ĩ ɲii, á wee lá bìo á ĩ yí bàrá, á mún wee lá ho dĩ́nló na á ĩ yí dù, ");
INSERT INTO boxNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ká bṹn fo zũ, á lée webio nɔn á ũ yí vaá bàrá le ho banki yi? Se bìo á ĩ bĩnía ɓuara, á ĩ lá ɓueé fé le lè le ɓàn cũ̀nú.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Bṹn mɔ́n ó o bía nɔn bìa wi bĩ́n yi: ‹Mi fé ho sã́nú kùúrè mu o cɔ̃́n à na hã kùráa bìo pírú ɓànso yi.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Á ɓa bía nɔn wo yi: ‹Ɲúhṹso, wón á hã bìo pírú wi cɔ̃́n vó.› ");
INSERT INTO boxNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ó o bía nɔn ɓa yi: ‹Le ĩ bío mu na mia: Yìa bìo wi á ɓa à bĩní ì na mu ɓúi wo yi á à bè mu wán. Ɛ̀ɛ ká yìa bìo mía, á hàrí mu bè-za na wi o cɔ̃́n á ɓa pá à fé. ");
INSERT INTO boxNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ká ĩ zúkúsa na yí wi á ĩ wé ɓa bɛ́ɛ á mí ɓua ɓuennáa hen à ɓuee ɓúe ĩ yìo yi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bìo ó o Yeesu bía bṹn vó, ó o khĩína dú ɓa yahó á ɲɔn ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bìo ó o Yeesu vaá sùaráa ho Bɛtefazee lè ho Betanii yi, le ɓúee na ɓa wee ve làa Oliivewa vĩ̀nsĩ̀a ɓúee nìsã́ní, ó o tonkaa mí nì-kenínia nùwã ɲun á bía nɔn yi: ");
INSERT INTO boxNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Mi lɛ́n va ho lóhó na vaá mi yahó yi, ká mi vaá dɔ̃n, á mi ì mi sũ̀npɛ̀-za na á nùpue dĩǹ yí yòora yí mɔn hùúu ká a can dĩ̀n. Mi fee wo ɓua ɓuennáa. ");
INSERT INTO boxNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ká a ɓúi tùara mia le lée webio nɔn mi wee feeráa wo, à mi bío na ɓànso yi: ‹O Ɲúhṹso màkóo wi o yi.›» ");
INSERT INTO boxNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Á bìa ó o tonkaa wà van, á mu ɓúenɓúen vaá wó làa bìo ó o Yeesu bíaráa mu. ");
INSERT INTO boxNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bìo ɓa wee fee o sũ̀npɛ̀-za mu, á bìa te o wee tùa ɓa yi: «Lée webio nɔn á mi wee feeráa o sũ̀npɛ̀-za mu?» ");
INSERT INTO boxNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Á ɓa bía: «O Ɲúhṹso màkóo wi o yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bṹn mɔ́n á ɓa ɓuan o sũ̀npɛ̀-za mu ɓuararáa o Yeesu cɔ̃́n, à bò mí kánɓunwà o wàn, à ɓa ɓuan wo yi ó o Yeesu yòora. ");
INSERT INTO boxNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bìo ó o lá ho wɔ̃hṹ wà, á ɓa nùpua wee bá mí kánɓunwà ho wɔ̃hṹ wàn o yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bìo ó o ɓúakáa wee birón hã Oliivewa vĩ̀nsĩ̀a ɓúee á wà vaá sùará ho Zeruzalɛɛmu yi, á ɓa zã̀amáa na lé o nì-kenínia ɓúenɓúen wee zã̀maka, á ɓa ɓúakáa wee khòoní le Dónbeenì pɔ̃́npɔ̃́n ho yéréké bè-beera na ɓa mɔn bìo yi: ");
INSERT INTO boxNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ɓa wee bío: «Le le Dónbeenì wé mu bè-tentewà là a bɛ́ɛ *Daviide na bò o ɓuen o Ɲúhṹso yèni yi. Ho hɛ́ɛrà kɛń ho wáayi, à ho cùkú lè le yèn-beenì bìo sĩ̀ le Dónbeenì na dà mu bìo ɓúenɓúen ɲúhṹ wán yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Á ɓa *Farizĩɛwa ɓúi na wi ɓa zã̀amáa tĩ́ahṹ bía nɔn o Yeesu yi: «Nì-kàránlo, bío le ũ nì-kenínia wé tɛ́tɛ́.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ó o Yeesu bía: «Ká ɓa wó tɛ́tɛ́, á hã huaa pá à wãamaka.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bìo ó o Yeesu vaá sùaráa ho Zeruzalɛɛmu yi, á yìo mɔn ho, ó o wee wá ho nìpomu bìo yi, ");
INSERT INTO boxNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ká a bío: «Éee Zeruzalɛɛmusa, mi yàá mún lá zũna bìo dà à na ho hɛ́ɛrà mia ho zuia bìo hã́. Ɛ̀ɛ ká mu màhã́ wã́a sànkaa mia. Mi yí dà mu máa mi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lé bìo ho pã̀ahṹ ɓúi khíi dã, á mi zúkúsa á à kɛɛní ì kĩ́ní mia, á à fĩ́fãka yi. ");
INSERT INTO boxNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɓa à fì mi lóhó lè minɛ́n ɓúenɓúen dúkúdúkúdúkú. Ɓa máa día á hàrí huee máa kɛń mí ninza huee wán mi lóhó mu yi, lé bìo mí yí zũna ho pã̀ahṹ na le Dónbeenì ɓuara mi bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bṹn mɔ́n ó o Yeesu zon le *Dónbeenì zĩ-beenì yi á zoó wee ɲa ɓa bè-yɛ̀ɛ́rowà ká a bío na ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","«Le Dónbeenì bía mí bíonì vɔ̃nna yi: ‹Ĩ zĩi á à wé fìoró zĩi,› ká minɛ́n wó le lè ɓa kɔ̃̀nlowà lùe.» ");
INSERT INTO boxNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","O Yeesu lá wee wé kàrán ɓa nùpua le Dónbeenì zĩ-beenì yi làa wizooní ɓúenɓúen. Á le *Dónbeenì yankarowà ɲúnása, lè ho *làndá bìo zéenílowa, lè mu nìpomu ɲúnása wee cà bìo ɓa à wé è ɓúeráa o Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ká bìo ɓa à wé è yíráa wo á ɓa yí zũ, lé bìo ó o bíoní ɲíló sĩ ɓa nùpua ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wizonle ɓúi ká a Yeesu wee kàrán ɓa nùpua le *Dónbeenì zĩ-beenì yi ká a bue le bín-tente, á ɓa *yankarowà ɲúnása, lè ho *làndá bìo zéenílowa, lè ɓa *zúifùwa nì-kĩ́a ");
INSERT INTO boxNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɓueé wee tùa wo yi: «Zéení bìo nɔn á ũ wee wéráa hã wárá mu? Lée wée nɔn mu ɓàn níi foǹ?» ");
INSERT INTO boxNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ó o Yeesu bía nɔn ɓa yi: «Ĩnɛ́n mún ǹ tùa mia, mi bío na miì: ");
INSERT INTO boxNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Lée wée hĩ́a nɔn le níi le o Zãn wé bátízé ɓa nùpua? Lé le Dónbeenì lée, tàá lé ɓa nùpua?» ");
INSERT INTO boxNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Á ɓa dĩ̀n wee bío mín yi: «Hen ká wa le lé le Dónbeenì, o ò bío le lée webio nɔn á wa yí tàráa o bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ká wa mún le lé ɓa nùpua tonkaa wo, á ɓa zã̀amáa á à lèeka wɛn lè hã huaa á à ɓúe. Lé bìo á ɓa láa mu yi kɛ̃́nkɛ̃́n le o Zãn lé le *Dónbeenì ɲi-cúa fɛɛro.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Á ɓa wã́a bía le mí yí zũ yìa nɔn le níi mu o Zãn yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ó o Yeesu ɓɛ̀n bía nɔn ɓa yi: «Àwa, ĩnɛ́n mún máa zéení yìa nɔn le níi miì á ĩ wee wéráa bìo kà.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bṹn mɔ́n ó o Yeesu wà le wàhiire na kà nɔn ɓa zã̀amáa yi: «Nìi ɓúi hĩ́a léra mí èrézɛ̃́n vĩ̀nsĩ̀a ɓuahó á nɔn ɓa nùpua na làa wó wã̀anía tò bìo ɓa khíi na a yi wán, le ɓa wé và ho, ò o wà van le khúii na nàyi á wà vaá mía bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pã̀ahṹ na ho èrézɛ̃́n wee be yi, ó o tonkaa mí ton-sá nì-kéní le o va ɓa nùpua mu cɔ̃́n le ɓa khé bìo bìo sã̀ mí yi à na. Á ɓa nùpua mu vaá han wo, á día ó o wà lè mí nín-kã́amáa. ");
INSERT INTO boxNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ó o mɔhṹ ɓànso bĩnía tonkaa mí ton-sá veere, á ɓa mún vaá là wón á han ɲɔn, ó o wà à ɓa yí nɔn dɛ̀ɛ wo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ó o pá bĩnía tonkaa ɓa nùwã tĩn níi, á wón ɓa mún vaá han ɓóoníkaa yi, á ɲɔn. ");
INSERT INTO boxNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Ó o mɔhṹ ɓànso wã́a bía: ‹Éee ĩ wã́a à wé kaka coon? Àwa, ĩ ì tonka ĩ za na á ĩ wa làa sòobɛ́ɛ, ɲún-sĩ á wón ɓa à kɔ̃̀nbi.› Ò o bía nɔn mí za mu yi le o hĩ́ní lɛ́n, á wón hĩ́nɔn wà. ");
INSERT INTO boxNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ɛ̀ɛ ká bìo ɓa nùpua mu yère dá a wán, á ɓa wee bío mín yi: ‹Yìa lua kà lé yìa á ho mɔhṹ bìo khíi sĩ̀ yi. Mi wa ɓúe o, á ho mɔhṹ bìo wã́a à sĩ̀ wɛn.› ");
INSERT INTO boxNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","À ɓa hĩ́nɔn wìira a á khɛ̀ra lée ɓó día.» Ó o Yeesu wã́a tùara ɓa yi: «Àwa! Lé mu yɛ́n á ho mɔhṹ ɓànso ò wé làa ba? ");
INSERT INTO boxNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O ò ɓuen ɓueé ɓúe ɓa nùpua mu, ká a cà nì-vio á à kúee mí mɔhṹ mu yi.» Bìo ɓa nùpua ɲá hã bíoní mu, á ɓa bía: «Póon! Bṹn máa wé.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ká a Yeesu màhã́ fá mí yìo ɓa yi ò o bía: «Le Dónbeenì bíonì vũahṹ bíoní na kà kúará lé mu yɛ́n? ‹Le huee na ɓa so-sowa lá pã́ día, lé dìo hĩ́a bĩnía ɓueé ɓuan ho soró dĩ̀nía.› ");
INSERT INTO boxNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yìa lùwá le huee mu wán á ɓànso sãnía á à yáa. Ká yìa á le ɓɛ̀n kùera lion wán, á ɓànso á à fùfúuka.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Á ɓa *yankarowà ɲúnása lè ho *làndá bìo zéenílowa zũna le lé ɓarɛ́n á le wàhiire mu wà bò wán, á ɓa dɛ̀ɛnía wee cà a wìiró yahó, ká ɓa màhã́ zã́na ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bṹn mɔ́n á ɓa wee hùen o Yeesu. Ɓa tonkaa ɓa nìnbáwa ɓúi na wee wé míten lòn nùpua na térénna. Ɓa le bán khũaa o ɲii yi à yí o bín-kohó ɓúi bè yi déráa wo yìa wi ho kɔ̃hṹ ɲúhṹ wán níi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Á ɓa tùara a yi: «Nì-kàránlo, wa zũ le bìo fo wee bío làa bìo fo wee kàrán lè ɓa nùpua á térénna. Fo yí máa kà nùpue yìo. Bìo le Dónbeenì le ɓa nùpua wé ɓua lè míten lé bṹn ɓàn kàránló binbirì á fo wee na. ");
INSERT INTO boxNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Àwa! Á ũ bío na wɛn: Wa làndá yi á ho lànpó ko ho wé cã na ho Oroomu kɔ̃hṹ bɛ́ɛ yi lée, tàá mu yí ko làa wéró?» ");
INSERT INTO boxNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ó o Yeesu zũna ɓa hénní bìo, ó o bía nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Mi zéení le wɛ́n-hɔ̃nló ɓúi làa mi. Ho yahó lè le yèni na wi le wɛ́n-hɔ̃nló mu wán á wée te?» Á ɓa bía: «Lé o bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ó o Yeesu bía nɔn ɓa yi: «Àwa. Bìo sã̀ a bɛ́ɛ yi à mi na a yi, ká bìo ɓɛ̀n bìo sã̀ le Dónbeenì yi à mi na mu dén yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","O bíoní na ó o bía á ɓa yí mɔn bín-kohó ɓúi na ɓa dà a bè yi á à wìiráa wo ɓa nùpua yahó. Bìo ó o bía wó ɓa coon, á ɓa dĩ̀n tɛ́tɛ́tɛ́. ");
INSERT INTO boxNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɓa *Sadusĩɛwa lé bìa le ɓa nì-hía máa vèe. Lé bán nùwã yɛn ɓúi ɓuara a Yeesu cɔ̃́n ɓueé tùara a yi: ");
INSERT INTO boxNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Nì-kàránlo, bìo ó o *Mɔyiize túara henía nɔn wɛn lé bìo kà: Hen ká a ɓúi yan mín hã́a á húrun ò o yí yú za làa wo, á ɓàn za ko ò o fé ɓàn hã́a ya, à te ɓa zàwa yi mín za mu yèni yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ka lòn nùpua nùwã hèɲun ɓúi lá lée zàwa síi, ó o yahón so yan mín hã́a á húrun ò o yí yú za làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ó o ɲun níi so fó a mahã́a mu yan, ");
INSERT INTO boxNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bṹn mɔ́n ó o tĩn níi so fó yan, á ɓa mí nùwã hèɲun yan wo bèenia á húrunka, ò o ɓúi yí yú za làa wo. ");
INSERT INTO boxNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mu ɓàn véeníi ó o hã́a mu mún húrun. ");
INSERT INTO boxNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Àyà, nɔ̀nzoǹ na ɓa nì-hía á à vèe yi, ó o hã́a mu bìo ò sĩ̀ a yɛ́n yi? Bìo ɓa mí nùwã hèɲun màhã́ yan wo bèenia.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ó o Yeesu bía nɔn ɓa yi: «Ho dĩ́míɲá na lònbìo báawa lè ɓa hã́awa wee ya mín. ");
INSERT INTO boxNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ɛ̀ɛ ká ɓa báawa lè ɓa hã́awa na ko ɓa khíi vèe à yí le mukãnì ho dĩ́míɲá na bò o ɓuen yi bán máa ya mín. ");
INSERT INTO boxNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓa yí dà máa bĩní máa hí, lé bìo ɓa ɓonmín lè le Dónbeenì wáayi tonkarowà. Ɓa lé le Dónbeenì zàwa lé bìo ɓa vèera. ");
INSERT INTO boxNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ho lahó na bía le vĩ̀ndɛ̀-za na ho dɔ̃hṹ wi yi bìo, ó o Mɔyiize zéenía mu wéréwéré le ɓa nì-hía khíi vèe, ò o von o Ɲúhṹso le *Abarahaamu ɓàn Dónbeenì là a *Izaaki ɓàn Dónbeenì là a *Zakoobu ɓàn Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Le Dónbeenì lé bìa yìo wi lua ɓàn Dónbeenì, ká le yínɔń nì-hía ɓàn Dónbeenì. Lé bìo ɓa ɓúenɓúen yìo wi lua lerɛ́n bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Á ho *làndá bìo zéenílowa nùwã yɛn ɓúi bía nɔn wo yi: «Nì-kàránlo, fo bía se.» ");
INSERT INTO boxNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lé bìo ɓa yí wi à ɓa bĩní khà míten tùa wo yi làa bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","O Yeesu bĩnía tùara ɓa yi: «Ɓa da à wé kaka à bíoráa le o *Krista lé o *Daviide mɔ̀nmàníi? ");
INSERT INTO boxNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Lé bìo ó o Daviide mí bɛɛre bía mu hã Leni vũahṹ yi: ‹O Ɲúhṹso Dónbeenì bía nɔn ĩ Ɲúhṹso yi: Ɓuee kɛɛní ĩ nín-tĩánì, ");
INSERT INTO boxNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fúaa ká ĩ ɓúrá ũ zúkúsa ũ tá, á ũ bò ũ zení wán› ");
INSERT INTO boxNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Bìo ó o Daviide wee ve o Krista lè mí Ɲúhṹso, o ò wé o ɲúhṹso ká a mún pá à wé o mɔ̀nmàníi kaka?» ");
INSERT INTO boxNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bìo ɓa zã̀amáa dĩ̀n wee ɲí a bíoní, ó o bía nɔn mí nì-kenínia yi: ");
INSERT INTO boxNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Mi pa miten ho *làndá bìo zéenílowa bìo yi. Ɓa wa hã báká-beera zĩ́ló à wé hɛ́ɛkaráa. Ɓa wa ɓa wé tɛ̀ɛní ɓa yi lè le kɔ̃̀nbii ɓa zã̀amáa fèmínló lara yi. Ho kàránló zĩní yahón lùa, lè ho dĩ́nló díiníi kɛɛnínía na seka ɓa wé hueeka kɛɛní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓa wee khà ɓa mahã́awa ɲuaa bìo, á mún wa ho fìoró na túee wéró à ɓa nùpua leéka le ɓa térénna. Lé bṹn ɓúenɓúen nɔn á ɓa lònbee khíi wíoka à déráa wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","O Yeesu hóonía mí yahó á lora khíi fò, ó o mɔn ho nàfòró ɓànsowà na wee kúee mí hãmu hã ɓonkoní yi le *Dónbeenì zĩ-beenì yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ó o mún mɔn o mahã́-khenii ɓúi ò o wee kúee mí tɔ̃mɔ́nwà bìo ɲun, ");
INSERT INTO boxNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ó o bía: «Le ĩ mì ho tũ̀iá na mia: O mahã́-khenii na kà bìo na ó o kúaa á boo po bìa ká ɓúenɓúen bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lé bìo le wárí na ɓa ɓúenɓúen wó lè mí hãmu lé dìo ɓa yú puunía. Ò orɛ́n lè mí khemu, ò o pá kúaa bìo wi o cɔ̃́n ɓúenɓúen na ó o lá wé è dí.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bìo ɓa nùpua nùwã yɛn ɓúi wee bío le Dónbeenì zĩ-beenì bìo, le le donkhueéra lè hã *hue-sení lè mu bìowa na ɓa wó lè mu hãmu, ó o Yeesu bía nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Pã̀ahṹ ɓúi khíi dã ká bìo mí yìo wi wán kà á à fì. Hàrí huee máa kɛń mí ninza huee wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Á ɓa tùara a yi: «Nì-kàránlo, lé ho pã̀ahṹ yɛ́n á bṹn bìo so ò wé yi, á lé mu bìo yɛ́n khíi zéení le mu bìo mu wéró pã̀ahṹ dɔ̃n?» ");
INSERT INTO boxNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ó o Yeesu bía: «Mi pa miten bìo. Mi yí día le ɓa vĩ́iní mia. Lé bìo á nùpua cɛ̀rɛ̀ɛ khíi ɓuen ĩ yèni yi á à bío: ‹Ĩ lé o *Krista, ho pã̀ahṹ dɔ̃n.› Ká mi màhã́ yí bè ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hen ká mi khíi wee ɲí hã hĩa táró, lé ho kã́aló bìo, à mi yí dèé mi yiwa. Lé bìo á bṹn bìowa so ko mu wé ho yahó. Ká bṹn dɛ̀ɛnía máa wé ho dĩ́míɲá véró pã̀ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ò o bĩnía bía bò mu wán: «Ho sìí ɓúi khíi wé è lé vaá fi lè ho sìí veere, á ho kɔ̃hṹ ɓúi khíi wé è lé vaá fi lè ho kã-veere. ");
INSERT INTO boxNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ho tá dèkénɔ̀n sũmáa khíi wé hã lùa ɓúi yi, á le hĩni lè mu vɔ̃́n-kora khíi kɛń lùa cɛ̀rɛ̀ɛ yi. Mu bè-beera ɓúi na bìo á à wé le zã́níi á à wé ho wáayi lè ho tá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ɛ̀ɛ ká sã́ni à bṹn ɓúenɓúen dã, á ɓa à wìika mia á à beé lò. Ɓa à ɓua mia á à varáa ɓa *zúifùwa kàránló zĩní yi á vaá cítí, á à kúee mia ho kàsó yi. Ɓa wé è ɓua mia á vaá dĩ̀ní hã kãna ɲúnása lè ɓa bá-zàwa yahó bìo mi tà miì bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lé bṹn mi ì bè yi á à zéenínáa ĩ bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mi bè mi hácírí bìo kà lè bìo wán: Mi yí dèé mi yiwa bìo mi vaá bío á à fenínáa miten bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ĩnɛ́n ĩ bɛɛre lé yìa á à na hã bíoní lè mu bè-zũńminì mia, á mi zúkúsa ó o ɓúi máa dàń máa sánsá mia á mún máa kán. ");
INSERT INTO boxNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hàrí mìn maáwà lè mìn nuwà, mìn zàwa lè mìn nùwã na ká, lè mìn bɔ̃́nlowà míten lé bán á à dé mia á à na, á mi cɛ̀rɛ̀ɛ ɓúi ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓa nùpua ɓúenɓúen á à ɲin mia bìo mi tà miì bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ɛ̀ɛ ká hàrí mi ɲún-vãní dà-kéní ɓúi máa vĩ́. ");
INSERT INTO boxNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mi fárá dĩ̀n sese, bṹn lé bìo á à na ká mi ì yí le mukãnì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Pã̀ahṹ na mi khíi mi ɓa hĩn-táwá lè mí kuio ká ɓa kĩ́nía ho Zeruzalɛɛmu yi, bṹn ká mi ì zũń le cĩ́inú ká ho fíoró yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hón pã̀ahṹ so yi á bìa á à kɛń ho *Zudee yi ko ɓa lùwí yòo hã ɓúaa. Bìa á à kɛń ho Zeruzalɛɛmu yi ko ɓa lé ho yi lɛ́n, à bìa wi hã mana yi yí bĩní ɓuee zo ho yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lé bìo mu ù wé le cítíi fĩ̀ló wizooní na le Dónbeenì bíonì vũahṹ bè-bíonii ɓúenɓúen á ɲii ì sí yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ho yéréké khíi sá ɓa hã́-sɛ̃ɛnasa lè ɓa hã́-ɲàawa yi mu zoǹ. Lé bìo mu ù wé le yi-vɛ́ɛ làa sòobɛ́ɛ ho kɔ̃hṹ mu yi, á le Dónbeenì á à zéení le le sĩi wee cĩ̀ ɓa nùpua mu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓa à ɓúe ɓa ɓúi lè hã hĩa khàra, ká ɓa ɓúi ɓa à ɓua à varáa hã kã-vio yi, á bìa yínɔń ɓa zúifùwa ɓueé fì ho Zeruzalɛɛmu á à kɛɛní ho yi fúaa ɓa pã̀ahṹ ɲii sú. ");
INSERT INTO boxNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Mu bìowa ɓúi na sìí yí zũ khíi wé le wii le ho pĩihṹ lè hã mànàayio yi. Ho dĩ́míɲá kãnasa ɓúenɓúen á yilera à yáa mu yámú ɲumu na wee kùrún sã ɲíló bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓa nùpua ɓúi yiwa á à dè dè è yuunika ká ɓa leékaa bìo khíi wé ho tá wán mu pã̀ahṹ, lé bìo á ho wáayi bìo ɓúenɓúen á à dèké. ");
INSERT INTO boxNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bṹn ká ɓa à mi a *Nùpue Za hã dùndúio wán ká a yòó lua lè mí dàńló lè mí cùkú beenì. ");
INSERT INTO boxNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ká bṹn bìowa so wéró ɲii khíi hɛ̀ra, à mi hĩ́ní dĩ̀n à hóoní mi ɲúná lé bìo á mi kã̀níló wã́a sùaráa.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bṹn mɔ́n ó o Yeesu wà le wàhiire na kà nɔn ɓa yi: «Mi loń ho *fíkíyée vĩ̀ndɛ̀ɛ lè hã vĩ̀nsĩ̀a na ká. ");
INSERT INTO boxNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ká hã hĩ́a wee sà mí vɔ̃n-yórówà, se mi zũ le ho viohó tèró dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Làa bṹn síi ká mi khíi mɔn ká bṹn bìowa so wee wé, à mi zũń le le *Dónbeenì bɛ́ɛnì sùaráa. ");
INSERT INTO boxNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Le ĩ mì ho tũ̀iá poni na mia: Ho pã̀ahṹ na kà nùpua máa hí máa vé ká bṹn bìowa so ɓúenɓúen yí wó. ");
INSERT INTO boxNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ho wáayi lè ho tá khíi vé, ká ĩ bíoní hɔ̃́n ǹ kɛń bĩ́n fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Hen ká mi wee pa miten bìo sese, á mi máa na miten ho dàndĩ́nló lè ho ɲa-ɲunló, lè ho dĩ́míɲá bìo yilera yi. Ká bṹn mia le wizonle mu khíi vĩ mia lè ho zùán bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lé bìo le khíi yòoka ho dĩ́míɲá nùpua ɓúenɓúen wán. ");
INSERT INTO boxNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mi fání mi yìo. Mi wé fìo fɛ́ɛɛ, á mi ì yí ho pànká à fenínáa miten bìo wà ɓueé wé ɓúenɓúen yi, á à dàń ǹ dĩ̀nnáa o *Nùpue Za yahó.» ");
INSERT INTO boxNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Le wisoni yi ó o Yeesu fù wee wé kàrán ɓa nùpua le *Dónbeenì zĩ-beenì yi. Ká ho zĩihṹ ò o lɛ́n yòo cãa hã Oliivewa vĩ̀nsĩ̀a ɓúee wán. ");
INSERT INTO boxNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ɓa nùpua ɓúenɓúen fù wee wé ɓuen le Dónbeenì zĩ-beenì yi le yìnbíi bùirìi, à ɓuee ɲí a cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ho *búurú na á ɲa-fĩni yí dó yi sã́nú na ɓa le Paaki wà ɓueé sùará. ");
INSERT INTO boxNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Á ɓa *yankarowà ɲúnása lè ho *làndá bìo zéenílowa wee cà bìo ɓa à wé wé è ɓúeráa o Yeesu, lé bìo ɓa zã́na ɓa zã̀amáa. ");
INSERT INTO boxNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","À bṹn ó o *Satãni dó hã yile-kora ò Zudaa na ɓa wee ve làa Isikariote yi. O lé ɓa nì-kenínia pírú ɲun nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ó o Zudaa mu wà vaá wã̀anía lè ɓa yankarowà ɲúnása lè le *Dónbeenì zĩ-beenì parowà ɲúnása, à zũńnáa bìo o ò wé wé è déráa o Yeesu ɓa níi yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Á bán sĩa wan wan le mí ì na le wárí wo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ó o Zudaa wã́a tà, á hĩ́nɔn wee cà bìo o ò dĩ̀n wán á à déráa wo ɓa níi yi kà ɓa zã̀amáa yí zũń mu. ");
INSERT INTO boxNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pã̀ahṹ na ɓa wee dí ho búurú na á ɲa-fĩni yí dó yi sã́nú yi, á le wizonle na ɓa ko ɓa fũ̀aa ho Paaki piozàwa yi à wé lè mu hãmu dɔ̃n, ");
INSERT INTO boxNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ó o Yeesu tonkaa o Piɛre là a Zãn á bía nɔn yi: «Mi lɛ́n vaa wíoka ho Paaki dĩ́nló bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Á ɓa tùara a yi: «Lé wen á fo wi à wa wíoka mu yi?» ");
INSERT INTO boxNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ó o bía nɔn ɓa yi: «Mi loń! Hen ká mi hĩ́a wà lií zo ho lóhó yi, á mi ì fè mín làa nìi ɓúi na sò mu ɲumu lè ho dṹuhṹ, à mi bè o yi va le zĩi na ó o vaá zo yi, ");
INSERT INTO boxNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","à vaa bío na le zĩi mu ɓànso yi: ‹O nì-kàránlo le wa tùa foǹ: Ho lahó na á ĩnɛ́n lè ĩ nì-kenínia á à dí ho Paaki dĩ́nló yi lé ho yɛ́n?› ");
INSERT INTO boxNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","O ò zéení la-beenì ɓúi làa mia ho nɔ́nwíohṹ yi na sĩ̀a bàráka vó. Lé bĩ́n à mi wíoka ho dĩ́nló bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Á ɓa wà vaá yú mu ɓúenɓúen làa bìo ó o Yeesu bíaráa mu á ɓa wíokaa ho Paaki dĩ́nló bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bìo ho pã̀ahṹ dɔ̃n, ó orɛ́n lè mí tonkarowà páanía kará ho dĩ́nló ɲúhṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ó o bía nɔn ɓa yi: «Ĩ ɓɛ̀ntĩ́n wee cà à ĩ dí ho Paaki sã́nú dĩ́nló na kà làa mia à bè yi lò beráa. ");
INSERT INTO boxNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lé bìo á ĩ máa bĩní máa dí ho làa mia hùúu, fúaa nɔ̀nzoǹ na á mu ù wé á ɲii á à sí yi le *Dónbeenì bɛ́ɛnì yi, le ĩ bío mu na mia.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ò o wã́a lá le ɲuuníi dɛ̀ɛ á ɓuan, ò o dó le Dónbeenì bárákà, ò o bía: «Mi fé le ɲuuníi dɛ̀ɛ na kà à ɲu fé mín yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Le ĩ bío mu na mia: À lá ho zuia ɲii wán, á ĩ máa bĩní máa ɲu dìvɛ̃́n hùúu, ká mu yínɔń le Dónbeenì bɛ́ɛnì ɓuenló mɔ́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bṹn mɔ́n ó o lá ho búurú, á dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho nɔn ɓa yi, ò o bía: «Hìa kà lé ĩ sãnía na nɔn mi bìo yi. Mi wé wé mu à leékaráa ĩ bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lé bṹn ɓàn síi ó o mún láráa le ɲuuníi dɛ̀ɛ ho dĩ́nló díró mɔ́n, ò o bía: «Le ɲuuníi dɛ̀ɛ na kà lé le páaníi fĩnle na bò lè ĩ cãni na á à kúia mi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Ɛ̀ɛ ká mi màhã́ loń, yìa á à dé mi ì na làa mi á páanía kará ho dĩ́nló ɲúhṹ yi hen. ");
INSERT INTO boxNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mu bon, o *Nùpue Za á à hí làa bìo le Dónbeenì le mu wéráa. Ká yìa màhã́ níi ì bè mu á ho yéréké è zo ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Á ɓa ɓúakáa wee tùaka mín yi le lé o yɛ́n màhã́ à wé mu mí tĩ́ahṹ coon?» ");
INSERT INTO boxNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","O Yeesu nì-kenínia wee wã̀aní mín yi à zũńnáa yìa po ɓarɛ́n na ká. ");
INSERT INTO boxNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ó o Yeesu bía nɔn ɓa yi: «Ho dĩ́míɲá kãna bá-zàwa wee wé mí pànká hã wán, á bìa ho pànká wi níní yi le ɓa wé ve mí làa ‹bè-tente wérowà›. ");
INSERT INTO boxNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ɛ̀ɛ ká minɛ́n bìo yí ko à mu kɛń kà. Minɛ́n á yìa ɲúhṹ wi po bìa ká wón ko ò o wé míten cĩ́inú bìa ká yahó. À yìa á ho pànká wi níi yi wé bìa ká ton-sá. ");
INSERT INTO boxNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yìa ɲúhṹ wi lée wée? Lé yìa ɓa wee lá ho dĩ́nló na yi ò o dí lée, tàá lé yìa wee lá ho na? Yínɔń yìa ɓa wee lá ho na yi le? Àwa! Ĩnɛ́n wi mi tĩ́ahṹ lòn ton-sá bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Bìo á mi wee tà kɛń làa mi fɛ́ɛɛ le lònbee na wee yí mi yi, ");
INSERT INTO boxNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","le bṹn nɔn á le bɛ́ɛnì na á ĩ Maá nɔn miì á ĩ mún nɔn mia. ");
INSERT INTO boxNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mi khíi dí á à ɲu làa mi ĩ bɛ́ɛnì yi, á mi mún khíi kɛɛní ɓa bá-zàwa kanmúiní wán á à cítíráa o *Isirayɛɛle zĩ-ɲúná pírú ɲun.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","O Yeesu bía nɔn o Simɔn Piɛre yi: «Simɔn, Simɔn, héyìi! Loń! O *Satãni fìora ho wɔ̃hṹ le Dónbeenì cɔ̃́n yú à didiráa mia làa bìo ɓa wé didiráa mu dũmu à lén zàn-bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɛ̀ɛ ká ĩ màhã́ fìora nɔn foǹ, à le sĩidéró yí fòo foǹ. Ká ũ khíi tà yèrèmáa ɓuara ĩ cɔ̃́n, à ũ hení mìn zàwa sĩa.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ó o Piɛre bía nɔn wo yi: «Ɲúhṹso, hàrí à mu wé kàsó, á ĩ ì zo ho làa fo. À mu wé húmú, á ĩ ì hí làa fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ó o Yeesu bía: «Piɛre, le ĩ bío mu na foǹ: Ho zuia ó o kò-bɛ́ɛ máa wá, ká ũ pã́ le fo yí zũ mi a dɔ̃n hã cúa-tĩn.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bṹn mɔ́n ó o Yeesu bía nɔn ɓa yi: «Bìo á ĩ hĩ́a tonkaa mia, à ĩ le mi yí ɓua wárí à yí ɓua puure làa nakãa, á bìo ɓúi cén fòora mia le?» Á ɓa bía: «Dɛ̀ɛ ɓúi yí fòora wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ó o wã́a bía nɔn ɓa yi: «Àwa! Bìo kà wán ká yìa wárí wi ò o lá le ɓua, à yìa puure wi mún lá le ɓua. Yìa khà-tóní mía à wón yɛ̀ɛ́ mí báká beenì, ò o yà ho ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Le ĩ bío mu na mia: Le Dónbeenì bíonì vũahṹ bíonì na kà bìo ko à mu sá miì à ɲii sí: ‹Ɓa mà a dó ɓa bè-kora wérowà ɲii.› Mu bon. Bìo túara ĩ dã́ní yi á à wé ɲii ì sí.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ó o nì-kenínia bía nɔn wo yi: «Ɲúhṹso, lé hã khà-túa bìo ɲun na.» Ó o Yeesu bía: «Mi wã́a día kà.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","O Yeesu ló ho lóhó yi á wà van hã Oliivewa ɓúee wán làa bìo ó o wee wé wéráa mu. Ó o nì-kenínia bò a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bìo ó o vaá dɔ̃n ho lahó mu ó o bía nɔn ɓa yi: «Mi wé fìo bèra a na à mi yí zo mu bè-kora wéró yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bṹn mɔ́n ó o khɛ̀ra làa ba á à yí lòn hen na ó o nùpue hue-lèenii dà vaá dã yi síi, á lií fárá mí nɔnkóɲúná wàn ò o wee fìo kà síi: ");
INSERT INTO boxNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Ĩ Maá, ká fo tà, à ũ yí le le lònbee na kà dã mi. Ɛ̀ɛ ká mu yí wé ĩnɛ́n sĩi bìo ká ũnɛ́n sĩi bìo lé bìo wé.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bṹn mɔ́n á le Dónbeenì tonkaro ɓúi ɓueé zéenía míten làa wo, á hĩ̀ína a sĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","O Yeesu wíokaa wee fìo lè mí sòobɛ́ɛ, lé bìo á bìo wà ɓueé wé làa bìo á à sá a yi ɓúenɓúen ó o mɔn, á mu wee beé o lò dàkhĩína, ó o fɛ̀ɛnì yèrèmáa ka lòn cãni, á wee luioka lii kúia ho tá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bìo ó o fìora vó, ó o bĩnía ɓuara mí nì-kenínia cɔ̃́n á ɓueé yú ɓa à mu dãmu ɓó ɓa, lé bìo ɓa yiwa wee váráa. ");
INSERT INTO boxNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ó o bía nɔn ɓa yi: «Mi yí da. Mi hĩ́ní fìo à mi yí zo mu bè-kora wéró yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bìo ó o Yeesu dĩ̀n wee bío, à bṹn ɓa zã̀amáa ɓúi vaá ló lua. Yìa dú ɓa yahó lé o Zudaa, wón na lé o nì-kenínia pírú ɲun nì-kéní mi bɛɛre. O ɓuee dɛ̃ɛníi, ó o wà ɓueé ɓó a Yeesu yi, á le mí ì tɛ̀ɛní a yi lè le kɔ̃̀nbii. ");
INSERT INTO boxNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Á wón bía nɔn wo yi: «Éee, Zudaa, lé le kɔ̃̀nbii tɛ̀ɛníi á fo ò bè yi á à déráa o *Nùpue Za á à na le?» ");
INSERT INTO boxNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ká bìa làa wo bò mín zũna bìo hĩ́a à wé, á ɓa tùara a yi: «Ɲúhṹso, wà dà à fi lè wa khà-túa le?» ");
INSERT INTO boxNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Á ɓa nì-kéní ɓúi dɛ̀ɛnía hà ɓa *yankarowà ɲúhṹso ton-sá nín-tĩánì ɲikãahṹ kúio. ");
INSERT INTO boxNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ká a Yeesu màhã́ bía: «Héyìi! Mi día kà.» Ò o dɔ̃n o nìi ɲikãahṹ ó o dɛ̀ɛnía wan. ");
INSERT INTO boxNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bṹn mɔ́n ó o Yeesu yèrèmáa bía nɔn ɓa yankarowà ɲúnása, lè le *Dónbeenì zĩ-beenì parowà ɲúnása lè ɓa nì-kĩ́a na wà ɓueé wìi wo yi: «Mi ɓuan mi khà-túa lè mi bũ̀aa ɓuararáa ĩ wán le we? Ĩ lée nì-kã́anii le? ");
INSERT INTO boxNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hã wizooní ɓúenɓúen á ĩ lá wee wé kɛń làa mia le Dónbeenì zĩ-beenì yi á mi yí wìira mi hón pã̀ahṹ so yi. Ɛ̀ɛ ká ho pã̀ahṹ na kà hón bìo sã̀ minɛ́n lè le tíbírí pànká ɲúhṹso yi.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bṹn mɔ́n á ɓa wã́a wìira a Yeesu á ɓuan vaá zonnáa ɓa yankarowà ɲúhṹso zĩi. O Piɛre bò ɓa yi ká a màhã́ khɛ̀ra wi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɓa zoó lò ho dɔ̃hṹ ho lún sĩi yi á ɓa ɓúi kará kĩ́nía yi. Ó o Piɛre ɓueé zoó kará làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ó o ton-sá hã́a ɓúi mɔn wo ho dɔ̃hṹ khoomu yi ò o kará, ó o fá mí yìo wo yi, ò o bía: «O nìi na kà mún fù wi làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ó o Piɛre pã́ mu, ò o bía: «Héyìi! Hã́a mu, ĩ yàá yí zũ a.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mu ù dé mí yi ò o ɓúi tĩ́n mɔn wo, á wón bía nɔn wo yi: «Ũnɛ́n mún lé o nìi mu ɓàn nì-kéní ɓúi.» Ká a Piɛre màhã́ bía: «Nìi mu, ĩ yí nɔn wo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bìo mu dá dò mí yi lòn lɛ́ɛ̀rè dà-kéní síi ó o nì-veere ɓúi tĩ́n pá bĩnía bía mu: «Mu bon kɛ̃́nkɛ̃́n. O nìi mu fù wi làa wo, lé bìo ó o mún lé o Kalilee nìi.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ká a Piɛre màhã́ bía: «Bìo á ũnɛ́n yàá wee bío á ĩ yí zũ.» Ho pã̀ahṹ dà-kéní kéní na ó o wee bío mu yi ó o kò-bɛ́ɛ wá. ");
INSERT INTO boxNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ó o Ɲúhṹso yèrèmáa fá mí yìo o Piɛre yi. Lé bṹn ó o Piɛre hácírí màhã́ ɓuara bìo ó o Ɲúhṹso bía nɔn wo yi wán: «Ho zuia ó o kò-bɛ́ɛ máa wá ká ũ pã́ le fo yí zũ mi á dɔ̃n hã cúa-tĩn.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ó o Piɛre hĩ́nɔn ló á lée wá bùbùbù. ");
INSERT INTO boxNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɓa nùpua na pan o Yeesu yi wee yáa mí ɲiní yi na a yi ká ɓa a ha a. ");
INSERT INTO boxNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓa wee pe o yahó yi ká ɓa tùa wo yi: «Ká fo lé le *Dónbeenì ɲi-cúa fɛɛro bìo bon, à ũ zéení yìa vĩ́na fo.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hã bín-kora lè mí sìíwà á ɓa wee bío na a yi. ");
INSERT INTO boxNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bìo ho tá tɔ̃n, á ɓa *zúifùwa nì-kĩ́a, lè ɓa *yankarowà ɲúnása *lè ho làndá bìo zéenílowa kúaa mín wán, à ɓa le ɓa ɓua a Yeesu ɓuennáa minɛ́n na lé ho làndá tũ̀iá fɛɛrowà yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Á ɓa tùara a yi: «Fo lé o *Krista à ũ bío mu le wa ɲí.» Ó o bía nɔn ɓa yi: «Ĩ bía mu nɔn mia á mi máa tà mu, ");
INSERT INTO boxNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ká ĩ mún tùara mia á mi máa bío dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ká hã laà na kà wán, ó o *Nùpue Za á à kɛɛní le Dónbeenì na dà mu bìo ɓúenɓúen nín-tĩánì.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Á ɓa ɓúenɓúen wã́a bía: «À bṹn à fo lé le Dónbeenì Za lon?» Ó o bía nɔn ɓa yi: «Lé minɛ́n miten bía le ĩ lé orɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Á ɓa wã́a bía: «Wa màkóo wã́a mía sɛɛ́ràsa yi. Warɛ́n waten wã́a ɲá a ɲi-cúa.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ho làndá tũ̀iá fɛɛrowà ɓúenɓúen hĩ́nɔn ɓuan o Yeesu vannáa o *Pilaate cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bìo ɓa vaá dɔ̃n bĩ́n, á ɓa wee bá a ká ɓa a bío: «O nìi na kà á wa yú ò o wee khà wa nìpomu vĩ́iní le ɓa yí cã ho lànpó à na a bɛ́ɛ yi. Ò o mún wee bío le mí lé o *Krista, o bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ó o Pilaate tùara a yi: «Lé ũnɛ́n lé ɓa *zúifùwa bɛ́ɛ le?» Ó o Yeesu bía nɔn wo yi: «Fo bía mu.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ó o Pilaate bía nɔn ɓa yankarowà ɲúnása lè ɓa zã̀amáa yi: «Bíonì na à ĩ ì dĩ̀n wán á à síinínáa o nìi na kà ɲúhṹ á ĩ yí mɔn.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ká ɓa màhã́ pá wíokaa wee bío lè mí pànká: «O wee kã́aní wa nìpomu lè mí kàránló. O ɓúa mu ɲúhṹ ho Kalilee yi á tò ho *Zudee yi fɛ́ɛɛ wà ɓueé ɓó hen.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bìo ó o Pilaate ɲá hã bíoní mu, ó o tùara: «O nìi mu lée Kalilee nìi le?» Á ɓa le ũuu. ");
INSERT INTO boxNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Á bìo ó o zũna mu kà, ó o le ɓa ɓua a varáa o *Heroode cɔ̃́n, lé bìo ó o Heroode lé yìa wi ho Kalilee ɲúhṹ wán, à wón mún wi ho Zeruzalɛɛmu yi mu pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bìo ó o Heroode mɔn o Yeesu, ó o sĩi wan, lé bìo ó o ɲá a sã míana, á lá wi ó o mi a wán hàrí hàánì. O lá wi ò o mi a ká a wee wé yéréké bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O tùara a yi làa bìo cɛ̀rɛ̀ɛ ká a Yeesu màhã́ yí dó mí ɲii wo yi hùúu. ");
INSERT INTO boxNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɓa *yankarowà ɲúnása lè ho *làndá bìo zéenílowa dĩ̀n wee kooní a Yeesu yi lè le hɛɛrè. ");
INSERT INTO boxNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","O Heroode lè mí dásíwá wee yáa mí ɲiní yi na a Yeesu yi ká ɓa a zùańka a yi. Ɓa zĩ́inía wo lè ho báká beenì na se làa sòobɛ́ɛ, à ɓa bĩnía ɓuan wo vannáa o Pilaate cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lé bṹn zoǹ ó o Heroode là a Pilaate bĩnía wó ɓa bɔ̃́nlowà ká ɓa ɲɔǹ lá wee fi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bṹn mɔ́n ó o Pilaate von ɓa yankarowà ɲúnása, lè ɓa ya-díwá lè ɓa zã̀amáa á kúaa mín wán, ");
INSERT INTO boxNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ò o bía nɔn ɓa yi: «O nìi na kà á mi ɓuan ɓuararáa ĩ cɔ̃́n, á le o wee kã́aní mu nìpomu. Àwa! Ĩ mún wã́a tùara a yi mi ɓúenɓúen yìo yi, á hã wén-kora na mi le o wó na dà à dé o ɲúhṹ á ĩ yí mɔn. ");
INSERT INTO boxNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","O Heroode bĩnía ɓuan wo ɓueé nɔn wɛn, lé bìo á wón mún yí mɔn o wékheró. O ɓɛ̀ntĩ́n yí wó bìo ɓúi na nɔn ó o koráa lè mu húmú. ");
INSERT INTO boxNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ĩ ì bío le ɓa ha a lè hã làbàaní, ká ĩ ì día wo o ò lɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hen ká ho Paaki sã́nú díró dɔ̃n, ó o Pilaate ko ò o lén o kàsó nìi ɓúi día. ");
INSERT INTO boxNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","À bṹn ɓa ɓúenɓúen páanía wee bío pɔ̃́npɔ̃́n: «Ɓúe o, à ũ día o Barabaasi!» ");
INSERT INTO boxNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wón Barabaasi so kàsó zoró ɲúhṹ lé bìo ó o hĩ́a wi ho kã́aló fio yi, á ɓó a nìi ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bìo ó o Pilaate wi ò o día a Yeesu, ó o wíokaa tùara ɓa zã̀amáa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ká ɓa màhã́ wee wãamaka: «Ɓúɛɛ wo ho *kùrùwá wán ò o hí! Ɓúɛɛ wo ho kùrùwá wán ò o hí!» ");
INSERT INTO boxNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mu cúa-tĩn níi ó o Pilaate bía nɔn ɓa yi: «Lée webio ó o wó khon yi? Ĩ yí mɔn bìo ɓúi na nɔn ó o koráa lè mu húmú. Ĩ ì bío le ɓa ha a lè hã làbàaní, ká ĩ ì día wo o ò lɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ká ɓarɛ́n bán pá lan wee wãamaka pɔ̃́npɔ̃́n le ɓa ɓúɛɛ o Yeesu ho kùrùwá wán. Á ɓarɛ́n wãamakaa lé hĩ̀a yú ho pànká. ");
INSERT INTO boxNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ó o wã́a tà le mí ì wé bìo ɓa wee cà. ");
INSERT INTO boxNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O nìi na ɓa le o día, wón na kɛra ho kã́aló fio yi á wó le nì-ɓúee ɓa dó ho kàsó yi, ó o léra día, ò o nɔn o Yeesu ɓa dásíwá yi le ɓa wé làa bìo ɓa zúifùwa sĩa vá yi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bìo ɓa ɓuan o Yeesu wàráa, á ɓa vaá fò mín làa Sirɛɛna nìi ɓúi na ɓa le Simɔn, ò o ló hã mana yi lua. Á ɓa dásíwá wìira a ɓueé séenía lè ho kùrùwá, ò o bèráa o Yeesu mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɓa minka zã̀amáa bò a yi á séenía ɓa hã́awa ɓúi na wee wá kùaará a bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ó o Yeesu yèrèmáa wee bío làa ba: «Zeruzalɛɛmu hã́awa, mi yí wá ĩnɛ́n bìo yi, ká mi wá minɛ́n miten lè mí zàwa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Lé bìo hã wizooní ɓúi na lua yi, á ɓa khíi wé è bío: ‹Ɓa hã́awa na yí máa te làa bìa dĩǹ yí ton za yí yɛ̀ɛnía yí mɔn bán ɲúná ɓɛ̀ntĩ́n sĩ.› ");
INSERT INTO boxNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hón pã̀ahṹ so yi ká ɓa à bío ò na hã ɓúaa yi: ‹Mi tè ɲì wɛn› á mún ǹ bío lè hã dònɓúaa: ‹Mi pe wɛn› ");
INSERT INTO boxNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Lé bìo ká ɓa wee wé ĩnɛ́n na ka lòn ɓùɛn-siire kà síi, á minɛ́n na ka lòn ɓùɛn-henì bìo khíi dà bṹn wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓa mún ɓuan nì-wànna nùwã ɲun ɓúi na ɓa à páaní ì ɓúe là a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bìo ɓa vaá dɔ̃n ho lahó na ɓa wee ve làa «Ɲún-ɓòkuee» á ɓa ɓúaa o Yeesu ho *kùrùwá wán bĩ́n. Ɓa nì-wànna nùwã ɲun á ɓa mún ɓúaa hã kùrùwáwá wán bĩ́n. O nì-kéní wi là a Yeesu nín-tĩánì ká yìa so wi là a nín-káahó. ");
INSERT INTO boxNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ó o Yeesu bía: «Ĩ Maá, sɛ́n día na ɓa yi, lé bìo ɓa yí zũ bìo ɓa wee wé.» Bṹn mɔ́n á ɓa dásíwá wó le ɲún-sĩni bìo á sankaaráa o sĩ̀-zĩ́nia. ");
INSERT INTO boxNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓa zã̀amáa dĩ̀n bĩ́n á wee loń. Ɓa *zúifùwa ɲúnása bán wee yáa mí ɲiní yi na a yi ká ɓa à bío: «O fenía ɓa ɓúi, le orɛ́n mún fení míten ká a lé o *Krista bìo bon, yìa le Dónbeenì mɔn léra.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ɓa dásíwá mún wee yáa mí ɲiní yi na a yi. Ɓa vá ɓueé ɓó a yi, á hóonía mu bè-ɲia yòó nɔn wo yi ");
INSERT INTO boxNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","à ɓa wee bío: «Hen ká fo lé ɓa zúifùwa bɛ́ɛ, à ũ fení ũten ũten.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yòó o ɲúhṹ yi á bìo kà lé bìo ɓa túara: «Yìa kà lé ɓa zúifùwa bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɓa nì-wànna na ɓa ɓúaa nì-kéní wee là a ká a bío: «Fo yínɔń o Krista le, á ũ fení ũten ũten à ũ mún fení warɛ́n lon!» ");
INSERT INTO boxNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ká a nì-kéní na so wón ɓɛ̀n wee zá lè mí ninza mu ká a bío: «Fo yí máa zɔ̃́n Dónbeenì le? Yínɔń le lònbee dà-kéní mu á ũ wi yi le? ");
INSERT INTO boxNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Warɛ́n bán ko lè le lònbee, lé bìo wa wékhe lé hìa dó wɛn mu yi, ká arɛ́n wón yí wó bè-kohó.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bṹn mɔ́n ó o bĩnía bía: «Yeesu, hen ká fo khíi ɓuara lè ũ bɛ́ɛnì, à ũ pa ĩ bìo.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ó o Yeesu bía nɔn wo yi: «Le ĩ mì ho tũ̀iá poni na foǹ: Ho zuia ká fo ò kɛń làa mi le Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Mu wó à le wii wà yòó fárá, á ho kɔ̃hṹ ɓúenɓúen dĩ̀ndĩ̀n wó le tíbírí á míana fúuu fúaa le wi-háarè. Ho pɔ̃nsòró na zoó le *Dónbeenì zĩ-beenì yi á lɛnkaa mín tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ó o Yeesu bía pɔ̃́npɔ̃́n: «Ĩ Maá, ĩ wee dé ĩ mànákã̀ ũ níi yi.» Bìo ó o bía bṹn vó, ó o húrun. ");
INSERT INTO boxNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bìo ho Oroomu dásíwá kuure ɲúhṹso mɔn bìo wó, ó o khòonía le Dónbeenì, ò o wee bío: «O nìi na kà ɓɛ̀ntĩ́n lá térénna.» ");
INSERT INTO boxNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɓa zã̀amáa na ɓuara ɓueé lora mu bìo mu á mɔn bìo wó, á ɓa bĩnía wà ká ɓa yara sò làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","O Yeesu ɓàn bɔ̃́nlowà ɓúenɓúen lè ɓa hã́awa na bò làa wó hàrí ho Kalilee yi á ɓueé khɛ̀ra dĩ̀n wee loń bìo wee wé. ");
INSERT INTO boxNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nìi ɓúi hĩ́a wi bĩ́n á yèni ɓa le Zozɛɛfu. O wee lé ɓa *zúifùwa lóhó na ɓa le Arimatee yi. O fù lée nì-tente na térénna, á hĩ́a wee lòoní le *Dónbeenì bɛ́ɛnì ɓuenló. O fù lé ɓa zúifùwa làndá tũ̀iá fɛɛrowà nì-kéní, ká a màhã́ fù yí tà bìo ɓa ninzàwa ɲiní tò wán wó. ");
INSERT INTO boxNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ó o wà van o Pilaate cɔ̃́n vaá fìora a Yeesu nì-hínmu. ");
INSERT INTO boxNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bṹn mɔ́n ó o huera a ho *kùrùwá wán, á lií pon yi lè ho ɓunló, á lá vaá nùuna le búure na có ho ɓúaahó yi, na á nì-hío lá dĩǹ yí nùuna yi yí mɔn. ");
INSERT INTO boxNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mu wó ho yèzṹmá zoǹ zĩihṹ á ho *Sabaa ɲúhṹ ɓúaráa. ");
INSERT INTO boxNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓa hã́awa na bò là a Yeesu hàrí ho Kalilee yi á bò mín là a Zozɛɛfu vaá mɔn le búure, á lora bìo ó o Yeesu nì-hínmu dũmanáa. ");
INSERT INTO boxNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bṹn mɔ́n á ɓa bĩnía vaá wee wíoka ho ɲiló lè mu bìo na sãmu sĩ o Yeesu mu sãnía bìo yi. Ho Sabaa zoǹ á ɓa vũńna làa bìo ho làndá heníanáa mu. ");
INSERT INTO boxNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ho dimaasi zoǹ yìnbíi bùirìi á ɓa hã́awa hĩ́nɔn lá ho ɲiló na sãmu sĩ na ɓa lá wíokaa, á ɓuan vannáa le búure wán. ");
INSERT INTO boxNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓa vaá yú le hue-beenì na lá pon le búure ɲii à le bĩ̀inía khíi día. ");
INSERT INTO boxNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Á ɓa yòó zon, ká ɓa màhã́ yí zoó mɔn o Ɲúhṹso Yeesu sãnía. ");
INSERT INTO boxNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Á ɓa dĩ̀n yilera lùnkaa, à bṹn à báawa nùwã ɲun na sĩ̀-zĩ́nia wee ɲuiíka dĩ̀n ɓa yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bìo ɓa zã́na dĩ̀n cúiorá mí ɲúná, á ɓa nùpua mu bía làa ba: «Lée webio nɔn á yìa yìo wi lua á mí ɓueé wee cà ɓa nì-hía lùe yi? ");
INSERT INTO boxNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O mía hen. O vèera. Mi le mi yiwa bìo ó o hĩ́a bía nɔn mia wán ká a wi ho Kalilee yi: ");
INSERT INTO boxNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹O *Nùpue Za ko ò o dé ɓa bè-kora wérowà níi yi, à ɓúɛɛ ho *kùrùwá wán, à vèe hã wizooní tĩn níi zoǹ.›» ");
INSERT INTO boxNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Á ɓa hácírí màhã́ bĩnía ɓuara o Yeesu bíoní wán. ");
INSERT INTO boxNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Á ɓa bĩnía wà vaá bía mu ɓúenɓúen nɔn ɓa tonkarowà pírú dòn làa bìa ká ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓa lé o Makadala Mari, là a Zaana, là a Zaaki ɓàn nu Mari. Ɓa hã́-vio na lá páanía wi làa ba á mún bía mu bìo dà-kéní mu nɔn ɓa tonkarowà yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɛ̀ɛ ká ɓa tonkarowà màhã́ lá hã bíoní mu lòn bín-conconwà, á ɓa yí tà ɓa bìo. ");
INSERT INTO boxNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ká a Piɛre màhã́ pá hĩ́nɔn lùwa van le búure wán à vaá lií lúnlúrá ò o lora le yi. Á ho nùuló dɛ̀ɛ lé dìo ó o mɔn. Ó o wó coon bìo wó bìo yi á bĩnía vannáa mí zĩi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Le wizonle mu mí bɛɛre zoǹ, ó o Yeesu nì-kenínia nùwã ɲun ɓúi bò mín ɲɔn ho lóhó na ɓa le Emayuusi. Horɛ́n lè ho Zeruzalɛɛmu á à yí lɛ́ɛ̀rèwa bìo ɲun vɛɛnì síi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bìo wó khĩína ɓúenɓúen lé bṹn ɓàn láakáwá á ɓa wee tà. ");
INSERT INTO boxNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bìo ɓa wee bío ká ɓa à wã̀aní mín ká ɓa wà, ó o Yeesu mí bɛɛre ɓueé ɓó ɓa yi á bò làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ɓa ɲɔǹ wee mi a, ká bìo ɓúi màhã́ hò ɓa á ɓa yí zũna a. ");
INSERT INTO boxNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ó o Yeesu tùara ɓa yi: «Lée webio á mi wee wã̀aní wán ká mi wà?» Á ɓa dĩ̀n sò mí yara. ");
INSERT INTO boxNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Á ɓa nì-kéní na ɓa le Keliopaasi bía nɔn wo yi: «Ɓa nùpua na ɓuara ho Zeruzalɛɛmu yi ɓúenɓúen, á ũnɛ́n ũ dòn lé yìa yí zũ mu bìowa na wó hã wizooní yɛn na kà yi le?» ");
INSERT INTO boxNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ó o tùara ɓa yi: «À bṹn bìowa so lè mu yɛ́n?» Á ɓa bía nɔn wo yi: «Bìo wó a Nazarɛɛte nìi Yeesu yi hã́. O lá lé le *Dónbeenì ɲi-cúa fɛɛro. Le Dónbeenì lè ɓa nùpua zũna le o pànká wi mí bè-wénia lè mí bíoní yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wa *yankarowà ɲúnása lè wa ya-díwá nɔn wo bìa yí zũ le Dónbeenì yi à bán síinía ɲúhṹ à ɓúe, á ɓa ɓúaa wo ho *kùrùwá wán. ");
INSERT INTO boxNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wa lá wee leéka le orɛ́n lè yìa ko ò o kã̀ní a *Isirayɛɛle nìpomu, ká mu yìo wã́a máa lé. Ho zuia lé mu bìowa mu wéró wizooní bìo tĩn. ");
INSERT INTO boxNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wa kuure hã́awa nùwã yɛn ɓúi wó wɛn coon. Ɓa fù hĩ́nɔn le yìnbíi bùirìi á van le búure wán, ");
INSERT INTO boxNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ká ɓa màhã́ yí vaá yú a sãnía. Á ɓa bĩnía ɓueé bía mu nɔn wɛn, à ɓa mún bía le Dónbeenì wáayi tonkarowà ɓúi zéenía míten làa mí, à ɓa bía nɔn mí yi wéréwéré le o yìo wi lua. ");
INSERT INTO boxNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wa ninzàwa nùwã yɛn ɓúi mún van le búure wán á vaá mɔn mu ɓúenɓúen làa bìo ɓa hã́awa bíaráa mu, ò o Yeesu wón ɓa yí mɔn.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ó o Yeesu màhã́ wã́a wee bío làa ba: «Mi lé ɓa bɔ̃́nbúwá. Mi yí máa dé mí sĩa le Dónbeenì ɲi-cúa fɛɛrowà bè-bíonii yi fùa. ");
INSERT INTO boxNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","O *Krista so lá yí ko ò o lò be kà síi à yíráa mí cùkú beenì le Dónbeenì cɔ̃́n le?» ");
INSERT INTO boxNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bṹn mɔ́n ó o wã́a zéenía bìo bía a dã́ní yi le Dónbeenì bíonì vũahṹ yi ɓúenɓúen ɓàn kúará. O ɓúa mu ɲúhṹ là a *Mɔyiize vɔ̃nna á vaá lá lè le Dónbeenì ɲi-cúa fɛɛrowà vɔ̃nna ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bìo ɓa vaá ɓó ho lóhó na ɓa wee va yi, ó o Yeesu wó lòn nìi na le mí ì khĩí á à va làa yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ká ɓa màhã́ hò a le o yí wé mu, à ɓa bía nɔn wo yi: «Día à ũ cãa làa wɛn, ho tá wee hĩ.» Ó o Yeesu wã́a zoó làara ɓa wán. ");
INSERT INTO boxNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bìo ɓa wee dí, ó o lá ho búurú, á dó le Dónbeenì bárákà, ò o cɛ̀ɛkaa ho nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lé bṹn wán á ɓa yìo màhã́ fá, á ɓa zũna a. Ó o dɛ̀ɛnía ɲuuna vṹnun ɓa yahó. ");
INSERT INTO boxNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Á ɓa wee bío làa mín: «Bìo ó o fù wee bío ká a zéení le Dónbeenì bíoní kúará làa wɛn ho wɔ̃hṹ wán á wa sĩa so fù yí hã le?» ");
INSERT INTO boxNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","À ɓa dɛ̀ɛnía hĩ́nɔn bĩnía ɲɔn ho Zeruzalɛɛmu. Ɓa vaá yú ɓa tonkarowà pírú dòn lè mí ninzàwa mín wán bĩ́n, ");
INSERT INTO boxNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","á bán wee bío làa ba: «O Ɲúhṹso vèera bìo bon. O Simɔn mɔn wo.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Á ɓarɛ́n mí bɛɛre lá bìo wó ho wɔ̃hṹ wán bía nɔn ɓa yi, làa bìo ɓa zũńnanáa o Yeesu pã̀ahṹ na ó o wee cɛ̀ɛka ho búurú yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bìo ɓa wi bṹn bíoró yi, à bṹn ò o Yeesu mí bɛɛre dɛ̀ɛnía wi ɓa tĩ́ahṹ ó o bía nɔn ɓa yi: «Le ho hɛ́ɛrà kɛń làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Á ɓa zã́na dàkhĩína, lé bìo ɓa mɔn wo wó làa nì-hɔ̃́nbóní. ");
INSERT INTO boxNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ká a Yeesu màhã́ bía làa ba: «Mi yilera yáara le we? Lée webio nɔn hã titikaa wiráa mí sĩa yi? ");
INSERT INTO boxNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mi loń ĩ níní le ĩ zení. Mu lé ĩnɛ́n ĩ bɛɛre. Mi ɓuee dã mi loń, lé bìo ó o nì-hɔ̃́nbóní sãnía mía làa bìo mi mɔn à ĩnɛ́n sãnía wiráa bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O bía hɔ̃́n bíoní so nɔn ɓa yi, ò o zéenía mí níní lè mí zení làa ba. ");
INSERT INTO boxNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ká ɓa minka sĩ-wɛɛ làa bìo mu wó ɓa coon bìo yi, á ɓa pá yí tà yí tà le o Yeesu vèera bìo bon, ó o wã́a bía nɔn ɓa yi: «Bè-dínii wi mi cɔ̃́n le?» ");
INSERT INTO boxNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Á ɓa nɔn o ceza na sɔ̃n sɔ̃́n-kéní wo yi, ");
INSERT INTO boxNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ó o fó a là ɓa yìo yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bṹn mɔ́n ó o bía nɔn ɓa yi: «Bìo kà lé bìo á ĩ bía nɔn mia pã̀ahṹ na á ĩ làa mia páanía wi: Bìo túara ĩ dã́ní yi ɓúenɓúen o Mɔyiize làndá lè ɓa ɲi-cúa fɛɛrowà vɔ̃nna, lè hã leni vũahṹ yi á lá ko mu wé.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bṹn mɔ́n ó o Yeesu wó á ɓa wee zũń le Dónbeenì bíonì vũahṹ bíoní kúará, ");
INSERT INTO boxNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ò o bía nɔn ɓa yi: «Mu túara kà: O *Krista ko ò o lò be, bṹn mɔ́n ò o vèe hã wizooní tĩn níi zoǹ. ");
INSERT INTO boxNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bìo kà lé bìo mi bue o yèni yi à na hã sìíwà nùpua ɓúenɓúen yi: ‹Mi yèrèmá mi yilera lè mi wárá à mi yí mu bè-kora sɛ́ndíaró.› Mi ɓúa mu ɲúhṹ ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bìo mi mɔn à mi bío na ɓa nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ĩnɛ́n ĩ bɛɛre á à tonka le Dónbeenì Hácírí na le dó mí ɲii le mí ì na á le è lii mi wán, ká mi màhã́ ko mi kɛɛní ho lóhó yi fúaa le Dónbeenì pànká lé ho wáayi à lii mi wán.» ");
INSERT INTO boxNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bṹn mɔ́n ó o Yeesu fó ɓa á ɓa ló ho lóhó yi wà vaá sùaráa ho Betanii yi, lé bĩ́n ó o hóonía mí níní ò o dúɓuaa ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pã̀ahṹ na ó o wee dúɓua ɓa yi, ó o làa ba saawaa mín yi, ó orɛ́n wón ɓuan yòora ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ká ɓarɛ́n bán ɓùaanía wo à ɓa bĩnía van ho Zeruzalɛɛmu ká ɓa sĩa wan làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ɓa yí máa khí le *Dónbeenì zĩ-beenì yi. Ɓa wee ɓuee ɓùaaní le bĩ́n fɛ́ɛɛ.");
INSERT INTO boxNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mu ɲúhṹ ɓúɛɛníi, á yìa lé le Bíonì á wi ká bìo ɓúi dĩǹ yí léra. O páanía wi lè le Dónbeenì. Orɛ́n mí bɛɛre lé le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mu bìo ɓúenɓúen ɲúhṹ ɓúɛɛníi, ká arɛ́n lè le Dónbeenì páanía wi. ");
INSERT INTO boxNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lé orɛ́n á le Dónbeenì dĩ̀n wán léraráa mu bìo ɓúenɓúen. Bìo ó o níi yí kɛra lénló yi bṹn mía. ");
INSERT INTO boxNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Orɛ́n lé yìa le mukãnì wee lé cɔ̃́n. Dén mukãnì so ka lòn khoomu na wee zéení bìo le Dónbeenì karáa lè ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mu khoomu mu wee dé le tíbírí yi, á bìa wi le tíbírí mu yi wee pĩ́ mu bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nìi ɓúi hĩ́a wi bĩ́n á le Dónbeenì tonkaa. O yèni ɓa le Zãn. ");
INSERT INTO boxNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Lé orɛ́n ɓuara ɓueé wó yìa ka lòn khoomu sɛɛ́ràso, á wee mì ho tũ̀iá o ɲii, bèra a na à ɓa ɓúenɓúen tà le yìa ka lòn khoomu á bìo bon orɛ́n pànká yi. ");
INSERT INTO boxNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Orɛ́n mí bɛɛre hĩ́a yínɔń yìa ka lòn khoomu, ká a ɓueé wó o sɛɛ́ràso, á mà ho tũ̀iá o ɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yìa lé mu khoomu binbirì á ɓuara ho dĩ́míɲá yi á ɓueé wee dé mu khoomu ɓa nùpua ɓúenɓúen wán. ");
INSERT INTO boxNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yìa lé le Bíonì á wi ho dĩ́míɲá yi, ho dĩ́míɲá na le Dónbeenì dĩ̀n orɛ́n wán á léra. Ɛ̀ɛ ká ho dĩ́míɲá mu nùpua màhã́ yí zũna a. ");
INSERT INTO boxNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O ɓuara mín kùrú lùe yi, á bìa bìo sã̀ a yi pã́ a bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ká ɓa tĩ́ahṹ á ɓa ɓúi màhã́ tà a bìo, á dó mí sĩa wo yi. Bán ó o wó á ɓa wó le Dónbeenì zàwa. ");
INSERT INTO boxNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓa yí wó le Dónbeenì zàwa làa bìo ɓa nùpua wee teráa ɓa zàwa bìo. Ɓa mún yí wó le Dónbeenì zàwa làa bìo ó o báa là a hã́a wee páaní à yíráa ɓa zàwa bìo. Le Dónbeenì míten lé dìo wó á ɓa lé le zàwa. ");
INSERT INTO boxNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yìa lé le Bíonì á ɓueé wó a nùpue, á kará làa wɛn. O sãamu ɲii mía. Lé orɛ́n wee zéení ho tũ̀iá poni binbirì làa wɛn. Wa fá wa yìo o cùkú yi, hìa ó o Za kéní na ló mín Maá Dónbeenì cɔ̃́n wé yí. ");
INSERT INTO boxNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O Zãn na lé o sɛɛ́ràso á bía bìo kà pɔ̃́npɔ̃́n o dã́ní yi: «Yìa kà lé yìa á ĩ fèra bía bìo nɔn mia. Ĩ bía le o wi ĩ mɔ́n bò o ɓuen, ká a màhã́ po mi lé bìo ó o wi ĩ yahó hàánì.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mu bè-tentewà lè mí sìíwà na lé o sãamu na ɲii mía á wa ɓúenɓúen yú ɲàmaa mín wán. ");
INSERT INTO boxNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ho làndá lé o *Mɔyiize á le Dónbeenì bò yi nɔnnáa ho wɛn. Ká mu sãamu lè ho tũ̀iá poni lé orɛ́n na lé o Yeesu *Krista á le Dónbeenì bò yi zéeníanáa mu làa wɛn. ");
INSERT INTO boxNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nùpue na dĩǹ mɔn le Dónbeenì wón mía. Ká arɛ́n na lé o Za kéní na lé le Dónbeenì, yìa páanía wi là a Maá Dónbeenì, lé wón nɔn ó o Maá bìo zũnáa. ");
INSERT INTO boxNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Wizonle ɓúi á ɓa *zúifùwa ɲúnása na wi ho Zeruzalɛɛmu yi á tonkaa ɓa yankarowà là a Levii nùwã le ɓa ɓuee tùa o Zãn yi le o lé o nùpue yɛ́n sìí. Ó o yí sà mu, ò o mà ho tũ̀iá wéréwéré nɔn bìa ɓa tonkaa yi: «Ĩnɛ́n yínɔń o Krista, yìa le Dónbeenì mɔn léra.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Á ɓa tùara a yi: «Á fo lé o nùpue yɛ́n síi? Fo lé le *Dónbeenì ɲi-cúa fɛɛro *Elii le?» Ó o Zãn le mí yínɔń Elii. Á ɓa bĩnía tùara: «Á fo lé le *Dónbeenì ɲi-cúa fɛɛro na wa wee lòoní le?» Ó o Zãn le ɓùeé. ");
INSERT INTO boxNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Á ɓa wã́a bía nɔn wo yi: «Ũnɛ́n ɓɛ̀n lé o nùpue yɛ́n sìí? Wa ko wa vaa zéení bìo ɓúi à na bìa tonkaa wɛn yi. Fo lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ó o Zãn bía: «Ĩnɛ́n lé yìa le *Dónbeenì ɲi-cúa fɛɛro *Ezayii bía bìo: ‹Nìi ɓúi wee bío pɔ̃́npɔ̃́n le dùure yi kà síi: Mi wíoka ho wɔ̃hṹ ká a Ɲúhṹso o ɓuen.›» ");
INSERT INTO boxNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bìa ɓa tonkaa o Zãn cɔ̃́n ɓúi lé ɓa Farizĩɛwa. ");
INSERT INTO boxNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Á bán tùara a Zãn mu yi: «Ká fo yínɔń yìa le Dónbeenì mɔn léra, á yínɔń o Elii, á mún yínɔń le Dónbeenì ɲi-cúa fɛɛro na wa wee lòoní, á lée webio nɔn fo wee bátízéráa ɓa nùpua?» ");
INSERT INTO boxNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ó o Zãn wã́a bía nɔn ɓa yi: «Ĩnɛ́n wee bátízé ɓa nùpua lè mu ɲumu. Ɛ̀ɛ ká a ɓúi wi mi tĩ́ahṹ á mi yí zũ bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ĩnɛ́n fèra dú wón yahó. O nakãa tɛnló á ĩnɛ́n yàá pá yí koráa.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bìo kà ɓúenɓúen wó ho Betanii lóhó yi, ho muhṹ na ɓa le Zurudɛ̃n mɔ́n, hìa ó o Zãn hĩ́a wee bátízé ɓa nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mu tá na lée tɔ̃n, ó o Zãn mɔn ò o Yeesu mà a wee ɓuen, ó o bía: «Yìa kà ka lòn muinì pioza á le Dónbeenì nɔn à sɛ́nnáa ho dĩ́míɲá nùpua bè-kora día. ");
INSERT INTO boxNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lé orɛ́n lé yìa á ĩ bía bìo kà síi: Nùpue ɓúi wi ĩ mɔ́n bò o ɓuen, ká a màhã́ po mi lé bìo ó o wi ĩ yahó hàánì. ");
INSERT INTO boxNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ĩ lá yí zũ yìa lé orɛ́n, ká ĩ màhã́ ɓueé wee bátízé ɓa nùpua lè mu ɲumu, bèra a na ò o *Isirayɛɛle nìpomu à zũń wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","O Zãn mu pá bĩnía bía bìo kà wéréwéré: «Ĩ mɔn le Dónbeenì Hácírí à le lion o wán lòn háponi, á lií wi làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ĩ lá dĩǹ yí zũ yìa lé orɛ́n, ká le Dónbeenì na tonkaa mi le ĩ bátízé ɓa nùpua lè mu ɲumu màhã́ bía nɔn miì: ‹Fo ó mi le Dónbeenì Hácírí ká le yòó ló wee lii o nùpue ɓúi wán. Wón lé yìa á à bátízé ɓa nùpua lè le Dónbeenì Hácírí.› ");
INSERT INTO boxNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ĩ mɔn mu, á ĩ wee bío mu wéréwéré le o lé le Dónbeenì Za.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mu tá na lée tɔ̃n, ká a Zãn tĩ́n wi ho lahó dà-kéní mu yi lè mí nì-kenínia nùwã ɲun, ");
INSERT INTO boxNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ó o mɔn o Yeesu ò o wee khĩí, ó o bía: «Yìa wee khĩí kà lé le *Dónbeenì Pioza.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ó o Zãn nì-kenínia nùwã ɲun mu ɲá bìo ó o bía, á ɓa dɛ̀ɛnía bò a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ó o Yeesu yèrèmáa khíi lora á mɔn à ɓa bò a yi, ó o tùara ɓa yi: «Lée webio mi wee cà.» Á ɓa bía: «Arabii (bṹn kúará le: ‹nì-kàránlo›), lé wen fo wi yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ó o Yeesu bía nɔn ɓa yi: «Mi ɓuen, á mi vaa mi hen na á ĩ wi yi.» Á ɓa wã́a bò a yi á vaá zũna bĩ́n. Mu wó le wi-háarè. Á ɓa wã́a kará tò le wii bĩ́n làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","O Zãn nì-kenínia nùwã ɲun na ɲá a bíoní á bò a Yeesu yi nì-kéní ɓa le Ãndere, o Simɔn Piɛre ɓàn za. ");
INSERT INTO boxNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yìa ó o Ãndere mu nín-yání van cɔ̃́n lé ɓàn za Simɔn mu á vaá bía nɔn wo yi: «Wa mɔn o Mɛsii.» (Mɛsii lé mu heberemu. Ká mu kúará lè mu kɛrɛɛkimu ɓa le Krista, bṹn kúará le yìa le Dónbeenì mɔn léra.) ");
INSERT INTO boxNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ò o fó a ɓuararáa o Yeesu cɔ̃́n. Ó o Yeesu lora a yi ò o bía: «Fo lé o Simɔn, o Zãn za. Àwa! Bìo kà wán á ɓa wé è ve fo làa Sefaasi.» (Sefaasi lé mu heberemu. Mu kɛrɛɛkimu yi ɓa le Piɛre, bṹn kúará le ɓúaahó.) ");
INSERT INTO boxNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mu tá na lée tɔ̃n, ó o Yeesu le mí ì va ho Kalilee kɔ̃hṹ, ó o fò mín là a nìi ɓúi na yèni ɓa le Filiipu, ó o bía nɔn wo yi: «Bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Filiipu mu wee lé ho Bɛtesayidaa lóhó yi, hen na ó o Ãndere là a Piɛre wee lé yi. ");
INSERT INTO boxNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Bṹn mɔ́n ó o Filiipu ɓɛ̀n vaá fò mín là a Natanayɛɛle, ó o bía nɔn wón yi: «Yìa ó o *Mɔyiize bía bìo ho làndá vɔ̃nna yi, wón na ɓa ɲi-cúa fɛɛrowà mún bía bìo, á wa yú. O lé o Nazarɛɛte nìi Yeesu, o Zozɛɛfu za.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ó o Natanayɛɛle bía nɔn wo yi: «Bè-tente so dà a lé Nazarɛɛte yi le?» Ó o Filiipu bía nɔn wo yi: «Ɓuen á fo vaá mi a.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bìo ó o Yeesu mɔn o Natanayɛɛle ò o vará mà a, ó o bía bìo kà o dã́ní yi: «Yìa kà á kũaakṹaamu mía yi. O lé o *Isirayɛɛle nìi binbirì.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ó o Natanayɛɛle tùara a Yeesu yi: «Fo wó kaka zũnanáa mi?» Ó o Yeesu bía nɔn wo yi: «Ĩ fèra mɔn fo ká ũ kará le vĩ̀ndɛ̀ɛ na ɓa le fíkíyée tá, ká a Filiipu yàá dĩǹ yí von fo.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ó o Natanayɛɛle bía nɔn wo yi: «Nì-kàránlo, fo lé le Dónbeenì Za. Fo lé o Isirayɛɛle nìpomu bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ó o Yeesu bía nɔn wo yi: «Fo dó ũ sĩi miì lé bìo á ĩ bía le ĩ mɔn fo ho *fíkíyée tá. Àwa! Bè-beera ɓúi yàá khíi wé fo ò mi ká mu po bìo kà.» ");
INSERT INTO boxNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ò o pá bĩnía bía: «Le ĩ mì ho tũ̀iá na mia: Mi khíi mi ho wáayi ká ho hɛ́ra, á le Dónbeenì wáayi tonkarowà wee bè o *Nùpue Za yi à liiráa à bĩní yòo.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hã wizooní bìo tĩn zoǹ, à bṹn mu yaamu sã́nú ɓúi wee dí ho Kalilee kɔ̃hṹ lóhó na ɓa le *Kanaa yi. Ó o Yeesu ɓàn nu kɛra bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ɓa mún von o Yeesu lè mí nì-kenínia mu yaamu mu sã́nú díiníi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bìo ho *dìvɛ̃́n hĩ́a vó, ó o Yeesu ɓàn nu ɓueé bía nɔn wo yi: «Ɓa dìvɛ̃́n vó.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ká a Yeesu màhã́ bía nɔn wo yi: «Hã́a mu, lé ũnɛ́n ko ũ zéení bìo á ĩ ko à ĩ wé làa mi le? Ĩ pã̀ahṹ dĩǹ yí dɔ̃n.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ó o Yeesu ɓàn nu wã́a bía nɔn ɓa ton-sáwá yi: «Bìo ɓúenɓúen na ó o hĩ́a à bío le mi wé, à mi wé mu.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ɲumu sĩ̀a bìo hèzĩ̀n wi bĩ́n. Hã lé hã huaa á ɓa tan. Hã mí dà-kéní kéní á liiterewa khĩmàni síi dà à kúee yi. Ɓa *zúifùwa wee wé kúee mu ɲumu hã yi, à sɛɛka lè míten làa bìo ɓa làndá bòráa mu à ceéráa míten. ");
INSERT INTO boxNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ó o Yeesu bía le ɓa ton-sáwá hà mu ɲumu síiní hã sĩ̀a mu. Á bán síinía hã yòó ɓó mí ɲi-kã́a yi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ó o Yeesu wã́a bía nɔn ɓa yi: «Mi kĩ̀ mu cĩ́inú à vaa na yìa dú ho sã́nú tonni yahó yi.» Á ɓa kã̀ mu vaá nɔn wo yi, ");
INSERT INTO boxNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ó o díndío à mu lé ho dìvɛ̃́n. Ó o yí zũ hen na á hón dìvɛ̃́n so ló yi, ká ɓa ton-sáwá na hà mu ɲumu, bán zũ hen na ho ló yi. Ó o von o hã́-fĩa ɓàn báa ");
INSERT INTO boxNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","á bía nɔn wo yi: «Ɓa nùpua ɓúenɓúen wee wé dá ho dìvɛ̃́n na sĩ ho yahó. Ká pã̀ahṹ na á bìa ɓa von yìo hĩ́a wee vĩ́ ɓa, à ɓa màhã́ wé dá hìa yí tà yí sĩ. À ũnɛ́n wón ɓɛ̀n bàrá hìa sĩ fúuu fúaa hã laà na kà wán.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Bìo kà lé o Yeesu nín-yání yéréké bìo na wee zéení le o ló le Dónbeenì cɔ̃́n na ó o wó. Mu wó ho Kalilee kɔ̃hṹ lóhó na ɓa le Kanaa yi. Bìo ó o wó kà lé bṹn zéenía o beemu, ó o nì-kenínia wíokaa dó mí sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bṹn mɔ́n ó o Yeesu lè mín nu, lè mín zàwa, lè mí nì-kenínia á bò mín van ho *Kapɛɛnayuumu lóhó yi. Ɓa kará bĩ́n wó hã wizooní bìo yɛn. ");
INSERT INTO boxNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bìo ɓa *zúifùwa sã́nú na ɓa le *Paaki díró wà ɓueé sùará, ó o Yeesu wà yòora ho Zeruzalɛɛmu lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bìo ó o vaá zon le *Dónbeenì zĩ-beenì lún yi, ó o zoó yú ɓa nùpua bĩ́n à ɓa wee yɛ̀ɛ́ ɓa nàwa, lè ɓa pia, lè ɓa ɓùaaɓúuní. O mún zoó yú bìa wee pùarí le wárí bĩ́n, à ɓa karáka mí tàbáríwa ɲúná yi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ó o wã́a lá ho hũló pá lè le làbàanì, á ɲɔn lè ɓa ɓúenɓúen á ɓa ló lè mí nàwa lè mí pia. Á ɓa wɛ́n-pùarílowà wárí ó o pɔ̃́nkaa kúaará, á líikaa ɓa tàbáríwa kúaaka. ");
INSERT INTO boxNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ò o bía nɔn ɓa ɓùaaɓú-yɛ̀ɛ́rowa yi: «Mi khuii ɓa le ɓa lé. Mi yí wé ĩ Maá zĩi làa duanló zĩi.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ó o nì-kenínia hácírí yòó ɓuara le Dónbeenì bíonì vũahṹ bíonì na kà wán: «Dónbeenì, bìo á ĩ heníanáa ũ zĩi bìo ɓɛ̀ntĩ́n hĩ́a máa ká mi» ");
INSERT INTO boxNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Á ɓa zúifùwa ɲúnása na wi bĩ́n tùara a yi: «Lé mu yéréké bìo yɛ́n á fo dà à wé á à zéení le bìo fo wó kà ɓàn wéró pànká á fo yú le Dónbeenì cɔ̃́n?» ");
INSERT INTO boxNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ó o Yeesu bía nɔn ɓa yi: «Ká le Dónbeenì zĩ-beenì na kà mi lá fù, á ĩnɛ́n ǹ bĩní ì so le hã wizooní bìo tĩn yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Á ɓa zúifùwa ɲúnása bía nɔn wo yi: «Le Dónbeenì zĩ-beenì na ɓa son hã lúlúio ɓúará-ɲun làa bìo hèzĩ̀n lé dén á ũnɛ́n le ká ɓa lá fù, á fo dà à bĩní ì so hã wizooní bìo tĩn yi le?» ");
INSERT INTO boxNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ɛ̀ɛ ká le Dónbeenì zĩ-beenì na ó o Yeesu wee bío bìo lé orɛ́n mí bɛɛre sãnía. ");
INSERT INTO boxNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","O Yeesu vèeró mɔ́n lé hón pã̀ahṹ so ó o nì-kenínia hácírí bĩnía ɓuara hã bíoní na ó o hĩ́a bía wán. Á ɓa tà le le Dónbeenì bíonì vũahṹ bíonì á bon, á mún tà le o Yeesu bíoní á bon. ");
INSERT INTO boxNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pã̀ahṹ na ó o Yeesu hĩ́a wi ho Zeruzalɛɛmu yi ho *Paaki sã́nú bìo yi, á ɓa nùpua cɛ̀rɛ̀ɛ mɔn mu yéréké bìowa na ó o wee wé, á ɓa tà a bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ká a Yeesu màhã́ yí dó mí sĩi ɓa yi, lé bìo ó o zũ bìo wi ɓa nùpua ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O màkóo mía à ɓa zéení bìo wi o nùpue yi làa wo. Orɛ́n míten zũ bìo wi o nùpue sĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nìi ɓúi hĩ́a wi bĩ́n á yèni ɓa le Nikodɛɛmu. O lé ɓa *zúifùwa ɲúhṹso ɓúi á mún lé ɓa *Farizĩɛwa kuure nùpue ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tĩ́nàahṹ ɓúi, ó o ɓuara a Yeesu cɔ̃́n á ɓueé wee bío làa wo: «Nì-kàránlo, wa zũ le ũnɛ́n lé yìa le Dónbeenì tonkaa. Lé bìo á nùpue yí dà máa wé mu yéréké bìowa làa bìo ũnɛ́n wee wéráa mu ká le Dónbeenì yí nɔn mu wéró pànká ɓànso yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ó o Yeesu bía nɔn wo yi: «Le ĩ mì ho tũ̀iá na foǹ: Nùpue yí dà máa zũń le *Dónbeenì bɛ́ɛnì bìo, ká ɓànso yí bĩnía yí ton.» ");
INSERT INTO boxNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ó o Nikodɛɛmu tùara a Yeesu yi: «O nùpue na yìo tɔ̃n dà à bĩní ì te kaka? Bìo ó o màhã́ yí dà máa bĩní máa zo mín nu píohó yi á máa te.» ");
INSERT INTO boxNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ó o Yeesu bía nɔn o Nikodɛɛmu yi: «Le ĩ mì ho tũ̀iá na foǹ: Nùpue yí dà máa kɛń le Dónbeenì bɛ́ɛnì díiníi, ká ɓànso yí ton mu ɲumu lè le Dónbeenì Hácírí yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yìa ton o nùpue yi, wón mu nìpomu mukãnì wi yi. Á yìa ton le Dónbeenì Hácírí yi, wón le Dónbeenì Hácírí na wee na le mukãnì binbirì wi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Àwa, á bìo á ĩ bía nɔn foǹ le mi ɓúenɓúen ko à mi bĩní te, ũ cén yí le mu wé fo coon. ");
INSERT INTO boxNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ho pinpiró wee wé và lùe lée lùe na bìo sĩ ho yi. Á fo ò ɲí ho sã, ká fo yí zũ hen na ho ló yi, làa hen na ho wee va yi. Lé kà síi ó o nùpue na ton le Dónbeenì Hácírí yi á bìo karáa.» ");
INSERT INTO boxNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ó o Nikodɛɛmu wã́a bía nɔn o Yeesu yi: «Ho bĩní teró mu bìo á dà à wé kaka?» ");
INSERT INTO boxNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ó o Yeesu bía nɔn wo yi: «Ũnɛ́n nì-kàránlo na yèni ló a *Isirayɛɛle nìpomu tĩ́ahṹ, á pá yí zũ bṹn le? ");
INSERT INTO boxNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Le ĩ mì ho tũ̀iá na foǹ: Bìo wa zũ làa bìo wa mɔn á lé mu sɛɛ́ràsa, bṹn lé bìo wa wee bío bìo wéréwéré. Ká mi màhã́ yí wi à mi tà mu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hen ká ĩ wee bío bìo wee wé ho tá wán làa mia, à mi máa tà bìo á ĩ wee bío yi. Á mi ɓɛ̀n ǹ wé kaka à tàráa bìo á ĩ wee bío yi ká ĩ wee bío bìo wee wé ho wáayi làa mia?» ");
INSERT INTO boxNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nùpue dĩǹ yí yòora ho wáayi. O *Nùpue Za mí dòn lé yìa ló ho wáayi á lion. ");
INSERT INTO boxNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bìo ó o Isirayɛɛle nìpomu hĩ́a wi ho tá henì yi, ó o *Mɔyiize hĩ́a can ho hɔ̃nló háa le ɓùɛɛnì yi á hóonía fárá. O Nùpue Za mún ko ò o ca le ɓùɛɛnì yi à hóoní fárá làa bṹn síi, ");
INSERT INTO boxNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bèra a na ká nùpue lée nùpue dó mí sĩi wo yi, à ɓànso yí le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mu bon. Le Dónbeenì wara ho dĩ́míɲá nùpua dàkhĩína, fúaa le nɔn mí za kéní, bèra a na ká nùpue lée nùpue na dó mí sĩi wo yi, à ɓànso bìo yí yáa, ká a yí le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Le Dónbeenì yí tonkaa mí Za ho dĩ́míɲá yi à síinínáa ɓa nùpua ɲúná, ká le tonkaa wo ò o ɓuee kã̀ní ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yìa dó mí sĩi wo yi, wón ɓànso ɲúhṹ máa sí. Ká yìa yí dó mí sĩi wo yi, wón ɲúhṹ sú vó. Ɓànso ɲúhṹ sú lé bìo ó o yí dó mí sĩi le Dónbeenì Za kéní yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bìo nɔn á ɓa nùpua ɲúná súráa lé bìo kà: Yìa na lé mu khoomu binbirì ló ɓuara ho dĩ́míɲá yi. Ká bìo ɓa nùpua wárá yí seka á ɓa wara le tíbírí á po a. ");
INSERT INTO boxNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mu bon, nùpue lée nùpue na wee wé mu bè-kora, wón wee ɲin mu khoomu. O yí máa tà lée dĩ̀n mu yi ò o wén-kora à mi wéréwéré. ");
INSERT INTO boxNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɛ̀ɛ ká yìa wee bè le Dónbeenì tũ̀iá poni yi, wón wee wé lé mu khoomu yi, à ɓa mi wéréwéré le o wee bè le Dónbeenì bíonì yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bṹn mɔ́n ó o Yeesu lè mí nì-kenínia ló ho Zeruzalɛɛmu yi wà van la-veere ho *Zudee kɔ̃hṹ yi. O vaá kará bĩ́n á cãakaa làa ba, á wee bátízé ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","O Zãn wón mún hĩ́a wee bátízé ɓa nùpua ho lahó na ɓa le Enɔn yi, ho wi ho Saliimu lóhó nìsã́ní, lé bìo mu ɲumu boo bĩ́n. Ɓa nùpua hĩ́a wee ɓuen o cɔ̃́n ò o bátízé ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mu wee wé ká a Zãn ɓa dĩǹ yí dó ho kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wizonle ɓúi, ó o Zãn nì-kenínia nùwã yɛn ɓúi wã̀anía là a zúifù nìi ɓúi bìo ho làndá le ɓa wé wé ceéráa míten wán. ");
INSERT INTO boxNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ó o Zãn nì-kenínia mu wà van o cɔ̃́n, á vaá bía nɔn wo yi: «Nì-kàránlo, ũ hácírí so ɓuara a nùpue na nɔ̀nzoǹ wi làa fo khíi ho Zurudɛ̃n mɔ́n bìo yi le? Yìa fo mà ho tũ̀iá ɲii. Àwa, lé o wã́a wee bátízé ɓa nùpua, á ɓa nùpua cɛ̀rɛ̀ɛ mún wee va a cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ó o Zãn bía nɔn ɓa yi: «Nùpue yí dà máa yí bìo ká Dónbeenì yí nɔn mu wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Minɛ́n mi bɛɛre ɲá ho tũ̀iá na á ĩ mà le ĩ yínɔń yìa le Dónbeenì mɔn léra, ká ĩ lée nùpue na le Dónbeenì tonkaa á ĩ dú a yahó ɓuara. ");
INSERT INTO boxNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mu ka lòn hã́-fĩa, wón bìo sã̀ mín báa yi. Ɛ̀ɛ ká ɓàn báa mu ɓàn bɔ̃́nlo wón wee wé dĩ̀n o nìsã́ní, à wé ɲí a bíoní. O sĩi wé wa a hã́-fĩa ɓàn báa bíoní yi. Lé bṹn á ĩnɛ́n sĩi mún wee waráa. Lé ĩ sĩ-wɛɛ mu ɲii màhã́ wã́a sú bìo kà wán. ");
INSERT INTO boxNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yìa mi bía bìo ko ò o bìo ɲúhṹ wé, à wé dé wán, ká ĩnɛ́n bìo ko mu tĩ̀ yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Yìa ló ho wáayi lion, wón po ɓa nùpua ɓúenɓúen. Yìa bìo sã̀ ho tá yi, wón wee wé ɓa nùpua wárá, á wee bío ɓa nùpua bíoní. Ká yìa ló ho wáayi lion wón po ɓa nùpua ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bìo ó o mɔn làa bìo ó o ɲá ho wáayi le Dónbeenì cɔ̃́n, lé bṹn ɓàn tũ̀iá ó o wee mì na ɓa nùpua yi. Ká ɓa nùpua màhã́ yí máa tà bìo ó o wee zéení yi. ");
INSERT INTO boxNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yìa tà ho tũ̀iá na ó o mà nɔn ɓa yi, se ɓànso wee zéení le bìo le Dónbeenì bía lée tũ̀iá poni. ");
INSERT INTO boxNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yìa le Dónbeenì tonkaa wón wee fɛɛ le ɲi-cúa, lé bìo le Dónbeenì wee na mí Hácírí ɓànso yi à yòo puuní. ");
INSERT INTO boxNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Maá Dónbeenì wa a Za, á bàrá a mu bìo ɓúenɓúen ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yìa dó mí sĩi o Za yi, se ɓànso yú le mukãnì binbirì na máa vé. Ká yìa pã́ a Za mu bìo, se wón yí yú dén mukãnì so. Ká le Dónbeenì sĩi pá wé è cĩ̀ ɓànso yi fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɓa *Farizĩɛwa ɲá le o Yeesu mɔ́n nùpua á po a Zãn nùpua, ó o mún wee bátízé ɓa nùpua po a. ");
INSERT INTO boxNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(O Yeesu mí bɛɛre yí máa bátízé ɓa nùpua. O nì-kenínia lé bìa wee bátízé ɓa). Bìo ó o Yeesu ɲá bìo ɓa bía a dã́ní yi, ");
INSERT INTO boxNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ó o ló ho *Zudee kɔ̃hṹ yi lè mí nì-kenínia á bĩnía ɲɔn ho Kalilee kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ká ɓa màhã́ ko ɓa kã́a ho *Samarii kɔ̃hṹ yi à varáa bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ɓa wà á vaá sùaráa ho Samarii lóhó ɓúi na ɓa le Sikaare yi. Ho lóhó mu ɓó ho mɔhṹ na ó o *Zakoobu yánkaa nɔn mí za Zozɛɛfu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Buii ɓúi ó o Zakoobu yánkaa có bĩ́n. Bìo ó o Yeesu ɓueé dɔ̃n dén buii so ɲúhṹ yi, ò o san le vɛɛnì yi, ó o lií kará bĩ́n wee vũńka. Ò o nì-kenínia bán wà zoó yà mu bè-dínii ho lóhó yi. Mu wó à le wii yòó fárá. Ó o Samarii hĩ́nzoró ɓúi ló wà ɓueé hà mu ɲumu, ó o Yeesu bía làa wo: «Hã́a mu, hã mi lè mu ɲumu le ĩ ɲu.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ó o hã́a bía nɔn wo yi: «Éee! Ũnɛ́n zúifù nìi wó kaka wee fìo mu ɲun-ɲunii ĩnɛ́n na lé o Samarii hĩ́nzoró cɔ̃́n?» O hã́a bía bṹn lé bìo ɓa *zúifùwa fù yí máa páaní bìo ɓúi yi lè ɓa Samariisa hùúu. ");
INSERT INTO boxNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ó o Yeesu bía nɔn o hã́a mu yi: «Fo lá zũ bìo na le Dónbeenì le mí ì hã làa fo, á lá zũ yìa wee fìo mu ɲumu ũ cɔ̃́n, ũnɛ́n lé fo lá à fìo mu ɲumu, ó o lá à na mu ɲumu na wee na le mukãnì binbirì foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ó o hã́a bía nɔn o Yeesu yi: «Nì-kàránlo, le buii nà yi, á ũ hũló mún mía máa hàráa. Á fo lá à wé kaka á à yíráa mu ɲumu na wee na le mukãnì binbirì mu? ");
INSERT INTO boxNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wàn ɓùaa Zakoobu lé yìa có le buii mu. Orɛ́n mí bɛɛre ɲun le ɲumu, ó o zàwa là a sáníi mún ɲun mu. Á ũnɛ́n so dà à bío le fo po wón le?» ");
INSERT INTO boxNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ó o Yeesu bía nɔn wo yi: «Nùpue lée nùpue na wee ɲu le buii na kà ɲumu, wón á le ɲu-hãní pá wé è dàń. ");
INSERT INTO boxNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ɛ̀ɛ ká nùpue na à ɲu mu ɲumu na á ĩ na ɓànso yi, wón á ɲu-hãní máa bĩní máa dàń hùúu. Mu ɲumu na á ĩ na a yi, á à wé lòn ɲun-dã́ní na yí máa fĩ̀ hùúu ɓànso yi, á mu ù na le mukãnì binbirì.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ó o hã́a bía nɔn o Yeesu yi: «Nì-kàránlo, yàá wã́a na bṹn ɲumu so miì, à le ɲu-hãní yí bĩní yí dàń mi, à ĩ wã́a yí bĩní yí ɓuee hà ɲumu hen.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ó o Yeesu bía nɔn o hã́a yi: «Lɛ́n zoo ve mìn báa à mi ɓuee lé.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ó o hã́a bía nɔn wo yi: «Ĩ yí yan.» Ó o Yeesu bía nɔn wo yi: «Ũ tũ̀iá sĩ à ũ bío le fo yí yan. ");
INSERT INTO boxNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bìo fo bía bon. Ɓa báawa na fo yan yú ɓa nùwã hònú, á yìa làa fo páanía wi kà yínɔń mìn báa.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ó o hã́a wã́a bía nɔn o Yeesu yi: «Wàn yàró, ĩ wã́a zũ le ũnɛ́n lé le *Dónbeenì ɲi-cúa fɛɛro ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Warɛ́n wàn ɓùaawa á ɓùaanía le Dónbeenì le ɓúee na kà wán, ká minɛ́n zúifùwa bán wee bío le hen na le Dónbeenì ko le wé ɓùaaní yi á wi ho Zeruzalɛɛmu yi. Á lé mu yɛ́n wã́a bìo bon?» ");
INSERT INTO boxNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ó o Yeesu bía nɔn wo yi: «Hã́a mu, tà bìo á à ĩ bío yi. Pã̀ahṹ ɓúi khíi dã, á le Dónbeenì ɓùaaníló le ɓúee na kà wán lè ho Zeruzalɛɛmu yi á bìo ɲúhṹ máa wé. ");
INSERT INTO boxNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Minɛ́n Samariisa wee ɓùaaní le Dónbeenì ká mi yí zũ le. Warɛ́n zúifùwa bán zũ le Dónbeenì na wa wee ɓùaaní lé bìo le Dónbeenì dĩ̀n warɛ́n wán á wee kã̀nínáa ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ɛ̀ɛ ká pã̀ahṹ ɓúi khíi dã, ho yàá wã́a dɔ̃n vó, á le Dónbeenì ɓùaanílowa binbirì á wé è ɓùaaní a Maá Dónbeenì lè lerɛ́n mí bɛɛre Hácírí pànká, lè ho tũ̀iá poni na le zéenía làa ba. Mu bon, bán ɓùaanílowa so lé bìa ó o Maá sĩi vá yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Le Dónbeenì lé le hácírí, á bìa wee ɓùaaní le ko ɓa ɓùaaní le lè lerɛ́n mí bɛɛre Hácírí pànká, lè ho tũ̀iá poni na le zéenía làa ba.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ó o hã́a bía nɔn o Yeesu yi: «Ĩ zũ mu le *Yìa le Dónbeenì mɔn léra yìa ɓa le *Krista, á wà à ɓuen. Ká a khíi ɓueé dɔ̃n, ó o ɓueé zéeníka mu bìowa ɓúenɓúen yara làa wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ó o Yeesu bía nɔn wo yi: «Ĩnɛ́n na wee bío làa fo kà lé orɛ́n mí bɛɛre.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bṹn pã̀ahṹ ò o Yeesu nì-kenínia bĩnía ɓueé dɔ̃n. Bìo ɓa ɓueé mɔn ò o Yeesu wee bío là a hã́a, á mu wó ɓa coon. Ká ɓarɛ́n ó o ɓúi màhã́ yí tùara a yi le mu wó kaka tàá lée webio nɔn ó o wee bíoráa là a hã́a mu. ");
INSERT INTO boxNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ó o hã́a wã́a día mí ɲumu dɛ̀ɛ bĩ́n, ò o wà zon ho lóhó yi à zoó wee bío lè ɓa nùpua ");
INSERT INTO boxNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","le ɓa ɓuee lée loń o nìi na zũńna bìo á mí wó ɓúenɓúen á bía. Le o màhã́ à wé Yìa le Dónbeenì mɔn léra na ɓa le Krista lée? ");
INSERT INTO boxNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Á ɓa nùpua ló mà a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hón pã̀ahṹ so yi, ó o Yeesu nì-kenínia le o dí. Ɓa wee bío: «Nì-kàránlo, sábéré à ũ dí.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ká a màhã́ bía nɔn ɓa yi: «Ĩ bè-dínii á mi yí zũ sìí.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Á ɓa nì-kenínia wee tùaka mín yi le o ɓúi màhã́ ɓuan bè-dínii ɓueé nɔn wo yi lée. ");
INSERT INTO boxNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ó o Yeesu bía nɔn ɓa yi: «Yìa tonkaa mi sĩi bìo wéró, lè ho tonló na ó o le ĩ sá à síiní ɲii, bṹn lé bìo lé ĩ dĩ́nló. ");
INSERT INTO boxNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Minɛ́n wee wé bío le hen làa pĩina bìo náa ká ho dĩ́nló láró dɔ̃n. Ká ĩnɛ́n ɓɛ̀n wee bío na mia: Mi loń hã manawà sese, ho dĩ́nló bon dĩ̀n á pan mí láró. ");
INSERT INTO boxNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yìa wee lá ho dĩ́nló dɛ̀ɛnía ɓúakáa mí tonló á wee yí mí sàáníi. Ho dĩ́nló na ó o wee lá lé ɓa nùpua na à kɛń le mukãnì binbirì na máa vé yi. Lé kà síi ó o dìro là a láro sĩa wee wé páaní waráa. ");
INSERT INTO boxNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bìo bía kà ɓɛ̀ntĩ́n bon: O dìro wi, á yìa wee lá ho dĩ́nló wi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Àwa, ĩnɛ́n wã́a tonkaa mia ɓa nùpua cɔ̃́n bèra a na à mi yí ɓa ɓuennáa làa bìo ho dĩ́nló lárowà wee láráa ho ho mɔhṹ na á ɓa yí sá yi bìo síi. Nì-vio lé bìa ɓúa ho tonló mu ɲúhṹ, á minɛ́n á à sá à sĩ̀ ɲii.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ho Samariisa na wi ho lóhó mu yi cɛ̀rɛ̀ɛ dó mí sĩa o Yeesu yi, lé bìo ó o hã́a míten bía nɔn ɓa yi le o Yeesu bía bìo mí wó ɓúenɓúen nɔn mí yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lé bṹn nɔn ká ɓa Samariisa ɓueé dɔ̃n, á ɓa yankaa wo le o kɛɛní làa mí. Ó o Yeesu kará bĩ́n hã wizooní bìo ɲun. ");
INSERT INTO boxNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Á bìa dó mí sĩa wo yi wíokaa dó wán hã bíoní na ó orɛ́n mí bɛɛre bía nɔn ɓa yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Á ɓa bía nɔn o hã́a yi: «Bìo kà wán, á wa wã́a dó wa sĩa wo yi lé bìo warɛ́n wa bɛɛre ɲá a ɲi-cúa, ká mu yínɔń bìo fo bía nɔn wɛn mí dòn bìo yi. Wa wã́a zũ le orɛ́n lé ho dĩ́míɲása kã̀nílo.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bìo ó o Yeesu lè mí nì-kenínia wó hã wizooní bìo ɲun ho lahó mu yi, á ɓa ló bĩ́n wà van ho Kalilee kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","O Yeesu míten hĩ́a bía le *Dónbeenì ɲi-cúa fɛɛro máa wé yí le kɔ̃̀nbii mín kùrú kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɛ̀ɛ ká bìo ó o vaá dɔ̃n ho Kalilee, á ho kɔ̃hṹ mu nùpua ɓuan wo se. Lé bìo á bán mún van ho *Paaki sã́nú díró ho Zeruzalɛɛmu yi, á vaá mɔn bìo ɓúenɓúen na ó o wó bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O Yeesu bĩnía van ho Kalilee kɔ̃hṹ lóhó na ɓa le *Kanaa, hen na ó o hĩ́a yèrèmáa mu ɲumu wó lè ho dìvɛ̃́n yi. Ho kɔ̃hṹ mu bɛ́ɛ tonni ya-dí beenì ɓúi wi bĩ́n á za lò yí here wi ho *Kapɛɛnayuumu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bìo ó o tonni ya-dí beenì mu ɲá le o Yeesu ló ho *Zudee kɔ̃hṹ yi á ɓuara ho Kalilee, ó o ló van o cɔ̃́n, á vaá yankaa wo le o ɓuen ho Kapɛɛnayuumu, à ɓuee wɛɛ́ mí za na día mu húmú ɲii wán. ");
INSERT INTO boxNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ó o Yeesu bía nɔn o nìi yi: «Yínɔń mi wé yí mɔn mu yéréké bìowa na wee zéení le Dónbeenì pànká, á mi máa dé mi sĩa miì lon?» ");
INSERT INTO boxNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ó o bɛ́ɛ tonni ya-dí beenì bía nɔn o Yeesu yi: «Nì-kàránlo, sábéré à ũ wa bè mín va hen na á ĩ za wi yi ò o yí hí.» ");
INSERT INTO boxNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ó o Yeesu bía nɔn wo yi: «Lɛ́n va, ũ za á dɛ̀ɛ ɓúi máa wé.» Ó o nìi dó mí sĩi bìo ó o Yeesu bía nɔn wo yi ó o bĩnía wà. ");
INSERT INTO boxNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mu tá na lée tɔ̃n, ó o ton-sáwá ló ɓueé sã́ a yahó, á bía nɔn wo yi le o za wã́a wan. ");
INSERT INTO boxNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ó o tùara ho pã̀ahṹ na ó o za mu bìo díká dó yi làa ba. Á ɓa bía nɔn wo yi le mu wó ho hĩihṹ ká le wii dá yɛɛnía. Lé hón pã̀ahṹ so á le tɛ̀ɛnì ɓúakáa ló a sãnía yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ó o za ɓàn maá wã́a zũna le mu wó ho pɔ̃̀n-kéní na ó o Yeesu bía nɔn wo yi le o za á dɛ̀ɛ ɓúi máa wé. Ó orɛ́n lè mí zĩi nùpua ɓúenɓúen dó mí sĩa o Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bṹn lé bìo wó a Yeesu cúa-ɲun níi yéréké bìo na wee zéení le o ló le Dónbeenì cɔ̃́n na ó o bĩnía ɓueé wó ho Kalilee kɔ̃hṹ yi, ká a ló ho Zudee kɔ̃hṹ yi ɓuara bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wizooní bìo yɛn bṹn mɔ́n, à bṹn ɓa *zúifùwa sã́nú ɓúi díró dɔ̃n, ó o Yeesu wà yòora ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ho lóhó mu yi á súeeníi la-beenì ɓúi wi yi á ɓa wee ve lè mu heberemu le Bɛtezadaa. Le ɓó ho zũaɲii na ɓa wee ve làa Pia Zũaɲii. Hã sànsáwá bìo hònú son kĩ́nía le súeeníi la-beenì mu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lé hɔ̃́n tá á ɓa vánvárowà cɛ̀rɛ̀ɛ hĩ́a wee wé da yi. Ɓa vánvárowà mu tĩ́ahṹ á ɓa muiiwà, lè ɓa lóní, lè ɓa mùamúawà wi yi. Ɓa hĩ́a wee da bĩ́n à pa bìo mu ɲumu hĩ́a à bùcán. ");
INSERT INTO boxNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Lé bìo á pɔ̃̀nna ɓúi, à le Dónbeenì wáayi tonkaro ɓuee bùcán mu. Ká a vánváro na zon mu yi ho yahó, hàrí mu wé vã́mú lée vã́mú tò à o ò pá wa. ");
INSERT INTO boxNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vánváro ɓúi hĩ́a wi bĩ́n á vã́mú míana a wán yú hã lúlúio ɓóní làa pírú làa bìo hètĩn. ");
INSERT INTO boxNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bìo ó o Yeesu mɔn wo ò o dũma, ó o zũ le o lò yí here míana, ó o tùara a yi: «Fo wi à ũ wa le?» ");
INSERT INTO boxNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ó o nìi bía nɔn wo yi: «Nì-kàránlo, nùpue na à lá mi lií dé mu ɲumu yi mu bùcánló pã̀ahṹ á mía. Hen ká ĩ dã̀mákaa le ĩ lií zo, bṹn ká a ɓúi zon vó.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ó o Yeesu bía nɔn wo yi: «Lii hĩ́ní, lá ũ dãmu dɛ̀ɛ à ũ varáka.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mí lahó yi ó o nìi mu dɛ̀ɛnía wan, á lá mí dãmu dɛ̀ɛ ò o wee varáka. Ɛ̀ɛ ká bìo mu wó ɓa *zúifùwa vũńló wizonle na ɓa le *Sabaa zoǹ, ");
INSERT INTO boxNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","á ɓa zúifùwa ɲúnása wee bío là a nìi na wan: «Wa làndá yi, á fo yí ko à ũ lá ũ dãmu dɛ̀ɛ ɓua, lé bìo ho Sabaa lé ho zuia.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ó o nìi bía nɔn ɓa yi: «Yìa wɛɛ́ra mi lé yìa bía nɔn miì le ĩ lá ĩ dãmu dɛ̀ɛ à ĩ varáka.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Á ɓa wã́a tùara a yi: «Yìa le ũ lá ũ dãmu dɛ̀ɛ ũ varáka lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ká a nìi màhã́ yí zũ yìa wɛɛ́ra a, lé bìo ó o Yeesu vṹnun ɓa nùpua na wee ɲàa mín bĩ́n tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bṹn mɔ́n, ó o Yeesu vaá fò mín là a nìi mu le *Dónbeenì zĩ-beenì lún yi, ó o bía nɔn wo yi: «Loń lon. Bìo kà wán, á fo wã́a wan. Àwa. Ká fo yí wi à mu ɓúi na po bìo yú fo khĩína à bĩní yí fo, à ũ yí bĩní yí wé bè-kohó.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ó o nìi wà vaá bía nɔn ɓa zúifùwa ɲúnása yi le lé o Yeesu wɛɛ́ra mí. ");
INSERT INTO boxNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lé bṹn nɔn á ɓa zúifùwa ɲúnása và bòráa o Yeesu yi wee sɛɛ́, bìo ó o wɛɛ́ra a nùpue ho Sabaa zoǹ bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ká a Yeesu màhã́ bía nɔn ɓa yi: «Ĩ Maá Dónbeenì wee sá fɛ́ɛɛ, á ĩnɛ́n mún wee sá.» ");
INSERT INTO boxNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dén bíonì so na ó o Yeesu bía bìo yi, á ɓa zúifùwa ɲúnása wíokaa sòobáa míten o ɓúeró bìo yi. Lé bìo á mu yínɔń bìo ó o wó khon ho Sabaa bìo yi mí dòn, ká lé bìo ó o le le Dónbeenì lé mín kùrú Maá. Bṹn wee zéení le o mànía míten lè le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","O Yeesu wíokaa lá le bíonì ò o bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: O Za yí máa wé bìo ɓúi míten. Bìo á ɓàn Maá Dónbeenì wee wé ò o mi, bṹn lé bìo ó o wee wé. Bìo á ɓàn Maá wee wé ɓúenɓúen ó o mún wee wé. ");
INSERT INTO boxNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mu bon, o Maá wa a Za, á bìo ó orɛ́n mí bɛɛre wee wé ó o wee zéení làa wo. O pá à bĩní ì zéení a lè mu bè-beera na po bìo mi mɔn á ɓueé ɓó ho zuia yi, ó o ò wé, á mu ù wé mia coon. ");
INSERT INTO boxNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Làa bìo síi ó o Maá wee vèenínáa ɓa nì-hía à na le mukãnì binbirì ɓa yi, lé làa bṹn síi ó o Za mún wee nanáa le mukãnì binbirì bìa ó o wi ò o na le yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","O Maá mún yí máa cítí nùpue, ká a màhã́ nɔn le cítíi fĩ̀ló pànká ɓúenɓúen o Za yi, ");
INSERT INTO boxNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","bèra a na à ɓa nùpua ɓúenɓúen wé kɔ̃̀nbi o Za, làa bìo ɓa wee kɔ̃̀nbiráa o Maá. Yìa yí máa kɔ̃̀nbi o Za, se ɓànso mún yí máa kɔ̃̀nbi o Maá na tonkaa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Le ĩ mì ho tũ̀iá na mia: Yìa wee tà ɲí ĩ bíoní, á dó mí sĩi ĩ Maá na tonkaa mi yi, wón ɓànso yú le mukãnì binbirì na máa vé hã laà na kà wán. Ɓànso á ĩ máa cítí. O dɛ̀ɛnía ló mu húmú yi, á yú le mukãnì binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Le ĩ mì ho tũ̀iá na mia: Ho pã̀ahṹ ɓúi khíi dã, ho yàá wã́a dɔ̃n vó, á bìa yí yú le mukãnì binbirì, na ka lòn nì-hía á à ɲí le Dónbeenì Za tãmu. Bìa á à ɲí mu, bán á à yí le mukãnì binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mu bon, làa bìo ó o Maá á le mukãnì binbirì wee lé cɔ̃́n, lé làa bṹn síi ó o wó ó o Za á le mukãnì binbirì mún wee lé cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O nɔn ho pànká wo yi ò o fĩ̀náa le cítíi, lé bìo ó o lé o *Nùpue Za. ");
INSERT INTO boxNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Mi yí le bìo bía kà wé mia coon, lé bìo á pã̀ahṹ ɓúi khíi dã, ká ɓa nì-hía ɓúenɓúen á à ɲí a Nùpue Za tãmu, ");
INSERT INTO boxNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","á ɓa à vèe. Á bìa wó mu bè-tentewà á à yí le mukãnì binbirì na máa vé. Ká bìa wó mu bè-kora bán ɲúná à sí. ");
INSERT INTO boxNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ĩnɛ́n yí dà dɛ̀ɛ máa wé ĩten. Ĩ wee wé fĩ̀ le cítíi à héha lè ĩ Maá ɲi-cúa na ó o mà nɔn miì. Á ĩ cítíi fĩ̀ló mún térénna, lé bìo á ĩ yí máa fĩ̀ le làa bìo á ĩ sĩi vá yi. Ĩ wee fĩ̀ le làa bìo ó o Maá na tonkaa mi sĩi vá yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Mu lá lé ĩnɛ́n ĩ dòn á wee mì ho tũ̀iá ĩ ɲii, á mi lá dà a pĩ́ ĩ tũ̀iá. ");
INSERT INTO boxNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɛ̀ɛ ká nì-veere lé ĩ sɛɛ́rà, á ĩ zũ le ho tũ̀iá na ó o wee mì ĩ ɲii á bon. ");
INSERT INTO boxNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Minɛ́n lé bìa tonkaa ɓa nùpua á ɓa van o Zãn Batiisi cɔ̃́n, á wón vaá mà ho tũ̀iá ĩ ɲii á nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ĩnɛ́n wón màkóo mía à nùpue wé ĩ bìo sɛɛ́ràso. Ká ĩ màhã́ bía mu bèra a na à mi dàń kã̀ní. ");
INSERT INTO boxNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","«Bìo ó o Zãn hĩ́a wee bío ka lòn fĩ̀ntã́ní na khoomu yenkeen, á mi tà zã̀makaa mu khoomu mu bìo yi ho pɔ̃̀n-za dɛ̀ɛ yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bìo ɓúi wi bĩ́n á wee zéení bìo á ĩ bìo karáa. Bṹn po ho tũ̀iá na ó o Zãn mà ĩ ɲii. Mu bìo mu lé mu bè-wénia na á ĩ Maá le ĩ wé, bìo á ĩ wee wé kà, lé bṹn wee zéení le lé ĩ Maá tonkaa mi bìo bon. ");
INSERT INTO boxNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Á ĩ Maá na tonkaa mi wón mí bɛɛre mún wee mì ho tũ̀iá ĩ ɲii. Mi yí ɲá a bíonì, á mi mún yí zũ a. ");
INSERT INTO boxNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mi yí tà a bíoní yi binbirì, lé bìo mi yí tà yìa ó o tonkaa bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mi wee kàrán le Dónbeenì bíonì à cikon, lé bìo mi wee leéka le lé lerɛ́n wee na à mi zũń bìo mi ì wé á à yíráa le mukãnì binbirì na máa vé. Àwa, lé dén bíonì so lé dìo wee zéení bìo á ĩ bìo karáa wéréwéré, ");
INSERT INTO boxNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","à mi màhã́ pá yí wi à mi ɓuen ĩ cɔ̃́n à yíráa le mukãnì binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ĩnɛ́n màkóo mía à ɓa nùpua khòoní mi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ɛ̀ɛ ká minɛ́n bán á ĩ zũ bìo mi karáa. Le Dónbeenì mi yí wa. ");
INSERT INTO boxNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ĩ Maá lé yìa á ĩ ɓuara yèni yi, á mi pã́ ĩ bìo. Ká a ɓúi màhã́ lá ɓuara mí kùrú yèni yi, á mi ì tà wón bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Minɛ́n na wi mi wé khòoní mín, à mi yí wi à mi cà à dìo lé le Dónbeenì mí dòn à khòoní mia, á à wé kaka à déráa mi sĩa ĩnɛ́n yi? ");
INSERT INTO boxNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mi yí leéka le lé ĩnɛ́n khíi kooní mia le Dónbeenì yahó dɛ́. Ɓùeé. O *Mɔyiize na mi wee lòoní le o ò séení mia lé wón wee kooní mia le Dónbeenì yahó. ");
INSERT INTO boxNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","O Mɔyiize bìo mi lá tà kɛ̃́nkɛ̃́n, se ĩnɛ́n á mi mún lá à tà bìo, lé bìo á ĩnɛ́n lé yìa ó o Mɔyiize bía bìo mí vɔ̃nna yi. ");
INSERT INTO boxNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɛ̀ɛ ká bìo ó o túara ĩ dã́ní yi á mi yí tà yi, á mi mún yí dà máa tà ĩnɛ́n bíoní yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bṹn mɔ́n ó o Yeesu lè mí nì-kenínia zon ho woohṹ á khú ho Kalilee vũ-beenì mɔ́n, hìa ɓa mún wee ve làa Tiberiade vũ-beenì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Á ɓa minka zã̀amáa bò a yi, lé bìo ɓa vánvárowà na ó o wee wɛɛ́ à ɓa mi á bìo wee wé ho yéréké. ");
INSERT INTO boxNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ó o Yeesu wà vaá yòora le ɓúee ɓúi, á yòó kará bĩ́n lè mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mu wee wé, à ɓa *zúifùwa sã́nú na ɓa le *Paaki díró sùaráa. ");
INSERT INTO boxNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ó o Yeesu le mí ì loń, à ɓa minka zã̀amáa wee ɓuen wo yi, ó o tùara a Filiipu yi: «Lé wen á wa à yí mu bè-dínii yi á à na ɓa minka nùpua na kà ɓúenɓúen yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O Yeesu tùara a Filiipu yi kà, lé bìo ó o wi ò o khɛ́n o kúará, ká arɛ́n wón zũ bìo ó o ò wé. ");
INSERT INTO boxNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ó o Filiipu bía nɔn o Yeesu yi: «Hàrí wa lá yí le wɛ́n-hãani khĩá-ɲun à vaa yà lè ho búurú ɓuee cɛ̀ɛka wĩ́níwĩ́ní, á ɓa ɓúenɓúen pá máa yí.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ó o nì-kenínia nì-kéní, o Simɔn Piɛre ɓàn za Ãndere á bía nɔn o Yeesu yi: ");
INSERT INTO boxNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Yàrónza ɓúi wi hen á ɓa cezàwa bùaa ɲun, lè ho búurú bi-zàwa bìo hònú na wó lè mu bìo ɓúi na ɓa le ooze dũmu á wi cɔ̃́n. Ká lée webio á bṹn ǹ wé lè ɓa minka zã̀amáa na kà?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ó o Yeesu wã́a bía: «Mi bío le ɓa ɓúenɓúen lii kɛɛní.» Le ɲíní sà le lùe mu yi boo, á lé dén ɓa wã́a lií kará wán. Ɓa báawa mí dòn á à yí muaaseé hònú síi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ó o Yeesu fó ho búurú bi-zàwa, á dó le Dónbeenì bárákà, ò o nɔn ho le ɓa sanka na bìa kará bĩ́n ɓúenɓúen yi. Lé bṹn ɓàn síi ó o mún wó lè ɓa cezàwa, á ɓa ɓúenɓúen dú làa bìo ɓa sĩa vá yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bìo ɓa ɓúenɓúen dú sù, ó o Yeesu bía nɔn mí nì-kenínia yi: «Mi yí día le bìo dú ká à yáa. Mi khuii mu ɓúenɓúen.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Á ɓa khuiira mu, á ho ooze búurú bi-zàwa bìo hònú bìo na là ká á sú hã sàkíwá pírú ɲun. ");
INSERT INTO boxNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bìo ɓa nùpua mɔn mu yéréké bìo na ò o wó, á ɓa bía: «O nìi na kà ɓɛ̀ntĩ́n lé le *Dónbeenì ɲi-cúa fɛɛro, yìa lá ko ò o ɓuen ho dĩ́míɲá yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bìo ó o Yeesu zũna le ɓa nùpua ɓueé fé mí á à wé lè mí bɛ́ɛ lè ho pànká, ó o tĩ́n wà yòora le ɓúee wán mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ho zĩihṹ, ó o Yeesu nì-kenínia wà lion ho vũ-beenì ɲii, ");
INSERT INTO boxNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","á lií zon ho woohṹ wee khí lè ho *Kapɛɛnayuumu lóhó cɔ̃́n. Ho tá hũn ká a Yeesu dĩǹ yí ɓueé dɔ̃n ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ho pinpiró wee và lè mí pànká, á ho vũ-beenì ɲumu wee yànbónka. ");
INSERT INTO boxNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bìo ɓa vá zon á à yí lòn kilomɛɛterewa bìo hònú tàá bìo hèzĩ̀n síi lè le ɓónɓóore, á ɓa mɔn o Yeesu ò o wee varáka mu ɲumu wán wà ɓueé sùará ɓa yi, á ɓa zã́na. ");
INSERT INTO boxNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ó o Yeesu bía nɔn ɓa yi: «Mu lé ĩnɛ́n, mi yí zɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Á ɓa wã́a wi ɓa bío le o Yeesu yòo zo ho woohṹ yi, à bṹn ɓa dɛ̀ɛnía dɔ̃n hen na ɓa wee va yi vó. ");
INSERT INTO boxNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mu tá na lée tɔ̃n, á ɓa zã̀amáa na khíi wi lè ho vũ-beenì mɔ́n á zũna le lée woohṹ dà-kéní mí dòn lá wi bĩ́n. Ɓa zũna le o Yeesu yí zon ho woohṹ lè mí nì-kenínia, ká lé ɓarɛ́n wà mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɛ̀ɛ ká wonna ɓúi ló ho Tiberiade lóhó yi ɓueé dɔ̃n ho lahó na ó o Yeesu dó le Dónbeenì bárákà ò o nɔn ho búurú ɓa là yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bìo ɓa zã̀amáa mɔn ò o Yeesu mía bĩ́n, ó o nì-kenínia mún mía bĩ́n, á ɓa yòó zon hɔ̃́n wonna so yi ɲɔn ho *Kapɛɛnayuumu lóhó, á wà khíi cà a. ");
INSERT INTO boxNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bìo ɓa bĩnía khíi yú a Yeesu ho vũ-beenì mɔ́n, á ɓa wee tùa wo yi: «Nì-kàránlo, fo ɓuara hen dĩà?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Mi wee cà mi yínɔń bìo mi zũna mu yéréké bìo na á ĩ wó ɓàn kúará, ká lé bìo mi yú ho búurú á là sù bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mi wé yí sá ho dĩ́nló na dà wee yáa bìo yi, ká mi wé sá hìa yí máa yáa bìo yi, hón na wee na le mukãnì binbirì na máa vé. Hón dĩ́nló so lé o Nùpue Za á à na ho mia, lé bìo ó orɛ́n lé yìa ó o Maá Dónbeenì zéenía bìo le mí nɔn mu bìo ɓúenɓúen wéró pànká yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Á ɓa tùara a yi: «Lé ho tonló yɛ́n á le Dónbeenì wi à wa sá?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ó o Yeesu bía nɔn ɓa yi: «Bìo le Dónbeenì le mi wé, lé à mi dé mi sĩa yìa le tonkaa yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bìo ó o bía kà síi, á ɓa bía nɔn wo yi: «Ũnɛ́n ɓɛ̀n lé mu yéréké bìo yɛ́n fo dà à wé á wa à mi á à déráa wa sĩa foǹ? Wé mu ɓúi le wa mi! ");
INSERT INTO boxNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pã̀ahṹ na á wàn ɓùaawa hĩ́a wi ho tá henì yi, á ɓa yú ho *maanɛ á là, làa bìo mu túararáa le Dónbeenì bíonì vũahṹ yi: ‹O hĩ́a nɔn ho dĩ́nló na ló ho wáayi ɓa yi á ɓa dú.›» ");
INSERT INTO boxNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ó o Yeesu ɓɛ̀n bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Mu yínɔń o *Mɔyiize lé yìa hĩ́a nɔn ho búurú na ló ho wáayi mia. Lé ĩ Maá Dónbeenì nɔn ho mia. Lé orɛ́n mún wee na ho dĩ́nló binbirì na ló ho wáayi mia. ");
INSERT INTO boxNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mu bon, ho dĩ́nló binbirì na le Dónbeenì wee na lé yìa ló ho wáayi lion. Lé orɛ́n wee na le mukãnì binbirì ho dĩ́míɲása yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Á ɓa bía nɔn wo yi: «Nì-kàránlo, wé na hón dĩ́nló so wɛn fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ó o Yeesu wã́a bía nɔn ɓa yi: «Ĩnɛ́n lé yìa lé ho dĩ́nló na wee na le mukãnì binbirì. Yìa bò miì á dó mí sĩi miì, á hĩni làa ɲu-hãní máa ɓúe ɓànso hùúu. ");
INSERT INTO boxNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ĩ bía mu nɔn mia le mi mɔn bìo á ĩ wó, à mi ɲɔǹ pá yí dó mi sĩa miì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bìa á ĩ Maá wee wé à ɓa bìo sĩ̀ miì le mí nì-kéní kéní wé è bè miì. Yìa bò miì, á ĩ máa bío le o bĩní hùúu. ");
INSERT INTO boxNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Lé bìo á ĩ yí ló ho wáayi yí wà ɓueé wé ĩ sĩi bìo. Yìa tonkaa mi lé wón sĩi bìo á ĩ wà ɓueé wé. ");
INSERT INTO boxNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yìa tonkaa mi sĩi bìo lé à ĩ yí vĩ́iní bìa ó o kàràfáa miì nì-kéní ɓúi, ká ĩ vèení ɓa ho dĩ́míɲá vé nɔ̀nzoǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mu bon, ĩ Maá sĩi bìo lé à bìa ɓúenɓúen na fá mí yìo o Za yi á dó mí sĩa wo yi, à yí le mukãnì binbirì na máa vé, à ĩ vèení ɓa ho dĩ́míɲá vé nɔ̀nzoǹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Á ɓa *zúifùwa wã́a wee khí mí kío yi, lé bìo ó o bía le mínɛ́n lé ho dĩ́nló binbirì na ló ho wáayi lion. ");
INSERT INTO boxNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Á ɓa bía: «Yínɔń orɛ́n lé o Zozɛɛfu za Yeesu le? Wa zũ ɓàn maá lè ɓàn nu. Ó o wã́a à wé kaka á à bíoráa le mí ló ho wáayi lion?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ó o Yeesu bía nɔn ɓa yi: «Mi yí khí mi kío yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nùpue woon yí dà máa bè miì, ká a Maá na tonkaa mi yí ɓuan wo yí ɓuararáa, á ĩnɛ́n á à vèení ɓànso ho dĩ́míɲá vé nɔ̀nzoǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bìo kà lé bìo túara le Dónbeenì ɲi-cúa fɛɛrowà vɔ̃nna yi: ‹Le Dónbeenì khíi kàrán ɓa ɓúenɓúen.› Nùpue lée nùpue na wee ɲí a Maá Dónbeenì tãmu, á wee día míten ò o kàrán, wón á à bè miì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bṹn yí máa zéení le ĩ le nùpue ɓúi mɔn o Maá. Yìa ló le Dónbeenì cɔ̃́n ɓuara, lé wón mí dòn mɔn wo. ");
INSERT INTO boxNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Le ĩ mì ho tũ̀iá na mia: Yìa dó mí sĩi wo yi, wón yú le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ĩnɛ́n lé ho dĩ́nló na wee na le mukãnì binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mìn ɓùaawa là ho *maanɛ ho tá henì yi, ɛ̀ɛ ká bṹn màhã́ yí hò ɓa húmú. ");
INSERT INTO boxNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ká ĩnɛ́n lé ho dĩ́nló binbirì na ló ho wáayi lion. Yìa dú ho, á ɓànso ò yí le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ĩnɛ́n lé ho dĩ́nló na wee na le mukãnì binbirì, hìa ló ho wáayi lion. Yìa dú ho, á ɓànso á à yí le mukãnì binbirì na máa vé. Ho dĩ́nló na á ĩ ì na bèra a na à ho dĩ́míɲása yí le mukãnì binbirì, lé ĩ sãnía.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bìo ɓa *zúifùwa ɲá hã bíoní mu, á ɓa wee kán mín lè mí sòobɛ́ɛ. Ɓa wee bío: «O nìi mu dà a wé kaka a nanáa mí sãnía wɛn á wa a là?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Hen ká mi yí là a Nùpue Za sãnía, á yí ɲun o cãni, á le mukãnì binbirì máa kɛń mia. ");
INSERT INTO boxNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yìa là ĩ sãnía, á ɲun ĩ cãni, wón ɓànso yú le mukãnì binbirì na máa vé. Ĩ ì vèení ɓànso ho dĩ́míɲá vé nɔ̀nzoǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mu bon, ĩnɛ́n sãnía lé ho dĩ́nló binbirì, á ĩ cãni lé mu bè-ɲunii binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yìa là ĩ sãnía á ɲun ĩ cãni, se wón páanía làa mi á ĩnɛ́n páanía làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","O Maá na tonkaa mi lé wón mí bɛɛre wee na le mukãnì binbirì. Á lé orɛ́n pànká yi á le mukãnì binbirì mún wiráa ĩnɛ́n yi. Lé làa bṹn síi, á yìa là ĩ sãnía, á ɓànso mún ǹ yí le mukãnì binbirì ĩnɛ́n pànká yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ĩnɛ́n lé ho dĩ́nló na ló ho wáayi lion, hón yí ka làa hìa á mìn ɓùaawa yánkaa dú bìo síi. Bán dú hón à ɓa pá húrun. Ɛ̀ɛ ká yìa dú ho dĩ́nló na ló ho wáayi lion, á ɓànso á à yí le mukãnì binbirì na máa vé.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","O Yeesu bía hã bíoní na kà, ká a wee kàrán ɓa nùpua ɓa zúifùwa kàránló zĩi ho *Kapɛɛnayuumu lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bìo á bìa bò a yi ɲá a bíoní, á ɓa cɛ̀rɛ̀ɛ bía: «O nìi mu bíoní ɓɛ̀ntĩ́n hereka. Nùpue na dà à tà hã yi á mía.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ó o Yeesu zũna le bìa bò a yi wee khí mí kío yi bìo ó o bía bìo yi, ó o bía: «Hã bíoní mu ɓóonía mia lée? ");
INSERT INTO boxNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɛ̀ɛ ká mi ɓɛ̀n wã́a khíi mɔn o *Nùpue Za ká a bĩnía wee yòo hen na ó o ló yi ɓuara hã́? ");
INSERT INTO boxNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Le Dónbeenì Hácírí lé dìo wee na le mukãnì binbirì. O nùpue míten yí dà dɛ̀ɛ máa wé. Hã bíoní mu na á ĩ bía nɔn mia kà lé le Dónbeenì Hácírí á hã ló cɔ̃́n. Hã wee na le mukãnì binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ɛ̀ɛ ká ɓa nùwã yɛn ɓúi mi tĩ́ahṹ á yí dó mí sĩa miì.» À mu ɓɛ̀n bon, mu ɲúhṹ ɓúɛɛníi á bìa yí dó mí sĩa o Yeesu yi ó o zũna bìo, á mún zũna yìa á à dé o ò na bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ó o Yeesu pá bĩnía bía kà síi: «Lé bṹn te bìo á ĩ bía mu nɔn mia le nùpue yí dà máa bè miì, ká a Maá Dónbeenì yí nɔn mu wéró pànká ɓànso yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","À wã́a lá bṹn ɲii wán, á bìa bò a yi cɛ̀rɛ̀ɛ bĩnía o mɔ́n, á yí máa bè làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ó o wã́a tùara mí nì-kenínia pírú ɲun yi: «Minɛ́n mún máa bĩní le?» ");
INSERT INTO boxNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ó o Simɔn Piɛre bía nɔn wo yi: «Ɲúhṹso, lé o yɛ́n á wa à bĩní vaá bè yi? Ũnɛ́n lé yìa le mukãnì binbirì na máa vé bíoní wee lé cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Warɛ́n dó wa sĩa foǹ, á zũ le ũnɛ́n lé yìa lé le Dónbeenì nùpue yi poni ɓànso na le tonkaa.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ó o Yeesu bía nɔn ɓa yi: «Mu so yínɔń ĩnɛ́n hueekaa minɛ́n pírú ɲun le? Ɛ̀ɛ ká mi nì-kéní ɓúi màhã́ pá lé o *Satãni nùpue.» ");
INSERT INTO boxNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mu lé o Simɔn Isikariote za Zudaa ó o wee bío bìo. Mu bon, ɓa pírú ɲun mu tĩ́ahṹ ó orɛ́n lé yìa à dé o ò na. ");
INSERT INTO boxNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bṹn mɔ́n, ó o Yeesu tò ho Kalilee kɔ̃hṹ yi. O yí wi ò o zoo tè ho *Zudee kɔ̃hṹ yi, lé bìo ɓa *zúifùwa ɲúnása wi ɓa ɓúe o. ");
INSERT INTO boxNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bìo ɓa zúifùwa sã́nú na ɓa le *Bùkúwá Sã́nú díró wà ɓueé sùará, ");
INSERT INTO boxNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ó o Yeesu ɓàn zàwa bía nɔn wo yi: «Fo lá ko à ũ lé hen à lɛ́n va ho Zudee kɔ̃hṹ yi, à bìa bò foǹ bĩ́n mún mi mu bè-wénia na fo wee wé. ");
INSERT INTO boxNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nùpue na wi ɓa zũń wo, wón bè-wénia máa wé sànka wé. Mu bè-beera na fo wee wé, á fo ko à ũ wé à ɓa nùpua ɓúenɓúen mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mu bon, o Yeesu ɓàn zàwa mí bɛɛre yí dó mí sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ó o Yeesu bía nɔn ɓa yi: «Ĩnɛ́n á ho pã̀ahṹ dĩǹ yí dɔ̃n cɔ̃́n, ká minɛ́n bán á ho pã̀ahṹ wi cɔ̃́n wà fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ho dĩ́míɲá nùpua yí dà máa ɲin mia, ká ĩnɛ́n wón ɓa ɲina, lé bìo á ĩ wee mì ho tũ̀iá le ɓa wárá yí seka. ");
INSERT INTO boxNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Minɛ́n lɛ́n va ho sã́nú díiníi. Ĩnɛ́n wón máa va, lé bìo ho pã̀ahṹ dĩǹ yí dɔ̃n ĩ cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","O Yeesu bía hɔ̃́n bíoní so nɔn ɓa yi ò o kará ho Kalilee kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bìo ó o Yeesu ɓàn zàwa wà van ho sã́nú díiníi, ó orɛ́n mún wà van. Ká a màhã́ sànkaa míten vannáa, ò o bìo yí zũń. ");
INSERT INTO boxNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ɓa *zúifùwa ɲúnása wee cà a ho sã́nú mu díiníi. Ɓa wee hɛ́ɛ tùaka hen na ó o Yeesu mu wi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","O Yeesu bìo wó le wã̀aníi làa sòobɛ́ɛ ɓa zã̀amáa tĩ́ahṹ. Ɓa ɓúi wee bío le o nìi mu lée nì-tente. Ɓa ɓúi ɓɛ̀n le o wee vĩ́iní ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ká nùpue na màhã́ à hení mí sĩi á à bío mu wéréwéré ɓa nùpua yahó wón mía, lé bìo ɓa zã́na ɓa zúifùwa ɲúnása. ");
INSERT INTO boxNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ho sã́nú dú zon ho tĩ́ahṹ lòn wizooní bìo náa síi ó o Yeesu zonnáa le *Dónbeenì zĩ-beenì lún yi, á zoó wee kàrán ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɓa zúifùwa wee wé coon o bìo yi, á ɓa wee bío: «O nìi mu kàránló ɲɔǹ yí van yahó ò o pá zũ le Dónbeenì bíonì vũahṹ bìo kà síi le we?» ");
INSERT INTO boxNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ó o Yeesu bía nɔn ɓa yi: «Bìo á ĩ wee kàrán làa mia á yí ló ĩnɛ́n ĩ bɛɛre cɔ̃́n. Yìa tonkaa mi lé yìa mu ló cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yìa tà wee wé le Dónbeenì sĩi bìo, wón ɓànso á à zũń ká ĩ kàránló ló le Dónbeenì cɔ̃́n, tàá ká ĩ wee bío ĩ kùrú bíoní. ");
INSERT INTO boxNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yìa wee bío mí kùrú bíoní, wón wee cà le yèni. Ká yìa wee cà le yèni à na yìa tonkaa wo yi, wón wee mì ho tũ̀iá, o térénna. ");
INSERT INTO boxNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","O *Mɔyiize so yí nɔn ho làndá mia le? À yìa màhã́ wee bè ho yi mi tĩ́ahṹ wón mía. Lée webio nɔn mi wi mi ɓúeráa mi?» ");
INSERT INTO boxNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Á ɓa zã̀amáa bía nɔn wo yi: «O cĩ́ná wi foǹ! Yìa wi ò o ɓúe fo lé o yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ó o Yeesu bĩnía lá le bíonì ò o bía nɔn ɓa yi: «Ĩ wó mu yéréké bìo dà-kéní mí dòn wa vũńló wizonle na lé ho *Sabaa zoǹ, á mi ɓúenɓúen wó coon mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O Mɔyiize bò mu henía nɔn mia le mi wé *kúio mi zà-báawa, á mi yàá wee kúio ɓa hàrí ho Sabaa zoǹ. Ho làndá mu yàá yínɔń Mɔyiize ɓúa ho ɲúhṹ, mu lé mìn ɓùaawa. ");
INSERT INTO boxNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Àwa, ká minɛ́n dà wee kúii o za báa ho Sabaa zoǹ, bèra a na à mi yí wé yí khe o Mɔyiize làndá dã́ní yi, á lée webio nɔn á mi sĩa wee cĩ̀náa miì, lé bìo á ĩ wó ó o nì-kùure wan cun ho Sabaa zoǹ? ");
INSERT INTO boxNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bìo mi wee mi à dĩ̀n wán cítíráa o nùpue à mi khí yi. Mi wé cítí o nùpue làa bìo térénna le Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Á ho Zeruzalɛɛmusa ɓúi wã́a wee bío: «Éee! Yìa kà so yínɔń o nìi na á wa ɲúnása wi ɓa ɓúe le? ");
INSERT INTO boxNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nín-yìa wee bío ɓa nùpua yahó, ò o ɓúi yí dó mí ɲii wo yi. Wa ɲúnása màhã́ wã́a zũna le lé orɛ́n lé yìa le Dónbeenì mɔn léra lée? ");
INSERT INTO boxNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yìa kà wón á warɛ́n zũ léeníi. Ɛ̀ɛ ká yìa le Dónbeenì mɔn léra khíi ɓuara, á nùpue woon máa zũń hen na ó o ló yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bìo ó o Yeesu wee kàrán ɓa nùpua le *Dónbeenì zĩ-beenì lún yi, ó o bía bìo kà pɔ̃́npɔ̃́n: «Mi so zũ mi kɛ̃́nkɛ̃́n, á zũ ĩ léeníi le? Ĩnɛ́n yí ɓuara ĩten, ká ho tũ̀iá poni ɓànso lé yìa tonkaa mi. Mi yí zũ a, ");
INSERT INTO boxNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ká ĩnɛ́n wón zũ a, lé bìo á mu lé orɛ́n á ĩ ló cɔ̃́n ɓuararáa. Orɛ́n lé yìa tonkaa mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Á ɓa wã́a wee cà a wìiró yahó, ká nùpue woon yí wìira a, lé bìo ó o pã̀ahṹ dĩǹ yí dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɛ̀ɛ ká ɓa zã̀amáa mu tĩ́ahṹ, á ɓa cɛ̀rɛ̀ɛ ɲɔǹ pá tà a bìo. Ɓa wee bío: «*Yìa le Dónbeenì mɔn léra khíi ɓuara, ó o so ɓueé wé yéréké bìowa na po bìo ó o nìi na kà wee wé le?» ");
INSERT INTO boxNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Á ɓa *Farizĩɛwa ɓúi ɲá bìo ɓa zã̀amáa wee hũ̀ahṹaaka a Yeesu dã́ní yi, á ɓa Farizĩɛwa mu kuure lè le *Dónbeenì yankarowà ɲúnása tonkaa ɓa parowà ɓúi le ɓa vaa wìi wo. ");
INSERT INTO boxNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ó o Yeesu bía: «Ĩ kɛńló mi tĩ́ahṹ máa wé bìo na á à mía. Hen làa cĩ́inú ká ĩ ì bĩní ì va yìa tonkaa mi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mi khíi wé è cà mi, ká mi máa yí mi, á hen na á ĩ ì kɛń yi á mi mún yí dà máa va yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Á ɓa *zúifùwa wee tùaka mín yi le lé wen o ò va ká mí máa yí o coon? Lé ɓa zúifùwa na hɛ́ɛra wika bìa yínɔń ɓa zúifùwa tĩ́ahṹ ó o màhã́ wi ò o lɛ́n va cɔ̃́n lée? O màhã́ wi o ò vaa kàrán bìa yínɔń ɓa zúifùwa lée? ");
INSERT INTO boxNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Bìo ó o bía le wa khíi wé è cà mí ká wa máa yí mí, á hen na mí ì kɛń yi á wa yí dà máa va yi, bṹn kúará lée webio? ");
INSERT INTO boxNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ho sã́nú dí vé nɔ̀nzoǹ dén wizonle so lé dìo ɲúhṹ wi po hĩ̀a ká. Bṹn zoǹ ó o Yeesu dĩ̀n ɓa zã̀amáa yahó ò o bía pɔ̃́npɔ̃́n: «Hen ká yìa le ɲu-hãní dà, à ɓànso ɓuen ĩ cɔ̃́n á ĩ ì na mu ɲumu wo yi ó o ò ɲu. ");
INSERT INTO boxNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yìa dó mí sĩi miì, làa bìo mu túararáa le Dónbeenì bíonì vũahṹ yi kà síi: ‹Á wón ɓànso sĩi á à wé lòn ɲun-dã́ní, á mu ɲumu na wee na le mukãnì wé è tá á à lé yi.›» ");
INSERT INTO boxNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mu lé le Dónbeenì Hácírí ó o Yeesu wee bío bìo kà síi, dìo á bìa dó mí sĩa wo yi khíi yí. Mu pã̀ahṹ ká le Dónbeenì dĩǹ yí nɔn mí Hácírí bìa dó mí sĩa o Yeesu yi, lé bìo le Dónbeenì dĩǹ yí léra a yèni. ");
INSERT INTO boxNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ká ɓa zã̀amáa na wi bĩ́n ɲá a Yeesu bíoní mu, á ɓa ɓúi wee bío le yìa kà wón ɓɛ̀ntĩ́n lé le *Dónbeenì ɲi-cúa fɛɛro. ");
INSERT INTO boxNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɓa ɓúi bán ɓɛ̀n le o lé *Yìa le Dónbeenì mɔn léra. Ɓa ɓúi ɓɛ̀n le mu so bon ká yìa le Dónbeenì mɔn léra ko ò o lé ho Kalilee kɔ̃hṹ yi le. ");
INSERT INTO boxNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mu so yí túara le Dónbeenì bíonì vũahṹ yi le o *Daviide nɔnkãni, là a Daviide mu ɓa lóhó Betelehɛɛmu lé bĩ́n á Yìa le Dónbeenì mɔn léra ko ò o lé yi le? ");
INSERT INTO boxNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Á ɓa zã̀amáa ɲi-cúa wó mín ɲúná yi o Yeesu mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɓa zã̀amáa mu tĩ́ahṹ á nùwã yɛn ɓúi wi ɓa wìi wo, ká nùpue woon yí tṹaa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bìo ɓa parowà na le Dónbeenì yankarowà ɲúnása lè ɓa Farizĩɛwa tonkaa bĩnía ɓuara, á bán tùara ɓa yi: «Lée webio nɔn á mi yí ɓuannáa wo yí ɓuararáa?» ");
INSERT INTO boxNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Á ɓa parowà bía: «Hã bíoní na ó o nùpue mu wee bío ɓàn síi á wa dĩǹ yí ɲá a ɓúi ɲii yi yí mɔn hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Á ɓa Farizĩɛwa bía nɔn ɓa yi: «Minɛ́n mún día miten ó o khà lon? ");
INSERT INTO boxNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Warɛ́n ɲúnása tĩ́ahṹ lè warɛ́n Farizĩɛwa tĩ́ahṹ á nì-kéní kà so tà a bìo le? ");
INSERT INTO boxNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ká lé ɓa zã̀amáa na kà mí dòn, bán na yí zũ dɛ̀ɛ o Mɔyiize làndá bìo yi, bán le Dónbeenì dánkánía.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Á ɓa Farizĩɛwa nì-kéní na ɓa le Nikodɛɛmu, yìa van o Yeesu cɔ̃́n ho tĩ́nàahṹ ɓúi, ");
INSERT INTO boxNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","á bía nɔn ɓa yi: «Wa làndá yi, á wa yí dà máa síiní nùpue ɲúhṹ ká wa yí ɲá ɓànso ɲi-cúa, á yí zũna ká a wó khon.» ");
INSERT INTO boxNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Á ɓa bía nɔn wo yi: «Ũnɛ́n mún wee bío lòn Kalilee nìi! Kàrán le Dónbeenì bíonì vũahṹ à cikon, á fo ò mi mu le *Dónbeenì ɲi-cúa fɛɛro nì-kéní kà yí máa lé Kalilee yi.»  ");
INSERT INTO boxNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Lé bṹn á ɓa ɓúenɓúen wà khíɓon wán, ");
INSERT INTO boxNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ò o Yeesu wón wà yòora le ɓúee na ɓa le Oliivewa ɓúee wán. ");
INSERT INTO boxNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mu tá na lée tɔ̃n yìnbíi bùirìi, ó o bĩnía van le *Dónbeenì zĩ-beenì lún yi, á ɓa zã̀amáa ɓueé kĩ́nía wo yi. Ó o lií kará ò o wee kàrán ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Á ho *làndá bìo zéenílowa lè ɓa *Farizĩɛwa ɓuan o hã́a ɓúi na ɓa zù yi là a bá-veere ɓueé zonnáa, á zoó dĩ̀nía wo ɓa nùpua ɓúenɓúen yahó, ");
INSERT INTO boxNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","à ɓa bía nɔn o Yeesu yi: «Nì-kàránlo, o hã́a na kà ɓa zù yi là a báa. ");
INSERT INTO boxNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","À wa làndá yi, ó o *Mɔyiize bò mu henía nɔn wɛn le ká wa wé yú bán hã́awa so síi, à wa lèeka ɓa lè hã huaa ɓúe. Àwa, ũnɛ́n ɓɛ̀n le we mu dã́ní yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓa bía bṹn à khũaanáa o Yeesu ɲii yi à yíráa wo kooní yi. Ká a Yeesu màhã́ lií lúnlúrá, ò o wee túa ho tá púnpùró yi lè mí nín-kíza. ");
INSERT INTO boxNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bìo ɓa dĩ̀n lan wee tùa wo yi, ó o lií hĩ́nɔn yòó dĩ̀n, ò o bía nɔn ɓa yi: «Yìa dĩǹ yí wó bè-kohó hùúu mi tĩ́ahṹ, à wón wã́a lèe wo lè le huee ho yahó.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ò o Yeesu bĩnía lií lúnlúrá, á wee túa ho tá púnpùró yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bìo ho làndá bìo zéenílowa lè ɓa Farizĩɛwa mu ɲá hɔ̃́n bíoní so, á ɓa wee lɛ́n lè mí nì-kéní kéní, à ɓúaká lè ɓa nì-kĩ́a, á ká a Yeesu là a hã́a ho tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ó o Yeesu wã́a lií hĩ́nɔn yòó dĩ̀n ò o wee bío là a hã́a: «O, o, hã́a mu, ɓa nùpua mu bò làa wen? O ɓúi mía máa síiní ũ ɲúhṹ le?» ");
INSERT INTO boxNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ó o hã́a bía nɔn o Yeesu yi: «Ɲúhṹso, o ɓúi mía máa síiní ho.» Ó o Yeesu wã́a bía nɔn wo yi: «Àwa, á ĩnɛ́n mún máa síiní ũ ɲúhṹ. Fo dà a lɛ́n, ká ũ ɓɛ̀n yí bĩní yí wé bè-kohó.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","O Yeesu pá bĩnía bía bìo kà nɔn ɓa zã̀amáa yi: «Ĩnɛ́n ka lòn khoomu ho dĩ́míɲása cɔ̃́n. Yìa tà bò miì, se ɓànso yú mu khoomu na wee na le mukãnì binbirì. O máa kɛń tíbírí yi hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Á ɓa Farizĩɛwa bía nɔn o Yeesu yi: «Ũnɛ́n wã́a wee mì ho tũ̀iá ũ ɲii, à bṹn à bìo fo wee bío á nùpue yí ko ò o tà yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ó o Yeesu bía nɔn ɓa yi: «Hàrí ká ĩ wee mì ho tũ̀iá ĩ ɲii, se bìo á ĩ wee bío ó o nùpue ko ò o tà yi. Lé bìo á ĩ zũ hen na á ĩ ló yi ɓuararáa, á ĩ mún zũ hen na á ĩ wee va yi. Ká minɛ́n bán yí zũ ĩ léeníi, á mún yí zũ hen na á ĩ wee va yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Minɛ́n wee fĩ̀ ɓa nùpua cítíi fĩ̀ló sìí, ká ĩnɛ́n wón máa cítí nùpue. ");
INSERT INTO boxNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ká ĩ lá ko à ĩ fĩ̀ cítíi, á ĩ cítíi mu ɲúhṹ á à wé. Lé bìo mu yínɔń ĩnɛ́n ĩ dòn á à fĩ̀ le cítíi mu. Mu lé ĩnɛ́n lè ĩ Maá na tonkaa mi á à páaní ì fĩ̀ le. ");
INSERT INTO boxNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mi làndá vũahṹ yi á mu túara le ká sɛɛ́ràsa nùwã ɲun mà ho tũ̀iá mu bìo dà-kéní bìo yi, se bṹn bìo so á nùpue ko ò o tà yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ĩnɛ́n wee mì ho tũ̀iá ĩ ɲii. Á ĩ Maá na tonkaa mi mún wee mì ho tũ̀iá ĩ ɲii.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Á ɓa tùara a yi: «Mìn maá mu wi wen?» Ó o Yeesu bía nɔn ɓa yi: «Mi yí zũ mi, á mún yí zũ ĩ Maá. Ká mi lá zũ mi, se mi mún lá à zũń ĩ Maá.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","O Yeesu bía hɔ̃́n bíoní so ká a wee kàrán ɓa nùpua le *Dónbeenì zĩ-beenì lún yi, mu hãmu kúeeníi lahó nìsã́ní. Nùpue yí wìira a lé bìo ó o pã̀ahṹ dĩǹ yí dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O Yeesu pá bĩnía bía bìo kà nɔn ɓa yi: «Ĩnɛ́n ǹ lɛ́n á mi ì càráa mi. Ɛ̀ɛ ká mi màhã́ à hí lè mi bè-kora. Hen na á ĩnɛ́n wee va yi, á minɛ́n yí dà máa va yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Á ɓa *zúifùwa wee bío mín yi: «O wi ò o ɓúe míten lée? Bìo ó o màhã́ le hen na mínɛ́n wee va yi á warɛ́n yí dà máa va yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ó o Yeesu bía nɔn ɓa yi: «Minɛ́n ló ho tá yi. Ká ĩnɛ́n ló ho wáayi. Minɛ́n bìo sã̀ ho dĩ́míɲá na kà yi, ká ĩnɛ́n wón bìo yí sã̀ ho yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lé bṹn te bìo á ĩ le mi ì híráa lè mi bè-kora. Mu bon, hen ká mi yí tà le ĩnɛ́n lé yìa wi fɛ́ɛɛ, á mi ì hí lè mi bè-kora.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Á ɓa tùara a yi: «Ũnɛ́n lé o yɛ́n?» Ó o Yeesu bía nɔn ɓa yi: «Ĩ wee bío mu na mia fɛ́ɛɛ hàrí mu ɲúhṹ ɓúɛɛníi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ĩ dà à bío bìo cɛ̀rɛ̀ɛ mi dã́ní yi, á dà à fĩ̀ le cítíi mi bìo cɛ̀rɛ̀ɛ wán. Ká yìa tonkaa mi lé ho tũ̀iá poni ɓànso, á bìo á ĩ ɲá a cɔ̃́n, bṹn lé bìo á ĩ wee bío na ho dĩ́míɲása yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓa yí zũ ká lé o Maá Dónbeenì ó o wee bío bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ó o Yeesu wã́a bía nɔn ɓa yi: «Ká a *Nùpue Za á mi can le ɓùɛɛnì wán hóonía fárá, bṹn ká mi ì zũń ká ĩnɛ́n lé yìa wi fɛ́ɛɛ. Á mi ì zũń ká ĩ yí máa wé bìo woon ĩten. Bìo á ĩ Maá bía nɔn miì, bṹn lé bìo á ĩ wee bío. ");
INSERT INTO boxNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ĩ Maá na tonkaa mi á wi làa mi, o yí día mi ĩ dòn, lé bìo á ĩ wee wé bìo sĩ a yi fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bìo ó o Yeesu wee bío kà, á ɓa nùpua cɛ̀rɛ̀ɛ dó mí sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ó o Yeesu wã́a bía nɔn ɓa zúifùwa na dó mí sĩa wo yi: «Ká mi wee bè ĩ bíonì yi, se mi màhã́ lé ĩ nì-kenínia bìo bon. ");
INSERT INTO boxNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mi ì zũń ho tũ̀iá poni binbirì na ló le Dónbeenì cɔ̃́n. Lé bṹn ǹ wé á mi ì kɛń miten.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Á ɓa bía nɔn wo yi: «Warɛ́n lé o *Abarahaamu mɔ̀nmànía. Wa yí wó a ɓúi wobáaní yí mɔn. Á lée webio nɔn á ũnɛ́n bíaráa le wa à kɛń waten?» ");
INSERT INTO boxNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Nùpue lée nùpue na wee wé mu bè-kora wón ka lòn wobá-nìi mu bè-kohó níi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Á mi zũ le o wobá-nìi bìo yí sã̀ ho zĩ-ɲúhṹ yi fɛ́ɛɛ. Ká a za na ton ho zĩ-ɲúhṹ yi, wón bìo sã̀ ho yi fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ká le Dónbeenì Za wã́a wó mia lè ɓa nùpua na wi míten, á mi ì wé miten binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ĩ zũ le mi lé o Abarahaamu mɔ̀nmànía, ɛ̀ɛ ká mi màhã́ wee cà à mi ɓúe mi, lé bìo á bìo á ĩ wee kàrán làa mia yí máa zo mia. ");
INSERT INTO boxNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Bìo á ĩ Maá zéenía làa mi, lé bṹn á ĩ wee bío, ká minɛ́n ɓɛ̀n wee wé bìo á mìn maá bía nɔn mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Á ɓa bía nɔn wo yi: «Warɛ́n wàn maá lé o Abarahaamu.» Ó o Yeesu bía nɔn ɓa yi: «Ká mi lá lé o Abarahaamu zàwa bìo bon, se mi lá wee wé hã wárá na ó o Abarahaamu wó ɓàn síi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Á mi yí máa wé hɔ̃́n, à mi wi mi ɓúe ĩnɛ́n na mà ho tũ̀iá poni nɔn mia, hìa na á ĩ ɲá ĩ Maá Dónbeenì cɔ̃́n. Bṹn ó o Abarahaamu yí wó. ");
INSERT INTO boxNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mi wee wé mìn maá wárá.» Á ɓa bía nɔn wo yi: «Wàn maá lé le Dónbeenì mí dòn. Wa yínɔń zĩní zàwa.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ó o Yeesu bía nɔn ɓa yi: «Ká mìn maá lá lé le Dónbeenì, á mi lá à wań mi, lé bìo á ĩnɛ́n ló le Dónbeenì cɔ̃́n ɓuara. Ĩ yí ɓuara ĩten. Lé lerɛ́n tonkaa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bìo nɔn á mi yí máa zũńnáa hã bíoní na á ĩ wee bío na mia kúará lé mu yɛ́n? Lé bìo á mi yí wi mi ɲí hã. ");
INSERT INTO boxNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yìa lé mìn maá lé o *Satãni. Á mìn maá sĩi bìo lé bṹn á mi wi à mi wé. O lé o nì-ɓúe hàrí ho dĩ́míɲá lénló pã̀ahṹ. O yí dà máa mì ho tũ̀iá poni, lé bìo á tũ̀iá poni mía wo yi. Hen ká a fã̀ le sabéré, se lé orɛ́n mí bɛɛre sìí ó o wee zéení, lé bìo ó o lé o sabín-fũ̀aalo. Orɛ́n lé yìa á hã sabíoní wee lé yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɛ̀ɛ ká ĩnɛ́n wee mì ho tũ̀iá poni, lé bṹn nɔn á mi yí tàráa ĩ bíoní yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Minɛ́n tĩ́ahṹ, ó o ɓúi so dà a bío le ĩ wó bè-kohó le? Ká ĩ wee mì ho tũ̀iá poni, á lée webio nɔn mi yí tàráa ĩ bíoní yi? ");
INSERT INTO boxNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bìa na lé le Dónbeenì zàwa binbirí wee wé ɲí le Dónbeenì bíoní. Ɛ̀ɛ ká minɛ́n yínɔń le Dónbeenì zàwa, lé bṹn nɔn mi yí máa ɲínáa le bíoní.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Á ɓa *zúifùwa bía nɔn wo yi: «À bṹn wa tũ̀iá sĩ à wa bío le fo lé o *Samarii nìi, á wa mún tũ̀iá sĩ à wa bío le o cĩ́ná wi foǹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ó o Yeesu bía nɔn ɓa yi: «Ĩnɛ́n á cĩ́ná mía yi. Ĩ Maá lé yìa á ĩ wee kɔ̃̀nbi. Ká minɛ́n bán wee zùań miì. ");
INSERT INTO boxNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ĩnɛ́n yí máa bío le nùpue dé cùkú miì. O ɓúi wi á à bío le ɓa dé ho miì, á lé wón mún lé o cítí-fĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Le ĩ mì ho tũ̀iá na mia: Yìa tà bò ĩ bíoní yi, á ɓànso máa hí máa cén.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Á ɓa zúifùwa bía nɔn wo yi: «Hã laà na kà wán, á wa wã́a láa mu yi kɛ̃́nkɛ̃́n le o cĩ́ná wi foǹ. O *Abarahaamu húrun, á le *Dónbeenì ɲi-cúa fɛɛrowà húrunka. À ũnɛ́n pá wee bío le ká yìa tà bò ũ bíoní yi á ɓànso máa hí máa cén. ");
INSERT INTO boxNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ũnɛ́n ɓɛ̀n wee leéka le ũ ɲúhṹ so wi po a Abarahaamu le? Wón húrun, á le Dónbeenì ɲi-cúa fɛɛrowà mún húrunka, á ũnɛ́n ɓɛ̀n wee leéka le fo lée wée?» ");
INSERT INTO boxNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ó o Yeesu bía: «Ĩ lá wee dé ho cùkú ĩten yi, se mu ɲúhṹ mía. Yìa wee dé ho cùkú miì lé ĩ Maá, yìa mi le o lé mìn Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","À mi ɲɔǹ yí zũ a. Ká ĩnɛ́n wón zũ a. Ĩ lá le ĩ yí zũ a, se ĩ lé o sabín-fũ̀aalo lè mi bìo síi. Ɛ̀ɛ ká ĩ zũ a, á wee bè o bíoní yi. ");
INSERT INTO boxNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mìn maá Abarahaamu hĩ́a wee leékaa le mí ì mi ĩ ɓuenló, ó o zã̀makaa mu bìo yi. Ó o ɓɛ̀n mɔn ĩ ɓuenló, á sĩi wan mu bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Á ɓa zúifùwa bía nɔn wo yi: «Ũnɛ́n na lúlúio máa yí ho ɓúará-ɲun làa pírú á mɔn o Abarahaamu wen?» ");
INSERT INTO boxNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ó o Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: O Abarahaamu á à bío le mí ì te, à bṹn à ĩnɛ́n wi.» ");
INSERT INTO boxNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Á ɓa wã́a sèekaa hã huaa le mí ì lèeka làa wo á à ɓúe. Ó o Yeesu sà míten ló le *Dónbeenì zĩ-beenì lún yi lée wà. ");
INSERT INTO boxNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Bìo ó o Yeesu lè mí nì-kenínia wee khĩí, á ɓa fò mín làa nìi ɓúi na ton ká a lé o muii. ");
INSERT INTO boxNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ó o nì-kenínia tùara a yi: «Nì-kàránlo, lée webio nɔn ó o nìi na kà ton ká a lé o muii? Lé orɛ́n kùrú bè-kora bìo yi lée, tàá lé ɓàn nùwã bè-kora bìo yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ó o Yeesu bía nɔn ɓa yi: «Mu yínɔń orɛ́n bè-kora bìo yi, á mu mún yínɔń ɓàn nùwã bè-kora bìo yi. O nìi mu ton ká a lé o muii, lée bèra a na à bìo le Dónbeenì dà a wé à ɓa nùpua ɓúenɓúen mi a yi. ");
INSERT INTO boxNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bìo mu khoomu wi hã laà na kà wán, á wa ko wa wé le Dónbeenì na tonkaa mi bè-wénia. Le tíbírí hĩ́a wi, á nùpue máa dàń máa wé bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bìo á ĩ wi ho dĩ́míɲá yi hã laà na kà wán, á ĩ ka lòn khoomu ho yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o pũ̀inía mí ɲinsãní, á khan lè le tĩ́ní, á khìira là a muii yìo, ");
INSERT INTO boxNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ò o bía nɔn wo yi: «Lɛ́n vaa sɛɛ ũ yahó le súeeníi la-beenì na ɓa le Silowee yi.» (Ho Silowee mu kúará le «tonkaro».) Ó o muii wà vaá sɛɛra mí yahó, á bĩnía wee ɓuen, ò o wee mi. ");
INSERT INTO boxNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Á bìa làa wo kará ɓó mín yi, làa bìa lá wee wé mi a ká a wee fìoka, á wã́a wee tùaka mín yi: «Yìa kà so yínɔń o nìi na lá wee wé kɛɛní fìoka le?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Á ɓa ɓúi le mu lé orɛ́n. Ɓa ɓúi ɓɛ̀n le mu yí bon, le o làa wo ɓonmín. Ó o nìi le mu lé mínɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Á ɓa tùara a yi: «Fo wó kaka wee mináa?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ó o nìi bía nɔn ɓa yi: «O nìi na ɓa le Yeesu, lé wón khan le tĩ́ní lè mí ɲinsãní, á khìira lè ĩ yìo, ò o le ĩ lɛ́n vaa sɛɛ ĩ yahó ho Silowee yi. Á ĩ wà van bĩ́n vaá sɛɛra ĩ yahó, á ĩ wee mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Á ɓa tùara a yi le o nìi mu wi wen, ó o le mí yí zũ. ");
INSERT INTO boxNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Á ɓa bò là a nìi na lá lé o muii vannáa ɓa *Farizĩɛwa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yaa bìo ó o Yeesu khan le tĩ́ní lè mí ɲinsãní á wɛɛ́ra a nìi yìo, á wó ho *Sabaa zoǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lé bṹn nɔn á ɓa Farizĩɛwa ɓɛ̀n sã̀ wee tùa o nìi yi làa bìo wó wó ó o wee mináa. Á wón bía nɔn ɓa yi: «O khìira le tĩ́-sio lè ĩ yìo, á ĩ sɛɛra ĩ yahó, á ĩ wã́a wee mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Á ɓa Farizĩɛwa nùwã yɛn ɓúi wã́a bía: «O nìi na wó bìo kà á Dónbeenì yí tonkaa, lé bìo ó o yí bò ho Sabaa làndá yi, ò o sá ho tonló.» Ɓa ɓúi bán ɓɛ̀n wee bío: «Bè-kora wéro so dà wee wé yéréké bìo na wee zéení le Dónbeenì pànká na á yìa kà wó ɓàn síi le?» Á ɓarɛ́n ɲi-cúa bĩnía wi mín ɲúná yi. ");
INSERT INTO boxNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Á ɓa bĩnía tùara a nìi yi: «Lé mu yɛ́n ũnɛ́n ɓɛ̀n wee leéka o nìi mu dã́ní yi, bìo á lé orɛ́n wɛɛ́ra ũ yìo?» Á wón bía: «O nìi mu lé le *Dónbeenì ɲi-cúa fɛɛro.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bìo ó o nìi lá lé o muii, á yìo bĩnía wee mi, á ɓa zúifùwa ɲúnása yí tà yi. ");
INSERT INTO boxNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Á ɓa von ɓàn nùwã wee tùa yi: «Yìa kà lé minɛ́n te mi za le? Lé orɛ́n á mi le o ton ká a lé o muii le? Á mu wó kaka ó o wee mináa?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ó o nìi ɓàn nùwã bía: «Lé warɛ́n te wa za, á ton ò o lé o muii. ");
INSERT INTO boxNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ká bìo wó wó ó o wee mináa á wa yí zũ, á yìa wɛɛ́ra a yìo á wa mún yí zũ. Mi tùa wo yi, o yìo tɔ̃n, o dà wee bío mí bìo míten.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɓa bía kà síi lé bìo ɓa zã́na ɓa zúifùwa ɲúnása. Bán wó le ɲii le ká nùpue bía wéréwéré ɓa nùpua yahó le o Yeesu lé *Yìa le Dónbeenì mɔn léra, á ɓànso ɓa à hè lè mí kàránló zĩi zoró. ");
INSERT INTO boxNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lé bṹn nɔn á ɓàn nùwã bíaráa le ɓa tùa orɛ́n mí bɛɛre yi, le o yìo tɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Á ɓa zúifùwa ɲúnása bĩnía von o nìi na lá lé o muii, á bía nɔn wo yi: «Loń le Dónbeenì yi à ũ ɓɛ̀ntĩ́n mì ho tũ̀iá. Warɛ́n bán zũ le o nìi mu lé o bè-kora wéro.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ó o nìi bía nɔn ɓa yi: «O nìi mu lé o bè-kora wéro lée, o yínɔń o bè-kora wéro lée, bṹn á ĩnɛ́n yí zũ. Bìo dà-kéní lé bìo á ĩ zũ, ĩ lá lé o muii, ká bìo kà wán á ĩ wee mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Á ɓa bía nɔn wo yi: «Lée webio ó o wó làa fo. O wó kaka á wɛɛ́raráa ũ yìo?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ó o nìi bía nɔn ɓa yi: «Ĩ lá bía mu nɔn mia, á mi yí ɲá lè ĩ cɔ̃́n. Á lée webio nɔn á mi wi à ĩ bĩní bíoráa mu na mia? Minɛ́n yàá mún wã́a wi à mi wé o nì-kenínia sá?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Á ɓa wee là a, à ɓa bía: «Ũnɛ́n lé yìa lé o nìi mu nì-kenínii kɛ̀ɛ. Warɛ́n bán lé o *Mɔyiize nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wa zũ le le Dónbeenì bía là a Mɔyiize. Ká yìa kà wón á wa yí zũ léeníi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ó o nìi bía nɔn ɓa yi: «Mu ɓɛ̀ntĩ́n lée bè-vĩ̀níkanii. Mi yí zũ a léeníi, ɛ̀ɛ ká arɛ́n lé yìa màhã́ wɛɛ́ra ĩ yìo. ");
INSERT INTO boxNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wa zũ le le Dónbeenì yí máa ɲí a bè-kora wéro fìoró. Ká yìa wee kɔ̃̀nbi le, á wee wé le sĩi bìo, wón lé yìa á le wee ɲí fìoró. ");
INSERT INTO boxNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bìo ho dĩ́míɲá wi wi, á wa dĩǹ yí ɲá ká nùpue na ton ká a lé o muii ó o ɓúi wɛɛ́ra yìo. ");
INSERT INTO boxNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","O nìi na kà lá yí ló le Dónbeenì cɔ̃́n, á bìo ó o wó kà ó o lá máa dàń máa wé.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Á ɓa bía nɔn wo yi: «Ũnɛ́n na ton lè mu bè-kora mí ɲii yi lé fo wee kàrán warɛ́n le?» À ɓa ɲɔn wo ó o ló, á hò a lè mí kàránló zĩi zoró. ");
INSERT INTO boxNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bìo ó o Yeesu ɲá à ɓa hò a nìi lè mí kàránló zĩi zoró, ó o wà vaá yú a, á bía nɔn wo yi: «Fo dó ũ sĩi o *Nùpue Za yi le?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ó o nìi bía: «Nì-kàránlo, zéení a làa mi bèra a na á ĩ dàń dé ĩ sĩi wo yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ó o Yeesu bía nɔn wo yi: «Fo mɔn wo, ĩnɛ́n na wee bío làa fo lé orɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ó o nìi wã́a bía: «Ɲúhṹso, ĩ dó ĩ sĩi foǹ.» Ò o lií ɓúrá a yahó. ");
INSERT INTO boxNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ó o Yeesu wã́a bía: «Ĩnɛ́n ɓuara ho dĩ́míɲá yi le cítíi bìo yi, bèra a na à ɓa muiiwà à wé mi. Ká bìa wee mi, à bán wé ɓa muiiwà.» ");
INSERT INTO boxNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bìo ɓa *Farizĩɛwa nùwã yɛn ɓúi na wi bĩ́n ɲá hã bíoní mu, á ɓa bía nɔn o Yeesu yi: «Á lé warɛ́n mún lé ũnɛ́n muiiwà le?» ");
INSERT INTO boxNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ó o Yeesu bía nɔn ɓa yi: «Ká mi lá lé ɓa muiiwà binbirí, á bè-kohó bìo lá máa mì máa lɛɛ́ mia. Ɛ̀ɛ ká bìo mi le mi wee mi, lé bṹn nɔn á mu bè-kohó bìo wee mì lɛɛ́ráa mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","O Yeesu bía nɔn ɓa yi: «Le ĩ mì ho tũ̀iá na mia: Yìa yí máa zo le pi-loore yi lè le ɓàn zũaɲii, ká a wee zo le yi làa lòn-veere, wón ɓànso lée kɔ̃̀nlo làa nì-wàahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yìa wee zo lè ho zũaɲii, wón lé o pi-pa. ");
INSERT INTO boxNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yìa wee pa le pi-loore yi wee hɛ́n le ɲii ò o zo. Á ɓa pia wee ɲí a cɔ̃́n. O wee ve mí pia lè ɓa yènnáa à léráa ho khũuhũ. ");
INSERT INTO boxNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ká a von mí pia ɓúenɓúen ɓa ló, ò o dí ɓa yahó lɛ́n à ɓa bè mɔ́n, lé bìo ɓa zũ a tãmu. ");
INSERT INTO boxNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ká yìa ɓa yí zũ wón ɓa máa bè mɔ́n. Ɓa yàá à lùwí á à khɛ̀n làa wo, lé bìo ɓa yí zũ a tãmu.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Yeesu wà dén wàhiire so nɔn ɓa yi, ká bìa ó o wà le nɔn yi màhã́ yí zũna a bíoní kúará. ");
INSERT INTO boxNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O Yeesu pá bĩnía bía: «Le ĩ mì ho tũ̀iá na mia: Ĩnɛ́n ka lòn pi-loore ɓàn zũaɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bìa dú ĩ yahó ɓúenɓúen lée kɔ̃̀nlowà làa nì-wànna. Ɛ̀ɛ ká ĩ pia yí ɲá ɓa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ĩnɛ́n ka lòn zũaɲii. Yìa zon làa ho, á wón ǹ fen. Ɓànso dà wé è zo ká a lé míten, á mún ǹ yí mí bè-dínii. ");
INSERT INTO boxNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","O kɔ̃̀nlo wón wee wé ɓuen ho ɲuaàló, lè ho ɓúeró, lè ho yáaró bìo yi mí dòn. Ɛ̀ɛ ká ĩnɛ́n wón ɓuara, bèra a na à ĩ pia yí le mukãnì binbirì na ɓàn síi mia. ");
INSERT INTO boxNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ĩnɛ́n ka lòn pi-pa tente. O pi-pa tente wee tà dé mí mukãnì na mí pia bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ká yìa wee pa ɓa pia le wárí bìo yi, wón ká a mɔn o dakhĩ́nkhĩ́n ò o lùwí ká a día ɓa, à wón yí ɓa ɓúi wìika, à bìa ká kɛ́nná. O wé lùwí lé bìo ɓa pia bìo yí sã̀ a yi. O yínɔń pi-pa binbirì. ");
INSERT INTO boxNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","O wee sá le wárí bìo yi, ká ɓa pia bìo yí ciran wo. ");
INSERT INTO boxNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Ĩnɛ́n ka lòn pi-pa tente. Bìa bìo sã̀ miì ka lòn pia. Ĩ zũ ɓa, á ɓa mún zũ mi, ");
INSERT INTO boxNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","làa bìo ó o Maá zũnáa mi á ĩ mún zũnáa wón bìo síi. Ĩ wee dé ĩ mukãnì na ĩ pia bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ĩ pia ɓúi pá wi, á dĩǹ yí zon le pi-loore na kà yi. Bán á ĩ mún ko à ĩ hè ɓuennáa. Ɓa à ɲí ĩ tãmu, á ɓa à wé pi-ɓoohṹ dà-kéní, làa pi-pa nì-kéní. ");
INSERT INTO boxNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","O Maá wa mi, lé bìo á ĩ wee tà dé ĩ mukãnì na, à bĩní yíráa le. ");
INSERT INTO boxNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nùpue yí dà máa vĩ́iní ĩnɛ́n mukãnì làa pànká. Ĩnɛ́n lé yìa wee tà dé le na ĩten. Le ɓàn naló pànká wi ĩ cɔ̃́n, á le ɓàn bĩní yíró pànká mún wi ĩ cɔ̃́n. Bṹn lé bìo á ĩ Maá nɔn le ɲii le ĩ wé.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hɔ̃́n bíoní so bìo yi, á ɓa *zúifùwa ɲi-cúa tĩ́n wó mín ɲúná yi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɓa tĩ́ahṹ, á ɓa cɛ̀rɛ̀ɛ wee bío bìo kà: «O cĩ́ná wi o yi, o wee khée. Mi yí ɲí a cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɓa ɓúi ɓɛ̀n wee bío: «Nùpue na á cĩ́ná wi yi yí dà máa bío hã bíoní na kà ɓàn síi. Cĩ́ná so dà a wɛɛ́ muiiwà yìo le?» ");
INSERT INTO boxNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mu wó le tɛ̀ɛnì pã̀ahṹ, ká ɓa *zúifùwa wee dí le *Dónbeenì zĩ-beenì ceéró sã́nú ho Zeruzalɛɛmu yi, ");
INSERT INTO boxNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ó o Yeesu zoó wee varáka ho sànsá na ɓa le Salomɔn sànsá yi, le Dónbeenì zĩ-beenì lún yi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Á ɓa zúifùwa wã́a ɓueé kĩ́nía wo yi, à ɓa tùara a yi: «Fo màhã́ à día wɛn hã yilera yi á vaá dã ho pã̀ahṹ yɛ́n coon? Hen ká fo lé *Yìa le Dónbeenì mɔn léra, à ũ bío mu wéréwéré na wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ó o Yeesu bía nɔn ɓa yi: «Ĩ bía mu nɔn mia, á mi yí tà mu. Hã wárá na á ĩnɛ́n wee wé lè ĩ Maá pànká, lé hɔ̃́n wee zéení ĩ léeníi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɛ̀ɛ ká bìo nɔn á minɛ́n yí tàráa mu, lé bìo á mi yí máa mì dé bìa bìo sã̀ miì ɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bìa bìo sã̀ miì wee ɲí ĩ cɔ̃́n làa bìo ɓa pia wee ɲínáa o pi-pa cɔ̃́n bìo. Ĩ zũ ɓa, á ɓa wee bè miì. ");
INSERT INTO boxNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ĩ wé è na le mukãnì binbirì na máa vé ɓa yi. Ɓa bìo máa yáa hùúu. O ɓúi máa fé ɓa ĩ níi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","O Maá na kàràfáa ɓa miì, wón po mu ɓúenɓúen, ó o ɓúi máa fé ɓa ĩ Maá níi yi máa yí. ");
INSERT INTO boxNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ĩnɛ́n lè ĩ Maá lée dà-kéní.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Á ɓa zúifùwa tĩ́n khuiira hã huaa le mí ì lèeka làa wo ò ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ó o Yeesu wã́a bía nɔn ɓa yi: «Ĩ wó mu bè-tentewà cɛ̀rɛ̀ɛ lè ĩ Maá pànká á mi mɔn. Á lé mu yɛ́n bìo yi á mi le mi ì lèekaráa mi lè hã huaa á à ɓúe?» ");
INSERT INTO boxNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Á ɓa bía nɔn wo yi: «Mu yínɔń ũ bè-tente ɓúi na fo wó bìo yi á wa le wa à lèekaráa fo lè hã huaa á à ɓúe. Ká lé bìo fo wee là le Dónbeenì. Ũnɛ́n nùpue kã́amáa á le fo lé le Dónbeenì.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ó o Yeesu wã́a bía: «Mu túara mi làndá vũahṹ yi kà síi: ‹Ĩnɛ́n Dónbeenì bía le mi lé hã dofĩ́ina.› ");
INSERT INTO boxNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","À wa ɲɔǹ zũ le bìo túara le Dónbeenì bíonì vũahṹ yi á yí dà máa khíní yi. Wa mún zũ le minɛ́n làndá yi á le Dónbeenì bía le ɓa nùpua na le nɔn mí bíoní yi lé hã dofĩ́ina. ");
INSERT INTO boxNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ká ĩnɛ́n wón ó o Maá Dónbeenì mɔn léra á ĩ bìo sã̀ a yi á tonkaa ho dĩ́míɲá yi. Á mi ì wé kaka à bíoráa le ĩnɛ́n wee là le Dónbeenì lé bìo á ĩ bía le ĩ lé le za? ");
INSERT INTO boxNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hen ká ĩ yí máa wé bìo á ĩ Maá wee wé, à mi yí tà ĩ bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ká ĩ wee wé mu, hàrí ká mi le mi máa tà ĩ bíoní yi, à mi pá wã́a tà bìo á ĩ wee wé yi, bèra a na à mi zũń kɛ̃́nkɛ̃́n le o Maá páanía làa mi, á ĩ páanía làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Á ɓa tĩ́n le mí ì wìi wo, ká a màhã́ porónna wà ò o día ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O Yeesu bĩnía khú lè ho Zurudɛ̃n muhṹ mɔ́n, hen na ó o Zãn lá wee bátízé ɓa nùpua yi, á khíi kará bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nùpua cɛ̀rɛ̀ɛ ɓuara a cɔ̃́n. Ɓa wee bío: «O Zãn yí wó hàrí yéréké bìo dà-kéní na wee zéení le Dónbeenì pànká. Ká bìo ɓúenɓúen na ó o bía a nìi mu dã́ní yi ɓɛ̀ntĩ́n lée tũ̀iá.» ");
INSERT INTO boxNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Á ɓa nùpua cɛ̀rɛ̀ɛ dó mí sĩa o Yeesu yi bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nìi ɓúi na ɓa le Lazaare hĩ́a lò yí here. O Lazaare mu lè mín hĩ́nni nùwã ɲun, o Maate là a Mari, á wi ho Betanii lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","O Mari mu lé yìa hĩ́a kúaa ho ɲiló na sãmu sĩ o Yeesu zení wán á bĩnía sùukaa lè mí ɲún-vãní. Lé wón ɓàn za Lazaare á lò yí here. ");
INSERT INTO boxNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ó o Lazaare mu ɓàn hĩ́nni mí nùwã ɲun tonkaa o ɓúi le o vaa bío bìo kà na a Yeesu yi: «Ɲúhṹso, mìn bɔ̃́nlo á lò yí here.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bìo ɓa vaá bía mu nɔn o Yeesu yi, ó o bía: «Mu vã́mú mu yínɔń bìo na à wé o ò hí ì cén. Mu ù wé á le Dónbeenì yèni á à lé. Mu ù wé á le Dónbeenì Za cùkú á à mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","O Yeesu á wa a Maate là a Mari lè ɓàn yàró Lazaare. ");
INSERT INTO boxNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɛ̀ɛ ká bìo ó o ɲá a Lazaare vã́mú bìo, ó o bĩnía wó hã wizooní ɲun hen na ó o wi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bṹn mɔ́n, ó o bía nɔn mí nì-kenínia yi: «Mi bĩní le wa lɛ́n va ho *Zudee kɔ̃hṹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ó o nì-kenínia bía nɔn wo yi: «Nì-kàránlo, yínɔń bĩ́n á ɓa còonía le mí ì lèeka fo lè hã huaa á à ɓúe le? À lé bĩ́n á ũ pá wi à ũ bĩní va yi le?» ");
INSERT INTO boxNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ó o Yeesu bía nɔn ɓa yi: «Hã lɛ́ɛ̀rèwa pírú ɲun lé hĩ̀a wi le wizon-kùure yi, tàá? Ká a nùpue wee varáka le wisoni yi, ò o máa hṹaa míten, lé bìo á mu khoomu wi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɛ̀ɛ ká a nùpue wee varáka ho tĩ́nàahṹ, ò o wé hṹaa míten, lé bìo mu khoomu mía.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o pá bĩnía bía: «Wàn bɔ̃́nlo Lazaare dũma, ká ĩ màhã́ vaá sĩ̀ní a.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ó o nì-kenínia bía: «Hen ká a dũma, se o vã́mú díká wee dé, o ò wa.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","O Yeesu wi ò o bío le o Lazaare húrun. Ká a nì-kenínia bán wee leéka le lé mu dãmu binbirì ó o bía bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ó o Yeesu wã́a bía mu wéréwéré nɔn ɓa yi: «O Lazaare húrun. ");
INSERT INTO boxNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bìo mu yí wó yí yú mi bĩ́n á ĩ wee zã̀maka minɛ́n bìo yi, lé bìo á lé bṹn á à na á mi ì wíoka à déráa mi sĩa miì. Mi wã́a wa lɛ́n va hen na ó o Lazaare mu wi yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ó o Toma na ɓa wee ve làa Hénbéní á wã́a bía nɔn ɓa nì-kenínia na ká yi: «Mi mún wa lɛ́n va, à vaa páaní hí làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bìo ó o Yeesu wà vaá zo ho Betanii lóhó yi, ó o ɲá à ɓa le o Lazaare nùuna á yú hã wizooní bìo náa. ");
INSERT INTO boxNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ho Betanii lè ho Zeruzalɛɛmu yí nà yi mín yi. Mu máa yí kilomɛɛterewa bìo tĩn sese, ");
INSERT INTO boxNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","á ɓa *zúifùwa cɛ̀rɛ̀ɛ ló ho Zeruzalɛɛmu yi ɓuara a Maate là á Mari cɔ̃́n, á wà ɓueé tɛ̀ɛní ɓàn yàró yúmú. ");
INSERT INTO boxNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bìo ó o Maate ɲá à ɓa le o Yeesu bò o ɓuen, ó o ló lée sã́ a yahó, ò o Mari wón kará le zĩi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bìo ó o lée yú a, ó o bía nɔn wo yi: «Ɲúhṹso, fo nɔ̀nzoǹ lá wi hen, se wàn yàró yí húrun. ");
INSERT INTO boxNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ɛ̀ɛ ká ĩ zũ le hã laà na kà wán pá, á bìo ɓúenɓúen na fo ò fìo le Dónbeenì cɔ̃́n, á le è wé.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ó o Yeesu bía nɔn wo yi: «Mìn yàró á à vèe.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ó o Maate bía: «Ĩ zũ le ká le Dónbeenì wee vèení ɓa nì-hía ho dĩ́míɲá vé nɔ̀nzoǹ, ó o ò vèe.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ó o Yeesu bía nɔn wo yi: «Ĩnɛ́n lé yìa wee vèení ɓa nì-hía á wee na le mukãnì binbirì. Yìa dó mí sĩi miì, ó o mukãnì á à kɛń, hàrí à ɓànso hí. ");
INSERT INTO boxNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Á nùpue lée nùpue na dó mí sĩi miì á yú le mukãnì binbirì, wón máa hí máa cén. Maate, fo tà bṹn le?» ");
INSERT INTO boxNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ó o Maate bía: «Ũuu Ɲúhṹso, ĩ tà le fo lé *Yìa le Dónbeenì mɔn léra, le Dónbeenì Za na ko ò o ɓuen ho dĩ́míɲá yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bìo ó o Maate bía bṹn vó, ó o wà ɓueé von mín hĩ́nló wee hũmɔnkaráa: «O nì-kàránlo lée wi hen. O le ũ ɓuen.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bìo ó o Mari ɲá bìo bía, ó o dɛ̀ɛnía hĩ́nɔn bánbáa mà a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mu pã̀ahṹ ò o Yeesu lá dĩǹ yí ɓueé zon ho lóhó yi. O wi hen na ó o Maate lée sã́ a yahó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bìo ɓa zúifùwa na lá wi le zĩi yi làa Mari, á wee hĩ̀í o sĩi mɔn wo ò o hĩ́nɔn bánbáa ló, á ɓa bò a mɔ́n. Ɓa wee leéka le o bò ò lé le búure wán á lée wá. ");
INSERT INTO boxNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bìo ó o Mari vaá dɔ̃n hen na ó o Yeesu wi yi, ó o lií ɓúrá a yahó, ò o bía nɔn wo yi: «Ɲúhṹso, fo nɔ̀nzoǹ lá wi hen, se wàn yàró yí húrun.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ká a Yeesu mɔn ò o wee wá, á ɓa nùpua na bò làa wo mún wee wá, á mu vá a yi làa sòobɛ́ɛ, ó o sò mí yahó. ");
INSERT INTO boxNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ó o tùara ɓa yi: «Lé wen á mi nùuna a yi?» Á ɓa bía nɔn wo yi: «Ɲúhṹso, ɓuen ɓuee loń.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ó o Yeesu yèn-caa wee lé. ");
INSERT INTO boxNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Á ɓa zúifùwa na wi bĩ́n á wee bío: «Mi loń bìo ó o lá wa làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ká ɓa nùwã yɛn ɓúi bán ɓɛ̀n wee bío: «Orɛ́n na wɛɛ́ra a muii yìo, á so mún lá yí dà máa hè o Lazaare húmú le?» ");
INSERT INTO boxNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bìo ɓa wee va hen na le búure wi yi, ó o Yeesu á mu wíokaa vá yi làa sòobɛ́ɛ. Le búure mu lée ɓó-lɛɛhó ɓúi kɔ̃hṹ, á ɲii pon lè le hue-beenì. ");
INSERT INTO boxNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ó o Yeesu bía: «Mi bĩ̀iní le huee lén bĩ́n.» Ó o Maate na lé yìa húrun ɓàn hĩ́nló, á bía nɔn o Yeesu yi: «O sãmu á à wé, lé bìo ó o wi le búure yi yú hã wizooní bìo náa.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ó o Yeesu bía nɔn wo yi: «Ĩ so yí bía yí nɔn foǹ le ká fo dó ũ sĩi miì, á fo ò mi le Dónbeenì cùkú beenì le?» ");
INSERT INTO boxNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Á ɓa wã́a bĩ̀inía le huee léra. Ó o Yeesu yòó dá mí yahó ho wáayi, ò o bía: «Ĩ Maá, ĩ wee dé ũ bárákà, lé bìo fo tà ɲá ĩ fìoró. ");
INSERT INTO boxNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ĩ zũ le fo wee ɲí ĩ cɔ̃́n fɛ́ɛɛ, ɛ̀ɛ ká ĩ wee bío làa fo bìo kà wán ɓa nùpua na kĩ́nía miì kà bìo yi, bèra a na ɓa tà le lé ũnɛ́n tonkaa mi bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o bía pɔ̃́npɔ̃́n: «Lazaare, ɓuee lé.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ó o Lazaare na lá húrun ɓueé ló, ká a zení là a níní bá lè hã nín-kéníwà, á yahó pon yi. Ó o Yeesu bía: «Mi fee wo, à día le o lɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bìo ɓa *zúifùwa na ɓuara a Mari cɔ̃́n mɔn bìo ó o Yeesu wó, á ɓa cɛ̀rɛ̀ɛ dó mí sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ká ɓa tĩ́ahṹ á ɓa nùwã yɛn ɓúi wà vaá yú ɓa *Farizĩɛwa, á lá bìo ó o Yeesu wó á fɛɛra nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Á ɓa Farizĩɛwa lè le *Dónbeenì yankarowà ɲúnása á von mí ninzàwa *làndá tũ̀iá fɛɛrowà na ká à ɓa kúaa mín wán, á bía nɔn mín yi: «Wa ɓɛ̀ntĩ́n ko à wa wé bìo ɓúi. O nìi mu sòobáa wee wé mu yéréké bìowa dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ká wa día ó o wee wé mu, á ɓa nùpua ɓúenɓúen hĩ́a yèrèmá à dé mí sĩa wo yi. Á ho Oroomusa ɲúnása á à hĩ́ní ì fì wa *Dónbeenì zĩ-beenì, á à ɓúe wa nìpomu ɲúhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Á ɓa nì-kéní na ɓa le Kayiifu, yìa lé le Dónbeenì yankarowà ɲúhṹso beenì le lúlúure mu yi, á bía nɔn ɓa yi: «Mi yí zũ bìo ɓúi mu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mi so yí zũ le warɛ́n cɔ̃́n á mu sṹaaní ò o nùpue nì-kéní hí wa nìpomu ɓúenɓúen bìo yi à mu bè yi fennáa le?» ");
INSERT INTO boxNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","O Kayiifu mu yí bía hã bíoní mu míten. Ká bìo ó o lé le Dónbeenì yankarowà ɲúhṹso beenì le lúlúure mu yi, lé bṹn nɔn ó o wee fɛɛ le Dónbeenì ɲi-cúa kà síi, le o Yeesu ko ò o hí mín nìpomu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mu yínɔń bán mí dòn bìo yi. O mún ko ò o hí, à le Dónbeenì zàwa ɓúenɓúen na saawaa wi ho dĩ́míɲá ɓúenɓúen yi, ò o vá kúee mín wán, à wé lè mu nìpomu dà-kéní. ");
INSERT INTO boxNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lé bṹn bìo yi, á ɓa zúifùwa ɲúnása bía tò mu wán mu zoǹ le mí ì na a Yeesu ɓa à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Á lé bṹn nɔn ó o Yeesu wã́a yí máa hɛ́ɛ ɓa zúifùwa tĩ́ahṹ à ɓa mi, ò o wà van ho lóhó ɓúi na ɓa le Efarayiimu, hìa ɓó le dùure yi, á vaá kará bĩ́n lè mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hen ká ɓa zúifùwa sã́nú na ɓa le Paaki wà ɓueé dã, à ɓa cɛ̀rɛ̀ɛ léka à fèn va ho Zeruzalɛɛmu, á vaa ceé míten à dàń díráa ho sã́nú mu. ");
INSERT INTO boxNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ɓa nùpua wee cà a Yeesu, á wee tùaka mín yi le Dónbeenì zĩ-beenì lún yi le o Yeesu mu á à yí ì ɓuen ho sã́nú díiníi lée, tàá o máa ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mu ù wé à le *Dónbeenì yankarowà ɲúnása lè ɓa *Farizĩɛwa á nɔn le ɲii le ká yìa zũ hen na ó o Yeesu wi yi, à ɓànso ɓuee bío mu, à mí wìi wo. ");
INSERT INTO boxNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bìo á ho *Paaki sã́nú díró ká hã wizooní bìo hèzĩ̀n, ó o Yeesu ɓuara ho Betanii lóhó, hen na ó o Lazaare wee lé yi, yìa ó o vèenía. ");
INSERT INTO boxNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɓa wee dí ho sã́nú o Yeesu bìo yi bĩ́n, ó o Maate wee na ho dĩ́nló ɓa nùpua yi. Bìa là a Yeesu páanía kará ho dĩ́nló ɲúhṹ yi ó o Lazaare wi tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ó o Mari ɓuan ho ɲiló na sãmu sĩ á yàwá here liitere sanka màní, hìa wó lè mu bìo ɓúi na ɓa le náàrè mí ɲii yi, á ɓueé kúaa o Yeesu zení wán, á bĩnía sùukaa lè mí ɲún-vãní. Á ho ɲiló sãmu hĩ́nɔn sú le zĩi mu ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ó o Yeesu nì-kenínia nì-kéní na ɓa le Zudaa Isikariote, yìa á à dé wo ò na, á wã́a bía: ");
INSERT INTO boxNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Lée webio nɔn ɓa yí yɛ̀ɛ́raráa ho ɲiló mu lè wɛ́n-hãani khĩá-tĩn, á yí nɔn ɓa nì-khenia yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O Zudaa bía bṹn yínɔń bìo ɓa nì-khenia bìo here wo yi, ká lé bìo ó o lé o kɔ̃̀nlo. Ɓa ɓunɓua-wárí na wi o cɔ̃́n ó o wee lén dí. ");
INSERT INTO boxNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ká a Yeesu màhã́ bía: «O hã́a mu á ũ día. Ho ɲiló mu ó o lá bàrá pan lè ĩ sãnía wíokaró hã nùuló bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɓa nì-khenia á à kɛń làa mia fɛ́ɛɛ, ká ĩnɛ́n wón máa kɛń làa mia fɛ́ɛɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ɓa minka *zúifùwa ɲá le o Yeesu wi ho Betanii yi, á ɓa wà van bĩ́n. Mu yínɔń o Yeesu bìo yi mí dòn ɓa vannáa, ɓa mún wi ɓa vaa mi a Lazaare na ó o Yeesu vèenía. ");
INSERT INTO boxNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Á le *Dónbeenì yankarowà ɲúnása mún wã̀anía tò le mí ì na a Lazaare ɓa à ɓúe ");
INSERT INTO boxNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","lé bìo á mu lé o Lazaare mu vèeró bìo yi á ɓa zúifùwa cɛ̀rɛ̀ɛ wee yèrèmá dé mí sĩa o Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mu tá na lée tɔ̃n, á ɓa minka zã̀amáa na ɓuara ho sã́nú díró bìo yi, á ɲá le o Yeesu wà ɓueé zo ho Zeruzalɛɛmu, ");
INSERT INTO boxNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","á ɓa khó hã yùkúio vɔ̃nna na ɓa lée déráa ho cùkú wo yi ɓuan, à ɓa wà lée sã́ a yahó. Ɓa wee bío bìo kà pɔ̃́npɔ̃́n: «Le ho cùkú à bìo sĩ̀ le Dónbeenì yi. Le o Ɲúhṹso Dónbeenì wé mu bè-tentewà làa yìa bò o ɓuen o yèni yi, o *Isirayɛɛle bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","O Yeesu yòora a sũ̀npɛ̀-bòohṹ ɓúi, làa bìo le Dónbeenì bíonì vũahṹ bíaráa mu kà síi: ");
INSERT INTO boxNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«*Sion lóhó nìpomu, yí zɔ̃́n dɛ̀ɛ. Loń, lé ũ bɛ́ɛ bò o ɓuen, o yòora a sũ̀npɛ̀-bòohṹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pã̀ahṹ na mu wee wé yi, ó o Yeesu nì-kenínia yí zũna mu kúará. Ká pã̀ahṹ na le Dónbeenì léra a Yeesu yèni yi, á ɓa hácírí màhã́ ɓuara bìo le Dónbeenì bíonì vũahṹ bía a dã́ní yi wán. Á bìo ho vũahṹ mu bía, lé bṹn ó o bìo wóráa. ");
INSERT INTO boxNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bìa nɔ̀nzoǹ páanía wi là a Yeesu pã̀ahṹ na ó o von o Lazaare á wón vèera ló le búure yi, bán ɓúenɓúen wee mì bìo ɓa mɔn tũ̀iá. ");
INSERT INTO boxNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bìo mún nɔn ɓa minka zã̀amáa lée sã́náa o yahó, lé bìo mu yéréké bìo na wee zéení le o ló le Dónbeenì cɔ̃́n tũ̀iá na mà á ɓa ɲá. ");
INSERT INTO boxNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Á ɓa *Farizĩɛwa wã́a wee bío mín yi: «Mi yí mɔn mu le, mi yí dà dɛ̀ɛ ɓúi máa wé. Ɓa nùpua ɓúenɓúen wee yèrèmá bè o yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bìa wà ɓueé ɓùaaní le Dónbeenì ho Zeruzalɛɛmu yi ho sã́nú díró pã̀ahṹ á bìa yínɔń *zúifùwa ɓúi wi tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓa vá ɓueé ɓó a Filiipu na wee lé ho Kalilee kɔ̃hṹ lóhó na ɓa le Bɛtesayidaa yi, á bía nɔn wo yi: «Wa wi à wa mi a Yeesu wán.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ó o Filiipu wã́a bía mu là a Ãndere, á ɓa mí nùwã ɲun wà vaá bía mu là a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ó o Yeesu bía nɔn ɓa yi: «Hìa kà lé ho pã̀ahṹ na le Dónbeenì á à lén o *Nùpue Za yèni yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Le ĩ mì ho tũ̀iá na mia: Ká ho dĩ́nló bɛɛre á yí dù, á mukãnì yí hà á bìo ká yí soora, á le è dĩ̀n kà. Ká le mukãnì hà, á bìo ká soora, á le è ha hã bia na boo. ");
INSERT INTO boxNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yìa henía mí mukãnì bìo, wón á à vĩ́iní le. Ká yìa yí máa càtí mí mukãnì bìo hùúu ho dĩ́míɲá na kà yi, wón á à yí le mukãnì binbirì na máa vé. ");
INSERT INTO boxNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yìa wi ò o sá na miì, à wón bè miì. Á hen na á ĩ wi yi, á ĩ ton-sá mún ǹ kɛń yi. Yìa wee sá na miì, wón á ĩ Maá á à dé ho cùkú yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Bìo kà wán, á ĩ hácírí yáara. Lé mu yɛ́n á ĩ ì bío? Ĩ bío le ĩ Maá kã̀ní mi le lònbee na à yí mi hã laà na kà wán lée? Ɛ̀ɛ ká lé bṹn bìo yi á ĩ ɲɔǹ ɓuararáa. ");
INSERT INTO boxNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ĩ Maá, zéení ũ cùkú le ɓa nùpua mi.» Á tãmu ɓúi sã ɲá ho wáayi á bía: «Ĩ zéenía ĩ cùkú, á ĩ pá à wíoka à zéení ho.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ká ɓa zã̀amáa na dĩ̀n bĩ́n ɲá mu, á ɓa le lée viohó và. Ɓa ɓúi ɓɛ̀n le lée tonkaro na ló ho wáayi bía làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ó o Yeesu bĩnía bía: «Mu yínɔń ĩnɛ́n bìo yi á mu tãmu sã ɲánáa. Mu lé minɛ́n bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bìo kà wán lé ho dĩ́míɲá na kà nùpua cítíró pã̀ahṹ. Lé bìo kà wán á le Dónbeenì lùwáráa ho dĩ́míɲá na kà ɲúhṹso. ");
INSERT INTO boxNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ká ĩnɛ́n ɓa khíi can le ɓùɛɛnì wán hóonía yòó fárá, á ĩ wé á ɓa nùpua ɓúenɓúen á à ɓuen ĩ cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O bía kà síi á zéeníanáa bìo ó o ò híráa sìí. ");
INSERT INTO boxNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Á ɓa zã̀amáa bía nɔn wo yi: «Wa zũ le le Dónbeenì làndá vũahṹ yi á mu bía le *Yìa le Dónbeenì mɔn léra ko ò o kɛń bĩ́n fɛ́ɛɛ, á ũ wó kaka wee bíoráa le o *Nùpue Za ɓa ko ɓa ca le ɓùɛɛnì wán hóoní yòo fárá? À wón Nùpue Za so ɓɛ̀n lé o yɛ́n?» ");
INSERT INTO boxNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ó o Yeesu bía míten bìo nɔn ɓa yi: «Mi yú mu khoomu, ká ho pã̀ahṹ na mu ù wé á yí túee. Á bìo mi yú mu khoomu, á mi wã́a wé varáka mu yi, à le tíbírí hĩ́a yí yòoka mi wán. Mu bon, yìa wee varáka le tíbírí yi á yí máa mi bìo wi o yahó. ");
INSERT INTO boxNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mi tà dé mi sĩa yìa lé mu khoomu yi, pã̀ahṹ na mi yú mu yi, à mi wé mu khoomu nùpua.» Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o khɛ̀ra vaá sà míten ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bìo ó o wó mu yéréké bìowa cɛ̀rɛ̀ɛ na wee zéení le o ló le Dónbeenì cɔ̃́n ɓa mɔn mí cúee, ká ɓa pá yí dó mí sĩa wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mu wó ò o *Ezayii ɲi-cúa na ó o fɛɛra, à ɲii sí. O bía: «Ɲúhṹso, lé o yɛ́n yàá dó mí sĩi le bín-tente na wa wee bue yi? Á lé o yɛ́n ó o Ɲúhṹso zéenía lè mí pànká?» ");
INSERT INTO boxNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bìo nɔn ɓa yí dà máa tàráa mu yi, lé bìo ó o Ezayii mu pá bĩnía bía: ");
INSERT INTO boxNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Le Dónbeenì wó á ɓa ka lòn muiiwà, bèra a na à ɓa wé yí mi. Le wó á ɓa yiwa tunka bèra a na à ɓa wé yí dàń zũń bìo á le wee wé. Le wó kà síi bèra a na à ɓa yí dàń yèrèmá ɓuen le cɔ̃́n à le wɛɛ́ ɓa.» ");
INSERT INTO boxNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","O Ezayii bía hɔ̃́n bíoní so lé bìo ó o mɔn ho cùkú na le Dónbeenì á à dé o Yeesu yi, ó o bía a bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ɛ̀ɛ ká ɓa *zúifùwa ya-díwá mí bɛɛre tĩ́ahṹ, á ɓa cɛ̀rɛ̀ɛ ɲɔǹ pá dó mí sĩa o Yeesu yi. Ká ɓa màhã́ yí máa tà bío mu wéréwéré, lé ɓa *Farizĩɛwa bìo yi, à bán yí hè ɓa lè ɓa zúifùwa kàránló zĩi zoró. ");
INSERT INTO boxNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ɓa wa le yèni càró ɓa nùpua cɔ̃́n á po le yèni càró le Dónbeenì cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","O Yeesu bía bìo kà pɔ̃́npɔ̃́n: «Yìa dó mí sĩi miì, se yínɔń ĩnɛ́n ĩ dòn á ɓànso dó mí sĩi yi. Ɓànso dó mí sĩi yìa tonkaa mi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yìa mɔn mi, se lé yìa tonkaa mi á ɓànso mún mɔn. ");
INSERT INTO boxNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ĩnɛ́n ka lòn khoomu á ɓuara ho dĩ́míɲá yi, bèra a na ká nùpue lée nùpue na dó mí sĩi miì, à ɓànso yí kɛń le tíbírí yi. ");
INSERT INTO boxNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ká a ɓúi ɲá ĩ bíoní ò o yí bò hã yi, á mu máa wé ĩnɛ́n lé yìa á à síiní ɓànso ɲúhṹ. Mu bon, ĩnɛ́n yí wà ɓueé síiní ho dĩ́míɲá nùpua ɲúná, ká ĩ wà ɓueé fení ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yìa pã́ ĩ bìo, á yí máa tà ĩ bíoní yi, wón ɲúhṹ á à sí. Hã bíoní na á ĩ bía lé hɔ̃́n á à síiní ɓànso ɲúhṹ ho dĩ́míɲá vé nɔ̀nzoǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Lé bìo á ĩ yí bía lè ĩ pànká. Ká a Maá na tonkaa mi, wón míten lé yìa nɔn le ɲii miì, á zéenía bìo á ĩ ì bío binbirì lè ɓa nùpua. ");
INSERT INTO boxNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Á ĩ mún zũ le bìo ó o wee na le ɲii à ĩ hení na ɓa nùpua yi, bṹn wee na le mukãnì binbirì na máa vé. Hã bíoní na á ĩ wee bío lé hĩ̀a ó o Maá nɔn le ɲii le ĩ bío.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sã́ni ho *Paaki sã́nú díró ɓúaká, á bìo ó o Yeesu zũna le mí léró ho dĩ́míɲá yi à va mín Maá cɔ̃́n pã̀ahṹ dɔ̃n, á bìa bìo sã̀ yi na wi ho dĩ́míɲá yi ó o wa, ó o wíokaa zéenía le bìo mí wa làa ba ɓàn síi mía. ");
INSERT INTO boxNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","O Yeesu lè mí nì-kenínia lan wee dí ho zĩihṹ ɲii. À bṹn, ò o *Satãni wó ó o Yeesu dénaló bìo wi o Zudaa na lé o Simɔn Isikariote za sĩi yi vó. ");
INSERT INTO boxNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","O Yeesu zũ le o Maá dó mu bìo ɓúenɓúen mí níi yi. Ó o mún zũ le mí ló le Dónbeenì cɔ̃́n, á bĩnía wà à va le cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ó o wã́a lií hĩ́nɔn ho dĩ́nló ɲúhṹ yi, á tɛra mí báká beenì, ò o lá le nín-kéní can lè mí kuio. ");
INSERT INTO boxNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ò o kúaa mu ɲumu le dɛ̀ɛ ɓúi yi, ò o wee sɛɛ mí nì-kenínia zení, à bĩní sùuka lè le nín-kéní na ó o can lè mí kuio. ");
INSERT INTO boxNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bìo o ɓueé dɔ̃n o Simɔn Piɛre, á wón bía nɔn wo yi: «Ɲúhṹso, lé ũnɛ́n wi à ũ sɛɛ ĩnɛ́n zení le?» ");
INSERT INTO boxNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ó o Yeesu bía nɔn wo yi: «Bìo á ĩnɛ́n wee wé bìo kà wán á ũnɛ́n yí zũ kúará. Ɛ̀ɛ ká fo khíi zũń mu làa mɔ́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ó o Piɛre bía: «Ɓùeé, ũnɛ́n máa sɛɛ ĩ zení hùúu.» Ó o Yeesu bía nɔn wo yi: «Ká ĩ yí sɛɛra ũ zení, á ũnɛ́n làa mi máa páaní bìo ɓúi yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ó o Simɔn Piɛre wã́a bía: «Ɲúhṹso, ká mu ka kà, à ũ yí sɛɛ ĩ zení mí dòn, ká ũ sɛɛ ĩ níní lè ĩ ɲúhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ó o Yeesu bía nɔn wo yi: «Yìa súaa, wón bìo ɓúenɓúen wee ce. O hĩ́a le mí ì sɛɛ bìo, se mu lé o zení. Minɛ́n bán wee ce, ɛ̀ɛ ká mu yínɔń mi ɓúenɓúen.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","O Yeesu zũ yìa á à dé o ò na, lé bṹn te bìo ó o le ɓa ɓúenɓúen yí máa ce. ");
INSERT INTO boxNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bìo ó o sɛɛra ɓa zení vó, ó o lá mí báká beenì zã́ ò o bĩnía lií kará ho dĩ́nló ɲúhṹ yi, ò o wã́a wee bío lè mí nì-kenínia: «Mi so zũ bìo á ĩ wó kà kúará le? ");
INSERT INTO boxNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mi wee ve mi làa nì-kàránlo, làa Ɲúhṹso, á mi tũ̀iá sĩ, ĩ lé o nì-kàránlo á lé o Ɲúhṹso. ");
INSERT INTO boxNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ká ĩnɛ́n hĩ́a sɛɛra minɛ́n zení, se minɛ́n mún ko mi wé sɛɛ mín zení. ");
INSERT INTO boxNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ĩ wó mu zéenía làa mia, bèra a na, à minɛ́n mún wé wé mu làa mín, làa bìo á ĩ wóráa mu làa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Le ĩ mì ho tũ̀iá na mia: Ton-sá na po mí ɲúhṹso wón mía. Ó o tonkaro na po yìa tonkaa wo, wón mún mía. ");
INSERT INTO boxNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bìo mi zũ bṹn, ká mi wee wé mu, se mi ɲúná sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","O Yeesu bía: «Mu yínɔń mi ɓúenɓúen á ĩ wee bío bìo. Ĩnɛ́n lé yìa zũ bìa á ĩ hueekaa. Ɛ̀ɛ ká bìo túara le Dónbeenì bíonì vũahṹ yi ko mu wé à ɲii sí. Mu túara kà síi: ‹Yìa làa mi páanía dú ĩ dĩ́nló á bĩnía wee fi làa mi.› ");
INSERT INTO boxNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ĩ wee bío mu na mia bìo kà wán ká mu bìo mu dĩǹ yí dɔ̃n, bèra a na ká mu khíi dɔ̃n, à mi tà le ĩnɛ́n lé yìa wi fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Le ĩ mì ho tũ̀iá na mia: Nùpue na khíi ɓuan ĩ tonkaro sese, se lé ĩnɛ́n á ɓànso ɓuan sese. Á yìa ɓuan mi sese, se lé yìa tonkaa mi á ɓànso ɓuan sese.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bìo ó o Yeesu bía hɔ̃́n bíoní so vó, ó o hácírí wíokaa yáara, ó o wã́a bía wéréwéré: «Le ĩ mì ho tũ̀iá na mia: Minɛ́n nì-kéní lé yìa á à dé mi ì na.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Á ɓa nì-kenínia wee lońka mín yi. Ɓa yí zũ yìa ó o wee bío bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mu wee wé, ò o Yeesu nì-kenínia nì-kéní, yìa ó o wa, á kará ɓó a yi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ó o Simɔn Piɛre bía làa wón lè mí níi le o tùa o Yeesu yi le lé o yɛ́n ó o wee bío bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ó o nì-kenínii mu ɓúera van là a Yeesu cɔ̃́n, á tùara a yi: «Ɲúhṹso, lé o yɛ́n fo wee bío bìo?» ");
INSERT INTO boxNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ó o Yeesu bía: «Ĩ zoó cĩ̀ ho búurú, ká yìa á ĩ nɔn ho yi, se wón lé orɛ́n.» Ó o Yeesu wã́a lá ho búurú zoó cã̀ á nɔn o Zudaa na lé o Simɔn Isikariote za yi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","O Zudaa féeníi lè ho búurú, ó o Satãni dɛ̀ɛnía zon wo. Ó o Yeesu bía nɔn o Zudaa yi: «Bìo fo le fo ò wé, à ũ wé fùa.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Á ɓa nì-kenínia na ká tĩ́ahṹ á nì-kéní woon yí zũ bìo nɔn ó o Yeesu bíaráa làa wo kà síi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bìo ó o Zudaa ɓa ɓunɓua-wárí wi cɔ̃́n, á ɓa ɓúi wee leéka le o Yeesu wi ò o bío le o vaa yà bìo ɓa màkóo wi yi ho sã́nú bìo yi. Tàá ká a Yeesu wi ò o Zudaa mu na bìo ɓúi ɓa nì-khenia yi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bìo ó o Zudaa wã́a fó ho búurú kà síi, ò o dɛ̀ɛnía hĩ́nɔn yòó ló. Mu wee wé à ho tá hũn. ");
INSERT INTO boxNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","O Zudaa léró mɔ́ndɛ́n, ó o Yeesu bía: «Hã laà na kà wán, ó o *Nùpue Za cùkú wee mi, ó o Nùpue Za mún wee zéení le Dónbeenì cùkú. ");
INSERT INTO boxNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ká a Nùpue Za wee zéení le Dónbeenì cùkú á le mún ǹ wé ó o Nùpue Za cùkú mún ǹ mi, á le è wé mu hen làa cĩ́inú. ");
INSERT INTO boxNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ĩ nì-kenínia na á ĩ wa làa sòobɛ́ɛ, ho pã̀ahṹ na á ĩ ì wé làa mia á yí túee. Mi khíi wé è cà mi. Ɛ̀ɛ ká bìo á ĩ bía nɔn ɓa *zúifùwa yi, lé bṹn ɓàn síi á ĩ mún ǹ bío á à na minɛ́n yi: Mi yí dà máa va hen na á ĩ wee va yi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ĩ ì bío bín-fĩnle ɓúi á à hení ì na mia: Mi wé wań mín. Mi ko mi wé wań mín, làa bìo á ĩ waráa mia bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ká mi wa mín, á ɓa nùpua ɓúenɓúen màhã́ à zũń le mi lé ĩ nì-kenínia.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ó o Simɔn Piɛre tùara a yi: «Ɲúhṹso, lé wen á fo ò va yi?» Ó o Yeesu bía nɔn wo yi: «Hã laà na kà wán, á fo yí dà máa bè làa mi máa va hen na á ĩ wee va yi. Ká fo màhã́ khíi bè làa mi làa mɔ́ndɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ó o Simɔn Piɛre bía nɔn wo yi: «Ɲúhṹso, lée webio nɔn á ĩ yí dà máa bè làa fo hã laà na kà wán? Ĩ tà à ĩ ì dé ĩ mukãnì na ũ bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ó o Yeesu bía: «Fo ò tà á à dé ũ mukãnì ì na ĩnɛ́n bìo yi kɛ̃́nkɛ̃́n le? Le ĩ mì ho tũ̀iá na foǹ: Sã́ni o kò-bɛ́ɛ wá, ká fo bía le fo yí zũ mi hã cúa-tĩn.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","O Yeesu bía nɔn mí nì-kenínia yi: «Mi yí yáa mi yilera. Mi dé mi sĩa le Dónbeenì yi, à mún dé mi sĩa miì. ");
INSERT INTO boxNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wàn Maá zĩi á hã kɛɛnínía lùa cɛ̀rɛ̀ɛ wi yi. Ká mu lá yí bon, se ĩ lá yí bía le ĩ vaá wíoka lùe á à ká làa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ká le lùe vaá wíokaa vó, á ĩ bĩní ɓueé fé mia, à mi vaa páaní kɛɛní làa mi hen na á ĩ ì kɛń yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mi zũ ho wɔ̃hṹ na wee va hen na á ĩ wà à va yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ó o Toma bía nɔn wo yi: «Ɲúhṹso, bìo wa yí zũ ũ vɛɛníi, á wa à zũń ho wɔ̃hṹ kaka?» ");
INSERT INTO boxNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ó o Yeesu bía nɔn wo yi: «Ĩnɛ́n lé yìa lé ho wɔ̃hṹ, á lé ho tũ̀iá poni ɓànso, lé ĩnɛ́n le mukãnì binbirì wee lé cɔ̃́n. Nùpue yí dà máa va a Maá cɔ̃́n ká ɓànso yí ló ĩ wán. ");
INSERT INTO boxNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ká mi lá zũ mi, ó o Maá á mi mún ǹ zũń. Hã laà na kà wán, ó o Maá mi zũ, á mɔn wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ó o Filiipu bía nɔn o Yeesu yi: «Ɲúhṹso, zéení a Maá làa wɛn, á bṹn wã́a à yí wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ó o Yeesu bía nɔn wo yi: «Éee! Filiipu, ĩnɛ́n wi làa mia míana, à ũ pá yí zũ mi le? Yìa mɔn mi, se ɓànso mɔn o Maá. Á fo tĩ́n le ĩ zéení a Maá làa fo le we? ");
INSERT INTO boxNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Á le fo yí tà le ĩnɛ́n páanía là a Maá ó o Maá páanía làa mi lon? Hã bíoní na á ĩ wee bío na mia á ĩnɛ́n yí te. Hã bíoní mu wee lé o Maá na wi làa mi cɔ̃́n. Lé orɛ́n wee wé bìo ó o sĩi vá yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mi tà bìo á ĩ bía nɔn mia yi le ĩnɛ́n páanía là a Maá ó o Maá páanía làa mi. Ká bṹn mía à mi pá wã́a tà mu bè-wénia na á ĩ wó á mi mɔn bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Le ĩ mì ho tũ̀iá na mia: Yìa dó mí sĩi miì, á ɓànso ò wé hã wárá na á ĩ wee wé ɓàn síi. O yàá à wé hĩ̀a po hɔ̃́n, lé bìo á ĩ wee va a Maá cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Á bìo ɓúenɓúen na mi wé è fìo ĩ yèni yi á ĩ ì wé, bèra a na ò o Maá yèni lé ĩnɛ́n na lé o Za pànká yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ká mi wé fìora bìo ɓúi ĩ yèni yi, á ĩ ì wé mu.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ká mi wa mi, á mi wé è bè bìo á ĩ henía nɔn mia yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Á ĩnɛ́n á à fìo o Maá yi, ó o na a Séenílo veere mia, ò o wé kɛń làa mia fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","O Séenílo mu lé le Dónbeenì Hácírí tũ̀iá poni ɓànso, dén na á ho dĩ́míɲása yí dà máa yí, lé bìo á ɓa yí máa mi le, á yí zũ le. Minɛ́n bán zũ le, lé bìo le wi làa mia, á khíi kɛń mia. ");
INSERT INTO boxNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Ĩ máa día á mi máa wé lòn híiminí, ĩ ì bĩní ì ɓuen mi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hen làa cĩ́inú ká ho dĩ́míɲása máa mi mi, ká minɛ́n bán ǹ mi mi, lé bìo á le mukãnì binbirì wi miì á minɛ́n le mukãnì binbirì mún ǹ wé yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ká mu pã̀ahṹ khíi dɔ̃n, á mi ì zũń le ĩnɛ́n páanía lè ĩ Maá, á minɛ́n páanía làa mi, á ĩnɛ́n páanía làa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yìa wee pa ĩ bíoní na á ĩ bò henía bìo, á wee bè hã yi, wón lé yìa wa mi. Ĩ Maá á à wań yìa wa mi, á ĩnɛ́n mún ǹ wań ɓànso, á wé è zéení ĩten làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ó o Zudaa, yìa wi mí dòn làa Zudaa Isikariote, bía nɔn wo yi: «Fo ò wé kaka à zéení ũten làa wɛn ká fo máa zéení ũten lè ho dĩ́míɲása?» ");
INSERT INTO boxNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ó o Yeesu bía nɔn wo yi: «Yìa wa mi, wón wee bè bìo á ĩ wee bío yi. Ĩ Maá á à wań ɓànso, á ĩ Maá làa mi á à ɓuen ɓànso cɔ̃́n, á ɓueé kɛń làa wo. ");
INSERT INTO boxNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yìa yí wa mi, wón yí máa bè ĩ bíoní yi. Hã bíoní na á ĩ wee bío kà yí ló ĩnɛ́n ĩ bɛɛre yi. Mu lé ĩ Maá na tonkaa mi á hã ló yi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Ĩ bía bìo kà nɔn mia ho pã̀ahṹ na á ĩ wi làa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ɛ̀ɛ ká a Séenílo na lé le Dónbeenì Hácírí, dìo ó o Maá Dónbeenì á à tonka ĩ yèni yi, dén wé è kení mia lè mu bìo ɓúenɓúen, á à bĩní ì leéka mia lè mu bìowa ɓúenɓúen na á ĩ bía nɔn mia. ");
INSERT INTO boxNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Ĩ wee lɛ́n, ká ĩ màhã́ a na ho hɛ́ɛrà mia. Ĩ hɛ́ɛrà lé hìa á ĩ wee na mia. Ho wi mí dòn lè ho dĩ́míɲá hɛ́ɛrà. Mi yí le mi yilera yáa. Mi yí zɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mi ɲá à ĩ bía le ĩ wee lɛ́n, ká ĩ bĩní ì ɓuen mi cɔ̃́n. Mi lá wa mi, se bìo á ĩ bía le ĩ va a Maá cɔ̃́n á mi sĩa lá à wa bìo yi, lé bìo ó o Maá po mi. ");
INSERT INTO boxNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ĩ bía mu nɔn mia hã laà na kà wán, ká mu bìowa mu wéró dĩǹ yí dɔ̃n, bèra a na, ká mu khíi dɔ̃n, à mi wíoka dé mi sĩa miì. ");
INSERT INTO boxNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ĩ máa bĩní máa bío bíoní cɛ̀rɛ̀ɛ làa mia, lé bìo á ho dĩ́míɲá na kà ɲúhṹso wà a ɓuen. O yí yú pànká ĩ wán. ");
INSERT INTO boxNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ɛ̀ɛ ká ho dĩ́míɲása ko ɓa zũń le ĩ wa a Maá, á bìo ó o bò henía nɔn miì lé bṹn á ĩ wee wé. Mi lii hĩ́ní, mi wa lɛ́n hen.» ");
INSERT INTO boxNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O Yeesu bía: «Ĩnɛ́n lé ho èrézɛ̃́n vĩ̀ndɛ̀ɛ binbirì, ká ĩ Maá lé ho èrézɛ̃́n vĩ̀ndɛ̀ɛ ɓànso. ");
INSERT INTO boxNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ká lakahó lée lakahó na can miì à ho yí máa ha, ó o ò kúii ho. Ká hĩ̀a wee ha, hɔ̃́n ɓúenɓúen ó o wee kí, à hã wíoka wé ha lè mí sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Làa bṹn síi á minɛ́n dɛ̀ɛnía wee ce vó lòn lakara na ɓa kú ĩ kàránló na á mi tà yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mi páaní làa mi, á ĩ mún ǹ páaní làa mia. Lakahó yí dà máa ha bia ká ho yí can le vĩ̀ndɛ̀ɛ yi. Làa bṹn síi, ká minɛ́n mún yí páanía làa mi, á le Dónbeenì Hácírí bìa máa kɛń mia. ");
INSERT INTO boxNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ĩnɛ́n ka lòn vĩ̀ndɛ̀ɛ, ká minɛ́n ka lòn lakara. Yìa páanía làa mi, á ĩnɛ́n páanía làa wo, á wón ɓànso á le Dónbeenì Hácírí bìa á à kɛń yi cɛ̀rɛ̀ɛ. Ĩnɛ́n bìo níi mía, á mi yí dà dɛ̀ɛ woon máa wé. ");
INSERT INTO boxNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yìa yí páanía làa mi ka lòn vĩ̀ndɛ̀ɛ lakara na ɓa kúiora lée kúaará. Ká hã lakara mu hon à ɓa khuii hã bè mín wán à dé ho dɔ̃hṹ yi cĩ̀í. ");
INSERT INTO boxNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ká mi páanía làa mi, á wee bè ĩ bíoní yi sese, à bìo mi wee cà, à mi fìo, á mi ì yí mu. ");
INSERT INTO boxNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ká le Dónbeenì Hácírí bìa wi mia cɛ̀rɛ̀ɛ se mu wee zéení le mi lé ĩ nì-kenínia binbirí, á ɓa nùpua ɓúenɓúen á à mi ĩ Maá cùkú mu bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Làa bìo ó o Maá waráa mi, lé bṹn ɓàn síi á ĩnɛ́n mún waráa mia. Mi páanía làa mi, á mi ì wíoka à zũń bìo á ĩ waráa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ká mi wee bè bìo á ĩ bò henía yi, se mi páanía làa mi á mi ì zũń bìo á ĩ waráa mia bìo, làa bìo ĩnɛ́n páanía là a Maá á zũ bìo ó o waráa mi, lé bìo á ĩ bò bìo ó o bò henía yi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Ĩ bía bṹn nɔn mia, bèra a na à ĩnɛ́n sĩ-wɛɛ ɓàn síi à kɛń mia, à mi sĩ-wɛɛ ɲii sí. ");
INSERT INTO boxNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bìo á ĩ ì hení á à na mia lé bìo kà: Mi wań mín làa bìo á ĩ waráa mia bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nùpue na dà à wań mín bɔ̃́nlowà á à poń yìa nɔn mí mukãnì ɓa bìo yi wón mía. ");
INSERT INTO boxNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ká mi wee bè bìo á ĩ bò henía nɔn mia yi, á mi ì wé wàn bɔ̃́nlowà. ");
INSERT INTO boxNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ĩ wã́a máa bĩní máa ve mia làa ton-sáwá, lé bìo ó o ton-sá yí zũ bìo ɓa ɲúhṹso wee wé. Mi lé wàn bɔ̃́nlowà, lé bìo á bìo ó o Maá bía nɔn miì ɓúenɓúen á ĩ fɛɛra nɔn mia. ");
INSERT INTO boxNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Minɛ́n yí léra mi. Ĩnɛ́n lé yìa hueekaa mia á tonkaa, à mi lɛ́n vaa wé hã wárá na se, hĩ̀a le Dónbeenì Hácírí bia wee mi yi, á bìo á à mía, bèra à na ká bìo mi wee fìo o Maá cɔ̃́n ĩ yèni yi à mi yí mu. ");
INSERT INTO boxNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bìo á ĩ ì wíoka à hení á à na mia lé bìo kà: Mi wań mín.» ");
INSERT INTO boxNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Ká ho dĩ́míɲása ɲina mia, à mi zũń le ɓa ɲina mi ló mia. ");
INSERT INTO boxNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ká minɛ́n lè ho dĩ́míɲása lá lée dà-kéní, á ɓa lá à wań mia làa bìo ɓa waráa bìo bìo sã̀ ɓa yi. Bìo nɔn á ho dĩ́míɲása ɲinanáa mia, lé bìo á ĩ hueekaa mia á mi wi mí dòn làa ba. Mi bìo wã́a yí sã̀ ho dĩ́míɲá yi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mi liiní mi hácírí bìo á ĩ bía nɔn mia wán: ‹Ton-sá na po mi ɲúhṹso wón mía.› Ká ĩnɛ́n á ɓa beéra lò, á minɛ́n á ɓa mún ǹ beé lò. Ká ɓa bò bìo á ĩ kàránna làa ba yi, á ɓa mún ǹ bè minɛ́n kàránló yi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɛ̀ɛ ká lé ĩnɛ́n bìo yi á ɓa wé è beéráa mi lò, lé bìo ɓa yí zũ yìa tonkaa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bìo á ĩ ɓuara á ɓueé bía làa ba á ɓa pã́, lé bṹn nɔn á mu bè-kohó bìo wee mì lɛɛ́ra ɓa yi. Á bìo kà wán, á ɓa wã́a yí dà máa bío le mí yí zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yìa ɲina mi, se wón mún ɲina ĩ Maá. ");
INSERT INTO boxNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ĩ lá yí wó wárá na á nì-veere yí dà máa wé hùúu ɓa tĩ́ahṹ, á se bè-kohó bìo máa mì máa lɛɛ́ ɓa yi. Ɛ̀ɛ ká bìo ɓa mɔn mu mí cúee, à ɓa pá ɲina ĩnɛ́n, á ɲina ĩ Maá. ");
INSERT INTO boxNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɛ̀ɛ ká bìo túara ɓa làndá yi á ko mu wé à ɲii sí: ‹Ɓa ɲina mi ká mu ɲúhṹ ɲɔǹ mía.› ");
INSERT INTO boxNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«O Séenílo khíi ɓuen. Orɛ́n lé le Dónbeenì Hácírí tũ̀iá poni ɓànso. Ĩ ì tonka a, ó o ò lé ĩ Maá cɔ̃́n á à ɓuen. Ká a khíi ɓuara ó o ɓuee mì ho tũ̀iá ĩ ɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Á minɛ́n mún wé è mì ho tũ̀iá ĩ ɲii, lé bìo mi wi làa mi hàrí ĩ tonló ɓúakáró pã̀ahṹ.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ĩ wee bío bṹn na mia à mi yí bĩní ĩ mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mi kàránló zĩní zoró á ɓa khíi wé è hè làa mia. Hàrí pã̀ahṹ ɓúi khíi dã, á bìa wee ɓúe mia pá à leéka le mí wee sá na le Dónbeenì yi kà síi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓa à wé mu lé bìo ɓa yí zũ a Maá Dónbeenì, á mún yí zũ ĩnɛ́n ");
INSERT INTO boxNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ká ĩ wee bío mu làa mia bèra a na ká ɓa khíi hĩ́nɔn wee wé mu, à mi bĩní leéka le ĩ bía mu nɔn mia. Ĩ tonló ɓúakáró pã̀ahṹ, á ĩ yí bía mu làa mia, lé bìo á ĩ lá wi làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Hã laà na kà wán, á ĩ bĩnía wee va yìa tonkaa mi cɔ̃́n, á mi tĩ́ahṹ á nì-kéní kà yí tùara miì le lé wen á ĩ wee va yi? ");
INSERT INTO boxNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ɛ̀ɛ ká lé bìo á ĩ bía mu nɔn mia lé bṹn wee vá mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ká mu ɓɛ̀n lé ho tũ̀iá á ĩ mì á à na mia: Mu sṹaaní minɛ́n cɔ̃́n à ĩ lɛ́n. Ká ĩ yí wà, ó o Séenílo máa ɓuen mi cɔ̃́n. Ɛ̀ɛ ká ĩ van, á ĩ ì tonka a ó ò ɓuen mi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ká a khíi ɓuara, ó o ɓueé zéení lè ho dĩ́míɲása le ɓa wee vĩ́iní míten mu bè-kora, làa bìo térénna, lè le Dónbeenì cítíi bìo dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","O ò zéení le ɓa wó mu bè-kohó, lé bìo ɓa yí dó mí sĩa miì. ");
INSERT INTO boxNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","O ò zéení le ĩ térénna bìo á ĩ wee va a Maá cɔ̃́n á mi máa bĩní máa mi mi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Le Dónbeenì cítíi bìo dã́ní yi, o ò zéení le le Dónbeenì dɛ̀ɛnía cítío ho dĩ́míɲá na kà ɲúhṹso á síinía ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Bìo cɛ̀rɛ̀ɛ á ĩ lá wi à ĩ bío na mia, ká ĩ dĩǹ máa bío mu lé bìo mu here po mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ká le Dónbeenì Hácírí tũ̀iá poni ɓànso khíi ɓueé dɔ̃n, á le è wé á mi ì zũń le Dónbeenì tũ̀iá poni ɓúenɓúen. Hã bíoní na le è bío máa lé lerɛ́n mí bɛɛre cɔ̃́n. Ká bìo le ɲá ĩ cɔ̃́n ɓúenɓúen lé bṹn á le khíi bío, á à bue bìo ko à mu ɓuen bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Le è zéení ĩ cùkú lé bìo le è lá bìo á ĩ le le zéení á à bue è na mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bìo bìo sã̀ a Maá yi ɓúenɓúen bìo sã̀ miì, lé bṹn nɔn á ĩ wee bíoráa mu na mia le le è lá bìo á ĩ le le zéení ɓúenɓúen á à bue è na mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Hen làa cĩ́inú ká mi máa mi mi, ká cĩ́inú bṹn mɔ́n á mi ì bĩní ì mi mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ó o nì-kenínia nùwã yɛn wee bío mín yi: «Bìo kà kúará lée webio coon? O bía: ‹Hen làa cĩ́inú ká mi máa mi mi, ká cĩ́inú bṹn mɔ́n á mi ì bĩní ì mi mi› làa bìo ó o bĩnía bía: ‹Bìo á ĩ wee va a Maá cɔ̃́n.› ");
INSERT INTO boxNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ho cĩ́inú na ó o wee bío bìo kúará lée webio? Wa ɓɛ̀ntĩ́n yí zũ bìo ó o wee bío.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bìo ó o Yeesu zũna le ɓa wi ɓa tùa wo yi, ó o bía nɔn ɓa yi: «Bìo á ĩ bía le hen làa cĩ́inú ká mi máa mi mi, ká cĩ́inú bṹn mɔ́n á mi ì bĩní ì mi mi, lé bṹn bìo yi á mi wee tùakaráa mín yi le? ");
INSERT INTO boxNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Àwa, le ĩ mì ho tũ̀iá na mia: Mi khíi wé è wá ká mi ì zúnzúrá ká ho dĩ́míɲása bán wee zã̀maka. Mi yara khíi sè, ɛ̀ɛ ká mi yara sèró mu màhã́ á à yèrèmá à wé le sĩ-wɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hen ká a hã́a wee te à mu wé le lònbee o wán hón pã̀ahṹ so yi. Ká a ton vó, ò o sĩi wa, lé bìo ó o yú a kúnkúza. O wé nɔnsã le lònbee na yú a yi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Minɛ́n mún bìo ka kà. Bìo kà wán, á mi yara sò, ɛ̀ɛ ká ĩ bĩní ì mi mia, hón pã̀ahṹ so ká mi sĩa á à wa. Dén sĩ-wɛɛ so á nùpue máa hè yi làa mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ká dén wizonle so khíi dɔ̃n, á mi máa bĩní máa tùa miì làa bìo ɓúi. Le ĩ mì ho tũ̀iá na mia: Bìo ɓúenɓúen na mi khíi fìo o Maá cɔ̃́n ĩ yèni yi ó o ò na mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mi lá dĩǹ yí fìora bìo ɓúi ĩ yèni yi. Mi wé fìo, á mi ì yí, bèra a na à mi sĩ-wɛɛ ɲii sí. ");
INSERT INTO boxNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Ĩ wà hã wàhio á bíaráa bìo kà ɓúenɓúen nɔn mia. Ká pã̀ahṹ ɓúi khíi dã, ká ĩ máa wé è wà wàhio máa na mia. Ĩ khíi wé è bío bìo bìo ciran o Maá wéréwéré á à na mia. ");
INSERT INTO boxNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ká hón pã̀ahṹ so khíi dɔ̃n, á mi wé è fìo o Maá Dónbeenì yi ĩ yèni yi. Ĩ máa bío máa na mia le ĩ wé è fìo o Maá mu yi mi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mu bon. O Maá Dónbeenì mí bɛɛre wa mia, lé bìo mi wa mi á tà le ĩ ló a cɔ̃́n bìo bon á ɓuara. ");
INSERT INTO boxNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ĩ ló a cɔ̃́n á ɓuara ho dĩ́míɲá yi. Bìo kà wán, á ĩ wee lé ho dĩ́míɲá yi á à bĩní ì va a Maá cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ó o nì-kenínia bía nɔn wo yi: «Ó, o! Fo màhã́ wã́a wee bío làa wɛn wéréwéré ká fo máa wà wàhio. ");
INSERT INTO boxNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bìo kà wán, á wa wã́a zũ le fo zũ mu bìo ɓúenɓúen. Ũ màkóo mía à ũ pa le o ɓúi tùa foǹ. Bṹn lé bìo nɔn á wa tà le fo ló le Dónbeenì cɔ̃́n bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ó o Yeesu bía nɔn ɓa yi: «Mi tà mu hã laà na kà wán le? ");
INSERT INTO boxNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ɛ̀ɛ ká ho pã̀ahṹ lua, ho yàá ɓueé dɔ̃n vó, ká mi ì kɛ́nná á à lɛ́n mìn ɲúná yi á à día mi ĩ dòn. Ɛ̀ɛ ká ĩ mía ĩ dòn, o Maá Dónbeenì wi làa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ĩ bía bṹn ɓúenɓúen nɔn mia bèra a na à mi yí ho hɛ́ɛrà mi páaníló làa mi bìo yi. Mi lò ò be ho dĩ́míɲá pànká-sũmáa níi yi, ɛ̀ɛ ká mi hení mi sĩa, lé ĩ dàńna hã.» ");
INSERT INTO boxNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bìo ó o Yeesu bía kà síi vó, ó o hóonía mí yahó ho wáayi, ò o bía: «Ĩ Maá, ho pã̀ahṹ dɔ̃n. Wé zéení ĩnɛ́n na lé ũ Za cùkú, bèra a na à ĩnɛ́n ɓɛ̀n mún wé zéení ũnɛ́n cùkú. ");
INSERT INTO boxNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Fo nɔn ho pànká miì ɓa nùpua ɓúenɓúen wán bèra a na à ĩ dàń nanáa le mukãnì binbirì na máa vé bìa ɓúenɓúen na fo kàràfáa miì yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Le mukãnì binbirì na máa vé lé à ɓa zũń ũnɛ́n na lé le Dónbeenì binbirì na ɓàn síi mía, à zũń ĩnɛ́n Yeesu *Krista na fo tonkaa. ");
INSERT INTO boxNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ĩ wó á ɓa nùpua mɔn ũ cùkú ho tá wán ho tonló na fo le ĩ sá á ĩ sá á ho ɲii sú bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ĩ Maá, bìo kà wán, á ũ wé le ĩ bĩní yí ho cùkú ũ nìsã́ní, hìa á ĩ yú lè ho yahó ká bìo ɓúi dĩǹ yí léra.» ");
INSERT INTO boxNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Ĩ zéenía ũ bìo lè ɓa nùpua na fo hueekaa ho dĩ́míɲása tĩ́ahṹ á kàràfáa miì. Ɓa bìo sã̀ foǹ, ká fo kàràfáa ɓa miì, á ɓa bò ũ bíonì yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bìo kà wán á ɓa zũ le bìo ɓúenɓúen na fo nɔn miì á ló ũnɛ́n ũ bɛɛre cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mu bon. Hã bíoní na ũ nɔn miì lé hĩ̀a á ĩ fɛɛra nɔn ɓa yi. Á ɓa tà hã yi. Á ɓa zũna kɛ̃́nkɛ̃́n le ĩnɛ́n ló ũ cɔ̃́n ɓuara, á tà le ũnɛ́n lé yìa tonkaa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Ĩ yí máa fìo foǹ ho dĩ́míɲása ɓúenɓúen bìo yi. Bìa fo kàràfáa miì lé bán á ĩ wee fìo bìo yi, lé bìo ɓa bìo sã̀ foǹ. ");
INSERT INTO boxNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bìa ɓúenɓúen na bìo sã̀ miì á bìo sã̀ foǹ, á bìa ɓúenɓúen na bìo sã̀ foǹ á mún bìo sã̀ miì, á ĩ cùkú wee mi ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ĩnɛ́n bĩnía wee ɓuen ũ cɔ̃́n, ĩ wã́a máa kɛń ho dĩ́míɲá yi, ká ɓarɛ́n bán wi ho yi. Ĩ Maá na ɓàn síi mía, pa ɓa yi lè ũ pànká, hìa fo nɔn miì, bèra a na à ɓa wé le dà-kéní làa bìo á ũnɛ́n làa mi lé le dà-kénínáa. ");
INSERT INTO boxNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bìo á ĩ hĩ́a wi làa ba, á ĩ wó á ɓa bò bìo á ũnɛ́n karáa yi, ũ bìo na fo le ĩ zéení. Ĩ pan ɓa bìo á hàrí nì-kéní yí vṹnun, ká mu yínɔń yìa ko ò o vĩ́, bèra a na à bìo túara le Dónbeenì bíonì vũahṹ yi à ɲii sí. ");
INSERT INTO boxNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hã laà na kà wán á ĩ bĩnía wee ɓuen ũ cɔ̃́n, ká bìo á ĩ pá wi ho dĩ́míɲá yi, á ĩ wee bío hã bíoní na kà ɓúenɓúen, bèra a na à ɓarɛ́n mí bɛɛre yí le sĩ-wɛɛ na á ĩ yú á le ɲii sú ɓàn síi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ũ bíoní á ĩ fɛɛra nɔn ɓa yi. Ká ho dĩ́míɲása màhã́ ɲina ɓa, lé bìo ɓa bìo yí sã̀ ho dĩ́míɲá yi làa bìo á ĩnɛ́n bìo yí sã̀náa ho yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ĩ yí le ũ lén ɓa ho dĩ́míɲá yi, ká ũ màhã́ kã̀ní ɓa o *Satãni níi yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓa bìo yí sã̀ ho dĩ́míɲá yi làa bìo á ĩnɛ́n bìo yí sã̀náa ho yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ĩ Maá, wé à ɓa bìo sĩ̀ foǹ ɓúenɓúen ũ tũ̀iá poni pànká yi. Mu bon, ũ bíonì lé ho tũ̀iá poni. ");
INSERT INTO boxNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bìo fo tonkaa làa mi ho dĩ́míɲá yi, lé bṹn á ĩ mún wee tonkaráa ɓarɛ́n ho yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ĩnɛ́n ĩ bɛɛre nɔn ĩten foǹ ɓúenɓúen ɓa bìo yi, bèra a na à ɓarɛ́n ɓɛ̀n mún na míten foǹ ɓúenɓúen ũ tũ̀iá poni pànká yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ĩ yí máa fìo foǹ bìa dó mí sĩa miì bìo yi mí dòn. Ká bìa á à dé mí sĩa miì ɓa bíoní pànká yi, á ĩ mún wee fìo bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ĩ wee fìo foǹ bèra a na à ɓa ɓúenɓúen wé le dà-kéní. Ĩ Maá, làa bìo á ũnɛ́n páanía làa mi, á ĩnɛ́n páanía làa fo, mún wé le ɓarɛ́n páaní làa wɛn, bèra a na à ho dĩ́míɲása zũń le lé ũnɛ́n tonkaa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bìo fo wó ũ cùkú wee mi miì, lé bṹn ɓàn síi á ĩ mún wó ũ cùkú mu wee mi ɓa yi, bèra a na à ɓa wé lé dà-kéní làa bìo á ĩnɛ́n làa fo lée dà-kénínáa. ");
INSERT INTO boxNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mu bon, ĩnɛ́n páanía làa ba, á ũnɛ́n páanía làa mi. Bṹn wó bèra a na à ɓa páaníló làa wɛn ɲii sí, à ho dĩ́míɲása zũń le lé ũnɛ́n tonkaa mi, á fo wa ɓa làa bìo fo waráa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ĩ Maá, bìa fo kàràfáa miì á ĩ wi à ɓa kɛń hen na á ĩnɛ́n ǹ kɛń yi, bèra a na à ɓa mi ĩ cùkú, ho cùkú na fo dó miì lé bìo fo wara mi ká ho dĩ́míɲá dĩǹ yí léra. ");
INSERT INTO boxNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ĩ Maá na térénna, ho dĩ́míɲása yí zũ fo, ká ĩnɛ́n wón zũ fo, á bìa fo kàràfáa miì zũ le lé ũnɛ́n tonkaa mi. ");
INSERT INTO boxNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ĩ zéenía ũ bìo làa ba á ɓa zũ fo. Ĩ pá à wíoka wé è zéení mu làa ba, bèra a na à bìo fo wa lè ĩnɛ́n, à dén waminì so mún wé mi ɓarɛ́n yi, à ĩnɛ́n làa ba páaní.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bìo ó o Yeesu fìora vó, ó o Yeesu lè mí nì-kenínia hĩ́nɔn ló lée wà, á vaá kã́a ho Sedoron bonconì. Vĩ̀nsĩ̀a ɓuahó ɓúi wi bĩ́n ó o vaá zon yi làa ba. ");
INSERT INTO boxNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","O Zudaa na à dé o ò na zũ ho lahó mu. Lé bìo ó o Yeesu lá dàn ɓuen bĩ́n lè mí nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ho *Oroomu dásíwá kuure lè ɓa parowà na ɓa yankarowà ɲúnása lè ɓa *Farizĩɛwa tonkaa, lé bán ó o Zudaa mu wã́a dú yahó ɓuararáa hã vĩ̀nsĩ̀a ɓuahó mu yi. Ɓa nùpua mu ɓuan hã fĩ̀ntɛ̃́ɛna, lè hã kã́aní na ɓa zã̀nía, lè hã fio sĩ̀a. ");
INSERT INTO boxNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Bìo ó o Yeesu zũ bìo á à sá a yi ɓúenɓúen, ó o vá ɓueé ɓó ɓa yi, ò o tùara: «Lé o yɛ́n mi wee cà?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Á ɓa bía nɔn wo yi: «Lé o Yeesu, o Nazarɛɛte nìi.» Ó o Yeesu le mu lé mínɛ́n. Bṹn wee wé ká a Zudaa na dó a nɔn wi bĩ́n làa ba. ");
INSERT INTO boxNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bìo ó o Yeesu bía le mu lé mínɛ́n, á ɓa ló lè mí mɔ́n á lée lùiorá. ");
INSERT INTO boxNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ó o Yeesu tùara ɓa yi mu cúa-ɲun níi le lé o yɛ́n á ɓa wee cà. Á ɓa le lé o Yeesu, o Nazarɛɛte nìi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ó o Yeesu bía nɔn ɓa yi: «Ĩ mà mu nɔn mia le mu lé ĩnɛ́n. Á bìo mu lé ĩnɛ́n mi wee cà, á mi wã́a día bìa kà le ɓa lɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O Yeesu bía bṹn bèra a na à le bíonì na ó o bía à ɲii sí: «Bìa á ũ kàràfáa miì, á hàrí nì-kéní á ĩ yí vĩ́inía.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mu wee wé ò o Simɔn Piɛre ɓuan ho khà-tóní. Ó o dɛ̀ɛnía dò ho, á hà lè le *Dónbeenì yankarowà ɲúhṹso beenì ton-sá nín-tĩánì ɲikãahṹ kúio. O ton-sá mu yèni ɓa le Malekuusi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ó o Yeesu bía nɔn o Piɛre yi: «Dé ũ khà-tóní mí lóorè yi. Fo wee leéka le ĩ máa tà le lònbee na á ĩ Maá le le yí mi lon?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Á ɓa dásíwá lè mí ɲúhṹso, lè ɓa *zúifùwa ɲúnása parowà wã́a wìira a Yeesu á can. ");
INSERT INTO boxNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Á yìa ɓa ɓuan wo vannáa cɔ̃́n ho yahó lé o Aana. O Aana mu lé o Kayiifu ɓàn hio báa. Wón Kayiifu so lé le *Dónbeenì yankarowà ɲúhṹso le lúlúure mu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Lé orɛ́n hĩ́a zéenía ɓa zúifùwa ɲúnása, le mu sṹaaní ò o nùpue nì-kéní hí mu nìpomu ɓúenɓúen bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","O Simɔn Piɛre lè mí ninza nì-kenínii ɓúi bò a Yeesu mɔ́n. O nì-kenínii mu lè ɓa yankarowà ɲúhṹso zũ mín. Lé bṹn nɔn ó o dàńna yòó zonnáa ɓa yankarowà ɲúhṹso zĩ-beenì lún yi là a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ò o Piɛre wón dĩ̀n ho khũuhũ ho zũaɲii. Ká a nì-kenínii na so, yìa lè le Dónbeenì yankarowà ɲúhṹso zũ mín, wón bĩnía yòó ló á lée bía là a ton-sá hã́a na pan ho zũaɲii, ò o fó a Piɛre zonnáa. ");
INSERT INTO boxNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ó o ton-sá hã́a na lá pan ho zũaɲii wã́a tùara a Piɛre yi: «Ũnɛ́n so yínɔń o nìi mu nì-kenínii ɓúi le?» Ó o Piɛre bía: Ĩ yínɔń o nì-kenínii ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bìo le tɛ̀ɛnì wi, á ɓa ton-sáwá lè ɓa parowà zã̀nía hã hĩ́a wee huee, ó o Piɛre mún páanía wee huee làa ba. ");
INSERT INTO boxNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Le Dónbeenì yankarowà ɲúhṹso wee tùa o Yeesu yi, là a nì-kenínia bìo làa bìo ó o wee kàrán lè ɓa nùpua dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ó o Yeesu bía nɔn wo yi: «Ĩ bía mu wéréwéré ɓa zã̀amáa yahó. Pã̀ahṹ lée pã̀ahṹ, á ĩ lá wee wé kàrán ɓa nùpua ɓa zúifùwa kàránló zĩní yi lè le *Dónbeenì zĩ-beenì lún yi, hen na ɓa zúifùwa wee wé kúee mín wán yi. Ĩ yí sà ĩten yí wóráa bìo ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Lée webio nɔn fo wee tùaráa miì? Tùa bìa ɲá ĩ bíoní yi. Bán zũ bìo á ĩ bía.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bìo ó o Yeesu bía bṹn, á ɓa parowà nì-kéní ɓúi na dĩ̀n o nìsã́ní dó a sáahó yi, ò o bía nɔn wo yi: «Lé làa bṹn á ũ ko à ũ bío sĩ́náa le Dónbeenì yankarowà ɲúhṹso le?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ó o Yeesu bía nɔn wo yi: «Ká ĩ bía khon, à ũ zéení hen na á ĩ bía khon yi. Ká ĩ ɓɛ̀n bía se, á lée webio nɔn á fo vĩ́nanáa mi.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ó o Aana wã́a le ɓa ɓua a Yeesu varáa le Dónbeenì yankarowà ɲúhṹso beenì Kayiifu cɔ̃́n ká a pá can. ");
INSERT INTO boxNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bṹn wee wé ká a Simɔn Piɛre pá wi ho lahó dà-kéní na ó o lá wi yi á wee huee ho dɔ̃hṹ. Ó o ɓúi bía nɔn wo yi: «Ũnɛ́n so yínɔń o nìi mu nì-kenínii ɓúi le?» Ó o Piɛre pã́ ò o bía: «Ĩnɛ́n yínɔń o nì-kenínii.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bṹn mɔ́n á le *Dónbeenì yankarowà ɲúhṹso beenì ton-sá nì-kéní na te mín làa yìa ó o Piɛre hà ɲikãahṹ kúio á bía nɔn wo yi: «Ĩ so yí mɔn fo là a nìi mu hã vĩ̀nsĩ̀a ɓuahó yi le?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ó o Piɛre tĩ́n pã́ mu. Mí lahó yi ó o kò-bɛ́ɛ wá. ");
INSERT INTO boxNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɓa *zúifùwa ɲúnása wã́a fó a Yeesu o Kayiifu cɔ̃́n vannáa o *Oroomu nìi *Pilaate zĩ-beenì yi, yìa ho Oroomu bɛ́ɛ bàrá ho Zudee kɔ̃hṹ ɲúhṹ wán. Mu wó hã tá-tĩa yi. Bìa bò là a Yeesu mí bɛɛre yí zon le zĩi yi. Lé bìo ɓa wi ɓa ɓua míten sese le Dónbeenì yahó à díráa ho Paaki sã́nú ká ɓa wee ce. ");
INSERT INTO boxNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lé bṹn te bìo ó o Pilaate lóráa ɓa cɔ̃́n ho khũuhũ á lée tùara ɓa yi: «Lé mu yɛ́n á mi le o nìi mu wó khon bìo yi?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Á ɓa bía: «O lá yí wó yí khon se wa yí ɓuan wo yí ɓuararáa ũ cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ó o Pilaate bía: «Mi bĩní lɛ́n làa wo. Mi vaa cítí o à héha lè mi làndá.» Á ɓa bía: «Mi yí nɔn níi wɛn le wa ɓúe nùpue.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mu wó kà síi à le bíonì na ó o Yeesu bía á zéeníanáa bìo o ò híráa sìí, à ɲii sí. ");
INSERT INTO boxNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ó o Pilaate wã́a yèrèmáa yòó zon le zĩ-beenì yi ò o le ɓa ɓua a Yeesu ɓuee zoráa. Bìo ó o Yeesu ɓueé zon ó o tùara a yi: «Lé ũnɛ́n lé ɓa zúifùwa bɛ́ɛ le?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ó o Yeesu bía nɔn wo yi: «Fo zũna mu ũten bía lée, tàá lé ɓa ɓúi bía ĩ bìo nɔn foǹ?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ó o Pilaate bía: «Ĩnɛ́n so lée zúifù le? Mìn sìí nùpua lè mìn yankarowà ɲúnása lé bìa dó fo ĩ níi yi. Lée webio á fo wó?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ó o Yeesu bía nɔn wo yi: «Ĩ bɛ́ɛnì bìo yí sã̀ ho dĩ́míɲá na kà yi. Ká mu bìo lá sã̀ ho dĩ́míɲá na kà yi, se ĩ nùpua lá à hĩ́ní ì fi hã fio à ĩ yí yí yí zo ɓa zúifùwa ɲúnása níní. Ɛ̀ɛ ká ɓùeé, ĩnɛ́n bɛ́ɛnì yínɔń ho dĩ́míɲá na kà bɛ́ɛnì.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ó o Pilaate bía nɔn wo yi: «Á fo lé o bɛ́ɛ lon, tàá?» Ó o Yeesu bía nɔn wo yi: «Lé ũnɛ́n ũten bía mu, ĩ lé o bɛ́ɛ. Ĩ ɓueé ton ho dĩ́míɲá yi à zéení ho tũ̀iá poni lè ɓa nùpua. Yìa bìo sã̀ ho tũ̀iá poni yi wón wee ɲí bìo á ĩ wee bío.» ");
INSERT INTO boxNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ó o Pilaate tùara a yi: «Tũ̀iá poni lée webio?» Bìo ó o bía bṹn vó ó o tĩ́n ló lée yú ɓa zúifùwa á bía nɔn ɓa yi: «Ĩnɛ́n cɔ̃́n ó o nìi mu yí wó yí khon bìo woon yi. ");
INSERT INTO boxNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hen ká ho *Paaki sã́nú sansan dɔ̃n, à mi le ĩ lén o kàsó nìi ɓúi día. Àwa, á mi wi à ɓa zúifùwa bɛ́ɛ lé yìa à ĩ día le?» ");
INSERT INTO boxNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Á ɓa wee bío na a yi ká ɓa wãamaka: «Ɓùeé! Yí día wón. O Barabaasi lé yìa á ũ lén día.» Ò o Barabaasi ɲɔǹ hĩ́a lé o nì-kã́anii. ");
INSERT INTO boxNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ó o *Pilaate wã́a nɔn le ɲii ɓa dásíwá yi le ɓa ɓua a Yeesu lée ha lè hã làbàaní. ");
INSERT INTO boxNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ɓa dásíwá mu tã́ ho kìrí lè hã kíkara á dó a ɲúhṹ yi, à ɓa zĩ́inía wo lè ho kánɓun muhṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓa wee ɓuee dĩ̀n o yahó ká ɓa bío: «*Zúifùwa bɛ́ɛ, Foó!» Ká ɓa à dé o sáarà yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ó o Pilaate tĩ́n zoó ló mí zĩi yi, á lée bía nɔn ɓa zúifùwa yi: «Àwa, ĩ bía le ɓa ɓua a ɓuee léráa à mi zũń le ĩnɛ́n cɔ̃́n o nìi mu yí wó yí khon bìo woon yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","O Yeesu ɓa wã́a ɓuan lóráa ho khũuhũ, ká hã kíkara kìrí wi o ɲúhṹ yi, á mún zã́ ho kánɓun muhṹ. Ó o Pilaate bía nɔn ɓa zúifùwa yi: «Lé o nìi mu na wã́a.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bìo ɓa yankarowà ɲúnása lè ɓa parowà mɔn o Yeesu á ɓa wee bío pɔ̃́npɔ̃́n: «Ɓúɛɛ wo ho *kùrùwá wán! Ɓúɛɛ wo ho kùrùwá wán!» Ó o Pilaate bía nɔn ɓa yi: «Minɛ́n mi bɛɛre wã́a fé o vaa ɓúɛɛ ho kùrùwá wán. Ĩnɛ́n cɔ̃́n ó o nìi mu yí wó yí khon bìo woon yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Á ɓa zúifùwa bía nɔn wo yi: «Warɛ́n làndá yi, ó o nìi mu ko lè ho ɓúeró lé bìo ó o le mí lé le Dónbeenì Za.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bìo ɓa bía kà wíokaa zã́nía o Pilaate làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ó o wã́a bò mín là a Yeesu yòó zon le zĩ-beenì yi, á zoó tùara a yi: «Lée wen ũnɛ́n wee lé yi?» Ó o Yeesu yí dó mí ɲii wo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ó o Pilaate wã́a bía nɔn wo yi: «Éee! Lé ĩnɛ́n á fo le fo máa bíoráa le? Fo so yí zũ le ũ díaró tàá ũ ɓúɛɛró ho kùrùwá wán ɓàn pànká wi ĩnɛ́n cɔ̃́n le?» ");
INSERT INTO boxNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ó o Yeesu bía nɔn wo yi: «Fo yí dà máa yí pànká ĩnɛ́n wán, ká le Dónbeenì yí nɔn ho foǹ. Lé bṹn nɔn á yìa dó mi ũ níi yi wékheró ɓùaa á po ũnɛ́n wékheró.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","À lá bṹn ɲii wán ó o Pilaate wã́a wee cà bìo ó o ò díaráa o Yeesu ó o ò lɛ́n. Ká ɓa zúifùwa wíokaa wee bío pɔ̃́npɔ̃́n: «O nìi na kà á fo día ó o wà se fo yínɔń ho *Oroomu bɛ́ɛ ɓàn bɔ̃́nlo. Nùpue na le mí lée bɛ́ɛ se wón wee penka lè ho Oroomu bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bìo ó o Pilaate ɲá hɔ̃́n bíoní so, ó o le ɓa ɓua a Yeesu léráa ho khũuhũ à vaá dĩ̀ní ho lahó na ɓa le «Lún na hã hue-pɛnlɛnwà bá yi.» Mu heberemu ɓa le «Kabataa.» Lé hón lahó so ó o Pilaate lée kará yi mí cítíi fĩ̀iníi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mu wó le wizonle na lée hĩ́ní ì wé ɓa ho *Sabaa zoǹ, ho *Paaki sã́nú díró pã̀ahṹ, ká le wii yòó fárá. Ó o Pilaate wã́a bía nɔn ɓa zúifùwa yi: «Lé mi bɛ́ɛ na.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Á ɓa wee bío pɔ̃́npɔ̃́n: «Ɓúe o! Ɓúe o! Ɓúɛɛ wo ho kùrùwá wán.» Ó o Pilaate bía: «Mi wi à ĩ ɓúɛɛ mi bɛ́ɛ ho kùrùwá wán kɛ̃́nkɛ̃́n le?» Á le *Dónbeenì yankarowà ɲúnása bía nɔn wo yi: «Wa bɛ́ɛ ɓúi mía ká mu yínɔń ho Oroomu bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ó o Pilaate wã́a dó a ɓa níi yi le ɓa ɓúɛɛ ho kùrùwá wán. Á ɓa dásíwá wã́a fó a Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɓa nɔn o *kùrùwá wo yi, ó orɛ́n mí bɛɛre pã̀ á lóráa ho lóhó mɔ́n, ho lahó na ɓa le «Ɲún-ɓòkuee» yi. Mu heberemu á ɓa wee ve ho lahó mu làa «Kolokota.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lé hón lahó so ɓa ɓúaa wo yi ho kùrùwá wán. Ɓa mún ɓúaa ɓa nùpua nùwã ɲun ɓúi hã kùrùwáwá wán làa wo. O nì-kéní wi là a nín-tĩánì, ká a nì-kéní wi là a nín-káahó, ó orɛ́n zoó wi ho tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","O Pilaate nɔn le ɲii le ɓa túa bìo kà yòo ɓúɛɛ o Yeesu ɲúhṹ yi ho kùrùwá wán: «Yeesu, Nazarɛɛte nìi, Zúifùwa bɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ɓa *zúifùwa cɛ̀rɛ̀ɛ kàránna bìo túara a Yeesu ɲúhṹ yi, lé bìo ho lahó na ɓa ɓúaa wo yi yí nàyi lè ho lóhó, á mu mún túara lè mu heberemu lè mu latɛnmu, lè mu kɛrɛɛkimu. ");
INSERT INTO boxNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Á le Dónbeenì yankarowà ɲúnása wà ɓuara a Pilaate cɔ̃́n á ɓueé bía nɔn wo yi: «Fo lá yí ko à ũ túa ‹zúifùwa bɛ́ɛ›, ká ũ túa ‹o nùpue mu le mí le ɓa zúifùwa bɛ́ɛ.›» ");
INSERT INTO boxNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ó o Pilaate bía: «Bìo á ĩ túara á à dĩ̀n làa bìo mu dĩ̀nnáa.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bìo ɓa dásíwá ɓúaa o Yeesu vó, á ɓa nùwã náa na ɓúaa wo sankaa o sĩ̀-zĩ́nia á ká a báká na ɓa tã́ á bĩ̀iminì mía yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Á ɓa dásíwá wee bío mín yi: «Mi yí le wa lɛ̀ɛka ho à sankaráa ho. Mi wa wé le ɲún-sĩni bìo à zũńnáa yìa ho ò sĩ̀ yi.» Mu wó kà síi à le Dónbeenì bíonì vũahṹ bìo na túara à wé à ɲii sí: «Ɓa sankaa ĩ sĩ̀-zĩ́nia, á wó le ɲún-sĩni bìo à zũńnáa yìa á ĩ dà-zĩ́nii dà-kéní ɓúi sã̀ yi.» Á bṹn lé bìo ɓa dásíwá ɓɛ̀n wó. ");
INSERT INTO boxNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bìa dĩ̀n ɓó a Yeesu kùrùwá yi, lé ɓàn nu, lè ɓàn nu ɓàn hĩ́nló, là a Mari, o Kolopaasi ɓàn hã́a, á séenía a Mari na wee lé ho lóhó na ɓa le Makadala yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bìo ó o Yeesu mɔn mín nu, á mɔn mí nì-kenínii na ó o wa à wón dĩ̀n ɓàn nu nìsã́ní, ó o Yeesu bía nɔn mín nu yi: «Hã́a mu, lé ũ za na.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ò o bía nɔn o nì-kenínii mu yi: «Lé mìn nu na.» À wã́a lá hón pã̀ahṹ so ɲii wán, ó o nì-kenínii wã́a fó a á vaá ɓuan. ");
INSERT INTO boxNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bṹn mɔ́n, ó o Yeesu wã́a zũ le mu bìo ɓúenɓúen ɲii sú, ó o bía bìo kà: «Ɲu-hãní dà mi», à síinínáa le Dónbeenì bíonì vũahṹ bíonì ɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mu wee wé à dɛ̀ɛ ɓúi bàrá sùaráa bĩ́n á sú lè ho dìvɛ̃́n bè-ɲia, á ɓa dásíwá lá le dɛ̀ɛ na wee kũ̀iní mu ɲumu á cú le vĩ̀ndɛ̀-za ɓúi na ɓa le *izoopu ɓùɛɛnì yi á zìíra ho dìvɛ̃́n bè-ɲia yi yòó dá a Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bìo ó o Yeesu yɛ̀ɛra mu, ó o bía: «Mu bìo ɓúenɓúen ɲii wã́a sú.» Bìo ó o bía bṹn, ó o ɓúera mí ɲúhṹ ò o húrun. ");
INSERT INTO boxNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mu wó le wizonle na lée hĩ́ní ì wé ho *Sabaa zoǹ, à bìo á hón Sabaa so lée Sabaa beenì, á ɓa zúifùwa ɲúnása yí wi à ɓa día bìa ɓa ɓúaa hã kùrùwáwá wán. Á ɓa ɓueé fìora a Pilaate le o bío le ɓa fì ɓa zení à ɓa hí fùafùa à ɓa liiní ɓa. ");
INSERT INTO boxNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Á ɓa dásíwá wã́a ɓueé fù ɓa nùwã ɲun na ɓa ɓúaa o nìsã́a zení, ");
INSERT INTO boxNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","À ɓa le mí ì loń ò o Yeesu húrun. Lé bṹn te bìo ɓa yí fùráa o Yeesu zení. ");
INSERT INTO boxNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ká ɓa dásíwá nì-kéní màhã́ pá cú a dòkóní lè mí cànɓúa. Á le cãni lè mu ɲumu dɛ̀ɛnía ló bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yìa mà mu bìowa mu tũ̀iá á mɔn mu míten. Bìo ó o wee mì bon. O zũ kɛ̃́nkɛ̃́n le bìo mí wee mì lé ho tũ̀iá poni. O wee mì mu tũ̀iá bèra a na à minɛ́n mún dé mi sĩa o Yeesu yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mu bon. Mu wó kà bèra a na à bìo túara le Dónbeenì bíonì vũahṹ yi à ɲii sí: «Hàrí o hũule dà-kéní á yí fù.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Á mu mún pá bĩnía túara: «Ɓa à fá mí yìo yìa ɓa cú wán.» ");
INSERT INTO boxNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bìo á bṹn wó khĩína, ó o Zozɛɛfu na wee lé ho Arimatee lóhó yi á vaá fìora a *Pilaate le o na le níi mí yi le mí lá a Yeesu sãnía vaá nùu. Orɛ́n mún lé o Yeesu nì-kenínii ɓúi, ká a màhã́ lá yí wi à mu zũń lé bìo ó o wee zɔ̃́n ɓa *zúifùwa ɲúnása. Ó o Pilaate nɔn mu níi wo yi. Ó o Zozɛɛfu wã́a ɓueé lá a Yeesu nì-hínmu. ");
INSERT INTO boxNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ó o Nikodɛɛmu, yìa hĩ́a ɓuara a Yeesu cɔ̃́n ho tĩ́nàahṹ ɓúi yi, á mún ɓuara. O ɓuan mu bìo ɓúi na sãmu sĩ na wó lè ho míìrè á lùnkaa làa bìo ɓa le alowɛɛsi á ɓuararáa. Mu ɓúenɓúen yú hã kiloowa ɓóní làa pírú. ");
INSERT INTO boxNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ó orɛ́n là a Zozɛɛfu páanía lá a Yeesu nì-hínmu à ɓa kúaa mu bìo mu ho nùuló dɛ̀ɛ wán á bá là a Yeesu nì-hínmu, làa bìo ɓa zúifùwa wee wé nùunáa mí nì-hía. ");
INSERT INTO boxNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Vĩ̀nsĩ̀a ɓuahó ɓúi wi hen na ɓa ɓúaa o Yeesu ho *kùrùwá wán nìsã́ní á bú-fĩnle ɓúi wi yi á nùpue dĩǹ yí nùuna yi. ");
INSERT INTO boxNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lé dén ɓa dó a Yeesu yi, lé bìo mu zoǹ à ɓa zúifùwa wee wíoka míten á lée hĩ́ní ì wéráa ho Sabaa, à le búure mu mún sùaráa yi bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ho dimaasi zoǹ yìnbíi bùirìi, ó o Makadala Mari wà van le búure wán. Mu wee wé ká ho tá pá ka yùiíi. Ó o Mari mɔn à le hue-beenì na lá pon le búure ɲii á hɛ́ra. ");
INSERT INTO boxNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ó o lùwa vaá yú a Simɔn Piɛre là a nì-kenínii na ó o Yeesu wa, á bía nɔn ɓa yi: «Ɓa léra a Ɲúhṹso le búure yi, á wa yí zũ hen na ɓa dó a yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ó o Piɛre là a nì-kenínii na so wã́a wà van le búure ɲii. ");
INSERT INTO boxNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓa mí nùwã ɲun wee lùwí ká a nì-kenínii na so màhã́ dàn lùwí po a Piɛre, ó o vaá dɔ̃n ló a. ");
INSERT INTO boxNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ó o zoó ɓúɛɛra lora le búure yi, ó o mɔn ho nùuló dɛ̀ɛ à le día, ká a màhã́ yí zon. ");
INSERT INTO boxNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ó o Simɔn Piɛre ɲɔn o mɔ́n ɓueé dɔ̃n, á wón yòó zon le búure yi, á zoó mɔn ho nùuló dɛ̀ɛ à le día. ");
INSERT INTO boxNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","O mún zoó mɔn le nín-kéní na lá pon o yahó yi à le bun sese bàrá mí dòn, dén yí páanía yí bàrá lè ho nùuló dɛ̀ɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ó o nì-kenínii na lá ɓueé dɔ̃n ho yahó màhã́ yòó zon. Bìo ó o mɔn mu kà, ó o tà le o Yeesu vèera bìo bon. ");
INSERT INTO boxNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu bon. Le Dónbeenì bíonì vũahṹ bía le o Yeesu ko ò o vèe, ká ɓa nì-kenínia lá dĩǹ yí zũ le bíonì mu kúará. ");
INSERT INTO boxNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bṹn mɔ́n á ɓa nì-kenínia nùwã ɲun bĩnía khíɓon. ");
INSERT INTO boxNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ká a Mari wón bĩnía ɓuara ɓueé dĩ̀n le búure ɲii wee wá. O wee wá ká a ɓúɛɛ loń le búure yi. ");
INSERT INTO boxNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ó o mɔn le Dónbeenì tonkarowà na ló ho wáayi nùwã ɲun na zã́ hã sĩ̀-poa. Ɓa kará ho lahó na ó o Yeesu nì-hínmu lá wi yi. O nì-kéní kará làa hen na ó o ɲúhṹ lá dó yi, ò o nì-kéní kará làa hen na ó o zení lá dó yi. ");
INSERT INTO boxNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Á ɓa tonkarowà mu wee tùa o Mari yi: «Hã́a mu, lée webio nɔn fo wee wáráa?» Ó o Mari bía nɔn ɓa yi: «Ɓa ɓueé léra ĩ Ɲúhṹso á ĩ yí zũ hen na ɓa dó a yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bìo ó o Mari bía bṹn vó, ó o yèrèmáa khíi mɔn o Yeesu ò o dĩ̀n. Ká a màhã́ yí zũna a. ");
INSERT INTO boxNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ó o Yeesu wee tùa wo yi: «Hã́a mu, lée webio nɔn fo wee wáráa? Lée wée á fo wee cà?» Ó o Mari wã́a wee leéka le lé o vĩ̀nsĩ̀a ɓuahó ɓànso wee tùa mí yi, ó o bía: «Hen ká lé ũnɛ́n ɓueé léra a Yeesu mu à ũ zéení hen na fo dó a yi làa mi, á ĩ vaá lá a.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ó o Yeesu von wo: «Mari!» Ó o Mari dɛ̀ɛnía zũna a, ó o von o Yeesu lè mu heberemu: «Arabunii!» Mu kúará le: «Nì-kàránlo.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ó o Yeesu bía nɔn wo yi: «Día mi. Ĩ dĩǹ yí yòora ĩ Maá cɔ̃́n. Lɛ́n vaa yí bìa dó mí sĩa miì ɓúenɓúen, bìa lé wàn zàwa, à bío na ɓa yi le ĩ wee yòo ĩ Maá Dónbeenì na mún lé mìn Maá Dónbeenì cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ó o Makadala Mari mu wã́a wà vaá bía bìo kà nɔn ɓa nì-kenínia yi: «Ĩ mɔn o Ɲúhṹso!» Ò o Mari lá bìo ó o Yeesu bía á fɛɛra nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ho dimaasi kéní kéní mu zoǹ zĩihṹ, ó o Yeesu nì-kenínia kúaa mín wán le zĩi ɓúi yi. Ɓa pon hã wonna ɓúenɓúen á dóka, lé bìo ɓa zã́na ɓa *zúifùwa ɲúnása. Yìo ɓueé tĩ, ò o Yeesu ɓueé dĩ̀n ɓa tĩ́ahṹ, ò o bía nɔn ɓa yi: «Le ho hɛ́ɛrà kɛń làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bìo ó o bía bṹn vó, ó o zéenía mí níní lè mí dòkóní làa ba. Á ɓa nì-kenínia sĩa wan làa sòobɛ́ɛ bìo ɓa mɔn o Ɲúhṹso bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ó o Yeesu tĩ́n bĩnía bía nɔn ɓa yi: «Le ho hɛ́ɛrà kɛń làa mia. Bìo á ĩ Maá tonkaaráa mi ho dĩ́míɲá yi, lé bṹn ɓàn síi á ĩnɛ́n mún ǹ tonkaráa mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bìo ó o bía bṹn vó, ó o pɛ̀ɛra mí ɲii sɔ̃nsãmu kúaa ɓa wán ò o bía: «Mi yí le Dónbeenì Hácírí. ");
INSERT INTO boxNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hen ká mi wé tà sɛ́ra nùpue lée nùpue bè-kora día nɔn wo yi, á le Dónbeenì mún ǹ sɛ́n ɓànso bè-kora á à día. Ká mi wé pã́ le mi máa sɛ́n nùpue lée nùpue bè-kora máa día, á le Dónbeenì mún máa sɛ́n wón ɓànso bè-kora máa día.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pã̀ahṹ na ó o Yeesu ɓueé zéenía míten lè mí nì-kenínia, ká ɓa nì-kéní lá mía bĩ́n. O yèni ɓa le Toma, ɓa mún wee ve o làa Hénbéní. ");
INSERT INTO boxNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Á ɓa nì-kenínia na ká bía nɔn wo yi le mí mɔn o Ɲúhṹso. Ó o Toma bía nɔn ɓa yi: «Ká ĩnɛ́n yí mɔn hã hĩa fãani o níní yi, á yí bò ĩ nín-kíza hã wán, á yí bò ĩ níi o dòkóní fɔ̃nló wán, á ĩ máa tà mu.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ho dimaasi na sã̀ bĩ́n, á ɓa nì-kenínia tĩ́n kúaa mí wán le zĩi yi ká a Toma wi làa ba. Á ɓa pon hã wonna á dóka. Ó o Yeesu tĩ́n ɓuara ɓueé dĩ̀n ɓa tĩ́ahṹ, ò o bía nɔn ɓa yi: «Le ho hɛ́ɛrà kɛń làa mia.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ò o bía nɔn o Toma yi: «Ɓuee bè ũ nín-kíza ĩ níní fãani wán loń, à bè ũ níi ĩ dòkóní fɔ̃nló wán. Wã́a yí bĩní yí titika, ká ũ tà le ĩ vèera bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ó o Toma bía nɔn o Yeesu yi: «Fo lé ĩ Ɲúhṹso á lé ĩ Dónbeenì.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ó o Yeesu bía nɔn wo yi: «Fo dó ũ sĩi miì lé bìo á fo mɔn mi. Ká bìa màhã́ dó mí sĩa miì à ɓa yí mɔn mi bán ɲúná sĩ.» ");
INSERT INTO boxNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","O Yeesu pá bĩnía wó yéréké bìowa cɛ̀rɛ̀ɛ á ɓa nì-kenínia mɔn ká mu yí túara ho vũahṹ na kà yi. ");
INSERT INTO boxNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bìo túara kà lée bìo na à na à mi dàń tà le o Yeesu lé *Yìa le Dónbeenì mɔn léra, le o lé le Dónbeenì Za bìo bon, à bìo mi ì dé mi sĩa wo yi, à mi yí le mukãnì binbirì orɛ́n pànká yi. ");
INSERT INTO boxNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bṹn mɔ́n, ó o Yeesu bĩnía zéenía míten lè mí nì-kenínia. Bṹn wó ho Tiberiade vũ-beenì ɲii. Bìo kà lé bìo ó o zéenía lè míten làa ba. ");
INSERT INTO boxNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wizonle ɓúi, ó o Yeesu nì-kenínia ɓúi páanía wi. Ɓa lé o Simɔn Piɛre, là a Toma na ɓa wee ve làa Hénbéní, là a Natanayɛɛle na wee lé ho Kalilee kɔ̃hṹ lóhó na ɓa le *Kanaa yi, là a Zebedee zàwa, là a Yeesu nì-kenínia nùwã ɲun ɓúi. ");
INSERT INTO boxNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ó o Simɔn Piɛre bía nɔn bìa ká yi: «Ĩ ì lɛ́n vaá pa ɓa cewà.» Á ɓa le mí ì bè làa wo. Á ɓa wã́a zon ho woohṹ wà, á vaá pan fɛ́ɛɛ ho tá tɔ̃n à ɓa yí fò hàrí ceza yà-kéní. ");
INSERT INTO boxNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bìo ho tá wee tĩ, à bṹn ò o Yeesu ɓueé dĩ̀n mu ɲumu ɲii. Ká a nì-kenínia màhã́ yí zũna a. ");
INSERT INTO boxNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ó o Yeesu von ɓa tùara yi: «Wàn bɔ̃́nlowà, mi yú cewà le?» Á ɓa bía nɔn wo yi: «Wa yí fò dɛ̀ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ó o bía nɔn ɓa yi: «Mi wã́a lèe mi zùán dé lè ho woohṹ nín-tĩánì á mi ì yí ɓa cewà.» Á ɓa lèera ho zùán dó á vá le mí ì hóoní yòó dé ho woohṹ yi, á ɓa hóonía san lé bìo ho sú lè ɓa cewà. ");
INSERT INTO boxNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ó o nì-kenínii na ó o Yeesu wa wã́a bía nɔn o Piɛre yi: «Yìa dĩ̀n kà lé o Ɲúhṹso.» Bìo ó o Piɛre ɲá le o lé o Ɲúhṹso, ó o lá mí báká na ó o lá tɛra á zã́ ò o yéran zon mu ɲumu yi wee lé o Yeesu cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɓa nì-kenínia na ká bán pà ho woohṹ vá lè ɓa cewà na ɓa vũn cɛ̀rɛ̀ɛ ɓueé lóráa. Ɓa lá yí nàyi lè le ɓónɓóore, ɓa à yí lòn mɛɛterewa khĩmàni síi làa de. ");
INSERT INTO boxNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bìo ɓa lée dɔ̃n á ɓa mɔn hã donfũaa à ɓa cezàwa bò hã wán, á mɔn ho búurú. ");
INSERT INTO boxNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ó o Yeesu bía nɔn ɓa yi: «Mi lén ɓa cewà na mi vũn bùaa yɛn ɓúi ɓuennáa.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ó o Simɔn Piɛre yòó zon ho woohṹ ò o vá ho zùán lè ɓa cewà lée día. Ce-beera ɓúará-hèɲun làa pírú làa bùaa tĩn lé bìa ló ho zùán mu yi, à ho pá yí fáara. ");
INSERT INTO boxNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ó o Yeesu bía nɔn ɓa yi: «Mi ɓuee dí.» Ɓa ɓúenɓúen á yìa henía mí sĩi tùara a Yeesu yi le o lé o yɛ́n wón mía. Ɓa zũ le mu lé o Ɲúhṹso. ");
INSERT INTO boxNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ó o Yeesu vá ɓueé ɓó ɓa yi, ò o lá ho búurú lè ɓa cezàwa sankaa nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bìo kà lé mu zen cúa-tĩn ká a Yeesu wee zéení míten lè mí nì-kenínia o vèeró mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bìo ɓa dú vó, ó o Yeesu tùara a Simɔn Piɛre yi: «Zãn za Simɔn, fo wa mi po bìo á bìa ká waráa mi le?» Ó o Simɔn le: «Ũuu, Ɲúhṹso, fo zũ le ĩ wa fo.» Ó o Yeesu bía nɔn wo yi: «Wé pa bìa bìo sã̀ miì bìo làa bìo ó o pi-pa wee wé paráa mí pia bìo.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ó o Yeesu bĩnía tùara a yi mu cúa-ɲun níi: «Zãn za Simɔn, fo wa mi le?» Ó o Simɔn le: «Ũuu, Ɲúhṹso, fo zũ le ĩ wa fo.» Ó o Yeesu bía nɔn wo yi: «Wé pa bìa bìo sã̀ miì bìo làa bìo ó o pi-pa wee wé paráa mí pia bìo.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ó o Yeesu pá bĩnía tùara a yi mu cúa-tĩn níi: «Zãn za Simɔn, fo wa mi le?» Á mu ɓóonía a Simɔn Piɛre yi lé bìo ó o Yeesu tùara a yi mu cúa-tĩn níi le o wa mí le. Ó o bía nɔn o Yeesu yi: «Ɲúhṹso, fo zũ bìo ɓúenɓúen. Fo zũ le ĩ wa fo.» Ó o Yeesu bía nɔn wo yi: «Wé pa bìa bìo sã̀ miì bìo làa bìo ó o pi-pa wee wé paráa mí pia bìo. ");
INSERT INTO boxNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Le ĩ mì ho tũ̀iá na foǹ: Bìo á fo hĩ́a lé o yàró ká ũ wee ca ũ kuio ká ũ lɛ́n va hen na á ũ sĩi vá yi. Ká fo khíi kĩ́na po bìo kà, á ũ wé è bɛn ũ bàra á nì-veere ɓueé ca ũ kuio mu á à ɓua fo ò varáa hen na á fo yí wi á ũ va yi.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","O Yeesu bía hɔ̃́n bíoní so à zéenínáa bìo ó o Piɛre á à híráa sìí á à déráa ho cùkú le Dónbeenì yi. Bìo ó o bía hã bíoní mu vó, ó o le o Piɛre bè mí yi fɛ́ɛɛ. ");
INSERT INTO boxNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ó o Piɛre yèrèmáa khíi mɔn o nì-kenínii na ó o Yeesu wa ò o bò ɓa yi. O lé yìa nɔ̀nzoǹ ɓúera van là a Yeesu cɔ̃́n ká ɓa kará ho dĩ́nló ɲúhṹ yi á tùara a yi: «Ɲúhṹso o, lé o yɛ́n á à dé fo ò na?» ");
INSERT INTO boxNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bìo ó o Piɛre wã́a mɔn o nì-kenínii mu, ó o tùara a Yeesu yi: «Ɲúhṹso o, á wón na kà bìo ɓɛ̀n khíi wé kaka?» ");
INSERT INTO boxNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ó o Yeesu bía nɔn o Piɛre yi: «Hen ká ĩ wi ò o kɛń bĩ́n à ĩ bĩní ɓuee yí, se bṹn wã́a yí ciran fo. Ũnɛ́n día à ũ bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dén bíonì so bìo yi, á bìa tà a Yeesu bìo wã́a wee hɛ́ɛ bío le o nì-kenínii mu máa hí. Ò o Yeesu ɲɔǹ yí bía là a Piɛre le o nì-kenínii mu máa hí. O bía le: «Hen ká ĩ wi ò o kɛń bĩ́n à ĩ bĩní ɓuee yí, se bṹn wã́a yí ciran fo.» ");
INSERT INTO boxNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wón nì-kenínii nì-kéní kéní so lé yìa mà bìo wó kà tũ̀iá, á túara mu. Á wa mún zũ le bìo ó o mà, á bon. ");
INSERT INTO boxNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","O Yeesu pá bĩnía wó bìo cɛ̀rɛ̀ɛ. Ká ɓa lá le mí ì tè mu yi lè mí dà-kéní kéní á à túa, á hã vɔ̃nna na mu ù túa yi á kúeeníi lá máa yí lé hã booró.");
INSERT INTO boxNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofiile, bìo ó o Yeesu hĩ́a wee wé làa bìo ɓúenɓúen na ó o hĩ́a wee kení lè ɓa nùpua mí tonló ɲúhṹ ɓúaró pã̀ahṹ à vaa ɓúe bìo le Dónbeenì ɓuan wo yòoraráa ho wáayi á ĩ bía bìo ĩ nín-yání vũahṹ yi. Sã́ni ò o yòo ho wáayi, ó o bía mí sòobá-bíoní lè le Dónbeenì Hácírí pànká á nɔn ɓa nùpua na ó o hĩ́a hueekaa wó lè mí tonkarowà yi. ");
INSERT INTO boxNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bìo ó o húrun bĩnía vèera ó o zéeníkaa míten làa ba hã wizooní ɓúará-ɲun yi á wó bìo cɛ̀rɛ̀ɛ à ɓa zũń ká a yìo wi lua bìo bon. Hɔ̃́n wizooní so yi ká ɓa páanía wi mín wán, ó o wee bío le *Dónbeenì bɛ́ɛnì bìo na ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wizonle ɓúi ká a làa ba wee dí, ó o henía bìo kà nɔn ɓa yi: «Mi yí lé ho Zeruzalɛɛmu yi. Mi kɛɛní bĩ́n à pa bìo á ĩ fèra bía bìo làa mia, mu hãmu na á ĩ Maá dó mí ɲii le mí ì na. ");
INSERT INTO boxNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","O Zãn hĩ́a wee bátízé lè mu ɲumu ká minɛ́n bán á à bátízé lè le Dónbeenì Hácírí hen làa wizooní bìo yɛn.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Á bìa làa wo páanía kará tùara a yi: «Ɲúhṹso, lé hón pã̀ahṹ so á fo ò wíoka a *Isirayɛɛle nìpomu bìo á ɓa à kɛń míten le?» ");
INSERT INTO boxNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ó o Yeesu bía nɔn ɓa yi: «Ho pã̀ahṹ lè le wizonle á mi yí ko mi tùa zũń. O Maá mí dòn lé yìa bàrá mu míten. ");
INSERT INTO boxNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɛ̀ɛ ká pã̀ahṹ na le Dónbeenì Hácírí á à lii mi wán yi, á mi ì yí ho pànká. Mi ì wé ĩ sɛɛ́ràsa á à bío ĩ bìo ho Zeruzalɛɛmu yi, lè ho *Zudee lè ho *Samarii kãna ɓúenɓúen yi, lè ho dĩ́míɲá kùaráa ɓúenɓúen yi mún.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bìo ó o bía hɔ̃́n bíoní so vó, ó o ɓuan yòó wà ho wáayi ká ɓa dĩ̀n wee loń. Á le dùndúure ɓúi ló ɓueé tun wo yi, á ɓa yí máa mi a. ");
INSERT INTO boxNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bìo ɓa dĩ̀n fá mí yìo ho wáayi, hen na ó o Yeesu yòó wà yi, yìo ɓueé tĩ à báawa nùwã ɲun na zã́ hã sĩ̀-poa á dĩ̀n ɓa nìsã́ní, ");
INSERT INTO boxNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","á wee bío làa ba: «Kalileesa, mi dĩ̀n hen wee loń ho wáayi lée webio? O Yeesu mu na le Dónbeenì léra mi tĩ́ahṹ á ɓuan yòoraráa ho wáayi á khíi bĩní ì ɓuen làa bìo mi mɔnnáa wo ká a yòó wà bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bṹn mɔ́n á ɓa tonkarowà ló le ɓúee na ɓa wee ve làa Oliivewa vĩ̀nsĩ̀a ɓúee wán á bĩnía lion ho Zeruzalɛɛmu. Le ɓúee mu lè ho lóhó á à yí kilomɛɛtere dà-kéní síi. ");
INSERT INTO boxNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bìo ɓa lií zon ho Zeruzalɛɛmu yi, á ɓa vaá yòora ho nɔ́nwíohṹ na ɓa lá wee wé kúee mín wán yi. Bìa kɛra bĩ́n lé o Piɛre, o Zãn, o Zaaki là a Ãndere, o Filiipu là a Toma, o Baatelemii là a Matiye, o Alifee za Zaaki, o Simɔn na ɓa le Zeloote, là a Zaaki za Zudaa. ");
INSERT INTO boxNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓa ɓúenɓúen fù wó mí yilera làa dà-kéní, á wee kúee mín wán túntún à páaní fìo le Dónbeenì yi lè ɓa hã́awa ɓúi, là a Yeesu ɓàn zàwa lè ɓàn nu Mari. ");
INSERT INTO boxNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wizonle ɓúi, ká bìa tà a *Krista bìo na kúaa mín wán á à yí lòn nùpua ɓúará-hèzĩ̀n síi, ó o Piɛre hĩ́nɔn yòó dĩ̀n ɓa tĩ́ahṹ ò o bía: ");
INSERT INTO boxNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Wàn zàwa, bìo le Dónbeenì Hácírí bía là a *Daviide ɲii le Dónbeenì bíonì vũahṹ yi á lá ko à mu wé. Le fèra bía mu ho vũahṹ mu yi o Zudaa dã́ní yi, wón na dú bìa wìira a Yeesu yahó. ");
INSERT INTO boxNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","O Zudaa lá lé wa kuure nùpua nì-kéní, á níi lá wi ho tonló dà-kéní yi làa wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","Ho Zeruzalɛɛmusa ɓúenɓúen zũ mu le o wékheró wárí na ɓa sàánía làa wo, lé dìo ó o yà lè ho mɔhṹ. Hón mɔhṹ so lé hìa ó o lion yi lè mí yahó, á píohó nà, á fĩn-sãníwà ló kúaará ho tá yi. Lé bṹn te bìo ɓa wee veráa ho mɔhṹ mu làa «Hakɛlidama.» Ɓàn bíonì yi á mu kúará le «cãni mɔhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ó o Piɛre bĩnía bía: «Bìo túara hã lení vũahṹ yi lé bìo kà: ‹O zĩi ko le dĩ̀n coon à nùpue yí zo› Mu mún pá bĩnía túara: ‹O ɓúi ko ò o zo a lahó›. ");
INSERT INTO boxNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Lé bṹn nɔn ó o nùpue ɓúi ko ó o dé wa wán à wé o Ɲúhṹso Yeesu vèeró sɛɛ́ràso. Bìa ó o nùpue mu ko ò o lé tĩ́ahṹ, lé bìa làa wɛn páanía bò mín ho pã̀ahṹ ɓúenɓúen na ó o Ɲúhṹso Yeesu làa wɛn vará yi, à lá pã̀ahṹ na ó o Zãn Batiisi bátízéra wo ɲii wán, à vaa ɓúe pã̀ahṹ na ó o ɓuan yòora ho wáayi.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Á ɓa wã́a zéenía ɓa nùpua nùwã ɲun, o Matiasi là a Zozɛɛfu na ɓa wee ve làa Baasabaasi tàá Zusituusi. ");
INSERT INTO boxNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bṹn mɔ́n á ɓa ɓúenɓúen páanía fìora kà síi: «Ɲúhṹso, ũnɛ́n lé yìa zũ ɓa nùpua ɓúenɓúen sĩa. Zéení yìa á ũ léra ɓa nùwã ɲun na kà tĩ́ahṹ làa wɛn, ");
INSERT INTO boxNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","yìa á à zo a Zudaa lahó ũ tonkarowà tonló yi, hón na á wón ló día ò o van hen na ó o ko ò o va yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Á ɓa wó le ɲún-sĩni bìo à zũńnáa yìa le Dónbeenì léra, ó o Matiasi lé yìa á mu tò wán. Lé wón dó ɓa tonkarowà pírú dòn na ká wán. ");
INSERT INTO boxNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ho Pãntekoote zoǹ, á bìa tà a *Krista bìo ɓúenɓúen kúaa mín wán lahó dà-kéní yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yìo ɓueé tĩ à mu bìo ɓúi sã wee ɲí ho wáayi lòn pinpi-beenì na wee và lè mí pànká bìo síi, á ɓueé lií sú le zĩi na ɓa kará yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Á ɓa le mí ì loń à bìo ɓúi lòn dɔ̃hṹ dɛnní á sankaa lè mí dà-kéní kéní, á wi ɓa ɓúenɓúen wán. ");
INSERT INTO boxNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Á ɓa ɓúenɓúen sú lè le Dónbeenì Hácírí, á ɓa wee bío hã sìí-viò bíoní, làa bìo le Dónbeenì Hácírí mu le ɓa bíoráa. ");
INSERT INTO boxNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mu pã̀ahṹ ká ɓa *zúifùwa ɓúi na wee bè le Dónbeenì yi sese á ló ho dĩ́míɲá kãna ɓúenɓúen yi, á ɓueé kará ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bìo ɓa ɲá mu bìo mu sã, á ɓa dɛ̀ɛnía ɓueé fò mín ɓùiríɓùirí. Bìa tà a Krista bìo bìo na á ɓa wee bío á bìa wi bĩ́n lè mí nì-kéní kéní wee ɲí lè mín kùrú bíoní, á mu sòobáa vĩ̀níkaa ɓa dà. ");
INSERT INTO boxNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mu wó ɓa coon dàkhĩína á ɓa wee bío: «Ɓa nùpua mu na wee bío kà ɓúenɓúen so yínɔń Kalileesa le? ");
INSERT INTO boxNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Á mu ɓɛ̀n wó kaka á wa lè wa nì-kéní kéní wee ɲínáa bìo ɓa wee bío lè wàn kùrú bíoní? ");
INSERT INTO boxNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Warɛ́n na wi hen, á ɓa ɓúi lé ɓa Paatewa. Ɓa ɓúi ló ho Mɛdii lè ho Elaamu lè ho Mɛzopotamii kãna yi. Ɓa ɓúi ló ho *Zudee, lè ho Kapadoosi, lè ho Pɔ̃n, lè ho Azii kãna yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ɓa ɓúi ló ho Firizii, lè ho Pãnfilii, lè ho *Ezipite kãna, lè ho Libii kɔ̃hṹ sɔ̃́n-kéní na sùaráa lè ho Sirɛɛna yi. Bìa ló ho *Oroomu yi mún wi wa tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ɓa zúifùwa binbirí làa bìa yèrèmáa bò ɓa zúifùwa mu ɓàn Dónbeenì yi á mún wi hen. Ho Kɛrɛɛtesa lè ɓa araabuwà mún wi hen. Wa ɓúenɓúen á yìa yí máa ɲí le Dónbeenì bè-beera na le wó na ɓa wee bío lè wàn kùrú bíoní wón mía.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓa ɓúenɓúen wó coon, ɓa yí zũ mu sìí. Á ɓa wee bío làa mín: «Bìo kà màhã́ lée webio coon?» ");
INSERT INTO boxNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ká ɓa ɓúi bán ɓɛ̀n wee yáa mí ɲiní yi ká ɓa à bío: «Áyì, ɓa bùaa ɲun sù wee khée.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ó o Piɛre wã́a hĩ́nɔn yòó dĩ̀n lè mí ninzàwa tonkarowà pírú dòn, ò o bía pɔ̃́npɔ̃́n nɔn ɓa zã̀amáa yi: «Minɛ́n *zúifùwa lè minɛ́n na kará ho Zeruzalɛɛmu yi ɓúenɓúen, mi ɲí bìo á ĩ ì bío á a na mia sese: Mi ko à mi zũń bìo kà ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ɓa ɓúi wee leéka le ɓa nùpua mu ɲun sú wee khée, ɛ̀ɛ ká ɓùeé. Lé bìo á mu lé le yìnbíi lɛ́ɛ̀rèwa bìo dènú níi á wa wi yi! ");
INSERT INTO boxNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bìo ó o ɲi-cúa fɛɛro Zowɛɛle hĩ́a bía lé bṹn lan wee wé hã laà na kà wán. ");
INSERT INTO boxNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bìo kà lé bìo le Dónbeenì bía: ‹Hã pɔ̃̀nna vaa véeníi á ĩ ì bɛn ĩ Hácírí à le è fè ɓa nùpua ɓúenɓúen. Mi zà-báawa lè mi zà-hĩ́nni á wé è fɛɛ ĩ ɲi-cúa. Mi yàrón-fĩ̀a á wé è mi mu bìowa ɓúi na ɓa lá yí dà máa mi. Mi nì-kĩ́a á hã kònkórá wé è ɲì yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mu bon. Hɔ̃́n pɔ̃̀nna so yi á ĩ ì bɛn ĩ Hácírí á le è fè ɓa báawa lè ɓa hã́awa na lé ĩ ton-sáwá, á ɓa wé è fɛɛ ĩ ɲi-cúa. ");
INSERT INTO boxNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mu bìowa ɓúi na sìí yí zũ á ĩ ì lén yòó ho wáayi, á à wé mu yéréké bìowa ho tá wán. Le cãni, lè ho dɔ̃hṹ, lè le minka yiìní á à kɛń. ");
INSERT INTO boxNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Le wii á à dé mí yuumu á ho pĩihṹ á à wé cṹɛncṹɛn lòn cãni. Bṹn bìowa so ɓúenɓúen á à wé è vé ó o Ɲúhṹso wizon-beenì na cùkú wi á à dãnáa. ");
INSERT INTO boxNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hón pã̀ahṹ so yi ká nùpue lée nùpue na tà von o Ɲúhṹso yèni à wón á à fen.› ");
INSERT INTO boxNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«*Isirayɛɛlesa, mi ɲí bìo á ĩ ì bío á à na mia: O Nazarɛɛte nìi Yeesu fù lée nùpue na le Dónbeenì zéenía bìo làa mia le mí wiráa. Mu yéréké bìowa na wee zéení le Dónbeenì pànká na le wó là a níi mi tĩ́ahṹ, lé bṹn wee zéení mu. Minɛ́n miten yàá zũ mu. ");
INSERT INTO boxNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","O nìi mu á le Dónbeenì dó mí níní yi làa bìo á le wi à mu wéráa. Le fèra zũ bìo mi ì wé làa wo. Minɛ́n lé bìa dó a bìa yí zũ le Dónbeenì níi yi, á ɓa ɓúaa wo ho *kùrùwá wán, ó o húrun. ");
INSERT INTO boxNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ká le Dónbeenì màhã́ fáa wo mu húmú níi yi, le vèenía wo. Mu húmú lá yí dà máa yí pànká o wán hùúu. ");
INSERT INTO boxNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","O *Daviide hĩ́a bía bìo kà o dã́ní yi: Ĩ hĩ́a wee wé mi a Ɲúhṹso ĩ yahó fɛ́ɛɛ. Orɛ́n lé yìa wee ɓua miì bèra a na á ĩ yí dɛ̀dɛ́ɛka. ");
INSERT INTO boxNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lé bṹn nɔn á ĩ sĩi wan, á bíoní ɓúenɓúen lée sĩ-wɛɛ bíoní. Hàrí à ĩ zũń ĩ húmú bìo, á ĩ sĩi pá à hĩ̀. ");
INSERT INTO boxNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Lé bìo á fo máa día mi á ĩ máa va hen na ɓa nì-hía wee va yi. Fo máa tà ũ ton-sá na á ũ wa á máa soo. ");
INSERT INTO boxNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fo zéenía mi lè ho wɔ̃hṹ na wee va le mukãnì lahó yi. Hen ká ĩ wi ũ nìsã́ní à ĩ sĩi wa wa dà khĩí. ");
INSERT INTO boxNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Wàn zàwa, mi le ĩ bío wàn ɓùaa Daviide bìo wéréwéré na mia: O Daviide hĩ́a húrun á ɓa nùuna, á búure pá dà wee zéení ho zuia. ");
INSERT INTO boxNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bìo ó o hĩ́a lé le *Dónbeenì ɲi-cúa fɛɛro, á zũ le le Dónbeenì hĩ́a báa á dóráa mí ɲii nɔn le mí ì na a bɛ́ɛnì o mɔ̀nmànía nì-kéní ɓúi yi, ");
INSERT INTO boxNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ó o fèra zũna bìo wa ɓueé wé, ó o wã́a bía a *Krista vèeró bìo kà síi: Le Dónbeenì máa día ó o máa va hen na ɓa nì-hía wee va yi, le máa día ó o máa soo. ");
INSERT INTO boxNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«O Yeesu mu le Dónbeenì vèenía, á warɛ́n ɓúenɓúen lé mu sɛɛ́ràsa. ");
INSERT INTO boxNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","O ɓuan yòora le Dónbeenì nín-tĩánì. Lé bĩ́n ó o yú le Hácírí yi, dìo ó o Maá dó mí ɲii le mí ì na. O bɛra le fò wa nì-kéní kéní. Á bṹn lé bìo mi wee mi á wee ɲí lònbìo. ");
INSERT INTO boxNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","O Daviide wón yí yòora ho wáayi ká a màhã́ bía bìo kà: ‹O Ɲúhṹso bía nɔn ĩ Ɲúhṹso yi: Ɓuee kɛɛní ĩ nín-tĩánì, ");
INSERT INTO boxNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","fúaa ká ĩ ɓúrá ũ zúkúsa ũ tá, á ũ bò ũ zení wán.› ");
INSERT INTO boxNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Minɛ́n Isirayɛɛle nìpomu ɓúenɓúen ko à mi zũń mu kɛ̃́nkɛ̃́n le o Yeesu mu na mi ɓúaa ho kùrùwá wán lé wón le Dónbeenì wó là a Ɲúhṹso là a Krista.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bìo ɓa ɲá hã bíoní mu, á hã zon ɓa dàkhĩína, á ɓa tùara a Piɛre lè mí ninzàwa tonkarowà yi: «Wàn zàwa, á lé mu yɛ́n á wa ko à wa wé.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ó o Piɛre bía nɔn ɓa yi: «Mi yèrèmá mi yilera lè mi wárá, à mi nì-kéní kéní bátízé o Yeesu *Krista yèni yi, á mi bè-kora á à sɛ́n ǹ día. Bṹn ká le Dónbeenì á à na mí Hácírí mia. ");
INSERT INTO boxNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Le Dónbeenì dó mí ɲii nɔn minɛ́n lè mi mɔ̀nmànía yi, làa bìa na dã́ní nàyi, bìa ɓúenɓúen na ó o Ɲúhṹso á à ve.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","O Piɛre pá bĩnía bía hã bíoní cɛ̀rɛ̀ɛ á ɓó lè ɓa ɲúhṹ, á henía ɓa sĩa. O bía: «Ho lònbìo nùpua yí se, mi lé ɓa mɔ́n, à tà ho kã̀níló bìo.» ");
INSERT INTO boxNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓa cɛ̀rɛ̀ɛ tà a Piɛre bíoní yi á ɓa bátízéra ɓa. Mu zoǹ á bìa zon sã̀ bìa tà a *Krista bìo yi ɲii, á à yí nùpua muaaseé tĩn síi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɓa wee tà ɲí ɓa tonkarowà kàránló na á bán wee na ɓa yi sese, á hácírí wó dà-kéní, á wee páaní sanka ho búurú, à páaní fìo. ");
INSERT INTO boxNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɓarɛ́n lè mí nì-kéní kéní á mu zon dà. Ɓa tonkarowà wee wé ho yéréké bìowa na wee zéení le Dónbeenì pànká. ");
INSERT INTO boxNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bìa tà a Krista bìo ɓúenɓúen fù ɓunɓuaa, á wee páaní kúee mí níi bìo mín wán. ");
INSERT INTO boxNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓa fù wee yɛ̀ɛ́ mí manawà, lè mí zĩní, lè mí bìowa, à sanka wárí na mín yi làa bìo ɓa nì-kéní kéní koráa. ");
INSERT INTO boxNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Làa wizooní ɓúenɓúen ká ɓa wee páaní kúee mín wán le *Dónbeenì zĩ-beenì lún yi à máa khí. Ɓa wee páaní sanka ho búurú mí zĩní yi, à dí mí dĩ́nló lè le sĩ-wɛɛ ká bíoní mía mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ɓa wee khòoní le Dónbeenì, á mu nìpomu ɓúenɓúen wee wíoka ɓa yèni. Làa wizooní ɓúenɓúen ká a Ɲúhṹso wee vá bìa ó o kã̀nía à kúee ɓa kuure nùpua wán. ");
INSERT INTO boxNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wizonle ɓúi, ó o Piɛre là a Zãn hĩ́nɔn wee yòo le *Dónbeenì zĩ-beenì lún yi le wi-háarè fìoró pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɓa yòó wee dã ò o nìi ɓúi na ton ká a le o mùamúa a kará le *Dónbeenì zĩ-beenì zũaɲii na ɓa wee ve làa Zũaɲi-senì ɲii. Làa wizooní ɓúenɓúen ká ɓa wee lá a ɓuee día bĩ́n ò o wé fìoka le wárí bìa wee ɓuee zo le zĩ-beenì lún mu yi cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bìo ó o Piɛre là a Zãn wà ɓueé zo ó o mɔn, ó o le ɓa hã mí. ");
INSERT INTO boxNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Á bán fá mí yìo wo yi, ò o Piɛre bía: «Loń wɛn sese.» ");
INSERT INTO boxNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ó o nìi ɓɛ̀n wã́a wíokaa fá mí yìo ɓa yi. O wee leéka le ɓa hĩ́a a na bìo ɓúi mí yi. ");
INSERT INTO boxNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ó o Piɛre wã́a bía nɔn wo yi: «Wárí ɓɛ̀ntĩ́n mía ĩ cɔ̃́n máa na foǹ. Bìo ĩ cɔ̃́n lé bìo á ĩ ì na foǹ. O Nazarɛɛte nìi Yeesu *Krista pànká yi, à ũ lii hĩ́ní yòo varáka.» ");
INSERT INTO boxNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ò o ɓuan o nín-tĩánì bàhó yi á wee hóoní làa wo. Mí lahó yi à bṹn ò o mùamúa mu zení là a nɔnkíkàá-yìo dɛ̀ɛnía fá, ");
INSERT INTO boxNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ó o tá yòó dĩ̀n mí zení wán á wee varáka. O varákaa bò làa ba a zon le Dónbeenì zĩ-beenì lún yi, á wee yénka ká a khòoní le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓa zã̀amáa ɓúenɓúen mɔn wo ò o wee varáka ká a khòoní le Dónbeenì. ");
INSERT INTO boxNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bìo ɓa zũna le lé o nìi na wee ɓuee kɛɛní fìoka le Dónbeenì zĩ-beenì Zũaɲi-senì ɲii, á ɓa ɓúenɓúen zã́na á wó coon bìo wó a yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bìo ó o nìi yí máa lé o Piɛre là a Zãn mɔ́n á ɓa nùpua ɓúenɓúen wee ɓùuni ɓuee zo ɓa cɔ̃́n o *Salomɔn Sànsá yi. Ɓa ɓúenɓúen wó coon bìo wó bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bìo ó o Piɛre mɔn mu, ó o bía bìo kà nɔn ɓa zã̀amáa yi: «*Isirayɛɛlesa, lée webio nɔn ó o nìi mu waró bìo wóráa mia coon? Lée webio nɔn mi wee lońnáa wɛn kà síi, ka lè mu lé warɛ́n waten lè wa pànká á nɔn ó o wee varákaráa, tàá lé bìo wa bò le Dónbeenì yi bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O *Abarahaamu là a *Izaaki là a *Zakoobu lè wàn ɓùaawa na ká ɓàn Dónbeenì lé yìa dó ho cùkú mí ton-sá Yeesu yi. Minɛ́n miten lé bìa dó a ho pànká ɓànsowà níi yi, á pã́ a bìo o *Pilaate yahó, ká wón ɲɔǹ wã́a lá tà le mí ì día a. ");
INSERT INTO boxNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","O nì-térénnii na bìo sĩ le Dónbeenì yi á mi pã́ bìo, ò o nì-ɓúe na ho kàsó yi lén díaró á mi sĩa màhã́ vá yi á fìora a Pilaate cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lé bṹn mi wó ɓóráa yìa le mukãnì bìo wi níi yi. Ká le Dónbeenì màhã́ vèenía wo. Warɛ́n lé mu ɓàn sɛɛ́ràsa. ");
INSERT INTO boxNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","O Yeesu yèni pànká, làa bìo wa dó wa sĩa o yi lé bṹn wɛɛ́ra a nìi mu na mi ɓúenɓúen zũ á yìo wi wán kà. Bìo wa dó wa sĩa o Yeesu yi lé bṹn nɔn ó o nìi mu wan cunnáa làa bìo mi ɓúenɓúen mɔn làa wo. ");
INSERT INTO boxNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Wàn zàwa, ĩ zũ le bìo minɛ́n lè mi ɲúnása wó là a Yeesu á mi yí zũ ɲúhṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ɛ̀ɛ ká lé kà síi á le Dónbeenì wóráa, à bìo le hĩ́a bía mí ɲi-cúa fɛɛrowà ɓúenɓúen ɲiní yi á yìo lé. Le bía le o *Krista ko ò o lò be. ");
INSERT INTO boxNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Á mi cén yèrèmá mi yilera lè mi wárá, à na miten le Dónbeenì yi, á dén á à sɛ́n mi bè-kora á à día. ");
INSERT INTO boxNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bṹn ká le è na hã pɔ̃̀nna na mi ì yí ho hɛ́ɛrà yi mia, á mi ì yí á à vũń yi, á mún ǹ na a *Krista na le fèra léra mia, o Yeesu. ");
INSERT INTO boxNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","O Yeesu ko ò o kɛɛní ho wáayi màní fúaa pã̀ahṹ na mu bìo ɓúenɓúen khíi yèrèmáa wó mu bè-fĩa yi làa bìo le Dónbeenì bíaráa mu hàánì mí ɲi-cúa fɛɛrowà ɲiní yi. ");
INSERT INTO boxNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","O *Mɔyiize bía bìo kà: ‹Mi Ɲúhṹso Dónbeenì á à lén o ɲi-cúa fɛɛro ɓúi mìn zàwa tĩ́ahṹ na ka lè ĩ bìo. Bìo ɓúenɓúen na ó o wé è bío á à na mia à mi wé ɲí sese. ");
INSERT INTO boxNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nùpue lée nùpue na khíi yí máa ɲí a ɲi-cúa fɛɛro mu bíonì, wón á à lén le Dónbeenì nìpomu tĩ́ahṹ á à ɓúe.› ");
INSERT INTO boxNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Á lá a Samuwɛɛle ɲii wán á ɓa ɲi-cúa fɛɛrowà na khĩína lè mí nì-kéní kéní ɓúenɓúen á mún bía hã wizooní na kà bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","«Bìo le Dónbeenì dó mí ɲii nɔn mìn ɓùaawa yi lè mi ɲi-cúa fɛɛrowà ɲiní á bìo sã̀ mia. Mi níi mún wi le *páaníi yi, dìo le Dónbeenì bò lè mìn ɓùaawa pã̀ahṹ na le bía bìo kà nɔn o *Abarahaamu yi: ‹Ũ mɔ̀nmànía bìo yi, á hã zĩ-ɲúná ɓúenɓúen na ho tá wán á ĩ ì dúɓua yi›. ");
INSERT INTO boxNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɛ̀ɛ ká mu nín-yání, á lé minɛ́n lé bìa le Dónbeenì tonkaa mí ton-sá Yeesu ó o ɓuara bìo yi. Le tonkaa wo ò o ɓuee dúɓua mia, à mi lè mi nì-kéní kéní khí mi wén-kora yi orɛ́n bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bìo ó o Piɛre là a Zãn wee bío lè ɓa zã̀amáa, à bṹn le *Dónbeenì yankarowà, lè le *Dónbeenì zĩ-beenì parowà ɲúnása lè ɓa *Sadusĩɛwa ɓueé dɔ̃n. ");
INSERT INTO boxNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɓa sĩa ɓɛ̀ntĩ́n yí wan ɓa tonkarowà nùwã ɲun mu bìo yi hùúu, lé bìo ɓa wee kàrán ɓa nùpua, á wee bío le o Yeesu vèera, á bṹn bìo yi á ɓa nì-hía mún dà à vèe. ");
INSERT INTO boxNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Á ɓa wìira ɓa kúaa ho kàsó yi á pannáa ho tá tĩló, lé bìo le wii tò vó. ");
INSERT INTO boxNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bṹn pá yí hò bìo á bìa ɲá hã bíoní mu á cɛ̀rɛ̀ɛ tà hã yi, á bìa dó mi sĩa a *Krista yi á dó wán á yú báawa muaaseé hònú síi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mu tá lée tɔ̃n á ɓa *zúifùwa ɲúnása, lè ɓa *nì-kĩ́a, lè ho *làndá bìo zéenílowa kúaa mín wán ho Zeruzalɛɛmu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ɓa nùpua ɓúi na wi bìa kúaa mín wán bĩ́n tĩ́ahṹ lé o Aana na lé ɓa yankarowà ɲúhṹso beenì, là a Kayiifu là a Zãn là a Alɛkisãndere, à séení ɓa yankarowà ɲúhṹso beenì zĩi nùpua ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓa le ɓa ɓua ɓa tonkarowà ɓuee dĩ̀ní mí tĩ́ahṹ. Bìo ɓa ɓueé dɔ̃n á ɓa tùara ɓa yi: «Lé o yɛ́n pànká yi tàá lé o yɛ́n yèni yi á mi wɛɛ́raráa o nìi mu?» ");
INSERT INTO boxNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","À bṹn ò o Piɛre wã́a sú lè le Dónbeenì Hácírí, ó o wee bío làa ba: «Minɛ́n nìpomu ɲúnása lè mí nì-kĩ́a, ");
INSERT INTO boxNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bìo mi wee tùa wɛn ho zuia lè mu bè-tente na wó nɔn o mùamúa yi bìo, làa bìo ó o wó wó wannáa. ");
INSERT INTO boxNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Àwa, mi ɓúenɓúen ko à mi zũń mu, ò o Isirayɛɛle nìpomu mún zũń mu. Bìo nɔn ó o nìi na kà wannáa á dĩ̀n mi yahó lé o Nazarɛɛte nìi Yeesu yèni pànká yi, yìa mi ɓúaa ho *kùrùwá wán ó o húrun, na le Dónbeenì vèenía. ");
INSERT INTO boxNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O Yeesu lé yìa le Dónbeenì bíonì vũahṹ bía bìo le o lé le huee na á ɓa sorowà pã́ bìo, minɛ́n sorowà. Dén huee so lé dìo bĩnía ɓuan ho soró dĩ̀nía. ");
INSERT INTO boxNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","O Yeesu mí dòn lé yìa dà wee kã̀ní ɓa nùpua. Mu yínɔń orɛ́n yèni, á yèni ɓúi na kũn dà à kã̀ní wɛn á le Dónbeenì yí nɔn nìi woon yi ho dĩ́míɲá yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Á ɓa zúifùwa làndá tũ̀iá fɛɛrowà mu á mu wó coon dàkhĩína, lé bìo ɓa mɔn ò o Piɛre là a Zãn wee bío ká ɓa ponì sɛ́ra. Ɓa mún zũna le ɓa lé ɓa nùpua na yí kàránna. Ɓa zũna mu le ɓarɛ́n là a Yeesu kɛra mín wán míana. ");
INSERT INTO boxNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ká bìo ɓa mún mɔn o nìi mu ò o wan á dĩ̀n o Piɛre là a Zãn nìsã́ní, á ɓa wã́a yí dà bìo máa bío. ");
INSERT INTO boxNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Á ɓa wã́a le ɓa tonkarowà lée dĩ̀n ho khũuhũ vé, à ɓarɛ́n bán kará wee wã̀aní. ");
INSERT INTO boxNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ɓa wee bío mín yi: «Lée webio wa yàá à wé lè ɓa nùpua mu coon? Ho Zeruzalɛɛmusa ɓúenɓúen zũ mu kɛ̃́nkɛ̃́n le ho yéréké bìo na wó á ɓa mɔn lé ɓarɛ́n wó mu, á warɛ́n mún yí dà máa bío le mu yí bon. ");
INSERT INTO boxNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Á mi cén wa là le hɛɛrè làa ba, à hè ɓa à ɓa yí bĩní yí bío o Yeesu bìo là a ɓúi hùúu. Lé bṹn á à na ká bìo wó kà máa bɛn máa fè ɓa zã̀amáa.» ");
INSERT INTO boxNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bṹn mɔ́n á ɓa bĩnía von o Piɛre là a Zãn á bía henía nɔn yi le ɓa khí à yí bío, tàá à yí kàrán ɓa nùpua o Yeesu yèni yi hùúu. ");
INSERT INTO boxNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ká a Piɛre là a Zãn màhã́ bía nɔn ɓa yi: «Minɛ́n mi bɛɛre wã́a loń le mu so térénna le Dónbeenì cɔ̃́n à wa bè mi bíonì yi ká wa pĩ́ lerɛ́n bíonì le? ");
INSERT INTO boxNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Warɛ́n cén yí dà máa pe wa ɲiní ká bìo wa mɔn làa bìo wa ɲá á wa yí máa bío bìo.» ");
INSERT INTO boxNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Á ho làndá tũ̀iá fɛɛrowà wíokaa là le hɛɛrè làa ba, à ɓa kúaará ɓa. Bìo ɓa à dĩ̀n wán á à beéráa ɓa lò á ɓa yí zũ, lé bìo ɓa zã̀amáa ɓúenɓúen wee khòoní le Dónbeenì bìo wó bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","O nìi na waró bìo wó ho yéréké á teró lúlúio po ɓúará-ɲun. ");
INSERT INTO boxNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bìo ó o Piɛre là a Zãn ló ho kàsó yi, á ɓa wà van mí kuure nùpua cɔ̃́n, á vaá lá bìo ɓúenɓúen na ɓa yankarowà ɲúnása lè ɓa nì-kĩ́a bía nɔn ɓa yi á fɛɛra nɔn mí ninzàwa mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bìo ɓa ɲá mu vó, á ɓa ɓúenɓúen wó mí yilera làa dà-kéní á wee fìo le Dónbeenì yi kà síi: «Ɲúhṹso, ũnɛ́n lé fo léra ho wáayi lè ho tá, lè ho muhṹ lè mu bìo ɓúenɓúen na wi ho yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ũnɛ́n lé fo bía lè ũ Hácírí ũ ton-sá *Daviide na lé wàn ɓùaa ɲii yi kà: ‹Lée webio nɔn á hã sìí-viò nùpua wee kánkáráa? Lée webio nɔn á ho dĩ́míɲása wee lè ká mu ɲúhṹ mía? ");
INSERT INTO boxNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ho dĩ́míɲá bá-zàwa wíokaa míten dĩ̀n hã fio bìo yi. Ɓa ɲúnása mún hĩ́nɔn von mín kúaa mín wán à ɓa lò. Ɓa ɓúenɓúen wó mí ɲii làa dà-kéní là a Ɲúhṹso làa yìa o mɔn léra wán.› ");
INSERT INTO boxNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","À mu ɓɛ̀n bon ò o *Heroode là a *Pɔ̃nsi Pilaate wó le ɲii dà-kéní ho lóhó yi hen, ɓarɛ́n là a *Isirayɛɛle nìpomu, lè hã sìí-viò nùpua à ɓa hĩ́nɔn ũ ton-sá Yeesu na bìo sĩ foǹ wán, yìa fo mɔn léra. ");
INSERT INTO boxNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bìo fo hĩ́a fèra bía le fo ò wé á à kã́ɲa lè ũ pànká lè ũ sĩi bìo yi, bṹn ɓúenɓúen lé bìo ɓa wó kà à tiíra ɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ɲúhṹso, wã́a loń ɓa hɛɛrè na ɓa wee là. Na le sĩ-heɓúee warɛ́n na lé ũ ton-sáwá yi à wa wé bue lè ũ bíonì. ");
INSERT INTO boxNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dé ũ níi, à ɓa vánvárowà waró lè mu yéréké bìowa na wa wee wé ũ ton-sá Yeesu na bìo sĩ foǹ yèni pànká yi, à zéení ká ũ bìo bon.» ");
INSERT INTO boxNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bìo ɓa fìora vó, á ho lahó na ɓa wi yi á zà kìkìkì, á ɓa ɓúenɓúen sú lè le Dónbeenì Hácírí, á ɓa hĩ́nɔn wee bue le Dónbeenì bíonì lè le sĩ-heɓúee. ");
INSERT INTO boxNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bìa tà a *Krista bìo ɓúenɓúen á fù ɓunɓuaa, á sĩa lè ɓa hácírí wó dà-kéní. O ɓúi fù yí máa bío mí níi bìo á mí te mí dòn. Ɓa bìo ɓúenɓúen na fù wi ɓa cɔ̃́n á ɓa ɓunɓuaa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ɓa tonkarowà fù wee zéení a Ɲúhṹso Yeesu vèeró bìo lè ho pànká beenì, á le Dónbeenì wee na hã dúɓuaa cɛ̀rɛ̀ɛ ɓa ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nì-khenii fù mía ɓa tĩ́ahṹ, lé bìo á bìa manawà lè ɓa zĩní wi á fù wee yɛ̀ɛ́ hã, ");
INSERT INTO boxNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","à ɓua wárí ɓuee dé ɓa tonkarowà níi yi, à ɓa bĩní wé sĩ̀ sanka na mín yi làa bìo ɓa nì-kéní kéní koráa. ");
INSERT INTO boxNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mu ɓàn síi ó o Zozɛɛfu hĩ́a wó. O lé o *Levii nùwã nì-kéní na wee lé ho Siipere yi. Ɓa tonkarowà wee ve o làa Baanabaasi, mu kúará le yìa wee hení hã sĩa. ");
INSERT INTO boxNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","O hĩ́a yɛ̀ɛ́ra mí mɔhṹ á ɓuan wárí ɓueé nɔn ɓa tonkarowà yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nìi ɓúi hĩ́a wi bĩ́n ɓa le Ananiasi, ká ɓàn hã́a ɓa le Safiraa. O hĩ́a yɛ̀ɛ́ra mí mɔhṹ, ");
INSERT INTO boxNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","á fá wárí sɔ̃́n-kéní bàrá, á ɓàn hã́a mún zũ mu, à dìo ká ó o ɓuan vaá nɔn ɓa tonkarowà yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ó o Piɛre bía nɔn wo yi: «Ananiasi, lée webio nɔn ó o *Satãni dóráa hã yile-kora foǹ, ũ fã̀ le sabéré le Dónbeenì Hácírí ɲii, á fá ho mɔhṹ wárí sɔ̃́n-kéní bàrá? ");
INSERT INTO boxNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bìo ho mɔhṹ mu lá dĩǹ yí yɛ̀ɛ́ra ká yínɔń fo te ho le? Á bìo ho yɛ̀ɛ́ra, á ho ɓàn wárí bìo sã̀ a yɛ́n yi? Yínɔń fo le? Á lée webio nɔn á fo wóráa bìo kà? Fo yí fã̀ sabéré nùpua ɲii, le Dónbeenì lé dìo á fo fã̀ le sabéré ɲii.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bìo ó o Ananiasi ɲá hã bíoní mu, ó o ló lùwá, á lií húrun. Á bìa ɲá mu ɓúenɓúen zã́na dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Á ɓa yàrówá hĩ́nɔn cà le dɛ̀ɛ pon o yi, á ɓuan vaá nùuna. ");
INSERT INTO boxNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lɛ́ɛ̀rèwa bìo tĩn síi bṹn mɔ́n á ɓàn hã́a wà ɓueé zon ká a yí zũ bìo wó. ");
INSERT INTO boxNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ó o Piɛre tùara a yi: «Mi ho tũ̀iá na miì: Mìn mɔhṹ na mi yɛ̀ɛ́ra ɓàn wárí ɓúenɓúen lé dìo kà le?» Ó o le ũuu, le dén lé lerɛ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ó o Piɛre wã́a bía nɔn wo yi: «Ũnɛ́n lè mìn báa wó kaka wã̀anía tòráa á wee khɛ́nnáa le Dónbeenì Hácírí kúará? Loń, bìa lée wi ho zũaɲii kà lé bìa vaá nùuna mìn báa. Ũnɛ́n ɓa mún ǹ lá á à lɛ́nnáa.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mí lahó yi ó o hã́a mu ɓɛ̀n dɛ̀ɛnía ló lùwá o Piɛre tá, á lií húrun. Bìo ɓa yàrówá ɓueé zoó dɔ̃n ò o húrun, á ɓa lá a ɓuan vaá nùuna ɓàn báa nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bìa tà a *Krista bìo kuure làa bìa ɲá mu ɓúenɓúen zã́na dàkhĩína. ");
INSERT INTO boxNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mu yéréké bìowa cɛ̀rɛ̀ɛ na wee zéení le Dónbeenì pànká á ɓa tonkarowà hĩ́a wee wé mu nìpomu tĩ́ahṹ. Bìa tà a Krista bìo ɓúenɓúen hĩ́a wee wé mí yilera làa dà-kéní à wé kúee mín wán le *Dónbeenì zĩ-beenì lún yi o *Salomɔn Sànsá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nì-vio yí máa hení mí sĩa zo ɓa tĩ́ahṹ, ɛ̀ɛ ká ɓa zã̀amáa màhã́ pá wee wíoka ɓa yèni. ");
INSERT INTO boxNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɓa báawa lè ɓa hã́awa na wee dé mí sĩa o Ɲúhṹso yi á wee wé boo ká ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Á ɓa wã́a wee ɓua ɓa vánvárowà à ɓuee lée bàráka hã wãna nìsã́a hã dãmu sĩ̀a wán, bèra a na ká a Piɛre hĩ́a ɓueé wee khĩí, ò o bóní pá wã́a yí kúia ɓa ɓúi wán. ");
INSERT INTO boxNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hàrí hã lórá na sùaráa lè ho Zeruzalɛɛmu à nùpua mún wee ɓùuni ɓuen lè mí vánvárowà lè ɓa nùpua na ɓa cĩ́náwa wee beé lò. Á ɓa ɓúenɓúen wee wa. ");
INSERT INTO boxNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Á ɓa yankarowà ɲúhṹso beenì làa bìa làa wo páanía wi na lé ɓa *Sadusĩɛwa kuure nùpua á le yandee sú ɓa tonkarowà bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Á ɓa wìikaa ɓa tonkarowà á kúaa ɓa zã̀amáa kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ká a Ɲúhṹso wáayi tonkaro ɓúi màhã́ lion ho tĩ́nàahṹ à lii hɛ́ra ho kàsó zĩi wonna, ò o léra ɓa á bía nɔn yi: ");
INSERT INTO boxNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Mi lɛ́n va le *Dónbeenì zĩ-beenì lún yi á vaa bue le mukãnì binbirì na máa vé bìo ɓúenɓúen à na ɓa zã̀amáa yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Á ɓa tonkarowà bò bìo ó o bía yi. Le yìnbíi bùirìi á ɓa wà van le Dónbeenì zĩ-beenì lún yi á vaá zoó wee kàrán ɓa nùpua. Ɓa yankarowà ɲúhṹso beenì làa bìa làa wo páanía wi á von o *Isirayɛɛle nìpomu *nì-kĩ́a. Á ɓarɛ́n na lé ho làndá tũ̀iá fɛɛrowà ɓúenɓúen kúaa mín wán, à ɓa tonkaa ɓa ɓúi le ɓa lɛ́n vaa lén ɓa tonkarowà ho kàsó yi ɓua ɓuennáa. ");
INSERT INTO boxNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ká ɓa parowà màhã́ yí vaá yú ɓa bĩ́n, á ɓa wà ɓueé bía bìo kà nɔn ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Wa vaá yú ho kàsó zĩi wonna ká hã pon dĩ̀n sese, á ɓa parowà na bĩ́n ɓúenɓúen mún dĩ̀nka mí lara yi. Ɛ̀ɛ ká bìo wa hɛ́ra à wa zon, á wa yí zoó yú nùpue.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bìo le Dónbeenì zĩ-beenì parowà ɲúhṹso lè ɓa yankarowà ɲúnása ɲá hã bíoní mu, á ɓa wã́a yí zũ hen na ɓa à dé míten yi ɓa tonkarowà mu vĩ́ló bìo yi, á ɓa wee tùa míten yi le mu yàá wó kaka wóráa coon. ");
INSERT INTO boxNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hón pã̀ahṹ so yi ò o ɓúi ɓueé dɔ̃n, á bía nɔn ɓa yi: «Mi loń, ɓa nùpua mu na mi pon ɲii ho kàsó yi, lé ɓarɛ́n vaá wi le Dónbeenì zĩ-beenì lún yi á wee kàrán ɓa nùpua.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Á le Dónbeenì zĩ-beenì parowà ɲúhṹso dɛ̀ɛnía hĩ́nɔn fó mí nùpua à ɓa vaá ɓuan ɓa tonkarowà ɓuararáa ká ɓa màhã́ yí wó mu làa hɛɛrè, lé bìo ɓa zã́na le ká mí wó mu, á ɓa nùpua á à lèeka mí lè hã huaa. ");
INSERT INTO boxNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bìo ɓa ɓueé dɔ̃n ho làndá tũ̀iá fɛɛrowà yahó làa ba, á ɓa yankarowà ɲúhṹso beenì tùara ɓa yi: ");
INSERT INTO boxNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Wa so nɔ̀nzoǹ yí hò mia lè le sòobɛ́ɛ le mi yí bĩní yí kàrán ɓa nùpua o nìi mu yèni yi le? Á mi wã́a loń bìo mi wó. Ho Zeruzalɛɛmu lóhó ɓúenɓúen á mi vó lè mi kàránló, á mún wi à mi bàká warɛ́n yi là a nìi mu húmú bìo.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ó o Piɛre lè ɓa tonkarowà bía nɔn ɓa yi: «Wa ko à wa bè le Dónbeenì bíoní yi á sṹaaní bìo wa à bè ɓa nùpua bíoní yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","O Yeesu mu na mi ɓúaa ho *kùrùwá wán ó o húrun, á wàn ɓùaawa ɓàn Dónbeenì vèenía, ");
INSERT INTO boxNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","á ɓuan yòó bàrá mí nín-tĩánì. Le wó a là a ɲúhṹso na lé o kã̀nílo, ò o *Isirayɛɛle nìpomu bè yi á yèrèmá mí yilera lè mí wárá, à yí mu bè-kora sɛ́ndíaró. ");
INSERT INTO boxNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Warɛ́n, lè le Dónbeenì Hácírí na le nɔn bìa wee tà le bìo yi, á lé mu bè-wénia mu ɓàn sɛɛ́ràsa.» ");
INSERT INTO boxNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bìo ho làndá tũ̀iá fɛɛrowà ɲá hã bíoní mu, á ɓa yiwa cã̀ cã̀, á wi ɓa ɓúe ɓa tonkarowà. ");
INSERT INTO boxNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ɛ̀ɛ ká *Farizĩɛ ɓúi màhã́ kɛra ɓa tĩ́ahṹ á yèni ɓa le Kamaliyɛli. O lé ho *làndá bìo zéenílowa nì-kéní na ɓa zã̀amáa ɓúenɓúen wee kɔ̃̀nbi. Wón lé yìa lií hĩ́nɔn yòó dĩ̀n ɓa tũ̀iá fɛɛrowà tĩ́ahṹ ò o le ɓa bío le ɓa tonkarowà mu lée dĩ̀n ho khũuhũ màní. ");
INSERT INTO boxNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bṹn mɔ́n ó o bía nɔn bìa kúaa mín wán yi: «Isirayɛɛlesa, mi cà hácírí bìo mi ì wé lè ɓa nùpua na kà bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nìi ɓúi ɓueé còonía hĩ́nɔn á yèni ɓa le Tedaasi. O hĩ́a wee wé míten lòn nùpue na bìo ɲúhṹ wi. Nùpua na ɓueé tà bò a yi á à yí báawa khĩá-náa síi. Bìo ó o húrun, á bìa ɓúenɓúen na tà bò a yi mu pã̀ahṹ á saawaa, ó o bìo ɲúhṹ ɓó. ");
INSERT INTO boxNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bṹn mɔ́n á ho mìló pã̀ahṹ, ó o Kalilee nìi Zudaa ɓɛ̀n hĩ́nɔn á yú ɓa nùpua cɛ̀rɛ̀ɛ á ɓa bò a yi. Á wón ɓa mún ɓó, á bìa bò a yi ɓúenɓúen saawaa. ");
INSERT INTO boxNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Àwa, á mi le ĩ bío mu na mi: Ɓa nùpua mu á mi día bìo. Mi día ɓa le ɓa lɛ́n. Lé bìo ká ɓa tonló mu á bìo ló nùpue níi yi, á ho ɲúhṹ á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ká ho bìo ɓɛ̀n ló le Dónbeenì níi yi, á mi yí dà dɛ̀ɛ ɓúi máa wé làa ho. Mi yí wó sese á mi ì kɛń lòn nùpua na wee fi lè le Dónbeenì.» Bìo ó o fɛɛra mí ɲi-cúa vó, á ho làndá tũ̀iá fɛɛrowà tà a bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Á ɓa von ɓa tonkarowà, á ɓueé han lè hã làbàaní, á ɓa le ɓa yí bĩní yí bío bìo o Yeesu yèni yi, á ɓa wã́a día ɓa à ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɓa tonkarowà ló le zĩi yi ká ɓa sĩa wan, lé bìo le Dónbeenì le ɓa ko lè le lònbee o Yeesu yèni bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Làa wizooní ɓúenɓúen ká ɓa wee kàrán ɓa nùpua, á wee bue le bín-tente le Dónbeenì zĩ-beenì lún yi lè hã zĩní na ká yi le o Yeesu lé *Yìa le Dónbeenì mɔn léra á wó là a kã̀nílo. ");
INSERT INTO boxNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu pã̀ahṹ ká ɓa nì-kenínia wee dé wán ká ɓa wà. Á ɓa *zúifùwa na wi ɓa tĩ́ahṹ na wee bío mu kɛrɛɛkimu sĩa yí wan bìo á ɓàn zàwa na lé ɓa zúifùwa binbirí wee wé yi. Ɓa wee zá le làa wizooní ɓúenɓúen le mínɛ́n mahã́awa á ɓa yí máa loń yi sese ho dĩ́nló sankaró pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Á ɓa tonkarowà pírú ɲun von ɓa nì-kenínia ɓúenɓúen kúaa mín wán bía nɔn yi: «Wàn zàwa, wa yí ko à wa día le Dónbeenì bíonì bueró ká wa yèrèmá wa yara sĩ́ ho dĩ́nló bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mi cén hueeka ɓa nùpua nùwã hèɲun mi tĩ́ahṹ na mi zũ le ɓa térénna, á sú lè le Dónbeenì Hácírí lè mu bè-zũńminì. Bán lé bìa á wa à dé mu níi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bṹn ká warɛ́n ɓɛ̀n dà à na waten ho fìoró lè le Dónbeenì bíonì bueró yi lè wa sòobɛ́ɛ.» ");
INSERT INTO boxNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bìo ɓa tonkarowà fɛɛra mí ɲi-cúa vó, á ɓa kuure nùpua tà ɓa bìo. Bìa ɓa hueekaa lé o Etiɛna na lé o nùpue na sĩidéró wi, na sú lè le Dónbeenì Hácírí. À séení a Filiipu, là a Porokoore, là a Nikonɔɔre, là a Timɔn, là a Paamɛnaasi, là a Ãntiosi nìi Nikolaa na hĩ́a yèrèmáa bò ɓa zúifùwa mu ɓàn Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɓa ɓuan ɓa vannáa ɓa tonkarowà cɔ̃́n, á bán bò mí níní ɓa wán à ɓa fìora nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Le Dónbeenì bíonì wee bɛn fè hã lara ká le wà, á ɓa nì-kenínia wee dé wán ho Zeruzalɛɛmu yi, á ɓa yankarowà cɛ̀rɛ̀ɛ á wee tà dé mí sĩa o *Krista yi. ");
INSERT INTO boxNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","O Etiɛna le Dónbeenì dúɓuaa nɔn ho pànká yi, ó o wee wé mu yéréké bè-beera na wee zéení le Dónbeenì pànká ɓa nùpua tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Á ɓa zúifùwa nùwã yɛn ɓúi á hĩ́nɔn pã́ a bìo. Ɓa ɓúi lé ɓa zúifùwa kàránló zĩi nùpua na ɓa wee ve làa wobáaní na wi míten. Ɓa lé bìa ló ho Sirɛɛna lè ho Alɛkisãndiri lórá yi. Ká ɓa ɓúi lé bìa ló ho Silisii lè ho Azii kãna yi. Lé bán lé bìa ɓueé wee wã̀aní là a Etiɛna. ");
INSERT INTO boxNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ká ɓa màhã́ yí dàńna a bìo, lé bìo le Dónbeenì Hácírí bè-zũńminì na le wee na a yi lé bìo ó o wee bíoráa. ");
INSERT INTO boxNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Á ɓa yà ɓa nùpua ɲiní à ɓa le ɓa bío bìo kà: «Wa ɲá ò o nìi mu bía khon o *Mɔyiize lè le Dónbeenì dã́ní yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Lé bṹn ɓa bía á súkúra lè ɓa zã̀amáa, lè ɓa *nì-kĩ́a, lè ho *làndá bìo zéenílowa. Bṹn mɔ́n á ɓa ɓueé wìira a Etiɛna á ɓuan vannáa ho làndá tũ̀iá fɛɛrowà yahó. ");
INSERT INTO boxNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓa mún fó ɓa nùpua ɓúi bòráa na ɓueé fũ̀aa hã sabíoní o Etiɛna mu ɲii. Á bán ɓueé bía: «Fɛ́ɛɛ ká a nìi mu wee bío hã bín-kora à lɛɛ́ le *Dónbeenì zĩ-beenì là a Mɔyiize làndá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wa ɲá ò o bía le o Yeesu, wón Nazarɛɛte nìi so, á à fío le Dónbeenì zĩ-beenì, á mún ǹ yèrèmá hã làndáwá na ó o Mɔyiize nɔn wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ho làndá tũ̀iá fɛɛrowà na wi le zĩi yi mu zoǹ ɓúenɓúen fá mí yìo o Etiɛna yi, á mɔn ò o yahó ɓonmín lè le Dónbeenì wáayi tonkaro yahó. ");
INSERT INTO boxNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ɓa yankarowà ɲúhṹso beenì tùara a Etiɛna yi: «Hãà! Bìo ɓa wee bío ũ ɲii so bon le?» ");
INSERT INTO boxNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ó o Etiɛna bía: «Minɛ́n wàn maáwà lè wàn zàwa, mi ɲí bìo á ĩ bío á à na mia. Le Dónbeenì cùkúso hĩ́a zéenía míten lè wàn ɓùaa *Abarahaamu ká a wi ho Mɛzopotamii yi á dĩǹ yí ló yí vaá kará ho Haran lóhó yi, ");
INSERT INTO boxNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","á bía nɔn wo yi: ‹Lé día mìn kɔ̃hṹ lè mìn zĩi á lɛ́n va ho kɔ̃hṹ ɓúi na á ĩ ì zéení làa fo yi.› ");
INSERT INTO boxNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ó o Abarahaamu wã́a hĩ́nɔn día ho Kalidee kɔ̃hṹ á vaá kará ho Haran yi. Bìo ó o Abarahaamu ɓàn maá húrun á le sã̀ léra a ho Haran yi á ɓuararáa ho kɔ̃hṹ mu na mi wi yi ho zuia. ");
INSERT INTO boxNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dónbeenì á yí nɔn tá wo yi bĩ́n. Hàrí hìa lè le nín-tàahṹ bìo ó o yí yú. Ká le Dónbeenì màhã́ nɔn le ɲii le mí ì na ho kɔ̃hṹ mu na ká wo yi, orɛ́n lè mí mɔ̀nmànía na à hĩ́ní o mɔ́n. Á ho pã̀ahṹ na le Dónbeenì wee bío mu yi làa wo ká za woon mía o cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bìo kà lé bìo á le bía nɔn wo yi: ‹Ũ mɔ̀nmànía khíi kɛń kã-veere yi, á à wé ɓa wobáaní bĩ́n. Ɓa à beé ɓa lò hã lúlúio khĩá-náa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ɛ̀ɛ ká ho sìí na à wé ɓa lè mí wobáaní á ĩnɛ́n Dónbeenì màhã́ à cítí. Bṹn mɔ́n á ɓa à lé bĩ́n á à lɛ́n wé ɓueé ɓùaaní mi ho lahó na kà yi.› ");
INSERT INTO boxNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bṹn mɔ́n á le bò le *páaníi là a Abarahaamu. Bìo wee zéení le páaníi mu bìo lé ho *kúiiró. Lé bṹn nɔn ó o Abarahaamu za *Izaaki teró wizooní bìo hètĩn níi yi ó o *kúio wo. Lé bṹn ó o Izaaki mún kúio o *Zakoobu, á wón ɓɛ̀n kúiora mí zàwa pírú ɲun na lé wa zĩ-ɲúná ɓàn ɓùaawa. ");
INSERT INTO boxNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«O zàwa mu dú le yandee lè mín fɛ̀ɛso Zozɛɛfu, á yɛ̀ɛ́ra a ó o wó a wobá-nìi ho *Ezipite yi. Ká le Dónbeenì màhã́ kɛra làa wo. ");
INSERT INTO boxNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Le léra a mí lònbee ɓúenɓúen yi. Le wó ó o dàńna dĩ̀n ho Ezipite bɛ́ɛ yahó á zéenía mí bè-zũńminì, ó o bìo wó sĩna a yi. Á wón bàrá a mí zĩi bìowa lè ho Ezipite kɔ̃hṹ bìowa ɓúenɓúen ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Mu pã̀ahṹ á le hĩni ló ho Ezipite kɔ̃hṹ ɓúenɓúen yi lè ho Kanan kɔ̃hṹ yi mún. Mu wó lònbee làa sòobɛ́ɛ, á wàn ɓùaawa mu yí máa yí bìo ɓa à dí. ");
INSERT INTO boxNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bìo ó o Zakoobu ɲá à ɓa le ho dĩ́nló wi ho Ezipite yi, ó o nín-yání tonkaa wàn ɓùaawa le ɓa va bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mu cúa-ɲun níi na ɓa bĩnía van bĩ́n, ó o Zozɛɛfu wã́a zéenía míten lè mín zàwa. Lé bṹn ó o bɛ́ɛ bò yi zũńnanáa hen na ó o Zozɛɛfu nɔnkãni can yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ó o Zozɛɛfu wã́a tonkaa mín zàwa le ɓa vaa fé mín maá lè mín zĩi nùpua ɓúenɓúen. Ɓa à yí nùpua ɓúará-náa hònú mía. ");
INSERT INTO boxNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ó o Zakoobu wã́a ɓuara ho Ezipite. Lé bĩ́n ó o ɓueé húrun yi, á wàn ɓùaawa mún húrun bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓa ɓuan ɓa nì-hínmu vannáa ho Sisɛɛmu yi, á vaá nùuna le búure na ó o Abarahaamu hĩ́a yà a Hamɔɔre zàwa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Bìo ho pã̀ahṹ na le Dónbeenì ko à le tií bìo le hĩ́a dó mí ɲii nɔn o Abarahaamu yi ɲii wà ɓueé sùará, á bṹn wa nìpomu boo, á wee dé wán ho Ezipite yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bṹn mɔ́n ó o bɛ́ɛ ɓúi na yí zũna a Zozɛɛfu á kará ho Ezipite kɔ̃hṹ ɲúhṹ wán. ");
INSERT INTO boxNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","O khà wa nìpomu, á beéra wàn ɓùaawa lò, á kĩ̀kã́a ɓa yi le ɓa pĩ́ mí zàwa kúia à ɓa hí. ");
INSERT INTO boxNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lé bṹn pã̀ahṹ ó o *Mɔyiize ton yi. O hĩ́a lée kúnkúza na se, na bìo sĩ le Dónbeenì yi. Pĩina bìo tĩn ká a wi mín zĩi á ɓàn nu wee yɛ̀ɛní. ");
INSERT INTO boxNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɓa día a yí máa loń yi, ó o bɛ́ɛ hĩ́nló lé yìa lá a ɓuan á hɔ̃n lè mí kùrú za bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lé o bɛ́ɛ zĩi á ɓa kenía o Mɔyiize yi lè ho Ezipitesa bìo na ɓa zũ ɓúenɓúen, ó o wó a nùpue na pànká wi mí bíoní lè mí wárá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Bìo ó o Mɔyiize lúlúio yú ho ɓúará-ɲun, ó o kará lon mí yi, ó o hĩ́nɔn le mí vaá loń mín zàwa na lé o *Isirayɛɛle nìpomu. ");
INSERT INTO boxNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ó o vaá mɔn o Ezipite nìi ɓúi ò o wee ha ɓàn za nì-kéní, ó o tà mín za na ɓa wee ha ɲii, ò o ɓó a Ezipite nìi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O lá wee leéka le o Isirayɛɛle nìpomu na lé ɓàn zàwa á à zũń le le Dónbeenì le mí ì dĩ̀n orɛ́n wán à lénnáa ɓa ɲúná, yaa ɓa yí zũna mu. ");
INSERT INTO boxNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mu tá na lée tɔ̃n, ó o Mɔyiize fò mín lè mín sìí nùpua nùwã ɲun ká ɓa wee fi. Ó o le mí ì yanka ɓa, ó o bía bìo kà: ‹Wàn zàwa, minɛ́n na lé lè dà-kéní á bĩnía wee fi mín yi le?› ");
INSERT INTO boxNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Á yìa dà mí ninza na so á lío o Mɔyiize ò o bía nɔn wo yi: ‹Lé o yɛ́n bàrá fo wa ɲúhṹ wán le ũ wé cítí wɛn? ");
INSERT INTO boxNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fo wi à ũ ɓúe mi làa bìo á fo hĩihṹ ɓóráa o Ezipite nìi bìo síi le?› ");
INSERT INTO boxNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bìo ó o Mɔyiize ɲá hɔ̃́n bíoní so, ó o lùwa á vaá kará ho Madĩa kɔ̃hṹ yi. Lé bĩ́n ó o yú ɓa zàwa nùwã ɲun yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Lúlúio ɓúará-ɲun bṹn mɔ́n, á le Dónbeenì wáayi tonkaro ɓúi zéenía míten làa wo le vĩ̀ndɛ̀-za dɔ̃hṹ na wee cĩ̀ yi, ho tá henì yi, ho Sinayii ɓúee nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bṹn bè-minii so wó a Mɔyiize coon. Á bìo ó o wi ò o vaa sùará mu yi à wíoka loń sese, ó o ɲá a Ɲúhṹso tãmu na bía làa wo: ");
INSERT INTO boxNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹O *Abarahaamu là a *Izaaki là a *Zakoobu na lé mìn ɓùaawa ɓàn Dónbeenì lé mi.› Ó o Mɔyiize zã́na, á wee zà wàwàwà, á yí wi ò o loń mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ó o Ɲúhṹso wã́a bía làa wo: ‹Tɛn ũ nakãa, lé bìo á ho lahó na á ũ wi yi lée tá na bìo sã̀ miì. ");
INSERT INTO boxNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Le lònbee na á ĩ nìpomu wi yi ho Ezipite yi á ĩ mɔn. Ĩ ɲá ɓa wɛ́ɛ sã, á ĩ lion wà lií kã̀ní ɓa. Wã́a ɓuen. Ĩ ì tonka fo ho *Ezipite yi›. ");
INSERT INTO boxNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«O Mɔyiize nì-kéní mu na ó o *Isirayɛɛle nìpomu fù pã́ bìo le lé o yɛ́n dó a le o wé mí ɲúhṹso lè mí cítí fĩ̀, wón lé yìa le Dónbeenì tonkaa ò o wé o ɲúhṹso làa yìa wee lén hã ɲúná. Le wó mu ho wáayi tonkaro pànká yi, yìa hĩ́a zéenía míten là a Mɔyiize le vĩ̀ndɛ̀-za na wee cĩ̀ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","O Mɔyiize lé yìa léra a Isirayɛɛle nìpomu ho *Ezipite yi. O wó mu yéréké bìowa na wee zéení le Dónbeenì pànká ho kɔ̃hṹ yi, lè ho muhṹ na ɓa wee ve làa muhṹ na mùia yi, lè ho tá henì yi hã lúlúio ɓúará-ɲun pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Lé o Mɔyiize mu lé yìa pá bía bìo kà nɔn o Isirayɛɛle nìpomu yi: ‹Le Dónbeenì á à lén o ɲi-cúa fɛɛro ɓúi mìn zàwa tĩ́ahṹ na ka lè ĩ bìo síi á à tonka mi cɔ̃́n›. ");
INSERT INTO boxNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Bìo mu nìpomu hĩ́a kúaa mín wán ho tá henì yi, á lé orɛ́n pá hĩ́a wee vará wàn ɓùaawa lè le Dónbeenì wáayi tonkaro pã̀ahṹ, yìa hĩ́a wee bío làa wo ho Sinayii ɓúee wán. Lé orɛ́n á le Dónbeenì bíonì na wee na le mukãnì á nɔn yi, ò o ɓuee lii na wɛn. ");
INSERT INTO boxNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ká wàn ɓùaawa màhã́ yí tà ká ɓa à bè hã bíoní mu yi. Ɓa pã́ a bìo, á wi ɓa bĩní va ho Ezipite yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ɓa bía nɔn o *Aaron yi: ‹Cà hã wɔ̃̀nna ɓúi na wɛn na à dí wa yahó, lé bìo á wa yí zũ bìo wó a Mɔyiize mu na léra wɛn ho Ezipite yi›. ");
INSERT INTO boxNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Á ɓa wã́a pà a nɔ̀n-za kansi á wee wé mu hãmu na yi, á dú ho sɔ̃́n-beenì bìo ɓarɛ́n míten dàńna wó bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ká le Dónbeenì màhã́ bĩnía ɓa mɔ́n, á día ɓa á ɓa wee ɓùaaní ho wáayi bìowa, làa bìo mu túararáa ɓa ɲi-cúa fɛɛrowà vũahṹ yi: ‹Isirayɛɛle nìpomu, hã lúlúio ɓúará-ɲun na mi wó ho tá henì yi, á ɓa bà-kùio na mi fũ̀aana lè mu hãmu na mi wó, lé ĩnɛ́n á mi so wó mu nɔn yi le? ");
INSERT INTO boxNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɓùeé. Mu lé mi Mɔlooki wã̀ahṹ bùkú za lè mi Erefãn wã̀ahṹ mànàayiire á mi ɓuan, hɔ̃́n na á mi wó miten á wee ɓùaaní, lé bṹn nɔn á ĩ ì sèráa mia á à dàráa ho *Babiloona wán.› ");
INSERT INTO boxNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Hã pɔ̃nsòni bùkú na hĩ́a wi wàn ɓùaawa cɔ̃́n ho tá henì yi lé hón á hã pɛnminí na le Dónbeenì làndá túara wán wi yi. Lé hɔ̃́n pɔ̃nsòni bùkú so hĩ́a wee zéení le le Dónbeenì wi ɓa tĩ́ahṹ. O *Mɔyiize hĩ́a wó ho làa bìo le Dónbeenì zéenía le o wé làa ho. Le hĩ́a le o wé ho làa hìa ó o mɔn bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bṹn mɔ́n á hã pɔ̃nsòni bùkú mu á wàn ɓùaawa lè mí mɔ̀nmànía na sã̀ mín á mún ɓuan. Pã̀ahṹ na le Dónbeenì ɲɔn hã kãna nùpua á fó táwá nɔn ɓa yi ká a Zozue dú ɓa yahó ká lé horɛ́n ɓa ɓuan. Á ho ɓɛ̀n wi bĩ́n fúuu fúaa o *Daviide pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","O Daviide bìo hĩ́a wó sĩna le Dónbeenì yi, ó o fìora le níi le cɔ̃́n, à soráa ho lahó ɓúi à na a *Zakoobu ɓàn Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ká a *Salomɔn lé yìa màhã́ son le zĩi mu nɔn le Dónbeenì yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ɛ̀ɛ ká le Dónbeenì na dà mu bìo ɓúenɓúen wán màhã́ yí máa zo zoo kɛɛní ɓa nùpua zĩ-sonia yi làa bìo ó o ɲi-cúa fɛɛro bíaráa mu. ");
INSERT INTO boxNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ho wáayi lé ĩ bɛ́ɛnì kanmúiní, ká ho tá lé ĩ zení bèeníi. Lé le zĩi yɛ́n sìí á mi dà à so á à na miì. Lé ho lahó yɛ́n á ĩ dà a kɛɛní yi? ");
INSERT INTO boxNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bṹn bìowa so ɓúenɓúen so yínɔń mi wó mu ĩten le? ");
INSERT INTO boxNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ɓúi! Isirayɛɛlesa, mi yiwa tunka dà, mi yí máa tà hɛ́n mi sĩa lè mi ɲikɔ̃nna le Dónbeenì veró yi. Minɛ́n lè mìn ɓùaawa lée dà-kéní. ");
INSERT INTO boxNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Lé o ɲi-cúa fɛɛro yɛ́n á mìn ɓùaawa mu á yí beéra lò? Bìa buera yìa mí dòn na wee wé le Dónbeenì sĩi bìo ɓuenló bìo, bán à mìn ɓùaawa ɓó. Bìo kà wán, lé orɛ́n nì-kéní mu á minɛ́n ló mɔ́n á mún ɓó. ");
INSERT INTO boxNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Minɛ́n na le Dónbeenì wáayi tonkarowà dó ho làndá níi yi, lé minɛ́n miten yí bò ho làndá mu bè-bíonii yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bìo ho làndá tũ̀iá fɛɛrowà ɲá hã bíoní mu á ɓa sĩa ka le hã à fáa o Etiɛna bìo yi lè le sĩ-cĩ̀ílè. ");
INSERT INTO boxNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ká arɛ́n wón sú lè le Dónbeenì Hácírí, ó o hóonía mí yahó á lora ho wáayi, ó o mɔn le Dónbeenì cùkú là a Yeesu ò o wi le Dónbeenì nín-tĩánì, ");
INSERT INTO boxNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ó o bía: «Mi tántá mi ɲikɔ̃nna, ho wáayi ɲii hɛ́ra, á ĩ mɔn o *Nùpue Za ká a dĩ̀n le Dónbeenì nín-tĩánì.» ");
INSERT INTO boxNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Á ɓa wee wãama pɔ̃́npɔ̃́n à ɓa tun mí ɲikɔ̃nna. ");
INSERT INTO boxNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bṹn mɔ́n á ɓa ɓúenɓúen dɛ̀ɛnía kúaaka a wán á wìira lóráa ho donkĩ́ahṹ á lée wee lèeka lè hã huaa á à ɓúe. Bìa wee wé mu á tɛnkaa mí sĩ̀a bàrá a yàrónza ɓúi na ɓa le Soole tá le o pa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bìo ɓa wee lèeka a Etiɛna lè hã huaa, ó o wee fìo kà síi: «Ɲúhṹso Yeesu, tà fé ĩ mànákã̀.» ");
INSERT INTO boxNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bṹn mɔ́n ó o ló lion mí nɔnkóɲúná wán, ò o wãamaa pɔ̃́npɔ̃́n: «Ɲúhṹso, yí bè mu bè-kohó na kà ɓa wán.» Bìo ó o bía hɔ̃́n bíoní so vó, ó o húrun. ");
INSERT INTO boxNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","O Etiɛna ɓúeró ó o Soole tà. Mu nɔ̀nzoǹ mí bɛɛre, á bìa tà a *Krista bìo na ho Zeruzalɛɛmu yi, á ɓa ɓúakáa wee beé lò làa sòobɛ́ɛ. Ɓa tonkarowà níi ló, ká bìa ká ɓúenɓúen saawaa zon ho *Zudee lè ho *Samarii kãna yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɓa nùpua ɓúi na wee bè le Dónbeenì yi sese lé bìa lá a Etiɛna vaá nùuna, à ɓa wá wá a bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","O Soole wón ɓɛ̀n lé bìa tà a Krista bìo ɲúhṹ ɓúeró ó o hĩ́nɔn can mí kuio bìo yi. O wee hɛ́ɛ wìika ɓa báawa lè ɓa hã́awa hã zĩní yi, à ɓua vaa kúee ho kàsó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bìa saawaa wà bán tò hã kãna yi, á wee bue le bín-tente. ");
INSERT INTO boxNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","O Filiipu wà van ho Samarii kɔ̃hṹ ló-beenì yi, á vaá wee bue o Krista bìo à na ho nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bìo ɓa zã̀amáa ɲá bìo ó o Filiipu wee bío, á mún mɔn mu yéréké bìowa na wee zéení le Dónbeenì pànká na ó o wee wé, á ɓa wíokaa wee tántá mí ɲikɔ̃nna sese bìo ó o wee bío yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɓa nùpua cɛ̀rɛ̀ɛ na ɓa cĩ́náwa wi yi, á ɓa wee fáara lé yi ká ɓa à wãamaka pɔ̃́npɔ̃́n. Á ɓa mùamúawà lè ɓa lóní cɛ̀rɛ̀ɛ mún wee wa. ");
INSERT INTO boxNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Á mu wó sĩ-wɛ-beenì ho lóhó mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nìi ɓúi na ɓa le Simɔn à hĩ́a wi ho lóhó mu yi, á wó mí níi símú bĩ́n míana. Ho Samarii nùpua ɓúenɓúen wee wé coon bìo ó o wee wé bìo yi. O lá wee wé míten lòn nùpue na bìo ɲúhṹ wi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ɓa nùpua ɓúenɓúen hĩ́a wee ɲí a cɔ̃́n sese, à lá ɓa háyúwá yi à yòo ɓúe ɓa nì-kĩ́a yi. Ɓa wee bío: «O nìi na kà á le Dónbeenì pànká na ɓa wee ve làa pànká beenì á wi cɔ̃́n.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bìo nɔn ɓa wee dĩ̀n ɲínáa o cɔ̃́n sese kà síi, lé bìo ó o wee wé ɓa coon lè mí níi símú bìowa mu míana. ");
INSERT INTO boxNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ká bìo ɓa yèrèmáa dó mí sĩa le bín-tente na ó o Filiipu buera nɔn ɓa yi le *Dónbeenì bɛ́ɛnì là a Yeesu *Krista bìo yi, á ɓa báawa lè ɓa hã́awa á ɓa bátízéra. ");
INSERT INTO boxNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","O Simɔn mí bɛɛre mún dó mí sĩi le yi, á ɓa bátízéra a. Bṹn ɲii wán, ó o wã́a yí máa tà lé o Filiipu mɔ́n. Mu yéréké bìowa na wee zéení le Dónbeenì pànká na ó o wee mi, ó o wee wé coon bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bìo ɓa tonkarowà na ho Zeruzalɛɛmu yi ɲá le ho Samariisa ɓúi tà le Dónbeenì bíonì bìo, á ɓa tonkaa o Piɛre là a Zãn ɓa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bìo ɓa vaá dɔ̃n á ɓa fìora nɔn ɓa nì-kenínia nì-fĩa yi bèra a na à ɓa yí le Dónbeenì Hácírí. ");
INSERT INTO boxNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Le Dónbeenì Hácírí mu lá dĩǹ yí lion ɓarɛ́n ɓúi wán: Ɓa bátízéra ɓa o Ɲúhṹso Yeesu yèni yi mí dòn. ");
INSERT INTO boxNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ó o Piɛre là a Zãn wã́a bò mí níní ɓa wán á ɓa yú le Dónbeenì Hácírí. ");
INSERT INTO boxNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Bìo ó o Simɔn mɔn à bìa dó mí sĩa o Krista yi yú le Dónbeenì Hácírí pã̀ahṹ na á ɓa tonkarowà bò mí níní ɓa wán yi, ");
INSERT INTO boxNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ó o bía nɔn o Piɛre là a Zãn yi: «Mi fé le wárí à mi na ho dàńló mu ɓàn síi miì, bèra a na ká ĩ wé bò ĩ níi nùpue wán à wón yí le Dónbeenì Hácírí.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ó o Piɛre bía nɔn wo yi: «Le ũnɛ́n lè ũ wárí ɓúenɓúen páaní cĩ̀, lé bìo fo wee leéka le le Dónbeenì bè-hãnii á dà a yà. ");
INSERT INTO boxNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mu bìo mu á ũ níi yí túee yi, á fo mún yí ko làa bṹn, lé bìo á le Dónbeenì cɔ̃́n á fo yínɔń húaarà. ");
INSERT INTO boxNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bìo wi ũ sĩi yi yínɔń bìo na se. Cén día mu à ũ fìo o Ɲúhṹso yi ká mu dà a wé, ò o sɛ́n día na foǹ hã yile-kora na wi foǹ bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ĩ mɔn à mu koomu zon fo dàkhĩína ũ yí dà máa fé ũten mu bè-kora níi yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ó o Simɔn wã́a bía nɔn o Piɛre là a Zãn yi: «Minɛ́n miten fìo o Ɲúhṹso yi à na miì, bèra a na à bìo mi bía kà ɓúi yí yí mi.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","O Piɛre là a Zãn wee zéení bìo ɓa zũ a Ɲúhṹso dã́ní yi lè ɓa nùpua, á wee bue o bíonì. Bṹn mɔ́n á ɓa bĩnía ɲɔn ho Zeruzalɛɛmu, á wee bue le bín-tente ho Samarii lórá cɛ̀rɛ̀ɛ yi ká ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mu pã̀ahṹ ó o Ɲúhṹso wáayi tonkaro ɓúi bía nɔn o Filiipu yi: «Hĩ́ní dé ũ yahó lè le wii hɛ̀ɛníi ɓàn nín-káahó. Lá ho wɔ̃hṹ na ló ho Zeruzalɛɛmu yi á lion ho Kazaa, ho bèrowà yí boo lònbìo.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ó o Filiipu dɛ̀ɛnía hĩ́nɔn wà. Ho wɔ̃hṹ na ó o lá, á Etiopii nìi ɓúi bò. O lé ho Etiopii kɔ̃hṹ bɛ́ɛ hã́a Kandaasi ton-sá beenì na wi o nàfòró ɲúhṹ wán. O ɓuara ho Zeruzalɛɛmu ɓueé ɓùaanía le Dónbeenì ");
INSERT INTO boxNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","á bĩnía wee ɓo. Le *Dónbeenì ɲi-cúa fɛɛro *Ezayii vũahṹ lé hìa ó o kará mí wòtóró yi wee kàrán. ");
INSERT INTO boxNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Á le Dónbeenì Hácírí bía nɔn o Filiipu yi: «Bánbá vaa ɓúe ho wòtóró na kà yi à bĩ́ ho lɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ó o Filiipu lùwa vaá ɓó ho yi, á ɲá ò o Etiopii nìi wee kàrán o ɲi-cúa fɛɛro Ezayii vũahṹ, ó o tùara a yi: «Bìo fo wee kàrán kà á fo zũ kúará le?» ");
INSERT INTO boxNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ó o nìi bía: «Ĩ ì wé kaka á à zũńnáa mu ká a ɓúi yí zéenía mu làa mi.» Ò o wã́a le o Filiipu ɓuee yòo kɛɛní mí nìsã́ní. ");
INSERT INTO boxNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ho vũahṹ bìo na ó o nìi wee kàrán lé bìo kà: O bìo ɓonmín là a pio na ɓa ɓuan wà vaá ɓúe, O bìo ɓonmín là a pioza na ɓa wee khè vará, ká a dĩ̀n cɛ̀kɛ̀ yí máa wá. ");
INSERT INTO boxNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɓa zìíra a ɲúhṹ, yìa dà a fɛɛ ho tũ̀iá o ɲii á yí ló. Ɓa vĩ́inía o mukãnì ho tá wán, á lé o yɛ́n á à dàń ǹ bío ɓa zàwa bìo á a lɛɛ́ wo yi? ");
INSERT INTO boxNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ó o Etiopii nìi tùara a Filiipu yi: «Lée wée ó o ɲi-cúa fɛɛro mu wee bío bìo kà? Lé orɛ́n míten bìo ó o wee bío lée tàá lée nì-veere?» ");
INSERT INTO boxNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ó o Filiipu wã́a dĩ̀n ho vũahṹ bìo na ó o nìi kàránna wán á láráa le bíonì, ò o buera a Yeesu *Krista bín-tente nɔn wo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bìo ɓa wi ho wɔ̃hṹ wán wà, cúa-yɛn à ɓa vaá dɔ̃n ho saahó ɓúi na mu ɲumu wi yi. Ó o Etiopii nìi bía: «Lé mu ɲumu na. Bìo á à hè mi á ĩ máa bátízé lé mu yɛ́n.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ó o Filiipu bía nɔn wo yi: «Ká fo tà a Krista bìo lè ũ sĩi ɓúenɓúen á fo dà à bátízé.» Ó o nìi bía nɔn wo yi: «Ũuu, ĩ tà le o Yeesu Krista lé le Dónbeenì Za.» ");
INSERT INTO boxNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ò o dɛ̀ɛnía le ɓa dĩ̀ní ho wòtóró. Ó orɛ́n là a Filiipu lion lií zon mu ɲumu yi, á wón bátízéra a. ");
INSERT INTO boxNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bìo ɓa ló mu ɲumu yi, á le Dónbeenì Hácírí lá a Filiipu wàráa, ó o Etiopii nìi yí bĩnía yí mɔn wo. Ó o wã́a lá mí wɔ̃hṹ wà ká a sĩi wan làa sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","O Filiipu le mí ì loń ò o wi ho Azoote lóhó yi. Lé bĩ́n ó o dĩ̀n yi á wee hɛ́ɛ bue le bín-tente hã lórá ɓúenɓúen na ó o wee kã́a yi, fúaa bìo ó o vaá dɔ̃n ho *Sezaaree. ");
INSERT INTO boxNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Hón pã̀ahṹ so yi à bìo ó o Soole pá can mí kuio bìo yi, lé bìa tà a *Krista bìo lò beéró lè ɓa ɓúeró. Ó o wà van ɓa yankarowà ɲúhṹso cɔ̃́n, ");
INSERT INTO boxNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","à wón na ho vũahṹ wo yi, ò o ɓua varáa ho Damaasi lóhó yi, à vaa zéení lè ɓa *zúifùwa kàránló zĩní ɲúnása. Hón vũahṹ so lé hìa á à zéení le ká a yú ɓa báawa lè ɓa hã́awa na bò a Krista wɔ̃hṹ, ò o wìika ɓa ɓua varáa ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bìo ó o lá ho Damaasi wɔ̃hṹ á wà vaá sùará ho yi, yìo ɓueé tĩ à khoomu ɓúi ló ho wáayi lií kúaará a wán. ");
INSERT INTO boxNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ó o ló lùwá ho tá yi, á mu tãmu ɓúi wee bío làa wo: «Soole, Soole. Fo wee beé ĩ lò kà síi lé we?» ");
INSERT INTO boxNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ó o tùara: «Ɲúhṹso, fo lée wée?» Á mu tãmu bía nɔn wo yi: «Ĩ lé o Yeesu na á fo wee beé lò. ");
INSERT INTO boxNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wã́a lii hĩ́ní vaa zo ho lóhó yi. Ká fo zoó dɔ̃n, á ɓa à zéení bìo fo ko à ũ wé.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Á ɓa nùpua na bò là a Soole á dĩ̀n coon yí dà máa bío. Ɓa wee ɲí mu tãmu sã ká ɓa yí mɔn nùpue. ");
INSERT INTO boxNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ó o Soole lií hĩ́nɔn á hɛ́ra mí yìo, ká a màhã́ yí máa mi bìo. Á ɓa fù a níi yi á zonnáa ho Damaasi lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wizooní bìo tĩn ká a yí máa mi. O yí máa dí, á yí máa ɲu. ");
INSERT INTO boxNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nì-kenínii ɓúi hĩ́a wi ho Damaasi lóhó yi á yèni ɓa le Ananiasi. O Ɲúhṹso zéenía míten làa wo á von wo: «Ananiasi.» Ó o tà: «Ɲúhṹso, lé mi na.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ó o Ɲúhṹso bía nɔn wo yi: «Dɛ̀ɛní lɛ́n vaa lá ho wɔ̃hṹ na ɓa le ‹Wɔ̃hṹ na muina›, à va a Zudaa zĩi, à vaa tùa o Taasi nìi na ɓa le Soole bìo. Bìo kà wán ó o lan wee fìo. ");
INSERT INTO boxNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Á bìo ɓúi zéenía míten làa wo. O mɔn nìi ɓúi na ɓa le Ananiasi na ɓueé wee bè mí níní o wán, ò o yìo dàń bĩní mi.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ó o Ananiasi bía: «Ɲúhṹso, nùpua cɛ̀rɛ̀ɛ bía a nìi mu bìo nɔn miì, á mún zéenía mu bè-kora ɓúenɓúen na ó o wó lè ũ nùpua na ho Zeruzalɛɛmu yi nɔn miì. ");
INSERT INTO boxNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɓa yankarowà ɲúnása á nɔn ho pànká wo yi ò o ɓuee wìikaráa bìa ɓúenɓúen na wee ve ũ yèni hen.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ká a Ɲúhṹso màhã́ bía nɔn wo yi: «Lɛ́n va, lé bìo ó o nìi mu á ĩ léra le o sá ĩ tonló. Orɛ́n lé yìa á à zéení ĩ bìo á a na hã sìí-viò lè mí bá-zàwa là a *Isirayɛɛle nìpomu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Le lònbee ɓúenɓúen na a yí o ĩnɛ́n bìo yi á ĩ ì zéení làa wo.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ó o Ananiasi wã́a hĩ́nɔn wà, á vaá zon le zĩi yi, á zoó bò mí níní o Soole wán ò o bía nɔn wo yi: «Wàn za Soole, o Ɲúhṹso Yeesu na zéenía míten làa fo ho wɔ̃hṹ na fo lá wee ɓuennáa wán lé wón tonkaa mi ũ cɔ̃́n, à ũ bĩní wé mi, à ũ mún sí lè le Dónbeenì Hácírí.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mí lahó yi, á bìo ɓúi lòn donkuaa á ló a yìo yi, á kùenkaa lií kúaará ó o wã́a wee mi. Ó o hĩ́nɔn á ɓa bátízéra a. ");
INSERT INTO boxNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bṹn mɔ́n ó o dú ó o bĩnía yú ho pànká. O Soole wó hã wizooní bìo yɛn lè ɓa nì-kenínia na wi ho Damaasi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mí lahó yi ó o dɛ̀ɛnía wee zéení le Dónbeenì bìo ɓa *zúifùwa kàránló zĩní yi, á wee bue le o Yeesu lé le Dónbeenì Za. ");
INSERT INTO boxNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bìa ɓúenɓúen na ɲá a bíoní á mu vã̀, á ɓa wee bío: «Bìa wee ve o Yeesu yèni ho Zeruzalɛɛmu yi ó o nìi na kà so hĩ́a yí máa beé lò lè mí sòobɛ́ɛ le? Á yínɔń ɓarɛ́n ó o so ló bìo yí ɓuara á wà ɓueé wìika hen á vaá na ɓa yankarowà ɲúnása yi le?» ");
INSERT INTO boxNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ká a Soole yàá wíokaa wee zéení le Dónbeenì bìo lè mí pànká fɛ́ɛɛ. Bìo ó o wã́a wee zéení mu wéréwéré le o Yeesu lé o *Krista, á ɓa zúifùwa na ho Damaasi yi wã́a yí zũ bìo ɓa à bío á à na a yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wizooní bìo yɛn bṹn mɔ́n, á ɓa zúifùwa wã̀anía tò à ɓa le mí ì ɓúe o Soole. ");
INSERT INTO boxNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ká a ɓúi màhã́ ɲà a zeǹ wán. Ho lóhó zũaɲiní á ɓa wee pa yi le wisoni lè ho tĩ́nàahṹ à dàń yíráa wo ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hón pã̀ahṹ so yi ó o Soole nì-kenínia fó a ho tĩ́nàahṹ á dó ho lío-beenì yi, á lée liinía lè ho dándá na ɓa son kòonia ho lóhó yi mɔ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","O Soole wà vaá dɔ̃n ho Zeruzalɛɛmu, ó o wi ò o zo ɓa nì-kenínia tĩ́ahṹ, ká ɓa ɓúenɓúen màhã́ zã́na a lé bìo ɓa yí láa mu yi le o lée nì-kenínii binbirì. ");
INSERT INTO boxNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ó o Baanabaasi lé yìa wã́a fó a á dú yahó á vannáa ɓa tonkarowà cɔ̃́n, á vaá lá bìo ó o Soole mɔnnáa o Ɲúhṹso ho wɔ̃hṹ wán làa bìo á wón bíaráa làa wo á fɛɛra nɔn ɓa yi. O mún fɛɛra bìo ó o Soole ponì sɛ́raráa á zéenía lè le Dónbeenì bìo o Yeesu yèni yi ho Damaasi yi á nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","À lá hón pã̀ahṹ so yi ó o Soole wã́a wi làa ba, á wee bue le Dónbeenì bíonì à tè ho Zeruzalɛɛmu yi yòo lé ká a ponì sɛ́ra. ");
INSERT INTO boxNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","O mún wee bío lè ɓa zúifùwa na wee bío mu kɛrɛɛkimu, á wee wã̀aní làa ba. Ká bán màhã́ wee cà bìo ɓa à yíráa wo ò ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bìo á bìa tà a Krista bìo zũna mu, á ɓa lɛ̀ɛnía o Soole vannáa ho *Sezaaree, á día a bĩ́n ó o ɲɔn ho Taasi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mu pã̀ahṹ á bìa tà a Krista bìo wi ho hɛ́ɛrà yi ho *Zudee, lè ho Kalilee, lè ho *Samarii kãna yi. Ɓa pànká wee dé wán, á wee ɓua míten là a Ɲúhṹso kɔ̃̀nbii, á le Dónbeenì Hácírí wee dé mí níi ɓa yi á ɓa wee ɲin. ");
INSERT INTO boxNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","O Piɛre hĩ́nɔn tò ho kɔ̃hṹ ɓúenɓúen yi. Wizonle ɓúi ó o wà van bìa tà a *Krista bìo yi cɔ̃́n ho Lidaa lóhó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O vaá yú nìi ɓúi bĩ́n na yèni ɓa le Enɛɛ. O lé o mùamúa, á wi le dãmu dɛ̀ɛ yi yú hã lúlúio bìo hètĩn. ");
INSERT INTO boxNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ó o Piɛre bía nɔn wo yi: «Enɛɛ, o Yeesu Krista wee wɛɛ́ fo. Hĩ́ní hóoní ũ dãmu dɛ̀ɛ.» Ó o Enɛɛ dɛ̀ɛnía lií hĩ́nɔn. ");
INSERT INTO boxNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ho Lidaa lóhó lè hã lórá na wi ho Saarɔn kɔ̃hṹ tá pɛ̀ɛrú yi nùpua ɓúenɓúen mɔn wo, á ɓa tà nɔn míten o Ɲúhṹso yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Hã́a ɓúi na tà a Krista bìo na yèni ɓa le Tabita á hĩ́a wi ho Zopee lóhó yi. Le yèni mu lè mu kɛrɛɛkimu á ɓa le Dookaasi. Mu kúará le «hã́-wonì.» O hĩ́a wee wé mu bè-tentewà fɛ́ɛɛ, á wee séení ɓa nì-khenia. ");
INSERT INTO boxNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu pã̀ahṹ ò o tò mu vã́mú á húrun. Bìo ɓa súeenía wo vó, á ɓa yòó bàrá a ho nɔ́nwíohṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ho Lidaa lè ho Zopee sùaráa mín yi. Bìo ɓa nì-kenínia ɲá ò o Piɛre wi ho Lidaa yi, á ɓa léra ɓa nùpua nùwã ɲun tonkaa á bía bìo kà nɔn yi: «Wa wee fìo fo, bánbá à ũ ɓuen wa cɔ̃́n fùafùa.» ");
INSERT INTO boxNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Á ɓa vaá bía mu nɔn wo yi, ó o dɛ̀ɛnía hĩ́nɔn bò làa ba. Bìo ó o ɓueé dɔ̃n, á ɓa fó a yòoraráa ho nɔ́nwíohṹ na ó o nì-hío wi yi. Á ɓa mahã́awa ɓúenɓúen wee vá ɓuee ɓúe o yi ká ɓa à wá. Hã sĩ̀-zĩ́nia na ó o Dookaasi mu bã̀ ká a dĩǹ yí húrun á ɓa wee lá zéení làa wo. ");
INSERT INTO boxNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ó o Piɛre le ɓa ɓúenɓúen lé, ò o lií fárá mí nɔnkóɲúná wán, ò o fìora. Bṹn mɔ́n ó o yèrèmáa sánsáa o nì-hío ò o bía: «Tabita, lii hĩ́ní.» Ó o hɛ́ra mí yìo. Bìo ó o mɔn o Piɛre, ó o lii hĩ́nɔn yòó kará. ");
INSERT INTO boxNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ó o Piɛre ɓuan o níi yi, á séenía wo ó o lií hĩ́nɔn yòó dĩ̀n. Bṹn mɔ́n ó o von bìa tà a Krista bìo, lè ɓa mahã́awa, á ɓueé zéenía wo làa ba ká a yìo wi lua. ");
INSERT INTO boxNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ho Zopee nùpua ɓúenɓúen ɲá mu, á ɓa cɛ̀rɛ̀ɛ tà a Ɲúhṹso bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bṹn mɔ́n ó o Piɛre dá cãakaa ho Zopee yi o sɔ̃n-fì ɓúi na yèni ɓa le Simɔn cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nìi ɓúi hĩ́a wi ho *Sezaaree lóhó yi á yèni ɓa le Koronɛɛye. O hĩ́a lé ho Oroomu dásíwá ku-beenì ɓúi kuure ɲúhṹso, dìo ɓa wee ve làa Italii dásíwá kuure. ");
INSERT INTO boxNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","O nùpue mu hĩ́a wee bè le Dónbeenì làndá yi sese, orɛ́n lè mí zĩi nùpua ɓúenɓúen wee kɔ̃̀nbi le Dónbeenì. Ɓa *zúifùwa nì-khenia ó o hĩ́a wee séení lè mí sòobɛ́ɛ, á wee fìo le Dónbeenì yí máa khí. ");
INSERT INTO boxNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wizonle ɓúi wi-háarè yi, á bìo ɓúi zéenía míten làa wo. O mɔn le Dónbeenì wáayi tonkaro wéréwéré ò o ɓueé zoó wee bío làa wo: «Koronɛɛye.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ó o yòó lora wo yi lè le zã́níi ò o bía: «Ɲúhṹso, mu wan le?» Á ho wáayi tonkaro bía: «Le Dónbeenì tà ɲá ũ fìoró, á mún mɔn le séeníi na fo wee wé na ɓa nì-khenia yi, á le leékaa ũ bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Àwa, wã́a tonka ɓa nùpua bìo kà wán le ɓa va ho Zopee lóhó à vaa fé o nìi ɓúi na ɓa le Simɔn ɓuennáa, yìa ɓa mún wee ve le Piɛre. ");
INSERT INTO boxNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","O làara a nìi ɓúi na wee fì hã sɔ̃nna wán. O yèni ɓa le Simɔn, á zĩi wi mu yámú ɲumu ɲii.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bìo ho wáayi tonkaro na bía làa wo wà, ó o Koronɛɛye von mí ton-sáwá nùwã ɲun lè mí dásíwá nì-kéní na sá a cɔ̃́n míana á wa le Dónbeenì, ");
INSERT INTO boxNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","á bía bìo wó ɓúenɓúen nɔn ɓa yi, ò o tonkaa ɓa le ɓa va ho Zopee. ");
INSERT INTO boxNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Á ɓa wà. Ho tá tɔ̃n yú ɓa ká ɓa pá wi ho wɔ̃hṹ wán. Le wii á a bío le mí yòó fárá à dĩ̀n, à ɓa sùaráa ho Zopee. Lé hón pã̀ahṹ so yi ó o Piɛre yòora le zĩi lòho á wà yòó wé mí fìoró. ");
INSERT INTO boxNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bìo ó o yòó wi bĩ́n, á le hĩni dà a, ó o le mí ì dí. Bìo ɓa lan wee sĩ̀ ho dĩ́nló, á bìo ɓúi ɓueé zéenía míten làa wo. ");
INSERT INTO boxNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O mɔn ho wáayi à ho hɛ́ra. Á dɛ̀ɛ ɓúi lòn pɔ̃nsò-beenì á ɓa ɓuan ɲi-kã́a bìo náa yi, á yòó ló wee lii, á wà lií ɓúe ho tá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Le dɛ̀ɛ mu yi á naɲuwà laà náa náa sowa, làa bìa wee várá mí píorà wán, lè ɓa ɲínzàwa lè mí sìíwà ɓúenɓúen wi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Á tãmu ɓúi bía nɔn wo yi: «Piɛre, lii hĩ́ní ɓúe ɓa à là.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ó o Piɛre bía: «Ébé, Ɲúhṹso, ĩ máa wé mu. Dĩ́nló na ũ hò yi, làa hìa tun á ĩ dĩǹ yí dú yí mɔn hùúu.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Á mu tãmu bĩnía sã ɲá á bía nɔn wo yi: «Bìo na le Dónbeenì le mu wee ce vó à ũnɛ́n yí wé làa bìo na tun.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mu wó làa bṹn á dɔ̃n hã zen cúa-tĩn. Bṹn mɔ́n á le dɛ̀ɛ mu dɛ̀ɛnía ɓuan yòora ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ó o Piɛre wã́a wee tùa míten yi lè mu bìo na ó o mɔn ɓàn kúará. Hón pã̀ahṹ so yi, ò o Koronɛɛye nùpua na ó o tonkaa le ɓa ɓuen o Simɔn zĩi á tùakaa ɓueé dɔ̃n le ɓàn zũaɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Á ɓa von à ɓa tùara: «Lé hen kà ó o Simɔn na ɓa le Piɛre á làara yi le?» ");
INSERT INTO boxNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bìo ó o Piɛre pá lan wee le mí yi mí bè-minii ɓàn kúará wán, à bṹn le Dónbeenì Hácírí wee bío làa wo: «Loń, ɓa nùpua nùwã tĩn wi hen á wee cà fo. ");
INSERT INTO boxNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yí titika bìo, hĩ́ní lii bè làa ba, ĩnɛ́n lé yìa tonkaa ɓa.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ó o Piɛre wã́a hĩ́nɔn lion ɓa nùpua mu cɔ̃́n, á lií bía nɔn ɓa yi: «Yìa mi wee cà lé ĩnɛ́n ĩ bɛɛre, lée webio nɔn mi ɓuararáa hen?» ");
INSERT INTO boxNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Á ɓa bía: «Ɓa dásíwá ɲúhṹso ɓúi na ɓa le Koronɛɛye lé yìa tonkaa wɛn ũ cɔ̃́n. O lée nì-tente á wee kɔ̃̀nbi le Dónbeenì, á ɓa *zúifùwa ɓúenɓúen wee wíoka a yèni. Le Dónbeenì wáayi tonkaro ɓúi bía nɔn wo yi le o bío le ɓa ɓuee ve fo ɓuennáa mí cɔ̃́n, ò o ɲí bìo fo ò bío á à na a yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ó o Piɛre fó ɓa, á ɓa zoó cãana làa wo. Mu tá na lée tɔ̃n, ó o Piɛre làa ba páanía lá ho wɔ̃hṹ, á bìa tà a *Krista yi nùwã yɛn ɓúi ló ho Zopee yi á lɛ̀ɛnía ɓa. ");
INSERT INTO boxNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ɓa vará cãana á tá lée tɔ̃n vaá dɔ̃nnáa ho Sezaaree. Bṹn ǹ wé ò o Koronɛɛye, lè mín zĩi nùpua, lè mín bɔ̃́nlowà binbirí na ó o von á kará pan wo bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pã̀ahṹ na ó o Piɛre wà ɓueé zo yi, ó o Koronɛɛye hĩ́nɔn sã́ a yahó, á vaá lií ɓúrá a tá, ò o tɛ̀ɛnía wo yi lè le kɔ̃̀nbii. ");
INSERT INTO boxNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ká a Piɛre màhã́ fù a yi á hóonía ò o bía nɔn wo yi: «Lii hĩ́ní, ĩnɛ́n mún lé o nùpue lè ũ bìo síi.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bṹn mɔ́n ó o pá lan wee bío làa wo á vaá zonnáa le zĩi yi, á zoó yú ɓa nùpua cɛ̀rɛ̀ɛ ká ɓa kúaa mín wán, ");
INSERT INTO boxNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ó o bía nɔn ɓa yi: «Mi zũ le ɓa zúifùwa cɔ̃́n, á ho va ho sìí veere nùpue cɔ̃́n, tàá à páaní kɛɛní làa wo lée bìo na yí ko à mu wé, ká le Dónbeenì màhã́ zéenía mu nɔn miì le ĩ yí ko à ĩ lá nùpue woon lòn nì-tinii na á nùpue yí ko ò o wé va cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lé bṹn nɔn á ĩ yí pã́ mi veró à ĩ dɛ̀ɛnía ɓuara. Àwa, á mi wã́a zéení ĩ veró ɲúhṹ.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ó o Koronɛɛye bía: «Mu wizooní tĩ́n lée zuia, ho pã̀ahṹ dà-kéní kéní na kà yi, le wi-háarè, á ĩ wee fìo ĩ zĩi. Yìo ɓueé tĩ à nùpue ɓúi na dà-zĩ́nii wee ɲuiíka á dĩ̀n ĩ yahó, ");
INSERT INTO boxNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ò o bía: ‹Le Dónbeenì tà ɲá ũ fìoró, á mún mɔn le séeníi na fo wee wé à na ɓa nì-khenia yi, á le leékaa ũ bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wã́a tonka ɓa nùpua ho Zopee yi le ɓa vaa bío le o Simɔn na ɓa le Piɛre à ɓuen. O làara a Simɔn wán, yìa wee fì hã sɔ̃nna, na zĩi wi mu yámú ɲumu ɲii.› ");
INSERT INTO boxNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Á ĩ dɛ̀ɛnía tonkaa ɓa nùpua le ɓa vaa ve fo, á fo tà ɓuara bṹn se. Hã laà na kà wán, á wa ɓúenɓúen wi le Dónbeenì yahó hen à ɲínáa bìo ɓúenɓúen na ó o Ɲúhṹso dó ũ ɲii yi le ũ bío.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ó o Piɛre wã́a lá le bíonì á bía: «Bìo kà wán á ĩ wã́a zũ kɛ̃́nkɛ̃́n le le Dónbeenì yí máa hueeka ɓa nùpua mín yi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nùpue lée nùpue, ò o lé kɔ̃hṹ lée kɔ̃hṹ yi, ká a wee kɔ̃̀nbi le, á wee wé le sĩi bìo, se wón bìo sĩ le yi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mi zũ bìo le Dónbeenì bía nɔn o *Isirayɛɛle nìpomu yi ká le nɔn ho hɛ́ɛrà bín-tente ɓa yi, dìo ó o Yeesu *Krista ɓuararáa, wón na lé ɓa nùpua ɓúenɓúen Ɲúhṹso. ");
INSERT INTO boxNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bìo ó o Zãn bía le Dónbeenì bìo lè ɓa nùpua á bátízéra ɓa, á bìo ɓúakáa wó ho Kalilee yi, à lá bìo wó ho Zudee yi ɓúenɓúen á mi mún zũ. ");
INSERT INTO boxNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mi mɔn bìo le Dónbeenì liiníanáa mí Hácírí pànká o Nazarɛɛte nìi Yeesu wán. Mi mún zũ bìo ó o Yeesu mu varáráa ho kɔ̃hṹ yi, á wee wé mu bè-tente ká a wɛɛ́ bìa ó o *Satãni pànká wi wán ɓúenɓúen, lé bìo le Dónbeenì hĩ́a wi làa wo. ");
INSERT INTO boxNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bìo ɓúenɓúen na ó o wó ɓa zúifùwa kɔ̃hṹ lè ho Zeruzalɛɛmu yi á wa mɔn, á lé mu sɛɛ́ràsa. Ɓa ɓúaa wo ho *kùrùwá wán ó o húrun. ");
INSERT INTO boxNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ká le Dónbeenì màhã́ vèenía wo mu wizooní tĩn níi zoǹ á ɓa nùpua mɔn. ");
INSERT INTO boxNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mu yínɔń ɓa nùpua ɓúenɓúen mɔn wo. Warɛ́n na lé fèra hueekaa wó lè ɓa sɛɛ́ràsa lé warɛ́n mɔn wo. Bìo le Dónbeenì vèenía wo mɔ́ndɛ́n, á warɛ́n làa wo páanía dú á ɲun. ");
INSERT INTO boxNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O henía mu nɔn wɛn le wa zéení le Dónbeenì bìo, á mún bue na ɓa nùpua yi le orɛ́n lé yìa le Dónbeenì bàrá ò o cítí ɓa yèn-vèeniasa lè ɓa nì-hía. ");
INSERT INTO boxNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Le *Dónbeenì ɲi-cúa fɛɛrowà ɓúenɓúen bía a bìo, le nùpue lée nùpue na dó mí sĩi o yi, ó o ò yí mu bè-kora sɛ́ndíaró o yèni pànká yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pã̀ahṹ na ó o Piɛre lan wee bío yi, á le Dónbeenì Hácírí lion bìa wee ɲí a bíoní wán. ");
INSERT INTO boxNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bìa tà a *Krista bìo na lé ɓa *zúifùwa binbirí na bò là a Piɛre ɓuararáa á wó coon dàkhĩína le Dónbeenì Hácírí na le nɔn á le bɛra fò bìa yínɔń ɓa zúifùwa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Lé bìo ɓa wee ɲí à ɓa wee bío hã sìí-viò bíoní na ɓa yí zũ, á wee khòoní le Dónbeenì le bè-beera na le wó bìo yi. Ó o Piɛre bía: ");
INSERT INTO boxNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɓa nùpua na kà á ɓa dà à hè le ɓa yí bátízé ɓa lè mu ɲumu, ká ɓa ɲɔǹ yú le Dónbeenì Hácírí lè wa bìo síi le?» ");
INSERT INTO boxNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ò o nɔn le ɲii le ɓa bátízé ɓa o Yeesu Krista yèni yi. Bṹn mɔ́n á ɓa fìora a Piɛre le o wé hã wizooní bìo yɛn làa mí. ");
INSERT INTO boxNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɓa tonkarowà làa bìa tà a *Krista bìo na wi ho *Zudee yi á ɲá le bìa yínɔń ɓa *zúifùwa á mún tà le Dónbeenì bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bìo ó o Piɛre bĩnía van ho Zeruzalɛɛmu, á bìa tà a Krista bìo na lé ɓa zúifùwa binbirí á wee zá làa wo: ");
INSERT INTO boxNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Lée webio nɔn á fo vannáa bìa yínɔń ɓa zúifùwa cɔ̃́n á páanía dú làa ba?» ");
INSERT INTO boxNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ó o Piɛre wã́a lií lá bìo mu wóráa lè mí dà-kéní kéní ɓúenɓúen á fɛɛra nɔn ɓa yi kà síi: ");
INSERT INTO boxNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Mu wee wé ká ĩ wi ho Zopee lóhó yi á wee wé ĩ fìoró. Yìo ɓueé tĩ à bìo ɓúi zéenía míten làa mi. Mu lée dɛ̀ɛ ɓúi lòn pɔ̃nsò-beenì á ɓa ɓuan ɲi-kã́a bìo náa yi, na yòó ló ho wáayi á ɓueé lií ɓó miì. ");
INSERT INTO boxNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Á ĩ lora le yi sese, á mɔn ɓa naɲuwà laà náa náa sowa, bìa ho lóhó yi làa bìa hã mana yi, làa bìa wee várá mí píorà wán, lè ɓa ɲínzàwa. ");
INSERT INTO boxNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Á ĩ ɲá tãmu ɓúi sã na wee bío làa mi: ‹Piɛre, lii hĩ́ní ɓúe ɓa à là.› ");
INSERT INTO boxNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ká ĩ màhã́ bía: ‹Ébé, Ɲúhṹso, ĩ máa wé mu. Dĩ́nló na ũ hò yi, làa hìa tun á ĩ dĩǹ yí dú yí mɔn hùúu.› ");
INSERT INTO boxNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Á mu tãmu tĩ́n pá bĩnía sã ɲá á bía nɔn miì: ‹Bìo na le Dónbeenì le mu wee ce vó ũnɛ́n yí wé làa bìo na tun.› ");
INSERT INTO boxNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mu wó làa bṹn á dɔ̃n hã zen cúa-tĩn. Bṹn mɔ́n á le dɛ̀ɛ mu dɛ̀ɛnía bĩnía ɓuan yòora ho wáayi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Hón pã̀ahṹ dà-kéní so yi, à bṹn ɓa nùpua nùwã tĩn ɓúi na ɓa tonkaa á ló ho *Sezaaree yi á ɓueé dɔ̃n le zĩi na á ĩ wi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Á le Dónbeenì Hácírí bía le ĩ yí titika, le ĩ hĩ́ní bè làa ba. Wàn zàwa nùwã hèzĩ̀n na bò làa mi ɓuara hen, lé bán lɛ̀ɛnía mi vannáa ho Sezaaree, á wa vaá páanía zon o Koronɛɛye zĩi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Á wón lá bìo ó o wó wó mɔnnáa ho wáayi tonkaro mí zĩi ká a dĩ̀n wee bío làa wo kà síi: ‹Tonka ɓa nùpua le ɓa va ho Zopee à vaa ve o Simɔn na ɓa le Piɛre le o ɓuen. ");
INSERT INTO boxNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hã bíoní na á à kã̀ní ũnɛ́n lè ũ zĩi nùpua ɓúenɓúen lé hɔ̃́n ò o bío á a na foǹ.› ");
INSERT INTO boxNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Bìo á ĩ ɓúakáa wee bío à bṹn le Dónbeenì Hácírí lion ɓa wán, làa bìo le hĩ́a lionnáa warɛ́n wán mu ɲúhṹ ɓúɛɛníi bìo síi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Á ĩ hácírí màhã́ ɓuara bìo ó o Ɲúhṹso hĩ́a bía wán: ‹O Zãn hĩ́a wee bátízé lè mu ɲumu, ɛ̀ɛ ká minɛ́n bán á à bátízé lè le Dónbeenì Hácírí.› ");
INSERT INTO boxNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bìo le Dónbeenì hĩ́a hɔ̃n làa wɛn, pã̀ahṹ na wa tà a Ɲúhṹso Yeesu Krista yi, lé bṹn á le mún hɔ̃n lè ɓarɛ́n. Á ĩnɛ́n lée wée á à pĩ́ bìo le Dónbeenì le mí ì wé.» ");
INSERT INTO boxNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bìo ɓa ɲá hɔ̃́n bíoní so, á ɓa yòó wan tɛ̀ɛn, á wee khòoní le Dónbeenì kà síi: «Mu ɓɛ̀ntĩ́n bon. Le Dónbeenì mún tà nɔn ho wɔ̃hṹ bìa yínɔń ɓa zúifùwa yi à ɓa dàń yèrèmá mí yilera lè mí wárá, à yí le mukãnì binbirì na máa vé.» ");
INSERT INTO boxNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bìa tà a *Krista bìo lò beéró na ɓúakáa o Etiɛna ɓúeró pã̀ahṹ lé bṹn nɔn á ɓa saawaaráa. Ɓa ɓúi wà fúaa ho Fenisii lè ho Siipere kãna, lè ho Ãntiosi lóhó yi. Ká ɓa màhã́ vaá yí máa bue le Dónbeenì bíonì à na nì-vio yi, ká mu yínɔń ɓa *zúifùwa. ");
INSERT INTO boxNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ɛ̀ɛ ká bìa tà a Krista bìo nùwã yɛn ɓúi na wee lé ho Siipere lè ho Sirɛɛna yi, á ló van ho Ãntiosi, á mún vaá wee bue le Dónbeenì bín-tente na bìo ciran o Ɲúhṹso Yeesu à na bìa yínɔń ɓa zúifùwa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","O Ɲúhṹso dàńló fù wi làa ba, á nùpua cɛ̀rɛ̀ɛ á tà yèrèmáa bò a Ɲúhṹso yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ho Zeruzalɛɛmu kèrètĩ́ɛwa kuure ɲá mu bìo mu, á ɓa wã́a tonkaa o Baanabaasi le o va ho Ãntiosi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bìo ó o vaá dɔ̃n bĩ́n ó o mɔn bìo le Dónbeenì dúɓuaaráa bìa tà a Krista bìo yi, ó o zã̀makaa mu bìo yi, ò o henía ɓa ɓúenɓúen sĩa, à ɓa yí lé o Ɲúhṹso mɔ́n, ká ɓa tà a bìo mí sĩa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mu bon, o Baanabaasi ɓɛ̀ntĩ́n fù lée nùpue na se, á sú lè le Dónbeenì Hácírí, á dó mí sĩi o Ɲúhṹso yi. Nùpua cɛ̀rɛ̀ɛ tà nɔn míten o Ɲúhṹso yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bṹn mɔ́n ó o Baanabaasi wà van ho Taasi lóhó, á wà vaá cà a Soole. ");
INSERT INTO boxNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bìo ó o vaá yú a, ó o bò mín làa wo ɓuara ho Ãntiosi yi. Ɓa mí nùwã ɲun á wó le lúlú-kùure ká ɓa wee páaní kúee mín wán lè ho Ãntiosi kèrètĩ́ɛwa, á kàránna nùpua cɛ̀rɛ̀ɛ. Lé ho Ãntiosi yi á ɓa ɓúakáa wee veráa bìa tà a Krista bìo làa kèrètĩ́ɛwa. ");
INSERT INTO boxNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu pã̀ahṹ á le *Dónbeenì ɲi-cúa fɛɛrowà ɓúi ló ho Zeruzalɛɛmu yi á van ho Ãntiosi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ɓa nì-kéní na ɓa le Akabuusi á le Dónbeenì Hácírí bía nɔn yi, ó o hĩ́nɔn yòó dĩ̀n ò o bía le hen làa cĩ́inú ká le hĩn-sũmúi á à lé ho tá ɓúenɓúen wán. Á le ɓɛ̀n ló pã̀ahṹ na ó o Koloode wó ho *Oroomu bá-zàwa bɛ́ɛ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Á ɓa nì-kenínia wã̀anía tò, le mí nì-kéní kéní á a na bìo na mí dà a na á à wé lè le séeníi á à toní ì na bìa tà a Krista bìo ho *Zudee yi. ");
INSERT INTO boxNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Á bṹn lé bìo ɓa wó, à ɓa tonkaa o Baanabaasi là a Soole le ɓa ɓua mu vaa na ho Zudee kɔ̃hṹ kèrètĩ́ɛwa kuio ya-díwá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu pã̀ahṹ ká a bɛ́ɛ *Heroode wee beé ɓa kèrètĩ́ɛwa nùwã yɛn ɓúi sãnía lò. ");
INSERT INTO boxNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O ɓó a Zãn ɓàn kĩ́nle Zaaki lè ho khà-tóní. ");
INSERT INTO boxNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bṹn mɔ́n, á bìo ó o mɔn à mu sĩ ɓa *zúifùwa yi, ó o mún wìira a Piɛre. Bṹn wó ho *búurú na á ɲa-fĩni yí dó yi sã́nú díró pã̀ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bìo ó o Piɛre ɓa wìira, ó o Heroode nɔn le ɲii le ɓa dé o ho kàsó yi, ò o bàrá ɓa dásíwá nùwã náa náa kuio bìo náa le ɓa pa a yi. O lá wee leéka le ká ho *Paaki sã́nú dú khĩína, o ò cítí o ɓa nùpua yìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","O Piɛre wón ɓa wã́a pan yi ho kàsó yi, ká ɓa kèrètĩ́ɛwa kuure ɓɛ̀n wee fìo le Dónbeenì yi na a yi lè mí sòobɛ́ɛ. ");
INSERT INTO boxNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ho tĩ́nàahṹ na tá lée tĩ ó o Heroode á à cítí o ɓa nùpua yìo yi, ká a Piɛre ɓa can lè hã zúakùaríwà bìo ɲun ó o dũma ɓa dásíwá nùwã ɲun pã̀ahṹ. Á ɓa parowà mún dĩ̀n mí lara yi ho kàsó zĩi zũaɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yìo ɓueé tĩ à wáayi tonkaro ɓúi dĩ̀n, á mu khoomu ɓúi ɲuiína zoó ho kàsó zĩi. Ó o Ɲúhṹso wáayi tonkaro lií ɓúanɓúaa o Piɛre dòkóní, á sĩ̀nía wo, ò o bía nɔn wo yi: «Lii hĩ́ní fùafùa.» Hón pã̀ahṹ so yi á hã zúakùaríwà feera a níní yi lií kúaará. ");
INSERT INTO boxNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Á ho wáayi tonkaro bía nɔn wo yi: «Ca ũ kìrí à ũ zĩ́ ũ nakãa.» Ó o Piɛre wó bṹn. Ó o bía nɔn wo yi: «Lá ũ kánɓun zĩ́ à ũ bè miì.» ");
INSERT INTO boxNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ó o Piɛre wó bṹn ò o ló lée bò a yi. O yí máa leéka le bìo ho wáayi tonkaro wee wé á bon. O wee leéka le hã lée kònkórá. ");
INSERT INTO boxNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓa lée khĩína ɓa nín-yání parowà, á bĩnía vaá khĩína bìa sã̀, á wà vaá ɓó ho hɔ̃nló woohṹ na sánsáa ho lóhó yi, á hón hɛ́ra míten á ɓa yòó ló. Bìo ɓa lá ho wɔ̃hṹ wà, yìo ɓueé tĩ à ho wáayi tonkaro wà ò o día a Piɛre. ");
INSERT INTO boxNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ó o Piɛre wã́a zũna le bìo wó kà bon, ó o bía: «Hã laà na kà wán á ĩ wã́a zũ mu kɛ̃́nkɛ̃́n le o Ɲúhṹso lé yìa tonkaa mí tonkaro na ló ho wáayi ó o ɓueé lií kã̀nía mi o Heroode níi yi, á mún kã̀nía mi le lònbee ɓúenɓúen na ɓa zúifùwa lá wee fan le le yí mi yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bìo ó o lon mí yi vó, ó o wà van o Zãn na ɓa le Maaki ɓàn nu Mari zĩi. Ɓa nùpua cɛ̀rɛ̀ɛ kúaa mín wán bĩ́n á wee fìo. ");
INSERT INTO boxNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","O vaá ɓúanɓúaa ho zũaɲii woohṹ, ó o ton-sá hã́a ɓúi na ɓa le Oroode á hĩ́nɔn wà ɓueé hɛ́n ho. ");
INSERT INTO boxNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bìo ó o ɓueé zũna a Piɛre tãmu, ó o sĩi wan wan á yí hɛ́ra ho woohṹ ò o bĩnía lùwa zoó bía le o Piɛre lée wi ho zũaɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Á ɓa bía nɔn wo yi: «Fo yàá wee khée.» Ká a màhã́ wee bío le mu bon kɛ̃́nkɛ̃́n. Á ɓa wã́a bía: «Áyì! Mu lé o nì-hɔ̃́nbómu.» ");
INSERT INTO boxNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ó o Piɛre pá dĩ̀n wee ɓúanɓúa ho woohṹ. Bìo ɓa wó san hɛ́ra ho, á ɓa mɔn wo á mu wó ɓa coon. ");
INSERT INTO boxNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ó o lá mí níi dá ɓa yi le ɓa wé tɛ́tɛ́, ò o zéenía bìo ó o Ɲúhṹso wó wó léraráa wo ho kàsó yi làa ba, ò o pá bĩnía bía: «Mi bío mu na a Zaaki lè wàn zàwa na so yi.» Bṹn mɔ́n ó o ló á wà van lòn-veere. ");
INSERT INTO boxNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bìo ho tá tɔ̃n á ɓa dásíwá ɓúenɓúen kánkáa, á wee cà à ɓa zũń bìo ó o Piɛre bìo wóráa. ");
INSERT INTO boxNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ó o Heroode le ɓa cà a, á ɓa cà a san ɓa yí yú a, ó o tùakaa bìa lá pan wo yi, ò o nɔn le ɲii le ɓa ɓúe ɓa. Bṹn mɔ́n ó o Piɛre ló ho *Zudee yi á vaá kará dóka mí yi ho *Sezaaree yi. ");
INSERT INTO boxNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","O Heroode sĩi hĩ́a wee cĩ̀ ho Tiire lè ho Sidɔ̃n lórása yi dàkhĩína. Á bìo ɓa bè-dínii wee lé o Heroode mu ɓàn kɔ̃hṹ yi, á ɓa wó le ɲii dà-kéní à ɓa le mí ì va a cɔ̃́n. À ɓa ɓueé dĩ̀n o Bilasutuusi wán, yìa wi o Heroode mu zĩi tonni ɲúhṹ wán. Ɓa wà zoó yanka a ò o le mí véení hã bíoní. ");
INSERT INTO boxNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bìo le wizonle na ɓa bàrá dɔ̃n, ó o Heroode lá mí bá-zàmu sĩ̀a zã́, ò o kará mí bɛ́ɛnì kanmúiní wán, ò o lá le bíonì ɓa zã̀amáa yahó. ");
INSERT INTO boxNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Á mu nìpomu ɓúenɓúen bía pɔ̃́npɔ̃́n: «Mu yí nɔn nùpue wee bío, mu lée dofĩ́ní ɓúi.» ");
INSERT INTO boxNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pã̀ahṹ na ɓa wee bío mu yi, à bṹn le Dónbeenì wáayi tonkaro ɓúi vĩ́na a Heroode, lé bìo ho cùkú na bìo sã̀ le Dónbeenì yi ó o fó bò míten wán. Á ɓa sũnɓowa zon wo ó o húrun. ");
INSERT INTO boxNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Le Dónbeenì bíonì wee bɛn fè hã lùa ká le wà. ");
INSERT INTO boxNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bìo ó o Baanabaasi là a Soole tonló vó ho Zeruzalɛɛmu yi, á ɓa fó a Zãn na ɓa le Maaki á wàráa. ");
INSERT INTO boxNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ho Ãntiosi kèrètĩ́ɛwa kuure yi á ɓa ɲi-cúa fɛɛrowà lè ɓa nì-kàránlowà hĩ́a wi yi. Ɓa lé o Baanabaasi là a Soole, là a Simiɔn na ɓa wee ve làa Nì-bírí, là a Sirɛɛna nìi Lisiyuusi, là a Manaɲɛɛ na páanía dɔ̃n là a bɛ́ɛ *Heroode. ");
INSERT INTO boxNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wizonle ɓúi, ká ɓa wee ɓùaaní a Ɲúhṹso, á lù mí ɲiní, á le Dónbeenì Hácírí bía nɔn ɓa yi: «Mi lén o Baanabaasi là a Soole mí dòn à ɓa sá ho tonló na á ĩ von ɓa bìo yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Á bìo ɓa lù mí ɲiní à ɓa fìora vó, á ɓa bò mí níní ɓa wán à ɓa nɔn ho wɔ̃hṹ ɓa yi á ɓa wà. ");
INSERT INTO boxNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bìo ó o Baanabaasi là a Soole á le Dónbeenì Hácírí wã́a von kà síi, á ɓa wà van ho Selesii lóhó. Lé bĩ́n á ɓa zon ho won-beenì yi vannáa ho Siipere kɔ̃hṹ na wi mu ɲumu tĩ́ahṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bìo ɓa vaá dɔ̃n ho Siipere kɔ̃hṹ lóhó na ɓa le Salamiina á ɓa wã́a wee bue le Dónbeenì bíonì ɓa *zúifùwa kàránló zĩní yi. Yìa kɛra bĩ́n làa ba á wee séení ɓa lé o Zãn Maaki. ");
INSERT INTO boxNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ho kɔ̃hṹ ɓúenɓúen ɓa tò yi yòó ló, á vaá ɓó ho Pafoosi lóhó yi. Lé bĩ́n á ɓa fò mín là a zúifù nìi ɓúi na wee wé mu nín-símú na ɓa le Bara-Yeesu yi. O lá wee lá míten lòn ɲi-cúa fɛɛro. ");
INSERT INTO boxNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","O hĩ́a wi ho kɔ̃hṹ mu ɲúhṹso na ɓa le Sɛɛziyuusi Poluusi cɔ̃́n. O nìi mu fù lée nùpue na hácírí wi. O wi ò o ɲí le Dónbeenì bíonì. Ó o von o Baanabaasi là a Soole le ɓa ɓuen mí cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ká a nín-símú ɓànso Elimaasi á yí wi à ho kɔ̃hṹ mu ɲúhṹso à tà a *Krista bìo ó o wi ò o hè ɓa. (Ɓa *Kɛrɛɛsisa wee ve o Bara-Yeesu mu làa Elimaasi.) ");
INSERT INTO boxNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hón pã̀ahṹ so yi, ó o Soole na ɓa mún wee ve làa Poole á le Dónbeenì Hácírí wã́a sú ó o fá mí yìo wo yi, ");
INSERT INTO boxNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ò o bía: «Ũnɛ́n *Satãni za sabín-fũ̀aalo yɛ́n. Fo wee vĩ́iní ɓa nùpua. Mu bìo na se ɓúenɓúen fo wee firáa. O Ɲúhṹso sĩi bìo bṹn térénna, à ũnɛ́n wón wee báaráka làa bũ. Cén khí mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Àwa, wã́a loń mu. O Ɲúhṹso á à ɓóoní foǹ. Fo ò wé o muii, á à cãaka ká ũ máa mi le wii khoomu.» Mí lahó yi ó o Elimaasi yìo dɛ̀ɛnía coora, á wó mí tíbírí. Ó o wee hɛ́ɛ vĩ́ná, á wee cà yìa á à tè o níi yi ì lɛ́nnáa. ");
INSERT INTO boxNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bìo ho kɔ̃hṹ ɲúhṹso mɔn bìo wó, ó o tà dó mí sĩi o Krista yi. O Ɲúhṹso bìo na ó o wee ɲí á zon wo dà. ");
INSERT INTO boxNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","O Poole lè mí ninzàwa á zon ho won-beenì ho Pafoosi yi á van ho Pãnfilii kɔ̃hṹ lóhó na ɓa le Pɛɛze. Bìo ɓa vaá dɔ̃n bĩ́n, ó o Zãn Maaki día ɓa, ò o bĩnía van ho Zeruzalɛɛmu. ");
INSERT INTO boxNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓarɛ́n bán dĩ̀n ho Pɛɛze yi à ɓa lá ho won-beenì, á vaa dɔ̃n ho Pizidii kɔ̃hṹ lóhó na ɓa le Ãntiosi. Ho *Sabaa zoǹ, á ɓa zon ho kàránló zĩi yi á zoó kará. ");
INSERT INTO boxNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bìo ɓa kàránna ho làndá vũahṹ lè le *Dónbeenì ɲi-cúa fɛɛrowà vũahṹ vó, á ho kàránló zĩi ɲúhṹso le ɓa bío bìo kà na ɓa yi: «Wàn zàwa, hen ká bíonì wi mi cɔ̃́n á mi le mi ì hĩ̀í lè ɓa nùpua sĩa se mi wã́a dà à bío.» ");
INSERT INTO boxNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ó o Poole lií hĩ́nɔn yòó dĩ̀n ò o dá mí níi le ɓa wé tɛ́tɛ́, ò o bía: «Minɛ́n *Isirayɛɛlesa, lè minɛ́n na wee kɔ̃̀nbi le Dónbeenì ɓúenɓúen, mi ɲí bìo á ĩ ì bío: ");
INSERT INTO boxNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","O Isirayɛɛle nìpomu na kà ɓàn Dónbeenì lé dén hueekaa wàn ɓùaawa. Le wó á mu nìpomu na kà ɲina ho *Ezipite yi pã̀ahṹ na ɓa wi mu nì-hãmu yi bĩ́n. Bṹn mɔ́n á le léra ɓa bĩ́n lè mí pànká. ");
INSERT INTO boxNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Le ɓuan ɓa hã mana tá henì yi á yú lòn lúlúio ɓúará-ɲun síi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ho Kanan kɔ̃hṹ yi á hã sìíwà bìo hèɲun nùpua á le ɓó ɲúhṹ, á fó táwá nɔn mí nìpomu yi, à hã bìo sĩ̀ ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mu ɓúenɓúen wó á míana yú hã lúlúio khĩá-náa làa ɓúará-ɲun làa pírú síi. «Bṹn mɔ́n á le Dónbeenì hueekaa ɓa ɓúi wàn ɓùaawa tĩ́ahṹ á wó lè ɓa ɲúnása, à bán wé fáa ɓa tũ̀iáwà. Á mu wó làa bṹn fɛ́ɛɛ á ɓueé ɓó a ɲi-cúa fɛɛro Samuwɛɛle pã̀ahṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bṹn mɔ́n á ɓa fìora a bɛ́ɛ le Dónbeenì cɔ̃́n á le nɔn o Kiisi za Sayuule ɓa yi. Wón na wee lé o Bɛ̃nzamɛɛ zĩ-ɲúhṹ yi. Á wón kɛra ɓa ɲúhṹ wán á dɔ̃n hã lúlúio ɓúará-ɲun. ");
INSERT INTO boxNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bìo le hĩ́a pã́ a Sayuule día á le nɔn o *Daviide ɓa yi á wó lè ɓa bɛ́ɛ. Wón Daviide so á le bía bìo kà dã́ní yi: ‹Ĩ sĩi nùpue á ĩ wã́a yú, o lé o Zesee za Daviide wón lé yìa á à wé bìo ɓúenɓúen na á ĩ ì bío le o wé á à tií ɲii.› ");
INSERT INTO boxNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","O Daviide mɔ̀nmàníi nì-kéní ɓúi lé o Yeesu. Lé wón le Dónbeenì wó là a Isirayɛɛle nìpomu kã̀nílo, làa bìo á le hĩ́a dóráa mí ɲii le mí ì wé làa bũ. ");
INSERT INTO boxNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sã́ni ò o Yeesu ɓuen, à bṹn ó o Zãn buera nɔn o Isirayɛɛle nìpomu ɓúenɓúen yi le ɓa yèrèmá mi yilera lè mi wárá à ɓa bátízé ɓa. ");
INSERT INTO boxNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pã̀ahṹ na ó o Zãn mukãnì véró wà ɓueé dã, ó o wee bío: ‹Mi wee leéka le ĩ lée wée? Yìa mi wee lòoní wi mí dòn le ĩnɛ́n. Ɛ̀ɛ ká mi màhã́ loń, ɓànso wi ĩ mɔ́n lùa. Hàrí o nakãa tɛnló á ĩ pá yí koráa.› ");
INSERT INTO boxNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Wàn zàwa, minɛ́n na lé o *Abarahaamu mɔ̀nmànía làa bìa mi tĩ́ahṹ na wee kɔ̃̀nbi le Dónbeenì, lé warɛ́n á ho fenló bíonì na kà á buera nɔn yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ho Zeruzalɛɛmusa lè mí ɲúnása á yí zũna a Yeesu bìo ɓàn ɲúhṹ á mún yí zũna ɓa ɲi-cúa fɛɛrowà bíoní na wee kàrán ho *Sabaa wizooní lè mí dà-kéní kéní yi kúará. O Yeesu mu á ɓa síinía ɲúhṹ á tiíraráa ɓa ɲi-cúa fɛɛrowà bíoní ɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bìo ɓa à dĩ̀n wán á à ɓúeráa wo á ɓa yí yú, á ɓa le o *Pilaate bío le ɓa ɓúe o. ");
INSERT INTO boxNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bìo á bìo ɓúenɓúen na le Dónbeenì bíonì vũahṹ bía a Yeesu dã́ní yi á ɓa wó á mu ɲii tun á ɓa liinía wo ho *kùrùwá wán á lií nùuna. ");
INSERT INTO boxNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ká le Dónbeenì màhã́ vèenía wo. ");
INSERT INTO boxNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hã wizooní cɛ̀rɛ̀ɛ yi ó o Yeesu zéenía míten làa bìa na hĩ́a lɛ̀ɛnía wo ho Kalilee yi fúaa ho Zeruzalɛɛmu. Lé bán wã́a wó a sɛɛ́ràsa á wee bío o bìo à na a Isirayɛɛle nìpomu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Warɛ́n lé bìa wee bue le Dónbeenì bín-tente à na mia: Le Dónbeenì ɲii na le dó nɔn wàn ɓùaawa yi ");
INSERT INTO boxNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","á bìo ɲii sú. Le vèenía o Yeesu á tiíraráa mu ɲii bìo kà wán á nɔn warɛ́n na lé ɓa mɔ̀nmànía yi, làa bìo mu túararáa hã Lení vũahṹ lení bìo ɲun níi yi: ‹Fo lé ĩ Za. Ho zuia ɲii wán á ĩ lé mìn Maá›. ");
INSERT INTO boxNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Le Dónbeenì hĩ́a bía mu le mí ì vèení a ó o máa bĩní máa hí. Bìo kà lé bìo le hĩ́a bía: ‹Ĩ ì dúɓua mia lè hã dúɓuaa na láayi wi. Hĩ̀a á ĩ dó ĩ ɲii nɔn o Daviide yi le ĩ na›. ");
INSERT INTO boxNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lé bṹn nɔn ó o pá wíokaa bía mu le Dónbeenì bíonì vũahṹ lahó ɓúi yi: ‹Fo máa día á yìa bìo sã̀ foǹ máa soo le búure yi›. ");
INSERT INTO boxNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","O Daviide pã̀ahṹ, ó o hĩ́a tà sá ho tonló na le Dónbeenì le o sá. Bṹn mɔ́n ó o húrun á ɓa nùuna a ɓàn ɓùaawa nìsã́ní ó o soora. ");
INSERT INTO boxNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ká yìa le Dónbeenì vèenía wón yí soora. ");
INSERT INTO boxNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Wàn zàwa, mi ko mi zũń mu le lé o Yeesu bìo yi á mu bè-kora sɛ́ndíaró bìo á bueraráa nɔn mia. Orɛ́n lé yìa á nùpue lée nùpue dó mí sĩi yi, ó o ò fen mí bè-kora ɓúenɓúen yi, bìo ó o *Mɔyiize làndá lá yí dà máa fení mia yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Á mi cén pa miten bìo, à bìo ɓa ɲi-cúa fɛɛrowà bía à yí yí mia, mu bía kà síi: ");
INSERT INTO boxNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Minɛ́n khònlowà, mi loń. Mi bìo á à vĩ̀níka mia. Mi ì hí á à lé bĩ́n. Bìo mi yìo wi lua, á ĩ ì wé yéréké bìo ɓúi na ɓa bía bìo nɔn mia, á mi máa dé mi sĩa mu yi.›» ");
INSERT INTO boxNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bìo ó o bía bṹn vó, ó orɛ́n là a Baanabaasi ló ɓa *zúifùwa kàránló zĩi yi. Á bìa wi bĩ́n fìora ɓa le ɓa bĩní ɓuen ho *Sabaa wizonle na sã̀ yi, à wíoka ɓuee bío mu bìo dà-kéní mu dã́ní yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ho kúeemínwánló mɔ́ndɛ́n á ɓa zúifùwa cɛ̀rɛ̀ɛ, lè ɓa nì-vio na yèrèmáa zon ɓa yi, á tà bò a Poole là a Baanabaasi yi. Á bán wee bío làa ba ká ɓa à hení ɓa sĩa à ɓa ca tĩn le Dónbeenì sãamu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ho Sabaa na sã̀ zoǹ, lée cĩ́inú ká, ká ho lóhó nùpua ɓúenɓúen á lá à lé è vé, á ɓueé ɲí a Ɲúhṹso bíonì. ");
INSERT INTO boxNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bìo ɓa zúifùwa mɔn ɓa zã̀amáa, á le yandee sú ɓa, á ɓa wee kán o Poole ká ɓa à là a. ");
INSERT INTO boxNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ó o Poole là a Baanabaasi wã́a wee bío bìo kà làa ba ká ɓa poní sɛ́ra: «Le Dónbeenì bíonì á lá ko à le bue na minɛ́n yi vé. Ká bìo mi pã́ le, á wee leéka le mi yí ko lè le mukãnì binbirì na máa vé, à wa wã́a a yèrèmá à va bìa yínɔń ɓa zúifùwa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bìo kà lé bìo le Dónbeenì bía nɔn wɛn: ‹Ĩ bàrá fo á wó lè hã kãna ɓúenɓúen nìpomu khoomu, bèra a na à ũ bue ho fenló bìo ho dĩ́míɲá kùaráa ɓúenɓúen yi.›» ");
INSERT INTO boxNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bìo á bìa yínɔń ɓa zúifùwa ɲá hɔ̃́n bíoní so, á ɓa wee zã̀maka ká ɓa à khòoní a Ɲúhṹso bíonì. Bìa ɓúenɓúen na bìo sã̀ le mukãnì binbirì na máa vé yi, á tà nɔn míten. ");
INSERT INTO boxNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","O Ɲúhṹso bíonì wee bɛn fè ho kɔ̃hṹ ɓúenɓúen nìpomu. ");
INSERT INTO boxNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ká ɓa zúifùwa màhã́ hĩ́nɔn sũ̀na ɓa hã́awa na níní se na wee kɔ̃̀nbi le Dónbeenì, lè ho lóhó ya-díwá, á wó le ɲii dà-kéní làa ba, à ɓa wee beé o Poole là a Baanabaasi lò, á ɲɔn ɓa léra mín kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Á ɓa báawa nùwã ɲun mu púaara mí zení khṹnkhũnì á kúaa ɓa wán, à ɓa wà van ho Ikoniyuumu lóhó. ");
INSERT INTO boxNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ɓa nì-kenínia á sĩa wan làa sòobɛ́ɛ, á sú lè le Dónbeenì Hácírí. ");
INSERT INTO boxNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bìo ó o Poole là a Baanabaasi vaá dɔ̃n ho Ikoniyuumu lóhó yi, á ɓa vaá zon ɓa *zúifùwa kàránló zĩi. Á bìo ɓa zoó bía á wó, á ɓa zúifùwa làa bìa yínɔń ɓa zúifùwa cɛ̀rɛ̀ɛ á tà a *Krista bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ká ɓa zúifùwa na pã́ a Krista bìo á súkúra bìa yínɔń ɓa zúifùwa, fúaa ɓa wee leéka mu bè-kora làa bìa tà a Krista bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bṹn lé bìo nɔn ó o Poole là a Baanabaasi á kará míana ho Ikoniyuumu yi. Ɓa wee bío ká ɓa ponì sɛ́ra, á dó mí sĩa o Ɲúhṹso yi. O Ɲúhṹso wee na mí pànká ɓa yi à ɓa wéráa mu yéréké bìowa na wee zéení le Dónbeenì pànká, à zéení le bìo ɓa wee bío o sãamu dã́ní yi lée tũ̀iá. ");
INSERT INTO boxNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Á ho lóhó nùpua sankaa lè hã kuio bìo ɲun. Ɓa sɔ̃́n-kéní tà ɓa zúifùwa ɲii, ká bìa so ɓɛ̀n tà ɓa tonkarowà ɲii. ");
INSERT INTO boxNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɓa zúifùwa làa bìa yínɔń ɓa zúifùwa lè mí ɲúnása wee wíoka míten ká ɓa à beé o Poole là a Baanabaasi lò, á à lèeka ɓa lè hã huaa á à ɓúe. ");
INSERT INTO boxNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bìo ɓa mí nùwã ɲun zũna mu, á ɓa lùwa, á dó mí yara lè ho Lisitere lè ho Dɛɛbe na lé ho Likawonii kɔ̃hṹ lórá cɔ̃́n, lè hã lórá na bã́makaa hã. ");
INSERT INTO boxNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bìo ɓa vaá dɔ̃n á ɓa lan wee bue le bín-tente bĩ́n. ");
INSERT INTO boxNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nìi ɓúi wi ho Lisitere yi á zení húrun kará. O ton ká a lé o mùamúa, á dĩǹ yí varákaa yí mɔn hùúu. ");
INSERT INTO boxNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","O kará wee ɲí bìo ó o Poole wee bío. Ó o Poole fá mí yìo wo yi, á mɔn à bìo ó o dó mí sĩi o *Krista yi á dà à wee wɛɛ́, ");
INSERT INTO boxNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ó o wã́a bía nɔn wo yi pɔ̃́npɔ̃́n: «Lii hĩ́ní yòo muin dĩ̀n ũ zení wán.» Ó o nìi yéran fárá mí zení wán á varákaa wà. ");
INSERT INTO boxNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bìo ɓa zã̀amáa mɔn bìo ó o Poole wó, á ɓa bía pɔ̃́npɔ̃́n lè ho Likawonii kɔ̃hṹsa bíonì: «Éee! Hã dofĩ́ina ɓúi lá a nùpue sìí á ɓueé lií ɓó wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","O Baanabaasi ɓa wee ve làa Zeesi, ká a Poole ɓa wee ve làa Hɛɛmɛɛsi, lé bìo ká mu lée bìo na ò o Poole lé yìa bío. ");
INSERT INTO boxNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ho Zeesi na lé ɓa dofĩ́ní ɓúi á zĩi hĩ́a wi ho lóhó ɲii. Dén dofĩ́ní so yankaro lé yìa ɓuan ɓa dãaní na ɓa donkhueéra lè le pũ̀iílè á ɓueé dĩ̀nnáa ho lóhó dándá na son kòonia ho zũaɲiní ɲii. O wi ò orɛ́n lè ɓa zã̀amáa à wé mu hãmu à na a Poole là a Baanabaasi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bìo ɓa tonkarowà mí nùwã ɲun zũna mu, á ɓa lɛ̀ɛkaa mí sĩ̀-zĩ́nia à zéení ká ɓa yí wa bìo ɓa le mí ì wé, à ɓa fáara yòó zon ɓa zã̀amáa tĩ́ahṹ, ");
INSERT INTO boxNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ká ɓa à bío pɔ̃́npɔ̃́n: «Éee! Minɛ́n nùpua mu, lée webio nɔn á mi wee wéráa bìo kà? Warɛ́n mún lé ɓa nùpua lè mí bìo síi, á wee bue le bín-tente na mia le mi ko à mi día hɔ̃́n wɔ̃̀n-kã́amáawa so, ká mi yèrèmá sánsá le Dónbeenì na wi fɛ́ɛɛ, dìo léra ho wáayi, lè ho tá, lè mu yámú ɲumu làa bìo wi mu yi ɓúenɓúen. ");
INSERT INTO boxNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Hã pɔ̃̀nna na khĩína yi, á le Dónbeenì día hã sìíwà nùpua ɓúenɓúen á ɓa bò mí sĩi wãna. ");
INSERT INTO boxNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ká le ɲɔǹ wee zéení míten lè mu bè-tentewà na le wee wé: Làa lúlúio ká le wee na ho viohó mia, à ho dĩ́nló be wé se, à mi wé dí sì à sĩa wa.» ");
INSERT INTO boxNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hàrí hã bíoní na ó o Poole là a Baanabaasi bía kà à hèráa ɓa zã̀amáa mu hãmu na ɓa le mí ì wé á à na ɓa yi bìo yi, á pá wó le lònbee. ");
INSERT INTO boxNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mu pã̀ahṹ, à ɓa zúifùwa ɓúi ló ho Ãntiosi lè ho Ikoniyuumu lórá yi á ɓuara ho Lisitere yi. Lé bán lè ɓa zã̀amáa wó le ɲii à ɓa lèekaa o Poole lè hã huaa, á várá wo lóráa ho donkĩ́ahṹ, lé bìo ɓa wee leéka le o húrun. ");
INSERT INTO boxNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bìo ɓa nì-kenínia ló lée dĩ̀n kĩ́nía wo yi, ó o lií hĩ́nɔn, á zon ho lóhó yi. Mu tá na lée tɔ̃n, ó orɛ́n là a Baanabaasi bò mín van ho Dɛɛbe. ");
INSERT INTO boxNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","O Poole là a Baanabaasi buera le bín-tente ho Dɛɛbe yi, á ɓa nùpua cɛ̀rɛ̀ɛ tà wó ɓa nì-kenínia. Bṹn mɔ́n, á ɓa yèrèmáa van ho Lisitere lè ho Ikoniyuumu yi, lè ho Ãntiosi na wi ho Pizidii kɔ̃hṹ yi. ");
INSERT INTO boxNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɓa wee hení bìa tà a *Krista bìo sĩa, á wee hení mu na ɓa yi le ɓa fárá dĩ̀n, à dé mí sĩa o Krista yi. Ɓa wee bío bìo kà na ɓa yi: «Wa ko wa kã́a lònbee cɛ̀rɛ̀ɛ yi à bè yi zoráa le *Dónbeenì bɛ́ɛnì yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ɓa hueekaa ɓa nùpua ɓúi ɓa kèrètĩ́ɛwa kuio lè mí dà-kéní kéní yi á wó lè ɓa ya-díwá. Bṹn mɔ́n á ɓa lù mí ɲiní à ɓa fìora, á dó ɓa bìo o Ɲúhṹso na ɓa tà nɔn míten yi níi yi. ");
INSERT INTO boxNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bṹn mɔ́n á ɓa kã́a ho Pizidii kɔ̃hṹ yi á vaá dɔ̃n ho Pãnfilii kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓa buera le Dónbeenì bíonì ho Pɛɛze lóhó yi à ɓa wà ɲɔn ho Atalii lóhó. ");
INSERT INTO boxNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lé bĩ́n á ɓa dĩ̀n yi láráa ho won-beenì á van ho Ãntiosi. Lé hón lóhó so yi á ɓa hĩ́a dó ɓa bìo le Dónbeenì sãamu ɓànso níi yi, à le séení ɓa ho tonló na ɓa vaá sá á ho ɲii sú bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bìo ɓa vaá dɔ̃n ho Ãntiosi, á ɓa von ɓa kèrètĩ́ɛwa kúaa mín wán, á lá bìo ɓúenɓúen na le Dónbeenì làa ba páanía wó á fɛɛra nɔn ɓa yi, làa bìo á le mún hɛ́raráa ho wɔ̃hṹ á nɔn bìa yínɔń ɓa zúifùwa yi, à bán mún dàń tà a Krista bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Á ɓa kará dá míana bĩ́n làa bìa tà a Yeesu bìo lè ɓa nì-kenínia. ");
INSERT INTO boxNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nùpua nùwã yɛn ɓúi ló ho *Zudee yi á ɓuara ho Ãntiosi yi, á ɓueé wee kàrán bìa tà a *Krista bìo làa bìo kà: «Mi yí dà máa fen ká mi yí kúiora làa bìo mu bòráa o *Mɔyiize làndá yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ó o Poole là a Baanabaasi pã́ ɓa bìo, á wã̀anía làa ba lè mí sòobɛ́ɛ mu bìo yi. Mu véeníi, á ɓa le o Poole là a Baanabaasi, lè ho Ãntiosi nùpua nùwã yɛn ɓúi ko ɓa va ho Zeruzalɛɛmu, à vaa fɛɛ ho tũ̀iá mu na a Krista tonkarowà lè ɓa kèrètĩ́ɛwa ya-díwá yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Á ɓa kèrètĩ́ɛwa kuure nɔn bìo ɓa màkóo wi yi le vɛɛnì mu bìo yi ɓa yi. Ɓa kã́a ho Fenisii lè ho *Samarii kãna yi ká ɓa à bío bìo á bìa yínɔń ɓa *zúifùwa wó wó yèrèmáa tàráa le Dónbeenì bìo lè mí dà-kéní kéní. Á mu wó sĩ-wɛ-beenì bìa ɓúenɓúen na tà a Krista bìo cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɓa vaá dɛ̃ɛníi ho Zeruzalɛɛmu yi á ɓa wà van ɓa kèrètĩ́ɛwa cɔ̃́n á bán lè ɓa tonkarowà, lè ɓa ya-díwá, á bɛ̀ɛ́nía ɓa yi. Á ɓarɛ́n ɓɛ̀n lá bìo ɓúenɓúen na ɓa wó lè le Dónbeenì pànká á fɛɛra nɔn ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ká ɓa *Farizĩɛwa kuure nùpua nùwã yɛn ɓúi na tà a *Krista bìo á hĩ́nɔn bía: «Bìa yínɔń ɓa zúifùwa na tà a Krista bìo ko ɓa *kúio. Ò o Mɔyiize làndá bèró bìo mún hení na ɓa yi.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Á ɓa tonkarowà lè ɓa ya-díwá kúaa mín wán, à lońnáa le bíonì mu yahó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɓa kára mín míana. Bṹn mɔ́n ó o Piɛre lií hĩ́nɔn lá le bíonì ò o bía nɔn ɓa yi: «Wàn zàwa, mi zũ le le Dónbeenì mɔn mi léra mi tĩ́ahṹ mu míana à ĩ bue le bín-tente à na bìa yínɔń ɓa zúifùwa yi, bèra a na à ɓa ɲí le, à tà le bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Le Dónbeenì zũ bìo wi ɓa nùpua sĩa yi. Le nɔn mí Hácírí ɓa yi làa bìo warɛ́n yúráa le bìo síi, à zéení le le tà ɓa bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Le yí wó bìo woon na wee zéení le warɛ́n làa ba wi mín ɲúná yi. Le ceéra ɓa sĩa, lé bìo ɓa tà le bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Á lée webio nɔn á mi wã́a wi à mi sèení ɓa lè ho sèró na á wàn ɓùaawa lè warɛ́n wa bɛɛre á yí dàńna yí sò, á à khũaanáa le Dónbeenì ɲii yi? ");
INSERT INTO boxNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɓùeé dɛ́. Bìo warɛ́n kã̀nía o Ɲúhṹso Yeesu sãamu bìo yi, lé bṹn ɓarɛ́n bìo mún wóráa.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Á bìa wi bĩ́n ɓúenɓúen wó tɛ́tɛ́. Bṹn mɔ́n á ɓa wee ɲí á Baanabaasi là a Poole cɔ̃́n. Ɓa wee bío mu yéréké bìowa na wee zéení le Dónbeenì pànká na le wó lè ɓa níní bìa yínɔń ɓa zúifùwa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bìo á ɓa bía vó, ó o Zaaki hĩ́nɔn lá le bíonì ò o bía: «Wàn zàwa, mi ɲí bìo á ĩ ì bío. ");
INSERT INTO boxNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bìo le Dónbeenì tà lora bìa yínɔń ɓa zúifùwa bìo hàrí mu ɲúhṹ ɓúɛɛníi, á léraráa mu nìpomu na bìo sã̀ le yi ɓa tĩ́ahṹ, ó o Simɔn zéenía. ");
INSERT INTO boxNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","«Mu fò mín lè le *Dónbeenì ɲi-cúa fɛɛrowà bíoní, lé bìo mu túara le Dónbeenì bíonì vũahṹ yi kà síi: ");
INSERT INTO boxNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","O Ɲúhṹso bía: «Bṹn mɔ́ndɛ́n á ĩ ì bĩní ì ɓuen á ɓueé so a *Daviide zĩi na lá tò. Le soni na fù á ĩ ì bĩní ì hóoní, á le è fárá á à dĩ̀n. ");
INSERT INTO boxNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Hón pã̀ahṹ so yi á ɓa nùpua na ká ɓúenɓúen, lè hã kãna ɓúenɓúen na á ĩ von à hã bìo sĩ̀ miì á à cà a Ɲúhṹso. «Hĩ̀a kà lé o Ɲúhṹso ɲi-cúa, yìa nɔn á mu bìowa mu ");
INSERT INTO boxNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","bìo zũńnanáa hàánì.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","O Zaaki pá bĩnía bía: «Lé bṹn nɔn á ĩ le mu sṹaaní à bìa yínɔń ɓa zúifùwa na yèrèmáa bò le Dónbeenì yi à ɓa yí sɛɛ́. ");
INSERT INTO boxNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ká mi màhã́ wa túa ɓa yi, à bío na ɓa yi le ɓa wé yí là le muinì taa, lé bìo hã tun. À pa míten ho hã́-fénló lè ho bá-fénló lè mí sìíwà yi. À yí là bùaa na yí fũ̀aana taa. À yí dí cãni. ");
INSERT INTO boxNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Hàánì bĩ́n ká ɓa nùpua wee kàrán o Mɔyiize làndá làa mín hã lórá lè mí dà-kéní kéní yi, à kàrán ho ɓa zúifùwa kàránló zĩní yi hã *Sabaawa ɓúenɓúen zoǹ.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Á ɓa tonkarowà, lè ɓa ya-díwá, lè ɓa kèrètĩ́ɛwa kuure wã̀anía tò le mí ì hueeka ɓa ɓúi mí tĩ́ahṹ á à dé o Poole là a Baanabaasi wán, á à tonka ho Ãntiosi yi. Á ɓa hueekaa o Silaasi là a Zude na ɓa wee ve làa Baasabaasi. Ɓa mí nùwã ɲun á bìa tà a *Krista bìo wee kɔ̃̀nbi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bìo kà lé bìo túara ho vũahṹ na ɓa a ɓua á à varáa yi: «Warɛ́n tonkarowà lè ɓa kèrètĩ́ɛwa ya-díwá wee tɛ̀ɛní minɛ́n na lé wàn zàwa na yínɔń ɓa *zúifùwa yi, bìa ho Ãntiosi lóhó yi lè ho Siirii lè ho Silisii kãna yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wa ɲá à ɓa nùpua ɓúi ló wa cɔ̃́n, ká warɛ́n ɲɔǹ yí tonkaa ɓa, á ɓueé lùnkaa mi yilera lè mí bíoní, á mi yí zũ bìo mi ì wé. ");
INSERT INTO boxNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lé bṹn nɔn á wa wã̀anía tò à wa le wa à hueeka ɓa ɓúi á à tonka mi cɔ̃́n. Ɓa à bè là a Baanabaasi là a Poole na lé wàn bɔ̃́nlowà na wa wa làa sòobɛ́ɛ, ");
INSERT INTO boxNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bán na zàanía mí mukãní wa Ɲúhṹso Yeesu *Krista tonló bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ó o Zude là a Silaasi lé bìa wa wã́a tonkaa mi cɔ̃́n, à bán míten ɓuee wíoka fɛɛ bìo túara ho vũahṹ yi à na mia. ");
INSERT INTO boxNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Warɛ́n á tò mu wán á le Dónbeenì Hácírí mún tà mu le wa máa ɲì sèró mi wán máa dà máa khĩí. Hã làndáwá na bìo henía nɔn mia na mi ko mi bè yi lé hĩ̀a kà: ");
INSERT INTO boxNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mi wé yí là le muinì taa. Mi yí dí cãni. Mi yí là bùaa na yí fũ̀aana taa. Mi pa miten ho hã́-fénló lè ho bá-fénló lè mí sìíwà yi. Ká mi wee dàń pa miten bìo bṹn ɓúenɓúen yi, se mu se. Ká mi foó.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bṹn mɔ́n á ɓa nɔn ho wɔ̃hṹ bìa ɓa le mí ì tonka yi á ɓa wà van ho Ãntiosi. Bìo ɓa vaá dɔ̃n bĩ́n, á ɓa von bìa ɓúenɓúen na tà a Krista bìo á kúaa mín wán, à ɓa nɔn ho vũahṹ mu ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bìo ɓa kàránna ho, á ɓa ɓúenɓúen zã̀makaa ho ɓàn bíoní na henía ɓa sĩa bìo yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Bìo ó o Zude là a Silaasi hĩ́a lé ɓa ɲi-cúa fɛɛrowà ɓúi, á ɓa kará bĩ́n míana lè mín zàwa kèrètĩ́ɛwa, á henía ɓa sĩa, à ɓa wíoka yí ho pànká. ");
INSERT INTO boxNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɓa dá dóka mí yi ho Ãntiosi yi. Bṹn mɔ́n á ɓa dó ɓa cãawése, á bán le ɓa bè wã-tente, à ɓa día ɓa á ɓa yèrèmáa van bìa tonkaa ɓa cɔ̃́n, ");
INSERT INTO boxNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ò o Poole là a Baanabaasi kará ho Ãntiosi yi. Á ɓarɛ́n làa bìa tà a Krista bìo cɛ̀rɛ̀ɛ ɓúi wee kàrán ɓa nùpua, á wee bue o Ɲúhṹso bíonì. ");
INSERT INTO boxNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wizooní bìo yɛn bṹn mɔ́n, ó o Poole bía nɔn o Baanabaasi yi: «Wa bĩní tè hã lórá ɓúenɓúen na wa buera le Dónbeenì bíonì yi, à ɓúɛɛkí wàn zàwa kèrètĩ́ɛwa à loń le ɓa bìo wó kaka.» ");
INSERT INTO boxNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","O Baanabaasi lá wi ò o fé o Zãn na ɓa le Maaki à bèráa. ");
INSERT INTO boxNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ká a Poole màhã́ yí tà a féró, lé bìo ó o bĩnía ɓa mɔ́n ho Pãnfilii kɔ̃hṹ yi, á yí bĩnía yí sá tonló làa ba. ");
INSERT INTO boxNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wã̀aníi na here kɛra ɓa pã̀ahṹ mu bìo yi, fúaa ɓa saawaa. Ó o Baanabaasi fó a Maaki á ɓa lá ho won-beenì à ɓa ɲɔn ho Siipere kɔ̃hṹ. ");
INSERT INTO boxNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ò o Poole wón ɓɛ̀n léra a Silaasi. Sã́ni ò o lɛ́n, á ɓàn zàwa kèrètĩ́ɛwa kàràfáa wo o Ɲúhṹso yi. ");
INSERT INTO boxNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O kã́a ho Siirii lè ho Silisii kãna yi, á wee séení ɓa kèrètĩ́ɛwa kuio à ɓa sĩadéró o Krista wíoka fárá tĩn. ");
INSERT INTO boxNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bṹn mɔ́n ó o Poole wà van ho Dɛɛbe lóhó, á dĩ̀n bĩ́n vannáa ho Lisitere lóhó. Nìi ɓúi na ɓa le Timɔtee na tà a *Krista bìo á wi ho lóhó mu yi. O lé o zúifù hĩ́nzoró na lé o kèrètĩ́ɛ hã́a á te mí za. Ká ɓàn maá lé o *Kɛrɛɛki nìi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ɓa kèrètĩ́ɛwa na wi ho Lisitere lè ho Ikoniyuumu lórá yi á wee wíoka a yèni. ");
INSERT INTO boxNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","O Poole lá wi ò o fé o à ɓa wé páaní bè mín. Ó o le ɓa kúii wo ɓa *zúifùwa na wi bĩ́n bìo yi, lé bìo ɓa ɓúenɓúen zũ mu le ɓàn maá lé o Kɛrɛɛki nìi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hã lórá ɓúenɓúen na ɓa wee kã́a yi, á ɓa wee bío bìo ɓa tonkarowà lè ɓa kèrètĩ́ɛwa ya-díwá wã̀anía tò wán ho Zeruzalɛɛmu yi à na bìa tà a Krista bìo yi, ká ɓa à bío na ɓa yi le ɓa wé bè mu yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ɓa kèrètĩ́ɛwa kuio wíokaa fárá dĩ̀n, á sĩadéró o Krista yi wi, á bìa tà a Krista mu bìo wee dé wán làa wizooní. ");
INSERT INTO boxNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Le Dónbeenì Hácírí hò ɓa le ɓa yí vaá bue le Dónbeenì bíonì ho Azii kɔ̃hṹ yi. Á ɓa kã́a ho Firizii lè ho Kalasii kãna yi á wà. ");
INSERT INTO boxNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bìo ɓa vaá dɔ̃n ho Mizii kɔ̃hṹ ɲii á ɓa le mí ì va ho Bitinii kɔ̃hṹ yi á à loń. Ká a Yeesu Hácírí màhã́ yí nɔn mu wɔ̃hṹ ɓa yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Á ɓa wã́a kã́a ho Mizii kɔ̃hṹ yi á lion ho Torowaasi lóhó wonna dĩ̀nníi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ho tĩ́nàahṹ á bìo ɓúi zéenía míten là a Poole. O mɔn ho Maseduana kɔ̃hṹ nùpue ɓúi ò o muina dĩ̀n á wee fìo wo kà síi: «Ɓuen ho Maseduana yi à ɓuee séení wɛn.» ");
INSERT INTO boxNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mí lahó yi á wa dɛ̀ɛnía wee cà bìo wa à wé wé á à varáa ho Maseduana, lé bìo wa wã́a zũ le lé bĩ́n á le Dónbeenì von wɛn le wa vaa bue mí bín-tente à na ho kɔ̃hṹ mu nùpua yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wa zon ho won-beenì ho Torowaasi yi á térénna van ho Samɔtaraasi kɔ̃hṹ na mu ɲumu kĩ́nía yi. Mu ɓàn tá na lée tɔ̃n, á wa van ho Niapoliisi lóhó. ");
INSERT INTO boxNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Lé bĩ́n á wa dĩ̀n yi vannáa ho Maseduana kɔ̃hṹ sɔ̃́n-kéní na bìo sã̀ ho Oroomu yi ɓàn ló-beenì na ɓa le Filiipu. Ho Oroomusa cɛ̀rɛ̀ɛ hĩ́a kará ho lóhó mu yi. Hón lóhó so á wa wó wizooní bìo yɛn yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ho *Sabaa zoǹ, á wa hĩ́nɔn ló ho donkĩ́ahṹ á wà lion ho vũhṹ ɲii, le ɲún-sĩ á wa lií yí ɓa *zúifùwa fìoró lahó bĩ́n. Wa lií yú ɓa hã́awa ɓúi à ɓa kúaa mín wán, á wa kará tà hã láakáwá làa ba. ");
INSERT INTO boxNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ɓa hã́awa mu nì-kéní ɓa le Lidi. O wee lé ho Tiatiire lóhó yi, á wee duan lè hã pɔ̃nsò-muna na yàwá here. O wee kɔ̃̀nbi le Dónbeenì. O kará wee tántá mí ɲikɔ̃nna wa bíoní yi, ó o Ɲúhṹso wó ó o wíokaa wee ɲí bìo ó o Poole wee bío sese. ");
INSERT INTO boxNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Orɛ́n lè mí zĩi nùpua á ɓa bátízéra. Bṹn mɔ́n ó o bía bìo kà á vonnáa wɛn: «Ká mi wee leéka le ĩ tà a Ɲúhṹso yi bìo bon, à mi ɓuee làa ĩ zĩi.» Ò o dĩ̀n lan wɛn fúuu á wa tà van. ");
INSERT INTO boxNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wizonle ɓúi, ká wà wee va ho fìoró lahó yi, á ton-sá hã́a ɓúi na lé o tĩahã́nìi ɓueé sã́ wa yahó. O wee yí wárí cɛ̀rɛ̀ɛ ho tĩnló mu bìo yi à na mí ɲúnása yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O bò warɛ́n là a Poole mɔ́n, á wee bío pɔ̃́npɔ̃́n kà síi: «Ɓa nùpua na kà lé le Dónbeenì na dà mu bìo ɓúenɓúen wán ton-sáwá. Ho wɔ̃hṹ na wee kã̀ní ɓa nùpua lé hón bìo ɓa wee bue à na mia.» ");
INSERT INTO boxNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wizooní cɛ̀rɛ̀ɛ yi ká lé bṹn ó o hã́a mu wee wé. Fúaa o Poole sĩi cã̀ cã̀, á yèrèmáa bía nɔn o cĩ́ná na ó o wee sáráa yi: «Le ĩ bío mu na foǹ: O Yeesu yèni pànká yi, à ũ lɛ́n día a hã́a mu lònbìo.» Mí lahó yi ó o cĩ́ná dɛ̀ɛnía wà día a hã́a. ");
INSERT INTO boxNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bìo ó o hã́a mu ɲúnása mɔn à bìo ó o lá wee yí na ɓa yi á ɲúhṹ wã́a ɓó, á ɓa wìira a Poole là a Silaasi vannáa ho pànká ɓànsowà cɔ̃́n ɓa zã̀amáa fèmínló lahó yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ɓa ɓuan ɓa vannáa bán na lé ho *Oroomusa tũ̀iá fɛɛrowà cɔ̃́n, à ɓa bía: «Ɓa nùpua na kà dĩ̀n wee kánká wa lóhó. Ɓarɛ́n lé ɓa *zúifùwa, ");
INSERT INTO boxNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","à warɛ́n na lé ho Oroomusa á ɓa màhã́ wee kàrán lè mu bè-wénia ɓúi na wa làndá le wa yí wé.» ");
INSERT INTO boxNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Á ɓa zã̀amáa mún sĩa cã̀ a Poole là a Silaasi yi. Á ɓa tũ̀iá fɛɛrowà le ɓa tɛn ɓa sĩ̀a, à ɓa le ɓa ha ɓa lè hã fĩ́nfoóní. ");
INSERT INTO boxNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bìo ɓa han ɓa vó, á ɓa kúaa ɓa ho kàsó yi, à ɓa henía mu nɔn o paro yi le o pa ɓa yi sese. ");
INSERT INTO boxNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bìo ó o paro ɲá bṹn kà síi, ó o ɓuan ɓa zoó kúaa ho kàsó zĩi fĩ̀kɔ̃hṹ, á kúaa hã súrúkùwa ɓa zení yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bìo ho tá wà vaá sanka à màní, ó o Poole là a Silaasi wee fìo ká ɓa à khòoní le Dónbeenì. Á ɓa kàsósa na ká wee ɲí ɓa cɔ̃́n. ");
INSERT INTO boxNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yìo ɓueé tĩ à ho tá zà lè mí sòobɛ́ɛ, á dèkío ho kàsó zĩi. Hã wonna ɓúenɓúen dɛ̀ɛnía hɛ́nkaa, á ɓa kàsósa ɓúenɓúen zúakùaríwà feera. ");
INSERT INTO boxNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ó o paro sĩ̀na. Bìo ó o mɔn à ho kàsó zĩi zũaɲiní hɛ́nkaa, ó o wee leéka le ɓa kàsósa ɓúenɓúen lùwa, ó o dò mí khà-tóní le mí ì ɓúe lè míten. ");
INSERT INTO boxNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ó o Poole wãamaa pɔ̃́npɔ̃́n o wán: «Yí yáa ũten. Wa ɓúenɓúen wi hen.» ");
INSERT INTO boxNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ó o paro le ɓa ɓuen lè mu khoomu. Á ɓa ɓuan mu ɓuararáa ó o fó ò o bánbáa vaá zon le zĩ-za yi ká a wee zà lé le zã́níi, á zoó ɓúrá a Poole là a Silaasi tá. ");
INSERT INTO boxNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bṹn mɔ́n ó o fó ɓa lóráa ò o tùara ɓa yi: «Minɛ́n nùpua mu, lé mu yɛ́n á ĩ ko à ĩ wé à fennáa?» ");
INSERT INTO boxNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Á bán bía nɔn wo yi: «Tà a Ɲúhṹso Yeesu bìo, á ũnɛ́n lè ũ zĩi nùpua á à fen.» ");
INSERT INTO boxNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","À ɓa bía a Ɲúhṹso bìo nɔn orɛ́n là a zĩi nùpua ɓúenɓúen yi. ");
INSERT INTO boxNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ho tĩ́nàahṹ mu yi, ho pã̀ahṹ dà-kéní kéní mu yi, ó o nìi fó ɓa vaá sɛɛra dokuaa. Ó orɛ́n lè mí zĩi nùpua ɓúenɓúen á ɓa dɛ̀ɛnía bátízéra. ");
INSERT INTO boxNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bṹn mɔ́n ó o fó a Poole là a Silaasi yòoraráa mí zĩi, á yòó nɔn mu bè-dínii ɓa yi. O nìi mu lè mí zĩi nùpua ɓúenɓúen sĩa wan, lé bìo ɓa tà le Dónbeenì bìo. ");
INSERT INTO boxNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bìo ho tá tɔ̃n, á ho Oroomu tũ̀iá fɛɛrowà tonkaa ɓa nùpua le ɓa vaa bío le yìa wee pa ho kàsó zĩi yi à kúia ɓa nùpua mu le ɓa lɛ́n. ");
INSERT INTO b