﻿USE sofia;
DROP TABLE IF EXISTS sofia.bov_vpl;
CREATE TABLE bov_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bov_vpl WRITE;
INSERT INTO bov_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ade Yesu Kristo kĩ ɛnyɛ Dawid ɔwa, kĩ Dawid lɛmɛ nyɛ Abraham ɔwa a bawanyɔ kasinu buĩ nɛ awĩ a. ");
INSERT INTO bov_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Kito Abraham akũ kɛyawo Lɛgã Dawid akũ bawanyɔ a kama kamɛ nyɛ Abraham ma Isak, Isak ma Yakob, ");
INSERT INTO bov_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ade Yakob ma Yuda mɔ bawaɛ̃nyole a. Yuda mɔ ɔtsɔ̃ Tamai ma Perez mɔ Zera. Perez ma Hezron, Hezron lɛmɛ ma Aram. ");
INSERT INTO bov_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ma Aminadab, Aminadab ma Naheson, ");
INSERT INTO bov_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ade Naheson ma Salmon a. Salmon mɔ Rahab ma Boaz, ade Boaz mɔ Rut ma Obed a. Obed ma Isai, ");
INSERT INTO bov_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ade Isai lɛmɛ ma Lɛgã Dawid a. Kito Dawid akũ kɛnawo lɔkɔ a kĩ bipili Israelfɔ ndom bɛnamɛna Babilonia tite akũ a ni, ade bawanyɔ a kasinu buĩ nɛ awĩ a. Dawid mɔ otsole a kĩ kufɛ ɛnyɛ Uria ɔtsɔ̃ a ma Salomo. ");
INSERT INTO bov_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo ma Rehoboam, Rehoboam ma Abiya, Abyia ma Asa. ");
INSERT INTO bov_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ma Yosafat, Yosafat ma Yoram, Yoram ma Uziya. ");
INSERT INTO bov_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya ma Yotan, Yotan ma Ahaz, Ahaz lɛmɛ ma Hezekiya. ");
INSERT INTO bov_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya ma Manase, Manase ma Amon, Amon ma Yosiya, ");
INSERT INTO bov_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ade Yosiya ma Yekoniya mɔ ye bawaɛ̃nyole a. ");
INSERT INTO bov_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kito Israelfɔ kamuniki kato Babilonia kɛyawo Yesu kama lɔkɔ a, bawanyɔ a kasinu buĩ nyɛ Yekoniya ma Sealtiel, Sealtiel ma Zerubabel, ");
INSERT INTO bov_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel lɛmɛ ma Abihud. Abihud ma Elyakim, Elyakim ma Azur, ");
INSERT INTO bov_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ade Azur ma Zadok, Zadok ma Akim, Akim lɛmɛ ma Elihud. ");
INSERT INTO bov_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud ma Eleazar, Eleazar ma Matan, ade Matan ma Yakob. ");
INSERT INTO bov_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob ma Yosef a kĩ ɛkɔã Maria a, kĩ ɛma Yesu a kĩ bavɛ Kristo a. ");
INSERT INTO bov_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Foesũ kito Abraham akũ kɛyawo Dawid akũ ni, bawanyɔ ewua-ana lɛna nɛ kasinu a kamɛ. Ade kĩ kito Dawid akũ kɛnawo lɔkɔ a kĩ Babiloniafɔ pili Israelfɔ ndom bɛnamɛna be tite akũ a, bawanyɔ ewua-ana lɛna nɛ kasinu a kamɛ. Kĩ kito lɔkɔ a na kɛyawo Kristo kama ni, bawanyɔ ewua-ana lɛna nɛ kasinu a na lɛmɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ade ayekĩ Yesu Kristo kama fɔlɛtsa a ya nɛ foe kamɛ a nɛ awĩ a. Bitinya ɔma Maria bɛkpa Yosef, lɛmɛ fɔmɔ baapi ye a, Maria mɔ́ eyi ɔsũ kĩ ɛtsɛ̃mɔ kɔma kĩ kuto Hũhũ Kpalɛwa a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ayekĩ Yosef nyɛ oti kpĩĩ nɛ Baguma anɛ, ade ɛtáwɛ kĩ yado Maria kɔnyɔã nɛ bati anɛ sũ ni, ɛwɛ kĩ yasĩ ye nɛ kabɛla kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kĩ ɛkakɔna fukĩĩ akũ a, boe Ɔlate a ode fɔtɔ ɔnyanɛ odi nyɛ ye akũ ɛtsa ye nɛ kɔda kamɛ, ebi ye kĩ, “Yosef, Dawid obi, tavila Maria kakɔã, kitonɛkĩ Hũhũ Kpalɛwa a kamɛ kɔma a to. ");
INSERT INTO bov_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yaama obinyole, ote ye dĩ kĩ Yesu, kitonɛkĩ ye aanyɛ ye bati etomɛna tɔkpa kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fɔlɛtsa kĩĩ flee ya nɛ foe kamɛ, ayekĩ lɛtsa a kĩ Baguma lɛ eyi ɛtsãmɛna ye onukpɛ̃ ɔnyɛnɛ akũ a fɔya nɛ foe kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Oyitsɔ̃ kĩ enyína onyole aatsãmɔ kɔma, ɛma obinyole. Baavɛ ye Imanuel,” kĩ de kayɔ nyɛ, “Baguma deĩ mɔ boe.” ");
INSERT INTO bov_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Foesũ kĩ Yosef nyinya a, ɛkɔã Maria ndɛ ayekĩ Baguma ode fɔtɔ ɔnyanɛ bi ye a. ");
INSERT INTO bov_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lɛmɛ Yosef mɔ Maria táta mɔ akũ ndɛ ɔtsɔ̃ mɔ ɔnyɔ aye, kɛnawo lɔkɔ a kĩ ɛma ye obinyole a. Ade Yosef te ye dĩ kĩ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bɛma Yesu nɛ Betlehem nɛ lɔkɔ a kĩ Herodes kanya lɛgã nɛ Yudea tite akũ a. Owi tábuna mɔ banyole badi kĩ bɛkɔlɛ fɔtsa nɛ fusibii kadã akũ to suwa kadekɔ̃ bɛya nɛ Yerusalem, ");
INSERT INTO bov_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ade bɛyavia kĩ, “Ndia bɛma obisɛ̃ a kĩ yaanya Yudafɔ lɛgã a? Bɔmɔ́ ye lisibii kĩ lide nɛ suwa kadekɔ̃, ade bɔya kĩ bɔ́asum ye a.” ");
INSERT INTO bov_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kĩ Lɛgã Herodes nu fukĩĩ a, ɔwɔlɛ bɔlɛ ye mɔ odi nyɛ odi nɛ Yerusalem a. ");
INSERT INTO bov_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Foesũ ɛvɛ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a flee ɛkpɔta evia be kĩ, “Nɛ ndia baama Kristo a?” ");
INSERT INTO bov_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɛkpa mbuayɛ kĩ, “Nɛ Betlehem nɛ Yudea tite akũ, kitonɛkĩ ade lɛtsa kĩ Baguma onukpɛ̃ ɔnyɛnɛ tsɛlɛ eyi kĩ, ");
INSERT INTO bov_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nɔ Betlehem nɛ Yuda tite akũ, nnɛ́ ɔmatɔ kabii kɔlaa anɛ nɛ Yuda tɛmatɔ tɛkpale tɛkpale a kamɛ. Kitonɛkĩ nɔ kamɛ mɔ ɔkpãnɛ a kĩ, yaakpã yĩ bati Israelfɔ a aanɛ eto.’ ” ");
INSERT INTO bov_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Foesũ Herodes vɛ anyansãfɔ a kĩ bito suwa kadekɔ̃ a ɛnamɛna kabɛlakɔ̃, ade evia be lɔkɔ paa a kĩ lisibii a nɛ a. ");
INSERT INTO bov_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ke liti a, ɛnyɛ be osi kĩ bɛnaa Betlehem mɔ ɔlɛdo kĩ, “Minaawɛ obisɛ̃ a kawɛ wĩ. Ntɛ mimɔ́ ye ni, mifɔ̃ ĩnyi lɔkɔa yĩ malo nnaasum ye.” ");
INSERT INTO bov_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Foesũ bɛdzakũ, ade kĩ banaa nɛ osi a, bɛmɔ́ lisibii mɔapɛ a kĩ bɛmɔ́ nɛ suwa kadekɔ̃ a. Kĩ bɛmɔ́ de lɔmɔ a, kawɔlɛ de be paa. Lɛnya be lɔtɔ tĩĩ lɛnafɔ̃ lɛdza nɛ kakɔ a kĩ obisɛ̃ a deĩ a lɔlɔ nyangɛ. ");
INSERT INTO bov_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kĩ biwo nɛ kɔla a kamɛ a, bɛmɔ́ obisɛ̃ a mɔ ɔma Maria, ade bike aduli bisum ye a. Bibinya be futetsa a kĩ fɔnyɛ sika ngbã, lifii mɔ klubɔũ bɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Baguma nyɛ ɛtsa be nɛ kɔda kamɛ kĩ bɛtabuki bɛnaa Herodes sɛkɛ̃, foesũ bimuniki bɛtsã osi bɛbã bɛdzakũ bɛnaa ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kĩ anyansãfɔ a dzakũ a, ode fɔtɔ ɔnyanɛ odi nyɛ ye akũ ɛtsa Yosef nɛ kɔda kamɛ ebi ye kĩ, “Herodes aatsã ɛwɛ obisɛ̃ a kĩ yakɔ ye, foesũ yidza kakpã obisɛ̃ a mɔ ɔma milo minaa Egipte tite akũ. Mina nɛ awã kɛnaawo lɔkɔ a kĩ maabi nɔ kĩ mimuniki miya.” ");
INSERT INTO bov_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lɛnyɛ lɛnyɛ a na, Yosef yidza ɛkpã obisɛ̃ a mɔ ɔma bilo bɛnaa Egipte tite akũ. ");
INSERT INTO bov_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Edzi nɛ awã kɛnawo kĩ Herodes ku. Fukĩĩ ya lɔmɔ ayekĩ lɛtsa a kĩ Baguma onukpɛ̃ ɔnyɛnɛ lɛ eyi a fɔya nɛ foe kamɛ kĩ, “Nvɛ yĩ obi ntomɛna Egipte tite akũ.” ");
INSERT INTO bov_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kĩ Herodes mɔ́ eyi ɔsũ kĩ anyansãfɔ a kĩ bito suwa kadekɔ̃ a bu ye tɛkɔasia a ni, ɛna kalɔkpa paa. Foesũ edo bati kĩ bɛnaakɔ kubisɛ̃ɛ̃nyole a kĩ kɔtɛ futeli nviã kɛka, kɛyawo akɔkɔa amɛ akũ a flee nɛ Betlehem, mɔ ye tɛmatɔ kĩ tifuã a flee kamɛ. Herodes vɛ futeli nviã kĩ fuketimɔ lɔkɔ a kĩ bibi ye kĩ lisibii a nɛ a. ");
INSERT INTO bov_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Adeke fɔlɛtsa a kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yeremia lɛ eyi a ya nɛ foe kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Fɔwɔla nɛ́ nɛ Rama, kabe mɔ ayɔlɔhɔ fɔwɔla fɔanɛ. Rahel kabe ye babi, ade yaátunɔ kĩ bɛdɔla ye ɔwɔlɛ a, kitonɛkĩ ye babi ku.” ");
INSERT INTO bov_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kĩ Herodes ku a, ode fɔtɔ ɔnyanɛ odi nyɛ ye akũ ɛtsa Yosef nɛ kɔda kamɛ nɛ Egipte, ");
INSERT INTO bov_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ade ebi ye kĩ, “Yidza, kakpã obisɛ̃ a mɔ ɔma mimuniki minaa Israelfɔ tite akũ, kitonɛkĩ bikĩ bɛwɛ kĩ bakɔ obisɛ̃ a ku.” ");
INSERT INTO bov_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Foesũ Yosef kpã obisɛ̃ a mɔ ɔma bimuniki bɛya nɛ Israel tite akũ. ");
INSERT INTO bov_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lɛmɛ kĩ Yosef nu kĩ bidzina Arkelao lɛgã nɛ ɔlɛga Herodes kadzakɔ̃ nɛ Yudea a, evila awã kanaa. Baguma buki ɛnyɛ foe ɛtsa ye nɛ kɔda kamɛ kĩ ɛtanaa awã, foesũ ɛdzakũ ɛnaa Galilea amantam kamɛ, ");
INSERT INTO bov_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ade ɛnadzi nɛ ɔmatɔ a kĩ bavɛ Nazaret a kamɛ a. Foesũ fɔlɛtsa a kĩ Baguma onukpɛ̃ banyɛnɛ a lɛ biyi a ya nɛ foe kamɛ kĩ, “Baavɛ ye kĩ Nazaretni.” ");
INSERT INTO bov_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nɛ fuwi a na kamɛ a, Yohanes Mui Ɔwɔlanɛ a ya nɛ Yudea kɔsa a kamɛ, ade eyi lɛtsã kade kayɔ nɛ Baguma fɔlɛtsa a akũ a. ");
INSERT INTO bov_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ɛlɛ kĩ, “Midani mi tɔwɔlɛ kamɛ, kitonɛkĩ Baguma lɛgãkanyakɔ̃ a fuã!” ");
INSERT INTO bov_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes nyɛ́ oti a kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ kɔdzɛla nɛ ye akũ eyi kĩ, “Odi lamɛna fɔwɔla kabɔa nɛ kɔsa kamɛ kĩ, ‘Milɔla boe Ɔlate a osi. Mifɔ̃ ye akũ eyo kpĩĩ!’ ” ");
INSERT INTO bov_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes do tɛtadiɛ kĩ bɛkɔa ɔpɔnkɔpoku tɛtsã bɛnɔ, ade ɛkɔa ɔyaɛ ovoli abɔsɔ eboomu kate a. Ye funitsã nyɛ koolo mɔ kɔsã. ");
INSERT INTO bov_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bati kato Yerusalem, Yudea tite flee mɔ tite a kĩ tifuã Yordan ɔwɔ a flee akũ kaya nɛ ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɛnyɛ be tɔkpa bɛtsa ade Yohanes wɔla be mui nɛ Yordan ɔwɔ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kĩ Yohanes mɔ́ Farisifɔ mɔ Zadukifɔ beblebee kĩ baya nɛ ye sɛkɛ̃ kĩ ɛwɔla be mui a, ebi be kĩ, “Mi bati kĩ mila ndɛ bɔɛ kpa! Owei lɛkpa mi kɔdɛ kĩ milo nɛ sɔtɔ kavɛlɛ a kĩ Baguma aayamɛna a kamɛ? ");
INSERT INTO bov_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mikɛna fɔtsa a kĩ fɔatsa kĩ midani mi tɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mitakɔna kĩ minyɛ Abraham bawa sũ, míapuli milo sɔtɔ kavɛlɛ a. Mabi mi kĩ Baguma aapuli ɛfɔ̃ boe kĩĩ lɛdani babi mɔ bawa ɛkpa Abraham. ");
INSERT INTO bov_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bike kasɔã kɔkɔɛ nɛ futse tɔbɔlɛ akũ kĩ baatsua. Kutse nyɛ kutse kĩ kɔáwũ babi wĩ ni, baakpeli koe bɛta bido nɛ fi luwotu kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Yĩ kɔ̃ ni, nkɔa mui mawɔla mi mui fɔtsa kĩ midani tɔwɔlɛ kamɛ, lɛmɛ oti a kĩ yaaya nɛ yĩ liti a, aakɔa Hũhũ Kpalɛwa mɔ fi ɛwɔla mi mui. Edeĩ kɔbɛ̃ kɔlaa ɛbɛ̃ yĩ, ade ntáfɛta kĩ mawũnya mpabua nɛ ye abɔa malo a. ");
INSERT INTO bov_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɛnɛɛ ye kɔvɛla nɛ awɛ kĩ yaakɔa ɛwɛ ye kamɔnɛ. Yaafila ye kamɔnɛ eko nɛ oli kamɛ, lɛmɛ yaapila afafa a nɛ fi kĩ fɔádĩ da a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nɛ lɔkɔ a na kamɛ a, Yesu to Galilea ɛya nɛ Yohanes sɛkɛ̃ nɛ Yordan ɔwɔ a abuĩ kĩ ɛwɔla ye mui. ");
INSERT INTO bov_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lɛmɛ Yohanes wɛ kĩ Yesu ɛdani adzuni. Ebi Yesu kĩ, “Nɔ a kĩ kɛnɛ kĩ awɔla yĩ mui a ni, nɔ mbom lɛya nɛ yĩ sɛkɛ̃?” ");
INSERT INTO bov_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lɛmɛ Yesu kpa ye mbuayɛ kĩ, “Finyaakɔ̃ fɔ̃ fɔna lɔmɔ, kitonɛkĩ ade osi kĩĩ akũ bɔ́atsã bɔkɛna fɔtsa a kĩ Baguma awɛ a.” Foesũ Yohanes tunɔ nɛ foe akũ. ");
INSERT INTO bov_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kĩ Yohanes wɔla Yesu mui eyua a, ɛnɛ nɛ mui a kamɛ lɛtalɛta, ade ode binya ɛkpa Yesu, ɛmɔ Baguma Hũhũ kĩ yaka ndɛ mblɔduma aye ɛyadzi nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ade odo odi nɛ eto ode ɛlɛ kĩ, “Ade yĩ mɔawɛ Obi kĩ maátunɔ ye kalɛ nɛ awĩ a, yawo yĩ anɛ.” ");
INSERT INTO bov_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ade Hũhũ Kpalɛwa a kpã Yesu ɛnamɛna kɔsa kamɛ kĩ Abonsam ɛsɔ ye ɛdã a. ");
INSERT INTO bov_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kĩ Yesu dzi katanya, lɛnyɛ mɔ suwa fuwi tɛna flee a, kɔlɛ kɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ade Abonsam ya nɛ ye sɛkɛ̃ ebi ye kĩ, “Ntɛ Baguma obi anɛ ni, kekɔ̃ bi boe kĩĩ bɛdani bɛkɛna abodoo.” ");
INSERT INTO bov_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lɛmɛ Yesu kpa mbuayɛ kĩ, “Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Nnɛ́ funitsã odi sũ oti adzi nkpã, mbom edzi nkpã nɛ kalɛ nyɛ kalɛ kĩ kanɛ kato Baguma onukpɛ̃ kamɛ a akũ.’ ” ");
INSERT INTO bov_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ade Abonsam kpã Yesu ɛnamɛna Yerusalem, Ɔmatɔ Kpalɛwa a kamɛ a. Ɛkɔa ye ɛnadzɛla nɛ Asɔli Kɔla ode kakɔ geĩ a, ");
INSERT INTO bov_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ebi Yesu kĩ, “Ntɛ Baguma obi anɛ ni, vɛnya kaka kanaadza nɛ tite, kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Baguma aakpa ye ode fɔtɔ banyanɛ ɔlɛdo nɛ nɔ akũ, kĩ baakaɛ nɔ nɛ be awɛ kamɛ, ayekĩ ɔláatula nɛ de akũ.’ ” ");
INSERT INTO bov_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kpa mbuayɛ kĩ, “Lɛmɛ Katsɛlɛ Kpalɛwa a buki kɛlɛ kĩ, ‘Tasɔ boe Ɔlate nɔ Baguma a ɔdã.’ ” ");
INSERT INTO bov_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ade Abonsam buki ɛkpã Yesu ɛnamɛna ɔtɔ geĩ odi kalete, ade ɛnyɛ katinya kamɛ fɔgã kanyakɔ̃ flee, mɔ foe akũ obu ɛtsa ye a. ");
INSERT INTO bov_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Abonsam bi ye kĩ, “Maakɔa fukĩĩ flee nkpa nɔ, ntɛ aake aduli osum yĩ.” ");
INSERT INTO bov_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu kpa ye mbuayɛ kĩ, “Satana, dzakũ nɛ yĩ akũ! Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Nɔ Ɔlate Baguma odi kɛnɛ kĩ akɛna nɔ akũ ɔkpa lɔkɔa osum ye lɛmɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ade Abonsam dzakũ ɛfɔnɛ Yesu mɔ ode fɔtɔ banyanɛ yabumɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kĩ Yesu nu kĩ bipi Yohanes bido nɛ kɔla a, ɛdzakũ ɛnaa Galilea tite akũ. ");
INSERT INTO bov_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɛtánaadzi nɛ Nazaret ɔmatɔ a kamɛ, mbom ɛnadzi nɛ Kapernaum, ɔmatɔ nɛ Galilea ɔwɔ lutubu baũ a ɔwɛ̃. Awã deĩ nɛ Zebulon mɔ Naftali amantam a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Fɔya lɔmɔ ndɛ ayekĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ eyi a kĩ, ");
INSERT INTO bov_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulon tite mɔ Naftali tite, osi kĩ ɛnaa mpo abuĩ mɔ Yordan ɔwɔ liti Galilea, bikĩ bɛnyɛ́ Yudafɔ tite! ");
INSERT INTO bov_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bati a kĩ bidzi nɛ ɔtũ kamɛ a mɔ́ ɔhaĩ kpale. Ade bikĩ bidzi nɛ tite kĩ wuda nya te akũ a, ɔhaĩ a nɛ́ ɛkpa be.” ");
INSERT INTO bov_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kito lɔkɔ a na, Yesu yi lɛtsã kade kayɔ kĩ, “Midani mi tɔwɔlɛ kamɛ, kitonɛkĩ Baguma lɛgãkanyakɔ̃ a fuã!” ");
INSERT INTO bov_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kĩ Yesu tsɛ̃ Galilea ɔwɔ lutubu baũ abuĩ yanaa a, ɛmɔ́ bawaɛ̃nyole nviã kĩ bɛnyɛ kɔfɔabi banyɛnɛ. Ade be nyɛ Simon kĩ bavɛ Petro mɔ ɔwaɛ̃ Andrea, kĩ bɛkata tɛsau nɛ lutubu baũ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu bi be kĩ, “Miyatomɔ yĩ lɔkɔa maakɛna mi bati banyɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nɛ awã naa, bɛfɔnɛ be tɛsau awɛ bitomɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu naa lɔtɔ ade ɛmɔ bawaɛ̃nyole nviã bɛbã, Yakobo mɔ Yohanes kĩ bɛnyɛ Zebedeo babi. Bɛna nɛ be ɔkɔlɔ kamɛ bɛmɔ ɔlɛga Zebedeo bɛkalɔla be tɛsau. Yesu vɛ be, ");
INSERT INTO bov_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ade lɛtalɛta bɛfɔnɛ ɔkɔlɔ a mɔ be ɔlɛga awɛ biyi, bitomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu tsã emini nɛ Galilea tite flee akũ ɛkatsa fɔtsa nɛ Yudafɔ fɔtsɛnakɔ̃ a. Ede lɛtsã nɛ Kalɛ Wĩ akũ nɛ Baguma lɛgãkanyakɔ̃ a akũ, ade ɛtsa fɔsɔ ahɔlɔ ahɔlɔ flee a. ");
INSERT INTO bov_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ye akũ fɔlɛtsa gba nɛ Siria tite flee akũ, foesũ bati kpã be a kĩ basɔ fɔsɔ ahɔlɔ ahɔlɔ a bɛma ye, bati kĩ bideĩ nɛ fɔsɔ mɔ ɔhau kamɛ, bikĩ hũhũ kpa deĩ nɛ be kamɛ, bikĩ odetɔ fɔsɔ kaha be, mɔ abafã amɛ, ade Yesu tsa be flee a. ");
INSERT INTO bov_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bati kɔdabu baũ kĩ bito Galilea tite akũ, mɔ Tɛmatɔ Ewua kamɛ, Yerusalem ɔmatɔ, Yudea tite akũ mɔ Yordan ɔwɔ liti tite akũ a yatomɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kĩ Yesu mɔ́ bati kɔdabu a, ede ɛnaa ɔtɔ akũ ɛnakɛna akũ edzi. Ye fɔtsa bakɔlɛnɛ a yakpɔta nɛ ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ade edo be fɔtsa katsa awɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Baguma hila bikĩ binyina kĩ bɛnyɛ ahiãfɔ nɛ Baguma anɛ a, kitonɛkĩ be la Baguma lɛgãkanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Baguma hila bikĩ babe kɔnya a, kitonɛkĩ Baguma aadɔla be tɔwɔlɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Baguma hila bikĩ bɛdɔla be akũ a, kitonɛkĩ ade be aanya tite akũ adzapadiɛ a. ");
INSERT INTO bov_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Baguma hila bikĩ Baguma kawɛ akũ kakɛna kɔlɛ mɔ ɔmɔado akɔ be a, kitonɛkĩ Baguma aafɔ̃ biwĩ! ");
INSERT INTO bov_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Baguma hila bikĩ bamɔ bati kɔnya a, kitonɛkĩ ade be Baguma aamɔ kɔnya a! ");
INSERT INTO bov_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Baguma hila bikĩ be tɔwɔlɛ teĩ nɛ ye odi akũ, kitonɛkĩ ade be aamɔ Baguma a! ");
INSERT INTO bov_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Baguma hila bikĩ bakɛna lukudɔ nɛ bati kayite, kitonɛkĩ Baguma aavɛ be kĩ ye babi! ");
INSERT INTO bov_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Baguma hila bikĩ batomɔ be liti, nɛ ye kawɛ akũ kakɛna sũ a, kitonɛkĩ be la Baguma lɛgãkanyakɔ̃ a! ");
INSERT INTO bov_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Baguma hila mi ntɛ bati avũna mi, katomɔ mi liti, kalɛ tuwuli kpa nɛ mi akũ, nɛ yĩ sũ. ");
INSERT INTO bov_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mimɔ kawɔlɛ, mitu osee, kitonɛkĩ mideĩ kɔtɔkase kpale nɛ ode. Ade ayea bitomɔ Baguma onukpɛ̃ banyɛnɛ a kĩ bɛnya mi lɔtɔ a liti a. ");
INSERT INTO bov_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mila ndɛ lɛdɛmɛ mikpa batidziwa flee. Lɛmɛ ntɛ lɛdɛmɛ yɛla de ɔmɛnɛ ni, osi odima lɛláa kĩ baatsã bibuki bido de ɔmɛnɛ. Lɛdani fɔtsa pupulidza foesũ bata de kawula lɔkɔa bati asumini de. ");
INSERT INTO bov_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mila ndɛ ɔhaĩ mikpa batidziwa flee. Bɛláapuli bɛkɔla ɔmatɔ kĩ bitsua nɛ ɔtɔ akũ. ");
INSERT INTO bov_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Odima látɛna ɔsɛdza kakɔa lɔɔda katsa ye, mbom yakɔa ye kate nɛ ɔsɛdza otse akũ nɛ awã kĩ yaakpalɛ fɔkɔ ɛkpa odi nyɛ odi nɛ tɔtɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ade ayea kɛnɛ kĩ mi ɔsɛdza ɛtɛ̃ nɛ bati anɛ, ayekĩ baamɔ fɔtsa wĩ a kĩ miakɛna a, lɔkɔa bimu mi Ɔlɛga nɛ ode a.” ");
INSERT INTO bov_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ade Yesu buki ɛlɛ kĩ, “Mitakɔna kĩ ĩya kĩ mayaafɔnɛ Mose mbla a mɔ Baguma onukpɛ̃ banyɛnɛ fɔtsa katsa a awɛ. Ntáya kĩ mayaafɔnɛ foe awɛ, mbom ĩya kĩ mayaakɛna foe fɔkpɔla. ");
INSERT INTO bov_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ayekĩ tite mɔ ode táwɔ tɔ̃ kĩĩ ni, bɛláafɔnɛ katsɛlɛ kabii ĩye ke akũ lɛtsa kabii nɛ mbla a kamɛ awɛ, mbɔɛntɛ lɛtsa nyɛ lɛtsa ya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Foesũ odi nyɛ odi kĩ yaafum mbla kabii adi, ɛtsa bati bɛbã lɛmɛ bɛkɛna lɔmɔ ni, yaanya obisɛ̃ kɔlaa nɛ Baguma ode lɛgãkanyakɔ̃ a. Lɛmɛ odi nyɛ odi kĩ ɛkɛna nɛ mbla a akũ, mɔ ɛtsa bati bɛbã lɛmɛ kĩ bɛkɛna foe lɔmɔ ni, yaanya ɔnɔkɔɛ̃ nɛ Baguma ode lɛgãkanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Foesũ mabi mi kĩ míapuli miwo nɛ ode lɛgãkanyakɔ̃ a, ntɛ miakɛna nɛ Baguma kawɛ akũ kaba mbla batsanɛ mɔ Farisifɔ a. ");
INSERT INTO bov_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Minu kĩ kɔkɔɛ a, bibi bati kĩ, ‘Takɔ oti, ade odi nyɛ odi kĩ edi awu ni, baadzɛmɔ ye.’ ");
INSERT INTO bov_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lɛmɛ finyaa mabi mi kĩ odi nyɛ odi kĩ ɛna kalɔkpa nɛ ɔwaɛ̃ akũ ni, baadzɛmɔ ye. Odi nyɛ odi kĩ ɛvɛ ɔwaɛ̃ kĩ, ‘Ɔkɔasia’ ni, baakpã ye bɛnamɛna nɛ Ɔmaĩ banɔkɔɛ̃ anɛ bɛdzɛmɔ ye, ade odi nyɛ odi kĩ ɛvɛ ɔwaɛ̃ kĩ, ‘ɔyaɛ’ ni, ɛfɛta ɛkpa ode fi luwotu a kamɛ kanaa. ");
INSERT INTO bov_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Foesũ ntɛ ɔwɛ kĩ akɔa nɔ afɔlibɔ fɔtsa ɔnaate nɛ afɔlibɔ atɛnyɛ akũ ɔkpa Baguma, mɔ ote anɛ kĩ awaɛ̃ nɛɛ nɔ kalɔɛ ni, ");
INSERT INTO bov_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","fɔnɛ nɔ afɔliɛ fɔtsa a awɛ kayi nɛ afɔlibɔ atɛnyɛ a lɔtɔ nɛ awã, kamuniki kanaalɔla mi mɔ ye kayite tɔ̃ fɔmɔ ayakɔa nɔ afɔliɛ fɔtsa ɔkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ntɛ odi sama nɔ nɛ fɔlɛtsa kadzɛkɔ̃ ni, bɔa mbɔdi milɔla mi kayite nɛ lɔkɔ a kĩ lideĩ fɔmɔ baavɛ kalɛ a. Ntɛ nnɛ́ aye mɔ miwo fɔlɛtsa kadzɛkɔ̃ a, oti a aakɔa nɔ edo nɛ fɔlɛtsa ɔdzɛnɛ awɛ. Fɔlɛtsa ɔdzɛnɛ a lɛmɛ aakɔa nɔ ɛkpa polisifɔ ade baado nɔ nɛ kɔla a. ");
INSERT INTO bov_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ ade awã aana flee kɛnaawo lɔkɔ a kĩ ose kɔtɔ a flee oyua a. ");
INSERT INTO bov_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Minu kĩ bɛlɛ kĩ, ‘Batsɔ̃ mɔ banyɔ bɛtanɛ bakɔba liti.’ ");
INSERT INTO bov_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lɛmɛ finyaa mabi mi kĩ odi nyɛ odi kĩ ɛmɔ́ otsole, mɔ ɛkɔ ye odo ni, ɛwɛ ye kɔkɔɛ nɛ ye ɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Foesũ ntɛ nɔ sɔmɔna linebi afɔ̃ akɛna tɔkpa ni, bɔlɛ de kata kamuni. Fɔnɛnɛ fɔkpa nɔ kĩ ayɛla nɔ sukɛna kakɔ kadi kɛba kĩ baata nɔ oti mɔa bido nɛ fi kĩ fɔádĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ntɛ nɔ sɔmɔna kɔkpɔ afɔ̃ akɛna tɔkpa ni, tsua koe kata kamuni. Fɔnɛnɛ fɔkpa nɔ kĩ ayɛla nɔ kɔkpɔ mɔa kɛba kĩ bɛta nɔ oti mɔa a flee bido nɛ fi kĩ fɔádĩ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bɛlɛ lɛmɛ kĩ, ‘Odi nyɛ odi kĩ yaasĩ ɔtsɔ̃ ni, kɛnɛ kĩ ɛkpa ye kɔtsɔ̃ kasĩ ovoli.’ ");
INSERT INTO bov_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lɛmɛ finyaa mabi mi kĩ ntɛ onyole odi sĩ ɔtsɔ̃ nɛ fɔlɛtsa bɛbã akũ kɛba kĩ nnɛ́ ye liti kanɛ sũ ni, onyole a fɔ̃ otsole a bɔa adɔpaa ntɛ ebuki ɛnadzi kɔnyɔ bɛbã. Ade ayea onyole bɛbã a kĩ yaakɔã ye a lɛmɛ bɔa adɔpaa a. ");
INSERT INTO bov_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Minu lɛmɛ kĩ bibi kɔkɔɛ bati a kĩ, ‘Mitatu mi fubo, mbom mikɛna nɛ fubo a kĩ milɔ mikpa boe Ɔlate a akũ.’ ");
INSERT INTO bov_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lɛmɛ finyaa mabi mi kĩ mitalɔ fubo ntɛ miakɛna nhihiɛ adi. Mitatani ode, kitonɛkĩ Baguma lɛgãkpo yanɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mitatani tite kitonɛkĩ Baguma abɔa kakekɔ̃ tanɛ ĩye mitani Yerusalem, kitonɛkĩ ɛnyɛ Lɛgã Kpale a ɔmatɔ. ");
INSERT INTO bov_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tatani nɔ lɔlɔ malo, kitonɛkĩ ɔláapuli ɔdani sɔlɔ mɔapɛ malo sɛkɛna suwovoe ĩye sɔwɔwa. ");
INSERT INTO bov_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mikɔ̃ milɛ kĩ, ‘Oo,’ ĩye ‘Oowo.’ Kalɛ bɛbã kĩ mialɛ nɛ kakĩĩ liti to Oti Kpa a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Minu kĩ bɛlɛ kĩ, ‘Linebi nɛ linebi kadokɔ̃, lɔdɔ̃ nɛ lɔdɔ̃ kadokɔ̃.’ ");
INSERT INTO bov_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lɛmɛ finyaa mabi mi kĩ mitakɛna tɔkpa mise tɔkpa kɔtɔ. Ntɛ odi balɛ nɔ awɛ nɛ sɔmɔna ɔlɔtɔ ni, fɔ̃ ɛbalɛ nɔ nɛ sɛba ɔlɔtɔ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ade ntɛ odi sama nɔ nɛ fɔlɛtsa kadzɛkɔ̃ kĩ yatɛ nɔ atadiɛ anyanglede ni, fɔ̃ ɛtɛ nɔ atadiɛ wulaa a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ntɛ oti kĩ edeĩ otumi hɛ nɔ kĩ lɔ ye fɔtsa mɔ kuvũ mitsã lisikũ mɔa ni, lɔ foe mitsã fusikũ nviã. ");
INSERT INTO bov_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ntɛ odi wã nɔ litsedi ni, kpa ye, ntɛ odi wɛ kĩ yavɛ litsedi nɛ nɔ sɛkɛ̃ ni, kpa ye ɛvɛ. ");
INSERT INTO bov_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Minu kĩ bɛlɛ kĩ, ‘Wɛ nɔ ɔkɔba kalɛ, kakesĩ nɔ bakesĩnɛ.’ ");
INSERT INTO bov_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lɛmɛ finyaa mabi mi kĩ miwɛ mi bakesĩnɛ kalɛ ade mibɔa mpaɛ nɛ bikĩ bitomɔ mi liti a lɔlɔ, ");
INSERT INTO bov_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ayekĩ míadani boe Ɔlɛga nɛ ode a babi. Kitonɛkĩ ye afɔ̃ suwa ata kakpa bati wĩ mɔ bati kpa flee, ade yafɔ̃ oni ako kakpa bati kĩ badã kpĩĩ mɔ bikĩ baádã kpĩĩ a flee a. ");
INSERT INTO bov_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ntɛ miawɛ bikĩ bawɛ mi kalɛ odi a, kɔtɔkase kɔɔdabe míana? Tɔgɔlɛ batɛnɛ malo akɛna foe lɔmɔ! ");
INSERT INTO bov_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ade ntɛ mi bakɔba odi miado onukpɛ̃ ni, litsa mitɛnɛ kakɛna? Amamufɔ malo akɛna foe lɔmɔ! ");
INSERT INTO bov_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Foesũ midã kĩ mikpɔla ndɛ ayekĩ mi Ɔlɛga nɛ ode a lɛmɛ kpɔla a. ");
INSERT INTO bov_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Midã kadã wĩ kĩ miláakɛna mi ɔsum fɔtsa a nɛ kanade anɛ ayekĩ bati aamɔ lɛtsa a kĩ miakɛna a. Ntɛ mikɛna foe nɛ bati anɛ ni, miláana kɔtɔkase mitomɛna mi Ɔlɛga nɛ ode a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Foesũ ntɛ ote ohiãni fɔtsa ni, tade lɛtsã nɛ foe akũ ndɛ ayekĩ anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ a akɛna nɛ be fɔtsɛnakɔ̃ mɔ tɔblɔnu anɛ a. Bakɛna foe ayekĩ bati aamu be. Mabi mi pefee kĩ bɛtɛ be kɔtɔkase a flee kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Foesũ nɔ kɔ̃ ntɛ akɛna sɛmɛ kalɛ ɔkpa ohiãni ni, tafɔ̃ nɔ ɔkɔba paa malo linyi lɛtsama nɛ foe akũ. ");
INSERT INTO bov_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Foesũ nɔ futetsa a fɔna nɛ kabɛla kamɛ, lɔkɔa nɔ Ɔlɛga a kĩ yamɔ fɔtsa nɛ kabɛla kamɛ a, aase nɔ foe kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ntɛ miabɔa mpaɛ ni, mitakɛna ndɛ anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ a aye. Bawɛ kayidza kadza kabɔa mpaɛ nɛ Yudafɔ fɔtsɛnakɔ̃ mɔ tɔblɔnu fɔbalikɔ̃ ayekĩ odi nyɛ odi aamɔ be. Mabi mi nɛ ɔnɔkɔali kamɛ kĩ bɛtɛ be kɔtɔkase a lodo kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lɛmɛ ntɛ abɔa mpaɛ ni, wo nɛ nɔ kɔla kamɛ, kabalɛ kɔla a lɔkɔa kabɔa mpaɛ kakpa nɔ Ɔlɛga a kĩ bɔámɔ mɔ anɛ a, lɔkɔa Aga a kĩ yamɔ fɔtsa a kĩ akɛna nɛ kabɛla kamɛ a aase nɔ kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ntɛ miabɔa mpaɛ ni, mitalɛ fɔlɛtsa beblebee kĩ fɔlá kayɔ ndɛ ayekĩ amamufɔ akɛna a. Be bakɔna kĩ ntɛ be mpaɛbɔ deĩ lugo a mɔ Baguma aatse be. ");
INSERT INTO bov_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mitakɛna mi akũ ndɛ be, kitonɛkĩ mi Ɔlɛga nyina lɛtsa a kĩ lisĩ mi kɔkɔɛ fɔmɔ miavia ye malo. ");
INSERT INTO bov_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Foesũ mibɔa mpaɛ kĩ, ‘Boe Ɔlɛga kĩ edeĩ nɛ ode, nɔ dĩ akũ lɛkpalɛ. ");
INSERT INTO bov_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nɔ lɛgãkanya lɛya. Bɛkɛna nɔ kawɛ nɛ tite akũ, ndɛ ayekĩ bakɛna nɛ ode a. ");
INSERT INTO bov_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kpa boe daa funitsã a kĩ busĩ nviã a. ");
INSERT INTO bov_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kɔa boe tɔkpa a kĩ bɔkɛna a kate boe, ndɛ ayekĩ bɔakɔa kate bikĩ bɛkɛna tɔkpa nɛ boe akũ a. ");
INSERT INTO bov_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Takpã boe ɔnamɛna sɔhuiɛ kamɛ, mbom nyɛ boe katomɛna Oti kpa a awɛ. Fɔya lɔmɔ.’ ");
INSERT INTO bov_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kitonɛkĩ ntɛ mikɔa bati tɔkpa a kĩ bɛkɛna nɛ mi akũ mite be ni, mi Ɔlɛga nɛ ode a lɛmɛ aakɔa mi tide a ete mi. ");
INSERT INTO bov_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lɛmɛ ntɛ mitákɔa bati tɔkpa mite be ni, mi Ɔlɛga nɛ ode a lɛmɛ lɛláakɔa mi tɔkpa a ete mi. ");
INSERT INTO bov_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ntɛ miasui onukpɛ̃ ni, mitakɛna anɛ kamɛ kusuu ndɛ ayekĩ anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ akɛna a. Bakɛna anɛ kamɛ kusuu ayekĩ bati aamɔ kĩ basui onukpɛ̃. Mabi mi nɛ ɔnɔkɔali kamɛ kĩ bɛtɛ be kɔtɔkase a flee kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ntɛ asui onukpɛ̃ ni, vɔlɛ anɛ, do kugua nɛ lɔlɔ kamɛ kasɛla tɔlɔ, ");
INSERT INTO bov_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ayekĩ bati bɛbã lɛláanyi kĩ asui onukpɛ̃. Nɔ Ɔlɛga a, kĩ baámɔ mɔ anɛ a odi aanyi, ade Ɔlɛga a kĩ yamɔ fɔtsa nɛ kabɛla kamɛ a aase nɔ foe kɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mitawɛ akũ kana fɔtsa miyi akũ nɛ tite kĩĩ akũ, awã kĩ fupuka mɔ nkandɔlɔ aabula foe kade, ade bayekpanɛ lɛmɛ abubuli kɔla kawo kaye foe a. ");
INSERT INTO bov_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mbom miwɛ akũ kana fɔtsa miyi akũ nɛ ode, awã kĩ fupuka mɔ nkandɔlɔ lɛláabula foe kade, ade bayekpanɛ lɛmɛ lɛláapuli bubuli biwo biye foe a. ");
INSERT INTO bov_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kitonɛkĩ awã kĩ nɔ fɔtsa mɔ kɔya deĩ ni, ade awã nɔ ɔwɔlɛ lɛmɛ deĩ a. ");
INSERT INTO bov_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Otidziwa banebi nyɛ ye ɔsɛdza. Ntɛ nɔ banebi amɔ kamɔ wĩ ni, nɔ oti mɔawɛ a flee aana nɛ ɔhaĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lɛmɛ ntɛ nɔ banebi lɛnɛ́nɛ ni, nɔ oti mɔawɛ a aana nɛ ɔtũ kamɛ. Foesũ ntɛ ɔhaĩ a kĩ edeĩ nɛ nɔ kamɛ a nyɛ ɔtũ ni, nɔ oti mɔawɛ kamɛ aake ɔtũ paa. ");
INSERT INTO bov_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Odima lɛláapuli esum balate nviã, kitonɛkĩ yaakesĩ ɔmɔa lɔkɔa ɛwɛ ɔyade a kalɛ, ĩye yaakɔa akũ ɛmɛnamɔ ɔmɔa esupa ɔyade a. Ɔnɔkɔali nyɛ kĩ ɔláapuli osum Baguma mɔ katinya kamɛ fɔtsa. ");
INSERT INTO bov_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ade foesũ mabi mi kĩ mitaha akũ nɛ lɛtsa a kĩ míanya, mimɔa midzi nkpã akũ, ĩye tilima a kĩ míasua akũ ĩye midzi a akũ. Mbɔɛɛ nkpã tátɛ kɔya ɛba funitsã, ĩye mbɔɛɛ oti mɔawɛ a tátɛ kɔya ɛba tilima mɔ tɛtadiɛ? ");
INSERT INTO bov_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Midã kɔvɔlabi, kɔádu funitsã, kɔákpɔta funitsã kako nɛ tili kamɛ, lɛmɛ mi Ɔlɛga nɛ ode a adɔɔla koe! Mbɔɛɛ mitátɛ kɔya miba kɔvɔlabi? ");
INSERT INTO bov_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mi kamɛ owei aapuli ɛkɔa luwi mɔa ete nɛ ye nkpã fuwi akũ ntɛ eti ɛha ye akũ bo aye malo? ");
INSERT INTO bov_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Lɔkɔa nde sũ miaha akũ nɛ tilima mɔ tɛtadiɛ akũ? Midã ayekĩ lupo kamɛ futse ako nhuilɛ kabo anɛ, fɔákɛna adzuma, fɔátaɛ tileti kanɔ tilima kakpa akũ. ");
INSERT INTO bov_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lɛmɛ mabi mi kĩ Lɛgã Salomo mɔ ye akũ kana fɔtsa a flee malo táhɛhɛ fɔlɛ kadã ndɛ nhuilɛ kĩĩ kamɛ amɔa. ");
INSERT INTO bov_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ntɛ Baguma kɛɛlɛ lupo kamɛ tuwĩ lɔmɔ, kĩ tideĩ nkpã nviã, ade kunya tiku, bipila te nɛ luwotu kamɛ a ni, ɛláakɛɛlɛ mi ɛba te? Mi katɛkado adã kabii paa! ");
INSERT INTO bov_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Foesũ mitakaha akũ mikalɛ kĩ, ‘Litsa bɔ́anya, litsa bɔ́amɔa ĩye litsa bɔ́asua akũ?’ ");
INSERT INTO bov_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ade fukĩĩ bamɛ liti amamufɔ atomɛna a. Mi Ɔlɛga nɛ ode a nyina kĩ fɔtsa kĩĩ flee sĩ mi. ");
INSERT INTO bov_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mifɔ̃ anɛ ɛyɔɔlɛ mi ɛba nɛ Baguma ode lɛgãkanyakɔ̃ a liti katomɛna mɔ fɔtsa a kĩ ɛwɛ etomɛna mi sɛkɛ̃ kĩ mikɛna a akũ, lɔkɔa yaakɔa fɔtsa bɛbã kĩĩ flee ebu ɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Foesũ mitaha akũ nɛ kunya akũ, kunya luwi a aana de mɔawɛ ɔhau. Luwi nyɛ luwi kamɛ ɔhau pɔnɛ ɛkpa de. ");
INSERT INTO bov_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mitadzɛmɔ bati bɛbã fɔfɔ̃ Baguma lɛmɛ lɛdzɛmɔ mi, ");
INSERT INTO bov_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kitonɛkĩ ayekĩ midzɛmɔ bati bɛbã a, ade aye Baguma lɛmɛ aadzɛmɔ mi a, ade mbla a kĩ mikɔa midzɛmɔ bati bɛbã a, ye mɔapɛ a yakɔa ɛdzɛmɔ mi malo a. ");
INSERT INTO bov_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nde sũ adã sukuluku kĩ sideĩ nɛ awaɛ̃ linebi kamɛ lɛmɛ aámɔ luvokũ a kĩ lideĩ nɛ nɔ mɔawɛ linebi kamɛ a? ");
INSERT INTO bov_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nde aapuli obi awaɛ̃ kĩ, ‘Make nɔ aduli, fɔ̃ ĩnyɛ sukuluku nɛ nɔ linebi kamɛ’ nɛ lɔkɔ a kĩ luvokũ deĩ nɛ nɔ mɔawɛ linebi kamɛ a? ");
INSERT INTO bov_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nɔ anɛ kamɛ kɛkɛ fɔtsa ɔkɛnanɛ! Nya lɔtɔ kanyɛ luvokũ a nɛ nɔ linebi kamɛ lɔkɔa aapuli ɔmɔ́ yededeede ɔnyɛ sukuluku nɛ awaɛ̃ linebi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mitakɔa fɔtsa a kĩ foe akũ kpalɛ mikpa bakpete, baadani bɛyaadɔ̃ mi. Mitata mi fulitsa kĩ fɔtɛ kɔya miko baplakuo, kitonɛkĩ baasumini foe bibula kade. ");
INSERT INTO bov_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mivia fɔtsa lɔkɔa baakpa mi, miwɛ fɔtsa lɔkɔa míamɔ foe, mibɔa opunu lɔkɔa baabinya bɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kitonɛkĩ odi nyɛ odi kĩ ɛwã fɔtsa ni, yana foe. Odi nyɛ odi kĩ ɛwɛ litsedi ni, yaamɔ de, ade odi nyɛ odi kĩ yabɔa opunu ni, baabinya bɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mi kamɛ obilɛga ɔɔdabe deĩ kĩ ntɛ obi via ye abodoo ni, yaabɔɛ de edo nɛ ye awɛ? ");
INSERT INTO bov_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ĩye ntɛ evia ye kafɔabi kĩ yaakɔa kɔɛ ɛkpa ye? ");
INSERT INTO bov_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ntɛ mi a kĩ minyɛ bati kpa a, minyina ayekĩ miate mi babi fɔtsa wĩ a ni, titi eni mɔ mi Ɔlɛga nɛ ode lɛláakɔa ye fɔtsa wĩ pii ɛkpa bikĩ bavia ye a? ");
INSERT INTO bov_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Foesũ lɛtsa nyɛ lɛtsa a kĩ miawɛ kĩ bati bɛbã bɛkɛna bɛkpa mi ni, mi malo mikɛna foe lɔmɔ mikpa be. Ade fukĩĩ Mose mbla a mɔ Baguma onukpɛ̃ banyɛnɛ fɔlɛtsa a atsa a. ");
INSERT INTO bov_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mitsã onyukpɛ̃ manɛwa a kamɛ miwo, kitonɛkĩ onyukpɛ̃ a kĩ ɛsa a mɔ osi a kĩ ɛdzɛlɛ a anaa kawɔ kamɛ, ye akũ katsã lɛlá ɔsĩ, ade bati pii lɛmɛ tsɛ̃ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lɛmɛ onyukpɛ̃ a kĩ yanaa nkpã kamɛ a manɛ, ade osi a kĩ ɛwaa ɛnaa a awã akũ katsã deĩ ɔsĩ, ade bati sukuloo lɛmɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Midã mi akũ kadã wĩ nɛ fɔvã tunukpɛ̃ banyɛnɛ akũ. Baya nɛ mi sɛkɛ̃ miamɔ ndɛ baveli aye, lɛmɛ nɛ be kamɛkamɛ ni, bɛla ndɛ kulikii kĩ kude adɔ̃. ");
INSERT INTO bov_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Míakɔa be fɔkɛnatsa minyi be. Ɔgɔabi láwũ akutu, ade ɔtatsuɛ láwũ asãã babi a. ");
INSERT INTO bov_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kutse wĩ awũ babi wĩ, ade kutse kpa lɛmɛ awũ babi kpa a. ");
INSERT INTO bov_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kutse wĩ lɛláapuli kuwũ babi kpa, ade ayea kutse kpa lɛmɛ lɛláapuli kuwũ babi wĩ a. ");
INSERT INTO bov_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lɛmɛ kutse nyɛ kutse kĩ kɔáwũ babi wĩ ni, batsua koe kata kado nɛ fi kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Foesũ fɔvã onukpɛ̃ banyɛnɛ a fɔkɛlatsa míakɔa minyi be. ");
INSERT INTO bov_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nnɛ́ odi nyɛ odi kĩ yavɛ yĩ kĩ, ‘Boe Ɔlate! Boe Ɔlate!’ aanaa ode lɛgãkanyakɔ̃ a kamɛ, mbɔɛntɛ bikĩ bakɛna nɛ Nda kawɛ akũ a odi aanaa awã. ");
INSERT INTO bov_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ntɛ Kadzɛ Luwi a wo ɔtɔ a, bati pii aavɛ yĩ kĩ, ‘Boe Ɔlate! Boe Ɔlate! Nnɛ́ nɔ dĩ akũ bɔlɛ Baguma fɔlɛtsa, bɔblɔmɛna hũhũ kpa butomɛna bati kamɛ, ade bɔkɛna awãwã fɔtsa pii lɛmɛ a?’ ");
INSERT INTO bov_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ade awã mɔ maabi be kĩ, ‘Ĩnyína mi koũ. Midzakũ nɛ yĩ anɛ kamɛ, mi tɔkpa bakɛnanɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Foesũ odi nyɛ odi kĩ yatse yĩ fɔlɛtsa kĩĩ mɔ ɛkɛna nɛ foe akũ ni, ɛla ndɛ ɔnyansãni kĩ eke ye kɔla nɛ de mɔ ɔsĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oni kpale ko, ade tɔwɔ yili, ɔwɛ vũ mɔ ɔsĩ mɔ ɔsĩ ɛyabɔa kɔla a, lɛmɛ kɔtáveli, kitonɛkĩ bike koe nɛ de mɔ ɔsĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lɛmɛ odi nyɛ odi kĩ yatse yĩ fɔlɛtsa kĩĩ mɔ yaákɛna nɛ foe akũ ni, ɛla ndɛ odzimbifɔ kĩ eke ye kɔla nɛ dã kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oni kpale ko, tɔwɔ yili ade ɔwɛ mɔ ɔsĩ vũ ɛyabɔa kɔla ade kuveli, kɔtɔ gbloo, kububuli a!” ");
INSERT INTO bov_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kĩ Yesu yua fɔlɛtsa kĩĩ kalɛ a, akũ dzuli bati kɔdabu a nɛ ye fɔtsa katsa a akũ. ");
INSERT INTO bov_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kitonɛkĩ ɛtsa fɔtsa ndɛ oti kĩ edeĩ otumi, kĩ fɔtána ndɛ mbla batsanɛ a fude. ");
INSERT INTO bov_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kĩ Yesu ka eto katɔbii a akũ yaya a, bati kɔdabu kɔdabu pii tomɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ade awã mɔ onyole odi kĩ yasɔ fɔsɔ ngbã, kĩ bati avila a, yake aduli nɛ ye anɛ kamɛ, ebi ye kĩ, “Boe Ɔlate, ntɛ fɔnyɛ nɔ kawɛ ni, aapuli ɔfɔ̃ fɔsɔ kĩĩ lɛwɔ nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu yo awɛ ɛta ye ade ebi ye kĩ, “Mawɛ lɔmɔ. Nɔ akũ ɛkpalɛ.” Ade lɛtalɛta fɔsɔ a wɔ nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ade Yesu bi ye kĩ, “Tse! Tabi odima kadima, mbom dã osi kpĩĩ kanaa ɔsɔfɔ sɛkɛ̃, kafɔ̃ ɛsɛla nɔ akũ ɛdã, lɔkɔa kabɔa afɔliɛ a kĩ Mose mbla tsa a, fɔfɔ̃ odi nyɛ odi enyi kĩ ɔsaɛ.” ");
INSERT INTO bov_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ke liti a, kĩ Yesu wo nɛ Kapernaum ɔmatɔ kamɛ a, Roma sodzafɔ ɔnɔkɔɛ̃ odi yake ye aduli kĩ, ");
INSERT INTO bov_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Boe Ɔlate, yĩ ɔsumunɛ waa nɛ kɔla yasɔ, yaápuli ekuna akũ, ade ɛlamɔ lubo kamɔ paa a.” ");
INSERT INTO bov_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kpa ye mbuayɛ kĩ, “Maaya ĩyaatsa ye.” ");
INSERT INTO bov_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lɛmɛ sodzafɔ ɔnɔkɔɛ̃ a bi ye kĩ, “Boe Ɔlate, ntákpɔla kĩ awo nɛ yĩ tɔtɔ kamɛ. Nɔ kɔ̃ lɛ kalɛ mɔapɛ lɔkɔa yĩ ɔsumunɛ a aasaɛ. ");
INSERT INTO bov_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yĩ malo ĩnyɛ oti kĩ ndeĩ nɛ banɔkɔɛ̃ kayɔ, ade ndeĩ sodzafɔ nɛ yĩ malo kayɔ a. Ntɛ mbi be kamɛ odi kĩ, ‘Naa’ ni, yanaa, ade ntɛ mbi ɔbɛbã lɛmɛ kĩ, ‘Ya’ ni, yaya. Ntɛ mbi yĩ ɔsumunɛ lɛmɛ kĩ, ‘Kɛna fukĩĩ’ ni, yakɛna foe.” ");
INSERT INTO bov_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kĩ Yesu nu fukĩĩ a, fɔkɛna ye wãwã, ade ebi bati a kĩ bitomɔ ye a kĩ, “Ɔnɔkɔali mabi mi kĩ ntámɔ odima nɛ Israel kĩ edeĩ katɛkado kĩĩ odu. ");
INSERT INTO bov_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mabi mi pipiipi kĩ bati pii aato suwa kadekɔ̃ mɔ suwa katomukɔ̃ bɛyaadzi nɛ opunu akũ mɔ Abraham, mɔ Isak mɔ Yakob nɛ Baguma lɛgãkanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lɛmɛ Baguma aata bikĩ be mbom la lɛgãkanyakɔ̃ a ewula nɛ ɔtũ kamɛ, awã kĩ baabe, bɛba adɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ke liti a, Yesu bi sodzafɔ ɔnɔkɔɛ̃ a kĩ, “Naa kɔla! Fɔ́aya nɛ foe kamɛ ndɛ ayekĩ ɔtɛ odo a.” Ade ye ɔsumunɛ a saɛ nɛ lɔkɔ a na pɛpɛɛpɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kĩ Yesu naa Petro tɔtɔ kamɛ a, ɛmɔ kĩ Petro nyina waa nɛ ɔkɛna akũ yasɔ atilili. ");
INSERT INTO bov_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu pi ye nɛ kɔkpɔ ade lɛtalɛta atilili a dɔ ye, eyidza ete opunu ɛkpa ye a. ");
INSERT INTO bov_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kĩ olobe wo ɔtɔ a, bati kpã bikĩ hũhũ kpa deĩ nɛ be kamɛ a bɛma Yesu. Ɛblɔmɛna hũhũ kpa a etomɛna be kamɛ mɔ kalɛ mɔapɛ, ade ɛtsa basɔnɛ a flee lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fukĩ ɛkɛna kĩĩ ya nɛ foe kamɛ ndɛ ayekĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ eyi kĩ, “Ye mɔawɛ lɛkɔa boe lubo kamɔ, mɔ fɔsɔ ahɔlɔ ahɔlɔ ete nɛ ye akũ!” ");
INSERT INTO bov_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kĩ Yesu mɔ́ bati kɔdabu pii a kĩ kusinya ye a, ebi ye fɔtsa bakɔlɛnɛ a kĩ bɛfɔ̃ binyina bɛnaa ɔwɔ lutubu baũ a liti. ");
INSERT INTO bov_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ade mbla batsanɛ a kamɛ odi ya nɛ ye sɛkɛ̃ ɛyabi ye kĩ, “Fɔtsa Ɔtsanɛ, maatomɔ nɔ nnaa kakɔ nyɛ kakɔ kĩ aanaa.” ");
INSERT INTO bov_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kpa ye mbuayɛ kĩ, “Kulikii deĩ fudzikɔ̃, kɔvɔlabi lɛmɛ deĩ fɔtsɔɛ, lɛmɛ Otidziwa Obi a lɛlá awã kĩ yate lɔlɔ malo.” ");
INSERT INTO bov_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ye fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa lɛmɛ bi ye kĩ, “Boe Ɔlate, maatomɔ nɔ, lɛmɛ fɔ̃ nnaabila nda tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ade Yesu kpa ye mbuayɛ kĩ, “Tomɔ yĩ. Fɔnɛ bikĩ bidzi nkpã ndɛ kaku biku a awɛ bibila be mɔawɛ banɔkpa.” ");
INSERT INTO bov_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu wo nɛ ɔkɔlɔ odi kamɛ ade ye fɔtsa bakɔlɛnɛ a tomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lɛtalɛta ɔwɛ mɔ ɔsĩ odi do kavũ awɛ nɛ ɔwɔ lutubu baũ a akũ, kabɔa mui kako nɛ ɔkɔlɔ a kamɛ, kĩ fɔfɔ̃ kite sukuloo ɔkɔlɔ a adoomu, lɛmɛ Yesu kɔ̃ waa tida. ");
INSERT INTO bov_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ye fɔtsa bakɔlɛnɛ a nadzɛla ye, ade bibi ye kĩ, “Boe Ɔlate, tɛ boe o-o! Buku buyua!” ");
INSERT INTO bov_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ade Yesu bi be kĩ, “Nde sũ libe wo mi lɔmɔ? Mi katɛkado lɛpɔ́nɛ kɔlaa!” Adeke eyidza ɛdza, ewũni nɛ mui mɔ ɔwɛ a akũ kĩ bɛkɛna dĩĩ, ade awã flee kɛna dĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Odi nyɛ odi kɛna saa, ade bɛkavia akũ kĩ, “Oti ɔdabe odu nyɛ okĩĩ? Ɔwɛ mɔ mui malo atse ye ɔlɛdo!” ");
INSERT INTO bov_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kĩ Yesu nawo Gadara tite akũ nɛ ɔwɔ lutubu baũ liti a, bati nviã kĩ hũhũ kpa na nɛ be kamɛ nɛ́ bito fɔkɛ kĩ babila banɔkpa kamɛ bɛyatsɛlamɔ ye. Ayekĩ be akũ deĩ libe sũ ni, odima lapuli katsã awã osi a katɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ade lɛtalɛta bɛbɔa fɔwɔla kɔɔba kĩ, “Nɔ Baguma Obi, litsa deĩ nɛ bɔmɔ nɔ kayite? Kaya ɔya kĩ ayaakɛna boe tɛnya fɔmɔ lɔkɔ wĩ a aawo ɔtɔ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Awã fuã kakɔ a kĩ baplakuo kɔdabu baũ kudi dza kɔkadɛ a. ");
INSERT INTO bov_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hũhũ kpa a ke Yesu aduli kĩ, “Ntɛ aablɔmɛna boe ni, fɔ̃ bɔnaawo nɛ baplakuo kɔdabu nɛ akĩĩ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu bi be kĩ, “Minɛ minaa.” Foesũ bɛnɛ bɛnawo nɛ baplakuo a kamɛ. Ade baplakuo kɔdabu a flee wula atsɛ kliklikli bɛka lɔwɔtuni geĩ a biwo nɛ lutubu a kamɛ, bɛmɔa mui biku a. ");
INSERT INTO bov_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bayaɛ akũ badãmɛnanɛ a lo bɛnaa ɔmatɔ kamɛ bɛnalɛ fɔlɛtsa a kĩ fɔya a flee nɛ banyole nviã a kĩ hũhũ kpa na nɛ be kamɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Foesũ ɔmatɔ a kamɛ bati flee nɛ́ kĩ banaadã Yesu, ade kĩ bɛmɔ́ ye a, bike ye aduli kĩ ɛdzakũ nɛ be tite akũ ɛnaa. ");
INSERT INTO bov_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu de ewo nɛ ɔkɔlɔ a kamɛ emuniki ɛtsã mui a anɛ ɛnaa ye awɛ ɔmatɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nɛ awã a, bati badi bɔɛ oti odi kĩ eveliveli bɛwɔla nɛ ɔkɛna akũ bɛma ye. Kĩ Yesu mɔ́ be katɛkado a, ebi oti a kĩ eveliveli a kĩ, “Yĩ obi, nɔ ɔwɔlɛ ɛka edzi! Nkɔa nɔ titikpa nte nɔ.” ");
INSERT INTO bov_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Adeke Yudafɔ mbla batsanɛ badi bi be akũ kĩ, “Onyole kĩĩ alɛ fubusuotsa!” ");
INSERT INTO bov_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kĩ Yesu mɔ́ lɛtsa a kĩ bɛkakɔna a, ɛlɛ kĩ, “Nde sũ miakɔna tɔkpa nɛ mi tɔwɔlɛ kamɛ? ");
INSERT INTO bov_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Fɔlɛtsa kĩĩ fɔɔdabe lɛ́la ɔsĩ mɔ kalɛ, ‘Nkɔa nɔ titikpa nte nɔ,’ mbɔɛɛ kĩ, ‘Yidza katsã’? ");
INSERT INTO bov_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lɛmɛ kĩ míanyi kĩ yĩ Otidziwa Obi, ndeĩ kɔbɛ̃ kĩ makɔa bati titikpa kate nɛ katinya kĩĩ kamɛ sũ ni, midã o-o!” Foesũ ebi oti a kĩ eveliveli a kĩ, “Yidza kadza, bɔɛ nɔ ɔkɛna kanaa nɔ awã!” ");
INSERT INTO bov_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Onyole a yidza ɛdza, ɛdzakũ ɛnaa ye awã. ");
INSERT INTO bov_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kĩ bati a mɔ́ fukĩĩ a, libe wo be ade bimu Baguma nɛ ayekĩ ɛkɔa kɔbɛ̃ kĩĩ odu ɛkpa batidziwa. ");
INSERT INTO bov_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu dzakũ nɛ awã, ade kĩ ɛtsɛ̃ yanaa a, ɛmɔ́ ɔgɔlɛ ɔtɛnɛ odi kĩ bavɛ Mateo kĩ edzi nɛ ye ɔgɔlɛ katekɔ̃. Ebi ye kĩ, “Tomɔ yĩ.” Ade Mateo yidza etomɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kĩ Yesu kanya nɛ Mateo awã a, tɔgɔlɛ batɛnɛ pii mɔ tɔkpa bakɛnanɛ bɛbã yadzi nɛ opunu akũ, bibumɔ Yesu mɔ ye fɔtsa bakɔlɛnɛ a bɛnya. ");
INSERT INTO bov_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisifɔ a badi mɔ́ foe ade bivia ye fɔtsa bakɔlɛnɛ a kĩ, “Nde sũ mianya kamɔa mɔ tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ?” ");
INSERT INTO bov_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nu lɛtsa a kĩ bɛkalɛ a, ade ɛkpa be mbuayɛ kĩ, “Basɔnɛ lisĩ bɛkpa tutsonu ɔkɛnanɛ, nnɛ́ bikĩ bideĩ akũ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Minaawɛ Katsɛlɛ Kpalɛwa a kalɛ kĩĩ kayɔ, ‘Sɛmɛ kalɛ kakɛna mawɛ, nnɛ́ bayaɛ afɔliɛ kabɔa mawɛ.’ Ntáya kĩ mayaavɛ bikĩ badã kpĩĩ, mbom ĩya kĩ maavɛ tɔkpa bakɛnanɛ.” ");
INSERT INTO bov_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ke liti a, Yohanes Mui Ɔwɔlanɛ a fɔtsa bakɔlɛnɛ ya nɛ Yesu sɛkɛ̃ ade bivia ye kĩ, “Nde sũ bɔmɔ Farisifɔ bɔawɛ onukpɛ̃ kasui, lɛmɛ nɔ fɔtsa bakɔlɛnɛ a kɔ̃ lásui onukpɛ̃ koũ?” ");
INSERT INTO bov_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kpa be mbuayɛ kĩ, “Kakɔna miakɔna kĩ obolitsɔ̃ ɔnyɔ bakɔba aadzi nɛ ayɔlɔhɔ kamɛ nɛ lɔkɔ a kĩ edeĩ nɛ be kamɛ a? Fɔláanya lɔmɔ. Lɛmɛ luwi a aaya kĩ baakpã obolitsɔ̃ ɔnyɔ a bɛdzakũmɛna nɛ be sɛkɛ̃, ade lɔkɔ a na kamɛ mɔ́ baasui onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Odima lákɔa limakũ vɔɛ̃ kataɛ atadiɛ kɔɛ, kitonɛkĩ limakũ vɔɛ̃ a aavɛlɛ lɔkɔɛ a lɛbɛ̃, lɔkɔa ɔkɛ baũ aawa ɛba ɔkɔɛ a. ");
INSERT INTO bov_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ade ayea odima láko waĩ vɔɛ̃ nɛ ɔyaɛ ovoli kuvũ kɔɛ kamɛ a, kitonɛkĩ ɔyaɛ kuvũ a aayili kɔbɛ̃, waĩ a liwula, ade ɔyaɛ kuvũ a lɛmɛ aabu kade a. Mbom bako waĩ vɔɛ̃ nɛ ɔyaɛ kuvũ vɔɛ̃ kamɛ lɔkɔa foe atsu nviã a flee lɛláabu kade.” ");
INSERT INTO bov_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kĩ Yesu kalɛ kɔdzɛla a, Yudafɔ katsɛnakɔ̃ ɔnɔkɔɛ̃ odi ya nɛ ye sɛkɛ̃, ade eke aduli nɛ ye anɛ kamɛ, ebi ye kĩ, “Yĩ obitsole ku finyaakĩĩ, lɛmɛ yaate awɛ nɛ ye akũ ayekĩ yaanyinya.” ");
INSERT INTO bov_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ade Yesu yidza bɛmɔ ye fɔtsa bakɔlɛnɛ a bitomɔ ye bɛnaa a. ");
INSERT INTO bov_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Otsole odi kĩ babɔanɛ kawula ye futeli ewua-nviã flee natsã Yesu liti, ɛta ye atadiɛ sɔtɔbi. ");
INSERT INTO bov_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ɛlɛ nɛ ye lɔlɔ kamɛ kĩ, “Ntɛ nsila nta ye atadiɛ odi pɛ, maasaɛ.” ");
INSERT INTO bov_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kĩ Yesu dani ɛmɔ́ otsole a, ebi ye kĩ, “Yĩ obi, nɔ ɔwɔlɛ ɛka edzi. Nɔ katɛkado tsa nɔ.” Otsole a akũ de ɔsĩ nɛ lɔkɔ a na pɛpɛɛpɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ke liti a, Yesu tomɔ ɔnɔkɔɛ̃ a biwo nɛ ye tɔtɔ kamɛ. Kĩ ɛmɔ́ tukutɔnɔ basãnɛ mɔ bati beblebee a kĩ bɛlamɛna kabe yoo a, ");
INSERT INTO bov_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ebi be kĩ, “Mi flee minɛ, kabisɛ̃ɛ̃tsole a táku, mbom tida kɛwaa!” Ade bati a flee mɛmɛ ye a. ");
INSERT INTO bov_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kĩ bɛblɔmɛna bati a bɛnɛmɛna a, Yesu wo nɛ kabisɛ̃ɛ̃ a sɛkɛ̃ nɛ kɔla a kamɛ. Epi ke nɛ kɔkpɔ ade kinyinya kiyidza kɛdza a. ");
INSERT INTO bov_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fɔlɛtsa kĩĩ gba nɛ tite a na akũ flee. ");
INSERT INTO bov_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kĩ Yesu to awã yanaa a, banɛkunɛ nviã badi tomɔ ye nɛ liti bɛkabɔa fɔwɔla kɔɔba kĩ, “Dawid obi, mɔ boe kɔnya!” ");
INSERT INTO bov_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kĩ Yesu wo nɛ tɔtɔ kamɛ a, banɛkunɛ a ya nɛ ye sɛkɛ̃, ade evia be kĩ, “Mitɛ mido kĩ maapuli ntsa mi?” Bɛkpa mbuayɛ kĩ, “Oo, boe Ɔlate!” ");
INSERT INTO bov_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Foesũ Yesu kɔa awɛ ɛta be banebi ɛlɛ kĩ, “Fɔya nɛ foe kamɛ ndɛ ayekĩ mitɛ mido a.” ");
INSERT INTO bov_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ade be anɛ binya bɛmɔ́ fɔkɔ a. Yesu si be mbla mɔ ɔsĩ kĩ, “Mitabi odima fukĩĩ!” ");
INSERT INTO bov_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lɛmɛ bɛdzakũ nɛ awã bɛnagbamɛna fɔlɛtsa a nɛ Yesu akũ nɛ tite a amantam a flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kĩ banyole a nɛ banaa a, bati badi kpã oti bɛbã kĩ yaápuli ɛlɛ kɔdzɛla, kitonɛkĩ hũhũ kpa deĩ nɛ ye kamɛ a bɛma Yesu. ");
INSERT INTO bov_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kĩ Yesu sila ɛblɔmɛna hũhũ kpa a nɛ ye kamɛ a, epuli ɛlɛ kɔdzɛla. Fɔkɛna bati kɔdabu a wãwã, ade bɛlɛ kĩ, “Bɔtámɔ tɔ̃ fukĩĩ odu nɛ Israel.” ");
INSERT INTO bov_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lɛmɛ Farisifɔ a lɛ kĩ, “Hũhũ kpa a lɛgã lɛkpa ye kɔbɛ̃ ɛnɛɛ yablɔmɛna hũhũ kpa.” ");
INSERT INTO bov_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu mini nɛ tɛmatɔ mɔ tukula a kamɛ. Ɛtsa fɔtsa nɛ fɔtsɛnakɔ̃ a, ɛlɛ Kalɛ Wĩ a nɛ ode lɛgã kanyakɔ̃ a akũ, ade ɛtsa fɔsɔ ahɔlɔ ahɔlɔ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kĩ ɛmɔ́ bati kɔdabu a, be akũ kɔ ye kɔnya, kitonɛkĩ kipiã be, bɛlá obumɛnanɛ ade bɛgba biko ndɛ baveli kĩ bɛlá ɔkpãnɛ a. ");
INSERT INTO bov_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Foesũ ebi ye fɔtsa bakɔlɛnɛ a kĩ, “Fudutsa a kĩ baaveli a pɔnɛ, lɛmɛ adzuma bakɛnanɛ a lɛpɔ́nɛ. ");
INSERT INTO bov_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Foesũ mike kɔba ɔlate a kĩ ye fudutsa baaveli a aduli, kĩ edo adzuma bakɛnanɛ bɛyaakpɔta foe.” ");
INSERT INTO bov_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu vɛ ye fɔtsa bakɔlɛnɛ ewua-nviã a ɛkpɔta, ade ɛkpa be kɔbɛ̃ kĩ bɛblɔmɛna hũhũ kpa bitomɛna bati kamɛ, bɛtsa fɔsɔ fudi nyɛ fudi a. ");
INSERT INTO bov_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Fɔtɔ banyanɛ ewua-nviã a buĩ nyɛ. Ɔtɔnyade, Simon kĩ bibuki bavɛ Petro, mɔ ɔwaɛ̃ Andrea, Yakobo mɔ ɔwaɛ̃ Yohanes kĩ bɛnyɛ Zebedeo babi, ");
INSERT INTO bov_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo mɔ Bartolomeo mɔ Toma, Mateo ɔgɔlɛ ɔtɛnɛ a, mɔ Alfeo obi Yakobo mɔ Tadeo, ");
INSERT INTO bov_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon kĩ epili ye kade lɔlɔ, mɔ Yuda Iskariot kĩ ye lɛnyɛ Yesu ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu do bati ewua-nviã kĩĩ fɔtɔ mɔ ɔlɛdo kĩ, “Mitanaa bikĩ bɛnyɛ́ Yudafɔ a tite akũ ĩye miwo nɛ Samariafɔ tɛmatɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mbom minaa Israelfɔ a kĩ bɛla ndɛ baveli kĩ bɛyɛla osi a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Minaade lɛtsã kĩ, ‘Baguma ode lɛgãkanyakɔ̃ a fuã!’ ");
INSERT INTO bov_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mitsa basɔnɛ, midzɛla banɔkpa bidzi nkpã, mitsa bikĩ basɔ fɔsɔ ngbã, miblɔmɛna hũhũ kpa mitomɛna bati kamɛ. Mitɛ kɔbɛ̃ kĩĩ kɔa, foesũ mikɔa mikpa faa. ");
INSERT INTO bov_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mitabɔɛ sika sidima milɛ nɛ mi fuvũ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Odima ɛtabɔɛ ositsãnɛ kuvũ, atadiɛ ayade, mpabua ayade ĩye otse kĩ bake katsã ɛlɛ nɛ osi a akũ. Kɛfɛta kĩ bɛkpa adzuma ɔkɛnanɛ lɛtsa a kĩ esĩ a. ");
INSERT INTO bov_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ntɛ miwo ɔmatɔ ĩye akula adi kamɛ ni, miwɛ oti odi kĩ yaatunɔ ɛtɛ mi, lɔkɔa mise nɛ ye sɛkɛ̃, mina nɛ awã kɛnaawo kĩ míadzakũ. ");
INSERT INTO bov_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ntɛ miwo nɛ tɔtɔ tidi kamɛ ni, miwɔ̃na te kamɛ bati a kĩ, ‘Lukudɔ lɛna nɛ mi akũ.’ ");
INSERT INTO bov_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ntɛ tɔtɔ a kamɛ bati a tɛ mi mɔ kawɔlɛ ni, mifɔ̃ mi lukudɔ kawɔ̃na a kɛkahɔ nɛ be akũ. Lɛmɛ ntɛ bɛtátɛ mi ni, mifɔ̃ mi lukudɔ kawɔ̃na a kimuniki kɛya nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Awã kĩ bati tátɛ mi ni, minɛ nɛ ɔmatɔ a kamɛ lɔkɔa miyɔ mi abɔa akũ kudu miko be. ");
INSERT INTO bov_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mabi mi ɔnɔkɔali a kĩ nɛ Kadzɛ Luwi a akũ a, Baguma aamɔ Sodom mɔ Gomora bati kɔnya ɛba ɔmatɔ a na kamɛ bati. ");
INSERT INTO bov_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Midã, mado mi ndɛ baveli aye nɛ kulikii kamɛ, foesũ minyi kadi ndɛ bɔɛ aye, midɔla akũ bɔɛɛ ndɛ mblɔduma aye. ");
INSERT INTO bov_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Midã mi akũ kadã wĩ, kitonɛkĩ bati aakɔa mi bido nɛ fɔlɛtsa badzɛnɛ awɛ, ade baabo mi nɛ Yudafɔ fɔtsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ade nɛ yĩ sũ baakpã mi bɛnamɛna ɔmaĩ banɔkɔɛ̃ mɔ fɔgã anɛ, lɔkɔa fɔnya adansiɛ kĩ míadi nɛ Kalɛ Wĩ a akũ mikpa be mɔ bikĩ bɛnyɛ́ Yudafɔ a. ");
INSERT INTO bov_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ntɛ bɛkpã mi bɛnamɛna fɔlɛtsa kadzɛkɔ̃ ni, mitaha akũ nɛ lɛtsa a kĩ míalɛ mɔ ayekĩ míadzɛla a akũ. Ntɛ lɔkɔ a wo ɔtɔ a, Baguma aakpa mi fɔlɛtsa a kĩ míalɛ a, ");
INSERT INTO bov_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kitonɛkĩ nnɛ́ mi aalɛ kɔdzɛla, mbom mi Ɔlɛga Hũhũ a aalɛ kɔdzɛla ɛtsãmɛna mi akũ. ");
INSERT INTO bov_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Bati aakɔa be mɔawɛ bawaɛ̃ bɛkpa kĩ bɛkɔ, ade balɛga lɛmɛ aakɛna foe lɔmɔ nɛ be mɔawɛ babi akũ, ade babi aayidza bɛdza nɛ be bamanɛ akũ bɛfɔ̃ bɛkɔ be a. ");
INSERT INTO bov_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bati flee aakesĩ mi nɛ yĩ sũ, lɛmɛ oti a kĩ yaadza pintii kɛnaawo kawũna ni, Baguma aakpa ye nkpã. ");
INSERT INTO bov_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ntɛ bitomɔ mi liti nɛ ɔmatɔ odi kamɛ ni, milo minaa ɔbɛbã kamɛ. Mawɛ kĩ minyi kĩ miláayua adzuma kakɛna nɛ Israel tɛmatɔ a kamɛ fɔmɔ Otidziwa Obi a aaya. ");
INSERT INTO bov_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Fɔtsa ɔkɔlɛnɛ odima lɛbɛ́ ye fɔtsa ɔtsanɛ, ade ɔsumunɛ lɛmɛ lɛbɛ́ ye ɔlate a. ");
INSERT INTO bov_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kɛnɛ kĩ fuwĩ ɔkɔlɛnɛ kĩ yayaakɛna ndɛ ye fɔtsa ɔtsanɛ, ade ɔsumunɛ lɛmɛ kĩ yayaakɛna ndɛ ye ɔlate a. Ntɛ bɛvɛ kɔla ɔnɔkɔɛ̃ odi kĩ hũhũ kpa flee lɛgã a, buĩ kpa badabe bɛláavɛ kɔla babi? ");
INSERT INTO bov_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nɛ foe sũ mitavila bati. Lɛtsa nyɛ lɛtsa kĩ bɛkɔa bɛkɔla finyaa ni, baanyɛ de kanya, ade kalɛ a kĩ bɛkɔla ni, kaanɛ binu ke. ");
INSERT INTO bov_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lɛtsa a kĩ mabi mi nɛ ɔtũ kamɛ a, milɛ de nɛ suwa ketee, ade lɛtsa a kĩ minu nɛ kabɛla kamɛ a, mide ke lɛtsã nɛ kanade. ");
INSERT INTO bov_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mitavila bati a kĩ bakɔ oti sukɛna lɛmɛ bɛláapuli bɛkɔ ɔkla a, mbom mivila Baguma a kĩ yaapuli ɛwɔla oti sukɛna mɔ ye ɔkla flee nɛ fi luwotu kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kaplɛ mɔapɛ miakɔa kaya funitataɛ nviã, lɛmɛ koe kamɛ kamɔapɛ malo látɔ nɛ tite kĩ fɔnyɛ́ mi Ɔlɛga nɛ ode a kawɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mi kɔ̃ Baguma kã mi lɔlɔ tɔlɔ malo flee. ");
INSERT INTO bov_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Foesũ mitavila, kitonɛkĩ mitɛ kɔya miba funitataɛ beblebee. ");
INSERT INTO bov_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Odi nyɛ odi kĩ yaabɔa yĩ dĩ nɛ bati anɛ kĩ ye ode manɛ ni, yĩ malo maakɛna foe lɔmɔ nkpa ye nɛ Nda nɛ ode a anɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lɛmɛ ntɛ odi sĩ yĩ nɛ bati anɛ ni, yĩ malo maasĩ ye nɛ Nda nɛ ode a anɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mitakɔna kĩ lukudɔ nkɔa ĩyamɛna nɛ katinya kamɛ. Oowo, ntáya mɔ lukudɔ, mbom kɔpã nkɔa ĩyamɛna. ");
INSERT INTO bov_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ĩya kĩ makɛna ‘babinyole biyidza bɛdza nɛ balɛga akũ, babitsole liyidza bɛdza nɛ bama akũ, babi batsɔ̃ biyidza bɛdza nɛ be nyina amɛ akũ. ");
INSERT INTO bov_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Oti bakesĩnɛ aanya ye mɔawɛ tɔtɔ kamɛ bati.’ ");
INSERT INTO bov_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Odi nyɛ odi kĩ yawɛ ɔlɛga ĩye ɔma kalɛ kaba yĩ ni, ɛtákpɔla kĩ yanya yĩ fɔtsa ɔkɔlɛnɛ, ade ayea odi nyɛ odi kĩ yawɛ ye obinyole ĩye obitsole kalɛ kaba yĩ ni, ɛtákpɔla kĩ yanya yĩ fɔtsa ɔkɔlɛnɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Odi nyɛ odi kĩ ɛtábɔɛ ye asendua etomɔ yĩ nɛ liti ni, ɛtákpɔla kĩ yanya yĩ fɔtsa ɔkɔlɛnɛ. ");
INSERT INTO bov_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Odi nyɛ odi kĩ ɛwɛ kĩ yapili ye nkpã ni, yaayɛla ye, lɛmɛ odi nyɛ odi kĩ yaayɛla ye nkpã nɛ yĩ sũ ni, yaana nkpã kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Odi nyɛ odi kĩ ɛtɛ mi ni, ɛtɛ yĩ malo, ade odi nyɛ odi kĩ ɛtɛ yĩ ni, ɛtɛ oti a kĩ edo yĩ a. ");
INSERT INTO bov_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Odi nyɛ odi kĩ ɛtɛ Baguma onukpɛ̃ ɔnyɛnɛ nɛ kĩ ɛnyɛ Baguma onukpɛ̃ ɔnyɛnɛ sũ ni, yaana kɔtɔkase a kĩ Baguma aakpa ye a kamɛ. Ade odi nyɛ odi kĩ ɛtɛ oti wĩ nɛ ayekĩ ɛnyɛ oti wĩ sũ ni, yaana tsɛfã nɛ kɔtɔkase a kĩ Baguma aakpa oti wĩ a odu. ");
INSERT INTO bov_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mitɛ mido kĩ odi nyɛ odi kĩ yaakpa bikĩ bitomɔ yĩ kĩĩ kamɛ obisɛ̃de mɔa mui dɔwa kɔɔpu mɔapɛ malo ni, yaana foe kɔtɔkase.” ");
INSERT INTO bov_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kĩ Yesu do ye fɔtsa bakɔlɛnɛ ewua-nviã a fɔtɔ eyua a, ɛdzakũ nɛ awã ɛnaa tɛmatɔ a kĩ tifuã a kamɛ kĩ yanaatsa fɔtsa, ede lɛtsã nɛ Baguma fɔlɛtsa a lɛmɛ akũ. ");
INSERT INTO bov_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kĩ Yohanes Mui Ɔwɔlanɛ a, kĩ ɛwaa kɔla a nu lɛtsa a kĩ Yesu lamɛna kakɛna a, edo ye fɔtsa bakɔlɛnɛ a badi nɛ Yesu sɛkɛ̃, ");
INSERT INTO bov_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kĩ bɛnaavia ye kĩ, “Nɔ nyɛ oti a kĩ Baguma lɛ eyi kĩ yaaya a, mbɔɛɛ kĩ bɔdã oti bɛbã anɛ?” ");
INSERT INTO bov_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kpa be mbuayɛ kĩ, “Mimuniki minaabi Yohanes lɛtsa a kĩ mimɔ́ mɔ lɛtsa a kĩ minu a. ");
INSERT INTO bov_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Banɛkunɛ mɔ́ fɔkɔ, bikĩ biveliveli yidza bɛtsɛ̃, bikĩ basɔ fɔsɔ ngbã akũ kpalɛ, batɔsĩnɛ anu fɔkɔ, bɛdzɛla banɔkpa bidzi nkpã, ade bɛlamɛna ahiãfɔ Kalɛ Wĩ a kabi a. ");
INSERT INTO bov_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Baguma hila oti a kĩ ɛtámɔ nfumusu adima nɛ yĩ akũ!” ");
INSERT INTO bov_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kĩ Yohanes batɔ a dzakũ a, Yesu yi kayɔ mɔ kɔdzɛla kalɛ nɛ Yohanes akũ kabi bati kɔdabu a kĩ, “Kĩ minɛ minaa Yohanes sɛkɛ̃ nɛ kɔsa kamɛ a, litsa minaadã? Kɔɔkaɛ kĩ ɔwɛ abɔa katomɛna katɛ̃mɛna mbɔɛɛ? ");
INSERT INTO bov_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Litsa koũ minɛ minaadã? Oti kĩ ɛkɛɛlɛ ye akũ mɔ fɔtsa mɔ kalɛ yanɛ? Bikĩ bado tɛtadiɛ mɔ kɔya ni, fɔgã tɔtɔ kamɛ bana. ");
INSERT INTO bov_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mibi yĩ lɛtsa a sũ koũ miti minɛ a? Kĩ míamɔ Baguma onukpɛ̃ ɔnyɛnɛ mbɔɛɛ? Nuwĩ mifɔ̃ nti mbi mi, mimɔ́ oti a kĩ ɛbɛ̃ Baguma onukpɛ̃ ɔnyɛnɛ malo. ");
INSERT INTO bov_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kitonɛkĩ Yohanes akũ mɔ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Dã, maado yĩ fɔtɔ ɔnyanɛ ĩnyamɛna nɔ lɔtɔ, yaalɔla osi nɛ nɔ lɔtɔ.’ ");
INSERT INTO bov_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ Yohanes Mui Ɔwɔlanɛ a bɛ̃ otidziwa odi nyɛ odi kĩ edzi nkpã tɔ̃. Lɛmɛ oti kĩ ɛnyɛ obisɛ̃ kɔlaa nɛ ode lɛgãkanyakɔ̃ a bɛ̃ Yohanes. ");
INSERT INTO bov_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kito Yohanes lɛtsã kade lɔkɔ kɛyawo nviã kĩĩ ni, bati yidza bɛdza nɛ Baguma ode lɛgãkanyakɔ̃ a akũ mɔ ɔsĩ mɔ ɔsĩ, bɛlamɔ mbɔdi kabɔa lɛmɛ kĩ basua de kaya osi. ");
INSERT INTO bov_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kɛyawo Yohanes kaya lɔkɔ a, Baguma onukpɛ̃ banyɛnɛ a flee mɔ Mose mbla a lɛ fɔlɛtsa biyi nɛ Baguma ode lɛgãkanyakɔ̃ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ntɛ miawɛ kĩ miatɛ be fɔlɛtsa mido kɔ̃ ni, minyi kĩ Yohanes nyɛ Eliya a kĩ bɛlɛ biyi kĩ yaanya lɔtɔ ɛya a. ");
INSERT INTO bov_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Oti a kĩ edeĩ sɔtɔ kĩ sanu tuwuli ni, etse! ");
INSERT INTO bov_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Finyaa, litsa maakɔa nviã bati nkɔnamɔ? Bɛla ndɛ babisɛ̃ kĩ bikoni nɛ kɔyaatɔ bagulo. Babɔa fɔwɔla kabi be bakɔba kĩ, ");
INSERT INTO bov_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Bɔsã obolitsɔ̃ tɔnɔ bɔkpa mi, lɛmɛ mitáto. Bɔsã tukutɔnɔ bɔkpa mi, lɛmɛ mitábe.’ ");
INSERT INTO bov_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kĩ Yohanes ya a, ɛtánya ɛtámɔa waĩ, lɛmɛ bati lɛ kĩ, ‘Hũhũ kpa deĩ nɛ ye kamɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kĩ Otidziwa Obi a ya a, yanya, yamɔa, ade bati lɛ kĩ, ‘Midã ɔnyakpanɛ mɔ bavɛ ɔmɔanɛ, tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ ɔkɔba.’ Lɛmɛ oti fɔkɛlatsa kamɛ bamɔ ye nyansã.” ");
INSERT INTO bov_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tɛmatɔ a kĩ te kamɛ Yesu kɛna ye awãwã fɔtsa pii a kamɛ bati tádani tɔwɔlɛ kamɛ, foesũ ɛkã tɛmatɔ a anɛ ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Bɔbɔɛ makpa nɔ Korasin! Bɔbɔɛ makpa nɔ Betsaida! Ntɛ awãwã fɔtsa a kĩ nkɛna nɛ mi kamɛ a mɔ Tiro mɔ Sidon tɛmatɔ kamɛ nkɛna foe ni, kufɛ te kamɛ bati dani tɔwɔlɛ kamɛ kɔkɔɛ bidzi tikpekpe, bɛtsɛla batɔ. ");
INSERT INTO bov_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ nɛ Kadzɛ Luwi a akũ ni, Baguma aamɔ Tiro mɔ Sidon bati kɔnya ɛba mi! ");
INSERT INTO bov_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ade nɔ Kapernaum! Ɔwɛ kĩ abɔɛ nɔ akũ ɔdɛla ɔnaatamɔ ode? Baakɛna nɔ nɛ kayɔ flee ɔnaawo kanɔkpade! Kitonɛkĩ awãwã fɔtsa a kĩ bɛkɛna nɛ nɔ kamɛ a mɔ Sodom bɛkɛna foe ni, kufɛ ɔmatɔ a buki edeĩ mɔ nviã kĩĩ! ");
INSERT INTO bov_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ nɛ Kadzɛ Luwi a akũ ni, Baguma aamɔ Sodom ɔmatɔ a kɔnya ɛba nɔ.” ");
INSERT INTO bov_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nɛ lɔkɔ a na kamɛ a, Yesu lɛ kĩ, “Nda, tite mɔ ode Ɔlate, manyɛ nɔ kɔlɛ kĩ ɔnyɛ fɔtsa a kĩ bɛkɔa bɛkɔla tuvoli banyinɛ mɔ anyansãfɔ a ɔtsa babisɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oo! Nda, ade foe awo nɔ anɛ a. ");
INSERT INTO bov_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nda kɔa lɛtsa nyɛ lɛtsa edo nɛ yĩ awɛ. Odima linyína Obi a mbɔɛntɛ Ɔlɛga a odi, ade odima lɛmɛ linyína Ɔlɛga a mbɔɛntɛ Obi a odi, mɔ bikĩ Obi a awɛ kĩ yanyɛ ye ɛtsa a. ");
INSERT INTO bov_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Miya nɛ yĩ sɛkɛ̃, mi flee a kĩ mikɛna adzuma, minɔnɛ fɔtsa mɔ ɔlɔmɛ kĩ kipiã mi a, lɔkɔa maakpa mi kawɛya. ");
INSERT INTO bov_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mibɔɛ yĩ sɔmɔ akũ otse a mite nɛ mi akũ, mikɔlɛ fɔtsa mitomɛna yĩ sɛkɛ̃, lɔkɔa mina kawɛya, kitonɛkĩ yĩ fɔlɛtsa dɔ, ade ndɔla yĩ akũ nɛ ɔwɔlɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kitonɛkĩ yĩ sɔmɔ akũ otse a kalɔ lɛlá ɔsĩ, ade yĩ fɔtsa a kĩ maalɔla mi a adã faafaa a.” ");
INSERT INTO bov_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nɛ lɔkɔ a na kamɛ a, Yesu natsã fugbanɔ kɔba kudi kamɛ nɛ Kawɛya Luwi akũ. Kɔlɛ kakɔ ye fɔtsa bakɔlɛnɛ a, foesũ biveli fudi bɛtsɛ̃ bɛba. ");
INSERT INTO bov_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kĩ Farisifɔ mɔ́ foe a, bibi Yesu kĩ, “Dã, nɔ fɔtsa bakɔlɛnɛ akɛna lɛtsa a kĩ boe mbla tákpa osi kĩ bɛkɛna nɛ Kawɛya Luwi akũ!” ");
INSERT INTO bov_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ade Yesu kpa be mbuayɛ kĩ, “Mbɔɛɛ mitakã tɔ̃ lɛtsa a kĩ Dawid kɛna nɛ lɔkɔ a kĩ kɔlɛ kɔ bɛmɔ bati a kĩ bitomɔ ye a? ");
INSERT INTO bov_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ewo nɛ Baguma kɔla a kamɛ ade bɛmɔ ye bati a bɛnya abodoo a kĩ bɛkɔa bɛbɔa afɔliɛ bɛkpa Baguma a, titɔ kĩ mbla tákpa osi kĩ bɛnya ye malo. Basɔfɔ odi bɛkpa osi kĩ bɛnya abodoo a na. ");
INSERT INTO bov_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mbɔɛɛ mitákã nɛ Mose mbla ovoli a kamɛ kĩ nɛ Kawɛya luwi nyɛ luwi akũ ni, basɔfɔ a kĩ basum nɛ Asɔli Kɔla kamɛ a afum Kawɛya Luwi mbla a, lɛmɛ baákɔ be foe kɔtɔ? ");
INSERT INTO bov_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mabi mi kĩ lɛtsa a kĩ lɛtɛ kɔya lɛba Asɔli Kɔla a deĩ nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Sɛmɛ kalɛ mawɛ, nnɛ́ bayaɛ afɔliɛ.’ Ntɛ kanu minu fɔlɛtsa kĩĩ kayɔ ni, kufɛ miláakɔ bikĩ bɛtáfum a kɔtɔ, ");
INSERT INTO bov_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","kitonɛkĩ Otidziwa Obi a nyɛ Kawɛya Luwi a Ɔlate.” ");
INSERT INTO bov_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu dzakũ nɛ awã ɛnaa Yudafɔ katsɛnakɔ̃ kadi, awã kĩ ");
INSERT INTO bov_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","onyole odi kĩ ye kɔkpɔ ku lɛmɛ na. Bati badi kĩ bɛwɛ kĩ babɔɛ fɔlɛtsa nɛ Yesu akũ na nɛ awã, foesũ bivia ye kĩ, “Boe mbla kpa osi kĩ bɛtsa fɔsɔ nɛ Kawɛya Luwi akũ?” ");
INSERT INTO bov_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kpa be mbuayɛ kĩ, “Ntɛ mi kamɛ odi deĩ kuveli mɔa mɔ kɔka kuwo nɛ lɛkɛ kamɛ nɛ Kawɛya Luwi akũ a, ɛláado awɛ epi koe ɛnyɛ? ");
INSERT INTO bov_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ade oti deĩ kɔya ɛbɛ̃ kuveli a! Foesũ boe mbla kpa osi kĩ bɛkɛna tuwĩ nɛ Kawɛya Luwi akũ.” ");
INSERT INTO bov_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Adeke ebi onyole a kĩ ye kɔkpɔ ku a kĩ, “Yo nɔ kɔkpɔ.” Eyo kɔkpɔ a ade kubuki kɔna ɔsĩ ndɛ kɔyade a. ");
INSERT INTO bov_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ade Farisifɔ a dzakũ bɛnapi adzuni kĩ baakɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kĩ Yesu nu kĩ bisui nɛ ye akũ a, ɛdzakũ nɛ lɔpɔ a na kamɛ, lɛmɛ bati kɔdabu baũ tomɔ ye. Ɛtsa basɔnɛ a flee, ");
INSERT INTO bov_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ade esi be mbla kĩ bɛtabi bati kadima nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɛlɛ fukĩĩ ayekĩ fɔlɛtsa a kĩ Baguma lɛ ɛtsãmɛna ye Onukpɛ̃ Ɔnyɛnɛ Yesaya akũ a aaya nɛ foe kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ade yĩ osumunɛ a kĩ mpau nɛ awĩ a. Ɛnyɛ oti kĩ mawɛ kalɛ, ade yawo yĩ anɛ a. Maakɔa yĩ Hũhũ nko nɛ ye akũ, lɔkɔa ede lɛtsã nɛ yĩ fɔlɛtsa kadzɛ akũ ɛkpa fude fude. ");
INSERT INTO bov_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɛláavɛlɛ fɔlɛtsa, ĩye ɛbɔa fɔwɔla, ĩye binu ye odo nɛ tɔblɔnu anɛ. ");
INSERT INTO bov_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yaana ɔwɔlɛ bɔɛɛ ɛkpa bikĩ bɛlá kɔbɛ̃ a, ade yaakɛna sɛmɛ kalɛ ɛkpa bikĩ bɛlá kabumɛna a. Yaadza pintii kɛnaawo kĩ ɛfɔ̃ kadzɛ nɛ osi kpĩĩ akũ anya akũ, ");
INSERT INTO bov_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ade bati flee aakɔa anɛ bite nɛ ye akũ a.” ");
INSERT INTO bov_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ke liti a, bati badi kpã oti odi kĩ hũhũ kpa deĩ nɛ ye kamɛ, kĩ ɛnyɛ ɔnɛkunɛ mɔ omumu bɛma Yesu. Yesu tsa oti a, epuli ɛlɛ kɔdzɛla ɛmɔ fɔkɔ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lɛtsa a kĩ Yesu kɛna a, kɛna bati kɔdabu a flee a saa, ade bivia kĩ, “Mbɔɛɛ nnɛ́ Dawid Obi a nɛ awĩ a?” ");
INSERT INTO bov_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kĩ Farisifɔ nu fukĩĩ a, bɛlɛ kĩ, “Yablɔmɛna hũhũ kpa kitonɛkĩ hũhũ kpa lɛgã Beelzebul akpa ye kɔbɛ̃ kĩ ɛkɛna foe.” ");
INSERT INTO bov_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu nyi lɛtsa a kĩ bɛkakɔna a, foesũ ebi be kĩ, “Ɔmaĩ odi nyɛ odi kĩ ɛsɛ̃ ye akũ nɛ kutsu kutsu kamɛ, mɔ tɛdzɛ deĩ nɛ ye kamɛ ni, ɛláadzi gɛlɛɛlɛ. Ade aye a ntɛ ɔmatɔ ĩye kɔla kudi bati sɛ̃ nɛ kutsu kutsu kamɛ mɔ tɛdzɛ deĩ nɛ be kamɛ ni, kaku ɔmatɔ a ĩye kɔla a aaku. ");
INSERT INTO bov_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Foesũ ntɛ katsu mɔa kadi nɛ Abonsam lɛgãkanyakɔ̃ anɔ mɔ kabɛbã ni, fɔatsa kĩ ye lɛgãkanyakɔ̃ a sɛ̃ kutsu kutsu kɔkɔɛ, ade kɔ́ayalɛ a. ");
INSERT INTO bov_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ntɛ mialɛ kĩ Beelzebul lɛkpa yĩ kɔbɛ̃ nnɛɛ mablɔmɛna hũhũ kpa a ni, owei lɛkpa bati a kĩ bitomɔ mi a kɔbɛ̃ bɛnɛɛ bablɔmɛna hũhũ kpa? Lɛtsa a kĩ mi mɔawɛ bati a kĩ bitomɔ mi akɛna a, aakɔ mi kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Oowo! Nnɛ́ Beelzebul kɔbɛ̃ nnɛɛ, mbom Baguma Hũhũ kɔbɛ̃ nnɛɛ mablɔmɛna hũhũ kpa, kĩ fɔatsa kĩ Baguma lɛgãkanya a ya nɛ mi akũ kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Odima lɛláapuli ewo nɛ ɔbɛlɛbɛ kɔla kamɛ efila ye akũ fɔtsa, mbɔɛntɛ ɛnya lɔtɔ esuli oti a edo nɛ tɔwɛ̃ kamɛ fɔmɔ yaapuli ɛpasa tɔtɔ a kamɛ efila ye fɔtsa. ");
INSERT INTO bov_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Odi nyɛ odi kĩ edzɛ́ nɛ yĩ liti ni, eyidza nɛ yĩ akũ, ade odi nyɛ odi kĩ yaábumɔ yĩ bɔakpɔta ni, kayalɛ yayalɛ kawula. ");
INSERT INTO bov_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ade foesũ mabi mi kĩ baakɔa tɔkpa nyɛ tɔkpa mɔ fubusuotsa fudi nyɛ fudi kĩ bati alɛ a bite be, lɛmɛ odi nyɛ odi kĩ yaalɛ fubusuotsa nɛ Hũhũ Kpalɛwa a kɔ̃ akũ ni, bɛláakɔa bite ye. ");
INSERT INTO bov_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Odi nyɛ odi kĩ yaalɛ kɔdzɛla etia Otidziwa Obi a ni, baakɔa bite ye, lɛmɛ odi nyɛ odi kĩ yaalɛ kɔdzɛla etia Hũhũ Kpalɛwa a ni, bɛláakɔa bite ye finyaa ĩye nɛ lɔkɔ a kĩ laya a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Fɔmɔ aana kutse libi wĩ ni, kɛnɛ kĩ ana kutse wĩ, ade ntɛ odeĩ kutse kpa ni, kutse libi kpa aana. Babi a kĩ kutse awũ a bakɔa kanyi kutse a odu. ");
INSERT INTO bov_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mi bati ndɛ bɔɛ babi! Nde míapuli milɛ fɔlɛtsa wĩ kĩ minyɛ tɔkpa bakɛnanɛ? Kitonɛkĩ lɛtsa a kĩ liyi oti ɔwɔlɛ kamɛ ni, ade foe anɛ nɛ ye onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Oti wĩ anyɛ fɔtsa wĩ kanya katomɛna ye fɔtsa wĩ kakɔlakɔ̃, ade oti kpa lɛmɛ anyɛ fɔtsa kpa kanya katomɛna ye fɔtsa kpa kakɔlakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mitɛ mido kĩ nɛ Kadzɛ Luwi a akũ ni, odi nyɛ odi aanyɛ ye akũ onukpɛ̃ nɛ kalɛ pupulidza kadi nyɛ kadi kĩ ɛlɛ tɔ̃ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nɔ mɔawɛ onukpɛ̃ kamɛ fɔlɛtsa baakɔa bɛdzɛmɔ nɔ bɛkpa nɔ ɔtɔbɛ ĩye bɛkɔ nɔ kɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ade mbla batsanɛ mɔ Farisifɔ badi bi Yesu kĩ, “Fɔtsa Ɔtsanɛ, bɔawɛ kĩ kɛna nsɛntsɛlɛni adi bɔdã.” ");
INSERT INTO bov_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kpa be mbuayɛ kĩ, “Nviã babi kpa mɔ bati kĩ binyína Baguma! Miavia yĩ kĩ nkɛna awãwã fɔtsa midã? Oowo! Awãwã fɔtsa a kĩ baanyɛ bɛtsa mi nyɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Yona fude a. ");
INSERT INTO bov_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndɛ ayekĩ Yona dzi fuwi ɛlalɛ lɛnyɛ mɔ suwa nɛ kafɔabi kpale lupu kamɛ a, ade aye Otidziwa Obi a lɛmɛ aatɛ fuwi ɛlalɛ lɛnyɛ mɔ suwa nɛ tite kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nɛ Kadzɛ Luwi a akũ ni, Ninivefɔ aayidza mɔ mi bidzi bɛkɔ mi kɔtɔ, kitonɛkĩ bɛdani tɔwɔlɛ kamɛ kĩ binu Baguma fɔlɛtsa a kĩ Yona lɛ a. Midã, litsedi deĩ nɛ awĩ kĩ lɛbɛ̃ Yona. ");
INSERT INTO bov_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nɛ Kadzɛ Luwi a akũ a, Seba Lɛgãtsole aayidza ɛdza ɛkɔ mi kɔtɔ, kitonɛkĩ ɛtsã osi gɛlɛɛlɛ eto ye ɔmaĩ kamɛ ɛyatse Lɛgã Salomo nyansã fɔtsa katsa, ade mitɛ yĩ mido kĩ odi deĩ nɛ awĩ kĩ ɛbɛ̃ Salomo. ");
INSERT INTO bov_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ntɛ hũhũ kpa nɛ́ nɛ oti kamɛ a, yanaatsã kamini nɛ fɔkɔ wɛlɛwa kawɛ kadzikɔ̃. Ntɛ ɛtána kadzikɔ̃ ni, ");
INSERT INTO bov_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yabi ye akũ kĩ, ‘Maamuniki nnaa yĩ kɔla kɔɛ a kamɛ.’ Foesũ ntɛ ɛyamɔ kĩ bɛyɔ koe kamɛ bɛlɔla koe kamɛ yededeede a, ");
INSERT INTO bov_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yanaa kanaakpã hũhũ kpa bɛbã evũkɔnɔ kĩ bideĩ ɔsĩ bɛbɛ̃ ye kayamɛna. Bawo nɛ oti a kamɛ kadzi nɛ awã, ade oti a kadzi kamɛ abu kade kaba ayekĩ fɔna nɛ kayɔkayi a. Ade aye fɔ́aya fɔkpa nviã bati kpa kĩĩ a.” ");
INSERT INTO bov_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kĩ Yesu kalɛ kɔdzɛla mɔ bati a, ɔma mɔ bawaɛ̃nyole yawo awã. Bɛdza nɛ kanya bɛwɛ kĩ balɛ kɔdzɛla mɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Foesũ bati a kamɛ odi bi ye kĩ, “Dã, ama mɔ awaɛ̃nyole amɛ dzɛ̃ nɛ kanya bawɛ kĩ balɛ kɔdzɛla mɔ nɔ.” ");
INSERT INTO bov_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kpa be mbuayɛ kĩ, “Owei nyɛ mma? Bawei nyɛ nwaɛ̃ amɛ?” ");
INSERT INTO bov_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ade eyo awɛ ɛtsa ye fɔtsa bakɔlɛnɛ a ɛlɛ kĩ, “Midã, ade mma mɔ nwaɛ̃ amɛ nɛ awĩ a! ");
INSERT INTO bov_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Odi nyɛ odi kĩ yakɛna nɛ Nda nɛ ode kawɛ akũ ni, ade ye nyɛ nwaɛ̃nyole, mɔ nwaɛ̃tsole mɔ mma a.” ");
INSERT INTO bov_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Luwi mɔapɛ a, Yesu nɛ́ nɛ tɔtɔ kamɛ, ɛnadzi nɛ ɔwɔ lutubu baũ a abuĩ ɛkatsa fɔtsa. ");
INSERT INTO bov_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ayekĩ bati kɔdabu a kĩ kɔtsɛna nɛ ye akũ a tɛ́nɛ kapɔ sũ ni, ewo edzi nɛ ɔkɔlɔ kamɛ ade kɔdabu a dza nɛ ɔwɔ abuĩ a. ");
INSERT INTO bov_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɛtsa be fɔtsa pii nɛ fɔgbã kamɛ ɛlɛ kĩ, “Luwi a onyole odi naasã kamɔnɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kĩ ɛkasã babi a nɛ kɔba kamɛ a, badi tɔ nɛ osi ɔɔwɛ̃ ade kɔvɔlabi yafila be bɛmɛna a. ");
INSERT INTO bov_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Babi a badi tɔ nɛ apibɔ akũ awã kĩ tite lɛpɔ́nɛ nɛ boe a anɛ. Babi a mɛ mɔatsɛ kitonɛkĩ tite a kamɛ tádzũ. ");
INSERT INTO bov_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Foesũ kĩ suwa yata a, sipila te tɛvɛ ade tivio mɔatsɛ a, kitonɛkĩ te tunu a tanaa kamɛ dzununu. ");
INSERT INTO bov_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Babi a badi tɔ nɛ fu tuwĩ kamɛ ade kĩ bɛmɛ bade a tuwĩ a bo anɛ tɛmɛna be. ");
INSERT INTO bov_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lɛmɛ babɛbã tɔ nɛ tite wĩ akũ ade biwũ babi a, badi wũ babi ɔha, badi wũ babi aduesia, ade babɛbã lɛmɛ wũ babi taalɛ a.” ");
INSERT INTO bov_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu wũna kĩ, “Oti a kĩ edeĩ sɔtɔ ni, etse!” ");
INSERT INTO bov_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ade fɔtsa bakɔlɛnɛ a ya nɛ Yesu sɛkɛ̃ bivia ye kĩ, “Nde sũ abi bati a fɔlɛtsa nɛ fɔgbã kamɛ?” ");
INSERT INTO bov_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kpa mbuayɛ kĩ, “Mi kɔ̃ bɛnyɛ ode lɛgãkanyakɔ̃ a fɔlɛtsa kɔlawa kamɛ bɛtsa mi, lɛmɛ, bɛtányɛ foe kamɛ bɛtsa be. ");
INSERT INTO bov_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kitonɛkĩ oti a kĩ edeĩ fɔtsa ni, baakpa ye fudi bibu lɔkɔa fɔpɔ fubu, lɛmɛ oti a kĩ ɛlá lɛtsama ni, baatɛ foe kabii a kĩ edeĩ a malo nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lɛtsa sũ a kĩ malɛ kɔdzɛla nɛ fɔgbã kamɛ mɔ be nyɛ kĩ bamɔ mɔ anɛ lɛmɛ baámɔ kayi ɔsũ, batse lɛmɛ baánu foe kayɔ. ");
INSERT INTO bov_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Foesũ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya fɔlɛtsa a kĩ ɛlɛ eyi a ya nɛ foe kamɛ kĩ, ‘Bati kĩĩ aanu bibuki binu lɛmɛ bɛláanu foe kayɔ. Ade baamɔ bibuki bɛmɔ́ lɛmɛ bɛláamɔ biyi ɔsũ. ");
INSERT INTO bov_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kitonɛkĩ be adzuni adã yududu, ade be atɔ lánu kanu wĩ a, ade bisua be anɛ a. Ntɛ nnɛ́ aye ni, be anɛ aamɔ fɔkɔ, be atɔ aanu, be adzuni aanu fɔlɛtsa kayɔ! Ade baadani bɛya nɛ yĩ sɛkɛ̃, lɔkɔa ntsa be fɔsɔ!’ ");
INSERT INTO bov_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lɛmɛ mi kɔ̃ Baguma hila mi! Mi anɛ amɔ ade mi atɔ lɛmɛ anu fɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, Baguma onukpɛ̃ banyɛnɛ mɔ bati kpĩĩ pii wɛ mɔ ɔsĩ kĩ bamɔ lɛtsa a kĩ miamɔ a, lɛmɛ bɛtápuli bɛmɔ́ foe, ade bɛwɛ lɛmɛ kĩ banu lɛtsa a kĩ mianu a lɛmɛ bɛtánu foe. ");
INSERT INTO bov_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Foesũ finyaa mitse ĩnyɛ lɛgbã nɛ kamɔnɛ odunɛ akũ a kayɔ minu. ");
INSERT INTO bov_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Odi nyɛ odi kĩ yanu ode lɛgãkanyakɔ̃ fɔlɛtsa lɛmɛ yaánu foe kayɔ a, la ndɛ babi a kĩ biwula nɛ osi ɔɔwɛ̃ a. Oti Kpa a ayawãnɛ lɛtsa a kĩ bidu nɛ ye kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Babi a kĩ bɛtɔ nɛ apibɔ akũ a nyɛ oti a kĩ ntɛ esila enu fɔlɛtsa a, yatɛ foe mɔatsɛ mɔ kawɔlɛ, ");
INSERT INTO bov_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","lɛmɛ fɔáwo kanaa ye ɔwɔlɛ kamɛ dzununu, ade fɔábuna owi nɛ ye kamɛ a. Foesũ ntɛ ɔhau ĩye bati liti katomɛna ya nɛ fɔlɛtsa kĩĩ sũ ni, yamuniki liti mɔatsɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Babi a kĩ bɛtɔ nɛ fu tuwĩ kamɛ a nyɛ oti a kĩ yanu fɔlɛtsa a, lɛmɛ katinya kamɛ ɔhau mɔ akũ kana fɔtsa liti katomɛna anya fɔlɛtsa a akũ, foesũ fɔáwũ babi. ");
INSERT INTO bov_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ade babi a kĩ bɛtɔ nɛ tite wĩ akũ a nyɛ oti a kĩ yanu fɔlɛtsa a, kanu foe kayɔ lɛmɛ. Bawũ babi, badi ɔha, badi aduesia babɛbã lɛmɛ be taalɛ.” ");
INSERT INTO bov_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu bɔa be lɛgbã bɛbã kĩ, “Ode lɛgãkanyakɔ̃ a la ndɛ oti odi kĩ ɛsã kamɔnɛ babi wĩ nɛ ye kɔba kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nɛ lɛnyɛ mɔa lidi, kĩ odi nyɛ odi wa tida a, ye okesĩnɛ nasã tuwĩ wuluwulu nɛ kamɔnɛ a kamɛ ɛdzakũ. ");
INSERT INTO bov_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kĩ kamɔnɛ a bo anɛ kido kayɛlɛ awɛ a, tuwĩ a lɛmɛ nɛ́ tɛdza nɛ ke kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Oti a basumunɛ ya nɛ ye sɛkɛ̃ bibi ye kĩ, ‘Boe ɔlate, nnɛ́ funitsã wĩ odu nɛ kɔba a kamɛ, mɔ ndia tuwĩ kpa to tɛyamɛ nɛ ke kamɛ?’ ");
INSERT INTO bov_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ɔlate a kpa mbuayɛ kĩ, ‘Okesĩnɛ odi lɛkɛna fukĩna.’ “Adeke bivia ye kĩ, ‘Awɛ kĩ bɔnaabɔlɛ tuwĩ a nɛ ke kamɛ?’ ");
INSERT INTO bov_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ebi be kĩ, ‘Oowo! Kitonɛkĩ ntɛ minaabɔlɛ tuwĩ a ni, míabɔlɛ kamɔnɛ a kadi mɔ te. ");
INSERT INTO bov_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mifɔ̃ kamɔnɛ a mɔ tuwĩ a flee fɔdza fubo anɛ kɛnaawo lɔkɔ a kĩ baanɛna kamɔnɛ a. Ade lɔkɔ a na maabi kamɔnɛ banɛnanɛ a kĩ bɛnya lɔtɔ bɛbɔlɛ tuwĩ a bisui te fudzu fudzu lɔkɔa bipila te, ke liti bɛkpɔta kamɔnɛ a bifila bɛnaako nɛ yĩ oli kamɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu bɔa be lɛgbã bɛbã kĩ, “Ode lɛgãkanyakɔ̃ a la ndɛ kutse libi kabii kĩ oti odi nadu nɛ ye kɔba kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lɛnyɛ kutse libi kabii flee nɛ kutse babi kamɛ, lɛmɛ ntɛ libo anɛ ni, kɔapɔ lububu kaba futse flee, ade kɔvɔlabi ayakɛna fɔtsɔɛ nɛ koe tɛnanɛ kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu buki ɛbɔa be lɛgbã bɛbã kĩ, “Ode lɛgãkanyakɔ̃ a la ndɛ oyila fɔtsa kĩ otsole odi pɔtɔ edo nɛ mawɛ fɔwɔda kakɔna ɛlalɛ kamɛ kɛnawo kĩ mawɛ a flee vuya.” ");
INSERT INTO bov_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu bi bati kɔdabu a fɔlɛtsa kĩĩ flee nɛ fɔgbã kamɛ, ade yaálɛ fɔlɛtsa fudima ntɛ nnɛ́ nɛ fɔgbã kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɛkɛna fukĩĩ kĩ Baguma onukpɛ̃ ɔnyɛnɛ fɔlɛtsa a fɔya nɛ foe kamɛ kĩ, “Maalɛ kɔdzɛla nɛ fɔgbã kamɛ, ade maanyɛ fɔtsa a kĩ bɛkɔa bɛkɔla kito anɛ katinya kayɔkayi a ntsa a.” ");
INSERT INTO bov_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kĩ Yesu nyɛ bati kɔdabu a osi a, ɛya nɛ kɔla kamɛ ade ye fɔtsa bakɔlɛnɛ a ya nɛ ye sɛkɛ̃ bɛyavia ye kĩ, “Nyɛ lɛgbã a kĩ ɔbɔa nɛ tuwĩ wuluwulu nɛ kamɔnɛ kamɛ a kayɔ katsa boe.” ");
INSERT INTO bov_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kpa mbuayɛ kĩ, “Oti a kĩ edu fudutsa wĩ a nyɛ Otidziwa Obi a. ");
INSERT INTO bov_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɔba a nyɛ katinya kamɛ, fudutsa wĩ a nyɛ bikĩ bɛnyɛ ode lɛgãkanyakɔ̃ a bade, ade tuwĩ a lɛmɛ nyɛ bikĩ bɛnyɛ Okesĩnɛ a bade a. ");
INSERT INTO bov_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Okesĩnɛ a kĩ ɛsã tuwĩ a nyɛ Abonsam. Fudutsa kakpɔta a nyɛ katinya kamɛ kawũna lɔkɔ, ade fudutsa bakpɔtanɛ a nyɛ ode fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ndɛ ayekĩ bakpɔta tuwĩ kapila te a, ade aye fɔ́ana nɛ katinya kawũna lɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Otidziwa Obi a aado ye ode fɔtɔ banyanɛ bɛyaakpɔta be a kĩ bɛfɔ̃ bati kɛna tɔkpa mɔ be a kĩ bɛkɛna tɔkpa a flee bɛnɛmɛna nɛ Baguma lɛgã kanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Baata be bido nɛ fi luwotu kamɛ, ade awã baabe bɛba adɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Baguma bade a kɔ̃ akũ aakpalɛ ndɛ suwa aye nɛ be Ɔlɛga lɛgãkanyakɔ̃ a kamɛ. Oti a kĩ edeĩ sɔtɔ ni, etse! ");
INSERT INTO bov_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ode lɛgã kanyakɔ̃ a la ndɛ akũ kana fɔtsa fudi kĩ bɛkɔa bɛkɔla nɛ kɔba kamɛ. Oti odi nake foe, ɛdani ɛkɔla foe. Ɛmɔ́ kawɔlɛ paa, foesũ ɛnanɔ lɛtsa nyɛ lɛtsa kĩ edeĩ a emuniki ɛnaya kɔba a.” ");
INSERT INTO bov_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu buki ɛlɛ kĩ, “Ode lɛgãkanyakɔ̃ a la ndɛ kɔyaatɔ ɔnyanɛ odi kĩ ɛtsɛ̃ yawɛ fulitsa babi wĩ. ");
INSERT INTO bov_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kĩ ɛnatsɛlamɔ lidi kĩ lideĩ kɔya paa a, ɛnanɔ fɔtsa a kĩ edeĩ a flee ɛkɔa ɛya fulitsa libi a. ");
INSERT INTO bov_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ode lɛgãkanyakɔ̃ a buki lɛla ndɛ asau kĩ bɛta bido nɛ mpo kamɛ bɛnyɛ kɔfɔabi ahɔlɔ ahɔlɔ pii. ");
INSERT INTO bov_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kĩ asau a yi mɔ kɔfɔabi a, bɛvɛlɛ ye bɛyamɛna nɛ mpo abuĩ, bidzi bɛsa kɔfɔabi a kamɛ. Bɛkɔa kɔfɔabi wĩ a biko nɛ fɔwɔda kamɛ ade bɛtalɛ kɔkpa a biwula a. ");
INSERT INTO bov_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ade aye fɔ́ana nɛ katinya kawũna lɔkɔ a. Ode fɔtɔ banyanɛ a aayasa bati kpa bɛnyɛ nɛ bati wĩ kamɛ, ");
INSERT INTO bov_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ade baata be bido nɛ fi luwotu kamɛ, awã kĩ baabe bɛba adɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu via be kĩ, “Minu fɔlɛtsa kĩĩ flee kayɔ?” Bitunɔ kĩ, “Oo.” ");
INSERT INTO bov_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Foesũ ebi be kĩ, “Fukĩĩ atsa kĩ mbla ɔtsanɛ odi nyɛ odi kĩ ɛdani ɛkɛna fɔtsa ɔkɔlɛnɛ nɛ ode lɛgãkanyakɔ̃ a akũ la ndɛ ɔtɔlate odi kĩ yanyɛ fɔtsa vɔɛ̃ mɔ fɔkɔɛ kanya katomɛna ye fɔtsa kakɔlakɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kĩ Yesu bɔa fɔgbã kĩĩ eyua a, ɛdzakũ nɛ awã, ");
INSERT INTO bov_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ɛnaa ye mɔawɛ ɔmatɔ kamɛ, ɛnatsa fɔtsa nɛ be katsɛnakɔ̃ a. Bati a kĩ binu ye fɔtsa katsa a kɛna saa, ade bivia akũ kĩ, “Ndia ɛkɔlɛ kadikanyi kĩĩ etomɛna? Ndia awãwã fɔtsa a lɛmɛ to? ");
INSERT INTO bov_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nnɛ́ ye nyɛ titse fɔtsa ɔmɛnɛ obi a mbɔɛɛ? Nnɛ́ ɔma nyɛ Maria, ade nnɛ́ bawaɛ̃nyole nyɛ Yakobo, Yosef, Simon mɔ Yuda a? ");
INSERT INTO bov_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nnɛ́ bawaɛ̃tsole lɛmɛ deĩ nɛ boe kamɛ nɛ awĩ a? Ndia etomɛna fɔtsa kĩĩ bamɛ flee?” ");
INSERT INTO bov_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ade ɛdani oti kĩ ye akũ ado be kalɔkpa a. Yesu bi be kĩ, “Baguma onukpɛ̃ ɔnyɛnɛ deĩ obu nɛ kakɔ nyɛ kakɔ mbɔɛntɛ nɛ ye mɔawɛ ɔmatɔ mɔ ye kɔla bati kamɛ mɔ ɛlá obu.” ");
INSERT INTO bov_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ayekĩ bɛtátɛ bido sũ ni, Yesu tákɛna awãwã fɔtsa pii nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nɛ lɔkɔ a na kamɛ a, Herodes, Galilea tite akũ ɔnyanɛ a, nu Yesu nkã. ");
INSERT INTO bov_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ebi ye banɔkɔɛ̃ a kĩ, “Yohanes Mui Ɔwɔlanɛ a liyidza eto kanɔkpa edzi nkpã, ade foesũ edeĩ kɔbɛ̃ kĩĩ ɛnɛɛ yakɛna awãwã fɔtsa a.” ");
INSERT INTO bov_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes nya lɔtɔ ɛfɔ̃ bipi Yohanes bisui ye bɛkɔa bido nɛ kɔla. Ɛkɛna fukĩĩ nɛ Herodia, ɔwaɛ̃ Filipo ɔtsɔ̃ sũ. ");
INSERT INTO bov_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Lɛtsa a kĩ lɛya nyɛ kĩ Yohanes Mui Ɔwɔlanɛ a bi Herodes kĩ, “Mose mbla a tákpa osi kĩ akɔã Herodia.” ");
INSERT INTO bov_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Fɔlɛtsa kĩĩ sũ Herodes wɛ kĩ yakɔ Yohanes, lɛmɛ evila Yudafɔ a kitonɛkĩ babu ye ndɛ Baguma onukpɛ̃ ɔnyɛnɛ aye. ");
INSERT INTO bov_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nɛ luwi a kĩ Herodes anya ye lɛmawi a, Herodia obitsole yato nɛ bati a flee anɛ. Ye kuto a lɛ Herodes kadã paa, ");
INSERT INTO bov_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","foesũ ɛlɔ fubo ɛkpa oyitsɔ̃ a kĩ, “Maakpa nɔ lɛtsa nyɛ lɛtsa kĩ aavia yĩ!” ");
INSERT INTO bov_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oyitsɔ̃ a ɔma fɔ̃ ebi Herodes kĩ, “Kɔa Yohanes Mui Ɔwɔlanɛ a lɔlɔ kate nɛ tsensi akũ kakpa yĩ finyaakĩĩ!” ");
INSERT INTO bov_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kalɛ a wo lɛgã a kalɔɛ, lɛmɛ nɛ fubo a kĩ ɛlɔ nɛ obu bati a kĩ ɛvɛ a anɛ sũ ni, ɛkpa osi kĩ bɛkɛna nɛ oyitsɔ̃ a kawɛ akũ. ");
INSERT INTO bov_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Foesũ ɛfɔ̃ bɛnatsua Yohanes lɔlɔ nɛ kɔla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bite oti lɔlɔ a nɛ tsensi akũ bɛyamɛna, ade bɛkɔa bɛkpa oyitsɔ̃ a, ade ye malo ɛkɔa de ɛma ɔma a. ");
INSERT INTO bov_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanes fɔtsa bakɔlɛnɛ a nabɔɛ ɔnɔkpa a bɛnabila, ade bɛnabɔa Yesu amandiɛ a. ");
INSERT INTO bov_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kĩ Yesu nu Yohanes fɔlɛtsa kĩĩ a, ewo nɛ ɔkɔlɔ kamɛ ɛdzaku ɛnaa kakɔ kadi kĩ bati lɛláa. Lɛmɛ bati nu ye nkã, foesũ bɛtsã abɔa bito be tɛmatɔ kamɛ bitomɔ ye liti. ");
INSERT INTO bov_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu nɛ́ nɛ ɔkɔlɔ a kamɛ, ade kĩ ɛmɔ bati kɔdabu a, be akũ kɔ ye kɔnya, ade ɛtsa be kamɛ basɔnɛ a. ");
INSERT INTO bov_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ke olobe a, ye fɔtsa bakɔlɛnɛ a fuã ye, ade bibi ye kĩ, “Kade dɔ kiyua ade awĩ táfuã ɔmatɔ kamɛ a, foesũ fɔnɛ bati a awɛ bɛdzakũ bɛnaa tukula kamɛ bɛnaaya funitsã bɛnya.” ");
INSERT INTO bov_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kpa be mbuayɛ kĩ, “Fɔtásĩ kĩ badzakũ. Mi mɔawɛ a mikpa be litsedi bɛnya!” ");
INSERT INTO bov_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Fɔtsa bakɔlɛnɛ a kpa mbuayɛ kĩ, “Abodoo fɔbɔ elo mɔ kɔfɔabi nviã pɛ bɔnɛɛ nɛ awĩ.” ");
INSERT INTO bov_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ade Yesu bi be kĩ, “Mikɔa foe mima yĩ nɛ awĩ.” ");
INSERT INTO bov_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɛfɔ̃ bati a flee dzi nɛ tuwĩ akũ nɛ awã, ade ɛbɔɛ abodoo elo mɔ kɔfɔabi nviã a, ɛdã ode, ehila foe. Ke liti a, ɛyɛlɛ abodoo a, ɛkɔa ɛkpa ye fɔtsa bakɔlɛnɛ a, ade be bɛsɛ̃ bɛkpa bati a. ");
INSERT INTO bov_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Odi nyɛ odi nya ewĩ. Ke liti a, ye fɔtsa bakɔlɛnɛ a fila fuwuliwa a kĩ fute a biyula tɛtsɛtsɛ ewua-nviã. ");
INSERT INTO bov_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bati a kĩ bɛnya funitsã a lidede aawo banyole mpim elo, kĩ bɛtákã batsole mɔ babisɛ̃ bido nɛ be kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu fɔ̃ ye fɔtsa bakɔlɛnɛ a wo nɛ ɔkɔlɔ kamɛ kĩ binyina bɛnaa ɔwɔ lutubu baũ sɛkɛ sitide a, lɔkɔa ɛnyɛ bati a osi. ");
INSERT INTO bov_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kĩ ɛnyɛ bati a osi eyua a, ede ɛnaa ɔtɔ akũ ye odi kĩ yanaabɔa mpaɛ. Kĩ kade dɔ a Yesu odi lite nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nɛ lɔkɔ a na kamɛ a, ɔkɔlɔ a naa mɔ lugo flee ade mpo akũ ɔwɛ kabɔa ye kato katɛ̃mɛna, kitonɛkĩ ɔwɛ mɔ ɔsĩ kavũ katsɛlamɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Odenyinawi tɔdɔũ ɛlalɛ kamɛ a, Yesu tsɛ̃ nɛ mui anɛ yaya nɛ ye fɔtsa bakɔlɛnɛ a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kĩ bɛmɔ́ ye ɛtsɛ̃ nɛ mui anɛ a, fute bɔɛ be bɛlɛ kĩ, “Ɔnɔkpa yanɛ!” ade bɛbɔa fɔwɔla kɔɔba mɔ libe a. ");
INSERT INTO bov_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Deedimɔapɛ Yesu lɛmɔ be kɔdzɛla kĩ, “Mi ɔwɔlɛ ɛka edzi. Yĩ manɛ. Mitavila!” ");
INSERT INTO bov_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ade Petro lɛ kĩ, “Boe Ɔlate, ntɛ nuwĩ nɔ anɛ ni, fɔ̃ ntsã mui a anɛ ĩya nɛ nɔ sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu bi ye kĩ, “Ya!” Ade Petro nɛ́ nɛ ɔkɔlɔ a kamɛ ɛtsã mui anɛ yanaa Yesu sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lɛmɛ kĩ ɛmɔ́ ayekĩ ɔwɛ lamɔ kavũ kɔɔba a, libe wo ye ade edo kayɛla awɛ nɛ mui a kamɛ a. Adeke ɛbɔa fɔwɔla kĩ, “Boe Ɔlate, tɛ yĩ!” ");
INSERT INTO bov_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Deedimɔapɛ Yesu yo awɛ epi ye nɛ kɔkpɔ, ɛlɛ kĩ, “Nɔ katɛkado adã kabii. Nde sũ ɔtɛ atsindze?” ");
INSERT INTO bov_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kĩ be nviã a biwo nɛ ɔkɔlɔ a kamɛ a ɔwɛ a fɔ̃ kavũ. ");
INSERT INTO bov_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Fɔtsa bakɔlɛnɛ nɛ ɔkɔlɔ a kamɛ a ke aduli bisum Yesu, ade bɛlɛ kĩ, “Nuwĩnuwĩ Baguma Obi anɛ!” ");
INSERT INTO bov_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kĩ binyina ɔwɔ lutubu baũ a, bɛyaduma nɛ Genezaret tite akũ. ");
INSERT INTO bov_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Awã bati mɔ́ Yesu biyi ɔsũ, foesũ bɛnakpã basɔnɛ nɛ kayite a flee bɛyamɛna nɛ ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bike ye aduli kĩ efɔ̃ basɔnɛ a bɛta ye atadiɛ atɔ odi pɛ. Ade bati a kĩ bɛta ye a flee akũ de ɔsĩ a. ");
INSERT INTO bov_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ade Farisifɔ mɔ mbla batsanɛ badi to Yerusalem bɛya nɛ Yesu sɛkɛ̃ bivia ye kĩ, ");
INSERT INTO bov_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nde sũ nɔ fɔtsa bakɔlɛnɛ a lákɛna nɛ fɔtsa katsa a kĩ boe bawanyɔ kɔa biyi boe a akũ? Baávɔlɛ awɛ nɛ osi wĩ akũ fɔmɔ banya!” ");
INSERT INTO bov_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu lɛmɛ via be kĩ, “Nde sũ mi malo miafum Baguma mbla mɔ miakɛna nɛ miawɛ fɔtsa katsa a akũ? ");
INSERT INTO bov_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mbɔɛɛ Baguma tálɛ kĩ, ‘Bu aga mɔ ama,’ ebuki ɛlɛ kĩ, ‘Odi nyɛ odi kĩ edumu ɔlɛga ĩye ɔma ni, kɛnɛ kĩ bɛkɔ ye’? ");
INSERT INTO bov_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lɛmɛ mi kɔ̃ miatsa fɔtsa kĩ ntɛ odi deĩ fɔtsa fudi kĩ yaapuli ɛkɔa ebumɔ ɔlɛga ĩye ɔma, mɔ ɛlɛ kĩ, ‘Nkɔa foe nkpa Baguma’ ni, ");
INSERT INTO bov_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","fɔtábuki fusĩ kĩ oti a abu ɔlɛga ĩye ɔma. Nɛ osi kĩĩ akũ mitábu Baguma mbla ayekĩ míatomɔ mi bawanyɔ fɔtsa katsa a sũ. ");
INSERT INTO bov_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Fɔlɛtsa a kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ nɛ mi akũ a ya nɛ foe kamɛ nuwĩ. ");
INSERT INTO bov_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Baguma lɛ kĩ, ‘Ɔmaĩ kĩĩ asum yĩ mɔ onukpɛ̃ kamɛ fɔlɛtsa mɛnɛmɛnɛ, lɛmɛ be tɔwɔlɛ deĩ mɔ lugo nɛ yĩ sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pupulidza basum yĩ, kitonɛkĩ batidziwa mbla batsa nɛ Baguma mbla a kadokɔ̃!’ ” ");
INSERT INTO bov_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ade Yesu vɛ bati kɔdabu a ɛkpɔta nɛ ye sɛkɛ̃ ebi be kĩ, “Mitse lɔkɔa minu fɔlɛtsa kayɔ! ");
INSERT INTO bov_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nnɛ́ lɛtsa kĩ lawo nɛ oti onukpɛ̃ kamɛ a ado ye efĩĩ, mbom lɛtsa a kĩ lanɛ kato ye onukpɛ̃ kamɛ a, ado ye efĩĩ.” ");
INSERT INTO bov_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Adeke ye fɔtsa bakɔlɛnɛ a ya nɛ ye sɛkɛ̃ bɛyabi ye kĩ, “Onyina kĩ fɔlɛtsa a kĩ ɔlɛ a wo Farisifɔ a kalɔɛ?” ");
INSERT INTO bov_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kpa be mbuayɛ kĩ, “Kutse nyɛ kutse kĩ nnɛ́ Nda nɛ ode lidu ni, baabɔlɛ koe bimuni. ");
INSERT INTO bov_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Foesũ mifɔnɛ be awɛ. Bɛnyɛ banɛkunɛ kĩ bakpã banɛkunɛ, ade ntɛ ɔnɛkunɛ akpã ɔnɛkunɛ ni, be nviã a flee baatɔ nɛ lɛkɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro bi ye kĩ, “Nyɛ lɛgbã kĩĩ kayɔ katsa boe.” ");
INSERT INTO bov_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu bi be kĩ, “Mbɔɛɛ mi malo bati kĩ baánu fɔlɛtsa kayɔ mibuki mianɛ? ");
INSERT INTO bov_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mitánu foe kayɔ kĩ lɛtsa nyɛ lɛtsa kĩ lawo nɛ oti onukpɛ̃ kamɛ a kanaa ye lupu kamɛ, ke liti yanaanyɛ nɛ kɔbɔa kayo kamɛ? ");
INSERT INTO bov_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lɛmɛ fɔtsa a kĩ fɔanɛ kato oti onukpɛ̃ a, ato ye ɔwɔlɛ kamɛ ade foe ado oti efĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kitonɛkĩ oti ɔwɔlɛ kamɛ adzuni kpa, oti kakɔ, adɔpaa kabɔa, bayitsɔ̃ mɔ bapopo kawa katɛ̃, kaye, fɔvã adansiɛ kadi, mɔ bati buĩ kanyɛ anɛ kato. ");
INSERT INTO bov_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ade fɔtsa kĩĩ bamɛ ado oti efĩĩ a, lɛmɛ kĩ ɔkɔa awɛ kĩ ɔtávɔlɛ anya ndɛ ayekĩ Farisifɔ atsa a, ládo oti efĩĩ.” ");
INSERT INTO bov_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu dzakũ nɛ awã ɛnaa kayite a kĩ kifuã Tiro mɔ Sidon tɛmatɔ kpale a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Awã naa, Kanan otsole odi kĩ edzi nɛ kayite a na ya nɛ Yesu sɛkɛ̃ mɔ fɔwɔla kĩ, “Boe Ɔlate, Dawid Obi, mɔ yĩ kɔnya! Yĩ obitsole lamɛna lubo kamɔ mɔ ɔsĩ mɔ ɔsĩ nɛ hũhũ kpa awɛ kamɛ!” ");
INSERT INTO bov_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lɛmɛ Yesu tálɛ kadima. Ye fɔtsa bakɔlɛnɛ a nake ye aduli bɛlɛ kĩ, “Blɔmɛna ye ɛdzakũ, kitonɛkĩ etomɔ boe mɔ fɔwɔla!” ");
INSERT INTO bov_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kpa mbuayɛ kĩ, “Baveli a kĩ bɛyɛla nɛ Israelfɔ kamɛ odi sɛkɛ̃ bido yĩ.” ");
INSERT INTO bov_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lɛmɛ otsole a yatɔ nɛ Yesu abɔa kamɛ ɛlɛ kĩ, “Boe Ɔlate, bumɔ yĩ!” ");
INSERT INTO bov_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kpa ye mbuayɛ kĩ, “Fɔnɛ́nɛ kĩ bata babisɛ̃ funitsã biko bakpete.” ");
INSERT INTO bov_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Otsole a kpa mbuayɛ kĩ, “Boe Ɔlate, fudeĩ lɔmɔ kɔ̃, lɛmɛ bakpete a malo anya funitsã wuliwa a kĩ futo be ɔlate opunu akũ fɔtɔ a.” ");
INSERT INTO bov_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kĩ Yesu nu foe a, ɛkpa ye mbuayɛ kĩ, “O, boe ɔma, nɔ katɛkado pɔnɛ! Lɛtsa a kĩ awɛ a lɛya lɛkpa nɔ.” Nɛ lɔkɔ a na kamɛ pɛpɛɛpɛ a obitsole a akũ de ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu dzakũ nɛ awã ɛtsã Galilea ɔwɔ lutubu baũ a abuĩ. Ede ɛnaa katɔbii kadi akũ ade ɛkɛna akũ edzi a. ");
INSERT INTO bov_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ade bati kɔdabu baũ kpã abafã amɛ, banɛkunɛ, bamumu, mɔ basɔnɛ bɛbã pii bɛyamɛna nɛ ye sɛkɛ̃ a. Bɛkɔa be biko nɛ ye anɛ kamɛ ade ɛtsa be a. ");
INSERT INTO bov_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kĩ bati kɔdabu a mɔ́ kĩ bamumu kalɛ kɔdzɛla, abafã amɛ kayidza katsã, bikĩ bɛnɛ lɛkpɛ̃ akũ dani fuyo, banɛkunɛ kamɔ fɔkɔ a, fɔkɛna be wãwã, ade bimu Israel Baguma a. ");
INSERT INTO bov_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu vɛ ye fɔtsa bakɔlɛnɛ a bɛya nɛ ye sɛkɛ̃ ade ebi be kĩ, “Bati kĩĩ akũ akɔ yĩ kɔnya, kitonɛkĩ bɛna nɛ yĩ sɛkɛ̃ fuwi ɛlalɛ flee, lɛmɛ bɛlá lɛtsama kĩ banya. Ntáwɛ kĩ manyɛ be osi bɛnaa mɔ kɔlɛ, anɛ lɛnaasinya be nɛ osi.” ");
INSERT INTO bov_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ye fɔtsa bakɔlɛnɛ a via ye kĩ, “Nɛ ndia bɔ́ana funitsã nɛ kɔsa kamɛ nɛ awĩ kĩ fɔ́ato bati kɔdabu kĩĩ odu bɛnya?” ");
INSERT INTO bov_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu via be kĩ, “Abodoo eni minɛɛ?” Bibi ye kĩ, “Abodoo evũkɔnɔ mɔ kɔfɔabi wuluwulu sukuloo deĩ.” ");
INSERT INTO bov_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ade Yesu fɔ̃ bati kɔdabu a kɛna akũ bidzi nɛ tite a. ");
INSERT INTO bov_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ade kĩ ɛbɔɛ abodoo evũkɔnɔ mɔ kɔfɔabi a ɛnyɛ Baguma kɔlɛ a, ebulibuli ye mɔ koe ɛkɔa ɛkpa ye fɔtsa bakɔlɛnɛ a, ade be malo bɛsɛ̃ bɛkpa bati a. ");
INSERT INTO bov_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Be flee bɛnya biwĩ. Kĩ fɔtsa bakɔlɛnɛ a fila fuwuliwa a kĩ fute a, fuyi tɛtsɛtsɛ evũkɔnɔ. ");
INSERT INTO bov_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bati a kĩ bɛnya funitsã a nyɛ banyole mpim ɛna, kĩ bɛtákã batsole mɔ babisɛ̃ bibu. ");
INSERT INTO bov_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ke liti a, Yesu nyɛ bati a osi ade edzi ɔkɔlɔ ɛnaa Magadan amantam kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisifɔ mɔ Zadukifɔ badi kĩ bɛya nɛ Yesu sɛkɛ̃ a wɛ kĩ basɔ ye bɛdã, foesũ bivia ye kĩ ɛkɛna awãwã fɔtsa kĩ futo ode ɛtsa be. ");
INSERT INTO bov_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lɛmɛ Yesu kpa mbuayɛ kĩ, “Ntɛ suwa anaa katomukɔ̃ a, mialɛ kĩ, ‘Fɔkɔ aakpalɛ kunya, kitonɛkĩ odetɔ́ kamɛ yɔɔlɛ.’ ");
INSERT INTO bov_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ade ayea ɔnɔnɛ lɛmɛ mialɛ kĩ, ‘Nviã oni aako kitonɛkĩ odetɔ́ kamɛ yɔɔlɛ fɔkɔ lɛmɛ kɛna tũũ.’ Miayi anɛ kadã odetɔ́ kamɛ kapuli kalɛ ayekĩ fɔkɔ aana, lɛmɛ miápuli minyi nviã nsɛntsɛlɛni a kĩ yaaya a kayɔ. ");
INSERT INTO bov_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nviã babi kpa kĩ binyína Baguma! Miavia yĩ awãwã fɔtsa? Oowo! Bɛláakpa mi awãwã fɔtsa fudima kɛba Yona fude a.” Ade ke ɛdzakũ ɛfɔnɛ be a. ");
INSERT INTO bov_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kĩ fɔtsa bakɔlɛnɛ a nyina ɔwɔ lutubu baũ bɛnaa sɛkɛ sitide a, bɛyate anɛ kĩ bɛtábɔɛ abodoo adima bɛlɛ. ");
INSERT INTO bov_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu bi be kĩ, “Mite anɛ, midã kadã wĩ nɛ Farisifɔ mɔ Zadukifɔ fuyilatsa a akũ.” ");
INSERT INTO bov_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ade bido kalɛ nɛ be nɛɛnɛɛ kamɛ kĩ, “Ayekĩ bɔtábɔɛ abodoo adima bɔlɛ sũ mɔ ɛlɛ foe.” ");
INSERT INTO bov_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu nyi lɛtsa a kĩ bɛkalɛ a foesũ evia be kĩ, “Nde sũ mialɔmɛna nɛ abodoo katabɔɛ akũ? Mi katɛkado adã kabii! ");
INSERT INTO bov_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Foesũ mitámɔ miyi ɔsũ tɔ̃? Mitáte anɛ kĩ nsɛ̃ abodoo elo nkpa bati mpim elo bɛnya a? Tɛtsɛtsɛ eni kamɛ mifila fuwuliwa a miyula? ");
INSERT INTO bov_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Litsa mialɛ nɛ abodoo evũkɔnɔ a kĩ nsɛ̃ nkpa banyole mpim ɛna bɛnya a akũ? Tɛtsɛtsɛ eni kamɛ miko fukĩ fute a? ");
INSERT INTO bov_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nde sũ mɔ miámɔ kĩ nnɛ́ abodoo fɔlɛtsa nlamɛna mi kabi? Midã kadã wĩ nɛ Farisifɔ mɔ Zadukifɔ fuyilatsa akũ!” ");
INSERT INTO bov_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ade finyaa fɔmɔ fɔtsa bakɔlɛnɛ a yanu foe kayɔ kĩ nnɛ́ fuyilatsa a kĩ bakɔa kado nɛ mawɛ kamɛ a akũ yadɛ be, mbom kadɛ ɛdɛ be nɛ Farisifɔ mɔ Zadukifɔ fɔtsa katsa a akũ. ");
INSERT INTO bov_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kĩ Yesu wo kakɔ a kĩ kifuã Kaisarea Filipi ɔmatɔ a, evia ye fɔtsa bakɔlɛnɛ a kĩ, “Owei bati alɛ kĩ Otidziwa Obi a anɛ?” ");
INSERT INTO bov_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bɛkpa mbuayɛ kĩ, “Badi alɛ kĩ Yohanes Mui Ɔwɔlanɛ a anɛ. Babɛbã alɛ kĩ Eliya, ade badi lɛmɛ alɛ kĩ Yeremia ĩye Baguma onukpɛ̃ banyɛnɛ a kamɛ ɔmɔa anɛ.” ");
INSERT INTO bov_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu via be kĩ, “Adeke mi malo, owei mialɛ kĩ ye manɛ?” ");
INSERT INTO bov_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ade Simon Petro kpa mbuayɛ kĩ, “Nɔ nyɛ Kristo a, Baguma kĩ edzi nkpã a Obi.” ");
INSERT INTO bov_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu bi ye kĩ, “Simon, Yona obi, Baguma hila nɔ, kitonɛkĩ nnɛ́ otidziwa odima lɛtsa nɔ foe, mbom Nda nɛ ode a lɛnyɛ foe ɛtsa nɔ. ");
INSERT INTO bov_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nɛ foesũ, Petro, mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ nɔ dĩ kayɔ nyɛ de mɔ ɔsĩ a, ade de kĩĩ akũ maayi yĩ asɔli a. Wuda malo lɛláapuli ɛnya ye akũ da. ");
INSERT INTO bov_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Maakɔa ode lɛgãkanyakɔ̃ a tɛsafi ndo nɔ nɛ awɛ. Lɛtsa nyɛ lɛtsa kĩ osĩ nɛ tite akũ ni, baasĩ foe nɛ ode, ade lɛtsa nyɛ lɛtsa kĩ ɔkpa osi nɛ tite akũ ni, baakpa de osi nɛ ode.” ");
INSERT INTO bov_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Adeke Yesu si ye fɔtsa bakɔlɛnɛ a mbla kĩ bɛtabi odima kĩ ye nyɛ Kristo a. ");
INSERT INTO bov_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kito luwi a, Yesu do ye fɔtsa bakɔlɛnɛ a kabi awɛ pefee kĩ, “Kɛnɛ kĩ nnaa Yerusalem, nnaamɔ lubo paa nɛ banɔkɔɛ̃, basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a awɛ. Baakɔ yĩ, lɛmɛ nɛ luwi lɛlalɛde akũ ni, Baguma aadzɛla yĩ ndzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petro kpã Yesu bɛnaadza nɛ ɔɔwɛ̃, ade edo ye anɛ kakã awɛ ɛlɛ kĩ, “Boe Ɔlate, Baguma esua foe osi. Fukĩnaa lɛláaya nɛ nɔ akũ da!” ");
INSERT INTO bov_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu dani ɛtsɛlamɔ Petro ebi ye kĩ, “Satana, dzakũ nɛ yĩ akũ! Ɔnyɛ lɛtsa a kĩ lasua yĩ osi kitonɛkĩ nɔ kakɔna táto Baguma sɛkɛ̃ mbom futo otidziwa sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ade Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Ntɛ odi wɛ kĩ yatomɔ yĩ ni, ɛtatsɛla ye mɔawɛ akũ lɔkɔa ɛbɔɛ ye asendua etomɔ yĩ. ");
INSERT INTO bov_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kitonɛkĩ odi nyɛ odi kĩ yawɛ kĩ yapili ye nkpã ni, yaayɛla ye, lɛmɛ odi nyɛ odi kĩ ɛyɛla ye nkpã nɛ yĩ sũ ni, yaana ye. ");
INSERT INTO bov_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ntɛ katinya kamɛ fɔtsa flee dani odi fude mɔ ɛyɛla ye nkpã ni, litsa nfasɔ yaana? Mbɔɛɛ litsedi deĩ kĩ oti aakɔa ɛvɛmɛna mɔ ye nkpã? ");
INSERT INTO bov_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kitonɛkĩ Otidziwa Obi a aaya nɛ Ɔlɛga kukũkpalɛ kamɛ mɔ ye ode fɔtɔ banyanɛ, lɔkɔa yaase odi nyɛ odi kɔtɔ nɛ ayekĩ edzi nkpã a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mabi mi pipiipi kĩ badi deĩ nɛ mi kamɛ nɛ awĩ kĩ bɛláaku kɛnaawo kĩ bɛmɔ́ Otidziwa Obi a kĩ ɛya ndɛ Lɛgã aye.” ");
INSERT INTO bov_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nɛ fuwi evũ liti a, Yesu kpã Petro, Yakobo mɔ ɔwaɛ̃ Yohanes bide bɛnaa ɔtɔ geĩ odi kalete, awã kĩ be odi bɛnadzi. ");
INSERT INTO bov_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kĩ bɛkadã ye a, Yesu akũ dani nɛ be anɛ kamɛ. Ye anɛ kamɛ kata ndɛ suwa aye, ade ye tɛtadiɛ lɛmɛ kɛna fitaa ndɛ ɔhaĩ aye a. ");
INSERT INTO bov_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Adeke fɔtsa bakɔlɛnɛ ɛlalɛ a mɔ́ Mose mɔ Eliya kĩ bɛkalɛ kɔdzɛla mɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Foesũ Petro dzɛla odo ebi Yesu kĩ, “Boe Ɔlate, fɔnɛnɛ paa kĩ budeĩ nɛ awĩ! Ntɛ awɛ ni, maabɔa fɔpɛ ɛlalɛ nɛ awĩ, nɔ lide lɔmɔa, Mose lide lɔmɔa lɔkɔa Eliya lɛmɛ lide lɔmɔa.” ");
INSERT INTO bov_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kĩ ɛkalɛ kɔdzɛla a, luflututu fitaa ka lɛtsa be, ade odo nɛ́ eto de kamɛ ɛlɛ kĩ, “Ade yĩ Obi kĩ maátunɔ ye kalɛ a, yawo yĩ anɛ. Mitse ye!” ");
INSERT INTO bov_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kĩ fɔtsa bakɔlɛnɛ a nu odo a libe wo be paa, foesũ bɛka bɛtsa anɛ nɛ tite. ");
INSERT INTO bov_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ya nɛ be sɛkɛ̃ ɛkɔa awɛ ɛta be, ade ebi be kĩ, “Miyidza! Mitavila!” ");
INSERT INTO bov_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Foesũ bɛdzɛla anɛ nɛ ode, lɛmɛ bɛtámɔ odima nɛ awã kɛba Yesu. ");
INSERT INTO bov_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kĩ bɛka ɔtɔ a baya a, Yesu si be mbla kĩ, “Mitabi odima lɛtsa a kĩ bɛnyɛ bɛtsa mi nɛ awĩ a, kɛnaawo kĩ bɛdzɛla Otidziwa Obi a bitomɛna kanɔkpa.” ");
INSERT INTO bov_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Adeke fɔtsa bakɔlɛnɛ a via Yesu kĩ, “Nde sũ mbla batsanɛ a alɛ kĩ kɛnɛ kĩ Eliya ɛnya lɔtɔ ɛya?” ");
INSERT INTO bov_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kpa be mbuayɛ kĩ, “Ɔnɔkɔali fɔanɛ kĩ Eliya ɛnya lɔtɔ ɛya, ɛyaalɔla lɛtsa nyɛ lɛtsa eyi. ");
INSERT INTO bov_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mabi mi kĩ Eliya ya kɔkɔɛ lɛmɛ bati támɔ ye biyi ɔsũ, foesũ bɛkɛna lɛtsa a kĩ bawɛ nɛ ye akũ. Ade ayea baakɛna Otidziwa Obi a lɛmɛ awɔda a.” ");
INSERT INTO bov_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ade awã mɔ fɔtsa bakɔlɛnɛ a nu foe kayɔ kĩ Yohanes Mui Ɔwɔlanɛ a akũ kɔdzɛla ɛkalɛ. ");
INSERT INTO bov_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ a muniki bɛya nɛ bati kɔdabu a sɛkɛ̃ a, onyole odi ya nɛ Yesu sɛkɛ̃ ɛyake aduli nɛ ye anɛ, ");
INSERT INTO bov_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ade ɛlɛ kĩ, “Boe Ɔlate, mɔ yĩ obinyole kɔnya! Odetɔ́ fɔsɔ deĩ nɛ ye akũ fɔamɔna ye lubo mɔ ɔsĩ mɔ ɔsĩ. Fɔfɔ̃ yawɛ katɔ nɛ fi ĩye mui kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nkpã ye mma nɔ fɔtsa bakɔlɛnɛ a lɛmɛ bɛtápuli bɛtsa ye.” ");
INSERT INTO bov_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kpa mbuayɛ kĩ, “O mi nviã babi kpa kĩ milá katɛkado. Mbɔɛɛ maana nɛ mi sɛkɛ̃ daa? Lɔkɔ lɔɔdabe kamɛ maana ɔwɔlɛ nvɛlɛ mi nnaawo? Mikpã kanyolebi a mima yĩ nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Adeke Yesu wũni nɛ hũhũ kpa a akũ mɔ ɛnɛ nɛ kanyolebi a kamɛ, ade kɛna akũ ɔsĩ nɛ lɔkɔ mɔapɛ a na kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ke liti a, ye fɔtsa bakɔlɛnɛ a ya nɛ ye sɛkɛ̃ nɛ kabɛla kamɛ bivia ye kĩ, “Nde sũ boe kɔ̃ bɔtápuli bɔblɔmɛna hũhũ kpa a bɔnɛmɛna?” ");
INSERT INTO bov_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kpa be mbuayɛ kĩ, “Kitonɛkĩ mi katɛkado lɛpɔ́nɛ. Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ntɛ mideĩ katɛkado ndɛ kutse libi kabii ni, míapuli mibi ɔtɔ kĩĩ kĩ, ‘Bɔlɛ nɛ awĩ kanaa akĩĩ,’ ade yaabɔlɛ a. Lɛtsama lɛláa kĩ miláapuli mikɛna. ");
INSERT INTO bov_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lɛmɛ hũhũ kpa kĩĩ odu lɛláanɛ mbɔɛntɛ fɔtsɛ̃ mpaɛbɔ mɔ, onukpɛ̃ kasui kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kĩ fɔtsa bakɔlɛnɛ a flee yakpɔta nɛ Galilea a, Yesu bi be kĩ, “Baakɔa Otidziwa Obi a bido nɛ bati awɛ. ");
INSERT INTO bov_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Baakɔ ye, lɛmɛ nɛ luwi lɛlalɛde akũ a, Baguma aadzɛla ye edzi nkpã.” Nɛ foesũ fɔtsa bakɔlɛnɛ a wo ɔblɔ paa. ");
INSERT INTO bov_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ a wo Kapernaum a, bikĩ batɛ Asɔli Kɔla ɔgɔlɛ a ya nɛ Petro sɛkɛ̃ bivia ye kĩ, “Mi fɔtsa ɔtsanɛ a ase Asɔli Kɔla ɔgɔlɛ?” ");
INSERT INTO bov_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro kpa mbuayɛ kĩ, “Oo, yase.” Kĩ Petro wo ɛnaa tɔtɔ kamɛ a, Yesu nya lɔtɔ evia ye kĩ, “Simon, litsa nyɛ nɔ adzuni? Baáde ase dutɛ ĩye tɔgɔlɛ kakpa katinya kamɛ fɔgã? Kade a bati ase mbɔɛɛ kĩ banɔvɔɛ̃?” ");
INSERT INTO bov_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro kpa mbuayɛ kĩ, “Banɔvɔɛ̃ a.” Ade Yesu kpa mbuayɛ kĩ, “Kekɔ̃ fɔatsa kĩ kade bati a wɛya. ");
INSERT INTO bov_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lɛmɛ bɔáwɛ kĩ bɔafum bati kĩĩ, foesũ naata dalɛwa nɛ ɔwɔ lutubu baũ a kamɛ. Kafɔabi katɔnyade a kĩ aanyɛ a ni, daɛ ke onukpɛ̃, aamɔ sika ovoe kĩ saato bɔmɔ nɔ Asɔli Kɔla ɔgɔlɛ kase. Kɔa se kanaase be bɔmɔ nɔ tɔgɔlɛ.” ");
INSERT INTO bov_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nɛ lɔkɔ a na kamɛ a, fɔtsa bakɔlɛnɛ a ya nɛ Yesu sɛkɛ̃, bivia ye kĩ, “Owei bɛ̃ flee nɛ ode lɛgãkanyakɔ̃ a kamɛ?” ");
INSERT INTO bov_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nɛ foesũ Yesu vɛ kabisɛ̃ɛ̃ kadi ɛyadzɛla nɛ be kayite, ");
INSERT INTO bov_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ade ebi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ntɛ mitádani mikɛna ndɛ babisɛ̃ aye ni, miláapuli miwo nɛ ode lɛgãkanyakɔ̃ a kamɛ da. ");
INSERT INTO bov_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Oti kĩ ɛbɛ̃ flee nɛ ode lɛgãkanyakɔ̃ a nyɛ oti a kĩ ɛdɔla ye akũ, ɛdani ɛkɛna ndɛ obisɛ̃ kĩĩ aye. ");
INSERT INTO bov_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Odi nyɛ odi kĩ yaakɛna sɛmɛ kalɛ ɛkpa obisɛ̃ kĩĩ odu nɛ yĩ dĩ akũ ni, yĩ ɛkɛna ɛkpa. ");
INSERT INTO bov_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ntɛ oti odi aakpã babisɛ̃ kĩĩ, kĩ bɛtɛ yĩ bido a kamɛ ɔmɔa edo nɛ tɔkpa kamɛ ni, fɔnɛnɛ fɔkpa ye fɔbɛ̃ kĩ bɛkɔa kɔwɔlɛ kpale bɛvɛla nɛ ye sɔmɔ bɛta bido nɛ mpo kamɛ ɛmɔa mui eku. ");
INSERT INTO bov_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Bɔbɔɛ makpa katinya kamɛ bati nɛ fɔtsa a kĩ foe avɛlɛ oti kado nɛ tɔkpa kamɛ a akũ. Kɛnɛ kĩ sɔhuiɛ kĩĩ odu ɛya kokooko, lɛmɛ bɔbɔɛ makpa oti a kĩ ye akũ fɔ́atsã fɔya! ");
INSERT INTO bov_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Foesũ ntɛ nɔ awɛ ĩye nɔ kɔbɔa aafɔ̃ ɔkɛna tɔkpa ni, tsua koe kata kamuni! Fɔnɛnɛ fɔkpa nɔ kĩ aana nkpã mɔ awɛ mɔa ĩye kɔbɔa mɔa, kɛba kĩ aana akpɔ mɔ abɔa lɛmɛ bɛta nɔ bido nɛ fi a kĩ fɔádĩ da a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ade ayea ntɛ nɔ linebi aafɔ̃ ɔkɛna tɔkpa ni, bɔlɛ de kanyɛ kata kamuni! Fɔnɛnɛ fɔbɛ̃ kĩ aana linebi mɔa odzi nkpã, kɛba kĩ aana banebi nviã lɛmɛ bɛta nɔ bido nɛ fi a kĩ fɔádĩ da a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Midã kadã wĩ, ayekĩ miláasupa babisɛ̃ kĩĩ kamɛ odima. Mabi mi nɛ ɔnɔkɔali kamɛ kĩ be ode fɔtɔ banyanɛ nɛ ode adza nɛ Nda anɛ kamɛ luwi daa, ");
INSERT INTO bov_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","kitonɛkĩ Otidziwa Obi a ya kĩ yaatɛ bikĩ bɛyɛla a bɛna nkpã. ");
INSERT INTO bov_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mikɔna fukĩĩ akũ midã. Ntɛ odi deĩ baveli ɔha mɔ kɔmɔa yɛla nɛ be kamɛ a, yaáfɔnɛ be aduekrɔũ-evedi a nɛ katɔbii akũ bɛkadɛ, ɛnaatsã ɛwɛ kɔmɔa a kĩ kɔyɛla a? ");
INSERT INTO bov_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ntɛ ɛmɔ́ koe ni, yamɔ kawɔlɛ paa nɛ kɔmɔa a akũ kaba be aduekrɔũ evedi a kĩ bɛtáyɛla a. ");
INSERT INTO bov_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ade ayea mi Ɔlɛga nɛ ode a láwɛ kĩ babisɛ̃ kĩĩ kamɛ odima ɛyɛla a. ");
INSERT INTO bov_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ntɛ awaɛ̃ fum nɔ ni, naa ye sɛkɛ̃ kanaanyɛ ye mfumsu katsa ye, lɛmɛ kɛna foe nɛ kabɛla kamɛ nɛ mimɔ ye odi kayite. Ntɛ enu foe kayɔ ɛkpa nɔ ni, ɔdani ɔtɛ awaɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lɛmɛ ntɛ ɛtánu ye akũ kayɔ ni, kpã oti mɔa ĩye bati nviã kabumɔ nɔ akũ minaa ye sɛkɛ̃, ayekĩ fɔlɛtsa a flee aanɛ fɔwa nɛ adansifɔ anɛ. ");
INSERT INTO bov_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lɛmɛ ntɛ esĩ ɛtátse be malo ni, kɔa fɔlɛtsa a kama asɔli a, ade ntɛ ɛtátse asɔli bati a lɛmɛ ni, bu ye ndɛ ɔmamuni ĩye ɔgɔlɛ ɔtɛnɛ aye. ");
INSERT INTO bov_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Foesũ mabi mi flee kĩ lɛtsa nyɛ lɛtsa kĩ mitákpa osi nɛ tite akũ ni, bɛláakpa de osi nɛ ode, ade lɛtsa nyɛ lɛtsa kĩ míakpa osi nɛ tite akũ ni, baakpa de osi nɛ ode. ");
INSERT INTO bov_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mabi mi mbu kĩ ntɛ mi kamɛ bati nviã mikɛna ɔmɔa nɛ litsedi akũ nɛ tite akũ, mɔ mibɔa mpaɛ mivia de ni, Nda nɛ ode a aakɛna foe ɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kitonɛkĩ awã kĩ bati nviã ĩye be ɛlalɛ tsɛna nɛ yĩ dĩ akũ ni, ndeĩ nɛ be kayite.” ");
INSERT INTO bov_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ke liti a, Petro yavia Yesu kĩ, “Boe Ɔlate, ntɛ nwaɛ̃ dzɛmɛna tɔkpa kakɛna nɛ yĩ akũ ni, titi eni kɛnɛ kĩ nkɔa nte ye? Titi evũkɔnɔ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kpa ye mbuayɛ kĩ, “Oowo, nnɛ́ titi evũkɔnɔ, mbom aduesɔũ titi evũkɔnɔ. ");
INSERT INTO bov_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kitonɛkĩ ode lɛgãkanyakɔ̃ a la ndɛ lɛgã lidi kĩ lɛwɛ kĩ lakɛna akunta mɔ de basumunɛ. ");
INSERT INTO bov_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kĩ esila eyi kayɔ a, bɛkpã be kamɛ ɔmɔa kĩ edzimɔ ye sika mpim mpim kɔtɔ bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɔsumunɛ a lɛlá sika kĩ yaase kɔtɔ a, foesũ lɛgã a kpa kɔbɛ̃ kĩ bɛnɔ ye mɔawɛ a ndɛ ɔsate, ye ɔtsɔ̃ mɔ babi, mɔ lɛtsa nyɛ lɛtsa kĩ edeĩ a bɛkɔa bise kɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ɔsumunɛ a ke aduli nɛ lɛgã a anɛ eke ye aduli kĩ, ‘Na ɔwɔlɛ bɔɛɛ kakpa yĩ. Maase nɔ se flee.’ ");
INSERT INTO bov_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ye akũ kɔ lɛgã a kɔnya foesũ ɛfɔnɛ ye awɛ ade ɛkɔa kɔtɔ a kĩ edzimɛna a flee ete ye a. ");
INSERT INTO bov_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ade kĩ ɔsumunɛ kĩĩ nɛ́ ɛdzakũ a, ɛnamɔ ɔkɔba ɔsumunɛ bɛbã odi kĩ edzimɔ ye sika ovoe ɔha mɔa kɔtɔ. Epi ɔkɔba a nɛ sɔmɔ ɛmɛnana ye odomɛna kɔɔba, ebi ye kĩ, ‘Se yĩ kɔtɔ a kĩ odzimɔ yĩ a!’ ");
INSERT INTO bov_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ɔkɔba a tɔ nɛ ye abɔa kamɛ eke ye aduli ɛlɛ kĩ, ‘Na ɔwɔlɛ bɔɛɛ kakpa yĩ! Maase nɔ kɔtɔ a!’ ");
INSERT INTO bov_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Lɛmɛ ɛtátunɔ, mbom ɛfɔ̃ bido ye nɛ kɔla kɛnaawo lɔkɔ a kĩ yaase kɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kĩ basumunɛ bɛbã a mɔ lɛtsa a kĩ lɛya a, fuwo be kalɔɛ ade bɛnabi lɛgã a lɛtsa a kĩ lɛya a flee a. ");
INSERT INTO bov_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Foesũ lɛgã a vɛ ɔsumunɛ a ɛya nɛ ye sɛkɛ̃ ade ebi ye kĩ, ‘Nɔ ɔsumunɛ kpa! Nkɔa kɔtɔ beblebee a kĩ odzimɔ yĩ a nte nɔ nɛ kĩ oke yĩ aduli sũ. ");
INSERT INTO bov_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kɛtáfɛta kĩ amɔ nɔ ɔkɔba ɔsumunɛ kɔnya ndɛ ayekĩ mmɔ́ nɔ kɔnya a?’ ");
INSERT INTO bov_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ade lɛgã a na kalɔkpa mɔ ɔsĩ ɛfɔ̃ bɛnado ye nɛ kɔla kĩ bɛmɔna ye lubo kɛnaawo kĩ ese kɔtɔ a flee.” ");
INSERT INTO bov_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu wũna kĩ, “Ade aye Nda nɛ ode a aakɛna mi kamɛ odi nyɛ odi kĩ ɛtákɔa ete ɔwaɛ̃ etomɛna ye ɔwɔlɛ kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, ɛdzakũ nɛ Galilea ɛnaa Yudea amantam nɛ Yordan ɔwɔ liti a. ");
INSERT INTO bov_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bati kɔdabu pii tomɔ ye bɛnaa ade ɛtsa be fɔtsa nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisifɔ a badi ya nɛ ye sɛkɛ̃, ade bɛwɛ kĩ basɔ ye bɛdã, foesũ bivia ye kĩ, “Boe mbla kpa onyole osi kĩ esĩ ɔtsɔ̃ nɛ kalɛ nyɛ kalɛ kĩ yawɛ a akũ?” ");
INSERT INTO bov_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kpa be mbuayɛ kĩ, “Mitákã nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ nɛ kayɔkayi a, otsole mɔ onyole Ɔbɔanɛ bɔa? ");
INSERT INTO bov_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ade Baguma lɛ kĩ, ‘Nɛ fukĩĩ sũ onyole aafɔnɛ ɔlɛga mɔ ɔma eyi ɛkɔa akũ ɛmɛna mɔ ɔtsɔ̃, lɔkɔa be nviã a baakɛna oti mɔa.’ ");
INSERT INTO bov_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Foesũ bibuki bɛnyɛ́ bati nviã mbom bɛkɛna oti mɔa. Nɛ foesũ otidziwa ɛtasɛ̃ lɛtsa a kĩ Baguma boomu a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ade Farisifɔ a via ye kĩ, “Mɔ nde sũ Mose kpa osi kĩ onyole ɛkpa ye ɔtsɔ̃ kasĩ ovoli lɔkɔa ɛfɔnɛ ye awɛ?” ");
INSERT INTO bov_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kpa be mbuayɛ kĩ, “Ade mi atɔ ɔsĩ sũ mɔ Mose kpa mi osi kĩ misĩ mi batsɔ̃ a, lɛmɛ fɔtána lɔmɔ nɛ kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lɛmɛ finyaa mabi mi kĩ ntɛ onyole odi sĩ ɔtsɔ̃ kĩ nnɛ́ kanɛ ɛnɛ ye liti sũ, mɔ ɛnakɔã otsole bɛbã ni, ɛbɔa adɔpaa.” ");
INSERT INTO bov_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ye fɔtsa bakɔlɛnɛ a bi ye kĩ, “Ntɛ aye onyole mɔ otsole kayite fɔlɛtsa la kɔ̃ ni, fɔnɛ́nɛ kĩ bɛkɔã ɔtsɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kpa be mbuayɛ kĩ, “Nnɛ́ odi nyɛ odi aapuli enu fɔlɛtsa kĩĩ kayɔ, mbɔɛntɛ bikĩ Baguma kpa be foe a. ");
INSERT INTO bov_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kitonɛkĩ kayɔkanyɛ futefute deĩ kĩ foe sũ banyole lɛláapuli bɛkɔã batsɔ̃. Badi bɛma be basaɛ, babɛbã bati lɛkɛna be basaɛ, ade badi lɛmɛ lákɔã batsɔ̃ nɛ ode lɛgãkanyakɔ̃ a sũ. Oti a kĩ yaapuli ɛtɛ fɔtsa katsa kĩĩ ni, ɛtɛ foe.” ");
INSERT INTO bov_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bati badi kpã babisɛ̃ bɛma Yesu kĩ ete awɛ nɛ be akũ, ɛbɔa mpaɛ ɛkpa be, lɛmɛ ye fɔtsa bakɔlɛnɛ a wũni nɛ be akũ. ");
INSERT INTO bov_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lɛmɛ Yesu lɛ kĩ, “Mifɔ̃ babisɛ̃ a bɛya nɛ yĩ sɛkɛ̃, mitasua be osi, kitonɛkĩ ade bikĩĩ bamɛ odu lá ode lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Adeke Yesu te awɛ nɛ be akũ ehila be, ade ɛdzakũ nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Luwi a onyole odi ya nɛ Yesu sɛkɛ̃ ɛvia ye kĩ, “Fɔtsa Ɔtsanɛ, lɛtsa wĩ lɔɔdabe kɛnɛ kĩ nkɛna mɔ maana daa nkpã a?” ");
INSERT INTO bov_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kpa ye mbuayɛ kĩ, “Nde sũ avia yĩ kalɛ nɛ fɔtsa wĩ kakɛna akũ? Oti mɔapɛ nyɛ owĩ. Lɛmɛ ntɛ awɛ kĩ awo nɛ nkpã kamɛ kɔ̃ ni, kɛna nɛ tɛbla a akũ.” ");
INSERT INTO bov_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oti a via ye kĩ, “Tɛbla tɛwɔdabe?” Yesu kpa ye mbuayɛ kĩ, “Takɔ oti, tabɔa adɔpaa, taye, tadi adansiɛ klumu, ");
INSERT INTO bov_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bu aga mɔ ama, kawɛ nɔ ɔkɔba kalɛ ndɛ ayekĩ awɛ nɔ akũ kalɛ a.” ");
INSERT INTO bov_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ade opopo a kpa mbuayɛ kĩ, “Nkɛna nɛ tɛbla kĩĩ flee akũ. Litsa libuki lisĩ kĩ nkɛna?” ");
INSERT INTO bov_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu bi ye kĩ, “Ntɛ awɛ kĩ akpɔla ni, naa kanaanɔ nɔ akũ fɔtsa flee, kakɔa sika a kate ahiãfɔ, lɔkɔa aana akũ kana fɔtsa nɛ ode. Ke liti muniki kayaatomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kĩ opopo a nu fɔlɛtsa kĩĩ a, ɛdzakũ mɔ ayɔlɔhɔ, kitonɛkĩ edeĩ akũ fɔtsa beblebee. ");
INSERT INTO bov_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Adeke Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ fɔ́ana ɔsĩ paa fɔkpa osikani kĩ yaawo nɛ ode lɛgãkanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mbuki mabi mi kĩ fɔadã bɔɛɛ fɔkpa ɔpɔnkɔ mɔ kanɛ mɔ lɔpɔ kĩ yaatsã ɔnɔbɔ̃ ɔkɛ kamɛ ɛnɛ́ kɛba kĩ osikani aawo nɛ Baguma lɛgãkanyakɔ̃ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kĩ fɔtsa bakɔlɛnɛ a nu kalɛ kĩĩ a, akũ dzuli be, ade bivia kĩ, “Kekɔ̃ owei aapuli ɛna katɛ?” ");
INSERT INTO bov_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu dã be kɛnanaana ade ɛlɛ kĩ, “Otidziwa lɛláapuli ɛkɛna fukĩĩ, lɛmɛ Baguma kɔ̃ apuli kakɛna lɛtsa nyɛ lɛtsa.” ");
INSERT INTO bov_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ade Petro dzɛla odo ɛlɛ kĩ, “Dã kĩ bɔfɔnɛ boe fɔtsa flee awɛ bɔya butomɔ nɔ, litsa koũ aanya boe fude?” ");
INSERT INTO bov_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu bi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ntɛ Otidziwa Obi a kɛna akũ edzi nɛ ye lɛgãkpo kpalɛwa a akũ nɛ katinya vɔɛ̃ a kamɛ ni, mi bati ewua-nviã a kĩ mitomɔ yĩ a lɛmɛ míadzi nɛ fɔgãkpo ewua-nviã akũ midzɛmɔ Israel futete ewua-nviã a. ");
INSERT INTO bov_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ade odi nyɛ odi kĩ ɛfɔnɛ fɔla, bawaɛ̃nyole, ĩye bawaɛ̃tsole, balɛga ĩye bama ĩye babi, ĩye fɔba biyi nɛ yĩ sũ ni, Baguma aakpa ye foe titi ɔha mɔ nkpã kĩ ɛla kawũna a. ");
INSERT INTO bov_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lɛmɛ bati pii kĩ bɛnyɛ batɔnyade finyaa a, aakɛna liti bade, ade liti bade a aakɛna batɔnyade a.” ");
INSERT INTO bov_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ode lɛgãkanyakɔ̃ a la ndɛ okuani odi kĩ eyidza mɔ ɔnɔnɛ tutuutu ɛnabɔɛ apaafɔ badi kĩ bɛyaakɛna adzuma bɛkpa ye nɛ ye waĩ kɔba kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bɛmɔ apaafɔ a bɛnya kɔya, etunɔ kĩ yaase be sika ovoe sɔmɔa sɔmɔa kĩ fɔnyɛ luwi mɔa kɔtɔkase, ade edo be nɛ ye waĩ kɔba a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kĩ ɔnɔnɛ tɔdɔũ evedi bɔa a, onyole a buki ɛnɛ ɛnaa kɔya ade ɛnamɔ banyole badi kĩ bɛdzɛ̃, kĩ bɛlá adzuma kɛnawa adima. ");
INSERT INTO bov_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Foesũ ebi be kĩ, ‘Mi malo minaakɛna adzuma nɛ yĩ waĩ kɔba kamɛ, maase mi kɔtɔ kĩ kɛfɛta a.’ ");
INSERT INTO bov_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ade bɛnaa kɔba a. “Ebuki ɛnɛ nɛ tɔdɔũ ewua-nviã mɔ olobe tɔdɔũ ɛlalɛ kamɛ ɛnakɛna ndɛ fɔtɔnyade a. ");
INSERT INTO bov_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kĩ tɔdɔũ elo anaa kabɔakɔ̃ a, ɛnaa kɔya ɛnamɔ banyole bɛbã kĩ bɛdzɛ̃ pupulidza. Evia be kĩ, ‘Nde sũ midzɛ̃ nɛ awĩ luwi a flee kĩ miákɛna lɛtsama?’ ");
INSERT INTO bov_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Bɛkpa ye mbuayɛ kĩ, ‘Odima tábɔɛ boe kĩ bɔkɛna adzuma bɔkpa ye.’ “Foesũ ebi be kĩ, ‘Ntɛ aye ni, mi malo minaakɛna adzuma nɛ yĩ kɔba a kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kĩ olobe wo ɔtɔ a, kɔba ɔlate a bi ye adzuma akũ ɔdãmɛnanɛ a kĩ, ‘Vɛ adzuma bakɛnanɛ a kase be kɔtɔ, kayi kayɔ katomɛna bikĩ bɛya nkaɛ a akũ kanaawũna nɛ batɔnyade a akũ.’ ");
INSERT INTO bov_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Bikĩ biyi adzuma kayɔ nɛ olobe tɔdɔũ elo kamɛ a kamɛ odi nyɛ odi tɛ sika ovoe sɔmɔa sɔmɔa. ");
INSERT INTO bov_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Foesũ kĩ bati batɔnyade a yaatɛ be kɔtɔkase a, bɛkɔna kĩ baase be bɛba lɔmɔ, lɛmɛ be malo bɛtɛ sika ovoe sɔmɔa sɔmɔa. ");
INSERT INTO bov_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kĩ bɛtɛ be sika a biyua a, bɛna kalɔkpa bɛkakɛna hũhũhũhũ nɛ ɔlate a akũ. ");
INSERT INTO bov_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ade bɛlɛ kĩ, ‘Bati a kĩ ɔbɔɛ nkaɛ a kɛna adzuma dɔũhuilɛ mɔapɛ, ade boe kɔ̃ bɔdza nɛ suwa kpaa kamɛ luwi a flee bɔkɛna adzuma a, lɛmɛ ose boe flee kɔtɔ tsɛtsɛɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kɔba ɔlate a kpa be kamɛ ɔmɔa mbuayɛ kĩ, ‘Ɔkɔba, dã ntásisi nɔ. Nnɛ́ sika ovoe sɔmɔa akũ bɔnya kɔya? ");
INSERT INTO bov_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kɔa nɔ kɔtɔkase kanaa kɔla. Yĩ lɛwɛ kĩ mase bati nkaɛ kĩĩ kɔtɔ ndɛ ayekĩ nse nɔ a. ");
INSERT INTO bov_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ndeĩ osi kĩ makɛna yĩ sika akũ adzuma ndɛ ayekĩ mawɛ. Mbɔɛɛ ayekĩ nkɛna sɛmɛ kalɛ a sũ anɛ abɛɛlɛ nɔ?’ ” ");
INSERT INTO bov_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ade Yesu wũna kĩ, “Foesũ bati a kĩ bɛkpa liti a, aadani batɔnyade, ade bikĩ bɛnyaa lɔtɔ a aadani batide a.” ");
INSERT INTO bov_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kĩ Yesu yɛlɛ yanaa Yerusalem a, ɛvɛ ye fɔtsa bakɔlɛnɛ ewua-nviã a nɛ ɔɔwɛ̃, ");
INSERT INTO bov_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ade ebi be kĩ, “Mitse lɛtsa a kĩ malɛ a! Bɔanaa Yerusalem, awã kĩ baakɔa Otidziwa Obi a bido nɛ basɔfɔnɔkɔɛ̃, mɔ mbla batsanɛ a awɛ. Baakɔ ye kɔtɔ bɛkpa wuda, ");
INSERT INTO bov_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bɛkɔa ye bido bikĩ bɛnyɛ́ Yudafɔ a nɛ awɛ kĩ bidi ye nsekuo. Baabo ye, ke liti baabɔa ye nɛ asendua akũ, lɛmɛ nɛ luwi lɛlalɛde akũ a, Baguma aadzɛla ye edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Adeke Zebedeo ɔtsɔ̃ kpã ye babinyole nviã ɛyamɛna nɛ Yesu sɛkɛ̃, ɛyake aduli nɛ ye anɛ kamɛ evia kabumɛna a. ");
INSERT INTO bov_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu via ye kĩ, “Litsa awɛ?” Otsole a kpa mbuayɛ kĩ, “Kpa yĩ bɔhɛ kĩ aafɔ̃ yĩ babinyole nviã kĩĩ kamɛ ɔmɔa lidzi nɛ nɔ sɔmɔna, ɔyade a lɛmɛ lidzi nɛ nɔ sɛba, nɛ nɔ lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kpa mbuayɛ kĩ, “Minyína lɛtsa a kĩ de milamɛna kavia a. Míapuli mimɔa lubo kamɔ kɔɔpu a kĩ maamɔa a?” Bɛkpa mbuayɛ kĩ, “Oo, bɔ́apuli.” ");
INSERT INTO bov_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ade Yesu bi be kĩ, “Ɔnɔkɔali fɔanɛ kĩ míapuli mimɔa foe, lɛmɛ nlá osi kĩ manyɛ oti a kĩ ye aadzi nɛ yĩ sɔmɔna ĩye yĩ sɛba. Fudzikɔ̃ a na nyɛ bikĩ Nda manɛ foe eyi a fude.” ");
INSERT INTO bov_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kĩ fɔtsa bakɔlɛnɛ nkaɛ ewua a nu fɔlɛtsa kĩĩ a, bɛna kalɔkpa nɛ bawaɛ̃ nviã a akũ. ");
INSERT INTO bov_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Foesũ Yesu vɛ be flee ɛkpɔta ade ebi be kĩ, “Minyina kĩ fɔgã a kĩ fɔanya amamufɔ akũ a deĩ kɔbɛ̃ nɛ be akũ, ade be banɔkɔɛ̃ lɛmɛ deĩ otumi baũ a nɛ be akũ a. ");
INSERT INTO bov_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lɛmɛ kɛtánɛ kĩ fɔana lɔmɔ nɛ mi kamɛ. Ntɛ mi kamɛ odi awɛ kĩ yanya ɔnɔkɔɛ̃ ni, kɛnɛ kĩ ɛnya mi ɔsumunɛ. ");
INSERT INTO bov_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ade ayea ntɛ mi kamɛ odi awɛ kĩ yanya ɔtɔnyade ni, kɛnɛ kĩ ɛnya mi ɔsumunɛ, ");
INSERT INTO bov_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ndɛ Otidziwa Obi a kĩ ɛtáya kĩ bisum ye, mbom kĩ yaasum ɛkɔa ye nkpã ɛkpa ɛnyɛ bati pii.” ");
INSERT INTO bov_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ a nɛ́ bito Yeriko ɔmatɔ a kamɛ banaa ni, bati kɔdabu baũ tomɔ be. ");
INSERT INTO bov_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Banɛkunɛ nviã kĩ bidzi nɛ osi ɔɔwɛ̃ nu kĩ Yesu yaatɛ̃, foesũ biyi fɔwɔla kabɔa kayɔ kĩ, “Lɛgã Dawid Obi, mɔ́ boe kɔnya!” ");
INSERT INTO bov_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bati kɔdabu a wũni nɛ be akũ kĩ bɛfɔ̃ fɔwɔla kabɔa, lɛmɛ bɛbɔa fɔwɔla a kɔɔba bɛba bɛlɛ kĩ, “Boe Ɔlate, Dawid Obi, mɔ́ boe kɔnya ni!” ");
INSERT INTO bov_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu fɔ̃ ɛdza ɛvɛ be kĩ bɛya nɛ ye sɛkɛ̃. Evia be kĩ, “Litsa miawɛ kĩ nkɛna nkpa mi?” ");
INSERT INTO bov_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bɛkpa ye mbuayɛ kĩ, “Ɔnɔkɔɛ̃, fɔ̃ boe anɛ ebinya.” ");
INSERT INTO bov_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Be akũ kɔ Yesu kɔnya, ade ɛkɔa awɛ ɛta be banebi a. Deedimɔapɛ be anɛ binya bɛmɔ́ fɔkɔ ade bitomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ a fuã Yerusalem, biwo Betfage kĩ ɛwaa nɛ Kugua Futse Ɔtɔ akũ a, edo ye fɔtsa bakɔlɛnɛ nviã kĩ bɛnya lɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ebi be kĩ, “Minaa akula a kĩ ɛwaa nɛ mi lɔtɔ a kamɛ. Ntɛ misila miwo awã a, míamɔ kĩ bido aflimu mɔ obi ɔwɛ̃ bɛdzɛla. Miwũnya be mikpã mima yĩ. ");
INSERT INTO bov_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ntɛ odi via mi kadi ni, milɛ kĩ, ‘Boe Ɔlate a sĩ be,’ lɔkɔa yaafɔnɛ be awɛ ɛkpa mi lɛtalɛta.” ");
INSERT INTO bov_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bɛkɛna fukĩĩ ayekĩ fɔlɛtsa a kĩ Baguma onukpɛ̃ ɔnyɛnɛ lɛ eyi a aaya nɛ foe kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bi Zion ɔmatɔ a kĩ, ‘Dã kĩ nɔ lɛgã aya nɛ nɔ sɛkɛ̃! Ɛdɔla ye akũ, edzi nɛ aflimu mɔ obi akũ yaya.’ ” ");
INSERT INTO bov_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ade fɔtsa bakɔlɛnɛ a naa bɛnakɛna ndɛ ayekĩ Yesu bi be kĩ bɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bɛkpã aflimu mɔ obi a bɛyamɛna, bɛkɔa be tilima bɛtɛɛtɛɛ nɛ be akũ ade Yesu de edzi a. ");
INSERT INTO bov_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bati kɔdabu a dzɛlɛ be tɛtadiɛ wulaa biko nɛ osi a akũ, ade badi lɛmɛ pãã pãã futse tɛnanɛ biko nɛ osi a akũ a. ");
INSERT INTO bov_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bati kɔdabu a kĩ bɛnya Yesu lɔtɔ mɔ bikĩ bitomɔ ye nɛ liti a kabɔa fɔwɔla kĩ, “Mitu osee nɛ Lɛgã Dawid Obinyole a akũ! Baguma ehila oti a kĩ yaya nɛ boe Ɔlate dĩ akũ a! Mimu Baguma nɛ ode!” ");
INSERT INTO bov_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kĩ Yesu wo nɛ Yerusalem ɔmatɔ a kamɛ a, ɔmatɔ a flee bɔa obũ, ade bati via kĩ, “Owei nɛ awĩ a?” ");
INSERT INTO bov_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bati kɔdabu a kpa mbuayɛ kĩ, “Ade Baguma Onukpɛ̃ Ɔnyɛnɛ Yesu kĩ eto Nazaret nɛ Galilea tite akũ a.” ");
INSERT INTO bov_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ade Yesu nawo nɛ Asɔli Kɔla a kamɛ, ɛblɔmɛna bati a kĩ bɛkanɔ fɔtsa mɔ bikĩ bɛkaya fɔtsa a nɛ awã ɛnɛmɛna. Edu bikĩ babɛ̃ sika a tupunu mɔ bikĩ banɔ mblɔduma a fukpo ewula, ");
INSERT INTO bov_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ade ebi be kĩ, “Bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ Baguma lɛ kĩ, ‘Baavɛ Yĩ Asɔli Kɔla a kĩ mpaɛ kabɔakɔ̃’ lɛmɛ mi kɔ̃ mikɔa koe mikɛna bayekpanɛ kabɛlakɔ̃!” ");
INSERT INTO bov_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ade banɛkunɛ mɔ abafã amɛ ya nɛ ye sɛkɛ̃ nɛ Asɔli Kɔla a kamɛ ade ɛtsa be fɔsɔ a. ");
INSERT INTO bov_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kĩ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a mɔ́ awãwã fɔtsa a kĩ ɛkɛna a, mɔ ayekĩ babisɛ̃ kabɔa fɔwɔla nɛ Asɔli Kɔla a kamɛ kĩ, “Mitu osee nɛ Lɛgã Dawid Obinyole a akũ!” a ni, bɛna kalɔkpa paa. ");
INSERT INTO bov_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Foesũ bivia Yesu nɛ kalɔkpa kamɛ kĩ, “Anu lɛtsa a kĩ bɛlamɛna kalɛ a?” Ade Yesu kpa be mbuayɛ kĩ, “Oo, manu. Mbɔɛɛ mitákã tɔ̃ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, ‘Babisɛ̃ mɔ bakɔkɔa onukpɛ̃ kamɛ kamu kĩ kɛkpɔla anɛ kato’ a?” ");
INSERT INTO bov_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ke liti a, Yesu dzakũ ɛfɔnɛ be, ɛnɛ nɛ ɔmatɔ a kamɛ ade ɛnaa Betania ɛnawa nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nɛ kadekanyina ɔnɔnɛ a, kĩ emuniki yanaa ɔmatɔ a kamɛ a, kɔlɛ kɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ɛmɔ́ kutse kĩ kɔawũ babi kĩ kɔdzɛ̃ nɛ osi ɔɔwɛ̃ ade ɛbɛlɛ ɛnaa koe kayɔ a, lɛmɛ ɛtámɔ babi badima nɛ koe akũ kɛba tɔɔta nɛnɛ. Foesũ ebi kutse a kĩ, “Ɔláabuki owũ babi dadaada.” Deedimɔapɛ kutse a tɔɔta vɛ. ");
INSERT INTO bov_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kĩ ye fɔtsa bakɔlɛnɛ a mɔ́ fukĩĩ a, fɔkɛna be wãwã, foesũ bivia ye kĩ, “Nde fɔya mɔ kutse a tɔɔta vɛ mɔatsɛ lɔmɔ?” ");
INSERT INTO bov_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ade Yesu kpa be mbuayɛ kĩ, “Mabi mi pipiipi kĩ ntɛ mitɛ mido, mɔ mitátɛ atsindze ni, míapuli mikɛna lɛtsa a kĩ nkɛna kutse kĩĩ. Nnɛ́ fukĩĩ odi malo, míapuli mibi ɔtɔ kĩĩ kĩ, ‘Bɔlɛ kanaatɔ nɛ mpo kamɛ,’ ade yaabɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ntɛ mideĩ katɛkado ni, lɛtsa nyɛ lɛtsa kĩ míavia nɛ mpaɛbɔ kamɛ ni, míana foe.” ");
INSERT INTO bov_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kĩ Yesu muniki ɛya nɛ Asɔli Kɔla kamɛ ɛkatsa fɔtsa a, basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ ya nɛ ye sɛkɛ̃ bivia ye kĩ, “Otumi ɔdabe ɔnɛɛ akɛna fɔtsa kĩĩ bamɛ? Owei lɛkpa nɔ osi a?” ");
INSERT INTO bov_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kpa be mbuayɛ kĩ, “Maavia mi kalɛ mɔapɛ ade ntɛ mikpa yĩ ke mbuayɛ ni, maabi mi otumi a kĩ nnɛɛ nkɔa makɛna fɔtsa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Owei sɛkɛ̃ Yohanes tɛ otumi etomɛna mɔ ɛwɔla bati mui? Baguma sɛkɛ̃ ɛtɛ ye etomɛna mbɔɛɛ kĩ batidziwa sɛkɛ̃?” Ade bido foe kamɛ kasa awɛ nɛ be kamɛ kĩ, “Litsa bɔ́alɛ? Ntɛ bɔlɛ kĩ, ‘Eto Baguma sɛkɛ̃’ ni, yaavia boe kĩ, ‘Mɔ nde sũ mitátɛ Yohanes mido?’ ");
INSERT INTO bov_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ade ntɛ bɔlɛ kĩ, ‘Eto bati sɛkɛ̃’ ni, bɔavila lɛtsa a kĩ bati a aakɛna, kitonɛkĩ be flee bɛtɛ bido kĩ Yohanes nyɛ Baguma onukpɛ̃ ɔnyɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Foesũ bɛkpa Yesu mbuayɛ kĩ, “Bunyína.” Ade Yesu lɛmɛ bi be kĩ, “Kekɔ̃ yĩ malo nláabi mi awã kĩ ntomɛna otumi nnɛɛ makɛna fɔtsa kĩĩ.” ");
INSERT INTO bov_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nde mikɔna nɛ kalɛ kĩĩ akũ? Onyole odi deĩ babinyole nviã. Ɛnaa ɔnɔkɔɛ̃de a sɛkɛ̃ ebi ye kĩ, ‘Yĩ obi, naa yĩ waĩ kɔba kamɛ nviã kanaakɛna adzuma kakpa yĩ.’ ");
INSERT INTO bov_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ye obi a kpa mbuayɛ kĩ, ‘Nláanaa,’ lɛmɛ ke liti a, fuwo ye kalɔɛ ade ɛnaa kɔba a. ");
INSERT INTO bov_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ɔlɛga a naa obi ɔyade a sɛkɛ̃ ebi ye kalɛ mɔapɛ a. Ɛkpa mbuayɛ kĩ, ‘Awoo, papa maanaa,’ lɛmɛ ɛtánaa. ");
INSERT INTO bov_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Bati nviã kĩĩ kamɛ ɔɔdabe lɛkɛna nɛ ɔlɛga a kawɛ akũ?” Bɛkpa mbuayɛ kĩ, “Ɔnɔkɔɛ̃de a.” Ade Yesu bi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ tɔgɔlɛ batɛnɛ mɔ adɔpaafɔ nya mi lɔtɔ bɛnaa nɛ Baguma lɛgãkanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kitonɛkĩ kĩ Yohanes Mui Ɔwɔlanɛ a ya kĩ yatsa mi osi wĩ a kĩ míatsã midzi nkpã a, mitátɛ ye mido. Mbom tɔgɔlɛ batɛnɛ mɔ adɔpaafɔ kɔ̃ tɛ ye bido. Ade titɔ kĩ mimɔ́ fukĩĩ malo ni, ke liti a mitádani adzuni mitɛ ye mido.” ");
INSERT INTO bov_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu bi be kĩ, “Mitse lɛgbã bɛbã lidi lɛmɛ. Kɔba ɔnɛnɛ odi nɛ́ waĩ kɔba, ade edzi kɔbã emini koe a. Ɛnyɛ lɛkɛ ɛkpa waĩ mui a kakã kako, ade eke kɔla geĩ kĩ oti aana nɛ awã ɛkadã kɔba a akũ. Ke liti ɛkɔa kɔba a edo nɛ waĩ kɔba banɛnɛ awɛ ɛdzakũ ɛnaa osi akũ. ");
INSERT INTO bov_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kĩ kutse babi a kana a wo ɔtɔ a, edo ye basumunɛ nɛ waĩ kɔba banɛnɛ a sɛkɛ̃ kĩ bɛnaatɛ ye kanyakɔ̃ bɛma ye. ");
INSERT INTO bov_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kɔba akũ badãmɛnanɛ a pi ye basumunɛ a, bibo ɔmɔa, bɛkɔ ɔbɛbã ade bɛtalɛ ɔlalɛde a boe a. ");
INSERT INTO bov_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ke liti a, kɔba ɔlate a buki edo basumunɛ bɛbã kĩ bɛpɔnɛ bɛbɛ̃ batɔnyade a, lɛmɛ kɔba akũ badãmɛnanɛ a kɛna be lɛtsa mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nɛ foe kawũna kamɛ a, edo ye obi nɛ be sɛkɛ̃, ɛlɛ kĩ, ‘Matɛ kado kĩ baanyɔã yĩ obi.’ ");
INSERT INTO bov_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Lɛmɛ kĩ kɔba akũ badãmɛnanɛ a mɔ́ obi a, bibi akũ kĩ, ‘Ade fɔtsa ɔnyanɛ a nɛ awĩ a. Miya bɔkɔ ye, ye adzapadiɛ a ɛdani boe ade.’ ");
INSERT INTO bov_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Foesũ bipi ye bɛvɛlɛ bɛnɛmɛna nɛ kɔba a kamɛ, ade bɛkɔ ye a.” ");
INSERT INTO bov_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu via kĩ, “Finyaa, ntɛ waĩ kɔba ɔlate a ya ni, litsa yaakɛna kɔba akũ badãmɛnanɛ kĩĩ a?” ");
INSERT INTO bov_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bɛkpa ye mbuayɛ kĩ, “Nɛ ɔnɔkɔali kamɛ ni, yaawɔla bati kpa a na, lɔkɔa ɛkɔa kɔba a edo nɛ kɔba akũ badãmɛnanɛ bɛbã awɛ, bikĩ baakɔa ye kanyakɔ̃ bɛma ye nɛ fudutsa kakpɔta lɔkɔ kamɛ pɛpɛɛpɛ.” ");
INSERT INTO bov_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ade Yesu bi be kĩ, “Mitákã tɔ̃ lɛtsa a kĩ Katsɛlɛ Kpalɛwa a lɛ a? ‘De a kĩ fɔla bakenɛ sĩ a, ade de lɛdani kɔla akũ de titiliwu a. Boe Ɔlate a lɛkɛna fukĩĩ. Fɔkɛna boe wãwã!’ ” ");
INSERT INTO bov_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu lɛ ebu kĩ, “Foesũ mabi mi kĩ, baatɛ Baguma lɛgãkanyakɔ̃ a nɛ mi awɛ bɛkɔa bɛkpa kade a kĩ kaawũ babi wĩ a. ");
INSERT INTO bov_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Odi nyɛ odi kĩ yaanɛ ɛtɔ nɛ de kĩĩ akũ ni, yaaveli gblɛgblɛgblɛ, lɛmɛ owula kĩ ye akũ laaatɔ ni, laabubuli ye kpɛtɛkpɛtɛkpɛtɛ.” ");
INSERT INTO bov_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kĩ basɔfɔnɔkɔɛ̃ mɔ Farisifɔ a nu Yesu fɔgbã kĩĩ a, bɛmɔ́ kĩ be akũ fɔlɛtsa ɛkalɛ, ");
INSERT INTO bov_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","foesũ bɛwɛ kĩ bapi ye. Lɛmɛ bivila bati kɔdabu a, kitonɛkĩ bati a bu Yesu ndɛ Baguma onukpɛ̃ ɔnyɛnɛ aye. ");
INSERT INTO bov_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu buki ɛlɛ kɔdzɛla mɔ be nɛ fɔgbã kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Baguma lɛgãkanyakɔ̃ a la ndɛ fukĩĩ. Lɛgã lidi te opunu ɛkpa obinyole nɛ ye obolitsɔ̃ kapi luwi akũ. ");
INSERT INTO bov_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Lɛmɛ kĩ edo ye basumunɛ kĩ bɛnaavɛ bati a kĩ ɛkpa kanyi a kĩ bɛya nɛ kanyakɔ̃, bisĩ kaya. ");
INSERT INTO bov_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Foesũ ebuki edo basumunɛ bɛbã nɛ bikĩ bɛvɛ a sɛkɛ̃ mɔ ɔlɛdo kĩ, ‘Bɛtɔ yĩ funitsã a biyua, bɛkɔ yĩ banantsuenyole mɔ banantsue babi dɔliwa, bɛmanɛ lɛtsa nyɛ lɛtsa biyua. Miya nɛ obolitsɔ̃ luwi kanyakɔ̃ a!’ ");
INSERT INTO bov_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Lɛmɛ bati a kĩ bɛvɛ a tákpeti ye kavɛ a, mbom bɛdzakũ bɛnaa be tudzuma kamɛ. Oti mɔa naa ye kɔba, ɔbɛbã naa kɔyaatɔ, ");
INSERT INTO bov_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bati nkaɛ a pili basumunɛ a bɛkɛna be tɛnya ade bɛkɔ be a. ");
INSERT INTO bov_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lɛgã a na kalɔkpa paa, foesũ edo ye sodzafɔ bɛnakɔ awudifɔ a, bipila be ɔmatɔ a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ke liti a, ɛvɛ ye basumunɛ ebi be kĩ, ‘Biyua obolitsɔ̃ kapi funitsã a katɔ, lɛmɛ bati a kĩ nvɛ a táfɛta obu a kĩ nkpa be a. ");
INSERT INTO bov_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Foesũ finyaa minaa ɔmatɔ a tɔblɔnu kpale akũ minaavɛ odi nyɛ odi kĩ míamɔ ɛya nɛ kanyakɔ̃ a.’ ");
INSERT INTO bov_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ade basumunɛ a nɛ bɛnaa tɔblɔnu akũ bɛnakpã odi nyɛ odi kĩ bɛmɔ́, bati wĩ mɔ bati kpa flee, ade obolitsɔ̃ kapikɔ̃ a yi mɔ bati a. ");
INSERT INTO bov_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kĩ lɛgã a nawo kĩ yadã bikĩ bɛvɛ a, ɛmɔ́ onyole odi kĩ ɛtádo obolitsɔ̃ kapi atadiɛ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ade lɛgã a via ye kĩ, ‘Ɔkɔba, nde ɔkɛna owo nɛ awĩ kĩ ɔtádo obolitsɔ̃ kapi atadiɛ?’ Lɛmɛ onyole a tɔ lumumu. ");
INSERT INTO bov_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Foesũ lɛgã a bi ye basumunɛ a kĩ, ‘Misui ye akpɔ mɔ abɔa mita ye mimuni nɛ kanya nɛ ɔtũ kamɛ, awã kĩ yaabe ɛba adɔ̃.’ ” ");
INSERT INTO bov_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu wũna kĩ, “Bati beblebee bavɛ, lɛmɛ be sukuloomɛ bapau.” ");
INSERT INTO bov_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisifɔ a nanaa adzina ayekĩ banaĩ Yesu bɛtsãmɛna fɔlɛtsa kavia kamɛ, bɛna ye nɛ ye kɔdzɛla kalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Foesũ bido be fɔtsa bakɔlɛnɛ mɔ bikĩ bitomɔ Herodes a kamɛ badi nɛ ye sɛkɛ̃ bɛlɛ kĩ, “Fɔtsa Ɔtsanɛ, bunyina kĩ odeĩ ɔnɔkɔali, atsa Baguma osi a nɛ ɔnɔkɔali kamɛ, ade ɔtsɛ́la odima akũ, kitonɛkĩ aádã oti anɛ. ");
INSERT INTO bov_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Foesũ bi boe nɔ adzuni. Boe mbla kpa osi kĩ bute tɔgɔlɛ bɔkpa Roma Lɛgãnɔkɔɛ̃, mbɔɛɛ kĩ ɛtákpa osi?” ");
INSERT INTO bov_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lɛmɛ Yesu mɔ́ be adzuni kpa a kĩ bɛbɔɛ a eyi ɔsũ, foesũ ebi be kĩ, “Mi anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Nde sũ miasɔ yĩ midã? ");
INSERT INTO bov_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mikɔa sika a kĩ miakɔa kase ɔgɔlɛ a mitsa yĩ.” Bɛkɔa sika a bɛma ye, ");
INSERT INTO bov_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ade evia be kĩ, “Owei lɔlɔ kata mɔ dĩ teĩ nɛ se akũ?” ");
INSERT INTO bov_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bɛkpa ye mbuayɛ kĩ, “Roma Lɛgãnɔkɔɛ̃ fude fɔanɛ.” Foesũ Yesu bi be kĩ, “Kekɔ̃ mikɔa lɛtsa a kĩ lɛnyɛ Roma Lɛgãnɔkɔɛ̃ lide mikpa ye, ade mikɔa lɛtsa a kĩ lɛnyɛ Baguma lide lɛmɛ mikpa Baguma.” ");
INSERT INTO bov_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kĩ binu fɔlɛtsa kĩĩ a fɔkɛna be saa, ade bɛfɔnɛ ye awɛ bɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Luwi mɔapɛ a, Zadukifɔ kĩ balɛ kĩ banɔkpa kayidza lɛláa kamɛ badi ya nɛ Yesu sɛkɛ̃ bɛyavia ye ");
INSERT INTO bov_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","kĩ, “Fɔtsa Ɔtsanɛ, Mose bi boe kĩ ntɛ onyole odi kĩ ɛtáma ku ni, kɛnɛ kĩ ɔwaɛ̃nyole ɛkɔã okunawa a lɔkɔa bɛma bido ye lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Finyaa bawaɛ̃nyole evũkɔnɔ badi dzi nɛ boe kamɛ tɔ̃ nɛ awĩ. Ɔnɔkɔɛ̃de a kɔã ɔtsɔ̃ lɛmɛ bɛmɔ ye bɛtáma fɔmɔ eku, foesũ ɛfɔnɛ ye okunawa a eyi ɛkpa ɔwaɛ̃nyole a. ");
INSERT INTO bov_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ade lɛtsa mɔapɛ a lɛya nɛ ɔyade a, mɔ ɔlalɛde a, kɛnawo ovũkɔnɔde a akũ a. ");
INSERT INTO bov_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nɛ foe kawũna kamɛ a, otsole a lɛmɛ ku. ");
INSERT INTO bov_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Finyaa, nɛ luwi a kĩ banɔkpa aayidza bidzi nkpã akũ a, be kamɛ ɔɔdabe ɔtsɔ̃ yaanya, kitonɛkĩ banyole evũkɔnɔ a flee kɔã ye tɔ̃ a?” ");
INSERT INTO bov_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kpa be mbuayɛ kĩ, “Mikɛna mfumsu, kitonɛkĩ minyína Katsɛlɛ Kpalɛwa a fɔlɛtsa mɔ Baguma kɔbɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kitonɛkĩ nɛ banɔkpa kayidza kadzi nkpã kamɛ ni, bɛláakɔã batsɔ̃ ĩye bidzi fɔnyɔ, mbom baana ndɛ ode fɔtɔ banyanɛ aye. ");
INSERT INTO bov_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mbɔɛɛ mitákã tɔ̃ lɛtsa a kĩ Baguma lɛ nɛ banɔkpa kayidza kadzi nkpã akũ a? Ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yĩ nyɛ Abraham Baguma, mɔ Isak Baguma mɔ Yakob Baguma.’ Nnɛ́ banɔkpa Baguma yanɛ, mbom batidziwa ade yanɛ.” ");
INSERT INTO bov_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kĩ bati kɔdabu a nu fɔlɛtsa kĩĩ a, akũ dzuli be nɛ ye fɔtsa katsa a akũ. ");
INSERT INTO bov_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kĩ Farisifɔ a nu kĩ Zadukifɔ a tápuli bɛdza nɛ Yesu anɛ a, bɛnakpɔta nɛ kakɔ mɔa, ");
INSERT INTO bov_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ade be kamɛ ɔmɔa kĩ ɛnyɛ mbla ɔtsanɛ sɔ Yesu ɛdã nɛ fɔlɛtsa kavia kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Fɔtsa Ɔtsanɛ, Mose mbla aádabe bɛ̃ nɛ te kamɛ?” ");
INSERT INTO bov_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kpa ye mbuayɛ kĩ, “Wɛ boe Ɔlate, nɔ Baguma a kalɛ mɔ nɔ ɔwɔlɛ flee, mɔ nɔ ɔkla flee, mɔ nɔ adzuni flee. ");
INSERT INTO bov_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ade mbla kĩĩ nyɛ atɔnyade mɔ ekĩ ɛbɛ̃ flefle a. ");
INSERT INTO bov_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mbla ayade a la ndɛ ye, ‘Wɛ nɔ ɔkɔba kalɛ ndɛ ayekĩ awɛ nɔ mɔawɛ akũ kalɛ.’ ");
INSERT INTO bov_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ade tɛbla nviã kĩĩ akũ Mose mbla a mɔ Baguma onukpɛ̃ banyɛnɛ fɔtsa katsa a flee dzɛ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kĩ Farisifɔ a yakpɔta a, Yesu via be kĩ, ");
INSERT INTO bov_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Litsa nyɛ mi adzuni nɛ Kristo akũ? Owei obinyole yanɛ?” Bɛkpa mbuayɛ kĩ, “Lɛgã Dawid kasinu kamɛ ɔwa yanɛ.” ");
INSERT INTO bov_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ade Yesu via be kĩ, “Kekɔ̃ nde sũ Dawid tsã Hũhũ kamɛ ɛvɛ ye kĩ, ‘Ɔlate’? Kitonɛkĩ Dawid lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Boe Ɔlate bi yĩ Ɔlate a kĩ, “Dzi nɛ yĩ sɔmɔna kɛnaawo kĩ maakɔa nɔ bakesĩnɛ ndo nɛ nɔ abɔa kayɔ.” ’ ");
INSERT INTO bov_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ntɛ Dawid vɛ Kristo kĩ Ɔlate a ni, nde Kristo aapuli ɛnya Dawid obinyole?” ");
INSERT INTO bov_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Be kamɛ odima tápuli ɛkpa Yesu mbuayɛ, ade kito luwi a kanaa a, odima tádo ɔwɔlɛ ebuki evia ye kalɛ kadima. ");
INSERT INTO bov_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ke liti a, Yesu bi bati kɔdabu mɔ ye fɔtsa bakɔlɛnɛ a fɔlɛtsa kĩ, ");
INSERT INTO bov_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mbla batsanɛ mɔ Farisifɔ a bɛkpa kɔbɛ̃ kĩ banyɛ Mose mbla a kayɔ. ");
INSERT INTO bov_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Foesũ mikɛna lɛtsa nyɛ lɛtsa kĩ bibi mi kĩ mikɛna a mipi foe midomɔ akũ. Lɛmɛ mitadã be fɔkɛlatsa mikɛna, kitonɛkĩ baákɛna nɛ lɛtsa a kĩ balɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Bisuli fɔtsa mɔ ɔlɔmɛ kĩ fudeĩ ɔsĩ mɔ kalɔ bɛlɔla bati, lɛmɛ be mɔawɛ a kɔ̃ baáwɛ kĩ bayo lawobi malo bibumɛna bati foe kalɔ. ");
INSERT INTO bov_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bakɛna lɛtsa nyɛ lɛtsa ayekĩ bati bɛmɔ be kɛkɛ. Bakɔa fumakɛ kĩ fɔsa a kĩ bɛtsɛlɛ Baguma fɔlɛtsa bite kabɔa nɛ nnyɛ mɔ akpɔ. Ade bakɛna be tɛtadiɛ wulaa atɔ tɛsa, tɛvanɛ mɔ mpɛsɛmpɛsɛ gɛlɛɛlɛgɛlɛɛlɛ a! ");
INSERT INTO bov_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bawɛ kĩ badzi nɛ banɔkɔɛ̃ fudzikɔ̃ nɛ kanyakɔ̃, mɔ banɔkɔɛ̃ fudzikɔ̃ nɛ Yudafɔ fɔtsɛnakɔ̃. ");
INSERT INTO bov_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bawɛ kĩ bati bɛwɔ̃na be mɔ obu nɛ kɔyaatɔ, bɛvɛ be kĩ Fɔtsa Ɔtsanɛ mɔ obu. ");
INSERT INTO bov_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kɛtánɛ kĩ bavɛ mi kɔ̃ kĩ Fɔtsa Ɔtsanɛ, kitonɛkĩ Fɔtsa Ɔtsanɛ mɔapɛ mideĩ, ade mi flee minyɛ bawaɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ade ayea mitavɛ odima nɛ tite akũ kĩ mi Ɔlɛga, kitonɛkĩ Ɔlɛga mɔapɛ mideĩ nɛ ode. ");
INSERT INTO bov_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mitafɔ̃ odima lɛvɛ mi kĩ Ɔkpãnɛ malo, kitonɛkĩ ɔkpãnɛ mɔapɛ mideĩ, kĩ ɛnyɛ Kristo. ");
INSERT INTO bov_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Oti a kĩ ɛnyɛ ɔnɔkɔɛ̃ nɛ mi kamɛ ni, ɛnya mi ɔsumunɛ. ");
INSERT INTO bov_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Odi nyɛ odi kĩ yadɛla ye akũ nɛ ode ni, baakɛna ye nɛ kayɔ, ade odi nyɛ odi kĩ ɛdɔla ye akũ ni, baadɛla ye nɛ ode. ");
INSERT INTO bov_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lɛmɛ makpa mi mbla batsanɛ mɔ Farisifɔ bɔbɔɛ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Mibalɛ ode lɛgãkanyakɔ̃ a onyukpɛ̃ a mido bati. Mi mɔawɛ a miáwo, ade miákpa bikĩ bɛbɔa mbɔdi kĩ bawo a osi biwo a. ");
INSERT INTO bov_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Makpa mi mbla batsanɛ mɔ Farisifɔ bɔbɔɛ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Miatɛ bakunawa tɔtɔ nɛ be awɛ ade miabɔa mpaɛ gɛlɛɛlɛ kakɔa tsa akũ a. Nɛ fukĩĩ sũ míana sɔtɔ kavɛlɛ mɔ ɔsĩ sɛba! ");
INSERT INTO bov_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Makpa mi mbla batsanɛ mɔ Farisifɔ bɔbɔɛ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Mitsã mpo akũ minyina minaa fude fude kĩ miawɛ oti mɔapɛ ɛdani Yudani, lɛmɛ ntɛ midani ye a, miakɛna ye titi nviã ɛkpɔla ɛkpa fi luwotu kamɛ kanaa ndɛ mi aye! ");
INSERT INTO bov_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makpa mi banɛkunɛ a kĩ bakpã bati a bɔbɔɛ! Mialɛ kĩ, ‘Ntɛ odi tani Asɔli Kɔla ni, fɔnyɛ́ lɛtsama, lɛmɛ ntɛ ɛtani sika ngbã nɛ Asɔli Kɔla kamɛ kɔ̃ ni, fubo a pi ye.’ ");
INSERT INTO bov_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Banɛkunɛ bakɔasia! Fɔɔdabe bɛ̃ kɔya? Sika ngbã a mbɔɛɛ Asɔli Kɔla a kĩ kɔfɔ̃ sika a akũ kpalɛ a? ");
INSERT INTO bov_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Miatsa fɔtsa lɛmɛ kĩ, ‘Ntɛ odi tani Baguma afɔlibɔ atɛnyɛ a ni, fɔnyɛ́ lɛtsama, lɛmɛ ntɛ ɛtani afɔliɛ fɔtsa a nɛ afɔlibɔ atɛnyɛ a akũ kɔ̃ ni, ɛlɔ fubo.’ ");
INSERT INTO bov_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Banɛkunɛ mianɛ nuwĩ! Fɔɔdabe bɛ̃ kɔya? Futetsa a mbɔɛɛ kĩ afɔlibɔ atɛnyɛ a kĩ ye lɛkpalɛ futetsa a akũ a? ");
INSERT INTO bov_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Foesũ ntɛ odi tani afɔlibɔ atɛnyɛ a ni, ɛtani ye mɔ futetsa a kĩ futeĩ nɛ atɛnyɛ a akũ a flee. ");
INSERT INTO bov_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ade ntɛ odi tani Asɔli Kɔla a ni, ɛtani koe mɔ Baguma a kĩ edzi nɛ koe kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ade ayea ntɛ odi tani ode ni, ɛtani Baguma lɛgãkpo mɔ Baguma a kĩ edzi nɛ de akũ a. ");
INSERT INTO bov_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Bɔbɔɛ makpa mi mbla batsanɛ mɔ Farisifɔ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ mianɛ! Miakpa Baguma tuwĩ kĩ bakɔa kado funitsã ɔlɛ̃ te kamɛ kasɛ̃ katsu kawuade a pɛpɛɛpɛ, lɛmɛ mifɔnɛ mbla fɔtsa katsa sĩwa, kĩ fɔnyɛ fɔlɛtsa kadzɛ nɛ osi kpĩĩ, kɔnyakamɔ mɔ ɔnɔkɔali kadi awɛ. Ade fukĩĩ kufɛ kɛfɛta kĩ miakɛna lɔkɔa mikɛna fɔbɛbã a mibu a. ");
INSERT INTO bov_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Banɛkunɛ bati bakpãnɛ! Miasɔni kɔyabi kanyɛ nɛ bavɛ kamɛ, lɛmɛ miamɛna ɔpɔnkɔ mɔ kanɛ mɔ lɔpɔ! ");
INSERT INTO bov_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Bɔbɔɛ makpa mi mbla batsanɛ mɔ Farisifɔ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Miavɔlɛ mi kuyei mɔ titsensi liti yededeede, lɛmɛ foe kamɛ yi mɔ fɔtsa a kĩ mikɔa kɔbɛ̃ mɔ anɛngbã mitɛ a. ");
INSERT INTO bov_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nɔ Farisini ɔnɛkunɛ, nya lɔtɔ kavɔlɛ kayei a kamɛ, lɔkɔa ke liti lɛmɛ aakpalɛ! ");
INSERT INTO bov_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Bɔbɔɛ makpa mi mbla batsanɛ mɔ Farisifɔ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Mila ndɛ funikɛ kĩ bikputa mɔ tite ovoe kĩ fɔalɛ kadã, lɛmɛ foe kamɛ yi mɔ banɔkpa fɔtsɔ̃ mɔ sukɛna vɔ̃wa. ");
INSERT INTO bov_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ade ayea miatsa akũ nɛ bati anɛ ndɛ bati wĩ, lɛmɛ mi kamɛ kɔ̃ yi mɔ anɛ kamɛ kɛkɛ fɔtsa kakɛna mɔ tɔkpa. ");
INSERT INTO bov_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Bɔbɔɛ makpa mi mbla batsanɛ mɔ Farisifɔ! Anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Mike funi mɔ kalɛ mikpa Baguma onukpɛ̃ banyɛnɛ a ade mihɛhɛ bikĩ bidzi nkpã wĩ a anɛ kate fɔtsa a. ");
INSERT INTO bov_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ade mialɛ kĩ, ‘Ntɛ budzi nkpã nɛ boe bawanyɔ lɔkɔ a ni, kufɛ bɔtákɛna ɔmɔa mɔ be bɔkɔ Baguma onukpɛ̃ banyɛnɛ a.’ ");
INSERT INTO bov_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ade fukĩĩ mikɔa midi adansiɛ nɛ mi akũ kĩ minyɛ bati a kĩ bɛkɔ Baguma onukpɛ̃ banyɛnɛ a bawa! ");
INSERT INTO bov_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nɛ foesũ mikɛna minaa lɔtɔ, lɔkɔa miyula lɛtsa a kĩ mi bawanyɔ yi kayɔ a! ");
INSERT INTO bov_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mi bati kĩ bɛla ndɛ bɔɛ babi! Kakɔna mikɔna kĩ míapuli milo, kĩ bɛláakɔ mi kɔtɔ bɛkpa fi luwotu kamɛ kanaa? ");
INSERT INTO bov_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Foesũ mabi mi kĩ maado Baguma onukpɛ̃ banyɛnɛ, anyansãfɔ, mɔ fɔtsa batsanɛ nɛ mi sɛkɛ̃. Míakɔ badi, mibɔa babɛbã nɛ asendua akũ, míabo badi mɔ mple nɛ mi fɔtsɛnakɔ̃, mitomɔ be liti kito ɔmatɔ kɛnaa ɔmatɔ. ");
INSERT INTO bov_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɛ fukĩĩ sũ bati wĩ babɔanɛ a kĩ biwula a flee aaya nɛ mi akũ. Fɔ́ayi kayɔ futo oti kpĩĩ Abel babɔanɛ akũ kɛnaawo Zakaria, Barakiya obi a kĩ mikɔ nɛ Asɔli Kɔla mɔ afɔlibɔ atɛnyɛ a kayite a akũ. ");
INSERT INTO bov_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ sɔtɔ kavɛlɛ nɛ wuda kĩĩ flee akũ aaya nɛ mi nviã babi akũ! ");
INSERT INTO bov_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem, Yerusalem, nɔ a kĩ ɔkɔ Baguma onukpɛ̃ banyɛnɛ, ade ɔnɔ fɔtɔ banyanɛ a kĩ Baguma do nɛ nɔ sɛkɛ̃ a boe a! Titi eni nwɛ kufɛ kĩ makpɔta nɔ babi ndɛ ayekĩ ɔkɔkɔ bima akpɔta ye babi kado nɛ fupoki kayɔ, lɛmɛ ɔtátunɔ! ");
INSERT INTO bov_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dã, baafɔnɛ nɔ tɔtɔ awɛ biyi tɛdza luto. ");
INSERT INTO bov_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mabi nɔ kĩ kito finyaa kanaa ni, ɔláabuki ɔmɔ́ yĩ kɛnaawo kĩ aalɛ kĩ, ‘Baguma hila oti a kĩ yaya nɛ boe Ɔlate dĩ akũ a.’ ” ");
INSERT INTO bov_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kĩ Yesu nɛ́ nɛ Asɔli Kɔla kamɛ yanaa a, ye fɔtsa bakɔlɛnɛ a ya nɛ ye sɛkɛ̃ kĩ batsa ye ayekĩ bike kɔla a flee a. ");
INSERT INTO bov_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu bi be kĩ, “Midã fukĩĩ flee kadã wĩ. Mabi mi nɛ ɔnɔkɔali kamɛ kĩ bɛláatina de lidima nɛ lɔkɔba akũ kĩ bɛláadu bimuni.” ");
INSERT INTO bov_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kĩ Yesu nɛ edzi nɛ Kugua Futse Ɔtɔ a akũ a, ye fɔtsa bakɔlɛnɛ a bɛla bɔɛɛ bɛya nɛ ye sɛkɛ̃ bivia ye kĩ, “Lɔkɔ lɔwɔdabe fɔtsa kĩĩ aaya nɛ foe kamɛ. Bi boe lɛtsa a kĩ laanya nɔ kaya mɔ katinya kamɛ kawũna a nsɛntsɛlɛni.” ");
INSERT INTO bov_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kpa be mbuayɛ kĩ, “Midã kadã wĩ ayekĩ odima lɛláakɛ mi. ");
INSERT INTO bov_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kitonɛkĩ bati pii aaya nɛ yĩ dĩ akũ bɛlɛ kĩ, ‘Yĩ nyɛ Kristo a.’ Baakɛ bati pii. ");
INSERT INTO bov_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Míanu kawũ kanɔ mɔ kawũ akũ fɔlɛtsa mɔ lugo. Lɛmɛ mitafɔ̃ fɔtsa kĩĩ lɛbɔlɛ mi tɔwɔlɛ. Kɛnɛ kĩ fɔtsa kĩĩ fɔya nɛ foe kamɛ, lɛmɛ fɔátsa kĩ katinya kamɛ kawũna a wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɔmaĩ aanɔ mɔ akũ, ade fɔgã kanyakɔ̃ aayidza bɛnɔ mɔ fɔgã kanyakɔ̃ a. Kɔlɛ aana, ade tite aakuna mɔ ɔsĩ mɔ ɔsĩ nɛ fɔkɔ pii a. ");
INSERT INTO bov_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Fukĩĩ flee la ndɛ ɔmatsɔ̃ sɛmɛ kapi kawo a kayɔkayi aye. ");
INSERT INTO bov_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nɛ lɔkɔ a na kamɛ ni, baanyɛ mi bɛkpa kĩ bɛkɛna mi awɔda, bɛkɔ mi malo. Batidziwa flee aakesĩ mi nɛ yĩ sũ. ");
INSERT INTO bov_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bati pii aamuniki nɛ be katɛkado liti. Baanyɛ be akũ akũ abɔa, bikesĩ akũ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Fɔvã onukpɛ̃ banyɛnɛ aanɛ bɛkpã bati pii bɛyɛla osi. ");
INSERT INTO bov_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tɔkpa kakɛna aade nɛ ode paa kĩ bati pii ɔdɔ onukpɛ̃ aadɔ. ");
INSERT INTO bov_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lɛmɛ odi nyɛ odi kĩ yaadza pintii ɛnawo kawũna ni, Baguma aatɛ ye. ");
INSERT INTO bov_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baalɛ Baguma lɛgãkanyakɔ̃ akũ Kalɛ Wĩ a akũ fɔlɛtsa nɛ katinya kamɛ flee fɔnya adansiɛ fɔkpa batidziwa flee. Nɛ fukĩĩ liti a, katinya kawũna a aaya. ");
INSERT INTO bov_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ntɛ mimɔ́ Fɔtsa mɔ libe kĩ fɔakɔ Ɔmaĩ, kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Daniel lɛ foe akũ fɔlɛtsa eyi a kĩ fɔdzɛ̃ nɛ kakɔ kpalɛwa a, nɔ ovoli kĩĩ ɔkãnɛ, nu foe kayɔ dzununuunu, ");
INSERT INTO bov_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","lɔkɔa bati a kĩ bideĩ nɛ Yudea, bilo bɛnaa tɔtɔ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Oti a kĩ edeĩ nɛ kɔla ode ni, ɛtaduma ɛka kĩ yanaabɔɛ ye akũ fɔtsa ɛnɛmɛna nɛ kɔla kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ade ayea oti a kĩ edeĩ nɛ kɔba lɛmɛ, ɛtamuniki ɛya kĩ yanaabɔɛ ye atadiɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lɛmɛ bɔbɔɛ makpa bamatsɔ̃ mɔ bikĩ babi amɛmɛ nɛ awɛ nɛ lɔkɔ a na kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mibɔa mpaɛ mikpa Baguma kĩ mi kalo lɔkɔ lɛtana nɛ osili lɔkɔ ĩye Kawɛya Luwi akũ! ");
INSERT INTO bov_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kitonɛkĩ lubo kamɔ nɛ lɔkɔ a na kamɛ aana ɔsĩ lɛba lidi nyɛ lidi kĩ lɛya tɔ̃, kito katinya kayɔkayi kɛyawo nviã kĩĩ, ade de odu lɛmɛ lɛláabuki lɛya dadaada a. ");
INSERT INTO bov_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ntɛ Baguma ɛtatinya lubokamɔ fuwi a na akũ kɔkɔɛ ni, kufɛ otidziwa odima lɛláana nkpã. Lɛmɛ nɛ bati a kĩ ɛpau eyi a sũ ni, Baguma aatinya fuwi a akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Foesũ ntɛ odi bi mi kĩ, ‘Dã, Kristo deĩ nɛ awĩ,’ ĩye ‘Amɔ ye nɛ akĩĩ’ ni, mitatɛ foe mido. ");
INSERT INTO bov_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kitonɛkĩ fɔvã kristofɔ mɔ fɔvã onukpɛ̃ banyɛnɛ aanɛ, ade baakɛna nsɛntsɛlɛni mɔ awãwã fɔtsa kĩ ntɛ baapuli bɛkɛ bikĩ Baguma pau a malo. ");
INSERT INTO bov_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Midã, mbi mi fukĩĩ ĩnyamɛna lɔtɔ fɔmɔ lɔkɔ a aawo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Foesũ ntɛ bati bi mi kĩ, ‘Dã, edeĩ nɛ kɔsa kamɛ’ ni, mitanaa awã. Ade ayea ntɛ bati lɛ kĩ, ‘Dã, edeĩ nɛ kɔla kamɛ’ ni, mitatɛ foe mido. ");
INSERT INTO bov_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kitonɛkĩ Otidziwa Obi a kaya aana ndɛ ayekĩ odetɔ́ kamɛ amɔanɛ kato suwa kadekɔ̃ kanaa suwa katomukɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Awã kĩ fɔtsa kuwa deĩ ni, ade awã fɔpɛtɛ akpɔta a. ");
INSERT INTO bov_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ntɛ lubo kamɔ fuwi a na yatɛ̃ pɛ, suwa aake ɔtũ, odetɔ lɛmɛ lɛláabuki ɛvɔlɛ. Fusibii aato ode fɔtɔ ade kɔbɛ̃ fɔtsa a kĩ fudeĩ nɛ odetɔ́ kamɛ a aakuna akũ, fɔdzakũ nɛ foe kadzakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ade lɔkɔ a na kamɛ mɔ Otidziwa Obi a nsɛntsɛlɛni aanɛ nɛ odetɔ́ kamɛ, ade tite akũ bati flee aabe, ade baamɔ Otidziwa Obi a kĩ yaya nɛ luflututu akũ mɔ kɔbɛ̃ nɛ kukũkpalɛ kpale kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Baavɔ̃ kagbulɛɛ kpale a, lɔkɔa yaado ye ode fɔtɔ banyanɛ bɛnaa katinya tukonto ɛna a akũ, bɛnaakpɔta ye bati a kĩ ɛpau a kito katinya sɛkɛ kĩĩ kɛnaa sɛkɛ kĩĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mikɔlɛ fɔtsa nɛ atɔ kutse a akũ. Ntɛ kɔnɛ tɛbabi vɔɛ̃ mɔ kudo tɔɔta blɔblɔ kanɛ awɛ ni, minyina kĩ ovio lɔkɔ fuã. ");
INSERT INTO bov_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ade ayea ntɛ mimɔ́ fɔtsa a kĩ nlɛ flee a ni, minyi kĩ katinya kawũna a lɔkɔ wo ɔtɔ fuyua. ");
INSERT INTO bov_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ fɔtsa kĩĩ flee aaya nɛ foe kamɛ, fɔmɔ nviã babi kasinu kĩĩ flee aaku. ");
INSERT INTO bov_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tite mɔ ode aayatɛ̃, lɛmɛ yĩ fɔlɛtsa a kɔ̃ onukpɛ̃ lɛláatɛ̃ da. ");
INSERT INTO bov_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Odima linyína luwi ĩye dɔũhuilɛ a kĩ fɔ́aya nɛ foe kamɛ. Ode fɔtɔ banyanɛ a ĩye Obi mɔawɛ a malo linyína, mbɔɛntɛ Ɔlɛga odi keĩ nyina. ");
INSERT INTO bov_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Otidziwa Obi a kaya aana ndɛ ayekĩ fɔya nɛ Noa lɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nɛ fuwi a kĩ fɔnya mui kayili nɛ tite akũ lɔtɔ kamɛ a, bati kanya bɛkamɔa, bɛkakɔã batsɔ̃, bɛkakɔã banyole kɛnawo luwi a kĩ Noa wo nɛ adaka ɔkɔlɔ a kamɛ, ");
INSERT INTO bov_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","lɛmɛ bɛtányi lɛtsa a kĩ lɛkaya kɛnawo kĩ mui kayili a yalɔ be flee ɛnamɛna. Ade aye lɛmɛ Otidziwa Obi a kaya aana a. ");
INSERT INTO bov_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nɛ lɔkɔ a na kamɛ a, banyole nviã aakakɛna adzuma nɛ kɔba, baabɔɛ ɔmɔa bɛnamɛna, bɛfɔnɛ ɔmɔa awɛ biyi. ");
INSERT INTO bov_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Batsole nviã aakawɔlɛ onuvoe nɛ kɔwɔlɛ akũ, baabɔɛ ɔmɔa bɛfɔnɛ ɔyade a biyi. ");
INSERT INTO bov_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Foesũ mina nɛ kukũmanɛ kamɛ, kitonɛkĩ minyína luwi a kĩ de akũ mi Ɔlate a aaya. ");
INSERT INTO bov_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ntɛ kanyi tɔtɔ ɔlate nyina lɔkɔ a kĩ oyekpanɛ aawo nɛ ye akũ ni, kufɛ esi lipe kĩ ɛtákpa oyekpanɛ a osi ewo nɛ ye kɔla kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɛ foesũ mi malo mimanɛ akũ miyi, kitonɛkĩ Otidziwa Obi a aaya nɛ lɔkɔ a kĩ miádã ye anɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Foesũ owei nyɛ ɔsumunɛ ɔnɔkɔalini mɔ kadi onyinɛ? Ade ye nyɛ oti a kĩ ye ɔlate kɔa ɛdzɛla nɛ ye basumunɛ bɛbã onukpɛ̃ kĩ ɛkpa be funitsã nɛ lɔkɔ wĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bihila ɔsumunɛ a kĩ ye Ɔlate aato osi akũ ɛyaamɔ kĩ ɛlamɛna adzuma a kĩ ɛkpa ye a kakɛna! ");
INSERT INTO bov_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɔnɔkɔali mabi mi kĩ, ɔlate a aakɔa ye ɛdzɛla nɛ ye fɔtsa flee onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lɛmɛ ntɛ ɛnyɛ ɔsumunɛ kpa ni, yaabi ye akũ kĩ, ‘Yĩ ɔlate a lɛláaya mɔatsɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mɔ edo ye bakɔba basumunɛ a kabo awɛ, yanya kamɔa mɔ bavɛ bawuganɛ ni, ");
INSERT INTO bov_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ye ɔlate a aamuniki ɛya nɛ luwi a kĩ ɛtáte anɛ mɔ lɔkɔ kĩ enyína akũ. ");
INSERT INTO bov_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ye ɔlate a aablɔmɛna ye, ɛvɛlɛ ye sɔtɔ ɛfɔ̃ ɛna tsɛfã mɔ anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ. Ade awã yaabe ɛba adɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lɔkɔ a kĩ Otidziwa Obi a aaya a, Baguma lɛgãkanyakɔ̃ a aana ndɛ bayitsɔ̃ ewua kĩ bɛbɔɛ be tɛsɛdza kĩ banaatsɛlamɔ obolitsɔ̃ ɔnyɔ. ");
INSERT INTO bov_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Be elo nyɛ bakɔasia, be elo lɛmɛ nyɛ anyansãfɔ. ");
INSERT INTO bov_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kĩ badzimbifɔ a bɔɛ be tɛsɛdza a, bɛtábɔɛ kugua bibu. ");
INSERT INTO bov_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anyansãfɔ a kɔ̃ ko kugua nɛ titontolowa kamɛ bɛlɛ bibu mɔ be tɛsɛdza a. ");
INSERT INTO bov_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Obolitsɔ̃ ɔnyɔ a táya mɔatsɛ, foesũ tida bɔɛ bayitsɔ̃ a, ade bɛwa tida a. ");
INSERT INTO bov_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nɛ lɛnyɛ kayite a, binu fɔwɔla kĩ, ‘Amɔ obolitsɔ̃ ɔnyɔ a nɛ awĩ tsoo! Minɛ miyaatsɛla mɔ ye!’ ");
INSERT INTO bov_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ade bayitsɔ̃ ewua a yidza bɛtɛna be tɛsɛdza a. ");
INSERT INTO bov_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Badzimbifɔ a bi anyansãfɔ a kĩ, ‘Mikpa boe mi kugua a kudi, kitonɛkĩ boe tɛsɛdza lamɔ kadĩ.’ ");
INSERT INTO bov_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Lɛmɛ anyansãfɔ a kpa be mbuayɛ kĩ, ‘Oowo, kukĩ bɔnɛɛ a lɛláato bɔmɔ mi. Minaa bikĩ banɔ a sɛkɛ̃ minaaya mi kude.’ ");
INSERT INTO bov_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Lɛmɛ kĩ bayitsɔ̃ badzimbifɔ a dzakũ bɛnaaya kugua a, obolitsɔ̃ ɔnyɔ a yaya. Bayitsɔ̃ elo a kĩ bɛmanɛ akũ a, tomɔ ye bɛnaa obolitsɔ̃ kapikɔ̃ a, ade bɛbalɛ opunu a. ");
INSERT INTO bov_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ke liti a, bayitsɔ̃ nkaɛ a muniki bɛya, ade bɛbɔa fɔwɔla kĩ, ‘Boe Ɔlate, boe Ɔlate, binya opunu kakpa boe!’ ");
INSERT INTO bov_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Obolitsɔ̃ ɔnyɔ a kpa mbuayɛ kĩ, ‘Oowo! Nɛ ɔnɔkɔali kamɛ ni, ĩnyína mi!’ ” ");
INSERT INTO bov_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu lɛ ewũna kĩ, “Nɛ foesũ mina nɛ kukũmanɛ kamɛ, kitonɛkĩ minyína luwi ĩye dɔũhuilɛ a. ");
INSERT INTO bov_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ode lɛgãkanyakɔ̃ a la ndɛ fɔlɛtsa kĩĩ. Onyole odi manɛ akũ kĩ yanaa osi akũ. Ɛvɛ ye basumunɛ ɛkpɔta ade ɛkɔa ye fɔtsa kĩ edeĩ a edo nɛ be awɛ a. ");
INSERT INTO bov_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɛkpa odi nyɛ odi nɛ ye mbɔdibɔ onukpɛ̃. Foesũ ɛkpa oti mɔa sika ovoe mpim elo, ɛkpa ɔbɛbã mpim nviã, ade ɛkpa ɔlalɛde a apim mɔa, ɛdzakũ ɛnaa osi akũ a. ");
INSERT INTO bov_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɔsumunɛ a kĩ ɛtɛ sika mpim elo a, nadani awɛ nɛ se akũ ɛna mpim elo nfasɔ ete nɛ se akũ. ");
INSERT INTO bov_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ade ayea oti a kĩ ɛtɛ sika mpim nviã lɛmɛ nadani awɛ nɛ se akũ ɛna mpim nviã ete nɛ se akũ a. ");
INSERT INTO bov_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lɛmɛ ɔsumunɛ a kĩ ɛtɛ apim mɔa a, natu lɛkɛ ɛkɔa ye ɔlate sika a ɛkɔla nɛ de kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nɛ lɔkɔ gɛlɛɛlɛ liti a, be ɔlate a muniki ɛya, ade ɛkɛna akunta mɔ be a. ");
INSERT INTO bov_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ɔsumunɛ a kĩ ɛtɛ sika mpim elo a kɔa se mɔ mpim elo kute a ɛyamɛna ɛlɛ kĩ, ‘Boe Ɔlate, sika mpim elo a kĩ ɔkpa yĩ a, dã nna mpim elo bɛbã nte nɛ se akũ.’ ");
INSERT INTO bov_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ye ɔlate a bi ye kĩ, ‘Mbo, ɔsumunɛ wĩ mɔ ɔnɔkɔalini! Odi ɔnɔkɔali nɛ fɔtsa kabii akũ, foesũ maakɔa nɔ ndzɛla nɛ fɔtsa pii onukpɛ̃. Yaawo nɛ yĩ kawɔlɛkamɔ kamɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ɔsumunɛ a kĩ ɛtɛ sika mpim nviã a lɛmɛ yalɛ kĩ, ‘Boe Ɔlate, ɔkpa yĩ sika mpim nviã. Dã, nna mpim nviã bɛbã kute nte nɛ se akũ.’ ");
INSERT INTO bov_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ye ɔlate bi ye kĩ, ‘Mbo, ɔsumunɛ wĩ mɔ ɔnɔkɔalini! Odi ɔnɔkɔali nɛ fɔtsa kabii akũ foesũ maakɔa nɔ ndzɛla nɛ fɔtsa pii onukpɛ̃. Yaawo nɛ yĩ kawɔlɛkamɔ kamɛ!’ ");
INSERT INTO bov_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ade oti a kĩ ɛtɛ sika apim mɔa a yabi ye kĩ, ‘Ɔnɔkɔɛ̃, ĩnyina nɔ kĩ oti mɔ ɔsĩ anɛ. Ana fɔtsa nɛ awã kĩ ɔtádu foe, ade akpɔta funitsã nɛ awã kĩ ɔtádu foe a. ");
INSERT INTO bov_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nɛ foesũ nvila, ade nnakɔa nɔ sika a nnabila nɛ tite kamɛ a. Amɔ nɔ fɔtsa nɛ awĩ.’ ");
INSERT INTO bov_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ye ɔlate kpa ye mbuayɛ kĩ, ‘Nɔ ɔsumunɛ kpa mɔ ɔnyɔnɛpo! Ntɛ onyina kĩ mana fɔtsa nɛ awã kĩ ntádu foe, ade makpɔta fɔtsa nɛ awã kĩ ntásã foe a ni, ");
INSERT INTO bov_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kufɛ kakɔa akɔa sika a ɔnaado nɛ sika kakɔlakɔ̃ ayekĩ ntɛ mmuniki ĩya, maatɛ se mɔ se akũ kute a. ");
INSERT INTO bov_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Mitɛ sika a nɛ ye awɛ, mikɔa se mikpa oti a kĩ edeĩ sika mpim ewua a. ");
INSERT INTO bov_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kitonɛkĩ odi nyɛ odi kĩ edeĩ fɔtsa ni, baakɔa fɔtsa pii bibu ye, ade yaana foe fublusu a. Lɛmɛ oti a kĩ ɛlá lɛtsama ni, foe kabii a kĩ edeĩ a malo baatɛ foe nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ɔsumunɛ kĩ ye akũ lɛlá nfasɔ kĩĩ lɛnɛ́nɛ ɛkpa lɛtsama kakɛna. Foesũ mita ye mimuni nɛ ɔtũ kamɛ. Ade awã yaana ebe ɛba adɔ̃ a.’ ");
INSERT INTO bov_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ntɛ Otidziwa Obi a to ode ɛya nɛ ye kukũkpalɛ kamɛ, kĩ ode fɔtɔ banyanɛ flee a tomɔ ye a, yaadzi nɛ ye lɛgãkpo a akũ. ");
INSERT INTO bov_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ade baakpɔta katinya kamɛ bati flee nɛ ye anɛ kamɛ a. Adeke, yaasɛ̃ be nɛ kutsu nviã kamɛ ndɛ ayekĩ baveli ɔkpãnɛ asɛ̃ baveli mɔ kutukpabi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yaakɔa bati wĩ a ɛdzala nɛ ye sɔmɔna, lɔkɔa bati kpa a anna nɛ ye sɛba. ");
INSERT INTO bov_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Lɛgã a aabi bati nɛ ye sɔmɔna a kĩ, ‘Miya, mi a kĩ Nda hila a. Miyaawo nɛ lɛgã kanyakɔ̃ a kĩ bɛmanɛ biyi bɛkpa mi a kamɛ, kito anɛ kĩ bɛbɔa katinya kamɛ a, ");
INSERT INTO bov_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kitonɛkĩ kĩ kɔlɛ kɔ yĩ a, mikpa yĩ litsedi ĩnya. Kĩ ɔmɔado kɔ̃ yĩ a, mikpa yĩ mui mmɔa, ade kĩ ĩnyɛ ɔnɔvɔɛ̃ a, mitɛ yĩ nɛ mi tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kĩ ndzi ɔdzɔ a, mido yĩ atadiɛ, kĩ masɔ a midã yĩ akũ, ade kĩ nwaa kɔla a, miyasɛla yĩ.’ ");
INSERT INTO bov_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ade bati wĩ a aavia ye kĩ, ‘Boe Ɔlate, luwei bɔmɔ́ nɔ kĩ kɔlɛ kɔ nɔ mɔ bɔkpa nɔ funitsã, ĩye kĩ ɔmɔado kɔ nɔ mɔ bɔkpa nɔ mui ɔmɔa? ");
INSERT INTO bov_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Luwei bɔmɔ́ nɔ ɔnɔvɔɛ̃ mɔ bɔtɛ nɔ nɛ tɔtɔ kamɛ, ĩye luwei ɔtsã ɔdzɔ mɔ bɔkpa nɔ atadiɛ odo? ");
INSERT INTO bov_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Luwei ɔsɔ mɔ bɔdã nɔ akũ, ĩye luwei ɔwa kɔla mɔ bɔyasɛla nɔ?’ ");
INSERT INTO bov_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Lɛgã a aakpa be mbuayɛ kĩ, ‘Mabi mi nɛ ɔnɔkɔali kamɛ kĩ lɛtsa nyɛ lɛtsa kĩ mikɛna mikpa nwaɛ̃ amɛ babisɛ̃ kĩĩ kĩ bɛlá obu a kamɛ odi ni, yĩ mikɛna foe mikpa!’ ");
INSERT INTO bov_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Adeke mɔ Lɛgã a aabi bikĩ nɛ ye sɛba a kĩ, ‘Minɛ liti nɛ yĩ akũ, mi bati kĩ Baguma dumu! Mitɔ minaa fi kĩ fɔádĩ da a kĩ bɛmanɛ bɛkpa Abonsam mɔ ye ode fɔtɔ banyanɛ a kamɛ! ");
INSERT INTO bov_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kɔlɛ kɔ yĩ lɛmɛ mitákpa yĩ ĩnya, ɔmɔado kɔ yĩ lɛmɛ mitákpa yĩ mui mmɔa. ");
INSERT INTO bov_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ĩnya ɔnɔvɔɛ̃ lɛmɛ mitátɛ yĩ nɛ mi tɔtɔ kamɛ. Ndzi ɔdzɔ lɛmɛ mitádo yĩ atadiɛ. Nsɔ mitádã yĩ akũ, ade nwa kɔla lɛmɛ mitáyaasɛla yĩ a.’ ");
INSERT INTO bov_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ade be malo baakpa mbuayɛ kĩ, ‘Boe Ɔlate, luwei tɔ̃ kɔlɛ kɔ nɔ, ĩye ɔmɔado kɔnɔ, ĩye ɔnya ɔnɔvɔɛ̃, ĩye odzi ɔdzɔ, ĩye ɔsɔ, ĩye kĩ ɔwa kɔla mɔ bɔtákɛna lɛtsama bɔkpa nɔ?’ ");
INSERT INTO bov_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Lɛgã a aakpa be mbuayɛ kĩ, ‘Mabi mi nɛ ɔnɔkɔali kamɛ kĩ lɛtsa nyɛ lɛtsa kĩ mitákɛna mikpa nwaɛ̃ amɛ babisɛ̃ kĩ bɛlá obu kĩĩ kamɛ odi ni, yĩ mitákɛna foe mikpa.’ ");
INSERT INTO bov_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Foesũ baanamɔ bati kĩĩ lubokamɔ a kĩ lɛlá kawũna a kamɛ, lɛmɛ bati wĩ a aanaa nkpã kĩ ɛlá kawũna a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kĩ Yesu lɛ fɔlɛtsa kĩĩ flee eyua a, ebi ye fɔtsa bakɔlɛnɛ a kĩ, ");
INSERT INTO bov_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Minyina kĩ kite fuwi nviã kĩ banya Wuda Katɛ̃ luwi a. Nɛ fuwi a na kamɛ, baanyɛ Otidziwa Obi a bɛkpa kĩ bɛbɔa ye nɛ asendua akũ.” ");
INSERT INTO bov_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ade basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a tsɛna nɛ Ɔsɔfɔnɔkɔɛ̃ Flee Kaiafa tɔtɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bɛkɛna nhihiɛ kĩ baapi Yesu nɛ kabɛla kamɛ lɔkɔa bɛkɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bɛlɛ kĩ, “Kɛtánɛ kĩ bɔakɛna foe nɛ fuwi kanya a kamɛ, ntɛ nnɛ́ aye ni, bati a aado ɔtutũ nɛ ɔmaĩ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu naa Simon kĩ ɛsɔ tɔ̃ fɔsɔ ngbã a awã nɛ Betania. ");
INSERT INTO bov_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lɔkɔ a kĩ Yesu dzi nɛ opunu akũ ɛkanya a, otsole odi kĩ ɛnɛɛ tumpã mɔ kalɛ, kĩ eyi mɔ kugua mɔ ɔlɛ̃ yatsokui kugua eko nɛ Yesu lɔlɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kĩ fɔtsa bakɔlɛnɛ a mɔ́ fukĩĩ a, bɛna kalɔkpa ade bivia kĩ, “Nde sũ yabula kugua a kade lɔmɔ? ");
INSERT INTO bov_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Baapuli bɛnɔ koe mɔ kɔya baũ lɔkɔa bɛkɔa se bite ahiãfɔ!” ");
INSERT INTO bov_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu nu lɛtsa a kĩ bɛkalɛ a, foesũ ebi be kĩ, “Nde sũ miaha otsole kĩĩ? Ɛkɛna fɔtsa wĩ ɛkpa yĩ. ");
INSERT INTO bov_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ahiãfɔ deĩ nɛ mi kamɛ daa, lɛmɛ yĩ kɔ̃ miláana yĩ nɛ mi kamɛ daa. ");
INSERT INTO bov_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lɛtsa a kĩ otsole kĩĩ kɛna nyɛ kĩ eko kugua nɛ yĩ akũ ɛkɔa ɛmanɛ yĩ ɛkpa kabila. ");
INSERT INTO bov_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ kakɔ nyɛ kakɔ kĩ baade lɛtsã nɛ Kalɛ Wĩ a akũ ni, baalɛ lɛtsa a kĩ otsole a kɛna a lɛmɛ, bɛkɔa bɛkai ye.” ");
INSERT INTO bov_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Adeke fɔtsa bakɔlɛnɛ a ewua-nviã kamɛ ɔmɔa kĩ bavɛ Yuda Iskariot a naa basɔfɔnɔkɔɛ̃ a sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ɛnavia be kĩ, “Litsa míakpa yĩ ntɛ ntsa ye liti osi?” Bɛkã sika ovoe fɔbɔ taalɛ bido nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kito lɔkɔ a naa, ɛkawɛ osi wĩ a kĩ yaatsã ɛnyɛ Yesu ɛkpa. ");
INSERT INTO bov_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nɛ Abodoo Kĩ Ɛtáyila Luwi kanya lɔtɔnyade akũ a, fɔtsa bakɔlɛnɛ a ya nɛ Yesu sɛkɛ̃ bivia ye kĩ, “Nɛ ndia awɛ kĩ bɔnaamanɛ bɔkpa nɔ Wuda Katɛ̃ funitsã a kanya?” ");
INSERT INTO bov_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɛkpa be mbuayɛ kĩ, “Minaa ɔmatɔ a kamɛ nɛ onyole odi sɛkɛ̃, mibi ye kĩ, ‘Fɔtsa Ɔtsanɛ bo yĩ lɔkɔ fuã, foesũ bɔmɔ yĩ fɔtsa bakɔlɛnɛ a bɔ́ayanya Wuda Katɛ̃ funitsã a nɛ nɔ awã.’ ” ");
INSERT INTO bov_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Fɔtsa bakɔlɛnɛ a kɛna ndɛ ayekĩ Yesu bi be a, ade bɛtɔ Wuda Katɛ̃ funitsã a. ");
INSERT INTO bov_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kĩ olobe wo ɔtɔ a, Yesu mɔ fɔtsa bakɔlɛnɛ a nadzi kĩ banya. ");
INSERT INTO bov_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nɛ kanyakɔ̃ a, Yesu bi be kĩ, “Mabi mi pipiipi kĩ mi kamɛ ɔmɔa aanyɛ yĩ ɛkpa.” ");
INSERT INTO bov_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Fɔha fɔtsa bakɔlɛnɛ a paa, ade bivia ye ɔmɔa ɔmɔa kĩ, “Boe Ɔlate, yĩ manɛ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kpa mbuayɛ kĩ, “Oti a kĩ bɔmɔ ye awɛ kpɔta nɛ sɔɔdaɛ kamɛ a, ade ye aanyɛ yĩ ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Otidziwa Obi a aaku ndɛ ayekĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ, lɛmɛ bɔbɔɛ makpa oti a kĩ ye aanyɛ Otidziwa Obi a ɛkpa! Ntɛ bɛtama oti a na malo, kufɛ fɔnɛnɛ fɔkpa ye fɔbɛ̃!” ");
INSERT INTO bov_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ade Yuda a kĩ ɛnyɛ ye ɛkpa a lɛmɛ via kĩ, “Fɔtsa Ɔtsanɛ, yĩ manɛ mbɔɛɛ?” Yesu kpa ye mbuayɛ kĩ, “Nɔ mɔawɛ lɛlɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kĩ bɛkanya a, Yesu bɔɛ abodoo, ade kĩ ɛbɔa mpaɛ nɛ ye akũ a, ebulibuli ye ɛkpa ye fɔtsa bakɔlɛnɛ a, ebi be kĩ, “Mitɛ minya, ade yĩ sukɛna nɛ awĩ a.” ");
INSERT INTO bov_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ke liti a, ɛbɔɛ okuluwa mɔ waĩ ɛnyɛ Baguma kɔlɛ ade ɛkɔa ɛkpa be a. Ebi be kĩ, “Mi flee mitɛ mimɔa. ");
INSERT INTO bov_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Fukĩĩ nyɛ yĩ babɔanɛ kĩ bɛkɔa bisipi Baguma apam mɔ bati a. Fɔnyɛ yĩ babɔanɛ kĩ biko nɛ tite nɛ bati pii lɔlɔ kĩ Baguma ɛkɔa be tɔkpa ete be. ");
INSERT INTO bov_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mabi mi kĩ nláabuki mmɔa waĩ kĩĩ kɛnaawo luwi a kĩ bɔmɔ mi bɔmɔa waĩ vɔɛ̃ nɛ Nda Lɛgã kanyakɔ̃ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kĩ bɛsã kɔlɛkanyɛ ɔnɔ biyua a, bɛnɛ bɛnaa Kugua Futse Ɔtɔ a akũ. ");
INSERT INTO bov_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ade Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Nviã lɛnyɛ, mi flee míalo mifɔnɛ yĩ, kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Baguma aakɔ baveli ɔkpãnɛ a ade baveli a aagba bɛsã a.’ ");
INSERT INTO bov_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lɛmɛ ntɛ Baguma dzɛla yĩ ndzi nkpã ni, maanya mi lɔtɔ nnaa Galilea.” ");
INSERT INTO bov_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro bi Yesu kĩ, “Ntɛ be flee aalo bɛfɔnɛ nɔ malo ni, yĩ kɔ̃ nláalo nfɔnɛ nɔ da!” ");
INSERT INTO bov_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ade Yesu bi Petro kĩ, “Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ lɛnyɛ kĩĩ fɔmɔ ɔkɔkɔ aabe ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” ");
INSERT INTO bov_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro kpa mbuayɛ kĩ, “Nláalo nfɔnɛ nɔ da ntɛ kɛnɛ kĩ bɔmɔ nɔ aaku malo!” Ade ayea fɔtsa bakɔlɛnɛ nkaɛ a flee lɛ kalɛ mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu mɔ ye fɔtsa bakɔlɛnɛ a naa kakɔ kadi kĩ bavɛ Getsemane. Ebi be kĩ, “Midzi nɛ awĩ nnaa lɔtɔ nnaabɔa mpaɛ tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɛkpã Petro mɔ Zebedeo babi nviã ebumɔ ye akũ. Nɛ awã naa, ayɔlɔhɔ pi ye edo ɛkatila bliblibli awɛ, ");
INSERT INTO bov_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ade ebi be kĩ, “Ayɔlɔhɔ tɛ yĩ kamɛ flee ndɛ maku. Midzi nɛ awĩ bɔmɔ mi bɔkaadzɔlɛ fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kĩ ɛnaa lɔtɔ sukuloo a, ɛtsa anɛ nɛ tite ɛbɔa mpaɛ kĩ, “Nda, ntɛ fɔ́adã bɔɛɛ fɔ̃ lubo kamɔ kɔɔpu kĩĩ ɛtɛ̃ nɛ yĩ akũ! Lɛmɛ nnɛ́ nɛ ayekĩ mawɛ, mbom ndɛ ayekĩ awɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Emuniki ɛya nɛ fɔtsa bakɔlɛnɛ ɛlalɛ a sɛkɛ̃ ɛyamɔ kĩ bɛwaa tida, ade ebi Petro kĩ, “Nde sũ mi ɛlalɛ a miápuli midzi midzɔlɛ dɔũhuilɛ mɔapɛ malo mibumɔ yĩ? ");
INSERT INTO bov_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mikaadzɔlɛ akũ, mikaabɔa mpaɛ ayekĩ miláawo nɛ sɔhuiɛ kamɛ. Hũhũ a awɛ lɛmɛ sukɛna a kɔ̃ kɛna kpɛtɛɛ.” ");
INSERT INTO bov_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu buki ɛnaa lɛyade ɛnabɔa mpaɛ ɛlɛ kĩ, “Nda, ntɛ fɔnyɛ kĩ lubo kamɔ kɔɔpu kĩĩ lɛláapuli ɛtɛ̃ nɛ yĩ akũ mbɔɛntɛ mmɔa ye ni, kekɔ̃ kɛna nɛ nɔ kawɛ akũ.” ");
INSERT INTO bov_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ebuki ɛya ɛyamɔ fɔtsa bakɔlɛnɛ kĩ bɛwa tida, kĩ bɛtápuli bibinya anɛ. ");
INSERT INTO bov_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu dzakũ ɛfɔnɛ be ɛnabɔa mpaɛ lɛlade, ɛlɛ fɔlɛtsa mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ke liti a, emuniki ɛyabi ye fɔtsa bakɔlɛnɛ a kĩ, “Tida miwaa miawɛya? Midã, lɔkɔ a wo ɔtɔ kĩ baakɔa Otidziwa Obi a bido nɛ tɔkpa bakɛnanɛ kɔbɛ̃ awɛ. ");
INSERT INTO bov_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Miyidza, mifɔ̃ bɔnaa. Midã, oti a kĩ yaanyɛ yĩ ɛkpa a, fuã.” ");
INSERT INTO bov_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kĩ Yesu buki ɛkalɛ kɔdzɛla a, Yuda kĩ ɛnyɛ fɔtsa bakɔlɛnɛ ewua-nviã a kamɛ ɔmɔa a yawo awã. Bati kɔdabu baũ a kĩ basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ do a tomɔ ye, bɛnɛɛ fɔpamɛ mɔ futsekpa nɛ awɛ. ");
INSERT INTO bov_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Oti a kĩ ɛnyɛ ye ɛkpa a, kpa be nsɛntsɛlɛni kĩ, “Oti a kĩ ye onukpɛ̃ maadzɛmɛ a, ade ye nɛ awã a. Mipi ye.” ");
INSERT INTO bov_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda yɛlɛ tĩĩ ɛnaa Yesu sɛkɛ̃ ade ɛlɛ kĩ, “Fɔtsa Ɔtsanɛ, lukudɔ litomɔ nɔ,” ade ɛdzɛmɛ ye onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kpa ye mbuayɛ kĩ, “Ɔkɔba, wɛ sɔwa nɛ lɛtsa a kĩ ɔyaakɛna a akũ.” Adeke bati a fuã bipi Yesu, bitimtim ye kɔɔba a. ");
INSERT INTO bov_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bati a kĩ bitomɔ Yesu a kamɛ ɔmɔa vɛlɛ kɔpã ɛnyɛ nɛ sɛpapo kamɛ, etsua Ɔsɔfɔnɔkɔɛ̃ Flee a ɔsumunɛ sɔtɔ emuni. ");
INSERT INTO bov_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu bi ye kĩ, “Kɔa nɔ kɔpã a kado nɛ koe kadokɔ̃, kitonɛkĩ odi nyɛ odi kĩ ɛbɔɛ kɔpã nɛ oti akũ ni, kɔpã onukpɛ̃ yaatɔ. ");
INSERT INTO bov_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mbɔɛɛ onyína kĩ kufɛ maapuli nwã Nda kĩ ɛyaabumɔ yĩ, kĩ lɛtalɛta yaado ode fɔtɔ banyanɛ sodzafɔ kĩ bɛbɛ̃ kutsu ewua-nviã bɛya? ");
INSERT INTO bov_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lɛmɛ ntɛ fɔya lɔmɔ ni, nde fɔlɛtsa a kĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ a kĩ kɛnɛ kĩ fɔya a, aaya nɛ foe kamɛ?” ");
INSERT INTO bov_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ke liti a, Yesu via bati kɔdabu a kĩ, “Nde sũ minɛɛ apã mɔ futsekpa kĩ miayaapi yĩ ndɛ oyekpanɛ aye? Luwi daa madzi nɛ Asɔli Kɔla kamɛ katsa fɔtsa, lɛmɛ mitápi yĩ. ");
INSERT INTO bov_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lɛmɛ fukĩĩ flee ya nɛ foe kamɛ, ayekĩ fɔlɛtsa a kĩ Baguma onukpɛ̃ banyɛnɛ a tsɛlɛ biyi a, aaya nɛ foe kamɛ.” Ade awã naa mɔ ye fɔtsa bakɔlɛnɛ a flee lo bɛfɔnɛ ye a. ");
INSERT INTO bov_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bati a kĩ bipi Yesu a, kɔa ye bɛnamɛna Ɔsɔfɔnɔkɔɛ̃ Flee Kaiafa sɛkɛ̃, awã kĩ mbla batsanɛ mɔ banɔkɔɛ̃ a natsɛna. ");
INSERT INTO bov_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro tomɔ be nɛ liti kɔlaa ɛnawo nɛ Ɔsɔfɔnɔkɔɛ̃ Flee a tɔtɔ kamɛ. Ewo ɛnadzi kĩ yadã fɔlɛtsa a kĩ fɔya a kawũna. ");
INSERT INTO bov_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basɔfɔnɔkɔɛ̃ mɔ Fɔlɛtsa Badzɛnɛ a flee wɛ kĩ bama fɔvã bite nɛ Yesu akũ ayekĩ baakɔ ye. ");
INSERT INTO bov_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Titɔ kĩ bati pii nɛ bɛyama fɔvã nɛ ye akũ malo ni, bɛtámɔ lɛtsama nɛ ye akũ. Nɛ ke kawũna kamɛ a, bati nviã nɛ bɛyadza, ");
INSERT INTO bov_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ade bɛlɛ kĩ, “Onyole kĩĩ lɛ kĩ, ‘Maapuli nveli Asɔli Kɔla a, mbuki nke koe nɛ fuwi ɛlalɛ liti.’ ” ");
INSERT INTO bov_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ɔsɔfɔnɔkɔɛ̃ Flee a yidza ɛdza, evia Yesu kĩ, “Ɔláanyɛ onukpɛ̃ nɛ fɔlɛtsa a kĩ bɛbɔɛ nɛ nɔ akũ a akũ?” ");
INSERT INTO bov_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lɛmɛ Yesu tábinya onukpɛ̃. Ade Ɔsɔfɔnɔkɔɛ̃ Flee a buki ebi ye kĩ, “Ntani Baguma kĩ edzi nkpã a kĩ, bi boe ntɛ nɔ nyɛ Kristo, Baguma Obi a.” ");
INSERT INTO bov_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kpa ye mbuayɛ kĩ, “Ade aye ɔlɛ a. Lɛmɛ mabi mi kĩ kito finyaa kanaa ni, míamɔ Otidziwa Obi a kĩ edzi nɛ Baguma Kpale sɔmɔna, ade yaya nɛ ode luflututu akũ a!” ");
INSERT INTO bov_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mɔ ye onukpɛ̃ katɔ pɛ, Ɔsɔfɔnɔkɔɛ̃ Flee a yɛlɛ ye atadiɛ ɛlɛ kĩ, “Onyole kĩĩ lɛ fubusuotsa! Bɔtábuki busĩ adansifɔ badima! Minu fubusuotsa a kĩ ɛlɛ a! ");
INSERT INTO bov_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Litsa nyɛ mi kakɔna?” Bɛkpa mbuayɛ kĩ, “Eku kɔtɔ, foesũ kɛnɛ kĩ bɛkɔ ye.” ");
INSERT INTO bov_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Adeke bitua tanɛ biko nɛ ye anɛ kamɛ, bɛtalɛ ye fukpeni, ade badi lɛmɛ balɛ balɛ ye tɔlɔtɔ, ");
INSERT INTO bov_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ade bivia ye kĩ, “Kristo, ntɛ ɔnyɛ Baguma onukpɛ̃ ɔnyɛnɛ ni, bi boe oti a kĩ ɛbɔa nɔ!” ");
INSERT INTO bov_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kĩ Petro dzi nɛ lɔwabe a, Ɔsɔfɔnɔkɔɛ̃ Flee a ɔsumunɛtsole mɔa ya nɛ ye sɛkɛ̃ ɛlɛ kĩ, “Nɔ malo otomɔ Yesu Galileani a.” ");
INSERT INTO bov_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lɛmɛ Petro sĩ nɛ bati a flee anɛ ɛlɛ kĩ, “Ĩnyina lɛtsama nɛ lɛtsa a kĩ alɛ a akũ.” ");
INSERT INTO bov_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kĩ eyidza ɛtsã onyukpɛ̃ yanɛ nɛ kanya a, katsolebi ɔsumunɛ bɛbã mɔ ye, ade ebi bikĩ bɛdzɛ̃ nɛ awã kĩ, “Onyole kĩĩ lɛmɛ na nɛ Yesu Galileani a sɛkɛ̃ tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petro buki esĩ ɛlɔ fubo ɛlɛ kĩ, “Ĩnyína onyole a na!” ");
INSERT INTO bov_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Owi tábuna mɔ banyole a kĩ bɛdzɛ̃ nɛ awã ya nɛ Petro sɛkɛ̃ bibi ye kĩ, “Ɔnɔkɔali fɔanɛ kĩ nɔ malo ɔnyɛ be kamɛ ɔmɔa, kitonɛkĩ nɔ kɔdzɛla kalɛ kamɛ nyɛ nɔ kanya!” ");
INSERT INTO bov_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Awã naa, Petro do kadumu awɛ, katani fɔtsa kĩ, “Ɔnɔkɔali malɛ. Baguma ɛvɛlɛ yĩ sɔtɔ ntɛ fɔvã mama. Ĩnyina oti a na!” Deedimɔapɛ ɔkɔkɔ be. ");
INSERT INTO bov_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Adeke mɔ Petro kai fɔlɛtsa a kĩ Yesu bi ye a kĩ, “Fɔmɔ ɔkɔkɔ aabe ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” Ade ɛnɛ ɛnaa kanya ɛnabe a. ");
INSERT INTO bov_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nɛ odenyinawi a, basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a flee tsa fɔlɔ bipi adzuni kĩ baaakɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bisui ye bɛkpã ye bɛnakɔa bido nɛ Roma Abãã Ɔnɔkɔɛ̃, Pilato awɛ. ");
INSERT INTO bov_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kĩ Yuda, kĩ ɛnyɛ Yesu ɛkpa a, mɔ́ kĩ bɛkɔ Yesu kɔtɔ a, fuwo ye kalɔɛ ade ɛkɔa sika ovoe fɔbɔ taalɛ a ɛma basɔfɔnɔkɔɛ̃ mɔ banɔkɔɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ebi be kĩ, “Nkɛna tɔkpa, kĩ ĩnyɛ oti kĩ mfumsu adima lɛláa ye akũ nkpa kĩ bɛkɔ.” Ade bɛkpa ye mbuayɛ kĩ, “Fukĩnaa lɛtsɛ́la boe. Nɔ kalɛ kanɛ!” ");
INSERT INTO bov_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ade Yuda talɛ sika fɔbɔ taalɛ a eko nɛ Asɔli Kɔla a kamɛ, ɛdzakũ ɛnado ye akũ ɔwɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Basɔfɔnɔkɔɛ̃ a nafila sika a bɛlɛ kĩ, “Sika kĩĩ nyɛ babɔanɛ kaya sika, boe mbla tákpa osi kĩ bɛkɔa se bido nɛ Asɔli Kɔla sika adakã kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","foesũ bipi adzuni nɛ se akũ, ade bɛnaya Fubui Ɔmɛnɛ Tite kĩ tɛnya banɔvɔɛ̃ kabilakɔ̃. ");
INSERT INTO bov_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɛ foesũ kɛyawo nviã bavɛ awã kĩ, Babɔanɛ Tite. ");
INSERT INTO bov_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ade Baguma Onukpɛ̃ Ɔnyɛnɛ Yeremia fɔlɛtsa a kĩ ɛlɛ eyi a ya nɛ foe kamɛ kĩ, “Bɛkɔa sika ovoe fɔbɔ taalɛ a kĩ Israel tunɔ baase nɛ ye lɔlɔ a, ");
INSERT INTO bov_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bɛya fubui ɔmɛnɛ tite ndɛ ayekĩ boe Ɔlate wɛ kĩ nkɛna a.” ");
INSERT INTO bov_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bɛfɔ̃ Yesu dza nɛ Romafɔ Abãã Ɔnɔkɔɛ̃ a anɛ. Ade Ɔnɔkɔɛ̃ a via ye kĩ, “Nɔ nyɛ Yudafɔ lɛgã a mbɔɛɛ?” Yesu kpa mbuayɛ kĩ, “Nɔ lamɔ kalɛ.” ");
INSERT INTO bov_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kĩ Yudafɔ basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a katsua ye onukpɛ̃ malo ni, Yesu tálɛ kadima. ");
INSERT INTO bov_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Adeke Pilato via ye kĩ, “Aánu fɔlɛtsa a kĩ bɛlamɔ kate nɛ nɔ akũ flee a?” ");
INSERT INTO bov_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lɛmɛ Yesu sĩ ɛtákpa kalɛ mɔapɛ malo mbuayɛ, foesũ fɔkɛna Abãã Ɔnɔkɔɛ̃ a wãwã paa. ");
INSERT INTO bov_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nɛ Wuda Katɛ̃ luwi lidi nyɛ lidi kanya kamɛ ni, Abãã Ɔnɔkɔɛ̃ a awɛ kɔla bawanɛ a kamɛ ɔmɔa, kĩ bati kɔdabu a awɛ a, awɛ kafɔnɛ kakpa be. ");
INSERT INTO bov_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nɛ lɔkɔ a kamɛ a, onyole odi kĩ bavɛ Baraba, kĩ ɛtɛ dĩ nɛ fɔtsa kpa kakɛna kamɛ waa kɔla. ");
INSERT INTO bov_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Foesũ kĩ bati kɔdabu a kpɔta a, Pilato via be kĩ, “Owei miawɛ kĩ nfɔnɛ awɛ nkpa mi? Yesu Baraba mbɔɛɛ kĩ Yesu a kĩ bavɛ Kristo a?” ");
INSERT INTO bov_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kitonɛkĩ Pilato nyina pefee kĩ lineke kanɔ sũ Yudafɔ banɔkɔɛ̃ a kpã Yesu bɛyado nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kĩ Pilato dzi nɛ fɔlɛtsa kadzɛ lukpo kamɛ a, ɔtsɔ̃ do lɔtɔ bɛyabi ye kĩ, “Takɛna oti kpĩĩ a na lɛtsama, kitonɛkĩ kadzɔ lɛnyɛ mmɔ́ lubo paa nɛ kɔda kamɛ nɛ ye sũ.” ");
INSERT INTO bov_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a fɔ̃ bati kɔdabu a wã Pilato kĩ ɛfɔnɛ Baraba awɛ lɔkɔa bɛkɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ade Pilato via bati a kĩ, “Bati nviã a kamɛ ɔwɔdabe miawɛ kĩ nfɔnɛ awɛ nkpa mi?” Bɛkpa mbuayɛ kĩ, “Baraba!” ");
INSERT INTO bov_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato via be kĩ, “Lɔkɔa litsa nkamɔ Yesu kĩ bavɛ Kristo a?” Be flee bɛkpa mbuayɛ kĩ, “Bɔa ye nɛ asendua akũ!” ");
INSERT INTO bov_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ade Pilato via be kĩ, “Litsa tɔkpa ɛkɛna?” Ade bido fɔwɔla kabɔa kɔɔba awɛ kĩ, “Bɔa ye nɛ asendua akũ!” ");
INSERT INTO bov_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kĩ Pilato mɔ́ kĩ lɛtsama kakɛna buki lɛláa, mbom ɔtutũ aaya sũ ni, ɛbɔɛ mui ɛvɔlɛ awɛ nɛ bati kɔdabu a anɛ ɛlɛ kĩ, “Yĩ akpɔ mɔ abɔa lɛláa onyole kĩĩ wuda kamɛ!” ");
INSERT INTO bov_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bati kɔdabu a flee kpa mbuayɛ yoo kĩ, “Ye babɔanɛ a bɛya nɛ boe mɔ boe babi akũ!” ");
INSERT INTO bov_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Adeke Pilato fɔnɛ Baraba awɛ ɛkpa be a, ade kĩ ɛfɔ̃ bibo Yesu mɔ mple biyua a ɛkɔa ye ɛkpa kĩ bɛnaabɔa ye nɛ asendua akũ. ");
INSERT INTO bov_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ade abãã ɔnɔkɔɛ̃ a sodzafɔ kpã Yesu bɛnamɛna Pilato lɔwabe ade sodzafɔ katsu a flee yadza bisinya Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɛnyɛ ye tɛtadiɛ nɛ ye akũ ade bɛkɔa atadiɛ wulaa ngbã bido ye a. ");
INSERT INTO bov_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bɛkɔa fɔtsɔlɛwɛ bɛnɔ lɛgãbɔɛ bɛtsa ye, ade bɛkɔa otse bido nɛ ye sɔmɔna awɛ a. Bɛkake aduli nɛ ye anɛ kadi ye nsekuo kĩ, “Yiiduu! Yudafɔ lɛgã a edzi nkpã daa!” ");
INSERT INTO bov_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bitua tanɛ biko nɛ ye akũ, bɛtɛ otse a nɛ ye awɛ biwula ye nɛ lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kĩ bidi ye nsekuo lɔmɔ biyua a, bɛnyɛ atadiɛ wulaa a nɛ ye akũ bɛbɔɛ ye mɔawɛ tide a bibuki bido ye. Ke liti bɛkpã ye bɛnɛmɛna kĩ banaabɔa ye nɛ asendua akũ. ");
INSERT INTO bov_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kĩ bɛnɛ banaa a, bɛtsɛlamɛna onyole odi kĩ bavɛ Simon, kĩ eto Kirene. Sodzafɔ a hɛ ye kĩ ɛlɔ Yesu asendua a. ");
INSERT INTO bov_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ade bɛyawo kakɔ kadi kĩ bavɛ Golgata, kĩ foe kayɔ nyɛ Oti Lɔlɔ Fɔtsɔ̃. ");
INSERT INTO bov_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ade awã bɛkpa ye waĩ kĩ bɛtsɛka mɔ otsonu mɔ ɔnyɛ kĩ ɛmɔa a, lɛmɛ kĩ ɛta be onukpɛ̃ ɛdã a, esĩ be kamɔa. ");
INSERT INTO bov_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kĩ sodzafɔ a bɔa ye bɛmɛna nɛ asendua akũ biyua a, bɛta bavulibi nɛ ye tɛtadiɛ akũ, bɛsɛ̃ bɛkpa akũ. ");
INSERT INTO bov_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ke liti a, bɛkɛna akũ bidzi nɛ awã bɛkadzɔlɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ade bɛtsɛlɛ ye onukpɛ̃ katsua fɔlɛtsa nɛ ye lɔlɔ nyangɛ kĩ, “Ade Yesu Yudafɔ Lɛgã a nɛ awĩ a.” ");
INSERT INTO bov_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɛbɔa bayekpanɛ nviã lɛmɛ bɛmɛna nɛ asendua akũ bibumɔ Yesu, ɔmɔa nɛ ye sɔmɔna, ɔyade nɛ ye sɛba. ");
INSERT INTO bov_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bati a kĩ bɛtsã awã batɛ̃ a, kakpɔkpa fɔlɔ, kata fuvũnatsa kamɛna Yesu, ");
INSERT INTO bov_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ade bɛkalɛ kĩ, “Nɔ a kĩ ɔlɛ kĩ aaveli Asɔli Kɔla a, lɔkɔa obuki oke koe nɛ fuwi ɛlalɛ kamɛ a, tɛ nɔ akũ! Ntɛ Baguma Obi anɛ ni, duma nɛ asendua a akũ!” ");
INSERT INTO bov_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ade ayea lɛmɛ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ mɔ ɔmaĩ banɔkɔɛ̃ a di Yesu nsekuo kĩ, ");
INSERT INTO bov_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ɛtɛ bati bɛbã nkpã, lɛmɛ yaápuli ɛtɛ ye akũ. Nnɛ́ ye nyɛ Israel lɛgã a? Kekɔ̃ eduma nɛ asendua a akũ finyaa, lɔkɔa bɔ́atɛ ye budo! ");
INSERT INTO bov_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yatɛ Baguma kado ade yalɛ kĩ Baguma Obi yanɛ. Ntɛ Baguma awɛ ye kalɛ nuwĩ ni, ɛyaatɛ ye finyaa!” ");
INSERT INTO bov_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ade ayea bayekpanɛ nviã a kĩ bɛbɔa nɛ asendua akũ a malo vũna Yesu a. ");
INSERT INTO bov_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kĩ kito suwa tɔdɔũ ewua-nviã a, katinya kamɛ flee ke ɔtũ kɛnawo olobe tɔdɔũ ɛlalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ndɛ tɔdɔũ ɛlalɛ kamɛ a, Yesu bɔa fɔwɔla kɔɔba kĩ, “Eli, Eli, lama sabaktani?” Foe kayɔ nyɛ kĩ, “Yĩ Baguma, yĩ Baguma, nde sũ ɔfɔnɛ yĩ awɛ?” ");
INSERT INTO bov_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kĩ bati a kĩ bɛdzɛ̃ nɛ awã a kamɛ badi nu lɛtsa a kĩ ɛlɛ a, bɛlɛ kĩ, “Onyole kĩĩ avɛ Eliya!” ");
INSERT INTO bov_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ade deedimɔapɛ be kamɛ ɔmɔa wula atsɛ ɛnabɔɛ ɔsapɔ edo nɛ waĩ yilawa kamɛ ɛkɔa ɛvɛla nɛ otse onukpɛ̃, ɛdɛla ete ye nɛ onukpɛ̃ kĩ ɛmɔa. ");
INSERT INTO bov_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lɛmɛ bati bɛbã a lɛ kĩ, “Dza tɔ̃. Mifɔ̃ bɔdã ntɛ Eliya aayanyɛ ye mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu buki ɛbɔa fɔwɔla kɔɔba, ade ɛmɛna onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Adeke lima kpale a kĩ bɛvɛla nɛ Asɔli Kɔla kamɛ a bɛ̃ fɔkɛ nviã, kito nyangɛ kɛyawo kayɔ. Tite kuna boe bakpale bakpale yɛlɛ, ");
INSERT INTO bov_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","funikɛ binya ade bɛdzɛla bati kpalɛwa pii kĩ biku a bidzi nkpã a. ");
INSERT INTO bov_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kĩ Yesu yidza eto kanɔkpa liti a, bati kpalɛwa a nɛ́ nɛ funikɛ a kamɛ bɛnaa Yerusalem, ɔmatɔ kpalɛwa a kamɛ, awã kĩ bati pii mɔ be. ");
INSERT INTO bov_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kĩ sodzafɔ ɔnɔkɔɛ̃ a mɔ bikĩ bibumɔ ye bɛkadzɔlɛ Yesu akũ a mɔ́ tite kakuna mɔ fɔtsa bɛbã kĩ fɔya a, libe wo be paa ade bɛlɛ kĩ, “Ɔnɔkɔali obi kĩĩ nyɛ Baguma Obi!” ");
INSERT INTO bov_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Batsole pii kĩ bito Galilea, kĩ bitómɔ Yesu bɛkabumɔ ye a, dza mɔ lugo bɛkadã. ");
INSERT INTO bov_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Be kamɛ badi nyɛ Maria Magdalani, Maria kĩ ɛnyɛ Yakobo mɔ Yosef ɔma, mɔ Zebedeo ɔtsɔ̃. ");
INSERT INTO bov_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kĩ olobe wo ɔtɔ a, onyole osikani odi kĩ bavɛ Yosef, kĩ eto Arimatia, kĩ ye malo ɛnya Yesu fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa a yanɛ ɛta. ");
INSERT INTO bov_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɛnaa Pilato sɛkɛ̃ ɛnawã ye kĩ ɛkɔa Yesu ɔnɔkpa a ɛkpa ye. Ade Pilato kpa osi kĩ bɛfɔnɛ ɔnɔkpa a awɛ bɛkpa ye a. ");
INSERT INTO bov_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Foesũ Yosef bɔɛ ɔnɔkpa a, ade ɛkɔa aklala fitaa vɔɛ̃ esuli ye, ");
INSERT INTO bov_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɛkɔa ɛnado nɛ ye mɔawɛ linikɛ vɔɛ̃ kĩ ɛfɔ̃ bɛnyɛ nɛ de kpale ɔkɛ kamɛ a. Emininya de kpale esua linikɛ a onukpɛ̃ ade ɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalani mɔ Maria kĩ a dzi nɛ awã bɛtsɛlamɔ linikɛ a bɛkadã. ");
INSERT INTO bov_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nɛ luwi lɛyade, kĩ lɛnyɛ Kawɛya Luwi ɔnɔnɛ a, basɔfɔnɔkɔɛ̃ mɔ Farisifɔ yatsɛna nɛ Pilato sɛkɛ̃, ");
INSERT INTO bov_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bibi ye kĩ, “Ɔnɔkɔɛ̃, bute anɛ kĩ, kĩ ɔvãlɛvã a na dzi nkpã a, ɛlɛ kĩ, ‘Maayidza ndzi nkpã nɛ fuwi ɛlalɛ liti.’ ");
INSERT INTO bov_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Foesũ kpa mbla kĩ bɛdzɔlɛ ye kuni a akũ kadzɔlɛ wĩ kɛnaawo luwi lɛlalɛde a akũ. Ntɛ nnɛ́ aye ni, ye fɔtsa bakɔlɛnɛ a aapuli bɛnaaye ɔnɔkpa a lɔkɔa bibi bati kĩ bɛdzɛla ye bitomɛna banɔkpa kamɛ. Ntɛ fɔya lɔmɔ ni, liti fɔvã a aaba fɔtɔnyade a.” ");
INSERT INTO bov_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato bi be kĩ, “Mikpã badzɔlɛnɛ minamɛna, midzɔlɛ kuni a akũ ayekĩ míapuli.” ");
INSERT INTO bov_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Foesũ bɛdzakũ bɛnatim de a nɛ kuni a onukpɛ̃ kɔɔba, ade bɛdzɛla de akũ badzɔlɛnɛ nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kĩ Kawɛya Luwi a tɛ̃, nɛ ɛkwansieda a luwi lɔtɔnyade kĩ lɛnyɛ Ɛkwansieda odenyinawi a, Maria Magdalani mɔ Maria kĩ a naa kĩ banaadã Yesu kuni a. ");
INSERT INTO bov_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lɛtalɛta tite kuna mɔ ɔsĩ mɔ ɔsĩ, kitonɛkĩ ode fɔtɔ ɔnyanɛ to ode ɛka ɛyamininya de nɛ linikɛ a onukpɛ̃ a eyi, ɛkɛna akũ edzi nɛ de akũ. ");
INSERT INTO bov_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ye akũ flee la ndɛ odetɔ́ kamɛ kamɔanɛ aye, ade ye tɛtadiɛ voe fitaa ndɛ aklala aye a. ");
INSERT INTO bov_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Libe wo bikĩ badzɔlɛ fɔkɔ a paa, bɛkatila bliblibli, bɛkɛna ndɛ banɔkpa. ");
INSERT INTO bov_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ade ode fɔtɔ ɔnyanɛ a bi batsole a kĩ, “Mitavila! Ĩnyina kĩ Yesu a kĩ bɛbɔa nɛ asendua akũ a miawɛ. ");
INSERT INTO bov_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɛláa awĩ, kitonɛkĩ bɛdzɛla ye edzi nkpã ndɛ ayekĩ ɛlɛ eyi a. Mifuã miyaadã awã kĩ ɛwa a. ");
INSERT INTO bov_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Miwɛ sɔwa minaabi ye fɔtsa bakɔlɛnɛ a kĩ, ‘Eyidza eto banɔkpa kamɛ. Ɛnyaa mi lɔtɔ yanaa Galilea. Ade awã míamɔ ye a!’ Mite anɛ nɛ lɛtsa a kĩ mbi mi a akũ.” ");
INSERT INTO bov_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Foesũ batsole a dzakũ mɔatsɛ nɛ linikɛ a ɔwɛ̃, ade bɛkɔa libe mɔ kawɔlɛ, biwula atsɛ kĩ banaabi ye fɔtsa bakɔlɛnɛ a lɛtsa a kĩ lɛya a. ");
INSERT INTO bov_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lɛtalɛta Yesu tsɛlamɔ be ade ebi be kĩ, “Lukudɔ litomɔ mi.” Bifuã bɛyapili ye nɛ fɔnɛta, bike aduli bisum ye. ");
INSERT INTO bov_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ade Yesu bi be kĩ, “Mitavila, mbom minaabi nwaɛ̃ amɛ kĩ bɛnaa Galilea, lɔkɔa baamɔ yĩ nɛ awã.” ");
INSERT INTO bov_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kĩ batsole a dzakũ banaa a, kuni a akũ badzɔlɛnɛ a kamɛ badi naa ɔmatɔ kamɛ bɛnabi basɔfɔnɔkɔɛ̃ a lɛtsa a kĩ lɛya a flee. ");
INSERT INTO bov_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kĩ basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a tsa fɔlɔ a, bipi adzuni ade bɛkpa badzɔlɛnɛ a sika baũ, ");
INSERT INTO bov_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bibi be kĩ, “Milɛ kĩ, ‘Lɛnyɛ a kĩ bɔwa tida a ade ye fɔtsa bakɔlɛnɛ a yaye ɔnɔkpa a bɛdzakũmɛna a.’ ");
INSERT INTO bov_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Adeke mɔ ntɛ fɔlɛtsa kĩĩ wo Abãã Ɔnɔkɔɛ̃ sɔtɔ kamɛ ni, bɔ́api foe onukpɛ̃ kĩ fɔláanya ɔhau fɔkpa mi.” ");
INSERT INTO bov_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Badzɔlɛnɛ a tɛ sika a, bɛnakɛna ndɛ ayekĩ bibi be a. Foesũ ade fɔlɛtsa kĩĩ lɛgba nɛ Yudafɔ kamɛ bɛnɛɛ balɛ kɛyawo nviã kĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nɛ foe kamɛ a, fɔtsa bakɔlɛnɛ ewua-odi a naa Galilea nɛ ɔtɔ a kĩ Yesu tsa be kĩ bɛnaa a akũ. ");
INSERT INTO bov_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kĩ bɛmɔ́ ye a, bike aduli bisum ye, lɛmɛ be kamɛ badi tɛ atsindze. ");
INSERT INTO bov_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu fuã be ɛlɛ kĩ, “Baguma kɔa tite mɔ ode otumi flee edo nɛ yĩ awɛ. ");
INSERT INTO bov_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Foesũ minaa fude flee kamɛ nɛ kakɔ nyɛ kakɔ, minaakɛna bati a bɛdani yĩ fɔtsa bakɔlɛnɛ. Miwɔla be mui nɛ Ɔlɛga a, Obi a mɔ Hũhũ Kpalɛwa a dĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mitsa be kĩ bidi nɛ lɛtsa nyɛ lɛtsa a kĩ nhɛ mi a akũ. Midã, ndeĩ nɛ mi sɛkɛ̃ luwi daa kɛnaawo katinya kawũna.”");
INSERT INTO bov_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ade Kalɛ Wĩ nɛ Yesu Kristo kĩ ɛnyɛ Baguma obi akũ kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anɛ kɔkɔɛ a mɔ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya tsɛlɛ eyi kĩ Baguma bi ye obi kĩ, “Maado yĩ fɔtɔ ɔnyanɛ ɛnya nɔ lɔtɔ, ɛyaalɔla osi eyi ɛkpa nɔ. ");
INSERT INTO bov_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aanu kĩ oti kĩĩ tsɛ̃ yade lɛtsã nɛ kɔsa kamɛ kalɛ kĩ, ‘Mimanɛ osi mikpa Ɔlate a kaya. Mikɛna osi a eyo kpĩĩ.’ ” ");
INSERT INTO bov_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Fɔtɔ Ɔnyanɛ kĩĩ nyɛ Yohanes kĩ ɛna nɛ kɔsa kamɛ ɛkawɔla bati mui nɛ ɔwɔ kamɛ ndɛ ayekĩ Yudafɔ akɛna a. Emini ede lɛtsã kĩ bati bɛdani be tɔwɔlɛ kamɛ, bɛtɛ mui kawɔla amaniɛ a, lɔkɔa Baguma aakɔa be titikpa ete be. ");
INSERT INTO bov_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bati pii to Yudea tite a akũ mɔ be ɔmatɔ kpale kĩ bavɛ Yerusalem, bɛnaa kɔsa a kamɛ, kĩ banaatse Yohanes ɔlɛdo. Bibinya be tɔkpa kamɛ bɛtsa Baguma, ade Yohanes wɔla be mui nɛ Yordan ɔwɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Lɔkɔ a na kamɛ ni, Yohanes do ɔpɔnkɔ mɔ kanɛ mɔ lɔpɔ tɔlɔ tɛtadiɛ, ɛkɔa ɔyaɛ ovoli ɔwɛ̃ ɛbɔa kate. Ye funitsã nyɛ kɔsã mɔ koolo. ");
INSERT INTO bov_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ede lɛtsã kĩ, “Oti a kĩ yaaya nɛ yĩ liti a, ɛbɛ̃ yĩ kɔlaa kĩ ntáfɛta kĩ makɛna akũ nwũnya mpabua nɛ ye abɔa malo. ");
INSERT INTO bov_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yĩ kɔ̃ mui nkɔa makɛna mui kawɔla amaniɛ, lɛmɛ ye kɔ̃ yaakɔa Hũhũ Kpalɛwa ɛwɔla mi mui.” ");
INSERT INTO bov_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Owi tábuna mɔ Yesu to Nazaret ɔmatɔ nɛ Galilea tite akũ, ɛyatɛ Yohanes mui kawɔla amaniɛ a nɛ Yordan ɔwɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kĩ Yesu sila ɛnɛ́ eto mui a kamɛ a, ɛmɔ kĩ odetɔ́ kamɛ binya ade Hũhũ a ka eko nɛ ye akũ ndɛ ayekĩ mblɔduma aka a. ");
INSERT INTO bov_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ade ɔlɛdo nɛ eto ode ɛlɛ kĩ, “Nɔ nyɛ yĩ obi kĩ maátunɔ kalɛ, kawɔlɛ ade yĩ nɛ nɔ akũ.” ");
INSERT INTO bov_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lɛtalɛta Hũhũ Kpalɛwa a kpã Yesu ɛnamɛna kɔsa kamɛ nɛ awã kĩ tuwĩ kamɛ bayaɛ deĩ. ");
INSERT INTO bov_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ye odi ɛna nɛ awã fuwi tɛna. Lɔkɔ a na kamɛ a, Abonsam sɔ Yesu ɛdã, ade ode fɔtɔ banyanɛ yasum ye a. ");
INSERT INTO bov_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lɔkɔ a kĩ bipi Yohanes bido nɛ kɔla kamɛ a, Yesu dzakũ ɛnaa Galilea ɛnalɛ Baguma Kalɛ Wĩ a nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ɛkalɛ nɛ awã kĩ, “Lɔkɔ wĩ a wo ɔtɔ ade Baguma lɛgãkanya lɔkɔ a fuã. Mimuniki nɛ mi tɔkpa liti lɔkɔa mitɛ Kalɛ Wĩ a mido!” ");
INSERT INTO bov_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kĩ Yesu kamini nɛ ɔwɔ lutubu baũ ɔwɛ̃ nɛ Galilea tite akũ a, ɛmɔ kɔfɔabi banyɛnɛ nviã kĩ bɛnyɛ Simon mɔ ɔwaɛ̃ Andrea, bɛkata be tɛsau. ");
INSERT INTO bov_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ade Yesu bi be kĩ, “Miyaatomɔ yĩ, lɔkɔa maakɛna mi bati banyɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nɛ awã naa, bɛfɔnɛ be tɛsau awɛ biyidza bitomɔ ye. ");
INSERT INTO bov_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kĩ bɛnaa lɔtɔ sukuloo a, ɛmɔ bawaɛ̃ nviã Yakobo mɔ Yohanes. Bɛna nɛ be ɔkɔlɔ kamɛ bɛkalɔla be tɛsau. ");
INSERT INTO bov_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kĩ Yesu mɔ be a, ɛvɛ be deedimɔapɛ kĩ bitomɔ ye. Be malo biyidza lɛtalɛta, bɛfɔnɛ be ɔlɛga Zebedeo mɔ ye adzuma bakɛnanɛ a odi nɛ ɔkɔlɔ a kamɛ, ade bitomɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu mɔ bikĩ bitomɔ ye a nawo ɔmatɔ kĩ bavɛ Kapernaum. Nɛ Yudafɔ Kawɛya Luwi a kĩ litomɔ be awã kawo luwi a, Yesu naa Yudafɔ katsɛnakɔ̃ ɛnatsa fɔtsa. ");
INSERT INTO bov_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bati a kĩ binu ye fɔtsa katsa a kɛna saa, kitonɛkĩ fɔvɛmɛna nɛ Yudafɔ mbla batsanɛ a fude akũ, mbom ye ɛtsa fɔtsa mɔ ɔwɔlɛ kamɛ kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɛ lɔkɔ a na kamɛ a, onyole odi kĩ hũhũ kpa deĩ nɛ ye kamɛ na nɛ be katsɛnakɔ̃ a, ");
INSERT INTO bov_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ade ɛbɔa fɔwɔla kɔɔba kĩ, “Yesu Nazaretni, litsa deĩ nɛ bɔmɔ nɔ kayite? Ɔya kĩ ayaawɔla boe mbɔɛɛ? Ĩnyina oti a kĩ anɛ. Nɔ nyɛ Baguma Oti Kpalɛwa Kĩ Bido a.” ");
INSERT INTO bov_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu wũni nɛ hũhũ a akũ kĩ, “Sua onukpɛ̃, kanɛ nɛ oti a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hũhũ a fufulinya oti a mɔ ɔsĩ, ɛfɔ̃ ɛbɔa fɔwɔla kɔɔba ade ɛnɛ nɛ ye kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Fɔkɛna bati a flee kĩ bɛdza nɛ awã saa, ade bivia be akũ kĩ, “Litsa nɛ awĩ a? Ei! Fɔtsa katsa vɔɛ̃ ɔdabe nɛ awĩ a? Oti kĩĩ deĩ kɔbɛ̃ yawũni nɛ hũhũ kpa akũ ade yatse ye ɔlɛdo a!” ");
INSERT INTO bov_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Foesũ Yesu dĩ gba nɛ Galilea tite akũ flee. ");
INSERT INTO bov_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu mɔ ye fɔtsa bakɔlɛnɛ, Yakobo mɔ Yohanes dzakũ nɛ Yudafɔ katsɛnakɔ̃ a, ade bɛnaa Simon mɔ Andrea tɔtɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kĩ biwo awã a, badi bi Yesu kĩ Simon nyina waa yasɔ, ye akũ bo hlihlihli. ");
INSERT INTO bov_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Foesũ Yesu wo nɛ ye sɛkɛ̃, ade epi ye nɛ kɔkpɔ ɛdzɛla ye kĩ eyidza. Deedimɔapɛ fɔsɔ a dɔ ye, ade eyidza esum be a. ");
INSERT INTO bov_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kĩ suwa tomu a, bati kpã basɔnɛ pii mɔ bikĩ hũhũ kpa deĩ nɛ be kamɛ a bɛyamɛna kĩ Yesu ɛtsa be. ");
INSERT INTO bov_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bati nɛ ɔmatɔ a kamɛ yabɔa obũ nɛ onyukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu tsa bati pii kĩ basɔ fɔsɔ ahɔlɔ ahɔlɔ, ade ɛblɔmɛna hũhũ kpa etomɛna bati pii lɛmɛ kamɛ a. Yesu tákpa hũhũ a osi bɛlɛ kɔdzɛla kitonɛkĩ binyina ye. ");
INSERT INTO bov_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Odenyinawi a, Yesu yidza nɛ tɔtɔ a kamɛ, ɛnɛ nɛ ɔmatɔ a kamɛ ɛnaa awã kĩ oti odima táfuã, ɛnabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lɛmɛ Simon mɔ bikĩ bitomɔ ye a nɛ bɛtsɛ̃ bawɛ Yesu. ");
INSERT INTO bov_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kĩ bɛmɔ́ ye a, bibi ye kĩ, “Odi nyɛ odi lamɛna nɔ kawɛ!” ");
INSERT INTO bov_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lɛmɛ Yesu bi be kĩ, “Mifɔ̃ bɔnaa tukula bɛbã kĩ tifuã a lɛmɛ kamɛ. Kɛfɛta kĩ mabi be malo Baguma fɔlɛtsa, kitonɛkĩ ade foesũ ĩya nɛ katinya kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Foesũ ɛnamini nɛ Galilea flee. Ɛtsã ɛkalɛ Baguma fɔlɛtsa a nɛ Yudafɔ fɔtsɛnakɔ̃, ade ɛkablɔmɛna hũhũ kpa kanɛmɛna nɛ bati kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oti odi kĩ yasɔ fɔsɔ ngbã kĩ bati avila ya nɛ Yesu sɛkɛ̃. Ɛkɛna akũ ade eke Yesu aduli kĩ ebumɔ ye a. Onyole a bi ye kĩ, “Ntɛ awɛ ni, aapuli ɔfɔ̃ fɔsɔ kĩĩ lɛwɔ nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ye fɔlɛtsa kɔ Yesu kɔnya, foesũ eyo awɛ ɛta ye. Ebi ye kĩ, “Mawɛ lɔmɔ. Nɔ akũ ɛkpalɛ.” ");
INSERT INTO bov_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Deedimɔapɛ fɔsɔ a wɔ nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Awã naa, Yesu bi ye kĩ ɛdzakũ mɔatsɛ ɛnaa, lɛmɛ esi ye mbla mɔ ɔsĩ mɔ ɔsĩ kĩ, ");
INSERT INTO bov_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tafɔ̃ ɔdza nɛ osi ɔkabi bati lɛtsa a kĩ de lɛya, mbom naa kpĩĩ, kakɔa nɔ akũ kanaatsa ɔsɔfɔ. Bɔa afɔliɛ a kĩ Mose mbla tsa a, ayekĩ odi nyɛ odi aanyi kĩ nɔ akũ kpalɛ.” ");
INSERT INTO bov_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lɛmɛ kĩ oti kĩĩ dzakũ a, ɛnado fɔlɛtsa a kagbamɛna awɛ, ɛkabi bati flee ayekĩ Yesu tsa ye a. Nɛ foesũ, Yesu tápuli ebuki ewo nɛ ɔmatɔ odima kamɛ, ade ɛkana nɛ tuwĩ kamɛ a. Lɛmɛ bati buki bɛkato kakɔ nyɛ kakɔ kaya nɛ ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Fuwi fudi liti a, Yesu muniki ɛnaa Kapernaum, ade owi tábuna mɔ bati nu ye nkã kĩ ɛya nɛ tɔtɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Foesũ bati yayi tɔtɔ a kĩ te kamɛ edeĩ a mɔ kanya flee, ade ɛkatsa be Baguma fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ade awã naa mɔ bati ɛna lɔ oti odi kĩ eveliveli bɛma ye a. ");
INSERT INTO bov_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kĩ bɛtápuli bɛtsã onyukpɛ̃ nɛ bati lidede sũ ni, bide nɛ kɔla ode bɛnyɛ ɔkɛ nɛ kakɔ kadi, ade bɛkɛna ɔsɔnɛ a mɔ ɔkɛna biyi nɛ Yesu anɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kĩ Yesu mɔ́ be katɛkado sũ ni, ebi oti a kĩ eveliveli a kĩ, “Obi, bɛkɔa nɔ titikpa bite nɔ.” ");
INSERT INTO bov_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lɛmɛ Yudafɔ mbla batsanɛ a kĩ bɛna nɛ awã kakɔna nɛ be kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nde sũ yalɛ fubusuotsa lɔmɔ? Baguma odi aapuli ɛkɔa titikpa ete.” ");
INSERT INTO bov_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu nyi be kakɔna a foesũ ebi be kĩ, “Litsa sũ fukĩĩ aha mi nɛ mi kamɛ? ");
INSERT INTO bov_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Fɔɔdabe deĩ ɔsĩ fɔbɛ̃ kĩ baabi oti kĩ eveliveli kĩ, ‘Bɛkɔa nɔ titikpa bite nɔ,’ ĩye kĩ, ‘Yidza, bɔɛ nɔ ɔkɛna katsã?’ ");
INSERT INTO bov_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kĩ míanyi kĩ Otidziwa Obi a deĩ kɔbɛ̃ nɛ katinya kĩĩ kamɛ kĩ yakɔa bati titikpa kate sũ ni,” Yesu bi oti a kĩ eveliveli a kĩ, ");
INSERT INTO bov_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yidza, bɔɛ nɔ ɔkɛna kanaa kɔla.” ");
INSERT INTO bov_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lɛtalɛta oti a yidza ɛbɔɛ ye ɔkɛna ɛnɛ nɛ bati a kĩ bɛdzɛ̃ nɛ awã anɛ. Fɔtsa a kɛna bati a flee wãwã, ade bimu Baguma, bɛlɛ kĩ, “Bɔtámɔ fɔtsa kĩĩ odu tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu buki ɛdzakũ ɛnaa Galilea ɔwɔ lutubu baũ abuĩ a. Bati pii ya nɛ ye sɛkɛ̃ nɛ awã ade ɛtsa be Baguma fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kĩ ɛdzakũ yanaa a ɛmɔ́ ɔgɔlɛ ɔtɛnɛ Levi, Alfeo obi kĩ edzi nɛ ɔgɔlɛ katɛkɔ̃. Ade Yesu bi ye kĩ, “Tomɔ yĩ.” Adeke Levi yidza ade etomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ke liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a mɔ bati pii kĩ bitomɔ ye a naanya nɛ Levi awã. Tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ pii lɛmɛ na nɛ kanyakɔ̃ a mɔ be. ");
INSERT INTO bov_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ade Farisifɔ kĩ bɛnyɛ Yudafɔ mbla batsanɛ badi lɛmɛ na nɛ awã a. Kĩ Farisifɔ mbla batsanɛ a mɔ́ kĩ Yesu anya mɔ titikpa bakɛnanɛ mɔ tɔgɔlɛ batɛnɛ a, bivia ye fɔtsa bakɔlɛnɛ a kĩ, “Litsa sũ yanya kamɔa mɔ tɔgɔlɛ batɛnɛ mɔ tɔkpa bɛbã bakɛnanɛ?” ");
INSERT INTO bov_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kĩ Yesu nu fɔlɛtsa kĩĩ a, ebi be kĩ, “Bati kĩ bideĩ akũ ɔsĩ tásĩ tutsonu ɔkɛnanɛ, mbom basɔnɛ lisĩ ye. Ntáya kĩ mayaavɛ bati kpĩĩ, mbom tɔkpa bakɛnanɛ kavɛ ĩya.” ");
INSERT INTO bov_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nɛ lɔkɔ lidi kamɛ, kĩ Yohanes mɔ ye fɔtsa bakɔlɛnɛ mɔ Farisifɔ kasui onukpɛ̃ a, bati badi ya nɛ Yesu sɛkɛ̃ bivia ye kĩ, “Nde sũ nɔ fɔtsa bakɔlɛnɛ a lásui onukpɛ̃ ndɛ Yohanes bade mɔ Farisifɔ a aye?” ");
INSERT INTO bov_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kpa be mbuayɛ kĩ, “Mbɔɛɛ obolitsɔ̃ ɔnyɔ bakɔba aapuli bidzi kɔlɛ nɛ obolitsɔ̃ kapikɔ̃ nɛ lɔkɔ a kĩ obolitsɔ̃ ɔnyɔ a deĩ nɛ be sɛkɛ̃ a? ");
INSERT INTO bov_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lɛmɛ luwi lidi aaya kĩ baakpã ye nɛ ye bakɔba a sɛkɛ̃, lɔkɔa baasui onukpɛ̃ nɛ fuwi a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Odima lákɔa limakũ vɔɛ̃ kataɛ ɔkɛ nɛ lima kɔɛ akũ. Limakũ vɔɛ̃ a aabɛ̃ lɔkɔɛ lidomɔ akũ ntɛ bɛvɔlɛ de, ade fɔ́afɔ̃ ɔkɛ baũ lɛwa ɛba ayekĩ fɔna kɔkɔɛ a. ");
INSERT INTO bov_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bio, odima lákɔa waĩ vɔɛ̃ kako nɛ ɔyaɛ ovoli kuvũ kɔɛ kamɛ, kitonɛkĩ waĩ vɔɛ̃ aabɛ̃ kuvũ kɔɛ a, lɔkɔa waĩ a aawula, kuvũ a lɛmɛ aabu kade. Mbom bakɔa waĩ vɔɛ̃ kako nɛ ɔyaɛ ovoli kuvũ vɔɛ̃ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nɛ Kawɛya Luwi lidi akũ a, kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ tsɛ̃ batɛ̃ nɛ fugbanɔ kɔba kudi kamɛ a, fɔtsa bakɔlɛnɛ a kave fudi. ");
INSERT INTO bov_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Foesũ Farisifɔ a bi Yesu kĩ, “Dã! Boe mbla tákpa osi kĩ bakɛna fukĩnaa nɛ Kawɛya Luwi akũ.” ");
INSERT INTO bov_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Awã naa Yesu via be kĩ, “Mitákã lɛtsa a kĩ Lɛgã Dawid kɛna a? Lɔkɔ a kĩ kɔlɛ kɔ ye mɔ bikĩ bitomɔ ye a, Dawid wo nɛ Baguma kɔla a kamɛ a, nɛ lɔkɔ a kĩ Abiata anya Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee a. Ɛnanyɛ afɔlibɔ abodoo kĩ Yudafɔ basɔfɔ odi deĩ osi kĩ banya a ɛnya, ade ɛkɔa adi ɛkpa bikĩ bitomɛna ye a lɛmɛ bɛnya a.” ");
INSERT INTO bov_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu bi be kĩ, “Otidziwa sũ bɛbɔa Kawɛya Luwi a, nnɛ́ Kawɛya Luwi a sũ bɛbɔa otidziwa. ");
INSERT INTO bov_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Foesũ Otidziwa Obi a nyɛ Kawɛya Luwi a Ɔlate.” ");
INSERT INTO bov_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ke liti a, Yesu buki ɛnaa Yudafɔ katsɛnakɔ̃ kadi. Oti odi kĩ ye kɔkpɔ ku na nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lɔkɔ a na Yesu bakesĩnɛ badi na nɛ katsɛnakɔ̃ a, bɛkadã ntɛ yaatsa oti a nɛ Kawɛya Luwi akũ, ayekĩ baabɔɛ fɔlɛtsa nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu vɛ oti a kĩ ye kɔkpɔ ku a kĩ ɛnɛ ɛyaadza nɛ bati a flee anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ade ɛdani ɛtsɛlamɔ bati a evia be kĩ, “Mbla kpa osi kĩ bɛkɛna tuwĩ nɛ Kawɛya Luwi akũ, mbɔɛɛ bɛkɛna tɔkpa? Fɔnyɛ luwi kĩ batɛ oti nkpã, mbɔɛɛ kĩ bɛfɔnɛ ye awɛ eku” Lɛmɛ bɛtálɛ kadima. ");
INSERT INTO bov_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu dã be ɛtɛ̃mɛna nɛ kalɔkpa kamɛ, ade fɔha ye paa nɛ be lɔlɔ kamɛ ɔsĩ sũ a. Ade ebi ɔsɔnɛ a kĩ, “Yo nɔ awɛ.” Eyo awɛ a ade ye awɛ a de ɔsĩ a. ");
INSERT INTO bov_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Adeke Farisifɔ a dzakũ bɛnamɔ Lɛgã Herodes batomɛnanɛ a, ade bipi adzuni nɛ Yesu kakɔ akũ a. ");
INSERT INTO bov_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu mɔ ye fɔtsa bakɔlɛnɛ a naa Galilea ɔwɔ lutubu baũ a abuĩ, ade bati beblebee tomɔ be bɛya a. Bito Galilea tite, Yudea tite, Yerusalem ɔmatɔ mɔ Idumea kamɛkamɛ a, bikĩ bito Yordan Ɔwɔ liti a, mɔ be a kĩ bito Tiro mɔ Sidon tɛmatɔ kamɛkamɛ a bɛya. Bati kĩĩ flee ya nɛ Yesu sɛkɛ̃, kitonɛkĩ binu ye awãwã fɔtsa a kĩ ɛtsɛ̃ yakɛna a. ");
INSERT INTO bov_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu tsa bati pii ade basɔnɛ pii kapili kĩ bata ye lɔkɔa bɛna akũ ɔsĩ a. Bati a lidede sũ ni, Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ bɛwɛ ɔkɔlɔ odi bɛdzɛla ye, ayekĩ bati a lɛláamɛnana ye. ");
INSERT INTO bov_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ntɛ bati a kĩ hũhũ kpa na nɛ be kamɛ sila bɛmɔ́ Yesu pɛ, batɔ nɛ ye abɔa kayɔ kabɔa fɔwɔla kĩ, “Nɔ nyɛ Baguma Obi.” ");
INSERT INTO bov_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lɛmɛ Yesu sua be osi kĩ bɛtafɔ̃ bati linyi oti a kĩ ye yanɛ. ");
INSERT INTO bov_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ke liti a, Yesu de ɛnaa ɔtɔ kalete. Ade awã ɛvɛ bikĩ yawɛ kĩ bɛnya ye bade a. ");
INSERT INTO bov_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bati kĩĩ yakpɔta nɛ ye sɛkɛ̃ ade ɛpau be kamɛ bati ewua-nviã, ete be dĩ kĩ fɔtɔ banyanɛ. Ebi be kĩ, “Mpau mi kĩ mina nɛ yĩ akũ lɔkɔ nyɛ lɔkɔ. Maado mi lɛmɛ kĩ minaalɛ Baguma fɔlɛtsa a, ");
INSERT INTO bov_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ade míana kɔbɛ̃ kĩ míablɔmɛna hũhũ kpa mitomɛna bati kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Bati ewua-nviã a kĩ ɛnyɛ a buĩ nyɛ Simon, ade ye Yesu te dĩ kĩ Petro, Yakobo mɔ ɔwaɛ̃ Yohanes kĩ bɛnyɛ Zebedeo babi. Yesu vɛ be kĩ Boanerges, foe kayɔ nyɛ kĩ balɛ kɔdzɛla mɔ kɔbɛ̃ ndɛ ayekĩ ɔplala akpɛ̃nɛ a. Babɛbã nyɛ Andrea, Filipo, Bartolomeo, Mateo mɔ Toma, Yakobo kĩ ɛnyɛ Alfeo obi, Tadeo, Simon kĩ eto Kana kĩ epili ye kade lɔlɔ a. Yuda Iskariot, oti kĩ ye lɛnyɛ Yesu ɛkpa. ");
INSERT INTO bov_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu dzakũ nɛ awã ɛnaa tɔtɔ kamɛ, ade bati pii buki bɛya nɛ be sɛkɛ̃ nɛ awã. Nɛ foesũ Yesu mɔ ye fɔtsa bakɔlɛnɛ a lána aya bɛnya malo. ");
INSERT INTO bov_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kĩ Yesu akũ bati nu foe a, bɛnaa kĩ banaakpã ye, kitonɛkĩ bati kalɛ kĩ, “Ye lɔlɔ kamɛ lamɔ kade kabu.” ");
INSERT INTO bov_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yudafɔ mbla batsanɛ a kĩ bito Yerusalem bɛya a lɛ kĩ, “Hũhũ kpa deĩ nɛ ye kamɛ. Hũhũ kpa lɛgã a lɛkpa ye kɔbɛ̃ yablɔmɛna hũhũ a katomɛna bati kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ade Yesu vɛ bati a ɛyamɛna nɛ ye sɛkɛ̃ ɛlɛ kɔdzɛla mɔ be nɛ fɔgbã kamɛ kĩ, “Nde fɔ́aya kĩ Abonsam aapuli ɛblɔmɛna ye mɔawɛ akũ etomɛna oti kamɛ? ");
INSERT INTO bov_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Foe nfantuhũ nyɛ kĩ ntɛ lɛgãkanyakɔ̃ kadi sɛ̃ ke akũ kutsu kutsu kĩ kɔanɔ akũ ni, kanyakɔ̃ a na lɛláapuli kitim. ");
INSERT INTO bov_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ade ayea ntɛ kɔla kudi sɛ̃ koe akũ kutsu kutsu mɔ tɛdzɛ nɛ́ nɛ be kamɛ ni, kɔla na lɛláapuli kɔdza. ");
INSERT INTO bov_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Foesũ ntɛ Abonsam yidza ɛdza nɛ ye mɔawɛ akũ, mɔ ye kanyakɔ̃ a sɛ̃ kutsu kutsu ni, ye kanyakɔ̃ a aayalɛ lɔkɔa ade ye lɛgã kanya a kawũna nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Odima lɛláapuli ewo nɛ oti kĩ edeĩ kɔbɛ̃ kɔla kamɛ ɛnaafila ye fɔtsa, mbɔɛntɛ ɛnya lɔtɔ esuli ɔbɛlɛbɛ a fɔmɔ yaawo efila ye fɔtsa a. ");
INSERT INTO bov_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mabi mi nɛ ɔnɔkɔali kamɛ kĩ Baguma aakɔa bati tɔkpa tidi nyɛ tidi kĩ bɛkɛna mɔ fubusuotsa fudi nyɛ fudi kĩ bɛlɛ ete be. ");
INSERT INTO bov_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lɛmɛ odi nyɛ odi kĩ yaalɛ fubusuotsa nɛ Hũhũ Kpalɛwa a akũ ni, Baguma lɛláakɔa ete ye da. Kitonɛkĩ ɛkɛna tɔkpa kĩ taawa daa.” ");
INSERT INTO bov_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu lɛ fukĩĩ kitonɛkĩ Yudafɔ mbla batsanɛ a badi lɛ kĩ hũhũ kpa deĩ nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ke liti a, Yesu ɔma mɔ bawaɛ̃nyole ya bɛdzɛ̃ nɛ kanya ade bido lɔtɔ kĩ bɛvɛ ye ɛya. ");
INSERT INTO bov_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bati a kĩ bidzi bɛtsɛna Yesu a bi ye kĩ, “Dã, ama mɔ awaɛ̃ amɛ dzɛ̃ nɛ kanya bawɛ nɔ!” ");
INSERT INTO bov_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ade Yesu via be kĩ, “Owei nyɛ mma? Bawei nyɛ nwaɛ̃ amɛ?” ");
INSERT INTO bov_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kĩ ɛdã bati a kĩ bidzi bisinya ye ɛnake a, ɛlɛ kĩ, “Midã, ade mma mɔ nwaɛ̃ amɛ nɛ awĩ a! ");
INSERT INTO bov_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Odi nyɛ odi kĩ yakɛna nɛ Baguma kawɛ akũ ni, ade ye nyɛ nwaɛ̃nyole mɔ nwaɛ̃tsole, mɔ mma a.” ");
INSERT INTO bov_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu buki ɛnaa Galilea ɔwɔ lutubu baũ a ɔwɛ̃, ade ɛkatsa Baguma fɔlɛtsa a. Ayekĩ bati pii fɔli nɛ ye akũ sũ ni, ewo edzi nɛ ɔkɔlɔ kĩ eteĩ nɛ mui anɛ kamɛ. Bati dza nɛ ɔwɔ lutubu baũ a abuĩ ade Yesu katsa be fɔtsa nɛ fɔgbã kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lɔkɔ pii nɛ ye fɔtsa katsa kamɛ a, ɛkɔa fɔgbã ɛtsa fɔtsa a kĩ yawɛ kĩ ɛtsa be a. Fɔtsa a kĩ ɛtsa be a nyɛ fukĩĩ. ");
INSERT INTO bov_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ebi be kĩ, “Mitse! Luwi a onyole odi naa kɔba ɛnaasã funitsã babi. ");
INSERT INTO bov_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kĩ ɛkasã foe a fudi tɔ nɛ osi ɔɔwɛ̃, ade kɔvɔlabi yafila be bɛmɛna a. ");
INSERT INTO bov_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Badi tɔ nɛ lɛkpakpalabode akũ, kĩ tite lɛláa pii. Foesũ babi a mɛ mɔatsɛ. ");
INSERT INTO bov_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lɛmɛ kĩ suwa ta kpaa pɛ bɛvɛ biku, kitonɛkĩ be tunu tána funitsã, nɛ boe a sũ. ");
INSERT INTO bov_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Badi tɔ nɛ tuwĩ mɔ fu ndɛ ɔgɔabi kamɛ. Tuwĩ mɔ fu mɛ fusuli be, kĩ bɛtápuli bibo anɛ. Nɛ foesũ bɛtáwũ babi. ");
INSERT INTO bov_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Babi badi tɔ nɛ tite wĩ akũ. Bɛmɛ bibo anɛ, ade biwũ bido babi a. Badi do babi taalɛ, badi aduesia, badi ɔha.” ");
INSERT INTO bov_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nɛ kawũnakɔ̃ a Yesu bi be kĩ, “Oti kĩ edeĩ atɔ ni, etse katse wĩ!” ");
INSERT INTO bov_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kĩ Yesu odi na nɛ kakɔ mɔa a, bati a kĩ binu ye lɛgbã a mɔ ye fɔtsa bakɔlɛnɛ mɔ ye fɔtɔ banyanɛ a ya kĩ ɛnyɛ de kayɔ ɛtsa be. ");
INSERT INTO bov_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu bi be kĩ, “Baguma nyɛ ye lɛgãkanya kamɛ fɔtsa kɔlawa a ɛtsa mi. Lɛmɛ bati a kĩ bite a ni, mbɔɛntɛ fɔgbã kamɛ baakanu fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Foesũ fɔ́aya nɛ foe kamɛ ndɛ ayekĩ Baguma onukpɛ̃ banyɛnɛ kamɛ odi tsɛlɛ eyi kĩ, ‘Baakadã, lɛmɛ bɛláamɔ biyi ɔsũ. Baakatse lɛmɛ bɛláanu foe kayɔ. Kitonɛkĩ titɔ kĩ banu ĩye bamɔ malo ni, bɛláanu kayɔ mɔ baadani bɛdã Baguma, lɔkɔa ɛkɔa be titikpa ete be.’ ” ");
INSERT INTO bov_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ade Yesu via be kĩ, “Ntɛ mitánu lɛgbã kĩĩ kayɔ a, nde míakɛna fɔmɔ míanu fɔgbã bɛbã kayɔ? ");
INSERT INTO bov_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Fɔtsa odunɛ a nyɛ oti kĩ ɛtsɛ̃ yalɛ Baguma kalɛ. ");
INSERT INTO bov_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bati badi la ndɛ babi a kĩ bɛtɔ nɛ osi ɔwɛ̃ a. Ntɛ binu pɛ lɔkɔa Abonsam yanyɛ foe nɛ be fɔlɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bati badi lɛmɛ la ndɛ babi a kĩ bɛtɔ nɛ boe kamɛ. Ntɛ lɔkɔ a kĩ binu pɛ lɔkɔa kawɔlɛ de be. ");
INSERT INTO bov_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lɛmɛ kalɛ a ke tunu láwo nɛ tite kamɛ kawo wĩ. Be katɛkado adã lukũ. Ntɛ bati liti katomɛna yawo nɛ kalɛ kĩĩ akũ pɛ, baamuniki nɛ ke liti. ");
INSERT INTO bov_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ade bati badi lɛmɛ la ndɛ babi kĩ bɛtɔ nɛ tuwĩ mɔ fu kamɛ a. Be bɛnyɛ bati kĩ binu Baguma fɔlɛtsa a, ");
INSERT INTO bov_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lɛmɛ katinya kamɛ ɔhau, sika kawɛ mɔ sukɛna fɔwɛtsa yi be tɔwɔlɛ kamɛ. Fɔtsa kĩĩ mɛna Baguma fɔlɛtsa a, foesũ fɔáwũ babi. ");
INSERT INTO bov_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Bati badi lɛmɛ atɛ Baguma Kalɛ a ndɛ babi kĩ bɛtɔ nɛ tite wĩ akũ. Bati kĩĩ tɛ ke mɔ be ɔwɔlɛ flee. Luwi nyɛ luwi, babo anɛ kanɛ lɔlɔ kawũ babi beblebee. Bɛkɛna ndɛ fudutsa a kĩ fɔawũ babi taalɛ, ĩye aduesia, ĩye ɔha mɔa.” ");
INSERT INTO bov_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu buki evia be kĩ, “Owei atɛna ɔsɛdza kakɔa lɔɔda katsa ye ĩye kakɔa ye kado nɛ mpa kayɔ? Nnɛ́ ɔsɛdza otse akũ bakɔa ye kate? ");
INSERT INTO bov_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lɛtsa nyɛ lɛtsa kĩ bɛkɔa bɛkɔla a baanyɛ de kanya, ade Baguma aabinya lɛtsa nyɛ lɛtsa kĩ bisua a. ");
INSERT INTO bov_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Foesũ ntɛ mideĩ atɔ ni, mitse foe katse wĩ!” ");
INSERT INTO bov_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bio, Yesu bi be kĩ, “Miyi atɔ yededeede mitse lɛtsa a kĩ mianu a. Kitonɛkĩ fɔtsa kakɔna odu a kĩ mikɔa mikɔna mikpa bati bɛbã a, ade foe odu Baguma lɛmɛ aakɔa ɛkɔna ɛkpa mi a. ");
INSERT INTO bov_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bikĩ bɛkɔa be akũ bɛkpa yĩ fɔtsa katsa a baakpa be kayɔkanu dzununuunu. Lɛmɛ bikĩ baátse a ni, baatɛ lɛtsa a kĩ bideĩ a malo nɛ be awɛ.” ");
INSERT INTO bov_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu buki ebi be kĩ, “Baguma lɛgãkanyakɔ̃ a la ndɛ oti kĩ yasã kamɔnɛ. ");
INSERT INTO bov_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Luwi daa kĩ yawa kayidza, ade babi a amɛ kabo anɛ. Lɛmɛ enyína ayekĩ fɔtsa a akɛna kabo anɛ. ");
INSERT INTO bov_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tite afɔ̃ fudutsa alɛ nɛ foe akũ akũ. Lanya lɔtɔ lɔkɔa lɛnyɛ tɔɔta fɔmɔ kutse a anɛ. Ntɛ kubo anɛ kɔawũ babi beblebee. ");
INSERT INTO bov_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ntɛ babi a yɔɔlɛ a banɛna be, kitonɛkĩ kɔba funitsã kakpɔta lɔkɔ wo ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu via kĩ, “Litsa bɔ́akɔa bɔkɔnamɔ Baguma lɛgãkanyakɔ̃ a? Lɛgbã lɛwɔdabe makɔa ĩnyɛ kayɔ ntsa? ");
INSERT INTO bov_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Fɔla ndɛ kutse libi kabii nɛ katinya kamɛ flee kĩ oti bɔɛ ɛnadu. ");
INSERT INTO bov_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kutse kĩĩ yapɔ kɔkɛna futse baũ a kamɛ kɔmɔa nɛ kɔba kamɛ. Kɔanɛ tɛnanɛ pii ade kɔakpa ɔna a. Kɔvɔlabi akɛna fɔtsɔɛ nɛ koe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu bi be Baguma fɔlɛtsa a nɛ fɔgbã kamɛ nɛ be kapuli kanu kayɔ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yaábi be kadima kɛba fɔgbã kamɛ. Ntɛ bɛmɔ ye fɔtsa bakɔlɛnɛ a odi bidzi a, lɔkɔa yanyɛ foe kayɔ katsa be. ");
INSERT INTO bov_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Luwi a ke olobe a, Yesu vɛ ye fɔtsa bakɔlɛnɛ a ɛlɛ kĩ, “Mifɔ̃ bunyina ɔwɔ lutubu baũ a bɔnaa de abuĩ atide a.” ");
INSERT INTO bov_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Foesũ bɛfɔnɛ bati a biwo nɛ ɔkɔlɔ kamɛ. Yesu nawo ɛkɛna akũ edzi, ade biyi ɔwɔ a kanyina kayɔ a. Tɔkɔlɔ bɛbã lɛmɛ na nɛ mui a akũ. ");
INSERT INTO bov_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Owi tábuna ɔwɛ kpale odi do kavũ awɛ, ɛbɔa mui eko nɛ ɔkɔlɔ a kamɛ. Ɔkɔlɔ a ka kɔlaa kĩ kite sukuloo kufɛ yayi mɔ mui ɛyɛla. ");
INSERT INTO bov_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lɔkɔ a na kamɛ a, Yesu wa nɛ ɔkɔlɔ a liti. Ɛkɔa sumuyɛ ete lɔlɔ ɛlamɛna tida kawa. Ye fɔtsa bakɔlɛnɛ a nadzɛla ye ade bibi ye kĩ, “Fɔtsa Ɔtsanɛ, fɔtsɛ́la nɔ kĩ bɔwɔ buyua?” ");
INSERT INTO bov_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kĩ Yesu yidza ɛdza a, ade ewũni kĩ, “Ɔwɛ, fɔ̃ kavũ!” Ebi mui a lɛmɛ kĩ, “Mui, kɛna dĩĩ.” Ɔwɛ a fɔ̃ kavũ ade mui a anɛ flee kɛna dĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu via ye fɔtsa bakɔlɛnɛ a kĩ, “Nde sũ libe wo mi lɔmɔ? Mitátɛ yĩ mido?” ");
INSERT INTO bov_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nɛ libe a kĩ libuki liwo be a sũ ni, bɛkavia be akũ kĩ, “Owei koũ nyɛ oti kĩĩ? Mui mɔ ɔwɛ malo atse ye kalɛ!” ");
INSERT INTO bov_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ke liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a naa Galilea lutubu baũ sɛkɛ kĩ a nɛ Gerasefɔ tite akũ. ");
INSERT INTO bov_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kĩ Yesu nɛ nɛ ɔkɔlɔ kamɛ a, onyole odi kĩ hũhũ kpa deĩ nɛ ye kamɛ nɛ eto asie ɛyatsɛlamɔ ye. ");
INSERT INTO bov_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Onyole kĩ kadzikɔ̃ nyɛ asie a kĩ efuã nɛ awã. Bati a flee lápuli kapi ye kado nɛ nkɔsɔnkɔsɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lɔkɔ nyɛ lɔkɔ kĩ basuli ye akpɔ mɔ abɔa ni, yaveli nkɔsɔnkɔsɔ a kĩ tipini ye a. Oti kĩ deĩ kɔbɛ̃ kudi odu kĩ odima lápuli kapi ye. ");
INSERT INTO bov_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lɛnyɛ mɔ suwa flee yamini nɛ asie mɔ tɔtɔ kamɛ. Ɛtsɛ̃ yabɔa fɔwɔla lɔkɔa yakɔa boe kakpeli ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Onyole kĩĩ dzɛ̃ mɔ lugo fɔmɔ ɛmɔ Yesu. Foesũ ewula atsɛ ɛnake aduli nɛ Yesu nnyɛ. ");
INSERT INTO bov_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ade ɛbɔa fɔwɔla kɔɔba ɛlɛ kĩ, “Yesu, Baguma Nɛ Ode Flee Obi! Bɔake nɔ aduli, nɛ Baguma sũ, tunɔ kĩ ɔláavɛlɛ yĩ sɔtɔ!” ");
INSERT INTO bov_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɛlɛ foe lɔmɔ kitonɛkĩ enu kĩ Yesu kalɛ kĩ, “Hũhũ kpa, nɛ́ nɛ oti kĩĩ kamɛ!” ");
INSERT INTO bov_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu via ye kĩ, “Nde bavɛ nɔ?” Awã naa ɛlɛ kĩ, “Bavɛ yĩ lidede, kitonɛkĩ boe a kĩ budeĩ nɛ onyole kĩĩ kamɛ a bɔpɔnɛ!” ");
INSERT INTO bov_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ade awã ebuki eke Yesu aduli mɔ ɔsĩ mɔ ɔsĩ kĩ ɛtablɔmɛna be ɛnɛmɛna nɛ tite a na kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lɔkɔ a na kamɛ a, baplakuo pii dzɛ̃ badɛ nɛ katɔbii kayɔ. ");
INSERT INTO bov_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ade bike Yesu aduli kĩ, “Blɔmɛna boe bɔnaawo nɛ baplakuo a kĩ bɛdzɛ̃ nɛ akĩĩ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɛkpa be osi ade hũhũ a nɛ́ nɛ onyole a kamɛ bɛnawo nɛ baplakuo kamɛ a. Baplakuo a flee kĩ baawo ndɛ mpim nviã, lo atsɛ kplikplikpli bɛka kakpenii a, bɛnawo nɛ ɔwɔ a kamɛ ade be flee bɛmɔa mui biku a. ");
INSERT INTO bov_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bati a kĩ badãmɛna be akũ a wula atsɛ bɛnaa ɔmatɔ a mɔ tikĩ tifuã a kamɛ, bɛnalɛ lɛtsa flee a kĩ lɛya a. Bati wula atsɛ bɛnaa awã kĩ banaadã lɛtsa a kĩ lɛya a. ");
INSERT INTO bov_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kĩ biwo Yesu sɛkɛ̃ a, bɛmɔ́ oti a kĩ hũhũ kpa beblebee na nɛ ye kamɛ a nɛ awã. Ɛkɛna akũ edzi ade edo atadiɛ a, ye anɛ kamɛ lɛmɛ kpalɛ. Libe wo bati a flee! ");
INSERT INTO bov_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bikĩ bɛnya lɔtɔ bɛmɔ foe a, lɛ lɛtsa a kĩ lɛya nɛ onyole a mɔ baplakuo a akũ. ");
INSERT INTO bov_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Foesũ bike Yesu aduli kĩ ɛdzakũ nɛ be tite akũ. ");
INSERT INTO bov_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kĩ Yesu awo nɛ ɔkɔlɔ kamɛ a, onyole a kĩ hũhũ kpa na nɛ ye kamɛ a ke ye aduli kĩ, “Fɔ̃ ntomɔ nɔ bɔnaa!” ");
INSERT INTO bov_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lɛmɛ Yesu tátunɔ. Mbom ebi ye kĩ, “Naa kɔla nɛ nɔ bati sɛkɛ̃, lɔkɔa kabi be lɛtsa a kĩ Ɔlate a kɛna ɛkpa nɔ, mɔ ayekĩ ɛmɔ nɔ kɔnya a.” ");
INSERT INTO bov_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Foesũ onyole kĩĩ naa ɛnamini nɛ tɛmatɔ ewua kamɛkamɛ a, ade ebi be fɔlɛtsa flee a kĩ Yesu kɛna ɛkpa ye a. Fɔkɛna bikĩ binu foe a saa. ");
INSERT INTO bov_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu buki ɛdani ɛnaa lutubu baũ a sɛkɛ̃ kĩ a. Kĩ ewo de abuĩ a, bati pii yayi ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Onyole odi nɛ Yudafɔ katsɛnakɔ̃ banɔkɔɛ̃ a kamɛ ɔmɔa kĩ bavɛ Yairo ya nɛ awã. Kĩ ɛmɔ Yesu a, ɛkɛna akũ ɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ade ebi ye mɔ kudulike kĩ, “Yĩ obitsole kabii kĩ kɛtɛ futeli ewua-nviã asɔ mɔ ɔsĩ mɔ ɔsĩ. Foesũ ya kayate awɛ nɛ ye akũ lɔkɔa yaana akũ ɔsĩ edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ade Yesu yidza etomɔ ye a. Nɛ ayekĩ bati a kĩ bitomɔ Yesu pɔnɛ sũ, ɛna nɛ be kayite kĩ banaa. ");
INSERT INTO bov_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Otsole odi kĩ babɔanɛ kawula nɛ ye akũ futeli ewua-nviã flee mɔ lubo kamɔ paa, titɔ kĩ bawanɛ kadã ye a malo na nɛ be kamɛ. Ebula sika flee kade nɛ fɔsɔ kĩĩ katsa akũ, lɛmɛ fɔsɔ a tádɔ ye, mbom kade fɔkade nɛ ode. ");
INSERT INTO bov_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Enu Yesu nkã foesũ ɛna nɛ bati a kĩ bitomɔ Yesu nɛ liti a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ade ebi ye akũ kĩ, “Ntɛ maapuli nta titɔ ye atadiɛ malo ni, kufɛ maasaɛ.” ");
INSERT INTO bov_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kĩ ɛta Yesu atadiɛ a, ade akũ fɔ̃ ye kawula deedimɔapɛ a. Ɛmɔ́ eyi ɔsũ nɛ ye kamɛ kĩ ɛsaɛ ade ɛnɛ nɛ ye lubo kamɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lɛtalɛta Yesu nyi kĩ kɔbɛ̃ kudi nɛ́ nɛ ye kamɛ. Foesũ ɛfɔ̃ ɛdza, ɛdani evia bati a kĩ bitomɔ ye a kĩ, “Owei nyɛ ekĩ ɛta yĩ atadiɛ?” ");
INSERT INTO bov_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ye fɔtsa bakɔlɛnɛ a bi ye kĩ, “Dã ayekĩ bati beblebee sinya nɔ. Nde sũ avia kĩ owei lɛta nɔ?” ");
INSERT INTO bov_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lɛmɛ Yesu dzɛmɛna anɛ kako kadã kĩ yaamɔ oti a kĩ ye lɛta ye a. ");
INSERT INTO bov_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Otsole a mɔ́ lɛtsa a kĩ lɛya nɛ ye akũ. Foesũ nɛ libe mɔ kukũtila kamɛ ni, ɛnɛ ɛyake aduli nɛ Yesu anɛ kamɛ. Ebi ye lɛtsa a kĩ lɛya a yededeede. ");
INSERT INTO bov_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu bi ye kĩ, “Yĩ obitsole, nɔ katɛkado fɔ̃ ɔsaɛ. Naa nɛ lukudɔ kamɛ. Nɔ lubo kamɔ a lɛláabuki lɛya nɛ nɔ akũ dadaada.” ");
INSERT INTO bov_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lɔkɔ a kĩ Yesu kalɛ fukĩĩ a, batɔ to Yairo awã bɛyabi ye kĩ, “Nɔ obi a ku kɔkɔɛ. Nde sũ obuki aha fɔtsa ɔtsanɛ kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu tátse be kalɛ a, mbom ebi Yairo kĩ, “Tavila, nɔ kɔ̃ tɛ kado.” ");
INSERT INTO bov_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu kpã Petro, Yakobo mɔ ɔwaɛ̃ Yohanes be odi bɛnaa Yairo awã. ");
INSERT INTO bov_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kĩ biwo tɔtɔ a kamɛ a, ade kĩ Yesu mɔ́ ayekĩ bati dzɛ̃ mɔ kɔnya mɔ fɔwɔla a, ");
INSERT INTO bov_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ewo nɛ be kamɛ, evia be kĩ, “Litsa tsɛ̃mɔ fɔwɔla kĩĩ odu? Nde sũ miabe? Kabisɛ̃ɛ̃ kĩĩ táku. Tida kawa!” ");
INSERT INTO bov_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kĩ ɛlɛ foe lɔmɔ pɛ, bati a kĩ bɛdzɛ̃ nɛ awã támɔ ye kamɛmɛ. Ade Yesu fɔ̃ bɛnyɛ bati a flee bɛnaa kanya, ade ɛfɔ̃ kabisɛ̃ɛ̃ a ɔlɛga mɔ ɔma mɔ ye fɔtsa bakɔlɛnɛ ɛlalɛ a biwo nɛ awã kĩ ɔnɔkpa a waa a. ");
INSERT INTO bov_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu pi ye nɛ kɔkpɔ ade ebi ye kĩ, “Talita koumu!” Foe kayɔ nɛ tide a kamɛ nyɛ kĩ, “Kayitsɔ̃bi kabii, mabi nɔ kĩ yidza!” ");
INSERT INTO bov_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Deedimɔapɛ katsolebi kĩĩ yidza kɛdza ade kido kato katɛ̃ awɛ a. Kĩ fɔya lɔmɔ a, fɔkɛna be a flee wãwã. ");
INSERT INTO bov_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lɛmɛ Yesu si be mbla mɔ ɔsĩ kĩ bɛtabi odima kadimanɔ. Ebuki ebi be kĩ, “Mikpa ke litsedi kɛnya.” ");
INSERT INTO bov_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu dzakũ nɛ awã ade bɛmɔ ye fɔtsa bakɔlɛnɛ a bɛnaa ɔmatɔ a kĩ ye kamɛ bɛdɔɔla ye a. ");
INSERT INTO bov_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɛ Kawɛya Luwi a akũ a, ɛnatsa Baguma fɔlɛtsa a nɛ katsɛnakɔ̃ a. Ye ɔmatɔ bati pii yatse ye fɔtsa katsa, ade fɔkɛna be saa a. Bivia be akũ kĩ, “Ndia oti kĩĩ kɔlɛ fɔtsa kĩĩ odu etomɛna? Kadikanyi mɔ kɔbɛ̃ wɔdabe bɛkpa ye sũ mɔ epuli yakɛna awãwã fɔtsa kĩĩ odu? ");
INSERT INTO bov_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mbɔɛɛ nnɛ́ Maria obi kĩ yamɛ fɔtsa a yanɛ? Ĩye nnɛ́ bawaɛ̃nyole nyɛ Yakobo, Yose, Yuda mɔ Simon? Miádã! Nnɛ́ bawaɛ̃tsole lɛmɛ nɛ awĩ a?” Foesũ bati kĩĩ sĩ ye katɛ kado. ");
INSERT INTO bov_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu bi be kĩ, “Baguma onukpɛ̃ ɔnyɛnɛ tɛ dĩ nɛ kakɔ nyɛ kakɔ, lɛmɛ nɛ ye mɔawɛ ɔmatɔ, mɔ ye mɔawɛ bati kamɛ ni, ɛlá dĩ wĩ lidima.” ");
INSERT INTO bov_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Nɛ ayekĩ ye ɔtɔ bati tátɛ ye bido sũ ni, fɔlɛtsa a nyɛnɛ Yesu akũ. Fɔtsɛ̃ foe akũ sũ ɛtápuli ɛkɛna awãwã fɔtsa pii nɛ awã, kɛba kĩ ete awɛ nɛ basɔnɛ badi akũ, ade be fɔsɔ a dɔ be a. Ke liti a lɛmɛ, Yesu mini nɛ tukula mɔ fɔkɔ a kĩ fufuã awã, ade ɛkatsa Baguma fɔlɛtsa wĩ a. ");
INSERT INTO bov_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɛvɛ ye fɔtsa bakɔlɛnɛ ewua-nviã a ɛkpɔta, ade edo be nviã nviã a. Ɛkpa be kɔbɛ̃ kĩ kɔnya hũhũ kpa flee akũ. ");
INSERT INTO bov_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Esi be mbla kĩ, “Odima ɛtabɔɛ lɛtsama ɛlɛ nɛ ye osi akũ, mbɔɛntɛ otse kĩ bake katsã odi. Mitalɛ funitsã ĩye kuvũ ndɛ ayekĩ fɔtsa bawãnɛ alɛ a. Mitabɔɛ sika milɛ nɛ mi fuvũ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mido mi tɛpambua, lɛmɛ mitabɔɛ tilima bɛbã mibumɛna lɛtsa a kĩ mido a.” ");
INSERT INTO bov_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ebuki ɛlɛ kĩ, “Awã kĩ míase a ni, mina nɛ awã kɛnaawo lɔkɔ a kĩ míadzakũ. ");
INSERT INTO bov_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Awã kĩ bati tátɛ mi ni, minɛ nɛ ɔmatɔ a kamɛ lɔkɔa mikpa mi abɔa kudu miko nɛ be akũ, fɔnya nsɛntsɛlɛni fɔkpa be kĩ Baguma aavɛlɛ be sɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Fɔtsa bakɔlɛnɛ ewua-nviã kĩĩ mini bɛtsa Baguma fɔlɛtsa wĩ a kĩ odi nyɛ odi ɛdani ɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɛblɔmɛna hũhũ kpa pii bitomɛna bati kamɛ. Bɛtsɛla basɔnɛ kugua ade bɛtsa be a. ");
INSERT INTO bov_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lɔkɔ kĩĩ, Lɛgã Herodes kanu lɛkɛnawa wĩ a flee kitonɛkĩ Yesu dĩ gba nɛ kakɔ nyɛ kakɔ. Bati badi kalɛ kĩ, “Yohanes, Mui Ɔwɔlanɛ a, liyidza ebuki eto kanɔkpa ɛya! Ade foesũ edeĩ kɔbɛ̃ yakɛna awãwã fɔtsa a!” ");
INSERT INTO bov_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Badi lɛmɛ lɛ kĩ, “Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya yanɛ.” Babɛbã lɛmɛ lɛ kĩ, “Baguma onukpɛ̃ banyɛnɛ kɔɛ a kamɛ odi yanɛ.” ");
INSERT INTO bov_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lɛmɛ lɔkɔ a kĩ Lɛgã Herodes nu fɔlɛtsa kĩ a ye malo ɛlɛ kĩ, “Yohanes a kĩ nfɔ̃ bitsua ye lɔlɔ a, ade ye liyidza ebuki edzi nkpã a.” ");
INSERT INTO bov_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Lɔkɔ lidi kamɛ ni, Lɛgã Herodes mɔawɛ lɛfɔ̃ bipi Yohanes ade ke ɛfɔ̃ bisuli ye mɔ tɔwɛ̃ bɛkɔa bido nɛ kɔla kĩ bado tɔkpa bakɛnanɛ a kamɛ a. Lɛgã Herodes kɛna fukĩĩ kitonɛkĩ Herodia kĩ ɛkɔã a nya ɔwaɛ̃ Filipo ɔtsɔ̃. ");
INSERT INTO bov_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohanes kabi Herodes kĩ, “Kɛtáfɛta kĩ atɛ awaɛ̃ ɔtsɔ̃ ɔkɔã.” ");
INSERT INTO bov_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Foesũ Yohanes fɔlɛtsa a wo Herodia kalɔɛ, ade ɛbɔɛ ye likesĩ a. Ɛwɛ kĩ yakɔ ye lɛmɛ ɛláapuli ɛkɛna fukĩĩ nɛ Lɛgã Herodes liti. ");
INSERT INTO bov_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kitonɛkĩ Lɛgã Herodes avila Yohanes, ade enyina kĩ Yohanes nyɛ oti wĩ kĩ ye akũ kpalɛ. Ɛkana kɔnɛyi nɛ ye akũ. Yawɛ katse ye fɔtsa katsa a katse fɔkɔ fudi, titɔ kĩ ye fɔlɛtsa awɛ ye ɔwɔlɛ kaha ntɛ enu foe. ");
INSERT INTO bov_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ke kawũna a, osi yabinya ɛkpa Herodia. Luwi a nya Lɛgã Herodes lɛmawi. Lɛgã Herodes vɛ banɔkɔɛ̃ banɔkɔɛ̃ nɛ ye lɛgãkanyakɔ̃, sodzafɔ banɔkɔɛ̃ mɔ banɔkɔɛ̃ nɛ Galilea tite akũ bɛya nɛ kanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia obi oyitsɔ̃ ya ɛyato edo Lɛgã Herodes mɔ ye bakɔba a kawɔlɛ paa nɛ kanyakɔ̃ a. Foesũ Lɛgã Herodes via oyitsɔ̃ a kĩ, “Litsa awɛ kĩ nkpa nɔ?” ");
INSERT INTO bov_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɛlɔ fubo ɛlɛ kĩ, “Lɛtsa nyɛ lɛtsa kĩ aavia yĩ ni, maakpa nɔ, ntɛ fɔ́anya yĩ lɛgãkanyakɔ̃ a sɛkɛ malo!” ");
INSERT INTO bov_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Foesũ oyitsɔ̃ kĩĩ nɛ ɛnavia ɔma kĩ, “Litsa nvia?” Ade ɔma bi ye kĩ, “Via Yohanes, mui ɔwɔlanɛ a, lɔlɔ.” ");
INSERT INTO bov_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oyitsɔ̃ a wɛ sɔwa ɛnaa kɔla a kamɛ, ade ebi Lɛgã Herodes kĩ, “Mawɛ kĩ tsua Yohanes Mui Ɔwɔlanɛ a lɔlɔ kate nɛ tsensi akũ kakpa yĩ finyaa finyaakĩĩ.” ");
INSERT INTO bov_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Fukĩĩ wo Lɛgã Herodes kalɔɛ paa lɛmɛ ɛláapuli ɛdani ye sɛmɛ nɛ fubo a kĩ ɛlɔ nɛ banɔkɔɛ̃ banɔkɔɛ̃ anɛ sũ. ");
INSERT INTO bov_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Foesũ awã naa edo ye ɔblafɔ kĩ ɛnaatsua Yohanes lɔlɔ ɛyamɛna. Ɔblafɔ a natsua naa kɔla kĩ bado bati a ɛnatsua Yohanes lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɛkɔa lɔlɔ a ete nɛ tsensi akũ ade ɛkɔa ɛma oyitsɔ̃ a. Ye malo ɛtɛ ɛkɔa de ɛma ɔma. ");
INSERT INTO bov_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kĩ Yohanes fɔtsa bakɔlɛnɛ a nu fɔlɛtsa a, bɛnaa bɛnabɔɛ ye ɔnɔkpa a bɛnabila. ");
INSERT INTO bov_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Fɔtɔ banyanɛ a kĩ Yesu do kĩ mini nɛ fɔkɔ a kĩ fufuã buki bimuniki, ade bibi ye fɔtsa flee a kĩ bɛkɛna, fɔtsa a kĩ bɛtsa mɔ fɔtsa a kĩ fɔya nɛ be osi akũ a. ");
INSERT INTO bov_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Awã kĩ Yesu mɔ be bɛna a bati a yapɔ lidede, bikĩĩ anaa ni bikĩĩ aya, foesũ bɛtána osi mɔ banya malo. Ade Yesu bi be kĩ, “Mifɔ̃ boe odi bɔnaa awã kĩ kadã dĩĩ bɔnaawɛya sukuloo.” ");
INSERT INTO bov_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Biwo nɛ ɔkɔlɔ kamɛ kĩ banaa awã kĩ bati lɛláa. ");
INSERT INTO bov_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lɛmɛ kĩ banaa a, bati pii mɔ be biyi ɔsũ, ade ke biwula atsɛ bɛnya be lɔtɔ biwo awã fɔmɔ Yesu mɔ ye fɔtsa bakɔlɛnɛ a nawo awã. ");
INSERT INTO bov_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kĩ Yesu nɛ́ nɛ ɔkɔlɔ a kamɛ a, ɛmɔ bati beblebee. Be akũ kɔ ye kɔnya kitonɛkĩ bɛkɛna ndɛ baveli kĩ bɛlá ɔkpãnɛ. Foesũ eyi kayɔ mɔ be Baguma fɔlɛtsa katsa. ");
INSERT INTO bov_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kĩ olobe wo ɔtɔ a, ye fɔtsa bakɔlɛnɛ a ya bɛyabi ye kĩ, “Kade dɔ kiyua. Ayekĩ awĩ la a bɛláana lɛtsama bɛnya. ");
INSERT INTO bov_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Foesũ kpa be osi bɛdzakũ, lɔkɔa ntɛ biwo tɛmatɔ a mɔ tukula kamɛ a, baana litsedi bɛya bɛnya.” ");
INSERT INTO bov_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu bi be kĩ, “Mi mɔawɛ a miwɛ litsedi mikpa be bɛnya.” Bɛkpa mbuayɛ kĩ, “Be kanya aatɛ ndɛ oti mɔa tidetɔ ɛlɛ̃ kɔtɔkase. Awɛ kĩ bubula sika kade nɛ be kanya odi sũ?” ");
INSERT INTO bov_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ade ke Yesu via be kĩ, “Abodoo eni minɛɛ? Minaa minaadã.” Kĩ bɛnadã a bibi ye kĩ, “Abodoo elo mɔ kɔfɔabi nviã pɛ deĩ.” ");
INSERT INTO bov_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ bɛfɔ̃ bati a flee bidzi nɛ kutsu kutsu kamɛ nɛ tuwĩ blɔblɔ akũ. ");
INSERT INTO bov_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bati a flee sɛ̃ bidzi nɛ kutsu kutsu kamɛ. Kutsu kudi aawo ndɛ bati ɔha, kudi lɛmɛ aawo ndɛ aduenum. ");
INSERT INTO bov_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu bɔɛ abodoo elo mɔ kɔfɔabi nviã a ade kĩ ɛdã odetɔ́ kamɛ fɛɛ a, ɛnyɛ Baguma kɔlɛ ade ɛyɛlɛ abodoo a. Ɛkɔa foe ɛkpa ye fɔtsa bakɔlɛnɛ a kĩ bɛsɛ̃ bɛkpa kutsu a flee. Ade ɛkɛna kɔfɔabi a lɛmɛ lɔmɔ a. ");
INSERT INTO bov_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bati a flee nya biwĩ. ");
INSERT INTO bov_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kĩ ye fɔtsa bakɔlɛnɛ a fila funitsã a kĩ fute bɛkpɔta a, fuyi kɔba tɛtsɛtsɛ ewua-nviã. ");
INSERT INTO bov_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ade bati a kĩ bɛnya funitsã a banyole nɛnɛ odi lidede wo mpim elo. ");
INSERT INTO bov_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Awã naa Yesu fɔ̃ ye fɔtsa bakɔlɛnɛ a wo nɛ ɔkɔlɔ kamɛ kĩ bɛnaa ɔmatɔ kĩ bavɛ Betsaida nɛ lutubu baũ sɛkɛ̃ kĩ a. Ɛfɔ̃ bati beblebee a lɛmɛ pansam. ");
INSERT INTO bov_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ke liti a, ye malo ede ɛnaa ɔtɔ kalete ɛnabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ke lɛnyɛ a, ɔkɔlɔ a wo ɔwɔ lutubu baũ a kayite, ade kite Yesu odi nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɛmɔ́ kĩ kɛkapiã ye bati a mɔ ɔkɔlɔ a kahali, kitonɛkĩ ɔwɛ kavũ katsɛlamɔ be. Foesũ fɔmɔ ɔnɔnɛ tɔdɔũ elo aabɔa a, Yesu tsã mui anɛ ɛnaa be sɛkɛ̃. Kĩ efuã be a, ɛkɛna ndɛ yatɛ̃ be, ");
INSERT INTO bov_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ade bɛbɔa fɔwɔla kĩ, “Ɔnɔkpa yanɛ!” ");
INSERT INTO bov_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Libe wo be flee. Lɛmɛ lɛtalɛta Yesu lɛmɔ be kɔdzɛla kĩ, “Mitavila! Yĩ manɛ. Mina ɔwɔlɛ!” ");
INSERT INTO bov_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ewo nɛ be sɛkɛ̃ nɛ ɔkɔlɔ a kamɛ, ade ɔwɛ a fɔ̃ kavũ a. Fukĩĩ fɔ̃ ye fɔtsa bakɔlɛnɛ a kɛna saa, ");
INSERT INTO bov_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kitonɛkĩ bɛtányi ayekĩ fɔkɛna fɔmɔ ɛkpa bati mpim elo funitsã bɛnya bitina. Be kakɔna nɛ fukĩĩ akũ malo tákpalɛ, foesũ bɛtátɛ bido. ");
INSERT INTO bov_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kĩ biwo ɔwɔ lutubu baũ a sɛkɛ sitide a, biduma nɛ Genezaret. Ade awã bɛbla be ɔkɔlɔ bɛdzɛla a. ");
INSERT INTO bov_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mɔ be kanɛ nɛ ɔkɔlɔ a kamɛ pɛ bati mɔ Yesu biyi ɔsũ. ");
INSERT INTO bov_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Foesũ biwula atsɛ bɛnakpa kanyi nɛ be tite flee akũ. Awã kĩ binu kĩ Yesu na a, bɛlɔ basɔnɛ bɛma ye. ");
INSERT INTO bov_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ade kakɔ nyɛ kakɔ kĩ Yesu tsã, ntɛ ɔmatɔ kamɛ o-o, ĩye akula kamɛ o-o, bati kayamɛna basɔnɛ nɛ kɔyaatɔ ade bɛkawã ye kĩ ɛfɔ̃ bɛta ye atadiɛ atɔ. Bikĩ bɛta ye a na akũ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisifɔ mɔ Yudafɔ mbla batsanɛ badi to Yerusalem bɛyatsɛna nɛ Yesu sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bɛmɔ́ kĩ ye fɔtsa bakɔlɛnɛ a dzi banya, ade badi távɔlɛ awɛ ndɛ ayekĩ be Farisifɔ bɛtsa bati kĩ bɛkaakɛna a. ");
INSERT INTO bov_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Biyi foe ɔsũ kitonɛkĩ Farisifɔ a mɔ Yudafɔ a flee tomɔ be bawanyɔ amaniɛ a kĩ bɛkɔa biyi be a. Foesũ ntɛ bɛtávɔlɛ awɛ kavɔlɛ wĩ ni, baánya. ");
INSERT INTO bov_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ntɛ bɛya litsedi bitomɛna kɔyaatɔ malo, kɛnɛ kĩ bavɔlɛ awɛ fɔmɔ banya. Bitomɛna mbla kumɛkumɛ lɛmɛ kĩ bibo anɛ bɛyamɔ a, ndɛ kuyei, fɔtɔtsa mɔ fugumi kavɔlɛ. ");
INSERT INTO bov_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Foesũ Farisifɔ mɔ Yudafɔ mbla batsanɛ a via Yesu kĩ, “Nde sũ bikĩ bitomɛna nɔ a lákɛna nɛ boe bawanyɔ amaniɛ akũ? Ade ntɛ banya malo baávɔlɛ awɛ!” ");
INSERT INTO bov_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kpa mbuayɛ kĩ, “Mi anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ! Fɔlɛtsa a kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ nɛ mi akũ a ya nɛ foe kamɛ pɛpɛɛpɛ. Baguma lɛ kĩ, ‘Bati kĩĩ asum yĩ mɔ onukpɛ̃ kamɛ fɔlɛtsa mɛnɛmɛnɛ odi, lɛmɛ be tɔwɔlɛ deĩ lugo nɛ yĩ sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pupulidza basum yĩ, kitonɛkĩ batsa batidziwa mbla nɛ Baguma mbla a kadokɔ̃.’ ");
INSERT INTO bov_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Fɔatsa kĩ bɛkɔa yĩ mbla biyi nɛ ɔɔwɛ̃ ade bɛkɔa batidziwa amaniɛ a batsa a!” ");
INSERT INTO bov_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu bi be kĩ, “Mideĩ tɛdake tidi kĩ mitomɛna ade mikɔa Baguma mbla miyi nɛ ɔɔwɛ̃ nɛ ayekĩ míakɛna nɛ mi bawanyɔ amaniɛ akũ sũ. ");
INSERT INTO bov_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Foesũ Baguma Onukpɛ̃ Ɔnyɛnɛ Mose tsɛlɛ eyi kĩ, ‘Bu aga mɔ ama.’ Ade ebuki ɛlɛ kĩ, ‘Odi nyɛ odi kĩ edumu ɔlɛga ĩye ɔma ni, kɛnɛ kĩ bɛkɔ ye.’ ");
INSERT INTO bov_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lɛmɛ miatsa kĩ ntɛ odi deĩ litsedi kĩ yaakɔa ebumɔ ye bamanɛ ni, yaapuli ɛlɛ kĩ ɛkɔa foe eyi lite ndɛ fɔtsa kpalɛwa ɛkpa Baguma lɔkɔa fɔatsa kĩ owula kɔa fɔtsa tewa a eyi kĩ yaabɔa afɔliɛ ɛkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ade ke mitákpa ye osi malo kĩ yabumɛna ye bamanɛ a mɔ fɔtsa tewa a! ");
INSERT INTO bov_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ade aye mikɔa mi bawanyɔ amaniɛ mibula Baguma mbla kade a. Miakɛna fɔtsa bɛbã ndɛ fukĩĩ odu.” ");
INSERT INTO bov_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ke liti a, Yesu buki ɛvɛ bati a flee ɛkpɔta nɛ ye sɛkɛ̃. Ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Lɛtsa nyɛ lɛtsa kĩ oti nya mɔ fuwo nɛ ye kamɛ ni, fɔádo ye efĩĩ nɛ Baguma anɛ. Mbom lɛtsa kĩ lato oti ɔwɔlɛ kamɛ a, ade foe ado ye efĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mi flee miyi atɔ mitse katse wĩ.” ");
INSERT INTO bov_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kĩ ɛdzakũ nɛ be sɛkɛ̃ ɛnaa kɔla a, ye fɔtsa bakɔlɛnɛ a via ye kĩ ɛnyɛ lɛgbã a kayɔ ɛtsa be. ");
INSERT INTO bov_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu bi be kĩ, “Ntɛ mitánu kalɛ kĩĩ kayɔ kekɔ̃ mi adzuni lɛláapuli epi lɛtsama. Fɔwaa yedede kĩ lɛtsa kĩ lawo nɛ oti kamɛ ni, fɔádo ye efĩĩ. ");
INSERT INTO bov_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kitonɛkĩ fɔtáwo nɛ ye ɔwɔlɛ kamɛ. Mbom fɔnaa ye sɛmɛ kamɛ, ade fɔtsa ye kamɛ fɔnɛ ndɛ fɔtsa kpa a.” Lɛtsa a kĩ Yesu lɛ nɛ awĩ tsa kĩ funitsã fudi nyɛ fudi nɛnɛ fɔkpa kanya. ");
INSERT INTO bov_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ebuki ɛlɛ ɛnamɛna lɔtɔ kĩ, “Lɛtsa a kĩ lanɛ kato oti ɔwɔlɛ kamɛ ni, ade foe ado ye efĩĩ a. ");
INSERT INTO bov_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kitonɛkĩ oti ɔwɔlɛ kamɛ tɔkpa kakɔna ato, tɔkpa a tidi nyɛ linyolewɛ mɔ litsolewɛ, kaye, oti kakɔ, kɔnyɔ mɔ kɔtsɔ̃ liti kanɛ, ");
INSERT INTO bov_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","anɛ ngbã, ablɔ kakɛna, fɔvã kama, sukɛna fɔwɛtsa kĩ fɔnɛnɛ, likesĩ, fɔvã kama kate nɛ bati akũ, lukũta mɔ kadzi nɛ tidzimbi kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Fɔtsa kĩĩ flee to oti kamɛ ade foe ado ye efĩĩ a.” ");
INSERT INTO bov_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu dzakũ ɛnaa tite a kĩ tifuã ɔmatɔ kĩ bavɛ Tiro a kamɛ. Ɛwo nɛ tɔtɔ tidi kamɛ. Ɛtáwɛ kĩ odima enyi kĩ edeĩ nɛ awã, lɛmɛ ɛtápuli ɛkɔla ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Otsole odi kĩ hũhũ kpa deĩ nɛ ye obi kamɛ nu kĩ Yesu na nɛ awã, ade ɛya ɛyake aduli nɛ ye anɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Otsole kĩĩ nyɛ ɔnɔvɔɛ̃ kĩ bɛmɔ Yudafɔ baákã. Ɛnyɛ Foenikeni kĩ eto Siria tite akũ. Eke Yesu aduli kĩ ɛblɔmɛna hũhũ kpa a etomɛna obitsole kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lɛmɛ Yesu bi ye kĩ, “Fɔ̃ bɛkpa babisɛ̃ funitsã tɔ̃. Fɔnɛ́nɛ kĩ bakɔa babisɛ̃ funitsã bɛkpa bakpete.” ");
INSERT INTO bov_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Awã naa otsole a kpa mbuayɛ kĩ, “Awoo, boe Ɔlɛga, lɛmɛ bakpete a kĩ bikoni nɛ kanyakɔ̃ a ana osi kanya babisɛ̃ funitsã a kĩ fuwuli fuko nɛ tite a.” ");
INSERT INTO bov_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu bi ye kĩ, “Nɛ lɛtsa a kĩ ɔlɛ nɛ awĩ sũ ni, kaanaa kɔla. Aamɔ kĩ hũhũ kpa a nɛ́ nɛ nɔ obitsole a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Otsole kĩĩ naa kɔla, ade ɛmɔ kĩ obi a waa nɛ ɔkɛna akũ, lɔkɔa hũhũ kpa a nɛ nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kĩ Yesu dzakũ nɛ Tiro kayite a ade ɛtsã Sidon ɔmatɔ a kamɛ a, ɛtsã Galilea ɔwɔ lutubu baũ abuĩ, ɛnaa tɛmatɔ ewua a kamɛkamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nɛ awã a, bati badi yamɛna odi kĩ esĩ atɔ ade ɛnyɛ omumu lɛmɛ a. Bike ye aduli kĩ ete awɛ nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Foesũ Yesu kpã ye ɛnamɛna ɔɔwɛ̃, ade ɛkɔa bawobi edo nɛ ye atɔ kamɛ a, ade etua tanɛ lɛmɛ ete nɛ lawobi akũ ɛkɔa ekputa onyole a sɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ade Yesu dzɛla anɛ ɛdã ode, ɛwɛya eke fɛɛ ade ebi onyole a kĩ, “Hefata,” foe kayɔ nyɛ kĩ, “Binya!” ");
INSERT INTO bov_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Deedimɔapɛ onyole a atɔ binya ade ye sɛmɛ tɔwɛ̃ wũnya, epuli ɛlɛ kɔdzɛla a. ");
INSERT INTO bov_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu sua bati a kĩ bɛdzɛ̃ nɛ awã osi kĩ bɛtabi odima lɛtsama nɛ lɛtsa a kĩ bɛmɔ́ a akũ. Lɛmɛ pupulidza esi be mbla, kitonɛkĩ be flee bɛnaa bɛnalɛ lɛtsa kĩ lɛya a. ");
INSERT INTO bov_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bati a flee kĩ binu fɔlɛtsa kĩ a, fɔkɛna be saa! Ade bibi akũ kĩ, “Yakɛna lɛtsa nyɛ lɛtsa kakɛna wĩ. Ɛfɔ̃ omumu alɛ kɔdzɛla, ade ɔtɔsĩnɛ lɛmɛ anu fɔkɔ a!” ");
INSERT INTO bov_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Owi tábuna fɔmɔ bati pii yatsɛna nɛ awã. Kĩ lɛtsama lɛláa kĩ baanya sũ ni, Yesu vɛ ye fɔtsa bakɔlɛnɛ a efuãmɔ ye ade ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Bati kĩĩ fɔlɛtsa akɔ yĩ kɔnya kitonɛkĩ bɛna nɛ yĩ sɛkɛ̃ fuwi ɛlalɛ flee. Ade finyaakĩĩ bɛlá lɛtsama kĩ baanya. ");
INSERT INTO bov_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ntɛ nfɔnɛ be awɛ mɔ bɛdzakũ mɔ kɔlɛ ni, baanaa lɔkɔa anɛ aasinya be nɛ osi, kitonɛkĩ badi to mɔ lugo.” ");
INSERT INTO bov_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ye fɔtsa bakɔlɛnɛ a via ye kĩ, “Nɛ kɔsa kĩĩ kamɛ, ndia oti odi aana funitsã ɛkpa bati kĩ bɛnya biwĩ?” ");
INSERT INTO bov_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Awã na Yesu via be kĩ, “Abodoo eni minɛɛ?” Bibi ye kĩ, “Bɔnɛɛ abodoo evũkɔnɔ.” ");
INSERT INTO bov_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu bi bati a kĩ bɛkɛna akũ bidzi. Ade ɛbɔɛ abodoo evũkɔnɔ a. Ɛnyɛ Baguma kɔlɛ ade ɛyɛlɛ ye fɔkɛfɔkɛ a, ɛkɔa ɛkpa ye fɔtsa bakɔlɛnɛ a kĩ bɛkɔa bɛkpa bati a flee. Be malo bɛtɛ, ade bɛsɛ̃ bɛkpa be a. ");
INSERT INTO bov_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bɛnɛɛ kɔfɔabi kubii kudi lɛmɛ nɛ awã, ade Yesu bɔɛ koe lɛmɛ ɛnyɛ kɔlɛ a. Ɛkɔa koe ɛkpa ye fɔtsa bakɔlɛnɛ a kĩ bɛsɛ̃ koe lɛmɛ bɛkpa be. ");
INSERT INTO bov_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Bati a flee nya biwĩ. Bati a lidede aawo mpim ɛna. Kĩ bɛnya biyua a, ye fɔtsa bakɔlɛnɛ a fila fuwuliwa a kĩ fute a bɛkpɔta ade fuyi kɔba tɛtsɛtsɛ kpale kpale evũkɔnɔ a. Ke liti a, Yesu nyɛ bati a flee osi ade bɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesu mɔ ye fɔtsa bakɔlɛnɛ a wo nɛ ɔkɔlɔ kamɛ binyina bɛnaa Dalmanuta tite akũ. ");
INSERT INTO bov_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisifɔ badi ya nɛ Yesu sɛkɛ̃ ade bɛkavia ye fɔlɛtsa kĩ basɔ ye bɛdã. Foesũ bibi ye kĩ ɛkɛna awãwã fɔtsa fudi lɔkɔa bɛmɔ kĩ eto Baguma sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lɛmɛ Yesu wɛya eke ade evia be kĩ, “Nde sũ koũ nviã babi awɛ kĩ bamɔ awãwã fɔtsa? Oowo, mabi mi kĩ nláayakɛna awãwã fɔtsa a odu kĩ miawɛ nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɛdzakũ nɛ be sɛkɛ̃ ade ebuki ewo nɛ ɔkɔlɔ a kamɛ enyina ɛnaa ɔwɔ lutubu baũ a sɛkɛ̃ sitide a. ");
INSERT INTO bov_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kĩ banaa a, ye fɔtsa bakɔlɛnɛ a lɛla abodoo kabɔɛ kabu, foesũ abodoo a amɔapɛ bɛna nɛ ɔkɔlɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu bi be kĩ, “Midã kadã wĩ nɛ Lɛgã Herodes mɔ Farisifɔ oyila a akũ.” ");
INSERT INTO bov_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bɛkavia akũ kĩ, “Ade ayekĩ bɔnɛ́ɛ abodoo adima sũ mɔ ɛlɛ fukĩĩ a.” ");
INSERT INTO bov_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Lɛmɛ Yesu nyi lɛtsa a kĩ bɛkalɛ a, ade evia be kĩ, “Nde sũ mialɛ abodoo katabɔɛ fɔlɛtsa? Foesũ kɛyawo lɔkɔ kĩĩ a mitáyi ɔsũ ĩye mitánu foe kayɔ tɔ̃? Mi atɔ deĩ ɔsĩ paa! Miáte lɛtsama anɛ? ");
INSERT INTO bov_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mideĩ anɛ lɛmɛ miámɔ! Mideĩ atɔ lɛmɛ miánu! ");
INSERT INTO bov_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mitámɔ lɔkɔ a kĩ nsɛ̃ abodoo elo nkpa bati mpim elo bɛba a? Tɛtsɛtsɛ eni fɔkɛfɔkɛ kubii a kĩ fute a yi?” Bibi ye kĩ, “Kɔba tɛtsɛtsɛ ewua-nviã.” ");
INSERT INTO bov_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu buki evia be kĩ, “Mɔ lɔkɔ a kĩ nsɛ̃ abodoo evũkɔnɔ nkpa bati mpim ɛna a, awuliwa a kĩ ete a, tɛtsɛtsɛ eni eyi?” Bibi ye kĩ, “Te kpale kpale evũkɔnɔ.” ");
INSERT INTO bov_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ade evia be kĩ, “Kɛyawo nviã kĩĩ a, nde sũ mɔ miányi oti a odu kĩ ye manɛ?” ");
INSERT INTO bov_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ a wo Betsaida a, bati badi kpã ɔnɛkunɛ bɛma ye ade bike ye aduli kĩ ɛkɔa awɛ ɛta ɔnɛkunɛ a. ");
INSERT INTO bov_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu pi oti a nɛ kɔkpɔ ade ɛkpã ye ɛnamɛna ɔmatɔ a ɔbaɛ̃ a. Kĩ evũma tanɛ eko nɛ oti a anɛ kamɛ a, ɛkɔa awɛ ete nɛ ye akũ ade evia ye kĩ, “Amɔ litsedi?” ");
INSERT INTO bov_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ade oti a dzɛla anɛ ɛdã ode ɛlɛ kĩ, “Oo! Mamɔ bati, lɛmɛ badã ndɛ futse. Lɛmɛ bɛtsɛ̃ bamini.” ");
INSERT INTO bov_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ade Yesu buki ɛta ye anɛ a. Lɛyade kĩ kɔ̃ oti a binya ye anɛ yededeede, ye anɛ kamɛ kpalɛ ade ɛmɔ lɛtsa nyɛ lɛtsa kamɔ wĩ a. ");
INSERT INTO bov_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu nyɛ ye osi ebi ye kĩ ɛtabuki ɛtsã ɔmatɔ a kamɛ ɛnaa kɔla. ");
INSERT INTO bov_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ke liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a dzakũ nɛ awã bɛnaa tukula kĩ tifuã Kaisarea nɛ Filipi kamɛkamɛ a. Kĩ banaa nɛ osi a, Yesu via be kĩ, “Mibi yĩ oti a odu kĩ bati alɛ kĩ ye manɛ.” ");
INSERT INTO bov_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bibi ye kĩ, “Badi alɛ kĩ nɔ nyɛ Yohanes Mui Ɔwɔlanɛ a. Ade badi lɛmɛ alɛ kĩ nɔ nyɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya. Badi bɛbã lɛmɛ alɛ kĩ nɔ nyɛ Baguma onukpɛ̃ banyɛnɛ kɔɛ a kamɛ ɔmɔa.” ");
INSERT INTO bov_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ade ke Yesu buki evia be kĩ, “Nde nyɛ mi lɛmɛ? Owei mialɛ kĩ ye manɛ?” Petro bi ye kĩ, “Nɔ nyɛ Kristo a Kĩ Bɛbɔa Tɔdɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu sua be osi kĩ bɛtabi odima lɛtsa a kĩ binyi nɛ ye akũ nɛ awĩ a. ");
INSERT INTO bov_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ade Yesu yi kayɔ mɔ ye fɔtsa bakɔlɛnɛ a fɔtsa fudi katsa a. Ebi be kĩ, “Kɛnɛ kĩ fɔya kĩ Otidziwa Obi a ɛmɔ lubo etomɛna ɔmatɔ banɔkɔɛ̃, Yudafɔ basɔfɔ banɔkɔɛ̃, mɔ Yudafɔ mbla batsanɛ a awɛ kamɛ. Ade baasĩ ye, bɛkɔ ye, lɛmɛ nɛ luwi lɛlalɛde akũ ni, yaayidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ebi be fukĩĩ yededeede binu. Petro kpã ye ɛnamɛna ɔɔwɛ̃, ade ɛtsa kĩ bɛmɔ ye bɛtákɛna ɔmɔa nɛ lɛtsa a kĩ ɛlɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lɛmɛ kĩ Yesu dani ɛdã ye fɔtsa bakɔlɛnɛ a, ɛkã Petro anɛ ɛlɛ kĩ, “Dzakũ nɛ yĩ akũ Satana! Aáwɛ fɔtsa a kĩ Baguma awɛ a, mbom awɛ lɛtsa a kĩ batidziwa awɛ a odi!” ");
INSERT INTO bov_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Foesũ Yesu vɛ bati kɔdabu a mɔ ye fɔtsa bakɔlɛnɛ a bɛya nɛ ye sɛkɛ̃ ade ebi be kĩ, “Ntɛ odi awɛ kĩ yatomɔ yĩ ni, kɛnɛ kĩ yafɔnɛ ye apɛdiɛ awɛ, ɛbɔɛ ye lubo kamɔ fɔlɔtsa luwi nyɛ luwi lɔkɔa etomɔ yĩ nɛ liti. ");
INSERT INTO bov_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kitonɛkĩ oti kĩ ɛwɛ kĩ yapili ye nkpã ni, yaayɛla ye. Lɛmɛ oti kĩ ɛkɔa ye akũ ɛkpa nɛ yĩ mɔ Kalɛ Wĩ a sũ ni, yaana nkpã daa. ");
INSERT INTO bov_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Litsa nfasɔ oti aana ntɛ ɛna katinya kamɛ fɔtsa flee mɔ ɛyɛla ye nkpã mɔawɛ a? ");
INSERT INTO bov_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ĩye litsa oti aakɔa ɛvɛmɛna mɔ nkpã mɔawɛ a? ");
INSERT INTO bov_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Foesũ ntɛ yĩ mɔ yĩ fɔtsa katsa a flee nyɛ fɔnyɔãtsa fɔkpa odi nɛ ablɔ katinya kpa kĩĩ kamɛ ni, ye malo yaanya fɔnyɔãtsa ɛkpa Yĩ Otidziwa Obi, nɛ lɔkɔ a kĩ bɔmɔ́ Baguma fɔtɔ banyanɛ kpalɛwa a bɔ́aya nɛ Baguma kukũkpalɛ a flee kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu buki ebi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, badi deĩ nɛ mi kamɛ nɛ awĩ kĩ bɛláaku kɛnaawo kĩ bɛmɔ́ Baguma lɛgãkanya a ya mɔ kɔbɛ̃.” ");
INSERT INTO bov_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Fuwi evũ liti a, Yesu kpã Petro, mɔ Yakobo, mɔ Yohanes bɛnaa ɔtɔ akũ, awã kĩ be bɛna. Kĩ fɔtsa bakɔlɛnɛ a kadã a, Yesu akũ dani nɛ be anɛ kamɛ, ");
INSERT INTO bov_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ade ye tɛtadiɛ dani tivoe kɛba ayekĩ otidziwa aapuli ɛvɔlɛ te tɛnɛ́ lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Adeke fɔtsa bakɔlɛnɛ ɛlalɛ a mɔ́ Baguma onukpɛ̃ banyɛnɛ Mose mɔ Eliya kĩ bɛnyɛ be akũ bɛkalɛ kɔdzɛla mɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ade Petro bi Yesu kĩ, “Fɔtsa Ɔtsanɛ, fɔnɛnɛ kĩ bɔya nɛ awĩ! Fɔ̃ bɔkɛna tɛpatampa ɛlalɛ, nɔ ade amɔa, Mose ade amɔa, lɔkɔa Eliya lɛmɛ ade amɔa.” ");
INSERT INTO bov_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Lɛmɛ enyína lɛtsa a kĩ ɛkalɛ a, kitonɛkĩ bɛtɛ́nɛ kavila. ");
INSERT INTO bov_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lufulututu lidi ka lɛyasua be akũ, ade odo nɛ́ eto de kamɛ kĩ, “Ade yĩ obi kĩ maátunɔ ye kalɛ a, mitse ye kalɛ!” ");
INSERT INTO bov_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lɛtalɛta bɛdã fɔkɔ bisinya lɛmɛ bɛtámɔ odima kɛba Yesu kĩ ɛdzɛ nɛ be ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kĩ bito ɔtɔ akũ baka a, Yesu si be mbla kĩ, “Mitabi odima lɛtsa a kĩ mimɔ́ a kɛnaawo lɔkɔ kĩ Otidziwa Obi a yidza eto banɔkpa kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bɛfɔ̃ kalɛ kĩĩ kahɔ nɛ be lɔlɔ kamɛ, lɛmɛ ntɛ be odi bidzi a balɛ kɔdzɛla nɛ foe akũ kavia akũ kĩ, “Kayidza kato kanɔkpa a kayɔ nyɛ litsa?” ");
INSERT INTO bov_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Adeke bivia Yesu kĩ, “Litsa sũ Yudafɔ mbla batsanɛ a alɛ kĩ, kɛnɛ kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya ɛnya lɔtɔ ɛya?” ");
INSERT INTO bov_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu bi be kĩ, “Nuwĩ, kɛnɛ kĩ Eliya ɛnya lɔtɔ ɛya ayekĩ yaamanɛ lɛtsa nyɛ lɛtsa eyi. Litsa sũ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ Otidziwa Obi a aayamɔ lubo pii, bisupa ye lɛmɛ a? ");
INSERT INTO bov_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mabi mi kĩ Eliya ya kɔkɔɛ ade bɛkɛna ye lɛtsa a kĩ bɛwɛ a, ndɛ ayekĩ bɛtsɛlɛ biyi nɛ ye akũ a.” ");
INSERT INTO bov_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kĩ Yesu mɔ ye fɔtsa bakɔlɛnɛ ɛlalɛ a muniki bɛya nɛ be nkaɛ a sɛkɛ̃ a, bɛmɔ́ bati kɔdabu baũ kĩ bisinya be, ade mbla batsanɛ a badi kavɛlɛ fɔlɛtsa mɔ be a. ");
INSERT INTO bov_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kĩ bati a kɔdabu a mɔ́ Yesu a, akũ dzuli be, ade biwula atsɛ bɛnawɔ̃na ye a. ");
INSERT INTO bov_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu via ye fɔtsa bakɔlɛnɛ a kĩ, “Litsa fɔlɛtsa milamɔ kavɛlɛ mɔ be?” ");
INSERT INTO bov_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Onyole odi nɛ bati kɔdabu a kamɛ kpa mbuayɛ kĩ, “Fɔtsa Ɔtsanɛ, nkpã yĩ obi mma nɔ, kitonɛkĩ hũhũ kpa deĩ nɛ ye kamɛ ade yaapuli ɛlɛ kɔdzɛla a. ");
INSERT INTO bov_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kakɔ nyɛ kakɔ kĩ hũhũ a api ye ni, yabɔɛ ye kamuni nɛ tite, ade kuvũ anɛ nɛ ye onukpɛ̃, yaba adɔ̃ lɔkɔa ye akũ flee asinsĩ. Nkpã ye mma nɔ fɔtsa bakɔlɛnɛ a kĩ bɛblɔmɛna hũhũ a, lɛmɛ bɛtápuli.” ");
INSERT INTO bov_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu bi be kĩ, “O! Nviã babi kĩ milá katɛkado! Maana nɛ mi sɛkɛ̃ daa? Lɔkɔ lɔɔdabe mado ɔwɔlɛ nvɛlɛ mi nnaawo? Mikpã kanyolebi a mima yĩ!” ");
INSERT INTO bov_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bɛkpã ke bɛma Yesu. Kĩ hũhũ a sila ɛmɔ Yesu a, efufulinya kanyolebi a kɛka kɛtɔ, kɛkamilinya nɛ tite kanɛ kuvũ nɛ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ade Yesu via ɔlɛga kĩ, “Lɔkɔ ɔdabe fuyi ye kayɔ?” Ɛkpa mbuayɛ kĩ, “Kito anɛ ye tibisɛ̃ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lɔkɔ pii hũhũ kpa a awɛ kĩ yakɔ ye, foesũ yabɔɛ ye kamuni nɛ fi ĩye mui kamɛ. Ntɛ aapuli ɔkɛna litsedi ni, mɔ́ boe kɔnya lɔkɔa kabumɔ boe.” ");
INSERT INTO bov_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu bi ye kĩ, “Kalɛ ɔlɛ kĩ ntɛ maapuli? Lɛtsa nyɛ lɛtsa aapuli lɛya lɛkpa oti kĩ ɛtɛ yĩ edo.” ");
INSERT INTO bov_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Deedimɔapɛ kabisɛ̃ɛ̃ a ɔlɛga bɔa fɔwɔla kĩ, “Ndeĩ katɛkado, lɛmɛ kɛpɔ́nɛ, bumɔ yĩ nna katɛkado mbu!” ");
INSERT INTO bov_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kĩ Yesu mɔ́ kĩ bati kɔdabu a kadu kafuã be a, ewũni nɛ hũhũ kpa a akũ kĩ, “Nɔ hũhũ kpa ɔtɔsĩnɛ mɔ omumu, mabi nɔ kĩ nɛ nɛ kabisɛ̃ɛ̃ a kamɛ, tabuki ɔyaawo nɛ ke kamɛ dadaada!” ");
INSERT INTO bov_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hũhũ kpa a bɔa fɔwɔla kɔɔba, efufulinya kabisɛ̃ɛ̃ a mɔ ɔsĩ, ɛbɔɛ ke emuni nɛ tite, ade ɛnɛ́ nɛ ke kamɛ a. Kabisɛ̃ɛ̃ a kɛna ndɛ kaku kiku, foesũ bati a pii lɛ kĩ, “Eku!” ");
INSERT INTO bov_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lɛmɛ Yesu pi kabisɛ̃ɛ̃ a nɛ kɔkpɔ ade kiyidza kɛdza a. ");
INSERT INTO bov_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ke liti a, kĩ Yesu naa tɔtɔ kamɛ a, ye fɔtsa bakɔlɛnɛ a via ye pɛtɛɛ kĩ, “Nde sũ boe kɔ̃ bɔtápuli bɔblɔmɛna hũhũ kpa a ɛnɛ́ nɛ ye kamɛ?” ");
INSERT INTO bov_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ade Yesu bi be kĩ, “Bɛláapuli bɛblɔmɛna hũhũ kĩĩ odu, mbɔɛntɛ bɛtsãmɛna foe mpaɛbɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu mɔ ye fɔtsa bakɔlɛnɛ a dzakũ nɛ awã bɛnatsã Galilea. Yesu táwɛ kĩ odima anyi awã kĩ ɛnaa, ");
INSERT INTO bov_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kitonɛkĩ ɛkatsa ye fɔtsa bakɔlɛnɛ a fɔtsa. Ebi be kĩ, “Baakɔa Otidziwa Obi a bido nɛ bati awɛ ade baakɔ ye a, lɛmɛ nɛ luwi lɛlalɛde liti a, yaayidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lɛmɛ bɛtánu lɛtsa kĩ ebi be a kayɔ, ade bivila kĩ bavia ye a. ");
INSERT INTO bov_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɛyawo Kapernaum ɔmatɔ a kamɛ, ade kĩ biwo nɛ tɔtɔ kamɛ a, Yesu via ye fɔtsa bakɔlɛnɛ a kĩ, “Litsa kalɛ mivɛlɛ nɛ osi a?” ");
INSERT INTO bov_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lɛmɛ bɛtákpa ye mbuayɛ, kitonɛkĩ nɛ osi akũ a, bɛkavɛlɛ fɔlɛtsa nɛ owula kĩ ɛbɛ̃ flee nɛ be kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kɛna akũ edzi ɛvɛ fɔtsa bakɔlɛnɛ ewua-nviã a, ebi be kĩ, “Odi nyɛ odi kĩ yawɛ lɔtɔ ɛnya ni, kɛnɛ kĩ ɛnya bati a flee nkaɛ mɔ ɔsumunɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ke liti a, ɛkpã kabisɛ̃ɛ̃ kadi kɛyadza nɛ be anɛ kamɛ, ade kĩ etu eboomu ke a, ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Odi nyɛ odi kĩ yaatɛ kabisɛ̃ɛ̃ kĩĩ kamɛ ɔmɔa nɛ yĩ dĩ akũ ni, yĩ ɛtɛ. Odi nyɛ odi kĩ ɛtɛ yĩ ni, nnɛ́ yi odi ɛtɛ, mbom ɛtɛ oti a kĩ edo yĩ a lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ade Yohanes bi Yesu kĩ, “Fɔtsa Ɔtsanɛ, bɔmɔ́ onyole odi kĩ ɛkablɔmɛna hũhũ kpa nɛ nɔ dĩ akũ, ade bubi ye kĩ ɛfɔ̃, kitonɛkĩ ɛláa boe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu bi be kĩ, “Mitasua ye osi, kitonɛkĩ oti kĩ yakɛna awãwã fɔtsa nɛ yĩ dĩ akũ ni, ɛláadani ɛlɛ kalɛ kpa nɛ yĩ akũ. ");
INSERT INTO bov_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Odi nyɛ odi kĩ yaákɛna lɛtsama katia boe ni, ɛdzɛ̃ nɛ boe liti. ");
INSERT INTO bov_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Ɔnɔkɔali a mabi mi kĩ odi nyɛ odi kĩ yaakpa mi mui mimɔa kĩ minyɛ yĩ bade sũ ni, yaana ye kɔtɔkase kokooko.” ");
INSERT INTO bov_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ntɛ oti odi aafɔ̃ kabisɛ̃ɛ̃ kĩĩ kamɛ ɔmɔa kĩ ɛtɛ yĩ edo lɛyɛla ye katɛkado ni, fɔnɛnɛ fɔbɛ̃ fɔkpa oti a ntɛ bɛkɔa kɔwɔlɛ bɛvɛla nɛ ye sɔmɔ, bɛta ye bido nɛ mpo kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Foesũ ntɛ nɔ awɛ afɔ̃ akɛna tɔkpa ni, tsua ye kamuni. Fɔnɛnɛ fɔbɛ̃ fɔkpa nɔ kĩ aakɔa awɛ mɔa owo nɛ nkpã kĩ ɛlá kawũna kamɛ, kɛba kĩ odeĩ awɛ nviã lɔkɔa bɛkɔa nɔ bido nɛ fi luwotu kĩ laádĩ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ade ntɛ nɔ kɔbɔa akpã nɔ kado nɛ tɔkpa kamɛ ni, tsua koe kamuni. Fɔnɛnɛ fɔbɛ̃ kĩ odeĩ kɔbɔa mɔa ɔna nkpã mɔawɛ a, kɛba kĩ odeĩ abɔa nviã ade baata nɔ bido nɛ fi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ntɛ nɔ linebi akpã nɔ kado nɛ tɔkpa kamɛ ni, bɔlɛ de kanyɛ. Fɔnɛnɛ fɔkpa nɔ kĩ aakɔa linebi mɔa owo nɛ Baguma lɛgãkanyakɔ̃ a, kɛba kĩ odeĩ banebi nviã lɛmɛ baata nɔ bido nɛ fi luwotu kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Awã kĩ batebi a kĩ bawo be a láku dadaada, ade fi a kĩ fɔapila be a lɛmɛ ládĩ da a.’ ");
INSERT INTO bov_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kitonɛkĩ baakɔa fi bɛkpalɛ odi nyɛ odi akũ ndɛ ayekĩ bakɔa lɛdɛmɛ kakpalɛ afɔliɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Lɛdɛmɛ nɛnɛ, lɛmɛ ntɛ de ɔmɛnɛ nɛ́ nɛ de kamɛ ni, nde aakɛna obuki ɔkɔa ɔmɛnɛ odo nɛ de kamɛ? Foesũ mina tɔkɔba kakɛna lɛdɛmɛ nɛ mi kamɛ, lɔkɔa midzi nɛ lukudɔ kamɛ mɔ akũ akũ.” ");
INSERT INTO bov_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu dzakũ nɛ awã ɛnaa Yudea amantam kamɛ mɔ Yordan Ɔwɔ liti. Bati kɔdabu buki bɛyatsɛna nɛ ye akũ nɛ awã, ade ɛtsa be fɔtsa ndɛ ayekĩ yawɛ kakɛna a. ");
INSERT INTO bov_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisifɔ badi ya nɛ ye sɛkɛ̃ bɛwɛ kĩ basɔ ye bɛdã, foesũ bivia Yesu kĩ, “Boe mbla a kpa osi kĩ onyole esĩ ɔtsɔ̃?” ");
INSERT INTO bov_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kɔa kavia ɛkpa mbuayɛ kĩ, “Mbla adabe Mose kpa mi?” ");
INSERT INTO bov_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɛkpa mbuayɛ kĩ, “Mose kpa osi kĩ onyole ɛtsɛlɛ kasĩ ovoli ɛkpa ye kanyi lɔkɔa esĩ ye.” ");
INSERT INTO bov_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu bi be kĩ, “Mose tsɛlɛ mbla kĩĩ nɛ mi atɔ ɔsĩ sũ. ");
INSERT INTO bov_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kito katinya kayɔkayi a, onyole mɔ otsole Baguma kɛna. ");
INSERT INTO bov_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nɛ fukĩĩ sũ onyole aafɔnɛ ɔlɛga mɔ ɔma awɛ ɛkɛna ɔmɔa mɔ ɔtsɔ̃, ");
INSERT INTO bov_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","lɔkɔa be nviã a baakɛna oti ɔmɔa. Foesũ bibuki bɛnyɛ́ bati nviã, mbom bɛkɛna oti mɔa. ");
INSERT INTO bov_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Foesũ lɛtsa a kĩ Baguma boomu ni, otidziwa ɛtasɛ̃ foe kamɛ!” ");
INSERT INTO bov_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ke liti a, kĩ bɛya nɛ tɔtɔ kamɛ a, ye fɔtsa bakɔlɛnɛ a via ye fɔlɛtsa nɛ fukĩ ɛlɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu bi be kĩ, “Onyole kĩ esĩ ɔtsɔ̃ mɔ ebuki ɛkɔã ɔbɛbã ni, ɛbɔa adɔpaa nɛ ɔtsɔ̃ akũ. ");
INSERT INTO bov_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ade ayea ntɛ otsole fɔnɛ ɔnyɔ awɛ mɔ ɛnadzi mɔ onyole bɛbã ni, ye malo ɛbɔa adɔpaa.” ");
INSERT INTO bov_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nɛ lɔkɔ a na kamɛ a, bati badi kpã babisɛ̃ bɛma Yesu kĩ ete awɛ nɛ be akũ, lɛmɛ ye fɔtsa bakɔlɛnɛ a kã be anɛ. ");
INSERT INTO bov_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kĩ Yesu mɔ fukĩĩ a ni, ɛna kalɔkpa ade ebi ye fɔtsa bakɔlɛnɛ a kĩ, “Mifɔ̃ babisɛ̃ bɛya nɛ yĩ sɛkɛ̃, mitasua be osi, kitonɛkĩ ade bati kĩĩ odu lá Baguma lɛgãkanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɔnɔkɔali a mabi mi kĩ odi nyɛ odi kĩ ɛtátɛ Baguma lɛgãkanyakɔ̃ a ndɛ obisɛ̃ aye ni, ɛláawo nɛ Baguma lɛgãkanyakɔ̃ a kamɛ da.” ");
INSERT INTO bov_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ke liti a, etu eboomu babisɛ̃ a, ade ete awɛ nɛ be akũ ehila be a. ");
INSERT INTO bov_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kĩ Yesu yidza epi osi a, onyole odi wula atsɛ ɛyake aduli nɛ ye anɛ kamɛ evia ye kĩ, “Fɔtsa Ɔtsanɛ Wĩ, litsa kɛnɛ kĩ nkɛna fɔmɔ maana nkpã kĩ ɛlá kawũna a?” ");
INSERT INTO bov_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu via ye kĩ, “Nde sũ avɛ yĩ oti wĩ? Odima lɛnyɛ́ oti wĩ mbɔɛntɛ Baguma odi. ");
INSERT INTO bov_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Onyina Baguma mbla a. Takɔ oti, tanɛ kɔnyɔ ĩye kɔtsɔ̃ liti, taye, tama fɔvã ote nɛ oti akũ, tasisi oti, mɔ bu aga mɔ ama.” ");
INSERT INTO bov_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Onyole a bi ye kĩ, “Fɔtsa Ɔtsanɛ, kito nɛ yĩ tibisɛ̃ kamɛ kĩ makɛna nɛ tɛbla a flee akũ.” ");
INSERT INTO bov_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu dã ye kɛnaana nɛ ɔdɔ kamɛ, ade ebi ye kĩ, “Kite nɔ lɛtsa mɔa. Naa kanaafila fɔtsa a kĩ odeĩ a flee kanɔ, kakɔa sika a kakpa ahiãfɔ, lɔkɔa aadani ɔkɛna osikani nɛ ode. Ke liti a, ya kayaatomɔ yĩ!” ");
INSERT INTO bov_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kĩ onyole a nu fɔlɛtsa kĩĩ a, emuna anɛ ade ɛdzakũ mɔ ayɔlɔhɔ a, kitonɛkĩ ɛna akũ. ");
INSERT INTO bov_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu dã ye fɔtsa bakɔlɛnɛ a ɛtsɛna ade ebi be kĩ, “Fɔ́ana ɔsĩ paa fɔkpa osikafɔ kĩ baawo nɛ Baguma lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fɔlɛtsa kĩĩ dzuli ye fɔtsa bakɔlɛnɛ a akũ. Lɛmɛ Yesu buki ebi be kĩ, “Yĩ babi, Baguma lɛgãkanyakɔ̃ a kamɛ kawo deĩ ɔsĩ paa fɔkpa asikafɔ. ");
INSERT INTO bov_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Fɔ́adã bɔɛɛ fɔkpa ɔpɔnkɔ mɔ kapu kĩ yaatsã ɔnɔbɔ̃ ɔkɛ kamɛ ɛnɛ kɛba kĩ osikani aawo nɛ Baguma lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Fɔlɛtsa kĩĩ a kɛna fɔtsa bakɔlɛnɛ a wãwã paa. Ade bɛkavia akũ kĩ, “Lɔkɔa owei koũ aapuli ɛna nkpã katɛ?” ");
INSERT INTO bov_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu dã be kɛnanaana ade ɛlɛ kĩ, “Batidziwa sɛkɛ̃ mɔ fɔláapuli fɔya, lɛmɛ nnɛ́ mɔ Baguma, kitonɛkĩ lɛtsa nyɛ lɛtsa adã bɔɛɛ lɛkpa Baguma.” ");
INSERT INTO bov_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ade Petro lɛ kĩ, “Dã, bɔfɔnɛ lɛtsa nyɛ lɛtsa awɛ buyi bɔya butomɛna nɔ.” ");
INSERT INTO bov_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu lɛ kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi ɛfɔnɛ ye tɔtɔ eyi, ĩye bawaɛ̃nyole mɔ bawaɛ̃tsole, ĩye ɔma, ĩye ɔlɛga, ĩye ye babi, ĩye fɔba eyi nɛ yĩ mɔ Kalɛ Wĩ a sũ ni, ");
INSERT INTO bov_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yaana fɔtsa pii ɛba nɛ lɔkɔ kĩĩ kamɛ. Yaana fɔla titi ɔha, bawaɛ̃nyole mɔ bawaɛ̃tsole, bama mɔ babi, mɔ fɔba, mɔ bati liti katomɛna. Ade nɛ lɔkɔ kĩ laya kamɛ a, yaana nkpã kĩ ɛlá kawũna da a. ");
INSERT INTO bov_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lɛmɛ bati pii kĩ bɛnyɛ batɔnyade a finyaa aakpa liti, ade bati batide finyaa aakɛna lɔtɔ banyanɛ.” ");
INSERT INTO bov_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Finyaa Yesu mɔ ye fɔtsa bakɔlɛnɛ a yɛlɛ banaa Yerusalem. Yesu nyaa be lɔtɔ ade fɔkɛna ye fɔtsa bakɔlɛnɛ a saa a, bati a kĩ bitomɔ be nɛ liti a kavila. Yesu buki ɛvɛ ye fɔtsa bakɔlɛnɛ ewua-nviã a ɛnamɛna ɔɔwɛ̃ ade ɛkabi be lɛtsa a kĩ laaya nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ebi be kĩ, “Mitse! Bɔanaa Yerusalem awã kĩ baakɔa Otidziwa Obi a bido nɛ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a awɛ. Baakɔ ye kɔtɔ bɛkpa wuda lɔkɔa bɛkɔa ye bido nɛ bikĩ bɛnyɛ́ Yudafɔ awɛ. ");
INSERT INTO bov_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baadi ye nsekuo, bitua tanɛ biko nɛ ye akũ, baabo ye mɔ mple ade baakɔ ye a, lɛmɛ nɛ luwi lɛlalɛde akũ a, yaayidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ke liti a, Zebedeo babi kĩ bɛnyɛ Yakobo mɔ Yohanes ya nɛ Yesu sɛkɛ̃ ade bibi ye kĩ, “Fɔtsa Ɔtsanɛ, bɔawɛ kĩ kɛna lɛtsa a kĩ bɔavia nɔ a kakpa boe.” ");
INSERT INTO bov_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu via be kĩ, “Litsa fɔanɛ?” ");
INSERT INTO bov_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bibi ye kĩ, “Ntɛ ɔnɛ odzi nɛ nɔ lɛgãkpo akũ nɛ nɔ kukũkpalɛ kamɛ ni, bɔawɛ kĩ budzi nɛ nɔ ɔwɛ̃, boe kamɛ ɔmɔa nɛ nɔ sɔmɔna, ɔmɔa lɛmɛ nɛ nɔ sɛbã.” ");
INSERT INTO bov_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu bi be kĩ, “Minyína lɛtsa kĩ de milamɛna kavia a! Mitɛ mido kĩ míapuli mimɔa lubo kamɔ kɔɔpu a kĩ kɛnɛ kĩ mmɔa? Ĩye míapuli mitɛ mui kawɔla a kĩ maatɛ a?” ");
INSERT INTO bov_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɛkpa mbuayɛ kĩ, “Bɔ́apuli.” Yesu bi be kĩ, “Oo, míapuli mimɔa kɔɔpu a kĩ maamɔa a, mɔ mui kawɔla amaniɛ a kĩ maatɛ a. ");
INSERT INTO bov_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lɛmɛ nlá osi kĩ mapau oti a kĩ ye aadzi nɛ yĩ sɔmɔna ĩye sɛbã. Baguma nyɛ oti a kĩ yaakɔa foe ɛkpa bati a kĩ ɛmanɛ foe eyi a.” ");
INSERT INTO bov_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kĩ fɔtsa bakɔlɛnɛ ewua nkaɛ nu fɔlɛtsa kĩĩ a, bɛna kalɔkpa nɛ Yakobo mɔ Yohanes akũ. ");
INSERT INTO bov_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Foesũ Yesu vɛ be ɛkpɔta ebi be kĩ, “Minyina kĩ bati a kĩ babu kĩ bɛnya tɔnɔkɔɛ̃ nɛ amamufɔ akũ a, deĩ kɔbɛ̃ nɛ be akũ, ade banɔkɔɛ̃ kĩĩ deĩ otumi nɛ be akũ a. ");
INSERT INTO bov_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lɛmɛ kɛtánɛ kĩ fɔana lɔmɔ nɛ mi kamɛ. Ntɛ mi kamɛ odi awɛ kĩ yanya ɔnɔkɔɛ̃ ni, kɛnɛ kĩ ɛnya mi ɔsumunɛ. ");
INSERT INTO bov_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ntɛ mi kamɛ odi wɛ kĩ yanya ɔnɔkɔɛ̃ ni, kɛnɛ kĩ ɛnya be nkaɛ a ɔsumunɛ. ");
INSERT INTO bov_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kitonɛkĩ Otidziwa Obi a malo táya kĩ bisum ye, mbom ɛya kĩ yasum bati ɛkɔa ye nkpã ɛkpa lɔkɔa ɛtɛ bati pii nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ke liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a yawo Yeriko. Kĩ banɛ nɛ ɔmatɔ a kamɛ a, bati kɔdabu baũ tomɔ be. Kĩ banaa nɛ osi a, bɛmɔ́ ɔnɛkunɛ odi kĩ bavɛ Bartimeo, Timeo obi kĩ edzi nɛ osi ɔɔwɛ̃ yawã fɔtsa. ");
INSERT INTO bov_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kĩ enu kĩ Yesu Nazaretni a lɛyaatɛ̃ a, edo fɔwɔla kabɔa awɛ kĩ, “Yesu! Dawid obi! Mɔ yĩ kɔnya!” ");
INSERT INTO bov_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bati pii wũni nɛ ye akũ kĩ esua onukpɛ̃. Lɛmɛ ɛbɔa fɔwɔla kɔɔba ɛba kĩ, “Dawid obi! Mɔ yĩ kɔnya!” ");
INSERT INTO bov_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu fɔ̃ ɛdza ade ɛlɛ kĩ, “Mivɛ ye mikpa yĩ.” Foesũ bɛvɛ ɔnɛkunɛ kĩĩ bibi ye kĩ, “Fɔ̃ ɔwɔlɛ ɛka edzi nɔ! Yidza mɔ atsɛ, yavɛ nɔ.” ");
INSERT INTO bov_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Awã naa ɛta ye atadiɛ wulaa eyi nɛ ɔɔwɛ̃ eyidza ɛdza, ɛnaa Yesu sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu via ye kĩ, “Litsa awɛ kĩ nkɛna nkpa nɔ?” Ɔnɛkunɛ a bi ye kĩ, “Fɔtsa Ɔtsanɛ, fɔ̃ mbuki mmɔ́ fɔkɔ!” ");
INSERT INTO bov_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ade Yesu bi ye kĩ, “Naa. Nɔ katɛkado tsa nɔ.” Deedimɔapɛ ye anɛ binya ɛmɔ́ fɔkɔ, ade etomɔ Yesu nɛ osi a akũ a. ");
INSERT INTO bov_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kĩ bifuã Yerusalem a, bɛkɔa bawo Betfage mɔ Betania tɛmatɔ a, bɛyawo Kugua Futse Ɔtɔ akũ. Nɛ awã Yesu do ye fɔtsa bakɔlɛnɛ nviã kĩ bɛnya lɔtɔ, ");
INSERT INTO bov_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mɔ ɔlɛdo kĩ, “Minaa akula a kĩ ɛwaa nɛ lɔtɔ a kamɛ. Ntɛ miwo ye kamɛ pɛ, míamɔ aflim obi kĩ bido ɔwɛ̃ bɛdzɛla kĩ odima tádzi tɔ̃ nɛ ye akũ. Miwũnya ye nɛ ɔwɛ̃ kamɛ mikɔa miyamɛna. ");
INSERT INTO bov_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ntɛ odi via mi kĩ, ‘Nde sũ miawũnya ye’ ni, mibi ye kĩ mi Ɔlate sĩ ye, ade yaakɔa ye ɛmɛna mɔatsɛ a.” ");
INSERT INTO bov_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Foesũ bati a naa, ade bɛnamɔ kĩ bido aflim obi ɔwɛ̃ ɛdzɛ̃ nɛ ɔblɔnu akũ nɛ kɔla onyukpɛ̃. Ade kĩ bɛkawũnya ye nɛ ɔwɛ̃ kamɛ a, ");
INSERT INTO bov_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bati badi kĩ bɛdza nɛ awã a via be kĩ, “Litsa miakɛna nɛ awã? Litsa sũ miawũnya aflim obi a?” ");
INSERT INTO bov_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɛkpa mbuayɛ ndɛ ayekĩ Yesu bi be a, ade bati a kpa be osi bɛnyɛ ye a. ");
INSERT INTO bov_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kĩ bɛkɔa ɔyaɛ a bɛma Yesu a, bɛdzɛlɛ be tilima biko nɛ ye akũ, ade Yesu de edzi nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bati pii dzɛlɛ be tilima biko nɛ osi akũ, ade badi lɛmɛ veli tɛnanɛ mɔ tɔɔta biko nɛ osi akũ a. ");
INSERT INTO bov_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bati a kĩ bɛnyaa lɔtɔ mɔ bikĩ bitomɛna ye a do fɔwɔla kabɔa kalɛ kĩ, “Hosiana! Mimu Baguma! Baguma hila oti a kĩ yaya nɛ Ɔlate a dĩ akũ! ");
INSERT INTO bov_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Baguma hila Boe Ɔlɛga Dawid lɛgãkanyakɔ̃ a kĩ kaya a! Hosiana deĩ nɛ ode flee flee!” ");
INSERT INTO bov_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kĩ Yesu wo Yerusalem a, ɛnaa Yudafɔ Asɔli Kɔla a kamɛ, ade eko anɛ ɛdã lɛtsa nyɛ lɛtsa ɛtɛ̃mɛna a. Lɛmɛ kĩ kade lamɛna kadɔ sũ ni, bɛmɔ ye fɔtsa bakɔlɛnɛ a ewua-nviã dzakũ bɛnaa Betania. ");
INSERT INTO bov_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kĩ kade nyina bimuniki bito Betania baya a, kɔlɛ kɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɛmɔ́ kutse kudi kĩ kɔawũ babi kĩ bavɛ figi mɔ lugo, kɔtalɛ mɔ tɔɔta beblebee nɛ koe akũ. Foesũ ɛnadã ntɛ yaana babi badi nɛ koe akũ. Lɛmɛ kĩ ewo kutse a kayɔ a, ɛtámɔ babi badimanɔ, mbɔɛntɛ tɔɔta nɛnɛ teĩ, kitonɛkĩ kutse a kawũ lɔkɔ táwo tɔ̃ ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ade Yesu bi kutse a kĩ, “Odimanɔ lɛláabuki ɛnya nɔ babi dadaada!” Ye fɔtsa bakɔlɛnɛ a nu foe. ");
INSERT INTO bov_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kĩ biwo Yerusalem a, Yesu naa Asɔli Kɔla a kamɛ ade edo bati a kĩ bɛkanɔ fɔtsa, mɔ bikĩ bɛkaya fɔtsa a kablɔmɛna kanɛmɛna awɛ a. Edu sika babɛ̃nɛ a tupunu ewula, ade edu bikĩ bidzi banɔ mblɔduma a lɛmɛ fukpo ewula a. ");
INSERT INTO bov_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ade ɛtákpa osi malo kĩ odima abɔɛ lɛtsama ɛtsã kɔla kamɛ ɛtɛ̃mɛna a. ");
INSERT INTO bov_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ke liti a, ɛtsa bati a fɔtsa ɛlɛ kĩ, “Bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ Baguma lɛ kĩ, ‘Baavɛ yĩ Asɔli Kɔla kĩ kamɛ katinya kamɛ bati flee mpaɛ kabɔakɔ̃.’ Lɛmɛ midani koe mikɛna bayekpanɛ kabɛlakɔ̃!” ");
INSERT INTO bov_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a nu fɔlɛtsa a kĩ Yesu lɛ a, foesũ bɛwɛ osi a kĩ baatsã bɛkɔ ye. Lɛmɛ bivila ye kitonɛkĩ ye fɔtsa katsa a nyɛnɛ bati kɔdabu a flee akũ. ");
INSERT INTO bov_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kĩ kiwo olobe lɔkɔ a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a nɛ nɛ ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Luwi lɛyade ɔnɔnɛ tutuutu kĩ bɛtsɛ̃ nɛ osi banaa a, bɛmɔ́ kĩ kutse a kĩ kɔawũ babi a ku kito lɔlɔ kɛnawo tunu akũ. ");
INSERT INTO bov_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro te anɛ nɛ lɛtsa kĩ lɛya a akũ, ade ebi Yesu kĩ, “Fɔtsa Ɔtsanɛ, dã! Kutse a kĩ odumu a ku!” ");
INSERT INTO bov_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu bi be kĩ, “Mitɛ Baguma mido. ");
INSERT INTO bov_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi kĩ yaabi ɔtɔ kĩĩ kĩ ɛbɔlɛ ɛnaatɔ nɛ mpo kamɛ, mɔ ɛtátɛ atsindze nɛ ɔwɔlɛ kamɛ mbom ɛtɛ edo kĩ lɛtsa a kĩ ɛlɛ a aaya nɛ foe kamɛ ni, fɔ́aya lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Foesũ mabi mi kĩ lɛtsa nyɛ lɛtsa kĩ míavia Baguma nɛ mpaɛbɔ kamɛ ni, mitɛ mido kĩ mina foe, ade Baguma aakpa mi foe a. ");
INSERT INTO bov_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ade ntɛ midzɛ̃ miabɔa mpaɛ mɔ mimɔ́ kĩ oti odi fum mi ni, mikɔa mite ye ayekĩ mi Ɔlɛga nɛ ode a lɛmɛ aakɔa mi tɔkpa ete mi. ");
INSERT INTO bov_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lɛmɛ ntɛ mitákɔa bati tɔkpa mite be, mi Ɔlɛga nɛ ode a lɛmɛ lɛláakɔa mi tɔkpa a ete mi!” ");
INSERT INTO bov_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ade Yesu mɔ ye fɔtsa bakɔlɛnɛ a buki bɛnaa Yerusalem a. Kĩ Yesu nɛ ɛtsɛ̃ yamini nɛ Asɔli Kɔla kamɛ a, basɔfɔnɔkɔɛ̃, mbla batsanɛ a mɔ ɔmatɔ banɔkɔɛ̃ badi ya nɛ Yesu sɛkɛ̃, ");
INSERT INTO bov_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ade bivia ye kĩ, “Kɔbɛ̃ ɔdabe ɔnɛɛ akɛna fɔtsa kĩĩ? Owei lɛkpa nɔ osi kĩ kɛna fɔtsa kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kpa be mbuayɛ kĩ, “Maanya lɔtɔ nvia mi kalɛ mɔapɛ. Ntɛ mikpa ke mbuayɛ ni, maabi mi kɔbɛ̃ a odu kĩ nnɛɛ makɛna fɔtsa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mibi yĩ Yohanes bati mui kawɔla a ni, Baguma sɛkɛ̃ futo mbɔɛɛ kĩ batidziwa sɛkɛ̃ futo? Mikpa yĩ mbuayɛ.” ");
INSERT INTO bov_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Biyi fukĩĩ kavɛlɛ nɛ be kamɛ awɛ ade bɛlɛ kĩ, “Litsa bɔ́alɛ? Ntɛ bɔlɛ kĩ kɔbɛ̃ a to Baguma sɛkɛ̃ ni, yaavia boe kĩ, ‘Kekɔ̃ litsa sũ mitátɛ Yohanes mido?’ ");
INSERT INTO bov_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mbɔɛɛ bɔ́alɛ kĩ futo batidziwa sɛkɛ̃?” Lɛmɛ bavila bati kɔdabu a, kitonɛkĩ odi nyɛ odi abu Yohanes kĩ ɛnyɛ Baguma onukpɛ̃ ɔnyɛnɛ. ");
INSERT INTO bov_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Foesũ bɛkpa Yesu mbuayɛ kĩ, “Bunyína.” Ade Yesu bi be kĩ, “Yĩ malo nláabi mi awã kĩ kɔbɛ̃ a to nnɛɛ makɛna fɔtsa kĩĩ!” ");
INSERT INTO bov_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ke liti a, Yesu tsa be fɔtsa nɛ fɔgbã kamɛ ɛlɛ kĩ, “Onyole odi nɛ waĩ futse kɔba, edzi kɔbã esinya koe. Ɛnyɛ lɛkɛ nɛ kɔba a kayite, awã kĩ yaana kutse babi a ɛkpɔta, ɛkakã mui a kako. Ade eke kɔla geĩ kudi, ayekĩ koe akũ ɔdãmɛnanɛ a aadzi ɛkadã kɔba a akũ. Ɛkɔa kɔba a edo nɛ apaafɔ awɛ kĩ bɛkaadã koe akũ, ade ɛdzakũ ɛnaa osi akũ a. ");
INSERT INTO bov_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kĩ lɔkɔ wo ɔtɔ kĩ baana babi a, onyole a do ye ɔsumunɛ nɛ be sɛkɛ̃ kĩ ɛnaatɛ ye kanyakɔ̃ ɛma ye. ");
INSERT INTO bov_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lɛmɛ ye apaafɔ a pi fɔtɔ ɔnyanɛ a bibo ye ade bɛblɔmɔ ye mɔ awɛ pupulidza a. ");
INSERT INTO bov_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Onyole kĩĩ buki edo fɔtɔ ɔnyanɛ bɛbã. Kĩ ɛnaa a, apaafɔ a bo ye, bipila ye nɛ lɔlɔ, bido ye kɔnyɔã lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kɔba ɔlate a buki edo fɔtɔ ɔnyanɛ bɛbã, adeke bɛkɔ ye a. Ade aye bɛkɛna babɛbã pii a. Bibo badi, bɛkɔ babɛbã lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Oti kĩ ete kĩ yaado nyɛ ye mɔawɛ obi kĩ yaátunɔ kalɛ. Nɛ kawũna kamɛ a, edo ye obi a kĩ yawɛ kalɛ paa a, ɛlɛ kĩ, ‘Matɛ kado kĩ baakpa yĩ obi kĩĩ kɔ̃ obu.’ ");
INSERT INTO bov_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Lɛmɛ kɔba akũ badãmɛnanɛ kĩĩ bi be akũ kĩ, ‘Ade adzapadiɛ ɔnyanɛ a nɛ awĩ a. Miya bɔkɔ ye ayekĩ ye adzapadiɛ a aakɛna boe ade!’ ");
INSERT INTO bov_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Foesũ, bipi obi a bɛkɔ ye, bɛta bimuni nɛ waĩ kɔbã a liti.” ");
INSERT INTO bov_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nɛ awã a, Yesu via bati a kĩ, “Litsa waĩ kɔba ɔlate a aakɛna? Yaaya ɛyaakɔ apaafɔ a ɛkɔa waĩ kɔba a edo nɛ bati bɛbã awɛ. ");
INSERT INTO bov_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mbɔɛɛ mitákã nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, ‘De a kĩ fɔla bakenɛ sĩ a, ade de lɛyadani kɔla okonto akũ de a. ");
INSERT INTO bov_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Baguma lɛkɛna fɔtsa kĩĩ, ade fɔnyɛ awãwã fɔtsa nɛ boe anɛ a!’ ” ");
INSERT INTO bov_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yudafɔ banɔkɔɛ̃ a wɛ kĩ bapi Yesu, kitonɛkĩ bɛmɔ́ kĩ ɛbɔa lɛgbã a etia be, lɛmɛ bivila bati kɔdabu a, foesũ bɛfɔnɛ ye ade bɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ke liti a, bido Farisifɔ badi mɔ bikĩ bitomɛna Herodes a kĩ bɛnaa Yesu sɛkɛ̃, bɛnaanaĩ ye nɛ tɛdake kamɛ mɔ fɔlɛtsa kavia bɛkɔa bipi ye. ");
INSERT INTO bov_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kĩ bɛya nɛ ye sɛkɛ̃ a, bibi ye kĩ, “Fɔtsa Ɔtsanɛ, bunyina kĩ alɛ ɔnɔkɔali daa, ade ɔtsɛ́la lɛtsa a kĩ bati akɔna nɛ nɔ akũ a. Aádã oti anɛ, mbom atsa Baguma akũ ɔnɔkɔali osi a. Bi boe ntɛ boe Mbla kpa osi kĩ bute ɔgɔlɛ bɔkpa Roma Lɛgãnɔkɔɛ̃. Bute mbɔɛɛ kĩ bɔtate?” ");
INSERT INTO bov_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lɛmɛ Yesu mɔ́ be tɛdake a, foesũ evia be kĩ, “Nde sũ miawɛ kĩ miasɔ yĩ midã? Mikɔa sika a miyamɛna ndã!” ");
INSERT INTO bov_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɛkɔa sɔmɔa bɛma ye, ade evia be kĩ, “Owei lɔlɔ mɔ dĩ teĩ nɛ se akũ?” Awã naa bɛkpa mbuayɛ kĩ, “Roma Lɛgãnɔkɔɛ̃ Kaisare.” ");
INSERT INTO bov_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ade Yesu bi be kĩ, “Kekɔ̃ mikɔa lɛtsa kĩ lɛnyɛ Kaisare lide a mikpa ye, ade lɛtsa kĩ lɛnyɛ Baguma lide a lɛmɛ ni, mikɔa mikpa Baguma.” Fukĩĩ fɔ̃ akũ nyɛnɛ be nɛ Yesu akũ. ");
INSERT INTO bov_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ade Zadukifɔ kĩ balɛ kĩ bati kayidza kato kanɔkpa lɛláa a kamɛ badi ya nɛ Yesu sɛkɛ̃, bɛyavia ye kĩ, ");
INSERT INTO bov_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Fɔtsa Ɔtsanɛ, Mose tsɛlɛ mbla kĩĩ eyi ɛkpa boe kĩ ntɛ onyole odi ku ɛfɔnɛ ɔtsɔ̃ kĩ bɛmɔ ye bɛtáma ni, ɔwaɛ̃nyole ɛkɔã okunawa a, lɔkɔa bɛma babi bɛkpa ɔtɔnyade a. ");
INSERT INTO bov_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Fɔya kĩ bawaɛ̃ evũkɔnɔ badi dzi nkpã. Ɔnɔkɔɛ̃de a kɔã ɔtsɔ̃ ade eku a, kĩ bɛtáma obi odima. ");
INSERT INTO bov_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ade ɔyade a kɔã otsole a, ade ye malo eku, kĩ bɛtáma obi odima. Ɔwaɛ̃ ɔlalɛde a lɛmɛ kɔã otsole a, ade ye malo ɛyaku kĩ bɛtáma obi odima. ");
INSERT INTO bov_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ade aye a be evũkɔnɔ a kɔã otsole a, lɛmɛ be flee a biku kĩ bɛmɔ otsole a bɛtáma babi. Nɛ foe kawũna a otsole a lɛmɛ yaku. ");
INSERT INTO bov_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nɛ kayidza kadzi nkpã kamɛ mɔ ntɛ biyidza a ni, be kamɛ ɔwɔdabe ɔtsɔ̃ otsole a aanya? Be evũkɔnɔ a flee bɛkɔã ye tɔ̃?” ");
INSERT INTO bov_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kpa be mbuayɛ kĩ, “Mikɛna mfumsu, kitonɛkĩ minyína Katsɛlɛ Kpalɛwa a fɔlɛtsa ĩye Baguma kɔbɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ntɛ banɔkpa yidza bidzi nkpã ni, baana ndɛ ode fɔtɔ banyanɛ ade bɛláakɔã batsɔ̃ a ĩye bidzi fɔnyɔ a. ");
INSERT INTO bov_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lɛmɛ nɛ banɔkpa kayidza akũ ni, mitákã nɛ Mose ovoli a kamɛ fɔlɛtsa a kĩ Baguma lɛ nɛ kutse a kĩ kɔkatɛ̃ a akũ? Baguma bi Mose kĩ, ‘Yĩ nyɛ Abraham Baguma, Isak Baguma mɔ Yakob Baguma.’ ");
INSERT INTO bov_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Fukĩĩ atsa kĩ ɛnyɛ bati kĩ bidzi nkpã Baguma, nnɛ́ banɔkpa Baguma yanɛ. Mikɛna mfumsu paa!” ");
INSERT INTO bov_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ade Yudani mbla ɔtsanɛ odi kĩ ɛna nɛ awã a, nu fɔlɛtsa kamɛ kasa a. Ɛmɔ́ kĩ Yesu kpa Zadukifɔ a mbuayɛ wĩ, foesũ efuã Yesu evia ye kĩ, “Mbla wɔdabe nyaa Baguma tɛbla a flee lɔtɔ?” ");
INSERT INTO bov_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kpa ye mbuayɛ kĩ, “Bɛtsɛlɛ mbla a kĩ ɛbɛ̃ a bɛtsa kĩ, ‘Israelfɔ, mitse! Ɔlate a nyɛ boe Baguma, ade ye odi lɛmɛ deĩ a. ");
INSERT INTO bov_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Foesũ awɛ Ɔlate, nɔ Baguma a, mɔ nɔ ɔwɔlɛ flee, mɔ nɔ ɔkla flee, mɔ nɔ adzuni flee mɔ nɔ kɔbɛ̃ flee.’ ");
INSERT INTO bov_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ade mbla sĩwa ayade nyɛ kĩ, ‘Wɛ nɔ ɔkɔba kalɛ ndɛ ayekĩ awɛ nɔ akũ a.’ Mbla adima buki ɛbɛ́ tɛbla kĩĩ.” ");
INSERT INTO bov_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Adeke mbla ɔtsanɛ a kpa mbuayɛ kĩ, “Fɔtsa Ɔtsanɛ, ɔlɛ foe kalɛ wĩ. Ɔnɔkɔali fɔanɛ ndɛ ayekĩ ɔlɛ kĩ Ɔlate a odi nyɛ Baguma, ade Baguma adima buki ɛláa kɛba ye odi a. ");
INSERT INTO bov_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Foesũ kɛnɛ kĩ oti ɛwɛ Baguma kalɛ mɔ ye ɔwɔlɛ flee, ye adzuni flee mɔ ye kɔbɛ̃ flee. Ade kɛnɛ kĩ ɛwɛ ye ɔkɔba kalɛ ndɛ ayekĩ yawɛ ye akũ kalɛ a. Fɔnɛnɛ kĩ oti ɛkɛna nɛ tɛbla nviã kĩĩ akũ kɛba kĩ yaabɔa bayaɛ mɔ afɔliɛ bɛbã ɛkpa Baguma.” ");
INSERT INTO bov_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kĩ Yesu mɔ kĩ onyole a kpa ye mbuayɛ nɛ nyansã kamɛ a ni, ebi ye kĩ, “Mimɔ Baguma lɛgãkanyakɔ̃ a kayite lɛlá lugo.” Nɛ fukĩĩ liti a, odimanɔ tápuli edo ɔwɔlɛ evia Yesu kalɛ kadima. ");
INSERT INTO bov_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kĩ Yesu katsa fɔtsa nɛ Asɔli Kɔla a kamɛ a, evia be kalɛ kĩ, “Nde fɔla sũ mbla batsanɛ a aapuli bɛlɛ kĩ Kristo a aanya Lɛgã Dawid kasinu obi? ");
INSERT INTO bov_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hũhũ Kpalɛwa a lɛfɔ̃ Dawid lɛ eyi kĩ, ‘Baguma bi yĩ Ɔlate kĩ, “Kɛna akũ kadzi nɛ yĩ sɔmɔna nɛ awĩ, kɛnawo kĩ maakɔa nɔ bakesĩnɛ ndo nɛ nɔ abɔa kayɔ.” ’ ");
INSERT INTO bov_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kĩ Lɛgã Dawid mɔawɛ vɛ ye kĩ Ɔlate a ni, nde fɔ́apuli fɔya kĩ Kristo a aanya Dawid kasinu obi?” Bati kɔdabu baũ dza nɛ awã bɛkatse Yesu fɔlɛtsa a mɔ kawɔlɛ. ");
INSERT INTO bov_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kĩ Yesu katsa bati a fɔtsa a ebi be kĩ, “Midã kadã wĩ nɛ Yudafɔ mbla batsanɛ a akũ. Bado tɛtadiɛ wulaa katsã kawɛ kĩ bati bɛwɔ̃na be nɛ obu kamɛ nɛ kɔyaatɔ. ");
INSERT INTO bov_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bawɛ banɔkɔɛ̃ fudzikɔ̃ kadzi nɛ be fɔtsɛnakɔ̃ mɔ obu fudzikɔ̃ kadzi nɛ kanyakɔ̃. ");
INSERT INTO bov_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Basisi bakunawa katɛ be tɔtɔ nɛ be awɛ. Babɔa mpaɛ gɛlɛɛlɛ kakɔa kapia be akũ. Be sɔtɔ kavɛlɛ aana ɔsĩ sɛba bati bɛbã fude.” ");
INSERT INTO bov_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ade Yesu nadzi nɛ Asɔli Kɔla a kamɛ efuã ɔgɔlɛ kate adakã a, ɛkadã ayekĩ bati lamɔ sika kata kado a. Asikafɔ pii ta sika baũ baũ bido nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Adeke okunawa ohiãni odi lɛmɛ ya ade ɛkɔa kaplɛ nviã edo nɛ adakã a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɛ awã a Yesu vɛ ye fɔtsa bakɔlɛnɛ a ɛkpɔta ebi be kĩ, “Ɔnɔkɔali mabi mi kĩ okunawa ohiãni kĩĩ lɛtsa a kĩ edo nɛ ɔgɔlɛ adakã kamɛ a pɔnɛ fɔbɛ̃ bati a flee fude. ");
INSERT INTO bov_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kitonɛkĩ bati bɛbã a kɔa akũ kana fɔtsa a kĩ fute a fudi bɛyate ɔgɔlɛ, lɛmɛ otsole ohiãni kosokoso kĩĩ kɔ̃, lɛtsa kĩ edeĩ a flee ɛkɔa ete. Ɛkɔa lɛtsa a kĩ de akũ yaadzi nkpã a ɛyate ɔgɔlɛ.” ");
INSERT INTO bov_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kĩ Yesu nɛ eto Asɔli Kɔla kamɛ yanaa a, ye fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa bi ye kĩ, “Fɔtsa Ɔtsanɛ, dã fɔla mɔ kalɛ mɔ boe kpale kĩĩ!” ");
INSERT INTO bov_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu bi ye kĩ, “Amɔ fɔla kpale kpale kĩĩ. Bɛlátina de a kamɛ lidima nɛ lɔkɔba akũ kĩ bɛláadu biwula! Baatinya de lidi nyɛ lidi biwula.” ");
INSERT INTO bov_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kĩ Yesu nɛ edzi nɛ Kugua Futse Ɔtɔ a akũ, ɛtsɛlamɔ Asɔli Kɔla a, Petro, mɔ Yakobo, mɔ Yohanes mɔ Andrea ya nɛ ye sɛkɛ̃ bɛyavia ye pɛtɛɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Boe Ɔlate, lɔkɔ wɔdabe fukĩĩ aaya nɛ foe kamɛ? Bi boe fɔtsa a kĩ fɔ́aya fɔkɔa fɔtsa kĩ lɔkɔ a wo ɔtɔ kĩ fɔtsa kĩĩ flee fɔya nɛ foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ade Yesu bi be kĩ, “Midã kadã wĩ, ade mitafɔ̃ odima lɛkɛ mi a. ");
INSERT INTO bov_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bati pii aaya nɛ yĩ dĩ akũ bibi mi kĩ, ‘Yĩ nyɛ Kristo a!’ ade baakɛ bati pii a. ");
INSERT INTO bov_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ɔwɔlɛ ɛtabɔlɛ mi ntɛ minu kawũkanɔ nkã nɛ mi ɔwɛ̃ ĩye kawũkanɔ akũ fɔlɛtsa mɔ lugo. Kɛnɛ kĩ fɔtsa kĩĩ bamɛ odu fɔya nɛ foe kamɛ, lɛmɛ fɔátsa kĩ katinya kamɛ kawũna a wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɔmaĩ mɔ ɔmaĩ aanɔ akũ. Lɛgãkanyakɔ̃ aayidza nɛ lɛgãkanyakɔ̃ akũ. Tite aakuna nɛ fɔkɔ kumɛkumɛ, ade kɔlɛ aaya a. Lɛmɛ fukĩĩ flee la ndɛ sɛmɛ kapi kayɔkayi lubo kamɔ a aye. ");
INSERT INTO bov_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kɛnɛ kĩ mi mɔawɛ a miana nɛ kɔnɛte kamɛ. Baapili mi lɔkɔa bɛkɔa mi bɛnamɛna fɔlɛtsa kadzɛkɔ̃. Baabo mi nɛ fɔtsɛnakɔ̃. Baafɔ̃ midza nɛ fɔgã mɔ ɔmaĩ banɔkɔɛ̃ anɛ nɛ yĩ sũ, lɔkɔa mibi be Kalɛ Wĩ a. ");
INSERT INTO bov_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lɛmɛ fɔmɔ katinya kawũna a aaya ni, kɛnɛ kĩ bɛnya lɔtɔ bide lɛtsã nɛ Kalɛ wĩ a akũ bɛkpa fude fude a flee. ");
INSERT INTO bov_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ntɛ bipi mi bɛkɔa mi bɛnamɛna fɔlɛtsa kadzɛkɔ̃ ni, mitanya lɔtɔ mibo akũ nɛ lɛtsa a kĩ míalɛ a akũ. Ntɛ lɔkɔ a wo ɔtɔ ni, milɛ lɛtsa nyɛ lɛtsa kĩ baakpa mi kĩ milɛ a. Kitonɛkĩ fɔlɛtsa a kĩ míalɛ a lɛláanya mi fude, mbom fɔ́ato Hũhũ Kpalɛwa a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Bati aakɔa be mɔawɛ bawaɛ̃ bɛkpa kĩ bɛkɔ, ade balɛga lɛmɛ aakɛna foe mɔapɛ a nɛ babi akũ. Babi aayidza bɛdza nɛ be bamanɛ akũ, bɛfɔ̃ bɛkɔ be. ");
INSERT INTO bov_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Odi nyɛ odi aakesĩ mi nɛ yĩ sũ. Lɛmɛ odi nyɛ odi kĩ yaadza pintii kɛnaawo ye nkpã kawũna ni, Baguma aakpa ye nkpã.” ");
INSERT INTO bov_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu buki ɛlɛ kĩ, “Ntɛ mimɔ́ fukesĩtsa mɔ libe kĩ fɔakɔ ɔmaĩ kĩ fɔdzɛ̃ nɛ awã kĩ kɛtánɛ kĩ fɔna a ni, ovoli ɔkãnɛ a enu foe kayɔ kanu wĩ, lɔkɔa bati a kĩ bideĩ nɛ Yudea a bilo bɛnaa tɔtɔ akũ. ");
INSERT INTO bov_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Oti kĩ edzi nɛ ye kɔla lɛtsã a, ɛtaduma ɛya nɛ tite kĩ yaabɔɛ litsedi etomɛna ye kɔla kamɛ ɛkpa ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Oti kĩ edeĩ nɛ ye kɔba kamɛ ɛtamuniki ɛnaa kɔla kĩ yanaabɔɛ ye lima. ");
INSERT INTO bov_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bɔbɔɛ makpa batsole a kĩ bɛtsɛmɔ fɔma mɔ bikĩ bɛnɛɛ babi kĩ bamɛmɛ nɛ lɔkɔ a na kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mibɔa mpaɛ mikpa Baguma kĩ fɔtsa kĩĩ fɔtaya nɛ osili lɔkɔ! ");
INSERT INTO bov_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kitonɛkĩ lubo kamɔ a kĩ laaya nɛ lɔkɔ a na kamɛ aana ɔsĩ lɛba lidi nyɛ lidi kĩ lɛya tɔ nɛ katinya kamɛ, kito nɛ kayɔkayi kĩ Baguma bɔa katinya a kɛyawo finyaa. Adeke lubo kamɔ kĩĩ odu lɛláabuki lɛya dadaada a. ");
INSERT INTO bov_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lɛmɛ Ɔlate a tinya lubo kamɔ fuwi a akũ. Ntɛ nɛ aye ni, kufɛ odima lɛláana nkpã. Lɛmɛ nɛ ye bati a kĩ ɛpau a sũ ni, etinya fuwi a akũ. ");
INSERT INTO bov_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Foesũ ntɛ odi bi mi kĩ, ‘Dã! Kristo a deĩ nɛ awĩ,’ ĩye ‘Edeĩ nɛ akĩĩ,’ mitatɛ ye mido! ");
INSERT INTO bov_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kitonɛkĩ fɔvã Kristo amɛ, mɔ fɔvã Baguma onukpɛ̃ banyɛnɛ aanɛ. Baakɛna awãwã fɔtsa mɔ nsɛntsɛlɛni pii kĩ ntɛ baapuli ni, baakɔa bɛkɛ bati a kĩ Baguma pau a malo. ");
INSERT INTO bov_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mi kɔ̃ midã kadã wĩ! Mbi mi lɛtsa nyɛ lɛtsa ĩnyamɛna lɔtɔ fɔmɔ lɔkɔ a aawo ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu lɛ ɛnamɛna lɔtɔ kĩ, “Nɛ fuwi a kĩ fɔ́aya nɛ lubo kamɔ fuwi liti a, ‘suwa aadĩ sɛkɛna tũũ, odetɔ lɛmɛ lɛláabuki ɛvɔlɛ. ");
INSERT INTO bov_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Fusibii aato ode fɔtɔ, ade odetɔ́ kamɛ kɔbɛ̃ a kĩ kupini ode a aakuna akũ.’ ");
INSERT INTO bov_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ke liti a, baamɔ Otidziwa Obi a, kĩ ɛnɛ yaya nɛ liflututu kamɛ mɔ kɔbɛ̃ mɔ kukũkpalɛ baũ. ");
INSERT INTO bov_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Adeke yaado ode fɔtɔ banyanɛ a kĩ bɛnaakpɔta bati a kĩ ɛpau eyi a, bitomɛna katinya kamɛ tukonto ɛna a kamɛ kito tite kakpulakɔ̃ kɛnaawo ode kakpulakɔ̃. ");
INSERT INTO bov_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mikɔlɛ fɔtsa nɛ kutse kĩ kɔawũ babi a akũ. Ntɛ fɔya kĩ mimɔ́ kĩ kutse a na nɛ́ tɛnanɛ kɔnyɛ tɔɔta vɔɛ̃ ni, minyi kĩ ovio lɔkɔ fuã. ");
INSERT INTO bov_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ade aye ntɛ mimɔ́ kĩ fɔtsa a kĩĩ do kaya awɛ pɛ, minyi kĩ lɔkɔ a fuã, ade liti liwo onyukpɛ̃ malo a. ");
INSERT INTO bov_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ɔnɔkɔali a mabi mi kĩ mi lɛtsã babi a flee lɛláaku fɔmɔ fɔtsa kĩĩ flee aaya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tite mɔ ode flee aayatɛ̃, lɛmɛ yĩ kalɛ a kɔ̃ lɛláatɛ̃ da. ");
INSERT INTO bov_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lɛmɛ luwi a ĩye ɔdɔũ a, odima linyína de. Ode fɔtɔ banyanɛ a mɔ Baguma Obi mɔawɛ a malo linyína, mbɔɛntɛ Ɔlɛga a odi keĩ nyina. ");
INSERT INTO bov_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Midã kadã wĩ mina nɛ kukũmanɛ kamɛ, kitonɛkĩ minyína luwi a kĩ de akũ lɔkɔ a aawo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Fɔ́ana ndɛ ayekĩ onyole odi naa osi akũ, ade ɛfɔnɛ ye tɔtɔ eyi ye basumunɛ a. Ɛkpa odi nyɛ odi ye kɔbɛ̃ mɔ adzuma kĩ ɛkɛna. Ke liti a, esi onyukpɛ̃ ɔdãmɛnanɛ a mbla kĩ ɛna nɛ kukũmanɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nɛ foesũ mina nɛ kukũmanɛ kamɛ, kitonɛkĩ minyína lɔkɔ a kĩ tɔtɔ ɔlate a aaya. Fɔ́apuli fɔnya olobe lɔkɔ ĩye lɛnyɛ kayite ĩye odenyinawi ĩye ɔnɔnɛ. ");
INSERT INTO bov_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ntɛ ɛyafuta mi ni, ɛtayaamɔ mi kĩ miwaa tida. ");
INSERT INTO bov_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lɛtsa a kĩ mabi mi a, ade foe mɔapɛ a mabi bati flee kĩ mina nɛ kukũmanɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kite fuwi nviã kĩ Yudafɔ aanya Wuda Katɛ̃ Luwi, kĩ bate anɛ nɛ be kadzakũ nɛ Egipte akũ a, mɔ Abodoo Kĩ Ɛtáyila Luwi. Basɔfɔnɔkɔɛ̃ a mɔ mbla batsanɛ kawɛ osi a kĩ baatsã nɛ kabɛla kamɛ bipi Yesu bɛkɔ ye. ");
INSERT INTO bov_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bɛlɛ kĩ, “Kɛtánɛ kĩ bɔkɛna foe nɛ fuwi kanya a kamɛ, kitonɛkĩ bati aado ɔtutũ nɛ ɔmaĩ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu na nɛ Betania ɔmatɔ kamɛ nɛ Simon kĩ ɛsɔ tɔ̃ fɔsɔ ngbã a awã. Kĩ Yesu dzi ɛkanya a, otsole odi kĩ ɛnɛɛ tumpã kĩ eyi mɔ kugua mɔ ɔlɛ̃ kĩ kɔtɛ kɔya paa a wo nɛ kɔla a kamɛ. Otsole a binya tumpã a ade etsokui kugua a flee eko nɛ Yesu lɔlɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ade bati a kĩ bɛdzɛ̃ nɛ awã a badi na kalɔkpa bɛlɛ kĩ, “Litsa sũ yabula kugua mɔ kɔya kĩĩ kade? ");
INSERT INTO bov_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Baapuli bɛnɔ kugua mɔ ɔlɛ̃ kĩĩ fɔba sika ovoe fɔbɔ ɔha ɛlalɛ, lɔkɔa bɛkɔa se bɛkpa ahiãfɔ.” Nɛ foe sũ, bɛkã ye anɛ mɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lɛmɛ Yesu lɛ kĩ, “Mifɔnɛ ye awɛ. Litsa sũ miaha ye? Ɛkɛna lɛtsa wĩ ɛkpa yĩ. ");
INSERT INTO bov_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ahiãfɔ aana nɛ mi kamɛ daa, ade míapuli mibumɛna be lɔkɔ kĩ miawɛ a. Yĩ kɔ̃ nláana nɛ mi sɛkɛ̃ daa. ");
INSERT INTO bov_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Otsole a kɛna lɛtsa kĩ yaapuli. Ɛnya lɔtɔ ɛtsɛla yĩ sukɛna kugua kĩ yamanɛ yĩ eyi ɛkpa yĩ kabila. ");
INSERT INTO bov_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ kakɔ nyɛ kakɔ kĩ baade Kalɛ Wĩ a lɛtsã nɛ katinya kamɛ flee ni, baalɛ kɔdzɛla nɛ lɛtsa kĩ otsole kĩĩ kɛna a akũ bɛkɔa bite ye anɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ke liti a, Yuda Iskariot kĩ ɛnyɛ fɔtɔ banyanɛ ewua-nviã a kamɛ ɔmɔa naa Yudafɔ basɔfɔnɔkɔɛ̃ a sɛkɛ̃ kĩ yaanyɛ Yesu ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kawɔlɛ de be nɛ fɔlɛtsa a akũ, ade be malo bike otse kĩ baakpa ye sika a. Foesũ Yuda kawɛ osi a kĩ yaatsã ɛnyɛ ye ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nɛ Abodoo Kĩ Ɛtáyila Kanya Luwi lɛtɔnyade a kĩ bakɔ Wuda Katɛ̃ Kavelibi a akũ a, Yesu fɔtsa bakɔlɛnɛ a via ye kĩ, “Ndia awɛ kĩ bɔlɔla bɔkpa nɔ luwi a funitsã kanya?” ");
INSERT INTO bov_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ade Yesu do be kamɛ bati nviã, mɔ ɔlɛdo kĩ, “Minaa ɔmatɔ a kamɛ, oti odi kĩ ɛnɔnɛ kugumi aatsɛlamɔ mi. Mitomɔ ye miwo nɛ tɔtɔ a kĩ te kamɛ yaawo a, ");
INSERT INTO bov_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","lɔkɔa mibi tɔtɔ ɔlate a kĩ, ‘Fɔtsa Ɔtsanɛ a bo, “Ndia banɔvɔɛ̃ kɔla a kĩ bɔmɔ yĩ fɔtsa bakɔlɛnɛ a aanya Wuda Katɛ̃ funitsã a deĩ?” ’ ");
INSERT INTO bov_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ade yaatsa mi abansulu kɔla baũ awã kĩ bɛhɛhɛ biyi kɔkɔɛ. Milɔla awã mikpa boe funitsã a kanya.” ");
INSERT INTO bov_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Fɔtsa bakɔlɛnɛ a dzakũ bɛnaa ɔmatɔ a kamɛ, ade bɛnamɔ fɔtsa flee ndɛ ayekĩ Yesu bi be a. Ade bɛtɔ Wuda Katɛ̃ funitsã a nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kĩ olobe wo ɔtɔ a, Yesu mɔ ye fɔtsa bakɔlɛnɛ ewua-nviã ya nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ade kĩ bidzi banya a Yesu lɛ kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ mi kamɛ ɔmɔa, kĩ bɔmɔ ye budzi bɔanya aanyɛ yĩ ɛkpa.” ");
INSERT INTO bov_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Fɔlɛtsa kĩĩ ha be, ade bɛkavia ye ɔmɔa ɔmɔa kĩ, “Yĩ manɛ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kpa mbuayɛ kĩ, “Ɛnyɛ mi ewua-nviã a kamɛ ɔmɔa, oti a kĩ ye awɛ deĩ nɛ sɔɔdaɛ kamɛ mɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Otidziwa Obi a anaaku ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ nɛ ye akũ a. Lɛmɛ bɔbɔɛ makpa oti a kĩ yaanyɛ Otidziwa Obi a ɛkpa a. Ntɛ bɛtama oti a na ni, kufɛ fɔnɛnɛ fɔkpa ye.” ");
INSERT INTO bov_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ade kĩ bɛkanya a, Yesu bɔɛ abodoo, ɛnyɛ Baguma kɔlɛ nɛ ye akũ, ade ebuli ye ɛkpa ye fɔtsa bakɔlɛnɛ a, ɛlɛ kĩ, “Mitɛ minya, ade yĩ sukɛna a.” ");
INSERT INTO bov_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ke liti a, ɛbɔɛ kɔɔpu mɔ waĩ, ɛnyɛ Baguma kɔlɛ, ɛkɔa ɛkpa be flee bɛkate kamɔa. ");
INSERT INTO bov_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ade Yesu bi be kĩ, “Ade fukĩĩ nyɛ yĩ apam babɔanɛ a kĩ biwula nɛ bati pii lɔlɔ a. ");
INSERT INTO bov_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ɔnɔkɔali a mabi mi kĩ nláabuki mmɔa waĩ adima kɛnaawo luwi a kĩ maamɔa waĩ vɔɛ̃ nɛ Baguma lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ke liti a, bɛsã tɔnɔ bimu Baguma, ade bɛnɛ bɛnaa Kugua Futse Ɔtɔ a akũ a. ");
INSERT INTO bov_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu bi be kĩ, “Mi a flee míalo mifɔnɛ yĩ, kitonɛkĩ bɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, ‘Maakɔ baveli akũ ɔdãmɛnanɛ a, ade ye baveli a flee aapansam a.’ ");
INSERT INTO bov_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lɛmɛ ntɛ bɛdzɛla yĩ ndzi nkpã ni, maanya mi lɔtɔ nɛ Galilea.” ");
INSERT INTO bov_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ade Petro bi ye kĩ, “Yĩ kɔ̃, nláalo nfɔnɛ nɔ da, ntɛ be nkaɛ a flee lo malo!” ");
INSERT INTO bov_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu bi Petro kĩ, “Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ fɔmɔ ɔkɔkɔ aabe titi nviã lɛnyɛ kĩĩ ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” ");
INSERT INTO bov_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lɛmɛ Petro buki ebi ye mɔ ɔsĩ kĩ, “Ntɛ kɛnɛ kĩ bɔmɔ nɔ buku malo ni, nláalɛ kĩ ĩnyína nɔ!” Fɔtsa bakɔlɛnɛ a flee lɛ kalɛ mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bɛyawo kakɔ kadi kĩ bavɛ Getsemane, ade Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Midzi nɛ awĩ lɔkɔa nnaabɔa mpaɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ade ɛkpã Petro, Yakobo mɔ Yohanes ebumɔ ye akũ a. Kalɔɛ mɔ libe wo nɛ ye kamɛ, ɛkatila bliblibli, ");
INSERT INTO bov_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ade ɛdani ebi be kĩ, “Ayɔlɔhɔ tɛ yĩ ɔwɔlɛ kamɛ paa ndɛ maku. Midzi nɛ awĩ, mikaadã fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kĩ ɛnaa lɔtɔ sukuloo a, ɛka ɛtsa nɛ tite ɛbɔa mpaɛ kĩ, “Ntɛ fɔ́adã bɔɛɛ ni, lubo kamɔ lɔkɔ kĩĩ lɛtɛ̃ nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ade ɛlɛ kĩ, “Nda, yĩ Ɔlɛga, apuli kakɛna lɛtsa nyɛ lɛtsa. Nyɛ lubo kamɔ kɔɔpu kĩĩ nɛ yĩ akũ. Lɛmɛ nnɛ́ lɛtsa a kĩ mawɛ, mbom lɛtsa a kĩ nɔ awɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ke liti a, emuniki ɛyamɔ ye fɔtsa bakɔlɛnɛ ɛlalɛ a kĩ bɛwa tida. Ebi Simon Petro kĩ, “Simon, tida ɔwaa? Ɔtápuli odzi ɔdã fɔkɔ dɔũhuilɛ mɔapɛ malo?” ");
INSERT INTO bov_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ade ebi be kĩ, “Mina nɛ kukũmanɛ kamɛ lɔkɔa mikaabɔa mpaɛ ayekĩ miláawo nɛ sɔhuiɛ kamɛ. Hũhũ a awɛ lɛmɛ sukɛna a kɔ̃ lɛlá kɔbɛ̃.” ");
INSERT INTO bov_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu buki emuniki ɛnabɔa mpaɛ ɛlɛ fɔlɛtsa mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ebuki emuniki ɛnaa ye fɔtsa bakɔlɛnɛ a sɛkɛ̃ ɛnamɔ kĩ bɛwa tida. Bɛtápuli bibinya anɛ, tida deĩ nɛ be anɛ ade bɛtányi lɛtsa kĩ balɛ bɛnyɛ be akũ onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kĩ ebuki emuniki ɛya lɛlalɛde a, evia be kĩ, “Tida mibuki miwaa miawɛya? Fɔlɛ! Ɔdɔũ a wo ɔtɔ! Midã, bɛkɔa Otidziwa Obi a, bado nɛ tɔkpa bakɛnanɛ awɛ. ");
INSERT INTO bov_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Miyidza mifɔ̃ bɔnaa. Midã oti a kĩ yaanyɛ yĩ ɛkpa a fuã.” ");
INSERT INTO bov_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu buki ɛlamɔ kɔdzɛla fɔmɔ Yuda kĩ ɛnyɛ be ewua-nviã a kamɛ ɔmɔa yanɛ ɛta. Bati kɔdabu a kĩ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ mɔ ɔmatɔ banɔkɔɛ̃ nyɛ bibu a tomɔ ye, ade bɛnɛɛ fɔpamɛ glɛlɛ glɛlɛ mɔ titse fukũ a. ");
INSERT INTO bov_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Oti a kĩ ɛnyɛ ye ɛkpa a kpa be nsɛntsɛlɛni eyi kĩ, “Oti a kĩ míamɔ kĩ ndzɛmɛ ye onukpɛ̃ a ni, ade ye nɛ awã a. Mipi ye mikpã minamɛna, lɔkɔa mi anɛ ɛna nɛ ye akũ.” ");
INSERT INTO bov_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kĩ Yuda sila ewo awã a, ɛnaa Yesu sɛkɛ̃ ɛvɛ ye kĩ, “Fɔtsa Ɔtsanɛ!” ade ɛdzɛmɛ ye onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Foesũ bipi Yesu, ade bipini ye kɔɔba a. ");
INSERT INTO bov_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lɛmɛ bati a kĩ bɛdzɛ̃ nɛ awã kamɛ ɔmɔa vɛlɛ ye kɔpã ɛnyɛ ɛbaa Ɔsɔfɔnɔkɔɛ̃ Flee a ɔsumunɛ sɔtɔ emuni. ");
INSERT INTO bov_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ade Yesu bi be kĩ, “Fusĩ kĩ mialɛ apã mɔ titse fukũ miya kĩ miaayapi yĩ ndɛ tɔkpa ɔkɛnanɛ manɛ? ");
INSERT INTO bov_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Luwi daa mana nɛ mi sɛkɛ̃ nɛ Asɔli Kɔla a kamɛ, katsa fɔtsa, lɛmɛ mitápi yĩ. Lɛmɛ kɛnɛ kĩ Katsɛlɛ Kpalɛwa fɔlɛtsa a fɔya nɛ foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ade ke ye fɔtsa bakɔlɛnɛ a flee lo bɛfɔnɛ ye a. ");
INSERT INTO bov_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nɛ lɔkɔ a kamɛ a, opopobi odi kĩ esua aklala lima odi akũ tomɛna Yesu. Bati a wɛ kĩ bapi ye, ");
INSERT INTO bov_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lɛmɛ ɛwɔlɔ ye lima edo be nɛ awɛ, ade elo mɔ ɔdzɔ a. ");
INSERT INTO bov_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ade bɛkpã Yesu bɛnamɛna Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee a tɔtɔ kamɛ, awã kĩ basɔfɔnɔkɔɛ̃, ɔmatɔ banɔkɔɛ̃ mɔ Yudafɔ mbla batsanɛ a kpɔta a. ");
INSERT INTO bov_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro tomɛna nɛ liti flee, ɛyawo nɛ Ɔsɔfɔnɔkɔɛ̃ Flee a lɔwabe. Ɛkɛna akũ edzi nɛ basumunɛ a ɔwɛ̃ bɛkawa fi. ");
INSERT INTO bov_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yudafɔ basɔfɔnɔkɔɛ̃ mɔ fɔlɛtsa badzɛnɛ a kĩ bidzi nɛ awã wɛ fɔlɛtsa kĩ batsua bite nɛ Yesu akũ bɛkɔa bɛkɔ ye wuda kɔtɔ, lɛmɛ bɛtána fudima nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Adansifɔ pii yama fɔvã bite nɛ ye akũ, lɛmɛ be adansiɛ kadi táketi mɔ akũ. ");
INSERT INTO bov_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ade bati badi yidza bɛdza bɛma fɔvã kĩ, ");
INSERT INTO bov_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bunu kĩ ɛlɛ kĩ, ‘Maabubuli Asɔli Kɔla kĩĩ kĩ bike mɔ awɛ a, ade nɛ fuwi ɛlalɛ liti ni, maake kɔbɛbã kĩ nnɛ́ awɛ bɛkɔa bike.’ ” ");
INSERT INTO bov_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lɛmɛ bati kĩĩ adansiɛ malo táketi mɔ akũ. ");
INSERT INTO bov_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɔsɔfɔnɔkɔɛ̃ Flee a yidza ɛdza nɛ bati a flee anɛ, ade evia Yesu kĩ, “Ɔláanyɛ onukpɛ̃ nɛ fɔlɛtsa a kĩ bɛlamɔ kalɛ katia nɔ a?” ");
INSERT INTO bov_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lɛmɛ Yesu sua onukpɛ̃ ɛtálɛ kadima. Ɔsɔfɔnɔkɔɛ̃ a buki evia ye kĩ, “Nɔ nyɛ Kristo, Nhila Ɔlate a Obi a?” ");
INSERT INTO bov_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu bi ye kĩ, “Ye manɛ, ade míamɔ Otidziwa Obi a kĩ edzi nɛ Baguma Kpale a sɔmɔna, ade yaato ode ɛya nɛ luflututu kamɛ a!” ");
INSERT INTO bov_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nɛ awã a, Ɔsɔfɔnɔkɔɛ̃ Flee a bɛ̃ ye atadiɛ kamɛ nɛ kalɔkpa kamɛ ɛlɛ kĩ, “Bɔtábuki busĩ ɔdansini odima! ");
INSERT INTO bov_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Minu ye mbusuo fɔlɛtsa a. Litsa nyɛ mi adzuni?” Adeke be flee bitunɔ yɔ kĩ eku kɔtɔ ade ɛfɛta ɛkpa wuda a. ");
INSERT INTO bov_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Be kamɛ badi yi kayɔ mɔ tanɛ katua kako nɛ Yesu akũ, badi sua ye anɛ, bɛkake ye fukpeni kavia ye kĩ, “Bi boe owula kĩ ɛbɔa nɔ!” Ade badãmɛnanɛ a kpã Yesu bɛbalɛbalɛ ye awɛ nɛ tɔlɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kĩ Petro buki edzi nɛ lɔwabe a, abawa adi nɛ Ɔsɔfɔnɔkɔɛ̃ Flee a tɔtɔ kamɛ a ya nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kĩ ɛmɔ Petro kĩ edzi yawa fi a, ɛbɛ̃ anɛ ɛdã ye ade ebi ye kĩ, “Nɔ malo otomɛna Yesu Nazaretni a!” ");
INSERT INTO bov_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ade Petro sĩ ɛlɛ kĩ, “Ĩnyína lɛtsama, ade maánu lɛtsa a kĩ alɛ a malo a!” Ade ɛnɛ ɛnaa onyukpɛ̃ a. Mɔ ye awã kawo pɛ mɔ ɔkɔkɔ nyɛ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Abawa a buki ɛmɔ́ ye nɛ awã, ade edo bati a kĩ bɛdzɛ̃ nɛ awã kabi awɛ kĩ, “Ɛnyɛ be kamɛ ɔmɔa!” ");
INSERT INTO bov_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lɛmɛ Petro buki esĩ. Owi tábuna mɔ bikĩ bɛdzɛ̃ nɛ awã bi ye kĩ, “Ɔláapuli osi kĩ ɔnyɛ́ be kamɛ ɔmɔa, kitonɛkĩ nɔ malo Galileani anɛ.” ");
INSERT INTO bov_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ade Petro do kadum mɔ katani awɛ kĩ, “Ntani kĩ ɔnɔkɔali malɛ, Baguma ɛvɛlɛ yĩ sɔtɔ ntɛ fɔvã mama. Ĩnyína oti a kĩ ye fɔlɛtsa milamɛna kalɛ a.” ");
INSERT INTO bov_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Deedimɔapɛ ɔkɔkɔ be lɛyade, ade Petro te anɛ nɛ kalɛ a kĩ Yesu bi ye a akũ kĩ, “Fɔmɔ ɔkɔkɔ aabe titi nviã ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” Kĩ ɛmɔ ye akũ eyi ɔsũ a, ebe blobloblo. ");
INSERT INTO bov_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɔnɔnɛ tutuutu a basɔfɔnɔkɔɛ̃ a, ɔmaĩ banɔkɔɛ̃ a, mbla batsanɛ a mɔ fɔlɛtsa badzɛnɛ a tsɛna mɔatsɛ bɛnaa adzina nɛ Yesu akũ. Bisui Yesu nɛ tɔwɛ̃ kamɛ, bɛkpã ye bɛnado nɛ Pilato awɛ. ");
INSERT INTO bov_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Awã naa, Pilato via Yesu kĩ, “Nɔ nyɛ Yudafɔ Lɛgã a?” Yesu bi ye kĩ, “Oo, fɔla ndɛ ayekĩ ɔlɛ a.” ");
INSERT INTO bov_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Basɔfɔnɔkɔɛ̃ a lɛ fɔlɛtsa pii bitsua Yesu onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Foesũ Pilato buki evia ye kĩ, “Ɔláakpa kalɛ a mbuayɛ? Tse fɔlɛtsa a kĩ bɛlamɛna katsua kate nɛ nɔ akũ a.” ");
INSERT INTO bov_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lɛmɛ Yesu tábuki ebinya onukpɛ̃ ade Pilato kɛna saa a. ");
INSERT INTO bov_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kateli nyɛ kateli, nɛ Wuda Katɛ̃ luwi kanya kamɛ a, Pilato afɔnɛ oti mɔa nɛ abãã kɔla bawanɛ a kamɛ, kĩ Yudafɔ via a awɛ kakpa be. ");
INSERT INTO bov_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nɛ lɔkɔ a na kamɛ a, onyole odi kĩ bavɛ Baraba waa kɔla mɔ bati bɛbã badi. Bati a yidza bɛdza nɛ Roma Abãã akũ ade bɛkɔ bati nɛ foe kamɛ a. ");
INSERT INTO bov_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kĩ bati kɔdabu a kpɔta a, bivia Pilato kĩ ɛkɛna sɛmɛ kalɛ kĩ yawɛ kakɛna kateli nyɛ kateli a ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Evia be kĩ, “Miáwɛ kĩ nfɔnɛ Yudafɔ Lɛgã a awɛ nkpa mi?” ");
INSERT INTO bov_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato via fukĩĩ kitonɛkĩ enyina yededeede kĩ lineke sũ mɔ basɔfɔnɔkɔɛ̃ a kɔa Yesu bido nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lɛmɛ Yudafɔ basɔfɔnɔkɔɛ̃ kɔa bido nɛ bati kɔdabu a kamɛ kĩ bivia Pilato ɛfɔnɛ Baraba mbom awɛ ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato buki evia bati kɔdabu a kĩ, “Kekɔ̃ litsa miawɛ kĩ nkɛna oti a kĩ miavɛ kĩ Yudafɔ Lɛgã a?” ");
INSERT INTO bov_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ade bɛbɔa fɔwɔla bibi ye kĩ, “Bɔa ye nɛ asendua akũ!” ");
INSERT INTO bov_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato via be kĩ, “Litsa tɔkpa ɛkɛna?” Ade be flee bɛbɔa fɔwɔla kɔɔba kĩ, “Bɔa ye nɛ asendua akũ!” ");
INSERT INTO bov_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato wɛ kĩ yakɛna nɛ bati kɔdabu a kawɛ akũ ɛkpa be, foesũ ɛfɔnɛ Baraba awɛ ɛkpa be, ade kĩ ɛfɔ̃ sodzafɔ bo Yesu paa mɔ mpile biyu a, ɛkɔa ye ɛkpa sodzafɔ a kĩ bɛnaabɔa ye nɛ asendua akũ. ");
INSERT INTO bov_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sodzafɔ a kpã Yesu biwomɛna nɛ abãã ɔnɔkɔɛ̃ a tɔtɔ a lɔwabe, ade bɛvɛ sodzafɔ nkaɛ a bɛyakpɔta a. ");
INSERT INTO bov_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ade bɛkɔa lima ngbã atadiɛ wulaa bido ye, bɛnɔ fɔtsɔlɛwɛ lɔbɔɛ bɛtsa ye a. ");
INSERT INTO bov_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Adeke bɛkawɔ̃na ye kĩ, “Yiiduu! Yudafɔ Lɛgã, lidzi nkpã gɛlɛɛlɛ!” ");
INSERT INTO bov_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bibo ye nɛ lɔlɔ mɔ otse, bitua tanɛ biko nɛ ye akũ, ade bike aduli bɛkɛna fɔlɔ bɛkpa ye a. ");
INSERT INTO bov_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kĩ bidi ye nsekuo biyua a, bɛnyɛ atadiɛ ngbã a nɛ ye akũ, bimuniki mɔ ye mɔawɛ tide bido ye. Ke liti a, bɛkpã ye bɛnɛmɛna kĩ banaabɔa ye nɛ asendua akũ. ");
INSERT INTO bov_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kĩ banaa a, bɛtsɛlamɛna onyole odi kĩ bavɛ Simon kĩ eto akula adi kamɛ yanaa ɔmatɔ kamɛ. Ade sodzafɔ a hɛ ye kĩ ɛtɛ Yesu asendua a ɛlɔ a. Simon kĩĩ to Kireneni ɔmatɔ a, ade ɛnyɛ Aleksandro mɔ Rufo ɔlɛga a. ");
INSERT INTO bov_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bɛkpã Yesu bɛnamɛna kakɔ kadi kĩ bavɛ Golgata, kĩ foe kayɔ nyɛ oti lɔlɔ fɔtsɔ̃. ");
INSERT INTO bov_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ade awã bɛkpa ye waĩ kĩ bɛtsɛkamɔ otsonu kĩ yadina akũ kawo kĩ ɛmɔa a, lɛmɛ Yesu támɔa be. ");
INSERT INTO bov_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sodzafɔ a bɔa Yesu nɛ asendua akũ ade bɛta bavulibi nɛ ye tɛtadiɛ akũ bɛmɔ́ ekĩ yaanya odi nyɛ odi ade a. ");
INSERT INTO bov_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bɛbɔa ye nɛ asendua akũ nɛ ɔnɔnɛ tɔdɔũ evedi kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ade bɛtsɛlɛ ye onukpɛ̃ katsua fɔlɛtsa bɛbɔa nɛ ye lɔlɔ nyangɛ kĩ, “Yudafɔ Lɛgã a.” ");
INSERT INTO bov_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɛbɔa bayekpanɛ nviã lɛmɛ nɛ asendua akũ bibumɔ Yesu, ɔmɔa nɛ ye sɔmɔna, ɔyade nɛ ye sɛbã. ");
INSERT INTO bov_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɛ osi kĩĩ akũ, lɛtsa a kĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ a ya nɛ foe kamɛ kĩ, “Bibu ye bido nɛ tɔkpa bakɛnanɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bati a kĩ bɛkatɛ̃ a kpɔkpa fɔlɔ ade bivũna Yesu kĩ, “Ao! Nɔ a kĩ ɔlɛ kĩ aaveli Asɔli Kɔla a obuki oke kɔbɛbã nɛ fuwi ɛlalɛ liti a nɛ awĩ a? ");
INSERT INTO bov_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Duma nɛ asendua akũ, kanyɛ nɔ akũ!” ");
INSERT INTO bov_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ade ayea Yudafɔ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a lɛmɛ di ye nsekuo bɛkabi akũ kĩ, “Ɛtɛ bati bɛbã nkpã, lɛmɛ yaápuli ɛtɛ ye mɔawɛ akũ. ");
INSERT INTO bov_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mifɔ̃ Kristo, Israelfɔ Lɛgã a eduma nɛ asendua akũ finyaa bɔmɔ lɔkɔa bɔtɛ ye budo” Ade bati nviã a kĩ bɛbɔa nɛ asendua akũ bibumɔ Yesu a, lɛmɛ vũna ye a. ");
INSERT INTO bov_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kĩ suwa tɔdɔũ ewua-nviã bɔa a, katinya kamɛ flee ke ɔtũ, kɛnawo tɔdɔũ ɛlalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nɛ tɔdɔũ ɛlalɛ kamɛ a, Yesu bɔa fɔwɔla kɔɔba ɛlɛ nɛ Hebri tide kamɛ kĩ, “Eloi, Eloi, lama sabaktani?” Foe kayɔ nyɛ, “Yĩ Baguma! Yĩ Baguma! Litsa sũ ɔfɔnɛ yĩ awɛ?” ");
INSERT INTO bov_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bati a kĩ bɛdzɛ̃ nɛ awã a badi nu lɛtsa kĩ ɛlɛ a, ade bɛlɛ kĩ, “Mitse! Yavɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya.” ");
INSERT INTO bov_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Be kamɛ ɔmɔa wula atsɛ ɛnabɔɛ kanyinya butubu ɔsapɔ kĩ edo nɛ waĩ mɔ ɔnyɛ kamɛ ade ɛdɛla mɔ otse ɛkpa Yesu kĩ ɛmɔa a. Ade oti a kalɛ kĩ, “Midza, mifɔ̃ bɔdã ntɛ Eliya aaka ɛyaanyɛ ye nɛ asendua a akũ!” ");
INSERT INTO bov_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu buki ɛbɔa fɔwɔla kɔɔba ade ɛmɛna onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nɛ lɔkɔ a na kamɛ pɛ, Asɔli Kɔla lima kpale a kĩ litsua koe kamɛ a bɛ̃ nɛ kayite, kito nyangɛ kɛyawo kayɔ. ");
INSERT INTO bov_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ade kĩ sodzafɔ ɔnɔkɔɛ̃ a kĩ ɛdza ɛtsɛlamɛna asendua a nu Yesu fɔwɔla kabɔa mɔ ayekĩ eku a, ɛlɛ kĩ, “Nuwĩ fɔanɛ kĩ oti kĩĩ nyɛ Baguma Obi.” ");
INSERT INTO bov_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Batsole badi lɛmɛ dza mɔ lugo bɛkadã. Be kamɛ badi nyɛ Maria Magdalani, Salome mɔ Maria kĩ ye babi nyɛ Yakobo obisɛ̃de a mɔ Yose. ");
INSERT INTO bov_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lɔkɔ a kĩ Yesu na nɛ Galilea, ade be lɛkatomɔ ye bɛkabumɔ ye a. Batsole bɛbã pii kĩ bitomɔ ye bɛya nɛ Yerusalem a lɛmɛ na nɛ awã. ");
INSERT INTO bov_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Fɔtsa kĩĩ flee ya nɛ luwi kĩ lɛnya Kawɛya Luwi a lɔtɔ. Nɛ olobe lɔkɔ a, ");
INSERT INTO bov_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosef kĩ eto Arimatia ɔmatɔ a ya. Ɛnyɛ oti kĩ edeĩ obu nɛ fɔlɛtsa badzɛnɛ a kamɛ, ade edzi yadã Baguma Lɛgãkanyakɔ̃ a kaya anɛ a. Yosef do ɔwɔlɛ ɛnaa Pilato sɛkɛ̃ eke ye aduli evia kĩ ɛfɔnɛ Yesu ɔnɔkpa a awɛ ɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fɔkɛna Pilato wãwã kĩ enu kĩ Yesu ku kɔkɔɛ. Foesũ ɛvɛ sodzafɔ ɔnɔkɔɛ̃ evia ye kĩ nuwĩ Yesu ku kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ade kĩ ɔnɔkɔɛ̃ a bi ye ɔnɔkɔali a, Pilato kpa Yosef osi kĩ ɛnaavɛnya ɔnɔkpa a. ");
INSERT INTO bov_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ade Yosef naya aklala, ade kĩ ɛnavɛnya Yesu ɔnɔkpa a, esuli ye nɛ lima a kamɛ. Ɛkɔa ye ɛwɔla nɛ linikɛ kĩ bɛnyɛ nɛ de ɔkɛ kamɛ, ade emilinya de kpale ɛbalɛ linikɛ a onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalani mɔ Maria kĩ ɛnyɛ Yose ɔma a dza bɛkadã, ade bɛmɔ́ awã kĩ bɛkɔa Yesu ɔnɔkpa a bibila a. ");
INSERT INTO bov_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kĩ Kawɛya Luwi a wũna a, Maria Magdalani, Maria Yakobo ɔma mɔ Salome bɛnaya klubɔũ kĩ banaatsɛla Yesu ɔnɔkpa a. ");
INSERT INTO bov_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nɛ Ɛkwansieda ɔnɔnɛ tutuutu a, kĩ suwa de a, biyidza bɛnaa linikɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Kĩ banaa a, bɛkavia akũ kĩ, “Owei aamilinya de kpale a nɛ linikɛ a onukpɛ̃ ɛkpa boe?” De a pɔnɛ lububu paa. Kĩ bɛdzɛla anɛ bɛdã a, bɛmɔ́ kĩ bimilinya de a biyi nɛ ɔɔwɛ̃ kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Foesũ biwo nɛ linikɛ a kamɛ. Adeke bɛmɔ́ opopo odi kĩ edo atadiɛ wulaa fitaa edzi nɛ sɔmɔna sɛmakɛ, ade bɛbɔa oblia. ");
INSERT INTO bov_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Opopo a bi be kĩ, “Mitavila. Yesu Nazaretni a kĩ bɛbɔa nɛ asendua akũ a, miawɛ. Ɛláa awĩ kĩĩ. Eyidza edzi nkpã! Midã, ade awĩ bɛkɔa ye bɛwɔla a. ");
INSERT INTO bov_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Minaabi ye fɔtsa bakɔlɛnɛ a mɔ Petro lɛmɛ kĩ, ‘Yesu nyaa mi lɔtɔ yanaa Galilea, ade awã míamɔ ye ndɛ ayekĩ ebi mi eyi a.’ ” ");
INSERT INTO bov_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Foesũ batsole a nɛ bilo atsɛ bɛdzakũ nɛ linikɛ a ɔwɛ̃ nɛ libe mɔ kukũtila kamɛ. Bɛtábi odima kadima kitonɛkĩ bɛkavila. ");
INSERT INTO bov_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kĩ Yesu yidza eto banɔkpa kamɛ nɛ Ɛkwansieda ɔnɔnɛ tutuutu a, ɛnya lɔtɔ ɛnyɛ ye akũ ɛtsa Maria Magdalani, kĩ ye kamɛ ɛblɔmɛna hũhũ kpa evũkɔnɔ etomɛna a. ");
INSERT INTO bov_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ade ye lɛnabi bikĩ bitomɔ Yesu tɔ̃ a fɔlɛtsa a. Bati kĩĩ dzi bɛkabe ayɔlɔhɔ nɛ ye wuda a akũ. ");
INSERT INTO bov_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lɛmɛ kĩ Maria bi be kĩ Yesu yidza edzi nkpã, ade kĩ ɛmɔ́ ye malo ni, bɛtátɛ ye bido. ");
INSERT INTO bov_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Fukĩĩ liti a, Yesu nyɛ ye akũ ɛtsa ye fɔtsa bakɔlɛnɛ nviã kĩ Bito Yerusalem banaa akula, lɛmɛ bɛtámɔ ye biyi ɔsũ nɛ kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bimuniki bɛnabi be nkaɛ a, lɛmɛ be malo bɛtátɛ bido. ");
INSERT INTO bov_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ke liti a, Yesu nyɛ ye akũ ɛtsa fɔtsa bakɔlɛnɛ ewua-odi a kĩ bidzi banya. Lɛmɛ ɛkã be anɛ kĩ bɛtána katɛkado, mɔ kĩ bɛna atɔ ɔsĩ, bɛtátɛ bati a kĩ bɛmɔ́ kĩ ye edzi nkpã a lɛmɛ bido a. ");
INSERT INTO bov_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ebi be kĩ, “Minaa katinya kamɛ flee minaalɛ Kalɛ Wĩ a mikpa batidziwa flee. ");
INSERT INTO bov_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Odi nyɛ odi kĩ ɛtɛ edo, ɛtɛ mui kawɔla lɛmɛ ni, baatɛ ye nkpã, lɛmɛ odi nyɛ odi kĩ ɛtátɛ edo ni, baakɔ ye kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Baguma aakpa batɛ badonɛ a kɔbɛ̃ bɛkɛna awãwã fɔtsa. Baablɔmɛna hũhũ kpa bɛnɛmɛna nɛ yĩ dĩ akũ, baalɛ tide vɔɛ̃. ");
INSERT INTO bov_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ade ntɛ bipi kɔɛ ĩye bɛmɔa otsonu kpa ni, fɔláakɛna be lɛtsama. Ntɛ bite awɛ nɛ basɔnɛ akũ ni, baana akũ ɔsĩ.” ");
INSERT INTO bov_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ke liti a, kĩ boe Ɔlate Yesu lɛ kɔdzɛla mɔ be eyua a, bɛbɔɛ ye bɛnamɛna nɛ ode ade ɛnadzi nɛ Baguma sɔmɔna a. ");
INSERT INTO bov_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ye fɔtsa bakɔlɛnɛ a nalɛ Kalɛ Wĩ a nɛ kakɔ nyɛ kakɔ. Boe Ɔlate a kɛna adzuma mɔ be, ɛkɔa awãwã fɔtsa a kĩ bɛkakɛna a ete de kĩ be fɔlɛtsa a nyɛ ɔnɔkɔali.");
INSERT INTO bov_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɔnɔkɔɛ̃ Tiofilo, bati pii bɔa mbɔdi ayekĩ baapuli, bɛtsɛlɛ lɛtsa nyɛ lɛtsa a kĩ lɛya nɛ boe kamɛ a biyi. ");
INSERT INTO bov_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bɛtsɛlɛ lɛtsa a kĩ bibi boe a, ndɛ ayekĩ binu bitomɛna bikĩ bɛmɔ́ fɔlɛtsa kĩĩ bamɛ kito anɛ kayɔkayi a, ade bide lɛtsã nɛ foe akũ a. ");
INSERT INTO bov_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Foesũ, Ɔnɔkɔɛ̃ Tiofilo, nɛ ayekĩ yĩ mɔawɛ a ntsã fɔlɛtsa kĩĩ flee kamɛ kito kayɔkayi a sũ ni, nkɔna kĩ fɔnɛnɛ kĩ matsɛlɛ fɔlɛtsa a pɛpɛɛpɛ mma nɔ. ");
INSERT INTO bov_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nkɛna fukĩĩ ayekĩ aanyi ɔnɔkɔali kalɛ a nɛ fɔlɛtsa a kĩ bɛtsa nɔ a flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nɛ lɔkɔ a kĩ Herodes kanya lɛgã nɛ Yudea tite akũ a, Yudafɔ ɔsɔfɔ odi na kĩ bavɛ Zakaria. Eto ɔsɔfɔ katsu a kĩ bavɛ Abiya a kamɛ. Ɔtsɔ̃ dĩ nyɛ Elizabet kĩ ye malo eto ɔsɔfɔ Aaron kasinu a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɔtsɔ̃ mɔ ɔnyɔ kĩĩ dzi nkpã wĩ nɛ Baguma anɛ, ade bɛkadi ye tɛbla mɔ nhihiɛ akũ pɛpɛɛpɛ a. ");
INSERT INTO bov_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bati kĩĩ táma obi odima kitonɛkĩ Elizabet nya oduko, ade bati nviã a lɛmɛ dɛ a. ");
INSERT INTO bov_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Luwi a Zakaria kakɛna ye tɔsɔfɔ adzuma nɛ Yudafɔ afɔliɛ kabɔakɔ̃, kitonɛkĩ be katsu a akũ fuke. ");
INSERT INTO bov_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nɛ be basɔfɔ adzuma kakɛna onukpɛ̃ a, biwole ade fɔyake nɛ Zakaria akũ, kĩ ɛnaate ɔnyɔ mɔ ɔlɛ̃ ɛkpa Baguma nɛ ye afɔlibɔ atɛnyɛ a akũ. Foesũ ewo ɛnaa Yudafɔ afɔliɛ kabɔakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lɔkɔ a kĩ ɛkate ɔnyɔ a, bati nkaɛ a ko nɛ kanya bɛkabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Boe Ɔlate ode fɔtɔ ɔnyanɛ odi nyɛ ye akũ ɛtsa ye nɛ ɔnyɔ katekɔ̃ a sɔmɔna sɛmakɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kĩ Zakaria mɔ́ ye a, ɛbɔa obili ade libe wo ye paa a. ");
INSERT INTO bov_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lɛmɛ Baguma ode fɔtɔ ɔnyanɛ a bi ye kĩ, “Zakaria, tavila! Baguma nu nɔ mpaɛbɔ, nɔ ɔtsɔ̃ Elizabet aama obinyole ɛkpa nɔ. Aate ye dĩ kĩ Yohanes. ");
INSERT INTO bov_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kawɔlɛ aade nɔ paa, ade ayea kawɔlɛ aade bati pii lɛmɛ ntɛ bɛma ye a. ");
INSERT INTO bov_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yaanya oti kpale nɛ Baguma anɛ. Kɛtánɛ kĩ yamɔa waĩ ĩye bavɛ mɔ ɔsĩ. Ade kito ye kama kamɛ ni, Hũhũ Kpalɛwa aatɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ade ye aanya oti kĩ yaamunikimɔ Israelfɔ bati pii ɛyamɛna nɛ be Ɔlate Baguma a sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yaanya boe Ɔlate kaya a lɔtɔ ɛna hũhũ mɔ kɔbɛ̃ ndɛ ayekĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya na a. Yaalɔla babi mɔ balɛga kayite. Yaadani bikĩ bideĩ atɔ ɔsĩ bɛna adzuni ndɛ bikĩ bakɛna tuwĩ. Fukĩĩ aafɔ̃ boe Ɔlate bati lɛna nɛ kukũmanɛ kamɛ bɛkpa ye.” ");
INSERT INTO bov_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ade Zakaria via ode fɔtɔ ɔnyanɛ a kĩ, “Nde maakɛna ĩnyi kĩ fukĩĩ aaya nɛ foe kamɛ? Kitonɛkĩ ndɛ, ade yĩ ɔtsɔ̃ lɛmɛ dɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Baguma fɔtɔ ɔnyanɛ a kpa mbuayɛ kĩ, “Yĩ nyɛ Gabriel kĩ madza nɛ Baguma anɛ. Ade ye lido yĩ kĩ ĩyaabi nɔ ɔlɛdo wĩ kĩĩ a. ");
INSERT INTO bov_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lɛmɛ ɔtátɛ yĩ ɔlɛdo odo, kĩ yaaya nɛ foe kamɛ nɛ lɔkɔ a kĩ Baguma hihiɛ eyi a. Nɛ foesũ aatɔ lumumu, ɔláapuli ɔlɛ kɔdzɛla kɛnaawo luwi a kĩ fɔlɛtsa a kĩ nlɛ ĩyi kĩĩ a aaya nɛ foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nɛ lɔkɔ a kamɛ a, bati a kĩ bɛna nɛ kanya bɛkadzɔlɛ Zakaria kɛna saa, ade bɛkabu lɔlɔ kamɛ nɛ lɛtsa a sũ kĩ ebuna owi beblebee nɛ afɔliɛ kabɔakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kĩ Zakaria nɛ ɛya a, ɛtábuki epuli ɛlɛ kɔdzɛla mɔ be. Foesũ bɛmɔ́ biyi ɔsũ kĩ ɛmɔ kanyɛkatsa kadi nɛ afɔliɛ kabɔakɔ̃ a. Kĩ ɛtɔ lumumu sũ ni awɛ ɛkɔa ɛkakɛna nsɛntsɛlɛni katsa be. ");
INSERT INTO bov_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kĩ Zakaria yua ye adzuma nɛ Yudafɔ afɔliɛ kabɔakɔ̃ a, ɛdzakũ ɛnaa ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ke liti a, Elizabet yatsãmɔ kɔma ade ɛtábuki ɛnɛ kanya a. Ɛkɔla ye akũ tidetɔ elo flee. ");
INSERT INTO bov_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Adeke Elizabet lɛ kĩ, “Finyaakĩĩ ni, Baguma bumɔ yĩ ade ɛnyɛ yĩ kɔnyɔã nɛ bati anɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nɛ tidetɔ evũ liti a, Baguma do ye ode fɔtɔ ɔnyanɛ Gabriel ɛnaa Galilea ɔmatɔ odi kĩ bavɛ Nazaret kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ode fɔtɔ ɔnyanɛ kĩĩ kɔa ɔlɛdo ɛma oyitsɔ̃ kĩ bitinya bɛkpa onyole kĩ bavɛ Yosef, kĩ ɛnyɛ Lɛgã Dawid kasinu a kamɛ obi. Oyitsɔ̃ a dĩ nyɛ Maria. ");
INSERT INTO bov_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ode fɔtɔ ɔnyanɛ a ya nɛ Maria sɛkɛ̃ ade ebi ye kĩ, “Oyitsɔ̃, mawɔ̃na nɔ nɛ lukudɔ kamɛ! Nɔ oti kĩ bɛmɔ́ kɔnya, boe Ɔlate tomɔ nɔ!” ");
INSERT INTO bov_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ode fɔtɔ ɔnyanɛ ɔlɛdo a fɔ̃ Maria kɛna basaa, ade evia ye akũ kĩ, “Litsa kawɔ̃na nɛ awĩ a?” ");
INSERT INTO bov_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ade ode fɔtɔ ɔnyanɛ a bi ye kĩ, “Maria, tavila. Baguma mɔ́ nɔ kɔnya. ");
INSERT INTO bov_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aatsãmɔ kɔma ɔma obinyole, lɔkɔa aate ye dĩ kĩ Yesu. ");
INSERT INTO bov_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yaatɛ dĩ paa kĩ bati aavɛ ye kĩ Baguma Nɛ Ode Flee Obi. Boe Ɔlate aadzina ye lɛgã ndɛ ɔwanyɔ Dawid aye. ");
INSERT INTO bov_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ade yaanya lɛgã nɛ Yakob babi mɔ bawa akũ daa a. Ye lɛgãkanyakɔ̃ a lɛláawũna dadaada.” ");
INSERT INTO bov_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Awã naa Maria bi Baguma ode fɔtɔ ɔnyanɛ a kĩ, “Nde fukĩĩ aapuli fɔya nɛ foe kamɛ nɛ lɔkɔ kĩ ĩnyína onyole a?” ");
INSERT INTO bov_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ade ke ode fɔtɔ ɔnyanɛ a bi ye kĩ, “Hũhũ Kpalɛwa ayako nɛ nɔ akũ ade Baguma kɔbɛ̃ aatɛ nɔ kamɛ a. Foesũ obi kpalɛwa a kĩ aama a ni, baavɛ ye kĩ Baguma Obinyole. ");
INSERT INTO bov_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mawɛ kĩ kai nɔ akũ oti kĩ bavɛ Elizabet. Bati alɛ kĩ ɛláama, lɛmɛ finyaakĩĩ ɛtsɛ̃mɔ kɔma. Edeĩ nɛ odetɔ ovũde kamɛ, titɔ kĩ ɛdɛ posoposo malo. ");
INSERT INTO bov_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kitonɛkĩ lɛtsama lɛláa kĩ Baguma lɛláapuli ɛkɛna.” ");
INSERT INTO bov_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ade Maria bi ye kĩ, “Dã, boe Ɔlate ɔsumunɛ manɛ. Fɔya nɛ foe kamɛ fɔkpa yĩ ndɛ ayekĩ ɔlɛ a.” Ade ode fɔtɔ ɔnyanɛ a dzakũ ɛfɔnɛ ye a. ");
INSERT INTO bov_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Nɛ fuwi a na kamɛ a, Maria manɛ akũ, ɛwɛ sɔwa ɛnaa Zakaria awã nɛ Yudea ɔmatɔ odi kĩ edeĩ nɛ tɔtɔ kamɛ, ade ɛnawɔ̃na Elizabet a. ");
INSERT INTO bov_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kĩ Elizabet nu Maria kawɔ̃na a, ye obi nɛ sɛmɛ kamɛ a kuna akũ, ade Hũhũ Kpalɛwa a tɛ Elizabet kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ade awã na ɛbɔa fɔwɔla kɔɔba ɛlɛ kĩ, “Bihila nɔ nɛ batsole flee kamɛ, ade bihila nɔ sɛmɛ kamɛ obi a lɛmɛ a! ");
INSERT INTO bov_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yĩ nyɛ owei kĩ boe Ɔlate ɔma ya kĩ yayaawɔ̃na yĩ? ");
INSERT INTO bov_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lɔkɔ a kĩ nsila nnu nɔ kawɔ̃na pɛ, obi nɛ yĩ sɛmɛ kamɛ a kuna akũ mɔ kawɔlɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bihila nɔ paa kitonɛkĩ ɔtɛ odo kĩ Baguma ɔlɛdo a kĩ ɛlɛ nɛ nɔ akũ a aaya nɛ foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Awã naa Maria lɛ kĩ, “Yĩ ɔwɔlɛ amu Baguma. ");
INSERT INTO bov_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ade kawɔlɛ ade yĩ hũhũ a, nɛ Baguma yĩ Ɔtɛnɛ a sũ, ");
INSERT INTO bov_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kitonɛkĩ ete anɛ nɛ, yĩ ye ɔsumunɛ kĩ ɛnyɛ́ lɛtsama akũ. Kito finyaa kanaa ni, babi mɔ bawa flee aavɛ yĩ oti kĩ bihila ye, ");
INSERT INTO bov_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kitonɛkĩ Baguma Otumifɔ kɛna fɔtsa kpale ɛkpa yĩ. Ye dĩ akũ kpalɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ye kɔnyakamɔ waa, kɛkpa babi mɔ bawa kĩ bavila ye a. ");
INSERT INTO bov_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɛkɛna fɔtsa kpale, ade ɛyalɛ bati a kĩ bɛdɛla be akũ nɛ ode mɔ be kakɔna flee a. ");
INSERT INTO bov_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɛdzɛla fɔgã kĩ fudeĩ kɔbɛ̃ nɛ be fɔgãkpo akũ, ade ɛdɛla bikĩ bɛdɔla be akũ a nɛ ode a. ");
INSERT INTO bov_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɛkpa bikĩ kɔlɛ akɔ be a fɔtsa wĩ pii, ade ɛfɔ̃ bikĩ bideĩ akũ a dzakũ mɔ awɛ pupulidza a. ");
INSERT INTO bov_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ete anɛ nɛ lɛtsa a kĩ ɛlɛ eyi ɛkpa boe bawanyɔ a akũ, ade ɛyaabumɔ ye ɔsumunɛ Israel a. Ete anɛ, ɛmɔ Abraham kɔnya, mɔ ye babi mɔ bawa kito finyaa flee kanaa!” ");
INSERT INTO bov_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria dzi nɛ Elizabet sɛkɛ̃ ndɛ tidetɔ ɛlalɛ fɔmɔ emuniki ɛnaa ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kĩ Elizabet aama a, ɛma obinyole. ");
INSERT INTO bov_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ye akũ bati mɔ banunɛ flee nu ayekĩ Baguma kɛna sɛmɛ kalɛ ɛkpa ye, foesũ be flee bɛmɔ́ kawɔlɛ paa mɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kĩ akɔkɔa a tɛ fuwi ɛlɛ̃ a, ye akũ bati ya kĩ batsua ye lɛkpati, ade bɛwɛ kĩ bakɔa ye ɔlɛga dĩ Zakaria bite ye a. ");
INSERT INTO bov_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lɛmɛ ɔma tátunɔ mɔ be, ade ebi be kĩ, “Ye dĩ aanya Yohanes.” ");
INSERT INTO bov_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ade awã mɔ bibi ye kĩ, “Odima táto nɔ kɔla kamɛ kĩ yanya dĩ a na.” ");
INSERT INTO bov_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɛ foesũ bɛkɔa awɛ bɛkɛna nsɛntsɛlɛni bivia ɔlɛga kĩ ɛtsa dĩ a kĩ ɛwɛ kĩ yate obi. ");
INSERT INTO bov_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Awã naa Zakaria via sileti ade ɛtsɛlɛ ete kĩ, “Ye dĩ nyɛ Yohanes.” Fɔkɛna be a flee saa. ");
INSERT INTO bov_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Deedimɔapɛ Zakaria buki edo kɔdzɛla kalɛ awɛ ade emu Baguma a. ");
INSERT INTO bov_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Libe wo ye banunɛ a flee ade fɔlɛtsa kĩĩ gba nɛ tɛmatɔ a kĩ tideĩ nɛ Yudea tɔtɔ kamɛ a flee a. ");
INSERT INTO bov_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Fɔlɛtsa kĩĩ kpa bati a kĩ binu foe a lɔlɔ kamɛ kabu, ade bivia be akũ kĩ, “Litsa odu obisɛ̃ kĩĩ aadani ɛkɛna?” Bivia foe kitonɛkĩ fɔwaa yedede kĩ Baguma kɔbɛ̃ tomɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hũhũ Kpalɛwa tɛ obisɛ̃ a ɔlɛga Zakaria kamɛ ade ɛlɛ Baguma fɔlɛtsa eyi kĩ, ");
INSERT INTO bov_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mifɔ̃ bumu boe Ɔlate, Israel Baguma, kitonɛkĩ ɛyabumɔ ye kade bati, ade ɛnyɛ be nɛ tɔkpa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɛkpa boe Ɔtɛnɛ kĩ edeĩ kɔbɛ̃, oti kĩ ɛnyɛ ye osumunɛ Lɛgã Dawid kasinu a kamɛ obi. ");
INSERT INTO bov_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nɛ ayekĩ ɛlɛ eyi anɛ kɔkɔɛ ɛtsãmɛna ye onukpɛ̃ banyɛnɛ kpalɛwa a akũ, ");
INSERT INTO bov_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kĩ yaanyɛ boe etomɛna bikĩ bapi boe osumbɔ mɔ boe bakesĩnɛ flee awɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɛlɛ kĩ yaamɔ boe bawanyɔ kɔnya, ade ete anɛ nɛ ye nhihiɛ kpalɛwa a kĩ ɛkɛna eyi a akũ a. ");
INSERT INTO bov_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Yaakɛna nɛ fubo a kĩ ɛlɔ ɛkpa boe ɔwanyɔ Abraham, kĩ yaanyɛ boe etomɛna boe bakesĩnɛ awɛ kamɛ a akũ, ayekĩ bɔ́apuli busum Baguma nɛ katavila kamɛ, ");
INSERT INTO bov_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","boe akũ lɛkpalɛ, budzi kadzi wĩ nɛ ye anɛ, nɛ boe nkpã fuwi flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nɔ, yĩ obi, bati aavɛ nɔ Baguma Nɛ Ode Flee Onukpɛ̃ Ɔnyɛnɛ. Ade nɔ aanya boe Ɔlate lɔtɔ lɔkɔa ɔlɔla osi ɔkpa ye kaya a. ");
INSERT INTO bov_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aabi ye bati kĩ baana katɛ nɛ be titikpa kakɔakate kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Boe Baguma deĩ sɛmɛ kalɛ mɔ ɔwɔlɛ bɔɛɛ, foesũ yaafɔ̃ katɛ ɔhaĩ a lide ɛkpa boe. ");
INSERT INTO bov_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yaafɔ̃ ɔhaĩ kĩĩ lɛyaako nɛ bati a kĩ bideĩ nɛ ɔtũ kamɛ, mɔ bikĩ bideĩ nɛ wuda kuyo kamɛ a akũ, lɔkɔa ɛkpã boe ɛtsãmɛna lukudɔ osi akũ.” ");
INSERT INTO bov_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Obisɛ̃ a bo anɛ nɛ sukɛna mɔ hũhũ kamɛ. Edzi nɛ kɔsa kamɛ, kɛnawo luwi a kĩ ɛnyɛ ye akũ ɛtsa Israel kanade a. ");
INSERT INTO bov_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nɛ lɔkɔ a na kamɛ a, Lɛgãnɔkɔɛ̃ Kaisare Augusto si mbla kĩ bɛkã, bɛtsɛlɛ bati flee a kĩ bideĩ nɛ Roma lɛgãkanyakɔ̃ tite akũ a buĩ. ");
INSERT INTO bov_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nɛ bati buĩ katsɛlɛ katɔnyade kĩĩ kamɛ a, abãã ɔnɔkɔɛ̃ kĩ bavɛ Kirenio lɛnya Siria tite akũ. ");
INSERT INTO bov_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nɛ mbla a sũ odi nyɛ odi naa ye ɔtɔ kĩ yanaatsɛlɛ dĩ. ");
INSERT INTO bov_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ade ke Yosef to Nazaret ɔmatɔ nɛ Galilea ɛnaa Betlehem ɔmatɔ nɛ Yudea tite akũ, awã kĩ bɛma Lɛgã Dawid lɛmɛ a. Yosef naa awã kitonɛkĩ ɛnya Lɛgã Dawid kasinu a kamɛ obi. ");
INSERT INTO bov_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bɛmɔ Maria kĩ bitinya bɛkpa ye a kĩ ɛtsɛ̃mɔ kɔma lɛmɛ a lɛnaa kĩ banaatsɛlɛ buĩ. ");
INSERT INTO bov_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kĩ bɛna nɛ Betlehem a, lɔkɔ wo ɔtɔ kĩ Maria ama. ");
INSERT INTO bov_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ɛma ye obinyole ɔtɔnyade, ade esuli obi a edo nɛ fumakũ kamɛ, ɛkɔa ɛwɔla nɛ lɛtsa a kĩ de kamɛ bayaɛ anya a kamɛ, kitonɛkĩ bɛtána kawakɔ̃ kadima nɛ banɔvɔɛ̃ kasekɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Baveli bakpãnɛ badi na nɛ tite a kakɔ kadi lɛnyɛ a flee bɛkadã be bayaɛ akũ. ");
INSERT INTO bov_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Deedimɔapɛ ode fɔtɔ ɔnyanɛ odi nɛ ɛta nɛ be kayite ade Baguma kukũkpalɛ ko nɛ be akũ a. Nɛ foesũ bivila paa, ");
INSERT INTO bov_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","lɛmɛ ode fɔtɔ ɔnyanɛ a bi be kĩ, “Mitavila! Mma mi fɔlɛtsa wĩ kĩ fɔ́ayamɛna kawɔlɛ mɔ lukudɔ pii fɔkpa bati flee. ");
INSERT INTO bov_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nɛ nviã luwi kĩĩ akũ, bɛma Ɔtɛnɛ kĩ ɛnyɛ boe Ɔlate Kristo bɛkpa mi nɛ Lɛgã Dawid ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lɛtsa a kĩ míakɔa mimɔ́ miyi ɔsũ nyɛ kĩ míamɔ waawa a kĩ busuli ye bido nɛ fumakũ kamɛ ɛwaa nɛ bayaɛ kanyakɔ̃.” ");
INSERT INTO bov_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Deedimɔapɛ ode fɔtɔ banyanɛ kɔdza baũ kudi to ode kɔka kɔyabumɔ ɔtɔnyade a, ade be a flee bɛkamu Baguma mɔ kawɔlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Obu mɔ kamu kɛkpa Baguma nɛ ode flefle, lɔkɔa lukudɔ litomɛna katinya kamɛ bati flee a kĩ Baguma awɛ a!” ");
INSERT INTO bov_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kĩ ode fɔtɔ banyanɛ a dzakũ nɛ be sɛkɛ̃ bɛdani bɛnaa ode a, baveli bakpãnɛ a bi be akũ kĩ, “Mifɔ̃ bɔnaa Betlehem bɔnaadã lɛtsa a kĩ lɛya a kĩ boe Ɔlate bi boe a.” ");
INSERT INTO bov_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ade bɛwɛ sɔwa bɛnaa bɛnamɔ Maria, Yosef mɔ waawa a kĩ ɛwaa nɛ bayaɛ kanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kĩ bɛmɔ́ ye a, bɛlɛ fɔlɛtsa a flee kĩ Baguma ode fɔtɔ ɔnyanɛ a bi be nɛ obisɛ̃ a akũ. ");
INSERT INTO bov_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bati flee a kĩ binu baveli bakpãnɛ fɔlɛtsa a kɛna saa. ");
INSERT INTO bov_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lɛmɛ Maria pi fɔlɛtsa kĩĩ flee edo nɛ lɔlɔ kamɛ, ɛkakɔna foe akũ dzununuunu. ");
INSERT INTO bov_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Baveli bakpãnɛ a muniki bɛnaa mɔ Baguma kamu nɛ fɔlɛtsa flee a kĩ binu, bɛmɔ́ lɛmɛ a akũ, kitonɛkĩ foe flee fɔya pɛpɛɛpɛ ndɛ ayekĩ ode fɔtɔ ɔnyanɛ a bi be a. ");
INSERT INTO bov_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nɛ luwi lɛlɛ̃de akũ kĩ batsua obisɛ̃ a lɛkpati a, bite ye dĩ kĩ Yesu ndɛ ayekĩ ode fɔtɔ ɔnyanɛ a lɛ eyi fɔmɔ bɛyatsãmɔ ye kɔma a. ");
INSERT INTO bov_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lɔkɔ wo ɔtɔ kĩ Yosef mɔ Maria bɛkɛna akũ kakpalɛ yedede amaniɛ ndɛ ayekĩ Mose mbla tsa a. Foesũ bɛkɔa waawa a bɛnamɛna Yerusalem kĩ banaakɔa ye bido nɛ boe Ɔlate awɛ, ");
INSERT INTO bov_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ndɛ ayekĩ bɛtsɛlɛ bido nɛ boe Ɔlate mbla ovoli a kamɛ kĩ, “Obinyole ɔtɔnyade odi nyɛ odi ni kɛnɛ kĩ bɛnyɛ ye biyi bɛkpa boe Ɔlate.” ");
INSERT INTO bov_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ade bɛnaa bɛnakɛna afɔlibɔ fɔtsa a nɛ boe Ɔlate mbla a onukpɛ̃ kĩ bɛkɔa mblɔduma nviã ĩye fɔblɔblɔm nviã bɛbɔa afɔliɛ bɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nɛ lɔkɔ a na kamɛ a, onyole odi kĩ bavɛ Simeon dzi nɛ Yerusalem. Ɛnyɛ oti wĩ kĩ yavila Baguma ade edzi ɛkadã osi kakpa Israel katɛ a. Hũhũ Kpalɛwa deĩ nɛ ye kamɛ, ");
INSERT INTO bov_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ade ɛnyɛ ɛtsa ye lɛmɛ kĩ ɛláaku kɛnaawo lɔkɔ a kĩ ɛmɔ boe Ɔlate, Kristo a kĩ bɛlɛ biyi a. ");
INSERT INTO bov_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ade ke Hũhũ a kpã Simeon ɛnamɛna Yudafɔ Asɔli Kɔla kamɛ a. Kĩ bamanɛ a kɔa waawa Yesu a bɛyamɛna kĩ bayaakɛna amaniɛ nɛ mbla a onukpɛ̃ a, ");
INSERT INTO bov_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon tɛ waawa a ɛlɛ nɛ awɛ, ade ɛnyɛ Baguma kɔlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Boe Ɔlate, finyaa, ɔkɛna nɛ nɔ kalɛ onukpɛ̃ akũ, aapuli ɔnyɛ yĩ, nɔ ɔsumunɛ, osi nnaa nɛ lukudɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yĩ mɔawɛ banebi mɔ́ Ɔtɛnɛ a, ");
INSERT INTO bov_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kĩ ɔkɔa ɔma bati flee a. ");
INSERT INTO bov_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ɛnyɛ ɔhaĩ a kĩ yaanyɛ nɔ fɔwɛtsa ɛtsa bikĩ bɛnyɛ́ Yudafɔ, ade yaanya obu fɔtsa ɛkpa nɔ bati Israelfɔ a.” ");
INSERT INTO bov_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Fɔlɛtsa a kĩ Simeon lɛ nɛ obisɛ̃ a akũ kɛna Yosef mɔ Maria saa. ");
INSERT INTO bov_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon hila be ade ebi Maria kĩ, “Baguma nyɛ obisɛ̃ kĩĩ kĩ fɔtsã ye akũ Israelfɔ pii bɛna katɛ ĩye kawɔ. Yaanya nsɛntsɛlɛni kĩ eto Baguma sɛkɛ̃ ade bati pii aayidza bɛdza nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ade yaanyɛ bati kakɔna a kĩ bɛkɔa bɛkɔla a kanya a. Fɔtsɛ̃ fukĩĩ akũ sũ ni, aatɛ kalɔɛ ndɛ ayekĩ lɛpamɛ atsɔɛ nɔ du.” ");
INSERT INTO bov_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Otsolenɔkɔɛ̃ odi kĩ ɛnya Baguma onukpɛ̃ ɔnyɛnɛ na nɛ awã, ɛnyɛ okunawa kĩ bavɛ Hana. Ɔlɛga nyɛ Fanuel kĩ eto Aser kasinu kamɛ. Futeli evũkɔnɔ pɛ edzi kɔnyɔ fɔmɔ ɔnyɔ ku, ade finyaakĩĩ ɛtɛ futeli aduewɔtsi-ɛna. Yudafɔ afɔliɛ kabɔakɔ̃ a ɛkana lɔkɔ nyɛ lɔkɔ, ɛkasum Baguma lɛnyɛ mɔ suwa, ade ɛkasui onukpɛ̃, kabɔa mpaɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nɛ lɔkɔ a na kamɛ pɛpɛɛpɛ ye malo ɛyawo awã ade ɛnyɛ Baguma kɔlɛ, ɛlɛ fɔlɛtsa nɛ obisɛ̃ a akũ ɛkpa bati flee a kĩ bidzi badã Baguma anɛ kĩ yaanyɛ Yerusalem a. ");
INSERT INTO bov_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kĩ Yosef mɔ Maria yua be amaniɛ kakɛna ndɛ ayekĩ boe Ɔlate mbla tsa a, bimuniki bɛnaa be ɔtɔ Nazaret nɛ Galilea tite akũ. ");
INSERT INTO bov_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Obisɛ̃ a bo anɛ, ɛna akũ ɔsĩ, ade enyi kadi paa a. Baguma nhila lɛmɛ tomɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kateli nyɛ kateli, Yesu bamanɛ kanaa Yerusalem kanaanya luwi kĩ bavɛ Wuda Katɛ̃ Luwi. ");
INSERT INTO bov_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kĩ Yesu tɛ futeli ewua-nviã a, bibuki bɛnaa luwi a kanyakɔ̃ ndɛ ayekĩ bɛkakɛna kɔkɔɛ a. ");
INSERT INTO bov_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kĩ luwi a kanya wũna a, bimuniki banaa ɔtɔ, lɛmɛ Yesu kɔ̃ kahɔ nɛ liti nɛ Yerusalem nɛ ye bamanɛ katanyi kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bibu kĩ ɛna nɛ bati kamɛ, foesũ bɛtsã luwi mɔa flee fɔmɔ bido ye kawɛ awɛ nɛ ye akũ bati mɔ bakɔba kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kĩ bɛtámɔ ye sũ ni, bimuniki bɛnaa Yerusalem bɛnɛ bɛtsɛ̃ bawɛ ye. ");
INSERT INTO bov_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nɛ luwi lɛlade a bɛnamɔ ye nɛ Yudafɔ Asɔli Kɔla kamɛ a kĩ ye mɔ Yudafɔ mbla batsanɛ badi bidzi, ɛkatse be fɔlɛtsa a kĩ bɛkalɛ, ade ɛkavia be fɔlɛtsa nɛ foe akũ a. ");
INSERT INTO bov_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Be flee a kĩ binu ye fɔlɛtsa kamɛ kakpalɛ a, kɛna saa nɛ kadi kanyi baũ odu a kĩ ɛkɔa ɛkpa mbuayɛ a. ");
INSERT INTO bov_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kĩ ye bamanɛ mɔ ye a, akũ yɛla be, ade ɔma via ye kĩ, “Obi, litsa sũ ɔkɛna boe fukĩĩ odu? Bɔmɔ aga flee bɔkɔa kɔnɛyɔɔlɛ bɔtsã bɔwɛ nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ade Yesu kpa mbuayɛ kĩ, “Nde sũ mitsã miwɛ yĩ? Minyína kĩ yĩ Ɔlɛga awa kɛnɛ kĩ nna mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lɛmɛ bɛtánu lɛtsa a kĩ de ebi be a kayɔ. ");
INSERT INTO bov_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu tomɔ be bɛdzakũ bɛnaa Nazaret, ade ɛdɔla ye akũ ɛkpa be a. Ɔma kɔa fɔlɛtsa kĩĩ flee edo nɛ ɔwɔlɛ kamɛ dzununuunu. ");
INSERT INTO bov_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ade Yesu bo anɛ nɛ sukɛna mɔ kadikanyi kamɛ, ade Baguma mɔ bati flee mɔ kawɔlɛ nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nɛ Lɛgãnɔkɔɛ̃ Kaisare Tiberio lɛgãkanya kateli kawualode kamɛ a, Pontio Pilato nya abãã ɔnɔkɔɛ̃ nɛ Yudea tite akũ. Nɛ lɔkɔ a na kamɛ a, Herodes lɛnya Galilea tite akũ, ade ɔwaɛ̃ Filipo nyá Iturea mɔ Trakoniti tite akũ a. Lisania nya Abilene tite akũ. ");
INSERT INTO bov_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hana mɔ Kayafa lɛmɛ nya Yudafɔ basɔfɔnɔkɔɛ̃ flefle a. Ade lɔkɔ a na kamɛ lɛmɛ mɔ Baguma ɔlɛdo ya ɛkpa Yohanes kĩ ɛnyɛ Zakaria obi a kĩ ɛna nɛ kɔsa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Foesũ Yohanes tsã emini nɛ Yordan ɔwɔ abuĩ mɔ ye fuyite a ɛkade lɛtsã kĩ, “Midani mi tɔwɔlɛ kamɛ lɔkɔa mitɛ mui kawɔla amaniɛ ayekĩ Baguma aakɔa mi tɔkpa ete mi.” ");
INSERT INTO bov_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ade aye bɛtsɛlɛ nɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya ovoli a kamɛ kĩ, “Oti odi tsɛ̃ yabɔa fɔwɔla nɛ kɔsa kamɛ kalɛ kĩ, ‘Milɔla osi mikpa boe Ɔlate kaya. Mikɛna osi kpĩĩ miyi ye. ");
INSERT INTO bov_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Miyula fɔkɔ a kĩ fɔpɛlɛ pɛlɛ fuwo a, ade mibubuli tɔtɔ mɔ kɔtɔbii a flee fɔtɛɛ a. Miyo tisi balibaliwa a, ade mitɛɛtɛɛ fɔkɔ a kĩ fude fute a. ");
INSERT INTO bov_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Katinya kamɛ bati flee aamɔ Ɔtɔnɛ a kĩ Baguma do a!’ ” ");
INSERT INTO bov_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bati kɔdabu kɔdabu pii ya nɛ Yohanes sɛkɛ̃ kĩ ɛkɛna be mui kawɔla amaniɛ, ade ebi be kĩ, “Mi bati kĩ mila ndɛ bɔɛ kpa! Owei lɛkpa mi kɔdɛ kĩ míapuli milo nɛ sɔtɔ kavɛlɛ a kĩ Baguma aayamɛna a kamɛ? ");
INSERT INTO bov_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Minyɛ mitsa nɛ mi fɔtsakɛlawa kamɛ bɛmɔ kĩ midani tɔwɔlɛ kamɛ. Ade mitakalɛ kĩ minyɛ Abraham babi mɔ bawa sũ ni, Baguma lɛláavɛlɛ mi sɔtɔ. Kitonɛkĩ mabi mi kĩ Baguma aapuli ɛkɔa boe kĩĩ ɛkɛna babi mɔ bawa ɛkpa Abraham. ");
INSERT INTO bov_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bike kasɔã kɔkɔɛ nɛ futse tɔbɔlɛ akũ kĩ baatsua. Kutse nyɛ kutse kĩ kɔáwũ babi wĩ ni, baakpeli koe bɛta bido nɛ fi luwotu kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Awã naa bati a via Yohanes kĩ, “Foesũ litsa kɛnɛ kĩ bɔkɛna?” ");
INSERT INTO bov_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ade ke ɛkpa be mbuayɛ kĩ, “Nɔ a kĩ odeĩ tɛtadiɛ tiwo te nviã ni, kɔa amɔa kakpa odi kĩ ɛlá adima. Ade ke nɔ a kĩ odeĩ funitsã ni sɛ̃ foe mɔ bikĩ bidzi kɔlɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tɔgɔlɛ batɛnɛ badi malo ya kĩ ɛwɔla be mui, ade bivia ye kĩ, “Fɔtsa Ɔtsanɛ, litsa kɛnɛ kĩ bɔkɛna?” ");
INSERT INTO bov_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanes bi be kĩ, “Mitatɛ ɔgɔlɛ fɔba fukĩ abãã tsua eyi kĩ mitɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sodzafɔ badi lɛmɛ yavia ye kĩ, “Boe malo litsa kɛnɛ kĩ bɔkɛna?” Yohanes bi be kĩ “Mitakɔa kɔbɛ̃ mitɛ sika nɛ bati awɛ, ade mitatsua odima onukpɛ̃ nɛ lɛtsa a kĩ minyina kĩ ɛtákɛna a akũ. Mifɔ̃ mi kɔtɔkase kuwo mi anɛ.” ");
INSERT INTO bov_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ayekĩ bati anɛ teĩ nɛ boe Ɔtɛnɛ a kaya mɔatsɛ akũ sũ ni, bɛkakɔna kĩ ɔsa Yohanes nyɛ oti a kĩ badzɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Foesũ Yohanes bi be kĩ, “Yĩ kɔ̃ nkɔa mui mawɔla mi mui, lɛmɛ oti odi kĩ ɛbɛ̃ yĩ aya nɛ liti. Ntáfɛta kĩ manyɛ ye mpabua nɛ ye abɔa malo. Oti kĩĩ aakɔa Hũhũ Kpalɛwa mɔ fi ɛwɔla mi mui. ");
INSERT INTO bov_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɛnɛɛ ye kɔvɛla kĩ yaakɔa ɛwɛ ɛnyɛ ye babi wĩ a lɔkɔa efila be eko nɛ oli kamɛ. Lɛmɛ yaapila afafa a nɛ fi kĩ fɔlá kadi a kamɛ!” ");
INSERT INTO bov_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ade Yohanes tsã kɔdɛ tisi futefute pii akũ ede lɛtsã nɛ Kalɛ Wĩ a akũ kĩ bati bɛdani be kadzi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohanes kã abãã ɔnɔkɔɛ̃ Herodes anɛ, kitonɛkĩ ɛtɛ ɔwaɛ̃ ɔtsɔ̃ kĩ bavɛ Herodia ɛkɔã, ade Herodes kɛna fɔtsa kpa bɛbã pii lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ade ebuki ɛkɛna tɔkpa kĩ tɛbɛ̃ kɔlaa kĩ epi Yohanes edo nɛ abãã kɔla kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kĩ Yohanes wɔla bati a flee mui eyua a, ɛwɔla Yesu lɛmɛ mui. Ade lɔkɔ a kĩ Yesu kabɔa mpaɛ a, odetɔ́ kamɛ binya, ");
INSERT INTO bov_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ade Hũhũ Kpalɛwa ka ndɛ mblɔduma aye ɛyadzi nɛ ye akũ a. Awã naa odo odi to ode ɛlɛ kĩ, “Nɔ nyɛ yĩ obi kĩ maátunɔ kalɛ. Kawɔlɛ ade yĩ nɛ nɔ akũ.” ");
INSERT INTO bov_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu tɛ ndɛ futeli taalɛ fɔmɔ eyi ye kanade adzuma kayɔ. Bati kɔna kĩ ɔlɛga nyɛ Yosef. Kĩ ye ɔlɛga nyɛ Eli, ");
INSERT INTO bov_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɔlɛga nyɛ Mata. Mata ɔlɛga nyɛ Levi, Levi ɔlɛga nyɛ Melki. Melki ɔlɛga nyɛ Yanai, Yanai ɔlɛga nyɛ Yosef. ");
INSERT INTO bov_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef ɔlɛga nyɛ Matatia, Matatia ɔlɛga nyɛ Amos. Amos ɔlɛga nyɛ Nahum, Nahum ɔlɛga nyɛ Esli. Esli ɔlɛga nyɛ Nagae, ");
INSERT INTO bov_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae ɔlɛga nyɛ Mahat. Mahat ɔlɛga nyɛ Matatia, Matatia ɔlɛga nyɛ Semei. Semei ɔlɛga nyɛ Yosek, Yosek ɔlɛga nyɛ Yuda. ");
INSERT INTO bov_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda ɔlɛga nyɛ Yohanan, Yohanan ɔlɛga nyɛ Resa. Resa ɔlɛga nyɛ Zerubabel, Zerubabel ɔlɛga nyɛ Sealtiel. Sealtiel ɔlɛga nyɛ Neri, ");
INSERT INTO bov_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ɔlɛga nyɛ Melki. Melki ɔlɛga nyɛ Adi, Adi ɔlɛga nyɛ Kosam. Kosam ɔlɛga nyɛ Elmadam, Elmadam ɔlɛga nyɛ Er. ");
INSERT INTO bov_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ɔlɛga nyɛ Yosua, Yosua ɔlɛga nyɛ Eliezer. Eliezer ɔlɛga nyɛ Yorim, Yorim ɔlɛga nyɛ Matat. Matat ɔlɛga nyɛ Levi, ");
INSERT INTO bov_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ɔlɛga nyɛ Simeon. Simeon ɔlɛga nyɛ Yuda, Yuda ɔlɛga nyɛ Yosef. Yosef ɔlɛga nyɛ Yonam, Yonam ɔlɛga nyɛ Eliakim. ");
INSERT INTO bov_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ɔlɛga nyɛ Melea, Melea ɔlɛga nyɛ Mena. Mena ɔlɛga nyɛ Matata, Matata ɔlɛga nyɛ Natan. Natan ɔlɛga nyɛ Dawid, ");
INSERT INTO bov_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawid ɔlɛga nyɛ Isai. Isai ɔlɛga nyɛ Obed, Obed ɔlɛga nyɛ Boaz. Boaz ɔlɛga nyɛ Salmon, Salmon ɔlɛga nyɛ Nahason. ");
INSERT INTO bov_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason ɔlɛga nyɛ Aminadab, Aminadab ɔlɛga nyɛ Admin. Admin ɔlɛga nyɛ Arni, Arni ɔlɛga nyɛ Ezron. Ezron ɔlɛga nyɛ Perez, Perez ɔlɛga nyɛ Yuda. ");
INSERT INTO bov_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ɔlɛga nyɛ Yakob, Yakob ɔlɛga nyɛ Isak. Isak ɔlɛga nyɛ Abraham, Abraham ɔlɛga nyɛ Tara. Tara ɔlɛga nyɛ Nahor, ");
INSERT INTO bov_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ɔlɛga nyɛ Seruk. Seruk ɔlɛga nyɛ Regu, Regu ɔlɛga nyɛ Pelek. Pelek ɔlɛga nyɛ Eber, Eber ɔlɛga nyɛ Sala. ");
INSERT INTO bov_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ɔlɛga nyɛ Kainan, Kainan ɔlɛga nyɛ Arfaksad. Arfaksad ɔlɛga nyɛ Sem, Sem ɔlɛga nyɛ Noa. Noa ɔlɛga nyɛ Lamek, ");
INSERT INTO bov_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ɔlɛga nyɛ Metusala. Metusala ɔlɛga nyɛ Henok, Henok ɔlɛga nyɛ Yared. Yared ɔlɛga nyɛ Mahaleel, Mahaleel ɔlɛga nyɛ Kainan. ");
INSERT INTO bov_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan ɔlɛga nyɛ Enok, Enok ɔlɛga nyɛ Set. Set ɔlɛga nyɛ Adam, ade Adam ɔlɛga nyɛ Baguma a. ");
INSERT INTO bov_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hũhũ Kpalɛwa a tɛ Yesu kamɛ flee ade ɛdzakũ nɛ Yordan ɔwɔ a abuĩ a. Hũhũ a kpã ye ɛnamɛna kɔsa kamɛ, awã kĩ bati lɛláa. ");
INSERT INTO bov_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ade awã mɔ Abonsam sɔ ye ɛdã fuwi tɛna flee a. Nɛ fuwi a na kamɛ flee a, Yesu tánya lɛtsama foesũ kɔlɛ kakɔ ye mɔ ɔsĩ mɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ade ke Abonsam bi ye kĩ, “Ntɛ Baguma obi anɛ ni, kekɔ̃ bi de kĩĩ lɛdani lɛkɛna abodoo.” ");
INSERT INTO bov_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lɛmɛ Yesu bi ye kĩ, “Oowo! Katsɛlɛ Kpalɛwa a lɛ kĩ nnɛ́ funitsã odi sũ oti adzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ke liti a, Abonsam kpã ye ɛnamɛna kakɔ kadi nɛ ode, ade nɛ sinepo mɔa kabɔa kamɛ ni, ɛnyɛ katinya kamɛ mɔ ke fɔgãtsa a flee ɛtsa Yesu. ");
INSERT INTO bov_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ebi Yesu kĩ, “Maakɔa katinya kamɛ kɔbɛ̃ kĩĩ mɔ ke kɔbɛ̃ mɔ anunyam flee nkpã nɔ, kitonɛkĩ bɛkɔa foe flee bido nɛ yĩ awɛ, ade ke maapuli nkɔa foe nte owula a kĩ mawɛ a. ");
INSERT INTO bov_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Foesũ fɔtsa kĩĩ flee aanya nɔ fude ntɛ ɔkɛna akũ ɔkpa yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu bi ye kĩ, “Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Nɔ Ɔlate Baguma odi kɛnɛ kĩ akɛna nɔ akũ ɔkpa lɔkɔa osum ye lɛmɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ke liti a, Abonsam kpã Yesu ɛnamɛna Yerusalem nɛ Yudafɔ Asɔli Kɔla a ode flee, ade ebi ye kĩ, “Ntɛ Baguma obi anɛ ni, kekɔ̃ vɛnya kaka kanaadza nɛ tite. ");
INSERT INTO bov_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Baguma aakpa ye ode fɔtɔ banyanɛ ɔlɛdo nɛ nɔ akũ, ");
INSERT INTO bov_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kĩ baakaɛ nɔ nɛ be awɛ kamɛ, ayekĩ nɔ abɔa lɛláasãmɔ de.’ ” ");
INSERT INTO bov_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu kpa mbuayɛ kĩ, “Katsɛlɛ Kpalɛwa a lɛmɛ lɛ kĩ, ‘Tasɔ boe Ɔlate nɔ Baguma a ɔdã.’ ” ");
INSERT INTO bov_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kĩ Abonsam yua Yesu kasɔkadã nɛ osi nyɛ osi akũ a, ɛfɔnɛ ye awɛ ɛdzakũ tɔ̃ kɛnaawo lɔkɔ bɛbã kĩ yaana osi. ");
INSERT INTO bov_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hũhũ Kpalɛwa a tɛ Yesu kamɛ ade emuniki ɛnaa Galilea tite akũ a. Ye dĩ gba nɛ kamɛ kamɛ nɛ awã flee. ");
INSERT INTO bov_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɛtsa fɔtsa nɛ Yudafɔ fɔtsɛnakɔ̃ a, ade odi nyɛ odi mu ye fɔtsa katsa a. ");
INSERT INTO bov_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ke liti a, Yesu naa Nazaret awã kĩ bɛdɔla ye a. Nɛ Kawɛya Luwi akũ a, ɛnaa Yudafɔ katsɛnakɔ̃ ndɛ ayekĩ yawɛ kakɛna a. Eyidza ɛdza kĩ yakã Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa, ");
INSERT INTO bov_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ade bɛkɔa Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya ovoli a bɛkpa ye a. Ebinya ovoli a nɛ awã kĩ bɛtsɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Boe Ɔlate Hũhũ a tɛ yĩ kamɛ flee, kitonɛkĩ ɛpau yĩ, kĩ nlɛ Kalɛ Wĩ a ntsa ahiãfɔ. Ade edo yĩ kĩ nde lɛtsã kĩ bikĩ bideĩ nɛ awɔba kamɛ aana be akũ akũ kadzi, kĩ banɛkunɛ aamɔ fɔkɔ, bikĩ bideĩ nɛ ɔhau mɔ lubo kamɔ kamɛ a, aana kawɛya. ");
INSERT INTO bov_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ade nkpa kanyi kĩ lɔkɔ a kĩ Baguma aamɔ ye bati kɔnya a wo ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu sua ovoli a emunikimɔ ye ɛkpa fɔtsa akũ ɔdãmɛnanɛ a, ade ɛkɛna akũ edzi a. Bati a flee ke anɛ nɛ ye akũ, bɛkadã ye kɛnanaana. ");
INSERT INTO bov_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ade ebi be kĩ, “Katsɛlɛ Kpalɛwa fɔlɛtsa a kĩ minu kĩ nkã kĩĩ a, ya nɛ foe kamɛ nviã kĩĩ nɛ mi mɔawɛ anɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bati a flee kĩ bɛna nɛ awã a mu ye paa mɔ ye kɔdzɛla kalɛ, ade ye kɔnyakamɔ fɔlɛtsa a kɛna be saa lɛmɛ a. Ade bivia be akũ kĩ, “Mbɔɛɛ nnɛ́ Yosef obi a nɛ awĩ a?” ");
INSERT INTO bov_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ade Yesu bi be kĩ, “Nti ĩnyina kĩ míabɔa yĩ lɛgbã kĩĩ kĩ, ‘Ɔwanɛ tsa nɔ akũ,’ ade míabi yĩ lɛmɛ kĩ, ‘Fɔtsa a kĩ bunu kĩ ɔkɛna nɛ Kapernaum a ni, kɛna foe odu nɛ nɔ mɔawɛ ɔmatɔ lɛmɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu buki ɛlɛ kĩ, “Lɛmɛ mabi mi kĩ Baguma onukpɛ̃ ɔnyɛnɛ odima látɛ dĩ wĩ nɛ ye mɔawɛ ɔmatɔ. ");
INSERT INTO bov_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Fɔnyɛ ɔnɔkɔali kĩ bakunawa pii na nɛ Israel tite akũ nɛ lɔkɔ a kĩ Eliya dzi nkpã a, kĩ oni fɔ̃ kako futeli ɛlalɛ mɔ sɛkɛ, ade kɔlɛ mɔ ɔsĩ mɔ ɔsĩ ya nɛ tite a na akũ a. ");
INSERT INTO bov_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lɛmɛ Baguma tádo Eliya nɛ Israelfɔ bakunawa a kamɛ odima sɛkɛ̃. Mbom okunawa odi kĩ ɛna nɛ Zarepta ɔmatɔ kĩ edeĩ nɛ Sidon tite akũ a sɛkɛ̃ edo ye. ");
INSERT INTO bov_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bati pii lɛmɛ kasɔ fɔsɔ ngbã nɛ Israel, nɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Elisa lɔkɔ, lɛmɛ bɛtátsa be kamɛ odima, kɛba Naeman kĩ eto Siria tite akũ.” ");
INSERT INTO bov_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kĩ bati a kĩ bɛna nɛ katsɛnakɔ̃ a nu fukĩĩ a bɛna kalɔkpa paa. ");
INSERT INTO bov_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ade ke bɛta biyidza bipi Yesu bɛvɛlɛ, bidu ye bɛnɛmɛna nɛ ɔmatɔ a kamɛ a. Bɛkpã ye bɛnamɛna ɔtɔ a kĩ ye akũ bitsua ɔmatɔ a kalete nɛ kakɔ pɛlɛpɛlɛ a, mɔ kakɔna kĩ badu ye ɛnaatɔ nɛ kayɔ, ");
INSERT INTO bov_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","lɛmɛ Yesu tsã bati a kayite ɛdzakũ. ");
INSERT INTO bov_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ke liti a, Yesu dzakũ ɛnaa Kapernaum ɔmatɔ kamɛ nɛ Galilea tite akũ, ade ɛkatsa bati fɔtsa nɛ Kawɛya Fuwi akũ a. ");
INSERT INTO bov_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ye fɔtsa katsa kɛna bati a saa, kitonɛkĩ kɔbɛ̃ na nɛ ye kɔdzɛla kalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Luwi a, odi kĩ hũhũ kpa na nɛ ye kamɛ na nɛ Yudafɔ katsɛnakɔ̃ a, ade ɛbɔa fɔwɔla kɔɔba ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ao! Yesu Nazaretni, litsa akamɔ boe? Ɔya kĩ ayaawɔla boe mbɔɛɛ? Ĩnyina owula a kĩ ye anɛ. Nɔ nyɛ Baguma Oti Kpalɛwa Kĩ Bido a!” ");
INSERT INTO bov_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Awã naa, Yesu do hũhũ a onukpɛ̃ kĩ, “Tse kɔdzɛla kanɛ nɛ oti a kamɛ!” Hũhũ a bɔɛ oti a emuni nɛ tite nɛ bati a anɛ kamɛ na, ɛnɛ nɛ ye kamɛ, ade lɛtsama tákɛna ye a. ");
INSERT INTO bov_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fɔtsa a kɛna bati a flee wãwã ade bivia be akũ kĩ, “Litsa fɔlɛtsa odu nɛ awĩ a? Oti kĩĩ deĩ otumi mɔ kɔbɛ̃ yawũni nɛ hũhũ kpa akũ ade batse a.” ");
INSERT INTO bov_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesu akũ fɔlɛtsa kĩĩ gba nɛ kayite a na flee. ");
INSERT INTO bov_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu to Yudafɔ katsɛnakɔ̃ a ɛnaa Simon awã. Lɔkɔ a na Simon nyina waa yasɔ atilili mɔ ɔsĩ, foesũ bɛkpa Yesu kanyi kĩ ɛyaadã ye. ");
INSERT INTO bov_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ade ke Yesu nadza nɛ ye mpa ɔwɛ̃, ewũni nɛ fɔsɔ a akũ, ade fɔnɛ nɛ ye kamɛ eyidza mɔatsɛ ɛkɛna fɔdɛtsa ɛkpa be a. ");
INSERT INTO bov_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kĩ fɔkɔ ka a, bati kpã be bakɔba a kĩ basɔ fɔsɔ kumɛkumɛ a bɛma Yesu. Ete awɛ nɛ be kamɛ odi nyɛ odi akũ ɛtsa be flee. ");
INSERT INTO bov_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hũhũ kpa nɛ́ nɛ bati pii kamɛ mɔ fɔwɔla kabɔa kĩ, “Nɔ nyɛ Baguma obi a!” Lɛmɛ Yesu bɔa hũhũ kpa a onukpɛ̃ ade ɛtákpa be osi kĩ bɛlɛ kɔdzɛla kitonɛkĩ binyina kĩ ye nyɛ Kristo a. ");
INSERT INTO bov_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Odenyinawi a, Yesu dzakũ nɛ ɔmatɔ a kamɛ ɛnaa kakɔ dĩĩ kadi, ade bati a do ye kawɛ awɛ a. Kĩ bɛmɔ́ ye a bike ye aduli kĩ ɛtadzakũ nɛ be sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lɛmɛ ebi be kĩ, “Kɛnɛ kĩ nnaalɛ Kalɛ Wĩ a nɛ Baguma lɛgãkanyakɔ̃ akũ a nɛ tɛmatɔ bɛbã lɛmɛ kamɛ, kitonɛkĩ ade foe Baguma do yĩ kĩ ĩyaakɛna a.” ");
INSERT INTO bov_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Foesũ ɛkalɛ Baguma kalɛ a nɛ Yudafɔ fɔtsɛnakɔ̃ a nɛ tite a na akũ flee. ");
INSERT INTO bov_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Luwi a, kĩ Yesu dza nɛ Genezaret ɔwɔ lutubu baũ a abuĩ a, bati kapili kĩ bafuã ye bitse Baguma fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu mɔ́ tɔkɔlɔ nviã nɛ lutubu a abuĩ ade kɔfɔabi banyɛnɛ a nɛ́ bɛlamɛna be tɛsau kavɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu wo nɛ ɔkɔlɔ a kĩ ɛnya Simon ode a kamɛ ebi ye kĩ edu ɔkɔlɔ a ɛnamɛna mui anɛ sukuloo. Ɛkɛna akũ edzi nɛ ye kamɛ ɛtsa bati a fɔtsa. ");
INSERT INTO bov_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kĩ Yesu tsa fɔtsa eyua a, ebi Simon kĩ, “Ta ɔkɔlɔ a kanamɛna awã kĩ kidzũ, lɔkɔa mimɔ nɔ babumɛnanɛ mita mi tɛsau minyɛ kɔfɔabi.” ");
INSERT INTO bov_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ade Simon kpa mbuayɛ kĩ, “Ɔnɔkɔɛ̃, bɔkɛna adzuma mɔ ɔsĩ mɔ ɔsĩ kadzɔ lɛnyɛ flee lɛmɛ bɔtána lɛtsama. Lɛmɛ ntɛ ɔlɛ lɔmɔ ni maafɔ̃ bɔta tɛsau a.” ");
INSERT INTO bov_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kĩ bɛta tɛsau a bɛnyɛ kɔfɔabi beblebee kĩ fɔfɔ̃ be tɛsau a do kakpeli awɛ. ");
INSERT INTO bov_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Foesũ bɛbɔa awɛ bɛvɛ be bakɔba nɛ ɔkɔlɔ ɔyade a kamɛ kĩ bɛyaabumɔ be. Bɛya bɛyanyɛ kɔfɔabi biyula tɔkɔlɔ nviã a tiyi limii kĩ tido kayɛla awɛ. ");
INSERT INTO bov_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kĩ Simon Petro mɔ́ lɛtsa a kĩ lɛya a, eke aduli nɛ Yesu anɛ kamɛ ebi ye kĩ, “Boe Ɔlate, nɛ liti nɛ yĩ ɔwɛ̃, kitonɛkĩ tɔkpa ɔkɛnanɛ manɛ.” ");
INSERT INTO bov_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon mɔ ye bade a kɛna saa nɛ kɔfɔabi beblebee a kĩ bɛnyɛ a sũ. ");
INSERT INTO bov_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ade ayea fɔkɛna ye adzuma bakɔba Yakobo mɔ Yohanes kĩ bɛnyɛ Zebedeo babi a lɛmɛ wãwã a. Ade Yesu bi Simon kĩ, “Tavila. Kito finyaakĩĩ kanaa ni, bati aakanyɛ.” ");
INSERT INTO bov_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ke liti a, bɛta be tɔkɔlɔ bɛnadzɛla nɛ ɔwɔ abuĩ, bɛfɔnɛ lɛtsa nyɛ lɛtsa awɛ biyi ade bitomɔ Yesu nɛ liti a. ");
INSERT INTO bov_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lɔkɔ lidi, Yesu na nɛ ɔmatɔ odi kamɛ awã kĩ onyole odi kĩ ɛkasɔ fɔsɔ ngbã na. Kĩ onyole kĩĩ mɔ́ Yesu a, ɛnatɔ nɛ ye abɔa kamɛ eke ye aduli kĩ, “Boe Ɔlate, ntɛ fɔnyɛ nɔ kawɛ ni, aapuli ɔfɔ̃ fɔsɔ kĩĩ lɛwɔ nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu yo awɛ ɛta ye ade ebi ye kĩ, “Mawɛ lɔmɔ. Nɔ akũ ɛkpalɛ.” Deedimɔapɛ fɔsɔ a wɔ nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ade Yesu si ye mbla ɛlɛ kĩ, “Tabi odima kadima mbom naa tĩĩ kanaakɔa nɔ akũ katsa ɔsɔfɔ, kafɔ̃ ɛsɛla nɔ akũ ɛdã, lɔkɔa edi adansiɛ ɛkpa odi nyɛ odi kĩ nuwĩnuwĩ fɔsɔ a wɔ nɛ nɔ akũ. Kpa afɔlibɔ fɔtsa a kĩ Mose mbla tsa a lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lɛmɛ Yesu akũ fɔlɛtsa gba fɔnaa mɔ lugo, ade bati pii kaya kĩ bayaatse ye fɔtsa katsa, bɛna fɔsɔ katsa lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lɛmɛ fɔkɔ fudi Yesu adzakũ kanaa kakɔ kĩ kɛkɛna dĩĩ kanaabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Luwi a, kĩ Yesu katsa fɔtsa a, Farisifɔ mɔ Yudafɔ mbla batsanɛ a kĩ bito tɛmatɔ kumɛkumɛ nɛ Galilea mɔ Yudea tite akũ, mɔ Yerusalem na nɛ awã. Baguma kɔbɛ̃ a na nɛ Yesu kamɛ kĩ ɛkɔa ɛtsa fɔsɔ. ");
INSERT INTO bov_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ade bati badi lɔ oti odi kĩ eveliveli nɛ ɔkɛna akũ bɛyamɛna a. Bɛbɔa mbɔdi bɛwɛ osi kĩ batsã biwo nɛ kɔla a kamɛ bɛkɔa oti a biyi nɛ Yesu anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lɛmɛ nɛ bati lidede sũ ni, bɛtána osi biwomɔ ye. Foesũ bɛbɔɛ oti a bide nɛ lɛtsã. Ade bitinya fɔkpã bɛnyɛ ɔkɛ bɛkamɛna ɔsɔnɛ a mɔ ye ɔkɛna biyi nɛ Yesu mɔ bati a flee anɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kĩ Yesu mɔ be katɛkado a, ebi onyole a kĩ, “Nwaɛ̃, bɛkɔa nɔ titikpa bite nɔ!” ");
INSERT INTO bov_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ade Farisifɔ mɔ mbla batsanɛ a do akũ kavia awɛ kĩ, “Owei nyɛ oti kĩĩ kĩ yalɛ fubusuotsa nɛ Baguma akũ? Baguma odi keĩ aapuli ɛkɔa titikpa ete!” ");
INSERT INTO bov_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nyi be kakɔna, foesũ evia be kĩ, “Nde sũ miakɔna fɔtsa kĩĩ bamɛ odu? ");
INSERT INTO bov_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fɔɔdabe kalɛ deĩ ɔsĩ fɔbɛ̃, ‘Bɛkɔa nɔ titikpa bite nɔ’ mbɔɛɛ kĩ, ‘Yidza kadza, katsã’? ");
INSERT INTO bov_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lɛmɛ kĩ míamɔ miyi ɔsũ kĩ yĩ a kĩ ĩnyɛ Otidziwa Obi a ndeĩ kɔbɛ̃ kĩ makɔa bati titikpa kate nɛ katinya kĩĩ kamɛ sũ ni, midã o-o!” Kĩ ɛlɛ fukĩĩ eyua a, ɛdani ebi oti a kĩ eveliveli a kĩ, “Mabi nɔ kĩ yidza kabɔɛ nɔ ɔkɛna kanaa kɔla!” ");
INSERT INTO bov_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lɛtalɛta onyole kĩĩ ta eyidza nɛ bati a flee anɛ kamɛ, ɛbɔɛ ye ɔkɛna a kĩ ye akũ ɛwa a, ɛnaa kɔla mɔ Baguma kamu. ");
INSERT INTO bov_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Fukĩĩ kɛna bati a flee wãwã. Akũ nyɛnɛ be flee, ade bimu Baguma, bɛkalɛ kĩ, “Litsa awãwã fɔtsa bɔmɔ́ nviã kĩĩ a!” ");
INSERT INTO bov_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ke liti a, kĩ Yesu anɛ nɛ tɔtɔ a kamɛ a, ɛmɔ́ ɔgɔlɛ ɔtɛnɛ odi kĩ bavɛ Levi edzi nɛ ye adzumamu. Yesu bi ye kĩ, “Tomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi yidza ɛfɔnɛ lɛtsa nyɛ lɛtsa eyi ade etomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Owi tábuna mɔ Levi te opunu kpale ɛkpa Yesu nɛ ye tɔtɔ kamɛ. Tɔgɔlɛ batɛnɛ pii mɔ bati bɛbã lɛmɛ na nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisifɔ mɔ be bakɔba Yudafɔ mbla batsanɛ a badi kɛna hũhũhũhũ bivia Yesu fɔtsa bakɔlɛnɛ a kĩ, “Nde sũ mianya kamɔa mɔ tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ?” ");
INSERT INTO bov_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ade ke Yesu kpa be mbuayɛ kĩ, “Basɔnɛ lisĩ bɛkpa tutsonu ɔkɛnanɛ, nnɛ́ bikĩ bideĩ akũ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ntáya kĩ mayaavɛ bati kĩ bidzi kpĩĩ, mbom ĩya kĩ tɔkpa bakɛnanɛ bɛdani be tɔwɔlɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bati badi bi Yesu kĩ, “Yohanes fɔtsa bakɔlɛnɛ a awɛ onukpɛ̃ kasui mɔatsɛ mɔatsɛ kabɔa mpaɛ ade ayea Farisifɔ bade a lɛmɛ akɛna a. Nde sũ nɔ fɔtsa bakɔlɛnɛ anya, kamɔa?” ");
INSERT INTO bov_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ade Yesu kpa mbuayɛ kĩ, “Miakɔna kĩ bati a kĩ bɛvɛ nɛ obolitsɔ̃ kapikɔ̃ a adzi kɔlɛ nɛ lɔkɔ a kĩ obolitsɔ̃ ɔnyɔ a deĩ nɛ be sɛkɛ̃? Oowo! Fɔlá lɔmɔ! ");
INSERT INTO bov_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lɛmɛ luwi aaya kĩ baakpã obolitsɔ̃ ɔnyɔ a nɛ be sɛkɛ̃. Nɛ lɔkɔ a na kamɛ ni, baasui onukpɛ̃.” ");
INSERT INTO bov_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu buki ɛbɔa be lɛgbã kĩ, “Odima lábɛ̃ lima vɔɛ̃ kakɔa katalɛ lima kɔɛ ɔkɛ. Ntɛ ɛkɛna foe lɔmɔ ni, yaabɛ̃ lima vɔɛ̃ a, lɛmɛ lɔvɔɛ̃ mɔ lɔkɔɛ a lɛláaketimɔ akũ. ");
INSERT INTO bov_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ade ayea baáko waĩ vɔɛ̃ nɛ ɔyaɛ ovoli kuvũ kɔɛ kamɛ a, kitonɛkĩ waĩ vɔɛ̃ a aafɔ̃ kuvũ a lɛbɛ̃ lɔkɔa waĩ a lɛmɛ aawula. ");
INSERT INTO bov_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nɛ foesũ kɛnɛ kĩ biko waĩ vɔɛ̃ nɛ ɔyaɛ ovoli kuvũ vɔɛ̃ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Finyaa, ntɛ odi mɔa waĩ kɔɛ ni, ɛláawɛ kĩ yamɔa bavɔɛ̃. Lɛtsa a kĩ yaalɛ nyɛ kĩ, ‘Waĩ kɔɛ a nɛnɛ ɛbɛ̃.’ ” ");
INSERT INTO bov_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nɛ Kawɛya Luwi mɔa lidi akũ ni, Yesu mɔ ye fɔtsa bakɔlɛnɛ tsã fugbanɔ kɔba kudi kayite batɛ̃. Ye fɔtsa bakɔlɛnɛ a ve fudi bɛtsɛ̃ foe bɛkaba. ");
INSERT INTO bov_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ade ke Farisifɔ a badi via be kĩ, “Nde sũ miakɛna lɛtsa a kĩ boe mbla tákpa osi kĩ bɛkɛna nɛ Kawɛya Luwi akũ?” ");
INSERT INTO bov_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kpa mbuayɛ kĩ, “Mitákã nɛ Katsɛlɛ Kpalɛwa a kamɛ, mimɔ́ lɛtsa a kĩ Lɛgã Dawid kɛna nɛ lɔkɔ a kĩ kɔlɛ kakɔ bɛmɔ ye bade a? ");
INSERT INTO bov_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lɛgã Dawid nawo nɛ Baguma kɔla kamɛ ɛbɔɛ abodoo a kĩ bɛkɔa bɛbɔa afɔliɛ bɛkpa Baguma a ɛnya, ade ɛkɔa adi ɛkpa ye bakɔba a lɛmɛ bɛnya a. Fɔnyɛ boe mbla kĩ odima lɛlá osi kĩ yanya foe, mbɔɛntɛ basɔfɔ odi keĩ.” ");
INSERT INTO bov_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu wũna kĩ, “Otidziwa Obi a nyɛ Kawɛya Luwi a Ɔlate.” ");
INSERT INTO bov_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nɛ Kawɛya Luwi bɛbã akũ ni, Yesu naa Yudafɔ katsɛnakɔ̃ a ɛnaatsa fɔtsa. Onyole odi kĩ ye kɔkpɔ ku na nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yudafɔ mbla batsanɛ mɔ Farisifɔ badi kawɛ osi a kĩ ye akũ baatsã bɛwɛ fɔlɛtsa bite nɛ Yesu akũ. Foesũ biko anɛ bɛdã flee ntɛ yaatsa fɔsɔ nɛ Kawɛya Luwi akũ. ");
INSERT INTO bov_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lɛmɛ Yesu nyi be kakɔna ade ebi onyole a kĩ, “Yidza kayaadza nɛ bati anɛ kamɛ nɛ awĩ.” Onyole a nɛ ɛyadza nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ade Yesu bi be kĩ, “Mavia mi ntse ni, litsa boe mbla kpa osi kĩ bɛkɛna nɛ Kawɛya Luwi akũ? Fɔnɛnɛ kĩ bɛkɛna tuwĩ nɛ Kawɛya Luwi akũ, mbɔɛɛ kĩ bɛkɛna tɔkpa? Fɔnyɛ luwi kĩ de akũ bɛtɛ oti nkpã, mbɔɛɛ kĩ bɛfɔnɛ ye awɛ eku?” ");
INSERT INTO bov_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu dã be flee ɛtɛ̃mɛna ade ebi onyole a kĩ, “Yo awɛ.” Eyo awɛ ade ye awɛ a lɛ pɛpɛɛpɛ a. ");
INSERT INTO bov_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yudafɔ mɔ mbla batsanɛ a na kalɔkpa mɔ ɔsĩ mɔ ɔsĩ ade bɛkapi adzuni nɛ lɛtsa a kĩ baakɛna ye akũ a. ");
INSERT INTO bov_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Luwi a Yesu de ɛnaa ɔtɔ akũ kĩ yanaabɔa mpaɛ, ade ɛbɔa mpaɛ lɛnyɛ flee ɛkpa Baguma a. ");
INSERT INTO bov_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kĩ kade nyina a, ɛvɛ ye fɔtsa bakɔlɛnɛ a flee ɛkpɔta ade ɛnyɛ be kamɛ bati ewua-nviã ɛvɛ be kĩ fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ade be nyɛ Simon kĩ ete dĩ kĩ Petro mɔ ɔwaɛ̃ Andrea, Yakobo mɔ Yohanes, Filipo mɔ Bartolomeo. ");
INSERT INTO bov_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Babɛbã nyɛ Mateo mɔ Toma, Yakobo kĩ ɛnyɛ Alfeo obi mɔ Simon a kĩ epili ye kade lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Be nkaɛ nyɛ Yuda kĩ ɛnyɛ Yakobo obi mɔ Yuda Iskariot kĩ ye lɛyatsa Yesu liti osi. ");
INSERT INTO bov_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kĩ Yesu mɔ ye fɔtɔ banyanɛ a ka bito ɔtɔ akũ a, bɛyadza nɛ kakɔ tɛɛwa kĩ ye fɔtsa bakɔlɛnɛ pii mɔ bati kɔdabu baũ kudi na. Bati pii to Yudea tite akũ, Yerusalem ɔmatɔ mɔ tɛmatɔ a kĩ tɛwaa nɛ Tiro mɔ Sidon mpo abuĩ a kamɛ bɛya. ");
INSERT INTO bov_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɛya kĩ bayaatse Yesu fɔtsa katsa bɛna fɔsɔ ahɔlɔ ahɔlɔ katsa. Bikĩ hũhũ kpa kaha be a lɛmɛ ya ade ɛtsa be a. ");
INSERT INTO bov_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bati a flee kabɔa mbɔdi kĩ bata Yesu kitonɛkĩ kɔbɛ̃ kudi kanɛ kato ye kamɛ katsa be flee. ");
INSERT INTO bov_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu dzɛla anɛ ɛdã ye fɔtsa bakɔlɛnɛ a ade ebi be kĩ, “Baguma aahila mi a kĩ minyɛ ahiãfɔ a, kitonɛkĩ mi kade nyɛ Baguma lɛgãkanyakɔ̃ a ");
INSERT INTO bov_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Baguma aahila mi a kĩ kɔlɛ akɔ mi finyaakĩĩ a, kitonɛkĩ míawĩ! Baguma aahila mi a kĩ miabe finyaa a, kitonɛkĩ miaya kamɛmɛ kɔ̃! ");
INSERT INTO bov_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Baguma aahila mi ntɛ bati akesĩ mi, bisĩ mi, bavũna mi, ĩye balɛ kĩ minyɛ bati kpa nɛ Otidziwa Obi a sũ! ");
INSERT INTO bov_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Mimɔ kawɔlɛ, ntɛ fɔya lɔmɔ a, mito, mimɔ kawɔlɛ kitonɛkĩ mideĩ kɔtɔkase kpale nɛ ode. Mite anɛ lɛmɛ kĩ ade fukĩĩ odu be bawanyɔ kɛna Baguma onukpɛ̃ banyɛnɛ kɔɛ a. ");
INSERT INTO bov_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lɛmɛ bɔbɔɛ makpa mi a kĩ mideĩ akũ a, kitonɛkĩ mimɔ́ mi kawɔlɛ kɔkɔɛ nɛ awĩ! ");
INSERT INTO bov_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bɔbɔɛ makpa mi a kĩ miwĩ finyaakĩĩ a, kitonɛkĩ kɔlɛ aakɔ mi! Bɔbɔɛ makpa mi a kĩ miamɛmɛ finyaakĩĩ a, kitonɛkĩ míawo ɔblɔ, mibe. ");
INSERT INTO bov_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bɔbɔɛ makpa mi ntɛ bati flee abɔa mi buĩ wĩ, kitonɛkĩ ade aye be bawanyɔ mu fɔvã onukpɛ̃ banyɛnɛ a. ");
INSERT INTO bov_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lɛmɛ mabi mi a kĩ miatse yĩ kalɛ a kĩ miwɛ mi bakesĩnɛ kalɛ, mikɛna tuwĩ mikpa be. ");
INSERT INTO bov_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mikpa bikĩ badumu mi a nhila. Mibɔa mpaɛ mikpa bikĩ bakɛna mi tɛnya a. ");
INSERT INTO bov_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ntɛ odi balɛ nɔ awɛ nɛ ɔlɔtɔ mɔa ni, fɔ̃ ɛbalɛ nɔ nɛ ɔyade a lɛmɛ. Ntɛ odi tɛ nɔ atadiɛ wulaa ni kɔa nɔ atadiɛ anyanglede a lɛmɛ kakpa ye. ");
INSERT INTO bov_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Odi nyɛ odi kĩ yaawã nɔ fɔtsa ni, kpa ye, ade ntɛ odi bɔɛ nɔ litsedi ni, tabuki ɔlɛ kĩ atɛ foe. ");
INSERT INTO bov_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lɛtsa a kĩ miawɛ kĩ bati bɛbã bɛkɛna bɛkpa mi ni, mikɛna foe lɔmɔ mikpa be. ");
INSERT INTO bov_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ntɛ miawɛ bati a kĩ bawɛ mi kalɛ odi ni, nde sũ kɛnɛ kĩ bihila mi? Tɔkpa bakɛnanɛ malo awɛ bikĩ bawɛ be kalɛ a. ");
INSERT INTO bov_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ade ntɛ bati a kĩ bakɛna mi sɛmɛ kalɛ odi mɔ miakɛna sɛmɛ kalɛ kakpa a ni, nde sũ kɛnɛ kĩ bihila mi? Tɔkpa bakɛnanɛ malo akɛna lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ade ntɛ bikĩ baapuli bise mi kɔtɔ odi mɔ miakpa tɛvɛ ni, nde sũ kɛnɛ kĩ bihila mi? Tɔkpa bakɛnanɛ malo akpa be akũ tɛvɛ, nɛ ayekĩ baase foe flee bɛkpa be sũ! ");
INSERT INTO bov_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Oowo! Miwɛ mi bakesĩnɛ kalɛ mikɛna be tuwĩ. Mikpa be tɛvɛ lɛmɛ mitate anɛ kĩ baase bɛkpa mi. Ntɛ mikɛna foe lɔmɔ ni, míana kɔtɔkase kpale lɔkɔa míanya Baguma Kpale Nɛ Ode a babi. Kitonɛkĩ Baguma deĩ sɛmɛ kalɛ ɛkpa bikĩ baáyi bati ayɛ mɔ bati kpa malo. ");
INSERT INTO bov_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mimɔ bati kɔnya ndɛ ayekĩ Baguma amɔ kɔnya. ");
INSERT INTO bov_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mitadzɛmɔ bati bɛbã ayekĩ Baguma lɛmɛ lɛláadzɛmɔ mi. Mitakɔ bati bɛbã kɔtɔ lɔkɔa Baguma lɛmɛ lɛláakɔ mi kɔtɔ. Mikɔa bati tɔkpa mite be, lɔkɔa Baguma lɛmɛ aakɔa ete mi. ");
INSERT INTO bov_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mikpa bati fɔtsa lɔkɔa Baguma lɛmɛ aakpa mi. Nuwĩnuwĩ Baguma aakɔna, edo ɛmɛnana fuyi tsɔnɔnɔɔnɔ fuwula nɛ ye sɛmɛ kalɛ onukpɛ̃. Fɔtsa kakɔna odu a kĩ mikɔa mikɔna mikpa bati bɛbã a, ade foe odu Baguma lɛmɛ aakɔa ɛkɔna ɛkpa mi a.” ");
INSERT INTO bov_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ade Yesu bɔa be lɛgbã kĩ, “Ɔnɛkunɛ lɛláapuli ɛkpã ɔkɔba ɔnɛkunɛ. Ntɛ ɛkɛna foe ni be nviã a flee baatɔ lɛkɛ. ");
INSERT INTO bov_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Fɔtsa ɔkɔlɛnɛ lɛbɛ́ ye fɔtsa ɔtsanɛ, lɛmɛ ntɛ ɛkɔlɛ fɔtsa eyua ni, yaana ndɛ ye fɔtsa ɔtsanɛ aye. ");
INSERT INTO bov_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nde sũ adã sukuluku kĩ sideĩ nɛ awaɛ̃ linebi kamɛ lɛmɛ ɔtsɛ́la luvokũ a kĩ lideĩ nɛ nɔ mɔawɛ linebi kamɛ a? ");
INSERT INTO bov_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nde aapuli obi awaɛ̃ kĩ, ‘Make nɔ aduli, fɔ̃ ĩnyɛ sukuluku nɛ nɔ linebi kamɛ’ nɛ lɔkɔ a kĩ luvokũ deĩ nɛ nɔ mɔawɛ linebi kamɛ a? Anɛ kamɛ kɛkɛ fɔtsa ɔkɛnanɛ anɛ! Nya lɔtɔ kanyɛ luvokũ a nɛ nɔ linebi kamɛ lɔkɔa aapuli ɔmɔ́ yededeede ɔnyɛ sukuluku nɛ awaɛ̃ linebi kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kutse wĩ láwũ babi kpa, ade kutse kĩ kɔnɛ́nɛ lɛmɛ láwũ babi wĩ a. ");
INSERT INTO bov_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Babi a kĩ kutse nyɛ kutse awũ a bakɔa kamɔ koe kayi ɔsũ. Baána figi babi nɛ fu kutse kamɛ ade baána akutu nɛ ɔgɔabi akũ a. ");
INSERT INTO bov_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Oti wĩ anyɛ fɔtsa wĩ a kĩ fudeĩ nɛ ye ɔwɔlɛ kamɛ a kanya, ade aye oti kpa lɛmɛ anyɛ fɔtsa kpa a kĩ fudeĩ nɛ ye ɔwɔlɛ kamɛ a kanya a. Kitonɛkĩ lɛtsa a kĩ lideĩ nɛ oti ɔwɔlɛ kamɛ a, ade de anɛ nɛ ye onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nde sũ miavɛ yĩ kĩ, ‘Boe Ɔlate, boe Ɔlate’ lɛmɛ miákɛna nɛ fɔtsa a kĩ matsa mi a akũ? ");
INSERT INTO bov_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Odi nyɛ odi kĩ yaya nɛ yĩ sɛkɛ̃ katse yĩ fɔlɛtsa, kakɛna nɛ foe akũ ni, maatsa mi oti a odu kĩ yanɛ. ");
INSERT INTO bov_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɛla ndɛ oti kĩ ntɛ eyi kɔla kake kayɔ etu ɔkã dzununuunu eke litekũ lɛyɔde nɛ boe akũ. Ntɛ ɔwɔ yili mɔ mui yalɔmɔ kɔla a ni, lɛtsama lɛláakɛna kɔla a, kitonɛkĩ bike koe kake wĩ. ");
INSERT INTO bov_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lɛmɛ odi nyɛ odi kĩ yaátse yĩ fɔlɛtsa, ade yaákɛna nɛ foe akũ lɛmɛ ni, ɛla ndɛ oti kĩ eke kɔla kĩ koe kayɔ litekũ a lɛla ɔsĩ. Ntɛ ɔwɔ yili ɛyalɔmɔ kɔla a na ni, kɔ́aveli kɔtɔ gbloo!” ");
INSERT INTO bov_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kĩ Yesu bi bati fɔlɛtsa kĩĩ flee eyua a, ɛdzakũ ɛnaa Kapernaum. ");
INSERT INTO bov_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Awã naa, Romafɔ sodzafɔ ɔnɔkɔɛ̃ odi nɛ awã na ɔsumunɛ kĩ yaátunɔ kalɛ. Ɔsumunɛ kĩĩ kasɔ mɔ ɔsĩ mɔ ɔsĩ kĩ ewo wuda onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kĩ ɔnɔkɔɛ̃ kĩĩ nu Yesu nkã a, edo Yudafɔ banɔkɔɛ̃ badi kĩ bɛnaabi ye ɛyaatsa ye ɔsumunɛ a. ");
INSERT INTO bov_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bɛya nɛ Yesu sɛkɛ̃ ade bike ye aduli mɔ ɔsĩ mɔ ɔsĩ kĩ, “Oti kĩĩ fɛta ɛkpa nɔ kabumɛna paa, ");
INSERT INTO bov_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kitonɛkĩ yawɛ boe kade bati kalɛ, ade ye like boe katsɛnakɔ̃ a ɛkpa boe a.” ");
INSERT INTO bov_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɛ foe sũ Yesu tomɔ be ɛnaa. Ki kite sukuloo kĩ Yesu awo nɛ ɔnɔkɔɛ̃ a tɔtɔ kamɛ a, ɔnɔkɔɛ̃ a do ye bakɔba kĩ bibi Yesu kĩ, “Boe Ɔlate, tabuki ɔha nɔ akũ. Ntákpɔla nkpa kĩ awo nɛ yĩ tɔtɔ kamɛ, ");
INSERT INTO bov_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ade ke ntákpɔla lɛmɛ kĩ maya nɛ nɔ sɛkɛ̃ a. Foesũ lɛ kalɛ mɔapɛ lɔkɔa yĩ ɔsumunɛ a aasaɛ. ");
INSERT INTO bov_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yĩ malo ĩnyɛ oti kĩ ndeĩ nɛ banɔkɔɛ̃ kĩ bɛbɛ̃ yĩ lɔnɔkɔɛ̃ kayɔ, ade ndeĩ sodzafɔ nɛ yĩ kayɔ a. Ntɛ mbi odi kĩ, ‘Naa ni’ yanaa, ntɛ mbi ɔbɛbã kĩ, ‘Ya ni’ yaya, ade ntɛ mbi yĩ ɔsate lɛmɛ kĩ ‘Kɛna fukĩĩ ni’ yakɛna foe.” ");
INSERT INTO bov_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kĩ Yesu nu fukĩĩ a fɔkɛna ye saa. Ɛdani ebi bati kɔdabu a kĩ bitomɔ ye a kĩ, “Mabi mi kĩ ntámɔ tɔ̃ katɛkado kĩĩ odu nɛ Israelfɔ malo kamɛ da!” ");
INSERT INTO bov_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Batɔ a kĩ ɔnɔkɔɛ̃ a do a muniki bɛnaa tɔtɔ a kamɛ, ade bɛnamɔ kĩ ɔsumunɛ a saɛ a. ");
INSERT INTO bov_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ke liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a mɔ bati pii naa Nain ɔmatɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kĩ ewo nɛ ɔmatɔ a koletia a, ɛtsɛlamɔ bati kɔdza kĩ bɛnɔnɛ ɔnɔkpa banaabila. Ɔnɔkpa a nyɛ otsole odi kĩ ɛnyɛ okunawa obinyole mɔapɛ, ade ke ɔmatɔ a kamɛ bati pii lɛmɛ tomɔ okunawa a. ");
INSERT INTO bov_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kĩ boe Ɔlate mɔ́ otsole a, ye fɔlɛtsa kɔ ye kɔnya ade ke ebi ye kĩ, “Fɔ̃ kabe.” ");
INSERT INTO bov_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Awã naa Yesu fuã ɛnata ɔnɔkpa apaka a ade bikĩ bɛnɔnɛ ye a fɔ̃ bɛdza a. Ade Yesu lɛ kĩ, “Opopo! Mabi nɔ kĩ yidza!” ");
INSERT INTO bov_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɔnɔkpa a yidza edzi edo kɔdzɛla kalɛ awɛ, ade Yesu kɔa ye edo nɛ ɔma awɛ a. ");
INSERT INTO bov_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Libe wo bati a flee ade bimu Baguma bɛlɛ kĩ, “Baguma Onukpɛ̃ Ɔnyɛnɛ kpale odi nɛ́ ɛta nɛ boe kamɛ! Baguma ka ɛya kĩ yayaanyɛ ye bati!” ");
INSERT INTO bov_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu akũ fɔlɛtsa kĩĩ gba nɛ Yudea tite mɔ fɔkɔ a kĩ fufuã a flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kĩ Yohanes fɔtsa bakɔlɛnɛ a bi ye fɔtsa kĩ Yesu lamɛna kakɛna flee a, ɛvɛ be kamɛ bati nviã, ");
INSERT INTO bov_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ade edo be nɛ boe Ɔlate sɛkɛ̃ kĩ bɛnaavia ye kĩ, “Nɔ nyɛ oti a kĩ bɛlɛ kĩ yaaya a, mbɔɛɛ kĩ bɔdã oti bɛbã anɛ?” ");
INSERT INTO bov_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kĩ biwo Yesu sɛkɛ̃ a bibi ye kĩ, “Yohanes Mui Ɔwɔlanɛ a do boe kĩ bɔyaavia nɔ kĩ, ‘Nɔ nyɛ oti a kĩ bɛlɛ kĩ yaaya mbɔɛɛ kĩ bɔdã oti bɛbã anɛ?’ ” ");
INSERT INTO bov_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nɛ lɔkɔ a na kamɛ pɛpɛɛpɛ a, Yesu tsa bati beblebee fɔsɔ, ɛblɔmɛna hũhũ kpa etomɛna bati kamɛ ade ɛfɔ̃ banɛkunɛ pii lɛmɛ mɔ́ fɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ade ɛkpa Yohanes batɔ a mbuayɛ kĩ, “Mimuniki minaabi Yohanes lɛtsa a kĩ mimɔ́ mɔ lɛtsa a kĩ minu a, banɛkunɛ mɔ́ fɔkɔ, bikĩ biveliveli yidza bɛtsɛ̃, bikĩ basɔ fɔsɔ ngbã akũ kpalɛ, batɔsĩnɛ anu fɔkɔ, bɛdzɛla banɔkpa bidzi nkpã, ade bɛlamɛna ahiãfɔ Kalɛ Wĩ a kabi a. ");
INSERT INTO bov_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baguma hila oti a kĩ ɛtamɔ́ nfumusu adima nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kĩ Yohanes batɔ a dzakũ a, Yesu yi kayɔ mɔ kɔdzɛla kalɛ nɛ Yohanes akũ kabi bati kɔdabu a kĩ, “Kĩ minaa Yohanes sɛkɛ̃ nɛ kɔsa kamɛ a, litsa mikɔna kĩ míamɔ? Mimɔ́ ye ndɛ kɔkaɛ sɔɔta kĩ ɔwɛ abɔa katomɛna katɛ̃mɛna? ");
INSERT INTO bov_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Litsa koũ minɛ minaadã? Oti kĩ ɛkɛɛlɛ ye akũ mɔ fɔtsa mɔ kalɛ yanɛ? Bikĩ bɛkɛɛlɛ be akũ mɔ fɔtsa mɔkalɛ bidzi nɛ ɔmɛnɛ kamɛ ni, fɔgã tɔtɔ kamɛ bamɔ be. ");
INSERT INTO bov_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mibi yĩ lɛtsa a koũ sũ miti mina a? Kĩ míamɔ Baguma onukpɛ̃ ɔnyɛnɛ mbɔɛɛ? Mifɔ̃ nti mbi mi kĩ mimɔ́ oti kĩ ɛbɛ̃ Baguma onukpɛ̃ ɔnyɛnɛ kɔlaa. ");
INSERT INTO bov_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ade Yohanes akũ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Maado yĩ fɔtɔ ɔnyanɛ ɛnya nɔ lɔtɔ, ɛyaalɔla osi eyi ɛkpa nɔ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu buki ebi be kĩ, “Yohanes bɛ̃ odi nyɛ odi kĩ edzi tɔ̃ nɛ katinya kĩĩ kamɛ. Lɛmɛ odi kĩ ɛnyɛ obisɛ̃ kɔlaa nɛ Baguma lɛgãkanyakɔ̃ a kamɛ bɛ̃ Yohanes.” ");
INSERT INTO bov_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Fɔmɔ fukĩĩ aayanɛ a, bati a flee nu Yohanes fɔlɛtsa a, bɛmɔ tɔgɔlɛ batɛnɛ a titiliwu nyɛ bikĩ bɛkɛna nɛ Baguma kawɛ akũ, ade bɛfɔ̃ Yohanes kɛna be mui kawɔla amaniɛ a. ");
INSERT INTO bov_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lɛmɛ Farisifɔ mɔ Yudafɔ mbla batsanɛ a sĩ Baguma nhihiɛ a kĩ ɛkɛna eyi ɛkpa be a, ade bɛtátunɔ kĩ Yohanes ɛwɔla be mui a. ");
INSERT INTO bov_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu lɛ ɛnamɛna lɔtɔ kĩ, “Finyaakĩĩ litsa maakɔa nviã babi nkɔna mɔ? ");
INSERT INTO bov_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɛla ndɛ babisɛ̃ kĩ bikoni nɛ kɔya bagulo. Babɔa fɔwɔla kabi bakɔba kĩ, ‘Bɔsã obolitsɔ̃ kapi tɔnɔ bɔkpa mi, lɛmɛ mitáto! Bɔsã tukutɔnɔ bɔkpa mi, lɛmɛ mitábe.’ ");
INSERT INTO bov_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohanes Mui Ɔwɔlanɛ a ya, ɛkasui onukpɛ̃, ɛtámɔa waĩ, lɛmɛ milɛ kĩ, ‘Hũhũ kpa deĩ nɛ ye kamɛ!’ ");
INSERT INTO bov_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Otidziwa Obi a lɛmɛ ya, ɛnya, ɛmɔa lɛmɛ, ade mialɛ kĩ, ‘Midã ɔnyakpanɛ mɔ bavɛ ɔmɔanɛ kĩĩ! Ɛnyɛ tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ ɔkɔba!’ ");
INSERT INTO bov_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lɛmɛ bati flee a kĩ bɛtɛ Baguma kadikanyi ni, be fɔkɛlatsa atsa kĩ fɔnyɛ ɔnɔkɔali fɔlɛtsa.” ");
INSERT INTO bov_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisini odi vɛ Yesu kĩ ɛyaanya nɛ ye awã. Yesu tunɔ ɛnaa ɛnadzi bɛkanya. ");
INSERT INTO bov_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Otsole odi kĩ ɛtábɔa ɔbla wĩ na nɛ ɔmatɔ a kamɛ. Kĩ enu kĩ Yesu na nɛ Farisini a tɔtɔ kamɛ ɛkanya a, ɛbɔɛ tumpã mɔkalɛ mɔ kugua mɔ ɔlɛ̃ mɔlɛ̃ ɛyamɛna nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ɛdza nɛ Yesu liti nɛ ye abɔa ɔwɛ̃ ade ɛkabe kako nɛ ye fɔnɛta akũ a. Otsole kĩĩ kɔa ye lɔlɔ tɔlɔ ɛyɔ babe a nɛ Yesu fɔnɛta, ade efifi foe akũ, ɛkɔa kugua a lɛmɛ eko nɛ foe akũ a. ");
INSERT INTO bov_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kĩ Farisini a mɔ fukĩĩ a, ɛlɛ nɛ ye lɔlɔ kamɛ kĩ, “Ntɛ obi kĩĩ mɔ nuwĩ Baguma onukpɛ̃ ɔnyɛnɛ yanɛ ni, kufɛ yaanyi kĩ otsole a odu kĩ ɛlamɛna ye katalɛ a nyɛ titikpa ɔkɛnanɛ!” ");
INSERT INTO bov_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ade Yesu bi Farisini a kĩ, “Simon, ndeĩ kalɛ kĩ mabi nɔ.” Simon kpa mbuayɛ kĩ, “Fɔtsa Ɔtsanɛ, bi yĩ lɛtsa a.” ");
INSERT INTO bov_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ade Yesu bi ye kĩ, “Banyole nviã badi dzimɔ sika ɔvɛ ɔkpanɛ odi kɔtɔ. Ɔmɔa dzimɔ ye sika kĩ siwo tidetɔ ewua kɔtɔkase, ade ɔyade a lɛmɛ dzimɔ ye odetɔ mɔa kɔtɔkase a. ");
INSERT INTO bov_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bati kĩĩ tápuli bise ye fɔtɔ kĩĩ, foesũ ɛkɔa ete be. Bati nviã kĩĩ kamɛ ɔwɔdabe aawɛ sika ɔvɛ ɔkpanɛ a kalɛ ɛba?” ");
INSERT INTO bov_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ade Simon kpa mbuayɛ kĩ, “Matɛ kado kĩ oti a kĩ bɛkɔa kɔtɔ kpale bite ye a.” Yesu bi ye kĩ, “Ɔlɛ ɔnɔkɔali.” ");
INSERT INTO bov_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ade Yesu dani ɛdã otsole a ebi Simon kĩ, “Amɔ otsole kĩĩ? Kĩ nwo nɛ nɔ tɔtɔ kamɛ a, ɔtákpa yĩ mui kĩ nvɔlɛ fɔnɛta, lɛmɛ otsole kĩĩ kɔa ye babe ɛvɔlɛ yĩ fɔnɛta, ɛkɔa ye tɔlɔ lɛmɛ ɛyɔ be. ");
INSERT INTO bov_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔtákɛna yĩ atuu, lɛmɛ kito lɔkɔ a kĩ ĩya nɛ awĩ a, otsole kĩĩ táfɔ̃ yĩ fɔnɛta kafifi. ");
INSERT INTO bov_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɔtákpa yĩ kugua ntsɛla nɛ lɔlɔ kamɛ, lɛmɛ ɛkɔa kugua mɔ ɔlɛ̃ mɔ ɔlɛ̃ ɛtsɛla yĩ fɔnɛta. ");
INSERT INTO bov_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Foesũ mabi nɔ kĩ nɛ ɔdɔ a kĩ ɛnyɛ ɛtsa kĩĩ a sũ ni, bɛkɔa ye titikpa beblebee a bite ye. Lɛmɛ oti kĩ bɛkɔa fɔtsa kabii bite ni, ɔdɔ kabii yanyɛ katsa.” ");
INSERT INTO bov_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu bi otsole a kĩ, “Bɛkɔa nɔ titikpa bite nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bati a kĩ bɛna nɛ kanyakɔ̃ a kavia be akũ kĩ, “Owei nɛ awĩ a kĩ yakɔa bati tɔkpa malo kate?” ");
INSERT INTO bov_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ade Yesu bi otsole a kĩ, “Nɔ katɛkado tɛ nɔ. Naa nɛ lukudɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nɛ fukĩĩ liti a, Yesu tsã emini nɛ tɛmatɔ mɔ tukula a kĩ tifuã a kamɛ ɛkalɛ Kalɛ Wĩ a nɛ Baguma lɛgãkanyakɔ̃ a akũ. Ye fɔtsa bakɔlɛnɛ ewua-nviã a lɛmɛ tomɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Batsole badi kĩ Yesu blɔmɛna hũhũ kpa nɛ be kamɛ, mɔ bikĩ ɛtsa be fɔsɔ lɛmɛ tomɔ ye. Be kamɛ ɔmɔa nyɛ Maria Magdalani kĩ ye kamɛ ɛblɔmɛna hũhũ kpa evũkɔnɔ etomɛna a. ");
INSERT INTO bov_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Otsole a odi lɛmɛ nyɛ Yohana, kĩ bavɛ ɔnyɔ kĩ Kusa kĩ ɛnya ɔnɔkɔɛ̃ nɛ Lɛgã Herodes fɔlɛtsa kadzɛkɔ̃, Susana mɔ batsole bɛbã pii kĩ bɛkɔa be mɔawɛ akũ fɔtsa bɛkadãmɛna Yesu mɔ ye fɔtsa bakɔlɛnɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bati kato tɛmatɔ pii kamɛ kaya nɛ Yesu sɛkɛ̃, ade kĩ bati beblebee yakpɔta a, ɛbɔa be lɛgbã kĩĩ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Luwi a okuani odi naasã funitsã babi. Kĩ ɛkasã be a badi wula nɛ osi ɔɔwɛ̃ ade ke bati sumini be, kɔvɔlabi lɛmɛ tsuli be a. ");
INSERT INTO bov_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Badi wula nɛ apibɔ akũ, ade kĩ bɛmɛ a bɛvɛ biku, kitonɛkĩ apibɔ a kamɛ lɛla mui. ");
INSERT INTO bov_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Badi wula nɛ tuwĩ mɔ fu kamɛ. Tuwĩ mɔ fu a mɛ tipi be. ");
INSERT INTO bov_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Badi lɛmɛ wula nɛ tite wĩ akũ, bɛmɛ bibo anɛ, kutse nyɛ kutse wũ babi kpasaa.” Ade Yesu wũna kĩ, “Oti kĩ edeĩ atɔ ni, etse katse wĩ!” ");
INSERT INTO bov_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu fɔtsa bakɔlɛnɛ a via ye lɛgbã a kayɔ. ");
INSERT INTO bov_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ade ebi be kĩ, “Bɛnyɛ Baguma lɛgãkanyakɔ̃ fɔtsa kɔlawa a bɛtsa mi, lɛmɛ bati bɛbã a kɔ̃ ni, fɔgbã kamɛ fɔaya kakpa be ayekĩ, ‘Baadã lɛmɛ bɛláamɔ biyi ɔsũ, baanu lɛmɛ bɛláa nu foe kayɔ.’ ");
INSERT INTO bov_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Lɛgbã a kayɔ nyɛ fukĩĩ. Funitsã babi a nyɛ Baguma kalɛ a. ");
INSERT INTO bov_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Babi a kĩ biwula nɛ osi ɔɔwɛ̃ nyɛ bati a kĩ binu kalɛ a, lɛmɛ Abonsam yanyɛ kalɛ a nɛ be tɔwɔlɛ kamɛ, ayekĩ bɛláatɛ bido bɛna katɛ ");
INSERT INTO bov_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bikĩ biwula nɛ apibɔ akũ a nyɛ bati a kĩ binu kalɛ a, bɛtɛ ke mɔ kawɔlɛ, lɛmɛ kɛtáwo nɛ be kamɛ dzununuunu. Bɛtɛ bido nɛ lɔkɔ lukũ odi kamɛ, ade ntɛ sɔhuiɛ adi ya ni, bamuniki liti. ");
INSERT INTO bov_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Babi a kĩ biwula nɛ tuwĩ mɔ fu kamɛ a nyɛ bati a kĩ binu kalɛ a bɛtɛ ke lɛmɛ katinya kamɛ ɔhau, akũ fɔtsa kawɛ mɔ katinya kamɛ kawɔlɛkamɔ anya be akũ, kafɔ̃ baábo anɛ kawũ babi kayɔɔlɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lɛmɛ babi a kĩ biwula nɛ tite wĩ akũ a nyɛ bati a kĩ binu kalɛ a, bɛtɛ ke nɛ tɔwɔlɛ wĩ mɔ obu kamɛ ade bipini ke mɔ ɔsĩ mɔ ɔsĩ kɛnawo kĩ biwũ babi a. ");
INSERT INTO bov_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Odima látɛna ɔsɛdza kakɔa lɔɔda kasua ye, ĩye kakɔa ye kado nɛ mpa kayɔ. Mbom yadɛla ye kate nɛ ɔsɛdza otse akũ ayekĩ bati aamɔ fɔkɔ ntɛ bawo nɛ tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Lɛtsa nyɛ lɛtsa kĩ bɛkɔa bɛkɔla ni, baanyɛ de kanya. Ade lɛtsa nyɛ lɛtsa kĩ bisua de ni, baamɔ de bɛnyɛ bɛyamɛna nɛ ɔhaĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mitse lɛtsa a kĩ mianu a katse wĩ, kitonɛkĩ okĩ edeĩ fɔlɛtsa kayɔkanu ni, baakpa ye kayɔkanu bibu, lɛmɛ okĩ ɛla kayɔkanu kadima ni, baatɛ sukuloo a kĩ ɛkɔna kĩ edeĩ a malo nɛ ye awɛ.” ");
INSERT INTO bov_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Luwi a, Yesu ɔma mɔ bawaɛ̃ ya nɛ ye sɛkɛ̃ lɛmɛ bɛtápuli bifuã ye nɛ bati lidede sũ. ");
INSERT INTO bov_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ade ke odi bi Yesu kĩ, “Ama mɔ awaɛ̃ amɛ dzɛ̃ nɛ kanya kĩ bawɛ bɛmɔ́ nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kpa mbuayɛ kĩ, “Mma mɔ nwaɛ̃ amɛ nyɛ bikĩ batse Baguma kalɛ, bakɛna nɛ ke akũ.” ");
INSERT INTO bov_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Luwi a Yesu mɔ ye fɔtsa bakɔlɛnɛ a wo nɛ ɔkɔlɔ kamɛ ade ebi be kĩ, “Mifɔ̃ bunyina ɔwɔ lutubu baũ a bɔnaa abuĩ atide a.” Ade biyi ɔwɔ a kanyina kayɔ a. ");
INSERT INTO bov_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kĩ biteĩ nɛ mui anɛ banaa a, Yesu wa tida. Deedimɔapɛ ɔwɛ mɔ ɔsĩ odi vũ nɛ lutubu baũ a akũ, ade ɛkabɔa mui kako nɛ ɔkɔlɔ a kamɛ, fɔfɔ̃ bɛna nɛ wuda mɔ nkpã kayite a. ");
INSERT INTO bov_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ye fɔtsa bakɔlɛnɛ a nadzɛla Yesu bibi ye kĩ, “Boe Ɔlate! Boe Ɔlate! Buku buyua!” Awã naa Yesu yidza ɛdza ewũni nɛ ɔwɛ mɔ mui a akũ. Ɔwɛ mɔ mui a onukpɛ̃ dɔ, ade awã flee kɛna dĩĩ a. ");
INSERT INTO bov_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ade evia ye fɔtsa bakɔlɛnɛ a kĩ, “Nde mi katɛkado?” Bɛkɛna saa, libe wo be lɛmɛ, ade bivia be akũ kĩ, “Owei nyɛ oti kĩĩ? Yado ɔwɛ mɔ mui onukpɛ̃ ade batse ye a!” ");
INSERT INTO bov_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu mɔ ye fɔtsa bakɔlɛnɛ a nyina ɔwɔ lutubu baũ a bito Galilea tite akũ bɛyawo Gadara nɛ tite a sɛkɛ sitide a. ");
INSERT INTO bov_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kĩ Yesu nɛ́ nɛ ɔkɔlɔ a kamɛ a, onyole odi kĩ hũhũ kpa na nɛ ye kamɛ nɛ eto ɔmatɔ a kamɛ ɛyatsɛlamɔ ye. Owi buna kĩ onyole kĩĩ tsã ɔdzɔ, ade yaádzi nɛ tɔtɔ kamɛ, mbom asie mɔ funikɛ kamɛ yadzi. ");
INSERT INTO bov_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kĩ ɛmɔ Yesu a, ɛbɔa fɔwɔla kɔɔba ade ɛbɔɛ ye akũ emuni nɛ Yesu abɔa kamɛ mɔ fɔwɔla kĩ, “Yesu Baguma Kpale Nɛ Ode Obi! Litsa akamɔ yĩ? Make nɔ aduli, takɛna yĩ awɔda!” ");
INSERT INTO bov_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Onyole a lɛ fukĩĩ kitonɛkĩ Yesu wũni nɛ hũhũ kpa a akũ kĩ ɛnɛ nɛ oti a kamɛ. Lɔkɔ pii hũhũ kpa a adzi nɛ ye akũ ade ntɛ bido ye nkɔsɔnkɔsɔ nɛ akpɔ mɔ abɔa malo a, yaveliveli ye lɔkɔa hũhũ kpa a akpã ye kanamɛna kɔsa kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu via ye kĩ, “Nde bavɛ nɔ?” Ade ɛkpa mbuayɛ kĩ, “Bavɛ yĩ Lidede,” kitonɛkĩ hũhũ kpa beblebee wo nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hũhũ kpa a ke Yesu aduli kĩ ɛtablɔmɛna be bɛnaawo nɛ lɛkɛ dzununuunu a kĩ lɛlá kakpulakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Baplakuo beblebee na nɛ ɔtɔ odi akũ bɛkadɛ. Foesũ hũhũ kpa a ke Yesu aduli kĩ ɛfɔ̃ bɛnɛ bɛnawo nɛ be kamɛ, ade Yesu lɛmɛ kpa osi a. ");
INSERT INTO bov_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ade bɛnɛ nɛ onyole a kamɛ bɛnawo nɛ baplakuo a kamɛ a. Be kɔdabu a flee wula atsɛ bɛka ɔtɔ sɛkɛ geĩ a biwo nɛ mui kamɛ, bɛmɔa mui biku. ");
INSERT INTO bov_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kĩ bikĩ badãmɛna baplakuo akũ a mɔ́ lɛtsa kĩ lɛya a, bilo bɛnaa ɔmatɔ mɔ tukula kamɛ bɛkabi bati lɛtsa kĩ lɛya a. ");
INSERT INTO bov_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bati nɛ bɛyaadã lɛtsa kĩ lɛya. Ade kĩ biwo Yesu sɛkɛ̃ a bɛmɔ́ onyole a kĩ ye kamɛ hũhũ kpa a nɛ a kĩ edzi nɛ ye abɔa kayɔ. Edo atadiɛ ade ye anɛ kamɛ lɛmɛ kpalɛ. Libe wo bati a flee. ");
INSERT INTO bov_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bikĩ bɛmɔ́ lɛtsa a kĩ lɛya a bi bati ayekĩ bɛblɔmɛna hũhũ kpa nɛ oti a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nɛ fukĩĩ sũ bati a flee nɛ Gadara kayite a na ke Yesu aduli kĩ ɛdzakũ nɛ be tite akũ, kitonɛkĩ libe wo be paa. Nɛ foesũ ewo nɛ ɔkɔlɔ a kamɛ ɛdzakũ. ");
INSERT INTO bov_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Onyole a kĩ ye kamɛ hũhũ kpa a nɛ a ke Yesu aduli kĩ, “Fɔ̃ ntomɔ nɔ bɔnaa.” Lɛmɛ Yesu nyɛ ye osi, ebi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muniki kanaa ɔtɔ kanaalɛ lɛtsa a kĩ Baguma kɛna ɛkpa nɔ a.” Onyole a tsã nɛ ɔmatɔ a kamɛ ɛkalɛ lɛtsa a kĩ Yesu kɛna ɛkpa ye a. ");
INSERT INTO bov_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kĩ Yesu muniki ɛnaa ɔwɔ lutubu baũ sɛkɛ sitide a, bati a tɛ ye mɔ kawɔlɛ kitonɛkĩ be flee bidzi bɛkadzɔlɛ ye. ");
INSERT INTO bov_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ade ke onyole odi kĩ bavɛ Yairo kĩ ɛnyɛ ɔnɔkɔɛ̃ ɔmɔa nɛ Yudafɔ katsɛnakɔ̃ ya nɛ awã a. Ɛyake aduli nɛ Yesu abɔa kamɛ ɛwã ye kĩ ɛfɔ̃ bɛnaa ye tɔtɔ kamɛ, ");
INSERT INTO bov_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kitonɛkĩ ye obitsole mɔapɛ kĩ ɛtɛ futeli ewua-nviã waa nɛ wuda mɔ nkpã kayite. Kĩ Yesu kanaa a, bati pii yi ye akũ. ");
INSERT INTO bov_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Otsole odi kĩ akũ awula ye futeli ewua-nviã flee lɛmɛ na nɛ bati a kamɛ. Otsole kĩĩ bula ye sika flee kade nɛ fɔsɔ batsanɛ sɛkɛ̃ lɛmɛ odima tápuli ɛtsa ye. ");
INSERT INTO bov_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɛkɛna bɔɛɛ ɛtsã bati a kamɛ nɛ Yesu liti ɛta ye atadiɛ sɔtɔ. Deedimɔapɛ babɔanɛ a fɔ̃ kawula. ");
INSERT INTO bov_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ade ke Yesu via kĩ, “Owei lɛta yĩ?” Lɛmɛ odima tákpeti. Foesũ Petro bi ye kĩ, “Boe Ɔlate, dã ayekĩ bati beblebee yi nɔ akũ!” ");
INSERT INTO bov_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lɛmɛ Yesu lɛ kĩ, “Mmɔ́ nɛ yĩ kamɛ kĩ odi ta yĩ ni, kitonɛkĩ kɔbɛ̃ kudi nɛ kuto yĩ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kĩ otsole a mɔ eyi ɔsũ kĩ bɛmɔ́ ye sũ ni, ɛna nɛ kukũtila kamɛ ɛnɛ ɛyake aduli nɛ Yesu abɔa kamɛ. Nɛ bati a flee anɛ kamɛ na, ebi ye lɛtsa nyɛ lɛtsa. Ebi ye lɛtsa a kĩ de sũ ɛta ye, mɔ ayekĩ ɛsaɛ lɛtalɛta a. ");
INSERT INTO bov_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu bi ye kĩ, “Yĩ obitsole, nɔ katɛkado kpa nɔ akũ ɔsĩ. Naa nɛ lukudɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lɔkɔ a kĩ Yesu kalɛ fukĩĩ a, ɔtɔ to Yudafɔ katsɛnakɔ̃ ɔnɔkɔɛ̃ a awã ɛyabi Yairo kĩ, “Nɔ obitsole a ku, fɔtábuki fusĩ kĩ aha fɔtsa ɔtsanɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lɛmɛ kĩ Yesu nu fɔlɛtsa a ebi Yairo kĩ, “Tavila. Nɔ kɔ̃ tɛ kado, obisɛ̃ a aasaɛ.” ");
INSERT INTO bov_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kĩ Yesu wo Yairo tɔtɔ kamɛ a, ɛtákpa odima osi ewo nɛ kɔla a kamɛ, mbɔɛntɛ Petro mɔ Yohanes mɔ Yakobo mɔ obisɛ̃ a ɔlɛga mɔ ɔma odi. ");
INSERT INTO bov_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bati pii dza nɛ awã bɛkabe mɔ kɔnya nɛ obisɛ̃ a wuda sũ. Ade Yesu bi be kĩ, “Mifɔ̃ kabe. Obisɛ̃ a táku. Tida kɛkɛ ɛwaa.” ");
INSERT INTO bov_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lɛmɛ bati a flee mɛmɛ ye kitonɛkĩ binyina kĩ obisɛ̃ a ku. ");
INSERT INTO bov_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ade Yesu pi obisɛ̃ a nɛ kɔkpɔ ɛvɛ ye kɔɔba kĩ, “Yĩ obi, yidza kadza!” ");
INSERT INTO bov_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ade ke katsolebi a nyinya kiyidza kɛdza deedimɔapɛ a. Yesu bi be kĩ bɛkpa ke funitsã kɛnya. ");
INSERT INTO bov_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Fɔlɛtsa kĩĩ nyɛnɛ bamanɛ a akũ, lɛmɛ Yesu si be mbla kĩ bɛtabi odima lɛtsa a kĩ lɛya a. ");
INSERT INTO bov_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Luwi a, Yesu vɛ ye fɔtsa bakɔlɛnɛ ewua-nviã a ɛkpɔta, ade ɛkpa be kɔbɛ̃ mɔ otumi kĩ bɛblɔmɛna hũhũ kpa flee, bɛtsa fɔsɔ kumɛkumɛ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Edo be kĩ bɛnaalɛ kalɛ nɛ Baguma lɛgãkanyakɔ̃ a akũ, lɔkɔa bɛtsa basɔnɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Fɔmɔ baanaa ni, Yesu bi be kĩ, “Mitabɔɛ lɛtsama ndɛ otse kĩ bake katsã, fɔtsa bawãnɛ kuvũ, funitsã ĩye sika milɛ. Mitabɔɛ atadiɛ ayade malo mibu. ");
INSERT INTO bov_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kakɔ nyɛ kakɔ kĩ mise ni, mina nɛ tɔtɔ a kamɛ kɛnaawo lɔkɔ a kĩ míadzakũ nɛ ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Awã kĩ bati tátɛ mi ni, minɛ nɛ ɔmatɔ a kamɛ lɔkɔa mikpa mi abɔa kudu miko nɛ be akũ, fɔnya nsɛntsɛlɛni fɔkpa be kĩ Baguma aavɛlɛ be sɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ade fɔtsa bakɔlɛnɛ a namini nɛ tukula a flee kamɛ bɛkalɛ Kalɛ Wĩ a, bɛkatsa basɔnɛ a nɛ kakɔ nyɛ kakɔ a. ");
INSERT INTO bov_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kĩ Lɛgã Herodes, Galilea tite akũ ɔnyanɛ a nu fɔtsa kĩ fɔlamɛna kaya a, ɛkɛna basaa, kitonɛkĩ bati badi kalɛ kĩ Yohanes Mui Ɔwɔlanɛ a libuki eyidza edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bati bɛbã lɛmɛ lɛ kĩ Eliya libuki ɛya, ade babɛbã lɛmɛ lɛ kĩ Baguma onukpɛ̃ banyɛnɛ kɔɛ a kamɛ odi liyidza edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lɛgã Herodes lɛ kĩ, “Nfɔ̃ bitsua Yohanes lɔlɔ, mɔ owei nyɛ oti a kĩ ye akũ fɔlɛtsa manu a?” Foesũ Lɛgã Herodes kabɔa mbɔdi kĩ yamɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kĩ fɔtsa bakɔlɛnɛ a muniki bɛya a, bibi Yesu lɛtsa nyɛ lɛtsa a kĩ bɛkɛna. Ade ɛkpã be odi bɛnɛ bɔɛɛ bɛnaa Betsaida ɔmatɔ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lɛmɛ kĩ bati kɔdabu a nu foe a, bitomɔ ye bɛnaa awã. Yesu tɛ be ade ebi be fɔlɛtsa nɛ Baguma lɛgãkanyakɔ̃ akũ, ɛtsa bikĩ bisĩ fɔsɔ katsa lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kĩ suwa anaa katomukɔ̃ a, Yesu fɔtsa bakɔlɛnɛ ewua-nviã yabi ye kĩ, “Fɔ̃ bati a bɛdzakũ bɛnaa tukula mɔ fɔpɛ a kĩ fufuã a kamɛ bɛnaawɛ funitsã mɔ fɔwakɔ̃ kitonɛkĩ awĩ lɛnyɛ́ bati kadzikɔ̃.” ");
INSERT INTO bov_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lɛmɛ Yesu bi be kĩ, “Mi mɔawɛ a miwɛ litsedi mikpa be bɛnya.” Ade bɛkpa mbuayɛ kĩ, “Funitsã flee kĩ bɔnɛɛ nyɛ abodoo elo mɔ kɔfɔabi tɔlɛwa nviã. Awɛ kĩ bɔnaaya funitsã bɔma bati beblebee kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Banyole ndɛ be mpim elo na nɛ awã. Ade Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Mifɔ̃ bati a bidzi nɛ kutsukutsu kamɛ. Katsu nyɛ katsu kiwo ndɛ bati aduenum.” ");
INSERT INTO bov_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kĩ fɔtsa bakɔlɛnɛ a kɛna foe lɔmɔ biyua a, ");
INSERT INTO bov_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu bɔɛ abodoo elo mɔ kɔfɔabi nviã a, ɛdɛla anɛ ɛdã odetɔ́ kamɛ, ɛnyɛ Baguma kɔlɛ, ade ebulibuli ye ɛkɔa ɛkpa ye fɔtsa bakɔlɛnɛ a kĩ bɛsɛ̃ bɛkpa bati a. ");
INSERT INTO bov_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bati a flee nya biwĩ, ade ye fɔtsa bakɔlɛnɛ a fila fukĩ fute a biyula tɛtsɛtsɛ ewua-nviã a. ");
INSERT INTO bov_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Luwi a, kĩ Yesu odi na ɛkabɔa mpaɛ a, ye fɔtsa bakɔlɛnɛ a ya nɛ ye sɛkɛ̃ ade evia be kĩ, “Owei bati alɛ kĩ ye manɛ?” ");
INSERT INTO bov_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɛlɛ kĩ, “Badi alɛ kĩ nɔ nyɛ Yohanes Mui Ɔwɔlanɛ a. Badi alɛ kĩ nɔ nyɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya, ade babɛbã lɛmɛ alɛ kĩ Baguma onukpɛ̃ banyɛnɛ kɔɛ a kamɛ odi liyidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ade evia be kĩ, “Nde nyɛ mi lɛmɛ? Owei mialɛ kĩ ye manɛ?” Awã naa, Petro kpa mbuayɛ kĩ, “Nɔ nyɛ Baguma Kristo a.” ");
INSERT INTO bov_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ade Yesu si be mbla mɔ ɔsĩ mɔ ɔsĩ kĩ bɛtabi odima fɔlɛtsa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu buki ebi be kĩ, “Kɛnɛ kĩ Otidziwa Obi a ɛmɔ lubo paa nɛ ɔmaĩ banɔkɔɛ̃, Yudafɔ basɔfɔnɔkɔɛ̃ mɔ Yudafɔ mbla batsanɛ a awɛ. Baasĩ ye lɔkɔa bɛkɔ ye, lɛmɛ nɛ luwi lɛlalɛde akũ ni, Baguma aadzɛla ye etomɛna banɔkpa kamɛ edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ade ebi bati a flee kĩ, “Ntɛ odi awɛ kĩ yatomɔ yĩ ni, kɛnɛ kĩ yafɔnɛ ye apɛdiɛ awɛ, ɛbɔɛ ye lubo kamɔ fɔlɔtsa luwi nyɛ luwi lɔkɔa etomɔ yĩ nɛ liti. ");
INSERT INTO bov_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kitonɛkĩ odi nyɛ odi kĩ yawɛ kĩ yapili ye nkpã ni, yaayɛla ye, lɛmɛ odi nyɛ odi kĩ ɛfɔnɛ ye nkpã awɛ ɛkpa nɛ yĩ katomɛna sũ ni, yaana nkpã wĩ a kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Litsa nfasɔ oti aana ntɛ ɛna katinya kamɛ fɔtsa flee lɛmɛ ɛyɛla ye mɔawɛ nkpã? ");
INSERT INTO bov_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ntɛ yĩ mɔ yĩ fɔtsa a kĩ matsa a nyɛ fɔnyɔãtsa fɔkpa odi ni, ye malo yaanya fɔnyɔãtsa ɛkpa Yĩ Otidziwa Obi a, ntɛ ĩya nɛ yĩ kukũkpalɛ mɔ Nda mɔ ode fɔtɔ banyanɛ kpalɛwa kukũkpalɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mabi mi pipiipi kĩ badi deĩ nɛ mi kamɛ nɛ awĩ kĩ bɛláaku kɛnaawo kĩ Baguma aanyɛ ye lɛgãkanya a ɛtsa be.” ");
INSERT INTO bov_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ndɛ ɛkwansieda mɔa liti kĩ Yesu lɛ fɔlɛtsa kĩĩ a, ɛkpã Petro, Yohanes mɔ Yakobo bide bɛnaa ɔtɔ odi akũ kĩ banaabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kĩ ɛkabɔa mpaɛ a ye anɛ kamɛ dani, ade ye tɛtadiɛ kɛna fita fita, tɛkata muamua a. ");
INSERT INTO bov_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ade banyole nviã kĩ bɛnyɛ Mose mɔ Eliya nɛ bɛdza bɛmɔ Yesu bɛkalɛ kɔdzɛla a. ");
INSERT INTO bov_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bɛna nɛ ode kukũkpalɛ kamɛ ade bɛkalɔmɛna mɔ Yesu nɛ osi a kĩ ye akũ yaatsã ɛkɛna nɛ Baguma nhihiɛ a kĩ ɛkɛna eyi kĩ yaaku nɛ Yerusalem akũ a. ");
INSERT INTO bov_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Titɔ kĩ Petro mɔ ye bade a wa tida kɔlaa malo ni, binyinya bɛmɔ́ Yesu kukũkpalɛ mɔ bati nviã a kĩ bɛdza nɛ ye ɔwɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kĩ bati a adzakũ a, Petro bi Yesu kĩ, “Boe Ɔlate, fɔnɛnɛ paa kĩ bɔya nɛ awĩ. Bɔ́abɔa fɔpɛ ɛlalɛ, nɔ lide lɔmɔa, Mose lide lɔmɔa, Eliya lɛmɛ lide lɔmɔa.” Lɛmɛ ɛtáti enyi lɛtsa a kĩ de ɛkalɛ a malo. ");
INSERT INTO bov_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kĩ ɛkalɛ kɔdzɛla a, luflututu ka ade de kuyo ko nɛ be akũ a. Fɔtsa bakɔlɛnɛ a vila nɛ lɔkɔ a kĩ luflututu a ka lisua be akũ a. ");
INSERT INTO bov_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ade odo odi nɛ eto luflututu a kamɛ ɛlɛ kĩ, “Ade yĩ obi a kĩ mpau a. Mitse ye kalɛ.” ");
INSERT INTO bov_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kĩ odo a tsua a, Yesu odi lite nɛ awã. Fɔtsa bakɔlɛnɛ a sua onukpɛ̃ nɛ fukĩĩ flee akũ ade bɛtábi odima kadima nɛ lɛtsa a kĩ bɛmɔ́ a akũ nɛ lɔkɔ a na kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kĩ kade nyina a, Yesu mɔ ye fɔtsa bakɔlɛnɛ ɛlalɛ a ka ɔtɔ a, ade bati kɔdabu baũ kudi yatsɛlamɔ ye a. ");
INSERT INTO bov_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Onyole odi nɛ bati a kamɛ bɔa fɔwɔla ɛlɛ kĩ, “Fɔtsa Ɔtsanɛ! Make nɔ aduli dã yĩ obi kakpa yĩ, yĩ obi mɔapɛ! ");
INSERT INTO bov_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hũhũ kpa adi adzi nɛ ye akũ lɔkɔa yabɔa fɔwɔla. Odetɔ́ fɔsɔ ade kadzi nɛ ye akũ, kabɔɛ ye kamuni, lɔkɔa kuvũ anɛ nɛ ye onukpɛ̃. Fɔafɔ̃ yapila ade hũhũ a lɛvá ye awɛ kafɔnɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nke nɔ fɔtsa bakɔlɛnɛ a aduli kĩ bɛblɔmɛna hũhũ kpa a, lɛmɛ bɛtápuli.” ");
INSERT INTO bov_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ade Yesu bi be kĩ, “O nviã babi mɔ atɔ ɔsĩ kĩ milá katɛkado! Lɔkɔ lɔwɔdabe maana nɛ mi sɛkɛ̃, nna ɔwɔlɛ bɔɛɛ lɛmɛ nkpa mi?” Ade ebi onyole a kĩ, “Kpã nɔ obi a kayamɛna nɛ awĩ.” ");
INSERT INTO bov_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kĩ kanyolebi a yɛlɛ kaya a, hũhũ kpa a bɔɛ ye emuni nɛ tite ade ke odetɔ́ fɔsɔ de fudzi nɛ ke akũ a. Awã naa Yesu do hũhũ kpa a onukpɛ̃, ade ɛtsa kanyolebi a ɛkɔa ke ɛkpa ɔlɛga a. ");
INSERT INTO bov_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baguma kɔbɛ̃ baũ lɛkɛnana kĩĩ kɛna bati a flee saa. Kĩ bati a kakɔna lɔlɔ kamɛ nɛ awãwã fɔtsa a kĩ Yesu kɛna akũ a, ebi ye fɔtsa bakɔlɛnɛ a kĩ, ");
INSERT INTO bov_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mitalɛla lɛtsa a kĩ maabi mi a! Baakɔa Otidziwa Obi a bido nɛ bati awɛ.” ");
INSERT INTO bov_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lɛmɛ fɔtsa bakɔlɛnɛ a tánu foe kayɔ. Bɛkɔa foe bɛkɔla be kĩ bɛtanu foe kayɔ ade bivila kĩ bavia ye foe kayɔ a. ");
INSERT INTO bov_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Fɔlɛtsa kavɛlɛ ya nɛ fɔtsa bakɔlɛnɛ a kamɛ nɛ owula a kĩ ye bɛ̃ flee nɛ be kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kĩ Yesu nyi lɛtsa kĩ bɛkakɔna a, ɛvɛ obisɛ̃ odi ɛyadzɛla nɛ ye ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ade ebi be kĩ, “Odi nyɛ odi kĩ ɛtɛ obisɛ̃ kĩĩ nɛ yĩ dĩ akũ ni, ade yĩ ɛtɛ a, ade odi nyɛ odi kĩ ɛtɛ yĩ ni, ɛtɛ owula a kĩ edo yĩ fɔtɔ a. Kitonɛkĩ owula kĩ ɛnyɛ obisɛ̃ kɔlaa nɛ mi kamɛ a, ade ye lɛtɛ kɔya ɛbɛ̃ a.” ");
INSERT INTO bov_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanes bi Yesu kĩ, “Boe Ɔlate, bɔmɔ́ onyole odi kĩ ɛkablɔmɛna hũhũ kpa nɛ nɔ dĩ akũ, lɛmɛ busua ye osi, kitonɛkĩ ɛláa boe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu bi ye mɔ fɔtsa bakɔlɛnɛ bɛbã a kĩ, “Mitasua ye osi, kitonɛkĩ odi nyɛ odi kĩ ɛdzɛ́ nɛ mi akũ ni, mi etomɛna.” ");
INSERT INTO bov_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kĩ lɔkɔ kawo ɔtɔ kĩ Baguma aabɔɛ Yesu ɛnamɛna ode a, esipi kĩ yanaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Edo fɔtɔ banyanɛ badi bɛnya ye lɔtɔ bɛnaa Samaria akula adi kamɛ kĩ bɛnaamanɛ lɛtsa nyɛ lɛtsa bɛkpa ye kaya. ");
INSERT INTO bov_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lɛmɛ akula a kamɛ bati sĩ kĩ baátɛ Yesu, kitonɛkĩ binyina kĩ ɛtɛ̃ yanaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kĩ Yohanes mɔ Yakobo nu fɔlɛtsa a, bivia Yesu kĩ, “Boe Ɔlate, awɛ kĩ bɔvɛ fi butomɛna ode fɔyaawɔla be?” ");
INSERT INTO bov_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lɛmɛ Yesu dani ɛkã be anɛ ɛlɛ kĩ, “Minyína Hũhũ a kĩ ye bade mianɛ! Yĩ Otidziwa Obi a ntáya kĩ mayaawɔla bati, mbom ĩya kĩ maatɛ be nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Foesũ Yesu mɔ ye fɔtsa bakɔlɛnɛ a tɛ̃ bɛnaa akula bɛbã kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kĩ bɛtsɛ̃ banaa a, onyole odi bi Yesu kĩ, “Maatomɔ nɔ nnaa kakɔ nyɛ kakɔ kĩ aanaa.” ");
INSERT INTO bov_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ade Yesu bi ye kĩ, “Kulikii deĩ fudzikɔ̃, kɔvɔlabi lɛmɛ deĩ fɔtsɔɛ, lɛmɛ Otidziwa Obi a lɛlá awã kĩ yate lɔlɔ malo.” ");
INSERT INTO bov_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ebi oti bɛbã kĩ, “Tomɔ yĩ.” Lɛmɛ oti a lɛ kĩ, “Boe Ɔlate, maatomɔ nɔ, lɛmɛ fɔ̃ nnaabila nda tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ade Yesu bi ye kĩ, “Fɔnɛ bikĩ bɛlá Baguma nkpã mɔawɛ a bibila be banɔkpa. Nɔ kɔ̃ naa kanaade lɛtsã nɛ Baguma lɛgãkanyakɔ̃ a akũ.” ");
INSERT INTO bov_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oti bɛbã kɔ̃ lɛ kĩ, “Boe Ɔlate, maatomɔ nɔ, lɛmɛ fɔ̃ nnaakla yĩ kɔla bati tɔ̃.” ");
INSERT INTO bov_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ade ke Yesu bi ye kĩ, “Oti kĩ ɛdzɛ̃ yapupu, mɔ yadani kadã liti ni, ɛtáfɛta ɛkpa Baguma lɛgãkanyakɔ̃ adzuma a.” ");
INSERT INTO bov_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Fukĩĩ liti a, boe Ɔlate pau bati aduesɔũ-nviã bɛbã, ade edo be nviã nviã kĩ bɛnya lɔtɔ bɛnaa tɛmatɔ mɔ tukula a kĩ ye mɔawɛ yaatsã te kamɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ade ebi be kĩ, “Fudutsa a kĩ míave a pɔnɛ lɛmɛ adzuma bakɛnanɛ a lɛpɔ́nɛ. Mibɔa mpaɛ mikpa kɔba ɔlate a kĩ edo adzuma bakɛnanɛ pii bɛyaave fudutsa a. ");
INSERT INTO bov_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Minaa! Mado mi fɔtɔ ndɛ bavelibi nɛ kulikii kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mitabɔɛ sika kuvũ, ĩye osi katsã fuvũ, ĩye mpabua milɛ, ade mitafɔ̃ midza nɛ osi kĩ miawɔ̃na odima a. ");
INSERT INTO bov_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ntɛ miwo tɔtɔ tidi kamɛ ni, minya lɔtɔ milɛ kĩ, ‘Lukudɔ lɛya nɛ tɔtɔ kĩĩ kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ntɛ oti kĩ yawɛ lukudɔ deĩ nɛ awã ni, mifɔ̃ mi lukudɔ a litomɔ ye. Lɛmɛ ntɛ odima lɛláa ni, mi nhila a aamuniki ɛya nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mina nɛ tɔtɔ mɔapɛ a kamɛ, minya mimɔa lɛtsa nyɛ lɛtsa a kĩ bɛkpa mi. Kitonɛkĩ adzuma ɔkɛnanɛ odi nyɛ odi sĩ kɔtɔkase. Mitatu nɛ tɔtɔ mɔa kamɛ minaa tɔtɔ bɛbã kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ntɛ miwo ɔmatɔ odi kamɛ mɔ bɛtɛ mi ni, minya lɛtsa nyɛ lɛtsa a kĩ bɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mitsa basɔnɛ nɛ ɔmatɔ a kamɛ lɔkɔa mibi bati a kĩ, ‘Baguma lɛgãkanya lɔkɔ a fuã mi.’ ");
INSERT INTO bov_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lɛmɛ ntɛ miwo ɔmatɔ odi kamɛ mɔ bɛtátɛ mi ni, midzakũ minaa ye tɔblɔnu akũ lɔkɔa milɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Bɔkpa mi ɔmatɔ kudu a nɛ boe abɔa buko nɛ mi akũ. Lɛmɛ mite anɛ kĩ Baguma lɛgãkanya lɔkɔ a fuã mi!’ ");
INSERT INTO bov_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ade mabi mi pipiipi kĩ nɛ bati kadzɛmɛna luwi a akũ ni, Baguma aamɔ Sodom ɔmatɔ a kɔnya ɛba ɔmatɔ a na! ");
INSERT INTO bov_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bɔbɔɛ makpa nɔ Korasin ɔmatɔ, bɔbɔɛ makpa nɔ Betsaida ɔmatɔ a lɛmɛ! Ntɛ Tiro mɔ Sidon tɛmatɔ a kamɛ nkɛna awãwã fɔtsa ni, kufɛ bidzi nɛ tite, bisua fumakũ akũ, bɛtsɛla batɔ kɔkɔɛ, bɛkɔa bɛtsa kĩ bɛdani tɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Baguma aamɔ Tiro mɔ Sidon kɔnya nɛ kadzɛmɛna luwi a akũ ɛba mi. ");
INSERT INTO bov_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ade nɔ Kapernaum ɔmatɔ! Kawɛ ɔwɛ kĩ adɛla nɔ akũ nɛ ode? Baakɛna nɔ nɛ kayɔ ɔnaa kanɔkpade!” ");
INSERT INTO bov_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Odi nyɛ odi kĩ yatse mi kalɛ ni, ade yĩ yatse a. Odi nyɛ odi kĩ esĩ mi ni, ade yĩ esĩ a. Ade ke odi nyɛ odi kĩ esĩ yĩ ni, esĩ Baguma a kĩ edo yĩ fɔtɔ a lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bati aduesɔũ-nviã a muniki bɛya mɔ kawɔlɛ bɛyalɛ kĩ, “Boe Ɔlate, hũhũ kpa malo tse boe ntɛ buwũni nɛ be akũ nɛ nɔ dĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu bi be kĩ, “Mmɔ́ Abonsam ndɛ odetɔ́ kamɛ kamɔanɛ aye kĩ eto ode ɛyatɔ. ");
INSERT INTO bov_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mitse! Nkpa mi kɔbɛ̃ ayekĩ míapuli misuma bɔɛ mɔ kɔkpɔ̃na, ade míanya Okesĩnɛ a kɔbɛ̃ akũ kĩ lɛtsama lɛláakɛna mi a. ");
INSERT INTO bov_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lɛmɛ kawɔlɛ kɛtade mi kĩ hũhũ kpa tse mi kalɛ, mbom mimɔ kawɔlɛ kĩ bɛtsɛlɛ mi buĩ biyi nɛ ode.” ");
INSERT INTO bov_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nɛ lɔkɔ a na kamɛ a, Hũhũ Kpalɛwa a kawɔlɛ wo nɛ Yesu kamɛ ade ɛlɛ kĩ, “Yĩ Ɔlɛga, tite mɔ ode Ɔlate, manyɛ nɔ kɔlɛ kitonɛkĩ fɔtsa a kĩ bɛkɔa bɛkɔla kadi banyinɛ mɔ tuvoli banyinɛ a, ɔnyɛ foe ɔtsa bikĩ binyína tuvoli ndɛ babisɛ̃ aye. Oo, Nda, ade aye koũ ɔwɛ kĩ fɔna a.” ");
INSERT INTO bov_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu buki ɛlɛ kĩ, “Nda kɔa lɛtsa nyɛ lɛtsa edo nɛ yĩ awɛ. Odima linyína oti a kĩ Baguma Obi a anɛ mbɔɛntɛ Ɔlɛga a odi keĩ. Ade aye odima lɛmɛ linyína oti a kĩ Ɔlɛga a anɛ, mbɔɛntɛ Obi odi mɔ bikĩ Obi aawɛ kĩ yanyɛ Ɔlɛga ɛtsa a.” ");
INSERT INTO bov_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ade Yesu dani ebi ye fɔtsa bakɔlɛnɛ a odi bɔɛɛ kĩ, “Lɛmɛ mi kɔ̃ Baguma hila mi! Mi anɛ amɔ ade mi atɔ lɛmɛ anu fɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mabi mi kĩ Baguma onukpɛ̃ banyɛnɛ pii mɔ fɔgã wɛ kĩ bamɔ lɛtsa a kĩ mimɔ́ finyaa, lɛmɛ bɛtápuli bɛmɔ́, ade bɛwɛ kĩ banu lɛtsa a kĩ mianu a, lɛmɛ bɛtánu foe.” ");
INSERT INTO bov_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Luwi a, Yudani mbla ɔtsanɛ a odi ya kĩ yasɔ Yesu ɛdã. Evia ye kĩ, “Fɔtsa Ɔtsanɛ, litsa kɛnɛ kĩ nkɛna nna nkpã a kĩ ɛlá kawũna a?” ");
INSERT INTO bov_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kpa mbuayɛ kĩ, “Litsa Katsɛlɛ Kpalɛwa a lɛ? Nde onu foe kayɔ?” ");
INSERT INTO bov_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Onyole a kpa mbuayɛ kĩ, “Wɛ nɔ Ɔlate, nɔ Baguma kalɛ mɔ nɔ ɔwɔlɛ flee, nɔ ɔkla flee nɔ kɔbɛ̃ flee mɔ nɔ kakɔna flee, kawɛ nɔ ɔkɔba kalɛ ndɛ ayekĩ awɛ nɔ mɔawɛ akũ a.” ");
INSERT INTO bov_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu bi ye kĩ, “Ɔlɛ ɔnɔkɔali. Kɛna fukĩĩ lɔkɔa aana nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lɛmɛ mbla ɔtsanɛ kĩĩ wɛ kĩ yakpa ye akũ ɔtɔbɛ, foesũ evia Yesu kĩ, “Owei nyɛ yĩ ɔkɔba?” ");
INSERT INTO bov_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kpa mbuayɛ kĩ, “Luwi a, onyole odi to Yerusalem yanaa Yeriko ɔmatɔ kamɛ, ade bayekpanɛ napi ye nɛ osi a. Bibo ye bɛyɛlɛ ye akũ tɛtadiɛ, ade bɛfɔnɛ ye awɛ biyi nɛ wuda mɔ nkpã kayite a. ");
INSERT INTO bov_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fɔyaya kĩ ɔsɔfɔ odi yatsã nɛ osi a na akũ yatɛ̃, lɛmɛ kĩ ɛmɔ oti kĩĩ a ɛtsã ɔɔwɛ̃ ɛtɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ade ayea Levini lɛmɛ yatɛ̃ a. Efuã ɛnadã onyole a, ade ye malo ɛtsã ɔɔwɛ̃ ɛtɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lɛmɛ Samariani odi kĩ ɛtsɛ̃ osi a akũ yamɔ oti a. Kĩ ɛmɔ oti a, ye akũ kɔ ye kɔnya. ");
INSERT INTO bov_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Efuã ye ade ɛkɔa kugua mɔ bavɛ eko nɛ ye fɔɔkpa kamɛ esui foe a. Ade ɛbɔɛ onyole a ete nɛ ye mɔawɛ ɔyaɛ akũ, ɛkɔa ye ɛnamɛna banɔvɔɛ̃ kasɛkɔ̃ ade ɛdã ye akũ a. ");
INSERT INTO bov_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kĩ kade nyina a, ɛnyɛ sika ɛkpa kasɛkɔ̃ a akũ ɔdãmɛnanɛ a ebi ye kĩ, ‘Dã ye akũ. Ntɛ mmuniki matɛ̃ ni maase nɔ lɛtsa nyɛ lɛtsa a kĩ aabuki obula kade nɛ ye akũ a kɔtɔ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ade Yesu wũna evia ye kĩ, “Nɛ nɔ kakɔna onukpɛ̃ ni, bati ɛlalɛ kĩĩ kamɛ a, ɔwɔdabe lɛnyɛ ye tɔkɔba kakɛna ɛtsa oti a kĩ ewo nɛ bayekpanɛ awɛ kamɛ a?” ");
INSERT INTO bov_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ade mbla ɔtsanɛ a kpa mbuayɛ kĩ, “Oti a kĩ ɛmɔ ye kɔnya a.” Yesu bi ye kĩ, “Kekɔ̃ nɔ malo naa kanaakɛna foe lɔmɔ.” ");
INSERT INTO bov_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Luwi a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a tsɛ̃ nɛ osi ade bɛnawo akula adi kamɛ a. Otsole odi kĩ bavɛ Marta tɛ ye nɛ ye tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta deĩ ɔwaɛ̃tsole kĩ bavɛ Maria. Edzi nɛ boe Ɔlate ɔwɛ̃ ɛkatse ye fɔtsa katsa. ");
INSERT INTO bov_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Fɔha Marta kĩ tɔtɔ kamɛ adzuma ko nɛ ye odi akũ, foesũ ɛnabi Yesu kĩ, “Boe Ɔlate, fɔtsɛ́la nɔ akũ kĩ nwaɛ̃ kɔa tɔtɔ kamɛ tudzuma a flee eko nɛ yĩ odi akũ? Bi ye ɛyaabumɛna yĩ!” ");
INSERT INTO bov_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ade boe Ɔlate kpa mbuayɛ kĩ, “O Marta! Dã, aha nɔ akũ nɛ fɔtsa pii akũ, ");
INSERT INTO bov_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lɛmɛ lɛtsa mɔapɛ lisĩ. Maria nyɛ lɛtsa wĩ a kĩ bɛláatɛ nɛ ye awɛ.” ");
INSERT INTO bov_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Luwi a, Yesu kabɔa mpaɛ nɛ kakɔ kadi. Kĩ eyua a, ye fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa bi ye kĩ, “Boe Ɔlate, tsa boe mpaɛ kabɔa ndɛ ayekĩ Yohanes tsa ye fɔtsa bakɔlɛnɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu bi be kĩ, “Ntɛ miabɔa mpaɛ ni, milɛ kĩ, ‘Boe Ɔlɛga, fɔ̃ bɛkpalɛ nɔ dĩ akũ. Nɔ lɛgãkanya a kɛya. Bɛkɛna nɛ nɔ kawɛ akũ, nɛ tite akũ ndɛ ayekĩ bakɛna nɛ ode a. ");
INSERT INTO bov_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kpa boe luwi nyɛ luwi funitsã a kĩ fusĩ boe a ");
INSERT INTO bov_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kɔa boe tɔkpa kate boe kitonɛkĩ boe malo bɔakɔa odi nyɛ odi tɔkpa kĩ ɛkɛna nɛ boe akũ a kate. Tafɔ̃ buwo nɛ sɔhuiɛ kamɛ, mbom nyɛ boe katomɛna tɔkpa kamɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ade Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Mibɔɛ foe kĩ mi kamɛ odi naa ɔkɔba sɛkɛ̃ mɔ lɛnyɛ kayite ɛnabi ye kĩ, ‘Ɔkɔba, vɛ abodoo fɔbɔ ɛlalɛ kakpa yĩ, ");
INSERT INTO bov_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kitonɛkĩ yĩ ɔkɔba odi to osi mɔ lugo akũ ɛyase yĩ finyaakĩĩ, ade nlá funitsã fudima kĩ makpa ye a!’ ");
INSERT INTO bov_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Bɔɛ foe kĩ nɔ ɔkɔba a nɛ́ nɛ kɔla kamɛ ɛkpa mbuayɛ kĩ, ‘Taha yĩ kɔlaa! Ndo kɔla safi ade bɔmɔ yĩ babi bɔwa kɔkɔɛ. Nláapuli mbuki ĩyidza mbɔɛ lɛtsama nkpa nɔ finyaa.’ ");
INSERT INTO bov_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mabi mi kĩ ntɛ nɛ be tɔkɔba kakɛna sũ ni, ɛláayidza. Lɛmɛ nɛ ayekĩ ɛdzɛ̃mɛna opunu kabɔa sũ ni, yaayidza ɛkpa ye lɛtsa nyɛ lɛtsa kĩ lisĩ ye a. ");
INSERT INTO bov_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Foesũ mabi mi kĩ mivia fɔtsa lɔkɔa baakpa mi, miwɛ lɔkɔa míamɔ foe, mibɔa opunu lɔkɔa baabinya bɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kitonɛkĩ odi nyɛ odi kĩ ɛwã fɔtsa ni, yaana foe. Odi nyɛ odi kĩ ɛwɛ litsedi ni, yaamɔ de, ade odi nyɛ odi kĩ yabɔa opunu ni, baabinya bɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mi kamɛ ɔwɔdabe kĩ ɛnyɛ obilɛga, aakɔa kɔɛ ɛkpa obi ntɛ evia ye kafɔabi? ");
INSERT INTO bov_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ĩye ɛkɔa kakpɔ̃na ɛkpa ye ntɛ evia ye ɔkɔkɔ lige? ");
INSERT INTO bov_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Titɔ kĩ minyɛ tɔkpa bakɛnanɛ malo ni, minyina ayekĩ miate mi babi fɔtsa wĩ. Nde fɔ́aya mɔ boe Ɔlɛga nɛ ode lɛláakɔa ye Hũhũ Kpalɛwa a ɛkpa bikĩ baavia ye a!” ");
INSERT INTO bov_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Luwi a, Yesu kablɔmɛna hũhũ kpa kĩ yaálɛ kɔdzɛla etomɛna odi kamɛ. Kĩ hũhũ kpa a nɛ a, oti a yi kɔdzɛla kalɛ kayɔ. Fukĩĩ kɛna bati a kĩ bɛdza nɛ awã a wãwã. ");
INSERT INTO bov_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lɛmɛ bati a badi lɛ kĩ, “Hũhũ kpa lɛgã a kĩ bavɛ Beelzebul a lɛkpa ye kɔbɛ̃ ɛkɔa ɛblɔmɛna hũhũ kpa a.” ");
INSERT INTO bov_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ade badi lɛmɛ wɛ kĩ basɔ Yesu bɛdã, foesũ bibi ye kĩ ɛkɛna awãwã fɔtsa ɛkɔa ɛtsa kĩ Baguma sɛkɛ̃ eto. ");
INSERT INTO bov_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lɛmɛ Yesu nyi lɛtsa a kĩ bɛkakɔna a, foesũ ebi be kĩ, “Ɔmaĩ kĩ ɛsɛ̃ nɛ kutsu kutsu kamɛ, mɔ lɛma nɛ́ nɛ ye kamɛ ni, ɔmaĩ a na aawɔ. Ade aye tɔtɔ nyɛ tɔtɔ kĩ te kamɛ bati sɛ̃ be akũ ni, tayalɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Foesũ ntɛ Abonsam lɛgãkanyakɔ̃ a sɛ̃ nɛ kutsu kutsu kamɛ mɔ banɔ akũ lɛma ni, nde kanyakɔ̃ a na aapuli kɛdza? Mialɛ kĩ mablɔmɛna hũhũ kpa kitonɛkĩ Beelzebul lɛkpa yĩ kɔbɛ̃ sũ. ");
INSERT INTO bov_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ntɛ aye mablɔmɛna hũhũ kpa a ni, nde bikĩ bitomɔ mi a ablɔmɛna hũhũ kpa? Mi mɔawɛ bati a nyɛ mi kayɔ bɛtsa kĩ fɔvã miama. ");
INSERT INTO bov_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oowo! Mbom Baguma kɔbɛ̃ akũ fɔtsɛ̃ mɔ mablɔmɛna hũhũ kpa, foesũ fukĩĩ atsa yededeede kĩ Baguma lɛgãkanya a wo mi sɛkɛ̃ kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ntɛ odi kĩ edeĩ kɔbɛ̃ dzi akpadza, edzi yadzɔlɛ ye tɔtɔ ni, enyina kĩ ye akũ fɔtsa waa pɛpɛɛpɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lɛmɛ ntɛ odi kĩ edeĩ kɔbɛ̃ ɛbɛ̃ ye yanɔ mɔ ye ɛnya ye akũ ni, yafila ye kawũkanɔ fɔtsa a kĩ ete anɛ nɛ foe akũ a ɛsɛ̃ fɔtsa a kĩ ɛtɛ a. ");
INSERT INTO bov_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Odi nyɛ odi kĩ ɛnyɛ́ yĩ ode ni, ɛdzɛ̃ nɛ yĩ akũ paa, ade odi nyɛ odi kĩ yaábumɔ yĩ bɔkpɔta ni, fɔtsa ɛlamɛna kayalɛ paa.” ");
INSERT INTO bov_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ntɛ hũhũ kpa nɛ́ nɛ oti kamɛ ni yanaatsã kamini nɛ fɔkɔ wɔlɛwa kawɛ kasekɔ̃. Ntɛ ɛtána kasekɔ̃ ni, yabi ye akũ kĩ, ‘Maamuniki nnaa yĩ tɔtɔ a kĩ te kamɛ nnɛ́ nto a kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Foesũ yamuniki kanaamɔ kĩ bɛyɔ tɔtɔ a kamɛ bɛmanɛ lɛtsa nyɛ lɛtsa pɛpɛɛpɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lɔkɔa yamuniki kanaawɛ hũhũ kpa evũkɔnɔ kĩ bideĩ ablɔ bɛbɛ̃ ye kabumɔ ye akũ bayaadzi nɛ awã. Ntɛ fɔya lɔmɔ a, oti a kadzi kamɛ abu kade kaba ayekĩ fɔna nɛ kayɔkayi a.” ");
INSERT INTO bov_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kĩ Yesu kalɛ fɔlɛtsa kĩĩ a, otsole odi bɔa fɔwɔla nɛ bati kɔdabu a kamɛ ɛlɛ kĩ, “Baguma hila otsole a kĩ ɛma nɔ, mɔ lɛmɛ a kĩ de ɔmɛmɛ a!” ");
INSERT INTO bov_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lɛmɛ Yesu kpa mbuayɛ kĩ, “Mbom bihila bikĩ batse Baguma kalɛ, kĩ bakɛna nɛ ke akũ lɛmɛ a!” ");
INSERT INTO bov_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kĩ bati kɔdabu a bɔa opim nɛ Yesu akũ a, ɛlɛ ɛnaa lɔtɔ kĩ, “Nviã babi nyɛ bati kpa paa! Bawɛ nsɛntsɛlɛni fɔtsa bɛmɔ́ lɛmɛ bɛláamɔ fudima kɛba Baguma Onukpɛ̃ Ɔnyɛnɛ Yona fude a. ");
INSERT INTO bov_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ndɛ ayekĩ Yona nya nsɛntsɛlɛni ɛkpa Ninivefɔ a, ade aye Otidziwa Obi a lɛmɛ aanya nsɛntsɛlɛni nkpa nviã babi a. ");
INSERT INTO bov_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nɛ Kadzɛ Luwi a akũ ni, Seba Lɛgãtsole a aayidza ɛdza ɛkɔ nviã babi kɔtɔ kitonɛkĩ eto ye tite akũ nɛ kakɔ mɔ lugo ɛnatse Lɛgã Salomo kadikanyi fɔtsa katsa a, lɛmɛ mabi mi kĩ odi kĩ ɛbɛ̃ Salomo deĩ nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivefɔ lɛmɛ aayidza bɛkɔ mi kɔtɔ nɛ Kadzɛ Luwi a akũ, kitonɛkĩ bɛdani tɔwɔlɛ kamɛ lɔkɔ a kĩ Yona bi be Baguma kalɛ a. Lɛmɛ mabi mi kĩ odi kĩ ɛbɛ̃ Yona deĩ nɛ mi kamɛ nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Odima látɛna ɔsɛdza kakɔla ye ĩye kakɔa lɔɔda kasua ye. Mbom bakɔa ye kate nɛ ɔsɛdza otse akũ ayekĩ ntɛ bati awo nɛ tɔtɔ kamɛ ni, baamɔ fɔkɔ yededeede. ");
INSERT INTO bov_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oti banebi kɛna ndɛ ɔsɛdza ɛkpa ye kutitse. Ntɛ nɔ anɛ amɔ kamɔ wĩ ni, nɔ kutitse a flee deĩ nɛ ɔhaĩ kamɛ. Lɛmɛ ntɛ nɔ anɛ lɛnɛ́nɛ ni, nɔ kutitse a flee aana nɛ ɔtũ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Foesũ dã kadã wĩ lɔkɔa ɔhaĩ a kĩ edeĩ nɛ nɔ kamɛ a ɛtadani ɛkɛna ɔtũ. ");
INSERT INTO bov_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ntɛ nɔ akũ flee kɛna haĩ mɔ nɔ kakɔma lɛláa ɔtũ kamɛ ni, nɔ akũ flee aakpalɛ ndɛ ayekĩ ɔsɛdza ako nɛ fɔtsa akũ kakpalɛ foe a.” ");
INSERT INTO bov_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kĩ Yesu yua kɔdzɛla a, Farisini odi tsɛlamɔ ye kĩ ɛyaanya nɛ ye sɛkɛ̃. Foesũ ɛnaa awã ɛnɛ edzi kĩ yanya. ");
INSERT INTO bov_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fɔkɛna Farisini a wãwã kĩ ɛmɔ kĩ Yesu távɔlɛ awɛ ndɛ ayekĩ mbla tsa a fɔmɔ eyi kanya kayɔ. ");
INSERT INTO bov_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Foesũ boe Ɔlate bi ye kĩ, “Finyaa ni, mi Farisifɔ miavɔlɛ mi tɔkɔɔpu mɔ fɔɔdaɛ liti, lɛmɛ anɛngbã mɔ ablɔ yi mi kamɛ tɛtɛɛtɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bakɔasia! Nnɛ́ Baguma a kĩ ɛkɛna fɔtsa fɔmɛde a lɛkɛna kanya fude a lɛmɛ mbɔɛɛ? ");
INSERT INTO bov_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mikɔa fɔtsa a kĩ fudeĩ nɛ tɔkɔɔpu mɔ fɔɔdaɛ kamɛ a mikpa ahiãfɔ lɔkɔa mi lɛtsa nyɛ lɛtsa akũ aakpalɛ nɛ Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Bɔbɔɛ makpa mi Farisifɔ! Miakɔa tɛnyɛ kumɛkumɛ kĩ tabɔa mɔ ɔlɛ̃ mɔ ɔlɛ̃ a te katsu kawuade kakpa Baguma, lɛmɛ misĩ ɔtɔbɛ kakpa bati ade miáwɛ Baguma kalɛ lɛmɛ a. Ade fukĩĩ bamɛ kɛnɛ kĩ miakɛna mibumɔ foe nkaɛ a. ");
INSERT INTO bov_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Bɔbɔɛ makpa mi Farisifɔ! Miawɛ banɔkɔɛ̃ fudzikɔ̃ nɛ mi katsɛnakɔ̃ ade miawɛ kĩ bati bɛwɔ̃na mi mɔ obu nɛ kɔya a. ");
INSERT INTO bov_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Bɔbɔɛ makpa mi! Mila ndɛ funi kĩ bɛtáyi foe ɔsũ, kĩ bati tsɛ̃ nɛ foe akũ nɛ katanyi kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nɛ awã naa Yudafɔ mbla batsanɛ a kamɛ ɔmɔa bi ye kĩ, “Fɔtsa Ɔtsanɛ, ntɛ ɔlɛ fukĩĩ ni, ovũna boe malo.” ");
INSERT INTO bov_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kpa mbuayɛ kĩ, “Bɔbɔɛ makpa mi mbla batsanɛ a lɛmɛ. Milɔ́la bati fɔlɔtsa kĩ foe kalɔ deĩ ɔlɔmɛ, lɛmɛ mi mɔawɛ miáyo awɛ kĩ míabumɔ be fɔtsa a kalɔ. ");
INSERT INTO bov_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Bɔbɔɛ makpa mi paa kitonɛkĩ mike funi mɔkalɛ mikpa Baguma onukpɛ̃ banyɛnɛ a. Ade Baguma onukpɛ̃ banyɛnɛ a kĩ mi bawanyɔ kɔ a. ");
INSERT INTO bov_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mi mɔawɛ a mitunɔ kĩ lɛtsa a kĩ mi bawanyɔ kɛna a nɛnɛ. Bɛkɔ Baguma onukpɛ̃ banyɛnɛ a ade mi mike be funi a. ");
INSERT INTO bov_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nɛ fukĩĩ sũ Baguma nɛ ye kadikanyi kamɛ lɛ kĩ, ‘Maado Yĩ onukpɛ̃ banyɛnɛ mɔ fɔtɔ banyanɛ nɛ be sɛkɛ̃. Baakɔ badi, bitomɔ babɛbã lɛmɛ liti.’ ");
INSERT INTO bov_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Foesũ baavɛlɛ nviã bati sɔtɔ nɛ Baguma onukpɛ̃ banyɛnɛ flee a kĩ bɛkɔ, kito anɛ katinya kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kito Abel kakɔ kɛnawo Zakaria kĩ bɛkɔ nɛ afɔlibɔ atɛnyɛ mɔ kakɔ kpalɛwa kayite a. Nuwĩ paa kĩ, baavɛlɛ nviã babi sɔtɔ nɛ fukĩĩ flee sũ! ");
INSERT INTO bov_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Bɔbɔɛ makpa mi mbla batsanɛ a. Kitonɛkĩ mikɔla safi a kĩ sabinya kadikanyi kɔla a. Mi mɔawɛ misĩ kĩ miáwo nɛ koe kamɛ ade miasua bikĩ babɔa mbɔdi kĩ bawo a lɛmɛ osi a!” ");
INSERT INTO bov_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kĩ Yesu dzakũ nɛ awã a, Farisifɔ mɔ Yudafɔ mbla batsanɛ yi fɔlɛtsa kavɛlɛ kayɔ mɔ Yesu mɔ ɔsĩ mɔ ɔsĩ, ade bɛkavia ye fɔlɛtsa nɛ fɔtsa pii akũ, ");
INSERT INTO bov_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bɛkabɔa mbɔdi kanaĩ kĩ bapi ye nɛ ye kɔdzɛla kalɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bati mpim mpim yakpɔta limii kĩ bɛkasumini akũ malo. Yesu nya lɔtɔ ebi ye fɔtsa bakɔlɛnɛ a kĩ, “Midã kadã wĩ paa nɛ Farisifɔ oyila fɔtsa a kĩ fɔnyɛ anɛ kamɛ kɛkɛ fɔtsa katsa a akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lɛtsa nyɛ lɛtsa kĩ bisua bido ni, baanyɛ de kanya, ade fɔlɛtsa kɔlawa fudi nyɛ fudi ni, bati aanu foe. ");
INSERT INTO bov_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Foesũ kalɛ nyɛ kalɛ kĩ bɛlɛ nɛ ɔtũ kamɛ ni, baanu ke mɔ suwa ketee ade kalɛ kĩ biwusa mido nɛ odi sɔtɔ kamɛ ni, baade lɛtsã nɛ ke akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nwaɛ̃ amɛ, mabi mi kĩ mitavila bikĩ baakɔ sukɛna lɛmɛ ke liti bɛláapuli bɛkɛna lɛtsama fɔba foe. ");
INSERT INTO bov_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Maatsa mi oti a kĩ kɛnɛ kĩ miavila. Mivila Baguma a kĩ ntɛ ɛkɔ bati eyua edeĩ kɔbɛ̃ kĩ yaata be edo nɛ fi kĩ fɔádĩ kamɛ. Mitɛ yĩ mido, ade ye nyɛ oti kĩ kɛnɛ kĩ miavila a. ");
INSERT INTO bov_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nnɛ́ kaplɛ nviã banɔ funitataɛ elo? Lɛmɛ Baguma lálɛla kamɔapɛ malo. ");
INSERT INTO bov_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mi lɔlɔ tɔlɔ malo bɛkã te flee, foesũ mitavila, kitonɛkĩ mitɛ kɔya mibɛ̃ funitataɛ beblebee. ");
INSERT INTO bov_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mabi mi yededeede kĩ odi nyɛ odi kĩ ɛlɛ nɛ bati anɛ kĩ ɛnyɛ yĩ ode ni, Otidziwa Obi lɛmɛ aakɛna lɔmɔ ɛkpa ye nɛ ode fɔtɔ banyanɛ a anɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lɛmɛ odi nyɛ odi kĩ esĩ yĩ nɛ bati anɛ ni, Otidziwa Obi lɛmɛ aasĩ ye nɛ ode fɔtɔ banyanɛ a anɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Odi nyɛ odi kĩ yaalɛ kalɛ kadi etia Otidziwa Obi ni, baakɔa bite ye, lɛmɛ odi nyɛ odi kĩ yaalɛ fubusuotsa nɛ Hũhũ Kpalɛwa akũ ni, bɛláakɔa bite ye da. ");
INSERT INTO bov_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Foesũ ntɛ bɛkpã mi banaadzɛmɔ mi nɛ Yudafɔ katsɛnakɔ̃, ĩye abãã banɔkɔɛ̃ anɛ ĩye fɔgã anɛ ni, mitaha akũ nɛ ayekĩ míapili mi lɔlɔ ĩye lɛtsa a kĩ míalɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kitonɛkĩ Hũhũ Kpalɛwa aatsa mi lɛtsa a kĩ míalɛ nɛ lɔkɔ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Onyole odi nɛ bati kɔdabu a kamɛ bi Yesu kĩ, “Fɔtsa Ɔtsanɛ, bi nwaɛ̃nyole ɛfɔ̃ bɔsɛ̃ boe ɔlɛga adzapadiɛ a kĩ ɛkɔa eyi boe a.” ");
INSERT INTO bov_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ade ke Yesu kpa ye mbuayɛ kĩ, “Nwaɛ̃, owei lɛkpa yĩ osi kĩ ndzɛ mi fɔlɛtsa ĩye nsɛ̃ adzapadiɛ nkpa mi bati nviã kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ade ebi be flee kĩ, “Midã kadã wĩ, lɔkɔa mipi mi akũ nɛ anɛngbã akũ, kitonɛkĩ oti nkpã lɛláa akũ fɔtsa kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ade Yesu bɔa be lɛgbã ɛlɛ kĩ, “Luwi a, osikani odi kĩ edzi tɔ̃ na tite kĩ yanyɛ funitsã wĩ nɛ te kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛlɛ nɛ ye kamɛ kĩ, ‘Nlá awã kĩ mako yĩ funitsã kĩĩ flee. Litsa maapuli nkɛna?’ ");
INSERT INTO bov_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ebi ye akũ kĩ, ‘Ade fukĩĩ maakɛna a. Maapansam yĩ tɛpata lɔkɔa nke tɛbaũbaũ awã kĩ maatɛɛ yĩ fugbanɔ mɔ yĩ fɔtsa bɛbã flee. ");
INSERT INTO bov_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lɔkɔa maabi yĩ ɔkla kĩ, “Ɔna lɔlɔ wĩ paa. Odeĩ fɔtsa wĩ kĩĩ flee kĩ fɔ́akpã nɔ nɛ futeli pii kamɛ. Dzi kawɛya, kanya, kamɔa, kamɔ kawɔlɛ.” ’ ");
INSERT INTO bov_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Lɛmɛ Baguma bi ye kĩ, ‘Ɔkɔasia! Lɛnyɛ mɔapɛ kĩĩ baatɛ nɔ nkpã nɛ nɔ awɛ, lɔkɔa owei aanya fɔtsa a kĩ ɔmanɛ oyi ɔkpa nɔ akũ a?’ ” ");
INSERT INTO bov_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ade Yesu wũna ɛlɛ kĩ, “Ade aye fɔla fɔkpa bikĩ a kĩ bɛmanɛ fɔtsa pii bɛkpa be akũ lɛmɛ bɛtátɛ kɔya nɛ Baguma anɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ke liti a, Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Foesũ mabi mi kĩ mitaha akũ nɛ lɛtsa a kĩ míanya midzi nkpã, ĩye lɛtsa a kĩ míasua akũ a akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Minyi kĩ nkpã tɛ kɔya ɛba funitsã, ade kutitse lɛmɛ tɛ kɔya kɔba tilima a. ");
INSERT INTO bov_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Midã anande, yaádu funitsã ade yaákpɔta funitsã lɛmɛ a. Ɛlá oli ĩye funitsã kakokɔ̃ lɛmɛ Baguma adɔɔla ye. Mi kɔ̃ mitɛ kɔya kɔlaa miba kɔvɔlabi. ");
INSERT INTO bov_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mi kamɛ owei aapuli ɛkɔa luwi mɔa ete nɛ ye nkpã fuwi akũ ntɛ eti ɛha ye akũ bo aye malo? ");
INSERT INTO bov_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ntɛ ɔláapuli ɔkɛna lɛtsama nɛ fɔtsa kabii kĩĩ akũ ni, nde sũ aha nɔ akũ nɛ fɔtsa bɛbã akũ? ");
INSERT INTO bov_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Midã ayekĩ flawasi abo anɛ. Fɔákɛna adzuma ade fɔánɔ tilima kakpa foe akũ a. Lɛmɛ mabi mi kĩ Lɛgã Salomo mɔ ye akũ kana fɔtsa a flee malo táhɛhɛ fɔlɛ kadã ndɛ nhuilɛ kĩĩ kamɛ fɔmɔa. ");
INSERT INTO bov_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Baguma akɛɛlɛ lupo kamɛ tuwĩ. Tuwĩ adza nviã, kunya tiku, lɔkɔa bipila te. Nde sũ Baguma lɛláadã kĩ ɛkpa mi lɛtsa a kĩ míasua akũ ɛba tuwĩ a? Mi katɛkado adã kabii koũ! ");
INSERT INTO bov_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Foesũ mitakaha akũ kɔlaa, mitakabu lɔlɔ kamɛ luwi daa nɛ lɛtsa a kĩ míanya mɔ likĩ míamɔa akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kitonɛkĩ bikĩ bɛtátɛ Baguma bido a, ade be adzi kabu lɔlɔ kamɛ nɛ fukĩĩ bamɛ odu akũ a. Mi Ɔlɛga nyina kĩ misĩ fɔtsa kĩĩ flee. ");
INSERT INTO bov_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mbom miwɛ Baguma lɛgãkanyakɔ̃ a akũ osi lɔkɔa yaakpa mi fɔtsa kĩĩ flee lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mi sukuloo a kĩ mitomɔ yĩ a, mitavila, kitonɛkĩ fɔnyɛ Baguma kawɛ kĩ yaakpa mi fudzikɔ̃ nɛ ye lɛgãkanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Minɔ mi akũ kana fɔtsa mikɔa foe sika a mite ahiãfɔ. Minɔ sika fuvulumi a kĩ fɔláakpeli a mikpa mi akũ, lɔkɔa mikɔla mi akũ kana fɔtsa nɛ ode lɛgãkanyakɔ̃ a. Awã naa, foe akũ lɛláatinya kitonɛkĩ oyekpanɛ lɛláapuli ɛta foe ade lupuka lidima lɛmɛ lɛláapuli libula foe kade a. ");
INSERT INTO bov_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kitonɛkĩ awã kĩ nɔ akũ kana fɔtsa sĩwa deĩ ni, ade awã nɔ ɔwɔlɛ lɛmɛ aana a. ");
INSERT INTO bov_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mina nɛ kukũmanɛ kamɛ mikpa lɛtsa nyɛ lɛtsa kĩ laaya, mido tɛtadiɛ mikpa adzuma kakɛna lɔkɔa mifɔ̃ mi tɛsɛdza tɛkaatɛ̃, ");
INSERT INTO bov_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ndɛ basumunɛ kĩ bidzi badzɔlɛ be Ɔlate kamuniki kato obolitsɔ̃ kapikɔ̃ kaya. Ntɛ ɛyabɔa opunu ni baabinya bɛkpa ye mɔatsɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kawɔlɛ aade basumunɛ ntɛ be Ɔlate a yamɔ kĩ bɛmanɛ akũ bidzi badzɔlɛ ye kaya. Mabi mi kĩ yaakɔa ye lima efili nɛ kate, ɛfɔ̃ bidzi lɔkɔa ɛsɛ̃ funitsã ɛkpa be bɛnya. ");
INSERT INTO bov_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kawɔlɛ aade bikĩ baana nɛ kukũmanɛ kamɛ titiliwu ntɛ ɛya nɛ lɛnyɛ kayite ĩye odenyinawi. ");
INSERT INTO bov_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ade minyina kĩ ntɛ tɔtɔ ɔlate a enyi lɔkɔ a kĩ oyekpanɛ aya ni, kufɛ ɛláakpa ye osi ebubuli ye kɔla ewo. ");
INSERT INTO bov_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ade ayea kɛnɛ kĩ mi malo mina nɛ kukũmanɛ kamɛ a, kitonɛkĩ Otidziwa Obi aaya nɛ lɔkɔ a kĩ miláate anɛ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ade Petro via Yesu kĩ, “Boe Ɔlate, boe odi ɔbɔa lɛgbã kĩĩ ɔkpa mbɔɛɛ kĩ latamɔ odi nyɛ odi?” ");
INSERT INTO bov_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu kpa mbuayɛ kĩ, “Owei nyɛ osumunɛ ɔnɔkɔalini mɔ kadi onyinɛ? Ade ye nyɛ ekĩ ye ɔlate kɔa ɛdzɛla kĩ ɛkaadã tɔtɔ akũ, ɛkpa basumunɛ bɛbã a funitsã nɛ lɔkɔ wĩ akũ. ");
INSERT INTO bov_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kawɔlɛ aade osumunɛ a kĩ ye ɔlate ayamɔ ye kĩ ɛlamɛna fukĩĩ kakɛna! ");
INSERT INTO bov_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɔnɔkɔali, mabi mi kĩ Ɔlate a aakɔa osumunɛ kĩĩ ɛdzɛla nɛ ye fɔtsa a kĩ edeĩ flee a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lɛmɛ ntɛ osumunɛ a bi ye akũ kĩ, ‘Yĩ ɔlate buna owi nɛ osi akũ.’ mɔ eyi ye bakɔba basumunɛ batsole mɔ banyole kabo kayɔ, kanya pɔtɔɔ, kamɔa bavɛ kawuga lɛmɛ ni, ");
INSERT INTO bov_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ye ɔlate ayafuta ye luwi mɔa nɛ lɔkɔ a kĩ ɛtáte anɛ ĩye ɛláanyi kamɛ. Ɔlate a aavɛlɛ ye sɔtɔ mɔ ɔsĩ mɔ ɔsĩ ndɛ bikĩ bideĩ atɔ ɔsĩ aye. ");
INSERT INTO bov_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Osumunɛ a kĩ enyina ye adzuma kĩ ye ɔlate kpa ye lɛmɛ ɛtámanɛ akũ ɛkpa foe kakɛna ni, yaatɛ sɔtɔ kavɛlɛ mɔ ɔsĩ paa. ");
INSERT INTO bov_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lɛmɛ osumunɛ kĩ enyína lɛtsa kĩ ye ɔlate awɛ, lɛmɛ ɛkɛna lɛtsa kĩ a lɛfɛta sɔtɔ kavɛlɛ ni, baavɛlɛ ye sɔtɔ sukuloo. Oti kĩ bɛkɔa fɔtsa pii bido nɛ ye awɛ ni, baavia foe pii bitomɛna ye awɛ. Ade oti kĩ bɛkɔa fɔtsa pii kĩ fublusu bido nɛ ye awɛ ni, baavia foe pii kĩ fublusu bitomɛna ye awɛ. ");
INSERT INTO bov_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nkɔa kadani vɔɛ̃ kĩ fɔnyɛ fi ĩyaatɛna nɛ katinya kamɛ ade nwɛ kĩ kufɛ fi a fuyi katɛ̃ kayɔ kɔkɔɛ a. ");
INSERT INTO bov_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ndeĩ mui kawɔla lubo kamɔ adi kĩ maatɛ ade ke fɔ́akaha yĩ ɔwɔlɛ flee kɛnaawo luwi a kĩ lubo kamɔ a atɛ̃ nɛ yĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Miakɔna kĩ lukudɔ nkɔa ĩyamɛna nɛ katinya kamɛ mbɔɛɛ? Oowo! Nnɛ́ lukudɔ mbom ɔdzɛ mɔ kasɛ̃ ĩyamɛna. ");
INSERT INTO bov_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kito finyaa kanaa a, tɔtɔ kĩ bati elo deĩ nɛ te kamɛ ni, kasɛ̃ aaya nɛ be kamɛ. Be ɛlalɛ ayidza bɛdza nɛ be nviã akũ ade be nviã aayidza bɛdza nɛ be ɛlalɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Babilɛga aayidza bɛdza nɛ be babinyole akũ, ade babinyole aayidza bɛdza nɛ be balɛga akũ a. Babima aayidza bɛdza nɛ be babitsole akũ ade babitsole aayidza bɛdza nɛ be bama akũ a. Nyina amɛ aayidza bɛdza nɛ be babi batsɔ̃ akũ ade babi batsɔ̃ aayidza bɛdza nɛ be nyina amɛ akũ a.” ");
INSERT INTO bov_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu buki ebi bati a kĩ, “Ntɛ mimɔ́ kĩ oni dza nɛ suwa katomukɔ̃ ni mialɛ kĩ oni aako, ade yako lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ade ke ntɛ mimɔ́ kĩ ɔwɛ bɔa eto kayɔ sɛmakɛ ni, mialɛ kĩ ovio ya, ade fɔaya lɔmɔ a. ");
INSERT INTO bov_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mi anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ, miapuli kadã tite mɔ odetɔ́ kamɛ kamɔ kalɛ lɛtsa a kĩ laaya. Nde sũ miápuli minyɛ nviã lɔkɔ kĩĩ kayɔ? ");
INSERT INTO bov_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nde sũ miápuli mike otse mikpa mi akũ nɛ lɛtsa wĩ a kĩ kɛnɛ kĩ mikɛna akũ? ");
INSERT INTO bov_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ntɛ odi bɔɛ kalɛ nɛ nɔ akũ ni, tsã osi nyɛ osi akũ mimɔ ye milɛ foe fɔmɔ yanaadza nɛ fɔlɛtsa kadzɛkɔ̃. Ntɛ nnɛ́ aye ni yaavɛlɛ nɔ ɛma fɔlɛtsa ɔdzɛnɛ ade ye malo yaakɔa nɔ ɛkpa polisifɔ bɛnaado nɔ nɛ kɔla a. ");
INSERT INTO bov_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mabi nɔ kĩ ade awã aana flee kɛnaawo lɔkɔ a kĩ ose kɔtɔ a flee oyua a.” ");
INSERT INTO bov_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","1 Lɔkɔ a na kamɛ a, bati badi yakpa Yesu kanyi kĩ Pilato kɔ Galileafɔ badi nɛ lɔkɔ a kĩ bɛkabɔa afɔliɛ nɛ Asɔli Kɔla kamɛ nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kpa mbuayɛ kĩ, “Mikɔna kĩ Galileafɔ a kĩ bɛkɔ a tɛnɛ titikpa kakɛna kaba Galileafɔ bɛbã flee a sũ? ");
INSERT INTO bov_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oowo, nnɛ́ aye kɔlaa! Mabi mi kĩ ntɛ mitádani tɔwɔlɛ kamɛ ni, mi a flee míaku ndɛ be aye. ");
INSERT INTO bov_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nde nyɛ bati ewua-alɛ̃ a kĩ Siloam kɔla gɛlɛɛlɛ veli kɔkɔ be a? Mikɔna kĩ be nyɛ titikpa bakɛnanɛ bɛba bikĩ nɛ Yerusalem flee a? ");
INSERT INTO bov_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Oowo! Nnɛ́ aye fɔla kɔlaa! Mabi mi kĩ ntɛ mitádani tɔwɔlɛ kamɛ ni, míaku ndɛ be aye.” ");
INSERT INTO bov_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ade Yesu bɔa be lɛgbã ɛlɛ kĩ, “Lɔkɔ lidi onyole odi du atɔ kutse nɛ ye kɔba kamɛ. Ɛkasɛla kadã ntɛ yaana atɔ babi nɛ koe akũ lɛmɛ ɛtána badima. ");
INSERT INTO bov_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ade ke ebi ekĩ yadãmɛna kɔba akũ kĩ, ‘Dã! Ade futeli ɛlalɛ mɔa flee kĩ maya nɛ awĩ kayaawɛ kutse kĩĩ babi lɛmɛ maámɔ badima. Tsua koe kamuni. Nde sũ kɔadza kɔkabula tite a kade?’ ");
INSERT INTO bov_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Lɛmɛ kɔba akũ ɔdãmɛnanɛ a kpa mbuayɛ kĩ, ‘Ɔnɔkɔɛ̃, fɔ̃ kɔdza, kpa yĩ kateli mɔa kabu. Maatu nsinya koe lɔkɔa nko fɔtsa a kĩ fɔ́akpa koe tite kanɔ. ");
INSERT INTO bov_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ntɛ kuwũ atɔ babi kateliva ni, kekɔ̃ fɔnɛnɛ. Lɛmɛ ntɛ kɔtáwũ babi ni, aapuli ɔfɔ̃ bitsua koe bimuni.’ ” ");
INSERT INTO bov_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nɛ Kawɛya Luwi lidi akũ ni, Yesu katsa fɔtsa nɛ Yudafɔ katsɛnakɔ̃ kadi. ");
INSERT INTO bov_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Otsole odi kĩ hũhũ kpa do ye fɔsɔ mɔ akũ futeli ewua-alɛ̃ flee na nɛ awã. Fɔsɔ a fɔ̃ ekũũkũ ebuki yaápuli eyo akũ kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kĩ Yesu mɔ ye a ɛvɛ ye ebi ye kĩ, “Boe ɔma, bɛnyɛ nɔ nɛ fɔsɔ kamɛ!” ");
INSERT INTO bov_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu kɔa awɛ ete nɛ ye akũ. Lɛtalɛta otsole a puli eyo akũ kpĩĩ ade ke emu Baguma a. ");
INSERT INTO bov_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɔnɔkɔɛ̃ a kĩ yadãmɛna Yudafɔ katsɛnakɔ̃ a na kalɔkpa paa kĩ Yesu tsa ɔsɔnɛ nɛ Kawɛya Luwi akũ, foesũ ebi bati a kĩ, “Fuwi evũ deĩ kĩ foe kamɛ kɛnɛ kĩ bɔkɛna adzuma. Foesũ miya nɛ fuwi kĩĩ kamɛ bɛtsa mi fɔsɔ, lɛmɛ nnɛ́ nɛ Kawɛya Luwi a akũ!” ");
INSERT INTO bov_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Boe Ɔlate kpa ye mbuayɛ kĩ, “Mi anɛ kamɛ kɛkɛ fɔtsa bakɛnanɛ, mianyɛ mi bayaɛ tɔwɛ̃ banaamɔa mui nɛ Kawɛya Luwi akũ. ");
INSERT INTO bov_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Finyaakĩĩ amɔ Abraham kasinu kamɛ obi kĩ Abonsam do ye fɔsɔ mɔ akũ futeli ewua-alɛ̃ flee. Fɔnɛ́nɛ kĩ banyɛ ye nɛ tɔwɛ̃ kamɛ nɛ Kawɛya Luwi a akũ?” ");
INSERT INTO bov_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mbuayɛ a kĩ Yesu kpa a fɔ̃ kɔnyɔã wo ye bakesĩnɛ a, lɛmɛ kawɔlɛ de bati a nɛ awãwã fɔtsa flee a kĩ ɛkɛna a sũ. ");
INSERT INTO bov_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ade Yesu via kĩ, “Nde Baguma lɛgãkanyakɔ̃ a la? Litsa maakɔa nkɔnamɔ de? ");
INSERT INTO bov_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Fɔla ndɛ fudutsa libi kabii ki onyole odi bɔɛ ɛnadu nɛ ye kɔba. Libi a mɛ libo anɛ lɛkɛna kutse, ade kɔvɔlabi yakɛna fɔtsɔɛ nɛ koe tɛnanɛ kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu buki evia kĩ, “Litsa maakɔa Baguma lɛgãkanyakɔ̃ a nkɔnamɔ? ");
INSERT INTO bov_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Fɔla ndɛ ayekĩ otsole kɔa oyila fɔtsa ɛtsɛka nɛ bodobodo onuvoe baũ kamɛ, fɔna flee kɛnawo kĩ evuya puu.” ");
INSERT INTO bov_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lɔkɔ a kĩ Yesu anaa Yerusalem a, ɛnatsã tɛmatɔ mɔ tukula kamɛ ɛkatsa bati fɔtsa. ");
INSERT INTO bov_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ade odi via ye kĩ, “Boe Ɔlate, mbɔɛɛ bati sukuloo aana katɛ?” Yesu kpa ye mbuayɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bɔa mbɔdi katsã onyukpɛ̃ a kĩ ɛtása a kamɛ kawo, kitonɛkĩ bati pii abɔa mbɔdi kĩ bawo lɛmɛ bɛláapuli. ");
INSERT INTO bov_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kɔla ɔlate a aayidza ɛyaabalɛ kɔla a, ade ntɛ midza nɛ kanya mikabɔa opunu kalɛ kĩ, ‘Boe Ɔlate, binya kakpa boe ni.’ “Ɔlate a aakpa mbuayɛ kĩ, ‘Ĩnyína mi mɔ awã kĩ mito!’ ");
INSERT INTO bov_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ade ke míalɛ kĩ, ‘Bɔmɔ nɔ lɛnya bɔmɔa ade ɔtsa fɔtsa nɛ boe ɔmatɔ kamɛ lɛmɛ a!’ ");
INSERT INTO bov_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Lɛmɛ yaakpa mbuayɛ kĩ, ‘Ĩnyína awã kĩ mito! Midzakũ nɛ yĩ ɔwɛ̃, mi tɔkpa bakɛnanɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Awã naa, kabe kadi kĩ míabe, miba adɔ̃ ntɛ mimɔ́ Abraham, Isak mɔ Yakob mɔ Baguma onukpɛ̃ banyɛnɛ a flee nɛ ode lɛgãkanyakɔ̃ a kamɛ, lɛmɛ mi kɔ̃ bɛblɔmɛna mi kĩ mitawo. ");
INSERT INTO bov_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bati aato suwa kadekɔ̃ mɔ suwa katomukɔ̃, kayɔ mɔ nyangɛ bɛyaanya bɛmɔa nɛ ode lɛgãkanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ade bati a kĩ bɛkpa liti finyaa a, badi aadani batɔnyade, ade bikĩ bɛnyaa lɔtɔ finyaa a, badi aadani liti bakpanɛ.” ");
INSERT INTO bov_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nɛ lɔkɔ a na kamɛ a, Farisifɔ badi yabi Yesu kĩ, “Wɛ sɔwa kadzakũ nɛ awĩ kĩĩ kanaa kakɔ bɛbã, kitonɛkĩ lɛgã Herodes wɛ kĩ yaakɔ nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ade ke Yesu bi be kĩ, “Minaabi kalikii a kĩ, ‘Nviã mɔ kunya flee maakablɔmɛna hũhũ kpa, maatsa fɔsɔ lɛmɛ, ade nɛ luwi lɛlalɛde a akũ ni, maayua yĩ adzuma.’ ");
INSERT INTO bov_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lɛmɛ kɛnɛ kĩ mpi osi, nviã, kunya mɔ kukunya, kitonɛkĩ fɔtáfɛta kĩ bakɔ Baguma onukpɛ̃ ɔnyɛnɛ nɛ kakɔma kɛba Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem! Nɔ bati kɔ Baguma onukpɛ̃ banyɛnɛ a ade bɛtalɛ bikĩ Baguma do nɛ nɔ sɛkɛ̃ a boe bɛkɔ be a. Titi eni ntáwɛ kĩ makpɔta nɔ babi ndɛ ayekĩ ɔkɔkɔbima api ye babi kado nɛ ye fupoki kayɔ, lɛmɛ ɔtákpa yĩ osi. ");
INSERT INTO bov_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɛ foesũ finyaa nɔ Asɔli Kɔla aawaa luto. Ade mabi mi kĩ miláabuki mimɔ́ yĩ kɛnaawo lɔkɔ a kĩ míalɛ kĩ, ‘Baguma hila ekĩ yaya nɛ boe Ɔlate dĩ akũ a!’ ” ");
INSERT INTO bov_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nɛ Kawɛya Luwi lidi akũ ni, kĩ Yesu naanya nɛ Farisifɔ ɔnɔkɔɛ̃ odi awã a, bati a ko anɛ bɛkadã ye. ");
INSERT INTO bov_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Onyole odi kĩ ye akpɔ mɔ abɔa wumi dzi nɛ ye anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ade ke Yesu via Farisifɔ mɔ mbla batsanɛ a kĩ, “Boe mbla kpa osi kĩ bɛtsa oti nɛ Kawɛya Luwi akũ mbɔɛɛ kĩ ɛtákpa osi?” ");
INSERT INTO bov_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lɛmɛ bisĩ bɛtákpa ye mbuayɛ. Ade Yesu ta oti a ɛtsa ye, ɛnyɛ ye osi ɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ade ɛdani ebi be kĩ, “Ntɛ mi kamɛ odi obi ĩye ɔnantsue tɔ mui lɛkɛ nɛ Kawɛya Luwi akũ ni, miáwɛ sɔwa kanaanyɛ ye nɛ lɛkɛ a kamɛ?” ");
INSERT INTO bov_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lɛmɛ bɛtápuli bɛkpa ye foe mbuayɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kĩ Yesu mɔ́ ayekĩ bati a kĩ bɛvɛ nɛ kanyakɔ̃ kawãnɛ banɔkɔɛ̃ fudzikɔ̃ a, ɛbɔa be lɛgbã kĩĩ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ntɛ odi vɛ nɔ nɛ obolitsɔ̃ kapikɔ̃ ni, tanaadzi nɛ banɔkɔɛ̃ kadzikɔ̃, kitonɛkĩ fɔ́apuli fɔya kĩ ɛvɛ odi kĩ edeĩ obu ɛbɛ̃ nɔ, ");
INSERT INTO bov_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","lɔkɔa oti a kĩ ɛvɛ mi bati nviã ayabi nɔ kĩ, ‘Kɔa nɔ lukpo kakpa oti kĩĩ’ ade ke aakɔa kɔnyɔã oyidza ɔnaadzi nɛ kakɔ nkaɛ a. ");
INSERT INTO bov_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mbom ntɛ bɛvɛ nɔ nɛ kakɔ kadi ni, naadzi nɛ kakɔ a kĩ kɛtátɛ kɔya, ayekĩ ntɛ ekĩ ɛvɛ nɔ a yamɔ nɔ ni, yaabi nɔ kĩ, ‘Ɔkɔba, yidza kanaadzi nɛ awã kĩ kɛtɛ kɔya a.’ Awã naa bati bɛbã flee a kĩ bɛvɛ a aakɔa obu bɛkpa nɔ, ");
INSERT INTO bov_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","kitonɛkĩ odi nyɛ odi kĩ ɛdɛla ye akũ nɛ ode ni, baakɛna ye nɛ kayɔ, ade odi nyɛ odi kĩ ɛdɔla ye akũ ni, baadɛla ye nɛ ode!” ");
INSERT INTO bov_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ade Yesu bi oti a kĩ ɛtsɛlamɔ ye nɛ kanyakɔ̃ a kĩ, “Ntɛ ote opunu ɔkpa bati ni, tavɛ nɔ bakɔba, awaɛ̃ amɛ, nɔ kɔla babi ĩye nɔ badzi kɔba a kĩ bideĩ akũ a, ayekĩ baavɛ nɔ malo ɔnaanya nɛ be sɛkɛ̃ bise kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mbom ntɛ ate opunu ni, vɛ ahiãfɔ, bikĩ bɛnɛ lɛkpɛ̃, bikĩ biveliveli mɔ banɛkunɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Fukĩĩ aafɔ̃ Baguma lihila nɔ kusɛkusɛ, kitonɛkĩ bɛláapuli bise nɔ foe kɔtɔ. Lɛmɛ Baguma aase nɔ kɔtɔ nɛ luwi a kĩ bati wĩ aayidza bito kanɔkpa a.” ");
INSERT INTO bov_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kĩ bati a kĩ bidzi nɛ opunu akũ bɛkanya kamɛ ɔmɔa nu fɔlɛtsa a kĩ Yesu lɛ a, ebi ye kĩ, “Kawɔlɛ aade bati a kĩ baadzi nɛ opunu akũ nɛ ode lɛgãkanyakɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu bi ye kĩ, “Luwi a onyole odi te opunu ɛvɛ bati beblebee. ");
INSERT INTO bov_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kĩ kanya lɔkɔ wo ɔtɔ a edo ye osumunɛ kĩ ɛnaavɛ bikĩ ɛtsɛlamɛna a kĩ, ‘Miya. Buyua Lɛtsa nyɛ lɛtsa!’ ” ");
INSERT INTO bov_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Lɛmɛ bati a kĩ ɛtsɛlamɛna a flee kamɛ odi nyɛ odi nyɛ onukpɛ̃. Oti ɔtɔnyade bi osumunɛ a kĩ, ‘Nnaya tite finyaa, foesũ kɛnɛ kĩ nnaadã te, make nɔ aduli nláapuli ĩya.’ ");
INSERT INTO bov_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Oti bɛbã lɛmɛ lɛ kĩ, ‘Ĩya banantsue ewua, kĩ kɛnɛ kĩ nkpã be nnaasɔ be ndã ntɛ baapuli bɛkɛna adzuma kakɛna wĩ. Makɛ nɔ aduli, nláapuli ĩya.’ ");
INSERT INTO bov_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Oti bɛbã lɛmɛ lɛ kĩ, ‘Wɔadzɔ nkɔã ɔtsɔ̃, foesũ nláapuli ĩya.’ ");
INSERT INTO bov_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Osumunɛ a muniki ɛnabi ye ɔlate lɛtsa a kĩ lɛya a flee. Awã naa ɔlate a na kalɔkpa paa ade ebi ye osumunɛ a kĩ, ‘Wɛ sɔwa kanaa tɔblɔnu mɔ fɔla fuyite nɛ ɔmatɔ a kamɛ, kakpã ahiãfɔ, lɛkpɛ̃ banɛnɛ, banɛkunɛ mɔ bikĩ biveliveli a kayamɛna.’ ");
INSERT INTO bov_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Owi tábuna mɔ osumunɛ a yabi ye kĩ, ‘Yĩ ɔlate nkɛna nɛ nɔ ɔlɛdo akũ, lɛmɛ fudzikɔ̃ buki fute.’ ");
INSERT INTO bov_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ade ke ɔlate a bi ye kĩ, ‘Naa tɔblɔnu mɔ fusikũ akũ nɛ tukula kamɛ, kabi be kĩ bɛya ayekĩ kɔla a kamɛ aayi. ");
INSERT INTO bov_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mabi mi a flee kĩ, bikĩ be ĩnya lɔtɔ nvɛ a kamɛ odima lɛláata yĩ funitsã a onukpɛ̃!’ ” ");
INSERT INTO bov_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Luwi a, kĩ bati kɔdabu tomɔ Yesu a, ɛdani ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ntɛ odi ya nɛ yĩ sɛkɛ̃, mɔ yawɛ ye ɔlɛga, ɔma, ɔtsɔ̃, babi, bawaɛ̃nyole mɔ bawaɛ̃tsole, mɔ ye mɔawɛ akũ kalɛ kaba yĩ ni, ɛláapuli ɛnya yĩ fɔtsa ɔkɔlɛnɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Odi nyɛ odi kĩ ɛtábɔɛ ye asendua ɛlɔ etomɔ yĩ ni, ɛláapuli ɛnya yĩ fɔtsa ɔkɔlɛnɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ntɛ mi kamɛ odi awɛ kĩ yake kɔla baũ kudi ni, yaánya lɔtɔ kadzi kabu kɔla a kake akũ akunta kadã, kamɔ ntɛ yaana sika epuli eke kɔla a ewũna? ");
INSERT INTO bov_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ntɛ ɛtákɛna foe lɔmɔ ni, ɛláapuli eyua kɔla a titɔ kĩ eke kayɔkayi futekũ malo. Ade ke bati flee a kĩ bamɔ foe a aadi ye nsekuo bɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Oti kĩĩ yi kɔla kake kayɔ lɛmɛ ɛtápuli eke koe ewũna.’ ");
INSERT INTO bov_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ntɛ lɛgã lidi aabɔɛ kawũ nɛ lɛgã bɛbã akũ ni, yaanya lɔtɔ edzi ɛkɔna foe akũ ɛdã ntɛ yaapuli ɛkɔa sodzafɔ mpim ewua ɛnya lɛgã bɛbã a kĩ lideĩ sodzafɔ mpim tɛya a akũ. ");
INSERT INTO bov_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ntɛ ɛláapuli ni, yaanya lɔtɔ edo batɔ nɛ lɛgã kĩ a sɛkɛ̃ nɛ lɔkɔ a kĩ bɛtáfuã akũ lɔkɔa ɛkpa lɔlɔ.” ");
INSERT INTO bov_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu lɛ ewũna kĩ, “Ade aye mi kamɛ odima lɛláapuli ɛnya yĩ fɔtsa ɔkɔlɛnɛ ntɛ ɛtáfɔnɛ ye lɛtsa nyɛ lɛtsa kĩ edeĩ awɛ a. ");
INSERT INTO bov_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Lɛdɛmɛ nɛnɛ, lɛmɛ ntɛ lɛyɛla de ɔmɛnɛ ni, osi odima lɛláa kĩ aatsã ye akũ obuki odo de ɔmɛnɛ. ");
INSERT INTO bov_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lɛnɛ́nɛ lɛkpa ndɛ tite kanɔ, ĩye lɛkpa fukluku kawulakɔ̃ malo. Kata bata de kawula. “Okĩ edeĩ atɔ ni, etse katse wĩ!” ");
INSERT INTO bov_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Luwi a, tɔgɔlɛ batɛnɛ mɔ tɔkpa bakɛnanɛ bɛbã ya nɛ Yesu sɛkɛ̃ bɛyaatse ye fɔlɛtsa. ");
INSERT INTO bov_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nɛ awã naa, Farisifɔ mɔ mbla batsanɛ a kakɛna hũhũhũhũ kalɛ kĩ, “Oti kĩĩ atɛ tɔkpa bakɛnanɛ ade yado awɛ kanya mɔ be malo a!” ");
INSERT INTO bov_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Foesũ Yesu bɔa be lɛgbã kĩĩ kĩ, ");
INSERT INTO bov_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ntɛ mi kamɛ odi ɔmɔa deĩ baveli ɔha mɔ kɔmɔa yɛla nɛ be kamɛ a, litsa yaakɛna? Yaafɔnɛ baveli aduekrɔũ-evedi a nɛ kanyakɔ̃ a ɛnaatsã ɛwɛ kukĩ kɔyɛla a kɛnaawo kĩ ɛmɔ koe. ");
INSERT INTO bov_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ntɛ ɛmɔ koe a, yaamɔ kawɔlɛ paa lɔkɔa ɛbɔɛ koe ete nɛ lɔbɔtɛɛ ɛyamɛna nɛ kɔla. ");
INSERT INTO bov_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ade yaavɛ ye bakɔba mɔ banunɛ ebi be kĩ, ‘Kawɔlɛ de yĩ kĩ mmɔ́ yĩ kuveli a kĩ kɔyɛla a, foesũ mifɔ̃ bɔmɔ́ kawɔlɛ!’ ");
INSERT INTO bov_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mabi mi kĩ ade aye baamɔ kawɔlɛ nɛ ode lɛgãkanyakɔ̃ a nɛ oti mɔa kĩ ɛdani ɔwɔlɛ kamɛ akũ, kɛba bati aduekrɔũ-evedi kĩ be akũ kpalɛ kĩ bɛtásĩ ɔwɔlɛ kamɛ kadani. ");
INSERT INTO bov_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ntɛ otsole odi deĩ sika ovoe babi ewua mɔ ɛyɛla libi mɔa ni, litsa yaakɛna? Yaatɛna ɔsɛdza ɛyɔ kɔla kamɛ ɛdã kakɔ nyɛ kakɔ yededeede kɛnawo kĩ ɛmɔ sika libi a. ");
INSERT INTO bov_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ntɛ ɛmɔ de a, yaavɛ ye bakɔba mɔ banunɛ ɛkpɔta ebi be kĩ, ‘Kawɔlɛ de yĩ paa kitonɛkĩ mmɔ́ yĩ sika libi a kĩ lɛyɛla a. Mifɔ̃ bɔmɔ́ kawɔlɛ!’ ");
INSERT INTO bov_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mabi mi kĩ ade aye Baguma ode fɔtɔ banyanɛ aamɔ kawɔlɛ nɛ tɔkpa ɔkɛnanɛ mɔa kĩ ɛdani ɔwɔlɛ kamɛ akũ a.” ");
INSERT INTO bov_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu lɛ ɛnaa lɔtɔ kĩ, “Onyole odi na babinyole nviã. ");
INSERT INTO bov_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ade obisɛ̃de a bi ɔlɛga kĩ, ‘Papa, kɔa adzapadiɛ a kĩ yaanya yĩ kanyakɔ̃ a kakpa yĩ finyaa.’ Foesũ onyole a sɛ̃ ye adzapadiɛ kamɛ ɛkpa ye babinyole nviã a. ");
INSERT INTO bov_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nɛ fuwi fudi liti ni, obisɛ̃de a nɔ ye kanyakɔ̃ fɔtsa a flee ade ɛdzakũ mɔ foe sika a. Ɛnaa katide mɔ lugo ɛnabula sika a kade nɛ nkpã basabasa kadzi kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ebula lɛtsa nyɛ lɛtsa kĩ edeĩ a kade. Ke liti a kɔlɛ kudi nɛ nɛ tite a na flee akũ ade ohiã pi ye a. ");
INSERT INTO bov_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɛ foesũ ɛnaa onyole odi nɛ tite a akũ sɛkɛ̃ kĩ yanaakɛna adzuma ɛkpa ye. Onyole a kpa ye baplakuo akũ kadãmɛna nɛ ye kɔba. ");
INSERT INTO bov_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nɛ kɔlɛ sũ ɛwɛ kĩ yanya funitsã a kĩ bɛkako baplakuo a fudi lɛmɛ odima tákpa ye lɛtsama. ");
INSERT INTO bov_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nɛ ke kawũna a, ɛyamɔ ye akũ eyi ɔsũ, ade ɛlɛ kĩ, ‘Bati a kĩ nda bɔɛ bakɛna tudzuma a ana kanya kawĩ pɔtɔɔ fɔate malo. Amɔ yĩ dzi nɛ awĩ kɔlɛ ayua yĩ kakɔ. ");
INSERT INTO bov_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maayidza nnaa nda sɛkɛ̃ nnaabi ye kĩ, “Papa, nkɛna tɔkpa nɛ Baguma mɔ nɔ akũ. ");
INSERT INTO bov_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ntáfɛta kĩ abuki ɔvɛ yĩ kĩ nɔ obi, mbom kɔa yĩ kakɛna ndɛ nɔ tudzuma bakɛnanɛ a kamɛ ɔmɔa.” ’ ");
INSERT INTO bov_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Foesũ eyidza epi osi yanaa ɔlɛga sɛkɛ̃. “Ɔlɛga mɔ́ ye mɔ lugo kĩ yaya. Obi akũ kɔ ye kɔnya ade ewula atsɛ ɛnatu eboomu ye a. ");
INSERT INTO bov_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ade ke obi a bi ye kĩ, ‘Papa, nkɛna tɔkpa nɛ Baguma mɔ nɔ akũ. Ntáfɛta kĩ abuki ɔvɛ yĩ kĩ nɔ obi.’ ");
INSERT INTO bov_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Lɛmɛ ɔlɛga a vɛ ye basumunɛ a ebi be kĩ, ‘Miwɛ sɔwa mibɔɛ tɛtadiɛ kĩ tɛnɛnɛ paa mido ye. Mido ye lipetia nɛ lawobi mɔ mpabua nɛ abɔa. ");
INSERT INTO bov_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ke liti ni, minaanyɛ ɔnantsue kĩ ɛdɔli paa mikɔ, lɔkɔa bɔnya bɔmɔ́ kawɔlɛ. ");
INSERT INTO bov_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kitonɛkĩ bɔbɔɛ foe kĩ yĩ obi kĩĩ ku lɛmɛ finyaakĩĩ edzi nkpã. Ɛyɛla lɛmɛ bɛmɔ́ ye.’ Foesũ biyi luwi a kanya kayɔ. ");
INSERT INTO bov_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nɛ lɔkɔ kĩĩ kamɛ a, obinyolenɔkɔɛ̃ a na nɛ kɔba. Kĩ eto yade, efuã tɔtɔ kamɛ a, enu tɔnɔ mɔ kuto nkã. ");
INSERT INTO bov_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Foesũ ɛvɛ basumunɛ a kamɛ ɔmɔa evia ye kĩ, ‘Litsa lámɔ kaya nɛ tɔtɔ kamɛ?’ ");
INSERT INTO bov_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Osumunɛ a kpa ye mbuayɛ kĩ, ‘Awaɛ̃ muniki ɛya nɛ ɔtɔ ade ke aga fɔ̃ bɛkɔ ɔnantsue dɔliwa a, kitonɛkĩ emuniki ɛya mɔ akũ ɔsĩ.’ ");
INSERT INTO bov_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tuwũna ba ɔnɔkɔɛ̃de a, ade esĩ kĩ yaáwo nɛ tɔtɔ kamɛ, foesũ ɔlɛga naa ye sɛkɛ̃ ɛnake ye aduli kĩ ewo ɛya nɛ tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lɛmɛ obi bi ɔlɛga kĩ, ‘Dã, nkɛna adzuma ndɛ ɔsate nɛ futeli pii kĩĩ kamɛ nkpa nɔ, kĩ ntáyidza ndza nɛ nɔ akũ da. Ade ɔtákpa tɔ̃ yĩ midi katukpabi malo kĩ nkɔ bɔmɔ yĩ bakɔba bɔmɔ́ kawɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lɛmɛ nɔ obi kĩĩ nabula nɔ akũ kana fɔtsa flee kade nɛ adɔpaafɔ akũ ade kĩ emuniki ɛya ni, ɔkɔ ɔnantsue dɔliwa akpa ye!’ ");
INSERT INTO bov_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Awã naa, ɔlɛga bi ye kĩ, ‘Yĩ obi, odeĩ nɛ yĩ sɛkɛ̃ luwi daa, ade lɛtsa nyɛ lɛtsa kĩ ndeĩ a, nɔ lide lanɛ. ");
INSERT INTO bov_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lɛmɛ kɛnɛ kĩ bɔanya luwi bɔmɔ́ kawɔlɛ, kitonɛkĩ bɔbɔɛ foe kĩ awaɛ̃ kĩĩ ku lɛmɛ finyaa edzi nkpã, ɛyɛla lɛmɛ bɔmɔ́ ye.’ ” ");
INSERT INTO bov_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Osikani odi na adzuma ɔkɛnanɛ kĩ edzi nɛ ye tudzuma onukpɛ̃. Bati yabi osikani a kĩ ye tudzuma onukpɛ̃ ɔdzanɛ a abula ye sika kade. ");
INSERT INTO bov_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Foesũ osikani a vɛ tudzuma onukpɛ̃ ɔdzanɛ a evia ye kĩ, ‘Litsa fɔlɛtsa manu kĩ balɛ nɛ nɔ akũ a? Kɛna akunta yededeede nɛ ayekĩ ɔnɛɛ yĩ tudzuma akũ, kitonɛkĩ ɔláapuli obuki ɔnya yĩ fɔtsa akũ ɔdãmɛnanɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ade ke tudzuma akũ ɔdãmɛnanɛ a bi ye akũ kĩ, ‘Yĩ ɔlate aablɔmɛna yĩ nɛ adzuma kamɛ. Litsa maakɛna? Nlá kɔbɛ̃ kĩ maatu tɔbɔnkam ade ke kɔnyɔã akɔ yĩ mɔ fɔtsa kawã lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ahãã! Ĩnyina lɛtsa a kĩ maakɛna. Ntɛ adzuma nɛ́ nɛ yĩ awɛ ni, maana bakɔba kĩ baatɛ yĩ mɔ kawɔlɛ nɛ be awã!’ ");
INSERT INTO bov_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Foesũ ɛvɛ bati a kĩ bidzimɔ ye ɔlate fɔtɔ a. Evia ɔtɔnyade a kĩ, ‘Ani odzimɔ yĩ ɔlate?’ ");
INSERT INTO bov_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ekĩ edzimɔ kɔtɔ a kpa mbuayɛ kĩ, ‘Bɔ̃ tɛkantsi ɔha.’ “Ade tudzuma akũ ɔdãmɛnanɛ a bi ye kĩ, ‘Amɔ nɔ akunta nɛ awĩ. Kɛna akũ kadzi katsɛlɛ aduenum.’ ");
INSERT INTO bov_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ade evia ɔbɛbã lɛmɛ kĩ, ‘Nɔ malo ani odzimɛna?’ “Kɔtɔ odzimɛnanɛ a lɛ kĩ, ‘Fugbanɔ fuvũ baũbaũ ɔha mɔa.’ “Oti a kĩ ɛdzɛ̃ nɛ tudzuma onukpɛ̃ a bi ye kĩ, ‘Amɔ nɔ akunta nɛ awĩ. Tsɛlɛ aduesɔũ kayi.’ ");
INSERT INTO bov_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nɛ fukĩĩ sũ ɔlate a mu ye tudzuma ɔdãmɛnanɛ a nɛ nyansã tɛdake tisi a kĩ ɛbɔɛ a sũ. Ɔnɔkɔali ni, katinya kamɛ bati deĩ nyansã tisi nɛ be fɔtsakɛlawa kamɛ bɛbɛ̃ bikĩ batse Baguma kalɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ade Yesu lɛ ɛnaa lɔtɔ kĩ, “Mikɔa katinya kamɛ akũ kana fɔtsa mikɛna tɔkɔba, ayekĩ ntɛ fuwoli ni, baatɛ mi nɛ daa nkpã ɔtɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Odi nyɛ odi kĩ edi oni nɛ fɔtsa kabii akũ ni, yaadi fɔtsa baũ akũ oni. Ade ayea odi nyɛ odi kĩ ɛtádi oni nɛ fɔtsa kabii akũ ni, ɛláadi fɔtsa baũ akũ oni lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ade ntɛ mitádi katinya kamɛ fɔtsa akũ oni a, nde baapuli bɛkɔa fɔtsa kĩ fɔtɛ kɔya fɔba katinya kamɛ fɔtsa bido nɛ mi awɛ? ");
INSERT INTO bov_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ntɛ mitádi lɛtsa a kĩ lɛnyɛ oti bɛbã fude kĩ fɔtɛ kɔya akũ oni ni, owei aakɔa litsedi kĩ laanya mi fude ɛkpa mi? ");
INSERT INTO bov_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Osumunɛ odima lɛláapuli esum balate nviã. Yaakesĩ ɔmɔa lɔkɔa ɛwɛ ɔyade a kalɛ. Ĩye yaakɔa ye akũ ɛkpa ɔmɔa lɔkɔa ɛvɛlɛ akũ nɛ ɔyade a akũ. Ɔnɔkɔali nyɛ kĩ, ɔláapuli osum Baguma mɔ katinya kamɛ fɔtsa.” ");
INSERT INTO bov_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kĩ Farisifɔ a nu fɔlɛtsa a kĩ Yesu lɛ a, bɛnyɛ ye ahĩsɛm kitonɛkĩ sika bawɛnɛ banɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu bi be kĩ, “Minyɛ bati kĩ bakɛna be akũ ndɛ badã yedede nɛ bati bɛbã anɛ, lɛmɛ Baguma nyina mi tɔwɔlɛ kamɛ. Kitonɛkĩ fɔtsa a kĩ fɔtɛ kɔya nɛ otidziwa anɛ a, fɔnyɛ kɔwɛ̃ fɔtsa nɛ Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose mbla mɔ Baguma onukpɛ̃ banyɛnɛ fɔtsa a kĩ bɛtsɛlɛ biyi a kɛna adzuma kɛyawo Yohanes Mui Ɔwɔlanɛ a lɔkɔ. Kito ke a, balɛ Kalɛ Wĩ a nɛ Baguma lɛgãkanyakɔ̃ a akũ, ade odi nyɛ odi lamɛna kapili kĩ yawo nɛ de kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lɛmɛ fɔadã bɔɛɛ kĩ tite mɔ ode aawɔ kɛba kĩ baafɔnɛ fɔlɛtsa kabiiwɛ awɛ nɛ mbla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Onyole nyɛ onyole kĩ esĩ ɔtsɔ̃, mɔ ɛnakɔã ɔbɛbã ni, ɛbɔa adɔpaa. Ade onyole kĩ ɛkɔã otsole kĩ bisĩ ni, ye malo ɛbɔa adɔpaa. ");
INSERT INTO bov_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Osikani odi dzi nkpã. Ɛkahihiɛ ye akũ nɛ tilima kĩ tɛtɛ kɔya kamɛ, ade ɛkanya nkpã mɛnɛmɛnɛ luwi daa a. ");
INSERT INTO bov_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ohiãni odi lɛmɛ kĩ bavɛ Lazaro lɛmɛ dzi nkpã tɔ̃. Fɔɔkpa nɛ́ nɛ ye akũ flee ade bɛkabɔɛ ye kanaadzina nɛ osikani a kɔla onyukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɛkakɔna kĩ yaana funitsã wuliwa a kĩ fɔato osikani opunu akũ katɔ nɛ tite a ɛnya. Bakpete malo kayadzɛmɛ ye fɔɔkpa a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ohiãni a ku, ade ode fɔtɔ banyanɛ yabɔɛ ye bɛnamɛna ode bɛnadzina nɛ Abraham ɔwɛ̃ a. Osikani a lɛmɛ yaku, ade ke bibila ye a. ");
INSERT INTO bov_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nɛ kanɔkpade awã kĩ ɛkamɔ lubo paa a, ɛdzɛla anɛ ɛmɔ Abraham mɔ lugo nɛ ode, mɔ Lazaro lɛmɛ kĩ edzi nɛ ye ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ade osikani a bɔa fɔwɔla ɛvɛ ye kĩ, ‘Boe Ɔlɛga Abraham! Mɔ yĩ kɔnya kafɔ̃ Lazaro edo lawobi nɛ mui kamɛ ɛta nɛ yĩ sɛmɛ akũ, ayekĩ fɔ́adɔla yĩ ɔmɔado, kitonɛkĩ nlamɛna lubo kamɔ nɛ fi kĩĩ kamɛ!’ ");
INSERT INTO bov_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lɛmɛ Abraham bi ye kĩ, ‘Yĩ obi, te anɛ kĩ bɛkpa nɔ fɔtsa wĩ flee nɛ nɔ nkpã kamɛ, lɛmɛ Lazaro kɔ̃ ni, fɔtsa kpa nɛnɛ ɛna. Lɛmɛ finyaakĩĩ a, ɛlamɛna kawɔlɛ kamɔ, ade nɔ malo ɔlamɛna lubo kamɔ a. ");
INSERT INTO bov_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ade lɛtsa kĩ lɛbɛ̃ kɔlaa nyɛ kĩ, lɛkɛ dzununuunu waa nɛ boe kayite, kĩ ntɛ odi wɛ kĩ yato awĩ ɛnyina ɛya nɛ mi sɛkɛ̃ ni, ɛláapuli. Ade ayea ntɛ odi lɛmɛ wɛ kĩ yato awã ɛnyina ɛya nɛ boe sɛkɛ̃, ɛláapuli a.’ ");
INSERT INTO bov_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Awã naa, osikani a bi ye kĩ, ‘Boe Ɔlɛga Abraham, make nɔ aduli kĩ do Lazaro ɛnaa nda tɔtɔ kamɛ, ");
INSERT INTO bov_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","awã kĩ ndeĩ bawaɛ̃nyole elo. Fɔ̃ ɛnaabɔa be kɔkɔ ayekĩ be malo bɛláayawo nɛ lubo kamɔ kĩĩ kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ade Abraham bi ye kĩ, ‘Awaɛ̃ amɛ deĩ fɔlɛtsa a kĩ Mose mɔ Baguma onukpɛ̃ banyɛnɛ a tsɛlɛ biyi a. Kɛnɛ kĩ bitse fɔlɛtsa a kĩ bɛlɛ a lɔkɔa bɛkɛna nɛ foe akũ.’ ");
INSERT INTO bov_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Osikani a kpa mbuayɛ kĩ, ‘Boe Ɔlɛga Abraham, fɔláawĩ be! Lɛmɛ ntɛ odi aayidza eto kanɔkpa ɛnaa be sɛkɛ̃ ni, baadani be tɔwɔlɛ kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Lɛmɛ Abraham bi ye kĩ, ‘Ntɛ bɛláatse Mose mɔ Baguma onukpɛ̃ banyɛnɛ a fɔlɛtsa ni, ntɛ odi to kanɔkpa ɛnaa be sɛkɛ̃ malo a, bɛláatɛ ye fɔlɛtsa a bido.’ ” ");
INSERT INTO bov_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Fɔtsa a kĩ foe aafɔ̃ bati liwo nɛ tɔkpa kamɛ a aaya kokooko, lɛmɛ bɔbɔɛ makpa oti a kĩ ye akũ fɔ́atsã fɔya a! ");
INSERT INTO bov_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Fɔnɛnɛ fɔkpa ye ntɛ bɛkɔa kɔwɔlɛ kpale bɛvɛla ye nɛ sɔmɔ bɛta bido nɛ mpo kamɛ, kɛba kĩ yaafɔ̃ babisɛ̃ kamɛ ɔmɔa liwo nɛ tɔkpa kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Foesũ midã kadã wĩ nɛ lɛtsa a kĩ miakɛna a akũ. “Ntɛ awaɛ̃ kɛna nɔ tɔkpa ni, kã ye anɛ. Ntɛ etunɔ kĩ eku kɔtɔ ni, kɔa kate ye. ");
INSERT INTO bov_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ntɛ ɛkɛna tɔkpa nɛ nɔ akũ titi evũkɔnɔ nɛ luwi mɔa kamɛ mɔ lɔkɔ nyɛ lɔkɔ ɛyabi nɔ kĩ eku kɔtɔ ni, kɛnɛ kĩ akɔa ote ye.” ");
INSERT INTO bov_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Fɔtɔ banyanɛ a bi Yesu kĩ, “Boe Ɔlate, fɔ̃ boe katɛkado kide nɛ ode kibu.” ");
INSERT INTO bov_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ade Yesu kpa mbuayɛ kĩ, “Ntɛ odeĩ katɛkado kĩ kɛpɔnɛ lububu ndɛ kutse libi kabiiwɛ flee ni, aapuli obi kutse kĩĩ kĩ, ‘Bɔlɛ mɔ tunu kanaadza nɛ mpo kamɛ’ ade kɔ́atse nɔ a. ");
INSERT INTO bov_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mibɔɛ foe kĩ mi kamɛ odi deĩ ɔpaani kĩ yadã nɔ kɔba akũ, ĩye ekĩ yadãmɛna nɔ baveli akũ, ntɛ eto ede a, aabi ye kĩ ɛwɛ sɔwa ɛyadzi ɛnya? ");
INSERT INTO bov_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oowo! Mbom aabi ye kĩ, ‘Manɛ akũ katɔ funitsã, kadza kasum yĩ, ĩnya, mmɔa ĩyua tɔ̃ fɔmɔ nɔ malo aanya.’ ");
INSERT INTO bov_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Osumunɛ tásĩ ɛkpa kɔlɛkanyɛ ntɛ ɛkɛna nɛ lɛtsa a kĩ kɛnɛ kĩ ɛkɛna akũ. Mbɔɛɛ esĩ? ");
INSERT INTO bov_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ade ayea fɔla fɔkpa mi a. Ntɛ mikɛna lɛtsa nyɛ lɛtsa a kĩ mbi mi kĩ mikɛna ni, milɛ kĩ, ‘Basumunɛ odi bɔanɛ, lɛtsa a kĩ kɛnɛ kĩ de bɔakɛna a, ade de bɔkɛna a.’ ” ");
INSERT INTO bov_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kĩ Yesu anaa Yerusalem a, ɛnatsã Samaria mɔ Galilea ɔbɛ̃ akũ. ");
INSERT INTO bov_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kĩ ɛkɔa yawo akula adi kamɛ a, banyole ewua kĩ basɔ fɔsɔ ngbã yatsɛlamɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bɛdza mɔ lugo ade bɛbɔa fɔwɔla kĩ, “Boe Ɔlɛga Yesu, mɔ boe kɔnya!” ");
INSERT INTO bov_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu dã be ade ebi be kĩ, “Minaa, minaakɔa mi akũ mitsa basɔfɔ bɛsɛla mi akũ bɛdã.” Kĩ bɛyɛlɛ banaa nɛ osi a, fɔsɔ a wɔ nɛ be akũ. ");
INSERT INTO bov_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kĩ be kamɛ ɔmɔa mɔ kĩ fɔsɔ a wɔ nɛ ye akũ a, emuniki ɛya mɔ Baguma kamu mɔ fɔwɔla kɔɔba. ");
INSERT INTO bov_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɛyatɔ nɛ Yesu abɔa kamɛ ɛnyɛ ye kɔlɛ. Onyole kĩĩ nyɛ Samariani. ");
INSERT INTO bov_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu via ye kĩ, “Nnɛ́ banyole ewua ntsa fɔsɔ a? Nde be evedi nkaɛ a? ");
INSERT INTO bov_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nde sũ ɔnɔvɔɛ̃ kĩĩ odi limuniki ɛyaanyɛ Baguma kɔlɛ?” ");
INSERT INTO bov_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu bi ye kĩ, “Yidza kanaa. Nɔ katɛkado fɔ̃ ɔsaɛ.” ");
INSERT INTO bov_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisifɔ badi via Yesu lɔkɔ a kĩ de kamɛ Baguma lɛgãkanya a aaya. Yesu kpa mbuayɛ kĩ, “Baguma lɛgãkanya a lɛlaaya nɛ osi a kĩ bati amɔ mɔ anɛ a. ");
INSERT INTO bov_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Odima lɛláalɛ kĩ, ‘Dã, amɔ foe nɛ awĩ’ ĩye ‘amɔ foe nɛ akĩĩ,’ kitonɛkĩ Baguma lɛgãkanya a deĩ nɛ mi kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ke liti a ebi ye fɔtsa bakɔlɛnɛ a kĩ, “Lɔkɔ lidi aaya kĩ míawɛ kĩ miamɔ Yĩ Otidziwa Obi fuwi a kamɛ lɔmɔa lɛmɛ miláamɔ de. ");
INSERT INTO bov_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bati badi aana, ade baabi mi kĩ, ‘Midã ye nɛ akĩĩ!’ ĩye ‘Midã ye nɛ awĩ!’ Lɛmɛ mitatomɔ foe liti. ");
INSERT INTO bov_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kitonɛkĩ ayekĩ odetɔ́ kamɛ amɔanɛ kato sɛkɛ kĩĩ kanaa sikĩĩ a, ade aye Otidziwa Obi a kaya aana a. ");
INSERT INTO bov_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lɛmɛ kɛnɛ kĩ ɛnya lɔtɔ ɛmɔ lubo pii, ade nviã bati lɛmɛ aasĩ ye a. ");
INSERT INTO bov_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ayekĩ fɔna nɛ Noa lɔkɔ a, ade aye fɔ́ana nɛ Otidziwa Obi a kabuki kaya fuwi a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bati flee kanya bɛkamɔa, banyole mɔ batsole kakɔã akũ, kɛnawo luwi a kĩ Noa de ewo nɛ ɔkɔlɔ a kamɛ, ade oni ko eyili fɔkɔ ɛwɔla bati flee a. ");
INSERT INTO bov_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ade ayea fɔ́ana ndɛ ayekĩ fɔna nɛ Lot lɔkɔ lɛmɛ a. Bati kanya, bɛkamɔa, bɛkanya kɔyaatɔ, kadu fɔtsa ade badi lɛmɛ kake fɔla a. ");
INSERT INTO bov_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ade luwi a kĩ Lot nɛ́ nɛ Sodom ɔmatɔ kamɛ a, fi mɔ fukpokpo kĩ fudeĩ nfiã kpitii wula futo ode fɔyawɔla be a flee. ");
INSERT INTO bov_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ade aye fɔ́ana nɛ luwi a kĩ Otidziwa Obi a aanɛ ɛta a. ");
INSERT INTO bov_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nɛ luwi a na, oti kĩ edeĩ nɛ kɔla ode ɛtabuki eduma kĩ yanaafila ye akũ fɔtsa nɛ kɔla kamɛ. Ade ayea odi kĩ edeĩ nɛ kɔba kamɛ ni, ɛtabuki emuniki ɛnaa tɔtɔ kamɛ kĩ yanaabɔɛ litsedi. ");
INSERT INTO bov_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mite anɛ nɛ lɛtsa a kĩ lɛya nɛ Lot ɔtsɔ̃ akũ a! ");
INSERT INTO bov_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Odi nyɛ odi kĩ ɛbɔa mbɔdi kĩ yapili ye nkpã ni, yaayɛla ye, ade odi nyɛ odi kĩ ɛyɛla ye nkpã ni yaana nkpã a bio. ");
INSERT INTO bov_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Luwi a lɛnyɛ ni, mabi mi kĩ bati nviã aawa nɛ ɔkɛna mɔa akũ, baabɔɛ ɔmɔa bɛdzakũmɛna lɔkɔa bɛfɔnɛ ɔyade a biyi. ");
INSERT INTO bov_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Batsole nviã aakawɔlɛ onuvoe nɛ kɔwɔlɛ akũ, baabɔɛ ɔmɔa lɔkɔa bɛfɔnɛ ɔyade a awɛ biyi. ");
INSERT INTO bov_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Banyole nviã aakakɛna adzuma nɛ kɔba. Baabɔɛ ɔmɔa bɛnamɛna, bɛfɔnɛ ɔmɔa biyi.” ");
INSERT INTO bov_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ade fɔtsa bakɔlɛnɛ a via ye kĩ, “Boe Ɔlate, nɛ ndia?” Yesu kpa mbuayɛ kĩ, “Awã kĩ fɔtsa kuwa waa ni, ade awã fɔpɛtɛ akpɔta a.” ");
INSERT INTO bov_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu bɔa ye fɔtsa bakɔlɛnɛ a lɛgbã lidi, ɛkɔa yatsa be kĩ kɛnɛ kĩ bɛkaabɔa mpaɛ lɔkɔ nyɛ lɔkɔ, kĩ akpɔ ɛtaveli be da. ");
INSERT INTO bov_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ebi be kĩ, “Fɔlɛtsa ɔdzɛnɛ odi na nɛ ɔmatɔ odi kamɛ kĩ ɛtávila Baguma ĩye ɛkɔa obu ɛkpa odima lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Okunawa odi lɛmɛ na nɛ ɔmatɔ mɔapɛ a kamɛ, ade ɛkayake ye aduli kĩ, ‘Bumɔ yĩ kanyɛ yĩ nɛ yĩ okesĩnɛ awɛ kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Fɔtɛ lɔkɔ pii kĩ fɔlɛtsa ɔdzɛnɛ a sĩ ɛtákɛna lɛtsama nɛ foe akũ. Lɛmɛ nɛ ke kawũna kamɛ a, ebi ye akũ kĩ, ‘Titɔ kĩ maávila Baguma ade maákɔa obu kakpa otidziwa malo ni, ");
INSERT INTO bov_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nɛ ɔhau beblebee kĩ okunawa kĩĩ akpa yĩ sũ ni, maadã kĩ ɛna ye ɔtɔbɛ. Ntɛ ntákɛna lɔmɔ ni, yaakaya nɛ yĩ sɛkɛ̃ lɔkɔa ɛláafɔ̃ nna kawɛya.’ ” ");
INSERT INTO bov_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ade boe Ɔlate lɛ ɛnaa lɔtɔ kĩ, “Mitse lɛtsa a kĩ fɔlɛtsa ɔdzɛnɛ kĩ yaádi ɔnɔkɔali kĩĩ lɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Finyaakĩĩ a, miatɛ kado kĩ Baguma lɛláadzɛ ɛkpa ye bati a kĩ babe kavɛ ye lɛnyɛ mɔ suwa, kavia kabumɛna a ɔtɔbɛ? Mbɔɛɛ miatɛ kado kĩ ɛláabumɛna be mɔatsɛ? ");
INSERT INTO bov_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mabi mi kĩ yaadzɛ ɛkpa be ɔtɔbɛ mɔatsɛ. Lɛmɛ ntɛ Otidziwa Obi a ya nɛ katinya kamɛ ni, yaamɔ kĩ bati deĩ katɛkado?” ");
INSERT INTO bov_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu bɔa lɛgbã kĩĩ ɛkpa bati a kĩ bɛtɛ bido kĩ bɛkpalɛ yedede ade basupa bati nkaɛ a. ");
INSERT INTO bov_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ebi be kĩ, “Luwi a, bati nviã badi naa Asɔli Kɔla kamɛ kĩ banaabɔa mpaɛ. Ɔmɔa nyɛ Farisini, ɔyade a nyɛ tɔgɔlɛ ɔtɛnɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisini a kpɛ̃ ye akũ ɛnadza ɛbɔa mpaɛ kĩ, ‘Baguma, manyɛ nɔ kɔlɛ, kitonɛkĩ nlá anɛngbã. Maádi bati ablɔ ade maákɛna adɔpaa ndɛ ayekĩ bati bɛbã akɛna a. Manyɛ nɔ kɔlɛ lɛmɛ kĩ nlá ndɛ tɔgɔlɛ ɔtɛnɛ a kĩ ɛdzɛ nɛ akĩĩ a aye. ");
INSERT INTO bov_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Masui onukpɛ̃ fuwi nviã nɛ ɛkwansieda mɔa kamɛ, ade makɔa lɛtsa a kĩ mana a foe katsu kawuade a kakpa nɔ a.’ ");
INSERT INTO bov_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lɛmɛ tɔgɔlɛ ɔtɛnɛ a dza mɔ lugo, ade ɛtáwɛ kĩ yadzɛla anɛ ɛdã ode malo a. Lɛmɛ ɛkɔa awɛ ɛbɔamɔ ɔwɔlɛ ɛlɛ kĩ, ‘Baguma, titikpa ɔkɛnanɛ manɛ, mɔ yĩ kɔnya!’ ” ");
INSERT INTO bov_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu bi be kĩ, “Mabi mi kĩ tɔgɔlɛ ɔtɛnɛ a akũ lɛkpalɛ yedede nɛ Baguma anɛ kĩ emuniki ɛnaa kɔla a, nnɛ́ Farisini a. Kitonɛkĩ odi nyɛ odi kĩ ɛdɛla ye akũ nɛ ode ni, baakɛna ye nɛ kayɔ, ade odi nyɛ odi kĩ ɛdɔla ye akũ ni, baadɛla ye nɛ ode.” ");
INSERT INTO bov_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bati badi kɔa be babi bɛyamɛna kĩ Yesu ete awɛ nɛ be akũ. Kĩ ye fɔtsa bakɔlɛnɛ a mɔ́ fukĩĩ a, bɛkã be anɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lɛmɛ Yesu vɛ babisɛ̃ a ɛyamɛna nɛ ye sɛkɛ̃, ɛlɛ kĩ, “Mifɔ̃ babisɛ̃ bɛya nɛ yĩ sɛkɛ̃, mitasua be osi. Kitonɛkĩ bikĩĩ bamɛ odu lá Baguma lɛgãkanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mite fukĩĩ anɛ! Odi nyɛ odi kĩ ɛtátɛ Baguma lɛgãkanyakɔ̃ a ndɛ obisɛ̃ aye ni ɛláapuli ewo nɛ de kamɛ dadaada.” ");
INSERT INTO bov_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yudafɔ ɔnɔkɔɛ̃ odi via Yesu kĩ, “Fɔtsa Ɔtsanɛ wĩ, litsa kɛnɛ kĩ nkɛna fɔmɔ maana nkpã kĩ ɛla kawũna dadaada a?” ");
INSERT INTO bov_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ade Yesu via ye kĩ, “Nde sũ avɛ yĩ oti wĩ? Odima lɛnyɛ́ oti wĩ, mbɔɛntɛ Baguma mɔapɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Onyina mbla a kĩ ɛtsa kĩ, ‘Tabɔa adɔpaa, takɔ oti, taye, tama fɔvã ote nɛ odima akũ, bu aga mɔ ama.’ ” ");
INSERT INTO bov_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Oti a kpa mbuayɛ kĩ, “Kito anɛ yĩ tibisɛ̃ kamɛ a, nkɛna nɛ tɛbla kĩĩ flee akũ.” ");
INSERT INTO bov_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kĩ Yesu nu foe a, ebi ye kĩ, “Lɛtsa mɔa te nɔ kakɛna. Naanɔ nɔ fɔtsa flee a kĩ odeĩ a kakɔa foe sika a kakpa ahiãfɔ, lɔkɔa aana akũ kana fɔtsa nɛ ode. Ke liti muniki kayaatomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lɛmɛ kĩ onyole a nu fɔlɛtsa a ewo ɔblɔ paa, kitonɛkĩ ɛna akũ kana fɔtsa beblebee. ");
INSERT INTO bov_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu mɔ ayekĩ ewo ɔblɔ a, ade ɛlɛ kĩ, “Fɔ́ana ɔsĩ fɔkpa asikafɔ kĩ baapuli biwo nɛ Baguma lɛgãkanyakɔ̃ a kamɛ! ");
INSERT INTO bov_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Fɔadã bɔɛɛ kĩ ɔpɔnkɔ mɔ kapu aatsã ɔnɔbɔ̃ ɔkɛ kamɛ ɛnɛ, kɛba kĩ osikani aawo nɛ Baguma lɛgãkanyakɔ̃ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ade bati a kĩ binu kalɛ kĩĩ a via Yesu kĩ, “Kekɔ̃ owei koũ aana katɛ?” ");
INSERT INTO bov_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kpa mbuayɛ kĩ, “Lɛtsa a kĩ otidziwa lɛláapuli ɛkɛna dadaada ni, Baguma kɔ̃ aapuli ɛkɛna.” ");
INSERT INTO bov_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Awã naa Petro bi Yesu kĩ, “Dã, bɔfɔnɛ boe tɔtɔ awɛ buyi bɔya butomɔ nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu bi be kĩ, “Mafɔ̃ minyi yededeede kĩ odi nyɛ odi kĩ ɛfɔnɛ ye tɔtɔ, ɔtsɔ̃ ĩye bawaɛ̃, ĩye bamanɛ ĩye babi eyi nɛ Baguma lɛgãkanyakɔ̃ a sũ ni, ");
INSERT INTO bov_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","baase ye fɔtsa kĩĩ fublusu nɛ nviã katinya kĩĩ kamɛ mɔ nkpã kĩ ɛla kawũna a nɛ kikĩ kaaya a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kpã ye fɔtsa bakɔlɛnɛ ewua-nviã a ɛnamɛna ɔɔwɛ̃ ade ebi be kĩ, “Mitse! Bɔanaa Yerusalem, awã kĩ fɔtsa flee a kĩ Baguma onukpɛ̃ banyɛnɛ tsɛlɛ nɛ Otidziwa Obi akũ biyi a, aaya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Baakɔa ye bido nɛ bikĩ bɛnyɛ́ Yudafɔ awɛ, bidi ye nsekuo, bivũna ye, bitua tanɛ biko nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baabo ye lɔkɔa bɛkɔ ye, lɛmɛ nɛ luwi lɛlalɛde akũ ni, yaabuki eyidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lɛmɛ ye fɔtsa bakɔlɛnɛ tánu fɔlɛtsa kĩĩ fudima kayɔ. Bɛkɔa foe kayɔkanu bɛkɔla be, ade ke bɛtányi lɛtsa a kĩ de akũ Yesu kalɛ kɔdzɛla a. ");
INSERT INTO bov_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kĩ Yesu fuã Yeriko ɔmatɔ a, ɔnɛkunɛ odi dzi nɛ osi ɔɔwɛ̃ ɛkawã fɔtsa. ");
INSERT INTO bov_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kĩ enu bati kɔdabu nkã kĩ batɛ̃ a, evia kĩ, “Litsa lamɔ kaya?” ");
INSERT INTO bov_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ade bibi ye kĩ, “Yesu Nazaretni a lɛyaatɛ̃.” ");
INSERT INTO bov_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Awã naa, ɛbɔa fɔwɔla kɔɔba kĩ, “Yesu, Lɛgã Dawid Obi! Mɔ yĩ kɔnya!” ");
INSERT INTO bov_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bati a kĩ bɛnyaa lɔtɔ a wũni nɛ ye akũ kĩ esua onukpɛ̃. Lɛmɛ ɛdanɛ fɔwɔla kabɔa kɔɔba kalɛ kĩ, “Lɛgã Dawid Obi! Mɔ yĩ kɔnya!” ");
INSERT INTO bov_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Foesũ Yesu fɔ̃ ɛdza ade ɛlɛ kĩ bɛkpã ɔnɛkunɛ a bɛma ye a. Kĩ ewo Yesu sɛkɛ̃ a, evia ye kĩ, ");
INSERT INTO bov_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Litsa awɛ kĩ nkɛna nkpa nɔ?” Ɔnɛkunɛ a akpa mbuayɛ kĩ, “Boe Ɔlate, mawɛ kĩ mbuki mmɔ́ fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ade Yesu bi ye kĩ, “Kekɔ̃ mɔ fɔkɔ. Nɔ katɛkado fɔ̃ ɔsaɛ.” ");
INSERT INTO bov_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Deedimɔapɛ epuli ɛmɔ fɔkɔ ade ke etomɔ Yesu mɔ Baguma kɔlɛ kanyɛ a. Kĩ bati kɔdabu a mɔ fukĩĩ a, be flee bimu Baguma. ");
INSERT INTO bov_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu nawo nɛ Yeriko ɔmatɔ a kamɛ, ɛtsã ye kamɛ ɛtɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tɔgɔlɛ ɔtɛnɛnɔkɔɛ̃ osikani paa odi kĩ bavɛ Zakeo dzi nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɛkabɔa mbɔdi kĩ yamɔ Yesu enyi ye, lɛmɛ kĩ ɛnyɛ oti lukũ sũ, bati lidede fɔ̃ ɛtápuli ɛmɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Foesũ ewula atsɛ ɛnya bati kɔdabu a lɔtɔ ɛnade nɛ kutse gɛlɛɛlɛ kudi kamɛ ayekĩ yaamɔ Yesu kitonɛkĩ enyina kĩ yaatsã awã ɛtɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kĩ Yesu wo kutse a kayɔ a, ɛdzɛla anɛ ɛmɔ Zakeo ade ɛvɛ ye kĩ, “Zakeo, duma mɔatsɛ, kɛnɛ kĩ mase nɛ nɔ awã nviã.” ");
INSERT INTO bov_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeo wɛ sɔwa eduma ade ɛyatɛ Yesu mɔ kawɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bati a flee kĩ bɛmɔ́ fukĩĩ a kɛna hũhũhũhũ nɛ Yesu akũ bɛlɛ kĩ, “Oti kĩĩ nase nɛ titikpa ɔkɛnanɛ tɔtɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakeo yidza ɛdza ebi boe Ɔlate a kĩ, “Boe Ɔlɛga, dã! Maakɔa yĩ akũ fɔtsa sɛkɛ mɔa nte ahiãfɔ, ade ntɛ nsisi odi ni, maase ye foe titi ɛna kɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ade Yesu bi ye kĩ, “Nkpã katɛ ya nɛ tɔtɔ kĩĩ kamɛ nviã, kitonɛkĩ oti kĩĩ lɛmɛ nyɛ Abraham kasinu a kamɛ obi. ");
INSERT INTO bov_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Otidziwa Obi a ya kĩ yawɛ bikĩ bɛyɛla ɛnyɛ be lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ade kĩ bati katse fɔlɛtsa a kĩ Yesu kabi be a, ɛlɛ ɛnamɛna lɔtɔ, ɛbɔa be lɛgbã lidi. Lɔkɔ kĩĩ a, efuã Yerusalem ade bati a kɔna kĩ Baguma lɛgãkanya a do kanɛ kata awɛ a. ");
INSERT INTO bov_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Foesũ ebi be kĩ “Nɛ lɔkɔ lidi kamɛ ni, ɔnɔkɔɛ̃ odi yidza kĩ yanaa tite tidi akũ mɔlugo mɔlugo bɛnaadzina ye lɛgã. Ehihiɛ eyi kĩ yaamuniki ɛya nɛ ɔtɔ nɛ foe liti. ");
INSERT INTO bov_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fɔmɔ yaapi osi a, ɛvɛ ye basumunɛ ewua ɛkpɔta ade ɛkpa be kamɛ odi nyɛ odi sika ngbã sɔmɔa sɔmɔa ebi be kĩ, ‘Mikɔa sika a minya kɔyaatɔ mina kute nɛ yĩ liti.’ ");
INSERT INTO bov_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Lɛmɛ ye ɔtɔ bati akesĩ ye foesũ bido batɔ bitomɔ ye liti kĩ bɛnaalɛ kĩ, ‘Bɔáwɛ onyole kĩĩ kĩ ɛnya boe lɛgã.’ ");
INSERT INTO bov_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bidzina onyole a lɛgã ade emuniki ɛya nɛ ɔtɔ a. Kĩ ɛya a, ɛfɔ̃ bɛvɛ ye basumunɛ a bɛyadzɛla nɛ ye anɛ kamɛ kĩ yawɛ enyi kute a kĩ bɛna. ");
INSERT INTO bov_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Osumunɛ ɔtɔnyade a bi ye kĩ, ‘Ɔnɔkɔɛ̃, nna sika a sɔmɔa sɔmɔa foe ewua nte nɛ sikĩ ɔkpa yĩ a akũ.’ ");
INSERT INTO bov_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ɔnɔkɔɛ̃ a kpa ye mbo ɛlɛ kĩ, ‘Ɔkɛna foe kakɛna wĩ! Ɔnyɛ osumunɛ kĩ yadi ɔnɔkɔali! Nɛ ayekĩ odi ɔnɔkɔali nɛ fɔtsa kabii akũ sũ ni, maakɛna nɔ ɔnɔkɔɛ̃ nɛ tɛmatɔ ewua akũ.’ ");
INSERT INTO bov_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Osumunɛ ɔyade a lɛmɛ yalɛ kĩ, ‘Ɔnɔkɔɛ̃, nna sika sɔmɔa sɔmɔa foe elo nte nɛ sikĩ ɔkpa yĩ a akũ!’ ");
INSERT INTO bov_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ɔnɔkɔɛ̃ a bi ye kĩ, ‘Mbo, ɔkɛna foe kakɛna wĩ! Aanya ɔnɔkɔɛ̃ nɛ tɛmatɔ elo akũ!’ ");
INSERT INTO bov_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Osumunɛ ɔlalɛde a yalɛ kĩ, ‘Ɔnɔkɔɛ̃, amɔ nɔ sika sɔmɔa kĩ ɔkɔa ɔkpa yĩ a. Nsui se nɛ limakũ kamɛ nkɔa nkɔla. ");
INSERT INTO bov_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nvila nɔ kitonɛkĩ oti mɔ ɔsĩ odi anɛ. Abɔɛ fɔtsa a kĩ fɔnyɛ́ nɔ fude, ade ana fɔtsa a kĩ ɔtádu lɛmɛ a.’ ");
INSERT INTO bov_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ade Ɔnɔkɔɛ̃ a bi ye kĩ, ‘Nɔ osumunɛ kpa, maakɔa nɔ mɔawɛ onukpɛ̃ kamɛ kɔdzɛla kalɛ nkɔ nɔ kɔtɔ. Onyina kĩ oti mɔ ɔsĩ manɛ kĩ mabɔɛ fɔtsa a kĩ fɔnyɛ́ yĩ fude, ade mana fɔtsa kĩ ntádu a. ");
INSERT INTO bov_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kĩ onyina lɔmɔ a, nde sũ ɔtákɔa yĩ sika ɔnaado nɛ sika kakɔlakɔ̃ kĩ ntɛ mmuniki ĩya ni, maatɛ se mɔ se akũ kute?’ ");
INSERT INTO bov_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ade ebi bati a kĩ bɛdzɛ̃ nɛ awã kĩ, ‘Mitɛ sika sɔmɔa nɛ ye awɛ mikɔa mikpa osumunɛ a kĩ ɛna sika sɔmɔa sɔmɔa ewua a.’ ");
INSERT INTO bov_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Lɛmɛ bati a bi ye kĩ, ‘Ɔnɔkɔɛ̃, oti a na deĩ sika sɔmɔa sɔmɔa se ewua kɔkɔɛ!’ ");
INSERT INTO bov_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ade Ɔnɔkɔɛ̃ a kpa mbuayɛ kĩ, ‘Mabi mi kĩ odi nyɛ odi kĩ edeĩ litsedi ni, ade ye baakɔa foe pii bibu a, lɛmɛ odi nyɛ odi kĩ ɛlá lɛtsama a ni, foe kabii a kĩ edeĩ a malo baatɛ foe nɛ ye awɛ. ");
INSERT INTO bov_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Finyaa ni, mivɛlɛ yĩ bakesĩnɛ a kĩ bɛtáwɛ kĩ ĩnya be lɛgã a miyamɛna nɛ awĩ, lɔkɔa mikɔ be nɛ yĩ anɛ kamɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kĩ Yesu bi be fɔlɛtsa kĩĩ eyua a, ɛnya ye fɔtsa bakɔlɛnɛ a lɔtɔ epi osi yanaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kĩ efuã Betfage mɔ Betania tɛmatɔ a nɛ Kugua Futse Ɔtɔ ɔwɛ̃ a, edo ye fɔtsa bakɔlɛnɛ nviã ɛnyamɛna lɔtɔ, ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Minaa ɔmatɔ kabii a kĩ ɛwa nɛ mi lɔtɔ a kamɛ. Ntɛ miawo nɛ ye kamɛ ni, míamɔ aflim obi kĩ odima tádzi nɛ ye akũ tɔ̃ kĩ edeĩ nɛ ɔwɛ̃ kamɛ. Miwũnya ye lɔkɔa mikɔa miyamɛna nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ntɛ odi via mi kĩ litsa sũ miawũnya ye ni, mibi ye kĩ, ‘Boe Ɔlate sĩ ye.’ ” ");
INSERT INTO bov_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Fɔtsa bakɔlɛnɛ a naa ade bɛmɔ́ lɛtsa nyɛ lɛtsa ndɛ ayekĩ Yesu bi be a. ");
INSERT INTO bov_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kĩ bɛkawũnya aflim obi a, ye balate via be kĩ, “Nde sũ miawũnya ye?” ");
INSERT INTO bov_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Fɔtsa bakɔlɛnɛ nviã a kpa mbuayɛ kĩ, “Boe Ɔlate sĩ ye.” ");
INSERT INTO bov_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bɛkɔa aflim obi a bɛma Yesu ade bɛdzɛlɛ be tɛtadiɛ wulaa biko nɛ ye akũ bibumɛna Yesu ede edzi nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kĩ edzi nɛ ye akũ banaa a, bati dzɛlɛ be tɛtadiɛ biko nɛ tite. ");
INSERT INTO bov_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kĩ Yesu fuã Yerusalem nɛ awã kĩ osi a ka eto Kugua Futse Ɔtɔ akũ a, ye fɔtsa bakɔlɛnɛ kɔdabu flee a yi kayɔ mɔ Baguma kɔlɛ kanyɛ, mɔ ye kahulu mɔ fɔwɔla kɔɔba nɛ awãwã fɔtsa flee a kĩ bɛmɔ́ a sũ. ");
INSERT INTO bov_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ade ke bɛlɛ kĩ, “Baguma ehila Lɛgã a kĩ laya nɛ Boe Ɔlate dĩ akũ! Lukudɔ lɛna nɛ ode, obu ɛnya Baguma nɛ ode flefle fude!” ");
INSERT INTO bov_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisifɔ badi kĩ bideĩ nɛ bati kɔdabu a kamɛ bi Yesu kĩ, “Fɔtsa Ɔtsanɛ, bi nɔ fɔtsa bakɔlɛnɛ a bisua onukpɛ̃!” ");
INSERT INTO bov_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kpa be mbuayɛ kĩ, “Mabi mi kĩ ntɛ bisua onukpɛ̃ ni, boe nɛ osi ɔɔwɛ̃ a mɔawɛ aayi fɔwɔla kabɔa kayɔ.” ");
INSERT INTO bov_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kĩ Yesu fuã Yerusalem ɛkɔa anɛ ɛmɔ ɔmatɔ kĩĩ a, ewula babe nɛ ye lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ade ɛlɛ kĩ, “Mawɛ kĩ nviã kĩĩ malo ni, aanyi lɛtsa a kĩ laakpa nɔ lukudɔ. Lɛmɛ finyaa kĩĩ a, ɔláapuli ɔmɔ́ de! ");
INSERT INTO bov_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lɔkɔ lidi aya kĩ nɔ bakesĩnɛ aatsua bisinya nɔ nɛ sɛkɛ nyɛ sɛkɛ. ");
INSERT INTO bov_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Baawɔla nɔ mɔ bati a kĩ bideĩ nɛ nɔ kamɛ a, ade bɛláafɔnɛ de lidima lɛwa nɛ de kawakɔ̃ malo a, kitonɛkĩ ɔtámɔ lɔkɔ a kĩ Baguma yatɛ nɔ a oyi ɔsũ!” ");
INSERT INTO bov_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kĩ Yesu nawo nɛ Asɔli Kɔla kamɛ a, eyi kayɔ mɔ fɔtsa banɔnɛ kablɔmɛna awɛ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ebi be kĩ, “Bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ Baguma lɛ kĩ, ‘Baavɛ yĩ asɔli kɔla kĩ mpaɛ kabɔakɔ̃.’ Lɛmɛ mikɔa koe mikɛna bayekpanɛ kabɛlakɔ̃!” ");
INSERT INTO bov_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Luwi nyɛ luwi ni, Yesu katsa fɔtsa nɛ Asɔli Kɔla a kamɛ. Yudafɔ basɔfɔnɔkɔɛ̃, mbla batsanɛ mɔ ɔmaĩ banɔkɔɛ̃ wɛ kĩ bakɔ ye. ");
INSERT INTO bov_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lɛmɛ bɛtámɔ osi a kĩ ye akũ baatsã, kitonɛkĩ bati a flee dzɛmɛna ye fɔlɛtsa kayaatse, ade bɛtáwɛ kĩ ye kalɛ kadima kɛtɛ̃ nɛ be akũ a. ");
INSERT INTO bov_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Luwi a, kĩ Yesu na nɛ Asɔli Kɔla kamɛ ɛkatsa fɔtsa, ɛkalɛ Kalɛ Wĩ a, Yudafɔ basɔfɔnɔkɔɛ̃, mbla batsanɛ mɔ ɔmatɔ a banɔkɔɛ̃ ya nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ade bibi ye kĩ, “Bi boe osi a kĩ odeĩ fɔmɔ akɛna fɔtsa kĩĩ bamɛ a. Owei lɛkpa nɔ osi?” ");
INSERT INTO bov_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kpa mbuayɛ kĩ, “Mifɔ̃ ĩnya lɔtɔ nvia mi kalɛ mɔa. Mibi yĩ, ");
INSERT INTO bov_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes bati mui kawɔla amaniɛ a ni, Baguma sɛkɛ̃ futo mbɔɛɛ kĩ bati sɛkɛ̃ futo?” ");
INSERT INTO bov_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nɛ awã a, biyi fɔlɛtsa kavɛlɛ mɔ be akũ kĩ, “Litsa bɔ́alɛ? Ntɛ bɔlɛ kĩ futo Baguma sɛkɛ̃ ni, yaavia kĩ, ‘Nde sũ mitátɛ Yohanes mido?’ ");
INSERT INTO bov_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ade ntɛ bɔlɛ kĩ bati sɛkɛ̃ futo ni, bati kɔdabu a flee aanɔ boe boe, kitonɛkĩ be flee bɛtɛ bido kĩ Yohanes nyɛ Baguma onukpɛ̃ ɔnyɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɛ foesũ bɛkpa mbuayɛ kĩ, “Bunyína awã kĩ futo.” ");
INSERT INTO bov_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ade Yesu lɛmɛ bi be kĩ, “Kekɔ̃ yĩ malo nláabi mi awã kĩ ntomɛna kɔbɛ̃ nnɛɛ makɛna fɔtsa kĩĩ bamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ade Yesu bɔa bati a lɛgbã kĩ, “Lɔkɔ lidi kamɛ ni, onyole odi nɛ waĩ kɔba. Ɛkɔa koe edo nɛ apaafɔ awɛ ɛnaa osi akũ, ɛnadzi nɛ awã ebuna owi. ");
INSERT INTO bov_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kĩ lɔkɔ wo ɔtɔ kĩ bana waĩ babi a, edo ye osumunɛ odi kĩ ɛnaatɛ ye kanyakɔ̃ nɛ apaafɔ a sɛkɛ̃ ɛma ye. Lɛmɛ apaafɔ a bo osumunɛ a, bɛlɔla ye mɔ awɛ pupulidza. ");
INSERT INTO bov_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɛ foesũ edo osumunɛ bɛbã, lɛmɛ apaafɔ a bo ye malo, bido ye kɔnyɔã, ade bɛnyɛ ye osi mɔ awɛ pupulidza a. ");
INSERT INTO bov_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ade edo osumunɛ ɔlalɛde a. Apaafɔ a bo ye malo bipila ye ade bɛblɔmɛna ye a. ");
INSERT INTO bov_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kɔba ɔlate a via ye akũ kĩ, ‘Litsa maakɛna? Maado yĩ obi kĩ maátunɔ kalɛ ade matɛ kado kĩ baabu ye.’ ");
INSERT INTO bov_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Lɛmɛ kĩ apaafɔ a mɔ́ obi a, bibi akũ kĩ, ‘Ade kɔba ɔlate a obi nɛ awĩ a. Mifɔ̃ bɔkɔ ye lɔkɔa ye adzapadiɛ ɛkɛna boe ade.’ ");
INSERT INTO bov_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Foesũ bɛvɛlɛ ye bɛnɛmɛna nɛ kɔbã a kamɛ ade bɛkɔ ye a.” Ade Yesu via be kĩ “Litsa mikɔna kĩ kɔba ɔlate a aakɛna apaafɔ a? ");
INSERT INTO bov_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mabi mi kĩ yaayakɔ apaafɔ a na flee lɔkɔa ɛkɔa kɔba a edo nɛ apaafɔ bɛbã awɛ.” Kĩ bati a nu fukĩĩ a, bɛlɛ kĩ, “Kusɛ! Baguma lɛláakpa osi fɔya nɛ foe kamɛ lɔmɔ da!” ");
INSERT INTO bov_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ko anɛ ɛdã be ade evia be kĩ, “Litsa Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa atsa? ‘De a kĩ fɔla bakenɛ sĩ a, ade de lɛdani kɔla akũ de titiliwu a!’ ");
INSERT INTO bov_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Odi nyɛ odi kĩ yaatula ɛtɔ nɛ de a na akũ ni, yaaveliveli gblɛgblɛgblɛ, ade ke odi nyɛ odi kĩ de a na aatɔ nɛ ye akũ ni, laanuna ye kpɛtɛkpɛtɛkpɛtɛ.” ");
INSERT INTO bov_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yudafɔ mbla batsanɛ a mɔ Yudafɔ basɔfɔnɔkɔɛ̃ a bɔa mbɔdi kĩ bapi Yesu nɛ awã, kitonɛkĩ bɛmɔ́ biyi ɔsũ kĩ be sũ mɔ ɛbɔa lɛgbã a, lɛmɛ bivila bati a. ");
INSERT INTO bov_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nɛ foesũ bɛwɛ osi bɛbã kĩ ye akũ baatsã bipi ye. Bɛkpa banyole badi sika kĩ bɛkɛna be akũ ndɛ bati kĩ badi ɔnɔkɔali. Bido be kĩ bɛnaanaĩ Yesu nɛ fɔlɛtsa kavia katse kamɛ, lɔkɔa bɛna osi bɛkɔa ye bido nɛ banɔkɔɛ̃, mɔ Roma abãã ɔnɔkɔɛ̃ awɛ. ");
INSERT INTO bov_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bikĩ banaĩ Yesu a ya nɛ ye sɛkɛ̃, bibi ye kĩ, “Fɔtsa Ɔtsanɛ, bunyina kĩ fɔlɛtsa a kĩ alɛ mɔ fukĩ atsa a nyɛ ɔnɔkɔali. Bunyina lɛmɛ kĩ aádã oti anɛ, mbom atsa Baguma tisi a nɛ ɔnɔkɔali kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Finyaakĩĩ ni, bi boe ntɛ boe mbla kpa osi kĩ buse ɔgɔlɛ bɔkpa Romafɔ Lɛgãnɔkɔɛ̃, mbɔɛɛ kĩ ɛtákpa osi?” ");
INSERT INTO bov_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lɛmɛ Yesu mɔ́ be tɛdake a eyi ɔsũ ade ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Miyamɛna sika ovoe a sidi ndã. Owei lɔlɔ mɔ dĩ teĩ nɛ se akũ?” ");
INSERT INTO bov_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bɛkpa mbuayɛ kĩ, “Lɛgãnɔkɔɛ̃ Kaisare fude fɔanɛ.” Yesu bi be kĩ, “Kekɔ̃ mikɔa fukĩ fɔnyɛ Lɛgãnɔkɔɛ̃ fude a mikpa Lɛgãnɔkɔɛ̃, ade mikɔa fukĩ fɔnyɛ Baguma fude lɛmɛ mikpa Baguma a.” ");
INSERT INTO bov_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nɛ bati kɔdabu a anɛ kamɛ na a, bɛtápuli bipi ye nɛ osi odima akũ, foesũ bisua be tunukpɛ̃ nɛ Yesu mbuayɛ a kĩ ɛkɛna be wãwã sũ. ");
INSERT INTO bov_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ade Zadukifɔ kĩ balɛ kĩ kayidza kato kanɔkpa lɛláa a, ya nɛ Yesu sɛkɛ̃, bibi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Fɔtsa Ɔtsanɛ, Mose tsɛlɛ mbla ɛkpa boe kĩ, ‘Ntɛ onyole odi ku ɛfɔnɛ ɔtsɔ̃ kĩ bɛmɔ ye bɛtáma ni, onyole a ɔwaɛ̃ ɛkɔã otsole a lɔkɔa bɛmɔ ye bɛma babi bɛnya ekĩ eku a bade.’ ");
INSERT INTO bov_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lɔkɔ lidi ni, bawaɛ̃nyole evũkɔnɔ badi dzi nkpã. Ɔnɔkɔɛ̃de a kɔã ɔtsɔ̃ lɛmɛ eku, kĩ bɛtáma obi odima. ");
INSERT INTO bov_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɔwaɛ̃ ɔyade a mɔ ɔlalɛde a lɛmɛ kɔã okunawa, ade be malo biku kĩ bɛtáma babi badima a. ");
INSERT INTO bov_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ade lɛtsa mɔapɛ a lɛkɛna bawaɛ̃nyole evũkɔnɔ a flee a. Be flee biku nɛ kĩ otsole a táma obi ɛkpa be kamɛ odima. ");
INSERT INTO bov_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nɛ foe kawũna kamɛ a, otsole a mɔawɛ yaku. ");
INSERT INTO bov_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lɔkɔa nɛ luwi a kĩ banɔkpa aabuki biyidza bidzi nkpã a ni, be kamɛ owei ɔtsɔ̃ yaanya, nɛ kĩ be evũkɔnɔ a flee bɛkɔã tɔ̃ ye a?” ");
INSERT INTO bov_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kpa be mbuayɛ kĩ, “Katinya kĩĩ kamɛ mɔ́ otsole mɔ onyole akɔã akũ, ");
INSERT INTO bov_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lɛmɛ banyole mɔ batsole a kĩ bɛkpɔla kĩ baayidza bito kanɔkpa bidzi nkpã nɛ katinya kĩ kaaya a kamɛ a ni, bɛláakɔã batsɔ̃ ĩye bidzi fɔnyɔ. ");
INSERT INTO bov_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Baana ndɛ ode fɔtɔ banyanɛ, ade bɛláabuki biku da a. Bɛnyɛ Baguma babi kitonɛkĩ biyidza bito kanɔkpa. ");
INSERT INTO bov_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose nyɛ ɛtsa yededeede nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ badzɛla banɔkpa babuki kadzi nkpã, kitonɛkĩ lɔkɔ a kĩ ɛdza nɛ kutse a kĩ kɔkatɛ̃ anɛ kamɛ a, ɛvɛ Baguma kĩ Abraham Baguma Isak Baguma mɔ Yakob lɛmɛ Baguma. ");
INSERT INTO bov_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Fukĩĩ atsa kĩ ɛnyɛ bikĩ bidzi nkpã a Baguma, nnɛ́ banɔkpa Baguma yanɛ. Kitonɛkĩ nɛ Baguma sɛkɛ̃ ni, be flee bidzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nɛ awã a Yudafɔ mbla batsanɛ badi lɛ kĩ. “Fɔtsa Ɔtsanɛ, ɔkpa mbuayɛ kakpa wĩ paa!” ");
INSERT INTO bov_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ke liti odima tábuki edo ɔwɔlɛ evia ye kadima. ");
INSERT INTO bov_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu via be kĩ, “Nde sũ bati alɛ kĩ Kristo a aanya Lɛgã Dawid kasinu kamɛ obi? ");
INSERT INTO bov_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ade Dawid mɔawɛ a lɛ nɛ Tɔnɔ Ovoli a kamɛ kĩ, ‘Boe Ɔlate bi yĩ Ɔlate kĩ, “Dzi nɛ yĩ sɔmɔna ");
INSERT INTO bov_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kɛnaawo lɔkɔ a kĩ nkɔa nɔ bakesĩnɛ nkɛna nɔ abɔa katekɔ̃.” ’ ");
INSERT INTO bov_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ade ntɛ Dawid vɛ ye kĩ boe Ɔlate a, nde fɔya mɔ Kristo a aanya Dawid kasinu kamɛ obi?” ");
INSERT INTO bov_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kĩ bati a flee dza bɛkatse Yesu fɔlɛtsa a, ɛdani ebi ye fɔtsa bakɔlɛnɛ a kĩ, ");
INSERT INTO bov_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Midã kadã wĩ nɛ Yudafɔ mbla batsanɛ a akũ. Bati kĩĩ ado tɛtadiɛ wulaa katsã kamini, ade bawɛ kĩ bati bɛwɔ̃na be nɛ obu kamɛ nɛ kɔya a. Bawɛ banɔkɔɛ̃ fudzikɔ̃ nɛ Yudafɔ fɔtsɛnakɔ̃, mɔ fudzikɔ̃ wĩ nɛ fuwi kanyakɔ̃. ");
INSERT INTO bov_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bakɔa tɛdake kasisi bakunawa katɛ be tɔtɔ ade babɔa mpaɛ gɛlɛɛlɛ kakɔa kamu akũ a. Nɛ fukĩĩ sũ be sɔtɔ kavɛlɛ aaba bati flee fude!” ");
INSERT INTO bov_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nɛ Yudafɔ Asɔli Kɔla kamɛ a, Yesu ko anɛ ɛmɔ asikafɔ kĩ bɛkɔa be futetsa bɛkado nɛ ɔgɔlɛ adakã kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ade ɛmɔ okunawa ohiãni odi kĩ ɛyakɔa kaplɛ nviã edo nɛ adakã a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ade ebi be kĩ, “Mabi mi kĩ okunawa ohiãni kĩĩ te fɔtsa ɛba bati bɛbã a flee. ");
INSERT INTO bov_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kitonɛkĩ bati bɛbã a kɔ̃ ni, be akũ kana fɔtsa a kĩ fublusu a kamɛ fudi sukuloo bite, lɛmɛ otsole ohiãni kĩĩ kɔa lɛtsa a kĩ de akũ yaadzi nkpã a flee ɛyate nɛ awĩ.” ");
INSERT INTO bov_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fɔtsa bakɔlɛnɛ a kamɛ badi kalɛ kɔdzɛla nɛ Asɔli Kɔla a akũ, mɔ boe mɔ kalɛ a kĩ bɛkɔa bike koe, mɔ ayekĩ bɛkɛɛlɛ kɔla foebi a, mɔ fɔtsatewa a kĩ bakpa Baguma a. Lɛmɛ Yesu bi be kĩ, ");
INSERT INTO bov_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Lɛtsa nyɛ lɛtsa kĩ miamɔ nɛ awĩ a, lɔkɔ aaya kĩ de lidima lɛláabuki lite nɛ lɔkɔba akũ. Baadzuli be flee biwula.” ");
INSERT INTO bov_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ade ke bivia ye kĩ, “Fɔtsa Ɔtsanɛ, lɔkɔ lɔwɔdabe fukĩĩ aaya? Ade litsa bɔ́akɔa buyi ɔsũ kĩ lɔkɔ a wo ɔtɔ?” ");
INSERT INTO bov_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu bi be kĩ, “Midã kadã wĩ, mitafɔ̃ bɛkɛ mi. Bati pii aaya nɛ yĩ dĩ akũ bɛlɛ kĩ, ‘Yĩ nyɛ Ɔtɛnɛ a,’ mɔ ‘Lɔkɔ a wo ɔtɔ.’ Lɛmɛ mitatomɔ be. ");
INSERT INTO bov_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mitafɔ̃ libe liwo mi ntɛ minu kawũkanɔ mɔ bati kayidza kadza nɛ bati akũ nkã. Kɛnɛ kĩ fɔtsa kĩĩ bamɛ flee fɔnya lɔtɔ fɔya nɛ foe kamɛ, lɛmɛ fɔátsa kĩ katinya kawũna a fuã kiyua.” ");
INSERT INTO bov_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu lɛ ɛnamɛna lɔtɔ kĩ, “Ɔmaĩ mɔ ɔmaĩ aanɔ akũ, fɔgã mɔ fɔgã lɛmɛ aanɔ akũ. ");
INSERT INTO bov_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tite kakuna mɔ ɔsĩ mɔ ɔsĩ, kɔlɛ mɔ fɔsɔ kpa kumɛkumɛ lɛmɛ aaya nɛ kakɔ nyɛ kakɔ, ade libe mɔ awãwã fɔtsa aanɛ nɛ odetɔ́ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Fɔmɔ fɔtsa kĩĩ bamɛ flee aaya ni, baatomɔ mi liti, bipili mi bɛnamɛna Yudafɔ fɔtsɛnakɔ̃ bɛdzɛ̃mɔ mi, bibo mi lɔkɔa bido mi nɛ kɔla. Ade baakpã mi bɛnaadzɛla nɛ fɔgã mɔ abãã banɔkɔɛ̃ anɛ nɛ yĩ sũ. ");
INSERT INTO bov_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Fukĩĩ aakpa mi osi kĩ milɛ Kalɛ Wĩ a. ");
INSERT INTO bov_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mipi miyi kĩ miláaha akũ nɛ lɛtsa a kĩ míalɛ minyɛ mi akũ a akũ. ");
INSERT INTO bov_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kitonɛkĩ maakpa mi fɔlɛtsa mɔ kadikanyi ayekĩ mi bakesĩnɛ kamɛ odima lɛláapuli esĩ ĩye ɛlɛ kalɛ etia lɛtsa a kĩ míalɛ a. ");
INSERT INTO bov_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mi bamanɛ, bawaɛ̃, akũ bati mɔ bakɔba aanyɛ mi bɛkpa ade baakɔ mi kamɛ badi a. ");
INSERT INTO bov_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Odi nyɛ odi aakesĩ mi nɛ yĩ sũ. ");
INSERT INTO bov_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lɛmɛ mi lɔlɔ sɔlɔ mɔapɛ malo lɛláayɛla. ");
INSERT INTO bov_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Midza pintii lɔkɔa míana katɛ. ");
INSERT INTO bov_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ntɛ mimɔ́ kĩ sodzafɔ dza bisinya Yerusalem ni, minyi kĩ ɔmatɔ a kawɔla wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nɛ lɔkɔ a na kamɛ ni, bati a kĩ bideĩ nɛ Yudea bilo bɛnaa tɔtɔ akũ. Bikĩ bideĩ nɛ Yerusalem ɔmatɔ a kamɛ bilo bɛnɛ, ade bikĩ bɛláa ɔmatɔ a kamɛ bɛtabuki bimuniki bɛya nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kitonɛkĩ lɔkɔ a na aanya Sɔtɔ Kavɛlɛ fuwi fɔkpa bati, ayekĩ Katsɛlɛ Kpalɛwa fɔlɛtsa a aaya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Fɔ́ana ɔsĩ paa fɔkpa bamatsɔ̃ mɔ babima a kĩ babi amɛmɛ be a. Lubokamɔ baũ aaya nɛ tite kĩĩ akũ, ade Baguma sɔtɔ kavɛlɛ aaya nɛ bati kĩĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bati badi aatɔ nɛ lɛpamɛ onukpɛ̃, ade baapili badi ndom bɛnamɛna tite bɛbã akũ a. Ade bikĩ bɛnyɛ́ Yudafɔ aade bidzi nɛ Yerusalem bati akũ kɛnaawo lɔkɔ a kĩ Baguma yi ɛkpa be a wũna. ");
INSERT INTO bov_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awãwã fɔtsa aanɛ nɛ odetɔ́ kamɛ fɔkatsa nsɛntsɛlɛni nɛ suwa, odetɔ mɔ fusibii anɛ. Katinya kamɛ tɛmaĩ akũ aayɛla be, libe liwo be nɛ mpo kayili mɔ kavũ basabasa sũ. ");
INSERT INTO bov_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Libe aafɔ̃ anɛ lisinya bati nɛ lɔkɔ a kĩ baakadã anɛ kakpa lɛtsa a kĩ de aaya nɛ katinya kamɛ flee akũ a, kitonɛkĩ odetɔ́ kamɛ kɔbɛ̃ fɔtsa lɛláabuki fɔdza nɛ foe kadzakɔ̃. ");
INSERT INTO bov_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ke liti a Otidziwa Obi a aanɛ ɛta, ɛya nɛ luflututu kamɛ mɔ kɔbɛ̃ kpale mɔ ɔhaĩ. ");
INSERT INTO bov_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ntɛ fukĩĩ bamɛ flee do kaya awɛ ni, midzɛla fɔlɔ midã ode kitonɛkĩ mi katɛ lɔkɔ wo ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ade Yesu bɔa be lɛgbã kĩ, “Midã atɔ kutse mɔ futse bɛbã a. ");
INSERT INTO bov_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ntɛ mimɔ́ kĩ kɔnyɛ tɔɔta vɔɛ̃ ni, minyina kĩ kanɔde lɔkɔ wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ade ayea ntɛ mimɔ́ fɔtsa kĩĩ bamɛ kĩ fɔlamɛna kaya ni, míanyi kĩ Baguma lɛgãkanya a fuã. ");
INSERT INTO bov_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mabi mi pipiipi kĩ bati a kĩ bidzi finyaa lɛláaku biwoli fɔmɔ fɔtsa kĩĩ flee aaya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tite mɔ ode flee onukpɛ̃ aatɛ̃ lɛmɛ yĩ fɔlɛtsa a kɔ̃ aana daa. ");
INSERT INTO bov_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Midã akũ kadã wĩ. Mitakɔa mi akũ mikpa kanya mɔ kamɔa pɔtɔɔ, mɔ katinya kamɛ ɔhau. Ntɛ nnɛ́ aye ni, Luwi a aayafuta mi, ");
INSERT INTO bov_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ndɛ ayekĩ ɔyaɛ atɔ kpeĩ, kitonɛkĩ Luwi a aaketimɔ odi nyɛ odi kĩ edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Foesũ mina nɛ kukũmanɛ kamɛ, mikaabɔa mpaɛ luwi nyɛ luwi ayekĩ míana kɔbɛ̃ mitsã yedede nɛ fɔtsa a kĩ fɔ́aya a flee kamɛ, lɔkɔa miyaadza nɛ Otidziwa Obi a anɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu kanaatsa bati fɔtsa luwi nyɛ luwi nɛ Yudafɔ Asɔli Kɔla a kamɛ, ade ntɛ olobe wo ɔtɔ lɔkɔa yadzakũ kanaa Kugua Futse Ɔtɔ a akũ kawa nɛ awã. ");
INSERT INTO bov_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ɔnɔnɛ nyɛ ɔnɔnɛ ni, bati kɔdabu atsɛna nɛ Asɔli Kɔla a kamɛ katse ye fɔtsa katsa. ");
INSERT INTO bov_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yudafɔ Abodoo Kĩ Ɛtáyila Luwi a kĩ bavɛ Wuda Katɛ̃ Luwi a kanya wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yudafɔ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a kavila bati a, foesũ bɛkabɔa mbɔdi kawɛ osi kĩ baatsã bɛna Yesu bɛkɔ nɛ kabɛla kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ade Abonsam wo nɛ Yuda kĩ bavɛ Iskariot, kĩ ɛnyɛ fɔtsa bakɔlɛnɛ ewua-nviã a kamɛ ɔmɔa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Foesũ Yuda naa Yudafɔ basɔfɔnɔkɔɛ̃ mɔ Yudafɔ mɔ banɔkɔɛ̃ a kĩ badãmɛna Asɔli Kɔla akũ a sɛkɛ̃, ade bipi adzuni nɛ osi wĩ a kĩ ye akũ yaatsã ɛnyɛ Yesu ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kawɔlɛ de be ade bike otse kĩ baakpa ye sika. ");
INSERT INTO bov_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda tunɔ nɛ foe akũ, foesũ ɛkawɛ lɔkɔ wĩ kĩ yaanyɛ Yesu ɛkpa nɛ bati kɔdabu a katanyi kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Luwi a kĩ bakɔ Wuda Katɛ̃ kavelibi nɛ Abodoo Kĩ Ɛtáyila Luwi Kanya kamɛ a wo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ade ke Yesu do Petro mɔ Yohanes kĩ, “Minaa lɔkɔa minaamanɛ Wuda Katɛ̃ funitsã a miyi mikpa boe kanya.” ");
INSERT INTO bov_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nɛ awã a bivia ye kĩ, “Nɛ ndia awɛ kĩ bɔnaamanɛ foe buyi?” ");
INSERT INTO bov_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu kpa mbuayɛ kĩ, “Ntɛ miawo nɛ Yerusalem ɔmatɔ a kamɛ ni, onyole odi kĩ ɛnɔnɛ kugumi mɔ mui aatsɛlamɔ mi. Mitomɔ ye miwo nɛ tɔtɔ a kĩ te kamɛ yaawo a. ");
INSERT INTO bov_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mibi tɔtɔ ɔlate a kĩ, ‘Fɔtsa Ɔtsanɛ bo buvia nɔ kĩ, “Nde kɔla kĩ koe kamɛ bɔmɔ yĩ fɔtsa bakɔlɛnɛ a bɔ́anya Wuda Katɛ̃ funitsã a?” ’ ");
INSERT INTO bov_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yaatsa mi kɔla kpale kudi nɛ abansulu ode kĩ bike opunu mɔ fukpo nɛ koe kamɛ. Mifɔ̃ bɛmanɛ lɛtsa nyɛ lɛtsa biyi nɛ awã.” ");
INSERT INTO bov_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bipi osi ade bɛnamɔ lɛtsa nyɛ lɛtsa pɛpɛɛpɛ ndɛ ayekĩ Yesu bi be a, ade bɛtɔ Wuda Katɛ̃ funitsã a nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yesu mɔ ye fɔtɔ banyanɛ a nadzi nɛ opunu akũ kĩ banya. ");
INSERT INTO bov_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ade ebi be kĩ, “Fɔnyɛ yĩ kawɛ kɔkɔɛ kĩ bɔmɔ mi bɔnya Wuda Katɛ̃ Funitsã kĩĩ fɔmɔ maamɔ lubo. ");
INSERT INTO bov_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mabi mi kĩ nláabuki ĩnya funitsã kĩĩ kɛnaawo lɔkɔ a kĩ foe kayɔkanu flee a ya nɛ Baguma lɛgãkanya a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ke liti a, Yesu bɔɛ kɔɔpu, ɛnyɛ Baguma kɔlɛ ade ɛlɛ kĩ, “Mitɛ fukĩĩ misɛ̃ mikpa akũ. ");
INSERT INTO bov_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mabi mi kĩ kito finyaa kanaa ni, nláabuki mmɔa waĩ kɛnaawo kĩ Baguma lɛgãkanyakɔ̃ a ya.” ");
INSERT INTO bov_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ade ɛbɔɛ abodoo, ɛnyɛ Baguma kɔlɛ, ebulibuli ye ɛkpa be ɛlɛ kĩ, “Ade yĩ sukɛna kĩ bɛkɔa bakpa nɛ mi lɔlɔ a. Mikɛna fukĩĩ mikɔa mikai yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ade ayea kĩ bɛnya biyua a, ɛbɔɛ kɔɔpu mɔ waĩ ɛlɛ kĩ, “Kɔɔpu kĩĩ nyɛ Baguma nhihiɛ vɔɛ̃ kĩ esipi nɛ foe akũ mɔ yĩ babɔanɛ a kĩ maako nɛ tite nɛ mi lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lɛmɛ midã, oti a kĩ yaanyɛ yĩ ɛkpa a, bɔmɔ ye budzi nɛ kanyakɔ̃ nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Otidziwa Obi a kɔ̃, aaku ndɛ ayekĩ Baguma hihiɛ eyi a. Lɛmɛ bɔbɔɛ bakpa owula a kĩ yaanyɛ ye ɛkpa a.” ");
INSERT INTO bov_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nɛ awã a biyi akũ kavia kayɔ kĩ be kamɛ owei aakɛna fukĩĩ odu. ");
INSERT INTO bov_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Fɔlɛtsa kavɛlɛ fudi yawo nɛ fɔtsa bakɔlɛnɛ a kamɛ kĩ be kamɛ owei baabu kĩ ɛbɛ̃ flee. ");
INSERT INTO bov_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ade ke Yesu bi be kĩ, “Bati a kĩ bɛnyɛ́ Yudafɔ a, be fɔgã deĩ otumi mɔ ɔsĩ nɛ be akũ, ade fɔgã kĩĩ te be akũ buĩ kĩ, Bati Bakɔba. ");
INSERT INTO bov_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lɛmɛ fɔtana lɔmɔ nɛ mi kamɛ. Mbom oti a kĩ ɛbɛ̃ flee nɛ mi kamɛ ni, ɛkɛna ye akũ ndɛ obisɛ̃ kɔlaa. Ade kɛnɛ kĩ lɔtɔ ɔnyanɛ nɛ mi kamɛ ɛna ndɛ osumunɛ ayea. ");
INSERT INTO bov_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Owei bɛ̃ ɔkɔba, ekĩ edzi yanya mbɔɛɛ ekĩ yasum ye a? Fɔwaa yededeede kĩ ekĩ edzi yanya a bɛ̃. Lɛmɛ ndeĩ nɛ mi kamɛ ndɛ osumunɛ aye. ");
INSERT INTO bov_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mina nɛ yĩ akũ nɛ yĩ sɔhuiɛ flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ndɛ ayekĩ Nda kpa yĩ kɔbɛ̃ kĩ ĩnya bati akũ a, ade ayea maakpa mi kɔbɛ̃ a na odu a. ");
INSERT INTO bov_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Míanya mimɔa mɔ yĩ nɛ opunu akũ nɛ yĩ lɛgãkanyakɔ̃ a kamɛ, ade míadzi nɛ fɔgãkpo akũ minya Israel futete ewua-nviã a akũ a.” ");
INSERT INTO bov_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu vɛ Simon Petro ɛlɛ kĩ, “Simon, Simon! Tse katse wĩ! Bɛkpa Abonsam osi kĩ ɛsɔ mi ɛdã lɔkɔa ɛsa bati wĩ a nɛ bakpa kamɛ, ndɛ ayekĩ okuani awɛ afafa kanyɛ nɛ kamɔnɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lɛmɛ Simon, mbɔa mpaɛ nkpa nɔ kĩ nɔ katɛkado kɛtadĩ. Ade ntɛ ɔyamuniki ɔya nɛ yĩ sɛkɛ̃ ni, do awaɛ̃ amɛ kɔbɛ̃.” ");
INSERT INTO bov_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Awã naa Petro kpa mbuayɛ kĩ, “Boe ɔlate, mmanɛ akũ nkpa kĩ bɔmɔ nɔ aawa kɔla ĩye kĩ bɔmɔ nɔ aaku!” ");
INSERT INTO bov_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ade Yesu bi ye kĩ, “Petro, mabi nɔ kĩ fɔmɔ ɔkɔkɔ aanyɛ onukpɛ̃ nviã lɛnyɛ kĩĩ ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu via ye fɔtsa bakɔlɛnɛ a kĩ, “Lɔkɔ a kĩ ndo mi fɔtɔ kĩ ntáfɔ̃ mibɔɛ sika kuvũ, ĩye kuvũ kĩ babɛla ĩye mpabua a ni, litsedi nasĩ mi?” Bɛkpa mbuayɛ kĩ, “Lɛtsama tásĩ boe.” ");
INSERT INTO bov_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ade Yesu bi be kĩ, “Finyaakĩĩ kɔ̃ ni, odi nyɛ odi kĩ edeĩ sika kuvũ ĩye osi akũ kanaa kuvũ ni, ɛbɔɛ ɛlɛ, ade oti kĩ ɛlá lɛpamɛ gɛlɛɛlɛ ni, kɛnɛ kĩ ɛnɔ ye atadiɛ wulaa lɔkɔa ɛya lɔmɔa. ");
INSERT INTO bov_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mabi mi kĩ Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa a kĩ fɔlɛ kĩ, ‘Bibu ye bido nɛ tɔkpa bakɛnanɛ kamɛ,’ a kɛnɛ kĩ fɔya nɛ yĩ akũ. Kitonɛkĩ fɔtsa a kĩ bɛtsɛlɛ nɛ yĩ akũ a lamɛna kaya nɛ foe kamɛ pɛpɛɛpɛ.” ");
INSERT INTO bov_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Fɔtsa bakɔlɛnɛ a bi ye kĩ, “Boe Ɔlate, amɔ, fɔpamɛ gɛlɛɛlɛ nviã nɛ awĩ!” Ade Yesu bi be kĩ, “Fɔlɛ!” ");
INSERT INTO bov_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu dzakũ ɛnɛ nɛ ɔmatɔ a kamɛ ɛnaa Kugua Futse Ɔtɔ akũ ndɛ ayekĩ yawɛ kakɛna a, ade ye fɔtsa bakɔlɛnɛ lɛmɛ to mɔ ye a. ");
INSERT INTO bov_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kĩ ewo awã a, ebi be kĩ, “Mibɔa mpaɛ ayekĩ sɔhuiɛ lɛláanya nɛ mi akũ.” ");
INSERT INTO bov_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɛvɛlɛ akũ nɛ be sɛkɛ̃ ɛnaa lɔtɔ sukuloo, ade ɛnake aduli ɛbɔa mpaɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ɛlɛ kĩ, “Nda, ntɛ fɔnyɛ nɔ kawɛ ni, tinya lubo kamɔ kɔɔpu kĩĩ nɛ yĩ akũ. Lɛmɛ takɛna nɛ yĩ kawɛ akũ, mbom kɛna nɛ nɔ kawɛ akũ.” ");
INSERT INTO bov_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nɛ awã naa, ode fɔtɔ ɔnyanɛ odi to ode ɛnyɛ ye akũ ɛtsa ye, edo ye kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɛna nɛ ayɔlɔhɔ mɔ kɔnɛyɔɔlɛ kamɛ, ɛbɔa mpaɛ mɔ ɔsĩ mɔ ɔsĩ ebu ade ye olulu na ndɛ babɔanɛ fɔbɔ, kako nɛ tite a. ");
INSERT INTO bov_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kĩ Yesu yidza nɛ mpaɛbɔ kamɛ a, emuniki ɛnaa ye fɔtsa bakɔlɛnɛ a sɛkɛ̃, ɛnamɔ be kĩ bɛwaa tida nɛ ayɔlɔhɔ a kĩ epi be a sũ. ");
INSERT INTO bov_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ebi be kĩ, “Nde sũ miawa tida? Miyidza mibɔa mpaɛ ayekĩ miláawo nɛ sɔhuiɛ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lɔkɔ a kĩ Yesu lamɛna kɔdzɛla kalɛ a, bati kɔdabu kudi de kɔnɛ. Yuda kĩ ɛnyɛ fɔtɔ banyanɛ ewua-nviã a kamɛ ɔmɔa nyaa be lɔtɔ. Efuã Yesu, etu eboomu ye. ");
INSERT INTO bov_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lɛmɛ Yesu bi ye kĩ, “Yuda, ɔkɔa onukpɛ̃ kadzɛmɛ anyɛ Otidziwa Obi a ɔkpa bati?” ");
INSERT INTO bov_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kĩ fɔtsa bakɔlɛnɛ a kĩ bɛna nɛ ye akũ a mɔ́ lɛtsa a kĩ laya nɛ Yesu akũ a, bivia ye kĩ, “Boe Ɔlate, bɔkɛna boe fɔpamɛ gɛlɛɛlɛ a akũ adzuma?” ");
INSERT INTO bov_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lɛtalɛta be kamɛ ɔmɔa tsua Ɔsɔfɔnɔkɔɛ̃ Flee a osumunɛ sɔmɔna sɔtɔ emuni. ");
INSERT INTO bov_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lɛmɛ Yesu lɛ kĩ, “Oowo! Fukpula nɛ awã!” Ade ke ɛta awã kĩ bitsua sɔtɔ a ɛtsa ye a. ");
INSERT INTO bov_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ke liti a, Yesu bi basɔfɔnɔkɔɛ̃ mɔ banɔkɔɛ̃ a kĩ badãmɛna Asɔli Kɔla akũ a mɔ ɔmaĩ banɔkɔɛ̃ a kĩ bɛyaapi ye a kĩ, “Nde sũ minɛɛ futsekpa mɔ fɔpamɛ miyaapi yĩ ndɛ tɔkpa ɔkɛnanɛ aye? ");
INSERT INTO bov_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nna nɛ mi kamɛ nɛ Yudafɔ Asɔli Kɔla a kamɛ luwi nyɛ luwi, ade ke mitádo ɔwɔlɛ mipi yĩ a. Lɛmɛ mi lɔkɔ liwo ɔtɔ kĩ mikɛna mi adzuma a, nɛ lɔkɔ kĩ Abonsam ɔtũ kɔbɛ̃ a anya akũ finyaa.” ");
INSERT INTO bov_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Foesũ bipi Yesu ade bɛkpã ye bɛnamɛna Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee a awã a. Petro lɛmɛ tomɔ be ɛna nɛ liti flee. ");
INSERT INTO bov_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bɛkpɔta fi nɛ tɔtɔ a lɔwabe ade Petro lɛmɛ nadzi nɛ bati a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kĩ bikĩ banya abawa kamɛ adi yamɔ Petro kĩ edzi yawa fi a, eke anɛ nɛ ye akũ ade ɛlɛ kĩ, “Obi kĩĩ malo tomɔ Yesu.” ");
INSERT INTO bov_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lɛmɛ Petro sĩ ade ɛlɛ kĩ, “Otsole dã, ĩnyina ye kɔlaa!” ");
INSERT INTO bov_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Owi tábuna mɔ onyole odi mɔ́ Petro eyi ɔsũ a ade ɛlɛ kĩ, “Nɔ malo ɔnyɛ be kamɛ ɔmɔa!” Lɛmɛ Petro kpa mbuayɛ kĩ, “Onyole dã, nnɛ́ yĩ manɛ!” ");
INSERT INTO bov_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ndɛ ndɔũhuilɛ mɔa liti a, onyole bɛbã yalɛ pipiipi kĩ, “Atsindze katɛ lɛláa nɛ foe kamɛ kĩ oti kĩĩ tomɔ Yesu, kitonɛkĩ ɛnyɛ Galileani!” ");
INSERT INTO bov_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lɛmɛ Petro kpa mbuayɛ kĩ “Onyole dã, ĩnyína lɛtsa a kĩ de ɔlamɛna kalɛ!” Mɔ Petro onukpɛ̃ katɔ pɛ, ɔkɔkɔ nyɛ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Boe Ɔlate dani ɛdã Petro, ade Petro te anɛ kĩ boe Ɔlate bi ye kĩ, “Fɔmɔ ɔkɔkɔ aanyɛ onukpɛ̃ lɛnyɛ kĩĩ ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” ");
INSERT INTO bov_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ade ke Petro nɛ ɛnaa kanya ɛnabe blobloblo a. ");
INSERT INTO bov_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bati a kĩ bɛdãmɛna Yesu akũ a di ye nsekuo bibo ye lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bisui ye anɛ ade bivia ye kĩ, “Bi boe owula a kĩ ɛbɔa nɔ.” ");
INSERT INTO bov_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ade bibi ye fuvũnatsa pii lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kĩ kade nyina a, ɔmaĩ banɔkɔɛ̃, basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a yakpɔta ade bɛkpã Yesu bɛyadzɛla nɛ be anɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɛ awã a, bivia Yesu kĩ, “Bi boe ntɛ nɔ nyɛ Kristo a.” Ade Yesu kpa mbuayɛ kĩ, “Ntɛ nlɛ kadi malo miláatɛ yĩ mido. ");
INSERT INTO bov_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ade ntɛ nvia mi kadi malo ni, miláakpa mbuayɛ. ");
INSERT INTO bov_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lɛmɛ kito nviã kĩĩ kanaa ni, baadzina Otidziwa Obi a nɛ Baguma Kpale Nɛ Ode a sɔmɔna.” ");
INSERT INTO bov_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ade ke be a flee bivia ye kĩ, “Foesũ Baguma obi anɛ?” Yesu kpa be mbuayɛ kĩ, “Mi lamɛna kalɛ kĩ ye manɛ.” ");
INSERT INTO bov_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ade bɛlɛ kĩ, “Bɔtásĩ adansifɔ badima. Boe mɔawɛ a bunu lɛtsa a kĩ ɛlɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ade bati kɔdabu a flee yidza bɛkpã Yesu bɛnamɛna Pilato sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ade bido ye onukpɛ̃ katsua awɛ kalɛ kĩ, “Bupi obi kĩĩ kĩ ɛlamɔ boe kade bati adzuni kadani. Yabi be kĩ bɛtate ɔgɔlɛ bɛkpa Romafɔ Lɛgãnɔkɔɛ̃. Ɛbɔɛ ye akũ kĩ ye nyɛ Kristo, lɛgã a.” ");
INSERT INTO bov_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato via ye kĩ, “Nɔ nyɛ Yudafɔ Lɛgã a?” Yesu kpa mbuayɛ kĩ, “Oo, fɔla ndɛ aye kĩ ɔlɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ade Pilato bi Yudafɔ basɔfɔnɔkɔɛ̃ mɔ bati kɔdabu a kĩ, “Ntámɔ lɛtsama nɛ ye akũ kĩ madza nɛ foe akũ nkɔ oti kĩĩ kɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lɛmɛ bɛdzɛmɛna kalɛ kabuli kĩ, “Ɛnɛɛ ye fɔtsa katsa yado ɔtutũ nɛ bati kamɛ nɛ Yudea tite flee akũ. Eyi fukĩĩ kayɔ nɛ Galilea ade finyaa ɛkɔa foe ɛyamɛna nɛ awĩ lɛmɛ a.” ");
INSERT INTO bov_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kĩ Pilato nu fukĩĩ a, evia be kĩ, “Galileani yanɛ?” ");
INSERT INTO bov_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Foesũ kĩ enyi kĩ Yesu to Galilea nɛ awã kĩ Lɛgã Herodes anya akũ a, ɛkɔa ye ɛma Herodes, kĩ ɛna nɛ Yerusalem nɛ lɔkɔ a na kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kawɔlɛ de Herodes paa kĩ ɛmɔ Yesu, kitonɛkĩ enu ye nkã ade ɛkawɛ kĩ yamɔ ye anɛ kɔkɔkɔɛ a. Ɛkadã anɛ kĩ Yesu aakɛna awãwã fɔtsa fudi ɛtsa ye. ");
INSERT INTO bov_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Foesũ Herodes via Yesu fɔlɛtsa pii lɛmɛ Yesu tábinya onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Awã naa Yudafɔ basɔfɔnɔkɔɛ̃ mɔ mbla batsanɛ a nɛ bɛyadza nɛ lɔtɔ bitsua fɔlɛtsa mɔ ɔsĩ mɔ ɔsĩ bite nɛ Yesu akũ. ");
INSERT INTO bov_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lɛgã Herodes mɔ ye sodzafɔ a di Yesu nsekuo bisupa ye. Bido ye atadiɛ wulaa mɔ kalɛ ndɛ lɛgã aye, bimuniki mɔ ye bɛma Pilato. ");
INSERT INTO bov_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Luwi a na, Herodes mɔ Pilato dani bɛkɛna bakɔba, kufɛ kɔkɔɛ a bakesĩ akũ. ");
INSERT INTO bov_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato vɛ Yudafɔ basɔfɔnɔkɔɛ̃, ɔmaĩ banɔkɔɛ̃ mɔ bati a ɛkpɔta. ");
INSERT INTO bov_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ade ebi be kĩ, “Mikpã oti kĩĩ mima yĩ ade milɛ kĩ ɛlamɔ bati adzuni kadani a. Finyaa nɛ mi anɛ kamɛ nɛ awĩ a, nvia ye onukpɛ̃ kamɛ tuwuli, ade fɔlɛtsa a kĩ mibɔɛ nɛ ye akũ a, ntámɔ tɔkpa tidima nɛ foe kamɛ kĩ makɔ ye kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Lɛgã Herodes lɛmɛ támɔ tɔkpa tidima nɛ ye akũ foesũ emunikimɔ ye ɛma boe. Oti kĩĩ tákɛna tɔkpa tidima kĩ ɛfɛta ɛkpa wuda. ");
INSERT INTO bov_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Foesũ maafɔ̃ bibo ye nfɔnɛ ye awɛ ɛdzakũ ɛnaa.” ");
INSERT INTO bov_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nɛ Wuda Katɛ̃ Luwi kanya kamɛ ni, kɛnɛ kĩ Pilato ɛfɔnɛ bati a kĩ bɛwaa kɔla a kamɛ ɔmɔa awɛ ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bati kɔdabu a flee bɔa fɔwɔla kɔɔba kĩ, “Kɔ ye! Fɔnɛ Baraba awɛ kakpa boe!” ");
INSERT INTO bov_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bido Baraba nɛ kɔla kĩ edo ɔtutũ nɛ ɔmatɔ kpale kamɛ, ɛkɔ bati lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato wɛ kĩ yafɔnɛ Yesu awɛ foesũ ebuki ɛnyɛ fɔlɛtsa kamɛ ɛtsa bati kɔdabu a. ");
INSERT INTO bov_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lɛmɛ bɛbɔa fɔwɔla biko nɛ ye akũ kĩ, “Bɔa ye nɛ asendua akũ! Bɔa ye nɛ asendua akũ!” ");
INSERT INTO bov_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato buki ebi be lɛlalɛde kĩ, “Mɔ litsa tɔkpa oti kĩĩ kɛna? Ntámɔ lɛtsa kĩ ɛkɛna kĩ yana foe akũ wuda! Maafɔ̃ bibo ye lɔkɔa nfɔnɛ ye awɛ.” ");
INSERT INTO bov_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lɛmɛ bati a dzɛmɛna fɔwɔla kabɔa kɔɔba kĩ bɛbɔa Yesu nɛ asendua akũ. Nɛ foe kawũna kamɛ a, bati a fɔwɔla kabɔa nya Pilato akũ. ");
INSERT INTO bov_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Foesũ Pilato kɔ Yesu kɔtɔ ndɛ ayekĩ bati a wɛ a. ");
INSERT INTO bov_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ade ɛfɔnɛ oti a kĩ bawɛ a awɛ ɛkpa be a, oti kĩ bido nɛ kɔla nɛ ɔtutũ mɔ bati kakɔ sũ, ade ɛkɔa Yesu edo nɛ be awɛ kĩ bɛkɛna ye ndɛ ayekĩ bɛwɛ a. ");
INSERT INTO bov_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sodzafɔ a kpã Yesu bɛnamɛna. Ade kĩ banaa nɛ osi a, bɛtsɛlamɛna Kireneni onyole odi kĩ bavɛ Simon, kĩ eto akula adi kamɛ yanna Yerusalem. Bipi ye bɛhɛ ye kĩ ɛlɔ asendua a etomɔ Yesu nɛ liti. ");
INSERT INTO bov_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bati kɔdabu baũ a tomɔ Yesu nɛ liti, ade batsole nɛ be kamɛ kabe kakpa ye a. ");
INSERT INTO bov_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu dani ɛtsɛlamɔ be ebi be kĩ, “Yerusalem batsole, mitabe mikpa yĩ mbom mibe mikpa mi babi mɔ mi akũ. ");
INSERT INTO bov_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kitonɛkĩ lɔkɔ aaya kĩ bati aalɛ kĩ, ‘Be a kĩ bɛnyɛ baduko, be a kĩ bɛtátsãmɔ kɔma bɛma tɔ̃, mɔ be a kĩ bɛtámɛmɛ be tɛmɛ tɔ̃ a na lɔlɔ wĩ!’ ");
INSERT INTO bov_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ade lɔkɔ a na mɔ bati aabi tɔtɔ kĩ, ‘Midzuli miko nɛ boe akũ!’ Ade baabi kɔtɔbii kĩ, ‘Mikɔla boe!’ ");
INSERT INTO bov_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kitonɛkĩ ntɛ bɛkɛna fukĩĩ nɛ kutse gɔ̃ akũ ni, nde fɔána fɔkpa kutse wɔlɛwa?” ");
INSERT INTO bov_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bɛkpã banyole bɛbã nviã kĩ bɛnyɛ tɔkpa bakɛnanɛ bibumɔ Yesu kĩ bɛnaakɔ be. ");
INSERT INTO bov_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kĩ biwo awã kĩ bavɛ kĩ Oti Lɔlɔ Fɔtsɔ̃ a, bɛbɔa Yesu nɛ asendua akũ. Bɛbɔa banyole nviã a lɛmɛ nɛ asendua akũ, ɔmɔa nɛ ye sɔmɔna, ɔyade a nɛ ye sɛbã. ");
INSERT INTO bov_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ade Yesu lɛ kĩ, “Nda, kɔa kate be, kitonɛkĩ binyína lɛtsa a kĩ bɛlamɛna kakɛna.” Ke liti a sodzafɔ a wole ade bɛsɛ̃ Yesu tɛtadiɛ bɛkpa be akũ a. ");
INSERT INTO bov_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bati a flee dza nɛ awã bɛkadã foe. Ade Yudafɔ banɔkɔɛ̃ a di Yesu nsekuo bɛlɛ kĩ, “Ɛtɛ bati bɛbã nkpã foesũ ntɛ ye nyɛ Kristo a kĩ Baguma pau a ni, ɛnyɛ ye akũ!” ");
INSERT INTO bov_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ade ayea sodzafɔ a lɛmɛ di Yesu nsekuo a. Bifuã ye bɛkɔa waĩ mɔ ɔnyɛ mɔ ɔnyɛ bɛkpa ye kĩ ɛmɔa. ");
INSERT INTO bov_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ade bibi ye kĩ, “Ntɛ nɔ nyɛ Yudafɔ lɛgã a ni, tɛ nɔ akũ!” ");
INSERT INTO bov_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɛtsɛlɛ fɔlɛtsa kĩĩ nɛ ye lɔlɔ nyangɛ kĩ, “Ade Yudafɔ Lɛgã nɛ awĩ a.” ");
INSERT INTO bov_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tɔkpa bakɛnanɛ a kĩ bɛbɔa nɛ asendua akũ a kamɛ ɔmɔa vũna Yesu kĩ, “Nnɛ́ nɔ nyɛ Kristo a? Tɛ nɔ akũ katɛ boe malo!” ");
INSERT INTO bov_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lɛmɛ ɔyade a wũni nɛ ye akũ kĩ, “Aávila Baguma mbɔɛɛ? Ɔtɛ sɔtɔ kavɛlɛ mɔapɛ a kĩ ɛtɛ a. ");
INSERT INTO bov_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lɛmɛ boe sɔtɔ kavɛlɛ a fɛta boe, kitonɛkĩ lɛtsa a kĩ bɔkɛna a, ade de sɔtɔ kavɛlɛ bɔtɛ a. Lɛmɛ ɛtákɛna tɔkpa tidima.” ");
INSERT INTO bov_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ade ebi Yesu kĩ, “Yesu, te anɛ nɛ yĩ akũ ntɛ owo nɔ lɛgãkanyakɔ̃ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Awã naa Yesu bi ye kĩ, “Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ nviã kĩĩ aana nɛ yĩ sɛkɛ̃ nɛ Paradiso kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kĩ kite sukuloo suwa tɔdɔũ ewua-nviã abɔa a, suwa fɔ̃ kata, ade ɔtũ ke nɛ katinya flee kamɛ kɛnawo tɔdɔũ ɛlalɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ade lima a kĩ lɛvanɛ nɛ Asɔli Kɔla kamɛ a bɛ̃ nɛ kayite a. ");
INSERT INTO bov_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu bɔa fɔwɔla kɔɔba kĩ, “Nda, nkɔa yĩ kawɛya ndo nɛ nɔ awɛ.” Kĩ ɛlɛ fukĩĩ a, eku. ");
INSERT INTO bov_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sodzafɔ ɔnɔkɔɛ̃ a mɔ́ lɛtsa a kĩ lɛya, ade emu Baguma ɛlɛ kĩ, “Fɔnyɛ ɔnɔkɔali kĩ oti wĩ yanɛ.” ");
INSERT INTO bov_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kĩ bati a kĩ bɛkpɔta nɛ awã bɛkadã foe flee a mɔ́ lɛtsa a kĩ lɛya a, bɛdzakũ bɛnaa kɔla mɔ ayɔlɔhɔ mɔ akpɔ kako nɛ lɔlɔ mɔ ɔwɔlɛ. ");
INSERT INTO bov_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bati a kĩ binyina Yesu kanyina wĩ a, mɔ batsole a kĩ bitomɔ ye bito Galilea a, dza mɔ lugo bɛkadã fɔtsa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Onyole odi kĩ bavɛ Yosef kĩ edzi nɛ Arimatia ɔmatɔ a kamɛ nɛ Yudea tite akũ na nɛ awã. Ɛnya oti wĩ kĩ ye akũ deĩ obu, ade ɛkadã anɛ kakpa lɔkɔ a kĩ Baguma lɛgãkanyakɔ̃ a aaya. ");
INSERT INTO bov_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Titɔ kĩ ɛna nɛ Yudafɔ ɔmaĩ banɔkɔɛ̃ fɔlɛtsa badzɛnɛ katsɛna a kamɛ malo ni, ɛtátunɔ nɛ lɛtsa a kĩ de akũ bike otse, mɔ lɛtsa a kĩ bɛkɛna a akũ. ");
INSERT INTO bov_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɛnaa Pilato anɛ kamɛ ade ɛnawã Yesu ɔnɔkpa a. ");
INSERT INTO bov_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ade ke ɛvɛnya ɔnɔkpa a ɛkɔa lima ovoe esuli ye a. Ɛkɔa ye ɛwɔla nɛ linikɛ kĩ bɛnyɛ nɛ de kamɛ, kĩ bɛtábila odima nɛ de kamɛ tɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Luwi a nya Efieda ade Kawɛya Luwi a lamɔ ɔtɔ kawo a. ");
INSERT INTO bov_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Batsole a kĩ bitómɔ Yesu bito Galilea tomɔ Yosef bɛnadã linikɛ a, mɔ ayekĩ bɛkɔa Yesu ɔnɔkpa bɛwɔla nɛ de kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ke liti a, bimuniki bɛnaa kɔla bɛnamanɛ tutsonu mɔ fugua mɔ ɔlɛ̃ mɔ ɔlɛ̃ kĩ baakɔa bɛtsɛla ɔnɔkpa a biyi. Nɛ Kawɛya Luwi akũ a, bidzi bɛwɛya nɛ be mbla a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ɛkwansieda ɔnɔnɛ tutuutu a, batsole a naa linikɛ a ɔwɛ̃, bɛnɛɛ lɛtsa nyɛ lɛtsa a kĩ bɛmanɛ biyi a. ");
INSERT INTO bov_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Awã naa bɛmɔ́ kĩ bimininya de kpale a kĩ bɛkɔa bisua linikɛ onukpɛ̃ a biyi nɛ ɔɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Foesũ biwo nɛ de kamɛ lɛmɛ bɛtámɔ boe Ɔlate Yesu ɔnɔkpa a. ");
INSERT INTO bov_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bɛkɛna saa bɛdzɛ̃ bakɔna foe akũ, ade lɛtalɛta bati nviã kĩ bɛna nɛ tɛtadiɛ kĩ tata muamua kamɛ nɛ bɛta nɛ be akũ a. ");
INSERT INTO bov_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Libe wo be paa foesũ bɛkɛna akũ nɛ kayɔ bɛkpa be, ade banyole a bi be kĩ, “Nde sũ miawɛ oti kĩ edzi nkpã nɛ banɔkpa kamɛ? ");
INSERT INTO bov_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɛláa awĩ. Eyidza eto kanɔkpa! Mite anɛ nɛ lɛtsa a kĩ ebi mi nɛ lɔkɔ a kĩ ɛna nɛ Galilea kĩ, ");
INSERT INTO bov_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kɛnɛ kĩ bɛkɔa Otidziwa Obi a bido nɛ bati kpa awɛ, baabɔa ye nɛ asendua akũ, lɔkɔa nɛ fuwi ɛlalɛ liti a, eyidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ade batsole a te anɛ nɛ ye fɔlɛtsa a akũ a. ");
INSERT INTO bov_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bimuniki bito linikɛ a ɔwɛ̃ bɛnabi fɔtsa bakɔlɛnɛ ewua-odi a mɔ bati bɛbã fɔlɛtsa a flee. ");
INSERT INTO bov_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Batsole a nyɛ Maria Magdalani, Yohana mɔ Maria kĩ ɛnyɛ Yakobo ɔma. Bɛmɔ batsole bɛbã a bɛnabi fɔtɔ banyanɛ a fɔlɛtsa a flee. ");
INSERT INTO bov_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lɛmɛ fɔtɔ banyanɛ a kɔna kĩ lɛtsa a kĩ bibi be a nyɛ fɔkɔasiatsa, foesũ bɛtátɛ be bido. ");
INSERT INTO bov_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lɛmɛ Petro ta eyidza ewula atsɛ ɛnaa linikɛ a ɔwɛ̃. Ɛkɛna akũ ɛdã de kamɛ ade ɛmɔ ɔnɔkpa tilima odi a. Ɛkɛna saa emuniki ɛnaa kɔla nɛ lɛtsa a kĩ lɛya a sũ. ");
INSERT INTO bov_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nɛ luwi mɔapɛ a akũ a, bikĩ bitómɔ Yesu a be kamɛ bati nviã tsɛ̃ osi banaa akula adi kĩ bavɛ Emaus kamɛ. Osi a lugo aana ndɛ fusikũ evũkɔnɔ kito awã kɛnaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bati a kalɔmɛna nɛ fɔlɛtsa a kĩ fɔya a flee akũ. ");
INSERT INTO bov_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kĩ bɛkalɔmɛna kanyɛ fɔlɛtsa kamɛ a, Yesu yapi be ade bɛtsã bɛnaa a. ");
INSERT INTO bov_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bɛmɔ́ ye lɛmɛ bɛtáyi ɔsũ kĩ ye yanɛ. ");
INSERT INTO bov_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu via be kĩ, “Litsa akũ milamɛna kalɔmɛna nɛ osi a?” Bɛfɔ̃ bɛdza dĩĩ mɔ anɛ kamɛ mɔ kɔnya. ");
INSERT INTO bov_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ade be kamɛ ɔmɔa kĩ bavɛ Kleopa via ye kĩ, “Nɔ odi nyɛ ɔnɔvɔɛ̃ nɛ Yerusalem kĩ ɔtánu lɛtsa a kĩ de lɛya nɛ fuwi lukũ kĩĩ kamɛ a mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu via be kĩ, “Litsa fɔlɛtsa lɛya?” Bɛkpa ye mbuayɛ kĩ, “Fɔlɛtsa a kĩ fɔya nɛ Yesu Nazaretni akũ a. Oti kĩĩ nyɛ Baguma onukpɛ̃ ɔnyɛnɛ kĩ edeĩ kɔbɛ̃ yakɛna awãwã fɔtsa pii, ɛnyɛ fɔtsa ɔtsanɛ kpale kĩ Baguma mɔ bati flee akpa ye obu. ");
INSERT INTO bov_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lɛmɛ Yudafɔ basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ pi ye bɛkɔa ye bido nɛ Roma abãã awɛ, kĩ bɛkɔ ye kɔtɔ bɛkpa wuda, bɛbɔa ye nɛ asendua akũ. ");
INSERT INTO bov_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bɔna kɔnɛte nɛ ye akũ kĩ ye aanya oti a kĩ yaanyɛ Israel. Ade nviã nyɛ fuwi ɛlalɛ kĩ fukĩĩ flee ya nɛ foe kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Boe katsu a kĩ kitomɔ ye a kamɛ batsole badi fɔ̃ akũ nyɛnɛ boe, kitonɛkĩ ɔnɔnɛ tutuutu kĩĩ bɛnaa ye linikɛ ɔwɛ̃, ");
INSERT INTO bov_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lɛmɛ bɛtámɔ ɔnɔkpa a. Bimuniki bɛyabi boe kĩ Baguma ode fɔtɔ banyanɛ nyɛ be akũ bɛtsa be, bibi be kĩ Yesu dzi nkpã. ");
INSERT INTO bov_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Boe katsu a kamɛ banyole badi naa linikɛ a ɔwɛ̃ bɛnamɔ foe pɛpɛɛpɛ ndɛ ayekĩ batsole a lɛ a, lɛmɛ bɛtámɔ Yesu.” ");
INSERT INTO bov_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ade Yesu bi be kĩ, “Mitɛnɛ kadzimbi! Mi adzuni lɛlá sɔwa kĩ miatɛ Baguma onukpɛ̃ banyɛnɛ a fɔlɛtsa a flee mido! ");
INSERT INTO bov_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mitányi tɔ̃ kĩ kɛnɛ kĩ Kristo a ɛmɔ lubo kĩĩ bamɛ flee fɔmɔ yaaawo nɛ ye lɛgãkanya kukũkpalɛ a kamɛ?” ");
INSERT INTO bov_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ade ke Yesu kpalɛ fɔlɛtsa kamɛ ɛtsa be nɛ lɛtsa a kĩ Katsɛlɛ Kpalɛwa a tsɛlɛ nɛ ye akũ, kito Mose tuvoli akũ kɛyake nɛ Baguma onukpɛ̃ banyɛnɛ flee katsɛlɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kĩ bifuã akula a kĩ ye kamɛ banaa biyua a, Yesu kɛna ndɛ yatɛ̃ ɛnaa lɔtɔ. ");
INSERT INTO bov_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lɛmɛ biwũnya ye ade bibi ye kĩ, “Dzi nɛ boe sɛkɛ̃. Kade dɔ kiyua ade ɔtũ do kake awɛ a.” Foesũ ɛnase nɛ be sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kĩ bɛmɔ be bidzi kĩ banya a, ɛbɔɛ abodoo ɛnyɛ Baguma kɔlɛ, ɛsɛ̃ ɛkpa be. ");
INSERT INTO bov_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nɛ awã naa, be anɛ binya ade bɛmɔ́ ye biyi ɔsũ a, lɛmɛ ɛyɛla nɛ be anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ade ke bibi be akũ kĩ, “Fɔtákɛna ndɛ fi fudi lɛkatɛ̃ nɛ boe tɔwɔlɛ kamɛ, kĩ ɛkanyɛ Katsɛlɛ Kpalɛwa fɔlɛtsa a kamɛ katsa boe nɛ osi a?” ");
INSERT INTO bov_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ade biyidza bimuniki mɔatsɛ bɛnaa Yerusalem, bɛnamɔ fɔtɔ banyanɛ ewua-odi a mɔ bati bɛbã a kĩ bɛkpɔta a. ");
INSERT INTO bov_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bɛnabi be kĩ, “Nuwĩ boe Ɔlate yidza eto kanɔkpa ade ɛnyɛ ye akũ ɛtsa Simon a.” ");
INSERT INTO bov_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bati nviã a bi be lɛtsa a kĩ lɛya nɛ osi akũ a, mɔ ayekĩ bɛmɔ́ boe Ɔlate a biyi ɔsũ nɛ lɔkɔ a kĩ ɛyɛlɛ abodoo ɛkpa be a. ");
INSERT INTO bov_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kĩ bati nviã kĩĩ kabi be fɔlɛtsa kĩĩ a, deedimɔapɛ Yesu mɔawɛ nɛ ɛdza nɛ be kayite, ade ebi be kĩ, “Lukudɔ litomɔ mi.” ");
INSERT INTO bov_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Libe wo be paa ade bɛkakɔna kĩ ɔnɔkpa bɛmɔ. ");
INSERT INTO bov_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lɛmɛ Yesu bi be kĩ, “Nde sũ mibɔa obili lɔmɔ? Nde sũ miatɛ atsindze nɛ mi kamɛ? ");
INSERT INTO bov_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Midã yĩ awɛ mɔ yĩ fɔnɛta. Mita yĩ midã mimɔ kĩ nnɛ́ ɔnɔkpa manɛ, kitonɛkĩ hũhũ lɛlá sukɛna mɔ fɔtsɔ̃ ndɛ ayekĩ miamɔ kĩ ndeĩ a.” ");
INSERT INTO bov_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kĩ ɛlɛ foe a, ɛkɔa ye awɛ mɔ fɔnɛta ɛtsa be. ");
INSERT INTO bov_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kawɔlɛ de be paa, lɛmɛ fɔkɛna be wãwã, foesũ biti bɛtátɛ bido. Ade ke Yesu via be kĩ, “Mideĩ funitsã fudi nɛ awĩ?” ");
INSERT INTO bov_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bɛkpa ye kafɔabi tɔlɛwa kadi, ");
INSERT INTO bov_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ɛtɛ ke ɛba nɛ be anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ke liti a ebi be kĩ, “Ade fɔlɛtsa kĩĩ bamɛ mbi mi nɛ lɔkɔ a kĩ nna nɛ mi kamɛ a. Kɛnɛ kĩ lɛtsa nyɛ lɛtsa a kĩ bɛtsɛlɛ biyi nɛ Mose mbla, Baguma onukpɛ̃ banyɛnɛ tuvoli mɔ Tɔnɔ Ovoli a kamɛ fɔya nɛ foe kamɛ lɔmɔ.” ");
INSERT INTO bov_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ebinya be adzuni ayekĩ baanu Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa a kayɔ. ");
INSERT INTO bov_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ebi be kĩ, “Bɛtsɛlɛ biyi kĩ Kristo a aamɔ lubo, lɔkɔa eyidza eto kanɔkpa nɛ luwi lɛlalɛde a akũ. ");
INSERT INTO bov_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɛ ye dĩ akũ ni, bikĩ bitomɔ ye a aade lɛtsã nɛ ɔwɔlɛ kamɛ kadani mɔ tɔkpa kakɔakate akũ bɛkpa katinya kamɛ bati flee. Baayi lɛtsã kĩĩ kade kayɔ bitomɛna Yerusalem. ");
INSERT INTO bov_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mi nyɛ fukĩĩ bamɛ flee adansifɔ. ");
INSERT INTO bov_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yĩ mɔawɛ a maakɔa Hũhũ Kpalɛwa mma mi ndɛ ayekĩ Nda lɛ eyi a. Lɛmɛ midzi nɛ Yerusalem nɛ awĩ kɛnaawo lɔkɔ a kĩ kɔbɛ̃ a aato ode kɔyaatɛ mi kamɛ.” ");
INSERT INTO bov_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ade ɛkpã be bɛnɛ nɛ Yerusalem ɔmatɔ a kamɛ bɛnaa Betania, awã kĩ ɛdzɛla awɛ nɛ ode ehila be a. ");
INSERT INTO bov_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kĩ ɛkahila be a, ɛdzakũ ɛfɔnɛ be ade bɛbɔɛ ye bɛnamɛna ode a. ");
INSERT INTO bov_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ade ke bisum ye bimuniki bɛnaa Yerusalem nɛ kawɔlɛ kpale kamɛ a. ");
INSERT INTO bov_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bidzi nɛ Asɔli Kɔla a kamɛ daa, bɛkamu Baguma.");
INSERT INTO bov_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fɔmɔ baabɔa katinya ni, Baguma Kalɛ a deĩ kɔkɔɛ. Kalɛ a mɔ Baguma deĩ, ade Kalɛ a nyɛ Baguma a. ");
INSERT INTO bov_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kalɛ a mɔ Baguma deĩ anɛ kayɔkayi a fɔmɔ bɛbɔa katinya. ");
INSERT INTO bov_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Baguma bɔa fɔtsa flee ɛtsãmɛna ye akũ, ade lɛtsama lɛláa kĩ ɛnɛ ye liti ɛbɔa. ");
INSERT INTO bov_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kalɛ a kamɛ nkpã deĩ, ade nkpã kĩĩ lɛma batidziwa ɔhaĩ a. ");
INSERT INTO bov_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ɔhaĩ a avɔlɛ nɛ ɔtũ kamɛ, ade ɔtũ tápuli edina ye da a. ");
INSERT INTO bov_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Baguma do onyole odi kĩ bavɛ Yohanes. ");
INSERT INTO bov_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ɛya kĩ yayaadi adansiɛ nɛ ɔhaĩ a akũ ayekĩ bati flee aatsã ye akũ bɛtɛ bido. ");
INSERT INTO bov_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nnɛ́ Yohanes nyɛ ɔhaĩ a, mbom adansiɛ ɛyadi nɛ ɔhaĩ a akũ. ");
INSERT INTO bov_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ɔhaĩ wĩ a kĩ yatɛ̃ kakpa odi nyɛ odi a, aya nɛ katinya kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kalɛ a na nɛ katinya kamɛ, lɛmɛ titɔ kĩ Baguma bɔa katinya ɛtsãmɛna ye akũ malo ni, batidziwa támɔ ye biyi ɔsũ. ");
INSERT INTO bov_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɛya nɛ ye mɔawɛ bati sɛkɛ̃, lɛmɛ ye bati a tátɛ ye. ");
INSERT INTO bov_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lɛmɛ bati flee a kĩ bɛtɛ ye, ade bɛtɛ ye bido lɛmɛ a, ɛkpa be kɔbɛ̃ kĩ bɛdani Baguma babi. ");
INSERT INTO bov_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bɛtádani Baguma babi nɛ batidziwa kama onukpɛ̃, ĩye ndɛ ayekĩ otinyole ama babi aye, mbom Baguma mɔawɛ lɛwɛ kĩ yakɛna be ye babi. ");
INSERT INTO bov_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kalɛ a dani kɛkɛna otidziwa, edzi nɛ boe kamɛ, ade kɔnyakamɔ mɔ ɔnɔkɔali yi ye kamɛ a. Bɔmɔ́ ye kukũkpalɛ a, kukũkpalɛ a kĩ ɛtɛ ndɛ Ɔlɛga a Obi mɔapɛ a aye. ");
INSERT INTO bov_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes di adansiɛ nɛ ye akũ, ɛbɔa fɔwɔla ɛlɛ kĩ, “Ade oti kĩĩ akũ fɔlɛtsa mbi mi kĩ, ‘Oti odi aya nɛ yĩ liti, lɛmɛ ɛbɛ̃ yĩ kitonɛkĩ edzi nkpã kɔkɔɛ fɔmɔ bɛma yĩ.’ ” ");
INSERT INTO bov_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nɛ ye kɔnyakamɔ beblebee sũ ni, ehila boe flee ɛkpa boe nhila ete nɛ nhila akũ. ");
INSERT INTO bov_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mose akũ Baguma mbla a tsã ɛya, lɛmɛ ye kɔnyakamɔ mɔ ɔnɔkɔali a tsã Yesu Kristo akũ fɔya. ");
INSERT INTO bov_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Odima támɔ tɔ̃ Baguma. Ye Obi mɔapɛ a kĩ eketimɔ Baguma a, kĩ edeĩ nɛ Ɔlɛga sɛkɛ̃ a, ade ye lɛnyɛ ayekĩ Baguma la a ɛtsa boe a. ");
INSERT INTO bov_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yudafɔ banɔkɔɛ̃ nɛ Yerusalem do be basɔfɔ mɔ Levifɔ nɛ Yohanes sɛkɛ̃ kĩ bɛnaavia ye kĩ, “Nɔ nyɛ owei?” ");
INSERT INTO bov_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanes tásĩ be mbuayɛ kakpa, mbom ɛkpalɛ fɔlɛtsa kamɛ yededeede ɛlɛ kĩ, “Nnɛ́ yĩ nyɛ Kristo a.” ");
INSERT INTO bov_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ade bivia ye kĩ, “Kekɔ̃ nɔ nyɛ owei? Mbɔɛɛ nɔ nyɛ Baguma Onukpɛ̃ Ɔnyɛnɛ Eliya a?” Ɛkpa be mbuayɛ kĩ, “Oowo, nnɛ́ ye manɛ.” Bibuki bivia ye kĩ, “Nɔ nyɛ Baguma onukpɛ̃ ɔnyɛnɛ a kĩ bɛlɛ biyi kĩ yaaya a?” Ɛkpa be mbuayɛ kĩ, “Oowo.” ");
INSERT INTO bov_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Adeke bibi ye kĩ, “Kekɔ̃ bi boe oti a kĩ anɛ, kitonɛkĩ kɛnɛ kĩ bɔkɔa mbuayɛ bɔma bikĩ bido boe fɔtɔ a. Owei koũ anɛ?” ");
INSERT INTO bov_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes kpa be mbuayɛ ndɛ ayekĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya tsɛlɛ eyi a kĩ, “Yĩ nyɛ oti a kĩ ɛtsɛ̃ nɛ kɔsa kamɛ yabɔa fɔwɔla a odo kĩ bɛkɛna osi kpĩĩ bɛkpa Ɔlate a.” ");
INSERT INTO bov_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Batɔ a kĩ bido bito Farisifɔ sɛkɛ̃ a, ");
INSERT INTO bov_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","via Yohanes kĩ, “Ntɛ nnɛ́ nɔ nyɛ Kristo a, ĩye Eliya, ĩye Baguma onukpɛ̃ ɔnyɛnɛ a ni, nde sũ akɛna mui kawɔla amaniɛ?” ");
INSERT INTO bov_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ade Yohanes kpa be mbuayɛ kĩ, “Yĩ kɔ̃ ni, mawɔla bati mui, lɛmɛ odi kĩ minyína ye dzɛ̃ nɛ mi kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ade ye tomɔ yĩ nɛ liti yaya a, lɛmɛ ntáfɛta kĩ mawũnya ye mpabua tɔwɛ̃ malo.” ");
INSERT INTO bov_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fukĩĩ flee ya nɛ foe kamɛ nɛ Betania ɔmatɔ kamɛ, nɛ Yordan ɔwɔ liti, awã kĩ Yohanes kawɔla bati mui a. ");
INSERT INTO bov_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kĩ kade nyina a, Yohanes mɔ́ Yesu kĩ yaya nɛ ye sɛkɛ̃, ade ɛlɛ kĩ, “Midã Baguma Kavelibi a kĩ yaakɔa katinya kamɛ bati tɔkpa ɛnamɛna a! ");
INSERT INTO bov_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ade oti kĩĩ akũ fɔlɛtsa mbi mi kĩ, ‘Oti odi aya nɛ yĩ liti, kĩ ɛbɛ̃ yĩ, kitonɛkĩ edzi nkpã kɔkɔɛ fɔmɔ bɛma yĩ.’ ");
INSERT INTO bov_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yĩ mɔawɛ a ntányi oti a kĩ ye yanɛ, lɛmɛ ĩyaawɔla bati mui, ayekĩ maanyɛ ye ntsa Israel kade a.” ");
INSERT INTO bov_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ade Yohanes lɛ nɛ Yesu akũ kĩ, “Mmɔ́ Hũhũ Kpalɛwa a kĩ ɛka eto ode ndɛ mblɔduma aye ɛyadzi nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nɛ kayɔkayi a, ntányi ye, lɛmɛ Baguma kĩ edo yĩ kĩ nwɔla bati mui a bi yĩ kĩ, ‘Oti a kĩ aamɔ kĩ yĩ Hũhũ a ka ɛyadzi nɛ ye akũ a ni, ade ye aakɔa Hũhũ Kpalɛwa ɛwɔla bati mui a.’ ");
INSERT INTO bov_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mmɔ́ foe lɔmɔ, ndi adansiɛ kĩ ade oti kĩĩ nyɛ Baguma Obi a.” ");
INSERT INTO bov_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Luwi lɛyade a, kĩ Yohanes mɔ ye fɔtsa bakɔlɛnɛ nviã dzɛ̃ nɛ awã a, ");
INSERT INTO bov_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bɛmɔ́ Yesu kĩ yatɛ̃ a, Yohanes lɛ kĩ, “Midã Baguma Kavelibi a!” ");
INSERT INTO bov_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Fɔtsa bakɔlɛnɛ nviã a nu fɔlɛtsa a kĩ ɛlɛ a, foesũ bitomɔ Yesu bɛnaa. ");
INSERT INTO bov_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu dani, ɛmɔ́ be kĩ bitomɔ ye, ade evia be kĩ, “Litsa miawɛ?” Bɛkpa ye mbuayɛ kĩ, “Rabi,” foe kayɔ nyɛ Fɔtsa Ɔtsanɛ, “ndia odzi?” ");
INSERT INTO bov_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu bi be kĩ, “Miyaadã.” Lɔkɔ a aana ndɛ olobe tɔdɔũ ɛna kamɛ, foesũ bitomɔ ye bɛnamɔ awã kĩ edzi a, ade bidzi nɛ ye sɛkɛ̃ olobe a flee a. ");
INSERT INTO bov_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Fɔtsa bakɔlɛnɛ nviã a kamɛ ɔmɔa nyɛ Andrea, Simon Petro ɔwaɛ̃nyole. ");
INSERT INTO bov_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lɛtsa a kĩ Andrea nya lɔtɔ ɛkɛna nyɛ kĩ ɛnawɛ ɔwaɛ̃ Petro ebi ye kĩ, “Bɔmɔ́ Mesia a!” De kayɔ nyɛ Kristo. ");
INSERT INTO bov_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ke liti a, Andrea kpã Simon ɛnamɛna Yesu sɛkɛ̃. Yesu dã Simon kɛnanaana ade ebi ye kĩ, “Nɔ dĩ nyɛ Simon kĩ ɛnyɛ Yohanes obi a, lɛmɛ kito finyaa baavɛ nɔ Kefas,” ĩye Petro. Buĩ nviã a kayɔ nyɛ de. ");
INSERT INTO bov_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kĩ kade nyina a, Yesu wɛ kĩ yadzakũ ɛnaa Galilea tite akũ, ade ɛmɔ Filipo ebi ye kĩ, “Yaatomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo lɛmɛ to Betsaida, ɔmatɔ a kĩ Andrea mɔ Simon dzi a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo mɔ Nataniel ade ebi ye kĩ, “Bɔmɔ́ oti a kĩ Mose mɔ Baguma onukpɛ̃ banyɛnɛ tsɛlɛ fɔlɛtsa nɛ ye akũ nɛ Katsɛlɛ Kpalɛwa kamɛ a. Ade ye nyɛ Yosef obi Yesu, kĩ eto Nazaret a!” ");
INSERT INTO bov_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel via kĩ, “Fɔtsa wĩ fudi aapuli fɔnɛ futo Nazaret lɛmɛ kamɛ?” Filipo kpa ye mbuayɛ kĩ, “Yaadã!” ");
INSERT INTO bov_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kĩ Yesu mɔ́ Nataniel yaya nɛ ye sɛkɛ̃ a, ɛlɛ nɛ ye akũ kĩ, “Ade Israelni kpanunuunu nɛ awĩ a, ɛnyɛ́ anɛ kamɛ kɛkɛ fɔtsa ɔkɛnanɛ!” ");
INSERT INTO bov_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel via Yesu kĩ, “Nde ɔkɛna onyi yĩ?” Yesu kpa ye mbuayɛ kĩ, “Mmɔ́ nɔ kɔkɔɛ nɛ kɔya kutse a kayɔ fɔmɔ Filipo yavɛ nɔ.” ");
INSERT INTO bov_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ade Nataniel lɛ kĩ, “Fɔtsa Ɔtsanɛ, nɔ nyɛ Baguma Obi a. Nɔ nyɛ Israel Lɛgã a!” ");
INSERT INTO bov_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu bi ye kĩ, “Ayekĩ mbi nɔ kĩ mmɔ́ nɔ nɛ kɔya kutse a kayɔ sũ mɔ ɔtɛ odo a? Aamɔ fɔtsa baũ kĩ fɔbɛ̃ fukĩĩ!” ");
INSERT INTO bov_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ade ke ebi be kĩ, “Mabi mi flee nɛ ɔnɔkɔali kamɛ kĩ míamɔ ode kĩ ebinya, ade míamɔ kĩ ode fɔtɔ banyanɛ aakade bɛkaka nɛ yĩ, Otidziwa Obi a, akũ.” ");
INSERT INTO bov_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nɛ luwi lɛlalɛde akũ a, bipi obolitsɔ̃ nɛ Kana ɔmatɔ kĩ edeĩ nɛ Galilea tite akũ. Yesu ɔma na nɛ awã, ");
INSERT INTO bov_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ade bɛvɛ Yesu mɔ ye fɔtsa bakɔlɛnɛ a lɛmɛ bɛya nɛ obolitsɔ̃ kapikɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kĩ waĩ woli a, Yesu ɔma fuã Yesu ebi ye kĩ, “Be waĩ a woli.” ");
INSERT INTO bov_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu bi ye kĩ, “Otsole, nnɛ́ nɔ aabi yĩ lɛtsa a kĩ nkɛna. Yĩ lɔkɔ táwo tɔ̃ ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesu ɔma nabi basumunɛ a kĩ, “Lɛtsa nyɛ lɛtsa a kĩ yaabi mi ni, mikɛna.” ");
INSERT INTO bov_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayekĩ fɔnyɛ Yudafɔ amaniɛ kĩ bavɔlɛ akũ fɔmɔ bawo nɛ tɔtɔ kamɛ sũ ni, bake boe tɔpɔɔlɔ evũ nɛ tɔtɔ a kamɛ. Mui fugumi tsɛtsɛɛ ɛna ĩye foe elo awo nɛ lɔmɔa kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu bi basumunɛ a kĩ, “Minu mui miyula tɔpɔɔlɔ a.” Foesũ binu mui biyula foe tsɔnɔnɔɔnɔ. ");
INSERT INTO bov_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ade Yesu bi be kĩ, “Minu mui a badi mima oti a kĩ yadãmɛna funitsã akũ a.” Ade binu badi bɛma ye a. ");
INSERT INTO bov_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Funitsã akũ ɔdãmɛnanɛ a tá mui a kĩ bɛdani bavɛ a onukpɛ̃ ɛdã. Ɛtányi awã kĩ bitomɛna be, lɛmɛ basumunɛ a kɔ̃ nyina. Foesũ ɛvɛ obolitsɔ̃ ɔnyɔ a, ");
INSERT INTO bov_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","evia ye kĩ, “Odi nyɛ odi akpa bati a bavɛ vɔɛ̃ kanyamɛna lɔtɔ, lɔkɔa ntɛ bɛmɔa be biwĩ a, yabɔɛ bakɔɛ a kayamɛna. Nde fɔya mɔ nɔ kɔ̃ ɔkɔa bavɛ vɔɛ̃ a oke kɛyawo lɔkɔ kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu kɛna ye awãwã fɔtsa fɔtɔnyade kĩĩ nɛ Kana nɛ Galilea tite akũ, ɛkɔa ɛnyɛ ye kukũkpalɛ ɛtsa, ade ye fɔtsa bakɔlɛnɛ a tɛ ye bido a. ");
INSERT INTO bov_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ke liti a, Yesu mɔ ɔma, mɔ bawaɛ̃nyole mɔ ye fɔtsa bakɔlɛnɛ a dzakũ bɛnaa Kapernaum, bɛnadzi nɛ awã fuwi sukuloo. ");
INSERT INTO bov_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kĩ Yudafɔ Wuda Katɛ̃ luwi kanya a wo ɔtɔ liyua a, Yesu naa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nɛ Asɔli Kɔla kamɛ a, ɛmɔ kĩ bati dzi banɔ banantsue, baveli mɔ mblɔduma. Ɛmɔ́ lɛmɛ kĩ sika babɛ̃nɛ dzi nɛ be tupunu akũ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Foesũ ɛnɔ ɔwɛ̃ ɛkɛna mple ɛkɔa ɛblɔmɛna bayaɛ a flee, banantsue mɔ baveli a nɛ Asɔli Kɔla a kamɛ. Edu be tupunu lɛmɛ ewula, ɛpansam sika babɛ̃nɛ a sika ɛsã. ");
INSERT INTO bov_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ade ebi bikĩ banɔ mblɔduma a kĩ, “Mifila fɔtsa kĩĩ minɛmɛna nɛ awĩ, mitakɔa Nda kɔla mikɛna kɔyaatɔ.” ");
INSERT INTO bov_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ade ke ye fɔtsa bakɔlɛnɛ a te anɛ kĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “O Baguma, nɔ kɔla akũ mbɔdibɔ atɛ̃ nɛ yĩ kamɛ ndɛ fi aye.” ");
INSERT INTO bov_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yudafɔ banɔkɔɛ̃ yavia Yesu kĩ, “Litsa nsɛntsɛlɛni aapuli ɔkɛna ɔtsa boe kĩ odeĩ osi kĩ akɛna fukĩĩ?” ");
INSERT INTO bov_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kpa be mbuayɛ kĩ, “Miveli Baguma Kɔla kĩĩ, ade nɛ fuwi ɛlalɛ liti ni, maabuki nke koe.” ");
INSERT INTO bov_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yudafɔ a bi ye kĩ, “Bɛkɔa futeli tɛna-avũ bike Asɔli Kɔla kĩĩ, ke mɔ alɛ kĩ aakɔa fuwi ɛlalɛ obuki oke koe a?” ");
INSERT INTO bov_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lɛmɛ asɔli kɔla a kĩ Yesu lamɛna kalɛ a nyɛ ye sukɛna. ");
INSERT INTO bov_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Foesũ kĩ Baguma dzɛla ye etomɛna kanɔkpa liti a, ye fɔtsa bakɔlɛnɛ a te anɛ kĩ ɛlɛ fukĩĩ eyi, ade bɛtɛ Katsɛlɛ Kpalɛwa fɔlɛtsa mɔ lɛtsa a kĩ Yesu lɛ a bido a. ");
INSERT INTO bov_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kĩ Yesu na nɛ Yerusalem nɛ Wuda Katɛ̃ luwi kanya kamɛ a, bati pii tɛ ye bido nɛ awãwã fɔtsa a kĩ bɛmɔ́ kĩ ɛkɛna a sũ. ");
INSERT INTO bov_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lɛmɛ Yesu tákɔa ye akũ ɛkpa be, kitonɛkĩ enyina bati flee. ");
INSERT INTO bov_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Foesũ fɔtásĩ kĩ odima abi ye kadi nɛ bati akũ, kitonɛkĩ ye mɔawɛ a enyina lɛtsa a kĩ lideĩ nɛ be tɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nɛ lɔkɔ a naa kamɛ a, Yudafɔ ɔnɔkɔɛ̃ mɔa na kĩ ɛnyɛ Farisini, kĩ bavɛ Nikodemo. ");
INSERT INTO bov_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Luwi a lɛnyɛ, ɛya nɛ Yesu sɛkɛ̃ ɛyabi ye kĩ, “Fɔtsa Ɔtsanɛ, bunyina kĩ Baguma sɛkɛ̃ oto ɔya, kitonɛkĩ odima lɛláapuli ɛkɛna nsɛntsɛlɛni a kĩ akɛna a, ntɛ Baguma lítomɔ ye.” ");
INSERT INTO bov_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ade Yesu bi ye kĩ, “Ɔnɔkɔali mabi nɔ kĩ ntɛ bɛtábuki bɛlɔla oti kama ni, ɛláapuli ɛmɔ Baguma lɛgãkanya a.” ");
INSERT INTO bov_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo via ye kĩ, “Nde baapuli bibuki bɛma oti kĩ ebo anɛ? Ɛláapuli ewo nɛ ɔma sɛmɛ kamɛ bɛlɔla ye kama lɛyade.” ");
INSERT INTO bov_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kpa ye mbuayɛ kĩ, “Ɔnɔkɔali a mabi nɔ kĩ, ntɛ bɛtáma oti bitomɛna mui mɔ Baguma Hũhũ kamɛ ni, ɛláapuli ewo nɛ ye lɛgãkanyakɔ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sukɛna kamɛ bama sukɛna oti katomɛna, lɛmɛ Baguma Hũhũ kamɛ bama hũhũ ode. ");
INSERT INTO bov_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Foesũ fɔtakɛna nɔ wãwã kĩ nlɛ kĩ kɛnɛ kĩ bɛlɔla mi flee kama. ");
INSERT INTO bov_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ɔwɛ abɔa kanaa awã kĩ yawɛ, anu ye nkã, lɛmɛ onyína awã kĩ eto ĩye awã kĩ yanaa. Ade aye fɔla fɔkpa odi nyɛ odi kĩ bɛma ye nɛ Hũhũ a kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ade Nikodemo via ye kĩ, “Nde fukĩĩ aapuli fɔya nɛ foe kamɛ?” ");
INSERT INTO bov_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kpa ye mbuayɛ kĩ, “Fɔtsa Ɔtsanɛnɔkɔɛ̃ anɛ nɛ Israel, mɔ onyína fukĩĩ a? ");
INSERT INTO bov_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ bɔalɛ kɔdzɛla nɛ lɛtsa a kĩ bunyina a akũ, ade bɔadi adansiɛ nɛ lɛtsa a kĩ bɔmɔ́ akũ a, lɛmɛ mi kamɛ odima láwɛ kĩ yatɛ boe fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ntɛ mbi nɔ tite akũ fɔlɛtsa mɔ́ ɔtátɛ foe odo a, lɔkɔa ntɛ mbi nɔ ode fɔlɛtsa a ni, aapuli ɔtɛ foe odo? ");
INSERT INTO bov_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ade odima táde tɔ̃ ɛnaa ode, mbɔɛntɛ yĩ, Otidziwa Obi a, kĩ nto ode ĩya a odi. ");
INSERT INTO bov_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ndɛ ayekĩ Mose dɛla kɔɛ kĩ bɛkɔa kɔɔble bɛkɛna a nɛ otse akũ nɛ kɔsa kamɛ a, ade ayea kɛnɛ kĩ baadɛla yĩ, Otidziwa Obi a, lɛmɛ nɛ asendua akũ a, ");
INSERT INTO bov_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ayekĩ odi nyɛ odi kĩ ɛtɛ yĩ edo aana nkpã kĩ ɛla kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kitonɛkĩ Baguma ti ɛwɛ katinya kalɛ paa kĩ ɛkɔa ye Obi mɔapɛ a ɛkpa kĩ odi nyɛ odi kĩ ɛtɛ ye edo lɛláaku ɛwɔ, mbom yaana nkpã kĩ ɛla kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kitonɛkĩ Baguma tádo ye Obi kĩ ɛyaakɔ katinya kamɛ bati kɔtɔ, mbom kĩ fɔtsã ye akũ bati bɛna katɛ. ");
INSERT INTO bov_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Odi nyɛ odi kĩ ɛtɛ Obi a edo ni, bɛtákɔ ye kɔtɔ, lɛmɛ odi nyɛ odi kĩ ɛtátɛ edo ni, bɛkɔ ye kɔtɔ kɔkɔɛ, kitonɛkĩ ɛtátɛ Baguma Obi mɔapɛ a edo. ");
INSERT INTO bov_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ayekĩ badzɛmɔ katinya kakɔ bati kɔtɔ a nyɛ kĩ ɔhaĩ a ya nɛ katinya kamɛ lɛmɛ bati wɛ ɔtũ kalɛ bɛba ɔhaĩ a, kitonɛkĩ be fɔtsakɛlawa nyɛ tɔkpa. ");
INSERT INTO bov_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Odi nyɛ odi kĩ yakɛna tɔkpa akesĩ ɔhaĩ a, ade ɛláaya nɛ ɔhaĩ a sɛkɛ̃ a, kitonɛkĩ yaáwɛ kĩ yanyɛ ye tɔkpa kanya. ");
INSERT INTO bov_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lɛmɛ odi nyɛ odi kĩ edzi nɛ ɔnɔkɔali kamɛ ni, yaya nɛ ɔhaĩ a kamɛ ayekĩ ɔhaĩ a aafɔ̃ bɛmɔ́ kĩ yakɛna fɔtsa nɛ Baguma kawɛ akũ.” ");
INSERT INTO bov_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Fukĩĩ liti a, Yesu mɔ ye fɔtsa bakɔlɛnɛ a naa Yudea amantam a kamɛ a. Edzi nɛ awã fuwi sukuloo ɛwɔla bati mui. ");
INSERT INTO bov_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohanes lɛmɛ kawɔla bati mui nɛ Ainon kĩ efuã Salim, kitonɛkĩ mui bɔ nɛ awã. Bati kaya nɛ ye sɛkɛ̃ kĩ ɛwɔla be mui. ");
INSERT INTO bov_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nɛ lɔkɔ a na kamɛ a, bɛtápi tɔ̃ Yohanes bido nɛ kɔla kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Luwi a, fɔlɛtsa kavɛlɛ ya nɛ Yohanes fɔtsa bakɔlɛnɛ mɔ Yudani odi kayite nɛ Yudafɔ akũ mui kawɔla amaniɛ akũ. ");
INSERT INTO bov_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Foesũ bɛya nɛ Yohanes sɛkɛ̃ bɛyabi ye kĩ, “Fɔtsa Ɔtsanɛ, ate anɛ nɛ onyole a kĩ ɛna nɛ nɔ sɛkɛ̃ nɛ Yordan ɔwɔ liti, kĩ odi adansiɛ nɛ ye akũ a? Ɛlamɛna bati mui kawɔla ade bati flee lamɛna ye sɛkɛ̃ kanaa a!” ");
INSERT INTO bov_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes kpa mbuayɛ kĩ, “Odima lɛláapuli ɛna litsedi mbɔɛntɛ Baguma lɛkpa ye de. ");
INSERT INTO bov_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mi mɔawɛ a nyɛ yĩ adansifɔ kĩ nlɛ kĩ, ‘Nnɛ́ yĩ nyɛ Kristo a, mbom Baguma do yĩ kĩ ĩnya ye lɔtɔ.’ ");
INSERT INTO bov_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Obolitsɔ̃ ɔnyɔ nyɛ oti a kĩ ɛla obolitsɔ̃ a, lɛmɛ obolitsɔ̃ ɔnyɔ ɔkɔba kĩ ɛdzɛ̃ nɛ ɔɔwɛ̃ yatse a kɔ̃, kawɔlɛ ade ye pii ntɛ enu obolitsɔ̃ ɔnyɔ a odo. Ade ayea kĩ nnu ye odo a, yĩ kawɔlɛkamɔ akpɔla a. ");
INSERT INTO bov_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kɛnɛ kĩ ye dĩ lide nɛ ode lɔkɔa yĩ lide lɛka nɛ kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Oti a kĩ eto ode ɛya a bɛ̃ be flee. Oti a kĩ eto tite akũ a nyɛ tite akũ oti, ade tite akũ fɔlɛtsa yalɛ a, lɛmɛ oti a kĩ eto ode a bɛ̃ be flee. ");
INSERT INTO bov_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yalɛ lɛtsa a kĩ ɛmɔ́, mɔ lɛtsa a kĩ enu, lɛmɛ odima látɛ ye adansiɛ kadi a. ");
INSERT INTO bov_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lɛmɛ odi nyɛ odi kĩ ɛtɛ ye fɔlɛtsa a, asipi kĩ Baguma adi ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Oti a kĩ Baguma do a alɛ Baguma fɔlɛtsa, kitonɛkĩ Baguma kɔa Hũhũ eyula ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ɔlɛga a awɛ ye Obi kalɛ, ade foesũ ɛkɔa fɔtsa flee edo nɛ ye awɛ a. ");
INSERT INTO bov_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Odi nyɛ odi kĩ ɛtɛ Obi a edo ni, edeĩ nkpã kĩ ɛlá kawũna a, odi nyɛ odi kĩ yaátse Obi a ni, ɛláana nkpã, mbom Baguma kalɔkpa aana nɛ ye akũ.” ");
INSERT INTO bov_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisifɔ a nu kĩ Yesu kawɔla bati mui, kĩ ye fɔtsa bakɔlɛnɛ a kapɔ kaba Yohanes bade. ");
INSERT INTO bov_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lɛmɛ nɛ ɔnɔkɔali kamɛ ni, Yesu mɔawɛ táwɔla odima mui, mbom ye fɔtsa bakɔlɛnɛ a odi lɛwɔla bati mui. ");
INSERT INTO bov_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Foesũ kĩ Yesu nu fɔlɛtsa kĩĩ a, ɛdzakũ nɛ Yudea emuniki ɛnaa Galilea tite akũ. ");
INSERT INTO bov_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kɛnɛ kĩ ɛtsã Samaria tite kamɛ ɛnaa awã. ");
INSERT INTO bov_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu yawo Samaria ɔmatɔ odi kĩ bavɛ Sikar. Ɔmatɔ a fuã mɔ tite a kĩ be ɔwanyɔ Yakob kɔa ɛkpa ye obi Yosef. ");
INSERT INTO bov_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakob lɔwɔkɛ deĩ nɛ awã. Yesu yawo awã ndɛ suwa tɔdɔũ ewua-nviã kamɛ, ade kĩ osi katsã piã ye sũ ni, ɛkɛna akũ edzi nɛ lɔwɔkɛ a ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Owi tábuna mɔ Samaria otsole odi ya kĩ yaanu mui. Yesu bi ye kĩ, “Kpa yĩ mui badi mmɔa.” ");
INSERT INTO bov_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nɛ lɔkɔ a na kamɛ ni, ye fɔtsa bakɔlɛnɛ a naa ɔmatɔ kamɛ bɛnaaya funitsã. ");
INSERT INTO bov_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Otsole a bi Yesu kĩ, “Nde fɔya mɔ nɔ Yudani avia yĩ Samaria otsole kĩ nkpa nɔ mui kamɔa?” Ɛlɛ lɔmɔ kitonɛkĩ Yudafɔ mɔ Samariafɔ lákã. ");
INSERT INTO bov_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kpa ye mbuayɛ kĩ, “Ntɛ kanyina onyina lɛtsa a kĩ Baguma akpa, mɔ oti a kĩ ye lamɛna nɔ mui mɔawa kavia ni, kufɛ nɔ aavia ye lɔkɔa ɛkpa nɔ mui kĩ bakpa nkpã a.” ");
INSERT INTO bov_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Otsole a bi ye kĩ, “Ɔnɔkɔɛ̃, ɔnɛ́ɛ bokiti kĩ bakɔa kanu mui, ade lɔwɔkɛ a lɛmɛ dzũ a. Ndia aatomɛna mui a kĩ bakpa nkpã a? ");
INSERT INTO bov_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Boe ɔwanyɔ Yakob lɛnyɛ lɔwɔkɛ kĩĩ ɛkpa boe, ade ye mɔawɛ, ye babi mɔ ye bayaɛ flee mɔa mui bitomɛna de kamɛ a. Mbɔɛɛ katsa atsa kĩ ɔbɛ̃ Yakob?” ");
INSERT INTO bov_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ade Yesu kpa ye mbuayɛ kĩ, “Odi nyɛ odi kĩ ɛmɔa mui kĩĩ ni, ɔmɔado aabuki ɛkɔ ye, ");
INSERT INTO bov_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lɛmɛ odi nyɛ odi kĩ yamɔa mui a kĩ maakpa ye a ni, ɔmɔado lɛláabuki ɛkɔ ye da. Kitonɛkĩ mui a kĩ maakpa oti a aadani mui katokɔ̃ kĩ nkpã mui deĩ a nɛ ye kamɛ, bɛkpa ye nkpã kĩ ɛla kawũna a.” ");
INSERT INTO bov_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Otsole a bi Yesu kĩ, “Ɔnɔkɔɛ̃, kpa yĩ mui a na badi ayekĩ ɔmɔado lɛláabuki ɛkɔ yĩ da, ĩye mbuki ĩya nɛ awĩ kĩ maanu mui.” ");
INSERT INTO bov_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ade Yesu bi ye kĩ, “Naakpã nɔ ɔnyɔ miya.” ");
INSERT INTO bov_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Otsole a bi ye kĩ, “Nlá ɔnyɔ.” Yesu bi ye kĩ, “Ɔlɛ ɔnɔkɔali kĩ ɔlá ɔnyɔ. ");
INSERT INTO bov_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nɛ ɔnɔkɔali kamɛ ni, odzimɔ banyole elo tɔ̃, ade onyole a kĩ mimɔ ye midzi finyaakĩĩ malo liti ɛnyɛ́ nɔ ɔnyɔ a.” ");
INSERT INTO bov_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ade otsole a bi Yesu kĩ, “Ɔnɔkɔɛ̃, mmɔ́ kĩ Baguma onukpɛ̃ ɔnyɛnɛ anɛ. ");
INSERT INTO bov_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Boe Samariafɔ bawanyɔ sum Baguma nɛ ɔtɔ kĩĩ akũ, lɛmɛ mi Yudafɔ mibo Yerusalem nyɛ awã kĩ kɛnɛ kĩ bati bisum Baguma.” ");
INSERT INTO bov_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu bi ye kĩ, “Boe ɔma, tɛ yĩ kado kĩ lɔkɔ aaya kĩ bati lɛláabuki bisum Ɔlɛga a nɛ ɔtɔ kĩĩ akũ ĩye nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mi Samariafɔ miti minyína oti a kĩ ye miasum. Lɛmɛ boe Yudafɔ kɔ̃ bunyina oti a kĩ bɔasum, kitonɛkĩ Yudafɔ akũ nkpã katɛ a tsã kɛya. ");
INSERT INTO bov_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lɛmɛ lɔkɔ aya, ade lɛya kɔkɔɛ malo kĩ bati a kĩ basum Baguma nɛ osi wĩ akũ a, aasum Ɔlɛga a nɛ Baguma Hũhũ mɔ ɔnɔkɔali kamɛ. Ade bati a kĩ basum ye lɔmɔ a Baguma awɛ a. ");
INSERT INTO bov_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Baguma ni, Hũhũ yanɛ, foesũ kɛnɛ kĩ bati a kĩ basum ye a, bisum ye nɛ Hũhũ mɔ ɔnɔkɔali kamɛ.” ");
INSERT INTO bov_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ade otsole a bi ye kĩ, “Ĩnyina kĩ Mesia kĩ bavɛ Kristo a aaya, ade ntɛ ɛya ni, yaabi boe lɛtsa nyɛ lɛtsa.” ");
INSERT INTO bov_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu bi ye kĩ, “Yĩ nyɛ ye, yĩ a kĩ nlamɛna kɔdzɛla kalɛ mɔ nɔ a.” ");
INSERT INTO bov_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lɔkɔ a na kamɛ mɔ Yesu fɔtsa bakɔlɛnɛ a muniki bɛya. Fɔkɛna be wãwã paa kĩ bɛmɔ́ kĩ ye mɔ otsole bɛlamɛna kɔdzɛla kalɛ. Lɛmɛ be kamɛ odima távia otsole a kĩ, “Litsa awɛ?” ĩye bivia Yesu kĩ, “Nde sũ mimɔ ye mialɔmɛna?” ");
INSERT INTO bov_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ade otsole a fɔnɛ ye kugumi awɛ eyi nɛ awã, ɛnaa ɔmatɔ kamɛ ɛnabi bati kĩ, ");
INSERT INTO bov_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Miyaadã onyole odi kĩ ebi yĩ lɛtsa nyɛ lɛtsa kĩ nkɛna tɔ̃. Mbɔɛɛ ye nyɛ Kristo a?” ");
INSERT INTO bov_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Foesũ bati nɛ́ nɛ ɔmatɔ a kamɛ bɛnaa Yesu sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nɛ lɔkɔ a kamɛ a, Yesu fɔtsa bakɔlɛnɛ a kake ye aduli kĩ, “Fɔtsa Ɔtsanɛ, yaanya litsedi.” ");
INSERT INTO bov_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lɛmɛ Yesu bi be kĩ, “Ndeĩ funitsã kĩ maanya, kĩ minyína foe akũ lɛtsama.” ");
INSERT INTO bov_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Foesũ ye fɔtsa bakɔlɛnɛ a kavia be akũ kĩ, “Mbɔɛɛ odi ma ye funitsã?” ");
INSERT INTO bov_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu bi be kĩ, “Yĩ funitsã nyɛ kĩ makɛna nɛ oti a kĩ edo yĩ a kawɛ akũ, lɔkɔa nwũna ye adzuma a kĩ ɛkpa yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nnɛ́ mi alɛ kĩ kite tidetɔ ɛna sɔũ kĩ funitsã kakpɔta lɔkɔ awo ɔtɔ? Lɛmɛ mabi mi kĩ miko anɛ midã fɔba a! Funitsã a bo kĩ bakpɔta. ");
INSERT INTO bov_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oti a kĩ yakpɔta funitsã a atɛ kɔtɔkase, ade ɔkpɔtanɛ akpɔta foe kakpa nkpã kĩ ɛlá kawũna a. Foesũ funitsã odunɛ a mɔ ɔkpɔtanɛ a flee aamɔ kawɔlɛ bɛkpɔta. ");
INSERT INTO bov_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Foesũ kalɛ a kĩ balɛ kĩ, ‘Oti mɔa adu fɔtsa, oti bɛbã akpɔta foe’ a nyɛ ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ndo mi kĩ minaakpɔta funitsã nɛ fɔba a kĩ mitákɛna adzuma nɛ foe kamɛ a. Bati bɛbã lɛkɛna adzuma nɛ awã, lɛmɛ mi mina nfasɔ mitomɛna be adzuma kakɛna kamɛ.” ");
INSERT INTO bov_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariafɔ pii kĩ bito ɔmatɔ a kamɛ a tɛ Yesu bido nɛ otsole a adansiɛ a kĩ edi kĩ, “Ebi yĩ lɛtsa nyɛ lɛtsa a kĩ nkɛna tɔ̃ nɛ yĩ nkpã kamɛ,” a sũ. ");
INSERT INTO bov_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Foesũ kĩ bɛyamɔ Yesu a, bike ye aduli kĩ edzi nɛ be sɛkɛ̃, ade Yesu dzi nɛ awã fuwi nviã fudi a. ");
INSERT INTO bov_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bati bɛbã pii lɛmɛ tɛ Yesu bido nɛ ye mɔawɛ fɔlɛtsa a kĩ ɛlɛ a sũ. ");
INSERT INTO bov_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ade bibi otsole a kĩ, “Finyaa kɔ̃, nnɛ́ nɔ fɔlɛtsa a sũ bɔtɛ budo, kitonɛkĩ boe mɔawɛ a bunu fɔlɛtsa a kĩ ɛlɛ a, ade bunyi kĩ nɛ ɔnɔkɔali kamɛ ni, ye nyɛ katinya kamɛ Ɔtɛnɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nɛ fuwi nviã a liti a, Yesu dzakũ nɛ awã ɛnaa Galilea tite akũ. ");
INSERT INTO bov_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ye mɔawɛ a ɛlɛ kĩ, “Baguma onukpɛ̃ ɔnyɛnɛ lɛ́la obu nɛ ye mɔawɛ kade bati kamɛ.” ");
INSERT INTO bov_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lɛmɛ kĩ ewo Galilea tite akũ a, bati a tɛ ye katɛ wĩ, kitonɛkĩ bɛnaa Yerusalem nɛ Wuda Katɛ̃ Luwi kanya a kamɛ, ade bɛmɔ́ lɛtsa nyɛ lɛtsa a kĩ ɛkɛna a nɛ luwi kanya a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ke liti a, Yesu muniki ɛnaa Kana nɛ Galilea tite akũ, awã kĩ ɛdani mui bɛkɛna bavɛ a. Abãã ɔnɔkɔɛ̃ odi deĩ nɛ awã, ye obinyole asɔ nɛ Kapernaum. ");
INSERT INTO bov_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kĩ enu kĩ Yesu to Yudea ɛya nɛ Galilea a, ɛnaa ye sɛkɛ̃ ɛnake ye aduli kĩ ɛyatsa ye obi kĩ edeĩ nɛ wuda mɔ nkpã kayite a ɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu bi ye kĩ, “Ntɛ mitámɔ awãwã mɔ nsɛntsɛlɛni fɔtsa ni, miátɛ kado.” ");
INSERT INTO bov_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɔnɔkɔɛ̃ a ke ye aduli kĩ, “Boe Ɔlate, ntɛ ɔtáya mɔatsɛ ni, yĩ obi aaku.” ");
INSERT INTO bov_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ade Yesu bi ye kĩ, “Naa, nɔ obi aana nkpã.” Ɔnɔkɔɛ̃ a tɛ Yesu fɔlɛtsa a edo ade epi ɔtɔsi a. ");
INSERT INTO bov_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kĩ yanaa a, ye basumunɛ yatsɛlamɔ ye bibi ye kĩ ye obinyole a saɛ. ");
INSERT INTO bov_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Evia be lɔkɔ a kĩ de kamɛ obinyole a saɛ, ade bibi ye kĩ, “Kadzɔ suwa ɔdɔũ mɔa kamɛ mɔ atilili a fɔnɛ ye awɛ.” ");
INSERT INTO bov_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ade ɔlɛga a te anɛ kĩ ade lɔkɔ a na kamɛ pɛpɛɛpɛ Yesu bi ye kĩ, “Nɔ obi aana nkpã.” Nɛ foesũ ye mɔ ye tɔtɔ kamɛ bati flee tɛ Yesu bido. ");
INSERT INTO bov_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ade fukĩĩ nyɛ nsɛntsɛlɛni ayade kĩ Yesu kɛna nɛ Galilea, kĩ emuniki eto Yudea ɛya a. ");
INSERT INTO bov_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ke liti a, kĩ Yudafɔ luwi lidi kanya wo ɔtɔ a, Yesu muniki ɛnaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lutubu lidi deĩ nɛ Yerusalem kakɔ a kĩ bavɛ Baveli Onyukpɛ̃ a ɔwɛ̃, kĩ bavɛ nɛ Hebri tide kamɛ kĩ Betesda. Bike tɛpata elo nɛ de atɔ. ");
INSERT INTO bov_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Basɔnɛ beblebee awa nɛ tɛpata a kamɛ, be badi nyɛ banɛkunɛ, babɛbã nyɛ lɛkpɛ̃ banɛnɛ mɔ abafã amɛ. Bawa nɛ awã kadzɔlɛ kĩ bɛyaakputua mui a. ");
INSERT INTO bov_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Kitonɛkĩ ntɛ kideĩ kideĩ Baguma ode fɔtɔ ɔnyanɛ odi ato ode kayaakputua mui a. Ɔsɔnɛ ɔtɔnyade kĩ yawo nɛ mui a kamɛ nɛ be kakputua liti a, asaɛ nɛ fɔsɔ nyɛ fɔsɔ kĩ yasɔ a kamɛ.) ");
INSERT INTO bov_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Onyole odi kĩ ɛkasɔ futeli taalɛ-alɛ̃ flee na nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kĩ Yesu mɔ́ ye kĩ ɛwaa nɛ awã a, enyi kĩ ɛkasɔ owi buna, foesũ evia ye kĩ, “Awɛ kĩ asaɛ?” ");
INSERT INTO bov_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɔsɔnɛ a kpa mbuayɛ kĩ, “Ɔnɔkɔɛ̃, ntɛ bikputua mui a ni, nlá odima kĩ yabɔɛ yĩ ɛnaado nɛ lutubu a kamɛ. Ntɛ mbɔa mbɔdi ĩyidza manaa a, lɔkɔa oti bɛbã tɛ̃ ɛnya yĩ lɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu bi ye kĩ, “Yidza kadza, kabɔɛ nɔ ɔkɛna katsã!” ");
INSERT INTO bov_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lɛtalɛta ɔsɔnɛ a na akũ ɔsĩ, ɛbɔɛ ye ɔkɛna edo katsã awɛ. Luwi a kĩ fukĩĩ ya a nyɛ Yudafɔ Kawɛya Luwi, ");
INSERT INTO bov_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","foesũ Yudafɔ banɔkɔɛ̃ a bi oti a kĩ Yesu tsa a kĩ ɛnɔnɛ ye ɔkɛna a kĩ, “Nviã nyɛ Kawɛya Luwi. Boe mbla a tákpa osi kĩ alɔ nɔ ɔkɛna.” ");
INSERT INTO bov_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Onyole a kpa be mbuayɛ kĩ, “Oti a kĩ ɛtsa yĩ a libi yĩ kĩ, ‘Yidza kadza, kabɔɛ nɔ ɔkɛna katsã!’ ” ");
INSERT INTO bov_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ade ke bivia ye kĩ, “Owei nyɛ oti a kĩ ebi nɔ kĩ bɔɛ nɔ ɔkɛna katsã?” ");
INSERT INTO bov_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lɛmɛ oti a kĩ bɛtsa a linyína Yesu, kitonɛkĩ bati yi awã, ade Yesu lɛmɛ vɛlɛ akũ ɛnɛ nɛ bati a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ke liti a, Yesu mɔ́ ye nɛ Asɔli Kɔla a kamɛ ade ebi ye kĩ, “Dã! Finyaa ɔna akũ ɔsĩ, foesũ fɔ̃ tɔkpa kakɛna, ntɛ nnɛ́ aye ni, lɛtsa kpa bɛbã kĩ lɛbɛ̃ fukĩĩ aaya nɛ nɔ akũ.” ");
INSERT INTO bov_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ade ke onyole a dzakũ ɛnabi Yudafɔ banɔkɔɛ̃ a kĩ Yesu lɛtsa ye. ");
INSERT INTO bov_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Foesũ bido Yesu liti katomɛna awɛ, kitonɛkĩ ɛtsa oti nɛ Kawɛya Luwi akũ. ");
INSERT INTO bov_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lɛmɛ Yesu bi be kĩ, “Nda akɛna adzuma luwi nyɛ luwi, ade yĩ malo kɛnɛ kĩ nkɛna adzuma a.” ");
INSERT INTO bov_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Fɔlɛtsa kĩĩ fɔ̃ Yudafɔ banɔkɔɛ̃ a buki bɛwɛ mɔ ɔsĩ mɔ ɔsĩ kĩ bakɔ Yesu, kitonɛkĩ nnɛ́ Kawɛya Luwi mbla a odi efum, mbom ebuki ɛlɛ kĩ Baguma nyɛ Ɔlɛga, kĩ fɔatsa kĩ ɛkɔa ye akũ eketimɔ Baguma. ");
INSERT INTO bov_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Foesũ Yesu bi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ Obi a lɛláapuli ɛkɛna lɛtsama nɛ ye mɔawɛ akũ. Lɛtsa a kĩ Obi a amɔ kĩ Ɔlɛga akɛna a, ade de odi ye malo yakɛna a. ");
INSERT INTO bov_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kitonɛkĩ Ɔlɛga a awɛ Obi a kalɛ, ade yatsa ye lɛtsa nyɛ lɛtsa kĩ ye mɔawɛ yakɛna a. Yaatsa Obi fɔtsa kpale kɔlaa kĩ fɔbɛ̃ fukĩĩ kĩ ɛkɛna, kĩ fɔ́akɛna mi wãwã. ");
INSERT INTO bov_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndɛ ayekĩ Ɔlɛga a adzɛla banɔkpa badzi nkpã a, ade aye Obi a lɛmɛ aakpa bikĩ ɛpau a nkpã a. ");
INSERT INTO bov_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɔlɛga mɔawɛ a ládzɛmɔ odima, mbom ɛkɔa kɔbɛ̃ flee edo nɛ Obi a awɛ kĩ ɛdzɛmɔ bati flee, ");
INSERT INTO bov_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ayekĩ be flee baakɔa obu bɛkpa Obi a ndɛ ayekĩ bakɔa kakpa Ɔlɛga a. Odi nyɛ odi kĩ yaábu Obi a ni, yaábu Ɔlɛga a kĩ ye lido ye a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi kĩ yatse yĩ fɔlɛtsa, mɔ yatɛ oti a kĩ edo yĩ a kado ni, edeĩ nkpã kĩ ɛlá kawũna a. Bɛláadzɛmɔ ye, mbom ɛtsã wuda kamɛ ɛtɛ̃, ɛna nkpã kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ lɔkɔ lidi aya, ade lɛya kɔkɔɛ malo, kĩ banɔkpa aanu Baguma Obi a odo, ade bikĩ binu ye odo a aadzi nkpã a. ");
INSERT INTO bov_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndɛ ayekĩ Ɔlɛga a mɔawɛ kamɛ nkpã deĩ a, ade ayea ɛfɔ̃ nkpã deĩ nɛ Obi a lɛmɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɛkpa ye kɔbɛ̃ kĩ ɛdzɛ ɛkɔ kɔtɔ lɛmɛ, kitonɛkĩ ye nyɛ Otidziwa Obi a. ");
INSERT INTO bov_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Fukĩĩ fɔtakɛna mi wãwã, kitonɛkĩ lɔkɔ lidi aya kĩ banɔkpa flee aanu ye odo, ");
INSERT INTO bov_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","lɔkɔa baanɛ nɛ be funikɛ kamɛ. Bikĩ bɛkɛna tuwĩ a aayidza bidzi nkpã, ade bikĩ bɛkɛna tɔkpa a aayidza bɛkpa kɔtɔkaku.” ");
INSERT INTO bov_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesu buki ɛlɛ kĩ, “Nláapuli nkɛna lɛtsama nɛ yĩ mɔawɛ otumi akũ. Madzɛ fɔlɛtsa ndɛ ayekĩ Baguma abi yĩ, foesũ madzɛ nɛ osi kpĩĩ akũ, kitonɛkĩ maákɛna nɛ yĩ mɔawɛ kawɛ akũ, mbom makɛna nɛ oti a kĩ edo yĩ a kawɛ akũ. ");
INSERT INTO bov_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ntɛ ndi adansiɛ nɛ yĩ mɔawɛ akũ ni, yĩ adansiɛ a tákpɔla. ");
INSERT INTO bov_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lɛmɛ oti bɛbã deĩ kĩ yadi adansiɛ nɛ yĩ akũ, ade ĩnyina kĩ lɛtsa a kĩ yalɛ nɛ yĩ akũ a kpɔla. ");
INSERT INTO bov_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mido batɔ nɛ Yohanes sɛkɛ̃, ade ebi mi ɔnɔkɔali nɛ yĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ntásĩ otidziwa adansiɛ kadi nɛ yĩ akũ, mbom nlɛ fukĩĩ ayekĩ míana nkpã katɛ. ");
INSERT INTO bov_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes la ndɛ ɔsɛdza kĩ yatɛ̃ kakpalɛ fɔkɔ, ade miawɛ kĩ miamɔ kawɔlɛ sukuloo nɛ ye ɔhaĩ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Lɛmɛ ndeĩ adansiɛ kĩ ɛbɛ̃ Yohanes ade a. Fɔtsa a kĩ makɛna a kĩ fɔnyɛ tudzuma kĩ Nda kpa yĩ kĩ nkɛna nwũna a, ade foe adi adansiɛ nɛ yĩ akũ, katsa lɛmɛ kĩ Ɔlɛga a lido yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ɔlɛga a kĩ edo yĩ a, ade ye adi adansiɛ nɛ yĩ akũ a. Mitánu tɔ̃ ye odo ĩye mimɔ́ tɔ̃ ayekĩ ɛla a. ");
INSERT INTO bov_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mitátɛ ye fɔlɛtsa a nɛ mi tɔwɔlɛ kamɛ, kitonɛkĩ mitátɛ oti a kĩ edo a mido. ");
INSERT INTO bov_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Miatsã Katsɛlɛ Kpalɛwa a fɔlɛtsa kamɛ fininiini, kitonɛkĩ miakɔna kĩ foe kamɛ míatsã mina nkpã kĩ ɛlá kawũna a. Ade ovoli kĩĩ kamɛ fɔlɛtsa mɔapɛ a adi adansiɛ nɛ yĩ akũ a, ");
INSERT INTO bov_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","lɛmɛ miáwɛ kĩ miaya nɛ yĩ sɛkɛ̃ ayekĩ míana nkpã. ");
INSERT INTO bov_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Maáwɛ kamu ntomɛna batidziwa sɛkɛ̃, ");
INSERT INTO bov_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kitonɛkĩ ĩnyina bati a odu kĩ be mianɛ, ade ĩnyina lɛmɛ kĩ milá ɔdɔ mikpa Baguma nɛ mi tɔwɔlɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ĩya nɛ Nda dĩ akũ lɛmɛ mitátɛ yĩ. Lɛmɛ ntɛ oti bɛbã lɛya nɛ ye mɔawɛ dĩ akũ ni, míatɛ ye. ");
INSERT INTO bov_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Miawɛ kĩ miatɛ mi akũ akũ kamu, lɛmɛ miáwɛ kamu a kĩ kito oti a kĩ ye odi nyɛ Baguma a sɛkɛ̃, lɔkɔa nde míapuli mitɛ yĩ mido? ");
INSERT INTO bov_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Lɛmɛ mitakɔna kĩ yĩ aatsua mi onukpɛ̃ nkpa Nda. Mose a kĩ ye akũ mikɔa anɛ mite a, ade ye nyɛ oti kĩ yaatsua mi onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ntɛ miti mitɛ Mose mido ni, kufɛ míatɛ yĩ malo mido, kitonɛkĩ ɛtsɛlɛ fɔlɛtsa eyi nɛ yĩ akũ. ");
INSERT INTO bov_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lɛmɛ ntɛ mitátɛ fɔlɛtsa a kĩ ɛtsɛlɛ eyi a mido ni, nde míakɛna mitɛ yĩ fɔlɛtsa a mido?” ");
INSERT INTO bov_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ke liti a, Yesu nyina Galilea ɔwɔ lutubu baũ a kĩ bavɛ lɛmɛ kĩ Tiberia ɔwɔ lutubu baũ a, ɛnaa sɛkɛ sitide a. ");
INSERT INTO bov_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bati kɔdabu kpale tomɔ ye kitonɛkĩ bɛmɔ́ awãwã fɔtsa a kĩ ɛkɛna, nɛ basɔnɛ katsa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ade Yesu de ɛnaa ɔtɔ akũ ɛnakɛna akũ edzi mɔ ye fɔtsa bakɔlɛnɛ. ");
INSERT INTO bov_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Finyaa, Wuda Katɛ̃ Luwi kanya lɔkɔ a wo ɔtɔ liyua. ");
INSERT INTO bov_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kĩ Yesu dzɛla anɛ ɛdã fɔkɔ a, ɛmɔ́ kĩ bati kɔdabu baũ kudi lamɛna ye sɛkɛ̃ kaya, foesũ evia Filipo kĩ, “Ndia bɔ́ana funitsã bɔya bɔkpa bati kĩĩ flee?” ");
INSERT INTO bov_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu mɔawɛ nyina lɛtsa a kĩ yaakɛna, lɛmɛ evia Filipo kalɛ kĩĩ kĩ yasɔ ye ɛdã. ");
INSERT INTO bov_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ade Filipo kpa ye mbuayɛ kĩ, “Ntɛ bɔya funitsã sika ovoe ɔha nviã malo ni, fɔláawĩ be ntɛ odi nyɛ odi tɛ sukuloo sukuloo malo.” ");
INSERT INTO bov_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Awã naa, Yesu fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa, Andrea, kĩ ɛnyɛ Simon Petro ɔwaɛ̃ bi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Opopo odi nɛɛ abodoo fɔbɔ elo mɔ kɔfɔabi nviã nɛ awĩ. Lɛmɛ futi fɔláato bati beblebee kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu bi be kĩ, “Mifɔ̃ bati a flee bɛkɛna akũ bidzi.” Tuwĩ blɔblɔ deĩ nɛ awã ade bati a flee kɛna akũ bidzi nɛ te akũ a. Banyole a lidede aana ndɛ mpim elo. ");
INSERT INTO bov_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ade ke Yesu tɛ abodoo a ɛnyɛ Baguma kɔlɛ, ade ɛsɛ̃ ye ɛkpa bati a. Ɛkɛna kɔfɔabi a lɛmɛ lɔmɔ, ade be flee bɛna funitsã ndɛ ayekĩ bawɛ a. ");
INSERT INTO bov_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kĩ bɛnya biwĩ a, Yesu bi ye fɔtsa bakɔlɛnɛ a kĩ, “Mikpɔta fukĩ fute a. Mitafɔ̃ bubula fudima kade.” ");
INSERT INTO bov_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Foesũ bifila fukĩ bati a nya bitina nɛ abodoo elo a kamɛ a biyula tɛtsɛtsɛ ewua-nviã. ");
INSERT INTO bov_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kĩ bati a mɔ́ awãwã fɔtsa a kĩ Yesu kɛna nɛ awã a, bɛlɛ kĩ, “Ɔnɔkɔali, ade Baguma onukpɛ̃ ɔnyɛnɛ a kĩ yaya nɛ katinya kamɛ a!” ");
INSERT INTO bov_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kĩ Yesu mɔ́ kĩ baayatimtim ye bipi bidzina lɛgã a, foesũ ɛnɛ́ nɛ be kamɛ ebuki ede ɛnaa ɔtɔ akũ ye odi. ");
INSERT INTO bov_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kĩ olobe lɔkɔ wo ɔtɔ a, Yesu fɔtsa bakɔlɛnɛ a ka bɛnaa ɔwɔ lutubu baũ a abuĩ. ");
INSERT INTO bov_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Biwo nɛ ɔkɔlɔ kamɛ bimuniki binyina banaa Kapernaum. Nɛ lɔkɔ a, kade dɔ lɛmɛ Yesu táyawo tɔ̃ be sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nɛ lɔkɔ a na kamɛ a, ɔwɛ kpale odi kavũ mɔ ɔsĩ mɔ ɔsĩ kabɔa mui kadɛla kakamɛna. ");
INSERT INTO bov_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kĩ fɔtsa bakɔlɛnɛ a tá ɔkɔlɔ a banaa lɔtɔ ndɛ fusikũ ɛlalɛ ĩye foe ɛna a, bɛmɔ́ Yesu kĩ ɛtsɛ̃ mui anɛ yaya nɛ ɔkɔlɔ a sɛkɛ̃, ade libe wo be a. ");
INSERT INTO bov_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lɛmɛ Yesu bi be kĩ, “Mitavila. Yĩ manɛ!” ");
INSERT INTO bov_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɔwɔlɛ ka edzi be ade bɛfɔ̃ Yesu wo nɛ ɔkɔlɔ a kamɛ a. Lɛtalɛta ɔkɔlɔ a wo lɔwɔtuni nɛ awã kĩ banaa a. ");
INSERT INTO bov_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kĩ kade nyina a, bati kɔdabu a kĩ bɛkahɔ nɛ ɔwɔ lutuni litide kadzɔ a mɔ́ biyi ɔsũ kĩ ɔkɔlɔ mɔapɛ lɛna nɛ awã. Bɛmɔ́ lɛmɛ kĩ Yesu táwo nɛ ɔkɔlɔ a kamɛ ebumɔ ye fɔtsa bakɔlɛnɛ a, mbom bɛdzakũ bɛfɔnɛ ye. ");
INSERT INTO bov_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lɔkɔ a na kamɛ a, tɔkɔlɔ bɛbã tidi kĩ tito Tiberia ɔmatɔ a yadza tifuã awã kĩ bati nya abodoo a kĩ boe Ɔlate bɔa mpaɛ nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kĩ bati kɔdabu a mɔ́ kĩ Yesu ĩye ye fɔtsa bakɔlɛnɛ a kamɛ odima lɛláa awã a, biwo nɛ tɔkɔlɔ a kamɛ bɛnaa Kapernaum bɛnaawɛ ye. ");
INSERT INTO bov_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kĩ bati a mɔ́ Yesu nɛ lɔwɔtuni litide a ni, bivia ye kĩ, “Fɔtsa Ɔtsanɛ, lɔkɔ lɔwɔdabe ɔyawo awĩ?” ");
INSERT INTO bov_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kpa be mbuayɛ kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, nnɛ́ awãwã fɔtsa a kĩ nkɛna mimɔ́ a sũ mitsɛ̃ miawɛ yĩ, mbom abodoo a kĩ mina minya miwĩ a sũ. ");
INSERT INTO bov_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mitaha akũ nɛ funitsã kĩ fɔ́abu kade akũ, mbom miha akũ miwɛ funitsã a kĩ fɔ́awa fɔkpa daa nkpã a kĩ Otidziwa Obi a aakpa mi a, kitonɛkĩ ade ye akũ Baguma boe Ɔlɛga a te awɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Foesũ bati a via Yesu kĩ, “Litsa kɛnɛ kĩ bɔkɛna fɔtsa kĩ bɔakɛna Baguma adzuma?” ");
INSERT INTO bov_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kpa be mbuayɛ kĩ, “Lɛtsa a kĩ Baguma awɛ kĩ mikɛna nyɛ kĩ mitɛ oti a kĩ edo a mido.” ");
INSERT INTO bov_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ade bivia ye kĩ, “Nsɛntsɛlɛni awɔdabe aakɛna bɔmɔ́ lɔkɔa bɔtɛ nɔ budo? Litsa aakɛna? ");
INSERT INTO bov_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Boe bawanyɔ nya funitsã a kĩ bavɛ mana a nɛ kɔsa kamɛ ndɛ ayekĩ bɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, ‘Ɛkpa be abodoo etomɛna ode kĩ bɛnya.’ ” ");
INSERT INTO bov_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu bi be kĩ, “Ɔnɔkɔali a mabi mi kĩ, nnɛ́ Mose lɛkpa mi abodoo a etomɛna ode, mbom Nda akpa abodoo wĩ katomɛna ode. ");
INSERT INTO bov_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kitonɛkĩ Baguma abodoo a nyɛ́ oti a kĩ eto ode ɛya kĩ yakpa katinya nkpã.” ");
INSERT INTO bov_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ade bibi ye kĩ, “Boe Ɔlate, kpa boe abodoo kĩĩ daa.” ");
INSERT INTO bov_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu bi be kĩ, “Yĩ nyɛ abodoo a kĩ yakpa nkpã. Odi nyɛ odi kĩ ɛya nɛ yĩ sɛkɛ̃ ni, kɔlɛ lɛláakɔ ye da, ade odi nyɛ odi kĩ ɛtɛ yĩ edo ni, ɔmɔado lɛláakɔ ye da. ");
INSERT INTO bov_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Finyaa mbi mi kĩ, mimɔ́ yĩ, lɛmɛ miátɛ mido. ");
INSERT INTO bov_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Odi nyɛ odi kĩ Nda kɔa ɛkpa yĩ ni, yaaya nɛ yĩ sɛkɛ̃, ade odi nyɛ odi kĩ ɛya nɛ yĩ sɛkɛ̃ ni, nláablɔmɛna ye da, ");
INSERT INTO bov_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kitonɛkĩ nto ode ĩya, nnɛ́ kĩ mayaakɛna nɛ yĩ mɔawɛ kawɛ akũ, mbom kĩ makɛna oti a kĩ edo yĩ a odi kawɛ akũ. ");
INSERT INTO bov_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ade oti a kĩ edo yĩ a kawɛ nyɛ kĩ bati a kĩ ɛkɔa ɛkpa yĩ a kamɛ odima ɛtayɛla, mbom kĩ ndzɛla be flee bidzi nkpã nɛ luwi nkaɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kitonɛkĩ Nda kawɛ nyɛ kĩ odi nyɛ odi kĩ ɛmɔ́ Obi a mɔ ɛtɛ ye edo lɛmɛ ni, ɛna nkpã kĩ ɛlá kawũna a. Ade maadzɛla ye edzi nkpã nɛ luwi nkaɛ a akũ a.” ");
INSERT INTO bov_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yudafɔ a do hũhũhũhũ kakɛna awɛ nɛ Yesu akũ, kitonɛkĩ ɛlɛ kĩ, “Yĩ nyɛ abodoo a kĩ eto ode ɛya a.” ");
INSERT INTO bov_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Foesũ bɛlɛ kĩ, “Nnɛ́ Yesu, Yosef obinyole a kĩ bunyina ɔlɛga mɔ ɔma flee a nɛ awĩ a? Nde fɔya mɔ finyaa yalɛ kĩ ode eto ɛya?” ");
INSERT INTO bov_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ade Yesu kpa be mbuayɛ kĩ, “Mifɔ̃ hũhũhũhũ kakɛna nɛ mi kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Odima lɛláapuli ɛya nɛ yĩ sɛkɛ̃ mbɔɛntɛ Nda a kĩ edo yĩ a vɛlɛ ye ɛma yĩ, ade maadzɛla ye edzi nkpã nɛ luwi nkaɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Baguma onukpɛ̃ banyɛnɛ a tsɛlɛ biyi kĩ, ‘Baguma aatsa bati flee fɔtsa!’ Odi nyɛ odi kĩ etse Ɔlɛga a, ɛkɔlɛ fɔtsa etomɛna ye sɛkɛ̃ ni, aya nɛ yĩ sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lɛmɛ fukĩĩ látsa kĩ odi mɔ́ tɔ̃ Ɔlɛga a, mbɔɛntɛ oti a kĩ eto Baguma sɛkɛ̃ a odi lɛmɔ Ɔlɛga a. ");
INSERT INTO bov_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi kĩ ɛtɛ edo ni, edeĩ nkpã kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yĩ nyɛ abodoo a kĩ yakpa nkpã. ");
INSERT INTO bov_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mi bawanyɔ nya mana nɛ kɔsa kamɛ, lɛmɛ biku. ");
INSERT INTO bov_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lɛmɛ abodoo a kĩ eto ode ɛya a aafɔ̃ odi nyɛ odi kĩ yanya ye a lɛláaku. ");
INSERT INTO bov_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yĩ nyɛ abodoo a kĩ yakpa nkpã, kĩ eto ode ɛya a. Ntɛ odi nya abodoo kĩĩ ni, yaadzi nkpã daa, ade ke abodoo a kĩ maakpa ye a nyɛ yĩ sukɛna, kĩ makpa katinya kamɛ bati bɛna nkpã.” ");
INSERT INTO bov_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Fukĩĩ fɔ̃ Yudafɔ a yi fɔlɛtsa kavɛlɛ kayɔ nɛ kalɔkpa kamɛ nɛ be kamɛ ade bivia kĩ, “Nde oti kĩĩ aapuli ɛkɔa ye sukɛna ɛkpa boe kĩ bɔba?” ");
INSERT INTO bov_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ade Yesu bi be kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ntɛ mitába Otidziwa Obi a sukɛna, mimɔa ye babɔanɛ a ni, miláana nkpã nɛ mi kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Odi nyɛ odi kĩ ɛba yĩ sukɛna ɛmɔa yĩ babɔanɛ lɛmɛ ni, yaana daa nkpã a, ade maadzɛla ye edzi nkpã nɛ luwi nkaɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kitonɛkĩ yĩ sukɛna nyɛ funitsã wĩ a, ade yĩ babɔanɛ lɛmɛ nyɛ bavɛ wĩ a. ");
INSERT INTO bov_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Odi nyɛ odi kĩ yaba yĩ sukɛna, kĩ yamɔa yĩ babɔanɛ lɛmɛ ni, edeĩ nɛ yĩ kamɛ ade yĩ malo ndeĩ nɛ ye kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ndɛ ayekĩ Ɔlɛga a kĩ edzi nkpã do yĩ a, kĩ ndzi nkpã nɛ ye sũ a, ade ayea odi nyɛ odi kĩ ɛba yĩ sukɛna lɛmɛ aadzi nkpã nɛ yĩ sũ a. ");
INSERT INTO bov_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ade abodoo a kĩ eto ode a nɛ awĩ a. Ɛlá ndɛ mana a kĩ mi bawanyɔ nya lɛmɛ ke liti, biku a. Odi nyɛ odi kĩ ɛnya abodoo kĩĩ aadzi nkpã daa.” ");
INSERT INTO bov_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu lɛ fukĩĩ nɛ lɔkɔ a kĩ ɛkatsa fɔtsa nɛ Yudafɔ katsɛnakɔ̃ nɛ Kapernaum. ");
INSERT INTO bov_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu fɔtsa bakɔlɛnɛ a pii nu fɔlɛtsa kĩĩ ade bɛlɛ kĩ, “Fɔtsa katsa kĩĩ tɛnɛ́ ɔsĩ! Owei aapuli ɛtɛ foe?” ");
INSERT INTO bov_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu mɔ́ eyi ɔsũ kĩ bɛkakɛna hũhũhũhũ, foesũ ebi be kĩ, “Mbɔɛɛ fukĩĩ fɔ̃ miawɛ kĩ miakpa lɔlɔ? ");
INSERT INTO bov_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kekɔ̃ nde fɔ́ana ntɛ mimɔ́ Otidziwa Obi a kĩ emuniki ede yanaa ode, awã kĩ ɛna tɔ̃ a? ");
INSERT INTO bov_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Baguma Hũhũ a akpa nkpã, otidziwa kɔbɛ̃ lɛláa lɛtsama kamɛ. Fɔlɛtsa a kĩ mbi mi a nyɛ Hũhũ kamɛ fɔlɛtsa kĩ foe kamɛ nkpã deĩ. ");
INSERT INTO bov_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lɛmɛ mi kamɛ badi tátɛ bido.” Kitonɛkĩ Yesu nyi kito anɛ kayɔkayi a bati a kĩ bɛláatɛ bido mɔ oti a kĩ ye aanyɛ ye ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɛlɛ ebu kĩ, “Ade fukĩĩ sũ mbi mi kĩ odima lɛláapuli ɛya nɛ yĩ sɛkɛ̃ mbɔɛntɛ Ɔlɛga a kpa ye osi.” ");
INSERT INTO bov_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kito fukĩĩ akũ a, Yesu fɔtsa bakɔlɛnɛ a badi pii muniki nɛ ye liti, ade bɛtábuki bitomɔ ye a. ");
INSERT INTO bov_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Foesũ evia fɔtsa bakɔlɛnɛ ewua-nviã a kĩ, “Mi malo miawɛ kĩ miadzakũ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ade Simon Petro kpa ye mbuayɛ kĩ, “Boe Ɔlate, owei sɛkɛ̃ bɔ́adzakũ bɔnaa? Nɔ deĩ daa nkpã a fɔlɛtsa. ");
INSERT INTO bov_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Finyaa kɔ̃ bɔtɛ budo ade bunyina kĩ nɔ nyɛ Oti Kpalɛwa a kĩ eto Baguma sɛkɛ̃ a.” ");
INSERT INTO bov_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ade ke Yesu kpa mbuayɛ kĩ, “Nnɛ́ mi bati ewua-nviã mpau? Lɛmɛ mi kamɛ ɔmɔa nyɛ Abonsam!” ");
INSERT INTO bov_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yuda, Simon Iskariot obi a akũ fɔlɛtsa ɛkalɛ, kitonɛkĩ titɔ kĩ ɛnyɛ be ewua-nviã a kamɛ ɔmɔa malo ni, ade ye aanyɛ ye ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ke liti a, Yesu natsã emini nɛ Galilea tite akũ, ɛtáwɛ kĩ yamini nɛ Yudea tite kamɛ, kitonɛkĩ Yudafɔ banɔkɔɛ̃ nɛ awã kawɛ kĩ bakɔ ye. ");
INSERT INTO bov_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nɛ lɔkɔ a na kamɛ a, Yudafɔ Tɛpatampa Kayɔ Kadzi Luwi kanya a fuã, ");
INSERT INTO bov_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","foesũ Yesu bawaɛ̃nyole bi ye kĩ, “Dzakũ nɛ awĩ kanaa Yudea tite akũ, lɔkɔa nɔ fɔtsa bakɔlɛnɛ a lɛmɛ bɛmɔ adzuma a kĩ ɔlamɛna kakɛna a. ");
INSERT INTO bov_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Odima lákɔla ye adzuma ntɛ yawɛ kĩ bati binyi ye kanyi wĩ. Ntɛ nuwĩ ɔlamɛna fɔtsa kĩĩ bamɛ flee kakɛna ni, nyɛ nɔ akũ katsa katinya kamɛ bati flee!” ");
INSERT INTO bov_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesu bawaɛ̃nyole a lɛ fukĩĩ kitonɛkĩ be malo bɛtátɛ ye bido. ");
INSERT INTO bov_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ade Yesu bi be kĩ, “Yĩ lɔkɔ wĩ táwo tɔ̃ ɔtɔ, lɛmɛ mi kɔ̃ lɔkɔ nyɛ lɔkɔ nɛnɛ lɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Katinya kamɛ bati lɛláapuli bikesĩ mi, lɛmɛ yĩ kɔ̃ bakesĩ yĩ, kitonɛkĩ ndzɛmɔ be kabi kĩ be tudzuma nyɛ tɔkpa. ");
INSERT INTO bov_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Minaa luwi a kanyakɔ̃. Yĩ kɔ̃ nláanaa luwi kĩĩ kanyakɔ̃, kitonɛkĩ yĩ lɔkɔ wĩ táwo tɔ̃ ɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kĩ Yesu lɛ fukĩĩ eyua a, ebuki ɛkahɔ nɛ Galilea. ");
INSERT INTO bov_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kĩ Yesu bawaɛ̃nyole a dzakũ bɛnaa luwi kanyakɔ̃ a, ye malo ɛyanaa awã, lɛmɛ ɛtányɛ ye akũ ɛtsa, mbom ɛbɛla ye akũ. ");
INSERT INTO bov_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yudafɔ banɔkɔɛ̃ a kawɛ ye nɛ luwi a kanyakɔ̃, bɛkavia kĩ, “Nde oti a?” ");
INSERT INTO bov_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bati kɔdabu a kalɛ kɔdzɛla pɛtɛɛ pɛtɛɛ nɛ Yesu akũ. Be kamɛ badi lɛ kĩ, “Oti wĩ yanɛ.” Ade babɛbã lɛmɛ lɛ kĩ, “Oowo, ɛtsɛ̃ yakɛ bati.” ");
INSERT INTO bov_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lɛmɛ odima tápuli ɛlɛ foe kɔɔba, kitonɛkĩ bivila Yudafɔ banɔkɔɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kĩ kite sukuloo luwi kanya a atɛ̃ de kayite a, Yesu naa Baguma Asɔli Kɔla a kamɛ ɛnado bati fɔtsa katsa awɛ. ");
INSERT INTO bov_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ye fɔtsa katsa a kɛna Yudafɔ banɔkɔɛ̃ a wãwã paa, ade bɛlɛ kĩ, “Nde oti kĩĩ kɛna enyina ovoli lɔmɔ, kĩ ɛtána fɔtsa kakɔlɛ kadima?” ");
INSERT INTO bov_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kpa be mbuayɛ kĩ, “Fɔtsa a kĩ matsa a lɛnyɛ́ yĩ mɔawɛ fude, mbom futo Baguma kĩ edo yĩ a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Odi nyɛ odi kĩ yawɛ kĩ yakɛna nɛ lɛtsa a kĩ Baguma awɛ akũ a, aanyi ntɛ fɔtsa a kĩ matsa a to Baguma sɛkɛ̃ ĩye malɛ foe nɛ yĩ mɔawɛ kɔbɛ̃ akũ. ");
INSERT INTO bov_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oti kĩ yatsa fɔtsa nɛ ye mɔawɛ kɔbɛ̃ akũ ni, obu yawɛ ɛkpa ye akũ. Lɛmɛ ntɛ oti awɛ obu ɛkpa oti a kĩ edo ye a ni, ɛnyɛ ɔnɔkɔalini, ade tɔkpa tidima lɛláa ye kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mbɔɛɛ nnɛ́ Mose lɛkpa mi mbla a? Lɛmɛ mi kamɛ odima lákɛna nɛ mbla a akũ. Nde sũ miawɛ kĩ miakɔ yĩ?” ");
INSERT INTO bov_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ade bati kɔdabu a bi ye kĩ, “Hũhũ kpa deĩ nɛ nɔ kamɛ! Owei awɛ kĩ yakɔ nɔ?” ");
INSERT INTO bov_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kpa be mbuayɛ kĩ, “Awãwã fɔtsa mɔa kĩĩ nkɛna, ade mi flee mikɛna saa a. ");
INSERT INTO bov_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose kpa mi mbla kĩ mitsua mi babinyole fɔkpati, ade titɔ kĩ nnɛ́ Mose sɛkɛ̃ futo, mbom mi bawanyɔ liyi foe kayɔ malo ni, miatsua onyole lɛkpati nɛ Kawɛya Luwi akũ. ");
INSERT INTO bov_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ntɛ bitsua obi lɛkpati nɛ Kawɛya luwi akũ ayekĩ bɛláafum Mose mbla a ni, nde sũ mina kalɔkpa nɛ yĩ akũ kĩ ntsa oti fɔsɔ nɛ Kawɛya Luwi a akũ? ");
INSERT INTO bov_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mitadã bati anɛ midzɛ mikɔ kɔtɔ, mbom midzɛ kalɛ nɛ ke osi kpĩĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalem ɔmatɔ a kamɛ bati badi via kĩ, “Nnɛ́ oti kĩĩ Yudafɔ banɔkɔɛ̃ a lamɛna kawɛ kĩ bakɔ a nɛ awĩ a? ");
INSERT INTO bov_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Midã kĩ ɛdzɛ̃ nɛ kanade yalɛ kɔdzɛla, kĩ bɛtávia ye kadima. Mbɔɛɛ fɔ́anya kĩ ɔmaĩ banɔkɔɛ̃ a nyina nuwĩ kĩ ye nyɛ Kristo a? ");
INSERT INTO bov_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Boe flee bunyina awã kĩ oti kĩĩ kɔ̃ to, lɛmɛ ntɛ Kristo a ya ni, odima lɛláanyi awã kĩ eto.” ");
INSERT INTO bov_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kĩ Yesu katsa fɔtsa nɛ Baguma Asɔli Kɔla kamɛ a, ɛbɔa fɔwɔla kɔɔba ɛlɛ kĩ, “Kalɛ mialɛ kĩ miti minyina yĩ mɔ awã kĩ nto a? Ntáya nɛ yĩ mɔawɛ kɔbɛ̃ akũ. Oti a kĩ edo yĩ a nyɛ ɔnɔkɔalini kĩ mi minyína ye, ");
INSERT INTO bov_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","lɛmɛ yĩ kɔ̃ ĩnyina ye, kitonɛkĩ ye sɛkɛ̃ nto ĩya ade ye lido yĩ a.” ");
INSERT INTO bov_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɛ foesũ bɛwɛ kĩ bapi Yesu, lɛmɛ odima tákɔa awɛ ɛta ye, kitonɛkĩ ye lɔkɔ táwo tɔ̃ ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lɛmɛ bati kɔdabu a kamɛ bati pii tɛ ye bido ade bivia kĩ, “Ntɛ Kristo a ya ni, yaakɛna awãwã fɔtsa pii fɔba fukĩ oti kĩĩ lamɛna kakɛna a?” ");
INSERT INTO bov_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisifɔ nu fɔlɛtsa a kĩ bati kɔdabu a lamɛna kalɛ pɛtɛɛ pɛtɛɛ nɛ Yesu akũ a, foesũ bɛmɔ Yudafɔ basɔfɔnɔkɔɛ̃ a bido Asɔli Kɔla akũ badãmɛnanɛ a kĩ bɛnaapi ye. ");
INSERT INTO bov_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ade Yesu lɛ kĩ, “Maana nɛ mi sɛkɛ̃ fubuna owi sukuloo, lɔkɔa maadzakũ nnaa oti a kĩ edo yĩ a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Míawɛ yĩ lɛmɛ miláamɔ yĩ, kitonɛkĩ miláapuli miya nɛ awã kĩ maana a.” ");
INSERT INTO bov_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yudafɔ banɔkɔɛ̃ a via akũ kĩ, “Nɛ ndia ɛwɛ kĩ yanaa kĩ bɔláapuli bɔmɔ́ ye? Mbɔɛɛ kĩ yanaa Yudafɔ a kĩ bɛgba biko nɛ Helafɔ kamɛ a ɛnaatsa Helafɔ a fɔtsa? ");
INSERT INTO bov_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ɛlɛ kĩ bɔ́awɛ ye lɛmɛ bɔláamɔ ye, ade bɔláapuli bɔnaa awã kĩ yaana a. Foe kayɔ nyɛ litsa?” ");
INSERT INTO bov_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nɛ luwi nkaɛ a kĩ lɛnyɛ luwi titiliwu nɛ fuwi kanya kamɛ akũ a, Yesu yidza ɛdza ade ɛbɔa fɔwɔla ɛlɛ kĩ, “Odi nyɛ odi kĩ ɔmɔado akɔ ye ni, ɛya nɛ yĩ sɛkɛ̃ ɛyaamɔa mui. ");
INSERT INTO bov_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ a, ‘Odi nyɛ odi kĩ ɛtɛ yĩ edo ni, nkpã tɔwɔ aatini bito ye ɔwɔlɛ kamɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu kalɛ kɔdzɛla nɛ Hũhũ a kĩ bikĩ bɛtɛ ye bido a aayatɛ a akũ. Nɛ lɔkɔ a na kamɛ a, bɛtákpa tɔ̃ Hũhũ a, kitonɛkĩ bɛtádzɛla Yesu ewo nɛ kukũkpalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kĩ bati a badi nu fɔlɛtsa a kĩ Yesu lɛ a, bɛlɛ kĩ, “Ɔnɔkɔali, Baguma Onukpɛ̃ Ɔnyɛnɛ a nyɛ oti kĩĩ.” ");
INSERT INTO bov_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Babɛbã lɛ kĩ, “Ade Kristo a nɛ awĩ a.” Lɛmɛ bati bɛbã kɔ̃ via kĩ, “Mbɔɛɛ Galilea tite akũ Kristo a aato ɛya? ");
INSERT INTO bov_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Katsɛlɛ Kpalɛwa a tálɛ kĩ Kristo aato Lɛgã Dawid kasinu a kamɛ, ade baama ye nɛ Betlehem, ɔmatɔ a kĩ Dawid dzi a kamɛ?” ");
INSERT INTO bov_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Foesũ kasɛ̃ wo nɛ bati kɔdabu a kamɛ nɛ Yesu sũ. ");
INSERT INTO bov_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Badi wɛ kĩ bapi ye, lɛmɛ odima tákɔa awɛ ɛta ye. ");
INSERT INTO bov_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kĩ Asɔli Kɔla akũ badãmɛnanɛ a muniki bɛya nɛ Yudafɔ basɔfɔnɔkɔɛ̃ mɔ Farisifɔ a sɛkɛ̃ a, bivia be kĩ, “Nde sũ mitápi ye miyamɛna?” ");
INSERT INTO bov_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Asɔli Kɔla akũ badãmɛnanɛ a kpa mbuayɛ kĩ, “Odima tálɛ tɔ̃ kɔdzɛla ndɛ ayekĩ oti kĩĩ alɛ a!” ");
INSERT INTO bov_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ade Farisifɔ a via be kĩ, “Mbɔɛɛ ɛnakɛ mi malo? ");
INSERT INTO bov_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɔnɔkɔɛ̃ ĩye Farisini ɔdabe lɛtɛ ye edo kĩ minyina? ");
INSERT INTO bov_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ade bati kɔdabu kĩĩ, kĩ binyína Mose mbla a sũ ni, Baguma dumu be!” ");
INSERT INTO bov_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo kĩ ɛnyɛ Farisifɔ a kamɛ ɔmɔa, kĩ ɛnaa Yesu sɛkɛ̃ tɔ̃ a na nɛ awã. Edo onukpɛ̃ ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Boe mbla tákpa boe osi kĩ bɔakɔ oti kɔtɔ, mbɔɛntɛ bɔdzɛmɔ ye butse ye onukpɛ̃ kamɛ fɔlɛtsa bunyi lɛtsa a kĩ ɛkɛna a.” ");
INSERT INTO bov_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bibi ye kĩ, “Mbɔɛɛ Galilea nɔ malo oto? Tsã Katsɛlɛ Kpalɛwa a kamɛ kadã, lɔkɔa aamɔ kĩ Baguma onukpɛ̃ ɔnyɛnɛ odima láto Galilea.” ");
INSERT INTO bov_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Ke liti a, odi nyɛ odi dzakũ ɛnaa kɔla.) ");
INSERT INTO bov_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lɛmɛ Yesu de ɛnaa Kugua Futse Ɔtɔ a akũ. ");
INSERT INTO bov_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kĩ kade nyina ɔnɔnɛ tutuutu a, Yesu muniki ɛya nɛ Baguma Asɔli Kɔla a kamɛ. Bati pii yakpɔta nɛ ye akũ, ade ɛkɛna akũ edzi eyi be fɔtsa katsa kayɔ a. ");
INSERT INTO bov_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yudafɔ mbla batsanɛ mɔ Farisifɔ a kpã otsole odi nɛ adɔpaa kabɔa kamɛ bɛyadzɛla nɛ bati a flee anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ade bibi Yesu kĩ, “Fɔtsa Ɔtsanɛ, bipi otsole kĩĩ kĩ onyole bɛbã awa mɔ ye. ");
INSERT INTO bov_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nɛ boe mbla a kamɛ ni, Mose kpa otumi kĩ bɛtalɛ otsole kĩĩ odu boe bɛkɔ. Litsa nɔ kɔ̃ alɛ nɛ foe akũ?” ");
INSERT INTO bov_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bivia fukĩĩ kĩ bakɔa banaĩ ye, ayekĩ baana kalɛ kadi bɛkɔa bitsua ye onukpɛ̃. Lɛmɛ Yesu kɛna akũ ɛkɔa lawobi ɛtsɛlɛ fɔtsa nɛ tite. ");
INSERT INTO bov_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kĩ bɛdza bɛkavia ye fɔlɛtsa a, ɛdzɛla akũ ade ebi be kĩ, “Mi kamɛ owula a kĩ ɛtákɛna tɔkpa tidima tɔ̃ ni, ɛnya lɔtɔ ɛta de ɛbɔa otsole a.” ");
INSERT INTO bov_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ade ke ebuki ɛkɛna akũ ɛtsɛlɛ fɔtsa nɛ tite a. ");
INSERT INTO bov_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kĩ binu fɔlɛtsa kĩĩ a, be flee bɛdzakũ ɔmɔa ɔmɔa, kito banɔkɔɛ̃ a akũ kɛnawo kĩ kite Yesu mɔ otsole a odi nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu dzɛla akũ evia otsole a kĩ, “Boe ɔma, nde bati a? Be kamɛ odima táte kĩ yakɔ nɔ kɔtɔ?” ");
INSERT INTO bov_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Otsole a kpa mbuayɛ kĩ, “Ɔnɔkɔɛ̃, oowo.” Ade ke Yesu bi ye kĩ, “Kekɔ̃ yĩ malo ntákɔ nɔ kɔtɔ. Dzakũ kanaa, lɛmɛ tabuki ɔkɛna tɔkpa.” ");
INSERT INTO bov_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu buki ebi bati a kĩ, “Yĩ nyɛ katinya kamɛ ɔhaĩ, odi nyɛ odi kĩ etomɔ yĩ ni, yaana nkpã ɔhaĩ a, ade ɛláatsã nɛ ɔtũ kamɛ da a.” ");
INSERT INTO bov_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisifɔ a bi ye kĩ, “Adi adansiɛ nɛ nɔ mɔawɛ akũ, foesũ nɔ adansiɛ a tákpɔla.” ");
INSERT INTO bov_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kpa be mbuayɛ kĩ, “Ntɛ madi adansiɛ nɛ yĩ mɔawɛ akũ malo ni, lɛtsa a kĩ malɛ a kpɔla, kitonɛkĩ ĩnyina awã kĩ nto mɔ awã kĩ manaa a. Mi linyína awã kĩ nto ĩye awã kĩ manaa a. ");
INSERT INTO bov_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Miadzɛ fɔlɛtsa nɛ batidziwa kamɔ onukpɛ̃, lɛmɛ yĩ kɔ̃ maádzɛmɔ odima. ");
INSERT INTO bov_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lɛmɛ ntɛ maadzɛ mɔ bati ni, yĩ kadzɛ a aakpɔla, kitonɛkĩ nnɛ́ yĩ odi adzɛ kalɛ, mbom bɔmɔ Nda a kĩ edo yĩ a adzɛ fɔlɛtsa. ");
INSERT INTO bov_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bɛtsɛlɛ nɛ mi mbla a kamɛ kĩ ntɛ adansifɔ nviã onukpɛ̃ kɛna ɔmɔa ni, lɛtsa a kĩ bɛlɛ a kpɔla. ");
INSERT INTO bov_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Madi adansiɛ kakpa yĩ akũ, ade Nda a kĩ edo yĩ a lɛmɛ adi yĩ akũ adansiɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bati a via Yesu kĩ, “Ndia aga deĩ?” Ɛkpa be mbuayɛ kĩ, “Minyína yĩ, ĩye Nda. Ntɛ kanyina minyina yĩ ni, kufɛ míanyi Nda lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu lɛ fɔlɛtsa kĩĩ flee nɛ tɔgɔlɛ katekɔ̃ a, kĩ ɛkatsa fɔtsa nɛ Asɔli Kɔla kamɛ a, lɛmɛ odima tápi ye, kitonɛkĩ ye lɔkɔ táwo tɔ̃ ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu buki ebi be kĩ, “Maadzakũ, ade míawɛ yĩ, lɛmɛ míaku nɛ mi tɔkpa kamɛ. Miláapuli minaa awã kĩ manaa a.” ");
INSERT INTO bov_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ade ke Yudafɔ banɔkɔɛ̃ a via kĩ, “Ye akũ yanaakɔ sũ mɔ ɛlɛ kĩ, ‘Miláapuli miya nɛ awã kĩ manaa a’?” ");
INSERT INTO bov_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kpa be mbuayɛ kĩ, “Tite kĩĩ akũ mito, lɛmɛ yĩ kɔ̃ ode nto ĩya. Katinya kĩĩ kamɛ bati mianɛ, lɛmɛ nnɛ́ katinya kĩĩ kamɛ oti manɛ. ");
INSERT INTO bov_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ade foesũ mbi mi kĩ míaku nɛ mi tɔkpa kamɛ a. Míaku nɛ mi tɔkpa kamɛ ntɛ mitátɛ mido kĩ yĩ nyɛ oti a kĩ ye manɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bɛdani bivia ye kĩ, “Owei anɛ?” Yesu kpa be mbuayɛ kĩ, “Lɛtsa a kĩ mbi mi kito anɛ kayɔkayi a, ade foe mɔapɛ a. ");
INSERT INTO bov_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndeĩ fɔlɛtsa pii kĩ maalɛ nɛ mi akũ nkɔa nkɔ mi kɔtɔ, lɛmɛ oti a kĩ edo yĩ a adi ɔnɔkɔali, ade lɛtsa a kĩ nnu ntomɛna ye sɛkɛ̃ a odi mabi katinya kamɛ bati a.” ");
INSERT INTO bov_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bati a tánu foe kayɔ kĩ Ɔlɛga akũ fɔlɛtsa Yesu kabi be. ");
INSERT INTO bov_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Foesũ ebi be kĩ, “Ntɛ midɛla Otidziwa Obi a nɛ ode a fɔmɔ míanyi kĩ yĩ nyɛ oti a kĩ ye manɛ a. Ade ke míanyi kĩ maákɛna lɛtsama nɛ yĩ mɔawɛ kɔbɛ̃ akũ, mbom lɛtsa a kĩ Nda tsa yĩ kĩ nlɛ a odi malɛ. ");
INSERT INTO bov_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Oti a kĩ edo yĩ a deĩ nɛ yĩ ɔwɛ̃. Ɛtáfɔnɛ yĩ odi eyi, kitonɛkĩ makɛna lɛtsa a kĩ lawo ye anɛ a daa.” ");
INSERT INTO bov_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kĩ Yesu lɛ fɔlɛtsa kĩĩ a, bati pii tɛ ye bido. ");
INSERT INTO bov_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu bi Yudafɔ a kĩ bɛtɛ ye bido a kĩ, “Ntɛ mitɛ yĩ fɔtsa katsa a midomɔ akũ ni, kekɔ̃ yĩ fɔtsa bakɔlɛnɛ wĩ mianɛ. ");
INSERT INTO bov_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Míanyi ɔnɔkɔali a, ade ɔnɔkɔali a aakpa mi akũ akũ kadzi a.” ");
INSERT INTO bov_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bati a kpa ye mbuayɛ kĩ, “Abraham babi mɔ bawa bɔanɛ, ade bɔtánya tɔ̃ odima basate a. Nde sũ alɛ kĩ, ‘Míana akũ akũ kadzi’?” ");
INSERT INTO bov_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu bi be kĩ, “Mabi mi ɔnɔkɔali a kĩ odi nyɛ odi kĩ yakɛna tɔkpa ni, ɛnyɛ tɔkpa ɔsate. ");
INSERT INTO bov_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɔsate lánya kɔla obi daa, lɛmɛ obinyole kɔ̃ nyɛ kɔla obi daa. ");
INSERT INTO bov_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Foesũ ntɛ Obi a kpa mi akũ akũ kadzi ni, lɔkɔa mina akũ akũ kadzi wĩ. ");
INSERT INTO bov_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ĩnyina kĩ Abraham babi mɔ bawa mianɛ, lɛmɛ miawɛ kĩ miakɔ yĩ, kitonɛkĩ yĩ fɔtsa katsa a táwo nɛ mi kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Fɔtsa a kĩ mmɔ́ nɛ Nda sɛkɛ̃ a, ade foe akũ malɛ kɔdzɛla a, lɛmɛ mi kɔ̃ miakɛna lɛtsa a kĩ mi ɔlɛga bi mi a.” ");
INSERT INTO bov_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bibi ye kĩ, “Boe ɔlɛga nyɛ Abraham.” Yesu kpa mbuayɛ kĩ, “Ntɛ Abraham babi mɔ bawa paa mianɛ ni, kufɛ míakɛna fɔtsa ndɛ ayekĩ ɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lɛmɛ miawɛ kĩ miakɔ yĩ oti a kĩ mbi mi ɔnɔkɔali fɔlɛtsa a kĩ ntɛ ntomɛna Baguma sɛkɛ̃ a. Abraham tákɛna fukĩĩ odu. ");
INSERT INTO bov_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mi miakɛna lɛtsa a kĩ mi ɔlɛga a kɛna a.” Bɛkpa ye mbuayɛ kĩ, “Ɔlɛga mɔapɛ budeĩ, ade ye nyɛ Baguma a. Bɔnyɛ́ adɔpaa kamɛ babi.” ");
INSERT INTO bov_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu bi be kĩ, “Ntɛ Baguma liti ɛnyɛ mi Ɔlɛga ni, kufɛ míawɛ yĩ kalɛ, kitonɛkĩ Baguma sɛkɛ̃ nto ĩya. Ntáya nɛ yĩ mɔawɛ kɔbɛ̃ akũ, mbom Baguma lido yĩ. ");
INSERT INTO bov_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nde sũ miánu fɔlɛtsa a kĩ malɛ a kayɔ? Kitonɛkĩ miáwɛ kĩ miatse yĩ fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mi ɔlɛga Abonsam bade mianɛ, ade miawɛ kĩ miakɛna nɛ mi ɔlɛga a fɔwɛtsa akũ a. Owudini yanɛ kito anɛ kayɔkayi, ade yaátomɔ ɔnɔkɔali liti a, kitonɛkĩ ɔnɔkɔali lɛláa ye kamɛ da. Ntɛ ɛma fɔvã ni, ye kutitse ɛnyɛ yatsa, kitonɛkĩ ɛnyɛ ɔvãlɛvã mɔ fɔvã ɔlɛga. ");
INSERT INTO bov_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lɛmɛ yĩ kɔ̃ ɔnɔkɔali a mabi mi, ade foesũ miátɛ yĩ mido a. ");
INSERT INTO bov_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mi kamɛ owei aapuli ɛkɔ yĩ kɔtɔ kĩ nkɛna tɔkpa? Ntɛ nlɛ ɔnɔkɔali a ni, nde sũ mitátɛ yĩ mido? ");
INSERT INTO bov_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Oti kĩ eto Baguma kamɛ a, atse Baguma fɔlɛtsa. Lɛmɛ ayekĩ mitáto Baguma kamɛ sũ ni, miátɛ yĩ fɔlɛtsa.” ");
INSERT INTO bov_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yudafɔ a via Yesu kĩ, “Ntɛ bɔlɛ kĩ Samariani anɛ, ade hũhũ kpa lɛmɛ deĩ nɛ nɔ kamɛ a ni, bɔtálɛ ɔnɔkɔali?” ");
INSERT INTO bov_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kpa be mbuayɛ kĩ, “Hũhũ kpa adima lɛláa yĩ kamɛ. Makpa Nda obu lɛmɛ mi miasupa yĩ. ");
INSERT INTO bov_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Maáwɛ kĩ mado yĩ akũ obu, lɛmɛ odi deĩ kĩ yawɛ foe ade ye adzɛ kakpa yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, odi nyɛ odi kĩ yakɛna nɛ yĩ fɔtsa katsa a akũ a, lɛláaku da.” ");
INSERT INTO bov_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yudafɔ a bi ye kĩ, “Ade owi bɔmɔ́ pefee kĩ hũhũ kpa deĩ nɛ nɔ kamɛ a! Abraham ku, Baguma onukpɛ̃ banyɛnɛ a lɛmɛ ku. Lɛmɛ nɔ kɔ̃ alɛ kĩ, ‘Odi nyɛ odi kĩ yakɛna nɛ yĩ fɔtsa katsa a akũ a, lɛláaku da.’ ");
INSERT INTO bov_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mbɔɛɛ nɔ bɛ̃ boe ɔwanyɔ Abraham kĩ eku a? Baguma onukpɛ̃ banyɛnɛ a lɛmɛ ku. Owei abu kĩ ye anɛ?” ");
INSERT INTO bov_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kpa be mbuayɛ kĩ, “Ntɛ mado yĩ mɔawɛ akũ obu ni, yĩ obu a lɛláana nfasɔ. Oti a kĩ ye ado yĩ obu a nyɛ Nda, oti kĩ mialɛ kĩ ɛnyɛ mi Baguma a. ");
INSERT INTO bov_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Minyína Nda a, lɛmɛ yĩ kɔ̃ ĩnyina ye. Ntɛ nlɛ kĩ ĩnyína ye ni, maakɛna ɔvãlɛvã ndɛ mi aye. Lɛmɛ nti ĩnyina ye ade makɛna nɛ ye kalɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mi ɔwanyɔ Abraham mɔ́ kawɔlɛ kĩ yaamɔ yĩ kaya. Ɛmɔ́ ke lɛmɛ ade kawɔlɛ de ye a.” ");
INSERT INTO bov_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ade ke Yudafɔ a bi ye kĩ, “Ɔtátɛ tɔ̃ futeli aduenum malo, ke mɔ alɛ kĩ ɔmɔ́ Abraham a?” ");
INSERT INTO bov_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kpa mbuayɛ kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, yĩ ndeĩ fɔmɔ bɛma Abraham.” ");
INSERT INTO bov_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ade ke bati a fila boe kĩ bata bɛbɔa ye a, lɛmɛ Yesu bɛla, ade ɛnɛ́ nɛ Baguma Asɔli Kɔla a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kĩ Yesu anaa a, ɛmɔ́ onyole odi kĩ bɛma ye ɔnɛkunɛ. ");
INSERT INTO bov_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ade ye fɔtsa bakɔlɛnɛ a via ye kĩ, “Fɔtsa Ɔtsanɛ, owei tɔkpa sũ bɛma onyole kĩĩ ɔnɛkunɛ? Ye mɔawɛ tɔkpa mbɔɛɛ ye bamanɛ tɔkpa sũ?” ");
INSERT INTO bov_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kpa be mbuayɛ kĩ, “Nnɛ́ onyole kĩĩ ĩye ye bamanɛ lɛkɛna tɔkpa, mbom bɛma ye ɔnɛkunɛ, ayekĩ baanyɛ Baguma kɔbɛ̃ adzuma bɛtsãmɛna ye akũ. ");
INSERT INTO bov_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ntɛ budeĩ nɛ kade kanyina kamɛ ni, kɛnɛ kĩ bɔakɛna adzuma bɔkpa oti a kĩ edo yĩ a. Kade aya kadɔkɔ̃ kĩ odima lɛláapuli ɛkɛna adzuma. ");
INSERT INTO bov_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kĩ ndeĩ nɛ katinya kamɛ kĩĩ ni, yĩ nyɛ katinya kamɛ ɔhaĩ a.” ");
INSERT INTO bov_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, etua tanɛ eyi nɛ tite, ɛfɔnɛ te ɛkɔa ɛtsɛla onyole a nɛ banebi. ");
INSERT INTO bov_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ade ebi ye kĩ, “Naavɔlɛ anɛ nɛ Siloam Lutubu a kamɛ.” Dĩ Siloam kayɔ nyɛ, bido ye. Ade onyole a navɔlɛ anɛ, ade ɛmɔ́ fɔkɔ kĩ emuniki yaya a. ");
INSERT INTO bov_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ye badzikɔba mɔ bikĩ bɛkamɔ ye kĩ ɛkawã fɔtsa a via kĩ, “Mbɔɛɛ nnɛ́ oti kĩĩ adzi kawã fɔtsa a?” ");
INSERT INTO bov_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Badi lɛ kĩ, “Ade ye a.” Lɛmɛ babɛbã lɛ kĩ, “Oowo, nnɛ́ ye yanɛ, kanɛ ɛnɛ́ ye.” Nɛ foesũ oti a mɔawɛ lɛ kĩ, “Ye manɛ.” ");
INSERT INTO bov_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bivia ye kĩ, “Nde fɔya mɔ finyaa kɔ̃ mɔ amɔ fɔkɔ?” ");
INSERT INTO bov_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɛkpa mbuayɛ kĩ, “Onyole a kĩ bavɛ Yesu lɛfɔnɛ tite ekputa yĩ banebi ade ebi yĩ kĩ naavɔlɛ anɛ nɛ Siloam Lutubu a kamɛ. Foesũ nnaa adeke, kĩ nsila nvɔlɛ anɛ pɛ, mpuli mmɔ́ fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bivia ye kĩ, “Nɛ ndia edeĩ?” Ɛkpa be mbuayɛ kĩ, “Ĩnyína.” ");
INSERT INTO bov_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ade ke bati a kpã onyole a kĩ eku tɔ̃ anɛ a bɛma Farisifɔ a. ");
INSERT INTO bov_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Luwi a kĩ de akũ Yesu fɔnɛ tite ɛkɔa ebinya ye anɛ a nyɛ Kawɛya Luwi. ");
INSERT INTO bov_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Foesũ Farisifɔ a lɛmɛ via ye ayekĩ fɔkɛna fɔmɔ bibinya ye anɛ. Ɛkpa be mbuayɛ kĩ, “Ɛkɔa tite fɔnɛwa ekputa yĩ banebi. Ɛfɔ̃ nnavɔlɛ anɛ, ade finyaakĩĩ mpuli mamɔ fɔkɔ a.” ");
INSERT INTO bov_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisifɔ a badi lɛ kĩ, “Oti a kĩ ɛkɛna fukĩĩ táto Baguma sɛkɛ̃, kitonɛkĩ yaákɛna nɛ Kawɛya Luwi mbla a akũ.” Ade babɛbã lɛmɛ via kĩ, “Nde fɔ́aya kĩ tɔkpa ɔkɛnanɛ aapuli ɛkɛna nsɛntsɛlɛni kĩĩ odu?” Nɛ foesũ kasɛ̃ wo nɛ be kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisifɔ a buki bivia onyole a kĩ, “Kĩ ɔlɛ kĩ ye libinya nɔ anɛ a ni, nɔ malo litsa odeĩ kĩ alɛ nɛ ye akũ?” Onyole a kpa be mbuayɛ kĩ, “Baguma onukpɛ̃ ɔnyɛnɛ yanɛ.” ");
INSERT INTO bov_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lɛmɛ Yudafɔ a táwɛ kĩ batɛ bido kĩ onyole a nya tɔ̃ ɔnɛkunɛ fɔmɔ ye anɛ binya, kɛnawo kĩ bɛvɛ ye bamanɛ bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ade bivia be kĩ, “Mi obi a kĩ milɛ kĩ mima ye ɔnɛkunɛ a nɛ awĩ a? Nde fɔya mɔ finyaa kɔ̃ yamɔ fɔkɔ?” ");
INSERT INTO bov_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ye bamanɛ a kpa mbuayɛ kĩ, “Bunyina kĩ boe obi yanɛ, ade bunyina kĩ bɔma ye ɔnɛkunɛ a. ");
INSERT INTO bov_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lɛmɛ ayekĩ fɔkɛna fɔmɔ yamɔ fɔkɔ a ni, bunyína foe kɔ̃, ade bunyína oti a kĩ ye libinya ye anɛ a lɛmɛ a. Mivia ye mɔawɛ a, ebo anɛ, yaapuli ɛnyɛ ye akũ onukpɛ̃.” ");
INSERT INTO bov_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ye bamanɛ lɛ fɔlɛtsa kĩĩ ayekĩ bɛkavila Yudafɔ a sũ. Kitonɛkĩ Yudafɔ banɔkɔɛ̃ a lɛ biyi kɔkɔɛ kĩ ntɛ odi tɛ edo kĩ Yesu nyɛ Kristo a ni, baablɔmɛna ye nɛ Yudafɔ katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ade foesũ ye bamanɛ a lɛ kĩ, “Ebo anɛ, mivia ye mɔawɛ a!” ");
INSERT INTO bov_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Banɔkɔɛ̃ a vɛ onyole a kĩ bɛma ɔnɛkunɛ a lɛyade ade bibi ye kĩ, “Lɛ ɔnɔkɔali a nɛ Baguma anɛ! Bunyina kĩ onyole a kĩ ɛtsa nɔ a nyɛ tɔkpa ɔkɛnanɛ.” ");
INSERT INTO bov_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Onyole a lɛ kĩ, “Ntɛ ɛnyɛ tɔkpa ɔkɛnanɛ o-o, ĩye ɛnyɛ́ tɔkpa ɔkɛnanɛ o-o, ĩnyína. Lɛtsa mɔapɛ kĩ ĩnyina nyɛ kĩ ĩnya tɔ̃ ɔnɛkunɛ, lɛmɛ finyaa mamɔ fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Banɔkɔɛ̃ a via ye kĩ, “Litsa ɛkɛna nɔ? Nde ɛkɛna ebinya nɔ anɛ?” ");
INSERT INTO bov_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɛkpa be mbuayɛ kĩ, “Mbi mi foe kɔkɔɛ lɛmɛ miáwɛ kĩ miatse foe. Nde sũ miawɛ kĩ miabuki mitse foe? Mbɔɛɛ mi malo miawɛ kĩ minya ye fɔtsa bakɔlɛnɛ?” ");
INSERT INTO bov_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bivũna ye bɛlɛ kĩ, “Nɔ odi nyɛ ye fɔtsa ɔkɔlɛnɛ, lɛmɛ boe kɔ̃ Mose fɔtsa bakɔlɛnɛ bɔanɛ. ");
INSERT INTO bov_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bunyina kĩ Baguma bi Mose fɔlɛtsa, lɛmɛ oti a naa kɔ̃ bunyína awã kĩ eto malo!” ");
INSERT INTO bov_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ade onyole a bi be kĩ, “Litsa awãwã fɔlɛtsa a? Minyína awã kĩ eto, lɛmɛ ade ye libinya yĩ anɛ a! ");
INSERT INTO bov_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bunyina kĩ Baguma látse tɔkpa bakɛnanɛ, lɛmɛ yatse bati a kĩ bakpa ye obu, kakɛna nɛ ye yawɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kito anɛ katinya kayɔkayi a, bɔtánu tɔ̃ kĩ odi puli ebinya oti kĩ bɛma ɔnɛkunɛ anɛ. ");
INSERT INTO bov_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ntɛ ɛtato Baguma sɛkɛ̃ ni, kufɛ ɛláapuli ɛkɛna lɛtsama.” ");
INSERT INTO bov_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Banɔkɔɛ̃ a via ye kĩ, “Katsa atsa kĩ nɔ a kĩ bɛma bɛdɔɔla nɛ tɔkpa kamɛ a, nɔ mbom awɛ kĩ atsa boe fɔtsa?” Ade bɛblɔmɛna ye nɛ Yudafɔ katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu nu kĩ bɛblɔmɛna onyole a nɛ be kamɛ, foesũ kĩ ɛmɔ́ onyole a, evia ye kĩ, “Ɔtɛ Otidziwa Obi a odo?” ");
INSERT INTO bov_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Onyole a kpa mbuayɛ kĩ, “Ɔnɔkɔɛ̃, bi yĩ oti a kĩ yanɛ, ayekĩ maapuli ntɛ ye ndo!” ");
INSERT INTO bov_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ade Yesu bi ye kĩ, “Ɔmɔ́ ye kɔkɔɛ, ade ye nyɛ oti a kĩ ɛlamɛna kɔdzɛla kalɛ mɔ nɔ finyaakĩĩ a.” ");
INSERT INTO bov_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Onyole a lɛ kĩ, “Boe Ɔlate, ntɛ ndo!” Ade ke eke aduli nɛ Yesu anɛ a. ");
INSERT INTO bov_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu lɛ kĩ, “Ĩya nɛ katinya kĩĩ kamɛ kĩ mayaadzɛmɔ bati, ayekĩ banɛkunɛ aamɔ fɔkɔ, ade bikĩ bamɔ fɔkɔ a aadani banɛkunɛ.” ");
INSERT INTO bov_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisifɔ a kĩ bɛdzɛ̃ nɛ awã a badi nu lɛtsa a kĩ ɛlɛ a, ade bivia ye kĩ, “Katsa atsa kĩ boe malo banɛkunɛ bɔanɛ mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kpa be mbuayɛ kĩ, “Ntɛ kaku mi anɛ eku ni, kufɛ bɛláakɔ mi kɔtɔ, lɛmɛ kĩ mialɛ kĩ miamɔ fɔkɔ sũ ni, tɔkpa deĩ nɛ mi akũ.” ");
INSERT INTO bov_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu lɛ kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ, oti kĩ ɛtátsã onyukpɛ̃ a ewo nɛ baveli kɔbã kamɛ, mbom ede ɛtsã kɔbã a akũ ewo ni, ɛnyɛ oyekpanɛ mɔ ɔblɔfɔ. ");
INSERT INTO bov_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Oti a kĩ ɛtsã kɔbã onyukpɛ̃ ewo a nyɛ baveli ɔkpãnɛ a. ");
INSERT INTO bov_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ade ye mɔ kɔbã onyukpɛ̃ ɔdzɔlɛnɛ a abinya kakpa ye, ade baveli a anu ye odo a. Yavɛ ye bade a buĩ a kĩ ete be a, kakpã be kanɛmɛna kanya. ");
INSERT INTO bov_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ntɛ ɛkpã be ɛnɛmɛna a, yanya be lɔtɔ, ade baveli a atomɔ ye, kitonɛkĩ binyina ye odo. ");
INSERT INTO bov_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bɛláatomɔ oti bɛbã, mbom baalo nɛ ye sɛkɛ̃, kitonɛkĩ binyína ye odo.” ");
INSERT INTO bov_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu bɔa be lɛgbã kĩĩ, lɛmɛ bɛtánu lɛtsa a kĩ yatsa a kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nɛ foesũ Yesu buki ɛlɛ kĩ, “Mabi mi ɔnɔkɔali a kĩ yĩ nyɛ baveli a kɔbã onyukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bati bɛbã a kĩ bɛnya yĩ lɔtɔ bɛya flee a nyɛ bayekpanɛ mɔ bablɔfɔ, foesũ baveli a tátse be fɔlɛtsa. ");
INSERT INTO bov_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yĩ nyɛ kɔbã onyukpɛ̃ a. Odi nyɛ odi kĩ ɛtsã yĩ akũ ewo ni, yaana katɛ. Yaawo ɛnɛ, ade yaana funitsã kanyakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oyekpanɛ aya kĩ yayaaye, edi awu, ebula fɔtsa kade. Yĩ kɔ̃ ĩya ayekĩ bati aana nkpã kĩ ɛkpɔla nɛ osi nyɛ osi akũ. ");
INSERT INTO bov_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yĩ nyɛ baveli ɔkpãnɛ wĩ a, baveli ɔkpãnɛ wĩ a akɔa ye nkpã kakpa nɛ baveli a lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ntɛ ɔpaani kĩ ɛnyɛ́ baveli ɔkpãnɛ, ade ɛnyɛ́ baveli a ɔlate lɛmɛ mɔ́ kalikii kaya ni, yalo kafɔnɛ baveli a. Foesũ kalikii a apili baveli a kapansam be. ");
INSERT INTO bov_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ɔpaani a alo kadzakũ kitonɛkĩ kabɔɛ bɛbɔɛ ye kĩ ɛkɛna adzuma a, ade ɛtsɛ́la baveli a lɛtsama akũ a. ");
INSERT INTO bov_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Yĩ nyɛ baveli ɔkpãnɛ wĩ a. Ndɛ ayekĩ Nda nyina yĩ, yĩ malo ĩnyina Nda a ni, ade aye ĩnyina yĩ mɔawɛ baveli ade be malo binyina yĩ a. Nkɔa yĩ nkpã nkpa nɛ be lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndeĩ baveli bɛbã kĩ bɛláa baveli kɔbã kĩĩ kamɛ. Kɛnɛ kĩ nkpã be malo ĩyamɛna, bitse yĩ odo lɔkɔa be flee baanya baveli katsu mɔa, bɛna nɛ baveli ɔkpãnɛ mɔa kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nda awɛ yĩ kalɛ, kitonɛkĩ nkɔa yĩ nkpã nkpa, kĩ maabuki ntɛ ye. ");
INSERT INTO bov_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Odima lɛláatɛ ye nɛ yĩ awɛ, mbom yĩ mɔawɛ lɛkɔa ye nkpa. Ndeĩ osi kĩ makɔa ye nkpa, ade ndeĩ osi kĩ mabuki ntɛ ye a. Ade lɛtsa a kĩ Nda do yĩ kĩ kɛnɛ kĩ nkɛna a.” ");
INSERT INTO bov_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nɛ fɔlɛtsa kĩĩ sũ kasɛ̃ buki kiwo nɛ Yudafɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Be pii, bɛkalɛ kĩ, “Hũhũ kpa deĩ nɛ ye kamɛ! Ye lɔlɔ kamɛ bu kade! Nde sũ koũ miatse ye?” ");
INSERT INTO bov_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lɛmɛ babɛbã lɛ kĩ, “Oti kĩ hũhũ kpa deĩ nɛ ye kamɛ lɛláapuli ɛlɛ kɔdzɛla lɔmɔ! Nde koũ hũhũ kpa aapuli ebinya banɛkunɛ anɛ?” ");
INSERT INTO bov_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Osili lɔkɔ wo ɔtɔ, ade Yudafɔ kanya Baguma Asɔli Kɔla Akũ kakpalɛ Luwi nɛ Yerusalem a. ");
INSERT INTO bov_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu kamini nɛ Baguma Asɔli Kɔla a kakɔ a kĩ bavɛ Salomo Ablanda a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ade Yudafɔ a nakpɔta nɛ ye akũ, ade bivia ye kĩ, “Nde sũ ɔfɔ̃ bɔlamɛna anɛ kadã kavia? Ntɛ nɔ nyɛ Kristo a ni, bi boe ɔnɔkɔali a faa.” ");
INSERT INTO bov_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kpa be mbuayɛ kĩ, “Mbi mi kɔkɔɛ, lɛmɛ miátɛ yĩ mido. Fɔtsa a kĩ makɛna nɛ Nda kɔbɛ̃ akũ a, adi yĩ akũ adansiɛ. ");
INSERT INTO bov_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lɛmɛ miátɛ kado kitonɛkĩ minyɛ́ yĩ baveli. ");
INSERT INTO bov_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yĩ baveli atse yĩ ɔlɛdo, ĩnyina be ade batomɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Makpa be nkpã kĩ ɛlá kawũna a, ade bɛláaku bɛwɔ da. Odima lɛláapuli ɛwãnɛ be ɛtɛ nɛ yĩ awɛ. ");
INSERT INTO bov_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Fɔtsa a kĩ Nda kɔa edo nɛ yĩ awɛ a deĩ kɔbɛ̃ fɔbɛ̃ lɛtsa nyɛ lɛtsa, ade odima lɛláapuli ɛwãnɛ foe ɛtɛ nɛ Nda awɛ a. ");
INSERT INTO bov_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bɔmɔ́ Nda ni, ɔmɔa bɔanɛ.” ");
INSERT INTO bov_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Foesũ Yudafɔ a buki bifila boe kĩ batalɛ Yesu. ");
INSERT INTO bov_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ade Yesu bi be kĩ, “Nkɛna fɔtsa wĩ pii kĩ Nda do yĩ kĩ nkɛna nɛ mi anɛ. Foe kamɛ fɔɔdabe sũ miawɛ kĩ miatalɛ yĩ boe?” ");
INSERT INTO bov_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bɛkpa mbuayɛ kĩ, “Nnɛ́ fɔtsa wĩ a kĩ ɔkɛna a sũ bɔawɛ kĩ bɔatalɛ nɔ boe, mbom nɛ mbusuo fɔlɛtsa a kĩ ɔlɛ a sũ! Otidziwa kɛkɛ anɛ, lɛmɛ awɛ kĩ akɛna nɔ akũ Baguma!” ");
INSERT INTO bov_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kpa be mbuayɛ kĩ, “Bɛtsɛlɛ nɛ mi mbla ovoli a kamɛ kĩ Baguma lɛ kĩ, ‘Minyɛ baguma amɛ.’ ");
INSERT INTO bov_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bunyina kĩ lɛtsa a kĩ Katsɛlɛ Kpalɛwa lɛ a nyɛ ɔnɔkɔali daa. Baguma vɛ bati a kĩ ɛkpa be ye ɔlɛdo a kĩ baguma amɛ. ");
INSERT INTO bov_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yĩ kɔ̃, Ɔlɛga a lɛpau yĩ edo yĩ nɛ katinya kamɛ. Lɔkɔa nde sũ miti mialɛ kĩ nlɛ fubusuotsa nɛ ayekĩ nlɛ kĩ Baguma Obi manɛ a sũ? ");
INSERT INTO bov_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Foesũ ntɛ nlámɛna fɔtsa a kĩ Nda do yĩ kĩ nkɛna a kakɛna ni, mitatɛ yĩ mido. ");
INSERT INTO bov_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lɛmɛ ntɛ makɛna foe, titɔ kĩ miátɛ yĩ kado malo ni, mitɛ fɔtsa a kĩ makɛna a mido, ayekĩ míanyi, minu foe kayɔ yededeede kĩ Ɔlɛga a deĩ nɛ yĩ kamɛ ade yĩ malo ndeĩ nɛ Ɔlɛga a kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yudafɔ a buki bɛwɛ kĩ bapi Yesu, lɛmɛ ɛnɛ́ nɛ be kamɛ ɛdzakũ. ");
INSERT INTO bov_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ade Yesu muniki enyina Yordan Ɔwɔ a ɛnaa awã kĩ Yohanes wɔla bati mui tɔ̃ a, ɛnadzi nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bati pii ya nɛ ye sɛkɛ̃, ade bɛlɛ kĩ, “Yohanes tákɛna awãwã fɔtsa fudima, lɛmɛ fɔlɛtsa a kĩ ɛlɛ nɛ oti kĩĩ akũ a flee nyɛ ɔnɔkɔali.” ");
INSERT INTO bov_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bati pii nɛ awã tɛ ye bido. ");
INSERT INTO bov_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Onyole odi kĩ bavɛ Lazaro kasɔ. Eto Betania, ɔmatɔ a kĩ bawaɛ̃tsole nviã Maria mɔ Marta dzi a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ade Maria kĩĩ lɛkɔa kugua mɔ ɔlɛ̃ eko nɛ boe Ɔlate fɔnɛta, ɛkɔa ye lɔlɔ tɔlɔ ɛyɔ foe a. Ye ɔwaɛ̃nyole nyɛ Lazaro kĩ yasɔ a. ");
INSERT INTO bov_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bawaɛ̃tsole a do lɔtɔ nɛ Yesu sɛkɛ̃ kĩ, “Boe Ɔlate, nɔ ɔkɔba a kĩ aátunɔ ye kalɛ a asɔ.” ");
INSERT INTO bov_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kĩ Yesu nu fɔlɛtsa kĩĩ a, ɛlɛ kĩ, “Fɔsɔ kĩĩ lɛnyɛ wuda fɔsɔ, mbom fɔnyɛ lɛtsa a kĩ baatsã foe akũ bɛdɛla Baguma dĩ nɛ ode, ade baadɛla Baguma Obi a lɛmɛ dĩ nɛ ode a.” ");
INSERT INTO bov_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu awɛ Marta, mɔ ɔwaɛ̃tsole mɔ Lazaro kalɛ. ");
INSERT INTO bov_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lɛmɛ kĩ Yesu nu Lazaro fɔsɔ a, ebuki ɛkahɔ nɛ awã kĩ edeĩ a fuwi nviã. ");
INSERT INTO bov_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ke liti a, ebi ye fɔtsa bakɔlɛnɛ a kĩ, “Mifɔ̃ bumuniki bɔnaa Yudea.” ");
INSERT INTO bov_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ade ye fɔtsa bakɔlɛnɛ a bi ye kĩ, “Fɔtsa ɔtsanɛ, wádzɔ nɛ awĩ mɔ Yudafɔ a wɛ kĩ batalɛ nɔ boe, mɔ obuki anaa awã a?” ");
INSERT INTO bov_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kpa be mbuayɛ kĩ, “Nnɛ́ dɔũhuilɛ ewua-nviã deĩ nɛ kade kanyina kamɛ? Odi nyɛ odi kĩ ɛtsɛ̃ nɛ suwa ni, ɛláatula kitonɛkĩ katinya kamɛ ɔhaĩ a afɔ̃ yamɔ fɔkɔ. ");
INSERT INTO bov_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lɛmɛ ntɛ odi tsɛ̃ nɛ lɛnyɛ ni, yatula kitonɛkĩ ɔhaĩ lɛláa.” ");
INSERT INTO bov_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, ebuki ɛlɛ kĩ, “Boe ɔkɔba Lazaro wa tida, lɛmɛ maanaadzɛla ye.” ");
INSERT INTO bov_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ye fɔtsa bakɔlɛnɛ a kpa mbuayɛ kĩ, “Boe Ɔlate, ntɛ tida ɛwaa kɔ̃ ni, yaasaɛ.” ");
INSERT INTO bov_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lɛtsa a kĩ Yesu atsa a nyɛ kĩ Lazaro ku, lɛmɛ ye fɔtsa bakɔlɛnɛ a kɔ̃ kɔna kĩ tida pupulidza kawa ɛlɛ. ");
INSERT INTO bov_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Foesũ Yesu binya ebi be pefee kĩ, “Lazaro ku. ");
INSERT INTO bov_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lɛmɛ nɛ mi sũ ni, kawɔlɛ de yĩ kĩ ntána nɛ awã ayekĩ míatɛ mido. Mifɔ̃ bɔnaa ye sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ade Toma kĩ bavɛ Ata a bi ye bakɔba fɔtsa bakɔlɛnɛ a kĩ, “Mifɔ̃ boe malo butomɔ Fɔtsa Ɔtsanɛ a bɔnaa, bɔnaaku mɔ ye!” ");
INSERT INTO bov_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kĩ Yesu wo awã a, ɛmɔ́ kĩ fɔtɛ fuwi ɛna kĩ bibila Lazaro. ");
INSERT INTO bov_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kito Betania kɛnaa Yerusalem aana ndɛ fusikũ nviã, ");
INSERT INTO bov_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ade Yudafɔ pii ya kĩ bayaadzam Maria mɔ Marta nɛ be ɔwaɛ̃nyole wuda a sũ. ");
INSERT INTO bov_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kĩ Marta nu kĩ Yesu aya a, ɛnɛ́ ɛnaatsɛlamɔ ye, lɛmɛ Maria kɔ̃ kahɔ nɛ tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ade Marta bi Yesu kĩ, “Boe Ɔlate, ntɛ kana ɔna nɛ awĩ kufɛ nwaɛ̃nyole táku! ");
INSERT INTO bov_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lɛmɛ ĩnyina kĩ finyaa malo Baguma aakpa nɔ lɛtsa nyɛ lɛtsa kĩ ovia ye.” ");
INSERT INTO bov_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kpa ye mbuayɛ kĩ, “Awaɛ̃nyole a aabuki eyidza edzi nkpã.” ");
INSERT INTO bov_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ade Marta bi ye kĩ, “Ĩnyina kĩ yaabuki eyidza edzi nkpã nɛ Luwi Nkaɛ a kĩ banɔkpa aayidza a akũ.” ");
INSERT INTO bov_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu bi ye kĩ, “Yĩ nyɛ kayidza kadzi nkpã mɔ nkpã a. Odi nyɛ odi kĩ ɛtɛ yĩ edo, ntɛ eku malo ni, yaayidza edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Odi nyɛ odi kĩ edzi nkpã mɔ́ ɛtɛ yĩ edo ni, ɛláaku da. Ɔtɛ fukĩĩ odo?” ");
INSERT INTO bov_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta kpa ye mbuayɛ kĩ, “Oo, boe Ɔlate! Ntɛ ndo kĩ nɔ nyɛ Kristo a, Baguma Obi a kĩ bɛlɛ biyi kĩ yaaya nɛ katinya kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kĩ Marta lɛ fukĩĩ eyua a, emuniki ɛnaa kɔla ɛnavɛ ɔwaɛ̃tsole Maria pɛtɛɛ. Ebi ye kĩ, “Fɔtsa Ɔtsanɛ a ya nɛ awĩ, ade evia nɔ akũ a.” ");
INSERT INTO bov_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kĩ Maria nu foe pɛ, ɛta eyidza ewula atsɛ ɛnaatsɛlamɔ ye. ");
INSERT INTO bov_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nɛ lɔkɔ a naa Yesu táwo tɔ̃ ɔmatɔ a kamɛ, mbom ebuki ɛdzɛ̃ nɛ awã kĩ Marta yatsɛlamɔ ye a. ");
INSERT INTO bov_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kĩ bati a kĩ bideĩ nɛ tɔtɔ kamɛ bɛkadzam Maria a mɔ́ kĩ ɛta eyidza ɛnɛ a, bitomɔ ye, kitonɛkĩ bɛkɔna kĩ yanaa linikɛ a ɔwɛ̃ ɛnaabe. ");
INSERT INTO bov_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria yawo awã kĩ Yesu dzɛ̃ a, ade kĩ esila ɛmɔ́ ye pɛ ɛtɔ nɛ Yesu abɔa kamɛ ɛlɛ kĩ, “Boe Ɔlate, ntɛ ɔna nɛ awĩ kufɛ nwaɛ̃nyole a táku.” ");
INSERT INTO bov_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kĩ Yesu mɔ́ ayekĩ ɛkabe, mɔ ayekĩ bati a kĩ bitomɔ ye kabe a, fɔkɛna adzuma nɛ ye kamɛ ade ɛwɛya eke hũũ a. ");
INSERT INTO bov_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Evia be kĩ, “Nɛ ndia mibila ye?” Bɛkpa ye mbuayɛ kĩ, “Boe Ɔlate, yaadã.” ");
INSERT INTO bov_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nɛ awã naa, Yesu be. ");
INSERT INTO bov_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ade Yudafɔ a lɛ kĩ, “Midã tɔ̃ ayekĩ yawɛ ye kalɛ!” ");
INSERT INTO bov_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lɛmɛ badi lɛ kĩ, “Ebinya ɔnɛkunɛ anɛ. Kapuli ɛláapuli ɛfɔ̃ kĩ onyole kĩĩ ɛtaku?” ");
INSERT INTO bov_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kalɔɛ a buki kɛna nɛ Yesu kamɛ ade ɛnaa linikɛ a ɔwɛ̃ a. Linikɛ a nyɛ de ɔkɛ kĩ bɛkɔa de bisua de onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu bi be kĩ, “Mibɔɛ de a nɛ lɛkɛ a onukpɛ̃.” Ade Marta, ɔnɔkpa a ɔwaɛ̃tsole, bi Yesu kĩ, “Boe Ɔlate, finyaa kɔ̃ edo kakũ awɛ, kitonɛkĩ ade fuwi ɛna kĩ bibila ye a.” ");
INSERT INTO bov_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu bi Marta kĩ, “Mbɔɛɛ ntábi nɔ kĩ ntɛ ɔtɛ odo ni, aamɔ Baguma kukũkpalɛ a?” ");
INSERT INTO bov_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bati a bɔɛ de a bɛnyɛ. Yesu dɛla anɛ nɛ ode ɛlɛ kĩ, “Nda, manyɛ nɔ kɔlɛ kĩ atse yĩ. ");
INSERT INTO bov_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ĩnyina kĩ atse yĩ daa, lɛmɛ bikĩ bɛdzɛ̃ nɛ awĩ a sũ malɛ fukĩĩ, ayekĩ baatɛ bido kĩ nɔ lido yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kĩ ɛlɛ fukĩĩ eyua a, ɛbɔa fɔwɔla kɔɔba kĩ, “Lazaro, nɛ́ kaya!” ");
INSERT INTO bov_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ade ɔnɔkpa a nɛ́ ɛya a. Lima a kĩ bɛkɔa bisuli ye akpɔ mɔ abɔa a buki lɛna nɛ ye akũ, ade duku a kĩ bɛkɔa bisuli ye anɛ a lɛmɛ na nɛ ye akũ a. Yesu bi be kĩ, “Miwũnya tilima a nɛ ye akũ mifɔ̃ ɛnaa.” ");
INSERT INTO bov_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yudafɔ a kĩ bɛya nɛ Maria sɛkɛ̃ mɔ́ lɛtsa a kĩ Yesu kɛna a, ade be pii tɛ ye bido a. ");
INSERT INTO bov_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lɛmɛ be kamɛ badi muniki bɛnaa Farisifɔ a sɛkɛ̃ bɛnabi be lɛtsa a kĩ Yesu kɛna a. ");
INSERT INTO bov_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Foesũ Farisifɔ a mɔ basɔfɔnɔkɔɛ̃ a natsa fɔlɔ mɔ Yudafɔ ɔmaĩ banɔkɔɛ̃ a ade bɛlɛ kĩ, “Litsa bɔ́akɛna? Kitonɛkĩ oti kĩĩ lamɛna awãwã fɔtsa pii kakɛna! ");
INSERT INTO bov_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ntɛ bɔkpa ye osi lɔmɔ ni, odi nyɛ odi aayatɛ ye edo, ade Roma abãã ayabubuli boe Asɔli Kɔla a, ɛwɔla boe ɔmaĩ lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Be kamɛ ɔmɔa kĩ bavɛ Kaiafa, kĩ ɛnyɛ Ɔsɔfɔnɔkɔɛ̃ Flee nɛ kateli a na kamɛ a bi be kĩ, “Minyína lɛtsama kɔlaa! ");
INSERT INTO bov_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Minyína kĩ fɔnɛnɛ fɔkpa mi kĩ oti mɔa aaku nɛ bati a flee lɔlɔ kɛba kĩ baawɔla ɔmaĩ a flee a?” ");
INSERT INTO bov_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nnɛ́ ye mɔawɛ kakɔna ɛkɔa ɛlɛ fukĩĩ, mbom ndɛ Ɔsɔfɔnɔkɔɛ̃ Flee nɛ kateli a kamɛ ni, ɛlɛ eyi kĩ Yesu aaku nɛ Yudafɔ a lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nnɛ́ Yudafɔ a odi yaku ɛkpa, mbom kĩ yaakpɔta Baguma bade a kĩ bɛgba biko nɛ katinya kamɛ a bɛkɛna ɔmɔa. ");
INSERT INTO bov_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kito luwi a kanaa a, Yudafɔ banɔkɔɛ̃ kapi adzuni kĩ baakɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nɛ foesũ Yesu tábuki ɛkanɛ kanya Yudafɔ a lɛmɔ ye. Ɛdzakũ ɛnaa ɔmatɔ odi kĩ bavɛ Efrayim kamɛ nɛ kɔsa kudi kamɛ, ade awã bɛmɔ ye fɔtsa bakɔlɛnɛ a bidzi nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Finyaa Yudafɔ Wuda Katɛ̃ luwi kanya a fuã, ade bati pii to ɔmaĩ a fɔkɔ kumɛkumɛ bɛya nɛ Yerusalem, kĩ bayaakpalɛ be akũ fɔmɔ luwi a aawo ɔtɔ. ");
INSERT INTO bov_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kĩ bɛna nɛ Asɔli Kɔla kamɛ a, bɛkawɛ Yesu, ade bɛkavia akũ kĩ, “Nde akɔna? Mbɔɛɛ ɛláaya nɛ luwi a kanyakɔ̃?” ");
INSERT INTO bov_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nɛ lɔkɔ a na kamɛ a, basɔfɔnɔkɔɛ̃ mɔ Farisifɔ a si mbla kĩ odi nyɛ odi kĩ enyina awã kĩ Yesu deĩ ni, kɛnɛ kĩ ɛyaakpa kanyi lɔkɔa bɛnaapi ye. ");
INSERT INTO bov_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kĩ kite fuwi evũ kĩ banya Wuda Katɛ̃ Luwi a, Yesu naa Betania, Lazaro ɔtɔ, awã kĩ ɛdzɛla ye etomɛna kanɔkpa a. ");
INSERT INTO bov_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bɛtɔ olobe funitsã bɛkpa ye nɛ awã. Marta sum nɛ opunu akũ, ade Lazaro lɛmɛ na nɛ bati a kĩ bidzi bɛkanya mɔ Yesu a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ade Maria bɔɛ kugua mɔ ɔlɛ̃ baũ, kĩ bavɛ koe nard, kĩ kudeĩ kɔya paa lita sɛkɛ ɛyatsɛla Yesu fɔnɛta, ade ɛkɔa ye lɔlɔ tɔlɔ ɛyɔ foe akũ a. Kugua a ɔlɛ̃ tɛ tɔtɔ a flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ye fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa, Yuda Iskariot, kĩ ye aanyɛ Yesu ɛkpa a lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nde sũ bɛtánɔ kugua kĩĩ sika ovoe ɔha ɛlalɛ lɔkɔa bɛkɔa sɛ bɛkpa ahiãfɔ?” ");
INSERT INTO bov_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nnɛ́ kĩ ɛtsɛla ahiãfɔ akũ sũ ɛlɛ fukĩĩ, mbom oyekpanɛ yanɛ. Ye nɛɛ sika kuvũ a ade yado awɛ nɛ koe kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ade Yesu lɛ kĩ, “Mifɔnɛ ye awɛ! Mifɔ̃ ɛmanɛ koe eyi ɛkpa yĩ kabila. ");
INSERT INTO bov_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ahiãfɔ deĩ nɛ mi kamɛ luwi nyɛ luwi, lɛmɛ yĩ kɔ̃ nláana nɛ mi kamɛ daa.” ");
INSERT INTO bov_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yudafɔ pii nu kĩ Yesu deĩ nɛ Betania, foesũ bɛya nɛ awã. Nnɛ́ Yesu odi sũ bɛya, mbom kĩ bayaadã Lazaro a kĩ Yesu dzɛla etomɛna kanɔkpa a. ");
INSERT INTO bov_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nɛ foesũ basɔfɔnɔkɔɛ̃ a pi adzuni kĩ baakɔ Lazaro lɛmɛ, ");
INSERT INTO bov_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kitonɛkĩ ye sũ Yudafɔ a pii kasĩ be kanaatɛ Yesu kado. ");
INSERT INTO bov_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kĩ kade nyina a, bati kɔdabu a kĩ bɛya nɛ Wuda Katɛ̃ Luwi kanyakɔ̃ a nu kĩ Yesu aya nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Foesũ bɛbɔɛ tuko bɛnɛ kĩ banaatsɛlamɔ ye, ade bɛkabɔa fɔwɔla kĩ, “Mimu Baguma! Baguma hila oti a kĩ yaya nɛ boe Ɔlate dĩ akũ a! Baguma hila Israel Lɛgã a!” ");
INSERT INTO bov_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu mɔ́ aflimu adi, ade ede edzi nɛ ye akũ ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion ɔmatɔ, tavila! Amɔ nɔ Lɛgã kĩ laya! Edzi nɛ aflimu obi akũ.” ");
INSERT INTO bov_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ye fɔtsa bakɔlɛnɛ a tánu fukĩĩ kayɔ nɛ lɔkɔ a na kamɛ, lɛmɛ kĩ Baguma dzɛla Yesu ɛkpalɛ ye akũ a, bɛyate anɛ kĩ Katsɛlɛ Kpalɛwa a lɛ lɛtsa a kĩ bɛkɛna bɛkpa ye a nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bati a kĩ bɛna nɛ Yesu sɛkɛ̃, nɛ lɔkɔ a kĩ ɛvɛ Lazaro etomɛna linikɛ kamɛ edzi nkpã a, di adansiɛ nɛ lɛtsa a kĩ lɛya a akũ. ");
INSERT INTO bov_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ade fukĩĩ sũ bati kɔdabu a natsɛlɛmɔ Yesu a, kitonɛkĩ binu kĩ ɛkɛna awãwã fɔtsa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Foesũ Farisifɔ a bi akũ kĩ, “Midã kĩ bɔlámɔ kadzakɔ̃ kana kɔlaa. Midã, katinya kamɛ bati a flee nɛ́ bitomɔ ye!” ");
INSERT INTO bov_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Helafɔ badi na nɛ bati a kĩ bɛnaa Yerusalem kĩ baasum Baguma nɛ luwi a kanya kamɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ade bɛnaa Filipo, kĩ eto Betsaida a nɛ Galilea sɛkɛ̃, ade bibi ye kĩ, “Ɔnɔkɔɛ̃, bɔawɛ kĩ bɔamɔ Yesu.” ");
INSERT INTO bov_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo nabi Andrea, ade be nviã a bɛnabi Yesu a. ");
INSERT INTO bov_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ade Yesu bi be kĩ, “Finyaa kɔ̃ lɔkɔ a wo ɔtɔ kĩ baadɛla Otidziwa Obi a nɛ ode. ");
INSERT INTO bov_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ntɛ ligbanɔbi táwo nɛ tite kamɛ lɛvɔ̃ ni, libi mɔapɛ keĩ a lanɛ, lɛmɛ ntɛ lɛvɔ̃ ni, lado babi beblebee. ");
INSERT INTO bov_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Odi nyɛ odi kĩ yawɛ ye nkpã kalɛ ni, yaayɛla ye, lɛmɛ odi nyɛ odi kĩ ekesĩ ye nkpã nɛ katinya kĩĩ kamɛ ni, ɛkɔla ye ɛkpa nkpã kĩ ɛla kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Odi nyɛ odi kĩ yawɛ kĩ yasum yĩ ni, kɛnɛ kĩ etomɔ yĩ, kitonɛkĩ awã kĩ ndeĩ a, ade awã yĩ ɔsumunɛ lɛmɛ ana a. Ade Nda aado obu nɛ odi nyɛ odi kĩ yasum yĩ akũ. ");
INSERT INTO bov_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Yĩ ɔwɔlɛ aha yĩ finyaa. Lɛmɛ litsa maalɛ? Kalɛ maalɛ kĩ, ‘Nda, nyɛ yĩ katomɛna lubo kamɔ lɔkɔ kĩĩ kamɛ mbɔɛɛ’? Oowo, ade foesũ ĩya nɛ katinya kamɛ a, ayekĩ maatsã lubo kamɔ lɔkɔ kĩĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nda, do nɔ dĩ akũ obu.” Adeke odo odi to ode ɛlɛ kĩ, “Ndo de obu kɔkɔɛ, ade maabuki ndo de a.” ");
INSERT INTO bov_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bati kɔdabu a kĩ bɛdzɛ̃ nɛ awã nu odo a, ade be kamɛ badi lɛ kĩ, ɔplala lɛnyɛ onukpɛ̃, lɛmɛ badi lɛ kĩ, “Ode fɔtɔ ɔnyanɛ odi lɛlɛ kɔdzɛla mɔ ye!” ");
INSERT INTO bov_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lɛmɛ Yesu bi be kĩ, “Nnɛ́ yĩ sũ odo a lɛ́ kɔdzɛla, mbom mi sũ. ");
INSERT INTO bov_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Finyaa nyɛ lɔkɔ a kĩ Baguma aadzɛmɔ katinya kamɛ. Finyaa mɔ baablɔmɛna katinya kĩĩ kamɛ akũ ɔnyanɛ a. ");
INSERT INTO bov_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ntɛ bɛdɛla yĩ nɛ ode nɛ asendua akũ ni, maavɛlɛ bati flee ĩyamɛna nɛ yĩ sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu lɛ fukĩĩ yakɔa ɛtsa wuda odu a kĩ yaaku. ");
INSERT INTO bov_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Adeke bati kɔdabu a kpa ye mbuayɛ kĩ, “Boe Mbla Ovoli a atsa boe kĩ Kristo a aadzi nkpã daa. Nde fɔya mɔ alɛ kĩ baadɛla Otidziwa Obi a nɛ ode nɛ asendua akũ? Owei nyɛ Otidziwa Obi kĩĩ a?” ");
INSERT INTO bov_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu kpa be mbuayɛ kĩ, “Ɔhaĩ a aabuki ɛna nɛ mi sɛkɛ̃ lɔkɔ lukũ lidi pɛ. Lɔkɔ kĩ ɔhaĩ a deĩ nɛ mi kamɛ ni, mitsã nɛ ye kamɛ ayekĩ ɔtũ lɛláake edo mi, kitonɛkĩ oti kĩ ɛtsɛ̃ nɛ ɔtũ kamɛ linyína awã kĩ yanaa. ");
INSERT INTO bov_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kĩ ɔhaĩ a deĩ nɛ mi sɛkɛ̃ kĩĩ ni, mitɛ ɔhaĩ mido ayekĩ míakɛna ɔhaĩ a kamɛ bati.” Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, ɛdzakũ nɛ be sɛkɛ̃ ɛnabɛla. ");
INSERT INTO bov_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Titɔ kĩ Yesu kɛna awãwã fɔtsa kĩĩ flee nɛ be anɛ kamɛ malo ni, bɛtátɛ ye bido. ");
INSERT INTO bov_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ayekĩ lɛtsa a kĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya lɛ eyi a, aaya nɛ foe kamɛ kĩ, “Boe Ɔlate, owei lɛtɛ nɔ fɔlɛtsa a kĩ bɔlɛ a edo? Owei ɛnyɛ ye kɔbɛ̃ ɛtsa?” ");
INSERT INTO bov_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nɛ foesũ bɛtápuli bɛtɛ bido, kitonɛkĩ Yesaya buki ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Baguma kɔ be anɛ ade esua be adzuni ayekĩ be anɛ lɛláamɔ fɔkɔ, ade be adzuni lɛláanu fɔlɛtsa kayɔ a. Baguma lɛ kĩ, ‘Bɛláamuniki bɛya nɛ yĩ sɛkɛ̃ lɔkɔa ntsa be.’ ” ");
INSERT INTO bov_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya lɛ fɔlɛtsa kĩĩ kitonɛkĩ ɛmɔ́ Yesu kukũkpalɛ a, ade ɛlɛ kalɛ nɛ foe akũ eyi a. ");
INSERT INTO bov_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Titɔ kĩ fɔla lɔmɔ malo a, Yudafɔ banɔkɔɛ̃ a pii tɛ Yesu bido, lɛmɛ nɛ Farisifɔ a sũ bɛtálɛ foe akũ kɔdzɛla nɛ kanade, ayekĩ bɛláablɔmɛna be nɛ be katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kitonɛkĩ bawɛ kĩ batidziwa bimu be kɛba kĩ Baguma aamu be. ");
INSERT INTO bov_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ade Yesu bɔa fɔwɔla ɛlɛ kĩ, “Odi nyɛ odi kĩ ɛtɛ yĩ edo ni, nnɛ́ yĩ odi ɛtɛ edo, mbom mɔ oti a kĩ edo yĩ a ɛtɛ edo. ");
INSERT INTO bov_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Odi nyɛ odi kĩ yamɔ yĩ ni, yamɔ oti a kĩ edo yĩ a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ĩya nɛ katinya kamɛ ndɛ ɔhaĩ aye, ayekĩ odi nyɛ odi kĩ ɛtɛ yĩ edo ni, ɛláana nɛ ɔtũ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ntɛ odi nu yĩ fɔlɛtsa a mɔ́ ɛtákɛna nɛ foe akũ ni, nláadzɛmɔ ye. Ntáya kĩ mayaadzɛmɔ katinya kamɛ bati, mbom ĩya kĩ mayaanyɛ be. ");
INSERT INTO bov_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Oti a kĩ esĩ yĩ, kĩ ɛtátɛ yĩ fɔlɛtsa a deĩ oti kĩ yaadzɛmɔ ye. Fɔlɛtsa a kĩ nlɛ a aadzɛmɔ ye nɛ luwi nkaɛ a akũ! ");
INSERT INTO bov_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Fukĩĩ nyɛ ɔnɔkɔali, kitonɛkĩ ntálɛ kɔdzɛla nɛ yĩ mɔawɛ otumi akũ, mbom Nda a kĩ edo yĩ a lɛkpa yĩ otumi kĩ nlɛ kɔdzɛla, nlɛ fɔlɛtsa a kĩ nlɛ a. ");
INSERT INTO bov_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ade ĩnyina kĩ ye mbla a akpa nkpã kĩ ɛlá kawũna a. Nɛ foesũ fɔlɛtsa a kĩ malɛ a nyɛ fɔlɛtsa kĩ Nda bi yĩ kĩ nlɛ.” ");
INSERT INTO bov_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Luwi a kĩ lɛnyaa Wuda Katɛ̃ Luwi lɔtɔ a, Yesu nyi kĩ lɔkɔ kpɔla ye kĩ yaadzakũ nɛ katinya kĩĩ kamɛ ɛnaa Ɔlɛga sɛkɛ̃. Ɛwɛ bikĩ bɛnyɛ ye bade nɛ katinya kamɛ a kalɛ, ade ɛwɛ be kalɛ kɛnawo kawũnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu mɔ ye fɔtsa bakɔlɛnɛ a dzi nɛ opunu akũ bɛkanya olobe funitsã. Abonsam kɔa edo nɛ Yuda kĩ ɛnyɛ Simon Iskariot obi a adzuni kamɛ kɔkɔɛ kĩ ɛnyɛ Yesu ɛkpa. ");
INSERT INTO bov_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nyina kĩ Ɔlɛga kpa ye kɔbɛ̃ flee. Enyina kĩ Baguma sɛkɛ̃ eto ɛya, ade Baguma sɛkɛ̃ yaabuki ɛnaa a. ");
INSERT INTO bov_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Foesũ eyidza nɛ opunu a akũ, ɛnyɛ ye atadiɛ wulaa eyi nɛ ɔɔwɛ̃, ade ɛkɔa ɔsa efili nɛ kate a. ");
INSERT INTO bov_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ke liti a, eko mui nɛ lɔɔda kamɛ, eyi ye fɔtsa bakɔlɛnɛ a abɔa kavɔlɛ kayɔ, ade ɛkɔa ɔsa a kĩ efili nɛ kate a ɛyɔ mui a. ");
INSERT INTO bov_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kĩ ewo Petro sɛkɛ̃ a, Petro bi ye kĩ, “Boe Ɔlate, ayaavɔlɛ yĩ abɔa?” ");
INSERT INTO bov_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kpa ye mbuayɛ kĩ, “Finyaa ɔláanu lɛtsa a kĩ makɛna a kayɔ, lɛmɛ ke liti aanu foe kayɔ.” ");
INSERT INTO bov_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro bi ye kĩ, “Owoo, ɔláavɔlɛ yĩ abɔa da.” Ade Yesu bi ye kĩ, “Ntɛ ntávɔlɛ nɔ abɔa ni, ke kɔ̃ ɔláabuki ɔnya yĩ fɔtsa ɔkɔlɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Petro kpa ye mbuayɛ kĩ, “Boe Ɔlate, ntɛ aye kɔ̃ ni, tavɔlɛ yĩ abɔa odi, mbom vɔlɛ yĩ awɛ mɔ lɔlɔ lɛmɛ!” ");
INSERT INTO bov_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu bi ye kĩ, “Oti kĩ ewo mui ɛnɛ́ yededeede tábuki esĩ ɛkpa mui kawo, kɛba abɔa odi kavɔlɛ. Mi kɔ̃ mi flee akũ nɛ́, mbɔɛntɛ oti mɔapɛ.” ");
INSERT INTO bov_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nyina oti a kĩ yaanyɛ ye ɛkpa a kɔkɔɛ, ade foesũ ɛlɛ kĩ, “Mi a flee akũ nɛ́, mbɔɛntɛ oti mɔapɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kĩ Yesu vɔlɛ ye fɔtsa bakɔlɛnɛ a abɔa eyua a, ɛbɔɛ ye atadiɛ wulaa a edo, emuniki ɛnadzi nɛ ye kadzikɔ̃ nɛ opunu akũ. Evia ye fɔtsa bakɔlɛnɛ a kĩ, “Minu lɛtsa a kĩ nkɛna nkpa mi a finyaa kayɔ mbɔɛɛ? ");
INSERT INTO bov_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Miavɛ yĩ kĩ Fɔtsa Ɔtsanɛ mɔ Ɔlate. Ade aye fɔla pɛpɛɛpɛ a, kitonɛkĩ ade lɛtsa a kĩ manɛ a. ");
INSERT INTO bov_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yĩ a kĩ ĩnyɛ mi Ɔlate mɔ Fɔtsa Ɔtsanɛ a, lɛvɔlɛ mi abɔa finyaa, foesũ kɛnɛ kĩ miavɔlɛ akũ akũ abɔa. ");
INSERT INTO bov_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nfantuhũ fɔanɛ nkpa mi kĩ mi malo mikɛna lɛtsa mɔapɛ a kĩ nkɛna nkpa mi a. ");
INSERT INTO bov_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ ɔsumunɛ lɛbɛ́ ye ɔlate, ade ayea fɔtɔ ɔnyanɛ lɛbɛ́ oti a kĩ edo ye fɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Finyaa, kĩ minyi ɔnɔkɔali kĩĩ a, Baguma aahila mi ntɛ mikɛna nɛ ke akũ. ");
INSERT INTO bov_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nnɛ́ mi flee malɛ, ĩnyina bati a kĩ mpau a. Lɛmɛ kɛnɛ kĩ Baguma fɔlɛtsa a kĩ bɛtsɛlɛ biyi a fɔya nɛ foe kamɛ kĩ, ‘Oti a kĩ bɔmɔ ye budo awɛ bɔanya a yidza ɛdza nɛ yĩ akũ.’ ");
INSERT INTO bov_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Mabi mi fukĩĩ ĩyi finyaa, fɔmɔ fɔ́aya nɛ foe kamɛ lɔkɔa míatɛ mido kĩ yĩ nyɛ oti a kĩ ye manɛ a. ");
INSERT INTO bov_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi kĩ ɛtɛ oti odi kĩ ndo fɔtɔ ni, yĩ ɛtɛ. Ade odi nyɛ odi kĩ ɛtɛ yĩ ni, ɛtɛ oti a kĩ edo yĩ a.” ");
INSERT INTO bov_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, fɔha ye ɔwɔlɛ paa ade ɛlɛ yededeede kĩ, “Mabi mi nɛ ɔnɔkɔali kamɛ kĩ mi kamɛ odi aanyɛ yĩ ɛkpa.” ");
INSERT INTO bov_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Awã naa, ye fɔtsa bakɔlɛnɛ a dã akũ anɛ, ade bɛkɛna saa kitonɛkĩ binyína be kamɛ oti a kĩ Yesu alɛ a. ");
INSERT INTO bov_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa kĩ Yesu awɛ kalɛ a dzi ɛmɛnamɔ Yesu. ");
INSERT INTO bov_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Adeke Simon Petro baa ye sɛnɛ kĩ, “Via ye owula a kĩ yalɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Foesũ fɔtsa ɔkɔlɛnɛ a fuã Yesu tsɛmɛtsɛmɛ evia ye kĩ, “Boe Ɔlate, owei yanɛ?” ");
INSERT INTO bov_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kpa mbuayɛ kĩ, “Oti a kĩ maabuli abodoo ntamɔ kutu nkpa a ni, ade ye a.” Ade ebuli abodoo sɛkɛ̃, ɛta kutu ɛkɔa ɛkpa Yuda kĩ ɛnyɛ Simon Iskariot obi a. ");
INSERT INTO bov_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kĩ Yuda sila ɛtɛ funitsã a pɛ, Satana wo nɛ ye kamɛ. Ade Yesu bi ye kĩ, “Wɛ sɔwa nɛ lɛtsa a kĩ awɛ kĩ akɛna a akũ.” ");
INSERT INTO bov_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lɛmɛ be a kĩ bidzi nɛ opunu akũ mɔ ye a kamɛ odima tánu lɛtsa a sũ kĩ Yesu bi ye tuwuli kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ayekĩ Yuda nɛɛ be sika kuvũ sũ ni, fɔtsa bakɔlɛnɛ a badi kɔna kĩ kabi Yesu bi ye kĩ ɛnaaya fɔtsa a kĩ baakɔa bɛnya luwi a, ĩye kĩ ɛnaakɔa litsedi ete ahiãfɔ. ");
INSERT INTO bov_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kĩ Yuda tɛ funitsã a, deedimɔapɛ ɛnɛ́ ɛdzakũ. Kade dɔ paa. ");
INSERT INTO bov_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kĩ Yuda nɛ ɛdzakũ a, Yesu lɛ kĩ, “Finyaa bɛdɛla Otidziwa Obi a dĩ nɛ ode, ade finyaa bɛdɛla Baguma dĩ lɛmɛ nɛ ode bɛtsãmɛna ye akũ a. ");
INSERT INTO bov_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ntɛ bɛdɛla Baguma dĩ nɛ ode bɛtsãmɛna Otidziwa Obi a akũ ni, lɔkɔa Baguma aadɛla Otidziwa Obi a dĩ nɛ ode nɛ ye mɔawɛ kamɛ lɛtalɛta. ");
INSERT INTO bov_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Yĩ babi, nláabuki nna nɛ mi sɛkɛ̃ owi libuna pii. Míawɛ yĩ, lɛmɛ finyaa mabi mi fɔlɛtsa a kĩ mbi Yudafɔ banɔkɔɛ̃ a kĩ, ‘Miláapuli minaa awã kĩ manaa a.’ ");
INSERT INTO bov_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Finyaa makpa mi mbla vɔɛ̃. Miwɛ mi akũ kalɛ. Ayekĩ nwɛ mi kalɛ a ni, mi malo miwɛ mi akũ kalɛ lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ntɛ miawɛ mi akũ kalɛ ni, odi nyɛ odi aamɔ eyi ɔsũ kĩ yĩ fɔtsa bakɔlɛnɛ mianɛ.” ");
INSERT INTO bov_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ade Simon Petro via kĩ, “Boe Ɔlate, nɛ ndia akpa?” Yesu kpa ye mbuayɛ kĩ, “Awã kĩ manaa, ɔláapuli otomɔ yĩ finyaa bɔnaa, lɛmɛ ke liti ni, aatomɔ yĩ liti.” ");
INSERT INTO bov_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro via ye kĩ, “Nde sũ nláapuli ntomɔ nɔ finyaa? Mmanɛ akũ kĩ maaku nɛ nɔ lɔlɔ!” ");
INSERT INTO bov_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kpa ye mbuayɛ kĩ, “Kalɛ alɛ kĩ ɔmanɛ akũ kĩ aaku nɛ yĩ lɔlɔ? Mabi nɔ ɔnɔkɔali a kĩ fɔmɔ ɔkɔkɔ aabe ni, aalɛ titi ɛlalɛ kĩ onyína yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu bi be kĩ, “Mitafɔ̃ fɔlɛtsa kĩĩ lɛha mi. Mitɛ Baguma mido, mitɛ yĩ malo mido. ");
INSERT INTO bov_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Fɔla beblebee deĩ nɛ Nda tɔtɔ kamɛ. Manaamanɛ kakɔ kadi ĩyi mi. Ntɛ fɔlá lɔmɔ ni, kufɛ nláabi mi kĩ manaamanɛ kadzikɔ̃ ĩyi mi. ");
INSERT INTO bov_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ade ntɛ nnaa nnamanɛ kadzikɔ̃ ĩyi mi ĩyua ni, maamuniki ĩyaakpã mi nnamɛna yĩ sɛkɛ̃, ayekĩ awã kĩ ndeĩ a mi malo míana nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Minyina osi a kĩ ɛwaa ɛnaa awã kĩ manaa a.” ");
INSERT INTO bov_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ade Toma bi Yesu kĩ, “Boe Ɔlate, bunyína awã kĩ anaa, foesũ nde bɔ́akɛna bɔmɔ́ osi a kĩ yanaa awã a?” ");
INSERT INTO bov_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kpa ye mbuayɛ kĩ, “Yĩ nyɛ osi a, ɔnɔkɔali a mɔ nkpã a. Odima láya nɛ Nda sɛkɛ̃ mbɔɛntɛ ɛtsã yĩ akũ. ");
INSERT INTO bov_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ntɛ kanyina minyina yĩ ni, kufɛ minyina Nda lɛmɛ. Lɛmɛ kito finyaa kanaa ni, minyina ye ade mimɔ́ ye lɛmɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ade Filipo bi Yesu kĩ, “Boe Ɔlate, tsa boe Ɔlɛga a, ade lɛtsa a kĩ liti lisĩ boe a.” ");
INSERT INTO bov_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu bi ye kĩ, “Filipo, owi buna kĩ ndeĩ nɛ mi flee sɛkɛ̃, lɛmɛ onyína yĩ? Odi nyɛ odi kĩ ɛmɔ́ yĩ ni, ɛmɔ́ Nda lɛmɛ. Nde sũ obuki avia kĩ, ‘Tsa boe Ɔlɛga a’? ");
INSERT INTO bov_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipo, mbɔɛɛ ɔtátɛ odo kĩ ndeĩ nɛ Nda kamɛ ade kĩ ye malo edeĩ nɛ yĩ kamɛ? Fɔlɛtsa a kĩ mbi mi a flee táto yĩ sɛkɛ̃, mbom Nda a kĩ edeĩ nɛ yĩ kamɛ a lamɛna ye adzuma kakɛna. ");
INSERT INTO bov_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mitɛ yĩ mido ntɛ nlɛ kĩ ndeĩ nɛ Nda kamɛ, ade Nda lɛmɛ deĩ nɛ yĩ kamɛ a. Ntɛ mitátɛ fɔlɛtsa kĩĩ mido ni, ke kɔ̃ mitɛ mido nɛ adzuma a kĩ makɛna a sũ. ");
INSERT INTO bov_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mabi mi nɛ ɔnɔkɔali kamɛ kĩ odi nyɛ odi kĩ ɛtɛ yĩ edo ni, yaakɛna lɛtsa a kĩ makɛna a. Nuwĩ yaapuli ɛkɛna fɔtsa ɛba yĩ fude a, kitonɛkĩ manaa Nda sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lɛtsa nyɛ lɛtsa kĩ míavia nɛ yĩ dĩ akũ ni, maakɛna foe nkpa mi ayekĩ baatsã Obi a akũ bɛdɛla Nda dĩ nɛ ode. ");
INSERT INTO bov_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ntɛ mivia litsedi nɛ yĩ dĩ akũ ni, maakɛna foe.” ");
INSERT INTO bov_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu buki ɛlɛ kĩ, “Ntɛ miawɛ yĩ kalɛ ni, míakɛna nɛ yĩ tɛbla a akũ. ");
INSERT INTO bov_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Maake Nda aduli ɛkpa mi Obumɛnanɛ bɛbã kĩ yaana nɛ mi sɛkɛ̃ daa. ");
INSERT INTO bov_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ade ye nyɛ Hũhũ a kĩ yanyɛ ɔnɔkɔali kalɛ nɛ Baguma akũ a katsa a. Katinya kamɛ bati kɔ̃ lɛláapuli bɛtɛ ye, kitonɛkĩ bɛláapuli bɛmɔ́ ye mɔ baanyi ye. Lɛmɛ mi kɔ̃ minyina ye kitonɛkĩ yaana nɛ mi sɛkɛ̃ ade edeĩ nɛ mi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nláafɔnɛ mi awɛ ĩyi ndɛ banɔkpabi aye. Maamuniki ĩya nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kite sukuloo katinya kamɛ bati lɛláabuki bɛmɔ́ yĩ, lɛmɛ mi kɔ̃ míamɔ yĩ. Ayekĩ ndzi nkpã sũ ni, mi malo míadzi nkpã. ");
INSERT INTO bov_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ntɛ luwi a wo ɔtɔ ni, míanyi kĩ ndeĩ nɛ Nda kamɛ ade mi mideĩ nɛ yĩ kamɛ ade yĩ malo ndeĩ nɛ mi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Oti a kĩ epini yĩ tɛbla, yakɛna nɛ te akũ ni, ade ye nyɛ oti a kĩ yawɛ yĩ kalɛ a. Oti a kĩ yawɛ yĩ kalɛ ni, Nda aawɛ ye kalɛ. Yĩ malo maawɛ ye kalɛ ade maanyɛ yĩ akũ ntsa ye a.” ");
INSERT INTO bov_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ade Yuda, nnɛ́ ekĩ ɛnyɛ Iskariot a, via kĩ, “Boe Ɔlate, nde sũ aanyɛ nɔ akũ ɔtsa boe, mɔ nnɛ́ katinya kamɛ bati a?” ");
INSERT INTO bov_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kpa ye mbuayɛ kĩ, “Odi nyɛ odi kĩ yawɛ yĩ kalɛ ni, yaapi yĩ fɔlɛtsa edomɔ akũ. Nda aawɛ ye kalɛ ade bɔmɔ Nda bɔ́aya nɛ ye sɛkɛ̃ bɔkɛna kadzikɔ̃ nɛ ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Odi nyɛ odi kĩ yaáwɛ yĩ kalɛ ni, yaápi yĩ fɔlɛtsa kadomɔ akũ. Fɔlɛtsa a kĩ minu a lɛnyɛ́ yĩ mɔawɛ fude, mbom futo Ɔlɛga a kĩ edo yĩ a fude fɔanɛ. ");
INSERT INTO bov_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mbi mi fɔlɛtsa kĩĩ nɛ lɔkɔ a kĩ mbuki ndeĩ nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lɛmɛ Obumɛnanɛ a kĩ ɛnyɛ Hũhũ Kpalɛwa kĩ Baguma aado nɛ yĩ dĩ akũ a, aatsa mi lɛtsa nyɛ lɛtsa, ade yaate mi anɛ nɛ lɛtsa nyɛ lɛtsa kĩ mbi mi a akũ a. ");
INSERT INTO bov_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Lukudɔ nkɔa mayi mi. Yĩ lukudɔ nkɔa makpa mi, nnɛ́ ndɛ ayekĩ katinya kamɛ bati akpa a aye. Mitafɔ̃ mi ɔwɔlɛ lɛha mi ĩye mifɔ̃ libe liwo mi. ");
INSERT INTO bov_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Minu ayekĩ mbi mi kĩ, ‘Madzakũ, lɛmɛ maamuniki ĩya nɛ mi sɛkɛ̃.’ Ntɛ miwɛ yĩ kalɛ ni, kufɛ kawɔlɛ de mi kĩ manaa Ɔlɛga a sɛkɛ̃, kitonɛkĩ ye ɛbɛ̃ yĩ. ");
INSERT INTO bov_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Finyaa mbi mi fukĩĩ ĩnyamɛna lɔtɔ fɔmɔ lɛtsa nyɛ lɛtsa aaya nɛ foe kamɛ, ayekĩ ntɛ fɔya nɛ foe kamɛ ni, míatɛ mido. ");
INSERT INTO bov_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nláabuki nlɛ mɔ mi kɔdzɛla nnamɛna lɔtɔ, kitonɛkĩ katinya kamɛ akũ ɔnyanɛ a aya, ade ɛlá kɔbɛ̃ nɛ yĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Lɛmɛ kɛnɛ kĩ katinya kamɛ bati binyi kĩ mawɛ Ɔlɛga a kalɛ, ade makɛna nɛ ye ɔlɛdo akũ pɛpɛɛpɛ a. “Finyaa, miyidza bɔdzakũ nɛ awĩ. ");
INSERT INTO bov_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yĩ nyɛ kutse wĩ a, ade Nda nyɛ futse kɔba ɔnɛnɛ a. ");
INSERT INTO bov_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ɔnanɛ odi nyɛ odi kĩ edeĩ nɛ yĩ akũ kĩ yaáwũ babi ni, yatsua ye kamuni, ade ɔnanɛ odi nyɛ odi kĩ yawũ babi ni, yanyɛ ye akũ tɔɔta, ayekĩ yaawũ babi pii. ");
INSERT INTO bov_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Finyaa yĩ fɔlɛtsa a kĩ mbi mi a kpalɛ mi akũ kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mikɛna ɔmɔa mɔ yĩ, yĩ malo nkɛna ɔmɔa mɔ mi. Ndɛ ayekĩ kutse ɔnanɛ lɛláapuli kuwũ nɛ koe akũ, mbɔɛntɛ kɔmanɛ nɛ kutse ɔma akũ a, ade aye mi malo miláapuli miwũ babi ntɛ mitákɛna ɔmɔa mɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yĩ nyɛ kutse a, ade mi minyɛ tɛnanɛ a. Oti a kĩ ɛkɛna ɔmɔa mɔ yĩ, mɔ yĩ malo nkɛna ɔmɔa mɔ ye ni, ade ye aawũ babi pii, kitonɛkĩ ntɛ nláa mi kamɛ ni, miláapuli mikɛna lɛtsama. ");
INSERT INTO bov_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Oti a kĩ ɛláa yĩ kamɛ ni, ɛla ndɛ ɔnanɛ kĩ bitsua bɛta bimuni ade yawɔlɛ a. Bakpɔta tɛnanɛ a kafila kado nɛ fi kamɛ tavio. ");
INSERT INTO bov_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ntɛ mikɛna ɔmɔa mɔ yĩ, mɔ yĩ fɔlɛtsa a deĩ nɛ mi kamɛ ni, míavia lɛtsa a kĩ miawɛ ade baakɛna foe bɛkpa mi a. ");
INSERT INTO bov_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ntɛ miwũ babi beblebee ni, foe fɔnyɛ Nda kukũkpalɛ fɔtsa, ade fusipi kĩ yĩ fɔtsa bakɔlɛnɛ mianɛ. ");
INSERT INTO bov_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ayekĩ Nda awɛ yĩ kalɛ a ni, ade aye yĩ malo mawɛ mi kalɛ a. Foesũ mifɔ̃ yĩ ɔdɔ a ɛna nkɔsu nɛ mi kamɛ lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ntɛ mipi yĩ tɛbla a midomɔ akũ ni, míana nɛ yĩ ɔdɔ a kamɛ ndɛ ayekĩ yĩ malo mpi Nda mbla ndomɔ akũ fɔfɔ̃ ye ɔdɔ deĩ nɛ yĩ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mbi mi fɔlɛtsa kĩĩ ayekĩ kawɔlɛ a kĩ kideĩ nɛ yĩ kamɛ a odu kɛna nɛ mi kamɛ, lɔkɔa mi kawɔlɛ a kɛkpɔla. ");
INSERT INTO bov_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ade yĩ mbla kĩ makpa mi nyɛ kĩ, miwɛ mi akũ akũ kalɛ ndɛ ayekĩ nwɛ mi kalɛ a. ");
INSERT INTO bov_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ɔdɔ titiliwu adima lɛláa kĩ oti akɔa ye nkpã ɛbɔa afɔliɛ nɛ bakɔba lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ntɛ mikɛna nɛ yĩ mbla a kĩ nkpa mi a akũ a ni, lɔkɔa minyɛ yĩ bakɔba. ");
INSERT INTO bov_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nláabuki nvɛ mi kĩ basumunɛ, kitonɛkĩ ɔsumunɛ linyína lɛtsa a kĩ ye ɔlate akɛna. Lɛmɛ mavɛ mi kĩ bakɔba kitonɛkĩ lɛtsa nyɛ lɛtsa a kĩ nnu ntomɛna Nda sɛkɛ̃ ni, nfɔ̃ minyi foe. ");
INSERT INTO bov_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nnɛ́ mi lɛpau yĩ, mbom yĩ lɛpau mi ndzina mi kĩ minaawũ babi beblebee kĩ baawa daa. Nɛ foesũ lɛtsa nyɛ lɛtsa kĩ míavia Ɔlɛga a nɛ yĩ dĩ akũ ni, yaakpa mi foe. ");
INSERT INTO bov_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Foesũ ade mbla kĩ makpa mi kĩ miwɛ mi akũ kalɛ.” ");
INSERT INTO bov_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu buki ɛlɛ kĩ, “Ntɛ katinya kamɛ bati akesĩ mi ni, minyi kĩ bɛnya lɔtɔ bikesĩ yĩ. ");
INSERT INTO bov_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ntɛ katinya kamɛ bade mianɛ ni, kufɛ baawɛ mi kalɛ ndɛ be bade aye. Lɛmɛ kĩ mpau mi ntomɛna katinya bati kamɛ ade mibuki minyɛ́ be bade a sũ ni, katinya kamɛ bati akesĩ mi. ");
INSERT INTO bov_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mite anɛ nɛ kalɛ a kĩ mbi mi akũ a kĩ, ‘Ɔsumunɛ lɛbɛ́ ye ɔlate.’ Ntɛ bati yidza bɛdza nɛ yĩ akũ ni, baayidza bɛdza nɛ mi malo akũ. Ntɛ bipi yĩ fɔlɛtsa bidomɔ akũ ni, baapi mi fude lɛmɛ bidomɔ akũ. ");
INSERT INTO bov_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lɛmɛ baakɛna fukĩĩ flee nɛ mi akũ nɛ yĩ dĩ sũ, kitonɛkĩ binyína oti a kĩ edo yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ntɛ ntayaabi be fɔlɛtsa ni, kufɛ bɛtáku tɔkpa kɔtɔ. Lɛmɛ finyaa bɛkɛna tɔkpa ade bɛlá onukpɛ̃ kanyɛ kadima a. ");
INSERT INTO bov_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Odi nyɛ odi kĩ yakesĩ yĩ ni, yakesĩ Nda lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ntɛ ntakɛna fɔtsa kĩ odima tákɛna tɔ̃ nɛ be kamɛ ni, kufɛ bɛtákɛna tɔkpa, lɛmɛ kĩ finyaa bɛmɔ́ fɔtsa a kĩ nkɛna a malo ni, bakesĩ bɔmɔ Nda. ");
INSERT INTO bov_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lɛmɛ fukĩĩ flee ya nɛ foe kamɛ ayekĩ fɔlɛtsa a kĩ bɛtsɛlɛ nɛ be mbla ovoli kamɛ a, fɔya nɛ foe kamɛ kĩ, ‘Bikesĩ yĩ pupulidza.’ ");
INSERT INTO bov_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Maado Obumɛnanɛ eto Ɔlɛga a sɛkɛ̃ ɛya nɛ mi sɛkɛ̃. Ade ye nyɛ Hũhũ a kĩ yaanyɛ ɔnɔkɔali a nɛ Baguma akũ ɛtsa a. Ntɛ eto Ɔlɛga a sɛkɛ̃ ɛya ni, yaadi adansiɛ nɛ yĩ akũ. ");
INSERT INTO bov_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mi malo míadi adansiɛ, kitonɛkĩ mina nɛ yĩ sɛkɛ̃ kito kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mbi mi fɔlɛtsa kĩĩ flee ayekĩ bati lɛláafɔ̃ akpɔ liveli mi nɛ mi katɛkado kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Baablɔmɛna mi nɛ Yudafɔ fɔtsɛnakɔ̃. Lɔkɔ aya kĩ ntɛ oti odi kɔ mi ni, yaakɔna kĩ Baguma adzuma ɛkɛna. ");
INSERT INTO bov_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bati aakɛna fukĩĩ nɛ mi akũ kitonɛkĩ bɛtányi Ɔlɛga a ĩye yĩ. ");
INSERT INTO bov_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lɛmɛ mabi mi fukĩĩ ayekĩ ntɛ lɔkɔ a wo ɔtɔ ni, míate anɛ kĩ mbi mi foe. “Ntábi mi fɔlɛtsa kĩĩ nɛ kayɔkayi a, kitonɛkĩ nna nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lɛmɛ finyaa kĩ madzakũ nnaa oti a kĩ edo yĩ a sɛkɛ̃ a, mi kamɛ odima távia yĩ awã kĩ manaa a. ");
INSERT INTO bov_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Finyaa, kĩ mbi mi fɔlɛtsa kĩĩ a, mi flee miwo ɔblɔ. ");
INSERT INTO bov_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lɛmɛ mabi mi ɔnɔkɔali a kĩ fɔnɛnɛ fɔkpa mi kĩ ndzakũ, kitonɛkĩ ntɛ ntánaa ni, Obumɛnanɛ a lɛláaya nɛ mi sɛkɛ̃. Lɛmɛ ntɛ ndzakũ nnaa ni, maado ye ɛya nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ade ntɛ ɛya ni, yaakɔ katinya kamɛ bati kɔtɔ ɛfɔ̃ binyi lɛtsa a kĩ lɛnyɛ tɔkpa, mɔ kadzi kpĩĩ, mɔ Baguma kɔtɔkakɔ. ");
INSERT INTO bov_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yaakɔ be kɔtɔ nɛ tɔkpa sũ, kitonɛkĩ bɛtátɛ yĩ bido. ");
INSERT INTO bov_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yaakɔ be kɔtɔ bɛkɔa binyi kadzi kpĩĩ kamɛ, kitonɛkĩ manaa Nda sɛkɛ̃, kĩ miláabuki mimɔ́ yĩ, ");
INSERT INTO bov_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ade baanyi lɛtsa a kĩ lɛnyɛ kɔtɔkaku, kitonɛkĩ bɛkɔ katinya kĩĩ kamɛ akũ ɔnyanɛ a kɔtɔ kɔkɔɛ. ");
INSERT INTO bov_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ndeĩ fɔlɛtsa pii kĩ maabi mi, lɛmɛ fɔ́aba mi kalɔ finyaa. ");
INSERT INTO bov_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lɛmɛ ntɛ Hũhũ a kĩ yanyɛ ɔnɔkɔali nɛ Baguma akũ katsa a ya ni, yaafɔ̃ minyi Baguma akũ ɔnɔkɔali a flee a. Ɛláalɛ kɔdzɛla nɛ ye mɔawɛ otumi akũ, mbom lɛtsa a kĩ enu a odi mɔ yaalɛ, ade yaafɔ̃ minyi fɔtsa a kĩ fɔ́ayaya a. ");
INSERT INTO bov_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yaado yĩ obu ɛnyɛ yĩ kukũkpalɛ ɛtsa, kitonɛkĩ yaabi mi lɛtsa a kĩ ɛtɛ etomɛna yĩ sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fɔtsa a kĩ fɔnyɛ Nda fude a flee, yĩ fude fɔanɛ. Ade foesũ nlɛ kĩ Hũhũ a aanu etomɛna yĩ sɛkɛ̃ ɛyaabi mi a.” ");
INSERT INTO bov_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu lɛ ɛnamɛna lɔtɔ kĩ, “Kite sukuloo kĩ miláabuki mimɔ́ yĩ, lɛmɛ owi lɛláabuna kĩ míabuki mimɔ́ yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Adeke ye fɔtsa bakɔlɛnɛ a badi via akũ kĩ, “Foe kayɔ nyɛ litsa kĩ yabi boe kĩ, ‘Kite sukuloo miláabuki mimɔ́ yĩ, lɛmɛ owi lɛláabuna kĩ míabuki mimɔ́ yĩ.’ Ebuki ɛlɛ kĩ, ‘Kitonɛkĩ manaa Nda sɛkɛ̃.’ ");
INSERT INTO bov_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Fɔlɛtsa a kĩ ɛlɛ kĩ, ‘Kite sukuloo’ a kayɔ nyɛ litsa? Bɔánu lɛtsa a kĩ yalɛ a kayɔ!” ");
INSERT INTO bov_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu mɔ́ kĩ ye fɔtsa bakɔlɛnɛ a wɛ kĩ bavia ye kalɛ kadi, foesũ ebi be kĩ, “Nlɛ kĩ kite sukuloo miláabuki mimɔ́ yĩ, lɛmɛ owi lɛláabuna kĩ míabuki mimɔ́ yĩ. Mbɔɛɛ fɔlɛtsa kĩĩ kamɛ milamɛna kasa mɔ akũ a? ");
INSERT INTO bov_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mabi mi ɔnɔkɔali a kĩ míabe miwo ɔblɔ, lɛmɛ katinya kamɛ bati aamɔ kawɔlɛ. Míadi ayɔlɔhɔ lɛmɛ mi ayɔlɔhɔ a aadani kawɔlɛkamɔ. ");
INSERT INTO bov_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ntɛ sɛmɛ pi otsole ni, yawo ɔblɔ kitonɛkĩ ye lubo kamɔ ɔdɔũ a bɔa. Lɛmɛ ntɛ ɛma eyua a, yalɛla ye lubo kamɔ a, kitonɛkĩ yamɔ kawɔlɛ kĩ ɛma obi edo nɛ katinya kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ade aye fɔla fɔkpa mi a. Finyaa miwo ɔblɔ, lɛmɛ maabuki mmɔ́ mi, lɔkɔa mi tɔwɔlɛ lɛka tidzi mi mɔ kawɔlɛ paa a kĩ odima lɛláapuli ɛtɛ nɛ mi awɛ a. ");
INSERT INTO bov_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ntɛ luwi a wo ɔtɔ ni, miláabuki mivia yĩ lɛtsama. Ɔnɔkɔali a mabi mi kĩ, Nda aakpa mi lɛtsa nyɛ lɛtsa kĩ míavia ye nɛ yĩ dĩ akũ. ");
INSERT INTO bov_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kito kɛyawo finyaa kĩĩ a, mitávia tɔ̃ lɛtsama nɛ yĩ dĩ akũ. Mivia, lɔkɔa míatɛ, ayekĩ mi kawɔlɛkamɔ aakpɔla. ");
INSERT INTO bov_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mabi mi fɔlɛtsa kĩĩ nɛ fɔgbã kamɛ. Lɛmɛ lɔkɔ aaya kĩ nláabuki mbi mi fɔlɛtsa nɛ fɔgbã kamɛ, mbom maabi mi Nda akũ fɔlɛtsa pefee. ");
INSERT INTO bov_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ntɛ luwi a wo ɔtɔ ni, mivia ye fɔtsa nɛ yĩ dĩ akũ. Maátsa kĩ yĩ maavia ye nkpa mi, ");
INSERT INTO bov_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kitonɛkĩ Nda mɔawɛ a awɛ mi kalɛ. Yawɛ mi kalɛ kitonɛkĩ miawɛ yĩ kalɛ ade mitɛ mido kĩ Baguma sɛkɛ̃ nto ĩya. ");
INSERT INTO bov_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nuwĩ, Ɔlɛga a sɛkɛ̃ nto ĩya nɛ katinya kamɛ, ade finyaa madzakũ nɛ katinya kamɛ nnaa Nda sɛkɛ̃ a.” ");
INSERT INTO bov_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ade ye fɔtsa bakɔlɛnɛ a bi ye kĩ, “Dã, finyaa kɔ̃ alɛ kɔdzɛla pefee, kĩ obuki aábɔa fɔgbã. ");
INSERT INTO bov_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Finyaa kɔ̃ bunyina kĩ onyina lɛtsa nyɛ lɛtsa, ade fɔtásĩ kĩ odi abuki evia nɔ kalɛ kadima a. Fukĩĩ fɔ̃ bɔtɛ budo kĩ Baguma sɛkɛ̃ oto.” ");
INSERT INTO bov_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kpa be mbuayɛ kĩ, “Finyaa kɔ̃ mitɛ mido? ");
INSERT INTO bov_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lɔkɔ aya ade liwo ɔtɔ kɔkɔɛ malo, kĩ baapasam mi flee odi nyɛ odi lɛnaa ye tɔtɔ kamɛ kite yĩ odi. Lɛmɛ nnɛ́ yĩ odi aate, kitonɛkĩ Nda deĩ nɛ yĩ sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mbi mi fukĩĩ kĩĩ flee ayekĩ míakɛna ɔmɔa mɔ yĩ bɔna lukudɔ. Katinya kamɛ bati aafɔ̃ mimɔ́ lubo. Lɛmɛ mido ɔwɔlɛ! Ĩnya katinya kamɛ akũ!” ");
INSERT INTO bov_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kĩ Yesu lɛ fɔlɛtsa kĩĩ eyua a, ɛdɛla anɛ ɛdã ode, ade ɛlɛ kĩ, “Nda, ɔdɔũ a bɔa. Dɛla nɔ Obi dĩ nɛ ode lɔkɔa nɔ Obi lɛmɛ ɛdɛla nɔ dĩ nɛ ode. ");
INSERT INTO bov_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kitonɛkĩ ɔkpa ye otumi nɛ batidziwa flee akũ ayekĩ yaakpa bati a kĩ ɔkɔa odo nɛ ye awɛ a nkpã kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nkpã kĩ ɛlá kawũna a nyɛ kĩ baanyi nɔ ɔnɔkɔali Baguma keĩ a mɔ Yesu Kristo a kĩ odo fɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ndɛla nɔ dĩ nɛ ode nɛ tite akũ, ade ĩyua adzuma a kĩ ɔkpa yĩ kĩ nkɛna a. ");
INSERT INTO bov_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Foesũ Nda, dɛla yĩ dĩ nɛ ode nɛ nɔ anɛ kamɛ, ndɛ ayekĩ nna nɛ nɔ sɛkɛ̃ fɔmɔ bɛbɔa katinya a. ");
INSERT INTO bov_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ĩnyɛ nɔ ntsa bati a kĩ ɔnyɛ nɛ katinya kamɛ ɔkpa yĩ a. Nɔ bade banɛ, lɛmɛ ɔkɔa ɔkpa yĩ. Bɛkɛna nɛ nɔ kalɛ akũ. ");
INSERT INTO bov_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Finyaa kɔ̃ binyina kĩ lɛtsa nyɛ lɛtsa kĩ ɔkɔa ɔkpa yĩ a flee to nɔ sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nkɔa ɔlɛdo a kĩ ɔkpa yĩ a nkpa be, ade bɛtɛ ye a. Binyina kĩ ɔnɔkɔali fɔanɛ kĩ nɔ sɛkɛ̃ nto, ade bɛtɛ bido kĩ nɔ lido yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Make aduli nɛ be lɔlɔ. Nlámɛna aduli kake nɛ katinya kamɛ bati lɔlɔ, mbom nɛ bati a kĩ ɔkɔa odo nɛ yĩ awɛ a lɔlɔ, kitonɛkĩ nɔ bade banɛ. ");
INSERT INTO bov_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yĩ bati a flee nɔ bade banɛ, ade ayea nɔ bade flee lɛmɛ nyɛ yĩ bade a, ade bɛdɛla yĩ dĩ nɛ ode bɛtsãmɛna be akũ a. ");
INSERT INTO bov_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ade finyaa maya nɛ nɔ sɛkɛ̃, mbuki nláa katinya kamɛ, lɛmɛ be kɔ̃ bideĩ nɛ katinya kamɛ. Ɔlɛga Kpalɛwa, kɔa nɔ dĩ akũ kɔbɛ̃ a kĩ ɔkpa yĩ a kadãmɛna be akũ ayekĩ baakɛna ɔmɔa ndɛ ayekĩ bɔmɔ nɔ bɔnyɛ ɔmɔa a. ");
INSERT INTO bov_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kĩ nna nɛ be sɛkɛ̃ a, nkɔa nɔ dĩ akũ kɔbɛ̃ a kĩ ɔkpa yĩ a ndãmɛna be akũ. Ndã be akũ kĩ be kamɛ odima táyɛla, mbɔɛntɛ oti a kĩ kɛnɛ kĩ ɛyɛla a, ayekĩ Katsɛlɛ Kpalɛwa fɔlɛtsa a aaya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lɛmɛ finyaa maya nɛ nɔ sɛkɛ̃, ade malɛ fukĩĩ bamɛ nɛ katinya kamɛ ayekĩ baamɔ kawɔlɛ kɛkpɔla nɛ be kamɛ ndɛ ayekĩ yĩ malo mamɔ ke a. ");
INSERT INTO bov_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Nkɔa nɔ ɔlɛdo a nkpa be lɛmɛ katinya kamɛ bati kesĩ be, kitonɛkĩ bɛtáto katinya kamɛ ndɛ ayekĩ yĩ malo ntáto katinya kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ntávia nɔ kĩ nyɛ be nɛ katinya kamɛ, mbom mawã nɔ kĩ nyɛ be nɛ Okesĩnɛ a awɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ndɛ ayekĩ ntáto katinya kamɛ sũ ni, be malo bɛnyɛ́ katinya kamɛ bade. ");
INSERT INTO bov_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kɛna be bati kpalɛwa kakpa nɔ akũ nɛ ɔnɔkɔali a kamɛ, nɔ kalɛ a nyɛ ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndo be nɛ katinya kamɛ ndɛ ayekĩ nɔ malo odo yĩ nɛ katinya kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ade nɛ be sũ ni, nkpalɛ yĩ akũ nkpa nɔ ayekĩ be malo baakpalɛ be malo akũ nɛ ɔnɔkɔali a kamɛ bɛkpa nɔ. ");
INSERT INTO bov_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nnɛ́ bati kĩĩ odi lɔlɔ mabɔa mpaɛ, mbom mabɔa nkpa bati a kĩ baatɛ yĩ bido nɛ fɔlɛtsa a kĩ baabi be a sũ. ");
INSERT INTO bov_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Make nɔ aduli kĩ fɔ̃ be flee bɛkɛna ɔmɔa. Nda, fɔ̃ be malo bɛna nɛ boe kamɛ ndɛ ayekĩ odeĩ nɛ yĩ kamɛ, ade yĩ malo ndeĩ nɛ nɔ kamɛ a. Fɔ̃ bɛkɛna ɔmɔa ayekĩ katinya kamɛ bati aatɛ bido kĩ nɔ lido yĩ. ");
INSERT INTO bov_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Ndɛla be buĩ nɛ ode ndɛ ayekĩ ɔdɛla yĩ dĩ nɛ ode, ayekĩ baakɛna ɔmɔa ndɛ ayekĩ bɔmɔ nɔ bɔnyɛ ɔmɔa a. ");
INSERT INTO bov_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yĩ ndeĩ nɛ be kamɛ ade nɔ malo odeĩ nɛ yĩ kamɛ, kĩ baakɛna ɔmɔa bɛkpɔla, ayekĩ katinya kamɛ bati aanyi kĩ nɔ lido yĩ. Ade baanyi kĩ awɛ be kalɛ ndɛ ayekĩ awɛ yĩ kalɛ a. ");
INSERT INTO bov_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nda, mawɛ kĩ bati a kĩ ɔkɔa ɔkpa yĩ a bɛna nɛ awã kĩ ndeĩ a, ayekĩ baamɔ yĩ kukũkpalɛ a kĩ ɔkpa yĩ a, kitonɛkĩ ɔwɛ yĩ kalɛ fɔmɔ biyi katinya kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Nda, Oti Kpĩĩ, katinya kamɛ bati linyína nɔ lɛmɛ yĩ kɔ̃ ĩnyina nɔ, ade bati kĩĩ lɛmɛ nyina kĩ nɔ lido yĩ a. ");
INSERT INTO bov_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ĩnyɛ nɔ ntsa be yededeede, ade maakanyɛ nɔ nkatsa be, ayekĩ ɔdɔ a kĩ odeĩ ɔkpa yĩ a aana nɛ be kamɛ, lɔkɔa yĩ malo maana nɛ be kamɛ.” ");
INSERT INTO bov_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kĩ Yesu bɔa mpaɛ kĩĩ eyua a, bɛmɔ ye fɔtsa bakɔlɛnɛ a bɛdzakũ nɛ awã, bɛnanyina Kidron kawɔbi a ade bɛnawo nɛ kugua futse kɔba kudi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda a kĩ ɛnyɛ ye ɛkpa a, nyina awã, kitonɛkĩ lɔkɔlɔkɔ Yesu mɔ ye fɔtsa bakɔlɛnɛ a awɛ katsɛna nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Foesũ Yuda kpã Roma sodzafɔ mɔ Asɔli Kɔla akũ badãmɛnanɛ a kĩ basɔfɔnɔkɔɛ̃ mɔ Farisifɔ do a ɛnamɛna kɔba a kamɛ. Bɛnɛɛ kawũkanɔ fɔtsa, tɛsɛdza mɔ tibia tɛnawa. ");
INSERT INTO bov_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ayekĩ Yesu nyina fɔtsa a kĩ fɔ́aya nɛ ye akũ a flee sũ ni, ɛnɛ ɛya nɛ lɔtɔ evia be kĩ, “Owei miawɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bɛkpa ye mbuayɛ kĩ, “Yesu Nazaretni a.” Yesu bi be kĩ, “Amɔ yĩ.” Yuda a kĩ ɛnyɛ ye ɛkpa a lɛmɛ dzɛ̃ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kĩ Yesu bi be kĩ, “Amɔ yĩ” a, be flee bɛnaa litiliti bɛnatɔ nɛ tite. ");
INSERT INTO bov_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ade Yesu buki evia be kĩ, “Owei miawɛ?” Bɛkpa ye mbuayɛ kĩ, “Yesu Nazaretni a.” ");
INSERT INTO bov_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu bi be kĩ, “Mbi mi kɔkɔɛ kĩ yĩ nyɛ ye, foesũ ntɛ yĩ miawɛ kɔ̃ ni, mifɔ̃ bati kĩĩ bɛdzakũ.” ");
INSERT INTO bov_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɛlɛ fukĩĩ ayekĩ kalɛ a kĩ ɛlɛ eyi a aaya nɛ foe kamɛ pɛpɛɛpɛ kĩ, “Nda, bati a kĩ ɔkɔa odo nɛ yĩ awɛ a kamɛ odima táyɛla.” ");
INSERT INTO bov_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ade Simon Petro nyɛ kɔpã a kĩ ɛnɛɛ a ɛbaa Ɔsɔfɔnɔkɔɛ̃ Flee a ɔsumunɛ sɔmɔna sɔtɔ emuni a. Ɔsumunɛ a dĩ nyɛ Malko. ");
INSERT INTO bov_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ade Yesu bi Petro kĩ, “Kɔa nɔ kɔpã a kado nɛ kuvũ kamɛ! Ɔkɔna kĩ nláamɔa lubo kamɔ kɔɔpu a kĩ Nda kɔa ɛkpa yĩ a mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ke liti a, Roma sodzafɔ mɔ be banɔkɔɛ̃, mɔ Yudafɔ Asɔli Kɔla akũ badãmɛnanɛ a pi Yesu ade bisui ye a. ");
INSERT INTO bov_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bɛnya lɔtɔ bɛkpã ye bɛnamɛna Hana sɛkɛ̃. Hana kĩĩ nyɛ Kayafa, kĩ yanya Ɔsɔfɔnɔkɔɛ̃ Flee nɛ kateli a kamɛ a otse. ");
INSERT INTO bov_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ade Kayafa kĩĩ lɛmɛ lɛkpa Yudafɔ banɔkɔɛ̃ a adzuni kĩ fɔnɛnɛ fɔbɛ̃ kĩ oti mɔa aku nɛ ɔmaĩ a lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petro mɔ fɔtsa ɔkɔlɛnɛ bɛbã odi tomɔ Yesu nɛ liti. Fɔtsa ɔkɔlɛnɛ bɛbã kĩĩ a nyɛ Ɔsɔfɔnɔkɔɛ̃ Flee a oti nyiwa, foesũ etomɔ Yesu ewo nɛ Ɔsɔfɔnɔkɔɛ̃ Flee a fɔlɛtsa kadzɛkɔ̃. ");
INSERT INTO bov_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lɛmɛ Petro fɔ̃ ɛdza nɛ kanya nɛ onyukpɛ̃. Ade fɔtsa ɔkɔlɛnɛ bɛbã a nɛ́, ɛnaa kanya ɛnalɛmɔ oyitsɔ̃ a kĩ yadã onyukpɛ̃ akũ a kɔdzɛla, ade ɛkpã Petro ewomɛna nɛ tɔtɔ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oyitsɔ̃ a kĩ yadã onyukpɛ̃ akũ a via Petro kĩ, “Nɔ malo nnɛ́ onyole kĩĩ fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa anɛ?” Petro kpa mbuayɛ kĩ, “Oowo, ĩnyɛ́ ye fɔtsa ɔkɔlɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Osili na, foesũ basumunɛ mɔ bikĩ badzɔlɛ awã akũ a tɛna futuã fi bɛdza bisinya bawa foe. Petro lɛmɛ nadza nɛ be ɔwɛ̃ ɛkawa fi a. ");
INSERT INTO bov_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ɔsɔfɔnɔkɔɛ̃ Flee a via Yesu fɔlɛtsa nɛ ye fɔtsa bakɔlɛnɛ mɔ ye fɔtsa katsa a akũ. ");
INSERT INTO bov_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ade Yesu kpa ye mbuayɛ kĩ, “Malɛ kɔdzɛla daa nɛ kanade kakpa odi nyɛ odi. Matsa fɔtsa nɛ Yudafɔ fɔtsɛnakɔ̃ mɔ Baguma Asɔli Kɔla a kamɛ, awã kĩ bati a flee atsɛna, ade maálɛ lɛtsama nɛ kabɛla kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mɔ nde sũ avia yĩ fɔlɛtsa? Via bikĩ binu yĩ fɔlɛtsa a. Ade be nyina lɛtsa a kĩ nlɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kĩ Yesu lɛ fɔlɛtsa kĩĩ a, bikĩ badzɔlɛ awã akũ a kamɛ ɔmɔa balɛ ye awɛ nɛ ɔlɔtɔ ade ebi ye kĩ, “Nde mɔ odo ɔwɔlɛ ɔkpa Ɔsɔfɔnɔkɔɛ̃ Flee a mbuayɛ lɔmɔ?” ");
INSERT INTO bov_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kpa ye mbuayɛ kĩ, “Ntɛ nlɛ fɔlɛtsa kpa ni, bi odi nyɛ odi nɛ awĩ kĩĩ lɛtsa a kĩ fɔanɛ. Lɛmɛ ntɛ lɛtsa a kĩ nlɛ a nyɛ ɔnɔkɔali ni, litsa sũ ɔbalɛ yĩ awɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ade Hana fɔ̃ bɛkpã Yesu kĩ ebuki edeĩ nɛ tɔwɛ̃ kamɛ a bɛma Kayafa, Ɔsɔfɔnɔkɔɛ̃ Flee a. ");
INSERT INTO bov_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nɛ lɔkɔ a na kamɛ a, Petro buki ɛdzɛ̃ yawa fi. Ade bati bɛbã a via ye kĩ, “Mbɔɛɛ nɔ malo ye fɔtsa bakɔlɛnɛ a kamɛ ɔmɔa anɛ?” Lɛmɛ Petro nunya kĩ, “Oowo, ĩnyɛ́ ye fɔtsa ɔkɔlɛnɛ.” ");
INSERT INTO bov_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɔsɔfɔnɔkɔɛ̃ Flee a basumunɛ a kamɛ ɔmɔa kĩ ye akũ oti sɔtɔ Petro baa emuni a via ye kĩ, “Ntámɔ nɔ nɛ ye sɛkɛ̃ nɛ kɔbã a kamɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro buki ɛlɛ kĩ, “Oowo!” Deedimɔapɛ ɔkɔkɔ be. ");
INSERT INTO bov_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɔnɔnɛ tutuutu a, bɛkpã Yesu bitomɛna Kayafa sɛkɛ̃ bɛnamɛna abãã ɔnɔkɔɛ̃ a tɔtɔ kamɛ. Yudafɔ banɔkɔɛ̃ a mɔawɛ táwo nɛ abãã tɔtɔ a kamɛ, kitonɛkĩ bɛwɛ kĩ be akũ ɛkpalɛ nɛ be amaniɛ onukpɛ̃ ɛkpa Wuda Katɛ̃ funitsã a kanya. ");
INSERT INTO bov_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Foesũ Pilato nɛ́ ɛnaa be sɛkɛ̃ evia be kĩ, “Litsa fɔlɛtsa mibɔɛ nɛ oti kĩĩ akũ?” ");
INSERT INTO bov_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bɛkpa ye mbuayɛ kĩ, “Ntɛ nnɛ́ tɔkpa ɔkɛnanɛ yanɛ ni, kufɛ bɔtákpã ye bɔma nɔ.” ");
INSERT INTO bov_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ade Pilato bi be kĩ, “Kekɔ̃ mi mɔawɛ mikpã ye minaadzɛmɔ ye nɛ mi mbla onukpɛ̃.” Yudafɔ banɔkɔɛ̃ a kpa ye mbuayɛ kĩ, “Bɛtákpa boe osi kĩ bɔakɔ oti odima.” ");
INSERT INTO bov_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Fukĩĩ ya lɔmɔ ayekĩ fɔlɛtsa a kĩ Yesu lɛ eyi nɛ wuda odu kĩ yaaku a akũ a fɔya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato dani ewo nɛ abãã tɔtɔ kamɛ ade ɛvɛ Yesu evia ye kĩ, “Nɔ nyɛ Yudafɔ lɛgã a mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kpa ye mbuayɛ kĩ, “Nɔ mɔawɛ avia yĩ fɔlɛtsa kĩĩ, mbɔɛɛ kĩ bati bɛbã libi nɔ yĩ akũ fɔlɛtsa?” ");
INSERT INTO bov_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kpa ye mbuayɛ kĩ, “Akɔna kĩ Yudani manɛ? Nɔ mɔawɛ kade bati mɔ basɔfɔnɔkɔɛ̃ a lɛkpã nɔ bɛmɛ yĩ. Litsa ɔkɛna?” ");
INSERT INTO bov_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kpa ye mbuayɛ kĩ, “Yĩ lɛgãkanyakɔ̃ táto katinya kĩĩ kamɛ. Ntɛ yĩ lɛgãkanyakɔ̃ kito katinya kĩĩ kamɛ ni, kufɛ yĩ basumunɛ a pili yĩ lɔlɔ, mɔ baakɔa yĩ bido nɛ Yudafɔ awɛ kamɛ. Lɛmɛ yĩ lɛgãkanyakɔ̃ a táto katinya kĩĩ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato via ye kĩ, “Foesũ lɛgã anɛ kɔ̃?” Yesu kpa mbuayɛ kĩ, “Nɔ lɛlɛ kĩ lɛgã manɛ. Yĩ kɔ̃ ni, ade fukĩĩ sũ bɛma yĩ a, ade foesũ ĩya nɛ katinya kamɛ kĩ mayaalɛ kɔdzɛla nɛ ɔnɔkɔali kalɛ a akũ. Odi nyɛ odi kĩ eto ɔnɔkɔali a kamɛ ni, yatse yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato via ye kĩ, “Litsa nyɛ ɔnɔkɔali a?” Kĩ Pilato lɛ fɔlɛtsa kĩĩ eyua a, ɛnɛ́ ɛnaa Yudafɔ a sɛkɛ̃ nɛ kanya ade ebi be kĩ, “Ntámɔ tɔkpa tidima nɛ oti kĩĩ akũ kĩ makɔ ye kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lɛmɛ nɛ mi amaniɛ onukpɛ̃ ni, kɛnɛ kĩ nfɔnɛ kɔla bawanɛ a kamɛ ɔmɔa nkpa mi nɛ Wuda Katɛ̃ Luwi kanya kamɛ. Miawɛ kĩ nfɔnɛ Yudafɔ lɛgã a awɛ nkpa mi mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ade bɛbɔa fɔwɔla bɛlɛ kĩ, “Oowo, nnɛ́ ye bɔawɛ! Baraba bɔawɛ!” Baraba nyɛ oti kĩ eyidza ɛdza nɛ abãã akũ. ");
INSERT INTO bov_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ade Pilato fɔ̃ bɛkpã Yesu bɛdzakũmɛna bɛnabo ye mɔ mple. ");
INSERT INTO bov_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sodzafɔ kɔa fɔtsɔlɛwɛ bɛnɔ lɛgãbɔɛ bɛtsa ye. Kĩ bido ye atadiɛ ngbã biyua a, ");
INSERT INTO bov_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","bifuã ye bibi ye kĩ, “Yiiduu! Yudafɔ Lɛgã o-o!” Ade bɛbalɛbalɛ ye awɛ nɛ tɔlɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ke liti a, Pilato buki ɛnɛ́ ɛnaa kanya ɛnabi bati kɔdabu a kĩ, “Midã, maakpã ye nnɛmɛna mma mi mimɔ́ kĩ ntámɔ́ mfumsu adima nɛ ye akũ kĩ makɔ ye kɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Adeke Yesu nɛ́ ɛya nɛ kanya, fɔtsɔlɛwɛ lɔbɔɛ a tsanɛ nɛ ye lɔlɔ, edeĩ nɛ atadiɛ ngbã a kamɛ. Pilato bi bati a kĩ, “Midã! Amɔ oti a nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kĩ basɔfɔnɔkɔɛ̃ mɔ Asɔli Kɔla akũ badzɔlɛnɛ a mɔ́ ye a, bɛbɔa fɔwɔla kĩ, “Bɔa ye nɛ asendua akũ! Bɔa ye nɛ asendua akũ!” Ade Pilato bi be kĩ “Mi mɔawɛ mikpã ye minaabɔa ye nɛ asendua akũ. Yĩ kɔ̃ ntámɔ kĩ ɛkɛna lɛtsa kpa lidima.” ");
INSERT INTO bov_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yudafɔ a kpa ye mbuayɛ kĩ, “Boe kɔ̃ budeĩ mbla, ade nɛ mbla a onukpɛ̃ ni, kĩ kɛnɛ kĩ eku, kitonɛkĩ ɛkɛna ye akũ Baguma Obi.” ");
INSERT INTO bov_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kĩ Pilato nu fɔlɛtsa kĩĩ a, ebuki evila ɛba kɔkɔɛ a. ");
INSERT INTO bov_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Foesũ emuniki ɛnaa abãã tɔtɔ a kamɛ ade evia Yesu kĩ, “Ndia oto?” Lɛmɛ Yesu tákpa ye mbuayɛ adima. ");
INSERT INTO bov_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ade Pilato bi ye kĩ, “Hei! Aákpa yĩ kalɛ a mbuayɛ? Mbɔɛɛ onyína kĩ ndeĩ kɔbɛ̃ kĩ mafɔnɛ nɔ awɛ, ĩye kĩ mafɔ̃ bɛbɔa nɔ nɛ asendua akũ?” ");
INSERT INTO bov_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kpa ye mbuayɛ kĩ, “Ntɛ bɛtakpa nɔ kɔbɛ̃ bitomɛna ode ni, kufɛ ɔláana kɔbɛ̃ nɛ yĩ akũ. Foesũ oti a kĩ ɛnyɛ yĩ ɛkpa nɔ a tɔkpa bɛ̃ nɔ tide.” ");
INSERT INTO bov_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kĩ Pilato nu fɔlɛtsa kĩĩ a, ɛwɛ kĩ yatsã osi nyɛ osi akũ ɛfɔnɛ ye awɛ, lɛmɛ Yudafɔ a bɔa fɔwɔla kɔɔba kĩ, “Ntɛ ɔfɔnɛ ye awɛ ni, fɔatsa kĩ ɔnyɛ́ Roma Lɛgãnɔkɔɛ̃ ɔkɔba! Odi nyɛ odi kĩ ɛkɛna ye akũ Lɛgã ni, eyidza ɛdza nɛ Roma Lɛgãnɔkɔɛ̃ akũ!” ");
INSERT INTO bov_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kĩ Pilato nu fɔlɛtsa kĩĩ a, ɛkpã Yesu ɛnamɛna kanya ade ye mɔawɛ ɛnadzi nɛ fɔlɛtsa kadzɛ lukpo kamɛ nɛ kakɔ a kĩ bavɛ kĩ Boe Ɔda a. Bavɛ kakɔ a nɛ Hebri tide kamɛ kĩ Gabata. ");
INSERT INTO bov_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lɔkɔ a nyɛ Wuda Katɛ̃ kukũmanɛ luwi, ade fɔ́ana ndɛ suwa tɔdɔũ ewua-nviã a. Ade Pilato bi Yudafɔ a kĩ, “Amɔ mi Lɛgã a nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bati a bɔa fɔwɔla kĩ, “Kpã ye kanamɛna! Kpã ye kanamɛna! Bɔa ye nɛ asendua akũ!” Ade Pilato via be kĩ, “Miawɛ kĩ mbɔa mi lɛgã nɛ asendua akũ?” Basɔfɔnɔkɔɛ̃ a kpa mbuayɛ kĩ, “Bɔlá Lɛgã lidima kɛba Roma Lɛgãnɔkɔɛ̃!” ");
INSERT INTO bov_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Adeke Pilato fɔnɛ Yesu awɛ ɛkpa sodzafɔ a kĩ bɛnaabɔa ye nɛ asendua akũ a. Foesũ bɛkpã Yesu bɛdzakũmɛna. ");
INSERT INTO bov_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ye mɔawɛ ɛlɔ ye asendua ɛnawo awã kĩ bavɛ Oti Lɔlɔ Fɔtsɔ̃. Bavɛ awã nɛ Hebri tide kamɛ kĩ Golgata. ");
INSERT INTO bov_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ade awã naa, bɛbɔa ye nɛ asendua akũ a. Bɛbɔa bati nviã bɛbã nɛ asendua akũ bibumɔ ye, ɔmɔa nɛ ye sɛba, ɔyade nɛ ye sɔmɔna, ade Yesu deĩ nɛ be kayite a. ");
INSERT INTO bov_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato tsɛlɛ ye onukpɛ̃ katsua fɔlɛtsa bɛbɔa nɛ asendua a lɔlɔ nyangɛ. Fɔlɛtsa a kĩ ɛtsɛlɛ nyɛ, “Yesu Nazaretni, Yudafɔ Lɛgã a.” ");
INSERT INTO bov_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yudafɔ pii kã fɔlɛtsa a kĩ bɛtsɛlɛ a, kitonɛkĩ awã kĩ bɛbɔa Yesu a fuãmɔ ɔmatɔ kamɛ. Pilato tsɛlɛ fɔlɛtsa a nɛ Hebri, Roma mɔ Hela lɛmɛ tide kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ade basɔfɔnɔkɔɛ̃ a sĩ fɔlɛtsa a, ade bibi Pilato kĩ, “Tatsɛlɛ kĩ, ‘Yudafɔ Lɛgã,’ mbom ‘Oti kĩĩ lɛ kĩ, “Yĩ nyɛ Yudafɔ Lɛgã a.” ’ ” ");
INSERT INTO bov_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kpa be mbuayɛ kĩ, “Lɛtsa a kĩ ntsɛlɛ ni, ntsɛlɛ de kɔkɔɛ.” ");
INSERT INTO bov_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kĩ sodzafɔ a bɔa Yesu nɛ asendua akũ biyua a, bɛbɔɛ ye tɛtadiɛ bɛsɛ̃ nɛ kutsu ɛna kamɛ, ade sodzafɔ a kamɛ odi nyɛ odi bɔɛ kamɔa a. Ke liti a, bɛbɔɛ ye atadiɛ amɛde a kĩ bɛtápam, mbom bɛnɔ ye kito sɔmɔ kɛnake kayɔ a. ");
INSERT INTO bov_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sodzafɔ a bi akũ kĩ, “Mitafɔ̃ bɔyɛlɛ atadiɛ a, mbom mifɔ̃ bɔta bavulibi bɔmɔ́ oti a kĩ yaatɛ ye.” Fɔlɛtsa kĩĩ ya ndɛ ayekĩ Katsɛlɛ Kpalɛwa a aaya nɛ foe kamɛ kĩ, “Bɛsɛ̃ yĩ tɛtadiɛ bɛkpa akũ. Ade bɛta bavulibi nɛ yĩ atadiɛ akũ a.” Ade lɛtsa a kĩ sodzafɔ a kɛna a. ");
INSERT INTO bov_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Finyaakĩiĩ a, Yesu ɔma, ɔma ɔwaɛ̃tsole, Maria kĩ ɛnyɛ Clopa ɔtsɔ̃, mɔ Maria Magdalani dzɛ̃ nɛ Yesu asendua a ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kĩ Yesu mɔ́ ɔma mɔ ye fɔtsa ɔkɔlɛnɛ a kĩ yaátunɔ kalɛ a kĩ bɛdzɛ̃ nɛ awã a, ebi ɔma kĩ, “Mma, dã ade nɔ obi nɛ awĩ a!” ");
INSERT INTO bov_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ade ebi fɔtsa ɔkɔlɛnɛ a kĩ, “Dã, ade ama nɛ awĩ a!” Kito luwi a akũ a, fɔtsa ɔkɔlɛnɛ a kpã Maria ɛnamɛna nɛ ye mɔawɛ tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Finyaa Yesu nyi kĩ biyua lɛtsa nyɛ lɛtsa kakɛna. Ayekĩ fɔ́afɔ̃ Katsɛlɛ Kpalɛwa a lɛya nɛ foe kamɛ sũ ni, ɛlɛ kĩ, “Ɔmɔado akɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kugumi kudi keni nɛ awã kĩ kuyi mɔ waĩ yilawa. Ade bɛkɔa ɔsapɔ bɛta waĩ a bɛkɔa bido nɛ otse akũ bɛnatamɔ Yesu onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kĩ Yesu mɔa bavɛ a eyua a, ɛlɛ kĩ, “Fuwoli!” Ɛkɛna lɔlɔ ade ye kawɛya nɛ a. ");
INSERT INTO bov_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Luwi a nyɛ Efieda, ade Kawɛya Luwi kĩ litomɔ de a nyɛ luwi kpalɛwa lɛkpa Yudafɔ, foesũ bɛtáwɛ kĩ banɔkpa a bɛkahɔ nɛ asendua akũ Kawɛya Luwi a liwo ɔtɔ. Nɛ fukĩĩ sũ Yudafɔ banɔkɔɛ̃ a navia Pilato kĩ ɛkpa be osi bɛnaaveliveli bati a kĩ bɛbɔa nɛ asendua akũ a abɔa, lɔkɔa bɛnyɛ be banɔkpa a. ");
INSERT INTO bov_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Foesũ sodzafɔ a yaveli oti ɔtɔnyade mɔ oti bɛbã a kĩ bɛbɔa nɛ asendua akũ bibumɔ Yesu a abɔa. ");
INSERT INTO bov_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lɛmɛ kĩ biwo Yesu akũ a, bɛmɔ́ kĩ eku kɔkɔɛ, foesũ bɛtáveli ye abɔa. ");
INSERT INTO bov_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lɛmɛ be kamɛ ɔmɔa kɔa lɔtsɔɛ ɛtsɔɛ ye sɛklabi, ade deedimɔapɛ babɔanɛ mɔ mui nɛ a. ");
INSERT INTO bov_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Oti a kĩ ɛmɔ́ fɔtsa kĩĩ lidi adansiɛ nɛ foe akũ ayekĩ nɔ malo aatɛ odo. Lɛtsa a kĩ ɛlɛ a nyɛ ɔnɔkɔali, ade enyina pefee kĩ ɔnɔkɔali ɛlɛ a. ");
INSERT INTO bov_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Fukĩĩ ya ayekĩ Katsɛlɛ Kpalɛwa fɔlɛtsa a aaya nɛ foe kamɛ kĩ, “Bɛláave ye lɔtsɔ̃ lidima.” ");
INSERT INTO bov_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Fɔlɛtsa bɛbã nɛ Katsɛlɛ Kpalɛwa a kamɛ lɛmɛ lɛ kĩ, “Bati aako anɛ bɛdã oti a kĩ bɛtsɔɛ ye lɔtsɔɛ a.” ");
INSERT INTO bov_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ke liti a, Yosef kĩ eto Arimatia yavia Pilato kĩ ɛkpa ye osi ɛbɔɛ Yesu ɔnɔkpa a. Yosef kĩĩ nyɛ Yesu fɔtsa ɔkɔlɛnɛ odi nɛ kabɛla kamɛ, kitonɛkĩ ɛkavila Yudafɔ banɔkɔɛ̃ a. Pilato kpa osi, ade Yosef yabɔɛ ɔnɔkpa a ɛdzakumɛna a. ");
INSERT INTO bov_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ade Nikodemo kĩ ɛnya lɔtɔ ɛnaa Yesu sɛkɛ̃ mɔ lɛnyɛ a lɛmɛ tomɔ Yosef ɛya a. Ɛnɛɛ tutsonu mɔ ɔlɛ̃ kĩ bɛkɔa klubɔũ mɔ odi kĩ bavɛ aloa bɛkɛna ɛyamɛna. Te ɔlɔmɛ kamɛ aana ndɛ kilo taalɛ. ");
INSERT INTO bov_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Banyole nviã a kɔa tutsonu a bikputa Yesu ɔnɔkpa a, ade bɛkɔa aklala ovoe bisuli ye ndɛ ayekĩ Yudafɔ akɛna ɔnɔkpa fɔmɔ babila ye a. ");
INSERT INTO bov_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kɔbã kudi deĩ nɛ awã kĩ bɛbɔa Yesu nɛ asendua akũ a. Linikɛ vɔɛ̃ kĩ bɛtábila oti tɔ̃ deĩ nɛ kɔbã a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ayekĩ luwi a nyɛ Kukũmanɛ luwi lɛkpa Kawɛya Luwi a, ade kĩ awã lɛmɛ fuã be sũ ni, bɛkɔa Yesu ɔnɔkpa a bibila nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɛkwansieda ɔnɔnɛ tutuutu a, kĩ fɔkɔ tákpalɛ tɔ̃ a, Maria Magdalani naa linikɛ a ɔwɛ̃, ade ɛmɔ́ kĩ bitinya de a nɛ linikɛ a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Foesũ ewula atsɛ ɛnaa Simon Petro mɔ fɔtsa ɔkɔlɛnɛ a kĩ Yesu látunɔ kalɛ a sɛkɛ̃, ebi be kĩ, “Bɛyabɔɛ boe Ɔlate nɛ linikɛ a kamɛ bɛdzakũmɛna, ade bunyína awã kĩ bɛkɔa ye biyi a.” ");
INSERT INTO bov_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ade Petro mɔ fɔtsa ɔkɔlɛnɛ kĩ a yidza bɛnaa linikɛ a ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Be nviã a flee bɛkawula atsɛ, lɛmɛ fɔtsa ɔkɔlɛnɛ kĩ a wula atsɛ ɛtɛ̃ Petro ɛnya lɔtɔ ewo linikɛ a ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɛkɛna akũ ɛdã de kamɛ ɛmɔ́ aklala a kĩ bɛkɔa bisuli ɔnɔkpa a, lɛmɛ ɛtáwo nɛ linikɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petro kĩ etomɔ ye nɛ liti a, ya ade ye kɔ̃ ewo nɛ linikɛ a kamɛ a. Ɛmɔ́ aklala ovoe a kĩ ɛwaa nɛ awã. ");
INSERT INTO bov_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɛmɔ́ lima a kĩ bɛkɔa bisui Yesu lɔlɔ a lɛmɛ nɛ awã, lɛmɛ lɛwáa nɛ aklala a ɔwɛ̃, mbom bibuta de biyi de lite. ");
INSERT INTO bov_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ke liti a, fɔtsa ɔkɔlɛnɛ bɛbã a kĩ ɛnya lɔtɔ ewo linikɛ a ɔwɛ̃ a, lɛmɛ wo nɛ de kamɛ. Ɛmɔ́ aklala mɔ lɔlɔ kasui lima a, ade ɛtɛ edo a. ");
INSERT INTO bov_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ke malo ni, bɛtánu kayɔ kĩ Katsɛlɛ Kpalɛwa a lɛ kĩ kɛnɛ kĩ Yesu eyidza eto kanɔkpa. ");
INSERT INTO bov_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ke liti a, fɔtsa bakɔlɛnɛ a dzakũ bɛnaa be tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lɛmɛ Maria dza nɛ linikɛ a ɔwɛ̃ ɛkabe. Kĩ ɛkabe a, ɛkɛna akũ ɛdã linikɛ a kamɛ, ");
INSERT INTO bov_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ade ɛmɔ́ ode fɔtɔ banyanɛ nviã kĩ bideĩ nɛ tɛtadiɛ fitaa kamɛ, kĩ bidzi nɛ awã kĩ bɛwɔ́la Yesu a. Ɔmɔa dzi nɛ ye lɔlɔ nyangɛ, ɔbɛbã dzi nɛ ye abɔa kayɔ. ");
INSERT INTO bov_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bivia Maria kĩ, “Boe ɔma, litsa sũ abe?” Maria kpa be mbuayɛ kĩ, “Bɛbɔɛ yĩ Ɔlate bɛnamɛna, ade ĩnyína awã kĩ bɛkɔa ye bɛnamɛna a.” ");
INSERT INTO bov_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kĩ ɛlɛ fukĩĩ eyua a, ɛdani akũ ade ɛmɔ́ Yesu kĩ ɛdzɛ̃ nɛ awã, lɛmɛ ɛtányi kĩ ye yanɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu via ye kĩ, “Boe ɔma, nde sũ abe? Owei awɛ?” Lɛmɛ Maria kɔna kĩ oti a kĩ yadãmɛna awã a yanɛ, foesũ ebi ye kĩ, “Ɔnɔkɔɛ̃, ntɛ nɔ lɛbɔɛ ye ni, bi yĩ awã kĩ oyi ye lɔkɔa nnaabɔɛ ye.” ");
INSERT INTO bov_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ade Yesu vɛ ye kĩ, “Maria!” Ɛdani ɛtsɛlamɔ ye ade ɛlɛ nɛ Hebri tide kamɛ kĩ, “Raboni!” Foe kayɔ nyɛ Fɔtsa ɔtsanɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu bi ye kĩ, “Tata yĩ, kitonɛkĩ ntámuniki nnaa ode nɛ Nda sɛkɛ̃ tɔ̃. Lɛmɛ naa nwaɛ̃ amɛ sɛkɛ̃ kabi be kĩ mmuniki manaa oti a kĩ ɛnyɛ Nda mɔ mi Ɔlɛga, yĩ Baguma mɔ mi Baguma a sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Foesũ Maria Magdalani a nabi fɔtsa bakɔlɛnɛ a kĩ ɛmɔ́ Ɔlate a, ade ebi be fɔlɛtsa a kĩ Yesu bi ye a flee a. ");
INSERT INTO bov_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nɛ Ɛkwansieda a na olobe a, fɔtsa bakɔlɛnɛ a kpɔta nɛ kɔla kamɛ, ade bɛbalɛ onyukpɛ̃ tupunu a flee, kitonɛkĩ bɛkavila Yudafɔ banɔkɔɛ̃ a. Lɛtalɛta Yesu yanɛ ɛdza nɛ be kayite, ade ebi be kĩ, “Lukudɔ litomɔ mi.” ");
INSERT INTO bov_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kĩ ɛlɛ fukĩĩ eyua a, ɛkɔa ye awɛ mɔ sɛklabi ɛtsa be. Adeke kawɔlɛ de fɔtsa bakɔlɛnɛ a kĩ bɛmɔ́ Ɔlate a. ");
INSERT INTO bov_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu buki ebi be kĩ, “Lukudɔ litomɔ mi! Ndɛ ayekĩ Nda do yĩ a, ade aye mado mi a.” ");
INSERT INTO bov_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Adeke ɛwɛya eko nɛ be akũ, ɛlɛ kĩ, “Mitɛ Hũhũ Kpalɛwa a. ");
INSERT INTO bov_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ntɛ mikɔa bati tɔkpa mite be ni, bɛkɔa bite be, lɛmɛ ntɛ mitákɔa be tɔkpa mite be a ni, bɛtákɔa te bite be.” ");
INSERT INTO bov_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kĩ Yesu ya a, Toma kĩ ɛnyɛ fɔtsa bakɔlɛnɛ ewua-nviã a kamɛ ɔmɔa, kĩ bibuki bavɛ Ata a, tána nɛ ye bade a kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Foesũ fɔtsa bakɔlɛnɛ bɛbã a bi ye kĩ, “Bɔmɔ́ boe Ɔlate a!” Ade Toma bi be kĩ, “Ntɛ ntámɔ ye awɛ kamɛ tiplego fɔɔkpa a, nkɔa lawobi nte nɛ fɔɔkpa a akũ ndo awɛ nɛ ye sɛklabi ni, nláatɛ ndo da.” ");
INSERT INTO bov_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nɛ fuwi ɛlɛ̃ liti a, fɔtsa bakɔlɛnɛ a buki bɛkpɔta nɛ kɔla a kamɛ, ade Toma lɛmɛ na nɛ be kamɛ a. Bɛbalɛ tupunu a flee, lɛmɛ Yesu yadza nɛ be kayite ade ɛlɛ kĩ, “Lukudɔ litomɔ mi!” ");
INSERT INTO bov_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Adeke ebi Toma kĩ, “Kɔa nɔ lawobi kate nɛ awĩ, kadã yĩ awɛ kamɛ. Yo kɔkpɔ kado awɛ nɛ yĩ sɛklabi kamɛ. Fɔ̃ atsindze katɛ, lɔkɔa katɛ kado!” ");
INSERT INTO bov_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma bi ye kĩ, “Yĩ Ɔlate mɔ yĩ Baguma!” ");
INSERT INTO bov_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ade Yesu bi ye kĩ, “Ayekĩ ɔmɔ́ yĩ sũ ɔtɛ odo. Baguma hila bikĩ bɛtámɔ yĩ, lɛmɛ bɛtɛ bido a!” ");
INSERT INTO bov_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nɛ ɔnɔkɔali kamɛ ni, Yesu kɛna awãwã fɔtsa bɛbã pii nɛ ye fɔtsa bakɔlɛnɛ a anɛ, kĩ bɛtátsɛlɛ bido nɛ ovoli kĩĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lɛmɛ bɛtsɛlɛ fukĩĩ biyi ayekĩ míatɛ mido kĩ Yesu nyɛ Kristo, Baguma Obi, ade mitɛ ye mido ni, míatsã ye akũ mina nkpã kĩ ɛla kawũna a. ");
INSERT INTO bov_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ke liti a, Yesu buki ɛnyɛ ye akũ ɛtsa ye fɔtsa bakɔlɛnɛ nɛ Tiberia Lutubu Baũ a abuĩ. Ayekĩ ɛnyɛ ye akũ ɛtsa a nyɛ. ");
INSERT INTO bov_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Luwi a, ye fɔtsa bakɔlɛnɛ badi kpɔta. Ade be nyɛ Simon Petro, Toma kĩ bavɛ Ata obi, mɔ Nataniel kĩ eto Kana nɛ Galilea tite akũ, mɔ Zebedeo babi mɔ Yesu fɔtsa bakɔlɛnɛ bɛbã nviã. ");
INSERT INTO bov_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ade Simon Petro bi be kĩ, “Manaata asau.” Bibi ye kĩ, “Bɔ́atomɔ nɔ bɔnaa.” Foesũ bɛnawo nɛ ɔkɔlɔ kamɛ bɛnaa, lɛmɛ lɛnyɛ a flee bɛtányɛ lɛtsama. ");
INSERT INTO bov_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kĩ kade aya kanyina kɔ̃ a, Yesu ya ɛdzɛ̃ nɛ ɔwɔ abuĩ, lɛmɛ fɔtsa bakɔlɛnɛ a linyína kĩ Yesu yanɛ. ");
INSERT INTO bov_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ade evia be kĩ, “Bapopo, mbɔɛɛ mitányɛ kɔfɔabi kudima?” Bɛkpa ye mbuayɛ kĩ, “Oowo!” ");
INSERT INTO bov_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu bi be kĩ, “Mita asau nɛ ɔkɔlɔ a sɔmɔna sɛmakɛ lɔkɔa míana kɔfɔabi a kudi.” Ade bɛta asau a bɛnyɛ kɔfɔabi beblebee kĩ bɛtápuli bɛvɛlɛ bɛnɛmɛna. ");
INSERT INTO bov_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Fɔtsa ɔkɔlɛnɛ a kĩ Yesu látunɔ kalɛ a bi Petro kĩ, “Boe Ɔlate a yanɛ!” Kĩ Petro nu kĩ boe Ɔlate yanɛ a, ɛbɔɛ ye atadiɛ anyanglede efili nɛ kate, kitonɛkĩ edzi ɔdzɔ, ade ɛvɛnya ewo nɛ mui a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fɔtsa bakɔlɛnɛ nkaɛ a ta ɔkɔlɔ a, bɛvɛlɛ asau a kĩ eyi mɔ kɔfɔabi a bɛyamɛna nɛ ɔwɔ abuĩ a. Awã kĩ bɛna a mɔ ɔwɔ abuĩ lɛlá lugo, fɔ́ana ndɛ abasam ɔha. ");
INSERT INTO bov_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kĩ biduma nɛ ɔkɔlɔ a kamɛ a, bɛmɔ́ kĩ bɛtɛna futuã fi kĩ kɔfɔabi teĩ nɛ foe akũ, ade abodoo adi lɛmɛ waa nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ade Yesu bi be kĩ, “Mikɔa kɔfɔabi a kĩ minyɛ finyaa kudi miyamɛna.” ");
INSERT INTO bov_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petro wo nɛ ɔkɔlɔ a kamɛ, ɛnavɛlɛ asau a ɛyamɛna nɛ lɔwɔ tuni. Kɔfɔabi baũ baũ ɔha mɔa mɔ aduenum ɛlalɛ yi asau a. Titɔ kĩ kɔfɔabi a pɔnɛ malo ni, asau a tákpeli. ");
INSERT INTO bov_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ade Yesu bi be kĩ, “Miyaanya.” Lɛmɛ fɔtsa bakɔlɛnɛ a kamɛ odima tádo ɔwɔlɛ evia ye kĩ, “Owei anɛ?” kitonɛkĩ binyina kĩ Boe Ɔlate a yanɛ. ");
INSERT INTO bov_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Foesũ Yesu nabɔɛ abodoo a ɛkɔa ɛkpa be, ade ayea ɛbɔɛ kɔfɔabi a lɛmɛ ɛkpa be a. ");
INSERT INTO bov_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ade fukĩĩ nyɛ lɛlade kĩ Yesu nyɛ ye akũ ɛtsa ye fɔtsa bakɔlɛnɛ, kĩ Baguma dzɛla ye etomɛna kanɔkpa a. ");
INSERT INTO bov_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kĩ bɛnya biyua a, Yesu via Simon Petro kĩ, “Simon, Yona obi, awɛ yĩ kalɛ kaba ayekĩ bati bɛbã kĩĩ a awɛ yĩ kalɛ a?” Ɛkpa ye mbuayɛ kĩ, “Oo, Boe Ɔlate! Onyina kĩ mawɛ nɔ kalɛ.” Ade Yesu bi ye kĩ, “Dãmɛna yĩ bavelibi akũ.” ");
INSERT INTO bov_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu buki evia ye lɛyade kĩ, “Simon, Yona obi, awɛ yĩ kalɛ?” Petro kpa ye mbuayɛ kĩ, “Oo, Boe Ɔlate! Nɔ mɔawɛ onyina kĩ mawɛ nɔ kalɛ.” Ade Yesu bi ye kĩ, “Dãmɛna yĩ baveli a akũ.” ");
INSERT INTO bov_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu buki evia Petro lɛlalɛde kĩ, “Simon, Yona obi, awɛ yĩ kalɛ?” Petro wo ɔblɔ kitonɛkĩ Yesu via ye lɛlade kĩ, “Awɛ yĩ kalɛ?” Foesũ ebi Yesu kĩ, “Boe Ɔlate, nɔ mɔawɛ onyina lɛtsa nyɛ lɛtsa. Nɔ mɔawɛ onyina kĩ mawɛ nɔ kalɛ!” Ade Yesu bi ye kĩ, “Dãmɛna yĩ baveli a akũ. ");
INSERT INTO bov_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mabi nɔ nɛ ɔnɔkɔali kamɛ kĩ lɔkɔ a kĩ ɔnyɛ opopo a, apuli kafili lima, kanaa kakɔ nyɛ kakɔ kĩ awɛ, lɛmɛ ntɛ ɔdɛ a ni, aadzɛla akpɔ, oti bɛbã lifili nɔ lima, ɛkpã nɔ ɛnamɛna awã kĩ aáwɛ kĩ anaa.” ");
INSERT INTO bov_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu lɛ fukĩĩ ɛkɔa ɛtsa wuda odu a kĩ Petro aaku, ɛkɔa ɛnyɛ Baguma kukũkpalɛ a ɛtsa. Ke liti a, Yesu bi ye kĩ, “Tomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro dani ade ɛmɔ́ fɔtsa ɔkɔlɛnɛ a kĩ Yesu látunɔ kalɛ a kĩ etomɔ be nɛ liti yaya. Ade fɔtsa ɔkɔlɛnɛ kĩĩ lidzi ɛmɛnamɔ Yesu kĩ bidzi bɛkanya, ade evia ye kĩ, “Boe Ɔlate, owei aanyɛ nɔ ɛkpa a?” ");
INSERT INTO bov_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kĩ Petro mɔ́ ye a, evia Yesu kĩ, “Boe Ɔlate, litsa aaya nɛ oti kĩĩ akũ?” ");
INSERT INTO bov_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ade Yesu kpa ye mbuayɛ kĩ, “Ntɛ mawɛ kĩ edzi nkpã kɛnaawo kĩ maaya a ni, fɔwɔdabe tsɛla nɔ akũ? Nɔ kɔ̃, tomɔ yĩ!” ");
INSERT INTO bov_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fɔlɛtsa kĩĩ gba nɛ Yesu batomɛnanɛ a kamɛ kĩ fɔtɔ ɔnyanɛ kĩĩ lɛláaku. Lɛmɛ Yesu tálɛ kĩ ɛláaku, mbom kalɛ ɛlɛ kĩ, “Ntɛ mawɛ kĩ edzi nkpã kɛnaawo kĩ maaya a ni, fɔɔdabe tsɛla nɔ akũ?” ");
INSERT INTO bov_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ade fɔtsa ɔkɔlɛnɛ kĩĩ adi adansiɛ nɛ fɔlɛtsa kĩĩ akũ a, ade ye lɛmɛ lɛtsɛlɛ foe eyi a. Foesũ bunyina kĩ lɛtsa a kĩ ɛlɛ a nyɛ ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Fɔtsa bɛbã pii deĩ kĩ Yesu kɛna. Ntɛ katsɛlɛ bɛtsɛlɛ foe flee biyi fɔmɔa fɔmɔa ni, nkɔna kĩ katinya kĩĩ flee kamɛ malo lɛláana kakokɔ̃ kɛkpa tuvoli a kĩ baatsɛlɛ a.");
INSERT INTO bov_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nwaɛ̃ Tiofilo, nɛ yĩ ovoli ɔtɔnyade a kamɛ a, ntsɛlɛ ntsa lɛtsa nyɛ lɛtsa a kĩ Yesu kɛna mɔ fukĩ ɛtsa, kito nɛ lɔkɔ a kĩ eyi ye adzuma kayɔ, kɛnawo lɔkɔ a kĩ Baguma bɔɛ ye ɛnamɛna ode. Fɔmɔ Baguma bɔɛ ye bɛnamɛna ode a, Yesu tsã Hũhũ Kpalɛwa kɔbɛ̃ akũ ɛtsa ye fɔtɔ banyanɛ a kĩ ɛpau a fɔtsa. ");
INSERT INTO bov_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nɛ ye wuda liti a, ɛnyɛ ye akũ ɛtsa be nɛ tisi pii akũ nɛ fuwi tɛna kamɛ, kĩ atsindze katɛ lɛláa foe kamɛ kĩ edzi nkpã. Ɛlɛmɔ bikĩ bɛmɔ́ ye a kɔdzɛla nɛ Baguma lɛgãkanyakɔ̃ fɔlɛtsa a akũ. ");
INSERT INTO bov_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lɔkɔ a kĩ bɛkpɔta a, esi be mbla kĩ, “Mitadzakũ nɛ Yerusalem, mbom midzi midzɔlɛ Hũhũ Kpalɛwa a kĩ mbi mi kĩ yĩ Ɔlɛga lɛ eyi kĩ yaakpa mi a kaya. ");
INSERT INTO bov_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanes kɔ̃ ni, mui ɛkɔa ɛwɔla bati. Lɛmɛ nɛ fuwi lukũ kamɛ ni, Baguma aakɔa Hũhũ Kpalɛwa ɛwɔla mi.” ");
INSERT INTO bov_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lɔkɔ a kĩ Yesu mɔ ye fɔtɔ banyanɛ a buki bɛkpɔta a, bivia ye kĩ, “Boe Ɔlate, mbɔɛɛ finyaakĩĩ ɔwɛ kĩ ayaamunikimɔ Israelfɔ lɛgãkanyakɔ̃ a ɔkpa be?” ");
INSERT INTO bov_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ade Yesu bi be kĩ, “Fɔtásĩ kĩ mianyi lɔkɔ ĩye fuwi a kĩ yĩ ɔlɛga lɛ eyi ɛkpa kĩ litsedi lɛya a nɛ ye kɔbɛ̃ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lɛmɛ ntɛ Hũhũ Kpalɛwa a yawo nɛ mi kamɛ ni, yaado mi kɔbɛ̃ lɔkɔa milɛ yĩ fɔlɛtsa a nɛ Yerusalem, mɔ Yudea flee mɔ Samaria, kɛnaawo katinya kamɛ tite kawũnakɔ̃.” ");
INSERT INTO bov_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kĩ ɛlɛ fukĩĩ eyua a nɛ be anɛ kamɛ naa, Baguma bɔɛ ye ɛnamɛna ode, ade ɛyɛla nɛ luflututu kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kĩ bɛdza bɛkadã koee kĩ yanaa odetɔ́ kamɛ a, lɛtalɛta banyole nviã badi kĩ bideĩ nɛ fɔtsa ovoe kamɛ nyɛ be akũ bɛtsa be, ");
INSERT INTO bov_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ade bibi be kĩ, “Galileafɔ, nde sũ midzɛ̃ miadã odetɔ́ kamɛ lɔmɔ? Yesu a kĩ Baguma bɔɛ nɛ mi ɔwɛ̃ nɛ awĩ ɛnamɛna ode a, aabuki ɛya nɛ mi sɛkɛ̃ ndɛ ayekĩ mimɔ́ kĩ yanaa ode a.” ");
INSERT INTO bov_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ke liti a, fɔtɔ banyanɛ kĩĩ dzakũ nɛ Kugua Futse Ɔtɔ akũ a bɛnaa Yerusalem ɔmatɔ kamɛ. Kito awã kɛnawo ɔmatɔ a kamɛ ana ndɛ lisikũ sɛkɛ. ");
INSERT INTO bov_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kĩ biwo ɔmatɔ a kamɛ a, bɛnaa be kadzikɔ̃ nɛ abansulu kɔla ode. Bati a kĩ bɛna nɛ awã nyɛ Petro, Yohanes, Yakobo, Andrea, Filipo, Toma, Bartolomeo, Mateo, Yakobo kĩ ɛnyɛ Alfeo obi, mɔ Simon kĩ epili ye kade lɔlɔ, mɔ Yuda kĩ ɛnyɛ Yakobo obi. ");
INSERT INTO bov_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bati kĩĩ flee katsɛna lɔkɔ nyɛ lɔkɔ mɔ kakɔna mɔa, kabɔa mpaɛ kakpa Baguma. Bati a badi lɛmɛ nyɛ batsole mɔ Yesu ɔma Maria, mɔ Yesu bawaɛ̃nyole. ");
INSERT INTO bov_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nɛ fuwi a na kamɛ a, bikĩ bɛtɛ bido a tsɛna, be lidede aawo ndɛ bati ɔha mɔ be tɛya. Ade Petro yidza ɛdza ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nwaɛ̃ amɛ, kɛnɛ kĩ lɛtsa a kĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ, kĩ Hũhũ Kpalɛwa a lɛ eyi ɛtsãmɛna Lɛgã Dawid akũ nɛ Yuda kĩ ye lɛnya bati lɔtɔ bipi Yesu a, fɔya lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda nya boe kamɛ ɔmɔa kĩ boe Ɔlate nyɛ ye kĩ ɛkɛna fɔtɔ banyanɛ adzuma.” ");
INSERT INTO bov_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Lɛmɛ ɛkɛna tɔkpa kĩ ɛnatɛ sika kĩ se bɛkɔa bɛya tite a kĩ te akũ eku a. Ade awã na kĩ eto ode ɛtɔ a, ye lupu tui lɛbɛ̃, ade ke ye fɔmɛtsa flee nɛ fuko nɛ tite a. ");
INSERT INTO bov_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ye wuda a akũ fɔlɛtsa gba nɛ Yerusalem kĩ odi nyɛ odi nu foe. Foesũ awã kĩ ɛnaku ɛwa a bavɛ ke kĩ Akeldamak, foe kayɔ nyɛ Babɔanɛ Tite. ");
INSERT INTO bov_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Foesũ Petro buki ɛlɛ kĩ, “Bɛtsɛlɛ nɛ Dawid Tɔnɔ Ovoli a kamɛ kĩ, ‘Mifɔ̃ ye tɔtɔ tɛwa luto, odima ɛtabuki edzi nɛ te kamɛ.’ Bɛtsɛlɛ lɛmɛ kĩ, ‘Mifɔ̃ oti bɛbã ɛtɛ ye kadzakɔ̃ a.’ ");
INSERT INTO bov_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Foesũ fusĩ kĩ oti bɛbã ɛyaawo nɛ boe kamɛ ndɛ ɔdansini ɛkpa boe Ɔlate Yesu kayidza kato kanɔkpa a. Ade fusĩ lɛmɛ kĩ ɛnya oti kĩ ɛnya boe bati a kĩ bɔtsã butomɛna boe Ɔlate Yesu a kamɛ ɔmɔa, kito lɔkɔ a kĩ Yohanes de lɛtsã nɛ mui kawɔla amaniɛ akũ kɛyawo lɔkɔ a kĩ Baguma bɔɛ Yesu nɛ boe sɛkɛ̃ ɛnamɛna ode a.” ");
INSERT INTO bov_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Foesũ bɛnyɛ bati nviã ade be nyɛ Matias mɔ Yosef kĩ bavɛ Barsaba kĩ babuki kavɛ Yusto a. ");
INSERT INTO bov_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ade bɛbɔa mpaɛ bɛvɛ Baguma kĩ, “Boe Ɔlate, nɔ nyina odi nyɛ odi lɔlɔ kamɛ. Tsa boe bati nviã kĩĩ kamɛ ekĩ ɔnyɛ kĩ ɛdza ndɛ fɔtɔ ɔnyanɛ nɛ kadzakɔ̃ a kĩ Yuda fɔnɛ awɛ eyi ɛnaa awã kĩ kɛfɛta ye a.” ");
INSERT INTO bov_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kĩ bɛta bavulibi nɛ bati nviã kĩĩ fɔlɔ a, fɔyake nɛ Matias akũ, ade bɛkɔa ye bibumɛna fɔtɔ banyanɛ ewua-odi a akũ a. ");
INSERT INTO bov_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kĩ Pentekoste luwi a wo ɔtɔ a, batɛ badonɛ a flee natsɛna nɛ kakɔ mɔapɛ. ");
INSERT INTO bov_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Deedimɔapɛ, binu litsedi nkã ndɛ ayekĩ ɔwɛ kpale avũ a nɛ odetɔ́ kamɛ, ade ɔwɛ kĩĩ tɛ tɔtɔ a flee kĩ te kamɛ bɛna a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bɛmɔ́ litsedi ndɛ fi fɔmɛ kĩ fɔka fudzi nɛ odi nyɛ odi akũ. ");
INSERT INTO bov_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ade Hũhũ Kpalɛwa tɛ be kamɛ flee, ade bido kɔdzɛla kalɛ awɛ nɛ tide futefute kamɛ, ndɛ ayekĩ Hũhũ a kpa be a. ");
INSERT INTO bov_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ade nɛ lɔkɔ a na kamɛ a, Yudafɔ kĩ bavila Baguma kĩ bito fude kumɛkumɛ nɛ katinya kamɛ flee a ya bideĩ nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Foesũ kĩ binu ɔwɛ baũ kĩĩ nkã a, bati pii bɔa obũ bɛnakpɔta nɛ awã. Kĩ binu kĩ batɛ badonɛ kĩĩ kalɛ kɔdzɛla nɛ be kamɛ odi nyɛ odi tide kamɛ a, fɔkɛna be wãwã. ");
INSERT INTO bov_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nɛ fukĩĩ sũ libe wo be, bɛkɛna saa, ade bido akũ kavia awɛ kĩ, “Midã, mbɔɛɛ nnɛ́ Galileafɔ bati kĩĩ flee anɛ? ");
INSERT INTO bov_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mɔ nde fɔya mɔ bɔanu kĩ bɛlamɛna kɔdzɛla kalɛ nɛ boe tide kamɛ? ");
INSERT INTO bov_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Bɔnyɛ Partiafɔ mɔ Mediafɔ mɔ Elamfɔ ade boe kamɛ badi to Mesopotamia mɔ Yudea mɔ Kapadokia mɔ Ponto mɔ Asia mɔ Frigia mɔ Pamfilia mɔ Egipte mɔ Libia kakɔ a kĩ kifuã Kirene. Boe badi buto Roma ");
INSERT INTO bov_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","kĩ bɔnyɛ Yudafɔ ĩye bati kĩ bɛdani akũ bɛkɛna Yudafɔ, boe badi bɔnyɛ Kretafɔ mɔ Arabiafɔ. Ade boe flee bɔanu kĩ bɛlamɛna Baguma awãwã fɔtsa kalɛ nɛ boe tide kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ade kĩ fɔkɛna be saa mɔ basaa lɔmɔ a, bɛkavia be akũ kĩ, “Litsa fɔlɛtsa nɛ awĩ a?” ");
INSERT INTO bov_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lɛmɛ bikĩ bɛdza nɛ awã badi di be nsekuo bɛlɛ kĩ, “Bavɛ lamɛna be kawugɛla.” ");
INSERT INTO bov_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ade awã mɔ Petro yidza ɛdza mɔ be ewua-odi a, ɛdzɛla odo ɛlɛ kĩ, “Mi Yudafɔ mɔ mi a flee kĩ midzi nɛ Yerusalem, mawɛ kĩ manyɛ fɔlɛtsa kĩ flee kayɔ ntsa mi, foesũ mitse katse wĩ. ");
INSERT INTO bov_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nnɛ́ bavɛ bati kĩĩ wuga ndɛ ayekĩ mikɔna a. Midã kĩ ade owi fɔmɔ ɔnɔnɛ tɔdɔũ evedi bɔa a. ");
INSERT INTO bov_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mbom lɛtsa a kĩ de milamɛna kamɔ nɛ awĩ a nyɛ fukĩ Baguma Onukpɛ̃ Ɔnyɛnɛ Yoel lɛ eyi anɛ kɔkɔɛ a kĩ, ");
INSERT INTO bov_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Baguma lɛ kĩ, “Nɛ fuwi nkaɛ a kamɛ ni, maado yĩ Hũhũ ɛyaawo nɛ bati flee kamɛ, lɔkɔa mi babinyole mɔ babitsole aade lɛtsã nɛ yĩ kalɛ a akũ. Mi bapopo aamɔ ode fɔtsa kɛnawa nɛ hũhũ kamɛ, ade mi banɔkɔɛ̃ lɛmɛ aawa fɔda a. ");
INSERT INTO bov_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɔnɔkɔali, nɛ fuwi a na kamɛ ni, yĩ Hũhũ aatɛ mi basumunɛ batsole mɔ banyole flee kamɛ, lɔkɔa baadɛ lɛtsã nɛ yĩ fɔlɛtsa akũ. ");
INSERT INTO bov_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ade maafɔ̃ awãwã fɔtsa lɛnɛ nɛ odetɔ kamɛ mɔ tite akũ. Míamɔ babɔanɛ, mɔ fi mɔ ɔnyɔ kusuu kĩ fɔgba nɛ tite akũ. ");
INSERT INTO bov_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Suwa aake ɔtũ, odetɔ anɛ aadani ngbã ndɛ babɔanɛ aye, ade owi fɔmɔ Baguma Luwi kpale mɔ kukũkpalɛ a aaya a. ");
INSERT INTO bov_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɛ lɔkɔ a na kamɛ ni, odi nyɛ odi kĩ yaavɛ Ɔlate a dĩ mɔ evia ye kɔnyakamɔ ni, yaana katɛ.” ’ ” ");
INSERT INTO bov_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ade Petro buki ɛlɛ kĩ, “Nwaɛ̃ amɛ Israelfɔ, mitse fɔlɛtsa kĩĩ. Yesu Nazaretni nyɛ Oti a kĩ Baguma pau, kĩ ye deĩ Baguma kɔbɛ̃. Ɛnyɛ kɔbɛ̃ kĩĩ ɛtsa mi nɛ ye awãwã mɔ nsɛntsɛlɛni fɔtsa kɛnawa kamɛ, ndɛ ayekĩ mi mɔawɛ minyina lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lɛmɛ nɛ Baguma kawɛ mɔ nhihiɛ onukpɛ̃ ni ɛfɔnɛ ye awɛ ɛkpa mi, ade mitsã tɔkpa bakɛnanɛ akũ mikɔ ye, nɛ kĩ mibɔa ye nɛ asendua akũ a. ");
INSERT INTO bov_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lɛmɛ Baguma buki ɛdzɛla ye etomɛna banɔkpa kamɛ ade ɛnɛ́ nɛ wuda awɛ kamɛ a, kitonɛkĩ wuda tápuli ɛfɔ̃ ɛkahɔ nɛ kanɔkpa da. ");
INSERT INTO bov_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ade lɛgã Dawid lɛ eyi nɛ ye akũ kĩ, ‘Mamɔ kĩ yĩ Ɔlate dzɛ̃ nɛ yĩ anɛ kamɛ lɔkɔ nyɛ lɔkɔ Nɛ kĩ ɛdzɛ̃ nɛ yĩ sɔmɔna ndɛ yĩ obumɛnanɛ sũ maávila. ");
INSERT INTO bov_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɛ fukĩĩ sũ kawɔlɛ de yĩ ade fɔfɔ̃ mamu ye luwi daa. Titɔ kĩ sukɛna pupulidza manɛ malo ni, maadzi nɛ kɔnɛte kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kitonɛkĩ ɔláafɔ̃nɛ yĩ ɔkla oyi nɛ kanɔkpade, ade ɔláafɔ̃ nɔ Obi Kpalɛwa sukɛna lɛvɔ̃ nɛ linikɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nɔ lɛtsa yĩ nkpã osi a, ade nɔ sɛkɛ̃ kana aafɔ̃ mmɔ́ kawɔlɛ paa.’ ");
INSERT INTO bov_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Foesũ, nwaɛ̃ amɛ, mabi mi yededeede kĩ boe ɔwanyɔ Lɛgã Dawid ku, bibila ye, ade ye kuni waa nɛ boe kamɛ kɛyawo nviã kĩ a. ");
INSERT INTO bov_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lɛmɛ kĩ ɛnya Baguma onukpɛ̃ ɔnyɛnɛ sũ ni, enyi lɛtsa a kĩ Baguma lɛ eyi kĩ yaakɛna ɛkpa ye. Baguma lɔ fubo kĩ yaakɛna Dawid kasinu a kamɛ obi mɔa odi ɛyaadzi ɛnya lɛgã ndɛ Dawid aye. ");
INSERT INTO bov_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nɛ kĩ Dawid nyi fukĩĩ ɛnyamɛna lɔtɔ sũ ni, ɛlɛ eyi kĩ Kristo aayidza eto banɔkpa kamɛ. Ɛlɛ kĩ, ‘Baguma táfɔnɛ ye awɛ ɛkahɔ nɛ kanɔkpa, ade ye sukɛna lɛmɛ távɔ̃ nɛ linikɛ kamɛ a.’ ");
INSERT INTO bov_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ade Yesu kĩĩ Baguma dzɛla etomɛna banɔkpa kamɛ a, ade boe a flee bɔnyɛ foe akũ adansifɔ a. ");
INSERT INTO bov_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Finyaakĩĩ ni, Ɔlɛga Baguma kpa ye lɔnɔkɔɛ̃ kadzikɔ̃ nɛ ye sɔmɔna, ade ɛkɔa ye Hũhũ ɛkpa ye ndɛ ayekĩ ɛlɛ eyi a. Foesũ ye malo ɛkɔa ye Hũhũ a, eko nɛ boe akũ. Ade foesũ mimɔ́, minu lɛmɛ lɛtsa a kĩ lɛlamɛna kaya nɛ awĩ a. ");
INSERT INTO bov_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Nnɛ́ Dawid liyidza ɛnaa ode, mbom ye lɛlɛ kĩ, ‘Baguma bi yĩ Ɔlate kĩ, “Dzi nɛ yĩ sɔmɔna kɛnaawo lɔkɔ a kĩ maakɔa nɔ bakesĩnɛ nkɛna ndɛ nɔ abɔa katekɔ̃.” ’ ");
INSERT INTO bov_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Foesũ mawɛ kĩ mi Israelfɔ flee minyi kĩ Yesu a kĩ mibɔa nɛ asendua akũ a, ade ye Baguma kɛna Ɔlate mɔ Kristo Oti a Kĩ Bɛbɔa Tɔdɔ̃ a.” ");
INSERT INTO bov_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kĩ bati kĩĩ nu Petro fɔlɛtsa a, fɔha be paa. Foesũ bivia ye mɔ fɔtɔ banyanɛ bɛbã a kĩ, “Nwaɛ̃ amɛ, litsa kɛnɛ kĩ bɔkɛna?” ");
INSERT INTO bov_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ade Petro bi be kĩ, “Fusĩ kĩ mi kamɛ odi nyɛ odi ɛdani ɔwɔlɛ kamɛ ɛtɛ Baguma edo, lɔkɔa ɛtɛ mui kawɔla amaniɛ nɛ Yesu Kristo dĩ akũ ayekĩ Baguma aakɔa ye titikpa ete ye, ɛtɛ Baguma futetsa a kĩ fɔnyɛ Hũhũ Kpalɛwa a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kitonɛkĩ lɛtsa a kĩ Baguma lɛ eyi kĩĩ a waa fɔkpa mi, mɔ mi babi mɔ bikĩ bito mɔ lugo, mɔ bikĩ boe Ɔlate Baguma aavɛ kĩ bɛya nɛ ye sɛkɛ̃ a.” ");
INSERT INTO bov_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ade Petro dɛ be pii ɛlɛ kĩ, “Minyɛ mi akũ mitomɛna sɔtɔ kavɛlɛ a kĩ saaya nɛ nviã katinya bati kpa kĩĩ akũ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɛ fukĩĩ sũ bati pii nɛ be kamɛ tɛ Petro fɔlɛtsa a bido, ade bɛwɔla be mui nɛ Yesu dĩ akũ a. Be lidede aana ndɛ mpim ɛlalɛ kĩ bɛkɔa bibumɛna batɛ badonɛ a akũ nɛ luwi a. ");
INSERT INTO bov_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bɛfɔnɛ be akũ awɛ bɛkpa fɔtɔ banyanɛ a bɛkatsa be fɔtsa, ade bɛkabɔa mpaɛ mɔ kanya kakpɔta mɔ ɔmɔa kakɛna a. ");
INSERT INTO bov_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nɛ kĩ fɔtɔ banyanɛ a kakɛna awãwã fɔtsa mɔ nsɛntsɛlɛni pii sũ ni, fɔkɛna bati pii wãwã. ");
INSERT INTO bov_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Batɛ badonɛ kĩĩ flee katsɛna luwi daa kakɛna lɛtsa mɔa, ade bɛkasɛ̃ be fɔtsa kakpa akũ a. ");
INSERT INTO bov_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ntɛ ɔsa bɛnɔ be akũ fɔtsa fudi ni, basɛ̃ sika a kakpa akũ nɛ be kamɛ odi nyɛ odi kasĩ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bɛkanaa Baguma afɔliɛ kabɔakɔ̃ a luwi daa, ade bɛkatsɛna nɛ kutsu kutsu kamɛ nɛ be tɔtɔ kamɛ kanya kakpɔta nɛ kawɔlɛ mɔ akũ kadɔla kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ade bɛkanyɛ Baguma kɔlɛ, kamu ye lɛmɛ a. Bati flee kɔa obu bɛkpa be. Luwi daa boe Ɔlate akɔa bikĩ bɛtɛ bido a kĩ ɛtɛ a kayaabumɔ be. ");
INSERT INTO bov_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Luwi a Petro mɔ Yohanes naa Asɔli Kɔla kamɛ nɛ lɔkɔ a kĩ Yudafɔ abɔa mpaɛ a kamɛ. Fɔ́ana ndɛ olobe tɔdɔũ ɛlalɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kĩ biwo Asɔli Kɔla onyukpɛ̃ a kĩ bavɛ Onyukpɛ̃ Mɔ Kalɛ a, bɛmɔ́ onyole odi kĩ eveliveli kito ye lɛmawi, kĩ ɛwaa nɛ awã. Ye bati abɔɛ ye kanaayi nɛ awã luwi daa ayekĩ yaakawã sika katomɛna bikĩ batɛ̃ nɛ awã a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kĩ Petro mɔ Yohanes atɛ̃ a, ɛwã be sika. ");
INSERT INTO bov_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bɛfɔ̃ bɛdza bɛdã ye koee ade Petro bi ye kĩ, “Dã boe anɛ kamɛ!” ");
INSERT INTO bov_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ade oti a dzɛla anɛ ɛdã be mɔ kakɔna kĩ baakpa ye litsedi. ");
INSERT INTO bov_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petro bi ye kĩ, “Nla sika sidima kĩ makpa nɔ, lɛmɛ maakpa nɔ lɛtsa a kĩ ndeĩ a! Nɛ Yesu Kristo Nazaretni dĩ akũ ni, mabi nɔ kĩ yidza kadza, katsã!” ");
INSERT INTO bov_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ade Petro pi oti a nɛ sɔmɔna kɔkpɔ ɛdzɛla ye a. Deedimɔapɛ ye abɔa mɔ anya flee de ɔsĩ, ");
INSERT INTO bov_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ade ɛvɛnya ɛdza nɛ abɔa akũ, edo katokatɛ̃ awɛ a. Etomɔ be biwo nɛ Asɔli Kɔla a kamɛ ade ɛkavɛnya kamu Baguma lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bati a kĩ bɛna nɛ awã a mɔ́ ye kĩ ɛtsɛ̃, ade binu ayekĩ ɛkamu Baguma a. ");
INSERT INTO bov_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kĩ bɛmɔ́ biyi ɔsũ kĩ ye lɛkadzi nɛ Onyukpɛ̃ Mɔ Kalɛ ɔwɛ̃ kawã fɔtsa a, fɔnyɛnɛ be flee akũ ade bɛkɛna saa nɛ lɛtsa a kĩ lɛya nɛ ye akũ a. ");
INSERT INTO bov_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bati pii wula atsɛ bɛnaa be sɛkɛ̃ nɛ awã kĩ bavɛ Lɛgã Salomo Mblada nɛ Asɔli kɔla kamɛ a. Bɛyamɔ oti a kĩ ɛmanɛmɔ Petro mɔ Yohanes tsɛmɛtsɛmɛ ade ye kasaɛ a kɛna be saa a. ");
INSERT INTO bov_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kĩ Petro mɔ́ bati kĩĩ a ebi be kĩ, “Nwaɛ̃ amɛ Israelfɔ, litsa koũ liti lakɛna mi wãwã nɛ fɔtsa kĩĩ akũ? Nde sũ miadã boe bãã lɔmɔ ndɛ bati kpalɛwa bɔanɛ? Mitakɔna kĩ boe awɛ kɔbɛ̃ bɔkɔa bɔtsa oti kĩĩ! ");
INSERT INTO bov_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Baguma a kĩ ɛnyɛ Abraham, Isak mɔ Yakob mɔ boe bawanyɔ Baguma a do ye Ɔsumunɛ Yesu obu. Ade ye obi Yesu mikɔa mikpa bɛkɔ a. Misĩ ye nɛ Pilato anɛ kamɛ, titɔ kĩ minyina ye nɛ kĩ Pilato wɛ kĩ yafɔnɛ ye awɛ kufɛ. ");
INSERT INTO bov_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Misĩ oti kpĩĩ mɔ oti kpalɛwa a, ade mitunɔ kĩ ɛfɔnɛ owudini awɛ ɛkpa mi nɛ ye kadokɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mifɔ̃ bɛkɔ oti a kĩ yakpa nkpã a, lɛmɛ Baguma dzɛla ye etomɛna banɔkpa kamɛ. Boe awɛ a bɔmɔ́ ye mɔ anɛ. ");
INSERT INTO bov_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu dĩ kɔbɛ̃ akũ futo mɔ oti kĩ miamɔ kĩĩ, minyina lɛmɛ a na akũ ɔsĩ. Nɛ kĩ ɛtɛ Yesu edo sũ ni, boe Ɔlate tsa ye nɛ mi anɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nwaɛ̃ amɛ, finyaakĩĩ ĩnyina kĩ mi mɔ mi banɔkɔɛ̃ mikɛna fukĩĩ nɛ Yesu akũ nɛ katanyi kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lɛmɛ Baguma lɛ eyi anɛ kɔkɔɛ ɛtsãmɛna ye onukpɛ̃ banyɛnɛ flee akũ kĩ ye Kristo a aatsã lubo kamɔ kamɛ. Ade foesũ ɛfɔ̃ fɔya nɛ foe kamɛ lɔmɔ a. ");
INSERT INTO bov_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Foesũ midani tɔwɔlɛ kamɛ mimuniki miyaatómɔ Baguma ayekĩ yaakɔa mi tɔkpa ete mi. Ntɛ mikɛna lɔmɔ ni, fɔ́afɔ̃ mina hũhũ kamɛ kɔbɛ̃ mitomɛna boe Ɔlate sɛkɛ̃, ayekĩ yaado Yesu a kĩ ye nyɛ Kristo a nɛ mi sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kɛnɛ kĩ Yesu ɛna nɛ ode kɛnawo lɔkɔ a kĩ Baguma lɔla lɛtsa nyɛ lɛtsa nɛ de osi akũ ndɛ ayekĩ ye onukpɛ̃ banyɛnɛ kpalɛwa a kĩ bidzi nkpã kɔkɔɛ a lɛ biyi a. ");
INSERT INTO bov_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kitonɛkĩ Mose lɛ kĩ, ‘Mi Ɔlate Baguma aanyɛ onukpɛ̃ ɔnyɛnɛ odi ndɛ yĩ aye etomɛna mi kamɛ. Foesũ mitse lɛtsa nyɛ lɛtsa a kĩ yaabi mi. ");
INSERT INTO bov_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Odi nyɛ odi kĩ ɛláatse ye kalɛ ni, baanyɛ ye nɛ Baguma bati a kamɛ lɔkɔa bɛwɔla ye mɔ odu mɔ odu.’ ");
INSERT INTO bov_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Baguma onukpɛ̃ banyɛnɛ flee a, kito Samuel akũ kɛyawo bikĩ bitomɔ ye a, lɛ biyi bɛnyamɛna lɔtɔ nɛ fɔtsa a kĩ fɔlamɛna kaya nɛ nviã fuwi kĩĩ kamɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Baguma apam a kĩ ɛkɛna mɔ mi bawanyɔ ɛtsãmɛna ye onukpɛ̃ banyɛnɛ akũ a nyɛ mi fude, ade mi aanya tsɛfã nɛ apam kĩĩ fɔtsa akũ a. Ebi Abraham kĩ fɔ́atsã ye ɔwa akũ yaakɔa nhila ɛkpa katinya kamɛ bati flee. ");
INSERT INTO bov_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Foesũ kĩ Baguma pau ye Ɔsumunɛ a ni, mi sɛkɛ̃ ɛnya lɔtɔ edo ye kĩ ɛkɔa nhila ɛkpa mi, lɔkɔa ɛfɔ̃ mi kamɛ odi nyɛ odi ɛfɔ̃ tɔkpa kakɛna.” ");
INSERT INTO bov_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nɛ lɔkɔ a kĩ Petro mɔ Yohanes dza bɛkabi bati a fɔlɛtsa a, Yudafɔ basɔfɔ badi, Asɔli kɔla a akũ ɔdãmɛnanɛ ɔnɔkɔɛ̃ mɔ Zadukifɔ badi ya nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kĩ binu kĩ Petro mɔ Yohanes katsa fɔtsa nɛ Yesu kayidza fɔlɛtsa akũ, katsa kĩ banɔkpa aayidza bidzi nkpã a, bɛna kalɔkpa paa! ");
INSERT INTO bov_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Foesũ bipi be, lɛmɛ kĩ kade dɔ sũ ni, bɛkɔa be bido nɛ kɔla kamɛ kɛnawo kĩ kade nyina. ");
INSERT INTO bov_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lɛmɛ bati pii kĩ binu be fɔlɛtsa a badi tɛ kalɛ wĩ a bido. Banyole batɛ badonɛ a kĩ bɛtɛ bido a pɔ biwo ndɛ mpim elo. ");
INSERT INTO bov_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ade kĩ kade nyina a, Yudafɔ banɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ mɔ mbla batsanɛ a yakpɔta nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bɛyatsa fɔlɔ mɔ Ɔsɔfɔnɔkɔɛ̃ Flee Hana mɔ Kayafa, Yohanes mɔ Aleksandro mɔ Ɔsɔfɔnɔkɔɛ̃ Flee a akũ bati badi. ");
INSERT INTO bov_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ade bɛnyɛ fɔtɔ banyanɛ a bɛyadzɛla nɛ be anɛ kamɛ a. Bivia be kĩ, “Osi ɔwɔdabe akũ mikɛna fukĩĩ? Owei dĩ akũ ĩye ɔwa kɔbɛ̃ akũ mikɛna fɔtsa kĩĩ?” ");
INSERT INTO bov_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ade Petro kĩ Hũhũ Kpalɛwa tɛ ye kamɛ a yidza ɛlɛ kĩ, “Boe lɔtɔ banyanɛ mɔ ɔmaĩ banɔkɔɛ̃, ");
INSERT INTO bov_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ntɛ miwɛ fɔlɛtsa kamɛ kanyɛ nɛ lɛtsa wĩ a kĩ bɔkɛna bɔkpa oti kĩ eveliveli mɔ ayekĩ bɛtsa ye a akũ ni, ");
INSERT INTO bov_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mitse mbi mi, lɔkɔa Israelfɔ flee binyi kĩ, Yesu Kristo Nazaretni a kĩ mibɔa nɛ asendua akũ, lɛmɛ Baguma dzɛla ye etomɛna banɔkpa kamɛ a, ye dĩ akũ fɔtsã sũ mɔ oti kĩĩ na akũ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ade Yesu kĩĩ akũ Katsɛlɛ Kpalɛwa lɛ kĩ, ‘De a kĩ fɔla bakenɛ sĩ a, ade de lɛdani kɔla akũ de titiliwu a.’ ");
INSERT INTO bov_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ye odi nyɛ bati Ɔtɛnɛ, ade otidziwa odima lɛláa tite akũ kĩ ye akũ bɔ́atsã bɔna nkpã a.” ");
INSERT INTO bov_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kĩ lɔtɔ banyanɛ mɔ ɔmaĩ banɔkɔɛ̃ a mɔ́ ayekĩ Petro mɔ Yohanes lɛ kɔdzɛla mɔ kɔbɛ̃, titɔ kĩ bɛtánaa sukuu malo ni, fɔkɛna be saa. Ade bɛmɔ́ biyi ɔsũ kĩ bɛtsã bitomɔ Yesu a. ");
INSERT INTO bov_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lɛmɛ kĩ bɛmɔ́ oti a kĩ bɛtsa a kĩ ɛdzɛ̃ nɛ be ɔwɛ̃ sũ ni, bɛtápuli bɛlɛ kadima. ");
INSERT INTO bov_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bibi be kĩ bɛnɛ nɛ katsɛnakɔ̃ a, kite be odi bɛkapi adzuni. ");
INSERT INTO bov_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Badi via kĩ, “Litsa bɔakɛna bati kĩĩ? Bɔláapuli busĩ kĩ lɛtsa a kĩ bɛkɛna a lɛnyɛ́ awãwã fɔtsa, kitonɛkĩ odi nyɛ odi nɛ Yerusalem nyina, enu kalɛ kĩĩ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nɛ kĩ fɔlɛtsa kĩ fɔtagba sũ ni, mifɔ̃ budo be libe kĩ bɛtabi odima kalɛ nɛ Yesu dĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ade bibuki bɛvɛ be bɛnamɛna katsɛnakɔ̃ a bisĩ be mbla kĩ bɛtabuki bibi odima kalɛ ĩye bɛtsa fɔtsa nɛ Yesu dĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lɛmɛ Petro mɔ Yohanes kpa mbuayɛ kĩ, “Mi awɛ mibu fukĩ fɔfɛta nɛ Baguma anɛ kĩ bɔkɛna, mi ɔlɛdo butse, mbɔɛɛ kĩ Baguma ode? ");
INSERT INTO bov_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lɛtsa a kĩ de bɔmɔ́, bunu lɛmɛ a, bɔláapuli busua onukpɛ̃ nɛ de akũ budzi kulokulo.” ");
INSERT INTO bov_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ade awã mɔ́ banɔkɔɛ̃ a kã be anɛ mɔ ɔsĩ mɔ ɔsĩ, bɛfɔnɛ be awɛ a. Nɛ kĩ bati a flee kamu Baguma nɛ lɛtsa a kĩ lɛya a akũ sũ ni, bɛtápuli bɛna osi a kĩ ye akũ baatsã bɛvɛlɛ be sɔtɔ. ");
INSERT INTO bov_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oti a kĩ ye bɛtsa a, tɛ fɔba futeli tɛna. ");
INSERT INTO bov_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kĩ bɛfɔnɛ Petro mɔ Yohanes awɛ bɛnaa be bati sɛkɛ̃ a, bɛbɔa be amandiɛ nɛ lɛtsa a kĩ basɔfɔnɔkɔɛ̃ mɔ ɔmaĩ banɔkɔɛ̃ a bi be a akũ. ");
INSERT INTO bov_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ade batɛ badonɛ a flee kpɔta bɛbɔa mpaɛ bɛvɛ Baguma bɛlɛ kĩ, “O boe Ɔlate, nɔ kĩ ɔkɛna tite mɔ ode, mpo mɔ fɔtsa a kĩ fudeĩ nɛ ye kamɛ, ");
INSERT INTO bov_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","nɔ lɛtsã Hũhũ Kpalɛwa akũ ɔfɔ̃ boe ɔwanyɔ Dawid, nɔ ɔsumunɛ lɛ eyi kĩ, ‘Nde sũ katinya kamɛ bati de adɔ̃ mɔ bati tsa fɔlɔ nɛ tɔkpa akũ pupulidza? ");
INSERT INTO bov_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Katinya kamɛ fɔgã flee kɛna ɔmɔa ade biyidza bɛdzɛ̃ nɛ boe Ɔlate mɔ ye Kristo akũ a.’ ");
INSERT INTO bov_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Fɔnyɛ ɔnɔkɔali kĩ Herodes mɔ Pontio Pilato mɔ Israelfɔ, mɔ bikĩ bɛnyɛ́ Israelfɔ a tsɛna nɛ ɔmatɔ kĩĩ kamɛ, ade biyidza bɛdza nɛ Yesu nɔ Ɔsumunɛ kpalɛwa a kĩ ɔbɔa tɔdɔ̃ a akũ a. ");
INSERT INTO bov_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Lɛmɛ nɛ nɔ kɔbɛ̃, mɔ nɔ kawɛ, ɔkpa osi bɛkpɔta bɛkɛna lɛtsa kĩ ohihiɛ oyi a fɔya nɛ foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Finyaakĩĩ, O boe Ɔlate, dã ɔhau a kĩ ye kamɛ bido boe, lɔkɔa kado boe nɔ adzuma bakɛnanɛ a ɔwɔlɛ, ayekĩ bɔ́apuli bɔlɛ nɔ kalɛ wĩ a nɛ katavila kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Te awɛ nɛ nɔ bati akũ bɛna kasaɛ, kafɔ̃ awãwã fɔtsa mɔ nsɛntsɛlɛni pii fɔya nɛ nɔ Ɔsumunɛ Kpalɛwa Yesu dĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kĩ bɛbɔa mpaɛ biyua a, kɔla kĩ koe kamɛ bɛna a kuna. Hũhũ Kpalɛwa wo nɛ be flee kamɛ ade bido Baguma fɔlɛtsa kalɛ awɛ mɔ kɔbɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nɛ fuwi kĩĩ kamɛ a, batɛ badonɛ a flee kɛna ɔmɔa nɛ be fɔkɛnatsa mɔ adzuni kamɛ. Be kamɛ odima tákɔna kĩ ye odi la ye fɔtsa kĩ ɛna a, mbom fɔtsa kumɛkumɛ a nya be flee fude. ");
INSERT INTO bov_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Fɔtɔ banyanɛ kĩĩ de lɛtsã mɔ kɔbɛ̃ kĩ boe Ɔlate Yesu kayidza kato banɔkpa kamɛ a nyɛ ɔnɔkɔali, ade Baguma lukudɔ mɔ nhila na nɛ be flee akũ a. ");
INSERT INTO bov_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Odima tánya ohiãni kitonɛkĩ bikĩ bɛna fɔla mɔ tite a nɔ foe. ");
INSERT INTO bov_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Bɛkɔa sika a bɛma fɔtɔ banyanɛ a ade bɛsɛ̃ se bɛkpa odi nyɛ odi nɛ ye kasĩ onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Onyole odi kĩ bavɛ Yosef na nɛ awã. Ɛnyɛ Levini kĩ bɛma nɛ Kipro tite akũ. Fɔtɔ banyanɛ a te ye dĩ kĩ Barnaba, dĩ a kayɔ nyɛ Ekĩ yado Bati Ɔwɔlɛ. ");
INSERT INTO bov_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnaba malo nɔ ye tite ɛkɔa sika a ɛma fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lɛmɛ onyole odi kĩ bavɛ Anania mɔ ɔtsɔ̃ Safira na nɛ be kamɛ, be malo bɛnɔ be tite tidi. ");
INSERT INTO bov_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anania kɔa sika a sidi ɛkɔla ade ɛkɔa se nkaɛ ɛma fɔtɔ banyanɛ a. Ɔtsɔ̃ Safira nyina foe akũ litsedi ade etunɔ kĩ bakɛna lɔmɔ a. ");
INSERT INTO bov_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ade Petro via ye kĩ, “Anania, nde sũ ɔfɔ̃ Abonsam nya nɔ akũ, ɔma fɔvã ɔkpa Hũhũ Kpalɛwa, fɔfɔ̃ ɔkɔla tite a kĩ ɔnɔ a sika a sidi? ");
INSERT INTO bov_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nɔ tide nyɛ tite a fɔmɔ ɔnɔ te, sika a kĩ ɔtɛ a lɛmɛ nɔ side sanɛ. Litsa lɛfɔ̃ ɔbɔɛ adzuni kpa kĩĩ odu? Nnɛ́ boe batidziwa ɔkɛ, mbom Baguma ɔkɛ!” ");
INSERT INTO bov_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kĩ Anania sila enu fɔlɛtsa kĩĩ pɛ, esinya ɛtɔ nɛ tite eku. Libe wo bati flee a kĩ binu fɔlɛtsa a paa. ");
INSERT INTO bov_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bapopo a kĩ bɛna nɛ be kamɛ a kɔa lima bisuli ye bɛbɔɛ bɛnabila. ");
INSERT INTO bov_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɔtsɔ̃ yanɛ ɛta nɛ awã ndɛ ndɔũhuilɛ ɛlalɛ liti, kĩ enyína lɛtsa kĩ lɛya lɛtɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ade Petro via ye kĩ, “Bi yĩ. Kĩ mimɔ nɔ ɔnyɔ minɔ tite a sika a kĩ bise mi a ni, se a flee nɛ awĩ a?” Otsole a kpa mbuayɛ kĩ, “Oo, ade se a flee nɛ awã a.” ");
INSERT INTO bov_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Foesũ Petro bi ye kĩ, “Nde sũ mimɔ nɔ ɔnyɔ mikɛna onukpɛ̃ mɔa miasɔ boe Ɔlate Hũhũ midã? Dã, bapopo a kĩ bɛbɔɛ nɔ ɔnyɔ bɛnabila a dzɛ̃ nɛ onyukpɛ̃ finyaakĩĩ. Baabɔɛ nɔ malo bɛnaabila.” ");
INSERT INTO bov_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Deedimɔapɛ otsole a ka ɛtɔ nɛ tite, eku. Ade kĩ bapopo a yamɔ kĩ eku ɛwaa a, bɛbɔɛ ye malo bɛnabila nɛ ɔnyɔ ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Foesũ libe paa wo batɛ badonɛ a flee mɔ be flee a kĩ binu lɛtsa kĩ lɛya nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nɛ lɔkɔ kĩĩ kamɛ a fɔtɔ banyanɛ a kakɛna awãwã mɔ nsɛntsɛlɛni fɔtsa pii nɛ bati a kamɛ. Batɛ badonɛ a flee katsɛna nɛ Yudafɔ Asɔli kɔla kakɔa kĩ bavɛ Salomo Mblada a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bikĩ bɛtána nɛ batɛ badonɛ a kamɛ a tádo ɔwɔlɛ kĩ bafuã be, titɔ kĩ bakɔa obu kakpa be malo. ");
INSERT INTO bov_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bati pii, batsole mɔ banyole, dani ɔwɔlɛ kamɛ bɛtɛ boe Ɔlate bido. ");
INSERT INTO bov_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ade bati pii bɔɛ be basɔnɛ mɔ tɛpa mɔ tɛkɛna bɛnayi nɛ kɔya nɛ awã kĩ ntɛ Petro atɛ̃ mɔ ye kuyo ako nɛ be akũ ni, lɔkɔa bɛsaɛ. ");
INSERT INTO bov_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ade bɛkɔa basɔnɛ mɔ bikĩ hũhũ kpa deĩ nɛ be kamɛ a bitomɛna tɛmatɔ a kĩ tisinya Yerusalem a bɛyamɛna bɛtsa be flee a. ");
INSERT INTO bov_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ade Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee mɔ bikĩ bideĩ nɛ ye akũ kĩ bito Zadukifɔ katsu kamɛ a yɔɔla anɛ nɛ fɔtɔ banyanɛ a akũ a. Foesũ bike otse kĩ baakɛna litsedi. ");
INSERT INTO bov_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nɛ foesũ bipi be bɛnado nɛ kɔla kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lɛmɛ ke lɛnyɛ a, boe Ɔlate ode fɔtɔ ɔnyanɛ odi yabinya opunu a, ɛnyɛ be, ade ebi be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Minaa Yudafɔ Asɔli kɔla a kamɛ lɔkɔa mibi bati fɔlɛtsa a flee nɛ nkpã vɔɛ̃ kĩĩ akũ!” ");
INSERT INTO bov_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Foesũ kĩ kade nyina a bɛnawo nɛ Asɔli kɔla a kamɛ ade biyi fɔtsa katsa kayɔ nɛ awã a. Lɔkɔa na kamɛ, Ɔsɔfɔnɔkɔɛ̃ Flee a mɔ bikĩ bitomɔ ye a, mɔ Yudafɔ ɔmaĩ banɔkɔɛ̃ a tsɛna, ade bido bikĩ badã asɔli kɔla akũ kĩ bɛnaanyɛ fɔtɔ banyanɛ a nɛ kɔla a kamɛ bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lɛmɛ kĩ bati a naa awã a, bɛtámɔ be, foesũ bimuniki bɛyabi be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kĩ bɔnaa a, bɛbalɛ kɔla a kpakplakpa ade bikĩ badã kɔla a akũ lɛmɛ dzɛ̃ nɛ onyukpɛ̃ a pɛpɛɛpɛ a. Lɛmɛ kĩ bubinya kɔla a bati a kamɛ odima lɛláa koe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kĩ asɔli kɔla akũ ɔdãmɛnanɛ ɔnɔkɔɛ̃ mɔ basɔfɔnɔkɔɛ̃ a nu kalɛ kĩĩ a, akũ dzuli be ade bɛkakɔna lɛtsa kĩ lɛya nɛ fɔtɔ banyanɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ade odi yabi be kĩ, “Bati a kĩ mipi mido nɛ kɔla kamɛ a, deĩ nɛ asɔli kɔla kamɛ ade bɛlamɛna bati fɔtsa katsa nɛ awã a.” ");
INSERT INTO bov_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nɛ awã a Asɔli Kɔla ɔdãmɛnanɛ ɔnɔkɔɛ̃ mɔ ye bati yidza bɛnakpã be bɛyamɛna. Nɛ kĩ bivila kĩ bati aanɔ be boe sũ ni, bɛtákpã be nɛ ɔhɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kĩ bɛkpã fɔtɔ banyanɛ a bɛyamɛna a, bɛfɔ̃ bɛdza nɛ ɔmaĩ banɔkɔɛ̃ a anɛ kamɛ. Ade Ɔsɔfɔnɔkɔɛ̃ Flee a via be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Bɔtábi mi kĩ mitabuki milɛ kadima nɛ Yesu dĩ akũ a? Lɛmɛ migbamɛna fɔlɛtsa kĩĩ flee nɛ Yerusalem, ade miawɛ kĩ miakɔa ye wuda sɔtɔ kavɛlɛ a mite nɛ boe akũ a.” ");
INSERT INTO bov_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Awã na Petro mɔ fɔtɔ banyanɛ bɛbã a kpa mbuayɛ kĩ, “Kɛnɛ kĩ bɔabu Baguma, nnɛ́ batidziwa. ");
INSERT INTO bov_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu a kĩ mifɔ̃ bɛbɔa nɛ asendua akũ mikɔ ye a, boe bawanyɔ Baguma dzɛla ye etomɛna kanɔkpa, edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Baguma kpa ye kadzikɔ̃nɔkɔɛ̃ nɛ ye sɔmɔna, ade ɛkɛna ye Ɔkpãnɛ mɔ Ɔtɛnɛ, ayekĩ Israelfɔ aana osi bɛdani be tɔwɔlɛ kamɛ lɔkɔa bɛna be titikpa kakɔakate. ");
INSERT INTO bov_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ade boe mɔ Hũhũ Kpalɛwa a, kĩ ɛnyɛ Baguma futetsa kĩ ɛkpa bikĩ babu ye a, bɔnyɛ foe akũ adansifɔ a.” ");
INSERT INTO bov_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kĩ ɔmaĩ banɔkɔɛ̃ a nu fɔlɛtsa kĩĩ a, fɔfɔ̃ bɛna kalɔkpa paa ade bɛwɛ kĩ bakɔ fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lɛmɛ Farisifɔ banɔkɔɛ̃ a kamɛ ɔmɔa kĩ bavɛ Gamaliel sua be osi. Ɛnyɛ fɔtsa ɔtsanɛ nɛ Mose mbla akũ, ade bati a flee akɔa obu baũ kakpa ye a. Eyidza ɛdza ade ɛlɛ kĩ bɛfɔ̃ fɔtɔ banyanɛ a bɛkpa be osi sukuloo bɛkɔna fɔlɛtsa a akũ. ");
INSERT INTO bov_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ade ke liti ebi be kĩ, “Nwaɛ̃ Israelfɔ, midã kadã wĩ nɛ lɛtsa kĩ miawɛ kĩ miakɛna nɛ bati kĩĩ akũ a! ");
INSERT INTO bov_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Míate anɛ kĩ lɔkɔ lidi kĩ lɛyatɛ̃ a, onyole odi kĩ bavɛ Teuda yakɛna ye akũ kĩ oti titiliwu odi odu yanɛ. Bati ndɛ ɔha ɛna tomɔ ye nɛ liti. Ade kĩ bɛkɔ ye a bikĩ bitomɔ ye a flee pansam, ade ye fɔlɛtsa a lɛmɛ wɔ a. ");
INSERT INTO bov_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ke liti, nɛ bati kakã lɔkɔ a, Yuda, Galileani a yayidza, ɛvɛlɛ bati kɔdabu ebumɔ ye akũ. Kĩ ye malo ɛyaku a bikĩ bitomɔ ye a flee yalɛ, ade ye fɔlɛtsa a lɛmɛ wɔ a. ");
INSERT INTO bov_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Foesũ lɛtsa kĩ mabi mi nyɛ kĩ mifɔnɛ bati kĩĩ awɛ bɛnaa. Ntɛ be fɔtsa katsa a mɔ bati fude fɔanɛ ni, owi lɛláabuna mɔ fɔ́awɔ. ");
INSERT INTO bov_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lɛmɛ ntɛ Baguma sɛkɛ̃ futo kɔ̃ ni, bɔláapuli busua foe osi. Ntɛ mitádã kadã wĩ ni, luwi lidi míamɔ kĩ Baguma awɛ akũ buyidza bɔdza.” Katsɛnakɔ̃ bati a tɛ Gamaliel kalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Foesũ bɛvɛ fɔtɔ banyanɛ a bimuniki bɛya ade bibo be a. Bisĩ be mbla kĩ bɛtabuki bɛlɛ kadima nɛ Yesu dĩ akũ dadaada, ade bɛfɔnɛ be awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kĩ bɛdzakũ banaa a, bɛmɔ́ kawɔlɛ pii kitonɛkĩ Baguma bu be ndɛ bati kĩ bɛfɛta bɛkpa lubo kamɔ mɔ kɔnyɔãkado nɛ Yesu dĩ sũ. ");
INSERT INTO bov_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nɛ fukĩĩ liti a, luwi daa bɛkatsa fɔtsa nɛ Asɔli kɔla kamɛ, mɔ bati tɔtɔ kamɛ, kade lɛtsã nɛ Kalɛ Wĩ akũ kĩ Yesu nyɛ Kristo a. ");
INSERT INTO bov_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ke liti a, kĩ fɔtsa bakɔlɛnɛ a lidede lamɛna kapɔ kabu a, ɔdzɛ yawo nɛ Yudafɔ a kĩ balɛ Tigriki mɔ Yudafɔ mɔawɛ a kayite. Grikifɔ a tsa kĩ ntɛ bɛsɛ̃ funitsã ni, baákpa be bakunawa. ");
INSERT INTO bov_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nɛ foesũ fɔtɔ banyanɛ ewua-nviã a vɛ batɛ badonɛ a flee bɛkpɔta ade bibi be kĩ, “Fɔtáfɛta kĩ bɔakɔa lɔkɔ a kĩ bɔalɛ Baguma fɔlɛtsa bɔkɛna funitsã kasɛ̃ lɔkɔ. ");
INSERT INTO bov_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Foesũ nwaɛ̃ amɛ, midã mi kamɛ minyɛ banyole evũkɔnɔ kĩ binyina kadi, kĩ Hũhũ Kpalɛwa lɛmɛ yi be kamɛ, lɔkɔa bɔkɔa adzuma kĩĩ budo nɛ be awɛ, ayekĩ boe mɔawɛ a bɔ́ana aya bɔkpa mpaɛ kabɔa mɔ Baguma fɔlɛtsa a kalɛ.” ");
INSERT INTO bov_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Fɔlɛtsa a de bati a flee kawɔlɛ ade bɛnyɛ Stefano, oti kĩ edeĩ katɛkado, kĩ Hũhũ Kpalɛwa lɛmɛ tɛ ye kamɛ, Filipo, Prokoro, Nikanora, Timona, Parmena mɔ Nikolao, kĩ ɛdani ɛkɛna Yudani. Eto Antiokia. ");
INSERT INTO bov_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɛnyɛ bati evũkɔnɔ a kĩ bɛpau a bɛtsa fɔtɔ banyanɛ a ade bɛbɔa mpaɛ nɛ be lɔlɔ, bite awɛ nɛ be akũ a. ");
INSERT INTO bov_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bati pii tɛ Baguma kalɛ wĩ a. Fɔtsa bakɔlɛnɛ nɛ Yerusalem danɛ kapɔ ade Yudafɔ basɔfɔ a pii lɛmɛ dani bɛtɛ Yesu bido a. ");
INSERT INTO bov_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano kĩ Baguma kɔbɛ̃ mɔ sɛmɛ kalɛ yi ye kamɛ a, kɛna awãwã mɔ nsɛntsɛlɛni fɔtsa pii nɛ bati a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yudafɔ a kĩ bɛnyɛ be nɛ awɔba kamɛ a kĩ bito Kirene mɔ Aleksandria bibumɔ bikĩ bito Kilikia mɔ Asia yidza nɛ Stefano akũ, bɛkavɛlɛ fɔlɛtsa mɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lɛmɛ Baguma Hũhũ kpa Stefano nyansã mɔ kadikanyi paa foesũ ntɛ ɛlɛ kɔdzɛla ni, be kamɛ odima lápuli katɛ ye atsindze. ");
INSERT INTO bov_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Foesũ bɛkɛna ɔmɔa mɔ badi kĩ bɛma fɔvã kĩ, “Bunu kĩ Stefano lɛ fubusuotsa nɛ Mose mɔ Baguma akũ.” ");
INSERT INTO bov_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ye onukpɛ̃ katsua kĩĩ fɔ̃ bati a, banɔkɔɛ̃ a, mɔ mbla batsanɛ a na kalɔkpa paa, ade Yudafɔ mbla batsanɛ a yapi Stefano bɛnamɛna Ɔmaĩ banɔkɔɛ̃ katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bati a kĩ bitsua Stefano onukpɛ̃ a yama fɔvã bɛlɛ kĩ, “Oti kĩĩ alɛ kɔdzɛla katia Asɔli Kɔla Kpalɛwa mɔ Mose mbla a luwi nyɛ luwi. ");
INSERT INTO bov_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bunu lɛmɛ kĩ ɛlɛ kĩ Yesu Nazaretni a aaveli Asɔli kɔla kĩĩ lɔkɔa ɛdani tɛmaniɛ flee a kĩ Mose yi ɛkpa boe a.” ");
INSERT INTO bov_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lɔkɔ a na kamɛ bati a flee kĩ bɛna nɛ katsɛnakɔ̃ a ke anɛ nɛ Stefano akũ ade bɛmɔ́ kĩ ye anɛ kamɛ dani ndɛ ode fɔtɔ ɔnyanɛ ade aye a. ");
INSERT INTO bov_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ade Ɔsɔfɔnɔkɔɛ̃ Flee a via Stefano kĩ, “Lɛtsa a kĩ bɛlamɛna kalɛ nɛ nɔ akũ a ni, nuwĩ fɔanɛ?” ");
INSERT INTO bov_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano kpa mbuayɛ kĩ, “Nda amɛ mɔ nwãɛ amɛ, mitse katse wĩ! Fɔmɔ boe ɔwanyɔ Abraham aatu ɛnaadzi nɛ Haram tite akũ a, Baguma Kpalɛwa a nyɛ ye akũ ɛtsa ye nɛ Mesopotamia tite akũ. ");
INSERT INTO bov_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ade awã ebi ye kĩ, ‘Yidza kafɔnɛ nɔ katete bati mɔ tite a na kanaa tite a kĩ maatsa nɔ a akũ.’ ");
INSERT INTO bov_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Foesũ ɛdzakũ nɛ Kaldea tite akũ ɛnadzi nɛ Haram kɛnawo lɔkɔ a kĩ ɔlɛga ku. Ade ke Baguma kpã ye ɛyamɛna nɛ awã kĩ midzi nviã kĩĩ a. ");
INSERT INTO bov_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Baguma tákpa Abraham tite kanyakɔ̃ sɛnɛta mɔa malo kĩ tɛnya ye tide. Lɛmɛ ɛlɛ eyi kĩ yaakɔa tite a na ɛkpa ye tɛnya ye mɔ ye babi mɔ bawa tide, titɔ kĩ nɛ lɔkɔ a na kamɛ malo ɛtáma obi odima! ");
INSERT INTO bov_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lɛtsa a kĩ Baguma bi ye nyɛ kĩ, ‘Nɔ bawa aanya banɔvɔɛ̃ nɛ tite bɛbã akũ, bɛnya abawa bɛkɛna be tɛnya futeli ɔha ɛna kpɔũ.’ ");
INSERT INTO bov_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ebuki ɛlɛ kĩ, ‘Maadzɛ mɔ bati a kĩ be baasum a. Ke liti baadzakũ nɛ tite a akũ bɛyaasum yĩ nɛ awĩ kĩĩ.’ ");
INSERT INTO bov_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ade ke Baguma kɛna lɛkpati katsua ndɛ apam aye nɛ Abraham mɔ Ye Baguma kayite a. Nɛ foesũ kĩ Abraham ma Isak a etsua ye lɛkpati kĩ ɛtɛ fuwi ɛlɛ̃ a. Isak lɛmɛ ma Yakob, Yakob lɛmɛ ma babi ewua-nviã kĩ bɛnyɛ Yudafɔ bawanyɔ ewua-nviã a. ");
INSERT INTO bov_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakob babi kĩĩ yɔɔlɛ anɛ nɛ be ɔwaɛ̃ Yosef akũ ade bipi ye bɛnɔ bɛkpa bati badi bɛkpã ye bɛnamɛna Egipte tite akũ a. Lɛmɛ Baguma dã ye akũ, ");
INSERT INTO bov_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ade ɛnyɛ ye etomɛna ye lubo kamɔ mɔ ayɔlɔhɔ kamɛ a. Baguma kpa ye nyansã mɔ kɔnyakamɔ baũ foesũ Egiptefɔ Lɛgã Farao wɛ ye kalɛ ade ɛkɔa ye ɛkɛna ye tite mɔ lɛgã tɔtɔ a akũ ɔdãmɛnanɛ a. ");
INSERT INTO bov_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Lɔkɔ lidi kamɛ ni, kɔlɛ kpale ya nɛ Egipte mɔ Kanan tite flee akũ kĩ fɔyamɛna lubo kamɔ beblebee kĩ boe bawanyɔ tána funitsã. ");
INSERT INTO bov_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ade kĩ Yakob nu kĩ fugbanɔ na nɛ Egipte a, edo ye babi lɔtɔnyade a bɛnaaya funitsã bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kĩ Yakob babi buki bɛnaa awã lɛyade kĩ banaaya funitsã a, Yosef nyɛ ye akũ ɛtsa bawaɛ̃, ade ɛnyɛ be lɛmɛ ɛtsa Lɛgã Farao a. ");
INSERT INTO bov_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosef bi be kĩ ntɛ bɛnaa ni, bɛkpã ɔlɛga Yakob mɔ ye akũ bati flee a kĩ baana ndɛ bati aduesɔũ-elo bɛyamɛna nɛ Egipte. ");
INSERT INTO bov_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Foesũ Yakob mɔ ye babi dzakũ bɛnaa Egipte bɛnadzi nɛ awã kɛnawo kĩ biku. ");
INSERT INTO bov_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ke liti a, bɛkɔa be banɔkpa bɛyamɛna nɛ Sekem bɛyabila nɛ linikɛ a kĩ Abraham ya mɔ sika etomɛna Hamor babi sɛkɛ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kĩ lɔkɔ a kĩ Baguma sui mɔ Abraham wo ɔtɔ kiyua a, Israelfɔ nɛ Egipte a ma bɛsa beblebee. ");
INSERT INTO bov_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Fɔyaya lɛmɛ kĩ lɛgã vɔɛ̃ Farao a kĩ ɛnya Egipte akũ a tányi Yosef kɔlaa. ");
INSERT INTO bov_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Farao kĩĩ tsã tɛdake kamɛ ɛkɛna boe bawanyɔ tɛnya, ɛfɔ̃ bɛnyɛ be babi bakɔkɔa nɛ tɔtɔ kamɛ ayekĩ baaku. ");
INSERT INTO bov_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ade lɔkɔ a na kamɛ bɛma Mose a. Obisɛ̃ kĩĩ kalɛ kadã paa. Nɛ foesũ ye bamanɛ kɔla ye nɛ kɔla kamɛ tidetɔ ɛlalɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kĩ bɛnyɛ ye nɛ be akũ a, Farao obitsole namɔ ye ɛbɔɛ, ade ɛdɔɔla ye ndɛ ye mɔawɛ sɛmɛ kamɛ obi a. ");
INSERT INTO bov_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bɛtsa ye Egiptefɔ kadikanyi mɔ be kadzi kamɛ fɔkɛnatsa a flee, ade ɛyabo anɛ ɛkɛna oti a. Ɛna ovio nɛ kɔdzɛla kalɛ mɔ fɔkɛnatsa pii kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kĩ Mose tɛ futeli tɛna a, kakɔna wo nɛ ye kamɛ kĩ ɛnaasɛla ye bawaɛ̃ Israelfɔ ɛdã. ");
INSERT INTO bov_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kĩ ewo awã a, ɛmɔ́ kĩ Egipteni odi lamɛna Israelni odi awɔda kakɛna foesũ ɛnabumɔ Israelni a, ade ebo Egipteni a ɛkɔ a. ");
INSERT INTO bov_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose kɔna kĩ bawaɛ̃ a aanu foe kayɔ kĩ Baguma lɛwɛ kĩ yatsã ye akũ ɛtɛ be lɛmɛ bɛtánu foe kayɔ lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kĩ kade nyina a, ebuki ɛmɔ́ kĩ Israelfɔ bati nviã lamɛna kavũ. Ɛnaakpɔla lɛma a ade ebi be kĩ, ‘Midã, bawaɛ̃ mɔ bawaɛ̃ mianɛ, nde sũ miakɛna akũ awɔda lɔmɔ?’ ");
INSERT INTO bov_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Lɛmɛ ekĩ ɛwɛ sɔwã a du Mose ɛdzɛla nɛ ɔɔwɛ̃ ade evia ye kĩ, ‘Fɔɔdabe tsɛla nɔ? Owei lɛkɛna nɔ boe akũ ɔnyanɛ mɔ fɔlɛtsa ɔdzɛnɛ? ");
INSERT INTO bov_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mbɔɛ awɛ kĩ akɔ yĩ ndɛ ayekĩ ɔkɔ Egipteni a kadzɔ a?’ ");
INSERT INTO bov_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kĩ Mose nu fɔlɛtsa kĩĩ a, libe wo ye paa, foesũ elo ɛnaa Midianfɔ tite akũ, awã kĩ ɛnadzi ndɛ ɔnɔvɔɛ̃ aye, ɛma babinyole nviã. ");
INSERT INTO bov_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Futeli tɛna liti a, ode fɔtɔ ɔnyanɛ odi nyɛ ye akũ ɛtsa Mose nɛ tuwĩ mɔ fu kĩ tɛkatɛ̃ nɛ kɔsa a kĩ kufuã Sinai ɔtɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kĩ Mose mɔ́ fukĩĩ a, fɔkɛna ye saa foesũ efuã kĩ yanaadã lɛtsa a kadã wĩ. Ade Baguma vɛ ye ebi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yĩ nyɛ nɔ bawanyɔ a Baguma, Abraham mɔ Isak mɔ Yakob Baguma.’ Mose katila bliblibli mɔ libe foesũ ɛtápuli ebuki ɛdã awã kadã wĩ. ");
INSERT INTO bov_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ade Baguma bi ye kĩ, ‘Nyɛ nɔ mpabua nɛ abɔa, kitonɛkĩ awã kĩ ɔdzɛ̃ a ni, tite kpalɛwa tanɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɔnɔkɔali mmɔ́ yĩ bati a lubo kamɔ mɔ tɛnya a kĩ bakɛna be nɛ Egipte tite akũ a. Nnu be kɔnyakabe foesũ ĩya kĩ mayaanyɛ be. Finyaakĩĩ ya, lɔkɔa ndo nɔ fɔtɔ nɛ Egipte.’ ");
INSERT INTO bov_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ade Mose a kĩ bisĩ kĩĩ bivia kĩ, ‘Owei lɛkɔa nɔ ɛdzɛla ndɛ boe akũ ɔnyanɛ mɔ fɔlɛtsa ɔdzɛnɛ?’ Ade ye Mose kĩĩ a Baguma do kĩ ɛnaanya be akũ, lɔkɔa ɛnyɛ be nɛ ɔhau kamɛ fɔtsãmɛna ode fɔtɔ ɔnyanɛ a kĩ ɛnyɛ ye akũ ɛtsa ye nɛ tuwĩ a kĩ tɛkatɛ̃ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose kpã bati a bɛdzakũ nɛ Egipte. Ɛkɛna awãwã fɔtsa pii nɛ Egipte mɔ Mpo Ngbã a abuĩ mɔ kɔsa kamɛ nɛ be osi katsã futeli tɛna a flee kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ade Mose kĩĩ mɔapɛ a libi Israelfɔ kĩ, ‘Baguma aanyɛ onukpɛ̃ ɔnyɛnɛ odi ndɛ ayekĩ ɛnyɛ yĩ a etomɛna mimɔa a kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mose nyɛ oti kĩ ɛna nɛ boe bawanyɔ a sɛkɛ̃ nɛ lɔkɔ a kĩ Israelfɔ na nɛ kɔsa kamɛ a. Ade ye mɔ Baguma fɔtɔ ɔnyanɛ lɛmɔ kɔdzɛla nɛ Sinai ɔtɔ akũ, ɛtɛ Baguma nkpã kalɛ a ɛma boe a. ");
INSERT INTO bov_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lɛmɛ boe bawanyɔ táwɛ kĩ batse Mose, mbom bisĩ ye, ade bɛwɛ kĩ bamuniki bɛnaa Egipte tite akũ a. ");
INSERT INTO bov_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Foesũ bibi ɔwaɛ̃ Aron kĩ, ‘Kɛna baviɔ̃ kĩ baakpã boe, kakpa boe, kitonɛkĩ bunyína lɛtsa a kĩ lɛya nɛ Mose a kĩ ɛkpã boe etomɛna Egipte a akũ.’ ");
INSERT INTO bov_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ade ke bɛmɛ baviɔ̃ ndɛ ɔnantsue obi aye, bɛkabɔa afɔliɛ kakpa ye a. Bɛmɔ́ kawɔlɛ bɛnya luwi bɛkpa lɛtsa a kĩ be mɔa bɛkɔa awɛ bɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nɛ fukĩĩ sũ Baguma muniki nɛ be liti, ɛfɔ̃ bɛkasum suwa mɔ odetɔ mɔ fusibii, ndɛ ayekĩ bɛtsɛlɛ nɛ Baguma onukpɛ̃ banyɛnɛ Ovoli a kamɛ kĩ, ‘Israelfɔ, nnɛ́ yĩ mikɔa bayaɛ mibɔa afɔliɛ mikpa nɛ futeli tɛna a kĩ mina nɛ kɔsa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mbom Molok pata mɔ Romfa fusibii baviɔ̃ a kĩ mikɛna a mikabɔa afɔliɛ kakpa. Foesũ maafɔ̃ bipili mi ndom bɛkpã mi bɛnamɛna mɔ lugo nɛ Babilonia liti flee.’ ");
INSERT INTO bov_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Boe bawanyɔ na patampa kĩ ye kamɛ Baguma kanyɛ akũ katsa be nɛ kɔsa a kamɛ. Bike patampa kĩĩ ndɛ ayekĩ Baguma nyɛ ɛtsa Mose kĩ ɛkɛna pɛpɛɛpɛ a. ");
INSERT INTO bov_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Patampa kĩĩ, kĩ boe bawanyɔ tɛ bitomɛna be balɛga sɛkɛ̃ a na nɛ be awɛ, nɛ lɔkɔ a kĩ Yosua kpã be a, ade bɛtɛ bati a kĩ Baguma blɔmɛna nɛ be lɔtɔ a tite a. Patampa kĩĩ na nɛ be kamɛ kɛyawo Lɛgã Dawid lɔkɔ. ");
INSERT INTO bov_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawid fɔkɛnatsa wo Baguma anɛ, ade evia Baguma kĩ ɛkpa ye osi eke kadzikɔ̃ wĩ ɛkpa Yakob Baguma a. ");
INSERT INTO bov_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lɛmɛ Salomo lɛyake kɔla a ɛkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lɛmɛ Baguma Kpale ládzi nɛ fɔla kĩ batidziwa ke a kamɛ. Baguma onukpɛ̃ ɔnyɛnɛ lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ode nyɛ yĩ lɛgãkpo, ade tite lɛmɛ nyɛ yĩ abɔa katekɔ̃ a. Kɔla kɔɔdabe odu míapuli mike mikpa yĩ, mbɔɛɛ kadzikɔ̃ mɔ nlá? ");
INSERT INTO bov_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nnɛ́ yĩ mɔawɛ lɛkɛna fukĩĩ bamɛ flee a?’ ” ");
INSERT INTO bov_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ade Stefano buki ebi be kĩ, “Bati kĩ mideĩ atɔ ɔsĩ mianɛ! Misĩ kĩ míatse Baguma kalɛ ndɛ ayekĩ mi balɛga kɛna a. Daa miayidza kadza nɛ Hũhũ Kpalɛwa akũ. ");
INSERT INTO bov_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Baguma onukpɛ̃ ɔnyɛnɛ ɔɔdabe mɔ mi bawanyɔ tátomɔ ye liti? Bɛkɔ Baguma onukpɛ̃ banyɛnɛ a kĩ bɛlɛ biyi kĩ Oti a Kĩ Bɛpau kĩ ye akũ kpalɛ a aaya. Oti Kĩ Bɛpau kĩĩ malo, minyɛ ye mikpa bɛkɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɔnɔkɔali fɔanɛ kĩ mi a kĩ mitɛ Baguma mbla mitomɛna ye ode fɔtɔ banyanɛ sɛkɛ̃ a, misĩ ye akũ kakɛna.” ");
INSERT INTO bov_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kĩ binu Stefano fɔlɛtsa a kĩ ɛlɛ nɛ be akũ a, be tɔwɔlɛ hulu, ade bɛkaba adɔ̃ dzadzadza mɔ kalɔkpa a. ");
INSERT INTO bov_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lɛmɛ Stefano kĩ Hũhũ Kpalɛwa yi ye kamɛ, dzɛla anɛ ɛdã ode koee ade ɛmɔ Baguma kukũkpalɛ a mɔ Yesu kĩ ɛdzɛ̃ nɛ Baguma sɔmɔna a. ");
INSERT INTO bov_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ade ebi be kĩ, “Midã! Mamɔ kĩ odetɔ́ kamɛ binya ade Otidziwa Obi a dzɛ̃ nɛ Baguma sɔmɔna a!” ");
INSERT INTO bov_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bati a bɔa fɔwɔla kɔɔba, bisua atɔ ade biwula atsɛ bɛnapi ye a. ");
INSERT INTO bov_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bɛvɛlɛ ye bɛnɛmɛna nɛ ɔmatɔ a kamɛ ade bɛtalɛ ye boe a. Bati a kĩ bɛvɛlɛ ye bɛnɛmɛna a nyɛ be tɛtadiɛ wulaa biyi nɛ opopo odi kĩ bavɛ Saulo sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kĩ bɛkatalɛ Stefano boe a, ɛbɔa mpaɛ ɛlɛ kĩ, “Boe Ɔlate Yesu, tɛ yĩ hũhũ.” ");
INSERT INTO bov_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ade ke eke aduli ɛbɔa fɔwɔla kɔɔba ɛlɛ kĩ, “Boe Ɔlate, tase be tɔkpa kĩĩ akũ kɔtɔ!” Kĩ ɛlɛ fukĩĩ eyua a, ade eku a. ");
INSERT INTO bov_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lɔkɔ a kĩ bɛkɔ Stefano a, Saulo mɔ́ kawɔlɛ nɛ ye wuda akũ. Kito luwi a na, ade bido batɛ badonɛ a liti katomɛna awɛ nɛ Yerusalem a. Batɛ badonɛ a flee pansam bilo bɛnaa Yudea mɔ Samaria tite akũ. Lɛmɛ fɔtɔ banyanɛ a kɔ̃ kahɔ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bikĩ bavila Baguma a kamɛ badi bɔɛ Stefano ɔnɔkpa a bɛnabila, ade bibe ye paa a. ");
INSERT INTO bov_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ade Saulo kɔa ete nɛ ye akũ mɔ ɔsĩ mɔ ɔsĩ kĩ yakɔ batɛ badonɛ a. Foesũ ɛkawo nɛ tɔtɔ tidi nyɛ tidi kamɛ kapili batsole mɔ banyole flee kavɛlɛ be kanaado nɛ kɔla kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lɛmɛ batɛ badonɛ a kĩ bilo nɛ Yerusalem a tsã bimini bɛkalɛ kalɛ wĩ a nɛ Yesu akũ. ");
INSERT INTO bov_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ade Filipo naa Samaria ɔmatɔ odi kamɛ ɛnabi bati a Kalɛ Wĩ nɛ Kristo akũ a. ");
INSERT INTO bov_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bati pii tse ye fɔlɛtsa a kĩ ɛlɛ a nɛ awãwã fɔtsa a kĩ ɛkɛna bɛmɔ́ a sũ. ");
INSERT INTO bov_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɛblɔmɛna hũhũ kpa etomɛna bati pii kamɛ. Hũhũ kpa a kabɔa fɔwɔla kɔɔba ntɛ banɛ nɛ bati a kamɛ. Ɛtsa bati kĩ biveliveli mɔ bikĩ bɛnɛ lɛkpɛ̃ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɛ fukĩĩ sũ Samaria ɔmatɔ a kamɛ bati mɔ kawɔlɛ paa! ");
INSERT INTO bov_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kanɔkɔnɛ ɔdãnɛ odi kĩ bavɛ Simon na nɛ Samaria ɔmatɔ a kamɛ Ye kanɔkɔnɛ kadã a kakɛna bati wãwã kĩ fɔfɔ̃ yabu ye akũ kĩ oti mɔ kɔbɛ̃ odi odu yanɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samariafɔ batsole mɔ banyole flee abu ye nɛ fukĩĩ sũ, ade balɛ nɛ ye akũ kĩ, “Ye nyɛ Baguma kɔbɛ̃ a kĩ bavɛ Kɔbɛ̃ Kpalede a.” ");
INSERT INTO bov_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nɛ ayekĩ ye kanɔkɔnɛ kadã awo be anɛ sũ ni, bati atse ye ɔlɛdo. ");
INSERT INTO bov_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lɛmɛ finyaakĩĩ kɔ̃, bɛtɛ Filipo fɔtsa katsa nɛ Baguma lɛgãkanya akũ a nɛ Yesu Kristo dĩ akũ bido. Nɛ foesũ batsole mɔ banyole pii tɛ mui kawɔla amaniɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon kĩĩ lɛmɛ tɛ edo ade ɛtɛ mui kawɔla amaniɛ a. Ɛtsã etomɔ Filipo bɛkamini ade Filipo awãwã fɔtsa kpale a kĩ ɛkakɛna a fɔ̃ akũ dzuli ye a! ");
INSERT INTO bov_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kĩ fɔtɔ banyanɛ nɛ Yerusalem nu kĩ Samariafɔ tɛ Baguma kalɛ a bido a, bido Petro mɔ Yohanes kĩ bɛnaasɛla be. ");
INSERT INTO bov_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kĩ biwo awã a, bɛbɔa mpaɛ nɛ batɛ badonɛ vɔɛ̃ a lɔlɔ kĩ bɛtɛ Hũhũ Kpalɛwa a. ");
INSERT INTO bov_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Titɔ kĩ bɛkɛna be mui kawɔla amaniɛ a nɛ Yesu dĩ akũ malo ni, bɛtátɛ tɔ̃ Hũhũ Kpalɛwa a. ");
INSERT INTO bov_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Foesũ Petro mɔ Yohanes te awɛ nɛ be akũ ade bɛtɛ Hũhũ Kpalɛwa a. ");
INSERT INTO bov_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kĩ Simon mɔ́ kĩ awɛ fɔtɔ banyanɛ a ate nɛ bati akũ fɔmɔ batɛ Hũhũ Kpalɛwa a sũ ni, ɛbɔɛ sika ɛkpa, ");
INSERT INTO bov_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ade ebi be kĩ, “Mikpa yĩ kɔbɛ̃ kĩĩ odu ayekĩ ntɛ nte awɛ nɛ bati akũ ni, baana Hũhũ Kpalɛwa a.” ");
INSERT INTO bov_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ade Petro bi ye kĩ, “Mimɔ nɔ sika a flee míawɔ, kitonɛkĩ ɔkɔna kĩ aapuli ɔya Baguma futetsa mɔ sika. ");
INSERT INTO bov_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɔláapuli ɔkɛna adzuma kĩĩ, kitonɛkĩ nɔ ɔwɔlɛ kamɛ lɛ́waa yededeede nɛ Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fɔnɛ adzuni kpa a kĩ ewo nɛ nɔ kamɛ a awɛ kabɔa mpaɛ kakpa boe Ɔlate, ɔsa yaakɔa nɔ ɔwɔlɛ kamɛ kakɔna kpa kĩ ete nɔ, ");
INSERT INTO bov_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","kitonɛkĩ mmɔ́ kĩ anɛngbã mɔ titikpa kakɛna nya nɔ kamɛ kamɛ!” ");
INSERT INTO bov_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ade Simon bi Petro mɔ Yohanes kĩ, “Mike boe Ɔlate aduli mikpa yĩ ayekĩ kadumu fɔlɛtsa kĩ milɛ kĩĩ fudima lɛlaaya nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kĩ Petro mɔ Yohanes lɛ boe Ɔlate kalɛ wĩ a, bidi adansiɛ lɛmɛ nɛ ke akũ nɛ Samaria biyua a, bimuniki bɛnaa Yerusalem. Bɛnatsã Samaria tukula pii kamɛ bɛkade lɛtsã nɛ Kalɛ Wĩ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ade boe Ɔlate ode fɔtɔ ɔnyanɛ odi yabi Filipo kĩ, “Yidza, kaka nɛ kayɔ, katsã kɔsa kamɛ osi a kĩ eto Yerusalem ɛnaa Gaza akũ a.” ");
INSERT INTO bov_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ade ke eyidza epi osi a. Kĩ yanaa a, ɛnatsɛlamɛna onyole odi kĩ yaya. Onyole kĩĩ nyɛ Etiopia lɛgãtsole kĩ bavɛ Kandake, sika akũ fɔtsa ɔdãmɛnanɛ ɔnɔkɔɛ̃. Ɔnɔkɔɛ̃ kĩĩ nabɔa mpaɛ nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Emuniki yatsã, ade edzi nɛ ohilili kĩ bapɔnkɔ avɛlɛ kamɛ, ɛkakã Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya ovoli a. ");
INSERT INTO bov_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ade Hũhũ Kpalɛwa a bi Filipo kĩ, “Tsã kanaapi ohilili a.” ");
INSERT INTO bov_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Foesũ Filipo wula atsɛ ɛnaa ye sɛkɛ̃ ade enu kĩ ɔnɔkɔɛ̃ a kakã Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya ovoli a kĩ ɛtsɛlɛ a. Ade evia ye kĩ, “Anu fɔlɛtsa a kĩ ɔlamɛna kakã a kayɔ?” ");
INSERT INTO bov_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɔnɔkɔɛ̃ a kpa mbuayɛ kĩ, “Oowo, nde maakɛna nnu foe kayɔ ntɛ odima tányɛ foe kamɛ ɛtsa yĩ?” Eke Filipo aduli kĩ ede ewo nɛ ohilili a kamɛ edzi nɛ ye ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Fɔlɛtsa a kĩ foe ɛkakã nɛ Katsɛlɛ Kpalɛwa a kamɛ nyɛ kĩ, “Bɛkpã ye ndɛ kuveli aye banamɛna kakɔkɔ̃. Edzɛ̃ dĩĩ ndɛ kavelibi nɛ ke tɛtsã bakpelinɛ anɛ ade ayea lɛmɛ ɛtábinya onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nɛ ye akũ kadɔla sũ, bɛtádzɛ bɛkpa ye ɔtɛbɛ Owei aalɛ kadi etomɛna ye babi mɔ bawa akũ, Kitonɛkĩ bɛtɛ ye nkpã nɛ ye awɛ nɛ katinya kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ɔnɔkɔɛ̃ a via Filipo kĩ, “Bi yĩ. Owei akũ fɔlɛtsa onukpɛ̃ ɔnyɛnɛ a lamɛna kɔdzɛla kalɛ, ye mɔa akũ mbɔɛɛ kĩ oti bɛbã?” ");
INSERT INTO bov_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo yi kayɔ etomɛna fɔlɛtsa kĩĩ akũ, ade ɛkɔa fɔbɛbã pii ebu, ebi ye Kalɛ Wĩ a nɛ Yesu akũ a. ");
INSERT INTO bov_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Kĩ banaa nɛ osi a bɛnawo kakɔ kadi kĩ mui dzɛ̃ nɛ osi ɔwɛ̃. Fɔtsa akũ ɔdãmɛnanɛ ɔnɔkɔɛ̃ a bi Filipo kĩ, “Aádã mui badi nɛ awĩ! Litsa sũ nláapuli ntɛ Baguma mui kawɔla amaniɛ a?” Ade Filipo bi ye kĩ, “Ntɛ ɔtɛ odo mɔ nɔ ɔwɔlɛ flee kɔ̃ ni, aapuli ɔtɛ” ");
INSERT INTO bov_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɔnɔkɔɛ̃ a bi ye kĩ, “Ntɛ ndo kĩ Yesu Kristo nyɛ́ Baguma Obi a.” Ade awã ɛfɔ̃ ohilili a dza a. Biduma bɛnawo nɛ mui a kamɛ ade Filipo wɔla ye mui nɛ Yesu dĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kĩ bɛnɛ nɛ mui a kamɛ a, Boe Ɔlate Hũhũ a bɔɛ Filipo ɛdzakũmɛna, ade ɔnɔkɔɛ̃ a tabuki ɛmɔ ye a. Ɛtɔasu ye osi ɛnaa mɔ kawɔlɛ. ");
INSERT INTO bov_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ke liti a, Filipo mɔ eyi ɔsũ kĩ ɛyanɛ ɛta nɛ Asoto ɔmatɔ kamɛ. Ɛtsã emini eto awã ɛkalɛ Kalɛ Wĩ a nɛ tɛmatɔ a kĩ tideĩ nɛ osi akũ a flee kɛnawo Kaisarea ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nɛ lɔkɔ a na kamɛ, Saulo kɔa kɔnɛyɔɔlɛ etomɔ batɛ badonɛ a liti kĩ yawɔla be. Ɛnaa Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee a sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ɛnavia kĩ bɛkpa ye otumi tuvoli, lɔkɔa ɛnaa Yudafɔ fɔtsɛnakɔ̃ nɛ Damasko, ɛnaapili bikĩ bɛtsɛ̃ nɛ boe Ɔlate osi vɔɛ̃ a akũ, batsole mɔ banyole flee, esuli be ɛyamɛna nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lɔkɔ a kĩ Saulo fuã Damasko ɔmatɔ a eyua mɔ kakɔna kĩĩ a ni, deedimɔapɛ ɔhaĩ odi mɔanɛ eto ode etsua esinya ye. ");
INSERT INTO bov_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɛka ɛtɔ ade enu ɔlɛdo odi kĩ, “Saulo, Saulo litsa sũ otomɔ yĩ liti?” ");
INSERT INTO bov_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ade Saulo via kĩ, “Boe Ɔlate, nɔ owei anɛ?” Ɔlɛdo kĩĩ kpa mbuayɛ kĩ, “Yĩ nyɛ Yesu a kĩ ye liti otomɛna a. ");
INSERT INTO bov_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yidza finyaakĩĩ kanaa ɔmatɔ a kamɛ, lɔkɔa baabi nɔ lɛtsa a kĩ kɛnɛ kĩ akɛna.” ");
INSERT INTO bov_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Banyole a kĩ bɛmɔ Saulo bɛtsɛ̃ a fɔ̃ bɛdza lɛmɛ baámɔ lɛtsa a kĩ de balɛ. Binu ɔlɛdo a lɛmɛ bɛtámɔ oti odima. ");
INSERT INTO bov_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ade kĩ Saulo yidza nɛ tite ebinya banebi a, ebuki yaámɔ fɔkɔ. Foesũ bipi ye nɛ kɔkpɔ bɛkpã ye bɛnamɛna Damasko ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Edzi fuwi ɛlalɛ kĩ yaámɔ fɔkɔ, yaánya, yaámɔa lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nɛ lɔkɔ a na kamɛ ɔtɛ odonɛ odi kĩ bavɛ Anania na nɛ Damasko. Boe Ɔlate nyɛ ye akũ ɛtsa ye ɛvɛ ye kĩ, “Anania!” Anania tunɔ ɛlɛ kĩ, “Boe Ɔlate, amɔ yĩ nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ade boe Ɔlate bi ye kĩ, “Yidza katsã ɔblɔnu a kĩ bavɛ Ɔblɔnu Kpĩĩ a akũ, lɔkɔa ntɛ owo Yuda tɔtɔ kamɛ ni, via Saulo kĩ eto Tarso a akũ. ");
INSERT INTO bov_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Edeĩ nɛ awã ɛlamɛna mpaɛ kabɔa, kitonɛkĩ ĩnyɛ ntsa ye ɛmɔ nɛ hũhũ kamɛ kĩ onyole odi kĩ bavɛ Anania aayate awɛ nɛ ye akũ ebuki ɛmɔ fɔkɔ.” ");
INSERT INTO bov_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ade ke Anania kpa mbuayɛ kĩ, “Boe Ɔlate, nnu fɔlɛtsa pii ntomɛna oti kĩĩ akũ nɛ ayekĩ ɛkɛna nɔ bati awɔda nɛ Yerusalem a! ");
INSERT INTO bov_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ade bunu kĩ ɛtɛ otumi tuvoli etomɛna Basɔfɔnɔkɔɛ̃ sɛkɛ̃ kĩ epili nɔ batɛ badonɛ flee nɛ Damasko a.” ");
INSERT INTO bov_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lɛmɛ boe Ɔlate bi ye kĩ, “Naa nɔ kɔ̃ kanaakɛna ayekĩ mbi nɔ a, kitonɛkĩ mpau ye kĩ ɛyaanya yĩ ɔsumunɛ ɛlɛ kalɛ wĩ a ɛtsa bikĩ bɛnyɛ́ Yudafɔ, fɔgã, mɔ Israelfɔ flee. ");
INSERT INTO bov_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ade yĩ mɔawɛ a maanyɛ lubo a kĩ yaamɔ nɛ yĩ sũ a ntsa ye a.” ");
INSERT INTO bov_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Foesũ Anania pi osi ɛnawo nɛ tɔtɔ a kĩ te kamɛ Saulo na, ade ete awɛ nɛ ye akũ ebi ye kĩ, “Nwaɛ̃ Saulo, Boe Ɔlate Yesu kĩ ɛnyɛ ye akũ ɛtsa nɔ nɛ osi a lido yĩ nɛ nɔ sɛkɛ̃ kĩ buki kamɔ fɔkɔ, lɔkɔa Hũhũ Kpalɛwa ɛtɛ nɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Deedimɔapɛ fɔkɛna Saulo ndɛ tupo lɛtsɛ nɛ ye anɛ tɛnɛ tɛtɔ, ade edo fɔkɔ kamɔ awɛ a. Eyidza ɛkpa osi bɛkɛna ye mui kawɔla amaniɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ade kĩ ɛnya eyua a, akũ de ye ɔsĩ. Saulo dzi nɛ batɛ badonɛ a sɛkɛ̃ nɛ Damasko fuwi fudi. ");
INSERT INTO bov_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nɛ fuwi a kamɛ a, ɛnaa Yudafɔ fɔtsɛnakɔ̃ a, ade ɛnalɛ kɔdzɛla ɛtsa kĩ Yesu nyɛ Baguma Obi a. ");
INSERT INTO bov_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Fɔkɛna bati flee a kĩ binu ye fɔtsa katsa a saa, ade bivia be akũ kĩ, “Nnɛ́ oti kĩĩ tsɛ̃ yakɔ bikĩ bɛtɛ Yesu bido a nɛ Yerusalem a mbɔɛɛ? Nnɛ́ ye lɛmɛ lɛya nɛ awĩ mɔ botaɛ kĩ yayaapili batɛ badonɛ a ɛma basɔfɔnɔkɔɛ̃ a mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lɛmɛ Saulo fɔtsa katsa na kɔbɛ̃ ade ye fɔlɛtsa kamɛ kanyɛ kĩ Yesu nyɛ Kristo a táfɔ̃ Yudafɔ a kĩ bɛna nɛ Damasko a lɛtɛmɔ ye atsindze a. ");
INSERT INTO bov_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fuwi fudi liti ni, Yudafɔ a natsɛna ade bipi adzuni kĩ bakɔ ye a. ");
INSERT INTO bov_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lɛmɛ bati bɔɛ bɛyabi Saulo. Lɛnyɛ mɔ suwa flee bɛkadzɔlɛ ɔmatɔ a seebi a kĩ bike bisinya a tunyukpɛ̃ ayekĩ baana ye bɛkɔ. ");
INSERT INTO bov_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lɛmɛ lɛnyɛ mɔa kayite a, bikĩ bitomɔ Saulo a bɔɛ ye bido nɛ ɔtsɛtsɛ kamɛ bɛtsãmɛna seebi ɔkɛ kamɛ bɛkamɛna ye bɛdzɛla nɛ tite! ");
INSERT INTO bov_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kĩ Saulo naa Yerusalem a, ɛwɛ kĩ yanaawo nɛ batɛ badonɛ a kamɛ nɛ awã. Lɛmɛ be flee bivila ye kitonɛkĩ bɛtátɛ bido kĩ ɔtɛ odonɛ yanɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ade Barnaba bumɔ ye ɛkpã ye ɛnamɛna fɔtɔ banyanɛ a sɛkɛ̃ a. Ebi be ayekĩ Saulo mɔ́ boe Ɔlate a nɛ lɔkɔ a kĩ yanaa Damasko, mɔ ayekĩ boe Ɔlate lɛmɔ ye kɔdzɛla lɛmɛ a. Ebi be lɛmɛ ayekĩ Saulo lɛ kɔdzɛla mɔ kɔbɛ̃ nɛ Yesu dĩ akũ nɛ Damasko. ");
INSERT INTO bov_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ade bɛtɛ ye ɛna nɛ be kamɛ a. Kito ke a, ɛna nɛ be kamɛ, emini nɛ Yerusalem flee ɛkalɛ Baguma fɔlɛtsa a nɛ boe Ɔlate dĩ akũ mɔ kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ade Yudafɔ badi kĩ balɛ Griki, kavɛlɛ fɔlɛtsa mɔ Saulo a, lɛmɛ bɛwɛ kĩ bakɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kĩ batɛ badonɛ a badi nu fukĩĩ a bɛkpã Saulo bɛnamɛna Kaisarea ade bɛnyɛ ye osi ɛnaa ye ɔtɔ Tarso a. ");
INSERT INTO bov_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Fɔyaya kĩ nɛ lɔkɔ a na kamɛ, batɛ badonɛ a kĩ bɛna nɛ Yudea, Galilea mɔ Samaria na nɛ lukudɔ kamɛ. Nɛ Hũhũ Kpalɛwa kɔbɛ̃ akũ sũ ni, bɛna ɔwɔlɛ kado. Bɛpɔ bibu ade bɛkɔa obu bɛkpa boe Ɔlate a. ");
INSERT INTO bov_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro mini ɛnaa fɔkɔ pii. Nɛ foe kamɛ a, ɛnasɛla batɛ badonɛ a kĩ bideĩ nɛ ɔmatɔ odi kĩ bavɛ Lida kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Awã na ɛmɔ onyole odi kĩ bavɛ Ainea. Ade futeli ɛlɛ̃ flee kĩ eveliveli kĩ yaápuli eyidza nɛ ɔkɛna akũ a. ");
INSERT INTO bov_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kĩ Petro mɔ ye a, ebi ye kĩ, “Ainea! Yesu Kristo tsa nɔ fɔsɔ! Yidza kadza kabuta nɔ ɔkɛna.” Deedimɔapɛ Ainea yidza ɛdza, nɛ akũ ɔsĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bati a flee kĩ bidzi nɛ Lida mɔ Saron a, mɔ́ Ainea foesũ bɛkɔa be akũ bɛkpa boe Ɔlate. ");
INSERT INTO bov_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ke liti a, otsole odi kĩ bavɛ Tabita na nɛ Yopa. Nɛ Griki tide kamɛ ni, bavɛ ye Dorkas kĩ de kayɔ nyɛ kayisie. Ɛnyɛ ɔtɛ odonɛ kĩ yakɛna tuwĩ daa, kabumɛna ahiãfɔ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Fɔsɔ yabɔa ye ade eku a. Foesũ ye bati wɔla ye mui bihihiɛ ye bɛwɔla nɛ kɔla kamɛ nɛ abansulu ode. ");
INSERT INTO bov_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa mɔ Lida kayite távɛlɛ, foesũ kĩ batɛ badonɛ a nu kĩ Petro na nɛ Lida a, bido bati nviã mɔ ɔlɛdo nɛ ye sɛkɛ̃ kĩ, “Wɛ sɔwa kaya nɛ boe sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ade ke Petro yidza ɛmanɛ akũ etomɔ be a. Kĩ ewo awã a bɛkpã ye bɛnamɛna kɔla kĩ koe kamɛ bɛwɔla Dorkas a. Bakunawa batsole dza bisinya Petro nɛ awã bɛkabe ade bɛtsa ye tɛtadie flee a kĩ Dorkas kapamu nɛ lɔkɔ a kĩ edzi nkpã a. ");
INSERT INTO bov_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ade Petro nyɛ be flee nɛ kɔla a kamɛ, eke aduli ɛbɔa mpaɛ a. Ɛdani ɛtsɛlamɔ ɔnɔkpa a ade ɛlɛ kĩ, “Tabita! Yidza!” Awã na ebinya anɛ ade kĩ ɛmɔ Petro a, eyidza edzi. ");
INSERT INTO bov_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ade Petro pi ye nɛ kɔkpɔ ɛdzɛla ye a. Foesũ Petro vɛ batɛ badonɛ mɔ bakunawa a, ade ɛkɔa ye nkpã ode edo nɛ be awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Fɔlɛtsa kĩĩ gba nɛ Yopa flee ade bati pii tɛ boe Ɔlate bido a. ");
INSERT INTO bov_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ke liti a, Petro dzi nɛ Yopa fuwi pii ade ɛna nɛ Simon adi kĩ yakɔa bayaɛ tuvoli kapamu fɔtsa a sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lɔkɔ a na kamɛ, onyole odi kĩ bavɛ Kornelio na nɛ Kaisarea ɔmatɔ a kamɛ. Ɛnyɛ Romafɔ kawũ ɔnɔnɛ ɔnɔkɔɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɛnyɛ oti wĩ, ade ye mɔ ye kɔla flee basum Baguma a. Oti kĩĩ abumɔ Yudafɔ ahiãfɔ kĩ futo ye ɔwɔlɛ kamɛ, ade yabɔa mpaɛ luwi daa lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Luwi a, kĩ kanaa olobe tɔdɔũ ɛlalɛ kamɛ a, ɛna hũhũ kamɛ kanyɛkatsa, ɛmɔ́ yededeede kĩ ode fɔtɔ ɔnyanɛ odi yabi ye kĩ, “Kornelio!” ");
INSERT INTO bov_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelio dã ye koee mɔ libe ade evia ye kĩ, “Boe Ɔlate, litsa fɔanɛ?” Ode fɔtɔ ɔnyanɛ a bi ye kĩ, “Nɔ sɛmɛ kalɛ kakɛna mɔ mpaɛbɔ a wo Baguma sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Do bati bɛnaa Yopa bɛnaakpã onyole odi kĩ bavɛ Simon Petro bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Edeĩ nɛ Simon kĩ yakɛna bayaɛ tuvoli akũ adzuma nɛ mpo abuĩ a sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kĩ Baguma ode fɔtɔ ɔnyanɛ a dzakũ a, Kornelio vɛ ye kɔla basumunɛ nviã mɔ kawũ ɔnɔnɛ mɔa kĩ ɛnyɛ oti kpĩĩ kĩ yadzɔlɛ ye akũ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ebi be lɛtsa a kĩ lɛya a, ade edo be kĩ bɛnaa Yopa a. ");
INSERT INTO bov_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kĩ kade nyina a kĩ bɛkɔa bafuã Yopa a, Petro de ɛnaa lɛtsã ode nɛ awã kĩ ese a, ɛnaabɔa mpaɛ mɔ suwa tɔdɔũ ewua-nviã lɔkɔ a. ");
INSERT INTO bov_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kɔlɛ kakɔ ye ade ɛwɛ litsedi kĩ yanya a. Lɛmɛ kĩ bɛkatɔ funitsã a, ɛna kanyɛkatsa. ");
INSERT INTO bov_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Awã na ɛmɔ́ kĩ odetɔ́ binya, ade ɛmɔ́ kĩ bɛkayɔna litsedi ndɛ lima kpale kĩ bipini de nɛ atɔ ɛna a. ");
INSERT INTO bov_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bayaɛ ahɔlɔ ahɔlɔ, bɔɛ mɔ kɔvɔlabi lɛmɛ na nɛ lima a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ade ɔlɛdo odi bi ye kĩ “Petro Yidza, kɔ, kaba!” ");
INSERT INTO bov_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lɛmɛ Petro kpa mbuayɛ kĩ, “Oowo! Kusɛ! Boe Ɔlate yĩ onukpɛ̃ táta ɔyaɛ sɛkɛna kĩ boe Yudafɔ bɔakesĩ a da!” ");
INSERT INTO bov_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɔlɛdo a buki ɛlɛ kĩ, “Lɛtsa a kĩ Baguma kpalɛ de akũ ni, tabu kĩ efĩĩ deĩ nɛ de akũ!” ");
INSERT INTO bov_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɛna kanyɛkatsa kĩĩ titi ɛlalɛ, ade bɛvɛlɛ fɔtsa a bɛnamɛna ode a. ");
INSERT INTO bov_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lɔkɔ a na kamɛ fɔlɛtsa kĩĩ kakɛna Petro basa basa, ade evia ye akũ kĩ, “Litsa fukĩĩ atsa?” Ade ke kamɛ a mɔ bati a kĩ Kornelio do fɔtɔ a yawo ɔmatɔ a kamɛ a. Kĩ bɛmɔ́ tɔtɔ a kĩ bawɛ a, bɛnadza nɛ te onyukpɛ̃, ");
INSERT INTO bov_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ade bɛkavia katse awã kĩ Simon Petro dzi a. ");
INSERT INTO bov_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petro buki edzimɔ lɔlɔ kamɛ kakɔna nɛ kanyɛkatsa a kayɔ kanu akũ, ade Baguma Hũhũ a bi ye kĩ, “Bati ɛlalɛ ya bɛlamɛna nɔ kawɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yidza katsɛlamɔ be. Tavila be katomɛna kanaa kitonɛkĩ yĩ lido be.” ");
INSERT INTO bov_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ade Petro duma ɛka ɛnabi be kĩ, “Yĩ nyɛ oti a kĩ milamɛna kawɛ a. Litsa sũ mitsɛ̃?” ");
INSERT INTO bov_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɛkpa ye mbuayɛ kĩ, “Kornelio kĩ ɛnyɛ Romafɔ kawũ ɔnɔnɛ ɔnɔkɔɛ̃ lido boe fɔtɔ. Ɛnyɛ oti kĩ edzi kpĩĩ, yasum Baguma, ade Yudafɔ flee akpa ye obu a. Baguma ode fɔtɔ ɔnyanɛ odi bi ye kĩ edo batɔ nɛ nɔ sɛkɛ̃, lɔkɔa etse nɔ onukpɛ̃ kamɛ fɔlɛtsa.” ");
INSERT INTO bov_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Foesũ Petro kpa be kasɛkɔ̃ nɛ ye sɛkɛ̃ ade ɛtɛ be ndɛ ye banɔvɔɛ̃ aye a. Kĩ kade nyina a, ye mɔ batɛ badonɛ badi kĩ bito Yopa mɔ batɔ a bipi osi. ");
INSERT INTO bov_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Luwi lɛyade a, bɛnawo Kaisarea, awã kĩ Kornelio kpɔta ye tɔtɔ kamɛ bati mɔ bakɔba badi bidzi bɛkadzɔlɛ Petro kaya a. ");
INSERT INTO bov_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kĩ Petro aawo nɛ tɔtɔ a kamɛ a, Kornelio natsɛlamɔ ye, eke aduli nɛ ye abɔa kayɔ ade ɛkɛna lɔlɔ a. ");
INSERT INTO bov_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lɛmɛ Petro dzɛla ye ebi ye kĩ, “Yidza kadza! Yĩ malo otidziwa manɛ.” ");
INSERT INTO bov_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kĩ bɛkalɔmɛna a, Kornelio kpã ye ewomɛna nɛ awã kĩ bati nkaɛ a kpɔta bidzi badzɔlɛ be a. ");
INSERT INTO bov_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ade Petro bi be kĩ, “Minyina yededeede kĩ boe Yudafɔ mbla tákpa yĩ osi kĩ nnaa odi bikĩ bɛnyɛ́ Yudafɔ a sɛkɛ̃ ĩye nkɔa akũ mbɔamɔ be. Lɛmɛ Baguma nyɛ ɛtsa yĩ kĩ ntabu odima kĩ ye akũ tákpalɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nɛ foesũ kĩ batɔ a yavɛ yĩ a, ntásĩ. Litsa sũ odo bati kĩ bɛyaavɛ yĩ?” ");
INSERT INTO bov_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ade Kornelio bi ye kĩ, “Nviã fuwi ɛlalɛ, fɔ́ana ndɛ tɔdɔũ ɛlalɛ kamɛ, nkabɔa mpaɛ nɛ yĩ awã. Deedimɔapɛ onyole odi kĩ edeĩ nɛ tɛtadiɛ ovoe kĩ tata muamua kamɛ nɛ ɛta nɛ yĩ anɛ kamɛ, ");
INSERT INTO bov_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","32","ade ebi yĩ kĩ, ‘Kornelio, Baguma nu nɔ mpaɛbɔ, eyi nɔ sɛmɛ kalɛ kakɛna lɛmɛ ɔsũ. Do bati bɛnaa Yopa bɛnaakpã odi kĩ bavɛ Simon Petro. Ɛyase nɛ Simon kĩ yakɔa bayaɛ tuvoli kapamu fɔtsa nɛ mpo abuĩ a sɛkɛ̃.’ ");
INSERT INTO bov_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ade foesũ ndo batɔ nɛ nɔ sɛkɛ̃ lɛtalɛta a, ade odi foe akũ ɔya mɔatsɛ lɛmɛ a. Foesũ boe flee budzi nɛ awĩ nɛ Baguma anɛ kamɛ kĩ yaaabi boe lɛtsa a kĩ ebi nɔ kĩ bi boe a.” ");
INSERT INTO bov_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ade Petro bi ye kĩ, “Finyaakĩĩ mmɔ́ ĩyi ɔsũ kĩ Baguma ládã bati anɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mbom oti kĩ ɛdɔla ye akũ ɛkpa Baguma, yakɛna nɛ ye kawɛ akũ lɛmɛ ni, ade ye Baguma awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Matɛ kado kĩ minu kalɛ a kĩ ɛma Israelfɔ kĩ fɔnyɛ lukudɔ Kalɛ Wĩ a kĩ fɔtsɛ̃ Yesu Kristo akũ a. Ade ye lɛmɛ nyɛ katinya kamɛ bati flee Ɔlate a. ");
INSERT INTO bov_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ade minyina kalɛ kpale a kĩ fɔya nɛ Israelfɔ tite akũ, kĩ kiyi kayɔ nɛ Galilea, kito lɔkɔ a kĩ Yohanes de lɛtsã nɛ mui kawɔla amaniɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Minu lɛmɛ ayekĩ Baguma kɔa ye Hũhũ mɔ kɔbɛ̃ eko nɛ Yesu kĩ eto Nazaret a akũ. Ɛtsã emini nɛ kakɔ nyɛ kakɔ ɛkakɛna tuwĩ, ade ɛtsa bikĩ hũhũ kpa kaha be a, kitonɛkĩ Baguma tomɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Boe bɔnyɛ adansifɔ bɔkpa fɔtsa a kĩ ɛkɛna nɛ Israelfɔ tite akũ mɔ Yerusalem a. Ade ke bɛkɔ ye nɛ ye kabɔa kamɛna nɛ asendua akũ a. ");
INSERT INTO bov_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lɛmɛ Baguma dzɛla ye eto kanɔkpa nɛ luwi lɛlalɛde akũ, ade ɛfɔ̃ ɛnyɛ ye akũ ɛtsa bati a. ");
INSERT INTO bov_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Lɛmɛ nnɛ́ bati flee lɔmɔ ye, mbom boe a kĩ Baguma pau ndɛ adansifɔ a lɛmɔ́ ye. Budo awɛ bɔnya, bɔmɔa mɔ ye kĩ eyidza eto kanɔkpa liti a. ");
INSERT INTO bov_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ade boe edo kĩ bɔnaalɛ Kalɛ Wĩ a nɛ kakɔ nyɛ kakɔ, budi adansiɛ lɛmɛ kĩ Baguma kɛna Yesu batidziwa mɔ banɔkpa flee fɔlɛtsa ɔdzɛnɛ. ");
INSERT INTO bov_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Baguma onukpɛ̃ banyɛnɛ flee lɛ nɛ ye akũ kĩ odi nyɛ odi kĩ yaatɛ ye edo ni, Baguma aakɔa ye tɔkpa ete ye nɛ Yesu dĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ade kĩ Petro kalɛ kɔdzɛla a, Hũhũ Kpalɛwa a ka eko nɛ bati a flee kĩ bidzi batsɛ ye fɔlɛtsa a akũ. ");
INSERT INTO bov_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Fɔkɛna Yudafɔ batɛ badonɛ a kĩ bitomɛna Petro nɛ Yopa bɛyaa a saa, nɛ ayekĩ Baguma Hũhũ Kpalɛwa a ka eko nɛ bikĩ bɛnyɛ́ Yudafɔ lɛmɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kitonɛkĩ binu kĩ bɛkalɛ kɔdzɛla nɛ tide ahɔlɔ ahɔlɔ kamɛ ade bɛkamu Baguma Kpale a. Ade ke Petro lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ayekĩ bati kĩĩ tɛ Hũhũ Kpalɛwa a ndɛ ayekĩ boe malo bɔtɛ a sũ ni, bɔ́apuli busĩ kĩ bɔákɛna be mui kawɔla amaniɛ?” ");
INSERT INTO bov_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Foesũ ɛkpa osi kĩ bɛkɛna be mui kawɔla amaniɛ nɛ Yesu Kristo dĩ akũ. Ke liti a, bɛwã ye kĩ edzi nɛ be sɛkɛ̃ fɔtɛ fuwi fudi. ");
INSERT INTO bov_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Owi tábuna mɔ fɔtɔ banyanɛ a mɔ batɛ badonɛ bɛbã nɛ Yudea nu kĩ bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ tɛ Baguma Kalɛ Wĩ a. ");
INSERT INTO bov_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lɛmɛ kĩ Petro muniki ɛya nɛ Yerusalem a, Yudafɔ a kĩ bɛna nɛ awã a tátunɔ mɔ ye, ade bibi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ɔnakɔa nɔ akũ ɔtsɛkamɔ banɔvɔɛ̃ kĩ bitómɛna Yudafɔ fɔtsa katsa a, ade odo awɛ ɔnyamɔ be malo a!” ");
INSERT INTO bov_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ade ke Petro nyɛ fɔlɛtsa kamɛ ɛtsa be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lɔkɔ a kĩ nna nɛ Yopa nkabɔa mpaɛ a, nna kanyɛkatsa. Nɛ foe kamɛ a, mmɔ́ kĩ bɛkakɛna lima dzɛlɛwa baũ lidi kĩ bipini de nɛ atɔ ɛna, ade lɛka lɛyakpula nɛ yĩ ɔwɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bayaɛ kumɛkumɛ na nɛ lima kpale kĩĩ kamɛ, bayaɛ kĩ bideĩ abɔa ɛna, bikĩ bɛtsɛ̃ nɛ sɛmɛ akũ, mɔ kɔvɔlabi kĩ bɔába malo. ");
INSERT INTO bov_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ade nnu ɔlɛdo odi ebi yĩ kĩ, ‘Petro! Yidza kakɔ kaba!’ ");
INSERT INTO bov_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Lɛmɛ nkpa mbuayɛ kĩ, ‘Oowo! Kusɛ! Boe Ɔlate, yĩ onukpɛ̃ táta ɔyaɛ kĩ boe Yudafɔ bɔakesĩ a da.’ ");
INSERT INTO bov_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ɔlɛdo a buki ɛlɛ kĩ, ‘Ntɛ lɛtsa a kĩ Baguma kpalɛ de akũ ni, tabu kĩ efĩĩ deĩ nɛ de akũ.’ ");
INSERT INTO bov_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fɔtsa kĩĩ kɛna lɔmɔ titi ɛlalɛ flee. Ke liti a, bɛvɛlɛ lima kpale kĩĩ mɔ bayaɛ a flee bɛnamɛna ode. ");
INSERT INTO bov_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ade lɔkɔ a na kamɛ pɛpɛɛpɛ mɔ́ batɔ ɛlalɛ a kĩ bito Kaisarea bɛyaakpã yĩ a wo tɔtɔ a kĩ te kamɛ nse a. ");
INSERT INTO bov_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Baguma Hũhũ a bi yĩ kĩ ntasĩ, mbom ntomɔ be bɔnaa. Batɛ badonɛ evũ a kĩ bito Yopa a, tomɔ yĩ bɔnawo oti a kĩ ye lido batɔ a tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ye malo ebi boe ayekĩ Baguma fɔtɔ ɔnyanɛ nyɛ ye akũ ɛtsa ye, ebi ye kĩ, ‘Naawɛ odi kado ye nɛ Yopa ɛnaavɛ onyole odi kĩ bavɛ Simon Petro. ");
INSERT INTO bov_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yaabi nɔ ayekĩ mimɔ nɔ tɔtɔ kamɛ bati flee míana katɛ.’ ");
INSERT INTO bov_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ke liti a, ĩyi kayɔ mɔ be Baguma fɔlɛtsa a kabi. Hũhũ Kpalɛwa a ka eko nɛ be akũ ndɛ ayekĩ eko nɛ boe flee akũ nɛ kayɔkayi a. ");
INSERT INTO bov_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ade ke nte anɛ nɛ lɛtsa a kĩ boe Ɔlate lɛ eyi kĩ, ‘Nuwĩnuwĩ, Yohanes kɔa mui ɛwɔla bati mui, lɛmɛ Baguma aakɔa Hũhũ Kpalɛwa ɛwɔla mi mui.’ ");
INSERT INTO bov_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ade kĩ Baguma lɛkpa bikĩ bɛnyɛ́ Yudafɔ a futetsa kĩĩ ndɛ ayekĩ ɛkpa boe kĩ bɔtɛ boe Ɔlate Yesu Kristo budo sũ ni, yĩ nyɛ owei kĩ masua Baguma osi!” ");
INSERT INTO bov_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kĩ binu fɔlɛtsa kĩĩ a bɛfɔ̃ atsindze katɛ ade bimu Baguma bɛlɛ kĩ, “Ɔnɔkɔali, Baguma binya osi ɛkpa bati bɛbã lɛmɛ kĩ bɛdani tɔwɔlɛ kamɛ lɔkɔa bɛna nkpã kĩ ɛla kawũna a!” ");
INSERT INTO bov_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nɛ lɔkɔ a na kamɛ kĩ fukĩĩ bamɛ lamɛna kaya a, batɛ badonɛ a kĩ bilo tɛnya kakɛna nɛ Stefano wuda sũ a, lo bɛnaa Foenike, Kipro mɔ Antiokia tɛmatɔ a kamɛ. Bimini bɛlɛ Baguma kalɛ a bɛkpa Yudafɔ odi. ");
INSERT INTO bov_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lɛmɛ batɛ badonɛ bɛbã a kĩ bito Kipro mɔ Kirene naa Antiokia bɛnabi Grikifɔ Baguma kalɛ a nɛ boe Ɔlate Yesu akũ. ");
INSERT INTO bov_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nɛ kĩ boe Ɔlate kɔbɛ̃ na nɛ be kamɛ sũ bati pii tɛ bido. ");
INSERT INTO bov_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kĩ batɛ badonɛ nɛ Yerusalem nu lɛtsa a kĩ lɛya nɛ Antiokia a, bido Barnaba kĩ ɛnaa awã. ");
INSERT INTO bov_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kĩ ewo awã a, ɛmɔ́ ayekĩ Baguma bumɔ be a, kawɔlɛ de ye paa, ade ɛkpa be kɔdɛ kĩ bɛkɔa be tɔwɔlɛ flee bite nɛ boe Ɔlate akũ a. ");
INSERT INTO bov_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba nyɛ oti wĩ, edeĩ katɛkado ade Hũhũ Kpalɛwa a lɛmɛ tɛ ye kamɛ. Futo ye akũ sũ ni, bati pii tɛ boe Ɔlate bido. ");
INSERT INTO bov_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ke liti a, Barnaba naa Tarso kĩ yanaawɛ Saulo nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kĩ ɛmɔ ye a, ɛkpã ye bɛnaa Antiokia. Bɛna nɛ awã kateli mɔa flee, bɛkatsɛna bati pii katsa be fɔtsa. Ade Antiokia mɔ bɛnya lɔtɔ bɛvɛ batɛ badonɛ a kĩ Kristofɔ a. ");
INSERT INTO bov_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nɛ lɔkɔ a na kamɛ ni, Baguma onukpɛ̃ banyɛnɛ badi to Yerusalem bɛya nɛ Antiokia a. ");
INSERT INTO bov_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ade Agabo kĩ ɛnyɛ be kamɛ ɔmɔa yidza ɛdza nɛ be katsɛnakɔ̃, ade nɛ Baguma Hũhũ kɔbɛ̃ onukpɛ̃ ni, ɛlɛ eyi kĩ kɔlɛ kpale aanɛ nɛ katinya flee kamɛ. Fukĩĩ yaya nɛ lɔkɔ a kĩ Klaudio nya Romafɔ Lɛgãnɔkɔɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nɛ foesũ batɛ badonɛ a yake otse kĩ baate fɔtsa fudi bɛkɔa bɛmɛna be bawaɛ̃ nɛ Yudea. Be kamɛ odi nyɛ odi te ayekĩ yaapuli. ");
INSERT INTO bov_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kĩ bɛkpɔta fɔtsa kĩĩ a, bɛkɔa foe bɛkpa Barnaba mɔ Saulo kĩ bɛkɔa bɛma batɛ badonɛ banɔkɔɛ̃ a nɛ Yudea. ");
INSERT INTO bov_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nɛ lɔkɔ a na kamɛ, Lɛgã Herodes pi batɛ badonɛ a badi kĩ bɛkɔ be. ");
INSERT INTO bov_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɛfɔ̃ bɛkɔ Yakobo kĩ ɛnyɛ Yohanes ɔwaɛ̃ a mɔ lɛpamɛ. ");
INSERT INTO bov_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kĩ ɛmɔ kĩ kawɔlɛ de Yudafɔ a sũ ni, ɛfɔ̃ bipi Petro lɛmɛ. Ɛkɛna foe nɛ Abodoo Kĩ Ɛtáyila Fuwi Kanya a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bɛkɔa ye bido nɛ kɔla kamɛ, awã kĩ sodzafɔ ɛna ɛna na nɛ kutsu ɛna kamɛ kavɛmɛna akũ kadzɔlɛ ye akũ. Herodes nhihiɛ nyɛ kĩ yaakɔa ye ɛkpa kanade a bɛdzɛmɔ ye ntɛ bɛnya Wuda Katɛ̃ Luwi a biyua. ");
INSERT INTO bov_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Foesũ sodzafɔ a kadzɔlɛ ye akũ kadzɔlɛ wĩ nɛ kɔla a kamɛ. Lɛmɛ batɛ badonɛ a kabɔa mpaɛ nɛ ye lɔlɔ kakpa Baguma mɔ ɔsĩ mɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lɛnyɛ a kĩ ke kade kanyina kamɛ Herodes aakɔa Petro ɛkpa bati a, Petro waa tida nɛ sodzafɔ nviã kayite. Bido ye nkɔsɔnkɔsɔ nviã ade sodzafɔ bɛbã dzɛ̃ nɛ opunu liti badzɔlɛ kɔla akũ a. ");
INSERT INTO bov_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Deedimɔapɛ ɔhaĩ odi mɔanɛ nɛ kɔla a kamɛ. Ade ke ode Baguma fɔtɔ ɔnyanɛ odi nɛ ɛdza nɛ Petro ɔwɛ̃ a. Ɛbɔa Petro nɛ lɔbɔtɛɛ enyina ye, ade ebi ye kĩ, “Yidza mɔatsɛ!” Lɛtalɛta nkɔsɔnkɔsɔ a nɛ́ nɛ ye akpɔ ɛtɔ nɛ tite. ");
INSERT INTO bov_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ade ode fɔtɔ ɔnyanɛ a bi ye kĩ, “Bɔɛ nɔ tɛtadiɛ, kado nɔ mpabua lɛmɛ.” Petro kɛna foe lɔmɔ, ade ode fɔtɔ ɔnyanɛ a buki ɛlɛ kĩ, “Bɔɛ nɔ atadiɛ kpale katsa akũ katomɔ yĩ.” ");
INSERT INTO bov_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Foesũ Petro tomɔ ye bɛnɛ nɛ kɔla a kamɛ. Ɛtányi ntɛ lɛtsa a kĩ ode fɔtɔ ɔnyanɛ a kakɛna a nyɛ ɔnɔkɔali, mbom ɛkɔna kĩ kɔda kamɛ fɔanɛ. ");
INSERT INTO bov_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bɛtɛ̃ kawũ banɔnɛ katsu katɔnyade mɔ kayade a kĩ badzɔlɛ tunyukpɛ̃ akũ a. Kĩ biwo fɔbɔtsaɛ onyukpɛ̃ a kĩ babinya kawo nɛ ɔmatɔ kamɛ a, onyukpɛ̃ a mɔawɛ binya nɛ ye akũ akũ ade bɛtɛ̃ a. Kĩ bɛnaa lɔtɔ sukuloo a, Baguma ode fɔtɔ ɔnyanɛ a dzakũ ɛfɔnɛ ye. ");
INSERT INTO bov_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kĩ anɛ kamɛ kpalɛ Petro a, ɛyanyi lɛtsa a kĩ lɛya nɛ ye akũ, ade ebi ye akũ kĩ, “Finyaakĩĩ, mmɔ́ kĩ ɔnɔkɔali fɔanɛ. Boe Ɔlate do ye ode fɔtɔ ɔnyanɛ kĩ ɛyaanyɛ yĩ etomɛna Herodes awɛ kamɛ mɔ lɛtsa a kĩ Yudafɔ hihiɛ kĩ baakɛna yĩ a kamɛ!” ");
INSERT INTO bov_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kĩ ɛmɔ lɛtsa a kĩ lɛya nɛ ye akũ a, ɛdzakũ ɛnaa Maria kĩ ɛnyɛ Yohanes Marko ɔma awã. Bati pii tsɛna nɛ awã bɛkabɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ade kĩ Petro dza ɛkabɔa kanya opunu a, katsolebi abawa kĩ bavɛ Roda yabinya kɔla a. ");
INSERT INTO bov_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kĩ eyi Petro odo ɔsũ a, kawɔlɛ de ye paa, foesũ ɛtábinya opunu a, mbom ewula atsɛ ɛnakpa bati a kanyi kĩ Petro dzɛ̃ nɛ opunu liti. ");
INSERT INTO bov_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bati a tátɛ bido foesũ bibi ye kĩ, “Kamɔ aamɔ mbɔɛɛ?” Lɛmɛ kĩ ɛdzɛmɛna kalɛ kĩ nuwĩ fɔanɛ sũ ni, bibi be akũ kĩ, “Ɔsa fɔ́anya ye Baguma ode fɔtɔ ɔnyanɛ.” ");
INSERT INTO bov_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lɔkɔa na flee Petro dzɛmɔ opunu a kabɔa. Kĩ bibinya opunu bɛmɔ́ ye a, akũ dzuli be. ");
INSERT INTO bov_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ete be awɛ kĩ bɛkɛna dĩĩ, ade ebi be ayekĩ boe Ɔlate nyɛ ye etomɛna kɔla a kamɛ a. Ebi be kĩ, “Mibi Yakobo mɔ batɛ badonɛ nkaɛ a lɛtsa a kĩ lɛya a.” Ke liti a, ɛdzakũ nɛ awã ɛnaa kakɔ bɛbã. ");
INSERT INTO bov_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kĩ kade nyina, kukũtila mɔ ɔtutũ kpale wo nɛ sodzafɔ a kamɛ nɛ kawakɔ̃ a, ade bɛkavia be akũ kĩ, “Ndia koũ Petro tsã?” ");
INSERT INTO bov_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kĩ Herodes wɛ Petro kayɛla evia a, ɛfɔ̃ bipi sodzafɔ a bivia be onukpɛ̃ kamɛ tuwuli. Ɛkɔ be kɔtɔ ɛfɔ̃ bɛkɔ be. Ke liti a, Herodes dzakũ nɛ Yudea ɛnaa Kaisarea, ɛnadzi nɛ awã fuwi fudi. ");
INSERT INTO bov_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Lɔkɔ a na kamɛ Herodes na kalɔkpa nɛ Tirofɔ mɔ Sidomfɔ akũ. Foesũ bɛkɛna ɔmɔa bɛya nɛ ye sɛkɛ̃. Bɛnya lɔtɔ bɛnamɔ Blasto, kĩ ɛnyɛ Herodes tɔtɔ akũ ɔdãmɛnanɛ, kĩ eke Herodes aduli ɛkpa be. Bɛwɛ kĩ tɛmatɔ nviã a tɛkɛna ɔmɔa mɔ Herodes, kitonɛkĩ ye tite akũ bana funitsã katomɛna. ");
INSERT INTO bov_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nɛ luwi a kĩ Herodes yi ɛkpa be akũ a, edo ye fɔgãtsa edzi nɛ ye lɛgãkpo akũ, ade ɛkabi ɔmaĩ a fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nɛ ye kɔdzɛla kawũna kamɛ a, bati a mu ye mɔ fɔwɔla bɛlɛ kĩ, “Fukĩĩ kɔ̃ nnɛ́ otidziwa lamɛna kɔdzɛla kalɛ. Baguma Kpale lamɔ kɔdzɛla kalɛ!” ");
INSERT INTO bov_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Deedimɔapɛ ode fɔtɔ ɔnyanɛ yabɔa Herodes emuni, kitonɛkĩ ɛtákpa Baguma obu. Ewo batsɛ bɛba ye kamɛ kamɛ, ade ke eku a. ");
INSERT INTO bov_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nɛ lɔkɔ a na kamɛ Baguma kalɛ a gba nɛ fɔkɔ pii, ade batɛ badonɛ a lɛmɛ pɔ bibu a. ");
INSERT INTO bov_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kĩ Barnaba mɔ Saulo yua be adzuma a kĩ bido be a, bɛdzakũ nɛ Yerusalem ade bɛkpã Yohanes Marko bibumɔ be akũ a. ");
INSERT INTO bov_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Baguma onukpɛ̃ banyɛnɛ mɔ fɔtsa batsanɛ badi na nɛ batɛ badonɛ a kamɛ nɛ Antiokia. Ade be nyɛ Barnaba mɔ Simeon kĩ bavɛ Oti Ɔɔwa, Lukio kĩ eto Kirene tite akũ, Manahen kĩ bɛmɔ Lɛgã Herodes bɛdɔɔla nɛ be tibisɛ̃ kamɛ, mɔ Saulo. ");
INSERT INTO bov_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kĩ bɛna nɛ awã bɛkamu boe Ɔlate, bɛkasui onukpɛ̃ lɛmɛ a, Hũhũ Kpalɛwa bi be kĩ, “Minyɛ Barnaba mɔ Saulo miyi lite lɔkɔa bɛnaakɛna adzuma a kĩ foesũ nvɛ be a.” ");
INSERT INTO bov_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nɛ foesũ bisui onukpɛ̃ bɛbɔa mpaɛ, bite awɛ nɛ be akũ ade bɛnyɛ be osi a. ");
INSERT INTO bov_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kĩ Hũhũ Kpalɛwa lido be sũ ni, bɛnaa ɔmatɔ a kĩ bavɛ Seleukia kamɛ. Awã na bidzi ɔkɔlɔ binyina bɛnaa Kipro tite kĩ mui tsua bisinya te a akũ. ");
INSERT INTO bov_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kĩ biwo Salami ɔmatɔ kamɛ a, bɛnalɛ Baguma Kalɛ Wĩ nɛ Yudafɔ fɔtsɛnakɔ̃. Yohanes Marko lɛmɛ tomɔ be ndɛ be obumɛnanɛ aye. ");
INSERT INTO bov_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kĩ bɛtsã mpo akũ bɛnawo Pafo ɔmatɔ a kamɛ a, bɛtsɛlamɔ Yudani odi kĩ yaveli tɔɔta. Bavɛ ye kĩ Yesuobi, ade ɛbɔɛ ye akũ kĩ ɛnyɛ onukpɛ̃ ɔnyɛnɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ɔwanɛ kĩĩ mɔ tite a akũ ɔdãnɛ kĩ bavɛ Sergio Paulo nyɛ bakɔba. Abãã ɔnɔkɔɛ̃ kĩĩ tsua linebi. Ɛvɛ Barnaba mɔ Saulo bɛnaa ye awã kitonɛkĩ ɛwɛ kĩ yatse Baguma fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lɛmɛ kĩ bɛnaa awã a, ɔwanɛ a kĩ babuki kavɛ Elima nɛ Griki tide kamɛ a, tɛ atsindze mɔ be. Ɛwɛ kĩ yadani ɔnɔkɔɛ̃ a adzuni nɛ lɛtsa a kĩ Saulo mɔ Barnaba lɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Lɛmɛ Hũhũ Kpalɛwa a kɔbɛ̃ tɛ Saulo kĩ babuki kavɛ Paulo kamɛ ade eke anɛ nɛ ɔwanɛ a akũ fɛɛ ɛlɛ kĩ, “Nɔ Abonsam obi! Ɔnyɛ okesĩnɛ ɔkpa tuwĩ tidi nyɛ tidi kakɛna. Tɛdake mɔ tɔkpa yi nɔ kamɛ flee. Luwi daa abɔa mbɔdi kĩ adani boe Ɔlate ɔnɔkɔali kalɛ a liti mɔ lɔtɔ! ");
INSERT INTO bov_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Dã, boe Ɔlate aavɛlɛ nɔ sɔtɔ finyaakĩĩ. Yaafɔ̃ oku anɛ, ade ɔláabuki ɔmɔ́ suwa kɛnaawo lɔkɔ lidi a.” Lɛtalɛta Elima anɛ kamɛ ke ɔtũ, ade ke ebuki yaámɔ fɔkɔ a. Ɛkatalɛ fɔkɔ kĩ yawɛ odi kĩ epi ye nɛ kɔkpɔ. ");
INSERT INTO bov_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kĩ abãã ɔnɔkɔɛ̃ kĩĩ mɔ́ lɛtsa a kĩ lɛya a, ɛtɛ edo kitonɛkĩ fɔtsa katsa nɛ boe Ɔlate kalɛ wĩ a akũ kɛna ye wãwã paa. ");
INSERT INTO bov_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ke liti a, Paulo mɔ bikĩ bitomɔ ye a wo nɛ ɔkɔlɔ kamɛ bito Pafo bɛnaa Perge ɔmatɔ a kĩ edeĩ nɛ Pamfilia tite kamɛ. Ade awã mɔ Yohanes Marko dzakũ ɛfɔnɛ be emuniki ɛnaa Yerusalem a. ");
INSERT INTO bov_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kĩ bito Perge a, bɛyawo Antiokia kĩ edeĩ nɛ Pisidia. Nɛ Kawɛya Luwi akũ a ni, bɛnaa Yudafɔ katsɛnakɔ̃ a bɛnadzi nɛ bati a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ade kĩ bɛkã fɔlɛtsa nɛ Mose mbla, mɔ Baguma onukpɛ̃ banyɛnɛ tuvoli kamɛ biyua a, katsɛnakɔ̃ banɔkɔɛ̃ a bi be kĩ, “Nwaɛ̃ amɛ, ntɛ mideĩ kadi kĩ míalɛ mido boe kɔbɛ̃ ni, osi waa, milɛ faa.” ");
INSERT INTO bov_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ade Paulo yidza ɛdza ete be awɛ ɛlɛ kĩ, “Nwaɛ̃ Israelfɔ mɔ mi a kĩ minyɛ́ Israelfɔ lɛmɛ miasum Baguma a, mitse katse wĩ! ");
INSERT INTO bov_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelfɔ Baguma lɛpau boe bawanyɔ, ade ɛkɛna be ɔmaĩ kpale nɛ lɔkɔ a kĩ bɛnya banɔvɔɛ̃ nɛ Egipte a. Ye mɔawɛ lɛnyɛ be etomɛna Egipte tɛsate kamɛ mɔ ye kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ade ɛdãmɛna be akũ futeli tɛna flee nɛ lɔkɔ a kĩ bɛna nɛ kɔsa kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɛwɔla fude evũkɔnɔ bati nɛ Kanan tite akũ, ade ɛkɔa te ɛkpa Israelfɔ kĩ tɛnya be adzapadiɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Fukĩĩ flee ya nɛ ndɛ futeli ɔha ɛna mɔ aduenum kamɛ. “Ke liti a, Baguma kpa be fɔlɛtsa badzɛnɛ bɛnya be akũ flee kɛyawo Baguma Onukpɛ̃ Ɔnyɛnɛ Samuel akũ. ");
INSERT INTO bov_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bivia ye kĩ edzina lɛgã ɛkpa be, ade Baguma pau Saulo, kĩ ɛnyɛ Kis obi ɛkpa be a. Eto Benyamin kasinu a kamɛ, ade ɛnya lɛgã futeli tɛna flee a. ");
INSERT INTO bov_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lɛmɛ Baguma dzɛla ye nɛ lukpo a akũ, ade ɛkɔa Dawid ɛkɛna lɛgã a. Ade lɛtsa a kĩ Baguma lɛ nɛ ye akũ nyɛ kĩ, ‘Yese obi Dawid nyɛ oti kĩ yĩ ɔwɔlɛ awɛ, kitonɛkĩ yaakɛna nɛ yĩ kawɛ akũ.’ ");
INSERT INTO bov_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ade Dawid kasinu a kamɛ Baguma nyɛ Ɔtɛnɛ a kĩ ɛnyɛ Yesu ɛkpa Israelfɔ ndɛ ayekĩ ɛlɛ eyi a. ");
INSERT INTO bov_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fɔmɔ Yesu aayi ye adzuma kayɔ a, Yohanes mui ɔwɔlanɛ a de lɛtsã ebi bati Israelfɔ flee kĩ bɛdani tɔwɔlɛ kamɛ lɔkɔa bɛtɛ mui kawɔla amaniɛ. ");
INSERT INTO bov_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kĩ Yohanes aawũna ye adzuma kakɛna a, evia bati a kĩ, ‘Mikɔna kĩ yĩ nyɛ Oti a Kĩ Bɛbɔa Tɔdɔ̃ a mbɔɛɛ? Oowo! Lɛmɛ etomɛna yĩ nɛ liti yaya, ade ntáfɛta kĩ mawũnya mpabua nɛ ye abɔa malo a.’ ");
INSERT INTO bov_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nwaɛ̃ amɛ Israelfɔ, Abraham babi mɔ bawa, mɔ mi a kĩ minyɛ́ Yudafɔ lɛmɛ miasum Baguma, bɛkɔa katɛ fɔlɛtsa kĩĩ bɛma boe flee. ");
INSERT INTO bov_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nɛ ayekĩ bikĩ bideĩ nɛ Yerusalem mɔ be banɔkɔɛ̃ a tányi kĩ ye nyɛ Ɔtɛnɛ, ĩye binu Baguma onukpɛ̃ banyɛnɛ fɔlɛtsa a kĩ bakã nɛ Kawɛya Luwi lidi nyɛ lidi akũ kayɔ sũ ni, fɔlɛtsa a ya nɛ foe kamɛ lɔmɔ, ade bɛkɔ ye kɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Titɔ kĩ bɛtámɔ tɔkpa tidima nɛ ye akũ malo ni, bɛkɔ ye kɔtɔ ade bɛfɔ̃ Pilato kpa osi bɛkɔ ye a. ");
INSERT INTO bov_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ade kĩ bɛkɛna lɛtsa nyɛ lɛtsa biyua ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ eyi nɛ ye akũ a, bɛnyɛ ye nɛ asendua akũ bɛnabila nɛ linikɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lɛmɛ Baguma dzɛla ye etomɛna kanɔkpa ebuki edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nɛ fuwi pii na kamɛ ni, ɛnyɛ ye akũ ɛtsa bikĩ bɛmɔ ye bɛtsã bito Galilea bɛnaa Yerusalem. Ade be nyɛ ye adansifɔ bɛkpa Israelfɔ finyaakĩĩ a. ");
INSERT INTO bov_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Finyaakĩĩ bɔkɔa Kalɛ Wĩ a bɔama mi, kĩ Baguma fɔlɛtsa a kĩ ɛlɛ eyi nɛ boe bawanyɔ lɔkɔ a ya nɛ foe kamɛ nɛ boe lɔkɔ. Baguma fɔ̃ Yesu yidza edzi nkpã ndɛ ayekĩ Dawid tsɛlɛ nɛ ɔnɔ ɔyade a kamɛ kĩ, ‘Nɔ nyɛ yĩ obi. Nviã kĩĩ nkɛna nɔ Ɔlɛga.’ ");
INSERT INTO bov_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ade lɛtsa a kĩ Baguma lɛ eyi nɛ ye kadzɛla katomɛna kanɔkpa nyɛ kĩ ye sukɛna lɛláavɔ̃ nɛ linikɛ kamɛ da. Baguma lɛ kĩ, ‘Maakɔa nhila kpalɛwa a kĩ nlɛ ĩyi nkpa Dawid a nkpa nɔ.’ ");
INSERT INTO bov_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ebuki ɛlɛ nɛ Dawid ɔnɔ bɛbã kamɛ kĩ, ‘Ɔláafɔ̃ nɔ oti kpalɛwa a lɛvɔ̃ nɛ linikɛ kamɛ.’ ");
INSERT INTO bov_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Kĩ Dawid kɛna nɛ Baguma fɔwɛtsa akũ lɔkɔ a kĩ edzi nkpã eyua a, eku bɛbɔɛ ye bibila nɛ ye bawanyɔ ɔwɛ̃, ade ɛvɔ̃ nɛ linikɛ kamɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lɛmɛ oti a kĩ Baguma dzɛla etomɛna kanɔkpa a sukɛna távɔ̃ nɛ linikɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nwaɛ̃ amɛ, bɔwɛ kĩ minyi kĩ fɔtsɛ̃ Yesu akũ mɔ bide lɛtsã nɛ Baguma tɔkpa kakɔakate a bɛkpa mi. ");
INSERT INTO bov_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Odi nyɛ odi kĩ yaatɛ Yesu edo ni, Baguma aabɔɛ ye kĩ ɛnya ɔtɔbɛ. Ade fukĩĩ Mose mbla a tápuli ɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Foesũ midã kadã wĩ ayekĩ Baguma onukpɛ̃ banyɛnɛ fɔlɛtsa a kĩ bɛlɛ biyi a lɛlaaya nɛ mi akũ. ");
INSERT INTO bov_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kitonɛkĩ Baguma lɛ kĩ, ‘Midã mi a kĩ miadi kalɛ a nsekuo! Fɔkɛna mi saa lɔkɔa miwɔ. Kitonɛkĩ lɛtsa a kĩ makɛna nviã kĩĩ a ntɛ odi nyɛ foe kayɔ ɛtsa mi malo, miláatɛ foe mido!’ ” ");
INSERT INTO bov_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kĩ Paulo mɔ Barnaba adzakũ nɛ katsɛnakɔ̃ a, bati a bi be kĩ bibuki bɛya nɛ Kawɛya Luwi a kĩ laayaa akũ, lɔkɔa bɛyaaabi be fɔlɛtsa a bibu. ");
INSERT INTO bov_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kĩ bɛpansam nɛ katsɛnakɔ̃ a, Yudafɔ pii mɔ bikĩ bɛdani bɛkɛna Yudafɔ bavila Baguma lɛmɛ a, tomɔ Paulo mɔ Barnaba. Fɔtɔ banyanɛ a dɛ be kĩ bɛdza pintii nɛ Baguma kɔnyakamɔ a kĩ edeĩ ɛkpa be a sũ. ");
INSERT INTO bov_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nɛ Kawɛya Luwi lɛyade akũ a, kite sukuloo ɔmatɔ a flee yabɔa obũ nɛ katsɛnakɔ̃ a kĩ batse boe Ɔlate kalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kĩ Yudafɔ banɔkɔɛ̃ a mɔ́ bati lidede kĩĩ odu nɛ katsɛnakɔ̃ a, anɛ bɛɛlɛ be. Bɛvɛlɛ fɔlɛtsa mɔ Paulo nɛ lɛtsa a kĩ de ɛlɛ a akũ ade bivũna ye a. ");
INSERT INTO bov_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lɛmɛ Paulo mɔ Barnaba lɛ kɔdzɛla mɔ kɔbɛ̃ kĩ, “Kɛnɛ kĩ bɔnya lɔtɔ bubi mi Yudafɔ Baguma kalɛ kĩĩ. Lɛmɛ kĩ misĩ ke kĩ mitákpɔla mikpa nkpã kĩ ɛla kawũna a sũ ni, bɔkɔa ke bɔama bikĩ bɛnyɛ́ Yudafɔ a. ");
INSERT INTO bov_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kitonɛkĩ ade ɔlɛdo kĩ Baguma kpa boe kĩ, ‘Nkɛna nɔ ndɛ ɔsɛdza nkpa bikĩ bɛnyɛ́ Yudafɔ a ayekĩ katinya kamɛ bati flee aana katɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kĩ bikĩ bɛnyɛ́ Yudafɔ a nu fɔlɛtsa kĩĩ a, kawɔlɛ de be, ade bimu boe Ɔlate kalɛ a. Ade bikĩ Baguma pau kĩ bɛna nkpã kĩ ɛlá kawũna a, dani bɛkɛna batɛ badonɛ a. ");
INSERT INTO bov_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Baguma Kalɛ a gba nɛ tite a na flee akũ. ");
INSERT INTO bov_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lɛmɛ Yudafɔ a fɔ̃ batsole badi kĩ obu deĩ nɛ be akũ kĩ basum Baguma lɛmɛ, mɔ ɔmatɔ banɔkɔɛ̃ a biyidza bɛdza nɛ Paulo mɔ Barnaba akũ, ade bɛblɔmɛna be nɛ be kayite a. ");
INSERT INTO bov_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ade kĩ Paulo mɔ Barnaba anɛ nɛ ɔmatɔ a kamɛ a, bɛkpa be abɔa kudu biko ɔmatɔ a bɛkɔa batsa kĩ bisĩ be. Ke liti a, bɛdzakũ bɛnaa Ikonio. ");
INSERT INTO bov_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kawɔlɛ de batɛ badonɛ nɛ Antiokia ade Hũhũ Kpalɛwa a lɛmɛ yi be kamɛ paa a. ");
INSERT INTO bov_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kĩ biwo Ikonio a, Paulo mɔ Barnaba naa Yudafɔ katsɛnakɔ̃. Ayekĩ bɛlɛ kalɛ wĩ a fɔ̃ Yudafɔ mɔ Grikifɔ pii tɛ bido. ");
INSERT INTO bov_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ade Yudafɔ a kĩ bɛtátɛ boe Ɔlate kalɛ wĩ kĩĩ bido a kɔa ɔdzɛ bido nɛ bikĩ bɛnyɛ́ Yudafɔ a mɔ Paulo mɔ Barnaba kayite. ");
INSERT INTO bov_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Lɛmɛ fɔtɔ banyanɛ kĩĩ kahɔ nɛ ɔmatɔ a kamɛ lɔkɔ gɛlɛɛlɛ, bɛlɛ kalɛ boe Ɔlate akũ mɔ kɔbɛ̃. Ade ɛnyɛ ye kawɛ ɛtsa ɛfɔ̃ bɛkɛna awãwã mɔ nsɛntsɛlɛni fɔtsa pii a. ");
INSERT INTO bov_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Fɔyaya kĩ bati nɛ ɔmatɔ a kamɛ sɛ̃ nɛ kutsu nviã kamɛ, badi tomɔ Yudafɔ a ade badi lɛmɛ tomɔ fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Nɛ lɔkɔ a kamɛ a, bamatɔnɛ a badi, Yudafɔ mɔ be banɔkɔɛ̃ a flee yidza kĩ bayaaha be, bɛnɔ be boe. Kĩ fɔtɔ banyanɛ a nu foe a bilo bɛnaa Likaonia tɛmatɔ a kĩ tɛnyɛ Listra mɔ Derbe mɔ tikĩ tideĩ nɛ kayite a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ade bɛnalɛ Kalɛ Wĩ a nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kĩ biwo Listra a bɛmɔ́ onyole odi kĩ eveliveli. Kito nɛ ye lɛmawi ɛtápuli eyidza ɛtsã da. ");
INSERT INTO bov_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Edzi nɛ awã ɛkatse fɔlɛtsa a kĩ Paulo kalɛ a. Kĩ Paulo mɔ eyi ɔsũ kĩ oti kĩĩ tɛ edo kĩ baapuli bɛtsa ye sũ ni, ");
INSERT INTO bov_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ɛdã ɔsɔnɛ a koee ade ɛlɛ kɔɔba kĩ, “Yidza kadza ɔkpalɛ!” Onyole kĩĩ ta eyidza ade edo kato katɛ̃ awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kĩ bati a kĩ bɛdzɛ̃ nɛ awã batse kalɛ a mɔ́ lɛtsa a kĩ Paulo kɛna a, bɛbɔa fɔwɔla nɛ Likaonia tide kamɛ kĩ, “Baviɔ̃ banɛ, bɛka bɛya ndɛ batidziwa aye nɛ boe kayite!” ");
INSERT INTO bov_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Foesũ bite Barnaba dĩ kĩ Zeus. Bite Paulo lɛmɛ kĩ Herme, kitonɛkĩ ade ye lɛdza ɛkalɛ kɔdzɛla a. ");
INSERT INTO bov_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Adeke Zeus oviɔ̃late a kĩ ye kuviɔ̃la kpale dza nɛ ɔmatɔ ɔbaɛ̃ a, nakpã banantsue ɛbɔɛ flawasi lɛka lɛmɛ ɛyamɛna nɛ ɔmatɔ a kɔbã onyukpɛ̃ kĩ bayaabɔa afɔliɛ bɛkpa fɔtɔ banyanɛ a. ");
INSERT INTO bov_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kĩ Paulo mɔ Barnaba nu lɛtsa kĩ bati a wɛ kĩ bakɛna a, bɛyɛlɛ be akũ tɛtadiɛ. Foesũ biwula atsɛ biwo nɛ bati a kamɛ, bɛbɔa fɔwɔla kĩ, ");
INSERT INTO bov_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nda amɛ, nde sũ miakɛna fukĩĩ odu? Boe malo batidziwa bɔanɛ ndɛ mi aye. Bɔya nɛ awĩ kĩ bɔkɔa kalɛ wĩ a bɔma mi. Mifɔ̃ fɔtsa a kĩ fɔlá kayɔ kakɛna lɔkɔa midani mimu Baguma kĩ edzi nkpã a. Ade ye lɛkɛna tite mɔ ode, mpo mɔ fɔtsa a kĩ fudeĩ nɛ foe kamɛ a flee a! ");
INSERT INTO bov_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kɔkɔɛ a ɛnyɛ anɛ nɛ batidziwa flee akũ ɛfɔ̃ bɛkakɛna lɛtsa a kĩ bawɛ a. ");
INSERT INTO bov_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lɛmɛ ebuki yanyɛ ye fɔkɛlatsa katsa boe kĩ fɔatsa kĩ nuwĩ edzi nkpã. Lɔkɔ nyɛ lɔkɔ fɔtsa deĩ kĩ fɔakai boe ye tudzuma wĩ a. Yakpa boe oni lɔkɔ nyɛ lɔkɔ, fudutsa nɛ lɔkɔ wĩ akũ, funitsã mɔ kawɔlɛ lɛmɛ.” ");
INSERT INTO bov_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Titɔ kĩ bɛlɛ fɔlɛtsa kĩĩ lɔmɔ malo ni, fɔna ɔsĩ fɔmɔ bati a fɔ̃ afɔliɛ kabɔa kakpa be. ");
INSERT INTO bov_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ade Yudafɔ badi to Antiokia nɛ Pisidia, mɔ Ikonio bɛyadani bati a adzuni a. Bɛfɔ̃ bɛtalɛ Paulo boe bɛvɛlɛ ye bɛnɛmɛna nɛ ɔmatɔ a kamɛ nɛ kĩ bɛkɔna kĩ eku sũ. ");
INSERT INTO bov_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lɛmɛ kĩ batɛ badonɛ a yatsɛna nɛ ye akũ a, eyidza ɛdza ade emuniki ɛnaa ɔmatɔ a kamɛ a. Kĩ kade nyina a, bɛmɔ Barnaba bɛdzakũ bɛnaa Derbe. ");
INSERT INTO bov_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo mɔ Barnaba de lɛtsã nɛ Kalɛ Wĩ a akũ nɛ Derbe, ade bɛna batɛ badonɛ pii nɛ awã a. Bimuniki bito awã bɛnaa Listra, Ikonio mɔ Antiokia nɛ Pisidia. ");
INSERT INTO bov_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Awã na bɛdɛ batɛ badonɛ a, bido be kɔbɛ̃ lɛmɛ kĩ bidi ɔnɔkɔali nɛ be katɛkado kamɛ. Ade bibi be lɛmɛ kĩ, “Kɛnɛ kĩ bɔtsã lubo kamɔ pii kamɛ fɔmɔ bɔawo nɛ Baguma lɛgãkanyakɔ̃ a kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ade ke Paulo mɔ Barnaba pau lɔtɔ banyanɛ bɛkpa asɔli adi nyɛ adi a. Bɛtsã mpaɛbɔ mɔ onukpɛ̃ kasui kamɛ bɛkɔa be bido nɛ boe Ɔlate a kĩ bɛtɛ bido a awɛ. ");
INSERT INTO bov_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ade kĩ bimini nɛ Pisidia tɛmatɔ kamɛ biyua a, bɛdani bɛnaa Pamfilia tite kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bɛlɛ kalɛ wĩ a nɛ Perge fɔmɔ bɛtɛ̃ bɛnaa Atalia. ");
INSERT INTO bov_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ade awã binyina mpo bɛnaa Antiokia, awã kĩ bɛnya lɔtɔ bɛkɔa be bido nɛ Baguma awɛ kamɛ nɛ adzuma a kĩ bɛkɛna biyua finyaa a. ");
INSERT INTO bov_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kĩ biwo Antiokia a, bɛkpɔta batɛ badonɛ a flee nɛ awã, bɛbɔa be osi akũ amandiɛ. Ade bibi be fɔtsa flee a kĩ Baguma kɛna ɛtsãmɛna be akũ mɔ ayekĩ ebinya katɛkado osi ɛkpa bikĩ bɛnyɛ́ Yudafɔ a. ");
INSERT INTO bov_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bidzi nɛ batɛ badonɛ nɛ Antiokia sɛkɛ̃ owi buna kɔlaa. ");
INSERT INTO bov_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kĩ Paulo mɔ Barnaba na nɛ Antiokia a, bati badi to Yudea bɛyatsa batɛ badonɛ nɛ awã fɔtsa kĩ, “Miláana katɛ mbɔɛntɛ bitsua mi lɛkpati nɛ Mose mbla a onukpɛ̃.” ");
INSERT INTO bov_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Lɛmɛ Paulo mɔ Barnaba vɛlɛ foe mɔ be mɔ ɔsĩ mɔ ɔsĩ. Nɛ foesũ bɛnyɛ batɛ badonɛ a badi kĩ bito Antiokia kĩ bitomɔ be bɛnaa Yerusalem lɔkɔa bɛmɔ fɔtɔ banyanɛ mɔ banɔkɔɛ̃ a kĩ bideĩ nɛ Yerusalem a bɛwɛ fɔlɛtsa kĩĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Foesũ batɛ badonɛ a yi be osi. Bɛnatsã Foenike mɔ Samaria bɛsɛla batɛ badonɛ a kĩ bideĩ nɛ awã, ade bibi be ayekĩ bikĩ bɛnyɛ́ Yudafɔ a kɔa be akũ bɛkpa Baguma a. Fɔlɛtsa kĩĩ de be kawɔlɛ paa. ");
INSERT INTO bov_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kĩ biwo Yerusalem a, batɛ badonɛ a, fɔtɔ banyanɛ a mɔ banɔkɔɛ̃ a flee tɛ be mɔ kawɔlɛ. Paulo mɔ Barnaba bɔa be amandiɛ nɛ fɔtsa a kĩ Baguma kɛna ɛtsãmɛna be akũ a flee. ");
INSERT INTO bov_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lɛmɛ Farisifɔ batɛ badonɛ badi yidza bɛdza ade bɛlɛ kĩ, “Kɛnɛ kĩ batɛ badonɛ a kĩ bɛnyɛ́ Yudafɔ a bitsua fɔkpati lɔkɔa bɛkɛna nɛ Mose mbla a akũ.” ");
INSERT INTO bov_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nɛ fukĩĩ sũ banɔkɔɛ̃ a mɔ fɔtɔ banyanɛ a tsɛna bɛkɔna fɔlɛtsa a akũ. ");
INSERT INTO bov_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kĩ bɛsa foe kamɛ fɛɛ a, Petro yidza ɛdza ade ɛlɛ kĩ, “Nwaɛ̃ amɛ, miawɛ minyina kĩ lɔkɔ lidi Baguma pau yĩ etomɛna mi kamɛ kĩ nnaabi bikĩ bɛnyɛ́ Yudafɔ a Kalɛ Wĩ a, ayekĩ be malo baanu ke bɛtɛ bido lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ade Baguma kĩ enyina otidziwa kakɔna a nyɛ ye kawɛ ɛtsa nɛ kĩ ɛkpa be Hũhũ Kpalɛwa ndɛ ayekĩ ɛkpa boe malo a. ");
INSERT INTO bov_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɛtátsa ntsitsemu adima nɛ bɔmɔ́ be kayite, kitonɛkĩ ɛtɛ be nɛ ayekĩ bɛtɛ bido sũ, ade ɛkɔa be tɔkpa ete be ndɛ boe aye a. ");
INSERT INTO bov_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Finyaakĩĩ, nde sũ bɔasɔ Baguma bɔdã? Nde sũ bɔkɔa fɔlɔtsa a kĩ bɔmɔ́ boe bawanyɔ bɔtápuli bɔlɔ a bɔate nɛ batɛ badonɛ kĩĩ akũ? ");
INSERT INTO bov_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Oowo! Ndɛ ayekĩ bɔtɛ budo kĩ boe a flee bɔna katɛ fɔtsã boe Ɔlate Yesu kɔnyakamɔ kamɛ a, ade ayea be malo bɛna katɛ a.” ");
INSERT INTO bov_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ade ke be flee bɛkɛna dĩĩ, bitse Paulo mɔ Barnaba amandiɛ kabɔa nɛ ayekĩ Baguma tsã be akũ ɛkɛna awãwã fɔtsa ɛkpa bikĩ bɛnyɛ́ Yudafɔ a. ");
INSERT INTO bov_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kĩ bɛbɔa amandiɛ biyua a, Yakobo lɛmɛ yidza ɛdza ade ɛlɛ kĩ, “Nwaɛ̃ amɛ, mitse! ");
INSERT INTO bov_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petro bi boe ayekĩ Baguma nya lɔtɔ ɛnyɛ ye kawɛ ɛtsa bikĩ bɛnyɛ́ Yudafɔ a, ade ɛpau be badi kĩ bɛnya ye bade a. ");
INSERT INTO bov_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ade Baguma onukpɛ̃ banyɛnɛ fɔlɛtsa a kĩ bɛlɛ biyi a ketimɔ fukĩĩ pɛpɛɛpɛ ndɛ ayekĩ katsɛlɛ kpalɛwa fɔlɛtsa a lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nɛ fukĩĩ liti ni, maamuniki ĩya. Maayalɔla Dawid lɛgãkanyakɔ̃ a kadzɛla, ade maalɔla fɔtsa a kĩ fubu kade nɛ awã kake a, lɔkɔa awã libuki kɛdza pintii. ");
INSERT INTO bov_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ade bati nkaɛ a aaya nɛ yĩ sɛkɛ̃, mɔ bikĩ bɛnyɛ́ Yudafɔ a kĩ nvɛ kĩ bɛnya yĩ bade a aatomɔ yĩ liti. ");
INSERT INTO bov_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ade aye boe Ɔlate lɛ eyi anɛ kɔkɔɛ kĩ yaakɛna a.’ ");
INSERT INTO bov_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Foesũ nɛ yĩ, Yakobo, kakɔna onukpɛ̃ ni, kɛtánɛ kĩ bɔaha bikĩ bɛnyɛ́ Yudafɔ a kĩ bɛkɔa be akũ bakpa Baguma a. ");
INSERT INTO bov_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mbom mifɔ̃ bɔtsɛlɛ ovoli bɔma be kĩ bɛfɔ̃ fukĩĩ bamɛ ndɛ bayaɛ kĩ bɛkɔa bɛbɔa afɔliɛ bɛkpa baviɔ̃ kaba, bɛfɔ̃ litsolewɛ mɔ linyolewɛ, bɛfɔ̃ ɔyaɛ kĩ bɛtátsua ye sɔmɔ kaba mɔ babɔanɛ kanya. ");
INSERT INTO bov_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kitonɛkĩ kito anɛ kɔkɔɛ a bakã Mose mbla a kĩ ɛtsɛlɛ eyi a nɛ Kawɛya Luwi lidi nyɛ lidi akũ nɛ Yudafɔ katsɛnakɔ̃ ade bade lɛtsã nɛ ye fɔlɛtsa akũ nɛ ɔmatɔ nyɛ ɔmatɔ kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ade ke fɔtɔ banyanɛ, banɔkɔɛ̃ mɔ batɛ badonɛ a flee kɛna onukpɛ̃ mɔa kĩ bɛnyɛ be kamɛ badi bibumɔ Paulo mɔ Barnaba bɛnaa Antiokia a. Bɛpau bati nviã kĩ batɛ badonɛ a akpa be obu paa. Ade be nyɛ Yuda kĩ bibuki bavɛ Barnaba mɔ Sila a. ");
INSERT INTO bov_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ovoli a kĩ bɛnɛɛ banamɛna a kamɛ fɔlɛtsa nyɛ kĩ, Ovoli kĩĩ to boe fɔtɔ banyanɛ, banɔkɔɛ̃, mɔ batɛ badonɛ a kĩ bideĩ nɛ Yerusalem sɛkɛ̃. Bɔawɔ̃na mi, boe bawaɛ̃ kĩ minyɛ́ Yudafɔ a kĩ mito Antiokia, Siria mɔ Kilikia. ");
INSERT INTO bov_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bunu kĩ batɛ badonɛ badi to boe kamɛ nɛ awĩ bɛyabi mi fɔlɛtsa fudi kĩ fɔha mi fudo ɔtutũ lɛmɛ nɛ mi kamɛ. Lɛmɛ nnɛ́ boe lido be. ");
INSERT INTO bov_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Nɛ foesũ bɔtsa fɔlɔ buke otse kĩ bɔado batɔ nviã nɛ mi sɛkɛ̃. Baatomɔ boe bawaɛ̃ nviã Barnaba mɔ Paulo, kĩ bɛkɔa be nkpã bɛkpa boe Ɔlate Yesu Kristo ɔsum a. ");
INSERT INTO bov_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Budo Yuda mɔ Sila kĩ be mɔa awɛ bibi mi fɔlɛtsa a kĩ foe bɔtsɛlɛ a. ");
INSERT INTO bov_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kitonɛkĩ Hũhũ Kpalɛwa a mɔ boe mɔawɛ a bɔmɔ́ buyi ɔsũ kĩ kɛtánɛ kĩ bɔakɔa fɔlɔtsa kpale bɔlɔla mi kɛba tɛbla sĩwa kĩĩ. ");
INSERT INTO bov_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ade te nyɛ kĩ mitanya funitsã kĩ bɛkɔa bɛbɔa afɔliɛ bɛkpa baviɔ̃, mitanya babɔanɛ, mitaba ɔyaɛ kĩ bɛtátsua ye sɔmɔ, mipi mi akũ nɛ linyolewɛ mɔ litsolewɛ kamɛ. Ntɛ mipi mi akũ limii ni, katinya kamɛ aalɛ kɛkpa mi. Midzi nɛ lukudɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Foesũ bɛnyɛ batɔ kĩĩ osi bɛnaa Antiokia. Bɛnakpɔta batɛ badonɛ a flee nɛ be katsɛnakɔ̃ a, ade bɛkɔa ovoli a bɛkpa be a. ");
INSERT INTO bov_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kawɔlɛ de bati a nɛ fɔlɛtsa a kĩ bɛkã nɛ ovoli a kamɛ a sũ. ");
INSERT INTO bov_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda mɔ Sila kĩ bɛnyɛ Baguma onukpɛ̃ banyɛnɛ nyɛ fɔlɛtsa pii kayɔ bɛtsa be nɛ lɔkɔ gɛlɛɛlɛ kamɛ, bido be kɔbɛ̃ lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bidzi nɛ be sɛkɛ̃ bɛtɛ fuwi fudi, ade batɛ badonɛ a nyɛ be osi nɛ lukudɔ kamɛ kĩ bimuniki bɛnaa Yerusalem a. ");
INSERT INTO bov_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lɛmɛ Sila kɔ̃ wɛ kĩ yakahɔ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo mɔ Barnaba dzi nɛ Antiokia sukuloo. Bɛmɔ bati bɛbã pii bɛtsa fɔtsa ade bɛkade lɛtsã nɛ boe Ɔlate kalɛ a akũ a. ");
INSERT INTO bov_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nɛ fuwi fudi liti ni, Paulo bi Barnaba kĩ, “Fɔ̃ bumuniki bɔnaasɛla boe bawaɛ̃ nɛ tɛmatɔ a kĩ bɔtsã te kamɛ bude lɛtsã nɛ boe Ɔlate kalɛ a akũ a, lɔkɔa bɔdã ni nde bidzi.” ");
INSERT INTO bov_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba tunɔ ade ɛwɛ kĩ bakpã Yohanes Marko bibumɔ be akũ a. ");
INSERT INTO bov_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lɛmɛ Paulo tátunɔ kɔlaa kitonɛkĩ, kĩ bɛnaa Pamfilia a, Yohanes Marko dzakũ ɛfɔnɛ be nɛ awã ade ɛtábumɔ be biyua adzuma a. ");
INSERT INTO bov_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bati nviã kĩĩ vɛlɛ fɔlɛtsa a mɔ ɔsĩ mɔ ɔsĩ ade fɔfɔ̃ bɛyalɛ a. Barnaba kpã Marko ade binyina mpo bɛnaa Kipro a. ");
INSERT INTO bov_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo lɛmɛ kpã Sila ade batɛ badonɛ a kɔa be bido nɛ boe Ɔlate awɛ kĩ ɛmɔ be kɔnya fɔmɔ bɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɛtsã Siria mɔ Kilikia tite kamɛ ɛkado tɛsɔli nɛ awã a kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ade Paulo dzakũ ɛnaa ɔmatɔ odi kĩ bavɛ Derbe, ade ɛtɛ̃ ɛnaa Listra lɛmɛ a. Ade awã ɛnamɔ ɔtɛ odonɛ odi kĩ bavɛ Timoteo a. Ɔma nyɛ Yudani kĩ ɛtɛ Kristo edo. Lɛmɛ ɔlɛga kɔ̃ nyɛ Grikini. ");
INSERT INTO bov_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Batɛ badonɛ flee a kĩ bideĩ nɛ Listra mɔ Ikonio bɔa Timoteo dĩ wĩ. ");
INSERT INTO bov_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ade ye Paulo wɛ kĩ yakpã ɛnamɛna a, foesũ etsua ye lɛkpati, kitonɛkĩ Yudafɔ a kĩ bideĩ nɛ kayite a na nyina kĩ ɔlɛga nyɛ Grikini. ");
INSERT INTO bov_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ade kĩ bɛdzakũ a, bɛtsã bimini nɛ tɛmatɔ a kamɛ, bibi be tɛbla a kĩ fɔtɔ banyanɛ mɔ banɔkɔɛ̃ nɛ Yerusalem ke otse nɛ te akũ a. Bɛdɛ be kĩ bɛkɛna nɛ te akũ. ");
INSERT INTO bov_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Foesũ luwi daa bati a kapɔ ade be katɛkado lɛmɛ na ɔsĩ kibu a. ");
INSERT INTO bov_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ke liti a, bɛtsã Frigia mɔ Galatia tite a kamɛ, kitonɛkĩ Hũhũ Kpalɛwa a tákpa be osi kĩ bɛnaade lɛtsã kalɛ wĩ a akũ nɛ Asia tite akũ. ");
INSERT INTO bov_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kĩ biwo Misia tite ɔbaɛ̃ a, bɛwɛ kĩ bawo nɛ Bitinia tite kamɛ, lɛmɛ Yesu Hũhũ a tákpa be osi. ");
INSERT INTO bov_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Foesũ bimuniki bɛtsã Misia bɛnawo Troa ɔmatɔ a kĩ ɛwaa nɛ mpo abuĩ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ke lɛnyɛ a, Paulo na kanyɛkatsa nɛ kɔda kamɛ. Nɛ kɔda a kamɛ a, ɛmɔ onyole odi kĩ eto Makedonia, ɛdza ɛlamɛna ye aduli kake kĩ, “Nyina mpo kaya nɛ Makedonia kayaabumɔ boe!” ");
INSERT INTO bov_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kĩ Paulo na kanyɛkatsa kĩĩ sũ ni, bɔmanɛ akũ bupi Makedonia osi, kitonɛkĩ fɔatsa kĩ Baguma lɛvɛ boe kĩ bɔnaade lɛtsã nɛ Kalɛ Wĩ a akũ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ade ke budzi nɛ ɔkɔlɔ kamɛ nɛ Troa bunyina kpĩĩ bɔnaa Samotrake a. Kĩ kade nyina a, buwo Neapoli. ");
INSERT INTO bov_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kĩ buto awã a, bɔnawo Filipi kĩ ɛnyɛ Makedonia ɔmatɔ kpale flee a kamɛ. Awã lɛmɛ nyɛ tite kĩ Romafɔ adãmɛna te akũ. Budzi nɛ awã fuwi fudi. ");
INSERT INTO bov_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nɛ Kawɛya Luwi akũ a, bɔnɛ nɛ ɔmatɔ a kamɛ bɔnaa ɔwɔ abuĩ, awã kĩ bɔkɔna kĩ Yudafɔ atsɛna kabɔa mpaɛ. Ade budzi nɛ awã bɔkatsa batsole a kĩ bɛkpɔta nɛ awã Baguma kalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bavɛ be kamɛ ɔmɔa kĩ eto Tiatira kĩ Lidia. Yanɔ tilima ngbã, ade ɛnyɛ oti kĩ yasum Baguma yededeede a. Ade lɔkɔ a kĩ ɛna nɛ awã ɛkatse boe a, Baguma binya ye ɔwɔlɛ kĩ ɛtɛ fɔlɛtsa a kĩ Paulo kalɛ a edo. ");
INSERT INTO bov_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ade kĩ ye mɔ ye tɔtɔ kamɛ bati flee bɛtɛ mui kawɔla amaniɛ a, eke boe aduli kĩ, “Ntɛ mitunɔ kĩ ntɛ boe Ɔlate ndo paa kɔ̃ ni, miyaadzi nɛ yĩ tɔtɔ kamɛ” Ɛdza nɛ boe akũ flee kɛnawo kĩ butunɔ bɔnaa ye sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Luwi mɔa lidi kĩ bɔanaa mpaɛ kabɔakɔ̃ a, bɔtsɛlamɔ oyitsɔ̃ abawa adi kĩ hũhũ kpa deĩ nɛ ye kamɛ, fɔafɔ̃ yapuli kadã kanɔkɔnɛ. Nɛ foesũ yakɛna sika baũ kakpa ye balate. ");
INSERT INTO bov_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Oyitsɔ̃ kĩĩ tomɔ boe mɔ Paulo mɔ fɔwɔla kabɔa kĩ, “Baguma Kpale basumunɛ bati kĩĩ anɛ, ade bɛya nɛ awĩ kĩ bayaatsa mi nkpã kana osi a!” ");
INSERT INTO bov_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Fukĩĩ na nkɔsu fuwi pii. Ade kĩ fuwo Paulo odo a, ɛdani ebi hũhũ a kĩ etomɔ oyitsɔ̃ a kĩ, “Nɛ Yesu Kristo dĩ akũ, mabi nɔ kĩ nɛ́ nɛ oti a kamɛ!” Lɛtalɛta hũhũ kpa a nɛ́ nɛ ye kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kĩ ye balate a mɔ́ kĩ osi a kĩ ye akũ batsã kana sika yɛla be a, bipi Paulo mɔ Sila bɛma fɔlɛtsa badzɛnɛ banɔkɔɛ̃ a nɛ kɔya. ");
INSERT INTO bov_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bɛlɛ nɛ kɔya kĩ, “Bati kĩĩ nyɛ Yudafɔ kĩ bɛyaabula boe ɔmatɔ a kade. ");
INSERT INTO bov_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Batsa bati fɔtsa kĩ boe ndɛ Romafɔ bɔláapuli bɔtɛ foe.” ");
INSERT INTO bov_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ade bati kɔdabu a yidza bɛdza bisinya Paulo mɔ Sila, bido be katsootsoo awɛ a. Fɔlɛtsa badzɛnɛ a fɔ̃ bɛyɛlɛ tɛtadiɛ nɛ be akũ, ade bɛkpa kɔbɛ̃ kĩ bibo be mɔ kutse a. ");
INSERT INTO bov_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kĩ bibo be kabo kpa biyua a, bɛnado be nɛ kɔla, ade bibi ekĩ yadãmɛna bikĩ bɛwaa kɔla akũ a kĩ ɛbalɛ Paulo mɔ Sila kabalɛ wĩ. ");
INSERT INTO bov_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kĩ bibi ye lɔmɔ sũ ni, ɛnado be nɛ kamɛ flee a, ade ɛbɔa be agba a. ");
INSERT INTO bov_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lɛnyɛ kayite a, kĩ Paulo mɔ Sila kabɔa mpaɛ mɔ tɔnɔ kasã kakpa Baguma a, kɔlabawanɛ nkaɛ a katse be. ");
INSERT INTO bov_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ade deedimɔapɛ tite kuna mɔ ɔsĩ mɔ ɔsĩ ade kɔla a flee kuna kɔnake a. Lɛtalɛta kɔla tupunu a flee binya ade nkɔsɔnkɔsɔ a wɔlɔ nɛ kɔlabawanɛ a flee akũ tɛtɔ a. ");
INSERT INTO bov_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kĩ kɔlabawanɛ akũ ɔdãmɛnanɛ a nyinya a, ɛmɔ kĩ kɔla a tunyukpɛ̃ flee waa luto. Ɛkɔna kĩ kɔlabawanɛ a nɛ bilo sũ ni, ɛbɔlɛ lɛpamɛ ɛnyɛ kĩ yatsɔɛ ye akũ ekɔ. ");
INSERT INTO bov_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lɛmɛ Paulo bɔa fɔwɔla kɔɔba kĩ, “Takɛna nɔ akũ lɛtsama. Boe a flee budeĩ nɛ awĩ!” ");
INSERT INTO bov_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kɔla bawanɛ akũ ɔdãmɛnanɛ a fɔ̃ bɛma ye ɔsɛdza ade nɛ kukũtila kamɛ ewula atsɛ ɛnatɔ nɛ Paulo mɔ Sila abɔa kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ade ke ɛnyɛ be nɛ kɔla a kamɛ, evia be kĩ, “Nda amɛ, litsa kɛnɛ kĩ nkɛna nna katɛ?” ");
INSERT INTO bov_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bibi ye kĩ, “Tɛ boe Ɔlate Yesu kado lɔkɔa mimɔ nɔ tɔtɔ kamɛ bati flee míana katɛ.” ");
INSERT INTO bov_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ade ke bɛnaa bɛnade lɛtsã nɛ boe Ɔlate kalɛ akũ bɛkpa ye tɔtɔ kamɛ bati a flee a. ");
INSERT INTO bov_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lɛnyɛ a na, ɛkpã be ɛnasu be fɔkpa, ade ye mɔ ye tɔtɔ kamɛ bati bɛtɛ mui kawɔla amaniɛ a. ");
INSERT INTO bov_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ɛkpã Paulo mɔ Sila ɛnamɛna ye awã, ade ɛkpa be funitsã bɛnya a. Ye mɔ ye tɔtɔ kamɛ bati a flee bɛmɔ́ kawɔlɛ paa kitonɛkĩ bɛtɛ Baguma bido. ");
INSERT INTO bov_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kĩ kade nyina a, ɔmatɔ a kamɛ fɔlɛtsa badzɛnɛ do fɔtɔ banyanɛ bɛnabi kɔlabawanɛ akũ ɔdãmɛnanɛ a kĩ, “Fɔnɛ bati a awɛ bɛnaa.” ");
INSERT INTO bov_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kɔla bawanɛ akũ ɔdãmɛnanɛ a bi Paulo mɔ Sila kĩ, “Fɔlɛtsa badzɛnɛ a bo nfɔnɛ mi awɛ midzakũ. Foesũ minaa faa nɛ lukudɔ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lɛmɛ Paulo bi batɔ a kĩ, “Bibo boe nɛ kanade nɛ lɔkɔ kĩ bɛtádzɛmɔ boe bɛkɔ boe kɔtɔ, ade bido boe nɛ kɔla kamɛ a, titɔ kĩ Romafɔ bɔanɛ. Ade finyaa kɔ̃ bawɛ kĩ bɔdzakũ nɛ kabɛla kamɛ? Oowo! Ke kɔ̃ nviã nɛ awĩ! Fɔ̃ be mɔawɛ a bɛyaanyɛ boe!” ");
INSERT INTO bov_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ade ke fɔtɔ banyanɛ a muniki bɛnabi fɔlɛtsa badzɛnɛ a ɔlɛdo a. Kĩ binu kĩ Paulo mɔ Sila nyɛ Romafɔ a, libe wo be paa. ");
INSERT INTO bov_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Foesũ bɛnaa be sɛkɛ̃ bɛnakpa be sɛmɛ bɔɛɛ, ade bɛnyɛ be nɛ kɔla a kamɛ a. Bike be aduli kĩ bɛdzakũ nɛ ɔmatɔ a kamɛ bɛnaa kakɔ bɛbã. ");
INSERT INTO bov_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo mɔ Sila dzakũ bɛnaa Lidia awã. Ade awã bɛnamɔ batɛ badonɛ bɛbã a. Bido be kɔbɛ̃ bibu ade bɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo mɔ Sila tsã bito Amfipoli mɔ Apolonia bɛyawo Tesalonika, awã kĩ Yudafɔ katsɛnakɔ̃ kadi na. ");
INSERT INTO bov_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ndɛ ayekĩ Paulo awɛ kakɛna a, ɛnaa Yudafɔ katsɛnakɔ̃ a Kawɛya Fuwi ɛlalɛ etomɔ akũ, ɛnyɛ fɔlɛtsa kayɔ ɛtsa bati a. ");
INSERT INTO bov_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ɛnyɛ lubo a kĩ bɛlɛ biyi kĩ Kristo aayamɔ, mɔ ayekĩ yaabuki eyidza edzi nkpã ɛtsa. Ebi be kĩ, “Oti a kĩ ye akũ fɔlɛtsa nlamɔ mi kabi a nyɛ Yesu Kristo a.” ");
INSERT INTO bov_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Fɔlɛtsa a kĩ foe kayɔ ɛnyɛ ɛtsa nɛ awĩ fɔ̃ bati a badi dani be adzuni, ade bɛtɛ bido bitomɔ Paulo mɔ Sila a. Ade aye a nɛ ɔmatɔ a kamɛ, Grikifɔ pii kĩ bipi be akũ nɛ Baguma kavila kamɛ, mɔ batsole pii kĩ obu deĩ nɛ be akũ lɛmɛ dani tɔwɔlɛ kamɛ bitomɔ Baguma. ");
INSERT INTO bov_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lɛmɛ anɛ bɛɛlɛ Yudafɔ banɔkɔɛ̃ a, ade ke bɛnawɛ patapaafɔ nɛ ɔmatɔ a kamɛ bibumɔ be akũ bido ɔtutũ nɛ ɔmatɔ a kamɛ a. Bɛbɔa obũ bɛkɛna dede bɛnawo nɛ Yason tɔtɔ kamɛ kĩ bapi Paulo mɔ Sila bɛnamɛna ɔmatɔ a katsɛnakɔ̃. ");
INSERT INTO bov_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kĩ bɛtamɔ be sũ ni, bɛvɛlɛ Yason mɔ batɛ badonɛ badi bɛnamɛna katsɛnakɔ̃ a. Awã na bɛkabɔa fɔwɔla kĩ, “Bati badi tsɛ̃mɔ ɔtutũ kado nɛ kakɔ nyɛ kakɔ, ade bɛkɔa foe bɛyamɛna nɛ awĩ kĩĩ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ade Yason lɛmɛ tɛ be edo nɛ ye tɔtɔ kamɛ a. Bati kĩĩ yidza bɛdza nɛ Lɛgãnɔkɔɛ̃ Kaisare tɛbla akũ. Ade batsa kĩ onyole odi kĩ bavɛ Yesu nyɛ Lɛgã a.” ");
INSERT INTO bov_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kĩ kɔdabu a mɔ ɔmatɔ a kamɛ banɔkɔɛ̃ nu fɔlɛtsa kĩĩ a fɔha be paa. ");
INSERT INTO bov_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Banɔkɔɛ̃ a fɔ̃ Yason mɔ ye bade a se be akũ liti kadza kɔtɔ ade bɛfɔnɛ be awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kĩ kade sila kɛdɔ pɛ, batɛ badonɛ a kpã Paulo mɔ Sila bilo bɛnaa Beroia. Kĩ biwo awã a, bɛnaa Yudafɔ katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beroia bati a tsua linebi bɛba bikĩ nɛ Tesalonika a. Biyi atɔ bitse kalɛ a. Luwi nyɛ luwi bɛkasa Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa kadã ntɛ lɛtsa a kĩ Paulo kabi be a nyɛ ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Foesũ be kamɛ bati pii tɛ bido. Grikifɔ batsole pii kĩ obu deĩ nɛ be akũ mɔ banyole pii lɛmɛ tɛ bido. ");
INSERT INTO bov_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lɛmɛ kĩ Yudafɔ a kĩ bideĩ nɛ Tesalonika nu kĩ Paulo ya ɛlamɛna Baguma kalɛ a katsa nɛ Beroia, bɛnaa awã bɛnado ɔtutũ nɛ bati a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Batɛ badonɛ a kĩ bideĩ nɛ awã a kpã Paulo mɔatsɛ mɔatsɛ bɛnamɛna mpo abuĩ. Lɛmɛ Sila mɔ Timoteo kɔ̃ kahɔ nɛ Beroia. ");
INSERT INTO bov_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bikĩ biyi Paulo osi a naa flee bɛnawo Atene. Ade awã bimuniki a, ade Paulo kpa ɔlɛdo kĩ bibi Sila mɔ Timoteo kĩ bɛya nɛ ye sɛkɛ̃ mɔatsɛ. ");
INSERT INTO bov_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kĩ Paulo na nɛ Atene ɛkadzɔlɛ Sila mɔ Timoteo a, ɛtɛ kalɔɛ nɛ ayekĩ ɛmɔ kĩ ɔmatɔ a kamɛ flee yi mɔ baviɔ̃ kasum. ");
INSERT INTO bov_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Foesũ ɛnanyɛ fɔlɛtsa kamɛ ɛtsa Yudafɔ a mɔ bikĩ bɛnyɛ́ Yudafɔ a kĩ basum Baguma a, mɔ bikĩ batɛ̃ nɛ kɔya luwi daa a. ");
INSERT INTO bov_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bati kutsu kudi kĩ bɛnyɛ Epikurofɔ mɔ Stoafɔ kĩ bideĩ katinya kamɛ kadikanyi kavɛlɛ fɔlɛtsa mɔ Paulo. Badi via kĩ, “Litsa fɔlɛtsa koũ oti kĩĩ wɛ kĩ yalɛ?” Bati bɛbã lɛmɛ kpa mbuayɛ kĩ, “Fɔadã ndɛ kade bɛbã baviɔ̃ akũ fɔlɛtsa ɛlamɛna kalɛ.” Bɛlɛ foe lɔmɔ kitonɛkĩ binu kĩ Paulo de lɛtsã nɛ Yesu mɔ bati kayidza kato kanɔkpa akũ. ");
INSERT INTO bov_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nɛ foesũ bɛkpã ye bɛnɛmɛna be ɔmatɔ a banɔkɔɛ̃ katsɛnakɔ̃ nɛ Areopago, ade bibi ye kĩ, “Bɔawɛ kĩ bɔanu fɔlɛtsa vɔɛ̃ a kĩ ɔlamɛna katsa a kayɔ. ");
INSERT INTO bov_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nɛ kĩ fɔlɛtsa a kĩ ɔlamɛna kalɛ a kamɛ tákpalɛ boe sũ ni, bɔawɛ butse foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenefɔ mɔ banɔvɔɛ̃ a kĩ bideĩ nɛ awã awɛ be lɔkɔ flee kakpa fɔlɛtsa vɔɛ̃ katse mɔ foe akũ kɔlɔmɛna. ");
INSERT INTO bov_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ade Paulo yidza ɛdza nɛ bati a anɛ kamɛ ɛlɛ kĩ, “Atenefɔ! Mmɔ́ kĩ nɛ lɛtsa nyɛ lɛtsa kamɛ ni, miapi mi ɔsum kadunamɔ akũ paa. ");
INSERT INTO bov_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kitonɛkĩ kĩ ntsɛ̃ nɛ ɔmatɔ kamɛ ndã mi fɔtsa kumɛkumɛ a kĩ miasum a ni, mmɔ́ kĩ bɛtsɛlɛ nɛ afɔliɛ kabɔa de lidi akũ kĩ, ‘Bɔkɔa bɔakpa Baguma a kĩ bunyína a.’ Baguma a kĩ minyina, lɛmɛ miabɔa afɔliɛ kakpa ye a, ade ye akũ fɔlɛtsa nlamɛna mi kabi finyaakĩĩ a. ");
INSERT INTO bov_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Baguma kĩĩ nyɛ lɛtsa nyɛ lɛtsa Ɔlate, kĩ ɛbɔa tite mɔ ode mɔ fɔtsa flee a kĩ fudeĩ nɛ foe kamɛ. Yaádzi nɛ kɔla a kĩ batidziwa ke mɔ awɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɛtási boe lɛtsama kĩ bɔkɔa awɛ bɔkɛna a, kitonɛkĩ ye mɔawɛ akpa oti nkpã mɔ kawɛya, mɔ lɛtsa nyɛ lɛtsa kĩ lisĩ oti. ");
INSERT INTO bov_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ɛnyɛ fude fude bati a a flee etomɛna otidziwa mɔapɛ kamɛ kĩ bidzi nɛ tite akũ. Ye mɔawɛ liyi lɔkɔ mɔ fudzikɔ̃ tɛbɛ̃ ɛkpa bati flee. ");
INSERT INTO bov_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Baguma kɛna fukĩĩ ayekĩ boe batidziwa baawɛ ye liti osi bɔmɔ́ ye, titɔ kĩ ɛláa mɔ lugo nɛ boe sɛkɛ̃ malo. ");
INSERT INTO bov_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kitonɛkĩ ndɛ ayekĩ mi tɔnɔ bamɛnɛ badi alɛ kĩ, ‘Ade ye dzi fɔ̃ budzi, bɔtsɛ̃ budeĩ nkpã a.’ Ade bɛlɛ lɛmɛ kĩ, ‘Boe malo bɔnyɛ ye kasinu a kamɛ babi.’ ");
INSERT INTO bov_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nɛ kĩ bɔnyɛ Baguma babi sũ ni, kɛtáfɛta kĩ bɔakɔna kĩ Baguma kutitse la ndɛ litsedi kĩ batidziwa kɔa awɛ bɛmɛ mɔ sika ngbã, suwovoe ĩye futse. ");
INSERT INTO bov_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kito anɛ katinya kayɔkayi kɛyawo nviã kĩĩ a, Baguma távɛlɛ bati sɔtɔ kitonɛkĩ bɛtányi ye sũ. Lɛmɛ finyaakɔ̃ ɛkpa ɔlɛdo kĩ bati flee nɛ kakɔ nyɛ kakɔ bɛdani be tɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kitonɛkĩ ehihiɛ luwi eyi kĩ de akũ oti a kĩ ɛpau a, aadzɛmɔ katinya kamɛ flee nɛ ɔnɔkɔali kamɛ. Kĩ yaakɛna fukĩĩ sũ ni, ɛdzɛla Oti a Kĩ Baguma bɔa Tɔdɔ̃ a etomɛna kanɔkpa ade ke ɛnyɛ ye ɛtsa bati flee a!” ");
INSERT INTO bov_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kĩ binu kĩ Paulo lɛ kɔdzɛla nɛ kayidza kato kanɔkpa akũ a, bati a badi di ye nsekuo, ade babɛbã lɛmɛ lɛ kĩ, “Bɔawɛ kĩ bɔabuki butse fɔlɛtsa fudi nɛ oti kabu kayidza a akũ.” ");
INSERT INTO bov_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kĩ fɔya lɔmɔ a, Paulo dzakũ ɛfɔnɛ be. ");
INSERT INTO bov_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lɛmɛ bati a badi tomɔ ye bɛdani bɛkɛna batɛ badonɛ. Be kamɛ badi nyɛ Dionisio, kĩ ɛnyɛ Areopago ɔnɔkɔɛ̃, mɔ otsole odi kĩ bavɛ Damari, mɔ bati bɛbã. ");
INSERT INTO bov_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Fukĩĩ liti a, Paulo dzakũ nɛ Atene ɛnaa Korinto. ");
INSERT INTO bov_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nɛ awã a ɛmɔ Yudani odi kĩ bavɛ Akwila kĩ eto Ponto. Bɛmɔ ɔtsɔ̃ Priskila bito Italia bɛya nɛ awã owi tábuna, kitonɛkĩ lɛgã a kĩ bavɛ Klaudio si mbla kĩ Yudafɔ flee bɛnɛ nɛ Roma. Paulo naa ɛnamɔ be, ");
INSERT INTO bov_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ade ɛna nɛ be sɛkɛ̃ ɛkabumɔ be adzuma, nɛ kĩ bɛmɔ be bakɛna adzuma mɔa sũ. Bɛkɔa bayaɛ tuvoli bɛkapam tilima fɔla fɔtsa ndɛ ayekĩ Paulo lɛmɛ akɛna a. ");
INSERT INTO bov_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nɛ Kawɛya Luwi lidi nyɛ lidi akũ ni, Paulo kanaa Yudafɔ katsɛnakɔ̃, kanaanyɛ fɔlɛtsa kamɛ katsa Yudafɔ mɔ Grikifɔ, kĩ bɛdani tɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kĩ Sila mɔ Timoteo to Makedonia bɛya a, Paulo na aya koũ ede lɛtsã nɛ kalɛ wĩ a akũ, ade edi adansiɛ ɛtsa Yudafɔ a kĩ Yesu nyɛ Kristo a. ");
INSERT INTO bov_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Lɛmɛ kĩ Yudafɔ a yidza bɛdza nɛ ye akũ bɛlɛ fuvũnatsa nɛ ye akũ sũ ni, ɛkpa ye akũ eko be ɛlɛ kĩ, “Ntɛ miyɛla ni, mi mɔawɛ aatɛ foe sɔtɔ kavɛlɛ. Yĩ akũ kpalɛ, ntáku kɔtɔ. Kito finyaakĩĩ kanaa ni, maanaa bikĩ bɛnyɛ́ Yudafɔ a sɛkɛ̃ nnaabi be kalɛ wĩ kĩĩ.” ");
INSERT INTO bov_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kĩ ɛdzakũ nɛ be sɛkɛ̃ a, ɛnadzi nɛ onyole odi kĩ ɛnyɛ Yudani kĩ bavɛ Tito Yusto tɔtɔ kamɛ. Ɛnyɛ oti kĩ yasum Baguma ade ye awã lɛmɛ fuãmɔ Yudafɔ katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Katsɛnakɔ̃ ɔnɔkɔɛ̃ a kĩ bavɛ Krispo mɔ ye akũ bati flee tɛ boe Ɔlate bido ade bɛtɛ mui kawɔla amaniɛ a. Ade ayea bɛkɛna Korintofɔ pii a kĩ bɛtɛ bido a mui kawɔla amaniɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Luwi a lɛnyɛ ni, Paulo na kanyɛkatsa, ade boe Ɔlate bi ye kĩ, “Tavila. Tafɔ̃ kalɛ wĩ a kalɛ. ");
INSERT INTO bov_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ntomɔ nɔ, odima lɛláapuli ɛkɛna nɔ lɛtsakpa lidima, kitonɛkĩ bati pii kĩ bɛnyɛ yĩ bade lɛmɛ deĩ nɛ ɔmatɔ kĩĩ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Foesũ Paulo dzi nɛ awã kateli mɔa mɔ sɛkɛ ɛkatsa bati Baguma kalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lɛmɛ lɔkɔ a kĩ bɛyadzina Galio ndɛ Roma abãã ɔnɔkɔɛ̃ nɛ Akaia tite akũ a, Yudafɔ badi tsa fɔlɔ biyidza bɛdza nɛ Paulo akũ, bipi ye bɛnamɛna fɔlɛtsa kadzɛkɔ̃. ");
INSERT INTO bov_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ade ke bibi ɔnɔkɔɛ̃ a kĩ, “Obi kĩĩ lamɛna bati adzuni kadani kĩ bisum Baguma nɛ osi kĩ etia boe mbla akũ.” ");
INSERT INTO bov_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Lɛmɛ kĩ Paulo wɛ kĩ yanyɛ ye akũ onukpɛ̃ pɛ, Galio bi Yudafɔ a kĩ, “Yudafɔ mitse! Ntɛ mi kalɛ kĩ miyamɛna kĩĩ mɔ mfumsu baũ adi yanɛ kɔ̃ ni, kufɛ maana ɔwɔlɛ ntse mi. ");
INSERT INTO bov_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lɛmɛ kĩ fɔnyɛ fɔlɛtsa kamɛ kanyɛ nɛ buĩ mɔ mi tɛmaniɛ akũ sũ ni, mi mɔawɛ minaasa foe kamɛ mimanɛ foe. Fɔnyɛ́ fɔlɛtsa kĩ madzi ndzɛ.” ");
INSERT INTO bov_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Foesũ ɛblɔmɛna be ɛnɛmɛna nɛ ye fɔlɛtsakadzɛkɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ade bati kɔdabu a napi Sostene kĩ ɛnyɛ Yudafɔ katsɛnakɔ̃ ɔnɔkɔɛ̃ a bibo nɛ fɔlɛtsa kadzɛkɔ̃ kɔla kamɛ a. Lɛmɛ Galio tákpeti be kɔlaa. ");
INSERT INTO bov_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo dzi nɛ Korinto fuwi beblebee. Ke liti a, ɛkla batɛ badonɛ a ade bɛmɔ Akwila mɔ Priskila binyina mpo bɛnaa Siria a. Fɔmɔ Paulo aadzakũ nɛ Kenkrea a, ɛfɔ̃ bɛkpa ye lɔlɔ tsɔlitsɔli nɛ fubo a kĩ ɛlɔ nɛ Yudafɔ amaniɛ osi sũ. ");
INSERT INTO bov_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kĩ biwo Efeso a, ɛdzakũ ɛfɔnɛ Priskila mɔ Akwila nɛ awã. Ɛdzakũ ɛnaa Yudafɔ katsɛnakɔ̃ a ɛnanyɛ fɔlɛtsa kamɛ mɔ Yudafɔ a kĩ bɛna nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bati a ke ye aduli kĩ edzi nɛ be sɛkɛ̃ sukuloo a, lɛmɛ ɛtátunɔ. ");
INSERT INTO bov_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nɛ foesũ kĩ yadzakũ a, ebi be kĩ, “Ntɛ fɔnyɛ Baguma kawɛ ni, owi lɛláabuna mɔ maabuki ĩya nɛ mi sɛkɛ̃.” Ade ke ewo nɛ ɔkɔlɔ kamɛ ɛdzakũ nɛ Efeso a. ");
INSERT INTO bov_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kĩ ewo Kaisarea a, ɛnaa Yerusalem ɛnawɔ̃na batɛ badonɛ a, ade ebuki ɛtɛ̃ ɛnaa Antiokia a. ");
INSERT INTO bov_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Edzi nɛ awã sukuloo ɛtsã emini nɛ Galatia mɔ Frigia tite a kamɛ, ɛkado batɛ badonɛ a kɛbɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nɛ lɔkɔa na kamɛ ni, Yudani odi ya nɛ Efeso. Bavɛ ye Apolo ade bɛma ye nɛ Aleksandria a. Ɛnyɛ oti kĩ enyina kɔdzɛla kalɛ ade enyina Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Titɔ kĩ bɛtsa ye fɔtsa nɛ boe Ɔlate kalɛ wĩ a akũ, yalɛ kɔdzɛla mɔ kɔbɛ̃ nɛ Yesu akũ malo ni, Yohanes mui kawɔla amaniɛ akũ fɔlɛtsa odi enyina. ");
INSERT INTO bov_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɛkalɛ kalɛ mɔ kɔbɛ̃ nɛ katsɛnakɔ̃ a. Kĩ Priskila mɔ Akwila tse ye fɔlɛtsa a, bɛkpã ye bɛnamɛna be awã ade bɛnanyɛ Baguma osi a bɛtsa ye yededeede a. ");
INSERT INTO bov_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kĩ Apolo yake otse kĩ yaanaa Akaia, batɛ badonɛ nɛ Efeso a yado ye kɔbɛ̃. Bɛtsɛlɛ ovoli bɛkpa bikĩ nɛ Akaia kĩ bɛtɛ ye atuu. Kĩ ewo awã a ebumɔ bati pii a kĩ bɛdani tɔwɔlɛ kamɛ nɛ Baguma kɔnyakamɔ sũ. ");
INSERT INTO bov_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ade ke ɛnya Yudafɔ a akũ nɛ fɔlɛtsa kavɛlɛ kamɛ a, kitonɛkĩ ɛnyɛ Katsɛlɛ Kpalɛwa a kamɛ fɔlɛtsa ɛtsa yededeede kĩ Yesu nyɛ Oti a kĩ Bɛbɔa tɔdɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kĩ Apolo na nɛ Korinto a, Paulo tsã abɔa, ɛtsã fuyite fuyite a ɛnanɛ nɛ Efeso. Awã naa, ɛmɔ batɛ badonɛ badi. ");
INSERT INTO bov_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ade evia be kĩ, “Kĩ mitɛ mido a ni, mitɛ Hũhũ Kpalɛwa a?” Ade ke bɛkpa mbuayɛ kĩ “Oowo! Litsa nyɛ Hũhũ Kpalɛwa a? Bɔtánu tɔ̃ foe akũ lɛtsama.” ");
INSERT INTO bov_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ebuki evia be kĩ, “Litsa mui kawɔla amaniɛ mitɛ?” Ade bibi ye kĩ, “Yohanes mui kawɔla amaniɛ a kĩ ke akũ ede lɛtsã a.” ");
INSERT INTO bov_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo nyɛ foe kayɔ ɛtsa be kĩ, “Yohanes kɛna bati mui kawɔla amaniɛ kĩ bɛdani tɔwɔlɛ kamɛ. Ade ebi be kĩ bɛtɛ oti a kĩ yaaya nɛ ye Yohanes liti a bido. Ade oti a nyɛ Yesu a.” ");
INSERT INTO bov_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kĩ binu fɔlɛtsa kĩĩ a, bɛfɔ̃ Paulo kɛna be mui kawɔla amaniɛ nɛ boe Ɔlate Yesu dĩ akũ. ");
INSERT INTO bov_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ade kĩ Paulo te awɛ nɛ be akũ a, Hũhũ Kpalɛwa a ka ɛyatɛ be flee kamɛ ade bɛlɛ kɔdzɛla nɛ tide ahɔlɔ ahɔlɔ kamɛ a, bɛlɛ Baguma kalɛ a lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Be lidede aawo ndɛ banyole ewua-nviã. ");
INSERT INTO bov_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo kanaa katsɛnakɔ̃ a nɛ tidetɔ ɛlalɛ kamɛ, ɛkabi bati kalɛ wĩ a mɔ ɔwɔlɛ kado. Ɛnyɛ fɔlɛtsa kamɛ ɛtsa be, ɛbɔa mbɔdi kĩ yavɛlɛ be adzuni ɛyamɛna nɛ Baguma lɛgãkanya a akũ a. ");
INSERT INTO bov_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lɛmɛ bati a badi na atɔ ɔsĩ, bɛtátse kalɛ wĩ a, ade bɛlɛ tuwuli kpa nɛ boe Ɔlate Osi Wĩ a akũ nɛ bati a flee anɛ kamɛ a. Foesũ Paulo dzakũ nɛ be sɛkɛ̃, ade ɛkpã bikĩ bɛtɛ bido a ɛnamɛna Tirano kadzikɔ̃. Ade awã ɛkatsa be fɔtsa luwi nyɛ luwi a. ");
INSERT INTO bov_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɛkɔa futeli nviã ɛtsa be fɔtsa lɔmɔ, ade Yudafɔ mɔ Helafɔ a kĩ bideĩ nɛ Asia kamɛ kamɛ a lɛmɛ nu boe Ɔlate kalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Baguma kpa Paulo kɔbɛ̃ ɛkɛna awãwã fɔtsa pii. ");
INSERT INTO bov_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ntɛ bɛkɔa ye tuduku mɔ tɛtadiɛ malo bɛtamɔ basɔnɛ ni, bana akũ ɔsi, ade fɔablɔmɛna hũhũ kpa katomɛna bikĩ edeĩ nɛ be kamɛ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ade Yudafɔ bawanɛ badi tsɛ̃ nɛ fɔkɔ kĩ be malo bablɔmɛna hũhũ kpa. Bɛkɔna kĩ baapuli bɛkɔa Yesu dĩ bɛblɔmɛna hũhũ a. Bibi hũhũ kpa a kĩ, “Mablɔmɛna mi nɛ Yesu a kĩ ye fɔlɛtsa Paulo tsɛ̃ yalɛ a dĩ akũ!” ");
INSERT INTO bov_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bikĩ bɛkɛna fukĩĩ nyɛ bawaɛ̃nyole evũkɔnɔ kĩ bɛnyɛ Skeva, Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee babi. ");
INSERT INTO bov_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lɛmɛ kĩ bɛnabi hũhũ kpa adi tuwuli kĩĩ a, ebi be kĩ, “Ĩnyina Yesu, ĩnyina Paulo malo. Lɛmɛ mi kɔ̃, ĩnyína mi! Bawei mianɛ?” ");
INSERT INTO bov_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ade oti a kĩ ye kamɛ hũhũ a deĩ a wo nɛ be akũ ebo be a! Bilomɔ mɔ ɔdzɔ mɔ akũ fɔkpa bɛnɛ nɛ tɔtɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Fɔlɛtsa a kĩ fɔya a gba nɛ Efeso, ade Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ flee nu foe a. Nɛ foesũ libe wo bati paa, ade boe Ɔlate Yesu dĩ buki lide nɛ ode libu a. ");
INSERT INTO bov_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bati pii kĩ bɛdani tɔwɔlɛ kamɛ a, nɛ bɛya nɛ kanade bɛyanyɛ be tɔkpa bɛtsa. ");
INSERT INTO bov_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bikĩ bɛnyɛ bawanɛ ĩye madzikifɔ a lɛmɛ lɔ be fuwa, fɔ́bɛ mɔ foe akũ tuvoli bɛyamɛna bipila nɛ kanade. Tuvoli a kɔya aawo ndɛ sika ovoe mpim aduenum. ");
INSERT INTO bov_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Fɔtsã osi kĩĩ akũ boe Ɔlate kalɛ a gba mɔ kɔbɛ̃, kɛtɛ awã lɛmɛ flee. ");
INSERT INTO bov_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nɛ fukĩĩ liti a Hũhũ Kpalɛwa a fɔ̃ Paulo kɛna adzuni kĩ yanatsã Makedonia mɔ Akaia ɛnaa Yerusalem. Paulo lɛ kĩ, “Ntɛ nto awã ni, kɛnɛ kĩ ntɛ̃ nnaadã Roma lama.” ");
INSERT INTO bov_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Edo ye babumɛnanɛ nviã Timoteo mɔ Erasto kĩ bɛnya lɔtɔ bɛna Makedonia, ade ye mɔa edzi nɛ Asia kamɛ kamɛ fɛɛ a. ");
INSERT INTO bov_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nɛ lɔkɔ a na kamɛ ni, ɔdzɛ kpale odi ya nɛ Efeso kĩ fɔtsɛ̃ Kristo katɛ kado osi a akũ sũ. ");
INSERT INTO bov_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Fukĩĩ yi kayɔ futo odi kĩ bavɛ Demetrio kĩ yakɔa sika ovoe katu Artemis asɔli kɔla akũ fɔtsa a. Bɛmɔ ye adzuma bakɛnanɛ a banɔ foe kakpa bikĩ bayaabɔa afɔliɛ kakpa baviɔ̃ a. Adzuma kĩĩ akpa be nfasɔ baũ paa. ");
INSERT INTO bov_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Luwi a, Demetrio ve sika fɔtsa batunɛ a flee ɛkpɔta ade ebi be kĩ, “Nwaɛ̃ amɛ, minyina kĩ boe akũ kana to adzuma kĩĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ade mi mɔawɛ minu, mimɔ́ yededeede ayekĩ Paulo do boe adzuma kĩĩ kɔnyɔã a. Epuli ebula bati a adzuni kade kĩ baviɔ̃ fɔtsa kĩ bɔatu a lɛnɛ́nɛ, nnɛ́ nɛ Efeso odi fukĩĩ lamɛna kaya, mbom nɛ Asia tite a flee akũ. ");
INSERT INTO bov_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Lɛmɛ nnɛ́ boe adzuma odi aabu kade! Boe baviɔ̃ kpale Artemis dĩ mɔ obu flee lɛmɛ aawɔ nɛ Asia mɔ katinya kamɛ flee!” ");
INSERT INTO bov_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kĩ binu Demetrio fɔlɛtsa kĩĩ a kalɔkpa wo be mɔ ɔsĩ mɔ ɔsĩ ade bido fɔwɔla kabɔa awɛ kɔɔba kĩ, “Boe Ɔma Artemis nyɛ Efesofɔ baviɔ̃ kpale!” ");
INSERT INTO bov_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Fɔwɔla kĩĩ tɛ ɔmatɔ a kamɛ flee. Nɛ foesũ ɔmatɔ a bɔa obũ ade bipi Paulo batomɛnanɛ nviã a kĩ be nyɛ Gaio mɔ Aristarko kĩ bito Makedonia, bɛnamɛna ɔmatɔ a katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo lɛmɛ wɛ kufɛ kĩ yanaa awã, lɛmɛ batɛ badonɛ bɛbã sua ye osi. ");
INSERT INTO bov_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kayite a na banɔkɔɛ̃ kĩ bɛnyɛ Paulo bakɔba lɛmɛ do lɔtɔ nɛ ye sɛkɛ̃, bike ye aduli kĩ ɛtasuma katsɛnakɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lɔkɔ a na ni, katsɛnakɔ̃ a flee kɛna yoo. Bati a badi lamɛna lɛtsa mɔa kalɛ, babɛbã lamɛna lɛtsa bɛbã kalɛ, ade be pii lɛmɛ ti binyína lɛtsa a kĩ de sũ bɛyatsɛna nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ade Yudafɔ a vɛlɛ Aleksandro bɛyadzɛla nɛ lɔtɔ kĩ ɛyaanyɛ lɛtsa kĩ de lɛya a onukpɛ̃. Ade Aleksandro dzɛla akpɔ nɛ ode ete be awɛ kĩ bɛfɔ̃ ebi be kadi. ");
INSERT INTO bov_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kĩ bati a mɔ biyi ɔsũ kĩ Yudani yanɛ sũ ni, bibuki bɛbɔa fɔwɔla, fɔtɛ ndɛ ndɔũhuilɛ nviã. Bɛkalɛ kĩ, “Boe Ɔma Artemis nyɛ Efesofɔ baviɔ̃ kpale!” ");
INSERT INTO bov_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Owi tábuna fɔmɔ abãã ɔnɔkɔɛ̃ odi puli ɛyadina bati a ade ebi be kĩ, “Nwaɛ̃ amɛ Efesofɔ, mi kamɛ odi nyɛ odi nyina kĩ Efeso nyɛ Artemis, baviɔ̃ kpale a kadzikɔ̃, ade ke de kpalɛwa a kĩ lito ode lɛka a lɛmɛ deĩ nɛ boe sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Odima lɛláapuli ɛlɛ kĩ fɔlɛtsa kĩĩ lɛnyɛ́ ɔnɔkɔali, foesũ mina ɔwɔlɛ lɔkɔa mitakɛna lɛtsama mɔ kalɔkpa. ");
INSERT INTO bov_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kitonɛkĩ bati a kĩ mipi miyamɛna nɛ awĩ a táye Artemis kuviɔ̃la fɔtsa fudima ĩye bɛlɛ fɔlɛtsa kpa fudima bitia boe baviɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Lɛmɛ ntɛ Demetrio mɔ ye adzuma bakɛnanɛ a deĩ kalɛ mɔ odi kɔ̃ ni, fɔlɛtsa badzɛnɛ deĩ. Ade budeĩ fuwi kĩ foe akũ badzɛ fɔlɛtsa, kĩ baapuli bɛkɔa bɛtsa lɛtsa kĩ litia be a bɛnamɛna awã. ");
INSERT INTO bov_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lɛmɛ ntɛ fɔlɛtsa bɛbã minɛɛ kɔ̃ ni, mifɔ̃ bɔkɔa foe bɔnaayi nɛ fɔlɛtsa badzɛnɛ a anɛ bɛdzɛ nɛ mbla onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kitonɛkĩ nviã ɔtutũ kĩĩ kɔ̃ kɛna ndɛ kayidza kadza nɛ abãã akũ kĩ baapuli bɛbɔɛ fɔlɛtsa nɛ boe akũ. Ade ntɛ banɔkɔɛ̃ a via boe kadi ni, bɔláapuli bɔnyɛ foe onukpɛ̃. Baavɛlɛ boe sɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kĩ ɛlɛ fukĩĩ eyua, ɛnyɛ be flee a osi, ade bɛpansam a. ");
INSERT INTO bov_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kĩ ɔtutũ a onukpɛ̃ dɔ a, Paulo vɛ batɛ badonɛ a ɛkpɔta. Kĩ ɛna kadi ebi be, edo be kɔbɛ̃ lɛmɛ eyua a, evia osi ɛdzakũ ɛnaa Makedonia. ");
INSERT INTO bov_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Paulo tsã kamɛ kamɛ na flee ebi bati boe Ɔlate fɔlɛtsa pii ɛkado be kɔbɛ̃, ɛkɔa ɛyawo Akaia. ");
INSERT INTO bov_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Edzi nɛ awã tidetɔ ɛlalɛ. Lɔkɔ a kĩ ɛkamanɛ akũ kĩ yadzakũ ɛnaa Siria tite akũ, ɛyamɔ kĩ Yudafɔ a sui nɛ ye akũ. Nɛ foesũ eke otse kĩ yabuki ɛdani ɛtsã Makedonia kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bɛmɔ bati pii lɛtsã bɛnaa. Ade be nyɛ Sopater, Piro obi kĩ eto Beroia, Aristarko mɔ Sekundo kĩ bito Tesalonika. Babɛbã nyɛ Gaio kĩ eto Derbe, Tihiko mɔ Trofimo kĩ bito Asia, mɔ Timoteo. ");
INSERT INTO bov_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bɛnya boe lɔtɔ bɛnadzɔlɛ boe nɛ Troa ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kĩ bɔnya Yudafɔ Abodoo kĩ Ɛtáyila Fuwi a buyua a, budzi ɔkɔlɔ nɛ Filipi ade bunyina bɔnaa be sɛkɛ̃ nɛ Troa a. Buwo awã nɛ fuwi elo liti, ade budzi nɛ awã fuwi evũkɔnɔ a. ");
INSERT INTO bov_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nɛ ɛkwansieda luwi lɛtɔnyade akũ a, bɔtsɛna kĩ bɔa nya boe Ɔlate funitsã a. Nɛ kĩ Paulo aadzakũ ntɛ kade nyina sũ ni, ɛlɛ kɔdzɛla flee kɛnawo lɛnyɛ kayite. ");
INSERT INTO bov_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bɛtɛna tɛsɛdza nɛ abansulu kɔla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kĩ Paulo lɛ kɔdzɛla gɛlɛɛlɛ sũ tida bɔɛ Eutiko, opopo kĩ ede edzi nɛ nfansili. Eto abansulu kɔla kɔlalɛde a ɛyatɔ nɛ tite. Bikĩ bɛnabɔɛ ye a mɔ́ kĩ eku. ");
INSERT INTO bov_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lɛmɛ kĩ Paulo ka ɛnaa a, ɛkɛna akũ eboomu ye, ade ebi be kĩ, “Mitavila! Edeĩ nkpã!” ");
INSERT INTO bov_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ade be flee bibuki bide bɛnaa abansulu ode a bɛnanya boe Ɔlate funitsã a. Paulo buki ɛlɛmɔ be kɔdzɛla flee kɛnawo odenyinawi ade ɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nɛ kĩ lɛtsama tákɛna opopo a sũ ni, bɛkpã ye bɛnamɛna kɔla, ade ɔwɔlɛ ka edzi be a. ");
INSERT INTO bov_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo tsã abɔa ɛnaa Aso a. Lɛmɛ boe a kĩ butomɔ ye a budzi ɔkɔlɔ bɔnya ye lɔtɔ kĩ bɔ́anatsɛlamɔ akũ nɛ awã, lɔkɔa bɔbɔɛ ye ndɛ ayekĩ ɛtsa a. ");
INSERT INTO bov_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kĩ ɛyamɔ boe nɛ Aso a, boe flee bɔdzakũ bɔnaa Mitilene. ");
INSERT INTO bov_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Odenyinawi a buwo Kio ntintisɔ. Luwi lɛyade akũ ni bɔnawo Samo, ade nɛ luwi lɛlade a buwo Mileto a. ");
INSERT INTO bov_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo fɔ̃ bɔtɛ̃ Efeso, kitonɛkĩ ɛtáwɛ kĩ yabula lɔkɔ pii kade nɛ Asia tite akũ. Eke otse lɛmɛ kĩ ntɛ fɔ́ana ye sɔwa ni, yaana nɛ Yerusalem nɛ Pentekoste luwi a akũ. ");
INSERT INTO bov_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lɛmɛ kĩ buwo Mileto a Paulo do batɔ nɛ Efeso batɛ badonɛ banɔkɔɛ̃ a sɛkɛ̃ kĩ bɛyaatsɛlamɔ ye nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ade kĩ bɛyaa a, ebi be kĩ, “Nwaɛ̃ amɛ, mi a flee minyina ayekĩ ndzi nɛ mi sɛkɛ̃, kito lɔkɔ a kĩ ĩya nɛ Asia tite akũ a kɛyawo nviã kĩĩ a. ");
INSERT INTO bov_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mimɔ́ ayekĩ ndɔla yĩ akũ nsum Boe Ɔlate, titɔ kĩ nna nɛ lubo kamɔ mɔ kabe kamɛ, nɛ ayekĩ Yudafɔ wɛ kĩ bakɔ yĩ sũ. ");
INSERT INTO bov_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Lɛmɛ minyina kĩ ntákɔla mi ɔnɔkɔali a. Fɔtsa a flee kĩ ĩnyina nɛ boe Ɔlate akũ a, ade foe ntsa mi a. Ntsa foe nɛ kanade flee anɛ mɔ mi tɔtɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ade kakɔ nyɛ kakɔ kĩ ntsã mmini ni, ndɛ Yudafɔ mɔ Helafɔ flee mɔ ɔsĩ mɔ ɔsĩ kĩ bɛdani be tɔwɔlɛ kamɛ bɛya nɛ Baguma sɛkɛ̃, lɔkɔa bɛtɛ boe Ɔlate Yesu bido. ");
INSERT INTO bov_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Finyaakĩĩ manaa Yerusalem nɛ Hũhũ Kpalɛwa kawɛ onukpɛ̃, nɛ kĩ ĩnyína lɛtsa kĩ laaya nɛ yĩ akũ nɛ awã a. ");
INSERT INTO bov_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lɛmɛ nɛ ɔmatɔ odi nyɛ odi kamɛ kĩ ntsã ni, Hũhũ Kpalɛwa a fɔ̃ ĩnyi kĩ maawa kɔla nɛ lubo kamɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yĩ nkpã lɛla nfasɔ adima, ntɛ ntápuli nkɛna lɛtsa a kĩ boe Ɔlate Yesu do yĩ kĩ nkɛna a. Lɛtsa kĩ edo yĩ kĩ nkɛna nyɛ kĩ nkaabi bati Baguma Kalɛ Wĩ a, mɔ ayekĩ edeĩ sɛmɛ kalɛ ɛkpa boe. ");
INSERT INTO bov_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Finyaakĩĩ ĩnyina kĩ mi a flee kĩ minu kĩ ntsa mi fɔtsa nɛ Baguma lɛgãkanyakɔ̃ akũ, bɔmɔ́ mi bɔlaabuki bɔmɔ́ akũ dadaada. ");
INSERT INTO bov_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nɛ foesũ mabi mi paa nviã kĩĩ, kĩ ntɛ odi yɛla ye nkpã ni, nnɛ́ yĩ nfumusu fɔanɛ. ");
INSERT INTO bov_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kitonɛkĩ nɛ ɔnɔkɔali kamɛ ni, ntákɔla mi lɛtsama nɛ Baguma lɛgãkanyakɔ̃ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nɛ foesũ mina nɛ kukũmanɛ kamɛ. Hũhũ Kpalɛwa a lɛpau mi ndɛ lɔtɔ banyanɛ kĩ mipi ye babi a kĩ edo mi nɛ awɛ a kapi wĩ. Mipi be kapi wĩ, kitonɛkĩ Baguma kɔa ye Obi babɔanɛ eko nɛ tite ɛnyɛ be. ");
INSERT INTO bov_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ade ĩnyina yededeede kĩ ntɛ ndzakũ ni, bati kpa aayawo nɛ mi kamɛ lɔkɔa bɛyalɛ mi ndɛ ayekĩ kulikii awo nɛ baveli kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nɛ mi mɔa awɛ kamɛ malo ni, bavãlɛvã aanɛ, lɔkɔa bɛkpã batɛ badonɛ pii bɛtsãmɛna fɔvã fɔtsa katsa a osi akũ. ");
INSERT INTO bov_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Foesũ midã kadã wĩ, lɔkɔa mite anɛ ayekĩ nkɔa anɛ mɔ babe ntsa mi fɔtsa lɛnyɛ mɔ suwa flee nɛ futeli ɛlalɛ a kĩ nna nɛ mi kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Finyaakĩĩ, nkɔa mi mado nɛ Baguma awɛ kĩ ɛdãmɛna mi akũ mɔ ye fɔlɛtsa a kĩ fɔabumɛna bati a, fudo mi katɛkado kɔbɛ̃ ayekĩ fɔ́akɛna mi ode fɔtsa banyanɛ ndɛ bikĩ ɛpau ɛkpa ye akũ a aye. ");
INSERT INTO bov_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Anɛ tábɛɛlɛ yĩ nɛ odima sika ngbã ĩye suwovoe ĩye tilima akũ. ");
INSERT INTO bov_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mi awɛ minyina kĩ yĩ awɛ kĩĩ nkɔa nkɛna adzuma ndãmɛna yĩ mɔ bikĩ bitomɔ yĩ a lɛmɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nkɛna fukĩĩ bamɛ flee nnɛɛ matsa mi ayekĩ mikɛna adzuma kɔɔba mibumɛna ahiãfɔ, ade mite anɛ nɛ lɛtsa kĩ boe Ɔlate Yesu lɛ a kĩ, ‘Kakpa deĩ nhila kɛbɛ̃ katɛ.’ ” ");
INSERT INTO bov_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ade ke kĩ Paulo lɛ kɔdzɛla eyua a, eke aduli ade bɛmɔ be flee bɔbɔa mpaɛ a. ");
INSERT INTO bov_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Lɔkɔ a kĩ ɛkakla be a, bɛkɔa anɛ mɔ babe bɛkatu kaboomu ye. ");
INSERT INTO bov_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lɛtsa a kĩ de lɛfɔ̃ biwo ɔblɔ koũ a nyɛ ayekĩ ɛlɛ kĩ bɛmɔ be bɛláabuki bɛmɔ akũ dadaada a. Biyi ye osi bɛnawo ɔkɔlɔ a ɔwɛ̃ nɛ ɔwɔ abuĩ. ");
INSERT INTO bov_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kĩ bɔkla akũ buyua a, budzi ɔkɔlɔ bɔtsã kpĩĩ bunyina bɔnaa Kos. Kĩ kade nyina a buwo Rodo ade bɔtɛ̃ bɔnaa Patara a. ");
INSERT INTO bov_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Awã naa budzi ɔkɔlɔ odi kĩ yanaa Foenike. ");
INSERT INTO bov_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bɔmɔ́ Kipro tite a nɛ lɔtɔ, ade bɔtsã te kayɔ kayɔ a bɔnaduma nɛ Tiro, nɛ Siria tite akũ, awã kĩ baanyɛ fɔtsa flee a kĩ ɔkɔlɔ a nɔnɛ a. ");
INSERT INTO bov_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bɔmɔ́ batɛ badonɛ badi nɛ awã, ade bɔna nɛ be sɛkɛ̃ ɛkwansieda mɔa a, kitonɛkĩ Hũhũ Kpalɛwa a tsã be akũ bibi Paulo kĩ ɛtanaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kĩ boe kadzakũ wo ɔtɔ a, batɛ badonɛ a mɔ batsɔ̃ mɔ babi flee yi boe osi bɛnawo mpo abuĩ. Awã na boe flee buke aduli bɔbɔa mpaɛ. ");
INSERT INTO bov_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kĩ bɔkla akũ buyua a, buwo nɛ ɔkɔlɔ kamɛ ade be malo bimuniki bɛnaa fɔla a. ");
INSERT INTO bov_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bɔbɔɛ buto Tiro ade bɔnadza nɛ Ptolemia a. Bɔnawɔ̃na batɛ badonɛ a kĩ bideĩ nɛ awã ade budzi nɛ be sɛkɛ̃ luwi mɔa a. ");
INSERT INTO bov_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kĩ kade nyina a, bɔdzakũ nɛ awã bɔnaa Kaisarea. Bɔnase nɛ Filipo, Kalɛ Wĩ a Lɛtsã odenɛ a awã. Ɛnyɛ babumɛnanɛ evũkɔnɔ a kĩ bɛpau nɛ Yerusalem a kamɛ ɔmɔa. ");
INSERT INTO bov_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Edeĩ bayitsɔ̃ ɛna kĩ bidzí fɔnyɔ, ade bɛnyɛ Baguma onukpɛ̃ banyɛnɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bɔna nɛ awã fuwi fudi ade foe kamɛ a Baguma onukpɛ̃ ɔnyɛnɛ a kĩ bavɛ Agabo to Yudea ɛya a. ");
INSERT INTO bov_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ade kĩ ɛya nɛ boe sɛkɛ̃ a ɛbɔɛ Paulo ɔwɛ̃ a kĩ yakɔa kaboomu kate a esuli ye mɔa awɛ akpɔ mɔ abɔa, ade ɛlɛ kĩ, “Hũhũ Kpalɛwa a bo ni, ade aye Yudafɔ nɛ Yerusalem aasuli ɔwɛ̃ kĩĩ ɔlate bɛkɔa ye bido nɛ bikĩ bɛnyɛ́ Yudafɔ banɔkɔɛ̃ a awɛ a.” ");
INSERT INTO bov_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kĩ boe flee bunu fɔlɛtsa kĩĩ a, bɔmɔ́ bati a kĩ bideĩ nɛ awã flee a buke Paulo aduli kĩ ɛtanaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lɛmɛ Paulo bi boe kĩ, “Litsa nyɛ kabe a kĩ mikɔa miaveli yĩ akpɔ? Mmanɛ akũ nkpa nnɛ́ kĩ bisuli yĩ nɛ Yerusalem odi lɛmɛ kĩ maaku nɛ awã nɛ boe Ɔlate Yesu sũ.” ");
INSERT INTO bov_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kĩ bɔmɔ́ kĩ bɔláapuli bɔdani ye adzuni sũ ni, bɔfɔnɛ ye awɛ ade bɔlɛ kĩ, “Boe Ɔlate kawɛ kɛya nɛ foe kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Fuwi fudi liti ni, bɔmanɛ akũ ade bɔdzakũ bɔnaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Batɛ badonɛ badi to Kaisarea bitomɔ boe bɔnaa. Kĩ buwo awã a, bɛkpã boe bɔnase nɛ ɔnɔkɔɛ̃ odi kĩ bavɛ Mnason awã. Eto Kipro ade ɛnyɛ batɛ badonɛ batɔnyade a kamɛ ɔmɔa a. ");
INSERT INTO bov_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kĩ buwo Yerusalem a batɛ badonɛ a tɛ boe mɔ kawɔlɛ. ");
INSERT INTO bov_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kĩ kade nyina a, Paulo kpã boe bɔnamɔ Yakobo mɔ batɛ badonɛ banɔkɔɛ̃ flee a nɛ Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ade kĩ bɔnawɔ̃nɔ akũ buyua a, Paulo bɔa be amandiɛ nɛ lɛtsa nyɛ lɛtsa a kĩ Baguma kɛna nɛ ye kamini nɛ bikĩ bɛnyɛ́ Yudafɔ kamɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kĩ bitse fɔlɛtsa a biyua a, be flee bimu Baguma ade bibi ye kĩ, “Boe ɔwaɛ̃, dã ayekĩ Yudafɔ mpim mpim tɛ bido, ade bipini Mose mbla a mɔ ɔsĩ mɔ ɔsĩ a. ");
INSERT INTO bov_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bati badi bi be kĩ ɔtsa Yudafɔ a kĩ bideĩ nɛ fude fude a kĩ bɛtakɛna nɛ Mose mbla mɔ boe tɛmaniɛ a akũ, ade obuki ɔtsa kĩ bɛtatsua be babi fɔkpati lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Baanu kokooko kĩ ɔya nɛ boe sɛkɛ̃. Nɛ fukĩĩ sũ litsa kɛnɛ kĩ bɔkɛna finyaa?” ");
INSERT INTO bov_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ade ke bɛkpa ye adzuni kĩ “Budeĩ bati ɛna kĩ bido lidetɔ. ");
INSERT INTO bov_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kpã be kanamɛna Yudafɔ Asɔli Kɔla kamɛ kabumɔ be minyɛ lɔlɔ kakpa lidetɔ a kase foe kɔtɔ. Fukĩĩ aafɔ̃ odi nyɛ odi lɔmɔ kĩ fɔvã bɛma bite nɛ nɔ akũ, lɔkɔa fɔtsa lɛmɛ kĩ opini Mose mbla a kapini wĩ. ");
INSERT INTO bov_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Batɛ badonɛ a kĩ bɛnyɛ́ Yudafɔ a kɔ̃ ni, bɔtsɛlɛ be ovoli bubi be kĩ bɛtabuki bɛnya fɔtsa kĩ bɛkɔa bɛbɔa afɔliɛ bɛkpa baviɔ̃, bɛfɔ̃ babɔanɛ kanya, bɛtaba bayaɛ kĩ bɛtátsua be fɔmɔ, lɔkɔa bɛfɔ̃ linyolewɛ mɔ litsolewɛ.” ");
INSERT INTO bov_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Foesũ kĩ kade nyina a, Paulo kpã banyole a, ade bɔnakɛna lɔlɔ kakpa tsɔli tsɔli amaniɛ a. Ke liti a, ɛnaa Yudafɔ afɔliɛ kabɔakɔ̃ a ɛnakpa basɔfɔ kanyi nɛ fuwi a kĩ tɔlɔ kakpa amaniɛ a aawũna, mɔ futetsa a lɛmɛ kĩ yaama be bɛkɔa bɛbɔa afɔliɛ a nɛ be lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ade kĩ kite sukuloo lɔkɔa fuwi evũkɔnɔ a aawo ɔtɔ a, Yudafɔ badi kĩ bito Asia kamɛ a yamɔ Paulo nɛ Asɔli Kɔla a kamɛ. Bido ɔtutũ nɛ bati a badi kamɛ ade bipi Paulo a. ");
INSERT INTO bov_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bɛkabɔa fɔwɔla kalɛ kĩ, “Israelfɔ miyaatɛ mɔ boe tsoo! Ade oti kĩĩ tsɛ̃ yamini nɛ kakɔ nyɛ kakɔ, yabi bati kĩ bɛtakɛna nɛ boe Yudafɔ mbla aku a. Ye lɛmɛ ɛkpã Grikifɔ ɛyawomɛna nɛ Asɔli Kɔla a kamɛ, kĩ fɔatsa kĩ ebula boe kakɔ kpalɛwa kĩĩ.” ");
INSERT INTO bov_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bɛlɛ foe lɔmɔ kitonɛkĩ luwi a bɛnya lɔtɔ bɛmɔ́ Paulo mɔ Trofimo kĩ eto Efeso a, kĩ bɛtsɛ̃ bamini nɛ Yerusalem. Nɛ foe sũ bɛkɔna kĩ ɛkpã ye ewomɛna nɛ Asɔli Kɔla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nɛ fɔwɔla kabɔa a sũ, akũ nyɛnɛ bati a flee ade biwula atsɛ yoo bɛnatsɛna nɛ Asɔli Kɔla a kamɛ. Badi vɛlɛ Paulo bɛnɛmɛna ade bɛbalɛ tunyukpɛ̃ flee a. ");
INSERT INTO bov_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Lɔkɔ a kĩ bɛwɛ kĩ bakɔ ye a, Romafɔ sodzafɔ ɔnɔkɔɛ̃ odi nu kĩ Yerusalem ɔmatɔ a flee deĩ nɛ ɔtutũ kamɛ mɔ fɔwɔla kabɔa. ");
INSERT INTO bov_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Deedimɔapɛ ɛkpã sodzafɔ badi bɛnaa awã kĩ bɛkakɛna hũnyɛhũnyɛ a. Kĩ bati kĩĩ mɔ sodzafɔ mɔ be ɔnɔkɔɛ̃ a pɛ bɛfɔ̃ Paulo katuli. ");
INSERT INTO bov_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Awã naa, sodzafɔ ɔnɔkɔɛ̃ a fɔ̃ bipi Paulo ade bido ye nkɔsɔnkɔsɔ nviã a. Ade evia etse oti a odu kĩ yanɛ mɔ lɛtsa a kĩ de ɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bati a flee kanyɛ tunukpɛ̃ futefute. Kĩ sodzafɔ ɔnɔkɔɛ̃ a lanu lɛtsama kayɔ pɔtii etomɛna be sɛkɛ̃ nɛ fɔwɔla mɔ ɔsĩ a sũ ni, ɛfɔ̃ bɛkɔa Paulo bɛnado nɛ kɔla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Kĩ bɛkɔa bade kɔla onyukpɛ̃ kadekɔ̃ a, fɔya nɛ sodzafɔ a kamɛ kĩ bɛbɔɛ Paulo bɛdɛla nɛ ode nɛ bati kɔdabu a kalɔkpa a kĩ bɛna nɛ Paulo akũ sũ. Ade bitomɔ be mɔ fɔwɔla kpaa kabɔa kĩ, “Mikɔ ye! Mikɔ ye!” ");
INSERT INTO bov_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lɔkɔ a kĩ bɛkɔa ye bado nɛ kɔla kamɛ a, Paulo bi sodzafɔ ɔnɔkɔɛ̃ a kĩ. “Nwɛ kĩ malɔmɛna mɔ nɔ sukuloo.” Ade ke sodzafɔ ɔnɔkɔɛ̃ a via ye kĩ, “Yie! Alɛ Griki tide?” ");
INSERT INTO bov_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ade ebuki evia ye kĩ, “Nɛ nɔ nyɛ Egipteni a kĩ lɔkɔ lidi ɛkpã awudifɔ mpim ɛna biyidza bɛdza nɛ abãã akũ, kĩ bilo bɛnaa kɔsa kamɛ a?” ");
INSERT INTO bov_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ade Paulo kpa mbuayɛ kĩ, “Yudani manɛ. Bɛma yĩ nɛ Tarso nɛ Kilikia tite akũ. Ade ɔmatɔ a na ni, nnɛ́ ɔmatɔ kabii yanɛ. Foesũ make nɔ aduli fɔ̃ nlɛmɔ bati kĩĩ kɔdzɛla.” ");
INSERT INTO bov_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Adeke ɔnɔkɔɛ̃ kĩĩ tunɔ kĩ Paulo ɛlɛmɔ be kɔdzɛla a. Paulo nɛ ɛyadza nɛ onyukpɛ̃ kadekɔ̃ a, ade ete awɛ nɛ bati kɔdabu akũ kĩ bɛkɛna dĩĩ a. Kĩ bɛfɔ̃ fɔwɔla kabɔa a, ɛlɛmɔ be kɔdzɛla nɛ Yudafɔ tide kamɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Nda amɛ mɔ nwaɛ̃ amɛ, agoo! Mifɔ̃ ĩnyɛ yĩ onukpɛ̃ kamɛ fɔlɛtsa mitse.” ");
INSERT INTO bov_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kĩ binu kĩ Yudafɔ tide kamɛ ɛlɛ kɔdzɛla a, bɛkɛna fɔwɔla kabɔa nɛ kayɔ bibu. Ade ke Paulo bi be kĩ, ");
INSERT INTO bov_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yudani manɛ ade bɛma yĩ nɛ Tarso, nɛ Kilikia tite akũ a. Lɛmɛ Yerusalem nɛ awĩ bɛdɔɔla yĩ, nkɔlɛ fɔtsa nɛ Gamaliel kayɔ. Bɛtsa yĩ boe bawanyɔ mbla a mɔ foe akũ amaniɛ a flee yededeede. Ade nkɔa yĩ ɔwɔlɛ flee nkpa Baguma ndɛ ayekĩ mi malo miakɛna nviã kĩĩ a. ");
INSERT INTO bov_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kito lɔkɔ a na, ntomɔ batɛ badonɛ a kĩ bɛtsɛ̃ osi vɔɛ̃ a liti, nwɛ kĩ bɛkɔ be. Ade nkapi batsole mɔ banyole kado nɛ kɔla a. ");
INSERT INTO bov_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Boe Ɔsɔfɔnɔkɔɛ̃ Flee mɔ ɔmaĩ banɔkɔɛ̃ aapuli bidi adansiɛ nɛ fukĩ malɛ kĩĩ akũ, kitonɛkĩ bɛkatsɛlɛ tuvoli kakpa yĩ kĩ nkɔa nkɛna fɔtsa kĩĩ bamɛ. Ade lɔkɔ a kĩ manaa Damasko a ni, bɛkpa yĩ tuvoli kĩ nkɔa mma Yudafɔ nɛ awã ndza nɛ foe akũ mpili batɛ badonɛ a nsuli be nkɔa ĩyamɛna nɛ Yerusalem bɛvɛlɛ be sɔtɔ. ");
INSERT INTO bov_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Lɔkɔ a kĩ ntsɛ̃ manaa, kĩ kite sukuloo mawo Damasko, ndɛ suwa tɔdɔũ ewua-nviã kamɛ a ni, deedimɔapɛ ɔhaĩ mɔ ɔsĩ odi to ode ɛka eko nɛ yĩ akũ! ");
INSERT INTO bov_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Adeke nka ntɔ nɛ tite, ade nnu ɔlɛdo odi kĩ ɛkavia yĩ kĩ, ‘Saulo, Saulo, nde sũ oyidza ɔdza nɛ yĩ akũ lɔmɔ?’ ");
INSERT INTO bov_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ade nvia kĩ, ‘Boe Ɔlate, nɔ owei anɛ?’ “Ebuki ebi yĩ kĩ, ‘Yĩ nyɛ Yesu Nazaretni a kĩ ye akũ oyidza ɔdza a.’ ");
INSERT INTO bov_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bati a kĩ bɔmɔ be tsɛ̃ a mɔ́ ɔhaĩ a lɛmɛ bɛtánu oti a kĩ bɔmɔ ye lɛkalɛ kɔdzɛla a odo. ");
INSERT INTO bov_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ade nvia ye kĩ, ‘Boe Ɔlate, litsa kɛnɛ kĩ nkɛna?’ “Ebi yĩ kĩ, ‘Yidza kanaa Damasko ɔmatɔ a kamɛ. Awã na maatsa nɔ lɛtsa a kĩ nwɛ kĩ kɛna a.’ ");
INSERT INTO bov_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɔhaĩ kĩĩ kɔ yĩ anɛ foesũ bati a kĩ bɔmɔ be tsɛ̃ a lipi yĩ nɛ kɔkpɔ bɛkpã yĩ bɔdzakũ bɔnawo Damasko ɔmatɔ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Onyole odi kĩ bavɛ Anania na nɛ awã. Ɛnyɛ oti kĩ yavila Baguma ade yakɛna nɛ boe mbla lɛmɛ akũ yededeede a. Yudafɔ a kĩ bideĩ nɛ awã flee a akpa ye obu. ");
INSERT INTO bov_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Oti kĩĩ yadza nɛ yĩ ɔwɛ̃ ade ebi yĩ kĩ, ‘Nwaɛ̃ Saulo bu kamɔ fɔkɔ!’ Lɔkɔ a na kamɛ pɛpɛɛpɛ yĩ anɛ kamɛ kpalɛ yededeede ade mmɔ́ ye a. ");
INSERT INTO bov_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ade ebi yĩ kĩ, ‘Boe bawanyɔ Baguma lɛpau nɔ eyi kĩ nyi ye fɔwɛtsa, kamɔ ye Obi Kpalɛwa a kĩ Bɛpau a lɔkɔa kanu ye kɔdzɛla lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kɛnɛ kĩ akɔa ɔlɛdo kĩĩ ɔnamɛna kakɔ nyɛ kakɔ, obi bati flee lɛtsa a kĩ ɔmɔ́ mɔ lɛtsa kĩ onu a. ");
INSERT INTO bov_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Finyaakĩĩ litsa adzɔlɛ? Yidza lɔkɔa katɛ mui kawɔla amaniɛ. Bɔa mpaɛ nɛ ye dĩ akũ lɔkɔa ɛkɔa nɔ titikpa ete nɔ.’ ");
INSERT INTO bov_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Fukĩĩ liti a, mmuniki nnaa Yerusalem. Ade kĩ nna nɛ Asɔli Kɔla kamɛ nkabɔa mpaɛ a, fɔkɔna ndɛ tida abɔɛ yĩ, ade nna kanyɛkatsa kadi a. ");
INSERT INTO bov_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ade awã na boe Ɔlate bi yĩ kĩ, ‘Wɛ sɔwa kadzakũ nɛ Yerusalem kitonɛkĩ awĩ bati lɛláatse nɔ fɔlɛtsa a kĩ aalɛ nɛ yĩ akũ a.’ ");
INSERT INTO bov_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Lɛmɛ nkpa mbuayɛ kĩ, ‘Boe Ɔlate, be flee binyina kĩ yĩ lɛkapili bikĩ bɛtɛ nɔ bido a nɛ Yudafɔ fɔtsɛnakɔ̃ a kabo be. ");
INSERT INTO bov_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ade lɔkɔ a kĩ bɛkakɔ nɔ ɔdansini Stefano a, yĩ malo ntunɔ. Foesũ bɛnyɛ be tɛtadiɛ bɛkpa yĩ nlɛ ade bɛkatalɛ ye boe a.’ ");
INSERT INTO bov_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Lɛmɛ boe Ɔlate bi yĩ kĩ, ‘Yidza kanaa, maado nɔ mɔ lugo nɛ bikĩ bɛnyɛ́ Yudafɔ a kamɛ!’ ” ");
INSERT INTO bov_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lɔkɔ kĩĩ flee a, bati a dza dĩĩ bɛkatse ye kalɛ a. Lɛmɛ mɔ ye kalɛ nkaɛ kawũna pɛ, be flee bɔbɔa fɔwɔla kɔɔba kĩ, “Aa! Kɛtáfɛta kĩ yadzi nkpã! Mikpã ye minamɛna minaakɔ ye!” ");
INSERT INTO bov_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nɛ kĩ bɛna kalɔkpa paa sũ ni, bɛbɔa fɔwɔla kɔɔba ade bido be tɛtadiɛ kayɛlɛ, mɔ kudu kata nɛ ɔwɛ kamɛ awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ade ke kawũ banɔnɛ ɔnɔkɔɛ̃ a fɔ̃ bɛkpã ye biwomɛna nɛ kɔla kamɛ kĩ bɛnaabo ye lɔkɔa binyi lɛtsa a sũ kĩ Yudafɔ a kpa biko nɛ ye akũ lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lɔkɔ a kĩ bɛkasuli ye a, Paulo via kawũ banɔnɛ ɔnɔkɔɛ̃ odi kĩ ɛdzɛ̃ nɛ awã kĩ, “Osi waa kĩ babo Romani ntɛ bɛtádzɛ ye fɔlɛtsa tɔ̃?” ");
INSERT INTO bov_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ɔnɔkɔɛ̃ kĩĩ naa be lɔtɔ ɔnyanɛ a sɛkɛ̃ ade evia ye kĩ, “Litsa akɛna nɛ awĩ a? Onyole kĩĩ boni Romani yanɛ!” ");
INSERT INTO bov_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Foesũ kawũ banɔnɛ lɔtɔ ɔnyanɛ a ya nɛ Paulo sɛkɛ̃ ade evia ye kĩ, “Abo nde? Romani anɛ?” Ade ke Paulo kpa mbuayɛ kĩ, “Romani manɛ!” ");
INSERT INTO bov_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kawũ banɔnɛ lɔtɔ ɔnyanɛ a bi ye kĩ, “Yĩ malo Romani manɛ. Yĩ kɔ̃ nse kɔtɔ baũ fɔmɔ ndani nkɛna Romani!” Ade Paulo bi ye kĩ, “Yĩ kɔ̃ yĩ bamanɛ flee nyɛ Romafɔ.” ");
INSERT INTO bov_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ade ke kĩ bati a kĩ bɛdza kĩ babo ye bivia ye onukpɛ̃ kamɛ fɔlɛtsa nu kĩ Romani yanɛ a, bɛvɛlɛ akũ bɛnaa liti. Kĩ be lɔtɔ ɔnyanɛ a nyi kĩ Romani yanɛ a, libe wo ye paa, kitonɛkĩ ye lɛkpa osi kĩ bisuli Paulo bibo ye. ");
INSERT INTO bov_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kĩ kade nyina, kawũ banɔnɛ ɔnɔkɔɛ̃ a wɛ kĩ yanyi lɛtsa a kĩ de sũ bɛbɔɛ fɔlɛtsa nɛ Paulo akũ. Ɛvɛ Yudafɔ basɔfɔnɔkɔɛ̃ mɔ be fɔlɛtsa badzɛnɛ ɛkpɔta. Ɛfɔ̃ biwũnya tɔwɛ̃ nɛ Paulo akũ ade bɛkpã ye bɛyadzɛla nɛ be anɛ kamɛ kĩ bawɛ ye fɔlɛtsa a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ade kĩ Paulo ko anɛ ɛdã Yudafɔ fɔlɛtsa badzɛnɛ a kĩ bikoni dĩĩ nɛ fɔlɛtsa kadzɛkɔ̃ a, ebi be kĩ, “Nwaɛ̃ amɛ Israelfɔ, yĩ ɔwɔlɛ kamɛ kpalɛ nɛ ayekĩ ndzi nkpã nɛ Baguma anɛ kɛyawo nviã kĩĩ a.” ");
INSERT INTO bov_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kĩ Anania, Yudafɔ Ɔsɔfɔnɔkɔɛ̃ Flee a kĩ ɛna nɛ awã nu ayekĩ Paulo kpa mbuayɛ a, ebi bikĩ bɛdza bifuãmɔ Paulo kĩ bɛbɔa ye nɛ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ade awã mɔ Paulo bi ye kĩ, “Baguma lɛmɛ aabalɛ nɔ awɛ! Nɔ seebi kĩ bikputa se fɔtsa ovoe bɛdzɛla anɛ! Litsa fɔlɛtsa ɔdzɛnɛ anɛ? Mbla akũ ɔtsɛ̃ adzɛmɔ yĩ, lɛmɛ ade ye mɔapɛ a ɔlamɛna kafum a, nɛ kĩ ɔkpa kɔbɛ̃ bɛbalɛ yĩ ɔlɔtɔ sũ!” ");
INSERT INTO bov_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ade ke bikĩ bɛdzɛ nɛ Paulo ɔwɛ̃ a via ye kĩ, “Ɔsɔfɔnɔkɔɛ̃ Flee ovũna lɔmɔ?” ");
INSERT INTO bov_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo kpa mbuayɛ kĩ, “Nwaɛ̃ amɛ, ntɛ ĩnyi kĩ Ɔsɔfɔnɔkɔɛ̃ Flee yanɛ ni, kufɛ ntádo ye onukpɛ̃ lɔmɔ. Kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, ‘Talɛ tuwuli kpa nɛ bikĩ banya mi akũ a akũ.’ ” ");
INSERT INTO bov_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ade kĩ Paulo mɔ eyi ɔsũ kĩ bati a kĩ bɛkpɔta nɛ awã a be kamɛ badi nyɛ Zadukifɔ ade badi lɛmɛ nyɛ Farisifɔ a sũ ni, ɛbɔa fɔwɔla kɔɔba kĩ, “Nwaɛ̃ amɛ, Farisini manɛ! Farisifɔ lɛmɛ lɛma yĩ! Nviã kĩĩ badzɛmɔ yĩ kitonɛkĩ ntɛ banɔkpa kabuki kayidza kadzi nkpã a ndo sũ!” ");
INSERT INTO bov_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kĩ Paulo sila ɛlɛ fɔlɛtsa kĩĩ eyua pɛ, kavɛlɛ ya nɛ Farisifɔ mɔ Zadukifɔ a kayite, ade bɛsɛ̃ be akũ a. ");
INSERT INTO bov_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kitonɛkĩ Zadukifɔ alɛ kĩ banɔkpa lábuki kayidza, ode fɔtɔ banyanɛ lɛláa, ade hũhũ lɛmɛ lɛláa a. Lɛmɛ Farisifɔ kɔ̃ tɛ fukĩĩ bamɛ flee bido. ");
INSERT INTO bov_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ɔtutũ kpale wo nɛ be kamɛ. Farisifɔ mbla batsanɛ a dza nɛ Paulo liti kĩ ye fɔlɛtsa a nyɛ ɔnɔkɔali. Ade ke bɛbɔa fɔwɔla kɔɔba kĩ, “Bɔtámɔ lɛtsa kpa lidima nɛ ye akũ! Ɔsa hũhũ adi ĩye ode fɔtɔ ɔnyanɛ odi alɛmɔ ye kɔdzɛla!” ");
INSERT INTO bov_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fɔwɔla kabɔa a buki fude nɛ ode fubu. Ade bati a flee pini Paulo bɛkavɛlɛ kadu kanamɛna kayamɛna a. Kĩ sodza ɔnɔkɔɛ̃ a vila kĩ baavɛlɛ ye bɛpããpãã sũ ni, ebi ye sodzafɔ a kĩ bɛka bɛnaatɛ ye bɛnaado nɛ kɔla. ");
INSERT INTO bov_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Luwi a lɛnyɛ a, boe Ɔlate yadza nɛ Paulo ɔwɛ̃ ebi ye kĩ, “Paulo do ɔwɔlɛ. Ayekĩ odi adansiɛ nɛ yĩ akũ nɛ Yerusalem nɛ awĩ a, ade ayea kɛnɛ kĩ akɛna nɛ Roma lɛmɛ a.” ");
INSERT INTO bov_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kĩ kade nyina a, Yudafɔ badi lɔ fubo bɛkpa be akũ kĩ ntɛ bɛtákɔ Paulo ni, bɛláanya ĩye bɛmɔa! ");
INSERT INTO bov_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bati kĩĩ lidede aana ndɛ be tɛna mɔ liti. ");
INSERT INTO bov_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ade ke bibuki bɛnaa basɔfɔnɔkɔɛ̃ mɔ be lɔtɔ banyanɛ sɛkɛ̃ bibi be kĩ, “Bɔlɔ fubo kĩ bɔlaanya ĩye bɔmɔa kɛnaawo kĩ bɔkɔ Paulo. ");
INSERT INTO bov_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Foesũ mimɔ fɔlɛtsa badzɛnɛ a mibi sodzafɔ lɔtɔ ɔnyanɛ a kĩ, ebuki ɛkɔa Paulo ɛyamɛna nɛ katsɛnakɔ̃ nɛ awĩ. Mikɛna ndɛ miawɛ kĩ miavia ye fɔlɛtsa fudi mibu. Ntɛ bɛkɔa ye bayamɛna ni, bɔ́akɔ ye nɛ osi.” ");
INSERT INTO bov_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lɛmɛ Paulo ɔfanyole odi nu fɔlɛtsa a flee kĩ bɛlɛ a, ade ewula atsɛ ɛnaa kɔla kamɛ, ɛnabi Paulo lɛtsa a kĩ de bɛlɛ a. ");
INSERT INTO bov_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ade ke Paulo vɛ sodzafɔ a kĩ bɛdza nɛ awã kamɛ ɔmɔa ebi ye kĩ, “Kpã obisɛ̃ kĩĩ minaa ɔnɔkɔɛ̃ sɛkɛ̃. Ɛnɛɛ kalɛ mɔ ɔsĩ kĩ yaabi ye.” ");
INSERT INTO bov_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Foesũ sodzani a kpã kabisɛ̃ɛ̃ a bɛnaa be lɔtɔ ɔnyanɛ a sɛkɛ̃, ade ebi ye kĩ, “Paulo a kĩ bido nɛ kɔla kamɛ nɛ awĩ a lɛvɛ yĩ ebi yĩ kĩ nkpã kabisɛ̃ɛ̃ kĩĩ mma nɔ, lɔkɔa kibi nɔ kalɛ kadi.” ");
INSERT INTO bov_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ade sodzafɔ lɔtɔ ɔnyanɛ a pi kabisɛ̃ɛ̃ a nɛ kɔkpɔ bɛnaa ɔɔwɛ̃ ade evia ye kĩ, “Litsa awɛ kĩ abi yĩ?” ");
INSERT INTO bov_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ade ke mɔ ebi ye kĩ, “Yudafɔ badi kɛna onukpɛ̃ mɔa mɔ be banɔkɔɛ̃ a kĩ bayaake nɔ aduli lɔkɔa kunya ɔkpã Paulo ɔyamɛna nɛ katsɛnakɔ̃, mɔ kakɔna kĩ bavia ye fɔlɛtsa fudi. ");
INSERT INTO bov_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lɛmɛ tatse be kitonɛkĩ bati ndɛ be tɛna bɛla nɛ osi badzɔlɛ ye. Bati kĩĩ lɔ fubo kĩ mbɔɛntɛ bɛkɔ Paulo fɔmɔ baata funitsã onukpɛ̃. Nɛ foesũ bɛmanɛ akũ bɛnabɛla badzɔlɛ nɔ osi kakpa. Bɛnabɛla nɛ osi ɔɔwɛ̃ kitonɛkĩ bɛtɛ bido kĩ aatunɔ ɔkpa be.” ");
INSERT INTO bov_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sodzafɔ lɔtɔ ɔnyanɛ a si ye mbla kĩ, “Tafɔ̃ odima libuki enu lɛtsa a kĩ ɔyabi yĩ nɛ awĩ a dadaada.” Ade ke ɛnyɛ ye osi ɛdzakũ a. ");
INSERT INTO bov_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ade ke sodzafɔ lɔtɔ ɔnyanɛ a vɛ ye banɔkɔɛ̃ nviã ade ebi be kĩ, “Miwɛ sodzafɔ ɔha nviã kĩ baanaa Kaisarea nviã lɛnyɛ. Miwɛ bikĩ balɛ fɔtsɔɛ ɔha nviã, mɔ bikĩ badzi bapɔnkɔ lɛmɛ be bati aduesɔũ. ");
INSERT INTO bov_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Miwɛ ɔpɔnkɔ mikpa Paulo edzi nɛ ye akũ lɔkɔa mikpã ye bɔɛɛ, mima abãã ɔnɔkɔɛ̃ Felike.” ");
INSERT INTO bov_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ade ke ɛtsɛlɛ ovoli odi ɛkpa abãã ɔnɔkɔɛ̃ a kĩ, ");
INSERT INTO bov_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ovoli kĩĩ to yĩ Klaudio Lisia sɛkɛ̃. Mawɔ̃na nɔ, boe Abãã Ɔnɔkɔɛ̃ Felike. ");
INSERT INTO bov_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yudafɔ badi pi oti kĩĩ, ade bɛwɛ kĩ bakɔ ye a. Lɛmɛ kĩ bɔmɔ sodzafɔ buwo awã a, nnu kĩ Romani yanɛ sũ ni, nfɔ̃ sodzafɔ a tɛ ye nɛ be awɛ. ");
INSERT INTO bov_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Foesũ nkpã ye ĩyamɛna nɛ be fɔlɛtsa kadzɛkɔ̃ kĩ manyi lɛtsa a kĩ ɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ĩyamɔ kĩ lɛtsa kĩ bɛbɔɛ nɛ ye akũ a nyɛ Yudafɔ ɔsum mbla akũ fɔlɛtsa kĩ fɔnyɛ́ fukĩ bado ye nɛ kɔla kamɛ ĩye bɛkɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Adeke kĩ bibi yĩ kĩ bɛlamɔ nhihiɛ kakɛna kĩ baakɔ ye sũ ni, nkɔna kĩ makɔa ye mma nɔ. Mbi bikĩ bɛbɔɛ kalɛ nɛ ye akũ a ku kĩ bɛkɔa ke bɛma nɔ. ");
INSERT INTO bov_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Foesũ luwi a lɛnyɛ a sodzafɔ a kpã Paulo bɛnawo Antipatre. ");
INSERT INTO bov_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kĩ kade nyina, sodzafɔ a kĩ bɛtsã abɔa a muniki bɛnaa kɔla kamɛ, ade bɛfɔ̃ bapɔnkɔ badzinɛ a kpã Paulo bɛnamɛna Kaisarea a. ");
INSERT INTO bov_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kĩ biwo awã a, bɛkɔa Paulo mɔ ovoli a kĩ bɛnɛɛ a bɛkpa abãã ɔnɔkɔɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kĩ ɛkã ovoli a eyua a, evia Paulo amantam a kĩ eto. Ade kĩ enyi kĩ Paulo to Kilikia a, ebi ye kĩ, ");
INSERT INTO bov_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Maanaa nɔ fɔlɛtsa kĩĩ kamɛ yededeede ntɛ bikĩ mimɔ be mina kalɛ a ya nɛ awĩ.” Ade ke ɛkpa sodzafɔ a kĩ bɛdza nɛ awã a kɔbɛ̃ kĩ bɛkɔa Paulo bido nɛ kɔla a kĩ Lɛgã Herodes ke a kamɛ lɔkɔa bɛkaadã ye akũ. ");
INSERT INTO bov_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Fuwi elo liti a, Ɔsɔfɔnɔkɔɛ̃ Flee Anania, Yudafɔ lɔtɔ banyanɛ mɔ fɔlɛtsa ɔdzɛnɛ kĩ bavɛ Tertulo naa Kaisarea. Bɛya nɛ Felike sɛkɛ̃ kĩ bayaanyɛ Paulo nfumusu bɛtsa ye. ");
INSERT INTO bov_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kĩ bɛvɛ Paulo bɛyamɛna a, Tertulo yi Paulo onukpɛ̃ katsua kĩ, “Boe Ɔlate, nɛ nɔ nyansã mɔ adzuni kĩ ɔnɛɛ akpã boe sũ ni, bɔna lukudɔ nɛ lɔkɔ pii kamɛ. Ade kavɛmɛna pii lɛmɛ ya nɛ boe tite akũ a. ");
INSERT INTO bov_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Fukĩĩ nyɛ fɔtsa kĩ fuwo boe Yudafɔ flee anɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bɔake nɔ aduli kĩ tse fɔlɛtsa a kĩ maabi nɔ nɛ onyole kĩĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kitonɛkĩ bɔmɔ́ ye buyi ɔsũ kĩ ɔdzɛ odonɛ yanɛ, ade ɛtsɛ̃ nɛ kakɔ nyɛ kakɔ yadani Yudafɔ kakɔna nɛ katinya kamɛ kĩ bɛkɛna fɔtsa basa bitia abãã a. Ɛnyɛ lɔtɔ ɔnyanɛ ɛkpa Nazaretfɔ katsu a. ");
INSERT INTO bov_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Foe liti a bɔmɔ́ lɛmɛ kĩ ɛtsɛ̃ yakɛna fɔtsa kĩ fɔado boe Yudafɔ Asɔli Kɔla a efĩĩ, ade bupi ye a. Foesũ bɔwɛ kĩ bɔadzɛmɔ ye nɛ boe mbla onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lɛmɛ kawũ banɔnɛ lɔtɔ ɔnyanɛ Lisia kɔa kɔbɛ̃ ɛyate ye nɛ boe awɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ntɛ ovia oti kĩĩ onukpɛ̃ kamɛ fɔlɛtsa ni, aapuli onyi fɔlɛtsa a kĩ bɔbɔɛ nɛ ye akũ a otomɛna ye sɛkɛ̃.” ");
INSERT INTO bov_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ade ke Yudafɔ a flee tunɔ mɔ onukpɛ̃ mɔa bɛlɛ kĩ fɔlɛtsa a kĩ Tertulo lɛ a nyɛ ɔnɔkɔali. ");
INSERT INTO bov_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kĩ abãã ɔnɔkɔɛ̃ a vɛ Paulo kĩ ɛlɛ kɔdzɛla a, eyi kayɔ kĩ, “Boe Ɔlɛga, ĩnyina kĩ nɛ futeli pii kĩ fɔtɛ̃ kĩĩ kamɛ ni, nɔ adzɛ Yudafɔ fɔlɛtsa. Nɛ foesũ kawɔlɛ de yĩ kĩ maanyɛ yĩ onukpɛ̃ nɛ nɔ anɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Aanu kĩ fɔ́ana ndɛ fuwi ewua-nviã kĩ ĩya nɛ Yerusalem ĩyaabɔa afɔliɛ nɛ Yudafɔ Asɔli Kɔla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ade odima támɔ kĩ bɔmɔ odi bɔkɛna ɔdzɛ ĩye ndo ɔtutũ nɛ Yudafɔ Asɔli Kɔla kamɛ, be fɔtsɛnakɔ̃, ĩye kakɔ kadi nɛ ɔmatɔ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ade bati kĩĩ kamɛ odima lɛláapuli eke otse nɛ lɛtsama akũ pɔtii kĩ fɔlɛtsa a kĩ bɛlɛ nɛ awĩ a ni, ɔnɔkɔali fɔanɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lɛmɛ lɛtsa a kĩ de akũ ntunɔ nyɛ kĩ masum boe bawanyɔ Baguma, ade ntomɛna Osi a kĩ balɛ kĩ ɛnyɛ́ osi wĩ a. Ntɛ fɔlɛtsa a kĩ bɛtsɛlɛ nɛ Mose mbla a mɔ Baguma onukpɛ̃ banyɛnɛ tuvoli a kamɛ a ndo. ");
INSERT INTO bov_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ndeĩ kɔnɛte nɛ Baguma akũ ndɛ ayekĩ be malo bideĩ, kĩ Baguma aadzɛla bati wĩ mɔ bati kpa flee etomɛna kanɔkpa. ");
INSERT INTO bov_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nɛ kɔnɛte kĩĩ sũ ni, mabɔa mbɔdi paa kĩ yĩ ɔwɔlɛ kamɛ ɛkpalɛ yededeede nɛ Baguma mɔ batidziwa anɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ade futeli pii kĩ ndzakũ nɛ Yerusalem a. Finyaakĩĩ ĩyaate ahiãfɔ fɔtsa lɔkɔa mbɔa afɔliɛ nkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kĩ mayua lɔlɔ kakpa amaniɛ a, Yudafɔ badi yamɔ yĩ nɛ Asɔli Kɔla a kamɛ. Nnɛ́ bɔmɔ́ bati kĩ banyɛ lɛma tsɛ̃. Ade ke ntádo ɔdzɛ odima lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yudafɔ a kĩ bito Asia tite akũ a na nɛ awã, ade be kɛnɛ kĩ bɛyaadza nɛ nɔ anɛ kamɛ a, lɔkɔa ntɛ bideĩ kalɛ kadi nɛ yĩ akũ ni, baalɛ. ");
INSERT INTO bov_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ĩye afɔ̃ bati a kĩ bidzi nɛ awĩ a bɛlɛ kɔtɔ a kĩ bɛkɔ yĩ nɛ lɔkɔ a kĩ Yudafɔ ɔmaĩ fɔlɛtsa badzɛnɛ a dzɛmɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mbɔɛ ntɛ kalɛ mɔa a kĩ ndzɛla ɔlɛdo nlɛ kĩ, ‘Miadzɛmɔ yĩ nviã kĩĩ kitonɛkĩ ntɛ banɔkpa kayidza kadzi nkpã a ndo.’ ” ");
INSERT INTO bov_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ade Felike, oti kĩ enyina katɛkado osi vɔɛ̃ kĩĩ paa a bi Yudafɔ a kĩ, “Midzɔlɛ yĩ kɛnaawo lɔkɔ a kĩ Lisia aaya fɔmɔ maatsua fɔlɛtsa kĩĩ kamɛ.” ");
INSERT INTO bov_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Adeke ɛfɔ̃ bɛkɔa Paulo bɛnado nɛ kɔla a. Lɛmɛ ebi bikĩ badãmɛna ye akũ a kĩ bɛtakɛna ye tɛnya. Ntɛ ye bakɔba badi ya nɛ ye sɛkɛ̃ ni, bɛkpa be osi lɔkɔa bɛkɛna lɛtsa a kĩ yawɛ a bɛkpa ye. ");
INSERT INTO bov_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nɛ fuwi fudi liti ni, Felike mɔ ɔtsɔ̃ Drusila kĩ ɛnyɛ Yudani ya. Ɛfɔ̃ bɛnyɛ Paulo bɛyamɛna ade ebi be kalɛ nɛ Yesu Kristo katɛkado fɔlɛtsa akũ a. ");
INSERT INTO bov_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kĩ ɛkanyɛ fɔlɛtsa kamɛ nɛ kadzi wĩ, akũ kapi, mɔ Baguma kadzɛ a kĩ kaaya nɛ kunya kamɛ a akũ ni, libe wo Felike paa. Adeke Felike bi ye kĩ, “Yidza kanaa tɔ̃. Ntɛ nna lɔkɔ wĩ ni, maafɔ̃ bɛvɛ nɔ.” ");
INSERT INTO bov_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nɛ kĩ ɛkɔna kĩ Paulo aakpa ye litsedi sũ ni, yado bavɛ ye mɔatsɛ mɔatsɛ bɛmɔ ye balɔmɛna. ");
INSERT INTO bov_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nɛ futeli nviã liti a, bɛnyɛ Felike ade bɛkɔa Porkio Festo bɛyamɛna nɛ ye kadzakɔ̃ a. Lɛmɛ kĩ Felike wɛ kĩ Yudafɔ a bɛwɛ ye kalɛ sũ ni, ɛfɔ̃ Paulo buki ɛna nɛ kɔla nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Kĩ Festo yawo kayite a kĩ yanya lɔnɔkɔɛ̃ a, ke fuwi ɛlalɛ liti a, eto Kaisarea ɛnaa Yerusalem. ");
INSERT INTO bov_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nɛ awã naa, basɔfɔnɔkɔɛ̃ a mɔ Yudafɔ banɔkɔɛ̃ a yabi ye fɔlɛtsa a kĩ bɛbɔɛ nɛ Paulo akũ. Ade ke bike ye aduli kĩ, ");
INSERT INTO bov_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ɛmɔ be kɔnya ɛfɔ̃ bɛkɔa ye bɛyamɛna nɛ Yerusalem. Be kasui nyɛ kĩ baadzi ye osi lɔkɔa ntɛ yatɛ̃ a bɛkɔ ye. ");
INSERT INTO bov_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lɛmɛ Festo bi be kĩ, “Paulo waa kɔla nɛ Kaisare. Yĩ malo maamuniki naa awã nɛ fuwi lukũ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Foesũ mifɔ̃ mi banɔkɔɛ̃ a bɛya nɛ awã bɛyaanyɛ ye nfumusu a bɛtsa.” ");
INSERT INTO bov_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nɛ fuwi ɛlɛ̃ ĩye foe ewua liti ni, Festo muniki ɛnaa Kaisare, ade ke luwi lɛyade a ɛvɛ Paulo fɔlɛtsa a. ");
INSERT INTO bov_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ade ke kĩ Paulo yawo fɔlɛtsa kadzɛkɔ̃ a, Yudafɔ a kĩ bito Yerusalem a yadza bisinya ye. Bitsua fɔlɛtsa pii bite nɛ ye akũ lɛmɛ fudima tápi ye. ");
INSERT INTO bov_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo nyɛ onukpɛ̃ ɛlɛ kĩ, “Ntáfum Yudafɔ mbla ĩye Yudafɔ Asɔli Kɔla a ĩye Lɛgãnɔkɔɛ̃ Kaisare.” ");
INSERT INTO bov_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nɛ kĩ Festo awɛ kĩ Yudafɔ a bɛwɛ ye kalɛ sũ ni, evia Paulo kĩ, “Ɔwɛ kĩ anaa Yerusalem lɔkɔa ndzɛ nɔ fɔlɛtsa a nɛ awã mbɔɛɛ?” ");
INSERT INTO bov_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ade ke Paulo bi ye kĩ, “Oowo. Romafɔ Lɛgãnɔkɔɛ̃ fɔlɛtsa kadzɛkɔ̃ ndzɛ̃. Ade awĩ kɛfɛta kĩ bɛdzɛmɔ yĩ a. Onyina yededeede kĩ ntákɛna tɔkpa tidima nɛ Yudafɔ akũ. ");
INSERT INTO bov_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ntɛ nkɛna lɛtsa a kĩ kɛnɛ kĩ bɛkɔ yĩ ni, maatunɔ kĩ bɛkɔ yĩ. Lɛmɛ ntɛ ntákɛna tɔkpa ni, kɛtáfɛta kĩ nɔ ĩye oti bɛbã akɔa yĩ edo nɛ bati kĩĩ awɛ kamɛ kĩ bɛkɔ yĩ. Nɛ foesũ nkɔa yĩ fɔlɛtsa makpa Lɛgãnɔkɔɛ̃ Kaisare!” ");
INSERT INTO bov_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fukĩĩ liti a, Festo mɔ ye fɔlɛtsa badzɛnɛ a tsa fɔlɔ ade bibi ye kĩ, “Kĩ ɔkɔa nɔ fɔlɛtsa akpa Kaisare sũ ni, Kaisare sɛkɛ̃ mɔ aanaa.” ");
INSERT INTO bov_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Fuwi fudi liti a, Lɛgã Agripa mɔ Bernike ya nɛ Festo sɛkɛ̃ nɛ Kaisare kĩ bɛyaawɔ̃na ye. ");
INSERT INTO bov_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bidzi nɛ awã fuwi pii, ade Festo kɔa Paulo fɔlɛtsa a ebi lɛgã a kĩ, “Onyole odi waa kɔla nɛ awĩ kĩ Felike kɔa ye fɔlɛtsa ɛkpa yĩ kĩ ndzɛ. ");
INSERT INTO bov_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kĩ nnaa Yerusalem a, basɔfɔnɔkɔɛ̃ mɔ be banɔkɔɛ̃ a tsua ye onukpɛ̃ bɛkpa yĩ ade bɛwɛ kĩ nkɔ ye kɔtɔ a. ");
INSERT INTO bov_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Nfɔ̃ binyi kĩ Romafɔ mbla tákpa osi kĩ bɛkɔ oti fɔmɔ baadzɛmɔ ye. Kɛnɛ kĩ bɛkpa ye osi bɛmɔ bikĩ bideĩ fɔlɛtsa a bɛkpɔta anɛ mɔ anɛ fɔmɔ bɛlɛ foe. ");
INSERT INTO bov_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Foesũ kĩ bɛya nɛ awĩ a, ntátɛ̃ ndzi nɛ kalɛ kĩĩ akũ. Kĩ kade sila kinyina a, nfɔ̃ bɛkpã oti kĩĩ bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Lɛmɛ fɔlɛtsa a kĩ bɛlɛ bitomɛna ye akũ a vɛmɛna nɛ fukĩ nkɔna kĩ baalɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Fɔlɛtsa a kĩ bɛlɛ nɛ awĩ a to be kasum mɔ onyole odi kĩ bavɛ Yesu kĩ eku, lɛmɛ Paulo kɔ̃ tsɛ̃ yalɛ kĩ ebuki edzi nkpã akũ! ");
INSERT INTO bov_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Fɔkɛna yĩ basaa ade ĩnyína ayekĩ matsua fɔlɛtsa a kamɛ a. Foesũ nvia Paulo ntɛ ɛwɛ kĩ nkɔa ye nnamɛna Yerusalem lɔkɔa ɛnaanyɛ ye akũ onukpɛ̃ nɛ awã. ");
INSERT INTO bov_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lɛmɛ Paulo lɛ kĩ ɛwɛ kĩ bɛkɔa ye fɔlɛtsa bɛkpa Lɛgãnɔkɔɛ̃ Kaisare. Ade nfɔ̃ bimunikimɔ ye bɛnado nɛ kɔla kɛnawo kĩ maakɔa ye mma Kaisare a.” ");
INSERT INTO bov_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ade ke Lɛgã Agripa bi Festo kĩ “Yĩ mɔawɛ mawɛ kĩ matse ye onukpɛ̃ kamɛ fɔlɛtsa a.” Ade Festo bi ye kĩ, “Aatse ye kunya!” ");
INSERT INTO bov_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kĩ kade nyina a, Lɛgã Agripa mɔ Bernike hɛhɛ akũ mɔ fɔgãtsa, bɛnɛ bɛya nɛ fɔlɛtsa kadzɛkɔ̃ a. Ade kawũ banɔnɛ banɔkɔɛ̃ mɔ ɔmatɔ a kamɛ banɔkɔɛ̃ a tomɔ be bɛya a. Festo nyɛ onukpɛ̃ kĩ bɛkpã Paulo bɛyamɛna. ");
INSERT INTO bov_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ade Festo lɛ kĩ, “Lɛgã Agripa mɔ mi a flee kĩ mikpɔta nɛ awĩ a, onyole kĩĩ nyɛ oti kĩ Yudafɔ nɛ Yerusalem mɔ Kaisare wɛ kĩ bɛkɔ! ");
INSERT INTO bov_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lɛmɛ nɛ yĩ kamɔ kamɛ ni, ɛtákɛna lɛtsa a kĩ kɛnɛ kĩ bɛkɔ ye. Kĩ ye a lɛmɛ ɛlɛ kĩ ɛkɔa ye fɔlɛtsa yakpa boe Lɛgãnɔkɔɛ̃ sũ ni, yĩ malo ntásĩ. ");
INSERT INTO bov_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lɛmɛ litsa koũ maatsɛlɛ nkɔa mmɛna yĩ ɔnɔkɔɛ̃ a? Kitonɛkĩ nɛ ɔnɔkɔali kamɛ ni, ɛtákɛna nfumusu adima. Ade foesũ nkɔa ye ĩyamɛna nɛ mi anɛ kamɛ titiliwu nɔ Lɛgã Agripa kĩ ntɛ bɔdzɛ ye fɔlɛtsa ni lɔkɔa maana kadi ntsɛlɛ nɛ ye akũ mma ye. ");
INSERT INTO bov_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kitonɛkĩ fɔnɛ́nɛ kĩ bakɔa odi kĩ ɛwaa kɔla bɛma Lɛgãnɔkɔɛ̃ kĩ bɛtámɔ tɔkpa a kĩ ɛkɛna a bɛtsa.” ");
INSERT INTO bov_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ade ke Agripa bi Paulo kĩ, “Osi waa kĩ apuli ɔlɛ kɔdzɛla.” Foesũ Paulo dɛla awɛ ade ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Boe Ɔlate Agripa, nna lɔlɔ wĩ kĩ maanyɛ yĩ akũ onukpɛ̃ nɛ fɔlɛtsa a kĩ foesũ Yudafɔ bɔɛ kalɛ nɛ yĩ akũ a akũ, nɛ nɔ anɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kitonɛkĩ onyina Yudafɔ tɛdzɛ mɔ be tɛmaniɛ a flee kanyina wĩ. Foesũ na ɔwɔlɛ katse yĩ fɔlɛtsa. ");
INSERT INTO bov_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yudafɔ flee nyina ayekĩ ndzi nkpã kito yĩ tibisɛ̃ kamɛ nɛ boe ɔtɔ mɔ Yerusalem lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ade ntɛ baalɛ ɔnɔkɔali nɛ yĩ akũ ni, baanyi kĩ ĩnyɛ Farisini kĩ mabu Yudafɔ mbla mɔ tɛmaniɛ a flee kaba mbla adi nyɛ adi. ");
INSERT INTO bov_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Finyaakĩĩ ndzɛ̃ badzɛmɔ yĩ nɛ ayekĩ yĩ anɛ teĩ nɛ Baguma kalɛ a kĩ ɛlɛ eyi ɛkpa boe bawanyɔ a sũ. ");
INSERT INTO bov_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ade foesũ Yudafɔ futete ewua-nviã bɔa mbɔdi kĩ basum Baguma lɛnyɛ mɔ suwa flee lɔkɔa bɛna kɔnɛte kĩĩ odu a. Boe Ɔlate, ade fukĩĩ sũ Yudafɔ a bɔɛ fɔlɛtsa nɛ yĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nde sũ fudeĩ mi ɔsĩ kĩ miatɛ mido kĩ Baguma adzɛla banɔkpa? ");
INSERT INTO bov_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Lɔkɔ lidi kamɛ ni, nkɔa nte nɛ yĩ akũ kĩ mayidza ndza nɛ bikĩ bitomɔ Yesu kĩ ɛnyɛ Nazaretni a akũ. ");
INSERT INTO bov_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yudafɔ basɔfɔnɔkɔɛ̃ a kpa yĩ kɔbɛ̃ kĩ mpili bati kpalɛwa pii ndo nɛ kɔla kamɛ nɛ Yerusalem. Ade ke ntɛ bakɔ be lɛmɛ matunɔ nɛ foe akũ a. ");
INSERT INTO bov_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ntomɔ be nkakɛna be tɛnya flee kɛnawo tɛmatɔ bɛbã kĩ tideĩ mɔ lugo a malo kamɛ. Nfɔ̃ bɛvɛlɛ be sɔtɔ nɛ Yudafɔ fɔlɛtsa kadzɛkɔ̃ flee, ndza nɛ be akũ kĩ bɛlɛ fubusuotsa nɛ Yesu akũ. ");
INSERT INTO bov_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ade kakɔna kĩĩ odu nnɛɛ manaa Damasko, mɔ kɔbɛ̃ a kĩ basɔfɔnɔkɔɛ̃ a kpa yĩ a. ");
INSERT INTO bov_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Boe Ɔlate, kĩ ntsɛ̃ nɛ osi manaa mɔ suwa ketee a, mmɔ́ ɔhaĩ odi kĩ ɛkpalɛ ɛba suwa, kĩ ɛmɔanɛ eto ode ɛyako nɛ bɔmɔ́ bikĩ bɔtsɛ̃ bɔanaa akũ. ");
INSERT INTO bov_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kĩ boe flee bɔka bɔtɔ a, nnu ɔlɛdo odi nɛ Yudafɔ tide kamɛ evia kĩ, ‘Saulo, Saulo nde sũ otomɔ yĩ liti? Ntɛ ɔta fu sɛnɛta ni, nɔ mɔawɛ akũ opila.’ ");
INSERT INTO bov_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ade ke nvia ye kĩ, ‘Boe Ɔlate, nɔ owei anɛ?’ “Ɔlɛdo a kpa mbuayɛ kĩ, ‘Yĩ nyɛ Yesu a kĩ ɔlamɛna ye kanɔ mɔ ɔsĩ mɔ ɔsĩ a. ");
INSERT INTO bov_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Finyaakĩĩ yidza kadza! Ĩnyɛ yĩ akũ ntsa nɔ kitonɛkĩ mawɛ kĩ nkɔa nɔ nkɛna yĩ tudzuma ɔkɛnanɛ. Aabi katinya kamɛ bati flee lɛtsa kĩ ɔmɔ́ nɛ awĩ, mɔ fɔtsa a kĩ maanyɛ ntsa nɔ a. ");
INSERT INTO bov_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ade kakɔ nyɛ kakɔ kĩ maado nɔ ni, maadza nɛ nɔ liti nɛ nɔ awɛ bati mɔ kade bɛbã bati lɛmɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ade aabinya be anɛ bɛnɛ nɛ Abonsam ɔtũ kɔbɛ̃ kamɛ bɛya nɛ ɔhaĩ mɔ Baguma kɔbɛ̃ kamɛ a. Baguma aakɔa be titikpa ete be lɔkɔa ɛkɛna be ndɛ bati kĩ ɛnyɛ ɛkpa ye akũ, nɛ kĩ bɛtɛ ye bido sũ.’ ");
INSERT INTO bov_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Foesũ, boe Ɔlate Agripa, ntátu kanyɛ katsa a kĩ mmɔ́ ntomɛna ode a atsɛlɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ĩyi kayɔ mɔ kalɛ wĩ a kabi Damaskofɔ, Yerusalemfɔ, Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ a kĩ bɛdani tɔwɔlɛ kamɛ bɛya nɛ Baguma sɛkɛ̃, lɔkɔa bɛkaakɛna fɔtsa a kĩ foe aatsa kĩ bɛdani tɔwɔlɛ kamɛ yededeede a. ");
INSERT INTO bov_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ade fukĩĩ sũ Yudafɔ a yapi yĩ nɛ be Asɔli Kɔla a kamɛ kĩ ndza nkalɛ fɔlɛtsa kĩĩ, ade ke bɛwɛ kĩ bakɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lɛmɛ Baguma nyɛ yĩ nɛ be awɛ kamɛ. Foesũ mbuki ndzi nkpã ade nlamɛna fɔlɛtsa kĩĩ kamɛ kanyɛ katsa mi banɔkɔɛ̃ mɔ bati flee a. Lɛtsa a kĩ de nlamɛna kalɛ nɛ awĩ a nyɛ fukĩ Baguma onukpɛ̃ banyɛnɛ mɔ Mose lɛ biyi kĩ fɔ́aya nɛ foe kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ade foe nyɛ kĩ Kristo aayamɔ lubo. Ade ye aanya oti ɔtɔnyade kĩ yaayidza eto banɔkpa kamɛ, lɔkɔa ɛkɔa ɔsɛdza ɛma Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ a flee a.” ");
INSERT INTO bov_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Deedimɔapɛ Festo bɔa fɔwɔla ɛlɛ kĩ, “Paulo, nɔ lɔlɔ kamɛ bu kade! Nɔ fɔtsa beblebee kakɔlɛ fɔ̃ nɔ lɔlɔ kamɛ bu kade!” ");
INSERT INTO bov_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ade Paulo kpa mbuayɛ kĩ, “Boe Ɔlate Festo, yĩ lɔlɔ kamɛ tábu kade. Takɔa fɔlɛtsa kĩĩ ɔkɛna kagulo. Kalɛ wĩ paa nlamɛna kalɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ɔnɔkɔali ni, Lɛgã Agripa nyina fɔlɛtsa kĩ malɛ a. Foesũ maapuli nlɛ kɔdzɛla mɔ ye faa. Matɛ kado paa kĩ bɛtákɛna fɔtsa kĩĩ nɛ kabɛla kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nda Agripa, ɔtɛ Baguma onukpɛ̃ banyɛnɛ a odo? Ĩnyina kĩ ɔtɛ be odo.” ");
INSERT INTO bov_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ade Agripa bi Paulo kĩ, “Ɔkɔna kĩ aapuli ɔdani yĩ nkɛna okristoni nɛ lɔkɔ lukũ kĩĩ kamɛ?” ");
INSERT INTO bov_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ade ke Paulo kpaa mbuayɛ kĩ, “Ntɛ lɔkɔ lukũ ĩye lɔkɔ gɛlɛɛlɛ malo ni, mabɔa mpaɛ nkpa Baguma kĩ, nviã kĩĩ mi a flee kĩ mideĩ nɛ awĩ a, midani mikɛna ndɛ ayekĩ nla. Lɛmɛ bɛtádo mi nkɔsɔnkɔsɔ ndɛ yĩ aye!” ");
INSERT INTO bov_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ade lɛgã, abãã ɔnɔkɔɛ̃ mɔ Bernike mɔ bati a flee yidza a. ");
INSERT INTO bov_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kĩ biyidza a, bɛnaa adzina ade bibi be akũ kĩ, “Oti kĩĩ tákɛna lɛtsa kpa lidima kĩ bakɔ ye ĩye bido ye nɛ kɔla.” ");
INSERT INTO bov_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ade Agripa bi Festo kĩ, “Ntɛ obi kĩĩ ɛtalɛ kĩ ɛkɔa ye fɔlɛtsa yama Lɛgãnɔkɔɛ̃ ni, kufɛ bɔ́apuli bɔfɔnɛ ye awɛ.” ");
INSERT INTO bov_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kĩ bike otse kĩ bɔanaa Italia a, bɛkɔa Paulo mɔ kɔla bawanɛ bɛbã bido nɛ Romafɔ sodzafɔ ɔnɔkɔɛ̃ kĩ bavɛ Yulio awɛ kamɛ. Ade ye adãmɛna sodzafɔ katsu a kĩ bavɛ Lɛgãnɔkɔɛ̃ Sodzafɔ Katsu akũ a. ");
INSERT INTO bov_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ade ke budzi ɔkɔlɔ kĩ eto Adramitio yanaa tɔkɔlɔ fɔdzakɔ̃ nɛ Asia kamɛ a. Bɔmɔ Makedoniani kĩ bavɛ Aristarko lidzi nɛ ɔkɔlɔ a kamɛ. Eto Tesalonika. ");
INSERT INTO bov_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kĩ kade nyina a, bɔnadza nɛ Sidon mpo abuĩ. Ade Yulio kpa Paulo osi kĩ ɛnaa ɔmatɔ kamɛ ɛnaamɔ ye bakɔba, lɔkɔa bɛkpa ye fɔtsa a kĩ yaakɔa ɛtsã osi a. ");
INSERT INTO bov_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kĩ bɔbɔɛ nɛ awã a nɛ kĩ ɔwɛ kabɔa katsɛlamɔ boe a onukpɛ̃ deĩ ɔsi sũ ni, bɔtsã Kipro kayɔ sɛmakɛ bɔbɛla ɔwɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kĩ bɔtɛ̃ awã a, bɔtsã Kilikia mɔ Pamfilia mpo abuĩ, ade bɔnadza nɛ Mira nɛ Likia a. ");
INSERT INTO bov_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Awĩ a sodzafɔ ɔnɔkɔɛ̃ a kĩ yakpã boe a mɔ́ ɔkɔlɔ odi kĩ eto Aleksandria yanaa Italia tite akũ, ade ke ɛkɔa boe flee edo nɛ ye kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Osi a katsã kamɛ na boe ɔsĩ nɛ fuwi pii kamɛ fɔmɔ bupuli buwo Knido ɔmatɔ a kamɛ. Kĩ ɔwɛ mɔ ɔsĩ kabɔa sũ ni, bɔtápuli bɔtɛ̃ bɔnaa kpĩĩ. Foesũ kĩ buwo Salmone a, bɔblɛ bɔtsã Kreta ɔmatɔ a ɔlɔtɔ, awã kĩ tite a sua ɔwɛ a kɔbɛ̃ onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ɔsĩ kamɛ bɔkɔa bɔtsã mpo abuĩ a bɔnawo kakɔ a kĩ bavɛ Tɔkɔlɔ Kadzakɔ̃ Wĩ a. Awã mɔ Lasea kayite lɛlá lugo. ");
INSERT INTO bov_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bubula fuwi kade, ade kĩ mui akũ katsã lɛmɛ na ɔsĩ sũ ni, Onukpɛ̃ Kasui Lɔkɔ a tɛ̃. Nɛ fukĩĩ sũ Paulo kpa be kakɔna ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Nda amɛ, mmɔ́ ĩyi ɔsũ kĩ boe mui anɛ osi katsã aawo nɛ mbɛtahu kamɛ, kĩ fɔtsa pii mɔ bati malo aawɔ.” ");
INSERT INTO bov_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lɛmɛ kawũ banɔnɛ ɔnɔkɔɛ̃ kĩĩ tɛ ɔkɔlɔ ɔtanɛ mɔ ye ɔlate a kakɔna ɛba lɛtsa kĩ Paulo lɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nɛ kĩ tɔkɔlɔ kadzakɔ̃ a lɛnɛ́nɛ kadzi gɛlɛɛlɛ nɛ osili lɔkɔ sũ ni, osi batsãnɛ a wɛ kĩ bɛdzakũ ɔsa baawo Foenike. Baapuli bidzi nɛ awã nɛ osili lɔkɔ, kitonɛkĩ Foenike nyɛ ɔmatɔ nɛ Kreta tite akũ. Edeĩ tɔkɔlɔ fɔdzakɔ̃ kĩ futsua ɔwɛ onukpɛ̃ nɛ suwa katomukɔ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kĩ ɔwɛ bɔɛɛ do kabɔa kademɛna awɛ a, fɔkɛna ndɛ fɔ́alɛ fɔkpa osi a akũ kanaa. Foesũ bɛmanɛ akũ ade bɛtsã Kreta mpo abuĩ a. ");
INSERT INTO bov_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lɛmɛ owi tábuna mɔ ɔwɛ mɔ ɔsĩ odi vũ eto Kreta sɛba sɛmakɛ. ");
INSERT INTO bov_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ɛvũ ɛtsɛlamɔ ɔkɔlɔ a lɔtɔ foesũ bɛtápuli bɛdani ɔkɔlɔ a anɛ bɛtsɛlamɔ mpo abuĩ. Nɛ foesũ bɛfɔnɛ ɔkɔlɔ a awɛ ade ɔwɛ a bɔa ye ɛkanamɛna a. ");
INSERT INTO bov_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ke liti kɔlaa, bɔyana kablakɔ̃ kadi nɛ Kauda tite kĩ mui tsua bisinya te liti. Kɔbɛ̃ kamɛ fɔmɔ bupuli busuli boe ɔkɔlɔ kabii a budo nɛ ɔkpale a kĩ ye kamɛ bɔna a kamɛ. ");
INSERT INTO bov_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kĩ bɛmanɛ ye biyua a, bɔkɔa tɔwɛ̃ bisuli bɔtɛ̃mɛna bupimɔ ɔkɔlɔ kpale a kitonɛkĩ bivila kĩ ɔwɛ aabɔa ye ɛnaabãã nɛ dã kamɛ nɛ Libia mpo abuĩ. Foesũ bɛkɛna tilima nɛ ɔkɔlɔ titse a akũ. Nɛ fukĩĩ sũ ɔwɛ a kabɔa ye kanamɛna bɔɛɛ. ");
INSERT INTO bov_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kade nyina, lɛmɛ kĩ ɔwɛ a táfɔ̃ kavũ sũ ni, bido fɔtsa a kĩ ɔkɔlɔ a nɔnɛ a kanyɛ kawula nɛ mui kamɛ awɛ. ");
INSERT INTO bov_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ade nɛ luwi lɛlalɛde a, bɛyatalɛ ɔkɔlɔ a akũ fɔtsa pii lɛmɛ biwula. ");
INSERT INTO bov_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ɔwɛ mɔ ɔsĩ kĩĩ vũ fuwi beblebee kĩ bɛtámɔ suwa ĩye fusibii malo. Ade bɔtátɛ budo kĩ bɔ́ana nkpã a. ");
INSERT INTO bov_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kĩ bidzi fuwi beblebee kĩ bɛtánya sũ ni, Paulo yidza ɛdza nɛ be anɛ kamɛ, ade ebi be kĩ, “Nwaɛ̃ amɛ, ntɛ mitse yĩ kalɛ ni, kufɛ bɔtábɔɛ nɛ Kreta, kufɛ fɔtsa kĩĩ bamɛ flee taya nɛ boe akũ, bɔyɛla boe akũ fɔtsa. ");
INSERT INTO bov_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Finyaakĩĩ, make mi aduli kĩ mina ɔwɔlɛ. Ade mabi mi yededeede kĩ ɔkɔlɔ kĩĩ aayɛla lɛmɛ mi kamɛ odima lɛláaku. ");
INSERT INTO bov_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kitonɛkĩ kadzɔ lɛnyɛ ni, Baguma a kĩ ye ode manɛ, mɔ ekĩ masum a, ye ode fɔtɔ ɔnyanɛ yadza nɛ yĩ ɔwɛ̃. ");
INSERT INTO bov_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ade ke ebi yĩ kĩ, ‘Paulo, tavila. Kɛnɛ kĩ akɔa nɔ kalɛ oyi nɛ Kaisare anɛ kamɛ! Nɛ Baguma kɔnyakamɔ sũ ni, nɔ mɔ bikĩ bɛtsɛ̃ osi a flee kamɛ odima lɛláaku.’ ");
INSERT INTO bov_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Foesũ, nwaɛ̃ amɛ, mina ɔwɔlɛ! Ntɛ Baguma ndo kĩ lɛtsa nyɛ lɛtsa aaya nɛ foe kamɛ ndɛ ayekĩ ɛlɛ eyi a. ");
INSERT INTO bov_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lɛmɛ ɔwɛ aabɔa boe ɛnamɛna tite tidi kĩ mui tsua bisinya te a akũ.” ");
INSERT INTO bov_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ade ke ɔwɛ mɔ ɔsĩ kĩĩ kabɔa boe kanamɛna lɔtɔ mɔ liti fuwi ewuana flee nɛ Adria mpo akũ a. Luwi luwuanade lɛnyɛ a, boe ɔkɔlɔ kamɛ adzuma bakɛnanɛ a kɔna kĩ bifuã tite tidi. ");
INSERT INTO bov_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Awã na bɛkɔna mui a kadzũ bɛdã, ade bɛmɔ́ kĩ foe kadzũ aana ndɛ fɔnɛta ɔha mɔ foe tɛya. Ade kĩ bɛnaa lɔtɔ sukuloo a, bibuki bɛkɔna ade bɛmɔ́ kĩ mui a a kadzũ nyɛ fɔnɛta aduekrɔũ a. ");
INSERT INTO bov_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nɛ kĩ bivila kĩ ɔwɛ a aabɔa ɔkɔlɔ a ɛnaasãmɔ boe kpale kpale sũ ni, bɛkɔa fɔbɔtsaɛ mɔ ɔlɔmɛ ɛna kĩ bido ɔwɛ̃ bipimɔ ɔkɔlɔ a nɛ liti bido nɛ mui a kamɛ. Fɔbɔtsaɛ a nabãã nɛ mui ɔda fɔfɔ̃ ɔkɔlɔ a dza. Ade ke bɛkadã anɛ kĩ kade wĩ kinyina a. ");
INSERT INTO bov_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kĩ ɔkɔlɔ a kamɛ adzuma bakɛnanɛ wɛ kĩ balo sũ ni, bɛkɛna ɔkɔlɔ kabii a, nɛ tɛdake kamɛ kĩ banaakɛna fɔbɔtsaɛ mɔ ɔlɔmɛ a nɛ ɔkɔlɔ kpale a lɔtɔ. ");
INSERT INTO bov_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lɛmɛ Paulo bi sodzafɔ a mɔ be lɔtɔ ɔnyanɛ a kĩ, “Ntɛ bati kĩĩ flee tána nɛ ɔkɔlɔ kĩĩ kamɛ kɔ̃ ni, míaku.” ");
INSERT INTO bov_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Foesũ sodzafɔ a tsua ɔwɛ̃ a kĩ epini ɔkɔlɔ kabii a, ade ɛka ewo nɛ mui a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Odenyinawi a, Paulo ke be flee aduli kĩ bɛnya. Ebi be kĩ, “Ade nviã nyɛ fuwi ewuana kĩ mi kamɛ odima táta lɛtsama onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nɛ foesũ, make mi aduli, minya litsedi lɔkɔa mina kɔbɛ̃ ayekĩ miláaku. Kitonɛkĩ odima sɔlɔ mɔapɛ malo lɛláakamu.” ");
INSERT INTO bov_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ade ke Paulo bɔɛ abodoo adi, ade kĩ ɛbɔa mpaɛ ɛkpa Baguma nɛ be flee anɛ a, ebuli adi ɛba. ");
INSERT INTO bov_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ade ke ɔwɔlɛ ka edzi odi nyɛ odi bido kanya awɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bati a kĩ bɛna nɛ ɔkɔlɔ a kamɛ lidede nyɛ ɔha nviã mɔ be aduesɔũ-evũ (276). ");
INSERT INTO bov_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kĩ bati a nya biwĩ a, bɛnyɛ funitsã mɔ fuvũ a flee nɛ ɔkɔlɔ a kamɛ biko nɛ mui kamɛ ade ɔkɔlɔ a nɛ́ ɔlɔmɛ a. ");
INSERT INTO bov_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kĩ fɔkɔ kpalɛ a, ɔkɔlɔ batanɛ a támɔ awã mpo abuĩ a biyi ɔsũ. Lɛmɛ bɛmɔ́ kadzakɔ̃ kadi kĩ bɛkɔna kĩ awã aalɛ bɛdza. Foesũ bɛwɛ kĩ ntɛ fɔ́alɛ ni bata ɔkɔlɔ a bɛnamɛna awã. ");
INSERT INTO bov_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Foesũ bikpeli fɔbɔtsaɛ mɔ ɔlɔmɛ kĩ fupini ɔkɔlɔ a tɔwɛ̃ bido nɛ mui kamɛ, ade biwũnya otse a kĩ ye atsa ɔkɔlɔ a osi a. Ke liti bɛdzɛla ɔkɔlɔ a tilima ayekĩ ɔwɛ aabɔa ye ɛnamɛna. ");
INSERT INTO bov_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kĩ bɛyɛlɛ banaa a, ɔkɔlɔ a nabãã nɛ dã kamɛ ade ye anɛ sɛmakɛ tábuki epuli ekuna akũ a. Ɔwɛ mɔ ɔsĩ a lɛmɛ yabo ye nɛ liti sɛmakɛ a ɛyɛlɛ ye fɔkɛ fɔkɛ. ");
INSERT INTO bov_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sodzafɔ a ke otse kĩ bakɔ kɔla bawanɛ a flee ayekĩ bɛláato mui bilo. ");
INSERT INTO bov_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lɛmɛ be lɔtɔ ɔnyanɛ wɛ kĩ yatɛ Paulo nkpã, foesũ ɛtátunɔ bɛkɛna nɛ be kawɛ akũ. Ade ɛkpa kɔbɛ̃ kĩ ntɛ bikĩ baapuli bito mui ni, bɛnya lɔtɔ bɛvɛnya biwo bito mui bɛnaa mpo abuĩ. ");
INSERT INTO bov_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bati a kĩ bite a lɛmɛ bɛbɔɛ titse fɔkɛ mɔ fɔtsa bɛbã kĩ fɔ́apuli fɔtsãmɔ be nɛ mui anɛ lɔkɔa biwo ɔwɔ abuĩ. Ade aye bɔkɛna buwo ɔwɔ abuĩ sɔũ a. ");
INSERT INTO bov_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ade kĩ bɔnɛ nɛ mbɛtahu kamɛ a, bɔyamɔ kĩ tite a kĩ mui tsua bisinya te a bavɛ Malta. ");
INSERT INTO bov_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bati nɛ tite kĩĩ akũ a tɛ boe mɔ kawɔlɛ paa a. Nɛ kĩ oni kako osili lɛmɛ na sũ ni, bɛkpɔta fi kpale nɛ mpo abuĩ a bɛkpa boe. ");
INSERT INTO bov_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kĩ Paulo fila tuvotsei kĩ yako nɛ fi kamɛ a, nɛ fi a ɔwɛ ɔbɔ̃ sũ kɔɛ kudi nɛ nɛ avo a kamɛ kɔyadɔ̃ ye kɔvanɛ nɛ ye kɔkpɔ. ");
INSERT INTO bov_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kĩ awã bati a mɔ kɔɛ a kĩ kɔvanɛ nɛ ye kɔkpɔ a, bibi akũ kĩ, “Owudini oti kĩĩ anɛ. Ade foesũ boe baviɔ̃ lɛláafɔ̃ edzi nkpã a, titɔ kĩ elo nɛ wuda awɛ kamɛ nɛ mpo kamɛ malo.” ");
INSERT INTO bov_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ade Paulo wunya kɔɛ a edo nɛ fi a kamɛ a, lɛmɛ lɛtsama tákɛna ye. ");
INSERT INTO bov_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ade bati a dza bɛkadã anɛ kĩ yaawumi ĩye yaaka ɛtɔ deedimɔapɛ eku. Owi buna kĩ bɛdza bɛkadã, ade kĩ lɛtsama tákɛna ye a, bɛdani be adzuni nɛ ye akũ, ade bɛlɛ kĩ, baguma adi yanɛ. ");
INSERT INTO bov_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Awã kĩ bɔnadza a, fuãmɔ Publio kĩ ɛnyɛ tite a lɛgã. Ɔnɔkɔɛ̃ kĩĩ lɛmɛ tɛ boe mɔ kawɔlɛ ade ɛdã boe akũ fuwi ɛlalɛ flee a. ");
INSERT INTO bov_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nɛ fuwi kĩĩ kamɛ ni, Publio ɔlɛga kasɔ atilili, ade ɛkayo kɔbɔa mɔatsɛ mɔatsɛ a. Paulo naa ye sɛkɛ̃, ɛnabɔa mpaɛ ete awɛ nɛ ye akũ, ade ɛsaɛ a. ");
INSERT INTO bov_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kĩ binu fɔsɔ katsa kĩĩ a, basɔnɛ nɛ tite akũ flee nɛ bɛya, ade Paulo tsa be a. ");
INSERT INTO bov_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nɛ lɛkɛnana kĩĩ sũ bɛkpa boe fɔtsa pii. Ade kĩ boe kadzakũ wo ɔtɔ a, bɛma boe fɔtsa a kĩ bɔ́akɔa bɔtsã osi. ");
INSERT INTO bov_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bɔtɛ tidetɔ ɛlalɛ nɛ awã fɔmɔ bɔdzakũ. Kĩ bɔadzakũ a budzi ɔkɔlɔ kĩ bavɛ Nta Baviɔ̃ kĩ eto Aleksandria ɛyadza nɛ kasekɔ̃ a nɛ osili lɔkɔ. ");
INSERT INTO bov_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kĩ bɔbɔɛ buto awã a, bɔnaa Sirakuse ɔmatɔ a, ade bɔna nɛ awã fuwi ɛlalɛ a. ");
INSERT INTO bov_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ade ke luwi lɛyade buto awã bunyina bɔnaa Regio a. Ɔwɛ wĩ odi bɔa boe nɛ liti, ade bɔyawo Puteoli a. ");
INSERT INTO bov_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Awã naa, bɔmɔ́ batɛ badonɛ badi, ade bike boe aduli kĩ budzi nɛ be sɛkɛ̃ ɛkwansieda mɔa. Nɛ ke liti a, buto awã bɔnaa Roma. ");
INSERT INTO bov_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kĩ boe bawaɛ̃ a kĩ bideĩ nɛ Roma nu kĩ bɔaya a, bɛyatsɛlamɔ boe nɛ awã kĩ bavɛ Apia Kɔyaatɔ a. Badi lɛmɛ yatsɛlamɔ boe nɛ Fusekɔ̃ Ɛlalɛ a. Kĩ Paulo mɔ́ be a, ɛnyɛ Baguma kɔlɛ ade ke ebuki ɛna ɔwɔlɛ kado a. ");
INSERT INTO bov_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kĩ buwo Roma a, bɛkpa Paulo osi kĩ edzi ye akũ akũ nɛ awã kĩ ɛwɛ a, lɛmɛ bɛfɔ̃ sodzafɔ a kamɛ ɔmɔa kadãmɛna ye akũ. ");
INSERT INTO bov_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Fuwi ɛlalɛ liti a, Paulo vɛ Yudafɔ banɔkɔɛ̃ a kĩ bideĩ nɛ awã a ɛkpɔta. Kĩ bɛtsɛna a, ebi be kĩ, “Nwaɛ̃ amɛ, bipi yĩ nɛ Yerusalem bɛkɔa bɛma Roma abãã kĩ ɛdzɛmɔ yĩ, titɔ kĩ ntáfum odima, ĩye nfum boe bawanyɔ amaniɛ adima malo. ");
INSERT INTO bov_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romafɔ a dzɛmɔ yĩ, ade ke bɛwɛ kĩ bafɔnɛ yĩ awɛ kufɛ a, kitonɛkĩ bɛtámɔ lɛtsa a kĩ de akũ baadza bɛkɔ yĩ wuda kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kĩ Yudafɔ a tátunɔ nɛ foe akũ sũ ni, fɔyasĩ kĩ nkɔa yĩ kalɛ mma Lɛgãnɔkɔɛ̃ Kaisare, titɔ kĩ ntábɔɛ fɔlɛtsa nɛ yĩ kade bati akũ malo. ");
INSERT INTO bov_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ade fukĩĩ sũ nvɛ mi a, kitonɛkĩ Oti a kĩ Bɛbɔa Tɔdɔ̃ a, kĩ ye akũ Yudafɔ ate anɛ a, ade ye ntɛ ndo sũ nkɔsɔnkɔsɔ kĩĩ pini yĩ a.” ");
INSERT INTO bov_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ade bibi ye kĩ, “Boe kɔ̃ bɔtánu kadima butomɛna nɔ akũ. Ade bɔtátɛ ovoli ĩye ɔlɛdo kpa odima nɛ nɔ akũ butomɛna bikĩ bito Yudea bɛya nɛ awĩ a sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lɛmɛ bɔawɛ kĩ bɔatse litsedi butomɛna lɛtsa a kĩ de ɔtɛ odo a akũ. Kitonɛkĩ baálɛ kalɛ wĩ kadima nɛ katɛkado katsu a kĩ ke kamɛ odeĩ a akũ nɛ kakɔ nyɛ kakɔ.” ");
INSERT INTO bov_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Biyi luwi ade ke bati pii yatsɛna nɛ Paulo awã a. Awã naa, ebi be fɔlɛtsa nɛ Baguma lɛgãkanyakɔ̃ a akũ. Ade ɛtsa be fɔtsa nɛ Yesu akũ etomɛna Mose mɔ Baguma onukpɛ̃ banyɛnɛ a tuvoli kamɛ a. Ɛlɛ kɔdzɛla kito ɔnɔnɛ kɛnawo olobe. ");
INSERT INTO bov_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Be kamɛ badi tɛ fɔlɛtsa a bido, badi lɛmɛ tátɛ bido. ");
INSERT INTO bov_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Fɔlɛtsa kĩĩ dani kavɛlɛ nɛ be kamɛ, ade bɛsɛ̃ be akũ a. Paulo bi be kĩ, “Hũhũ Kpalɛwa lɛ ɔnɔkɔali ɛtsã Yesaya akũ ebi boe bawanyɔ kĩ, ");
INSERT INTO bov_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Naa kanaabi Yudafɔ a kĩ, “Míanu yĩ fɔlɛtsa lɛmɛ miláanu foe kayɔ, míako anɛ midã lɛmɛ miláamɔ foe miyi ɔsũ.” ");
INSERT INTO bov_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kitonɛkĩ bati kĩĩ tɔwɔlɛ deĩ ɔsĩ, ade be atɔ sĩ a, ade bisua anɛ lɛmɛ a. Ntɛ nnɛ́ aye ni, kufɛ be anɛ aamɔ ade be atɔ aanu, be adzuni kamɛ lɛmɛ aakpalɛ, ade baadani bɛya nɛ yĩ sɛkɛ̃ lɔkɔa ntsa be fɔsɔ.’ ” ");
INSERT INTO bov_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Paulo wũna kɔdzɛla kalɛ mɔ be kĩ, “Kɛnɛ kĩ minyi kĩ, bɛkɔa Baguma bati nkpã katɛ fɔlɛtsa kĩĩ a bɛma bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ. Be ni, baatɛ foe!” ");
INSERT INTO bov_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo dzi nɛ awã futeli nviã nɛ kɔla kĩ ɛwã a kamɛ. Ade awã ɛkatɛ bati a flee kĩ bɛkaya nɛ ye sɛkɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ɛkalɛ Baguma lɛgãkanyakɔ̃ akũ fɔlɛtsa mɔ ɔwɔlɛ kamɛ kɔbɛ̃ flee kakpa be, ɛtsa be fɔtsa etomɛna boe Ɔlate Yesu Kristo akũ, ade odima tásua ye osi a.");
INSERT INTO bov_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ovoli kĩĩ to yĩ, Paulo, Yesu Kristo ɔsumunɛ sɛkɛ̃. Baguma lɛpau yĩ, ɛvɛ yĩ kĩ ĩyadani ye fɔtɔ ɔnyanɛ, nde lɛtsã nɛ ye Kalɛ Wĩ a akũ. ");
INSERT INTO bov_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Baguma lɛ Kalɛ Wĩ kĩĩ eyi anɛ kɔkɔɛ ɛtsãmɛna ye onukpɛ̃ banyɛnɛ akũ, ndɛ ayekĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Bɛlɛ Kalɛ Wĩ kĩĩ nɛ Obi, boe Ɔlate Yesu Kristo akũ. Bɛma ye ndɛ otidziwa aye nɛ Lɛgã Dawid kasinu a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nɛ kakpalɛ nɛ hũhũ kamɛ ni, Baguma nyɛ ye ɛtsa mɔ kɔbɛ̃ ndɛ ye obi, lɔkɔ a kĩ ɛdzɛla ye etomɛna wuda kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Baguma tsã Yesu Kristo akũ ɛmɔ́ boe kɔnya bɔyadani fɔtɔ banyanɛ, ayekĩ fɔ́atsã ye dĩ akũ, bɔ́akpã fude fude bati flee bɛtɛ ye bido, bitse ye. ");
INSERT INTO bov_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mi Romafɔ lɛmɛ, mideĩ nɛ bati a kĩ Baguma vɛ kĩ bɛyaakɛna Yesu Kristo bade a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ade foesũ ntsɛlɛ ovoli kĩĩ mama mi flee a kĩ mideĩ nɛ Roma, kĩ Baguma awɛ mi kalɛ, ade ɛvɛ mi kĩ miyaakɛna bati kĩ ɛkpalɛ be akũ a. Baguma boe Ɔlɛga mɔ boe Ɔlate Yesu Kristo, bɛmɔ mi kɔnya, bɛkpa mi lukudɔ lɛmɛ! ");
INSERT INTO bov_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Lɛtsa a kĩ lɛnyaa lɔtɔ nyɛ kĩ, nkɔa Yesu Kristo manyɛ yĩ Baguma kɔlɛ nɛ mi flee lɔlɔ, kitonɛkĩ balɛ ayekĩ mitɛ Kristo mido a fɔlɛtsa nɛ katinya kamɛ flee. ");
INSERT INTO bov_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Baguma a kĩ masum mɔ yĩ ɔwɔlɛ flee, nɛ lɛtsã a kĩ made nɛ ye Obi Kalɛ Wĩ a akũ a, nyɛ yĩ adansiɛ kĩ lɛtsa a kĩ malɛ a nyɛ ɔnɔkɔali. Baguma nyina kĩ mate anɛ nɛ mi akũ, ");
INSERT INTO bov_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","lɔkɔ nyɛ lɔkɔ kĩ mabɔa mpaɛ. Mawã Baguma kĩ ntɛ fɔnyɛ ye kawɛ ni, ɛkpa yĩ osi ĩyaasɛla mi finyaa. ");
INSERT INTO bov_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kitonɛkĩ mawɛ mɔ ɔsĩ mɔ ɔsĩ kĩ bɔmɔ akũ, lɔkɔa nkɔa hũhũ kamɛ futetsa fudi mma mi nkɔa ndo mi kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Lɛtsa a kĩ matsa nyɛ kĩ bɔmɔ mi bɔ́ado akũ kɔbɛ̃. Yĩ katɛkado ado mi kɔbɛ̃, ade mi kade lɛmɛ aado yĩ kɔbɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nwaɛ̃ amɛ, mawɛ kĩ minyi kĩ nkɛna nhihiɛ lɔkɔ pii kĩ mayaasɛla mi kufɛ, lɛmɛ lɔkɔ nyɛ lɔkɔ litsedi asua yĩ osi. Mawɛ kĩ mana bati kĩ bɛtɛ Kristo bido nɛ mi kamɛ, ndɛ ayekĩ nna nɛ bati bɛbã a kĩ bɛnyɛ́ Yudafɔ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kitonɛkĩ yĩ adzuma fɔanɛ kĩ nde lɛtsã nkpa bati flee, bikĩ binyina kadi mɔ bikĩ binyína kadi, bati kĩ binyina tuvoli mɔ bikĩ binyína tuvoli. ");
INSERT INTO bov_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ade foesũ akũ asĩ yĩ kĩ made lɛtsã nɛ Kalɛ Wĩ a akũ nkpa mi a kĩ mideĩ nɛ Roma lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kalɛ Wĩ a lákɔ yĩ kɔnyɔã, kitonɛkĩ Baguma kɔbɛ̃ kɔanɛ. Kakpa bati a kĩ bɛtɛ ke bido a nkpã, Yudafɔ nyaa lɔtɔ fɔmɔ bikĩ bɛnyɛ́ Yudafɔ a. ");
INSERT INTO bov_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kitonɛkĩ Kalɛ Wĩ a kamɛ banyɛ ayekĩ Baguma abu bati kĩ bɛkpɔla a katsa. Fɔnyɛ katɛkado fɔlɛtsa kĩto kayɔkayi kɛnawo kawũna. Ndɛ ayekĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, “Oti kĩ Baguma abu kĩ yadã kpĩĩ nɛ ye katɛkado sũ ni, yaana nkpã.” ");
INSERT INTO bov_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Baguma anyɛ ye kalɔkpa katomɛna ode kako nɛ bati a kĩ bakɔa tɔkpa mɔ ablɔ fɔtsa kasua ɔnɔkɔali a kanyi osi a akũ. ");
INSERT INTO bov_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Baguma avɛlɛ bati a sɔtɔ kitonɛkĩ binyina fɔtsa a kĩ otidziwa aapuli enyi nɛ ye akũ a. Baguma mɔawɛ a lɛnyɛ foe ɛtsa be yededeede. ");
INSERT INTO bov_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kito anɛ kĩ Baguma bɔa katinya a, ye kutitse kĩ baámɔ mɔ anɛ a, mɔ kɔbɛ̃ kĩ kudeĩ daa mɔ ye Baguma kutidu a, anyɛ foe akũ katsa nɛ fɔtsa a kĩ ɛbɔa a kamɛ. Foesũ bati a lɛláapuli bɛnyɛ onukpɛ̃ kĩ binyína Baguma. ");
INSERT INTO bov_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Titɔ kĩ binyina Baguma malo ni, baákpa ye obu a kĩ ɛfɛta ye, ade baányɛ ye kɔlɛ a. Mbom fɔtsa a kĩ fɔlá nfasɔ akũ bakɔna, ade be adzuni kamɛ ke ɔtũ a. ");
INSERT INTO bov_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Babu be akũ kĩ binyina kadi, lɛmɛ bɛdani badzimbifɔ. ");
INSERT INTO bov_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Nɛ kĩ bɛkɔa obu bɛkpa Baguma a kĩ edzi nkpã daa a ni, basum fɔtsa a kĩ bɛmɛ mɔ awɛ kutidu, kĩ fɔla ndɛ oti kĩ yaku, ĩye kɔvɔlabi, ĩye bayaɛ, ĩye bayaɛ kĩ baboli nɛ sɛmɛ akũ. ");
INSERT INTO bov_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nɛ foesũ Baguma fɔnɛ be awɛ kĩ bɛkɛna efĩĩ fɔtsa kĩ be tɔwɔlɛ awɛ a, kĩ bɛkɔa be sukɛna bakɛna fɔnyɔãtsa mɔ be akũ akũ. ");
INSERT INTO bov_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bakɔa Baguma akũ ɔnɔkɔali a kavɛmɛna mɔ fɔvã. Basum fɔtsa a kĩ Baguma bɔa a kaba Baguma mɔawɛ a kĩ ɛbɔa foe a, kĩ kɛfɛta kĩ bɛkaamu daa a! Fɔya lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nɛ fukĩ bakɛna a sũ, Baguma fɔnɛ be awɛ ɛkpa sukɛna fɔwɛtsa kĩ fɔado akũ kɔnyɔã kakɛna. Be batsole dani bawamɔ bakɔba batsole. ");
INSERT INTO bov_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ade ayea banyole lɛmɛ fɔ̃ bɛmɔ batsole kawa ndɛ ayekĩ Baguma kɛna eyi a, mbom bakɔba banyole akɔ be odo. Foesũ banyole awamɔ akũ kĩ kɔnyɔã lɛláa foe kamɛ. Nɛ ɔbla kpa kĩ bɛbɔa kĩĩ sũ ni, Baguma vɛlɛ be sɔtɔ a kĩ sɛfɛta be a, nɛ be mɔawɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ayekĩ bati a sĩ kĩ baátɛ kadikanyi wĩ nɛ Baguma akũ a bido nɛ be kamɛ sũ ni, Baguma fɔnɛ be awɛ ɛkpa be adzuni kĩ bibula kade a, kĩ bɛkɛna fɔtsa a kĩ fɔtáfɛta a. ");
INSERT INTO bov_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Be kamɛ yi mɔ tɔkpa tidi nyɛ tidi kakɛna, ablɔ, anɛngbã mɔ bati tɔkpa kawɛ. Fɔbɛbã kĩ fudeĩ nɛ be kamɛ nyɛ lineke kanɔ, awudi, lɛma kavũ, bati kakɛ mɔ likesĩ. Fukĩ fubu nyɛ kĩ balɛ bati akũ kɔdzɛla, ");
INSERT INTO bov_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","bɛnyɛ bati buĩ banyɛnɛ, mɔ Baguma bakesĩnɛ. Bɛnyɛ bati bavũnanɛ, akũ batanɛ, akũ bapianɛ, bawɛ tɔkpa tisi bɛbã pii kayamɛna mɔ bati kĩ baábu be bamanɛ a. ");
INSERT INTO bov_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bɛnyɛ bati kĩ be tɔwɔlɛ lákɔ be kɔtɔ, baákɛna nɛ bɔhɛ a akũ a, bɛlá sɛmɛ kalɛ ade baámɔ oti kɔnya a. ");
INSERT INTO bov_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Titɔ kĩ binyina pefee kĩ nɛ Baguma mbla a onukpɛ̃ ni, bikĩ bidzi nkpã nɛ osi kĩĩ odu akũ a fɛta bɛkpa wuda malo ni, bɛkakɛna foe. Nnɛ́ foe odi bakɛna, mbom bɛdza nɛ bikĩ bakɛna fɔtsa kpa kĩĩ odu a liti. ");
INSERT INTO bov_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nwaɛ̃, nɔ akɔ bati bɛbã kɔtɔ? Ntɛ litsa oti anɛ malo ɔláapuli ɔnyɛ onukpɛ̃ kĩ nɔ kɔ̃ oti kpĩĩ anɛ. Kitonɛkĩ ntɛ adzɛmɔ bati bɛbã adeke akɛna lɛtsa mɔapɛ a kĩ de bakɛna a ni, nɔ mɔawɛ akũ akɔ kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Bunyina kĩ Baguma deĩ ɔtɔbɛ ntɛ ɛdzɛmɔ bati a kĩ bakɛna fɔtsa kĩĩ bamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lɛmɛ nwaɛ̃, nɔ a kĩ akɛna fɔtsa kĩĩ bamɛ a lɛmɛ akɔ bati bɛbã kɔtɔ nɛ foe akũ a ni, abu kĩ aapuli olo Baguma kɔtɔkakɔ? ");
INSERT INTO bov_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Mbɔɛɛ ɔbɔɛ foe kĩ Baguma deĩ sɛmɛ kalɛ, ɔwɔlɛ kado mɔ ɔwɔlɛ bɔɛɛ sũ ɔtsɛ́la lɛtsama? Onyina kĩ nuwĩ Baguma deĩ sɛmɛ kalɛ, kitonɛkĩ yawɛ kĩ yakpã nɔ ɔdani ɔwɔlɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lɛmɛ nɛ nɔ atɔ ɔsĩ kĩ aádani ɔwɔlɛ kamɛ sũ ni, ɔfɔ̃ nɔ sɔtɔ kavɛlɛ aana ɔsɛ̃ nɛ luwi a kĩ Baguma aanyɛ ye kalɔkpa mɔ ye fɔlɛtsa kadzɛ kpĩĩ akũ a kanya. ");
INSERT INTO bov_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kitonɛkĩ Baguma aase odi nyɛ odi kɔtɔ nɛ ye adzuma a kĩ ɛkɛna a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bati a kĩ bakɛna tuwĩ kĩ bawɛ kukũkpalɛ, obu mɔ daa nkpã a, Baguma aakpa be nkpã kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lɛmɛ bati bɛbã a kĩ be odi fude bawɛ, kĩ bisĩ ɔnɔkɔali a, bitomɔ tɔkpa a, Baguma aakɔa kalɔkpa ɛvɛlɛ be sɔtɔ mɔ ɔsĩ mɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Bati flee a kĩ bakɛna tɔkpa a, aamɔ lubo mɔ kalɔɛ, Yudafɔ aanya lɔtɔ, ke liti bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lɛmɛ Baguma aakpa bikĩ bakɛna tuwĩ a kukũkpalɛ, obu mɔ lukudɔ, Yudafɔ aanya lɔtɔ bɛna, fɔmɔ bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ. ");
INSERT INTO bov_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kitonɛkĩ Baguma ládã oti anɛ nɛ ye fɔlɛtsa kadzɛ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bikĩ bɛnyɛ́ Yudafɔ a tána Mose mbla a, lɛmɛ kĩ bɛkɛna titikpa ni, Baguma aavɛlɛ be sɔtɔ, kĩ ɛláakɔa mbla a bɛdzɛmɔ be. Yudafɔ a na Mose mbla a, lɛmɛ bɛkɛna titikpa, Baguma aakɔa mbla a ɛdzɛ mɔ be. ");
INSERT INTO bov_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kitonɛkĩ nnɛ́ bati a kĩ batse mbla a nyɛ bati kpĩĩ nɛ Baguma anɛ, mbom bati a kĩ bɛkɛna nɛ mbla akũ a, adã kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Nɛ ɔnɔkɔali kamɛ ni, bikĩ bɛnyɛ́ Yudafɔ a tána mbla a, lɛmɛ ntɛ oti kabɔa kamɛ fɔ̃ bɛkɛna lɛtsa a kĩ Mose mbla tsa ni, fɔatsa kĩ bɛkɛna mbla bɛkpa be akũ, titɔ kĩ bɛlá Mose mbla a malo. ");
INSERT INTO bov_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Be fɔkɛlatsa atsa kĩ Baguma tsɛlɛ mbla a nɛ be tɔwɔlɛ kamɛ. Be tɔwɔlɛ lɛmɛ atsa kĩ fɔnyɛ ɔnɔkɔali, kitonɛkĩ fɔkɔ fudi be tɔwɔlɛ akɔ be kɔtɔ ade yadza nɛ be liti a. ");
INSERT INTO bov_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nɛ foesũ nɛ Kalɛ Wĩ a kĩ malɛ a onukpɛ̃ ni, ade aye fɔ́ana nɛ Luwi a akũ kĩ Baguma aatsã Yesu Kristo akũ ɛdzɛmɔ bati flee fɔlɔ kamɛ fɔlɛtsa kɔlawa a. ");
INSERT INTO bov_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Avɛ nɔ akũ kĩ Yudani, akɔa anɛ kate nɛ mbla akũ, ade apia nɛ Baguma akũ a. ");
INSERT INTO bov_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Onyina lɛtsa a kĩ Baguma awɛ kĩ kɛna, ade ɔkɔlɛ otomɛna mbla a kamɛ lɛtsa a kĩ lɛnyɛ fɔtsa wĩ a. ");
INSERT INTO bov_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Atɛ kado kĩ ɔnyɛ banɛkunɛ ɔkpãnɛ, ɔnyɛ ɔhaĩ ɔkpa bikĩ bideĩ nɛ ɔtũ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ɔkɔa nɔ akũ ɔkɛna bakɔasia ɔvɛlɛnɛ mɔ bikĩ bɛtábo anɛ tɔ̃ fɔtsa ɔtsanɛ. Onyina yededeede lɛmɛ kĩ kadikanyi mɔ ɔnɔkɔali deĩ nɛ mbla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nɔ a kĩ atsa bati bɛbã fɔtsa a, nde sũ aátsa nɔ mɔawɛ akũ? Ade lɛtsã kĩ bati bɛtaye, lɛmɛ nɔ mɔawɛ a aáye? ");
INSERT INTO bov_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Abi bati kĩ bɛtabɔa adɔpaa, lɛmɛ nɔ mɔawɛ a aábɔa adɔpaa? Aáwɛ baviɔ̃ fɔlɛtsa, lɛmɛ aáye kuviɔ̃la kamɛ fɔtsa? ");
INSERT INTO bov_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Abo ɔwɔlɛ nɛ Baguma mbla a akũ, lɛmɛ afum ye mbla a kakɔado Baguma kɔnyɔã. ");
INSERT INTO bov_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Katsɛlɛ Kpalɛwa a lɛ kĩ, “Mi Yudafɔ ɔbla kpa sũ bikĩ bɛnyɛ́ Yudafɔ a alɛ fɔlɛtsa kpa nɛ Baguma dĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ntɛ akɛna nɛ mbla a akũ ni, kekɔ̃ nɔ lɛkpati katsua a akũ deĩ nfasɔ, lɛmɛ ntɛ aákɛna nɛ mbla a akũ kɔ̃ ni, oketimɔ bikĩ bɛtátsua fɔkpati a. ");
INSERT INTO bov_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ntɛ oti kĩ ɛnyɛ́ Yudani, kĩ ɛtátsua lɛkpati akɛna nɛ mbla a akũ ni, Baguma lɛláabu ye ndɛ oti kĩ etsua lɛkpati aye? ");
INSERT INTO bov_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Foesũ, mi Yudafɔ, oti kĩ ɛnyɛ́ Yudani a kĩ ɛkɛna nɛ mbla a akũ aakɔ mi kɔtɔ, kitonɛkĩ miafum mbla a, titɔ kĩ bɛtsɛlɛ ye biyi bɛkpa mi, ade miatsua lɛkpati a. ");
INSERT INTO bov_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nnɛ́ oti kĩ bɛma Yudani ĩye oti kĩ bitsua lɛkpati nɛ Mose mbla a onukpɛ̃ nyɛ Yudani. Ade lɛkpati katsua paa ni, fɔdzɛ́ fɔkpa sukɛna katsua lɛkɛnana kĩ bamɔ nɛ oti akũ a, ");
INSERT INTO bov_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","mbom Yudani kpanunuunu nyɛ oti kĩ ɛnyɛ Yudani nɛ ye kamɛkamɛ, ade foe nyɛ kĩ bitsua ye ɔwɔlɛ kamɛ lɛkpati. Lɛkpati katsua kĩĩ nyɛ Baguma Hũhũ adzuma, fɔtáto mbla a kĩ bɛtsɛlɛ biyi a kamɛ. Baguma amu oti kĩĩ odu, nnɛ́ batidziwa. ");
INSERT INTO bov_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Litsa koũ Yudani deĩ ɛbɛ̃ oti kĩ ɛnyɛ́ Yudani, ĩye litsa nfasɔ deĩ nɛ lɛkpati katsua kamɛ? ");
INSERT INTO bov_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ɔnɔkɔali nfasɔ a pɔnɛ nɛ tisi pii akũ. Katɔnyade nyɛ kĩ Yudafɔ awɛ Baguma kɔa ye fɔlɛtsa a edo. ");
INSERT INTO bov_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lɛmɛ nde ntɛ be kamɛ badi tátɛ bido a? Katsa fɔatsa kĩ be katatɛkado aafɔ̃ Baguma lɛláadi ɔnɔkɔali? ");
INSERT INTO bov_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Oowo! Kɛnɛ kĩ Baguma adi ɔnɔkɔali, titɔ kĩ oti nyɛ oti ama fɔvã malo, ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Ntɛ ɔlɛ kɔdzɛla ni, nɔ fɔlɛtsa fɔnya ɔnɔkɔali. Ntɛ bɛdzɛmɔ nɔ ni, aanya akũ.” ");
INSERT INTO bov_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lɛmɛ ntɛ boe titikpa kakɛna anyɛ fɔtsa wĩ a kĩ Baguma akɛna a katsa yededeede a ni, bɔ́apuli bɔlɛ kĩ Baguma akɛna tɔkpa ntɛ ɛvɛlɛ boe sɔtɔ? Ade kavia kĩ otidziwa aavia a. ");
INSERT INTO bov_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Oowo! Ntɛ Baguma ládã kpĩĩ ni, nde yaakɛna ɛdzɛmɔ katinya kamɛ? ");
INSERT INTO bov_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ntɛ yĩ fɔvã kama anyɛ Baguma ɔnɔkɔali a katsa, kĩ bamu ye a, nde sũ bakɔ yĩ kɔtɔ ndɛ tɔkpa ɔkɛnanɛ? ");
INSERT INTO bov_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nde sũ bɔálɛ kĩ, “Mifɔ̃ bɔkɛna titikpa ayekĩ tuwĩ aanɛ tito foe kamɛ?” Ɔnɔkɔali bati badi lamɛna fɔvã kama kate nɛ yĩ akũ kĩ ade aye nlɛ a. Baguma aakɔ be kɔtɔ ndɛ ayekĩ kɛfɛta. ");
INSERT INTO bov_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Mbɔɛɛ finyaa, boe Yudafɔ kadzi kamɛ nɛnɛ kɛbɛ̃ bikĩ bɛnyɛ Yudafɔ a? Oowo! Kitonɛkĩ ĩnya lɔtɔ ntsa kɔkɔɛ kĩ tɔkpa nya Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ a flee akũ, ");
INSERT INTO bov_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Oti odima lɛláa kĩ yadã kpĩĩ. Midi oti mɔapɛ malo lɛláa. ");
INSERT INTO bov_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Odima lɛláa kĩ yanu fɔlɛtsa kayɔ, ĩye kĩ yawɛ Baguma liti osi. ");
INSERT INTO bov_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bati flee muniki nɛ Baguma liti, be flee bɛyɛla osi, ade odima lɛláa kĩ yakɛna tuwĩ a, oti mɔapɛ malo lɛláa. ");
INSERT INTO bov_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Be tudomɛna binya tɛwaa ndɛ linikɛ kĩ lɛwaa luto aye, bakɛ bati mɛnɛmɛnɛ mɔ be fɔmɛ. Be onukpɛ̃ kamɛ fɔlɛtsa la ndɛ kɔɛ kadɔ̃ aye. ");
INSERT INTO bov_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Fudumutsa mɔ fɔlɔɛwotsa yi be tunukpɛ̃ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Bawɛ sɔwa kĩ bapila bati bɛkɔ be. ");
INSERT INTO bov_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kakɔ nyɛ kakɔ kĩ banaa ni, kawɔla mɔ fɔtsa kade kabula ate nɛ liti. ");
INSERT INTO bov_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Binyína kadzi nɛ lukudɔ kamɛ, ");
INSERT INTO bov_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ade Baguma kavila kadima lɛláa be kamɛ a.” ");
INSERT INTO bov_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Finyaa, bunyina kĩ lɛtsa nyɛ lɛtsa nɛ mbla a kamɛ a atamɔ bikĩ bideĩ nɛ mbla a kayɔ, ayekĩ baasua batidziwa onukpɛ̃ kanyɛ osi, lɔkɔa Baguma lɛdzɛmɔ katinya kamɛ flee. ");
INSERT INTO bov_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kitonɛkĩ odima lɛnyɛ́ oti kpĩĩ nɛ Baguma anɛ, nɛ ayekĩ yakɛna nɛ mbla a akũ sũ. Lɛtsa a kĩ mbla a akɛna nyɛ kĩ yafɔ̃ oti anyi kĩ ɛkɛna tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lɛmɛ finyaa, bɛnyɛ osi a kĩ Baguma atsã kakɛna bati kpĩĩ nɛ ye anɛ a bɛtsa. Fukĩĩ lɛtsɛ́la mbla a akũ, titɔ kĩ Mose mbla a mɔ Baguma onukpɛ̃ banyɛnɛ di foe akũ adansiɛ malo. ");
INSERT INTO bov_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Baguma akɛna bati badã kpĩĩ katsãmɛna be Yesu Kristo katɛkado kamɛ. Yakɛna fukĩĩ kakpa bati a kĩ bɛtɛ Kristo bido a flee, kĩ ntsitsemu adima lɛláa foe kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kitonɛkĩ odi nyɛ odi kɛna tɔkpa, ade edeĩ mɔ lugo nɛ Baguma kukũkpalɛ a ɔwɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lɛmɛ nɛ kɔnya a kĩ Baguma amɔ faa sũ ni, ɛtsã Kristo Yesu a kĩ ese kɔtɔ nɛ boe lɔlɔ a akũ, ɛkɛna boe bati kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Baguma kɔa ye ɛkpa ndɛ lɛma ɔkplanɛ kĩ fɔtsã ye wuda kamɛ bati bɛna tɔkpa kakɔakate ntɛ bɛtɛ ye bido. Baguma kɛna fukĩĩ ɛnɛɛ yatsa kĩ yadã kpĩĩ. Nɛ kɔkɔɛ a, Baguma na ɔwɔlɛ bɔɛɛ, ɛve sinepo esua bati tɔkpa, ");
INSERT INTO bov_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","lɛmɛ finyaa kɔ̃ yate anɛ nɛ be tɔkpa akũ ɛkɔa yatsa kĩ yadã kpĩĩ. Nɛ osi kĩĩ akũ, Baguma atsa kĩ ye mɔawɛ ɛnyɛ oti kpĩĩ ade yakɛna odi nyɛ odi kĩ ɛtɛ Yesu edo oti kpĩĩ a. ");
INSERT INTO bov_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Finyaa ni, litsa bɔ́akɔa bubo ɔwɔlɛ? Bɔlá lɛtsamama! Mɔ litsa sũ? Ayekĩ bɔakɛna nɛ mbla a akũ sũ mbɔɛɛ? Oowo! Mbom ayekĩ bɔtɛ budo sũ. ");
INSERT INTO bov_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Foesũ bɔ́awũna kĩ katɛkado odi akũ fɔtsã mɔ oti adã kpĩĩ nɛ Baguma anɛ, kĩ nnɛ́ mbla a akũ kakɛna sũ. ");
INSERT INTO bov_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Mbɔɛɛ Baguma a ni, Yudafɔ odi ode yanɛ? Nnɛ́ bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ Baguma yanɛ? Oo, be malo Baguma yanɛ! ");
INSERT INTO bov_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Baguma mɔapɛ deĩ, ade yaakɛna Yudafɔ bati kpĩĩ ɛtsãmɛna be katɛkado akũ a, ɛkɛna bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ bati kpĩĩ ɛtsãmɛna be katɛkado kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Katsa fɔatsa kĩ katɛkado sũ bɔfɔnɛ mbla a awɛ? Oowo! Fɔlá lɔmɔ kɔlaa, mbom bupini mbla a mɔ ɔsĩ mɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Litsa bɔ́apuli bɔlɛ nɛ boe kade ɔwanyɔ Abraham akũ? Litsa ɛmɔ́ eyi ɔsũ nɛ fɔlɛtsa kĩĩ akũ? ");
INSERT INTO bov_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ntɛ tudzuma a kĩ ɛkɛna a akũ fɔtsã sũ Baguma bu Abraham kĩ ɛnyɛ oti kpĩĩ ni, kekɔ̃ yaana litsedi kĩ yakɔa ebo ɔwɔlɛ, lɛmɛ nnɛ́ nɛ Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Abraham tɛ Baguma edo, ade nɛ ye katɛkado sũ Baguma tɛ ye kĩ yadã kpĩĩ.” ");
INSERT INTO bov_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Oti kĩ yakɛna adzuma ni, base ye kɔtɔ, lɛmɛ baábu kɔtɔkase a ndɛ futetsa, mbom fɔnyɛ lɛtsa a kĩ fɔfɛta fɔkpa ye adzuma a kĩ ɛkɛna a. ");
INSERT INTO bov_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lɛmɛ ntɛ odi tátɛ dĩ nɛ adzuma kakɛna kamɛ, mɔ ɛtɛ edo kĩ Baguma akɛna bikĩ baávila ye bati kpĩĩ ni, nɛ ye katɛkado sũ Baguma aabu ye kĩ ɛnyɛ oti kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ade foe Lɛgã Dawid lɛmɛ lɛ kĩ bihila oti a kĩ Baguma bu ye kĩ ɛnyɛ oti kpĩĩ, kĩ nnɛ́ ye adzuma wĩ a kĩ ɛkɛna a sũ. Dawid lɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Baguma hila bikĩ ye mɔawɛ ɛkɔa be tɔkpa ete be a, bikĩ ɛkɔa be titikpa ɛkɔla. ");
INSERT INTO bov_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Baguma hila oti a kĩ Baguma nyɛ anɛ nɛ ye tɔkpa akũ.” ");
INSERT INTO bov_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Nhila fɔlɛtsa a kĩ Dawid lɛ nɛ awĩ a ni, bikĩ bitsua fɔkpati a odi fude yanɛ, mbɔɛɛ kĩ mɔ bikĩ bɛtátsua fɔkpati a? Oowo! Ɛnyɛ bikĩ bɛtátsua fɔkpati a lɛmɛ ade, kitonɛkĩ bɔlɛ butomɛna Katsɛlɛ Kpalɛwa a kamɛ kĩ, “Nɛ Abraham katɛkado sũ, Baguma bu ye oti kpĩĩ.” ");
INSERT INTO bov_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Lɔkɔ lɔwɔdabe Baguma bu ye oti kpĩĩ? Nɛ lɔkɔ a kĩ bitsua Abraham lɛkpati a, mbɔɛɛ lɔkɔ a kĩ bɛtátsua de tɔ̃ a? Fɔnyɛ lɔkɔ a kĩ ɛtátsua tɔ̃ lɛkpati a, nnɛ́ lɔkɔ a kĩ etsua liti a. ");
INSERT INTO bov_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ke liti kɔlaa fɔmɔ bitsua Abraham lɛkpati. Ye lɛkpati katsua lɛmɛ nyɛ nsɛntsɛlɛni kĩ Baguma tɛ ye kĩ ɛnyɛ oti kpĩĩ nɛ ye katɛkado sũ, titɔ kĩ nɛ lɔkɔ a na kamɛ malo bɛtátsua tɔ̃ ye lɛkpati. Foesũ Abraham yadani bati a kĩ bɛtɛ Baguma bido a flee hũhũ kamɛ ɔlɛga. Titɔ kĩ bɛtátsua fɔkpati malo ni, bɛtɛ be ndɛ bati kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ade ayea Abraham nyɛ bikĩ bitsua fɔkpati a lɛmɛ ɔlɛga a. Lɛmɛ nnɛ́ nɛ ayekĩ bitsua be fɔkpati a odi sũ, mbom nɛ ayekĩ bidzi nkpã nɛ katɛkado kamɛ ndɛ ayekĩ boe ɔlɛga Abraham dzi fɔmɔ bitsua ye lɛkpati a sũ. ");
INSERT INTO bov_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Baguma kpa Abraham mɔ ye kasinu kamɛ babi bɔhɛ kĩ katinya kĩĩ kamɛ aanya be adzapadiɛ. Ɛkɛna foe nnɛ́ nɛ ayekĩ Abraham kɛna nɛ mbla a akũ sũ, mbom nɛ ayekĩ ɛtɛ edo kĩ Baguma bu ye oti kpĩĩ sũ. ");
INSERT INTO bov_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kitonɛkĩ ntɛ bikĩ bakɛna nɛ mbla a akũ odi aanya fɔtsa a kĩ ɛlɛ eyi a ni, kekɔ̃ katɛkado lɛnyɛ́ lɛtsama ade Baguma kalɛkayi a lɛmɛ nyɛ fɔtsa pupulidza a. ");
INSERT INTO bov_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Mbla a avɛlɛ Baguma kalɔkpa kayamɛna, lɛmɛ awã kĩ mbla lɛláa ni, mbla kafum lɛláa. ");
INSERT INTO bov_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Foesũ bɔhɛ a dzɛ̃ nɛ katɛkado akũ, ayekĩ bɔhɛ a aatim ndɛ fɔtsa a kĩ Baguma mɔ kɔnya ɛkɔa ete Abraham kasinu a kamɛ babi. Nnɛ́ bikĩ bakɛna nɛ mbla a akũ odi fɔwaa fɔkpa, mbom mɔ bikĩ bɛtɛ bido ndɛ ayekĩ Abraham tɛ edo a, kitonɛkĩ Abraham nyɛ boe flee hũhũ kamɛ ɔlɛga, ");
INSERT INTO bov_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Nkɔa nɔ nkɛna fude fude pii ɔlɛga.” Foesũ bɔhɛ a nɛnɛ nɛ Baguma anɛ. Ade ye nyɛ Baguma a kĩ Abraham tɛ edo kĩ yadzɛla banɔkpa bayidza kadzi nkpã, kĩ yafɔ̃ fɔtsa a kĩ fɔláa kɔkɔɛ fɔanɛ katinya. ");
INSERT INTO bov_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Titɔ kĩ anɛ kate adima buki ɛláa malo ni, Abraham tɛ edo ɛkadã anɛ, ade foesũ ɛkɛna fude pii ɔlɛga, ndɛ ayekĩ Baguma bi ye a kĩ, “Nɔ babi mɔ bawa aama bɛsa beblebee ndɛ fusibii aye.” ");
INSERT INTO bov_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nɛ lɔkɔ a, Abraham tɛ ndɛ futeli ɔha, lɛmɛ ye katɛkado onukpɛ̃ tádɔ, titɔ kĩ ɛmɔ eyi ɔsũ kĩ kɔbɛ̃ woli nɛ ye sukɛna kamɛ, mɔ ayekĩ Sara lɛmɛ tɛ̃ kɔma kana malo a. ");
INSERT INTO bov_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ɛtátɛ fɔtsa a kĩ Baguma lɛ eyi kĩ yaakɛna ɛkpa ye a akũ atsindze, ade ɛtáfɔnɛ ye katɛkado awɛ a, mbom ye katɛkado a do ye kɔbɛ̃, edo Baguma obu. ");
INSERT INTO bov_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ɛtɛ edo pipiipi kĩ Baguma aapuli ɛkɛna nɛ lɛtsa a kĩ ɛlɛ eyi a akũ. ");
INSERT INTO bov_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ade Abraham katɛkado sũ mɔ Baguma bu ye kĩ ɛnyɛ oti kpĩĩ a. ");
INSERT INTO bov_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Fɔlɛtsa a kĩ bɛlɛ kĩ, “Baguma bu ye kĩ yadã kpĩĩ” a, nnɛ́ Abraham odi sũ bɛtsɛlɛ foe, ");
INSERT INTO bov_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mbom bɛtsɛlɛ foe bɛkpa boe lɛmɛ. Boe a kĩ bɔ́atɛ oti a kĩ ɛdzɛla boe Ɔlate Yesu etomɛna kanɔkpa a budo a, baabu boe kĩ bɔnyɛ bati kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Boe titikpa sũ Baguma fɔnɛ Kristo awɛ ɛkpa kĩ bɛkɔ, ade ɛdzɛla ye edzi nkpã, ayekĩ yaabu boe bati kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Finyaa, kĩ Baguma bu boe bati kpĩĩ nɛ boe katɛkado sũ ni, bɔtsɛ̃ boe Ɔlate Yesu Kristo akũ bɔna lukudɔ nɛ bɔmɔ Baguma kayite. ");
INSERT INTO bov_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ye akũ lɛmɛ bɔtsã mɔ osi binya ɛkpa boe kĩ Baguma aamɔ boe kɔnya, budzi nɛ ye kɔnyakamɔ a kamɛ. Nɛ foesũ bɔapia nɛ kɔnɛte a kĩ budeĩ kĩ bɔ́ana tsɛfã nɛ Baguma kukũkpalɛ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Nɛ ɔhau pii kamɛ malo bɔamɔ kawɔlɛ, kitonɛkĩ bunyina kĩ ɔhau afɔ̃ bɔakɔlɛ ɔwɔlɛ kado, ");
INSERT INTO bov_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ɔwɔlɛ kado afɔ̃ bɔadza pintii, ade kadza pintii afɔ̃ bɔana kɔnɛte a. ");
INSERT INTO bov_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ade kɔnɛte láfɔ̃ kɔnyɔã awo boe, kitonɛkĩ Baguma kɔa ye ɔdɔ edo nɛ boe tɔwɔlɛ kamɛ ɛtsãmɛna ye Hũhũ Kpalɛwa a kĩ ɛkpa boe a akũ. ");
INSERT INTO bov_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kitonɛkĩ kĩ bubuki bɔlá kɔbɛ̃ kudima a, ade lɔkɔ a na kamɛ Kristo ku nɛ tɔkpa bakɛnanɛ lɔlɔ, ndɛ ayekĩ Baguma mɔawɛ yi ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Fɔnyɛ lɛtsa mɔ ɔsĩ kĩ oti odi aku nɛ oti kpĩĩ lɔlɔ. Fɔ́apuli fɔya malo kĩ oti odi aado ɔwɔlɛ kĩ yaku nɛ oti wĩ lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lɛmɛ Baguma tsa boe ayekĩ eti yawɛ boe kalɛ, kitonɛkĩ lɔkɔ a kĩ bubuki bɔnyɛ tɔkpa bakɛnanɛ a, Kristo ku nɛ boe lɔlɔ. ");
INSERT INTO bov_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ɛtsã ye wuda kamɛ ɛkɛna bati boe kpĩĩ nɛ Baguma anɛ. Wuda kĩĩ sũ yaanyɛ boe etomɛna Baguma kalɔkpa a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Bɔnya Baguma bakesĩnɛ lɛmɛ ɛkɛna boe ye bakɔba ɛtsãmɛna ye Obi wuda a kĩ ɛkɔa ɛpata ye a kamɛ. Finyaa kĩ ɛkpɔla Baguma ɛkpa boe kĩĩ ni, yaatɛ boe ɛba, kitonɛkĩ edzi nkpã. ");
INSERT INTO bov_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lɛmɛ nnɛ́ fukĩĩ odi, mbom bɔamɔ kawɔlɛ nɛ lɛtsa a kĩ Baguma tsã boe Ɔlate Yesu Kristo akũ ɛlɔla bɔmɔ ye kayite a sũ. ");
INSERT INTO bov_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Tɔkpa tsã oti mɔa akũ tɛya nɛ katinya kamɛ, ade wuda tsã ye akũ ɛya a. Nɛ fukĩĩ sũ ni, wuda yalɛ ewo nɛ batidziwa flee kamɛ, kitonɛkĩ odi nyɛ odi kɛna tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Nɛ ɔnɔkɔali kamɛ ni, tɔkpa na nɛ katinya kamɛ fɔmɔ mbla a ya, lɛmɛ awã kĩ mbla lɛláa ni, baábu lɛtsama kĩ lɛnyɛ tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lɛmɛ kito Adam lɔkɔ kɛyawo Mose lɔkɔ a ni, wuda nya batidziwa flee akũ, mɔ bikĩ bɛtákɛna tɔkpa ndɛ tikĩ Adam kɛna a malo. Adam kĩĩ dzɛ̃ ndɛ oti a kĩ yaaya a. ");
INSERT INTO bov_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lɛmɛ be bati nviã a bɛtáketi, kitonɛkĩ Baguma futetsa faa a lɛlá ndɛ Adam tɔkpa a. Fɔnyɛ ɔnɔkɔali kĩ bati pii ku nɛ oti mɔa tɔkpa sũ. Lɛmɛ Baguma kɔnyakamɔ bɛ̃ kɔlaa, foesũ ade ayea ye futetsa a kĩ yakpa bati pii faa katsãmɛna oti mɔa kĩ ɛnyɛ Yesu Kristo akũ a la a. ");
INSERT INTO bov_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Futesa a kĩ Baguma kpa faa a lɛlá ndɛ lɛtsa a kĩ oti mɔa tɔkpa vɛlɛ tɛyamɛna a, kitonɛkĩ tɔkpa a kĩ oti mɔa a kɛna a yamɔ kadzɛ mɔ kɔtɔkaku. Lɛmɛ futetsa a kĩ Baguma kpa faa a fɔ̃ bibu bati beblebee tɔkpa a kĩ bɛkɛna a kĩ badã kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Fɔnyɛ ɔnɔkɔali kĩ oti mɔa tɔkpa a kĩ ɛkɛna sũ wuda yaanya akũ. Lɛmɛ lɛtsa a kĩ oti mɔa a kĩ ɛnyɛ Yesu Kristo kɛna a bɛ̃ foe flee. Bikĩ bɛna Baguma kɔnyakamɔ baũ kĩĩ flee a, kĩ ɛkɛna be bati kpĩĩ lɛmɛ a, aanya akũ nɛ nkpã kamɛ bɛtsãmɛna Kristo akũ. ");
INSERT INTO bov_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Foesũ ndɛ ayekĩ oti mɔa tɔkpa a kĩ ɛkɛna fɔ̃ bɛkɔ batidziwa flee kɔtɔ a, ade ayea oti mɔa tuwĩ kĩ ɛkɛna a kpa batidziwa flee ɔtɔbɛ, bɛna nkpã lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ade ndɛ ayekĩ oti mɔa atɔ ɔsĩ kakɛna fɔ̃ bati flee dani tɔkpa bakɛnanɛ a ni, ade ayea oti mɔa Baguma ɔlɛdo akũ kakɛna aafɔ̃ bɛkɛna bati pii kpĩĩ nɛ Baguma anɛ a. ");
INSERT INTO bov_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Bɛyamɛna mbla a ayekĩ tɔkpa kakɛna aapɔ ebu, lɛmɛ awã kĩ tɔkpa kakɛna pɔnɛ ni, Baguma kɔnyakamɔ lɛmɛ apɔ kabu. ");
INSERT INTO bov_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Foesũ ayekĩ tɔkpa nya akũ nɛ wuda kamɛ a ni, ade ayea Baguma kɔnyakamɔ anya akũ katsãmɛna kadzi kpĩĩ kamɛ, kakpã boe kawomɛna nkpã a kĩ kɛlá kawũna a kamɛ, nɛ boe Ɔlate Yesu Kristo dĩ akũ a. ");
INSERT INTO bov_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Foesũ, finyaa litsa bɔ́alɛ? Bɔ́ana nɛ tɔkpa kakɛna kamɛ ayekĩ Baguma kɔnyakamɔ aapɔ kibu mbɔɛɛ? ");
INSERT INTO bov_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Oowo! Kĩ buku bɔkpa tɔkpa kɔkɔɛ a, nde bɔabuki budzi nkpã bɔkakɛna tɔkpa? ");
INSERT INTO bov_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Mbɔɛɛ minyína kĩ, kĩ bɛwɔla boe mui, bɔkɛna ɔmɔa mɔ Yesu Kristo a, bɛwɔla boe mui bɔkɛna ɔmɔa mɔ ye wuda a lɛmɛ? ");
INSERT INTO bov_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nɛ boe mui kawɔla kĩĩ kamɛ a, bɔna tsɛfã nɛ ye wuda a kamɛ, ade bibila bɔmɔ ye a. Ndɛ ayekĩ Ɔlɛga a tsã ye kukũkpalɛ kɔbɛ̃ kamɛ ɛdzɛla Kristo etomɛna banɔkpa kamɛ a, ade aye boe malo bɔ́ayidza budzi nkpã vɔɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kitonɛkĩ ayekĩ bɔkɛna ɔmɔa mɔ ye nɛ ye wuda kamɛ a, ade ayea bɔ́abuki bɔkɛna ɔmɔa mɔ ye nɛ boe kadzɛla kadzi nkpã kamɛ ndɛ ayekĩ bɛdzɛla ye a. ");
INSERT INTO bov_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Bunyina kĩ, kĩ bɛbɔa boe kutitse kɔɛ a nɛ asendua akũ mɔ Kristo ayekĩ boe sukɛna kĩ sawɛ tɔkpa kakɛna a aawɔ, ayekĩ bɔláabuki bɔnya tɔkpa basate. ");
INSERT INTO bov_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kitonɛkĩ ntɛ oti sila eku ni, bɛnyɛ ye nɛ tɔkpa kɔbɛ̃ kayɔ. ");
INSERT INTO bov_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ntɛ buku mɔ Kristo ni, bɔtɛ budo kĩ bɔ́adzi nkpã lɛmɛ mɔ ye. ");
INSERT INTO bov_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bunyina kĩ, kĩ Baguma dzɛla Kristo etomɛna kanɔkpa sũ ni, ɛláabuki eku da. Wuda buki lɛláabuki ɛna kɔbɛ̃ kudima nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Wuda a kĩ Kristo ku a, eku ye deedimɔapɛ ɛkpa tɔkpa, lɛmɛ nkpã a kĩ edzi finyaa, edzi ye ɛkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ade ayea mi malo mibu mi akũ kĩ miku mikpa tɔkpa, lɛmɛ Baguma nɛ ɔmɔa kakɛna mɔ Kristo Yesu kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kɛtánɛ kĩ tɔkpa tibuki tɛnya mi sukɛna a kĩ saku a akũ, ayekĩ míakakɛna nɛ se fɔwɛtsa akũ. ");
INSERT INTO bov_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mitafɔnɛ mi sukɛna kakɔma awɛ mikpa tɔkpa tɛkɔa tɛkɛna ablɔ adima, mbom mikɔa mi akũ mikpa Baguma ndɛ bati kĩ ɛnyɛ etomɛna wuda kamɛ ɛyamɛna nɛ nkpã kamɛ. Mifɔnɛ mi akũ flee awɛ mikpa Baguma fɔnya fɔtsa kĩ yaakɔa ɛkɛna tuwĩ. ");
INSERT INTO bov_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kɛtánɛ kĩ tɔkpa tɛnya mi akũ, kitonɛkĩ miláa mbla kayɔ, mbom mideĩ nɛ Baguma kɔnyakamɔ kayɔ. ");
INSERT INTO bov_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Foesũ litsa bɔalɛ? Bɔ́akɛna tɔkpa kitonɛkĩ bɔláa mbla kayɔ, mbom budeĩ nɛ Baguma kɔnyakamɔ kayɔ sũ? Oowo! ");
INSERT INTO bov_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Minyina pefee kĩ ntɛ mikɔa mi akũ mikɛna odi basumunɛ ni, minyɛ ɔlate a kĩ ye kayɔ mideĩ a basate. Ntɛ mikɔa akũ mikpa tɔkpa kakɛna ni, lɛtsa a kĩ laanɛ nɛ foe kamɛ nyɛ wuda, lɛmɛ ntɛ mikɛna nɛ Baguma ɔlɛdo akũ ni, foe nfasɔ nyɛ kadzi kpĩĩ nɛ Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bɔanyɛ Baguma kɔlɛ paa, kitonɛkĩ titɔ kĩ minya tɔkpa basate miyatɛ̃ malo ni, finyaa mitɛ ɔnɔkɔali fɔtsa katsa a mɔ mi tɔwɔlɛ, milamɔ foe akũ kakɛna pɛpɛɛpɛ. ");
INSERT INTO bov_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Baguma nyɛ mi etomɛna tɔkpa kamɛ, midani fɔtsa wĩ kakɛna basate. ");
INSERT INTO bov_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Malɛ kɔdzɛla ndɛ otidziwa aye nɛ ayekĩ otidziwa adɔ nɛ sukɛna kamɛ sũ. Nɛ lɔkɔ lidi kĩ lɛtɛ̃ kamɛ ni, mifɔnɛ mi akũ flee awɛ ndɛ basate mikpa efĩĩ mɔ ablɔ fɔtsa kakɛna. Ade ayea kɛnɛ kĩ finyaa miafɔnɛ mi akũ flee awɛ mikpa ndɛ tuwĩ kakɛna basate a. ");
INSERT INTO bov_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kĩ minya tɔkpa kakɛna basate a, tuwĩ kakɛna tánya ɔhɛ fɔkpa mi. ");
INSERT INTO bov_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Litsa nfasɔ mina mitomɛna fɔtsa a kĩ mikakɛna a kĩ finyaa fɔakɔ mi kɔnyɔã a kamɛ? Fɔtsa a na bamɛ flee kawũna nyɛ wuda. ");
INSERT INTO bov_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lɛmɛ finyaa, Baguma nyɛ mi nɛ tɔkpa kamɛ midani ye basate. Nfasɔ a kĩ míana nyɛ kĩ miakɔa mi akũ flee mikpa Baguma ɛkpalɛ ye akũ, lɔkɔa nɛ foe kawũna mina nkpã kĩ ɛlá kawũna a. ");
INSERT INTO bov_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kitonɛkĩ tɔkpa kɔtɔkase nyɛ wuda, lɛmɛ Baguma futetsa faa nyɛ nkpã kĩ ɛlá kawũna a, nɛ ɔmɔa kakɛna mɔ boe Ɔlate Kristo Yesu kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nwaɛ̃ amɛ, mi a kĩ minyina Mose mbla a, míanu lɛtsa a kĩ mawɛ kĩ malɛ nɛ awĩ a kayɔ. Mbla anya oti akũ nɛ lɔkɔ a kĩ edzi nkpã a odi. ");
INSERT INTO bov_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Foe nfantuhũ nyɛ kĩ mbla sui otsole kĩ edzi kɔnyɔ edo nɛ ɔnyɔ kayɔ nɛ onyole a nkpã kamɛ. Lɛmɛ ntɛ onyole a ku ni, otsole a nɛ́ nɛ mbla a kĩ esui ye ɛmɛna mɔ onyole a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Foesũ ntɛ otsole a naa onyole bɛbã sɛkɛ̃ nɛ lɔkɔ a kĩ ɔnyɔ a buki edzi nkpã ni, baavɛ ye ɔdɔpaani. Lɛmɛ ntɛ ɔnyɔ a ku kɔ̃ ni, mbla kĩĩ tásui ye, ade ntɛ ɛnadzi mɔ onyole bɛbã ni, ɛtábɔa adɔpaa. ");
INSERT INTO bov_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nwaɛ̃ amɛ, ade aye fɔla fɔkpa mi malo a. Nɛ mbla a onukpɛ̃ ni, mi malo miku, kitonɛkĩ minyɛ Kristo sukɛna a sɛkɛ sidi. Ade finyaa minyɛ ye a kĩ Baguma dzɛla etomɛna kanɔkpa a bade, ayekĩ bɔ́anɛ libi bɔkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kitonɛkĩ kĩ budzi nkpã nɛ sukɛna kamɛ a ni, sukɛna fɔwɛtsa kpa a kĩ mbla a dzɛla nɛ boe kamɛ a, kɛna adzuma nɛ boe kamɛ, ɛmanɛ boe ɛkpa wuda. ");
INSERT INTO bov_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lɛmɛ finyaa bɔnɛ́ nɛ mbla a kayɔ, kitonɛkĩ buku bɔkpa fɔtsa a kĩ fusuli boe ndɛ kɔla bawanɛ a. Bɔláabuki busum nɛ mbla kĩ bɛtsɛlɛ osi kɔɛ a akũ, mbom bɔ́asum nɛ Hũhũ kamɛ osi vɔɛ̃ a akũ. ");
INSERT INTO bov_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Finyaa litsa bɔ́alɛ? Kalɛ bɔ́alɛ kĩ mbla nyɛ tɔkpa? Oowo! Fɔlá lɔmɔ. Lɛmɛ mbla a lɛfɔ̃ ĩnyi lɛtsa a kĩ tɔkpa anɛ. Ntɛ mbla a ɛtalɛ kĩ, “Tayɔɔla anɛ nɛ oti bɛbã fɔtsa akũ” ni, kufɛ ĩnyína anɛngbã kawɛ a na. ");
INSERT INTO bov_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Lɛmɛ fɔtsã mbla a akũ, tɔkpa na osi tinyina odo kakɔ fɔtsa kpa flee nɛ yĩ kamɛ. Ntɛ mbla kalaa ɛláa ni, kufɛ tɔkpa lɛmɛ ku. ");
INSERT INTO bov_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Yĩ mɔawɛ a ndzi tɔ̃ nkpã, kĩ mbla a tána, lɛmɛ kĩ mbla a ya a, tɔkpa yidza tidzi nkpã, ");
INSERT INTO bov_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ade nku a. Ade mbla a kĩ kufɛ ɛma yĩ nkpã a, yĩ kɔ̃ wuda ɛkɔa ɛma yĩ. ");
INSERT INTO bov_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Tɔkpa tsã mbla akũ tɛna osi tɛkɛ yĩ, ade tɛkɔ yĩ a. ");
INSERT INTO bov_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Foesũ mbla mɔawɛ a akũ kpalɛ, ade ayea ye nhihiɛ a adã kpĩĩ, ɛnɛnɛ lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Lɔkɔa lɛtsa wĩ a kĩ lɛnɛnɛ a dani wuda lɛkpa yĩ? Oowo! Fɔlá lɔmɔ. Tɔkpa tsã tuwĩ akũ tɛkɔa wuda tɛma yĩ, ayekĩ taanyɛ te kutitse paa a tɛtsa. Foesũ fɔtsã mbla akũ bɛnyɛ tɔkpa bɛtsa ndɛ lɛtsa kpa kĩ liti lɛnɛ́nɛ koũ. ");
INSERT INTO bov_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Bunyina kĩ mbla a nyɛ hũhũ kamɛ fɔtsa, lɛmɛ yĩ kɔ̃ ĩnyɛ otidziwa, kĩ bɛnɔ ɔsate bɛkpa tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Maánu yĩ fɔtsa kɛnawa a kayɔ, kitonɛkĩ maákɛna lɛtsa a kĩ mawɛ kĩ makɛna a, mbom makɛna lɛtsa a kĩ makesĩ a. ");
INSERT INTO bov_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ntɛ lɛtsa a kĩ maáwɛ a makɛna kɔ̃ ni, kekɔ̃ ntunɔ kĩ mbla a nɛnɛ. ");
INSERT INTO bov_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Foesũ nnɛ́ yĩ mɔawɛ akɛna fɔtsa a, mbom tɔkpa a kĩ tideĩ nɛ yĩ kamɛ a akɛna foe. ");
INSERT INTO bov_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ĩnyina kĩ tuwĩ tidima lidzí nɛ yĩ kamɛ ayekĩ ĩnyɛ otidziwa sũ. Kitonɛkĩ titɔ kĩ kawɛ a kĩ makɛna tuwĩ deĩ nɛ yĩ kamɛ malo ni, maápuli nkɛna te. ");
INSERT INTO bov_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Tuwĩ a kĩ mawɛ kĩ makɛna a, maákɛna te, mbom makɛna tɔkpa a kĩ maáwɛ kĩ makɛna a. ");
INSERT INTO bov_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ntɛ lɛtsa a kĩ maáwɛ a makɛna ni, kekɔ̃ nnɛ́ yĩ mɔawɛ a akɛna foe, mbom tɔkpa a kĩ tideĩ nɛ yĩ kamɛ a akɛna foe. ");
INSERT INTO bov_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Foesũ mmɔ́ mbla kĩĩ fɔlɛtsa ĩyi ɔsũ, kĩ ntɛ mawɛ kĩ makɛna tuwĩ ni, tɔkpa mbom makɛna. ");
INSERT INTO bov_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nɛ yĩ kamɛkamɛ ni, mamɔ kawɔlɛ nɛ Baguma mbla a akũ. ");
INSERT INTO bov_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lɛmɛ mamɔ mbla bɛbã nɛ yĩ sukɛna kamɛ kĩ yanɔ lɛma mɔ yĩ lɔlɔ kamɛ tuwĩ kĩ mawɛ a. Ɛkɛna yĩ kɔla ɔwanɛ ɛkpa tɔkpa mbla a kĩ edeĩ nɛ yĩ sukɛna kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Nkɛna oti kĩ ye akũ akɔ kɔnya. Owei aatɛ yĩ etomɛna sukɛna kĩ sɛkpã yĩ sanamɛna wuda kamɛ a awɛ? ");
INSERT INTO bov_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kɔlɛ bɔanyɛ Baguma bɔtsãmɛna boe Ɔlate Yesu Kristo akũ. Finyaa, ayekĩ nla nyɛ kĩ nɛ yĩ mɔa akũ akũ ni, nnɛɛ yĩ adzuma makɛna nɛ Baguma mbla a akũ, lɛmɛ sukɛna a kɔ̃ ni, nnɛ masum tɔkpa mbla a. ");
INSERT INTO bov_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Foesũ finyaa kɔtɔkakɔ lɛláa kɛkpa bikĩ bɛkɛna ɔmɔa mɔ Kristo Yesu a. ");
INSERT INTO bov_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kitonɛkĩ Hũhũ mbla a kĩ yakpa oti nkpã nɛ ɔmɔa kakɛna kamɛ mɔ Kristo Yesu a, nyɛ yĩ etomɛna tɔkpa mɔ wuda mbla a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Lɛtsa a kĩ mbla a tápuli ɛkɛna a, ayekĩ sukɛna a tɛ kɔbɛ̃ nɛ ye awɛ sũ ni, Baguma kɔ̃ kɛna foe. Edo ye mɔawɛ obi ɛya nɛ otidziwa sukɛna kĩ sakɛna tɔkpa kamɛ, ade ɛyakɔ tɔkpa kɔtɔ, ɛnyɛ te a. ");
INSERT INTO bov_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Baguma kɛna fukĩĩ ayekĩ boe a kĩ budzi nɛ Hũhũ kamɛ, kĩ nnɛ́ nɛ sukɛna kamɛ a, bɔ́apuli budzi nɛ tuwĩ kakɛna a kĩ ye mbla awɛ a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bati kĩ bidzi nkpã ndɛ ayekĩ be sukɛna awɛ a onukpɛ̃ ni, fɔtsa a kĩ be sukɛna awɛ a akũ bakɔna. Lɛmɛ bikĩ bidzi nkpã ndɛ ayekĩ Hũhũ a awɛ a onukpɛ̃ ni, fɔtsa a kĩ Hũhũ a awɛ a akũ be adzuni ana. ");
INSERT INTO bov_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Oti kadzi nɛ sukɛna fɔwɛtsa tsɛ̃mɔ wuda, lɛmɛ oti kĩ Hũhũ a akpã ye a, ana nkpã mɔ lukudɔ. ");
INSERT INTO bov_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Nɛ foesũ oti a kĩ ye sukɛna fɔwɛtsa nya ye akũ a adani Baguma okesĩnɛ, kitonɛkĩ yaákɛna nɛ Baguma mbla akũ, ade nɛ ɔnɔkɔali kamɛ ni, ɛláapuli ɛkɛna nɛ ye akũ. ");
INSERT INTO bov_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bikĩ bidzi nkpã nɛ be sukɛna kawɛ onukpɛ̃ a fɔkɛlatsa lɛláapuli fuwo Baguma anɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Lɛmɛ mi kɔ̃ midzí nɛ sukɛna kawɛ onukpɛ̃, mbom midzi ndɛ ayekĩ Hũhũ a awɛ kĩ midzi a. Odi nyɛ odi kĩ Kristo Hũhũ lɛláa ye kamɛ lɛnyɛ́ Kristo ode. ");
INSERT INTO bov_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Lɛmɛ ntɛ Kristo deĩ nɛ nɔ kamɛ a, Hũhũ a nyɛ nkpã ɛkpa nɔ, kitonɛkĩ ɛkɛna nɔ oti kpĩĩ nɛ Baguma anɛ, titɔ kĩ nɔ sukɛna ayaku malo nɛ tɔkpa sũ. ");
INSERT INTO bov_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ntɛ Baguma Hũhũ a kĩ ɛdzɛla Yesu etomɛna banɔkpa kamɛ a deĩ nɛ mi kamɛ ni, kekɔ̃ oti a kĩ ɛdzɛla Kristo etomɛna banɔkpa kamɛ a lɛmɛ aakpa mi sukɛna kĩ saku a nkpã, nɛ ye Hũhũ a kĩ edeĩ nɛ mi kamɛ a sũ. ");
INSERT INTO bov_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Foesũ nwaɛ̃ amɛ, budeĩ adzuma adi kĩ kɛnɛ kĩ bɔkɛna lɛmɛ fɔnyɛ́ kĩ bɔadzi nkpã ndɛ ayekĩ boe sukɛna awɛ kĩ budzi a. ");
INSERT INTO bov_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kitonɛkĩ ntɛ midzi nkpã nɛ sukɛna kawɛ onukpɛ̃ ni, míaku. Lɛmɛ ntɛ mitsã Hũhũ kamɛ mikɔ mi fɔkɛlatsa kpa a, míana nkpã. ");
INSERT INTO bov_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Bati a kĩ Baguma Hũhũ akpã a flee nyɛ Baguma babi. ");
INSERT INTO bov_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kitonɛkĩ Hũhũ a kĩ Baguma kpa mi a tákɛna mi basate mikavila, mbom Hũhũ a akɛna mi Baguma babi. Ade Hũhũ a kɔbɛ̃ afɔ̃ bɔbɔa fɔwɔla kavɛ Baguma kĩ, “Abba!” kĩ foe kayɔ nyɛ kĩ “Ao Nda!” ");
INSERT INTO bov_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Baguma Hũhũ a mɔawɛ lɛkɛna ɔmɔa mɔ boe hũhũ yadi adansiɛ kĩ Baguma babi bɔanɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ntɛ bɔnyɛ ye babi ni, bɔnyɛ ye adzapadiɛ lɛmɛ banyanɛ, ade bɔmɔ Kristo bɔ́anya adzapadiɛ a kĩ Baguma kɔa eyi ye a. Foesũ ntɛ bɔna tsɛfã nɛ Kristo lubo kamɔ a kamɛ ni, bɔ́ana tsɛfã lɛmɛ nɛ ye kukũkpalɛ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Makɔna kĩ bɔláapuli bɔkɔa lubo a kĩ bɔamɔ finyaa a bɔkɔnamɔ Baguma kukũkpalɛ a kĩ baanyɛ bɛtsa boe a kɔlaa. ");
INSERT INTO bov_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Fɔtsa a kĩ Baguma bɔa a flee dzi fɔadzɔlɛ mɔ akũ kasĩ kĩ Baguma ɛnyɛ ye babi ɛtsa. ");
INSERT INTO bov_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kitonɛkĩ bɛkɔ fɔtsa a kĩ Baguma bɔa a flee kɔtɔ kĩ fɔnyɛ fɔtsa pupulidza, nnɛ́ nɛ foe kawɛ akũ, mbom Baguma lɛwɛ kĩ fɔna lɔmɔ. Lɛmɛ kɔnɛte a deĩ kĩ, ");
INSERT INTO bov_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","luwi lidi ni, fɔtsa a kĩ bɛbɔa flee aanyɛ foe akũ nɛ tɛsate ɔsum kĩ yabu kade a kamɛ, fɔyaawo nɛ akũ akũ kadzi mɔ kukũkpalɛ a kĩ Baguma aakpa ye babi a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kitonɛkĩ bunyina kĩ kɛyawo nviã lɔkɔ kĩĩ a, fɔtsa a kĩ Baguma bɔa a flee abe ayɔlɔhɔ ndɛ ɔmatsɔ̃ kĩ sɛmɛ pi ye aye. ");
INSERT INTO bov_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Lɛmɛ nnɛ́ fɔtsa kĩ bɛbɔa a odi abe ayɔlɔhɔ, mbom boe a kĩ Baguma kpa ye Hũhũ ndɛ ye futetsa fɔtɔnyade a lɛmɛ bɔabe ayɔlɔhɔ nɛ boe kamɛ, kadzɔlɛ Baguma kĩ ɛkɛna boe ye babi a, ɛnyɛ boe kutitse a flee. ");
INSERT INTO bov_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kitonɛkĩ ade kɔnɛte kĩĩ sũ bɔna katɛ a, lɛmɛ ntɛ bɔamɔ kɔnɛte fɔtsa kɔkɔɛ ni, fubuki fɔnyɛ́ kɔnɛte. Kitonɛkĩ owei akɔa anɛ kate nɛ fɔtsa a kĩ yamɔ a akũ? ");
INSERT INTO bov_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Lɛmɛ ntɛ boe anɛ teĩ nɛ fɔtsa a kĩ bɔámɔ akũ ni, bɔana ɔwɔlɛ bɔɛɛ kadzɔlɛ foe. ");
INSERT INTO bov_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ade ayea Hũhũ a lɛmɛ aayabumɔ boe a kĩ bɔdɔ a, kitonɛkĩ bunyína ayekĩ kɛfɛta kĩ bɔabɔa mpaɛ bɔkpa Baguma. Hũhũ mɔawɛ a abe ayɔlɔhɔ kapili boe lɔlɔ nɛ Baguma sɛkɛ̃ mɔ fɔlɛtsa kĩ onukpɛ̃ lɛláapuli ɛlɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ade Baguma a kĩ yamɔ bati tɔwɔlɛ kamɛ a nyina lɛtsa a kĩ lɛnyɛ Hũhũ a adzuni, kitonɛkĩ Hũhũ a ake Baguma aduli nɛ ye bade lɔlɔ ndɛ ayekĩ Baguma awɛ a. ");
INSERT INTO bov_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Bunyina kĩ Baguma akɛna fɔtsa flee fɔaboomu kakɛna fuwĩ kakpa bati a kĩ bawɛ ye kalɛ a, kĩ ɛvɛ nɛ ye nhihiɛ onukpɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bati a kĩ Baguma nyi ɛnyamɛna lɔtɔ a, ɛpau be eyi kĩ bɛyaakɛna ndɛ ye Obi aye, ayekĩ ye Obi a aanya be ɔtɔnyade nɛ bawaɛ̃ pii kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Foesũ bati a kĩ Baguma nyɛ eyi a, ade be ɛvɛ a, ade bikĩ ɛvɛ a, ɛkɛna be bɛkpɔla ade ɛkpa be tsɛfã nɛ ye kukũkpalɛ a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ntɛ bɔkɔna fukĩĩ flee akũ a, litsa bɔ́apuli bɔlɛ? Ntɛ Baguma dzɛ̃ nɛ boe liti a ni, owei aapuli eyidza ɛdza nɛ boe akũ? ");
INSERT INTO bov_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ntɛ Baguma a kĩ ɛtásĩ ye mɔawɛ Obi kakɔa kakpa, mbom ɛkɔa ye ɛkpa faa nɛ boe flee lɔlɔ a ni, nde fɔ́anya kĩ ɛláakɔa fɔtsa bɛbã flee faa ebu Obi ɛkpa boe? ");
INSERT INTO bov_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Owei aapuli ɛbɔɛ fɔlɛtsa nɛ bati a kĩ Baguma pau a akũ? Baguma mɔawɛ di adansiɛ kĩ bɛtáku kɔtɔ. ");
INSERT INTO bov_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Foesũ owei aakɔ be kɔtɔ? Nnɛ́ Kristo Yesu a kĩ eku ĩye kĩ Baguma dzɛla ye etomɛna banɔkpa kamɛ, edzi nkpã nɛ Baguma sɔmɔna, yake ye aduli nɛ boe lɔlɔ a! ");
INSERT INTO bov_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kekɔ̃ owei ĩye litsa aapuli etsua bɔmɔ Kristo ɔdɔ a kayite? Lubokamɔ aapuli, mbɔɛɛ ɔhau, mbɔɛɛ bati liti katomɛna, mbɔɛɛ kɔlɛkakɔ ĩye ohiã, mbɔɛɛ ɔdzɔ kadzi, mbɔɛɛ wuda libe, mbɔɛɛ kĩ wuda? ");
INSERT INTO bov_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Katsɛlɛ Kpalɛwa a lɛ kĩ, “Nɔ sũ, bakɔ boe lɔkɔ nyɛ lɔkɔ. Ade babu boe ndɛ baveli kĩ bɛkpã banaakɔ aye.” ");
INSERT INTO bov_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nɛ fukĩĩ flee kamɛ a, bɔtsã Kristo kĩ yawɛ boe kalɛ a akũ bɔba ayekĩ bɔkɔna malo. ");
INSERT INTO bov_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kitonɛkĩ ntɛ ndo kĩ lɛtsama lɛláapuli lɛnyɛ boe nɛ boe Ɔlate Kristo ɔdɔ a kamɛ. Fɔláanya wuda ĩye nkpã, ode fɔtɔ banyanɛ ĩye hũhũ kpa kɔbɛ̃ kudi, lɔkɔ kĩĩ ĩye lɔkɔ kĩ laaya, ");
INSERT INTO bov_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","katinya kĩ kideĩ nɛ ode ĩye katinya kĩ kideĩ nɛ tite kayɔ ĩye fɔtsa a kĩ bɛbɔa a kamɛ fudima. Lɛtsama koũ lɛláa katinya kamɛ flee kĩ láapuli lɛnyɛ boe nɛ Baguma ɔdɔ a kĩ bɔna bɔtsãmɛna boe Ɔlate Kristo Yesu akũ a kamɛ! ");
INSERT INTO bov_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Lɛtsa a kĩ malɛ a nyɛ ɔnɔkɔali, Kristo ode manɛ ade maáma fɔvã a. Yĩ ɔwɔlɛ kĩ Hũhũ Kpalɛwa anya ye akũ a akpa yĩ katɛkado kĩ nnɛ́ fɔvã mama. ");
INSERT INTO bov_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Mabe ayɔlɔhɔ, ade ntɛ kalɔɛ kĩ kaádɔ nɛ yĩ ɔwɔlɛ kamɛ, ");
INSERT INTO bov_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","kakpa yĩ bati a kĩ bɔmɔ be bɔnyɛ sukɛna mɔ babɔanɛ mɔa. Nɛ be sũ maawɛ kĩ Baguma edumu yĩ faa, ɛsɛ̃ bɔmɔ Kristo kayite malo kufɛ. ");
INSERT INTO bov_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Kitonɛkĩ ade be nyɛ Israel ɔmaĩ a kĩ Baguma pau, ɛkɔa ɛkɛna ye bade, ɛnyɛ ye kukũkpalɛ a ɛtsa be a. Esui onukpɛ̃ mɔ be, ɛkpa be ye mbla a lɛmɛ. Be nɛɛ Baguma ɔsum osi wĩ a, ade be lɛmɛ ɛkɛna bɔhɛ ɛkpa a. ");
INSERT INTO bov_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Be kasinu to Hebrifɔ bawanyɔ a kĩ bɛtɛ buĩ a kamɛ, ade be kade kamɛ Kristo lɛmɛ nɛ eto ndɛ otidziwa aye ɛya a. Mifɔ̃ bumu Baguma a kĩ yanya fɔtsa flee akũ daa daa a! Fɔya lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Nlámɔ kalɛ kĩ Baguma kalɛkayi a táya nɛ foe kamɛ, kitonɛkĩ nnɛ́ bati a kĩ bito Israel a flee nyɛ Israelfɔ kpanunu. ");
INSERT INTO bov_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ade ayea nnɛ́ Abraham kasinu babi a flee nyɛ Baguma babi. Baguma bi Abraham kĩ, “Isak akũ fɔ́atsã mɔ aana babi mɔ bawa a kĩ nlɛ ĩyi a.” ");
INSERT INTO bov_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Foe kayɔ nyɛ kĩ nnɛ́ babi a kĩ Abraham ma ndɛ bati ayea nyɛ Baguma babi, mbom bikĩ ɛma nɛ ye bɔhɛ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kitonɛkĩ Baguma bɔhɛ a nyɛ, “Kateliva, lɔkɔ kĩĩ kamɛ a, maamuniki ĩya ade Sara aama obinyole a.” ");
INSERT INTO bov_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Nnɛ́ fukĩĩ odi a. Babinyole nviã a kĩ Rebeka ma a ɔlɛga nyɛ boe ɔwanyɔ Isak. ");
INSERT INTO bov_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Lɛmɛ nɛ ayekĩ babinyole nviã kamɛ ɔmɔa kapau fɔya nɛ foe kamɛ nɛ Baguma nhihiɛ onukpɛ̃ sũ ni, Baguma bi Rebeka kĩ, “Obinɔkɔɛ̃ a aasum obisɛ̃de a.” Ebi ye eyi kɔkɔɛ fɔmɔ ɛyama babi a. Foesũ Baguma kapau a kĩ ɛkɛna a lɛdzɛ́ nɛ tuwĩ ĩye tɔkpa a kĩ nta babi a kamɛ odi kɛna a akũ, mbom Baguma kawɛ fɔanɛ. ");
INSERT INTO bov_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Bɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, “Nwɛ Yakob kalɛ, lɛmɛ nkesĩ Esau.” ");
INSERT INTO bov_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Lɔkɔa bɔ́alɛ kĩ Baguma lɛmɛ ládã kpĩĩ? Oowo! Fɔlá lɔmɔ kɔlaa. ");
INSERT INTO bov_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kitonɛkĩ ebi Mose kĩ, “Odi nyɛ odi kĩ mawɛ kĩ makɛna sɛmɛ kalɛ nkpa ni, ade ye maakɛna sɛmɛ kalɛ nkpa a. Ade odi nyɛ odi kĩ ye akũ kɔ yĩ kɔnya ni, maamɔ ye kɔnya.” ");
INSERT INTO bov_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Foesũ Baguma oti kapau lɛdzɛ́ nɛ ye mbɔdibɔ ĩye lɛtsa a kĩ yawɛ a akũ, mbom lɛtsa nyɛ lɛtsa dzɛ̃ nɛ Baguma kɔnyakamɔ odi akũ. ");
INSERT INTO bov_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kitonɛkĩ nɛ Katsɛlɛ Kpalɛwa kamɛ a, Baguma bi Egipte lɛgã kĩ, “Ndzina nɔ lɛgã ayekĩ maatsã nɔ akũ ĩnyɛ yĩ kɔbɛ̃ ntsa, lɔkɔa yĩ dĩ lɛgba nɛ katinya kamɛ flee.” ");
INSERT INTO bov_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Foesũ odi nyɛ odi kĩ Baguma awɛ kĩ yamɔ kɔnya a, ade ye yamɔ kɔnya a, ade odi nyɛ odi kĩ yawɛ kĩ ɛna atɔ ɔsĩ a, yafɔ̃ yana atɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mi kamɛ odi aavia yĩ kĩ, “Ntɛ fɔla lɔmɔ a, nde sũ Baguma buki yanyɛ nfumusu kakpa odi? Owei aapuli eyidza ɛdza nɛ Baguma kawɛ akũ?” ");
INSERT INTO bov_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nɔ otidziwa, owei anɛ kĩ akpa Baguma mbuayɛ lɔmɔ? Lubui lávia de ɔmɛnɛ kĩ, “Nde sũ ɔmɛ yĩ lɔmɔ?” ");
INSERT INTO bov_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Fubui ɔmɛnɛ deĩ osi kĩ yakɔa tibute a kĩ enuna ɛbɔa lɔbɔ a ɛmɛ lɛtsa a kĩ yawɛ. Mbɔɛɛ ɛlá osi kĩ yakɔa tite lɔbɔ mɔapɛ a ɛmɛ fubui nviã? Yaamɛ lɔmɔa kĩ lalɛ kadã eyi ɛkpa fuwi titiliwu, lɔkɔa ɛkɔa te nkaɛ a ɛmɛ lɛbɛbã kĩ laálɛ kadã eyi ɛkpa luwi daa akũ adzuma kakɛna. ");
INSERT INTO bov_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ade lɛtsa a kĩ Baguma kɛna a kayɔ nɛ awĩ a. Ntɛ Baguma wɛ kĩ yanyɛ ye kalɔkpa kanya, ɛfɔ̃ bɛmɔ ye otumi, lɛmɛ ebuki ɛna ɔwɔlɛ bɔɛɛ epini bikĩ be akũ ɛna kalɔkpa, kĩ bidum be bɛkpa kawɔla a ni, litsa odeĩ kĩ aalɛ? ");
INSERT INTO bov_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ade ntɛ Baguma wɛ lɛmɛ kĩ yanyɛ ye kukũkpalɛ baũ a kĩ biko nɛ boe a kĩ ɛmɔ kɔnya akũ a, boe a kĩ ɛmanɛ eyi ɛkpa ye kukũkpalɛ a, ");
INSERT INTO bov_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","kitonɛkĩ boe nyɛ bati a kĩ ɛpau etomɛna Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ a kamɛ a ni, odeĩ kadi kalɛ? ");
INSERT INTO bov_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ade fukĩĩ Baguma lɛ nɛ Onukpɛ̃ Ɔnyɛnɛ Hosea ovoli kamɛ kĩ, “Bati kĩ bɛnyɛ́ yĩ ɔmaĩ bati a, maavɛ be kĩ, ‘Yĩ bati.’ Kade a kĩ ntáwɛ ke kalɛ a, maavɛ ke ‘Yĩ ɔdɔ bati.’ ");
INSERT INTO bov_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Nɛ kakɔ mɔapɛ a kĩ bibi be kĩ, ‘Minyɛ́ yĩ bati’ a Ade awã baavɛ be kĩ ‘Baguma Kĩ Edzi Nkpã Daa a babi.’ ” ");
INSERT INTO bov_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Baguma Onukpɛ̃ Ɔnyɛnɛ Yesaya bɔa fɔwɔla ɛlɛ nɛ Israelfɔ akũ kĩ, “Ntɛ Israelfɔ nɛ lidede ndɛ mpo abuĩ dã malo ni, be kamɛ bati sukuloo badi aana katɛ, ");
INSERT INTO bov_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","kitonɛkĩ boe Ɔlate aadzɛmɔ katinya kamɛ bati pɛpɛɛpɛ mɔatsɛ, etsua lɛtsa nyɛ lɛtsa lukũ.” ");
INSERT INTO bov_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Yesaya buki ɛlɛ eyi kĩ, “Ntɛ boe Ɔlate Otumifɔ Flee a ɛtatina boe babi mɔ bawa a badi ni, kufɛ bɔdani bɔkɛna ndɛ Sodom, buketimɔ Gomora!” ");
INSERT INTO bov_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Foesũ litsa koũ bɔ́alɛ? Matsa kĩ bikĩ bɛnyɛ́ Israelfɔ a kĩ bɛtápili kĩ badzi kpĩĩ nɛ Baguma anɛ a, bɛkɛna be bati kĩ bɛkpɔla bɛtsãmɛna be katɛkado akũ. ");
INSERT INTO bov_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ade Israelfɔ a kĩ bɛkawɛ mbla a kĩ yaakɛna be bati kpĩĩ a, tápuli bɛkɛna nɛ mbla a akũ a. ");
INSERT INTO bov_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Litsa sũ bɛtápuli? Kitonɛkĩ bɛtákɔa katɛkado bɛwɛ foe, mbom bɛkɔa anɛ bite nɛ be mɔawɛ mbɔdibɔ akũ. Nɛ foesũ bitula nɛ Kristo kĩ ɛla ndɛ de a kĩ bati atula nɛ de akũ a akũ, ");
INSERT INTO bov_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ndɛ ayekĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, “Midã! Nkɔa de lidi mayi nɛ Zion, de kĩ bati aatula nɛ de akũ bɛnɛ bɛtɔ. Lɛmɛ odi nyɛ odi kĩ ɛtɛ ye edo ni, kɔnyɔã lɛláawo ye.” ");
INSERT INTO bov_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Nwaɛ̃ amɛ, lɛtsa a kĩ mawɛ nɛ yĩ ɔwɔlɛ kamɛ flee, mɔ mpaɛ kĩ mabɔa nɛ de akũ kakpa Baguma nyɛ kĩ, ɛfɔ̃ yĩ awɛ kade bati bɛna nkpã katɛ! ");
INSERT INTO bov_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Maapuli ndi adansiɛ kĩ bɛkɔa be akũ flee bɛkpa Baguma ɔsum, lɛmɛ binyína ayekĩ basum ye nɛ osi wĩ akũ a kanyina wĩ. ");
INSERT INTO bov_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Bɛtányi osi a kĩ Baguma atsã kabu bati kĩ bidzi kpĩĩ nɛ ye anɛ, foesũ bɛwɛ be mɔawɛ tisi kĩ batsã bɛkɛna fɔtsa biwo Baguma anɛ, ade foesũ bɛtákɔa be akũ bɛkpa Baguma osi a kĩ yatsã kakɛna bati kpĩĩ a. ");
INSERT INTO bov_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kitonɛkĩ Kristo nyɛ Mose mbla a kawũna, ayekĩ odi nyɛ odi kĩ ɛtɛ ye edo ni, baabu ye oti kpĩĩ. ");
INSERT INTO bov_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mose tsɛlɛ eyi ɛtsa ayekĩ oti adzi kpĩĩ nɛ Baguma anɛ ntɛ edi mbla a akũ. Ɛlɛ kĩ, “Odi nyɛ odi kĩ ɛkɛna nɛ mbla a akũ pɛpɛɛpɛ ni, yaana nkpã.” ");
INSERT INTO bov_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lɛmɛ lɛtsa a kĩ Katsɛlɛ Kpalɛwa a lɛ nɛ ayekĩ oti aadã kpĩĩ nɛ katɛkado kamɛ nyɛ kĩ, “Tavia nɔ akũ kĩ, ‘Owei aade ɛnaa ode?’ kĩ fɔatsa kĩ ɛnaakpã Kristo eto kanɔkpade ede ɛya. ");
INSERT INTO bov_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ĩye tavia kĩ, ‘Owei aaka ɛnaa kayɔ?’ Foe nyɛ kĩ owei aanaa kanɔkpade ɛnaakpã Kristo ɛyamɛna.” ");
INSERT INTO bov_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Lɛtsa a kĩ yatsa a nyɛ kĩ, “Baguma kalɛ a fuã nɔ plɛplɛplɛ, kideĩ nɛ nɔ onukpɛ̃ mɔ nɔ ɔwɔlɛ kamɛ.” Ade katɛkado ɔlɛdo a kĩ bɔade lɛtsã nɛ ke akũ a nɛ awĩ a. ");
INSERT INTO bov_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ntɛ ɔkɔa onukpɛ̃ ɔlɛ kĩ Yesu nyɛ boe Ɔlate, mɔ ɔtɛ odo nɛ nɔ ɔwɔlɛ kamɛ kĩ Baguma dzɛla ye etomɛna banɔkpa kamɛ ni, Baguma aakpa nɔ nkpã. ");
INSERT INTO bov_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kitonɛkĩ ɔwɔlɛ bakɔa katɛ kado kana kadzi kpĩĩ, ade onukpɛ̃ bakɔa kanyɛ foe kanya mɔ Baguma akpa boe nkpã. ");
INSERT INTO bov_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Katsɛlɛ Kpalɛwa a lɛ kĩ, “Odi nyɛ odi kĩ ɛtɛ ye edo lɛláatɛ kɔnyɔã.” ");
INSERT INTO bov_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Odi nyɛ odi deĩ nɛ foe kamɛ, kitonɛkĩ ntsitsemu adima lɛláa Yudafɔ mɔ bikĩ bɛnyɛ́ Yudafɔ a kayite. Baguma mɔapɛ a nyɛ bati flee Ɔlate, ade yakpa akũ kana fɔtsa nhila pii bikĩ babɔa mpaɛ kavɛ ye a. ");
INSERT INTO bov_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ a, “Odi nyɛ odi kĩ yaavɛ boe Ɔlate a dĩ ni, yaana nkpã.” ");
INSERT INTO bov_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Lɛmɛ nde bati aakɛna bɛvɛ oti a kĩ bɛtátɛ ye bido a? Nde baakɛna bɛtɛ oti a kĩ bɛtánu ye fɔlɛtsa a bido? Ade ntɛ bɛtáde lɛtsã nɛ fɔlɛtsa a akũ a, nde baakɛna binu ye dĩ? ");
INSERT INTO bov_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ade nde baakɛna bide lɛtsã Baguma fɔlɛtsa ntɛ bɛtádo fɔtɔ banyanɛ? Ade foe akũ mɔ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Batɔ a kĩ bɛyaade lɛtsã nɛ Kalɛ Wĩ a akũ a kaya alɛ kadã paa!” ");
INSERT INTO bov_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lɛmɛ nnɛ́ bati flee lɛtɛ Kalɛ Wĩ a, kitonɛkĩ Yesaya lɛ kĩ, “Boe Ɔlate, owei lɛtɛ boe kalɛ a edo?” ");
INSERT INTO bov_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Foesũ katɛkado ato kalɛ a kanu kamɛ, ade fɔlɛtsa a kanu ato lɛtsã kade nɛ Kristo akũ a. ");
INSERT INTO bov_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lɛmɛ mavia kĩ ɔnɔkɔali fɔanɛ kĩ bɛtánu Baguma fɔlɛtsa a kɔlaa? Ɔnɔkɔali binu foe, kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Lɛtsã badenɛ a odo tsɛna katinya kamɛ flee, ade be fɔlɛtsa a gba fɔnawo katinya kawũnakɔ̃ a flee.” ");
INSERT INTO bov_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Mavia bio kĩ lɔkɔa kanu Israelfɔ a tánu fɔlɛtsa a kayɔ? Mose mɔawɛ lɛnya lɔtɔ ɛlɛ kĩ, Baguma lɛ kĩ, “Maafɔ̃ minɔ lineke mɔ bati kĩ bɛnyɛ́ ɔmaĩ a. Maakɔa ɔmaĩ a kĩ ɛtábinya anɛ a ndo mi kalɔkpa.” ");
INSERT INTO bov_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ade Yesaya do ɔwɔlɛ ɛba ebi be kĩ, Baguma lɛ kĩ, “Bati a kĩ bɛtáwɛ yĩ liti osi a, ade be lɛmɔ́ yĩ a bati a kĩ bɛtávia yĩ akũ a, ade be ĩnyɛ yĩ akũ ntsa a.” ");
INSERT INTO bov_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Baguma buki ɛlɛ nɛ Israelfɔ akũ kĩ, “Luwi mɔa flee ndzɛlɛ yĩ akpɔ kamɛ nkpa bati a kĩ bideĩ atɔ ɔsĩ, kĩ biyidza bɛdza nɛ yĩ akũ lɛmɛ a.” ");
INSERT INTO bov_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Foesũ mavia kĩ Baguma pu ye mɔawɛ bati a flefle? Oowo! Yĩ mɔawɛ Israelni manɛ, ĩnyɛ Abraham kasinu ɔwa, kĩ nto Benyamin katete a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Baguma tápu ye ɔmaĩ a kĩ ɛpau eyi kito kayɔkayi a. Mbɔɛɛ minyína lɛtsa a kĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ, awã a kĩ Eliya ke Baguma aduli nɛ Israelfɔ lɔlɔ a? Ɛlɛ kĩ, ");
INSERT INTO bov_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Boe Ɔlate, bɛkɔ nɔ onukpɛ̃ banyɛnɛ, ade bidzuli nɔ afɔlibɔ tɛtɛnyɛ a. Yĩ odi keĩ lite ade bawɛ kĩ bakɔ yĩ malo a!” ");
INSERT INTO bov_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Lɛmɛ nde Baguma kpa Eliya mbuayɛ? Ebi ye kĩ, “Ntina bati mpim evũkɔnɔ kĩ bɛtásum Baal baviɔ̃ a ĩyi nkpa yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ade aye fɔla nɛ finyaa lɔkɔ kĩĩ kamɛ malo a. Israelfɔ sukuloo badi te kĩ Baguma mɔ be kɔnya ɛpau eyi a. ");
INSERT INTO bov_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Baguma mɔ be kɔnya, ɛpau be, nnɛ́ nɛ be adzuma a kĩ bɛkɛna a sũ. Kitonɛkĩ ntɛ bati kapau dzɛ̃ nɛ be lɛkɛnana akũ ni, kekɔ̃ ye kɔnyakamɔ a buki kɔnyɛ́ kɔnyakamɔ. ");
INSERT INTO bov_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Foesũ nde? Israelfɔ a tána lɛtsa a kĩ bɛkawɛ a. Lɛmɛ be kamɛ badi sukuloo a kĩ Baguma pau a lɛna foe, ade be nkaɛ kɛna atɔ ɔsĩ nɛ Baguma kavɛ akũ a. ");
INSERT INTO bov_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Baguma fɔ̃ be adzuni mɔ be tɔwɔlɛ dɔ kĩ baánu fɔlɛtsa kayɔ, Ade kito nɛ ke kɛyawo nviã kĩĩ a, baápuli bɛmɔ́ biyi ɔsũ ĩye binu foe kayɔ.” ");
INSERT INTO bov_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ade Dawid lɛ kĩ, “Baguma ɛfɔ̃ be kanyakɔ̃ opunu ɛdani kpɛĩ epi be, mɔ lɛtsa a kĩ baatula bɛtɔ fɔnya be sɔtɔ kavɛlɛ. ");
INSERT INTO bov_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ɛfɔ̃ be anɛ eke ɔtũ ayekĩ bɛláamɔ fɔkɔ, ɛfɔ̃ bikũũkũ nɛ be lubokamɔ kayɔ daa daa.” ");
INSERT INTO bov_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Finyaa mavia kĩ, kĩ Yudafɔ tula bɛnɛ bɛtɔ a, bɛkahɔ kɔlaa nɛ awã? Oowo! Ayekĩ bɛkɛna tɔkpa sũ ni, nkpã katɛ a ya nɛ bikĩ bɛnyɛ́ Yudafɔ a sɛkɛ̃, ayekĩ Yudafɔ a aanɔ be lineke. ");
INSERT INTO bov_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ntɛ Yudafɔ tɔkpa yamɛna akũ kana nhila baũ nɛ katinya kamɛ, mɔ ntɛ be hũhũ kamɛ katɔ a ma bikĩ bɛnyɛ́ Yudafɔ a nhila pii ni, kekɔ̃ nhila a aablusu paa ntɛ Yudafɔ a flee dani bɛkɛna Baguma bade. ");
INSERT INTO bov_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ade mi a kĩ minyɛ́ Yudafɔ a mabi fɔlɛtsa finyaa a. Ayekĩ ĩnyɛ bikĩ bɛnyɛ́ Yudafɔ a fɔtɔ ɔnyanɛ sũ ni, maapia nɛ adzuma a akũ. ");
INSERT INTO bov_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ɔsa fɔ́atsã ye kakɛna kamɛ ni, maapuli nfɔ̃ yĩ kade bati lɛnɔ lineke ayekĩ maapuli ntɛ badi nkpã. ");
INSERT INTO bov_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kitonɛkĩ kĩ Baguma fɔnɛ be awɛ a, ɛkpɔla batidziwa kĩ bɛnyɛ ye bakesĩnɛ a ɛkɛna be ye bakɔba. Foesũ nde fɔ́ana ntɛ Baguma buki ɛtɛ be? Fɔ́ana ndɛ nkpã ɛkpa banɔkpa! ");
INSERT INTO bov_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Ntɛ abodoo sɛkɛ sɛtɔnyade a kĩ bɛkɔa bɛkpa Baguma akũ kpalɛ ni, kekɔ̃ ye nkaɛ a lɛmɛ akũ kpalɛ. Ade ayea ntɛ bɛkɔa kutse tunu bɛbɔa afɔliɛ bɛkpa Baguma ni, koe tɛnanɛ a lɛmɛ nyɛ ye tide. ");
INSERT INTO bov_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bitsua kugua kutse kĩ bidu a tɛnanɛ tidi bɛnyɛ, ade bɛkɔa lupo kamɛ kugua kutsede tɛnanɛ bɛyatalɛ nɛ koe akũ a. Mi a kĩ minyɛ́ Yudafɔ a la ndɛ lupo kamɛ kutse tɛnanɛ a kĩ bɛkɔa bɛyatalɛ nɛ kukĩ bidu akũ a, ade finyaa míana kutse a tunu kamɛ funitsã a fudi. ");
INSERT INTO bov_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Foesũ mitasupa bikĩ bitsua bɛnyɛ ndɛ tɛnanɛ aye a. Nde sũ miapia akũ mitsa be? Mite anɛ kĩ tɛnanɛ kɛkɛ mianɛ, nnɛ́ mi nyɛ kutse tunu a, mbom tunu a pini mi. ");
INSERT INTO bov_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Lɛmɛ ɔsa nɔ aalɛ kĩ, “Bitsua tɛnanɛ a bɛnyɛ kĩ yĩ nna nɛ te kadokɔ̃.” ");
INSERT INTO bov_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Fɔnyɛ ɔnɔkɔali. Bitsua te kitonɛkĩ bɛtátɛ bido, ade mina kadzakɔ̃ nɛ mi katɛkado sũ a, foesũ mitapia nɛ foe akũ, mbom mikavila. ");
INSERT INTO bov_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kitonɛkĩ ntɛ Baguma támɔ Yudafɔ a kĩ bɛla ndɛ kutse kpĩĩ a tɛnanɛ a kɔnya ni, ɔkɔna kĩ yaamɔ nɔ kɔnya? ");
INSERT INTO bov_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Dã ayekĩ Baguma deĩ sɛmɛ kalɛ, mɔ ayekĩ edeĩ ɔsĩ. Baguma deĩ ɔsĩ nɛ bikĩ bɛnɛ bɛtɔ akũ, lɛmɛ edeĩ sɛmɛ kalɛ ɛkpa nɔ ntɛ osila odzi nɛ ye sɛmɛ kalɛ a kamɛ. Lɛmɛ ntɛ ɔtádzi lɔmɔ ni, Baguma aatsua nɔ malo ɛnyɛ nɛ kutse a akũ. ");
INSERT INTO bov_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ade ntɛ Yudafɔ a muniki bɛyatɛ Baguma bidoi ni, Baguma aakɔa be ɛdzɛla nɛ be kadzakɔ̃ kɔɛ a, kitonɛkĩ Baguma aapuli ɛkɛna foe. ");
INSERT INTO bov_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mi a kĩ minyɛ́ Yudafɔ a, mila ndɛ lupo kamɛ kugua kutse tɛnanɛ a kĩ bitsua bɛyatalɛ nɛ kugua kutse wĩ a akũ a aye. Yudafɔ a la ndɛ kugua kutse a kĩ bidu a, foesũ fɔlá ɔsĩ fɔkpa Baguma kĩ yaabuki ɛkɔa kugua kutse mɔawɛ tɛnanɛ a kĩ bitsua bɛnyɛ a ɛtalɛ nɛ kutse mɔawɛ a akũ. ");
INSERT INTO bov_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nwaɛ̃ amɛ, ɔnɔkɔali fɔlɛtsa bɛlawa fudi deĩ kĩ mawɛ kĩ minyi, ayekĩ miláabu mi akũ anyansãfɔ. Ade foe nyɛ kĩ Israelfɔ badi atɔ ɔsĩ a aana kɛnaawo kĩ, bati a kĩ bɛnyɛ́ Yudafɔ a, kakã flee ya nɛ Baguma sɛkɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ntɛ fɔya lɔmɔ fuyua a lɔkɔa Yudafɔ a flee aana katɛ, ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Ɔtɛnɛ a aato Zion ɛya. Yaanyɛ ablɔ fɔtsa flee ɛnɛmɛna nɛ Yakob katete a kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Maakɛna bɔhɛ kĩĩ mɔ be, ntɛ ĩnyɛ be tɔkpa nnamɛna.” ");
INSERT INTO bov_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Nɛ Kalɛ Wĩ a akũ kɔ̃ ni, Yudafɔ a dani Baguma bakesĩnɛ nɛ mi a kĩ minyɛ́ Yudafɔ a sũ. Lɛmɛ nɛ Baguma be kapau sũ ni, bɛnyɛ Baguma bakɔba nɛ be bawanyɔ sũ. ");
INSERT INTO bov_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kitonɛkĩ Baguma ládani ye adzuni nɛ oti a kĩ ɛpau ĩye ehila a akũ. ");
INSERT INTO bov_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kɔkɔɛ a, mi a kĩ minyɛ́ Yudafɔ a, mitákɛna nɛ Baguma kawɛ akũ, lɛmɛ finyaa Baguma mɔ mi kɔnya kitonɛkĩ Yudafɔ a na atɔ ɔsĩ. ");
INSERT INTO bov_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ade ayea kɔnya a kĩ Baguma mɔ mi a sũ ni, finyaa Yudafɔ lɛmɛ lákɛna nɛ Baguma kawɛ akũ ayekĩ Baguma aamɔ be malo kɔnya. ");
INSERT INTO bov_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ayekĩ batidziwa flee sĩ kĩ baátse Baguma sũ ni, ɛfɔ̃ bati flee kɛna fɔkɔ katabu kɔla bawanɛ, ayekĩ yaamɔ be flee kɔnya. ");
INSERT INTO bov_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Baguma akũ kana fɔtsa nɛ lidede paa! Ye nyansã mɔ kadikanyi kamɛ dzũ paa! Owei aapuli ɛnyɛ ye kɔtɔkakɔ kamɛ? Owei aapuli enu ye tisi kayɔ? ");
INSERT INTO bov_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Owei nyina boe Ɔlate a adzuni? Owei aapuli ɛkpa ye kɔdɛ? ");
INSERT INTO bov_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Owei lɛkpa Baguma litsedi tɔ̃, ayekĩ yaakɛna ese ye kɔtɔ?” ");
INSERT INTO bov_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kitonɛkĩ Baguma lɛbɔa fɔtsa flee, ye kɔbɛ̃ akũ lɛtsa nyɛ lɛtsa dzi nkpã, ade ye kamɛ lɛmɛ lɛtsa nyɛ lɛtsa aawũna a. Obu mɔ kamu nyɛ Baguma fude daa. Fɔya lɔmɔ. ");
INSERT INTO bov_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Foesũ nwaɛ̃ amɛ, ayekĩ Baguma amɔ boe kɔnya sũ ni, make mi aduli paa kĩ mikɔa mi akũ mikpa Baguma ndɛ afɔliɛ fɔtsa kĩ fudeĩ nkpã, kĩ foe akũ kpalɛ, fɔawo ye anɛ. Ade fukĩĩ nyɛ ayekĩ miasum Baguma nɛ ɔnɔkɔali kamɛ mɔ mi tɔwɔlɛ a. ");
INSERT INTO bov_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mitadzi nkpã ndɛ ayekĩ katinya kĩĩ kamɛ bati adzi nɛ tɔkpa kakɛna kamɛ a, mbom mifɔ̃ Baguma ɛdani mi adzuni ɛkɛna avɔɛ̃ lɔkɔa midani ɔbla. Fɔ́afɔ̃ minyi Baguma kawɛ, fɔtsa a kĩ fɔnɛnɛ, kĩ fɔawo ye anɛ, fɔkpɔla lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Nɛ Baguma kɔnyakamɔ futetsa baũ a kĩ ɛkpa yĩ sũ ni, mabi mi kamɛ odi nyɛ odi kĩ ɛtabu ye tɔnɔkɔɛ̃ ɛba ayekĩ kɛfɛta. Nɛ foe kadokɔ̃ a, ɛkɔna fɔtsa a kĩ fɔatsa akũ kadɔla, lɔkɔa ɛdzɛmɔ ye akũ ɛdã nɛ katɛkado a kĩ Baguma kpa ye a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ayekĩ budeĩ sukɛna fɔkɔ kumɛkumɛ pii nɛ oti mɔawɛ a kamɛ, kĩ fɔakɛna tudzuma futefute a, ");
INSERT INTO bov_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ade ayea titɔ kĩ bati pii bɔanɛ malo ni, oti mɔa bɔanɛ nɛ Kristo kamɛ, kĩ bɔtsamɔ akũ ndɛ sukɛna fɔkɔ futefute nɛ oti mɔa kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Baguma mɔ boe kɔnya, ɛkpa boe futetsa futefute, foesũ mifɔ̃ bɔkɛna foe akũ adzuma nɛ ye kɔnyakamɔ a onukpɛ̃. Ntɛ boe futetsa nyɛ Baguma fɔlɛtsa onukpɛ̃ kanyɛ ni, kɛnɛ kĩ bɔakɛna nɛ katɛkado a kĩ budeĩ a onukpɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ntɛ boe futetsa nyɛ kĩ busum bati ni, kɛnɛ kĩ busum be ayekĩ kɛfɛta, ntɛ futetsa nyɛ fɔtsa katsa ni, kɛnɛ kĩ bɔtsa fɔtsa. ");
INSERT INTO bov_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ntɛ fɔnyɛ bati ɔwɔlɛ kɔbɛ̃ kado ni, kɛnɛ kĩ bɔkɛna foe. Odi nyɛ odi kĩ yakpa bati fɔtsa ni, ɛkɛna foe mɔ ɔwɔlɛ faa. Odi nyɛ odi kĩ ɛdzɛ̃ nɛ bati onukpɛ̃ ni, kɛnɛ kĩ ɛkɛna adzuma mɔ ɔsĩ, ade odi nyɛ odi kĩ yakɛna sɛmɛ kalɛ kakɛna ni, kɛnɛ kĩ ɛkɛna foe mɔ anɛ kakpalɛ. ");
INSERT INTO bov_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Miwɛ akũ kalɛ nɛ ɔnɔkɔali kamɛ. Mikesĩ tɔkpa, lɔkɔa mipi fɔtsa wĩ midomɔ akũ. ");
INSERT INTO bov_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Miwɛ akũ akũ kalɛ ndɛ bawaɛ̃ nɛ Kristo kamɛ aye, ade odi nyɛ odi ɛbɔa mbɔdi ɛkɔa obu ɛkpa ɔwaɛ̃ a. ");
INSERT INTO bov_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Mikɛna adzuma mɔ ɔsĩ ade mitana ɔnyɔnɛ a. Misum boe Ɔlate a mɔ ɔwɔlɛ kamɛ kɔbɛ̃. ");
INSERT INTO bov_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Mifɔ̃ mi kɔnɛte a kɔkpã mi nɛ kawɔlɛ kamɛ. Mina ɔwɔlɛ bɔɛɛ nɛ mi ɔhau kamɛ, mikaabɔa mpaɛ daa daa. ");
INSERT INTO bov_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Mibumɔ asɔli bati a kĩ badi ahiã a, ade mitɛ banɔvɔɛ̃ faa nɛ mi tɔtɔ kamɛ a. ");
INSERT INTO bov_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Miwã Baguma kĩ ehila bikĩ bitomɔ mi liti a. Mivia kĩ ehila be, ɛtadum be. ");
INSERT INTO bov_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Mimɔ kawɔlɛ mɔ bikĩ bamɔ kawɔlɛ, ade mibe mɔ bikĩ babe lɛmɛ a. ");
INSERT INTO bov_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mina nɛ adzuni mɔapɛ kamɛ mikpa odi nyɛ odi. Mitapia akũ, mbom mikɛna tɔkɔba mɔ bikĩ bɛdɔla be akũ kĩ bati lábu nɛ lɛtsama kamɛ a. Mitabu mi akũ kĩ minyina kadi. ");
INSERT INTO bov_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ntɛ oti odi fum nɔ ni, takɔa tɔkpa ose ye kɔtɔ. Mibɔa mbɔdi mikɛna lɛtsa kĩ odi nyɛ odi abu kĩ lɛnɛnɛ a. ");
INSERT INTO bov_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ntɛ fɔ́alɛ kakɛna, mɔ fɔ́ato mi sɛkɛ̃ ni, mimɔ odi nyɛ odi midzi nɛ lukudɔ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nwaɛ̃ amɛ, mitakɛna odima tɔkpa mise kɔtɔ da, mbom mifɔ̃ Baguma kalɔkpa kɛkɛna foe. Kitonɛkĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, Ɔlate a lɛ kĩ, “Yĩ aavɛlɛ sɔtɔ, yĩ aakɛna nse kɔtɔ.” ");
INSERT INTO bov_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Lɛmɛ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Ntɛ kɔlɛ akɔ nɔ okesĩnɛ ni, kpa ye funitsã ɛnya. Ntɛ ɔmɔado akɔ ye ni, kpa ye mui ɛmɔa. Kitonɛkĩ ntɛ ɔkɛna fukĩĩ ni, aafɔ̃ kɔnyɔã liwo ye paa.” ");
INSERT INTO bov_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Tafɔ̃ tɔkpa lɛnya nɔ akũ, mbom kɔa tuwĩ kanya tɔkpa akũ. ");
INSERT INTO bov_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Kɛnɛ kĩ odi nyɛ odi ebu ɔmaĩ akũ banyanɛ, kitonɛkĩ otumi odima lɛláa kĩ ɛtáto Baguma sɛkɛ̃, ade ɔmaĩ akũ banyanɛ a kĩ bidzi finyaa a, Baguma lidzina be. ");
INSERT INTO bov_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Foesũ odi nyɛ odi kĩ eyidza ɛdza nɛ ɔmaĩ akũ banyanɛ otumi akũ a, yidza ɛdza nɛ lɛtsa a kĩ ehihiɛ eyi a akũ. Ade odi nyɛ odi kĩ yakɛna lɔmɔ a, aavɛlɛ kɔtɔkaku ɛkpa ye mɔawɛ. ");
INSERT INTO bov_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Bati a kĩ bakɛna tuwĩ a, lávila bati akũ banyanɛ, mbom bikĩ bakɛna tɔkpa a avila be. Ɔwɛ kĩ bati akũ ɔnyanɛ ɛtahũnahũna nɔ? Kekɔ̃ kɛna lɛtsa a kĩ lɛnɛnɛ, lɔkɔa yaamu nɔ. ");
INSERT INTO bov_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kitonɛkĩ bati akũ ɔnyanɛ a nyɛ Baguma ɔsumunɛ kĩ yakɛna adzuma ɛkpa nɔ kalɛ. Lɛmɛ ntɛ ɔkɛna tɔkpa kɔ̃ ni, kekɔ̃ vila ye, kitonɛkĩ edeĩ kɔbɛ̃ kĩ yavɛlɛ sɔtɔ ndɛ ayekĩ kɛfɛta. Baguma fɔtɔ ɔnyanɛ yanɛ, ade yadã kĩ bɛkpa bikĩ bɛkɛna tɔkpa a Baguma sɔtɔ kavɛlɛ a. ");
INSERT INTO bov_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Nɛ fukĩ sũ ni, kɛnɛ kĩ oti adɔla akũ ɛkpa ɔmaĩ akũ banyanɛ a, nnɛ́ nɛ Baguma sɔtɔ kavɛlɛ odi sũ, mbom ayekĩ oti ɔwɔlɛ fɔ̃ enyina tuwĩ a sũ. ");
INSERT INTO bov_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ade fukĩĩ lɛmɛ sũ miase ɔmaĩ tɔgɔlɛ a, kitonɛkĩ ɔmaĩ akũ banyanɛ a akɛna adzuma kakpa Baguma ntɛ bɛkɛna be tudzuma tɛkpɔla. ");
INSERT INTO bov_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Foesũ mise be lɛtsa a kĩ midzimɔ be a. Mise ɔgɔlɛ mɔ dutɛ mikpa bikĩ kɛfɛta. Mivila oti a kĩ kɛnɛ kĩ bivila a, ade mibu oti a kĩ kɛnɛ kĩ bɛkpa obu a. ");
INSERT INTO bov_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Mitadzimɔ odima kɔtɔ, kɔtɔ a kĩ miadzimɛna a nyɛ kĩ miwɛ mi akũ akũ kalɛ. Odi nyɛ odi kĩ ɛwɛ ɔwaɛ̃ kalɛ ni, ɛkɛna nɛ Baguma mbla a flee akũ. ");
INSERT INTO bov_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Mbla a kĩ Baguma kpa a lɛ kĩ, “Tabɔa adɔpaa, takɔ oti, taye, tayɔɔlɛ anɛ nɛ nɔ ɔkɔba fɔtsa akũ,” mɔ tɛbɛbã a kĩ tibu a flee boomu nɛ mbla mɔapɛ kamɛ kĩ, “Wɛ nɔ ɔkɔba kalɛ ndɛ ayekĩ awɛ nɔ akũ kalɛ a.” ");
INSERT INTO bov_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ntɛ awɛ odi kalɛ ni, ɔláakɛna tɔkpa nɛ ye akũ, foesũ ɔdɔ nyɛ mbla a flee akũ kakɛna. ");
INSERT INTO bov_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Kɛnɛ kĩ miakɛna fukĩĩ, kitonɛkĩ minyina kĩ lɔkɔ wo ɔtɔ kĩ mianyinya nɛ tida kamɛ. Kitonɛkĩ lɔkɔ a kĩ Baguma aatɛ boe a nkpã fuã finyaa lɛba lɔkɔ a kĩ bɔnya lɔtɔ bɔtɛ Kristo budo a. ");
INSERT INTO bov_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Lɛnyɛ lɔkɔ tɛ̃ liyua, kade lamɛna kanyina. Mifɔ̃ bɔfɔ̃ ɔtũ kamɛ fɔtsa kakɛna, lɔkɔa bɔbɔɛ kawũ kanɔ fɔtsa bɔbla bɔkpa kanɔ nɛ ɔhaĩ kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mifɔ̃ bupi boe akũ kapi wĩ ndɛ bati kĩ bidzi nɛ ɔhaĩ kamɛ. Mitafɔ̃ bɔna nɛ kanya mɔ futo kawɔlɛ mɔ bavɛ kawuga kamɛ, ĩye adɔpaa kabɔa, ĩye ablɔ kadi, ĩye kapaa mɔ anɛngbã kakɛna kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Mbom mibɔɛ boe Ɔlate Yesu Kristo kawũ fɔtsa mido ndɛ atadiɛ aye, lɔkɔa mifɔ̃ mi sukɛna akũ kadã kakɔna miyaadani se odo fɔtsa akũ bakɛnanɛ. ");
INSERT INTO bov_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Mitɛ oti a kĩ ɛtátim nɛ katɛkado kamɛ a mido nɛ mi kamɛ faa, mitavɛlɛ fɔlɛtsa mɔ ye nɛ lɛtsa kĩ kɛnɛ kĩ ɛkɛna mɔ likĩ kɛtáfɛta kĩ ɛkɛna a akũ. ");
INSERT INTO bov_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Oti odi katɛkado kpa ye osi kĩ ɛnya funitsã fudi nyɛ fufudi, lɛmɛ oti a kĩ ye katɛkado tátim a kɔ̃ anya kɔba kamɛ funitsã odi. ");
INSERT INTO bov_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Oti a kĩ yanya lɛtsa nyɛ lɛtsa a, ɛtasupa oti a kĩ yaánya foe. Ade oti a kĩ yanya kɔba funitsã odi a, ɛtadzɛmɔ ekĩ yanya lɛtsa nyɛ lɛtsa, kitonɛkĩ Baguma tɛ ye. ");
INSERT INTO bov_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Owei anɛ kĩ adzɛmɔ oti bɛbã ɔsumunɛ? Ye mɔawɛ ɔlate aamɔ ntɛ ɛdzɛ̃ pintii ĩye ɛtɔ. Lɛmɛ yaanya akũ kitonɛkĩ boe Ɔlate a aapuli ɛkɛna ye ɛdza pintii. ");
INSERT INTO bov_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Oti odi abu kĩ luwi lidi sĩ lɛba fuwi bɛbã a, ade odi lɛmɛ adã kĩ fuwi a flee keti a. Nɛ fukĩĩ odu akũ a, odi nyɛ odi ɛdza pintii nɛ kakɔ mɔa. ");
INSERT INTO bov_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Odi nyɛ odi kĩ ebu luwi lidi paa ni, ɛkɛna foe kĩ yado boe Ɔlate a obu. Ade ayea odi nyɛ odi kĩ yaánya funitsã fudi a, kɛna foe kĩ yado boe Ɔlate a obu, ade yanyɛ Baguma kɔlɛ nɛ foe akũ a. ");
INSERT INTO bov_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Boe kamɛ odima lidzí nkpã ɛkpa ye akũ odi, ade boe kamɛ odima láku lɛmɛ kakpa ye akũ odi a. ");
INSERT INTO bov_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ntɛ budzi nkpã ni, boe Ɔlate a budzi bɔkpa, ade ntɛ buku a, boe Ɔlate a buku bɔkpa. Foesũ ntɛ budzi nkpã o-o ĩye buku o-o, boe Ɔlate a bade bɔanɛ. ");
INSERT INTO bov_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Ade fukĩĩ sũ mɔ Kristo ku, ade eyidza edzi nkpã ayekĩ yaanya bikĩ bidzi nkpã mɔ bikĩ biku a Ɔlate a. ");
INSERT INTO bov_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ade nɔ kɔ̃, nde sũ akɔ awaɛ̃ kɔtɔ? Ĩye nɔ malo nde sũ asupa awaɛ̃? Boe a flee bɔ́adza nɛ Baguma anɛ kamɛ lɔkɔa ɛdzɛmɔ boe. ");
INSERT INTO bov_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kitonɛkĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, “Ɔlate a lɛ kĩ, ‘Kĩ ndzi nkpã kĩĩ a, odi nyɛ odi aake aduli ɛkpa yĩ, ade odi nyɛ odi aabinya onukpɛ̃ ɛlɛ kĩ yĩ nyɛ Baguma a.’ ” ");
INSERT INTO bov_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Foesũ boe kamɛ odi nyɛ odi aakpa Baguma ye mɔawɛ akũ akunta. ");
INSERT INTO bov_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Foesũ mifɔ̃ bɔfɔ̃ akũ akũ kadzɛmɛna, kakɔ kɔtɔ. Fukĩ miakɛna nyɛ kĩ mikɛna adzuma kĩ miláakɛna lɛtsama kĩ fɔ́afɔ̃ awaɛ̃ lɛtɔ ĩye fɔfɔ̃ ɛkɛna tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Yĩ ɔmɔa kakɛna mɔ boe Ɔlate Yesu sũ, ntɛ ndo kĩ funitsã fudima nɛ foe akũ akũ lɛnyɛ́ efĩĩ fɔtsa. Lɛmɛ ntɛ odi tɛ edo kĩ funitsã fudi akũ tákpalɛ ni, kekɔ̃ fɔkɛna efĩĩ fɔtsa fɔkpa ye. ");
INSERT INTO bov_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ntɛ nɔ funitsã kĩ anya sũ awaɛ̃ tɛ kalɔɛ ni, kekɔ̃ nnɛ́ ɔdɔ kamɛ ɔtsɛ̃mɔ ye. Tafɔ̃ funitsã a kĩ anya a lɛwɔla oti a kĩ ye lɔlɔ Kristo ku a. ");
INSERT INTO bov_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Foesũ mitafɔ̃ bati bɛbã lisupa fɔtsa a kĩ mi miakɔna kĩ fɔnɛnɛ a. ");
INSERT INTO bov_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kitonɛkĩ Baguma lɛgãkanya a lɛnyɛ́ kanya mɔ kamɔa, mbom fɔnyɛ tuwĩ kakɛna mɔ lukudɔ, mɔ kawɔlɛ kĩ Hũhũ Kpalɛwa a akpa a. ");
INSERT INTO bov_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ade ntɛ odi asum Kristo nɛ osi kĩĩ akũ a, yawo Baguma anɛ ade bati lɛmɛ akpa ye obu a. ");
INSERT INTO bov_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Foesũ mifɔ̃ boe botaɛ ɛnya kĩ bɔakɛna lɛtsa a kĩ layamɛna lukudɔ, titiliwu mɔ fukĩ fɔ́abumɛna akũ akũ. ");
INSERT INTO bov_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Mitabula Baguma adzuma kade nɛ funitsã sũ. Nɛ ɔnɔkɔali kamɛ ni, funitsã flee akũ kpalɛ fɔkpa kanya, lɛmɛ fɔnɛ́nɛ kĩ banya lɛtsa kĩ laha odi fɔfɔ̃ ɛkɛna tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Lɛtsa wĩde nyɛ kĩ taba sɛkɛna ĩye ɔmɔa waĩ ĩye akɛna lɛtsa bɛbã lidima kĩ fɔ́afɔ̃ awaɛ̃ lɛkɛna tɔkpa. ");
INSERT INTO bov_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Fɔ̃ lɛtsa a kĩ ɔtɛ odo nɛ fɔtsa kĩĩ akũ a, fɔna nɛ mimɔ nɔ Baguma odi kayite. Baguma hila oti a kĩ ɛtákɔ ye akũ kɔtɔ nɛ lɛtsa a kĩ ɛkɛna, ɛmɔ kĩ lɛnɛnɛ a sũ. ");
INSERT INTO bov_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Lɛmɛ ntɛ odi anya lɛtsa kĩ ye ɔwɔlɛ tákpa ye osi a, Baguma akɔ ye kɔtɔ, kitonɛkĩ lɛtsa a kĩ ɛkɛna a táto katɛkado kamɛ. Lɛtsa nyɛ lɛtsa kĩ oti akɛna kĩ fɔtáto katɛkado kamɛ ni, tɔkpa tanɛ. ");
INSERT INTO bov_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Kɛnɛ kĩ boe a kĩ budeĩ ɔsĩ nɛ katɛkado kamɛ a, bɔabumɔ bati a kĩ be katɛkado lɛlá ɔsĩ a nɛ be ɔhau kamɛ. Kɛtánɛ kĩ bɔakɛna lɛtsa a kĩ laawo boe mɔawɛ anɛ. ");
INSERT INTO bov_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Mifɔ̃ boe kamɛ odi nyɛ odi ɛkɛna lɛtsa a kĩ laawo boe bakɔba anɛ ayekĩ fɔ́alɛ fɔkpa be, bitim nɛ be katɛkado kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kitonɛkĩ Kristo malo tákɛna fɔtsa a kĩ fuwo ye anɛ, mbom ndɛ ayekĩ bɛtsɛlɛ nɛ Katsɛlɛ Kpalɛwa a kamɛ kĩ, Kristo bi Baguma kĩ, “Fuvũnatsa a kĩ bɛta bɛkpa nɔ a, yako nɛ yĩ akũ.” ");
INSERT INTO bov_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ade lɛtsa nyɛ lɛtsa a kĩ bɛtsɛlɛ biyi nɛ Katsɛlɛ Kpalɛwa a kamɛ a, bɛtsɛlɛ foe batsa boe fɔtsa, kĩ bɔkɔa ɔwɔlɛ bɔɛɛ mɔ Baguma fɔlɛtsa bɔdza pintii, budo ɔwɔlɛ bɔna lɛtsa a kĩ bɔadã anɛ a. ");
INSERT INTO bov_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Baguma a kĩ ye nyɛ ɔwɔlɛ bɔɛɛ mɔ kɔbɛ̃ kado katokɔ̃ a, ɛfɔ̃ mina onukpɛ̃ mɔa nɛ mi kamɛ, mitomɔ Kristo Yesu osi a kĩ ɛtsa a, ");
INSERT INTO bov_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ayekĩ mi flee míakɔa ɔwɔlɛ mɔa mɔ odo mɔa mimu Baguma, kĩ ɛnyɛ boe Ɔlate Yesu Kristo Ɔlɛga a. ");
INSERT INTO bov_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Foesũ mitɛ mi bawaɛ̃ ndɛ ayekĩ Kristo tɛ mi a, fɔnya obu fɔkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Mabi mi kĩ Kristo yakɛna Yudafɔ a ɔsumunɛ, ɛkɔa ɛtsa kĩ Baguma adi ɔnɔkɔali, lɔkɔa ete de nɛ bɔhɛ a kĩ Baguma kɛna mɔ Yudafɔ bawanyɔ a akũ, ");
INSERT INTO bov_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ayekĩ bikĩ bɛnyɛ́ Yudafɔ a lɛmɛ aamu Baguma nɛ ye kɔnyakamɔ sũ. Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Nɛ foesũ maamu nɔ nɛ bikĩ bɛnyɛ́ Yudafɔ a kamɛ. Maasã kamu tɔnɔ ndɛla nɔ dĩ nɛ ode.” ");
INSERT INTO bov_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ade bibuki bɛtsɛlɛ biyi kĩ, “Mi a kĩ minyɛ́ Yudafɔ a, mimɔ kawɔlɛ mɔ Baguma bade a.” ");
INSERT INTO bov_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Katsɛlɛ bɛbã lɛ kĩ, “Mi a kĩ minyɛ́ Yudafɔ a flee mimu boe Ɔlate a. Mi fude fude flee mimu ye!” ");
INSERT INTO bov_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Ade Yesaya lɛmɛ lɛ kĩ, “Isai kasinu a kamɛ obi odi aanɛ ɛta, ye aayanya bikĩ bɛnyɛ́ Yudafɔ a akũ. Ade ye akũ baakɔa anɛ bite a.” ");
INSERT INTO bov_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Baguma a kĩ ye akũ bɔate anɛ a ɛfɔ̃ kawɔlɛ mɔ lukudɔ lɛtɛ mi kamɛ nɛ mi ye katɛkado sũ, ayekĩ mi kɔnɛte a aakabo anɛ nɛ Hũhũ Kpalɛwa kɔbɛ̃ a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Nwaɛ̃ amɛ, yĩ mɔawɛ a ntɛ ndo paa kĩ fɔtsa wĩ kakɛna tɛ mi kamɛkamɛ, ade minyina kadi pii kĩ míapuli midɛ akũ akũ. ");
INSERT INTO bov_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Lɛmɛ nɛ ovoli kĩĩ kamɛ a, ndo ɔwɔlɛ ntsɛlɛ fɔtsa fudi faa kĩ mabuki nkɔa nkai mi foe. Ndo ɔwɔlɛ kitonɛkĩ Baguma mɔ yĩ kɔnya ɛkɔa adzuma kĩĩ edo yĩ nɛ awɛ, ");
INSERT INTO bov_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","kĩ ĩnya Kristo Yesu ɔsumunɛ nkɛna adzuma nkpa bikĩ bɛnyɛ́ Yudafɔ a. Nkɛna adzuma ndɛ ɔsɔfɔ nkalɛ Baguma Kalɛ Wĩ a, ayekĩ bikĩ bɛnyɛ́ Yudafɔ a aakɛna ndɛ afɔlibɔ wĩ kĩ Hũhũ Kpalɛwa kpalɛ ye akũ ɛkpa Baguma. ");
INSERT INTO bov_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Foesũ yĩ ɔmɔa kakɛna mɔ Yesu Kristo sũ ni, maapuli mpia nɛ adzuma a kĩ nkɛna nkpa Baguma a akũ. ");
INSERT INTO bov_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Lɛtsa a kĩ odi maado ɔwɔlɛ nlɛ nyɛ kĩ Kristo tsã yĩ akũ ɛfɔ̃ bikĩ bɛnyɛ́ Yudafɔ na osetie nɛ Baguma fɔlɛtsa akũ. Ɛkɛna fukĩĩ ɛtsãmɛna yĩ fɔlɛtsa a kĩ nlɛ, mɔ adzuma a kĩ nkɛna a kamɛ. ");
INSERT INTO bov_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Fukĩĩ ya nɛ foe kamɛ nɛ awãwã mɔ nsɛntsɛlɛni fɔtsa a kĩ nkɛna, nɛ Hũhũ Kpalɛwa a kɔbɛ̃ a kamɛ. Foesũ ntsã mmini nto Yerusalem nnawo Iliriko tite akũ a, nde lɛtsã nɛ Kristo Kalɛ Wĩ a akũ ntsɛna tɛmatɔ a flee. ");
INSERT INTO bov_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Yĩ kawɛ mɔ ɔsĩ nyɛ kĩ made lɛtsã nɛ Kalɛ Wĩ a akũ nɛ awã kĩ bati tánu tɔ̃ Kristo dĩ, ayekĩ nlánake nte nɛ litekũ kĩ odi nya lɔtɔ eke a akũ. ");
INSERT INTO bov_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ndɛ ayekĩ Katsɛlɛ Kpalɛwa a lɛ kĩ, “Bati a kĩ bɛtábi be kadima nɛ ye akũ tɔ̃ a, aamɔ ye, ade bikĩ bɛtánu tɔ̃ kadima nɛ ye akũ a, aanu foe kayɔ.” ");
INSERT INTO bov_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ade foesũ nkawɛ lɔkɔ pii kĩ maya nɛ mi sɛkɛ̃, mɔ ntána osi a. ");
INSERT INTO bov_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Lɛmɛ finyaa kĩ ĩyua yĩ adzuma nɛ fuyite kĩĩ, mɔ ayekĩ nkawɛ futeli pii kĩ mayaasɛla mi a sũ ni, ");
INSERT INTO bov_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","matɛ kado kĩ maapuli nkɛna foe finyaa. Mawɛ kĩ ntɛ ĩyaatɛ̃ nnnaa Spania, maadza nɛ mi sɛkɛ̃ sukuloo budo akũ kawɔlɛ, lɔkɔa mibumɛna minyɛ yĩ osi nnaa. ");
INSERT INTO bov_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Finyaa kɔ̃ ni, manaa Yerusalem nkɔa futelitsa fudi mma Baguma bade a nɛ awã. ");
INSERT INTO bov_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Kitonɛkĩ Makedonia mɔ Akaia tɛsɔli a te fɔtsa faa kĩ bakɔa bibumɛna ahiãfɔ a kĩ bideĩ nɛ Baguma bade a kamɛ nɛ Yerusalem. ");
INSERT INTO bov