﻿USE sofia;
DROP TABLE IF EXISTS sofia.bou_vpl;
CREATE TABLE bou_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bou_vpl WRITE;
INSERT INTO bou_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitabu cha mazina ya wantu wa kolwa da Yesu Klistu mwana Daudi mwana wa Ibulahimu. ");
INSERT INTO bou_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu nekamvyaa Isaka na Isaka akamvyaa Yakobo na Yakobo akamvyaa Yuda na wanduguze. ");
INSERT INTO bou_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda akamvyaa Pelesi na Zela, ambao mami yao nee ni Tamali, Pelesi akamvyaa Eziloni na Hesiloni akamvyaa Alamu. ");
INSERT INTO bou_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu akamvyaa Aminadabu na Aminadabu akamvyaa Nashoni na Nashoni akamvyaa Salimoni. ");
INSERT INTO bou_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni akamvyaa Boazi, na mami yakwe Boazi nee ni Lahabu, na Boazi akamvyaa Obedi, na mami yakwe Obedi nee ni Luti, na Obedi akamvyaa Yese. ");
INSERT INTO bou_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nae Yese akamvyaa Seuta Daudi. Daudi akamvyaa Selemani, mami yakwe Selemani ni yuda ekuwae mkaza Ulia. ");
INSERT INTO bou_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani akamvyaa Lehoboamu na Lehoboamu akamvyaa Abiya na Abiya akamvyaa Asa. ");
INSERT INTO bou_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa akamvyaa Yehoshafati na Yehoshafati akamvyaa Yolamu na Yolamu akamvyaa Uzia. ");
INSERT INTO bou_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia akamvyaa Yosamu na Yosamu akamvyaa Ahazi na Ahazi akamvyaa Ezekia. ");
INSERT INTO bou_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia akamvyaa Manase na Manase akamvyaa Amoni na Amoni akamvyaa Yosia. ");
INSERT INTO bou_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia akamvyaa Yekonia na wanduguze. Kisingi cha kusamizwa kwa Wayahudi kuita si ya Babeli. ");
INSERT INTO bou_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bada ya kusamizwa na kuita mwe si ya Babeli, Yekonia akamvyaa Shealitieli na Shealitieli akamvyaa Zelubabeli. ");
INSERT INTO bou_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli akamvyaa Abiudi na Abiudi akamvyaa Eliakimu na Eliakimu akamvyaa Azoli. ");
INSERT INTO bou_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli akamvyaa Sadoki na Sadoki akamvyaa Akimu na Akimu akamvyaa Eliudi. ");
INSERT INTO bou_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi akamvyaa Eliazali, na Eliazali akamvyaa Matani na Matani akamvyaa Yakobo ");
INSERT INTO bou_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo akamvyaa Yusufu muume da Malia ekuwae mami yakwe da Yesu etangwaye Klistu. ");
INSERT INTO bou_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Naho kuvokea Ibulahimu adi kubua kwa seuta Daudi, nee kuwa na vivyazi kumi dimwe na nne, naho tangia Seuta Daudi hadi Wayahudi wekudoigwaho kuita Babeli nee kuwa na vivyazi kumi dimwe na nne. Naho kuvokea kisingi wekusamizwaho adi kuvyaigwa kwa Yesu Klistu nee kuwa na vivyazi kumi dimwe na nne. ");
INSERT INTO bou_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naho kuvyaigwa kwa Yesu Klistu nekuwa ivi, Malia mami yakwe ekuwaho kaombwa na Yusufu. Akini kisingi khawazati kuteguana akaoneka ana ifu kwa udaho wa Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwaviya Yusufu, ekuwaye akunda kumtegua Malia nekawa mntu yedi, khekukunda kumgea soni hemeso ya wantu, ivyo akakunda kumbada kwa sii. ");
INSERT INTO bou_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ekuwaho akamamakhanya mbui iyo, mndima wa uko uwanga kwa Muungu wa Zumbe akamwawiiya mwe sozi, nakumwamba “Yusufu mwana Daudi wesekuogoha kumdoa Malia atende mkazio mana kenua ifu kwa udaho wa Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Endaavyae mwana kigosi na wendaumwekhe zina da Yesu, kwa viya yee nee mwendae awaohoe wantu wakwe kulawa mwe mavigaviga yao.” ");
INSERT INTO bou_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naho aya yose yalawiiya ili iiganie ida mbui ya Zumbe ekugombekayo kwembokea kwa muoni wa Muungu ");
INSERT INTO bou_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kauwa mvyee mwenye kiwaa endaenue ifu. Na kuvyaa mwana kigosi, nae endaetangwe Imanueli” mana yakwe, “Muungu hamwe na swie.” ");
INSERT INTO bou_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naye Yusufu ekwenukaho mwe usisiza akagosoa inga mndima wa uko uwanga kwa Muungu wa Zumbe ekumwambavyo, akamdoa mkaziwe adi kaya. ");
INSERT INTO bou_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Akini khekugonana nae adi Maliamu ekuvyaaho mwana kigosi. Na Yusufu akamwekha zina da Yesu. ");
INSERT INTO bou_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kavyaigwa mwe mzi wa Betilehemu phande ya Uyahudi, kisingi cha ugookezi wa Seuta Helode. Ekuvyaigwaho du, wamanyi wa ntoondo kulawa awiyo da zua wakabua mzi wa Yelusalemu, ");
INSERT INTO bou_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wakauza, “Yuhahi mwana, mwekuvyaigwa, endaeawe Seuta wa Wayahudi?, Kwaviya tiiyona ntoondo yakwe yekulawiiyaho awiyo da zuwa na swie teza kumvika.” ");
INSERT INTO bou_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Seuta Helode ekuyategeezaho ayo, yee na wantu wose wa mzi wa Yelusalemu wakatozwa ni maatu. ");
INSERT INTO bou_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Naho akawetanga hamwe, waviki wakuu wose na wahinyi wa miko ya Muungu ekumwekhayo Musa akawauza, “Klistu avyaigwa hahi?” ");
INSERT INTO bou_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wowo wakamtambaisa, “Avyaigwa mwe mzi wa Betilehemu, uko Uyahudi.” Inga muoni wa Muungu ekuandikavyo, ");
INSERT INTO bou_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Wee Betilehemu si ya Uyahudi, Wee khio mdodo katu mwe mizi mikuu ya si ya Yudea Kwaviya aho hako endaalawiiye Seuta mwendae awagookee wantu wangu wa Isilaeli.’ ” ");
INSERT INTO bou_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aho Helode akawetanga kandani awo wamanyi wa ntoondo akawauza, asa kisingi ida ntoondo yekuwalawiiyaho. ");
INSERT INTO bou_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naho akawaagiiya waite mwe mzi wa Betilehemu akawamba, “Hitani mkasunguumanye kwa vitana mbui za mwana uyo, mkabinda kumanya mbui zakwe niyeteani mbui zakwe na miye niite nikamvike.” ");
INSERT INTO bou_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wekubindaho kumtegeeza seuta, awo wamanyi wa ntoondo wakahauka, wakaongweewa na ida ntoondo wekuiyonayo awio da zua adi hantu hada hekuwaho yuda mwana, ");
INSERT INTO bou_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wenye umanyi wekuonaho ida ntoondo igooka nawo wakawa na nyemi muno. ");
INSERT INTO bou_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wakengia mda nyumbani, wakamwona yuda mwana hamwe na Malia mami yakwe wakakinta mavindi, wakamvika. Naho wakavugua sanduku na kulavya funge zao, zahabu na ubani na mzigi kwaajii ya wana wekwetangwao manemane. ");
INSERT INTO bou_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ivyo wakauya mwe si yao kwa sia ntuhu, kwaviya Muungu nee kawahaza mwe sozi wasekuuya kwa Helode. ");
INSERT INTO bou_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wamanyi wa ntoondo wekuhaukaho mndima wa uko uwanga kwa Muungu wa Zumbe akamuawiiya Yusufu mwe sozi akagombeka, “Hauke, mdoe mwana hamwe na mami yakwe mnyiikie Misili. Mwekae uko adi nendaho nikugombeke vituhu, kwaviya Helode aondeza kumkoma uyu mwana.” ");
INSERT INTO bou_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ivyo, Yusufu akenuka, akamdoa mwana hamwe na mami yakwe wakahauka na kio akaita Misili. ");
INSERT INTO bou_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akekaa uko hadi Helode ekuuyaho na nyuma mbui iyo igosoka inga ekwambavyo Zumbe kwa sia ya muoni wakwe iiganie, “Khimwetanga mwanangu kulawa Misili.” ");
INSERT INTO bou_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode ekumanyaho wada wamanyi wa ntoondo wamtiiya akakimwa muno. Akaagiiya wana wose wa kigosi wa mzi wa Betilehemu na mizi yose yekuwayo hehi yakwe, kuvokea mwana wa msi umwe adi myaka miidi wakomwe. Bada ya kumanya mbui izo kulawa kwa wada wamanyi wa ntoondo. ");
INSERT INTO bou_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nee yekuiganiaho mbui yekugombekwayo kwa sia ya muoni Yelemia, ");
INSERT INTO bou_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mgutio wa ndio na mabwaimbo vitegeezeka uko Lama. Laheli awaiiya wana wakwe, Nahodu khakunda kugewa moyo kwaviya wose wakomwa.” ");
INSERT INTO bou_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helode ekuuyaho na nyuma mndima wa uko uwanga kwa Muungu wa Zumbe akamuawiiya Yusufu mwe sozi kuda Misili, ");
INSERT INTO bou_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamwamba, “Enuka! Mdoe mwana hamwe na mami yakwe, uuye vituhu mwe si ya Isilaeli kwaviya wada wekukundao kumkoma mwana uyo khawana ugima vituhu.” ");
INSERT INTO bou_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naho Yusufu ekwenukaho, akamdoa mwana hamwe na mami yakwe akauya mwe si ya Isilaeli. ");
INSERT INTO bou_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Akini Yusufu ekusikiaho kuwa Alikelao mwanawe da Helode nekawa seuta wa si ya Yudea hantu hatati yakwe akaogoha kuita uko. Naho bada ya kuemezwa mwe sozi akaita phande za Galilaya, ");
INSERT INTO bou_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akasamia mwe mzi wetangwao Nazaleti. Nee ivyo yekuiganiavyo mbui zekugombekwazo kwa sia ya Waoni wa Muungu, “Endaetangwe mntu wa Nazaleti.” ");
INSERT INTO bou_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Misi ziya Yohana Mbatiiza keza akibiikia mwe nyika ya Uyahudi na akigombeka, ");
INSERT INTO bou_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mhitukieni Muungu na mbade mavigaviga yenu kwamana useuta wa uwanga kwa Muungu uhehi.” ");
INSERT INTO bou_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana uyu ni yuda mwekutamwiiwaye na muoni Isaya ekwambaho, “Mgutio wa mntu wetanga mwenyika ‘Mgosoeyani Zumbe sia yakwe Nyooshani myemboko yakwe.’ ” ");
INSERT INTO bou_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana nee kavaa gwanda dekufumwado kwa mazoya ya mnyama etangwae ngamia na mkwiji wa babu mwe kigudi. Khande yakwe neiwa sige na woki. ");
INSERT INTO bou_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Naho wantu wakamtimia kulawa mzi wa Yelusalemu, na phande zose za Uyahudi na mizi ya khandakhanda ya zigizigi da mazi da Yolodani. ");
INSERT INTO bou_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nawo wakagombeka mavigaviga yao na kubatiizwa mwe zigizigi da mazi da Yolodani. ");
INSERT INTO bou_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Akini ekuwaonaho Mafalisayo na Masadukayo wangi wamwezea wakunda kubatiizwa, nee awamba, “Nywie uvyazi wa nyoka! Nindai mwekuwahaza mguuke maya yezayo? ");
INSERT INTO bou_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Naho oneshani kwa ntendwa zenu kuwa mumhitukia Muungu na kubada mavigaviga inga mti uvyaao matunda matana. ");
INSERT INTO bou_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Naho msekumamakhanya mwe mioyo yenu na kweamba tinae tate ni Ibulahimu. Kwaviya nawamba kwei Muungu adaha kuyagosoa maiwe aya yawe wana wa Ibulahimu. ");
INSERT INTO bou_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na hoya diikwa kae mwe mazindo ya miti ivyo kia mti wesaokuvyaa matunda matana wendausengwe na kwasigwa mwe moto. ");
INSERT INTO bou_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mie nawabatiiza kwa mazi kwaviya mhituka na kubada mavigaviga. Akini mwe mgongo wangu eza yee mwenye udaho kusima miye, ambae khikundigwa katu kwenua sabana zakwe. Yee enda awabatiize kwa Muye wa Muungu na kwa moto. ");
INSERT INTO bou_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana kiheo mwe mkono wakwe, nae endaahagie hantu ha kuhetea, na kukusanya ubosi wakwe na kuuika mwe taa na mafusi endaayoke moto wesaokukomeka.” ");
INSERT INTO bou_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naho kisingi icho Yesu akalawa mzi wa Galilaya akabua mwe zigizigi da mazi da Yolodani akamtimia Yohana ambatiize. ");
INSERT INTO bou_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Akini Yohana akaemea akamba, “Mie asa nemkundigwa nibatiizwe na weye, na weye weza aha hangu nikubatiize!” ");
INSERT INTO bou_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu akamtambaisa, “Eka iwe ivyo isasa, kwaajii inu nee vyeivyo tikundigwavyo kugosoa yada akundayo Muungu. Aho Yohana akazumiiya.” ");
INSERT INTO bou_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu ekubindaho kubatiizwa akalawa mwe mazi, uwanga kwa Muungu kukavuguka nae akoona Muye wa Muungu ukaseeya inga sua na kugooka uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naho mgutio kulawa uwanga kwa Muungu ukagombeka, “Uyu nee mwanangu nimkundisae, anieteaye nyemi khuu.” ");
INSERT INTO bou_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naho Yesu akegalwa na Muye wa Muungu adi he kiwawe na kugeezwa na ibiisi. ");
INSERT INTO bou_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bada ya kwekaa misi makumi mane kwehiniza kuda kio na musi na kisiikizi akaumwa ni saa muno. ");
INSERT INTO bou_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aho mgeeza akamwezea, na akamgombeka, “Ukawa wee ni Mwana wa Muungu yaagiiye maiwe aya yawe mabumunda.” ");
INSERT INTO bou_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu akamtambaisa, “Iyandikwa mwe Maandiko ya Muungu, ‘Mntu khadaha kwekaa du kwa mabumunda, Iya kwa kia mbui agombekayo Muungu.’ ” ");
INSERT INTO bou_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naho ibiisi akamdoa adi Yelusalemu mzi wa Muungu akamuika uwanga ya mnaa wa Nyumba ya Muungu, ");
INSERT INTO bou_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamwamba, “Ikawa wee ni Mwana wa Muungu, etambike asi kwaviya iyandikwa mwe Maandiko ya Muungu ‘Muungu endaawaagiiye wandima wakwe wa uko uwanga weze, Wendawakudoe mwe mikono yao, Usekweza kweumiza muundi wako mwe iwe.’” ");
INSERT INTO bou_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akatambaisa, “Naho iyandikwa mwe Maandiko ya Muungu, ‘Usekumgeeza Zumbe, Muungu yako.’ ” ");
INSERT INTO bou_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Naho Ibiisi akamdoa adi uwanga ya muima wekulehao, akamwonyesha seuta zose za inusi na ukuu wakwe. ");
INSERT INTO bou_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akamwamba, “Ivi vyose nendanikwekhe inga ukanikintia mavindi na kunivika.” ");
INSERT INTO bou_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aho Yesu akamwamba, “Hauke ibiisi! Iyandikwa mwe Maandiko ya Muungu ‘Wendaumvikie Zumbe Muungu yako na kumgosoeya ndima yee ikedu!’ ” ");
INSERT INTO bou_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aho, ibiisi akambada, na wandima wa uwanga uko kwa Muungu wakamwezea na kumwambiiza. ");
INSERT INTO bou_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu ekusikiaho Yohana Mbatiiza kagewa mwe kifungo akaita mwe si ya Galilaya. ");
INSERT INTO bou_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yesu khekwekaa Nazaleti iya kaita kwekaa Kapelinaumu mzi wekuwao hehi na tondoo da mazi da Galilaya mwe miyaka ya si ya Zabuloni na Nafutali. ");
INSERT INTO bou_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iganie ida mbui ya uwoni wa muoni Isaya inga ikugombekavyo. ");
INSERT INTO bou_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Si ya Zabuloni na si ya Nafutali Kwe sia ya kwembokea tondoo da mazi phande ya Yolodani na Galilaya si ya wantu wesawokuwa Wayahudi! ");
INSERT INTO bou_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wantu wada wekwekaao mwe kiza. Wauona ung'ao mkuu. Naho wekwekaao mwe si ya kiza na kuogoha ufe, Ung'azi uwezea.” ");
INSERT INTO bou_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuvokea kisingi icho, Yesu akavoka kubiikia akagombeka, “Hitukani na mbade mavigaviga yenu kwamana useuta wa uwanga kwa Muungu uhehi.” ");
INSERT INTO bou_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kisingi Yesu ekuwaho enda khandakhanda ya tondoo da mazi da Galilaya neawaona wandugu waidi walowa samaki, Simoni etangwae Petulo na Andulea ekuwaye nduguye, newawa wakazitambika nyavu zao mwe mazimshindo kwaviya wowo newawa walowa. ");
INSERT INTO bou_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naho Yesu akawamba, “Nitongeani na miye nendaniwagosoe nywie mnietee wantu inga walowa waetavyo samaki kaya.” ");
INSERT INTO bou_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aho wakazibada nyavu zao na wakamtongea. ");
INSERT INTO bou_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ekuitaho hemeso, akawaona wandugu watuhu waidi Yakobo na Yohana wana wa Zebedayo. Awo newawa mwe ngaawa hamwe na tati yao Zebedayo nee wakagosoa nyavu zao. Yesu akawetanga, ");
INSERT INTO bou_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ahoaho wakaibada ngaawa hamwe na tati yao, wakamtongea Yesu. ");
INSERT INTO bou_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu nekawa akaita kia hantu mwe mzi wa Galilaya, uku akahinya mwe nyumba ya kukintania Wayahudi na kuwaabiikia Mbui Yedi za Useuta wa Muungu na kuhonya kia mbai ya matamu yose wekuwayo nayo wantu. ");
INSERT INTO bou_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbui zakwe zikaambazwa phande zose za si yose ya Siliya. Wekutozwao na matamu mbaimbai na suuba na wenye mazaiko na wagwao mtwi na wekuhooawo, naye Yesu akawahonya. ");
INSERT INTO bou_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mazumwezumwe makuu ya wantu kulawa mzi wa Galilaya na mzi wa Dekapoli na Yelusalemu na Yudea na phande ya Zigizigi da mazi da Yolodani wose wakamtongea. ");
INSERT INTO bou_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ekuyaonaho mazumwezumwe ya wantu akakwea kwe muima akekaa. Wahina wakwe nao wakambasa, ");
INSERT INTO bou_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nae akavoka kuwahinya. ");
INSERT INTO bou_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wenda wawe na nyemi wada wantu wamanyao kuwa wamkunda Muungu mwe wekazi wao, Mana useuta wa uwanga uko kwa Muungu ni wao ");
INSERT INTO bou_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wenda wawe na nyemi wada wekuwao na hovu, Mana awo wenda wahongezwe. ");
INSERT INTO bou_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wenda wawe na nyemi wada wahuhusi, Mana wendawahokee si ambayo Muungu ekuwaikiayo kiaga endaawekhe. ");
INSERT INTO bou_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wenda wawe na nyemi wada wenye saa na khiu ya kugosoa akundavyo Muungu, Kwaviya wenda weguswe. ");
INSERT INTO bou_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wenda wawe na nyemi wada wenye mbazi, Kwaviya wenda wafiiwe mbazi. ");
INSERT INTO bou_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wenda wawe na nyemi wada wenao moyo mtana, Kwaviya awo wenda wamwone Muungu. ");
INSERT INTO bou_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wenda wawe na nyemi wada waetao uivanisi, Kwaviya awo wenda wetangwe wana wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wenda wawe na nyemi wada wasuumizwao kwaajii ya kugosoa viya akundavyo Muungu, Kwaviya Useuta wa uwanga uko kwa Muungu ni wao. ");
INSERT INTO bou_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mwenda muwe na nyemi nywinywi wantu wendaho wawabee na kuwasuumiza na kuwagombeka ya ufyaimi wa mbai yoyose kwa uhokho kwaajii ya miye. ");
INSERT INTO bou_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muwe na nyemi muno kwaviya funge yenu ni khuu uko uwanga kwa Muungu. Ivyo nee wekuwasuumizavyo waoni wa Muungu wekuwaaho kisingi khamzati kuwaaho. ");
INSERT INTO bou_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nywie ni munyu wa inusi. Akini munyu ukaza umwiiye wakwe khaidahika vituhu kuvuza umwiiye wakwe, iya kwasigwa chongoi na kujatwa ni wantu. ");
INSERT INTO bou_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nywie ni ung'azi wa inusi! Mzi wekuzengwao uwanga ya muima khaudaha kwefisa. ");
INSERT INTO bou_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naho wantu khawawasha taa na kuigubika na nyungu iya waiika uwanga ya kintu cha kuikia taa iyo, ili iwamuikie wantu wose weumo mwe nyumba. ");
INSERT INTO bou_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Viyaviya mng'ao wenu na uwamuike wantu, naho waone ntendwa zenu ntana, wamtogoe Tati yenu ekuwaye uwanga uko kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Msekumamakhanya sheza kuiyusa miko ya Musa na mahinyo ya waoni iya ncheza kuiganiza. ");
INSERT INTO bou_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kwaviya nawamba kwei, adi aho mbingu na inusi zendazemboke, khahana katu hata hantu ekuwaho hadodo he miko ya Musa yendayoiyuswe adi yose yaiganie. ");
INSERT INTO bou_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naho mntu yoyose mwendaabade kutongea na kuwahinya wantu ivyo, endaetangwe mdodo muno mwe Useuta wa uwanga kwa Muungu, iya mntu azigosoae na kuzihinya, uyo endaetangwe mkuu mwe Useuta wa Uwanga uko kwa Muungu ");
INSERT INTO bou_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nawagombeka, mwakundigwa muitongee vyedi muno miko ya Muungu kusima viya wekugosoavyo wahinyi wa miko ya Musa na Mafalisayo, ama khivyo khamna mwengie mwe Useuta wa uwanga uko kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mtegeeza wantu waaho kae wekwembigwavyo, ‘Usekukoma! Na mntu yoyose endaeakome endaaamuiwe.’ ");
INSERT INTO bou_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Akini miye nawamba, yoyose amkimae nduguye wa kigosi hambu wakivyee akundigwa aamuiwe. Na ambae ambea nduguye endaegalwe he mkonga. Amwetangae nduguye, ‘Mhezi’ akundigwa engie mwe moto wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ukegaa malavyo yako uwanga ya ingo na ahoaho ukamanya khamwevana na nduguyo, ");
INSERT INTO bou_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bada malavyo yako he meso ya ingo, na uwite ukevane na nduguyo, nee uuye ulavye malavyo yako. ");
INSERT INTO bou_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Evana na mmasa yako kinyio kisingi mke siai hamwe nae uku mwaita he mkonga, uyo mmasa yako asekweza akakubuza kwa muamua nae muamua akakwekhia kwa maasikai na kugewa mwe kifungo.” ");
INSERT INTO bou_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kwa kwei nakwamba khunaulawe umo adi uihe hea ya kisikiizi. ");
INSERT INTO bou_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mtegeeza kuwa wantu nee wembigwa, ‘Usekugosoa ukianga.’ ");
INSERT INTO bou_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Akini miye nawamba, endaeamkauwe mvyee kwa kumtamiiya endaawe kagosoa nae ukianga mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ziso dako da kuume dikakutenda ugosoe mavigaviga diuse ukadase hae. Ni ebae kwaza kimamo kimwe cha mwii wako kusima mwii wako wose utambikwe mwe moto wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na inga mkono wako wa kuume ukakutenda ugosoe mavigaviga usenge na uwase hae. Ni ebae hako kwaza kimamo kimwe cha mwii wako, kusima mwii wako wose utambikwe mwe moto wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naho igombekwa kuwa, ‘Mgosi yoyose ambadae mkaziwe, akundigwa amwekhe bauwa ya kubadana.’ ");
INSERT INTO bou_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Akini miye nawamba mgosi yoyose khakundigwa kumbada mkaziwe kwa masa yoyose, iya kwa mbui ya ukianga du, akini ambadae mkaziwe kwa masa yoyose amtenda mkaziwe awe mkianga na mgosi yoyose endaeamtegue yuda mvyee mwekubadwa agosoa ukianga. ");
INSERT INTO bou_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Naho mtegeeza wekwembigwavyo wantu wa kae kuwa, ‘Inga ukaika kiaga chako kwa Muungu wakundigwa ukiiganize.’ ");
INSERT INTO bou_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iya miye nawamba mwesekuaha katu iwe uwanga kwa Muungu, kwaviya uwanga kwa Muungu ni kigoda cha Useuta wa Muungu, ");
INSERT INTO bou_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","naho msekuahia inusi, kwaviya nee hantu hakwe Muungu hakuikia miundi, naho kwa Yelusalemu kwaviya ni mzi wa Seuta Mkuu. ");
INSERT INTO bou_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naho usekuaha kwa mtwi wako kwaviya khudaha kugosoa hata fii mwenga iwe size hambu yekung'aayo. ");
INSERT INTO bou_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ukagombeka, ‘Eehe, naiwe eehe’ Na ukagombeka, ‘Khio kwei naiwe khio.’ Chochose kitendesacho chalawa kwa yuda ibiisi. ");
INSERT INTO bou_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mtegeeza nee igombekwa, ‘Ziso kwa ziso, zino kwa zino.’ ");
INSERT INTO bou_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iya miye nawamba, usekuiha masa kwa mntu ekukugosoeaye mafyaimi. Mntu akakutoa kofi funda da kuume, mhituiye na dakumoso. ");
INSERT INTO bou_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mntu akundae kukwegaa mwe mkonga na kukunda kukudoeya shati dako mbadie adoe na koti dako. ");
INSERT INTO bou_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mntu akakushuutiza kwenua fuushi dakwe kilomita mwenga, wee wenue kilomita mbii. ");
INSERT INTO bou_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akuombezae mwekhe, akundae kukuazima kintu usekumuemeeya. ");
INSERT INTO bou_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mtegeeza kuwa nee igombekwa, ‘mkundise mmbuya wako na umkime mmasa yako.’ ");
INSERT INTO bou_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Akini miye nawamba, wakundiseni wamasa wenu na kuwavika wada wawasuumizao nywie, ");
INSERT INTO bou_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ili mdahe kuwa wana wa tati yenu mwe uko uwanga kwa Muungu kwaviya yee aditenda zua diwekhe mng'ao wakwe kwa wantu wafyaimi na wantu wedi, na viyaviya fua yanya kwa wantu wamkundisao Muungu na wantu wesaokumkundisa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mkawakundisa du wada wawakundisao ivi mwendamwekhigwe kintu yani? Kwaviya watozao ushuu nao wagosoa ivyoivyo! ");
INSERT INTO bou_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Inga mkasagua kugosoa yedi kwa wambuya wenu du ivi muwatendesa watuhu kintu chani? Kwaviya ata wantu wesao kummanya Muungu nao wagosoa ivyoivyo! ");
INSERT INTO bou_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Naho mwesekuhungukiwa na kintu chochose inga Tati yenu wa uwanga kwa Muungu ambavyo khekuhungukiwa. ");
INSERT INTO bou_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ekauweni mwesekugosoa inga wakundavyo wantu, ili wawatogoe. Kwaviya mkagosoa inga ivyo khamnampate funge kwa Tati yenu mwe uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ivyo muwaambizavyo wakiwa, mwesekweambaza kwa wantu, inga wahokho wagosoavyo mwe nyumba zakukintania Wayahudi na siai ili wantu wawatogoe. Kwei nawagombeka, awo wekhigwa kae funge. ");
INSERT INTO bou_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Akini wee umuambizavyo mkiwa gosoa ivyo na mntu yoyose asekumanya. ");
INSERT INTO bou_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Umuambiize mtu kwesiho mntu kumanya na Muungu endaakwekhe funge. ");
INSERT INTO bou_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mvikaho msekugosoa inga wahokho, wowo wakunda kuvika wakawa wagooka mwe nyumba ya kuvika wayahudi na mwe sia phanda ili wantu wawakauwe. Kwei nawamba awo wekhigwa kae funge dao. ");
INSERT INTO bou_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akini wee uvikaho engia gati kwako vugaa uvi, naho umvike Tati yako esae kuoneka. Nae Tati yako aonae sii, endaakwekhe funge. ");
INSERT INTO bou_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Naho mvikaho, mwesekutamwiiya ntamwiizi zesazo kuwa na mana inga wantu wesao kummanya Muungu, kwaviya wowo wamamakhanya wendawategeezwe kwa ntamwiizi zao kuwa nyingi. ");
INSERT INTO bou_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Naho mwesekuigana nao kwaviya Tati yenu amanya muyakundayo kabla khamzati kumwombeza. ");
INSERT INTO bou_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Naho ivi nemkundigwavyo kuvika, ‘Tati yetu mwe uko uwanga kwa Muungu, Zina dako ditogolwe muno. ");
INSERT INTO bou_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Useuta wako weze. Yada ukundayo yagosoke uko uwanga kwako Muungu na yagosoke mwe inusi ");
INSERT INTO bou_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utekhe khande yetu kia msi. ");
INSERT INTO bou_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utiekee masa yetu Inga swiswi tiwaekeavyo masa wamasa wetu. ");
INSERT INTO bou_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usekutigea mwe mageezo Akini utihonye na ibiisi kwaviya Useuta niwako na udaho na ukuu hata misi zose zesazo na kisiikizi. Pepa.’ ");
INSERT INTO bou_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwaviya mkawaekea wantu masa yao na Tati yenu wa uko uwanga kwa Muungu endaawaekee na nywinywi ");
INSERT INTO bou_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Naho mkesekuwaekea wantu masa yao na Tati yenu khanaawaekee nywinywi masa yenu. ");
INSERT INTO bou_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mwehinizaho kuda khande, mwesekugosoa inga wabakha, wehituao kuwa wenye hovu na kunyafuisa vyeni vyao, ili wantu wawaone kuwa wehiniza kuda khande. Kwei nawamba wapata kae funge zawo. ");
INSERT INTO bou_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Akini mwehinizaho kuda, esiseni mavuta mwe mitwi yenu na kusunta vyeni vyenu, ");
INSERT INTO bou_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili kwehiniza kwenu kuda kwesekumanyika na wantu watuhu, iya Tati yenu ekaae hantu hasii, nae Tati yenu aonae sii endaawekhe funge zenu. ");
INSERT INTO bou_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mwesekweikia kiikizo hanu he inusi ambaho sondo na kutu, na wabavi wengia na kubawa. ");
INSERT INTO bou_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Eikieni kiikizo uko uwanga kwa Muungu ambaho sondo na kutu khawadaha kubananga na wabavi khawadaha kuita kutua na kubawa. ");
INSERT INTO bou_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwaviya hada cheiho kiikizo chako nee wendahouwe moyo wako. ");
INSERT INTO bou_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ziso ni taa ya mwii. Inga ziso dako ni gima mwii wako wose wendauwe mwe mng'ao. ");
INSERT INTO bou_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akini ikawa ziso dako khio gima mwii wako wose wendauwe mwe kiza. Naho mng'ao wekuwao umo mwako ukawa kiza, umanye icho kiza ni chakutisa muno. ");
INSERT INTO bou_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Khahana mntu adahae kuwagosoeya ndima mazumbe waidi, kwaviya enda amgosoee ndima vitana zumbe yumwe na kumbea mtuhu. Khamdaha kumkundisa Muungu hamwe na vintu vingi.” ");
INSERT INTO bou_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ivyo nawamba, msekuwa na matumatu uwanga ya khande na vidomeo hambu mii yenu mvaeni, kwaviya kwekaa kwenu khakukauwiiya khande du na mii yenu khaikauwiiya magwanda. ");
INSERT INTO bou_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wakauweni wadege wa uwanga khawahanda na khawabonda na khawana khande mwe taa dodose. Hata ivyo Tati yenu wa uwanga awaisa. Tambe nywie khamna yombe kusima aho? ");
INSERT INTO bou_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nindai gatigati yenu mwenye maatu muno adaha kweongeza msi wa kwekaa kwakwe? ");
INSERT INTO bou_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwambwai mwepisha kwaajii ya magwanda? Kauweni maua ya mzituni yatamavyo, khayagosoa ndima wala khayegosweeya magwanda yakwe. ");
INSERT INTO bou_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iya nawamba hata seuta Selemani mwenye na vintu vyakwe vyose khekuwahi kuvikwa vitana inga uwa dimweaho. ");
INSERT INTO bou_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Naho ikawa Muungu ayavika ivi mani ya mwe minda ambayo ivyeo yaaho na kioi yasigwa mwe moto, Nywie wantu wenye uzumizi mdodo namba nywie enda awagosoee muno? ");
INSERT INTO bou_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Aho msekuwa na matumatu, ‘Tendatideni? Tendatidomee mbwai? Tendativae mbwai?’ ");
INSERT INTO bou_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwaviya ayo yose yaondezwa na wantu wesaokummanya Muungu. Tate yenu wa uwanga amanya ati mwakunda vintu ivyo vyose. ");
INSERT INTO bou_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naho vokani kuuondeza Useuta wakwe, na kwekaa viya akundavyo Muungu na ayo yose mwendamwekhigwe na ngeeko. ");
INSERT INTO bou_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Naho msekuwa na matumatu ya kioi, kwaviya kioi ina yakwe. Kiya msi ina suuba yakwe. ");
INSERT INTO bou_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Msekuwaamwiiya watuhu, msekweza na nywie mkaamwiiwa. ");
INSERT INTO bou_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwaviya mwendavyomuwaamwiiye watuhu nee ivyo na nywie mwendavyomuamwiiwe, na kihimo kiakia muhimiacho watuhu nee icho mwendachomuhimiwe. ");
INSERT INTO bou_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kwambwai waona kibasi mwe ziso da nduguyo na ahoaho khuona basi mwe ziso dako? ");
INSERT INTO bou_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hambu wadaha viivihi kumwamba nduguyo ‘Mwaya eka nikuuse iki kibasi mwe ziso dako kisingi wee mwenye una basi mwe ziso dako?’ ");
INSERT INTO bou_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mhokho wee usa basi deumo mwe ziso dako naho ndiho wendaho udahe vitana kuusa kibasi mwe ziso da nduguyo. ");
INSERT INTO bou_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Msekuwekha makui vintu vya vyekuikwavyo kwajii ya Muungu wasekweza wakahituka na kuwakwacha naho msekuwawasia nguuwe lulu zenu wasekweza kuzijata. ");
INSERT INTO bou_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ombezani nanywi mwendamwekhigwe, na ondezani nanywi mwendampate na ukon'te uvi na mwenda mvuguiwe. ");
INSERT INTO bou_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwaviya mntu yoyose aombezae ekhigwa na aondezae apata na akon'tae uvi avugwiiwa. ");
INSERT INTO bou_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tambe kuna yumweaho mwanawe akamwombeza bumunda enda amwekhe iwe? ");
INSERT INTO bou_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hambu akamwombeza samaki endaamwekhe mdudu? ");
INSERT INTO bou_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ikawa ninywi wenye mavigaviga mwamanya kuwekha wana wenu vintu vitana, haika Tati yenu mwe uwanga kwa Muungu endaawekhe vintu vitana muno kwa wada wamuombezao. ");
INSERT INTO bou_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Yoyose mkundayo wantu wawagosoee na nywie muwagosoee inga ivyo. Kwaviya inu nee miko ya Musa na mahinyo ya waoni wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Engiani kwa kwembokea uvi msisii, kwaviya sia iitayo umo mwe ubanasi ni phana, na sia ya kwengiiya umo ni phana, na wembokeao sia iyo ni wangi. ");
INSERT INTO bou_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iya sia iitayo mwe ugima ni sisii na uvi wa kwengiiya ni msisii, ni wantu wachechedu wadahao kuiyona sia iyo. ");
INSERT INTO bou_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Muwe hae nao waoni wahokho wowo weza kwenu wakaoneka inga ngoto kwa chongoi akini kwa ndani ni inga makui makai ya mzituni. ");
INSERT INTO bou_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mwendamuwamanye kwa wayagosoayo inga timanyavyo mti kulawana na matunda yakwe. Ivi tambe wantu watunda zabibu mwe migunga hambu matunda yetangwayo tini mwe mbigii? ");
INSERT INTO bou_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iya mti mtana wavyaa matunda matana na mti mfyaimu wavyaa matunda mafyaimu. ");
INSERT INTO bou_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mti mtana khaudaha kuvyaa matunda mafyaimi na mti mfyaimi khaudaha kuvyaa matunda matana. ");
INSERT INTO bou_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kia mti wesao kuvyaa matunda matana wenda usengwe na kwasigwa mwe moto. ");
INSERT INTO bou_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ivyo mwendamuwamanye kwa yada wayagosoayo. ");
INSERT INTO bou_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Khio kia mntu anetangae ‘Zumbe, Zumbe,’ enda engie mwe Useuta wa uwanga kwa Muungu iya ni yudadu mgosoa yada ya Tate yangu wa uwanga. ");
INSERT INTO bou_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wantu wangi wendawanambe misi ida, ‘Zumbe, Zumbe! Kwa zina dako tibiikia mbui zako na kwa zina dako tiwaavya mazaiko na kugosoa vihii vingi.’ ");
INSERT INTO bou_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aho nenda nimwambe ‘Nchekuwamanya nywie katu haukeni aha hangu nywie mgosoao mavigaviga.’ ");
INSERT INTO bou_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ivyo kia mntu ategeezae mbui zangu na kuzigosoa aigana na mntu mwenye akii, mwekuzenga nyumba yakwe uwanga ya iwe kuu. ");
INSERT INTO bou_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fua ikanya, mazigizigi ya mazi yakamema na khusi khai ikeza ikatoa iyo nyumba. Akini khayokugwa kwaviya izengwa uwanga ya iwe kuu. ");
INSERT INTO bou_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Na yoyose ategeezae mbui zangu izi na akesekuzitozeeza, aigana na mntu mhezi mwekuzenga nyumba yakwe uwanga ya sanga. ");
INSERT INTO bou_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fua ikanya, mazigizigi ya mazi yakamema, khusi khai ikeza na kuitoa iyo nyumba nayo ikagwa, naho kugwa uko kuwa kukuu muno.” ");
INSERT INTO bou_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ekubindaho kugombeka mbui iyo zumwezumwe da wantu wakahondomazwa na mahinyo yakwe. ");
INSERT INTO bou_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kwaviya nee kawa akahinya khio inga wahinyi wa maagiiyo iya kahinya inga mwenye udaho. ");
INSERT INTO bou_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ekuseeaho kwe muima na zumwezumwe da wantu dikambasa. ");
INSERT INTO bou_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nee eza mntu yumwe mwenye utamu wa nyoka khuu na akamkintia mavindi na kugombeka, “Zumbe ukakunda wadaha kuning'aza!” ");
INSERT INTO bou_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu akaunyoosha mkono akamdonta na kugombeka, “Nakunda, ng'azika!.” Ahoaho mntu uyo akahona utamu wakwe wa nyoka khuu. ");
INSERT INTO bou_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Naho akamwamba, “Kauwa, usekumwamba mntu yoyose, iya hita ukeonyeshe kwa mviki na kulavya malavyo inga akwambavyo Musa, na wantu wamanye kuwa kuhona.” ");
INSERT INTO bou_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu ekuwaho engia mwe mzi wa Kapelinaumu, asikai mkuu yumwe akambasa, ");
INSERT INTO bou_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","na kumwamba, “Zumbe, mndima yangu kagona kaya ni mtamu wa kuhooa na ahuma muno.” ");
INSERT INTO bou_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu akamwamba, “Hita nendaneze kumhonya.” ");
INSERT INTO bou_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Uyo mkuu wa asikai akamwamba, “Zumbe, miye khifaa weye wengie kaya hangu. Akini wee gombeka mbui du na mndima yangu endaahone. ");
INSERT INTO bou_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwaviya hata miye ni mntu mkuu mwenye udaho mkuu, nenao asikai asi yangu. Nikamwamba yumwe, ‘Hita!’ Nae aita na mtuhu ‘Soo’ Nae eza, naho nikamwamba mndima wangu, ‘Gosoa kintu iki!’ Nae agosoa.” ");
INSERT INTO bou_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ekusikiaho ayo akahondomaa, akawagombeka wada wantu wekuwao wambasa, “Kwei nawamba khizati kumwona mntu mwe si ya Isilaeli mwenye uzumizi inga unu. ");
INSERT INTO bou_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iya nawamba kwei wantu wangi wendaweze kulawa awio da zua na engiiyo da zua naho wendawekae he ntafuno hamwe na Ablahamu, na Isaka na Yakobo mwe Useuta wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iya wada Waisilaeli wose wekukundigwao kuwa mwe Useuta uwo wendawasigwe chongoi mwe kiza, na uko wendawaiye na kuuma meno kwa usungu.” ");
INSERT INTO bou_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aho Yesu akamwamba uyo asikai wa Kilumi, hita kaya na iwe inga wekuzumiavyo. Na mndima yakwe akahona saa idaida. ");
INSERT INTO bou_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ekubuaho kaya kwa Petulo akamwona mkwewe da Petulo kagona mwe usazi, ana bomubomu kai. ");
INSERT INTO bou_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nee Yesu amdonta uyo mmaa mkono nee ahona, akenuka na kuvoka kumwembikia. ");
INSERT INTO bou_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yekubuaho guoni, wakamweeteya wantu wangi wekukwewao ni mazaiko, nae akayalavya ayo mazaiko kwa kugombeka mbui yakwe du, na wantu wose wekuwao watamu akawahonya. ");
INSERT INTO bou_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kagosoa ivyo ili yada ekugombekayo muoni Isaya yaiganie, “Yee mwenye kadoa unyonge wetu na akayenua matamu yetu.” ");
INSERT INTO bou_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu ekuonaho zumwezumwe da wantu dimuikia bunga akawamba wahina wakwe waite phande ya kaidi ya tondoo da mazi. ");
INSERT INTO bou_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mhinyi yumwe wa miko akambasa na kumwamba, “Mhinyi miye nenda nikutongee hohose wendako uite.” ");
INSERT INTO bou_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu akamtambaisa, “Ukwii wana maphanga, wadege wana masasa, iya Mwana wa Mntu khana hantu hakuhumwiiza.” ");
INSERT INTO bou_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yumwe wa wahina wakwe akamwamba, “Zumbe unekhe uhusa niite nikamzike tate.” ");
INSERT INTO bou_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Akini Yesu akamtambaisa, “Nitongee! Wabade wekuuyao na nyuma wawazike wekuuyao na nyuma wao.” ");
INSERT INTO bou_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naho Yesu akakwea ngaawa hamwe na wahina wakwe wakahauka wose. ");
INSERT INTO bou_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na wekuwaho mwe tambo vuupuu mwe mazimshindo ikalawiiya khusi khai hata mkubwadiso wa mazi ukavoka kugubika ngaawa, iya Yesu nee kagona usisiza. ");
INSERT INTO bou_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wahina wakambasa, wakamwenua wakagombeka, “Zumbe, tiohoe tadagamia!” ");
INSERT INTO bou_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu akawatambaisa, “Kwambwai mwaogoha, nywie wantu wenye uzumizi mdodo?” Ahoaho akenuka akaiwakia ida khusi na mkubwaniso wa mazi twiyani, nee kwatwiiya tui. ");
INSERT INTO bou_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wada wantu wakahondomaa na kugombeka, “Uyu ni mntu yevivihi? Hata khusi na mkubwadiso vyamtegeeza!” ");
INSERT INTO bou_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ekubuaho phande ya kaidi wa si ya Wagelasi na uko nekuwa na wagosi waidi wekuwao na mazaiko wakakintana nae, wowo nee walawiia mwe mbia. Awa nee ni wantu watisao muno, naho khahana mntu mwekudaha kwembokea sia iyo. ");
INSERT INTO bou_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wekukintanaho na Yesu nee wavoka kutoa vuzo, “Wakunda mbwai kwetu, wee Mwana wa Muungu? Kweza kutisuumiza kisingi kikundigwacho khakizati kubua?” ");
INSERT INTO bou_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hehi na hantu aho nee hawa na tintimo da nguuwe wakaiswa. ");
INSERT INTO bou_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nee ayo mazaiko yakamhembeeza Yesu, “Inga ukatilavya utibade tiwengie wada nguuwe.” ");
INSERT INTO bou_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu akawamba, “Hitani.” Aho wakalawa mwe wantu awo na kuwengiiya wada nguuwe, nee tintimo da nguuwe. Dikaseeya mwe mpoomoko mkai wakengia mwe tondoo da mazi, nguuwe wose wakauya na nyuma mwe mazi. ");
INSERT INTO bou_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wada waisi wa awo nguuwe wakaguuka wakaita mwe mzi uko na kuwamba wantu mbui zose zekulawiiazo kwa wada wantu wekuwao wakwewa ni mazaiko. ");
INSERT INTO bou_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nee wantu wose mwe mzi uda wakalawa mwe mzi na kumbasa Yesu na wekumuonaho wakamwombeza ahauke mwe si yao. ");
INSERT INTO bou_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu akakwea ngaawa, akadumua ntondoo da mazi na kubua mwe mzi wa Kapelinaumu ekuwaho akekaa. ");
INSERT INTO bou_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aho wakamwetea mntu mwenye kuhooa mwii, kagonezwa mwe javi. Yesu ekuonaho uzumizi wao, akamwamba uyo mntu mwe kuhooa, “Ekhe moyo mwanangu! Kuekewa mavigaviga yako.” ");
INSERT INTO bou_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naho wamwe wa wahinyi wa miko wakavoka kumamakhanya mwe mioyo yao, “Mntu uyu amdumua Muungu!” ");
INSERT INTO bou_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu akayamanya wamamakhanyayo, akamba “Kwambwai mwamamakhanya ufyaimi mwe mioyo yenu? ");
INSERT INTO bou_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni dihi dekuhuhado muno, kugombeka, ‘kuekewa mavigaviga, hambu kugombeka, gooka wende?’ ");
INSERT INTO bou_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naho, nakunda mmanye Mwana wa Mntu ana udaho mwe inusi ya kuwaekea wantu mavigaviga.” Aho akamwamba uyo mntu mwekuhoowa, “Enuka, udoe javi dako uite kaya kwako.” ");
INSERT INTO bou_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yuda mntu ekuhooae akahauka na kuita kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zumwezumwe da wantu dekuwado hada, dikahondomaa na kuogoha, wakamtogoa Muungu ekuwekhae wantu udaho wa namna iyo. ");
INSERT INTO bou_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu akahauka hantu hada, na ekuwaho akaita zakwe, akamwoona mntu yumwe etangwae Matayo, kekaa mwe kazumba cha kuihiiya ushuu. Nee, Yesu amwamba, “Nibase.” Matayo akenuka, akambasa. ");
INSERT INTO bou_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu ekuwaho kaya kwa Matayo kekaa ada khande, watoza ushuu wangi na wenye mavigaviga wakeza na kwekaa hamwe na Yesu na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo wekuonaho, wakawamba wahina wakwe, “Kwambwai mhinyi yenu ada khande hamwe na watoza ushuu na wenye mavigaviga?” ");
INSERT INTO bou_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ekuwategeezaho, akawatambaisa, “Wantu wenye ugima khawakunda mganga, iya watamu du nee wakundao mganga. ");
INSERT INTO bou_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Akini hitani, mkehinye mana ya mbui inu. ‘Nakunda mbazi khio ntambiko.’ Nchekweza kuwetanga wantu wedi iya wenye mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naho wahina wa Yohana Mbatiiza wakamtimia Yesu, na kumuuza, “Swie na Mafalisayo tehiniza kuda, kwambwai wahina wako khawehiniza kuda?” ");
INSERT INTO bou_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akawatambaisa, “Ivi wekugonekwao kwe ndoza wadaha viivihi kutoa bwaimbo kisingi zumbe wa ndoza yuke hamwe nao? Havidaika! Iya kisingi chendakibue ambaho zumbe wa wiya endaho ausigwe gatigati yao, kisingi icho ndiho wendaho wehinize kuda. ");
INSERT INTO bou_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Wantu khawagea kilaka cha gwanda dihya mwe gwanda dekusakaayo. Kwa mana kilaka icho chendakitatue diya gwanda dekusakaayo, na hada hekutatukaho endahagenyee. ");
INSERT INTO bou_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naho wantu khawageya divai mphya mwe mikwiji yekusakaayo, inga akatenda ivyo iyo divai mphya yendaitatue iyo mikwiji na divai yendayetike na mikwiji iyo yendaibanike. Divai mphya yagewa mwe mikwiji ya babu mihya.” ");
INSERT INTO bou_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ekuwaho akagombeka ayo, mkuu yumwe wa Wakiyahudi neabuwa, akamkintia mavindi na kugombeka, “Mwanangu ya kindee kauya kae na nyuma isasa ivi. Akini tite ukamwikie mkono, nae endaatende mgima.” ");
INSERT INTO bou_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu akahauka akatongeana nae, nao wahina wakwe wakamtongea. ");
INSERT INTO bou_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kisingi ichoicho, mmaa yumwe, mwekuwa na utamu wa mtuo kwa kisingi cha myaka kumi dimwe na mbii, nee amtongea Yesu kwa nyuma, akadonta msao wa gwanda dakwe. ");
INSERT INTO bou_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwaviya nee kegombekea mwe moyo wakwe, “Nikadonta du gwanda dakwe, nendanihone.” ");
INSERT INTO bou_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu nee ahituka akamwona, akamwamba, “Ekhe moyo biti yangu! Uzumizi wako ukuohoa.” Mmaa uyo akahona saa idaida. ");
INSERT INTO bou_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Naho Yesu akengia nyumbani kwa yuda mkuu. Na ekuwaonaho wantu wavuzia fiimbi na zumwezumwe kuu da wantu wakatoa bwaimbo, ");
INSERT INTO bou_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","akagombeka, “Haukeni aha! Mndee uyu khekuuya na nyuma, kagonadu.” Nawo nee wamseka. ");
INSERT INTO bou_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Naho, zumwezumwe da wantu dekuuswaho, Yesu akengia mda ndani, akamtoza mkono uyo mndee, nae akenuka. ");
INSERT INTO bou_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbui iyo ikaambazika mwe si ida yose. ");
INSERT INTO bou_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ekuwaho ahauka hantu aho, matuntu waidi wakambasa na kutoa vuzo, “Mwana wa Daudi, utifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ekwengiaho nyumbani, wantu awo waidi wakamtimia, nae akawauza, “Ivi, mwazumiiya nadaha kutenda mbui iyo?” Nao nee wamtambaisa, “Eehe, Zumbe.” ");
INSERT INTO bou_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aho Yesu akayadonta meso yao, akawamba, “Naiwe inga mzuumiavyo!” ");
INSERT INTO bou_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meso yao yakagubulwa. Nee Yesu akawahaza muno, “Mwesekumwamba mntu yoyose mbui inu!” ");
INSERT INTO bou_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iya wowo wakalawa na kuambaza mbui zakwe Yesu mwe si ida yose. ");
INSERT INTO bou_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wantu wada waidi wekuwaho wakahauka, watuhu wakamwetea Yesu mntu yumwe mwekuwa mbubu naho kakwewa ni zaiko. ");
INSERT INTO bou_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ahoaho uyo zaiko dekulavigwaho, mntu uyo mwekuwa mbubu akavoka kutamwiiya vituhu. Wantu wakahondomaa na kugombeka, “Mbui inga inu khaizati kulawiiya kwa wantu wa Isilaeli!” ");
INSERT INTO bou_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iya Mafalisayo wakagombeka, “Ayaguusa mazaiko kwa udaho wa mkuu wa mazaiko.” ");
INSERT INTO bou_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu akavuiiya mizi yose mikuu na phaamo zose, akahinya he nyumba ya kukintania Wayahudi na kubiikia Mbui Yedi za Useuta wa Muungu, na kuwahonya wantu matamu yose. ");
INSERT INTO bou_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na ekuwaonaho wantu, zumwezumwe kwa zumwezumwe, akawafiiya mbazi kwaajii newasokea muno na wenye maatumaatu inga ngoto wesao kuwa na muisi. ");
INSERT INTO bou_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ivyo akawamba wahina wakwe, “Ubosi ni mwingi, iya wagosozi wandima niwacheche. ");
INSERT INTO bou_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ivyo mwombezeni mwenye uwo ubosi aagiiye wagosozi wa ndima wabonde ubosi wakwe.” ");
INSERT INTO bou_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Naho Yesu akawetanga wahina wakwe kumi dimwe na waidi na kuwekha udaho wakulavya mazaiko na kuhonya matamu yose. ");
INSERT INTO bou_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mazina ya awo waagiiwa kumi dimwe na mbii, Wabosi ni Simoni etangwae Petulo na Andulea nduguye na Yakobo mwana wa Zebedayo na Yohana nduguye, ");
INSERT INTO bou_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batiomayo, na Tomasi na Matayo mwekuwa mtoza ushuu na Yakobo mwana wa Alifayo na Tadei, ");
INSERT INTO bou_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni ambae nekawa mtoanaji kwaajii ya si yakwe hambu zelote na Yuda Isikaliote mwekumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu akawaagiiya awo waagiiwa kumi dimwe na mbii na kuwekha miagiiyo inu, “Mwesekuita kwa wantu wesao kuwa Wayahudi, naho mwesekwengiya mwe mizi ya Wasamalia. ");
INSERT INTO bou_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iya hitani kwa wantu wa Isilaeli wekwagao inga ngoto. ");
INSERT INTO bou_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na mwiitaho bikiani ivi, ‘Useuta wa uwanga kwa Muungu uhehi!’ ");
INSERT INTO bou_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wahonyeni watamu na wekuyao na nyuma wayuyuseni, na wasunteni wenye utamu wa nyoka na lavyeni mazaiko. Mwekhigwa bue na nywie lavyeni bue. ");
INSERT INTO bou_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwesekudoa mwe mikwiji yenu zahabu, wala hea wala sensi za shaba. ");
INSERT INTO bou_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mwesekudoa mfuko wa ntambo wa kuombezea vintu siai, wala gwanda da hakiba nawala sabana wala ngoda. Kwaviya mgosozi wa ndima akundigwa ekhigwe maiho yakwe. ");
INSERT INTO bou_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mkengia mwe mzi wowose mkuu hambu phaamo yoyose, ondezani mntu ambae akunda kuwahokea na ekaeni aho hake adi mwendaho mhauke hantu aho. ");
INSERT INTO bou_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mwengiaho mwe nyumba iyo ugusani wenyezi wakwe, na kuwamba, ‘Uivanisa uwe nanywi.’ ");
INSERT INTO bou_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Inga waaho wantu wedi umo ndani mkawaombee Muungu awajaiye, ati khawana wawe awo wantu wedi Muungu khana awajaiye. ");
INSERT INTO bou_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inga mntu yoyose akaemea kuwahokea hambu kuwategeeza, naho mlawaho mwe nyumba iyo hambu mzi uwo kung'untani sanga ya mwe miundi yenu inga hazo kwao. ");
INSERT INTO bou_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kwei nawagombeka, msi wakuamuiwa mzi uwo wenda wekhigwe sugusa khuu kusima ida yekwekhigwayo ya mizi ya Sodoma na Gomola. ");
INSERT INTO bou_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Isasa miye nawaagiiya inga ngoto gatigati ya makui ya mzituni. Muwe na unyanyi inga nyoka na muwe wahuhusi inga sua. ");
INSERT INTO bou_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ekaeni hae na wantu, kwaviya wendawamigwiye na kuwegaa mwe mikonga, na wenda wamitoe ngoda mwe nyumba ya kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mwendamwegalwe hemeso ya wagookezi na Maseuta kwaajii yangu, ili mdahe kuwagombeka wowo mbui zangu na kwa wantu wesao kuwa Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naho wendahowawegae he mikonga msekuogoha mwendavyo mgombeke, kwaviya saa idaida mwenda mwekhigwe yakugombeka. ");
INSERT INTO bou_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwaviya khio nywie mwendaomgombeke, iya ni Muye wa Muungu wa Tati yenu nee endaeagombeke umo mwenu. ");
INSERT INTO bou_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndugu endamhituke nduguye akomwe, na tate endaamhituke mwanawe, wana nao wenda wawahituke wavywazi wao wakomwe. ");
INSERT INTO bou_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wantu wose khawana wawakundise kwaajii yangu. Akini mwenda azizimize adi kisiikizi nee mwendaaoholwe. ");
INSERT INTO bou_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wantu wakasumiiza mwe mzi unu guukani mzi mtuhu. Nawamba kwei, khamna mbindiize mizi yose ya wantu wa si ya Isilaeli hadi Mwana wa Mntu endaho eze. ");
INSERT INTO bou_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mhina khadaha kumwemboka mhinyi yakwe, na mndima nae khadaha kumwemboka zumbe yakwe. ");
INSERT INTO bou_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yadahika mhina kuwa inga mhinyi yakwe na yadahika mndima kuwa inga zumbe yakwe. Ikawa wanetanga miye mkuu yenu Beelizebuli, Ivi nywie khawana wawetange mazina mafyaimi muno. ");
INSERT INTO bou_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Naho msekuwaogoha wantu awo, kwaviya kia mbui yekugubikwayo yendaigubulwe, na kia chekufiswacho chendakioneke. ");
INSERT INTO bou_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Niwagombekayo nywie kandani myagombeke he wazo. Kiya niwanong'onezacho nawakunda mkitamwiiye kwa mgutio kiya mntu ategeeze. ");
INSERT INTO bou_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Msekuwaogoha wada waukomao mwii, akini khawadaha kuukoma muye. Mwakundigwa kumwogoha Muungu adahae kudagamiza mwii hamwe na muye mwe moto wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wadege waidi wadodo watagwa kwa sensi mwenga ndodo. Akini ata yumwe aho kagwa asi kwesiho Tate yenu kumanya. ");
INSERT INTO bou_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hata ntaazia ya fii za mitwi yenu Muungu azimanya. ");
INSERT INTO bou_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kwa iyo msekuogoha nywie ni watana he meso ya Muungu kusima wadege wangi. ");
INSERT INTO bou_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na yoyose mwendaye anizumiiye hemeso ya wantu, miye nami nendanimzumiiye hemeso ya Tate yangu wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Iya yoyose mwendayeaniemee hemeso ya wantu, na miye nenda nimuemee hemeso ya Tate yangu wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Msekumamakhanya kuwa ncheza kueta uivanisa mwe inusi iya ncheza kueta khondo. ");
INSERT INTO bou_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwaviya ncheza kueta kutokwevana kwa mntu na tati yakwe biti na mami yakwe, mkaza mwana na mame vyaa khawana wevane. ");
INSERT INTO bou_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na mmasa wa mntu ni wantu wakaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Amkundisae tate hambu mami yakwe kusima anikundisavyo miye, khadaha kuwa hamwe na miye na akundisae wanawe kusima miye, khadaha kuwa mhina wangu. ");
INSERT INTO bou_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mntu mwesaekuudoa mhamba wakwe na kunitongea khadaha kuwa mhina wangu. ");
INSERT INTO bou_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mntu akundae kuuhonya ugima wakwe endaawaze, akini endaeawaze ugima wakwe kwaajii yangu wenda wekhigwe. ");
INSERT INTO bou_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Na yoyose awahokea nywie anihokea miye. Na yoyose anihokea miye, amhokea yuda mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na yoyose amhokeaye Muoni kwaajii ni Muoni, endaahokee funge da Muoni. Na yoyose amhokeaye mntu agosoaye yada akundayo Muungu, endaekhigwe funge idaida ambayo wekhingwa wada ambao wagosoa akundayo Muungu. ");
INSERT INTO bou_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nawagombeka kwei, yoyose mwenda amwekhe yumwe aho wa wadodo awa kikombe cha mazi ya pheho kwaajii ni mhina yangu, haika khana akose katu kwekhigwa funge dakwe.” ");
INSERT INTO bou_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ekubindaho kuwekha miagiiyo wahina wakwe, akalawa aho, akaita kuhinya na kubiikia mwe mizi yao uko Galilaya. ");
INSERT INTO bou_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana ekuwaho mwe kifungo nee asikia mbui za Klistu, akawaagiiya wahina wakwe, waite kumuuza, ");
INSERT INTO bou_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","weye nee yuda ezae, hambu timkauwiye mtuhu? ");
INSERT INTO bou_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu akawatambaisa, “Hitani mkamgombekee Yohana mbui mtegeezazo na kuziona, ");
INSERT INTO bou_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","matuntu waona, wesaokudaha kwenda wenda, na viziba wategeeza, na wenye utamu wa nyoka wasuntika na wekuuyao na nyuma wayuyuswa, na wakiwa wabiikiwa Mbui Yedi. ");
INSERT INTO bou_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Endaawe na nyemi mntu yuda ambae khana maatu na miye.” ");
INSERT INTO bou_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wada wahina wa Yohana wekuwaho wakahauka, Yesu akavoka kugombeka na dia zumwezumwe kuusu Yohana, Mbatiiza. Akawauza, “Mwekuitaho kuda he nyika, mwita kukauwa mbwai? Ivi nee mkakunda kuona inde dikasingiswa ni khusi? ");
INSERT INTO bou_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Inga khivyo, mwiita kukauwa mbwai? Mwiita kukauwa mntu mwekwehasika magwanda matana? Wantu wehasikao magwanda inga ayo, wekaa mwe nyumba ya Maseuta. ");
INSERT INTO bou_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Naho, mwita kukauwa mbwai? Muoni wa Muungu? Haika nawamba, nee mwiita kumuona mntu ekuwaye mkuu kusima muoni. ");
INSERT INTO bou_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uyo nee ambae mbui zakwe ziandikwa mwe Maandiko ya Muungu, ‘Kauwa namuagiiya mwagiiwa yangu aniongweee, mwendayeagosoe sia he meso yako.’ ");
INSERT INTO bou_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nagombeka kwei mwa wantu wekuvyaigwao na wavyee, khazati kulawiiya mntu mkuu inga Yohana Mbatiiza, akini ambae ni mdodo muno mwe useuta wa uwanga kwa Muungu, ni mkuu kusima Yohana ");
INSERT INTO bou_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuvokea kisingi cha Yohana Mbatiiza adi isasa Useuta wa uwanga kwa Muungu wapatikana kwa nguvu, naho wantu wenye udaho wageeza kuudoa. ");
INSERT INTO bou_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwaviya miko ya Musa na waoni wose na wazitamwiiya mbui za useuta wa Muungu wendavyo uwe kwa kisingi iki. ");
INSERT INTO bou_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ikawa mwakunda kuzumia ido, yee Yohana nee uyo Eliya ambae waoni newawa wakagombeka endaeze. ");
INSERT INTO bou_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yee mwenye magutwi na ategeeze! ");
INSERT INTO bou_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Akini nikiiganiye na mbwai kivyazi iki? Kiigana na wana wekaao gwiiyo, wawetangao wezwao na kuwagombeka, ");
INSERT INTO bou_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nee tiwatoea ngoma na wala khamwekuvina, na titoa wiya za bwaimbo na wala khamwekuiya.’ ");
INSERT INTO bou_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwaviya Yohana Mbatiiza keza akehiniza kuda na wala kuidomea divai, nao wakamwamba, ‘Kakwewa na mazaiko.’ ");
INSERT INTO bou_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Mntu keza, ada khande na kudomea, nao wakamwamba. ‘Mkauweni uyu ni mmeo, na ni mkozi, wambuya wakwe ni watoza ushuu na wenye mavigaviga!’ Ata ivyo unyanyi wa Muungu imanyika kuwa niyedi kulawana na ndima yakwe.” ");
INSERT INTO bou_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ndiho Yesu akavoka kuihaza mizi ida ambayo kaigosweeya vihii vingi kusima kutuhu, kwaviya wantu wakwe khawakubada mavigaviga. ");
INSERT INTO bou_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wendawakione wantu wa Kolozini! Wendawakione wantu wa Betisaida! Inga vihii vyekugosokavyo aha henu ati nee vigosoka kuda Tilo na Sidoni, wantu wakwe newavaa kae magwanda ya gunia na kwesisa mazeu na kuonyesha wabada mavigaviga. ");
INSERT INTO bou_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nagombeka kwei yendaiwe ihuha kwa wantu wa mizi ya Tilo na Sidoni kuzizimiza mwe msi wa kuamuiwa wa Muungu kusima aha henu. ");
INSERT INTO bou_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na nywie wantu wa Kapelinaumu, ivi wenda wenulwe adi uwanga kwa Muungu? Eehe, wenda useezwe adi si ya wekuyao nyuma, kwaviya inga vihii vyekugosokavyo aho hako inga nevigosoka mwe Sodoma mzi uwo neukeaho adi ivyeo. ");
INSERT INTO bou_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akini nagombeka kwei, msi wakuamwiiwa weye wenda wekhigwe sugusa khuu kusima ya Sodoma. ");
INSERT INTO bou_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kisingi icho Yesu akagombeka, “Nakutogoa ee Tate, Zumbe wa uwanga na wa inusi, kwaviya kuwafisa wenye unyanyi na umanyi, na ukawagubwiiya wana wadodo. ");
INSERT INTO bou_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eehe, Tate nee vyekukutamiavyo. ");
INSERT INTO bou_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tate yangu kanekha vintu vyose. Khahana ammanyae Mwana iya Tate, nawala ammanyae Tate iya Mwana, na yoyose yuda ambae Mwana akunda kumgubwiiya uyo endaammanye Tate. ");
INSERT INTO bou_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sooni aha hangu nywie nyose muangadikao na kuzamiwa na mafuushi, na miye nendaniwahumwiize. ");
INSERT INTO bou_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mzumiye kuongoewa na miye inga viya njeku afungwaho nila kisingi cha kuima, mkehine kulawa kwangu, kwaviya miye niyedi naho ni mnyenyekevu wa moyo, na nywie mwenda mwekhigwe nyemi. ");
INSERT INTO bou_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwaviya yendaiwe vihufu kwenu kwamana mahinyo yangu ni mahufu.” ");
INSERT INTO bou_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kisingi icho Yesu akembokea kwe minda ya uhemba msi wa kuhumwiiza. Aho wahina wakwe wakawa nasaa, kusenga uhemba, wakada khokhoo zakwe. ");
INSERT INTO bou_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo wekuonaho ayo, wakamwamba Yesu, “Kauwa, wahina wako wagosoa mbui yesayokukundigwa kugosoka mwe Msi wa Kuhumwiiza.” ");
INSERT INTO bou_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu akawatambaisa, “Khamzati kusoma ekugosoavyo Daudi hamwe na weziwe kisingi wekuwaho na saa? ");
INSERT INTO bou_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yee kengia mwe nyumba ya Muungu akada yada mabumunda yekuikwayo hemeso ya Muungu. Khio yee wala wada weziwe khawekukundigwa kuda yada mabumunda iya nee yakundigwa kuigwa na waviki wowodu ikedu. ");
INSERT INTO bou_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tambe khamzati kusoma mwe miko, Waviki wakuu newawa wakabananga miko ya Msi wa Kuhumwiiza nao khawamamakhanywa kuwa wana masa? ");
INSERT INTO bou_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iya nawagombeka kwei, aha yuaho mkuu kusima nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Inga nee mmanya mana ya mbui inu, ‘Nakunda mbazi nawala khio ntambiko.’ Khamwekuwa mkawaamuiiya wantu wesaokukoa masa, ");
INSERT INTO bou_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","kwaviya Mwana wa Mntu nee Zumbe wa Msi wa kuhumwiiza.” ");
INSERT INTO bou_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu akahauka hantu aho, na kwengia mwe nyumba yao yakukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nekuwa na mntu yumwe mwenye mkono wekuhoao. Naho, wantu wakamuuza Yesu, “Kulawana na miko yetu, ivi ni vitana kuohoa mntu Msi wa Kuhumwiiza? Wamuuza ivyo wapate kumuamuiiya masa.” ");
INSERT INTO bou_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu akawamba, “Ni ndai gatigati yenu mwenye ngoto yumwe, na yuda ngoto akengia mwe tubwi Msi wa Kuhumwiiza, ivi khanaamtoze na kumlavya? ");
INSERT INTO bou_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nakunda mmanye du, mntu ana yombe muno kusima ngoto! Aho ni vitana kugosoa matana Msi wa Kuhumwiiza.” ");
INSERT INTO bou_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naho akamwamba yuda mntu, “Unyooshe uwo mkono.” Akanyoosha, nao ukawa mgima inga uda mtuhu. ");
INSERT INTO bou_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aho, Mafalisayo wakalawa chongoi na kufanyanya wendavyowadahe kumkoma Yesu. ");
INSERT INTO bou_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Akini Yesu ekumanyaho mamakhanyi zao, hantu hada akahalawa. Wantu wangi wakamtongea, akawahonya watamu wose. ");
INSERT INTO bou_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akawaemeza wasekumwamba mntu mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ili yada ekwambayo Muoni Isaya yaiganie, ");
INSERT INTO bou_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kauwa mndima yangu nekumsaguae, Mkundiswa wangu nitamiwae nae mwe moyo. Nenda niike Muye wangu, Nae enda aiyambaze miamuiyo kwa si zose. ");
INSERT INTO bou_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Khana aete uhigano na wantu wala kutoa vuzo, Wala mgutio wakwe khauna utegeezeke siai. ");
INSERT INTO bou_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lasi dekuhondekado khanaadibonde, Wala utambi wa koloboi ufufutikao mosi khanaaukome Adi endaho atende uwamuiyo wa kwei ugooke wenye, ");
INSERT INTO bou_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na wantu wose wendawamkauwiiye.” ");
INSERT INTO bou_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aho wantu wakamwetea Yesu mntu mwekuwae ni tuntu naho khadaha kutamwiiya uku kakwewa ni mazaiko. Yesu nee amhonya ata akadaha kutamwiiya na kuona. ");
INSERT INTO bou_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zumwezumwe dose da wantu dikahondomaa na kugombeka, “Ivi yadahika ikawa nee Mwana wa Daudi?” ");
INSERT INTO bou_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Akini Mafalisayo wekusikiaho ayo, newamba, “Mntu uyu ayaguusa mazaiko kwa udaho wa Belizebuli mkuu wa mazaiko.” ");
INSERT INTO bou_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu, akawamanya mamakhanyo zao, akawamba, “Useuta wowose wekupanganikao vizumwezumwe vihiganavyo khaudaha kwekaisa, naho mzi wowose hambu kaya yoyose yekupanganikayo vizumwezumwe vihiganavyo khavina vigooke. ");
INSERT INTO bou_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikawa Ibiisi amguusa Ibiisi mweziwe ahigana mwenye. Aho useuta wakwe wenda ugooke viivihi? ");
INSERT INTO bou_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nywie mwamba ati naguusa mazaiko kwa udaho wa Belizebuli mkuu wa mazaiko. Awo wana wenu wayaguusa kwa udaho wa ndai? Kwaajii iyo wao nee wendao awaamuiye nywinywi. ");
INSERT INTO bou_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akini ikawa nayaguusa mazaiko kwa udaho wa Muye wa Muungu, aho mmanye Useuta wa Muungu ubua kae henu. ");
INSERT INTO bou_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Yadahika viivihi mntu kwengia mwe nyumba ya mntu mwenye nguvu na kumhoka vintu vyakwe, kwesaho kuvoka kumzengeteza sigi uyo mntu mwenye nguvu? Akimzengeteza kae aho ndiho endahoadahe kumhoka mai zakwe. ");
INSERT INTO bou_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mntu yoyose mwese kuwa hamwe na miye ahigana na miye naho mtu yoyose mwesaekuika wantu hamwe na miye na kuwegaa kwa Muungu mtu uyo amwaganisa. ");
INSERT INTO bou_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwaajii iyo nawamba, wantu wenda waekewe mavigaviga yao hamwe na kufuu zao, akini khawana waekewe mavigaviga ya kumbea Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nae agombekae mbui ya kuhigana na Mwana wa Mntu enda aekewe, akini yuda agombekae mbui ya kuhigana na Muye wa Muungu khana aekewe mwe si inu wala ida yezayo. ");
INSERT INTO bou_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ukauweni mti uwe mtana na matunda yakwe yenda yawe matana na ugosoeni mti kuwa mfyaimi na matunda yakwe yenda yawe mafyaimi, kwaviya mti wamanyika kwa matunda yakwe. ");
INSERT INTO bou_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nywie uvyazi wa mdudu mwadaha viivihi kugombeka mbui ntana kisingi nywinywi wenye ni wenye mavigaviga? Kwaviya mntu agombeka yada yekumemayo mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mntu yedi ulavya mbui zedi mwe moyo wakwe na mntu mfyaimi hulavya mbui zakwe za ufyaimi kwe moyo wakwe wa ufyaimi. ");
INSERT INTO bou_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Iya nawamba, mwe msi wakuamuiwa wantu wenda wakundigwe kutambaisa kuusu kia mbui wekugombekayo. ");
INSERT INTO bou_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwaviya kwayada ugombekayo wendautaaziwe kuwa uyedi hemeso ya Muungu na kwa kugombeka wendauamuiwe.” ");
INSERT INTO bou_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wamwe wa wahinyi wa Miko na Mafalisayo wakamwamba Yesu, “Mhinyi takunda kuona ntangio kulawa kwako.” ");
INSERT INTO bou_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iya yee akawatambaisa, “Kivyazi chesacho kutama na cha ukianga chaondeza ntangio! Iya khakina chekhigwe ntangio iya ntangio wa Yona muoni wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kwaviya inga Yona ekuwavyo mwe ifu da samaki etangwae Nyangumi, nee ivyo Mwana wa Mntu endavyoekae asi ya sanga kwa misi mitatu kio na musi. ");
INSERT INTO bou_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wantu wa Ninawi wenda wagooke msi wa kuamuiwa hamwe na uvyazi unu na kuwaamuiiya, kwaviya wowo wayaeka mavigaviga kwa mabiikizi ya Yona, kauwa hanu yuaho ambae ni mkuu kusima Yona! ");
INSERT INTO bou_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Maikia wa kusini endaagooke kisingi cha uamuiyo na kukiamuiya kivyazi iki, kwaviya yee kalawiiya kisikiizi cha inusi, kutegeeza umanyi wa Selemani, akeza kutegeeza mbui za umanyi wa Selemani na aha yuaho ekuwae mkuu kusima Selemani. ");
INSERT INTO bou_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Zaiko dimlawaho mntu, daangadika angadika mwe hantu hesiho na mazi dikoondeza hantu hakuhumwiiza akini kadipata, ");
INSERT INTO bou_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","aho egombekea mwenye, ‘Nenda niiuiye ida nyumba yangu nekulawayo.’ Iya auyaho na kuibwiiya ibue ihagiwa na kuhambwa vitana. ");
INSERT INTO bou_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aho, aita kuwaeta mazaiko mfungate wafyaimi kusima yee, nao wengia nakwekaa umo. Nae hali ya kisiikizi ya mntu yuda yatenda ya ufyaimi muno kusima ya bosi. Nee yendavyoiwe mwe uvyazi unu wa mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ekuwaho atamwiiya na zumwezumwe da wantu, mami yakwe na wanduguze wakabua na kugooka chongoi na kukunda kutamwiiya nae. ");
INSERT INTO bou_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aho mntu yumwe akamwamba, “Mhinyi, mami yako na wanduguzo wagooka uko chongoi wakunda kutamwiiya nawe.” ");
INSERT INTO bou_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu akamtambaisa, “Mmaa yangu nindai, na wandugu zangu ni wakina ndai?” ");
INSERT INTO bou_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ahoaho akenua mkono kwa wahina wakwe, akagombeka, “Awa nee mmaa yangu na wandugu zangu! ");
INSERT INTO bou_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mana yoyose agosoae akundavyo Tate yangu wa uwanga kwa Muungu, uyo nee kaka yangu na umbu dangu na mmaa yangu.” ");
INSERT INTO bou_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Msi uwouwo Yesu akalawa mwe nyumba ida, akaita na kwekaa khandakhanda ya mazimshindo. ");
INSERT INTO bou_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Zumwezumwe kuu da wantu wakamwekaiya bunga nee Yesu akakwea mwe ngaawa na kwekaa. Nawo wantu wose wakagooka khandakhanda ya mazimshindo, ");
INSERT INTO bou_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","nae Yesu akatamwiiya nawo mbui nyingi muno kwa misimo. “Tegeezani, muimi kaita kuhanda mbeyu. ");
INSERT INTO bou_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ekuwaho akahanda mbeyu mwe mnda, mbeyu ntuhu zikagwa khandakhanda ya sia, wadege wakeza na kuzida. ");
INSERT INTO bou_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ntuhu zikagwa hantu ha uwongo wekuwao uwanga ya iwe, ahoaho zikaoneka kuhota kwa kinyio. ");
INSERT INTO bou_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iya zua dekusomookaho, mitengea iyo ikahya na kwaviya mazindo yakwe khayokwengia asi muno, zikanyaa. ");
INSERT INTO bou_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu ntuhu zikagwa gatigati ya miwa, miwa iyo ikakuwa na kufintafinta ida mitengea. ");
INSERT INTO bou_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Naho mbeyu ntuhu zikagwa he uwongo ntana, na mitengea yakwe ikavyaa khokoo makumi kumi na ntuhu makumi mtandatu na ntuhu makumi matatu.” ");
INSERT INTO bou_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu akawamba, “Mwenye magutwi na ategeeze!” ");
INSERT INTO bou_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naho wahina wakamtimia na kumuuza Yesu, “Kwa mbwai wagombeka na wantu kwa misimo?” ");
INSERT INTO bou_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akawatambaisa, “Muungu kawekha nywie udaho wa kumanya sii za Useuta wakwe, akini wowo khamwekwekhigwa udaho wa kumanya ayo yose. ");
INSERT INTO bou_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mntu yeyose ambae amanya kuusu Useuta wa Muungu, Muungu endaamgosoe kwevana muno, iya mtu esayekumanya ata kidodo, Muungu endaadoe ata kiya kidodo akimanyacho. ");
INSERT INTO bou_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nagombeka nao kwa misimo, kwaajii wakauwa niyagosoayo, iya wegosoa khawaona, na wategeeza nihinyayo, iya wegosoa khawava. ");
INSERT INTO bou_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yaigania kwao yada ekugombekayo muoni Isaya, ‘Wantu awa wendawategeeze na kutegeeza akini khamnamnive; Kukauwa mwenda mkauwe, wala khamnamuone, ");
INSERT INTO bou_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwaajii akii za wantu awa zihuuzuka Waziba magutwi yao Meso yao wayafumba. Ama khivyo nee woona kwa meso yao, Nee wategeeza kwa magutwi yao, Nee wamanya kwa akii zao, Na kunihitukia agombeka Zumbe na miye nee kiwahonya.’ ");
INSERT INTO bou_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mwenda muwe na nyemi nywie, kwaviya meso yenu, kwaajii yakauwa na magutwi yenu kwaajii ya tegeeza. ");
INSERT INTO bou_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kwei nawamba, Waoni wangi na wantu wedi watamiwa kuyaona yada mwekuyaonayo nywie, iya khwekuyaona, na nee watamiwa muno kutegeeza yada myategeezayo iya khawekuyategeeza. ");
INSERT INTO bou_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Naho tegeezani mana ya msimo wa yuda mntu ekuwaye ahanda mbeyu. ");
INSERT INTO bou_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mntu yoyose ategeezae mbui inu ya Useuta wa Muungu kwesiho kuva, aigana na zia mbeyu zekugwazo siai. Yuda Ibiisi eza na kumhoka kia chekuhandwacho mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ida mbeyu zekugwiswazo mwe uwongo wekuwao uwanga ya iwe ni mntu yuda ateegeeza Mbui ya Muungu na ahoaho huihokea kwa nyemi. ");
INSERT INTO bou_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iya kwaviya khana mazindo yenye udaho ndani yakwe, ida mbui yekaa kisingi kijihi. Ilawiiaho suuba hambu masuumizo kwaajii ya mbui iyo, yee afa maya. ");
INSERT INTO bou_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ida mbeyu yekugwayo mwe miwa ni yuda mntu ategeezae mbui, akini maangadiko ya inusi na usongeezi wa mai yaifintafinta ida mbui na kuigosoa yesekuvyaa matunda. ");
INSERT INTO bou_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ida mbeyu yekuhandwayo mwe uwongo mtana ni sawa na mntu ategeezae mbui iyo na kuiva, nae avyaa matunda, makumi kumi mtuhu makumi mtandatu na mtuhu makumi matatu.” ");
INSERT INTO bou_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu akawamba wantu msimo mtuhu, “Useuta wa uwanga kwa Muungu waigana na mntu mwekuhanda mbeyu ntana mwe mnda wakwe. ");
INSERT INTO bou_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iya wantu wekuwaho wagona akeza mmasa wakwe akahanda ndago gatigati ya mnda wa uhemba, akaita. ");
INSERT INTO bou_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naho mbeyu zekuhotaho na mitengea ikakuwa na kuvoka kuvyaa, viyaviya ndago ikavoka kuoneka. ");
INSERT INTO bou_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wandima wa yuda mwenye mnda wakamwezea na kumwamba, ‘Mkuu khwekuhanda mbeyu ntana mweunu mnda wako? Inu ndago ilawiiya hahi?’ ");
INSERT INTO bou_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yee akawatambaisa ‘Mmasa nee mwekutenda ivyo.’ Wandima wakwe wakamuuza, ‘Ivi, wakunda tiite tikayang'oe?’ ");
INSERT INTO bou_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Iya akagombeka ‘mwesekuita kuyausa kwaviya kisingi muusaho mainde, mwadaha kuusa ndago hamwe na uhemba.’ ");
INSERT INTO bou_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ekani uhemba na mainde vikue vyose hamwe adi kisingi cha ubosi. Kisingi icho nenda niwambe wabosi, wavoke kuika hamwe mainde, wayafunge matitamatita yokwe moto wakabinda waike hamwe na uhemba na kuika mwe taa.” ");
INSERT INTO bou_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu akawamba wantu msimo mtuhu, “Useuta wa uwanga kwa Muungu waigana na mbeyu yetangwayo haladali ekuidoayo mntu yumwe, akaihanda mwe mnda wakwe. ");
INSERT INTO bou_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu iyo ni ndodo kusima mbeyu zose, akini ihotaho yawa mtenge mkuu kusima mitengea yose, naho yakuwa na kutenda mti mkuu na wadege wawezea mti uwo na kuzenga masasa mwe matambi yakwe.” ");
INSERT INTO bou_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu akawagombeka msimo mtuhu, “Useuta wa uwanga wa Muungu waigana na hamila ekudoayo mvyee yumwe, akaihanganya mwe madebe yakwe maidi ya unga wa ngano na hindi, ata unga wose ukaumuka.” ");
INSERT INTO bou_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nee kawamba ayo zumwezumwe da wantu kwa misimo. Na khekuwamba dodose kwesiho misimo. ");
INSERT INTO bou_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ili mbui yekugombekwayo na Muoni iiganie, “Nenda nigombeke nao kwa misimo, Nendaniyatamwiize yada yekufiswayo tangia kuumbwa kwa inusi.” ");
INSERT INTO bou_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Naho Yesu akadiaga dia zumwezumwe da wantu, akengia nyumbani. Wahina wakwe wakamtimia na kumwamba, “Tisosoee mana ya uda msimo wa mainde za mwe mnda.” ");
INSERT INTO bou_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu akawatambaisa, “Mhasi wa zia mbeyu ntana ni Mwana wa Mntu, ");
INSERT INTO bou_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","uda mnda ni inusi. Zia mbeyu ntana ni wantu wada ambao Useuta ni wao. Akini yada mainde ni wada wantu wa Ibiisi, ");
INSERT INTO bou_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mmasa mwe kuhanda ida mainde ni Ibiisi, ubosi ni kisikiizi cha inusi wabondaji ni wandima wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Inga viya muonavyo mainde yaikwavyo hamwe na kokwa moto, nee ivyo vyendavyo viwe mwe kisikiizi cha inusi. ");
INSERT INTO bou_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Mntu enda awaagiiye wandima wakwe wa uwanga kwa Muungu wawaike hamwe wantu kulawa mwe Useuta wakwe, na wada wose wawatendao wantu wagosoe mavigaviga na wada wose wagosoao ubanasi, ");
INSERT INTO bou_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuwatambika mwe tanuli da moto, na uko wendawaiye na kuuma meno kwaajii maumevu makai. ");
INSERT INTO bou_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naho wada wantu wekugosoayo yada yamtamiayo Muungu wendawang'ae inga zua mwe Useuta wa Tate yao. Mwenye magutwi na ategeeze! ");
INSERT INTO bou_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Useuta wa uwanga wa Muungu waigana na kiikizo chekufiswacho mwe mnda. Mntu yumwe ekuiyonaho akaifisa vituhu, akawa na kinyemi muno akenda kutaga vintu vyose ekuwavyo navyo, na akaugua uda mnda.” ");
INSERT INTO bou_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naho Useuta wa uwanga kwa Muungu waigana na mtabiashaa yumwe mwoondeza lulu ntana, ");
INSERT INTO bou_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na ekupataho lulu mwenga ya hea nyingi muno, akenda kutaga vyose ekuwavyo navyo, akaigua ida lulu.” ");
INSERT INTO bou_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Naho, Useuta wa uwanga kwa Muungu waigana na wavu wekwasigwao na walowa samaki mwe mazimshindo, ukagwiiya samaki wa kia mbai, ");
INSERT INTO bou_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wekumemaho, wantu wakaubuuta adi khandakhanda ya mazimshindo, wakekaa na kuwasaguwa samaki watana na kuwaika mwe majumu yao na samaki wafyaimi wakasigwa.” ");
INSERT INTO bou_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nee ivyo vyendavyoviwe kisikiizi cha inusi, wandima wa uwanga kwa Muungu wendawalawiiye, na kuwabahua wantu wafyaimi na wantu wedi, ");
INSERT INTO bou_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nakuwasa awo wafyaimi mwe tanuli da moto. Uko wendawaiye na kuuma meno kwa maumevu makai. ");
INSERT INTO bou_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu akawauza, “Ivi, mbui izi mzimanya zose?” Wakamtambaisa, “Eehe.” ");
INSERT INTO bou_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nae akawamba, “Nee ivyo, kia mhinyi wa miko ya Musa awaye mhina wa Useuta wa Muungu aigana na mwenye kaya alavyae kiikizo chakwe cha vintu vihya na vya kae.” ");
INSERT INTO bou_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu ekubindaho kutamwiiya misimo iyo akahauka hantu aho, ");
INSERT INTO bou_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akaita mwe mzi wakwe. Uko akawa awahinya wantu mwe nyumba ya kukintania Wayahudi ata wakahondomaa, wakamba, “Uyu kaipata hahi akii nyingi ivi,” wakauza, “Na udaho wa kugosoa vihii? ");
INSERT INTO bou_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uyu khio yuda mwana seemaa? Mami yakwe khio yuda etangwae Maliamu na wanduguze khio Yakobo na Yusufu na Simoni na Yuda? ");
INSERT INTO bou_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naho umbuze wose khawekaa hamwe na swie? Naho khayapata hahi aya yose?” ");
INSERT INTO bou_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wakamuemea. Iya Yesu akawamba, “Muoni atunywa na kia hantu kwesiho wantu wa mwe si yakwe na kaya kwakwe.” ");
INSERT INTO bou_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nae khekugosoa vihii vingi uko, kwaajii ya kwesekuzumiiya kwao. ");
INSERT INTO bou_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kisingi icho Seuta Helode ekuwae mgookezi wa si ya Galilaya nee kategeeza mbui za Yesu. ");
INSERT INTO bou_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akawagombeka wandima wakwe, “Uyo nee Yohana Mbatiiza, ekuyuyukae, nee mana ana udaho wakugosoa mbui za vihii uumo mwakwe.” ");
INSERT INTO bou_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode nee kamgwiiya Yohana Mbatiiza akamzengeteza minyololo na akamwengiza mwe geeza kwaajii ya Helodia mkaza Filipo nduguye da Helode. ");
INSERT INTO bou_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwaajii Yohana Mbatiiza kamwamba Helode, “Khio vitana kumdoa Helodia awe mkazio!” ");
INSERT INTO bou_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode nee kakunda kumkoma Yohana Mbatiiza, iya nee akawaogoha Wayahudi, kwaajii wao wenye nee wakamanya kuwa Yohana Mbatiiza nekawa Muoni wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ata yekubuaho sikukhuu ya kuvyaigwa kwakwe Helode, mwana kindee wa Helodia akavina hemeso ya wageni wekugonekwao. Adi Helode akatamiwa muno, ");
INSERT INTO bou_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ata akaika kiaga kwa kuaha, “Nenda nikwekhe chochose wendacho uniombeze.” ");
INSERT INTO bou_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uyo mndee nee kanchochewa kae na mami yakwe akamba. “Nekha mtwi wa Yohana Mbatiiza mwe chano!” ");
INSERT INTO bou_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Seuta Helode akaungumia mwe moyo wakwe akini kwaajii ya kuaaha kwakwe hemeso ya wada wageni wekuwao he ntafuno akaagiiya ekhigwe. ");
INSERT INTO bou_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Helode akaagiiya mntu kuda mwe geeza Yohana mbatiiza adumue mtwi. ");
INSERT INTO bou_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mtwi wake ukaetwa uikwa mwe chano, wakamwekha yuda mwana kindee, nae akamwegaiya mami yakwe. ");
INSERT INTO bou_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wahina wakwe Yohana Mbatiiza wakeza mwe geeza na kuudoa mwii wakwe na kuugea mwe mbia. Wekubindaho wakaita na kumwamba Yesu. ");
INSERT INTO bou_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ekusikiaho mbui ya Yohana Mbatiiza akahauka hantu hada kwa ngaawa, akaita hantu hesiho wantu yee ukedu. Wantu wakamtimia kwa miundi kulawa mwe mizi yao. ");
INSERT INTO bou_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aho ekuseaho khandakhanda ya mazimshindo akoona zumwezumwe kuu da wantu, akawafiiya mbazi na akawahonya watamu wao. ");
INSERT INTO bou_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Zuwa dekuswaho wahina wakwe wakambasa na kugombeka, “Hantu aha khahana wantu wekaisao aha na saa zemboka kae. Agana na awa wantu ili waite mwe mizi wakeguiye khande.” ");
INSERT INTO bou_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu akawatambaisa, “Khawakundigwa kuhauka wekheni nywinywi khande.” ");
INSERT INTO bou_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iya wao wakamtambaisa, “Tina mabumunda mashano na samaki waidi du.” ");
INSERT INTO bou_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu akawamba, “Nieteyani hanu.” ");
INSERT INTO bou_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akawakunda wantu wekae asi mwe mani. Yesu akayadoa yada mabumunda mashano na wada samaki waidi, akakauwa uwanga kwa Muungu, akavijaiya na kubendua yada mabumunda aho akawekha wahina wakwe ayo mabumunda na wada samaki, na wahina wakwe wakawekha wada wantu. ");
INSERT INTO bou_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wantu wose wakada na kweguta. Aho wahina wakadodoa phuguntio, na wakamemeeza ngahu kumi dimwe na mbii. ");
INSERT INTO bou_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wantu wekudao ntaazia yao nee ni wagosi elufu shano kwesiho kutaazia wavyee na wana. ");
INSERT INTO bou_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ahoaho Yesu akawamba wahina wakwe wengie mwe ngaawa waongoe na kuita phande ya kaidi ya tondoo da mazi, kisingi yee aagana na zumwezumwe da wantu. ");
INSERT INTO bou_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ekubindaho kuwaaga, akakwea mwe muima yee ukedu kuvika. Na yekubuwaho guoni yee nekekaa uko ikedu kidege, ");
INSERT INTO bou_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kwa kisingi icho ida ngaawa nee igatigati ya tondoo da mazi yakubwaniswa na mazi kwaajii khusi khai nee yaikindia ngaawa. ");
INSERT INTO bou_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kio, hehi na kucha, Yesu akawatimia wahina wakwe uku enda uwanga ya mazi. ");
INSERT INTO bou_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wahina wakwe wekumwonaho akenda uwanga ya mazi wakaogoha muno, wakagombeka, “Ni mzimu!” Wakatoa vuzo kwa ukeng'enta. ");
INSERT INTO bou_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ahoaho Yesu akagombeka nao, “Twiiyani, ni miye, msekuogoha!” ");
INSERT INTO bou_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo akamwamba, “Zumbe, ikawa ni wee kwei, nambia nende uwanga ya mazi neze aho hako.” ");
INSERT INTO bou_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akamtambaisa, “Soo!” Aho Petulo akaseeya mwe ida ngaawa, akenda uwanga ya mazi na kumtimia Yesu. ");
INSERT INTO bou_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Akini ekuonaho khusi khai akengiwa ni matu nae akavoka kudidimia mwe mazi, uku atoa vuzo, “Zumbe niohoe!” ");
INSERT INTO bou_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ahoaho Yesu akanyoosha mkono wakwe na kumtoza, akamwamba, “Wee mwenye uzumizi mcheche kwambwai kuwa na maatu?” ");
INSERT INTO bou_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nao wekwengiaho mwe ngaawa, khusi ikaeka. ");
INSERT INTO bou_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wose wekuwao mda mwe ngaawa wakakinta mavindi na kwemwenamia na kugombeka, “Ni kwei wee ni Mwana wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wekubindaho kudumua tondoo da mazi, wakabua si ya Genesaleti. ");
INSERT INTO bou_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wantu wekummanyaho Yesu, wakaambaza mbui zakwe mwe si yose na mizi yekuwayo hehi na mzi uda, ivyo wakamwetea Yesu watamu wose. ");
INSERT INTO bou_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wakamwombeza awaekee wadonte msao wa nguo yakwe, na wose wekudontao wakahona. ");
INSERT INTO bou_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naho, Mafalisayo na wahinyi wa miko ya Musa wakabua kulawa Yelusalemu, wakamtimia Yesu na kumuuza, ");
INSERT INTO bou_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwambwai wahina wako khawapatiiza mahinyo tekuyahokeayo kwa waongoweezi wetu wa kae? Khawasunta inga mazweeya yetu yakundavyo!” ");
INSERT INTO bou_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akawatambaisa, “Kwambwai nywie nanywi khampatiiza miko ya Muungu iya mwayabasa mahinyo yenu wenye? ");
INSERT INTO bou_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwaviya Muungu kagombeka, ‘Na mntu yoyose amtunyae tati yake na mami yake na mntu yoyose amdumuae tati yakwe hambu mami yakwe, yakundigwa akomwe.’ ");
INSERT INTO bou_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iya nywie mwahinya inga mntu akawa na kintu ambacho chadaha kumwambiiza tati yakwe au mami yakwe, iya akamba, ‘Kintu iki ni cha Muungu,’ ");
INSERT INTO bou_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nywie wagombeka khudaha kumtunya tati yako kwa kumuambiiza kwa kumwekha kintu icho! Ivyo nee mbeavyo Mbui ya Muungu kwa kutongea mahinyo yenu wenye. ");
INSERT INTO bou_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nywie wabakha! Muoni Isaya kaambiza vyedi kwenu nywinywi, ");
INSERT INTO bou_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Muungu amba Wantu awa wanitunya kwa ntamwiizi zao, Iya mwe mioyo yao wahae na miye. ");
INSERT INTO bou_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunivika kwao khakuwaambiiza dodose, Kwaviya mahinyo wahinyayo ni wantu ni du wekuyagoayo wao wenye!’ ” ");
INSERT INTO bou_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu akawetanga wada zumwezumwe da wantu, akagombeka, “Tegeezani, na mnive! ");
INSERT INTO bou_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kintu kimtendacho mntu asekuzumiiwa kuwa he meso ya Muungu khio via vyengiavyo mwe muomo, iya ntamwiizi zimlawazo mwe muomo. Ivyo nee vimtendavyo mntu asekuzumiiwa kuwa he meso ya Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aho wahina wakambasa nakumwamba, “Ivi, wamanya kuwa Mafalisayo wakimwa muno wekutegeezaho mbui zako?” ");
INSERT INTO bou_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu akawatambaisa, “Kintu chochose ambacho Tate yangu wa uwanga kwa Muungu khekuhanda chendaking'olwe.” ");
INSERT INTO bou_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wabadeni wenye, wowo ni matuntu na waongweeya matuntu. Inga tuntu akamwongoeya tuntu mweziwe, wose waidi wendawengiye mwe tubwi. ");
INSERT INTO bou_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo akamba, “Tisosoee msimo uwo.” ");
INSERT INTO bou_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu akawamba, “Hata nywie khammanya? ");
INSERT INTO bou_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ivi khammanya kuwa kia chengiacho kanwai chengia mweifu na kulavigwa chongoi na kuita nkii? ");
INSERT INTO bou_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iya mbui zilawazo kanwai zalawa mwe moyo na mbui izo nee zimtendazo mntu asekuzumiiwa kuwa he meso ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwaviya umo mwe moyo wa mntu kwalawa fanyanyi za ufyaimi na ukomaji na ukianga na kianga na ubavi na ugombekaji wa uhokho na kuwagombekea watuhu mafyaimi. ");
INSERT INTO bou_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ayo nee yamtendayo mntu asekuzumiiwa ni Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu akahauka hantu hada akaita mwe si ambazo ni hehi na mizi ya Tilo na Sidoni, ");
INSERT INTO bou_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aho mvyee yumwe ekuwae ni mkanaani ambae nee kawa akekaa mwe si iyo akamtimia Yesu, nakutoa mgutio, “Zumbe, Mwana wa Daudi, unifiiye mbazi! Mwanangu wa kivyee apishwapishwa ni mazaiko.” ");
INSERT INTO bou_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iya Yesu khekumwandua mbui yoyose. Aho, wahina wakwe wakambasa Yesu, na kumwamba, “Umwambe aite kwaviya atibasabasa na kutitoeya vuzo!” ");
INSERT INTO bou_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akamtambaisa, “Khiagiiwa kwaajii ya wantu wa si ya Isilaeli wakwagao inga ngoto.” ");
INSERT INTO bou_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iya yuda mmaa akeza na kukinta mavindi hemeso ya Yesu na kumwamba, “Zumbe, niambiize!” ");
INSERT INTO bou_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu akamtambaisa, “Khio vitana kudoa khande ya wana na kuwatambikia makui.” ");
INSERT INTO bou_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yuda mmaa akamtambaisa, “Ni kwei Zumbe, akini hata makui yada phuguntio zigwiswazo kulawa he meza za mazumbe wao.” ");
INSERT INTO bou_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aho Yesu akamtambaisa, “Mmaa uzumizi wako ni mkuu na itende inga wekukundavyo.” Yuda mdee akahona kisingi ichoicho. ");
INSERT INTO bou_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu akahauka na kuita khandakhanda ya tondoo da mazi ya Galilaya. Aho akakwea mwe muima akekaa uko. ");
INSERT INTO bou_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zumwezumwe kuu da wantu dikamwezea, wakamuetea wantu wekuviao na matuntu na wekuviao miundi na mabubu na watuhu watamu wangi, wakawaika hemeso yakwe Yesu nae akawahonya. ");
INSERT INTO bou_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Awo wantu wakahondomaa wekuonaho mabubu watamwiiya na wekuviao miundi wenda na matuntu waona, wantu wakamtogoa Muungu wa wantu wa Isilaeli. ");
INSERT INTO bou_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aho Yesu akawetanga wahina wakwe akagombeka, “Nawafiiya mbazi wantu awa kwaajii wawa na miye misi mitatu, naho khawana khande. Khikunda kuwabada waite na saa, wasekweza kugwa msae siai.” ");
INSERT INTO bou_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wahina wakwe wakamwamba, “Hantu hanu khahana wantu, tendatiipatie kuhi khande ya kuigania wantu wose awa?” ");
INSERT INTO bou_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu akawauza, “Mnayo mabumunda mangahi?” Wakamtambaisa, “Tinayo mabumunda mfungate na visamaki vidodo naho ni vicheche.” ");
INSERT INTO bou_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aho akawamba wada wantu wekae asi. ");
INSERT INTO bou_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akayadoa yada mabumunda mfungate na via visamaki vicheche, akamtogoa Muungu, akavibendua, akawekha wahina, nao wakawapangia wada wantu. ");
INSERT INTO bou_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose wakada na kweguta. Wahina wakwe wakaika hamwe phuguntio vya vyekusigaavyo wakamemeeza ngahu mfungate. ");
INSERT INTO bou_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Awo wekudao nee wawa wagosidu elufu nne kwesaho kutaazia wavyee na wana. ");
INSERT INTO bou_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aho, Yesu akaagana na wada wantu akengia mwe ngaawa, akaita phande za Magadani. ");
INSERT INTO bou_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo wakamwezea Yesu, na kumgeeza kwa kumwoombeza awagosoee ntangio kulawa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Akawatambaisa akawamba, “Ibuaho guoni mwagombeka, ‘Hali ya hewa yendaiwe ni ntana kwaviya maangwi ni mekhundu.’ ");
INSERT INTO bou_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na keokeo mwagombeka, ‘Ivyeo fua yendainye kwaajii ni yasize nahodu mazunde yatanda.’ Naho nywie mwamanya muno kusoma misimu na kuikauwa hali ya uwanga, iya khammanya ntangio zilawiiyazo kisingi iki. ");
INSERT INTO bou_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kivyazi cha wantu wabanasi na chesacho kuwa na uzumizi! Chakunda ntangio, akini khakina chekhigwe ntangio yoyose, iya ida ntangio ya Yona, Yesu akawabada, akaita.” ");
INSERT INTO bou_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wahina wakwe wekubuaho phande ya kaidi ya tondoo da mazi, wakakumbuka wajaa kudoa mabumunda. ");
INSERT INTO bou_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu akawamba, “Kauwani, na muiyemee hamila ya Mafalisayo na Masadukayo.” ");
INSERT INTO bou_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Akini wakauzana wowo kwa wowo, “Tambe agombeka ivyo kwakuwa khatekudoa mabumunda.” ");
INSERT INTO bou_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu akamanya yada wekuwayo watamwiiya akawamba, “Nywie wantu wenye uzumizi mdodo! Kwambwai mwauzanauzana kwa kwesekuwa na mabumunda ");
INSERT INTO bou_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ivi khamzati kuniva? Khamkumbuka nekubenduaho yada mabumunda mashano kwaajii ya wada wantu elufu shano? Mmemeeza ngahu nyingahi ya vyekusigaavyo? ");
INSERT INTO bou_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hambu yada mabumunda mfungate wekudao wada wantu elufu nne, nee mwiika hamwe ngahu nyingahi ya vyekusigaavyo. ");
INSERT INTO bou_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kwambwai mwavotwa kumanya miye nchekuwa nikatamwiiya mbui ya mabumunda? Ekauweni na hamila ya Mafalisayo na Masadukayo!” ");
INSERT INTO bou_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aho wahina wakamanya kuwa kawamba waemee khio hamila ya mabumunda, iya mahinyo ya Mafalisayo na Masadukayo. ");
INSERT INTO bou_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ekubuaho phande za Kaisalia Filipi, akawauza wahina wakwe, “Wantu wagombeka Mwana wa Mntu kuwa nindai?” ");
INSERT INTO bou_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wakamtambaisa, “Watuhu wamba ni Yohana Mbatiiza na watuhu wamba ni Eliya na watuhu wamba ni Jelemia hambu yumwe wa Waoni.” ");
INSERT INTO bou_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu akawauza, “Ivi, nywinywi mwambaze, miye nindai?” ");
INSERT INTO bou_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo akamtambaisa, “Wee nee Klistu, Mwana wa Muungu ekuwaye na ugima.” ");
INSERT INTO bou_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akagombeka, “Wenda uwe na nyemi Simoni mwana wa Yona, kwaviya khahana mntu yoyose mwekukugubwiiya mbui inu, iya Tate yangu wa uwanga kwa Muungu ekukugubuiaye mbui izi. ");
INSERT INTO bou_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ivyo nakwamba, wee nee Petulo na uwanga ya iwe idi nendanizenge zumwezumwe da wantu wamzumiiyao Klistu, na udaho wa ufe khaunaudahe kudivota. ");
INSERT INTO bou_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nendanikwekhe funguo za Useuta wa uwanga kwa Muungu, na dodose wendadoudivugae mwe inusi dendadiwe divugalwa uko uwanga kwa Muungu, na dodose wendado udivugue mwe inusi dendadiwe divugulwa uko uwanga kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aho akawaemeza wahina wakwe wasekumwamba mntu yoyose kuwa yee nee mwekusagulwa ni Muungu. ");
INSERT INTO bou_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tangia kisingi icho Yesu akavoka kuwamanyisa pwii wahina wakwe, kuwa nakundigwa niite Yelusalemu na uko nendanekhigwe usuumizi mwingi kulawa kwa wadaa na Waviki wakuu na wahinyi wa miko na nendanikomwe, na msi wa ntatu nendaniyuyuke. ");
INSERT INTO bou_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aho Petulo akamdoa khandai akavoka kumwakia Yesu, “Zumbe isekuwa ivyo, mbui iyo khaina ikubwiiye!” ");
INSERT INTO bou_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu akahituka na kumwamba Petulo, “Hauke he meso yangu, Ibiisi! Wee ukikindio changu. Moyo wako khaumamakanya yekuwayo ya Muungu iya ya wantu.” ");
INSERT INTO bou_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aho Yesu akawamba wahina wakwe, “Mntu yoyose akakunda kunitongea yakundigwa eemee mwenye na audoe mhamba wakwe anitongee. ");
INSERT INTO bou_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwaviya mntu akakunda kuuhonya ugima wakwe mwenye, endaawaze, ");
INSERT INTO bou_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","na mntu endae awaze ugima wakwe kwaajii yangu endaekhigwe. Ivi, mntu endaafaidike mbwai akekhigwa vintu vyose vya inusi uku akawaza ugima wakwe? Hambu mntu endaalavye kintu chani kiwe badala yakwe? ");
INSERT INTO bou_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwaviya, Mwana wa Mntu endaeze na udeeko wa Tati yakwe hamwe na wandima wa uwanga kwa Muungu na aho ndiho endahoamwiihe kiya mntu kwa kadii ya ntendwa zakwe. ");
INSERT INTO bou_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nawamba kwei, wauko watuhu hanu ambao khawana wauye na nyuma kabla ya kumoona Mwana wa Mntu akeza mwe useuta wakwe.” ");
INSERT INTO bou_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yekwembokaho misi mtandatu, Yesu akawadoa Petulo na Yakobo na Yohana nduguye akaita nao hadi uwanga ya muima uko nee wawa ikedu. ");
INSERT INTO bou_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wekuwaho uko Yesu akahituka cheni hemeso yao. Cheni chakwe kikang'ang'azika inga zuwa na magwanda yakwe yakang'ang'azika inga ung'azi. ");
INSERT INTO bou_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naho wada wahina watatu nee wawaona Musa na Eliya wakatamwiiya na Yesu. ");
INSERT INTO bou_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aho Petulo akamwamba Yesu, “Zumbe, nivitana sie kuwa hanu! Ukakunda nendanizenge makumbi matatu. Dimwe dako na dimwe da Musa na kitudu cha Eliya.” ");
INSERT INTO bou_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ekuwaho bado agombeka, zunde dekung'aado dikawagubika, na mgutio ukategeezeka kulawa mwe dia zunde, “Uyu ni Mwanangu nimkundisae, nitamiwae nae, mtegeezeni yee.” ");
INSERT INTO bou_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wahina wekutegeezavyo ivyo, nee wakagwa asi na kugonea maifu, wakaogoha muno ");
INSERT INTO bou_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu akawezea akawadonta, akawamba, “Gookani msekuogoha!” ");
INSERT INTO bou_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wekukauwaho uwanga khawekumwona mntu mtuhu, iya Yesu ikedu. ");
INSERT INTO bou_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aho wekuwaho waseeya mwe muima Yesu akawaemeza, “Wasekumwamba mntu mbui wekuonazo adi Mwana wa Mntu endaho ayuyuke.” ");
INSERT INTO bou_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aho wahina wakamuuza, “Kwa mbwai wahinyi wa miko wagombeka kuwa yakundigwa Eliya avoke kweza?” ");
INSERT INTO bou_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akawatambaisa, “Ni kwei, yakundigwa Eliya avoke kweza na kuika vitana mbui zose.” ");
INSERT INTO bou_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Akini nawamba Eliya keza kae, iya wantu khawekummanya, iya wakamgosoeya mbui za ufyaimi inga wakundavyo. Viyaviya Mwana wa Mntu enda asuumizwe mwe mikono yao. ");
INSERT INTO bou_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aho awo wahina wakamanya kuwa nee akawamba mbui za Yohana Mbatiiza. ");
INSERT INTO bou_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wekudibwiiyaho vituhu dia zumwezumwe da wantu, mntu yumwe akamwezea Yesu na kumkintia mavindi, ");
INSERT INTO bou_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akagombeka, “Zumbe mfiiye mbazi mwanangu kwaviya agwa mtwi naho asumiiya muno, maa nyingi agwa mwe moto na mwe mazi. ");
INSERT INTO bou_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Khiwaetea wahina wako iya khawekudaha kumhonya.” ");
INSERT INTO bou_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu akawatambaisa, “Nywie wantu wa kivyazi iki chesacho kuzumiiya, chekuatukacho! Nenda nekae na nyie adi ini? Nendaniwazizimize ata ini? Mweteni hanu uyo mbwanga.” ");
INSERT INTO bou_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aho Yesu akadiwakia ido zaiko nado dikamlawa yuda mbwanga akahona kisingi kia kia. ");
INSERT INTO bou_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aho wahina wakwe wakamtimia Yesu hantu kwesiho wantu, wakamuuza, “Kwa mbwai sie khatokudaha kumlavya yuda zaiko?” ");
INSERT INTO bou_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akawatambaisa kwaajii ya uzumizi wenu mdodo. Nawamba kwei, ati nee muwa na uzumizi inga khokhoo ya haladali nee mkawamba muima unu hauke aha uite hada, nao wendauhauke. Ivyo khahana mbui yoyose yesayokudahika kwenu. ");
INSERT INTO bou_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mbui inga inu khaidahika iya kwa kuvika na kwa kwehiniza kuda. ");
INSERT INTO bou_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu ekuwaho na wahina wakwe uko Galilaya akawamba, “Mwana wa Mntu enda alavigwe kwa wantu. ");
INSERT INTO bou_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nao wenda wamkome na msi wa ntatu enda ayuyuke.” Wahina wakwe wakaungumia muno. ");
INSERT INTO bou_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na wahina wakwe wekubuwaho Kapelanaumu, wadoao kodi he Nyumba ya Muungu wakamwezea Petulo na kumuuza, “Wee, ivi mhinyi yenu khaiha kodi ya Nyumba ya Muungu?” ");
INSERT INTO bou_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo akatambaisa, “Eehe yee aiha.” Aho, Petulo ekwengiaho mda ndani ya nyumba hata khazati kutamwiiya mbui, Yesu akavoka kumuuza, “Simoni, wee waona viivihi? Maseuta wa inusi wadoa kodi kulawa kwa kinandai? Kulawa kwa wantu wa si yao hambu kwa wageni?” ");
INSERT INTO bou_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo akatambaisa, “Kulawa kwa wageni.” Yesu akamwamba, “Inga ni ivyo wenye si yao khawakundigwa kuiha kodi. ");
INSERT INTO bou_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iya khatikunda kuwasefua moyo, hita mwe tondoo da mazi ukatambike ndoano, samaki wa bosi endaeatozwe mgubue muomo wakwe wenda umbwiiye heya idoe ukaihe kodi yako na yangu.” ");
INSERT INTO bou_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kisingi kiya wahina wakamwezea Yesu, na kumuuza, “Nindai mkuu muno mwe useuta wa uwanga kwa Muungu?” ");
INSERT INTO bou_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu akamwetanga mwana mdodo na kumgoosa gatigati yao, ");
INSERT INTO bou_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aho akawagombeka, “Nawamba kwei, mkesekuhituka na kuwa inga wana khamnamwengiye katu mwe useuta wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kwaiyo mntu yoyose ajinyenyeekeshae inga mwana uyu, nee endae awe mkuu kusima wose mwe useuta wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yuda amhokeaye mwana kwaajii yangu, endaawe anihokea miye. ");
INSERT INTO bou_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Iya inga mntu yoyose mwendae amtende yumwe wa wadodo awa wanizumiiao agosoe mavigaviga, ni ebae mntu uyo azengetezwe iwe kuu da kubundugia mwe singo yakwe na kutambikwa mwe kina kilehacho cha mazimshindo. ");
INSERT INTO bou_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mmbwii yenu wantu wa Inusi inu kwaajii ya yada yaetayo wantu kugosoa mavigaviga! Mbui izo nlazima yawe aho, iya mmbwii yakwe mntu yuda ambae endaagosoe. ");
INSERT INTO bou_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Inga mkono hambu muundi wako ukakutenda kugosoa mavigaviga usenge na uwase hae. Ni ebae kwako kwengia mwe ugima kwesiho mkono hambu muundi, kusima kwasigwa mwe moto wesao kukomeka misi yose kwesiho kisiikizi ukawa na mikono miidi na miundi yako miidi. ");
INSERT INTO bou_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na ziso dako dikakutenda ugosoe mavigaviga, ding'oe na kudasa hae. Ni ebae kwako kwengia mwe ugima ukawa na ziso dimwe kusima kwengia mwe moto misi yose kwesaho kukomeka ukawa na meso yako yose maidi. ");
INSERT INTO bou_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ekauweni, msekumbea wamwe wa wadodo awa. Kwaviya nawamba, wandima wao wa uko uwanga kwa Muungu, misi yose wahamwe na Tate yangu uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwaviya Mwana wa Mntu keza kuohoa wada wakwagao. ");
INSERT INTO bou_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mwaona viivihi? Mntu akawa na ngoto makumi kumi, akaga yumwe endaatende viivihi? Ivi khana awabade wada makumi kenda na kenda kwe muima, na nakuita kumwondeza yuda yumwe mwekwaga? ");
INSERT INTO bou_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nawamba kwei endaho amuone, endaawe na nyemi nae uyo kusima wada makumi kenda na kenda ambao khawekwaga. ");
INSERT INTO bou_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ivyoivyo na Tate yangu wa uwanga kwa Muungu khakunda hata yumwe wa wadodo awa age. ");
INSERT INTO bou_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nduguyo mkese kwevana, umbase na umhaze mkawa nywie waidi du. Akakutegeeza wendauwe nduguyo kumpata. ");
INSERT INTO bou_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ikawa ata khekukutegeeza doa mtu yumwe hambu waidi, inga Maandiko yagombekavyo, ‘kia masa yendayaonoke kuwa ni kwei kwa uvuhuzi wa wantu waidi hambu watatu, masa yaamulwe.’ ");
INSERT INTO bou_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akese kuwategeeza awo wavuhuzi waidi hambu watatu, wagombeke zumwezumwe da wantu wekumzumiiyao Klistu. Na inga khanaaditegeeze zumwezumwe da wantu wamzumiiao Klistu na awe kwako inga wantu wesao kummanya Muungu hambu watozao ushuu. ");
INSERT INTO bou_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Kwei nawamba, mbui mwendazomzivugue mwe inusi zendazivugalwe na uko uwanga kwa Muungu, na mbui zendazomzivugae mwe inusi zendazivugulwe na uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nawagombekea vituhu waidi gatigati yenu wakevana hanu he inusi kuusu mbui yoyose waiyombezayo, Tate yangu wa uko uwanga endaagosoe mbui iyo. ");
INSERT INTO bou_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwaviya hohose hada wakintanaho waidi hambu watatu kwa zina dangu, miye ni ahoaho gatigati yao.” ");
INSERT INTO bou_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Naho Petulo akamwezea Yesu na kumuuza, “Zumbe, ndugu yangu akaendeea kunikosea maa nyingahi na miye nimfiiye mbazi? Hambu, ata maa mfungate?” ");
INSERT INTO bou_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akamtambaisa, “Khigombeka maa mfungate iya mfungate maa makumi mfungate.” ");
INSERT INTO bou_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwaivyo Useuta wa Muungu wadaha kuiganywa na seuta yumwe mwe kukunda kugosoa ntaazia ya hea na wandima wakwe. ");
INSERT INTO bou_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ekuvokaho kugosoa ntaazia zakwe mntu yumwe mwekuwa adaiwa vifuko magana kumi vya zahabu, akaetwa kwakwe. ");
INSERT INTO bou_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ekuvotwaho kuiha deni ido, ivyo seuta yake akakunda yee atagwe na mkaziwe atagwe hamwe na wanawe watagwe na vyose ekuwavyo navyo vitagwe ili dia deni diihwe. ");
INSERT INTO bou_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yuda mndima akakinta mavindi na kumhembeeza yuda seuta na kugombeka, “unizizimizie, nami nenda nikuihe deni dako dose.” ");
INSERT INTO bou_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yuda Mkuu wa uyo mndima akamfiiya mbazi na akamuekea deni dakwe dose akambada aite zakwe. ");
INSERT INTO bou_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Iya uyo mndima ekuwaho alawa chongoi, akakintana na mndima ekuwae amdai ntii makumi kumi ya madini yetangwayo feza. Akamfuntia na kumkeda kongomeo na kumwamba niihe kia nikudaiacho. ");
INSERT INTO bou_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yuda mndima mweziwe akakinta mavindi na kumhembeeza akagombeka, ‘Naombeza unizizimize, nami nendanikuihe deni dako dose.’ ");
INSERT INTO bou_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Akini akaemea na akamwegaa he kifungo hadi endahoaihe ido deni. ");
INSERT INTO bou_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wandima weziwe wekuonaho ayo yekuawiiayo wakakimwa muno, nao wakaita nakumgombeka seuta yao kiya kintu chekulawiiacho. ");
INSERT INTO bou_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aho yuda seuta akamwetanga yuda mndima, akamwamba, ‘wee ni mndima mfyaimi muno! Kuniombeza nikakufiiya mbazi na miye nikakufiiya mbazi deni dako dose.’ ");
INSERT INTO bou_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ivi weye, khwekukundigwa kumfiiya mbazi mndima mwezio inga nekukufiiavyo mbazi? ");
INSERT INTO bou_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aho, uyo seuta akakimwa muno akamwekhiiza kwa asikai mageeza wamsuumize adi endahoaihe deni dose.” ");
INSERT INTO bou_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Yesu akaedeea kugombeka, “Tate yangu wa uwanga kwa Muungu nee endavyoawagoswee ivyo inga kia yumwe yenu khana amfiiye mbazi nduguye kwa moyo wakwe wose.” ");
INSERT INTO bou_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu ekubindaho kutamwiiya mbui izo, akahauka Galilaya akaita Uyahudi, phande ya zigizigi da mazi da Yolodani. ");
INSERT INTO bou_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zumwezumwe da wantu dikamtongea, nae akawahonya uko. ");
INSERT INTO bou_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wakamwezea, wakamuuza kwa kumgeeza, “Vyafaa mgosi kumbada mkaziwe kwa masa yoyose?” ");
INSERT INTO bou_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akawatambaisa, “Khamwekusoma mwe Maandiko ya Muungu kuwa Muungu mwe kumuumba mntu, kuvokea aho bosi kagosoa mgosi na mvyee, ");
INSERT INTO bou_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na akagombeka, ‘Kwaajii uyo mgosi endaabadane na tati yakwe na mami yakwe, na endaaungane na mkaziwe, nao awa waidi wenda wawe mwii umwe.’ ");
INSERT INTO bou_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwaivyo, wowo khio waidi vituhu iya ni mwii umwe. Ivyo ekukintanisacho Muungu mntu asekukibahua.” ");
INSERT INTO bou_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Akini wowo wakamuuza, “Kwambwai Musa katiagiiya mvyee ekhigwe bauwa na kubadwa?” ");
INSERT INTO bou_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu akawatambaisa, Musa kawekha uhusa kuwabada wavyee wenu kwaajii mioyo yenu itoga. Iya khayokuwa ivyo kuvokea aho bosi. ");
INSERT INTO bou_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na isasa nawambeni, yoyose ambadae mkaziwe kwesiho mbui ya ukianga na akategua mvyee mtuhu agosoa kianga. ");
INSERT INTO bou_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wahina wakwe wakamwamba, “Ikawa mbui ya mgosi na mvyee niivyo, ni ebae mtu asekutegua.” ");
INSERT INTO bou_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu akawamba, “Khio wose wadahao kuhokea hinyizo idi, kwesiho kwa wada ambao Muungu kawaambiza kugosoa ivyo. ");
INSERT INTO bou_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwaviya wauko mabunyenge wekuvyaigwao na mami zao na wauko mabunyenge wekugosolwao na wantu na wauko mabunyenge wekwetendao kuwa mabunyenge kwaajii ya Useuta wa Muungu. Adahae kuhokea hinyizo ido na aihokee.” ");
INSERT INTO bou_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wamwe wa wantu wakamwetea wana wadodo awaikie mikono na kuwavika. Akini wahina wakawawakia. ");
INSERT INTO bou_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu akagombeka “Waekeni awo wana weze hangu, naho msekuwakindia, kwaviya Useuta wa uwanga kwa Muungu ni wa wantu wekuwao inga wana awa.” ");
INSERT INTO bou_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ekubindaho kuwaikia mikono nee ahauka hantu aho. ");
INSERT INTO bou_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mntu yumwe akamwezea Yesu akamwamba, “Mhinyi, nigosoe mbui yani yedi nekhigwe ugima wa misi yose kwesiho kisiikizi?” ");
INSERT INTO bou_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akamtambaisa, “Mbona waniuza kuusu mbui yedi? Kuna yumwedu ambae ni yedi. Ukakunda kwengia mwe ugima toza amli.” ");
INSERT INTO bou_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yuda mntu akamuuza, “Amli ni zihi?” Yesu akamwamba, “Usekukoma na usekugosoa kianga na usekubawa na wesekugombeka uhokho, ");
INSERT INTO bou_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","watunye tati yako na mami yako na mkunde mwezio inga wekundavyo mwenye.” ");
INSERT INTO bou_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Uyo mbwanga akamwamba, “Ayo yose khiyatozeeza. Ivi khihungukiwa na mbwai?” ");
INSERT INTO bou_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu akamwamba, “Inga ukakunda kuwa mwiganizi, hita ukatage vintu vyako vyose na izo hea ukawekhe wakiwa, nawe wendauwe na kiikizo uwanga kwa Muungu, ukabinda soo unitongee.” ");
INSERT INTO bou_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yuda mbwanga ekusikiaho ayo, akahauka kwa kuungumia kwaajii nekawa na vintu vingi. ");
INSERT INTO bou_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aho Yesu akawamba wahina wakwe, “Kwei nawamba indaiwe khavidahika muno kwa mwenye vintu vingi kwengia mwe Useuta wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Naho nawamba ni vihufu ngamia kwemboka mwe ntundu ya singano kusima mwenye vintu vingi kwengia mwe Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wada wahina wakwe wekusikiaho ivyo wakahondomaa muno wakauzana, “Nindai adahae kuoholwa?” ");
INSERT INTO bou_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akawakauwa, akagombeka, “Kwa mntu mbui inu khaidahika, iya kwa Muungu mbui zose zadahika.” ");
INSERT INTO bou_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aho Petulo akagombeka, “Na swiswi tibada vyose takutongea, tinda tipate mbwai?” ");
INSERT INTO bou_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akawamba, “Nawamba kwei, Mwana wa Mntu endahoekae mwe kigoda kikuu cha Useuta mwe inusi mphya, nywinywi mwekunitongeao mnda mwekae mwe vigoda kumi dimwe na mbii mkaamuiya mbai kumi dimwe na mbii ya Isilaeli. ");
INSERT INTO bou_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kiya mwekubada nyumba yakwe, hambu ndugu yakwe hambu umbu dakwe hambu tati yakwe hambu mmaa yakwe hambu wanawe hambu minda yakwe kwaajii yangu, endaahokee mamia na ngeeko, na kwekhigwa ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iya ambao ni wabosi wendawawe wa kisikiizi na ambao ni wa kisikiizi wendawawe wa bosi. ");
INSERT INTO bou_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Useuta wa uwanga kwa Muungu waigana na mntu mwenye mnda wa mizabibu, mwekulawa keokeo da mtungaihu kwaajii ya kuwekha waimi ndima mwe mnda wakwe. ");
INSERT INTO bou_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akevana nao kuwaiha sensi mwenga ya madini yetagwayo feza kwa msi umwe, nee awegaa mwe mnda wakwe wa mizabibu. ");
INSERT INTO bou_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akalawa mwe saa tantu da keo akawabwiiya wantu watuhu wagooka gwiiyo, khawana ndima, ");
INSERT INTO bou_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","akawagombeka, ‘Hitani na nywie mkagosoe ndima mwe mnda wangu wa mizabibu, na miye nenda niwekhe kiya kikundigwacho kuihwa.’ ");
INSERT INTO bou_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nawo wakaita. Uyo mwenye mnda akalawa vituhu mwe saa mtandatu na saa kenda, akatenda ivyo. ");
INSERT INTO bou_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ata zua dekuswaho akalawa vituhu akawabwiiya wantu watuhu wagooka hada gwiiyo. Aho akawauza, ‘Mbona mgooka hanu musi ngima kwesiho ndima?’ ");
INSERT INTO bou_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wakamtambaisa, ‘Kwaviya khahana mntu mwekutekha ndima.’ Nae akawamba, ‘Hitani na nywie mkagosoe ndima mwe mnda wangu wa mizabibu.’ ");
INSERT INTO bou_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Zua dekuswaho, uyo mwenye mnda akamwamba mgookezi wakwe, ‘Wetange wandima uwahihe maiho yao, uvoke na wada wekugosoao ndima mda wa kisikiizi na uwabindiizie wada wekuvokaho ndima.’ ");
INSERT INTO bou_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wada wandima wakeza wada wekugosoao ndima zua diswa kae wakahokea kia yumwe maiho ya sensi mwenga ya madini yetangwayo feza. ");
INSERT INTO bou_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wada wa bosi wekubuaho, wakamamakhanya wenda wekhigwe na ngeeko, akini hata wowo wakekhigwa sensi mwenga mwenga ya madini yetangwayo feza. ");
INSERT INTO bou_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wakahokea yada maiho na kuvoka kumng'ung'uzikia yuda mwenye mnda. ");
INSERT INTO bou_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wakamba, ‘Wantu awa weza guoni na wagosoa ndima kwa mda wa saa dimwe du, mbona kutiiha sawa nao, kisingi swie tizizimiza ndima ngumu na zua kai?’ ");
INSERT INTO bou_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naho yuda mwenye mnda akamtambaisa yumwe aho, ‘Mbuyangu nchekukukonya kintu! Ivi, tambe khatekwevana kuwaiha misi yose maiho ya sensi mwenga kwa msi umwe? ");
INSERT INTO bou_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Doa kiya wekukundigwacho kuihwa na uite. Nakunda kumwekha uyu wa kisikiizi inga nikukuihavyo wee. ");
INSERT INTO bou_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ivi khikundigwa kugosoa kiya nikundacho na ni vintu vyangu mwenye? Hambu waona kinyuu kwa viya khiwa yedi?’ ” ");
INSERT INTO bou_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu akabindiizia kwa kugombeka, “Ivyo, wakisikiizi wendawawe wa bosi na wabosi wendawawe wa kisikiizi.” ");
INSERT INTO bou_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ekuwaho akaita Yelusalemu hamwe na wahina wakwe wangi, na wekuwaho siai akawadoa wada wahina wakwe kumi dimwe na mbii kuwegaa khandani na kutamwiia nawo wowo ikedu, ");
INSERT INTO bou_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tegeezani! Taita Yelusalemu na uko Mwana wa Mntu endaekhiizwe kwa waviki wakuu na wahinyi wa miko, nao wendawamuamuiye akomwe. ");
INSERT INTO bou_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wenda wamwekhiize kwa wantu wesao kuwa Wayahudi, nawo wendawambee na endaatoigwe ngoda na kusuumizwa na kugong'ondewa he mhamba, iya bada ya misi mitatu endaayuyuswe.” ");
INSERT INTO bou_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aho mkaza Zebedayo hamwe na wanawe waidi ambao ni Yakobo na Yohana wakamwezea Yesu, wakakinta mavindi hemeso yakwe na kumwombeza kintu. ");
INSERT INTO bou_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu akamuuza, “Wakunda mbwai?” Uyo mmaa akamtambaisa, “Niikia kiaga wendaho wengie mwe Useuta wako, awa wanangu waidi nakunda wekae, yumwe phande yako ya kuume na mtuhu phande yako ya kumoso.” ");
INSERT INTO bou_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu akamtambaisa, “Khammanya mwaombeza mbwai. Ivi mwadaha kudomea kikombe iki cha usuumizi nendacho nidomee miye?” Wakatambaisa, “Tadaha.” ");
INSERT INTO bou_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu akawamba, “Kwei kikombe changu cha masuumizo mwenda mkidomee, iya kwekaa phande ya kuume hambu kumoso kwangu iyo khiyo ndima yangu kuwekha, mbui iyo wendawekhigwe wada wekuikiwao kae ni Tate yangu.” ");
INSERT INTO bou_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wada wahina watuhu kumi dimwe wekutegeezaho ayo, wakakimwa kwaajii ya awo ndugu waidi. ");
INSERT INTO bou_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ivyo Yesu akawetanga wose, na akawamba, “Mwamanya kuwa wagookezi wa si ntuhu uwagookea wantu wao kwa nguvu na wakuu wao wawatumikisha wekuwao asi yao. ");
INSERT INTO bou_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iya kwenu isekuwa ivyo, na mntu akundae kuwa mkuu gatigati yenu yakundigwa awe mndima wa wose, ");
INSERT INTO bou_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na akundae kuwa wa bosi gatigati yenu, akundigwa awe mndima yenu. ");
INSERT INTO bou_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Inga ivyoivyo, Mwana wa Mntu khekweza kugosoewa, iya kuwagosoea na kuulavya ugima wakwe na ili wantu wangi waoholwe.” ");
INSERT INTO bou_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kisingi Yesu na wahina wakwe wekuwaho wakahauka mwe mzi wa Yeliko, zumwezumwe kuu da wantu dikamtongea. ");
INSERT INTO bou_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Matuntu waidi wekuwao wekaa khandakhanda ya sia, wekusikiaho kuwa Yesu emboka aho, wakatoa mgutio, “Zumbe, Mwana Daudi utifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dia zumwezumwe da wantu dikawaegezea na kuwakunda wanyamae. Iya wowo wakatendesa kutoa mgutio, “Zumbe, Mwana wa Daudi utifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu akagooka, akawetanga na kuwauuza, “Mwaonda niwagoswee mbwai?” ");
INSERT INTO bou_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wakamtambaisa, “Zumbe, takunda meso yetu yagubuke.” ");
INSERT INTO bou_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu akawafiiya mbazi na kuyadonta meso yao, ahoaho meso yao yakadaha kuona, na wao wakamtongea. ");
INSERT INTO bou_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wahina wakwe wekubuaho hehi na Yelusalemu na kubua hantu hetangwaho Betifage mwe muima wa Mizaituni, akawaagiiya wahina wakwe waidi, ");
INSERT INTO bou_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akawamba, “Hitani adi mwe mzi weiho hemeso yenu na aho mwendamumbwiiye phunda kazengetezwa uzigi na mwanawe kazengetezwa uzigi khandai yakwe wavugueni mkawaete. ");
INSERT INTO bou_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Inga mntu akawauza kwambwai mwawadoa phunda, mmwambe, Zumbe awakunda, na mwenye phunda endaawekhe kinyio.” ");
INSERT INTO bou_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mbui inu igosoka ili yada yekugombekwayo na Muoni wa Muungu yaiganyie, ");
INSERT INTO bou_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Wagombekeni wantu wa mzi wa Sayuni, Kauwa, Seuta yako akwezea! Ni mhuhusi, nae eza akawa kekaa uwanga ya phunda, Mwana phunda.” ");
INSERT INTO bou_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ivyo wada wahina wakaita wakagosoa inga Yesu ekuwaagiiavyo. ");
INSERT INTO bou_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wakamweta yuda phunda na mwanawe, wakatandika nguo zao uwanga ya phunda na Yesu akekaa uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zumwezumwe kuu da wantu wakatandaza nguo zao mwe sia na wantu watuhu wakasenga matambi madodo dodo ya miti nayo wakayatandaza mwe sia. ");
INSERT INTO bou_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zumwezumwe da wantu wekuongoao na wada wamtongeao wakatoa mgutio, “Atogolwe Mwana wa Daudi! Ajaiwe uyo ezae kwa zina da Zumbe! Atogolwe Muungu uwanga!” ");
INSERT INTO bou_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ekwengiaho Yelusalemu mzi wose wakawa na matumatu. Wantu wakawa wauzana, “Uyu ni nindai?” ");
INSERT INTO bou_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wantu mwe dia zumwezumwe wakagombeka, “Uyu ni Yesu, yuda muoni kulawa Nazaleti mzi wa Galilaya.” ");
INSERT INTO bou_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aho, Yesu akengia he Nyumba ya Muungu, na kuwaguusa wose wekuwao wakagua na kutaga vintu he Nyumba ya Muungu. Akazihitua meza za wada wekuwao wahitua hea, na vigoda vya wada wekuwao wataga sua. ");
INSERT INTO bou_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akawamba, “Iyandikwa mwe Maandiko ya Muungu, ‘Nyumba yangu indaiwe nyumba ya kuvika.’ Iya nywie mwiitenda phanga da wabavi!” ");
INSERT INTO bou_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wantu wekuwao matuntu na wekuviao wakambasa uko kwe Nyumba ya Muungu, nae Yesu akawahonya. ");
INSERT INTO bou_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aho, waviki wakuu na wahinyi wa miko wakakimwa muno wekuonaho vihii ekugosoavyo Yesu hamwe na kuwategeeza wana wekuwavyo walavya mgutio kwe Nyumba ya Muungu wakamba, “Atogolwe Mwana Daudi.” ");
INSERT INTO bou_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ivyo wakamwamba, “Ivi, wategeeza wambavyo?” Yesu akawatambaisa, “Eehe, nategeeza!” Ivi khamzati kusoma Maandiko aya? “Kwa miomo ya wana wadodo na wateke, Muungu kawagosoa wamtogoe yee.” ");
INSERT INTO bou_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aho Yesu akawabada, akalawa chongoi ya mzi na kuita mwe phaamo ya Besania, na akagona uko. ");
INSERT INTO bou_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Keokeo da mtungaihu Yesu ekuwaho auya mwe mzi neekawa na saa. ");
INSERT INTO bou_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akoona mtini khandakhanda ya sia, akautimia hehi, akini khekuona tunda dodose iya manidu. Ahoaho akaugombeka uda mtini, “Wesekuvyaa vituhu matunda misi yose!” Aho uwo mtini ukanyaa. ");
INSERT INTO bou_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wahina wakwe wekuonaho mbui iyo wakahondomaa, wakamuuza, “Iwa viivihi mti unu wa mtini unyaa kinyio?” ");
INSERT INTO bou_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu akawatambaisa, “Nawamba kwei, inga mkazumiiya na mkesekuwa na matumatu, mwadaha khio du kugosoa ivyo kwa yada yekugosokanayo kwa unu mtini, iya ata mkawamba muima unu halawe uketambike mwe mazimshindo, inda igosoke ivyo. ");
INSERT INTO bou_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na mkazumiiya, dodose mwendado muombeze kwa kuvika, mwenda mwekhigwe.” ");
INSERT INTO bou_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ekwengiaho, he Nyumba ya Muungu wagookezi wa waviki na wadaa wa wantu wakamwezea ekuwaho akahinya na kugombeka, “Wagosoa mbui izi kwa udaho wani, nae ni ndai mwe kukwekha udaho unu?” ");
INSERT INTO bou_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akawatambaisa, “Na miye nendaniwauze mbui mwenga, mkanitambaisa, na miye nendaniwambe nagosoa mbui izi kwa udaho wani. ");
INSERT INTO bou_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubatiizo wa Yohana, ulawa kuhi? Ulawa kwa Muungu hambu ulawa kwa wantu?” Wakavoka kuuzana wowo kwa wowo, “Tikamba ulawa kwa Muungu, endaatiuze, mbona khamwekumzumiiya?” ");
INSERT INTO bou_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iya tikamba, “Ulawa kwa wantu, taogoha zumwezumwe da wantu kwaviya wose wammanya Yohana Mbatiiza kuwa ni muoni wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kwaiyo wakamtambaisa, “Swie khatimanya.” Nae Yesu akawamba, “Wala na miye khina niwambie ni kwa udaho wani natenda mbui izi.” ");
INSERT INTO bou_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nywie mwamamaakhanya viivihi? Mntu yumwe nee ana wana waidi wakigosi. Akamwamba yuda wa bosi, ‘Mwanangu, ivyeo hita kwe mnda wa mizabibu ukaime.’ ");
INSERT INTO bou_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yuda mwana akamtambaisa, ‘Miye khina niite,’ bada ya mda akamamakhanya na akaita. ");
INSERT INTO bou_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nee yuda tate akambasa mwanawe mtuhu akamwamba viyaviya. Yee akatambaisa, ‘Nenda niite Tate,’ iya khekuita. ");
INSERT INTO bou_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gatigati ya awo wana waidi ni yuhi mwe kugosoa kida ekukundacho Tati yao?” Wakamtambaisa, “Ni yuda wa bosi.” Yesu akawamba, “Watoza ushuu na wakiyanga wao wendawaongoe kwengia mwe Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwaviya Yohana Mbatiiza keza kwenu na kuwaonyesha sia yedi, iya khamwekumzumiiya, akini watoza ushuu na wakiyanga wamzumiia. Nywie hata mwe kuonaho ayo, khamwekuhituka na khamwekuzumiiya. ");
INSERT INTO bou_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu akamba, “Tegeezani msimo mtuhu. Nee kuwa na mntu yumwe mwenye mnda wa mizabibu. Akadizengea buha na akafuka tubwi mda ndani da kukamwiiya divai, na akazenga mnaa. Naho akawekha waimi uwo mnda, na akatamba na kuita si ya hae.” ");
INSERT INTO bou_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kisingi cha ubosi chekubuaho, akawaagiiya wandima wakwe kwa wada waimi wakadoe hantu ha ubosi wakwe. ");
INSERT INTO bou_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wada waimi wakawagwiiya awo wandima, yumwe wakamtoa na yumwe wakamkoma na mtuhu wakamtoa maiwe. ");
INSERT INTO bou_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Uyo mntu akawaagiiya wandima watuhu, wangi na wangi kusima wada wa ntambo ya bosi. Wada waimi wakawagosweeya ya viyaviya inga wezwao wa bosi. ");
INSERT INTO bou_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kisikiizi akamwagiiya mwanawe kwao, uku amamaakhanya, na kugombeka, “Wendawamtunye mwanangu.” ");
INSERT INTO bou_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iya wada waimi wekumwonaho ni mwanawe wakegombekea wowo kwa wowo, “Uyu nee mpazi na timkome na upazi wakwe tiudoe swie!” ");
INSERT INTO bou_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ahoaho wakamgwiiya na kumlavya chongoi ya uda mnda wa mizabibu na kumkoma. ");
INSERT INTO bou_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu akawauza, “Yuda mwenye mnda, endahoeze andaawatende mbwai wada waimi?” ");
INSERT INTO bou_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wowo wakamtambaisa, “Haika, endaawakome na uda mnda enda awekhe waimi watuhu, wendao wamwekhe hantu ha ubosi kwa kisingi chakwe.” ");
INSERT INTO bou_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu akawamba, “Khamzati kusoma mwe Maandiko yagombekavyo? ‘Iwe wekuemeado wazengi Isasa diwa iwe kuu da khandakhanda. Zumbe nee mwe kugosoa mbui inu, Nayo ni kiozo muno umu mwetu!’ ");
INSERT INTO bou_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nawagombeka,” “Useuta wa Muungu wendauusigwe aha henu na kwekhigwa wantu wa si ntuhu wada wagosoao yada yamtamizayo Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yesu akaendeea kugombeka, “Yee endaeagwe mwe iwe idi endaabondeke bondeke ntii, iya yuda dendaedimgwiiye endaahondeke muno.” ");
INSERT INTO bou_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wagookezi wa waviki wakuu na Mafalisayo wekutegeezaho misimo iyo wakamanya nee akawagombekea wowo. ");
INSERT INTO bou_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wakoondeza sia ya kumgwiiya, iya wakaogoha zumwezumwe da wantu kwaviya wantu nee wamkauwa Yesu kuwa ni muoni. ");
INSERT INTO bou_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu akagombeka nao vituhu wada wantu kwa misimo. ");
INSERT INTO bou_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Useuta wa uwanga kwa Muungu waigana na zumbe yumwe mwekumgosoeya mwanawe ntafuno ya ndoza. ");
INSERT INTO bou_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akawaagiiya wandima na kuwetanga wekugonekwao weze kwe ndoza, iya wekugonekwao khawakukunda kweza. ");
INSERT INTO bou_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naho akawaagiiya wandima vituhu wawambe wada wekugonekwao, ‘Isasa ntafuno iikwa kae khande. Na nyama za njeku na wesao kudahaa vitana kia kintu kiikwa kae!’ ");
INSERT INTO bou_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Iya wowo khawekupatiiza, wakahauka, yumwe kaita tanga kwakwe na mtuhu kwe biashaa zakwe, ");
INSERT INTO bou_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na watuhu wakawagwiiya wakawatoa na kuwakoma. ");
INSERT INTO bou_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yuda Seuta akakimwa, akawaagiiya maasikai wakwe wakawadagamize wada wakomaji na kuubananga mzi wao kwa moto. ");
INSERT INTO bou_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aho akawamba wandima wakwe, ‘Ntafuno ya ndoza itayali, iya wekugonekwao wakaemea kweza. ");
INSERT INTO bou_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hitani mwe baabaa na wowose wendao muwabwiiye wetangani weze kwe ndoza,’ ");
INSERT INTO bou_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","wada wandima wakalawa na kuita mwe baabaa, wakawaika hamwe wantu wose, wafyaimi na wedi. Nyumba ya ndoza ikamema wageni. ");
INSERT INTO bou_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Seuta ekwengiaho kuwakauwa wageni akamwona mntu yumwe ambae khekuvaa gwanda da ndoza. ");
INSERT INTO bou_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Seuta akamuuza, ‘Mmbuya, kwengia viivihi uku khuna gwanda da ndoza?’ Yuda mntu khekuwa na dakugombeka. ");
INSERT INTO bou_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ahoaho Seuta akawamba wandima, ‘Mzengetezeni sigi za mwe miundi na mwe mikono mkamwase chongoi kwe kiza, uko endaaiye na kuuma meno.’ ” ");
INSERT INTO bou_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu akabindiizia kwa kugombeka, “Wantu wekwetangwao ni wangi, iya wekusagulwao niwacheche.” ");
INSERT INTO bou_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nee Mafalisayo wakahauka na kuita sia ya kuteganya wendavyo wamgwiye Yesu kwa ntamwiizi zakwe. ");
INSERT INTO bou_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aho wakawaagiiya wahina wao hamwe na wahina wa kizumwezumwe cha Mahelode. Wakamuuza, “Mhinyi, tamanya wee ni mntu yedi na wahinya sia ya Muungu ya wantu kugosoa yekuwayo yedi, khumwogoha mntu yoyose kwamana ya ukuu wakwe na ukuu wakwe kwako khio kintu. ");
INSERT INTO bou_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haya tambie wee waona viivihi? Ni vyedi kumuiha ushuu kwa seuta mkuu wa Lumi hambu tisekumuiha?” ");
INSERT INTO bou_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu akamanya nteganyi zao za ufyaimi akawagombeka, “Nywie ni wahokho, kwambwai mwanigeeza kwa kunihega? ");
INSERT INTO bou_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nionyeshani iyo sensi iihayo ushuu.” Nawo wakamwekha sensi mwenga. ");
INSERT INTO bou_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ahoaho, Yesu akamuuza, “Cheni na magondo aya ni ya ndai?” ");
INSERT INTO bou_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wakatambaisa, “Ni seuta mkuu wa lumi.” Aho Yesu akawamba, “Ya seuta mkuu wa lumi mwekheni seuta mkuu wa lumi na ya Muungu mwekheni Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wekusikiavyo ivyo nee wahondomaa, wakambada wakaita. ");
INSERT INTO bou_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Msi uwouwo wamwe wa Masadukayo wagombekao wekufao khawayuyuka vituhu wakamtimia Yesu. ");
INSERT INTO bou_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Na kumwamba, “Mhinyi, Musa kagombeka mntu inga akategua na akauya na nyuma na khekubada mwana, yakundigwa nduguye amtegue uyo mvyee mwekufiiwa ni mgosi, ili ampatie wana. ");
INSERT INTO bou_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hanu hetu nee kuwa na wandugu mfungate. Wabosi kategua nee auya na nyuma na khekujaiwa mwana, akadoigwa ni nduguye uyo mvyee mwekufiiwa ni mgosi. ");
INSERT INTO bou_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Vikagosoka ivyoivyo kwa ndugu wakaidi na wantatu, adi wose mfungate. ");
INSERT INTO bou_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bada ya ndugu ao wose kuuya na nyuma na yuda mvyee nae akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wendaho ubue uwo msi wa uyuyuko wendaho wayuyuke mvyee uyo endaawe ni mkaza ndai wamwe wa wada wandugu mfungate? Kwaviya wose mfungate nee wamtegua.” ");
INSERT INTO bou_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu akawatambaisa, “Nywie mwaga kwaajii khammanya Maandiko ya Muungu wala udaho wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kisingi wantu wendaho wayuyuke khawana wategulwe wala kutegua, iya wendawawe inga wandima wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Iya kwa ida mbui ya wantu kuyuyuka tambe khamzati kusoma yada ekuwagombekayo Muungu? ");
INSERT INTO bou_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Miye ni Muungu wa Iblahimu na Muungu wa Isaka na Muungu wa Yakobo!’ Yee khie Muungu wa wekuuyao na nyuma, iya ni Muungu waugima.” ");
INSERT INTO bou_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yada mazumwezumwe ya wantu yekutegeezaho mahinyo yakwe wakahondomazwa muno. ");
INSERT INTO bou_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo wekusikiaho kuwa Yesu kawatwiiza Masadukayo, na wakakintana hamwe. ");
INSERT INTO bou_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumwe wa Mafalisayo ambae amanya miko, akamuuza Yesu kwa kumgeeza. ");
INSERT INTO bou_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mhinyi mwe miko ni amli ihi yekuwayo khuu?” ");
INSERT INTO bou_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akamtambaisa, “ ‘Mkundise Zumbe Muungu yako kwa moyo wako wose na muye wako wose na kwa akii zako zose.’ ");
INSERT INTO bou_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inu nee amli khuu na ya bosi. ");
INSERT INTO bou_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yakaidi yaigana na inu, ‘Mkundise mntu yoyose inga wekundisavyo wee mwenye.’ ");
INSERT INTO bou_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Miko yose ya Musa na mahinyizo ya Waoni zizengwa na amli izi mbii.” ");
INSERT INTO bou_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kisingi Mafalisayo wekukintanaho hamwe, Yesu akawauza. ");
INSERT INTO bou_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nywie mwaona viivihi kuusu klistu mwohozi? Yee ni mwana wa ndai?” Wakamtambaisa, “Yee ni mwana ya Daudi.” ");
INSERT INTO bou_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu akawauza, “Yadahika viivihi Daudi akaongweewa na Muye wa Muungu amwetange Klistu ni ‘Zumbe?’ Kwaviya kagombeka, ");
INSERT INTO bou_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Zumbe kamwamba Zumbe yangu, Ekaa he mkono wangu wa kuume Adi nendaho niwavote wamasa wako.’ ");
INSERT INTO bou_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Akawa Daudi amwetanga Klistu ‘Zumbe’, yadahika viivihi Daudi kuwa mwanawe?” ");
INSERT INTO bou_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Khahana mntu yoyose mwekudaha kumtambaisa Yesu mbui iyo, na kuvokea msi uwo khahana mwekudaha kugeeza kumuuza vituhu dodose. ");
INSERT INTO bou_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Naho Yesu akawamba wada wantu wangi na wangi wekuwao aho, hamwe na wahina, ");
INSERT INTO bou_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wahinyi wa Miko na Mafalisayo nee wekwekhigwao udaho wakusosoa miko ya Musa. ");
INSERT INTO bou_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ivyo tozani na mtongee dodose wendado wawagombekee. Iya mwesekutongea yada wayagosoayo, kwaviya wowo khawayatongea yada wayahinyayo. ");
INSERT INTO bou_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wadoa maafuushi yazamayo na kuwabadika wantu mwe mawega, akini wowo wenye khawakunda kuidon'ta hata kwa chaa wadahe kuyenua. ");
INSERT INTO bou_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wao wagosoacho mbui zao zose ili kwakweonyesha he meso ya wantu. Kwaviya wavaa kwenye vyeni vyao na mwe mikono yao ntii khuu za babu ambavyo viandikwa miko ya Musa, na kuomeea mafundo mwe magwanda yao. ");
INSERT INTO bou_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wakunda kwekaa phasi za kutunywa mwe ntafuno na vigoda vya kutunywa mwe Nyumba za kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wakunda kuuguswa kwa kutunywa gwiiyo na nakwetangwa na wantu. ‘Mhinyi.’ ");
INSERT INTO bou_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Iya nywie wantu wasekuwetanga ‘Mhinyi.’ Kwaviya mhinyi yenu ni yumwedu, na nywie wose ni ndugu. ");
INSERT INTO bou_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nahodu mwesekumwetanga mntu yoyose ‘Tate’ hanu mwe inusi kwaviya Tate yenu ni yumwedu, mweuko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naho mwesekwetangwa ‘Wagookezi,’ Kwaviya mgookezi yenu ni yumwedu nee Klistu. ");
INSERT INTO bou_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na mntu yoyose ambae akunda kuwa mgookezi, akundigwa awe awagosoeya ndima wenziwe. ");
INSERT INTO bou_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na mntu yoyose egosoaye kuwa mkuu Muungu enda amtende mdodo na yoyose etendae mdodo Muungu enda amtende mkuu. ");
INSERT INTO bou_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mmbwii yenu, wahinyi wa miko na Mafalisayo mwekuwao wahokho! Uvi muuvugaa wa Useuta wa Muungu hemeso ya wantu. Nywie wenye khamwengia umo, naho khamuwabada watuhu wakundao kwengia wengie. ");
INSERT INTO bou_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mmbwii yenu wahinyi wa miko na Mafalisayo nywie wahokho! Mwada khande mwe nyumba za wavyee wekufiwao ni wagosi, nywie mwetenda kuwa ni wedi mwavika kisingi kileacho. Kwaajii iyo mwenda mwekhigwe sugusa khai. ");
INSERT INTO bou_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mmbwii yenu, wahinyi wa miko na Mafalisayo, wahokho! Mwatamba mwe mazimshindo na mwesanga khavu ili mmuohoe mntu esae kuwa Myahudi awe Myahudi mkabinda awatongea nywie, iya mkabinda kumpata mwamgosoa awe mntu akundigwae kuita mwe si ya moto wesao kukomeka inga nywie wenye. ");
INSERT INTO bou_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mmbwii yenu, wagookezi matuntu! Nywie mwahinya, ‘mntu akaaha kwa Nyumba ya Muungu khio kintu, iya akaaha kwa zahabu yekuwayo mwe Nyumba ya Muungu kuaha kwakwe kwenda kumtoze.’ ");
INSERT INTO bou_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nywie matuntu wahezi! Kihi ambacho ni cha mana muno, ni zahabu hambu Nyumba ya Muungu yekugosoayo iyo zahabu iwe ya Muungu! ");
INSERT INTO bou_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naho mwahinya mntu akaaha kwa ingo da kulaviya malavyo khio kintu, iya akaaha kwa funge ikuikwayo uwanga ya ingo, kuaha kwakwe uko kwamtoza. ");
INSERT INTO bou_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nywie matuntu kweikwei! Ni kihi chekuwacho kikuu muno. Ni funge hambu ingo ambado dagosoa iyo funge iwe ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwaiyo mntu aahae kwa ingo da kulaviya malavyo, kuaha kwa ido ingo na vintu vyose vyekuwavyo uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na aahae kwa Nyumba ya Muungu, kaaha kwa iyo Nyumba ya Muungu na yuda ekaae ndani yakwe. ");
INSERT INTO bou_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na aahae kwa uwanga kwa uwanga kwa Muungu, aaha kwa kigoda cha kiseuta cha Muungu na kwa uyo ekaae uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mmbwii yao, wahinyi wa miko na Mafalisayo, wahokho! Mwawatoza wantu zaka ya mani ya halufu ntana, na binzali, na bwache, na uku mwabada mbui za miagiiyo inga viya haki na mbazi na uzumizi. Aya nee asa mkundigwayo kuyagosoa na mwesekujaa yada matuhu. ");
INSERT INTO bou_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wagookezi matuntu! Mwalavya nisi mwe vyakudomeea, akini mwakhia ngamia! ");
INSERT INTO bou_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mmbwii yenu Wahinyi wa Miko na Mafalisayo wahokho! Mwasunta kikombe na kalai kwa chongoi, iya ndani mwabada kumema vintu mwe kupatavyo kwa kuwahoka wantu na uchoyo. ");
INSERT INTO bou_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nywie Mafalisayo matuntu! Vokani kusunta kikombe ndani, na chongoi chendakiwe kisuntika. ");
INSERT INTO bou_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mmbwii yao wahinyi wa miko na Mafalisayo nyie wahokho! Mwaigana na mambia yekusiswayo nchokaa ambayo kwa chongoi yakaulwa kuwa ni matana, akini umo ndani yamema mavuha ya vimba na kia namna ya usama. ");
INSERT INTO bou_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Viyaviya kwa chongoi nywie mwaonekana kuwa ni wantu wedi, akini kwa ndani mmema uhokho na kia namna ya ufyaimi. ");
INSERT INTO bou_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mmbwii yenu wahinyi wa miko na Mafalisayo, wahokho. Mwayazengea mambia ya waoni na mwayazengea na kuhamba mbia za wantu wedi, ");
INSERT INTO bou_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nywie mwagombeka, inga nee tiwaaho kisingi cha wadaa wetu nee khatokutongeana nao mwe ukomaji wa waoni!” ");
INSERT INTO bou_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ivyo mwesemea wenye kuwa nywie ni uvyaigwa wa wantu wekukomao waoni ");
INSERT INTO bou_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aya iiganizeni ndima ida wadaa wenu wekuivokayo. ");
INSERT INTO bou_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Enywi uvyazi wa mdudu mwenye sumu! Mwendamdahe viivihi kuhepa sugusa ya si ya moto wesao kukomeka misi yose kwesiho kiisikizi? ");
INSERT INTO bou_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nee mana miye nawegaiiya nyie waoni, wantu wenye akii na wahinyi, mwenda muwakome na kuwagong'ondea he mhamba na wamwe wao, na watuhu mwendamuwatoe ngoda mwe nyumba za kukintania Wayahudi na kuwaguusa kwa kia mzi. ");
INSERT INTO bou_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ivyo lawama yose inda iwapate kwaajii ya phome yose ya wantu wedi wa Muungu yekwetiwayo uwanga ya inusi, kuvokea phome ya Abeli ambae khekuwa na hatia hadi ida ya Zakalia, mwana wa Balakia ambae mumkoma he Nyumba ya Muungu gatigati ya hantu hang'azi ha ingo. ");
INSERT INTO bou_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nawamba kwei, wantu wa kivyazi iki chendachekhigwe sugusa kwaajii ya mbui izi. ");
INSERT INTO bou_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Nywie wantu wa Yelusalemu! Nywie wantu wa Yelusalemu! Uwakomae waoni wa Muungu na kuwatambikia maiwe wada wose wekuagiiwao aha hako. Maa nyingahi khigeeza kuwaika hamwe wana wako kwangu, inga via nguku awatamiiavyo wanawe asi ya mawawa yakwe, akini khamwekukunda. ");
INSERT INTO bou_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kauwa Muungu endaaibade Nyumba yenu yenda ibomolwe na kubadwa ukiwa. ");
INSERT INTO bou_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nakwamba, khuna unikauwe vituhu hadi kisingi wendaho ugombeke, ‘Ajaiwe uyo ezae kwa zina da Zumbe.’ ” ");
INSERT INTO bou_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu akalawa he Nyumba ya Muungu, wahina wakwe wakamtimia na kumwonyesha mazengo ya Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu akawamba, “Ni sawa, mwadaha kuyakauwa aya yose! Kwei nawamba, khahana hata iwe dimwe dendado disigae uwanga ya iwe tuhu, kia iwe dendadibomolwe.” ");
INSERT INTO bou_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ekuwaho kekaa he muima wa Mizaituni, wahina wakwe wakamtimia Yesu ili wawe ikedu, wakamuuza, “Tambie, mbui izi zendazilawiiye ini, na ni ntangio ihi ya kweza kwako na ntangio ya kisikiizi cha inusi ni mbwai.” ");
INSERT INTO bou_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu akawatambaisa, “Kuwani meso mntu asekuwatiiya. ");
INSERT INTO bou_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwaviya wangi wendaweze na wendawatumiye zina dangu na kugombeka, ‘Miye nee Klistu, nao wenda wawatiiye wangi.’ ” ");
INSERT INTO bou_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mwenda mtegeeze mbui za khondo na ufukufuku wa khondo kauweni mwesekuogoha, kwaviya aya yakundigwa yalawiiye, iya kia kisikiizi chenye khakizati. ");
INSERT INTO bou_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Wantu wa si mwenga wenda watoane khondo na wantu wa si ntuhu, wantu wa useuta umwe wenda watoane khondo na wantu wa useuta mtuhu. Kwendakuwe na saa na mizingizo mwe hantu mbaimbai mwe inusi. ");
INSERT INTO bou_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yose ayo ni inga usungu wa bosi wa kwefungua mwana. ");
INSERT INTO bou_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Naho mwenda muemewe na wantu na kuwasuumiza na kukomwa. Wantu wa Si zose wenda wawakime kwaajii kunizumiia miye. ");
INSERT INTO bou_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naho wangi wenda wabade kuzumiia kwao na wendawahitukane na khawana wakundisane katu. ");
INSERT INTO bou_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wendawalawiiye waoni wangi wa uhokho, nao wenda wawatiiye wantu wangi. ");
INSERT INTO bou_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Naho ukundiso wa wantu wangi wenda uhungue, kwaajii mavigaviga yenda yawe yamema. ");
INSERT INTO bou_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na yoyose endaeagooke mwe untintimavu adi kisikiizi, uyo nee endaeaoholwe. ");
INSERT INTO bou_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mbui Yedi ya useuta wa Muungu inda ibiikiwe mwe inusi yose, ili wantu wose waimanye nee kisikiizi chendahocheze. ");
INSERT INTO bou_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ivyo mwendaho muone mbui ya kutisa na dietado ubanasi, digooka he Nyumba ya Muungu inga ekugombekavyo muoni Danieli, ivyo kia asomaye na amanye mbui iyo.” ");
INSERT INTO bou_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aho, wada wekaao Uyahudi waguukie he miima. ");
INSERT INTO bou_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yoyose mwe uwanga ya taa da nyumba yakwe asekuseeya kudoa chochose kulawa mwe nyumba yakwe. ");
INSERT INTO bou_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ekuwae tanga asekuuya kaya kudoa gwanda dakwe. ");
INSERT INTO bou_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mmbwii yao wakina mmaa wekwenuao maifu na waokhesao misi iyo! ");
INSERT INTO bou_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ombezani Muungu kuguuka kwenu kusekuwa kisingi cha khusi hambu Msi wa Kuhumuiza. ");
INSERT INTO bou_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwaviya kisingi icho chendakiwe na suuba khuu ambayo khaizati kulawiia kuvokea aho bosi wa inusi adi ivyeo, wala khakina kilawiiye vituhu. ");
INSERT INTO bou_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iya Muungu kahunguza misi izo, inga khekugosoa ivyo khahana mntu ambae nee kaoholwa, na Muungu kazihunguza kwaajii ya wantu wakwe ekuwasaguwao. ");
INSERT INTO bou_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kisingi icho mntu yoyose akawamba, ‘Klistu, yuhanu!’ Hambu ‘Yuhada,’ msekuzumiiya.” ");
INSERT INTO bou_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwaviya wendawalawiiye wantu wetangao Klistu akini khio, naho wendawalawiiye waoni wa uhokho. Wendawagosoe ntangio na vihii vikuu vya kudaha kuwaza, vikadahika hata wekusagulwao ni Muungu. ");
INSERT INTO bou_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kauwani! Khibindiiza kuwahaza kae kabla mbui izo khazizati kulawiia. ");
INSERT INTO bou_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kwaiyo, mntu yoyose akawamba, ‘Klistu yuuko he nyika, msekuita.’ Hambu wakagombeka, ‘Klistu yuuko gati, msekuzumiiya.’ ");
INSERT INTO bou_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwaviya inga umbauwa umuikavyo kulawa awiyo da zua adi engiiyo da zua, nee ivyo vyendavyoviwe kweza kwakwe Mwana wa Mntu. ");
INSERT INTO bou_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Hada weiho mzoga, neaho wakintanaho tai. ");
INSERT INTO bou_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Maa misi iyo za suuba zendaho zemboke, Muungu endaadihitue zuwa kuwa kiza na mweenge nayo khaina ilavye mng'ao na ntoondo zendazigwe kulawa uwanga, viyaviya endaazisingise nguvu za uwanga. ");
INSERT INTO bou_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aho wenda uoneke ntangio ya Mwana wa Mntu uwanga kwa Muungu na wantu wose mwe inusi wenda watoe bwaimbo, wenda wamwone Mwana wa Mntu akeza uwanga ya maangwi ya uwanga kwa Muungu kwa udaho na ukuu mwingi. ");
INSERT INTO bou_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nae endaawaagiiye wandima wa uwanga kwa Muungu uku watoa gunda divumado muno, nao wendawawaike hamwe wekusagulwao ni Muungu kulawa phande zose nne za inusi, kulawa kisikizi iki cha inusi adi kisikizi kituhu cha inusu. ");
INSERT INTO bou_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mwehinye kulawa kwa mti wa mkuyu, muonaho matambi yakwe yamema mani, mwamanya kisingi cha fua kibua. ");
INSERT INTO bou_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ivyoivyo, mwonaho mbui izo zikagosoka mmanye kuwa Seuta yuhehi muno. ");
INSERT INTO bou_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nawamba kwei, wantu wa kivyazi iki khauna wemboke kabla ya mbui izo khazizati kulawiiya. ");
INSERT INTO bou_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Uwanga kwa Muungu na inusi zendazemboke, iya mbui zangu khazina zemboke katu. ");
INSERT INTO bou_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kwa mbui ya msi uda na saa ida khahana amanyae, ata wandima wa uwanga kwa Muungu wala Mwana, iya Tate ikedu nee amanyae msi uwo. ");
INSERT INTO bou_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Inga yekuwavyo kisingi cha Nuhu, nee vyendavyoviwe kweza kwakwe Mwana wa Mntu. ");
INSERT INTO bou_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwaviya kisingi icho, kabla ya mazi mangi kuigubika inusi, wantu neewawa wakada na kudomea, wakategua na kutegulwa, hadi Nuhu ekwengiaho mwe ida Safina. ");
INSERT INTO bou_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Khawokumanya kuna mbwai hadi yada mazi mangi yekulawiiyaho, kuwakumba wose. Nee vendavyoviwe kisingi Mwana wa Mntu endahoeze. ");
INSERT INTO bou_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kisingi icho wantu waidi wendawawe tanga yumwe endaadoigwe na mtuhu endaabadwe. ");
INSERT INTO bou_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wavyee waidi wendawawe wakabunduga khande, yumwe endaadoigwe na mtuhu endaabadwe. ");
INSERT INTO bou_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ekauweni, kwaviya khammanya msi endahoeze Zumbe yenu. ");
INSERT INTO bou_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iya mmanye mbui inu, inga mwenye nyumba ati nee kamanya msi mbavi endahoabue, nee akacheeza, wala khekuwa aibadie nyumba yakwe itulwe. ");
INSERT INTO bou_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Viyaviya nanywi mwekae meso, kwaviya Mwana wa Mntu endaeze saa mwesayokuikauwiya. ");
INSERT INTO bou_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nindai mndima mkwei na mwenye akii, ambae zumbe yakwe endaamwiike agookee weziwe na awekhe khande kwa kisingi chakwe? ");
INSERT INTO bou_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yendaiwe vyedi mndima uyo ambae zumbe yakwe endahoeze endaambwiiye agosoa ivyo. ");
INSERT INTO bou_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nawamba kwei, endaamwiike mndima uyo agookee vintu vyakwe vyose. ");
INSERT INTO bou_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Inga mndima ni mfyaimi akegombekea mwe moyo, ‘Zumbe yangu endaacheewe kuuya,’ ");
INSERT INTO bou_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nae akavoka kuwatoa wandima weziwe, na kuvoka kuda na kudomea hamwe na wakozi, ");
INSERT INTO bou_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","zumbe yakwe mndima uyo endaeze msi ambao mndima khamkauwiiya na saa ida ambayo khaimanya. ");
INSERT INTO bou_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Endaamsuumize vifyaimi na kumwiika hamwe na wahokho. Uko kwendakuwe na ndio na kuuma meno kwa usungu. ");
INSERT INTO bou_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Useuta wa Muungu wendauigane na wandee kumi dimwe wekudoao taa zao, na wakaita kumhokea zumbe wa ndoza.” ");
INSERT INTO bou_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Washano nee niwahezi na washano wawa wenye akii. ");
INSERT INTO bou_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wada wahezi wadoa taa zao, iya khawekudoa mavuta ya kuomeea, ");
INSERT INTO bou_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Iya wada wenye akii wadoa taa zao na mavuta ya kuomeea mwe nchupa zao. ");
INSERT INTO bou_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwaviya mteguzi kacheewa kweza, wada wandee wose wakasikha na wakagona. ");
INSERT INTO bou_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kio kikuu kukawa na vuzo, ‘Homgwiiyo, homgwiiyo! Mteguzi eza, hitani mkamhokee.’ ");
INSERT INTO bou_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aho wada wandee wose wakenuka wakaziika vitana taa zao. ");
INSERT INTO bou_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wada wahezi wakawamba wada wenye akii, ‘Tipangieni mavuta kwaviya taa zetu zafa.’ ");
INSERT INTO bou_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Akini wada wenye akii wakawamba, ‘Khayanayatitoshe nywie na swiswi! Ni ebae mwiite kwa watagao mavuta mkague wenye!’ ");
INSERT INTO bou_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aho wada wandee wahezi, wakaita kugua mavuta. Uku nyuma mteguzi akabua, na wada wekuwao watayali wakengia hamwe nae mwe nyumba ya wiya, na uvi ukavugalwa. ");
INSERT INTO bou_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Yekwembokaho ayo wada wandee watuhu wakeza, na kwetanga. ‘Zumbe, Zumbe, tivuguiye uvi!’ ");
INSERT INTO bou_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Akini yee akawatambaisa, ‘Nawamba kwei,’ khiwamanya nywie.” ");
INSERT INTO bou_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ahoaho Yesu akawamba, “Ekauweni, kwaviya khammanya msi wala saa. ");
INSERT INTO bou_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Naho Useuta wa Muungu inga mntu yumwe mwe kukunda kutamba, akawetanga wandima wakwe, akawekha vintu vyakwe. ");
INSERT INTO bou_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akamwekha kadii ya udaho wa kia yumwe, yumwe vifuko vya hea vishano na mtuhu vifuko vya hea viidi na mtuhu kifuko cha hea kimwe, na ahoaho akatamba. ");
INSERT INTO bou_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yuda mwe kwekhigwa vifuko vya hea vishano akazigosoeya biashaa zikavyaa vifuko vya hea vishano ntuhu. ");
INSERT INTO bou_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Viavia yuda mwe kwekhigwa vifuko vya hea viidi nazo zikavyaa vifuko vya hea vituhu. ");
INSERT INTO bou_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iya yuda mwe kwekhigwa kifuko cha hea kimwe, yee akaita akafuka tubwi na kuifukia kia kifuko cha hea ya zumbe yakwe. ");
INSERT INTO bou_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yekwembokaho kisingi kilehacho, yuda zumbe wa wada wandima akauya, na kugosoa ntaazia nao. ");
INSERT INTO bou_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yuda mndima mwe kwekhigwa vifuko vishano vya hea akeza uku kaeta vifuko vishano vya hea zekuongezekazo. Akagombeka. ‘Zumbe kunekha vifuko vishano vya hea, kauwa kiongeza mituhu mishano.’ ");
INSERT INTO bou_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Zumbe wakwe akamwamba, ‘Vyedi mndima yedi, nee kuwa yedi kwa vintu vicheche, ninda nikuike uwe mgookezi kwa vintu vingi. Soo ushiiki nyemi ya zumbe yako!’ ");
INSERT INTO bou_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yuda mwekwekhigwa vifuko viidi vya hea mbii nae akeza. Akagombeka, ‘Zumbe kunekha vifuko viidi vya heya mbii. Kauwa kieta vifuko vituhu viidi.’ ");
INSERT INTO bou_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Zumbe yakwe akamtambaisa, ‘Kutenda vyedi muno mndima yedi na kuwa mzumiiwa mwe mbui ndodo, nendanikuike kuwa yedi kwa vintu vingi. Soo ushiiki mwe nyemi ya zumbe yako!’ ");
INSERT INTO bou_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Naho yuda mndima mwekwekhigwa kifuko kimwe cha heya akeza na kugombeka, ‘Zumbe, namanya kuwa wee ni mntu utogae, wabonda kwesiho kuhanda na kukisanya kwesiho kwetiya mbeyu. ");
INSERT INTO bou_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Khikuogoha kwaza kifiko chako cha hea, na khiifisa kifuko kimwe cha heya yako mwe sanga. Doa kifuko kimwe cha heya yako.’ ");
INSERT INTO bou_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Zumbe yakwe akamwamba, ‘Wee ni mndima mfyaimi na mbwa! Kumanya kuwa, miye nabonda hantu ambaho nchekuhanda, nadoa hantu ambaho nchekwetiya mbeyu. ");
INSERT INTO bou_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kukundingwa kuika kifuko cha hea kwa walavyao nyongeza, na miye mwe kifuko changu nee khipata nyongeza. ");
INSERT INTO bou_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haya mhokeni icho kifuko cha hea mkamwekhe yuda mwenye vifuko kumi. ");
INSERT INTO bou_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwaviya mwena endaekhigwe na ngeeko. Na yuda mwesena hata kia enacho endaahokwe. ");
INSERT INTO bou_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mtambikeni uyu mndima mfyaimi chongoi mwe kiza! Uko kundakuwe na ndio na kuuma meno kwa usungu.’ ");
INSERT INTO bou_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana wa Mntu endahoeze na ukuu wakwe na wandima wa Muungu wakawa hamwe nae, aho endaekae mwe kigoda chakwe cha Useuta na ukuu. ");
INSERT INTO bou_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wantu wa si zose wendawakintane hemeso yakwe, nae enda awaike wantu inga via mwiisi awaikavyo ngoto hantu hakwe na mbuzi hantu hakwe. ");
INSERT INTO bou_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aho endaawaiike ngoto phande ya kuume na mbuzi phande ya kumoso. ");
INSERT INTO bou_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naho Seuta endaawambe wada wa phande ya kuume, ‘Sooni nywie mwekujaiwao na Tate yangu, hokeani Useuta mwekuikiwao kae kuvokea kugosolwa kwa inusi. ");
INSERT INTO bou_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwaviya nekhiwa na saa, mkanekha khande, na nekhiwa na khiu mkanidomeza na nekhiwa mgeni mkanihokea, ");
INSERT INTO bou_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nekhiwa mwazi mkanivika magwanda na nekhiwa mtamu mkeza kunikauwa na nekhiwa mwe kifungoni mkeza kunivuiiya.’ ");
INSERT INTO bou_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aho awo wantu wedi wenda wamtambaise na kumwamba, ‘Zumbe ni ini, tekukuonaho una saa tikakwekha khande hambu ukawa na khiu tikakudomeza mazi? ");
INSERT INTO bou_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni ini tekukuonaho umgeni na swie tikakuhokea na tekukuonaho umwazi tikakuvika magwanda? ");
INSERT INTO bou_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ni ini tikuona ukawa mtamu tikeza kukukauwa hambu wekuwaho mwe kifungo tikeza kukuvuiiya.’ ");
INSERT INTO bou_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nae Seuta endaawatambaise, ‘Kwei nawamba, chochose mwekuwagosweado wamwe wa awa wandugu zangu mnigosweeya miye!’ ");
INSERT INTO bou_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ahoaho endaawambe wada wekuwao phande yakwe ya kumoso, haukeni aha hangu, nywie mwe kubadiwao lazi, hitani mwe moto wa misi zose kwesaho kukomeka na wekuikwao kae kwaajii ya ibiisi na wandima wakwe! ");
INSERT INTO bou_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwaviya nekhiwa na saa khamwekunekha khande na nekhiwa na khiu khamwekunidomeza mazi; ");
INSERT INTO bou_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nekhiwa mgeni nywie khamwekunihokea, na nekhiwa mwazi khamwekunivika magwanda na nekhiwa mtamu khamwekweza kunikauwa, na nekhiwa mwe khiwa mwe kifungo khamwekweza kunivuiiya.” ");
INSERT INTO bou_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wowo wenda wamtambaise, “Zumbe, ni ini, tekukuonaho una saa na khiu, hambu ukawa mgeni na umwazi, na ukawa mtamu, na ukawa mwe kifungo, khatikweza kukuambiza?” ");
INSERT INTO bou_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nae endaawatambaise, “Nawamba kwei kiya mwekuemeavyo kumwambiiza yumwe wa wadodo awa mwemea kuniambiiza miye.” ");
INSERT INTO bou_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Awa wendawaite kwe usuumizi wa misi zose zesazo kuwa na kisiikizi, na wada wantu wedi wenda waite kwe ugima wa misi zose zesazo kuwa na kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu ekubindaho kuwahinya ayo yose, akawamba wahina wakwe, ");
INSERT INTO bou_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mwamanya kuwa bada ya misi miidi indaiwe ni sikukhuu ya Pasaka, na Mwana wa Mntu endaalavigwe ili agong'ondewe mwe mhamba.” ");
INSERT INTO bou_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naho wagookezi wa waviki wakakintana hamwe kwe ukumbi wa Mviki Mkuu zina dake Kayafa. ");
INSERT INTO bou_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wakagosoa nteganyi wendavyo wamgwiiye kwa sii kwa unyanyi na kumkoma. ");
INSERT INTO bou_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iya wakamba, “Isekuwa kisingi cha sikukhuu ama khivyo kunda kulawiiye khumbizi kwa wantu.” ");
INSERT INTO bou_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ekuwaho Besania kaya kwa Simoni, mwekuwa na utamu wa nyoka. ");
INSERT INTO bou_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mvyee yumwe mwekuwa na nchupa ya iwe yetangwayo alibasta yenye mavuta yanukhiayo vitana ya yombe khuu, akamtimia hada Yesu ekwekaaho ada khande, na akamwetiiya ayo mavuta mwe mtwi. ");
INSERT INTO bou_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wahina wakwe wekuonaho ayo wakakimwa na kugombeka, “Kwambwai taza hea ivi! ");
INSERT INTO bou_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mavuta aya nee yatagwa kwa yombe khuu, na hea izo wekhigwe wakiwa.” ");
INSERT INTO bou_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu akamanya mamakhanyi zao, akawamba, “Kwambwai mwampisha uyu mvyee? Yee kanigosoeya mbui yedi. ");
INSERT INTO bou_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wakiwa mnao misi yose, iya miye khamna muwe nami misi yose. ");
INSERT INTO bou_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mvyee uyu kanitiiya mavuta ili niwe tayali kwa maziko yangu. ");
INSERT INTO bou_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nawambeni kwei, hohose mweinusi ambaho Mbui Yedi yendaibiikiwe, kintu iki ekugosoacho mvyee uyu chendakitamwiiwe kwa khumbuso yakwe.” ");
INSERT INTO bou_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naho Yuda Isikaliote, yumwe wa wada wahina kumi dimwe na waidi, akaita kwa wagookezi wa waviki, ");
INSERT INTO bou_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akawamba, “Mwendamnekhe mbwahi nendahonimhituke Yesu kwenu?” Wakamtaazia ntii makumi matatu ya madini ya feza. ");
INSERT INTO bou_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuvokea kisingi icho Yuda Isikaliote akaondeza phasi ya kumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Msi wa bosi ya sikukhuu ya mabumunda yesayo kugewa hamila, wahina wakaita kwa Yesu na kumuuza, “Wakunda tikuikie kuhi khande ya Pasaka?” ");
INSERT INTO bou_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yee akawatambaisa, “Hitani mwe mzi kwa mntu yumwe, na mmwambe, ‘Mhinyi amba kisingi changu kibua, mwe nyumba yako nakunda niide khande ya Pasaka hamwe na wahina wangu.’ ” ");
INSERT INTO bou_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wahina wakatenda inga Yesu ekuwaagiiavyo, wakaandaa khande ya Pasaka. ");
INSERT INTO bou_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yekubuaho guoni, akekaa asi hamwe na wahina wakwe kumi dimwe na waidi. ");
INSERT INTO bou_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wekuwaho wakada, Yesu akawamba, “Nawambeni kwei, yumwe yenu endaanihituke.” ");
INSERT INTO bou_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wahina wakaungumia muno, wakavoka kuuza yumweyumwe, “Ni miye Zumbe?” ");
INSERT INTO bou_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu akawatambaisa, “Agintae bumunda hamwe na miye mwe wiga nee endae anihituke. ");
INSERT INTO bou_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Mntu aita zakwe inga Maandiko yagombekavyo, iya mmbwii yakwe mntu yuda amhitukae Mwana wa Mntu! Neeiwa ebae kwa mntu uyo inga khekuvyaigwa.” ");
INSERT INTO bou_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda Isikaliote ambae nee mwe kumhituka akamuuza, “Mhinyi! Ivi ni miye?” Yesu akamtambaisa, “Eehe weye mwenye kugombeka”. ");
INSERT INTO bou_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wekuwaho wakada, Yesu akadoa bumunda akamtogoa Muungu, akadibendua akawekha wahina wakwe akamba, “Doani mde unu nee mwii wangu.” ");
INSERT INTO bou_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akakidoa kikombe cha divai akamtogoa Muungu akawekha akamba, domeani wose, ");
INSERT INTO bou_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Inu nee phome yangu iyonyeshayo Agane dangu ni dakwei, phome yetiwayo kwaajii ya wantu wangi kwa kuwausia mavigaviga. ");
INSERT INTO bou_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nawamba, khina nidomee vituhu divai ya mzabibu adi msi uda nendaho nidomee mphya hamwe na nywinywi mwe Useuta wa Tate yangu.” ");
INSERT INTO bou_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wekubindaho kutoa wiya, wakahauka wakaita mwe muima wa mizeituni. ");
INSERT INTO bou_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aho Yesu akagombeka, “Kio cha ivyeo nywie wose mwendamniguuke kwaviya Maandiko yagombeka, ‘Muungu endaamtoe mwiisi na tintimo da ngoto dendadiangadike.’ ");
INSERT INTO bou_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iya bada ya miye kuyuyuka nendaniwaongwee uko Galilaya.” ");
INSERT INTO bou_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo akamwamba Yesu, “Wose wakakubada miye katu khinanikubade.” ");
INSERT INTO bou_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu akamwamba Petulo, “Kwei nakwamba, kio iki zogoo khadizati kukema wendauniemee maa ntatu.” ");
INSERT INTO bou_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo akamwamba, “Hata nikakudigwa niuye na nyuma hamwe nawe khinanikubade katu.” Wada wahina watuhu wose wakatamwiiya viyaviya. ");
INSERT INTO bou_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu akaita hamwe na wahina wakwe adi hantu ekwetangwaho Getisemani akawamba, “Ekaeni hanu, miye naita kuvika.” ");
INSERT INTO bou_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akamdoa Petulo hamwe na wada wana waidi wa Zebedayo, akavoka kuwa na usungu na uku aona kiyangayanga, ");
INSERT INTO bou_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","aho akawamba, “Nina usungu muno mwe moyo ata nihehi na kuuya na nyuma, ekaeni hanu na msekugona na muwe hamwe na miye.” ");
INSERT INTO bou_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aho akaita mbee kidogo akagonea ifu, akavika akamba, “Tate yangu, usekutenda nengie mwe masuumizo yezayo isasa, khio inga nikundavyo miye iya inga ukundavyo wee.” ");
INSERT INTO bou_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akawatimia wada wahina akawabwiia wagona, neamuuza Petulo, “Yaani khamwekudaha kucheeza hamwe na miye hata saa dimwe? ");
INSERT INTO bou_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Msekugona iya vikani msekweza kwengia mwe mageezo. Kwaviya muye wakunda akini mwii unyong'onyea.” ");
INSERT INTO bou_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akaita vituhu maa ya kaidi akavika, “Eee Tate yangu, ikawa khaidahika kuyembokea maasumizo haya makuu, naho ugosoe ukundavyo wee.” ");
INSERT INTO bou_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akawatimia vituhu akawabwiiya wagona, kwaviya nee watozwa muno na usisiza. ");
INSERT INTO bou_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aho akawabada, akaita vituhu kuvika maa ya ntatu kwa mbui idaida. ");
INSERT INTO bou_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naho akawaitiya wada wahina, akawamba, “Mke mgonie na kuhumwiza? Kauwani, saa ibua na Mwana wa Mntu endaalavigwe kwa wantu wenye mavigaviga. ");
INSERT INTO bou_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enukani, titeni! Kauwani, eza yuda endaeanihituke.” ");
INSERT INTO bou_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ekuwaho ake kugombeka, Yuda Isikaliote yumwe wa wada wahina kumi dimwe na waidi akabua, uku katongeana na zumwezumwe kuu da wantu wenye malungu na mapaange wekuwao waagiiwa na wagookezi wa waviki na wagookezi wa Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda Isikaliote mwe kukunda kumhituka Yesu akawekha awo wantu ntangio, “Mntu uyo nendae nimuuguse kwa kumuumbatia uyo mgwiyeni.” ");
INSERT INTO bou_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda Isikaliote akamtimia Yesu hehi akamuugusa, “Mhinyi nakuugusa!” Nee amuumbatia. ");
INSERT INTO bou_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu akamwamba, “Mbuyangu gosoa wekwezeado.” Aho wada wantu wakamtimia nee wamfuntia na kumgwiiya Yesu. ");
INSERT INTO bou_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumwe wa wada wekuwao hamwe na Yesu akasomoa tuni dakwe khuu, akamsenga gutwi mtumwa wa mviki mkuu. ");
INSERT INTO bou_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu akamwamba, “Vuza tuni dako mwe kisafuo, kwaviya yoyose atumiae tuni kwa kukoma wantu, endaauye na nyuma kwa tuni. ");
INSERT INTO bou_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ivi tambe khammanya kuwa nadaha kumwombeza uwambiizi Tate yangu akanietea mazumwezumwe kumi dimwe na mbii ya wandima wakwe wa Muungu? ");
INSERT INTO bou_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Iya nikagosoa ivyo Maandiko ya Muungu yendayaiganie viivihi?” ");
INSERT INTO bou_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kisingi ichoicho Yesu akadigombeka ido zumwezumwe da wantu, “Ivi mweza kunigwiiya kwa mapaange na malungu inga miye nibagaa? Kia msi nekhiwa he Nyumba ya Muungu nikahinya, na khamwekunigwiiya! ");
INSERT INTO bou_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Iya aya yose yagosoka ili Maandiko wekuandikayo waoni yaiganie.” Nee wahina wose wakambada na kumguuka. ");
INSERT INTO bou_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wada wantu wekumgwiiyao Yesu wakamwegaa he nyumba ya mviki mkuu ekwetangwae Kayafa, wekukintanikaho wahinyi wa miko na wagookezi wa Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo akamtongea kwa hae adi kwe ukumbi da mviki mkuu, akengia mwe buha da ida nyumba hamwe na wagoji adahe kukauwa mbui zendavyozilawiiye. ");
INSERT INTO bou_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wagookezi wa mkonga na waviki wakuu wakaondeza uvuhuzi wa uhokho wadahe kumkoea masa Yesu ili wamkome. ");
INSERT INTO bou_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Iya khawekupata uvuhuzi wowose, etiho nee weza wavuhuzi wangi wa uhokho. Kisikiizi wakeza wavuhuzi waidi, ");
INSERT INTO bou_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wakamba, “Mntu uyu kagombeka, ‘Nadaha kuituwa Nyumba ya Muungu na kuizenga kwa misi mitatu.’ ” ");
INSERT INTO bou_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mviki mkuu akagooka na kumuuza Yesu, “Wee khuna chakutambaisa kwa aya wagombekayo wantu awa?” ");
INSERT INTO bou_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iya Yesu yee khekuandua dodose. Mviki mkuu akamwamba, “Nakuahiza kwa Muungu wa ugima, tambe ati wee nee Klistu, Mwana wa Muungu!” ");
INSERT INTO bou_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akamtambaisa, “Inga wekugombekavyo miye nee uyo. Iya nawamba, kuvokea isasa mwendammuone Mwana wa Mntu kekaa phande ya kuume ya yuda mwenye udaho, akeza uwanga ya mazunde ya uwanga kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aho mviki mkuu akatatua gwanda dakwe akamba, “Kambea Muungu takunda wavuhuzi wani vituhu? Nywie wenye mtegeeza ekumbeavyo Muungu. ");
INSERT INTO bou_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nywie mwaona viivihi?” Wowo wakamtambaisa, “Akundigwa auye na nyuma!” ");
INSERT INTO bou_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ahoaho wakamswiiya ovu mwe cheni na watuhu wakamtoa ngumi na watuhu vibao, ");
INSERT INTO bou_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wakamwamba, ati wee nee klistu “Otea! Ni ndai mwekukutoa!” ");
INSERT INTO bou_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kisingi Petulo nekekaa chongoi he buha. Mndima yumwe wa kivyee wa Mviki Mkuu akamwezea na kumwamba, “Wee namba ne uhamwe na Yesu wa Galilaya.” ");
INSERT INTO bou_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petulo akaemea hemeso ya wose akamba, “Khimanya wagombeka mbwai.” ");
INSERT INTO bou_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ekuwaho akalawa he uvi, mndima mtuhu wa kivyee ekumwonaho, akawamba wada wekuwao hada, “Mntu uyu nekawa na Yesu wa Nazaleti.” ");
INSERT INTO bou_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo akaemea vituhu kwa kuaha, “Khimmanya mntu uyo.” ");
INSERT INTO bou_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kisingi kidogo, wantu wekuwao hada wakambasa Petulo na kumwamba, “Ata wee, ni yumwe yao, kwaviya ata viya ugombekavyo kwakumanyisa.” ");
INSERT INTO bou_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aho Petulo akavoka kweswiiya ute na kweahiza na kugombeka, “Khimmanya mntu uyo!” Ahoaho zogoo akakema, ");
INSERT INTO bou_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","aho Petulo akaikumbuka ida mbui ekwembigwayo ni Yesu, “Zogoo khadizati kukema wenda uniemee maa ntatu.” Aho akalawa chongoi na akavoka kuiya kwa usungu. ");
INSERT INTO bou_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kwekuchaho wagookezi wa Waviki wose na waongoezi wa Wayahudi wakakintana vituhu ili wagosoe nteganyi wadahe kumkoma Yesu. ");
INSERT INTO bou_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wakamzengeteza phingu na kumwegaa kwa Pilato, mwekuwa mgookezi wa Kilumi. ");
INSERT INTO bou_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda Isikaliote mwekumhituka Yesu, ekuonaho Yesu kabindakae kuamuiwa, akamema usungu na akawavuzia wagookezi wa waviki wakuu zia ntii za makumi matatu ya madini ya feza. ");
INSERT INTO bou_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akawamba, “Khikoa masa kwa kumlavya mntu mwesekuwa na masa yoyose akomwe.” Iya wowo wakamtambaisa, “Yatiambiiza mbwai swie? Ivyo umanye wee mwenye!” ");
INSERT INTO bou_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nee atambika zia ntii za madini ya feza he nyumba ya Muungu na kulawa chongoi na kuita kwetungika. ");
INSERT INTO bou_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Waviki wakuu wakadoa zia ntii za madini za feza wakamba, “Khaifaa kuika hamwe madini aya ya feza na madini yalavigwayo mwe Nyumba ya Muungu kwaviya ntii izi za madini ya feza zilavigwa kwaajii ya kumkoma mntu.” ");
INSERT INTO bou_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wekubindaho kumamakhanya wakevana kugua mnda wa kiongo hawe hantu hauzisi ha wanyika. ");
INSERT INTO bou_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nee mana adi ivyeo mnda uwo wetangwa mnda wa phome. ");
INSERT INTO bou_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nee yaigania ida mbui yekwegombekwayo na Muoni Yelemia, kuwa, “Wakadoa ziya ntii za makumi matatu ya madini ya feza, yombe yekupangwayo na wantu wa Isilaeli, ");
INSERT INTO bou_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","wakaziguiya mnda wa kiongo, inga Zumbe ekuniagiiavyo.” ");
INSERT INTO bou_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ekuwaho kagooka hemeso ya Pilato ekuwaye mgookezi wa Kilumi, akamuuza, “Wee nee Seuta wa Wayahudi?” Yesu akagombeka, “Inga wekugombekavyo miye nee uyo.” ");
INSERT INTO bou_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iya wagookezi wa waviki na wadaa wekumwahiavyo masa khekutambaisa mbui. ");
INSERT INTO bou_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ivyo Pilato akamuuza, “Ivi khutegeeza mbui ambazo wazigombeka?” ");
INSERT INTO bou_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Iya Yesu khekuandua ata mbui mwenga, ata uyo mgookezi wa Kilumi akahondomaa muno. ");
INSERT INTO bou_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Neiwa kawaida kisingi cha sikukhuu ya Pasaka mgookezi wa Kilumi awavugwiiya zumwezumwe da wantu mfungwa yumwe wamkundae. ");
INSERT INTO bou_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kisingi icho nekuwa na mfungwa yumwe ekuwaye mntu mfyaimi, zina dakwe Balaba. ");
INSERT INTO bou_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ivyo wantu wekukintanikaho hamwe, Pilato akawauza, “Mwakunda ni wavugwiiye yuhi gatigati ya awa waidi, Balaba hambu Yesu etangwae Klistu?” ");
INSERT INTO bou_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kagombeka ivyo, kwaviya kamanya wamueta kwakwe kwaajii ya kinyuu. ");
INSERT INTO bou_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato ekuwaho kekaa mwe kigoda chakwe cha kuamuiya, mkaziwe akamwetea bauwa inu. “Usekumgosoa kintu chochose mntu uyu yedi, na kwaviya ivyeo khisuumizwa muno mwe sozi kwaajii yakwe.” ");
INSERT INTO bou_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iya waviki wakuu na wadaa wakawanchochea dia zumwezumwe da wantu wamwombeze Balaba aekewe na Yesu akomwe. ");
INSERT INTO bou_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato akawauza, “Gatigati ya awa waidi ni yuhi mumkundae niwavugwiiye?” Wakatambaisa, “Balaba!” ");
INSERT INTO bou_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato akawauza, “Isasa mwaonda nimtende viivihi na Yesu mwetangwae Klistu?” Wose wakagombeka, “Agong'ondewe he mhamba!” ");
INSERT INTO bou_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato akawauza, “Kwa mbwai? Ni ufyaimi wani ekugosoao?” Wowo wakaendeea kutoa mgutio, “Agong'ondewe he mhamba!” ");
INSERT INTO bou_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato ekuonaho kuwa khadaha kugosoa dodose na kwaviya khumbizi zavoka kulawiiya, akadoa mazi na akasunta mikono hemeso ya dia zumwezumwe da wantu, akamba, “Mie khimo mwe mbui ya kumkoma mntu uyu, mbwii yenu wenye.” ");
INSERT INTO bou_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wantu wose wakamba, “Kwa mbui inu tiigosoayo, Muungu na atekhe sugusa swie hamwe na wana wetu!” ");
INSERT INTO bou_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aho Pilato akawavuguiya Balaba kulawa he kifungo, na akagombeka Yesu atoigwe na ngoda yekwegosolwayo na babu da kiboko, na akamlavya agong'ondewe he mhamba. ");
INSERT INTO bou_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wakamwegaa gati mwe nyumba ya ugookezi, na maasikai wose wakamzunguka. ");
INSERT INTO bou_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wakamhambua gwanda dakwe, wakamhasika joho dekhundu. ");
INSERT INTO bou_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wakagosoa kintu inga khofia seuta yekugosolwayo na miwa wakamhasika mwe mtwi, wakamwiikia ngoda mwe mkono wakwe kuume. Wakakinta mavindi hemeso yakwe, wakambea kwa kumwamba, “Takuugusa Seuta wa Wayahudi!” ");
INSERT INTO bou_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wakamswiiya ovu, wakadoa ida ngoda wekumwekhayo mwe mkono wakwe na kumtoa nayo mwe mtwi ");
INSERT INTO bou_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wekubindaho kumgosoeya ayo, wakamhambua dia gwanda na kumhasika nguo zakwe, na wakamwegaa kumgong'ondea mwe mhamba. ");
INSERT INTO bou_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wekuwaho wakaita kumng'ondea he mhamba wakamuona mntu yumwe zina dakwe Simoni, mwenyezi wa Kilene. Aho asikai wa Wakilumi wakamshuutiza kuudoa mhamba wakwe Yesu. ");
INSERT INTO bou_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wekubuaho hantu hetangwaho Goligota mana yakwe, hantu hafufu da mtwi, ");
INSERT INTO bou_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wakamwekha divai yekuhanganywayo na nyongo. Iya Yesu ekuionjaho akaemea kuidomea. ");
INSERT INTO bou_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wakamgong'ondea he mhamba, naho nguo zakwe wakapangana kwa kuzitoea kula ");
INSERT INTO bou_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wakekaa, wakawa wamuinda. ");
INSERT INTO bou_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uwanga ya mtwi wakwe kwe mhamba nee kuikwa kibao chekuandikwacho, “Uyu ni Yesu, Zumbe wa Wayahudi.” ");
INSERT INTO bou_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Viyaviya mabagaa waidi nee wagong'ondewa kia yumwe na mhamba wakwe, yumwe phande ya kuume na mtuhu phande ya kumoso. ");
INSERT INTO bou_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wantu wekuwao wakemboka hehi na aho wakamdumua na kusingisa mitwi yao kwa kumseka na kugombeka, ");
INSERT INTO bou_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wee kwevuna, wadaha kuitua Nyumba ya Muungu na kuizenga kwa misi mitatu! Inga wee ni Mwana wa Muungu, eohoe mwenye na usee mwenye kulawa aho he mhamba!” ");
INSERT INTO bou_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Viyaviya, wagookezi wa waviki na wahinyi wa miko na waongoezi wa Wayahudi wakamhega na kugombeka. ");
INSERT INTO bou_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kawaohoa watuhu, akini kweohoa mwenye khadaha! Ati yee ni Seuta wa wantu wa Isilaeli! Na asee mwe mhamba, na swie tenda timzumiiye! ");
INSERT INTO bou_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kamkauwiya Muungu, na isasa Muungu amwoohoe inga amkunda, kwaviya kagombeka, ‘Mie ni Mwana wa Muungu.’ ” ");
INSERT INTO bou_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ata wada wahokaji wekugong'ondewao hamwe nae wakamdumua viyaviya. ");
INSERT INTO bou_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kuvokea saa mtandatu, musi adi saa kenda, si yose nenikiza du. ");
INSERT INTO bou_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yekubuaho saa kenda Yesu akaiya kwa mgutio mkuu, “Eloi, Eloi, Lama sabakitani?” Yaani, “Muungu yangu, Muungu yangu, mbona kunibada?” ");
INSERT INTO bou_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iya wantu wada wekugookao hada wekutegeezaho ivyo wakagombeka, “Amwetanga Elia.” ");
INSERT INTO bou_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yumwe awo akaguuka na akadoa dodoki akadiginta mwe divai yekusasayo, akaiika uwanga ya lasi, na akamwekha adomee. ");
INSERT INTO bou_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Watuhu wakagombeka, “Eka tikauwe ati Elia endaeze kumwoohoa.” ");
INSERT INTO bou_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naho Yesu akaiya vituhu kwa mgutio mkuu na akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ahoaho pazia da Nyumba ya Muungu dikatatuka ntii mbii, kulawa uwanga hadi asi, na inusi ikazingiza na maiwe makuu yakabondekabondeka, ");
INSERT INTO bou_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mambiya yakavuguka na wantu wa Muungu wakayuyuswa. ");
INSERT INTO bou_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bada ya kuyuyuka kwakwe Yesu, wakalawa mwe mambiya na wakengia mzi wa Muungu na wantu wangi wakawaona. ");
INSERT INTO bou_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yuda mkuu wa maasikai hamwe na weziwe wekuwao wakamuinda Yesu wekuonaho zingizo da inusi na zia mbui zekulawiiazo wakaogoha muno na wakagombeka kwei, “Mntu uyu neekawa Mwana wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hantu aho newaaho wavyee wangi wakamkauwa kwa hae. Awo nee wada wekumtongeao Yesu kulawa Galilaya wakamwambiiza. ");
INSERT INTO bou_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gatigati yao nee ni Maliamu mntu wa Magidala na Maliamu mami yao da Yakobo na Yusufu, hamwe na mami yao wana wa Zebedayo. ");
INSERT INTO bou_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yekubuaho guoni, akeza mntu yumwe mwenye vintu vingi zina dakwe Yusufu mwenyezi wa mzi wa Alimataya. Yee naye nekawa mhina wa Yesu, ");
INSERT INTO bou_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","akambasa Pilato akauombeza mwii wa Yesu. Aho Pilato akamba ekhigwe. ");
INSERT INTO bou_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu akaudoa uda mwii akauzengeteza sanda yekung'aayo muno, ");
INSERT INTO bou_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","akauiika mwe mbia dihya ekudisongoado mwe iwe kuu, akadoa iwe kuu na kudiika he uvi, na akahauka zakwe. ");
INSERT INTO bou_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliamu mntu wa Magidala na Maliamu yuda mtuhu, newekaa kukauwa mbia da Yesu. ");
INSERT INTO bou_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kioi yakwe, yaani Msi wa Kuhumwiiza, Waviki wakuu na Mafalisayo wakambasa Pilato, ");
INSERT INTO bou_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wakamwamba, “Mkuu tikumbuka kuwa, ‘Yuda mtiizi katigombeka, kisingi khazati kuuya na nyuma, bada misi mitatu nendaniyuyuke.’ ");
INSERT INTO bou_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwaiyo agiiya ido mbiya diindwe adi misi mitatu ili wahina wakwe wasekweza kumbawa, na kuwamba wantu kayuyuka. Uhokho hunu wa kisikiizi wendauwe wa ufyaimi muno kusima uda wa bosi.” ");
INSERT INTO bou_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato akawamba. “Haya, mnao waindaji na waite mkadiinde mmanyavyo.” ");
INSERT INTO bou_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ivyo wakaita na wagoji ili kudiinda dia mbia vitana, na wakaika alama mwe dia mbia na aho waika asikali wainde. ");
INSERT INTO bou_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wekwembokaho Msi wa Kuhumwiiza na yekubuwaho keo muno msi wa Jumapili. Maliamu mntu wa Magidala na yuda Maliamu mtuhu wakaita kudikauwa dia mbia. ");
INSERT INTO bou_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vuu puu, kukalawiiya zingizo kuu da inusi mndima wa Zumbe akaseeya kulawa uwanga kwa Muungu akaditongoosa dia iwe na akadekaiya. ");
INSERT INTO bou_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Akoonekana inga umweko na nguo zakwe nezing'aa chwee. ");
INSERT INTO bou_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wagoji wa dia mbiya wakakama kwa ukeng'enta mkuu wakawa inga wekuuyao na nyuma. ");
INSERT INTO bou_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Iya yuda mndima wa uwanga kwa Muungu akawamba wada wavyee, “Nyie mwesekuogoha! Namanya mwa mwondeza Yesu mwekugong'ondewa he mhamba. ");
INSERT INTO bou_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hanu khayuho kwaviya kayuyuka inga ekugombekavyo. Sooni mhakauwe hantu hekuwaho mwii wakwe ugonezwa. ");
INSERT INTO bou_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naho hitani kinyionyio mkawambe wahina wakwe kuwa kayuyuka na isasa awaongoeya kuita Galilaya, uko mwendamumwone. Aya miye khigombeka kae.” ");
INSERT INTO bou_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Awo wavyee wakahauka hada he mbiya uku wamema ukeng'enta na nyemi muno, wakaita uku waguuka wakawambe wahina wakwe mbui iyo. ");
INSERT INTO bou_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vuu puu, Yesu akakintana nawo akagombeka, “Mwaona vihi.” Awo wavyee wakamtimia na kukinta mavindi hemeso yakwe wakatoza miundi yakwe wakavika. ");
INSERT INTO bou_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nee Yesu awamba, “Mwesekuogoha! Hitani mkawambe wandugu zangu waite Galilaya na uko wenda wanione.” ");
INSERT INTO bou_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kisingi wada wavyee wekuwaho wakaita zao siai, wamwe na wamwe wa asikai wekuwao wainda mbiya wakaita mwe mzi na kuwatamwiiziya wagookezi wa waviki kia kintu chekulawiiacho. ");
INSERT INTO bou_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Awo wagookezi wa waviki kukintana hamwe na waongoezi wa Wayahudi na kugosoa nteganyi yao, na wakawekha wada asikai hea nyingi muno, ");
INSERT INTO bou_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wakawamba, “Nywie mwenda mgombeke ivi, ‘Wahina wakwe nee weza na kio, wakaudoa mwii wakwe kisingi swie nee tigona.’ ");
INSERT INTO bou_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Inga mbui izi zikambwiiya mgookezi Pilato swie tendatigombeke nae na nywie khamnampate tatizo dodose.” ");
INSERT INTO bou_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wada wagoji wakazidoa zia hea inga wekuhinywavyo. Mbui iyo ikaambazika gatigati ya Wayahudi hadi ivyeo. ");
INSERT INTO bou_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wada wahina kumi dimwe na mwenga wakaita Galilaya kwe uda muima inga ekuwaagiiavyo Yesu. ");
INSERT INTO bou_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akini watuhu newawa khawazumiiya kuwa kwei nee ni Yesu. ");
INSERT INTO bou_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akeza hehi na kuwamba, “Nchekhigwa udaho wose wa uko uwanga kwa Muungu na mwe inusi. ");
INSERT INTO bou_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hitani mkawagosoe wantu wa si zose wawe wahina wangu, mkawabatiiza kwa zina da Tate na da Mwana na Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wahinyeni kutoza miagiiyo yangu nikuwekhayo. Na miye ni hamwe na nywie misi yose, adi kisingi cha kisikiizi.”");
INSERT INTO bou_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inu ni Mbui Yedi ya Yesu Klistu, Mwana wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ivoka inga yekuandikwavyo he kitabu cha muoni wa Muungu etangwaye Isaya, “Muungu akagombeka, ‘Namuagiiya mndima yangu Akuongwee, endaye akugoswee sia yako.’ ");
INSERT INTO bou_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mgutio wa mntu wetanga mwenyika ‘Mgosoeyani Zumbe sia yakwe Nyooshani myemboko yakwe.’” ");
INSERT INTO bou_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana mbatiiza kalawiiya mwe nyika, akawabiikia wantu na kuwabatiiza na kuwamba, “Waeke mavigaviga na Muungu endaawaekee mavigaviga yao.” ");
INSERT INTO bou_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wantu wose kulawa si ya Uyahudi na wada wa mzi wa Yelusalemu, wakambasa kumtegeeza Yohana na kubada mavigaviga yao, nee wabatizwa mwe zigizigi da mazi Yolodani. ");
INSERT INTO bou_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana kavaa gwanda dekugosolwado na mazoya ya mnyama mwetangwa ngamia, na mshipi wa babu mwe kigudi chakwe, naho khande yakwe ne nsige na woki. ");
INSERT INTO bou_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Akawamba wantu, “Eza mntu kwe mgongo wangu mwenye udaho kusima miye. Naho miye khikundigwa ata kwenama na kuchopoa sigi za sabana zakwe. ");
INSERT INTO bou_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miye nabatiiza kwa mazi, akini yee endaawabatiize kwa Muye wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Misi ida Yesu akatimia kulawa Nazaleti mzi wa Galilaya, akabatizwa ni Yohana mwe zigizigi da mazi Yolodani. ");
INSERT INTO bou_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ahoaho ekulawaho mwe mazi, Yesu akaona uwanga kwa Muungu kuvuguka na Muye wa Muungu ukaseeya inga suwa uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mgutio ukategeezeka kulawa uwanga kwa Muungu, “Uyu ne mwanangu nimkundaye, nitamiwaye naye.” ");
INSERT INTO bou_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ahoaho Muye wa Muungu ukamuongoeeya kuita he kiwawe. ");
INSERT INTO bou_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akekaa uko kwa misi makumi mane, akageezwa ni Ibiisi. Kekaa uko hamwe na wanyama wa mzituni, naho wandima wa uwanga wa Muungu wamuambiza. ");
INSERT INTO bou_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana ekuikwaho mwe kifungo, Yesu akaita mwe si ya Galilaya, akabiikia Mbui Yedi ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akagombeka, “Kisingi kibua, Useuta wa Muungu uhehi! Hitukani mzumiiye Mbui Yedi!” ");
INSERT INTO bou_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Naho Yesu ekuwaho akemboka khandakhanda ya tondoo da mazi ya Galilaya, nee awaona wavuvi waidi, Simoni na nduguye Anduleya, walowa samaki. ");
INSERT INTO bou_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu akawamba, “Nitongeani miye, nendaniwatende muwaete wantu kwangu inga walowa waetavyo samaki.” ");
INSERT INTO bou_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aho wakazibada nyavu zao wakamtongea. ");
INSERT INTO bou_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ekuitaho mbee kidodo nee awaona Yakobo na nduguye Yohana wana wa Zebedayo. Wowo pia newawa mwe ngaawa yao, naho ne wakagosoa nyavu zao. ");
INSERT INTO bou_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ahoaho Yesu akawetanga, wakambada tati yao Zebedayo mwe ngaawa hamwe na wandima wakwe na kumtongea Yesu. ");
INSERT INTO bou_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wahina wakwe nee waita mzi wa Kapelinaumu. Msi wekwezao wa Kuhumwiiza, Yesu akengia mwe Nyumba ya kukintania Wayahudi, nee avoka kuhinya wantu. ");
INSERT INTO bou_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wantu wose wekumtegeezaho nee wahondomaa kwa mahinyo yakwe, kwaviya khekuwa akahinya inga wahinyi wa miko, iya inga mntu mwenye udaho. ");
INSERT INTO bou_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mwe Nyumba ya kukintania Wayahudi akaawiiya mntu yumwe mwekuwa na mazaiko, nee agutia, ");
INSERT INTO bou_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Una mbwai na swie, Yesu wa Nazaleti? Kweza kutidagamiza? Namanya wee u ndai? Wee ni Mntu Mtana wa Muungu!” ");
INSERT INTO bou_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu akadiwakia ido zaiko, “Nyamaa muawe mntu uyu!” ");
INSERT INTO bou_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dia zaiko dikamgea ugwa mtwi, akaiya kwa mgutio mkuu akamlawa. ");
INSERT INTO bou_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wantu wose wakahondomaa wakauzana, “Inu ivivihi? Uwo ni mahinyo mahya? Kwaviya kwa udaho mntu uyu alavya mazaiko, naho yamtegeeza!” ");
INSERT INTO bou_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nee mbui za Yesu zikaambazwa mwe si yose ya Galilaya. ");
INSERT INTO bou_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wakalawa he Nyumba ya kukintania Wayahudi, wakaita mwenga kwa mwenga kaya kwa Simoni na Anduleya na Yakobo na Yohana wakaita hamwe nawo. ");
INSERT INTO bou_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naho mkwewe da Simoni ya kivyee nee yumwe usazi ni mtamu ana bombom kai, Yesu ekubuaho wakamwamba mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu akamtimia hehi yakwe, akamtoza mkono uyo mvyee, akamwenua na ahoaho homa ikamwekea. Akavoka kuwagosoeya ndima. ");
INSERT INTO bou_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Guoni zua dekuswaho, wakamwegaiya Yesu watamu wose na wekukwewao mazaiko. ");
INSERT INTO bou_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wantu wose wa mzi uda wakakintana chongoi ya uvi. ");
INSERT INTO bou_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu akawahonya wantu wangi wekuwao na tamu mbaimbai na akaguusa mazaiko mangi. Naho khekuwaekea watamwiiye kintu chochose kwaviya wammanya yee ni ndai. ");
INSERT INTO bou_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Keokeo da mtungaihu, Yesu akalawa akaita hantu kwesaho wantu kuvika. ");
INSERT INTO bou_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na weziwe wakaita kumoondeza, ");
INSERT INTO bou_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","wekumwonaho wakamwamba, “Kiya mntu akoondeza.” ");
INSERT INTO bou_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu akawatambaisa, “Titeni he mizi mituhu yahehi nikabiikie uko, miye ncheza kwaajii iyo.” ");
INSERT INTO bou_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naho akaita si yose ya Galilaya, akabiikia mwe Nyumba ya kukintania Wayahudi na kuwaakia mazaiko. ");
INSERT INTO bou_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mntu yumwe mwekuwa na utamu wa nyoka akambasa Yesu, akamheembeza na kumkintia mavindi na kumwamba, “Ukakunda, wadaha kuning'aza.” ");
INSERT INTO bou_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu akamwonea mbazi, akenua mkono wakwe na kumdonta. Nee amwamba, “Nakunda, ng'azika! ");
INSERT INTO bou_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ahoaho utamu wa nyoka ukamuekea yuda mntu, akang'azika.” ");
INSERT INTO bou_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naho Yesu akamwamba aite kinyionyio na kumwamba, ");
INSERT INTO bou_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tegeeza, usekumwamba mntu yoyose mbui inu. Akini hita ukeonyeshe kwa mviki, na kwaajii ya kung'aa kwako ukalavye mviko inga ekugombekavyo Musa koonyesha kuhona.” ");
INSERT INTO bou_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Akini yuda mntu akaita na akavoka kuambaza mbui izo kiya hantu, hata Yesu khekudaha kwengia mwe mzi wowose kwa kweonyesha. Nee ekaa chongoi kwesaho wantu, nee ivyo wantu wakambasa kulawa kiya phande. ");
INSERT INTO bou_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yekwembokaho misi micheche, Yesu akauya mwe mzi wa Kapelinaumu wantu wakategeeza yukaya. ");
INSERT INTO bou_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aho wakeza wantu wangi na kumema hewazo adi kwe uvi. Yesu nee awabiikia mbui zakwe, ");
INSERT INTO bou_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","kisingi ichoicho wantu wane nee wabua wakamwenua mntu yumwe mwekuhooa, wakamwegaa kwa Yesu. ");
INSERT INTO bou_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwaajii ya zumwezumwe da wantu dekumemado, khawekudaha kubua hehi na Yesu. Ivyo wakabovoa hantu ha chusi yekuwayo uwanga ya hantu ekuwaho Yesu, nee waseeza javi da yuda mwekuhooa. ");
INSERT INTO bou_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ekuonaho kuzumiiya kwao, akamwamba yuda mwekuhooa, “Mwanangu, kuekewa mavigaviga yako.” ");
INSERT INTO bou_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wahinyi watuhu wa miko newawa mwe nyumba ida wekaa, wakamamakhanya mwe mioyo yao, ");
INSERT INTO bou_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Haikuka mbwahi ata agombeka ivi? Kamdumua Muungu! Khahana mdaha kuekea mntu mavigaviga iya Muungu ikedu!” ");
INSERT INTO bou_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu akamanya wamamakhanyavyo mwe mioyo yao nee awauza, “Kwa mbwai mwamamakhanya ivyo mwe mioyo yenu? ");
INSERT INTO bou_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vyedi ni vihi, kumwamba mntu mwekuhooa, ‘Kuekewa mavigaviga yako’, hambu kugombeka, ‘Enuka wetwike javi dako wende?’ ");
INSERT INTO bou_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Akini mmanye Mwana wa Mntu ana udaho wa kuekea wantu mavigaviga yao mwe inusi.” Nee Yesu amwamba yuda mntu mwekuhooa, ");
INSERT INTO bou_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nakwamba, gooka, wetwike javi dako uite kaya!” ");
INSERT INTO bou_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ahoaho wantu wose nee wamkauwa yuda mntu akenuka, na kudoa kilago chakwe, akahauka. Wantu wose nee wahondomaa na kumtogoa Muungu wakamba, “Khatizati kuona katu mbui inga inu!” ");
INSERT INTO bou_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu akaita vituhu khandakhanda ya tondoo da mazi ya Galilaya. Zumwezumwe da wantu dikambasa, nee avoka kuwahinya. ");
INSERT INTO bou_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ekuwaho akemboka, nee amwona Lawi mwana wa Alifayo, kekaa mwe kazumba ka kuihia kodi. Yesu akamwamba, “Nitongea.” Lawi akagooka akamtongea. ");
INSERT INTO bou_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kisingi kwemboka Yesu nee kekaa mwe nyumba ya Lawi, akada khande. Watoza ushuu na wada wagosoao mavigaviga nee wakambasa Yesu, na wangi wao wawa wekaa hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wamwe wa wahinyi wa miko, wekuwao Mafalisayo, wekumuonaho Yesu ada hamwe na wagosoa mavigaviga na watoza ushuu, nee wawauza wahina wakwe, “Kwambwai ada na watoza ushuu na wagosoa mavigaviga?” ");
INSERT INTO bou_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ekuwategeezaho, nee agombeka, “Wantu wesao kuhuma khawakunda mganga akini wamkundao ni wada wahumao. Nchekweza kuwetanga wedi, iya wenye mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kisingi kimwe wahina wa Yohana mbatiiza hamwe na wahina wa Mafalisayo nee wehiniza kuda. Naho wantu wakeza wakamuuza Yesu, “Kwambwai wahina wa Yohana na wa Mafalisayo wehiniza kuda, akini wahina wako khawehiniza kuda?” ");
INSERT INTO bou_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akatambaisa, “Wantu wekugonekwao kwe wiya wadaha viivihi kwehiniza kuda ikawa zumbe wa wiya yu hamwe nao? Khawadaha kwehiniza kuda wakawa hamwe na zumbe wa wiya. ");
INSERT INTO bou_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Akini kisingi chendakibue zumbe wa wiya endaho ausigwe gatigati yao, aho wendawehinize kuda. ");
INSERT INTO bou_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Khahana mntu msenga kilaka kihya na kukibwikabwika mwe nguo yekusakaayo, inga akatenda ivyo iko kilaka kihya chendakitatue nguo yekusakaayo, naho yendaibanike muno. ");
INSERT INTO bou_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naho khahana wantu wageayo divai mhya mwe mikwiji ya babu yekusakaayo, inga wakagosoa ivyo divai yendaitatue mikwiji ya babu, na divai hamwe na mikwiji ya babu yendaibanike. Divai mhya yagewa mwe mikwiji mihya.” ");
INSERT INTO bou_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Msi umwe wa Kuhumwiiza, Yesu na wahina wakwe wekuwaho wemboka mwe minda ya uhemba, wekuwaho wakenda wahina wakwe wakavoka kusenga uhemba. ");
INSERT INTO bou_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo wakamuuza Yesu, “Kauwa, ni viivihi wagosoa mbui ziemewazo kugosoa Msi wa Kuhumwiiza?” ");
INSERT INTO bou_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu nee awatambaisa, “Khamzati kusoma ekugosoavyo Daudi hamwe na weziwe kisingi wekuwaho na saa? ");
INSERT INTO bou_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yee akengia mwe Nyumba ya Muungu akada yada mabumunda yekuikwayo hemeso ya Muungu. Mbui inu igosoka kisingi cha Abiazali, nekawa Mviki Mkuu. Na ni waviki wowodu wakukundigwao wade mabumunda ayo, akini Daudi kada na kuwekha na weziwe.” ");
INSERT INTO bou_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naho Yesu akawamba, “Msi wa Kuhumwiiza uikwa kwaajii ya wantu na khio wantu kwaajii ya Msi wa Kuhumwiiza. ");
INSERT INTO bou_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ivyo Mwana wa Mntu ana udaho ata wa Msi wa Kuhumwiiza.” ");
INSERT INTO bou_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naho Yesu akengia vituhu mwe Nyumba ya kuvikia Wayahudi, nemuwa na mntu mwekuhooa mkono. ");
INSERT INTO bou_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Umo wantu watuhu wakamgoja amhonye mntu uyo Msi wa Kuhumwiiza ili wadahe kumuahiya masa. ");
INSERT INTO bou_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu akamwamba uyo mntu mwekuhooa mkono, “Soo aha gooka hemeso ya kia yumwe.” ");
INSERT INTO bou_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Naho akawauza, “Kulawana na miko yetu takundigwa kugosoa mbwai Msi wa Kuhumwiiza? Kuohoa ugima au kukoma?” Akini wowo khawekuandua dodose! ");
INSERT INTO bou_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aho Yesu akawafuiya meso kwa maya, akaugumia, kwaajii ya mioyo yao itogayo. Naho amwamba yuda mntu, “Enua mkono wako!” Naye akenua mkono wakwe, ukatenda mgima vituhu. ");
INSERT INTO bou_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ahoaho Mafalisayo wakalawa chongoi, wakakintana hamwe na kizumwezumwe cha Helode wakaondeza sia ihi wendayo wamkome Yesu. ");
INSERT INTO bou_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu hamwe na wahina wakwe, wakahauka na kuita khandakhanda ya tondoo da mazi. Na zumwezumwe da wantu kulawa si ya Galilaya dikambasa, ");
INSERT INTO bou_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","wekusikiaho mbui zose ekugosoazo, zumwezumwe da wantu dikamwezea kulawa Uyahudi na Yelusalemu na Idumea na si zose zekuwazo awio da zua da zigizigi da mazi Yolodani hamwe na wada wa hehi wa si ya Tilo na Sidoni. ");
INSERT INTO bou_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu akawamba wahina wakwe wamuikie ngaawa kwaviya wantu wasekumfintafinta. ");
INSERT INTO bou_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kwaviya ne kawahonya watamu wangi, na watamu wose ne wamfintafinta wadahe kumdonta. ");
INSERT INTO bou_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na kia mwenye zaiko ekumuonaho Yesu, aketambika ahosi hemeso yakwe na kugombeka, “Wee ni Mwana wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Akini Yesu akayaemeza kwa ukai yada mazaiko yasekuwamba wantu kuwa yee ni ndai. ");
INSERT INTO bou_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ne akwea kwe kiima akawetanga wada ekuwakundao ne wambasa. ");
INSERT INTO bou_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naho ne awasagua wantu kumi dimwe na waidi na akawetanga waagiiwa, wekae naye awaagiiye kubiikia wantu, ");
INSERT INTO bou_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na wawe na udaho wa kulavya mazaiko. ");
INSERT INTO bou_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aho kumi dimwe na waidi wekusagulwao ni awa, Simoni mwekwekhigwa zina da Petulo, ");
INSERT INTO bou_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na kakie Yohana wana wa Zebedayo, Yesu akawekha zina Boanege mana yakwe, “Wantu wa tuntumo.” ");
INSERT INTO bou_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulea na Filipo na Batolomayo na Matayo na Tomasi na Yakobo mwana wa Alifayo na Tadayo na Simoni mtoanaji wa si yakwe. ");
INSERT INTO bou_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda Isikaliyote mwekumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Naho Yesu akauya kaya na zumwezumwe da wantu dikakintana vituhu, ata Yesu na wahina wakwe khawekupata phasi ya kuda khande. ");
INSERT INTO bou_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nduguze wekusikiaho mbui iyo wakenda kumdoa kwaajii wantu ne wamba, “Ana kiau.” ");
INSERT INTO bou_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wamwe wa Wahinyi wa Miko kulawa Yelusalemu wakamba, Kakwewa Belizebuli! Mkuu wa mazaiko awalavya wantu mazaiko kwa udaho wa mkuu wa mazaiko. ");
INSERT INTO bou_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu akawetanga, akagombeka nao kwa simo, “Ibiisi adaha viivihi kumguusa Ibiisi mweziwe?” ");
INSERT INTO bou_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Inga wantu wa useuta umwe wakatoana khondo wenye kwa wenye, useuta wendaugwe. ");
INSERT INTO bou_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wantu wa kaya mwenga wakesekwevana kaya iyo yendaidagamie. ");
INSERT INTO bou_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kwaivyo useuta wa Ibiisi ukepanga vizumwezumwe khaudaha kwekaisa iya wendaudagamie. ");
INSERT INTO bou_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Khahana mntu adahae kwengia mwe nyumba ya mntu mwenye mdundugo na kuvidoa vintu vyakwe, avoke kutoana na kumzengeteza yuda mntu mwenye mdundugo nae akamvota endaadahe kuvidoa vintu vyakwe.” ");
INSERT INTO bou_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kwei nawamba, wantu wadaha kuekewa mavigaviga yao hamwe na kumbea Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Akini mntu agombekaye yesayokutama kwa Muye wa Muungu khana aekewe katu, endaawe na mavigaviga ya kae na kae. ");
INSERT INTO bou_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kagombeka ivyo kwaajii wantu watuhu ne wamba, “Ana mazaiko.” ");
INSERT INTO bou_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mami yakwe da Yesu na wanduguze wakabua aho, wakagooka chongoi wakamwagiiya mntu kumwetanga Yesu. ");
INSERT INTO bou_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Zumwezumwe da wantu diwa dekaa aho wekaa bunga. Naho wantu wakamwamba, “Kauwa mami yako na wanduguzo wauko chongoi, wakwetanga.” ");
INSERT INTO bou_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu akawatambaisa, “Mmaa na wandugu zangu ni wakina ndai?” ");
INSERT INTO bou_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aho akawakauwa wada wantu wekuwao wekaa bunga akamba, “Awa ne mmaa yangu na wandugu zangu! ");
INSERT INTO bou_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mntu yoyose agosoaye akundavyo Muungu, uyo ne kaka yangu na umbu dangu na mmaa yangu.” ");
INSERT INTO bou_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ne avoka vituhu kuhinya khandakhanda ya tondoo da mazi ya Galilaya. Zumwezumwe da wantu wangi dikaika bunga naho akengia mwe ngaawa na kwekaa, wantu wose wekaa mwe sanga khandakhanda ya tondoo da mazi. ");
INSERT INTO bou_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Akawahinya mbui nyingi kwa simo, na mwe mahinyo yakwe akawamba. ");
INSERT INTO bou_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tegeezani! Mntu mhanda mbeyu kenda kwetia mbeyu.” ");
INSERT INTO bou_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ekuaho aketia mbeyu ntuhu zigwa khandakhanda ya sia ne wadege weza wakazida. ");
INSERT INTO bou_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ntuhu zikagwa mwe iwe kwesiho na sanga, zikahota aho, kwaviya sanga nee ncheche. ");
INSERT INTO bou_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zua dekulawaho mbeyu ziya zikanyaa, kwaviya mazindo yakwe khayokuwa na udaho. ");
INSERT INTO bou_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu ntuhu nezagwa mwe miwa, ida miwa neyakua na kuzifintafinta ziya mbeyu naho khazokuvyaa. ");
INSERT INTO bou_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na mbeyu ntuhu zikagwa mwe sanga ntana, ne zakua na kuvyaa vitana, mwenga makumi matatu na mwenga makumi mtandatu, na mwenga makumi kumi. ");
INSERT INTO bou_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu akagombeka, “Mwenye magutwi na ategeeze.” ");
INSERT INTO bou_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu ekuwaho ikedu wamwe wa wada wekumtegeezao hamwe na wahina wakwe kumi dimwe na waidi ne wambasa na kumuuza kia ekutamwiacho kwa simo. ");
INSERT INTO bou_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu akawatambaisa, “Nywie mwekhigwa kumanya sii zose za Useuta wa Muungu, akini kwa wada weuko chongoi wenda wembigwe kia kintu kwa simo, ");
INSERT INTO bou_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ili, ‘Wakaue kwei, akini wasekuona Wategeeze kwei, akini wasekumanya. Ama khivyo ne wamhitukia Muungu, wakaekewa.’ ” ");
INSERT INTO bou_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naho Yesu akawauza, “Nyie khammanya msimo unu? Mwadaha viivihi kumanya simo tuhu?” ");
INSERT INTO bou_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbeyu ihandwayo na mntu ahandae mbeyu ni mbui ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wantu watuhu ni inga viya mbeyu zekwetiwazo siai. Ahoaho wategeezaho ida mbui ya Muungu, Ibiisi eza na kuiusa mwe mioyo yao. ");
INSERT INTO bou_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wantu watuhu nao ni inga mbeyu zekwetiwazo mwe maiwe. Ahoaho wategeezaho mbui ida wakaihokea kwa kinyemi. ");
INSERT INTO bou_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Akini khaviwengia nakuwa na mazindo mwe mioyo yao. Mbui ida yekaa kwa misi micheche na kisingi cha suuba kikalawiiya, ahoaho mntu uyu hufa maya. ");
INSERT INTO bou_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wantu watuhu inga mbeyu zekugwazo he miwa. Uwo ni msimo wa wada wekutegezao ida mbui, ");
INSERT INTO bou_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","akini maatu ya mwe inusi na utiizi wa mai, na kukunda muno vintu vingi zikawengia mwe mioyo yao, zafintafinta ida mbui ya Muungu na kuvota kuvyaa matunda. ");
INSERT INTO bou_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Akini watuhu inga mbeyu zekwetiwazo he sanga ntana. Aho wategeeza ida mbui ya Muungu, wakaihokea na kuvyaa matunda watuhu makumi matatu, watuhu makumi mtandatu na watuhu makumi kumi. ");
INSERT INTO bou_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu akaendeea kuwamba, “Uwo wantu wadaha kuwasha koloboi na kwengiza nyumbani na kuigubika kwa biga au kuika mzungui? Aah! Waiika uwanga ya kiango. ");
INSERT INTO bou_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Naho kintu chochose chekufiswacho chenda kioneke, na chochose chekugubikwacho chenda kigubulwe. ");
INSERT INTO bou_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mwenye magutwi ya kutegeeza na ategeeze!” ");
INSERT INTO bou_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naho akamba, “Tegeezani vitana kwa kia mtegeezacho! Miko idaida mtumiayo kuamuiiya watuhu, Muungu enda azitumie kuamuiiya nywie, nayo ata kai muno. ");
INSERT INTO bou_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwaviya mwena endaamemezewe, na mwesena endaahokwe kiya kidodo enacho.” ");
INSERT INTO bou_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu akaendeea kugombeka, “Useuta wa Muungu inga yezayo mntu ahanda mbeyu mwe mnda. ");
INSERT INTO bou_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kio agona, musi yu meso na kisingi icho mbeyu yahota na kukua yee mwenye khamanya vyekugosokavyo. ");
INSERT INTO bou_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwaviya sanga yenye yagosoa mimea kukua na kuvyaa, uvoka kulavya zani teke, naho dakua suke na kulawiiya uhemba wekudahayo. ");
INSERT INTO bou_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uhemba ukabinda kudahaa, mntu uyo adoa nyengo na kuvoka kusenga, kwaajii kisingi cha ubosi kibua.” ");
INSERT INTO bou_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Naho Yesu akagombeka, “Tiuiganye na mbwai Useuta wa Muungu? Tiutamwiize kwa simo zihi? ");
INSERT INTO bou_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Waigana na mbeyu ya haladani, ambayo ni ndodo kwesima zose zihandwazo mwe inusi. ");
INSERT INTO bou_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Akini ikabinda kuhandwa, yahota na kutenda ziti kuu kwesima yose mwe mnda. Naho matambi yakwe yawa makuu hata wadege wa uwanga wazenga masasa yao mwe matambi yakwe.” ");
INSERT INTO bou_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu akawabiikia mbui zakwe kwa simo tuhu nyingi inga izo, akatamwiiana nao kadii wekudahavyo kumanya. ");
INSERT INTO bou_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Khekutamwiiya nao chochose iya kwa simo, akini ekuaho hamwe na wahina wakwe ikedu akawamba kia kintu. ");
INSERT INTO bou_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Msi udauda, guoni Yesu akagombeka na wahina wakwe, “Titeni phande ntuhu ya tondoo da mazi.” ");
INSERT INTO bou_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aho wakabada dia zumwezumwe da wantu, wahina wakwe wakengia mwe ngaawa ekuwayo Yesu. Viyaviya ngaawa ntuhu zikambasa. ");
INSERT INTO bou_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Khusi khai ikaawiya, mkubwaniso wa mazi ikatoa ida ngaawa, nayo ikavoka kumema mazi. ");
INSERT INTO bou_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu ne yunyuma ya ngaawa, naho kagonea mwe kigonea, wahina wakwe wakamwenua na kumwamba, “Mhinyi kwa mbwai khutipatiiza khuona inga tinda tiuye na nyuma?” ");
INSERT INTO bou_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu akenuka na kuiwakia ida khusi na kuyamba mawimbi, “Nyamaa! Twiiya!” Ahoaho khusi ikaeka, ne kwatwiiya tui. ");
INSERT INTO bou_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu akawauza wahina wakwe, “Kwa mbwai mwaogoha? Khamzati kuzumiiya du?” ");
INSERT INTO bou_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naho wakaogoha muno, wakauzana wenye, “Uyu nndai? Hadi khusi na mawimbi vyamtegeeza!” ");
INSERT INTO bou_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wahina wakwe wakabua phande ya kaidi ya tondoo da mazi ya Galilaya mwe si ya Wagelasi. ");
INSERT INTO bou_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ahoaho Yesu ekuseeaho mwe ngaawa akakintana na mntu yumwe mwenye mazaiko kaawiiya he mambia. ");
INSERT INTO bou_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mntu yuda ne akekaa kwe mambia na khahana mntu mwekudaha kumtoza na kumzengeteza minyololo. ");
INSERT INTO bou_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Maa nyingi wamzengeteza kwa phingu mwe mikono na minyololo mwe miundi, akini kia maa akadaha kuidumua iyo minyololo na izo phingu, naho khahana mntu mwekudaha kumuemeza. ");
INSERT INTO bou_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Msi na kio ne akekaa mwe mambia na kwe miima akagutia na kwesengasenga na maiwe. ");
INSERT INTO bou_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ekumuonaho Yesu kwa hae, akamguukia, akamwenamia. ");
INSERT INTO bou_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akamba kwa mgutio mkuu, “Una mbwai nami?, Yesu Mwana wa Muungu mwe uko uwanga muno! Nakuhembeza kwa zina da Muungu wesekunisuumiza!” ");
INSERT INTO bou_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akagombeka ivyo kwaviya Yesu nekawa kamwamba, “Ee zaiko mlaweni mntu uyu!” ");
INSERT INTO bou_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aho, Yesu akamuuza, “Zina dako ni ndai?” Ne amtambaisa, “Zina dangu ni hindoo kwaviya ti wangi.” ");
INSERT INTO bou_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Naho akamhembeeza Yesu asekuwaguusa mwe si ida. ");
INSERT INTO bou_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hehi na aho ne kuwa na tintimo kuu da nguuwe uisi he mpoomoko wa muima. ");
INSERT INTO bou_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aho mazaiko yada yakamhembeza Yesu na kumwamba, “Tegae tikengie kwa wada nguuwe.” ");
INSERT INTO bou_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naye akayekha uhusa, aho yada mazaiko yakamlawa mntu yuda, yakawengiia wada nguuwe. Tintimo dose ido da nguuwe ne diwa elufu mbii dikaseeya mwe uda mpoomoko mkai dikengia mwe tondoo da mazi. ");
INSERT INTO bou_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Waisi wa wada nguuwe, ne waguuka na kuambaza mbui ida mwe mizi na mwe minda. Wantu wakaita wakauwe yekulawiayo. ");
INSERT INTO bou_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ne wamtimia Yesu, wakammbuiya mntu yudayuda mwekuwa kakwewa na hindoo da mazaiko kekaa asi, kavaa nguo, na akii zakwe zimuuiya, wantu wose wakaogoha. ");
INSERT INTO bou_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na wada wekuonaho mbui ida ne wawamba wantu watuhu, chekulawiacho kwa yuda mntu mwekuwa na mazaiko hamwe na mbui za wada nguuwe. ");
INSERT INTO bou_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aho, wantu wakamhembeza Yesu alawe mwe si yao. ");
INSERT INTO bou_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ekuwaho akwea mwe ngaawa yuda mntu mwekuwa na mazaiko akamhembeza waite wose. ");
INSERT INTO bou_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Akini Yesu akamweemeza, naho akamwamba, “Hita kwenu kaya kwa wanduguzo ukagombeke yada yose Zumbe ekukugosoeavyo na kukufiia mbazi.” ");
INSERT INTO bou_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aho yuda mntu akaita na kuvoka kubiikia Dekapoli mana yakwe ni si ya mizi kumi dimwe, mbui zose Yesu ekumgosoeavyo. Wantu wose wakahondomaa. ");
INSERT INTO bou_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akaita vituhu phande ya kaidi ya tondoo da mazi kwa ngaawa. Zumwezumwe da wantu dikammemea hemeso yakwe, naye ne kagooka khandakhanda ya tondoo da mazi. ");
INSERT INTO bou_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aho akeza mntu yumwe etangwa Yailo yumwe wa wakuu wa Nyumba ya kuvikia Wayahudi, ekumuonaho Yesu akakinta mavindi hemeso yakwe. ");
INSERT INTO bou_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akamhembeeza akamba, “Mwanangu wa kivyee mdodo ni mtamu yu hehi na kuuya na nyuma. Nakuhembeza tite ukamuikie mikono yako adahe kuhona na aendeee kwekaa.” ");
INSERT INTO bou_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aho, Yesu akahauka hamwe naye. Wantu wangi wakamtongea Yesu na kumfintafinta kia phande. ");
INSERT INTO bou_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aho ne hawa na mvyee yumwe mwekuwa na utamu wa mtuo kwa kisingi cha myaka kumi dimwe na miidi. ");
INSERT INTO bou_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mvyee uyo ne kaangadika muno kuita kwa waganga wangi. Na etiho kaza mai zakwe zose, akini khekuona ebae, iya kaendeea kuwa mtamu muno. ");
INSERT INTO bou_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Naye uyo mvyee ne kasikia mbui za Yesu ne ahenya gatigati ya dia zumwezumwe da wantu. Akamlawiiya Yesu kwa nyuma na kudonta nguo yakwe. ");
INSERT INTO bou_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kwaviya ne kegombekea mwe moyo wakwe, “Nikadonta nguo yakwe, nenda nihone.” ");
INSERT INTO bou_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ahoaho utamu wa mtuo ukanyaa, akeona mwe mwii wakwe kahona utamu wakwe. ");
INSERT INTO bou_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ahoaho, Yesu akamanya udaho umlawa. Neahitukia dia zumwezumwe da wantu na kuwauza, “Nndai mwekudonta nguo yangu?” ");
INSERT INTO bou_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wahina wakwe wakamtambaisa, “Woona wantu wakufintafinta, naho wauza ni ndai mwekukudonta?” ");
INSERT INTO bou_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Akini Yesu akakauwa phande zose amwone nndai mwekumdonta. ");
INSERT INTO bou_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aho yuda mvyee akamanya yekumlawiayo, akeaviiza, akakama kwa kuogoha, aketambika asi hemeso ya Yesu, na kugombeka yose yekumlawiayo. ");
INSERT INTO bou_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu akamwamba, “Mwanangu kuzumiiya kwako kukuhonya, hita kwa utuivu naho utende mgima.” ");
INSERT INTO bou_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ekuwaaho agombeka, ne weza wantu kulawa kwa Yailo mkuu wa Nyumba ya kuvikia Wayahudi, wakamwamba, “Mwanao kauya na nyuma kae, kwambwai wampisha mhinyi?” ");
INSERT INTO bou_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Akini, Yesu khekuwaanduwa wekugombekacho nee amwamba yuda mkuu wa Nyumba ya kuvikia Wayahudi, “Usekuogoha, wee zumiiya du.” ");
INSERT INTO bou_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu khekukunda mntu yoyose amtongee, iya Petulo na Yakobo na Yohana nduguye Yakobo. ");
INSERT INTO bou_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wekubuaho mwe nyumba ya Yailo, Yesu ne aona wantu waketambikatambika asi wakiiya na kutoa bwaimbo. ");
INSERT INTO bou_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ne engia gati, na kugombeka, “Kwa mbwai mwetambikatambika na kuiiya? Mndee khekuuya na nyuma, kagona.” ");
INSERT INTO bou_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Akini wowo wakamseka. Aho akawalavya wose chongoi, akamdoa tati yakwe na mami yakwe da yuda mwana na wahina wakwe watatu, wakengia mwe chumba wekumwikacho yuda mndee. ");
INSERT INTO bou_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naho akamtoza mkono, na kumwamba, “Talita, komu,” Mana yakwe “Mndee mdodo nakwamba enuka!” ");
INSERT INTO bou_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ahoaho mndee yuda akagooka, na kuvoka kuita. Mndee yuda ne kawa na myaka kumi dimwe na miidi. Aho wantu wakahondomaa muno kwa dekulawiado. ");
INSERT INTO bou_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Akini Yesu akawaemeza wasekugombeka kwa mntu yoyose ida mbui. Naho akawamba wamwekhe khande yuda mndee. ");
INSERT INTO bou_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu akalawa hada, akaita mwe mzi wakwe na wahina wakwe ne wamtongea. ");
INSERT INTO bou_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Msi wa Kuhumwiiza wekubuaho, akavoka kuhinya mwe Nyumba ya kuvikia Wayahudi. Wantu wangi wekumtegeezao wakahondomaa wakauza, “Uwo mbui izi kazilavia kuhi? Ni udaho uhi ekwekhigwao? Naho agosoa viivihi tangio izi? ");
INSERT INTO bou_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uwo uyu khii yuda seemaa, mwana Maliamu, wanduguze ni Yakobo na Yusufu na Yuda na Simoni? Na maumbuze wekaa ahaaha hetu?” Wantu ne wawa na matumatu nae. ");
INSERT INTO bou_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu akawamba, “Muoni wa Muungu akundwa kia hantu iya mwe si yakwe na kwa wanduguze na kaya kwakwe khakundwa.” ");
INSERT INTO bou_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Khekugosoa tangio zozose hada, iya akaika mikono kwa watamu wacheche, ne awahonya. ");
INSERT INTO bou_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu akahondomaa muno, kwaviya wantu khawokuzumiia. Naho Yesu neaita mizi ya hehi, akahinya wantu. ");
INSERT INTO bou_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akawetanga wada wahina kumi dimwe na waidi, akavoka kuwaagiia waidiwaidi. Ne awekha udaho wa kuguusa mazaiko. ");
INSERT INTO bou_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akagombeka, “Msekudoa kintu chochose mwe ntambo yenu iya ngoda du. Msekudoa khande, mkwiji wala hea. ");
INSERT INTO bou_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Vaani sabana, akini mwesekudoa gwanda tuhu.” ");
INSERT INTO bou_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Vituhu akawamba, “Kaya yoyose mwendayo mhokewe ekaani umo na msekusamasama kuita kaya tuhu hadi mwendaho mhauke mwe mzi uwo. ");
INSERT INTO bou_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hantu hohose wantu wendawo wawaemee kuwahokea au kuwategeeza, haukeni aho na kung'unteni sanga ya mwe miundi yenu inga hinyo kwao.” ");
INSERT INTO bou_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Awo wakahauka na kuwabiikia wantu wamhitukie Muungu. ");
INSERT INTO bou_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wakaguusa mazaiko mangi na kuwasisa mavuta ya mizaituni watamu wangi na kuwahonya. ");
INSERT INTO bou_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naho, Seuta Helode ekutegeezaho mbui izi kwaviya togoo za Yesu ne ziambazwa kia hantu. Wantu watuhu ne wakagombeka, “Yohana mbatiiza kayuyuka kulawa mwe wekufao, ne mana udaho wa kugosoa vihii wagosoa ndima.” ");
INSERT INTO bou_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wantu watuhu wakagombeka, “Uyu ni Eliya” Na wantu watuhu ne wagombeka, “Uyu ni Muoni wa Muungu inga yumwe wa Waoni wa Muungu wa kae.” ");
INSERT INTO bou_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Akini Helode ekusikiaho akagombeka, “Uyu ni Yohana mbatiiza! Nekumsengae mtwi, tambe kayuyuka!” ");
INSERT INTO bou_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aho bosi Helode mwenye kakunda Yohana Mbatiiza agwiwe na aikwe mwe kifungo. Helode katenda ivyo kwaajii ya Helodia, mvyee uyo ne nimkaza Filipo, nduguye Helode. ");
INSERT INTO bou_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwaviya Yohana ne kamwamba Helode, “Khio vitana kumdoa mkaza nduguyo.” ");
INSERT INTO bou_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aho Helodiya akakimwa muno na Yohana na akakunda kumkoma, akini khekudaha kumkoma. ");
INSERT INTO bou_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode ne akamuogoha Yohana kwaviya kamanya Yohana ni mntu mtana na yedi, ivyo akamkindia asekukomwa. Helode kakundisa kumtegeeza Yohana, akini ekumtegezaho, akahungumia muno mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Msi umwe Helodia akapata phasi kisingi cha sikukhuu ya khumbuso da kuvyaigwa kwakwe Helode. Helode kawagosoeya ntafuno wadaa waongoezi na wakuu wa mahindoo hamwe na wagookezi wose wa Galilaya. ");
INSERT INTO bou_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aho mwana kivyee wa Helodiya akengia akavina, akawatamiza muno Helode na wageni wakwe. Seuta Helode akamwamba yuda mndee, “Niombeza dodose ukundado, nami nenda nikwekhe.” ");
INSERT INTO bou_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naho akamwahiiya, “Chochose wendacho uniombeze, nenda nikwekhe hata ntii ya useuta wangu.” ");
INSERT INTO bou_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aho uyo mndee akalawa kumuuza mami yakwe, “Niombeze mbwai?” Mmaa yakwe akamtambaisa, “Ombeza mtwi wa Yohana Mbatiiza.” ");
INSERT INTO bou_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yuda mndee akamuuiya seuta kinyionyio na kumwombeza, “Nakunda unekhe isasa mtwi wa Yohana Mbatiiza mwe chano.” ");
INSERT INTO bou_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Seuta akoona usungu, akini kwaviya ya kuaha kwakwe na kwaviya ya wageni wose wekuwao mwe ntafuno, khekudaha kumuemeea. ");
INSERT INTO bou_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aho seuta akamwagiiya asikai kueta mtwi wa Yohana Mbatiiza. Asikai akaita akamdumua mtwi Yohana Mbatiiza. ");
INSERT INTO bou_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yuda asikali akaueta mtwi mwe chano, akamwekha yuda mndee, na mndee naye akamwekha mami yakwe. ");
INSERT INTO bou_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wahina wa Yohana Mbatiiza wekusikiaho mbui ida, ne waita wakaudoa mwii wakwe wakaugea mwe mbia. ");
INSERT INTO bou_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wada waagiiwa wakauya wakakintana hemeso ya Yesu na kumwamba yose wekugosoayo na kuhinya. ");
INSERT INTO bou_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu akawamba, “Titeni swie ikedu kwesiho wantu mkahumwiize” kagombeka ivyo kwaviya ne hana wantu wangi, wekuwao wabua aho na kuhauka hata Yesu na wahina wakwe khawokudaha kuwa na phasi ya kuda khande. ");
INSERT INTO bou_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aho wakahauka wowodu kwa ngaawa na kuita kwesiho wantu. ");
INSERT INTO bou_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Akini wantu wangi wakawaoona wakaita naho wakawamanya. Ne wantu kulawa kia mzi wakaguuka na kuongoa kubua ekuako aita Yesu na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ekuseeaho mwe ngaawa, ne aona zumwezumwe da wantu, akawafiia mbazi, kwaviya ne wawa inga ngoto wesao kuwa na muiisi. Akavoka kuwahinya mbui nyingi na nyingi. ");
INSERT INTO bou_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wahina wakwe wakambasa Yesu wakamwamba, “Hantu aha nihe kiwawe na zua daswa. ");
INSERT INTO bou_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wabade wantu awa waite mwe minda na mwe mizi ya hehi, wakague khande.” ");
INSERT INTO bou_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Akini Yesu akawatambaisa, “Wekheni nywie khande.” Ne wamuuza, “Khuona inga tendatikundigwe tiwe na mshahaa wa mntu wa miongo minane idahe kugua mabumunda na kuwekha wantu wade?” ");
INSERT INTO bou_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu akawauza, “Mna mabumunda mangahi? Hitani mkakauwe.” Wekumanyaho, wakamwamba, “Kuna mabumunda mashano na samaki waidi.” ");
INSERT INTO bou_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aho Yesu akagombeka na wahina wakwe wawaike wantu vizumwezumwe na kwekaa asi he mani. ");
INSERT INTO bou_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne wekaa mwe vizumwezumwe vya wantu makumi kumi na vizumwezumwe vya makumi mashano. ");
INSERT INTO bou_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naho Yesu akadoa yada mabumunda mashano na wada samaki waidi, akakauwa uwanga kwa Muungu, akavijaiya, ne abendua yada mabumunda na kuwekha wahina wakwe wawapangie wantu. Na wada samaki waidi wawapangie wose. ");
INSERT INTO bou_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wantu wose ne wada na kweguta. ");
INSERT INTO bou_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wahina wakwe wakadodoa phugutio za vyekusigaavyo vya mabumunda na samaki wakamemeeza ngahu kumi dimwe na mbii. ");
INSERT INTO bou_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wekudao ida mikate ne wawa wagosi elufu shano. ");
INSERT INTO bou_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ahoaho Yesu akawamba wahina wakwe wakwee mwe ngaawa wamuongoee kuita Betisaida, phande ya kaidi ya tondoo da mazi, kisingi yee aaga zumwezumwe da wantu. ");
INSERT INTO bou_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ekubindaho kuagana nao, ne aita mwe muima kuvika Muungu. ");
INSERT INTO bou_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yekubuaho guoni, ngaawa ne igatigati ya tondoo da mazi, akini Yesu ne awa ikedu mwe sanga khavu. ");
INSERT INTO bou_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aho akoona wahina wakwe mwe ngaawa wakepisha kwa kutoa makasia, kwaviya ne wakahigana na khusi. Hehi na kucha, Yesu akawabasa wahina uku enda uwanga ya mazi, akakunda kuwemboka. ");
INSERT INTO bou_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Akini wekumuonaho akenda uwanga ya mazi, ne wammamakhanya ni mzimu, wakakema. ");
INSERT INTO bou_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kwaviya wose wekumuonaho ne waogoha muno. Ahoaho Yesu akagombeka nao, “Twiiyani msekuogoha! Ni mie!” ");
INSERT INTO bou_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naho akengia mwe ngaawa wekuwamo na khusi ikatwiiya, wahina wakwe ne wahondomaa muno. ");
INSERT INTO bou_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kwaviya ne khawazati kumanya mana ya yada mabumunda wekudao wantu elufu shano. ");
INSERT INTO bou_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wakemboka phande ya kaidi ya tondoo da mazi wakabua mwe si ya Genezaleti, aho ne wagea kigomogomo. ");
INSERT INTO bou_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wekulawaho mwe ngaawa, wantu naho wakammanya Yesu. ");
INSERT INTO bou_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naho wakaita kinyionyio mwe si yose, wakawenua watamu mwe vilago vyao ne wamwegaiya Yesu, hohose hada wekutegeezaho yuaho. ");
INSERT INTO bou_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kia hantu Yesu ekubuaho, mwe mizi na mwe minda, wantu ne wawaika watamu wao wazoi, Wakamhembeeza wadon'te du msao wa nguo yakwe, na wose wekumdontao nee wahona. ");
INSERT INTO bou_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wamwe wa Mafalisayo na Wahinyi wa Miko wekuwao walawa Yelusalemu ne wakintana hemeso ya Yesu. ");
INSERT INTO bou_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wakoona wamwe wa wahina wa Yesu wada khande kwa mikono yao kwesiho kusunta inga ikundingwavyo na Miko ya Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafalisayo na Wayahudi wose watozeeza mahinyo wekuyahokeayo kwa wadaa wao, khawada khande yoyose hadi wasunte mikono yao vitana kubua mwe kiko. ");
INSERT INTO bou_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Naho khawada chochose kulawa gwiiyo hadi wasunte mikono. Viyaviya watozeeza mahinyo matuhu wekuhokeayo kuvokea kae, inga viya wasuntavyo vikombe na nyungu na via vya shaba. ");
INSERT INTO bou_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aho wada Mafalisayo na Wahinyi wa Miko wakamuuza Yesu, “Kwa mbwai wahina wako khawatongea mahinyo ya wadaa? Iya wada khande kwesiho kusunta mikono?” ");
INSERT INTO bou_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu akawatambaisa, “Muoni Isaya ne koona kwei kwenu nywie wabakha inga viya ekugondavyo, Muungu kagombeka, ‘Wantu awa wanitegeeza mwe miomo yao, iya mioyo yao ihae na mie. ");
INSERT INTO bou_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naho wanivikia buwe, kwaviya mbui wazihinyazo ni miagiiyo ya kiuntudu wakigombeka ayo ni mahinyo ya Muungu!’ ");
INSERT INTO bou_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nyie mwabada Miko ya Muungu na kutongea miagiiyo ya wantu.” ");
INSERT INTO bou_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu akatendesa kugombeka, “Nyie mwadaha kuiemea kwa unyanyi Miko ya Muungu kwaajii ya kutongea mahinyo yenu! ");
INSERT INTO bou_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mana Musa kagombeka, ‘Wategeezeni tati zenu na mami zenu naho mntu yoyose amdumuae tati yakwe au mami yakwe yakundigwa akomwe.’ ");
INSERT INTO bou_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Akini nywie mwahinya, inga mntu mwenacho kintu kidahacho kumwambiiza tati yakwe au mami yakwe, akini akamba kintu icho ni ‘Kolobani’ yani ni funge kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Naho kheshuutiza vituhu kumwambiiza tati yakwe au mami yakwe. ");
INSERT INTO bou_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ivi ne mbeavyo mbui za Muungu, kwaajii ya mahinyo mhokezanayo. Naho mwagosoa mbui nyingi inga izi.” ");
INSERT INTO bou_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu ne awetanga vituhu zumwezumwe da wantu, akawamba, “Nitegeezani nyose, mmanye.” ");
INSERT INTO bou_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khakuna kintu chengiacho kwa mntu kidahacho kumtenda asekukundigwa na Muungu, akini kilawacho ndani ya mntu nee kimtendacho mntu asekukudigwa na Muungu. ");
INSERT INTO bou_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mwenye magutwi ya kutegeeza na ategeeze! ");
INSERT INTO bou_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ekubadaho zumwezumwe da wantu na kwengia kaya, wahina wakwe wakamuuza mana ya msimo uwo. ");
INSERT INTO bou_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu akagombeka, “Hata nywie khamna umanyi? Khammanya kintu kimwengiacho mntu kulawa chongoi khakidaha kumtenda mntu asekukudigwa hemeso ya Muungu, ");
INSERT INTO bou_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwaviya khachekumwegia mwe moyo wakwe iya mwe ifu, naho chalawa chongoi mwe mwii.” Kwa kugombeka ivyo, Yesu kauusu khande zose ziigwe. ");
INSERT INTO bou_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akatendesa kugombeka, “Kimlawacho mntu ndani yakwe ne kimtendacho asekukudigwa hemeso ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwaviya mwe moyo wa mntu kwalawa mbui zesazo kutama, na ukianga na ubavi na ukomaji, ");
INSERT INTO bou_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na kianga na choyo na ubanasi na utiizi na umeo wa mai na kinyuu na kubea na kibui na ubahau. ");
INSERT INTO bou_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mbui zose izo zalawa mwe moyo wa mntu na kumtenda asekukudigwa hemeso ya Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu akahauka aho na kuita mwe si ya hehi na mzi wa Tilo. Uko akengia mwe kaya mwenga na khekukunda mntu yoyose ammanye, akini khekudaha kwefisa. ");
INSERT INTO bou_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aho mvyee yumwe kawa na mwanaye wa kindee mwekuwa na zaiko, ekutegezavyo mbui za Yesu akeza hada na aketambika asi hemeso ya Yesu. ");
INSERT INTO bou_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mvyee yuda khekuwa Myahudi, iya nee ni mwenyezi wa Silofoinike mwe si ya Siliya. Aho akamheembeza Yesu amlavye mazaiko yuda mwanawe. ");
INSERT INTO bou_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Akini Yesu akamtambaisa, “Eka wana wegute, kwaviya khio vitana kudoa khande ya wana na kuwasia makui.” ");
INSERT INTO bou_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yuda mvyee ne amtambaisa, “Zumbe” ni vitana, “Akini hata makui nayo yeaho asi ya meza yadaha kudodoa phugutio za khande vyekusigazwavyo.” ");
INSERT INTO bou_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naho Yesu ne agombeka, “Kwaajii ya kutambaisa ivyo, hita kaya, naho wenda umbwiie mwanao zaiko dimlawa!” ");
INSERT INTO bou_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aho yuda mvyee akauya kaya na kumbwiia mwanawe kagona mwe usazi na dia zaiko dimlawa kae. ");
INSERT INTO bou_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ne alawa mwe mihaka ya mzi wa Tilo akemboka gatigati ya Sidoni akaita Dekapoli mana yakwe si ya mizi kumi, kwembokea tondoo da mazi ya Galilaya. ");
INSERT INTO bou_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aho wakamwegaiiya mwenye kisita kikai na kiziba, wakamheembeza amuiikie mikono. ");
INSERT INTO bou_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu akamuusa mwe dia zumwezumwe da wantu, akamgea vyaa mwe magutwi ya yuda mntu, ne aswa ovu mwe vyaa vyakwe na kumdonta mwe ulimi wakwe. ");
INSERT INTO bou_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naho akakauwa uwanga, akatoa mhezemuko akamwamba, “Efata,” Mana yakwe, “Vuguka.” ");
INSERT INTO bou_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahoaho magutwi yakwe yakavuguka na ulimi wakwe ukaegea na kuvoka kutamwiiya vitana. ");
INSERT INTO bou_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ne awaemeza wantu wasekumwamba mntu yoyose mbui izo. Akini ekuwaemezavyo ne watendesaho kuziambaza mbui izo. ");
INSERT INTO bou_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wantu wose wakahondomaa muno, wakagombeka, “Kagosoa yose matana kawajaiya viziba kutegeeza na mabubu kudaha kugombeka!” ");
INSERT INTO bou_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kisingi icho, zumwezumwe da wantu dikakintana vituhu, na khawekuwa na khande. Aho, Yesu akawetanga wahina wakwe akawamba, ");
INSERT INTO bou_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nawafiiya mbazi wantu awa kwaviya wawa na mie kwa misi mitatu, naho khawana khande. ");
INSERT INTO bou_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nikawabada waite kaya kwesaho kuda wenda wagwe msae siai, kwaviya watuhu walawa hae.” ");
INSERT INTO bou_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wahina wakwe wakamuuza, “Hanu he kiwawe tendatikundigwe tipatie kuhi mabumunda ya kuwegusa wantu wose awa?” ");
INSERT INTO bou_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu akawauza, “Mna mabumunda mangahi?” Wakamtambaisa, “Tina mabumunda mfungate.” ");
INSERT INTO bou_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aho Yesu akawamba wantu wekae asi, akayadoa yada mabumunda mfungate, akamtogoa Muungu, akayabendua yada mabumunda, akawekha wahina wakwe wawapangie wantu, ne wawapangia. ");
INSERT INTO bou_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naho kuwa na samaki wacheche. Yesu akamtogoa Muungu, na kuwekha wahina wakwe wawapangie wantu viyaviya. ");
INSERT INTO bou_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wantu wose wakada, na kweguta. Ne wahina wakwe wakadodoa phugutio za khande za vyekusigaavyo na kumemeeza ngahu mfungate. ");
INSERT INTO bou_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naho wekudao khande wabua wantu elufu nne, Yesu akabadana nao. ");
INSERT INTO bou_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ahoaho akakwea ngaawa hamwe na wahina wakwe na kuita mzi wa Dalumanuta. ");
INSERT INTO bou_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wamwe wa Mafalisayo wakambasa Yesu na kuvoka kutambaisana nae. Wakamgeeza, wakakunda agosee tangio koonesha kuwa udaho wakwe walawa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Akini Yesu akoona usungu mwe moyo wakwe akagombeka, “Ni kwambwai wantu wa uvyazi unu wakunda tangio? Kwei nawamba khahana tangio zozose zendazo mwekhigwe uvyazi unu.” ");
INSERT INTO bou_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aho akawabada na akakwea vituhu ngaawa, akavoka ntambo ya kuita phande ya kaidi ya mazimshindo. ");
INSERT INTO bou_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wahina wakwe wajaa kudoa mabumunda ya kuiganyia. Ne wawa na bumunda dimwe mwe ngaawa. ");
INSERT INTO bou_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu akawaemeza, “Kauwani muno, na mwekae hae na hamila ya Mafalisayo na hamila ya Helode.” ");
INSERT INTO bou_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wahina wakavoka kuuzana, “Agombeka ivi kwaviya khatina mabumunda.” ");
INSERT INTO bou_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kamanya ayo ne awamba, “Kwambwai mwauzana mbui ya kwesekupata mabumunda? Nyie khammanya au khamna umanyi? Kwambwai mioyo yenu yatoga? ");
INSERT INTO bou_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mna meso akini khamdaha kuona? Mna magutwi akini khamdaha kutegeeza? Khambukhua? ");
INSERT INTO bou_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kisingi kiya nikubenduaho yada mabumunda mashano na kuwekha wantu elufu shano? Mdodoa ngahu nyingahi za phugutio za khade za vyekusigaavyo?” Wahina wakatambaisa, “Ni ngahu kumi dimwe na viidi.” ");
INSERT INTO bou_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu akawauza, “Na hada nikubenduao yada mabumunda mfungate na kuwekha wantu elufu nne wakada, mdodoa ngahu nyingahi za phugutio za khande za vyekusigaavyo?” Ne wamtambaisa, “Ni ngahu mfungate.” ");
INSERT INTO bou_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aho akawauza, “Khamzati kumanya?” ");
INSERT INTO bou_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu akabua mzi wetangwao Betisaida hamwe na wahinyi wakwe. Uko wantu wakamwegaiya mntu tuntu, wakamheembeza amdonte. ");
INSERT INTO bou_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu akamtoza mkono yuda tuntu na kumlavya chongoi ya mzi. Akamswiia ovu mwe meso, akamwiikia mikono kwe meso na kumuuza, “Wadaha koona chochose?” ");
INSERT INTO bou_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yuda tuntu akakauwa na kugombeka, “Naona wantu wakenda inga miti yendayo.” ");
INSERT INTO bou_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naho Yesu akamwiikia vituhu mikono yakwe mwe meso ya yuda tuntu, naye yuda mntu akafua meso, ne meso yakavuguka, koona kwakwe kukamuuiya akoona kia kintu pwii. ");
INSERT INTO bou_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu akamwamba aite kaya na kumuemeza, “Naho usekwengia mwe mzi.” ");
INSERT INTO bou_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naho Yesu na wahina wakwe wakaita mwe mizi ya hehi na Kaisalia Filipi. Wekuwaho siai Yesu akawauza wahina wakwe, “Wantu wamba mie nndai?” ");
INSERT INTO bou_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wakamtambaisa, “Watuhu wamba wee ni Yohana mbatiiza, watuhu wamba u Eliya na watuhu wamba ni yumwe wa Waoni wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu akawauza, “Na nywie mwamba mie nndai?” Petulo akagombeka, “Wee ne Klistu.” ");
INSERT INTO bou_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Naho Yesu akawaemeza wasekugombeka kwa mntu yoyose mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naho Yesu akavoka kuwahinya wahina wakwe, nlazima Mwana wa Mntu ekhigwe usuumizi mwingi na kuemewa na wadaa na Waviki wakuu na Wahinyi wa Miko. Enda akomwe, akini mwe msi wa ntatu enda ayuyuke. ");
INSERT INTO bou_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kagombeka mbui ida pwiii. Aho Petulo akamdoa Yesu khandani, na kuvoka kumuakia. ");
INSERT INTO bou_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Akini Yesu akahituka na kuwakauwa wahina wakwe, akamuakia Petulo na akamba, “Hauke hemeso yangu Ibiisi wee! Umamakhanyo wako khio wa Muungu iya ni wa kiuntu.” ");
INSERT INTO bou_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naho akawetanga zumwezumwe da wantu hamwe na wahina wakwe akawamba, “Inga mntu yoyose akakunda kunitongea nlazima eemee mwenye, enue mhamba wakwe anitongee. ");
INSERT INTO bou_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwaviya mntu yoyose akundae kuohoa ugima wakwe mwenye enda awaze, akini mntu mwaza ugima wakwe kwaajii ya mie na kwaajii ya Mbui Yedi za Muungu enda ayaohoe. ");
INSERT INTO bou_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mntu enda ekhigwe mbwai inga akekhigwa vintu vyose vya inusi na kuwaza ugima wakwe? ");
INSERT INTO bou_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Khahana kintu wendacho ukilavye ili uupate ugima? ");
INSERT INTO bou_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mntu yoyose mwenda anionee soni mie na mahinyo yangu, mwe uvyazi unu wa kianga na cha mavigaviga, Mwana wa Mntu enda amuonee soni mntu uyo, kisingi endaho auye he ukuu wa Tati yakwe hamwe na wandima wa Muungu wa uwanga.” ");
INSERT INTO bou_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akatendesa kugombeka, “Nawamba kwei, kuna wantu watuhu aha khawana wauye na nyuma, hadi wendaho wauone Useuta wa Muungu ukeza kwa udaho.” ");
INSERT INTO bou_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yekwembokaho misi mtandatu, Yesu akawadoa Petulo na Yakobo na Yohana, akaita nao uwanga ya muima ulehao kwesaho wantu. Uko Yesu akahituka cheni hemeso yao. ");
INSERT INTO bou_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nguo zakwe zikang'aa pee, ung'ao wakwe khahana mnyukuaji yoyose mwe inusi mdaha kunyukuua nguo zing'ae inga izo. ");
INSERT INTO bou_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naho Eliya na Musa wakalawiia wakatamwiiya na Yesu. ");
INSERT INTO bou_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo akamwamba Yesu, “Mhinyi, ni vitana sie tiwe aha. Ebae tikazenga makumbi matatu, dimwe dako, dimwe da Musa na dimwe da Eliya.” ");
INSERT INTO bou_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo na weziwe wakaogoha muno hata wasekumanya da kugombeka. ");
INSERT INTO bou_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naho kukalawia zunde dikawagubika, na mgutio ukategeezeka kulawa mwe dia zunde, “Uyu ne Mwanangu wa kigosi nimkundaye mtegeezeni.” ");
INSERT INTO bou_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ahoaho wahina wakakaua vituhu, akini khawekumwona mntu mtuhu iya Yesu ikedu. ");
INSERT INTO bou_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aho wekuwaho wakaseea kulawa kwe muima, Yesu akawaemeza, wasekumwamba mntu mbui zozose wekuzionazo, adi aho Mwana wa Mntu endaho ayuyuke. ");
INSERT INTO bou_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aho wakatoza miagiiyo iyo, akini wakauzana, mana ya kuyuyuka ni mbwai? ");
INSERT INTO bou_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wahina wakamuuza Yesu, “Kwambwai Wahinyi wa Miko wagombeka, Eliya akundigwa avoke kweza?” ");
INSERT INTO bou_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu akawatambaisa, “Ni kwei, Eliya avoke kweza na kuika mbui zose vitana. Ata ivyo kwambwai iandikwa mwe Maandiko ya Mungu, Mwana wa Mntu enda asumizwe muno na kubewa? ");
INSERT INTO bou_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Akini nawamba Eliya keza kae naho wakamgosoa wakundavyo inga Maandiko yekugombekavyo kwaajii yakwe.” ");
INSERT INTO bou_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Naho wekuwabwiaho wada wahina watuhu, ne waona zumwezumwe kuu da wantu diwaikia bunga. Na wamwe wa Wahinyi wa Miko watambaisana nawo. ");
INSERT INTO bou_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ahoaho wada wantu wekumwonaho Yesu, wakahondomaa muno, wakamguukia na kumuugusa. ");
INSERT INTO bou_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu akawauza wahina wakwe, “Mwatambaisana mbwai?” ");
INSERT INTO bou_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aho mntu yumwe mwe dia zumwezumwe akagombeka, “Mhinyi khimueta mwanangu kwaviya ana mazaiko yekumgosoayo asekudaha kutamwiiya. ");
INSERT INTO bou_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naho zaiko ido dikamkwea mwanangu damgwisa asi na kumtenda alawe fuo mwe kanwa, na akeuma meno naho akakama mwii wose. Kiwamba wahina wako walavye ido zaiko, akini khawekudaha.” ");
INSERT INTO bou_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu akagombeka, “Nywie kivyazi chesacho kuzumiiya! Nenda nekae na nywie hata ini? Nenda niwazizimize hata ini? Mweeteni hangu!” ");
INSERT INTO bou_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naho wakamweta yuda mbwanga kwa Yesu. Na dia zaiko dekumuonaho Yesu dikamsingisa, yuda mbwanga akagwa asi, akagaagaa ne alawa fuo mwe kanwa. ");
INSERT INTO bou_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu akamuuza tate ya yuda mbwanga, “Mazaiko aya yamvoka ini?” Nee amtambaisa, “Kuvokea udodo wakwe. ");
INSERT INTO bou_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maa zose zaiko idi damgwisa mwe moto na mwe mazi, ili dimkome. Inga ukadaha tifiiye mbazi na kutiambiza!” ");
INSERT INTO bou_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akagombeka, “Ati ukadaha, Mbui zose zadahika kwa yuda azumiiae.” ");
INSERT INTO bou_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aho tati yakwe yuda mbwanga akatoa vuzo kwa mgutio mkuu, na akamba “Nakuzumiia, niambiza kwesekudaha kuzumiiya.” ");
INSERT INTO bou_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu ekuonaho zumwezumwe da wantu dagenyea hemeso yakwe, ne amwamba dia zaiko, “Wee zaiko umgosoae mwana uyu asekudaha kugombeka na kutenda kiziba, nakwamba mlawe mbwanga uyu usekumuuwiya vituhu!” ");
INSERT INTO bou_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aho zaiko dia ne dagutia na kumgea ugwa mtwi na kumgwisa yuda mbwanga asi na kumlawa. Yuda mbwanga akekaa inga kimba hata watuhu ne wamba, “Kauya na nyuma!” ");
INSERT INTO bou_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Akini Yesu akamtoza mkono yuda mbwanga, akamwenua, ne agooka. ");
INSERT INTO bou_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aho, Yesu akengia kaya, wahina wakwe wakamuuza wekuwaho ikedu, “Kwambwai swie khatekudaha kumlavya yuda zaiko?” ");
INSERT INTO bou_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu akawamba, “Zaiko inga idi khadidaha kulawa, kwesiho kuvika.” ");
INSERT INTO bou_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wahina wakwe walawa hada, ne waita wakembokea Galilaya, Yesu khekukunda wantu wowose wamanye weiho, ");
INSERT INTO bou_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwaviya ne awahinya wahina wakwe, akawamba, “Mwana wa Mntu enda egalwe kwa wantu wendao wamkome. Akini bada ya msi wa ntatu enda ayuyuke.” ");
INSERT INTO bou_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Akini wahina wakwe khawokumanya mahinyo yada na wakaogoha kumuuza. ");
INSERT INTO bou_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naho wakabua Kapelinaumu, ekuaho kaya, Yesu akawauza wahina wakwe, “Ne mkatambaisana mbwai mwe sia?” ");
INSERT INTO bou_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Akini khawokuandua, kwaviya ne wakatambaisana wakamba nndai mkuu gatigati yao. ");
INSERT INTO bou_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu akekaa asi, akawetanga wada wahina wakwe kumi dimwe na waidi na kuwamba, “Mntu akakunda awe mgookezi akundigwa awe wa kisikizi na mndima wa wose.” ");
INSERT INTO bou_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naho akamdoa mwana mdodo akamgoosa gatigati yao, akamuumbatia na kuwamba, ");
INSERT INTO bou_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mntu yoyose amhokeae mwana inga uyu kwa zina dangu anihokea mie, naho mntu anihokeaye mie, khanihokea miedu iya amhokeea yuda mwekuniagiiya.” ");
INSERT INTO bou_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana akamwamba Yesu, “Mhinyi, timuona mntu yumwe akalavya zaiko kwazina dako, nee tageeza kumweemeza kwaviya khayuko hamwe na swie.” ");
INSERT INTO bou_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Akini Yesu akagombeka, “Msekumweemeza kwaviya khahana mntu agosoae tangio kwa zina dangu, na ahoaho akagombeka ufyaimu wa mbui zangu.” ");
INSERT INTO bou_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwaviya mntu yoyose esaye kuhigana nasi, yu hamwe na swie. ");
INSERT INTO bou_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nagombeka kwei mntu yoyose endae amyekhe kikombe cha mazi ya kudomea kwaviya nywie ni wantu wa Klistu, na kwei enda ahokee funge. ");
INSERT INTO bou_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mntu yoyose endae amkindie yumwe wa awa wadodo wanizumiiyao agosoe mavigaviga ni ebae kwa mntu uyo azongomezwe he singo yakwe iwe kuu da kubundugia na kutambikwa mwe mazimshindo. ");
INSERT INTO bou_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mkono wako ukakutenda kugosoa mavigaviga, uusenge. Ebae wengie mwe ugima kwesaho mkono umwe, kusima na mikono miidi na kwengia mwe moto wa misi yose wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Umo minyula yakwe khaifa na moto wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na muundi wako ukakutenda kugosoa mavigaviga uusenge! Ebae kwengia mwe ugima kwesaho muundi umwe kusima na miundi yose miidi na kutambikwa mwe moto wa kae na kae. ");
INSERT INTO bou_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uko mafunyo yakwe khayafa na moto wa misi yose wesao kukomeka. ");
INSERT INTO bou_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ziso dako dikakutenda ugosoe mavigaviga diuse. Ebae kwengia mwe Uzumbe wa Muungu na ziso dimwe kusima na meso yose maidi na kutambwikwa mwe moto wa kae na kae. ");
INSERT INTO bou_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Minyula yakwe khaifa na moto wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kwaviya kiya yumwe enda agewe munyu kwa moto. ");
INSERT INTO bou_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu ni mtana akini inga ikabanika inda ikweezwe na mbwai? Muwe na munyu mwe mioyo yenu na kwekaisa kwevana gatigati yenu.” ");
INSERT INTO bou_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu akalawa hada na kuita si ya Uyahudi, akadumua zigizigi da mazi da wa Yolodani. Zumwezumwe da wantu dikambasa vituhu, ne awahinya vituhu inga viya agosoavyo. ");
INSERT INTO bou_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aho Mafalisayo watuhu wakambasa na kumuuza kwa kumgeeza wakagombeka, “Miko yamuekea mgosi kumbada mkaziwe?” ");
INSERT INTO bou_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akawatambaisa kwa kuwauza. “Musa kawekha mwiko wani?” ");
INSERT INTO bou_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wowo wakagombeka, “Musa katiagiiya kuwa mgosi aluusiwa kuandika bauwa ya kumbada mkaziwe.” ");
INSERT INTO bou_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu akawamba, “Musa kagonda mwiko uwo, kwaajii ya kutoga kwa mioyo yenu.” ");
INSERT INTO bou_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Akini kuvokea kugosolwa inusi, Muungu kaumba mgosi na mvyee. ");
INSERT INTO bou_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ivyo mgosi enda ambade tati yakwe na mami yakwe, enda awe hamwe na mkaziwe. ");
INSERT INTO bou_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Na awa waidi wenda wawe mwii umwe. Kwaivyo wowo khio waidi vituhu iya mwii umwe. ");
INSERT INTO bou_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Naho, ekukintanisacho Muungu, mntu asekukibahua. ");
INSERT INTO bou_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wekwengiaho kaya vituhu, wahina wakwe ne wamuuza Yesu mbui ida. ");
INSERT INTO bou_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akawamba, “Mgosi yoyose ambadae mkaziwe na kutegua mvyee mtuhu, agosoa kianga. ");
INSERT INTO bou_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mvyee naye akambada mgosi yakwe na kutegulwa na mgosi mtuhu, yee nae agosoa kianga.” ");
INSERT INTO bou_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wantu wakamwetea Yesu wana wadodo awadonte, akini wahina wakwe wakawaemeza wantu wada. ");
INSERT INTO bou_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ekuonaho ivyo akakimwa, akawamba wahina wakwe, “Waekeeni wana wadodo weze hangu, naho msekuwakindia, kwaviya Uzumbe wa Muungu ni kwa wantu inga awa wana wadodo. ");
INSERT INTO bou_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nawamba kwei, mntu yoyose mwesekuuhokea Useuta wa Muungu inga mwana mdodo, khana engie umo.” ");
INSERT INTO bou_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Akawahokea wana wada akawaumbatia na kuwaikia mikono kwa kuwajaiya. ");
INSERT INTO bou_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ekuvokaho ntambo yakwe, mntu yumwe nee amguukia, akakin'ta mavindi hemeso yakwe, akamuuza, “Mhinyi yedi, nitende viivihi nidahe kuhokea ugima wa misi yose kwesiho kisiikizi?” ");
INSERT INTO bou_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu akamtambaisa, “Kwambwai wanetanga yedi? Khahana mntu yedi iya Muungu ikedu. ");
INSERT INTO bou_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Miko waimanya, ‘Usekuwa mkianga, Usekukoma, Usekubawa, Usekugombeka uhonko, Usekutiiya Wategeeze tati yako na mami yako.’” ");
INSERT INTO bou_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nee amtambaisa, “Mhinyi, ayo yose khiyatozeeza kuvokea udodo wangu.” ");
INSERT INTO bou_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu akamkauwa akamkundisa akamwamba, “Kuhungukiwa na kintu kimwe. Hita ukatage vyose wenavyo navyo uwekhe hea wakiwa, nawe wenda uwe na utajii mwingi uwanga kwa Muungu naho unibase.” ");
INSERT INTO bou_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ekutegeezavyo ayo, ne agumia, na kuhauka kwa usungu, kwaviya ne kawa na mai nyingi. ");
INSERT INTO bou_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu akamagaza magaza kia phande na kuwamba wahina wakwe, “Yenda iwe vyatoga kwa mwenye mai kwengia mwe Useuta wa Muungu!” ");
INSERT INTO bou_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wahina wakwe wakahondomaa kwa ida mbui, akini Yesu akawamba vituhu, “Wanangu, vyatoga muno kwa wenye mai kwengia mwe Useuta wa Muungu! ");
INSERT INTO bou_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vyadahika ng'ombe kwengia mwe ntundu ya singano iya khaidaika kwa mntu mwe mai kwengia kwe Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wahina ne wahondomaa na kuuzana, “Nndai mwenda adahae kuoholwa?” ");
INSERT INTO bou_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu akawafuiya meso na kuwamba, “Kwa wantu khavidahika, akini kwa Muungu vintu vyose vyadahika.” ");
INSERT INTO bou_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naho Petulo akamwamba, “Kauwa, tibada vyose, tikakutongea weye.” ");
INSERT INTO bou_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu akagombeka, “Nawamba kwei, kia mntu mwekubada kaya, na wanduguze wa kigosi na maumbu zakwe na mami yakwe na tati yakwe na wanawe na minda yakwe kwaajii ya mie na Mbui Zedi, ");
INSERT INTO bou_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","enda ahokee maa mia kisingi cha isasa, kaya na wanduguze wa kigosi na maumbu na mame na wana na minda hamwe na suuba. Na mwe kisingi chezacho enda ahokee ugima wa kae na kae. ");
INSERT INTO bou_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akini wantu wangi wabosi wenda wawe wa kisikizi, na wakisikizi wenda wawe wabosi.” ");
INSERT INTO bou_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Naho wawa siai kuita Yelusalemu, na Yesu ne mwekuwaongweea, wahina wakwe wakamema maatu, na wantu wekuwatongeao nee waogoha. Yesu akawadoa wada wahina kumi dimwe na waidi akavoka kuwamba mbui zendazo zimlawie. ");
INSERT INTO bou_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Tegeezani, taita Yelusalemu uko Mwana wa Mntu enda ekhiizwe kwa Waviki Wakuu na Wahinyi wa Miko wendao wamuamwiie akomwe na kumwekhiiza kwa wantu wesiho Wayahudi. ");
INSERT INTO bou_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Naho wenda wambee na kumswiia ovu na kumtoa na koto na kumkoma, akini mwe msi wa ntatu enda ayuyuke.” ");
INSERT INTO bou_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naho, Yakobo na Yohana wana wa Zebedayo, ne wambasa Yesu na kumwamba, “Mhinyi, takunda utigosoee kintu tendacho tiombeze.” ");
INSERT INTO bou_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu akawauza, “Mwonda niwagosoee mbwai?” ");
INSERT INTO bou_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ne wamtambaisa, “Hada wendaho wekae mwe kigoda chako cha ukuu cha Uzumbe, takunda tekae hamwe nawe, utigosoe kwekaa yumwe phande yako ya kumuso na mtuhu phande yako ya kuume.” ");
INSERT INTO bou_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu akawamba, “Khammanya ido mdiombezado. Mwadaha kuzizimiza kusuubikaa inga nendavyo nisuubike? Naho mwenda muwe tayali kuuya na nyuma inga nendavyo niuye na nyuma?” ");
INSERT INTO bou_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wakamtambaisa, “Tadaha” Yesu akawamba, “Suuba nendazo nipate mwendamzizimize kusuubika kwei, naho kwei mwenda muuye na nyuma inga nendavyo niuye na nyuma mie. ");
INSERT INTO bou_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Akini khidaha kusagua ni yuhi endae ekae phande ya kuume hambu kumoso kwangu. Ni Muungu ne ahiganyaye yuhi ekae phande ya kuume hambu kumoso kwa wada ekuwasaguao.” ");
INSERT INTO bou_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wada wahina watuhu kumi dimwe wekutegeezaho mbui ida wekuombezayo Yakobo na Yohana ne wakimwa. ");
INSERT INTO bou_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu akawetanga wose na kugombeka, “Mwamanya kuwa wada wamamakhanywao kuwa waongoezi wa si wawagookea wantu wao kwa mdundugo, na wakuu awo wawashuutiza wantu wao. ");
INSERT INTO bou_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Akini kwenu isekuwa ivyo, iya akundae kuwa mkuu gatigati yenu akundigwa awe mndima yenu. ");
INSERT INTO bou_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mntu yoyose akundae kuwa mwoongoezi wa wantu, akundigwa awe mndima wa wose. ");
INSERT INTO bou_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwaviya Mwana wa Mntu khekweza kugosoewa ndima, iya keza kugosoea wantu ndima na kulavya ugima wakwe kwajii ya kuohoa wantu wangi.” ");
INSERT INTO bou_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naho wakabua Yeliko, Yesu ekuwaho akahauka mwe mzi uwo na wahina wakwe hamwe na zumwezumwe da wantu, tuntu yumwe etangwaye Batimayo mwana wa Timayo ne kekaa khandakhanda ya sia akaombeza. ");
INSERT INTO bou_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Batimayo ekusikiaho Yesu Mnazaleti emboka hantu aho, ne avoka kukema, “Yesu! Mwana wa Daudi! Nifiie mbazi!” ");
INSERT INTO bou_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wantu wangi wakamwakia na kumwamba anyamae, akini ne aendeea kukema, “Mwana wa Daudi, nifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu nee kagooka na kugombeka, “Mwetangeni.” Wakamwetanga yuda tuntu, nee wamwamba, “Ekhe moyo! Gooka akwetanga.” ");
INSERT INTO bou_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akatambika gwanda dakwe, akahauka kinyinyio na kumbasa Yesu. ");
INSERT INTO bou_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ne amuuza, “Wakunda nikugosoee mbwai?” Uyo tuntu akamwamba, “Mhinyi, nakunda nione.” ");
INSERT INTO bou_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu akamwamba, “Hita kuzumiiya kwako kukuhonya.” Ahoaho akoona, akamtongea Yesu na kuita nae. ");
INSERT INTO bou_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wekuwaho wa hehi na Yelusalemu, hehi ya mizi ya Betifage na Besaniya, kwe muima wa mizaituni. Yesu akawaagiia wahina wakwe waidi. ");
INSERT INTO bou_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Akawamba, “Hitani mwe mzi wehehi yenu. Mkabua uko mwenda mbwiie mwanaphunda kazengetezwa, naho khazati kugosoewa ndima. Mchopoeni mkamweete. ");
INSERT INTO bou_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ati mntu akawauza, ‘Kwambwai mwagosoa ivi?’ Mmwambe, ‘Zumbe amkunda na enda amvuze isasa.’” ");
INSERT INTO bou_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naho, wakaita, wakambwiiya mwanaphunda siai kafungwa he uvi. Wekuwaho wamchopoa, ");
INSERT INTO bou_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wamwe wa wantu wekuwaho wagooka aho wakawauza, “Kwambwai mwamchopoa uyo mwanaphunda?” ");
INSERT INTO bou_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wahina wakawatambaisa inga viya wekwembigwavyo ni Yesu, naho wakawaeka waite. ");
INSERT INTO bou_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wakamwegaiiya Yesu yuda mwanaphunda, wakatandika nguo uwanga ya yuda mwanaphunda, Yesu ne ekaa uwanga yakwe. ");
INSERT INTO bou_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wantu wangi watandaza nguo zao siai, watuhu nao watandaza vihuto vya miti wekusengayo mwe minda kwaajii ya kumtogoa. ");
INSERT INTO bou_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wantu wose wekuongoao na wada wekuwabasao, wakalavya mgutio wakagombeka, “Zumbe atogolwe! Ajaiwe yuda ezae kwa zina da Zumbe! ");
INSERT INTO bou_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ujaiwe Uzumbe wezao wa zumbe Daudi tati yetu! Atogolwe Muungu mwe uko uwanga muno!” ");
INSERT INTO bou_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu akengia mwe mzi wa Yelusalemu, akaita mwe Nyumba ya Muungu na kukauwa kia kintu. Akini kwaviya ne diswa, akaita mwe mzi wa Besaniya hamwe na wahina wakwe kumi dimwe na waidi. ");
INSERT INTO bou_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Msi wekutongeao wekuwaho wakauya kulawa Besaniya, Yesu akaumwa nsaa. ");
INSERT INTO bou_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aho kwa hae akaona mti umanyikanao kwa zina da mtini wenye mani mangi, ne aubasa aukaue inga enda apate tini. Ekubuaho akaubwiia khauna tini iya manidu, kwaviya kisingi chakwe cha kuvyaa khakizati kubua. ");
INSERT INTO bou_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aho Yesu akawamba mtini, “Kuvokea ivyeo hadi misi zose khahana mntu endae ade tini kulawa kwako vituhu.” Na wahina wakwe wakaitegeeza mbui iyo. ");
INSERT INTO bou_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wakabua mzi wa Yelusalemu, Yesu akengia mwe Nyumba ya Muungu akavoka kuwaguusa wantu wose wekuwaho wakataga na kugua vintu. Akahitua meza za wada wabadiishao hea na kugwisa viti vya wada watagao suwa, ");
INSERT INTO bou_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","khekukunda mntu yoyose kwembokea kwe buha da Nyumba ya Muungu kudoa kintu chochose. ");
INSERT INTO bou_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naho ne awahinya, “Igondwa, ‘Nyumba yangu yetangwa Nyumba ya kuvikia kwaajii ya wantu wa si zose!’ Akini nywie muitenda phanga da wahokaji.” ");
INSERT INTO bou_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Waviki wakuu hamwe na Wahinyi wa Miko, wekutegezavyo mbui izo, wakavoka kuondeza sia ya kumkoma Yesu. Akini wakamuogoha Yesu kwaajii ya wantu wose wekuhondomaao kwa mahinyo yakwe. ");
INSERT INTO bou_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ikubuaho guoni, Yesu na wahina wakwe wakahauka mwe mzi uda. ");
INSERT INTO bou_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Keokeo da mtungaihu, wekuwaho wakemboka ne wauwona uda mtini unyaa wose hadi kwe sina. ");
INSERT INTO bou_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo akakumbuka akamwamba Yesu, “Mhinyi, kaua uda mtini wekuubadiao lazi, unyaa!” ");
INSERT INTO bou_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu akatambaisa, “Mzumieni Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nawamba kwei mntu akawamba muima unu, ng'oka uketambike mwe mazimshindo naye khana matumatu mwe moyo wakwe, akini akazumiia mbui zose agombekazo zagosoka, enda agosoewe mbui iyo. ");
INSERT INTO bou_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwaajii iyo nawagombekani, mvikaho na kuombeza kintu chochose, zumiani kwamba mkihokea, nacho chenda kiwe chenu. ");
INSERT INTO bou_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nyie mgookaho kuvika, mwekeeni kia mntu mwekukubanangia chochose, ili Tati yenu mwe uwanga awaekee masa yenu. ");
INSERT INTO bou_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Akini mwesekuwaekea watuhu, hata Tati yenu mwe uko uwanga kwa Muungu khana awaekee masa yenu. ");
INSERT INTO bou_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naho wakabua Yelusalemu vituhu, Yesu ekuwaho akaita he Nyumba ya Muungu, Waviki wakuu na Wahinyi wa Miko na wadaa waongoezi wakambasa, ");
INSERT INTO bou_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wakamuuza, “Ni kwa udaho uhi wagosoa mbui izi? Naho nndai mwekukwekha udaho wa kugosoa mbui izi?” ");
INSERT INTO bou_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu akawatambaisa, “Nendaniwauze mbui mwenga, mkanitambaisa nami nendaniwambe nagosoa aya kwa udaho wa ndai. ");
INSERT INTO bou_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nigombekani, udaho wa ubatiizo wa Yohana walawa kwa Muungu au walawa kwa wantu?” ");
INSERT INTO bou_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wakavoka kuuzana, “Tikamba walawa uko uwanga kwa Muungu endaatiuze, ‘Kwambwai khamwekumzumiia Yohana?’ ");
INSERT INTO bou_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tikamba, ‘Ulawiiya kwa wantu.’ ” Wakaogoha zumwezumwe da wantu kwaajii wose wamzumiiya Yohana kwei ni muoni wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aho wakamtambaisa Yesu, “Swie khatimanya.” Yesu akawamba, “Mie nami khinaniwambe nagosoa mbui izi kwa udaho wa ndai.” ");
INSERT INTO bou_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Naho Yesu akavoka kugombeka nao kwa misimo, “Mntu yumwe kaima mnda wa mizabibu akazenga ukanto, na gatigati akagosoa hantu ha kukamuiia divai, akazenga mnaa aho. Naho akauazima uda mnda kwa waimi akatamba kuita si ya hae.” ");
INSERT INTO bou_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kisingi cha ubosi chekubuaho, akamwagiiya mndima wakwe kwa wada waimi, amwetee fungu dakwe da ubosi da yuda mwenye mnda. ");
INSERT INTO bou_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wada waimi wakamgwiiya, yuda mndima wakamtoa na kumvuza bue. ");
INSERT INTO bou_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mwenye mnda akamwagiiya mndima mtuhu, uyu nae wakamtoa mwe mtwi na kumtenda vyesavyo kutama. ");
INSERT INTO bou_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yuda mwenye mnda akamwagiiya mndima mtuhu, awo waimi wakamkoma na mwenye mnda akawaagiiya watuhu wangi, wakatoigwa na wangi wakakomwa. ");
INSERT INTO bou_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwenye mnda akasigaa na mntu yumwe ni mwanawe amkundisae. Nae akamwagiiya uyo akagombeka, “Wenda wamtunye mwanangu!” ");
INSERT INTO bou_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Akini wada waimi wakaambizana, “Uyo ne mpazi haya timkome, upazi utende wetu.” ");
INSERT INTO bou_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kwaiyo wakamgwiiya, wakamkoma na kumtambika chongoi ya uda mnda wa mizabibu. ");
INSERT INTO bou_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aho Yesu akawauza, “Mwenye mnda endaatende viivihi? Endaeze awadagamize awo waimi na kuazimisha mnda uwo wa mizabibu kwa waimi watuhu. ");
INSERT INTO bou_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Khamzati kusoma Maandiko aya? ‘Iwe dekuemewado na wazengi isasa diwa iwe kuu da khandani. ");
INSERT INTO bou_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zumbe ne mwekugosoa mbui inu, nado ni utangio kwetu!’” ");
INSERT INTO bou_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Waviki wakuu, Wahinyi wa Miko na wadaa wamanya yakuwa msimo uwo wawausu, wakageeza kumgwiya akini wakaogoha zumwezumwe da wantu aho wakambada wakaita. ");
INSERT INTO bou_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Naho, wamwe wa Mafalisayo na kizumwezumwe cha Helode, wakaagiiwa kwa Yesu wamtege kwa mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wakambasa Yesu wakamwamba, “Mhinyi tamanya wee ni mntu mzumizi, ugombekaye ukwei. Naho khukauwa ukuu wa mntu yoyose, akini wahinya kwei sia ya Muungu. Ni vyedi kuiha kodi kwa Seuta mkuu wa Lumi? Tiihe hambu tesekuiha?” ");
INSERT INTO bou_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Akini Yesu ne amanya uhokho wao. Akawatambaisa, “Kwa mbwai mwanigeeza? Nekhani sensi niikauwe.” ");
INSERT INTO bou_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wakamwegaiya sensi mwenga ne awauza, “Cheni na idi zina ni da ndai?” Ne wamtambaisa, “Ni vya Seuta mkuu wa Lumi.” ");
INSERT INTO bou_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aho Yesu akawamba, “Ni vyedi mwekheni Seuta mkuu wa Lumi ayo yakwe na Muungu mwekheni yakwe.” Wakahondomazwa muno nae. ");
INSERT INTO bou_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Naho, wamwe wa Masadukayo wamba khakuna kuyuyuka, wakambasa Yesu na kumuuza, ");
INSERT INTO bou_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mhinyi, Musa katiagiiya ivi, ‘Mntu akauya na nyuma na kumbada mkaziwe kwesiho kuvyaa. Nduguye akundigwa amdoe yuda mvyee mwekufiwa ni mgosi, adahe kumvyaia wana.’ ");
INSERT INTO bou_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naho nekuwa na ndugu mfungate, yuda wa bosi kategua, akauya na nyuma kwesiho kubada mwana. ");
INSERT INTO bou_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndugu wakaidi naye akampaa yuda mvyee mwekufiwa ni mgosi, akini yee naye akauya na nyuma kwesiho kubada mwana. Viyaviya ndugu wa ntatu akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wose mfungate wakauya na nyuma kwesiho kubada mwana. Ne yuda mvyee naye mwekufiwa ni mgosi akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aho, msi wantu wendaho wayuyuke, mvyee uyo endaawe mkaza ndai? Kwaviya wose mfungate ne wamtegua.” ");
INSERT INTO bou_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akawatambaisa, “Nyie mwaga kwaviya khammanya Maandiko ya Muungu wala udaho wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwaviya wantu wendaho wayuyuke, khawana wategue wala kutegulwa, iya wendawawe inga wandima wa uwanga wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Akini mbui ya kuyuyuka kwa wekufao, khamzati kusoma mwe kitabu cha Musa hantu ambaho kada katundugua kekuwacho chaka moto? Muungu akamwamba Musa, ‘Mie ni Muungu wa Ibulahimu na Muungu wa Isaka na Muungu wa Yakobo.’ ");
INSERT INTO bou_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yee ni Muungu wa wantu wagima, na khio Muungu wa wada wekuuyao na nyuma. Ivyo mbanikiwa muno!” ");
INSERT INTO bou_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mhinyi yumwe wa miko akabua hada, akategeeza wahiganavyo. Ekuonaho Yesu kawatambaisa vitana yuda Sadukayo, ne ambasa Yesu na kumuuza, “Mwe amli zose ni ihi ya bosi?” ");
INSERT INTO bou_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akamtambaisa, “Mwiko mkuu ni unu, ‘Tegeezani nywie wantu wa Isilaeli! Zumbe Muungu yetu ni yumwe Zumbe ikedu. ");
INSERT INTO bou_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mkunde Zumbe Muungu yako kwa moyo wako wose, kwa muye wako wose, na kwa akii zako zose na kwa mdundugo wako wose.’ ");
INSERT INTO bou_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ya kaidi ni inu, ‘Mkunde mwenzio inga wekundisavyo mwenye.’ Khahana mwiko mkuu mtuhu kusima inu miidi.” ");
INSERT INTO bou_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aho yuda Mhinyi wa Miko akamwamba Yesu, “Kugombeka vyedi Mhinyi! Muungu ni yumwe du na khahana Muungu mtuhu inga yee. ");
INSERT INTO bou_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Naho yakundigwa mntu amkundise Muungu kwa moyo wose na kwa muye wose na kwa akii zose na kwa udaho wose, na kumkundisa mwenzio inga wekundisavyo mwenye. Mbui inu ni ntana kusima malavyo na ntambiko.” ");
INSERT INTO bou_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu ekuonaho yuda mntu kamtambaisa kwa kutintimaa akamwamba, “Wee khuho hae na Uzumbe wa Muungu.” Bada ya mbui ida khahana mntu yoyose mwekudaha kumuuza vituhu mbui yoyose. ");
INSERT INTO bou_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Naho kisingi Yesu ekuwaho akahinya kwe Nyumba ya Muungu, akawauza, Wahinyi wa Miko wamba Klistu ni mwana Daudi? ");
INSERT INTO bou_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Daudi mwenye akaongoewa na Muye wa Muungu akagombeka. ‘Zumbe akamwamba Zumbe yangu, ekaa mkono wangu wa kudiiya, hadi nendaho niwaike wamasa wako asi he miundi yako.’ ");
INSERT INTO bou_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi mwenye amwetanga Klistu Zumbe, aho Klistu endaawe viivihi mwanawe?” Zumwezumwe da wantu ne wakamtegeeza Yesu kwa kinyemi. ");
INSERT INTO bou_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ekuwaho awahinya ne awamba, “Ekaani hae na Wahinyi wa Miko, wakundao kwemboka emboka wevaia khanzu zilehazo na kuuguswa ni wantu kwa tunyo mwe gwiiyo, wakunda kwekaa hantu ha tunyo he Nyumba ya kukintania Wayahudi, ");
INSERT INTO bou_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wakunda kwekaa viti vya hemeso mwe Nyumba ya kuvikia Wayahudi na kwekhigwa phasi ha ntunyo mwe ntafuno. ");
INSERT INTO bou_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wawakonya wavyee wekufiwao ni wagosi naho wegosoa kuvika kisingi kilehacho! Msi wa kuamuiwa wendawekhigwe sugusa khai!” ");
INSERT INTO bou_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ekuwaho kekaa hehi na ntezu ya kuikia malavyo. Akawakauwa wantu wangi waavyavyo hea na kuika mwe ntezu ya Nyumba ya Muungu. Wantu wenye mai nyingi walavya hea nyingi. ");
INSERT INTO bou_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aho ne eza mmaa yumwe mkiwa mwekufiwa ni mgosi, akalavya sensi mbii za shaba. ");
INSERT INTO bou_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aho Yesu akawetanga wahina wakwe akawamba, “Nawamba kwei mmaa uyu mkiwa mwekufiwa ni mgosi kagea hea nyingi mwe ntezu ya malavyo kusima wose wekulavyao. ");
INSERT INTO bou_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwaviya Watuhu wose walavya mai zekuwamemeazo, akini uyu mmaa mwe ukiwa wakwe kalavya vyose ekuwavyonavyo hata kia chakumwambiza mwe ugima wakwe.” ");
INSERT INTO bou_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ekuwaho akalawa mwe Nyumba ya Muungu, mhina wakwe yumwe akamwamba, “Mhinyi, kauwa maiwe aya na mazengo yekuwavyo matana muno!” ");
INSERT INTO bou_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu akamwamba, “Wayaona mazengo aya makuu? Khahana hata iwe dimwe dendado disigae uwanga ya ntuhu, yose yenda yatulwe.” ");
INSERT INTO bou_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ekuwaho kekaa kwe muima wa Mizaituni na kukauwa Nyumba ya Muungu, Petulo na Yakobo na Yohana na Andulea wakamuuza kwesiho wantu. ");
INSERT INTO bou_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tambie mbui izo zendazilawie ini? Na utangio wakwe ni uhi wendaoutimanyise mbui izi zihehi kubua?” ");
INSERT INTO bou_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akavoka kuwamba, “Ekauweni mwesekutiiwa ni mntu yoyose.” ");
INSERT INTO bou_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wangi wendaweze na kwetanga kwa zina dangu, kia yumwe endaagombeke, “Mie nee Klistu!” Naho wendawawatiie wantu wangi. ");
INSERT INTO bou_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mwendaho mtegeeze mbui ya khondo kwa hae na vuzo da khondo kwa hehi, mwesekuwa na maatu. Mbui izo zakundigwa zilawie, akini mbui iyo khaizati kubua. ");
INSERT INTO bou_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Wantu wa si mwenga wendawatowane na wantu wa si ntuhu, wantu wa useuta umwe wendawatoane na wantu wa useuta mtuhu, naho kia hantu hendahawe na mizingizo ya inusi na baa da saa. Mbui izi inga usungu wa bosi wa kuvyaa mwana. ");
INSERT INTO bou_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Akini nywie mwekae meso, kwaviya wendawawegae mwe kifungo na kuwatoa mwe Nyumba ya kuvikia Wayahudi. Mwendamwegalwe hemeso ya wagookezi na maseuta kwaajii yangu, ili muwambe Mbui Yedi. ");
INSERT INTO bou_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Akini yakundigwa Mbui Yedi ya Muungu ivoke kubiikiwa kwa wantu wa si zose, kabla khakizati kubua kisingi cha kisikizi. ");
INSERT INTO bou_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naho wendaho wawagwiiye na kuwegaa ha kuamuiwa, msekuogoha mwendamgombeke mbwai, mda wendaho ubue dodose mwendado mwekhigwe gombekani. Kwaviya khio nywie mgombekao iya ni Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mntu endaamhituke nduguye akomwe, na tate endaamhituke mwanawe. Wana nao wendawawahituke wavyazi wao na kuwakoma. ");
INSERT INTO bou_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wantu wose wendawakimwe na nywie Kwaajii yangu, iya mwendaazizimize adi kubua kisikizi ne endaye aoholwe. ");
INSERT INTO bou_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Muonaho ufyaimu ugooka hantu kwesiho hakwe, mmanyisi na amanye mana yakwe aho, wada weiho Uyahudi waguukie kwe miima. ");
INSERT INTO bou_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yuda mwe uwanga ya nyumba asekuseea asi kwengia mwe nyumba yakwe kudoa kintu chochose. ");
INSERT INTO bou_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mntu mwekuwa mwe mnda asekuuya kaya kudoa nguo yakwe. ");
INSERT INTO bou_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wendawakione wavyee wekwenuao maifu na wada waokhesao msi uwo! ");
INSERT INTO bou_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mwombezeni Muungu mbui izo zesekulawia kisingi cha pheho. ");
INSERT INTO bou_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwaviya kisingi icho chendakiwe cha suuba khuu na khakizati kulawiiya kuvokea aho Muungu ekugosoavyo inusi hadi ivyeo, naho khayezakulawiiya vituhu. ");
INSERT INTO bou_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Inga Zumbe khekuwa ahunguzie misi izo khahana mntu mwendayeaoholwe, akini kwaajii ya wantu wakwe ekuwasaguao Zumbe kahunguza misi izo. ");
INSERT INTO bou_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Naho mntu yoyose akawamba, Kauwani, Klistu yuaha, au yu kuda! Msekuzumiia.” ");
INSERT INTO bou_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwaviya wendawalawie maklistu wa utiizi na waoni wa utiizi, wendawagosoe vihii na viozo, kwaajii ya kuwaza hata wada wekusagulwao ni Muungu, inga vikadahika. ");
INSERT INTO bou_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akini nywie mwekae meso! Kwaviya khiwagombekea mbui zose zekuwazo khazizati kulawiiya. ");
INSERT INTO bou_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mwe misi izo, suuba khuu ikemboka, zua dendadigewe kiza na mweenge khauna ung'ae.” ");
INSERT INTO bou_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ntoondo zendazigwe kulawa uwanga na mdundugo wa uwanga kwe mazunde wendausingisike. ");
INSERT INTO bou_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aho Mwana wa Mntu endaalawie akeza mwe mazunde kwa udaho na ukuu. ");
INSERT INTO bou_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naye endaawagiiye wandima wa uwanga kwa Muungu kuwaika hamwe wantu wose wekusagulwao ni Muungu, kulawiiya phande zose nne za inusi, kulawiiya kisikizi cha inusi hadi kisikizi cha mmbingu. ");
INSERT INTO bou_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kauwani msimo wa mti wa mtini na mwehinye. Aho matambi yakwe yavoka kutenda mateke na kulavya mani, mmanye kisingi cha ubosi kihehi.” ");
INSERT INTO bou_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Viyaviya muonaho mbui izo zikalawia, mmanye Mwana wa Mntu yu hehi kwe uvi kweza. ");
INSERT INTO bou_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nawamba kwei, kivyazi iki khakinachemboke hadi mbui zose izo zendahozilawie. ");
INSERT INTO bou_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mmbingu na inusi zendazemboke, akini mbui zangu khazina zemboke katu. ");
INSERT INTO bou_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Akini khahana mntu amanyae msi na saa hata wandima wa uwanga kwa Muungu, na Mwana khamanya, iya Tate ikedu ne amanyae. ");
INSERT INTO bou_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muwe tayali kwaviya khammanya kisingi icho chenda kibue ini. ");
INSERT INTO bou_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yendaiwe inga mntu alawaye kaya na kuita ntambo akawabadia wandima wakwe waikaue na waigookee, kia yumwe akamwekha ndima yakwe yakugosoa, akamwamba yuda semgoja “Asekugona.” ");
INSERT INTO bou_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mwekae tayali kwaviya khammanya mwenye kaya endaauye ini, yadahika ni guoni, kio kikuu, keokeo da mtungaihu au keo. ");
INSERT INTO bou_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwekae tayali ili akeza vuupu asekweza akawabwiiya mgona. ");
INSERT INTO bou_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Niwambavyo nywie nawamba wose, mwekae tayali! ");
INSERT INTO bou_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nezisigaa misi miidi kabla khaizati kubua sikukhuu ya Pasaka na ya mabumunda yesayokugewa hamila. Waviki wakuu na wahinyi wa miko wakaondeza sia ya kumgwiiya Yesu kwa unyanyi na kumkoma. ");
INSERT INTO bou_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akini wakamba, “Tesekumgwiya kisingi cha sikukhuu ya Pasaka, wantu wesekweza wakatikweea khumbizi.” ");
INSERT INTO bou_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ne yumwe mzi wa Besaniya, mwe nyumba ya Simoni mntu mwekuwa na utamu wa nyoka. Aho Yesu ekuwaho akada khande ne engia mvyee yumwe mwekuwa na nchupa ya iwe yetangwayo alibasta yenye mavuta yanukhiayo vitana ya hela nyingi. Akaitua ida nchupa na kumwetiia mavuta Yesu mwe mtwi. ");
INSERT INTO bou_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wamwe wa wantu wekuwaho aho wakakimwa na mbui ida wakauzana, “Kwambwai mavuta aya matana yaga buebue? ");
INSERT INTO bou_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mavuta ayo ne yadahika kutangwa kwa sensi nyingi na sensi izo wakekhigwa wakiwa!” Wakamwakia yuda mvyee. ");
INSERT INTO bou_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Akini Yesu akawamba, “Mweekeni kwambwai mwampisha? Kanigosweea mbui ntana. ");
INSERT INTO bou_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wakiwa mnao misi yose, mwadaha kuwaambiza kisingi chochose mkundacho. Akini mie khinaniwe hamwe na nywie misi yose. ");
INSERT INTO bou_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mvyee uyu kagosoa viya ekudahavyo, kaongoa kuusisa mwii wangu mavuta kwaajii ya kuandaia maziko yangu. ");
INSERT INTO bou_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nawambeni kwei, hantu hohose mwe inusi Mbui Yedi yendaho ibiikiwe, mbui inu ekugosoayo uyu mvyee yenda itamwiiwe kwa khumbuso da yuda mvyee.” ");
INSERT INTO bou_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naho Yuda Isikaliote yumwe wa wada wahina kumi dimwe na waidi, akaita kwa waviki wakuu ili kumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Waviki wakuu wekutegeezaho mbui izo, ne wawa na nyemi, wakamwikia kiaga cha kumwekha hela. Aho Yuda akavoka kuondeza phasi ya kumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mwe msi wa bosi mwe sikukhuu ya mabumunda yesayokugewa hamila, kisingi ambaho mwanangoto wa Pasaka adumulwa singo, wahina wakwe wakamuuza Yesu, “Wakunda tikwikie hahi ntafuno ya Pasaka?” ");
INSERT INTO bou_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naho Yesu akawagiiya wahina wakwe waidi, akawamba, “Hitani kwe mzi na umo mwendamkintane na mgosi yumwe kenua biga da mazi. Mtongeeni, ");
INSERT INTO bou_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hadi mwe kaya endayoengie, mkamwambe mwenye kaya, ‘Mhinyi amba, nihahi gati nendaho nidiie khande ya Pasaka hamwe na wahina wangu?’ ");
INSERT INTO bou_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naye enda awonyeshe gati khuu yeuko uwanga kwe goofa chekuikwacho tayali, tiikieni umo.” ");
INSERT INTO bou_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wahina wakahauka wakaita kwe mzi, wakabwiiya kia kintu nsawa inga Yesu ekuwagombekeavyo. Ne waiika ntafuno ya sikukhuu ya Pasaka. ");
INSERT INTO bou_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yekubuaho guoni Yesu akabua hamwe na wahina wakwe kumi dimwe na waidi. ");
INSERT INTO bou_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wekuwaho wakada khande Yesu akawamba, “Kwei nawamba yumwe yenu mda nami, enda anihituke.” ");
INSERT INTO bou_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wada wahina wakagumia mioyo wakamuuza Yesu yumweyumwe, “Hambu, ni mie?” ");
INSERT INTO bou_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu akawatambaisa, “Ni yumwe gatigati yenu nywie kumi dimwe na waidi, ni yuda agintae bumunda hamwe na mie mwe bakui. ");
INSERT INTO bou_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kwei Mwana wa Mntu aita kuuya na nyuma inga yekuandikwavyo mwe Maandiko ya Muungu, akini endaakione mntu yuda amhitukae Mwana wa Mntu! Ebae mntu uyo khekuwa avyaigiwe!” ");
INSERT INTO bou_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wekuwaho wakada, Yesu akadoa bumunda akatogoa, akadibendua na kuwekha wahina wakwe, akamba, “Doani unu nee mwii wangu.” ");
INSERT INTO bou_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naho akadoa kikombe cha divai, akamtogoa Muungu na akawekha wose wakadomea kulawa mwe kikombe icho. ");
INSERT INTO bou_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akawamba, “Inu ne phome yangu ya Agane yetikayo kwaajii ya wantu wangi.” ");
INSERT INTO bou_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nawamba kwei, “Khinanidomee vituhu divai inu ya mzabibu hadi misi ida nendayo nidomee uhya mwe Uzumbe wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naho wakatoa wiya, wakahauka wakaita kwe Muima wa Mizaituni. ");
INSERT INTO bou_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu akawamba wahina wakwe, “Nywie nyose mwendamnibade, kwaviya Maandiko ya Muungu yamba ‘Nenda nimtoe mwiisi, na ngoto zenda ziangadike uko na uko.’ ");
INSERT INTO bou_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Akini nendaho niyuyuke nenda niwaongoee kuda Galilaya.” ");
INSERT INTO bou_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo akamwamba Yesu, “Inga wose wendaho wakubade, mie khina nikubade katu!” ");
INSERT INTO bou_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu akamwamba Petulo, “Kwei nakwamba kio iki, zogoo khadizatikukema maa mbii, wendauniemee maa ntatu.” ");
INSERT INTO bou_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Akini petulo akaendeea kugombeka, “Hata inga nikakudigwa niuye na nyuma hamwe nawe, khina nikubade katu.” Naho Wahina wose wakagombeka inga ivyo. ");
INSERT INTO bou_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aho, wakabua he kamnda wetangwao Gesemane, Yesu akawamba wahina wakwe, “Ekaani aha, kisingi mie navika.” ");
INSERT INTO bou_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Naho akawadoa Petulo, na Yakobo na Yohana. Akavoka kuugumia muno mwe moyo wakwe na kuangadika. ");
INSERT INTO bou_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne awamba, “Nina usungu mno mwe moyo wangu hehi na kunikoma. Mwekae aha na mwekae meso.” ");
INSERT INTO bou_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akaita mbee kidodo, aketambika asi akagonea ifu, akavika amba, ati ikadahika asekwembokea mda uwo wa suuba. ");
INSERT INTO bou_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akagombeka, “Abba, Tate mbui zose kwako zadahika. Uniusie kikombe iki, iya khio inga nikundavyo mie iya ukundavyo weye.” ");
INSERT INTO bou_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naho akauya na kuwabwiiya wada wahina wakwe watatu wagona, akawamba Petulo, “Simoni, kugona? Khamwekudaha kwekaa meso hata saa mwenga?” ");
INSERT INTO bou_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Naho akawamba, “Mwekae meso na kuvika mwesekweza kwengia mwe mageezo. Muye wakunda, iya mwii khauna udaho.” ");
INSERT INTO bou_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akenda kuvika vituhu na kuuiya mbui ziyaziya. ");
INSERT INTO bou_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naho akauya vituhu, akawabwiiya wagona kwaviya meso yao ne yamema usisiza, khawokumanya da kumtambaisa. ");
INSERT INTO bou_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ekwezaho maa ya ntatu akawamba, “Khamzati kwenuka na kuhumwiiza? Isasa enukani! Mda ubua kauwa, Mwana wa Mntu agewa mwe mikono ya wagosoao mavigaviga. ");
INSERT INTO bou_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enukani! Titeni! Kauwani, yuda mntu endaeanihituke yuhehi.” ");
INSERT INTO bou_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ekuwaho agombeka, Yuda, yumwe wa wada wahina kumi dimwe na waidi akabua, keza hamwe na zumwezumwe da wantu wekwenuao mapaange na malungu. Wantu awo ne waagiiwa na waviki wakuu na wahinyi wa miko hamwe na wadaa wagookezi. ");
INSERT INTO bou_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naho Yuda Isikaliote nee kawekha utangio, “Nendaye nimuumbatie uyo mgwiieni na kumwiika asi ya ugoja.” ");
INSERT INTO bou_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda Isikaliote ekubuaho akaita kwa Yesu, akamwamba “Mhinyi!” Naho akamuumbatia. ");
INSERT INTO bou_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wada wantu wakamgwiya Yesu na kumwiika asi ya ugoja. ");
INSERT INTO bou_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumwe da wada wekuwaho wagooka aho hamwe na Yesu, akasomoa paange dakwe akamtoa yumwe wa wandima wa mviki mkuu, akamsenga gutwi. ");
INSERT INTO bou_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Naho Yesu akawamba, “Uwo mweza na mapaange na malungu kunigwiiya inga mie ni mhokaji? ");
INSERT INTO bou_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kia msi ni hamwe nanywi kahinya mwe Nyumba ya Muungu, khamwekunigwiya, akini isasa yakundigwa Maandiko ya Muungu yaiganie.” ");
INSERT INTO bou_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aho wahina wakwe wose wakambada na kuguuka. ");
INSERT INTO bou_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nekuwa na mbwanga yumwe ekuwaye akambasa Yesu nekavaa shuka ing'aayo. Naho wakageeza kumgwiiya. ");
INSERT INTO bou_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Akini yee akachopoka na kuwabadia shuka ing'aayo, akaguuka kwesaho nguo. ");
INSERT INTO bou_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naho Yesu akegalwa mwe kaya ya mviki mkuu, aho akakintana na waviki wakuu wose, wadaa na wahinyi wa miko ne wakintana. ");
INSERT INTO bou_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo akambasa Yesu kwa hae, akengia mda mwe buha da mviki mkuu, akekaa hamwe na wasemgoja aotea moto. ");
INSERT INTO bou_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Waviki wakuu na wantu wose wa baaza kuu wakoondeza, mbui zendazo zimtende Yesu akomwe, akini khawekupata. ");
INSERT INTO bou_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wantu wangi nee wagooka na kugombeka uhokho, akini mbui zao khazekuhigana. ");
INSERT INTO bou_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Naho watuhu wakagooka wakagombeka uhokho, ");
INSERT INTO bou_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Timtegeeza mntu uyu akagombeka, ‘Nenda niibanange Nyumba inu ya Muungu yekuzengwayo na wantu, na kwa misi mitatu nendaniizenga tuhu yesayokuzengwa na wantu.’ ” ");
INSERT INTO bou_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Akini ata ivyo mbui zao khazekwevana. ");
INSERT INTO bou_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nee Mviki Mkuu akagooka hemeso yao akamuuza Yesu, “Wee khutambaisa mbui? Wantu awa waona mbwai kwako?” ");
INSERT INTO bou_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akini yee akanyamaa khekuandua hata mbui mwenga. Mviki Mkuu akamuuza vituhu, “Uwo wee nee Klistu, Mwana wa Muungu Mkuu?” ");
INSERT INTO bou_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akatambaisa, “Ehe, nee mie, na nywie mwendammwoone Mwana wa Mntu kekaa phande ya kuume ya Muungu mwenye udaho, eza na maangwi ya uwanga.” ");
INSERT INTO bou_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aho Mviki Mkuu akatatua khanzu yakwe, akamba, “Taonda mbui yani vituhu za kumkoea masa?” ");
INSERT INTO bou_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mtegeezeni amdumuavyo Muungu. Nyie mwaona vivihi? Wose wakakunda akomwe. ");
INSERT INTO bou_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aho wamwe wa wantu wakavoka kumswiia ovu, wakamfunga buye, wakamtoa na kumwamba, “Otea ni ndai mwekukutoa!” Hata wakinasemgoja wakamdoa, wakamtoa vibao. ");
INSERT INTO bou_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo ekuwaho yu ahosi kwe buha, yumwe wa wandima wa kivyee wa Mviki Mkuu akeza. ");
INSERT INTO bou_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ekumuonaho Petulo aotea moto, akamkauwa akamwamba, “Hata wee nee uhamwe na Yesu Mnazaleti.” ");
INSERT INTO bou_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Akini Petulo akaemea, “Hangi na khimanya ugombekayo!” Naho Petulo akahauka akaita hantu ha kwengiia, aho zogoo dikakema. ");
INSERT INTO bou_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yuda mndima ekumwonaho vituhu Petulo akavoka vituhu kuwamba wantu wekuwao wagooka aho, “Mntu uyu ni yumwe yao.” ");
INSERT INTO bou_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petulo akaemea vituhu. Mda mcheche wantu wekuwaho wagooka aho wakamwamba Petulo, “Kwei wee ni yumwe yao, kwaajii wee ni Mgalilaya.” ");
INSERT INTO bou_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iya Petulo akavoka kweyapiza na kuaha akamba, “Miye khimmanya mntu uyu mgombekaye mbui zakwe.” ");
INSERT INTO bou_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aho zogoo akakema maa ya kaidi, Petulo akakumbuka viya Yesu ekuwavyo kamwamba, “Zogoo khadizati kukema maa mbii, wendauniemee maa ntatu.” Petulo akahomokeza mesozi. ");
INSERT INTO bou_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwekuchaho waviki wakuu na wadaa na wahinyi wa miko na Baaza kuu dose, wakamgea phingu Yesu wakamwegaa na kumwekhiiza kwa Pilato. ");
INSERT INTO bou_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato akamuuza Yesu, “Wee ni Seuta wa Wayahudi?” Yesu akamtambaisa, “Eeh inga ugombekavyo wee!” ");
INSERT INTO bou_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Waviki wakuu wakamuahia Yesu kwa mbui nyingi. ");
INSERT INTO bou_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato akamuuza vituhu Yesu, “khuna da kutambaisa? Kauwa wakusakiavyo mbui nyingi kwaajii yako.” ");
INSERT INTO bou_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Akini Yesu khekutambaisa mbui hata Pilato akahondomaa. ");
INSERT INTO bou_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kia kisingi cha sikukhuu ya Pasaka, Pilato kawa na mazweea ya kuwavuguiya mfungwa yumwe wamkundaye. ");
INSERT INTO bou_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kisingi icho nekuwa na mntu yumwe etangwae Balaba, nee kafungwa hamwe na wantu wekuaho waemea uongooezi, naho nee wagosoa ukomaji kwe khumbizi. ");
INSERT INTO bou_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wantu wangi wakaita kwa Pilato wakamwombeza awagosoee inga yekuwavyo akawagosoea. ");
INSERT INTO bou_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato akawauza, “Mwakunda niwavuguiye Seuta wa Wayahudi?” ");
INSERT INTO bou_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato kagombeka ivyo kwaajii kamanya pwii waviki wakuu wamwegaa Yesu kwakwe kwaajii ya kinyuu. ");
INSERT INTO bou_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akini waviki wakuu wakawatenda wantu watoe vuzo ili wamwombeze Pilato awavuguiye Balaba. ");
INSERT INTO bou_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato akawauza wantu vituhu, isasa mwakunda nigosoe mbwai mntu uyu mwetangwae Seuta wa Wayahudi? ");
INSERT INTO bou_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wantu wose wakatowa mgutio vituhu, “Mgong'ondeni kwe mhamba!” ");
INSERT INTO bou_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Akini Pilato akawauza, “Kwambwai! Kagosoa ufyaimu wani?” Akini wowo wakaendeea kutoa mgutio, “Mgong'ondeni he mhamba!” ");
INSERT INTO bou_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato akakunda kutamiza dia zumwezumwe da wantu. Aho nee amwekea Balaba kulawa mwe kifungo. Akakunda Yesu atoigwe ngoda wakabinda wamgong'ondee he mhamba. ");
INSERT INTO bou_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naho asikai wakamwegaa Yesu mwe buha da nyumba ya mkuu wa si ya Yudea, aho wakakintana kikosi kigima cha asikai. ");
INSERT INTO bou_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wakamvika gwanda da zambalau, wakagosoa kintu inga khofia ya useuta yekugosolwayo na miwa, wakamwiikia Yesu mwe mtwi wakwe. ");
INSERT INTO bou_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wakavoka kumuugusa, “Mwinyi Seuta wa Wayahudi!” ");
INSERT INTO bou_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wakamtoa kwa ngoda ya lasi mwe mtwi, wakamswiia ovu, wakamkintia mavindi na kumwenamia. ");
INSERT INTO bou_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wekubindaho kumbea, wakamhambua dia gwanda da zambalau, wakamvika nguo zakwe, naho wakamlavya chongoi, wakamwegaa kumgong'ondea mwe mhamba. ");
INSERT INTO bou_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wekuwaho siai, wakakintana na mntu yumwe etangwae Simoni, mwenyezi wa Kilene. Yee nee ni tate yao Alekizanda na Lufo na kisingi icho ne akalawa chongoi ya mzi. Nee asikai wamshutiza audoe mhamba wa Yesu. ");
INSERT INTO bou_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naho wakamwegaa Yesu adi hantu hetangwaho Goligota, mana yakwe hantu ha Fufu da Mtwi. ");
INSERT INTO bou_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wakamwekha divai yekuhanganywayo na mzigi wetangwao manemane, akini yee akaemea kuidomea. ");
INSERT INTO bou_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nee wamgong'ondea he mhamba, wakapangana nguo zakwe na kuzitoea kula kia yumwe adoe yakwe. ");
INSERT INTO bou_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Neiwa saa ntatu da keo wekumgong'ondeavyo he mhamba. ");
INSERT INTO bou_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nee yagondwa masa yakwe ni, “Seuta wa Wayahudi.” ");
INSERT INTO bou_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wamgong'ondea he mhamba na wahokaji waidi kia yumwe mhamba wakwe, yumwe phande ya kudiiya na mtuhu phande ya kumoso. ");
INSERT INTO bou_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aho Maandiko ya Muungu yakaigania yambayo, “Kaikwa kundi dimwe hamwe na wahokaji.” ");
INSERT INTO bou_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wantu wekuwao wemboka hantu hada wakamdumua wakasingisa mitwi yao na kugombeka, Ehee! Wee mtua Nyumba ya Muungu na kuizenga kwa misi mitatu. ");
INSERT INTO bou_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Isasa weohoe mwenye seea he mhamba! ");
INSERT INTO bou_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na viyaviya waviki wakuu hamwe na wahinyi wa miko wakammbea wakamba, “Kawaohoa wantu watuhu akini khadaha kweohoa mwenye!” ");
INSERT INTO bou_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ati yee ni Klistu ekusagulwae ni Muungu, Seuta wa Isilaeli! Na asee kulawa he mhamba tione na kumzumiia hata wada wantu wekugong'ondwao wose he mhamba nae wakamdumua. ");
INSERT INTO bou_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kuvokea saa mtandatu wa musi adi saa kenda kiza kikuu kikagwa mwe si yose. ");
INSERT INTO bou_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa kenda guoni Yesu akaiya kwa mgutio mkuu, akamba, “Eloi, Eloi, lama, Sabakitani?” Mana yakwe, “Muungu yangu, Muungu yangu mbona kunibada?” ");
INSERT INTO bou_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wamwe wa wantu wekugookao hada wekutegezaho ivyo wakamba, “Tegeeza! Amwetanga Elia.” ");
INSERT INTO bou_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mntu yumwe akamgukia akaginta dodoki mwe divai yekusasayo, akaika uwanga ya lasi akamwekha adomee akamba, “Hembu timkaue ati Elia endaeze amseeze he mhamba!” ");
INSERT INTO bou_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu akakema kwa mgutio mkuu, akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nee pazia kuu da Nyumba ya Muungu dikatatuka ntii mbii kulawa uwanga hadi asi. ");
INSERT INTO bou_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkuu wa maasikai ekuwaye kagooka hemeso ya mhamba wa Yesu, ekuonaho Yesu kauya na nyuma kwa namna iyo, akamba kwei mntu uyu nekawa Mwana wa Muungu. ");
INSERT INTO bou_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wawa aho wavyee wekukauwao kwa hae gatigati yao nee ni Maliamu Magidalena na Salome na Maliamu mami yakwe Yakobo mvunawe da Yusufu. ");
INSERT INTO bou_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Awa ne wambasa Yesu ekuwaho Galilaya na kumwambiza. Nekuwa na wavyee watuhu wangi na wangi wekwezao Yelusalemu hamwe nae. ");
INSERT INTO bou_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kisingi cha guoni ne kibua kae, na iyo neiwa msi wa maandaiyo yani msi uongoao Msi wa Kuhumwiiza. ");
INSERT INTO bou_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aho akeza Yusufu mwenyezi wa Alimatayo ne ni mntu wa Baaza kuu da Wayahudi, mtunywa muno. Yee pia nee akakauwiya kweza kwa Useuta wa Muungu. Nee aita kwa Pilato kwesiho kumwogoha, akamwombeza ekhigwe mwii wa Yesu. ");
INSERT INTO bou_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato akahondomaa ekusikiaho kuwa Yesu kabindiikia kae kuuya na nyuma. Nee akamwetanga mkuu wa maasikai na kumuuza ati Yesu kauya kae na nyuma mwandoose. ");
INSERT INTO bou_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato ekwembigwaho na uyo mkuu wa maasikai Yesu kauya kae na nyuma, akamkunda Yusufu adoe mwii wakwe. ");
INSERT INTO bou_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aho Yusufu akagua sanda, akauseeza asi uwo mwii akauvungavunga sanda. Akauwiika mwe mbia dekuwado digosolwa kwe iwe cha ukuu naho akatongoosa iwe kuu hemeso ya uvi. ");
INSERT INTO bou_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Maliamu Magidalena na Maliamu mami yakwe da Yusufu wakahaona aho ekugonezwaho. ");
INSERT INTO bou_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Msi wa Kuhumwiiza yekwembokayo Maliamu Magidalena na Salome na Maliamu mami yakwe da Yakobo wakagua mavuta matana, ili wakausise mwii wa Yesu. ");
INSERT INTO bou_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Keo da mtungaihu msi wa bosi wa juma wakabua he mbia zua dekuvokaho kulawa. ");
INSERT INTO bou_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Naho wekuwaho siai nee watamwiiya, “Nndai mwendaatiusie dia iwe he uvi wa mbia?” ");
INSERT INTO bou_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Akini wekukauwaho wakoona iwe diusigwa kae nado nee diwa kuu muno. ");
INSERT INTO bou_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wekwengiaho mda mwe mbia wakomwona mbwanga yumwe kavaa khanzu yekung'aayo kekaa phande ya kuume wakahondomaa muno. ");
INSERT INTO bou_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akini uyo mbwanga akawamba, “Msekuhondomaa. Mwamwondeza Yesu wa Nazaleti mwekugong'ondewa he mhamba. Kayuyuka, khayuho aha, kauwani hantu ekugonezwaho. ");
INSERT INTO bou_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hitani mkawambe wahina wakwe hamwe na Petulo awaongweea kuita Galilaya. Uko mwendammwone inga ekuwagombekeavyo.” ");
INSERT INTO bou_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naho wakalawa hada he mbia na uguuko, mana nee wakazingiza kwa maatu na kuhondomaa khawekumgombekea mntu yoyose mbui iyo, kwaajii waogoha mno. ");
INSERT INTO bou_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu ekuyuyukaho msi wa bosi wa juma aho akeonyesha kwa Maliamu Magidalena, ambae Yesu kamlavya mazaiko mfungate. ");
INSERT INTO bou_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliamu Magidalena akaita, akawamanyisa wada wekuwaho wakitongeana na Yesu na kisingi icho newawa na bwaimbo na kuiya. ");
INSERT INTO bou_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Akini wekusikiaho Yesu yu mgima ati Maliamu Magidalena kamwoona, khawokumzumiiya. ");
INSERT INTO bou_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yekwembokaho ayo Yesu akawalawia wahina waidi kwa cheni kituhu. Wahina awo newawa wakaita chongoi ya mzi. ");
INSERT INTO bou_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naho wakaita kuwamba wezwao akini wowo khawokuwazumiiya. ");
INSERT INTO bou_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mda mcheche Yesu akawalawia wahina kumi dimwe na mwenga wekuwaho hamwe wakada khande. Akawaakia muno kwaajii ya kwesekuzumiiya kwao na khani zao, mana khawokuwazumiiya wada wekuwao wamwona bada ya kuyuyuka. ");
INSERT INTO bou_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aho akawamba, “Hitani mwe inusi yose mkabiikie Mbui Yedi kwa wantu wose. ");
INSERT INTO bou_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mwendaazumiiye na kubatizwa endaaoholwe. Mwesekuzumiiya endaaamuiiwe. ");
INSERT INTO bou_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na vihii ivi vyenda vitongeane na wada wazumiiyao kwa zina dangu. Wenda walavye mazaiko na wendawatamwiiye kwa vitamwiiwavyo vihya. ");
INSERT INTO bou_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wendawatoze nyoka au kudomea kintu chochose cha kukoma khakina kiwakome, wendawawaikie watamu mikono nao wendawahone.” ");
INSERT INTO bou_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Naho Zumbe Yesu ekubindaho kugombeka nao akadoigwa kwe maangwi akekaa phande ya kuume ya Muungu. ");
INSERT INTO bou_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wahina wakaita wakabiikia kia hantu, Zumbe akagosoa ndima hamwe nao kuika vitana mbui izo kwa vihii vyekutongeanavyo nao.");
INSERT INTO bou_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkuu Teofilo. Kwaviya, wantu wangi wekaa na kuandika mbui ziya zekulawiiyazo umu mwetu. ");
INSERT INTO bou_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Waandika inga tekugombekwavyo na wada wekuonao mbui izo kwa meso yao kuvokea aho bosi mwe ndima ya Yesu. Awo nee wekubiikiyao mbui ya Yesu. ");
INSERT INTO bou_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ivyo mkuu Teofilo, tekubindaho kusunguumanya mbui inu kwa akii kuvokea aho bosi, khiona ni vitana na miye nikuandikie mbui izi kwa vitana, ");
INSERT INTO bou_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nawe udahe kumanya ukwei wa mbui zose wekuhinywazo. ");
INSERT INTO bou_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kisingi Helode ekuwaho seuta wa si ya Yudea nekuwa na mviki yumwe zina dakwe Zakalia, wa kizumwezumwe cha uviki cha Abiya. Mkaziwe nee aketangwa Elizabeti, nae nekawa wakolwa da mviki Haluna. ");
INSERT INTO bou_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose waidi wekaa inga viya wekukundigwavyo ni Muungu, wekaa kwa kutongea miko na miagiiyo yose ya Zumbe kwesaho waa. ");
INSERT INTO bou_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Khawokuwa na wana kwaviya Elizabeti nee khana uvyazi, na wose waidi nee ni wadaa. ");
INSERT INTO bou_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Msi umwe, Zakalia yekuwaho zamu yakwe ya kugosoa ndima ya uviki mwe Nyumba ya Muungu, ");
INSERT INTO bou_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kulawana na mazweeya ya waviki, Zakalia akasagulwa kwa kutoewa kula kwengiya mwe Nyumba ya Zumbe kufukiza ubani. Ivyo Zakalia akengia mwe Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zumwezumwe kuu da wantu nee wakintana chongoi wakavika kisingi icho cha kufukiza ubani. ");
INSERT INTO bou_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mndima wa uko uwanga kwa Muungu wa Zumbe akamwawiiya uko gati, akagooka phande ya kuume wa ingo da kufukizia ubani. ");
INSERT INTO bou_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia ekumuonaho yuda mndima wa uko uwanga kwa Muungu, akavituka na akaogoha muno. ");
INSERT INTO bou_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iya mndima wa uko uwanga kwa Muungu akamwamba, Zakalia, “Usekuogoha Kwaviya Muungu kautegeeza uviki wako, na mkazio Elizabeti endaakuvyaiye mwana kigosi, nawe wendaumwetange zina dakwe Yohana. ");
INSERT INTO bou_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nawe wendauwe na kinyemi kikuu na wantu wose wendawawe na kinyemi kwaajii ya kuvyaigwa kwakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Endaawe mkuu hemeso ya Zumbe. Khanaadomee divai wala phombe, naho endaamemeezwe Muye wa Muungu kuvokea mwe ifu da mami yakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Endaawavuze wantu wangi wa Isilaeli kwa Zumbe Muungu yao. ");
INSERT INTO bou_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Endaamwongwee Zumbe, naho endaawe na udaho na muye inga viya Eliya. Endaawaike hamwe vituhu tate na wana wao, endaawagoswee wesaokuzumiiya wawe na umanyi wa wantu wedi, na kumwiikia Zumbe wantu wendaowawe tayali kumhokea.” ");
INSERT INTO bou_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia akamwamba yuda mndima wa uko uwanga kwa Muungu, “Nendanimanye viivihi mbui inu ati niya kwei? Kwaviya miye ni mdaa, naho mkazangu nae ni mdaa.” ");
INSERT INTO bou_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mndima wa uko uwanga kwa Muungu akamtambaisa, “Miye ni Gablieli, mndima wa Muungu na khiagiiwa nitamwiiye nawe nikwambe mbui yedi. ");
INSERT INTO bou_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kwaviya khwekuzumiiya mbui zangu zendazozilawiiye kwa kisingi chakwe. Ivyo khaunaudahe kutamwiiya adi ayo nekugombekayo yendahoyaiganie.” ");
INSERT INTO bou_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kisingi kiya, wada wantu wekuwao wakamhafiiza Zakalia uku wahondomaa kwa kucheewa kulawa kwakwe mwe Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ekulawaho chongoi khekudaha kutamwiiya kwaajii nekawa akatamwiiya nao kwa utangio. Wantu wakamanya kinagaubaga kuna ekuonado mwe Nyumba ya Muungu. Kwaviya nee atamwiiya nao kwa mikono. ");
INSERT INTO bou_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zamu yakwe ya kugosoa ndima yakwe yekusiaho, akauya kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kisingi kwemboka, Elizabeti akenua ifu, nae khekulawa kaya kwakwe kwa kisingi cha miongo mishano. ");
INSERT INTO bou_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Akagombeka, “Zumbe ivi nee ekunigosweeavyo kisingi iki, kanikauwa na kuniusia soni yangu ya kwesekuvyaa nekuwayo nayo hemeso ya wantu.” ");
INSERT INTO bou_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yekubuwaho muongo wa mtandatu, mndima wa uko uwanga kwa Muungu etangwaye Gablieli nekaagiiwa ni Muungu aite kwe mzi zina dakwe Nazaleti uko si ya Galilaya, ");
INSERT INTO bou_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa mndee yumwe mwenye kiwaa etangwae Malia, mwekuwaye kaombwa na mntu yumwe zina dakwe Yusufu wa kolwa da Daudi. ");
INSERT INTO bou_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mndima wa uko uwanga kwa Muungu akamlawiiya Malia akamuugusa, “Ewe mwekujaiwaye wedi na Muungu, Zumbe yu hamwe nawe.” ");
INSERT INTO bou_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia ekusikiaho mbui izo neawa na maatu, akamamakhanya mbui izi zina mana yani? ");
INSERT INTO bou_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mndima wa uko uwanga kwa Muungu akamwamba Malia, “Usekuogoha kwaviya Muungu kakujaiya wedi wakwe, ");
INSERT INTO bou_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wendawenue ifu, naho wendauvyae mwana kigosi, na zina dakwe wendaumwetange Yesu. ");
INSERT INTO bou_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uyo endaatende mkuu naho endaetangwe Mwana wa Muungu ekuwaye uko uwanga wa vyose. Zumbe Muungu endaamwekhe kigoda cha useuta cha Daudi tati yake. ");
INSERT INTO bou_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Endaawe seuta wa kolwa da Yakobo kwa misi yose kwesiho kisiikizi, naho useuta wakwe khaunauwe na kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia akamtambaisa yuda mndima wa uko uwanga kwa Muungu, “Yadahika viivihi, mbui iyo mana miye nina kiwaa?” ");
INSERT INTO bou_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mndima wa uko uwanga kwa Muungu akamtambaisa, “Muye wa Muungu wendaukwezee, na udaho wa Muungu ekuwaye mkuu wa vintu vyose wendaukugubike inga kizui. Kwaajii iyo mwana endaeavyaigwe endaawe Mng'azi naye endaetangwe Mwana wa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naho umanye Elizabeti nduguyo nae kenua ifu etiho ni mdaa, na isasa ni muongo mtandatu kwakwe, yee ambae wantu wammanya kuwa khadaha kuvyaa, ");
INSERT INTO bou_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kwaviya khahana mbui yesayokudahika kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Naho Malia akagombeka, “Miye ni mndima wa Zumbe, igosoke mbui inga wekugombekavyo.” Yuda mndima wa uko uwanga kwa Muungu akaita. ");
INSERT INTO bou_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mwe kisingi kiya Malia akafunga ntambo kuita kwa kinyionyio mwe mzi umwe weuko mwe miima ya Yudea. ");
INSERT INTO bou_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aho akengia mwe nyumba ya Zakalia akamuugusa Elizabeti. ");
INSERT INTO bou_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ahoaho Elizabeti ekusikiaho uugusi wa Malia mwana mwekuwa mwe ifu dakwe Elizabeti akehituahitua. Naho udaho wa Muye wa Muungu ukamwezea Elizabeti. ");
INSERT INTO bou_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naho akagombeka kwa mgutio mkuu, “Wee kujaiwa kusima wavyee wose, na mwana wendayeumvyae kajaiwa. ");
INSERT INTO bou_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miye nndai hata mmaa wa Zumbe yangu abue hangu? ");
INSERT INTO bou_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nakwamba, vuupu nekutegeezaho uugusi wako mwana mwe ifu dangu akawa nanyemi na kwehituahitua. ");
INSERT INTO bou_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kujaiwa wee mwekuzumiiya kuwa yendayawe kwei yada Zumbe ekugombekayo.” ");
INSERT INTO bou_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia akamba. “Muye wangu wamtogoa Zumbe, ");
INSERT INTO bou_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Muye wangu unanyemi kwaajii ya Muungu Mwohozi yangu, ");
INSERT INTO bou_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwaajii kanikumbuka, miye mndima wakwe mdodo! Ivyo kuvokea isasa wantu wose, wendawanetange mwenye kujaiwa, ");
INSERT INTO bou_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwaviya Muungu mwenye udaho, kanigosoeya mbui khuu. Zina dakwe ni ng'azi. ");
INSERT INTO bou_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mbazi zakwe kwa wantu wamvikiao, Kwekaa kwa vyekuvyaigwavyo na vyekuvyaigwavyo, ");
INSERT INTO bou_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kagosoa mbui khuu kwa mkono wakwe, Kawasambaatisha wenao vibui umamakhanyi ya mioyo yao. ");
INSERT INTO bou_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Akawaseeza maseuta wakuu kulawa he vigoda vyao vya useuta, Kawenua wekuwao wadodo. ");
INSERT INTO bou_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wenaosaa endaaweguse vintu vitana, Na wenye vintu vingi endaawause mikono yebue. ");
INSERT INTO bou_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kamwambiza Isilaeli, mndima yakwe, Akakumbuka kuwafiiya mbazi. ");
INSERT INTO bou_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Inga ekuwaikiavyo kiaga baba zetu, Ibulahimu Na vyekuvyaigwavyo vyakwe misi yose kwesiho kisiikizi!” ");
INSERT INTO bou_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia akekaa na nduguye Elizabeti kwa kisingi kibuacho miongo mitatu, naho akauya kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kisingi cha kwefungua kwakwe Elizabeti kikabua, akefungua mwana kigosi. ");
INSERT INTO bou_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wantu wa hehi yakwe na wanduguze wekumanyaho mbui inu ati Zumbe kamfiiya mbazi muno, wakawa na kinyemi hamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana ekubuwaho msi wanane wakeza kumgwisa. Wakakunda kumwetanga Zakalia zina da tati yakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Akini mami yakwe akamba, “Khivyo! Zina dakwe endaetangwe Yohana.” ");
INSERT INTO bou_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wakamwamba, “Khahana yoyose mwe kolwa dako mwe zina inga ido?” ");
INSERT INTO bou_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naho wakamwamba kwa ntangio ya mikono tati yakwe, wamanye mwana endaekigwe zina dani. ");
INSERT INTO bou_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia akaombeza kibao cha kuandikiya, akaandika ivi, “Zina dakwe ni Yohana.” Wose wakahondomaa! ");
INSERT INTO bou_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ahoaho Zakalia akadaha kutamwiiya vituhu, naho akavoka kumtogoa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wantu wahehi yakwe wose wakaogoha muno, na mbui iyo ikaambazika kiya hantu mwe miima ya si ya Yudea. ");
INSERT INTO bou_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na wose wekusikiaho mbui iyo, wakamamakhanya mwe mioyo yao na kweuza, “Mwana uyu endaawe mntu yevii vihi?” Kwaajii udaho wa Zumbe neuwa hamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia tati yakwe da Yohana, akezewa na udaho wa Muye wa Muungu, naye akatamwiiya uwoni unu. ");
INSERT INTO bou_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atogolwe Zumbe Muungu wa Isilaeli! Kwaajii kawezea na kuwaohowa wantu wakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katekha mwohozi mwenye udaho, Uvyaigwa wa Daudi mndima wakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Katiikia kiaga aho kae, kwa sia ya waoni wang'azi, ");
INSERT INTO bou_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kamba endaatiohowe kulawa kwa wamasa wetu. Na kulawa kwa wada wose wesaokutikunda. ");
INSERT INTO bou_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akagombeka endaawaonee mbazi wadaa wetu Na kukumbuka diyagane dakwe ng'azi. ");
INSERT INTO bou_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kiaga ekumwekhacho Ibulahimu baba yetu. ");
INSERT INTO bou_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tioholwe mwe mikono ya wamasa wetu, Tidahe kumgosoeya ndima kwesaho kuogoha. ");
INSERT INTO bou_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ili tiwe wazumizi kwa Muungu, na kuwa wantu wategeezao miagiiyo yakwe. Misi yose ya ugima wetu. ");
INSERT INTO bou_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nawe mwanangu, wendawetangwe Muoni wa Muungu ekuwaye uko uwanga wa vintu vyose, Wendaumuongwee Zumbe ukamuikie Vitana sia yakwe. ");
INSERT INTO bou_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wendauwabiikie wantu kuwa wendawaoholwe Kwa kuekewa mavigaviga yao. ");
INSERT INTO bou_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ukundiso wa Muungu na mbazi zakwe zating'azia inga zua diawiado kulawa uwanga. ");
INSERT INTO bou_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kwetu swie he kiza na kizui cha ufe, na ung'azi unu wendautumwikie na kutuongweeya mwe sia ya uivanisa.” ");
INSERT INTO bou_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yuda mwana neakuwa kimo na udaho wa muye. Akekaa he kiwawe adi ekweaviizavyo kwa wantu wa Isilaeli. ");
INSERT INTO bou_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kisingi kiya Kaisali Agusto, Seuta mkuu wa Walumi kaagiiya wantu wose wa inusi wa useuta wa Lumi wataaziwe. ");
INSERT INTO bou_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kutaaziwa uko nekuwa kwa bosi, aho Kileniyo ekuwaho mkuu wa mzi wa Siliya. ");
INSERT INTO bou_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wantu wose wakaita kutaaziwa, kiya mntu mwe mzi wakwe ekuvyaigwaho. ");
INSERT INTO bou_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu naye akahauka kulawa mwe mzi wa Nazaleti si ya Galilaya, kwaviya nekawa wa uvyaigwa wa Daudi akaita Betilehemu mwe mzi wa Yudea ekuvyaigwaho Seuta Daudi. ");
INSERT INTO bou_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akaita kwe kutaaziwa hamwe na Malia ekuwaye kamuomba, na Malia mwenye nee anaifu. ");
INSERT INTO bou_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wekuwaho uko Betilehemu, msi wakwe Malia wa kuvyaa neibua. ");
INSERT INTO bou_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nee avyaa mwanawe wa bosi, mwana kigosi akamvika nguo za kiteke, akamgoneza mwe dewa da kudiiya ng'ombe kwaajii khawekupata phasi mwe nyumba zakugona wageni. ");
INSERT INTO bou_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mwe si ida neekuwa na waisi wekuwao wacheeza, wakainda matintimo ya ngoto na kiyo. ");
INSERT INTO bou_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mndima wa uko uwanga kwa Muungu akalawiiya ahoaho na ukuu wa Zumbe ukawang'azia phande zose, naho wakaogoha muno. ");
INSERT INTO bou_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mndima wa uko uwanga kwa Muungu akagombeka, “Msekuogoha, khiwaetea mbui yedi yendayoiwatamize wantu wose. ");
INSERT INTO bou_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ivyeo mwe mzi wa Daudi kavyaigwa mwohozi kwaajii yenu, yee nee Zumbe Klistu.” ");
INSERT INTO bou_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inu ne yendayoiwe utangio kwenu, mwendamumbwiiye mwana mteke kazengetezwa magunya na kagonezwa mwe dewa da kudiiya ng'ombe. ");
INSERT INTO bou_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ahoaho zumwezumwe kuu da wandima wa uko uwanga kwa Muungu, wakamtogoa Muungu na kugombeka, ");
INSERT INTO bou_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tunyo kwa Muungu uko uwanga kwa Muungu, Na uivanisa mwe inusi kwa wantu awakundao.” ");
INSERT INTO bou_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wandima wa uko uwanga kwa Muungu wakahauka na kuuya uwanga kwa Muungu, wada waisi wakagombekana mbui, “Titeni mwe mzi wa Betilehemu tikakauwe ido dekulawiado, Zumbe ekutigombekado.” ");
INSERT INTO bou_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Naho wakaita kinyio, wakambwiiya Malia na Yusufu hamwe na yuda mwana mteke kagonezwa mwe dewa da kudiiya ng'ombe. ");
INSERT INTO bou_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waisi awo wekumuonaho uyo mwana wakagombeka wavyazi wakwe mbui zose wekwembiwazo na wandima wa uwanga wa Muungu kuusu uyo mwana. ");
INSERT INTO bou_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wose wekusikiaho ayo nee wahondomaa uwanga ya mbui izo wekugombekwazo na waisi. ");
INSERT INTO bou_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Malia akaika mbui izo mwe moyo wakwe na kumamaakhanya muno. ");
INSERT INTO bou_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wada waisi wakauya, wakamtunya na kumtogoa Muungu kwa yose wekutegeezayo na kuona, kwaviya yose neyawa inga wekuwavyo wembigwa na mndima wa uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yekubuwaho msi wa nane, kisingi cha kumgwisa mwana chekubuwaho, wakamwekha zina da Yesu, zina ambado kekhigwa na mndima wa uko uwanga kwa Muungu kisingi Malia khazati kwenuwa ifu. ");
INSERT INTO bou_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Misi yekubuwaho kwa Yusufu na Malia kusuntwa inga wekukundigwavyo na miagiiyo ya Musa ekwekhigwazo ni Zumbe, wavyazi awo wakamdoa mwana, wakaita naye Yelusalemu na kumwiika hemeso ya Zumbe. ");
INSERT INTO bou_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inga viya yekuandikwavyo mwe miagiiyo ya Zumbe, “Kiya mvyaigwa wa bosi wa kigosi endaawe wa Zumbe.” ");
INSERT INTO bou_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naho viyaviya wakaita wakalavya ntambiko, inga yekugombekwavyo mwe miagiiyo ya Zumbe, “Suwa waidi hambu makinda maidi ya njiwa.” ");
INSERT INTO bou_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kisingi kiya uko Yelusalemu nehawa na mntu yumwe zina dakwe Simoni naye nee ni mntu yedi hemeso ya Muungu. Yee nee akakauwiiya kwa hovu uohozi wa Isilaeli na Muye wa Muungu nee uhamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Muye wa Muungu nee kamwekha kiaga khana auye na nyuma adi endahoamwone Zumbe Klistu ekusagulwaye ni Muungu. ");
INSERT INTO bou_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na wavyazi wakwe Yesu wekumweetaho he Nyumba ya Muungu mwana yao wamgosweeya inga yekukundigwavyo na miagiiyo ya Musa. Aho, Muye wa Muungu ukamwoongweeya Simoni akengia he Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni akamhokea mwana mwe mikono yakwe, uku akamtogoa Muungu akamba. ");
INSERT INTO bou_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Isasa Zumbe, kuiganiza kiaga chako, Umwekee mndima yako aite kwa uivanisa. ");
INSERT INTO bou_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwaajii kwa meso yangu khimuona muohozi, ");
INSERT INTO bou_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ambae kumsagua kuwa muohozi wa wantu wa si zose. ");
INSERT INTO bou_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uyu endaawe ung'azi kwa kuwagubuiya wantu wesaokuwa Wayahudi wammanye Muungu, Na kwaajii ya ukuu kwa wantu wako wa Isilaeli.” ");
INSERT INTO bou_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wavyazi wakwe da Yesu nee wahondomaa kwa mbui ekugombekazo Simoni kwaajii ya mwana. ");
INSERT INTO bou_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoni akawajaiya na kumwamba Malia mami yakwe da Yesu, “Mwana uyu endaawe vokeo da kugwa kwa wantu wangi na watuhu kuoholwa wa si ya Isilaeli, naye endaawe utangio kulawa kwa Muungu na wantu wangi wenda waiemee.” ");
INSERT INTO bou_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na ivyo umamakhanyo wa wantu wangi yendayaoneke pwii. Nawe mwenye usungu wekuwao inga paange kai wenda uwoke moyo wako. ");
INSERT INTO bou_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nee kuwa na Muoni mvyee aketwanga Ana, biti Fanueli, wa mbai wa Asheli mvyee uyo nee ni mdaa muno. Nee kekaa na mgosi yakwe kwa myaka mfungate kuvokea ekutegulwaho. ");
INSERT INTO bou_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Naho mvyee uyo ekufiiwaho ni mgosi akasigaa ikedu adi kisingi icho ekuwaho mdaa wa myaka makumi mane na nne. Kisingi icho chose nee akekaa he Nyumba ya Muungu, ehiniza kuda na kuvika kiyo na musi. ");
INSERT INTO bou_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naho akabua saa idaida, akavoka kumtogoa Muungu naye akagombeka mbui za mwana uyo kwa wantu wose wekuwao wamgoja kuona ni viivihii Muungu endavyo awaohoe wantu wa mzi wa Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufu na Malia wekubindao kugosoa yose yekukundigwayo na miagiiyo ya Zumbe, wakauya Nazaleti, mwe mzi wa Galilaya. ");
INSERT INTO bou_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yuda mwana neakuwa, akaendeeya kuwa na udaho, na akamema umanyi, na wedi wa Muungu ukawa hamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wavyazi wakwe Yesu nee wawa na mazweeya ya kuita Yelusalemu kiya mwaka kisingi cha sikukhuu ya Pasaka. ");
INSERT INTO bou_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu ekuwaho na myaka kumi dimwe na mbii, wose wakaita kwe sikukhuu iyo inga yekuwavyo mazweeya. ");
INSERT INTO bou_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aho sikukhuu yekusiaho, wakavoka ntambo ya kuuya kwao, yuda mwana Yesu akasigaa Yelusalemu kwesiho wavyazi wakwe kumanya. ");
INSERT INTO bou_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wakamanya kuwa yuumo mwe zumwezumwe da wantambo, wakaita kutwa ngima, nee wavoka kumwondeza mwe wanduguze na wambuya wao. ");
INSERT INTO bou_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kwaviya khawekumwona, wakauya Yelusalemu kumwondeza ");
INSERT INTO bou_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Msi wa ntatu, wakambwiiya he Nyumba ya Muungu, kekaa gatigati ya wahinyi, awategeeza na kuwauza mbui. ");
INSERT INTO bou_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose wekutegeezaho mbui zakwe wakaondomaa kwaajii ya akii yakwe na ntambaisi zakwe nizaumanyi. ");
INSERT INTO bou_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wavyazi wakwe wekumuonaho wakahondomaa. Mami yakwe akamuuza, “Mwanangu, kwa mbwai kutigosweeya ivyo? Miye na Tati yako nee tikakoondeza kwa usungu.” ");
INSERT INTO bou_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu akawatambaisa, “Kwambwai mwaniondeza? Khamwekumanya nakundigwa nekae mwe nyumba ya Tate yangu?” ");
INSERT INTO bou_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Akini wavyazi wakwe khawekumanya mana ya mbui ekuwagombekayo. ");
INSERT INTO bou_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aho Yesu nee auya hamwe na wavyazi wakwe Nazaleti, akawa awategeeza. Mami yakwe akaika mbui iyo mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naye Yesu akaendeeya kuwa na umanyi na kimo, na akaendeea kukundiswa ni Muungu na wantu. ");
INSERT INTO bou_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa kumi dimwe na shano wa uongweezi wa seuta mkuu Kaisali Tibelio, Pontio Pilato ne kawa mkuu wa si ya Yudea, na Helode ne kawa seuta wa Galilaya na nduguye Filipo nekawa seuta wa hantu ha Ituleya hamwe na Tilakoniti, na Lusania nekawa seuta wa Abilene, ");
INSERT INTO bou_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa newawa Waviki Wakuu wa Muungu. Kisingi icho nei mbui ya Muungu yekumwezeaho Yohana mwana wa Zakalia kwe kiwawe. ");
INSERT INTO bou_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Naho Yohana akaita hantu he mizi yekuhakanayo na zigizigi da mazi Yolodani akabiikia, “Hitukani mkaeke mavigaviga yenu na kubatiizwa, na Muungu endaawaekee mavigaviga yenu.” ");
INSERT INTO bou_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nee ivyo yekuandikwavyo mwe kitabu cha Isaya Muoni wa Muungu, “Mgutio wa mntu wetanga mwenyika ‘Mgosoeyani Zumbe sia yakwe Nyooshani myemboko yakwe.’ ");
INSERT INTO bou_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kiya koongo dendadimemeezwe, Kiya kiima na muima vindavisambazwe, Hekuhotokaho hendahanyooshwe na Sia zesazo kutama zindazigosolwe ");
INSERT INTO bou_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wantu wose wendawauwone uohozi aetao Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aho Yohana neawamba diya zumwezumwe da wantu wose wekubuao wabatiizwe, “Nywinywi uvyazi wa mdudu! Nndai mwekuwahaza mguuke sugusa yezayo? ");
INSERT INTO bou_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Oneshani mbui zenu kuwa mhituka na kubada mavigaviga yenu. Msekuvoka isasa kwegombekea, ‘Iblahimu ni tati yetu.’ Nawambeni kwei, Muungu adaha kuyagosoa maiwe aya yawe wana wa Ibulahimu. ");
INSERT INTO bou_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na hoya diikwa kae mwe mazindo ya miti, ivyo kiya mti wesaokuvyaa matunda matana wendausengwe na kwasigwa mwe moto.” ");
INSERT INTO bou_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zumwezumwe da wantu dikamuuza, “Titende mbwai?” ");
INSERT INTO bou_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohana akawatambaisa, “Mwenye magwanda maidi amwekhe yuda mwesaekuwa na gwanda, mwenye khande atende ivyoivyo.” ");
INSERT INTO bou_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Watoza kodi nao wakeza wabatiizwe wakamuuza, “Mhinyi na swiswi titende mbwai?” ");
INSERT INTO bou_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yee akawamba, “Msekutoza kodi inga mwekuagiiwayo.” ");
INSERT INTO bou_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nawo maasikali wakamuuza, “Swie nasi titende mbwai?” Akawatambaisa, “Msekudoa vintu vya mntu yoyose kwa kumhoka kwesaho kumwahiiya masa kwa uhokho, naho toshekani kwa maiho yenu.” ");
INSERT INTO bou_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wantu wose wekuwao wakauwiya chendachokilawiie, newavoka kweuza mwe mioyo yao kuhusu Yohana, kuwa yee ati nee Klistu ekusagulwaye ni Muungu. ");
INSERT INTO bou_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aho Yohana akawamba wose, “Miye nawabatiiza kwa mazi, akini eza mwenye udaho kusima, miye uyo khifaa katu kuchopoa sigi za sabana zakwe, uyo enda awabatiize kwa Muye wa Muungu na kwa moto. ");
INSERT INTO bou_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana kiheo cha kuhetea khande mwe mikono yakwe, endaakusanye khande yakwe na kuiika mwe taa, na mahehe ayoke moto wesaokukomeka.” ");
INSERT INTO bou_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kulawana na mahinyo matuhu mangi, Yohana akawahembeeza na kuwabiikia wantu Mbui Yedi. ");
INSERT INTO bou_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana akamwakia seuta Helode kwaviya nekamdoa Helodia mvyee wa nduguye na kumtenda mkaziwe na kwajii ya mavigaviga yose ekuwayo agosoa. ");
INSERT INTO bou_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naho Helode akaendeeya na ufyaimi wakwe kwa kumgea Yohana mwe kifungo. ");
INSERT INTO bou_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wantu wose wekubindiizwaho kubatiizwa, na Yesu akabatiizwa, ekuwaho akavika, uwanga kwa Muungu kukavuguka, ");
INSERT INTO bou_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Muye wa Muungu ukamwezea nekawa na mwii inga sua. Mgutio ukategeezeka kulawa uwanga kwa Muungu, “Wee nee mwanangu nikukundisae, nitamiiwae naye.” ");
INSERT INTO bou_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ekuvokaho ndima yakwe nekawa na myaka makumi matatu, na wantu wammamakhanya yee ni mwana wa Yusufu, Yusufu mwana wa Heli. ");
INSERT INTO bou_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli mwekuwa mwana wa Masati, na Masati mwekuwa mwana wa Lawi, na Lawi mwekuwa mwana wa Meleki, na Meleki mwekuwa mwana wa Yanai, na Yanai mwekuwa mwana wa Yusufu, ");
INSERT INTO bou_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Yusufu mwe kuwa mwana Matasia, na Matasia mwekuwa mwana wa Amosi, na Amosi mwekuwa mwana wa Nahumu, na Nahumu mwekuwa mwana wa Hesili, na Hesili mwekuwa mwana wa Nagai, ");
INSERT INTO bou_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Hagai mwekuwa mwana wa Maati, na Maati mwekuwa mwana wa Matasia, na Matasia mwekuwa mwana wa Semei, na Semei mwekuwa mwana wa Yoseki, na Yoseki mwekuwa mwana wa Yoda, ");
INSERT INTO bou_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Yuda mwekuwa mwana wa Yohanani, na Yohanani mwekuwa mwana wa Lesa, na Lesa mwekuwa mwana wa Zelubabeli, na Zelubabeli mwekuwa mwana wa Shealitieli, na Shealitieli mwekuwa mwana wa Neli, ");
INSERT INTO bou_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neli mwekuwa mwana wa Meliki, na Meliki mwekuwa mwana wa Adi, na Adi mwekuwa mwana wa Kosamu, na Kosamu mwekuwa mwana wa Elimadamu, Elimadamu mwekuwa mwana wa Eli, ");
INSERT INTO bou_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Eli mwekuwa mwana wa Yoshua, na Yoshua mwekuwa mwana wa Eliezeli, na Eliezeli mwekuwa mwana wa Yotimu, na Yotimu mwekuwa mwana wa Masati, na Masati mwekuwa mwana wa Lawi, ");
INSERT INTO bou_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Lawi mwekuwa mwana wa Simoni, na Simoni mwekuwa mwana wa Yuda, na Yuda mwekuwa mwana wa Yusufu, na Yusufu mwekuwa mwana wa Yonamu, na Yonamu mwekuwa mwana wa Eliakimu, ");
INSERT INTO bou_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliakimu mwekuwa mwana wa Melea, na Melea mwekuwa mwana wa Mena, na Mena mwekuwa mwana wa Matasa, na Matasa mwekuwa mwana wa Nasani, na Nasani mwekuwa mwana wa Daudi, ");
INSERT INTO bou_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Daudi mwekuwa mwana wa Yese, na Yese mwekuwa mwana wa Obedi, na Obedi mwekuwa mwana wa Boazi, na Boazi mwekuwa mwana wa Salimoni, na Salimoni mwekuwa mwana wa Nashoni, ");
INSERT INTO bou_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Nashoni mwekuwa mwana wa Aminadabu, na Aminadabu mwekuwa mwana wa Adimini, na Adimini mwekuwa mwana wa Alini, na Alini mwekuwa mwana wa Hesiloni, na Hesiloni mwekuwa mwana wa Pelesi, na Pelesi mwekuwa mwana wa Yuda, ");
INSERT INTO bou_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Yuda mwekuwa mwana wa Yakobo, na Yakobo mwekuwa mwana wa Isaka, na Isaka mwekuwa mwana wa Ibulahimu, na Iblahimu mwekuwa mwana wa Tela, na Tela mwekuwa mwana wa Naholi, ");
INSERT INTO bou_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Naholi mwekuwa mwana wa Selugi, na Selugi mwekuwa mwana wa Leu, na Leu mwekuwa mwana wa Pelegi, na Pelegi mwekuwa mwana wa Ebeli, na Ebeli mwekuwa mwana wa Sala, ");
INSERT INTO bou_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala mwekuwa mwana wa Kainamu, na Kainamu mwekuwa mwana wa Alifakisadi, na Alifakisadi mwekuwa mwana wa Shemu, na Shemu mwekuwa mwana wa Nuhu, na Nuhu mwekuwa mwana wa Lameki, ");
INSERT INTO bou_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lameki mwekuwa mwana wa Mesusela, na Mesusela mwekuwa mwana wa Henoki, na Henoki mwekuwa mwana wa Yaledi, na Yaledi mwekuwa mwana wa Mahalaleli, na Mahalaleli mwekuwa mwana wa Kainani, ");
INSERT INTO bou_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Kainani mwekuwa mwana wa Enoshi, na Enoshi mwekuwa mwana wa Seti, na Seti mwekuwa mwana wa Adamu, na Adamu mwekuwa wa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ekulawaho mwe zigizigi da mazi da Yolodani uku kamema Muye wa Muungu, akaongoewa na Muye wa Muungu adi he kiwawe. ");
INSERT INTO bou_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uko nee ageezwa na ibiisi kwa kisingi cha misi makumi mane. Kisingi chose khekuda chochose na bada ya misi iyo akaumwa nsaa. ");
INSERT INTO bou_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibiisi akamwamba, “Ati wee ni Mwana wa Muungu gombekea iwe idi dihituke diwe bumunda.” ");
INSERT INTO bou_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu akamtambaisa, “Iyandikwa, ‘Mntu khanaekae kwa kuda bumunda du.’ ” ");
INSERT INTO bou_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naho ibiisi akamdoa akamwegaa hantu hauwanga akamwoonyesha Useuta wose wa inusi. ");
INSERT INTO bou_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ibiisi akamwamba, “Nenda nikwekhe udaho uwanga ya Useuta wose na vintu vyose, kwaviya vyose nchekhigwa, nadaha kumwekha yoyose nimkundae. ");
INSERT INTO bou_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ukanikintia mavindi na cheni chako kikadonta asi, ivi vyose vyendaviwe mai yako.” ");
INSERT INTO bou_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu akamtambaisa, “Iyandikwa, ‘Wendaumvike na kumkintia mavindi Zumbe Muungu yako na kumgosoeya yee ikedu.’ ” ");
INSERT INTO bou_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibiisi akamdoa adi Yelusalemu he mnaa wa Nyumba khuu ya Muungu, akamwamba, “Ati wee ni Mwana wa Muungu, etambike asi.” ");
INSERT INTO bou_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwaviya Iyandikwa, endaawaagiiye Wandima wa uko uwanga kwa Muungu wakuinde, ");
INSERT INTO bou_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","vituhu, “Wendawakudoe mwe mikono yao, usekweza kwekungwaa muundi mwe iwe.” ");
INSERT INTO bou_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Akini Yesu akamtambaisa, “Iyandikwa, ‘Usekumgeeza Zumbe Muungu yako.’ ” ");
INSERT INTO bou_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibiisi ekubindaho kumgeeza kwa kiya sia, akambada kwa kisingi. ");
INSERT INTO bou_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aho Yesu akauya Galilaya, kamema udaho wa Muye wa Muungu, na mbui zakwe zikaambazika kiya hantu hehi ya mzi uda. ");
INSERT INTO bou_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naye nee akawahinya wantu mwe Nyumba za kukintania Wayahudi, na kiya yumwe akamtogoa. ");
INSERT INTO bou_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Viyaviya, Yesu akaita Nazaleti hantu ekueewaho, na Msi wa Kuhumwiza akengiya mwe Nyumba ya kukintania Wayahudi inga yekuwavyo mazweeya yakwe. Akagooka asome Maandiko ya Muungu kwa mgutio. ");
INSERT INTO bou_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akahokea kitabu cha Muoni Isaya, akakigubua na akabwiiya hantu hekuandikwaho, ");
INSERT INTO bou_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muye wa Zumbe uhamwe nami, Kwaviya kanisagua niwabikiiye, wakiwa Mbui Yedi. Kaniagiiya niwabiikiye wada wekufungwao, mbui ya kuvugwiiwa kwao, Na wada mantuntu wadahe kukauwa vituhu Na kaniagiiya niwaohoe wasuumizwao, ");
INSERT INTO bou_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na kubiikiya kisingi kibua, Zumbe eza kuwaohoa wantu wakwe.” ");
INSERT INTO bou_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naho akakigubika kiya kitabu, akamwekha mndima, naho akekaa. Wantu wose wekuwao mwe Nyumba ya kukintania Wayahudi nee wamfwiiya meso. ");
INSERT INTO bou_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naho akavoka kuwamba, “Maandiko ya Muungu aya mwekutegeezayo yaigania ivyeo.” ");
INSERT INTO bou_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wose wakatamiwa naye, wakahondomaa kwa mbui ntana ekugombekazo. Wakauzana, “Huyu khio mwana wa Yusufu?” ");
INSERT INTO bou_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naye akawamba, haika mwendamnigombeke mtamwiiyo unu, “Mganga ehonye mwenye. Vituhu mwendamgombeke, ‘Yose tekuyategeezayo kuyagosoa kuda Kapelinaumu, yagosoe hanuhanu mwe mzi wako.’ ” ");
INSERT INTO bou_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akaendeea kutamwiiya, “Nawamba kwei, khahana Muoni mzumiiwa mwe mzi wakwe.” ");
INSERT INTO bou_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Akini tegeezani! Kwei, kuwa na wavyee wangi wekufiiwao ni wagosi mwe si ya Isilaeli kisingi cha Eliya. Uwanga kwekufungwaho, kisingi icho fua iyeka kunya kwa kisingi cha myaka mitatu na miongo mtandatu, nekuwa na saa khai mwe si yose. ");
INSERT INTO bou_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ivyo Eliya khekuagiiwa kwa mntu yoyose wa Isilaeli, iya kwa mvyee yumwe ekufiiwaye ni mgosi wa Salepta mwe si ya Sidoni. ");
INSERT INTO bou_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naho, mwe si ya Isilaeli kisingi cha Muoni Elisha nekuwa na wenye utamu wa nyoka wangi, akini khahana yoyose ekusuntwaye iya Naamani mwenyezi wa si ya Shamu. ");
INSERT INTO bou_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wose wekuwao mwe ida Nyumba ya kukintania Wayahudi wekusikiaho ayo nee wakimwa muno. ");
INSERT INTO bou_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wakagooka wakamlavya chongoi ya mzi wao wekuzengwao uwanga ya muima, wakamwegaa hadi mwe kisiikizi cha muima wamwase asi. ");
INSERT INTO bou_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Akini Yesu akemboka ahoaho gatigati ya zumwezumwe da wantu akaita. ");
INSERT INTO bou_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naho Yesu akaseeya Kapelinaumu, mwe mzi wa Galilaya, nee akahinya wantu Msi wa Kuhumwiza. ");
INSERT INTO bou_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wakahondomaa muno kwa mahinyo yakwe, kwaviya nee akahinya kwa udaho. ");
INSERT INTO bou_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na mwe ida nyumba ya kukintania Wayahudi nekuwa na mntu ekuwaye mwekukwewa na zaiko fyaimi, akatoa vuzo kuu. ");
INSERT INTO bou_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Una mbwai na swie, wee Yesu wa Nazaleti? Kweza kutidagamiza? Nakumanya undai. Weye ni Mng'azi wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu akadiwakiya ido zaiko fyaimi akadigombeka, “Nyamaa na umlawe mntu uyu!” Yuda zaiko akamgwisa yuda mntu asi hemeso yao wose, akamlawa kwesao kumuumiza hantu. ");
INSERT INTO bou_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wantu wose wakahondomaa, nee waambizana, “Inu ni mbui yevivihi, kwaviya kwa udaho na nguvu agombeka mazaiko walawe, nao walawa!” ");
INSERT INTO bou_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mbui zakwe Yesu zikavoka kuambazika kiya hantu mwe si ida. ");
INSERT INTO bou_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nealawa mwe ida Nyumba ya kukintania Wayahudi akaita kaya kwa Simoni. Mvyee yumwe, mkwewe da Simoni nekawa na bombom khai, wakamwombeza amhonye ");
INSERT INTO bou_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu akeza akagooka hehi naye akawakia diya bombom, nado dikamwekea. Yuda mvyee akenuka ahoaho, kuwembikia khande. ");
INSERT INTO bou_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zuwa dekuswaho, wose wekuwao na watamu wao mbaimbai nee wegalwa kwakwe, naye akawadonta kwa mikono yakwe, akawahonya. ");
INSERT INTO bou_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mazaiko nee yawalawa wantu wangi wakatoa vuzo wakagombeka, “Wee ni Mwana wa Muungu!” Akini Yesu akawawakia, naho khekukunda wagombeke, kwa viya wammanya yee nee Klistu. ");
INSERT INTO bou_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kioi dakwe keo, Yesu akahauka akaita hantu heikedu. Wantu wawa wakamwondeza. Awo wantu wekubuaho hantu ekuwaho, wakageeza kumuemeza asekuhauka kwao. ");
INSERT INTO bou_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Akini yee akawamba, “Nakundigwa kubiikia Mbui Yedi za Useuta wa Muungu mwe mizi mituhu, kwaviya khiagiiwa kwaajii iyo.” ");
INSERT INTO bou_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nekawa abiikia mwe Nyumba za kukintania Wayahudi mwe mzi wa Yudea. ");
INSERT INTO bou_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Msi umwe, Yesu ekuwaho kagooka khandakhanda ya tondoo da mazi ya Genesaleti, na wantu wangi newamzunguuka uku wakefintafinta, wategeeza mbui ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akoona ngaawa mbii khandakhanda ya tondoo da mazi. Walowa wa samaki newalawa, wasunta nyavu zao. ");
INSERT INTO bou_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu akengia mwe ngaawa mwenga yekuwayo ya Simoni, nee amuombeza Simoni aisogeze mwe tondoo da mazi kulawa mpwani, Yesu akahinya zumwezumwe da wantu uku kekaa mwe ngaawa. ");
INSERT INTO bou_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ekubindaho kuhinya, akamwamba Simoni, “Yegae ngaawa adi mwekiindi, mkazitambike nyavu mdahe kulowa samaki.” ");
INSERT INTO bou_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akamtambaisa, “Zumbe titenda ivyo kio kigima khatokuambua kintu, akini kwaviya kugombeka, nenda nizitambike nyavu.” ");
INSERT INTO bou_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ekubindaho kugosoa ivyo, wakalowa samaki wangi, ivyo nyavu zao zikavoka kudumuka. ");
INSERT INTO bou_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wakawetanga wezwao wekuwao mwe ngaawa ntuhu weze kuwaambiza. Wakeza, wakamemeeza ngaawa zose mbii samaki, zikawa hehi na kuzama. ");
INSERT INTO bou_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo ekuonaho ayo, akakinta mavindi hemeso ya Yesu akamba, “Hauke he meso yangu ee Zumbe, kwaviya mie ni mwenye mavigaviga!” ");
INSERT INTO bou_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni hamwe na weziwe wose wakahondomaa kwa ugenyezi wa samaki wangi viya. ");
INSERT INTO bou_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Viyaviya Yakobo na Yohana, wana wa Zebedayo wekuwao walowa wa samaki weziwe Simoni, Yesu akamwamba Simoni, “Usekuogoha kuvokea isasa wendauwe mlowa wa wantu.” ");
INSERT INTO bou_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naho, bada ya kuzieta zia ngaawa mpwani, wakabada vyose wakamtongea. ");
INSERT INTO bou_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aho Yesu ekuwaho mwe mzi umwewao, mntu yumwe mwenye utamu wa nyoka mwii mgima Yesu akamwona. Naho, mntu uyo akagonea ifu akamwombeza Yesu, “Zumbe, ukakunda wadaha kuning'aza!” ");
INSERT INTO bou_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu akenua mkono, akamdonta na kugombeka, “Nakunda, ng'azika!” Ahoaho akahona utamu wa nyoka. ");
INSERT INTO bou_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu akamwagiiya akamwamba, “Usekumwamba mntu yoyose mbui izi, iya hita mwenga kwa mwenga kwa Mviki, ukalavye lavyo kwa Mviki inga Musa ekuagiiavyo na kuwa uvuhuzi kwa wantu wose kuwa kusuntwa.” ");
INSERT INTO bou_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Akini mbui za Yesu zikaendeeya kuambazika kiya hantu. Mazumwezumwe mangi ya wantu wakakintana kumtegeeza na kuhonywa matamu yao. ");
INSERT INTO bou_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Akini yee akaita hantu hesahokuwa na wantu uko akavika. ");
INSERT INTO bou_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Msi umwe, Yesu nekawa akahinya. Mafalisayo na Wahinya wa Miagiiyo kulawa mwe kiya mzi wa Galilaya na Yudea na Yelusalemu, newekaa aho. Udaho wa Zumbe ne uwa hamwe naye kwaajii ya kuhonya watamu. ");
INSERT INTO bou_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ahoaho wantu wakeza, wamwenua mntu yumwe mwekuhoowa mwii, kagona mwe usazi wakageeza kumwengiza ndani, wamwiike hemeso ya Yesu. ");
INSERT INTO bou_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kwaajii ya zumwezumwe da wantu dekumemado, khawokudaha kubua hehi na Yesu. Ivyo wakabovoa hantu ha chusi yekuwayo uwanga ya hantu ekuwaho Yesu, nee waseeza javi da yuda mwekuhoowa. ");
INSERT INTO bou_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ekuonaho wekuwavyo na uzumizi mkuu, akamwamba mntu uyo, “Mmbuya kuekewa mavigaviga yako.” ");
INSERT INTO bou_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wahinya wa Miagiiyo na Mafalisayo wakavoka kweuza wenye, “Nindai uyu atamwiaye mbui zakufuu? Khahana mntu adahae kuekea mavigaviga iya Muungu ikedu!” ");
INSERT INTO bou_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu akawamanya mamakhanyo zao, akawauza, “Mwamamakhanya mbwai mwe mioyo yenu? ");
INSERT INTO bou_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni dihi dekuhuhado muno Kugombeka, ‘Kuekewa mavigaviga,’ hambu kugombeka, ‘Gooka, uite?’ ");
INSERT INTO bou_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Naho nakunda mmanye kwaviya Mwana wa Mntu ana udaho wa kuekea wantu mavigaviga mwe inusi.” Aho akamwamba uyo mwekuhoowa, “Gooka, doa javi dako, uite kaya.” ");
INSERT INTO bou_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahoaho uyo mntu mwekuhoowa akagooka hemeso ya wose, akadoa usazi wakwe akaita kaya kwake uku amtogoa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wose wakatozwa na umako na kwengiwa ni maatu, nee wamtogoa Muungu wakagombeka, “Ivyeo tiona ntangio.” ");
INSERT INTO bou_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yekwembokaho ayo, Yesu akalawa chongoi akamwona mtoza kodi yumwe etangwaye Lawi, kekaa hantu hakwe hakudoea kodi. Yesu akamwamba, “Nitongea” ");
INSERT INTO bou_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naye akavibada vyose akamtongea. ");
INSERT INTO bou_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naho Lawi akamgosoeya Yesu ntafuno mwe nyumba yakwe, na zumwezumwe kuu dawatoza kodi na wantu wangi wawa wekaa hamwe nae. ");
INSERT INTO bou_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Akini Mafalisayo na Wahinyi wa miagiiyo wakawa wawang'ung'uzikia wahina wakwe na kuwamba, “Kwa mbwai mwada na kudomea na watozao kodi na wenao mavigaviga?” ");
INSERT INTO bou_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akawatambaisa, “Wenye mii mitana khawakunda mganga, wamkundao ni wada wekuwao watamu. ");
INSERT INTO bou_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nchekweza kuwetanga wantu wedi, iya wenye mavigaviga, wadahe kuhituka.” ");
INSERT INTO bou_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wantu watuhu wakamwamba, “Wandima wa Yohana mbatiiza wehiniza kuda kiya maa na kuvika, na wandima wa Mafalisayo wagosoa ivyoivyo. Akini wahina wako wada na kudomea.” ");
INSERT INTO bou_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akawatambaisa, “Wada wagonekwao mwe ndoza khawakundigwa kwehiniza kuda kwaviya Zumbe wa ndoza yu hamwe nao?” ");
INSERT INTO bou_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Akini kisingi chendakibue ambaho Zumbe wa ndoza enda ausigwe gatigati yao, kisingi icho nee wendaho wehinize kuda. ");
INSERT INTO bou_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu akawamba msimo unu, “Khahana mntu asengae kilaka mwe gwanda dihya na kuika mwe gwanda dekusakaado, inga akatenda ivyo endaawe kasenga ido dihya, na kida kilaka cha gwanda dihya khakina chendane na ido gwanda dekusakaado. ");
INSERT INTO bou_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naho wantu khawageya divai mphya mwe mikwiji ya babu yekusakaayo, inga akatenda ivyo iyo divai mphya yendaitatue iyo mikwiji ya babu na divai yendayetike na mikwiji iyo yendaibanike. ");
INSERT INTO bou_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Divai mphya yagewa mwe mikwiji ya babu mihya. ");
INSERT INTO bou_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Khahana mntu atamiwaye kudomea divai mphya bada ya kudomea divai ya kae kwa kugombeka ‘Ida ya kae ni ntana muno.’ ” ");
INSERT INTO bou_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Msi umwe wa kuhumwiza, Yesu nekawa akemboka mwe minda ya uhemba, na wahina wakwe wakavoka kusenga masuke ya uhemba na kuyahugusua mwe mikono yao na kuda. ");
INSERT INTO bou_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wamwe wa Mafalisayo wakawauza wahina, “Kwa mbwai mwagosoa yesayokukundigwa Msi wa Kuhumwiza?” ");
INSERT INTO bou_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu akawatambaisa, “Khamkusoma viya ekugosoavyo Daudi hamwe na wenziwe wekuwaho na saa? ");
INSERT INTO bou_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi nee engiya mwe Nyumba ya Muungu, akadoa yada mabumunda yekuikwayo hemeso ya Muungu akada na kuwekha wenziwe. Na khayokukundigwa mntu yoyose kuda mabumunda ayo, iya Waviki wowodu.” ");
INSERT INTO bou_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu akawamba, “Miye mwana wa Mntu nee Zumbe wa Msi wa Kuhumwiza.” ");
INSERT INTO bou_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Msi mtuhu wa Kuhumwiza, Yesu neengia mwe Nyumba ya kukintania Wayahudi, nee awahinya. Mwe nyumba iyo, nekuwa na mntu ambae mkono wakwe wa kuume neuwa uhooa. ");
INSERT INTO bou_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wahinya wa miagiiyo ya Muungu na Mafalisayo nee wakoondeza kumkoeya masa Yesu, ivyo wakamkauwa kwa hehi ati endaahonye Msi wa Kuhumwiza. ");
INSERT INTO bou_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Akini Yesu akamanya mamakhanyi zao, akamwamba yuda mwe mkono wekuhoao, “Enuka, gooka gatigati yao.” Yuda mntu akagooka gatigati yao. ");
INSERT INTO bou_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Naho Yesu akawamba wada Wahinyi wa miagiiyo na Mafalisayo akagombeka, “Nawauza nywie, kulawana na miagiiyo yetu ni dihi tana kugosoa msi wa kuhumwiza, kugosoa mbui ntana hambu kugosoa mbui ya ufyaimi? Kuohoa ugima hambu kuyadagamiza?” ");
INSERT INTO bou_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Akawafuiya meso phande zose, akamwamba yuda mntu, “Enua mkono wako.” Akawenua mkono wakwe ukawa mgima vituhu. ");
INSERT INTO bou_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wada wakuu wakakimwa muno, wakeambizana wowo kwa wowo, ni viivihi wendacho wamgoswee Yesu. ");
INSERT INTO bou_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Msi umwe Yesu akaita kwe muima kuvika, akacheeza uko kiyo kigima akamvikia Muungu. ");
INSERT INTO bou_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kwekuchaho akawetanga wahina wakwe, nae akasagua kumi dimwe na waidi nee awetanga wagiiwa, ");
INSERT INTO bou_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, yuda Yesu ekumwekhaye zina da Petulo na Andulea nduguye na Yakobo na Yohana na Fiipo na Batolomayo, ");
INSERT INTO bou_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomaso na Yakobo wana wa Alifayo na Simoni ekwetangwaye Zelote mntu mwekuwa mvunizi wa si yakwe, ");
INSERT INTO bou_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana Yakobo na Yuda Isikalioti yuda mwe kumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu ekuseeaho kwe muima hamwe na waagiiwa wakwe, Yesu akagooka hantu ekuwaho tambalale. Aho nekuwa na zumwezumwe kuu da wahina wakwe na zumwezumwe da wantu wekulawao phande zose za si ya Yudea na mzi wa Yelusalemu na mpwani ya mizi ya Tilo na Sidoni, ");
INSERT INTO bou_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wose wakabua kumtegeeza Yesu na kuhonywa matamu yao. Nee awahonya wose wekuwao na mazaiko. ");
INSERT INTO bou_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wantu wose newakunda kumdonta, kwajii ya udaho wekulawao kwakwe na kuwahonya wose. ");
INSERT INTO bou_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu akawahitukia wahina wakwe, akamba, “Mjaiwa nywie wakiwa, kwaviya Useuta wa Muungu ni wenu! ");
INSERT INTO bou_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mjaiwa nywie mwenao saa isasa, Kwa viya msi weza mwendamweguswe, Mjaiwa nywie mwiiyao isasa, Kwaviya misi yezayo mwendamseke kwa kinyemi. ");
INSERT INTO bou_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mjaiwa nywie wantu wendahowawakimwe, na kuwabahuwa, wendawawadumue, na kuwabanangia zina kwaajii ya Mwana wa Mntu. ");
INSERT INTO bou_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aho kae wadaa wenu wagosoa ivyoivyo kwa waoni wa Muungu ivyo yendahoyalawiie kuwani na nyemi na kuvina kwaviya funge yenu ni khuu huko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Akini mmbwii yenu nywie mwenao vintu vingi. Kwaviya mbinda kwekhigwa kae nyemi yenu. ");
INSERT INTO bou_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mmbwii yenu nywie mwegutao isasa, Kwaviya misi yeza mwendamuwe nasaa. Mmbwii yenu nywie msekao kwa kinyemi isasa, Kwaviya misi yeza mwendamuomboleze na kuiya. ");
INSERT INTO bou_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mmbwii yenu nywie hada wantu wose wanitogoao, kwaviya wadaa wao wawagosweeya waoni wa uwokho ivyoivyo. ");
INSERT INTO bou_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Akini nawagombekea nywie mnitegeezao, wakundiseni wamasa wenu, wagosweeni vyedi wada wamikimao. ");
INSERT INTO bou_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wajaiyeni wada wawabadiao lazi, na wavikieni wada wamigosweeyao ufyaimi. ");
INSERT INTO bou_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mntu akakutoa funda dimwe mhituiye dakaidi. Mntu akakuhoka gwanda dako mbadie na shati dako viyaviya. ");
INSERT INTO bou_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mntu akakuombeza kintu mwekhe, na mntu akakuhoka vintu vyako vyose usekukunda akuvuzie. ");
INSERT INTO bou_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mkundavyo wantu wawagoswee nywie, wagosweeni ivyoivyo. ");
INSERT INTO bou_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Na mkawa mwawakundisa wada wawakundao nywie, ivi, mwenda mpate funge dani? Kwaviya hata wenye mavigaviga wawakunda wada wawakundao wowo. ");
INSERT INTO bou_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naho, inga mkawagosweeya mbui ntana, wada du wawagosweeyao matana, mwenda mpate funge dani kwaviya wenao mavigaviga wagosoa ivyoivyo. ");
INSERT INTO bou_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Naho inga mkawekha wada du mkauwiyao wendawamiihe, ivi mwenda mpate funge dani? Hata wenao mavigaviga wawekha wenye mavigaviga wezwao ili wawavuzie kihimo kiyakiya. ");
INSERT INTO bou_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iya nywie wakundiseni wamasa wenu na kuwagosoea mbui ntana, wekheni msekukauwiya kuvuziwa. Naho funge yenu yendaiwe khuu, nanywi mwenda muwe wana wa Muungu mwe uko uwanga kwa Muungu. Kwaviya yee ni mng'azi kwa wada wesao ntogoo na wafyaimu. ");
INSERT INTO bou_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kuwani na mbazi inga Tate yenu ekuwavyo na mbazi. ");
INSERT INTO bou_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Msekuwekha sugusa watuhu, na nywie mwenda mwekhigwe sugusa, msekuwalaumu watuhu, na nywie khamna mlaumiwe, waekeni watuhu, nanyi mwenda muekewe. ");
INSERT INTO bou_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wekheni watuhu vintu, nanyi mwendamwekhigwe. Eehe, mwendamhokee he mikono yenu kihimo chekumemacho, na kuomoewa na kwetika etika. Kwaviya kihimo kiyakiya muhimiacho kwa watuhu nee endachoahimie Muungu kwenu.” ");
INSERT INTO bou_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu akawamba msimo unu akawauza, “Ivi tuntu adaha kumuongweeya tuntu mweziwe?. Eehe wose waidi wenda wengie mwe tubwi” ");
INSERT INTO bou_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mhina khamwemboka mhinyi wakwe, akini kiya mhina akabinda kuhinywa awa inga mhinyi wakwe. ");
INSERT INTO bou_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kwa mbwai waona kibasi mwe ziso danduguyo na ahoaho khuona basi mwe sizo dako? ");
INSERT INTO bou_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wadaha viivihi kumwamba nduguyo, ‘Ndugu, goja nikuuse kibasi mwe ziso dako,’ na uku khuona basi mwe ziso dako mwenye? Mbakha weye! Voka kulavya basi deumo mwe ziso dako, na aho nendiho wendaho uwone vitana na kudaha kuusa basi dekuwado mwe ziso da nduguyo.” ");
INSERT INTO bou_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mti mtana khauvyaa matunda yesayo kutama, naho mti wesao kutama khauvyaa matunda yatamayo, ");
INSERT INTO bou_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kiya mti wamanyika kwa matunda yakwe. Kwaviya wantu khawatunda tini mwe misongoma wala zabibu mwe miwa.” ");
INSERT INTO bou_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mntu mtana alavya matana kulawa mwe moyo wakwe na mntu mfyaimi hulavya yesayo kutama mwe moyo wakwe, kwaviya mntu ugombeka kulawana na yada yekumemayo mwe moyo wakwe. ");
INSERT INTO bou_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kwambwai mwanetanga, ‘Zumbe, Zumbe’, na uku khamgosoa yada nigombekayo? ");
INSERT INTO bou_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nendaniwaonyeshe ni viivihi eivyo mntu yuda ezae kwangu na kutegeeza mbui zangu na kuzigosoa. ");
INSERT INTO bou_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uyo aigana na mntu azengaye nyumba, mwekufuka asi na kuika msingi wakwe uwanga ya iwe na yakalawiiya mafuiko ya zigizigi da mazi, mfeeji wa mazi ukaitoa ida nyumba, iya khaidaha kusingisika, kwaajii nee iwa izengwa vyedi. ");
INSERT INTO bou_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akini yoyose ategeezaye mbui zangu na akesekugosoa chochose, uyo aigana na mntu ekuzengaye nyumba uwanga ya msanga kwesiho kuika msingi. Mafuiko ya zigizigi da mazi neyalawiiya, mfeeji wa mazi ukaitoa nyumba ida, ikagwa na kubanika na kubondekabondeka.” ");
INSERT INTO bou_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu ekubindaho kugombeka mbui yedi kwa wantu, akengia mzi wa Kapelinaumu. ");
INSERT INTO bou_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Uko nekuwa na mkuu yumwe wa asikai wa Kilumi neekawa na mndima wakwe, neakamkundisa muno. Uyu mndima nekawa mtamu hehi na kuuya na nyuma. ");
INSERT INTO bou_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkuu wa asikai wa Lumi ekusikiaho mbui za Yesu, neawaagiiya wadaa wa Kiyahudi, wakamwombeze eze amhonye mndima uyo wa mkuu wa Lumi. ");
INSERT INTO bou_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wekubuwaho kwa Yesu, ne wamhembeeza muno, wakamba, “Mntu huyu afaa kuambizwa, ");
INSERT INTO bou_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwaajii yee aikundisa si yetu, na nee mwekutizengea ida Nyumba ya kukintania Wayahudi.” ");
INSERT INTO bou_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naho, Yesu akaita hamwe nao. Ekuwaho hehi na kubua kwe nyumba ya yuda mkuu wa maasikai, yuda mkuu wa masikai wa Lumi akawaagiiya wambuya wakwe wamwambe Yesu, “Zumbe, usekwepisha muno, kwaviya miye khifaa weye wengie mwe nyumba yangu. ");
INSERT INTO bou_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Naho miye nchekweona inga nafaa kweza kwako. Akini gombeka mbui du, na mndima yangu enda ahone. ");
INSERT INTO bou_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwamana hata miye uwanga yangu kuna wagookezi, na nenao asikai asi yangu. Nikamwamba yumwe ‘Hita,’ naye aita, nikamwamba mtuhu ‘Soo,’ naye eza. Nikamwamba mndima yangu,, ‘Gosoa idi’ nae agosoa.” ");
INSERT INTO bou_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ekusikiaho mbui iyo akahondomaa, naho akahitukia diya zumwezumwe da wantu wekuwao wamuondeza akamba, “Nchekuona mwenye uzumizi inga unu mwe wantu wose wa Isilaeli.” ");
INSERT INTO bou_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Naho wada wantu wekuwao waagiiwa kwa Yesu wekuuyaho kaya nee wambwiiya yuda mndima kahona. ");
INSERT INTO bou_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kisingi kwemboka, Yesu akaita mwe mzi umwe wetangwao Naini. Na wahina wakwe na zumwezumwe kuu da wantu wakaita hamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naho, ekuwaho yu hehi na uvi mkuu wa mzi, wakalawiiya wantu wenua kiimba cha mwana kigosi yumwe, mwana wa ikedu wa mvyee mwekufiiwa ni mgosi. Wantu wangi wa mzi uda neswawa hamwe na uyo mvyee. ");
INSERT INTO bou_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zumbe Yesu ekumwonaho mvyee uyo akamfiiya mbazi, akamwamba, “Usekuiiya.” ");
INSERT INTO bou_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naho akatimia hehi akadidonta diya tusi, na wada wekuwao wadenua wakagooka. Yesu akamba, “Mbwanga, nakwamba enuka.” ");
INSERT INTO bou_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yuda Mbwanga ekuyae na nyuma akenuka na kwekaa, akavoka kutamwiiya. Na Yesu akamwegaa yuda mwana kwa mami yakwe. ");
INSERT INTO bou_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wantu wose wakaogoha muno na kumtogoa Muungu na kugombeka, “Muoni wa Muungu mkuu kalawiiya gatigati yetu. Muungu keza kuwaohowa wantu wakwe.” ");
INSERT INTO bou_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbui izo ekuzigosoazo Yesu zikaambazika kose mwe si ya Yudea na mizi yose ya hehi. ");
INSERT INTO bou_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wahina wa Yohana Mbatiiza wakamwamba Yohana mbui izo zose ekugosoazo Yesu. Nee Yohana awetanga wahina wakwe waidi, ");
INSERT INTO bou_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nee awagiiya kwa Zumbe Yesu wamuuze, “Wee nee yuda tekuwaye tikamkauwia, hambu tigoje mtuhu?” ");
INSERT INTO bou_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wada wahina wekumbwiiyaho Yesu wakamwamba, “Yohana mbatiiza katiagiiya kwako tikuuze, ‘Wee nee yuda mwekuwa tikamkauwia, hambu tigoje mtuhu?’ ” ");
INSERT INTO bou_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kisingi ichoicho, Yesu nee ahonya wantu wangi wekuwao wasuumizwa ni matamu na wekukwewao na mazaiko na matuntu wangi wakadaha kuona. ");
INSERT INTO bou_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ivyo Yesu akawatambaisa, “Hitani mkamwambe Yohana yada yose mwekuyaonayo na kuyategeeza, matuntu waona, wekuviao miundi wenda, wenye utamu wa nyoka wang'azika, viziba wasikiya, wekuuyao na nyuma wayuyuswa, na wakiwa wabiikiwa Mbui Yedi.” ");
INSERT INTO bou_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kajaiwa mntu yuda ambae khana matumatu nami. ");
INSERT INTO bou_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wahina wa Yohana Mbatiiza wekuhaukaho, Yesu akavoka kugombeka na diya zumwezumwe da wantu mbui za Yohana Mbatiiza, “Mwekuitaho kwe kiwawe mwona mbwai? Nee ni inde dikasingiswa nkhusi? ");
INSERT INTO bou_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hambu mwita kukauwa mbwai? Nee mwita kumkauwa mntu mwe kuvaa gwanda ntana? Manyeni kuwa wavaao magwanda ya hea nyingi na kwekaa wekazi wa ntunyo na makwasukwasu wekaa mwe mazumba ya maseuta. ");
INSERT INTO bou_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Naho nambiani, mwita koona mbwai? Nee mwita kumwona Muoni wa Muungu? Eehe, nkwei akini yee mwekumuonaye kembokesa Muoni. ");
INSERT INTO bou_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mwe Maandiko matana Muungu atamwiiya uwanga ya Yohana akamwamba, ‘Yesu kuwa namuagiiya mndima yangu Yohana akuongwee na kukuikia vitana sia yako.’ ” ");
INSERT INTO bou_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu akabiindizia kwa kugombeka, “Nawamba, mwe wantu wekwekaisao mwe inusi khahana ekuwaye mkuu kusima Yohana Mbatiiza. Na ivyo, yuda ekuwaye mdodo mwe Useuta wa Muungu ni mkuu kusima yee.” ");
INSERT INTO bou_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wantu wose wekusikiaho ayo na watoza kodi nee watogoa wedi wa Muungu, aho nee wada wekuwao wauhokea ubatiizo wa Yohana. ");
INSERT INTO bou_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Akini Mafalisayo na wahinyi wa miagiiyo newaemea nteganyi ya Muungu yekukundigwayo wakaemea kubatiizwa ni Yohana. ");
INSERT INTO bou_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu akaendeea kugombeka, “Naho, nendaniwaiganize wantu wa kivyazi iki na kintu chani? Ni wantu wa namna yani? ");
INSERT INTO bou_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ni inga wabwanga wekwekao gwiiyo na kwambizana, kizumwezumwe kimwe na kituhu, ‘Tiwatoea fiimbi wala khamwekuvina, titoa wiya wa bwaimbwo wala kamwekuiya’ ");
INSERT INTO bou_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwaviya Yohana mbatiiza keza, akehiniza kuda na khekudomea divai, nanywi mkamba, ‘Kakwewa ni mazaiko!’ ");
INSERT INTO bou_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Mntu keza, ada na kudomea, nanywi mwamba, ‘Mkauweni uyu ni mmeo na mkozi, ni mmbuya wa watoza kodi na wenye mavigaviga!’ ");
INSERT INTO bou_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na ivyo, umanyi wa Muungu yamanyika kuwa ni ntana kwa wantu wose waizumiiyao.” ");
INSERT INTO bou_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo yumwe nee kamgoneka Yesu kuda khande mwe nyumba yakwe. Na Yesu akengia mwe nyumba ya uyo Mfalisayo, na akekaa kuda khande. ");
INSERT INTO bou_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naho mwe mzi uda nekuwa na mvyee yumwe mwekuwa na mavigaviga. Ekusikiaho Yesu yuuko mwe nyumba ya uyo Mfalisayo, akadoa nchupa yekugosolwayo na iwe detegwado alabasta yekumemezwayo mavuta matana ya hea nyingi. ");
INSERT INTO bou_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akeza, akagooka hehi ya miundi ya Yesu, akaiya na mesozi yakwe yakamwetikiya Yesu mwe miundi. Uyo mvyee akaihangusa miundi ya Yesu kwa fii zakwe. Naho akaiyumbatia na kuihaka yada mavuta matana. ");
INSERT INTO bou_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayo yuda ekumgonekae Yesu ekuonaho ayo, akamamaakhanya mwe moyo wakwe, “Inga mntu uyu nee ni muoni wa Muungu wa kwei nee kamanya mvyee uyu niwa viivihi, ni mwenye mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu akamwamba uyo Mfalisayo, “Simoni, nna mbui ya kukugombeka.” Naye Simoni akamwamba, “Eehe! Mhinyi, nigombeka.” ");
INSERT INTO bou_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Wantu waidi newawa wamkopa mntu hea. Yumwe nee kamwekha vintii vya madini ya feza mia shano, na mtuhu vintii vya madini vya feza elufu shano. ");
INSERT INTO bou_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wekuvotwaho kuiha madeni yao. Uyo mntu wakaekewas wose waidi. Isasa ni yuhi gati ya aho waidi enda amkundise muno zumbe?” ");
INSERT INTO bou_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni akamtambaisa, “Ni kwei yuda ekuekeewaye deni kuu endaamkundise yuda zumbe.” Yesu akamwamba, “Ni kwei.” ");
INSERT INTO bou_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Naho akamhitukia yuda mvyee na kumwamba Simoni, “Wamwona mvyee uyu? Aho miye nekwengiaho hanu he nyumba yako khwekunekha mazi ya kusunta miundi yangu, akini mvyee uyu kanisunta miundi yangu kwa mesozi yakwe na kunihangusa kwa fii zakwe. ");
INSERT INTO bou_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wee khwekuniugusa kwa kuniumbatia, akini mvyee uyu kuvokea nekwengiaho hanu kawa akaumbatia miundi yangu. ");
INSERT INTO bou_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wee khwekunionyesha untana wako kwa kunihaka mavuta ya mzaituni mwe mtwi, akini uyu mvyee katenda ivyo kwa kunihaka mavuta matana mwe miundi yangu. ");
INSERT INTO bou_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa iyo nakwamba kaekewa mavigaviga yakwe kwaviya kaonesha ukundiso mkuu. Mwenye kuekewa vidodo mavigaviga, kakundisa vidodo.” ");
INSERT INTO bou_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aho, Yesu akamwamba yuda mvyee, “Kuekewa mavigaviga yako.” ");
INSERT INTO bou_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naho wada wekuwaaho wekaa hamwe wakauzana, “Ni ndai uyu adahaye kuekea mavigaviga?” ");
INSERT INTO bou_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naye Yesu akamwamba yuda mvyee, “Uzumizi wako ukuohowa, hita kwa uivanisa.” ");
INSERT INTO bou_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yekwembokaho ayo, Yesu nee kemboka mwe mizi na mizi akabiikia Mbui Yedi za Useuta wa Muungu. Wada wahina kumi dimwe na waidi wakatongeana naye. ");
INSERT INTO bou_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hamwe na wavyee watuhu Yesu ekuwalavyao mazaiko na kuwahonya matamu, wakatongeana naye. Awo nee wakina Malia mwekwetangwae Magidalene, mwe kuavigwa mazaiko mfungate, ");
INSERT INTO bou_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana na mkaza Kuza, mndima mkuu wa Helode na Susana na wavyee watuhu. Awo wavyee nee wakamgosweeya ndima kwa vintu vyao vyose Yesu hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kisingi kimwe zumwezumwe kuu da wantu nediwa dakintana, na wantu nee wamwezea Yesu kulawa kwe kiya mzi. Na Yesu akawamba msimo unu. ");
INSERT INTO bou_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mhasi kenda kuhanda mbeyu zakwe. Ekuwaho aketia mbeyu ntuhu zikagwa mwe sia, na wemboka sia wakazijata na wadege wa uwanga wakazida. ");
INSERT INTO bou_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ntuhu zikagwa mwe uongo wekuwao na maiwe, na zekuhotao zikanyaa kwaajii ya kwesekuwa na uwisiuwisi. ");
INSERT INTO bou_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeyu ntuhu zikagwa kwe miti ya misongoma, na ida miti ya miwa yekuhotaho hamwe nazo nakuzifintafinta iyo mitengea ikanyaa. ");
INSERT INTO bou_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ntuhu nezigwa mwe sanga wenye khande, zikahota na kuvyaa vitana.” Ekubindaho kugombeka ayo, Yesu akalavya mgutio, akamba, “Mwenye magutwi na ategeeze!” ");
INSERT INTO bou_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wahina wakwe Yesu wakamuuza mana ya msimo uwo. ");
INSERT INTO bou_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naye akawatambaisa, “Nywinywi mwekhigwa umanyi wa kumanya ukwei wa Useuta wa Muungu ambao aho kae khawekumanyika akini isasa uikwa pwii, akini awo watuhu wendawembigwe kwa misimo, wakakauwa wasekudaha kuona, na wakategeeza wasekumanya.” ");
INSERT INTO bou_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mana ya msimo unu ni inu, Mbeyu ni mbui ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ziya zekugwazo mwe sia zaonyesha wantu wada wategeezao ida mbui, ikaukaaho ibiisi akeza na kudihusa mwe mioyo yao wasekweza kumzumiia na kuoholwa. ");
INSERT INTO bou_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ziya zekugwazo mwe maiwe zaonyesha wada wantu wategeezaho ida mbui wakaihokea kwa kinyemi. Akini inga ziya mbeyu, wantu awo khawana mazindo na mbui iyo khayekaa mwe mioyo yao kwaviya wazumiiya kwa kisingi du, na kisingi wageezwaho kubadana na mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ziya mbeyu zekugwazo mwe miti ya miwa ni wantu wada wategeezao ida mbui, akini kisingi si kisingi, wahaukao wafintwafintwa na maatu, na vintu vyao vyose, na wekazi wa kiya msi nao khawakua mwe mbui ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na ziya zekugwazo mwe sanga ntana nee wada wategeezao ida mbui wakaizumiiya kwa moyo mtana na wa kutegeeza. Awo kuzizimiza na kuendeea kugosoa mbui zimkundisazo Muungu. ");
INSERT INTO bou_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wantu khawawasha taa na kuigubika kwa nyungu hambu kuiika mzungui. Akini waika uwanga ya kiango ili wantu wengiaho gati wadahe kuona ung'azi. ");
INSERT INTO bou_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ivyoivyo chochose chekufiswacho chenda kigubulwe, na sii yoyose yesayokumanyika na yendaimanyike pwii. ");
INSERT INTO bou_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kwa iyo, muwe meso mtegeezavyo. Kwaajii yoyose mwenacho endaekigwe na ngeeko, akini yuda mwesena, hata kiya afikiicho anacho, chendakidoigwe.” ");
INSERT INTO bou_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Aho mami yakwe da Yesu na wanduguze wakamwezea, akini khawokudaha kumwezea hehi kwaajii ya zumwezumwe da wantu. ");
INSERT INTO bou_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mntu yumwe akamwamba Yesu, “Mami yako na wanduguzo wagooka chongoi, wakunda wakuone.” ");
INSERT INTO bou_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Akini Yesu akawamba wantu wose, “Mmaa yangu na wandugu zangu ni wada wategeezao mbui ya Muungu na kuditoza.” ");
INSERT INTO bou_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Msi umwe, Yesu nekakwea ngaawa hamwe na wahina wakwe, akawamba, “Tidumuwe ntondoo da mazi tiite adi phande ya kaidi.” Naho, wakavoka ntambo. ");
INSERT INTO bou_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ekuwaho wakatamba kwa ngaawa iyo, Yesu akagona. Ahoaho khusi khai ikavoka kuvuma, mazi yakavoka kwengia mwe ngaawa, newawa hehi na kudagamia. ");
INSERT INTO bou_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wada wahina wakamtimia Yesu, wakamwenua wakamwamba, “Zumbe, Zumbe! Tadagamia!” Yesu akenuka akaiwakia ida khusi na mkubwaniso wa mazi, navyo vikatwiiya, nee kwatuiiya. ");
INSERT INTO bou_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naho akawamba, “Uzumizi wenu u hahi?” Akini wowo wakatozwa ni umako na kuogoha uku wakagombekana, “Uyu ni ndai, ata agiiya khusi na mkubwaniso wa mazi, navyo vyamtegeeza?” ");
INSERT INTO bou_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Waendeeya na ntambo, wakabua mpwani ya si ya Wagelasi zekuhakanazo na ntondoo da mazi da Galilaya. ");
INSERT INTO bou_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ekuwaho aseeya mpwani, mntu yumwe ekuwaye kakwewa na mazaiko akamwezea kulawa he mzi uda. Kwa misi mingi mntu uyo kheekuwa akavaa magwanda, wala khekuwa akekaa mwe nyumba iya mwe mambiya. ");
INSERT INTO bou_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ekumuonaho Yesu, aketambika ahosi hemeso yakwe na kugombeka kwa mgutio mkuu, “Wee Yesu Mwana wa Muungu ekuwaye uko uwanga, una mbui yani na miye? Nakuhembeeza usekunisumiiza!” ");
INSERT INTO bou_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nee kamba ivyo kwaviya Yesu nekamwamba uyo zaiko amlawe mntu uyo. Zaiko ido ne dikamkwea mntu uyo maa kwa maa, na etiho wantu wamuika ndani na kumzengeteza kwa minyololo na mphingu, akini kiya maa akazidumua mphingu izo, akegalwa na zaiko ido adi he kiwawe. ");
INSERT INTO bou_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naho, Yesu akamuuza, “Zina dako ni ndai?” Yee akamtambaisa. “Zina dangu ni ‘Hindoo’ ” kwaajii mazaiko mangi nee yammema. ");
INSERT INTO bou_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ayo mazaiko wakamhembeeza Yesu asekuwegaa tubwi dilehado desado kuwa na kisiikizi. ");
INSERT INTO bou_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hantu aho nekuwa na tintimo kuu da nguuwe wakaiswa mwe mpolomoko wa muima. Naho ayo mazaiko wakamhembeeza awabade wawengie wada nguuwe. Naye Yesu akawabada wawengie. ");
INSERT INTO bou_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kwa iyo mazaiko ayo yakamlawa yuda mntu, yakengia kwa wada nguuwe na wakaseeya kwa kinyionyio mwe uda mpolomoko mkai, wakengia mwe ntondoo da mazi, wakafa. ");
INSERT INTO bou_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wada waisi wekuonaho yose yekuawiiayo wakaguuka, wakaita kuwekha wantu mbui mwe mzi na mwe minda. ");
INSERT INTO bou_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wantu wakeza kukauwa yekulawiiayo. Wakamtimia Yesu, wakamwona yuda mntu mwe kulavigwa mazaiko kekaa hehi na Yesu kavaa magwanda, na akii zakwe zimuuiya, wakaogoha. ");
INSERT INTO bou_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wada wantu wekuonaho ida mbui wakawagombekea wada wantu wekwezaho hada viya yuda mntu mwekuwae na mazaiko ekuoholwavyo. ");
INSERT INTO bou_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wantu wa si ya Gelasi wakaogoha muno. Ivyo wakamuombeza Yesu ahauke. Ivyo Yesu akakwea vituhu ngaawa ahauke. ");
INSERT INTO bou_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yuda mntu mwe kuavigwa yada mazaiko akamhembeeza aite hamwe naye. Yesu akamwemeza, na akamwamba, ");
INSERT INTO bou_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uya kaya ukawambe yose Muungu ekukugosweyavyo.” Aho, yuda mntu akaita akabiikia kiya hantu mwe mzi uda mbui zose Yesu ekumgosweyavyo. ");
INSERT INTO bou_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu ekuuyaho phande ya kaidi ya ntondoo da mazi, zumwezumwe da wantu dikamhokea, kwaviya wose nee wakamgoja. ");
INSERT INTO bou_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aho akeza mntu yumwe zina dake Yailo, muongoezi wa Nyumba ya kukintania Wayahudi, nee etambika he meso ya Yesu, akamhembeeza aite kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kwaajii ni mwana waikedu wa kivyee, mwenye myaka kumi dimwe na mbii, nekawa yu hehi na kuuya na nyuma. Yesu ekuwaho akaita wantu ne wamfintafinta kiya phande. ");
INSERT INTO bou_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kuwa na mvyee yumwe gatigati ya diya zumwezumwe da wantu, nekawa akalawa phome kwaviya nekawa na utamu wa mtuo kwa kisingi cha myaka kumi dimwe na mbii. Naho nekabinda vintu vyakwe vyose kwa waganga, khahana ekudahae kumhonya. ");
INSERT INTO bou_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uyo mvyee ne amtongea Yesu nyuma, akadonta msao wa gwanda dakwe. Ahoaho, akahonywa utamu wakwe wakulawa phome. ");
INSERT INTO bou_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu akauza, “Nndai mwekunidonta?” Wose wakaemea wakamba khahana mntu ekukudontae. Naye Petulo akamba, “Zumbe, zumwezumwe da wantu wakuikia bunga na kukufintafinta!” ");
INSERT INTO bou_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Akini Yesu akamba, “Kuna mntu kanidonta, mana khimanya kihinya mntu kwa udaho wangu.” ");
INSERT INTO bou_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yuda mvyee ekuonaho khadaha kwefisa, akeaviiza huku akakama kwa kuogoha aketambika hemeso ya Yesu. Aho akawamba wantu wose chekumwekacho kumdonta Yesu na kwaviya ekuhonywavyo vuu puu. ");
INSERT INTO bou_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu akamwamba, yuda mwana kivyee, “Hita kwa uivanisa, kuzumiiya kwako kukuhonya.” ");
INSERT INTO bou_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ekuwaho aendeeya kugombeka, Yailo yuda muongoezi wa nyumba ya kukuntania Wayahudi akaetewa mbui kulawa kaya, “Mwana yako wakivyee kauya kaye na nyuma, usekumpisha Mhinyi.” ");
INSERT INTO bou_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ekusikiaho ayo akamwamba Yailo, “Usekuogoha zumiiya du, naye endaahone.” ");
INSERT INTO bou_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ekubuwaho nyumbani kwa Yailo khawekumbada mntu kwengia ndani hamwe naye, iya Petulo, na Yohana, na Yakobo na wavyazi wa mndee uyo. ");
INSERT INTO bou_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wantu wose nee wakiiya na kuomboeza kwaajii ya uyo mndee ekuyae na nyuma. Aho Yesu akawamba, “Msekuiiya, kwaajii mwana khekuuya na nyuma, kagona du!” ");
INSERT INTO bou_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nawo wakamseka Yesu kwaajii nee wamanya kauya kae na nyuma. ");
INSERT INTO bou_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Akini Yesu akamtoza mkono akamba, “Mwana enuka!” ");
INSERT INTO bou_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Muye wakwe ukamuuwiya, vuu puu akenuka, Yesu akawamba wamwekhe khande. ");
INSERT INTO bou_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wavyazi wakwe nee wahondomaa, aho Yesu akawaemeza wasekumwamba mntu yeyose aya yekugosokayo. ");
INSERT INTO bou_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu nee awetanga wada wahina kumi dimwe na mbii, akawekha udaho wa kuguusa mazaiko yose, na udaho wa kuhonya matamu. ");
INSERT INTO bou_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naho akawagiiya waite kubiikia wantu mbui za Useuta wa Muungu na kuhonya wantu matamu. ");
INSERT INTO bou_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akawamba, “Mwendahomtambe msekudoa chochose, msekudoa ngoda wala jumu, wala khande, wala hea hata gwanda tuhu.” ");
INSERT INTO bou_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yoyose mwendayo mwengie na kuhokewa, ekaani umo hadi mwendaho mhauke mwe mzi uwo. ");
INSERT INTO bou_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wantu wendaho wawaemee kuwahokea, lawani mwe mzi uwo, nanywi mlawaho kung'untani sanga mwe miundi yenu, ili kuwa uvuhuzi kwao. ");
INSERT INTO bou_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naho wahina awo wakavoka kutamba, wakemboka mwe mizi wabiikia wantu Mbui Yedi na kuhonya watamu kiya hantu. ");
INSERT INTO bou_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naye, seuta Helode mgookezi wa si ya Galilaya ekutegeezaho mbui ya yose yekulawiiayo, neawa ni maatu kwaajii wantu watuhu ne wakagombeka kuwa Yohana Mbatiiza kayuyuka. ");
INSERT INTO bou_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Watuhu ne watamwiiya Eliya mwekuwa muoni wa Muungu kalawiiya, na watuhu wakatamwiiya kwamba yumwe wa waoni wa kae kayuyuka. ");
INSERT INTO bou_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode akamba, “Uyo Yohana nekhimsenga mtwi, isasa nndai uyu nitegeezaye mbui zakwe?” Ne awa na hovu ya kumkauwa. ");
INSERT INTO bou_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wada wagiiwa wekuuyaho, wakamgombeka Yesu yose wekuyagosoayo. Yesu akawadoa, wahina wakwe wakaita hikedu mwe mzi wa Betisaida. ");
INSERT INTO bou_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Akini wada wantu wekumanyaho ekuitaho, wakamtongea. Yesu akawahokea ne atamwiiya nao kuusu mbui ya Useuta wa Muungu na akawahonya wada wekukundao kuhonywa. ");
INSERT INTO bou_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zua dekuswaho, wada wahina kumi dimwe na mbii wakamwiitia na kumwamba, “Wabade wantu waite mwe mizi na mwe minda ya hehi wakaondeze khande na hantu hakugona, kwaviya aha teiho ni mwe nyika.” ");
INSERT INTO bou_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu akawamba, “Wekheni nywinywi khande.” Wakamtambaisa, “Khatina chochose iya mabumunda mashano na samaki waidi. Wakunda swie tikawagwiiye khande wantu wose hawa?” ");
INSERT INTO bou_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wekuwaho hada nee ni wagosidu elufu shano. Naho, Yesu akawamba wahina wakwe, “Wagombekeni wantu wekae kwe mazumwezumwe ya wantu makumi mashano.” ");
INSERT INTO bou_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wahina wakagosoa inga wekugombekwavyo, wambeni wantu wose wekae. ");
INSERT INTO bou_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naho Yesu akayadoa yada mabumunda mashano na wada samaki waidi, akakauwa uwanga kwa Muungu na kumtogoa Muungu, akavijaiya, akabendua, akawekha wahina wakwe wawekhe wantu. ");
INSERT INTO bou_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wantu wose wakada na kweguta. Wahina wakadodoa phuguntio za khande, wakamemeeza ngahu kumi dimwe na mbii. ");
INSERT INTO bou_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Msi umwe, Yesu ekuwaho avika ikedu, na wahina wakwe ne wawa hehi naye. Naho akawauza, “Wantu wamba miye ni ndai?” ");
INSERT INTO bou_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nao wahina wakamtambaisa, “Watuhu wamba kuwa wewe ni Yohana mbatiiza, watuhu wamba ni Eliya muoni wa Muungu, na watuhu wamba ni yumwe wa waoni wa kae ambae kayuyuka.” ");
INSERT INTO bou_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aho akawauza, “Na nywinywi, mwamba miye ni ndai?” Petulo akamtambaisa, “Wee nee Klistu ekusagulwaye ni Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu akawawakia wasekumwamba mntu yoyose mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu nee aendeea kugombeka kuwa nlazima Mwana wa Mntu endaasuumizwe na kuemewa na wadaa na waviki wakuu na wahinyi wa miko na kukomwa, akini mwe msi wa ntatu endaayuyuke. ");
INSERT INTO bou_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naho akawamba wantu wose, “Mntu yoyose akundaye kunibasa nlazima eemee mwenye, adoe mhamba wakwe kia msi na anibase. ");
INSERT INTO bou_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwaviya, mntu akundaye kuohowa ugima wakwe mwenye, enda awaze, akini awazae ugima wakwe kwaajii yangu, enda auohoe. ");
INSERT INTO bou_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mntu endaekhingwe myengizo yani ati akekhigwa vintu vyose vya mwe inusi, akini akawaza ugima wakwe mwenye hambu kwedagamiza mwenye? ");
INSERT INTO bou_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mntu akanionea soni miye na mahinyo yangu, Mwana wa Mntu endaamwonee soni mntu uyo kisingi endachoeze mwe Ukuu wakwe na wa Tate na wandima wa uko uwanga kwa Muungu wang'azi. ");
INSERT INTO bou_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nawamba kwei, kuna wamwe wenu aha khawana wauye na nyuma adi aho wendao wauwone Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yekubuwaho msi wa nane bada ya kutamwiiya ayo. Yesu ne awadoa Petulo, na Yohana na Yakobo, akaita nao mwe muima kuvika. ");
INSERT INTO bou_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ekuwaho avika, cheni chakwe kikahituka, na magwanda yakwe ne yakang'ang'azika pee. ");
INSERT INTO bou_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ahoaho wantu waidi wakaawiiya wakatamwiiya nae, nao ne wawa Musa na Eliya, ");
INSERT INTO bou_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ambao walawiiya wakawa wenye ukuu, wakatamwiiya nae kuusu kulawa kwakwe endavyo aiganye uko Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na wenziwe ne wagona fofofo, wekwenukaho, wakoona Ukuu wakwe, na wada waidi wekugokao hamwe nae. ");
INSERT INTO bou_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Naho wantu awo waidi wekuwaho wakahauka, Petulo akamwamba Yesu, “Zumbe ni vyedi swiswi tiaha. Naho tizenge makumbi matatu, dimwe dako, na dimwe da Musa na dimwe da Eliya.” Kwa kwei khekumanya agombeka mbwai. ");
INSERT INTO bou_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo ekuwaho agombeka ayo, vuu puu zunde dikaawiia na kuwagubika na zunde ido dekuwezeaho wada wahina wakaogoha muno. ");
INSERT INTO bou_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mgutio ukategeezeka kulawa mwe ido zunde, “Uyu nee Mwanangu nekumsaguaye, mtegeezeni.” ");
INSERT INTO bou_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wekwembokaho uwo mgutio kutegeezeka, Yesu nekaoneka yu ikedu. Wahina wakanyamaa myee khawokuiyandua mbui iyo, na kisingi kiya khawokumgombekea mntu yoyose mbui izo wekuonazo. ");
INSERT INTO bou_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kioi dakwe Yesu hamwe na wahina wakwe watatu wekuwaho waseeya kuda kwe muima, zumwezumwe kuu da wantu dikakintana na Yesu. ");
INSERT INTO bou_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aho, mntu yumwe mwe diya zumwezumwe akatoa mgutio, akamba, “Mhinyi! Nakuhembeeza umhonye mwanangu wa ikedu. ");
INSERT INTO bou_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maa kwa maa zaiko damkweya, na kumtenda atoe vuzo, naho damgwisa na kumgea ugwa mtwi na kulawa fuo mwe kanwa. Uyo zaiko amsumiiza muno na khadimbada kwa kinyio. ");
INSERT INTO bou_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Khiwaombeza wahina wako wadiguuse akini khawokudaha.” ");
INSERT INTO bou_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu akamba, “Enyi uvyazi wesaho na uzumizi, na chenye mavigaviga nndanekae nanyi na kuwazizimiza adi ini?” Aho akamwamba uyo mntu, “Mwete uyo mwanao hanu.” ");
INSERT INTO bou_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kisingi uyo mwana ekuwaho amwezea Yesu, yuda zaiko neamgwisa asi na kumgea ugwa mtwi. Akini Yesu akamwakia yuda zaiko, na akamhonya yuda mwana na kumwegaa mwana kwa tati yakwe. ");
INSERT INTO bou_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wantu wose wakahondomaa kwa udaho mkuu wa Muungu. Wada wantu wekuaho watozwa ni umako kwa mbui zose ekugosoazo, Yesu akawamba wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tegezani vitana aya niyagombekayo isasa, Mwana wa Mntu endaahitukwe na kugewa mwe mikono ya wantu.” ");
INSERT INTO bou_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Akini wowo khawekumanya mana ya chekutamwiwacho. Mbui iyo iwa ifiswa kwao wasekumanya, nao wakaogoha kumuuza kuusu chekugombekwacho iko. ");
INSERT INTO bou_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Naho wahina wa Yesu wakavoka kuuzana kugombeka ni ndai mkuu gatigati yao. ");
INSERT INTO bou_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu akamanya mamakhanyi zekuwazo mwe mioyo yao, nee amdoa mwana akamuika hehi naye. ");
INSERT INTO bou_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Akawamba, “Yoyose amhokeaye mwana uyu mdodo kwa zina dangu kwaajii anihokeya miye. Na yoyose anihokeaye miye, amhokea yuda mwekuniagiiya. Kwaajii yuda ekuwaye mdodo gatigati yenu, yee ni mkuu kusima wose.” ");
INSERT INTO bou_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana akagombeka, “Zumbe timwoona mntu yumwe alavya mazaiko kwa wantu kwa zina dako ne tamwemeza kwaviya yeye khayuho hamwe naswi.” ");
INSERT INTO bou_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Akini Yesu akamwamba, “Msekumwemeza, kwaviya yoyose mwesekuhigana nanywi yu hamwe nanywi.” ");
INSERT INTO bou_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kisingi chekubuaho hehi Yesu kudoigwa kuita uwanga kwa Muungu, akoona avoke ntambo ya kuita Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naho akawagiiya wagiiwa wamuongoee, nao wakaita wakengia mwe mzi umwe wa wantu Wasamalia wamgoswee kia kintu. ");
INSERT INTO bou_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Akini wenyezi wa mzi uda ne waemea kumhokea kwaviya nekawa akaita Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wahina wakwe, Yohana na Yakobo wekuonaho ayo wakamba, “Zumbe wakunda tiuwagiiye moto kulawa uwanga kwa Muungu uwadagamize?” ");
INSERT INTO bou_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Akini Yesu neawahitukia, na kuwakia. ");
INSERT INTO bou_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wakalawa, wakaita mwe mzi mtuhu. ");
INSERT INTO bou_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wekuwaho watamba mwe sia, mntu yumwe akamwamba Yesu, “Nendanikubase hohose uitako.” ");
INSERT INTO bou_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akamba, “Mbweha wana phanga na wadege wa uwanga kwa Muungu wana masasa, akini Mwana wa Mntu khana hantu ha kugona.” ");
INSERT INTO bou_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naho akamwamba mntu mtuhu, “Nitongea.” Mntu uyo akamba, “Zumbe, nieka nivoke kuita kwe uzisi wa tate.” ");
INSERT INTO bou_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu akamwamba, “Wabade wantu wekuwao wauya na nyuma mwe mioyo yao wazike wekuyao na nyuma wezwao, iya wee hita ukabiikie Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mntu mtuhu akamwamba, “Zumbe nendanikubase, akini eka nkaage wada wekuwao mwe kaya yangu.” ");
INSERT INTO bou_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu akamwamba, “Mntu yoyose atozaye gembe na yutayali kuima na uku akauwa nyuma, khafaa kwa Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yekwembokaho ayo Zumbe akasagua watuhu makumi mfungate na mbii, akawagiiya wandima waidiwaidi wamuongwee mwe kiya mzi ambao yee mwenye ne akakunda kuita. ");
INSERT INTO bou_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akawamba, “Ubosi ni mwingi akini wabondaji ni wacheche, kwa iyo mwoombezeni Zumbe wa ubosi agiiye wantu wakabonde.” ");
INSERT INTO bou_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Isasa hitani, manyeni kuwa nawagiiya nywinywi inga ngoto waitao gatigati ya makui ya mzitui. ");
INSERT INTO bou_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Msekudoa kifuko cha hea, jumu wala sabana, msekumuugusa mntu yoyose mwe sia. ");
INSERT INTO bou_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mkengia mwe kaya yoyose mvoke kuwaugusa ivi, “Uivanisa uwe mwe nyumba inu.” ");
INSERT INTO bou_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akawaaho mntu akundaye uivanisa, ugusi wenu wa uivanisa wenda usigae, ama khivyo uugusi uwo wa utuivu undauwauwie. ");
INSERT INTO bou_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ekaani mwe nyumba iyo mkada na kudomea wendavyo wawekhe, kwaviya mndima afaigwa kwekhigwa kima chake. Msekusama nyumba inu na nyumba ida. ");
INSERT INTO bou_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ati mkabua mzi wowose na wantu wakawahokea, daani wendavyo waviete hemeso yenu. ");
INSERT INTO bou_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Honyani watamu wekuwao uko, wagombekeni wantu, “Useuta wa Muungu u hehi.” ");
INSERT INTO bou_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Akini mkengia mwe mzi wowose, wakesekumihokea, lawani, nanyi mwembokaho mwe sia zao gombekani, ");
INSERT INTO bou_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hata sanga za mzi wenu yekutozananayo, na miundi yetu tayakung'uta iwe tangio ya mavigaviga yenu. Akini manyani kuwa, “Useuta wa Muungu uhehi.” ");
INSERT INTO bou_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kwei nawamba, msi wa kuamuiwa mzi uwo wendawekhigwe sugusa khuu kusima yada mavigaviga ya wantu wa mzi wa Sodoma. ");
INSERT INTO bou_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mmbui yenu wantu wa Kolazini! Mmbwii yenu wantu wa Betisaida, inga vihii vyekugosokazo kwako ati ne vigosoka kuda Tilo na Sidoni, nee wawa wavaa kae magunia na kwesisa mazeu na ili koonyesha kuhituka na kubada mavigaviga yao. ");
INSERT INTO bou_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hata ivyo, msi wakuamuiwa nywinywi mwenda mwekhigwe sugusa khuu kusima ida ya wantu wa Tilo na Sidoni. ");
INSERT INTO bou_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nywie wantu wa Kapelinaumu, “Mweona mwenda mwekhigwe ntogoo adi uwanga kwa Muungu? Eehe, mwendamseezwe adi asi kwe si ya wantu wekuuyao na nyuma.” ");
INSERT INTO bou_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu akawamba wahina wakwe, “Endaeawategeeze nywinywi, anitegeeza miye, na endayeawaemee kuwahokea nywinywi, aemeya kunihokea miye. Na yoyose aemeaye kunihokea, aemea kumhokea yuda ekuniagiiaye ambae ni Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Naho wada makumi mfungate na mbii newauya wamema kinyemi, wakagombeka, “Zumbe hata mazaiko yatutegeeza tekuyawakiaho kwa zina dako.” ");
INSERT INTO bou_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yee akawatambaisa, “Khimwona ibiisi ekuwavyo akagwa inga umweko wa umbauwa kulawa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kauwa khiwekha udaho wa kujata nyoka na visuse, na udaho wose wakumvota yuda mmasa, wala khahana kintu chochose chendachokimizuu. ");
INSERT INTO bou_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naho msekuwa na kinyemi kwaajii mazaiko wamitegeeza, iya kuwani nanyemi kwaajii mazina yenu yaandikwa uwanga kwa Muungu muwe wantu wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saa idaida, Yesu nekawa na nyemi kwa udaho wa Muye wa Muungu, akamba, “Nakutogoa ee Tate, Zumbe wa uwanga kwa Muungu na inusi, kwaajii mbui izi wekuwafisazo wenye akii na umanyi, ukawamanyisa wadodo. Eehe Tate, ne vyekukutamiavyo.” ");
INSERT INTO bou_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ne agombeka, “Tati yangu kanekha vintu vyose. Khahana ammanyaye Mwana iya Tate, wala ammanyaye Tate iya Mwana, na yoyose yuda ambae Mwana endaakunde kumgubuiya.” ");
INSERT INTO bou_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Naho akawabasa wahina wakwe akawamba he ikedu, “Wajaiwa wada wakauwao mbui izi mkauazo nywinywi! ");
INSERT INTO bou_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kwei nawamba, waoni na maseuta watamiwa kukauwa yada muyakauwayo nywinywi akini khawekuyaona na kuyategeeza yada mtegeezayo akini khawadaha.” ");
INSERT INTO bou_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aho mhinyi wa miagiiyo yumwe akagooka, akamuza Yesu, akakunda kumgeeza, “Mhinyi, nigosoe mbwai nidahe kwekaa misi yose kwesaho kisiikizi?” ");
INSERT INTO bou_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu akamtambaisa, “Yamba mbwai mwe miagiiyo? Mwamamakhanya viivihi?” ");
INSERT INTO bou_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yuda mntu akamtambaisa Yesu, “Mkundise Zumbe Muungu yako kwa moyo wako wose, kwa muye wako wose, kwa udaho wako wose na kwa akii zako zose. Na mkunde mntu wa hehi nawe inga wekundavyo wee mwenye.” ");
INSERT INTO bou_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu akamwamba, “Kutambaisa vyedi! Gosoa ayo, nawe wendauwe na ugima wa misi yose kwesaho kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Akini yuda Mhinyi wa miagiiyo neakakunda kweonyesha kuwa ni mtana akamuuza Yesu, “Na mntu wa hehi yangu ni ndai?” ");
INSERT INTO bou_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akamtambaisa, “Mntu yumwe kawa akaseeya kulawa Yelusalemu kuita Yeliko. Ekuwaho mwe sia, neafuntiwa ni mabagaa, na kumhoka vintu vyake vyose na kumtoa na kumbada kagona hada hehi na kuuya na nyuma.” ");
INSERT INTO bou_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ahoaho mviki yumwe nekawa akemboka mwe sia idaida, ekumuonaho akemboka khandani. ");
INSERT INTO bou_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nee eza Mlawi yumwe, ekubuwaho hada hantu akamwona, naye akemboka khandani. ");
INSERT INTO bou_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akini Msamalia yumwe nekawa akatamba, neabuwa hada kwa yuda mntu ekufintwae ekuwaho, naye ekumuonaho akamfiiya mbazi. ");
INSERT INTO bou_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akambasa, akamfunga vionda vyakwe kwa vibwende na kumsisa mavuta ya mzaituni na divai, akamkweza uwanga ya phunda wakwe, akamwegaa mwe nyumba ya kuhumuizia wageni akamhumiza. ");
INSERT INTO bou_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kioi yakwe akalavya ntii mbii vya madini ya feza akamwekha yuda mwenye nyumba akamwamba, “Mhumize mntu uyu na chochose wendachoutumie, nendanikuihe nendahoniuye.” ");
INSERT INTO bou_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naho Yesu akauza, “Gatigati ya awo watatu, ni yuhi mwekweonyesha kuwa mntu wa hehi yakwe yuda ekufuntiwaye na mabagaa?” ");
INSERT INTO bou_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yuda mhinyi wa miko akamtambaisa, “Ni yuda ekumfiiaye mbazi.” Yesu akamwamba, “Hita ukagosoe ivyoivyo.” ");
INSERT INTO bou_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na wahina wakwe wekuwaho watamba kuita Yelusalemu, wakengia mwe mzi umwe na mvyee zina dakwe Malita, akamhokea kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita ne kawa na dadiye etangwaye Malia uyu ne kekaa hehi na Zumbe akategeeza mahinyo yakwe. ");
INSERT INTO bou_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Akini Malita nekawa akagosoa ndima za zikoi na mbui nyingi, nee akamwiitia Yesu akamwamba, “Zumbe ivi khupatiiza kwambwai dada yangu kanibada nagosoa ndima za zikoi ikedu? Umgombeke aniambiize.” ");
INSERT INTO bou_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Akini Zumbe akamtambaisa, “Malita, Malita kwambwai wepisha kwa ndima nyingi.” ");
INSERT INTO bou_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Akini kuna mbui mwenga ntana kusima yose, mbui iyo ni kunitegeeza. Malia nee ekusaguado na khahana mntu yoyose adahae kumhoka. ");
INSERT INTO bou_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Msi umwe, Yesu kawa hantu akavika. Ekubindaho kumvika Muungu, yumwe wa wahina wakwe akamwamba, “Zumbe, takunda utihinye kuvika inga Yohana mbatiiza ekuwahinyavyo wahina wakwe.” ");
INSERT INTO bou_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu akawamba, “Mkavika Muungu, gombekani ivi, ‘Tate yetu weuko uwanga kwa Muungu Zina dako ditogolwe, Useuta wako weze. ");
INSERT INTO bou_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utekhe khande yetu kiya msi. ");
INSERT INTO bou_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utiekee mavigaviga yetu, Kwaajii swie tiwaekeavyo wose wekutikoseao, Wala wesekutingiza mwe mageezo.’ ” ");
INSERT INTO bou_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Naho Yesu akawamba wahina wakwe, “Nndai gatigati yenu mwenye mmbuya wakwe akamwezea na kio kikuu akamwamba, ‘Mmbuya nekha mabumunda matatu. ");
INSERT INTO bou_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwaajii mmbuya wangu kanezea alawa ntambo, namiye khina khande ya kumwekha.’ ");
INSERT INTO bou_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naho yuda mwe kuwa gati akamtambaisa, ‘Usekunipisha uvi uvugalwa kae, miye na wanangu tigona kae, khidaha kwenuka na kukwekha ukundacho.’ ");
INSERT INTO bou_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kwei nawagombeka inga uyo mntu khana enuke na kumwekha ayo mabumunda kwaajii ni mmbuya wakwe, akini kwaajii ya uyo mntu kwesekuona soni kuendeea kwakwe kumwetanga enda enuke na kumwekha kia ekukikundacho. ");
INSERT INTO bou_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ivyo nawagombakeni, ombezani nanywi mwondamwekhigwe, ondezani na nywie mndampate, kontani uvi nanywi mwenda mvuguiwe. ");
INSERT INTO bou_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwaviya kia aombezaye ekhigwa, na kia aondezaye endaekhigwe na kia akontaye uvi avugwiiwa. ");
INSERT INTO bou_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hambu kuna yoyose gatigati mwenu, mwana yakwe akamwombeza samaki, enda amwekhe nyoka na khiyo samaki? ");
INSERT INTO bou_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hambu mwana akamwomba tagi, endaamwekhe kisuse? ");
INSERT INTO bou_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Naho nywinywi wenye mavigaviga mwadaha kuwekha wana wenu vintu vyedi, kwei tati yenu wa uwanga kwa Muungu endaagosoe muno, endaawekhe Muye wa Muungu wada wamuombezao!” ");
INSERT INTO bou_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Naho Yesu ekuwaho amlavya zaiko mwe kuwa kwa mntu ekuwaye khadaha kutamwiiya. Yuda zaiko ekumlawaho yuda mntu mwekuwa khadaha kutamwiiya, nee avoka kutamwiiya na zumwezumwe da wantu dikahondomaa. ");
INSERT INTO bou_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Akini wamwe wa wantu awo wakagombeka, “Aguusa mazaiko kwakwekhigwa udaho wa Belizebuli, yuda muongoezi wa Mazaiko.” ");
INSERT INTO bou_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wantu watuhu wakamgeeza, wakaonda awaonyeshe utangio kulawa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Akini yee, akamanya mamakhanyi zao, akawamba, “Useuta wowose wekuiganyikao vizumwezumwe vihiganavyo khaudaha kwekaisa, naho wandugu wowose wenao khumbizi wadagamia.” ");
INSERT INTO bou_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inga Ibiisi akahigana yee mwenye, useuta wakwe wendagooke viivihi? Isasa mwadaha viivihi kugombeka ati nalavya mazaiko kwa udaho wa Belizebuli? ");
INSERT INTO bou_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Naho, inga miye nkawaguusa mazaiko kwa udaho Belizebuli, hata wahina wenu pia wawaguusa kwa udaho wakwe, kwaajii iyo wahina wenu nee wendaowawamuiye nywinywi. ");
INSERT INTO bou_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Akini ikawa naguusa mazaiko kwa udaho wa Muungu, manyeni kuwa useuta wa Muungu ubuakae kwenu. ");
INSERT INTO bou_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mntu mwenye muku aindaho nyumba yakwe kwa guha na uta, vintu vyakwe vyose vyendaviwe mwe uivanisa. ");
INSERT INTO bou_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Akini akeza mwenye muku muno, akamfuntia na kumvota, mntu uyo endaadoe vitoanavyo vyakwe ekutegemeavyo na kudoa vintu vyakwe vyose.” ");
INSERT INTO bou_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yoyose mwesekwevana nami ahigana nami, na mntu yoyose mwesekuika hamwe nami, endaamwaganise.” ");
INSERT INTO bou_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Zaiko dimlawaho mntu daangadika hantu kwesiho na mazi na kuondeza hantu ha kuhumwiiza. Akesekuhapata egombekeya nindaniuuwiye ida nyumba yangu nekulawayo.” ");
INSERT INTO bou_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Auyaho aibwiiya ida nyumba ihagiwa na vintu viikwa vitana. ");
INSERT INTO bou_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naho aita na kuwadoa mazaiko watuhu mfungate wafyaimi muno kusima yee, wose waita wakamwengia mntu uyo. Ivyo ugima wa mntu uyo undautendese kuwa wa ufyaimi muno kusima aho bosi. ");
INSERT INTO bou_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ekuwaho akatamwiiya ayo, mvyee yumwe gatigati ya diya zumwezumwe da wantu, akagombeka kwa mgutio mkuu, “Kajaiwa mvyee ekukuvyaae na kukuonkesa.” ");
INSERT INTO bou_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu akamtambaisa, “Akini wajaiwa muno wada wategeezao mbui ya Muungu na kuizumiiya.” ");
INSERT INTO bou_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zumwezumwe da wantu wekutendesaho kugenyea, Yesu akaendeea kuhinya akagombeka, “Iki ni kivyazi chenye mavigaviga. Chaondeza utangio, akini khakinachekigwe utangio wowose iya utangio wa Yona. ");
INSERT INTO bou_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Inga viya Yona ekuwavyo utangio kwa wantu wa Ninawi, nee vyendavyo viwe kwa Mwana wa Mntu kwa kivyazi iki. ");
INSERT INTO bou_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Seuta wa kivyee wa Sheba endaalawiiye kisingi kivyazi iki chendavyo kiamuiwe na Muungu, nae endaatamwiiye kivyazi iki kina mavigaviga. Kwaviya yee nee katamba kulawa hae mwe inusi, akeza kutegeeza umanyi wa Seemani na niaha nekuwae mkuu kusima Seemeni.” ");
INSERT INTO bou_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Wantu wa Ninawi wendawalawiiye kisingi cha kuamuiwa, nao wenda waonyeshe kivyazi iki kina mavigaviga. Kwaviya wantu wa Ninawi newahituka kwa kubada mavigaviga yao kwaajii ya ubiikizi wa Yona, niaha nekuwae mkuu kusima Yona.” ");
INSERT INTO bou_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Khahana mntu awashae taa na kuigubika kwa nyungu, iya aiika uwanga ya kiango wantu wengiao mda gati wadahe kuona ung'azi. ");
INSERT INTO bou_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Taa ya mwii wako ni sizo. Inga meso yako yendayakauwe vitana he ung'azi mwii wako wose wenda uwe vitana, na inga meso yako khayana yakauwe vitana aho mwii wako wenda uwe na kiza. ");
INSERT INTO bou_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Naho ukauwe, ung'azi weumo mwe mwii wako usekweza kuwa kiza. ");
INSERT INTO bou_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Naho inga mwii wako wose ukawa na ung'azi, na kwesekuwa na hantu hohose he kiza, mwii uwo wenda ung'ae vyedi muno inga viya taa ikumwiikavyo kwa ung'azi wakwe.” ");
INSERT INTO bou_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ekuwaho atamwiiya, mntu yumwe Mfalisayo neamgoneka akade khande kaya kwakwe. Yesu nee aita, akekaa kuda khande. ");
INSERT INTO bou_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Uyo Mfalisayo ne ahondomaa kuona Yesu ada khande kwesao kusunta mikono inga yekuwavyo wagosoa kia msi. ");
INSERT INTO bou_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Zumbe akamwamba, “Nywinywi Mafalisayo mwasunta via vya kudiiya khande kwa chongoi, akini ndani mmema uhokaji na mavigaviga. ");
INSERT INTO bou_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nywie wahezi! Khammanya kuwa Muungu yee nee mwekugosoa chongoi nee uyo mwe kugosoa na ndani? ");
INSERT INTO bou_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wekheni wakiwa vintu mwekuwavyo navyo, na kiya kintu mgosoacho kindakiwe vyedi kwenu. ");
INSERT INTO bou_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Akini mmbwii yenu Mafalisayo, kwaviya mwamwekha Mungu hantu ha kumi dimwe mnanaa na bwache na kiya mbai za mboga za mani, akini mwajaa haki na ukundiso wa Muungu. Naho iwakunda kulavya malavyo ayo, wala msekujaa kugosoa matuhu. ");
INSERT INTO bou_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mmbwii yenu nywinywi Mafalisayo, kwaajii nywie mwakunda kwekaa mwe vigoda he meso ya wantu mwe Nyumba za kukintania Wayahudi na kuuguswa kwa ishima mwe maguiyo. ");
INSERT INTO bou_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mmbwii yenu Mafalisayo kwaajii nywinywi inga mambiya yekwagayo, wantu wayajata kwesiho kumanya.” ");
INSERT INTO bou_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yumwe wa wahinyi wa miagiiyo akamwamba, “Mhinyi, mbui zako zatidumuwa na swie.” ");
INSERT INTO bou_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akamtambaisa, “Na nywinywi wahinyi wa miagiiyo, mmbwii yenu, kwaviya mwawatwika wantu fuushi zesazokwenukika, uku nywinywi khamnyoosha hata chaa kuwaambiza. ");
INSERT INTO bou_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mmbwii yenu, kwaviya mwazenga mambiya ya waoni wa Muungu wada ambao wadaa wenu nee wawakoma. ");
INSERT INTO bou_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nanywi wenye wavuhuzi na kwevana na mbui ya wadaa wenu, kwaviya wao nee wawakoma waoni wa Muungu, na nywinywi mwazenga mambia yao. ");
INSERT INTO bou_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwa iyo Muungu nee kagombeka kwa umanyi wakwe, ‘Nendaniwegaiye waoni wa Muungu na wagiiwa, akini wamwe wao wendawawakome, na kuwasuumiza watuhu.’ ");
INSERT INTO bou_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kivyazi iki chendachekhigwe sugusa kwaajii ya phome ya waoni yekuyetikayo tangia kuvokea inusi yekugosokaho, ");
INSERT INTO bou_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tangia phome ya Abeli adi phome ya Zakalia mwe kukomwa gatigati ya ingo na hantu ha Muungu. Eehe, kwei kivyazi chendachekigwe sugusa kwa mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mmbwii yenu nywinywi wahinyi wa miagiiyo, kwaajii muufisa uda ufunguo wa uvi wa kummanya Muungu nywie wenye khamokwengia na muwakindia wekuwaho wengia wasekwengia.” ");
INSERT INTO bou_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu ekuwaho alawa hada, wada Mafalisayo na wahinyi wa miko ne wavoka kuhigana nae vikai muno na kumsongeeza kwa kumuuza mbui nyingi, ");
INSERT INTO bou_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wakambengea wategeeze mbui ilawayo kwe miomo yakwe. ");
INSERT INTO bou_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kisingi icho zumwezumwe khuu muno da wantu wekuwao wakintana hata wakawa wajatana, Yesu akavoka kutamwiiya na wahina wakwe akawamba, “Ekauweni na ugwadu wa Mafalisayo yani ubakha wao. ");
INSERT INTO bou_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chochose chekugubikwacho chendakigubulwe, na chochose chekufiswacho chendakimanyike.” ");
INSERT INTO bou_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa iyo kia mwekugombedo mwe kiza, wantu wendawasikie mwe mweenje, na kia mwekupokosado mwe magutwi yenu mkawa mwe vyumba vya khandani, yenda ibiikiwe uwanga ya chusi. ");
INSERT INTO bou_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nawagombekeni nywinywi wambuya wangu, mwese kuwaogoha wada waukomao mwii, na khawadaha kugosoa kintu kituhu. ");
INSERT INTO bou_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naho nendaniwambie nndai wa kuogohwa. Muogoheni yuda ambae akabinda kuukoma mwii ana udaho wa kuuwasa mwe moto da tubwi diwakado moto wesao kukomeka. Eehe, nawamba muogoeni uyo. ");
INSERT INTO bou_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mwamanya kuwa machole washano watagwa kwa senti mbii? Akini hemeso ya Muungu khajaika ata yumwe. ");
INSERT INTO bou_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Naho ata fii za mitwi yenu zitaaziwa zose. Msekuogoha, kwaviya nywinywi mwafaa muno kusima machole wangi. ");
INSERT INTO bou_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nami nawamba yoyose anizumiaye hemeso ya wantu Mwana wa Mntu naye endaamzumiiye he meso ya wandima wa uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na mntu yoyose aniemeaye he meso ya wantu, naye Mwana wa mntu endaamuemee hemeso ya wandima wa uko uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mntu yoyose agombekaye mbui ya kumuemea Mwana wa Mntu Muungu endaamuekee, akini endayeaudumuwe Muye wa Muungu khana uyo Muungu khanaamuekee mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Hada wendaho wawaguiye na kumyengiza nywinywi hemeso ya Nyumba ya kukintania Wayahudi na hemeso ya wenye udaho na wagookezi, msekuwa na maatumaatu uwanga ya mwondavyo kwevunia hambu mwondavyo mtamwiiye. ");
INSERT INTO bou_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwaviya Muye wa Muungu endaawahinye kiya mkundigwacho kugombeka.” ");
INSERT INTO bou_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naho mntu yumwe mwe diya zumwezumwe da wantu akamwamba, “Mhinyi, mgombeke ndugu yangu tipangane upazi ekutibadiao tate.” ");
INSERT INTO bou_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akamtambaisa, “Mmbuya, nndai ekuniikaye miye kuwa muamuia na mpangi gatigati yenu?” ");
INSERT INTO bou_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naho Yesu akawamba wose, “Ekauweni na kia mbai ya khwiina ya vintu vingi kwa mana ugima wa mntu khaukauwia wingi wa vintu ekuwavyo navyo.” ");
INSERT INTO bou_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naho akawamba msimo unu, “Nekuwa na mntu yumwe mwenye vitu vingi ambae mnda wakwe uvyaa ubosi mwingi. ");
INSERT INTO bou_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mntu uyo mwenye vintu vingi akamamakhanya mwe moyo wakwe, ‘Nami khina hantu ha kuika ubosi wangu, nndanitende viihii? ");
INSERT INTO bou_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ekegombekea, nndanigosoe ivi, nndaniditue idi taa dangu nakuzenga tuhu kuu muno, namiye nndaniike umo khande zangu hamwe na vintu vyangu vyose. ");
INSERT INTO bou_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aho nee nendaho nidahe na kuwamba muye wangu, isasa una vintu vingi wendavyo uvitumie kwa myaka mingi. Humwiiza, na daa khande, na domeea na uwe na nyemi.’ ");
INSERT INTO bou_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Akini Muungu akamwamba, ‘Wee mhezi! Ivyeo na kiyo muye wako wendaudoigwe. Na vintu viya vyose wekuviikavyo vindaviwe vya ndai?’ ” ");
INSERT INTO bou_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu akabinda kwa kugombeka, “Nee vyeivyo kwa mntu yoyose ememezeae vintu kwaajii yakwe, akini khio mntu mwenye vintu vingi hemeso ya Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Naho Yesu akawamba wahina wakwe, “Msekuwa na maatumatu uwanga ya khande mwiikundayo ili mwe na ugima, wala uwanga ya magwanda myakundayo kwaajii ya mii yenu. ");
INSERT INTO bou_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwaajii ugima ni yedi kusima khande, na mwii ni wedi kusima magwanda. ");
INSERT INTO bou_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wamamakhanyeni kunguu wowo khawahanda wala kawabonda na khawana taa, wala hohose hakuika khande zao akini Muungu awekha khande. Akini nywinywi ni wedi kusima wadege. ");
INSERT INTO bou_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nndai yumwe wenu ambae kwa kwepisha adaha kweongezea ugima wakwe hata kwa saa dimwe? ");
INSERT INTO bou_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naho inga khamdaha kugosoa mbui ndodo inga iyo, kwa mbwai kuwa na maatumatu uwanga ya yada matuhu? ");
INSERT INTO bou_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kauwani mauwa yasukhavyo khayagosoa ndima wala khayasuka. Akini nawamba, hata seuta Seemani he vintu vyakwe vyose khekuwahi kuvaa magwanda matana inga uwa dimwe aho. ");
INSERT INTO bou_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Inga Muungu ayavika ivi mani ya mwe minda ambayo ivyeo yaaho kioi yasigwa mwe moto, ivi nywinywi khana awavike vyedi muno enyi wenye uzumizi mdodo?” ");
INSERT INTO bou_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Wala msekwepisha mwe mioyo yenu mwenda mde mbwai hambu mwenda mdomee mbwai msekuwa na maatumatu kuusu mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wantu wesaokuwa Wayahudi wa inusi waangadikia vintu ivyo. Akini Tati yenu wa uwanga kwa Muungu amanya kuwa mwakunda vintu ivyo. ");
INSERT INTO bou_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Isasa uwangadikieni Useuta wa Muungu, na vintu ivyo vyose navyo mwenda mwekhigwe.” ");
INSERT INTO bou_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Msekuogoha, nywinywi zumwezumwe dodo, kwaviya Tati yenu katamiwa kuwekha Useuta. ");
INSERT INTO bou_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tageni vintu vyenu mkawekhe wakiwa izo hea. Mwegosoee vifuko vya hea vyesayokusakaa, na uko nee kuika kiikizo uwanga kwa Muungu ambaho taa dakwe khadihungua, uko wabavi khawabua na wala mswa khawabananga. ");
INSERT INTO bou_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hada enaho kiikizo chako, nee endaho uwe aho moyo wako. ");
INSERT INTO bou_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ekaani tayali kwa kunigosoeya na taa zenu ziwe zaka. ");
INSERT INTO bou_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Inga wandima wamgojao zumbe yao auye kulawa kwe ntafuno ya ndoza. Na ezaho na kukonta uvi wadahe kumvuguiya maa mwenga. ");
INSERT INTO bou_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wajaiwa wada wandima ambao zumbe yao endaawabwiiye wameso endahoeze. Kwei, nawamba endaeike tayali na kuwetanga mwe ude na kuwegosoeya ndima. ");
INSERT INTO bou_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wajaiwa kwa wandima awo mkuu yao endahoeze na kuwabwiiya wacheeza hata akeza kio kikuu, hambu hehi na kucha. ");
INSERT INTO bou_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Manyeni kuwa inga mwenye nyumba ati nee kamanya saa ambayo mbavi endaeze, nee kawa meso ili amkindie mbavi, na khekuwa aibadie nyumba yakwe itulwe. ");
INSERT INTO bou_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nywie nanywi mwakundigwa mwekae tayali saa zose, kwaviya Mwana wa Mntu enda eze saa ambayo khamuimanya.” ");
INSERT INTO bou_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo akamwamba, “Zumbe, msimo uwo watambia swiswi, hambu wawamba wantu wose?” ");
INSERT INTO bou_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zumbe akamtambaisa, “Nindai, mndima mzumiiwa na mwenye umanyi, ambae Zumbe wakwe endaamwiike uwanga ya wandima wakwe awekhe khande kisingi kifaacho. ");
INSERT INTO bou_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kajaiwa mndima uyo, hada zumbe wakwe endaho auye nakumbwiiya atenda ivyo. ");
INSERT INTO bou_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nawamba kwei kuwa endaamwekhe ugookezi wa vintu vyakwe vyose. ");
INSERT INTO bou_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Akini inga mndima uyo akegombeka mwenye mwe moyo wakwe zumbe yangu kawa kacheewa muno kuuya, naho akavoka kuwatoa wandima wa wakivyee hambu wakigosi wada wenziwe, viyaviya endaade na kudomeea na kukolwa, ");
INSERT INTO bou_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","zumbe wakwe yuda mndima endaauye msi esao kukauwia na mda esao kuumanya. Endaamwekhe sugusa mndima uyo ya ufyaimi na kumwiika hamwe na wantu wesaokuzumiiya.” ");
INSERT INTO bou_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yuda mndima amanyaye vitana akundacho zumbe wakwe, akini khayuho tayali wala kugosoa yakundigwayo mkuu wakwe endaatoigwe muno. ");
INSERT INTO bou_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Akini mndima yuda mwesekumanya mkuu yakwe akunda mbwai akagosoa ya ufyaimi, uyo endaatoigwe kidodo. Yoyose yuda mwekhekigwa kugosoa ndima khuu, endaakundigwe kulavya vingi muno.” ");
INSERT INTO bou_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ncheza kueta moto mwe inusi, natamiwa inga uwe tayali ugimbwa!” ");
INSERT INTO bou_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Akini nenao ubatiizo ambao nlazima nibatiizwe, suuba yangu ni khuu hadi ubatiizo uwiganie. ");
INSERT INTO bou_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mwamamakhanya ncheza kueta uivanisa mwe inusi? Nawamba khivyo, ncheza kueta mabadano. ");
INSERT INTO bou_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kuvokea isasa, kundakuwe na wantu wa kaya mwenga washano, watatu kwa waidi na waidi kwa watatu. ");
INSERT INTO bou_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tate khanaevane na wanawe wa kigosi, na wana wa kigosi khawanawevane na tati yao, na mmaa khanaevane na wanawe wa kivyee, wana wa kivyee khawanawevane na mami yao, naye mame vyaa khanaevane na mkaza mwana, nae mkaza mwana khanaevane na mami yakwe vyaa. ");
INSERT INTO bou_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu akagombeka vituhu mwe dia zumwezumwe da wantu, “Muonaho mazunde yakalawiiya phande ya engiiyo da zuwa, aho mwagombeka, fua indainye na kwei yanya.” ");
INSERT INTO bou_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Muonaho pheho ya khusi yavuma, mwagombeka, “Kunda kuwe na zuguto, na vyawa ivyo. ");
INSERT INTO bou_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enywi wabakha! Mwamanya koona msimu kwa kukauwa inusi na uwanga kwa Muungu vyeivyo. Kwa mbwai, khamdaha kusosoa mana ya mbui zigosokazo isasa? ");
INSERT INTO bou_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na kwambwai khamdaha kweamuiya wenye mbui yedi za kugosoa? ");
INSERT INTO bou_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kwaviya inga mmasa wako akakwegaa he mkonga, yedi wevane nae mkesiai ili asekweza kukwegaa hemeso ya mntu muamuwa, na uyo muamuwa akakwekhiiza kwa asikai, nawo wakakugea mwe kifungo. ");
INSERT INTO bou_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nakwamba Kwei khunaulawe umo, hadi wendaho ubindiize kuihaa senti ya kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kisingi icho wantu watuhu ne weza, wakamwamba Yesu kuusu mbui ya wantu wa Galilaya ambao Pilato akawakoma na phome ya wantu awo ikahanganyikana na phome ya ntambiko izo wekuavyo walavya. ");
INSERT INTO bou_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu akawamba, “Mwamamakhanya Wagalilaya awo wekugosoewa ivyo neewawa wagosoa mavigaviga muno kusima Wagalilaya watuhu? ");
INSERT INTO bou_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nawamba kwei khivyo ivyo, akini nanywi mwesaho kuhituka na kubada mavigaviga mwendamdagamie inga wowo. ");
INSERT INTO bou_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mwamamakhanya wada kumi dimwe na nane wekugwiwao na mnaa kuda Siloamu wakauya na nyuma, ivi mwamamakhanya wao neewawa na makwasukwasu kusima watuhu wose wekaao Yelusalemu? ");
INSERT INTO bou_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nawamba khivyo ivyo akini nanywi mkese kuhituka na kubada mavigaviga na kumuuiya Muungu, mwenda mdagamie inga wowo.” ");
INSERT INTO bou_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aho Yesu akawamba msimo unu, “Mntu yumwe nekawa na mti wetangwao mtini mwe mnda wakwe wa mizabibu, mntu uyo akaita kutunda matunda yakwe, akini nee aubwiiya khauzati kuvyaa hata tunda dimwe. ");
INSERT INTO bou_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naho akamwamba mndima wakwe, ‘Kwa myaka mitatu nee nikeza nitunde matunda ya mtini unu, iya chekumbwiia chochose. Usenge! Kwaviya wabananga sanga bue.’ ");
INSERT INTO bou_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Akini yee akamtambaisa, ‘Zumbe, tiubade vituhu mwaka unu, nenda nindaniutifuie uhongo na kuugea mboleya. ");
INSERT INTO bou_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Inga wendauvyae matunda mwaka wezao nivitana, hambu ukesekuvyaa tadaha kuusenga.’ ” ");
INSERT INTO bou_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Msi umwe wa Kuhumwiza Yesu ne kawa akahinya mwe Nyumba ya kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na aho ne awa na mvyee yumwe ekuwaye mtamu kwa myaka kumi dimwe na minane, nekawa na zaiko dilimtenda mwii wakwe ne wenama muno hata asekudaha kugooka vitana. ");
INSERT INTO bou_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu ekumuonaho, akamwetanga akamwamba, “Mmaa, kuhonywa utamu wako!” ");
INSERT INTO bou_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nee amuikia mkono na aho akagooka vituhu, akawa amtogoa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Akini muongoezi wa nyumba ya kukintania Wayahudi akakimwa kwaajii Yesu kamhonya uyo mmaa msi wa kuhumwiza. Ivyo mkuu uyo akawamba wada wantu wekuwao hada, “Mna misi mtandatu za kugosoa ndima. Buwani misi iyo mkahonywe matamu yenu, akini msekweza Msi wa Kuhumuiiza!” ");
INSERT INTO bou_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aho Zumbe akamtambaisa, “Enywi wabakha! Nndai gatigati yenu khamfungua ng'ombe wakwe hambu phunda wakwe kulawa mwe dewa amwegaye kwe kunywa mazi, hata inga msi uwo ni wa kuhumuiza. ");
INSERT INTO bou_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Isasa yuaho mwana wa uvyaigwa wa Ibulahimu ambaye ibiisi kamgosoa avie kwa kisingi cha myaka kumi dimwe na minane, khayokuwa vitana kuvuguiwa kulawa kifungo iko msi wa kuhumuiza?” ");
INSERT INTO bou_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu ekubindaho kutamwiiya ayo, wada wahiganae naye wakengiwa nsoni, akini wantu wose wakamema nyemi kwaajii ya mbui yose yekugosokanayo. ");
INSERT INTO bou_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Naho Yesu akauza, “Useuta wa Muungu waigana na mbwai? Nendaniuwiganize na mbwai? ");
INSERT INTO bou_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Waigana na mbeyu ya haladali ambayo ni ndodo muno, ambayo mntu akaidoa na kuihanda mwe mnda wakwe. Naho ikahota na kukua na kuwa mti na wadege wa uwanga wakazenga masasa yao mwe matambi yakwe.” ");
INSERT INTO bou_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu akawauza vituhu, “Nndaniuwiganize Useuta wa Muungu na mbwai? ");
INSERT INTO bou_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Waigana na hamila ambayo mvyee ne kaidoa na kuihanganya mwe madebe matatu ya unga ne wose ukawa uumuka.” ");
INSERT INTO bou_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu akemboka mwe mzi na mizi midodo akahinya ekuwaho mwe ntambo yakwe yakuita Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mntu yumwe akamuuza, “Ivi Zumbe, wendaowaoholwe ni wantu wachechedu?” ");
INSERT INTO bou_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesu akawamba, “Jiimeni kwengia kwa kwembokea uvi msisii, kwaviya nawagombekani, wangi wendawageeze kwengia, akini khawana wadahe. ");
INSERT INTO bou_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kisingi cheza ambao mwenye kaya enda enuke na kuvugaa uvi nywinywi mwenda mgooke chongoi na kukonta uvi na kugombeka, ‘Zumbe, tivuguiye uvi!’ Akini yee enda awatambaise, ‘Khiwamanya mwaawako!’ ");
INSERT INTO bou_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nanywi mwenda mvoke kumwamba, ‘Swiswi nee wada tekudao na kudomeea hamwe nawe na wee kutihinya mwe mizi yetu!’ ");
INSERT INTO bou_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Akini yee atawatambaisa, ‘Khiwamanya nywinywi mwaawako. Haukeni hemeso yangu nywinywi nyose mkugosoao mavigaviga!’ ");
INSERT INTO bou_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aho nee wendaho muiye muno na kuuma meno, kisingi mwendaho muwaone Ibulahimu na Isaka na Yakobo na Waoni wose wa Muungu waaho mwe Useuta wa Muungu, akini nywinywi wenye mwasigwa chongoi. ");
INSERT INTO bou_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wantu wendaweze kulawa phande zose za inusi, awio da zua na engiiyo da zua na kasikazini na kusini, na kwekaa kwe ntafuno mwe Useuta wa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kauwa wada wa kisiikizi wenda wawe wa bosi, nawo wa bosi wenda wawe wa kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kisingi ichoicho wamwe wa Mafalisayo wakamwiitia Yesu na kumwamba, “Hauke hanu uite hantu hatuhu kwaviya Helode aondeza kukukoma.” ");
INSERT INTO bou_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akawatambaisa, “Hitani mkamwambe yuda mbweha, ‘Nndaniwaguuse mazaiko na kuhonya watamu ivyeeo na kioi, nami msi wa tatu nndanibindiize ndima yangu.’ ");
INSERT INTO bou_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata ivyo ivyeeo na kioi na kisinda kioi, nlazima niendeee na ntambo yangu kwaajii khiyo vitana muoni wa Muungu akomwe chongoi ya mzi wa Yelusalemu.” ");
INSERT INTO bou_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ewe wantu wa Yelusalemu, wantu wa Yelusalemu, wee uwakomaye waoni wa Muungu na kuwatoa maiwe wada wekuagiiwao na Muungu kwako! ‘Maa nyingahi khitamiwa kuwaika wanao hamwe inga mdege aikavyo vifaanga vyakwe ili awainde asi ya mawawa yakwe akini wee khwekukunda! ");
INSERT INTO bou_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kauwa Nyumba yenu ya Muungu ya badwa, nawagombeka khamna mnione vituhu hadi kisingi kia mwendaho mgombeke, kajaiwa yee mwekuagiiwa na kwekhigwa udaho kwa zina da Zumbe.’ ” ");
INSERT INTO bou_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Msi umwe wa kuhumwiiza, Yesu nee kaita kuda khande nyumbai kwa muongoezi yumwe wa Mafalisayo na wantu wekuwao aho wakawa wamsunguumanya. ");
INSERT INTO bou_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hemeso ya Yesu nee hawa na mntu yumwe mwekuwa na utamu wa kumema mwii. ");
INSERT INTO bou_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu akawauza wahinyi wa miagiiyo na Mafalisayo, “Ivi miagiiyo ya Musa yawakunda kuhonya wantu msi wa Kuhumuiza hambu khivyo?” ");
INSERT INTO bou_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Akini wowo wakanyamaa. Yesu akamtoza uyo mtamu, akamhonya, akambada aite. ");
INSERT INTO bou_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Naho Yesu akawamba, “Nndai gatigati yetu ambae mwanawe hambu ng'ombe wakwe akengia mwe tubwi, khana amuavye kwaviya ni Msi wa Kuhumwiiza?” ");
INSERT INTO bou_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na wantu awo khawokudaha kumtambaisa mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu akakauwa wada wantu wekugonekwao wekuavyo wesaguiya viti vya hemeso hantu ha ishima, akawamba msimo unu, ");
INSERT INTO bou_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Inga mntu akakugoneka mwe ndoza, usekwekaa viti vya hemeso hantu ha ishima, isikweza kukawa kagonekwa mntu mtuhu wa ishima kusima wee, ");
INSERT INTO bou_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","akeza yuda mwekuwagoneka nywinywi waidi na kukugombeka, ‘Mhakanye uyu.’ Ndiho wendaho uvoke kwa soni kuita kwekaa nyuma. ");
INSERT INTO bou_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Naho ukagonekwa kwe ntafuno, ekaa hantu ha nyuma, na mwenyezi yako endaho eze akwambe, ‘Mmbuya, soo hanu hemeso, hantu hatana muno.’ Aho wendauwe wa kutunywa hemeso ya wantu wose wekwekaao hamwe nawe. ");
INSERT INTO bou_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwaviya mntu yoyose etendae mkuu enda atendwe mdogo na atendae mdogo enda atendwe mkuu.” ");
INSERT INTO bou_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu akamwamba yuda ekumgonekaye, “Inga ukawaikia wantu ntafuno ya musi hambu guoni, usekuwagoneka wambuya wako hambu nduguzo hambu wantu wa hehi yako wekuwao wenye vintu vingi. Wasekweza nao wakakugoneka, nawe ukawa kuihwa kia wekuwagosoeacho. ");
INSERT INTO bou_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naho ugosoaho ntafuno, wagoneke wakiwa na wantu wekuviao na wekuviawo miundi na matuntu, ");
INSERT INTO bou_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nawe wenda ujaiwe kwaajii awo khawadaha kukuiha, Muungu enda akuihe funge kisingi cha uyuyuko cha wantu wedi.” ");
INSERT INTO bou_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yumwe wa wada wekuwao wekaa hamwe na Yesu akamba, “Kajaiwa mntu yuda endae ade khande mwe Useuta wa Muungu!” ");
INSERT INTO bou_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu akamtambaisa, “Mntu yumwe kagosoa ntafuno khuu, akawagoneka wantu wangi ");
INSERT INTO bou_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kisingi cha khande chekubuwaho akamwagiiya mndima wakwe, akawambe wada wekugonekwao, ‘Sooni kwaviya kia kintu kitayali!’ ");
INSERT INTO bou_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Akini wose kia yumwe akavoka kuomba lazi, wa bosi akamba ‘khigua kae mnda nlazima niite nikaukauwe khina neze.’ ");
INSERT INTO bou_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mntu mtuhu akamwamba, ‘Khigua ng'ombe mbai shano wa kuima, isasa ni siai nenda kuwageeza ivyo nakuombeza uniuusu.’ ");
INSERT INTO bou_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na mtuhu akamwamba, ‘Isasa khitegua kwa iyo khidaha kweza.’ ");
INSERT INTO bou_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mndima uyo ekuuyaho akamwamba mkuu yakwe mbui iyo. Mkuu nee akimwa, akamwamba mndima wakwe, ‘Hita kinyionyio mwe baabaa na sia za mizi, ukawaete hanu gati wakiwa, na wekuviao miundi, na matuntu na wekuviao.’ ");
INSERT INTO bou_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Badae mndima uyo akamba, ‘Zumbe, mbui zigosoka inga wekuniagiiavyo, akini ikeaho phasi.’ ");
INSERT INTO bou_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yuda zumbe akamwamba mndima uyo, ‘Hita mwe baabaa na sia za mizi uwahembeeze wantu wengie mwe nyumba yangu imeme. ");
INSERT INTO bou_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwaviya nawamba, khahana hata yumwe wa wada wekugonekwao mwenda aonje khande yangu.’ ” ");
INSERT INTO bou_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aho mazumwezumwe mangi nee yawa yaita hamwe na Yesu, naho akawahitukia wantu akawamba, ");
INSERT INTO bou_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mntu yoyose akeza kwangu, khana adae kuwa mhina wangu akese kunikunda mie muno kusima tati yakwe na mami yakwe na mkaziwe na wanawe, na nduguze na dadize na ata ugima wakwe yee mwenye. ");
INSERT INTO bou_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mntu yoyose mwesekuudoa mhamba wakwe na kunibasa khadaha kuwa mhina wangu. ");
INSERT INTO bou_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Goja nisosoe vitana, nndai gatigati yenu akakunda kuzenga mnaa khana avoke kwekaa ahime galama zakwe amanye anakima cha kugenyea na cha kubindiizia? ");
INSERT INTO bou_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inga akesekugosoa ivyo, endaadahe kugosoa msingi na kuvotwa kubinda mnaa uwo, aho wantu wendawamseke. ");
INSERT INTO bou_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wakagombeka, ‘Mntu uyu nee kavoka kuzenga, akini khana udaho kubindiizia.’ ");
INSERT INTO bou_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hambu ni seuta yuhi mkunda kuita kutoana na seuta mtuhu, khana avoke kwekaa na kumamaakhanya inga enda adahe kutoana na mwenye asikai elufu ishiini na yee ana asikai elufu kumi dimwe? ");
INSERT INTO bou_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Inga akoona khana adahe kutoana nae, endaawaagiiye wandima wakwe kuwaomba wawe na mwevano wa uivanisa, kisingi seuta uyo mtuhu yuke hae. ");
INSERT INTO bou_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ivyoivyo, khahana hata yumwe gatigati yenu endaye awe mhina wangu inga akese kueka kia kintu ekuwacho nacho.” ");
INSERT INTO bou_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu ni kintu kitana, akini ukabanika, khaidaika kugosoa chochose kuwa munyu vituhu? ");
INSERT INTO bou_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Khaifaa kintu wala kwa msanga wala kwa mboleya. Wantu wayasa hae, mwenye magutwi ya kutegeeza na ategeeze!” ");
INSERT INTO bou_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Msi umwe, watoza kodi na wenye mavigaviga wangi nee waita kumtegeeza Yesu. ");
INSERT INTO bou_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na wahinyi wa miko wakavoka kupokosana, “Mkauweni mntu huyu awahokea wenao mavigaviga, naho ada nao!” ");
INSERT INTO bou_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ndiho Yesu akawatambaisa kwa msimo unu. ");
INSERT INTO bou_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Inga, yumwe yenu akawa na ngoto makumi kumi, akamanya kuwa yumwe yao kaga, enda agosoe mbwai? Enda awabade wada makumi kenda na kenda uisi na kuita kumuondeza yuda ekwagaye hadi amuwone.” ");
INSERT INTO bou_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Naye akabinda kumuwona, enda amwenue kwa nyemi mwe mawega yakwe. ");
INSERT INTO bou_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Endaoabue kaya, enda awetange wambuya na wantu wa hehi yakwe na kuwamba, “Muwe na nyemi hamwe na mie kwaajii khimuwona yuda ngoto yangu ekwagaye.” ");
INSERT INTO bou_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nawambeni ivyoivyo, kundakuwe na nyemi muno uko uwanga kwa Muungu kwaajii ya mwenye mavigaviga yumwe kuhituka, kusima kwa wada wedi makumi kenda na kenda ambao khawakunda kubada mavigaviga. ");
INSERT INTO bou_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu akawamba msimo mtuhu akamba, “Tambe mvyee yumwe ana senti kumi dimwe, akaza mwenga, enda atende mbwai? Enda awashe taa, enda aihagie ida nyumba phahoephahoe hadi aiyone. ");
INSERT INTO bou_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akaipata, enda awetange wambuya na wantu wa hehi yakwe na kuwamba, ‘Kuwani na nyemi hamwe nami, kwaajii khiipata ida senti yangu yekuwayo yaga.’ ");
INSERT INTO bou_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nawambeni, Nee wendavyo wawe na nyemi wandima wa uko uwanga kwa Muungu kwaajii ya mwenye mavigaviga yumwe haitukae na kumuuiya Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu akaendeea kugombeka, “Kuwa na mntu yumwe mwekuwa na wana waidi wa kigosi. ");
INSERT INTO bou_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yuda mdodo akamwamba tati yakwe, ‘Tate nekha hantu hangu ha upazi.’ Naye akamwekha hantu hakwe. ");
INSERT INTO bou_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bada ya misi micheche, yuda mdodo akataga vintu vyake, akatamba na hea ekupatazo akaita si ya hae na hea zose akazibananga kwa wekazi wa mavigaviga. ");
INSERT INTO bou_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ekubindaho kutumia kia kintu kukalawiiya saa khai mwe si ida, naye akavoka kuangadika. ");
INSERT INTO bou_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akaombeza ndima kwa mntu yumwe wa si ida, nae akamwegaa mwe mnda wakwe awaise nguuwe. ");
INSERT INTO bou_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mbwanga yuda nee ana nsaa muno, akatamiwa kuda makoa wekudayo wada nguuwe, iya khahana mntu ekumwekhaye khande. ");
INSERT INTO bou_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Badae akamamakhanya mwe moyo wakwe, ‘Kaya kuna wandima wangi wa tate yangu wadao khande na kubada phugutio, na miye nafa na saa?’ ");
INSERT INTO bou_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nenda niuye kwa tate yangu na kumwamba, ‘Tate, khimgosoea mavigaviga Muungu ekuwaye uwanga na khikukoa masa na weye. ");
INSERT INTO bou_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Khifaa hata kwetangwa mwanao, nigosoe inga yumwe wa wandima wako.’ ");
INSERT INTO bou_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndiho akavoka kutamba kuuya kwa tati yakwe.” “Ekuwaho yuke hae, tati yakwe ekumuonaho, na kwa moyo wa mbazi akamguukia, na kumuumbatia kwa ukundiso. ");
INSERT INTO bou_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwanawe akamwamba, ‘Tate, khimgosoea mavigaviga Muungu ekuwae uwanga, na khikukoa masa na wee, khifaa kwetangwa mwanao.’ ");
INSERT INTO bou_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Akini tati yakwe akawetanga wandima wakwe akawamba, ‘Etani gwanda tana mkamvike kinyio! Mvikeni phete mwe chaa chakwe na sabana mwe miundi yakwe. ");
INSERT INTO bou_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mdumueni singo ng'ombe mwe kunona, tide na kuwa na nyemi! ");
INSERT INTO bou_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwaajii uyu mwanangu inga nee kauya na nyuma na isasa yu mgima, nee kaga, akini isasa khaoneka’ wakavoka kuwa na nyemi.” ");
INSERT INTO bou_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kisingi icho kakiye neyuke tanga. Ekuwaho auya na kubua hehi na nyumbani, akategeeza migutio ya wantu wakitoa vigeegee na ngoma. ");
INSERT INTO bou_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akamwetanga mndima yumwe, na kumuuza, ‘Kuna mbwai hanu?’ ");
INSERT INTO bou_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uyo mndima akamtambaisa, ‘Nduguyo kauya kaya na tati yako kamdumuiya ng'ombe mwe kunona kwaviya kampata yuke mgima.’ ");
INSERT INTO bou_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Uyo mwana mkuu akakimwa muno akaemea kwengia gati, ndiho tati yakwe akaawa chongoi na kumhembeeza engiye gati. ");
INSERT INTO bou_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Akini yee akamtambaisa tati yakwe, ‘Kauwa myaka yose inu nee nikakugosoea ndima na hata msi umwe shekubada kukutegeeza mwiko, akini khuzati kunekha hata mbuzi nitamiwe na wambuya wangu. ");
INSERT INTO bou_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akini mwanao uyu mwekutumia vintu vyako hamwe na wakianga, ekwezaho du kumdumuiya singo ng'ombe mwe kunona.’ ");
INSERT INTO bou_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tati yakwe akamtambaisa, ‘Mwanangu, wee uhamwe nami misi yose, na kia nenacho ni chako. ");
INSERT INTO bou_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ifaigwa kugosoa nyemi khuu muno kwaajii uyu nduguyo nee inga kauya na nyuma, na kumbe yuke mgima, nee kaga, akini isasa timuona.’ ” ");
INSERT INTO bou_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu akawamba wahina wakwe, “Nee kuwa na mwenye vintu vingi yumwe nee kawa na mgookezi yakwe mwekuwa mgookezi wa vintu vyake, uyo mwenye vintu vingi akagombekwa mgookezi wakwe anatumia kwa ufyaimi vintu vyakwe, ");
INSERT INTO bou_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","yuda mwenye vintu vingi akamwetanga na kumuuza, ‘Ni mbui zani izi nekuzisikiazo kuusu weye? Avya taazia za vintu vyangu kwaviya khauna udahe kuendeea kuwa mgookezi.’ ");
INSERT INTO bou_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yuda mgookezi akemamakhanya, ‘Zumbe yangu kaniguusa ndima yangu. Nndanitende mbwai? Ati ni kuima khina nguvu za kuima. Naho naona soni kuombezaombeza. ");
INSERT INTO bou_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Isasa, namanya nendado nigosoe, ili nendaho niguuswe ndima ya ugookezi, wantu wadahe kunihokea mwe nyumba zao.’ ");
INSERT INTO bou_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naho yuda mgookezi akawetanga wada wose wekuwaho wakadaiwa na zumbe yakwe, akamuuza wa bosi, ‘Una daiwa kima chani na mkuu yangu?’ ");
INSERT INTO bou_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yee akamtambaisa, ‘Mapipa makumi kumi ya mavuta ya mzaituni,’ yuda mgookezi akamwamba, ‘Doa maandiko yako ya deni, ekaa asi, gonda makumi mashano.’ ");
INSERT INTO bou_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Naho akamuuza mdaiwa mtuhu, ‘Wee wadaiwa kima chani?’ Yee akamtambaisa, ‘Magunia mia mwenga ya ngano.’ Yuda mgookezi akamwamba, doa kaatasi yako ya deni gonda semanini.” ");
INSERT INTO bou_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Naho yuda zumbe akamtogoa yuda mgookezi mfyaimi, kwaviya nee katumia unyanyi kwaajii wantu ambao khawazumiiya Muungu wa inusi wana akii muno na mbui zao kusima wantu wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Naye Yesu akaendeea kutamwiiya, “Nami nawamba, waambizeni wambuya wenu kwa mai za mavigaviga ili zendaho zisie muhokewe mwe chekao cha misi yose kwesaho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mntu yoyose azumiwae mwe mbui ndodo enda azumiiwe mwe mbui khuu na yoyose mwesekuzumiika mwe mbui ndodo khadaha kuzumiiwa kwe mbui khuu. ");
INSERT INTO bou_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Inga mkese kuzumiika kwa mai za inusi, nndai endae wazumiie mwe mai za kwei? ");
INSERT INTO bou_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nanywi inga khamokuwa wazumiika wa mai ya mntu mtuhu, nndai endae awekhe yekuwayo yenu wenye? ");
INSERT INTO bou_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Khahana mndima adahaye kuwagosoeya ndima mazumbe waidi, kwaviya endaamkime yumwe na kumkundisa mtuhu, hambu endaatozane na yumwe na kumbea mtuhu. Khamdaha kumgosoeya Muungu hamwe na mai.” ");
INSERT INTO bou_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayo wekusikiaho ayo, kwaviya neewawa wakunda hea muno nee wambeya Yesu. ");
INSERT INTO bou_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu akawamba, “Nywie mwegosoa wedi hemeso ya wantu. Akini Muungu aimanya mioyo yenu kwaviya kia kionekacho ni chedi hemeso ya wantu, Muungu ayakima. ");
INSERT INTO bou_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Miagiiyo ya Musa na magondo ya waoni wa Muungu nee yakawaongoeya hadi kisingi cha Yohana mbatiiza. Kuvokea kisingi icho, Mbui Yedi ya Useuta wa Muungu yabiikiwa na wantu wose washuutizwa wengie he Useuta wa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Akini ni vihufu muno uwanga kwa Muungu na inusi kwaga, kusima hata helufi mwenga ya miagiiyo ya Musa kuusigwa. ");
INSERT INTO bou_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mntu yoyose amwekhaye mkaziwe talaka na kutegua mtuhu, agosoa ukianga na yoyose amteguaye mvyee mwekwekhigwaye talaka, agosoa ukianga.” ");
INSERT INTO bou_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu akaendeea kugombeka, “Nee kuwa na mntu yumwe mwenye vintu vingi, ambae neakavaa magwanda ya hea nyigi muno ya langi ya zambalau na gwanda dekung'aado na kugosoa sikukhuu ya ntafuno kia msi. ");
INSERT INTO bou_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aho he uvi wa mwenye vintu vingi nee kuwa na mkiwa yumwe, mwekuwa akaetwa aho zina dakwe Lazalo, ambae nee kamema vionda mwe mwii mgima. ");
INSERT INTO bou_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalo nee akakauwiya kuda phuguntio zekugwazo kulawa he meza ya uyo mwenye vintu vingi, na makui nee yakeza kumsona vionda vyakwe. ");
INSERT INTO bou_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Naho, uyo mkiwa akauya na nyuma, nao wandima wa uko uwanga kwa Muungu wakamdoa, wakamwiika hehi na Ibulahimu. Na yuda mwenye vintu vingi naye akauya na nyuma, akagewa mwe mbia. ");
INSERT INTO bou_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Uyo mwenye vintu vingi akawa na usumiizi mkai uko mwe si ya wantu wekuuyao na nyuma, akenua meso yakwe, akamwona Ibulahimu kwa hae na Lazalo hehi yakwe. ");
INSERT INTO bou_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Naho aketanga kwa mgutio, ‘Tate Ibulahimu nifiiye mbazi, umuagiiye Lazalo aginte ncha ya chaa chakwe mwe mazi, kutamiza ulimi wangu, kwaviya nasimiizwa muno mwe moto unu.’ ");
INSERT INTO bou_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akini Ibulahimu akamtambaisa, ‘Kumbuka mwanangu nee kuvoka kupata matana wekuwaho ukekaisa, nae Lazalo nee ahokea ufyaimi. Akini isasa yee ana nyemi, nawe wekhigwa usuumizo. ");
INSERT INTO bou_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ukaekeya ayo, gatigati mwetu na nywinywi kuikwa tubwi khuu, ili wakundaho kweza kwenu kulawa uku wasekudaha, na wakundaho kulawa kwenu kweza kwetu wasekudaha.’ ");
INSERT INTO bou_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Uyo ekuwaye mwenye vintu vingi naho akamba, ‘Tate, nakuombeza umuagiiye mntu aite kwe nyumba ya tati yangu, ");
INSERT INTO bou_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwaviya ninao wandugu washano awahaze, wasekweza uku kwe kusumiizwa.’ ");
INSERT INTO bou_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Akini Ibulahimu akamwamba, ‘Wandugu zako wana Magondo ya Musa na waoni wa Muungu waeke wawategeeze wowo.’ ");
INSERT INTO bou_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Akini mwenye vintu vingi akamba, ‘Khivyo Tate Ibulahimu, inga mntu enda ayuyuke kulawa he si ya wekuuyao na nyuma na kuwaitia, wenda wabade mavigaviga na kumhitukia Muungu.’ ");
INSERT INTO bou_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naye Ibulahimu akamba, ‘Inga khawanawawategeeze Musa na waoni wa Muungu khanawapatiize hata inga mntu ayuyuke kulawa kwe si ya wekuuyao na nyuma.’ ” ");
INSERT INTO bou_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu akawamba wahina wakwe, “Mbui ziekazo wantu watende mavigaviga ziaho misi zose. Akini mmbwii yakwe mntu aetae mbui izo. ");
INSERT INTO bou_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nee ni ebae mntu uyo ati nee kazongomezwa iwe kuu da kubundugia mwe singo na kutambikwa kwe mazimshindo, kusima kumgosoea yumwe wa wantu wanitongeao atende mavigaviga. ");
INSERT INTO bou_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ekauweni!” “Inga nduguyo akagosoa mavigaviga, muwakie, inga akamhitukia Muungu, mwekee. ");
INSERT INTO bou_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Inga endaho akugosooe mavigaviga maa mfungate kwa msi umwe na maa mfungate akeza kwako akamba, ‘Nahituka.’ Muwekee.” ");
INSERT INTO bou_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wagiiwa wakamwamba Zumbe, “Utiomee kuzumiiya muno.” ");
INSERT INTO bou_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naye Zumbe akawatambaisa, “Inga kuzumiiya kwenu nee kuwa kudodo inga mbeyu ndodo ya haladali, nee mdaha kuugombeka mti unu wa mkuyu, ng'oka uketwiize mwe mazimshindo nao nee uzumiiya.” ");
INSERT INTO bou_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tambe yumwe yenu ana mndima aima tanga hambu aisa ngoto. Ivi auyaho kulawa tanga, enda amwambe uyo mndima, Soo ude khande kinyio? ");
INSERT INTO bou_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Khivyo! Enda amwambe, ‘Niikia khande, uvae magwanda yako yakundigwayo unigosoee ndima na weze ugooke hanu hadi nendaho nibinde kuda na kudomea, ndiho nawe ude na kudomeea.’ ");
INSERT INTO bou_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ivi mntu uyo endaamwekhe ntogoo uyo mndima kwaajii kayagosoa yada ekwembigwayo ayagosoe? ");
INSERT INTO bou_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ivyoivyo na nywinywi mbindiizaho kugosoa yose mwekwembigwavyo kugosoa, tamwiiyani ivi, ‘Swiswi ni wandima tesao kuwa na maiho, tigenyeza yadadu tekukundigwayo kuyagosoa.’ ” ");
INSERT INTO bou_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu nee atamba kuita mwe mzi wa Yelusalemu hadi kwe mhaka wa gatigati ya Samalia na Galilaya. ");
INSERT INTO bou_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ekuwaho engia mwe mzi umwe wantu kumi dimwe wenye utamu wa nyoka nee wakintana naye, wakagooka kwa hae. ");
INSERT INTO bou_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nee wakakema na kugombeka, “Yesu mhinyi, tifiiye mbazi!.” ");
INSERT INTO bou_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ekuwaonaho akawamba, “Hitani mkeonyeshe kwa waviki.” Naho wekuwaho waita, wakang'azika. ");
INSERT INTO bou_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumwe wao ekuonaho kahonywa, nee auya kwa Yesu uku amtogoa Muungu kwa mgutio mkuu. ");
INSERT INTO bou_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nee etambika asi hemeso ya miundi ya Yesu uku amtogoa Muungu. Na mntu uyo nee ni Msamalia. ");
INSERT INTO bou_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aho Yesu akauza, “Khiyo wantu kumi dimwe wekung'azwao? Wada kenda wa hahi? ");
INSERT INTO bou_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ivi khekuoneka mntu mtuhu ekuuyae kumwekha ntunyo Muungu iya uyu mgeni ikedu?” ");
INSERT INTO bou_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu akamwamba uyo mntu, “Gooka uite, kuzumiiya kwako kukuhonya.” ");
INSERT INTO bou_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kisingi kimwe, Mafalisayo wakamuuza Yesu, “Useuta wa Muungu wenda weze ini?” Naye akawatambaisa, “Useuta wa Muungu khaweza inga kintu cha kusungumanya kwa meso. ");
INSERT INTO bou_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Khahana mntu adahae kugombeka, ‘Uuku’, hambu ‘Uhada,’ kwaajii Useuta wa Muungu uuko gatigati yenu.” ");
INSERT INTO bou_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu nee awamba wahina wakwe, “Misi yeza ambayo mwendamkunde kuona msi umwe gati msi wa Mwana wa Mntu, akini khamna muiyone. ");
INSERT INTO bou_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na wantu wenda wawambe, ‘Kauwani, yu hada!’ Hambu ‘Kauweni yu aho!’ Akini nywinywi msekulawa na kuwabasa. ");
INSERT INTO bou_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mmanye kuwa Mwana wa Mntu endaoauye, endaeze inga umbauwa umuikavyo vuupu na kumuiika phande zose za uwanga. ");
INSERT INTO bou_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akini kabla ya ayo, enda asumiizwe muno na kuemewa na wantu wa misi izi. ");
INSERT INTO bou_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Inga yekuwavyo kisingi cha Nuhu, nee vyeivyo vyendavyo viwe mwe msi wa kuuya kwa Mwana wa Mntu. ");
INSERT INTO bou_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Misi za Nuhu wantu nee waendeea kuda na kudomea, kutegua na kutegulwa hadi kisingi kia cha Nuhu ekweingiaho mwe Safina, mafuiko makuu yakeza yakaimemeeza mazi inusi na kudagamiza wose. ");
INSERT INTO bou_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Indaiwe inga yekulawiavyo kisingi cha Lutu wantu nee waendeea kuda na kudomea, kugua na kutaga, kuhanda mbeyu na kuzenga. ");
INSERT INTO bou_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Akini msi uda Lutu ekuhaukaho Sodoma, moto mkai nee useeya kulawa uwanga inga fua na kuwadagamiza wantu wose. ");
INSERT INTO bou_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nee ivyo vyendavyoviwe msi uda Mwana wa Mntu endaho agubulwe.” ");
INSERT INTO bou_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Misi iyo, mntu yoyose endae awe uwanga ya chusi asekuseea kuita nyumbani kudoa vintu vyakwe. Ivyo, nae mwendae awe tanga asekuuya kaya kudoa chochose. ");
INSERT INTO bou_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkumbukani yada yekumpatayo mkaza Lutu. ");
INSERT INTO bou_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mntu yoyose endae akunde kuuohowa ugima wakwe, endaawaze na mntu yoyose awazaye ugima wakwe enda auohowe. ");
INSERT INTO bou_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nawamba, kio cha msi uwo wantu waidi wendawawe wagona hamwe mwe usazi, yumwe endaadoigwe na yuda mtuhu endaabadwe. ");
INSERT INTO bou_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wavyee waidi wenda wawe wabunduga, yumwe enda adoigwe na mtuhu enda abadwe. ");
INSERT INTO bou_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wantu waidi wenda wawe mwe mnda waima, yumwe enda adoigwe na mtuhu enda abadwe.” ");
INSERT INTO bou_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wahina wakwe wakamuuza, “Zumbe, ayo wekugombekayo yendayalawiiye hahi?” Naye Yesu akawatambaisa kwa msimo akagombeka, “Henaho mwii wekuuyo na nyuma, aho ndiho mbizi wendaowakintane.” ");
INSERT INTO bou_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu akawamba wahina wakwe msimo ili awahinye kuwa wakundigwa kuvika kia maa na wasekufa maya. ");
INSERT INTO bou_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nee amba, “Mwe mzi umwe kuwa na muamuwa ambae nee khamvika Muungu wala kupatiiza mntu yoyose. ");
INSERT INTO bou_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mwe mzi wouwo nee kuwa na mvyee yumwe mwekufiiwa nimgosi ekuwaye kambasa uyo muamuwa maa nyingi, akoonda amfiiye mbazi ekhigwe vintu vyakwe kulawa kwa mmasa wakwe. ");
INSERT INTO bou_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa kisingi kilehacho uyo muamuwa nee khakukunda kumfiiya mbazi uyo mwekufiiwa na mgosi, akini kisiikizi akamba, ‘Etiho mie khimuogoha Muungu wala khipatiiza mntu, ");
INSERT INTO bou_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","akini kwaviya uyu mvyee mwekufiiwa ni mgosi anipisha, nendanigosoe dodose adi ekhigwe vintu vyakwe, ama khivyo endaaendee kubua hanu, na kisiikizi endaanisokeze muno!’ ” ");
INSERT INTO bou_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naho Zumbe nee aendeea kutamwiiya, “Tegeezani ekugombekavyo uyo muamuwa mfyaimi. ");
INSERT INTO bou_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ivi Muungu khana awagosoee vitana wantu wakwe ekuwasaguwao wada ambao wamwiiya kio na musi? Ivi enda acheewe kuwaambiza? ");
INSERT INTO bou_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nawamba endaawaambize kinyio. Akini ivi Mwana wa Mntu endaho auye mwe inusi endaawaone wantu wamzumiao?” ");
INSERT INTO bou_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu akawamba msimo unu kwa wada weonao ni wedi na kuwabeya watuhu. ");
INSERT INTO bou_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wantu waidi nee waita he Nyumba ya Muungu kuvika, yumwe ne kawa Mfalisayo na mtuhu mtoza kodi. ");
INSERT INTO bou_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Uyo Mfalisayo nee agooka, akavika mwe moyo wakwe, ‘Ee Muungu, nakutogoa kwaviya mie khiyo inga wantu watuhu, Wameo, watiizi na wakianga. Nakutogoa mie khio inga mntu uyu mtoza kodi. ");
INSERT INTO bou_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mie nehiniza kuda maa mbii kwa kia juma, nalavya malavyo hantu ha kumi dimwe ya myengizo yangu yose.’ ");
INSERT INTO bou_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Akini yuda mtoza kodi, akawa kagooka kwa hae uku aogoha hata kwenua meso yakwe uwanga kwa Muungu, yee akenamia kwa huzuni na kutoza kifua chakwe nee amba, ‘Ee Muungu, unifiiye mbazi mie mwenye mavigaviga.’ ");
INSERT INTO bou_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nawamba, uyo mtoza ushuu akauya nyumbai akawa kafiiwa mbazi. Akini yuda mtuhu, khivyo. Yuda etendae kuwa mkuu enda atendwe mdogo, na kia etendae mdodo enda atendwe kuwa mkuu.” ");
INSERT INTO bou_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Msi umwe wantu wakamwetea Yesu wana wadodo awaikie mikono yakwe ili awajaie. Wahina wakwe wekuwaonaho, wakamuwakia. ");
INSERT INTO bou_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Akini Yesu akawetanga hakwe akamba, “Wabadeni awa wana weze kwangu, wala msekuwaemeza, kwaviya Useuta wa Muungu ni kwaajii ya wantu inga awa. ");
INSERT INTO bou_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nawamba kwei, mntu yoyose esaekuuhokea Useuta wa Muungu inga mwana mdodo, khana engie mwe Useuta uwo.” ");
INSERT INTO bou_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkuu yumwe Myahudi nee amuuza Yesu, “Mhinyi yedi, nigosoe mbwai nidahe kuupata ugima wa misi yose kwesaho kisiikizi?” ");
INSERT INTO bou_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akamtambaisa, “Mbona wanetanga yedi? Khahana ekuwaye yedi iya Muungu ikedu. ");
INSERT INTO bou_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wazimanya mwiko za Musa, ‘Usekuwa mkianga, usekukoma, usekubawa, usekumkoea mntu masa kwa uhokho, watunye tati yako na mami yako.’ ” ");
INSERT INTO bou_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yee akamba, “Ayo yose khiyatoza kuvokea udodo wangu.” ");
INSERT INTO bou_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ekutegeezaho ayo, akamwamba, “Wakundigwa kugosoa mbui mwenga. Taga kia kintu wenacho, uwapangie wakiwa iyo hea, nawe wendauwe na kiikizo uko uwanga kwa Muungu na khiyo vintu inga vya inusi ukabinda soo unibase.” ");
INSERT INTO bou_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Akini uyo mntu ekutegeezaho ayo, ne akaona usungu muno kwaajii nee kawa mntu mwenye vintu vingi muno. ");
INSERT INTO bou_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ekumuonaho anausungu, ivyo akamba “Mntu mwenye vintu vingi khadaha kwengia kihufu kwe Useuta wa Muungu! ");
INSERT INTO bou_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nivihufu muno kwa ngamia kwemboka mwe poota da singano kusima, mwenye vintu vingi kwengia mwe Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wada wantu wekutegeezaho ayo, wakamuuza Yesu, “Nndai naho adahae kuoholwa?” ");
INSERT INTO bou_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu akawatambaisa, “Yesayokudahika kwa wantu, kwa Muungu yadahikana.” ");
INSERT INTO bou_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naye Petulo akamuuza, “Kauwa, tibada vyose tekuwavyo navyo tikakubasa!” ");
INSERT INTO bou_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu akamwamba, “Kwei nawagombeka khahana hata yumwe ekubadae nyumba yakwe na mkaziwe hambu wanduguze hambu wavyazi wakwe hambu wana wakwe kwaajii ya Useuta wa Muungu, ");
INSERT INTO bou_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","endaahokee vingi muno mwe inusi inu na ugima wa misi yose kwesaho kisiikizi mwe Useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ne awadoa khandai wada wahina wakwe kumi dimwe na waidi, akawamba, “Nitegeezani! Taita Yelusalemu na uko kia kintu chekundikwacho na Waoni wa Muungu kuusu Mwana wa Mntu kindakigosolwe. ");
INSERT INTO bou_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naye wendawamwegae na kuguiwa na wantu wesaokuwa Wayahudi, nao wendawambee, wenda wamdumuwe na kusuiwa ovu. ");
INSERT INTO bou_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wenda wamtoe makoto na kumkoma. Akini msi wa ntatu endaayuyuke.” ");
INSERT INTO bou_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iya wahina wakwe khawekumanya mana yakwe mbui izi, kwaviya nee ifiswa kwao, nao khawokummanya Yesu nee akagombeka mbwai. ");
INSERT INTO bou_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kisingi Yesu ekuwabuwaho hehi na mzi wa Yeliko, neekuwa na mntu yumwe tuntu kekaa khandai ya sia aombeza. ");
INSERT INTO bou_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yuda mntu tuntu ekusikiaho mgutio wa zumwezumwe da wantu dikemboka akauza, “Kunani?” ");
INSERT INTO bou_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wakamwamba, “Yesu kulawa Nazaleti emboka.” ");
INSERT INTO bou_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nee alavya mgutio akamba, “Yesu, Mwana wa Daudi, nifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wada wantu wekuwao waongoa hemeso wakamuwakia anyamae. Akini yee akaendeea kulavya mgutio muno, “Mwana wa Daudi, nifiiye mbazi!” ");
INSERT INTO bou_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu akagooka, akawagiiya wada wantu wamwegae hemeso yakwe. Yuda tuntu ekubuwaho hehi, Yesu akamuuza, ");
INSERT INTO bou_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wakunda nikugoswee mbwai?” Naye akatambaisa, “Zumbe, nakunda kukauwa.” ");
INSERT INTO bou_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu akamwamba, “Kauwa! Kuzumiiya kwako kukuhonya.” ");
INSERT INTO bou_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ahoaho uyo mntu tuntu akadaha kukauwa, akambasa Yesu akamtogoa Muungu. Wantu wose wekuonaho ayo, wakamtogoa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu akengia mwe mzi wa Yeliko, nae nekawa akemboka gatigati ya sia ya mzi uwo. ");
INSERT INTO bou_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mwe mzi uwo neekuwa na mntu yumwe zina dakwe Zakayo. Mntu huyo neekawa mwenye vintu vingi na nekawa mkuu wa watoza kodi. ");
INSERT INTO bou_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yee nee akakunda kumkauwa Yesu kuwa ni mntu wa namna yani. Akini kwaajii ya zumwezumwe kuu da wantu khekudaha kumkauwa kwaviya nee ni mjihi. ");
INSERT INTO bou_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ivyo akaongoa hemeso ya zumwezumwe da wantu, akafida uwanga ya mkuyu adahe kumwona Yesu, kwaajii enda embokee sia ida. ");
INSERT INTO bou_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Naho Yesu ekubuwaho hantu hada, akakauwa uwanga akamwamba, “Zakayo, seeya kinyio kwaajii ivyeeo nlazima nisinde kaya hako.” ");
INSERT INTO bou_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo ne aseeya kinyio, akamhokea Yesu mwe nyumba yakwe kwa kinyemi kikuu. ");
INSERT INTO bou_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wantu wose wekuonaho ayo, wakavoka kung'ung'uzika wakamba, “Kaita kuwa mgeni kwa mntu mwenye mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Akini Zakayo akagooka, akamwamba Yesu, “Tegeezani, Zumbe! Miye nendaniwekhe wakiwa ntii ya vintu vyangu, na inga khimhoka mntu yoyose kintu, nendanimvuzie maa kane.” ");
INSERT INTO bou_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu akamwamba, “Ivyeo uohozi ubua mwe nyumba inu, kwaviya uyu ni uvyaigwa wa Ibulahimu.” ");
INSERT INTO bou_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwamana Mwana wa Mntu keza kuondeza na kuohowa wantu wekwagao. ");
INSERT INTO bou_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wantu wekuwaho wakategeeza Yesu, nee Yesu akawamba msimo uwo. Aho nekawa hehi na kubuwa mzi wa Yelusalemu, na wantu wada nee wamamakhanya kuwa Useuta wa Muungu weza saa iyo iyo. ");
INSERT INTO bou_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ivyo akawamba, “Nee kuwa na mntu yumwe mtunywa muno akafunga ntambo ya kuita si ya hae asimikwe kutendwa Seuta, akabinda auye mwe si yakwe. ");
INSERT INTO bou_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ivyo ekuwaho khazati kuhauka, akawetanga wandima wakwe kumi dimwe, akawekha fungu da hea kwakiya yumwe na kuwamba, ‘Mzigoswee biashaa izi hea hadi nendaho niuye.’ ");
INSERT INTO bou_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Akini wantu wa si yakwe mwenye, nee wakamkima ivyo wakawagiiya wantu nyuma yakwe wakambe, ‘Khatimkunda uyu awe Seuta wetu.’ ” ");
INSERT INTO bou_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hata ivyo ekuuyaho mwe si yakwe kawakae Seuta, ahoaho akawetanga wada wandima wakwe wekuwao kawabadai hea, amanye myengizo niya kima chani kwakiya yumwe ekupatacho. ");
INSERT INTO bou_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mndima ya bosi akaawiiya akamba, ‘Zumbe fungu dako dieta maa kumi dimwe.’ ");
INSERT INTO bou_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nae akamwamba, ‘Ni vyedi, wee ni mndima yedi kwaviya umzumiiwa mwe mbui ndodo, na wendauwe mgookezi mwe mizi kumi dimwe.’ ");
INSERT INTO bou_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mndima wa kaidi akeza akamba, ‘Zumbe fungu dako wekunekhado dieta mafungu mashano.’ ");
INSERT INTO bou_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nae akamwamba, ‘Nawe wendauwe mgookezi mwe mizi mishano.’ ");
INSERT INTO bou_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mndima wa ntatu nae akeza nakumwamba, ‘Zumbe doa fungu dako, kwaviya ne khidiika he mkwiji desekwaga.’ ");
INSERT INTO bou_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kwajii nee khiogoha kwaviya wee ni mntu mkai. Wadoa wesacho kuika kintu na wabonda hantu wesaho kuhanda kintu. ");
INSERT INTO bou_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nae akamwamba, ‘Wee mndima mfyaimi! Nenda nikuamuiye kulawana na mbui zako wekugombekazo, nee ukamanya kuwa mie ni mntu mkai, nadoa vintu vyesavyokuwa vyangu na kubonda kwesiho kuhanda. ");
INSERT INTO bou_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ni vyedi, akini kwa mbwai khwekuika hea zangu kwa wada walavyao nyongeza, nami ne khiidoa hamwe na mwengizo aho nendaho niuye kwangu?’ ");
INSERT INTO bou_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aho akawamba wada wekuwao hada, ‘Mhokeni ido fungu da hea, mkamwekhe yuda mwekuwa na mafungu kumi dimwe.’ ");
INSERT INTO bou_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naho wakamwamba, ‘Akini Zumbe, tayali ana mafungu kumi dimwe.’ ");
INSERT INTO bou_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nae akawatambaisa, ‘Kia ekuwaye na kintu endaekhigwe na kumemeezewa. Akini yuda mwesena, hata kia ekuwacho nacho chenda kidoigwe, ");
INSERT INTO bou_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","akini wada wamasa wangu wesao kukunda mie niwe Seuta wao, waeteni hanu mkawakome hemeso yangu.’ ” ");
INSERT INTO bou_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ekubindaho kugombeka ayo, akawaongweeya kuita Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ekuwaho hehi kubua mzi wa Betifage na mzi wa Besaniya hehi na muima wa Mizaituni, akawagiiya wahina wakwe waidi, ");
INSERT INTO bou_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akawamba, “Hitani mwe mzi uda weiho hemeso yenu, mwendaho mwengia mwe mzi, mwenda mubwiie mwana phunda kazengetezwa sigi khazati kumwenua mntu. Mchopoeni mmwete hanu. ");
INSERT INTO bou_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mntu akawauza kwambwai mwamchopoa mmwambe, ‘Zumbe amkunda.’ ” ");
INSERT INTO bou_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naho wakaita, wakabwiia kia kintu inga Yesu ekuwambavyo. ");
INSERT INTO bou_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wekuwaho wamchopoa yuda mwana phunda, mwenye wakawauza, “Kwa mbwai mwamchopoa mwana phunda uyu?” ");
INSERT INTO bou_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wahina wakwe wakawatambaisa, “Zumbe amkunda.” ");
INSERT INTO bou_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nee wamwegaiya Yesu yuda mwana phunda, wakatandika magwanda yao uwanga yakwe, Yesu akakwea uwanga ya mwana phunda. ");
INSERT INTO bou_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu akaendeea na ntambo, na wantu wakatandaza magwanda yao mwe sia. ");
INSERT INTO bou_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ekuwaho hehi na mzi wa Yelusalemu, mwe mpolomoko wa muima wa Mizaituni, zumwezumwe kuu da wantu na wahina wakwe wakavoka kutoa kheegee na kuwa nyemi na kumtogoa Muungu kwa mgutio mkuu, kwaajii ya mbui khuu wekuonayo, ");
INSERT INTO bou_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","uku wagombeka, “Ajaiwe Seuta ezae kwa udaho wa zina da Zumbe. Uivanisa uwanga kwa Muungu, na Ukuu kwa Muungu!” ");
INSERT INTO bou_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aho wamwe wa Mafalisayo wekuwaaho mwe diya zumwezumwe da wantu wakamwamba Yesu, “Mhinyi, wawakie wahina wako wanyamae!” ");
INSERT INTO bou_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akawatambaisa, “Nawamba inga awa wakanyamaa, maiwe yenda yatoe vuzo.” ");
INSERT INTO bou_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ekuwaho hehi na mzi wa Yelusalemu, na ekuonaho uwo mzi Yesu akauiiya, ");
INSERT INTO bou_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akagombeka kuusu wantu wa mzi uwo, “Nee nikakunda hata ivyeo ii mmanye mbui zietazo uivanisa. Akini isasa yafiswa na khamdaha kuiona uwo utuivu. ");
INSERT INTO bou_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwaviya misi yeza ambaho wamasa wako wendawazenge ukanto mntintimavu kuika buha mzi wose, na aho wendawakutoe kulawa phande zose. ");
INSERT INTO bou_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wenda wakuhondehonde wee hamwe na wana wako ndani ya viambaza vyako, nao khawana wakuekee hata iwe dimwe uwanga ya tuhu, kwaajii kwekumanya kisingi Muungu ekwezaho kukuohoa.” ");
INSERT INTO bou_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Naho, Yesu akengia he buha da Nyumba ya Muungu, akavoka kuwalavya chongoi wata biashaa, ");
INSERT INTO bou_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Muungu agombeka, “Iyandikwa, ‘Nyumba yangu indaiwe nyumba ya kuvika.’ Akini nywinywi muigosoa hantu ha kufisa wahokaji.” ");
INSERT INTO bou_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kia msi Yesu neekawa he Nyumba ya Muungu. Waviki wakuu na wahinyi wa miko na waongoezi wa wantu ne wakakunda kumkoma, ");
INSERT INTO bou_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","akini ne khawakuwa na dakugosoa, kwaviya wantu wose wawa wamtegeeza kwa vitana muno. ");
INSERT INTO bou_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Msi umwe, Yesu ekuwaho awahinya wantu he Nyumba ya Muungu na kuwabiikia Mbui yedi, Waviki Wakuu na Wahinyi wa miko hamwe na wadaa wakabua, ");
INSERT INTO bou_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wakamba, “Tigombekee! Wagosoa mbui izi kwa udaho wa ndai? Ni ndai mwekukwekha udaho unu?” ");
INSERT INTO bou_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu akawauza, “Na mie nendaniwauze mbui. Nambiani, ");
INSERT INTO bou_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","udaho wa Yohana wa kubatiiza uwanga kwa Muungu hambu kwa wantu?” ");
INSERT INTO bou_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Akini wowo wakauzana ivi, “Inga tikamba, ‘Ulawa uwanga kwa Muungu,’ yee enda atiuze, ‘Mbona khamwekumzumiiya?’ ");
INSERT INTO bou_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Akini tikamba, ‘Yaawa kwa wantu,’ wantu wose wendawatitoe kwa maiwe kwaajii wazumiiya kuwa Yohana ne kawa muoni wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nao wakamtambaisa, “Khatimanya udaho uwo wekuawako.” ");
INSERT INTO bou_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu akawamba, “Hata mie khina niwambe nagosoa mbui izi kwa udaho wa ndai.” ");
INSERT INTO bou_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu akaendeea kugombeka na wantu msimo unu, “Mntu yumwe nee kaima mnda wa mizabibu, akadikodisha kwa waimi, naho akatamba kwa kisingi kileacho. ");
INSERT INTO bou_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kisingi cha kubonda, mntu uyo nee akamuagiiya mndima wakwe kwa wada waimi, akadoe fungu dakwe da ubosi wa mnda wa mizabibu. Akini wada waimi wakamtoa mndima uyo, wakamguusa kwesaho kumwekha kintu. ");
INSERT INTO bou_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yuda mwenye mnda akamuagiiya vituhu mndima mtuhu, akini wowo wakamtoa uyo viyaviya na kumgosoea ufyaimi, wakamguusa kwesaho kumwekha kintu. ");
INSERT INTO bou_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akamuagiiya mndima wa ntatu vituhu, uyo naye wakamsuumiza, wakamguusa kwesaho kintu. ");
INSERT INTO bou_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yuda zumbe mwenye mnda wa mizabibu akamamakhanya, ‘Nendanigosoe mbwai? Nendanimuagiiye mwanangu nimkundisae, inga wendawamtunye.’ ");
INSERT INTO bou_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wada waimi wekumuonahodu, wakamba, ‘Uyu ne mpazi. Ivyo timkome upazi wakwe utende wetu.’ ");
INSERT INTO bou_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ndiho wakamlavya chongoi mwe uda mnda wa mizabibu, wakamkoma.” Yesu akawauza, “Yuda zumbe mwenye mnda endaawatende mbwai awo waimi? ");
INSERT INTO bou_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Endaeze kuwakoma waimi awo, na kuwekha waimi watuhu uwo mnda wa mizabibu.” Wantu wekusikiaho mbui ziya. Wakamba, “Khivyo! Yasekulawiiya katu!” ");
INSERT INTO bou_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Akini Yesu akawafuiya meso akawamba, “Maandiko aya Muungu yana mana yani? ‘Iwe wekuemeado wazengi, Isasa diwa iwe kuu da msingi’ ");
INSERT INTO bou_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mntu yoyose akagwa uwanga ya iwe ido, endaabondeke bondeke, dikamguiya mntu yoyose, dendadimbonde nyang'anyang'a.” ");
INSERT INTO bou_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wahinyi wa miko na waviki wakuu wekumanyaho kuwa msimo uwo neuwa wawausu, ivyo wakakunda kumgwiiya hadahada, akini wakawaogoha wantu. ");
INSERT INTO bou_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kwaivyo wakuu awo wakawa wanambengea Yesu wamgwiie. Aho wakawekha wantu mlungula, na kuwagiiya waite kumuuza mbui, wantu awo waketenda kuwa ni wedi, kumbe nee wakaondeza sia ya kumgwiiya Yesu kwa mbui zakwe ili waite kumuahiiya masa kwa wagookezi wa Kilumi. ");
INSERT INTO bou_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aho wantu wekuagiiwao wakamwamba, “Mhinyi, tamanya kuwa wee wagombeka na kuhinya mbui za kwei, tamanya kuwa wee khuna ubahuzi, wahinya kwei wantu wakundigwavyo kwekaa inga akundavyo Muungu. ");
INSERT INTO bou_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Naho, tambie kulawana na miagiiyo yetu ivi yakundigwa kuiha kodi kwa Kaisali, hambu khivyo?” ");
INSERT INTO bou_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Akini Yesu ne abukhua unyanyi wao, akawamba, ");
INSERT INTO bou_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Nioneshani iyo senti. Cheni na zina idi ni da ndai? Nawo wakamtambaisa, “Ni ya Mkuu wa Lumi.” ");
INSERT INTO bou_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu akawamba, “Yekuwayo ya Kaisali mwekheni kaisali, na yekuwayo ya Muungu mwekheni Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naho wantu wada khawekudaha kumgwiiya kwa yada ekuwayo kagombeka hemeso ya wantu. Nao wakahondomaa muno na mitambaiso yakwe, wakanyamaa myee. ");
INSERT INTO bou_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Naho wamwe wa Masadukayo, ambao wagombeka kuwa wekuuyao na nyuma khawayuyuka, wakamwezea Yesu na kumuuza, ");
INSERT INTO bou_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mhinyi, Musa katiandikia kuwa inga ndugu ya mntu yumwe akauya na nyuma na kumbada mvyee yakwe kwesaho wana, yakundigwa kakie ampae uyo mvyee, na amvyaie nduguye wana. ");
INSERT INTO bou_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nekuwa na ndugu mfungate, yuda wa bosi ne kategua na kisingi kwemboka akauya na nyuma kwesaho kubada mwana. ");
INSERT INTO bou_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yuda ndugu wakaidi akampaa yuda mvyee mwekufiiwa ni mgosi, kisingi kwemboka akauya na nyuma kwesiho kubada mwana, ");
INSERT INTO bou_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na ndugu wa ntatu akampaa yuda mvyee kisingi kwemboka akauya na nyuma. Na mbui zikawa ziyaziya kwa wose mfungate ne wauya na nyuma kwesaho kubada wana. ");
INSERT INTO bou_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kisiikizi yuda mvyee akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ivi msi wantu kuyuyuswa, mmaa uyo endaawe mvyee wa ndai? Kwaviya wose mfungate nee wamtegua.” ");
INSERT INTO bou_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akawamba, “Wantu wekaisao mwe inusi isasa wategua na kutegulwa, ");
INSERT INTO bou_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","akini wada wantu ambao Mungu anaona kuwa wafaa kwepata hantu mwe inusi kuyuyuswa, khawategua wala kutegulwa. ");
INSERT INTO bou_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Awa khawadaha kuuya na nyuma vituhu, kwaajii wendawawe inga wandima wa uwanga kwa Muungu. Wao ni wana Muungu kwaviya wayuyuswa. ");
INSERT INTO bou_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Akini mbui inu ya kuyuyuka kulawa kwa wekufao, hata Musa kagombeka kuwa wantu wekuuyao na nyuma wenda wayuyuswe, kagombeka ayo mwe Maandiko ya Muungu. Hada yekugombekayo uwanga ya mbui za kisaka chekuwacho chaka moto, nee kagombeka kuwa yee nee Zumbe ‘Muungu wa Ibulahimu na Muungu wa Isaka na Muungu wa Yakobo.’ ");
INSERT INTO bou_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yee Muungu khio Muungu wa wekuuyao na nyuma iya kwa wekuwao na ugima, kwaajii wose ambao ni wagima.” ");
INSERT INTO bou_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wamwe wa wada Wahinyi wa miko wakamba, “Mhinyi, kutamwiiya vyedi muno.” ");
INSERT INTO bou_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wakamba ivyo kwaajii khawekuandua kumuuza vituhu mbui ntuhu. ");
INSERT INTO bou_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu akawauza, “Yadahika viivihi wantu wambe kuwa Klistu ni mwana wa Daudi? ");
INSERT INTO bou_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi mwenye nee kaandika mwe kitabu cha Zabui, ‘Zumbe Muungu nekamwamba Zumbe wangu, ekaa phande yangu ya kuume, ");
INSERT INTO bou_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Adi nikugosoe uwavote wamasa wako na kuwagookea wawe asi yako.’ ");
INSERT INTO bou_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ikawa Daudi amwetanga Klistu, ‘Zumbe,’ naho yendaiwe viivihi awe mwanawe?” ");
INSERT INTO bou_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wantu wose wekuwaho wakamtegeeza, Yesu akawamba wahina wakwe, ");
INSERT INTO bou_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ekaeni hae na wahinyi wa miko ambao wakunda kwenda wevaiya khazu zilehazo, wakunda kuuguswa na wantu kwa kutunywa kwe magwiiyo. Kwekaa hantu ha kutunywa mwe Nyumba ya kukintania Wayahudi na kudoa hantu hakutunywa mwe ntafuno, ");
INSERT INTO bou_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","wao uda nyumba za wekufiiwao ni wagosi, ili waoneke kuwa ni wedi kwa kuvika mda uleaho. Awo wenda wekhigwe sugusa khai muno!” ");
INSERT INTO bou_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Naho Yesu akakauwa phande zose, akawaona wenye vintu vingi wekuwavyo wagea malavyo yao kwe ntezu za kiikizo he Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akamwona pia mvyee yumwe mwekufiiwa ni mgosi akagea umo sensi mbii ndodo. ");
INSERT INTO bou_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naho, akamba, “Nawamba ukwei, mvyee uyu mwekufiiwa ni mgosi na mkiwa kagea mwe ntezu kima kikuu kusima wekulavyao wose. ");
INSERT INTO bou_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa viya, watuhu wose walavya malavyo kidodo mwe vintu vyao vingi, akini uyu mvyee mwekufiiwa ni mgosi etiho ni mkiwa kalavya vyose ekuwavyo navyo, ekutegemeavyo kwa kwekaa kwakwe.” ");
INSERT INTO bou_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wamwe wa wahina wakwe nee wamwonyesha Nyumba ya Muungu yekuhambavyo vitana kwa maiwe na kwa vintu vyekulavigwavyo kuwa malavyo kwa Muungu. Akini Yesu akawamba, ");
INSERT INTO bou_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Aya yose muonayo misi yenda yeze ambaho khahana hata iwe dimwe dindado disigae uwanga ya ntuhu, kiya kintu chenda kibomolwe.” ");
INSERT INTO bou_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Naho, wahina awo wakamuuza, “Mhinyi, mbui izi zendazilawiiye ini? Ni utangio wani wendao uwonyeshe ati mbui izo zihehi kulawiiya?” ");
INSERT INTO bou_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu akawatambaisa, “Ekaani hae, msekweza mkatiiwa. Kwaviya wangi wendawalawiiye he zina dangu, kiya yumwe enda etenda kuwa yee ni miye nee Klistu, vituhu wenda watamwiiye kisiikizi cha inusi kihehi. Akini nywinywi msekuwabasa. ");
INSERT INTO bou_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Naho mwendaho msikie mbui za khondo na misuumizo msekuogoha, kwaviya nlazima ayo yavoke kulawiiya, akini kisiikizi cha inusi khauzati.” ");
INSERT INTO bou_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nee aendeea kugombeka, “Si mwenga yendaitowane na si ntuhu, na useuta umwe wendautoane na useuta mtuhu. ");
INSERT INTO bou_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kia hantu hendahawe na mizingizo mikuu ya mweinusi, saa khai na matamu mafyaini muno. Wantu wenda waone vintu vya kutisa inga utangio kulawa uwanga. ");
INSERT INTO bou_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Akini kisingi khayazati kulawiiya ayo, wenda wawagwie, wenda wawasumiize na kuwegaa mwe Nyumba ya kukintania Wayahudi na kuwagea kwe kifungo, mwendamwegalwe hemeso ya maseuta na wagookezi kwaajii ya zina dangu, ");
INSERT INTO bou_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","inu indaiwe phasi yenu kuvuhuzia. ");
INSERT INTO bou_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Akini msekuwa na matumatu mwe mioyo yenu kuwa mwendamtamwiiye mbwai uko ");
INSERT INTO bou_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwaviya nendaniwekhe mbui za kutamwiiya na umanyi ambaho khahana mmasa wenu yumwe endaeadahe kuhigana nayo wala kuyaemea. ");
INSERT INTO bou_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wavyazi wenu na ndugu na wambuya wenu wendawawahituke nywinywi, na wamwe wenu wenda wakomwe. ");
INSERT INTO bou_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wantu wose wendawawakime kwaajii ya zina dangu. ");
INSERT INTO bou_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Akini, hata fii mwenga ya mtwi wenu khaunawage. ");
INSERT INTO bou_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa kuzizimiza kwenu, mwendamuohoe ugima wenu. ");
INSERT INTO bou_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mwendaho muone mzi wa Yelusalemu uikwa bunga na maasikai, manyeni kuwa kisingi kibua ambaho mzi uwo undaubanangwe. ");
INSERT INTO bou_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aho, wekuwako mwe mzi wa Yudea waguukie miimani, wada weaho mwe mzi nlazima walawe, na wada weaho mwe minda wasekuuya mwe mzi. ");
INSERT INTO bou_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwaviya misi iyo ni misi za sugusa, ili yose yekugondwayo yaiganie. ");
INSERT INTO bou_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mmbwii yao wekwenua ndaa na waokhesao misi iyo! Kwaviya kundakuwe na masuumizo makuu mwe inusi, na sugusa ya Muungu indaisee kwa wantu awa. ");
INSERT INTO bou_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Watuhu wenda wawakomwe kwa paange, na watuhu wenda wegalwe wandima mwe si ntuhu. Nao mzi wa Yelusalemu wendaujatwe na wantu wesaokuwa Wayahudi wenda waugookea mzi uwo kwa nguvu, na kuwasuumiza wantu wakwe. ");
INSERT INTO bou_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kundakuwe na utangio mwe zua na mweenge na ntoondo. Na aha mwe inusi na si wantu wenda wawe na suuba na maatu kulawana na mkubwaniso mkuu muno wa mazimshindo. ");
INSERT INTO bou_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wantu wendawazumiiye kwaajii ya kuogoha, wakimamakhanya ni kihi chendachokilawiie mwe inusi, kwaviya udaho wa vintu vya uwanga kwa Muungu vyendavisingisike. ");
INSERT INTO bou_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naho wendawamwone Mwana wa Mntu akeza mwe zunde, mwenye udaho na Ukuu mwingi. ");
INSERT INTO bou_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kisingi mbui izo yendaho yavoke kulawiiya, gookeni na kwenua mitwi yenu uwanga, kwaviya uohozi wenu uhehi.” ");
INSERT INTO bou_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Naho akawamba msimo unu, “Kauwani mtini na miti mituhu yose.” ");
INSERT INTO bou_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mwendaho muone kuwa ivoka kuhota mani, mwamanya kuwa miongo ya kubonda ihehi. ");
INSERT INTO bou_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ivyoivyo, mwendaho muone mbui izo zagosoka, mwenda mmanye kuwa Useuta wa Muungu uhehi. ");
INSERT INTO bou_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kwei nawamba wantu wa kivyazi iki cha isasa khakina chemboke adi ya ayo yose kugosoka. ");
INSERT INTO bou_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Uwanga kwa Muungu na inusi zenda zemboke akini mbui zangu khazina zemboke. ");
INSERT INTO bou_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Muwe meso, mioyo yenu isekweza ikatozwa na mbui za makwasukwasu, ukozi na ndima za ugima. Ama khivyo, msi uda undauwezee vuupu. ");
INSERT INTO bou_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwaviya undaumyezee inga mtego wantu wose wekaao mwe inusi yose. ");
INSERT INTO bou_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Muwe meso kisingi chose, na vikani misi yose ili Mungu awaambize kuvuka yose yendayoyalawiiye mdahe kuwa na udaho wa kwemboka kwesio suuba mwe mbui izi zose yendayoyalawiiye, na kugooka hemeso ya Mwana wa Mntu.” ");
INSERT INTO bou_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kia msi wa musi Yesu ne kawa akahinya wantu he Nyumba ya Muungu, akini kio ne kawa akaita he muima wa Mizaituni na kwekaa uko. ");
INSERT INTO bou_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Wantu wose ne waita he Nyumba ya Muungu keo da mtungaihu wadahe kumtegeeza Yesu. ");
INSERT INTO bou_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sikukhuu ya mabumunda yesayo kugewa hamila, yetangwayo sikukhuu ya Pasaka, nee iwa ihehi. ");
INSERT INTO bou_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Waviki wakuu na wahinyi wa miko nee wawa waondeza sia ya kumkoma Yesu, akini nee wakawaogoha wantu. ");
INSERT INTO bou_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naho, ibiisi nee amwengiiya Yuda etangwaye Isikalioti, yumwe wa wada wahina kumi dimwe na waidi. ");
INSERT INTO bou_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda Isikalioti akaita, akagombeka na waviki wakuu na wagoja wa Nyumba ya Muungu akatamwiiya nao namna wendavyo wamgwiye Yesu. ");
INSERT INTO bou_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nao nee wawa na kinyemi na kwevana naye kumuiha hea. ");
INSERT INTO bou_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda Isikalioti akazumiiya, nee ahaondeza hantu hatana hakumwekhiiza Yesu kwesaho wantu kumanya. ");
INSERT INTO bou_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Naho, msi wa mabumunda yesayo kugewa hamila ikabua. Iyo nee msi ambaho Mwanangoto wa Pasaka alavigwa ntambiko. ");
INSERT INTO bou_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ivyo Yesu akawagiiya Petulo na Yohana, akawamba, “Hitani mkatiikie khande tidahe kuda Pasaka.” ");
INSERT INTO bou_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naho wakamuuza, “Wakunda tikuikie hahi?” ");
INSERT INTO bou_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akawamba, “Tegeezani! Mwendaho muwe mwaita mwe uwo mzi, mwenda mkintane na mgosi kenua biga da mazi. Mtongeeni hadi mwe nyumba endayo engie. ");
INSERT INTO bou_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mmwambe mwenye nyumba, ‘Mhinyi akuuza, ki hahi kiya chumba ambaho nendanide Pasaka hamwe na wahina wangu?’ ");
INSERT INTO bou_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naye enda awaonyeshe chumba kikuu kwe goofa ambacho kiikwa tayali, ikani umo”. ");
INSERT INTO bou_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naho wakaita, wakabwiiya kia kintu nsawa inga Yesu ekuwavyo kawamba, waika ntafuno ya Pasaka. ");
INSERT INTO bou_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mda wekubuwaho, Yesu akekaa ade khande hamwe na wagiiwa wakwe. ");
INSERT INTO bou_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akawamba, “Nee khitamiwa muno kuda Pasaka inu hamwe nanywi kabla ya kusumiizwa kwangu. ");
INSERT INTO bou_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Isasa nawamba, khina niide vituhu ntafuno ya Pasaka adi hada yendahoiiganie mwe useuta wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naho akakidoa kikombe cha divai, akatogoa, akavika, “Hokeani, mpangane. ");
INSERT INTO bou_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwa viya nawamba, khina nidomee vituhu divai ya mzabibu hadi Useuta wa Muungu wendaho weze”. ");
INSERT INTO bou_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Akadoa bumunda, akatogoa Muungu, akaubendua, akawekha akamba, “Unu nee mwii wangu ulavigwao kwaajii yenu. Gosoani ivi kwa khumbuso yangu.” ");
INSERT INTO bou_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akagosoa ivyoivyo na kikombe cha divai ekubindaho kuda akagombeka, “Kikombe iki cha divai nee Diyagane dihya dionyeshwado kuwa ni kwei ni phome yangu yetikayo kwaajii yenu. ");
INSERT INTO bou_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Akini, kauwani! Yuda Isikalioti endaye anihituke yu hamwe nami hanu he khande. ");
INSERT INTO bou_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwei Mwana wa Mntu aita kukomwa inga yekupangwavyo, akini mmbwii yakwe mntu yuda amhitukae.” ");
INSERT INTO bou_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aho wakavoka kuuzana wenye kwa wenye ni ndai gati yao endaye agosoe mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kukalawiiya mahigano gati ya awo wagiiwa kuusu ni ndai gati yao amamakhanywae kuwa mkuu kusima watuhu. ");
INSERT INTO bou_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu akawamba, “Maseuta wa si ntuhu wawagookea wantu wesaokuwa Wayahudi kwa nguvu, akini kisingi ichoicho wetanga wambuya wa wantu. ");
INSERT INTO bou_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Akini isekuwa ivyo gati yenu, naye yuda mkuu gati yenu nlazima awe mdodo wa wose, na ekuwaye muongoezi nlazima awe inga mndima awagosoaye watuhu. ");
INSERT INTO bou_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwa viya, ni ndai mkuu gati ya yuda ekaaye he meza kuda khande, ama yuda aetae khande? Inga miye neivyo hanu ni mndima gatigati yenu. ");
INSERT INTO bou_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nywinywi nee mwekusigaao nami kisingi chose cha kugeezwa kwangu, ");
INSERT INTO bou_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","na inga viya Tate yangu ekunekhavyo Useuta, ivyoivyo nami nawekha nywinywi Useuta. ");
INSERT INTO bou_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kusudi mdahe kuda na kudomea hamwe nami mwe Useuta wangu na kwekaa he vigoda vya Useuta na kuwaamuia mbai kumi dimwe na waidi ya wantu wa Isilaeli. ");
INSERT INTO bou_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Tegeeza, ibiisi kamwomba Muungu uhusa adahe kuwabahuwa inga mntu mheta ngano. ");
INSERT INTO bou_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Akini mimi nakuombeza wee Simoni ili uzumizi wako usekuhungua. Nawe wendaho uniuwiye, wagee moyo wanduguzo.” ");
INSERT INTO bou_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naye Petulo akamtambaisa, “Zumbe, miye ntayali kuita hamwe nawe mwe kifungo, na hata kuuya na nyuma hamwe nawe.” ");
INSERT INTO bou_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu akamtambaisa, “Nakwamba wee Petulo, kabla zogoo khadizati kukema ivyeeo wenda uniemee maa ntatu.” ");
INSERT INTO bou_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Naho Yesu akawauza wahina wakwe, “Kisingi nekuwaagiaho kwesaho kifuko cha hea wala jumu wala sabana, ne mhungukiwa na chochose?” Wakatambaisa, “Khivyo.” ");
INSERT INTO bou_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naye Yesu akawamba, “Akini isasa, yuda mwe kuwa na kifuko cha hea audoe, na mwe kuwa na jumu naye adidoe. Na yoyose mwesekuwa na paange, atage gwanda dakwe ague dimwe. ");
INSERT INTO bou_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwaviya iyandikwa mwe Maandiko ya Muungu, ‘Kataaziwa hamwe na mabagaa,’ mbui izi ziandikwa kwaajii yangu nawamba nlazima mbui izi zigosoke.” ");
INSERT INTO bou_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naho wakamba, “Zumbe, kauwa, hanu kuna mapaange maidi.” Naye akamba, “Eka!” ");
INSERT INTO bou_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu akalawa, na inga yekuwavyo mazweeya yakwe, akaita he muima wa Mizaituni, wahina wakwe wakambasa. ");
INSERT INTO bou_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ekubuwaho uko akawamba, “Vikani, msekweza kwengia mwe mageezo.” ");
INSERT INTO bou_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naho akawabada, akaita uhae wa mntu kudaha kutambika iwe, akakinta mavindi, akavika kwa Muungu ");
INSERT INTO bou_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tate, inga ikadahika uuse kwangu kikombe iki cha usumiizi, hata ivyo ukundavyo wee na viwe, akini khio nikundavyo mie.” ");
INSERT INTO bou_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aho mndima wa uko uwanga kwa Muungu akamlawiiya kumwekha udaho. ");
INSERT INTO bou_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akawa mwe usungu mkuu, akavika, na kizuguto kikamlawa inga madodwe ya mphome, na kujuuzika kubua asi. ");
INSERT INTO bou_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ekubindaho kuvika, akawauiya wahina wakwe, akawabwiiya wagona, ne awamba kwa usungu, ");
INSERT INTO bou_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akawamba “Kwa mbwai mwagona? Enukani mvike, msekweza kwengia mwe mageezo.” ");
INSERT INTO bou_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ekuwaho atamwiiya, zumwezumwe da wantu dikeza diongoewa na Yuda, yumwe wa wada wahina kumi dimwe na waidi. Yuda akaita kumuugusa Yesu kwa kumuumbatia kwa ukundiso? ");
INSERT INTO bou_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Akini Yesu akamwamba, “Yuda! Wamhituka Mwana wa Mntu kwa kumuumbatia?” ");
INSERT INTO bou_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wada wahina wakwe wekuonaho ayo wakamba, “Zumbe, tiwasengesenge na mapaange yetu?” ");
INSERT INTO bou_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na yumwe wada wahina akamsenga paange mndima wa mviki mkuu, gutwi dakwe da kuume. ");
INSERT INTO bou_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aho, Yesu akamba, “Eka!” Akadidonta diya gutwi da yuda mntu uyo, akamhonya. ");
INSERT INTO bou_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Naho Yesu akamwamba waviki wakuu, na wakuu wa wagoja wa Nyumba ya Muungu na wagookezi watuhu wa Isilaeli hamwe na wadaa wekwezao kumgwiiya, “Mweza na mapaange na malungu kunigwiiya inga miye ni mbavi. ");
INSERT INTO bou_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nekuwaho hamwe nanywi kia misi he Nyumba ya Muungu khamwekugeeza kunigwiiya. Akini, unu nee kisingi chenu, ndicho kisingi cha ugookezi wa kiza.” ");
INSERT INTO bou_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Naho wakamgwiiya Yesu, wakamdoa na kuita naye he nyumba ya mviki mkuu. Petulo ne kawa ambasa nyuma kwa hae. ");
INSERT INTO bou_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wantu wada wekubuwaho kwe nyumba ya mviki mkuu wakagimba moto gatigati buha, petulo akasogea akekaa hamwe nao. ");
INSERT INTO bou_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mndima yumwe wa kivyee ekumuonaho Petulo kekaa hehi na moto, akamfuiya meso, akamba. “Mntu uyu nee kawa hamwe na Yesu.” ");
INSERT INTO bou_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Akini Petulo akaemea akamba, “Wee! Khimmanya.” ");
INSERT INTO bou_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wekwembokaho mda mcheche, mntu mtuhu akamwona Petulo, akamba, “Wee ni yumwe yao.” Akini Petulo akamtambaisa, “Wee mntu, mie khie.” ");
INSERT INTO bou_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yekwembokaho saa dimwe, mntu mtuhu akagombeka vituhu, “Kwei uyu ne kawa hamwe naye Yesu, kwaviya kalawa Galilaya.” ");
INSERT INTO bou_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Akini Petulo akamba, “Zumbe wee, khimanya hata ugombekacho.” Na ahoaho, ekuwaho agombeka, zogoo dikakema. ");
INSERT INTO bou_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zumbe akahituka na kumkauwa Petulo naye Petulo ne akumbuka yada ekwegombekwayo ni Zumbe, “Ivyee zogoo khadizati kukema, wenda uniemee maa ntatu.” ");
INSERT INTO bou_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aho Petulo akalawa chongoi, akavoka kuiya muno. ");
INSERT INTO bou_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wada wantu wekuwaho wamuinda Yesu, wakavoka kumbea na kumtoa, ");
INSERT INTO bou_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","wakamfunga buye hemeso, wakawa wamuuza, “Lavya uwoni! Tigombeke nndai ekukutoaye.” ");
INSERT INTO bou_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wakagombeka mbui nyingi za kumdumuwa. ");
INSERT INTO bou_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kwekuchaho, chekao cha wadaa wa wagookezi wa wantu wa Isilaeli kikagosoka, waviki wakuu na wahinyi wa miagiiyo newabua. Yesu akaetigwa hemeso ya mkonga. ");
INSERT INTO bou_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Naho wakamwamba, “Tigombeke! Wee nee Klistu?” Akini Yesu akawamba, “Hata inga nikawagombeka, khamna mnizumiie, ");
INSERT INTO bou_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na hata inga nikiwauzani mbui, khamna mnitambaise. ");
INSERT INTO bou_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Akini kuvokea isasa, Mwana wa Mntu endaekae phande ya kuume ya Muungu mwenye udaho.” ");
INSERT INTO bou_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aho wose wakamuuza, “Wenda ugombeke wee ni Mwana wa Muungu?” Naye akamba, “Nywinywi mwagombeka kwaviya mie ndie.” ");
INSERT INTO bou_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naho wakamba, “Ivi, takunda uvuhuzi mtuhu? Swiswi wose wenye timtegeeza ekugombekacho.” ");
INSERT INTO bou_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Naho wantu wose wakagooka, wakamwegaa Yesu hemeso ya Pilato. ");
INSERT INTO bou_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wakavoka kumuhaiya masa wakagombeka, “Timbwiiya akitiiya wantu na kuwaemeza wasekuiha kodi kwa mkuu wa kilumi na kwetanga ati yee ni Klistu, Seuta.” ");
INSERT INTO bou_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato akamuuza Yesu, “Wee nee Seuta wa Wayahudi?” Yesu akamtambaisa, “Wee wagombeka.” ");
INSERT INTO bou_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato akawamba waviki wakuu na zumwezumwe da wantu, “Nchekuona masa yoyose kwa mntu huyu.” ");
INSERT INTO bou_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Akini wowo wakahembeeza na kugombeka, “Awachonchea wantu kwa mahinyo yakwe mwe si yose ya Uyahudi, kavoka Galilaya na isasa yu hanu.” ");
INSERT INTO bou_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato ekutegeezayo ayo, akauza, “Ivi mntu huyu ni mwenyezi wa Galilaya?” ");
INSERT INTO bou_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ekumanyaho kuwa Yesu alawa he hantu ha ugookezi wa Helode, akamwegaa kwa Helode, kisingi icho neekawa Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode kawa na kinyemi muno ekumuonaho Yesu. Kwaviya kabinda kae kutegeeza mbui zakwe, na ivyo nekawa akauwiya kwa kisingi kilehacho kumuona kwa meso yakwe mwenye. Naho akakunda kuona ntangio zekugosolwazo ni Yesu, ");
INSERT INTO bou_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ivyo Helode akamuuza Yesu mbui nyingi, akini Yesu khekumtambaisa. ");
INSERT INTO bou_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Waviki wakuu na wahinyi wa miko wakalawiiya hemeso, wakamlavyia masa kwa ukai muno. ");
INSERT INTO bou_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Naho Helode hamwe na asikai wakwe, wakambea Yesu na kumgosweeya mahoka, newamvika gwanda da kiseuta, wakamvuza kwa Pilato. ");
INSERT INTO bou_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kisingi icho Helode na Pilato, nee ni wambuya akini aho kae nee ni wamasa. ");
INSERT INTO bou_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Naho, Pilato akawetanga hamwe waviki wakuu, wakuu na wantu, ");
INSERT INTO bou_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akawamba, “Mmweeta mntu huyu kwangu mkagombeka kuwa ne kawa awasongeeza wantu waemee ugookezi. Isasa tegeezani! Bada ya kumuuza mbui iyo hemeso yenu, nchekupata dodose da ufyaimi kuusu masa mwekuyaetayo hangu. ");
INSERT INTO bou_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala khio miye ikedu, iya hata Helode khekuona mbui ya ufyaimi yoyose, ivyo akamvuza vituhu kwetu. Mntu huyu khekugose mbui yoyose ya ufyaimi ambayo dendado dimtende akomwe. ");
INSERT INTO bou_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ivyo, nendaniwambe atoigwe makoto, mkabinda nimuwekee.” ");
INSERT INTO bou_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kia sikukhuu ya Pasaka Pilato nee akundigwa kuwavuguiya wantu mfungwa yumwe. ");
INSERT INTO bou_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Akini zumwezumwe dose dikatoa vuzo wakamba, “Mkome uyo, utivuguiye Balaba!” ");
INSERT INTO bou_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba nee kagewa mwe kifungo kwaajii ya kugosoa khumbizi mwe mzi na kwaajii ya kukoma. ");
INSERT INTO bou_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato nee kakunda kumuekea Yesu, Ivyo akamba vituhu, na zumwezumwe da wantu. ");
INSERT INTO bou_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Akini wowo wakatoa vuzo, “Mgong'ondee he mhamba! Mgong'ondee he mhamba!” ");
INSERT INTO bou_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato akawamba maa ya ntatu, “Kagosoa masa yani yakumtenda akomwe? Khiona ufyaimi wowose kwakwe akundigwao akomwe, kwa iyo nenda nimbade mumtoe makoto, mkabinda mwamuekea.” ");
INSERT INTO bou_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Akini wowo wakatendesa kutoa vuzo kwa mgutio mkuu, kuwa Yesu nlazima agong'ondewe he mhamba. Kisiikizi, wakavota. ");
INSERT INTO bou_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Naho, Pilato akaamua kiya wantu wekukundacho. ");
INSERT INTO bou_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akamvuguiya yuda mntu wekumkundaye kulawa mwe kifungo, ambaye nee kagewa mwe kifungo kwaajii ya kuemea ugookezi wa seekai ya kilumi, na akamwekhiiza Yesu kwao, wamgoswee viya wekukundavyo. ");
INSERT INTO bou_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wekuwaho wamwegaa, nee wakintana na mntu yumwe etagwaye Simoni wa Kulene, ekuwaye alawa chongoi ya mzi. Naho wakamgwiiya, wakamtwika uda mhamba audoe nyuma ya Yesu. ");
INSERT INTO bou_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zumwezumwe kuu da wantu wakamtongea, gati yao awa neekuwa na wavyee wekuwao wakamwiiya na kutoa mbwaimbo. ");
INSERT INTO bou_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu akawahitukia, akamba, “Nywie wavyee wa Yelusalemu! Msekuniiya mie, akini iyani kwaajii yenu wenye na kwaajii ya wana wenu.” ");
INSERT INTO bou_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwaviya, kwei misi zendazeze ambaho wenda wagombeke, “Wajaiwa wavyee wesaho kuwa na wana na wesao kuvyaa na kuokhesa wana!” ");
INSERT INTO bou_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kisingi icho, ndiho wantu wenda wavoke kugombeka miima mikuu, “Tiguieni! Na viima vidodo, ‘Tigubikeni!’ ” ");
INSERT INTO bou_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwaviya wantu waugosweeya mti muisi namna inu, indaiwe viivihi kwa mti wekunyaao? ");
INSERT INTO bou_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Masikai wakawadoa wantu watuhu waidi mabagaa, wakomwe hamwe naye. ");
INSERT INTO bou_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wekubuwaho hantu hetwangwao, “Fufu da Mtwi,” naho wakamgong'ondea Yesu he mhamba. Wada mabagaa waidi wakagong'endewa kia yumwe he mhamba wakwe, yumwe phande ya kuume na mtuhu phande ya kumoso. ");
INSERT INTO bou_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu akamba, “Tate, waekee kwa viya khawamanya wagosoado.” Naho wakapangana magwanda yakwe kwa kuyatoeya kula. ");
INSERT INTO bou_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wantu ne wawa wagooka hada wakakauwa. Nawo waongoezi wa Kiyahudi wakambeya na kumsizigia wakagombeka, “Kawaohowa watuhu, isasa na eohoe mwenye, inga yee ne Klistu, mwekusagulwa ni Muungu!” ");
INSERT INTO bou_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asikai nao nee wambea, wakamtimia wakamwekha divai yekusasayo ");
INSERT INTO bou_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","naho wakamba, “Inga kwei wee nee Seuta wa Wayahudi eohoe mwenye.” ");
INSERT INTO bou_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nee waika kibao chekundikwacho, “Uyu nee Seuta wa Wayahudi.” ");
INSERT INTO bou_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumwe wa wada mabagaa wekugong'ondwae he mhamba, akamdumuwa akamba, “Ati wee nee Klistu? Eohoe mwenye, utuohoe na swiswi.” ");
INSERT INTO bou_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Akini yuda bagaa mtuhu akamwakia mweziwe akagombeka, “Wee khumuogoha Muungu? Wee kwekhigwa sugusa iyoiyo? ");
INSERT INTO bou_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wee na miye niamuiwa kwa haki, kwaviya haya ni maiho ya yada tekugosoayo. Akini mntu uyu khekugosoa dodose da ufyaimu.” ");
INSERT INTO bou_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naho akagombeka, “Ee Yesu! Unikumbuke kisingi wendaho wengie mwe Useuta wako.” ");
INSERT INTO bou_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu akamtambaisa, “Nakwamba kwa kwei, ivyeoo wendauwe hamwe hantu ha Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nee yapata saa mtandatu wa musi, zua dikabada kumwiika, kiza kikagubika si wose yose hadi saa kenda, ");
INSERT INTO bou_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na pazia dekuwado dikepanga sehemu mbii he Nyumba ya Muungu dikatatuka kuvoka uwanga hadi asi. ");
INSERT INTO bou_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu akaiya kwa mgutio mkuu, “Tate, he mikono yako naika muye wangu.” Ekubindaho kutamwiiya ayo, akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aho, yuda mkuu wa maasikai ekuonaho yekulawiiayo akamtogoa Muungu akamba, “Kwei uyu ne kawa mntu yedi.” ");
INSERT INTO bou_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wantu wada wose wekuitaho kwaajii ya mbui iyo, wekuonaho ayo yekulawiiayo wakauya mwe nyumba zao waketoa vifua kwa usungu. ");
INSERT INTO bou_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wantu wose wekummnyao vitana hamwe na wada wavyee wekutongeana naye kulawa Galilaya, ne wakagooka kwa hae kukauwa mbui iyo. ");
INSERT INTO bou_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Naho kuwa na mntu yumwe zina dakwe Yusufu, mwenyezi wa mzi umwe wa Wayahudi wetagwao Alimataya. Nee kawa mntu yedi atunywae. ");
INSERT INTO bou_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nee kawa akakauwiiya kweza kwa Useuta wa Muungu. Etiho nekawa mwenyezi wa Alimataya, yumwe wa wagookezi wakuu wa mkonga wa Wayahudi, nee khayekumtamia ida mbui yao ya kumkoma Yesu. ");
INSERT INTO bou_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naho yee Yusufu akaita kwa Pilato akaombeza ekhigwe mwii wa Yesu. ");
INSERT INTO bou_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nee auseeza mwii uwo kulawa he mhamba akauzengeteza sanda ntana, akauwika mwe mbiya dekuwado disongolwa mwe iwe, ambado khadizati kugewa mntu yoyose. ");
INSERT INTO bou_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Msi uwo nee maandaio ya Msi wa Kuhumuiza nee iwa yavoka. ");
INSERT INTO bou_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wada wavyee wekutongeana na Yesu kulawa Galilaya wakambasa Yusufu wakoona diya mbiya na mwii wakwe Yesu wekuikwavyo. ");
INSERT INTO bou_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nee wauya kaya, wakayagosoa manukato na mavuta matana ya malashi kwaajii ya kuusisa mwii wa Yesu. Msi wa Kuhumuiza wakahumuiza inga miko ya Musa yekugombekavyo. ");
INSERT INTO bou_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Msi wa bosi wa juma, keo da mtungaihu, wada wavyee nee waita kwe mbiya wakayadoa yada manukato wekuyagosoayo. ");
INSERT INTO bou_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wakabwiiya diya iwe dekuwado dikubika mbiya diusigwa hae na mbia. ");
INSERT INTO bou_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wekweingiaho mda ndani, khawokuona mwii wa Zumbe Yesu. ");
INSERT INTO bou_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wekuwaho wahondomaa kuusu ida mbui iyo, ahoaho wantu waidi wekuvaao magwanda yang'aayo pee, wakagooka hehi nao. ");
INSERT INTO bou_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Awo wavyee wakengiwa ni matumatu, wakenama asi. Naho wada wantu wakawamba, “Kwa mbwai mwamuondeza ekuwaye mgima gatigati ya wekuyao na nyuma? ");
INSERT INTO bou_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Khayuho hanu, kayuyuka. Kumbukani ekuwagombekavyo ekuwaho kuda Galilaya, ");
INSERT INTO bou_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Nlazima Mwana wa Mntu alavigwe kwa wantu wenao mavigaviga, nao wenda wamgong'onde he mhamba na msi wa ntatu enda ayuyuke.’ ” ");
INSERT INTO bou_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aho awo wavyee nee wakumbuka mbui izo wekugombekwazo ni Yesu, ");
INSERT INTO bou_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wakauya kulawa mwe mbiya, wakawamba wada wagiiwa kumi dimwe na mwenga na wandima watuhu mbui izo zose. ");
INSERT INTO bou_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wavyee wekutamwiao mbui izo kwa waagiiwa ne ni Malia Magidalene, Yoana na Malia mami yakwe da Yakobo, hamwe na wavyee watuhu wekutongeana nao. ");
INSERT INTO bou_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Akini wada waagiiwa wa Yesu wekutegeezaho mbui izo khawokuzumiiya. ");
INSERT INTO bou_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petulo akalawa, akaita kinyio hadi mwe mbiya. Ekusungiaho mda ndani, akoona ida sanda du. Akauya kaya uku akawa kahondomaa kuusu ayo yekulawiiayo. ");
INSERT INTO bou_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Msi wouwo, wantu waidi gati ya wahina wakwe Yesu newawa wakaita mwe mzi umwe wetangwao Emau, uhae wakwe nee ntambo ya masaa maidi kulawa Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nee wakagombeka kuusu ayo yose yekulawiiayo. ");
INSERT INTO bou_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wekuwaho siai wakatamwiiya, Yesu mwenye akalawiiya hehi yao, na akaita hamwe nawo. ");
INSERT INTO bou_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wamuona kwa meso yao, akini khawokummanya. ");
INSERT INTO bou_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu Akawauza, “Mwagombeka mbwai uku mkenda?” Wakagooka uku wakawa na usungu. ");
INSERT INTO bou_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumwe etangwaye Kileopa, akamtambaisa, “Ivi wee nee mgeni ikedu aha Yelusalemu wesae kumanya mbui zose zekulawiiazo misi micheche yekwembokayo?” ");
INSERT INTO bou_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naye akawatambaisa, “Mmbui zani?” Wowo wakamtambaisa. “Mbui zekumpatazo Yesu wa Nazaleti. Yee ne kawa muoni wa Muungu mwenye udaho wa kuhonya wantu na kuhinya hemeso ya Muungu na hemeso ya wantu wose. ");
INSERT INTO bou_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Waviki wakuu na wagookezi wetu newamlavya aamuiwe ufe, na wakamgong'ondea he mhamba. ");
INSERT INTO bou_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akini swie ne tikauwiya kuwa yee neendae awaohowe wantu wa Isilaeli. Isasa ivyeo ni msi wa ntatu kuvokea mbui izo zekugosokaho. ");
INSERT INTO bou_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naho wavyee watuhu wa kwetu nee wativitua. Wowo nee waita mwe mbiya keo da mtungaihu, ");
INSERT INTO bou_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nao khawokumbwiiya mwii wakwe. Wakauya wakamba kuwa walawiiwa na wandima wa uko uwanga kwa Muungu wekuwaambiao kuwa Yesu ni mgima. ");
INSERT INTO bou_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Watuhu wetu nee waita mwe mbiya wakaona yada yekugombekwayo na wada wavyee, iya yee khawokumuona.” ");
INSERT INTO bou_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu akawamba, “Nywie mahezi kiasi icho na mioyo yenu itoga ivyo kuzumiiya yose yekutamwiiwayo na waoni wa Muungu! ");
INSERT INTO bou_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ivi khaikudaika Klistu kusumiizwa inga viya, na engie mwe Ukuu wakwe?” ");
INSERT INTO bou_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naho yesu akawamba mbui zose zekuandikwazo kwaajii yakwe mwenye mwe Maandiko ya Muungu kuvokea kitabu cha Musa hadi mwe Magondo ya waoni wose wa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wekuwaho hehi na uda mzi wekuwao wakauitia, Yesu akagosoa inga aendeea na ntambo. ");
INSERT INTO bou_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Akini wowo wakamhembeza wakagombeka, “Ekaa hamwe naswi, kwaviya zua diswa, na kio kihehi.” Naho akengia mwe mzi, akekaa hamwe nawo. ");
INSERT INTO bou_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ekwekaaho kuda khande hamwe nao, akadoa bumunda, akamtogoa Muungu, akabendua akawekha. ");
INSERT INTO bou_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahoaho meso yao yakagumbulwa wakammanya kuwa yee ni Yesu, akini yee akaga gatigati yao. ");
INSERT INTO bou_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naho, wakagombeka, “Mioyo yetu khayokuwa yaka moto kisingi ekuwaho akatamwiiya naswi siai na kugombeka Maandiko ya Muungu.” ");
INSERT INTO bou_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wakahauka kisingi kiyakiya, wakauya Yelusalemu, nee wawabwiiya wada wagiiwa kumi dimwe na mwenga na wada watuhu wekuwaho hamwe nao wakintana ");
INSERT INTO bou_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wakawamba wahina wada waidi wakagombeka, “Kwei Zumbe kayuyuka kamlawiiya Simoni.” ");
INSERT INTO bou_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Naho, awo wahina waidi wakawamanyisa yada yekuwapatayo wekuwaho siai na wekummanyavyo ekubenduaho bumunda. ");
INSERT INTO bou_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wekuwaho wakawamba ayo, Yesu mwenye akagooka gati yao, akawamba, “Uivanisa uwe naywi.” ");
INSERT INTO bou_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wakahondomaa na kutozwa ni matumatu wakamanya waona mzimu. ");
INSERT INTO bou_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Akini yee akawamba, “Kwambwai mwaogoha mwe mioyo yenu. Kwambwai khamnizumiiya? ");
INSERT INTO bou_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kauweni mikono yangu na miundi yangu, ni mii mwenye. Nitozani mwe mwii wangu wose, kwaviya mzimu khauna mwii na mavuha inga mnikauavyo.” ");
INSERT INTO bou_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ekubindaho kugombeka ayo, akawaonesha mikono na miundi yakwe. ");
INSERT INTO bou_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wakavotwa kwezumiiya kwaajii ya nyemi muno uku wahondomaa mpaka ikawatenda kumamakhanya inga khio kwei, uku wahondomaa, akawauza, “Mna khande yoyose hanu?” ");
INSERT INTO bou_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wakamwekha ntii ya samaki yekubanikwayo. ");
INSERT INTO bou_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nee akakidoa, akada, hemeso yao. ");
INSERT INTO bou_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ekubindaho akawamba, “Inu nee mana ya mbui nekugombekayo nekuwaho hamwe nanywi, kuwa mbui zose zekuandikwazo kuusu mie mwe miagiiyo ya Musa na mwe Maandiko ya Muungu ya waoni na mwe kitabu cha zabui yaiganizwe.” ");
INSERT INTO bou_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naho akavugua akii zao wadahe kumanya Maandiko ya Muungu. ");
INSERT INTO bou_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akawamba, “Nee ivyo yekugondwavyo kuwa Klistu enda asumiizwe na msi wa ntatu enda ayuyuke kulawa mwe wekufao, ");
INSERT INTO bou_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","naho kwa udaho wa Yesu, wantu wa si zose kuvokea Yelusalemu wenda wabiikiwe kuwa wahituke na kuekewa mavigaviga. ");
INSERT INTO bou_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nywie wose nee wavuhuzi wa mbui izi. ");
INSERT INTO bou_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mie nenda nimwagiie kwenu Muye wa Muungu ambaye Tate nee kaika kiaga kuwekha, akini nlazima mgoje mwe mzi hadi udaho kulawa uwanga kwa Muungu wendaho umyezee.” ");
INSERT INTO bou_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Naho akawaongoeya wahina wakwe kuita chongoi ya mzi hadi Besaniya, uko akenua mikono yakwe uwanga, na kuwajaiya. ");
INSERT INTO bou_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ekuwaho awajaiya, akawabada, akadoigwa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wowo wakakinta mavindi na kumvikia, naho wakauya Yelusalemu wakawa na kinyemi kikuu. ");
INSERT INTO bou_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wakekaa kisingi chose he Nyumba ya Muungu na wakamtogoa Muungu.");
INSERT INTO bou_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho bosi inusi khaizati kuubwa, nee kuwa na Mbui, naye Mbui nee akawa kwa Muungu, naye Mbui ni Muungu. ");
INSERT INTO bou_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kuvokea aho bosi uyo Mbui nee kawa hamwe na Muungu. ");
INSERT INTO bou_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kwembokea yee vintu vyose viumbwa, khahana ata kintu kimwe chekugosokacho kwesiho yee. ");
INSERT INTO bou_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na Mbui nekawa vokeo da ugima na ugima unu ueta ung'azi kwa wantu. ");
INSERT INTO bou_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ung'azi uwo waangaza mwe kiza, naho kiza khachekudaha kuuvota. ");
INSERT INTO bou_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Muungu akamwaagiiya mntu yumwe etangwaye Yohana. ");
INSERT INTO bou_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Uyo keza kuwavuhuzia wantu kuusu uwo ung'azi kuwa kia mtu adahe kutegeeza mbui iyo na kuzumiia. ");
INSERT INTO bou_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana khekuwa uwo ung'azi, iya keza kuwavuhuzia wantu kuusu uwo ung'azi. ");
INSERT INTO bou_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Unu nee ung'azi wa kwei, ung'azi wezao mwe inusi na kuwaangaza wantu wose. ");
INSERT INTO bou_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Naho iyo Mbui ekuwaho mwe inusi, kwembokea yee inusi igosolwa, akini wantu wa inusi khawekummanya. ");
INSERT INTO bou_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yee keza he si yakwe mwenye, akini wantu wekuawo wa kwakwe khawekumhokea. ");
INSERT INTO bou_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Akini wada wekumhokeao, na kumzumiia, akawekha udaho wa kuwa wana wa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Awa nee wekuvyaigwao khio kwa phome nawala kwa mwii hambu akundavyo mntu iya kwaakundavyo Muungu. ");
INSERT INTO bou_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naye uyo Mbui kawa mntu akekaa hamwe na swie, swie tiona ukuu wakwe, ukuu ekuuhokeao inga mwana wa ikedu, ekulawaye kwa Tate kamema wedi na ukwei. ");
INSERT INTO bou_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana kawavuhuzia wantu mbui zakwe, akagombeka kwa mgutio, “Uyu nee yuda nekumtamwiiaye mbui zakwe nikigombeka, ‘Yee ezae hemgongo wangu ni mkuu kusima mie, kwaviya kawa aho kisingi khizati kuvyaigwa.’ ” ");
INSERT INTO bou_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kulawana na wingi wa wedi wakwe swie wose, tihokea majaiwa uwanga ya majaiwa. ");
INSERT INTO bou_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Muungu katekha miagiiyo kwembokea Musa, akini wedi na kwei vitezea kwembokea kwa Yesu Klistu. ");
INSERT INTO bou_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Khahana mntu mwekumuona Muungu katu iya Mwana ikedu mwekuigana na Muungu, yee ekuwae hehi na Tate, nee mwe kutigubuiya mbui za Muungu. ");
INSERT INTO bou_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ivi nee ekuvuhuziavyo Yohana kisingi waongoezi wa Kiyahudi kuda Yelusalemu wekuwagiiyaho waviki, na Walawi, wamuuze Yohana Wee u ndai? ");
INSERT INTO bou_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana khekuemea kutambaisa mbui iyo, akini akatamwiiya pwii akamba, “Miye khio Klistu mwekusagulwaye ni Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wakamuuza, “Wee u ndai? Wee ni Eliya?” Yee akawatambaisa, “Aaha miye khiye.” Wakamuuza vituhu, “Wee ni yuda muoni?” Yohana akawatambaisa, aaha miye khiye. ");
INSERT INTO bou_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nawo wakamwamba, asa wee u ndai? Takundigwa tivuze ntambaisi kwa wada wekutiagiiyao, isasa tambie wee u ndai? ");
INSERT INTO bou_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana akawatambaisa miye ni yuda ambae Muoni Isaya kagombeka mbui zakwe. “Mgutio wa mntu wetanga mwenyika ‘Mgosoeyani Zumbe sia yakwe Nyooshani myemboko yakwe.’ ” ");
INSERT INTO bou_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Awo wantu nee waagiiwa ni Mafalisayo, ");
INSERT INTO bou_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","naho wakamuuza Yohana, “Ati wee khiwe Klistu, wala khiyo Eliya, wala khiyo yumwe wa muoni, kwa mbwai wabatiiza?” ");
INSERT INTO bou_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana akawatambaisa, “Miye nabatiiza kwa mazi, akini gatigati yenu hana yumwe mwesae kummanya. ");
INSERT INTO bou_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Miye khiongoa iya endaye eze miye khifaa katu kumchopoa sigi za sabana yakwe.” ");
INSERT INTO bou_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vintu ivi vyose vigosoka uko Besaniya he phande za awiyo da zua he zigizigi da mazi ya Yolodani aho ekuwaho Yohana nee abatiizaho. ");
INSERT INTO bou_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kioi yakwe Yohana kamuona Yesu akimwezea akagombeka, “Kauwani, uyu nee mwanangoto wa Muungu, adoaye mavigaviga ya wantu wa mweinusi. ");
INSERT INTO bou_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uyu ni yuda nekumtamwiiaye nekugombekaho, ‘Kuna mntu mwezae he mgongo wangu, akini ni mkuu kusima miye kwaviya kawa aho kisingi miye khizati kuvyaigwa.’ ");
INSERT INTO bou_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miye ncheekummanya eivyo, akini ncheza kubatiiza kwa mazi ili wantu wa Isilaeli wadahe kummanya.” ");
INSERT INTO bou_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Naho Yohana akawekha uvuhuzi na kugombeka, “Kimwona Muye ukaseeya inga sua kulawa uwanga kwa Muungu na kwekaa uwanga yakwe.” ");
INSERT INTO bou_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miye ncheekummanya kuwa ni yee, akini Muungu ekuniagiiyae kubatiiza wantu kwa mazi nekanamba, “Mntu yuda wendaeumwone Muye wa Muungu akaseeya kulawa uwanga kwa Muungu na kwekaa uwanga yakwe uyo nee endaeabatize kwa Muye wangu miye Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana akaendeea kugombeka, “Miye khivuhuzia na nawamba kwei uyu ni Mwana wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kioi dakwe, Yohana kagooka hada vituhu hamwe na wahina wakwe waidi. ");
INSERT INTO bou_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ekumuonaho Yesu emboka akamba, “Kauwani! Uyu ni Mwanangoto wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wada wahina waidi wekutegezaho akigombeka ayo wakambasa Yesu. ");
INSERT INTO bou_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu ekuhitukaho, na kuwaona wada wahina wambasa, akawauza, “Mwaondeza mbwai?” Wakamtambaisa, “Labbi” mana yakwe Mhinyi, wekaa kuhi. ");
INSERT INTO bou_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nee iwa inga saa kumi guoni Yesu akawamba “Sooni mkauwe.” Aho wahina wakambasa, wakoona hantu ekuwaho akekaa wakasinda naye msi uwo wose. ");
INSERT INTO bou_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yumwe yao nee kawa Andulea nduguye Simoni Petulo, nee kawa wao wa wada waidi wekumtegeezao Yohana akagombeka ivyo na wakamtongea Yesu. ");
INSERT INTO bou_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ahoaho Andulea akaita kumwamba nduguye Simoni, “Timuona Masiya mana yakwe Yesu Klistu.” ");
INSERT INTO bou_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naye akamwegaa Simoni kwa Yesu. Yesu akamkauwa Simoni akamwamba, “Wee zina dako ni Simoni mwana wa Yohana. Isasa wendawetangwe Kefa” Kigiiki ni Petulo mana yakwe “Iwe.” ");
INSERT INTO bou_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Msi wekutongeao Yesu akaamua kuita si ya Galilaya, akamwona Fiipo na akamwamba “Nitongee.” ");
INSERT INTO bou_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fiipo nee akawa akalawa Betisaida, mzi wekuwao wakekaa Andulea na Petulo. ");
INSERT INTO bou_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Fiipo akambwiiya Nasanaeli akamwamba, Timuona mntu ambae Musa kaandika mbui zakwe mwe kitabu cha miagiiyo, na ambae waoni waandika mbui zakwe. Yee ni Yesu Mwana wa Yusufu kulawa mzi wa Nazaleti. ");
INSERT INTO bou_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nasanaeli akauza, “Yadahika viivihi vihi kintu chedi kilawe mzi wa Nazaleti?” Fiipo akatambaisa, “Soo na ukauwe”. ");
INSERT INTO bou_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu ekumuonaho Nasanaeli amwezeya akamba, “Kauwani uyo ni Muisilaeli wa kwei khana dosali umo mwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasanaeli akamuuza kudaha vivihi kunimanya? Yesu akatambaisa khikuona wekuwaho asi ya mti wetagwaho mtini, kisingi Fiipo khazati kukwetanga. ");
INSERT INTO bou_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nasanaeli akamtambaisa, “Labbi wee nee Mwana wa Muungu, wee nee Seuta wa Isilaeli.” ");
INSERT INTO bou_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu akamwamba, “Kuzumiiya kwa kuwa kikwamba khikuona asi ya mtini? Wendauone mbui khuu kusima izi.” ");
INSERT INTO bou_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu akawamba, “Nawamba ukwei mwendamuone uwanga kwa Muungu kuvuguka na wandima wa uwanga kwa Muungu wakakwea na kuseeya heuwanga ya Mwana wa Mntu.” ");
INSERT INTO bou_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Msi wa ntatu hawa na wiya mwe mzi wa Kana, uko Galilaya, mami yakwe da Yesu naye kawa aho. ");
INSERT INTO bou_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu hamwe na wahina wakwe wagonekwa mwe wiya uwo. ");
INSERT INTO bou_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai yekusiaho, mami yakwe da Yesu akamwamba, “Khawana divai.” ");
INSERT INTO bou_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu akamtambaisa, “Mmaa usekunamba nigosoe chochose, kisingi changu khakizati kubua.” ");
INSERT INTO bou_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mami yakwe da Yesu akawamba wandima, “Dodose endadoawambe gosoani.” ");
INSERT INTO bou_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aho hawa na mabiga mtandatu yekugosolwayo kwa maiwe, kia dimwe didahado kwengia ndoo shano za mazi. Nee yaikwa aho kutongeana na mazweeya ya Wayahudi ya kwezingua. ");
INSERT INTO bou_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu akawamba wada wandima, memeezani ayo mabiga mazi, nao wakayamemeeza adi uwanga. ");
INSERT INTO bou_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Naho akawamba, “Isasa tekani mazi mwe ayo mabiga mmwegaiye Mkuu wa wiya.” Wakadoa yada mazi na kumwegaiya. ");
INSERT INTO bou_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mkuu wa wiya ekusonaho ayo mazi, kumbe nee yahituka kae kutenda divai. Yee khekumanya yekulawiiako, akini wada wandima wekutekao mazi nee wakamanya. Mkuu wa wiya akamwetanga zumbe wa wiya, ");
INSERT INTO bou_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na akamwamba, “Kia mntu avoka kuika divai ntana wantu wakabinda kutosheka nee awekha yesayokuwa ntana muno, akini wee kuiika divai ntana adi isasa!” ");
INSERT INTO bou_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Unu ni utangio wa bosi wa Yesu ekugosoao uko Kana mzi wa Galilaya, na kugubua Ukuu wakwe, na wahina wakwe wakamzumiiya. ");
INSERT INTO bou_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yekwembokaho ayo Yesu na mami yakwe, hamwe na wanduguze, na wahina wakwe wakaseeya mwe mzi wa Kapelinaumu na wakekaa uko misi micheche. ");
INSERT INTO bou_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sikukhuu ya Wayahudi yetangwayo Pasaka yekuwaho hehi, Yesu akaita Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","He ida Nyumba ya Muungu akawabwiiya wantu wataga ng'ombe, na ngoto, na sua na watuhu wekuwao wekaa na kuvunja hea. ");
INSERT INTO bou_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ivyo akagosoa mkoto wa uzigi, na kuwaguusa wanyama chongoi he ida Nyumba ya Muungu. Wanyama wose ngoto, na ng'ombe na kuzigwisa meza za wavunja hea na kuzigwisa hea zao. ");
INSERT INTO bou_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akawamba wada wekuawo wakataga sua, “Usani vintu ivi aha, ekani kugosoa Nyumba ya Tate yangu inga gwiiyo.” ");
INSERT INTO bou_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wahina wakwe wakayakumbuka yada Maandiko yagombekayo “Ukundiso wangu kwa nyumba yako, Ee Muungu yangu yanoka inga moto.” ");
INSERT INTO bou_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Waongoezi wa Kiyahudi wakamuuza, “Utangio wani wendao uugosoe kutionyesha ati una udaho wani wakugosoa ivi?” ");
INSERT INTO bou_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akawamba, “Bomoani inu Nyumba ya Muungu, nami nendanizenge kwa misi mitatu.” ");
INSERT INTO bou_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wada Wayahudi wakamuuza, “Nyumba inu ya Muungu izengwa kwa kisingi cha myaka magana mane na mtandatu, nawe wamba wenda uzenge kwa misi mitatu?” ");
INSERT INTO bou_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Akini, Nyumba ya Muungu ekuayo akatamwiiya Yesu ni mwii wakwe. ");
INSERT INTO bou_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kisingi Yesu ekuyuyukaho, wahina wakwe nee wakumbuka ida Mbui ekutamwiiayo, wakayazumiiya Maandiko ya Muungu, na mbui zose ekugombekazo Yesu. ");
INSERT INTO bou_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Akini Yesu ekuaho mwe mzi wa Yelusalemu kwe sikukhuu ya Pasaka wantu wangi wakazumiiya wekuonaho utangio ekugosoao. ");
INSERT INTO bou_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Akini Yesu khekuwa na uzumizi nao, kwaajii kamanya mbui zekuwazo mwe mioyo yao. ");
INSERT INTO bou_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Khekukunda kuvuhuzia mbui yoyose uwanga ya wantu, kwa viya azimanya mbui zose zeumo ndani ya mioyo yao. ");
INSERT INTO bou_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hawa na muongoezi yumwe wa Kiyahudi zina dakwe Nikodemo, mwekuwa yumwe wamkonga da Mafalisayo. ");
INSERT INTO bou_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kio kimwe Nikodemo akaita kwa Yesu na kumwamba, “Labbi, tamanya ati wee ni mhinyi mwekuagiiwa ni Muungu, khahana mntu mdaha kugosoa ntangio uvigosoavyo kwesahokuwa Muungu yu hamwe nae.” ");
INSERT INTO bou_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu akamtambaisa, “Nakugombeka kwei, khahana mwenda adahe kwengia mwe useuta wa Muungu, akese kuvyaigwa maa ya kaidi.” ");
INSERT INTO bou_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo akamuuza, “Mntu mgima adaha viivihi kuvyaigwa vituhu? Ivi adaha kwengia mwe ifu da mamiakwe na kuvyaigwa maa ya kaidi?” ");
INSERT INTO bou_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu akatambaisa, “Nawamba kwei, khahana mntu endae engie mwe Useuta wa Muungu kwesaho kuvyaigwa kwa mazi na kwa Muye wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mntu avyaigwa kimwii kwa tate na mmaa, akini ugosolwa kuwa Mwana wa Muungu na Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usekuhondomaa, kwaajii kikwamba kuwa yakundigwa uvyaigwe maa ya kaidi. ");
INSERT INTO bou_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Khusi yavuma hohose ikundaho, wategeeza mgutio wakwe, akini khumanya yalawiiya kuhi, na kuhi uitako, nee vyeivyo kwa mntu mwekuvyaigwa kwa Muye wa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo akauza, “Mbui izi zadahika viivihi?” ");
INSERT INTO bou_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akamtambaisa, “Wee ni mhinyi mkuu mwe si ya Isilaeli, yadahika viivihi khuzimanya Mbui izi? ");
INSERT INTO bou_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nakwamba ukwei tatamwiia mbui tizimanyazo na tavuhuzia tekukionacho, akini khahana ata yumwe wenu ambaye azumiiyae kuhokea mahinyo yetu. ");
INSERT INTO bou_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Inga miye khamkunizumiiya niwagombekaho mbui zigosokazo mwe inusi, ivi mwenda mnizumiie nendaho nigombeke mbui za uwanga kwa Muungu? ");
INSERT INTO bou_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Khahana mwekubua uko uwanga kwa Muungu, iya Mwana wa mntu nee mwekuseeyae kulawa uwanga kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Inga viya Musa ekumwenuavyo uwanga nyoka wa shaba he kiwawe, nae Mwana wa Mntu endaenulwe uwanga ivyoivyo. ");
INSERT INTO bou_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ili kiya mntu amzumiiaye endaawe na ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwaviya Muungu kaikundisa inusi ata akamlavya mwanawe wa ikedu, ili kia mntu endae amzumiiye asekwaga, iya awe na ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwaviya Muungu khekumwaagiiya Mwanawe mwe inusi ili awaamuiye wantu, iya wantu waoholwe kwembokea yee. ");
INSERT INTO bou_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wantu wose wamzumiiao Mwana khawana waamuiiwe, akini wose wesao kumzumiia Mwana, waamuiwa kae, kwaajii khawekumzumiiya Mwana wa ikedu wa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na uwamuiyo wenye ni unu, ung'azi weza mwe inusi, akini wantu wakakunda kiza kwesima ung'azi, kwaajii ya ntendwa zao ni za ufyaimi. ");
INSERT INTO bou_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wose wagosoao yesayokutama, waemea ung'azi, naho khawakunda kweza he ung'azi, kwaviya khawakunda ntendwa zao za fyaimi zioneke pwii. ");
INSERT INTO bou_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Akini yoyose mwenye kutoza kwei eza he ung'azi, ili waonyeshe yada wagosoayo kwa kuwa yamtamiza Muungu. ");
INSERT INTO bou_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bada ya aho Yesu na wahina wakwe wakaita mwe si ya Yudea, na kwekaa uko kwa misi micheche na kubatiiza wantu. ");
INSERT INTO bou_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana nae nee akabatiiza huko Ainoni, hehi na mzi wa Salimu kwaviya kuwa na mazi mangi, wantu wakamtimia na kuita kubatizwa. ");
INSERT INTO bou_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aya yalawiiya kisingi Yohana nee khazati kwengizwa mwe kifungo. ");
INSERT INTO bou_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Msi umwe wamwe wa wahina wa Yohana wakavoka kuhigana na Myahudi yumwe kwaajii ya kwezingua inga igombekavyo miko kisingi mntu khazati kuvika. ");
INSERT INTO bou_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Awo wahina wakambasa Yohana na kumwamba, “Labbi wambukhua mntu yuda wekuae naye phande ya awiyo da zua da Yolodani yuda wekutivuhuziae Mbui zakwe? Isasa naye abatiiza na kiya mntu amtongea.” ");
INSERT INTO bou_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana akawatambaisa, “Khahana mntu yoyose adahae kuhokea kintu chochose kwesiho kulawa uwanga uko kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nywie nyose ni wavuhuzi wangu kwakuwa kigombeka, ‘Miye khie Klistu, akini khiagiiwa nimuongwee.’ ");
INSERT INTO bou_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mwai ya kivyee nimai ya mteguzi, akini mbuyaye damteguzi, ambae agooka na kumtegeeza uwa na nyemi muno, ategeezaho mgutio wa mteguzi akamba mbui inu, kwaajii inu nyemi yangu yekuiganiayo. ");
INSERT INTO bou_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yee akundigwa atende mkuu nami nitende mdodo.” ");
INSERT INTO bou_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mwana wa Muungu kulawa uwanga kwa Muungu ni mkuu wa wose, alawaye mwe inusi ni wa inusi, na utamwiiya mbui za mwe inusi. Akini ezaye kulawa uwanga kwa Muungu yu uwanga wa wose. ");
INSERT INTO bou_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yee avuhuzia yada ekuonayo na ekutegeezayo kulawa uwanga uko kwa Muungu, khio wantu wangi wazumiiyao mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Akini yoyose avuhuziae mbui zakwe amanya kuwa agombekayo Muungu ni kwei. ");
INSERT INTO bou_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yoyose mwekuagiiwa ni Muungu agombeka mbui za Muungu kwaviya Muungu amwekha Muye wakwe ili amuongoee kwa kia kintu. ");
INSERT INTO bou_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tate amkundisa Mwanawe na kamwekha vintu vyose ili avigookee. ");
INSERT INTO bou_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yoyose amzumiiaye Mwana ana ugima wa misi yose kwesiho kisiikizi, yoyose mwesaye kumzumiia Mwana khana awe na ugima wa misi yose kwesiho kisiikizi, akini endaekhigwe suuba ni Muungu misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo nee wakategeeza kuwa Yesu abatiiza nakupata wahina wangi kusima Yohana. ");
INSERT INTO bou_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Akini ukwei ni kuwa Yesu khekumbatiza yoyose iya wahina wakwe nee wekuwao wakabatiiza. ");
INSERT INTO bou_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu ekutegeezayo ayo, akalawa Uyahudi, akauya mwe si ya Galilaya. ");
INSERT INTO bou_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na mwe ntambo iyo, imkunda embokee mwe si ya Samalia. ");
INSERT INTO bou_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nee abuwa mwe mzi umwe wa Samalia wetangwao Sikali, hehi ya uda mnda ambaho Yakobo nee kamwekha mwanawe Yusufu. ");
INSERT INTO bou_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hantu hada hawa na kisima cha Yakobo, nae Yesu kwa msokeo wa ntambo, akekaa khandakhanda ya kisima, nee iwa musi saa mtandatu. ");
INSERT INTO bou_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Keza mvyee yumwe kulawa mwe si ya Samalia keza kuteka mazi, Yesu akamwamba, “Nekha mazi nidomee.” ");
INSERT INTO bou_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kisingi icho wahina wakwe nee waita kwe mzi kugua khande. ");
INSERT INTO bou_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Akini yuda mvyee akamwamba, weye u Myahudi na miye Msamalia wadaha viivihi kuniombeza mazi? Kwaviya Wayahudi na Wasamalia khawaugusana na khawagosoa chochose kia hamwe. ");
INSERT INTO bou_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akamtambaisa, “Ati nee ukamanya kiya ambacho Muungu adaha kukwekha na nndai akwambae, nekha mazi nidomee, wee nee ukamuombeza, naye akakwekha mazi ugima.” ");
INSERT INTO bou_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yuda mvyee akamba, “Zumbe wee khuna ugata na kisima ni kileha, ayo mazi ambayo yawekha wantu ugima wenda uyapate hahi?” ");
INSERT INTO bou_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hambu, wee wetenda mkuu kusima tati yetu Yakobo? Yee mwekutekha swie kisima iki, na yee mwenye, wana wakwe, na mantintimo yakwe, nee wadomea mazi ya kisima iki. ");
INSERT INTO bou_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akatambaisa, “Kiya mntu endae adomee mazi aya enda atozwe ni khiu vituhu.” ");
INSERT INTO bou_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Akini mwendae adomee mazi nendayo nimwekhe miye, khana atozwe ni khiu vituhu, mazi nendayo nimwekhe yenda yawe ni soko da mazi ya ugima, na yendayoyamwekhe ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yuda mvyee akamwamba, “Zumbe nekha mazi ayo nisekweza kutozwa ni khiu vituhu, naho nisekweza aha vituhu kuteka mazi.” ");
INSERT INTO bou_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu akamwamba yuda mvyee, hita ukamwetange muumeo, weze naye aha. ");
INSERT INTO bou_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mvyee yuda akamwamba, miye khina mgosi. Yesu akamwamba, “Kugombeka kwei kuwa khuna mgosi. ");
INSERT INTO bou_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwaviya nee kutegulwa na wagosi washano, na uyu wekae naye isasa khio muumeo, aho kugombeka kwei.” ");
INSERT INTO bou_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yuda mvyee akamwamba, “Zumbe naona kuwa wee u muoni.” ");
INSERT INTO bou_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akaendeea kugombeka, “Baba zetu nee wakamvikia Muungu uwanga ya muima unu, akini nywie Wayahudi mwagombeka hantu ha kumvikia Muungu ni uko Yelusalemu.” ");
INSERT INTO bou_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu akamwamba, “Nizumiiya wee mvyee, kisingi cheza khamna mumvikie Tate uwanga mwe muima unu, hambu kuda Yelusalemu.” ");
INSERT INTO bou_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nywie Wasamalia, mwamvikia yuda mwesae kummanya, akini swie Wayahudi tamvikia yuda timmanyae, kwaviya uohozi walawiiya kwa Wayahudi ");
INSERT INTO bou_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kisingi cheza, naho kibua, ambao wantu wakundao kumvikia Muungu mwe ukwei, wendawamvikie Tate inga Muye wakwe endavyo awaonyeshe, kumvika yee eivyo kwei. Tate Muungu awakunda ambao wamvika kwa sia iyo. ");
INSERT INTO bou_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Muungu ni Muye, na wantu wamvikiao wakundigwa wamvikie kwa Muye na kwei. ");
INSERT INTO bou_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uyo mvyee akamwamba, “Namanya eza Masiya yani Klistu, umo akeza enda atigubwiiye kia kintu.” ");
INSERT INTO bou_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu akamwamba, “Miye nitamwiiaye nawe ndie.” ");
INSERT INTO bou_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aho wahina wakwe wakauya, wakamaka koona atamwiiya na mvyee, akini khahana yumwe yao ekumuuzae yuda mvyee, “Waondeza mbwai?” Wala khahana ekumuuzae Yesu, “Kwa mbwai watamwiiya na mvyee?” ");
INSERT INTO bou_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yuda mvyee akabada biga dakwe hada, akaita mwe mzi na kuwamba wantu. ");
INSERT INTO bou_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Sooni mumkauwe mntu mwekunamba mbui zangu zose nigosoazo. Ivi, adahika yee nee Klistu.” ");
INSERT INTO bou_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wantu wakalawa mwe si ya Samalia wakambasa Yesu. ");
INSERT INTO bou_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kisingi icho wahina wakwe wamuombeza Yesu, “Mhinyi, daa khande.” ");
INSERT INTO bou_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Akini Yesu akawamba, “Miye nina khande mwesayo kuimanya nywie.” ");
INSERT INTO bou_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wahina wakwe wakauzana, “Ivi kuna mntu mwekumweetea khande?” ");
INSERT INTO bou_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu akamba, khande yangu ni kugosoa akundavyo yuda mwekuniagiiya na kubindiiza ndima ekunekhayo kuigosoa. ");
INSERT INTO bou_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nywie mwagombeka, “Isigaa miongo minne kisingi cha ubosi kibua.” Akini miye nawamba, kauwani minda, khande zidahaa na zihehi kubondwa. ");
INSERT INTO bou_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mbosi ekhigwa maiho yakwe, na akusanya khande kwaajii ya ugima wa misi yose kwesiho kisiikizi, ivyo mhasi na mbosi, wendawawe na nyemi hamwe. ");
INSERT INTO bou_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Msimo unu ni kwei, “Yumwe ahanda mtuhu abonda.” ");
INSERT INTO bou_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Miye khiwagiiya mkabonde ubosi mwe minda ambayo khamwekuiima, watuhu nee wakagosoa ndima uko, akini nywinywi mwapata myengizo kwembokea ndima yao. ");
INSERT INTO bou_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamalia wangi wa mzi uda wakamzumiiya Yesu kwaajii ya mbui ekugombekazo yuda mvyee kuwa, “Kanivuhuzia mbui zose nekuzigosoazo.” ");
INSERT INTO bou_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wasamalia wakambasa Yesu wakamuombeza ekae nawo, akekaa mwe mzi uwo misi miidi. ");
INSERT INTO bou_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wantu wangi wamzumiiya Yesu kwaajii ya mbui zakwe ");
INSERT INTO bou_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wakamwamba yuda mvyee, “Khatizumiiya du kwaajii ya mbui zako, akini swie wenye timtegeeza na timmanya kuwa uyu nee kwei Mwohozi wa inusi.” ");
INSERT INTO bou_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yekwembokaho misi miidi, Yesu akahauka hada akaita mwe si ya Galilaya. ");
INSERT INTO bou_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwaviya Yesu mwenye kavuhuzia pwii, “Muoni khana atunywe mwe mzi wakwe mwenye.” ");
INSERT INTO bou_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ekubuaho mwe si ya Galilaya, wantu wa Wagalilaya wangi wakamhokea, kwaajii nao nee waita kwe sikukhuu ya Pasaka Yelusalemu, nako nee wawa wayaona yose ambayo Yesu kayagosoa. ");
INSERT INTO bou_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu akabua vituhu mzi wa Kana uko Galilaya, hantu ekuhituaho mazi na kuwa divai. Nee kuwa na mgookezi yumwe ekuwae na mwana mtamu uko Kapelinaumu. ");
INSERT INTO bou_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Muongoezi uyo ekusikiaho Yesu kalawa Uyahudi na kubua Galilaya akambasa akamwoombeza aite akamhonye mwanawe mwekuwa mtamu wa kukauwiiwa. ");
INSERT INTO bou_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu akamwamba, “Mkesekuona utangio na vihii khamna mzumiiye.” ");
INSERT INTO bou_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uyo Mwoongoezi akamwamba, “Zumbe chondechonde tite mwanangu asekweza kuuya na nyuma.” ");
INSERT INTO bou_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akamwamba, “Hita mwanao ni mgima.” Uyo muongoezi nee azumiiya mbui za Yesu, akaita zakwe. ");
INSERT INTO bou_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ekuaho yu siai, akakintana na wandima wakwe wakamwamba, “Yuda Mwana kindee kahona.” ");
INSERT INTO bou_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naye akawauza neeiwa saa nyingahi mwana ekuhoneaho, wakamwamba, “Zana saa mfungate wa musi, utamu ukamuweekea”. ");
INSERT INTO bou_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uyo tati yakwe akakumbuka iwa saa idaida Yesu ekumwambaho, “Mwanao ni mgima.” Aho akazumiiya hamwe na nyumba yakwe yose. ");
INSERT INTO bou_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Unu nee utangio wa kaidi ekugosoao Yesu ekuaho akaawa Uyahudi kuita Galilaya. ");
INSERT INTO bou_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yekwembokaho ayo, Yesu akaita Yelusalemu kwe sikukhuu ya Wayahudi. ");
INSERT INTO bou_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Uko Yelusalemu, hehi na uvi wetangwao uvi wa ngoto, nehawa na tondoo da mazi detangwado kwa kiebulania Betisaza ambado nee dizunguukwa na mabaaza mashano. ");
INSERT INTO bou_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aho nehawa na watamu wangi wekaa, matuntu, na wesao kudaha kwenda, na wekuhooawo. Newawa wakagoja mazi yatibulwe. ");
INSERT INTO bou_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwaviya mndima wa uwanga wa Muungu kuna kisingi aseeya na kuyavuuga mazi mwe tindiziwa ido, mtamu yoyose avokae kwengia mwe mazi aho mazi yakatibulwa, ahona utamu wakwe wowose ekuwao nao. ");
INSERT INTO bou_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aho, hana mgosi mwekuwa mtamu kwa kisingi cha myaka makumi matatu na minane. ");
INSERT INTO bou_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ekumuonaho kagona aho na kumanya kuwa kawa mtamu kwa misi mingi, akamwamba, “Ivi, wakunda kuhona?” ");
INSERT INTO bou_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yuda mtamu akamtambaisa, “Zumbe khina mntu wa kunegaa mwe tondoo da mazi kisingi yakatibulwa, kia nikageeza kwengia mntu mtuhu aniongweeya.” ");
INSERT INTO bou_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu akamwamba “Gooka, na doa javi dako wende.” ");
INSERT INTO bou_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vuupuu uyo mntu akahona, akadoa javi dakwe. Akavoka kwenda, mbui inu igosoka Msi wa Kuhumwiiza. ");
INSERT INTO bou_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wamwe wa waongoezi wa Wayahudi wakamwamba yuda mwe kuhonywa, “Ivyeeo ni Msi wa Kuhumwiiza kwa miko yetu khukundigwa wenue javi dako.” ");
INSERT INTO bou_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yee akawatambaisa, “Yuda mntu mwekunihonya nee mwekunamba udoe javi dako wende.” ");
INSERT INTO bou_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nawo wakamuuza, “Uyo mntu mwekukwamba udoe javi dako wende ni ndai?” ");
INSERT INTO bou_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iya yuda mntu khekummanya mntu mwekumhonya, Yesu nee kahauka kae hantu hada, kwaajii nee hana zumwezumwe kuu da wantu. ");
INSERT INTO bou_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Naho bada ya ayo, Yesu akambwiiya yuda mntu mwekumhonya mwe Nyumba ya Muungu akamwamba, “Isasa kuhona, wesekugosoa mavigaviga vituhu, usekweza kubwiiwa ni mbui fyaimi muno.” ");
INSERT INTO bou_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yuda mntu akaita, akawamba wakuu wa Kiyahudi, Yesu nee mwekunihonya. ");
INSERT INTO bou_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwaviya Yesu ida mbui kaigosoa Msi wa Kuhumwiiza, Wayahudi wakavoka kumkefyakefya Yesu. ");
INSERT INTO bou_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu akawamba, “Tate yangu agosoa ndima misi yose, na miye nagosoa ndima kwesiho kueka.” ");
INSERT INTO bou_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa mbui izi waongoezi wa Kiyahudi wakoondeza sia ya kumkoma Yesu, khio kwaviya kabananga miko ya Msi wa Kuhumwiiza du, akini kamba Muungu ni Tati yakwe ivyo ketenda aigana na Muungu. ");
INSERT INTO bou_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu akawamba, “Kwei nawamba, Mwana khadaha kugosoa kintu ikedu, adaha kugosoa kia amuonacho Tate agosoacho, kwaviya agosoacho Tate, Mwana nae akigosoa viyaviya.” ");
INSERT INTO bou_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwaviya Tate amkundisa Mwana, na kumuonyesha kia kintu agosoacho mwenye. Naho endaamuonyeshe mbui khuu kusima izi, nanywi mwendamhondomae. ");
INSERT INTO bou_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Inga viya Tate ayuyusavyo wekuuyao na nyuma, na kuwekha ugima, ivyoivyo Mwana naye awekha ugima wada awakundisao. ");
INSERT INTO bou_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tate khamuamuiiya mntu yoyose, iya kamtenda mwana awaamwiiye wantu wose. ");
INSERT INTO bou_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ili wantu wamtegeeze Mwana inga wamtegeezavyo Tate, yoyose esaekumtegeeza Mwana khamtegeeza Tate wekumwaagiiaye Mwana. ");
INSERT INTO bou_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nawamba kwei, wada wategeezao mbui zangu na kumzumiia yuda mwekuniagiiya wana ugima wa misi yose kwesiho kisiikizi, khana aamuiiwe katu, kwaviya wavota kae ufe na kwengia mwe ugima misi yose kwesiho kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nawamba kwei, kisingi cheza, naho kibuwa kae, na wada wekuwao hae na Muungu, wenda wategeeze mgutio wa Mwana wa Muungu, awo wenda wahokee ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Inga viya Tate awekhavyo wantu ugima, viyaviya kamtenda Mwana awekhe wantu ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naho kamwekha Mwana udaho wa kuamuiiya, kwaviya ni Mwana wa Mntu. ");
INSERT INTO bou_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Msekuhondomaa kwaajii ya mbui inu, kisingi cheza ambacho wose wekuuyao na nyuma wenda wategeeze mgutio ambao wose wekuwao mwe mambiya. ");
INSERT INTO bou_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nawo wendawalawe mwe mambiya wada wekugosoao matana, wenda wayuyuke na kwekaa, wada wekugosoao yesayokutama wenda wayuyuswe na kuamuiiwa. ");
INSERT INTO bou_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesu akaendeea kugombeka, “Khidaha kugosoa kintu kwa udaho wangu mwenye, miye neamuiiya inga nitegeezavyo kulawa kwa Tate na uwo wedi wangu ni wa kwei, kwaviya khigosoa nikundavyo mwenye, iya akundavyo yuda mwekuniagiiya.” ");
INSERT INTO bou_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Inga nawagombeka nywie mbui zangu mwenye, naho yada nigombekayo khamyavuhuzia kuwa ni ya kwei. ");
INSERT INTO bou_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Akini hana mntu mtuhu avuhuziae mbui zangu kwenu, na namanya agombeka kwei. ");
INSERT INTO bou_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nywie nee muagiiya wantu kwa Yohana wamuuze mbui zangu, nae akawavuhuzia ni kwei. ");
INSERT INTO bou_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Khio inga nakauwiiya wantu wanivuhuzie, akini nayagombeka aya ili mdahe kuoholwa. ");
INSERT INTO bou_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana nee kawa inga taa yekuwayo ikaka na kulavya ung'azi, nanywi muwa na nyemi na ung'azi uwo kwa kisingi kijihi. ");
INSERT INTO bou_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Akini kuna mbui khuu muno iyonyeshayo miye ni ndai kusima yada ekugombekayo Yohana mbatiiza. Mbui yenye ni zia ndima ekunekhazo Tate nizigosoe, ayo yose yanivuhuzia miye ni ndai na yaonyesha Tate nee mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naye tate mwekuniagiiya kanivuhuzia miye ni ndai, akini khamzati kutegeeza mgutio wakwe, naho kumwona yee eivyo, ");
INSERT INTO bou_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na mbui yakwe khayekwekaa mwe mioyo yenu, kwaviya khamwekumzumiiya yuda mwekumuagiiya. ");
INSERT INTO bou_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nywie mwayasunguumanya muno Maandiko ya Muungu kwaviya mwamamaakhanya mwe ayo mwendampate ugima wa misi yose kwesiho kisiikizi, na Maandiko ayo yanivuhuzia miye! ");
INSERT INTO bou_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ata ivyo khamkunda kweza kwangu ili mhokee ugima. ");
INSERT INTO bou_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Miye khiondeza kutunywa na wantu. ");
INSERT INTO bou_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Akini nawamanya nywie ni wantu wa namna yani, na viyaviya khamna ukundiso wa Muungu mwe mioyo yenu. ");
INSERT INTO bou_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miye ncheza kwa udaho wa Tate, akini khamnihokea, akini akeza mntu mtuhu kwa udaho wakwe mwenye, mwenda mumhokee. ");
INSERT INTO bou_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwakunda kuhokea ntunyo kulawa kwenu nywie wenye, akini khamkunda kuhokea ntunyo kulawa kwa Muungu mwenye, kwaajii iyo mwadaha viivihi kunizumiiya? ");
INSERT INTO bou_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Akini wesekufanyanya kuwa miye nenendae niwaahie masa kwa Tate, Musa ambae mwamkauwiya neendae awaahie masa. ");
INSERT INTO bou_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ati kwei nee mkamzumiiya Musa, nee mkanizumiiya na miye, kwaviya Musa kaandika mbui zangu. ");
INSERT INTO bou_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Akini kwaviya khamyazumiiya yada ekuyaandikayo Musa, mwadaha viivihi kuzumiia kiya nigombekacho?” ");
INSERT INTO bou_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yekwembokaho ayo, Yesu akadumua tindiziwa da mazi da Galilaya. Kwa zina tuhu detangwa ziwa da Tibelia. ");
INSERT INTO bou_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Zumwezumwe kuu da wantu dikatendesa kumbasa kwaajii waona ntangio nyingi na vihii ekugosoazo kwa watamu. ");
INSERT INTO bou_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu akakwea kwe muima, akekaa hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na Sikukhuu ya Wayahudi yetangwayo Pasaka iwa hehi. ");
INSERT INTO bou_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Naho Yesu ekukauwaho, na kuona zumwezumwe da wantu dikeza kwakwe, akamwamba Fiipo, “Tendatigue hahi mabumunda, wantu awa wadahe kuda?” ");
INSERT INTO bou_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nee kauza mbui iyo kumgeeza Fiipo kwaviya kamanya endachoagosoe. ");
INSERT INTO bou_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fiipo akamtambaisa, “Ata inga tikawa na hea dinali mia mbii nee khatokudaha kugua mabumunda ya kuwekha wantu awa.” ");
INSERT INTO bou_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mhina yakwe yumwe mwetangwa Andulea uyo nee kawa nduguye Simoni Petulo akamwamba Yesu, ");
INSERT INTO bou_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yuhanu mbwanga yumwe ana mabumunda mashano ya shaili na samaki vidodo viidi, akini vyendavitoshe mbwai kwa wantu wangi inga awa?” ");
INSERT INTO bou_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu akamba, “Waikeni wantu,” hantu hada nehawa na ulondo mtana, wantu wakekaa, na wagosi du nee wawa elufu shano. ");
INSERT INTO bou_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Naho Yesu akadoa yada mabumunda akamtogoa Muungu, akawapangia wantu wekuawo wekaa, akagosoa viyaviya na wada samaki, kia mntu akahokea na akada inga akundavyo kuda. ");
INSERT INTO bou_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wantu wekwegutaho Yesu akawamba wahina wakwe, “Dodoani phuguntio zekusigaazo kisekwaga chochose.” ");
INSERT INTO bou_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wakadodoa phuguntio zia za mabumunda ya shaili vyekusigazwavyo na wada wantu wekudao, wakamemeeza ngahu kumi dimwe na mbii. ");
INSERT INTO bou_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wantu wekuonaho ntangio icho ekugosoacho Yesu wakamba, “Kwei uyu nee muoni tekumkauwiaye endaeze mwe inusi.” ");
INSERT INTO bou_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu akamanya kuwa wantu waondeza kumdoa wamtende Seuta, akahauka vituhu akaita kwe muima yee ikedu. ");
INSERT INTO bou_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yekubuaho guoni wahina wakwe Yesu wakaseeya mwe mazimshindo, ");
INSERT INTO bou_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wakakwea ngaawa ili wemboke waite Kapelinaumu. Kiza nee chengia kae, na Yesu nee khazati kuseeya mwe muima ili awe nawo. ");
INSERT INTO bou_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tindiziwa da mazi dikavoka kuvuugika kwaajii khusi khai neiwa yavuma. ");
INSERT INTO bou_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wahina wakwe Yesu newawa wakatoa makasia kuita inga uhae wa kilomita shano hambu mtandatu, wakamwona Yesu akenda uwanga ya mazi, akaitimia ngaawa wakaogoha muno. ");
INSERT INTO bou_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Akini Yesu akawamba, “Ni miye msekuogoha.” ");
INSERT INTO bou_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nee wakoondeza kumwegaa Yesu he mpwani ahoaho ngaawa ibuwa mwe si khavu wekuwayo waita. ");
INSERT INTO bou_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kioi dakwe zumwezumwe da wantu wada wekuwao wekaa phande ya kaidi ya tindiziwa da mazi nee wakabukhua kuwa hawa na ngaawa mwengadu hantu hada, Yesu khekwengia mwe ida ngaawa hamwe na wahina wakwe, iya wahina awo nee waita kae ikedu. ");
INSERT INTO bou_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wantu watuhu kulawa Tibelia wakabuwa na ngaawa, hantu hada wantu wekudaho mabumunda, Zumbe ekumtogoaho Muungu. ");
INSERT INTO bou_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Naho wantu wekumanyaho ati Yesu na wahina wakwe khawekuwaaho hantu hada, wakakwea mwe ngaawa izo na wakaita Kapelinaumu kumuondeza Yesu. ");
INSERT INTO bou_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wada wantu wekumbwiiaho Yesu phande ya kaidi ya tondoo da mazi wakamuuza, “Mhinyi, kubuwa ini aha?” ");
INSERT INTO bou_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu akawatambaisa, “Nawamba kwei mwaniondeza khio kwa viya muona ntangio nekugosoavyo, iya kwaajii nee mda yada mabumunda mkeguta. ");
INSERT INTO bou_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Msekugosoa ndima kwaajii ya kwepata khande ibanikayo, iya gosoani ndima kwaajii ya khande yesayo kubanika vyekaa misi yose kwesiho kisiikizi. Khande izo zendaziwekhe ugima wa misi yose kwesiho kisiikizi kulawa kwa Muungu. Mwana wa Mntu nee endayeawekhe khande iyo, kwaajii Tate Muungu khamwekha udaho wa kugosoa ivyo.” ");
INSERT INTO bou_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wowo wakauza, “Titende mbwai tidahe kugosoa ndima za Muungu?” ");
INSERT INTO bou_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akawatambaisa, akawamba, “Ndima ambayo Muungu akunda mwiigosoe nikunizumiiya mie, ambae kiagiiwa nae.” ");
INSERT INTO bou_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aho wakamwamba, “Wendaugosoe ntangio yani ili tiikauwe tidahe kukuzumiiya? ");
INSERT INTO bou_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mababa zetu wada khande yekwetangwayo mana kuda kwe kiwawe, inga yagombekavyo Maandiko ya Muungu, ‘Kawaisa mabumunda kulawa uwanga.’ ” ");
INSERT INTO bou_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu akagombeka, “Nawamba kwei, Musa khekuwekha mabumunda kulawa uwanga kwa Muungu, iya Tate yangu nee awekhae nywie bumunda da kwei, kulawa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwaviya bumunda da Muungu ni yuda ekuseeaye kulawa uwanga kwa Muungu, ili awekhae wantu wa inusi inu ugima wa misi yose kwesiho kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aho wakamwamba, “Zumbe, kuvoka isasa tekhe bumunda ido misi yose.” ");
INSERT INTO bou_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu akawamba, “Miye nee bumunda da ugima.” Na mntu yoyose ezae kwangu na kunizumiiya khanaawe na saa wala khiu katu. ");
INSERT INTO bou_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Akini nawamba kuwa, mniona akini khamnizumiiya. ");
INSERT INTO bou_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose anekhao Tate, wendaweze hangu na mie katu khina nimwase chongoi yoyose mwendaeeze hangu, ");
INSERT INTO bou_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwaviya khiseeya kulawa uwanga kwa Muungu, khio kwaajii ya kugosoa yada niyakundayo mie, iya kugenyeza yada akundayo Muungu mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na yada akundayo Muungu mwekuniagiiya nee aya, nesekumwaza ata yumwe gatigati ya wada ekunekhao, iya niwayuyuse wose msi wa kisikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwaviya akundavyo Tate, nee iki kia mntu amkauwaye Mwana na kumzumiiya, awe na ugima wa misi yose kwesiho kisiikizi, naho nenda nimyuyuse msi wa kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aho Wayahudi wakavoka kung'ung'uzika kwaviya kagombeka, “Miye ni bumunda dekuseeyado kulawa uwanga.” ");
INSERT INTO bou_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wakamba, “Uyu khi Yesu mwana wa Yusufu? Tammanya tati yakwe na mami yakwe naho, adaha vivihi kugombeka ati kaseeya kulawa uwanga kwa Muungu?” ");
INSERT INTO bou_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu akawatambaisa, “Ekani kunung'unika nywinywi kwa nywie. ");
INSERT INTO bou_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Khahana mntu adahae kweza kwangu, inga Tate mwekuniagiiya khekumuongoea kwangu, na miye nendanimyuyuse mntu uyo msi wa kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Muoni yumwe wa Muungu nee kaandika mwe kitabu cha Muungu, ‘Wantu wose wenda wahinywe ni Muungu.’ Kia mntu amtegeezaye na kumzumiia Tate, eza kwangu. ");
INSERT INTO bou_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inu khaina mana kuwa, yuuko mntu yee ikedu mwekumuona Tate, iya ni yuda ekulawae kwa Muungu, uyo nee mwekumuona Tate. ");
INSERT INTO bou_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kwei nawamba, mnizumiiya ana ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miye ni bumunda da ugima. ");
INSERT INTO bou_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mababa zenu nee wada khande yekwetangwayo mana kuda kwe kiwawe, akini wauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Akini idi ni bumunda diseeyado kulawa uwanga kwa Muungu, mntu yoyose adae khadaha kuuya na nyuma. ");
INSERT INTO bou_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miye ni bumunda da ugima wekuseeao kulawa uwanga kwa Muungu, mntu yoyose mwendaye ade bumunda idi endaekae misi yose kwesiho kisiikizi, na bumunda nendado nimwekhe ni mwii wangu naulavya kwa ugima wa inusi.” ");
INSERT INTO bou_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aho Wayahudi wakavoka kuhigana wowo wenye wakauzana, “Adaha viivihi kutekha mwii wakwe tiude?” ");
INSERT INTO bou_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu akawamba, “Nawamba ukwei, mkesekuuda mwii wa Mwana wa Mntu na kudomea phome yakwe khamnamuwe na ugima mwe mii yenu. ");
INSERT INTO bou_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Adae mwii wangu na kudomea phome yangu anawo ugima wa misi yose kwesiho kisiikizi, na miye nenda nimyuyuse msi wa kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwaviya mwii wangu ni khande ya kwei na phome yangu ni kidomewacho cha kwei. ");
INSERT INTO bou_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yoyose adae mwii wangu na kudomea phome yangu ekaa umu mwangu na miye nekaa kwakwe. ");
INSERT INTO bou_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tate wa ugima kaniagiiya nigosoe ndima na miye nekaa kwaajii yakwe, ivyo anidae miye naye endaekae kwaajii yangu. ");
INSERT INTO bou_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naho idi nee bumunda dekuseeyado kulawa uwanga, khio inga bumunda wekudayo mababa zenu, ata ivyo wakauya na nyuma, adae bumunda idi endaawe na ugima wa misi yose kwesiho kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kagombeka ayo ekuaho akahinya he Nyumba ya kukintania Wayahudi uko Kapelinaumu. ");
INSERT INTO bou_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ivyo, wahina wakwe wekutegeezaho mbui inu wakamba, “Mahinyo aya khayava ni ndai adahae kuyahokea?” ");
INSERT INTO bou_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu akamanya kwesiho kugombekwa ni mntu kuwa wahina wakwe nee wang'ung'uzika kwa mbui iyo akawauza, “Ivi mbui inu yawatenda muwe na maatu? ");
INSERT INTO bou_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yendaiwe viivihi mwendaho mmuone Mwana wa Mntu akakwea na kuita uwanga kwa Muungu kuda ekulawako? ");
INSERT INTO bou_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Muye wa Muungu nee uetao ugima, mwii khauna udaho wakugosoa kintu. Mbui nekuwagombekazo zalawa kwa Muye wa Muungu na yaeta ugima. ");
INSERT INTO bou_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Akini, wantu watuhu gatigati yenu khawazumiiya.” Yesu kagombeka ivyo kwaviya kamanya kuvokea aho bosi, wada ambao khawana wamzumiye gatigati yao na yuda ambae enda amhituke. ");
INSERT INTO bou_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akatendesa kugombeka, “Kwaajii inu, nee nekuwambavyo kuwa khahana mntu adahae kweza hangu kwesiho kuongoewa na Tate yangu.” ");
INSERT INTO bou_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwaajii ya ayo, wahina wakwe wangi wekumtongeao Yesu, wakauya mgeeka, wasekutongeana nae vituhu. ");
INSERT INTO bou_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ivyo Yesu akawauza wada kumi dimwe na mbii, “Nanywi mwakunda kuhauka?” ");
INSERT INTO bou_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo akamtambaisa, “Zumbe tendatiite kwa ndai? Wee una mbui za ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Swie tazumiiya na kumanya kuwa wee nee Klistu mwekusagulwae kulawa kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akawauza, “Ivi ncheekuwasagua nywie kumi dimwe na mbii? Na yumwe aongoewa na Ibiisi.” ");
INSERT INTO bou_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu kagombeka ayo kwaajii ya Yuda, mwana wa Simoni Isikaliote kwaviya uyu nee endaeamhituke, etiho ni yumwe da wada kumi dimwe na mbii. ");
INSERT INTO bou_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yekwembokaho ayo, Yesu nee avoka kuzunguka kia hantu mwe mizi ya Galilaya, khekukunda kuita si ya Yudea kwaajii waongweezi wa Kiyahudi nee wakaondeza kumkoma. ");
INSERT INTO bou_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kisingi cha sikukhuu mwenga ya Wayahudi yetangwayo sikukhuu ya vikumbi nee iwa hehi. ");
INSERT INTO bou_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Naho nduguze da Yesu wakamwamba, “Hauke aho uite si ya Yudea ili wahina wako wakaone ndima uzigosoazo. ");
INSERT INTO bou_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mntu khagosoa mbui kwa sii inga akakunda kumanyika kwa wantu, kwaviya wagosoa mbui izi, naho eambaze mwe inusi wantu ili wakumanye.” ");
INSERT INTO bou_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Naho ata wanduguze wagombeka ivyo kwaviya khawekumzumiiya. ");
INSERT INTO bou_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu akawamba, “Kisingi changu cha kuita uko Yelusalemu khakizati kubuwa, akini nywie mwadaha kuita kisingi chochose. ");
INSERT INTO bou_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wantu wa mwe inusi inu khawamiemea nywie, akini miye waniemea kwaajii nawavuhuzia kuwa wagosoa mafyaimi. ");
INSERT INTO bou_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nywie hitani kwe sikukhuu iyo, miye khina niite kwe sikukhuu iyo, kwaviya mda wangu ukundigwao khauzati kubuwa.” ");
INSERT INTO bou_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu ekubindiizaho kugombeka ivyo, akasigaa uko Galilaya. ");
INSERT INTO bou_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wanduguze nee waongowa kuita kwe sikukhuu Yelusalemu, Yesu naye akaita, akini kwa sii. ");
INSERT INTO bou_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naho Waongoeezi wa Kiyahudi kisingi waaho mwe sikukhuu na kuwauza wantu, “Yu hahi mtu uyu?” ");
INSERT INTO bou_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hawa na mipokoso mingi mwe zumwezumwe da wantu, wamwe wakamba, “Ni mntu yedi.” Watuhu wakamba, “Khivyo kwaviya awaza wantu.” ");
INSERT INTO bou_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na ivyo khahana mntu mwekugeeza kugombeka mbui zakwe hewazo kwa kuogoha waongoezi wa Kiyahudi. ");
INSERT INTO bou_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Sikukhuu iyo yekubuaho gatigati, Yesu nee aita he Nyumba ya Muungu, akavoka kuhinya. ");
INSERT INTO bou_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Naho Wayahudi wakahondomaa na kugombeka, “Mntu uyu kamanya viivihi mbui izi kwesiho kuhinywa?” ");
INSERT INTO bou_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu akawatambaisa, “Mahinyo nihinyayo khio yangu, iya yalawa kwa Muungu mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mntu mkunda kugosoa yada akundayo Muungu, endaamanye mahinyo yangu yalawa kwa Muungu, hambu negombekea ni yamie mwenye. ");
INSERT INTO bou_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yee egombekeaye mwenye aondeza Ukuu mwenye, akini aondezae ukuu kwa yuda mwekuniagiiya, uyo agombeka yekuwayo kwei na khagombeka uhokho. ");
INSERT INTO bou_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ivi Musa khekuwekha miagiiyo ambayo kekhigwa ni Muungu? Na ivyo khahana katu mntu yumwe mtoza miko kwa mbwai mwaonda kunikoma?” ");
INSERT INTO bou_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aho wantu wakamtambaisa, “Wee una zaiko, nindai muondeza kukukoma?” ");
INSERT INTO bou_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akawatambaisa, “Kuna mbui mwenga nekugosoayo nanywi yawahondomaza. ");
INSERT INTO bou_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa nee kawaagiiya nywie kugwisa wana wenu wakigosi. Kugombeka kwei mbui iyo ivoka kwa mababa zenu, akini nywie mwawagwisa wana wenu ata Msi wa Kuhumwiiza. ");
INSERT INTO bou_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ikawa mntu adaha kugwiswa ata Msi wa Kuhumwiiza ili kuitoza miagiiyo ya Musa, kwambwai mwanikima kwaviya khihonya mntu Msi wa Kuhumwiiza? ");
INSERT INTO bou_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mwesekumuamuiya mntu kwa mbui zionekazo kwa chongoi, iya mumuamuiiye mntu kwa wedi na ikundigwavyo.” ");
INSERT INTO bou_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wamwe wa wantu wa Yelusalemu nee wagombeka, “Ivi, uyu khio yuda mntu ambae waongweezi wakunda kumkoma? ");
INSERT INTO bou_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mbona yuaha atamwiiya hemeso ya wantu, naho khahana mntu agombekae mbui yoyose! Ivi yadahika waongoeezi wamanya kwei inga uyu nee Klistu? ");
INSERT INTO bou_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Endahoeze Klistu Mwohozi, khahana mntu endayeamanye hantu ekulawiako, akini swie tamanya alawiako.” ");
INSERT INTO bou_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aho Yesu ekuwaho akahinya he Nyumba ya Muungu, akagombeka kwa mgutio mkuu, “Inga mwanimanya, uko nilawiako mwakumanya na ivyo ncheekweza kwa udaho wangu iya ni yuda mwekuniagiiya miye ni wa kwei, nywie khamummanya, ");
INSERT INTO bou_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","akini miye nammanya kwaviya kilawiya kwakwe na yee nee mwekuniagiiya.” ");
INSERT INTO bou_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Naho, wantu nee wakaondeza kumgwiya akini khahana mwekudaha kumgwiya kwaviya mda wakwe nee khauzati kubua. ");
INSERT INTO bou_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wantu wangi mwe dia zumwezumwe da wantu nee wamzumiiya na kugombeka, “Ivi, Klistu akeza endaagosoe ntangio vikuu kusima ekugosoazo uyu?” ");
INSERT INTO bou_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo wawategeeza wantu wakapokosa mbui izo za Yesu, aho wowo hamwe na waviki wakuu wakawaagiiya wagoji wamgwiye. ");
INSERT INTO bou_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu akamba, “Nikeaho na nywie kwa kisingi kijihi, nikabinda nendaniuye kwa yuda mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwenda mniondeze akini khamna mnione na hada nendahoniwe, nywie kwamdaha kubua.” ");
INSERT INTO bou_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Waongoeezi wa Kiyahudi wakauzana wowo kwa wowo, “Mntu uyu enda aite kuhi ambaho khatina tidahe kumuona? Endaaite kwa Wayahudi wekuambazikao gatigati ya Wagiiki na kuwahinya Wagiiki? ");
INSERT INTO bou_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ivi akunda kugombeka mbwai agombekaho, mwenda mniondeze akini khamna mnione na hada nendaho niwe nywie khamdaha kubua.” ");
INSERT INTO bou_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Msi wa kisiikizi wa sikukhuu iyo nee ni msi maalum, Yesu akagooka, akagombeka kwa mgutio mkuu, “Mtozwa ni khiu na eze kwangu adomee mazi, ");
INSERT INTO bou_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","inga yagombekavyo Maandiko ya Muungu, ‘Mnizumiiya miye, vizigizigi vya mazi ya ugima vyenda vimwamwaike kulawa mwe moyo wakwe.’ ” ");
INSERT INTO bou_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kagombeka ayo kuusu Muye kwa wada wamzumiiao yee wendawamhokee, kisingi icho Muye khazati kweza, kwa ivyo Yesu nee khazati atogolwe. ");
INSERT INTO bou_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wantu watuhu he dia zumwezumwe wategeeza mbui izo, “Kwei mntu uyu Muoni.” ");
INSERT INTO bou_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Watuhu wamba, “Uyu nee Klistu.” Akini watuhu wamba, “Yadahika viivihi Klistu akalawiiya mwe si ya Galilaya! ");
INSERT INTO bou_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiko ya Muungu yamba kuwa, Klistu endaalawiiye he muango wa Seuta Daudi, na endaavyaigwe Betilehemu mzi ekuwao akekaa Daudi.” ");
INSERT INTO bou_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nee kwalawiiya kwepanga kwaajii yakwe he dia zumwezumwe da wantu. ");
INSERT INTO bou_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wantu watuhu nee wakoondeza kumgwiya Yesu, akini khahana mntu mwekugeeza kumgwiya. ");
INSERT INTO bou_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Naho wada wagoji wakauya kwa waviki wakuu na Mafalisayo na wakauzwa, “Kwa mbwai khamwekumweeta Yesu?” ");
INSERT INTO bou_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wagoji wakawatambaisa, “Khahana mntu ekulawiyae na kugombeka mbui khuu inga mntu uyu!” ");
INSERT INTO bou_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo wakawauza, “Ivi nywie nanywi mtiiwa?” ");
INSERT INTO bou_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Ivi, mwammanya mwoongoezi yoyose, hambu yumwe wa Mafalisayo mwekumzumiiya mntu uyu? ");
INSERT INTO bou_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Akini zumwezumwe da wantu wamzumiiao, khawamanya miagiiyo ya Musa, kubadiwa lazi na Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yumwe yao kawa Nikodemo uyo nee mwekumbasa Yesu na kio, naho nee mwekugombeka. ");
INSERT INTO bou_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Miagiiyo tekwekhigwayo na Muungu kwembokea Musa yatiemeza kumuamuiiya mntu kabla ya kumtegeeza na kumanya kia ekugosoacho.” ");
INSERT INTO bou_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nawo wakamtambaisa, “Wee nawe kulawa si ya Galilaya? Ni vyedi, kayasunguumanye Maandiko ya Muungu nawe wendauone kuwa Galilaya khakulawa katu muoni.” ");
INSERT INTO bou_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naho wose wakahauka, kiya mntu akaita kwakwe. ");
INSERT INTO bou_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Akini Yesu akaita he muima wa Mizaituni. ");
INSERT INTO bou_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kioi dakwe keokeo, Yesu nee aita vituhu kwe Nyumba ya Muungu, wantu wose wakambasa, nae akekaa akahinya. ");
INSERT INTO bou_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naho Wahinya wa miagiiyo na Mafalisayo wakamweeteya mvyee yumwe mwekutozwa heugoni, wakamgoosa gatigati yawo. ");
INSERT INTO bou_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nee wamuuza, “Mhinyi!” “Mvyee uyu timbwiiya he ugoni. ");
INSERT INTO bou_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mwe miagiiyo yetu Musa katiagiiya mvyee inga uyu atoigwe maiwe adi auye na nyuma, tambe nawe wambaze?” ");
INSERT INTO bou_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wowo wagombeka ivyo, ili wapate mbui yendayoiwatende wamuahiye masa. Akini Yesu akenama na kuaandika asi kwa chaa. ");
INSERT INTO bou_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wekutendesaho kumuuza, Yesu akenuka akawamba, “Yumwe yenu mwesekuwa na mavigaviga na avoke kumtambikia iwe.” ");
INSERT INTO bou_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Naho akenama vituhu, na kuandika ahosi kwa chaa chakwe. ");
INSERT INTO bou_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wekutegeezaho ayo, wakavoka kuhauka yumweyumwe, wakaongoa wadaa, Yesu akasigaa ikedu kidege na yuda mvyee kagooka hadahada. ");
INSERT INTO bou_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ekwenukaho akamuuza yuda mvyee, “Wahahi wada wantu? Ivi khahana katu ata yumwe mwekukuamuiiya?” ");
INSERT INTO bou_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uyo mvyee akamtambaisa, “Zumbe khahana ata yumwe!” Na Yesu akamwamba, “Miye nami khinanikuamuiiye, hita na usekugosoa mavigaviga vituhu.” ");
INSERT INTO bou_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu akatamwiiya nao vituhu, akawamba, “Mie nee ung'azi wa inusi, yoyose anibasae endaawe na ung'azi umuongoeae mwe ugima wa misi yose kwesiho kisiikizi, naho khanaende mwe kiza katu.” ");
INSERT INTO bou_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo wakamwamba kwei Yesu, “Mbui zako wegombekea mwenye, ivyo khahana mntu akuvuhuziae mbui zako.” ");
INSERT INTO bou_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu akawatambaisa, “Ata inga nevuhuzia mwenye, yada nigombekayo ni ya kwei, kwaviya namanya nilawako na niitako, akini nywie khammanya nilawako wala niitako. ");
INSERT INTO bou_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nywinywi mwaamuiiya wantu kwakuwakauwa viya wagosoavyo, akini mie khiamuiiya mntu. ");
INSERT INTO bou_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Etiho nikaamuiiya, uwamuiiyo wangu ni kwei, kwa ivyo miye khio ikedu, Tate mwekuniagiiya yu hamwe na miye. ");
INSERT INTO bou_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iyandikwa mwe miagiiyo yenu, kuwa uvuhuzi wa wantu waidi, mbui iyo ni kwei. ");
INSERT INTO bou_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miye nevuhuzia mwenye na Tate mwekuniagiiya nae anivuhuzia.” ");
INSERT INTO bou_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aho wakamuuza Yesu, “Tati yako yu hahi.” Yesu akawatambaisa, “Nywie khamnimanya miye naho khamummanya Tate, ati nee mkanimanya nee mkammanya na Tate.” ");
INSERT INTO bou_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kagombeka mbui izo mwe chumba cha kiikizo, ekuwaho akahinya kwe Nyumba ya Muungu, naho khahana mntu mwekumgwiya, kwaviya mda wakwe khauzati kubua. ");
INSERT INTO bou_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu akawamba vituhu, “Miye naita na nywie mwenda mniondeze, akini mwenda muuye na nyuma kwa mavigaviga yenu, niitako miye, nywie khamdaha kweza.” ");
INSERT INTO bou_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Waongoeezi wa Kiyahudi wakauzana, “Ivi endaekome mwenye? Kwambwai amba, niitako khamna mbue.” ");
INSERT INTO bou_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu akawamba, “Nywie mlawa ahaaha asi, miye nalawa uwanga kwa Muungu, nywie ni wa mwe inusi inu, miye khio wa mwe inusi inu. ");
INSERT INTO bou_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nee mana nikawamba, ‘mwenda muuye na nyuma he mavigaviga yenu mkesekuzumiiya kuwa miye nee mweaho ambae niaho mwenda muuye na nyuma kwa mavigaviga yenu.’ ” ");
INSERT INTO bou_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wowo wakamuuza Yesu, “Wee ni ndai?” Yesu akawatambaisa, “Miye nee yuda nekuwagombekae aho bosi. ");
INSERT INTO bou_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ninayo mangi ya kugombeka na kuwamuiiya uwanga yenu, akini yuda mwekuniagiiya ni kwei nami nawamba wantu wainusi mbui ziyadu nekuzitegeezazo kulawa kwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Khawekuva ati Yesu kagombeka nawo kuusu Tati yakwe wa uwanga kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu akawamba, “Mwendaho mmwenue Mwana wa Mntu aho ndiho mwendaho mmanye, ‘Mie nee uyo’ na kuwa khigosoa chochose mie kwa udaho wangu akini nagombekadu yada Tate ekunihinyayo. ");
INSERT INTO bou_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yuda mwekuniagiiya yuhamwe namiye, yee khekunibada ikedu kwaviya nagosoa yada yamtamiayo misi yose.” ");
INSERT INTO bou_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ekubindaho kugombeka ayo wantu wangi wakamzumiia. ");
INSERT INTO bou_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu akawamba wada Wayahudi wamzumiiao, “Ati mkayatozeeza mahinyo yangu, mwendamuwe wahina wangu kwei. ");
INSERT INTO bou_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Naho Mwenda mmanye kwei, kwasia ya ukwei uwo Muungu eza kuwaekea kulawa mwe utumwa.” ");
INSERT INTO bou_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wowo wakamuuza, “Swie tiuvyazi wa Ibulahimu na khatizati katu kuwa watumwa wa mntu yawa viivihi ukamba tenda tiekewe?” ");
INSERT INTO bou_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu akawatambaisa, “Nawamba kwei kia mntu mgosoa mavigaviga ni mtumwa wa mavigaviga. ");
INSERT INTO bou_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mtumwa khana chekao cha kwekaa mwe nyumba, akini Mwana anacho chekao kisingi chose. ");
INSERT INTO bou_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Inga Mwana akawaekea kulawa mwe utumwa wa mavigaviga, mwenda muwe muekewa kweikwei. ");
INSERT INTO bou_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Namanya nywie ni muango wa Ibulahimu, na ivyo mwaondeza kunikoma kwaviya muyaemea mahinyo yangu. ");
INSERT INTO bou_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miye nagombeka ekunionyeshayo Tate, akini nywie mwagosoa yada yekugombekwayo na Tati yenu.” ");
INSERT INTO bou_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wowo wakamtambaisa, “Swie tiwana wa Ibulahimu.” Yesu akawamba, “Inga nywie ni wana wa Abulahamu, nee mkagosoa inga yada ekugosoayo Abulahamu. ");
INSERT INTO bou_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nawamba ukwei, nekuutegeezao kwa Muungu, na ivyo nywie mwaondeza kunikoma, Ibulahimu khekugosoa ivyo. ");
INSERT INTO bou_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nywie mwagosoa mbui ziyaziya ekugosoazo tati yenu.” Wowo wakamwamba, “Swie khio wanahalamu na tinae Tate yumwedu na nee Muungu yetu!” ");
INSERT INTO bou_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu akawamba, “Inga Muungu nee tati yenu nee mkanikundisa, kwaviya miye nalawa kwa Muungu isasa niaha, ncheekweza kwa udaho wangu mwenye, iya yee Muungu mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwa mbwai khamva ayo nigombekayo? Kwaviya muemea kutegeeza mbui yangu. ");
INSERT INTO bou_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nywie ni wana wa tati yenu Ibiisi mwaondeza kugosoa mbui akundazo tati yenu. Yee kawa mkomaji kuvokea aho bosi, wala khekugooka mwe ukwei, kwaviya kwei khaimo umo mwakwe. Kia agombekaho uhokho, agombeka uhokho kwaajii nee eivyo, kwaviya yee ni mhokho na tate wa uwo uhokho. ");
INSERT INTO bou_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Akini mie nagombeka ukwei, nee kiekacho nywie msekunizumiiya. ");
INSERT INTO bou_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yuhi gatigati yenu adahae kumanya ati mie nina mavigaviga? Ati nagombeka ukwei kwa mbwai khamnizumiiya? ");
INSERT INTO bou_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mntu wa Muungu ategeeza mbui za Muungu akini nywie khamtegeeza, ivyo nywie khio wantu wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi wakamtambaisa Yesu, “Uwo khatekugombeka ukwei ati wee umsamalia naho una zaiko?” ");
INSERT INTO bou_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu akawatambaisa, “Mie khina mazaiko, mie namtegeeza Tate, iya nywie khamnitegeeza mie. ");
INSERT INTO bou_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miye khiondeza wantu wanitunye akini yuaho akundae wantu wanitunye na yee nee mwaamua inga nagosoa ikundigwavyo. ");
INSERT INTO bou_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kwei nawamba, mwekutozeeza mbui zangu khana auye na nyuma kisingi chose.” ");
INSERT INTO bou_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Aho Wayahudi wakamba, “Isasa tamanya kwei kuwa wee una zaiko! Ibulahimu kauya na nyuma, Waoni nawo wauya na nyuma, wee wamba mtozeeza mbui zangu khana auye na nyuma kisingi chose. ");
INSERT INTO bou_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ivi wetenda umkuu kusima tati yetu Ibulahimu mwe kuuya na nyuma? Na waoni nawo wauya na nyuma, asa wee wetenda kuwa undai?” ");
INSERT INTO bou_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akawatambaisa, “Inga nikefena mwenye, kwetogoa kwangu ni bue. Akini tate yangu uyo mgombekaye nee Muungu yenu, nee anitogoae. ");
INSERT INTO bou_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nywie khamzati kummanya akini mie nammanya, nikamba khimmanya nendaniwe mhokho inga nywinywi, mie nammanya na natoza mbui yakwe. ");
INSERT INTO bou_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baba yenu Ibulahimu kawa na nyemi muno kumanya kuwa miye nendaneze. Neekawa inga kaniona, nee kawa na nyemi muno.” ");
INSERT INTO bou_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aho Wayahudi wakamwamba, “Wee khuzati kubuza myaka makumi mashano nawe kumwona kuhi Ibulahimu?” ");
INSERT INTO bou_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu akawamba, “Kwei nawamba kisingi Ibulahimu khazati kuvyaigwa, ‘Mie nee Niuko.’ ” ");
INSERT INTO bou_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aho wakadoa maiwe ili wamtambikie, akini Yesu akefisa akalawa kwe Nyumba ya Muungu. ");
INSERT INTO bou_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu ekuaho akemboka, akamuona mntu yumwe mwekuvyaigwa tuntu. ");
INSERT INTO bou_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aho, wahina wakwe wakamuuza, “Mhinya! Ni yuhi mwekugosoa mavigaviga, mntu uyu hambu wavyazi wakwe ata avyaigwe tuntu?” ");
INSERT INTO bou_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akawatambaisa, “Mbui inu khayokulawiiya kwaajii ya mavigaviga yakwe wala mavigaviga ya wavyazi wakwe, iya kavyaigwa tuntu ili udaho wa Muungu uoneke ukagosoa ndima umo mwakwe. ");
INSERT INTO bou_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kukawa kuke musi takundigwa titendese kugosoa ndima za yuda mwekuniagiiya, mana kio cheza mntu khadaha kugosoa ndima. ");
INSERT INTO bou_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kisingi nike mwe inusi, mie ni ung'azi wa inusi.” ");
INSERT INTO bou_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ekubindaho kugombeka ayo, akaswa ovu ahosi, akagosoa ntope kwa dia ovu, akamsisa yuda tuntu he meso. ");
INSERT INTO bou_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akamwamba, “Hita ukesunte cheni he tondoo da mazi da siloamu” mana ya zina idi ni mwekuagiiwa, aho yuda tuntu akaita, akesunta akauya uku aona. ");
INSERT INTO bou_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naho wahehi yakwe, na wada wekuwao wakammanya aho bosi kawa mkiwa mwekuwa akaombeza, wakamba, “Ivi, uyu khie yuda mkiwa mwekuwa akekaa na kuombeza?” ");
INSERT INTO bou_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wamwe wao wakamba, “Ndie.” Watuhu wakamba, “Khio iya waigana nae.” Akini yuda ekuae khaona akamba “Ni miye.” ");
INSERT INTO bou_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nae wakamuuza “Isasa meso yako yadaha vivihi kugubuka?” ");
INSERT INTO bou_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naye akawatambaisa, “Yuda mntu etangwae Yesu, kagosoa ntope akanisisa mwe meso na kunamba, hita ukesunte he tondoo da siloamu, aho nee naita nikesunta nikadaha kuona.” ");
INSERT INTO bou_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wakamuuza, “Yee yu hahi?” Akawatambaisa, “Mie khimanya.” ");
INSERT INTO bou_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nee wamwegaa yuda mntu mwekuwae tuntu kwa mafalisayo. ");
INSERT INTO bou_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Msi uwo Yesu ekugosoaho ntope na kumgubua meso mntu uyo iwa Msi wa Kuhumwiiza. ");
INSERT INTO bou_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Naho mafalisayo wakamuuza mntu uyo, “Kudaha viivihi kuona? Akawamba kanisisa ntope mwe meso, nami nikesunta, na isasa naona.” ");
INSERT INTO bou_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wamwe wa Mafalisayo wakamba, “Mntu uyu khee kulawa kwa Muungu mana khatoza miagiiyo ya Msi wa Kuhumwiiza.” Akini watuhu wakamba, “Mntu mwenye mavigaviga adaha kugosoa viivihi utangio inga unu?” Ivyo Mafalisayo khawekwevana wowo wenye. ");
INSERT INTO bou_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wakamuuza vituhu yuda mwekuwa tuntu, “Kwa kuwa kakugubua meso wambaze uwanga ya mntu uyo?” Nae akawamba, “Yee ni Muoni wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Waongoezi wa Kiyahudi khawekumzumiiya ati mntu uyo nee kawa tuntu aho bosi, na isasa aona, adi wekuwetangaho wavyazi wakwe. ");
INSERT INTO bou_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Aho, wakawauza, awo wavyazi, “Uyu ni yuda mwana yenu mwekugombekae kavyaigwa tuntu? Kadaha viivihi kuona?” ");
INSERT INTO bou_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wavyazi wakwe wakatambaisa, “Tamanya uyu ni mwana yetu na kavyaigwa tuntu. ");
INSERT INTO bou_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Akini kadaha viivihi kuona, khatimanya, nahodu khatimmanya yuda mwekumgubwiiya meso, muuzeni yee mwenye ni mntu mgima adaha kugombeka yee mwenye.” ");
INSERT INTO bou_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wavyazi wakwe wamba ivyo kwa kuwaogoha waongoeezi wa Kiyahudi, kwa kuwa waongoeezi awo wevana kae, kuwa mntu yoyose agombeke Yesu nee Klistu, endaaguuswe he Nyumba ya kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nee mana wavyazi wakwe wakamba, “Yee ni mntu mgima muuzeni.” ");
INSERT INTO bou_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Naho wakamwetanga vituhu yuda mwekuwa tuntu, wakamwamba, “Gombeka ukwei mwekhe Muungu Ukuu swie tamanya ati mntu uyu ni mwenye mavigaviga.” ");
INSERT INTO bou_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yee akatambaisa, “Ati ni mwenye mavigaviga miye khimanya, akini kintu kimwe nakimanya, cheekuwa nikaona, na isasa naona!” ");
INSERT INTO bou_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aho wakamuuza, “Kakugosweea mbwai? Ayo meso yako kayagubua viivihi?” ");
INSERT INTO bou_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uyo mntu akawatambaisa, “Khiwamba kae na nywie khamwekunitegeeza, kwa mbwai mwakunda kutegeeza vituhu? Ivi, mwakunda na nywie mtende wahina wakwe?” ");
INSERT INTO bou_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Akini wowo waongoezi wa Wayahudi wakamdumua, wakamba, “Wee nawe ni mhina wakwe, akini swie ni wahina wa Musa. ");
INSERT INTO bou_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Swie tamanya kuwa Muungu kagombeka na Musa, akini mntu uyu khatimmanya kalawiiya kuhi.” ");
INSERT INTO bou_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naye akatambaisa, “Inu ni mbui ya kuhondomaza! Nywie khammanya kalawiiya kuhi, akini kanigubua meso yangu! ");
INSERT INTO bou_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tamanya kuwa Muungu khawategeeza wantu wenye mavigaviga, iya amtegeeza yoyose, mwenye hofu ya kumwogoha Muungu na kugosoa viya akundayo. ");
INSERT INTO bou_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuvokea aho bosi wa inusi, khatizati kutegeeza kuwa mntu kamhonya yoyose ekuwae tuntu. ");
INSERT INTO bou_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Inga mntu uyu kheekulawa kwa Muungu kheekuwa adahe kugosoa chochose.” ");
INSERT INTO bou_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wowo wakamtambaisa, “Wee kuvyaigwa na kweewa he mavigaviga wadaha viivihi kutihinya swie?” Aho wakamguusa he Nyumba ya kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ekusikiaho kuwa wamguusa mntu uyo he Nyumba ya kukintania Wayahudi, akaita kumuondeza. Kisingi ekumbwiiaho akamuuza, akamba “Ivi wee wamzumiiya Mwana wa Mntu?” ");
INSERT INTO bou_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uyo mntu akamtambaisa, “Mkuu nambiya ni ndai, nidahe kumzumiiya.” ");
INSERT INTO bou_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu akamwamba, “Kumwona kae na nee agombekae nawe isasa.” ");
INSERT INTO bou_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aho uyo mntu akamba, “Zumbe, Nazumiiya” akamkintia mavindi na kumvikia. ");
INSERT INTO bou_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu akamba, “Miye ncheza mwe inusi kwaajii ya kuwekha sugusa wantu, ili wantu wada wesaokuona wadahe kuona na wamamaakhanyao waona, wesekudaha kuona.” ");
INSERT INTO bou_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wamwe wa Mafalisayo wekuwao hamwe nae, nee wasikia mbui izo wakamuuza, “Tambe swie ni matuntu?” ");
INSERT INTO bou_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akawatambaisa, “Ati nee nimatuntu, neekhamwekuwa na mavigaviga, akini isasa nywie mwamba, ‘Swie taona,’ na iyo yaonyesha ati mke na masa.” ");
INSERT INTO bou_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu akawamba, “Nawamba ukwei, yoyose yuda mwesaekwengia mwe dewa da ngoto kwa kwembokea he uvi, iya ahenya na kwengia sia ntuhu, uyo ni mbavi na mhokaji. ");
INSERT INTO bou_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Akini mwengia kwa kwembokea he uvi wa dewa, uyo nee muisi wa ngoto. ");
INSERT INTO bou_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mgoji wa dewa amvugwiiya, na ngoto ava mgutio wakwe, na awetanga ngoto zakwe kia yumwe kwa zina dakwe, na kuwalavya chongoi. ");
INSERT INTO bou_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akabinda kuwalavya chongoi, aziongweeya na awo ngoto wamtongea, kwaviya waumanya mgutio wakwe. ");
INSERT INTO bou_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngoto izo khazidaha kutongea muisi mgeni, iya wendawamguuke kwaviya khawamanya mgutio wakwe.” ");
INSERT INTO bou_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu akawamba msimo uwo akini wowo khawekumanya ekukundavyo kuwamba. ");
INSERT INTO bou_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu akagombeka vituhu, “Kwei nawamba, miye ni uvi wa ngoto. ");
INSERT INTO bou_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wada watuhu wose wekuniongweeao miye ni wabavi na wahokaji, akini ngoto khawekuwategeeza. ");
INSERT INTO bou_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miye ni inga uvi, mntu yoyose mwengia kwembokea kwangu endaaoholwe, endaengiye na kulawa chongoi na endaapate kia akundacho. ");
INSERT INTO bou_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbavi eza kwa kuondeza kubawa na kukoma, na kubananga. Miye ncheza ili muwe na ugima, naho wawe nao mwingi. ");
INSERT INTO bou_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Miye ni muisi yedi. Muisi yedi ni yuda azumiiyae kuulavya ugima wakwe kwaajii ya ngoto zakwe. ");
INSERT INTO bou_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mntu agosoae ndima ya kibauwa cha kuisa ngoto ili ekhigwe hea naho ngoto khio mai yakwe, aonaho kui da mzituni dikeza, abada ngoto na kuguuka, naho kui da mzituni dawagwiya na kuwamwaganisa. ");
INSERT INTO bou_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yee khapatiiza kintu kuusu ngoto, kwaviya yee ni mkibauwa apatiiza kuihwa hea. ");
INSERT INTO bou_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miye ni muisi yedi wada wakwangu nawamanya, na wakwangu wanimanya. ");
INSERT INTO bou_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Inga Tate animanyavyo, ivyoivyo na miye nammanya Tate, miye nazumiiya ata kuulavya ugima wangu ili ngoto wasekwaga. ");
INSERT INTO bou_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naho ninao ngoto watuhu, awo khawamo mwe dewa dangu, awo nakundigwa kuwaeta, naho wenda wategeeze mgutio wangu, kwenda kuwe na tintimo dimwe na muisi yumwe. ");
INSERT INTO bou_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tate anikundisa kwaviya miye mwenye naulavya ugima wangu, ili nidahe kuwa na ugima vituhu. ");
INSERT INTO bou_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Khahana mntu mnihoka ugima wangu, miye naulavya kwa kukunda kwangu mwenye. Ninao udaho wa kuulavya na udaho wa kuudoa vituhu, mwiko unu nee Tate ekunigombekavyo nigosoe.” ");
INSERT INTO bou_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wekusikiaho mbui izo kukalawiiya kwepanga vituhu gatigati ya Wayahudi. ");
INSERT INTO bou_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wangi wao wakamba, “Ana zaiko uyu, naho ni mkiau! Kwa mbwai kumtegeeza?” ");
INSERT INTO bou_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wantu watuhu wakamba, “Izi khizo mbui za mntu mwenye zaiko, kwaani zaiko dadaha kugubua meso ya matuntu?” ");
INSERT INTO bou_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uko Yelusalemu nee kuwa na sikukhuu ya kuvugua Nyumba ya Muungu, kisingi icho kiwa cha pheho. ");
INSERT INTO bou_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu nae kawa akenda he Nyumba ya Muungu he ukumbi wa Selemani. ");
INSERT INTO bou_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wayahudi wakamuikia bunga wakamuuza, “Watibada mwemamaakhanyi adi ini? Ati wee ni Klistu isasa tambie ukwei.” ");
INSERT INTO bou_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu akawatambaisa, “Khiwagombeka kae akini khamwekuzumiiya, ndima nizigosoazo ni kwa udaho wa zina da Tate yangu zanivuhuzia. ");
INSERT INTO bou_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Akini nywie khamzumiiya, kwaivyo nywie khio ngoto zangu. ");
INSERT INTO bou_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngoto zangu zategeeza mgutio wangu, miye nawamanya, nawo wanitongea. ");
INSERT INTO bou_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miye nawekha ugima wa misi yose kwesiho kisiikizi, naho khawana wage kisingi chose, wala khahana mntu mdaha kuwadoa kulawa hangu. ");
INSERT INTO bou_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate yangu nee mwekunekha awo, ni mkuu kusima wose, naho khahana mntu mdaha kuwadoa he mikono ya Tate. ");
INSERT INTO bou_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miye na Tate ni kintu kimwe.” ");
INSERT INTO bou_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wayahudi wakadoa maiwe wamtambikie ili wamkome. ");
INSERT INTO bou_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu akawamba, “Khiwaonyesha ndima nyingi zilawazo kwa Tate, ni kihi icho kimiekacho mnitoe maiwe?” ");
INSERT INTO bou_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahudi wakamtambaisa, “Khatikutoa maiwe kwaajii ya ndima ntana, iya ni kwa kumkufuu Muungu! Kwaviya wetenda u Muungu ikawa wee ni mntu du inga wantu watuhu.” ");
INSERT INTO bou_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akawatambaisa, “Iyandikwa mwe miagiiyo yenu kuwa, Muungu kagombeka, ‘Nywie ni miuungu.’ ");
INSERT INTO bou_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Muungu kawetanga miuungu wada wekwekhigwao mbui zakwe, tamanya kuwa Maandiko ya Muungu yagombeka ukwei misi yose. ");
INSERT INTO bou_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ivi, mwadaha viivihi kumwamba yuda ambae Tate akamuika kwaajii ya ndima yakwe na kumwagiiya mwe inusi adumuwa? Ivi ni kwaviya khigombeka miye ni Mwana wa Muungu? ");
INSERT INTO bou_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Inga khigosoa ndima za Tate yangu, msekunizumiiya. ");
INSERT INTO bou_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Akini ati nazigosoa ndima za Tate yangu, ata inga khamnizumiiya, naho zizumiieni ndima izo, ili mdahe kummanya kuwa Tate yuumu mwangu na miye niumo mwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wakageeza vituhu kumgwiya, akini akahauka gatigati yao. ");
INSERT INTO bou_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu akaita khandakhanda ya zigizigi da mazi ya Yolodani, hantu Yohana ekubatiizaho, akekaa uko. ");
INSERT INTO bou_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wantu wangi wakambasa wakamba, “Yohana kheekugosoa ntangio yoyose, akini mbui zose za Yesu zia ekugombekazo Yohana neziwa za kwei.” ");
INSERT INTO bou_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wantu wangi wekuwaho hantu hada, wakamzumiia Yesu. ");
INSERT INTO bou_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mntu yumwe etangwae Lazalo, mwenyezi wa Besania, nekawa mtamu. Mntu uyo neakekaa mwe phaamo ya Besania ekuwayo akekaa Maliamu na umbude da Yesu. ");
INSERT INTO bou_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliamu nee yuda mwekumsisa Zumbe mavuta ya mzingo mtana na kumhangusa kwa fii zakwe, Lazalo, kakie nee mwekua mtamu. ");
INSERT INTO bou_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ivyo awo waumbude Lazalo, Malia na Masa wakaagiiya mbui inu kwa Yesu “Zumbe, mbuyayo umkundisae ni mtamu.” ");
INSERT INTO bou_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu ekusikiaho ivyo akamba, “Utamu unu khio wa ufe iya wendauwatende wantu wamtogoe Muungu na kwa sia iyo, Mwana wa Muungu viyaviya endaatogolwe.” ");
INSERT INTO bou_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kawakundisa muno Masa na Malia maumbude da na Lazalo. ");
INSERT INTO bou_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu ekwembigwaho Lazalo ni mtamu, Yesu akaendeea kwekaa hantu aho ekuaho kwa misi miidi. ");
INSERT INTO bou_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Naho akawamba wahina wakwe, “Titeni vituhu mwe si ya Yudea.” ");
INSERT INTO bou_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wahina wakwe wakamwamba, “Mhinyi! Kisingi kijihi chekwembokacho tangia Wayahudi wekukundaho kukukoma kwa maiwe, nawe waonda ukuite uko vituhu?” ");
INSERT INTO bou_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akawamba, “Ivi saa za musi khio kumi dimwe na mbii? Naho mntu akenda musi khadaha kwekungwaa kwaviya aona ung'azi wa zua mwe inusi. ");
INSERT INTO bou_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Akini mntu akenda na kio, ekungwaa kwaviya ung'azi khaumo umo mwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu ekubindaho kugombeka mbui izo, akawamba, “Mmbuya wetu Lazalo kagona akini miye naita nikamwenue.” ");
INSERT INTO bou_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wahina wakwe wakamwamba, “Zumbe, inga kagona usisiza, endaenuke.” ");
INSERT INTO bou_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wowo wamamakhanya kuwa kagona usisiza, akini Yesu kamanya kae ati Lazalo kauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu akawamba pwii, “Lazalo kauya na nyuma, ");
INSERT INTO bou_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","akini natamiwa kwaviya nchekuwa uko ekuuyaho na nyuma Lazalo, ili mdahe kunizumiiya, aya titeni kwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaso yuda mwetangwa phasa akawamba wahina weziwe “Titeni na swie tiuye na nyuma hamwe nae!” ");
INSERT INTO bou_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu ekubuaho uko, akabwiiya Lazalo kagewa kae mwe mbiya kwa misi mine. ");
INSERT INTO bou_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Phaamo ya Besania neiwa hehi, na Yelusalemu uhae ubuwao kilomita ntatu. ");
INSERT INTO bou_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wayahudi wangi waita kwa Masa na Malia kuwahongeza kwa ufe wa kaka yao. ");
INSERT INTO bou_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Naho Masa ekusikiaho Yesu eza, akenda kumhachiiza, akini Malia kasigaa kaya. ");
INSERT INTO bou_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Masa akamwamba Yesu, “Zumbe ati nekuwa aha, kaka yangu kheekuwa auye na nyuma. ");
INSERT INTO bou_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Akini namanya isasa chochose wendacho umuombeze Muungu, endaakwekhe.” ");
INSERT INTO bou_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu akamwamba, “Kakio endaayuyuke na kuwa mgima vituhu.” ");
INSERT INTO bou_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Masa akatambaisa “Namanya endaayuyuke kisingi wantu wendaho wayuyuswe, msi wa kisiikizi.” ");
INSERT INTO bou_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu akamwamba, “Miye nee niwayuyusae wantu na kuwekha ugima na mntu yoyose anizumiiyae ata inga kauya na nyuma, endaawe na ugima. ");
INSERT INTO bou_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na mntu yoyose ekaae na kunizumiiya kisingi chose khana auye na nyuma katu, ivi wayazumiiya ayo?” ");
INSERT INTO bou_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Masa akamtambaisa, “Eehe Zumbe miye nazumiiya ati wee nee Klistu Mwana wa Muungu yuda ezae mwe inusi.” ");
INSERT INTO bou_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ekugombekayo ayo, Masa akenda kumwetanga Malia umbude, akampokosa he ikedu, “Mhinyi yuaha akwetanga.” ");
INSERT INTO bou_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliamu ekusikiaho ayo, akenuka kinyio akambasa Yesu. ");
INSERT INTO bou_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nee khazati kwengia mwe phaamo akini kawa hadahada Masa ekumhokeaho. ");
INSERT INTO bou_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aho, Wayahudi wekuwao hamwe na Malia kwa kumhongeza wamwona enuka na kulawa chongoi kinyio wakambasa, wakimamaakhanya kuwa enda kuiya kwe mbiya. ");
INSERT INTO bou_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Naho Malia ekubuaho hantu Yesu ekuaho nakumuona, akakinta mavindi akamwamba “Zumbe inga nekuwa aha kaka yangu kheekuwa akauya na nyuma.” ");
INSERT INTO bou_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ekumuonaho aiya, wada wayahudi wekwezao hamwe naye wose wakaiya, akengiwa ni mbazi na kugwidukwa moyo. ");
INSERT INTO bou_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu akawauza “Mmwika hahi?” Wakamtambaisa, “Zumbe soo ukauwe.” ");
INSERT INTO bou_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu nee aiya. ");
INSERT INTO bou_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wayahudi wakamba, “Kauwani ekumkundisavyo Lazalo!” ");
INSERT INTO bou_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wantu watuhu wakamba, “Ivi nee yuda mwekumgubua meso yuda tuntu? Isasa khekudaha kumtenda Lazalo asekuuya na nyuma?” ");
INSERT INTO bou_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Naho Yesu akawa na usungu vituhu mwe moyo wakwe, akaita he mbiya. Mbiya denye nediwa phanga, nado digubikwa kwa iwe kuu. ");
INSERT INTO bou_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu akawamba, “Usani ido iwe!” Masa umbude da uyo mwekuuya na nyuma akamtambaisa Zumbe, “Kwaviya kekaa mwe mbiya misi mine isasa kavoka kae kunukha!” ");
INSERT INTO bou_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu akawamba, “Ivi ncheekukwamba inga ukanizumiiya wendauuone ukuu wa Muungu?” ");
INSERT INTO bou_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wakadiusa dia iwe, Yesu akakauwa uwanga kwa Muungu akamba, “Nakutogoa Tate kwaviya wanitegeeza uviki wangu. ");
INSERT INTO bou_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Namanya inga wanitegeeza kia msi, akini nagombeka aya kwaajii ya wantu awa weaha wadahe kuzumiia ati wee nee mwekuniagiiya” ");
INSERT INTO bou_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ekubindaho kugombeka ayo, aketanga kwa mgutio mkuu “Lazalo, lawa chongoi!” ");
INSERT INTO bou_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazalo akalawa chongoi, uku kazengetezwa sanda mwe mwii wakwe, miundi na mikono ifungwa na cheni chakwe kigubikwa leso, Yesu akamba, “Mchopoeni mmweeke aite.” ");
INSERT INTO bou_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ivyo wayahudi wangi wekwezaho kwa Malia yekuonaho mbui ida ekugosoayo Yesu wakamzumiia. ");
INSERT INTO bou_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Akini watuhu wakaita kwa Mafalisayo na kuwagombeka mbui ida ekugosoayo Yesu. ");
INSERT INTO bou_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwa ivyo, waviki wakuu na mafalisayo wakawetanga waongoezi wakuu wa Wayahudi wa mkonga na kugombeka “Titende viivihi? Mntu uyu agosoa ntangio nyingi. ");
INSERT INTO bou_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Inga tikamwekea aendeee, wantu wose wendawamzumiiye, na awo Walumi wendaweze waibanange Nyumba ya Muungu na kuwakoma wantu wa si yetu!” ");
INSERT INTO bou_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yumwe yawo etangwae Kayafa, yuda mwekuwa Mviki Mkuu kwa mwaka uda, akawagombeka “Nywie khammanya kintu! ");
INSERT INTO bou_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Khammanya ati ni vyedi kumkoma mntu yumwe kwaajii ya wantu, kusima wantu wose wa si ngima wadagamiye?” ");
INSERT INTO bou_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kheekugombeka akundavyo mwenye, kwaviya kawa Mviki Mkuu kisingi icho, nee kamanya Yesu endaauye na nyuma kwaajii ya si yawo, ");
INSERT INTO bou_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na khio kwaajii ya si iyo ya Wayahudi iya ni kwaajii ya wantu wa Muungu wekumwaganikao ili kuwaeta hamwe na kuwatenda kuwa kintu kimwe. ");
INSERT INTO bou_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nee kuvokea msi uwo, waongoezi wa Kiyahudi wakaondeza kintu chendacho kiwatende wamkome Yesu. ");
INSERT INTO bou_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ivyo Yesu khekuita vituhu hemeso ya Wayahudi iya akalawa aho, akaita hehi na kiwawe, he mzi wetangwao Eflaimu, akekaa uko hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sikukhuu ya Wayahudi ya pasaka iwa hehi na wantu wangi wakaita Yelusalemu wadahe wezingue hemeso ya Muungu kabla ya sikukhuu iyo. ");
INSERT INTO bou_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wantu nee wakamuondeza Yesu, nawo wekukintanaho hantu he Nyumba ya Muungu wakauzana, “Ivi mntu uyu khanaeze he sikukhuu?” ");
INSERT INTO bou_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Waviki wakuu na Mafalisayo nee walavya miko kuwa mntu akamanya hantu Yesu eiho, awatonye wadahe kumgwiya. ");
INSERT INTO bou_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Misi mtandatu nee khaizati sikukhuu ya Pasaka, Yesu akaita Besania ekuwako akekaa Lazalo, yuda ambae Yesu ekumyuyusaye. ");
INSERT INTO bou_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uko wakamuiikia khande ya guoni, Masa nee mwekuwa akawagosweea ndima, na Lazalo kawa yumwe wa wada wekuwao wekaa hamwe na Yesu. ");
INSERT INTO bou_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aho, Malia akadoa hindi ya mavuta ya mzingo mtana yekugosolwayo na nalido na ya yombe khuu, akamwetiiya Yesu mwe miundi na kumhangusa kwa fii zakwe, nyumba yose ikamema mzingo mtana wa mavuta. ");
INSERT INTO bou_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda wa Isikaliote, yumwe wa wada wahina kumi dimwe na mbii nauyo nee mwenda amhituke Yesu akamba, ");
INSERT INTO bou_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwa mbwai ayo mavuta yenye mzingo mtana yasekutagwa kwaviya nee tikadaha kupata hea za kuiha mtu maiho yakwe ya mwaka mgima na hea iyo tikawekha wakiwa?” ");
INSERT INTO bou_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kagombeka ivyo, khio kwa kuwaonea mbazi wakiwa, iya kwaajii yee nekawa na mkwiji wa hea na nee mbavi. Maa kwa maa nee akadoa hea na kuzida ikedu. ");
INSERT INTO bou_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Naho Yesu akagombeka, “Mwesekumpisha mvyee uyu! Kwaviya kanetiiya mavuta aya kwaajii ya msi wangu wa kugewa mwe mbiya. ");
INSERT INTO bou_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wakiwa mnawo misi yose, akini miye khamna muwe nami misi yose.” ");
INSERT INTO bou_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi wangi wasikia Yesu kawa Besania, ivyo wakaita uko khio kwaajii ya Yesu iya kumuona Lazalo yuda ekuyuyuswae na Yesu. ");
INSERT INTO bou_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Viyaviya waviki wakuu wakagosoa nteganyi ya kumkoma Lazalo, ");
INSERT INTO bou_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwaajii ya kuyuyuswa kwa Lazalo, Wayahudi wangi wakawahituka waongoezi wao, wakamzumiia Yesu. ");
INSERT INTO bou_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kioi dakwe zumwezumwe khuu da wantu wakeza kwe sikukhuu, wasikia Yesu kawa siai eza Yelusalemu. ");
INSERT INTO bou_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nee wadoa matambi ya mitende madodo dodo, wakalawa kwa kumhachiiza, wakatoa mgutio wakamba, “Ntunyo! Ajaiwe uyo mweza kwa udaho wa zina da Zumbe, ajaiwe Seuta wa Isilaeli!” ");
INSERT INTO bou_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu nekapata mwanaphunda akamkwea uwanga inga viya yekuandikwavyo mwe Maandiko ya Muungu, ");
INSERT INTO bou_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mwesekuogoha ee wantu wa mzi wa Sayuni! Kauwa Seuta wenu eza, Kakwea mwana phunda.” ");
INSERT INTO bou_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kisingi icho wahina wakwe khawekuzimanya mbui izo, akini Yesu ekutogolwaho, nee wakumbuka Maandiko yekuandikwayo uwanga yakwe na wantu wamgosweeya ivyo. ");
INSERT INTO bou_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Zumwezumwe da wantu wekuwao hamwe na Yesu kisingi ekumwetangaho Lazalo kulawa mwe mbiya, na kamyuyusa kulawa kwa wekufao nee wa mvuhuzia. ");
INSERT INTO bou_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwa ivyo zumwezumwe ido da wantu, wakamhachiiza kwaviya wose wasikia ntangio iyo, kuwa Yesu kamyuyusa Lazalo. ");
INSERT INTO bou_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafalisayo wakaambizana “Mwaona khatidaha kugosoa chochose vituhu! Kauwani inusi ngima wantu wose wamtongea yee!” ");
INSERT INTO bou_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nekuwa na Wagiiki wekuawo wabua Yelusalemu kuvika kisingi cha sikukhuu ya pasaka. ");
INSERT INTO bou_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Awo wakamtimia Fiipo mwenyezi wa Betisaida wa mzi wa Galilaya, wakamba, “Mkuu taombeza kumwona Yesu.” ");
INSERT INTO bou_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fiipo akaita akamwamba Andulea, aho wose waidi wakaita kumwamba Yesu. ");
INSERT INTO bou_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akawamba, “Saa ya kutogolwa muno miye Mwana wa Mntu ibua. ");
INSERT INTO bou_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nawamba ukwei, mbeyu ya ngano yasigaa mbeyu ikesekugwa, akini ikagwa ahosi na kufa, ati ikafa, aho yavyaa matunda mangi. ");
INSERT INTO bou_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mntu yoyose akundisae ugima wakwe endaawaze, akimae ugima wakwe mwe inusi, endaauike kwaajii ya ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mntu akundae kunigosweeya ndima akundigwa anitongee, ili awe na miye kia hantu niitako, viyaviya mntu akanigosoeya ndima, Tate yangu endaamwekhe ntunyo. ");
INSERT INTO bou_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Isasa moyo wangu wasuumia muno, nigombeke mbwai? Ivi nigombeke, ‘Tate, nakuombeza unihonye kisingi iki cha masuumizo?’ Khivyo khidaha kugombeka akini ni kwaajii ya ayo nee kiekacho nibwiiye mda unu. ");
INSERT INTO bou_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, uditogoe zina dako!” Aho ukalawa mgutio kulawa uwanga kwa Muungu ukamba, “Khiditogoa zina dako na nendaniditogoe vituhu.” ");
INSERT INTO bou_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Akini zumwezumwe da wantu wekuwao hantu hada wasikia mgutio uwo, nawo wakagombeka, uwo ni mgutio wa tuntumo, na wantu watuhu wakamba, “Mndima wa uwanga kwa Muungu katamwiiya na Yesu!” ");
INSERT INTO bou_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu akawamba, “Mgutio uwo utegeezeka khio kwaajii yangu, iya ni kwaajii nywie mumzumiiye Muungu. ");
INSERT INTO bou_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Isasa ni kisingi cha inusi kuamuiiwa, mkuu wa mwe inusi endaasigwe chongoi. ");
INSERT INTO bou_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nendaho nenulwe uwanga kulawa mwe inusi, nendaniwetange kia yumwe eze kwangu.” ");
INSERT INTO bou_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kwa kugombeka ivyo, Yesu kamanya endaauye na nyuma viivihi. ");
INSERT INTO bou_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Naho zumwezumwe ido dikamtambaisa, “Swie tisoma mwe Miagiiyo kuwa uyo Klistu endaekae kisingi chose kwesiho kisiikizi, wadaha viivihi kugombeka Mwana wa Mntu akundigwa enulwe? Uyo Mwana wa Mntu ni ndai?” ");
INSERT INTO bou_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu akawamba, “Un'gazi wendauwe na nywie kwa mda mjihi, endani mke na uwo un'gazi ili kiza kisekuwavota, kwaviya endae na kiza khamanya aitako. ");
INSERT INTO bou_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kisingi mke na uwo ung'azi, uzumiiye ili mdahe kuwa wantu wa ung'azi.” Yesu ekugombekaho mbui izo akenda kwefisa hae nawo. ");
INSERT INTO bou_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Etiho Yesu kagosoa ntangio vyose hemeso yawo, wowo khawekumzumiiya, ");
INSERT INTO bou_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Inu neiwa ili kuiganiza ida mbui yekugombekwayo na Muoni wa Muungu Isaya, “Zumbe ni ndai mwekuzumiia mbui zetu? Naho Zumbe kumgubuiya ndai udaho wakwe?” ");
INSERT INTO bou_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ivyo khawekudaha kumzumiia Yesu, kwaviya Muungu kagombeka hantu hatuhu kwembokea muoni yakwe Isaya, ");
INSERT INTO bou_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Muungu kawatenda wasekuona, Kawatenda wasekuva kwa mioyo yao, Wasekukauwa kwa meso yawo, Wasekumanya kwa akii zawo, Naho wasekunihitukia, Ili nidahe kuwahonya, agombeka Zumbe.” ");
INSERT INTO bou_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kagombeka mbui izi kwaajii ya ukuu uwo wa Yesu, akamba mbui zakwe. ");
INSERT INTO bou_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na ivyo waongoezi wangi wa kiyahudi wamzumiiya Yesu, akini khawekugombeka pwii kuwa wamzumiiya kwa kuogoha kuguuswa mwe Nyumba ya kukintania Wayahudi. ");
INSERT INTO bou_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Waongoezi awo wa Wayahudi nee wakakundisa muno kutunywa ni wantu kusima kutunywa na Muungu. ");
INSERT INTO bou_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naho Yesu akagombeka kwa mgutio mkuu, “Mntu mnizumiiya miye, khanizumiiya miye du, iya amzumiiya viyaviya yuda mwekunigiiya. ");
INSERT INTO bou_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mwekuniona miye kamuona yuda mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miye ni ung'azi, nami ncheza mwe inusi, ili wose wamzumiiao wasekusigaa mwe kiza. ");
INSERT INTO bou_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mntu yoyose ategeezae mbui zangu akini khazitozeeza, miye khinanimuamwiiye, mana ncheekweza kwaajii ya kuamuiiya inusi iya kuiohoa. ");
INSERT INTO bou_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akini wose wekuniemeao miye na kuemea mbui yangu, wendawaamuiwe mwe msi uda wa kisiikizi, kwa mbui ya kwei nekugombekayo. ");
INSERT INTO bou_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Miye ncheekugombeka kwa mwiko wangu mwenye iya khigombeka yada ekunekhayo Tate. ");
INSERT INTO bou_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Miye namanya miko yakwe yaeta ugima wa misi yose kwesiho kisiikizi. Miye nagombeka du yada Tate ekuniagiiyao niyagombeke.” ");
INSERT INTO bou_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Neiwa msi nee khaizati kubua sikukhuu ya Pasaka. Yesu akamanya mda wakwe wa kuhauka mwe inusi kuita kwa Tate nee ubua kae. Nee kawakundisa misi yose wantu wakwe wekaao mwe inusi, naho nee kawakundisa muno kwesiho mihaka. ");
INSERT INTO bou_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nee Yesu na wahina wakwe wawa wekaa kuda khande ya guoni, Ibiisi kamgeya kae Yuda mwana wa Simoni Isikaliote moyo wa kumhituka Yesu. ");
INSERT INTO bou_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu akamanya kuwa Tate kaika vintu vyose asi ya udaho wakwe, na kuwa nee kalawa kwa Muungu na endaagotoke kwa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aho Yesu akagooka, akaika khandai gwanda dakwe da chongoi, akadoa ntii kitambaa na kwefunga mwe kigudi. ");
INSERT INTO bou_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Naho, akagea mazi mwe wiga, akavoka kuwasunta wahina wakwe miundi na kuihangusa kwa kitambaa ekwefungacho mwe kigudi. ");
INSERT INTO bou_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aho, akamtimia Simoni Petulo, nae Petulo akamba, “Zumbe wee wendaunisunte miundi miye?” ");
INSERT INTO bou_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akamtambaisa, “Khumanya nigosoacho isasa, akini wendaumanye kisingi chezaho.” ");
INSERT INTO bou_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo akamwamba Yesu, “Wee khunaunisunte miundi katu.” Yesu akamtambaisa, “Nikesekukusunta khaunauwe yumwe wa wantu wangu kisingi chose.” ");
INSERT INTO bou_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo akamtambaisa, “Zumbe nisunta, khio miundi du, ata na mikono yangu na viyaviya mtwi.” ");
INSERT INTO bou_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu akamwamba, “Mwekwehaka kae mazi khakundigwa kwehaka vituhu, iya akundigwa kusunta miundi du kwaviya kang'aa mwii wose, nywie mng'aa akini khio nyose.” ");
INSERT INTO bou_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu akamanya yuda endaeamhituke nee mana kagombeka, “Nywie msuntika, akini khio nyose.” ");
INSERT INTO bou_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ekubindaho kuwasunta miundi na kwehasika vituhu gwanda dakwe, akekaa he meza hantu hakwe, akawauza, “Ivi mniva ivyo nekuwagosoeacho?” ");
INSERT INTO bou_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nywie mwanetanga Mhinyi na Zumbe, nanywi mwagombeka vyedi, kwaajii ni miye. ");
INSERT INTO bou_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naho, ikawa miye Zumbe na mhinyi khimisunta miundi, nywie nanywi mwakundigwa mgosoeane ivyo. ");
INSERT INTO bou_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Khiwekha msimo unu, ili nanywi mgosoe inga nekuwagosweeavyo. ");
INSERT INTO bou_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nawagombeka ukwei, mndima khio mkuu kusima mkuu yakwe, wala mwagiiwa khio mkuu kusima yuda mwekumuagiiya. ");
INSERT INTO bou_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Naho, ikawa mwayamanya ayo, mwendamjaiwe. ");
INSERT INTO bou_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aya nigombekayo ni kwa nywie nyose, miye nawamanya wada nekuwasaguwao. Akini yakundigwa yaiganie Maandiko ya Muungu yagombekavyo, ‘Yuda mwekuda khande hamwe na miye kanihituka.’ ");
INSERT INTO bou_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Miye nawamba mbui izi isasa umo khayazati kulawiiya, ili yalawiaho mdahe kuzumiia kuwa, ‘Miye Nee Uyo.’ ");
INSERT INTO bou_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nawamba ukwei, amuhokeae yuda nimuagiiye anihokea miye, na anihokeae miye amhokea yuda mwekuniagiiya.” ");
INSERT INTO bou_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu ekugombekaho ayo, moyo ukamuuma, akagombeka pwii, “Nawamba kwei, yumwe yenu endaanihituke.” ");
INSERT INTO bou_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wahina wakwe wakakauwana, kwaviya khawekumanya amgombeka ndai. ");
INSERT INTO bou_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mhina yumwe yuda Yesu ekuae amkundisa muno, nee kekaa hehi na Yesu. ");
INSERT INTO bou_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo akamhungia mkono na kumwonyesha utangio, na kugombeka, “Muuze amgombeka ni ndai.” ");
INSERT INTO bou_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mhina uyo akesogeza hehi na Yesu akamuuza, “Zumbe ni ndai?” ");
INSERT INTO bou_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu akamtambaisa, “Yuda nendaenimwekhe kibendu cha bumunda, nekukigintacho mwe wiga, nee uyo.” Akadoa kibendu cha bumunda, akakiginta mwe wiga, akamwekha Yuda mwana wa Simoni wa Isikaliote. ");
INSERT INTO bou_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda wa Isikaliote ekubindaho kuhokea kia kibendu cha bumunda Ibilisi akamwengiya. Aho Yesu akamwamba, “Ukundacho kukigosoa kigosoe kinyio.” ");
INSERT INTO bou_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Akini khakuna katu yumwe wa wada wekwekaao he meza mwekumanya kwa mbwai kagombeka ivyo. ");
INSERT INTO bou_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwaviya Yuda kawa mwiika hea, watuhu wakamamakhanya, Yesu kamwamba ague vyekukundigwavyo mwe sikukhuu, hambu kamwamba alavye chochose kwa wakiwa. ");
INSERT INTO bou_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda wa Isikaliote ekuhokeaho kia kibendu cha bumunda, akalawa chongoi kinyio, neiwa kiza. ");
INSERT INTO bou_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Naho Yuda kisingi kalawa chongoi, Yesu akawamba wahina wakwe akagombeka, “Isasa ukuu wangu miye Mwana wa Mntu uhehi kuoneka pwii. Naho wendauoneke pwii ukuu wa Muungu kwembokea mwe ntendwa zangu. ");
INSERT INTO bou_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mwana endaawaonyeshe wantu, Muungu ekuwavyo mkuu, naho Muungu endaawaonyeshe wantu viya Mwana ekuwavyo mkuu. ");
INSERT INTO bou_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu nikeaho na nywie kwa mda mjihi du. Mwendamniondeze akini isasa nawamba yada nekuwagombekayo waongoezi wa Kiyahudi, ‘Niitako nywie khamdaha kuita.’ ");
INSERT INTO bou_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nawekha mwiko mhya, kundisaneni inga viya niwakundisavyo nywie, na nywie kundisaneni. ");
INSERT INTO bou_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mkakundisana, wantu wose wendawamanye nywie ni wahina wangu.” ");
INSERT INTO bou_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo akamuuza, “Waita kuhi?” Yesu akatambaisa, “Niitako khudaha kunitongea isasa, akini wendaunitongee kisingi chezacho.” ");
INSERT INTO bou_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo akamwamba, “Kwambwai isasa khidaha kukutongea? Ntayali kuuya na nyuma kwaajii yako.” ");
INSERT INTO bou_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu akamtambaisa, “Ivi kwei wadaha kuuya na nyuma kwaajii yangu? Nakwamba zogoo khadizati kukema, wendauniemee maa ntatu.” ");
INSERT INTO bou_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu akawamba, “Mwesekugwidukwa mwe mioyo yenu, mwamzumiiya Muungu, mnizumiie na miye viyaviya. ");
INSERT INTO bou_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kaya mwa Tate yangu mna vyekao vingi, ati nee khayekuwa ivyo nee khiwamba kae, isasa naita kuwaikia hakwekaa. ");
INSERT INTO bou_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nikaita kuwaikia hantu ha kwekaa, nendaniuye niwadoe na nywie muwe hada neiho. ");
INSERT INTO bou_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sia ya kuita uko, nywie mwaimanya.” ");
INSERT INTO bou_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso akamuuza, “Zumbe uitako khatikumanya, tadaha vivihi kuimanya iyo sia?” ");
INSERT INTO bou_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu akatambaisa, “Miye ni sia na kwei na ugima, khahana mntu adahae kuita kwa Tate kwesiho kwembokea kwa miye. ");
INSERT INTO bou_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ati nee mwanimanya miye nee mkammanya na Tate yangu, kuvokea isasa mwammanya naho mmuona kae.” ");
INSERT INTO bou_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo akamwamba, “Zumbe Tionyeshe Tate du, na swie nee tikundacho!” ");
INSERT INTO bou_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akamtambaisa, “Nchekaa na nywie kisingi chose iki, nawe Filipo khauzati kunimanya? Mwekuniona miye kamuona Tate, wadaha viivihi kugombeka, ‘Tionyeshe Tate?’ ” ");
INSERT INTO bou_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ivi, khaunizumiiya ati miye niumo mwa Tate, nae Tate yuumu mwangu? Mbui niwagombekeazo khizigombeka inga nikundavyo miye, iya Tate mweumo mwangu agosoa ndima yakwe. ");
INSERT INTO bou_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwakundigwa mnizumiie nigombekayo miye niumo ndani ya Tate na Tate yuumu mwangu, inga khivyo, zumiiyani kwa ndima nizigosoazo. ");
INSERT INTO bou_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nawamba ukwei, anizumiiae endaagosoe mbui nizigosoazo miye, naho endaagosoe makuu muno kwaviya naita kwa Tate. ");
INSERT INTO bou_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chochose muombezacho kwa zina dangu ido nendanigosoe, ili Tate atogolwe ekuwavyo mkuu kwembokea Mwanawe. ");
INSERT INTO bou_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chochose mniombezacho kwa udaho wa zina dangu nendanimigoswee. ");
INSERT INTO bou_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Inga nee mkanikundisa mwenda mtoze miko yangu. ");
INSERT INTO bou_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nendanimuombeze Tate, nae endaawekhe mwaambiza mtuhu endaeekae na nywie kisingi chose. ");
INSERT INTO bou_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Muye unu endaawagubuie wantu ukwei. Wantu wa inusi ambao wamuemea Muungu khawadaha kumhokea Muye uyo, kwaajii khawamuona naho khawammanya, akini nywie mwammanya Muye wa Muungu, kwaajii ekaa hamwe na nywie naho endaawe ndani yenu.” ");
INSERT INTO bou_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Khinanimibade nywie ikedu, nendaneze vituhu kwenu. ");
INSERT INTO bou_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hasigaa hadodo wantu wa mwe inusi khawana wanione vituhu, akini nywie mwendamnione kwaviya miye ni mgima, na nywie nanywi mwendamuwe wagima.” ");
INSERT INTO bou_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Msi uda wendaho ubue, mwendammanye miye niumo mwa Tate, na nywie muumo mwangu na miye viyaviya niumo mwenu. ");
INSERT INTO bou_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yuda ahokeao miko yangu na kuitongea, yee nee mnikundisa. Anikundisae miye endaakundwe ni Tate yangu, na miye nendanimkundise na nendanimtende animanye.” ");
INSERT INTO bou_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, akini khio Yuda Isikaliote akamwamba, “Zumbe yendaidahike viivihi kutitenda swie tikumanye na khio wantu wa inusi wesaokukuzumiiya wee, wakumanye?” ");
INSERT INTO bou_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu akatambaisa, “Mntu yoyose anikundisae endaatoze mbui yangu na Tate yangu endaamkundise, miye na Tate tendateze kwakwe na kwekaa nae. ");
INSERT INTO bou_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mwesaekunikunda khatoza mbui zangu. Na mbui mwekutegeezayo khio yangu, iya ni yakwe Tate mwekuniagiiya.” ");
INSERT INTO bou_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nawamba mbui izi, nike hamwe na nywie. ");
INSERT INTO bou_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Akini uyo Mwaambizi, nee Muye wa Muungu ambae Tate endaamuagiiye kwenu kwa udaho wa zina dangu, endaawahinye kia kintu na kuwakumbusa yose nekugombekayo.” ");
INSERT INTO bou_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nawabadia uivanisi, ni uivanisi ulawao kwangu, khio uivanisi inga uda ulawao kwa wantu wa inusi, ivyo mwesekwepisha mwe mioyo yenu, naho mwesekuogoha kintu chochose. ");
INSERT INTO bou_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mtegeeza kae, nikawamba, ‘Naita nikaukaaho nagotoka vituhu.’ ” Inga nee mkanikundisa, nee mkatamiwa kwaviya naita kwa Tate kwaviya yee ni mkuu kusima miye. ");
INSERT INTO bou_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nawamba aya isasa khayazati kulawiiya, aho yendaho yalawiiye, mdahe kuzumiia. ");
INSERT INTO bou_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Khinanigombeke na nywie vituhu, mbui nyingi mana mkuu wa inusi atimia kwangu, iya khana udaho kwangu. ");
INSERT INTO bou_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Akini wantu wa inusi wakundigwa kumanya inga namkundisa Tate, nee vyeekavyo nagosoa kia kintu inga Tate ekuniagiiyavyo. “Gookani tihauke aha.” ");
INSERT INTO bou_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu akagombeka “Miye ni mzabibu wa kwei, na Tate yangu nee muimi. ");
INSERT INTO bou_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kia tambi desado kuvyaa matunda yee adiusa, na kia tambi divyaado adisengeasengea didahe kuvyaa vitana. ");
INSERT INTO bou_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nywie msuntwa kae na msuntwa kwaajii ya mzumiiya mbui zangu. ");
INSERT INTO bou_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ekaani ndani yangu, nami nekae ndani yenu inga viya tambi desavyo kudaha ikedu kuvyaa matunda dikesekusigaa he mzabibu, ivyoivyo khamdaha kugosoa yada akundayo Muungu kwesiho kusigaa umu mwangu.” ");
INSERT INTO bou_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Miye ni mzabibu, na nywie ni matambi, ekaaye umu mwangu, na miye nekaa umo mwake, uyo avyaa matunda mangi, kwaviya kwesiho miye khamdaha kugosoa chochose. ");
INSERT INTO bou_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mntu yoyose mwesaekwekaa ndani yangu, atambikwa chongoi inga tambi ditambikwavyo chongoi, adi dinyae. Wantu wadidodoa tambi inga ido na kuditambika mwe moto dihye. ");
INSERT INTO bou_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mkekaa umu mwangu na mbui zangu zikekaa mwenu, ombezani chochose mkundacho nanywi mwendamwekhigwe. ");
INSERT INTO bou_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wantu wendawammanye Tate yangu endaatogolwe ekuwavyo mkuu inga mkagosoa mbui nyingi akundazo Muungu na mwendamuwe wahina wangu. ");
INSERT INTO bou_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Inga viya Tate ekunikundisavyo miye, ivyo ndiho miye nekuwakundavyo nywie, ekaeni kwa kuongoewa na ukundiso wangu. ");
INSERT INTO bou_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mkatoza miko yangu nendaniendee kuwakundisa, inga viya miye nekutozeezavyo miko ya Tate yangu ambae aendeea kunikundisa. ");
INSERT INTO bou_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nawamba mbui izi, nakunda nywie muwe na nyemi na miye, inga viya miye niwavyo na nyemi na nywie. ");
INSERT INTO bou_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inu nee miko yangu, kundisaneni inga nekumikundisavyo miye. ");
INSERT INTO bou_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sia khuu muno ya kuonyesha wawakundisa wambuya zako, ni kuuya na nyuma ili wowo wekae. ");
INSERT INTO bou_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nywie ni wambuya wangu mkagosoa niwaagiiavyo. ");
INSERT INTO bou_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nywie khinaniwetange wandima wangu vituhu, kwaviya mndima khamanya agosoado Zumbe yakwe, akini miye nawetanga nywie wambuya, kwaajii nawamba yose nekutegeezayo kulawa kwa Tate yangu. ");
INSERT INTO bou_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nywie khamwekunisagua miye, iya miye khiwasagua na kuwaagiiya muite mkavyae matunda yekaayo, naye Tate adahe kuwekha chochose mkiombezacho kwa zina dangu. ");
INSERT INTO bou_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Naho nawagiiya kia mntu na amkundise mwezie. ");
INSERT INTO bou_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Inga wantu wa mwe inusi wakawakima nywie, akini msekujaa idi, wowo wavoka kunikima miye. ");
INSERT INTO bou_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Inga nemuwa wantu wa inusi, inusi nee ikamikunda nywie inga wantu wakwe, Akini kwaviya nywie khio wa mwe inusi, iya miye khiwasagua kulawa mwe inusi inu, kwaajii inu wantu wa inusi wawakima. ");
INSERT INTO bou_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukani nekuwambiavyo, ‘Mtumwa khio mkuu kusima mkuu yakwe.’ Ikawa wanisuumiza miye wenda wamisuumize nywie naywi ati watoza mbui zangu, wendawatoze na da kwenu. ");
INSERT INTO bou_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Akini ayo yose wenda wamigoswee nywie kwaajii ya kunizumiiya miye, kwaviya khawammanya mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Inga nchekweza na kugombeka nawo nee khawekuwa na mavigaviga, akini isasa khawadaha kwevunia inga khawana mavigaviga. ");
INSERT INTO bou_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mnikima miye, viyaviya amkima Tate yangu. ");
INSERT INTO bou_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wesekuwa na mavigaviga inga nchekugosoa vihii gatigati yao, yada ambayo khahana mntu yoyose adahae kuyagosoa akini wowo waona yada nekuyagosoayo na wakanikima miye hamwe na Tate yangu. ");
INSERT INTO bou_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nee mana yada yekuandikwayo mwe miagiiyo yao ni kwei, ‘Wanikima buebue.’ ");
INSERT INTO bou_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nendanimwagiiye Muye wa Muungu alawaye kwa Tate, endaeawaonyeshe ukwei. Muye uyo wa Muungu endaawambize na kuwagombeka miye neivyo. ");
INSERT INTO bou_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na nywie nanywi mwenda mnigombekee, kwaviya muwa na miye kuvokea aho bosi. ");
INSERT INTO bou_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kiwamba ayo kwaviya msekueka kunizumiiya. ");
INSERT INTO bou_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wantu wendawamiguuse nywie he nyumba zawo za kukintania Wayahudi. Naho kisingi cheza kia endaeawakome nywie endaamamakhanye kuwa amgosoea ndima Muungu. ");
INSERT INTO bou_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wenda wamigoswee mbui izo kwaviya khawekummanya Tate naho khawekunimanya miye.” ");
INSERT INTO bou_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Akini khiwamba mbui izo ili mda wendahoubue kwa wowo kuwagosoea ayo, mwendamkumbuke kuwa khiwamba. Nchekuwamba mbui izo, kuvokea aho bosi, kwaviya khiwa hamwe na nywie. ");
INSERT INTO bou_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Akini isasa naita kwa yuda mwekuniagiiya na khahana katu mntu yumwe aniuzae, waita hahi? ");
INSERT INTO bou_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwaviya khiwamba mbui izo mmema usungu mwe mioyo yenu. ");
INSERT INTO bou_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Akini nawamba ukwei, ni vyedi kwenu miye nihauke, kwaviya nikesekuita mwambizi khanaeze kwenu, akini nikaita uko nendanimwaagiiye kwenu. ");
INSERT INTO bou_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nae endahoeze endaawaonyeshe wantu wa mwe inusi mbui ya mavigaviga, na kwa mbui ziya zimtamiazo Muungu na kwa mbui ya uwamuiiyo wa Muungu. ");
INSERT INTO bou_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Waga kwa mbui za mavigaviga kwaajii khawanizumiiya miye, ");
INSERT INTO bou_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mwe mbui ya kumtamiza Muungu, miye khigosoa yamtamizayo Muungu nee mana naita kwa Tate, nanywi khamna mnione vituhu. ");
INSERT INTO bou_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aonyesha pwii kuwa Muungu endaawaamuiye kwaajii kamuamuiya kae Shetani ambae ni muongoezi wa inusi. ");
INSERT INTO bou_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nina mangi ya kuwamba iya kwa isasa khamdaha kuyamanya yose. ");
INSERT INTO bou_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Akini endaho auye uyo Muye wa kwei endaawatende muimanye kwei yose ya Muungu, naho khana agombeke mbui zakwe mwenye, iya enda agombeke ekuyategeezayo na kugombeka yendayoyeze. ");
INSERT INTO bou_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yee endaawatende mnitunye, kwaajii endaawambe yada yose endayo apate kulawa kwangu. ");
INSERT INTO bou_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vyose enavyo Tate ni vyangu, nee vyekweekacho khigombeka kuwa Muye endaawambe yada yose yalawayo kwangu. ");
INSERT INTO bou_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kisingi kidodo khamnamnione, na bada ya kisingi kidodo vituhu mwendamnione.” ");
INSERT INTO bou_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aho wamwe wa wahina wakwe wakauzana, “Ambaze? Atambiaho, kusigaa kisingi kidodo khamna mnione na ikemboka kisingi kidodo vituhu mwendamnione? Naho amba, ‘kwaviya naita kwa Tate.’ ");
INSERT INTO bou_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aho wakaendeea kuuzana, ana mana yani, agombekaho, ‘Kusigaa kisingi kidodo?’ Khatimanya amba mbwai!” ");
INSERT INTO bou_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kamanya ati nee wakoondeza kumuuza, aho akawamba, “Ivi mwauzana kwa yada nekugombekayo, ‘Kusigaa kisingi kidodo nywie khamna mnione.’ Na ikemboka kisingi kidodo vituhu mwendamnione? ");
INSERT INTO bou_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nawamba ukwei, nywinywi mwendamwiiye na kuwa na bwaimbo, akini wantu wa inusi wendawawe na nyemi, mwendamuone usungu, akini usungu wenu wendauhituke uwe nyemi. ");
INSERT INTO bou_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Inga mvyee aita kuvyaa mwana, ana usungu kwaajii amanya kisingi chakwe cha maumevu makai kibuwa, akini akabinda kuvyaa mwana, khakumbuka vituhu maumevu ayo, kwaajii ya nyemi ya kuvyaigwa mwana mteke mwe inusi ibua. ");
INSERT INTO bou_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nanywi, isasa mna usungu, akini nendaniwezee vituhu, naho mwendammeme nyemi he miyoyo yenu na nyemi iyo khahana mntu mwendae aiyuse kwenu. ");
INSERT INTO bou_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Msi uwo khamna mniombeze chochose. Nawamba ukwei, chochose mwendacho mumuombeze Tate, kwa udaho wangu mwendamwekhigwe. ");
INSERT INTO bou_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Adi isasa khamzati kuombeza chochose kwa udaho wangu. Akini isasa ombezani nanywi mwenda mwekhigwe, ili muwe na nyemi muno. ");
INSERT INTO bou_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Khiwamba mbui izo kwa misimo, akini kisingi cheza ambaho khina nigombeke na nywie vituhu kwa misimo iya nendaniwambe pwii mbui za Tate. ");
INSERT INTO bou_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Msi uwo, mwendamuombeze kwa udaho wangu na khinaniwambe ati nendanimuombeze Tate kwaajii yenu, ");
INSERT INTO bou_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yee mwenye Tate awakundisa nywie, kwaviya nywie mwanikundisa miye, na kunizumiiya kuwa nalawa kwa Tate. ");
INSERT INTO bou_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Miye nalawa kwa Tate ncheza mwe inusi, isasa nahauka mwe inusi inu na kuuya kwa Tate.” ");
INSERT INTO bou_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aho wahina wakwe wakamwamba, “Isasa wagombeka pwii kwesiho kugea misimo. ");
INSERT INTO bou_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Isasa tamanya kuwa wee wamanya kiya kintu, khahana haja ya kuuzigwa mbui na mntu yoyose, ivyo tazumiiya ati kulawa kwa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akawatambaisa, “Ivi isasa twazumiia? ");
INSERT INTO bou_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kisingi cheza, naho kibua kae, ambaho nywie nyose mwendahomumwaganike kiya mntu kwakwe, namiye nabadwa ikedu, aaha akini miye khiko ikedu, mana Tate yu hamwe na mie. ");
INSERT INTO bou_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nawamba mbui izi mdahe kuwa na uivanisi he kuwa hamwe na miye, mwe inusi mwenda mkubwaniswe, akini togwani ni moyo miye khivota inusi.” ");
INSERT INTO bou_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ekubindaho kugombeka ayo, akenua meso uwanga kwa Muungu, akamba, “Tate ida saa ibuwa! Mtogoe Mwanao na Mwana nae adahe kukutogoa. ");
INSERT INTO bou_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwaviya kumwekha udaho Mwanao mwa wantu wose, ili awekhe ugima wa misi yose kwesiho kisiikizi, wose wekumwekhao. ");
INSERT INTO bou_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ugima wa misi yose kwesiho kisiikizi nee unu, kukumanya wee ikedu Muungu wa kwei na kummanya Yesu Klistu wekumwaagiiaye. ");
INSERT INTO bou_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Miye kikutogoa mwe inusi nakuwaonyesha wantu ukuu wako, kwembokea ndima wekuniagiiazo nizigosoe. ");
INSERT INTO bou_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Isasa Tate unitogoe uwaonyeshe wantu nekuwavyo mkuu kwa uda Ukuu nekuwao nao, kabla ya kuumbigwa inusi. ");
INSERT INTO bou_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Khikutenda umanyike kwa wantu wekunekhao kulawa mwe inusi, nee wawa wantu wako, nawe ukanekha wawe wangu naho wagosoa yose wekuwaagiiayo, ");
INSERT INTO bou_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","isasa wamanya kuwa kia wekunekhacho kilawa kwako. ");
INSERT INTO bou_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwaajii khiwamba yose wekunigombekayo, nawo wakahokea, wamanya kwei kilawa kwako na wazumiiya wee nee mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nawaombezea awo, nawala khiwaombezea wantu wa inusi, iya nawaombezea wada wekunekhao kwaviya ni wako. ");
INSERT INTO bou_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wantu wose nekuwao nao ni wako naho wantu wose ambao ni wako ni wangu na miye kitogolwa na waoneka mwe wada wekunekhao. ");
INSERT INTO bou_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na isasa neza kwako, khimo vituhu mwe inusi, akini wowo wendawaendee kuwa mwe inusi, Tate Muungu! Kwa udaho wa zina dako wekunekhado uwaike pheho wawe kintu kimwe inga swie teivyo hamwe. ");
INSERT INTO bou_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nekuaho nawo, miye kiwaika pheho kwa udaho wa zina dako wekunekhado Miye khiwainda naho khahana katu yumwe yawo mwekwaga iya ni yuda mwana mwekwaga, ili Maandiko ya Muungu yaiganie inga yekuandikwavyo. ");
INSERT INTO bou_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Isasa neza kwako na kigombeka mbui izo mwe inusi, ili wawe na nyemi muno mioyo yao inga ambavyo miye nekuwavyo na nyemi. ");
INSERT INTO bou_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Miye kiwekha mbui yako, naho wantu wa inusi wakawakima, akini wowo wekukuzumiiao khio wantu wa inusi inu, inga viya mie nesivyo wa mwe inusi inu. ");
INSERT INTO bou_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Khiombeza uwalavye mwe inusi iya naombeza uwainde na yuda mbanasi. ");
INSERT INTO bou_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wowo khiwo wa mwe inusi, inga viya nesivyo wa mwe inusi. ");
INSERT INTO bou_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Eee Tate nakuombeza uwazingue kuwa wantu wako wa kwei, kwa sia ya ukwei wako, kwaajii mbui yako nee ukwei. ");
INSERT INTO bou_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Inga viya wekuniagiiavyo mwe inusi na miye kiwaagiiya wowo mwe inusi. ");
INSERT INTO bou_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Miye mwenye nchezingua kukugosoea ndima kwaajii yawo ili wowo nawo wezingue kukugosoea ndima mwe ukwei. ");
INSERT INTO bou_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Khiwavikia wowo du, iya nawavikia wose wendao wakuzumiiye kwaawiana na mbui zao. ");
INSERT INTO bou_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Naombeza ili wose wawe kintu kimwe, Tate naombeza wawe ndani yetu inga viya wee weivyo ndani yangu miye ndani yako, naombeza wawe kintu kimwe ili wantu wa inusi wakuzumiiye inga wee nee mwekuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Miye khiwekha ukuu udauda wekunekhao miye, wawe kintu kimwe inga viya swie teivyo hamwe. ");
INSERT INTO bou_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miye niwe ndani yawo nawe uwe ndani yangu, naombeza watendwe wawe kintu kimwe, kwaivyo wantu wa inusi wamanye wee nee mwekuniagiiya naho wawakundisa wowo inga unikundisavyo mie. ");
INSERT INTO bou_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate naondeza awo wekunekhao wawe hamwe na miye hada neiho, waone Ukuu wangu wekunekhao, kwaviya nee kunikunda, kabla inusi khaizati kuumbigwa. ");
INSERT INTO bou_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate Yedi! Wantu wa mwe inusi khawakumanya, akini miye nakumanya, awa nawo wamanya wee kuniagiiya. ");
INSERT INTO bou_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Khikutenda zina dimanyike kwao, na nendanitendese kugosoa ivyo, ili ukundiso wenao kwangu uwe umo mwao na miye umo mwao.” ");
INSERT INTO bou_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ekubindaho kugombeka ayo, akaita phande ya kaidi ya ngodi ya mazi ya Kedloni, hamwe na wahina wakwe, hantu hada hawa na kamnda. Nae Yesu akengiya umo hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, mwekumhituka Yesu, kahamanya hantu hada, kwa viya kia maa Yesu nee wakakintana hamwe na wahina wakwe. ");
INSERT INTO bou_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda akadoa wakhondo wa Kilumi na wagoji kulawa kwa waviki wakuu na mafalisayo, akeza nawo he kamnda, uku watoza mienge, na chemli na vitoanavyo. ");
INSERT INTO bou_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, kwaviya kavimanya vyose vyendavyo vimbwiiye, akalawa akawauza, “Mwamwondeza ndai?” ");
INSERT INTO bou_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nawo wakamtambaisa, “Yesu wa mzi wa Nazaleti.” Yesu akawamba, “Nee Miye.” Yuda mwe kumhituka kagooka aho hamwe nawo. ");
INSERT INTO bou_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu ekuwambaho, “Nee Miye,” wowo wakauya mgeeka, na wakagwa asi. ");
INSERT INTO bou_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu akawauza vituhu, “Mwamwondeza ndai?” Wowo wakamtambaisa, “Yesu wa Nazaleti.” ");
INSERT INTO bou_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akawamba, “Khiwamba kae kuwa nee miye, naho inga mwaniondeza miye, waekeni awa waite.” ");
INSERT INTO bou_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu kagombeka ayo, ili yalawiiye yada ekugombekayo aho bosi, “Wada wekunekhao nchekumwaza ata yumwe.” ");
INSERT INTO bou_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo kawa na paange, nee adisoomoa, akamsenga gutwi da kuume mndima wa Mviki Mkuu. Mndima uyo nee aketangwa Maliko. ");
INSERT INTO bou_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aho Yesu akamwamba Petulo, “Vuza paange dako mwe safuo dako, ivi nisekudomeya kikombe cha usuumizi ekunekhacho Tate?” ");
INSERT INTO bou_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wada wakhondo wa Kilumi na mgookezi yawo na wagoji wa Wayahudi nee wamgwiiya Yesu wakamzengeteza sigi, ");
INSERT INTO bou_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","na wakamwegaa kwa Anasi, Anasi ni mkwewe da Kayafa yuda mwekuwa Mviki Mkuu wa kisingi icho. ");
INSERT INTO bou_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Uyo Kayafa nee mwekuwamba Wayahudi kuwa, yendaiwe vitana mntu yumwe auye na nyuma, kwaajii ya wantu wose. ");
INSERT INTO bou_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo hamwe na mhina mtuhu wakamtongea Yesu. Uyo mhina mtuhu nee akamanyika kwa Mviki Mkuu, ivyo akengia na Yesu heukumbi wa Mviki Mkuu. ");
INSERT INTO bou_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Akini Petulo, nee kagooka chongoi hehi na uvi. Naho uyo mhina mtuhu mwekumanyika kwa Mviki Mkuu akalawa chongoi, na akagombeka na mndima wa kivyee mgoji wauvi akamwengiza Petulo ndani. ");
INSERT INTO bou_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mtumwa uyo ya kivyee mgoji wauvi akamuuza Petulo, nawe wee ni yumwe wa wahina wa mntu uyu? Petulo akamtambaisa, “Khio miye.” ");
INSERT INTO bou_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Msi uwo nekuwa na pheho na wandima na wagoji nee wagimba moto, naye Petulo akagooka hamwe nawo wakaotea moto. ");
INSERT INTO bou_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Naho Mviki Mkuu akamuuza Yesu mbui ya wahina wakwe na mahinyo yakwe. ");
INSERT INTO bou_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akamtambaisa, “Miye khigombeka na inusi pwii, kia maa nahinya he Nyumba ya kukintania Wayahudi, na kwe Nyumba ya Muungu na hantu wakintanaho Wayahudi wose, naho ncheekugombeka dodose kwa sii. ");
INSERT INTO bou_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwa mbwai waniuza miye? Wauze wada wekunitegeezao khiwambaze, wowo wamanya nekuwambiavyo.” ");
INSERT INTO bou_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ekubindaho kugombeka ayo, mgoji yumwe mwekua kagooka hada akamtoa Yesu kofi akamba, ivi wee nee umtambaisavyo Mviki Mkuu? ");
INSERT INTO bou_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu akamtambaisa, ati khigombeka yesayo kutama vuhuzia ivyo vyesavyo kutama, akini ati kigombeka vyedi wanitoeyani? ");
INSERT INTO bou_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nee Anasi amwegaa Yesu uku kazengetezwa sigi, kwa Mviki Mkuu Kayafa. ");
INSERT INTO bou_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na Simoni Petulo kawa aho aotea moto, umo wakamuuza, “Ivi, wee ni yumwe wa wahina wakwe?” Petulo akaemea na kwamba, “Khiyo miye.” ");
INSERT INTO bou_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumwe da wandima wa Mviki Mkuu akamba, ni nduguye da yuda mntu mwe kusengwa gutwi ni Petulo, akamuuza, “Ivi miye nchekukuona he kamnda hamwe naye?” ");
INSERT INTO bou_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petulo akaemea vituhu, akagombeka khio miye, vuupu zogoo dikakema. ");
INSERT INTO bou_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Keokeo da mtungaihu wakamdoa Yesu kulawa kwa Kayafa, na kumwegaa kwe nyumba khuu ya mkuu wa Walumi, nawo wadahe kuida sikukhuu ya Pasaka, khawe kwengia mwe nyumba ya mkuu wa Walumi, nee waogoha kwaviya wakengia kwendakuwatende wesekuzumiwa kwe kumvikia Muungu, ivyo newavotwa kugosoa sikukhuu ya Pasaka. ");
INSERT INTO bou_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ivyo Pilato akawabasa chongoi akawauza, “Ivi mntu uyu kagosoa masa yani adi mumwete kwangu?” ");
INSERT INTO bou_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wakamtambaisa, “Inga uyu kheekuwa mkoa masa khatekuwa timwete kwako.” ");
INSERT INTO bou_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato akawamba, “Hayani, mdoeni nywinywi wenye mkamuamwiiye kutongeana na miagiiyo yenu.” Wayahudi wakamtambaisa, “Miagiiyo yetu yatiemeza kumkoma mntu yoyose.” ");
INSERT INTO bou_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wagombeka ivyo, ili vidahe kuigania mbui ekugombekayo Yesu kumanya enda afe vivihi. ");
INSERT INTO bou_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato akengia vituhu mwe nyumba ya mkuu wa Walumi akamwetanga Yesu na kumuuza, “Ivi wee nee Seuta wa Wayahudi?” ");
INSERT INTO bou_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu akamtambaisa, izo ni mbui zako mwenye, hambu wantu watuhu wakwamba mbui zangu? ");
INSERT INTO bou_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato akamtambaisa, “Ivi miye ni Myahudi? Wantu wa si yako na waviki nee wekukuetao kwangu. Kugosoa masa yani?” ");
INSERT INTO bou_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akamtambaisa, “Useuta wangu khio wa mwe inusi, ati useuta wangu nee ni wa mwe inusi, wandima wangu nee wakanivunia nisekweza kugwiwa na Wayahudi, akini isasa useuta wangu khio wa aha.” ");
INSERT INTO bou_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aho Pilato akamwamba, “Ivi wee u Seuta?” Yesu akamtambaisa, “Weye wamba miye ni Seuta, miye khivyaigwa kwaajii iyo, na kwaajii iyo ncheza mwe inusi kuwamba wantu ukwei na kia mntu azumiiyae ukwei, uyo anitegeeza.” ");
INSERT INTO bou_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato akamuuza Yesu, “Ukwei ni mbwai?” Pilato ekubindaho kugombeka ayo, akawabasa Wayahudi vituhu chongoi akawamba, “Miye khiona masa yoyose kwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Akini mna mazweeya ya kuniombeza miye kuwavuguiya mfungwa yumwe kisingi cha sikukhuu ya pasaka, Ivi mwakunda niwavugwiiye Seuta wa Wayahudi? ");
INSERT INTO bou_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aho wakatoa vuzo, “Aah! Khio mntu uyu iya Balaba!” Na yuda Balaba nee kawa mhokaji. ");
INSERT INTO bou_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Naho Pilato akaagiiya Yesu adoigwe, atoigwe makoto. ");
INSERT INTO bou_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na awo maasikali wakagosoa kintu inga khofia ya useuta yekugosolwayo na miwa, wakambadika mwe mtwi, wakamvikia gwanda da langi ya zambalau. ");
INSERT INTO bou_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wakeza hemeso yakwe na kugombeka “Togoa, Seuta wa Wayahudi!” Wakamtoa vibao. ");
INSERT INTO bou_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato akalawa vituhu chongoi, akawamba wada wekukintanao, “Kauwani, namwekhiiza Yesu henu na kuwamanyisha miye khiona masa yoyose ya mntu huyu.” ");
INSERT INTO bou_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Umo Yesu akalavigwa chongoi kevaiya kiya kintu inga khofia ya useuta yekugosolwayo na miwa, na gwanda da langi ya zambalau, Pilato akawamba, “kauwani mntu mwenye nee uyo.” ");
INSERT INTO bou_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Waviki wakuu na wagoji wekumuonaho wakakweza mgutio, “Agong'ondewe he mhamba! Agong'ondewe he mhamba.” Pilato, akawamba, “Mdoeni nywinywi wenye mkamsuumiize, mana miye khiona masa yoyose kwakwe.” ");
INSERT INTO bou_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wakatambaisa, “Swiye tina Miko, na kutongeana na miko iyo akundigwa auye na nyuma kwaviya ketanga Mwana Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato ekusikiaho mbui iyo akaogoha. ");
INSERT INTO bou_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akengiya mwe nyumba khuu ya kiseuta vituhu akamuuza Yesu, “kulawiiya kuhi?” Akini Yesu khee kumwaandua mbui yoyose. ");
INSERT INTO bou_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato akamwamba, “Wee khukunda kutamwiiya na miye? Khumanya kuwa miye ninaudaho wakukuekea naho ninaudaho wa kukugong'ondea he mhamba.” ");
INSERT INTO bou_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akatambaisa, “Wee una udaho uwanga yangu, kwaajii du kwekhigwa ni Muungu, ivyo yuda mwekunekhiiza kwako kagosoa kintu kifyaimi muno.” ");
INSERT INTO bou_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kuvokeya aho, Pilato akaondeza sia ya kumweekeya, akini wayahudi wakatoa vuzo, “Ukamwekeya mntu uyu, wee khiwe mmbuya wa zumbe mkuu wa Walumi, kiya mntu atendaye kuwa seuta ahigana na seuta wa Wakilumi.” ");
INSERT INTO bou_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Naho Pilato ekutegeezaho mbui izo akamlavya Yesu chongoi akekaa he kigoda cha uamwiiyo hantu hetangwaho “Hantu hekupangwaho maiwe.” Kwa kieblania “Gabasa” ");
INSERT INTO bou_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yekubuwaho saa mtandatu wa musi, msi wa kweika tayali kwaajii ya Pasaka. Pilato akawamba Wayahudi, “Mkauweni Seuta yenu.” ");
INSERT INTO bou_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wowo wakakweza mgutio, “Mkome! Mkome! Agong'ondwe he mhamba.” Pilato akawauza, “uwo nimgong'onde he mhamba seuta yenu?” Waviki wakuu wakatambaisa, “Swie khatina seuta iya seuta mkuu wa kilumi!” ");
INSERT INTO bou_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aho pilato akamgeya Yesu mwe mikono yao agong'ondewe he mhamba. Ivyo wakamdoa Yesu. ");
INSERT INTO bou_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu ekwenuwaho mhamba wakwe, akalawa kuita hantu he kwetangwaho, “Fufu da mtwi” kwa Kieblania ni Goligota. ");
INSERT INTO bou_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aho nee agong'ondewa he mhamba, hamwe nae wawagong'ondea he mhamba wantu watuhu waidi, kia yumwe he mhamba wakwe, yumwe phande ya kuume na mtuhu phande yakwe ya kumoso, na Yesu gatigati. ");
INSERT INTO bou_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato akaandika kibao akakiika uwanga ya mti wa mhamba nee kiandikwa ivi, “Yesu Mnazaleti Seuta wa Wayahudi” ");
INSERT INTO bou_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi wangi wasoma kibao icho, mana hada ekugong'ondewaho Yesu hawa hehi na mzi. Naho kibao icho kiwa kiandikwa kwa Kieblania na Kilatini na Kigiiki. ");
INSERT INTO bou_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Waviki Wakuu wa Wayahudi wakaemea wakamwamba Pilato, “Usekuandika, ‘Seuta wa Wayahudi,’ iya andika, mntu huyu nee kamba, ‘Miye ni Seuta wa Wayahudi.’ ” ");
INSERT INTO bou_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato akawatambaisa, “Nekuandikayo khiyaandika.” ");
INSERT INTO bou_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Maasikai wekubindaho kumgong'ondea Yesu he mhamba, wakadoa magwanda yakwe wakayapanga mafungu mane, fungu dimwe kwa kia asikai, wakadoa viyaviya na gwanda dakwe, gwanda ido diwa difumwa na kuwa kintu kimwe kulawa uwanga adi asi. ");
INSERT INTO bou_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Awo masikai wakamamakhanya, “Tisekuitatua iya tiitwee kula yendaiwe ya ndai.” Mbui iyo igosoka ili Maandiko ya Muungu yaiganie, yagombekayo, “Wapangana magwanda yangu Na gwanda dangu wakaditwee kula.” Ivyo nee wekugosoavyo wada maasikai. ");
INSERT INTO bou_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hehi ya mti wa mhamba wa Yesu nee wagooka mami yakwe da Yesu, na mami yakwe mdodo da Yesu na Maliamu mkaza Kileopa na Maliamu wa mzi wa Magidala. ");
INSERT INTO bou_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu ekumuonaho mami yakwe, na hehi naye kagooka yuda mhina ekumkundisae, akamwamba mami yakwe, “Mmaa uyo nee mwanao.” ");
INSERT INTO bou_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Akabinda akamwamba yuda mhina, “Kauwa uyo nee mami yako.” Na kuvokeya mda uda mhina akahauka nae kaya kwakwe. ");
INSERT INTO bou_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu akamanya kabindiiza ndima yakwe ya uohozi, naho akagombeka ili Maandiko ya Muungu yadahe kuigania, “Naona khiu.” ");
INSERT INTO bou_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aho nee hana wiga wekumemao divai yekusasayo, akadoa dodoki akadiginta mwe divai yekusasayo, wakaigea uwanga ya lasi, wakamwiikiya mwe muomo. ");
INSERT INTO bou_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu ekusonaho iyo divai yekusasayo akamba, “Yaigania!” Naho akenamiza mtwi wakwe, akauya na nyuma. ");
INSERT INTO bou_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iwa Ijumaa msi wa mwaandao, kwaivyo mii isekwekaa mwe mti wa mhamba, kwaajii Msi uwo wa Kuhumwiiza iwa msi mkuu kwa Wayahudi, wakamwoombeza Pilato miundi ya awo wekugong'ondewao he mhamba ibondwe na mii yawo iusigwe. ");
INSERT INTO bou_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ivyo maasikai wakaita, wakaibonda miundi ya yuda mntu wa bosi na yuda wakaidi wekugong'ondewa he mhamba hamwe na Yesu. ");
INSERT INTO bou_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Akini wekumbwiiaho Yesu waona kauya kae na nyuma, ivyo khawekumbonda miundi yakwe. ");
INSERT INTO bou_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Akini asikai yumwe akamtunga ubavu kwa guha na vuupuu ikalawa phome na mazi. ");
INSERT INTO bou_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yuda mwekuona mbui iyo, akawamba wantu ili nywie mdahe kuzumiia, na yada ekugombekayo ni kwei naho amanya kuwa agombeka ukwei. ");
INSERT INTO bou_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mbui iyo igosoka ili Maandiko ya Muungu yaiganie “Khahana katu vuha dakwe dimwe dendado dibondwe.” ");
INSERT INTO bou_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Naho Maandiko ya Muungu matuhu yamba, “Wendawamkauwe yuda wekumtungae.” ");
INSERT INTO bou_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yekusiaho ayo, Yusufu mwenyezi wa mzi wa Alimataya, mwekuwaye mndima wa Yesu etiho kwa sii kwaajii ya kuwaogoha Wayahudi, akaita kwa Pilato na kumuombeza uhusa wa kuudoa mwii wa Yesu, Pilato akamzumiiya, ivyo Yusufu akaita akaudoa mwii wa Yesu. ");
INSERT INTO bou_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naho Nikodemo, ambae aho bosi kawa kambasa Yesu na kio, akaita hamwe na Yusufu wakadoa mhanganyo wa manemane na ubani yabua kilo makumi matatu. ");
INSERT INTO bou_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wantu waidi awo, wakaudoa uda mwii wa Yesu wakauzengeteza sanda hamwe na yada malashi inga yeivyo mazweeya ya Wayahudi he uzisi. ");
INSERT INTO bou_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hada hakugong'ondewa Yesu hawa na kamnda, na mwe kamnda ako hawa na mbia dihya dekusongwado he iwe kuu, ambado khadizati kugewa mntu yoyose. ");
INSERT INTO bou_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwa ngijangija za Wayahudi za mwaandao wa Msi wa Kuhumwiiza, kwaviya mbia ido diwa hehi, wakaika mwii wa Yesu umo. ");
INSERT INTO bou_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Keokeo da mtungaihu, msi wa bosi wa juma kukekuwa na kakiza, Maliamu wa kulawa Magidala akaita kwe mbia, akadiona dia iwe diusigwa he uvi wa mbia. ");
INSERT INTO bou_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aho akaguuka kuita kwa Simoni Petulo na yuda mhina mtuhu Yesu ekuaye kamkundisa muno akawamba, “Wamuusa Zumbe he mbia na aho khatimanya wamwiikia kuhi.” ");
INSERT INTO bou_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ahoaho, Petulo hamwe na yuda mhina mtuhu wakahauka na kuita kwe mbia. ");
INSERT INTO bou_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose waidi wakaguuka akini yuda mhina mtuhu kaguuka kinyio kusima Petulo, akaongoa kubua he mbia. ");
INSERT INTO bou_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ekwenamaho na kusungiia ndani ya mbia akoona sanda, akini kheekwengia ndani. ");
INSERT INTO bou_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulo akeza akamtimia, akengia he mbia, umo akaona sanda, ");
INSERT INTO bou_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kia kitambaa ekuzengetewazo Yesu kwe mtwi. Kitambaa icho khachekuikwa hamwe na sanda, kikunjwa na kuikwa hantu ha ikedu. ");
INSERT INTO bou_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naho yuda mhina mtuhu mwekuongoa kubua he mbia, akengia viyaviya ndani akoona na akazumiiya. ");
INSERT INTO bou_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nee khawazati kuva Maandiko ya Muungu yekwambayo kuwa, nee yakundigwa ayuyuke kulawa he ufe. ");
INSERT INTO bou_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naho awo wahina wakauya kaya. ");
INSERT INTO bou_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliamu kawa kagooka chongoi ya mbia aiya, uku akekwiiya nee enama na kusungiia he mbia, ");
INSERT INTO bou_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akaona wandima wa uwanga wa Muungu waidi, wekuvaawo magwanda yekung'aayo muno, wekaa hada wekuwaho mwii wa Yesu ugonezwa yumwe he mtwi, wa kaidi he miundi. ");
INSERT INTO bou_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Awo wandima wa uwanga wa Muungu wakamuuza, “Mmaa kwa mbwai waiya?” Nae akawatambaisa, “Wamuusa Zumbe yangu na khimanya wekumwiikako!” ");
INSERT INTO bou_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ekugombekaho ayo, akahituka mgeeka akamuona Yesu kagooka aho, akini kheekumtanga inga ni Yesu. ");
INSERT INTO bou_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu akamuuza, “Mmaa waiya mbwai? Wamwoondeza ndai?” Maliamu akamamakhanya uyo nee mgookezi wa kamnda akamwamba, “Mkuu inga ni weye mwekumuusa, nambia wekumwiikako, nami ninda nimdoe.” ");
INSERT INTO bou_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu akamwetanga, “Maliamu!” Nae Maliamu akamhitukia Yesu na kumwamba kwa Kiebulania, “Laboni” mana yakwe, “Mhinyi.” ");
INSERT INTO bou_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu akamwamba, “Usekunitoza khizati kuita uwanga kwa Tate, akini uite kwa wandugu zangu ukawambe, naita uwanga kwa Tate yangu na Tate yenu, Muungu yangu na Muungu yenu.” ");
INSERT INTO bou_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ivyo Maliamu wa mzi wa Magidala akaita kuwamba wada wahina kuwa kamuona Zumbe na kuwa nee kamwamba ivyo. ");
INSERT INTO bou_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nee iwa guoni wa msi uwo wa bosi wa juma, wahina wa Yesu, wakakintana hamwe mwe nyumba, na nyuvi nee zivugalwa kwaajii ya kuwaogoha waongoezi wa Kiyahudi. Aho Yesu akeza akagooka gati yawo akawamba, “Uivanisi uwe kwenu.” ");
INSERT INTO bou_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ekugombekaho ivyo, akawaonyesha mikono yakwe na mbavu zakwe, aho wahina wakwe wakawa na nyemi muno kwaviya wamuona Zumbe. ");
INSERT INTO bou_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu akawamba vituhu, “Uivanisi uwe hamwe nanywi, inga viya Tate ekuniagiiavyo miye, na miye nawaagiiya nywinywi.” ");
INSERT INTO bou_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ekugombekaho ayo, akawavuziya muye na kuwamba, “Hokeani Muye wa Muungu.” ");
INSERT INTO bou_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inga mwawaekea wantu mavigaviga yao Muungu endaawaekee na inga mkese kuwaekea wantu mavigaviga yao, Muungu khana awaekee mavigaviga yao. ");
INSERT INTO bou_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomaso, yumwe wa wada kumi dimwe na waidi etangwae zina tuhu mpasa kheekuwa hamwe nae kisingi Yesu ekwezaho. ");
INSERT INTO bou_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aho wada wahina watuhu wakamwamba, “Timwoona Zumbe.” Akini Tomaso akawamba, “Nikesekuona alama za misumai mwe mikono yakwe na kugeya chaa changu he khovu izo na kugeya mkono wangu he ubavu wakwe, khinanizumiiye.” ");
INSERT INTO bou_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yekwembokaho misi nane, wahina wakwe wawa hamwe umo ndani, na Tomaso kawa hamwe nawo, akeza Yesu akagooka gatigati yawo, uku nyuvi ziwa zivugalwa akamba, “Uivanisi uwe nanywi.” ");
INSERT INTO bou_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Naho akamwamba Tomaso, “Ete chaa chako aha uikauwe mikono yangu, ete mkono wako wembose he ubavu wangu usekuwa na maatu iya zumiiya.” ");
INSERT INTO bou_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso akamtambaisa, “Weye ni Zumbe yangu naho weye ni Muungu yangu!” ");
INSERT INTO bou_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu akamwamba, “Ivi kuzumiia kwaajii kuniona? Ebae wada wesaokuona akini wazumiiya.” ");
INSERT INTO bou_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu kagosoa hemeso ya wahina wakwe ntangio ntuhu nyingi khazekuandikwa mwe kitabu iki. ");
INSERT INTO bou_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Akini izi ziandikwa mdahe kuzumiia inga Yesu ni Klistu Mwana wa Muungu na kwa kuzumiiya mdahe kuwa na ugima wa misi yose kwesiho kisiikizi. ");
INSERT INTO bou_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yekwembokaho ayo, Yesu akawalawiiya vituhu wahina wakwe, khandakhanda ya tondoo da mazi da Tibelia na idoido nado nee tondondoo da mazi da Galilaya na nee yekuwavyo, ");
INSERT INTO bou_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo na Tomaso etangwae phasa na Nasanaeli mwenyezi wa mzi wa Kana ya Galilaya, na wana waidi wa Zebedayo, na wahina watuhu waidi wawa hamwe wose. ");
INSERT INTO bou_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo akawamba weziwe, “Naita kwekuloa samaki.” Nawo wakamwamba, “Tenda tiite hamwe nawe.” Naho wakalawa, wakengia mwe ngaawa, akini kio icho khawekwaambua chochose. ");
INSERT INTO bou_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wekuvokaho kucha, Yesu nee agooka khandakhanda ya tondoo da mazi, akini wahina khawekummanya ati ni yee nee Yesu. ");
INSERT INTO bou_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aho Yesu akawauza, “Wambuya wangu, khamzati kupata samaki wowose?” Wowo wakamtambaisa, “Bue! Khatizati kwaambua kintu.” ");
INSERT INTO bou_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu akawamba, “Tambikani nyavu zenu phande ya kuume ya ngaawa nanywi mwenda mpate samaki.” Nee wazitambika nyavu akini isasa khawekudaha kubuuta vituhu kwa wingi wa samaki. ");
INSERT INTO bou_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aho yuda mhina mwekuwa akakundiswa ni Yesu akamwamba Petulo, “Uyu ni Zumbe!” Simoni Petulo ekusikiaho ni Zumbe, akevika gwanda da uwanga, mana kheekuwa kadivaa akasooka mwe mazi. ");
INSERT INTO bou_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Akini wada wahina watuhu watimiya phwani kwa ngaawa uku wabuuta wavu wekumemao samaki, khawekuwa hae na si khavu, iya neeiwa yapata mita mia mwenga kubua khandakhanda ya mazi. ");
INSERT INTO bou_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wekubuaho si khavu waona moto wa makaa ugimbwa, uwanga yakwe kuikwa samaki na bumunda. ");
INSERT INTO bou_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu akawamba, “Eteni aha izo samaki wacheche mwekuloazo.” ");
INSERT INTO bou_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petulo akakwea ngaawa na kuubuuta uda wavu adi si khavu. Nee umema samaki wakuu mia mwenga hamsini na ntatu na etiho wawa wangi, akini wavu khawekudumuka. ");
INSERT INTO bou_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu akawamba, “Sooni mde.” Khahana katu yumwe wa wahina mwekugeeza kumuuza wee undai? Kwaviya wammanya ni Zumbe. ");
INSERT INTO bou_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu akeza, akadoa bumunda akawekha, akagosoa ivyoivyo na wada samaki. ");
INSERT INTO bou_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Inu nee iwa maa ya ntatu Yesu kuwaawiiya wahina wakwe bada ya kuyuyuka. ");
INSERT INTO bou_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wekubindaho kuda, Yesu akamuuza Simoni Petulo, “Simoni mwana wa Yohana, Ivi wanikundisa kusima awa?” Naye akatambaisa, “Eehe, Zumbe wamanya ati mie nakukundisa.” Yesu akamwamba, “Wakauwe wanangoto wangu.” ");
INSERT INTO bou_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Naho akamwamba kakaidi, Simoni mwana wa Yohana, “Ivi wanikundisa?” Petulo akamtambaisa, “Eehe Zumbe wamanya kuwa nakukundisa.” Yesu akamwamba, “Wakauwe ngoto zangu.” ");
INSERT INTO bou_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamuuza maa ya ntatu, “Simoni mwana wa Yohana! Ivi wanikundisa?” Aho Petulo akasuumia mwe moyo wakwe, kwaajii ekumuuzavyo maa ntatu, “Wanikundisa?” Akamwamba, “Zumbe, wee wamanya yose ati miye nakukundisa.” Yesu akamwamba, “Wakauwe ngoto zangu. ");
INSERT INTO bou_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nakwamba ukwei, wekuaho mbwanga, kwezoweya kweika mwenye tayali na kuita kokose wekukundako. Akini wendaho uwe mdaa wenda wenue mikono yako na mntu mtuhu endaakufunge na kukwegaa wesakokukunda uite.” ");
INSERT INTO bou_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwa kugombeka ivyo, koonyesha Petulo ufe wakwe wendavyouete ukuu kwa Muungu. Naho akamwamba, “Nitongea.” ");
INSERT INTO bou_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aho Petulo akahituka, akamuona mhina mtuhu yuda ekukundiswae muno na Yesu ambasa, uyu mhina ni yuda kisingi cha khande ya guoni kekaa hehi na Yesu na kumuuza “Zumbe ni yuhi endae akuhituke?” ");
INSERT INTO bou_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petulo ekumuonaho yuda mhina akamuuza Yesu, “Zumbe, na uyu vihi?” ");
INSERT INTO bou_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu akamtambaisa, “Ati nakunda asigae adi nendaho niuye, yakuusu mbwai? Weye yakundigwa unitongee.” ");
INSERT INTO bou_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nee mbui iyo ikazagaa gatigati mwa wantu wekumzumiiya Yesu kuwa mhina uyo khana auye na nyuma, akini Yesu kheekumwamba inga mhina uyo khana auye na nyuma, akini kagombeka, “Inga nikakunda asigae adi msi nendaho neze, wakunda mbwai?” ");
INSERT INTO bou_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uyo ni yuda mhina mwekuvuhuzia mbui izi na kuziandika, naswi tamanya uvuhuzi wakwe ni kwei. ");
INSERT INTO bou_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Naho kuna mbui nyingi ekugosoazo Yesu, ayo inga nee yaandikwa yose dimwe kutongea ntuhu, namamakhanya mwe inusi yenye khavyekuwa vikaiganiya kuviika vitabu ambavyo nee viandikwa.");
ALTER TABLE bou_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
