﻿USE sofia;
DROP TABLE IF EXISTS sofia.bor_vpl;
CREATE TABLE bor_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bor_vpl WRITE;
INSERT INTO bor_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ainore Jesus Cristo uwobe ekiere. Mariguduwuge uwobe etumana iere Davi. Mariguduwuge uwobe etuo iere Abraão. ");
INSERT INTO bor_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão onaregedu imedu iere Isaque. Isaque onaregedu imedu iere Jacó. Jacó ore ime emagare. Ia iere Judá. ");
INSERT INTO bor_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá onaregedu imedu iere Peres. Ia onaregedu imedu iere Zera. Nou Peres, nou Zera etuje iere Tamar. Peres onaregedu imedu iere Esrom. Esrom onaregedu imedu iere Arão. ");
INSERT INTO bor_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão onaregedu imedu iere Aminadabe. Aminadabe onaregedu imedu iere Nasom. Nasom onaregedu imedu iere Salmom. ");
INSERT INTO bor_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom onaregedu imedu iere Boaz. Nou Boaz uče iere Raabe. Boaz onaregedu imedu iere Obede. Nou Obede uče iere Rute. Obede onaregedu imedu iere Jessé. ");
INSERT INTO bor_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé onaregedu imedu iere Davi. Boe eimijera kurireu nure ema. Nou Davi ure tugeragu Urias oredujeji toreduječe. Etonaregedu imedure. Iere Salomão. ");
INSERT INTO bor_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão onaregedu imedu iere Roboão. Roboão onaregedu imedu iere Abias. Abias onaregedu imedu iere Asa. ");
INSERT INTO bor_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa onaregedu imedu iere Josafá. Josafá onaregedu imedu iere Jorão. Jorão onaregedu imedu iere Uzias. ");
INSERT INTO bor_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias onaregedu imedu iere Jotão. Jotão onaregedu iere Acaz. Acaz onaregedu imedu iere Ezequias. ");
INSERT INTO bor_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias onaregedu imedu iere Manassés. Manassés onaregedu imedu iere Amom. Amom onaregedu imedu iere Josias. ");
INSERT INTO bor_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias onaregedu imedu iere Jeconias. Jeconias uwiemagere jamedu. Nou Josias ore ime edu kimore Judá moto keje dukeje Babilônia kejewuge tugobaigarege ere tugeragu Judá kejewugei turaga tabo tuduwo ebo toro to moto Babilônia moto ka. ");
INSERT INTO bor_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilônia kejewuge ere Judá kejewuge erego Babilônia moto ka dukeje nou Jeconias onaregedu imedure. Ure iedo Salatiel. Nou Salatiel onaregedu imedu iere Zorobabel. ");
INSERT INTO bor_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel onaregedu imedu iere Abiúde. Abiúde onaregedu imedu iere Eliaquim. Eliaquim onaregedu imedu iere Azor. ");
INSERT INTO bor_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor onaregedu imedu iere Sadoque. Sadoque onaregedu imedu iere Aquim. Aquim onaregedu imedu iere Eliúde. ");
INSERT INTO bor_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde onaregedu imedu iere Eleazar. Eleazar onaregedu imedu iere Matã. Matã onaregedu imedu iere Jacó. ");
INSERT INTO bor_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó onaregedu imedu iere José. Nou José oreduje iere Maria. Nou Maria onaregedure Jesus rema. Nou Jesus iere Pao Kurireu ure boe ekinorudowu nure ema. Ainore Jesus iere. ");
INSERT INTO bor_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ainore Jesus uwobe imere. Abraão pijire boe ere catorze jii Davi boture du ka. Davi pijire boe ere catorze pugeje jii Babilônia kejewuge ere Judá moto kejewuge etawuje du ka. Judá kejewuge edure Babilônia moto keje du pijire boe ere catorze pugeje jii nou Jesus boture du ka. ");
INSERT INTO bor_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ainore Jesus Cristo boture. Uče Maria ure tuwadaru maku boe etai tumugumoduie imedu José apo rugadu. Mare emugukare puapo raga. Eribarikare pui raga. Nogwaredu jeribarikareudo nure nou Mariače rugadu. Mare Maria kuiarure. Pao Kurireu Uwari koiare Maria kuiarure. ");
INSERT INTO bor_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José jorduwagodure nou tumugumode apowu aredu kuiarure duji. Imedu pemegareu nure Joseče rugadu. Jorduwakare kaba kodiba Maria kuiarure dukodire aidukare tumuguwo apo pugeje. Mare aidukare tuwo Maria pogurudo boe egai. Dukodire ukare boe ewie. Ure tumeardae tawuje tumagowo tu Mariaji tumugumodukaie apo pugeje. ");
INSERT INTO bor_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nou José ure nou tumeardae tawuje dukeje ia boečoji uniaure. Nou uniau tada ia Pao Kurireu utugare baru tadawu aregodure José ae. Makore José ieji. Akore: – José. Davi onaregedu nure aki. Apagudukaba amuguwo Maria apo rugadu. Reko awai ka amuguwo apo rugadu. Kuiarure mare jeribarikare ia imeduji. Pao Kurireu Uwari koiare ure kuiarudo. ");
INSERT INTO bor_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Onaregedu imedumode rugadu. Emare umode boe ekinorudo ewarigudukawo bope doge eda kejewu joruto ero pegareu moriče pugeje. Dukodire tamode iedo Jesus. Ainore nou Pao Kurireu utugare baru tadawu akore Joseji. ");
INSERT INTO bor_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Marigudu Pao Kurireu makore ia imeduji tuwo boe ewie ainore boemoduie duji. Akore: – Nogwaredu jeribarikareudo kuiarumode. Onaregedu imedu mode. Emode iedo Emanuel. Ainore Pao Kurireu akore marigudu. Aino ča nou Pao Kurireu bataru jeture pudui rugadu. (Nou boe egore “Emanuel” aino tuwadaru tabo. Pawadaru tabo pamagore Pao Kurireu Mugure Pagabo.) ");
INSERT INTO bor_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nono čare José jetadure. Meartorure nou Pao Kurireu makore pudui duji rugadu. Ure Maria reko tuwai ka tumuguwo apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mare jeribarikare nou Mariaji jii toro nou Maria kuri buture du ka. Ča Maria kuri buture rugadu. Imedu rugadu. José ure iedo Jesus rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus boture Belém ba kurireu keje Judéia moto keje. Nou Judéia moto kejewu boe eimijera kurireu iere Herodes. Jesus boture dukeje ia boe tuginaiwuge jorduwareuge etaregodure to moto piji Jerusalém ba kurireu ka. Leste pijire etaregodure. ");
INSERT INTO bor_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Etaregodure Jerusalém ba kurireu ka dukeje enarare nou boe dogei. Egore: – Čerdure Judeu doge eimijera kurireu maiwu o kuieje tuginaiwuji baru tada. Nou kuieje tuginaiwu ruture dukeje čerdure ji. Dukodire čerduware Judeu doge eimijera kurireu maiwu boture rugadu duji. Dukodire čedaregodure aino čewo čebu jodo moto keje jokorai čemago pemegawo ji rugadu. Ema pa? Kaiba rakojere? ");
INSERT INTO bor_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nou Jerusalém kejewu boe eimijera kurireu Herodes meardure nou egoino duji dukeje mororamagadure rugadu. Jerusalém ba kurireu kejewuge emeardure ewadaruji jamedu dukodire eiamedu boe emororamagadure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dukodire Herodes makore nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ewagai. Makore nou jorduware Judeu doge eno bakaru jiwuge eiamedu boe ewagai jamedu. Etaregodure dukeje Herodes unarare ei kaiba nou umode boe ekinorudowu botumoduie. ");
INSERT INTO bor_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Erduware rugadu dukodire emagore Herodes bataru jipagi. Egore: – Nou umode boe ekinorudowu botumode Belém ba kurireu keje. Ainore nou mariguduwu makore Pao Kurireu bataru jiwu batarure marigudu. Nou bataru padure bapera keje. Akore: ");
INSERT INTO bor_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","– Belém ba kurireu mugure Judá uwobe eno moto keje. Boe eda kurikareu nure nou Belémče. Boe eimijera kurikareu mugure Belém keje. Mare nou Belém boe eda kejere ia Judeu doge eimijera kurireu botumode nono. Nou boe eimijera kurireu jetu pemegamode iwobe Israel doge eiamedu boei rugadu. – Ainore Pao Kurireu akore marigudu. ");
INSERT INTO bor_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nono Herodes makore nou boe tuginaiwuge jorduwareuge ewagai etaregoduwo pudae. Makore ei tuginaigodu. Unarare ei dukodire ere Herodes biedu pemegado nuba merire pudui tuiorduie nou kuieje tuginaiwu rutuie duji. ");
INSERT INTO bor_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nono Herodes makore ei etuwo Belém ba kurireu ka rugadu. Akore: – Tadudo toro rugadu. Tagaiwodo rugadu nou imedu rogu bagai. Tardumode ji dukeje tagirimi kuri mato tawo iwie rugadu kaiba rakojere ituwo toro jamedu iwo ipu jodo moto keje imago pemegawo ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nou boe tuginaiwuge jorduwareuge emeardure nou Herodes makore puduiwu boeji dukeje eture pugeje. Ča nou erdure jiwu kuieje rakoje kimore baru tada. Erdure ji. Nou kuieje uture etododai rugadu jii je rugadu. Dukeje nou kuieje ure tuwuredo nono nou imedu rogu rakojere tadawu bai aogeje. ");
INSERT INTO bor_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nou boe tuginaiwuge jorduwareuge erdure nou kuieje roinoduji dukeje egarere pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ere tuburedo nou baiji. Nono ere turemo nou baito rugadu. Dukejere čare erdure nou imedu roguji. Rakojere tuje Maria apo rugadu. Nou jorduwareuge ere tubu jodo moto keje nou imedu rogu jokorai tumago pemegawo ji. Emago pemegare ji rugadu. Nono ere toe tadaboe jado tuwo toe maku nou imedu rogu ai. Ere toe mori kurireu maku ai rugadu. Ere tori kuieje maku imedu rogu ai. Ere roreboe mori kurireu maku ai. Ere jorubo pemegareu mori kurireu maku ai. Nou jorubo pemegareu iere mirra. ");
INSERT INTO bor_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nou boečoji eniaure Pao Kurireu aregodure pudae duji. Pao Kurireu makore ei pagaie Herodes akoino ei. Pao Kurireu makore ei ekaiago tugirimi Herodes ae. Dukodire nou barogwato ekare tugirimi Herodes ae rugadu. Eture ia awaraji Belém piji tuduwo to moto ka rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nou boe tuginaiwuge jorduwareuge eture dukeje José uniaure Pao Kurireu utugare baru tadawu aregodure pudae duji. Nou Pao Kurireu utugare baru tadawu makore Joseji. Akore: – Aragojedo. Akeragu imedu roguji tuje apo jamedu taregodudo toro Egito moto ka tawo tawiado toro Herodes piji. Herodes aiwomode nou imedu rogu bagai tuwo nou imedu rogu bito. Tarego piji toro Egito moto ka. Tagaba tagirimi tago moto ka jii toro ire tawie kejewu meri ka. Imire imode tawie kaba meri kejeba tamode tagirimi tago moto ka pugeje. Ainore Pao Kurireu akore Joseji uniau tada. ");
INSERT INTO bor_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dukodire José ure turagojedo kuri je nou boečoji rugadu. Ure tugeragu nou imedu roguji, nou učeji. Eture nou boečoji rugadu nou tieda piji tuduwo toro Egito moto ka. Eture jii toro etaregodure Egito moto ka rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Emugu raire nono Egito moto keje jii nou Herodes bire kejewu meri ka. Marigudu Pao Kurireu ure boe ewie ainore eromoduie. Makore Pao Kurireu bataru jiwu ure nou bataru bu bapera keje. Akore: – Imagore itonaregedu bagai utuwo Egito moto piji. Aino nou bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ča nou boe tuginaiwuge jorduwareuge ere činorudo Herodes piji. Ekare tugirimi ae rugadu. Nou Herodes jorduwagodure nou inoduji dukodire korigodure rugadu. Aidure tuwo nou imedu rogu bito marigudu. Mare nou jorduwareuge ekare tuiorduwado duboba nure ema duji. Dukodire korigodure. Makore to tugobaigaregei etuwo Belém ba kurireu ka ewo boe etore ime eiamedu ewido rugadu. Nou boture maibariwuge, nou jorure mitotu, pobetu kejewuge eiamedu boe ewido. Emode nou Belém ba kurireu tadawuge boe etore kugure ime ewido, nou mugure pureduwuge boe etore ime ewido jamedu. Nou boe tuginaiwuge jorduwareuge ere Herodes bie kaba meri kejeba eture to moto piji. Dukodire Herodes meardaere jorumoduie pobe ei etaiwore bagaiwu imedu roguji. Dukodire makore to tugobaigaregei ewo nou boe etore ime ewido, ewo nou boture maibariwuge ewido, nou o jorure mitotu, pobetu kejewuge boe etore ime ewido jamedu. Dukodire nou tugobaigarege eture toro. Ere nou boe etore ime eiamedu boe ewido rugadu Belém ba kurireu keje, nou rakojere nou Belém ba kurireu pureduwuge ewido jamedu. ");
INSERT INTO bor_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pao Kurireu ure boe ewie nou inoduji marigudu. Ure tuwadaru maku makore Pao Kurireu bataru jiwu Jeremias ai. Akore: ");
INSERT INTO bor_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","– Boe eda Ramá rakoje jaekare Belém piji. Ramá kejewuge etragudu rakamode rugadu. Ekiarigodumode rugadu. Boe emeardumode etraguduji rugadu. Nou moto kejewuge etuje Raquel uwobe areme etragudumode tore ewagai. Boe erduwamodukare tuwo ewudugugo nou tugiarigodure dupiji. Etore kugure eiamedu boe ewire dukodi. Ainore Pao Kurireu akore marigudu. Aino čare nou Pao Kurireu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Toro ia meri keje Herodes bire rugadu. Nono ia Pao Kurireu utugare baru tadawu aregodure José ae toro Egito moto ka. Makore Joseji uniau tada. ");
INSERT INTO bor_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Akore: – Nou aidure tuwo imedu rogu bitowu bokware. Aino ča taragojedo taduwo taibagi tago moto ka pugeje, aki, nou imedu rogu, nou uče jamedu tawo tagirimi Israel moto ka. ");
INSERT INTO bor_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dukodire José ure turagojedo. Ure tugeragu toredujeji, nou imedu roguji dukeje eture rugadu toro to moto Israel moto ka rugadu. ");
INSERT INTO bor_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kodure awaraji dukeje José meardure nou imedu Arquelau muguie tuo Herodes mugato boe eimijera kurireuwo ema nono Judéia moto keje. Dukodire José pagudure tuduwo Judéia moto ka. Uniau tadare Pao Kurireu ure bie jamedu utukawo toro Judéia moto ka. Dukodire José uture toreduje apo nou imedu rogu apo jamedu toro Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Etaregodure Galiléia moto ka dukeje eture toro Nazaré ba kurireu ka tumuguwo nono. Marigudu Pao Kurireu ure boe ewie eromoduie aino. Nou makore Pao Kurireu bataru jiwuge ere nou Pao Kurireu bataru bu bapera keje. Akore: – Nou umode boe ekinorudowu iemode Nazaré ba kurireu pijiwu nure ema. Ainore Pao Kurireu akore marigudu. Aino ča nou Pao Kurireu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ia meri keje João Batista rakojere boe maereu keje Judéia moto keje. Nonore rakojere tumago tabo Pao Kurireu bataruji. ");
INSERT INTO bor_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Akore: – Tagera ra taro pegareu piji. Boe puredugodu Pao Kurireu uwo boe eimijera kurireudo pudumi rugadu. ");
INSERT INTO bor_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ainore João Batista akore. Marigudu Pao Kurireu ure boe ewie ia makore Pao Kurireu bataru jiwu aregodumoduie nono João Batista mogadure rugadu. Mariguduwu makore Pao Kurireu bataru jiwu Isaías ure nou Pao Kurireu bataru bu bapera keje. Akore: – Ia imedu uwadodunure boe maereu keje boe ewo awara jetorodo boe eimijera aregodu pemegawo boe etae. Mare awara ji karega akoino. Boe ewo turo jetorodo. Dujire akoino. Boe ewo turo pemegado, umode boe ekinorudowu imedu aregodumode Pao Kurireu piji kodi. Dujire akoino. João Batista jirabodu Pao Kurireu akoino. ");
INSERT INTO bor_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João Batista ukudaure camelo buče. Pegajejewure tapira biri rema. Okwagere tu kitariga dogei, ropa doge eweguruji tu rugadu. ");
INSERT INTO bor_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Boe emagare tudu tabo João Batista ae. Etaregodure Judéia moto piji. Etaregodure Jerusalém ba kurireu piji. Etaregodure Jordão Po okwaiwu moto jamedu boe piji tumearduwo João Batista makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Emeardure João Batista bataruji dukeje emagore turo pegareu jiboeji, taiduie tuwo tugera ra nou turo pegareu jiboe piji. Nono João Batista ure etao pegodo Jordão Po tada. ");
INSERT INTO bor_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mare ia fariseu doge etaregodure João Batista ae. Ia saduceu doge etaregodure João Batista ae jamedu. Judeu doge eimijerage nure emage. Etaregodure João Batista ae etao pegododuwo jamedu. Mare etaidukare tuwo tugera ra nou turo pegareu piji. Dukodire João Batista makore ei. Akore: – Tare nono awage pegareuge emogadure. Mare awagu ji karega inagoino. Tare tadugarege Judeu doge ekiripagado. Tagagore taro pemegaie mare ro pegareuge nure tagi rugadu. Kočare tagaregodure mato iwagai. Tarokwačereu bokware. Pao Kurireu umode boe pegado tai taro pegareu moriče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mare taro jetorodo tarore jiboeji boe erduwo taroji boe erduwawo tare tagera ra taro pegareu piji duji. ");
INSERT INTO bor_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mare tamodukare tagera ra taro pegareu piji dukeje Pao Kurireu uwobe emodukare tagi. Tagagore boe etuo Abraão ore enuie tagi dukodire Pao Kurireu uwobe enuie tagi. Ainore tagagore. Boe jokodu jire tagagoino. Abraão uwobe nure tagi rugadu. Mare du inodu kodi karega Pao Kurireu ro pegamodukare tai taro pegareu moriče. Ro pegareuge nure tagi rugadu. Dukodire tagare nono Abraão uwobe remawuge emogadure pugeje. Pao Kurireu roiware tuwo tori udo nono boe mogadure tuwo Abraão uwobedo emage tamugato. ");
INSERT INTO bor_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Boe emode tudureboe i butudo jerigiče tudu bokware dukodi. Tagi tagagomode tamoduie tagera ra taro pegareu piji mare taro pemegamodukare, tameardae pemegamodukare dukeje Pao Kurireu ro pegamode tai jamedu nono boe erore nou jerigi jitu mogadure. Mare jerigi ji karega inagoino. Boe pegamode tai rugadu. Dujire inagoino. Pao Kurireu umode boe pegado tai taro pegareu moriče kuri je rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Boe ere tugera ra turo pegareu piji dukodire ire etao pegodo pobo tabo. Mare ia imedu ro kodumode ikoriwu aregodumode kuri iregodaji. Boe pemegareu nure ema, boe kurireu mode ema rugadu. Dukodire ipogurumode ipureduwo ji, kurikareu nure imi kodi. Emare umode Tuwari tugu boe emeardaeto boe ero pemegawo. Umode ro pegareuge ewarigu joruto jamedu. ");
INSERT INTO bor_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Romode nono ia imedu rore trigo jitu mogadure. Imedu umode trigo jukodo baku tabo tuwo iwo tawuje nou trigo piji. Nou trigo remawure umode tugu baito. Nou iwore umode barigu joruto. Nou umode boe ekinorudowu romode aino boei jamedu. Meartorure Pao Kurireu jiwuge ere nono trigo mogadure. Mare trigo ji karega inagoino. Umode boe ekinorudowu umode meartorure Pao Kurireu jiwuge etawuje ro pegareuge epiji tuwo edudo pudabo. Dujire inagoino. Umode ro pegareuge ewarigu bope doge eda kejewu joru pegareuto. Dujire inagoino. Nou joru akedumodukare rugadu. Ainore João Batista akore. ");
INSERT INTO bor_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ia meri keje Jesus uture Galiléia moto piji toro Jordão Po ka, João Batista bagai, João Batista uwo Jesus ao pegodo. ");
INSERT INTO bor_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jesus aregodure João Batista ae mare João Batista aidukare tuwo Jesus ao pegodo. Akore: – Ro pegareu nure imi dukodire ipemegakare iwo akao pegodo. Aki apemegare awo itao pegodo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mare Jesus akore: – Boro. Amode itao pegodo rugadu. Ainore Pao Kurireu meardaere. Amode itao pegodo dukeje pamode Pao Kurireu makore jiboe jamedu boe jetudo pudui. Aino Pao Kurireu meardae pemegareu jire paroino rugadu. Dukodire João Batista ure tumeardaedo nono Jesus makore jiboe mogadure. ");
INSERT INTO bor_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ure Jesus ao pegodo rugadu. Dukeje Jesus ure tudawuje Jordão Po piji. Nono barure tuiado. Jesus jordure Pao Kurireu Uwari ure turawuje baru piji rugadu. Ure nono metugore. Ure tumugudo Jesus keje. ");
INSERT INTO bor_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nono Pao Kurireu makore baru piji. Akore: – Itonaregedu reo. Imeardu kurire ji rugadu. Ure iagaredo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nono Pao Kurireu Uwari makore Jesusji utuwo toro boe maereu ka. Nonore mareboe doge eimijera umoduie turokogado Jesusji tuwo Jesus meardae pegado tumeardaeji. ");
INSERT INTO bor_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Torore merire quarenta Jesusji. Nou meri jameduji Jesus okwagekare iaboeji iaboeji. Dukodire uke boeire ji. ");
INSERT INTO bor_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nono nou mareboe aregodure Jesus ae rugadu. Akore: – Pao Kurireu onaregedu remawu mode aki dukeje amagodo awu toriji uwo tudo nono amireu mogadure awo kowuje. ");
INSERT INTO bor_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus akore: – Padure bapera kejewu Pao Kurireu bataru koiare iromodukare nono ameardae mogadure. Nou bakaru akore: “Boe eke mitodu tabo karega imedu rakojemode moto keje mare Pao Kurireu o bataru jamedu boe tabo.” ");
INSERT INTO bor_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mareboe eimijera uture Jesus apo toro Jerusalém ba kurireu ka. Uture apo toro Pao Kurireu uwai ričoreu ao ka. ");
INSERT INTO bor_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nono makore Jesusji pugeje. Akore: – Pao Kurireu onaregedu remawu mode aki dukeje amode akaredo awu bai ričoreu ao piji toro moto ka. Padure bapera kejewu Pao Kurireu bataru akore tumoduie tudugarege baru tadawuge ekera bararedo ai. Etu pemegamoduie ai akawo akogorido. Awure jamedu jetumodukaie toriji. ");
INSERT INTO bor_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mare Jesus akore: – Boro iromodukare aino. Nou padure bapera kejewu Pao Kurireu bataru remawu akore: “Boe ekawo turokogado Pao Kurireuji.” ");
INSERT INTO bor_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Dukejere nou mareboe eimijera uture Jesus apo toro ia tori kurireu ao ka. Ure Jesus jordudo moto jamedu boeji tači je. Akore: – Awu moto jamedu boe makudure inai inoče. Awu moto kejewuge eimijera nure imi. Itaidumode dukeje imode awu moto maku itaidure jiwuge etai. Ča amode apu jodo iogorai akagomode akaiduie i amoduie akimijerado imi ameartoruwo i dukeje imode awu moto jamedu boe maku akai, imode awu moto kejewuge eimijerado aki. ");
INSERT INTO bor_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus akore: – Boro. Iromodukare aino. Padure bapera kejewu Pao Kurireu bataru akore: “Boe etaiduwo tu Pao Kurireuji ewo tubu jodo moto keje tu Pao Kurireu jokorai emago pemegawo tu Pao Kurireuji rugadu. Boe emeartoruwo tu Pao Kurireuji rugadu.” Mare akiere Satanás. Mareboe nure aki rugadu. Ča atudo ipiji. ");
INSERT INTO bor_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dukodire mareboe eimijera uture Jesus piji rugadu. Nono Pao Kurireu utugarege baru tadawuge etaregodure Jesus ae. Etu pemegare Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mare boe eimijera ure João Batista tugu baičoreuto. Ča Jesus meardure nou inoduji dukeje ure tugirimi Galiléia moto ka Nazaré ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nono Jesus uture Nazaré ba kurireu piji. Uture toro Cafarnaum ba kurireu ka. Nou Cafarnaum ba kurireu mugure nou pobo maereu okwai. Nou pobo maereu iere Galiléia. Naftali moto kejere nou Cafarnaum ba kurireu mugure. Nou Cafarnaum ba kurireu mugu puredure Zebulom motoji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dukodire ia Pao Kurireu bataru jeture pudui. Nou makore Pao Kurireu bataru jiwu imedu Isaías ure nou bataru bu bapera keje. Akore: ");
INSERT INTO bor_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","– Nou iere Galiléia aino jiwu pobo maereu okwai Zebulom moto mugure, Naftali moto mugure jamedu. Boe ekodumode nou moto kajeje taregoduwo nou pobo maereu ka, taregoduwo Jordão Po ka jamedu. Boe tuginaiwuge emugure nou moto keje jamedu. Nou boe emugu pemegakare. Emugure boečo tada. Emugure kejewu moto ure nono bireuge eda mogadure. Mare boečo ji karega inagoino. Nou boe erduware tuwimoduie. Dujire inagoino. Erduwakare tuwo tuginorudo nou tuwi piji. Dujire inagoino. Mare aino erdure ia jorugu kurireuji. Ure nono meri joku rutu mogadure. Mare jorugu ji karega inagoino. Meri joku rutu ji karega inagoino jamedu. Umode boe ekinorudowu jire inagoino. Boe erduware umode boe ekinorudowuji. Dujire inagoino. Ainore Pao Kurireu akore marigudu. Aino čare Jesus aregodure. Dujire nou Pao Kurireu bataru akoino. ");
INSERT INTO bor_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nou meri kejere Jesus makogodure boei. Makore tu tu je boe ewiagai tuwo boe erduwado Pao Kurireu meardaeji. Akore: – Tagera ra taro pegareu piji. Kuri aino Pao Kurireu umode boe eimijera kurireudo pudumi rugadu. ");
INSERT INTO bor_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ia meri keje Jesus merure nou Galiléia Po Maereu okwaji. Nono jordure Simãoji nono pobo okwai. Nou Simão iere Pedro jamedu. Jesus jordure nou Simão umanaji jamedu. Nou umana iere André. Nou ime pobedu doge ere tuwuge barigu poboto kare ewagai. Emaragodae reno. ");
INSERT INTO bor_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nono Jesus makore etae. Akore: – Mato itabo. Imode tawogudo ime ewagai. Mare tawogu ji karega inagoino. Tamode boe emeartorudo Pao Kurireuji. Dujire inagoino. Ainore Jesus akore. ");
INSERT INTO bor_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ča nou ime pobedu doge ere tugera ra tuwuge piji tači je. Eture Jesus apo rugadu tumaragodae piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eture ji je dukeje erdure ia boei pugeje. Zebedeu ore ime nure emage. Ere pobe. Ia iere Tiago. Nou uwie imedu iere João. Emugure tuo apo to ika kurireu tada. Emaragodure tuwugeji tuwo tuwuge pemegado. Nono Jesus makore etae. ");
INSERT INTO bor_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ča eture to ika kurireu piji kuri je. Nono eture tuo piji tuduwo Jesus apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nono Jesus kodure nou Galiléia moto jamedu boe parugajeje tuwo boe eiamedu boe erduwado Pao Kurireu bataruji. Ure turemo tu tu nou Judeu doge ere bato puiwu to baito tuwo erduwado nono. Ure ewie tu tu je Pao Kurireu umoduie boe eimijera kurireudo pudumi kuri aino rugadu. Ure kogodureuge epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nou Jesus akaru ure tumaedo Síria moto jamedu boe ka. Dukodire boe etaregodure Jesus bagai kogodureuge eiamedu boebo. Iage etaora, emorora, ekana, epogora korire ei rugadu. Bope doge emedure iage etada. Iage epogora pegare emeru bokware. Iage ewi kigodure tu tu je tumagadu tabo. Jesus ure awu kogodureuge eiamedu boe epemegago. ");
INSERT INTO bor_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Boe emagare taregodu tabo Jesus ae tuduwo Jesus apo rugadu. Boe etaregodure Galiléia moto piji, Decápolis moto piji, Jerusalém ba kurireu piji, Judéia moto piji. Nou torowu Jordão Po bakowu kejewuge boe ekurugodure nou pobo kajeje mato Jesus ae tuduwo apo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus jordure nou boei dukeje ruture ia tori kurireu ao ka. Nono ure tumugudo. Nou ure jorduwadowuge etaregodure Jesus ae jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nono Jesus makore ei tuwo erduwado. Akore: – ");
INSERT INTO bor_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ia boe enojarokare pudui. Dukodire eragojemode Pao Kurireu apo. Ere tugimijerado ema dukodire eragojemode apo rugadu boe pemegareu keje. Dukodire egaremode pudui. Boe pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ia boe etragudure tugiarigodure dukodi. Mare du inodu tabo Pao Kurireu umode ewudugugo. Dukodire egaremode pudui rugadu. Boe pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ia boe emaragodu pemegamode tugimijera ai mare ekorigodumodukare ji rugadu. Mare Pao Kurireu umode tumagore jiboe maku nou maragodu pemegareuge etai rugadu. Dukodire egaremode pudui. Boe pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ia boe ere turagado pudui tumeartoruwo Pao Kurireuji tuwo turo jetorodo. Ewiagorore tu turo pemegawo tu rugadu. Ewiapagakare iaboeji iaboeji. Dukodire Pao Kurireu umode turaga maku etai rugadu ewo turo jetorodo. Dukodire egaremode pudui. Boe pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ia boe enogudugodure boebo rugadu. Dukodire Pao Kurireu okudugodumode ebo nou ero jipagi. Dukodire boe pemegamode ei rugadu. Egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ia boe emeardae pegareu bokware. Emeardae pemegare. Boe pemegamode ei rugadu. Erdumode Pao Kurireuji tuioku tabo rugadu. Dukodire egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ia boe erugodukare boei. Emago kigodure boei erugodukawo pui pugeje epemegawo pui rugadu. Boe pemegamode nou boei. Pao Kurireu umode toredo emage. Dukodire egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ia boe emeartorure Pao Kurireuji dukodire ro pegareuge emago pegare ei, ero pega kigodure ei. Mare du inodu tabo boe pemegamode nou meartorure Pao Kurireu jiwugei. Ere tugimijerado Pao Kurireuče dukodire eragojemode Pao Kurireu apo rugadu boe pemegareu keje. Dukodire egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Tameartorumode imagore tai jiboeji dukodire boe emago pegamode tarore jiboeji boe emeartorukawo tai pugeje. Tagodumode iwadaru kodaji dukeje boe emago pegamode tai, ero pegamode tai, egomode taro pegaie tuwadrarodu tabo. Ainore ewobe emago pegare jamedu jaoboei. Mariguduwuge ewobe ero pegare nou mariguduwuge makore Pao Kurireu bataru jiwugei jamedu. Mare tare tameartorudo i dukodire emago pegare aino tai jamedu. Mare kočare tameartorukaba egoino jiboeji. Taegaredo tai. Mare paga karega. Pao Kurireu umode mori kurido tagai toro baru tada. Dukodire čare taegaregodumode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesus mako kimore. Akore: – Tameartorure i dukodire tare nono sal mogadure. Sal pemegare. Mare nou sal pegomode dukeje nou sal akedumode. Nono umodukare nono sal mogadure pugeje. Dukodire boe eromodukare iaboeji nou sal tabo pugeje. Emode barigu. Ewure jomode keje. Mare sal ji karega inagoino. Tameartorure i. Dujire inagoino. Tagaba tagera ra tameartorure i dupiji. Nono meartorukareuge erdumode taro pemegareuji. Nono etaidumode tumeartoruwo i jamedu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","– Tameartorure i dukodire tare nono jorugu mogadure. Boe emode jorugudo ia tori kurireu ao keje dukeje boe eiamedu boe erdumode joruguji. ");
INSERT INTO bor_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Boe emode pori bu jorugu aogeje dukeje urugumodukare. Mare boe emode jorugu bararedo, uruguwo pudui. ");
INSERT INTO bor_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mare jorugu ji karega inagoino. Tameartorure i. Dujire inagoino. Tamodukare tagera ra tameartorure i dupiji dukeje boe erdumode taro pemegareuji. Dujire inagoino. Boe erdumode taro pemegareuji dukeje emago pemegamode tameartorure jiwu Pao Kurireuji. Emagomode Pao Kurireu bagai baruto. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","– Ia boe egore itaregoduie iwo Moisés ure maku Judeu doge etaiwu bakaru akedudo. Mare itaregodukare iwo nou bakaru akedudo. Ia boe egore itaregoduie iwo makore Pao Kurireu bataru jiwuge emagore jiboe akedudo. Mare itaregodukare iwo nou emagore jiboe akedudo. Itaregodure iwo Moisés ure maku Judeu doge etaiwu bakaru makore jiboe jetudo pudui. Itaregodure iwo nou makore Pao Kurireu bataru jiwuge emagore jiboe jetudo pudui. ");
INSERT INTO bor_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Moisés makore jiwu Pao Kurireu o bakaru jetumode pudui rugadu. Nouia makore Pao Kurireu bataru jiwuge emagore jiwu Pao Kurireu o bakaru jetumode pudui rugadu. Nou Pao Kurireu o bakaru tadawu ia bataru rogu akedumodukare piji rugadu jii toro moto akedumode du ka, jii toro baru akedumode du ka. Nou makore jiboe jamedu boe jetumode pudui rugadu. Boe jokodu jire inagoino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ia boe emeartorumodukare awu Pao Kurireu bakaru tadawu bataru roguji. Emode ia boe emeartoru bokwado nou bataru roguji jamedu dukeje Pao Kurireu umode boe eimijerado pudumi dukeje mako pegamode ei. Akomode nou roinowugei: – Itugarege jorduwakareuge nure tagi pemegakareuge nure tagi. Ainore Pao Kurireu akomode ei. Umode boe eimijera kurireudo pudumi dukeje ainore akomode ei rugadu. Mare ia boe emeartorumode awu Pao Kurireu bataruji, emode boe erduwado awu Pao Kurireu bataruji dukeje Pao Kurireu mako pemegamode ei. Akomode ei erduwaie epemegaie ekurie nou tudugarege eiamedu boe ekori. Pao Kurireu umode boe eimijera kurireudo pudumi dukeje ainore akomode ei. ");
INSERT INTO bor_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iwo tawie. Pao Kurireu umode boe eimijera kurireudo pudumi rugadu. Mare tamodukare taro jetorodo fariseu doge ero kori dukeje tagimijera umodukare Pao Kurireuče. Tamodukare taro jetorodo nou jorduware Judeu doge eno bakaru jiwuge ero kori dukeje tagimijera umodukare Pao Kurireuče. ");
INSERT INTO bor_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","– Marigudu Pao Kurireu makore boei ekawo boe ewido. Tarduware nou bataruji marigudu. Pao Kurireu akore boe emoduie boe ewido dukeje boe eimijerage emoduie boe pegado ei ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mare imode tawie Pao Kurireu meardae remawuji. Boe ekorigodumode timediaji dukeje Pao Kurireu umode boe pegado ei nono turo moga nou ure boe ewidowu jitu mogadure. Ia pugeje. Ia boe akomode timediaji boe kaieguie ema dukeje nou metia umode nou akoino puduiwu reko Judeu doge ekimijerage etae ewo boe pegado ji nou bataru pegareu moriče. Ainore tarore. Mare imode tawie Pao Kurireu meardae remawuji. Ia boe akomode timediaji jorduwa bokwaie rugadu dukeje boe pegamode ji rugadu. Umodukare togwa ra nou tuwadaru pegareu piji dukeje barigudumode bope doge eda kejewu joru pegareuto rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dukodire imode tawie. Tagaregodumode Pao Kurireu uwai ka ia tagoe tabo tawo maku Pao Kurireu ai. Mare tagaregodu keje tawiabuture ia taro pegare tamedia jitu keje. Nou tamedia jordu pemegakaie nou taroino pudui duji. ");
INSERT INTO bor_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Dukodire tamode nou tagoe bu moto keje nono Pao Kurireu uwai tada taduwo kuri nou tamedia bagai. Tardumode nou tamediaji dukeje tamago pemegado ji tagiarigoduie nou taro pegareuji, tamodukaie nou taro towuje pugeje. Dutabore tamode tabemegado ji pugeje. Tabemegamode pui pugeje dukeje tamode tagirimi Pao Kurireu uwai ka tawo nou tagoe maku Pao Kurireu ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ia boe ekorigodumode tai. Egomode tumoduie tarego boe eimijera kurireu ae tumago pegawo ia tarore jiboeji nou boe eimijera biagai. Nou boe eimijera makomoduie tai tawo iaboe maku nou boe etai taro pegareu moriče. Nou boe eimijera umoduie tamagu tugobaigarege etai. Umoduie tadugu baičoreuto. Ainore nou korigodure taiwuge egomode. Parduwakare boemode aino tai rugadu duji. Dukodire imode tawie. Ia boe ekorigodumode tai. Emagomode tai tumoduie tarego boe eimijera bagai aiwowo ia taro pegareu bagai dukeje tamago pemegado ei tawo nou boe ekorigoduredu barigu epiji. Taro pemegado ei ekorigodukawo tai pugeje kuri je. ");
INSERT INTO bor_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Boe jokodu jire inagoino. Tamodukare tabemegado nou korigodure taiwugei dukeje emode tarego boe eimijera bagai rugadu. Nou boe eimijera umode tadugu baičoreuto rugadu. Taedumode nono jii tamode taro pegareu morido du ka. ");
INSERT INTO bor_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","– Marigudu tarduware bakaruji rugadu. Akore boe eribarikaiago toreduje piji toredu piji. ");
INSERT INTO bor_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mare aino čare imode tawie Pao Kurireu meardae remawuji. Boe etaiwomode areduji tumeardae pegareu tabo tuwo tugeragu nou areduji. Dutabore emeardae ure nono boe ero moga tieribari tabo jitu mogadure Pao Kurireu jakai. Dukodire Pao Kurireu jordu pegare nou emeardaeji. ");
INSERT INTO bor_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Boe etaidukare tuioku bokwawo. Mare epagudure tuwariguduwo bope doge eda kejewu joru pegareuto rugadu. Dukodire imode tawie. Taeku umode tameardae pegado dukeje nou taeku tawuje. Mare taeku remawu ji karega inagoino. Tagaidure jiwu tameardae pegareu jire inagoino. Nou tameardae pegareu barigu tagaora piji rugadu tameardaekawo nou tameardae pegareuji pugeje. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Boe etaidukare tugera kadoduwo tugana piji. Mare epagudure tuwariguduwo bope doge eda kejewu joru pegareuto rugadu. Dukodire imode tawie. Tagera umode taro pegado dukeje nou tagera kado tagana piji rugadu. Mare tagera remawu ji karega inagoino. Tagaidure jiwu taro pegareu jire inagoino. Nou taro pegareu barigu tabiji rugadu tarokawo nou taro pegareuji pugeje. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","– Marigudu Moisés ure taro maku tagai. Akore ia imedu umoduie tugera ra toreduje piji dukeje umoduie bapera atugodo tuwo maku toreduje ai tuwo toreduje bie tuie tugera ra piji duji. Umoduie tugie bu nou bapera atugododureu keje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mare imode tawie Pao Kurireu meardae remawuji. Imedu umode tugera ra toreduje piji mare mugumode ia aredu apo pugeje. Du pegare Pao Kurireu jakai rugadu. Nou imedu ro peganure nou toreduje boetojiwudo piji rugadu. Ure tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai. Mare imedu oreduje jeribarimode nou toredu piji dukeje nou imedu aidumode tuwo tugera ra toreduje piji du pegakare. Mare imedu oreduje jeribarikare toredu piji mare nou imedu umode tugera ra toreduje piji dukeje ro peganure nou toredujeji rugadu. Turoino dutabo umode toreduje udo nono jeribarire toredu pijiwu aredu mogadure Pao Kurireu jakai. Imedu jamedu mugukawo ia aredu ure tugera ra toredu pijiwudo apo. Mugumode apo dukeje umode tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","– Marigudu Pao Kurireu makore boei emagomoduie Pao Kurireu ie tabo turomode jiboeji dukeje ekawo tuwadaru pogurudo. Mare boe emagomoduie Pao Kurireu ie tabo dukeje nou emagore jiboe ewo towuje rugadu. Tarduware nou bataruji marigudu. ");
INSERT INTO bor_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Mare imode tawie Pao Kurireu meardae remawuji. Tamagokaba iaboe iaboe ie tabo. Mare tamagodo tameardae pemegareuji. Tawadrarodukaba rugadu. Tamagomode jiboe jetudo pudui rugadu. Tagaba tawadaru pogurudo. Tamagomode uu taromoduie ia taroji dukeje tarodo ji rugadu. Tamagomode boro taromodukaie ia boe eroji dukeje tarokaba ji rugadu. Ia boe emagore baru ie tabo tuwo boe emeartorudo tuwadaruji. Mare tamagokaba baru ie tabo. Nonore Pao Kurireu mugure. Ia boe emagore moto ie tabo tuwo boe emeartorudo tuwadaruji. Mare tamagokaba moto ie tabo. Nonore Pao Kurireu umode tuwure udo tamudo. Ia boe emagomode Jerusalém ba kurireu ie tabo tuwo boe emeartorudo tuwadaruji. Tamagokaba Jerusalém ba kurireu ie tabo. Jerusalém tadare Pagimijera Kurireu mugumode rugadu. Ia boe emagomode taora ie tabo tuwo boe emeartorudo tuwadaruji. Mare tamagokaba tagaora ie tabo. Taroiwakare tawo tagao čoreu kigadudo. Taroiwakare tawo tagao kigadureu čodo pugeje. Tu Pao Kurireu emare roiware tuwo boe etao udo nono tumeardae mogadure. Dukodire inagoino. Tawadrarodukaba. Tamagore jiboe jamedu boe jetudo pudui rugadu tawo boe emeartorudo tawadaruji. Mareboe aidure boe ewadraroduwo boe emeartorukawo pui. Dukodire nou mareboe meardae jire boe eroino tumagowo iaboe ie tabo ia tumagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","– Marigudu Pao Kurireu ure boe ewie nuba eromoduie tuwo ia boe ero pegare jiboe morido etai. Akore boe erowo ji nono ro pegare jitu mogadure. Ia boe umoduie ia timedia joku pegado dukeje boe ewo nou ro pegare timedia jiwu joku pegado jamedu ro pegare timedia jitu moriče. Ia boe umoduie ia timedia o kado dukeje boe ewo nou ro pegare timedia jiwu o kado jamedu ro pegare timedia jitu moriče. Tarduware nou Pao Kurireu bataruji marigudu. ");
INSERT INTO bor_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mare imode tawie Pao Kurireu meardae remawuji rugadu. Tagaba ro pegareu rore taiboe morido ai. Ia ro pegareu umode tugera to taeji tae abowu metia maku ai jamedu uwo tugera to ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ia boe etumode boe eimijera bagai tuwo tugeragu tagudau meture taiwuji tabiji dukeje maku etai rugadu. Mare ia tagudau okwatorureu biaku epa maku etai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ia boe tuginaiwuge tugobaigarege ero rakamode tai tagoreduwo toe tabo pudai jii quilômetro oto pa ka tageragu ji tagoreduwo tabo rugadu. Mare quilômetro udo pobe taroino enoe tabo duji. ");
INSERT INTO bor_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ia boe enogwamagudumode tai iaboe bagai dukeje maku etai rugadu. Ia boe enogwamagudumode tai ia tago diero bagai mare ia meri kejeie tumoduie morido tagai dukeje diero maku etai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","– Marigudu Pao Kurireu akore boe emeardu kuriwo tumedagei tuwobei. Marigudu tagimijerage egore boe erdu pegawo jordu pegare puduiwugei. Tameardure nou bataruji marigudu. ");
INSERT INTO bor_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mare imode tawie Pao Kurireu meardae remawuji. Tameardu kurido jordu pegare taiwugei, onare taiwugei. Tamagodo baruto Pao Kurireu bagai nou ro pegare taiwuge eparu tabo. ");
INSERT INTO bor_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dukodire čare boe erduwamode Pao Kurireu ore nure tagi duji. Pao Kurireu emare ure meri joku jorugudo ro pemegareugei ro pegareugei jamedu. Emare ure bubutudo ro pemegareuge eno moto keje ro pegareuge eno moto keje jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tameardu kurimode tu ro pemegare taiwugei dukeje taro pemegamodukare ro pegareuge ero kori. Nou ure tugeragu boe enoe mori jiwu imedu ro pemegare nou ro pemegare puduiwugei jamedu. Mare tameardu kuriwo boe eiamedu boei nono Pao Kurireu umode boe pemegado tai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tagimadumode tu tawobebo tu tamedagebo dukeje taro pemegamodukare ro pegareuge ero kori. Ro pegareuge meartorukare Pao Kurireu jiwuge ekimadure tuwobebo tumedagebo jamedu. Mare tagimaduwo boe eiamedu boebo. Nono Pao Kurireu jordu pemegamode tarore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dukodire inure tawie. Taro jamedu boe pemegado nono Pao Kurireu ro pemegareu mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","– Taro pemegamode boei tu boe egai mare boe etaiwokare dukeje tamodukare taro pemegado boei dukeje Pao Kurireu umodukare nou taro pemegareu morido baru tada. ");
INSERT INTO bor_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dukodire tamode ia tagoe maku marenarue doge etai dukeje tagaba boe ewie tapira ukiga tabo. Ia meartorukare tuwadaru jiwuge emode boe edo tapira ukiga akodo Judeu doge ere bato puiwu bai tada, awara okwai jamedu tuwo boe eiamedu boe ewie tuie ia toe maku marenarue doge etai. Etaidure tuwo boe emeardae pemegado pudui. Dukodire boe emago pemegamode ei eroino nou marenarue dogei duji. Mare ere turo pegareu biado boe epiji. Dukodire boe emago pemegare ei du morimode tu nouče rugadu. Mare Pao Kurireu umodukare nou ero pemegareu morido etai. ");
INSERT INTO bor_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Iwo tawie. Tamode iaboe maku marenarue doge etai dukeje tagaba boe ewie taroino duji. Tagaba tamedage ewie. Tagaba tawobe ewie taroino duji. ");
INSERT INTO bor_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aino taro pemegareu biadodumode boe epiji. Mare Pao Kurireu jordumode tarore jiboe jamedu boeji. Emare umode nou taro pemegareu morido tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","– Ia boe emeartorukare tuwadaruji. Emagere etaidure tuwo turagojedo nono Judeu doge ere bato puiwu bai tada tumagowo baruto Pao Kurireu bagai boe erduwo turoinoduji. Etaidure turagojewo nono awara kajeje nono boe eda oiadada tumagowo Pao Kurireu bagai baruto boe eiamedu boe erduwo turoinoduji. Iwo tawie. Tarokaba nono ero mogadure tamagowo Pao Kurireu bagai baruto. Boe erdure egoino duji. Dukodire boe emago pemegamode ei. Du erore ainodu morireu tu rugadu. Mare Pao Kurireu jorduware boe remawuji. Dukodire meardae pemegamodukare ei nou eroino duji. ");
INSERT INTO bor_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mare tagi taremo tawaito tamagowo baruto Pao Kurireu bagai. Tawai bai poro mi tawo taro biado boe epiji. Boe erdukare Pao Kurireuji mare Pao Kurireu jordure boe erore jiboe jamedu boeji. Dukodire umode nou tare biadowu taro pemegareu morido rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tarokaba nono meartorukare Pao Kurireu jiwuge ero mogadure tamagowo Pao Kurireu bagai baruto. Meartorukare Pao Kurireu jiwuge emago raimode tumeartorure jiwu bagai. Emode tuwadaru udo nono tuwadarure tu tu je tumago raiwo tumeartorure jiwu bagai. Egore boe emodukaie tuwadaru udo nono tuwadarure tu tu je dukeje tumeartorure jiwu meardumodukaie tumagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tarokaba nono ero mogadure. Tamagokare tagaidure jiboe bagai raga mare Pao Kurireu jorduware marigudu tagaidure jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dukodire imode tawie. Tamagore Pao Kurireu bagai baruto dukeje ainore tagagomode: “Iogwa Kurireu. Mugure baru tadawu nure aki. Boe emago pemegawo akieji tuwo boe emeartorudo tu ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Boe emeartoruwo awadaru jamedu boeji tuwo tugimijera kurireudo aki rugadu. Akaregodu pemegado aro pemegareu tabo mato moto ka ameardae rugadu boe jetuwo pudui rugadu, nono aro mogadure toro baru tada dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Čege maku čenai meri jameduji. ");
INSERT INTO bor_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Awiagodudo čero pegareu piji nono čewiagodure ro pegare čeiwuge ero piji dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iage etaidumode tuwo tumeardae pegareu maku čenai tuwo čero pegado. Čeginorudo epiji čewiapagakawo nou emeardae pegareuji. Čeginorudo mareboe piji rugadu. Mare paga karega. Boe eimijera kurireu nure aki. Aragare boe jamedu boe kori. Apemegare rugadu. Are aino jii toro rugadu. Ainore uwo rugadu.” – Ainore tagagomode Pao Kurireu bagai baruto. ");
INSERT INTO bor_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","– Tawiagodumode ro pegare taiwuge ero piji dukeje Pao Kurireu biagodumode taro pegare jiboe piji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mare tawiagodumodukare ro pegare taiwuge ero piji dukeje Pao Kurireu biagodumodukare taro pegare jiboe piji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","– Ia tagimijerage emeartorukare tuwadaruji. Etaidure tuwo turo pegareu biado boe epiji. Mare emode tugera ra togwage piji ia meri keje tumagowo Pao Kurireu bagai baruto nou meriji dukeje emode tie makodudo. Mare pagare eroino. Emode tie makodudo boe erduwo pudui boe emeardae pemegawo pudui. Dukodire etaidure boe erduwo turoino duji. Boe erdure eroino duji. Dukodire boe emago pemegamode ei eroino duji. Dukodire nou boe emago pemegare pudui nou morimode tu nouče rugadu. Mare Pao Kurireu jorduware boe remawuji. Dukodire Pao Kurireu meardae pemegamodukare ei eroino duji rugadu. Ča. Iwo tawie boe remawuji. Tarokaba nono ero mogadure. ");
INSERT INTO bor_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tamode tagera ra tagwage piji tu tu ia meri keje tamagowo Pao Kurireu bagai baruto dukeje nou taro biado boe epiji. Tae kabi. Puduga tugu tagaoji. Roreboe reko tawiriji. Tae makodukawo. ");
INSERT INTO bor_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nono boe erduwamodukare tare tagera ra tagwage piji. Tu Pao Kurireu jorduwamode taroino duji. Boe erdumodukare Pao Kurireuji. Mare Pao Kurireu jordure boe ere biadowu turore jiboe jamedu boeji. Dukodire emare umode taro morido rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","– Tawiagorokaba tu tawo tagoe kurido woe moto keje. Tamode tagoe kurido woe moto keje mare boreu umode tagoe pegado. Tagoe akedumode. Iwogureuge ekiwogumode tagoeji tabiji. ");
INSERT INTO bor_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mare tawiagorodo tawo tagoe kurido baru tada. Mare moto kejewu tagoe ji karega inagoino. Tawiagorodo tameartoruwo Pao Kurireu bataruji, tameardu kuriwo Pao Kurireuji. Dujire inagoino. Tawiagorodo tawo taro pemegado. Dujire inagoino. Tameartorumode Pao Kurireuji dukeje umode boe pemegado tai baru tada. Dujire inagoino. Baru tadare boreu umodukare boe pegado. Iwogureuge ekiwogumodukare nou Pao Kurireu ro pemegareuji tabiji. Nou boe pemegare taiboe akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Boe etaidure tuwo toe kurido woe moto keje dukodire ewiagoromode tu nou toeji rugadu. Nou boe ewiapagamodukare Pao Kurireu bataruji. Mare boe enoe jetumode baru tada dukodire ewiagoromodukare ia moto kejewu toeji pugeje, ewiapagamode tu Pao Kurireu bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","– Tuioku tabore boe erdumode boeji. Mare boe eku pegare dukeje erdumodukare boeji. Imagore jiboe ure nono boe eku mogadure. Mare boe eku ji karega inagoino. Boe emeartorumode imagore jiboeji dukeje erduwamode rugadu. Dujire inagoino. Mare boe emeartorumodukare imagore jiboeji dukeje erduwa bokwamode rugadu. Dujire inagoino. Dukodire tagi tagaidumodukare tarduwawo iwadaruji dukeje boečomode tai rugadu. Mare boečo ji karega inagoino. Tarduwamodukare boe pemegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","– Ia imedu ukimijerage emode pobe dukeje meardu kurimode nouia tugimijeraji. Mare jordu pegamode nouia tugimijeraji. Meartorumode nouia tugimijera bataruji. Mare meartoru bokwamode nouia tugimijera bataruji. Dukodire boe emode tugimijerado dieroče dukeje ewiapagamodukare tumeartoruwo Pao Kurireuji pugeje. ");
INSERT INTO bor_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tamororamagadukaba tage bagai, tagudumode čeboe bagai, tagudau areia bagai. Pao Kurireu ure tadowuje. Ure tawodudo. Emare jetu pemegamode tai. ");
INSERT INTO bor_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tagaiwodo awu kiebaregei. Ekare boe tugu. Ekare tugeragu boeji. Eke ja bokware. Eke muga bokware. Mare du inodu tabo Pao Kurireu koiare ure enogwagedo. Boe nure tagi. Pao Kurireu meardu kurire boei nou kiebarege ekori. Dukodire inagoino tai jetu pemegamoduie tai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tamororamagadumode mare du inodu tabo tamodukare tawimode kejewu meri barigu tabiji. ");
INSERT INTO bor_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","30","Tamororamagadukaba tagudau areia bagai. Tagaiwodo awu okureboeji. Emodure rugadu mare emage eigoia karega ere tumodudo aino. Pao Kurireu koiare ure awu okureboe emodudo aino. Mariguduwu Israel doge eimijera kurireu Salomão oe kuričigore dukodire meture jiwu ukudau areia moture rugadu. Mare motukare nono awu okureboe emodu mogadure. Ča okureboe emodure mare joru umode ekowu kuri je. Mare boe nure tagi. Pao Kurireu meardu kurire boei nou okureboe kori. Dukodire umode tugera maku tagai rugadu. Dukodire inagoino tai tamororamagadukaiago tagudau areia bagai, tameartoruwo tu Pao Kurireuji rugadu. Tameartorumode ji dukeje tamode nono awu okureboe emogadure jamedu. Pao Kurireu jetu pemegamode tai rugadu. Kočare tameartorukare ji. ");
INSERT INTO bor_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dukodire inagoino tai tamororamagadukaiago tagwagemode jiboe bagai tagudumode čeboe bagai. Tamororamagadukaba tagudau areia bagai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","34","Mare meartorukare Pao Kurireu jiwuge ewiagorore tu nou tuge roguji toe roguji rugadu. Mare tameartorumode Pao Kurireuji dukeje tawiagoromodukare nou inoduji pugeje. Pao Kurireu jorduware kaba jiba tagaidure. Dukodire tawiagorodo tawo tagimijera kurireudo Pao Kurireuče rugadu. Tawiagorodo tawo taro jetorodo nono Pao Kurireu meardae mogadure. Tamode tagimijerado ema dukeje umode tage jamedu boe maku tagai rugadu. Umode tagudau areia maku tagai. Jetu pemegamode tai rugadu. Tamororamagadukaba barogwato boe pegamode tai du bagai, boe rakamode tai dubagai. Boe rakare boei meri jameduji. Mare tamode tagimijerado Pao Kurireuče dukeje umode tugera maku tagai awu meriji rugadu. Umode tugera maku tagai barogwato jamedu. ");
INSERT INTO bor_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","– Tawiapagakaba boei boe pegareu tabo. Tawiapagamode boei boe pegareu tabo dukeje Pao Kurireu biapagamode tai boe pegareu tabo jamedu. Tameardae pegamode boe erore jiboeji tamago pegawo nou boei dukeje Pao Kurireu meardae pegamode tarore jiboeji jamedu tumago pegawo tai jamedu nono tamago mogadure. Tamode tameardae tawuje taro pegawo ia tamediaji nou tamedia ro pegareu moriče. Aino jamedu Pao Kurireu romode aino tai taro pegareu moriče nono taro moga tamediaji dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Meartorukare tuwadaru jiwuge nure tagi. Tardure tamedia joku tadawu boebutu roguji. Mare tardukare taeku tadawu iraji. Mare boebutu rogu ji karega inagoino. Boe ero pegareu rogu jire inagoino. Biagare tu je mare tardure ji. Dujire inagoino. Dukodire tamago pegare nou tamediaji. Tagagore: “Aro pegare”, aino ji. Tagagore tarduwaie tamedia ro pegareuji mare tardukare ia taro pegareuji. Dukodire tameartorukare tawadaruji. Tardukare taeku tadawu ira kurireuji. Mare ira ji karega inagoino. Taro pegareu kurireu jire inagoino. Taro pega kurire rugadu mare tagare tardudo ji. Dujire inagoino. Kočare. Tagera ra taro pegareu piji. Tamode tagera ra taro pegareu piji dukeje tarduwamode rugadu tamago pemegawo nou tamediaji nou tamedia uwo tugera ra turo pegareu biagareu piji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","– Tagaba Pao Kurireu maragodae pemegareu maku ariga doge etai. Mare ariga ji karega inagoino. Meartorukare Pao Kurireu jiwuge ro pegareuge eire inagoino. Tamode taragado tawo Pao Kurireu maragodae pemegareu maku nou meartoru bokware Pao Kurireu jiwuge etai dukeje nou meartorukare Pao Kurireu jiwuge ro pegareuge ekadakagirimode tai tuwo boe emeartoru akedudo tawadaruji. Emeardaere Pao Kurireu maragodae uie pagatu je. Dujire inagoino. Tagaba Pao Kurireu maragodae pemegareu maku jugureuge etai. Mare jugureu ji karega inagoino. Meartoru bokware Pao Kurireu jiwuge ro pegareuge eire inagoino. Tamode taragado tawo Pao Kurireu maragodae pemegareu maku nou meartorukare Pao Kurireu jiwuge etai dukeje emode tumeardae pegareu tawuje nou Pao Kurireu maragodae pemegareu piji tuwo nou Pao Kurireu maragodae pemegareu akedudo boe epiji. Emeardaere Pao Kurireu maragodae uie pagatu je. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","– Tagogwamagudumode Pao Kurireuji iaboe bagai dukeje Pao Kurireu umode tamagore bagaiboe maku tagai rugadu. Pao Kurireu aidure tuwo boe erduwado pudui. Dukodire taemarumode Pao Kurireu bagai dukeje umode tarduwado pudui rugadu. Pao Kurireu aidure tuwo tuwai poro jado baru tada tuwo boe edo turemo baruto. Dukodire tamode tagera to Pao Kurireu uwai poroji dukeje umode tuwai poro jado tagai rugadu. Mare bai poro ji karega inagoino. Boe emeartoruwo Pao Kurireuji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ro pegareuge ero pemegamode torei. Dukodire tagore emagomode tai amireu bagai tuge boei koia. Nono tamodukare tori maku etai. Tamode amireu maku etai rugadu eke boeire ei kodi. ");
INSERT INTO bor_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tagore emagomode tai karo bagai tuge boei koia. Nono tamodukare awagu maku etai. Tawogumode karo bagai ekeče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ro pegareuge nure tagi mare du inodu tabo tarduware taro pemegawo tagorei tawo eke maku etai rugadu. Tarduware tawo boe pemegareu maku tagore etai. Mare Pao Kurireu pemegare rugadu. Dukodire umode boe pemegareu maku boe etai rugadu du kodumode nou tare maku tagore etaiboe kori. ");
INSERT INTO bor_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dukodire ire tawie. Taro pemegado boei boetoji nono tagaidu moga boe ero pemegawo tai dumogadure. Du nono tameartorunure makudure Judeu doge etaiwu bakaruji. Tameartorunure nou mariguduwuge makore Pao Kurireu bataru jiwuge emagore jiboeji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","– Pao Kurireu meardae ure nono baiporo biagareu ja mogadure. Ure nono awara barikareu mogadure. Boe emode baiporo biagareu jado tugoduwo nou awara barikareuji taregoduwo Pao Kurireu ae. Mare baiporo ji karega inagoino. Awara ji karega inagoino. Pao Kurireu meardae jire inagoino. Taragado tai tawo tameardae pemegado nono Pao Kurireu meardae mogadure tawo taremo baruto Pao Kurireu mugureu ka. Dujire inagoino. Bope doge eimijera meardae pegareu ure nono baiporo kurireu ja mogadure. Bope doge eimijera meardae pegareu ure nono awara barireu mogadure. Boe emode nou baiporo kurireu jado tugoduwo nou awara barireuji dukeje ewarigudumode bope doge eda kejewu joru pegareuto rugadu. Mare baiporo ji karega inagoino. Awara ji karega inagoino. Bope doge eimijera meardae pegareu jire inagoino. Boe emeartorumode kuri je nou bope doge eimijera meardae pegareuji. Dujire inagoino. Meartorure jiwuge emagare rugadu. Dujire inagoino. Etaidure tuwo turemo baru tadawu Pao Kurireu uwaito rugadu mare ekare tugimijerado Pao Kurireuče. Dukodire umodukare edo turemo rugadu. Meartorure Pao Kurireu meardae remawu jiwuge emagakare. ");
INSERT INTO bor_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","– Taeku jado. Nouia boe emagomode tai tumagoie Pao Kurireu bataruji. Mare pagare egoino. Ewadrarodunure. Ere tudo nono ovelha doge emogadure. Mare ovelha ji karega inagoino. Ere tuwadaru motudo boe etaiduwo tumagore jiboeji. Mare pagare egoino. Etada ere nono rie pegareuge emogadure. Mare rie ji karega inagoino. Etadare emeardae pegareure. Ewadrarodure tuwo boe ekiripagado Pao Kurireu bataru remawu piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mare tagaiwodo erore jiboeji. Erore jiboe umode tarduwado ei. Erore jiboe ure nono kurodureu tudu mogadure. Boe emodukare tugeragu uva tuduji ia boto iku piji. Boe emodukare tugeragu figo tuduji ia boto iku piji jamedu. Emode tugeragu uva tuduji ia uva iku piji. Emode tugeragu figo tuduji ia figo i piji. Mare kurodureu tudu ji karega inagoino. Makore Pao Kurireu bataru jiwuge batrarodureuge eire inagoino. Ewadaru moture mare emeardae pegare dukodire erore jiboe pegamode jamedu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","I pemegareu tudu pemegamode. Tudu kurodumode dukeje betumode rugadu. Mare i pegareu tudu pemegamodukare. Nou i tudu pegamode rugadu. Pagodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I pemegamode dukeje tudu pegareu bokwamode. I pegamode dukeje tudu pemegareu bokwamode. ");
INSERT INTO bor_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ia i tudu pegareumode dukeje boe emode nou i kado rugadu. Emode barigu joruto. ");
INSERT INTO bor_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mare i tudu ji karega inagoino. Makore Pao Kurireu bataru jiwuge eire inagoino. Tumeardae jire erore aino. Dujire inagoino. Tagaiwo pemegado nou boe erore jiboeji tarduwawo ei rugadu. Nono tarduwamode makore Pao Kurireu bataru jiwuge remawugei, batrarodureugei jamedu. Tarduwa pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","23","– Ia boe egomode i: “Ikimijera. Ikimijera.” Ainore nou boe egomode i. Mare pagare egoino dukodire imodukare eremo baruto. Egomode: – Ikimijera. Ikimijera nure aki. Akie tabore imagore awadaruji boe ewiagai. Akie tabore ire bope doge ewarigu boe epiji. Akie tabore iro rakare rugadu tu tu je. Ainore nou boe egomode i. Mare imagomode ewadaru jipagi. Inagomode: “Pagare tagagoino. Iorduware tarore jiboeji. Tameartorukare Iogwa Kurireu meardaeji. Dukodire ikare iwobedo tagi. Ča. Tadudo ipiji rugadu. Ro pegareuge nure tagi.” Ainore inagomode nou boei rugadu. Dukodire inure tawie. Tu nou boe emeartorumode baru tadawu Iogwa Kurireu meardae jiwuge emode turemo baruto. Nou boe ere tugimijera remawudo Pao Kurireuče rugadu dukodire emode turemo baruto. ");
INSERT INTO bor_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","– Dukodire imode tawie aino. Boe ewiapagamode iwadaruji dukeje emeartorumode nou imagore jiboeji rugadu dukeje jorduwareuge emode emage. Jorduwareuge emode emage nono ia jorduware tuwo tuwai pemegadowu imedu mogadure. Nou imedu ure tuwai towuje. Ure iguru pemegareu tugu mototo rugadu tuwo tuwai pemegado bakuru ukawo tuwai butudo. ");
INSERT INTO bor_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nono bubuture rugadu. Pobo aregodure rugadu. Bakurure rugadu. Nou poborereu jeture nou imedu uwaiji. Mare nou uwai butukare rakare dukodi. Ča meartorure iwadaru jiwu jorduwamode tuwo boe pemegado pudui nono nou jorduwareu ure bai pemegado dumogadure. Mare bai ji karega inagoino. Boe ewiapaga pemegamode iwadaruji dukeje emeartorumode rugadu imagore jiboe jamedu boeji. Dukodire nou boe erduwamode rugadu dukodire boe pemegamode ei rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mare boe ewiapagamode iwadaruji mare emeartorumodukare nou imagore jiboeji rugadu dukeje jorduwa bokwareuge umode emage. Jorduwa bokwareuge umode emage nono ia jorduwa bokwareu imedu ro moga tuwai jitu mogadure. Nou imedu ure tuwai pemegado jamedu mare ure tugeragu iguru pegareuji. Ure tugu mototo mare ukare tugudu pemegado. ");
INSERT INTO bor_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nono bubuture. Nou pobo aregodure. Dukodire pobo jeture nou imedu ure towu baiji. Bakuru pegareu jetu rakare ji jamedu. Dukodire nou uwai buture tiaruru tabo rugadu. Ča nou meartorukare iwadaru jiwu jorduwa bokwamode dukodire boe pegamode ji nono boe pegare nou bai jitu mogadure. Mare bai ji karega inagoino. Boe emeartorumodukare tumeardure jiwu iwadaruji dukeje boe pegamode ei rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ča Jesus ure tumago akedudo. Mare nou biapagare nou Jesus bataru jiwuge eku kidure nou Jesus makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesus makore jiboe ukare nono nou boe eimijerage jorduware Judeu doge eno bakaru jiwuge ewadaru mogadure. Jesus mako pemegare mako jetorore rugadu dukodire boe erduware Pao Kurireu bataru remawu jire Jesus akoino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus ure turawuje tori ri ao piji. Mare boe eture rekodaji rugadu. Emagare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nono ia imedu kogodureu aregodure Jesus togi. Nou imedu kogodae pegare ji rugadu. Ure biri pegado rugadu. Nou imedu aregodure Jesus togi dukeje ure tubu jodo moto keje Jesus jokorai. Nono makore Jesusji. Akore: – Ikimijera. Aragare rugadu awo ipemegago. Akaidumode dukeje amode ipemegago rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nono Jesus ure tugera raido nou imedu ae. Ure tugera bu imedu keje. Nono Jesus makore ji. Akore: – Uu. Itaidure. Ča. Apemegare rugadu. Ča nou imedu pemegagodure tači je. Nou imedu biri pegakare pugeje. ");
INSERT INTO bor_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nono Jesus makore imeduji pugeje. Akore: – Amagokaba awu irore ai boeji. Atudo kuri nou Pao Kurireu uwai ka. Nonore amode nou ure Judeu doge enomea maku Pao Kurireu aiwu imedu jordudo awiriji. Jordumode apemegagodure duji rugadu. Nono amode nou Moisés makore jiwu mori maku ai rugadu nono paro mogadure. Nono nou ure boe enomea maku Pao Kurireu aiwu imedu umode nou are maku pudaiwu mori maku Pao Kurireu ai rugadu. Dukodire boe eiamedu boe erduwamode apemegagodure rugadu duji. Ainore Jesus makore nou imeduji. ");
INSERT INTO bor_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nono Jesus aregodure Cafarnaum ba kurireu ka. Nonore ia tugobaigarege eimijera aregodure Jesus ae rugadu. Okwamagudure Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Akore: – Boe eimijera nure aki. Itugare imedu padure toro iwai tada tugogodure dutabo. Kogodure rugadu dukodire meru bokware. Korire ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus makore ji. Akore: – Itumode toro awai ka iwo atugare pemegago. ");
INSERT INTO bor_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mare nou tugobaigarege eimijera makore Jesusji pugeje. Akore: – Boe eimijera kurireu nure aki rugadu. Atukaba iwai ka. Mare tu nou awadaru tabore amode itugare pemegago. Amagomode dukeje itugare pemegagodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ikimijerare. Tugobaigarege eimijera nure imi jamedu. Imagomode tugobaigare imeduji utuwo toro dukeje utumode toro rugadu. Imagomode iaji aregoduwo mato itae dukeje aregodumode itae rugadu. Imagomode itugareji maragoduiago ia imaragodaeji dukeje nou itugare maragodumode ji rugadu. Dukodire iorduware nou itugare kogodae meartorumode awadaruji nono nou itugare meartorure i dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus meardure nou tugobaigarege eimijera akoino duji dukeje Jesus jebogodure. Makore nou rakojere pudabowugei. Akore: – Iwo tawie. Judeu karegure ema mare awu imedu meartorure i rugadu Israel moto kejewu Judeu doge eiamedu boe emeartoru kori. ");
INSERT INTO bor_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","Marigudu Pao Kurireu makore Judeu doge ewagai emeartoruwo pudui. Makore ei tumoduie nou umode boe ekinorudowu arego etae. Abraão meartorure nou bataruji. Onaregedu Isaque meartorure. Isaque onaregedu Jacó meartorure jamedu. Dukodire toro ia meri keje Pao Kurireu umode boe ekimijerado pudumi dukeje umode ia tuwadae tawuje etai toro baru tada. Ča nou umode boe ekinorudowu aregodure. Mare Judeu doge emeartorure nou umode boe ekinorudowu jiwuge emagakare. Meartorukare nou umode boe ekinorudowu jiwuge ewarigudumode toro boečo tadawu joru pegareuto. Nonore boe etragudu rakamode rugadu, emode to reko pui tuwiri boe kori koia. Mare boe tuginaiwuge emeartorumode nou umode boe ekinorudowuji rugadu. Meartorure jiwuge emagamode rugadu moto jamedu boe parugajeje. Emugumode Abraão apo, Isaque apo, Jacó apo nono Pao Kurireu uwadae keje toro baru tada. ");
INSERT INTO bor_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nono Jesus makore nou tugobaigarege eimijeraji pugeje. Akore: – Ča. Ameartorure i rugadu. Ire nou atugare pemegago tu iwadaru tabo nono ameartorure i dumogadure. Atudo aibagi toro awai ka arduwo ji. Ča Jesus ure tuwadaru iado dukeje nou tugobaigarege eimijera utugare pemegagodure rugadu tači je. ");
INSERT INTO bor_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nono Jesus aregodure Pedro uwai ka. Nou Pedro uwai tadare Jesus jordure Pedro učarugoji. Nou Pedro učarugo kogodure rugadu. Biri urure dukodire padure nono tuba keje. ");
INSERT INTO bor_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nono Jesus ure tugera bu Pedro učarugo iera keje. Ča nou biri uru akedure piji tači je. Dukodire nou Pedro učarugo ure tumugudo. Ure turagojedo. Dukejere ure ia tuge rogu towuje. Ure ia maku Jesus ai ukeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nou boečoji ia boe etaregodure Jesus ae. Emagare pugeje. Etaregodure bope doge emedure tadawugebo rugadu. Nono Jesus ure nou bope doge etawuje nou boe epiji tuwadaru tabo. Makore ei dukodire eture nou boe epiji. Jesus ure kogodureuge epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dukodire čare Pao Kurireu bataru jeture pudui rugadu. Marigudu makore Pao Kurireu bataru jiwu Isaías ure nou Pao Kurireu bataru bu bapera keje. Akore: – Rakare boe ekogodaeji. Ure boe epemegago rugadu. Ainore Pao Kurireu akore marigudu nou umode boe ekinorudowu romoduie aino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Boe emagare nono Jesus apo rugadu. Ere taiado Jesus apo rugadu. Jesus jordure nou boe eiamedu boei emagare rugadu dukodire makore nou ture jorduwadowugei etuwo pudabo toro nou pobo maereu okwa abowu ka. ");
INSERT INTO bor_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ere tudo turugadu tuduwo dukeje ia jorduware Judeu doge eno bakaru jiwu imedu aregodure Jesus ae. Makore Jesusji. Akore: – Boe eimijera nure aki. Itaidure ikoduwo akabo akodure jiboe ka. ");
INSERT INTO bor_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mare Jesus makore ji. Akore: – Okwa doge emugure tiari poro ja tada. Kiebarege emode tamudo tuwaradu ja tada jamedu. Imire Imedu Onaregedu nure imi. Mare iwai bokware iedureu bokware iwo itamudo tada, inuduwo tada. Boe rakamode kodure itabowugei jamedu. ");
INSERT INTO bor_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ia Jesus ure jorduwadowu imedu makore Jesusji jamedu. Akore: – Ikodumode akabo rugadu mare kajao. Aino kuri aino itumode kuri iogwa uwai ka. Iogwa bire dukodire itaidure iwo iogwa tugu mototo jao. Dukejere ikodumode akabo akodure jiboe ka. ");
INSERT INTO bor_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mare Jesus makore ji. Akore: – Bireuge etugudumode bireugebo mare awiapagakaba ei. Atudo epiji. Ako itabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nono Jesus ure turemo ika kurireuto. Nou ure jorduwadowuge ere turemo apo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ekodure nou ika kurireu tabo nou pobo maereu kajeje dukeje Jesus unudure nou ika kurireu ja tada. Ča ia bakuru pegareu aregodure etae tači je. Nou bakuru ure nou pobo redo. Nou inodu kodire pobo jeture nou ika kurireuji. Dukodire pobo ure turemo nou ika kurireuto rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nou Jesus ure jorduwadowuge epagudugodure dukodire ere Jesus jetadudo. Egore: – Čegimijera. Pawimode poboto! Arodo iaboeji awo paginorudo. ");
INSERT INTO bor_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus akore: – Kočare tabagudure? Kočare tameartorukare i? Nono Jesus ure turagojedo ika ja tada. Nono makore nou bakuruji nou poboji dukodire nou bakuru akedure, nou pobo butugugodure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nou Jesus ure jorduwadowuge ebogodure rugadu. Egore pui: – Duboba nure awu imeduče? Kočare bakuru, pobo emeartorure awu imedu bataruji rugadu! ");
INSERT INTO bor_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dukejere Jesus aregodure toro nou pobo maereu okwa abowu ka ture jorduwadowugebo nou ika kurireu tabo. Nou etaregodure kawu moto iere Gadara. Etaregodure dukeje ere tudawuje ika kurireu piji. Mare bope doge emedu tadawu ime eture Jesus togi. Marigudu nou bope doge emedure nou ime etada dukodire erore pudabo turo pega tabo boe eiamedu boei. Dukodire boe epagudure eče. Dukodire boe etukare toro etae pugeje. Nou ime pobedu doge edu pagare nono aroe eda keje jamedu. ");
INSERT INTO bor_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nono ekudugodure Jesus ae. Egore: – Pao Kurireu onaregedu nure aki. Kodiba akaregodure mato čedae? Kaba kodiba aroino čewagai? Toro ia meri keje Pao Kurireu umode boe pegado čei rugadu. Aki kana amode boe pegado čei kuri aino? ");
INSERT INTO bor_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jugureuge edu puredure nono togwage tabo. Emagare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nou meture nou ime tadawu bope doge emagore nou ime eiabiji Jesusji. Egore: – Amode čedawuje awu ime epiji dukeje čedudo toro nou jugureuge etae. Čedo čeremo nou jugureugeto. ");
INSERT INTO bor_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dukodire Jesus akore: – Toro. Dukodire ere tudawuje nou ime epiji. Eture toro nou jugureuge etae. Ere turemo nou jugureugeto. Dukodire nou jugureuge eregodure toro ia moto ri ao piji tači poboto. Dukodire eiamedu boe ewire poboto rugadu. ");
INSERT INTO bor_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nou jeture nou jugureuge eiwuge eregodure Jesus piji toro nou tuwai mugure tadawu ba kurireu ka tureadoduwo boe ewiagai nono. Ereadodure nou Jesus rore jiboeji boe eiamedu boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nou ba kurireu kejewuge eiamedu boe eture toro Jesus ae. Erdure Jesusji dukeje emagore ji utuwo nou boe epiji. Enogwamagudure Jesusji rugadu utuwo nou moto piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nono Jesus ure turemo ika kurireuto pugeje. Ure tugirimi nou pobo maereu kajeje pugeje nou ture jorduwadowugebo. Dukejere etaregodure nou Jesus mugure kejewu ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nono ia boe etaregodure ia imedu pogora pegareu apo. Nou imedu pogora pegareu padure tugudau kodo keje. Jesus jordure emeartorure pudui duji kodire etaregodure aino nou imedu pogora pegareu apo pudae rugadu duji. Dukodire makore nou imedu pogora pegareuji. Akore: – Me. Ire aro pegareu jamedu boe barigu apiji dukodire Pao Kurireu biagodumode aro pegare jiboe piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ia boe eimijerage jorduware Judeu doge eno bakaru jiwuge etaidukare nou Jesus akoino duji. Egore tudada: – Awu makore jiboe ukare turugadu! Pagare akoino. Unure tudo nono Pao Kurireure. Tu Pao Kurireu umode boe ero pegareu barigu boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus jorduware emeardaere jiboeji rugadu. Dukodire makore ei. Akore: – Kočare kodiba tameardae pegare aino i. ");
INSERT INTO bor_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Boe jokodu. Boe emodukare boe ero pegareu barigu boe epiji rugadu. Tu Pao Kurireu umode boe ero pegareu barigu boe epiji rugadu. Mare boe emodukare awu imedu pogora pegareu pemegago jamedu. Emodukare pemegago rugadu. Tu Pao Kurireu koiare umode nou imedu pogora pemegago. ");
INSERT INTO bor_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dukodire imode awu imedu pemegago dukeje tarduwamode Imedu Onaregedu nure imi duji. Dukodire imode tarduwado iragare iwo boe ero pegareu barigu epiji ewarigudukawo bope doge eda kejewu joru pegareuto rugadu. Ainore Jesus akore nou boe eimijeragei. Nono ure tuie mekido nou imedu pogora pegareu ae. Nono makore ji. Akore: – Me. Aragojedo. Akeragu akudau kodoji atuwo tabo aibagi awai ka. ");
INSERT INTO bor_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ča nou imedu ure turagojedo rugadu. Meru pegakare dukodire uture tuwai ka rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nou boe eiamedu boe erdure nou rore aino duji. Erore ta je. Mare emago pemegare Pao Kurireuji. Egore emaie roino Jesusji uwo nou imedu pogora pegareu pemegago. ");
INSERT INTO bor_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus uture nou boe epiji. Kodure awaraji dukeje jordure ure tugeragu boe enoe mori jiwu imeduji. Du iere Mateus. Nou Mateus mugure nono ira keje. Nonore ure tugeragu dieroji boe epiji tuwo maku boe eimijera kurireu ai. Nono Jesus makore ji. Akore: – Ako itabo. Nono Mateus ure turagojedo. Ure tugera ra tumaragodae piji tuduwo Jesus apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mateus makore Jesusji okwagewo tuwai keje pudabo. Dukodire Jesus uture Mateus apo toro uwai ka. Jesus ure jorduwadowuge eture Jesus apo jamedu. Boe emagare nono togwage tabo ebo. Imposto diero makudure aiwuge ime nure emage. Boe egore ro pegareuge enuie emage. Ia boe etaidukare jiwuge eragojere nono Jesus apo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseu doge etaregodure toro etae jamedu. Erdure Jesus rore jiboeji dukeje emagore nou Jesus ure jorduwadowugei. Egore: – Kočare tagimijera okwagere awu ro pegareugebo? Ukare turugadu! ");
INSERT INTO bor_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus meardure egoino duji dukeje makore nou fariseu doge ewadaru jipagi. Akore: – Jorubo kuru epa jemarumodukare kogodukareuge ewagai. Mare kogodureuge ewagaire jemarumode tuwo epemegago. ");
INSERT INTO bor_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Irore nono nou jorubo kuru epa ro mogadure. Mare jorubo kuru epa ji karega inagoino. Itaregodure woe mare ro pemegareuge ewagai karega iroino. Ro pegareuge ewagaire iroino ewo tugera ra turo pegareu piji. Dujire inagoino. Marigudu Pao Kurireu ure tawie. Tagaiwodo nou Pao Kurireu bagai. Akore: “Boe emode boe egu barogo rogu kowu tuwo maku inai turo pegareu moriče. Mare itaidure boe enogudugoduwo puapo rugadu. Dujire itaidure rugadu.” Ainore Pao Kurireu akore marigudu. Ča tarduwado nou bataruji tameartoruwo ji tarore jiboe tabo. ");
INSERT INTO bor_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ia meri keje João Batista ure jorduwadowuge etaregodure Jesus ae. Egore: – Ia meri keje čenogwagemodukare nou meriji čemagowo Pao Kurireu bagai baruto nou meri keje. Ainore čerore. Fariseu doge eromode aino jamedu čero mogadure. Kodiba nou are jorduwadowuge erokare aino jamedu? ");
INSERT INTO bor_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus makore ewadaru jipagi. Akore: – Ire nono uwiremodewu imedu mogadure. Boe etuwirere dukeje boe ere tuwadae towuje. Nou ewadae kejere boe enogwagemode rugadu. Ewadae reno. Ekiarigodumodukare nou meriji. Mare ewadae akedure dukeje uwirereu imedu utumode epiji toreduje apo. Dukejere čare boe emode ia meri tawuje togwagekawo nou meriji tumagowo Pao Kurireu bagai baruto nou meriji. Ire nono nou uwiremodewu imedu mogadure. Mare uwiremodewu imedu ji karega inagoino. Ire inagoino. Ire irawuje baru piji mato boe ewagai. Mare ia meri keje itumode nou boe epiji. Dujire inagoino. Itumode nou boe epiji dukeje boe emode ia meri tawuje togwagekawo nou meriji tumagowo Pao Kurireu bagai baruto nou meri keje. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Boe ekudau areia pegagodureu umode tuwowuje. Mare boe emodukare tugudau areia maiwu kado tuwo nou tugudau pegagodureu poro miwuje tabo. Boe eromode aino dukeje nou ekudau areia maiwu gigirimode. Dukodire umode tuwowuje nou boe ekudau areia pegagodureu piji kuri je rugadu. Dukodire nou ekudau areia pegagodureu umode tuwowuje ja je pugeje. ");
INSERT INTO bor_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Boe ere tapira biri maiwu pemegado nou tuge vinho kuru maiwu jače. Mare emode vinho kuru maiwu tugu tapira biri čodureuto dukeje nou tapira biri čodureu umode tuwowuje. Nono nou vinho kuru umode tuwarigu nou tapira biri čodureu piji rugadu. Dukodire boe ekare tuge vinho kuru maiwu tugu tapira biri čodureuto. Ere tuge vinho kuru maiwu tugu tapira biri maiwuto tu tu je. Ainore Jesus akore. Mare areia ji karega akoino. Vinho kuru ji karega akoino. Tuwadaru maiwu jire Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus akoino dukeje ia boe eimijera aregodure ae. Ure tubu jodo moto keje Jesus jokorai. Makore Jesusji. Akore: – Itonaregedu aredu bire aino maigodu. Mare atudo itabo iwai ka awo akera bu nou itonaregedu aredu biri keje dukeje jewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus ure turagojedo tumuga piji. Uture nou boe eimijera apo toro uwai ka ture jorduwadowugebo. ");
INSERT INTO bor_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ekodure awaraji dukeje ia aredu kodure ebo Jesus rekodaji. Marigudu nou aredu kogodaere tu tu je. Nou aredu ku rere piji nono areme etorewudae mogadure. Mare nou aredu o akedukare piji. Re kimonure piji meri jameduji. Joru oto padu kejeboere doze nou aredu ku rere piji duji. Aino nou aredu makore tudada. Akore: – Imode ikera otorogu jetudo Jesus ukudau areiaji dukeje ipemegagodumode. Ainore nou aredu akore tudada. Dukodire nou aredu ure tugera raido. Nono iera otorogu jeture Jesus ukudau areiaji. ");
INSERT INTO bor_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nono Jesus ure tuie mekido. Jordure nou areduji rugadu. Akore: – Are. Ameartorure i rugadu. Dukodire apemegagodumode rugadu. Nono nou aredu pemegagodure tači je rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Nono Jesus aregodure nou boe eimijera uwai ka. Boe emagare nono tragudu tabo. Edukiorokare. Nou boe ere tuwabo ako rakado jamedu. Jesus jordure nou inoduji dukeje makore nou boei. Akore: – Tadawuje awu bai piji. Aredu rogu bikare. Unudunure tu je. Mare nou boe erduware nou nogwaredu bire rugadu duji dukodire enogwarigodure Jesusji. ");
INSERT INTO bor_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mare nou boe eimijera ure nou boe etawuje tuwai piji. Dukejere Jesus ure turemo nou nogwaredu padure tadawu baito. Dukeje ure tugeragu nou nogwaredu ieraji. Nono nou nogwaredu jewodure pugeje rugadu. Ure tumugudo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nou boe erduware nou inoduji dukodire ereadodure boe eiamedu boe ewiagai awu Jesus rore jiboeji nou moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nono Jesus uture pugeje. Mare ia ime joku bokwareuge ekodure Jesus rekodaji. Ere pobe. Ekudugodure Jesus bagai. Egore: – Mariguduwu Judeu doge eimijera kurireu Davi uwobe nure aki. Akogudugo čedabo. ");
INSERT INTO bor_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus ure turemo ia baito. Nono nou ime joku bokwareuge ere turemo Jesus rekodaji. Etaregodure Jesus ae rugadu. Jesus makore ei. Akore: – Tameartorure i imode tabemegago duji rugadu kana? Egore: – Uu. Čegimijera nure aki. ");
INSERT INTO bor_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dukejere Jesus ure tugera bu eku keje. Nono makore ei. Akore: – Tameartorure jiboe jetuwo pudui tai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nono epemegagodure tači je rugadu. Etaiwore pugeje rugadu. Mare Jesus makogodure ei. Akore: – Tareadodukaba boe ewiagai awu irore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mare eture Jesus piji dukeje ereadodure Jesus rore jiboeji boe eiamedu boe ewiagai nou moto rugadu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Eture dukeje iage etaregodure ia imedu apo Jesus bagai pugeje. Nou imedu mako bokware. Roiwakare tumagowo. Bope meture tada kodi. ");
INSERT INTO bor_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mare Jesus ure nou bope tawuje nou imedu piji dukeje nou imedu makore pugeje. Boe emagare nono tuiordure Jesus roino jitu tabo. Eiamedu boe ebogodure rugadu. Egore: – Marigudu Israel moto kejewu boe erdukare ia awu inodu boeji jii aino. ");
INSERT INTO bor_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mare fariseu doge etaidukare Jesus rore jiboeji. Emago pegare ji. Egore: – Bope doge eimijera kurireu raka tabore awu Jesus roino tuwo bope doge etawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus kodure nou moto jamedu boe parugajeje boe eda jamedu boe ka. Aregodumode ia boe eda ka dukeje ure turemo nou Judeu doge ere bato pui towu baito. Nonore ure erduwado tuwadaru pemegareuji tu tu je. Ure ewie Pao Kurireu umoduie boe eimijerado pudumi kuri je rugadu. Ure kogodureuge eiamedu boe epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Boe emagare Jesus apo tu tu je. Jesus jordure nou boei dukeje okudugodure ebo rugadu. Akore eie nono ovelha doge emogadure. Jetu pemegare eiwu bokwaie. Boe pegaie ei. Erduwakaie nuba turomode. Mare ovelha ji karega akoino. Nou boe eroiwakare tuwo tuginorudo. Dujire akoino. Ure erduwado Pao Kurireu bataru remawu jiwu bokware. Dujire akoino. ");
INSERT INTO bor_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nono Jesus makore ture jorduwadowugei. Akore: – Boepa kurire rugadu. Nou boepa tadaboe ure turugadu boe ewo kado. Mare umode boepa tadaboe kadowuge emagakare. ");
INSERT INTO bor_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dukodire tamagodo baruto Pao Kurireu bagai. Boepa jiwu boe eimijera kurireu nure ema. Tamagodo ji maragoduwo boepa jiwuge emagawo etuwo boepato ewo boepa tadaboe kado rugadu. Mare boepa ji karega Jesus akoino. Meartorumode Pao Kurireu jiwugeire akoino. Boe emode boe erduwado Pao Kurireu bataruji dukeje emeartorumode ji, Pao Kurireu umode ekinorudo. Dujire akoino. ");
INSERT INTO bor_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus makore nou ture jorduwadowuge ewagai pudae. Ere doze. Nono ure eragado ewo bope doge etawuje boe epiji. Ure eragado ewo boe epemegago ekogodae boe piji. ");
INSERT INTO bor_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ainore nou Jesus ure jorduwadowuge ekiere: Simão. Iere Pedro jamedu. André. Pedro uwie nure ema. Tiago. Nou Tiago uo iere Zebedeu. João. Tiago uwie nure ema. ");
INSERT INTO bor_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe, Bartolomeu, Tomé, Mateus. Boe ere to diero maku nou Mateus ai uwo maku boe eimijerage etai. Tiago. Alfeu onaregedu nure ema. Tadeu. ");
INSERT INTO bor_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão. Emare makore tumedagei marigudu emeartorukawo Roma kejewu boe eimijeragei pugeje. Judas Iscariotes. Emare umode Jesus maku boe eimijera pegareuge etai. Nou ime eture Jesus bataru tabowuge umode emage rugadu. ");
INSERT INTO bor_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Awu doze ime dogere Jesus ure etudo tuwadaru tabo. Makore ei. Akore: – Tadukaba boe tuginaiwuge etae. Tadukaba ia Samaritano doge eda ka. ");
INSERT INTO bor_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tadudo tu Judeu doge etae. Ere nono okware boetowuge ovelha doge emogadure. Mare ovelha ji karega inagoino. Nou Judeu doge emeartorukare Pao Kurireuji pugeje. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tadumode dukeje tamagomode tardure jiwuge ewiagai awu iwadaruji. Tamagodo: “Pao Kurireu umode boe eimijera kurireudo pudumi kuri je.” Ainore tagagomode boei. ");
INSERT INTO bor_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tadumode dukeje tamode kogodureuge epemegago. Tamode bireuge eewodudo pugeje. Tamode kogodureuge biri pegareuge epemegago. Tamode bope doge etawuje boe epiji. Ire taragado tarowo awu inagoino jiwu taroji mare ikare nou ire maku tagaiboe morido. Dukodire tamodukare boe edo iaboe maku tagai tarore jiboe moriče jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tadukaba tori kuieje tabo. Tadukaba prata tabo. Tadukaba ia diero tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tadukaba ia tagudau areia meture tadawu kadarabo tabo. Tadukaba ia tagudau areia tabo. Tadukaba ia tawure okeakejewu tabo. Tadukaba ia tagedu jiwu tagaibo tabo. Tadudo tu meture taiwu tagudau areia tabo. Tadumode tawo boe ewie iwadaruji. Dukodire boe etu pemegamode tai. ");
INSERT INTO bor_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tagaregodumode ia boe eda ka dukeje tagaiwodo ia ro pemegareu bagai tamuguwo nono uwai keje jii tadure kejewu meri ka. ");
INSERT INTO bor_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tamode taremo nou baito dukeje tagimadudo nou boebo. ");
INSERT INTO bor_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nou bai tadawuge ero pemegamode tai, etaidumode tai tietu pemegawo tai dukeje tawadaru pemegareu maku etai Pao Kurireu uwo boe pemegado ei. Mare ero pemegamodukare tai dukeje tagaba tawadaru pemegareu maku etai. ");
INSERT INTO bor_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ia boe eda kejewuge etaidumodukare tamagore jiboeji. Ekimadumodukare tagabo dukeje tadudo epiji. Tadumode nou boe eda piji dukeje tawure okeakejewu to pui egai tawo moto urugudu tawuje nou tawure okeakejewu piji nou boe erduwo Pao Kurireu aidukare nou erore jiboe jituji kodire umode tugera ra epiji. ");
INSERT INTO bor_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inure tawie. Boe pegamode nou aidukare taiwugei rugadu. Toro ia meri keje Pao Kurireu aiwomode boe eiamedu boe erore jiboeji. Mariguduwuge Sodoma kejewuge ero pegare. Gomorra kejewuge ero pegare jamedu. Dukodire nou meri keje Pao Kurireu umode boe pegado nou Sodoma kejewugei ero pegareu moriče. Umode boe pegado nou Gomorra kejewugei ero pegareu moriče. Mare nou aidukare taiwuge boe eire Pao Kurireu ro pega kuričigomode nou Sodoma kejewuge ekori, nou Gomorra kejewuge ekori jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","– Nou ire tadudo etaewuge ere nono rie doge emogadure. Tare nono ovelha doge emogadure. Mare barogo ji karega inagoino. Tameardae pegareu bokware. Dujire inagoino. Mare tadumode ewagaiwuge emeardae pegamode rugadu. Dujire inagoino. Dukodire inure tawie. Taeku jado nono awagu ro mogadure. Mare awagu ji karega inagoino. Tarduwado boe emeardae jamedu boeji. Dujire inagoino. Mare tameardae pegareu bokwado nono metugo mogadure. Mare metugo ji karega inagoino. Tameardae pegakaba boei rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Taeku jado ro pegareuge emeardae pegareu bagai. Mare ro pegareuge emode tugeragu tai rugadu. Emode tamagu Judeu doge eimijerage etai. Emode tarego Judeu doge ere bato puiwu bai ka. Nonore emode boeto tai tapira biri iku tabo. ");
INSERT INTO bor_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tameartorumode i dukodire ro pegareuge emode tamagu boe ekimijera governador doge etai. Emode tamagu boe ekimijerage kurireuge etai rugadu. Nono tamode nou boe ekimijerage ewie iwadaruji jamedu. Tamode boe tuginaiwuge ewie iwadaruji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mare nou boe ekimijerage emode tadugu baičoreuto dukeje tamororamagadukaba ia tamagomode jiboe bagai. Tamororamagadukaba tamode ewie jiboe bagai. Tamagomode mare tawadaru karega. Pao Kurireu Uwari makomode tai tuwo tamagore jiboe maku tagai Tao nure ema kodi. Emare umode tarduwado Pao Kurireu makomode jiboeji tamagowo nou Pao Kurireu bataruji nou boe ekimijerage ewiagai. ");
INSERT INTO bor_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","– Imode tawie iaboeji pugeje. Tameartorure i dukodire boe erdu pegamode tai, ero pegamode tai. Mare tamodukare tagera ra ipiji dukeje imode taginorudo rugadu. Ia boe emeartorumode i dukodire etumana mage emode nou tuwiemage meartorure iwuge emagu boe eimijerage pegareuge etai ewidoduwo. Ia boe emeartorumode i dukodire etuo jordu pegamode ei. Dukodire nou etuo umode tore meartorure iwuge emagu boe eimijerage pegareuge etai ewidoduwo. Ia boe etore etuje meartorumode i dukodire boe etore etaidumodukare nou tujeji pugeje. Ia boe etore etuo meartorumode i dukodire nou boe etore etaidumodukare nou tuoji pugeje. Dukodire nou boe etore emode tujemage tuomage meartorure iwuge emagu boe eimijerage pegareuge etai ewidoduwo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mare ia boe ero pegamode tai dukeje tarego nou boe epiji tamuguwo ia boe eda keje pugeje. Iwo tawie. Imedu Onaregedu nure imi. Tadumode Judeu doge eno moto kejewu boe eda jamedu boe ka jii toro imode ikirimi kejewu meri ka. Mare tagaregodumodukare nou Judeu doge emugure kejewu eda jamedu boe ka jii itaregodumode du ka. ");
INSERT INTO bor_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Boe emeartorumodukare ia mugure bapera kejewuji jorduwamodukare nono tugimijera mogadure. Boe emeartorumode tu nou mugure bapera kejewu ukimijeraji. Boe emeartorumodukare ia boe eimijera utugareji. Boe emeartorumode tu nou boe eimijeraji. ");
INSERT INTO bor_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mare nou mugure bapera kejewu jorduware jiboe umode nono nou ukimijera jorduware jiboe mogadure. Du ure turugadu. Nou boe eimijera utugare romode nono tugimijera ro mogadure. Du ure turugadu. Boe emode ia boe etuo iedo “Mareboe” aino dukeje emode nou imedu uwobe ekiedo aino jamedu. Mare ire inagoino. Taire inagoino jamedu. Boe etokire i nou bope ie tabo. Etokimode tai jamedu. Dujire inagoino. Etoki kuričigomode tai rugadu tokire i dupiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mare tabagudukaba eče. Boe ero pegamode dukeje etaidumode tuwo nou turo pegareu biado boe epiji tumagowo ro pemegareuge nuie pudumi. Mare Pao Kurireu jorduware marigudu ero pegareuji dukodire boe erduwamode nou ero pegareuji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tu tagi tarduware ia ire tarduwado jiboeji mare tamagodo nou ire tarduwado jiboeji boe ewiagai rugadu. Tamago pemegado ji boe eiamedu boe emearduwo tamagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","– Tabagudukaba boeče. Boe emode tawido mare eragakare tuwo tawarigu bope doge eda kejewu joru pegareuto. Dukodire inagoino tai. Tabagudukaba eče. Tu Pao Kurireu meardae koiare umode boe ewarigu bope doge eda kejewu joru pegareuto boe ewi keje. Tabagududo tu Pao Kurireuče. Mare tabagudu remawu ji karega inagoino. Taragado tai rugadu tameartoruwo tu Pao Kurireuji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ča kiebarege kugure emode pobe dukeje boe emode to diero tori rogu udo mitotu je tuwo akirodo nou kiebarege kugurei tugeče tuwo kowuje. Nou kiebarege emori bokware mare du inodu tabo Pao Kurireu biagodumodukare epiji rugadu. Ewudumodukare moto ka Pao Kurireu meardae piji. ");
INSERT INTO bor_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Mare Pao Kurireu aidure tai du kodure nou kiebarege kugure eiamedu boe ekori. Dukodire jetu pemegamode tai rugadu. Jorduware tai rugadu. Jorduware tagao iku jamedu boeji. Jorduware nou inodu rogu boeji kodire jorduware nuba boe mode tai duji rugadu. Jetu pemegamode tai rugadu. Dukodire inagoino tai tabagudukawo boeče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","– Iwo tawie iaboeji pugeje. Ia boe emagomode boe eiamedu boe ewiagai tuie tumagu inai tumeartoruwo tu i dukeje imagomode Pao Kurireu biagai baru tada nou meartorure iwu nuie ema rugadu. Toro nou Pao Kurireu aiwomode boe ero pegareu bagaiwu meri kejere imagomode aino ji. ");
INSERT INTO bor_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mare ia boe makomode boe ewiagai tugaie tumagu inai, tumeartorukaie i dukeje imagomode Pao Kurireu biagai baru tada nou meartorukare iwu nuie ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tameardaere itaregodure iwo boe epemegado pui. Ča itaregodure iwo boe pemegado boei rugadu. Mare ia boe emeartorumodukare i. Dukodire emeardaemodukare nono pumeardae mogadure imagore jiboeji. Dukodire boe epemegamodukare pui. ");
INSERT INTO bor_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Marigudu Pao Kurireu ure boe ewie nuba boemode meartorure iwugei. Aino nou Pao Kurireu bataru jetumode pudui rugadu. Akore: – Ime emeardaemodukare nono tuo meardae mogadure. Dukodire nou etuo meardae pegamode nou tore imei. Areme emeardaemodukare nono tuje meardae mogadure. Dukodire nou etuje meardae pegamode nou tore aremei. Areme emeardaemodukare nono turagomage emeardae mogadure. Dukodire nou eturago mage emeardae pegamode nou tujarugo magei. Nou imedu uwobe erdu pegamode ji. Jordu pegare jiwuge emode emage. – Ainore Pao Kurireu akore marigudu. ");
INSERT INTO bor_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iwo tawie pugeje. Boe emeardu kurimodukare i tuje kori, tuo kori, tore ime ekori, tore areme ekori, dukeje ukare turugadu iwo erduwado imeardaeji. ");
INSERT INTO bor_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Imeartorure Iogwa Kurireuji dukodire boe erdu pegare i, emode iwido. Boe etaidumode tuwo tumeartorudo imeardaeji dukeje ewo tudo turugadu tuwiwo nono iwimode dumogadure. Emodukare tudo turugadu tuwiwo nono iwimode dumogadure dukeje imodukare erduwado imeardaeji. ");
INSERT INTO bor_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Boe emeardae pemegare tuwo tuginorudo mare emeardaere tu pudui. Mare nou eraga akedumode epiji rugadu. Egare remawu modukare. Emodukare tuginorudo bope doge eda kejewu joru pegareu piji rugadu. Mare ia boe ewiapagamodukare tumeardaeji pugeje tuwo tugera ra tumeardae piji, taidure jiboe piji tumeartoruwo i rugadu. Dukejere Pao Kurireu umode boe pemegado ei, umode egare remawudo rugadu. Nono ewarigudumodukare bope doge eda kejewu joru pegareuto. ");
INSERT INTO bor_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Inure tawie. Ia boe erduware tameartorure i duji. Nono ekimadumode tagabo ekimadunure itabo jamedu. Ire eroino jamedu. Boe ekimadumode itabo ekimadunure ure itarego matowu Pao Kurireu apo jamedu. Ire eroino Pao Kurireu jire eroino jamedu. ");
INSERT INTO bor_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Boe erduware ia makore Pao Kurireu bataru jiwugei dukodire ekimadumode ebo dukodire Pao Kurireu umode boe pemegado ei nono turo moga makore Pao Kurireu bataru jiwugei dumogadure. Boe erduware ia ro pemegareugei dukodire ekimadumode ebo dukodire Pao Kurireu umode boe pemegado ei nono turo moga ro pemegareugei dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iwo tawie rugadu. Boe erduware meartorure iwugei dukodire emode pobo maku etai ekuduwo če. Dukodire Pao Kurireu umode boe pemegado ei eroino du moriče. ");
INSERT INTO bor_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus ure tumago akedudo nou ture jorduwadowugei dukeje uture pugeje. Nou ure jorduwadowuge enodo padure doze. Ča uture Galiléia moto kejewu boe eda jamedu boe ka tuwo boe erduwado. Makore Pao Kurireu bataruji boe ewiagai tu tu je. ");
INSERT INTO bor_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","João Batista rakojere baičoreu tada. Boe ere João Batista bie nou Jesus rore jiboeji makore jiboeji. Dukodire João Batista ure ia ture jorduwadowuge etudo toro Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Makore ei enarawo Jesusji Pao Kurireu umoduie maku boe etaiwu boe ekinorudowu nure ema rugadu kana? Enarawo Jesusji boe epagaiago ia bagai kimo kana? Dukodire eture Jesus ae rugadu. Enarare Jesusji nono tugimijera makore pudui dumogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nono Jesus makore ewadaru jipagi. Akore: – Tagirimi tawo João biedu pemegado rugadu tardure jiwu irore jiboeji tameardure jiwu imagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ire joku bokwareuge epemegago etaiwowo pugeje. Ire pogora pegareuge epemegago emeruwo pugeje. Ire kogodureuge ewiri pegareuge epemegago ewiri pemegawo pugeje. Ire bija bokwareuge epemegago emearduwo pugeje. Ire bireuge eewodudo pugeje. Ire marenarue doge ewie nou umode boe ekinorudowu aregoduie rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Boe pemegamode nou meartorure iwu boei. Emodukare tugera ra tumeartorure i dupiji nono egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Nou João Batista ure jorduwadowuge eture pugeje Jesus piji. Dukeje Jesus makore João Batista rore jiboeji nou rakojere pudabowuge boe ewiagai. Akore: – Marigudu tadure jiče boe akurugudu maereu ka mare tarduwo bakuru jeture boebutu jitu bagai karega. Tarduwo ukudau areia motureu jiwu boe ewagai karega. Tarduwo oe kurireuge ewagai karega. Nou ukudau areia motureu jiwu boe emugure bai kurireu tada. Oe kurireuge emugure bai kurireu tada. Tadumode bai kurireu ka nouge ewagai. Mare tadure boe maereu ka. Tadure toro tarduwo João Batistaji. Tarduware João Batista makore Pao Kurireu bataru jituji. Dukodire tadure toro boe maereu ka João Batista bagai. Aino ča imode tawie. João Batista makore Pao Kurireu bataruji rugadu. Mare imode tawie iaboeji pugeje. João Batista rore nono Pao Kurireu meardae mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dujire Pao Kurireu ure boe ewie marigudu. Nou bataru padure bapera keje. Akore: “Imode itugare arego uwo boe pemegado nou umode boe ekinorudowu togi.” Ainore Pao Kurireu akore marigudu. João Batista jire akoino. Dukodire čare awu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jesus mako kimore. Akore: – Iwo tawie boe remawuji rugadu. João Batista kurire boe eiamedu boe ekori. Mare aino ia boe etugare umode tugimijerado Pao Kurireuče dukeje kurimode João Batista kori Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","João Batista aregodure dukeje ure boe ewie Pao Kurireu ure maku aiwu tuwadaru pemegareuji. Ainore rore jii aino. Akore Pao Kurireu umoduie boe eimijera kurireudo pudumi kuri aino. Dukodire nou aidukare nou bataru pemegareu jiwuge ere turokogado nou ure tugimijerado Pao Kurireu čewugei emeartorukawo ji pugeje. ");
INSERT INTO bor_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moisés ure maku Judeu doge etaiwu bakaru ure boe ewie nuba Pao Kurireu romode. Makore Pao Kurireu bataru jiwuge ere Pao Kurireu bataru bu bapera keje jamedu boe erduwawo Pao Kurireu meardaeji. Ainore Pao Kurireu rore tuwo boe ewie tumeardaere jiboeji jii toro João Batista aregodure du ka. ");
INSERT INTO bor_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Marigudu Pao Kurireu ure boe ewie tumoduie Elias arego mato boe etae. Mare Elias ji karega akoino. Nou aregodumodewu romode nono Elias ro mogadure. Dujire akoino. Aino ča imode tawie. Awu João Batista nure ema rugadu. João Batista jire Pao Kurireu akoino. Rore nono Elias ro mogadure. Tameartorumode nou inoduji dukeje tameartorumode iwadaruji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tawiapaga pemegado iwadaruji. ");
INSERT INTO bor_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Imode tarduwado nuba meartorukare João Batista jiwuge emeardaere. Ere nono boe etore ewadure puapo nono bawadu keje dumogadure. Ewadure puapo mare etokire pui. ");
INSERT INTO bor_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Egore: “Čere bapo akodo. Nono čemagore tai tareruwo mare tarerukare. Nono čemagore tai tagraguduwo čedabo mare tagragudukare.” – Ainore boe etore egore pui. Epemegakare pui rugadu. Ča nou meartorukare João Batista jiwuge ere nono nou boe etore emogadure. Mare boe etore ei karega inagoino. João Batista makore boe ewiagai ewo tugimijerado Pao Kurireuče mare erokare aino. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","João Batista ure tugera ra tuge piji jao tumagowo baruto nono boe ero mogadure. João Batista kudukare vinho kuruče nono ro pemegareu ro mogadure. Mare boe emago pegare ji. Egore bope uwari metuie tada. ");
INSERT INTO bor_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Imedu Onaregedu nure imi. Pao Kurireu ure itarego mato boe etae. Inogwagere boebo. Ikudure boebo. Mare du inodu tabo boe emago pegare i jamedu. Egore inogwage ierikaie. Mare pagare egoino. Egore ikudu kigoduie vinho kuruče. Mare pagare egoino. Egore itaiduie ro pegareugei, nou ure tugeragu boe enoe mori jiwugei, marenarue dogei jamedu. Ainore egore. Mare tumago pegawo i dubagaire egoino. Mare ia boe emeartorumode i. Dukodire boe erduwagodumode Pao Kurireu bataru remawu jire João Batista akoino duji. Boe erduwagodumode Pao Kurireu bataru remawu jire inagoino duji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nono Jesus mako pegare ia boe eda kejewugei. Jesus ure turo rakado boe egai nono nou boe eda jamedu boe keje mare du inodu tabo nou boe ekare tugera ra turo pegareu piji. Emeartorukare Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jesus akore: – Iro rakare Corazim ba kurireu keje iwo nou boe erduwado i. Dukodire erdure iro rakareuji. Mare du inodu tabo emeartorukare i. Dukodire boe pegamode ei rugadu. Iro rakare Betsaida ba kurireu keje iwo nou boe erduwado i. Erdure iro rakareuji. Mare du inodu tabo emeartorukare i. Dukodire boe pegamode ei jamedu. Marigudu Tiro ba kurireu kejewuge emeartorukare Pao Kurireuji. Marigudu Sidom ba kurireu kejewuge emeartorukare Pao Kurireuji. Nou Tiro ba kurireu kejewuge, nou Sidom ba kurireu kejewuge erdumode iro rakareuji dukeje ekiarigodumode turo pegareuji rugadu. Emode tugera ra turo pegareu piji. Emode jorugudu bu taora keje tuwo boe erduwado tugiarigodure turo pegareu boeji. Emode tugudau areia kwatorureu tugu pudui tuwo boe erduwado tugiarigodure turo pegareu boeji rugadu tumode tugera ra turo pegare jiboe piji duji. Mare erdukare i, erdukare iro rakareuji dukodire erduwakare i. Ekare tugera ra turo pegareu piji rugadu. Mare kočare Corazim ba kurireu kejewuge, Betsaida ba kurireu kejewuge, erdure iro rakareuji mare du inodu tabo ekiarigodukare turo pegareuji. Etaidukare tuwo tugera ra turo pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pao Kurireu ure ia meri tawuje taiwowo boe eiamedu boe ero pegareu bagai nou meri keje. Tiro ba kurireu kejewuge emeartorukare Pao Kurireuji dukodire Pao Kurireu umode boe pegado ei nou ture tawujewu meri keje. Sidom ba kurireu kejewuge emeartorukare Pao Kurireuji dukodire Pao Kurireu umode boe pegado ei jamedu nou ture tawujewu meri keje. Mare Corazim ba kurireu kejewuge, Betsaida ba kurireu kejewuge erdure iro rakareuji mare du inodu tabo emeartorukare i. Dukodire Corazim ba kurireu kejewuge eire, Betsaida ba kurireu kejewuge eire, Pao Kurireu ro pega kurimode ei rugadu nou Sidom kejewuge ekori, nou Tiro kejewuge ekori. Pao Kurireu romode aino ei toro ia meri keje. Nou ture tawujewu meri kejere umode boe pegado ei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Cafarnaum ba kurireu kejewuge emeartorure tu pudui turuduwo baruto. Mare pagatu je. Pao Kurireu umode ewarigu toro bope doge eda kejewu joruto nou taiwomode boe ero pegareu bagaiwu meri keje. Marigudu Sodoma ba kurireu kejewuge erdukare Pao Kurireu jordae pemegareuji dukodire ero pegare rugadu. Erdumode iro rakareuji nono Cafarnaum ba kurireu kejewuge erdure dumogadure dukeje ekiarigodumode turo pegareuji rugadu. Emode tugera ra turo pegareu piji. Mare erdukare. Dukodire ekare tugera ra turo pegareu piji rugadu. Dukodire Pao Kurireu ure nou Sodoma ba kurireu akedudo. Mare nou Cafarnaum ba kurireu kejewuge erdure iro rakareuji rugadu. Mare du inodu tabo ekiarigodukare turo pegareuji. ");
INSERT INTO bor_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dukodire imode tawie. Boe pegamode nou Sodoma kejewugei nou Pao Kurireu aiwomode boe ero pegareu bagaiwu meri keje. Mare nou meri keje nou Cafarnaum ba kurireu kejewuge eire Pao Kurireu ro pega kurimode ei rugadu nou Sodoma kejewuge ekori. ");
INSERT INTO bor_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nono Jesus makore Pao Kurireu bagai baruto. Akore: – Iogwa. Imago pemegawo ai. Baru tadawuge eimijera kurireu nure aki. Moto kejewuge eimijera kurireu nure aki. Are mugukare bapera kejewuge erduwado ameardaeji. Mare are nou ameardae biado jorduwareuge epiji. Are biado mugure bapera kejewuge epiji. Mare are mugukare bapera kejewuge erduwado. Dukodire imago pemegare aino ai. ");
INSERT INTO bor_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ainore ameardaere. Nou ameardae ure aegaredo ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus ure nou tuwadaru akedudo baruto dukeje makore boei. Akore: – Iogwa ure boe jamedu boe maku inai. Tu Pao Kurireu jorduware Tonaregeduji. Tu nou Onaregedu jorduware Tuoji. Mare Onaregedu umode nou ture tugeragu jiwuge erduwado Pao Kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ia tagi tamagore tameartorumoduie Pao Kurireuji dukodire tare taragado tai tameartoruwo nou Judeu doge eno bakaruji. Mare taraga tabore taroiwakare. Dukodire tagiarigodure, tamedugodure. Ča. Mato itae. Imode taraga maku tagai tawo tagamudo. ");
INSERT INTO bor_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Imode maku boe etaiwu iwadaru rakakare. Iro butugumode boei rugadu. Ikare boe remawudo imi iwo imeardae pemegado boe eiamedu boei. Imode maku boe etaiwu iro rakakare boei. Dukodire meartorure iwuge emode tamudo rugadu. Dukodire inagoino tai tameartoruwo i. Tarduwagoduwo iwadaruji rugadu tameartoruwo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesus merure boepa oiagi sábado meriji. Trigo ure nou boepa tada. Nou ure jorduwadowuge ekodure apo. Ča nou Jesus ure jorduwadowuge eke boeire ei. Dukodire ere tugeragu trigo enariji tuwo ko. ");
INSERT INTO bor_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseu doge erdure erore aino duji dukeje emagore Jesusji. Egore: – Akaiwodo. Judeu doge nure pagi. Sábado meriji pamaragodumodukare rugadu. Dukodire pamodukare pageragu trigoji sábado meri keje. Mare nou are jorduwadowuge ere tugeragu ji. Ukare turugadu! ");
INSERT INTO bor_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus akore: – Kočare tarduwakare Pao Kurireu bataruji! Dukodire tarduwakare Pao Kurireu meardae remawuji. Tarduwamode Pao Kurireu meardae remawuji dukeje tamago pegamodukare čeroino aino duji. Mariguduwu Judeu doge eimijera kurireu Davi rore jiboe padure Pao Kurireu bataru keje. Dujire tarduwakare. Nou Davi uke boeire ji. Utugarege tugobaigarege eke boeire ei jamedu. ");
INSERT INTO bor_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dukodire ure turemo Pao Kurireu uwaito. Okwagere boe ere maku Pao Kurireu aiwu amireuji. Pao Kurireu ure turo maku mariguduwuge pawobe Judeu doge etai. Makore ei ekawo nou amireu kowuje. Tu nou ure Judeu doge enomea maku Pao Kurireu aiwuge emode nou Pao Kurireu uwai tadawu amireu kowuje. Ainore Pao Kurireu akore. Ainore pawobe Judeu doge erore. Mare Davi ure nou Pao Kurireu uwai tadawu amireu kowuje. Ure ia maku tudugarege etai ewo kowuje jamedu. Mare Pao Kurireu mako pegakare eroino duji. Dukodire imagore aino tai tamago pegakawo čere čegeragu trigo jituji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kočare tarduwakare Pao Kurireu bataruji! Nou Moisés ure maku Judeu doge etaiwu bakaru akore nou maragodure Pao Kurireu uwai tadawuge ewo tagu barogo kowu boe ero pegareu moriče sábado meri keje. Ainore Pao Kurireu akore. Aino emaragodure sábado meri keje. Mare Pao Kurireu jordu pegakare eroino duji. ");
INSERT INTO bor_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iwo tawie. Ikurire Pao Kurireu uwai kori. ");
INSERT INTO bor_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pao Kurireu bataru remawu akore Pao Kurireu aiduie boe enoguduwo puapo. Aiduie boe ewo tagu barogo rogu kowu turo pegareu moriče mare aidu kurie boe enoguduwo puapo rugadu. Tarduwamode awu Pao Kurireu bataru remawuji dukeje tameartorumode ji. Dukeje tamago pegamodukare aino ro pega bokwareugei. ");
INSERT INTO bor_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ča iwo tawie. Imedu Onaregedu nure imi. Imire imode boe erduwado rugadu nuba boe eromode sábado meri keje. ");
INSERT INTO bor_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus ure nou tuwadaru akedudo dukeje uture nou boe epiji. Uture ere bato puiwu bai ka. Ure turemo. ");
INSERT INTO bor_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ia imedu rakojere nono. Iera pegare. Nou ierare tudorido puapo. Ia boe eimijerage edu nono jamedu. Erdu pegare Jesusji. Dukodire etaiwore Jesus ia ro pegamode tiagai dubagai. Judeu doge eromodukare ia turore jiboeji sábado meri keje. Dukodire etaidukare boe eiogowo boei sábado meri keje. Mare Jesus umode nou imedu iera pemegago nou meriji dukodire nou boe eimijerage erdu pegamode nou Jesus rore aino duji. Dukodire enarare Jesusji. Egore: – Pago bakaru ure parduwado boe eiogowo sábado meri keje? ");
INSERT INTO bor_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mare Jesus makore ewadaru jipagi. Akore: – Tagagore boe emaragodukaiago sábado meri keje tumeartoruwo pago bakaruji. Mare nuba paromode pagagu ie ovelha dogei sábado meri keje? Ia pagagu ovelha butumode moto poroto sábado meri keje dukeje pamodukare tawuje rugadu kana? Boro pamode tawuje rugadu. Kočare pamaragodu tabo kana parore aino? ");
INSERT INTO bor_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ča Pao Kurireu aidure boei nou boe egu ovelha doge ekori. Dukodire paro pemegamode boei sábado meri keje du pegamodukare Pao Kurireu ure maku pagaiwu bakaruji. ");
INSERT INTO bor_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nono Jesus makore nou imedu iera pegareuji. Akore: – Akera raido itae. Nono nou imedu ure tugera raido Jesus ae. Čare iera pemegagodure tači je rugadu. Pemegare nono nou iera abowu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nou boe eimijerage fariseu doge ekorigodure rugadu. Erdu pegare Jesus rore aino duji sábado meri keje. Du ainodu otobiji emagore pui tu tu je tuwo ia tumeardae pegareu tawuje tuwo Jesus bito rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mare Jesus jorduware emeardae pegareuji. Dukodire uture nou boe eda piji. Mare boe emagare tudure Jesus apo duji. Dukodire Jesus ure nou uture pudabowuge kogodureuge epemegago. ");
INSERT INTO bor_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mare makore ei ekawo boe ewie kaboba ure pudumi duji. ");
INSERT INTO bor_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dujire Pao Kurireu makore marigudu. Marigudu ure tuwadaru maku Isaías ai uwo bu bapera keje. Akore: ");
INSERT INTO bor_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","– Itugare reo. Ire ikeragu ji rugadu. Imeardu kurire ji rugadu. Ure iagaredo i rugadu. Imode Iwari maku ai rugadu. Emare umode boe ewie Pao Kurireu ro pemegamoduie boei duji. Umode boe ewie Pao Kurireu umoduie meartorure puduiwuge ekinorudo ero pegareu mori piji. Umode Judeu doge ewie. Umode boe tuginaiwuge ewie jamedu. ");
INSERT INTO bor_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Okimodukare boei. Mako rakamodukare boei. Mako pegamodukare toro nou boe etae. ");
INSERT INTO bor_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Umodukare boe pegado rakakareugei. Umodukare boe pegado marenarue dogei. Ainore itugare romode jii boe emeartorure jitu ka uwo boe ekinorudo turo pegareu mori piji. ");
INSERT INTO bor_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nou itugare ie jire boe eiamedu boe emeartorumode. Epagamode uwo meartorure puduiwuge eiamedu boe ekinorudo du bagai rugadu. Aino čare awu Pao Kurireu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ia meri keje boe etaregodure Jesus ae ia joku bokwareu imedu apo. Nou imedu mako bokware jamedu. Mare bope uwari meture tada dukodire nou bope uwari koiare ure nou imedu joku bokwado ure mako bokwado. Nono Jesus ure nou imedu pemegago rugadu dukodire nou imedu makore pugeje, aiwore pugeje. ");
INSERT INTO bor_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nou boe eiamedu boe erore ta je. Enarare pui. Egore: – Nou Pao Kurireu umoduie maku pagaiwu Davi Onaregedu kana? ");
INSERT INTO bor_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseu doge emeardure egoino duji dukeje emago pegare Jesusji pu biagai. Egore: – Bope doge eimijera Belzebu meture Jesus tada dukodire ure turaga maku Jesus ai Jesus uwo bope uwari tawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mare Jesus jorduware emeardae pegareuji. Dukodire makore nou fariseu dogei. Akore: – Nou epokare puapowu boe erugodumode pui rugadu. Dukeje eraga akedumode epiji kuri je. Boe erugodumode tuwobei dukeje emode tugera ra pubiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ča meartorure Satanás jiwuge emode Satanás utugarege bope doge etawuje ia boe epiji dukeje ere nono epokare puapowuge emogadure. Erugodumode pui rugadu. Dukodire nou meartorure Satanás jiwuge eragamodukare rugadu etagedumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kočare tagagore nou Belzebu raka taboie ire bope uwari pegareu tawuje boe epiji. Mare nou tare jorduwadowuge nuba erore tuwo bope uwari tawuje boe epiji? Pao Kurireu raka tabore eroino na? Tu Pao Kurireu rakare tuwo bope doge etawuje boe epiji tu rugadu. Dukodire nou tare jorduwadowuge egomode pagaie tagagoino Belzebu raka taboie ire bope uwari tawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pao Kurireu koiare ure turaga maku inai iwo bope doge etawuje boe epiji rugadu. Dukodire boe erdure Pao Kurireu ro rakareuji rugadu. Turore aino dutabo Pao Kurireu makonure boe ewagai ewo tugimijera kurireudo tu pudumi rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ča iwogureu aidure tuwo turemo ia tugobaigare uwaito tuwo tugeragu nou tugobaigare oeji. Mare umode nou tugobaigare kogudo bukigu tabo boetoji. Nono umode tugeragu nou tugobaigare oeji rugadu tuduwo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aidukare iwu aidumode tuwo imeardae pegado tuwo iro bokwado. Ukare tugera maku inaiwu umodukare boe etarego itae. Umode boe edo taodo ipiji. ");
INSERT INTO bor_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Boe jokodu jire inagoino. Boe etaidukare turo pegareuji pugeje dukeje Pao Kurireu biagodumode nou ero pegareu piji. Boe emago pegamode Imedu Onaregeduji mare toro ia meri keje ekiarigodumode nou tuwadaru pegareuji. Emagomode Pao Kurireuji biagoduwo nou tuwadaru pegareu piji. Dukeje Pao Kurireu biagodumode ewadaru pegareu piji rugadu. Mare ia boe emago pegamode Pao Kurireu Uwariji dukeje Pao Kurireu biagodumodukare nou ewadaru pegareu piji. Nou bataru metumode nou boebo jii rugadu. Du akedumodukare rugadu. Dukodire Pao Kurireu biagodumodukare nou inodu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","– Iwo tawie. Iguru pegareu tudu pemegamodukare. Iguru pemegareu tudu pemegamode rugadu. Boe erduwamode tuduji dukeje erduwamode nou tudu iji jamedu. Mare iguru ji karega inagoino. Ire inagoino. Ča tameardae tawuje nuba ire taegai. ");
INSERT INTO bor_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mare tare nono awage pegareuge emogadure. Mare awagu ji karega inagoino. Ro pegareuge nure tagi marigudu. Dujire inagoino. Dukodire tameardae pemegamodukare i rugadu. Dukodire tamago pemegamodukare i jamedu. Boe ewiagoromode tumeardae pegareu tabo dukeje emago pegamode nono nou tumeardae mogadure. ");
INSERT INTO bor_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Boe ewiagoromode tumeardae pegareu tabo dukeje ero pegamode emago pegamode nono nou tumeardae mogadure. Mare boe ewiagoromode tumeardae pemegareu tabo dukeje ero pemegamode emago pemegamode nono nou tumeardae mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Toro ia meri keje Pao Kurireu aiwomode boe eiamedu boei ero pegareu bagai. Dukeje boe eiamedu boe emagomode turore jiboeji tumagore jiboeji Pao Kurireu biagai rugadu. Boe etaidumode tuwo ia tuwadaru biado mare pagatu je. Pao Kurireu jorduware marigudu emeardaeji. ");
INSERT INTO bor_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dukodire imode tawie. Tamagore jiboe pemegamode dukeje Pao Kurireu mako pegamodukare tai. Mare tamagore jiboe pegare dukeje Pao Kurireu makomode tai tumoduie boe pegado tai tawadaru pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nono ia fariseu doge emagore Jesusji. Ia jorduware Judeu doge eno bakaru jiwuge emagore Jesusji jamedu. Egore: – Čegimijera. Čerdudo ia aro rakareuji čemeartoruwo ai. Mare pagatu jere egoino. Etaidukare tumeartoruwo Jesus bataruji. ");
INSERT INTO bor_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nono Jesus makore ewadaru jipagi. Akore: – Aino čare boe emeardae pegare rugadu, ero pegare rugadu. Ainore tameardaere jamedu. Tamagore i iwo ia iro rakareu tawuje taegai tarduwo iro rakareuji tarduwawo kaboba ure imi duji. Mare pagatu jere tagagoino. Dukodire iromodukare ia iro rakareuji taegai pugeje. Mare boemode i nono boe moga Jonas jitu mogadure. Dukejere boe erduwamode i rugadu. ");
INSERT INTO bor_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Marigudu Jonas meture karo kurireu kuri tada. Merire pobe metia bokware ji nono nou karo kuri tada. Dukejere Pao Kurireu ure Jonas tawuje nou karo kurireu kuri piji rugadu. Aino Imedu Onaregedu rakojemode moto tada jamedu. Merimode pobe metia bokware ji nono jamedu. ");
INSERT INTO bor_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pao Kurireu ure Jonas tawuje karo kurireu kuri piji dukeje uture Nínive ba kurireu ka Pao Kurireu bataru tabo. Dukodire nou Nínive kejewuge erduware boe jokodu jire Jonas akoino pudui duji. Ekiarigodure turo pegareuji. Ere tugera ra turo pegareu piji rugadu tumeartoruwo Pao Kurireuji. Mare boe eimijera kurireu nure imi. Ikodure Jonas kori. Iorduware jiboe kodure Jonas jorduware jiboe kori. Mare du inodu tabo tagaidukare tarduwawo i. Tagaidukare tawo tagera ra taro pegareu piji. Toro ia meri keje Pao Kurireu umode boe eewodudo pugeje taiwowo boe ero pegareu bagai tuwo boe pegado ei ero pegareu moriče. Nou meri keje nou Nínive ba kurireu kejewuge emago pegamode tai tawiapagakare iwadaruji dukodi. ");
INSERT INTO bor_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Marigudu Sabá moto kejewuge boe eimijerago kurireudo aidure rugadu tuiorduwawo Judeu doge eimijera kurireu Salomão jorduware jiboeji. Dukodire ure tudawuje to moto piji tuduwo toro Salomão uwai ka tumearduwo Salomão makore jiboeji. Mare boe eimijera kurireu nure imi. Ikodure Salomão kori. Iorduware jiboe kodure Salomão jorduware jiboe kori. Mare du inodu tabo tagaidukare tarduwawo i. Toro ia meri keje Pao Kurireu umode boe eewodudo pugeje taiwowo boe ero pegareu bagai tuwo boe pegado ei ero pegareu moriče. Nou meri keje nou Sabá moto kejewu boe eimijerago aredu mako pegamode tai tawiapagakare iwadaruji dukodi. ");
INSERT INTO bor_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Jesus mako kimore boei. Akore: – Bope uwari pegareu umode tudawuje ia imedu piji dukeje utumode toro boe maereu ka taiwo tabo tumode tamudo kejewu bagai. Jordumodukare taidure jiboeji dukeje meardaemode tuwo tugirimi nou tumedure tadawu imedu ae pugeje tuwo turemo to pugeje. Dukodire nou bope uwari pegareu umode tugirimi nou tumedure tadawu imedu ae rugadu. Aregodumode dukeje jordumode ji pemegare duji. Jordumode ji ure nono tuwai motureu umogadure. ");
INSERT INTO bor_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dukejere utumode toro tumedage bope doge ewagai. Enodo padure sete. Epegare nou bope uwari boetojiwu kori. Bope uwari boetojiwu makomode ei etuwo pudabo toro nou imedu ae. Nono emode turemo nou imeduto pugeje. Dukodire boe pegamode nou imeduji rugadu. Boetojiwu meture tadawu bope uwari ure mitotu je. Aino čare bope doge enodo padu kejeboere oito nou imedu tada. Dukodire boe pegamode nou imeduji rugadu. Ča iwo tawie. Meartoru bokware iwugeire boe pegamode rugadu nono boe pegare nou imedu jitu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus mako kimore boei dukeje uče uwiemage etaregodure bagai. Etaidure tumagowo ji. Mare ekare turemo baito. Epagare bagai toro bawadu keje. ");
INSERT INTO bor_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ia imedu ure Jesus bie. Akore: – Ače, awiemage etaregodure. Eragojere toro bawadu keje. Etaidure tumagowo ai. ");
INSERT INTO bor_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus akore: – Imode tawie ioguduba nure mugače, ioguduba nure iwobeče. ");
INSERT INTO bor_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nono Jesus ure tugera raido nou ture jorduwadowuge eiagwai. Akore: – Awu ire jorduwadowuge ere nono iwobe emogadure. ");
INSERT INTO bor_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Meartorure Iogwa Kurireu meardae jamedu boe jiwuge ere nono iwobe emogadure rugadu. Ere nono iwie mage emogadure rugadu. Ere nono muga mage emogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","2","Nou meriji rugadu Jesus uture nou bai piji pobo maereu okwa ka pugeje. Boe ere bato pui nono tumearduwo Jesus bataruji pugeje. Emagare rugadu. Dukodire Jesus ure taredo ia ika kurireuto. Nou ika kurireu padure nono pobo tada. Nou boe edure pobo okwai tumearduwo Jesus bataruji. Jesus ure tumugudo nou ika kurireu ja tada. ");
INSERT INTO bor_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dukejere Jesus readodure ewiagai ia bakaruji tuwo erduwado toro nouia Pao Kurireu meardaeji. Akore: – Ia imedu ure tudawuje tuwo boe a roto ja ja moto joki to boepa tada. ");
INSERT INTO bor_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ia a buture awara okwaji. Dukodire kiebarege ere nou buture awara okwa jiwu boe a rugadu kowuje. ");
INSERT INTO bor_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ia a buture toriguru tada. Boture kuri je mare moto pegare ji. ");
INSERT INTO bor_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dukodire boeru jeture ji dukejere nou boeru ure nou botureboe bito kuri je rugadu. Ukwa bokware kodi. Moto pegare kodi. ");
INSERT INTO bor_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ia a buture botoguru tada. Botoguru boture tabo mare botoguru ure bito. ");
INSERT INTO bor_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mare ia a buture moto pemegareu keje. Ere tuguwu sacu ure mitotu je. Botu pemegare, ričodu pemegare, enari kurire rugadu. Kidure dukeje ere rawuje čiwu piji. Ere a rawuje tuwo tugu sacuto. Nou sacu doge emagare. Enodo padu kejeboere trinta, ere sessenta, ere cem nou boe a tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tawiapaga pemegado awu iwadaruji tarduwawo kaba jiba inagoino tai. ");
INSERT INTO bor_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nou Jesus ure jorduwadowuge enarare Jesusji. Egore: – Kaba kodiba areadodure bakaruji aino boe ewiagai? ");
INSERT INTO bor_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus akore: – Ireadodure bakaruji iwo boe erduwado toro nouia Pao Kurireu meardaeji. Mare paga karega. Ireadodure bakaruji aino Pao Kurireu uwo tarduwado meture pudabowu tumeardae boeji, boe ewo tugimijerado ema. Mare iage emodukare boe pa nou bakaruji. ");
INSERT INTO bor_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Boe erduware Pao Kurireu bataruji. Etaidure tumeartoruwo ji dukeje Pao Kurireu umode erduwa kurido pudui emeartoruwo pudui rugadu. Mare ia boe etaidumodukare tumeartoruwo tuiorduware jiwu Pao Kurireu bataruji dukeje Pao Kurireu umode erduwa bokwado tuwadaruji. Emeardaere tuiorduwaie rugadu mare pagatu je. ");
INSERT INTO bor_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dukodire ire boe erduwado toro nouia Pao Kurireu meardaeji nou bakaru tabo boe ewiagai. Dukodire etaiwomode rugadu mare erdumodukare boeji. Ewiapagamode mare erduwamodukare boeji. ");
INSERT INTO bor_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Marigudu Isaías ure Pao Kurireu bataru bu bapera keje. Awu boe eire nou bataru akoino. Akore: – Tameardumode Pao Kurireu bataruji jii je mare tarduwamodukare ji. Tardumode Pao Kurireu rore jiboeji jii je mare tameartorumodukare emare roino duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Boe etaidukare tumeartoruwo Pao Kurireuji. Etaidumode tumeartoruwo Pao Kurireuji dukeje etaiwomode Pao Kurireu rore jiboeji tuiorduwawo Pao Kurireu meardaeji. Etaidumode tumeartoruwo Pao Kurireuji dukeje ewiapaga pemegamode Pao Kurireu bataruji tuiorduwawo Pao Kurireu meardaeji rugadu. Dukejere etaidumodukare turo pegareuji pugeje. Emode tugera ra turo pegareu piji. Dukodire imode ekinorudo ero pegareu piji. Mare etaidukare tumeartoruwo dukodire ewijare mare ewiapaga pemegamodukare. Ekure mare ere tuioku mi taiwokawo Pao Kurireu rore jiboeji. – Ainore Pao Kurireu makore marigudu. ");
INSERT INTO bor_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mare tagi tagaidure tameartoruwo rugadu dukodire tagaiwore irore jiwu Pao Kurireu rore jiboeji. Tawiapaga pemegare imagore jiwu Pao Kurireu bataruji. Dukodire tarduwagodunure Pao Kurireu meardaeji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Imode tawie. Mariguduwuge makore Pao Kurireu bataru jiwuge etaidure rugadu tuiorduwo tardure jiwu irore jiboeji. Mariguduwuge ro pemegareuge etaidure rugadu tuiorduwo tardure jiwu irore jiboeji. Mare erdukare ji. Etaidure tumearduwo tameardure jiwu imagore jiboeji mare emeardukare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","– Dukodire čare imode tawie nou imagore jiwu bakaruji. ");
INSERT INTO bor_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ainore awu bakaru ure. Boe eire inagoino. Pao Kurireu o bataru ure nono nou boe a mogadure. Mare boe a ji karega inagoino. Pao Kurireu bataru aregodumode boe etae. Nono boe emeardumode Pao Kurireu bataruji. Dujire inagoino. Boe emeardumode Pao Kurireu bataruji dukeje bope doge eimijera umode nou Pao Kurireu bataru tawuje nou boe epiji nono nou kiebarege ere nou boe a tawuje awara piji dumogadure. Mare kiebarege ei karega inagoino. Bope doge eimijera jire inagoino. Umode boe ewiago Pao Kurireu bataru piji rugadu. Dujire inagoino. Dukodire nou boe emeartorumodukare Pao Kurireu bataruji rugadu. Emodukare tugimijerado ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ia boe emeardumode Pao Kurireu bataruji pugeje. Nono nou boe emode nono nou boture toriguru tadawu boe a mogadure. Nou boture toriguru tadawu boe a rakamodukare. Mare boe a ji karega inagoino. Boe eire inagoino. Nou boe eragamodukare tumeartoru raiwo Pao Kurireuji. Dujire inagoino. Emode tugeragu Pao Kurireu bataruji tiagare tabo mare emeartoru raimodukare ji. Dujire inagoino. Boe emode boe pegado ei dukeje emode tugera ra tumeartorure Pao Kurireu jitu piji kuri je. ");
INSERT INTO bor_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ia boe emeardumode Pao Kurireu bataruji pugeje. Awu boe emode nono nou boture botoguru tadawu boe a mogadure. Botoguru umode boe pegado ji umode bito. Mare boture botoguru tadawu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji. Etaidure tumeartoruwo ji mare kuri je emororamagadumode tu tumeardae boeji pugeje. Dujire inagoino. Emeardaere tu pudui tuwo to diero kurido. Dujire inagoino. Emeardaere to diero umode tuginorudo pagatu je. Dukodire emode tugera ra Pao Kurireu bataru piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mare ia boe emeardumode Pao Kurireu bataruji dukeje emeartorumode ji rugadu. Dukodire epemegamode rugadu nono nou boture moto pemegareu boe a mogadure. Mare boture moto pemegareu kejewu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji nono emeartorumode ji rugadu. Dujire inagoino. Emodukare tugera ra tumeartorure jitu piji rugadu jii toro rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus makore boei pugeje. Readodure ia bakaruji tuwo boe erduwado toro nouia Pao Kurireu meardaeji pugeje. Akore: – Imode tawie duba ure tugimijerado Pao Kurireu čewuge ere. Boemode ei du mode nono ia imedu moga ure to boepa pemegado dumogadure. Imedu ure boe a pemegareu tugu to boepato. ");
INSERT INTO bor_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dukejere boečoji boe eiamedu boe enudure. Mare nou boečoji ia jordu pegare nou imedu jiwu uture nou imedu o boepa ka. Ure boto a tugu nou boepato nou trigo oiadada. Dukeje uture pugeje. ");
INSERT INTO bor_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nou trigo a boture dukeje ričodure. Mare boto boture nou trigo tabo dukodire boto ričodure trigo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nou ore boepa čewu utugarege etaregodure tugimijera ae. Emagore tugimijeraji. Egore: “Čegimijera. Are trigo a pemegareu tugu ako boepa tada rugadu. Kočare kodiba boto boture nou trigo tabo rugadu?” ");
INSERT INTO bor_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","– Nou ore boepa čewu akore: “Imedu jordu pegare iwu ro pegare ino boepaji rugadu.” – Utugarege enarare ji. Egore: “Akaidure čeduwo ako boepato čewo nou boto tawuje moto piji čegera tabo čewo ako boepa akudo kana?” ");
INSERT INTO bor_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","– Ore boepa čewu akore: “Boro. Tamode boto tawuje moto piji dukeje nou trigo tawujedumode jamedu boto tabo. ");
INSERT INTO bor_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Parokawo boeji botoji ji je. Ričodumode trigo tabo gu nou trigo kurodumode du ka. Trigo kurodure dukeje imode nou umode trigo kadowuge ewie ewo boto kado boetoji. Emode boto kado trigo piji dukeje ewo boto kogudo. Nono emode barigu joruto tuwo boto kowu rugadu. Nono imagomode ei ewo trigo kado rugadu, ewo trigo reko nou ire trigo jeto tadawu bai ka.” Ainore Jesus akore. ");
INSERT INTO bor_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus readodure ia bakaruji pugeje tuwo boe erduwado toro nouia Pao Kurireu meardaeji pugeje. Akore: – Imode tawie nuba nou emode tugimijerado Pao Kurireu čewuge emode. Nou emode tugimijerado Pao Kurireu čewuge emagamodukare boetoji mare ia meri keje emagagodumode rugadu. Emode nono mostarda a mogadure. Imedu ure nou mostarda a tugu to boepato. ");
INSERT INTO bor_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nou mostarda a kurikare rugadu. Boe a jamedu boe kurire nou mostarda a kori. Mare boture dukeje ričodumode rugadu nou boe emode tugu to boepa tadaboe iku jamedu boe kori. Ričomode nono iguru mogadure. I kurimode. Tugu kurimode jamedu. Dukodire kiebarege emode tumugudo keje. ");
INSERT INTO bor_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nono Jesus readodure ia bakaruji pugeje tuwo boe erduwado toro nouia Pao Kurireu meardaeji pugeje. Akore: – Imode tawie nuba nou ere tugimijerado Pao Kurireu čewuge emode. Nou emode tugimijerado Pao Kurireu čewuge emagamodukare boetoji mare ia meri keje Pao Kurireu utugarege emagagodumode rugadu. Emode nono fermento mogadure. Aredu ure tugeragu fermentuji. Ure tugu trigo kuduto. Nono ure trigo kudu udo amireuče. Nou fermento jore nou amireu jamedu boeto. ");
INSERT INTO bor_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ainore Jesus akore. Readodu kigodure bakaruji boe ewiagai tuwo boe erduwado toro nouia Pao Kurireu meardaeji rugadu. Tu tureadodu tabore ure boe erduwado. ");
INSERT INTO bor_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dujire Pao Kurireu ure boe ewie marigudu. Akore: – Imagomode dukeje ireadodumode bakaruji iwo boe erduwado toro ia Pao Kurireu meardaeji. Marigudu Pao Kurireu ure nou tumeardae biado boe epiji boe erduwakawo ji. Ure moto towuje baru towuje dupijire boe erduwakare nou Pao Kurireu meardaeji. Nono ireadodumode bakaruji boe ewiagai iwo erduwado toro nou Pao Kurireu meardaeji rugadu. Ainore nou makore Pao Kurireu bataru jiwu akore marigudu. Ure nou tuwadaru bu bapera keje marigudu rugadu. Aino ča nou bataru jeture pudui rugadu. Jesus jire akoino. ");
INSERT INTO bor_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus ure nou tuwadaru akedudo dukeje uture nou boe epiji toro ia bai ka. Ure turemo nou baito. Nono nou Jesus ure jorduwadowuge etaregodure ae. Enarare ji. Egore: – Kaba jiba akagoino nou boepa tadawu botoguru bakaru jiboeji? ");
INSERT INTO bor_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus makore ewadaru jipagi. Akore: – Nou ure boe a pemegareu tugu to boepa towu ure nono Imedu Onaregedu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nou boepa ure nono boe emogadure. Nou boe a pemegareu ure nono nou ure tugimijerado Pao Kurireu čewuge emogadure. Nou boto ure nono nou meartorure bope doge eimijera jiwuge emogadure. ");
INSERT INTO bor_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nou ure boto tugu boepa towu ure nono bope doge eimijera mogadure. Boe ere nou boepa tadaboe kado dure nono Pao Kurireu umode moto akedudo kejewu meri mogadure. Nou ure boepa tadaboe kadowuge ere nono Pao Kurireu utugarege baru tadawuge emogadure. ");
INSERT INTO bor_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Mare boto ji karega inagoino. Meartorure bope doge eimijera jiwugeire inagoino. Boe a pemegareu ji karega inagoino. Ure tugimijerado Pao Kurireu čewugeire inagoino. Imedu Onaregedu umode tugirimi pugeje dukeje umode tudugarege baru tadawuge etudo tododai nou meartorure bope doge eimijera jiwuge ro pegareuge ewagai. Pao Kurireu utugarege baru tadawuge emode tugeragu nou meartorure bope doge eimijera jiwuge eiamedu boei nou ure tugimijerado Pao Kurireu čewuge epiji. Emodukare tugeragu nou ure tugimijerado Pao Kurireu čewugei. Nono nou Pao Kurireu utugarege baru tadawuge emode nou meartorure bope doge eimijera jiwuge ewarigu toro bope doge eda kejewu joru pegareuto. Nonore etragudu rakamode rugadu joru kori koia. Emode to reko pui tuwiri boe kori koia. ");
INSERT INTO bor_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mare nou ure tugimijerado Pao Kurireu čewuge ro pemegareuge emugumode nou Pao Kurireu apo. Ekimijera mode ema rugadu. Pao Kurireu umode emugu pemegado nono rugadu. Umode egaredo pudui rugadu. Boe eiamedu boe erdumode ei egarere pudui duji boe pemegare ei duji. Meardure awu inagoino jiwuge ewiapaga pemegawo awu iwadaruji rugadu tumeartoruwo ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus mako kimore boei. Readodure ia bakaruji ewiagai tuwo erduwado toro ia Pao Kurireu meardaeji. Akore: – Boe etaiduwo tuwo tugimijerado Pao Kurireuče nono boe etaidure biadodureu tori kuieje mori kurireu jitu mogadure. Nou tori kuieje tugudure mototo biadoduwo boe epiji. Toro ia meri keje imedu jordure nou biadodureu tori kuiejeji nou moto keje. Jakarere pudui rugadu. Mare utukare tabo raga. Ure tugu mototo pugeje jii tumode akirodo nou moto jitu ka. Dukeje rekodure tuibagi tuwai ka. Ure nouia toe jamedu boe maku diero bagai. Nou diero tabore ure akirodo nou motoji rugadu. Nono ore nou tori kuieje mori kurireuče jamedu. Ainore rore tuwo tugeragu nou tori kuieje mori kurireuji toče. Mare tori kuieje ji karega Jesus akoino. Boe ewo tuwia ra tumeardae jamedu boe piji tumeartoruwo Pao Kurireuji tuwo tugimijerado ema. Dujire akoino. ");
INSERT INTO bor_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesus makore boei pugeje. Readodure ia bakaruji ewiagai pugeje tuwo ewie nou Pao Kurireu meardaeji. Akore: – Nou ure tugimijerado Pao Kurireu čewuge ere nono ia umode akirodo pérola tori jiwu imedu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nou imedu aiwore ia pérola tori mori kurireu bagai. Jordure ia motureu mori kurireuji dukeje uture tuibagi tuwai ka. Ure toe jamedu boe maku diero bagai. Nou diero tabore ure tugirimi nou pérola tori mori kurireu bagai pugeje. Nou diero tabore ure akirodo nou pérola tori mori kurireuji rugadu. Ča boe etaiduwo rugadu tuwo tugimijerado Pao Kurireuče nono nou imedu aidure rugadu tuwo akirodo nou pérola tori mori kurireu jitu mogadure. Mare pérola tori ji karega Jesus akoino. Boe ewo tuwia ra tumeardae jamedu boe piji tumeartoruwo Pao Kurireuji tuwo tugimijerado ema. Dujire akoino. ");
INSERT INTO bor_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesus makore boei pugeje. Readodure ia bakaruji ewiagai pugeje tuwo ewie toro ia Pao Kurireu meardaeji. Akore: – Nou ure tugimijerado Pao Kurireu čewuge ere nono boe ewogure tabowu buke mogadure. Boe ere buke barigu dukejere ere tugeragu karei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nou buke korobadure karebo dukeje boe ere buke tawuje pobo piji toro pobo okwa ka. Nono boe ere kare etawuje buke piji. Karo pemegareugere boe ere tugu kadaraboto. Mare karo pegareugere boe ere barigu. ");
INSERT INTO bor_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Nou karo pegareuge ere nono meartorukare Pao Kurireu jiwuge emogadure. Karo pemegareuge ere nono nou ure tugimijerado Pao Kurireu čewuge emogadure. Mare karo ji karega inagoino. Boe eire inagoino. Imode moto akedudo dukeje imode Pao Kurireu utugarege baru tadawuge etudo itododai. Emage emode ro pegareuge etawuje nou meartorure Pao Kurireu jiwuge epiji. Nono emode nou ro pegareuge ewarigu toro bope doge eda kejewu joru pegareuto rugadu. Nono etragudu rakamode rugadu joru kori koia. Emode to reko pui tuwiri boe kori koia. ");
INSERT INTO bor_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nono Jesus unarare nou boei. Akore: – Tarduware awu imagore jiboe jamedu boeji kana? Egore: – Uu. Čerduware akagoino jiboeji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nono Jesus makore ei. Akore: – Jorduware Judeu doge eno bakaru jiwuge nure tagi. Aino ire tarduwado ure tugimijerado Pao Kurireu čewuge ere. Dukodire tare nono ia ore bai čewu mogadure. Nou ore bai čewu aiwomode tuwaito toe bagai. Nono jordumode nou ture tugeragu mariguduwu toeji. Mare jordumode nouia ture tugeragu jiwu toe maiwuji jamedu. Mare ore bai čewu ji karega Jesus akoino. Ture jorduwadowuge eire Jesus akoino. Boe enoe maiwu ji karega akoino. Ture erduwado jiboe jire akoino. ");
INSERT INTO bor_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus readodure awu bakaru jamedu boeji. Dukeje uture nou boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aregodure turijodure kejewu Nazaré ba kurireu ka. Uture nou Judeu doge ere bato puiwu bai ka. Nonore ure boe erduwado pugeje. Nou boe erdu pemegakare nou Jesus makore jiboeji. Egore: – Ioguduba ure awu imedu jorduwado? Ioguduba ure turaga maku ai ro rakawo awu turo rakareu boeji? ");
INSERT INTO bor_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Maragodure ira jiwu imedu onaregedu nure ema. Uče iere Maria. Uwie ime ekiere Tiago, José, Simão, Judas. Čerduware ji marigudu. ");
INSERT INTO bor_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Uwie areme emugu kimore woe awu pago ba kurireu keje rugadu. Boe eimijera karegure ema. Boe eimijera ukare jorduwado. Pagare akoino. Ro rakare mare pagatu je. ");
INSERT INTO bor_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dukodire nou boe etaidukare Jesus makore jiboeji rore jiboeji. Mare Jesus makore nou boei. Akore: – Makore Pao Kurireu bataru jiwu makore jiboe pemegamode boei. Boe emeartorumode ji. Mare turijodure kejewu boe eda kejewuge etaidumodukare makore jiboeji. Uwai tadawu boe etaidumodukare makore jiboeji. Tu emage rugadu. Iage etaidumode ji. ");
INSERT INTO bor_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dukodire Jesus ukare turo rakareu makado nono Nazaré ba kurireu keje. Emeartorukare Jesusji dukodire ukare turo rakareu makado nono rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ča boe eimijera governador nure Herodes toro nou Galiléia moto keje. Herodes meardure boe emagore Jesus akaru jituji. ");
INSERT INTO bor_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nono ča Herodes makore tudugaregei. Akore nou imedu nuie João Batistače. Emare jewoduie pugeje dukodire ro rakaie nono boe ereadodure jiboe mogaduie jamedu. Ainore Herodes akore. ");
INSERT INTO bor_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mare Herodes ure tiekiripagado. João Batista karega. João Batista bire marigudu. Marigudu Herodes ure boe edo tugeragu João Batistaji. Ere iera kogudo tuwo tugu baičoreuto. Mare paga karega. Herodes ure tugeragu tumana Filipe oredujeji tumana piji toreduječe. Nou aredu iere Herodias. Herodes ure tugeragu ji tumana piji tumuguwo apo rugadu. Dukodire João Batista mako pegare Herodes rore nono duji. Mako raire ji. Akore: – Arokaba aino amana oredujeji. Paro kigodukare aino. Ameartoru bokware dukodire amugure nou aredu Herodias apo. Ainore João Batista akore. ");
INSERT INTO bor_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Dukodire Herodes korigodure. Aidure tuwo João Batista bito mare pagudure boe eče. Boe etaidure João Batistaji. Emeardaere makore Pao Kurireu bataru jiwu nure ema rugadu. Dukodire Herodes roiwakare tuwo João Batista bito rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ia meri keje Herodes ure tuwadae towuje tuwiabutuwo tuwudure kejewu ariji meriji. Nou uwadae keje nou aredu Herodias onaregedu aredu rerure boe eiamedu boe egai. Moture rugadu. Ure Herodes jakaredo pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nono Herodes makore nou nogwareduji. Akore: – Ameartorudo i. Imode akogwamagudure bagaiboe jamedu boe maku akai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dukodire nogwaredu uture tuje bagai okituwawo pudui nuba turowo nuba togwamaguduwo Herodiji. Uče okituware ji dukodire okwamagudure João Batista aora bagai paduwo ia baku keje kuri aino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Boe eimijera Herodes kiarigodure. Makore nou boe egai tumoduie nou nogwaredu okwamagudure bagaiboe jamedu boe maku ai rugadu. Nou makore bagaiboe makudumode ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nono ča makore tugobaigaregei ewo João Batista aora kado nou baičoreu tada rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dukodire tugobaigarege etaregodure aora tabo. Padure baku keje rugadu. Nono ča ere maku nou nogwaredu ai. Dukejere ure reko toro tuje ae rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nono João Batista utugarege etaregodure tugimijera bireu ka. Nono ere tugeragu tugimijera biji. Ere reko toro to moto ka tuwo tugu mototo. Dukodire eture toro tureadoduwo Jesus biagai. ");
INSERT INTO bor_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jorduware boe pegare João Batista jituji. Dukodire čare Jesus ure tudawuje nou boe epiji. Nono ure taredo ika kurireuto tuduwo nou boe maereu ka turagojewo nono tuginaigodu. Du inodu tabo nou boe makareuge erduware kaiba rakojere. Tieda pijire nou boe eture tuwure tabo Jesus rekodaji. ");
INSERT INTO bor_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ča Jesus ure tudawuje ika kurireu piji. Aiwore, jordure boe emagare duji. Okudugodure ebo rugadu. Nono ča iogore nou kogodureugei, nou mugure nonowugei jamedu. ");
INSERT INTO bor_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nono ča nou Jesus ure jorduwadowuge etaregodure Jesus ae merirekodutabo. Ča egore: – Merirekodu. Awu boe etudo awu boe maereu piji. Emeardaere tuwo nou boe etudo ia boe etae ewo tugeragu ia tuge roguji. ");
INSERT INTO bor_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dukeje Jesus makogodure ewadaru jipagi. Akore: – Nou boe etumodukare. Taigoiare tamode enogwagedo. ");
INSERT INTO bor_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ča egore: – Čege amireure ikera aboudure tu je. Čege karo rogu ere pobetu je jamedu. ");
INSERT INTO bor_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus akore: – Arego mato itae. ");
INSERT INTO bor_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nono ča makore nou boei ewo tumugudo boebutu keje. Dukeje ure tugeragu nou amireuji nou kare kugurei jamedu. Nono ča aiwore baruto. Imadure Pao Kurireu apo nou amireu paru tabo nou kare kugure eparu tabo uwo nou amireu nou kare kugure eidodudo. Nono ča ure nou amireu kado puiato. Ča ure maku tudugarege etai ewo pedo boei. ");
INSERT INTO bor_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nono ča eiamedu boe enogwagere. Nono ča ekuredure egarere pudui rugadu. Ča nou utugarege ere nou kadarabo doge korau nou boe eke kobo tabo. Nou kadarabo dogere enodo padu kejeboere doze nou boe eke kobo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nou okwagereuge ime enodo padu kejeboere cinco mil. Ekare areme eremagu. Ekare etore eremagu jamedu. ");
INSERT INTO bor_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kuri je dukeje Jesus makore nou ture jorduwadowugei etuwo pobo maereu okwa ka ewo turemo ika kurireuto etuwo tododai. Ekurugoduwo nou pobo maereu kajeje toro bakowu ka. Jesus rakojere eiageje tumago tabo nou boei tuwo etudo. ");
INSERT INTO bor_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ure boe etudo dukeje Jesus ruture ia tori ao ka tumagowo Pao Kurireuji tuginaigodu. Nono ča boečodure. Mare Jesus mugu kimore nono tuginaigodu kimo. ");
INSERT INTO bor_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dukeje čare nou ure jorduwadowuge ekodure tabowu ika kurireu mugu kimore pobo maereu oiadada rugadu. Nono bakuru jore etogi dukodire nou pobo jetu rakare nou ika kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Toro baregodutabo, Jesus uture toro tumeru tabo pobo aoji. ");
INSERT INTO bor_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dukeje nou utugarege erdure Jesus merure pobo ao jituji. Dukodire etokudure tubagudu koia. Egore: – Pardure ia boe pegareuji! ");
INSERT INTO bor_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mare Jesus akore: – Taragado tai! Imi rugadu reo. Tabagudukaba. ");
INSERT INTO bor_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nono Pedro makore: – Ikimijera mode aki rugadu dukeje imerudo pobo aoji jii toro akae. ");
INSERT INTO bor_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus akore: – Mato. Dukodire čare Pedro ure tudawuje ika kurireu piji dukeje čare merure pobo aoji jii toro Jesus ae jamedu. ");
INSERT INTO bor_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mare puredugodure Jesus ae dukeje jordure bakuru rakare pudui duji. Dukeje ča pagudugodure. Nono ure tuwogwaiago poboto dukeje ča kudugodure. Akore: – Ikimijera! Akeragu ikeraji! Iwogwakawo poboto! ");
INSERT INTO bor_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kuri je Jesus ure tugera raido. Nono ča ure tugera kogudo Pedro iera kajeje. Makore Pedroji. Akore: – Ča ameartoru biagare tu je. Kodiba amororamagadure iwadaru boeji? Ameartorukanure i pugeje? ");
INSERT INTO bor_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nono ča ei pobedu ere turemo ika kurireuto. Nono ča bakuru akedure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nono ča nou Jesus ure jorduwadowuge emeartorure Jesusji rugadu. Ere tubu jodo tumago pemegawo Jesusji rugadu. Egore: – Pao Kurireu onaregedu nure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesus kurugodure ture jorduwadowugebo pobo maereu kajeje dukeje etaregodure Genesaré ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Boe erduware Jesusji dukodi ča ere mugure puredure puduiwuge kogodureuge ewie. Dukeje čare nou boe ere kogodureuge erego toro Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Boe enogwamagudure Jesusji nou kogodureuge ewo tugera bu nou Jesus ukudau areia okwa keje. Nou ure tugera bu ukudau areia okwa kejewuge epemegagodure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ča ia fariseu doge etaregodure Jerusalém piji. Nouia jorduware bakaru jiwuge jamedu etaregodure Jerusalém piji jamedu tumagowo Jesusji. Ča enarare ji. ");
INSERT INTO bor_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Egore: – Kodiba atugarege enogwagere tugera rorogodu tabo? Emeartorukare nou jaoboe emagore jiboeji. Erokare nono jaoboe ero mogadure. ");
INSERT INTO bor_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus makogodure ei. Akore: – Kodiba tameartorukare Pao Kurireu makore jiboeji? Tagodure tu nou tameardae rekodaji. ");
INSERT INTO bor_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ča Pao Kurireu akore: “Tameartorudo taoji, tajeji. Ča nou boe mako pegamode tuoji, tujeji tuwo epogurudo dukeje bitoduiago.” Ainore Pao Kurireu akore jawu tawobei. ");
INSERT INTO bor_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mare tagi tare boe erduwado ia bataru tuginaiwuji boe ekawo tugera maku tuwo ai tuje ai. Tagagore imedu makomoduie tujeji tuoji tumodukaie tugera maku etai tumoduie toe maku Pao Kurireu ai kodi. Dukodire tumodukaie tugera maku tuwo ai tuje ai. Ainore boe eromoduie. Mare pagare egoino. Etaidukare tuwo tugera maku tuwo ai tuje ai dukodire egoino. Taigoiare tare boe egodo aino. Dukodire čare tagaidukare Pao Kurireu bataruji rugadu. Tameartorukare ji. Tagaidure tagoduwo tu nou tameardae rekodaji. ");
INSERT INTO bor_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ča tamagore boei tawo boe erduwado. Mare tameartorukare tagagoino jiboeji. Tagodu pegare nou tagagoino jiboeji tarore jiboeji rugadu. Mariguduwu makore Pao Kurireu bataru jiwu Imedu Isaías mako pemegare. Makore ainore taromode rugadu duji. Akore: ");
INSERT INTO bor_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","– Pao Kurireu akore: “Awu boe emagore togwa tabo tumeartoruie i mare nou boe rugadu boe emeardae remawu ure tuginai rugadu toro imeardae piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awu boe ere tubu jodo tumago pemegawo i mare pagare egoino. Ere boe erduwado bakaruji. Egore iwadaruie. Mare pagare egoino. Ia tumagore jiwu bakaru jire nou boe egoino rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus makore boe makareuge etae ewo bato pui pudae. Akore: – Tawiapagado. Tarduwado. ");
INSERT INTO bor_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nou tagwagemode jiboe umodukare tabegado Pao Kurireu jakai dukodire tawujedumodukare mugure tagabowu tago bakaru piji rugadu. Mare nou taiabijiwu tawadaru pegareu emare umode tabegado Pao Kurireu jakai dukodire tawujedumode mugure tagabowu tago bakaru piji rugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ča nou Jesus ure jorduwadowuge ere tuburedo ji. Egore: – Nou fariseu doge ekorigodure nou amagore čei jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ča Jesus makore pugeje. Akore: – Nou baru tadawu Iogwa ukare tuguwu iguru rugadu boe tawujedumode. Mare iguru ji karega inagoino. Nou fariseu doge eire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dukodire tamororamagadukaba nou fariseu dogei. Eku bokware. Mare nou joku bokwareu iera bararemode nou timedia joku bokwareuji dukeje ei pobedu ewudumode nou boeiakoto. Mare eku bokwa ji karega inagoino. Emeardae pegare nou Pao Kurireu meardae remawu piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ča Pedro okwamagudure: – Čerduwado nou akagoino mariguduboe jiboeji čewiagai. ");
INSERT INTO bor_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus akore: – Kočare tagaora rakare tarduwagoduwo boe remawuji? ");
INSERT INTO bor_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nou tagwagere jiboe utumode tagurito mare umode tudawuje tabiji. ");
INSERT INTO bor_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mare nou umode tudawuje taiabijiwu tawadaru aregodumode nou tameardae piji. Nou inodu koiare umode boe epegado Pao Kurireu jakai dukodire etawujedumode to bakaru tadawu turo piji jii je. ");
INSERT INTO bor_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Du nou tameardae pegareu aregodumode tabiji rugadu. Nou umode boe ewidowu, nou jeribarimode toreduje pijiwu toredu pijiwu, nou umode turo pegareu tieribari tabowu, nou iwogureu, nou umode boe ekiripagadowu, nou mako pegamode timedia ro jiwu. ");
INSERT INTO bor_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Awu boe ero pegareu koiare umode boe epegado rugadu Pao Kurireu jakai dukodire etawujedumode to bakaru tadawu turo piji rugadu. Mare boe enogwagemode tugera rorogodutabo du umodukare boe epegado Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus ure tudawuje nou boe piji nono utu puredure nouia boe eda ka. Nou boe eda mugu puredure nou Tiro ba kurireuji, nou Sidom ba kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ča nouia aredu cananeu kejewudo mugure nou moto kejewudo ure tuburedo Jesus ae. Ča kudugodure boe eiamedu boe emearduwo. Akore: – Ikimijera nure aki. Jawu boe eimijera kurireu Davi onaregedu nure aki. Ča akogududo itabo. Bope meture itonaregedu aredu tada. Ro pega kigodure ji dukodire boe pegare ji rugadu. Awo nou bope tawuje itonaregedu piji. ");
INSERT INTO bor_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mare Jesus makokare boeji. Dukodire čare ure jorduwadowuge etaregodu puredure ae. Ča egore: – Awu aredu utudo pabiji. Ukare boe kiorodo paregodaji. ");
INSERT INTO bor_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ča Jesus makogodure: – Imi itaregodure woe itaiwowo nou Israel doge egu ovelha okwareuge ewagai. Mare ovelha ji karega inagoino. Israel moto kejewu meartorukare Pao Kurireu jiwuge eire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ča nou aredu aregodure. Ča ure tubu jodo moto keje Jesus bure keje. Ča akore: – Akera maku inai. ");
INSERT INTO bor_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus akore: – Ukare turugadu boe ewo tore eke rogu tawuje epiji tuwo maku tagu ariga doge etai. ");
INSERT INTO bor_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ča aredu makogodure: – Boe rugadu. Mare ariga doge emode nou buture nou ira kudawu boe eke gigudu rugadu boe kowuje. ");
INSERT INTO bor_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ča Jesus akore aino nou areduji. Akore: – Aredu. Ameartoru kurire i rugadu. Nou akaidure bagaiboe todumode rugadu. Ča kuri je nou aredu onaregedu pemegagodure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus ure tudawuje nou boe epiji. Nono uture toro nou Galiléia pobo maereu okwa ka. Nono Jesus kodure nou Galiléia pobo maereu okwaji. Nono ča ruture nouia tori ao ka. Ča ure tumugudo nono. ");
INSERT INTO bor_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nono ča boe makareuge eture Jesus ae. Ere nou kogodureuge erego toro Jesus ae. Nou joku bokwareuge, nou mako bokwareuge, nou meru bokwareuge, nou pogora pegareuge, nou kana pegareuge, nou kogodureuge jamedu ere erego toro Jesus ae. Nono Jesus iogore eiamedu boei. ");
INSERT INTO bor_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nou boe erore ta je erdure nou mako bokwareuge emagore duji, nou kana pegareuge nou pogora pegareuge epemegagodure duji, nou meru bokwareuge emerure duji, nou joku bokwareuge etaiwore duji. Nono ča nou boe emago pemegare Pao Kurireuji. Egore: – Israel moto kejewu pawobe emeartorure jiwu Pao Kurireu ro pemegare pai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus makore nou ture jorduwadowuge etae. Nono ča makore ei. Akore: – Inogudugodure awu boebo. Merire pobe metia bokware ei woe itabo. Woe boe eke bokware rugadu ewo ko. Itaidukare iwo etudo tuguri bioro tabo. Eragamodukare tumeruwo awaraji tuguri bioro tabo. ");
INSERT INTO bor_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nono ča Jesus ure jorduwadowuge egore nou boe emagaie nono dukodire enaragodure nuba turomoduie nou boe maereuto boe eke bagai nou boe ekeje. ");
INSERT INTO bor_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus akore: – Nuba tage amireu rogure tu je? Egore: – Amireu oto padure sete. Kare kugure enowarore tu je. ");
INSERT INTO bor_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nono ča Jesus makore nou boe ewo tumugudo moto keje. ");
INSERT INTO bor_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nono ča ure tugeragu nou sete amireuji nou kare kugurei jamedu. Nono ča imadure Pao Kurireu apo nou amireu paru tabo nou kare kugure eparu tabo jamedu uwo nou amireu nou kare kugure eidodudo. Nono ča ure kado puiato. Ure maku nou ture jorduwadowuge etai. Nono ere reko nou boe etae. Ere pedo boei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nono ča nou boe eiamedu boe enogwagere rugadu. Egarere pudui rugadu tuguredure duji. Nono ča nou Jesus ure jorduwadowuge ere kadarabo korobadureugedo sete nou boe eke kobo tabo. ");
INSERT INTO bor_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nou okwagereuge boe enodo padu kejeboere quatro mil ime. Aremere jamedu. Boe etore kugurere jamedu. ");
INSERT INTO bor_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nono ča Jesus makore nou boei etuwo. Ča ure taredo nou ika kurireuto. Nono ča uture nou pobo maereu kajeje toro nou Magadã ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nouia fariseu doge nouia saduceu doge jamedu eture tumagowo Jesusji. Etaidure tuiorduwawo nouia ro rakareu bagai. Dukeje enogwamagudure Jesusji uwo ia turo rakareu to tiagai tuiorduwo nouia ro rakareu aregodure rugadu Pao Kurireu piji du bagai. ");
INSERT INTO bor_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mare Jesus makogodure: – Baru kujagure merirekodutabo dukeje tamagore boe pemegamoduie baru kujaguie dukodi. Bubutumodukaie barogwato. Ainore tagagore. Ainore tarduware. ");
INSERT INTO bor_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mare baru kujagumode braekododutabo dukeje tagagore bubutumoduie baru kujagure boe tugure dukodi. Tarduware tagaiwowo baruto. Tarduware boetugu umode bubutudo. Kočare iro rakare jiboe ukare tarduwado Pao Kurireu meardae remawuji? ");
INSERT INTO bor_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tagi taro pegare tameartorukare Pao Kurireuji. Dukodire tagogwamagudure ia iro rakareu bagai mare pagatu je. Ča marigudu jawu makore Pao Kurireu bataru jiwu Jonas jiboere makudumode tagai. Mare boemode i nono boe moga Jonas jitu mogadure jamedu. Dujire inagoino. Dukodire boe erduwamode i rugadu. Mare du inodu tabo tameartorumodukare i. Tamagore i iwo ia iro rakareu tawuje taegai. Mare pagatu jere tagagoino. Dukodire iromodukare ia iro rakareuji taegai pugeje. Jesus ure tuwadaru akedudo dukeje ure tudawuje epiji. Ča uture. ");
INSERT INTO bor_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dukeje nou Jesus ure jorduwadowuge ekurugodure Jesus apo toro nouia pobo maereu okwa ka. Nono ewiagodure tuwo nouia tuge amireu towuje. ");
INSERT INTO bor_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus makore ei. Akore: – Tamearduwadudo tai nou fariseu doge nou saduceu doge eno fermentuji. ");
INSERT INTO bor_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nou Jesus ure jorduwadowuge emagore pui kaba jiba akoino nou fermento jiboeji. Nono egore pui: – Pawiagodure page amireu piji dukodire pagimijera akoino pai. ");
INSERT INTO bor_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus jorduware egoino pui duji. Nono unaragodure ei. Akore: – Kodiba tamagore pui nou tage amireu bokwaie duji? Tameartoru kurikare. Tameartoru biagare tu je. ");
INSERT INTO bor_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kočare tarduwa bokware kimo. Tawiabutudo nou irore jiboe keje nou amireu rogu ure ikera aboudure tu je. Dutabore ire boe enogwagedo nou ime enodo padure cinco mil. Ča nuba tare nou kadarabo dogedo nou boe eke kobo tabo? ");
INSERT INTO bor_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ča ia meri keje pugeje nou amireu doge enodo padure sete boe etai pugeje du nou ime enodo padure quatro mil. Ča nuba tare nou kadarabo dogedo nou boe eke kobo tabo? ");
INSERT INTO bor_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kočare tarduwakare kimo imago karegure amireu jiboeji. Imagore tai tamearduwaduwo tai nou fariseu doge nou saduceu doge emeardaere jiboeji. Emeardae ure nono fermento mogadure. Mare fermento ji karega inagoino. Emeardaere jiboe jire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nono ča nou Jesus ure jorduwadowuge ere tuwia tugu boeto nou Jesus akoino jiboeji. Dukodire erduwagodure makore pudui jiboeji. Erduwagodure fermento remawu ji karega akoino duji. Mare nou fariseu doge nou saduceu doge ere boe erduwado jiboe jire akoino. Dujire Jesus akoino ture jorduwadowugei emeardu waduwo pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus uture ia moto ka ture jorduwadowugebo. Etaregodure toro dukeje ure tuwuredo ebo. Epuredure nou Cesaréia Filipe ba kurireuji. Nono ča Jesus unaragodure nou ture jorduwadowugei nuba boe emeardaere nou Imedu Onaregeduji. ");
INSERT INTO bor_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Emage emagogodure: – Boe egore João Batista nuie aki. Nouiage egore Elias nuie aki. Nouiage egore Jeremias nuie aki. Nouiage egore ia mariguduwu makore Pao Kurireu bataru jiwu nuie aki. ");
INSERT INTO bor_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus unaragodure ei pugeje. Akore: – Tagi. Nuba tameardaere i? ");
INSERT INTO bor_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nono ča Simão Pedro makogodure. Akore: – Umode boe ekinorudowu nure aki rugadu. Pao Kurireu remawu onaregedu nure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus makore Pedroji. Akore: – Akiere Simão. João onaregedu nure aki. Boe remawu jire akagoino. Mare boe ekare arduwado. Pao Kurireu koiare ure arduwado aino. Dukodire boe pemegare ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dukodire inagoino ai akire akiere Pedro. Awu tori tabore imode iwai towuje. Mare iwai ji karega inagoino. Meartorure iwuge emagagodumode. Dujire inagoino. Imode emagagodudo rugadu. Bope doge etaidumode turo pegawo ei. Mare du inodu tabo boe emagamode tumeartorure i dutabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nono imode mugure baru tadawu chave maku akai. Mare chave ji karega inagoino. Ardu pegamode boe erore jiboeji woe moto keje baru tadawuge erdu pegamode ji jamedu. Dujire inagoino. Nono ardu pemegamode boe erore jiboeji woe moto keje baru tadawuge erdu pemegamode ji jamedu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nono Jesus makore nou ture jorduwadowugei ereadodukawo boe ewiagai umode boe ekinorudowu nuie pudumi duji. ");
INSERT INTO bor_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nono ča Jesus makogodure rugadu nou ture jorduwadowugei. Akore: – Itumode nou Jerusalém ba kurireu ka. Nonore Judeu doge eimijerage emode boe pegado i rugadu. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ero pegamode i jamedu. Nou jorduware Judeu doge eno bakaru jiwuge emode boe pegado i jamedu. Nou boe eiamedu boe emode iordudo boe koriji rugadu. Iwimode rugadu. Mare merimode pobe metia bokware i dukeje iewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mare Pedro aidukare nou Jesus makore jiboeji. Ure tumegido Jesus apo kuri nono tumagowo ji. Akore: – Boe modukare aino ai. Pao Kurireu aidukare boewo aino ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mare Jesus ure tumegido nono makore Pedroji. Akore: – Akaradai ikoda piji bope Satanás. Are nono ia tori mogadure nou itowara oiadada. Arore aino i awo iwududo. Mare tori ji karega inagoino. Ameardae jire inagoino. Ameardaere nono boe emeardae mogadure. Boe emeardae kare nono Pao Kurireu meardae mogadure dukodi. ");
INSERT INTO bor_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nono Jesus makore nou ture jorduwadowugei. Akore: – Ia tagi tagaidumode tameartoruwo i dukeje tagera ra nou taro pegareu piji, tawia ra tameardae pegareu piji tagaidure jiboe piji. Tado tarugadu boe pegawo tai nono boe pegamode i dumogadure. Iwimode ipo padure pugajejewu keje. Dukodire inagoino tai tado tarugadu tagoduwo itabo. ");
INSERT INTO bor_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Boe etaidumode tuwo boe pemegado tu pudui turaga tabo dukeje nou boe eraga akedumode epiji rugadu. Egare remawu modukare. Emodukare činorudo bope doge eda kejewu joru pegareu piji rugadu. Mare nou boe ewiapagamodukare tumeardaeji pugeje tuwo tugera ra turo pegareu piji tumeardae pegareu piji taidure jiboe piji dukeje Pao Kurireu umode boe pemegado ei, umode egare remawudo rugadu. Nono ewarigudumodukare bope doge eda kejewu joru pegareuto jamedu. ");
INSERT INTO bor_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Boe emode toedo boe jamedu boeče. Mare nou enoe umodukare erududo baruto. Boe ewiagorokare tuwo tumeartorudo Pao Kurireuji. Ewiagorore tu tuwo toe kurido pagatu je. Mare paga karega inagoino. Boe emodukare turudure barutodu morido toe tabo. ");
INSERT INTO bor_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Imedu Onaregedu nure imi. Imode ikirimi mato moto ka pugeje. Itaregodumode nono iraga mode nono iogwa raka mogadure. Itaregodumode Pao Kurireu utugarege baru tadawugebo. Itaregodumode iogwa o jorugu pemegareu tabo. Nono imode ro pegareuge ero morido etai rugadu. Imode ro pemegareuge ero morido etai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Boe jokodu jire inagoino tawiagai. Imedu Onaregedu nure imi. Imode boe eimijera kurireudo imi dukeje imode ikirimi pugeje. Ia tagi tardumode awu inagoino jiboeji. Tawimodukare jii toro tardumode awu inagoino jiboe jitu ka. ");
INSERT INTO bor_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Meri oto padure seis Jesusji pugeje. Nono ča uture ia ture jorduwadowugebo toro ia tori ričoreu ao ka. Nou ure jorduwadowuge ere pobe metia bokware. Pedrore, Tiagore, Joãore. Tiago uwie nure Joãoče. ");
INSERT INTO bor_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Etaregodure nou tori ao ka rugadu. Nonore Jesus jere tuginai. Nou ure jorduwadowuge erdure ji rugadu. Mare Pao Kurireu koiare ure Jesus je udo aino. Dukodire Jesus jere nono meri joku urugu mogadure. Dukodire je ure nono jorugu urugu mogadure. Pao Kurireu ure Jesus ukudau areia kigadu maereudo ji. Kigadure rugadu kigadureboe jamedu boe kori. ");
INSERT INTO bor_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nono ča rore puku ei ime pobedu doge edure nono ebo. Moisere, Eliare edu nono tumago tabo Jesusji. ");
INSERT INTO bor_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nono Pedro makore Jesusji. Akore: – Čegimijera nure aki rugadu. Padure woe dure turugadu pai. Ameardaemode nono imeardaeji dukeje imode ia mačebradudo pobe metia bokware woe. Iamode akai. Iamode Moisés ai. Iamode Elias ai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro mako kimore dukeje nono ia boetugu ure turawuje etae. Nou boetugu urugu kigadure rugadu. Ure taiado ebo. Nono nou boe emeardure ia boe emagoji nou boetugu piji. Akore: – Itonaregedu reo. Imeardu kurire ji rugadu. Rore jiboe ure iagaredo i rugadu. Tawiapaga pemegado awu itonaregedu bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nou Jesus utugarege emeardure nou bataruji dukeje epagudugodure rugadu. Nono ere tubu jodo tori keje. ");
INSERT INTO bor_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mare Jesus ure tuburedo ei nono ure tugera bu ewugeje. Akore: – Taragojedo. Tabagudukaba. ");
INSERT INTO bor_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nono ere turagojedo. Nono ere tie maedo mare erdukare ia boei pugeje. Tu emage eragojere nono Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nono ere turawuje nou tori ao piji. Dukejere Jesus makore ei. Akore: – Tareadodukaba tardure jiboeji boe ewiagai. Imedu Onaregedu nure imi. Iewodumode pugeje dukeje tareadodumode awu tardure jiboeji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nou ure jorduwadowuge enarare ji. Egore: – Kodiba pawobe erduware Judeu doge eno bakaru jiwuge egore Elias aregodumoduie nou umode boe ekinorudowu otodai? ");
INSERT INTO bor_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus akore: – Boe jokodu. Pao Kurireu akore Elias aregodumoduie rugadu. Umoduie boe ewie ewo tudo turugadu nou umode boe ekinorudowu togi. ");
INSERT INTO bor_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mare inure tawie. Nou Pao Kurireu makore jiwu imedu Elias aregodure marigudu. Rore nono Elias ro mogadure. Mare boe etaidukare ji. Ero pegare ji tumeardae pegareu tabo. Inure tawie. Imedu Onaregedu nure imi. Nou boe ero pegamode i nono erore jitu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nono nou Jesus ure jorduwadowuge erduwagodure João Batista jire Jesus akoino duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nono Jesus ure turawuje tori ao piji boe etae pugeje Pedro apo, João apo, Tiago apo. Boe emagare nono. Nono ča ia imedu aregodure Jesus ae rugadu. Ure tubu jodo moto keje Jesus jokorai. ");
INSERT INTO bor_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nou imedu makore Jesusji. Akore: – Boe eimijera nure aki. Inogwamagudunure ai akoguduwo itonaregedu iparedu apo. Boe pegare ji rugadu. Ia boe kogodae pegareu jeture ji dukodire butumode moto ka pagatu je. Boe romode puku ji buture duji. Butumode joruto. Butumode poboto. ");
INSERT INTO bor_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Itaregodure apo nouia are jorduwadowuge ewagai ewo pemegago. Mare eroiwakare tuwo pemegago rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus makore ei. Akore: – Tare ikiarigo. Tameartorukare rugadu. Tarduwakare tawo tameardae pemegado. Iragoje raimodukare tagabo. Nuba tagaidure irowo tameartoruwo i? Nono Jesus makore iagei. Akore: – Mato nou iparedu apo itae! ");
INSERT INTO bor_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus mako pegare nou meture nou iparedu tadawu mareboeji. Dukodire ure tudawuje nou iparedu piji rugadu. Nono ča nou iparedu pemegare rugadu. Jesus ure pemegago tači je rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nou boe eture dukeje Jesus rakojere nou ture jorduwadowugebo. Emagore Jesusji. Egore: – Kodiba čeroiwakare čewo nou mareboe tawuje nou iparedu piji? ");
INSERT INTO bor_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus makore ewadaru jipagi. Akore: – Iwo tawie. Tameartoru biagare Pao Kurireuji kodire taroiwakare. Mare tameartoru biagamode Pao Kurireuji mare tamode taragado tai tameartoru rakawo tu jao. Nono tamagomode ia tori ričoreuji uwo tudawuje tumuga piji. Nono Pao Kurireu koiare umode nou tori ričoreu meartorudo tawadaruji rugadu. Pao Kurireu raka koiare umode taroiwado boe jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Boe emodukare togwa ra tuge piji jao tumagowo Pao Kurireu bagai baruto dukeje eroiwamodukare tuwo awu inodu mareboe tawuje boe epiji. Boe emode togwa ra tuge piji ia meri keje togwamaguduwo Pao Kurireu bagai baruto nono eroiwamode tuwo awu inodu mareboe tawuje boe epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesus uture nou moto piji ture jorduwadowugebo jii toro nou Galiléia moto ka. Nonore Jesus makore nou ture jorduwadowugei. Akore: – Imedu Onaregedu nure imi. Imagudumode ro pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Emode iwido. Mare merimode pobe metia bokware dukeje iewodumode pugeje. Dukodi nou Jesus ure jorduwadowuge ekiarigodure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus aregodure ture jorduwadowugebo Cafarnaum ba kurireu ka. Nono nou Pao Kurireu uwai pijiwuge ime etaregodure Pedro ae. Ure tugeragu boe enoe mori jiwuge nure emage. Ere tugeragu Pao Kurireu uwai mori roguji boe eiamedu boe epiji tuwo maku Pao Kurireu uwai tadawuge eimijera ai. Awu ime emaragodae nure nou inoduče rugadu. Nono enarare Pedroji. Egore: – Nou ure tarduwadowu imedu umode Pao Kurireu uwai mori maku kana? ");
INSERT INTO bor_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro akore: – Uu! Ure maku rugadu. Nono Pedro uture epiji. Ure turemo Jesus rakojere tadawu baito. Nouia utugarege edu nono jamedu. Nono Jesus makore boetoji. Akore: – Nuba ameardaere Pedro? Ioguduba pijiba moto kejewu boe eimijerage emode tugeragu boe enoe moriji? Emode tugeragu ji tuwobe epiji? Emode tugeragu ji ia boe tuginaiwuge epiji kana? ");
INSERT INTO bor_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro akore: – Boro. Emode tugeragu boe tuginaiwuge enoe moriji mare emodukare tugeragu tuwobe enoe moriji rugadu. Jesus akore: – Uu. Boe jokodu jire akagoino. Emodukare tugeragu tuwobe enoe moriji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ča Pao Kurireu Onaregedu nure imi dukodire ukare turugadu iwo nou Pao Kurireu uwai mori maku. Mare pagawo nou Pao Kurireu uwai tadawuge eimijera korigo. Pawo nou mori maku rugadu. Ča atudo toro nou pobo maereu ka. Awodiku barigu. Amode bitowu karo boetojiwu okwa jado. Nou karo okwa ja tadare ardumode ia diero toriji. Nou diero umode turugadu pai pawo nou Pao Kurireu uwai mori maku. Nou tardumode jiwu diero tori reko nou ure tugeragu Pao Kurireu mori jiwuge etae rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nono ča nou Jesus ure jorduwadowuge etaregodure Jesus ae. Enarare ji. Egore: – Pao Kurireu umode boe eimijera kurireudo pudumi dukeje umode boe eimijeragedo iageče jamedu. Ča duboba umode emage? ");
INSERT INTO bor_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus makore ia boe etonaregedu rogu bagai. Makore ji rakojewo nono nou boe etoiadada. ");
INSERT INTO bor_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nono Jesus akore: – Boe remawu jire imode tawie. Tamodukare tameardae udo nono boe etore emeardae mogadure dukeje tamodukare tagimijerado Pao Kurireuče. Tamodukare taremo baruto. ");
INSERT INTO bor_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mare boe emode tumeardae pemegado tugawo boe remawugedo pudumi nono boe etore emogadure dukeje Pao Kurireu umode boe eimijerage paru towugedo emage. Pao Kurireu umode boe eimijera kurireudo pudumi dukeje umode boe eimijera paru towugedo emage jamedu. ");
INSERT INTO bor_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Boe emode tugera podo boe etonaregedu apo dukeje itabore ere tugera podo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Boe emode tori kurireu kogudo imedu itoru kajeje tuwo barigu poboto dukodire nou barigudure pobo towu imedu bimode rugadu. Mare ia boe umode nou itore meartorure maibari iwuge edo tugera ra ipiji ero pegawo pugeje dukeje boe pegamode nou ure nou boe etore etaora pegadowuji rugadu. Jire boe pegareu kodumode nou barigudure pobo towu imedu kori. ");
INSERT INTO bor_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Boe pegamode meartorukare iwugei. Ere tumeardae kodudo boe emeardae pegareu kodaji dukodire boe pegamode ei ero pegareu moriče. Boe emeardae pegareu makudumode boe etai tu tu je emeardae pegawo ero pegawo jamedu. Mare boe pegamode rugadu nou ure tumeardae pegareu maku boe etaiwugei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jesus mako kimore: – Tagera umode taro pegado tameartorukawo i dukeje tagera kado tabiji. Tawure jamedu umode taro pegado tameartorukawo i dukeje tawure kado tabiji. Mare tagera remawu tawure remawu ji karega inagoino. Tameardae pegareu jire inagoino tawo barigu tabiji. Mare paga karega. Tameartorumodukare i dukeje tawarigudumode bope doge eda kejewu joru maereuto. Nou joru akedumodukare rugadu. Tadumode toro dukeje boe pegamode tai rugadu jii toro rugadu. Mare tameartorumode i dukeje imode tarududo baruto. Tadumode toro dukeje boe pemegamode tai nono jii toro rugadu. Kodire inagoino tai. Boe ekera umode mitotu je, boe ewure umode mitotu je mare du inodu tabo emeartorure i dukeje erudumode baruto rugadu tuwikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Taeku jamedu umode taro pegado tameartorukawo i dukeje taeku tawuje tabiji. Mare taeku remawu ji karega inagoino. Tameardae pegareu jire inagoino tawo barigu tabiji. Mare paga karega. Tameartorumodukare i dukeje tawarigudumode bope doge eda kejewu joru maereuto. Nou joru umode boe ekowu jii toro rugadu. Nou joru akedumodukare. Mare tameartorumode i dukeje imode tarududo baruto. Tarudumode baruto dukeje boe pemegamode tai rugadu jii toro rugadu. Kodire inagoino tai. Taeku umode mitotu je mare tameartorure i rugadu dukeje tarudumode baruto rugadu tawikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Jesus mako kimore: – Taeku jado. Tardu pegakaba nou meartorure maibari iwugei. Itore nure emage. Pao Kurireu utugarege baru tadawuge emagore awu itore eparu tabo Pao Kurireu bagai. Nou Pao Kurireu utugarege baru tadawuge edu nono Pao Kurireu apo tu je. Imedu Onaregedu nure imi. Itaregodure iwo ure tuwarigu boetowuge ekinorudo etukawo bope doge eda kejewu joru pegareuto, etuwo baruto rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesus mako kimore: – Ireadoduwo ia bakaruji tawiagai iwo tarduwado ia Pao Kurireu meardae pemegareuji. Ia imedu aku carneiro doge enodo padure cem. Ia okware boeto nou iage epiji. Nou akure čewu imedu uture rugadu nou tagu noventa e nove carneiro doge epiji taiwowo nou okware boetowu carneiro bagai rugadu. Nou noventa e nove carneiro doge edure nono boebutu pemegareu keje. Mare nou akure čewu imedu aiwore rugadu nou okware boetowu tagu carneiro bagai jii toro tuiordure jitu ka. ");
INSERT INTO bor_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jordure ji dukeje jakaregodure pudui rugadu. Jakarere tagu noventa e nove carneiro dogei. Mare jakarere pudui rugadu nou tuiordure jiwu carneiro roguji nou tiagarere noventa e nove carneiro dogei du kori. ");
INSERT INTO bor_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iwo tawie. Pao Kurireu aiwomode meartorumode puduiwuge ewagai nono nou imedu aiwore tagu carneiro bagai dumogadure. Mare carneiro ji karega inagoino. Boe eire inagoino. Emeartorumodukare Pao Kurireuji dukeje emode tuwarigu boeto. Ewarigudumode bope doge eda kejewu joru maereuto. Pao Kurireu aidukare boewo aino boei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus mako kimore: – Ia meartorure iwu ro pegamode ia tai dukeje atudo toro ae awo nou ro pegare aiwu bie. Amagodo ji ro pegare ai du boeji. Mare amago rakakaba ji. Tu aki amagodo ji. Tamagodo tu pui. Nono nou ro pegare aiwu biapagamode amagore jiboeji dukeje amedia mode ema. Tamedage mode pugi pugeje. Awiagodumode nou ro pegare ai dupiji. ");
INSERT INTO bor_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mare biapagamodukare amagore pudui duji dukeje akaiwodo ia meartorure iwuge ewagai. Emode mito pobe dukeje atudo ebo toro nou ro pegare aiwu bagai pugeje. Nou uture akabowuge ewiapagamode tamagore pui jiboeji. Ainore padure bapera kejewu Pao Kurireu bataru akore marigudu. Makore boei erowo pui tuwo tumeardae pegare puidu barigu pubiji. Akore: “Boe ewo pobe, boe ewo pobe metia bokware emagore jiboe uwo nono pu mogadure boe erduwawo boe remawuji.” Ainore padure bapera kejewu Pao Kurireu bataru akore marigudu. ");
INSERT INTO bor_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dukodire atumode amedagebo nou ro pegare aiwu bagai mare nou ro pegare aiwu biapagamodukare amagore jiboeji, amedage emagore jiboeji dukeje atumode nou meartorure iwuge ere bato puiwu bai ka tawo nou meartorure iwuge eiamedu boe ewie nou ro pegare aiwu ro pegare jiboeji. Nono nou meartorure iwuge emagomode nou ro pegare aiwuji jamedu. Biapagamodukare nou meartorure iwugei dukeje tamode tagera ra nou ro pegare aiwu piji. Tamode udo nono meartorukare iwu mogadure taegai. Tamode udo nono ia ro pegareu ure tugeragu boe enoe mori jiwu iwogureu mogadure taegai. ");
INSERT INTO bor_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Inure tawie boe remawuji. Tardu pegamode boe erore jiboeji woe moto keje du baru tadawuge erdu pegamode ji jamedu. Nono tardu pemegamode boe erore jiboeji woe moto keje du baru tadawuge erdu pemegamode ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Iwo tawie pugeje. Ia tagi tamode pobe, tamode pobe metia bokware dukeje tamode bato pui tamagowo pui, tarduwawo imeardaeji. Nono iragojemode tagabo rugadu. Dukodire tameardaemode nono pu meardaere dukeje tamagomode nou tameardaeji Pao Kurireu bagai baruto dukeje Pao Kurireu umode nou tagogwamagudure bagaiboe udo turugadu tai ure nono imeardae mogadure dukodi. ");
INSERT INTO bor_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesus akoino dukeje Pedro ure tuburedo Jesusji. Unarare: – Čegimijera nure aki. Ia meartorure aiwu ro pegamode i dukeje nuba iromode ji? Iwiagodumode nou ro pegare iboe piji kana? Mare ro pegamode i oto padumode sete dukeje nuba iromode? Iwiagodumode nou ro pegare iboe jamedu boe piji rugadu kana? ");
INSERT INTO bor_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus makore nou Pedro bataru jipagi. Akore: – Iwo awie rugadu. Sete karega. Ia meartorure iwu ro pegamode ai dumode setenta e sete dukeje awiago nou ro pegare aidu jamedu boe piji. ");
INSERT INTO bor_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesus mako kimore. Akore: – Ireadoduwo iwo tarduwado nou Pao Kurireu meardaeji tawiagai. Pao Kurireu umode boe eimijerado pudumi dukeje romode nono ia boe eimijera kurireu ro mogadure. Nou boe eimijera aidure tuwo nou tudugarege ere tugeragu jiboe mori makuduwo pudai. ");
INSERT INTO bor_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dukodire makore tudugarege ewagai ewo nou mori maku pudai rugadu. Ča ia utugare aregodure tugimijera ae. Nou utugare ure tugeragu jiboe kurire rugadu. Maragodumode jii toro tuwi ka mare umodukare tugeragu jiboe morido ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nono roiwakare tuwo nou mori maku tugimijera ai rugadu. Dukodire nou boe eimijera makore tumoduie nou tudugare maku oreduje maku ore kugure emagu jamedu diero bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jesus mako kimore: – Nou boe eimijera utugare jorduware nou tugimijera meardaeji dukeje ure tubu jodo moto keje nou tugimijera jokorai. Okwamagudure tugimijeraji. Akore: “Akorigodukaba i. Arokaba ia arore jiboeji i kuri je imode ikare maku akaiboe rugadu maku akai rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","– Ča nou ukimijera okudure apo rugadu. Makore nou tudugareji ukaiago ture tugeragu jiboe morido pudai. Nou rore jiboe akeduie rugadu. Tuwiagodumoduie nou rore jiboe piji rugadu. Nono makore nouia tudugaregei ekawo nou tudugare barigu baičoreuto pugeje. ");
INSERT INTO bor_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","– Nono nou utugare imedu uture pugeje nou tugimijera piji. Toro jordure ia timediaji emaragodure puapo tugimijera ai. Mare nou metia ukare ia boe mori maku ai dukodire aidure nou toe mori bagai. Mare nou boe mori rogu kurikare. Mare nou imedu okudugodukare timedia apo rugadu. Ure tugera kogudo nou timedia itoru kajeje. Mako rakare ji. Akore: “Nou akare boe mori maku inaiwu mori maku inai rugadu kuri aino rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","– Nou metia ure tubu jodo moto keje. Okwamagudure nou imeduji tragudu tabo. Akore: “Akorigodukaba i. Arokaba ia arore jiboeji i kuri je. Imode ikare maku akaiboe rugadu maku akai rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","– Mare nou imedu ukare tumeardae mekido nou tumeardae pegareu piji rugadu. Uture tugobaigarege ewagai. Makore ei ewo nou timedia barigu baičoreuto. Rakojemoduie baičoreu tada jii tugare morido inaiboe oto pa ka. ");
INSERT INTO bor_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nou boe eimijera ia utugarege erduware nou timedia rore jiboeji dukeje emororamagadugodure rugadu. Eture tugimijera bagai. Ereadodure nou timedia rore jiboe jamedu boeji tugimijera biagai. ");
INSERT INTO bor_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nono nou ekimijera makore nou tudugare bagai pugeje. Nou roiwakare tuwo toe morido pudaiboe tudugare bagaire makore. Nou utugare aregodure pugeje dukeje nou boe eimijera mako rakare ji rugadu. Akore: “Itugare pegareu nure aki. Ro pegareu nure aki rugadu. Akogwamagudure i akragudu tabo. Dukodire inogudugodure akabo rugadu. Imagore ai akaiago nou are akeragu jiboe morido inai pugeje. Amodukaie maku inai jii toro rugadu. Iwiagodumoduie nou diero piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kočare akogudugoduwo amedia apo jamedu nono iro mogadure. Mare ameardae pegare rugadu. Akogudukare amedia apo rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","– Nono nou boe eimijera korigodure nou tudugareji rugadu. Ure nou tudugare maku tugobaigarege etai rugadu ewo boeto ji rugadu, ewo tugu baičoreuto rugadu jii umode ture tugeragu jiboe moridodu ka. ");
INSERT INTO bor_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesus mako kimore: – Ainore baru tadawu Iogwa Kurireu romode taiamedu boei. Tagogudugodumodukare tamedagebo dukeje Iogwa Kurireu ro pegamode tai jamedu. Tawiagodumode tamedage ero pegare tai dupiji tagaidu tabo dukeje Iogwa Kurireu okudugodumode tagabo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus ure nou tumago akedudo dukeje uture Galiléia moto piji. Uture Judéia moto ka. Kurugodure Jordão po kajeje toro bakowu ka. ");
INSERT INTO bor_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Boe emagare tudu tabo Jesus rekodaji toro nou moto ka. Jesus ure kogodureuge epemegago. ");
INSERT INTO bor_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ia fariseu doge etaregodure nono Jesus rakojereu ka jamedu. Etaidure tuwo turokogado Jesusji tuiorduwo ia Jesus ro pegareuji ia Jesus mako pegareuji. Erdumode dukeje emago pegamode ji rugadu. Dukodire enarare Jesusji. Egore: – Nuba Pao Kurireu ure maku Moisés aiwu pago bakaru akore? Ukana turugadu imedu uwo toreduje utudo tubiji tumugukawo apo pugeje? Romode aino pagatu je mare pegakare kana? Nou pago bakaru ukana turugadu imedu rore aino duji? ");
INSERT INTO bor_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus makore ewadaru jipagi. Akore: – Tagaiwore Pao Kurireu bataru remawu boetojiwuji rugadu. Kočare tarduwakare ji. Nou bataru akoino Pao Kurireu uie boe jamedu boe towuje dukeje ure imedu boetojiwu towuje. Ure aredu boetojiwudo towuje jamedu. ");
INSERT INTO bor_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pao Kurireu makoie ei imedu utumoduie tuo piji tuje piji tumuguwo toreduje apo dukeje emodukaie pobe pugeje, emoduie mitotu je rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dukodire imedu mugumode aredu apo dukeje ere nono mitotu puapo turoi pui dutabo Pao Kurireu jakai. Ča Pao Kurireu aidure emugure puapo duji. Dukodire emuguwo puapo jii toro rugadu. Ekawo tugera ra pubiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nono nou fariseu doge enarare Jesusji pugeje. Egore: – Mare nou ure pago bakaru maku pagaiwu Moisés makore nou mariguduwuge pawobei. Nou bakaru akore imedu aiduie tuwo toreduje utudo tubiji dukeje uwo ia bapera atugodo tuwo toreduje bie kaba kodiba tuie utudo tubiji rugadu. Imedu romoduie aino du pegakaie. Uwo toreduje utudo tubiji rugadu. Ainore nou mariguduwu jorduware Pao Kurireu bataru jiwu makore pawobei marigudu. Nou bataru ure turugadu kana? ");
INSERT INTO bor_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus akore: – Uu. Mariguduwuge pawobe etaora rakare dukodire etaidukare tuiorduwawo, etaidukare turo pemegawo. Dukodire Moisés ure nou paro maku mariguduwuge pawobe etai ewo tugera ra toreduje piji. Mare Pao Kurireu meardae remawu ukare aino boetoji. Aidukare imedu uwo tugera ra toreduje piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dukodire iwo tawie Pao Kurireu meardae remawuji pugeje. Imedu umode tugera ra toreduje piji mare mugumode ia aredu apo pugeje. Du pegare Pao Kurireu jakai. Nou imedu ro peganure nou toreduje boetojiwudoji rugadu. Ure tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai. Mare imedu oreduje jeribarimode nou toredu piji dukeje nou imedu aidumode tuwo tugera ra toreduje piji du pegakare. ");
INSERT INTO bor_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nono nou Jesus ure jorduwadowuge emeardure Jesus akoino duji dukeje emagore Jesusji. Egore: – Ča nou akagoino jiwu Pao Kurireu meardae remawu rakare boei rugadu. Ime eragamodukare tumuguwo tu toreduje apo rugadu. Dukodire ukare turugadu imedu uwirewo. ");
INSERT INTO bor_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus makore ewadaru jipagi. Akore: – Awu iwadaru rakare dukodire ia boe etaidumodukare ji. Mare Pao Kurireu ure tumeardae maku etaiwuge etaidumode nou iwadaruji rugadu emeartorure Pao Kurireuji kodi. ");
INSERT INTO bor_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ia ime ewodure dukeje ewa pegare dukodire ime mode emage mare eroiwakare tieribariwo areduji dukodire etuwiremodukare. Ia ime ewa bokware mare ime ro pegareuge ero koiare ere nou ime ewa tawuje. Dukodire etuwiremodukare. Mare ia ime emode tumeardae tawuje tuwirekawo. Mare paga karega. Etuwiremodukare tuwo tumagu Pao Kurireu ai tuwo Pao Kurireu utugaregedo pudumi. Ia boe eragare taiduwo awu iwadaruji du etaiduwo ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nono ia boe etaregodure Jesus ae ia boe torebo. Emagore Jesusji uwo tugera bu nou boe etore ewugeje makowo eparu tabo Pao Kurireu bagai baruto. Mare Jesus ure jorduwadowuge etaidukare eroino duji. Emagore ei etuwo torebo Jesus piji. ");
INSERT INTO bor_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mare Jesus makore ture jorduwadowugei rugadu. Akore: – Tagaba tawu boe etore emeardae ekajeje etaregoduwo itae rugadu. Etarego itae rugadu. Boe ewo tumeardae udo nono boe etore emeardae mogadure tuwo tugimijerado Pao Kurireuče rugadu turuduwo baruto. ");
INSERT INTO bor_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nono ča Jesus ure tugera bu nou boe etore ewugeje. Nono uture nou boe epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ia imedu aregodure Jesus ae. Unarare Jesusji. Akore: – Jorduwareu nure aki. Nuba iromode iwo iro pemegado iewoduwo pugeje imuguwo baru tada Pao Kurireu apo du akedukawo rugadu? ");
INSERT INTO bor_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus akore: – Ča anarare i boe ero pemegareu bagai. Arduwa kana kaba jiba akagoino? Pemegareu ure mitotu je. Marigudu arduware nou Pao Kurireu ure maku Judeu doge etaiwu bakaruji. Ure maku etai marigudu. Akaidure aewoduwo pugeje amuguwo Pao Kurireu apo du akedukawo dukodi ameartorudo nou Pao Kurireu ure maku Judeu doge etaiwu bakaruji. ");
INSERT INTO bor_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nou imedu unarare pugeje. Akore: – Nou bakaru kurire rugadu. Imeartorumodu kana nou bakaru jamedu boeji? Kaba bataru ji ba imeartorumode? Jesus makore nou imedu bataru jipagi. Akore: – Akaba boe ewido. Aeribarikaba akoreduje piji. Akiwogukaba. Awadrarodukaba boe erore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ameartorudo ačeji, aoji. Ameardu kurido amedagei nono ameardu kuri moga ai dumogadure. Ameartorudo awu bataru boeji. ");
INSERT INTO bor_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nou imedu akore: – Marigudu imeartorure awu bataru jamedu boeji ji aino. Kaba jiba iromode pugeje? ");
INSERT INTO bor_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nono Jesus makore imeduji pugeje. Akore: – Akaidure awo ro pemegareu remawudo aki dukeje akoe jamedu boe maku diero bagai. Nou ako diero rugadu maku marenarue doge etai. Dukeje Pao Kurireu umode akoe kurido baru tada. Aromode aino dukeje akaregodumode itae pugeje akoduwo itabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nou imedu meardure Jesus bataruji dukeje kiarigodure. Oe kurire dukodire aidukare tuwo toe maku. Kiarigodure rugadu. Kodire uture Jesus piji. Meartorukare Jesus bataruji. ");
INSERT INTO bor_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nono Jesus makore ture jorduwadowugei. Akore: – Iwo tawie boe remawuji. Kočare. Boe rakare oe kurireugei etaiduwo tuwo tugimijerado Pao Kurireuče tumuguwo Pao Kurireu apo baru tada. ");
INSERT INTO bor_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Boe rakare oe kurireu imeduji rugadu uwo tugimijerado Pao Kurireuče tumuguwo apo nono boe rakare cameloji uwo turemo agulha poroto dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nou Jesus ure jorduwadowuge emeardure nou Jesus bataruji dukeje eku kidure ji. Dukodire enarare ji. Egore: – Kočare. Ioguduba umode tuginorudo tuiewoduwo pugeje tumuguwo Pao Kurireu apo? ");
INSERT INTO bor_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus aiwore nou ture jorduwadowugei. Akore: – Boe eroiwakare tuwo činorudo rugadu. Mare Pao Kurireu roiware tuwo boe ekinorudo rugadu. Pao Kurireu rakare tuwo boe jamedu boe pemegado boei. ");
INSERT INTO bor_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nono Pedro akore: – Čegi čere čegera ra čenoe jamedu boe piji čegoduwo akabo. Nuba boemode čei? ");
INSERT INTO bor_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus akore: – Imode tawie boe remawuji rugadu. Toro ia meri keje Pao Kurireu umode boe jamedu boe maiwudo pugeje. Nono Imedu Onaregedu mugumode boe eimijera kurireu mugure kejewu to ira motureu keje, dukeje nou kodure itabowuge tagi tamugumode boe eimijera mugure kejewu ira keje jamedu. Nono tagaiwomode Israel doge erore jiboeji ero pegareu bagai ero pemegareu bagai jamedu. Nou ira doge enodo padumode doze nono nou Israel doge eno clã dogere doze dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Boe emode tugera ra tuwai piji, tuo piji, tuje piji, tumanamage epiji, tuwiemage epiji, to boepa piji tugoduwo itabo tuwo boe ewie iwadaru pemegareuji dukeje boe rugadu boe makudumode etai eroino du moriče. Nou mori kurimode eture pijiboe kori rugadu. Nono ia meri keje eewodumode pugeje emuguwo toro baru tada. Ewimodukare pugeje jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Boe emeardae pemegare oe kurireugei dukeje egore boe eimijerage nuie emage mare emeartorumodukare Pao Kurireuji dukeje marenarue doge mode emage. Iage enoe bokware dukodire boe emeardae pegare ei mare emeartorumode Pao Kurireuji dukeje oe kurireuge mode emage toro ia meri keje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus makore boei pugeje. Akore: – Ireadodumode ia maragodure boepa jiwuge erore jiboeji tawiagai iwo tawie ia Pao Kurireu meardaeji. Boe eimijera kurireu nure ema. Boe emode tugimijerado ema tumuguwo apo baru tada dukeje Pao Kurireu romode ei nono ia ore moto čewu ro mogadure. Nou ore moto čewu o boepare. Uva iku makare nou o boepa tada. Nou boepa kurire. Ia meri keje meri rutukare raga dukeje nou ore moto čewu ure tudawuje tuwai piji taiwowo ia ime ewagai tumagowo ei emaragoduwo to boepa tada pudai. ");
INSERT INTO bor_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jordure ia imei dukeje makore ei tumoduie emaragodae morido rugadu. Tumoduie nou moto kejewu diero udo mitotu je etai emaragodae moriče. Nou moto keje emaragodae ainore morire rugadu. Dukodire nou ime etaidure nou ore moto čewu meardaeji. Nono ere tuwadaru maku ai tumaragodumoduie ai nou meriji jii merirekodu ka nou akoino jiwu mori bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nono emaragodure rugadu. Mare meri aregodure gu je pugeje nou ore moto čewu ure tumeardae tawuje tuwo tugeragu ia maragodureugei pugeje. Nono uture nou boe eda ka pugeje nou ime ewagai. Jordure ia imei toro. Emugu pagare nono. ");
INSERT INTO bor_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nono makore ei. Akore: “Tadumode ino boepa ka. Tamaragodumode tada jii merirekodu ka dukeje imode diero maku tagai tamaragodae moriče rugadu. Iro pegamodukare tai.” ");
INSERT INTO bor_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","– Nou ime etaidure nou ore moto čewu bataruji dukodire eture o boepa ka rugadu. – Nono meri aregodure pagaia ka dukeje nou ore moto čewu uture boe eda ka pugeje. Ure tugeragu ia imei pugeje emaragoduwo to boepa tada. Makore ei nono tumagore boetojiwugei dumogadure. Merirekodutabo nou ore moto čewu rore aino pugeje ia maragodure to boepa jiwuge ewagai pugeje. ");
INSERT INTO bor_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nono merirekodugodutabo rugadu dukeje nou ore moto čewu uture boe eda ka pugeje. Jordure ia imei nono pugeje. Edu pagare tu nono. Nono nou ore moto čewu unarare ei. Akore: “Kaba kodiba tadu pagare woe awu meriji jii merirekodu ka?” ");
INSERT INTO bor_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","– Egore: “Iaboe emagokare čei čemaragoduwo pudai. Čemaragodae bokware.” – Nono nou ore moto čewu makore ei. Akore: “Ča tadudo toro ino boepa ka tamaragoduwo tada. Nono imode diero maku tagai tamaragodae moriče.” – Dukodire eture toro rugadu tumaragoduwo nou ore moto čewu o boepa tada. ");
INSERT INTO bor_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","– Nono ča merirekodure rugadu dukodire boečodure ei rugadu dukeje nou ore moto čewu makore nou to boepa kejewu boe eimijeraji makowo nou maragodureuge eiamedu boe ewagai. Tumoduie diero maku etai emaragodae moriče. Makoiago nou aregodure boeiwuge ewagai boetoji. ");
INSERT INTO bor_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","– Dukodire nou boepa kejewu boe eimijera makore nou aregodure boeiwuge ewagai etaregoduwo mato nou ore moto čewu imedu ae. Emage etaregodure tumaragoduwo boigodu, merirekodutabo rugadu. Nono nou ore moto čewu ure ia nou moto kejewu eno diero udo mitotu je etai emaragodae moriče. ");
INSERT INTO bor_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nou aregodure boetojiwuge erduware nou inoduji dukeje emeardaere to diero kurimode nou aregodure boeiwuge eno diero kori rugadu. Nou aregodure boetojiwuge emaragodure aino ča je jii merirekodu ka rugadu. Emaragodu rakare rugadu. Dukodire emeardaere nou ore moto čewu umoduie to diero kurido tumagore jiboe kori. Mare nou ore moto čewu ure eno diero udo mitotu je etai jamedu nono turore nou aregodu boeiwugei dumogadure. ");
INSERT INTO bor_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ure nou diero maku etai dukeje erduware to diero ure mitotu je rugadu. Emago pegare nou ore moto čewu rore pudui duji. Egore ukaie turugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Egore: “Čegi čemaragodu rakare aino ča je jii merirekodu ka rugadu boeru kuda rugadu. Nou aregodure boeiwuge etaregodure merirekodutabo rugadu. Emaragodure kuri uma hora ka. Mare are emaragodae mori udo nono čemaragodae mori mogadure. Ukare turugadu čegai.” ");
INSERT INTO bor_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","– Mare nou ore moto čewu makore ei. Akore: “Imedage nure tagi. Iro pega karegure tai. Imagore tawagai tamaragoduwo inai dukeje ire tawie nuba imode diero udo tamaragodae moriče. Tagi tagagore uie turugadu tai. ");
INSERT INTO bor_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ča ire nou imagore jiboe maku tagai rugadu. Tageragu ji. Taegaredo tai nou tamaragodae moriji. Nou aregodure boeiwuge etaire itaidure iwo emaragodae mori udo nono tamaragodae mori mogadure du pegakare. ");
INSERT INTO bor_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Iromode ino dieroji nono imeardae mogadure rugadu du pegakare. Itaidure iro pemegawo ei du pegakare. Mare kočare iro pemegare ei mare tardu pegare iro pemegare ei duji. Du ukare turugadu.” ");
INSERT INTO bor_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus mako kimore: – Nou ore moto čewu rore jiboe ure nono Pao Kurireu ro mogadure meartorure puduiwugei. Mare maragodure boepa jiwugei karega inagoino. Ure tugimijerado Pao Kurireu čewugeire inagoino. Iage ere tugimijerado Pao Kurireuče marigudu. Iage ere tugimijerado ema aino maibari. Mare Pao Kurireu ro pemegamode eiamedu boei. Ro pemegamode nou meartorure puduiwuge boeiwugei. Ro pemegamode nou meartorure puduiwuge boetojiwugei jamedu. Umode eiamedu boe emugudo pudabo baru tada rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nono Jesus uture pugeje. Kodure Jerusalém ba kurireu kawu awaraji. Nono ure tuwuredo nou ture jorduwadowugebo tumagowo ei. Enodo padure doze. ");
INSERT INTO bor_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Akore: – Padumode Jerusalém ba kurireu ka. Imedu Onaregedu nure imi. Imagudumode nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etai. Imagudumode nou jorduware Judeu doge eno bakaru jiwuge etai. Nou boe eimijerage egomode ipegaie. Etaidumode tuwo iwido rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dukodire emode imagu boe tuginaiwuge eimijera ai nou boe tuginaiwuge eimijera uwo to tugobaigarege edo boeto i. Emode iwido ipadumode ipo padure pugajejewu keje. Mare merimode pobe metia bokware dukeje iewodumode pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ia aredu aregodure Jesus ae tore ime pobedu dogebo. Etuo iere Zebedeu. Nou aredu ore ime ekodure Jesus apo marigudu. Jesus ure jorduwadowuge nure emage. Etuje ure tubu jodo moto keje togwamaguduwo Jesusji iaboe bagai. ");
INSERT INTO bor_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus makore nou areduji. Akore: – Kaba jiba akaidure? Nou aredu akore: – Amode boe eimijerado aki woe dukeje amugumode ira kurireu keje nono boe ekimijerage ero mogadure. Itaidure awo itore ime emugudo amegi boe eimijera mugure kejewu ira keje jamedu. Ia mugudo nono akana pemegareu jagwai. Metia mugudo akana pegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus meardure nou aredu bataruji dukeje makore nou aredu ore ime pobedu dogei. Akore: – Tarduwakare kaboba bagaiba taje akoino. Boe pegamode tai nono boe pegamode i dumogadure dukeje taroiwakana tawo taragado tai tagawo tagera ra tameartorure idu piji? Egore: – Uu. Čemode čeragado čei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus makore ei pugeje. Akore: – Inure tawie. Boe pegamode tai rugadu nono boe pegamode i dumogadure. Mare iroiwakare iwo tamugudo itabo ikana pemegareu jagwai, ikana pegareu jagwai. Iogwa Kurireu emare ure nou imegiwu udo turugadu. Tu ema jorduware turomode jiboeji. Emare umode taidure jiwuge emugudo ikana pemegareu jagwai, ikana pegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nou pobedu doge emedage enodo padure dez. Jesus ure erduwado jamedu. Emeardure nou tumedage etuje okwamagudure jiboeji dukeje ekorigodure nou tumedage pobedu dogei. ");
INSERT INTO bor_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nono Jesus makore eiamedu boe etae ewiapagawo tuwadaruji. Akore: – Tarduware boe tuginaiwuge ekimijerage erore jiboeji. Ero rakare boei. Boe emeartorumode tugimijeragei rugadu. Emeartorumodukare ei dukeje nou boe ekimijerage emode boe pegado nou meartorukare puduiwugei rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Mare tarokaba nono nou boe tuginaiwuge ekimijerage ero mogadure. Ia tagi tagaidumode tawo boe ekimijerado tagi dukeje tameardae udo nono boe utugare meardae mogadure tawo boe eimijera pemegareugedo tagi. Boe eimijera romode nono boe utugare ro mogadure tuwo boe eimijera pemegareudo pudumi. ");
INSERT INTO bor_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tarodo nono iro mogadure. Imedu Onaregedu nure imi. Itaregodukare iwo boe ekimijerado imi. Itaregodure iwo boe etugaredo imi. Itaregodure iwo imagu boe etai. Itaregodure iwiwo boe ero pegareu moriče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Toro ia meri keje, Jesus uture Jericó ba kurireu piji ture jorduwadowugebo. Ia boe ekodure awaraji Jesus apo jamedu. Emagare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Joku bokwareuge ime pobedu doge emugure nono nou awara okwai. Emeardure Jesus kodure tugori duji. Kodire ekudure Jesus rekodaji. Egore: – Čegimijera! Davi Onaregedu nure aki! Akogududo čedabo! Nou joku bokwareu ime erduware Davi uwobe nure Jesusče duji dukodire egoino Davi Onaregedu nuie ema. ");
INSERT INTO bor_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nou kodure nonowu boe emago rakare ei emugu kiorowo. Mare ekudu rakare pugeje. Egore: – Čegimijera! Davi Onaregedu nure aki! Akogududo čedabo! ");
INSERT INTO bor_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nono ča Jesus ure tuwuredo nono. Makore toro etae. Akore: – Kaba jiba tagaidure irowo tai? ");
INSERT INTO bor_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Egore: – Čegimijera nure aki. Čedaidure čedaiwowo pugeje. ");
INSERT INTO bor_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus okudugodure ebo rugadu. Ure tugera bu eku keje. Aino ča etaiwore pugeje tači je. Etaiwo pemegare rugadu. Dukodire ekodure Jesus rekodaji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nou inodu otobiji Jesus uture Jerusalém ba kurireu ka ture jorduwadowugebo. Epuredugodure boe eda Betfagé ka. Nou boe eda mugu puredure Oliveira Riji. Aregodure toro dukeje makore nou ture jorduwadowuge ime pobedu dogei tuwo etudo tododai. ");
INSERT INTO bor_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Akore ei: – Tadudo toro nou boe eda ka. Tagaregodumode dukeje tardumode ia jumenta areduji onaregedu apo duji. Boe ere ekogudo nono duji. Tamode bukigu kiwuje dukeje tadumode mato ebo itae. ");
INSERT INTO bor_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ia boe enaramode kaba kodiba tarore aino dukeje tamagodo aino ji: “Pagimijera aidure ei”, aino. Nono nou boe emode tadudo ebo itae rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dukodire ia Pao Kurireu bataru jeture pudui. Marigudu ia makore Pao Kurireu bataru jiwu ure nou bataru bu bapera keje. Akore: ");
INSERT INTO bor_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","– Awu mugure Jerusalém kejewuge tagi. Tabagudukaba. Tagimijera kurireu ro butugumode boei rugadu. Mugumode jumenta keje taregoduwo tagae. Jumenta onaregedu kejere mugumode rugadu taregoduwo tagae. ");
INSERT INTO bor_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nono ča nou Jesus ure jorduwadowuge pobedu doge erore nono Jesus makore pudui dumogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Etaregodure tuibagi nou jumenta apo, nou jumenta onaregedu apo rugadu Jesus ae rugadu. Nono nou boe ere tugudau areia cobertor boe bu nou jumenta poru keje, nou jumenta onaregedu poru keje Jesus muguwo keje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Boe emagare nono nou Jerusalém kawu awara keje. Iage ere tugudau areia cobertor bu awara keje rugadu. Iage ere bai kado. Ere nou bai bu awara keje jamedu Jesus koduwo nou jumenta apo nou awaraji Jerusalém ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Boe emagare rugadu tugodu tabo Jesus apo. Eture tiegarere pudui dutabo rugadu. Dukodire ewadodu rakare Pao Kurireu ie tabo tumago pemegare ji dutabo. Egore: – Davi onaregedu nure ema dukodire pagimijera kurireu nure ema rugadu. Pao Kurireu uwo boe pemegado ji rugadu! Pao Kurireu ure arego mato pagae. Ure turaga maku ai rugadu. Boe eiamedu boe emago pemegawo ji rugadu woe moto keje, baru tada jamedu. ");
INSERT INTO bor_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nono ča Jesus aregodure Jerusalém ba kurireu ka rugadu. Nou ba kurireu tadawuge eiamedu boe erore ta je. Erduwakare kodiba nou boe eroino. Dukodire enarare boei. Egore: – Ioguduba ure ema? ");
INSERT INTO bor_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nou kodure Jesus apowuge boe emagareuge egore: – Jesus reo. Emare makore Pao Kurireu bataruji. Aregodure Galiléia moto piji, Nazaré ba kurireu piji. ");
INSERT INTO bor_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus ure turemo Pao Kurireu uwaito. Nono jordure nou boei ere tagu metugoe emagu diero bagai duji ere diero maku puai duji. Dukodire korigodure rugadu. Ure nou boe enoe rugadu barigu. Ure emugure kejewu ira rugadu boe barigu. Ure nou metugoe emedure tadaboe rugadu barigu. Ure nou boe etudo Pao Kurireu uwai piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesus akore: – Pao Kurireu uwai tadare boe emagomode bagai baruto. Ainore Pao Kurireu akore. Ainore bapera atugo ure. Mare tare awu Pao Kurireu uwai udo nono iwogureuge ewai mogadure. ");
INSERT INTO bor_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Joku bokwareuge, pogora pegareuge, etaregodure Jesus ae nou Pao Kurireu uwaito. Nono Jesus ure epemegago. ");
INSERT INTO bor_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge erdure Jesus ure boe epemegago duji. Emeardure nou boe etore ekudure Jesus ro pemegareu tabo boe egai duji. Dukodire ekorigodure. Nou boe etore egore Davi onaregedu nuie ema duji. Pagimijera kurireu nuie ema rugadu. Pawo boe pemegado ji rugadu! Dukodire nou boe eimijerage erdu pegare Jesusji. Ekorigodure. ");
INSERT INTO bor_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dukodire emagore Jesusji. Egore: – Ameardu kana nou boe etore emagoji? Emagore jiboe ukare turugadu. Pagare egoino. Atudo toro etae awo edukiorodo. Mare Jesus akore: – Boro. Tarduwakare Pao Kurireu bataru remawuji. Marigudu Pao Kurireu ure boe ewie nou emagomoduie aino duji rugadu. Padure bapera keje. Akore Pao Kurireu uie boe etore kugure emago pemegado rugadu. Emago pemegaie Pao Kurireuji rugadu. Dujire Pao Kurireu aidure. Dujire Pao Kurireu meardae remawure. ");
INSERT INTO bor_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nono ča Jesus uture nou boe epiji. Uture Jerusalém ba kurireu piji toro Betânia boe eda ka. Nonore unudure nou boečoji. ");
INSERT INTO bor_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nou barogwato ča boečoto Jesus kodure awaraji pugeje tuwo tugirimi Jerusalém ba kurireu ka pugeje. Mare uke boeire ji. ");
INSERT INTO bor_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nono jordure ia figo iji nou awara okwai. Uture nou i ka. Aiwore ia tudu kurodureu bagai mare jordukare boeji. Jordure tu aruji rugadu. Nono Jesus mako pegare nou iji. Akore: – Boe emodukare akurodu kowuje pugeje awimode kodi. Ča nono nou figo i bire aino tači je! ");
INSERT INTO bor_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nou Jesus ure jorduwadowuge erdure nou inoduji dukeje eku kidure rugadu. Egore: – Kočare awu figo i bire aino tači je rugadu? ");
INSERT INTO bor_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus makore ei. Akore: – Inure tawie boe remawuji. Tameartorudo Pao Kurireuji rugadu. Tameartugukaba ji. Tameartorumode dukeje taromode figo iji nono iro mogadure. Nono tamagomode tori riji uwo tuwarigu pobo maereuto. Tamagomode ji dukeje barigudumode pobo maereuto rugadu. Mare tameartorumodukare dukeje umodukare tuwarigu. ");
INSERT INTO bor_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tameartorumode dukeje tamagomode Pao Kurireu bagai baruto iaboe bagai dukeje umode tamagore bagaiboe maku tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus aregodure Pao Kurireu uwai ka pugeje. Ure turemo dukeje ure boe erduwado nono. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nouia boe eimijerage etaregodure Jesus ae jamedu. Emagore Jesusji: – Ioguduba ure akarego mato? Ioguduba ure turaga maku akai aro rakawo aino? ");
INSERT INTO bor_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesus akore: – Imi jamedu inaramode tai. Ioguduba ure João Batista udo boe etao pegodo? Pao Kurireu koia kana? Ia boe eigoia kana? Tamagomode iwadaru jipagi dukeje imagomode tawadaru jipagi jamedu. Mare nou boe eimijerage erduwakare tumagowo Jesus bataru jipagi. Dukodire emagore pui nuba tagomode Jesus bataru jipagi. Egore: – Pamagomode Pao Kurireu koiare ure João Batista udo boe etao pegodo mare pameartorukare nou inoduji. Awu Jesus jorduware pameartorukare nou inodu jituji. Dukodire pagagomode aino dukeje Jesus umode pawadaru pogurudo. Akomode: “Kodiba tameartorukare ji?” Ainore akomode pai. ");
INSERT INTO bor_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mare pagagomode boe eigoiaie dukeje awu woewu boe ekorigodumode pai rugadu. Boe eiamedu boe emeartorure João Batista makore Pao Kurireu bataru jituji. Egore Pao Kurireu koiare ure João Batista udo boe etao pegodo rugadu. Pagagomode boe eigoiaie mare pabagudure boeče dukodire pamagomodukare aino. ");
INSERT INTO bor_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nono nou boe eimijerage emagore Jesusji. Egore: – Čerduwakare ioguduba koiare ure João Batista udo boe etao pegodo. Nono Jesus makore ei. Akore: – Tamagokare iwadaru jipagi dukodire imagomodukare ioguduba ure itarego mato jamedu duji. ");
INSERT INTO bor_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus mako kimore nou boe eimijeragei. Akore: – Ireadodumode ia bakaruji iwo tawie ia Pao Kurireu meardaeji. Ia imedu ore ime ere pobe. Nou imedu makore nou tonaregedu imedu boetojiwuji. Makore ji. Akore: “Atudo toro pago boepato amaragoduwo nou boepa tadawu uva ikuji.” ");
INSERT INTO bor_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","– Mare nou imedu onaregedu boetojiwu akore tudumodukaie, tumaragodumodukaie boepaji nou meriji. Mare nou imedu onaregedu boetojiwu ure tumeardae mekido dukodire uture rugadu boepato rugadu. Maragodure ji rugadu nou meriji. ");
INSERT INTO bor_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mare nou uo jorduwakare nou inoduji dukodire uture nou tonaregedu boigoduwu bagai. Makore ji utuiago to boepato nou meriji, maragoduiago boepaji nou meriji. Nou imedu onaregedu boigoduwu akore tudumoduie tumaragoduwo rugadu. Mare ča utukare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Ainore Jesus readodure. Nono Jesus unarare nou boe eimijeragei. Akore: – Kakojiwu imedu onaregedu ba meartorure nou tuo makore pudui duji? Nou boe eimijerage egore: – Nou imedu onaregedu boetojiwu emare meartorure tuo bataruji. Jesus akore: – Boe jokodu jire tagagoino. Boe egore nou umoduie tugeragu boe enoe morijiwu emugumodukaie Pao Kurireu apo baru tada. Boe egore nou areme ure tugeragu dieroji tieribari tabowuge emugumodukaie Pao Kurireu apo baru tada erore aino dukodi. Mare iwo tawie boe remawuji. João Batista makore nou boei dukodire ekiarigodure nou turo pegareuji. Ere nou tumeardae pegareu barigu tubiji tumeartoruwo Pao Kurireuji rugadu. Ainore boe erore tuwo tudo turugadu tumuguwo Pao Kurireu apo baru tada rugadu. João Batista ure tarduwado jamedu. Ure tarduwado Pao Kurireu meardaeji. Ure tarduwado nuba taromode tawo tado nono ro pemegareugere Pao Kurireu jakai. Tardure nouia boei ere tumeardae pegareu barigu tubiji duji. Tardure nouia boei emeartorure João Batista makore pudui duji. Mare tagire tameartorukare. Tagare tameardae pegareu barigu tabiji. Dukodire tagare tarugadu raga tamuguwo Pao Kurireu apo baru tada rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus mako kimore nou boe eimijerage pegareugei. Akore: – Imagowo ia bakaruji tawiagai iwo tawie Pao Kurireu meardae remawuji pugeje. Ainore nou bakaru ure. Ia imedu ure uva tugu to boepa tada. Ure ramiku aiado to boepa tabo. Ure ia moto porodo tuwo tuwuredo nou uva kurodu keje tuwo kuru tawuje. Ure ia tugamo pemegado boe ewo tumugudo toro aogeje taiwo pemegawo boepaji. Nono ure tugeragu ia boei tuwo etudo nou to boepaji. Nono nou ore boepa čewu uture epiji tugiriadu tabo toro ia boe eda jaereu ka. ");
INSERT INTO bor_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nou boepa tadawu uva kurodumode kejewu ari puredugodure dukeje nou ore boepa čewu imedu ure tudugarege etudo toro nou jeture to boepa jiwuge etae nou tugiriadure kawu moto piji. Ure nou tudugarege etudo ewo tugeragu nou makudumode pudaiwu boeji. Nou jeture nou boepa jiwuge emode uva rugadu kado dukeje emode ia kado puiato nou ore boepa čewu imedu ai. ");
INSERT INTO bor_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nou imedu utugarege etaregodure nou boepa ka. Mare nou jeture nou boepa jiwuge etaidukare tuwo uva kado puiato pugeje nou ore boepa čewu ai. Dukodire ere tugeragu nou imedu utugaregei turaga tabo. Ere boeto iaji. Ere ia bito. Eidore tori tabo iaji. ");
INSERT INTO bor_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jesus mako kimore: – Nou utugarege etaregodukare iaboe tabo dukeje nou ore boepa čewu imedu ure ia tudugarege etudo pugeje toro nou jeture to boepa jiwuge ewagai pugeje. Ure tudugarege emagado toro rugadu. Mare nou jeture boepa jiwuge ero pegare nou imedu utugaregei nono turo mogadure pugeje. ");
INSERT INTO bor_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nono ča nou ore boepa čewu ure tonaregedu imedu utudo nou jeture boepa jiwuge ewagai boigodu. Imedu makore tudada tonaregedu jie emeartorumoduie. ");
INSERT INTO bor_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mare nou jeture boepa jiwuge erdure nou ore boepa čewu onaregedu kodure aino pudae duji dukeje emagore pui. Egore: “Awu ore boepa čewu onaregedu reo. Emare omode tuo oe jamedu boeče. Pawo bito pagowo oe jamedu boeče.” ");
INSERT INTO bor_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ainore emagore pui. Nono ere tugeragu nou ore boepa čewu onaregeduji. Ere barigu nou boepa piji. Nono ere bito toro. ");
INSERT INTO bor_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesus mako kimore nou boe eimijeragei. Akore: – Ainore erore rugadu. Ča. Nuba tameardaere nou ore boepa čewu romode nou jeture boepa jiwugei? ");
INSERT INTO bor_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nou boe eimijerage emagore Jesus bataru jipagi. Egore: – Umode nou jeture to boepa jiwuge ro pegareuge ewido. Nono umode to boepa maku ia ime etai etuwo ji. Nouge ča emode ia kurodureboe maku nou ore boepa čewu ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus akore: – Boe rugadu jire tagagoino. Mare tagaiwokare rugadu kana ia padure bapera kejewu Pao Kurireu bataruji? Ainore awu Pao Kurireu bataru akore: – Boe emeardae pegare toriji. Egore pegaie tuwo tuwaido ema. Mare nou tori pemegareu nure ema rugadu boe ewo tuwaido ema rugadu. Pao Kurireu koiare ure nou tori pemegado aino. Ure pemegado nouia tori jamedu boe ekori. Boe eiamedu boe ebogodure nou Pao Kurireu roino duji. – Ainore nou batarure. ");
INSERT INTO bor_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Jesus mako kimore: – Iwo tawie awu Pao Kurireu bataru boeji. Tori ji karega akoino. Umode boe ekinorudowu imedu jire Pao Kurireu akoino. Nou umode boe ekinorudowu romode boei nono ia boe ewudure kejewu tori ro mogadure. Buture tori aogejewuge eiamedu boe emode togorido. Mare tori ji karega inagoino. Nou umode boe ekinorudowu umode meartorukare puduiwuge erugadu boe epegado. Dujire inagoino. Nou umode boe ekinorudowu romode boei nono ia buture boe ewugejewu tori ro mogadure jamedu. Tori butumode boe ewugeje dukeje umode nou boe egugudo. Mare tori ji karega inagoino. Nou umode boe ekinorudowu umode boe pegado nou meartorukare puduiwuge eiamedu boei. Dujire Pao Kurireu akoino. Čare imode tawie boe remawuji. Tameardaere tamugumoduie Pao Kurireu apo baru tada. Tameardaere tagimijera nuie Pao Kurireuče. Mare pagare tagagoino. Pao Kurireu makomodukare tawagai pugeje. Makomode ia boe ewagai. Nono emeartorumode Pao Kurireuji rugadu dukodire emagere emugumode Pao Kurireu apo baru tada rugadu. Emode tugimijerado Pao Kurireuče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emeardure nou Jesus bataruji. Nou boe eimijerage fariseu doge emeardure jamedu. Emeardure Jesus readodure jiwu bakaruji dukeje erduware puduire Jesus akoino duji. ");
INSERT INTO bor_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dukodire nou boe eimijerage pegareuge eiamedu boe etaidure tuwo tugeragu Jesusji tuwo tugu baičoreuto kuri je rugadu. Mare boe etaidukare ero pegawo Jesusji. Egore makore Pao Kurireu bataru jiwu nuie ema rugadu. Pao Kurireu uie arego rugadu. Boe etaidure tuwiapagawo Jesus makore jiboeji. Dukodire nou boe eimijerage pegareuge epagudure, eroiwakare tuwo tugeragu Jesusji nou boe epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus makore nou boei pugeje. Makore ia bakaruji tuwo boe ewie toro ia Pao Kurireu meardae ka pugeje. ");
INSERT INTO bor_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Akore: – Pao Kurireu umode boe eimijera kurireudo pudumi dukeje ainore boemode. Imode tawie bakaruji. Ia boe eimijera kurireu onaregedu imedu uwiremode. Dukodire nou boe eimijera kurireu ure ia boe ewadae kurireu towuje. ");
INSERT INTO bor_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ure boe jamedu boe udo turugadu dukeje ure tudugarege etudo nou tumagore bagaiwuge ewagai tuwo ewie boe uie turugadu duji etaregoduwo tuwadae ka rugadu. Mare nou makore bagaiwuge etaidukare tuduwo toro. Eiamedu boe egore tudumodukaie. ");
INSERT INTO bor_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dukodire nou boe eimijera kurireu ure ia tudugarege etudo pugeje toro nou makore bagaiwuge ewagai pugeje. Akore nou tudugaregei: “Tamagodo nou imagore bagaiwugei ire boe eke kurido rugadu. Tapira kodu kareu uie turugadu. Boe jamedu boe uie turugadu.” ");
INSERT INTO bor_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ainore nou boe eimijera kurireu akore. Dukodire nou utugarege eture nou boe ewagai. Mare nou boe ewiapagakare ewadaruji. Eture nou boe eimijera kurireu utugarege epiji. Ia uture to boepato. Ia uture tumaragodure tadawu bai ka. ");
INSERT INTO bor_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iage ere tugeragu nou boe eimijera kurireu utugaregei. Ero pegare ei. Ere ewido. ");
INSERT INTO bor_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nou boe eimijera jorduware nou inoduji dukeje korigodure nou boei rugadu. Ure to tugobaigarege etudo nou boe eda ka. Nou tugobaigarege ere nou boe ewido rugadu. Ere joru tugu nou ewai jamedu boeto. ");
INSERT INTO bor_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nono nou boe eimijera kurireu makore tudugaregei pugeje. Akore: “Itonaregedu uwiremode dukodire ire ewadae pemegado. Boe jamedu boe ure turugadu. Mare nou imagore bagaiwuge epemegakare, etaregodukare. Itaidukare ei pugeje. ");
INSERT INTO bor_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dukodire čare tadudo toro nou boe eda ka ia boe ewagai pugeje. Tamagodo tardumode jiwuge eiamedu boei etaregoduwo mato nou iwadae ka.” ");
INSERT INTO bor_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dukodire čare nou utugarege eture nou boe eda ka rugadu. Ekodure nou boe eda jamedu boe parugajeje. Emagore tuiordure jiwuge eiamedu boei etaregoduwo nou tugimijera kurireu uwadae ka. Nou emagore jiwuge epemegare iage epegare. Dukodire nou boe eimijera kurireu uwadae kejewu bai kurireu korobadure boebo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nono nou boe eimijera kurireu ure turemo nou boe ewadaemode kejewu bai kurireuto tuiorduwo nou aregodureuge boei. Nono jordure ia imeduji nono nou bai tada. Mare nou imedu ukudau areia ure tuginai. Ukare nou tugudau areia boe ewadae kejewu tugu pudui. ");
INSERT INTO bor_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nou boe eimijera kurireu makore nou imeduji. Akore: “Me. Boe ewadae kejewu akudau areia metukare ai. Kočare nuba arore awo aremo awu iwaito?” – Mare nou imedu bataru bokware. ");
INSERT INTO bor_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nono nou boe eimijera kurireu makore tudugaregei. Akore: “Tageragu nou imeduji. Iera kogudo. Bure kogudo. Nono barigu toro bawadu ka, toro boečo ka. Torore boe etragudu rakare. Torore boe emode to reko pui tuwiri boe kori koia.” ");
INSERT INTO bor_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mare paga karega. Pao Kurireu makore bagaiwuge emagare mare ure tugeragu jiwuge emagakare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ia fariseu doge ere tumeardae pegareu tawuje. Etaidure tuwo Jesus barigu boeto tagoino jiboeji. ");
INSERT INTO bor_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dukodire ere ture jorduwadowuge etudo Jesus bagai. Aidure Herodes jiwuge eture ebo jamedu. Etaregodure Jesus ae dukeje enarare ji. Egore: – Boe eimijera nure aki. Awiapagakare boe ewadaru pegareuji. Boe jokodu jire akagoino. Akare awadaru udo paga boei. Ameardaere boei boe remawu tabo. Arduware Pao Kurireu meardaeji. Are boe erduwado nou Pao Kurireu meardaeji tu tu je. Awiapagakare ia boe emeardae pegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dukodire čare čedaidure čenarawo ai ameardae bagai. Nuba pago bakaru akomode paromode jiboeji? Pamode pagoe mori maku Roma kejewu boe eimijera kurireu César ai na? Pamode maku kana? Pamodukana maku? ");
INSERT INTO bor_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mare Jesus jorduware emeardae pegareu boeji. Dukodire mako rakare ei. Akore: – Meardae pegareuge nure tagi. Tameartorukare tawadaruji. Kaba kodiba tagaidure tawo iwarigu boeto tagagoino idu tabo? ");
INSERT INTO bor_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nou boe mode morido aiwu imedu boe enoe diero tori maku inai iorduwo ji ka. Nono ia boe ere ia diero tori maku Jesus ai. ");
INSERT INTO bor_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nono Jesus unarare ei: – Ioguduba je ba padure awu diero tori keje? Ioguduba ie ba padure awu diero tori keje? ");
INSERT INTO bor_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nou boe egore: – Roma kejewu boe eimijera kurireu César ie padure keje. Nono Jesus makore ei. Akore: – Boe rugadu. Čare awu César oeboe maku César ai. Mare Pao Kurireu oeboe maku Pao Kurireu ai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nou boe emeardure Jesus akoino duji dukodire erore ta je akoino pudui duji. Dukodire emagokare ji pugeje. Nono eture piji. ");
INSERT INTO bor_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nou meriji rugadu ia saduceu doge etaregodure Jesus ae tuwo Jesus barigu boeto tagoino jiboeji jamedu. Nou saduceu doge emeardaere boe eewodumodukaie pugeje. ");
INSERT INTO bor_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nono emagore Jesusji. Egore: – Jorduwareu nure aki. Ča mariguduwu makore Pao Kurireu bataru jiwu Moisés ure jaoboe ero maku etai pameartoruwo ji jii aino rugadu. Akore imedu bimoduie mare ore bokwaie dukeje nou imedu uwie muguwo nou tumana bireu oreduje apo orewo nou bireu tumana ai. ");
INSERT INTO bor_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ča ia meri keje ime enodo padure sete. Etumana etuwie mage nure pugi. Etumana mugure ia aredu apo. Mare čare bire. Mare ore bokware. Dukodire nou imedu uwie mugure nou tumana bireu oreduje apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ča nou bire jamedu. Dukodire uwie imedu mugure nou aredu apo. Mare bire jamedu. Dukodire nou uwie ime eiamedu boe emugure nou aredu apo rugadu. Mare eiamedu boe ewire. ");
INSERT INTO bor_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dukeje čare nou aredu bire jamedu. ");
INSERT INTO bor_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dukodire čedaidure čenarawo ai. Pao Kurireu umode eewodudo pugeje dukeje duboba mugumode nou aredu apo? Eiamedu boe emugure apo moto keje mare duboba mugumode nou aredu apo baru tada? ");
INSERT INTO bor_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus makore nou boe ewadaru jipagi. Akore: – Tarduwa bokware. Tarduwakare Pao Kurireu bataru padure kejewu baperaji. Tarduwakare Pao Kurireu ro rakareuji. ");
INSERT INTO bor_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bireuge eewodumode pugeje dukeje emode nono Pao Kurireu utugarege baru tadawuge emogadure. Etuwiremodukare. Etugogemodukare. ");
INSERT INTO bor_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Mare tameardaere boe eewodumodukaie pugeje. Tagaiwo kana padure bapera kejewu Pao Kurireu bataruji? Pao Kurireu akore: “Abraão meartorure jiwu Pao Kurireu nure imi. Isaque meartorure jiwu Pao Kurireu nure imi. Jacó meartorure jiwu Pao Kurireu nure imi.” – Pao Kurireu makore jiwu ime ewire marigudu. Mare Pao Kurireu makore emeartoruie pudui rugadu. Dukodire parduware eewodure pugeje duji. Bireuge emeartorumodukare Pao Kurireuji. Jewodureuge emeartorumode ji. Dukodire tameardae ukare turugadu. Boe eewodumode pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mare boe emagare nono tuwiapaga tabo Jesus akoino duji. Emeardure dukeje eku kidure nou Jesus bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseu doge erduware Jesus mako pemegare nou saduceu doge ewadaru jipagi duji. Dukodire ere bato pui pugeje. ");
INSERT INTO bor_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ia jorduware Pao Kurireu ure maku etaiwu bakaruji rugadu. Emare ure tumeardae tawuje tunarawo Jesusji pugeje. ");
INSERT INTO bor_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Akore: – Kakojiwu Pao Kurireu bataru pemegareu remawu jiba pamode pageragu? ");
INSERT INTO bor_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jesus akore: – Ere pobe. Boetojiwu bataru kurireu ure aino: “Pao Kurireu ure mitotu je. Tameardu kurido Pao Kurireuji taraga tabo, tameardae pemegareu tabo, tarore jiboe jamedu boe tabo. Boe eiamedu boe erduwawo awu bataruji rugadu.” Ainore Pao Kurireu bataru kurireu boetojiwu ure. ");
INSERT INTO bor_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pao Kurireu bataru boigoduwu ure aino: “Tameardu kurido tamedagei nono tameardu kuri moga tai dumogadure.” Ia bataru kurireu bokware nono awu bataru pobedu doge emogadure. ");
INSERT INTO bor_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Boe emeartorumode nou bataru pobedu dogei boetoji. Dutabore emeartorumode makudure Judeu doge etaiwu bakaruji rugadu. Dutabore emeartorumode nou mariguduwu makore Pao Kurireu bataru jiwuge emagore jiboeji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseu doge edure nono Jesus apo kimo. Dukejere Jesus unarare ei. ");
INSERT INTO bor_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Akore: – Nuba tameardaere nou umode boe ekinorudowuji. Ioguduba onaregedu mode ema? Egore: – Mariguduwu pawobe ekimijera kurireu Davi onaregedu mode ema. ");
INSERT INTO bor_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Jesus akore: – Mare Pao Kurireu Uwari ure Pao Kurireu bataru maku nou Davi ai marigudu. Dukodire Davi akore: – Pao Kurireu makore nou ikimijera umode boe ekinorudowuji. Akore: “Amugudo woe ikana pemegareu jagwai jii toro imode nou jordu pegare aiwuge etagedudo du ka.” – Ainore nou Davi akore marigudu tuwo boe ewie Pao Kurireu bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tagoino dutabo Davi akore tugimijera nuie nou umode boe ekinorudowuče. Mare Davi onaregedu mode ema jamedu. Ča nuba nou umode boe ekinorudowu ure? ");
INSERT INTO bor_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nou boe erduwakare tumagowo nou Jesus bataru jipagi pugeje. Dupijire boe eraga bokware tunarawo Jesusji pugeje. Eraga bokware tuwo Jesus barigu boeto tagoino jiboeji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nono Jesus makore ture jorduwadowugei. Boe emagare nono ebo. Jesus makore nou boe eiamedu boei. ");
INSERT INTO bor_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Akore: – Nou ure boe erduwado Judeu doge eno bakaru jiwuge ere tumugudo Moisés mugato. Nou fariseu doge ere tumugudo Moisés mugato. Dukodire tagimijerage nure emage. ");
INSERT INTO bor_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dukodire tameartorudo ei emagore taiboe jamedu boeji. Mare tarokaba nono ero mogadure. Emage emeartorukare tuwadaruji rugadu. Dukodire inagoino tarokawo nono ero mogadure. ");
INSERT INTO bor_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ere turo makado boe etai tuwo boe rakado ei rugadu. Mare ekare tugera maku nou boe etai tuwo turaga maku etai. ");
INSERT INTO bor_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Erore jiboe etaidure boe erduwo turore jiboeji boe emagowo pudui boe emago pemegawo pudui. Ere boe etaiwodo tugudau areia motureu meture pudui duji. Etaidure tuwo boe epogurudo. Egore tu pudumie tuiorduwaie tumago raiwo Pao Kurireu bagai. Mare pagatu je. Emago raikare tumeardae remawu tabo Pao Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Etumode boe ewadae ka dukeje etumode boe eke jeture kejewu ira ka boe etododai togwagewo boetoji. Etumode Judeu doge ere bato puiwu bai ka dukeje emode tugeragu nou boe eimijera mugure kejewu iraji tumuguwo keje. ");
INSERT INTO bor_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Etumode ba kurireu ka dukeje etaidure boe emago pemegawo pudui etaidure boe ekimijeragewo pudumi dukodi. ");
INSERT INTO bor_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","– Mare tarokaba nono ero mogadure. Tagimijera ure mitotu je. Pao Kurireu nure ema. Dukodire taiamedu boe tawobe nure pugi. Tagaidukaba tawo boe eimijeragedo tagi. ");
INSERT INTO bor_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tagaidukaba tawo tado nono boe etuo mogadure. Pao ure mitotu je. Rakojere baru tada. ");
INSERT INTO bor_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tagaidukaba tawo tado nono umode boe erduwadowu mogadure. Umode boe erduwadowu remawu ure mitotu je. Umode boe ekinorudowu nure ema. ");
INSERT INTO bor_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mare ia tagi tagaidumode tawo boe ekimijeragedo tagi dukeje tameardaemode nono boe utugare meardae mogadure tawo boe eimijera pemegareugedo tagi. ");
INSERT INTO bor_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Boe enojaromode pudui, emode tugimijerado pudumi tumeardae tabo dukeje Pao Kurireu umode epogurudo. Mare boe emode boe utugaregedo pudumi turo pemegawo boei dukeje Pao Kurireu umode boe eimijera pemegareugedo emage rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nono ča Jesus makore fariseu dogei. Makore ure boe erduwado Judeu doge eno bakaru jiwugei jamedu. Akore: – Boe eimijerage nure tagi mare tameartorukare tawadaruji. Dukodire boe pegamode tai rugadu. Tare boe emeartoru okwado Pao Kurireuji dukodire emodukare tugimijerado Pao Kurireuče. Tagi jamedu tagare tagimijerado Pao Kurireuče. Mare ia boe etaidure tuwo tugimijerado Pao Kurireuče rugadu. Mare tare ewarigu boeto nou emeardae piji rugadu. Dukodire boe pegamode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Tagiwogure okoge bokwareuge eno dieroji epiji. Mare tagaidure tawo boe etaidudo tai dukodire tamago raimode Pao Kurireu bagai baruto boe ewiagai. Mare pagare taroino tagagoino. Boe emeardae pemegawo tai dubagaire taroino. Dukodire boe pegamode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Tagodu jaemode. Tagurugodumode pobo maereu kajeje tagaiwowo ia boe ewagai tawo emeartorudo tawadaruji, tarore jiboeji. Nono tamode emeartorudo mare taroino dutabo tamode ro pegareu remawugedo emage. Ero pegamode taro pegareu kori. Dukodire ewarigudumode bope doge eda kejewu joru pegareuto rugadu tagabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Boe pegamode tai rugadu. Tare nono joku bokwareuge emogadure. Mare taeku ji karega inagoino. Tarduwakare boe remawuji rugadu. Dujire inagoino. Tare boe erduwado tameardaeji. Tagagore boe emagomoduie Pao Kurireu uwai kurireu ie tabo. Mare emodukaie nou tumagore jiboe towuje. Dukeje boe pegamodukaie ei. Ainore tagagore. Dujire tare boe erduwado. Mare tagagore boe emagomoduie Pao Kurireu uwai tadawu tori kuieje ie tabo. Mare boe emodukaie nou tumagore jiboe towuje. Dukeje boe pegamoduie ei rugadu. Ainore tagagore. Dujire tare boe erduwado. ");
INSERT INTO bor_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mare pagare tagagoino. Jorduwa bokwareuge nure tagi. Tare nono joku bokwareuge emogadure. Mare taeku ji karega inagoino. Tarduwakare boe remawuji. Dujire inagoino. Ča iwo tawie boe remawuji. Nou mugure Pao kurireu uwai tadawu tori kuieje na ure Pao kurireu uwaido tuginai? Boro. Pao kurireu uwai pemegare nou tori kuieje kori rugadu. Mare nou tori kuieje mugumodukare Pao kurireu uwai ja tada dukeje tori kuieje tuginaiwu modukare ema rugadu. Pao Kurireu uwai pemegare nou tori kuieje kori rugadu. Dukodire inagoino tamagore jiboe ukare turugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tagagore boei emagomoduie Pao Kurireu uwai tadawu kamo ie tabo. Mare emodukaie tumagore jiboe towuje. Dukeje boe pegamodukaie ei. Ainore tagagore. Mare tagagore boei emagomoduie nou padure nou kamo kejeboe ie tabo. Mare emodukaie nou tumagore jiboe towuje. Dukeje boe pegamoduie ei rugadu. Ainore tagagore. ");
INSERT INTO bor_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tare nono joku bokwareuge emogadure. Mare taeku ji karega inagoino. Tarduwa bokware. Dujire inagoino. Nou Pao Kurireu uwai tadawu kamo kejere boe emode ia tagu barogo kodu kowu tomeawo tabo Pao Kurireu ai. Padumodukare nou kamo keje dukeje tagomeamodukare tabo Pao Kurireu ai. Dukodire nou kamo pemegare nou padure kamo kejeboe kori. ");
INSERT INTO bor_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dukodire imode tawie. Boe emagomode nou Pao Kurireu uwai tadawu kamo ie tabo dukeje nou kamo kejeboe ie tabore egoino jamedu. ");
INSERT INTO bor_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Boe emagomode Pao Kurireu uwai kurireu ie tabo dukeje Pao Kurireu ie jire egoino jamedu. Pao Kurireu mugure tuwai kurireu tada rugadu dukodi. ");
INSERT INTO bor_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Boe emagomode baru ie tabo dukeje nou baru tadawu Pao Kurireu mugure kejewu ira ie tabore egoino jamedu. Pao Kurireu ie tabore egoino jamedu. ");
INSERT INTO bor_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Tare tago boepa pijiwu boe aru rogu mori kado puiato tu tu je tagomeawo iarogu tabo Pao Kurireu ae. Nou tarore jiboe pegakare. Tarodo ji rugadu. Mare tagare tameartorudo Pao Kurireu bataru remawuji rugadu. Tameardaekare tawo taro jetorodo boei. Tameardaekare tagoguduwo boebo. Tameardaekare tameartoruwo Pao Kurireu bataruji jii toro rugadu. Dujire inagoino. Dukodire čare boe pegamode tai rugadu. Ča taro jetorodo boei. Tagogududo boebo. Tameartorudo Pao Kurireu bataruji jii toro rugadu. Dujire inagoino tameartoruwo Pao Kurireu bataru remawuji. ");
INSERT INTO bor_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Joku bokwareuge nure tagi mare du inodu tabo tare boe erduwado awaraji. Mare taeku ji karega inagoino. Tarduwa bokware Pao Kurireu bataru remawuji. Dujire inagoino. Dukodire tawiapagare tawo ia ruke rogu tawuje tagudumode čewu pobo piji mare tare barogo kurireu remo tagogwato. Mare ruke ji karega inagoino. Taro pegareu biagareu jire inagoino. Barogo ji karega inagoino. Taro pegareu remawu jire inagoino. Tamororamagadure taro pegareu biagareuji mare tawiapagakare nou taro pegareu remawuji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Tare tago pagaga kabi tawo pemegado tarowo nou taro boeji nou pagaga tabo. Tare tago ruwobo kabi tawo pemegado tarowo nou taro boeji nou ruwobo tabo jamedu. Ainore tago bakaru ure. Tameardaere tare Pao Kurireu jakaredo pudui nou taro tabo. Mare pagatu jere taroino. Tadadare tameardae pegare rugadu. Tagogwa kidure tu tagai tawo tagoe kurido tamedage epiji. Tagaidure tawo boe pemegado tu tai. ");
INSERT INTO bor_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tarduwa bokware! Tadadare tamode tameardae pemegado dukeje tabemegamode Pao Kurireu jakai. Mare taro jire inagoino jamedu. ");
INSERT INTO bor_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Tare nono bireuge emedure tadawu moto poro mogadure. Mare moto poro ji karega inagoino. Tabegareu meture tadada tameardae pegare dukodi. Dujire inagoino. Boe etaiwore tai dukeje emeardae pemegare tai. Egore ro pemegareuge nuie tagi. Mare tadadare tameardae ure nono bireu ra mogadure. Tameardae ure nono bireu apowu ro kigoreboe mogadure. Mare bireu ra ji karega inagoino. Ro kigoreboe ji karega inagoino. Tameardaere jiboe jire inagoino. Tameardaere tawo Judeu doge erduwado tawadaruji. Mare pagatu je. Tameartoru bokware nou tawadaruji. Dujire inagoino. Tameardae pegare taro pegawo rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Fariseu doge nure tagi. Ure boe erduwado Judeu doge eno bakaru jiwuge nure tagi. Tameartorukare tawadaruji dukodire boe pegamode tai rugadu. Mariguduwu tawobe ero pegare makore Pao Kurireu bataru jiwugei rugadu. Ere iage ewido rugadu. Aino čare tare tori motureu rakojedo nou bireuge etugudure towu moto keje boe erduwawo nonore nou makore Pao Kurireu bataru jiwuge bireuge emedure duji. ");
INSERT INTO bor_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tagagore: “Paragojemode nou mariguduwu pawobebo dukeje pamodukare nou makore Pao Kurireu bataru jiwuge ewido nono pawobe ero mogadure.” ");
INSERT INTO bor_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mare pagare tagagoino. Tameartorukare i. Dukodire tagi rugadu tare boe erduwado tameardae remawuji. Tare nono nou mariguduwuge emogadure ere makore Pao Kurireu bataru jiwuge ewido rugadu. Tare nono emogadure. ");
INSERT INTO bor_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dukodire čare taromode nono nou mariguduwuge tawobe ero mogadure jii nou tameardae pegareu idu oto pa ka. ");
INSERT INTO bor_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","– Tare nono awagu pegareuge emogadure rugadu. Mare awagu ji karega inagoino. Tameardae pegare rugadu taro pegawo rugadu. Dujire inagoino. Dukodire tawarigudumode bope doge eda kejewu joru pegareuto rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mare paga karega. Imode makore Pao Kurireu bataru jiwuge etarego tawagai. Imode jorduwareuge etarego tawagai. Imode ure boe erduwadowuge etarego tawagai. Mare tawiapagamodukare ei. Taro pegamode ei. Tamode iage ewido ipo padure pugajejewu keje. Tamode boeto iagei bukigu tabo Judeu doge ere bato puiwu bai tada. Taregodumode iage eregodaji boe eda jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dukodire nou ro pemegareuge eiamedu boe ewi mori butumode tawugeje rugadu. Tawobe ere ro pemegareuge ewido marigudu. Ere ro pemegareu boetojiwu Abel bito. Ere ro pemegareu boigoduwu Baraquias onaregedu Zacarias bito jamedu. Ere nou Zacarias bito Pao Kurireu uwai jokorai. Nou Abel piji jii Zacarias ae ro pemegareuge emagare rugadu. Mare tawobe mariguduwuge ere bitowuge emagare jamedu. Mare tagaire Pao Kurireu umode nou tawobe ero pegareu jamedu boe morido tagai. ");
INSERT INTO bor_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nou mariguduwuge tawobe ero pegareu jamedu boe mori barigudumode tawugeje rugadu meartorukare iwuge tawobe ewugeje jamedu aino kuri aino. Inure tawie boe remawuji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesus aiwore toro Jerusalém ba kurireu ka. Dukejere čare kiarigodure rugadu. Mako kimore. Nou Jerusalém kejewugeire akoino. Akore: – Jerusalém kejewuge nure tagi. Tare nou mariguduwuge makore Pao Kurireu bataru jiwuge ewido. Aregodure Pao kurireu bataru tabo tagaewuge tare tori barigu etae tawo ewido. Mare imeardu kurire tai rugadu. Kagariga umode tore ewiado tugana kuda tietu pemegawo ei. Itaidure irowo taiamedu boei nono nou kagariga ro moga torei dumogadure. Mare tagaidukare i. ");
INSERT INTO bor_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dukodire Pao Kurireu mugumodukare Jerusalém kejewu tuwai tada pugeje. ");
INSERT INTO bor_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iwo tawie. Tardumodukare i pugeje jii toro tameartorumode i du ka. Tagagomode: “Pagimijera reo! Aregodure Pao Kurireu meardae tabo. Pao Kurireu ro pemegawo ji.” Tamagomode aino i dukeje itaregodumode tagae pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus ure tudawuje Pao Kurireu uwai kurireu piji. Kodure dukeje nou ure jorduwadowuge ere tuburedo Jesusji. Etaiwore nou Pao Kurireu uwai kurireuji. Egore nou bai motuie rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nono Jesus akore: – Iwo tawie boe remawuji. Ro pegareuge emode nou tardure jiwu bai kurireu butudo rugadu. Tori tabore pawobe ere towuje marigudu. Mare ia meri keje nou tori jamedu boe epadumodukare pu aogeje pugeje. ");
INSERT INTO bor_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus uture Oliveira ri ao ka. Nono ure tumugudo nono. Nou ure jorduwadowuge ere tumugudo nono Jesus apo jamedu. Tu emagere emugure nono. Nono enarare Jesusji. Egore: – Akagore ro pegareuge emoduie Pao Kurireu uwai butudo ia meri keje. Kaba meri kejeba emode butudo? Kaba jiba čerdumode čerduwawo boe puredugodure akaregoduwo pugeje rugadu duji? Kaba jiba čerdumode čerduwawo moto akedumode kuri aino duji? ");
INSERT INTO bor_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus akore: – Taeku jado boe ekawo taekiripagado. ");
INSERT INTO bor_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Boe emagamode tuwadaru pemegareu tabo. Egomode umode boe ekinorudowu nuie pudumi. Mare pagare egoino. Mare du inodu tabo emode boe ekiripagado rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tameardumode bakaru pegareuji. Boe emode tawie boe erugoduie pui tuwaiga tabo. Boe erugodu akedukaie. Boe egomode nou torowu boe ekorigoduie dukodie erugodu kurie pui rugadu. Mare taragado tai tamororamagadukawo. Pao Kurireu jorduware ro pegareuge erugoduji marigudu. Umodukare nou erugodu tawuje epiji. Erugodumode pui tuwaiga tabo rugadu mare moto akedumodukare raga. ");
INSERT INTO bor_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Boe eimijerage kurireuge erugodumode pui tugobaigaregebo. Boe eke bokwamode boe jamedu boe parugajeje. Dukodire boe ewimode tuge boei koia. Moto magadugodumode boe jamedu boe parugajeje jamedu. ");
INSERT INTO bor_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Awu inagoino jiwu iwadaru jetumode pudui dukeje tarduwamode moto akedumode kuri aino duji nono aredu kurijirigodu mogadure. Aredu kurijirigodure dukeje boe erduware kuri butumode kuri aino duji. Mare aredu kurijirigodu ji karega inagoino. Boe pegamode motoji nono iwadaru mogadure dukeje tarduwamode moto akedumode kuri aino duji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nono ro pegareuge emode tamagu boe eimijerage pegareuge etai ero pegawo tai, ewo tawido. Tameartorure i dukeje boe erdu pegamode tai moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nou meri keje boe emode tugera ra tumeartorure idu piji rugadu. Erdu pegamode pui. Emode pu maku boe eimijera pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Boe egomode tumagoie Pao Kurireu bataruji. Mare pagatu jere egoino. Mare du inodu tabo boe emeartorumode ei. Emode jekiripagadowuge emagamode rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Boe emode turo pegareu kodudo tugori pugeje. Dukodi boe emeardu kurimodukare pui pugeje. Meardu kurire puiwuge enowaromode tu je. ");
INSERT INTO bor_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mare ia boe emodukare tugera ra tumeartorure i dupiji dukeje imode ekinorudo. ");
INSERT INTO bor_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nono boe emagomode boei ewo tugimijerado Pao Kurireuče moto jamedu boe parugajeje. Emagomode nou bataruji boe tuginaiwuge eiamedu boe ewiagai dukeje moto akedumode. ");
INSERT INTO bor_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iwo tawie. Tardumode nou Pao Kurireu jordu pegare jiboeji Pao Kurireu uwai tada. Marigudu nou makore Pao Kurireu bataru jiwu imedu Daniel ure boe ewie boemoduie aino rugadu. Jordumode awu bapera jiwuge eiamedu boe ewiapaga pemegawo awu bataruji. ");
INSERT INTO bor_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mare boe erdumode nou Pao Kurireu jordu pegare jiboeji Pao Kurireu uwai tada dukeje Judéia moto kejewuge eregodu rakamode toro tori ao ka tuwo tuginorudo boe pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nou rakojere tuwai ao kejewuge eregoduwo tuwai piji kuri je rugadu. Ekawo turemo tuwai jagi iaboe bagai. Etuwo tugera kedo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nou maragodure to boepa jiwuge eregoduwo nou to boepa piji kuri je jamedu. Ekawo tugirimi tuwai ka ia tugudau areia bagai. ");
INSERT INTO bor_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nou meriji boe pegamode kuiarureugei rugadu. Boe pegamode ei rugadu eroiwakare turegodu rakawo dukodi. Boe pegamode boe etore etuje magei jamedu eroiwakare ture rakawo dukodi. ");
INSERT INTO bor_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tamagodo baruto Pao Kurireu bagai boe pegakawo aino boei sábado meri keje. Tamagodo baruto Pao Kurireu bagai biaku butukawo boei nou eregodure jiwu meri keje. ");
INSERT INTO bor_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","22","Mare paga karega. Boe pegamode boei rugadu boe pega jamedu boe kori. Pao Kurireu ure moto to dupiji boe erdukare awu boe pegareu boeji jii aino. Mare boe pegamode motoji rugadu. Nou boe pegamode kejewu meri makamode. Mare Pao Kurireu umode nou merido biagatu je rugadu. Nou boe pegamode kejewu meri makamode rugadu dukeje boe eiamedu boe ewimode rugadu. Mare Pao Kurireu umode nou boe pegamode kejewu merido biagatu je tuwo meartorure puduiwuge edo činorudo. ");
INSERT INTO bor_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mare boe pegamode kejewu meri aregodumode dukeje boe egomode: “Umode boe ekinorudowu aregodu! Ema reo!” Ainore boe egomode. Mare tawiapagakaba ewadaruji. Pagare egoino. ");
INSERT INTO bor_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mare paga karega inagoino. Boe etaregodumode rugadu nou tuwadaru tabo rugadu. Egomode umode boe ekinorudowu nuie pudumi. Mare pagare egoino. Egomode tumagoie Pao Kurireu bataruji mare pagare egoino. Ero rakamode boe emeartoruwo pudui Pao Kurireu piji pagatu je. Emodukare meartorure Pao Kurireu jiwuge remawuge ekiripagado. Mare etaidumode tuwo meartorure Pao Kurireu jiwuge ekiripagado nou turo rakareu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dukodi čare ire tawie rugadu. Taeku jado. Pagare eroino. ");
INSERT INTO bor_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Dukodire tarduwamode. Boe egomode umode boe ekinorudowu rakojeie boe maereu keje mare tameartorukaba ei. Boe egomode rakojeie ia bai tada mare tameartorukaba ei. ");
INSERT INTO bor_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Imedu Onaregedu aregodumode moto ka pugeje dukeje boe erdumode ji rugadu nono boe erdure boeiaragudu jitu mogadure. Boeiaragudure dukeje boe erdu jaere ji. Nono boe erdu jaemode itaregoduji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Boe erdumode Imedu Onaregedu aregoduji nono boe erdure pobureuge ere tago puae barogo bireu kodu keje jitu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Boe pegare moto jiboe akedumode dukeje meri joku akedumode jamedu. Ari joku akedumode. Kuieje doge ewudumode baru piji jamedu. Baru magadugodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dukeje čare boe erdumode Imedu Onaregeduji baru tada. Boe tuginaiwuge eiamedu boe ekiarigodumode rugadu boe jamedu boe parugajeje. Erdumode Imedu Onaregeduji kodure boetugu aoji. Erdumode Imedu Onaregedu ro rakareuji. Erdumode Imedu Onaregedu o jorugu kurireuji. Jorugure moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nono umode tudugare baru tadawu udo tapira ukiga akodo tuwo tudugarege baru tadawuge etudo Pao Kurireu ure tugeragu jiwuge ewagai moto jamedu boe parugajeje. Emode edo tudo pui. ");
INSERT INTO bor_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Figo i ure tarduwado tu tu je. Figo i okurogu boture dukeje tarduware bubutumode kuri je rugadu. Tagaiwore figo iji tarduwawo bubutumode kejewu meriji. Ainore tarore tu tu je. ");
INSERT INTO bor_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ča ire tawie nuba boemode meri jokuji nuba boemode ari jokuji. Iwo tawie. Tagaiwodo awu ire tawie jiboe jamedu boeji emode tarduwado dubagai. Tardumode ire tawie jiwu iwadaru jetumode pudui duji dukeje tarduwamode boe puredugodure itaregoduwo iwo boe jamedu boe akedudo. Mare bubutu ji karega inagoino. Nou itaregodumode jiwu meri jire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iwo tawie boe remawuji. Toro ia meri keje ia tawobe erdumode awu imagore jiboe jeture pudui duji rugadu. Jetumode pudui rugadu tuwimodedu otodai. ");
INSERT INTO bor_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Baru akedumode. Moto akedumode jamedu. Mare iwadaru akedumodukare jii toro rugadu. Jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nono Jesus mako kimore. Akore: – Boe erduwakare nou meriji rugadu. Boe erduwakare nuba meri mode awu iwadaru jetuwo pudui. Pao Kurireu utugarege baru tadawuge erduwakare. Pao Kurireu Onaregedu jorduwakare. Tu Pao Kurireu jorduware tu rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Imedu Onaregedu aregodumode pugeje dukeje boe emeardaemode nono rakojere boe etumana Noé apowuge emeardae pegareu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Mariguduboe etumana Noé rakoje kimore dukeje boe ewiapagakare pobo aregodumode duji. Ewiapagare tu tugeji tugudure če boeji. Ime ewiapagare tu tuwirewo. Areme ewiapagare tu tugogewo jamedu. Erore aino jii toro Noé ure turemo ikarereu to du ka. Noé ure turemo ikarereuto tu tuwobebo rugadu. Mare iage ewiapagakare Noéji dukodire erduwa bokware pobo umode moto kejewuge eiamedu boe etagedudo duji. Dukodire nou pobo aregodure, ure eiamedu boe etagedudo rugadu. Ainore boe emeardaemode pugeje. Imedu Onaregedu aregodumode pugeje mare boe ewiapagamodukare bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ime emode pobe tumaragodae keje ipoguru keje. Imode ikeragu iaji mare metia utumodukare. ");
INSERT INTO bor_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Areme emode pobe tumaragodae keje tuwo trigo kududo. Imode ikeragu iarodoji mare metago utumodukare. ");
INSERT INTO bor_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dukodire inagoino tai taeku jaewo. Tarduwakare kaba meri kejeba Tagimijera Kurireu aregodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mare tawiagodukaba. Uwaire bai čewu jorduwamode kaba meri kejeba iwogureu aregodumode dukeje umode tudo turugadu taiwo tabo nou iwogureu bagai nou iwogureu ukawo turemo nou baito nou boečoji. ");
INSERT INTO bor_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tado tarugadu tagaiwo tabo jamedu. Mare iwogureu bagai karega. Tado tarugadu Imedu Onaregedu aregodumode dubagai. Tarduwakare kaba meri kejeba aregodumode dukodire inagoino tawo tado tarugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesus mako kimore. Akore: – Nuba boemode boe utugare pemegareu jorduwareuji? Ukimijera aidumode tuduwo toro ia moto ka dukeje umode nou tudugare pemegareu mugudo tumugato tudugarege eimijerawo ema uwo iage eke maku etai nou tudure jiwu meri keje. ");
INSERT INTO bor_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nou utugare ro pemegamode meartorumode tugimijeraji jii toro tugimijera aregodumode kejewu meri ka dukeje jakaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dukejere čare nou boe eimijera umode nou tudugare jetudo toe jamedu boeji jetu pemegawo ji. Boe jokodu jire inagoino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mare ia boe utugare meardae pegamode. Nou ukimijera utu jaemode jamedu dukeje aregodumodukare tuibagi kuri je. Nono nou utugare pegareu meardaemode tugimijera aregodumodukaie pugeje duji. ");
INSERT INTO bor_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nono umode boeto nouia tudugarege imei, aremei jamedu. Nono maragodumodukare pugeje mare okwagemode, kudumode jamedu. Nono uke kurumode ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Čare ia meri keje nou ukimijera aregodumode tuibagi pugeje. Mare nou utugare upagakare bagai. Jorduwakare aregodumode kejewu meriji. ");
INSERT INTO bor_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nono nou boe eimijera jordumode nou tudugare ro pegare duji. Dukodire nou ukimijera umode nou tudugare bito. Umode bowuje rugadu. Nono umode nou tudugare barigu toro boe pegareuto ime pegareugebo nou meartorukare tuwadaru jiwugebo. Torore boe etragudu rakamode. Torore boe emode to reko pui tuwiri boe kori koia. ");
INSERT INTO bor_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus mako kimore. Akore: – Imode tawie nuba ure tugimijerado Pao Kurireu čewuge emode toro nou inagoino jiwu meri keje. Ireadodumode bakaruji iwo tawie. Ča nogware enodo padu kejeboere dez. Ere tudawuje tuwai piji joru kuru meture tadawu to jorugu tabo tuduwo uwiremodewu iparedu togi. ");
INSERT INTO bor_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jorduwareuge nogwarere ikera aboudure. Jorduwa bokwareuge nogwarere ikera aboudure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nou jorduwa bokwareuge nogware eture to jorugu tabo mare etukare ia joru kuru kobo tabo. Eture tabowu joru kuru meture to jorugu tada tu rugadu. ");
INSERT INTO bor_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mare nou jorduwareu nogware eture to jorugu tabo, nou meture to jorugu tadawu joru kuru tabo, ia joru kuru kobo tabo jamedu, joru kuru akedukawo. ");
INSERT INTO bor_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ča nou uwiremodewu iparedu akekare ji dukodire aregodukare jii boečoji. Dukodire nou nogware eiamedu boe enudure. Norire ekuji dukodire enudure. ");
INSERT INTO bor_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ča ari aregodure baru oia ka dukeje boe ekudure boe etae. Egore: “Uwiremodewu iparedu aregodu! Mato! Mato togi!” ");
INSERT INTO bor_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dukodire nou nogware edadure. Ere nou to jorugu uradu rogu kado urugu pemegawo. ");
INSERT INTO bor_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mare nou jorduwa bokwareuge nogware emagore nou jorduwareugei. Egore: “Ia joru kuru maku čenai. Čeno joru kuru akedugodu.” ");
INSERT INTO bor_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mare nou jorduwareuge nogware egore: “Boro. Čeno joru kuru kurikare. Umode turugadu tu čei tu rugadu. Umodukare turugadu tai. Tadudo toro boe jetureu ka tawo tageragu ia joru kuruji pugeje tagoče.” ");
INSERT INTO bor_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dukodire nou jorduwa bokwareuge nogware eture rugadu tuwo akirodo joru kuruji. Mare ekare tugirimi dukeje nou uwiremodewu iparedu aregodure. Nou jorduwareuge nogware ere tudo turugadu marigudu dukodire ere turemo nou uwiremodewu uwaito nou boe ewadae ka rugadu. Nono nou bai poro midure tuku rugadu. ");
INSERT INTO bor_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jii je dukeje nou jorduwa bokwareuge nogware etaregodure boe jetureu piji. Nono egore: “Čegimijera. Bai poro jado čenai.” ");
INSERT INTO bor_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mare nou uwiremodewu iparedu uwai tadawu boe eimijera akore: “Iorduwakare tai. Imodukare jado.” ");
INSERT INTO bor_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesus mako kimore. Akore: – Ainore nou boe egore. Mare Pao Kurireu meardae jire ireadodure aino tawiagai. Tarduwakare kaba meri kejeba Pao Kurireu aregodumode pugeje dukodire tado tarugadu marigudu. ");
INSERT INTO bor_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesus mako kimore. Akore: – Ča ia bakaru reo pugeje iwo tawie nuba ure tugimijerado Pao Kurireu čewuge emode toro nou inagoino jiwu meri keje. Ia meri keje imedu ure tumeardae tawuje tudu jaewo toro ia moto ka. Dukodire makore tudugarege ewagai. Ure etudo toe jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nou utugarege pemegareuge etaire ure to diero kurido etai. Dukodire ure diero tori kuieje oto padudo quinhentos makuduwo ia tudugare pemegareu ai. Ure udo quinhentos ai utugare pemegareu nure ema kodi. Ure diero tori kuieje oto padudo duzentos makuduwo ia tudugare ai. Ure diero tori kuieje oto padudo cem makuduwo ia tudugare ai pugeje. Ure udo cem ai utugare pemega jokodukare dukodi. Nono nou imedu uture. Utu jaere toro ia moto ka. ");
INSERT INTO bor_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nou quinhentos makudure aiwu imedu ure tudawuje kuri je tumaragoduwo nou diero tabo tuwo nou diero kurido tugori pugeje. Dukodire ure nou diero kurido rugadu dukodire o diero oto padure mil. ");
INSERT INTO bor_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nou duzentos makudure aiwu imedu rore nono nou timedia ro mogadure jamedu. Ure to diero kurido jamedu dukodire o diero oto padure quatrocentos pugeje. ");
INSERT INTO bor_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mare nou cem makudure aiwu imedu maragodukare nou makudure pudaiwu diero tabo. Ure tudawuje nou diero tabo. Ure moto porodo nono ure nou makudure pudaiwu diero tugu nou mototo tuwo nou tugimijera o diero biado. ");
INSERT INTO bor_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Toro ia meri keje nou utu jaereu imedu aregodure tuibagi to moto ka tuwai ka. Dukeje čare makore nou tudugarege ewagai pugeje tumagowo nou eture jiwu diero bagai. ");
INSERT INTO bor_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nou quinhentos makudure aiwu utugare aregodure nou to diero rugadu boe tabo. Akore: “Ikimijera. Are quinhentos maku inai. Ča ire kurido dukodire oto padure mil aino. Ema reo.” ");
INSERT INTO bor_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ukimijera akore: “Aru! Aro pemegare rugadu. Itugare pemegareu nure aki rugadu! Ameartorure i rugadu dukodire aro pemegare inoe roguji. Dukodire imode boe eimijerado aki rugadu aetu pemegawo inoe kurireuji rugadu. Mato. Aremo iwaito aegarewo ai itabo.” ");
INSERT INTO bor_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nono nouia utugare aregodure jamedu. Akore: “Ikimijera. Are duzentos maku inai. Akaiwodo. Ire ako diero kurido. Dukodire oto padure quatrocentos aino. Ema reo.” ");
INSERT INTO bor_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ukimijera akore: “Aru! Aro pemegare rugadu. Itugare pemegareu nure aki rugadu! Ameartorure i rugadu dukodire aro pemegare inoe roguji. Dukodire imode boe eimijerado aki rugadu aetu pemegawo inoe kurireuji rugadu. Mato. Aremo iwaito aegarewo ai itabo.” ");
INSERT INTO bor_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nono nou utugare pemega jokodukareu aregodure jamedu. Akore: “Ikimijera. Ipagudure ače. Are boe emaragodae rakado ei awo akoe kurido. Are boe emaragodu rakado ako boepaji. Emagere ere ako boepa pemegado mare akai rugadu. Are emaragodae rakado ei ako boepa tadaboe kadoduwo mare etai karega akai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dukodire itaidukare iwo ako diero barigu boeto. Dukodire imaragodukare ako diero tabo. Ire biado moto kuda akedukawo. Ča itaregodure tabo. Ema reo.” ");
INSERT INTO bor_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mare nou ukimijera jordu pegare tudugare roino duji. Akore: “Aro pega! Akera kiarire rugadu. Ameardae pega kana irore jiboeji? Ire tamaragodae maku tagai tawo ino boepa pemegado rugadu dukodire inoe kurire rugadu. ");
INSERT INTO bor_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mare kodiba akare ino diero tugu boe mode tugeragu diero pijiwu baito? Aromode aino dukeje ino diero itodumode rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nono nou ukimijera makore ia tudugarege ewagai. Makore ei. Akore: “Tageragu nou dieroji nou itugare pegareu piji tawo maku nou mil apowu ai. ");
INSERT INTO bor_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Imode tawie. Maragodu pemegareuge etaire boe makudumode. Mare nou maragodu pegareuge etaire boe makudumodukare rugadu. Nou maragodu pegareuge enoe rogu mode mare nou enoe rogu akedumode epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ča nou itugare pegareu barigu toro boečoto. Nou rakojere torowuge etragudu rakamode rugadu. Torore nou boe emode to reko pui tuwiri boe kori koia rugadu.” ");
INSERT INTO bor_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus mako kimore. Akore: – Toro ia meri keje Imedu Onaregedu aregodumode to jorugu kurireu tabo joruguwo moto jamedu boe parugajeje. Aregodumode turo rakareu tabo jamedu. Pao Kurireu utugarege baru tadawuge etaregodumode apo jamedu. Dukeje Imedu Onaregedu umode tumugudo boe eimijera mugure kejewu to ira motureu keje. Boe erduwamode baru tadawu nure ema duji. ");
INSERT INTO bor_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nono boe eiamedu boe etaregodumode bagai moto jamedu boe piji. Dukeje čare Imedu Onaregedu aiwomode boei. Umode tugeragu meartorure Pao Kurireu jiwuge remawugei tuwo etawuje meartorukare Pao Kurireu jiwuge epiji. Romode nono ia imedu jeture boe eguie jitu ro mogadure. Jeture ovelha dogeiwu umode ovelha doge etawuje cabrito doge epiji. ");
INSERT INTO bor_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nono umode nou ture tugeragu jiwuge ovelha doge emugudo nono tugana pemegareu jagwai. Mare umode nou cabrito doge emugudo nono tugana pegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mare boe eguie ji karega inagoino. Boe eire inagoino. Boe Eimijera Pao Kurireu makomode nou mugure tugana pemegareu jagwaiwugei. Akomode: “Mato. Taremo Pao Kurireu uwaito. Pao Kurireu aidure tai. Tare tagimijerado ema tameartoruwo tu ji dukodire umode nou tameartorure pudui du morido tagai tamuguwo boe pemegareu keje. Ure nou boe pemegareu towuje marigudu. Ukare moto to raga dukeje ure nou boe pemegareu towuje meartorure puduiwuge emuguwo keje toro ia meri keje. ");
INSERT INTO bor_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mare paga karega. Ike boeire i dukeje tare ike maku inai. Pobo boeire i dukeje tare pobo maku inai ikuduwo če. Boe tuginaiwure imi dukeje tare iremo tawaito iwo itamudo. ");
INSERT INTO bor_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ikudau areia bokware dukeje tare ia boe ekudau areia maku inai ikudauče. Ikogodure dukeje taetu pemegare i. Iragojere baičoreu tada dukeje tagaregodure itae tamagowo i tawo ikiarigodu barigu ipiji.” Ainore Pao Kurireu makomode nou mugure tugana pemegareu jagwaiwugei. ");
INSERT INTO bor_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nono nou ro pemegareuge emagomode Pao Kurireuji. Egomode: “Čegimijera. Kočare čerdukare ai ake boeire ai duji dukodire čegare boe eke maku akai. Čerdukare ai pobo boeire ai duji dukodire čegare pobo maku akai akuduwo če. ");
INSERT INTO bor_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Čerdukare ai boe tuginaiwu nure aki duji dukodire čegare aremo čewaito. Čerdukare ai akudau bokware duji dukodire čegare čegudau areia maku akai. ");
INSERT INTO bor_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Čerdukare ai akogodure baičoreu tada duji dukodire čedaregodukare akae čewo akiarigodu barigu apiji.” Ainore nou ro pemegareuge egomode. ");
INSERT INTO bor_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mare Pao Kurireu makomode ei: “Iwo tawie boe remawuji. Meartorure iwugeire tarore awu inagoino jiboeji dukodire inaire taroino. Emeartorure i dukodire iwobere emage. Rakakareuge nure emage marenarue doge nure emage mare du inodu tabo taro pemegare ei dukodire inaire taroino.” Ainore Pao Kurireu makomode nou mugure tugana pemegareu jagwaiwugei. ");
INSERT INTO bor_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mare Pao Kurireu makomode nou mugure tugana pegareu jagwaiwugei. Akomode: “Ipiji! Boe pegamode tai rugadu! Ire joru pegareu towuje bope doge eimijera bariguduwo to, bope doge ewariguduwo to. Nou joru pegareu akedumodukare jii toro rugadu. Ča tawariguduwo to ipiji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mare paga karega. Tardure i ike boeire iduji mare tagare ike maku inai. Pobo boeire i mare tagare pobo maku inai. ");
INSERT INTO bor_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tardure i boe tuginaiwu nure imi duji mare tagare iremo tawaito iwo itamudo. Ikudau areia bokware mare tagare tagudau areia maku inai ikudauče. Ikogodure. Iragojere baičoreu tada. Mare tagaiwokare i taetu pemegakare i.” Ainore Pao Kurireu akomode nou mugure tugana pegareu jagwaiwugei. ");
INSERT INTO bor_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mare egomode: “Čegimijera. Kočare čerdukare ai ake boeire ai duji. Čerdukare ai pobo boeire ai duji. Čerdukare ai boe tuginaiwu nure aki duji. Čerdukare ai akogodure duji. Čerdukare ai baičoreu tada. Dukodire čegare čegera maku akai.” ");
INSERT INTO bor_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mare Pao Kurireu akomode: “Mare imode tawie boe remawuji. Tardure meartorure iwugei rugadu. Eire inagoino. Tagare tagera maku nou meartorure iwuge etai dukodire inagoino tagare tagera maku inai. Ire taroino. Eragakare marenarue doge nure emage mare du inodu tabo iwobere emage dukodire inagoino ire taroino.” ");
INSERT INTO bor_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","– Dukeje čare nou boe ewarigudumode nou bope doge eda kejewu joru pegareuto eragojewo nono jii toro rugadu. Mare nou ro pemegareuge emugumode Pao Kurireu apo rugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus ure tuwadaru akedudo nou boei. Nono čare makore ture jorduwadowugei. ");
INSERT INTO bor_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Akore: – Merimode pobe dukeje boe emode tuwadae Páscoa towuje nono paroiaji. Nono Imedu Onaregedu makudumode boe eimijerage pegareuge etai bitoduwo ipo padure pugajejewu keje. ");
INSERT INTO bor_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Toro nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu rakojere tuwai kurireu tada nouia Judeu doge eimijeragebo. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu iere Caifás. ");
INSERT INTO bor_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ere bato pui nono tuwo tumeardae pegareu tawuje tuwo tugeragu Jesusji tuwo bito. Mare emagore pui tumoduie nou tumeardae biado boe epiji. ");
INSERT INTO bor_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Egore: – Pawadae Páscoa kejere pamodukare pageragu ji. Pamode pageragu ji pawadae keje dukeje boe ekorigodumode pai. Emode bato pui turugoduwo pai. Dukodire pamodukare pageragu ji pawadae keje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nono Jesus uture boe eda Betânia ka. Nonore rakojere Simão uwai tada. Nou Simão iere Biri Pegareu jamedu. ");
INSERT INTO bor_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesus mugure nono nou bai tada ira keje togwage tabo. Nono ia aredu aregodure Jesus ae poari rogu tabo. Nou boe ere nou poari towuje tori tabo. Nou tori iere alabastro. Roreboe mori kurireu meture nou poari rogu tada. Nono ča nou aredu ure nou poari jado. Ure nou roreboe redo Jesus aora joki. ");
INSERT INTO bor_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus ure jorduwadowuge erdure nou aredu roino duji dukeje emago pegare rore jiboeji. Egore: – Kočare ure barigu. ");
INSERT INTO bor_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nou roreboe mori kurire rugadu. Kočare ukare maku diero bagai tuwo diero kurido tuwo maku marenarue doge etai. ");
INSERT INTO bor_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mare Jesus jorduware emagore pui duji. Dukodire makore ei. Akore: – Tagaba awu aredu pogurudo rore i duji. Rore i du moture Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mare paga karega. Marenarue doge edumode tagabo jii toro rugadu. Mare imire itumode tabiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Emarodo ure iwiri udo turugadu ituguduwo mototo iwi keje. ");
INSERT INTO bor_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dukodire imode tawie boe remawuji. Awu aredu rore iboe akedumodukare boe etaora piji jii toro rugadu. Boe etumode moto jamedu boe parugajeje tuwo boe erduwado emeartoruwo i iwo ekinorudo dukeje ereadodumode awu aredu rore iduji boe eiamedu boe ewiagai. Dukodire boe ewiagodumodukare awu aredu piji rugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Nono nou Jesus ure jorduwadowu Judas Iscariotes uture nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etae. Makore ei: – Imode Jesus maku tagai dukeje nuba tamode dierodo inai nou iro moriče? Etaidure Judas bataruji dukodire ere diero prata oto padudo trinta Judas Iscariotes ai uwo Jesus maku pudai. ");
INSERT INTO bor_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Du nou meri pijire nou Judas Iscariotes aiwore Jesus rore jiboeji tuiorduwo tumode maku boe eimijerage pegareuge etaiwu meri bagai. ");
INSERT INTO bor_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Páscoa meri boetojiwu aregodure dukeje Judeu doge ere tuge amireu pemegado nono turo mogadure tuwaduwo Páscoaji. Nou meriji nou Jesus ure jorduwadowuge enarare Jesusji. Egore: – Kaiba čemode page pemegado pawo ko, pawaduwo Páscoaji? ");
INSERT INTO bor_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus akore: – Tadudo toro nou ba kurireu ka. Torore tardumode imeduji. Tamagodo ji tagimijera akoie uwai tadare uie turugadu tuwo tuge ko tuwaduwo Pascoaji ture jorduwadowugebo. ");
INSERT INTO bor_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesus akoino ei dukodire nou ure jorduwadowuge erore nono Jesus mako mogadure. Nono ere tuge pemegado tuwaduwo Pascoaji. ");
INSERT INTO bor_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nou boečoji Jesus mugure nono ira keje togwagewo ture jorduwadowugebo. Nou ure jorduwadowuge eiamedu boe edu nono dukodire enodo padure doze nono Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Enogwagere dukeje Jesus makore ei. Akore: – Iwo tawie boe remawuji. Ia tagi tamode imagu boe eimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ekiarigodure nou Jesus makore pudui duji. Dukodire emagore tugimijeraji tu tu puregodaji. Egore: – I karega akagoino ikimijera? ");
INSERT INTO bor_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus akore: – Nou ure tuge amireu pegodo nou carneiro kuru towu nono itabowu emare umode imagu boe ekimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Marigudu Pao Kurireu ure boe ewie iwimoduie duji. Nou Pao Kurireu bataru padure bapera keje. Aino čare iwimode nou Pao Kurireu meardae koia. Mare boe pegamode rugadu nou ure imagu boe eimijerage pegareuge etaiwuji. Botumodukare dukeje boe pegamodukaie ji. Mare aino čare umode imagu boe ekimijerage pegareuge etai dukodire boe pegamode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas umode Jesus maku rugadu boe eimijerage pegareuge etai rugadu. Nono emare makore Jesusji. Akore: – I karega akagoino ikimijera? Jesus akore: – Uu. Aki rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Čare enogwage kimore. Jesus ure tugeragu amireuji. Imadure Pao Kurireu bagai nou amireu paru tabo. Nono ure nou amireu kado dukeje ure pedo nou ture jorduwadowugei. Akore: – Tagwagedo awuji. Ikodu reo tawiabutuwo iwugeje, irore jiboe keje. ");
INSERT INTO bor_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nono ure tugeragu vinho kuruji jamedu. Imadure Pao Kurireu bagai nou uva kuru paru tabo dukeje ure pedo ei jamedu. Akore: – Tagududo če taiamedu boe. ");
INSERT INTO bor_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ikure nou uva kuru rema. Iku redodumode boe eiamedu boe ero pegareu moriče. Pao Kurireu ure boe ewie marigudu tumoduie turo maiwu maku boe etai tuwo boe ekinorudo. Aino čare iku umode nou Pao Kurireu bataru jetudo pudui rugadu. Nou iku koiare Pao Kurireu biagodumode meartorure puduiwuge ero pegare jiboe piji tuwo ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mare iwo tawie. Ikudumodukare awu vinho kuruče pugeje jii toro itaregodumode mato ibagi pugeje du ka. Itaregodumode pugeje dukeje boe eiamedu boe eimijera kurireu mode imi. Nono ikudumode vinho kuru maiwuče tagabo. ");
INSERT INTO bor_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jesus akoino dukeje urare Pao Kurireu bataru tabo nou ture jorduwadowugebo. Nono ere tudawuje nou ba kurireu piji tuduwo toro Oliveira Ri ao ka. ");
INSERT INTO bor_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nono Jesus makore ture jorduwadowugei pugeje. Akore: – Awu boečoji ro pegareuge emode tugeragu i rugadu. Dukodire taiamedu boe tamode tagera ra ipiji. Pao Kurireu ure boe ewie marigudu. Nou bataru padure bapera keje. Akore: “Pao Kurireu umode nou jeture boeiwu bito. Nono nou boe eiamedu boe emode taodo nou tugimijera piji nono ovelha doge ero mogadure.” ");
INSERT INTO bor_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ainore Pao Kurireu akore marigudu. Ire akoino. Mare iewodumode pugeje dukeje itumode tagododai toro Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mare Pedro makore Jesusji. Akore: – Nou iage emode tugera ra apiji mare imire iromodukare aino. Imodukare ikera ra apiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus akore: – Imode awie boe remawuji. Awu boečoji rugadu akagomode arduwakaie i dumode pobe metia bokware rugadu. Dukeje čare kagariga kudugodumode. ");
INSERT INTO bor_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mare Pedro aidukare Jesus akoino pudui duji. Akore: – Iwimode akabo mare imodukare iwadaru udo nono akago mogadure. Imodukare ikera ra apiji rugadu. Ainore Pedro akore. Nono nouia Jesus ure jorduwadowuge egore nono Pedro ako mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nono Jesus aregodure ture jorduwadowugebo ia iguru jetureu ka. Nou iguru iere Getsêmani. Nono Jesus makore nou ture jorduwadowugei. Akore: – Tamugudo woe. Itumode kuri je. Imagomode baruto Pao Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nono Jesus ure tugeragu Pedroji, Tiagoji, Joãoji tuduwo ebo kuri nono. Dukeje kiarigodu rakare. Jorduware boe pegamode pudui duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nono makore nou ture tugeragu jiwugei. Akore: – Ikiarigodu rakare rugadu. Rakare tuwo iwido rugadu. Ča tadu ruga woe tamagowo baruto Pao Kurireu bagai itabo. ");
INSERT INTO bor_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nono Jesus ure tudaru gu epiji. Nono ure tuie jodo moto ka tumagowo Pao Kurireu bagai baruto. Akore: – Iogwa Kurireu nure aki. Boe ero pegamode idu utudo ipiji. Mare ukawo nono itaidu mogadure. Mare uwo nono akaidu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Čare ure tugirimi nou ture jorduwadowuge ewagai. Mare kočare enudunure. Nono makore Pedroji. Akore: – Amagodo Pao Kurireu bagai itabowu hora uwo mitotu je mare kočare anudure kuri je. ");
INSERT INTO bor_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ameardae pemegare. Mare araga bokware. Aino čare anudukaba pugeje. Amagodo itabo Pao Kurireu bagai baruto bope ukawo tumeardae pegareu maku akai aro pegakawo. ");
INSERT INTO bor_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nono Jesus ure tudaru gu epiji pugeje. Čare makore Pao Kurireu bagai baruto pugeje. Akore: – Iogwa. Boe ero pegamode idu utumodukare ipiji dukeje uwo nono akaidu mogadure. ");
INSERT INTO bor_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nono Jesus ure tugirimi nou ture jorduwadowuge etae pugeje. Jordure ei enudu kimore duji. Norire ekuji dukodire enudure rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dukodire ure tudaru gu epiji pugeje. Makore baruto Pao Kurireu bagai pugeje. Makore nono nou tuwadaru mogadure pugeje. ");
INSERT INTO bor_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dukeje čare ure tugirimi nou ture jorduwadowuge etae pugeje. Nono makore ei. Akore: – Tamugudo. Tanudu kimo nure rugadu kana? Aino čare imagudumode boe eimijerage pegareuge etai kuri aino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ča taragojedo. Pugeje. Paduwo. Nou ure imagu boe eimijerage pegareuge etaiwu aregodu! ");
INSERT INTO bor_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus mako kimore dukeje Judas Iscariotes aregodure. Jesus ure jorduwadowu nure ema rugadu. Mare aino nou Judas Iscariotes aregodure boebo. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nouia boe eimijerage pegareuge ere nou boe etudo toro Jesus bagai dukodire etaregodure rago tabo, tariga kurireu tabo. ");
INSERT INTO bor_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nou Judas Iscariotes makore ei tumoduie Jesus maku etai. Tugimadumoduie Jesus apo, tumoduie togwa to je koduto tuwo boe pegareuge erdudo etaidure tuwo tugeragu jiwu nure ema duji. ");
INSERT INTO bor_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dukodire Judas Iscariotes uture kuri Jesus ae rugadu. Ukimadure apo rugadu. Akore: – Jorduwareu nure aki rugadu. Nono Judas Iscariotes ure togwa to Jesus je koduto. ");
INSERT INTO bor_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus makore ji. Akore: – Me. Arodo akaidure jiboeji rugadu. Nono nouia ime ere tuburedo Jesusji. Nono ere tugeragu Jesusji turaga tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mare ia Jesus ure jorduwadowu ure tugeragu tariga kurireuji. Ure ia imedu bija kado. Nou imedu nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu utugare nure ema. ");
INSERT INTO bor_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mare Jesus akore: – Arokaba aino. Tariga kurireu tugu tuiato pugeje. Boe emode tugeragu tariga kurireuji turugoduwo tabo dukeje ewimode tariga kurireu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tawiapagakare iragaji rugadu. Itaidumode imagowo Iogwa Kurireu bagai dukeje umode tudugarege baru tadawuge enodo padu kejewudo doze mil etuwo mato iwagai emeartoruwo i erowo nono imeardae mogadure. ");
INSERT INTO bor_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mare imagomodukare ewagai. Marigudu Pao Kurireu ure boe ewie tumeardae remawuji iwimoduie. Padure bapera keje. Aino čare nou bataru jetumode pudui rugadu. Dukodire imagomodukare nou baru tadawuge Pao Kurireu utugarege ewagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nono Jesus makore nou ro pegamoduie puduiwuge eiamedu boei. Akore: – Ire boe emeardae pegado kana emeartorukawo tugimijeragei kana? Kočare tagaregodure tariga kurireu tabo rago tabo tawo tageragu i nono taro moga ro pegareuge eidu mogadure. Iragojere tagabo meri jameduji Pao Kurireu uwai tada. Ire boe erduwado nono. Mare tagare tageragu i nono. ");
INSERT INTO bor_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mare aino tagaregodure iwagai woe tarowo i nono tarore ro pegareugei dumogadure. Dujire Pao Kurireu akoino marigudu. Aino ča nou Pao Kurireu makore jiboe jeture pudui. Nou makore Pao Kurireu bataru jiwuge ere nou bataru bu bapera keje marigudu. Jesus akoino dukeje nou ure jorduwadowuge eiamedu boe eregodure piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nou boe ere Jesus reko toro Judeu doge ekimijera kurireu uwai ka. Nou imedu iere Caifás. Ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijera kurireu nure ema. Nouia Judeu doge eimijerage edu nono jamedu. Jorduware Judeu doge eno bakaru jiwuge edu nono jamedu. Boe eimijerage paru towuge edu nono jamedu. ");
INSERT INTO bor_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro kodu jaere boei tudu tabo Jesus rekodaji boe erdukawo pudui. Nono aregodure nou Judeu doge ekimijera kurireu uwai ka. Nou uwai kejere ure tumugudo nono tugobaigaregebo tuiorduwawo nuba boemode Jesusji. ");
INSERT INTO bor_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nou bai ja tadare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage edure. Nou Jerusalém kejewu Judeu doge eimijerage eiamedu boe edure nono jamedu. Eiamedu boe etaiwore ia Jesus ro pegareu bagai. Ewiapagare batrarodureuge ewadaruji taiwo tabo nou Jesus ro pegareu bagai. Etaidure tuwo Jesus bito. ");
INSERT INTO bor_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mare erdukare ia Jesus ro pegareuji. Nou boe egore Jesus ro pegaie. Mare ewadaru kodukare puregodaji. Nono čare imere pobe ere turagojedo tumagowo. ");
INSERT INTO bor_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Egore: – Awu imedu akore tumoduie awu Pao Kurireu uwai kurireu butudo dukeje merimoduie pobe metia bokware tuwo nou bai rakojedo pugeje. ");
INSERT INTO bor_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu ure turagojedo jamedu. Makore Jesusji. Akore: – Amagomodukare nou ewadaru jipagi kana? Boe rugadu ji kana egoino ai rugadu? ");
INSERT INTO bor_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mare Jesus makokare boeji rugadu. Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu unarare ji pugeje. Akore: – Pao Kurireu aiwore pai. Dukodire amagodo boe remawuji čei rugadu. Umode boe ekinorudowu nure aki kana? Pao Kurireu onaregedu nure aki rugadu kana? ");
INSERT INTO bor_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus akore: – Uu. Boe jokodu jire akagoino. Mare iwo tawie Imedu Onaregedu romode jiboeji. Awu inodu otobiji tardumode i imugure Pao Kurireu ukana pemegareu jagwai duji. Tardumode i ire irawuje baru piji boetugu tabo duji. ");
INSERT INTO bor_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Čare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu ure tugudau areia mega bowuje tugorigodure dukodi. Dukodire makore tumedage boe eimijeragei. Akore: – Unure tudo nono Pao Kurireure. Pagare akoino. Mako peganure Pao Kurireuji rugadu. Pawiapagamodukare ia boe emagore jiboeji pugeje. Tameardure ji mako pegare Pao Kurireu jituji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dukodi čare nuba tameardaere? Nuba paromode? Nou boe eimijerage egore: – Mako pegare Pao Kurireuji rugadu. Dukodire čare bitoduwo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nono ere todoguru barigu Jesus je joki. Ere boeto ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Egokodure ji. Egore: – Umode boe ekinorudowu nure aki rugadu kana? Ioguduba ure boeto ai? Amagodo! ");
INSERT INTO bor_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro mugu kimore nono bawadu keje. Nono ia aredu maragodure nou bai tadawu ure tuburedo Pedro ae. Akore: – Aragojere nou Galiléia kejewu Jesus apo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mare Pedro akore turagojekaie apo rugadu nou boe eiamedu boe ewiagai. Akore: – Iorduwakare kaba jiba akagoino. ");
INSERT INTO bor_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dukejere Pedro uture nou bai poro bawadu kejewu ka mare ukare tudawuje. Nonore rakojere rugadu. Dukejere čare ia aredu jordure ji. Makore boei nono. Akore: – Awu imedu rakojere nou Nazaré kejewu imedu Jesus apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mare Pedro akore: – Boe rugadu jire inagoino. Iorduwakare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mare Pedro utukare. Rakojere ji je nono rugadu. Dukejere čare iage ere tuburedo Pedroji pugeje. Egore: – Awadarure nono nou rakojere Jesus apowuge ewadaru mogadure. Dukodire čare boe erduware aragojere Jesus apo duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mare Pedro mako pegare ei tumagomodukaie boe remawuji dukeje Pao Kurireu uiago boe pegado pudui. Akore: – Iorduwakare nou tagagoino jiwu imeduji rugadu. Čare rore puku kagariga kudugodure rugadu duji. ");
INSERT INTO bor_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kodire Pedro biabuture Jesus makore puduiwu tuwadaru keje. Jesus makore Pedroji makomoduie tuiorduwakaie pudui dukeje nou kagariga kudugodumoduie rugadu. Pedro makomoduie tuiorduwakaie Jesusji dumoduie pobe metia bokware rugadu. Aino ča Pedro biabuture nou Jesus bataru keje rugadu jeture pudui duji rugadu. Dukodire uture nou boe epiji rugadu. Ragudure rugadu turore aino duji. ");
INSERT INTO bor_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nou barogwato, barogwakododutabo nou Judeu doge enomea makudure aiwuge eimijerage, nou Judeu doge eimijerage eiamedu boe emagore pui tuwo tumeardae tawuje tuwo Jesus bito rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nono ere Jesus kogudo. Dukejere ere reko nou boe eimijera governador Pilatos bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nou ure Jesus maku boe eimijera pegareuge etaiwu Judas Iscariotes jorduware Jesus bitodumoduie dukeje kiarigodure rugadu. Dukeje čare uture nou Judeu doge eimijerage ewagai pugeje, nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ewagai pugeje tuwo nou diero tori maku tuibagi etai. Ere nou diero tori prata oto padudo trinta Judas Iscariotes ai uwo Jesus maku pudai. ");
INSERT INTO bor_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas Iscariotes akore: – Iro pegare. Ire maku tagaiwu imedu ro pegareu bokware. Mare nou boe eimijerage egore: – Aki rugadu aroino. Čegi karega. ");
INSERT INTO bor_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ča Judas Iscariotes ure nou diero tori rugadu boe barigu nou Pao Kurireu uwai kurireuto. Dukeje čare uture pugeje toro nou ba kurireu piji. Dukeje čare ure tuwido ture bukigu kogudo tugidoru kajeje dutabo. ");
INSERT INTO bor_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nou Pao Kurireu uwai kurireu tadare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere tugeragu nou diero tori kugurei. Egore pui: – Awu diero makudure imedu bitoduwo. Parore jiboe koiare pamodukare awu diero maku Pao Kurireu uwai tadaboe bagai. Pago bakaru jire paromodukare aino. ");
INSERT INTO bor_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dukodire nou boe eimijerage ere tumeardae tawuje puapo tuwo tugeragu ia moto roguji nou diero tabo. Nonore boe tuginaiwuge etugudumode mototo aroe eda keje. ");
INSERT INTO bor_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nou diero makudure Jesus bitoduwo dukodire nou boe ere nou moto iedo. Egore Boe Eku Jeture Kejewu Moto Reo aino ji. Ainore iere jii aino. ");
INSERT INTO bor_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mare paga karega. Marigudu Pao Kurireu ure boe ewie boe eromoduie aino duji. Makore Pao Kurireu bataru jiwu imedu Jeremias ure nou bataru bu bapera keje. Akore: – Israel kejewuge ere tumeardae tawuje puapo tuwo diero prata tori oto padudo trinta nou imedu moriče. ");
INSERT INTO bor_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nono boe ere tugeragu nou dieroji. Ere nou diero maku ia maragodure rotu jiwu imedu ai tuwo tugeragu ia moto roguji. Mare paga karega emeartoruwo Pao Kurireu makore jiboeji. Ainore nou padure bapera kejewu Pao Kurireu bataru akore rugadu. Jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Toro nou boe eimijera governador uwai kejere Jesus rakojere nou boe eimijera kurireu Pilatos jokorai. Unarare Jesusji. Akore: – Boe rugadu kana? Judeu doge eimijera kurireu nure aki rugadu? Jesus akore: – Uu. Boe jokodu jire akagoino. ");
INSERT INTO bor_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mare nouia boe eimijerage, nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emago pegare Jesus rore jiboeji makore jiboeji nou Pilatos biagai. Mare Jesus makokare boeji tubaru tabo ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dukodire čare Pilatos unarare Jesusji pugeje. Akore: – Ameardu kana nou boe emago pegare ai duji rugadu? ");
INSERT INTO bor_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mare Jesus makokare boeji pugeje. Dukodire nou Pilatos joku kidure Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Judeu doge ewadae Páscoa kejere Pilatos ure ia ro pegareu tawuje baičoreu piji Judeu doge eroiaji. Judeu doge emagomode ia ro pegareu ieji dukeje Pilatos umode nou ro pegareu tawuje baičoreu piji utuwo pugeje joru jameduji. ");
INSERT INTO bor_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ča awu joruji ia boe erduware jiwu ro pegareu imedu rakojere baičoreu tada. Iere Barrabás. Boe eiamedu boe erduware ji rugadu. Ro pegareu remawu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nono nou boe emagare ture bato pui dutabo Pilatos ae. Dukejere Pilatos unarare ei. Akore: – Ioguduba jiba tagaidure iwo tawuje baičoreu piji awu joruji utuwo pugeje? Tagaidu kana Barrabaji utuwo pugeje kana? Tagaidu kana awu boe egoino umode boe ekinorudowu Jesusji kana utuwo pugeje? ");
INSERT INTO bor_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatos akoino tuwo Jesus utudo pugeje rugadu. Jorduware nou Judeu doge eimijerage emeardae pegare Jesus jituji. Etaidure boe emeartoruwo tu pudui rugadu. Dukodire etaregodure Jesus apo Pilatos ae boe emeartorukawo Jesusji pugeje. ");
INSERT INTO bor_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ča Pilatos mugure nou taiwore boe ero pegareu bagaiwu ira keje. Dukeje čare oreduje bataru makudure ai nono. Akore: – Akera ra nou imedu piji. Ro pegareu bokware rugadu. Iniau pegare ji awu boečoji dukodire ipagudure če. Ainore nou Pilatos oreduje makore nou toredu bagai. ");
INSERT INTO bor_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mare nou Judeu doge eimijerage, nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere boe ero jodo nono Pilatos jokorai. Dukodire nou boe emagore Pilatoji uwo ro pegareu imedu Barrabás tawuje baičoreu piji utuwo pugeje. Mare uwo Jesus bito rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatos unarare ei pugeje. Akore: – Ioguduba imode tawuje baičoreu piji utuwo pugeje? Egore: – Barrabás tawujeduiago rugadu! ");
INSERT INTO bor_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dukeje čare Pilatos unarare pugeje. Akore: – Nuba iromode awu boe egoino umode boe ekinorudowu Jesusji? Nou boe eiamedu boe egore: – Bito ipo padure pugajejewu keje rugadu! ");
INSERT INTO bor_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatos akore: – Kodiba tagagoino? Ro pegareu pa? Mare ewiapagakare ji. Ere tugudu rakado. Egore: – Bito ipo padure pugajejewu keje rugadu! ");
INSERT INTO bor_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ča Pilatos jorduware nou boe ekorigodure rugadu tugaie ewudugugo kodi. Dukeje čare ure tugeragu poboji. Ure tugera kabi nou boe egai. Akore: – Ča. Imi karega imode awu imedu ku redo. Tagire taromode aino rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nou boe eiamedu boe egore: – Uu! Čeigoia rugadu čemode ku redo rugadu dukodire čegire čemode morido, čedore emode morido jamedu. ");
INSERT INTO bor_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dukodire čare Pilatos ure Barrabás tawuje baičoreu piji utuwo pugeje. Mare ure tugobaigarege edo boeto Jesusji bukigu tabo. Nono ure maku etai ewo Jesus bito ipo padure pugajejewu keje. ");
INSERT INTO bor_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tugobaigarege ere tugeragu Jesusji. Ere turemo apo nou tugimijera Pilatos uwaito. Nono emagore nouia tugobaigarege ewagai. Ere bato pui nono Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Čare ere Jesus ukudau areia tawuje piji. Nono ere ia boe eimijera kurireu ukudau areia motureu kujagureu tugu Jesusji. ");
INSERT INTO bor_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ere ia boe eimijera kurireu atadawu towuje. Ere nou atadawudo botoguruče. Dukejere ere tugu Jesus aoto atadawuwo ema. Ere Jesus iedudo ia ipoji tugana pemegareu tabo. Dukejere čare ere tubu jodo Jesus jokorai tuwadarukeadae pegareu tabo. Egore: – Judeu doge eimijera kurireu nure aki. Boe pemegawo ai rugadu. Mare pagare egoino. Emeartorukare Jesusji dukodi rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dukodire ere todoguru barigu ji. Ere tugeragu nou ipoji piji dutabore ere boeto ji nou ipo tabo rugadu. Ere boeto boeto aoraji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ere tumago pegado ji pugeje. Dukejere čare ere nou boe eimijera kurireu ukudau areia motureu tawuje Jesus piji. Ere Jesus ukudau areia tugu ji pugeje. Nono ere tugeragu Jesusji tuduwo apo Jerusalém piji tuwo bito ipo padure pugajejewu keje rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eture Jesus apo rugadu. Ekodure dukeje erdure ia imeduji. Iere Simão. Cirene ba kurireu pijiwu nure ema. Ča nou tugobaigarege ere tugeragu nou Simãoji oreduwo nou Jesus bitodumode kejewu ipo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nono eture Jesus apo toro ia tori ri ao ka. Ewadaru tabo nou tori iere Gólgota. Nou Gólgota ewadaru tabo iere: “Boe ewireuge etaora ra jeta reo”, aino. ");
INSERT INTO bor_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ere ia jorubo barigu vinho kuruto. Nou jorubo iere mirra. Nono ere nou vinho kuru maku Jesus ai kuduwo če. Mare Jesus ure togwa pagado ji dukodire aidukare tuguduwo če. ");
INSERT INTO bor_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nono tugobaigarege ere Jesus bu ipo padure pugajejewu keje. Ere Jesus ukudau areia pedo pui. Ere tuwadumode tabowu tori rogu barigu tuiorduwawo duboba umode tugeragu Jesus ukudau areiaji. ");
INSERT INTO bor_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dukejere čare ere tumugudo nono taiwo tabo Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ere atugoreboe bu ipo keje Jesus aora bukajeje. Egore: – Judeu doge eimijera kurireu reo. Iere Jesus. ");
INSERT INTO bor_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ere ia ro pegareuge ime pobedu doge emugudo nono Jesus apo jamedu nou meriji. Ia rakojere Jesus kana pemegareu jagwai. Metia rakojere Jesus kana pegareu jagwai jamedu. ");
INSERT INTO bor_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Boe etaregodure nono dukeje ere taora paradudo. Emago pegare Jesusji. ");
INSERT INTO bor_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Egore: – Akagore amoduie Pao Kurireu uwai butudo mare merimoduie pobe metia bokware dukeje amoduie rakojedo pugeje. Ča Pao Kurireu onaregedu mode aki dukeje amode arawuje nou ipo piji awo akinorudo. ");
INSERT INTO bor_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge, nouia Judeu doge eimijerage eiamedu boe edu nono tumago pega tabo Jesusji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Egore: – Ure boe ekinorudo mare kočare roiwakare tuwo tuginorudo rugadu! Judeu doge eimijera kurireu karegure ema kana? Umode turawuje nou ipo padure pugajejewu piji dukeje čemeartorumode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kočare awu Jesus meartoruie Pao Kurireuji. Akore Pao Kurireu onaregedu nuie pudumi. Mare pagare akoino. Aino Pao Kurireu umodukare udo činorudo rugadu. Ainore nou boe eimijerage eiamedu boe egore tumago pega tabo ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nou rakojere Jesus apowuge ro pegareuge pobedu doge emago pegare Jesusji jamedu. ");
INSERT INTO bor_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Meri aregodure pagaia ka dukeje boečodure moto jamedu boe parugajeje. Boečodure rugadu. Nou boečo kodure kuri toro nou três hora ka. ");
INSERT INTO bor_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dukeje čare Jesus makore tugudu tabo nou boe ewadaru tabo. Akore: – Eli, Eli lemá sabactani? Boe ewadaru tabore akore: – Pao Kurireu, Pao Kurireu! Kaba kodiba are akera ra ipiji? – Dujire akoino tuwadaru tabo. ");
INSERT INTO bor_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ia boe emeardure nou Jesus bataruji dukeje egore: – Tawiapagado. Jesus kudugodure Elias bagai. ");
INSERT INTO bor_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ia imedu rekodure ia esponja tabo. Ure nou esponja pegodo vinho kuru tabo. Nono aregodure tabo Jesus ae. Ure nou esponja kogudo ipo oto tabo. Nono ure nou esponja raido nou ipo tabo toro Jesus okwa ka kuduwo če. ");
INSERT INTO bor_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nou iage egore: – Ča parokawo iaboeji pugeje. Pabagawo Elias bagai. Aregodumode rugadu kana? Umode Jesus rawuje nou ipo padure pugajejewu piji kana? ");
INSERT INTO bor_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nono Jesus kudugodu rakare dukeje bire. ");
INSERT INTO bor_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Čare rore puku je nou areia kurireu bararere Pao Kurireu uwai ja tadawu ure tuwowuje nou bai ja oto piji moto ka. Moto magadugodure. Nou tori boe ere tuwowuje. ");
INSERT INTO bor_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bireuge eiari ere tuiado jamedu. Nono meartorure Pao Kurireu jiwuge bireuge eewodure pugeje. Emagare rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ere tudawuje nou etugudure towu tori poro boe piji. Jesus jewodumode pugeje dukeje nou jewodureuge etumode nou Jerusalém ba kurireuto. Israel doge emuga kurireu reo. Nonore boe erdure nou jewodureugei rugadu. Jordure eiwuge emagare nou ba kurireu keje. ");
INSERT INTO bor_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mare aino nou Romano doge tugobaigarege eimijera jordure moto magadugodure duji. Nou tugobaigarege erdure jamedu. Eiamedu boe erdure nou inodu boeji. Dukodire epagudugodure rugadu. Egore: – Boe rugadu! Awu imedu nure Pao Kurireu onaregeduče rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Areme eragojere nono jamedu. Emagare. Iarodo iere Maria Madalena. Ia etumedago iere Maria jamedu. Nou Maria ore ime ere pobe. Ia iere Tiago. Umana iere José. Zebedeu ore etuje rakojere nono jamedu. Jesus rakoje kimore Galiléia moto keje dutabo nou areme emeartorure ji. Ekodure Jesus apo tu tu je tietu pemegawo Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Merirekodugodutabo José aregodure. Arimatéia ba kurireu pijiwu nure ema. Oe kurireu nure ema. Meartorure Jesusji jamedu. Nou José uture boe eimijera Pilatos bagai tumagowo ji bireu Jesus bagai tuwo Jesus tugu mototo. Nono Pilatos makore tugobaigaregei ewo Jesus bireu maku nou José ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dukodire čare José ure tugeragu bireu Jesusji. Ure upodo areia pemegareu tabo. ");
INSERT INTO bor_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nono ure Jesus tugu to tori poro maiwuto. Emare ure nou tori porodo aino maigodu. Dukeje ure tuiodo nouia tori kurireu keje tuwo bu nou tori poro je keje tuwo nou tori poro midu pemegado. ");
INSERT INTO bor_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nou Maria Madalena, nou iarodo Maria ere tudaru nou tori poro ka tumugu pureduwo nou tori poroji taiwo tabo nou José roino duji. ");
INSERT INTO bor_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nou barogwato nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage eture Pilatos bagai ia fariseu dogebo. Sábado meri kejere eroino. ");
INSERT INTO bor_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Emagore Pilatoji. Egore: – Čegimijera. Čewiabuture nou Jesus bataru keje. Akore merimoduie pobe metia bokware pudui dukeje tuiewodumoduie pugeje. Tuwo boe ekiripagado dubagaire nou Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dukodire čedaidure čewo čemeardae maku akai. Ukana turugadu awo ia tugobaigarege etu pemegado nou bireu meture tadawu tori poroji jii nou akoino jiwu meri akedumode du ka? Amodukare tugobaigarege etudo toro dukeje ia ure jorduwadowuge etumode toro nou tori poro ka. Emode bireu tawuje nou tori poro piji. Nono ewadrarodumode boe ewiagai jewoduie pugeje duji. Dutabore emode boe ekiripaga kurido nou Jesus makore jiboe kori. ");
INSERT INTO bor_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nono Pilatos akore: – Ča. Tadudo awu tugobaigaregebo taetu pemegawo nou bireu meture tadawu tori poroji nono tameardae umogadure. ");
INSERT INTO bor_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dukodi ča eture rugadu. Ere iaboe bu nou tori okwaji boe erduwawo tawujedukare nou tori poro piji rugadu. Nono ere nou tugobaigarege emugudo nono etaiwo pemegawo nou tori poroji rugadu boe ekawo tugeragu nou bireuji nou tori poro piji. ");
INSERT INTO bor_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nou Sábado meri akedure dukeje nou barogwato kuri ča je Maria Madalena uture nou Maria apo toro nou Jesus meture tadawu tori poro ka taiwowo ji. ");
INSERT INTO bor_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ča moto magadugodu rakare rugadu. Mare ia Pao Kurireu utugare baru tadawu ure turawuje baru piji. Aregodure nou tori poro ka rugadu. Dukeje ča ure tuiodo nou padure nou tori poro je kejewu tori kurireu keje tuwo nou tori poro jado. Dukeje ča ure tumugudo nou tori keje. ");
INSERT INTO bor_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ukudau areia kigadure rugadu. Ure nono boeiaragudu mogadure boe etaiwo tabo ji. ");
INSERT INTO bor_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dukodire čare nou tugobaigarege epagudugodure če rugadu. Dukodire epogora kugudugodure rugadu. Ere nono bireuge emogadure. Mare ewi ji karega inagoino. Erokare iaboeji iaboeji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ča nono nou baru pijiwu Pao Kurireu utugare makore nou aremei. Akore: – Tabagudukaba. Iorduware tagaiwore bagaiwu boeji. Tagaiwore bitodureu Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ča rakojekare woe pugeje. Jewodure pugeje. Makore jiwu bataru jeture pudui rugadu. Mato tagaiwowo padureu ka. ");
INSERT INTO bor_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tadumode dukeje tadudo tamara tabo tawo ure jorduwadowuge ewie jewodure pugeje duji. Ewie utumoduie tagododai toro Galiléia moto ka. Toroie tardumoduie pudui. Ča inure tawie aino. ");
INSERT INTO bor_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dukodire nou areme eture nou tori poro piji tumara tabo rugadu. Epagudure. Mare egarere pudui jamedu. Eregodu rakare toro nou Jesus ure jorduwadowuge ewagai. ");
INSERT INTO bor_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mare erore puku je Jesus ure tuie bu tači etae. Akore: – Itaregodu. Ere tuburedo ji. Nono ere tubu jodo jokorai. Ere tugeragu bureji. Emago pemegare ji. ");
INSERT INTO bor_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nono Jesus makore ei. Akore: – Tabagudukaba. Tadudo toro ire jorduwadowuge ewagai. Aino ere nono imedage remawuge emogadure. Tamagodo ei etuwo toro Galiléia moto ka. Nonore erdumode i rugadu. ");
INSERT INTO bor_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ča nou areme eture rugadu. Mare ča nou tugobaigarege eture jamedu toro ba kurireu ka tureadoduwo nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ewiagai nou boe jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nono ča nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere bato pui nouia boe eimijeragebo tuwo tumeardae tawuje. Dukodire ere tumeardae maku puai tuwo diero kurireu maku nou tugobaigarege etai. ");
INSERT INTO bor_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ere nou diero maku nou tugobaigarege etai tumagore ei dutabo. Egore: – Tawadrarodumode boe eiamedu boei tanuduie nou boečoji dukejeie ure jorduwadowuge etaregoduie nou tori poro ka. Emageie ere tugeragu nou bireuji nou tori poro piji. ");
INSERT INTO bor_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nou tagimijera Pilatos meardumode nou tawadrarodaeji dukeje korigodumode tai tanudure duji. Mare tamororamagadukaba. Čegi čemode butugugo boe pegakawo tai. ");
INSERT INTO bor_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dukodire čare nou tugobaigarege ere tugeragu nou dieroji rugadu. Dukeje ewadrarodure nono nou boe eimijerage egore pudui dumogadure. Dukodire nou ewadrarodae ure tumaedo nou Judeu doge ekao jii aino. ");
INSERT INTO bor_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aino ča nou Jesus ure jorduwadowuge enodo padure onze. Nono ča eture Galiléia moto ka rugadu. Dukeje čare etaregodure nou Jesus makore jiwu tori ao ka. ");
INSERT INTO bor_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Etaregodure dukeje erdure Jesusji rugadu. Ere tubu jodo moto keje tumago pemegawo ji. Mare iage erduwa jokodukare ure ema duji. ");
INSERT INTO bor_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dukeje čare Jesus ure tuburedo ei. Nono akore: – Pao Kurireu ure baru tadawu raka jamedu boe maku inai. Ure moto kejewu raka jamedu boe maku inai. ");
INSERT INTO bor_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dukodire imode tawie. Tadudo boe eiamedu boe ewagai moto jamedu boe parugajeje tamago raiwo boei emeartoruwo i ewo tugimijerado imi. Emeartorumode i dukeje etao pegodo jamedu Pao Kurireu ie tabo, Onaregedu ie tabo, Uwari ie tabo jamedu. ");
INSERT INTO bor_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Erduwado ire maku tagaiwu taro jamedu boeji emeartoruwo ji jamedu. Mare tawiagodukaba. Iragojemode tagabo meri jameduji rugadu jii toro moto akedumode du ka.");
INSERT INTO bor_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pao Kurireu o bakaru pemegareu reo. Jesus Cristo jire Pao Kurireu akoino. Onaregedu nure ema. ");
INSERT INTO bor_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Marigudu rugadu imedu Isaías ure Pao Kurireu bataru bu bapera keje. Ainore nou bataru akore: – Imode itugare utudo uwo boe pemegado nou umode boe ekinorudowu togi. – Itugare kudugodumode boe ewagai boe maereu keje boe ewo awara jetorodo boe eimijera kurireu aregodumode boe etae duji. Mare awara ji karega inagoino. Boe ewo turo pemegado. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nou Pao Kurireu makore jiboe jeture pudui rugadu. João Batista jirabodu Pao Kurireu akoino. Pao Kurireu utugare nure ema. Aregodure boe maereu ka. Makore Pao Kurireu bataruji boe ewiagai. Ure boe etao pegodo. Akore: – Tagera ra taro pegareu piji dukeje imode tagao pegodo. Nono Pao Kurireu biagodumode taro pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Boe eture João ae. Emagare tudu tabo toro ae. Etaregodure Judéia moto piji. Etaregodure Jerusalém ba kurireu piji jamedu. Emeardure João Batista bataruji dukeje emagore turo pegareuji, taiduie tuwo tugera ra nou turo pegareu piji. Nono João Batista ure etao pegodo Jordão Po tada. ");
INSERT INTO bor_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João Batista ukudaure camelo buče. Pegajejewure tapira biri rema. Okwagere tu kitariga dogei, ropa doge eweguruji tu rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Nono ure boe ewie Pao Kurireu bataruji. Akore: – Ia imedu ro kodumode ikoriwu aregodumode iregodaji. Boe pemegareu nure ema, boe kurireu mode ema rugadu. Dukodire ipogurumode ipureduwo ji iro rakakare kodi. Imire ire boe etao pegodo pobo tabo. Emare umode Tuwari tugu boe emeardaeto boe ero pemegawo. ");
INSERT INTO bor_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ia meri keje Jesus uture tuwai piji Nazaré ba kurireu piji toro Galiléia moto ka. Nono aregodure João Batista ae toro Jordão Po ka. Nonore João ure Jesus ao pegodo Jordão Po tada. ");
INSERT INTO bor_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nono Jesus ure tudawuje Jordão Po piji dukeje aiwore baruto. Nono barure tuiado dukeje Pao Kurireu Uwari ure turawuje baru piji. Ure tudo nono metugore. Ure tumugudo Jesus keje. ");
INSERT INTO bor_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nono Pao Kurireu makore baru piji. Akore: – Itonaregedu nure aki. Imeardu kurire ai rugadu. Are iagaredo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dukeje Pao Kurireu Uwari ure Jesus utudo toro boe maereu ka. ");
INSERT INTO bor_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Meri oto padure quarenta Jesusji nono. Bope doge eimijera Satanás aregodure ae nono. Aidure tuwo turokogado Jesusji tuwo Jesus meardae pegado nono tumeardae mogadure. Barege pegareuge emagare nono Jesus apo. Mare Pao Kurireu utugarege baru tadawuge etaregodure ae. Etu pemegare Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Boe eimijera pegareu ure João Batista tugu baičoreuto. Jesus uture Galiléia moto ka. Nonore makore Pao Kurireu bataru pemegareuji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akore: – Kuri aino Pao Kurireu umode boe eimijera kurireudo imi rugadu. Ča tagera ra taro pegareu piji. Tameartorudo Pao Kurireu bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus merure pobo maereu okwaji. Nou pobo maereu iere Galiléia. Nono Jesus jordure imei. Ere pobe. Ia iere Simão. Uwie iere André. Ewogure tuwuge tabo. Ere kare ewido. ");
INSERT INTO bor_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus makore etae. Akore: – Mato tagoduwo itabo. Imode tarduwado tawoguwo ime ewagai. Mare tawogu ji karega inagoino. Tamode boe emeartorudo Pao Kurireuji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nono ere tugera ra tuwogu piji tači je. Eture Jesus apo rugadu tumaragodae piji. ");
INSERT INTO bor_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesus kodure nou pobo maereu okwaji kimo. Nono jordure ia imei. Ere pobe. Ia iere Tiago. Nou uwie imedu iere João. Etuo iere Zebedeu. Eragojere to ika kurireu tada. Emaragodure tuwugeji tuwo pemegado. ");
INSERT INTO bor_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus jordure ei dukeje makore etae. Dukodire eture tuo piji, to ika kurireu piji, tudugarege epiji tugoduwo Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus aregodure Cafarnaum ba kurireu ka ture jorduwadowuge ebo. Sábado meri keje Jesus uture nou Judeu doge ere bato puiwu bai ka. Nonore ure boe erduwado. ");
INSERT INTO bor_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Boe emeardure Jesus bataruji dukeje nono eiamedu boe eku kidure rugadu nou Jesus makore jiboeji. Jesus makore jiboe ukare nono nou boe eimijerage jorduware Judeu doge eno bakaru jiwuge ewadaru mogadure. Jesus mako pemegare mako jetorore rugadu dukodire boe erduware Pao Kurireu bataru remawu jire Jesus akoino duji. ");
INSERT INTO bor_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nono ia bope meture tadawu imedu kudugodure. Nou bope uwari emare akoino. ");
INSERT INTO bor_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Akore: – Nazaré pijiwu Jesus nure aki rugadu. Nuba aromode čei? Amode čedagedudo na? Čerduware ai. Aro pega bokware. Pao Kurireu ure akarego mato tuwadaru pemegareu tabo boe ewagai rugadu! ");
INSERT INTO bor_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nono Jesus makore nou bope bataru jipagi. Akore: – Amagokaba boeji pugeje. Atawuje awu imedu piji. ");
INSERT INTO bor_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nou bope uwari ure nou imedu magadudo ure kudugodudo jamedu. Dukejere ure tudawuje nou imedu piji. ");
INSERT INTO bor_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Boe erore ta je Jesus rore aino duji. Dukodire emagore pui. Egore: – Nuba awu Jesus rore? Ure nou bope uwari utudo tači awu imedu piji. Nou bope meartorure awu Jesus bataruji. Marigudu čerduwakare čerowo aino. ");
INSERT INTO bor_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dukodire boe ere nou Galiléia moto kejewuge boe eiamedu boe ewie Jesus rore jiboeji makore jiboeji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus uture nou Judeu doge ere bato puiwu bai piji. Uture nou ture jorduwadowugebo. Tiago uture apo. João uture apo jamedu. Eture Simão, André ewai ka. ");
INSERT INTO bor_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simão učarugo kogodure. Biri urure. Padure nono tuba keje. Jesus aregodure dukeje boe ere bie. ");
INSERT INTO bor_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dukodire uture ae. Ure tugeragu ieraji. Ure rakojedo dukeje nou biri uru akedure tači je. Pemegagodure pugeje. Dukodire ure eke pemegado. ");
INSERT INTO bor_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Boečoji boe etaregodure Jesus ae kogodureugebo, bope doge emedure tadawugebo jamedu. ");
INSERT INTO bor_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nou mugure ba kurireu kejewuge eiamedu boe etaregodure Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus ure nou kogodureuge epemegago. Ure bope doge etawuje boe epiji tuwo etudo epiji rugadu. Nou bope doge erduware Jesusji dukodire Jesus ure nou bope doge emago bokwado. ");
INSERT INTO bor_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nou barogwato boedugu kimoto Jesus ure tudawuje. Uture nou bai piji. Uture nou ba kurireu piji toro ia boe maereu ka tumagowo Tuo bagai baruto. ");
INSERT INTO bor_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nono Simão uture tumedagebo tiemaru tabo bagai. ");
INSERT INTO bor_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nono erdure ji dukeje egore: – Boe emarure awagai tumearduwo awadaruji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mare Jesus makore ei. Akore: – Emeardure iwadaruji marigudu dukodire padumode ia boe etae pugeje. Imagomode Iogwa Kurireu bataruji ewiagai jamedu. Dukodire itaregodure baru piji. ");
INSERT INTO bor_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dukodire uture Galiléia moto jamedu boe parugajeje tumagowo Tuo bataruji boe ewiagai. Makore boei ere bato puiwu bai tada. Ure bope doge etawuje boe epiji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ia imedu kogodureu aregodure Jesus ae pugeje. Nou kogodae ure biri pegado rugadu. Aregodure Jesus ae dukeje ure tubu jodo moto keje jokorai. Okwamagudure Jesusji uwo tugera maku pudai rugadu. Akore: – Aragare rugadu awo ipemegago. Mare akaidumode dukeje amode ipemegago. ");
INSERT INTO bor_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus okudugodure apo. Dukodire ure tugera bu nou imedu keje. Akore: – Uu. Itaidure. Ča. Apemegare rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nono nou imedu biri pemegagodure tači je rugadu. ");
INSERT INTO bor_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nono Jesus ure tumago rakado ji ukawo boe ewie nou turore jiboeji. Akore: – Amagokaba awu irore jiboeji boe ewiagai. Atudo kuri nou Pao Kurireu uwai ka. Nonore amode nou ure Judeu doge enomea maku Pao Kurireu aiwu imedu jordudo awiriji. Jordumode awiri pemegagodure duji rugadu. Nono amode nou Moisés makore jiwu mori maku ai rugadu nono paro mogadure. Nono nou ure boe enomea maku Pao Kurireu aiwu imedu umode nou are maku pudaiwu mori maku Pao Kurireu ai rugadu. Dukodire boe eiamedu boe erduwamode apemegagodure duji. Jesus makore aino tuwo nou imedu utudo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nou imedu uture mare meartorukare Jesus makore pudui jiboeji. Makore boe eiamedu boe ewiagai nuba Jesus rore pudui duji. Nono boe eiamedu boe etaidure tumagowo Jesusji. Dukodire Jesus roiwakare tuduwo boe eda ka. Rakojere boe maereu keje. Mare nou moto kejewu boe emarure Jesus bagai tuiorduwo ji. ");
INSERT INTO bor_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ia meri keje Jesus uture tuibagi Cafarnaum ba kurireu ka. Aregodure dukeje boe ere pu rugadu boe bie aregodure duji. ");
INSERT INTO bor_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dukodire boe eture nou Jesus rakojere tadawu bai ka. Emagare. Emagare rugadu. Ere turemo nou baito mare nou bai čekare nou boe dogei. Dukodire iage edure bawadu keje. Jesus makore Pao Kurireu bataruji ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nono ia ime etaregodure. Enodo padure pobe puibiji. Enoredure ia imedu pogora pegareu apo. Etaidure taregoduwo apo Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mare boe emagare nono Jesus apo dukodire eroiwakare tubureduwo Jesusji. Dukodire erudure nou bai ao ka nou imedu pogora pegareu apo. Nono ere nou bai ao porodo. Dukejere ere nou imedu pogora pegareu rawuje nou bai ao piji moto ka bukigu tabo. Nou imedu padure kodo keje. Ere bukigu kogudo nou imedu padure kejewu kodo tabo. Dutabore ere rawuje moto ka Jesus jokora ka. ");
INSERT INTO bor_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus jordure emeartorure pudui duji kodire etaregodure aino nou imedu apo pudae duji. Dukodire makore nou imedu pogora pegareuji. Akore: – Me. Ire aro pegareu jamedu boe barigu apiji dukodire Pao Kurireu biagodumode aro pegare jiboe piji. ");
INSERT INTO bor_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jorduware Judeu doge eno bakaru jiwuge edure nono nou boe dogebo. Ewiapagare Jesus bataruji dukeje emeardaere tudada. ");
INSERT INTO bor_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Egore: – Awu Jesus makore jiboe ukare turugadu. Unure tudo nono Pao Kurireure. Mare pagare akoino. Dukodire mako peganure Pao Kurireuji. Tu Pao Kurireu umode boe ero pegareu barigu boe epiji tuwiagoduwo ero pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus jorduware emeardaere jiboeji. Dukodire makore ei. Akore: – Kočare tameardae pegare imagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Boe jokodu. Boe emodukare boe ero pegareu barigu epiji rugadu. Mare boe emodukare awu imedu pogora pegareu pemegago jamedu. Emodukare pemegago rugadu. Tu Pao Kurireu umode pemegago. Tu Pao Kurireu umode boe ero pegareu barigu boe epiji tuwiagoduwo ero pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dukodire imode awu imedu pogora pegareu pemegago dukeje tarduwamode Imedu Onaregedu nure imi duji. Dukodire imode tarduwado iragare iwo boe ero pegareu barigu epiji duji ewarigudukawo bope doge eda kejewu joru pegareuto rugadu. Ainore Jesus akore nou boe eimijeragei. Nono Jesus makore nou imedu pogora pegareuji. ");
INSERT INTO bor_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Akore: – Me. Aragojedo. Akeragu akudau kodoji atuwo tabo aibagi awai ka. ");
INSERT INTO bor_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Boe etaiwore nou imedu pogora pegareuji. Ča ure turagojedo rugadu. Ure tugeragu tugudau kodoji. Dukejere uture tabo pugeje. Meru pegakare. Boe eiamedu boe eku kidugodure nou rore aino duji. Dukodire emago pemegare Pao Kurireuji. Egore: – Marigudu čerdukare awu inoduji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus uture tuibagi pobo maereu okwa ka. Nou pobo maereu iere Galiléia. Nou boe etaregodure nono ae pugeje. Emagare. Dukejere Jesus ure erduwado Pao Kurireu bataruji. ");
INSERT INTO bor_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Merure pobo okwaji dukeje jordure imposto diero makudure aiwu imeduji. Nou imedu iere Levi. Alfeu onaregedu nure ema. Mugure nono ira keje. Nonore ure tugeragu dieroji boe epiji enoe imposto moriče tuwo maku boe eimijera kurireu ai. Nou imedu maragodae nure nou inoduče. Jesus makore ji. Akore: – Ako itabo. Ča Levi ure turagojedo. Uture Jesus apo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nou boečoji eragojere Levi uwai tada togwagewo. Jesus ure jorduwadowuge edure nono jamedu. Ia kodure Jesus apowuge emagare nono. Nou imposto mori makudure aiwuge edure nono jamedu. Boe egore ro pegareuge enuie emage. Ia boe etaidukare jiwuge eragojere nono Jesus apo jamedu. Nou boe eiamedu boe emugure nono togwage tabo Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dukejere ia fariseu doge etaregodure jamedu. Jorduware Judeu doge eno bakaru jiwuge nure emage. Erdure Jesus okwagere nou ro pegareugebo duji. Etaidukare nou ro pegareugei dukodire emagore nou Jesus ure jorduwadowugei. Egore: – Kočare Jesus okwagere awu ro pegareugebo? Ukare turugadu! ");
INSERT INTO bor_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus meardure nou fariseu doge egoino duji. Dukodire makore ei. Akore: – Jorubo kuru epa jemarumodukare kogodukareuge ewagai. Mare kogodureuge ewagaire jemarumode tuwo epemegago. Irore nono nou jorubo kuru epa ro mogadure. Mare jorubo kuru epa ji karega inagoino. Itaregodure woe mare ro pemegareuge ewagai karega iroino. Ro pegareuge ewagaire iroino ewo tugera ra turo pegareu piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ia meri keje aidure João Batista bataru jiwuge enogwage bokware tumagowo Pao Kurireu bagai baruto nou meriji. Ainore Fariseu doge erore jamedu. Ia boe etaregodure Jesus ae dukeje enarare ji. Egore: – João Batista ure jorduwadowuge enogwagekare awu meriji tumagowo Pao Kurireu bagai baruto awu meriji. Fariseu doge ere jorduwadowuge erore aino awu meriji jamedu. Kodiba are jorduwadowuge enogwagekare tumagowo Pao Kurireu bagai baruto awu meriji? ");
INSERT INTO bor_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus akore: – Ire nono uwiremodewu imedu mogadure. Mare uwiremodewu karega. Boe etuwirere dukeje ere tuwadae towuje. Nou ewadae kejere boe enogwagemode rugadu. Ewadae reno. Ekiarigodumodukare nou meriji. ");
INSERT INTO bor_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mare ewadae akedure dukeje uwirereu imedu utumode epiji toreduje apo. Dukejere čare boe emode ia meri tawuje togwagekawo nou meriji tumagowo Pao Kurireu bagai baruto nou meriji. Ire nono nou uwiremodewu imedu mogadure. Mare uwiremodewu imedu ji karega inagoino. Ire inagoino. Ire irawuje baru piji mato boe ewagai. Mare ia meri keje itumode nou boe epiji baruto dukeje boe emode nou meri tawuje togwagekawo nou meriji tumagowo Pao Kurireu bagai baruto nou meri keje. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Boe ekudau areia pegagodureu umode tuwowuje. Mare boe emodukare tugudau areia maiwu kado tuwo nou tugudau pegagodureu poro miwuje tabo. Boe eromode aino dukeje nou ekudau areia maiwu gigirimode. Dukodire umode tuwowuje nou boe ekudau areia pegagodureu piji kuri je pugeje. Dukodire nou ekudau areia pegagodureu umode tuwowuje ja je. Nono nou poro kodumode tugori. ");
INSERT INTO bor_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Boe ere tapira biri maiwu pemegado nou tuge vinho kuru maiwu jače. Mare emode vinho kuru maiwu tugu tapira biri čodureuto dukeje nou tapira biri čodureu umode tuwowuje. Nono nou vinho kuru umode tuwarigu nou tapira biri čodureu piji rugadu. Dukodire boe ekare tuge vinho kuru maiwu tugu tapira biri čodureuto. Ere tuge vinho kuru maiwu tugu tapira biri maiwuto tu tu je. Ainore Jesus akore. Mare areia ji karega akoino. Vinho kuru ji karega akoino. Tuwadaru maiwu jire Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesus merure boepa oiagi sábado meriji. Trigo ure nou boepa tada. Ure jorduwadowuge ekodure apo. Nono nou Jesus ure jorduwadowuge ere tugeragu trigo enariji tuwo ko. ");
INSERT INTO bor_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseu doge emeardae pegare nou inoduji. Dukodire emagore Jesusji. Egore: – Akaiwodo. Judeu doge nure pagi. Pamaragodumodukare sábado meriji. Dukodire pamodukare pageragu trigoji sábado meri keje. Mare nou are jorduwadowuge ere tugeragu trigoji. Ukare turugadu! Mare erduwakare. Boe ewo tugeragu ia tuge roguji ji karega Pao Kurireu akoino boe emaragodukaiago sábado meriji. ");
INSERT INTO bor_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus akore: – Tarduwakare Pao Kurireu bataruji! Dukodire tarduwakare Pao Kurireu meardae remawuji. Tarduwamode Pao Kurireu meardae remawuji dukeje tamago pegamodukare čeroino duji. Marigudu Judeu doge eimijera kurireu Davi rore jiboe padure Pao Kurireu bataru keje. Dujire tarduwakare. Nou Davi uke boeire ji. Utugarege tugobaigarege eke boeire ei jamedu. ");
INSERT INTO bor_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dukodire ure turemo Pao Kurireu uwaito. Okwagere boe ere maku Pao Kurireu aiwu amireuji. Nou joruji nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu iere Abiatar. Pao Kurireu ure turo maku pawobe Judeu doge etai. Makore ei ekawo nou amireu ko. Tu nou ure boe enomea maku Pao Kurireu aiwuge emode nou Pao Kurireu uwai tadawu amireu kowuje. Mare Davi ure kowuje. Ure ia maku tudugarege etai ewo kowuje jamedu. ");
INSERT INTO bor_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Imedu Onaregedu nure imi. Imire imode boe erduwado rugadu nuba boe eromode sábado meri keje. Dukodire imagomode aino tai. Pao Kurireu ure boe ero maku boe etai erowo aino sábado meriji tu tu je. Mare paga karega boe pemegawo boei. Boe pegawo boei karega. ");
INSERT INTO bor_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus uture Judeu doge ere bato puiwu bai ka pugeje sábado meri keje. Ia imedu rakojere nono. Iera pegare. Ierare tudorido puapo. ");
INSERT INTO bor_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ia boe erdu pegare Jesusji. Edure nono jamedu. Dukodire etaiwore Jesus ia ro pegamode dubagai. Judeu doge eromodukare ia turore jiboeji sábado meri keje. Dukodire etaidukare boe eiogowo boei sábado meri keje. Mare Jesus umode nou imedu iera pemegago nou meriji dukodire nou boe erdu pegamode Jesus rore aino duji. ");
INSERT INTO bor_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus makore nou imedu iera pegareuji. Akore: – Aragojedo. Mato itae woe boe etoia ka. ");
INSERT INTO bor_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nono Jesus unarare nouia boei. Akore: – Nuba pago bakaru akore paromoduie sábado meri keje? Paro pegamoduie boei kana? Paro pemegamoduie boei kana? Pamode boe ekinorudo boe pegareu piji sábado meri keje kana? Pamode boe ewarigu boe pegareuto sábado meri keje kana? Nou boe emagokare boeji. ");
INSERT INTO bor_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus korigodure ei. Aiwore ei. Etaidukare tumearduwo Jesus makore jiboeji emeardae pegare kodi. Mare Jesus okudugodure ebo jamedu. Dukejere Jesus makore nou imedu iera pegareuji. Akore: – Akera raido itae. Nono nou imedu ure tugera raido ae. Čare iera pemegagodure tači je. ");
INSERT INTO bor_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mare fariseu doge eture nou bai piji tumara tabo boe korire ei kodi. Erdu pegare Jesus rore aino duji sábado meri keje. Sábado meriji emaragodumodukare eromodukare ia turore jiboeji. Dukodire ekorigodure Jesusji. Ere bato pui ia meartorure Herodes bataru jiwu imebo. Emagore pui tuwo ia tumeardae tawuje tuwo Jesus bito. ");
INSERT INTO bor_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus uture ture jorduwadowugebo pobo maereu okwa ka. Nou pobo maereu iere Galiléia Po. Aidure Jesus bataru jiwuge eture Jesus rekodaji pugeje. Emagare rugadu. ");
INSERT INTO bor_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Galiléia kejewugere. Judéia kejewugere. Iduméia kejewugere. Tiro ba kurireu kejewugere. Sidom ba kurireu kejewugere. Ia Jordão Po bakowu kejewuge ekurugodure Jordão Po kajeje taregoduwo Jesus ae jamedu. Emeardure Jesus rore jiboeji dukodire nou boe etaregodure tuiorduwo Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Boe ere tuiodo puwugeje pu otodai dukodire Jesus roiwakare tumago pemegawo ei. Dukodire makore ture jorduwadowugei ewo ia ika kurireu po barigu tuwo taredo to. Ewo tuiodo ika keje pobo oiado. Nono akuamode tumago pemegawo nou boei nou ika piji. ");
INSERT INTO bor_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesus ure kogodureuge epemegago. Emagare rugadu. Mare ia kogodureuge kimore. Etaidure tuwo tuburedo Jesusji tuwo tugera jetudo Jesus ukudau areiaji tubemegagoduwo. ");
INSERT INTO bor_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bope doge emedure iage etada. Etaregodure Jesus ae dukeje ere tuwududo moto keje tugudu tabo Jesus jokorai. Egore: – Pao Kurireu Onaregedu nure aki! ");
INSERT INTO bor_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus mako rakare nou bope doge ewadaru jipagi emagokawo nou inoduji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nono Jesus ruture ia tori ao ka. Nono makore taidure jiwuge boe ewagai. Nono etaregodure ae. ");
INSERT INTO bor_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesus ure tugeragu jiwuge ime enodo padure kejewugere doze. Ure tugie maku etai. Akore: – Uture iwadaru tabowu boe nure tagi. Ire ikeragu tai taragojewo itabo. Imode tarduwado tamagowo iboeji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Imode taragado tawo bope doge etawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ainore nou Jesus ure tugeragu jiwuge ekiere. Ia iere Simão. (Jesus ure awu Simão iedo Pedro) ");
INSERT INTO bor_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ia iere Tiago. Zebedeu onaregedu nure ema. Ia iere João. Tiago uwie nure ema. (Jesus ure nou ime pobedu doge ekiedo Boanerges. Ewadaru tabo egore aino: “Boeiaruru ore nure emage.”) ");
INSERT INTO bor_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ia iere André. Ia iere Filipe. Ia iere Bartolomeu. Ia iere Mateus. Ia iere Tomé. Ia iere Tiago. Nou Tiago Alfeu onaregedu nure ema. Ia iere Tadeu. Ia iere Simão Zelote. ");
INSERT INTO bor_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ia imedu iere Judas Iscariotes. Emare umode Jesus maku boe eimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nono Jesus ure turemo ia baito. Boe emagare nono apo pugeje. Dukodire Jesus roiwakare togwagewo ture jorduwadowugebo. ");
INSERT INTO bor_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesus uwobe emeardure nou inoduji dukeje etaidure tuwo Jesus utudo nou boe doge epiji. Boe egore Jesus aora bai baie kodi. ");
INSERT INTO bor_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ia jorduware Judeu doge eno bakaru jiwuge etaregodure Jerusalém ba kurireu piji. Erdu pegare Jesus rore jiboeji dukodire emago pegare ji. Egore: – Bope doge eimijera iere Belzebu. Emare meture nou Jesus tada. Emare ure turaga maku Jesus ai Jesus uwo bope doge etawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dukodire Jesus makore ewagai tumagowo ewadaru jipagi. Akore: – Bope doge eimijera iere Satanás jamedu. Umodukare tudawuje boe epiji tuginai. Mare ia imedu ro rakareu koiare umode tawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ia boe epokare puapo dukeje erugodure pui. Dukeje eraga akedumode epiji kuri je. ");
INSERT INTO bor_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Boe erugodumode tuwobei dukeje emode tugera ra pubiji rugadu. Dukodire eraga bokwamode rugadu. ");
INSERT INTO bor_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mare meartorure Satanás jiwugeire inagoino. Epomodukare puapo dukeje eragamodukare pugeje. Boe pegamode ei rugadu. Etagedumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ča iwogureu aidure tuwo turemo ia tugobaigare uwaito tuwo tugeragu nou tugobaigare ia oeji. Mare umode nou tugobaigare kogudo bukigu tabo boetoji. Nono umode tugeragu nou tugobaigare oeji rugadu tuduwo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","– Boe jokodu jire inagoino. Boe etaidukare turo pegareuji pugeje dukeje Pao Kurireu biagodumode nou ero pegareu piji. Emago pegamode Pao Kurireuji. Mare ekiarigodumode nou tuwadaru pegareuji dukeje Pao Kurireu biagodumode ewadaru pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mare ia boe emago pegamode Pao Kurireu Uwariji dukeje Pao Kurireu biagodumodukare nou ewadaru pegareu piji rugadu. Nou bataru metumode nou boebo ji rugadu. Du akedumodukare rugadu. Dukodire Pao Kurireu biagodumodukare nou inodu piji. ");
INSERT INTO bor_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nou boe egore bope uwari metuie Jesus tada dukodire Jesus akoino ei. ");
INSERT INTO bor_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus uče, uwiemage etaregodure bagai. Eragojere bawadu keje. Emagore Jesus bagai toro nou baito. ");
INSERT INTO bor_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Boe emagare nou bai tada Jesus apo. Emagore Jesusji. Egore: – Akaiwodo. Ače, awiemage etaregodure. Epagare awagai bawadu keje. ");
INSERT INTO bor_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Jesus makore ewadaru jipagi. Akore: – Imode tawie ioguduba nure mugače, ioguduba nure iwobeče. Nono Jesus aiwore nou mugure pudabowugei. Akore: – Awu boe ere nono iwobe mogadure. Meartorure Pao Kurireu meardae jiwu areme ime ere nono iwobe emogadure rugadu. Ere nono iwie mage emogadure rugadu. Ere nono muga mage emogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nono Jesus uture nou Galiléia pobo maereu okwa ka pugeje. Boe ere bato pui nono tumearduwo Jesus bataruji pugeje. Emagare rugadu. Dukodire Jesus ure taredo ia ika kurireuto. Nou ika kurireu padure nono pobo tada. Nou boe edure pobo okwai tumearduwo Jesus bataruji. Jesus ure tumugudo nou ika kurireu ja tada. ");
INSERT INTO bor_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nono Jesus makore ia bakaruji nou boe ewiagai tuwo nou boe erduwado nouia Pao Kurireu meardaeji. ");
INSERT INTO bor_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Akore: – Tawiapaga pemegado iwadaruji. Ia meri keje imedu uture to boepato tuwo boe tugu mototo. ");
INSERT INTO bor_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ure boe a roto ja ja moto joki to boepa tada. Ia a buture awara okwaji. Dukodire kiebarege ere nou buture awara okwa jiwu boe a rugadu kowuje. ");
INSERT INTO bor_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ia a buture toriguru tada. Boture kuri je mare moto pegare ji. ");
INSERT INTO bor_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dukodire boeru jeture ji dukejere nou boeru ure nou botureboe bito kuri je rugadu. Ukwa bokware kodi. Moto pegare kodi. ");
INSERT INTO bor_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ia a buture botoguru tada. Botoguru boture tabo jamedu mare botoguru ure bito. Dukodire nou buture botoguru tadawu boe a ričodukare pemegakare jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mare ia a buture moto pemegareu keje. Ere tuguwu sacu ure mitotu je. Botu pemegare, ričodu pemegare, enari kurire rugadu. Kidure dukeje ere rawuje čiwu piji. Ere a rawuje tuwo tugu sacuto. Nou sacu doge emagare. Parduwakare nuba nou ere korau sacu dogere. Ere cem, ere sessenta, ere trinta rabodu nou boe a tabo. Tawiapaga pemegado awu iwadaruji tarduwawo kaba jiba inagoino tai. ");
INSERT INTO bor_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesus ure nou bakaru akedudo dukeje makore ei pugeje. Akore: – Tawiapaga pemegado iwadaruji. ");
INSERT INTO bor_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus uture nou boe epiji ture jorduwadowugebo. Mare iage etaidure tuiorduwawo kaboba jiba nou bakaru akoino. Dukodire eture rekodaji tumeardu pemegawo kaba jiba akoino. ");
INSERT INTO bor_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus makore ei. Akore: – Ireadodure bakaruji iwo boe erduwado nouia Pao Kurireu meardaeji. Mare paga karega. Ireadodure bakaruji aino Pao Kurireu uwo tarduwado meture pudabowu tumeardae boeji boe ewo tugimijerado tu ema. Mare meartorukare Pao Kurireu jiwuge emeardumode imagore jiwu bakaruji mare emodukare boe pa nou bakaruji. ");
INSERT INTO bor_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dukodire: – Etaiwomode rugadu mare erdumodukare boeji; Ewiapagamode mare erduwamodukare boeji. Mare erduwamode dukeje emode tumagu Pao Kurireu ai. Dukejere Pao Kurireu biagodumode nou ero pegareu boe piji. ");
INSERT INTO bor_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nono Jesus unarare ture jorduwadowugei. Akore: – Tarduware awu inagoino jiwu bakaruji? Nuba taromode tarduwawo awu bakaruji? ");
INSERT INTO bor_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nono Jesus ure erduwado nou bakaruji. Akore: – Boe eire inagoino. Pao Kurireu bataru jire inagoino jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pao Kurireu o bataru ure nono nou boe a mogadure. Mare boe a ji karega inagoino. Pao Kurireu bataru aregodumode boe etae. Nono boe emeardumode Pao Kurireu bataruji. Dujire inagoino. Boe emeardumode Pao Kurireu bataruji mare bope doge eimijera umode nou boe ewiagodudo nou tumeardure jiwu Pao Kurireu bataru piji. Dukodire emeartorumodukare ji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Ia boe emeardumode Pao Kurireu bataruji pugeje. Nono nou boe emode nono nou boture toriguru tadawu boe a mogadure. Mare boe a ji karega inagoino. Boe eire inagoino. Nou boe eragamodukare tumeartoru raiwo Pao Kurireuji. Dujire inagoino. Emode tugeragu Pao Kurireu bataruji tiagare tabo mare emeartoru raimodukare ji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ia boe emeardumode Pao Kurireu bataruji pugeje. Awu boe emode nono nou boture botoguru tadawu boe a mogadure. Botoguru umode boe pegado ji umode bito. Mare boture botoguru tadawu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji. Etaidure tumeartoruwo ji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mare emororamagadumode tu tumeardae boeji kuri je. Emeardaere tu pudui tuwo to diero kurido. Dujire inagoino. Etaidumode tu taidure jiboeji. Emeardaere nou taidure jiboe umode tuginorudo boe pegareu piji mare pagatu je. Dukodire emode tugera ra Pao Kurireu bataru piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mare ia boe emeardumode Pao Kurireu bataruji dukeje emeartorumode ji rugadu. Dukodire epemegamode rugadu nono nou boture moto pemegareu boe a mogadure. Mare boture moto pemegareu kejewu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji nono emeartorumode ji rugadu. Dujire inagoino. Emodukare tugera ra tumeartorure jitu piji rugadu jii toro rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus makore kimo. Akore: – Boe emode pori bu lamparina aogeje dukeje urugumodukare. Boe emode jorugu mugudo tuba kuda dukeje urugumodukare jamedu. Mare boe emode lamparina urugu bararedo, uruguwo pudui. ");
INSERT INTO bor_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ča boe etaidumode tuwo turo pegareu biado boe epiji. Mare Pao Kurireu jorduware marigudu ero pegareuji. Dukodire boe erduwamode nou ero pegareuji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Taipaga pemegado iwadaruji. ");
INSERT INTO bor_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nono Jesus makore ei pugeje. Akore: – Taipaga pemegado tameardure jiboeji. Tagaiwomode boe eroji ero pegamode dubagai dukeje Pao Kurireu aiwomode taro pegareu bagai jamedu. Tagaidumode boe pegawo boei ero pegareu moriče dukeje Pao Kurireu umode boe pegado tai rugadu taro pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Boe erduware Pao Kurireu bataruji. Etaidure tumeartoruwo ji dukeje Pao Kurireu umode erduwa kurido pudui emeartoruwo pudui rugadu. Mare ia boe etaidumodukare tumeartoruwo tuiorduware jiwu Pao Kurireu bataruji dukeje Pao Kurireu umode erduwa bokwado tuwadaruji. Emeardaere tuiorduwaie rugadu mare pagatu je. ");
INSERT INTO bor_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus makore boei pugeje. Akore: – Boe eimijera kurireu nure Pao Kurireuče rugadu. Meartorure jiwuge emagamode rugadu. Mare boe erduwakare meartorumode jiwugei meartorumodukare jiwugei jamedu. Imode tarduwado nou inoduji bakaru tabo. Imedu ure boe a tugu mototo mare jorduwakare botumodewugei botumodukareugei jamedu. Ure boe a roto ja ja moto joki. ");
INSERT INTO bor_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nono nudure boečoji. Nou barogwato ure tie bu. Ure tuguwu boe a boture mare imedu jordukare ji mototo. Jorduwakare nuba nou boe a rore tuwoduwo. ");
INSERT INTO bor_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Moto koiare ure nou boe a botudo. Boture dukeje ričodure. Ričore dukeje enarire. Enari kurire. ");
INSERT INTO bor_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Imedu pagare kuroduwo. Kurodumode dukeje ure kado tariga tabo. Inagore imedu uie boe a tugu mototo. Boere nono nou boe a mogadure. Mare boe a ji karega inagoino. Boe eire inagoino. Ia boe emeartorumode Pao Kurireuji rugadu. Iage emeartorumodukare ji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus makore boei pugeje. Akore: – Itaidure iwo tarduwado nuba Pao Kurireu utugarege ere. Pao Kurireu utugarege emagakare mare ia meri keje Pao Kurireu utugarege emagagodumode rugadu. Ireadoduwo ia bakaruji tawiagai. ");
INSERT INTO bor_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ia imedu ure ia mostarda a tugu to boepato. Mostarda a kurikare rugadu. Boe a jamedu boe kurire nou mostarda a kori. Imedu ure tugu to boepato. ");
INSERT INTO bor_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nono ia meri keje boture. Ričodure rugadu. Nono iku kurire nou boe emode tugu to boepa tadaboe iku jamedu boe kori. Kiebarege ere tumugudo keje. Ere tuwaradu pemegado keje. Pao Kurireu utugarege ere nono nou mostarda a rogu mogadure. Mare mostarda a ji karega inagoino. Pao Kurireu utugarege eire inagoino. Emagakare mare ia meri keje Pao Kurireu utugarege emagamode rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ainore Jesus akore. Readodu kigodure bakaruji nou boe ewiagai tuwo erduwado toro nouia Pao Kurireu meardaeji rugadu jii erduwamode jitu oto pa ka. ");
INSERT INTO bor_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bakaru jire Jesus akoino boe ewiagai. Mare Jesus mugure nou ture jorduwadowugebo tuginai dukeje ure nou ture jorduwadowuge erduwado nou tumagore jiwu bakaruji ewiagai. Nou Jesus ure jorduwadowuge enodo padure doze. ");
INSERT INTO bor_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nou meriji rugadu boečoji Jesus makore ture jorduwadowugei. Akore: – Pagurugoduwo awu pobo maereu okwa abowu ka. ");
INSERT INTO bor_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dukodire emagore nou boei etuwo pugeje. Jesus ure jorduwadowuge enodo padure doze. Ere taredo ika kurireuto Jesus apo. Nono eture. Ia boe eture eregodaji ika kurireugebo jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ekurugodure dukeje bakuru pegareu aregodure etae. Nou bakuru pegareu ure pobo maereu rutudo. Dukodire pobo jeture nou ika kurireuji. Dukodire pobo ure turemo nou ika kurireuto. Dukodire nou ika kurireu korobadugodure pobo tabo. ");
INSERT INTO bor_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mare Jesus unudure toro nou ika kurireu upo keje. Aora padure takudau keje. Ča ure jorduwadowuge ere Jesus jetadudo. Egore: – Čegimijera! Akaidure pawiwo? Pawimode! ");
INSERT INTO bor_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ča Jesus ure turagojedo. Nono mako rakare bakuruji. Akore: – Akaguru akedudo! Nono makore poboji. Akore: – Akaba aporudo pugeje! Dukodire nou bakuru akedure rugadu. Nou pobo butugugodure jamedu. ");
INSERT INTO bor_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nono Jesus makore nou ture jorduwadowugei. Akore: – Kodiba tabagudugodure? Kočare tameartorukare i na? ");
INSERT INTO bor_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mare epagudugodure rugadu. Nono emagore pui. Egore: – Duboba nure awu imeduče? Kočare bakuru, pobo emeartorure awu Jesus bataruji rugadu! ");
INSERT INTO bor_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus aregodure ture jorduwadowugebo toro nou Galiléia pobo maereu okwa abowu ka. Nou etaregodure kawu moto iere Gerasa. ");
INSERT INTO bor_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nono Jesus ure tudawuje ika kurireu piji dukeje bope doge emedure tadawu imedu uture Jesus togi. ");
INSERT INTO bor_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dukodire nou imedu mugure boe ere bireuge etugu tadawu tori poro tada. Boe etaidure tuwo nou imedu kogudo meriri iku tabo mare meriri iku rakakare nou imeduji. ");
INSERT INTO bor_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Marigudu boe ere nou imedu bure kogudo meriri iku tabo. Ere nou imedu iera kogudo meriri iku tabo. Mare nou imedu ure nou meriri iku kado turaga tabo tu tu je. Raka kodure boe eiamedu boe ekori. ");
INSERT INTO bor_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nou imedu meru pagare tori aoji, nou tori poro jamedu boe parugajeje meriji boečoji. Kudu pagare meri jamedu boeji tu tu je. Ure tuwiri kado nou tori mega tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nou imedu aiwo jaere Jesus togi. Nono rekodure toro ae. Aregodure Jesus ae dukeje ure tubu jodo moto keje Jesus jokorai. ");
INSERT INTO bor_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dukejere ure tugudu rakado. Akore: – Jesus nure aki! Pao Kurireu Onaregedu nure aki! Boe eiamedu boe eimijera kurireu nure Pao Kurireuče! Jesus akore: – Bope uwari nure aki. Atawuje awu imedu piji! Nou bope uwari akore: – Nuba aromode čei? Akaba itudo boe pegareuto. Amagodo Pao Kurireu biagai aro pegamodukaie i rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus unarare ji. Akore: – Nuba akiere? Nou meture nou imedu tadawu bope uwari akore: – Čegiere bope doge makareuge. Čemagare awu imedu tada. ");
INSERT INTO bor_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nono nou meture nou imedu tadawu bope doge enogwamagudure Jesusji ukawo tududo nou moto piji. ");
INSERT INTO bor_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jugureuge edu puredure togwage tabo nono. ");
INSERT INTO bor_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dukodire nou meture nou imedu tadawu bope doge enogwamagudure Jesusji nou imedu ja piji. Egore: – Čedudo toro nou jugureuge etae. Čedo čeremo nou jugureugeto. ");
INSERT INTO bor_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nono Jesus ure etudo. Dukodire nou bope doge ere tudawuje nou imedu piji. Ere turemo nou jugureugeto. Dukodire nou jugureuge eiamedu boe eregodure kuri ia moto ri ao piji tači poboto. Dukodire eiamedu boe ewire poboto. Enodo padure dois mil. ");
INSERT INTO bor_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nou jeture nou jugureuge eiwuge ime eregodure nou boe epiji toro tuwai mugure tadawu ba kurireu ka. Ereadodure Jesus rore jiboeji nou ba kurireu tadawu boe ewiagai. Ereadodure boe eiamedu boe ewiagai nou moto jamedu boe parugajeje jamedu. Dukodire nou boe eture Jesus ae tuiorduwo ji, tuiorduwo nou imeduji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Etaregodure Jesus ae dukeje erdure nou bope doge emedure tadawu imeduji pemegagodure duji. Butugugodure. Ukudau areia meture ji. Erduware ji. Erduware Jesus ure bope doge etawuje nou imedu piji dukodire nou imedu pemegagodure. Dukodire nou boe epagudugodure. ");
INSERT INTO bor_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jordure nou Jesus rore jiwuge ereadodure nouia boe ewiagai nuba Jesus rore nou bope doge emedure tadawu imeduji. Ereadodure nou bope doge ere turemo jugureugeto duji nouia boe ewiagai jamedu. ");
INSERT INTO bor_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nou boe epagudugodure dukodire enogwamagudure Jesusji utuwo nou to moto piji. ");
INSERT INTO bor_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dukodire Jesus uiago taredo ika kurireuto pugeje. Mare nou bope doge ere tudawuje pijiwu imedu okwamagudure Jesusji. Akore: – Itaidure ikoduwo akabo. ");
INSERT INTO bor_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mare Jesus makore ji. Akore: – Boro. Atudo aibagi awobe etae. Areadoduwo ewiagai nuba Pao Kurireu ro pemegare ai duji rugadu. Areadodudo ewiagai Pao Kurireu ro pemegare ai du boeji. ");
INSERT INTO bor_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dukodire nou imedu uture Jesus piji tuwobe etae. Boe eda enodo padure dez nou moto keje. Nou imedu readodure Pao Kurireu ro pemegare pudui duji boe eiamedu boe ewiagai nou moto jamedu boe parugajeje. Boe eiamedu boe erore ta je nou imedu akoino tureadodu tabo Pao Kurireu bataruji boe ewiagai duji. ");
INSERT INTO bor_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus kurugodure nou pobo maereu kajeje tuibagi. Aregodure toro dukeje boe emagare nono pobo okwai. ");
INSERT INTO bor_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judeu doge ere bato pui ia bai tada tu tu je. Jeture nou bai jiwu boe eimijera iere Jairo. Nou imedu Jairo aregodure Jesus togi. Dukejere ure tuwududo moto keje Jesus jokorai. ");
INSERT INTO bor_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Dukejere okwamagudure Jesusji. Akore: – Itonaregedu aredu bigodunure. Mato itabo awo akera bu biri keje pemegagoduwo, bikawo. ");
INSERT INTO bor_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dukodire Jesus uture nou Jairo apo. Boe emagare rugadu tugodui Jesus rekodaji dutabo. Nono nou boe emagare rugadu dukodire ere taiado pači Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Ia aredu kodure ebo Jesus rekodaji. Marigudu nou aredu kogodaere tu tu je. Nou aredu ku rere piji nono areme etorewudae mogadure. Mare nou aredu o akedukare piji. Re kimore piji meri jamedu boeji. Joru oto padure doze nou aredu ku rere piji dukeje. Kodire uture jorubo epage etae. Ure diero rugadu maku jorubo epage etai mare ekare nou aredu pemegago. Pegare kimo. Jorubo epage etaiwore ji dukeje nou kogodae ure turagado ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nou aredu meardure Jesus rore jiboeji. Dukodire uture ae. Mare boe emagare nono Jesus apo. Dukodire nou aredu makore tudada. Akore: – Ikera otorogu jetumode awu Jesus ukudau areiaji dukeje ipemegagodumode. Nono nou aredu ure tugera raido. Nono iera otorogu jeture Jesus ukudau areiaji. ");
INSERT INTO bor_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ča nou aredu pemegagodure tači je. Nou aredu ku rekare piji pugeje. Jorduware tubemegagodure duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ča Jesus jorduware ia turaga iogore ia boei duji. Dukodire ure tuwuredo taiwowo nou boei. Akore: – Ioguduba ure tugera raido ikudau areia ka? ");
INSERT INTO bor_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nou ure jorduwadowuge emagore ji. Egore: – Kodiba akagore aino? Boe emagare woe pagabo. Boe eiamedu boe ekera jeture akudau areiaji. ");
INSERT INTO bor_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mare Jesus aiwore nou boei nou iera jeture tugudau areia jiwu bagai. ");
INSERT INTO bor_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nou aredu jorduware tubemegagodure duji. Dukodire ure tuburedo Jesusji. Mare pagudure dukodire mororamagadure. Ure tubu jodo moto keje Jesus jokorai dukejere readodure turore jiboeji Jesus biagai. ");
INSERT INTO bor_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus makore ji. Akore: – Are. Ameartorure i dukodire apemegagodure. Amororamagadukaba. Ire akogodae akedudo apiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus mako kimore nou areduji dukeje ime etaregodure etae Jairo uwai piji. Emagore Jairoji. Egore: – Akanaregedu rogu bokware. Amagokaba nou pagimijeraji pugeje. Piji. ");
INSERT INTO bor_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus meardure emagore jiboeji mare biapagakare ewadaruji. Makore Jairoji. Akore: – Amororamagadukaba. Ameartorudo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nono uture Jairo apo, Pedro apo, Tiago apo, Tiago uwie João apo. Eture toro Jairo uwai ka. Mare nouia ture jorduwadowuge ukare etudo pudabo. Kodire etukare rugadu. ");
INSERT INTO bor_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesus aregodure Jairo uwai ka Pedro apo, Tiago apo, João apo dukeje erdure boei nono. Nou boe etragudu rakare. Ekiarigodure rugadu etonaregedu bire kodi. ");
INSERT INTO bor_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nono Jesus ure turemo tumagowo ei. Akore: – Kodiba tagragudure? Kodiba tagiarigodure? Aredu bikare. Unudunure! Jorduware tumoduie jewodudo pugeje. Dukodire akoino unudunuie. ");
INSERT INTO bor_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mare nou boe erduware nou nogwaredu bire rugadu duji dukodire enogwarigodure Jesusji. Dukodire Jesus ure etudo nou bai piji. Nono ure tugeragu nou aredu učeji, ure tugeragu aredu uoji. Ure tugeragu Pedroji, Tiagoji, Joãoji jamedu. Nono ure turemo ebo nou aredu padure tadawu baito. ");
INSERT INTO bor_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesus ure tugeragu nou aredu ieraji dukeje makore ji ewadaru tabo. Akore: – Talitá cumi! (Boe ewadaru tabo akore: – Are! Amugudo! Imire inagoino ai!) ");
INSERT INTO bor_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ča nou aredu ure tumugudo tači je. (Nou aredu o joru oto padure doze.) Nono ure turagojedo. Merure nou bai ja tada. Uče, uo erore ta je. ");
INSERT INTO bor_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nono Jesus makore ei ekawo boe ewie turore jiboeji boe ewiagai. Dukejere Jesus akore: – Awu tagonaregedu okwagedo. ");
INSERT INTO bor_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus uture Jairo uwai piji tuduwo turijodure kejewu Nazaré ba kurireu ka. Ure jorduwadowuge eture rekodaji. ");
INSERT INTO bor_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Sábado meriji Jesus uture Judeu doge ere bato puiwu bai ka. Nonore ure boe erduwado nou bai tada. Nono boe emagare nou bai tada jamedu. Emeardure Jesus bataruji dukodire erore ta je. Mare erdu pemegakare ji. Egore: – Awu Jesus maragodumode ira jiwu imedu nure ema. Boe eimijera karegure ema. Čerduware uwobe eiamedu boei. Uče iere Maria. Uwie ime ekiere Tiago, José, Judas, Simão. Uwie areme emugu kimore woe awu pago ba kurireu keje rugadu. Ioguduba ure awu imedu jorduwado? Ioguduba ure turaga maku ai ro rakawo awu turo rakareu boeji? Boe eimijera karegure ema. Boe eimijera ukare jorduwado. Pagare akoino. Ro rakare mare pagatu je. Nono nou boe emeartorukare Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus makore nou boei. Akore: – Makore Pao Kurireu bataru jiwu makore jiboe pemegamode boei. Boe emeartorumode ji. Mare turijodure kejewu boe eda kejewuge etaidumodukare makore jiboeji. Uwobe uwai tadawu boe etaidumodukare makore jiboeji. Tu emage rugadu. Iage etaidumode ji. ");
INSERT INTO bor_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Boe emeartorukare Jesusji nono. Dukodire Jesus roiwakare tuwo turo rakareu makado nono nou turijodure kejewu moto keje. Akore: – Kočare awu boe emeartorukare i. Ure ia boe epemegago. Mare emagakare. Ure tugera bu ewugeje dukeje ure epemegago rugadu. Nono Jesus uture nou boe epiji. Aregodure ia boe eda ka pugeje. Nono ure boe erduwado pugeje. ");
INSERT INTO bor_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nono makore ture jorduwadowuge ewagai. Enodo padure doze. Jesus aidure tuwo etudo tuwadaru tabo boe eiamedu boe etae. Ure edo pobe tu tu puapo boe etae. Ure eragado ewo bope doge etawuje boe epiji. Jesus makore nou ture jorduwadowugei. ");
INSERT INTO bor_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Akore: – Tadukaba tage tabo. Tadukaba diero tabo. Tagaba tagoroe reko jamedu. Tadukaba ia tagedu jiwu tagaibo tabo. Tadudo tu meture taiwu tagudau areia tabo. Tadudo tu nou tawure tadawu tabo. Tadukaba ia tagudau tabo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tagaregodumode ia boe eda ka dukeje tardumode boei. Etaidumode tai dukeje tagamudo ebo ji nou tadumode kejewu meri ka. ");
INSERT INTO bor_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mare tagaregodumode ia boe eda ka pugeje mare nou boe ekimadumodukare tagabo. Etaidumodukare tuwiapagawo tawadaruji. Dukeje tadudo epiji. Tadumode epiji dukeje tawure okeakejewu to pui egai tawo moto urugudu barigu tawure okeakejewu piji nou boe erduwo Pao Kurireu aidukare nou erore jiboeji kodire umode tugera ra epiji. ");
INSERT INTO bor_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nono nou Jesus ure jorduwadowuge eture. Emagore Jesus bataruji boe ewiagai ewo tugera ra turo pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nou Jesus ure jorduwadowuge ere bope doge ewari etawuje boe epiji. Ere boekaguru redo kogodureuge etaora keje nono Pao Kurireu ure epemegago rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Boe eiamedu boe emeardure nou Jesus rore jiboeji. Etaidure tuiorduwawo kakojiwu imedu ba ure ema. Iage egore: – Elias nure ema. Mare iage egore: – Boro. Elias karega. Ia makore Pao Kurireu bataru jiwu nure ema. Ure nono jaoboe makore Pao Kurireu bataru jiwuge emogadure. Mare ia boe egore: – Boro. João Batista nure ema. Jewodure pugeje! Dukodire rakare tuwo boe pemegado boei. Boe eimijera kurireu Herodes meardure nou inoduji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes akore: – João Batista nure ema rugadu. Ire João Batista itoru kado kodire bire. Mačare jewodure pugeje. Mare Herodes okware boeto. João Batista bire rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Marigudu nou Herodes ure tugeragu tumana Filipe oredujeji tumana piji toreduječe. Nou aredu iere Herodias. Herodes ure tugeragu ji tumana piji tumuguwo apo rugadu. Dukodire João Batista mako pegare Herodes rore aino duji. Mako raire ji. Akore: – Arokaba aino amana oredujeji. Paro kigodukare aino. Ameartoru bokware dukodire amugure nou aredu Herodias apo. Ainore João Batista akore. Herodias korigodure João Batista akoino duji dukodire Herodes makore to tugobaigaregei ewo João Batista kogudo tuwo tugu baičoreuto. ");
INSERT INTO bor_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodias korigodu kimore João Batistaji dukodire aidure tuwo bito. Mare boe etaidure João Batistaji. João Batista ro pemega kuričigore boe eiamedu boeji. Dukodire Herodes pagudure turo pegawo João Batistaji dukodire ukare João Batista bito. Herodes aidure tuwiapagawo João Batista bataruji. Mare biapagare João Batista bataruji dukeje biagorore rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ia meri keje Herodias jorduware nuba turomode tuwo João Batista bito. Herodes ure tuwadae towuje tuwiabutuwo tuwudure kejewu ari keje. Makore boe eimijerage eiamedu boe ewagai Galiléia moto keje. Etaregodure tuwaduwo apo nou meriji. Makore tugobaigarege eimijerage ewagai jamedu. ");
INSERT INTO bor_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ere bato pui dukeje Herodias onaregedu rerure nou boe eiamedu boe egai. Ure Herodes jakaredo pudui. Ure nou boe eimijerage eiamedu boe egaredo pudui jamedu. Dukodire Herodes makore nou nogwareduji. Akore: – Ameartorudo i. Kaba jiba akaidure? Imode akogwamagudure bagaiboe jamedu boe maku akai rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nono Herodes mako pemegare ji pugeje. Akore: – Imagore jiboe imodukare udo tugirimi. Imode maku. Imode akaidure jiboe maku akai rugadu. Akaidumode ia ino motoji dukeje imode ino moto kado puiato. Imode maku akai rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nono nou nogwaredu uture epiji tuje bagai. Makore tujeji. Akore: – Kaboba bagaiba inogwamagudumode Herodiji? Uče makore tonaregeduji. Akore: – Akogwamagududo João Batista aora bagai. ");
INSERT INTO bor_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dukodire nou nogwaredu uture tuibagi tumara tabo Herodes ae. Akore: – Itaidure João Batista aoraji. João Batista aora bu ia baku keje kuri aino rugadu awo aora maku inai. ");
INSERT INTO bor_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes meardure nou inoduji dukeje kiarigodure rugadu. Aidukare tuwo João Batista bito. Mare makore nou boe egai tumoduie nou nogwaredu okwamagudure bagaiboe jamedu boe maku ai rugadu. Nou makore bagaiboe makudumoduie ai rugadu. Dukodire Herodes aidukare tuwo tuwadaru pogurudo. ");
INSERT INTO bor_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dukodire makore ia tugobaigare bagai uwo João Batista bito, uwo aora kado piji, uwo João Batista aora reko pudae. Dukodire nou tugobaigare uture João Batista bagai nou baičoreu ka tuwo João Batista bito. Ure João Batista itoru kado kodire ure bito. ");
INSERT INTO bor_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Dukejere tugobaigare aregodure João Batista aora tabo. Padure baku keje. Nono ča ure maku nou nogwaredu ai. Dukeje čare nou nogwaredu ure reko toro tuje ae rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nono ča João Batista utugarege emeardure nou inoduji dukeje etaregodure tugimijera bireu bagai. Nono ča ere tugeragu bireuji. Ere reko toro to moto ka tuwo tugu toro to moto keje. ");
INSERT INTO bor_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Uture Jesus bataru tabowuge ere tugirimi Jesus ae pugeje. Enodo padure doze. Ereadodure turore jiboeji, tumagore jiboeji Jesus biagai. ");
INSERT INTO bor_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Boe emagare nono. Etaregodure tumagowo Jesusji. Iage eture mare iage etaregodure pugeje tumagowo Jesusji jamedu. Dukodire Jesus roiwakare tuwo boe kowuje nou boe doge eigoia. Nou ure jorduwadowuge enogwagekare jamedu. Dukodire Jesus makore ei. Akore: – Paduwo ia boe eda tuginaiwu ka awu boe epiji pawo pagamudo. ");
INSERT INTO bor_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dukodire eture ika kurireu tabo ia boe maereu ka nou boe epiji tuwo tamudo. ");
INSERT INTO bor_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mare boe erdure ei rugadu. Dukodire eregodure ika kurireu me keje taregoduwo nou ika kurireu otodai tubagawo ewagai toro. Nou boe emagare toro. Etaregodure boe eda jamedu boe piji. ");
INSERT INTO bor_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus aregodure nou pobo maereu okwa ka ture jorduwadowugebo. Mare boe emagare nono marigudu. Jesus ure tudawuje ika kurireu piji dukeje jordure nou boei rugadu. Okudugodure ebo rugadu. Akore eie nono ovelha doge emogadure. Jetu pemegare eiwu bokwaie. Mare ovelha ji karega akoino. Nou boe eroiwakare tuwo tuginorudo. Dujire akoino. Dukodire mako raire ei tuwo erduwado boe jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Merirekodutabo Jesus ure jorduwadowuge etaregodure ae. Enodo padure doze. Emagore Jesusji. Egore: – Merirekodure. Awu boe etudo awu boe maereu piji. Boe bokware woe du kodi. ");
INSERT INTO bor_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Awu boe etudo ia boe etae ewo tugeragu ia tuge roguji. ");
INSERT INTO bor_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mare Jesus makore nou ture jorduwadowugei. Akore: – Boro. Taigoiare tamode enogwagedo. Egore: – Awu boe emagare. Boe maragodumode kejewu arimode oito dukeje o dieromode tuwo akirodo boe ekeji awu boe ekeče. Mare pago diero bokware. Nuba paromode pawo enogwagedo? ");
INSERT INTO bor_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nono Jesus makore ei. Akore: – Page amireu rogure? Tagaiwodo bagai. Dukodire Jesus ure jorduwadowuge etaiwore amireu bagai. Erdu iaji dukeje ere reko Jesus ae. Egore: – Akaiwodo. Čerdure jiwu amireu ure ikera aboudure tu je. Page karo rogu ere pobetu je. ");
INSERT INTO bor_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nono Jesus makore nou boei ewo tudo pui ewo tudo cinquenta ewo tudo cem tu tu tumuga boe keje. ");
INSERT INTO bor_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dukodire nou boe eiamedu boe ere tudo pui. Ere tudo cinquenta ere tudo cem tu tu nou tumuga boebutu keje. ");
INSERT INTO bor_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nono Jesus ure tugeragu nou amireuji nou kare kugurei. Nou amireu ure ikera aboudure. Nou kare kugure ere pobetu je. Nono Jesus aiwore baruto. Dukeje Jesus imadure Pao Kurireu apo nou amireu paru tabo nou kare kugure eparu tabo jamedu. Nono ure nou amireu kado tuwo maku nou ture jorduwadowuge etai ewo pedo nou boe dogei jamedu. Nono Jesus ure nou kare ekado jamedu nou ture jorduwadowuge ewo pedo ei jamedu. ");
INSERT INTO bor_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jesus koiare ure nou boe doge eke kodudo tugori boe eiamedu boe etai. Boe eiamedu boe enogwagere rugadu. Ekuredure egarere pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ča nou Jesus ure jorduwadowuge ere nou kadarabo doge korau nou boe eke kobo tabo. Nou kadarabo doge enodo padure doze nou boe eke kobo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ime enodo padure cinco mil nono togwage tabo nou meriji. ");
INSERT INTO bor_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kuri je dukeje Jesus makore nou ture jorduwadowugei ewo turemo ika kurireuto etuwo tododai. Ekurugoduwo nou pobo maereu kajeje toro bakowu ka toro Betsaida ba kurireu ka. Jesus rakojere eiageje tumago tabo nou boei tuwo etudo. ");
INSERT INTO bor_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesus uture nou boe epiji dukeje Jesus ruture toro ia tori ao ka tuginaigodu tumagowo Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Boečodure dukeje nou Jesus ure jorduwadowuge eture tabowu ika kurireu mugu kimore nou pobo maereu oiadada. Mare Jesus rakoje kimore toro nou tori aogeje tuginaigodu. ");
INSERT INTO bor_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Barogwakododukare raga dutabo Jesus jordure ture jorduwadowugei toro pobo maereu oiadada. Bakuru jore etogi. Boe korire nou bakuruji rugadu dukodire ere tubeodo pudui traiga tabo nou ikaji nou bakuru togi. Toro baregodutabo, Jesus uture toro tumeru tabo pobo aoji. Ča ure tugoduiago toro etododai. ");
INSERT INTO bor_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mare nou ture jorduwadowuge erdure Jesus merure pobo aoji. Emeardaere ia boe pegareu nuie ema. Dukodire epagudugodure. Nono etokudure tubagudu koia če. ");
INSERT INTO bor_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Eiamedu boe epagudugodure rugadu. Ča Jesus makore ei. Akore: – Taragado tai! Imi rugadu reo. Tabagudukaba. ");
INSERT INTO bor_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nono ure turemo ika kurireuto ebo. Ča nou bakuru rakareu akedure tači je. Nou ure jorduwadowuge erore ta je. ");
INSERT INTO bor_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesus ure boe enogwagedo jawu meriji. Boe ekuredure rugadu dukodire egarere pudui. Mare nou ure jorduwadowuge etaidukare tumeartoruwo ji dukodire erduwakare Jesus rore jiboeji. Pao Kurireu maragodae reno. Ča Jesus merure pobo aoji, ure bakuru rakareu akedudo jamedu mare nou ure jorduwadowuge etaidukare tumeartoruwo ji raga dukodire erduwakare nou Jesus rore jiboeji pugeje. Pao Kurireu maragodae reno pugeje. ");
INSERT INTO bor_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ekurugodure nou pobo maereu kajeje dukeje etaregodure Genesaré moto ka. Nonore ere to ika kurireu bu. Ere kogudo. ");
INSERT INTO bor_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ere tudawuje to ika kurireu piji dukeje boe erdure Jesusji. Erduware Jesus ure ema duji. ");
INSERT INTO bor_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dukodire nou boe eregodure nou boe eda jamedu boeji tuwo nou boe ewie Jesus aregodure duji. Dukodire boe eiamedu boe etaregodure tuwobe kogodureugebo Jesus ae. Nou kogodureuge epadure tugudau kodo keje. ");
INSERT INTO bor_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus uture nou boe eiamedu boe eda ka. Uture boe eda ka dukeje boe etaregodure ae kogodureugebo. Enogwamagudure Jesusji kogodureuge ewo tugera bu Jesus ukudau areia okwa keje. Uture ba kurireu ka dukeje boe etaregodure ae kogodureugebo nono jamedu. Enogwamagudure Jesusji kogodureuge ewo tugera bu Jesus ukudau areia okwa keje jamedu. Nono nou ure tugera bu Jesus ukudau areia okwa kejewuge eiamedu boe epemegagodure rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ia fariseu doge etaregodure Jerusalém piji Jesus ae. Ia jorduware Judeu doge eno bakaru jiwuge etaregodure Jerusalém piji Jesus ae jamedu. Ere bato pui Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Erduware Jesus ure jorduwadowuge enogwagere tugera tabo duji. Nou fariseu doge etaidure boe ewo tugera kabi nono mariguduwuge tuwobe ero mogadure. Judeu doge erore tu tu aino togwagewo. Mare nou Jesus ure jorduwadowuge erokare nono ero mogadure. ");
INSERT INTO bor_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Marigudu fariseu doge, Judeu doge eiamedu boe erore nou mariguduwuge tugimijerage ere maku pudaiwu bakaru tadawu ero boeji tu tu je. Dukodire marigudu ere tugera kabi nono mariguduwuge Judeu doge ero mogadure togwagewo tu tu je. Ainore erore jii aino. ");
INSERT INTO bor_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Emode akirodo tugeji nou boe jeto tadawu bai piji dukeje emode kabi nono mariguduwuge Judeu doge ero mogadure jamedu tu tu je. Mariguduwuge Judeu doge eno bakaru kurire dukodire erore jiboe makare rugadu. Kodire ere turuwobo kabi tu tu je. Ere tudaria kabi tu tu je. Ere tubagaga kabi tu tu je. Ere tubadure kejewu kamoreu kabi tu tu je jamedu. Emodukare tugera ra turore aino dupiji rugadu. Turoia jire eroino tu tu je tuwo nou jamedu boe pemegado turowo nou to bakaru tadawu turo boeji tu tu je. ");
INSERT INTO bor_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dukodire nou fariseu doge, nou jorduware Judeu doge eno bakaru jiwuge etaidukare nou Jesus ure jorduwadowuge ekare tugera kabi duji. Enarare Jesusji. Egore: – Kodiba nou are jorduwadowuge emeartorukare mariguduwuge pawobe emagore jiboeji? Erokare nono nou mariguduwuge pawobe ero mogadure. Enogwagere mare ekare tugera kabi nono nou mariguduwu paro mogadure. Ukare turugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mare Jesus makore ei. Akore: – Tare boe erduwado mare tameartorukare tawadaruji. Boe jokodu jire Isaías akoino marigudu. Marigudu rugadu ure pawobe ewie taromode tameardaemode jiboeji. Marigudu Isaías akore: – Pao Kurireu ure boe ewie rugadu. Akore: “Awu boe emagore togwa tabo tumeartoruie i mare emeardae remawu ure tuginai rugadu toro imeardae piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","– “Awu boe ere tubu jodo tumago pemegawo i mare pagare egoino. Ere boe erduwado bakaruji. Egore iwadaruie. Mare pagare egoino. Ia tumagore jiwu bakaru jire nou boe egoino.” ");
INSERT INTO bor_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesus makore nou fariseu dogei pugeje. Akore: – Taro kodure nou imedu Isaías ure boe ewie jiboeji rugadu. Tare tagera ra Pao Kurireu bataru remawu piji tameartoruwo tu tameardaeji. Pao Kurireu bataru ji karega tagagoino. ");
INSERT INTO bor_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","– Jeroreuge nure tagi. Tamago moture tawo boe emeartorudo tawadaruji ekoduwo nou tameardae rekodaji emeartorukawo Pao Kurireu bataru remawuji. ");
INSERT INTO bor_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Marigudu Moisés ure pawobe erduwado Pao Kurireu bataru remawuji. Akore: “Tameartorudo taoji tajeji. Ča nou boe mako pegamode tuoji tujeji tuwo epogurudo dukeje bitoduiago.” Ainore Pao Kurireu akore jawu tawobei. ");
INSERT INTO bor_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mare tagi tare boe erduwado ia bataru tuginaiwuji boe ekawo tugera maku tuo ai tuje ai. Tagagore imedu makomoduie tujeji tuoji tumodukaie tugera maku etai tumoduie toe maku Pao Kurireu ai kodi. Dukodire tumodukaie tugera maku tuo ai tuje ai. Ainore boe eromoduie. ");
INSERT INTO bor_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mare pagare egoino. Etaidukare tuwo tugera maku tuje ai tuo ai dukodire egoino. ");
INSERT INTO bor_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Taigoiare tare boe egodo aino. Dukodire čare tagaidukare Pao Kurireu bataruji rugadu. Tameartorukare ji. Tagaidure tagoduwo nou tameardae rekodaji. Ainore tarore ia taroji jamedu. Tare taro udo tuginai Pao Kurireu meardae remawu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nono Jesus makore boe makareuge etae ewo bato pui pudae. Makore nou boei. Akore: – Taiamedu boe tawiapaga pemegado iwadaruji. Iwo tarduwa kuričigodo iwadaruji. ");
INSERT INTO bor_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nou tagwagemode jiboe umodukare tabegado Pao Kurireu jakai dukodire tawujedumodukare tago bakaru tadawu taro piji. Mare nou taiabijiwu tawadaru pegareu umode tabegado Pao Kurireu jakai dukodire tawujedumode tago bakaru tadawu taro piji jii je. ");
INSERT INTO bor_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dukeje Jesus uture nou boe epiji. Ure turemo ia baito. Nono nou ure jorduwadowuge enarare Jesusji uwo tuiorduwado kaba jiba akoino nou boei. ");
INSERT INTO bor_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus makore nou ture jorduwadowugei. Akore: – Tarduwa bokware nono nou boe emogadure. Tawiapaga pemegado iwadaruji. Tamodukare tabegado tage tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tamode tage ko dukeje taguredumode. Nono umode tudawuje tabiji. Mare tabemega kimomode tarowo boe eno bakaru tadawu boe ero boeji. Tage umodukare tameardae pegado boei. Tagoino dutabo Jesus ure nou Judeu doge eno bakaru tadawu ia ero akedudo. Nou bakaru akore ekaiago ia tuge kowuje tuwo tubemegado turowo nou to bakaru tadawu boe ero boeji. Aino čare Jesus ure nou bakaru akedudo. Boe eke jamedu boe uie turugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nono Jesus makore ei pugeje. Akore: – Boe ero pegareu umode tudawuje boe emeardae piji. Nou inodu koiare umode boe epegado Pao Kurireu jakai dukodire etawujedumode to bakaru tadawu turo piji jii je. ");
INSERT INTO bor_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Du nou boe emeardae pegareu aregodumode epiji rugadu. Emode nou tumeardae tawuje turo pegawo rugadu. Ero pegamode tieribari tabo. Ekiwogumode. Emode boe ewido. ");
INSERT INTO bor_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Eribarimode toreduje piji toredu piji. Enogwa kidumode tu pudai tuwo toe kurido tumedage epiji. Emode turo pegareu kurido rugadu. Boe emode boe ekiripagado. Boe etaora bai baimode tuge kurure pudui dutabo. Boe ekorigodumode boe enoe keje. Boe emago pegamode tumedage eroji. Boe enojaromode tuwadaruji. Boe erduwa bokwamode turore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Boe emode tumeardae pegareu tawuje turowo awu boe ero pegareu jamedu boeji. Awu boe ero pegareu koiare umode boe epegado rugadu Pao Kurireu jakai dukodire etawujedumode to bakaru tadawu turo piji jii je. ");
INSERT INTO bor_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nono Jesus uture nou boe epiji. Uture toro ia moto ka. Puredure Tiro ba kurireuji. Nono ure turemo ia boe ewaito. Aidure tuwo tamudo. Aidukare boe erduwawo turagojere nono duji mare boe erdure ure turemo nou bai toduji. ");
INSERT INTO bor_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ia aredu jorduware Jesus rakojere nono duji. Bope uwari meture nou aredu onaregedu tada. Dukodire uče aregodure Jesus ae. Ure tubu jodo moto keje Jesus jokorai. ");
INSERT INTO bor_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nou aredu Judeu kejewu aredu karegure ema. Boture Fenícia moto keje puredure Síria motoji. Okwamagudure Jesusji uwo nou bope uwari tawuje tonaregedu aredu piji. ");
INSERT INTO bor_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mare Jesus makore ji. Akore: – Boe etore enogwagewo jii tuguredu ka. Ukare turugadu boe ewo tore eke rogu tawuje epiji tuwo maku tagu ariga doge etai. ");
INSERT INTO bor_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nou aredu jorduware boe etore ji karega Jesus akoino duji. Jorduware Judeu dogeire Jesus akoino duji. Jesus aregodure moto ka tumagowo Judeu dogei rugadu. Nono nou aredu makore Jesus bataru jipagi. Akore: – Boe rugadu. Mare ariga doge epuredumode boe etorei tuwo nou buture ira kudawu boe etore eke gigudu rugadu boe kowuje. ");
INSERT INTO bor_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus akore: – Boe jokodu. Atudo aibagi awai ka akanaregedu aredu bagai. Ire nou bope uwari tawuje piji dukodire akanaregedu pemegagodure rugadu. Nou bope uwari ure tudawuje piji. ");
INSERT INTO bor_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dukodire nou aredu ure tugirimi tuibagi tuwai ka tuiorduwo tonaregeduji. Aregodure tuwai ka dukeje jordure tonaregedu padure kamoreu keje duji. Pemegagodure. Nou bope uwari ure tudawuje piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nono Jesus uture nou Tiro ba kurireu kejewuge epiji. Uture Sidom ba kurireu ka. Dukeje merure boe eda kejewu motoji. Boe eda enodo padure dez nono nou moto keje. Nono aregodure nou Galiléia pobo maereu okwa ka. ");
INSERT INTO bor_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nonore ia boe etaregodure Jesus ae ia bija bokwareu imedu apo. Roiwakare tumagowo jamedu. Nono nou boe enogwamagudure Jesusji uwo tugera bu nou imedu keje pemegagoduwo. ");
INSERT INTO bor_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dukodire Jesus ure taradaino boe epiji nou imedu apo. Jesus ure tugera bu nou imedu bija keje pudogi. Dukejere ure todoguru bu tugerako keje. Nono ure raido nou imedu eru ka. ");
INSERT INTO bor_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nono Jesus aiwore baruto. Ure ake tawuje tubiji. Dukejere makore Judeu doge ewadaru tabo. Akore: – Efatá. (Boe ewadaru tabore boe egore: “Uwo tuiado” aino.) ");
INSERT INTO bor_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ča nou imedu bija pemegagodure pugeje tači je. Meardure boe emagoji rugadu. Makore jamedu. Mako pemegare. ");
INSERT INTO bor_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nono Jesus makore nou boei ekawo boe ewie nou turore jiboeji. Makore ei mare emeartorukare. Ere boe ewie rugadu. ");
INSERT INTO bor_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Biapagare nou Jesus ro jiwuge eiamedu boe erore ta je. Egore: – Awu Jesus ro pemegare rugadu! Rakare rugadu kodire umode bija bokwareuge ewija epemegago emearduwo boeji erduwawo boe emagore pudui duji. Rakare tuwo mako bokwareuge emagodo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ia meri keje boe ere bato pui pugeje tuwiapagawo Jesus bataruji. Emagare rugadu. Enodo padure quatro mil. Čare eke akedure dukeje Jesus makore nou ture jorduwadowuge etae. Nono ča makore ei. ");
INSERT INTO bor_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Akore: – Inogudugodure awu boebo. Merire pobe metia bokware ei woe itabo. Woe boe eke bokware rugadu ewo ko. ");
INSERT INTO bor_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Itaidukare iwo etudo tuguri bioro tabo mare eragamodukare tumeruwo awaraji pugeje. Iage etaregodu jaere woe itae. ");
INSERT INTO bor_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nou Jesus ure jorduwadowuge egore: – Nou boe emagare rugadu woe pagabo. Nuba čeromode woe boe maereuto boe eke bagai nou boe ekeje? ");
INSERT INTO bor_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus akore: – Nuba tage amireu rogure tu je? Egore: – Amireu oto padure sete. ");
INSERT INTO bor_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nono Jesus makore boe eiamedu boei ewo tumugudo moto keje. Dukejere ure tugeragu nou amireuji. Nono imadure Pao Kurireu apo nou amireu paru tabo. Dukejere ure nou amireu kado. Ure maku ture jorduwadowuge etai ewo reko boe etae. Dukodire ere pedo boe eiamedu boei rugadu. ");
INSERT INTO bor_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ia kare kugurere nono jamedu. Jesus imadure Pao Kurireu apo nou kare kugure eparu tabo. Dukejere makore ture jorduwadowugei ewo nou kare kugure pedo boe eiamedu boei jamedu. ");
INSERT INTO bor_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Nono ča nou boe eiamedu boe enogwagere. Egarere pudui rugadu tuguredure duji. Emagare. Enodo padure quatro mil. Nono ča nou Jesus ure jorduwadowuge ere kadarabo korobadureugedo sete nou boe eke kobo tabo. Nono Jesus makore nou boei ewo tugirimi tuibagi tuwai ka pugeje. ");
INSERT INTO bor_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dukejere Jesus ure taredo ika kurireuto ture jorduwadowugebo. Eture toro Dalmanuta moto ka. ");
INSERT INTO bor_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ia fariseu doge etaregodure Jesus ae. Ere tunarado ji tumago rakareu tabo tuiorduwo jorduwamode rugadu dubagai. Dukodire enogwamagudure Jesusji uwo ia turo ro rakareu to tiagai tuiorduwo nouia ro rakareu aregodure rugadu Pao Kurireu piji du bagai. ");
INSERT INTO bor_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mare Jesus jorduware nou boe emeartorukare pudui duji dukodire ure ake ta tubiji tugiarigodure dukodi. Nono akore: – Kočare awu boe etaidure tu iro rakawo tuiorduwawo i rugadu. Boro! Iromodukare ia iro rakareuji rugadu! Pagare egoino. Etaidukare tumeartoruwo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dukodire uture epiji. Ure taredo ika kurireuto pugeje tugurugoduwo nou pobo maereu okwa ka. ");
INSERT INTO bor_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus ure jorduwadowuge ewiagodure tuwo tugeragu ia tuge amireuji pugeje. Dukodire eke akedugodure. Eke amireure mitotu je nou ika kurireu tada. ");
INSERT INTO bor_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus makore ei. Akore: – Tawiapagado tawo tado tarugadu. Fariseu doge emeardae ure nono fermento mogadure. Herodes meardae ure nono fermento mogadure jamedu. Tameardaekaba nono nou emeardae mogadure. ");
INSERT INTO bor_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dukodire nou Jesus ure jorduwadowuge emagore pui kaba jiba akoino nou fermento jiboeji. Egore pui: – Pawiagodure page amireu piji dukodire Pagimijera akoino pai. ");
INSERT INTO bor_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus jorduware egoino pui duji. Nono unaragodure ei. Akore: – Kodiba tamagore pui nou tage amireu bokwaie duji? Kočare tarduwa bokware kimo? Tagaora rakare tarduwawo iwadaruji. ");
INSERT INTO bor_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Taekure tarduwo irore jiboeji. Tawijare tamearduwo imagore jiboeji. Mare tawiagodure irore jiboe piji, imagore jiboe piji marigudu. ");
INSERT INTO bor_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ire boe eke rogu kado dukeje nou boe eke kodure kuri boe ekori. Ire boe enogwagedo nou boe eke roguji. Nou boe enodo padure cinco mil. Enogwagere dukeje tare boe eke kobo tugu kadaraboto boe etuwo tabo. Nuba tare korau kadarabo ure nou boe eke kobo tabo? Egore: – Oto padure doze. ");
INSERT INTO bor_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesus makore ei pugeje. Akore: – Ča ia meri keje ire boe enogwagedo pugeje. Nou amireu ure sete. Ire kado boe etai pugeje du nou ime enodo padure quatro mil. Ča nuba tare korau kadarabo dogere nou boe eke kobo tabo? Egore: – Oto padure sete. ");
INSERT INTO bor_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesus akore: – Kočare tarduwa bokware imeardae remawuji kana? ");
INSERT INTO bor_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus aregodure ture jorduwadowugebo Betsaida ba kurireu ka. Nono ia boe etaregodure Jesus ae ia joku bokwareu imedu apo. Enogwamagudure Jesusji uwo tugera bu keje. ");
INSERT INTO bor_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus ure tugeragu nou joku bokwareu imedu ieraji. Uture apo toro nou ba kurireu piji tugiogowo nou imeduji. Nono Jesus ure todoguru bu nou imedu joku keje. Nono Jesus ure tugera bu nou imedu keje jamedu. Dukejere unarare ji. Akore: – Ardure iaboeji? ");
INSERT INTO bor_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nou imedu aiwore. Dukeje akore: – Uu. Iordure ia boei. Mare iorduwakare ei. Ere nono igurure tumeru tabo mato, toro, mato, toro, mato. ");
INSERT INTO bor_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nono Jesus ure tugera bu nou imedu joku keje. Dukejere nou imedu aiwore pugeje. Čare joku pemegagodure. Jordure boeji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nono Jesus makore ji utuwo tuibagi tuwai ka. Akore: – Akaba akirimi ba kurireu ka. Atudo jii toro awai ka. ");
INSERT INTO bor_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dukejere Jesus uture ture jorduwadowugebo nou ba kurireu piji toro ia boe eda ka. Nou boe eda puredure Cesaréia Filipe ba kurireuji. Nou awaraji Jesus unarare nou ture jorduwadowugei. Akore: – Nuba boe emeardaere i? ");
INSERT INTO bor_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Egore: – Boe egore João Batista nuie aki. Nouiage egore Elias nuie aki. Nouiage egore ia mariguduwu makore Pao Kurireu bataru jiwu nuie aki. ");
INSERT INTO bor_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nono Jesus unarare ei pugeje. Akore: – Tagi. Nuba tameardaere i? Pedro akore: – Umode boe ekinorudowu nure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nono Jesus akore: – Tamagokaba awu tameardaere idu jiboeji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nono Jesus ure nou ture jorduwadowuge erduwado pugeje. Akore: – Imedu Onaregedu nure imi. Judeu doge eimijerage erdu pegamode i. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage erdu pegamode i. Jorduware Judeu doge eno bakaru jiwuge erdu pegamode i. Emode boe pegado i rugadu. Emode iwido. Mare merimode pobe metia bokware dukeje iewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus mako pemegare nou tuwadaruji nou ture jorduwadowuge ewiagai erduwawo boe mode pudui duji. Mare Pedro aidukare nou Jesus bataruji. Ure tumegido Jesus apo kuri nono tumagowo ji. Akore: – Boe modukare aino ai. ");
INSERT INTO bor_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mare Jesus ure tumegido. Nono aiwore nou ture jorduwadowuge eiamedu boei. Dukejere mako rakare Pedroji. Akore: – Akaradai ikoda piji Satanás. Ameardae jire inagoino. Ameardaere nono boe emeardae mogadure. Boe emeardaekare nono Pao Kurireu meardae mogadure. ");
INSERT INTO bor_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nono Jesus makore nou ture jorduwadowuge ewagai ewo tuburedo pudui. Makore ia boe ewagai jamedu. Dukejere makore ei. Akore: – Ia tagi tagaidumode tameartoruwo i dukeje tagera ra taro pegareu piji, tawia ra tameardae pegareu piji, tagaidure jiboe piji. Tado tarugadu boe pegawo tai nono boe pegamode i dumogadure. Iwimode ipo padure pugajejewu keje. Dukodire inagoino tai tawo tado tarugadu tagoduwo itabo. ");
INSERT INTO bor_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Boe ewiapagamode tuwo boe pemegado tu pudui turaga tabo dukeje nou boe eraga akedumode epiji rugadu. Egare remawu modukare. Emodukare tuginorudo bope doge eda kejewu joru pegareu piji rugadu. Mare boe ewiapagamodukare tumeardaeji pugeje tuwo tugera ra turo pegareu piji tumeardae pegareu piji tuwo tumagu inai tuwo boe erduwado iwu bakaru pemegareuji dukeje Pao Kurireu umode boe pemegado ei, umode egare remawudo rugadu. Nono ewarigudumodukare bope doge eda kejewu joru pegareuto jamedu. ");
INSERT INTO bor_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Imedu umode toedo boe jamedu boeče. Mare nou oe umodukare imedu rutudo baruto. Ča nou imedu biagorokare tuwo tumeartorudo Pao Kurireuji. Biagorore tu tuwo toe kurido pagatu je. Mare paga karega inagoino. Boe emodukare turudu morido toe tabo. ");
INSERT INTO bor_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ro pegareuge emagare rugadu. Ro pegareuge tieribari tabowuge emagare rugadu. Mare ia boe epogurure tumagowo iwu bakaruji nou boe ewiagai dukeje imodukare ikeragu ei itae. Itaregodumode Pao Kurireu o jorugu pemegareu tabo Pao Kurireu utugarege baru tadawugebo dukeje imodukare ikeragu ei. Nou Pao Kurireu o jorugu pemegareu urugure Pao Kurireu kujegajeje. Imode ikirimi mato dukeje urugumode nou aregodumode itabowu Pao Kurireu utugarege baru tadawuge ekujegajeje jamedu. ");
INSERT INTO bor_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nono Jesus makore ture jorduwadowugei pugeje. Akore: – Iwo tawie. Pao Kurireu umode boe eimijera kurireudo pudumi dukeje aregodumode turaga tabo rugadu. Ia tagi tardumode awu inagoino jiboeji. Tawimodukare jii toro tardumode nou Pao Kurireu roino jitu ka. ");
INSERT INTO bor_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Meri oto padure seis Jesusji pugeje. Nono ča uture Pedro apo, Tiago apo, João apo toro ia tori ričoreu ao ka. Tu emagere edure nono nou tori aogeje. Nono nou Jesus je ure tudo tuginai. Nou ure jorduwadowuge erdure ji rugadu. Mare Pao Kurireu koiare ure Jesus je udo tuginai. ");
INSERT INTO bor_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pao Kurireu ure Jesus ukudau areia kigadu maereudo ji. Kigadure rugadu kigadureboe jamedu boe kori. ");
INSERT INTO bor_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nono ča rore puku ei ime edure nono ebo. Eliare Moisere edu nono tumago tabo Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nono Pedro makore Jesusji. Akore: – Ikimijera. Ure turugadu paeduwo woe. Čemode ia mačebradudo pobe metia bokware. Iamode akai. Iamode Moisés ai. Iamode Elias ai jamedu. ");
INSERT INTO bor_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro, Tiago, João epagudugodure dukodire Pedro makore aino. Dukodire erduwakare tumagomode jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nono ia boetugu ure turawuje etae. Nou boetugu ure taiado ebo. Nono emeardure ia boe emagoji nou boetugu piji. Akore: – Imeardu kurire jiwu itonaregedu reo. Tawiapaga pemegado awu itonaregedu bataruji. ");
INSERT INTO bor_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nono ere tie maedo mare erdukare ia boei pugeje. Tu emagere eragojere nono Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nono ere turawuje nou tori ao piji. Dukejere Jesus makore ei. Akore: – Tareadodukaba tardure jiboeji boe ewiagai. Imedu Onaregedu nure imi. Iewodumode pugeje dukeje tareadodumode awu tardure jiboeji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Emeartorure awu Jesus bataruji. Mare puire enarare. Egore: – Nuburedu jiba akoino pai tuiewodumoduie pugeje? ");
INSERT INTO bor_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dukodire enarare Jesusji. Egore: – Kodiba pawobe erduware Judeu doge eno bakaru jiwuge egore Elias aregodumoduie nou umode boe ekinorudowu otodai? ");
INSERT INTO bor_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus akore: – Pao Kurireu makore boei marigudu Elias aregodumoduie boetoji rugadu. Umoduie boe ewie ewo tudo turugadu nou umode boe ekinorudowu aregoduwo etae rugadu. Mare Pao Kurireu bataru makore boei marigudu boe pegamoduie nou Imedu Onaregeduji. Boe etaidumodukaie nou Imedu Onaregeduji. ");
INSERT INTO bor_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mare inure tawie. Nou Pao Kurireu makore jiwu imedu Elias aregodure marigudu. João Batistare ema. Rore nono Elias ro mogadure. Mare boe etaidukare ji. Pao Kurireu ure boe ewie marigudu ainoie boemoduie nou Eliaji. Nou Pao Kurireu bataru jeture pudui rugadu João Batistaji. ");
INSERT INTO bor_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nono Jesus aregodure nouia ture jorduwadowuge etae Pedro apo, João apo, Tiago apo. Boe emagare nono nou Jesus ure jorduwadowugebo. Ia jorduware Judeu doge eno bakaru jiwuge edure nono ebo jamedu. Etokire pui. ");
INSERT INTO bor_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Boe erdure Jesusji dukeje egarere pudui. Nono eregodure togi. Ekimadure Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mare Jesus unarare ture jorduwadowugei. Akore: – Kaba tawadaru jiba tagagoino nou jorduware Judeu doge eno bakaru jiwugei? ");
INSERT INTO bor_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nono ia imedu rakojere boe etoiadada. Makore Jesusji. Akore: – Ikimijera. Itaregodure itonaregedu apo woe are jorduwadowuge etae. Bope uwari meture awu itonaregedu tada. Dukodire itonaregedu roiwakare tumagowo. ");
INSERT INTO bor_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nou bope uwari ro pegare itonaregeduji. Ure butudo moto ka. Nou itonaregedu jataro aregodure jabiji. Ure tora reko pui. Nono rakagodure. Inogwamagudure are jorduwadowugei ewo nou bope uwari pegareu barigu piji mare ero čekare ji. ");
INSERT INTO bor_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus makore ei. Akore: – Tare ikiarigo. Tameartorukare rugadu. Iragoje raimodukare tagabo. Nuba tagaidure irowo tameartoruwo i? Nono Jesus makore iagei. Akore: – Mato nou iparedu apo itae! ");
INSERT INTO bor_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dukodire boe ere nou iparedu reko Jesus ae. Nou meture nou iparedu tadawu bope uwari jordure Jesusji dukeje ure nou iparedu butudo moto ka pugeje. Magadugodure moto keje. Nou iparedu jataro aregodure ja piji. Dukodire Jesus makore nou iparedu uoji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Akore: – Marigudu na nou bope roino akanaregeduji? Nou iparedu uo akore: – Marigudu rugadu. Imedu rogu biagare tu je dutabore nou bope uwari roino ji jii aino. ");
INSERT INTO bor_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mai karega roino ji. Ure barigu joruto biwo joru tada. Dukeje ure barigu poboto biwo pobo tada. Inogwamagudunure ai. Akogududo čedabo. Aroiware dukeje awu itonaregedu pemegago. ");
INSERT INTO bor_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus akore: – Uu. Mare ameartorumode rugadu dukeje aroiwamode boe jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nou imedu aidure rugadu. Akore: – Imeartorure ai. Imeardae pegareu tawuje ipiji imeartoru raiwo ai rugadu. ");
INSERT INTO bor_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus jordure nou boe emagare turegodu tabo mato pudae duji. Nono mako pegare nou meture nou iparedu tadawu bope uwariji. Akore: – Bope uwari nure aki. Mako bokwareu nure aki. Bija bokwareu nure aki. Atudo awu iparedu piji. Amodukare aremo to pugeje! ");
INSERT INTO bor_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nou bope uwari kudugodure. Nono ure nou iparedu butudo moto ka pugeje. Mare ure tudawuje nou iparedu piji rugadu. Nono nou iparedu ure nono bireuboe mogadure. Nou boe egore: – Bire rugadu! ");
INSERT INTO bor_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mare Jesus ure tugeragu nou iparedu ieraji. Dukejere ure udo turagojedo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nono Jesus ure turemo ia baito. Nono nou ure jorduwadowuge enarare Jesusji. Egore: – Kodiba čeroiwakare čewo nou bope uwari tawuje nou iparedu piji? ");
INSERT INTO bor_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus akore: – Boe emagomodukare baruto dukeje eroiwamodukare tuwo awu bope uwari tawuje boe epiji. Boe enogwamaguduwo baruto nono boe eroiwamode tuwo bope uwari tawuje piji. Ia boe eroiwamodukare tuwo tawuje rugadu. ");
INSERT INTO bor_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus uture nou moto piji ture jorduwadowugebo jii toro nou Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesus meardaere tuwo tudaru kuri boe poru ka jao ture jorduwadowugebo tuwo erduwado nuba boemode pudui duji. Makore ei. Akore: – Imedu Onaregedu nure imi. Imagudumode ro pegareuge etai. Emode iwido. Mare merimode pobe metia bokware i dukejere iewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mare nou Jesus ure jorduwadowuge erduwakare nou Jesus makore jiboeji. Mare epagudure tunarawo Jesusji kaba jiba Jesus akoino pudui. ");
INSERT INTO bor_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesus aregodure Cafarnaum ba kurireu ka ture jorduwadowugebo. Ere turemo ia baito dukeje Jesus unarare ei. Akore: – Tagokire pui awaraji. Kaboba bagaiba tagagoino pui? ");
INSERT INTO bor_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mare emagokare Jesus bataru jipagi. Eiamedu boe etaidure tuwo boe eimijera kurireudo pudumi tumedage epiji. Dukodire etokire pui awaraji. Nono epogurure tumagowo tumeardae boeji Jesus biagai. Dukodire emagokare Jesus bataru jipagi. ");
INSERT INTO bor_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nono Jesus ure tumugudo nou bai tada tumagowo nou ture jorduwadowugei mare jorduware emeardae boeji rugadu. Makore ei. Akore: – Boe eimijera meardaemode nono boe utugare meardae mogadure tuwo boe eimijera pemegareudo pudumi. Boe eimijera romode nono boe utugare ro mogadure tuwo boe eimijera ro pemegareudo pudumi. ");
INSERT INTO bor_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nono Jesus ure tugeragu ia boe etonaregedu roguji. Makore ji rakojewo nono boe etoiadada. Nono ukimadure apo dukeje makore nou ture jorduwadowugei pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Akore: – Boe emode tugera podo boe etonaregedu apo inai itabore ere tugera podo. Boe emode tugera podo itabo ure itarego matowu apore ure tugera podo jamedu. ");
INSERT INTO bor_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","João makore Jesusji. Akore: – Čerdure ia imeduji. Ure bope doge etawuje boe epiji akie tabo. Čemagore ji uwo tugera ra nou turo piji. Ia are jorduwadowu karegure ema. ");
INSERT INTO bor_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mare Jesus makore ei. Akore: – Piji. Umode bope tawuje boe epiji ikie tabo dukeje mako pegamodukare i. ");
INSERT INTO bor_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ro pegakare paiwuge emeardu kurinure pai. ");
INSERT INTO bor_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Inure tawie. Ia boe erduware tameartorure i duji. Nono emode pobo maku tagai taguduwo če dukeje Pao Kurireu umode boe pemegado ei rugadu eroino du moriče. ");
INSERT INTO bor_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus akore: – Boe emode tori kurireu kogudo ia boe ekidoru kajeje tuwo ewarigu poboto dukodire nou ewarigudure pobo towuge ewimode. Mare ia boe umode nou itore meartorure maibari iwuge edo tugera ra ipiji ero pegawo pugeje dukeje boe pegamode nou ure nou boe etore etaora pegadowuji rugadu. Jire boe pegareu kodumode nou barigudure pobo towuge ekori. ");
INSERT INTO bor_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Boe etaidukare tugera kadoduwo tugana piji. Mare tagera umode taro pegado tameartorukawo i dukeje tagera kado tabiji. Mare tagera remawu ji karega inagoino. Tameardae pegareu jire inagoino tawo barigu tabiji. Mare paga karega. Tameartorumodukare i dukeje tawarigudumode bope doge eda kejewu joru maereuto. Nou joru akedumodukare rugadu. Tadumode toro dukeje boe pegamode tai rugadu jii toro rugadu. Mare tameartorumode i dukeje imode tarududo baruto. Tadumode toro dukeje boe pemegamode tai nono jii toro rugadu. Dukodire inagoino tai. Tagera umode mitotu je mare du inodu tabo tameartorure i dukeje tarudumode baruto rugadu tawikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Boe etaidukare tuwure kadoduwo tubogora piji. Mare tawure umode taro pegado tameartorukawo i dukeje tawure kado tabogora piji. Mare tawure remawu ji karega inagoino. Tameardae pegareu jire inagoino tawo barigu tabiji. Mare paga karega. Tameartorumodukare i dukeje tawarigudumode bope doge eda kejewu joru maereuto. Tadumode toro dukeje boe pegamode tai rugadu jii toro rugadu. Mare tameartorumode i dukeje imode tarududo baruto. Tadumode toro dukeje boe pemegamode tai nono jii toro rugadu. Dukodire inagoino tai. Tawure umode mitotu je mare du inodu tabo tameartorure i dukeje tarudumode baruto rugadu tawikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Boe etaidukare tuioku bokwawo. Mare taeku umode taro pegado tameartorukawo i dukeje taeku tawuje tabiji. Mare taeku remawu ji karega inagoino. Tameardae pegareu jire inagoino tawo barigu tabiji. Mare paga karega. Tamodukare tagimijerado Pao Kurireuče dukeje tawarigudumode bope doge eda kejewu joru maereuto. Tadumode toro dukeje boe pegamode tai rugadu. Toro ate doge enogwagemode boei jii toro. Etagedumodukare. Toro joru umode boe ekowu jii toro. Nou joru akedumodukare jii toro rugadu. Mare tamode tameardae pegareu barigu tagaora piji tawo tagimijerado Pao Kurireuče dukeje boe pemegamode tai rugadu. Dukodire inagoino tai. Taeku umode mitotu je mare tameartorure i rugadu dukeje tarudumode baruto rugadu tawikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","– Joru butumode boe eiamedu boe ewugeje. Nou joru umode boe pegareu kowu. Nou boe pemegareu jetumode. ");
INSERT INTO bor_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","– Sal pemegare. Mare sal pegomode dukeje nou sal akedumode. Nono umodukare nono sal mogadure pugeje. Sal umode boe eke pemegado. Tarodo pui nono sal mogadure. Mare sal ji karega inagoino. Tagogududo tagabo. Taro pemegado pui tabemegawo pui rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nono Jesus uture nou moto piji toro Judéia moto ka. Kurugodure Jordão po kajeje. Boe emagare taregodutabo Jesus ae pugeje. Dukodire Jesus ure erduwado nono turo mogadure. ");
INSERT INTO bor_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ia fariseu doge etaregodure Jesus ae jamedu. Etaidure tuwo turokogado Jesusji tuiorduwo ia Jesus ro pegareuji ia Jesus mako pegareuji. Erdumode dukeje emago pegamode ji rugadu. Dukodire enarare Jesusji. Egore: – Nuba Pao Kurireu ure maku Moisés aiwu pago bakaru akore? Ukana turugadu imedu uwo toreduje utudo tubiji tumugukawo apo pugeje? ");
INSERT INTO bor_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus makore ei. Akore: – Nuba nou mariguduwu Moisés ure maku pagaiwu bakaru akore? ");
INSERT INTO bor_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nou fariseu doge egore: – Moisés makore mariguduwuge pawobei. Nou bakaru akore imedu aiduie tuwo tugera ra toreduje piji dukeje uwo ia bapera atugodo tuwo toreduje bie kaba kodiba tuie tugera ra toreduje piji rugadu. Imedu romoduie aino du pegakaie. Uwo toreduje utudo tubiji rugadu. Ainore nou jorduware Pao Kurireu bataru jiwu akore pawobei marigudu. ");
INSERT INTO bor_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus akore: – Uu. Nou mariguduwuge pawobe etaora rakare dukodire etaidukare tuiorduwawo, etaidukare turo pemegawo. Dukodire Moisés ure nou paro maku mariguduwuge pawobe etai ewo tugera ra toreduje piji. ");
INSERT INTO bor_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mare ukare aino boetoji. Pao Kurireu ure baru to. Ure moto to. Dukejere ure imedu boetojiwu towuje. Ure aredu boetojiwudo towuje oreduječe. Ainore Pao Kurireu bataru padure bapera kejewure. ");
INSERT INTO bor_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dukodire imedu utumoduie tuo piji tuje piji tumuguwo toreduje apo dukeje emodukaie pobe pugeje, emoduie mitotu je rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Dukodire imedu mugumode aredu apo dukeje ere mitotu puapo turoi pui dutabo Pao Kurireu jakai. Ainore Pao Kurireu bataru padure bapera kejewure. ");
INSERT INTO bor_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ča Pao Kurireu aidure emugure puapo duji. Dukodire emuguwo puapo jii toro rugadu. Ekawo tugera ra pubiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nono Jesus uture ia bai ka ture jorduwadowugebo. Ere turemo dukeje nou ure jorduwadowuge enarare Jesusji nou Jesus bataru bagai. ");
INSERT INTO bor_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus makore ei. Akore: – Imedu umode tugera ra toreduje piji mare mugumode ia aredu apo pugeje. Du pegare Pao Kurireu jakai. Nou imedu ro peganure nou toreduje boetojiwudoji rugadu. Ure tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aredu jamedu umode tugera ra toredu piji mare mugumode ia imedu apo pugeje. Dutabore ro peganure nou toredu boetojiwuji rugadu. Ure tudo nono jeribarire toredu pijiwudo mogadure Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ia boe etaregodure torebo Jesus ae Jesus uwo tugera bu nou boe etore ewugeje. Mare nou Jesus ure jorduwadowuge etaidukare eroino duji. Emagore nou boei etaregodukaiago torebo Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus jorduware nou inoduji dukodire korigodure nou ture jorduwadowugei. Akore: – Tagaba tawu boe etore ekajeje etaregoduwo itae. Etarego itae rugadu. Boe ewo tumeardae udo nono boe etore emeardae mogadure tuwo tugimijerado Pao Kurireuče rugadu turuduwo baruto. ");
INSERT INTO bor_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Boe jokodu jire inagoino tai. Boe etore emeartorure tuo tuje makore jiboeji. Mare boe etore ji karega inagoino. Boe ewo tugimijerado Pao Kurireuče tumeartoruwo Pao Kurireu bataruji. Dujire inagoino. Boe emeartorumode Pao Kurireuji dukeje emugumode Pao Kurireu apo jamedu. Mare emeartorumodukare Pao Kurireuji dukeje emugumodukare Pao Kurireu apo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nono Jesus ure tona bu nou boe etore ekajeje. Nono ure tugera bu ewugeje. Ure tuwadaru pemegareu bu ewugeje jamedu. ");
INSERT INTO bor_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nono Jesus uture nou boe epiji pugeje. Merure awaraji dukeje ia imedu rekodure Jesus rekodaji aidure tumagowo ji kodi. Aregodure Jesus ae dukeje ure tubu jodo moto keje Jesus bure paru. Makore Jesusji. Akore: – Jorduwareu pemegareu nure aki. Nuba iromode iewoduwo pugeje imuguwo baru tada Pao Kurireu apo du akedukawo? ");
INSERT INTO bor_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus akore: – Ča akagore pemegareu nuie imi. Mare tu Pao Kurireure pemegare tu rugadu. Arduwa kana Pao Kurireu nuie imi rugadu? Aino čare ameardae pemegado ameartoruwo i rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Marigudu arduware nou Pao Kurireu ure maku Judeu doge etaiwu bakaruji. Ure maku etai marigudu. Pao Kurireu akore: “Akaba boe ewido. Aeribarikaba akoreduje piji akoredu piji. Akiwogukaba. Awadrarodukaba boe erore jiboeji. Akaba boe ekiripagado jamedu. Ameartorudo aoji ačeji jamedu.” ");
INSERT INTO bor_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nou imedu akore: – Uu. Iparedurogu ure imi dutabore imeartorure awu bataru jamedu boeji ji aino. ");
INSERT INTO bor_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus aiwore tu nou imeduji. Meardu kurire nou imeduji. Nono makore ji. Akore: – Iaboe kimore arowo ji. Akoe jamedu boe maku diero bagai. Nou ako diero rugadu maku marenarue doge etai. Dukeje Pao Kurireu umode akoe kurido baru tada. Aromode aino dukeje akaregodumode itae pugeje akoduwo itabo. ");
INSERT INTO bor_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nou imedu meardure Jesus bataruji dukeje kiarigodure. Oe kurire dukodire aidukare tuwo toe maku. Je kiarigodure. Kodire uture Jesus piji. Meartorukare Jesus bataruji. ");
INSERT INTO bor_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus aiwore tumebiji ture jorduwadowuge ewagai. Makore ei. Akore: – Kočare. Boe rakare oe kurireugei etaiduwo tuwo tugimijerado Pao Kurireuče tumuguwo Pao Kurireu apo baru tada. Oe kurireuge etaidure tumeartoruwo tu toeji tuwo činorudo. ");
INSERT INTO bor_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nou ure jorduwadowuge erore ta je nou Jesus bataru keje. Mare Jesus makore ei pugeje. Akore: – Itore nure tagi. Boe rakare oe kurireugei etaiduwo tuwo tugimijerado Pao Kurireuče rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Boe rakare oe kurireu imeduji uwo tugimijerado Pao Kurireuče tumuguwo apo nono boe rakare cameloji uwo turemo agulha poroto dumogadure. ");
INSERT INTO bor_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nono Jesus ure jorduwadowuge erore ta je. Egore pui: – Kočare. Ioguduba umode činorudo tuiewoduwo pugeje tumuguwo Pao Kurireu apo? ");
INSERT INTO bor_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus aiwore tu ei. Dukeje akore: – Boe eroiwakare tuwo činorudo rugadu. Mare Pao Kurireu roiware tuwo boe ekinorudo rugadu. Pao Kurireu rakare tuwo boe jamedu boe pemegado boei. ");
INSERT INTO bor_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nono Pedro akore: – Akaiwodo. Čere čegera ra čenoe jamedu boe piji čegoduwo akabo. ");
INSERT INTO bor_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Nono Jesus makore ei. Akore: – Uu. Mare iwo tawie boe remawuji. Boe emode tugera ra tuwai piji, tuo piji, tuje piji, tumanamage epiji, tuwiemage epiji, to boepa piji tugoduwo itabo tuwo boe ewie iwadaru pemegareuji dukeje boe rugadu boe makudumode etai awu moto keje. Ewai kurimode. Etumana mage emagamode. Etuwie mage emagamode. Etuje mage emagamode. Etore emagamode. Eno boepa kurimode. Mare ro pegareuge ero pegamode ei pugeje. Mare ia meri keje eewodumode pugeje emuguwo baru tada jii toro rugadu. Ewimodukare pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Boe emeardae pemegare oe kurireugei dukeje egore boe eimijerage nuie emage mare emeartorumodukare Pao Kurireuji dukeje marenarue doge mode emage. Iage enoe bokware dukodire boe emeardae pegare ei mare emeartorumode Pao Kurireuji dukeje oe kurireuge mode emage toro ia meri keje. ");
INSERT INTO bor_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus uture Jerusalém kawu awaraji ture jorduwadowugebo tuduwo Jerusalém ba kurireu ka. Enodo padure doze. Jesus kodure etododai. Nou ure jorduwadowuge epagudure Jerusalém tadawu boe eimijerageče. Ia boe ekodure eregodaji jamedu. Nou kodure eregodajiwuge epagudure nou boe eimijerageče jamedu. Dukodire Jesus ure tuwuredo. Makore tu nou ture jorduwadowugei nuba boemode pudui duji. ");
INSERT INTO bor_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akore: – Tawiapagado iwadaruji. Padumode Jerusalém ba kurireu ka. Imedu Onaregedu nure imi. Imagudumode nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etai. Imagudumode nou jorduware Judeu doge eno bakaru jiwuge eimijerage etai. Nou boe eimijerage egomode ipegaie. Etaidumode tuwo iwido rugadu. Dukodire emode imagu boe tuginaiwuge ekimijerage etai. ");
INSERT INTO bor_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nou boe ekadakagirimode i. Emode todoguru to i. Emode boeto i bukigu tabo. Emode iwido. Mare merimode pobe metia bokware i dukeje iewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nono Zebedeu ore ime emagore Jesusji. Ia iere Tiago. Uwie iere João. Emagore Jesusji. Egore: – Čegimijera kurireu nure aki. Čedaidure awo iaboe towuje čenai. ");
INSERT INTO bor_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus akore: – Nuba tagaidure irowo tai? ");
INSERT INTO bor_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Egore: – Boe ekimijera kurireu mode aki dukeje boe pemegamode ai rugadu. Amugumode ira kurireu keje nono boe ekimijerage ero mogadure. Dukejere čedaidure čewo čemugudo amegi boe eimijera mugure kejewu ira keje jamedu. Ia čegi čedaidure čemuguwo ira keje akana pemegareu jagwai. Ia čedaidure čemuguwo akana pegareu jagwai jamedu. ");
INSERT INTO bor_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus makore ei. Akore: – Tarduwakare kaba bagaiba tagagoino. Boe pegamode tai nono boe pegamode i dumogadure dukeje taroiwakana tawo taragado tai tagawo tagera ra tameartorure idu piji kana? ");
INSERT INTO bor_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Egore: – Uu. Čemode čeragado čei. Jesus akore: – Inure tawie. Boe pegamode tai rugadu nono boe pegamode i dumogadure. ");
INSERT INTO bor_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mare iroiwakare iwo tamugudo itabo ikana pemegareu jagwai, ikana pegareu jagwai. Pao Kurireu emare ure nou imegiwu pemegado. Tu ema jorduware turomode jiboeji. Emare umode taidure jiwuge emugudo ikana pemegareu jagwai, ikana pegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nouia Jesus ure jorduwadowuge enodo padure dez. Emeardure nou Tiago nou João enogwamagudure jiboeji dukeje ekorigodure nou tumedage pobedu dogei. ");
INSERT INTO bor_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dukodire Jesus makore nou ture jorduwadowuge eiamedu boe ewagai. Enodo padure doze. Jesus makore ei. Akore: – Tarduware boe tuginaiwuge eimijerage erore jiboeji. Ero rakare boei. Boe emeartorure tugimijeragei rugadu. Emeartorumodukare ei dukeje nou boe ekimijerage emode boe pegado nou meartorukare puduiwugei rugadu. ");
INSERT INTO bor_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Ča tarokaba nono nou boe eimijera kurireuge ero mogadure. Ia tagi tagaidumode tawo boe eimijerado tagi dukeje tameardae udo nono boe utugare meardae mogadure tawo boe eimijera pemegareugedo tagi. Boe eimijera romode nono boe utugare ro mogadure tuwo boe eimijera pemegareudo pudumi. ");
INSERT INTO bor_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ainore irore rugadu. Imedu Onaregedu nure imi. Mare itaregodukare iwo boe ekimijerado imi. Itaregodure iwo boe etugaredo imi. Itaregodure iwo imagu boe etai. Itaregodure iwiwo boe ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Etaregodure Jericó ba kurireu ka. Nono Jesus uture nou ba kurireu piji ture jorduwadowugebo. Ia boe ekodure awaraji Jesus apo jamedu. Emagare rugadu. Nono ia imedu joku bokwareu mugure nou awara okwai. Iere Bartimeu. Timeu onaregedu nure ema. Okwamagudure boei nono tuge rogu bagai meri jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Meardure Jesus kodure tugori duji. Dukodire kudugodure Jesus rekodaji. Akore: – Jesus! Davi Onaregedu nure aki! Akogududo itabo! Nou joku bokwareu imedu jorduware Davi uwobe nure Jesus če duji kodire akoino Davi Onaregedu nure ema. ");
INSERT INTO bor_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Boe emagare nono apo. Emago pegare ji mugu kiorowo. Mare kudugodu rakare pugeje. Akore: – Davi Onaregedu nure aki! Akogududo itabo marenaru nure imi! ");
INSERT INTO bor_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus ure tuwuredo. Akore: – Mato apo itae. Nono nou boe emagore nou joku bokwareu imeduji. Egore: – Ča. Akiarigodukaba pugeje. Jesus makore awagai. Aragojedo. ");
INSERT INTO bor_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dukodire ure tugudau areia biaku epa barigu tubiji tuwo tugera jodo mototo tuwo turagojedo. Uture Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus makore ji. Akore: – Kaba jiba akaidure irowo ai? Nou joku bokwareu imedu akore: – Ikimijera nure aki. Itaidure itaiwowo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus akore: – Ča. Ameartorure i dukodire ire apemegago akaiwowo pugeje. Atudo aibagi awai ka. Jesus makore dukeje nou imedu aiwore pugeje tači je. Aiwore pugeje rugadu. Nono kodure Jesus rekodaji nou awaraji. ");
INSERT INTO bor_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus ure taregoduiago Jerusalém ba kurireu ka ture jorduwadowugebo. Epuredugodure boe eda Betfagé ka. Epuredugodure boe eda Betânia ka jamedu. Nou boe eda Betfagé, nou boe eda Betânia eragoje puredure Oliveira Riji. Dukejere Jesus makore ture jorduwadowuge ime pobedu dogei tuwo etudo tododai. ");
INSERT INTO bor_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesus makore ei. Akore: – Tadudo toro nou boe eda ka. Tagaregodumode toro dukeje tardumode ia jumenta onaregeduji. Boe ere kogudo nono duji. Nou jumenta rakojere nono mare ia boe ekare tumugudo keje ji aino. Tamode bukigu kiwuje dukeje tadumode mato apo itae. ");
INSERT INTO bor_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ia boe enaramode tai kaba kodiba taroino apo. Tamagodo ei Boe Eimijera aiduie ji. Tumoduie reko tuibagi kuri je. ");
INSERT INTO bor_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dukodire nou ime pobedu doge eture nou boe eda ka. Erdure nou jumenta onaregeduji nono Jesus bataru mogadure. Kogure ia bai poro keje. Ere nou bukigu kiwuje dukeje ia boe enarare ei. ");
INSERT INTO bor_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Egore: – Mure kodiba tamode tageragu nou jumenta onaregeduji? ");
INSERT INTO bor_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nou ime pobedu doge emagore nou Jesus makore puduiboe tabore emagore nou boe ewadaru jipagi. Dukodire nou boe emago pegakare etuwo apo. ");
INSERT INTO bor_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Etaregodure Jesus ae nou jumenta onaregedu apo dukeje ere padure tuwugejewu tugudau areia boe bu nou jumenta onaregedu poru keje. Nono Jesus ure tumugudo nou jumenta keje. ");
INSERT INTO bor_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Boe emagare nono. Ere padure tuwugejewu areia boe bu nou Jesus kodure jiwu awaraji. Ia boe ere bai kado. Ere nou bai bu awara keje jamedu. ");
INSERT INTO bor_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Boe emagare rugadu tugodu tabo Jesus apo. Eture tiegarere pudui dutabo rugadu. Dukodire ewadodu rakare Pao Kurireu ie tabo. Egore: – Pao Kurireu pemegare! Pagimijera reo! Pameartoruwo ji nono mariguduwuge pao mage emeartorure tugimijera kurireu Davi jitu mogadure. Pao Kurireu ure arego mato pagae. Uwo boe pemegado ji rugadu! Boe eiamedu boe emago pemegawo ji rugadu moto keje, baru tada jamedu. ");
INSERT INTO bor_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus aregodure Jerusalém ba kurireu ka dukeje uture Pao Kurireu uwai ka. Ure turemo dukeje aiwore boe parugajeje boe jamedu boeji. Mare merirekodure dukodire uture pugeje. Uture Betânia ba kurireu ka tuibagi pugeje ture jorduwadowugebo. Enodo padure doze. ");
INSERT INTO bor_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nou barogwato Jesus utuiago tuibagi boe eda Betânia piji ture jorduwadowugebo. Mare Jesus uke boeire ji. ");
INSERT INTO bor_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesus aiwo jaere dukeje jordure ia figo iji. Nou figo i arure rugadu. Dukodire uture ka taiwowo tudu kurodureu bagai. Mare jordukare boeji. Jordure tu nou aruji. Nou i tudumodukare nou ariji. ");
INSERT INTO bor_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nono Jesus mako pegare nou figo iji. Akore: – Boe emodukare akurodu kowuje pugeje awimode kodi. Nou Jesus ure jorduwadowuge emeardure nou Jesus akoe nou figo i jituji. ");
INSERT INTO bor_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Etaregodure Jerusalém ba kurireu ka pugeje. Jesus uture Pao Kurireu uwai ka. Ure turemo nono. Jordure nou boei ere tagu ie metugoe emagu diero bagai duji, ere diero maku puai duji. Dukodire korigodure. Ure nou boe enoe rugadu barigu. Ure emugure kejewu ira rugadu boe barigu. Ure nou metugoe meture tadaboe rugadu barigu. Ure nou boe etudo Pao Kurireu uwai piji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Makore boe eiamedu boei etaregodukawo toe tabo pugeje Pao Kurireu uwai ka. ");
INSERT INTO bor_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nono makore boei tuwo erduwado. Akore: – Moto rugadu boe kejewuge etaregoduwo awu Pao Kurireu uwai ka tumagowo Pao Kurireu bagai baruto. Ainore Pao Kurireu akore. Ainore bapera atugo ure. Mare tare awu Pao Kurireu uwai udo nono iwogureuge ewai mogadure. ");
INSERT INTO bor_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emeardure nou inoduji. Nou jorduware Judeu doge eno bakaru jiwuge emeardure nou inoduji jamedu. Dukejere eiamedu boe ekorigodure Jesusji. Etaiwore ia tumeardae bagai tuwo Jesus bito. Mare boe doge etaidure Jesusji. Egaregodure pudui Jesus rore jiboeji, makore jiboeji. Dukodire nou boe eimijerage epagudure turo pegamode Jesus jituji tumode nou boe doge ekorigo pudui dukodi. ");
INSERT INTO bor_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Merirekodutabo Jesus uture Jerusalém ba kurireu piji ture jorduwadowugebo. ");
INSERT INTO bor_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nou barogwato ča je Jesus merure awaraji pugeje ture jorduwadowugebo. Nono erdure nou figo iji pugeje. Ma kočare nou figo i bire rugadu. ");
INSERT INTO bor_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nono Pedro biabuture Jesus makore jiboe keje. Dukodire makore Jesusji. Akore: – Akaiwodo. Awu amago pegare jiwu figo i bire rugadu. ");
INSERT INTO bor_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus akore: – Tameartorudo Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Boe jokodu jire inagoino tai. Tamororamagadukaba. Tameartorudo rugadu. Tameartorumode dukeje tamagomode nou tori riji uwo tuwarigu pobo maereuto. Tamagomode ji dukeje barigudumode pobo maereuto rugadu. Mare tameartorumodukare dukeje umodukare tuwarigu. ");
INSERT INTO bor_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dukodire tamagomode Pao Kurireu bagai baruto iaboe bagai, tameartorumode makudumode tagai duji dukeje Pao Kurireu umode tamagore bagaiboe maku tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Tamagomode baruto dukeje tawiagodudo boe ero pegare taidu piji. Dukodire baru tadare Pao Kurireu biagodumode taro pegare jiboe piji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus aregodure Jerusalém ba kurireu ka pugeje ture jorduwadowugebo. Jesus merure Pao Kurireu uwai kurireu oiagi. Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge, nouia Judeu doge eimijerage eiamedu boe etaregodure Jesus ae jamedu. ");
INSERT INTO bor_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eiamedu boe emagore Jesusji. Egore: – Ioguduba ure turaga maku akai aro rakawo aino? ");
INSERT INTO bor_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus makore ewadaru jipagi. Akore: – Inaramode tai iaboeji jamedu. Tamagomode iwadaru jipagi dukeje imagomode tawadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ča ioguduba ure João Batista udo boe etao pegodo? Pao Kurireu koia kana? Ia boe eigoia kana? Nuba tameardaere? Tamagodo. ");
INSERT INTO bor_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mare nou boe eimijerage erduwakare tumagowo Jesus bataru jipagi. Dukodire emagore pui nuba tagomode Jesus bataru jipagi. Egore: – Pamagomode Pao Kurireu koiaie ure João Batista udo boe etao pegodo mare pameartorukare nou inoduji. Awu Jesus jorduware pameartorukare nou inodu jituji. Dukodire pagagomode aino dukeje Jesus umode pawadaru pogurudo. Akomode: “Kodiba tameartorukare ji?” Ainore akomode pai. ");
INSERT INTO bor_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mare pagagomodukare boe eigoiaie. Boe eiamedu boe emeartorure João Batista makore Pao Kurireu bataru jituji. Egore Pao Kurireu koiare ure João Batista udo boe etao pegodo. Dukodire nou boe eimijerage epagudure tumago pegawo João Batista rore jiboeji tumode boe ekorigo pudui dukodi. ");
INSERT INTO bor_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nono nou boe eimijerage emagore Jesusji. Egore: – Čerduwakare ioguduba koiare ure João Batista udo boe etao pegodo. Nono Jesus makore ei. Akore: – Ča tamagokare iwadaru jipagi dukodire imagomodukare ioguduba ure itarego mato jamedu. ");
INSERT INTO bor_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus readodure ia bakaruji boe ewiagai tuwo ewie Pao Kurireu meardae remawuji. Akore: – Marigudu ia imedu ure uva tugu to boepa tada. Ure ramiku aiado to boepa tabo. Ure ia moto porodo tuwo tuwuredo nou uva kurodu keje tuwo kuru tawuje. Ure ia tugamo pemegado boe ewo tumugudo toro aogeje taiwo pemegawo boepaji. Nono ure tugeragu ia boei tuwo etudo nou to boepaji emaragoduwo ji. Nono nou ore boepa čewu uture epiji tugiriadu tabo toro ia boe eda jaereu ka. ");
INSERT INTO bor_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nou boepa tadawu uva kurodumode kejewu ari puredugodure dukeje nou ore boepa čewu ure tudugare utudo toro nou jeture to boepa jiwuge boe etae nou tugiriadure kawu moto piji. Ure nou tudugare utudo uwo tugeragu nou makudumode pudaiwu boeji. Nou jeture nou boepa jiwuge emode uva rugadu kado dukeje emode ia kado puiato nou ore boepa čewu imedu ai. ");
INSERT INTO bor_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ča nou utugare aregodure nou boepa ka. Mare nou jeture boepa jiwuge etaidukare tuwo uva kado puiato pugeje nou ore boepa čewu imedu ai. Dukodire ere tugeragu nou ore boepa čewu utugareji. Ere boeto ji. Dukeje ere utudo tuibagi tugimijera ae tugera kedo tabo. ");
INSERT INTO bor_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nono nou ore boepa čewu ure ia tudugare utudo etae pugeje. Mare nou jeture boepa jiwuge ere boeto nou utugareji pugeje. Ere boeto aoraji. Ero pegare ji rugadu. Ere utudo tuibagi tugera kedo tabo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nono nou ore boepa čewu ure ia tudugare utudo etae pugeje. Mare ere nou utugare bito. Nou ore boepa čewu ure tudugarege emagado toro etae rugadu. Mare nou jeture boepa jiwuge ero pegare nou ore boepa čewu utugarege eiamedu boei. Ere boeto ei. Ere iage ewido. ");
INSERT INTO bor_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nono nou ore boepa čewu onaregedu imedu ure mitotu je. Meardu kurire nou tonaregeduji rugadu. Čare ure nou tonaregedu utudo toro nou jeture boepa jiwuge ewagai aino boigodu. Nou ore boepa čewu akore: “Emeartorumode itonaregeduji rugadu.” ");
INSERT INTO bor_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","– Mare nou jeture boepa jiwuge emagore pui. Egore: “Awu ore boepa čewu onaregedu reo. Emare omode tuo oe jamedu boeče. Pawo bito pagowo awu uo o motoče.” ");
INSERT INTO bor_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","– Dukodire nou jeture boepa jiwuge ere tugeragu nou ore boepa čewu onaregeduji. Ere bito. Ere barigu toro nou boepa piji. ");
INSERT INTO bor_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesus mako kimore nou boei. Akore: – Ainore erore rugadu. Ča. Nuba nou ore boepa čewu romode nou jeture boepa jiwugei? Aregodumode etae. Umode ewido. Nono umode to boepa maku iage etai etuwo ji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mare tagaiwokare rugadu ia padure bapera kejewu Pao Kurireu bataruji kana? Ainore awu Pao Kurireu bataru akore: – Boe emeardae pegare ia toriji. Egore pegaie tuwo tuwaido ema. Mare nou tori pemegareu nure ema rugadu boe ewo tuwaido ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","– Pao Kurireu koiare ure nou tori pemegado aino. Ure pemegado nouia tori jamedu boe ekori. Boe eiamedu boe ebogodure nou Pao Kurireu roino duji. ");
INSERT INTO bor_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judeu doge eimijerage emeardure Jesus akoino jiboeji dukeje erduware puduire Jesus akoino duji. Dukodire etaidure tuwo tugeragu Jesusji tuwo tugu baičoreuto kuri je rugadu. Mare boe etaidure Jesusji. Dukodire nou boe eimijerage epagudure, eroiwakare tuwo tugeragu Jesusji. Dukodire eture piji. ");
INSERT INTO bor_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Judeu doge eimijerage ere fariseu doge etudo Jesus ae. Ere ia aidure Herodes jiwuge etudo Jesus ae jamedu. Judeu doge eimijerage emagore nou boei etuwo Jesus ae tunarawo ji tuwo Jesus barigu boeto tagoino jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dukodire etaregodure Jesus ae. Emagore Jesusji. Egore: – Boe eimijera nure aki rugadu. Akare awadaru udo paga boei. Ameardaere boei boe remawu tabo. Boe jokodu jire akagoino. Awiapagakare boe ewadaru pegareuji. Ameardaere Pao Kurireu meardaeji. Are boe erduwado Pao Kurireu meardaeji tu tu je. Awiapagakare ia boe emeardae pegareuji rugadu. Ča. Nuba pago bakaru umode parduwado paromode jiboeji? Pamode pagoe imposto mori maku Roma kejewu boe eimijera kurireu César ai na? Pamode maku kana? Pamodukana maku kana? ");
INSERT INTO bor_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mare Jesus jorduware emeardae pegareuji. Jorduware emeartorukare tuwadaruji. Akore: – Kaba kodiba tagaidure tawo iwarigu boeto tagagoino idu tabo? Ia imposto morireu diero tori maku inai iorduwo ji. ");
INSERT INTO bor_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ere ia diero tori maku Jesus ai. Nono Jesus akore: – Ioguduba je ba padure awu diero tori keje? Ioguduba ie ba padure awu diero tori keje? Egore: – Roma kejewu boe eimijera kurireu César ie padure keje. ");
INSERT INTO bor_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nono Jesus akore: – Boe rugadu. Čare César oeboe maku César ai. Mare Pao Kurireu oeboe maku Pao Kurireu ai jamedu. Nou boe emeardure Jesus akoino duji dukodire erore ta je akoino pudui duji. ");
INSERT INTO bor_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nono ia saduceu doge etaregodure Jesus ae tuwo Jesus barigu boeto tagoino jiboeji jamedu. Nou saduceu doge emeardaere boe eewodumodukaie pugeje. Nono emagore Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Egore: – Jorduwareu imedu nure aki. Ča mariguduwu makore Pao Kurireu bataru jiwu Moisés ure jaoboe ero maku etai pameartoruwo ji jii aino rugadu. Akore imedu bimoduie mare ore bokwaie dukeje nou imedu uwie muguwo nou tumana bireu oreduje apo torewo nou bireu tumana ai. ");
INSERT INTO bor_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ča ia meri keje ime enodo padure sete. Etumana etuwie mage nure pugi. Etumana mugure ia aredu apo. Mare čare bire. Mare ore bokware. ");
INSERT INTO bor_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dukodire nou uwie imedu mugure nou aredu apo. Mare nou imedu bire jamedu. Etore bokware. Nono uwie imedu mugure nou aredu apo jamedu. Mare bire jamedu. ");
INSERT INTO bor_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dukodire nou uwie ime eiamedu boe emugure nou aredu apo rugadu. Mare eiamedu boe ewire. Etore bokware. Dukeje čare nou aredu bire jamedu. ");
INSERT INTO bor_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dukodire čedaidure čenarawo ai. Pao Kurireu umode eewodudo pugeje dukeje duboba mugumode nou aredu apo? Eiamedu boe emugure apo moto keje mare duboba mugumode nou aredu apo baru tada? ");
INSERT INTO bor_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus makore nou boe ewadaru jipagi. Akore: – Tarduwa bokware. Tarduwakare Pao Kurireu bataru padure kejewu baperaji. Tarduwakare Pao Kurireu ro rakareuji. ");
INSERT INTO bor_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bireuge eewodumode pugeje dukeje emode nono Pao Kurireu utugarege baru tadawuge emogadure. Etuwiremodukare. Etugogemodukare. ");
INSERT INTO bor_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mare tameardaere boe eewodumodukaie pugeje. Tagaiwokare Moisés ure bu bapera kejewu Pao Kurireu bataruji? Pao Kurireu ure Moisés jordudo pudui ia enado i piji. Joru čere nou enado ito mare nou joru ukare nou enado i kowu. Nou enado i pijire Pao Kurireu makore Moisesji. Akore: “Abraão meartorure jiwu Pao Kurireu nure imi. Isaque meartorure jiwu Pao Kurireu nure imi. Jacó meartorure jiwu Pao Kurireu nure imi.” ");
INSERT INTO bor_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pao Kurireu makore jiwu ime ewire marigudu. Mare Pao Kurireu makore emeartoruie pudui rugadu. Dukodire parduware eewodure pugeje duji. Bireuge emeartorumodukare Pao Kurireuji. Eewodureuge emeartorumode ji. Dukodire tameardae ukare turugadu. Boe eewodumode pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ia jorduware Pao Kurireu ure maku etaiwu bakaru jiwu meardure nou Jesus bataruji. Jorduware Jesus mako pemegare nou saduceu doge ewadaru jipagi duji. Mare meardaere tunarawo Jesusji jamedu. Akore: – Kakojiwu Pao Kurireu bataru pemegareu remawu jiba pamode pageragu? ");
INSERT INTO bor_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Jesus akore: – Ere pobe. Boetojiwu bataru kurireu ure aino: “Pao Kurireu ure mitotu je. Tameardu kurido Pao Kurireuji taraga tabo, tameardae pemegareu tabo, tarore jiboe jamedu boe tabo. Judeu doge eiamedu boe erduwawo awu bataruji rugadu.” Ainore Pao Kurireu bataru kurireu boetojiwu ure. ");
INSERT INTO bor_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pao Kurireu bataru boigoduwu ure aino: “Tameardu kurido tamedagei nono tameardu kuri moga tai dumogadure.” Ia bataru kurireu bokware nono awu bataru pobedu doge emogadure. ");
INSERT INTO bor_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nou jorduware Judeu doge eno bakaru jiwu imedu makore Jesusji pugeje. Akore: – Awadaru ure turugadu. Jorduwareu nure aki. Boe jokodu jire akagoino. Pao Kurireu ure mitotu je. Ia boe umodukare nono umogadure. ");
INSERT INTO bor_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Boe emeardu kuriwo Pao Kurireuji turaga tabo, tumeardae pemegareu jamedu boe tabo. Boe emeardu kuriwo tumedagei nono tumeardu kuri moga pudui dumogadure. Boe emeartorumode awu Pao Kurireu bataru kurireu boetojiwuji dukeje emeartorumode Pao Kurireu bataru jamedu boeji. Boe emode boe egu barogo rogu bito tuwo maku Pao Kurireu ai turo pegareu boe moriče. Emode boe egu barogo rogu kodu kowu tuwo tomeado če Pao Kurireu ai. Mare emeardu kurimode Pao Kurireuji rugadu emeardu kurimode tumedagei rugadu. Dure pemegare nou turo boe egu barogo rogu jitu kori rugadu. ");
INSERT INTO bor_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus meardure nou imedu bataruji. Jordure ji jorduware Pao Kurireu bataru jiwu nure ema duji. Dukodire Jesus makore ji pugeje. Akore: – Arduware awo akimijerado Pao Kurireuče. Ča. Ameartorudo ji rugadu. Nono boe eraga bokware tunarawo Jesusji pugeje. Eraga bokware tuwo Jesus barigu boeto tagoino jiboeji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus ure boe erduwado Pao Kurireu uwai tada. Nono unarare boei. Akore: – Jorduware Judeu doge eno bakaru jiwuge ere boe erduwado nou umode boe ekinorudowuji. Egore Davi onaregedu moduie ema. Mare erduwa pemegakare Pao Kurireu bataruji ");
INSERT INTO bor_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pao Kurireu Uwari ure Pao Kurireu bataru maku Davi ai marigudu. Dukodire Davi akore: – Pao Kurireu makore nou ikimijera umode boe ekinorudowuji. Akore: “Amugudo woe ikana pemegareu jagwai jii toro imode nou jordu pegare aiwuge etagedudo du ka.” ");
INSERT INTO bor_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","– Tagoino dutabo Davi akore tugimijera nuie nou umode boe ekinorudowuče. Mare Davi onaregedu mode ema jamedu. Ča nuba nou umode boe ekinorudowu ure? Boe emagare nono tuwiapaga tabo Jesus bataruji. ");
INSERT INTO bor_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nono Jesus ure erduwado rugadu. Akore: – Tagaiwo pemegado jorduware Judeu doge eno bakaru jiwugei. Etaidure boe emeartoruwo pudui. Ere boe etaiwodo tugudau areia motureu meture pudui duji. Etaidure tuwo boe epogurudo. Etumode ba kurireu ka dukeje etaidure boe emago pemegawo pudui etaidure boe ekimijeragewo pudumi kodi. Dukodire erore aino. ");
INSERT INTO bor_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nou jorduware Judeu doge eno bakaru jiwuge etumode Judeu doge ere bato puiwu bai ka dukeje emode tugeragu boe eimijera mugure kejewu iraji tumuguwo keje. Etumode boe ewadae ka dukeje etumode boe eke jeture kejewu ira ka boe etododai togwagewo boetoji. ");
INSERT INTO bor_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eragojemode boebo dukeje emago raimode baruto boe emearduwo tagoi tuwadaru motureu jituji. Mare pagatu je. Ekiwogure okoge bokwareuge aremei. Ere nou areme okoge bokwareuge ewai aru epiji. Dukodire Pao Kurireu ro pegamode ei rugadu nou ero pegareu boe moriče. ");
INSERT INTO bor_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus ure tumugudo nono Pao Kurireu uwai tada taiwo tabo boei. Ere ia to diero tugu ira jagi tuwo maku Pao Kurireu ai. Oe kurireuge ere ture tuguboe kurido rugadu. ");
INSERT INTO bor_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nono ia okoge bokwareudo aredu marenaru aregodure. Nou okoge bokwareudo ure to diero tori rogu pobedu tugu nou ira jagi. Ure nono um centavo mogadure. ");
INSERT INTO bor_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nono Jesus makore nou ture jorduwadowugei. Akore: – Iwo tawie boe remawuji. Awu marenaru aredu okoge bokwareudo ure to diero jamedu boe maku dukodire ure to diero makudu kurido nou oe kurireuge eiamedu boe ekori. ");
INSERT INTO bor_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mare diero kurireu ji karega inagoino. Nou oe kurireuge ere to diero kurido Pao Kurireu ai mare etaidukare jiwu kobo rogure ere maku. Eno diero kurire ebo kimo. Mare awu aredu ure to diero rugadu maku. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nono Jesus ure tudawuje Pao Kurireu uwai piji ture jorduwadowugebo. Ia akore: – Ikimijera. Akaiwodo. Awu Pao Kurireu uwai moture rugadu, rakare jamedu. ");
INSERT INTO bor_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mare Jesus makore nou ture jorduwadowugei. Akore: – Awu tardure jiwu bai rakare, moture. Mare ro pegareuge emode nou tardure jiwu bai kurireu butudo rugadu. Tori tabore pawobe ere towuje marigudu. Mare ia meri keje nou tori jamedu boe epadumodukare puaoji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus uture Oliveira Ri ao ka. Mugu jaekare Pao Kurireu uwai piji. Jesus ure tumugudo nono. Pedro, Tiago, João, André eiamedu boe etaregodure Jesus ae. Ia boe edukare nono ebo. Nono enarare Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Egore: – Kaba meri kejeba Pao Kurireu uwai butumode, nou akagoino jiboe jetumode pudui kuri aino na? Kaba jiba čerdumode čerduwawo nou akagoino jiboe jetumode pudui kuri aino duji? ");
INSERT INTO bor_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus makore ei. Akore: – Taeku jado boe ekawo taekiripagado. ");
INSERT INTO bor_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Boe emagamode tuwadaru pegareu tabo. Egomode umode boe ekinorudowu nuie pudumi. Mare pagare egoino. Mare du inodu tabo emode boe ekiripagado rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tameardumode bakaru pegareuji. Boe emode tawie boe erugoduie pui tuwaiga tabo. Boe erugodu akedukaie. Boe egomode nou torowu boe ekorigoduie dukodie erugodu kurie pui rugadu. Mare taragado tai tamororamagadukawo. Pao Kurireu jorduware ro pegareuge erugoduji marigudu. Umodukare nou erugodu tawuje epiji. Erugodumode pui tuwaiga tabo rugadu mare moto akedumodukare raga. ");
INSERT INTO bor_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Boe eimijera kurireuge erugodumode pui tugobaigaregebo. Boe eke bokwamode boe jamedu boe parugajeje. Dukodire boe ewimode tuge boei koia. Moto magadugodumode boe jamedu boe parugajeje jamedu. Awu inagoino jiwu iwadaru jetumode pudui dukeje tarduwamode moto akedumode kuri aino duji nono aredu kurijirigodu mogadure. Aredu kurijirigodure dukeje boe erduware kuri butumode kuri aino duji. Mare aredu kurijirigodu ji karega inagoino. Boe pegamode motoji nono iwadaru mogadure dukeje tarduwamode moto akedumode kuri aino duji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Taeku jado. Boe emode tugeragu tai. Emode tadugu baičoreuto. Etaiwomode ia taro pegare jiboe bagai. Emode boeto tai Judeu doge ere bato puiwu bai tada. Tameartorure i kodire boe eimijera kurireuge emagomode tawagai. Dukejere tamagodo iwadaru pemegareuji ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Boe eiamedu boe emeardumode iwu bakaru pemegareuji moto jamedu boe parugajeje dukeje moto akedumode. ");
INSERT INTO bor_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Boe emode tadugu baičoreuto. Emagomode tai ia taro pegareu bagai. Mare tamororamagadukaba tamagore jiboe bagai. Tamagomode mare tawadaru karega. Pao Kurireu Uwari umode tuwadaru maku tagai tamagowo ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Boe emode tuwiemage emagu boe eimijerage pegareuge etai ewidoduwo. Boe emode tore emagu boe eimijerage pegareuge etai ewidoduwo. Boe etore emode tuo tuje emagu boe eimijerage pegareuge etai ewidoduwo. ");
INSERT INTO bor_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tameartorumode i kodire boe eiamedu boe erdu pegamode tai. Mare tamodukare tagera ra tameartorure i dupiji kodire imode taginorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesus makore kimo. Akore: – Tardumode nou Pao Kurireu jordu pegare jiboeji Pao Kurireu uwai tada dukeje tarduwamode boe pegamode kuri aino duji. Tardumode nou inoduji kodire inagoino tai. Boe erdumode awu bataru padure kejewu baperaji rugadu. Mare boe erdumode nou Pao Kurireu jordu pegare jiboeji Pao Kurireu uwai tada dukeje Judéia moto kejewuge eregodu rakamode toro tori ao ka tuwo tuginorudo boe pegareu piji. ");
INSERT INTO bor_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nou rakojere tuwai aogejewuge eregoduwo tuwai piji toro tori ao ka. Ekawo turemo tuwaito iaboe bagai. Etuwo tugera kedo tabo. ");
INSERT INTO bor_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nou maragodure to boepa jiwuge eregoduwo nou to boepa piji toro nou tori ao ka jamedu. Ekawo tugirimi tuwai ka ia tugudau areia bagai. ");
INSERT INTO bor_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nou Pao Kurireu jordu pegare jiboe rakojemode Pao Kurireu uwai tada dukeje boe pegamode boei rugadu. Dukodire inagoino boei eregoduwo rugadu toro tori ao ka. Nou meriji boe pegamode kuiarureugei rugadu. Boe pegamode ei rugadu eroiwakare turegodu rakawo dukodi. Boe pegamode etore kugure etuje magei jamedu eroiwakare ture rakawo dukodi. ");
INSERT INTO bor_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tamagodo baruto Pao Kurireu bagai biaku butukawo boei nou eregodure jiwu meri keje. ");
INSERT INTO bor_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Boe pegamode boei rugadu boe pega jamedu boe kori. Pao Kurireu ure moto to dupiji boe erdukare awu boe pegareu boeji jii aino. Mare boe pegamode motoji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nou boe pegamode kejewu meri makamode. Mare Pao Kurireu umode nou merido biagatu je pugeje. Nou boe pegamode kejewu meri makamode rugadu dukeje boe eiamedu boe ewimode rugadu. Mare Pao Kurireu umode nou boe pegamode kejewu merido biagatu je tuwo meartorure puduiwuge edo činorudo. ");
INSERT INTO bor_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mare boe pegamode kejewu meri aregodumode dukeje boe egomode: “Umode boe ekinorudowu aregodu. Ema reo!” Ainore boe egomode. Mare tawiapagakaba ewadaruji. Pagare egoino. ");
INSERT INTO bor_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mare paga karega inagoino. Boe etaregodumode rugadu nou tuwadaru tabo rugadu. Egomode umode boe ekinorudowu nuie pudumi. Mare pagare egoino. Egomode tumagoie Pao Kurireu bataruji mare pagare egoino. Ero rakamode boe emeartoruwo pudui Pao Kurireu piji pagatu je. Emodukare meartorure Pao Kurireu jiwuge remawuge ekiripagado. Mare etaidumode tuwo meartorure Pao Kurireu jiwuge ekiripagado nou turo rakareu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dukodi čare taeku jado. Pagare eroino tai. Tameartorukaba ei. Ire tawie boe jamedu boeji marigudu. ");
INSERT INTO bor_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","– Boe pegare moto jiboe akedumode dukeje meri joku akedumode jamedu. Ari joku akedumode jamedu. ");
INSERT INTO bor_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kuieje doge ewudumode baru piji jamedu. Baru magadugodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dukejere čare boe erdumode Imedu Onaregedu aregodumode tugodu tabo boetugu aojitu duji. Erdumode Imedu Onaregedu ro rakareuji. Erdumode Imedu Onaregedu o jorugu kurireuji. Jorugure moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Umode Pao Kurireu utugarege baru tadawuge etudo tododai Pao Kurireu ure tugeragu jiwuge ewagai moto jamedu boe parugajeje. Emode edo tudo pui. ");
INSERT INTO bor_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesus mako kimore. Akore: – Figo i ure tarduwado tu tu je. Figo i okurogu boture dukeje tarduware bubutumode kuri je rugadu. Tagaiwore figo iji tarduwawo bubutumode kejewu meriji. Ainore tarore tu tu je. ");
INSERT INTO bor_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ča ire tawie nuba boemode meri jokuji nuba boemode ari jokuji. Iwo tawie. Tagaiwodo awu ire tawie jiboe jamedu boeji emode tarduwado dubagai. Tardumode ire tawie jiwu iwadaru jetumode pudui duji dukeje tarduwamode boe puredugodure itaregoduwo iwo boe jamedu boe akedudo. Mare bubutu ji karega inagoino. Nou itaregodumode jiwu meri jire inagoino. ");
INSERT INTO bor_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iwo tawie boe remawuji. Toro ia meri keje ia tawobe erdumode awu imagore jiboe jeture pudui duji rugadu. Jetumode pudui rugadu tuwimodedu otodai. ");
INSERT INTO bor_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Baru akedumode. Moto akedumode jamedu. Mare iwadaru akedumodukare jii toro rugadu. Jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nono Jesus mako kimore. Akore: – Boe erduwakare nou meriji rugadu. Boe erduwakare kaiba meri jetumode awu iwadaru jetuwo pudui. Pao Kurireu utugarege baru tadawuge erduwakare. Pao Kurireu Onaregedu jorduwakare. Tu Pao Kurireu jorduware tu rugadu. ");
INSERT INTO bor_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tarduwakare itaregodumode kejewu meriji. Dukodire tado tarugadu. Tagaiwodo itaregodumode dubagai. ");
INSERT INTO bor_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iromode nono ia imedu ro mogadure. Utu jaere tugiriaduwo. Ure tudugarege etu pemegado tuwaiji. Ure emaragodae maku etai. Ure ia tudugare rakojedo bai poro keje. Makore nou tudugareji jetu pemegawo nou bai poroji tubaga tabo tuwagai. ");
INSERT INTO bor_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iromode nono nou imedu ro mogadure. Dukodire inagoino tai taeku jaewo. Tarduwakare kaba meri kejeba itaregodumode. Itaregodumode boečoji rakudu, meriji rakudu, baburedugodutabo rakudu, čaboečoto rakudu, merirekodutabo rakudu. Tarduwakare. ");
INSERT INTO bor_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Dukodire tado tarugadu tabaga tabo iwagai. Itaregodumode tači je. Itaidukare iorduwo tai tameartorukare i dutabo. ");
INSERT INTO bor_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dukodi inagoino tai. Inagoino boe eiamedu boei. Tado tarugadu tabaga tabo iwagai. ");
INSERT INTO bor_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Merimode pobe dukeje Judeu doge emode tuwadae Páscoa towuje. Nou ewadae kejere emode ia tuge amireu tuginaiwu kowuje. Fermento metukare nou amireu tada. Čare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etaidure tuwo tugeragu Jesusji tuwo bito. Nou jorduware Judeu doge eno bakaru jiwuge etaidure tuwo Jesus bito jamedu. Mare etaidukare boe erduwawo nou tumeardae pegareuji. ");
INSERT INTO bor_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Emagore pui. Egore: – Pamode pageragu Jesusji nou Judeu doge ewadae keje dukeje boe ekorigodumode pai rugadu. Emode bato pui turo pegawo pai. Dukodire paromodukare aino ewadae keje. ");
INSERT INTO bor_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus rakojere boe eda Betânia keje Simão uwai tada. Nou Simão iere Biri Pegareu jamedu. Jesus mugure nono nou bai tada ira keje togwage tabo. Nono ia aredu aregodure Jesus ae poari rogu tabo. Boe ere nou poari towuje tori tabo. Nou tori iere alabastro. Roreboe mori kurireu meture nou poari rogu tada. Boe ere nou roreboe towuje nardo tabo. Nono ča nou aredu ure nou poari rogu jado. Ure nou roreboe redo Jesus aora joki. ");
INSERT INTO bor_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Boe erdure nou aredu roino duji dukeje iage emago pegare nou aredu roino Jesus jituji. Egore: – Awu aredu ro pegare. Ure nou roreboe barigu. Nou roreboe mori kurire rugadu. Boe emaragodumode jii joru akedu ka tuwo tugeragu nou diero kurireuji tuwo akirodo nou roreboeji. Kočare ukare nou roreboe maku diero bagai tuwo diero kurido tuwo maku marenarue doge etai? Nono emago pegare nou areduji. ");
INSERT INTO bor_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mare Jesus makore nou boei. Akore: – Tagaba awu aredu pogurudo rore iduji. Rore i du moture Pao Kurireu jakai. Mare paga karega. ");
INSERT INTO bor_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Marenarue doge edumode tagabo jii toro rugadu. Tagaidumode taro pemegawo ei dukeje taro pemegado ei tagaidure jiwu meri keje. Mare imire itumode tabiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Awu aredu jorduware nou inoduji dukodire ure nou roreboe redo iogi tuwo iwiri udo turugadu ituguduwo mototo iwi keje. ");
INSERT INTO bor_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ča iwo tawie boe remawuji. Awu aredu rore iboe akedumodukare boe etaora piji jii toro rugadu. Boe etumode moto jamedu boe parugajeje tuwo boe erduwado emeartoruwo i iwo ekinorudo dukeje ereadodumode awu aredu rore iduji boe eiamedu boe ewiagai. Dukodire boe ewiagodumodukare awu aredu piji rugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nou Jesus ure jorduwadowu Judas Iscariotes uture toro nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etae. Judas Iscariotes makore ei tumoduie Jesus maku etai. ");
INSERT INTO bor_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Egarere nou Judas Iscariotes makore pudui boeji rugadu. Dukodire egore tumoduie diero maku ai. Du nou meri pijire nou Judas Iscariotes aiwore Jesus rore jiboeji tuiorduwo tumode Jesus maku boe eimijerage pegareuge etaiwu meri bagai. ");
INSERT INTO bor_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Páscoa meri boetojiwu aregodure dukeje Judeu doge ere tagu carneiro doge kugure ewido tuwo tuge pemegado nono turo mogadure tuwaduwo Páscoaji. Nou meriji nou Jesus ure jorduwadowuge enarare Jesusji. Egore: – Kaiba čemode page pemegado pawo kowuje, pawaduwo Páscoaji? ");
INSERT INTO bor_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nono Jesus ure tugeragu imei. Ere pobe. Ure jorduwadowuge nure emage. Makore ei. Akore: – Tadudo toro ba kurireu ka. Tagaregodumode toro dukeje ia imedu aregodumode tadogi ia pori po tabo. Tadudo nou imedu rekodaji. ");
INSERT INTO bor_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Umode turemo ia baito dukeje tanarado nou uwaire bai čewuji ia paedumodewu bagai. Tagagodo aino: “Pagimijera aidure ia tumugumodewu bagai togwagewo Páscoa kejewu boe ekeji ture jorduwadowugebo nou boe edureu tada.” ");
INSERT INTO bor_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tamagomode aino dukeje nou uwaire bai čewu umode tardudo ia boe edu tadawu bai pemegareuji. Nou bai pemegamode rugadu pagwagewo Páscoa kejewu pageji. Nonore tamode page pemegado. ");
INSERT INTO bor_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nou Jesus ure jorduwadowuge pobedu doge eture nou ba kurireu ka. Erdure nou boeji nono Jesus akoino jiboeji. Nono ere tuge pemegado tuwaduwo Páscoaji nou bai tada rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nou boečoji Jesus aregodure nouia ture jorduwadowugebo nou bai ka nou ime pobedu doge etae. Dukodire enodo padure doze nono Jesus apo. ");
INSERT INTO bor_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Emugure nono ira keje togwage tabo rugadu. Dukeje Jesus makore ei. Akore: – Iwo tawie boe remawuji. Tagwagere itabo woe mare ia tagi tamode imagu boe eimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nou Jesus ure jorduwadowuge eiamedu boe ekiarigodure. Dukodire enarare Jesusji tu tu puregodaji. Egore: – I na akagoino? Imi na? ");
INSERT INTO bor_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus akore: – Tare doze. Mare umode tuge amireu pegodo nou carneiro kaguru tabowu emare umode imagu boe ekimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Marigudu Pao Kurireu ure boe ewie iwimoduie duji. Nou Pao Kurireu bataru padure bapera keje. Aino čare iwimode nou Pao Kurireu meardae koia. Mare boe pegamode rugadu nou ure imagu boe eimijerage pegareuge etaiwuji. Botumodukare dukeje boe pegamodukare ji. Mare boture. Aino čare umode imagu boe eimijerage pegareuge etai dukodire boe pegamode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ča enogwage kimore. Jesus ure tugeragu tuge amireuji. Imadure Pao Kurireu bagai nou amireu paru tabo. Nono ure nou amireu kado dukeje ure pedo nou ture jorduwadowugei. Akore: – Tagwagedo awuji. Ikodu reo tawiabutuwo iwugeje, irore jiboe keje. ");
INSERT INTO bor_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nono Jesus ure tugeragu vinho kuruji jamedu. Nono imadure Pao Kurireu bagai nou uva kuru paru tabo. Dukejere ure pedo ei jamedu ekuduwo če. ");
INSERT INTO bor_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nono Jesus makore ei. Akore: – Ikure nou uva kuru rema. Iku redodumode boe eiamedu boe ero pegareu moriče. Pao Kurireu ure boe ewie marigudu tumoduie turo maiwu maku boe etai tuwo boe ekinorudo. Aino čare iku umode nou Pao Kurireu bataru jetudo pudui rugadu. Nou iku koiare umode meartorure Pao Kurireu jiwuge etawuje tuwobeče tuwo ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mare iwo tawie. Ikudumodukare awu vinho kuruče pugeje jii toro itaregodumode mato ibagi pugeje du ka. Itaregodumode pugeje dukeje boe eiamedu boe eimijera kurireu mode imi. Nono ikudumode vinho kuru maiwuče tagabo. ");
INSERT INTO bor_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesus akoino dukeje urare Pao Kurireu bataru tabo nou ture jorduwadowugebo. Nono ere tudawuje nou ba kurireu piji tuduwo toro Oliveira Ri ao ka. ");
INSERT INTO bor_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus makore ture jorduwadowugei. Akore: – Taiamedu boe tamode tagera ra ipiji. Pao Kurireu ure boe ewie marigudu. Nou bataru padure bapera keje. Akore: “Pao Kurireu umode nou jeture boeiwu bito. Nono nou boe eiamedu boe emode taodo nou tugimijera piji nono ovelha doge ero mogadure.” ");
INSERT INTO bor_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mare iewodumode pugeje dukeje itumode tagododai toro Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro akore: – Nou iage emode tugera ra apiji mare imire iromodukare aino. Imodukare ikera ra apiji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus makore Pedroji. Akore: – Imode awie boe remawuji. Awu boečoji rugadu akagomode arduwakaie i dumode pobe metia bokware rugadu. Dukeje čare kagariga kudugodumode. ");
INSERT INTO bor_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mare Pedro aidukare awu Jesus akoino pudui duji. Akore: – Boro. Iwimode akabo mare imodukare iwadaru udo nono akago mogadure. Imodukare ikera ra apiji rugadu. Ainore Pedro akore. Nono nouia Jesus ure jorduwadowuge egore nono Pedro ako mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nono Jesus aregodure ture jorduwadowugebo ia iguru jetureu ka. Nou iguru iere Getsêmani. Nono Jesus makore nou ture jorduwadowugei. Akore: – Tamugudo woe. Imagomode baruto Pao Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesus ure tugeragu Pedroji, Tiagoji, Joãoji. Uture ebo kuri nono. Dukeje kiarigodu rakare. Jorduware boe pegamode pudui duji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Makore nou ture tugeragu jiwugei. Akore: – Ikiarigodu rakare rugadu. Rakare tuwo iwido rugadu. Ča tadu rugadu woe tamagowo baruto Pao Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nono Jesus ure tudaru gu epiji. Nono ure tubu jodo moto keje tumagowo baruto Pao Kurireu bagai. Makore Pao Kurireu bagai boe pegakawo pudui. Makore Pao Kurireu bagai uwo tumeardae mekido. ");
INSERT INTO bor_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akore: – Iogwa Kurireu nure aki. Aromode boe jamedu boeji. Boe ero pegamode idu utudo piji. Mare ukawo nono itaidu mogadure. Mare uwo nono akaidu mogadure. ");
INSERT INTO bor_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nono Jesus ure tugirimi nou ture jorduwadowuge ewagai. Mare kočare enudure. Nono Jesus makore Pedro bagai. Akore: – Simão Pedro! Anudure? Amagodo Pao Kurireu bagai itabowu hora uwo mitotu je mare kočare anudure kuri je. ");
INSERT INTO bor_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nono Jesus makore eiamedu boei. Ere pobe metia bokware. Akore: – Tameardae pemegare. Mare taraga bokware. Aino ča tanudukaba pugeje. Tamagodo itabo Pao Kurireu bagai baruto bope ukawo tumeardae pegareu maku tagai taro pegakawo. ");
INSERT INTO bor_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nono Jesus ure tudaru gu epiji pugeje. Nono makore baruto nono tumago mogadure boetoji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nono Jesus ure tugirimi nou ture jorduwadowuge etae pugeje. Jordure ei enudu kimore duji. Norire ekuji rugadu dukodire enudure rugadu. Nono erduwakare tumagomode jiboeji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nono Jesus uture epiji pugeje tumagowo baruto pugeje. Dukejere čare ure tugirimi etae pugeje. Nono makore ei. Akore: – Tanudu kimo nure rugadu kana? Urugadu. Aino čare imagudumode boe eimijerage pegareuge etai kuri aino rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ča taragojedo. Pugeje. Nou ure imagu boe eimijerage pegareuge etaiwu aregodu. Paduwo togi. ");
INSERT INTO bor_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus mako kimore dukeje Judas Iscariotes aregodure etae. Jesus ure jorduwadowu nure ema. Aregodure boebo. Nou boe etaregodure tariga kurireu tabo. Etaregodure rago tabo. Boe ekimijerage ere nou boe etudo toro Jesus bagai. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge ere nou boe etudo toro Jesus bagai. Jorduware Judeu doge eno bakaru jiwuge ere nou boe etudo toro Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nou Judas Iscariotes makore nou boei tugimadumoduie Jesus apo, tumoduie togwa to je koduto tuwo nou boe pegareuge erdudo taidure tuwo tugeragu jiwu nure ema duji. ");
INSERT INTO bor_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dukodire Judas Iscariotes uture kuri Jesus ae rugadu. Ukimadure apo rugadu. Akore: – Jorduwareu nure aki. Nono Judas Iscariotes ure togwa to Jesus je koduto. ");
INSERT INTO bor_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nono nou boe pegareuge ere tugeragu Jesusji turaga tabo. ");
INSERT INTO bor_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mare ia Jesus ure jorduwadowu ure tugeragu tariga kurireuji. Ure ia imedu bija kado. Nou imedu nou ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijera kurireu utugare nure ema. ");
INSERT INTO bor_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mare Jesus makore nou boei. Akore: – Ire boe emeardae pegado kana emeartorukawo tugimijeragei kana? Ro pegareu karegure imi. Kočare tagaregodure tariga kurireu tabo rago tabo tawo tageragu i nono taro moga ro pegareuge eidu mogadure. ");
INSERT INTO bor_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iragojere tagabo meri jameduji Pao Kurireu uwai tada. Ire boe erduwado nono. Mare tagare tageragu i. Mare aino čare Pao Kurireu bataru jeture pudui rugadu. Tagaregodure tawo tageragu i nono Pao Kurireu bataru mogadure. ");
INSERT INTO bor_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dukodire Jesus ure jorduwadowuge eiamedu boe eregodure Jesus piji. ");
INSERT INTO bor_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nou boe pegareuge eture Jesus apo dukeje ia iparedu uture eregodaji. Dukodire nou boe pegareuge etaidure tuwo tugeragu ji jamedu. Nou iparedu ukudau areiare mitotu je. ");
INSERT INTO bor_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mare uture piji tuwo činorudo nou boe pegareuge epiji tuwiri kedo tabo. ");
INSERT INTO bor_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nou boe ere Jesus reko toro Judeu doge ekimijera kurireu uwai ka. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijera kurireu nure ema. Nouia Judeu doge ekimijerage edu nono jamedu. Ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijerage nure iage. Jorduware Judeu doge eno bakaru jiwuge nure iage. Boe eimijerage paru towuge nure iage. ");
INSERT INTO bor_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro kodu jaere boei tudu tabo Jesus rekodaji boe erdukawo pudui. Nono aregodure nou Judeu doge ekimijera kurireu uwai ka. Nou uwai kejere ure tumugudo nono tugobaigaregebo joru okwai. ");
INSERT INTO bor_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nou bai ja tadare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage edure. Nou Jerusalém kejewu Judeu doge eimijerage eiamedu boe edure nono jamedu. Eiamedu boe etaiwore ia Jesus ro pegareu bagai. Ewiapagare batrarodureuge ewadaruji taiwo tabo nou Jesus ro pegareu bagai. Etaidure tuwo Jesus bito. Mare erdukare ia Jesus ro pegareuji. ");
INSERT INTO bor_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Boe egore Jesus ro pegaie. Mare ewadaru kodukare puregodaji. ");
INSERT INTO bor_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nono ia boe ewadrarodure pugeje Jesus roji. ");
INSERT INTO bor_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Egore: – Čemeardure awu imedu bataruji. Akore ime eie Pao Kurireu uwai towuje. Mare tumoduie Pao Kurireu uwai kurireu butudo dukeje merimoduie pobe metia bokware tuwo nou bai rakojedo pugeje. Ia ime karega. Pudumie tumoduie Pao Kurireu uwai rakojedo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mare awu ime ewadaru kodukare puregodaji jamedu. ");
INSERT INTO bor_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu ure turagojedo. Makore Jesusji. Akore: – Amagomodukare nou ewadaru jipagi kana? Boe rugadu ji kana egoino rugadu? ");
INSERT INTO bor_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mare Jesus makokare boeji. Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijera kurireu unarare Jesusji pugeje. Akore: – Umode boe ekinorudowu nure aki? Pao Kurireu Onaregedu nure aki? ");
INSERT INTO bor_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus akore: – Imi rugadu. Mare iwo tawie Imedu Onaregedu romode jiboeji. Awu inodu otobiji tardumode i imugure Pao Kurireu ukana pemegareu jagwai duji. Tardumode i ire irawuje baru piji boetugu tabo duji. ");
INSERT INTO bor_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ča nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu ure tugudau areia mega bowuje tugorigodure dukodi. Dukodire makore tumedage boe eimijeragei. Akore: – Ča. Pameardure awu Jesus bataru pegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Unure tudo nono Pao Kurireure. Pagare akoino. Mako peganure Pao Kurireuji rugadu. Dukodi čare nuba tameardaere? Nuba paromode ji? Nou boe eimijerage eiamedu boe ere tumeardaedo nono nou boe eimijera kurireu meardae mogadure. Emeartorukare Jesus akoinoduji. Egore pagaie akoino. Jesus ro pegaie rugadu. Tumoduie Jesus bito. ");
INSERT INTO bor_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nono ere todoguru barigu Jesus joki. Ere areia kogudo Jesus jegajeje. Nono ere boeto Jesusji. Egokodure ji. Egore: – Ioguduba roino ai? Nono nou tugobaigarege ere tugeragu ji pugeje tuwo boeto ji. ");
INSERT INTO bor_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro rakoje kimore nono nou bawadu keje. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge ekimijera kurireu utugare aredu kodure nono. ");
INSERT INTO bor_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nou aredu jordure Pedroji. Pedro mugure nou joru okwai ture tugera urudo dutabo. Nou aredu aiwore ji. Akore: – Ature Nazaré kejewu Jesus apo jamedu. ");
INSERT INTO bor_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mare Pedro akore: – Boro. Iorduwakare kaba jiba akagoino. Nono Pedro uture nou bawadu kejewu bai poro ka. Nono ia kagariga kudugodure. ");
INSERT INTO bor_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nono nou aredu makore ia boei. Akore: – Jowu imedu ia Jesus ure jorduwadowu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mare Pedro akore pugeje tuiorduwakaie Jesusji. Ča Pedro rakoje kimore nono ji je. Dukejere ia boe emagore Pedroji pugeje. Egore: – Galiléia moto kejewu nure aki nono Jesus mogadure. Ia Jesus ure jorduwadowu nure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mare Pedro mako pegare ei tumagomodukaie boe remawuji dukeje Pao Kurireu uiago boe pegado pudui. Akore: – Iorduwakare nou tagagoino jiwu imeduji rugadu. ");
INSERT INTO bor_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Čare rore puku kagariga kudugodure pugeje. Dukodire Pedro biabuture Jesus makore puduiwu tuwadaru keje. Jesus makore Pedroji makomoduie tuiorduwakaie pudui dukeje nou kagariga kudugodumoduie rugadu. Pedro makomoduie tuiorduwakaie Jesusji dumode pobe metia bokware rugadu. Aino ča Pedro biabuture nou Jesus bataru keje rugadu jeture pudui duji rugadu. Dukodire kiarigodure turo pegareuji. Dukodire ragudure. ");
INSERT INTO bor_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nou barogwato, barogwakododutabo nou Judeu doge enomea makudure aiwuge eimijerage, nouia Judeu doge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge emagore pui tuwo tumeardae tawuje tuwo Jesus bito rugadu. Nono ere Jesus kogudo. Dukejere ere Jesus reko nou boe eimijera governador Pilatos bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Etaregodure Jesus apo Pilatos ae dukeje Pilatos unarare Jesusji. Akore: – Boe rugadu kana? Judeu doge eimijera kurireu nure aki rugadu kana? Jesus akore: – Uu. Boe jokodu jire akagoino. ");
INSERT INTO bor_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emago pegare Jesus rore jiboeji nou Pilatos biagai. Ewadrarodure Jesus rore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dukodire Pilatos makore Jesusji pugeje. Akore: – Egore aro pegaie. Kočare amagokare boeji ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mare Jesus makokare boeji pugeje. Dukodire Pilatos jorduwakare nuba turomode Jesusji pugeje. ");
INSERT INTO bor_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Judeu doge ewadae Páscoa kejere Pilatos ure ia ro pegareu tawuje baičoreu piji Judeu doge eroiaji. Judeu doge emagomode ia ro pegareu ieji dukeje Pilatos umode nou ro pegareu tawuje baičoreu piji utuwo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ro pegareuge emagare baičoreu tada nou joruji. Iage ekorigodure pui ba kurireu tada dukodire ere ia imedu bito. Dukodire eragojere nono baičoreu tada. Ia ro pegareu imedu rakojere ebo jamedu. Iere Barrabás. ");
INSERT INTO bor_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aino čare boe emagore Pilatoji uwo ia ro pegareu tawuje baičoreu piji utuwo pugeje turoiaji. ");
INSERT INTO bor_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dukodire Pilatos makore ei. Akore: – Tagaidure iwo awu Judeu doge eimijera kurireu tawuje baičoreu piji utuwo pugeje? Jesus jire nou Pilatos akoino. ");
INSERT INTO bor_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatos jorduware nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emeardae pegare Jesus jituji. Etaidure boe emeartoruwo tu pudui rugadu. Dukodire etaregodure Jesus apo Pilatos ae boe emeartorukawo Jesusji pugeje. Mare Pilatos jorduware Jesus ro pegareu bokwaie duji. Dukodire aidure Jesus utuwo pugeje. Aidukare turo pegawo Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere boe ero jodo. Dukodire nou boe emagore Pilatoji uwo ro pegareu imedu Barrabás tawuje baičoreu piji utuwo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mare Pilatos makore ei. Akore: – Nuba iromode awu tagagoino Judeu doge eimijera kurireuji? ");
INSERT INTO bor_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nou boe doge ekudugodure. Egore: – Nou Jesus bito! Bito ipo padure pugajejewu keje! ");
INSERT INTO bor_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatos akore: – Kodiba tagagoino? Ro pegareu pa? Mare ewiapagakare ji. Ere tugudu rakado. Egore: – Bito ipo padure pugajejewu keje rugadu! ");
INSERT INTO bor_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatos aidure tuwo nou boe doge ewudugugo. Dukodire rore nono etaidu mogadure. Ure Barrabás tawuje baičoreu piji utuwo pugeje. Dukejere ure tugobaigarege edo boeto Jesusji tapira biri iku tabo. Nono ure Jesus maku etai ewo bito ipo padure pugajejewu keje. ");
INSERT INTO bor_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tugobaigarege ere tugeragu Jesusji. Ere turemo apo nou tugimijera Pilatos uwaito. Nono emagore nouia tugobaigarege ewagai. Ere bato pui nono Jesus ae. ");
INSERT INTO bor_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nono ere ia boe eimijera kurireu ukudau areia motureu tugu Jesusji. Nou areia kaworu dugunure. Ere ia boe eimijera kurireu atadawu towuje. Ere nou atadawudo botoguruče. Dukejere ere tugu Jesus aoto atadawuwo ema. ");
INSERT INTO bor_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nono emago pegare Jesusji. Egore: – Judeu doge eimijera kurireu nure aki. Boe pemegawo ai awikawo jii toro. Mare tuwudorekeadae tabore egoino Jesusji. ");
INSERT INTO bor_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nono ere ipo to Jesus aoraji. Ere todoguru to ji. Ere tubu jodo Jesus jokorai. Ere tuie jodo mototo tuwudorekeadae pegareu tabo. ");
INSERT INTO bor_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ere tumago pegareu akedudo dukeje ere nou boe eimijera kurireu ukudau areia motureu tawuje Jesus piji. Ere Jesus ukudau areia tugu ji pugeje. Nono ere tugeragu Jesusji tuduwo apo Jerusalém piji tuwo bito ipo padure pugajejewu keje toro ture boe ewidodureu ka. ");
INSERT INTO bor_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eture Jesus apo dukeje tugobaigarege ere tugeragu ia imeduji oreduwo nou Jesus bitodumode kejewu ipo tabo. Nou imedu iere Simão. Aregodure ipoguru piji ba kurireu ka. Cirene ba kurireu pijiwu nure ema. Onaregedu imedu iere Alexandre. Ia onaregedu imedu iere Rufo. Tugobaigarege ere tugeragu Simãoji oreduwo nou ipo tabo. ");
INSERT INTO bor_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nono eture Jesus apo toro ia tori ao ka. Ewadaru tabo nou tori iere Gólgota. Boe ewadaru tabo iere: “Boe ewireuge etaora ra jeta reo.” ");
INSERT INTO bor_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ere ia jorubo barigu vinho kuruto. Nou jorubo iere mirra. Nono ere nou vinho kuru maku Jesus ai kuduwo če. Mare Jesus aidukare tuguduwo če. ");
INSERT INTO bor_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nono tugobaigarege ere Jesus bu ipo padure pugajejewu keje. Ere Jesus ukudau areia pedo pui. Ere tuwadumode tabowu tori rogu barigu tuiorduwawo ioguduba umode tugeragu Jesus ukudau areiaji. ");
INSERT INTO bor_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Meri jeture toro baru kugajeje dukeje ere bu ipo padure pugajejewu keje. ");
INSERT INTO bor_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ere atugoreboe bu ipo keje Jesus aora bukajeje. Egore: – Judeu doge eimijera kurireu reo. ");
INSERT INTO bor_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ere ia ro pegareu ime pobedu doge emugudo nono Jesus apo jamedu nou meriji. Ia rakojere Jesus kana pemegareu jagwai. Metia rakojere Jesus kana pegareu jagwai jamedu. ");
INSERT INTO bor_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Boe etaregodure nono dukeje ere taora paradudo. Emago pegare Jesusji. Egore: – Akagore amoduie Pao Kurireu uwai butudo mare merimoduie pobe metia bokware dukeje amoduie rakojedo pugeje. ");
INSERT INTO bor_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kočare amodukare arawuje nou ipo piji? Ča arawuje. Amodukare akinorudo nou ipo piji rugadu? ");
INSERT INTO bor_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge emagore pui tugodakagiriwo Jesusji. Egore: – Awu imedu akore tumoduie boe ekinorudo. Mare roiwakare tuwo činorudo. Kočare umodukare boe ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Umode turawuje awu ipo piji dukeje pameartorumode ji. Kočare umode boe ekinorudowu karegure ema pugeje. Israel doge eimijera kurireu karegure ema rugadu. Nou ro pegareuge epadure ipo keje Jesus apowuge emago pegare Jesusji nou boe eimijera pegareugebo jamedu. ");
INSERT INTO bor_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Meri aregodure pagaia ka dukeje boečodure moto jamedu boe parugajeje. Boečodure rugadu. Nou boečo kodure kuri toro nou três hora ka. Nou três hora otobiji baru aregodure nono tumogadure pugeje. ");
INSERT INTO bor_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dukeje čare Jesus makore tugudu tabo tuwadaru tabo. Akore: – Eloí. Eloí. Lemá sabactani? Boe ewadaru tabore akore: – Pao Kurireu. Pao Kurireu. Kodiba are akera ra ipiji? ");
INSERT INTO bor_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Boe emeardure nou Jesus bataruji dukeje egore: – Tawiapagado. Jesus kudugodure Elias bagai. ");
INSERT INTO bor_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ia imedu rekodure ia esponja tabo. Ure nou esponja pegodo vinho kuru tabo. Nono aregodure tabo Jesus ae. Ure nou esponja kogudo ipo oto tabo. Nono ure nou esponja raido nou ipo tabo toro Jesus okwa ka. Akore: – Pabagamode Elias bagai uwo Jesus rawuje nou ipo piji. ");
INSERT INTO bor_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nono Jesus kudugodu rakare tugiarigodure dukodi dukeje bire. ");
INSERT INTO bor_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nou areia kurireu bararere Pao Kurireu uwai ja tadawu ure tuwowuje nou bai ja oto piji moto ka jamedu. ");
INSERT INTO bor_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ia tugobaigarege eimijera rakoje puredure nou Jesus padure kejewu ipoji. Jordure Jesus bire duji. Akore: – Boe rugadu. Pao Kurireu onaregedu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Areme eragojere nono jamedu. Etaiwo jaere Jesus ae. Iarodo iere Maria Madalena. Metago iere Salomé. Ia etumedago iere Maria jamedu. Nou Maria ore ime ere pobe. Ia iere Tiago. Umana iere José. ");
INSERT INTO bor_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesus rakoje kimore Galiléia moto keje dutabo nou areme emeartorure ji. Aino eragojere nou Jesus bireu keje. Ia areme etaregodure Jerusalém piji turagojewo nono jamedu. ");
INSERT INTO bor_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Merirekodutabo José aregodure. Arimatéia ba kurireu kejewu nure ema. Boe eimijera nure ema jamedu. Boe etaidure ji. Emeartorure ji. Nou José upagare Pao Kurireu bagai boe eiamedu boe eimijerawo ema. Aino čare Jesus bire sexta feira meri keje. Dukodire José uture boe eimijera Pilatos bagai tumagowo ji. Pogurukare tumagowo ji. Aidure tuwo Jesus tugu mototo. ");
INSERT INTO bor_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Pilatos okeare Jesus bire kuri aino duji. Makore tugobaigarege eimijera bagai tunarawo ji Jesus bagai. Nou tugobaigarege eimijera akore Jesus bie rugadu. Nono Pilatos akore: – Kočare Jesus bire kuri je. Nono Pilatos makore Joseji uwo tugeragu Jesusji uwo tugu mototo. ");
INSERT INTO bor_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nono José ure akirodo ia boe ekudau areia motureuji. Uture tabo bireu Jesus ae. Ure Jesus rawuje nou ipo piji. Ure Jesus upodo nou areia tabo. Nono ure Jesus tugu ia tori poro maiwuto nono Judeu doge ero mogadure. Ere nou tori porodo tuwo ia bireuge etugu nono. Mare ekare ia bireuge etugu nou tori poroto raga. Ča José ure Jesus tugu nou tori poroto dukeje ure ia tori kurireu bu nou tori poro je keje tuwo miwuje. ");
INSERT INTO bor_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Areme eku kidure rore aino duji. Iarodo iere Maria Madalena. Metago iere Maria. José uče nure ema. Emagere erduware kaiba Jesus padure. ");
INSERT INTO bor_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado boečoji nou areme ere tudawuje tuwo akirodo roreboeji tuwo reko Jesus biri joki. Iarodo iere Maria Madalena. Metago iere Maria. Tiago uče nure ema. Metago iere Salomé. ");
INSERT INTO bor_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo meriji, ča boečoto eture nou tori poro ka. ");
INSERT INTO bor_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Epuredugodure dukeje emagore pui. Egore: – Nuba paromode pawo nou tori poro jado? Tori kurireu padure nou tori poro je keje. Paragakare pawo nou tori kurireu tawuje nou tori poro piji. Etaregodure dukeje etaiwore mare nou tori kurireu padukare nou tori poro je keje pugeje. ");
INSERT INTO bor_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dukodire ere turemo nou tori poroto rugadu. Nono erdure ia ipareduji. Mugure nono nou tori poro ja tada. Ukudau areia kigadu maere ji rugadu. Dukodire čare epagudugodure nou ipareduče. ");
INSERT INTO bor_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nou iparedu makore ei. Akore: – Tabagudukaba. Iorduware kaba bagaiba taroino taemaru tabo. Tagaiwonure Nazaré pijiwu bitodureu Jesus bagai. Ča rakojekare woe pugeje. Tagaiwodo padure kejewu toriji. Jewodure pugeje. ");
INSERT INTO bor_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tadudo pugeje toro Jesus ure jorduwadowuge ewagai, Pedro bagai jamedu. Tawo ewie Jesus utumoduie etododai Galiléia moto ka. Torore boe erdumoduie pudui. Ure ewie marigudu erdumoduie pudui toro. ");
INSERT INTO bor_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nono nou areme eregodure nou tori poro piji tubagudu koia. Emororamagadure nou tuiordure jiboeji rugadu. Dukodire emagokare boeji boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo meriji ča boečoto Jesus jewodure pugeje. Nono ure Maria Madalena jordudo pudui. Marigudu ure nou bope doge etuwaire ewarigu nou Maria Madalena piji. Nou bope doge etuwaire enodo padure sete. ");
INSERT INTO bor_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aino čare ure Maria Madalena jordudo pudui dukeje Maria Madalena uture nou Jesus ure jorduwadowuge etae tuwo ewie tuiordure Jesus jituji. Emage edure tuwai keje tragudu tabo tugiarigodu tabo. ");
INSERT INTO bor_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria Madalena ure ewie. Akore: – Jesus jewodure pugeje. Iordure ji rugadu. Mare emeartorukare Maria Madalena makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ia ime pobedu doge eture tuwai piji ipoguru ka. Jesus ure jorduwadowuge nure emage. Nono Jesus ure erdudo pudui. ");
INSERT INTO bor_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dukodi čare ere tugirimi nouia Jesus ure jorduwadowuge ewagai tuwo ewie tuiordure Jesus jituji. Mare emeartorukare nou ime pobedu doge egoino jiboeji. ");
INSERT INTO bor_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dukeje čare Jesus ure ture jorduwadowuge eiamedu boe erdudo pudui. Enodo padure onze. Enogwagere dukeje Jesus aregodure etae. Mako rakare ei. Emeartorukare nouia tumedage ewadaruji. Nou emedage erdure Jesusji dukeje ere tumedage ewie mare emeartorukare. Dukodire Jesus mako rakare ei. ");
INSERT INTO bor_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dukodi čare makore ei pugeje. Akore: – Tadudo moto jamedu boe parugajeje tawo boe eiamedu boe ewie iwadaru pemegareuji. ");
INSERT INTO bor_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Imode meartorure iwuge eiamedu boe ekinorudo. Emeartorumode i dukeje etao pegododumode dukeje imode ekinorudo. Mare meartorukare iwuge imode ewarigu boe pegareuto. ");
INSERT INTO bor_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Imode meartorure iwuge ero rakado. Emode bope doge etuwaire etawuje boe epiji. Mare turaga tabo karega. Ikie tabore imeardae tabore eroino. Emagomode boe tuginaiwuge ewadaruji jamedu. Boe erdumode eroino duji dukeje erduwamode iragojere ebo duji. ");
INSERT INTO bor_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Emode tugeragu awagei mare boe pegamodukare ei. Ekudumode jorubo pegareuče mare boe pegamodukare ei. Emode tugera bu kogodureuge ewugeje dukeje nou kogodureuge epemegagodumode jamedu. ");
INSERT INTO bor_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus ure tumago akedudo nou ture jorduwadowugei dukeje ruture baruto. Aregodure toro baruto dukeje mugure Pao Kurireu kana pemegareu jagwai. Aino Pagimijera kurireu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nou Jesus ure jorduwadowuge emagore Jesus bataru pemegareuji boe eiamedu boe ewiagai moto jamedu boe parugajeje. Pagimijera Jesus ure ero rakado. Dukodi čare boe erduware boe jokodu jirabodu boe egoino.");
INSERT INTO bor_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Imedia Teófilo nure aki. Ire awu bapera atugodo awagai boe remawu tabo arduwawo boe remawuji rugadu. Boe ereadodure boe ewiagai tuiordure jiwu Jesus rore jiboeji tumeardure jiwu Jesus makore jiboeji. Ia boe etaidure tuwo nou boe ereadodure jiwu Jesus rore jiboe bu bapera keje, boe ereadodure jiwu Jesus makore jiboe bu bapera keje jamedu. Ere boe ereadodure jiboe bu bapera keje jamedu. Mare imire, ire iragado i iorduwawo boe remawuji rugadu. Ire iragado i iorduwawo Jesus rore jiboeji, makore jiboeji. Dukodire imagore jordure Jesus rore jiboe jiwugei, meardure Jesus bataru jiwugei. Ere iorduwado boe remawuji rugadu. Dukodire inure awu bapera atugodo awagai boe remawu tabo arduwawo boe remawuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judéia moto keje Herodes boe eimijera unure ema. Dukejere ia imedu maragodure Pao Kurireu uwai tada. Nou imedu iere Zacarias. Maragodure Pao Kurireu uwai tada tuwo Judeu doge enomea maku Pao Kurireu ai. Abias uwobe nure nou Zacariače. Nou Zacarias oreduje iere Isabel. Nou oreduje uwobe nure Arãoče jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nou Zacarias toreduje apo emeartorure rugadu Pao Kurireu ure maku Judeu doge etaiwu bakaruji. Dukodire Pao Kurireu aidure ei. Makore ro pemegareuge nuie emage. ");
INSERT INTO bor_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mare Isabel kuiarumodukare dukodire etore bokware. Aino čare epegagodure tore bokware dutabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Nou maragodure Pao Kurireu uwai tadawuge ime emagare rugadu. Emode roreboe kowu. Nou roreboe uredudu rore Pao Kurireu uwai tada. Ere kowu kamo keje Pao Kurireu ai. Ere tori barigu tu tu je tuiorduwawo ioguduba umode roreboe kowu nou meriji. Ia meri keje nou tori buture Zacarias ie keje dukodire Zacarias ure turemo tuginaigodu Pao Kurireu mugure tadawu baito tuwo nou roreboe kowu kamo keje Pao Kurireu ai nou tori buture tugie keje kodi. ");
INSERT INTO bor_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nono boere turugadu dukodire Zacarias ure roreboe kowu kamo keje rugadu. Toro bawadu kejere boe emagare. Emagore baruto Pao Kurireu bagai tubaga tabo Zacarias uwo tumaragodae iado. ");
INSERT INTO bor_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mare ukare iado raga dukeje ia Pao Kurireu utugare baru tadawu aregodure Zacarias ae. Rore puku ji nou baru tadawu rakojere nono pudabo nou kamo jagwai. ");
INSERT INTO bor_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarias jordure nou Pao Kurireu utugare baru tadawuji dukeje pagudugodure. ");
INSERT INTO bor_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mare nou baru tadawu akore: – Apagudukaba. Amagore baruto Pao Kurireu bagai uwo akoredo. Pao Kurireu meardure amagore jiboeji. Akoreduje Isabel kuiarumode rugadu. Taganaregedu imedu mode. Tamode iedo João aino. ");
INSERT INTO bor_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Botumode dukeje taegaremode ji rugadu. Boe egaregodumode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pao Kurireu aidu kurimode nou taganaregedu Joãoji. Mako pemegamode João rore jiboeji rugadu. Mare nou taganaregedu João biedu pemegado kudukawo vinho kuruče jii toro rugadu, kudukawo piga kuruče jamedu jii toro rugadu. Pao Kurireure akoino. Botumode dukeje Pao Kurireu Uwari rakojemode apo rugadu tuwo ro pemegado jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ričodumode dukeje nou taganaregedu João makomode Pao Kurireu bataruji Israel moto kejewu Judeu doge ewiagai. Dukodire umode Judeu doge emeartorudo Pao Kurireuji pugeje. Nou meartorure Pao Kurireu jiwuge emagamode pugeje Israel moto keje. Emode tugimijerado Pao Kurireuče pugeje. ");
INSERT INTO bor_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nou taganaregedu João kodumode Pao Kurireu otodai. Rakamode, kurimode nono jorduware Pao Kurireu bataru jiwu Elias mogadure. Nou taganaregedu João okituwamode boei ewudugugoduwo torebo. Umode ro pegareuge edo tugera ra turo pegareu piji ro pemegareuge emeardae ka pugeje. Umode Judeu doge ewie Pagimijera Kurireu aregodumoduie kuri je ewo tudo turugadu Pagimijera Kurireu togi. ");
INSERT INTO bor_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarias unarare nou Pao Kurireu utugare baru tadawuji. Akore: – Kodiba iorduwamode awadaru jetumode pudui duji? Ipegagodure. Itoreduje pegagodure jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nou Pao Kurireu utugare baru tadawu akore: – Ikiere Gabriel. Imire imugure Pao Kurireu apo tu tu je. Emare ure itarego mato iwo awie tumeardae pemegareuji. ");
INSERT INTO bor_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pao Kurireu umode imagore jiboe jetudo pudui rugadu taidure jiwu meri keje. Mare ameartorukare imagore jiboeji. Dukodire amago bokwamode jii toro nou inagore jiwu akanaregedu botumode du ka. Botumode dukeje amago padumode tači akajeje pugeje. ");
INSERT INTO bor_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Toro nou Pao Kurireu uwai jokorai boe edure nono tubaga tabo nou Zacarias uwo tumaragodae iado. Mare nou Zacarias rakoje raire toro bai tada. Dukodire nou boe emororamagadure bagai. Egore: – Kočare ukare tuie bu raga. ");
INSERT INTO bor_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dukejere Zacarias ure tuie bu rugadu. Mare mako bokware dukodire boe erduware jordure iaboeji nono duji. Zacarias roiwakare tumagowo dukodire ure boe erduwado tumeardaeji tugera tabo. ");
INSERT INTO bor_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nou Zacarias maragodure kejewu ari akedure dukeje uture tuibagi toro tuwai ka nouia ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ia meri keje oreduje Isabel kuiarure. Dukodire ukare tudawuje tuwai piji jii toro. Arire ikera aboudure ji tumugu tabo tuwai keje. ");
INSERT INTO bor_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Akore: – Mare aino Ikimijera Pao Kurireu ure tugera maku inai. Marigudu ikuiarukare dukodire ipogurure. Mare aino čare ikuiarure dukodire ipogurukare imeruwo imedage aremebo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Arire seis Isabelji kuiarure dutabo. Dukejere Pao Kurireu ure nou tudugare baru tadawu Gabriel utudo ia nogwaredu bagai tuwadaru tabo Nazaré ba kurireu ka. Nazaré ba kurireu rakojere Galiléia moto keje. Nou nogwaredu iere Maria. Nogwaredu nure ema. Bowadukare ia imeduji raga. Mugumode ia Davi uwobe imedu apo. Nou imedu iere José. Erduware tumugumode puapo duji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nou Pao Kurireu utugare baru tadawu aregodure Maria ae dukeje makore Mariaji. Akore: – Itaregodu. Pao Kurireu rakojere akabo. Ro pemegamode ai taidu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria pagudugodure če. Mare jorduwakare kaba kodiba akoino pudui. ");
INSERT INTO bor_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","33","Mare nou Pao Kurireu utugare baru tadawu makore ji. Akore: – Are. Apagudukaba. Pao Kurireu ro pemegamode ai rugadu. Akuiarumode. Akanaregedu imedu mode. Iemode Jesus. Boe kurireu umode ema. Iemode Pao Kurireu Onaregedu. Pao Kurireu umode boe eimijera kurireudo ema. Nou Jacó uwobe Judeu doge eimijera kurireu mode ema rugadu. Umode nono Judeu doge eimijera kurireu Davi umogadure. Judeu doge eimijera kurireu mode ema jii toro rugadu. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria akore: – Nuba ikuiarumode? Nogwaredu kimo nure imi. Imedu jeribarikare i raga. ");
INSERT INTO bor_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","37","Nou baru tadawu akore: – Pao Kurireu Uwari umode turawuje akae. Pao Kurireu umode tonaregedu maku akai. Dukodire akanaregedumode. Boe egomode Pao Kurireu onaregedu iure ema rugadu. Pao Kurireu ro rakare kodi. Atuie Isabel kuiarure. Boe egore kuiarumodukaie pugeje pegagoduie kodi. Mare aino čare kuiarure kejewu ari oto padure seis. Pao Kurireu koiare umode onaregedudo toredu apo rugadu. Pao Kurireu ro rakare dukodire rore aino Isabelji romode aino ai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria akore: – Pao Kurireu utugare nure imi. Awadaru ure turugadu inai. Nono nou baru pijiwu Pao Kurireu utugare uture tuibagi Maria piji. ");
INSERT INTO bor_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Maria ure tugera pemegado pudui tuduwo Judéia moto ka tugiriaduwo tuduie Isabel bagai. Nou Isabel mugure kejewu boe eda mugure toriguru tada. Maria aregodure dukeje ure turemo Zacarias uwaito tugimaduwo Isabel apo. ");
INSERT INTO bor_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel meardure Maria makoji. Dukeje Isabel onaregedu jakarere pudui kuri tada. Pao Kurireu ure Isabel korau tubemega tabo turaga tabo, Uwari rakojere Isabel apo dukodi. ");
INSERT INTO bor_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Isabel makore Mariaji. Akore: – Pao Kurireu ro pemegare ai rugadu awu areme epiji. Akanaregedu botumode dukeje Pao Kurireu ro pemegamode ji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ikimijera mode ema. Boe karegure imi. Kočare ikimijera kurireu uče aregodure itae. ");
INSERT INTO bor_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nono imeardure amago jitu keje itonaregedu jakaregodure magadure ikuri tada jorduware boe ekimijera kurireu mode akanaregeduče dukodi. ");
INSERT INTO bor_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ameartorure Pao Kurireu makore ai duji dukodire boe pemegamode ai rugadu. Pao Kurireu akore turomoduie aino rugadu tuwiagodumodukaie tuwadaru piji. Aki ameartorure nou bataruji. Dukodire boe pemegamode ai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Maria akore: – Imeardu kurire Pao Kurireuji. Iagarere i Pao Kurireu rore aino iduji. Emare umode ikinorudo. Utugare nure imi. Boe kurireu karegure imi. Mare ro pemegare i rugadu. Dukodire boe eiamedu boe ewiabutumode iwugeje. Egomode jakarere puduiwu nuie imi Pao Kurireu ro pemegare i kodi. Ro pemegareu nure ema. ");
INSERT INTO bor_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","– Okudugodure meartorure puduiwugebo ji aino rugadu. Okudugodure jawu boebo. Aino maiwu boebo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","– Očarore tuwadaru jiwuge ere tumeardae tawuje mare Pao Kurireu ure tuwu ekajeje tugana rakareu tabo ekawo nou tumeardae utudo tudobiji. ");
INSERT INTO bor_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","– Ure boe eimijera kurireuge etagedudo. Ure boe eimijeragedo marenarue dogeče. ");
INSERT INTO bor_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","– Ure uke boeire jiwuge ekuredudo tuge pemegareu tabo. Ure nou o diero kurireuge etudo tugera kedo tabo. ");
INSERT INTO bor_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","– Marigudu ure tuwadaru maku mariguduwuge pawobe etai. Aino ure tumagore jiboe jetudo pudui rugadu. Dukodire aregodure tuwo tugera maku tudugarege Israel kejewu Judeu doge etai. – Biabuture tumeardae keje rugadu togudugoduwo Abraão uwobe eiamedu boebo jii toro rugadu. Ainore Maria akore tura tabo. ");
INSERT INTO bor_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria rakoje raire tuduie Isabel apo. Arire pobe metia bokware ji nono dukeje ure tugirimi tuibagi tuwai ka. ");
INSERT INTO bor_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ari aregodure Isabel kuri butumodewu ka. Dukodire kuri buture rugadu. Imedu rogure ema. ");
INSERT INTO bor_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nono Isabel jakarere pudui rugadu. Nou uwobe nou mugu puredure jiwuge eiamedu boe egarere pudui jamedu nou Isabel kuri butu pemegare kodi. Erduware Pao Kurireu ro pemegare jituji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Merire sete nou negeduroguji dukeje boe etaregodure Isabel uwai ka tuwo nou imedu rogu oe oto biri rogu kado nono turoiaji. Dukeje etaidure tuwo iedo Zacarias nono uo ie mogadure turoiaji. ");
INSERT INTO bor_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mare uče akore: – Boro. Pamode iedo João. ");
INSERT INTO bor_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mare nou boe egore: – Tawobe ekiemodukare João. ");
INSERT INTO bor_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nono ere tugera onado nou uo ae tunarawo ji nuba nou imedu rogu iemode. ");
INSERT INTO bor_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarias ure tugera onado ei tunara tabo bapera bagai. Dukejere ure tuwadaru bu nou bapera keje. Akore: – Iemode João. Ure iedo João dukodire nou boe erore toku je. ");
INSERT INTO bor_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zacarias ure nou ie bu nou bapera keje dukeje bataru padure tači kajeje. Dukodire mako pemegare Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nou boe erdure nou inoduji dukeje epagudugodure nou bataru padure tači kajeje duji. Boe ereadodure nou boeji nou Judéia moto kejewuge boe eiamedu boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Boe emeardure nou ereadodaeji dukeje ewiagorore tuiedui. Erduware Pao Kurireu raka meture nou imedu rogu apo duji. Boe enarare pui. Egore: – Nuba nou imedu rogu romode? ");
INSERT INTO bor_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","João uo Zacarias korobadure Pao Kurireu Uwari apo. Ure Zacarias jorduwado nuba Maria onaregedu botumodewu romode. Dukodire Zacarias makore nou Pao Kurireu bataruji. Akore: ");
INSERT INTO bor_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","– Pamago pemegawo Pagimijeraji. Israel moto kejewuge emeartorure jiwu Pao Kurireu nure ema. Aregodure tuwo tugera maku meartorure puduiwuge etai tuwo ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","– Ure nou umode boe ekinorudowu arego mato pagae. Jawu pawobe eimijera kurireu iere Davi. Meartorure Pao Kurireuji. Nou mariguduwu boe eimijera Davi uwobe nure nou umode boe ekinorudowuče jamedu. ");
INSERT INTO bor_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","– Marigudu Pao Kurireu akore tumoduie paginorudo jordu pegare paiwuge epiji, eraga piji. Makore Pao Kurireu bataru jiwuge ere boe ewie nou Pao Kurireu bataruji. ");
INSERT INTO bor_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","– Ure tumeardae pemegareu maku jawu pawobe etai eno bakaruwo ema. Makore ei tuwiagodumodukaie nou ture maku etaiwu tumeardae piji jii toro rugadu. Makore ei togudugodumoduie ebo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","– Pao Kurireu makore jawu pawobe etuo Abraãoji tumoduie tumagore jiboe jetudo pudui rugadu. Makore tumoduie paginorudo jordu pegare paiwuge epiji. Makore tumoduie pabagudure jiboe okwado pabiji tudugaregewo pagi rugadu paro pemegawo, parore jiboe uwo tuginai meartorukare jiwuge ero piji nono Pao Kurireu aidu mogadure jii toro pawimodedu ka. Ainore Zacarias akore. Maria onaregedu jire akoino. Nono Zacarias makore pugeje. Akore: – Aino čare itonaregedu jire imagomode iwo boe erduwado nuba itonaregedumode. ");
INSERT INTO bor_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","– Itonaregedu imedu rogu nure aki. Boe emago pemegamode ai. Egomode makore Pao Kurireu bataru jiwu nuie aki. – Akaregodure Pagimijera Kurireu otodai awo boe udo turugadu Pagimijera Kurireu togi. ");
INSERT INTO bor_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","– Amode boe ewie nuba boe eromode tureadoduwo turo pegareu boeji Pao Kurireu biagai Pao Kurireu uwo ekinorudo. Boe ereadodumode turo pegareu boeji Pao Kurireu biagai dukeje Pao Kurireu biagodumode ero pegareu boe piji. Dukodire umode ekinorudo etukawo bope doge eda kejewu joru pegareu ka. ");
INSERT INTO bor_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","– Pao Kurireu okudugodure boebo. Ro pemegamode boei rugadu. Dukodire umode parduwado nou umode paginorudowu meardaere jiboeji. Nou umode paginorudowu meardae ure nono meri rutu mogadure. Mare meri rutu ji karega inagoino. Umode boe ekinorudowu umode boe erduwado Pao Kurireu bataru remawuji. Dujire inagoino. Marigudu boe eiamedu boe erduware rugadu tuwimode duji jii aino rugadu. Dukodire boe emeardae ure nono boečo mogadure. Mare boečo ji karega inagoino. Ekiarigodure, emororamagadure tuwimode duji rugadu. Dujire inagoino. Mare aino nou umode paginorudowu umode paroiwado parore jiboeji tuwo padawuje pagiarigodure dupiji pabemegawo boebo pamugu pemegawo Pao Kurireu apo. Ainore Zacarias akore. ");
INSERT INTO bor_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nou Zacarias onaregedu ričodure. Ure turagado pudui tumeardae jetororeu tabo. Dukodire uture tuje piji tuo piji tumuguwo ia boe maereu keje. Mugu raire nono. Toro ia meri keje aregodure tuibagi Israel moto kejewu Judeu doge etae tuwo ewie Pao Kurireu bataruji. Maragodumode nou inoduji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Síria moto kejewu boe eimijera governador iere Cirênio. Dukejere Roma kejewu boe eimijera kurireu César Augusto ure tuwadaru utudo boe eiamedu boe etae. Akore eiago tugirimi tuwobe edure kejewu moto ka ewo tugie bu bapera keje. Aidure tuiorduwawo nou to moto kejewu boe emagamode dubagai. Dukodire boe eiamedu boe eture mariguduwuge tuwobe ewodure kejewu ba kurireu ka tuwo tugie bu bapera keje. ");
INSERT INTO bor_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Dukodire Maria uture toredu José apo Nazaré ba kurireu piji Belém ba kurireu ka nou mariguduwuge tuwobe ewodure kejewu moto Belém ba kurireu ka tuwo tugie bu bapera keje. Nou Belém ba kurireu padure Judéia moto keje. Mariguduwu Judeu doge eimijera kurireu Davi boture Belém ba kurireu keje. Nono José, Maria, Davi uwobe nure emage. Dukodire eture Belém ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Maria kurijirigodure etaregodure Belém ba kurireu to dukeje. Mare boe emagare nono tuwo tugie bu bapera keje dutabo. Dukodire nou Belém ba kurireu korobadure nou boebo. Maria, José eda bokware. Dukodire eture tubaduwo ia boe egu tapira doge ewai tada. Nonore kuri buture. Imedu rogure ema. Onaregedu boetojiwu nure ema rugadu. Maria ure areia upodo tonaregedu apo. Nono ure tonaregedu rogu bu ia tapira doge eke ja tada. Enudure nono nou bai tada. ");
INSERT INTO bor_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nou boečoji ia boe edu puredure tietu tabo tagu cabrito dogei, tagu carneiro dogei, ipoguru keje. ");
INSERT INTO bor_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nono Pao Kurireu utugare baru tadawu aregodure etae. Pao Kurireu o jorugu pemegareu urugure ei. Nono epagudugodure. ");
INSERT INTO bor_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mare nou baru tadawu akore: – Tabagudukaba. Itaregodure Pao Kurireu o bakaru pemegareu tabo uwo boe eiamedu boe egaredo pudui. ");
INSERT INTO bor_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ainore awu bakaru ure. Awu meriji Belém ba kurireu keje umode boe ekinorudowu boture. Pao Kurireu ure maku boe etaiwu tagimijera nure ema. Boe eimijera kurireu mode ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tadudo toro tarduwo ji. Tardumode ji areia upore apo duji. Tardumode ji ia boe egu tapira doge ewai tada, ia tapira doge eke ja tada. Tardumode aino ji dukeje tarduwamode ema rugaduie duji. ");
INSERT INTO bor_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ča ia Pao Kurireu utugarege baru tadawuge etaregodure pugeje. Emagare rugadu. Emago pemegare Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Egore: – Boe emago pemegawo Pao Kurireuji rugadu baru tada. Pao Kurireu uwo taidure jiwuge epemegado pui woe moto keje. ");
INSERT INTO bor_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nono nou baru tadawuge erudure tuibagi baruto. Nou jeture tagu ie jiwuge emagore pui. Egore: – Paduwo Belém ba kurireu ka. Parduwo Pagimijera Pao Kurireu makore pai jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nono eture tači je toro Belém ba kurireu ka rugadu. Nono erdure nou Joseji nou Mariaji, nou etonaregedu roguji jamedu. Nou negedurogu padure ia tapira doge eke ja tada nono nou baru tadawuge ego mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","Erdure ji dukeje ereadodure boe ewiagai Pao Kurireu utugarege baru tadawuge emagore jiboeji. Boe eku kidugodure nou egore tuwiagai duji. ");
INSERT INTO bor_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mare Maria jorduware marigudu. Dukodire roiwakare tuwiagoduwo nou Pao Kurireu bataru piji. Biagorore nou bataru boeji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nou jeture ovelha doge eiwuge ere tugirimi tagu ie etae. Erare tumago pemegawo Pao Kurireuji tuiordure jiboeji tumeardure jiboeji tuwo Pao Kurireu ie kurido rugadu. Nou Pao Kurireu utugare baru tadawu makore jiboe jeture pudui rugadu. Dukodire eragodure aino čimaduwo Pao Kurireu apo. ");
INSERT INTO bor_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Merire sete Joseji Mariaji. Dukejere ere tonaregedu baka oto biri kado nono nou tuwobe Judeu doge ero mogadure. Nono ere iedo Jesus nono nou Pao Kurireu utugare baru tadawu makore ei dumogadure. Makore marigudu Mariaji kuiarure du otodai uwo iedo Jesus aino. ");
INSERT INTO bor_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Merire 40 Joseji Mariaji etukare Pao Kurireu uwai ka dutabo. Ainore Judeu doge erore. Etonaregedu imedu boture dukeje etukare Pao Kurireu uwai ka jii je. Ainore Moisés ure maku Judeu doge etaiwu bakaru jawu akore. Merimoduie 40 ei dukejere etuwo tonaregedu apo Pao Kurireu uwai ka. Nono merire 40 ei dukeje Maria, José eture Pao Kurireu uwai ka Jerusalém ba kurireu ka tonaregedu rogu apo tuwo Pao Kurireu jordudo ji tumagowo paru tabo jamedu Pao Kurireu utugarewo ema. ");
INSERT INTO bor_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Marigudu Pao Kurireu makore Judeu dogei. Moisés ure bu bapera keje Judeu doge eno bakaruče. Pao Kurireu akore: – Nou taganaregedu imedu boetojiwu maku inai itugarewo ema. ");
INSERT INTO bor_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ainore erore rugadu. Merire 40 ei dukeje ere metugoe pobedu doge ekowu tuwo turemo Pao Kurireu uwaito. Marigudu Pao Kurireu makore Judeu dogei. Akore: – Taganaregedu botumode dukeje tamode metugoe pobedu doge ekowu tawo maku inai, tawo taremo iwaito. Tago diero kurikare dukeje tamode metugo gigiri dogedo pobe. Tago diero kurire dukeje tamode metugo kurireugedo pobe tawo ekowu tawo taganaregedu maku inai. Ainore Pao Kurireu akore. Moisés ure nou bataru bu bapera keje marigudu Judeu doge eno bakaruče. Dukodire José roino toreduje apo metugoe pobedu dogei. ");
INSERT INTO bor_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Nono Jerusalém ba kurireu kejere ia imedu pemegareu rakojere. Iere Simeão. Meartorure Pao Kurireuji. Meartorure Pao Kurireu bataruji. Pao Kurireu akore tumoduie Judeu doge ekinorudo boe pegareuge epiji. Pao Kurireu Uwari rakojere nou imedu Simeão apo. Ure Simeão bie. Akore: – Ardumode umode boe ekinorudowu imeduji awimodukare du otodai. ");
INSERT INTO bor_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pao Kurireu Uwari ure nou Simeão utudo Pao Kurireu uwai ka nou meriji. Maria, José, etaregodure Jesus apo tumagowo Pao Kurireuji aiwowo ji. ");
INSERT INTO bor_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nou Simeão jordure ji dukeje jorduware ji rugadu, umode boe ekinorudowu mode ema rugadu. Nono Simeão ure tugeragu Jesus roguji. Nono mako pemegare Pao Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Akore: – Ikimijera nure aki. Aino čare are awadaru jetudo pudui rugadu. Iordure ioku remawu tabo umode boe ekinorudowuji rugadu dukodire imode itamudo. Are akeragu awu imedu roguji boe eiamedu boe emeartoruwo ji. Umode boe tuginaiwuge erduwado ameardae pemegareuji. Umode Judeu doge epemegado, ero pemegawo boe egai. ");
INSERT INTO bor_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nou Jesus uo uče ebogodure nou Simeão akoino nou imedu rogu jituji. ");
INSERT INTO bor_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeão ure tuwadaru pemegareu bu ewugeje. Akore Mariaji: – Pao Kurireu ure tugeragu akanaregeduji. Umode ia Israel moto kejewuge etagedudo. Mare umode nouia Israel doge ekinorudo jamedu. Pao Kurireu umode akanaregedu udo nono tuwadaru mariguduwu mogadure. Dukodire boe erdumode Pao Kurireu makore jiboe jetumode pudui rugadu duji. Mare boe emeartorumodukare makore jiboeji. Emago pegamode akanaregeduji. ");
INSERT INTO bor_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Boe emeardumode egoino duji dukodire erduwamode nou boe emeardae pegareu boeji. Nono akiarigodumode rugadu. Nou akiarigodae umode boe pegado ai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Nou Pao Kurireu uwai ja tadare ia makore Pao Kurireu bataru jiwudo mugure jamedu. Iere Ana. Uo iere Fanuel. Judeu doge mariguduwuge etumana Aser uwobe nure ema. Ana okoge bokware. Marigudu oredu bire. Emugure puapo dukeje jorure sete ei dukejere oredu bire piji. Nono Ana okogekare pugeje. Aino čare o jorure oitenta e quatro. Ukare tudawuje Pao Kurireu uwai piji rugadu. Meriji, boečoji rakojere nono tumago pemegawo Pao Kurireuji. Ure tugera ra togwage piji tu tu je tumagowo baruto Pao Kurireu bagai. Aino čare jordure Mariaji, Joseji. Aregodure dukeje imadure Pao Kurireu apo nou etonaregedu rogu paru tabo. Akore nou etonaregeduie umoduie boe ekinorudo rugadu. Boe epagare Pao Kurireu bagai rugadu uwo Judeu doge ekinorudo. Aino čare nou okoge bokwareudo makore nou imedu rogu umoduie boe ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ere nou Pao Kurireu makore jiboe jamedu boe udo turugadu dukeje Maria, José ere tugirimi tuibagi tuwai ka Nazaré ba kurireu ka Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Etonaregedu ričodure rugadu. Rakagodure pudui. Jorduwagodure rugadu. Pao Kurireu ro pemegare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Jesus o jorure doze. Dukejere José, Maria ere Jesus reko toro Jerusalém ba kurireu ka tuwadae Páscoa ka. Ainore erore joru jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Nou ewadae akedure dukeje Jesus uo uče ere tugirimi tuwobebo tuibagi tieda ka. Emerure jii toro meriji. Mare Jesus kodukare ebo. Mugure Jerusalém ba kurireu keje eiageje. Uče uo erdukare ji pudabo dukeje etaiwore bagai tuwobe ekao. ");
INSERT INTO bor_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mare erdukare ji. Dukodire ere tugirimi tuibagi Jerusalém ba kurireu ka tiemaru tabo bagai. ");
INSERT INTO bor_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","47","Merire pobe metia bokware dukeje erdure ji Pao Kurireu uwai tada. Mugure jorduware Pao Kurireu bataru jiwugebo tumearduwo ewadaruji, tumagowo ewadaru jipagi. Ure boe eku kidugo tagoino duji. Nou boe eiamedu boe ebogodure akoino tuwadaru jipagi duji. ");
INSERT INTO bor_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesus uče, uo erore ta tonaregeduji. Maria akore: – Me. Kodiba arore aino? Imi, ao čemororamagadure čemaru tabo awagai! ");
INSERT INTO bor_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus akore: – Kodiba taemarure iwagai? Tarduwakare imugure iogwa uwai tada duji? ");
INSERT INTO bor_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Uče uo emeardure Jesus makore pudui duji mare erduwakare nou tonaregedu bataruto. ");
INSERT INTO bor_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","52","Jesus ure tugirimi tuo apo tuje apo toro Nazaré ba kurireu ka. Nonore Jesus ričodure. Meartorure tujeji, tuoji. Ričodure tumeardae kurigodureu tabo jamedu. Pao Kurireu jordu pemegare rore jiboeji makore jiboeji. Boe eiamedu boe erdu pemegare ji. Uče biagodukare tonaregedu roredu piji akoredu piji. ");
INSERT INTO bor_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Jorure quinze Tibério César boe eimijera kurireure ema nono Roma ba kurireu keje duji. Dukeje Judéia moto kejewuge eimijera governador iere Pôncio Pilatos. Galiléia moto kejewuge eimijera iere Herodes. Itureia moto kejewuge eimijera iere Filipe. Traconites moto kejewuge eimijera nure ema jamedu. Herodes umana nure ema. Abilene moto kejewuge eimijera iere Lisânias. Jerusalém ba kurireu tadare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireuge ere pobe. Ia iere Caifás. Metia iere Anás. Emugu kimore dutabo Pao Kurireu bataru aregodure Zacarias onaregedu João Batista ae. Ema rakojere boe maereu keje. Dukejere João Batista kodure Jordão Po okwaji tumago tabo boei. Akore: – Tagera ra taro pegareu boe piji. Nono imode tagao pegodo. Nono Pao Kurireu biagodumode taro pegareu boe piji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Dujire nou makore Pao Kurireu bataru jiwu imedu Isaías makore marigudu. Akore: – Ia boe kudugodumode boe maereu keje boe ewo awara jetorodo boe eimijera aregodu pemegawo boe etae. Kudugodumode boe ewo moto ri butudo ewo barigu koiareuto korobaduwo moto tabo. Moto ri jamedu boe butumode dukeje nou tori jamedu ao kororogodumode. Nono boe emode awara mekireu jetorodo. Boeiako mode awara keje boe emode korau boe ewo ao kororogo jamedu nou umode boe ekinorudowu imedu aregodu pemegawo boe etae. Mare tori ji karega akoino. Awara ji karega akoino. Boe ewo tumeardae jetorodo. Dujire akoino. Boe ewo turo pemegado. Dujire akoino. Boe ewo tugera bararedo pui, umode boe ekinorudowu imedu aregodumode Pao Kurireu piji dukodi. Dujire akoino. Aino boe eiamedu boe erduwamode nuba Pao Kurireu romode tuwo boe ekinorudo. ");
INSERT INTO bor_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","9","Boe emagare taregodu tabo João Batista ae tuwiapagawo bataruji. Emagore João Batistaji uiago etao pegodo. Mare João Batista makore ei. Akore: – Nou iguru tudu pegare dukeje boe ere butudo tuwo jerigido ema. Tagi tagagomode tamoduie tagera ra taro pegareu piji mare taro pemegamodukare, tameardae pemegamodukare dukeje Pao Kurireu ro pegamode tai jamedu nono boe erore nou jerigi jitu mogadure. Mare jerigi ji karega inagoino. Boe pegamode tai rugadu. Dujire inagoino. Boe pegareuge nure tagi. Tagagore boe etuo Abraão ore enuie tagi dukodire Pao Kurireu uwobe enuie tagi. Ainore tagagore. Boe jokodu jire tagagoino. Abraão uwobe nure tagi rugadu. Mare dukodi karega Pao Kurireu ro pegamodukare tai taro pegareu moriče. Ro pegareuge nure tagi rugadu. Dukodire tagare nono Abraão uwobe remawuge emogadure pugeje. Pao Kurireu roiware tuwo tori udo nono Abraão uwobe maiwuge emogadure tamugato. Tamodukare tagera ra taro pegareu piji dukeje tamodukare taginorudo Pao Kurireu piji rugadu. Umode boe pegado tai rugadu tameartorukare Pao Kurireu bataruji kodi. ");
INSERT INTO bor_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dukodire nou boe enarare João Batistaji. Egore: – Nuba akaidure čerowo? ");
INSERT INTO bor_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","João Batista akore: – Nou ukudau areiare pobewu dukeje metia maku nou ukudau areia bokwareu imedu ai. Nou ukereu umode ia tuge maku uke bokwareuge etai. ");
INSERT INTO bor_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dukeje iage enaragodure João Batistaji etaidure João Batista uwo tao pegodo kodi. Egore: – Čegire čemode čegeragu imposto moriji boe epiji makuduwo boe eimijera kurireu ai. Nuba čeromode? ");
INSERT INTO bor_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","João Batista akore: – Tagiwogukaba. Tagaba boe eno imposto mori utudo tugori. ");
INSERT INTO bor_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tugobaigarege enarare João Batistaji jamedu. Egore: – Nuba čeromode? João Batista akore: – Tagorigodukaba boei. Taroreru kaba boei. Tagaba tageragu dieroji epiji. Tawudugugo tu je tamaragodae mori makudure tagai duji. ");
INSERT INTO bor_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nou boe epagare rugadu umode boe ekinorudowu imedu bagai. Emeardaere nou umode boe ekinorudowu nuie nou João Batistače. Dukodire enaragodure João Batistaji. Egore: – Aki na, amode boe ekinorudo? Amode boe ekinorudo boe pegareu piji? ");
INSERT INTO bor_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","17","Mare João Batista akore: – Ire boe etao pegodo pobo tabo mare ia imedu tuginaiwu aregodumode. Ro kodumode ikori. Boe pemegareu nure ema, boe kurireu mode ema rugadu. Dukodire ipogurumode ipureduwo ji, kurikareu nure imi dukodi. Emare umode Tuwari tugu boe emeardaeto boe ero pemegawo. Umode ro pegareuge ewarigu joruto jamedu. Romode nono ia imedu ro mogadure. Imedu umode trigo jukodo baku tabo nou pegareu uwo tudawuje nou trigo piji. Nou trigo remawu umode remo baito. Nou iwore umode barigu joruto. Umode boe ekinorudowu romode aino boei jamedu. Meartorure Pao Kurireu jiwuge ere nono trigo mogadure. Mare trigo ji karega inagoino. Umode boe ekinorudowu umode meartorure Pao Kurireu jiwuge etawuje ro pegareuge epiji tuwo edudo pudabo. Dujire inagoino. Umode ro pegareuge ewarigu bope doge eda kejewu joru pegareuto. Dujire inagoino. Nou joru akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ainore João Batista mako raire boei tuwo erduwado Pao Kurireu bataruji, tuwo e mekido emeardae pegareu piji tuwo edo tugera ra turo pegareu piji. ");
INSERT INTO bor_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","João Batista mako pegare boe eimijera kurireu Herodes rore jiboeji. Herodes ure tugeragu tumana oredujeji tumana piji tumuguwo nou tumana oreduje apo. Nou aredu iere Herodias. Herodes ro pegare ia turo pegareuji jamedu. Ro pegare jiboe makare. Dukodire João Batista mako pegare nou Herodes rore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dukodire Herodes ure João Batista tugu baičoreuto. Kodire ro pegareu kuričigore nouia turo pegareu kori. ");
INSERT INTO bor_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","João Batista rakojekare raga baičoreu tada dukejere maragodaere tuwo boe etao pegodo kimo. Boe ere tugera ra turo pegareu piji dukeje João Batista ure nou boe etao pegodo pobo tabo. Čare Jesus aregodure João Batista ae jamedu uwo tao pegodo pobo tabo jamedu. João Batista ure Jesus ao pegodo pobo tabo rugadu. Nono Jesus makore baruto tuo bagai. Dukejere Pao Kurireu Uwari ure turawuje Jesus ae. Ure tudo nono metugore. Ure tumugudo Jesus keje. Nono Pao Kurireu makore Jesusji baru piji. Akore: – Imeardu kuričigore jiwu itonaregedu unure aki. Are iagare kuričigodo i ai. ");
INSERT INTO bor_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus ure tugera tugu tumaragodaeto tuwo boe ewie Pao Kurireu bataruji tuwo boe erdudo turomode jiboeji kodire o jorure trinta. Boe emeardaere José onaregedu nuie ema duji. José uo iere Eli. ");
INSERT INTO bor_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli uo iere Matate. Matate uo iere Levi. Levi uo iere Melqui. Melqui uo iere Janai. Janai uo iere José. ");
INSERT INTO bor_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José uo iere Matatias. Matatias uo iere Amós. Amós uo iere Naum. Naum uo iere Esli. Esli uo iere Nagai. ");
INSERT INTO bor_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai uo iere Maate. Maate uo iere Matatias. Matatias uo iere Semei. Semei uo iere José. José uo iere Jodá. ");
INSERT INTO bor_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodá uo iere Joanã. Joanã uo iere Resa. Resa uo iere Zorobabel. Zorobabel uo iere Salatiel. Salatiel uo iere Neri. ");
INSERT INTO bor_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri uo iere Melqui. Melqui uo iere Adi. Adi uo iere Cosã. Cosã uo iere Elmadã. Elmadã uo iere Er. ");
INSERT INTO bor_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er uo iere Josué. Josué uo iere Eliézer. Eliézer uo iere Jorim. Jorim uo iere Matate. Matate uo iere Levi. ");
INSERT INTO bor_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi uo iere Simeão. Simeão uo iere Judá. Judá uo iere José. José uo iere Jonã. Jonã uo iere Eliaquim. ");
INSERT INTO bor_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim uo iere Meleá. Meleá uo iere Mená. Mená uo iere Matatá. Matatá uo iere Natã. Natã uo iere Davi. ");
INSERT INTO bor_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi uo iere Jessé. Jessé uo iere Obede. Obede uo iere Boaz. Boaz uo iere Sala. Sala uo iere Nasom. ");
INSERT INTO bor_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasom uo iere Aminadabe. Aminadabe uo iere Admim. Admim uo iere Arni. Arni uo iere Esrom. Esrom uo iere Peres. Peres uo iere Judá. ");
INSERT INTO bor_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá uo iere Jacó. Jacó uo iere Isaque. Isaque uo iere Abraão. Abraão uo iere Tera. Tera uo iere Nacor. ");
INSERT INTO bor_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor uo iere Serugue. Serugue uo iere Reú. Reú uo iere Pelegue. Pelegue uo iere Éber. Éber uo iere Selá. ");
INSERT INTO bor_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selá uo iere Cainã. Cainã uo iere Arpaxade. Arpaxade uo iere Sem. Sem uo iere Noé. Noé uo iere Lameque. ");
INSERT INTO bor_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque uo iere Matusalém. Matusalém uo iere Enoque. Enoque uo iere Jarede. Jarede uo iere Maalalel. Maalalel uo iere Cainã. ");
INSERT INTO bor_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã uo iere Enos. Enos uo iere Sete. Sete uo iere Adão. Imedu boetojiwu nure Adãoče. Pao Kurireu koiare ure Adão towuje. ");
INSERT INTO bor_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pao Kurireu Uwari rakojere Jesus apo. Dutabore Jesus ure tugirimi Jordão Po piji. Nou Pao Kurireu Uwari pemegareu makore Jesusji utuwo boe maereu ka. ");
INSERT INTO bor_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Torore merire 40 ji dutabore bope doge eimijera ure turokogado Jesusji tuwo Jesus meardae pegado tuiordae tumeardae ka. Nou meri jameduji Jesus okwagekare dukodire uke boeire ji. ");
INSERT INTO bor_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nou bope doge eimijera iere Satanás. Ča nou bope doge eimijera makore Jesusji. Akore: – Pao Kurireu onaregedu remawu mode aki dukeje amagodo awu toriji uwo tudo nono amireu mogadure awo kowuje. ");
INSERT INTO bor_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus akore: – Pao Kurireu o bakaru koiare iromodukare aino. Pao Kurireu meardaekare nono ameardae mogadure. Nou bakaru akore: “Boe eke mitodu tabo karega imedu jere mare Pao Kurireu o bataru jamedu boe tabore boe ewodure boe eragare.” ");
INSERT INTO bor_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Dukejere nou bope doge eimijera uture Jesus apo toro ia tori raireu ao ka. Ure Jesus jordudo moto jamedu boeji tači je. Akore: – Awu moto jamedu boe makudure inai inoče. Awu moto kejewuge eimijera nure imi. Itaidumode dukeje imode awu boe jamedu boe maku itaidure jiwuge etai. Ča amode apu jodo iogorai amagomode akaiduie i amoduie akimijerado imi ameartorumoduie i dukeje imode awu moto jamedu boe maku akai, imode awu moto kejewuge eimijerado aki. ");
INSERT INTO bor_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus akore: – Boro. Iromodukare aino. Padure bapera kejewu Pao Kurireu bataru akore: “Boe etaiduwo tu Pao Kurireuji. Boe ewo tubu jodo moto keje tu Pao Kurireu jokorai boe emago pemegawo tu Pao Kurireuji rugadu. Boe emeartoruwo tu Pao Kurireuji rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Bope doge eimijera uture Jesus apo toro Jerusalém ba kurireu ka. Uture apo toro Pao Kurireu uwai ričoreu ao ka. Nono makore Jesusji pugeje. Akore: – Pao Kurireu onaregedu remawu mode aki dukeje amode akaredo awu bai ričoreu ao piji toro moto ka. Padure bapera kejewu Pao Kurireu bataru akore tumoduie tudugarege baru tadawuge ekera bararedo ai etu pemegawo ai. Awure jamedu jetumodukaie toriji. ");
INSERT INTO bor_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mare Jesus akore: – Boro iromodukare aino. Nou padure bapera kejewu Pao Kurireu bataru remawu akore: “Boe ekawo turokogado Pao Kurireuji.” ");
INSERT INTO bor_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ainore Jesus akore nou bope doge eimijera bataru jipagi. Dukejere nou bope doge eimijera uture piji tubagawo toro ia meri ka pugeje. ");
INSERT INTO bor_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Jesus ure tugirimi tuibagi Galiléia moto ka. Pao Kurireu Uwari ure Jesus rakado turowo Pao Kurireu ro rakareuji. Nou moto kejewuge emeardure Jesus akaru pemegareuji dukodire boe erduware Jesus rore jiboeji makore jiboeji. Jesus ure boe erduwado tu tu je. Ure nou boe erduwado ere bato puiwu bai tada. Nonore ure boe ewie tu tu je Pao Kurireu bataru remawuji. Boe eiamedu boe emago pemegare Jesusji rore jiboeji makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus ure tugirimi nou Nazaré ba kurireu ka nou turijodure kejewu moto ka. Sábado meriji ure turemo nou baito, Judeu doge ere bato puiwu baito turo mogadure. Nono ure turagojedo tumagowo padure bapera kejewu Pao Kurireu bataruji boe ewiagai nou bai ja tada. ");
INSERT INTO bor_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nou boe ere Isaías ure bu bapera kejewu Pao Kurireu o bakaru maku Jesus ai aiwowo ji, makowo ji. Ure bapera jado. Aiwore taidure jiwu bataru bagai. Nono Jesus makore ji nou boe ewiagai. Akore: ");
INSERT INTO bor_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","– Pao Kurireu ure tugeragu jiwu akore aino: “Pao Kurireu ure tugeragu i dukodire Uwari rakojere itabo. Ure ido bakaru pemegareu arego marenarue doge ewagai. Ure itudo boe pegare jiwuge ewagai iwo ewie tuwadaru pemegareuji. Iwo ro pegareuge ewie Pao Kurireu umode turaga maku etai duji. Dukodire ro pegareuge ero pegamodukare pugeje emeartorumodukare bope doge eimijeraji pugeje. Joku bokwareuge etaiwomode pugeje. Boe pegare jiwuge etawujedumode boe pegareu piji rugadu. Pagimijera Kurireu umode meartorure puduiwuge ekinorudo rugadu. Dujire imode boe ewie rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus mako akedure dukeje ure nou Pao Kurireu o bapera okwa bu pugeje. Ure maku nou bai tadawu imedu ai. Nono Jesus ure tumugudo. Nou meardure Jesus akoinowuge eiamedu boe etaiwore Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nono Jesus akore: – Awu meriji tameardure jiwu Pao Kurireu bataru jeture pudui rugadu. Ire akoino. ");
INSERT INTO bor_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nou boe erdu pemegaiago Jesus bataruji. Egore: – Awu imedu mako moture. Mare kočare José onaregedu nure ema. Jorduware Pao Kurireu bataru jiwu umodukare ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus makore nou boe ewadaru jipagi. Akore: – Iorduware nuba tagagomode i. Ia meri keje tagagomode: “Boe egore jorubo epa remawu nuie aki dukeje akiogodo ai rugadu, čerduwo aro rakaredu bagai. Cafarnaum ba kurireu kejewuge egore aro rakaie. Ča aro rakado nouia aroji woe čegai čerduwo aroinoduji.” Ainore tagagomode i. ");
INSERT INTO bor_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","– Mare imire itaidure iwo tawie boe remawuji tu rugadu. Makore Pao Kurireu bataru jiwu makomode boe eiamedu boe ewiagai. Mare turijodure kejewu boe eda kejewuge etaidumodukare makore jiboeji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Marigudu Elias makore Pao Kurireu bataruji tuwobe jaoboe Judeu doge ewiagai woe Israel moto keje. Nou Elias ure bubutu akedudo rugadu. Jorure pobe metia bokware bubutu bokware duji. Dukodire boe eke bokware rugadu. Elias rore aino dukeje okoge bokwareu areme emagare Israel moto keje. Mare Pao Kurireu ukare Elias utudo nou Judeu doge ewagai emeartorukare pudui dukodi. Ure utudo toro ia moto jaereu ka ia aredu tuginaiwudo okoge bokwareudo bagai Sarepta ba kurireu ka, Sidom moto keje. Nou aredu tuginaiwudo meartorure Pao Kurireuji dukodire Pao Kurireu ure Elias utudo bagai. ");
INSERT INTO bor_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Marigudu Eliseu makore Pao Kurireu bataruji tuwobe jaoboe Judeu doge ewiagai woe Israel moto keje. Judeu doge ewiri pegareuge emagare Israel moto keje. Mare Eliseu ukare epemegago emeartorukare Pao Kurireuji kodi. Tu ia Síria moto kejewu biri pegareu meartorure. Dukodire Eliseu ure nou Síria moto kejewu boe tuginaiwu imedu biri pemegago tu je. Nou Síria moto kejewu imedu iere Naamã. ");
INSERT INTO bor_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ainore Jesus akore tumago pegareu tabo nou rakojere nou bai tadawu Judeu doge etuwobei. Nou boe emeardure Jesus akoino duji dukejere ekorigodure. ");
INSERT INTO bor_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dukodire ere tugeragu Jesusji. Ere tawuje nou bai piji turaga tabo nou ba kurireu piji toro tori ao ka tuwo barigu nou tori ao piji moto ka. ");
INSERT INTO bor_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mare Jesus padure ekajeje tači je dukodire uture epiji. ");
INSERT INTO bor_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus uture Cafarnaum ba kurireu ka. Nou Cafarnaum ba kurireu padure Galiléia moto keje. Sábado meriji Jesus uture Judeu doge ere bato puiwu bai ka. Nonore ure boe erduwado. ");
INSERT INTO bor_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Boe eiamedu boe eku kidure nou Jesus makore jiboeji. Jesus mako pemegare mako jetorore rugadu dukodire boe erduware Pao Kurireu bataru remawu jire akoino rugadu. ");
INSERT INTO bor_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nou meri keje bope uwari pegareu meture tadawu imedu rakojere nou bai tada. Nou bope uwari ure tumago rakado Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Akore: – Jesus nure aki rugadu! Arijodure Nazaré ba kurireu keje. Ča nuba aromode čei? Amode čedagedudo na? Iorduware ai rugadu. Aro pega bokware. Pao Kurireu ure akarego mato tuwadaru pemegareu tabo boe ewagai rugadu! ");
INSERT INTO bor_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus mako rakare nou bope uwari bataru jipagi. Akore: – Amugu kiorodo. Amagokaba boeji pugeje. Atawuje awu imedu piji atuwo pugeje. Ča nou bope uwari ure nou imedu butudo moto keje nou boe egorai. Dukeje ure tudawuje nou imedu piji. Mare boe pegakare nou imeduji. Ure turugadu. ");
INSERT INTO bor_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nou boe erdure nou inoduji dukejere erore ta je. Emagore pui. Egore: – Awu Jesus makore jiboe rakare rugadu. Makore nou bope uwariji dukeje nou bope uwari meartorure makore pudui duji rugadu. Ure tudawuje nou imedu piji kodire uture piji rugadu. Ainore nou boe egore. ");
INSERT INTO bor_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dukejere boe ere nou moto kejewuge boe eiamedu boe ewie nou Jesus rore jiboeji, makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus uture nou bai piji. Uture Simão Pedro uwai ka. Simão Pedro učarugo kogodure. Biri urure rugadu. Boe ere Jesus bie nou aredu kogodure duji. ");
INSERT INTO bor_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dukodire Jesus uture nou aredu ae. Nono rakojere nono nou Pedro učarugo upa jagwai dukeje Jesus makore ji biri urukawo pugeje. Ča nou Pedro učarugo biri uru akedure tači piji. Ča nou aredu ure turagojedo. Ure tuie bu tuwo nou boe eke pemegado ewo ko. ");
INSERT INTO bor_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nou boečoji boe eiamedu boe etaregodure tumedage kogodureugebo Jesus bagai. Jesus ure tugera bu nou kogodureuge ewugeje. Nono ure nou kogodureuge epemegago rugadu. ");
INSERT INTO bor_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bope doge etuwari pegareu meture iage etada. Nou bope doge ere tudawuje nou boe epiji jamedu. Ere tugudu rakado ture tudawuje nou boe epiji dukeje. Nou bope doge egore: – Pao Kurireu Onaregedu nure aki rugadu! Erduware umode boe ekinorudowu nure Jesusče rugadu mare Jesus aidukare boe erduwawo pudui. Dukodire Jesus mako rakare nou bope doge etuwairei emagokawo iaboeji pugeje. Dukodire nou bope doge emagokare iaboeji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Barogwakododure dukeje Jesus uture nou boe eda piji toro ia boe maereu ka. Mare boe emarure bagai. Erdure ji dukeje emagore ji utukawo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mare Jesus makore ei. Akore: – Pao Kurireu ure itudo mato iwo boe ewie tuwadaru pemegareuji, imagowo Pao Kurireu rore jiboeji boe ewiagai. Imagowo boei ewo tugimijerado Pao Kurireuče tu rugadu. Imaragodae jire iroino. Dukodire itumode ia boe eda tuginaiwu ka pugeje. ");
INSERT INTO bor_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dukodire Jesus uture nou moto kejewu boe eda jamedu boe ka. Uture tu tu nou Judeu doge ere bato puiwu bai ka eda jamedu boe ka. Makore Pao Kurireu bataruji boe eiamedu boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Ia meri keje Jesus rakojere ia kugaru keje Galiléia pobo maereu okwai. Jesus ure boe erduwado Pao Kurireu bataruji nono pobo maereu okwai. Boe etaregodure tuwiapagawo Jesus makore jiboeji. Emagare rugadu. Nono ere tuiodo pugeje tuwo tuburedo ji. Dukodire Jesus roiwakare tumagowo ei. Aidure tuwo tudaru epiji tumagowo ei. Jordure ika kurireu pobedu dogei nono pobo okwai. Nou ore nou ika kurireu čewuge ere tuwuge kabi nono pobo okwai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus ure taredo nou ika kurireuto. Ore nou ika čewu iere Simão Pedro. Jesus makore Pedroji. Akore: – Ako ika kogudo gu toro nowari okwa piji. Imode imugudo nou ika ja tada imagowo awu boei. Simão Pedro meartorure Jesus bataruji. Ure to ika kurireu kogudo gu toro nowari okwa piji. Nono Jesus ure tumugudo nou ika kurireu ja tada. Dukejere makore boei tuwo boe erduwado rugadu. ");
INSERT INTO bor_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesus mako raire boei tuwo erduwado. Nono ure tuwadaru akedudo dukeje makore Simão Pedroji pugeje. Akore: – Awu ika reko toro awu pobo maereu po koreu ka. Aki amedagebo tawo tawuge barigu tawoguwo. ");
INSERT INTO bor_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simão Pedro akore: – Čegimijera. Čewogure awu boečoji jii barogwakododu ka. Mare čegare boe bito rugadu. Du amagore i dukodire imode iwuge barigu pugeje. Imeartorure awadaruji dukodire imode iwuge barigu pugeje. ");
INSERT INTO bor_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nono Simão Pedro timediapo ere to ika reko Jesus apo toro pobo maereu po koreu ka. Ere tuwuge barigu. Ča ere tugeragu karei rugadu. Nou buke korobadure karebo dukodire nou bukere tuiago tuwowuje kare emodudu koia. ");
INSERT INTO bor_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nono makore ia tumedage etae ewo tugera maku pudai nouia ika kurireu tabo. Ere ika kurireuge ekorau karebo. Ere tuwogwaiago poboto kare emodudu koia. ");
INSERT INTO bor_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Dukodire Simão Pedro jorduware Jesus emare rore aino duji. Nou metage ekiere Tiago, João. Zebedeu ore nure emage. Erore ta je jamedu Jesus ure edo kare ewido aino duji. Nono Simão Pedro ure tubu jodo Jesus jokorai. Akore: – Imedu ro pegareu nure imi. Aiado i. Ukare turugadu iragojewo akabo. Nono Jesus makore Simão Pedroji. Akore: – Apagudukaba. Atumode itabo. Awu inodu otobiji awogumodukare kare ewagai pugeje. Awogumode boe ewagai. Mare awogu ji karega inagoino. Amode boe emeartorudo Pao Kurireuji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nono eture tuibagi pobo maereu okwa ka. Nono Pedro, nou metage, eture Jesus apo rugadu toe rugadu boe piji tumaragodae piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ia meri keje Jesus rakojere ia boe eda keje. Ia imedu mugure nou boe eda keje tugogodae tabo. Nou kogodae koiare ure nou imedu biri pegado rugadu. Boe epagudure nou kogodaeče rugadu. Nou biri pegareu imedu jordure Jesusji dukeje ure tubu jodo moto keje Jesus jokorai. Okwamagudure Jesusji. Akore: – Ikimijera. Aro rakare rugadu awo iwiri pemegago. Akaidumode dukeje amode ipemegago rugadu. ");
INSERT INTO bor_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus ure tugera raido nou imedu ae. Ure tugera bu imedu keje. Akore: – Uu. Itaidure. Ča. Apemegare rugadu. Nono nou imedu biri pemegagodure tači je. ");
INSERT INTO bor_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mare Jesus makore ji. Akore: – Amagokaba awu irore ai duji. Atudo kuri nou Pao Kurireu uwai ka. Nonore amode nou ure Judeu doge enomea maku Pao Kurireu aiwu imedu jordudo awiriji. Jordumode awiri pemegagodure duji rugadu. Nono amode nou Moisés makore jiwu mori maku ai rugadu nono paro mogadure. Nono nou ure boe enomea maku Pao Kurireu aiwu imedu umode nou are maku pudaiwu mori maku Pao Kurireu ai rugadu. Dukodire boe eiamedu boe erduwamode awiri pemegagodure duji. Ainore Jesus makore nou imeduji. ");
INSERT INTO bor_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mare boe erduwagodure Jesus rore jiboeji rugadu. Emagare taregodu tabo Jesus ae tuwiapagawo Jesus bataruji, tubemegagoduwo tugogodae piji. ");
INSERT INTO bor_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mare Jesus rakoje raikare boebo ji je. Uture boe epiji tu tu je toro boe maereu ka tumagowo baruto Tuo Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ia meri keje Jesus ure boe erduwado pugeje. Ia boe eimijerage fariseu doge edure nono nou boebo tuwiapaga tabo Jesus bataruji. Ia boe eimijerage jorduware Judeu doge eno bakaru jiwuge edure nono jamedu. Nou boe eimijerage etaregodure tumuga jamedu boe piji. Etaregodure Galiléia moto piji, Judéia moto piji, Jerusalém ba kurireu piji jamedu. Pao Kurireu raka meture Jesus apo dukodire roiware tuwo boe epemegago. ");
INSERT INTO bor_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nono ia boe etaregodure ia imedu pogora pegareu apo. Nou imedu pogora pegareu padure tugudau kodo keje. Etaidure tuwo turemo toro nou Jesus rakojere tadawu baito tuwo Jesus jordudo nou imedu pogora pegareuji. ");
INSERT INTO bor_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mare boe emagare tuiedui nono. Nou bai čekare nou boei. Dukodire nou boe eroiwakare tuwo turemo nou baito nou imedu apo. Dukodire erudure nou bai ao ka nou imedu pogora pegareu apo. Ere nou bai aia porodo. Nono ere nou imedu pogora pegareu rawuje bukigu tabo tuwo mugudo Jesus jokorai nou boe etoiadada. ");
INSERT INTO bor_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus jordure emeartorure pudui duji kodire etaregodure aino nou imedu pogora pegareu apo pudae duji. Dukodire makore nou imedu pogora pegareuji. Akore: – Ča. Me. Ire aro pegareu jamedu boe barigu apiji Pao Kurireu biagoduwo aro pegare jiboe piji. ");
INSERT INTO bor_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mare nou boe eimijerage fariseu doge, nou boe eimijerage jorduware Judeu doge eno bakaru jiwuge erdu pegare nou Jesus akoino duji. Egore tudada: – Awu makore jiboe ukare turugadu! Tu Pao Kurireu umode boe ero pegareu barigu boe epiji. Awu imedu ure tudo nono Pao Kurireure. Makočarore tuwadaruji rugadu. Ukare turugadu. Mako peganure tagoino dutabo Pao Kurireuji! ");
INSERT INTO bor_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus jorduware emeardaere jiboeji rugadu. Dukodire makore ei. Akore: – Kočare tameardae peganure imagore jiboeji tadada na? ");
INSERT INTO bor_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Boe jokodu. Boe emodukare boe ero pegareu barigu boe epiji rugadu. Mare boe emodukare awu imedu pogora pegareu pemegago jamedu. Emodukare pemegago rugadu. Tu Pao Kurireu koiare umode nou imedu pogora pemegago. Tu Pao Kurireu koiare umode boe ero pegareu barigu boe epiji dukodire biagodumode nou boe ero pegareu piji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ča imode awu imedu pogora pegareu pemegago dukeje tarduwamode Imedu Onaregedu nure imi duji. Dukodire imode tarduwado iragare iwo boe ero pegareu barigu boe epiji ewarigudukawo bope doge eda kejewu joru pegareuto rugadu. Ainore Jesus akore nou boe eimijeragei. Nono Jesus makore nou imedu pogora pegareuji. Akore: – Me. Aragojedo. Akeragu akudau kodoji atuwo tabo aibagi awai ka. ");
INSERT INTO bor_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ča nou imedu ure turagojedo rugadu. Ure tugeragu tugudau kodoji. Dukejere uture tabo pugeje. Meru pegakare. Uture tumago pemegareu tabo Pao Kurireuji. Nou boe eiamedu boe erdure nou rore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dukejere erore ta je. Nono epagudugodure jamedu. Mare emago pemegare Pao Kurireuji. Egore: – Awu meriji čerdure Pao Kurireu ro pemegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","28","Nou inodu otobiji Jesus jordure imposto diero makudumode aiwu imeduji. Nou imedu iere Levi. Nou Levi mugure nono ira keje. Nonore ure tugeragu dieroji boe epiji eno imposto moriji tuwo maku boe eimijera kurireu ai. Nono Jesus makore ji. Akore: – Ako itabo. Levi ure turagojedo. Ure tugera ra tumaragodae piji tuduwo Jesus apo. ");
INSERT INTO bor_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi makore Jesusji okwagewo toro tuwai keje pudabo. Dukodire Jesus uture Levi apo toro uwai ka. Boe emagare togwage tabo ebo nono. Imposto diero makudure aiwuge ime nure emage. Boe egore ro pegareuge nuie emage. Ia boe etaidukare jiwuge eragojere nono Jesus apo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nono fariseu doge etaregodure, jorduware Judeu doge eno bakaru jiwuge etaregodure jamedu. Ča emagore nou Jesus ure jorduwadowugei. Egore: – Kočare tagwagere tagudure awu ro pegareugebo? Ukare turugadu! ");
INSERT INTO bor_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus akore: – Jorubokuru epa jemarumodukare kogodukareuge ewagai. Mare kogodureuge ewagaire jemarumode tuwo epemegago. ");
INSERT INTO bor_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Irore nono nou jorubo kuru epa ro mogadure. Mare jorubokuru epa ji karega inagoino. Itaregodure woe mare ro pemegareuge ewagai karega iroino. Ro pegareuge ewagaire iroino ewo tugera ra turo pegareu piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ia meri keje boe etaregodure Jesus ae dukeje enarare ji. Egore: – Ia meri keje João Batista ure jorduwadowuge enogwagemodukare nou meri keje tumagowo baruto Pao Kurireu bagai nou meri keje. Eromode aino tu tu je. Tu turoia jire eroino. Fariseu doge ere jorduwadowuge eromode nono ero mogadure jamedu. Kodiba nou are jorduwadowuge erokare aino jamedu? ");
INSERT INTO bor_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Jesus akore: – Ire nono uwiremodewu imedu mogadure. Boe etuwiremode dukeje boe emode tuwadae towuje. Nou ewadae kejere boe enogwagemode rugadu. Ewadae reno. Mare ewadae akedure dukeje uwirereu imedu utumode epiji. Dukeje ia meri keje boe enogwagemodukare rugadu nou meri keje tumagowo Pao Kurireu bagai baruto. Ire nono nou uwiremodewu imedu mogadure. Mare uwiremodewu imedu ji karega inagoino. Ire irawuje baru piji mato boe ewagai. Mare ia meri keje itumode nou boe epiji. Dujire inagoino. Itumode nou boe epiji dukeje emode ia meri tawuje togwagekawo nou meri keje tumagowo Pao Kurireu bagai baruto. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nono Jesus makore ia bakaruji nou boe ewiagai tuwo jebato toro nouia Pao Kurireu meardaeji. Akore: – Boe ekudau areia pegagodureu umode tuwowuje dukeje boe emodukare tugudau areia maiwu kado tuwo bu nou tugudau areia pegagodureu tuwowujewu keje tuwo miwuje tabo pegagodure dukodi. Boe eromode aino dukeje emode nou tugudau areia maiwu pegado. Nou emode kadowu areia maiwu umodukare turugadu nou tugudau areia pegagodureu okwa togi jamedu. ");
INSERT INTO bor_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Boe ere tapira biri maiwu kado tuwo udo nono poari mogadure tuge vinho kuru maiwu jače. Mare emode vinho kuru maiwu tugu tapira biri čodureuto dukeje nou tapira biri čodureu umode tuwowuje. Nono nou vinho kuru umode tuwarigu nou tapira biri čodureu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dukodire boe ekare tuge vinho kuru maiwu tugu tapira biri čodureuto. Ere tuge vinho kuru maiwu tugu tapira biri maiwuto tu tu je. ");
INSERT INTO bor_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nou aidure vinho kuru čodureu jiwuge etaidumodukare vinho kuru maiwuji. Egomode: “Jowu metu raire tapira biri čodureu tadawu vinho kuru pemegare čei.” Ainore Jesus akore. Mare areia ji karega akoino. Vinho kuru ji karega akoino. Tuwadaru maiwu jire Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jesus merure boepa oiagi sábado meriji. Trigore nou boepa tada. Nou ure jorduwadowuge ekodure apo jamedu. Nono nou Jesus ure jorduwadowuge ere tugeragu trigo enariji. Ere tugera reko pui nou trigo enari tabo tuwo nou trigo tawuje čiwu piji tuwo trigo ko. ");
INSERT INTO bor_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseu doge erdure erore aino duji dukeje emagore Jesusji. Egore: – Akaiwodo. Judeu doge nure pagi. Sábado meriji pamaragodumodukare pugeje. Dukodire pamodukare pageragu trigoji sábado meri keje. Mare tare tageragu trigoji sábado meri keje. Ukare turugadu! ");
INSERT INTO bor_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus akore: – Tarduwakare Pao Kurireu bataruji! Dukodire tarduwakare Pao Kurireu meardae remawuji. Tarduwamode Pao Kurireu meardae remawuji dukeje tamago pegamodukare čeroino duji. Mariguduwu Judeu doge eimijera kurireu Davi rore jiboe padure Pao Kurireu bataru keje. Dujire tarduwakare. Nou Davi uke boeire ji. Utugarege tugobaigarege eke boeire ei jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dukodire ure turemo Pao Kurireu uwaito. Okwagere boe ere maku Pao Kurireu aiwu amireuji. Pao Kurireu ure tuwadaru maku mariguduwuge pawobe Judeu doge etai. Dukodire makore ei ekawo nou amireu kowuje. Tu nou ure Judeu doge enomea maku Pao Kurireu aiwuge emode nou Pao Kurireu uwai tadawu amireu kowuje. Ainore Pao Kurireu akore. Mare Davi ure nou Pao Kurireu uwai tadawu amireu kowuje. Ure ia maku tudugarege etai ewo kowuje jamedu. Mare Pao Kurireu mako pegakare eroino duji. Dukodire imagore aino tai tamago pegakawo čere čegeragu trigo jituji. ");
INSERT INTO bor_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ča iwo tawie. Imedu Onaregedu nure imi. Imire imode boe erduwado rugadu nuba boe eromode sábado meri keje. ");
INSERT INTO bor_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ia Sábado meri keje Jesus ure turemo ia Judeu doge ere bato puiwu baito pugeje. Ure nou boe erduwado Pao Kurireu bataruji. Ia imedu rakojere nono. Iera pegare. Nou iera bekurure pudo. ");
INSERT INTO bor_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ia fariseu doge, ia jorduware Judeu doge eno bakaru jiwuge edu nono jamedu. Boe eimijerage nure emage. Nou boe eimijerage erdu pegare Jesusji. Dukodire etaiwore Jesus ia ro pegamode tiagai dubagai. Judeu doge eromodukare ia turoji sábado meri keje. Dukodire etaidukare boe eiogowo boei sábado meri keje. Mare Jesus umode nou imedu iera pemegago nou meriji dukeje nou boe eimijerage erdu pegamode nou Jesus rore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mare Jesus jorduware erdu pegare pudui duji. Jorduware emeardaere jiboe jamedu boeji. Nono Jesus makore nou imedu iera pegareuji. Akore: – Aragojedo. Mato itae awu boe etoiado. Nou imedu ure turagojedo. Nono uture Jesus ae nou boe etoiado. ");
INSERT INTO bor_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nono Jesus unarare nou boei. Akore: – Nuba pago bakaru ure parduwado paroiago sábado meriji? Paro pegamode boei kana? Paro pemegamodukana boei? Sábado meri keje pamodukana boe ekinorudo boe pegareu piji? Pamodukana boe ewarigu boe pegareuto sábado meri keje? ");
INSERT INTO bor_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus aiwore ei. Mare emago bokware Jesus bataru jipagi. Nono Jesus makore nou imedu iera pegareuji. Akore: – Akera raido itae. Nono nou imedu ure tugera raido ae. Čare iera pemegagodure tači je. ");
INSERT INTO bor_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nou boe eimijerage erdure nou inoduji dukeje ekorigodure rugadu. Erdu pegare Jesus rore aino sábado meri keje duji. Du otobiji emagore pui tu tu je tuwo ia tumeardae tawuje turo pegawo Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ia meri keje Jesus ruture ia tori ao ka tumagowo baruto. Nono makore Pao Kurireuji jii je barogwakododu ka. ");
INSERT INTO bor_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Barogwakododure dukeje makore ture jorduwadowuge ewagai. Nou ture jorduwadowuge epiji ure tugeragu jiwuge enodo padure doze. Du emagere etumode Jesus bataru tabo boe eiamedu boe ewagai. ");
INSERT INTO bor_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ainore nou boe ekiere. Simão, Jesus ure iedo Pedro. Uwie André. Tiago, João, Filipe, Bartolomeu, Mateus, Tomé. Tiago, Alfeu onaregedu. Simão, Zelote ure ema. Judas, Tiago onaregedu. Judas Iscariotes. Emare umode Jesus maku boe eimijera pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","19","Nono Jesus ure turawuje nou tori ao piji nou ture tugeragu jiwu boebo. Boe emagare taregodu tabo ae tumearduwo bataruji. Boe etaregodure Judéia moto piji, Jerusalém ba kurireu piji, Tiro ba kurireu piji, Sidom ba kurireu piji tumearduwo Jesus bataruji, uwo tubemegago tugogodae boe piji. Bope ro pegare jiwu boe doge etaregodure ae jamedu. Jesus ure nou bope doge etawuje nou boe epiji. Nou boe emagare rugadu. Erduware Jesus ure boe epemegago duji rugadu. Etaidure tuwo tugera bu Jesus keje. Emeardaere tumoduie tugera bu Jesus keje dukeje umoduie tubemegago. ");
INSERT INTO bor_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus makore ture jorduwadowugei. Akore: – Marenarue nure ia tagi mare taegaredo tai. Taragojemode Pao Kurireu apo rugadu. Tare tagimijerado ema dukodire taragojemode apo rugadu boe pemegareu keje. Dukodire boe pemegamode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ia tagi tage boeire tai mare du inodu tabo taegaredo tai. Boe pemegamode tai. Mare paga karega. Tage kurimode rugadu. Ia tagi tagragudure tagiarigodu koia. Mare du inodu tabo boe pemegamode tai rugadu dukodire taegaredo tai. Tagogwarigodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Boe ekadakagirimode tai tameartorumode imagore tai jiboeji. Tagodumode iwadaru kodaji dukeje boe emodukare tuiordudo tai, erorerumode tai, egomode meridoge enuie tagi. Ainore etuwobe emago pegare nou jaoboei jamedu. Mariguduwu etuwobe ero pegare nou mariguduwuge makore Pao Kurireu bataru jiwugei jamedu. Mare tare tameartorudo i dukodire emago pegamode aino tai jamedu. Mare taegaredo tai. Boe pemegamode tai. Mare paga karega Pao Kurireu umode mori kurido tagai toro baru tada. Dukodire čare taegaregodumode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mare Jesus mako pegare iagei. Akore: – Ia tagi oe kurireuge nure tagi. Dukodire taegarere tai nou tagoeji. Mare tawiapagakare baru tadaboe bagai. Dukodire boe pemegamodukare tai. Nou tagoe akedumode rugadu. Nou tagoe umodukare taginorudo boe pegareu piji. ");
INSERT INTO bor_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","– Ia tagi tage kurire. Dukodire taegarere tai tageji. Mare tawiapagakare baru tadaboeji. Dukodire boe pemegamodukare tai. Tage akedumode rugadu. Tage umodukare taginorudo boe pegareu piji. – Ia tagi taegarere tai dukodire tagogwarire aino jamedu. Mare tawiapagakare baru tadaboeji. Dukodire boe pemegamodukare tai rugadu. Tagragudumode, tamode maido tagabo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","– Boe ebogodure ia tai. Dukodire taegaregodure tai nou ewadaruji. Mare pagare egoino. Mariguduwuge ewobe ebogodure batrarodure Pao Kurireu bataru jiwugei. Aino čare boe ebogodure tai jamedu. Mare tawiapagakare Pao Kurireu mako pemegare tai jiboeji. Dukodire boe pemegamodukare tai. ");
INSERT INTO bor_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesus mako kimore. Akore: – Tawiapagado awu iwadaruji. Tameardu kurido jordu pegare taiwugei. Taro pemegado kadakagirire taiwugei jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tawadaru pemegado nou bataru pegare taiwugei. Tamagodo baruto Pao Kurireu bagai nou ro pegare taiwuge eparu tabo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ia ro pegareu umode tugera to aeji, ae abowu metia maku ai uwo tugera to ji jamedu. Ia boe umode akudau areia okwatorureu biaku epa tawuje apiji dukeje maku ai rugadu. Mare ia akudau areia meture aiwu maku ai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iaboe maku okwamagudure aiwu boe etai. Nouia boe ure tugeragu akoe jitu keje akaba udo maku akai tuibagi pugeje. ");
INSERT INTO bor_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Taro pemegado boei boetoji nono tagaidu mogadure boe ero pemegawo tai du mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","33","Tameardu kurimode tu ro pemegare taiwugei dukeje taro pemegamodukare ro pegareuge ero kori. Ro pegareuge emeardu kurire ro pemegare puduiwugei jamedu. Taro pemegamode nou ro pemegare taiwugei mare taro pegamode nou ro pegare taiwugei dukeje tarore nono nou ro pegareuge ero mogadure jamedu. Ro pegareuge emeardu kurire ro pemegare puduiwugei jamedu. Mare tameardu kurimode ro pegare taiwugei dukeje Pao Kurireu ro pemegamode tai. ");
INSERT INTO bor_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tamode diero maku boe etai mare tagaidure ewo maku tuibagi tagai pugeje. Taromode aino dukeje tarore nono ro pegareuge ero mogadure. Pao Kurireu mako pemegamodukare tai pugeje. Ro pegareuge emode diero maku iage etai mare ewo nou diero rugadu maku pudai tuibagi pugeje. ");
INSERT INTO bor_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Aino čare imode tarduwado. Pao Kurireu ro pemegare ro pegareugei. Pao Kurireu okudure boebo rugadu. Ča taro pemegado nono Pao Kurireu ro mogadure jamedu. Tameardu kurido aidukare taiwugei nono Pao Kurireu ro mogadure. Ia tagoe maku etai jamedu. Taipagakaba ewo maku tuibagi tagai pugeje nono Pao Kurireu ro mogadure. Tagogududo boebo nono Pao Kurireu okudu mogadure boebo dumogadure jamedu. Taromode aino dukeje Pao Kurireu oremode tagi. Umode boe pemegareu maku tagai. ");
INSERT INTO bor_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","– Tawiapagakaba boei boe pegareu tabo. Nono Pao Kurireu ro pegamodukare tai. Tagaba boe ewarigu boe pegareuto Pao Kurireu ukawo tawarigu boe pegareuto jamedu. Boe ero pegare tai dukeje tawiago nou erore tai dupiji. Dukeje Pao Kurireu biagodumode taro pegareu boe piji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ia tagoe maku ia boe enoe bokwareuge etai. Nono Pao Kurireu umode ia boe pemegareu maku tagai jamedu. Umode maku tagaiboe kurimode rugadu. Umode maku tagai nono tamode maku boe etai du mogadure. ");
INSERT INTO bor_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nono Jesus ure nou tuwadaru jebato toro ia Pao Kurireu meardae ka tuwo nou boe erduwado ji. Akore: – Joku bokwareuge ekera bararemode pui dukeje ewudumode boeiakoto. Jorduwakare Pao Kurireu jiwuge ere nono nou joku bokwareuge emogadure. Mare joku bokwareuge ei karega inagoino. Jorduwakare Pao Kurireu jiwuge eroiwakare tuwo boe erduwado Pao Kurireuji. Dujire inagoino. Etaidumode tuwo erduwado mare emode ewarigu Pao Kurireu piji. Dujire inagoino. Erduwakare Pao Kurireuji. Emeartorukare ji jamedu. Dukodire eroiwakare tuwo boe erduwado Pao Kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Boe emeartorumodukare ia mugure bapera kejewuji jorduwamodukare nono tugimijera mogadure. Boe emeartorumode tu nou mugure bapera kejewu ukimijeraji. Mare nou ukimijera umode nou mugure bapera kejewu jorduwado tuiorduware jiboe jamedu boeji dukeje nou mugure bapera kejewu jorduware jiboe umode nono nou tugimijera jorduware jiboe mogadure. Du ure turugadu. ");
INSERT INTO bor_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Tagi tardure tamedia joku tadawu boe giguduji. Mare tardukare taeku tadawu iraji. Mare boe gigudu ji karega inagoino. Boe ero pegareu rogu jire inagoino. Biagare tu je mare tardure ji. Dujire inagoino. Dukodire tamago pegare nou tamediaji. Tagagore: “Aro pega” aino ji. Tagagore tarduwaie tamedia ro pegareuji mare tardukare ia taro pegareuji. Dukodire tameartorukare tawadaruji. Tardukare taeku tadawu ira kurireuji. Mare ira ji karega inagoino. Taro pegareu kurireu jire inagoino. Taro pega kurire rugadu mare tagare tardudo ji. Dujire inagoino. Kočare. Tagera ra taro pegareu piji. Tamode tagera ra taro pegareu piji dukeje tarduwamode rugadu tamago pemegawo nou tamediaji nou tamedia uwo tugera ra turo pegareu biagareu piji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","– I pegareure tudu pegare. I pemegareure tudu pemegare. ");
INSERT INTO bor_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Boe erduwamode tuduji dukeje erduwamode nou tudu iji jamedu. Boe emodukare tugeragu figo tuduji botoguru i piji. Figo i pijire boe emode tugeragu figo tuduji. Boe emodukare tugeragu uva tuduji botoguru i piji. Uva iku pijire boe emode tugeragu uva tuduji. ");
INSERT INTO bor_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Boe ere nono nou iguru mogadure. Mare iguru ji karega inagoino. Boe emeardae koiare umode boe ero pemegado umode boe ero pegado. Dujire inagoino. Boe ewiagoromode tumeardae pegareuji dukeje ero pegamode emago pegamode nono nou tumeardae mogadure. Mare boe ewiagoromode tumeardae pemegareuji dukeje ero pemegamode emago pemegamode nono nou tumeardae mogadure. Dujire inagoino. Tumeardaere jiboe jire boe emagomode, eromode tu tu je. ");
INSERT INTO bor_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesus mako kimore nou boei. Akore: – Ia tagi tamagore tagimijera nuie imi. Ma kočare tameartorukare iwadaruji. ");
INSERT INTO bor_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ia imedu ure tuwai towuje. Ure ia iguru pemegareu tugu mototo. Ure tugera pemegado ji tuwo tuwai pemegado bakuru ukawo tuwai butudo. Nono bubuture. Pobo aregodure rugadu. Nou poborereu jeture nou imedu uwaiji. Mare nou uwai rakare rugadu. Butukare. Ča meartorure iwadaru jiwu akedumodukare nono nou bai mogadure. Mare bai ji karega inagoino. Boe ewiapaga pemegamode iwadaruji dukeje emeartorumode rugadu imagore jiboe jamedu boeji. Dukodire nou boe erduwamode rugadu dukodire boe pemegamode ei rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ia imedu ure tuwai pemegado jamedu mare ure tugeragu ia iguru pegareuji. Ure tugu mototo mare ukare bure tugu pemegado. Iera kiogwakare nou tuwaiji. Nono pobo aregodure. Dukodire pobo jeture nou imedu ure towu baiji. Nono nou uwai buture. Pobo ure nou uwai butudo rugadu. Ure rugadu pegado tači je. Ča nou meartorukare iwadaru jiwu jorduwa bokwamode dukodire boe pegamode ji nono boe pegare nou bai jitu mogadure. Mare bai ji karega inagoino. Boe emeartorumodukare tumeardure jiwu iwadaruji dukeje boe pegamode ei rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus mako akedure nou boei dukeje uture epiji toro Cafarnaum ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma kejewu tugobaigarege edure nono nou ba kurireu keje jamedu. Nou tugobaigarege eimijera aidure rugadu ia tudugare imeduji. Mača aino nou utugare imedu kogodure. Puredugodure tuwiwo. ");
INSERT INTO bor_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nou tugobaigarege eimijera meardure Jesus rore jiboeji. Meardure Jesus aregodure mato duji. Dukodire ure Judeu doge eimijerage etudo toro Jesus bagai Jesus aregoduwo uwo nou tudugare imedu kogodureu pemegago. ");
INSERT INTO bor_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dukodire nou Judeu doge eimijerage eture Jesus bagai. Etaregodure Jesus ae dukeje enogwamagudure Jesusji utuwo pudabo toro nou tugobaigarege eimijera uwai ka uwo nou tugobaigarege eimijera utugare imedu pemegago. Emagore Jesusji. Egore: – Awu tugobaigarege eimijera ro pemegare boei. ");
INSERT INTO bor_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Meardu kurire Judeu dogei. Čegimijera pemegareu nure ema. Ure ia bai rakojedo čenai čewo bato pui nou bai ja tada čemagowo baruto Pao Kurireu bagai nono. ");
INSERT INTO bor_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dukodire Jesus uture nou Judeu doge eimijeragebo toro nou tugobaigarege eimijera uwai ka. Mare etaregodukare toro raga dukeje ia tugobaigarege etaregodure etogi nou tugimijera bataru tabo. Emagore Jesusji. Egore: – Čegimijera makore atukaiago toro tuwai ka pugeje. Akore boe eimijera kurireu nuie aki. Akore boe eimijera kurireu ukaie gure pudumi. Dukodire akore akaregodukaiago pudae toro tuwai ka. ");
INSERT INTO bor_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Akore tuboguruie turore jiboeji dukodire taregodumodukaie mato atogi. Akore amagomoduie dukeje tudugare pemegagodumoduie. ");
INSERT INTO bor_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akore tugobaigarege eimijera nuie pudumi. Akore tugimijeraie jamedu. Kodire tuiorduwaie boe eimijera rore jiboeji. Akore tumagomoduie ia tugobaigare utuwo ia boe eda ka dukeje nono tugobaigare utumoduie rugadu. Meartoruie tuwadaruji kodi. Tumagomoduie ia tugobaigare aregoduwo pudae dukeje nou tugobaigare aregodumoduie pudae rugadu. Tumagomoduie tudugare rowo iaboeji dukeje tudugare meartorumoduie tumagore jiboeji rugadu. Akore boe eimijera kurireu nuie aki rugadu. Boe ekogodae meartorumoduie awadaruji rugadu. Amagomoduie dukeje tudugare pemegagodumoduie tači rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nou tugobaigarege eimijera bataru ure Jesus joku kidugo. Jesus makore nou rakojere pudabowu boe dogei. Akore: – Iwo tawie. Nou tugobaigarege eimijera meartorure idu kodure Israel moto kejewu Judeu doge eiamedu boe emeartorure idu kori. ");
INSERT INTO bor_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nono nou tugobaigarege eimijera utugarege ere tugirimi Jesus piji tugimijera uwai ka. Etaregodure dukeje erdure nou tugimijera utugare kogodureuji. Mare kogodukare pugeje. Pemegagodure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nouia barogwato Jesus uture Naim ba kurireu ka ture jorduwadowugebo. Nouia boe emagare rugadu tugodui Jesus rekodaji. ");
INSERT INTO bor_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesus puredugodure nou ba kurireu ka dukeje ia boe ere tudawuje nou Naim ba kurireu piji ia iparedu bireu apo tuwo tugu mototo. Nou iparedu uče oredu bire pijiwudo onaregedu rogu ure mitotu je. Boe emagare rugadu ture tudawuje nou Naim ba kurireu piji tudui nou bireu apo dutabo. ");
INSERT INTO bor_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus jordure nou areduji dukeje okudugodu kuričigore nou aredu apo. Akore: – Akragudukaba. ");
INSERT INTO bor_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nono ure tuburedo nou bireu meture tadawu ira ka. Nono ure tugera bu nou metu tadawu ira aogeje. Nono nou oredure nou bireu apowuge ere tuwuredo. Jesus makore nou bireu ipareduji. Akore: – Me. Amugudo. Atawuje nou ira piji. ");
INSERT INTO bor_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nono nou iparedu ure tumugudo. Jewodure tuwi piji rugadu dukodire makore jamedu. Nono Jesus ure nou iparedu maku tuje ai. ");
INSERT INTO bor_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nou boe eiamedu boe epagudugodure Jesus rore aino duji. Egore: – Ča makore Pao Kurireu bataru jiwu imedu kurireu aregodure pagae rugadu. Pao Kurireu aregodure tuwo tugera maku pagai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Awu bataru pemegareu ure tumaedo nou Judéia moto jamedu boe parugajeje. Ure tumaedo nou moto tuginaiwu jamedu boe parugajeje jamedu. ");
INSERT INTO bor_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","João Batista ure jorduwadowuge eture João Batista ae baičoreu ka tureadoduwo biagai awu Jesus rore jiboeji. Ereadodure biagai dukeje João Batista makore nou ture jorduwadowuge pobedu doge ewagai. Makore ei. Akore: – Tanarado Jesusji, “Nou Pao Kurireu umoduie maku boe etaiwu boe ekinorudowu nure aki rugadu kana? Čebagamode ia bagai kimo kana?” Tanarado aino Jesusji inai. ");
INSERT INTO bor_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nono nou ime eture Jesus ae rugadu. Emagore Jesusji. Egore: – João Batista ure čedudo mato akae čenaragoduwo aino ai. Nou Pao Kurireu umoduie maku boe etaiwu boe ekinorudowu remawu nure aki? Čebaga kimomode kana ia bagai? ");
INSERT INTO bor_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nou meriji Jesus ure kogodureuge epemegago. Ure bope doge etawuje epijiwuge emagare jamedu. Ure joku bokwareuge etaiwodo pugeje jamedu. ");
INSERT INTO bor_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dukodire Jesus makore nou João Batista ure jorduwadowugei. Akore: – Tagirimi tawo João Batista biedu pemegado rugadu tardure jiwu irore jiboeji, tameardure jiwu imagore jiboeji. Ire joku bokwareuge epemegago etaiwowo pugeje. Ire pogora pegareuge epemegago emeruwo pugeje. Ire kogodureuge ewiri pegareuge epemegago ewiri pemegawo pugeje. Ire bija bokwareuge epemegago emearduwo pugeje. Ire bireuge eewodudo pugeje. Ire marenarue doge ewie nou umode boe ekinorudowu aregoduie rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Boe pemegamode nou meartorure iwu boei. Emodukare tugera ra tumeartorure i dupiji nono egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Nou João Batista ure jorduwadowuge eture pugeje dukeje Jesus makore João Batista rore jiboeji nou rakojere pudabowu boe doge ewiagai. Akore: – Marigudu tadure jiče boe maereu ka mare tarduwo bakuru jeture boebutu jitu bagai karega. Tarduwo ukudau areia motureu jiwu boe ewagai karega. Tarduwo oe kurireuge ewagai karega. Nou ukudau areia motureu jiwu boe emugure bai kurireu tada. Oe kurireuge emugure bai kurireu tada. Tadumode bai kurireu ka nouge ewagai. Mare tadure boe maereu ka. Tadure toro tarduwo João Batistaji. João Batista mugure boe maereu keje. Ukudau areia pemegakare, motukare ji. ");
INSERT INTO bor_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tarduware João Batista makore Pao Kurireu bataru jituji. Dukodire tadure toro boe maereu ka João Batista bagai. Aino ča imode tawie. João Batista makore Pao Kurireu bataruji rugadu. Iwo tawie iaboeji pugeje. João Batista rore nono Pao Kurireu meardae mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Marigudu Pao Kurireu akore: “Imode itugare arego uwo boe pemegado nou umode boe ekinorudowu togi.” Ainore Pao Kurireu akore marigudu. João Batista jire akoino. Dukodi čare awu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus mako kimore. Akore: – Iwo tawie. João Batista kurire boe eiamedu boe ekori. Mare aino ia boe etugare umode tugimijerado Pao Kurireuče dukeje Pao Kurireu jakai boe kurireu mode ema João Batista kori. ");
INSERT INTO bor_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nou boe eiamedu boe emeardure nou Jesus makore jiboeji. Ia imposto mori makudure aiwuge eragojere nono ebo jamedu. Marigudu João Batista ure etao pegodo. Emeartorure Pao Kurireu bataruji dukodire João Batista ure etao pegodo. Aino čare emeardure Jesus makore jiboeji dukeje emago pemegare Pao Kurireu meardaeji. Egore pemegaie. ");
INSERT INTO bor_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mare fariseu doge ekare João Batista udo tao pegodo. Nou jorduware Judeu doge eno bakaru jiwuge ekare João Batista udo tao pegodo jamedu. Turore aino dutabo ere boe erduwado tumeardae pegareuji. Nou fariseu doge, nou jorduware Judeu doge eno bakaru jiwuge ere tumeardae pegareu tawuje tumeartorukawo Pao Kurireu makore pudui jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus makore boei pugeje. Akore: – Imode tarduwado nuba nou meartoru bokwareuge emeardaere. ");
INSERT INTO bor_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Boe etore ewadure puapo mare etokire pui. Egore: “Čere bapo akodo. Nono čemagore tai tareruwo mare tarerukare. Nono čemagore tai tagraguduwo čedabo mare tagragudukare.” – Ainore boe etore egore pui. Epemegakare pui rugadu. Ča nou meartoru bokwareuge ere nono nou boe etore emogadure. Mare boe etore ei karega inagoino. Pao Kurireu makore meartoru bokwareuge ewagai mare erokare iaboeji. Dujire inagoino ");
INSERT INTO bor_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pao Kurireu ure João Batista arego mato boe etae. João Batista ure tugera ra tuge piji tumagowo baruto jao nono boe ero mogadure. João Batista kudukare vinho kuruče nono ro pemegareu boe ero mogadure. Mare boe emago pegare ji. Egore bope uwari metuie tada. ");
INSERT INTO bor_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nono Pao Kurireu ure Imedu Onaregedu arego mato boe etae. Mare ire inagoino. Inogwagere boebo. Ikudure boebo. Mare du inodu tabo boe emago pegare i jamedu. Egore inogwage ierikaie. Mare pagare egoino. Egore Ikudu kigoduie vinho kuruče. Itaiduie ro pegareugei, imposto mori makudure aiwugei, marenarue dogei jamedu. Ainore egore. Mare tumago pegareu tabore egoino i. Dukodire inagoino meartoru bokwareuge nure emage. ");
INSERT INTO bor_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mare Pao Kurireu jorduware boe jamedu boeji. Ia boe emeartorumode Pao Kurireu bataruji dukeje meardae kurireuge mode emage. Nou ero koiare umode boe erdudo Pao Kurireu ure erduwado boe remawu jituji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseu imedu makore Jesusji okwagewo pudabo tuwai keje. Nou imedu iere Simão. Jesus uture uwai ka. Ure tumugudo ebo togwagewo. ");
INSERT INTO bor_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Dukeje aredu umode tumagu paga paga ime etaiwudo jorduware Jesus okwagere nou fariseu uwai keje duji. Dukejere nou aredu aregodure Jesus ae nou boe ewai ka poari rogu tabo. Nou boe ere nou poari towuje tori tabo. Nou tori iere alabastro. Roreboe mori kurireu meture nou poari rogu tada. Nono nou aredu biabuture nou turo pegareu boe keje dukodire ragudu kuričigore dukodire nou jokuru buture Jesus bure keje. Ča nono nou aredu ure Jesus bure kidudo tao tabo. Nono ure togwa to bureto. Nono ure nou roreboe redo Jesus bure joki. ");
INSERT INTO bor_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nou fariseu imedu jordure nou aredu rore aino duji dukeje jordu motukare nou aredu rore aino Jesus jituji. Dukodire nou fariseu imedu biagorore tudada. Akore: – Kočare nou aredu rore aino nou Jesusji. Iordu motukare rore aino iwai ja tada duji. Kodiba Jesus ure nou aredu rodo ino pudui? Makore Pao Kurireu bataru jiwu karegure ema. Makore Pao Kurireu bataru jiwu umode ema dukeje jorduwamode nou aredu rore jiboeji, umode tumagu paga paga ime etaiwudo nure emarodo rugadu. Dukeje awu Jesus umodukare nou aredu rodo ino pudui. Makore Pao Kurireu bataru jiwu karegure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mare Jesus jorduware nou Simão makore tudada jiboeji. Dukodire makore Simãoji. Akore: – Iorduware awu areduji, umode tumagu paga paga ime etaiwudo nure ema rodo rugadu. Ča ireadodumode iaboeji tawiagai. Simão akore: – Areadodudo. ");
INSERT INTO bor_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus akore: – Imedu ure diero maku aiwuge imere pobe. Ia ai ure oto bu 500. Nou metia ai ure oto bu 50. ");
INSERT INTO bor_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Boe aregodure nou meri ka ewo nou diero maku tuibagi nou imedu ai. Mare ere nou diero rugadu akedudo kodire eroiwakare tuwo morido tuibagi. Dukodire nou imedu makore ei ekawo morido pudai enoe bokware kodi. Kaibowu imedu ba meardu kurimode nou imeduji rugadu? ");
INSERT INTO bor_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","44","Simão akore: – Ure diero oto bu 500 aiwu imedure meardu kurimode rugadu nou ure diero maku pudaiwu imeduji rugadu ukare udo morido pudai kodi. Jakaremode pudui akore aino pudui duji. Okwa imadumode apo rugadu ukare udo morido pudai kodi. Nono Jesus akore: – Boe jokodu. Ča ire iremo awaito mare akimadukare itabo. Akare pobo maku inai iwo iwure kabi akimaduwo itabo nono Judeu doge ero mogadure. Mare awudorema ure iwure kabi tuioguru tabo, ure iwure kidudo tao tabo. ");
INSERT INTO bor_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aki akare akogwa to ie koduto akimaduwo itabo nono Judeu doge ero mogadure mare awudorema ukare tugera ra ture togwa to iwureto dupiji. ");
INSERT INTO bor_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Akare boekaguru tugu itaoto nono Judeu doge erore tugimaduwo boebo dumogadure, mare awudorema ure roreboe reko iwure joki. ");
INSERT INTO bor_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Awu aredu rore aino i dukodire iorduware meardu kurire i rugadu duji. Pao Kurireu biagodure awu aredu ro pegare jiboe piji tuwo awu aredu ro pegareu boe pijido ukawo morido pugeje dukodire meardu kuričigore aino i. Mare tagi tameardaere taro pegareu bokwaie kodire Pao Kurireu ukare taro pegareu pijido. Dukodire tameardu kurikare aino i rugadu. ");
INSERT INTO bor_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nono Jesus makore nou areduji. Akore: – Aro pegareu jamedu boe iwiagodure piji marigudu. ");
INSERT INTO bor_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dukodire čare nou Simão, nou mugure nono apowuge, erdu pegare Jesus akoino duji. Egore: – Ukare turugadu. Awu Jesus umodukare boe ero pegareu barigu boe epiji. Tu Pao Kurireu romode aino tu rugadu. Emeartorukare Jesusji dukodire egoino. ");
INSERT INTO bor_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus makore nou areduji pugeje. Akore: – Ameartorure i dukodire akinorudodure aro pegareu jamedu boe piji dukodire awarigudumodukare toro bope doge eda kejewu joru pegareuto. Akirimi aibagi awai ka. Amororamagadukaba. Boe pegareu puredumodukare ai. ");
INSERT INTO bor_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesus uture ture jorduwadowu imebo boe eda jamedu boe ka tuwo boe ewie tuwadaru pemegareuji, tumagowo Pao Kurireu rore jiboeji boe ewiagai. Makore boei Pao Kurireu umoduie boe eimijerado pudumi kuri je. Nou Jesus ure jorduwadowuge enodo padure doze. ");
INSERT INTO bor_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Ia areme ekodure Jesus apo jamedu. Iarodo iere Maria Madalena. Metago iere Joana. Nou iarodo iere Susana. Marigudu bope doge emedure nou Maria Madalena tada. Nou bope doge enodo padure sete. Mare Jesus ure nou bope doge etawuje nou Maria Madalena piji dukodire nou Maria Madalena kodure apo. Nou Joana oredu iere Cuza. Nou Cuza maragodure boe eimijera Herodes ai. Ia areme ekodure Jesus apo jamedu. Jesus ure bope doge etawuje iage epiji. Ure iage epemegago tugogodae piji. Dukodire nou areme ere tugera maku etai nou toe makudu tabo Jesus ai, nou utugarege etai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Boe emagare taregodu tabo Jesus ae. Etaregodure tieda jamedu boe piji tuwo bato pui Jesus ae tumearduwo Jesus makore jiboeji. Dukeje Jesus readodure ewiagai ia bakaruji tuwo jebato toro nouia Pao Kurireu meardae ka. ");
INSERT INTO bor_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Akore: – Ia imedu ure tudawuje tuwo boe a roto ja ja moto joki to boepa tada. Ia a buture awara okwaji. Boe ewure jore nou buture awara okwa jiwu a keje, kiebarege ere nou boe a rugadu kowuje. ");
INSERT INTO bor_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ia a buture toriguru tada. Boture mare kidure, tori uru koia, moto pegare ji kodi. ");
INSERT INTO bor_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ia a buture botoguru tada. Botoguru boture tabo jamedu mare botoguru ure bito. ");
INSERT INTO bor_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mare ia a buture moto pemegareu keje. Ere tuguwu sacu ure mitotu je. Botu pemegare, ričodu pemegare, enari kurire rugadu. Kidure dukeje ere rawuje čiwu piji. Ere a rawuje tuwo tugu sacuto. Nou sacu oto padure kejeboere cem nou boe a tabo. Nono Jesus okituware nou boei. Akore: – Tawiapaga pemegado awu iwadaruji tarduwawo kaba jiba inagoino tai. ");
INSERT INTO bor_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nou Jesus ure jorduwadowuge enarare ji: – Kaba awadaru jiba akaidure čerduwawo akagoino čei duji? ");
INSERT INTO bor_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus akore: – Ire boe erduwado toro nouia Pao Kurireu meardaeji rugadu nou bakaru tabo. Mare paga karega. Ireadodure aino Pao Kurireu uwo tarduwado meture pudabowu tumeardae boeji, boe ewo tugimijerado tu ema, tarduwawo nuba Pao Kurireu romode tudugaregei. Mare ireadodure bakaruji kodire ia boe erduwamode awu bakaruji mare emodukare boe pa nou bakaruji. Ewiapagamode ji mare erduwamodukare nou Pao Kurireu meardaeji. ");
INSERT INTO bor_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","– Ainore awu bakaru ure. Boe eire inagoino. Pao Kurireu bataru ure nono nou boe a mogadure. Mare boe a ji karega inagoino. Pao Kurireu bataru aregodumode boe etae. Nono boe emeardumode Pao Kurireu bataruji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Boe emeardumode Pao Kurireu bataruji dukeje bope doge eimijera umode nou Pao Kurireu bataru tawuje nou boe epiji nono nou kiebarege ere nou boe a tawuje moto piji dumogadure. Mare kiebarege ei karega inagoino. Bope doge eimijera jire inagoino. Umode boe ewiago Pao Kurireu bataru piji. Dujire inagoino. Dukodire nou boe emeartorumodukare Pao Kurireu bataruji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ia boe emeardumode Pao Kurireu bataruji pugeje. Nono nou boe emode nono nou boture toriguru tadawu boe a mogadure. Nou boture toriguru tadawu boe a rakamodukare. Mare boe a ji karega inagoino. Boe eire inagoino. Nou boe eragamodukare tumeartoru raiwo Pao Kurireuji. Dujire inagoino. Emode tugeragu Pao Kurireu bataruji tiagare tabo mare emeartoru raimodukare ji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ia boe emeardumode Pao Kurireu bataruji pugeje. Awu boe emode nono nou boture botoguru tadawu boe a mogadure. Botoguru umode boe pegado ji. Mare boture botoguru tadawu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji mare emororamagadumode tu nou tumeardae pegareu boeji. Dujire inagoino. Emeardaere tu pudui tuwo to diero kurido. Emeardaere tu nou taidure jiboeji. Dukodire toro ia meri keje nou boe emode tugera ra Pao Kurireu bataru piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mare ia boe emeardumode Pao Kurireu bataruji dukeje emeartorumode ji rugadu. Dukodire epemegamode rugadu nono nou boture moto pemegareu boe a mogadure. Mare boture moto pemegareu kejewu boe a ji karega inagoino. Boe eire inagoino. Nou boe emeardumode Pao Kurireu bataruji nono emeartorumode ji rugadu. Dujire inagoino. Emodukare tugera ra tumeartorure jitu piji rugadu jii toro rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesus makore kimo. Akore: – Boe emode pori bu jorugu aogeje dukeje urugumodukare. Boe emode jorugu mugudo tuba kuda dukeje urugumodukare jamedu. Mare boe emode jorugu bararedo, uruguwo pudui. ");
INSERT INTO bor_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","18","Mare paga karega iwadaru ure nono nou lamparina urugu mogadure. Mare lamparina urugu ji karega inagoino. Marigudu boe erduwakare ia Pao Kurireu meardaeji. Marigudu boe erduwakare ia boe ero pegare jiboeji. Mare boe emeardumode iwadaruji dukeje boe erduwamode Pao Kurireu meardae pemegareu jamedu boeji. Boe emeardumode iwadaruji dukeje erduwamode boe ero pegare jiboeji. Dujire inagoino. Erduwakare ia boe ero pegare jiboeji mare erduwamode ji. Dujire inagoino. Erduwakare ia Pao Kurireu meardae pemegareuji mare erduwamode ji. Dujire inagoino. Dukodire tameardae pemegado tawiapagare jiwu iwadaruji tawo taragado tai tameartoruwo ji rugadu. Mare paga karega. Boe etaidumode tumeartoruwo tuiorduware jiwu Pao Kurireu bataruji dukeje Pao Kurireu umode erduwa kurido pudui emeartoruwo pudui rugadu. Mare ia boe etaidumodukare tumeartoruwo tuiorduware jiwu Pao Kurireu bataruji dukeje Pao Kurireu umode erduwa bokwado tuwadaruji. Emeardaere tuiorduwaie rugadu mare pagatu je. ");
INSERT INTO bor_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus uče uwiemage etaregodure tuiorduwo Jesusji tumagowo ji. Mare eroiwakare tubureduwo ji boe emagare nono apo kodi. ");
INSERT INTO bor_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ia imedu ure Jesus bie. Akore: – Ikimijera. Ače, awiemage etaregodure awagai. Etaidure tumagowo ai. ");
INSERT INTO bor_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mare Jesus makore: – Biapagare Pao Kurireu bataru jiwuge emeartorure jiwuge ere nono iwobe emogadure. Ere nono iwie mage emogadure. Ere nono muga mage emogadure. ");
INSERT INTO bor_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ia meri keje Jesus ure turemo ture jorduwadowugebo ia ika kurireuto. Makore ei: – Pagurugoduwo awu pobo maereu okwa abowu ka. ");
INSERT INTO bor_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nono eture. Ekurugodure dutabo Jesus unudure. Mačare ia bakuru pegareu aregodure etae tači je. Nou bakuru ure nou pobo maereu rutudo. Kodire pobo jeture nou ika kurireuji. Dukejere nou pobore turemo nou ika kurireuto rugadu. Boe pegare nou ika kurireu tadawu boe dogei rugadu. ");
INSERT INTO bor_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesus ure jorduwadowuge epagudugodure rugadu dukodire ere Jesus jetadudo. Egore: – Čegimijera! Pawimode poboto! Nono Jesus ure turagojedo. Nono makore nou bakuruji nou poboji dukodire nou bakuru akedure, nou pobo butugugodure jamedu. ");
INSERT INTO bor_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nono Jesus makore nou ture jorduwadowugei. Akore: – Tameartorukare i na? Mare epagudure. Ebogodure. Egore pui: – Duboba nure awu imeduče? Kočare bakuru, pobo emeartorure awu imedu bataruji rugadu! ");
INSERT INTO bor_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ekurugodure Galiléia pobo maereu okwa abowu ka. Nou etaregodure kawu moto iere Gerasa. ");
INSERT INTO bor_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Nono Jesus ure tudawuje ika piji dukeje bope doge emedu tadawu imedu uture Jesus togi. Marigudu nou bope doge emedure nou imedu tada dukodire boe ere kogudo ia meriri iku tabo boe etuwo ji rekodukawo. Mare nou bope doge ere nou imedu rakado rugadu dukodire nou imedu ure nou meriri iku kado tu tu je. Nono nou bope doge ere nou imedu utudo boe epiji. Dukodire merure tuwiri kedo tabo, rekodure tuwai piji jamedu. Mugure boe ere bireuge etugu tadawu tori poro ja tada boe maereu keje. Nono Jesus makore nou meture nou imedu tadawu bope dogei. Akore: – Tadawuje nou imedu piji! Nou imedu kudugodu rakare dukeje ure tuwududo Jesus jokorai. Ure tumago rakado. Akore: – Jesus! Boe eimijera Pao Kurireu onaregedu nure aki! Nuba aromode čei? Inogwamagudumode ai. Akaba čedudo boe pegareuto. ");
INSERT INTO bor_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","31","Jesus unarare ji: – Nuba akiere? Nou meture nou imedu tadawu mareboe doge emagare dukodire egore: – Čegiere bope doge makareuge. Nono nou meture nou imedu tadawu bope doge enogwamagudu raire Jesusji ro pegakawo pudui ukawo tuwarigu boe eiawu moto koreuto. ");
INSERT INTO bor_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jugureuge edu puredure nono togwage tabo. Nono nou mareboe doge enogwamagudure Jesusji uwo tudo turemo nou jugureugeto. Jesus makore ei uie turugadu. ");
INSERT INTO bor_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nono ere tudawuje nou imedu piji dukejere ere turemo nou jugureugeto. Dukodire nou jugureuge eregodure kuri ia moto ri ao piji poboto. Dukodi eiamedu boe ewire poboto. ");
INSERT INTO bor_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dukodire nou jeture jugureuge eiwuge ime eregodure toro nou tuwai mugure tadawu ba kurireu ka tureadoduwo boe ewiagai nono. Ereadodure nou Jesus rore jiboeji boe eiamedu boe ewiagai nou moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","39","Nou ba kurireu kejewuge eture toro Jesus ae dukeje erdure nou bope doge emedu tadawu imeduji pemegagodure duji. Butugugodure. Ukudau areia meture jituji. Erduware Jesus ure bope doge etawuje nou imedu piji dukejere epagudugodure. Eiamedu boe emagore Jesusji utuwo nou to moto piji. Dukodire Jesus ure tuduiago dukeje nou bope doge ere tudawuje pijiwu imedu makore Jesusji. Akore: – Itaidure ikoduwo akabo. Mare Jesus akore: – Atudo aibagi awai ka. Areadoduwo boe ewiagai nuba Pao Kurireu ro pemegare ai duji. Dukodire nou imedu uture tuibagi tuwai ka. Readodure nou ba kurireu kejewuge boe eiamedu boe ewiagai nuba Jesus ro pemegare pudui duji. ");
INSERT INTO bor_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus kurugodure tuibagi ika kurireu tabo pobo maereu okwa abowu ka pugeje ture jorduwadowugebo. Etaregodure dukeje boe ekimadure Jesus apo. Epagare bagai marigudu tuwiapagawo Jesus bataruji. ");
INSERT INTO bor_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ča ia bai kejewu boe eimijera iere Jairo. Judeu doge ere bato puiwu bai kejewu boe eimijera nure ema. Nou imedu Jairo aregodure Jesus ae, tragudu tabo. Okwamagudure Jesusji koduiago pudabo toro tuwai ka. Tonaregedu nogwaredu rogu ure mitotu jedu bigoduiure. Dukodire Jesus uture apo uwai ka. Mare nono nou boe emagare rugadu dukodire ere taiado pači Jesus apo. ");
INSERT INTO bor_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ia aredu kodure ebo Jesus rekodaji. Marigudu nou aredu kogodaere tu tu je. Nou aredu ku rere piji nono areme etorewudae mogadure. Mare nou aredu ku akedukare piji. Re kimore piji meri jamedu boeji. Joru oto padure doze nou aredu ku rere piji dukeje. Kodire uture jorubo epage etae. Mare ekare nou aredu pemegago nou tugogodae piji. Pega kimore rugadu. ");
INSERT INTO bor_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aino čare nou aredu ure tugera raido. Nono iera otorogu jeture Jesus ukudau areiaji. Dukeje nou aredu pemegagodure tači je. Nou aredu ku rekare piji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ča Jesus ure tuwuredo tu je. Akore: – Ioguduba ure tugera raido ikudau areia ka? Boe emagokare boeji. Dukejere Pedro akore: – Kodiba akagore aino? Boe emagare woe pagabo. Boe eiamedu boe ekera jeture akudau areiaji. ");
INSERT INTO bor_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mare Jesus akore: – Iorduware ipijire ia iraga rakareu ure tudawuje dukejere iogore ia boei. Dukodire iorduware ia boe ekera jeture ikudau areia jituji. ");
INSERT INTO bor_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nou aredu jorduwagodure Jesus jorduware pudumie tuie tugera raido pudae duji. Dukodire ure tuburedo Jesusji. Mare pagudure dukodire mororamagadure. Ure tubu jodo moto keje Jesus jokorai dukejere readodure turore jiboeji Jesus biagai. ");
INSERT INTO bor_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus makore ji. Akore: – Are. Ameartorure tu i dukodire apemegagodure. Mare amororamagadukaba. Ire akogodae akedudo apiji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus mako kimore nou areduji dukeje ia imedu aregodure etae Jairo uwai piji. Makore Jairoji. Akore: – Akanaregedu rogu bokware. Amagokaba nou pagimijeraji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mare Jesus meardure emagore pui duji. Nono makore Jairoji. Akore: – Amororamagadukaba. Ameartorudo i rugadu. Akanaregedu pemegagodumode. ");
INSERT INTO bor_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Makore aino dukeje Jesus uture ture jorduwadowugebo Jairo apo uwai ka. Etaregodure uwai ka dukeje boe emagare nono tragudu tabo nou Jairo onaregedu rekodaji bire kodi. Jesus akore: – Tagragudukaba pugeje. Bikare. Unudunure. Unure tamudo tu je. Mare nou nogwaredu bire rugadu. Mare Jesus jorduware turomode jiboeji dukodire akoino ei. Mare nou boe erduware nou nogwaredu bire rugadu duji. Dukodire enogwarigodure ji emeartorukare ji kodi. Nono Jesus makore Pedroji, Joãoji, Tiagoji jamedu, ewo turemo pudabo, Jairo apo, Jairo oreduje apo jamedu. Makore nou iagei epagawo toro bawadu keje. ");
INSERT INTO bor_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ere turemo dukeje Jesus ure tugeragu nou nogwaredu ieraji. Makore ji. Akore: – Are. Aragojedo. ");
INSERT INTO bor_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Ča. Nou nogwaredu jewodure tači je. Nono ure turagojedo. Uče, uo erore ta je Jesus rore aino duji. Mare Jesus makore ei. Akore: – Awu tagonaregedu okwagedo. Imode tawie. Tareadodukaba boe ewiagai irore aino woe tawai keje duji. ");
INSERT INTO bor_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nono Jesus makore ture jorduwadowuge ewagai. Enodo padure doze. Ure turaga maku etai ewo boe epemegago ewo bope doge etawuje boe epiji jamedu. Ure eragado turaga tabo ewo boe epemegago ekogodae boe piji. ");
INSERT INTO bor_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","5","Jesus makore nou ture jorduwadowugei. Akore: – Tadukaba nou tagedure jiwu tagaibo tabo. Tadukaba marenaru ukudau areia meture tadawu kadarabo tabo. Tadukaba tage tabo. Tadukaba diero tabo. Tadudo tu meture taiwu tagudau areia tabo. Tadukaba ia tagudau areia metia tabo pugeje. Tagaregodumode ia boe eda ka dukeje tardumode boei. Etaidumode tai dukeje tamugudo ebo jii nou tadumode kejewu meri ka. Mare tagaregodumode ia boe eda ka pugeje mare nou boe etaidumodukare tai. Ekimadumodukare tagabo dukeje tadudo epiji. Tadumode epiji dukeje tawure okeakejewu to pui egai tawo moto urugudu tawuje nou tawure okeakejewu piji nou boe erduwo Pao Kurireu aidukare nou erore jiboeji kodire umode tugera ra epiji. Jesus makore nou ture jorduwadowugei dukeje ure etudo ewo boe ewie Pao Kurireu bataru pemegareuji boe ewo tugimijerado tu Pao Kurireuče. Ure etudo ewo kogodureuge boe epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dukodire nou Jesus ure jorduwadowuge eture. Eture boe eda jamedu boe ka. Ere boe eiamedu boe ewie nou Jesus bataru pemegareu jamedu boeji. Ere kogodureuge epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galiléia moto kejewu boe eimijera iere Herodes. Meardure nou Jesus rore jiboeji makore jiboeji. Mare jorduwa bokware ioguduba nuie ema duji. Ia boe egore João Batista jewoduie pugeje kodie João Batista nure ema. ");
INSERT INTO bor_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ia boe egore Elias uie tugirimi baru piji. Iage egore ia mariguduwu makore Pao Kurireu bataru jiwu jewoduie pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes akore: – Boe egore ia imedu ro rakaie rugadu. Dukodire imire imagore itugaregei ewo João Batista itoru kado. Dukodire ere bito rugadu. Ema karega rore aino. Ča kakojiwu imedu ba ro rakare aino pugeje? Dukodire Herodes jemarure Jesus bagai tunarawo ji ioguduba nuie ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","11","Nou uture Jesus bataru tabowuge ere tugirimi tuibagi Jesus ae. Ereadodure turore jiboeji Jesus biagai. Dukejere Jesus uture ebo pugeje boe epiji. Etuiago toro Betsaida ba kurireu ka. Mare boe erduware Jesus kodure toro duji dukeje eture rekodaji. Emagare. Dukodire Jesus ure tuwuredo nono boe maereu keje tumagowo nou boei. Ure erduwado Pao Kurireu bataru pemegareuji boe ewo tugimijerado Pao Kurireuče. Nono nou tumugureu keje ure boe kogodureuge epemegago jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nono merirekodutabo nou Jesus ure jorduwadowuge emagore Jesusji. Egore: – Boe doge etudo awu boe maereu piji. Edo taodo ia tieda puredureu bagai emuguwo keje etaiwowo ia tuge rogu bagai. Boe bokware woe du kodire. ");
INSERT INTO bor_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Jesus akore: – Boro. Taigoiare tamode enogwagedo. Egore: – Awu boe emagare rugadu. Ime enodo padure cinco mil. Mare page amireu rogure ikera aboudure tu je. Page karo rogure pobetu je. Tu rugadu. Akaidukana čeduwo toro ba kurireuto čewo čegeragu awu boe eiamedu boe ekeji kana? Mare Jesus akore: – Tamagodo awu boei ewo tudo pui enodo paduwo cinquenta tu tu tumuga boe keje. ");
INSERT INTO bor_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nono nou Jesus ure jorduwadowuge erore aino. Ere nou boe eiamedu boe edo tudo pui tumuga jamedu boe keje. Eiamedu boe ere tudo pui rugadu. Dukodire ere tumugudo tu tu tumuga boe keje. ");
INSERT INTO bor_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nono Jesus ure tugeragu nou boe eke roguji tumagowo Tuwo Kurireu bagai baruto nou boe eke rogu paru tabo. Imadure Tuwo Kurireu apo nou boe eke rogu paru tabo dukeje Jesus ure nou boe eke kado puiato ture jorduwadowuge ewo maku boe etai. Nou boe erore puku je nou boe eke itodure aino duji. Dukodire nou boe eke ure turugadu boe eiamedu boei. ");
INSERT INTO bor_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Boe eiamedu boe enogwagere. Nono ča ekuredure egarere pudui rugadu. Ča nou Jesus ure jorduwadowuge ere nou kadarabo doge ekorau nou boe eke kobo tabo. Nou kadarabo doge enodo padure doze nou boe eke kobo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ia meri keje Jesus makore baruto Tuo Kurireu bagai. Rakojere tuginaigodu. Tu nou Jesus ure jorduwadowuge edure tu nono Jesus apo. Jesus ure tuwadaru akedudo dukeje unarare nou ture jorduwadowugei: – Nuba boe emeardaere i? ");
INSERT INTO bor_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Egore: – Boe egore João Batista nuie aki. Nou iage egore Elias nuie aki. Nou iage egore ia mariguduwu makore Pao Kurireu bataru jiwu imedu jewodureu nuie aki. ");
INSERT INTO bor_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus akore: – Mare tagi. Nuba tameardaere i? Pedro akore: – Pao Kurireu ure maku boe etaiwu nure aki. Umode boe ekinorudowu nure aki. ");
INSERT INTO bor_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Jesus akore: – Tareadodukaba nou inoduji boe ewiagai. Mare du inodu tabo boe erorerumode i. Boe etaidumodukare i. Judeu doge eimijerage erdu pegamode i rugadu. Jorduware Judeu doge eno bakaru jiwuge erdu pegamode i rugadu. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage erdu pegamode i rugadu. Boe emode iwido rugadu. Mare merimode pobe metia bokware dukeje iewodumode tači je pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nono Jesus makore nouia boei pugeje. Akore: – Ia tagi tagaidure tagoduwo itabo kana? Ča iwo tawie. Tagaidumode dukeje tameartorudo tu i dukeje tagera ra taro pegareu piji, tawia ra tameardae pegareu piji, tagaidure jiboe piji jamedu. Tado tarugadu meri jameduji boe pegamode tai nono boe pegamode i dumogadure. Iwimode ipo padure pugajejewu keje. Dukodire inagoino tai tado tarugadu tagoduwo itabo. ");
INSERT INTO bor_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mare ia boe ewiapagamode tuwo boe pemegado tu pudui turaga tabo dukeje nou boe eraga akedumode epiji rugadu. Egare remawu modukare. Emodukare činorudo bope doge eda kejewu joru pegareu piji rugadu. Mare ia boe ewiapagamodukare tumeardaeji pugeje tuwo tugera ra nou turo pegareu piji tumeardae pegareu piji taidure jiboe piji dukeje Pao Kurireu umode boe pemegado ei, umode egare remawudo rugadu. Nono ewarigudumodukare bope doge eda kejewu joru pegareuto jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pagatu jere boe emode turagado pudui toe kuriwo awu moto keje. Ča nou enoe umodukare erududo baruto. Ewiagorokare tuwo tumeartorudo tu Pao Kurireuji kodi. Ewiagorore tu tuwo toe kurido mare pagatu je. ");
INSERT INTO bor_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ia boe epogurumode tumagowo iwadaruji tumedage ewiagai dukeje imi imodukare ikeragu ei itae. Itaregodumode Pao Kurireu o jorugu kurireu tabo Pao Kurireu utugarege baru tadawugebo dukeje imodukare ikeragu ei. Nou Pao Kurireu o jorugu kurireu urugure Pao Kurireu kujegajeje. Imode ikirimi mato dukeje urugumode ikujegajeje jamedu. Urugumode nou aregodumode itabowu Pao Kurireu utugarege baru tadawuge ekujegajeje jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iwo tawie boe remawuji. Pao Kurireu umode boe eimijera kurireudo pudumi dukeje ia tagi tardumode awu Pao Kurireu roino duji. Tawimodukare jii toro tardumode roino jitu ka. ");
INSERT INTO bor_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nou akoinodu bataru rekodaji semanare mito. Dukeje Jesus uture Pedro apo, Tiago apo, João apo jamedu toro ia tori ričoreu ao ka. Toro nou tori ričoreu ao kejere Jesus makore Pao Kurireu bagai baruto. ");
INSERT INTO bor_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesus makore baruto dukeje je ure tudo tuginai. Ukudau areia kigadu maere ji. Gurugure nono boeiaragudu urugu mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nono ia ime doge epadure tači toro ae. Ere pobe. Ia iere Moisés. Metia iere Elias. Nou Pao Kurireu jorugu pemegareu urugure ekujegajeje. Emagore Jesusji. Jesus makore ei jamedu. Ere pu bie Pao Kurireu meardaeji. Nou Pao Kurireu meardae koiare boe pegamoduie Jesusji nono Jerusalém ba kurireu keje dukodire Jesus bimoduie Jerusalém ba kurireu keje rugadu. Mare jewodumoduie pugeje turuduwo baruto rugadu. ");
INSERT INTO bor_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mare Pedro unudure tumedagebo. Čare edadure dukeje erdure nou urugure Jesus kujegajejewu Pao Kurireu jorugu pemegareuji. Erdure nou ime pobedu dogei jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ča nou ime pobedu doge ere tuduiago tuibagi baruto dukeje Pedro makore Jesusji. Akore: – Ikimijera. Ure turugadu paeduwo woe. Čemode ia mačebradudo pobe metia bokware. Iamode akai. Iamode Moisés ai. Iamode Elias ai jamedu. Mare Pedro jorduwakare tuiordure jiboeji dukodire mako pagare. ");
INSERT INTO bor_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro mako kimore dukeje ia boe tugu ure turawuje etae. Nou boe tugu ure turorido eiogi. Dukodire nou Pedro, nou rakojere apowuge metage epagudugodure. ");
INSERT INTO bor_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nono emeardure ia boe emagoji nou boe tugu piji. Akore: – Imeardu kurire jiwu itonaregedu reo. Ire ikeragu ji iwo udo boe ekinorudo. Tawiapaga pemegado makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Akore aino dukeje nou boe tugu akedure. Ča Jesus rakojere nono. Nou ime pobedu doge eragojekare nono pugeje. Mare Pedro, Tiago, João nou meriji ereadodukare tumedage ewiagai tuiordure tumeardure jiboeji jii toro, ia boe ewiagai jii toro jamedu. ");
INSERT INTO bor_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nou barogwato ere turawuje nou tori ao piji dukejere boe emagare taregodu tabo Jesus togi. ");
INSERT INTO bor_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","40","Ia imedu akore: – Ikimijera! Ikimijera! Inogwamaguduwo ai itonaregedu rogu paru tabo bope uwari pegareu meture tada kodi. Nou bope uwari ro pegare ji kodire ure magadudo, ure kudugo. Jataro aregodure jabiji, rakakare tuwo turagojedo pugeje. Kodire ure tiamedu boe korido. Ukare tudawuje itonaregedu piji rugadu. Dukodire inogwamagudunure ai akaiwowo ji awo pemegago. Rogure mitotu inai. Imagore awu ia are jorduwadowugei ewo nou bope uwari pegareu barigu piji. Mare ero rakakare ji. ");
INSERT INTO bor_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus akore nou boei: – Tare ikiarigo. Tameartorukare rugadu. Tarduwakare tawo tameardae pemegado. Iragoje raimodukare tagabo. Nuba tagaidure irowo tameartoruwo i? Nono Jesus makore nou imeduji. Akore: – Mato akanaregedu apo. ");
INSERT INTO bor_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nono boe ere nou iparedu reko Jesus ae dukeje nou bope uwari pegareu ure nou iparedu butudo moto keje pugeje. Magadugodure nono nou moto keje. Mare Jesus mako rakare nou bope uwariji uwo tudawuje nou iparedu piji. Ainore čare ure nou bope tawuje nou iparedu piji rugadu. Dukodire ure pemegago. Nono ure nou iparedu maku tuo ai pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Boe eiamedu boe ebogodure Pao Kurireu ro rakare aino duji. Nou boe ebogodu kimore Jesus rore jiboeji. Dukeje Jesus makore ture jorduwadowugei pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Akore: – Imedu Onaregedu nure imi. Imagudumode ro pegareuge etai ero pegawo i. Tawiagodukaba awu imagore tai dupiji. ");
INSERT INTO bor_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mare nou Jesus ure jorduwadowuge erduwakare kaba jiba Jesus akoino pudui duji. Nou Jesus makore jiboe ukare turemo etaorato. Dukodire ure tuwiado epiji. Mare epagudure jamedu tunarawo Jesusji kaba jiba Jesus akoino pudui. ");
INSERT INTO bor_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nou Jesus ure jorduwadowuge ere bato pui tunarawo kakojiwu pudumiba boe kurireu mode ema. Eiamedu boe egore boe eimijera kurireu moduie pudumi nou tumedage epiji. ");
INSERT INTO bor_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mare Jesus jorduware emeardae jamedu boeji. Nono Jesus ure tugeragu ia boe etonaregedu roguji. Makore ji rakojewo nono pudabo tugana pemegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nono Jesus makore ture jorduwadowugei. Akore: – Meartorure iwu umode tugera podo boe etonaregedu apo dukeje unure tugera podo itabo jamedu. Meartorure iwu umode tugera podo itabo dukeje unure tugera podo nou ure itarego matowu apo jamedu. Tagaidumodukare tawo tagurido tamedage ekori pugeje, mare tamode tado itugaregedo tagi dukeje Pao Kurireu aidu kurimode tai boe eimijerage kurireuge ekori. ");
INSERT INTO bor_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","João makore Jesusji. Akore: – Čerdure ia imeduji. Ure bope doge etawuje boe epiji akie tabo. Pamedia karegure ema. Dukodire čemagore ji uwo tugera ra nou turo piji makokawo akie tabo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mare Jesus makore ei. Akore: – Piji. Ro pegakare paiwuge emeardu kurinure pai. ");
INSERT INTO bor_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus jorduware meri puredugodure pudui turuduwo baruto. Dukodire ure tumeardae udo turugadu tuduwo Jerusalém ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ure tugeragu nouia ture jorduwadowuge pobedu dogei tuwo etudo tododai tuwadaru tabo toro Samaria moto kejewu ia boe eda ka ewo boe udo turugadu Jesus togi aregodumode toro kodi. ");
INSERT INTO bor_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dukodire nou pobedu doge eture nou Samaria moto kejewu boe eda ka rugadu. Mare nou boe erduware Jesus utumoduie Jerusalém ba kurireu ka dukodire etaidukare Jesus aregoduwo pudae. ");
INSERT INTO bor_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mare nou pobedu doge erduware nou boe emeardaeji dukodire ere tugirimi Jesus ae tuwo Jesus bie nou boe egore Jesus jituji. Ere Jesus bie dukeje nou Tiago, nou João emeardure egoino duji jamedu. Dukodire emagore Jesusji. Egore: – Čegimijera. Akaidukana čemagowo baruto joru butuwo nou boe ewugeje, uwo nou boe etagedudo? ");
INSERT INTO bor_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mare Jesus akore: – Boro. Tameardae pegakaba ei. ");
INSERT INTO bor_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dukejere Jesus uture ture jorduwadowugebo toro ia boe eda ka pugeje. ");
INSERT INTO bor_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesus kodure awaraji dukeje ia imedu aregodure ae. Makore ji. Akore: – Itaidure ikoduwo akabo rugadu atumode kaboe ka. ");
INSERT INTO bor_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus makore ji. Akore: – Okwa doge emode tamudo tiari poro ja tada. Kiebarege emode tamudo tuwaradu ja tada jamedu. Imedu Onaregedu nure imi. Mare iwai bokware dukodire imode itamudo tadaboe bokware. ");
INSERT INTO bor_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dukeje Jesus makore ia imeduji. Akore: – Ako itabo. Mare nou imedu akore: – Ikodumode akabo rugadu mare kajao. Aino kuri aino itumode iogwa uwai ka. Iogwa bire dukodire iwo iogwa tugu mototo jao. Dukejere ikodumode akabo akodure jiboe ka. ");
INSERT INTO bor_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus akore: – Bireuge etugudumode mototo bireugebo mare awiapagakaba ei. Atudo epiji ia boe eda ka awo nou boe ewie boe eimijera kurireu moduie Pao Kurireuče rugadu duji. ");
INSERT INTO bor_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ia boe makore Jesusji pugeje. Akore: – Ikodumode akabo rugadu. Mare kajao. Iwo ikirimi iwai ka jao ikimaduwo iwobebo. ");
INSERT INTO bor_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mare Jesus makore ji. Akore: – Ia boe aidumode tumaragoduwo motoji tuwo nou merirido moto kado kuwaru apo dukeje umodukare tuie mekido tododaiwu moto piji tuwo nou ture kadowu moto jetorodo. Aiwomodukare tuibagi. Tarodo nono nou umode moto kadowu ro mogadure. Mare umode moto kadowu ro ji karega inagoino. Tamaragoduwo Pao Kurireu ai tawo boe ewie boe eimijera kurireu mode Pao Kurireuče. Dujire inagoino. Boe etaidumode tumaragoduwo Pao Kurireu ai dukeje ekawo tugera ra Pao Kurireu piji tuwo tugirimi turo pegareu ka pugeje. Dujire inagoino. Emode tugera ra Pao Kurireu piji dukeje Pao Kurireu umodukare tudugaregedo emage. ");
INSERT INTO bor_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jesus ure tugeragu imei pugeje tuwo etudo tuwadaru tabo boe etae. Enodo padure kejewugere setenta e dois. Ure edo pobe čai čai je puapo tudumodewu ka. ");
INSERT INTO bor_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Makore ei. Akore: – Boepa kurire rugadu. Nou boepa tadaboe ure turugadu boe ewo kado. Mare nou umode boepa tadaboe kadowuge emagakare. Dukodire tamagodo baruto Pao Kurireu bagai. Boepa jiwu boe eimijera kurireu nure ema. Tamagodo ji uwo nou maragodure boepa jiwuge emagado etuwo boepato ewo boepa tadaboe kado rugadu. Mare boepa remawu ji karega Jesus akoino. Meartorumode Pao Kurireu jiwugeire akoino. Boe emode boe erduwado Pao Kurireu bataruji dukeje emeartorumode ji, Pao Kurireu umode ekinorudo rugadu. Dujire akoino. ");
INSERT INTO bor_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nono Jesus makore ei pugeje. Akore: – Nou imode tadudo etaewuge ere nono rie doge emogadure. Mare tagire tare nono ovelha doge emogadure. Mare barogo remawu ji karega inagoino. Tameardae pegareu bokware. Dujire inagoino. Mare nou tadumode etaewuge emeardae pegamode tai rugadu. Dujire inagoino. Ča tadudo toro boe ewagai. ");
INSERT INTO bor_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mare tadukaba ia diero tabo. Tadukaba marenaru ukudau areia meture tadawu kadarabo tabo. Mare tadudo tu nou meture tawuretadau tawure okeakejewu tabo. Tadukaba ia metia tabo pugeje. Tagaba tawuredo awara kajeje tagimaduwo ia boebo. ");
INSERT INTO bor_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tagaregodumode nou boe ewai ka dukeje tagimadudo nou boebo. Tamagodo aino ei: “Boe epemegawo awu bai tadawugei.” ");
INSERT INTO bor_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","– Tamagomode aino nou boei dukeje tarduwamode ei. Etaidure tuwo tubemegado boei dukeje tawadaru pemegareu maku etai Pao Kurireu uwo boe pemegado ei. Mare etaidumodukare tuwo tubemegado boei dukeje tagaba tawadaru pemegareu maku etai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","8","Nou boe etaidumode tai dukeje tabaduwo nou ewai keje. Tabadu paga paga kaba ia boe ewai keje. Nou aidure taiwuge ewai kejere tabaduwo. Tagwagedo nou emode maku tagaiwu tageji. Taeku irukaba nou emode maku tagai boeji. Tagududo nou emode maku tagaiwu boeče. Nou tagwagere jiboe, nou tagudure čewu makudure tagai tamaragodae moriče. ");
INSERT INTO bor_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tawo nou boe eda kejewu kogodureuge epemegago. Tamagodo nou boei Pao Kurireu umoduie boe eimijera kurireudo pudumi kuri aino. ");
INSERT INTO bor_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mare tagaregodumode ia boe eda metia ka dukeje etaidumodukare tugimaduwo tagabo dukeje tagaba taremo ewaito nou boe eda keje. Dukeje toro bawadu keje tagagomode aino ia boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Tamagodo aino ei: “Čedaregodure čewo boe ewie Pao Kurireu umoduie boe eimijera kurireudo pudumi kuri aino. Mare ia tagi tawiapagakare čewadaruji. Dukeje čemode čewure okeakejewu to pui taegai čewo nou moto urugudu tawuje čewure okeakejewu piji nou boe erduwo Pao Kurireu aidukare tarore aino čei duji.” Ainore tagagomode ei. ");
INSERT INTO bor_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mare imode tawie. Pao Kurireu okudugodumodukare nou aidukare taiwugei. Toro ia meri keje aiwomode boe eiamedu boe erore jiboeji tuwo nou erore jiboe morido etai. Marigudu nou Sodoma kejewuge ero pegare. Dukodire nou meri keje Pao Kurireu umode boe pegado nou Sodoma kejewugei ero pegareu moriče. Mare nou aidukare taiwuge boe eire Pao Kurireu ro pega kuričigomode nou Sodoma kejewuge ekori. Ainore Jesus akore nou setenta e dois boe doge ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nono Jesus makore nouia boei. Akore: – Iro rakare Corazim ba kurireu keje iwo nou boe erduwado i. Mare emeartorukare i. Dukodire boe pegamode ei rugadu. Iro rakare Betsaida ba kurireu keje iwo nou boe erduwado i. Mare emeartorukare i. Dukodire boe pegamode ei jamedu. Marigudu rugadu Tiro ba kurireu kejewuge emeartorukare Pao Kurireuji. Marigudu rugadu Sidom ba kurireu kejewuge emeartorukare Pao Kurireuji. Nou Tiro ba kurireu kejewuge, nou Sidom ba kurireu kejewuge erdumode nou Corazim ba kurireu kejewuge erdure jiwu iro rakareuji dukeje ekiarigodumode turo pegare jiboeji rugadu. Emode tugera ra turo pegareu piji. Emode jorugudu bu taora keje tuwo boe erduwado tugiarigodure turo pegareu boe jituji tuwo tugera ra turo pegareu piji. Mare erdukare i, erdukare iro rakareuji dukodire erduwakare i. Ekare tugera ra turo pegareu piji rugadu. Mare kočare Corazim ba kurireu kejewuge, Betsaida ba kurireu kejewuge, erdure iro rakareuji mare du inodu tabo ekiarigodukare turo pegareuji. Etaidukare tuwo tugera ra turo pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mare Pao Kurireu ure ia meri tawuje taiwowo boe eiamedu boe ero pegareu bagai nou meri keje. Mare nou Tiro ba kurireu kejewuge emeartorukare Pao Kurireuji dukodire Pao Kurireu umode boe pegado ei nou makore kejewu meri keje. Sidom ba kurireu kejewuge emeartorukare Pao Kurireuji dukodire Pao Kurireu umode boe pegado ei jamedu nou makore kejewu meri keje. Mare Corazim ba kurireu kejewuge, Betsaida ba kurireu kejewuge erdure iro rakareuji mare du inodu tabo emeartorukare i. Dukodire Corazim ba kurireu kejewuge eire, Betsaida ba kurireu kejewuge eire, Pao Kurireu ro pega kuričigomode nou Sidom kejewuge ekori, nou Tiro kejewuge ekori jamedu. Pao Kurireu romode aino ei toro ia meri keje. Nou makore kejewu meri keje umode boe pegado ei rugadu. ");
INSERT INTO bor_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Cafarnaum ba kurireu kejewuge emeartorure tu pudui turuduwo baruto. Mare pagatu je. Pao Kurireu umode ewarigu toro bope doge eda kejewu joruto nou taiwomode boe ero pegareu bagaiwu meri keje. ");
INSERT INTO bor_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nono Jesus makore ture jorduwadowugei. Akore: – Biapagare taiwuge ewiapagare i jamedu. Jordu pegare taiwuge erdu pegare i jamedu. Jordu pegare iwuge erdu pegare ure itarego matowuji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Uture Jesus bataru tabowuge ere tugirimi tuibagi Jesus ae. Enodo padure kejeboere setenta e dois. Egarere pudui taregodure dutabo rugadu. Egore: – Čegimijera. Čemagore bope dogei akie tabo ewo tudawuje boe epiji dukodire emeartorure čewadaruji rugadu! ");
INSERT INTO bor_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus akore ei: – Iordure bope doge eimijera pegareu Satanás buture baru piji duji. Buture nono boeiaragudu butu mogadure. ");
INSERT INTO bor_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tawiapaga pemegado awu iwadaruji. Ire tarduwado. Ire ia iraga maku tagai. Dukodire taragare jordu pegare paiwu Satanásji. Dukodire čare boe pegareu umodukare tagogorido. Awagu umodukare toedo tai. Betaga umodukare tudugo tugu tado. ");
INSERT INTO bor_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bope doge etuwaire emeartorure tai mare taegaregodukaba nou inoduji. Taiamedu boe taegaredo tai nou tagie padure bapera keje baru tada kodi. ");
INSERT INTO bor_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nou meriji Pao Kurireu Uwari ure Jesus jakaredo pudui rugadu. Dukodire Jesus makore Pao Kurireu bagai baruto. Akore: – Iogwa. Baru tadawuge, moto kejewuge eiamedu boe eimijera kurireu nure aki tu rugadu. Are nou mugukare bapera kejewuge erduwado. Nou are erduwado jiboe are biado jorduwareuge epiji marigudu. Are biado nou mugure bapera kejewuge epiji jamedu. Mare are mugukare bapera kejewuge erduwado. Dukodire ikimadure toro awagai. Are nou ameardae jetudo pudui rugadu akaidu tabo. ");
INSERT INTO bor_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesus ure nou tuwadaru iado tumagore tuo jitu keje makore nou boei. Akore: – Iogwa ure boe jamedu boe maku tu inai. Tu Pao Kurireu jorduware nou Tonaregeduji. Tu nou Onaregedu jorduware Tuoji. Dukodi nou Onaregedu umode nou taidure jiwuge erduwado Pao Kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nono Jesus ure tumegido nou ture jorduwadowuge etae. Dukeje makore ei. Akore: – Tardure irore jiboeji dukodire boe pemegare tai. ");
INSERT INTO bor_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jawu pawobe emagore Pao Kurireu bataru jiwuge etaidure tuiorduwo i nou itaregodumode kejewu meri keje tuiorduwo nou tardure jiwu irore jiboeji. Mare ewire marigudu dukodire erdukare i. Jawu pawobe eimijera kurireuge etaidure tuiorduwo i nou itaregodumode kejewu meri keje tuiorduwo nou tardure jiwu irore jiboeji. Mare ewire marigudu dukodire erdukare i. Etaidure tumearduwo tameardure jiwu imagore jiboeji. Mare emeardukare ji, ewire kodi. ");
INSERT INTO bor_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ia meri keje ia jorduware Pao Kurireu o bakaru jiwu unarare Jesusji: – Nuba iromode iewoduwo pugeje iragojewo Pao Kurireu apo baru tada jii toro rugadu? Mare pagatu jere ure tunarado Jesusji. Aidure tuwo Jesus barigu boeto Jesus makowo ia tuwadaru pegareuji nono tumago pegawo Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus akore: – Nuba Pao Kurireu bataru akore boe eroiago? Nuba ameardaere ji? ");
INSERT INTO bor_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nou imedu akore: – Pao Kurireu makore pai pameardu kuriwo Pao Kurireuji paraga tabo, pameardae pemegareu tabo, parore jiboe jamedu boe tabo. Makore pai pameardu kuriwo pamedagei nono pameardu kurimode pai dumogadure. ");
INSERT INTO bor_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus akore: – Boe jokodu jire akagoino. Aromode aino dukeje aragojemode Pao Kurireu apo du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mare nou imedu aidukare turo pemegawo tumeardae pemegawo tumedagei. Dukodire unarare Jesusji pugeje. Akore: – Kaibowugeba imedage mode emage rugadu? ");
INSERT INTO bor_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nono Jesus akore: – Ia imedu ure turawuje Jerusalém ba kurireu piji tuduwo toro Jericó ba kurireu ka. Nou awara keje iwogureuge eiwogure nou imeduji. Ere ukudau areia tawuje piji tugiwoguwo ji. Ere boeto ji. Ere kugudugodudo. Nono dukeje eture piji. Nou imedu bigodunure. Boe etaiwomodukare ji puredugodure tuwiwo kodi. ");
INSERT INTO bor_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ča ia ure Judeu doge enomea maku Pao Kurireu aiwu imedu kodure nou awaraji. Jordure nou ere boeto jiwu imeduji mare ure tumegido awara okwa abowu ka. Aidukare tuwo tugera maku ai. ");
INSERT INTO bor_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dukeje ia Levi uwobe imedu kodure nono pugeje. Aiwore ji mare ure tumegido awara okwa abowu ka jamedu. ");
INSERT INTO bor_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nono ia moto tuginaiwu kejewu imedu kodure nou awaraji. Samaria moto kejewu nure ema. Jordure nou imeduji dukeje okudugodure apo. Jorduwakare ji mare okudugodure apo, dukodire ure tugera maku ai. ");
INSERT INTO bor_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ure tuburedo ji. Iogore nou epae oiaji. Dukejere ure barigu tagu kuwaru ao ka. Nono ure reko toro boe enudumode boe enogwagemode kejewu bai ka. ");
INSERT INTO bor_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nou barogwato ure dierodo pobe uwaire bai čewu ai jetuwo nou imeduji. Akore: “Imode ikirimi dukeje imode aeture jidu morido akai pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nono Jesus unaragodure nou imeduji. Akore: – Kaibowu imedu ba ure timediado nou imedu koridodureuče? ");
INSERT INTO bor_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nou jorduware Judeu doge eno bakaru jiwu akore: – Nou Samaria moto kejewu imedure jeture nou imedu koridodureuji kodire ure timediado ema. Jesus akore: – Toro. Arodo nono nou Samaria moto kejewu imedu ro mogadure. ");
INSERT INTO bor_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus uture pugeje ture jorduwadowugebo. Etaregodure ia boe eda ka. Nou boe eda kejere ia aredu mugure. Iere Marta. Imadure ebo. Makore ei enogwagewo tuwai keje. ");
INSERT INTO bor_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nou aredu uwie iere Maria. Jesus ure turemo ewaito dukeje Maria ure tumugudo nono Jesus jokorai tuwiapagawo Jesus bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta maragodu kimore tumugure kejewu bai tada tuwo tuge udo turugadu, tuwo boe jamedu boe udo turugadu. Mare nou uwie ukare tugera maku ai dukodire korigodure tuwie areduji. Dukodire Marta mako pegare tuwieji Jesus biagai. Akore: – Ikimijera nure aki. Mare awu iwie ukare tugera maku inai. Imire ire boe jamedu boe towuje ikinaigodu. Kočare amagokare ji uwo tugera maku inai. Amagodo ji uwo tugera maku inai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mare Jesus makore Martaji. Akore: – Amororamagadu kurire amaragodae jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mare awie Maria meardae pemegare ameardae kori. Kodire ure tumugudo iogorai tuwiapagawo imagore jiboeji. Boe emodukare nou biapagare jiboe tawuje aora piji rugadu. Dukodire boe emeardaemode tuwiapagawo iwadaruji nono nou Maria meardae mogadure, dukeje nou emeardae koiare umode boe pemegado boei. ");
INSERT INTO bor_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ia meri keje Jesus makore baruto tuo bagai. Ure jorduwadowuge eragojere nono apo. Ia akore: – Čegimijera. Čerduwado čemagowo baruto nono João Batista ure jorduwadowuge emogadure. ");
INSERT INTO bor_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus akore: – Ainore tagagomode baruto. Iogwa Kurireu. Mugure baru tadawu nure aki. Boe emago pemegawo akieji tuwo boe emeartorudo tu ai rugadu. Boe emeartoruwo awadaru jamedu boeji tuwo tugimijera kurireudo aki rugadu. Akaregodu pemegado aro pemegareu tabo mato moto ka ameardae rugadu boe jetuwo pudui rugadu, nono aro mogadure toro baru tada dumogadure. ");
INSERT INTO bor_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Čege maku čenai meri jameduji. ");
INSERT INTO bor_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Awiagodudo čero pegareu piji nono čewiagodure ro pegare čeiwuge ero piji dumogadure. Iage etaidumode tuwo tumeardae pegareu maku čenai tuwo čero pegado. Čeginorudo epiji čewiapagakawo nou emeardae pegareuji. Čeginorudo boe pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Nono Jesus makore ture jorduwadowugei pugeje. Akore: – Ia boečo aregodure toia ka dukeje imedu utumode timedia uwai ka tumagowo timediaji ia uke amireu bagai. Akore: “Me. Imedia aregodu. Utu jaere tugiriadu tabo mato iwai ka. Mare ike bokware. Ia ake amireu udo pobe metia bokware inai jao. Barogwato imode ia maku akai tuibagi pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mare nou imedu umodukare tie bu. Rakojemode tu tuwai ja tada tumago tabo bataru jipagi. Akomode: “Boro. Akaradaino ipiji. Ire iwai baiporo mi marigudu. Itore enudunure. Ipadure ipa kamoreu keje marigudu iwo itamudo. Imodukare ie bu iwo iaboe maku akai rugadu. Atudo iwai piji.” ");
INSERT INTO bor_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mare nou imedu utumodukare nou timedia uwai piji rugadu. Pogurukare togwamagudu raiwo nou imeduji ia uke amireu bagai. Nono nou tumagore dutabo ure nou timediado tie bu pudae rugadu. Nono nou metia ure nou imedu makore bagaiwu amireu maku ai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Imedu rore aino. Pao Kurireu ro kodumode nou imedu ro kori. Dukodire imode tawie. Pao Kurireu aidure tuwo boe emagore bagaiboe maku boe etai rugadu. Dukodire tagogwamagudumode Pao Kurireuji iaboe bagai dukeje Pao Kurireu umode tamagore bagaiboe maku tagai rugadu. Pao Kurireu aidure tuwo boe erduwado pudui. Dukodire taemarumode Pao Kurireu bagai dukeje umode tarduwado pudui rugadu. Pao Kurireu aidure tuwo tuwai poro jado baru tada tuwo boe edo turemo baruto. Dukodire tamode tagera to Pao Kurireu uwai poroji dukeje umode tuwai poro jado tagai rugadu. Mare bai poro ji karega inagoino. Boe emeartoruwo Pao Kurireuji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","– Ro pegareuge erduware turo pemegawo torei. Dukodire tagore emagomode tai karo bagai tuge boei koia. Nono tamodukare awagu maku etai. Tawogumode karo bagai ekeče. ");
INSERT INTO bor_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tagore enogwamagudumode kagariga ba bagai tuge boei koia dukeje tamode maku etai. Tamodukare betaga maku etai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ro pegareuge nure tagi mare du inodu tabo tarduware taro pemegawo tagorei tawo eke pemegareu maku etai. Tarduware tawo boe pemegareu maku tagore etai. Mare Pao Kurireu pemegare rugadu. Dukodire umode boe pemegareu maku boe etai rugadu du kodumode nou tare maku tagore etaiboe kori. Umode Tuwari maku okwamagudure puduiwuge etai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ure bope uwari pegareu tawuje imedu piji. Nou bope uwari ure nou imedu mako bokwado. Mare Jesus ure nou bope uwari tawuje piji dukodire nou imedu makore pugeje. Boe erdure Jesus rore aino duji dukeje erore ta je. ");
INSERT INTO bor_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mare iage emeartorukare ji. Dukodire egore: – Bope doge eimijera pegareu Belzebu meture Jesus tada dukodire ure turaga maku Jesus ai Jesus uwo bope uwari pegareu tawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ia meartorukare Jesus jiwuge etaidure tunarawo Jesusji tuwo Jesus barigu boeto. Enogwamagudure Jesusji uwo ia turo rakareu to tiagai tuiorduwo nouia ro rakareu aregodure rugadu Pao Kurireu piji du bagai. ");
INSERT INTO bor_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mare Jesus jorduware emeardae pegareuji. Dukodire makore ei. Akore: – Boe epomodukare puapo dukeje emeardaere tu turugoduwo pui dukeje etagedumode. Boe erugodumode tuwobei dukeje emode tugera ra pubiji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ča meartorure Satanás jiwuge epomodukare puapo dukeje emeardaere tu turugoduwo pui dukodi etagedumode. Kočare tagagore nou Satanás raka taboie ire bope uwari pegareu tawuje boe epiji. ");
INSERT INTO bor_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mare nou tare jorduwadowuge nuba erore tuwo nou bope uwari tawuje boe epiji? Pao Kurireu raka tabore eroino kana? Tu Pao Kurireu rakare tuwo bope doge etawuje boe epiji rugadu. Dukodire nou tare jorduwadowuge egomode pagaie tagagoino, Belzebu raka tabo karega ire bope uwari pegareu tawuje boe epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pao Kurireu koiare ure turaga maku inai iwo bope doge etawuje boe epiji rugadu. Dukodire boe erdure Pao Kurireu ro rakareuji rugadu. Turore aino dutabo Pao Kurireu makonure boe ewagai ewo tugimijera kurireudo tu pudumi rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","– Tugobaigare rakareu umode tuwaiga pemegado rugadu. Umode tudariga merido tietu pemegawo tuwaiji, tietu pemegawo toeji. ");
INSERT INTO bor_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mare iwogureu jorduware turagamode ji dukeje umode tubodo apo rugadu. Umode tugobaigare butudo dukeje umode tugeragu uwaigaji piji, utariga kurireuji piji jamedu. Umode tugeragu nou tugobaigare oeji tuduwo tabo toro tumedage etae tuwo pedo pui. ");
INSERT INTO bor_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","– Aidukare iwu aidumode turo pegawo i tuwo iro pegado. Ukare tugera maku inaiwu umodukare boe etarego itae. Umode boe edo taodo ipiji. ");
INSERT INTO bor_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesus mako kimore boei. Akore: – Bope uwari pegareu umode tudawuje ia imedu piji dukeje utumode toro boe maereu ka taiwo tabo tumode tamudo kejeboe bagai. Jordumodukare taidure jiboeji dukeje meardaemode tuwo tugirimi nou tumedure tadawu imedu bagai pugeje tuwo turemo to pugeje. ");
INSERT INTO bor_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dukodire nou bope uwari pegareu umode tugirimi nou tumedure tadawu imedu ae rugadu. Aregodumode dukeje jordumode ji pemegare duji. Jordumode ji ure nono tuwai motureu mogadure duji. ");
INSERT INTO bor_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dukejere utumode toro tumedage bope doge ewagai. Enodo padure sete. Makomode ei etuwo pudabo toro nou imedu ae. Nono emode turemo nou imeduto pugeje. Dukodire boe pegamode nou imeduji rugadu. Boetojiwu meture tadawu bope uwari ure mitotu je. Aino čare bope doge enodo padu kejewumode oito nou imedu tada. Dukodire boe pegamode nou imeduji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus ure nou tuwadaru akedudo dukeje, nou boe etoiadada ia aredu ure tumago rakado toro Jesus ae mare mako pemeganure ji. Akore: – Ače maragodu rakare tuwo arijodudo. Kurijirigodure awoduwo. Ure akogwagirido. Mare aino čare boe pemegare ačeji rugadu. Jakarere pudui rugadu arore jiboeji, amagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus makore nou aredu bataru jipagi. Akore: – Boro. Boe pemegamode biapagare Pao Kurireu bataru jiwugei, meartorure Pao Kurireu bataru jiwugei. Egare remawumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Boe emagare nono Jesus apo. Ere taiado apo rugadu tuwiapagawo Jesus bataruji. Mare pagatu jere eroino. Etaidukare tumeartoruwo Jesus bataruji. Nono Jesus akore: – Aino čare boe emeardae pegare rugadu, ero pegare rugadu. Ainore tameardaere jamedu. Tamagore i iwo ia iro rakareu towuje taegai tarduwo iro rakareuji tarduwawo kaboba nuie imi. Mare pagatu jere tagagoino. Tardure iro rakareuji marigudu. Mare tagaidukare tarduwawo i. Tagaidukare tameartoruwo i rugadu. Dukodire iromodukare ia iro rakareuji taegai pugeje. Mare boemode i nono boere Jonas jitu mogadure. Dukejere boe erduwamode i rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Marigudu Pao Kurireu ure Jonas tawuje karo kurireu kuri piji turo rakareu tabo Jonas utuwo Nínive ba kurireu ka Pao Kurireu bataru tabo. Dukodire nou Nínive kejewuge erduware boe jokodu jire Jonas akoino pudui duji. Pao Kurireu umode itawuje bireuge eda piji turo rakareu tabo jamedu dukodire tarduwamode boe jokodu jire inagoino tai duji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Marigudu Sabá moto kejewuge boe eimijerago kurireudo aidure rugadu tuiorduwawo Judeu doge eimijera kurireu Salomão jorduware jiboeji. Dukodire ure tudawuje to moto piji tuduwo toro Salomão uwai ka tumearduwo Salomão makore jiboeji. Mare boe eimijera kurireu nure imi. Iro kodure Salomão ro kori. Iorduware jiboe kodure Salomão jorduware jiboe kori. Mare du inodu tabo tagaidukare tameartoruwo i. Toro ia meri keje Pao Kurireu umode boe eewodudo pugeje taiwowo boe ero pegareu bagai tuwo boe pegado ei ero pegareu moriče. Nou meriji nou Sabá moto kejewu boe eimijerago aredu mako pegamode tai tawiapagakare awu iwadaruji kodi. ");
INSERT INTO bor_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Marigudu Jonas uture Nínive ba kurireu ka tuwo nou ba kurireu kejewuge ewie Pao Kurireu bataruji. Emeardure Pao Kurireu bataruji dukodi ekiarigodure turo pegareuji. Ere tugera ra nou turo pegareu piji rugadu tumeartoruwo tu Pao Kurireuji. Mare boe eimijera kurireu nure imi. Iro kodure nou Jonas ro kori. Iorduware jiboe kodure Jonas jorduware jiboe kori. Mare du inodu tabo tagaidukare tameartoruwo i. Tagaidukare tawo tagera ra nou taro pegareu piji rugadu. Toro ia meri keje Pao Kurireu umode boe eewodudo pugeje taiwowo boe ero pegareu bagai tuwo boe pegado ei ero pegareu moriče. Nou meri keje nou Nínive kejewuge emago pegamode tai tawiapagakare awu iwadaruji dukodi. ");
INSERT INTO bor_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesus mako kimore boei. Akore: – Boe emode jorugu biado dukeje urugumodukare. Boe emode pori bu jorugu aogeje dukeje urugumodukare. Mare boe emode jorugu bararedo, uruguwo pudui boe ewo turemo tuwaito. ");
INSERT INTO bor_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tuioku tabore boe erdure boeji. Mare boe eku pegare dukeje erdumodukare boeji. Imagore jiboe ure nono boe eku mogadure. Mare boe eku ji karega inagoino. Boe emeartorumode tu imagore jiboeji dukeje boe emeardae kurimode rugadu. Dujire inagoino. Mare boe emeartorumodukare imagore jiboeji dukeje emeardae bokwamode rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dukodire čare tameartorudo imagore jiboeji. Tagaidumodukare tameartoruwo imagore jiboeji dukeje boečomode tai rugadu. Mare boečo ji karega inagoino. Tarduwa bokwamode taro pegare jiboeji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mare tameartorumode imagore jiboeji dukeje jorugumode tai. Mare jorugu ji karega inagoino. Tameardae pegareu bokwamode pugeje. Dujire inagoino. Tagaidumodukare taro pegawo pugeje. Taro pemegamode rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus ure nou tuwadaru akedudo dukeje ia fariseu imedu makore ji utuwo pudabo toro tuwai ka okwagewo pudabo tuwai keje. Dukodire Jesus uture nou fariseu uwai ka. Ure turemo uwaito dukeje ure tumugudo ira keje togwagewo. ");
INSERT INTO bor_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mare Jesus ukare tugera kabi nono Judeu doge ero mogadure. Nou fariseu jerore ta je tuiordure Jesus rore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","41","Mare Jesus jorduware nou fariseu meardaeji. Dukodire akore: – Fariseu doge nure tagi. Tare taruwobo kabi tabagaga kabi tawo epemegado tarowo nono Pao Kurireu ure maku tagaiwu bakaru umogadure. Tare taragado tai tawo nou tagoroe kabi rugadu tabemegawo nono nou makudure tagaiwu bakaru umogadure taro boeji. Mare kočare tu tadadare tameardae pegareu meture. Tarduwa bokware! Tagare tameardae pegareu barigu tabiji. Tawiapagare tu tai tawo tagoe kurido tamedage ekori rugadu. Tagaidure tawo boe pegado boei, tawo boe rakado boei. Mare Pao Kurireu koiare ure boe jamedu boe towuje. Ure boe etowuje jamedu. Eire Pao Kurireu ure maku tagaiwu bakaru akoino jamedu boe ewo nono nou ture kabiwu turuwobo mogadure tubagaga mogadure jamedu. Mare tu boe eruwobo ji karega akoino. Tu boe epagaga ji karega akoino jamedu. Meture boe etadawu emeardae jire akoino. Ča meture taruwobo tadaboe maku marenarue doge etai. Padure tabagaga tadaboe maku marenarue doge etai jamedu. Taromode aino dukeje tabemegamode tarowo nono tago bakaru umogadure taro boeji. Mare nou tameardae pemegareu tabo tamode boe pemegado tai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Jesus mako raire nou boei. Akore: – Fariseu doge nure tagi. Tare tago boepa pijiwu boe aru rogu mori kurireboe kado puiato tu tu je tagomeawo iarogu tabo Pao Kurireu ai jamedu. Mare tameardaekare tawo taro jetorodo boei. Tameardaekare tameardu kuriwo Pao Kurireuji jamedu. Kodire boe pegamode tai rugadu. Tameardu kurido Pao Kurireuji. Taro jetorodo boei. Mare tawiagodukaba tawo nou mori kurireboe kado puiato tu tu je tagomeawo iarogu tabo Pao Kurireu ai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","– Fariseu doge nure tagi. Tadumode Judeu doge ere bato puiwu bai ka dukeje tare tageragu boe eimijera mugure kejewu iraji tamuguwo keje. Tadumode ba kurireu ka dukeje tagaidure boe emago pemegawo tai tagaidure boe ekimijeragewo tagi kodi. Dukodire boe pegamode tai rugadu! ");
INSERT INTO bor_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tare nono bireuge emedure tadawu moto poro mogadure. Mare moto poro ji karega inagoino. Tabegareu meture tadada tameardae pegare kodi. Dujire inagoino. Boe erduwakare ia bireuge edaji dukodire emerumode bireuge etaoji. Erdumodukare bireu meture nou moto tada duji. Tare nono nou boe erduwakare jiwu bireuge eda mogadure. Mare bireuge eda ji karega inagoino tai. Boe erdukare nou meture tadadawu tameardae pegareuji. Dujire inagoino tai. Dukodire boe pegamode tai rugadu! ");
INSERT INTO bor_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ia jorduware Judeu doge eno bakaru jiwu makore Jesusji. Akore: – Amago pegare fariseu dogei dutabore amago pegare čei jamedu. ");
INSERT INTO bor_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus akore: – Jorduware Judeu doge eno bakaru jiwuge nure ia tagi. Mare boe pegamode tai jamedu. Tare boe erduwado bakaruji mare tawo boe pemegado ei karega. Tagogudukare boebo. Tagaidure tawo boe rakado boei rugadu. Tagare tagera maku boe etai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","49","Marigudu Pao Kurireu makore tumoduie jorduware tuwadaru jiwuge etarego boe etae ewo boe ewie iwu bakaruji. Mare boe emoduie iage ewido. Emoduie boe pegado iagei jamedu. Ainore Pao Kurireu akore marigudu. Ainore mariguduwu tawobe erore rugadu. Ero pegare nou makore Pao Kurireu bataru jiwugei rugadu. Ere iage ewido rugadu. Aino čare tare tori motureu rakojedo nou bireuge etugudure towu moto keje boe erduwawo nonore nou makore Pao Kurireu bataru jiwuge bireuge emedure. Mare tameartorukare nou bitodureuge emagore jiwu Pao Kurireu bataruji. Dukodire boe erduware tameardaeji. Tameardaere nono nou tawobe mariguduwu emeardae pegareu mogadure rugadu. Tagaidure emeardae pegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dukodire Pao Kurireu umode boe pegado tai rugadu nou makore Pao Kurireu bataru jiwuge eiamedu boe ewi moriče. ");
INSERT INTO bor_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tawobe ere ro pemegareuge ewido marigudu. Ere imedu Abel bito. Makore Pao Kurireu bataru jiwu boetojiwu nure ema. Ere makore Pao Kurireu bataru jiwu boigoduwu Zacarias bito jamedu. Ere nou Zacarias bito Pao Kurireu uwai jokorai rugadu. Nou Abel pijire jii nou Zacarias ae makore Pao Kurireu bataru jiwuge emagare rugadu. Mare tawobe mariguduwuge ere iage ewido jamedu. Dukodire awu maiwu pawobe emode mariguduwu jaoboe ero pegareu morido, aino kuri aino. Inure tawie boe remawuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Taetu pemegare Pao Kurireu bataru padure bapera kejewuji. Taro pemegare nou baperaji rugadu. Tarduware Pao Kurireu bataruji. Mare du inodu tabo tarduwakare Pao Kurireu meardae remawuji. Dukodire tameartorukare ji. Tagagore taie boe erduwado Pao Kurireu bataruji. Mare tu tameardae jire tare boe erduwado. Pao Kurireu bataru remawu ji karega tagagoino boei. Dukodire nou tare jorduwadowuge erduwakare Pao Kurireu meardae remawuji jamedu. Dukodi čare boe pegamode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus ure tuwadaru iado dukeje uture nou boe epiji. Dukejere nou fariseu doge, nou jorduware Judeu doge eno bakaru jiwuge emago pegare Jesusji rugadu. Eture rekodaji tunarawo ji dutabore ere tumago rakado ji boe jamedu boe bagai. ");
INSERT INTO bor_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Etaidure tuwo Jesus barigu boeto ia tuwadaru keje. ");
INSERT INTO bor_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Boe emagare nono Jesus apo. Dukodire ere tuwuredo pu bure keje rugadu. Mare Jesus makore tu ture jorduwadowugei boetoji. Akore: – Taeku jado nou fariseu doge emeardaere jiboeji. Emeardae ure nono fermento mogadure. Mare fermento remawu ji karega inagoino. Emeardaere tuwo turo pegareu biado boe epiji tu tu je. Ere boe emeartorudo tu tuwadaruji mare emage emeartorukare nou tumagore jiboeji. Dujire inagoino. Tarokaba nono ero mogadure. ");
INSERT INTO bor_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Boe ero pegamode dukeje etaidumode tuwo nou turo pegareu biado boe epiji tagowo ro pemegareuge nuie pudumi. Mare Pao Kurireu jorduware ero pegareuji marigudu dukodire boe erduwamode nou ero pegareuji jamedu. Dukodire itaidure iwo tawie. Tarokaba nono fariseu doge ero mogadure. Tamago pegamode iaboeji boečoji dukeje Pao Kurireu meardumode rugadu. Toro ia meri keje boe eiamedu boe emeardumode nou tamagore jiboeji jamedu. Tamago podumode pui pu bijato ia tameardae pegareuji tawai tada mare Pao Kurireu meardumode nou tamagore jiboeji rugadu. Dukodire uwadodumode nou tamagore jiboe tabo boe eiamedu boe ewiagai. Dukodire inure tawie. Taro pegakaba, tamago pegakaba nono nou fariseu doge ero mogadure. ");
INSERT INTO bor_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus mako kimore. Akore: – Imedage nure tagi. Iwo tawie. Tabagudukaba boeče. Tabagudukaba bope dogeče. Boe emode tawido mare eragakare tuwo tawarigu bope doge eda kejewu joru pegareuto. Bope uwari umode boe pegado tai mare rakakare tuwo tawarigu tieda kejewu joru pegareuto. ");
INSERT INTO bor_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iwo tawie. Tabagududo tu Pao Kurireuče. Tu Pao Kurireu meardae koiare umode boe ewarigu bope doge eda kejewu joru pegareuto boe ewi keje. Dukodire inagoino tai. Tabagududo tu Pao Kurireuče. ");
INSERT INTO bor_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Mare tabagudu remawu ji karega inagoino. Taeku kidugo Pao Kurireuji tameartoruwo tu ji rugadu. Dujire inagoino. Tameartorumode tu Pao Kurireuji dukeje tamororamagadumodukare boe pega boeji pugeje. Dujire inagoino. Pao Kurireu jetu pemegamode tai rugadu. Dukodire tameartorudo tu ji rugadu. Dukodire inagoino tai. Ča kiebarege kugure emode ikera aboudure dukeje boe emode diero tori rogu udo pobe emoriče tuwo akirodo ei tugeče tuwo ekowuje. Nou kiebarege emori bokware. Mare du inodu tabo Pao Kurireu biagodumodukare nou kiebarege ekugure piji rugadu jii toro. Jorduware kiebarege eiamedu boei. Aidure kiebarege kugurei. Mare Pao Kurireu aidure tai du kodure nou kiebarege kugure eiamedu boe ekori. Dukodire jetu pemegamode tai rugadu. Jorduware tai rugadu. Jorduware tagao iku jamedu boeji. Jorduware nou inodu rogu boeji kodire jorduware nuba boe mode tai duji rugadu. Jetu pemegamode tai rugadu. Dukodire inagoino tai tabagudukawo boeče pugeje. ");
INSERT INTO bor_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesus mako kimore. Akore: – Imedu Onaregedu nure imi. Iwo tawie. Ia boe emagomode boe eiamedu boe ewiagai tuie tumagu inai tumeartoruwo tu i dukeje imagomode Pao Kurireu utugarege baru tadawuge ewiagai nou meartorure iwu nuie ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mare ia boe emagomode boe ewiagai tugaie tumagu inai, tumeartorukaie i dukeje imagomode Pao Kurireu utugarege baru tadawuge ewiagai nou meartorukare iwu nuie ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Boe emago pegamode Imedu Onaregeduji mare toro ia meri keje ekiarigodumode nou tuwadaru pegareuji. Emagomode Pao Kurireuji biagoduwo nou tuwadaru pegareu piji. Dukeje Pao Kurireu biagodumode ewadaru pegareu piji rugadu. Mare ia boe emago pegamode Pao Kurireu Uwariji dukeje Pao Kurireu biagodumodukare nou ewadaru pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tameartorure i. Dukodire boe emode tugeragu tai tuwo tarego boe eimijerage etae etaiwowo taro pegareu bagai tuwo boe pegado tai tameartorure i dukodi. Emago pegamode tai mare tamororamagadukaba tamagowo ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pao Kurireu Uwari umode tarduwado nou meriji tamago pemegawo ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Boe emagare nono Jesus apo. Ia imedu makore Jesusji. Akore: – Ure boe erduwadowu nure aki rugadu. Čare inogwamaguduwo ai. Amagodo imanaji uwo iogware maku pudaiwu moto kado puiato uwo ia maku inai inoče jamedu. ");
INSERT INTO bor_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus akore: – Itaidure ai. Mare umode boe enoe kado puiatowu boe eimijera karegure imi. ");
INSERT INTO bor_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dukodire Jesus makore boe eiamedu boei. Akore: – Taeku jado. Boe emeardaere tu pudui tuwo toe kurido tumedage ekori rugadu. Taragado tai tarokawo nono nou boe ero mogadure. Tagoe kurimode mare tagoe umodukare tamugu pemegado. Boe enoe koia karega umode boe emugu pemegado moto keje tiegarere pudui dutabo. ");
INSERT INTO bor_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nono Jesus makore ia bakaruji nou boe ewiagai. Akore: – Ia imedu oe kurire. O moto kurire. O boepa kurire rugadu. Nouia joruji ure kadoboe kurire rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ure boe jamedu boe tawuje nou to boepa piji dukeje makore tudada. Akore: “Imode biadowu towu bai kurikare iwo ire kadoboe jamedu boe jetudo ja tada. Ča nuba iromode?” ");
INSERT INTO bor_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nono ure tumeardae tawuje pugeje. Akore: “Ainore iromode. Imode nou iwai jamedu boe butudo iwo ia iwai kurireu mugudo pugeje iwo ire kadoboe jamedu boe jetudo nou iwai kurireu maiwu ja tada, iwo inoe kurireu jamedu boe jetudo nou iwai kurireu ja tada jamedu. ");
INSERT INTO bor_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dukeje inagomode iwaidigirire rugadu. Aino čare imode itamudo rugadu. Imaragodumodukare pugeje. Nono iagaremode inogwarimode nou inoe kurireu jamedu boeji. Joru makamode i mare inoe akedumodukare inoe kurire kodi. Čare iwadumode imedagebo. Inogwagemode. Ikudumode. Boe pemegamode i rugadu jii toro rugadu. Boe rakamodukare i pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","– Ainore nou imedu akore. Mare Pao Kurireu makore nou oe kurireu imeduji. Akore: “Arduwa bokware. Awu boečoji awimode rugadu. Mare atumodukare nou akoe kurireu boe tabo. Nou akoe mugumode aiageje moto keje. Ča duboba umode tugeragu nou akoeji?” ");
INSERT INTO bor_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nono Jesus makore pugeje. Akore: – Ainore boemode nou ure toe kuridowuge boe eiamedu boei. Ere toe kurido mare ewiapagakare tumeartoruwo Pao Kurireuji. Dukodire enoe bokwamode baru tada. Marenarue doge nure emage Pao Kurireu jakai. ");
INSERT INTO bor_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus mako kimore ture jorduwadowugei. Akore: – Tamororamagadukaba tage bagai, tagudau areia bagai. ");
INSERT INTO bor_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pao Kurireu ure tadowuje. Ure tawodudo. Emare jetu pemegamode tai. ");
INSERT INTO bor_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tagaiwodo awu kiebaregei. Ekare boe tugu. Ekare tugeragu boeji. Eke ja bokware. Eke muga bokware. Mare du inodu tabo Pao Kurireu koiare ure enogwagedo. Boe nure tagi. Pao Kurireu meardu kurire boei nou kiebarege ekori. Dukodire inagoino, jetu pemegamoduie tai. ");
INSERT INTO bor_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Pao Kurireu jorduware tawimode kejewu meriji. Tagi rema tarduwakare. Tamororamagadumode mare tamodukare tawimode kejewu meri raido toro tagododai tamugu raiwo moto keje. Dukodire inagoino, tamororamagadukaiago iaboe rogu bagai pugeje. Tameartorudo tu Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","28","Tagaiwodo awu okureboeji. Emodure mare emage eigoia karega ere tumodudo. Pao Kurireu koiare ure awu okureboe emodudo aino. Mariguduwu Israel doge eimijera kurireu Salomão oe kuričigore dukodire meture jiwu ukudau areia moture rugadu. Mare motukare nono awu okureboe emodu mogadure. Ča okureboe emodure mare joru umode ekowu kuri je. Mare boe nure tagi. Pao Kurireu meardu kurire boei nou okureboe ekori. Dukodire umode tugera maku tagai rugadu. Dukodire inagoino tai tamororamagadukaba tagudau areia bagai, tameartoruwo tu Pao Kurireuji rugadu. Tameartorumode ji dukeje tamode nono awu okureboe umogadure jamedu. Pao Kurireu jetu pemegamode tai rugadu. Kočare tameartoru kurikare ji? ");
INSERT INTO bor_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tamororamagadukaba nou tagwagemode jiboe bagai. Tamororamagadukaba nou tagudumode čeboe bagai. ");
INSERT INTO bor_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mare meartorukare Pao Kurireu jiwuge ewiagorore tu nou tuge roguji tuge rogu bagai. Mare tameartorumode Pao Kurireuji dukeje tawiagoromodukare nou inoduji. Pao Kurireu jorduware kaba jiba tagaidure. ");
INSERT INTO bor_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dukodire tameardae tawuje tawo tagimijera kurireudo tu Pao Kurireuče. Tamode tagimijerado ema dukeje umode tage jamedu boe maku tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesus mako kimore: – Tabagudukaba. Pao Kurireu aidure tuwo tagimijerado pudumi tuwo boe pemegareu maku tagai baru tada. ");
INSERT INTO bor_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tagoe rugadu boe maku. Nou morire tamode maku marenarue etai. Taromode aino dukeje tanure tagoe kurireu jetudo baru tada. Toro tagoe akedumodukare rugadu. Toro iwogureu iwogumodukare nou tagoeji. Toro boreu umodukare nou tagoe pegado. ");
INSERT INTO bor_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Boe etaidure tu tuwo toe kurido woe moto keje dukodire ewiagoromode tu nou toeji woe rugadu. Nou boe ewiapagamodukare Pao Kurireu bataruji. Mare boe emode toe jetudo baru tada dukeje boe ewiagoromodukare ia moto kejewu toeji pugeje, boe ewiapagamode tu Pao Kurireu bataruji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","– Tado tarugadu tamaragoduwo Pao Kurireu ai. Tarodo nono boe eimijera utugarege ero mogadure. Ere tumaragodure tabowu tugudau areia metudo pudui. Enoredure jorugu tabo tumaragoduwo boečoji. ");
INSERT INTO bor_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Epagare tugimijera bagai. Ekimijera uture uwiremodewu bowadae ka. Mare aregodure tuibagi tuwai ka boečoji dukeje ure tugera to tuwai poroji. Nono utugarege ere baiporo jado kuri kuri je rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ekimijera aregodure dukeje jordure nou tudugaregei enudukare duji. Dukodire jakarere pudui nou tudugaregei. Nono utugarege egarere pudui rugadu. Egarere pudui nou tugimijera jakarere pudui dukodi. ");
INSERT INTO bor_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ekimijera aregodukare kuri je. Boečo aregodure toia ka dukejere aregodure. Mare utugarege ere tudo turugadu tugimijera aregodu bagai rugadu. Dukodire egarere pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Uwaire bai čewu jorduwamode kaba meri kejeba iwogu kigodureu aregodumode. Dukeje umode tudo turugadu taiwo tabo nou iwogu kigodureu bagai, nou iwogu kigodureu ukawo turemo nou tuwaito. ");
INSERT INTO bor_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ča iwo tawie. Tado tarugadu, taerodo tagaiwo tabo tabiji. Mare iwogureu bagai karega. Tado tarugadu Imedu Onaregedu togi. Tarduwakare kaba meri kejeba aregodumode dukodire inagoino tai, tawo tado tarugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro unarare Jesusji. Akore: – Tu čei na akagoino? Boe eiamedu boei na akagoino nou bakaruji? ");
INSERT INTO bor_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesus akore: – Ča nuba boemode pemegareu jorduwareu boe etugareji? Ukimijera aidumode tuduwo toro ia moto ka dukeje umode nou tudugare pemegareu mugudo tumugato tudugarege eimijerawo ema uwo eke maku etai nou tudure jiwu meri keje. ");
INSERT INTO bor_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nou utugare ro pemegamode meartorumode tugimijeraji jii toro tugimijera aregodumode kejewu meri ka dukeje jakaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Dukejere čare nou boe eimijera umode nou tudugare jetudo toe jamedu boeji rugadu jetu pemegawo ji. Boe jokodu jire inagoino nou meartorure iwadaru jiwugei. ");
INSERT INTO bor_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mare ia boe utugare meardae pegamode. Nou ukimijera utu jaemode jamedu dukeje aregodumodukare tuibagi kuri je. Nono nou utugare pegareu meardaemode tugimijera aregodumodukaie pugeje. Nono umode boeto nouia tudugarege imei, aremei jamedu. Nono maragodumodukare pugeje mare okwagemode, kudumode jamedu. Nono uke kurumode ji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Čare ia meri keje nou ukimijera aregodumode tuibagi pugeje. Mare nou utugare upagakare bagai. Jorduwakare aregodumode kejewu meriji. Nono nou boe eimijera jordumode nou tudugare ro pegare duji. Dukodire nou ukimijera umode nou tudugare bito. Umode bowuje rugadu. Nono umode nou tudugare mugudo meartoru bokwareugebo bope doge eda kejewu joru pegareu keje. ");
INSERT INTO bor_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","– Ia boe utugare jorduware tugimijera meardaeji mare ukare turagado pudui tumeartoruwo tugimijera bataruji. Nono nou ukimijera umode boeto ji bukigu tabo turaga tabo rugadu. Umode boetodu kurido ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ia utugare jorduwakare nou tugimijera meardaeji dukodire ro pegare. Dukodire ukimijera umode boeto ji bukigu tabo jamedu mare umodukare boetodu kurido ji. Boe eimijera umode tudugare maragodae rogu maku ai dukeje nou ukimijera aidumode nou tudugare meartoruwo pudui tuwadaruji uwo nou tumaragodae rogu iado rugadu. Mare nou ukimijera meardaemodukare tuwo ia tumaragodae maiwu maku tudugare ai, jorduwamodukare tuwo towuje kodi. Mare boe eimijera umode tudugare jorduwado tumaragodae jamedu boeji dukeje nou ukimijera aidumode nou tudugare uwo nou tumaragodae jamedu boe towuje rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus mako raire boei kimo. Akore: – Itaregodure iwo joru barigu moto ka. Itaidure joru bariguduwo moto ka marigudu mare Iogwa aidukare raga. Mare joru remawu ji karega inagoino. Pao Kurireu umode boe pegado ro pegareugei. Dujire inagoino. Ro pegareuge ewarigudumode toro nou joru pegareuto. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mare boe pegamode i boetoji dukodire ikiarigodure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tameardaere itaregodure iwo boe epemegado tai. Ča itaregodure iwo boe pemegado boei rugadu. Mare ia boe doge emeartorumodukare i. Dukodire emeardaemodukare nono pumeardae mogadure imagore jiboeji. Dukodire boe epemegamodukare pui. ");
INSERT INTO bor_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dukodi čare boe epomodukare puapo dukeje emeardaemodukare nono tuwobe emeardae mogadure. Emode tugera aboudure dukeje. Nou ime pobedu doge emeardae pegamode nouia tuwobe emeardaere jiboeji, dukodire emode tuiado pubiji. ");
INSERT INTO bor_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ime emeardaemodukare nono tuo meardae mogadure. Dukodire nou etuo meardae pegamode nou tore imei. Areme emeardaemodukare nono tuje meardae mogadure. Dukodire nou etuje meardae pegamode nou tore aremei. Areme emeardaemodukare nono turagomage emeardae mogadure. Dukodire nou eturagomage emeardae pegamode nou tujarugomagei. ");
INSERT INTO bor_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus mako kimore nou boei. Akore: – Tardumode ia boe tugu čoreuji baru tada kodure tagae duji dukeje tagagomode bubutumoduie rugadu. Nono bubuture rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bakuru urureu jetumode tai dukeje tagagomode awu meriji boeru butumoduie jamedu. Nono boerure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tarduware tawo boe ewie bubutuji boeruji. Dukodire tagagore jorduwareuge nuie tagi. Nono tagagomode tarduwaie nuba boemoduie boei. Mare kočare meartorukare tuwadaru jiwuge nure tagi. Tagagore tarduwaie Pao Kurireu meardae remawuji. Tardure iro rakareu remawuji mare tarduwakare kaba jiba iroino. Dukodi čare tarduwakare Pao Kurireu meardae remawuji. ");
INSERT INTO bor_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus mako kimore boei. Akore: – Kodiba tagare tameardae tawuje nuba boe ero pemegareumode? ");
INSERT INTO bor_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ia boe aidumodukare ia arore pudui duji. Aidumode tuduwo akabo toro boe eimijera ae aiwowo aroji aro pegareu bagai. Mare amago pemegado ji tawo tameardae maku puai taro pegakawo pugeje tawo tabemegado pui. Mare amago pemegamodukare ji dukeje umode arego toro boe eimijera ae rugadu. Nou boe eimijera aiwomode arore jiboeji dukeje jorduwamode aro pegare jiboeji rugadu. Nono umode amagu tugobaigarege etai ewo atugu baičoreuto. ");
INSERT INTO bor_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iwo awie. Amodukare apemegado nou korigodure aiwuji dukeje atugudumode baičoreuto rugadu. Aragojemode nono baičoreu tada jii amode aro morido du ka. ");
INSERT INTO bor_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nou meriji ia boe ere Jesus bie. Egore: – Boe pega. Ia pawobe Galiléia kejewuge eiago boe egu barogo rogu kowu tomeawo Pao Kurireu bagai mare Roma pijiwu boe eimijera Pilatos ure ewido. ");
INSERT INTO bor_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus akore: – Tameardaere nou pawobe Galiléia kejewuge bireuge ero pegaie nou tumedage ekori dukodire ewidodure aino? Ainore boe emeardaere. ");
INSERT INTO bor_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mare imode tarduwado. Ero pegareu koia karega ewire aino. Paedure boe pegareu tada kodire boe ewimode. Iwo tawie. Tamodukare tagera ra taro pegareu piji dukeje tawimode jamedu nono ewi mogadure. ");
INSERT INTO bor_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ia Jerusalém kejewuge ewire jamedu. Enodo padure dezoito. Edure Siloé tada Jerusalém ba kurireu keje. Dukejere ia mačebradu ričoreu buture ewugeje dukodire ure ewido. Boe egore nou boe ero pegaie nouia tumedage Jerusalém ba kurireu kejewuge ekori dukodire ewire aino. ");
INSERT INTO bor_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mare iwo tarduwado. Du inodu kodi karega ero pegare tumedage ekori. Iwo tawie. Boe eiamedu boe ero pegare. Tagi jamedu. Tamodukare tagera ra taro pegareu piji dukeje tawimode jamedu nono nou enodo padure dezoito boe doge ewi mogadure. ");
INSERT INTO bor_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nono Jesus readodure ia to bakaruji nou boe ewiagai. Mare bakaru remawu karega. Readodure tuwo erduwado toro nouia Pao Kurireu meardaeji. Akore: – Ia imedu o boepare. Uva ikure nou boepa tada. Nono nou uva iku oiadada ia figo i rakojere jamedu. Nou ore boepa čewu aiwore nou figo ito ia tudu kurodu bagai mare jordukare ia tuduji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dukodire makore tudugareji. Akore: “Jorure pobe metia bokware i itaiwo tabo nou figo ito. Mare iordukare ia tudu roguji. Dukodi awu figo i kado. Butudo. Rakojekawo nono ino boepa tada pugeje!” Ainore nou ore boepa čewu akore. ");
INSERT INTO bor_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mare nou utugare akore: “Kajao. Imaragodumode nou figo iji awu joruji pugeje. Imode boe pemegado ji rugadu. Imode tapira pe bu nou figo i paru keje moto pemegawo nou figo iji tuduwo. ");
INSERT INTO bor_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nono tudumode. Mare tudumodukare boeiwu joru keje dukeje pamode nou figo i kado rugadu.” Ainore Jesus akore. ");
INSERT INTO bor_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ia sábado meri keje Jesus rakojere Judeu doge ere bato pui towu bai ja tada. Ure boe erduwado nono. ");
INSERT INTO bor_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nono jordure ia aredu kogodureudoji. Bope ure pegado kejewu joru oto padure dezoito. Merukare tiedoro tabo. Roiwakare tuwo tiedorodo. ");
INSERT INTO bor_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus makore bagai dukeje makore ji. Akore: – Ire akinorudo akogodae piji. Ire apemegago. ");
INSERT INTO bor_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nono Jesus ure tugera bu nou aredu poru keje. Ča nou aredu pemegagodure tači je. Jakaregodure pudui rugadu. Mako pemegare Pao Kurireuji, Jesus rore aino pudui dukodi. ");
INSERT INTO bor_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nou jeture nou bai jiwu boe eimijera korigodure Jesus rore aino Sábado meri keje duji. Dukodire makore nou bai tadawu boei: – Pao Kurireu makore pai pamaragodukawo sábado meri keje. Dukodire tagaregodukaba mato sábado meriji boe ewo tabemegago. Tagarego mato boe ewo tabemegago ia meri keje. ");
INSERT INTO bor_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Jesus akore: – Ča tameartorukare tamagore jiboeji jamedu. Tamode tagagu ie etarego pobo ka tawo ekududo poboče sábado meriji mare tardu pegakare nou tarore aino duji. Mare tagaidukare boe pemegawo awu areduji sábado meriji. Pawobe nure ema. Bope doge eimijera Satanás ure kogodudo marigudu. Kogodure oto padure kejewu jorure dezoito rugadu. Mare aino Pao Kurireu ure pemegago awu meriji. Mure kodiba tagaidukare pemegagoduwo sábado meriji? Tamagore Pao Kurireu makore jiboeji mare tameartorukare ji! ");
INSERT INTO bor_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesus akore aino dukeje nou aidukare Jesus jiwuge erduwakare tumagowo Jesus bataru jipagi. Dukodire epogurure tumagowo ia tuwadaruji pugeje. Mare boe eiamedu boe egarere pudui Jesus ro pemegare aino duji. ");
INSERT INTO bor_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus akore: – Itaidure iwo tarduwado nuba nou ure tugimijerado Pao Kurireu čewuge ere. Nou Pao Kurireu utugarege emagakare mare ia meri keje Pao Kurireu utugarege emagagodumode rugadu. Ireadoduwo ia bakaruji tawiagai, dukeje tarduwamode kaboba jiba inagoino. ");
INSERT INTO bor_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ia imedu ure ia mostarda a tugu to boepato. Nono boture. Ričodure rugadu. Nono i kurire, tugu kurire jamedu. Kiebarege ere tumugudo keje. Ere tuwaradu pemegado keje. Pao Kurireu utugarege ere nono nou mostarda a rogu mogadure. Mare mostarda a remawu ji karega inagoino. Ure tugimijerado Pao Kurireu čewuge eire inagoino. Emagakare mare ia meri keje nou Pao Kurireu utugarege emagamode rugadu. ");
INSERT INTO bor_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus mako kimore ei. Akore: – Itaidure iwo tarduwado nuba ure tugimijerado Pao Kurireu čewuge emode. Nou Pao Kurireu utugarege emagakare mare toro ia meri keje nou Pao Kurireu utugarege emagagodumode rugadu. Ireadoduwo ia bakaruji tawiagai, dukeje tarduwamode kaboba jiba inagoino. ");
INSERT INTO bor_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia aredu ure fermento tugu trigo kuduto. Dukejere ure nou trigo udo amireuče. Nono nou fermento jore nou amireu jamedu boeto, dukeje ure nou amireu barodudo. Pao Kurireu utugarege ere nono nou fermento mogadure. Mare fermento remawu ji karega inagoino. Ure tugimijerado Pao Kurireu čewuge eire inagoino. Emagakare boetoji mare toro ia meri keje nou Pao Kurireu utugarege emagagodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus uture pugeje. Kodure Jerusalém ba kurireu kawu awaraji tuduwo Jerusalém ba kurireu ka. Boe eda jamedu boe keje ure boe erduwado. ");
INSERT INTO bor_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Toro ia boe eda keje ia boe enarare ji. Egore: – Ioguduba umode činorudo? Ure činorudowuge emagamodu kana? ");
INSERT INTO bor_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesus makore nou boei. Akore: – Pao Kurireu meardae ure nono baiporo biagareu ja mogadure. Boe emode turemo baiporo biagareuto taregoduwo Pao Kurireu ae. Mare baiporo remawu ji karega inagoino. Pao Kurireu meardae jire inagoino. Taragado tai tawo tameardae pemegado nono Pao Kurireu meardae mogadure tawo taremo baruto Pao Kurireu mugureu ka. Aidumode tuwo turemo baru tadawu Pao Kurireu uwai towuge emagamode rugadu mare eroiwamodukare tuwo turemo toro. Ekare tugimijerado Pao Kurireuče dukodire iage emodukare turemo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pao Kurireu umode tuwai kejewu baiporo miwuje dukeje ia tagi tamodukare taremo baru tadawu Pao Kurireu uwaito rugadu. Mare baiporo remawu ji karega inagoino. Pao Kurireu jorduware jiwu meri jire inagoino. Toro ia meri keje Pao Kurireu umode tumeardae tawuje tuwo nou meartorukare puduiwuge ewarigu bope doge eda kejewu joru pegareuto. Dujire inagoino. Dukodire nou boe eroiwamodukare tuwo turemo baruto rugadu. Ia tagi tagare tagimijerado Pao Kurireuče. Tamagomode Pao Kurireuji: “Čeremo baruto čeragojewo čemedagebo baru tada.” Ainore tagagomode Pao Kurireuji. Mare umodukare taremo baruto rugadu. Pao Kurireu makomode: “Imedage karegure tagi. Iwobe karegure tagi.” Ainore Pao Kurireu akomode ia tai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nono tagagomode: “Čenogwagere akabo. Čegudure akabo. Are boe erduwado čedabo čeda keje.” Ainore tagagomode. ");
INSERT INTO bor_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mare Pao Kurireu makomode pugeje: “Iwobe karegure tagi. Tadudo ipiji. Ro pegareuge nure tagi.” Ainore Pao Kurireu akomode tai. ");
INSERT INTO bor_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nou meriji tardumode Abraãoji, Isaqueji, Jacoji nono Pao Kurireu apo rugadu. Nou meriji tardumode nouia makore Pao Kurireu bataru jiwugei jamedu nono Pao Kurireu apo rugadu. Mare tawarigudumode toro bope doge eda kejewu joru pegareuto. Dukodire tagragudu rakamode rugadu. Tamode tago reko pui tawiri boe kori koia. ");
INSERT INTO bor_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nou meriji Pao Kurireu umode boe eimijera kurireudo pudumi nono meartorure Pao Kurireu jiwuge etaregodumode Pao Kurireu ae moto jamedu boe piji. Nono emode tumugudo Pao Kurireu apo nono Pao Kurireu bowadae keje toro baru tada. ");
INSERT INTO bor_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ia meartorukare iwuge enoe kurire woe moto keje mare nou meriji Pao Kurireu umode marenarue dogedo emage. Ia marenarue doge emeartorure i woe moto keje dukodire nou meriji Pao Kurireu umode enoe kurido rugadu nono Pao Kurireu muga keje. ");
INSERT INTO bor_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nono ia fariseu doge etaregodure Jesus ae tumagowo ji. Egore: – Atudo awu boe piji toro ia boe eda ka. Boe eimijera pegareu Herodes aidure tuwo awido. ");
INSERT INTO bor_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus akore: – Herodes ro pegare nono okwa ro pega mogadure. Jerore turo pegawo tu tu je. Tadudo toro bagai tawo Herodes bie nuba iromode boei duji. Awu meriji, barogwato imode bope doge etawuje boe epiji. Imode boe epemegago jamedu. Boeiwu barogwato imode nou imaragodae iado. Biedu pemegado awu inagore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mare iwo tawie. Iturumode Jerusalém ba kurireu ka awu meriji, barogwato, boeiwu barogwato jamedu. Mariguduwuge ere nouia makore Pao Kurireu bataru jiwuge ewido nono Jerusalém ba kurireu keje tu tu je. Dukodire itumode toro iwiwo nono jamedu. ");
INSERT INTO bor_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","– Jerusalém kejewuge nure tagi. Tare nou mariguduwuge makore Pao Kurireu bataru jiwuge ewido. Tagidore tori tabo aregodure Pao Kurireu bataru tabowugei. Mare imeardu kurire tai rugadu. Kagariga umode tore ewiado tugana kuda tietu pemegawo ei. Itaidure irowo taiamedu boei nono nou kagariga ro moga torei dumogadure. Mare tagaidukare i. ");
INSERT INTO bor_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dukodire Pao Kurireu mugumodukare Jerusalém kejewu tuwai tada pugeje. Iwo tawie. Tardumodukare i pugeje jii toro tameartorumode i du ka. Tagagomode: “Pagimijera reo! Aregodure Pao Kurireu meardae tabo. Pao Kurireu ro pemegawo ji.” Tagagomode aino i dukeje itaregodumode tagae pugeje. ");
INSERT INTO bor_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ia sábado meri keje Jesus uture toro ia fariseu uwai ka togwagewo apo. Judeu doge eimijera nure ema. Dukodire boe etaiwore Jesus makore nou boe eimijera jituji. Ia fariseu doge edure nono jamedu. Ia jorduware Judeu doge eno bakaru jiwuge edure nono jamedu. ");
INSERT INTO bor_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nono ia imedu aregodure Jesus ae nono nou fariseu uwai ka. Pogora bokodure. Kana bokodure jamedu. ");
INSERT INTO bor_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nono Jesus unarare nou fariseu dogei, nou jorduware Judeu doge eno bakaru jiwugei jamedu. Akore: – Nuba pago bakarure? Pamodukana boe epemegago sábado meri keje? ");
INSERT INTO bor_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nou fariseu doge, nou jorduware Judeu doge eno bakaru jiwuge emagokare boeji. Nono Jesus ure nou imedu pemegago. Ure kana bokodu akedudo, ure pogora bokodu akedudo jamedu. Nono Jesus ure nou imedu utudo tuibagi tuwai ka. Mare nou fariseu doge, nou jorduware Judeu doge eno bakaru jiwuge erdu motukare boewo boe epemegago sábado meri keje. ");
INSERT INTO bor_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mare Jesus makore nou fariseu dogei. Makore nou jorduware Judeu doge eno bakaru jiwugei jamedu. Akore: – Ia tagi tagagu tapira imedu butumode ia kačiba poto sábado meriji dukeje tamode nou tagagu tapira tawuje nou kačiba po piji nou meri keje rugadu. Ia tagi taganaregedu butumode kačiba poto sábado meriji dukeje tamode nou taganaregedu tawuje nou kačiba po piji nou meri keje kuri je rugadu. ");
INSERT INTO bor_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nou boe eimijerage fariseu doge eroiwakare tumagowo Jesus bataru jipagi. Nou jorduware Judeu doge eno bakaru jiwuge eroiwakare tumagowo Jesus bataru jipagi jamedu. ");
INSERT INTO bor_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Boe etaregodure nou bai ka togwagewo dukeje Jesus aiwore nou boe erore jiboeji. Aregodure boetojiwuge ere tumugudo boe eimijerage emuga keje boe pemegareu keje. Dukodire Jesus makore nou boei tuwo emeardae pemegado. ");
INSERT INTO bor_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Akore: – Boe emagomode tawagai tagaregoduwo boe uwiremodewu bowadae ka dukeje tadumode toro. Nou makore tawagaiwu makomode ia boe eimijera kurireu bagai jamedu mare tarduwakare. Tagaregodure dukeje tagaba tamugudo boe pemegareu keje tagojaro tabo tai. Tamode tamugudo boe pemegareu keje. ");
INSERT INTO bor_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mare nou boe eimijera kurireu aregodumode dukeje nou makore tawagaiwu umode tadawuje nou boe pemegareu piji nou boe eimijera kurireu uwo tumugudo tumuga keje. Akomode aino tai: “Aragojedo awu boe eimijera uwo tumugudo woe awu boe pemegareu keje.” Ainore akomode tai. Nono tabogurumode. Nono tamode tamugudo toro nou boe etugarege emuga keje. ");
INSERT INTO bor_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dukodire inagomode aino tai. Tagaba tamugudo boe pemegareu keje tameardae tabo. Tagaregodumode boe ewadae ka dukeje tamugudo nono nou boe etugaregebo. Nono nou boe ewadae kejewu boe eimijera makomode tawagai tuwo tamugudo nono taidure jiboe keje. Nono tabogurumodukare. Boe emago pemegamode tarore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iwo tawie. Boe enojaromode pudui, emode tugimijerado tu pudumi tumeardae tabo dukeje Pao Kurireu umode epogurudo. Mare boe emode boe utugaregedo pudumi turo pemegawo boei dukeje Pao Kurireu umode boe eimijera pemegareugedo emage. ");
INSERT INTO bor_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nono Jesus makore nou uwaire bai čewuji. Akore: – Amode ake kurido awadae keje mare amagokaba amedage ewagai enogwagewo akabo. Amagokaba awobe ewagai enogwagewo akabo. Amagokaba oe kurireuge ewagai enogwagewo akabo jamedu. Enogwagemode akabo dukeje toro ia meri keje emage emagomode awagai jamedu akwagewo pudabo jamedu nou arore pudui du moriče. ");
INSERT INTO bor_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mare are ake kuričigodo awadae keje. Dukeje amagodo marenarue doge ewagai, joku bokwareuge ewagai, pogora pegareuge ewagai, kogodureuge ewagai enogwagewo akabo. ");
INSERT INTO bor_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nono boe pemegamode ai rugadu. Emagere emodukare boe pemegareu maku akai nou arore pudui du moriče. Mare toro ia meri keje Pao Kurireu umode boe eewodudo pugeje dukeje umode boe pemegado ai nou aro pemegareu moriče. ");
INSERT INTO bor_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nouia mugure nono Jesus apowu meardure Jesus akore aino duji dukejere makore Jesusji. Akore: – Pao Kurireu umode boe eimijera kurireudo pudumi dukeje umode boe enogwagedo pudabo. Nou baru tadawu Pao Kurireu uke kurimode rugadu. Dukodire boe pemegamode nou okwagemode Pao Kurireu apowugei. Egaremode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nono Jesus makore ji. Akore: – Marigudu ia imedu ure ia boe ewadae kurireu towuje. Makore bagaiwuge emagare rugadu. Mare makore ewagai etaregoduwo nou ture tawujewu meri ka enogwagewo pudabo. ");
INSERT INTO bor_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ure boe jamedu boe udo turugadu dukeje ure tudugare utudo nou tumagore bagaiwuge ewagai tuwo ewie boe uie turugadu duji etaregoduwo tuwadae ka rugadu. Nou utugare uture nou boe ewagai rugadu. Makore ei. Akore: “Mato boe ewadae ka. Ikimijera ure boe jamedu boe udo turugadu.” ");
INSERT INTO bor_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","– Mare nou makore bagaiwuge etaidukare tuduwo toro. Eiamedu boe egore nou utugareji tudumodukaie. Ia akore: “Ire ikeragu ia motoji inoče dukodire itumode toro nou moto ka iorduwo ji. Dukodire iroiwakare ituwo nou akimijera bowadae ka.” ");
INSERT INTO bor_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","– Metia akore jamedu: “Ire akirodo tapira dogei. Enodo padure dez. Ewo tumugudo ino carroça keje. Dukodire itumode toro nou tapira doge ewagai iorduwo emaragodu pemegamode dubagai. Dukodire iroiwakare ituwo nou akimijera bowadae ka.” ");
INSERT INTO bor_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","– Ia metia akore: “Maigodure iwirere. Iragojemode tu woe itoreduje apo. Dukodire iroiwakare ituwo nou akimijera bowadae ka.” ");
INSERT INTO bor_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","– Nono nou utugare ure tugirimi tuibagi tugimijera bagai. Readodure nou boe egore aino pudui duji nou tugimijera biagai. Nou ukimijera korigodure nou tumagore bagaiwuge ewagai. Makore nou tudugareji. Akore: “Atudo toro nou boe eda ka amara tabo. Amagodo marenarue dogei. Amagodo joku bokwareugei. Amagodo pogora pegareugei. Amagodo kogodureugei. Akarego mato ebo enogwagewo pagabo.” ");
INSERT INTO bor_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","– Nou utugare meartorure nou tugimijera bataruji rugadu. Makore nou boe eiamedu boei rugadu. Aregodure nou boebo tuibagi kuri je. Dukeje makore tugimijeraji pugeje. Akore: “Imeartorure awadaruji rugadu. Mare aino čare pawai ja kuri kimore dukodire čere boei kimo.” ");
INSERT INTO bor_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","– Dukodire nou ukimijera akore: “Atudo toro ia boe eda kawu awaraji nou mugure awara okwaiwu boe ewai jamedu boe ka amagowo nou boe ewagai jamedu. Etudo mato rugadu. Itaidure iwai korobaduwo boebo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mare iwo tawie. Nou imagore bagaiwuge boetojiwuge enogwagemodukare woe itabo rugadu.” Ainore nou Jesus readodure jiwu bakaru ure. ");
INSERT INTO bor_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ia meri keje boe emagare nono Jesus apo tugodui apo. Nono Jesus ure tuwuredo tumagowo ei. ");
INSERT INTO bor_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Akore: – Ia boe etaidumode tumeartoruwo imeardaeji. Mare emeardu kurimode i dukeje imode erduwado imeardae remawuji rugadu. Emeardu kurimode i tuje kori, tuo kori, tore ekori, tumanamage ekori, tuduiemage ekori dukeje imode erduwado imeardae remawuji. Mare emeardu kurimodukare i tuje piji, tuo piji, toreduje piji, tore epiji, tumanamage epiji, tuduiemage epiji dukeje imodukare erduwado imeardae remawuji. ");
INSERT INTO bor_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Imeartoru kurire Iogwa Kurireuji dukodire boe erdu pegare i, emode iwido. Boe etaidumode tuwo tumeartorudo imeardaeji dukeje ewo tudo turugadu tuwiwo nono iwimode dumogadure. Emodukare tudo turugadu tuwiwo nono iwimode dumogadure dukeje imodukare erduwado imeardae remawuji. ");
INSERT INTO bor_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Boe emode ia tuwai towuje dukeje boe emode tumeardae pemegareu tawuje tuiorduwawo nuba turomode tuwo tugeragu boe jamedu boeji tuwo nou tuwai pemegado. Etaiwomode to diero kurimode dubagai tuwo akirodo boe jamedu boeji tuwo tuwai iado. ");
INSERT INTO bor_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Emodukare tumeardae pemegado dukeje eromode ta je to diero akedure duji rugadu dukodire emodukare tuwai iado. Nono boe egokodumode ei. ");
INSERT INTO bor_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Egomode aino: “Akare awai iado. Ameardae pegare kodi.” Ainore egomode. ");
INSERT INTO bor_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","– Ča ia bakaru reo pugeje. Ia boe eimijera o tugobaigarege enodo padure dez mil. Mare nou turugodumode jiwu boe eimijera o tugobaigarege enodo padure vinte mil. Dukodire nou boe eimijera urugodumodukare nouia boe eimijeraji kuri je. Umode tumeardae pemegareu tawuje. Jordumode nou to tugobaigarege eraga kodumode nou iage eraga kori duji. ");
INSERT INTO bor_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eragamodukare dukeje umode tuwadaru maku tudugarege etai ewo reko toro nou turugodumode jiwu boe eimijera bagai. Mare erugodukare pui raga dukodire makomode nou boe eimijeraji tumoduie iaboe pemegareu maku ai erugodukawo pui pugeje tuwo tumedagedo puče. ");
INSERT INTO bor_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","– Ča tarodo aino jamedu. Tagera ra tagoe jamedu boe piji tameartoruwo tu i. Nono imode tarduwado tameartoruwo imeardae jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesus makore pugeje: – Sal pemegare. Mare nou sal pegomode dukeje nou sal akedumode. Nono umodukare nono sal mogadure pugeje. ");
INSERT INTO bor_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dukodire boe eromodukare iaboeji nou sal tabo pugeje. Emode barigu. Mare sal remawu ji karega inagoino. Meartorure iwugeire inagoino ekawo tugera ra tumeartorure i dupiji rugadu. Tawiapaga pemegado awu iwadaruji tawo awu iwadaru metudo tagaora tada tameartoruwo ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ia meri keje Judeu doge etaidukare jiwuge boe etaregodure Jesus ae tuwiapagawo Jesus makore jiboeji. Imposto mori makudure aiwuge nure iage. Nou Judeu doge egore ro pegareuge uie iage. ");
INSERT INTO bor_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nono fariseu doge etaregodure jamedu. Jorduware Judeu doge eno bakaru jiwuge etaregodure jamedu. Emago pegare pu biagai nou Jesus rore aino nou boe dogei duji. Egore: – Awu Jesus imadure nou boe etaidukare jiwuge ro pegareugebo. Okwagere ebo jamedu. Nou ukare turugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dukodire Jesus readodure ia bakaruji ewiagai. Mare tuwo jebato toro Pao Kurireu meardae pemegareu jitu bagaire akoino, tuwo jebato nou boe eimijerage emeardae pegareu jitu bagaire akoino jamedu. ");
INSERT INTO bor_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Akore: – Ia tagi tagagu carneiro doge enodo padumode cem. Ia okwamode boeto nou iage epiji dukeje tadumode rugadu nou noventa e nove carneiro doge epiji tagaiwowo nou okware boetowu carneiro bagai rugadu. Nou noventa e nove carneiro doge tamode edudo tubaga tabo ia boebutu pemegareu keje. Nono tadumode tagaiwowo nou okware boetowu carneiro bagai jii toro tardure jitu ka. ");
INSERT INTO bor_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tardumode ji dukeje taegaregodumode tai rugadu. Tamode bu taganaura keje tawo reko tawai ka tuibagi pugeje. ");
INSERT INTO bor_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tagaregodumode apo tawai ka dukeje tamagomode tamedage ewagai tawo ewie tarduie okware boetowu carneiroji rugadu. Taegaregoduie tai. Tamoduie boe ewadae towuje ebo. Ainore tarore. Ainore boe erore rugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ča baru tadawuge erore nono nou taro mogadure jamedu. Mare carneiro doge ewagai karega eroino. Boe ero pemegamode dukeje baru tadawuge egaremode pudui. Ro pemegareuge emode noventa e nove dukeje baru tadawuge egaremode nou noventa e nove eiamedu boei. Mare ia ro pegareu umode mitotu je dukeje umode tugera ra turo pegareu piji turokawo aino nou turo pegareuji pugeje dukeje baru tadawuge egaregodumode pudui rugadu. Egaremode nou ure tugera ra turo pegareu pijiwuji nou noventa e nove ro pemegareuge eiamedu boe ekori. ");
INSERT INTO bor_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus mako kimore. Akore: – Ia aredu o diero tori rogu enodo padure dez. Ure nono prata mogadure dukodire mori kurire. Mare akore ia okwaie tubiji. Nuba tameardaere nou aredu romode? Umode jorugu pemegado tuwai ja tada. Umode vassoura reko tuwai ja otoji. Aiwo pemegamode tuwai ja otoji jii toro tuiordure nou diero tori jitu ka. ");
INSERT INTO bor_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ča jordure ji dukeje makomode tumedage areme ewagai ewo bato pui pudae. Etaregodure pudae dukeje makomode ei. Akore: “Iagarere i rugadu iordure čewu ino diero tori rogu okware ipijiwuji. Pawaduwo rugadu.” Ainore nou aredu akomode tumedage aremei. ");
INSERT INTO bor_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pao Kurireu utugarege baru tadawuge egaremode pudui jamedu nono nou aredu jakare moga pudui dumogadure. Mare diero remawu ji karega egaremode. Ure tugera ra turo pegareu pijiwu jire egaregodumode. Ia ro pegareu umode tugera ra turo pegareu piji turokawo nono nou turo mogadure pugeje dukeje Pao Kurireu utugarege baru tadawuge egaregodumode pudui nou inoduji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus readodure ia bakaruji pugeje tuwo jebato toro nouia Pao Kurireu meardaeji boe ewiagai. Akore: – Ia imedu orere pobe. Iparere emage. ");
INSERT INTO bor_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naregedu boigoduwu aidukare tubagawo tuo bimodedu bagai, aidure tuo oe kadoduwo puiato makuduwo pudai. Nou naregedu boigoduwu aidure makudumode pudaiwu tuo oeji kuri je. Makore tuoji. Akore: “Iogwa. Itaidukare ipagawo awimode du bagai nou akoe makuduwo čenai. Itaidure awo čeno diero kado puiato awo ino maku inai kuri je.” Ainore nou onaregedu boigoduwu akore tuoji. ");
INSERT INTO bor_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dukodire uo ure to diero kado puiato ei. Ure maku tore pobedu doge etai rugadu. Nono nou onaregedu boigoduwu ure tugeragu nou dieroji. Dukeje čare uture pugeje nou diero tabo. Utu jaere toro ia moto ka. Nono ure nou to diero rugadu akedudo boe pega boeto. ");
INSERT INTO bor_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Dukodi čare ure to diero rugadu akedudo. Nono ča nou joruji boe pegare boe eiamedu boei. Bubutu bokware dukodire boe eke bokware. Dukodire nou iparedu uke boeire ji o diero akedure dukodi. ");
INSERT INTO bor_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nono nou iparedu okwamagudure ia oe kurireu imeduji tumaragoduwo ai. Nono nou oe kurireu imedu ure nou iparedu maragodae maku ai jetuwo jugureugei uwo nou jugureuge enogwagedo. ");
INSERT INTO bor_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nono nou iparedu maragodure nono nou oe kurireu imedu ai rugadu. Ure jugureuge eke maku etai tu tu je. Mare aidure tuwo jugureuge eke kowuje tuge boe koia. Mare nou oe kurireu imedu aidukare uwo ko jugureugebo. ");
INSERT INTO bor_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Toro ia meri keje čare nou iparedu biagorore turo pegareuji. Makore tudada. Akore: “Iragojemode woe iwimode ike boe koia. Mare iogwa uwai keje iogwa utugarege eke makare rugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Imode ikirimi iogwa uwai ka. Imagomode ji ie iwarigu boeto. Iro pegaie Pao Kurireuji rugadu. Iro pegaie ji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dukodire ukare turugadu onaregeduwo imi pugeje. Nono utugare rumode imi rugadu. Imaragodumode ai rugadu. Ainore inagomode iogwaji rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","– Ainore nou iparedu akore tudada. Dukeje čare ure tudawuje nou boe piji tuduwo toro tuo uwai ka rugadu. Ča uo jordu jaere tonaregedu iparedu puredugodure pudae duji. Nono okudugodure nou tonaregedu apo rugadu. Rekodure tiagare tabo nou tonaregedu togi. Nono ure tona bu kajeje. ");
INSERT INTO bor_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nono nou iparedu makore tuoji. Akore: “Ire iwarigu boeto. Iro pegare Pao kurireuji. Iro pegare ai jamedu. Dukodire ukare turugadu akanaregeduwo imi pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","– Mare nou uo biapagakare nou tonaregedu bataruji. Makore tudugarege ewagai. Makore ei. Akore: “Tageragu ia areia pemegareuji. Mato tabo tawo tugu awu itonaregeduji. Ia ieratadau tugu ierakoto jamedu. Ia bure okeakejewu tugu bureto jamedu. ");
INSERT INTO bor_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tapira kareu bito pagwagewo, pawaduwo, paegarewo pai, itonaregedu ure tugirimi kodi. ");
INSERT INTO bor_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Imeardaere bie kodi. Mare awu meriji čare iorduware bikaie duji. Itonaregedu uture ipiji nono imeardaere umodukaie tugirimi pugeje duji, mare awu meriji aregodure tuibagi iwai ka pugeje.” – Nono ewadure tiagarere pudui dutabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","– Mare nou onaregedu boetojiwu rakojere toro ipoguru keje tumaragodu tabo. Jorduwakare tuwie aregodure duji. Nono ure tugirimi tuibagi tuo uwai ka. Mare puredugodure tuo uwai ka dukeje meardure boe eraji, boe enogwariji toro tuo uwai keje. ");
INSERT INTO bor_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dukodire unaragodure tudugaregei. Akore: “Kaba kodiba boe egoino tiagarere pudui dutabo?” ");
INSERT INTO bor_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","– Nou utugare akore: “Awie ure tugirimi. Aregodure pugeje. Aregodu pegakare dukodire ao ure tapira kareu bito boe ewaduwo ia tuwadaeji.” ");
INSERT INTO bor_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","– Nou naregedu boetojiwu korigodure. Korigodure rugadu dukodire ukare turemo nou tuo uwaito ewadae ka boe kori koia. Dukodire uo ure tie bu toro tonaregedu boetojiwu ae togwamaguduwo ji uwo turemo tuwaito. ");
INSERT INTO bor_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mare nou onaregedu boetojiwu mako rakare tuoji. Akore: “Imaragodu rakare akai marigudu. Irore nono atugarege ero mogadure rugadu. Imeartorure amagore i jamedu boeji. Mare akare iaboe maku inai. Akare ia cabrito rogu maku inai iwo iwadae towuje imedagebo. ");
INSERT INTO bor_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aino čare nou akanaregedu boigoduwu ro pegare, ure ako diero rugadu maku areme pegareuge etai pagatu je. Mare aregodure tuibagi mato pugeje dukeje are ia tapira kareu bito boe ewaduwo aregodure dukodi. Ukare turugadu!” ");
INSERT INTO bor_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","– Nono uo makore nou tonaregedu boetojiwuji. Akore: “Boro. Akagore aino du ukare turugadu. Itonaregedu nure aki. Atukare ipiji. Aragoje pemegare woe itabo jii aino. Ire inoe jamedu boe maku akai marigudu akoče. ");
INSERT INTO bor_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mare awu awie ča imeardaere bire marigudu. Mare bikare rabodu. Aregodure pugeje rugadu. Dukodi čare pawaduwo paegarewo pai ji rugadu. Ure tuwarigu boeto mare aino ča boe erdure ji pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus makore ture jorduwadowugei. Akore: – Ia imedu oe kurireu utugare jeture nou tugimijera oe jamedu boeji. Mare jetu pemegakare ji. Dukodire ia boe ereadodure nou imedu oe kurireu biagai nou utugare ro pegare jiboeji uie nou tugimijera o diero akedudo boe pegareuto paga tu je. ");
INSERT INTO bor_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dukodire nou imedu oe kurireu makore nou tudugare bagai. Makore ji: “Boe ere iwie arore jiboeji. Dukodire aetumodukare inoe boeji pugeje. Nou inoe mori padure kejewu bapera jamedu boe maku inai iwo ia itugare jetudo ji pugeje.” ");
INSERT INTO bor_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","– Dukodire nou utugare uture nou bapera jamedu boe bagai. Mare meardaere tu tudada. Akore: “Ikimijera unure itawuje imaragodae piji. Nuba iromode imaragoduwo pugeje? Iraga bokware imaragoduwo iwo boepa butudo ia boe etai. Ipogurure dukodire inogwamagudumodukare ia boei eke kobo rogu bagai ikeje. Nuba iromode? ");
INSERT INTO bor_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","5","Ča iorduware. Imagomode nou ukare toe morido ikimijera aiwuge ewagai. Imode nou ere tugeragu ikimijera pijiboe mori kado tu tu puiato. Dukodire nou boe ewiagodumodukare ipiji. Imedage mode emage.” Ainore nou imedu oe kurireu utugare meardaere tudada. Dukodire makore nou ukare toe moridowu tugimijera aiwuge eiamedu boe ewagai. Unarare nou aregodure boetojiwuji. Akore: “Are akirodo ikimijera pijiboe akare morido raga. Nuba nou jetu kimore akaboboe mori oto padu kejeboere?” ");
INSERT INTO bor_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","– Nou imedu akore: “Tambor oto padure cem azeite kuru tabo iwo maku nou akimijera ai.” – Mare nou utugare akore: “Uu. Ainore ure woe awu bapera keje jamedu. Mare akaiwodo. Pamodukare morido cem pugeje. Pawo udo cinquenta ai pugeje awu bapera keje.” – Dukodire padure nou bapera keje nou imedu umoduie maku aiwu tambor oto padure cinquenta tu rugadu azeite kuru tabo. Ainore nou utugare ure nou imedu jakaredo pudui mare ukimijera jorduwakare nou tudugare rore aino pudui duji. ");
INSERT INTO bor_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","– Nono nou utugare makore nouia imeduji. Akore: “Are akirodo ikimijera pijiboe akare morido raga. Nuba nou jetu kimore akaboboe mori oto padu kejeboere?” – Nou imedu akore: “Trigo oto padure 25 mil quilos iwo maku akimijera ai.” – Nono nou utugare ure tugeragu nou imedu o baperaji jamedu. Akore: “Ča. Pawo oto padudo vinte mil quilos tu rugadu awo maku ikimijera ai.” ");
INSERT INTO bor_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","– Nou oe kurireu imedu jorduwagodure nou tudugare rore aino pudui duji dukejere mako pemegare nou tudugare rore jiboeji. Akore jeroreu nuie ema. Jesus mako kimore ture jorduwadowugei. Akore: – Imode tawie. Meartorure Pao Kurireu jiwuge emodukare jeroreugedo pudumi. Mare meartorukare Pao Kurireu jiwuge ere jeroreugedo pudumi tu tu je emode tuiorduwa jetorodo nuba turowo taidure jiboe bagai. ");
INSERT INTO bor_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","– Ča iwo tarduwado. Tameardaekaba tawo tago diero kurido. Mare tago diero maku, tagoe maku jamedu boe etai tamedagewo emage. Awu moto kejewu tagoe rugadu boe akedumode. Mare baru tadare tamugu pemegamode jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Boe etu pemegamode iaboe roguji dukeje etu pemegamode iaboe kurireuji jamedu. Mare boe eiwogumode iaboe roguji dukeje eiwogumode iaboe kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Taetu pemegamodukare moto kejewu boe enoeji dukeje Pao Kurireu umodukare taetudo baru tadawu boe remawu boeji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Taetu pemegamodukare ia boe enoeji dukeje Pao Kurireu umodukare ia baru tadawu tagoe remawu maku tagai. ");
INSERT INTO bor_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ia imedu ukimijerage emode pobe dukeje meardu kurimode nouia tugimijeraji. Mare jordu pegamode nouia tugimijeraji. Meartorumode nouia tugimijera bataruji. Mare meartoru bokwamode nouia tugimijera bataruji. Dukodire boe emode tugimijerado dieroče dukeje ewiapagamodukare tumeartoruwo Pao Kurireuji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ia fariseu doge emeardure Jesus akore aino duji. Emeardu kurire dieroji rugadu. Dukodire egokodure Jesus akore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mare Jesus makore ei. Akore: – Tare taro pemegado boe egai. Mare Pao Kurireu jorduware tameardae pegare tadada duji. Jorduware tagaidukare pudui duji. Tagaidure tu dieroji. Kočare boe etaidu kurimode Pao Kurireu jordu pegare jiwu boe ero pegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","– Moisés ure Pao Kurireu bataru maku Judeu doge etai eno bakaruwo ema boe emeartoruwo tu ji. Makore Pao Kurireu bataru jiwuge ere Pao Kurireu bataru bu bapera keje boe emeartoruwo ji. Boe emeartoruwo nou bataru jamedu boeji jii toro João Batista aregodure du ka. João Batista aregodure dukeje ure boe ewie ia Pao Kurireu bataru pemegareuji. Makore boe eimijera kurireu moduie Pao Kurireuče rugadu. Dukodire nou aidure nou bataru pemegareu jiwuge eiamedu boe ere turagado pudui tuwo tugimijerado tu Pao Kurireuče rugadu. ");
INSERT INTO bor_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moto, baru akedumode mare Pao Kurireu makore jiboe akedumodukare rugadu jii toro rugadu. Pao Kurireu makore jiboe jamedu boe jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ča iwo tawie Pao Kurireu meardae remawuji. Imedu umode tugera ra toreduje piji mare mugumode ia aredu apo pugeje. Du pegare Pao Kurireu jakai rugadu. Nou imedu ro peganure nou toreduje boetojiwudoji rugadu. Ure tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai. Ainore Pao Kurireu meardaere. Aredu umode tugera ra toredu piji dukeje ia imedu mugumode nou aredu apo pugeje. Du pegare Pao Kurireu jakai jamedu. Nou mugure nou aredu apowu imedu ure tudo nono jeribarire toreduje pijiwu mogadure Pao Kurireu jakai jamedu. Ainore Pao Kurireu meardaere. ");
INSERT INTO bor_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus mako kimore boei: – Marigudu ia imedu oe kurire. Ukudau areia mori kurire. Uwai kurire. Oe kurire rugadu. Iaboe iaboe bokwakare ai meri jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ia marenaru imedu rakojere nou boe keje jamedu. Iere Lázaro. Nou Lázaro biri jamedu boe pegare. Boe ere nou Lázaro reko tu tu je nou oe kurireu imedu uwai poro ka okwamaguduwo ia uke rogu bagai. ");
INSERT INTO bor_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Meardaere tumoduie tugeragu nou buture moto kejewu ia boe eke roguji nono nou oe kurireu imedu uwai tada. Ariga doge etaregodure tu tu nou Lázaro ae tuwo tugeru reko nou Lázaro biri pegareu jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ia meri keje nou marenaru imedu Lázaro bire rugadu. Pao Kurireu utugarege baru tadawuge ere nou Lázaro reko toro baruto muguwo Abraão apo okwagewo nono jii toro tuguredu ka. Nono nou imedu oe kurireu bire jamedu. Boe ere nou imedu oe kurireu tugu mototo. ");
INSERT INTO bor_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Čare rakojere bireuge eda pegareu keje. Nonore joru ure nou oe kurireu imedu korido rugadu. Dukejere aiwore toro. Jordure Abraãoji toro baru tada. Jordure nou marenaru imedu Lazaruji jamedu Abraão apo. ");
INSERT INTO bor_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dukodire makogodure toro etae. Akore: “Iogwa Abraão! Akogududo itabo! Nou imedu Lázaro arego mato itae uwo tugerako tugu poboto tuwo reko ikeruji boeru akeduwo ikeru piji. Awu joru unure ikowu rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","– Mare Abraão akore: “Kočare. Awikare dukeje akoe kurire, boe pemegareboe kurire awai tada. Mare boe pegare awu Lazaruji rugadu. Mare aino čare boe pemegare awu Lazaruji rugadu mare boe pegare ai, joru unure akowu. ");
INSERT INTO bor_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Čare iaboe ure nono moto poro kurireu mogadure. Padure nono pagaiadada. Dukodire taroiwakare tagurugoduwo mato nou moto poro kurireu kajeje. Dukodire tagurugodumodukare mato rugadu. Čeroiwakare čegurugoduwo kajeje toro tagae jamedu.” ");
INSERT INTO bor_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","– Dukodire nou oe kurireu imedu akore: “Iogwa Abraão! Inogwamagudunure ai rugadu. Nou imedu Lázaro jewodudo pugeje utuwo tuibagi iogwa uwai ka uwo iwie mage ewie. Iwie magere ikera aboudure. Nou Lázaro utudo toro ewagai tuwo ewie boe pegaie woe duji. Emeartoruwo tu Pao Kurireuji etukawo mato awu joru ka jorukawo ekowu nono boe moga idu mogadure.” ");
INSERT INTO bor_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","– Mare Abraão akore: “Moisés makore jiwu Pao Kurireu bataru padure bapera keje. Nou iage makore Pao Kurireu bataru jiwuge ewadaru padure bapera keje jamedu. Awie mage etaiwowo nou baperaji tuiorduwawo boe pegamode pudui duji. Emeartoruwo nou Pao Kurireu bataruji etukawo nou boe pegareu ka.” ");
INSERT INTO bor_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","– Mare nou oe kurireu imedu akore: “Ukare turugadu. Emeartorumodukare nou bapera kejewu bataruji. Mare ia boe jewodumode pugeje tuduwo etae tuwo ewie dukeje emeartorumode, emode tugera ra turo pegareu piji.” ");
INSERT INTO bor_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","– Mare Abraão akore: “Ewiapagamodukare Moisés makore jiwu Pao Kurireu bataruji. Ewiapagamodukare nou iage emagore Pao Kurireu bataru jiwuge ewadaruji dukeje, ewiapagamodukare ia jewodureu imedu bataruji jamedu. Emeartorumodukare ji rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus makore ture jorduwadowugei. Akore: – Boe emode turokogado boei tuwo tumeardae pegareu maku boe etai tu tu je emeardae pegawo ero pegawo jamedu. Mare boe pegamode rugadu nou ure tumeardae pegareu maku boe etaiwugei rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Boe emode tori kurireu kogudo ia boe ekidoru kajeje tuwo ewarigu poboto dukodire ewimode. Mare ia boe umode nou itore meartorure maibari iwuge edo tugera ra ipiji ero pegawo pugeje dukeje boe pegamode nou ure nou boe etore etaora pegadowuji rugadu. Jire boe pegareu kodumode nou barigudure pobo towuge ekori. ");
INSERT INTO bor_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taeku jado tarore jiboeji. Mare ia tawobe ro pegare dukeje tamagodo ji rokawo aino pugeje. Mare kiarigodumodukare nou turo pegareuji dukeje umodukare tugera ra turo pegareu piji rugadu. Mare kiarigodumode nou turo pegareuji dukeje makomode turomodukaie aino pugeje. Nono tagogudugo apo. Tawiago nou ro pegare dupiji. ");
INSERT INTO bor_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ia meri keje ro pegamode tai nono aregodumode tagae tumagowo tai tagoguduwo pudabo, tawiagoduwo nou turo pegareu piji. Nono nou meriji rugadu ro pegare tai pugeje. Uture tagae pugeje tumagowo tai tawiagoduwo nou turo pegareu piji pugeje. Dukeje nou meriji rugadu ro pegare tai pugeje. Dukeje uture tagae pugeje tumagowo tai tawiagoduwo turo pegareu piji pugeje. Nono nou ro pegareu oto aregodumode sete ka nou meri keje rugadu dukeje tawiago nou ro pegareu boe piji. Ainore Jesus akore boe ewiagoduiago boe ero pegare emago pegare pudui dupiji. ");
INSERT INTO bor_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nou Jesus ure jorduwadowuge emagore tugimijeraji. Utumode Jesus bataru tabowuge emode emage. Egore: – Čemeartoru kurido Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus akore: – Tameartoru biagamode Pao Kurireuji. Mare tamode taragado tai tameartoru rakawo tu jao. Nono tamagomode ia kodui iji uwo tudawuje tumuga piji tuguduwo toro pobo maereuto. Nono Pao Kurireu koiare umode nou kodui i meartorudo tawadaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesus mako kimore. Akore: – Boe utugare maragodure boepaji. Jeture boe egu ieji ipoguru keje jamedu. Dukeje aregodumode tuibagi tugimijera uwai ka mare okwagemodukare kuri je taregodu keje. ");
INSERT INTO bor_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ukimijera makomode ji tuge bagai. Dukodire umode tugimijera uke pemegado. Umode maku tugimijera ai. Ukimijera umode togwage iado dukeje makomode tudugareji okwagewo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Boe eimijera makomodukare nou tudugare pemegareuji tuwo timediado ema. Umodukare timediado ema rugadu. Mare utugare pemegareu meartorumode tu tugimijeraji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tarodo nono nou utugare pemegareu ro mogadure jamedu. Tameardaekaba tawo boe eimijerado tagi. Tameartorudo tu Pao Kurireu makore taiboe jamedu boeji dukeje tamagomode aino: “Boe eimijerawo imi kodi karega irore aino. Pao Kurireu utugare rogu nure imi. Ire irugadu imeartoruwo ji rugadu.” Tamagodo aino. Tameardaedo aino jamedu. ");
INSERT INTO bor_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus kodure Jerusalém ba kurireu kawu awaraji tuduwo Jerusalém ba kurireuto rugadu. Nou awara kodure Samaria moto okwaji Galiléia moto okwaji. Nou Samaria moto, nou Galiléia moto okwa jore pudodu oiagi nou awara kodure. ");
INSERT INTO bor_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesus puredugodure taregoduwo ia boe eda ka. Dukeje ia ime etaregodure Jesus togi. Nou ime enodo padure dez. Ekogodure. Nou ekogodae pegare ei rugadu. Ure ewiri pegado rugadu. Dukodire ekare tuburedo boei. Dukodire ekare tuburedo Jesusji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ere tumago pemegado toro Jesus ae. Egore: – Jesus! Čegimijera nure aki! Akogudugo čedabo awo čebemegago! ");
INSERT INTO bor_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus jordure ei. Nono makore toro etae. Akore: – Tadudo toro nou ure Judeu doge enomea maku Pao Kurireu aiwuge etae. Etaiwomode tai tuiorduwawo tabemegagodure dubagai. Ča eture. Ekodure awaraji dukeje epemegagodure tači je rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Nono ia jorduware tubemegagodure duji dukeje ure tugirimi pači tuibagi Jesus togi pugeje. Ure tumago pemegado boe eiamedu boe emearduwo tagoino duji. Mako pemegare Pao Kurireuji rugadu. Aregodure Jesus togi dukeje ure tubu jodo Jesus bure paru. Imadure Jesus apo rore aino pudui duji. Nou rore ainowu imedu boture Samaria moto keje. Samaria moto kejewu imedu nure ema. ");
INSERT INTO bor_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nono Jesus akore: – Ire pemegagodureuge ime enodo padure dez. Nou iage pa? ");
INSERT INTO bor_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tu nou boe tuginaiwu imedu ure tugirimi itae tumago pemegawo Pao Kurireuji. Kodiba nou iage erokare aino jamedu? ");
INSERT INTO bor_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nono Jesus makore nou imeduji. Akore: – Aragojedo. Ameartorure i dukodire ire apemegago. ");
INSERT INTO bor_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Ia fariseu imedu unarare Jesusji. Akore: – Kaba meri kejeba Pao Kurireu aregodumode turo pemegareu tabo boe eiamedu boe eimijerawo ema? Jesus akore: – Ča Pao Kurireu nure ema rugadu. Umode boe emeardae pemegado ewo tugimijerado Pao Kurireuče rugadu. Dukodire Pao Kurireu aregodumodukare nono ia boe erdu jiboe mogadure. Boe egomodukare: “Emareo, emariče”, aino. ");
INSERT INTO bor_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nono Jesus makore ture jorduwadowugei. Akore: – Ia meri keje tagaidumode tarduwo Pao Kurireu Onaregeduji mare tardumodukare ji rakojemode baru tada kodi. ");
INSERT INTO bor_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Boe egomode tai: “Emareo! Aregodu!” Mare tameartorukaba nou boe ewadaruji. Mare ia meri keje Imedu Onaregedu umode tugirimi pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aregodumode dukeje boe erdumode ji rugadu nono boe erdure boeiaraguduji dumogadure. Umode nono boeiaragudu rugu jo moga boeto dumogadure. ");
INSERT INTO bor_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mare aino boetoji boe ero pegamode ji, boe etaidumodukare ji, boe pegamode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","– Imedu Onaregedu aregodumode pugeje dukeje boe emeardaemode nono rakojere boe etumana Noé apowuge emeardae pegareuge emogadure. ");
INSERT INTO bor_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mariguduboe etumana Noé rakoje kimore dukeje boe ewiapagakare boeji. Ewiapagare tu tugeji tugudure čeboeji. Ime ewiapagare tu tuwirewo. Areme ewiapagare tu tugogewo jamedu. Erore aino jii toro Noé ure turemo ikarereu to du ka. Noé ure turemo ikarereuto tu tuwobebo rugadu. Emagere ere činorudo pobo piji. Mare iage ewiapagakare Noéji dukodire erduwa bokware pobo umode moto kejewuge eiamedu boe etagedudo duji. Dukodire nou pobo aregodure, ure eiamedu boe etagedudo rugadu. Ainore boe emeardaemode pugeje. Imedu Onaregedu aregodumode pugeje mare boe ewiapagamodukare bagai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaoboe etumana Ló rakoje kimore dukeje ainore nou rakojere apowuge boe erore jamedu. Eiamedu boe ewiapagare tu tugeji tugudure čeboeji. Ewiapagare tuwo akirodo boeji. Ewiapagare tuwo boe maku diero bagai. Ewiapagare tuwo boe tugu to boepato. Ewiapagare tuwo tuwai kurido. ");
INSERT INTO bor_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ló ure ewie boe pegareu butumoduie nou boe eda keje. Makore ei eregoduwo tuwai piji mare ewiapagakare bataruji. Nono Ló rekodure nou tuwai piji Sodoma ba kurireu piji rugadu. Nou meri keje rugadu joru buture baru piji Sodoma keje. Nou enxofre buture baru piji jamedu. Nou joru, nou enxofre ure nou Sodoma kejewuge eiamedu boe ewido. ");
INSERT INTO bor_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Imedu Onaregedu umode tugirimi moto ka pugeje dukeje ainore boemode boei jamedu. Mare boe ewiapagamodukare nou inodu bagai pugeje. ");
INSERT INTO bor_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","– Itaregodumode pugeje nono boe pegamode motoji rugadu. Nou meriji rugadu rakojere tuwai ao kejewuge eregoduwo tuwai piji tači je. Ekawo turemo tuwai jagi iaboe bagai. Nou maragodure to boepa jiwuge eregoduwo nou to boepa piji tači je jamedu. Ekawo tugirimi tuwai ka iaboe bagai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tawiabutudo Ló oreduje rore jiboe keje tarokawo aino. Uture Sodoma ba kurireu piji mare ure tuwuredo taiwowo tuibagi tuwai ka dukeje bire. ");
INSERT INTO bor_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ia boe etaidumode tuwo boe pemegado tu pudui turaga tabo dukeje eraga akedumode epiji rugadu. Egare remawu modukare. Emodukare činorudo bope doge eda kejewu joru pegareu piji rugadu. Mare iage ewiapagamodukare tumeardae pegareuji tuwo tugera ra turo pegareu piji taidure jiboe piji dukeje Pao Kurireu umode nou boe ekinorudo. Umode boe pemegado ei, umode egare remawudo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nou itaregodumode kejewu boečoji nudureuge emode pobe tubadure ira keje dutabo. Imode ikeragu iaji mare nou metia utumodukare. ");
INSERT INTO bor_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Areme emode pobe tumaragodae keje tuwo trigo kududo. Imode ikeragu iarodoji mare metago utumodukare. ");
INSERT INTO bor_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ime emode pobe ipoguru keje. Imode ikeragu iaji mare metia utumodukare. ");
INSERT INTO bor_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nou Jesus ure jorduwadowuge enarare ji. Egore: – Čegimijera. Kaiba aromode aino? Jesus akore: – Boe erdumode Imedu Onaregedu aregoduji nono boe erdure pobureuge ere tago puae tuge barogo bireu ka dumogadure. ");
INSERT INTO bor_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nono Jesus makore ture jorduwadowugei. Aidure tuwo erduwado emagowo baruto Pao Kurireu bagai tu tu je ekiarigodukawo jii toro rugadu. Dukodire makore ia bakaruji ewiagai. Mare bakaru remawu karega tuwo jebato toro ia Pao Kurireu meardae ka. ");
INSERT INTO bor_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akore: – Ia boe eda keje ia boe eimijera kurireu mugure. Emare umode ro pegareuge mori maku etai. Aiwore boe ero pegareu bagai tu tu je. Jordure boe ero pegareu jitu keje ure nou boe edo turo pegareu morido jamedu. Nou inodure maragodae rema. Mare nou boe eimijera meartoru bokware Pao Kurireuji. Meartoru bokware boei jamedu. Biapagakare boei jamedu. Dukodire maragodu pemegakare tumaragodaeji. ");
INSERT INTO bor_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nou boe eda keje ia aredu okoge bokwareudo rakojere jamedu. Ia boe ero pegare nou areduji dukodire nou aredu aregodure nou boe eimijera ae tumagowo ji uwo nou ro pegare puduiwuge edo turo pegareu morido. ");
INSERT INTO bor_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mare nou boe eimijera pegareu rokare iaboeji jii toro. Makokare iaboeji nou ro pegare nou aredu jiwugei. Mare nou aredu ukare togwa rawuje tumagore nou boe eimijera jitu piji. Aregodure ae tu tu je tumagowo ji uwo nou ro pegare puduiwuge edo turo pegareu morido. Dukodire toro ia meri keje nou boe eimijera makore tudada. Akore: “Ikare ioku kidugo Pao Kurireuji dukodire imeartoru bokware Pao Kurireuji. Imeartoru bokware boei. ");
INSERT INTO bor_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mare nou aredu ukare togwa rawuje idu piji rugadu. Nou aredu butugugodukare. Dukodire imode aidure jiboe towuje. Imodukare boe pemegado ai dukeje umodukare togwa ra ipiji rugadu tumagowo i dupiji. Mako raimode i rugadu. Ča imedugodure nou aredu makore i du boeji. Dukodire imode boe pemegado ai. Imode nou ro pegare jiwuge edo turo pegareu morido ai rugadu.” ");
INSERT INTO bor_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nono Jesus makore ture jorduwadowugei. Akore: – Tawiapagado nou boe eimijera pegareu bataruji. Pegare mare ro pemegare nou areduji. ");
INSERT INTO bor_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Mare Pao Kurireu pemegare dukodire ro pemegareu kodumode nou boe eimijera pegareu ro kori rugadu. Boečoji, meriji, boe enogwamagudumode Pao Kurireuji uwo tuginorudo ro pegare puduiwuge epiji dukeje umode tugera maku etai rugadu tuwo ekinorudo nou ro pegare puduiwuge epiji rugadu. Umodukare tumeardae raido tuwo tumeardae tawuje tuiorduwawo nuba turomode nou ro pegareugei duji. Aiwomode nou meartorure puduiwuge ereadodure jiboeji nono umode tumeardae tawuje kuri je rugadu. Mare Imedu Onaregedu aregodumode pugeje. Aregodumode dukeje romode aino rugadu. Nou meriji jordumode meartorukare puduiwugei. Emagamode moto keje rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus jorduware iagei enojarore pudui duji rugadu. Nou boe emeardaere turo jetoroie mare emeardae pegare iagei jamedu. Dukodire Jesus makore ia bakaruji nou boe ewiagai tuwo erduwado emeardaeji, tuwo erduwado pudui dubagai. ");
INSERT INTO bor_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Akore: – Imere pobe tudu tabo Pao Kurireu uwai ka tumagowo bagai baruto. Fariseure ia. Imposto mori makudure aiwu ro pegareu imedure ia. Nou fariseu očarore tuwadaruji rugadu. Meardaere tuiorduwaie Pao Kurireu bataruji, meardaere tugoduie Pao Kurireu bataru kodaji. Mare jorduwakare Pao Kurireu bataruji. Kodukare Pao Kurireu bataru kodaji. ");
INSERT INTO bor_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nono makore Pao Kurireuji turagoje tabo očarore tuwadaruji kodi. Rakojere boe egorai tumago tabo baruto tubaru tabo. Akore: “Iogwa, iagarere i imedu pemegareu nure imi kodi. Ikare nono awu imedu ro pegareu imposto mori makudure aiwu mogadure. Ro pegareu nure ema. Mare imi karega. Ikiwogukare. Iwadrarodukare. Ieribarikare imugure apowu aredu piji. Irore nono akaidure jiboe mogadure. ");
INSERT INTO bor_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Merire ikera aboudure i inogwagere dukeje. Merire pobe inogwagekare dukeje imago tabo baruto tu tu awagai. Ainore irore tu tu je. Ire ia ino diero maku akai tu tu je jamedu.” Ainore nou očarore tuwadaru jiwu imedu akore. ");
INSERT INTO bor_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","– Mare nou imposto makudure aiwu ro pegareu imedu jorduware tugiwogure boei duji. Jorduware tuwadrarodure boei duji. Kiarigodure turo pegareuji. Aidukare turo pegareuji pugeje dukodire pogurure tuwo tuburedo boei. Rakoje jaere nou boei. Pogurure taiwowo baruto. Dukodire makore baruto tie jo tabo Pao Kurireu bagai. Akore: “Iogwa Kurireu. Imedu ro pegareu nure imi rugadu. Dukodire iorduware aro pegamode i iro pegareu moriče rugadu. Mare inogwamagudunure ai akoguduwo itabo akawo iwarigu joru pegareuto.” Ainore nou ro pegareu imedu akore. ");
INSERT INTO bor_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nono Jesus ure tuwadaru iado. Akore: – Imagomode aino tai. Awu ro pegareu imedu makore turo pegareuji Pao Kurireu biagai dukodire emare ure tugirimi tuwai ka tubemegare Pao Kurireu jitu tabo. Dukodire Pao Kurireu pemegare ji jamedu. Mare čewu fariseu imedu makokare nono nou ro pegareu imedu mako mogadure. Nou fariseu meardaekare turo pegareuji. Akore tubemegaie mare Pao Kurireu jorduware pegare duji. Dukodire imagomode aino tai. Boe enojaromode pudui, emode tugimijerado pudumi tumeardae tabo dukeje Pao Kurireu umode epogurudo. Mare boe epogurumode turo pegareuji, emode boe utugaregedo pudumi dukeje Pao Kurireu umode boe pemegado ei, umode boe remawugedo emage. ");
INSERT INTO bor_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ia boe etaregodure torebo Jesus ae uwo tugera bu nou tore ewugeje. Mare Jesus ure jorduwadowuge erdure nou inodu jiboeji dukeje etaidukare eroino duji. Emagore ei etaregodukaiago torebo Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mare Jesus makore nou boe etorei rugadu. Akore: – Mato. Etaregodure dukeje Jesus makore nouia boei. Akore: – Tagaba tawu boe etore emeardae kajeje etaregoduwo itae. Etarego itae rugadu. Boe ewo tumeardae udo nono boe etore emeardae mogadure tuwo tugimijerado Pao Kurireuče rugadu turuduwo baruto. ");
INSERT INTO bor_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tawiagodukaba iwadaru piji. Boe etore emeartorure tuo tuje makore jiboeji. Mare boe etore ji karega inagoino. Boe emeartoruwo Pao Kurireu bataruji. Dujire inagoino. Boe emeartorumode Pao Kurireuji tuwo tugimijerado ema dukeje emugumode Pao Kurireu apo jamedu. Mare emeartorumodukare Pao Kurireuji dukeje emugumodukare Pao Kurireu apo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ia Judeu doge eimijera unarare Jesusji. Akore: – Čegimijera pemegareu nure aki. Nuba iromode iewoduwo pugeje imuguwo Pao Kurireu apo du akedukawo? ");
INSERT INTO bor_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","20","Jesus akore: – Ča akagore ipemegaie. Mare tu Pao Kurireure pemegare rugadu. Arduwa kana Pao Kurireu nuie imi rugadu? Aino čare ameardae pemegado ameartoruwo i rugadu. Marigudu arduware nou Pao Kurireu ure maku Judeu doge etaiwu bakaruji. Ure maku etai marigudu. Nou bakaru akore aeribarikaiago akoreduje piji, akaiago boe ewido, akiwogukaiago boei, awadrarodukaiago, ameartoruwo aoji ačeji. ");
INSERT INTO bor_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nono nou imedu akore: – Ikodu maidure dutabo imeartorure awu bataru jamedu boeji ji aino. ");
INSERT INTO bor_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nono Jesus akore: – Iaboe okwa kimore ameartoruwo ji jamedu. Akoe rugadu boe maku diero bagai. Nono nou ako diero rugadu maku marenarue doge etai. Dukeje Pao Kurireu umode akoe kurido baru tada. Aromode aino dukeje akaregodumode itae pugeje akoduwo itabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nou imedu meardure Jesus akore aino pudui duji dukeje kiarigodure rugadu. Oe kurire rugadu. Aidukare tuwo tugera ra nou toe jamedu boe piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Jesus jordure nou imedu kiarigodure duji dukodire akore: – Kočare boe rakare oe kurireu imeduji uwo tugimijerado tu Pao Kurireuče rugadu tumuguwo Pao Kurireu apo baru tada. Oe kurire dukodire biapagakare Pao Kurireuji. Boe rakare oe kurireu imeduji uwo tugimijerado tu Pao Kurireuče nono boe raka cameloji uwo turemo agulha poroto dumogadure. ");
INSERT INTO bor_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Boe emeardure nou Jesus bataruji dukeje enarare ji: – Mare ioguduba umode činorudo tuiewoduwo pugeje tumuguwo Pao Kurireu apo? ");
INSERT INTO bor_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nono Jesus akore: – Boe eroiwakare jiboe, Pao Kurireu roiware ji. ");
INSERT INTO bor_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nono Pedro makore Jesusji. Akore: – Čeiamedu boe čere čegera ra čenoe jamedu boe piji čegoduwo akabo. ");
INSERT INTO bor_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesus akore: – Uu. Boe jokodu jire inagoino tai. Boe emode tugera ra tuwai piji, toreduje piji, tuo piji tuje piji tumanamage epiji, tuwiemage epiji tuwo tugimijerado tu Pao Kurireuče tuwo boe emeartorudo Pao Kurireuji dukeje boe pemegareu makudumode etai eroino du moriče. Eture tuwai piji, toreduje piji, tumana mage epiji, tuo tuje epiji, tore epiji tumeartoruwo Pao Kurireuji. Dukodire nou mori kurimode eture pijiboe kori rugadu woe awu moto keje. Mare toro ia meri keje Pao Kurireu umode boe pemegareu kurido etai rugadu baru tada. Toro baru tadare emugumode rugadu, ewimodukare pugeje rugadu jii toro. ");
INSERT INTO bor_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","33","Ia meri keje Jesus makore tu nou ture jorduwadowugei. Akore: – Tawiapagado. Padurumode Jerusalém ba kurireu ka. Mariguduwuge makore Pao Kurireu bataru jiwuge ere Pao Kurireu meardae bu bapera keje. Egore imagudumoduie boe tuginaiwuge etai. Nou boe tuginaiwuge egorerumoduie i, erorerumoduie i, emoduie todoguru to i, emoduie boeto i, emoduie iwido. Mare merimoduie pobe metia bokware dukeje iewodumoduie pugeje. Ainore nou mariguduwuge makore Pao Kurireu bataru jiwuge egore. Pao Kurireu meardae jire egoino. Boemode aino i rugadu. Nou bataru jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mare nou ure jorduwadowuge erduwakare kaba jiba Jesus akoino. Erduwa bokware Jesus akoino jiboeji. Dukodire erduwakare rugadu. ");
INSERT INTO bor_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus aregodure Jericó ba kurireu ka dukeje ia joku bokwareu imedu mugure awara okwai togwamagudu tabo boei ia diero bagai, ia boe eke rogu bagai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Boe emagare tugodu tabo Jesus apo. Etaregodure dukeje nou joku bokwareu imedu meardure nou ewure akoji. Dukeje unarare ia imeduji. Akore: – Kaibowu boeba ekodure aino? Amagodo iwiagai. ");
INSERT INTO bor_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nou imedu akore: – Jesusre kodure aino woe. Nazaré ba kurireu kejewu nure ema. ");
INSERT INTO bor_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nono nou joku bokwareu imedu kudugodure Jesus rekodaji. Akore: – Jesus! Jesus! Mariguduwu Judeu doge eimijera kurireu Davi uwobe nure aki. Akogudugo itabo! ");
INSERT INTO bor_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ia boe emago pegare nou joku bokwareu imeduji mugu kiorowo. Mare ure tugudu rakado pugeje rugadu. Akore: – Jesus! Davi Onaregedu nure aki. Akogudugo itabo! ");
INSERT INTO bor_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Nono Jesus ure tuwuredo. Makore boei ewo nou joku bokwareu imedu reko pudae. Aregodure ae dukeje Jesus akore: – Kaba jiba akaidure irowo ai? Nou joku bokwareu imedu akore: – Ikimijera. Itaidure itaiwowo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus akore: – Ča akaiwodo. Ameartorure i dukodire apemegagodure. ");
INSERT INTO bor_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ča nou imedu joku bokwareu pemegagodure tači je rugadu. Aiwore pugeje rugadu. Dukodire nou imedu jakaregodu kuričigore pudui rugadu. Mako pemegare Pao Kurireuji rore aino pudui duji boe eiamedu boe ewiagai. Nono kodure Jesus rekodaji tagoino dutabo. Boe erdure Jesus rore aino duji dukodire nou boe emago pemegare Pao Kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus aregodure Jericó ba kurireu ka dukeje boe emagare tugodui rekodaji dutabo. ");
INSERT INTO bor_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ia imedu iere Zaqueu. Nou ure tugeragu imposto diero jiwuge eimijera nure ema. O diero kurire. Ure tugeragu boe eno imposto dieroji tuwo maku boe eimijera kurireu ai. ");
INSERT INTO bor_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nou Zaqueu aidure tuiorduwo Jesusji nou boe ekao. Mare roiwakare ričokare kodi. ");
INSERT INTO bor_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dukodire čare rekodure Jesus otodai nou boe etododai. Dukeje ruture ia kodui i ričoreuto tubagawo Jesus bagai nono. Meardaere taiwowo nou i piji toro moto ka. Jesus kodumode nono dukeje nou Zaqueu jordumode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ča Jesus kodure nono rugadu. Mare jorduware Zaqueu rakojere nou i tada duji rugadu dukodire ure tuwuredo nou i paru taiwo tabo nou Zaqueu bagai. Jordure Zaqueuji nono makore Zaqueu ieji. Akore: – Zaqueu. Arawuje nou i piji. Amara tabo. Awu meriji itaidure ipaduwo awai keje. ");
INSERT INTO bor_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dukodire Zaqueu ure turawuje tumara tabo. Nono uture Jesus apo tuwai ka tiegarere pudui dutabo. ");
INSERT INTO bor_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Boe eiamedu boe erdu pegare Jesus uture Zaqueu apo duji. Egore: – Jesus uture tubaduwo ia ro pegareu uwai keje. ");
INSERT INTO bor_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Toro nou Zaqueu uwai ja tada Zaqueu ure turagojedo. Nono makore Jesusji. Akore: – Ikimijera. Aino čare imode inoe kado puiato iwo ia maku marenarue doge etai. Ikiwogure jiwuge etaire imode makudu kurido pobe puibiji etai. ");
INSERT INTO bor_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Nono Jesus akore: – Awu meriji Pao Kurireu ure awu bai tadawuge ekinorudo ero pegareu boe piji. Mare paga karega awu meriji rugadu emeartorure Pao Kurireuji kodi nono nou mariguduwu etuo Abraão meartoru mogadure. Itaregodure iemaruwo ro pegareuge ewagai iwo etawuje ero pegareu boe piji iwo ekinorudo etukawo bope doge eda kejewu joru pegareu ka ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus kodure Jerusalém kawu awaraji rugadu. Jaekare Jerusalém ba kurireuji rugadu. Boe ekodure rekodaji tuwiapaga tabo Jesus akoino duji. Nou boe emeardaere Pao Kurireu umode boe eimijerado pudumi woe moto keje kuri je. Egore nou boe eimijera umoduie Jesusče rugadu. Mare Jesus makore nou boei. ");
INSERT INTO bor_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Akore: – Ia meri keje ia oe kurireu imedu ure tudo turugadu tudu jaewo rugadu toro ia moto tuginaiwu ka. Nou moto tuginaiwu boe eimijera kurireu makore nou oe kurireu imedu bagai tumagowo ji boe eimijerawo ema toro to moto keje. Nono nou oe kurireu imedu umode tugirimi mato to moto ka pugeje boe eimijerawo ema nono to moto keje. ");
INSERT INTO bor_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dukodire makore tudugarege ewagai. Enodo padure dez. Ure ia to diero tori kuieje maku eiamedu boe etai. Ure udo mito mito eiamedu boe etai. Makore ei. Akore: “Itu jaemode rugadu. Nou ire maku tagaiwu diero kurido tu tu je jii toro itaregodumode mato ibagi du ka.” Ainore nou boe eimijera makore tudugaregei. ");
INSERT INTO bor_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mare nou moto kejewu ia boe etaidukare nou oe kurireu imeduji. Etaidukare boe eimijerawo ema nono pudabo. Dukodire ere ia tumedage etudo toro nou moto tuginaiwu boe eimijera kurireu bagai tuwo bie taidukaie nou oe kurireu imeduji, taidukaie boe eimijerawo ema nono pudabo. ");
INSERT INTO bor_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","– Mare nou moto tuginaiwu boe eimijera kurireu aidure nou oe kurireu imeduji rugadu. Ure boe eimijerado ema rugadu. Nono nou oe kurireu imedu ure tugirimi tuibagi to moto ka pugeje boe eimijerawo pudumi nono to moto keje rugadu. Aregodure dukeje makore tudugarege eiamedu boe ewagai. Aidure tuiorduwawo nuba erore to diero jamedu boe tabo. ");
INSERT INTO bor_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Utugare boetojiwu aregodure tugimijera ae. Akore: “Ire ako diero mitodu rogu kurido pugeje. Nou diero rogu tabo imaragodure. Ire oto padudo dez.” Ainore nou utugare akore. ");
INSERT INTO bor_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nono nou boe eimijera akore: “Ure turugadu. Amaragodu pemegare inoe rogu boeji. Dukodi čare imode boe eimijerado aki jamedu. Akaiwomode jiwuge emugure kejewu boe eda oto padumode dez.” Ainore nou boe eimijera akore tudugare boetojiwuji. ");
INSERT INTO bor_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nono nouia utugare aregodure tugimijera ae. Akore: “Ire ako diero mitodu rogu kurido pugeje. Ire udo ikera aboudure.” Ainore nou utugare akore. ");
INSERT INTO bor_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nono nou boe eimijera akore: “Ure turugadu. Imode boe eimijerado aki jamedu. Akaiwomode jiwuge emugure kejewu boe eda umode ikera aboudure.” Ainore nou boe eimijera akore nou tudugareji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nono ia utugare aregodure tugimijera ae jamedu. Akore: “Ikimijera nure aki. Ikare ako diero rogu barigu. Ire biado boe epiji ia ikudau areia rogu tada. Ema reo. ");
INSERT INTO bor_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ipagudure ače. Are boe emaragodae rakado ei awo akoe kurido. Are boe emaragodu rakado ako boepaji. Emagere ere ako boepa pemegado mare akai rugadu. Are boe emaragodae rakado ei ako boepa tadaboe kadoduwo mare etai karega, akai rugadu.” Ainore nou utugare akore tugimijeraji. Mare pagare akoino. ");
INSERT INTO bor_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nono nou boe eimijera akore: “Aro pega. Iromode ai nono akago mogadure. Akagore ie amaragodae rakado ai. Akagore amaragodu rakaie ino boepaji dukodie inoe kurie. Kodire akire ameardae pegare i. ");
INSERT INTO bor_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kočare akare ino diero rogu tugu bancoto metu pemegawo nono banco tada, makagoduwo nono banco tada.” ");
INSERT INTO bor_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nono nou boe eimijera makore nouia tudugaregei. Akore: “Tageragu nou ino diero tori kuieje mitodu roguji nou imedu piji. Maku nouia itugare ai nou diero oto padure dez apowu ai.” Ainore nou boe eimijera akore. ");
INSERT INTO bor_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mare nou rakojere nonowuge egore: “Akaba maku ai. O diero tori kuieje kurire. Enodo padure dez.” Egore. ");
INSERT INTO bor_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mare nou boe eimijera makore ewadaru jipagi. Akore: “Boe makudumode nou maragodu pemegareuge etai. Mare nou maragodu pegareuge etaire boe makudumodukare rugadu. Nou maragodu pegareuge enoe rogu mode mare nou enoe rogu akedumode epiji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aino čare tageragu nou aidukare iwugei emagore boe ekimijera kurireuji taidukaie i woe pudabo tugimijerawo imi. Mato ebo itae tawo ewido woe. Emagore boe eimijera kurireuji taidukaie i. Emagore taidukaie tugimijerawo imi. Dukodire ewimode.” ");
INSERT INTO bor_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nou inodu otobiji Jesus uture nou Jerusalém ba kurireu kawu awaraji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Puredugodure boe eda Betfagé ka, boe eda Betânia ka jamedu. Nou boe eda mugu puredure Oliveira Tori Riji. Aregodure toro dukeje makore nou ture jorduwadowuge ime pobedu dogei tuwo etudo tododai. ");
INSERT INTO bor_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Akore ei: – Tadudo toro nou boe eda ka. Tagaregodumode toro dukeje tardumode ia jumenta onaregeduji boe ere kogudo nono duji. Ia boe ekare tumugudo nou jumenta onaregedu keje raga. Tamode bukigu kiwuje dukeje tadumode mato apo itae. ");
INSERT INTO bor_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ia boe enaramode nukodiba tarore aino dukeje tamagodo bataru jipagi: “Pagimijera aidure ji”, aino. ");
INSERT INTO bor_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nono nou ime pobedu doge eture toro nou boe eda ka rugadu. Erdure nou jumenta onaregeduji nono Jesus mako mogadure. ");
INSERT INTO bor_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ere kiwuje dukeje nou akure čewuge enarare ei. Egore: – Kaba kodiba taroino nou čenagu jumenta onaregeduji? ");
INSERT INTO bor_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Egore: – Pagimijera aidure ji. ");
INSERT INTO bor_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nono eture apo Jesus togi. Etaregodure Jesus ae dukeje ere tugudau areia cobertor boe bu nou jumenta naregedu poru keje Jesus uwo tumugudo keje. Nono ere tugera maku Jesus ai rutuwo nou jumenta naregedu ao ka. ");
INSERT INTO bor_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Nou jumenta naregedu boe korikare ji. Pagudu bokware rugadu. Jesus uture apo. Uture dukeje boe ere tugudau areia cobertor bu awaraji tuwo awara pemegado. Nou awara ure turawuje Oliveira Tori Ri piji. Kodure Jerusalém ba kurireu ka rugadu. Boe emagare rugadu tugodui Jesus apo. Eture tiegarere pudui dutabo rugadu. Egarere Jesus ro rakare jiboeji. Dukodire ewadodu rakare Pao Kurireu ie tabo tumago pemegare ji dutabo. ");
INSERT INTO bor_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Egore: – Pagimijera Kurireu reo. Pao Kurireu ure arego mato pagae. Ča Pao Kurireu uwo boe pemegado ji rugadu! Pao Kurireu uwo boe pemegado baru tadawugei rugadu. Boe eiamedu boe emago pemegawo pagimijeraji rugadu moto keje, baru tada jamedu. ");
INSERT INTO bor_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseu doge edure nono nou boebo jamedu mare emeardaekare nono nou boe emeardae mogadure. Egore Jesusji: – Amagodo nou merure akabowu boei edukiorowo. ");
INSERT INTO bor_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus makore ewadaru jipagi. Akore: – Nou boe egarere pudui kodire egoino tugudu tabo. Emagomodukare dukeje nou toriguru mako pemegamode Pao Kurireuji aino nou boe emugato. ");
INSERT INTO bor_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesus jordure Jerusalém ba kurireuji dukeje ure tuwuredo nono. Okudure nou Jerusalém ba kurireu kejewugebo dukodire ragudure. ");
INSERT INTO bor_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akore: – Jerusalém ba kurireu kejewuge nure tagi. Kočare awu meriji umode boe ekinorudowu aregodure tagae mare tameartorukare ji dukodire tarduwakare tabemegawo pui, Pao Kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ia meri keje jordu pegare taiwuge emode taiado tagabo dukeje emode tubodo tagabo jiče woje. ");
INSERT INTO bor_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Emode tabegado. Emode tagore erugadu etagedudo. Nono emode tawai rugadu boe butudo jamedu. Mare paga karega. Pao Kurireu ure umode boe ekinorudowu arego tawagai tuwo taginorudo taro pegareu piji mare tameartorukare ji dukodire boe pegamode aino tai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus aregodure Jerusalém ba kurireu ka dukeje ure turemo Pao Kurireu uwaito. Nono jordure nou boei ere toe maku diero bagai duji ere morido puai duji ere tagu ie maku diero bagai duji. Dukodire korigodure. Ure nou boe enoe rugadu barigu. Ure nou boe etudo Pao Kurireu uwai piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesus akore: – Pao Kurireu uwai tadare boe emagomode bagai baruto. Ainore Pao Kurireu akore. Ainore nou bapera atugo ure. Mare tare awu Pao Kurireu uwai udo nono iwogu kigodureuge ewaire. ");
INSERT INTO bor_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Meri jameduji Jesus ure boe erduwado Pao Kurireu uwai tada. Mare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware nou Judeu doge eno bakaru jiwuge eimijerage, nou ba kurireu tadawu boe eimijerage eiamedu boe ere bato pui tumagowo pui nuba turowo Jesusji. Etaidure tuwo bito mare eroiwakare ji. Mare paga karega. Boe emagare tu tu je tuwiapaga tabo Jesus bataruji. Boe etaidure tumearduwo Jesus makore jiboeji. Dukodire nou boe eimijerage eroiwakare tuwo tugeragu Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ia meri keje Jesus rakojere Pao Kurireu uwai tada tuwo boe erduwado Pao Kurireu bataru pemegareuji tuwo boe emeartorudo pudui. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge eimijerage, nouia Judeu doge eimijerage etaregodure Jesus ae. ");
INSERT INTO bor_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Emagore Jesusji. Egore: – Amagodo čei. Ioguduba koiare ure turaga maku akai aro rakawo aino? ");
INSERT INTO bor_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Jesus akore: – Imi jamedu inaramode tai. Ioguduba ure João Batista udo boe etao pegodo? Pao Kurireu koia kana? Ia boe koia kana? ");
INSERT INTO bor_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mare nou boe eimijerage erduwakare tumagowo Jesus bataru jipagi. Dukodire emagore pui nuba tagomode Jesus bataru jipagi. Egore: – Pagagomode Pao Kurireu koiaie ure João Batista udo boe etao pegodo mare pameartorukare nou inoduji. Awu Jesus jorduware pameartorukare nou inodu jituji. Du inodu tabo pagagomode aino dukeje Jesus umode pabogurudo. Akomode: “Kodiba tameartorukare ji?” Ainore akomode pai. ");
INSERT INTO bor_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mare pagagomode boe eigoiaie dukeje awu woewu boe ekorigodumode pai rugadu. Boe eiamedu boe emeartorure João Batista makore Pao Kurireu bataruji kodi. Egore Pao Kurireu koiaie ure João Batista udo boe etao pegodo rugadu. Du inodu tabo ekorigodumode pai. Eidomode tori tabo pai tuwo pawido rugadu. ");
INSERT INTO bor_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dukodire nou boe eimijerage emagore Jesusji. Egore: – Čerduwakare ioguduba ure João Batista udo boe etao pegodo. ");
INSERT INTO bor_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nono Jesus makore ei. Akore: – Tamagokare iwadaru jipagi dukodire imagomodukare ioguduba ure itarego mato jamedu. ");
INSERT INTO bor_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nono Jesus makore ia bakaruji nou boe ewiagai tuwo jebato toro Pao Kurireu meardae ka. Akore: – Ia imedu ure uva tugu to boepato. Nono ure tugeragu ia boei tuwo etudo nou to boepaji emaragoduwo ji. Nono nou ore boepa čewu uture epiji tugiriaduwo. Boe raire ji nou tugiriadu tabo. ");
INSERT INTO bor_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nou boepa tadawu uva kurodumode kejewu ari puredugodure pudui dukeje nou ore boepa čewu ure ia tudugare utudo toro nou jeture to boepa jiwuge etae nou tugiriadure jiwu moto piji. Ure nou tudugare utudo uwo tugeragu nou makudumode pudaiwu boeji. Nou jeture nou boepa jiwuge emode uva rugadu kado dukeje emode ia kado puiato nou ore boepa čewu imedu ai. Ča nou utugare aregodure nou boepa ka. Mare nou jeture boepa jiwuge etaidukare tuwo uva kado puiato pugeje nou ore boepa čewu ai. Dukodire ere tugeragu nou imedu utugareji. Ere boeto ji. Ere utudo tuibagi tugera kedo tabo. ");
INSERT INTO bor_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dukeje nou ore boepa čewu ure ia tudugare utudo etae toro pugeje. Mare nou jeture boepa jiwuge ere boeto ji jamedu. Ere udo tugirimi tugera kedo tabo. ");
INSERT INTO bor_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dukejere nou ore boepa čewu ure ia tudugare utudo etae pugeje. Mare ere boeto ji dukeje ere barigu toro tubiji. ");
INSERT INTO bor_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nono nou ore boepa čewu makore tudada. Akore: “Imode imeardu kurire jiwu itonaregedu utudo etae toro. Jire emeartorumode.” ");
INSERT INTO bor_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","– Mare nou jeture boepa jiwuge erdure nou ore boepa čewu onaregedu kodure aino pudae duji dukeje emagore pui. Egore: “Awu ore boepa čewu onaregedu reo. Emare omode nou tuo oe jamedu boeče. Pawo bito pagowo awu uo o motoče.” ");
INSERT INTO bor_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","16","– Dukeje nou jeture boepa jiwuge ere nou ore boepa čewu onaregedu barigu boepa piji. Ere bito toro rugadu. Ainore erore. Ča. Nuba nou ore boepa čewu romode nou jeture boepa jiwugei? Aregodumode etae. Umode ewido. Nono umode to boepa maku ia ime etai pugeje etuwo ji. Ainore Jesus akore. Mare ia boe etaidukare nou ure tuwie jiwu bakaruji. Egore: – Boro. Nou ore boepa čewu romodukare aino. ");
INSERT INTO bor_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","18","Nono Jesus aiwore tu nou boei. Dukejere akore: – Ainore nou padure bapera kejewu Pao Kurireu bataru ure marigudu. Akore: “Boe emeardae pegare toriji. Egore pegaie tuwo tuwaido ema. Mare nou tori pemegareu ure turugadu boe ewo tuwaido tabo rugadu.” Ainore nou batarure. Mare tori ji karega akoino. Umode boe ekinorudowu imedu jire Pao Kurireu akoino. Nou umode boe ekinorudowu romode boei nono ia boe ewudure kejewu tori ro mogadure. Buture tori aogejewuge eiamedu boe emode togorido. Mare tori ji karega inagoino. Nou umode boe ekinorudowu umode meartorukare puduiwuge erugadu boe epegado. Dujire inagoino. Nou umode boe ekinorudowu romode boei nono ia buture boe ewugejewu tori ro mogadure jamedu. Tori butumode boe ewugeje dukeje umode nou boe egugudo. Mare tori ji karega inagoino. Nou umode boe ekinorudowu umode boe pegado nou meartorukare puduiwuge eiamedu boei. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nou jorduware Judeu doge eno bakaru jiwuge eimijerage erduware puduie Jesus akoino duji. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage erduware puduie Jesus akoino jamedu. Dukodire nou boe eimijerage pegareuge eiamedu boe etaidure tuwo tugeragu Jesusji tuwo tugu baičoreuto kuri je rugadu. Mare nouia boe etaidure Jesusji. Dukodire nou boe eimijerage epagudure, eroiwakare tuwo tugeragu Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nou boe eimijerage etaiwore ia Jesus ro pegareu bagai rugadu. Ere ime etudo taiwo tabo Jesus ae ia Jesus bataru pegareu umode dubagai. Etaidure Jesus ro pegawo mako pegawo tuwo maku boe eimijera governador ai. Dukodire nou ime ere tudo nono ro pemegareuge mogadure mare pagare eroino. ");
INSERT INTO bor_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nono ia unaragodure Jesusji tuwo barigu boeto dubagai. Akore: – Boe eimijera nure aki. Boe jokodu jire akagore tu je. Arduware Pao Kurireu bataru remawuji. Are boe eiamedu boe erduwado rugadu Pao Kurireu bataruji rugadu. Ameardaere boei boe remawu tabo. ");
INSERT INTO bor_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ča amagodo čei. Nuba pago bakaru akomode paromode jiboeji? Pamode pagoe imposto mori maku Roma kejewu boe eimijera kurireu César ai na? Pamode maku kana? Pamodukare maku kana? ");
INSERT INTO bor_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Mare Jesus jorduware pagare egoino duji. Emeartorukare tuwadaruji rugadu. Dukodire makore ei. Akore: – Ia imposto morireu diero tori maku inai. Ere ia diero tori maku Jesus ai dukeje Jesus unarare ei. Akore: – Ioguduba je ba padure awu diero tori keje? Ioguduba ie ba padure awu diero tori keje? Nou boe egore: – Roma kejewu boe eimijera kurireu César iere padure keje. ");
INSERT INTO bor_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesus akore: – Boe rugadu. Čare awu César oeboe maku César ai. Mare Pao Kurireu oeboe maku Pao Kurireu ai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dukodi čare nou boe eimijerage pegareuge ekare Jesus udo tuwarigu boeto tagoino jiboeji. Dukodire eroiwakare tumago pegawo Jesus makore jiboeji boe ewiagai. Erore ta je akoino pudui duji. Dukodire emagokare pugeje. ");
INSERT INTO bor_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nono ia saduceu doge etaregodure Jesus ae tuwo Jesus barigu boeto tagoino dutabo jamedu. Nou saduceu doge emeartorukare boe eewodumode pugeje duji. Ča emagore Jesusji. ");
INSERT INTO bor_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Egore: – Jorduwareu imedu nure aki. Ča mariguduwu makore Pao Kurireu bataru jiwu Moisés ure jaoboe ero maku etai pameartoruwo ji jii aino. Moisés akore imedu bimoduie mare ore bokwaie dukeje nou imedu uwie muguwo nou tumana bireu oreduje apo torewo nou tumana bireu oreduje apo. ");
INSERT INTO bor_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ainore Moisés akore marigudu tuwo paro maku pagai. Ča ia meri keje ime enodo padure sete. Etumana etuwie mage nure pugi. Etumana mugure ia aredu apo. Čare bire. Mare ore bokware. ");
INSERT INTO bor_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dukodire nou uwie imedu mugure nou aredu apo. Mare nou imedu bire jamedu. ");
INSERT INTO bor_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nono uwie imedu mugure nou aredu apo jamedu. Mare bire jamedu. Nou uwie ime eiamedu boe emugure nou aredu apo. Mare eiamedu boe ewire. Etore bokware nou aredu apo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dukeje čare nou aredu bire jamedu. ");
INSERT INTO bor_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dukodire čedaidure čenarawo ai. Pao Kurireu umode erugadu boe eewodudo dukeje duboba mugumode nou aredu apo? Eiamedu boe emugure apo woe moto keje mare duboba mugumode nou aredu apo baru tada? ");
INSERT INTO bor_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus makore ei. Akore: – Boe emugumode puapo tu woe moto keje ");
INSERT INTO bor_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Meartorure Pao Kurireu jiwuge eewodumode pugeje dukeje emode nono Pao Kurireu utugarege baru tadawuge emogadure. Ewimodukare pugeje. Etuwiremodukare pugeje. Etugogemodukare pugeje. Pao Kurireu ore mode emage eewodure pugeje dukodi. ");
INSERT INTO bor_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés ure bu bapera kejewu Pao Kurireu bataru ure boe erduwado boe eewodumode pugeje duji. Pao Kurireu ure Moisés meardudo tuwadaruji ture iaboedo nono joru mogadure enado i piji. Dukejere Pao Kurireu makore Moisesji. Akore: “Abraão meartorure jiwu Pao Kurireu nure imi. Isaque meartorure jiwu Pao Kurireu nure imi. Jacó meartorure jiwu Pao Kurireu nure imi.” ");
INSERT INTO bor_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ainore Pao Kurireu akore. Mare nou Pao Kurireu akoino jiwu ime ewire marigudu. Mare Pao Kurireu makore emeartoruie pudui rugadu. Dukodire parduware eewodure pugeje duji. Bireuge emeartorumodukare Pao Kurireuji. Jewodureuge emeartorumode ji. Pao Kurireu umode meartorure puduiwuge eiamedu boe eewodudo pugeje rugadu. ");
INSERT INTO bor_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nono ia jorduware Judeu doge eno bakaru jiwuge eimijerage egore: – Boe jokodu jire akagoino. ");
INSERT INTO bor_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mare pagare egoino. Ča boe eraga bokware tunarawo Jesusji pugeje. Eraga bokware tuwo Jesus barigu boeto tagoino jiboe tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nono Jesus unarare nou boei. Akore: – Boere boe erduwado umode boe ekinorudowuji. Egore Davi onaregedu moduie ema. Mare erduwa pemegakare Pao Kurireu bataruji. ");
INSERT INTO bor_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Nou mariguduwu boe eimijera Davi ure ia Pao Kurireu bataru bu bapera keje. Akore: – Pao Kurireu makore nou ikimijera umode boe ekinorudowuji. Akore: “Amugudo woe ikana pemegareu jagwai jii toro imode nou jordu pegare aiwuge etagedudo du ka.” ");
INSERT INTO bor_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","– Tagoino dutabo Davi akore tugimijera nuie nou umode boe ekinorudowuče. Mare Davi onaregedu mode ema jamedu. Ča nuba nou umode boe ekinorudowu ure? ");
INSERT INTO bor_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Boe emagare nono tuwiapaga tabo Jesus bataruji. Nono Jesus ure ture jorduwadowuge erduwado. ");
INSERT INTO bor_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Akore: – Taeku jado jorduware Judeu doge eno bakaru jiwugei. Etaidure boe emeartoruwo tu pudui. Ere boe etaiwodo tugudau areia motureu meture pudui duji. Etaidure tuwo boe epogurudo. Etumode ba kurireu ka dukeje etaidure boe emago pemegawo pudui etaidure boe ekimijeragewo pudumi kodi. Dukodire erore aino. Nou jorduware Judeu doge eno bakaru jiwuge etumode Judeu doge ere bato puiwu bai ka dukeje emode tugeragu boe eimijera mugure kejewu iraji tumuguwo keje. Etumode boe ewadae ka dukeje etumode boe eke jeture kejewu ira ka boe etododai togwagewo boetoji. ");
INSERT INTO bor_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eragojemode boebo dukeje emago raimode baruto boe emearduwo tagoi tuwadaru motureu jituji. Mare pagatu je. Ekiwogure okoge bokwareuge aremei. Ere nou areme okoge bokwareuge ewai aru epiji. Dukodire Pao Kurireu ro pega kuričigomode ei rugadu nou ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus rakojere Pao Kurireu uwai ja tada taiwo tabo nou boei. Dukejere jordure nou oe kurireugei. Ere ia toe tugu ia ira jagi tuwo maku Pao Kurireu ai. ");
INSERT INTO bor_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dukejere jordure ia okoge bokwareudo areduji, marenaruji. Nou okoge bokwareudo ure to diero tori rogu pobedu tugu nou ira jagi. Toe mitodu rogu ure maku. ");
INSERT INTO bor_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nono Jesus akore: – Iwo tawie boe remawuji. Awu marenaru aredu okoge bokwareudo ure to diero jamedu boe maku dukodire ure to diero makudu kurido nou oe kurireuge eiamedu boe ekori. ");
INSERT INTO bor_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mare diero kurireu ji karega inagoino. Nou oe kurireuge ere to diero kurido Pao Kurireu ai mare etaidukare jiwu kobo rogure ere maku. Enoe kurire rugadu kimo. Mare awu aredu ure to diero rugadu boe maku. Dujire inagoino tai. ");
INSERT INTO bor_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ia Jesus ure jorduwadowuge emagore pui Pao Kurireu uwai jiboeji. Egore Pao Kurireu uwai motuie. Boe ere towuje tabowu tori motuie. Boe eie toe makudu kurido Pao Kurireu ai. Du paduie nono nou Pao Kurireu uwai ja tada. ");
INSERT INTO bor_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mare Jesus makore nou ture jorduwadowugei. Akore: – Moture mare ia meri keje ro pegareuge emode awu Pao Kurireu uwai butudo rugadu. Tori tabore pawobe ere towuje marigudu. Mare nou tori jamedu boe epadumodukare pu aogeje pugeje. ");
INSERT INTO bor_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nou Jesus ure jorduwadowuge enarare Jesusji. Egore: – Kaba meri kejeba Pao Kurireu uwai butumode? Kaba jiba čerdumode čerduwawo nou akagoino jiboe jetumode pudui kuri aino duji? ");
INSERT INTO bor_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus makore ei. Akore: – Taeku jado boe ekawo taekiripagado. Boe emagamode tuwadaru pegareu tabo. Egomode umode boe ekinorudowu nuie pudumi. Boe puredugoduie moto akeduwo. Mare pagare egoino. Mare du inodu tabo emode boe ekiripagado rugadu. Mare tameartorukaba ei. ");
INSERT INTO bor_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tameardumode bakaru pegareuji. Boe emode tawie boe erugoduie pui tuwaiga tabo. Erugodu akedukaie. Emoduie tugimijerage etawuje turaga tabo. Mare taragado tai tamororamagadukawo. Pao Kurireu jorduware ro pegareuge erugoduji marigudu. Umodukare nou erugodu tawuje epiji. Erugodumode pui tuwaiga tabo rugadu mare moto akedumodukare raga. ");
INSERT INTO bor_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesus mako kimore ei. Akore: – Boe eimijera kurireuge erugodumode pui tugobaigaregebo. ");
INSERT INTO bor_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Moto magadugodumode boe jamedu boe parugajeje. Boe eke bokwamode boe jamedu boe parugajeje. Dukodire boe ewimode tuge boei koia. Jorubo pegareu jetumode boei moto jamedu boe parugajeje. Boe erdumode boe pegareu boeji ure turawuje baru piji duji. ");
INSERT INTO bor_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mare ro pegareuge emode tugeragu tai. Emode boe pegado tai rugadu. Emode tamagu Judeu doge eimijerage etai. Nou boe eimijerage emode tarego Judeu doge ere bato puiwu bai ka taiwowo ia taro pegare jiboe bagai. Nono emode tadugu baičoreuto. Boe eimijera kurireuge emagomode tawagai jamedu tumago pegawo tarore jiboeji. ");
INSERT INTO bor_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dukejere tamagodo iwadaru pemegareuji ewadaru jipagi. ");
INSERT INTO bor_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mare tamororamagadukaba tamagore jiboe bagai. Tamagomode mare tawadaru karega. ");
INSERT INTO bor_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Imode iwadaru maku tagai tamagowo ewadaru jipagi. Dukodire nou boe eimijerage ero rakamodukare tai tawadaru jipagi pugeje. ");
INSERT INTO bor_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tawie mage emode tamagu boe eimijerage pegareuge etai. Taomage tajemage emode tamagu boe eimijerage pegareuge etai. Ia tawobe emode tamagu boe eimijerage pegareuge etai. Ia tamedage emode tamagu boe eimijerage pegareuge etai. Ia tagi tawidodumode rugadu. ");
INSERT INTO bor_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tameartorumode i dukodire boe eiamedu boe erdu pegamode tai. ");
INSERT INTO bor_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mare ietu pemegamode tai ia tagao iku butukawo tagaora piji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tagaba tagera ra tameartorure i dupiji dukeje imode taginorudo tawarigudukawo bope doge eda ka rugadu taruduwo baruto itae. ");
INSERT INTO bor_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesus makore kimo. Akore: – Tardumode tugobaigarege pegareuge ere taiado Jerusalém ba kurireu tabo duji dukeje tarduwamode boe akedumode kuri aino duji. ");
INSERT INTO bor_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Inure tawie. Boe erdumode nou inoduji dukeje Judéia moto kejewuge eregodu rakawo toro tori ao ka. Jerusalém ba kurireu tadawuge eregodu rakawo. Nou rakojere ipoguru kejewuge eregodu rakawo jamedu. Ekawo tugirimi tuwai ka iaboe bagai pugeje tuwo tuginorudo boe pegareu piji. ");
INSERT INTO bor_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nou meri keje boe pegamode boei rugadu ero pegareu moriče. Pao Kurireu ure boe ewie marigudu boe pegamoduie boei rugadu boe ero pegareu moriče. Aino makore jiboe jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nou meriji boe pegamode kuiarureugei rugadu. Boe pegamode ei rugadu eroiwamoka turegodu rakawo kodi. Boe pegamode etore kugure etuje magei jamedu eroiwamoka turegodu rakawo kodi. Boe pegamode awu motoji rugadu. Pao Kurireu umode boe pegado awu Judeu dogei rugadu ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iage ewidodumode tariga kurireu tabo. Boe emode iage etudo toro moto tuginaiwu ka etuguduwo baičoreuto toro. Nono boe tuginaiwuge etaregodumode Jerusalém ba kurireu ka tuwo akedudo rugadu jii toro Pao Kurireu jorduware jiwu meri ka. ");
INSERT INTO bor_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesus mako kimore: – Meri joku umode tuginai. Ari joku umode tuginai. Kuieje doge emode tuginai jamedu. Moto kejewu boe eimijera kurireuge epagudumode rugadu. Epagudumode pobo maereu ako pegareu akoji. Pobo maereu umode pobo barigu moto ao ka. ");
INSERT INTO bor_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Boe erduwamode boe pegare moto jituji. Baru magadugodumode jamedu. Boe edu pagamode turoiwakare nou boe pegare jiboeji kodi. Dukodire ekugudugodumode tubagudu koia. ");
INSERT INTO bor_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dukejere čare boe erdumode Imedu Onaregedu aregodumode tugodu tabo boetugu ao jituji. Erdumode Imedu Onaregedu ro rakareuji. Erdumode Imedu Onaregedu o jorugu kurireuji. Jorugure moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tardumode nou iwadaru jetumode pudui duji dukeje taragojedo tawo tado tarugadu. Tagaiwowo iwagai. Tarduwamode imode taginorudo rugadu kuri aino duji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus mako kimore. Akore: – Figo i ure tarduwado tu tu je. ");
INSERT INTO bor_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Figo i okurogu boture dukeje tardure roino duji rugadu. Dukodi čare tarduware bubutumode kuri je rugadu. Tagaiwore figo iji tarduwawo bubutumode kejewu meriji. Ainore tarore tu tu je. ");
INSERT INTO bor_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ča ire tawie nuba boemode meri jokuji nuba boemode ari jokuji. Iwo tawie. Tagaiwodo awu ire tawie jiboe jamedu boeji emode tarduwado dubagai. Tardumode ire tawie jiwu iwadaru jetumode pudui duji dukeje tarduwamode itaregodumode kuri aino duji boe eimijera kurireuwo imi. Bubutu ji karega inagoino. Ire inagoino rugadu. Itaregodumode kejewu meri jire inagoino tai. ");
INSERT INTO bor_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iwo tawie boe remawuji. Toro ia meri keje ia tawobe erdumode awu imagore jiboe jeture pudui duji rugadu. Jetumode pudui rugadu tuwimodedu otodai. ");
INSERT INTO bor_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Baru akedumode. Moto akedumode. Mare iwadaru akedumodukare rugadu jii toro rugadu. Jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jesus mako kimore ei. Akore: – Taeku jado. Tamororamagadukaba tawadae bagai. Tagaba tage kurudo tai. Tamororamagadukaba tamaragodae bagai. Tamororamagadumode nou inoduji dukeje tamodukare tado tarugadu nou ire tawie jiwu meri aregodumodedu ka. ");
INSERT INTO bor_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nou meri keje aregodumode tagae tae pagare tu je du ka. Moto kejewuge eiamedu boe emodukare činorudo nou itaregodumode kejewu meri keje. ");
INSERT INTO bor_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dukodire inagoino tai. Taeku jado. Tamagodo baruto Pao Kurireu bagai tu tu je uwo taragado, uwo taginorudo boe pegareu boe piji, tagawo tagera ra tameartorure i dupiji jii toro itaregodumode du ka. ");
INSERT INTO bor_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nono Jesus ure boe erduwado Pao Kurireu uwai ja tada meri jamedu boeji jii toro merirekodu ka tu tu je. Nou boečoji ure tudawuje nou ba kurireu piji tuduwo toro Oliveira Ri tori ao ka tu tu je. ");
INSERT INTO bor_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Barogwakododure dukeje ure tugirimi Pao Kurireu uwai ka pugeje tuwo boe erduwado nono. Boe eiamedu boe eture Pao Kurireu uwai ka Jesus togi tu tu je tuwiapagawo Jesus makore jiboeji pugeje. Ainore Jesus rore nou meri jameduji. ");
INSERT INTO bor_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Judeu doge epuredugodure tuwo tuwadae towuje. Nou ewadae iere Páscoa. Nou tuwadae kejere emode ia amireu tuginaiwu ko. Fermento metukare nou amireu tada. ");
INSERT INTO bor_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere bato pui jorduware Judeu doge eno bakaru jiwugebo. Emagore pui nuba turowo tuwo tugeragu Jesusji tuwo bito du bagai. Mare boe etaidure Jesusji dukodire nou jordu pegare Jesus jiwuge boe eimijerage epagudure turo pegawo ji. ");
INSERT INTO bor_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nono bope doge eimijera Satanás ure turemo nou Jesus ure jorduwadowu Judas Iscariotito. ");
INSERT INTO bor_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dukodire Judas Iscariotes uture toro nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etae tumagowo ei tumoduie Jesus maku etai. Pao Kurireu uwai tadawu tugobaigarege eimijerage eire Judas Iscariotes akoino jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dukodire nou boe eimijerage eiamedu boe egarere pudui. Nou boe eimijerage ere diero tori udo 30 Judas Iscariotes ai. ");
INSERT INTO bor_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dukodire Judas ure tugeragu nou dieroji. Du nou meri pijire nou Judas Iscariotes aiwore Jesus rore jiboeji tuiorduwo boe emagakare apo dubagai tuwo Jesus maku boe eimijerage pegareuge etai nou meri keje. ");
INSERT INTO bor_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Páscoa meri aregodure Judeu doge ere tuge amireu pemegado, ere tagu carneiro doge kugure ewido tuwo pemegado tuwo kowuje jamedu nono turo mogadure tuwaduwo Páscoaji. ");
INSERT INTO bor_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus makore Pedroji, Joãoji jamedu. Akore: – Tadudo toro tawo page pemegado pawo kowuje pawaduwo Páscoaji. ");
INSERT INTO bor_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Egore: – Kaiba čemode nou page pemegado? ");
INSERT INTO bor_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Jesus akore: – Tadumode Jerusalém ba kurireu ka. Tagaregodumode toro dukeje ia imedu aregodumode tadogi ia pori po tabo. Tadudo nou imedu rekodaji. Umode turemo ia baito dukeje tanarado nou uwaire bai čewuji ia paedumodureu bagai. Tagagodo aino: “Pagimijera aidure ia tiedumodureu bagai togwagewo Páscoa kejewu boe ekeji ture jorduwadowugebo nou boe edureu ja tada.” ");
INSERT INTO bor_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tagagomode aino dukeje nou uwaire bai čewu umode tardudo ia boe edure kejewu bai pemegareuji. Nou bai pemegamode rugadu pagwagewo Páscoa kejewu pageji. Nonore tamode page pemegado. ");
INSERT INTO bor_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nono Pedro uture João apo jamedu. Etaregodure Jerusalém ba kurireu ka dukeje erdure boeji nono Jesus akoino jiboeji. Nono ere tuge pemegado tuwaduwo Pascoaji nou bai tada rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nono Jesus aregodure nouia ture jorduwadowugebo. Nou boečoji Jesus mugure nono ia ira keje togwage tabo ebo. Utumode Jesus bataru tabowuge emode emage. ");
INSERT INTO bor_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akore: – Itaidure rugadu iwo awu Páscoa kejewu boe eke kowuje mare boe ero pegamode i du otodai. ");
INSERT INTO bor_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nono imodukare awu boe eke kowuje pugeje jii toro Boe Eimijera Pao Kurireu aregodumode nou meartorure puduiwuge ewagai du ka. Nono imode Pao Kurireu uke remawu kowuje Pao Kurireu apo. ");
INSERT INTO bor_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesus ure tugeragu vinho kuruji. Imadure Pao Kurireu apo nou vinho kuru paru tabo. Dukeje makore pugeje nou ture jorduwadowugei. Akore: – Awu pedo tai. ");
INSERT INTO bor_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inure tawie aino. Ikudumodukare awu vinho kuruče pugeje jii toro itaregodumode iwo boe eimijera kurireudo imi du ka. ");
INSERT INTO bor_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesus ure tugeragu amireuji. Imadure Pao Kurireu apo nou amireu paru tabo. Nono ure nou amireu kado dukeje ure pedo ei. Akore: – Ikodu reo. Makudumode taro pegareu moriče. Tagwagedo awuji tawiabutuwo iwugeje, irore jiboe keje. ");
INSERT INTO bor_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Enogwagere dukeje Jesus ure tugeragu vinho kuruji jamedu turowo ji nono turo moga amireu jitu mogadure. Akore: – Ikure nou uva kuru rema. Pao Kurireu meardae maiwu koiare imode iku redo boe ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ča. Tagaiwodo. Umode imagu boe eimijerage pegareuge etaiwu mugure woe itabo ira keje. ");
INSERT INTO bor_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mare iwimode nono Pao Kurireu meardae mogadure rugadu. Mare boe pegamode nou umode imagu boe eimijerage pegareuge etaiwuji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesus akore aino dukeje čare nou ure jorduwadowuge enarare pui duboba romode aino tuwo Jesus maku boe eimijerage etai du bagai. ");
INSERT INTO bor_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nono Jesus ure jorduwadowuge eiamedu boe etokire pui. Eiamedu boe egore boe eimijera kurireu moduie pudumi nou tumedage ekori. ");
INSERT INTO bor_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mare Jesus makore ei. Akore: – Boe tuginaiwuge eimijerage meartorukare Pao Kurireu jiwuge egore boe emedage enuie pudumi mare pagare egoino. Ero rakare boei. Boe emeartorure tugimijeragei rugadu. Emeartorumodukare ei dukeje nou boe eimijerage emode boe pegado nou meartorukare puduiwugei rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mare tagi tarokaba nono nou boe eimijera kurireuge ero mogadure. Ia tagi tagaidumode tawo boe eimijerado tagi dukeje tagojarokaba tai tawo tado nono ipare enojaromoga pudui tumanamagei dumogadure. Ia tagi tagaidumode tawo boe eimijerado tagi dukeje tameardae udo nono boe utugare meardae mogadure tawo boe eimijera pemegareugedo tagi. Boe eimijera romode nono boe utugare ro mogadure tuwo boe eimijera pemegareudo pudumi. ");
INSERT INTO bor_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Boe eimijerage kurireuge enogwagemode boetoji. Utugarege emode boe eke maku etai. Boe eimijera kurireu nure imi rugadu mare ire ido nono boe etugare mogadure iwo tage maku tagai. Tarodo nono iro mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Boe rakare i. Du inodu tabo taragojere woe itabo. Tardure boe rakare i duji. Mare Iogwa Kurireu ure boe eimijera kurireudo imi ietuwo boei. Dukodire imode boe eimijerado tagi jamedu taetuwo boei. ");
INSERT INTO bor_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mare boe eimijera kurireu mode imi dukeje tagwagemode itabo tagudumode itabo imugureu keje. Tamugumode boe eimijerage emuga keje jamedu. Boe eimijerage emode tagi jamedu tagaiwowo Judeu doge eiamedu boe ero pegareu bagai. ");
INSERT INTO bor_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Nono Jesus makore Pedroji. Akore: – Simão. Simão. Awiapaga pemegado imagomode ai jiboeji. Bope doge eimijera Satanás okwamagudure tuwo turokogado ai tuwo ameardae pegado. Dukodire imagore Pao Kurireuji aparu tabo ameartorure idu akedukawo. Nono amode akirimi ameartoruwo i pugeje nono amode amedage emeartoru kurido i jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mare Pedro akore: – Ikimijera kurireu nure aki rugadu. Imeartorure tu ai rugadu. Ire irugadu ikoduwo akabo imeduwo baičoreu tada akabo, iwiwo akabo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus akore: – Inure awie boe remawuji. Awu boečoji akagomode arduwakaie i dumode pobe metia bokware. Dukeje čare kagariga kudugodumode. ");
INSERT INTO bor_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nono Jesus makore ture jorduwadowuge eiamedu boei pugeje. Akore: – Ire tadudo toro boe etae marigudu tawo boe ewie iwadaruji. Mare ire tadudo tagadarabo bokware dutabo, tamijigu bokware dutabo, tawure okeakejewu bokware dutabo. Ča inarawo tai. Tadure toro ia boe bokware tagai kana? Egore: – Boro. Iaboe okwakare čenai rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesus akore: – Aino čare ore mičigureu umode tugeragu to mičiguji. Ukadaraboreu umode tugeragu tugodaraboji. Iaboe maku diero bagai tawo akirodo ia tarigaji. ");
INSERT INTO bor_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tawiapaga pemegado iwadaruji. Pao Kurireu bataru padure bapera keje marigudu. Akore aino: “Boe ere udo nono ro pegareu mogadure.” Ainore padure bapera kejewu Pao Kurireu bataru akore marigudu. Aino ča nou bataru jetumode pudui rugadu. Boe mode aino i rugadu nono nou bataru mogadure. ");
INSERT INTO bor_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ia nou Jesus ure jorduwadowu imedu akore: – Akaiwodo. Padarigare pobe woe. Jesus akore: – Ure turugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus uture ture jorduwadowugebo nou Jerusalém ba kurireu piji Oliveira ri ao ka turoiaji. ");
INSERT INTO bor_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aregodure taidure jiboe ka dukeje Jesus makore ei. Akore: – Tamagodo itabo Pao Kurireu bagai baruto bope ukawo tumeardae pegareu maku tagai taro pegakawo. ");
INSERT INTO bor_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nono Jesus ure tudawuje epiji kuri je tumagowo baruto. Ure tubu jodo moto keje tumagowo Tuoji. ");
INSERT INTO bor_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Akore: – Iogwa. Boe ero pegamode idu utudo ipiji. Mare umodukare nono itaidu mogadure. Mare uwo nono akaidu mogadure. ");
INSERT INTO bor_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dukeje ia Pao Kurireu utugare baru tadawu aregodure Jesus ae tuwo raka maku ai. ");
INSERT INTO bor_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus mako kimore baruto turaga tabo. Akaru ure nono boe ekure tuwudure moto ka dutabo. ");
INSERT INTO bor_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ure tumago akedudo dukeje Jesus ure tugirimi ture jorduwadowuge etae. Jordure ei enudure duji. Emedugodure tugiarigodure dukodi. ");
INSERT INTO bor_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesus makore ei. Akore: – Kodiba tanudure? Taragojedo. Tamagodo baruto Pao Kurireu bagai bope ukawo tumeardae pegareu maku tagai taro pegakawo. ");
INSERT INTO bor_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus mako kimore aino nou ture jorduwadowugei dukeje boe emagare taregodu tabo ae. Nou Jesus ure jorduwadowu Judas Iscariotes emare roino ebo tuwo erego Jesus bagai tuwo Jesus maku etai. Nono Judas ure tuburedo Jesusji tugimaduwo apo. Ure togwa to čo Jesus je koduto tuwo nou boe pegareuge erdudo taidure tuwo tugeragu jiwu imedu nure ema duji. ");
INSERT INTO bor_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus makore Judaji. Akore: – Are imagu awu boe pegareuge etai. Kočare akaidure akimaduwo aino itabo? ");
INSERT INTO bor_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ia Jesus ure jorduwadowuge erdure nou boe pegareuge emode tugeragu Jesus jituji dukeje enarare Jesusji: – Čegimijera! Čemode čebodo ebo tariga tabo? ");
INSERT INTO bor_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mare nouia Jesus ure jorduwadowu upagakare Jesus makowo nou tumedage ewadaru jipagi. Ure taredo nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu utugare ae. Ure tariga bu nou utugare bija kajeje. ");
INSERT INTO bor_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mare Jesus akore: – Tarokaba aino. Urugadu. Nono Jesus ure tugera bu nou imedu bija keje. Ča ure pemegago tači je. ");
INSERT INTO bor_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Dukeje Jesus makore nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijeragei, nou Pao Kurireu uwai tadawu tugobaigaregei jamedu, nouia boe eimijeragei jamedu. Akore: – Ire boe emeardae pegado kana emeartorukawo tugimijeragei kana? Kočare tagaregodure tariga kurireu tabo, rago tabo, tawo tageragu i nono taro moga ro pegareuge eidu mogadure. Iragojere tagabo meri jameduji Pao Kurireu uwai ja tada. Mare tagare tageragu i nono. Mare bope aidure boečoji kodire tare tarodo aino boečo kao tawo tageragu aino i boečoji rugadu tameartorure tagimijera bope doge eimijeraji dukodi. ");
INSERT INTO bor_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dukeje nou tugobaigarege ere tugeragu Jesusji. Eture apo. Ere reko nou Judeu doge eimijerage etae toro ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu uwai ka. Pedro uture eregodaji mare ure tugodu jaedo ei. Nou boe eimijerage ere nou tugobaigarege etudo Jesusji nono bawadu keje. ");
INSERT INTO bor_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nono boe ere jorugo nono bawadu keje. Pedro uture nou boe etae. Ure tumugudo nono ebo. ");
INSERT INTO bor_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ia utugare aredu jordure Pedroji nono nou joru okwai. Aiwo pemegare ji dukeje akore: – Awu imedu rakojere Jesus apo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mare Pedro akore: – Boro. Iorduwakare ji. ");
INSERT INTO bor_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mare Pedro utukare. Rakoje kimore nono nou bawadu keje. Nono ia imedu jordure ji dukeje makore Pedroji. Akore: – Ia Jesus apowu nure aki jamedu? Pedro akore: – Boro. Imi karega. ");
INSERT INTO bor_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nou inodu rekodaji ia imedu makore Pedroji pugeje. Akore: – Iorduware ai. Aragojere Jesus apo. Awadarure nono Galiléia kejewu boe ewadaru mogadure. ");
INSERT INTO bor_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mare Pedro akore: – Iorduwakare kaba jiba akagoino. Pedro makore aino dukeje ia kagariga kudugodure. ");
INSERT INTO bor_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nono Jesus aiwore tu Pedroji. Dukeje Pedro biabuture Jesus makore puduiwu bataru keje. Jesus makore Pedroji makomoduie tuiorduwakaie pudui dukeje kagariga kudugodumoduie rugadu. Pedro makomoduie tuiorduwakaie Jesusji dumode pobe metia bokware rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nono Pedro biabuture nou Jesus bataru keje jeture pudui rugadu duji. Dukodi čare Pedro uture nou boe epiji rugadu. Ragudu rakare rugadu turore aino duji. ");
INSERT INTO bor_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tugobaigarege ere boeto Jesusji, egokodure ji jamedu. ");
INSERT INTO bor_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ere areia kogudo Jesus je kajeje. Nono enarare ji: – Ioguduba ure boeto ai? Amagodo! Mare pagare egoino. Enure tago kodudo ji turoi jitu tabo. ");
INSERT INTO bor_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nono emago pegare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Barogwakododure dutabo boe eimijera kurireuge ere bato pui. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage edure nono. Jorduware Judeu doge eno bakaru jiwuge edure nono jamedu. Nono tugobaigarege etaregodure Jesus apo etae. ");
INSERT INTO bor_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Dukeje nou boe eimijerage enaragodure Jesusji. Egore: – Amagodo. Aki na umode boe ekinorudowu nure aki? Jesus akore: – Inagomode uu. Imie rugadu mare tameartorumodukare i dukodire imagomodukare tawadaru jipagi. Inaramode tai iaboeji mare tarduwamodukare tamagowo iwadaru jipagi jamedu. Dukodire inaramodukare boeji tai. ");
INSERT INTO bor_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mare Pao Kurireu raka kodure boe eiamedu boe kori. Nono inure tawie. Awu inodu otobiji imugumode Pao Kurireu ukana pemegareu jagwai. ");
INSERT INTO bor_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesus akore aino dukeje nou boe eimijerage enarare Jesusji. Egore: – Mare aki na Pao Kurireu Onaregedu nure aki? Jesus akore: – Boe jokodu jire tagagoino. Imi rugadu. ");
INSERT INTO bor_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mare nou boe eimijerage emeartorukare nou inoduji marigudu. Dukodire emagore pui tumago pegare Jesus jitu tabo. Egore: – Pagare akoino. Batrarodunure. Mako peganure Pao Kurireuji. Kodi čare ure tumagu pagai nou tuwadaru pegareu tabo. Paipagamodukare ia bataru pegareu bagai pugeje. ");
INSERT INTO bor_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nono nou Judeu doge eimijerage ere Jesus reko toro Pilatos ae. Emare Romano doge eimijera kurireu nure ema nono. ");
INSERT INTO bor_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Etaregodure Pilatos ae dukeje nou Judeu doge eimijerage emago pegare Jesusji Pilatos biagai tuwadrarodu tabo. Egore: – Čerdure awu imedu ro pegareuji. Ure čewobe Judeu doge emeardae pegado Roma kejewu pagimijera kurireuji. Makore boei ekawo imposto diero maku Roma kejewu pagimijera kurireu César ai. Akore tumoduie boe ekinorudo Roma kejewuge epiji. Akore boe eimijera kurireu unuie pudumi. ");
INSERT INTO bor_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dukodire Pilatos unarare Jesusji. Akore: – Boe rugadu na? Judeu doge eimijera kurireu nure aki rugadu? Jesus akore: – Uu. Boe jokodu jire akagoino. ");
INSERT INTO bor_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mare Pilatos makore nou Judeu dogei, eimijeragei jamedu. Akore: – Iordukare awu imedu ia ro pegareuji. Imodukare barigu boe pegareuto. ");
INSERT INTO bor_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mare nou boe emagore Pilatoji pugeje. Egore: – Ure boe ekiripagado Judéia kejewu moto parugajeje tuwadaru tabo. Ainore rore Galiléia moto keje ji taregodure aino woe du ka. ");
INSERT INTO bor_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","7","Pilatos unarare nou boei. Akore: – Nou Galiléia moto kejewu nure ema na? Nou boe egore uie ema rugadu. Dukodire Pilatos ure nou Judeu doge eimijerage etudo Galiléia moto kejewuge eimijera bagai Jesus apo. Nou Galiléia moto kejewuge eimijera iere Herodes. Nou Herodes rakojere nono Jerusalém ba kurireu keje nou meriji. Dukodire Pilatos ure Jesus utudo toro bagai. ");
INSERT INTO bor_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Etaregodure Jesus apo Herodes ae dukeje Herodes jakaregodure pudui. Marigudu aidure tuiorduwo ia Jesus ro rakareuji kodi. ");
INSERT INTO bor_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dukodire Herodes unara raire Jesusji. Mare Jesus makokare boeji, rokare ia boeji. ");
INSERT INTO bor_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nono nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nou jorduware Judeu doge eno bakaru jiwuge emago pegare Jesusji nou Herodes biagai. ");
INSERT INTO bor_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nono Herodes ure tuwadaru očarodo Jesusji. Nou rakojere apowu tugobaigarege ere tuwadaru očarodo ji jamedu. Dukeje Herodes ure ia tugudau areia motureu tugu ji mare roreru nure ji. Dukeje ure Jesus utudo toro tuibagi Pilatos ae. ");
INSERT INTO bor_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dukodire nou meriji Herodes, Pilatos ere tumedagedo puče. Marigudu erdu pegare pui. Aino čare ere tubemegado pui. ");
INSERT INTO bor_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Etaregodure tuibagi Pilatos ae pugeje. Dukeje Pilatos makore nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijeragei, nouia Judeu doge eimijeragei, nouia boei jamedu. ");
INSERT INTO bor_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akore: – Tagaregodure awu imedu Jesus apo woe itae. Tagagore uie boe emeardae pegado emeartorukawo tugimijerage čei pugeje. Aino inara raire ji woe taiamedu boe taegai. Mare iordukare ia tagagoino jiwu awu imedu ro pegareuji. Iordukare ia tagagoino jiwu awu imedu bataru pegareuji. ");
INSERT INTO bor_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ire utudo Herodes ae. Mare Herodes jordukare ia awu imedu ro pegareuji jamedu. Ure utudo tuibagi mato itae pugeje. Awu imedu ro pegareu kurimode dukeje imagomode tugobaigaregei ewo bito. Mare iagai ro pegareu remawu bokware dukodire imodukare edo bito. ");
INSERT INTO bor_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Imode tugobaigarege edo boeto ji bukigu tabo nono imode ikera ra piji utuwo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","Páscoa kejewu meriji nou Judeu doge ero koiare nou Pilatos umode ia mugure baičoreu tadawu imedu tawuje utuwo nou boe epiji ainore rore tu tu je. Ainore erore joru jamedu boeji. Dukodire Pilatos meardaere tuwo Jesus utudo aino. Ia imedu iere Barrabás. Ure boe ewido. Ure boe ero pegado rugadu boe eimijeragei. Ro pegareu nure ema rugadu. Dukodire nou Barrabás rakojere baičoreu tada marigudu. Mare nou boe ere tumago rakado toro Pilatos ae. Egore: – Nou imedu Barrabás tawuje čenai utuwo pugeje! Awu imedu Jesus remo baičoreuto nou Barrabás mugato bitoduwo! ");
INSERT INTO bor_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatos meardaere tuwo Jesus utudo rugadu dukodire makore nou boei pugeje. ");
INSERT INTO bor_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mare ere tumago rakado toro Pilatos ae. Egore: – Bito ipo padure pugajejewu keje! Bito ipo padure pugajejewu keje! ");
INSERT INTO bor_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mare Pilatos makore nou boei pugeje. Akore: – Kodiba tagagoino? Ro pegareu pa? Iagai awu imedu ro pegareu remawu bokware dukodire imodukare tugobaigarege edo bito. Imode edo boeto ji bukigu tabo nono imode ikera ra piji utuwo pugeje. ");
INSERT INTO bor_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mare nou boe ere tugudu rakado toro Pilatos ae rugadu Jesus bitoduwo ipo padure pugajejewu keje rugadu! Ere tumago raido aino dukodire ere nou Pilatos meardae kodudo nou tumeardae rekodaji. ");
INSERT INTO bor_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Dukodire Pilatos ure Barrabás utudo baičoreu piji mare makore nou boei Jesus bitodumoduie. Nou Barrabás imedu ro pegareu nure ema rugadu. Ure boe ewido. Ure boe emeardae pegado tumeartorukawo tugimijeragei pugeje. Mare nou meriji boe etaidure ji. Emagore Pilatoji uwo nou Barrabás tawuje baičoreu piji. Dukodire Pilatos ure utudo rugadu. Mare boe etaidukare Jesusji. Etaidure tuwo Jesus bito rugadu. Nono Pilatos ure Jesus maku tugobaigarege etai bitoduwo nono nou boe etaidu mogadure. ");
INSERT INTO bor_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Du inodu rekodaji tugobaigarege eture toro Jesus apo. Jesus oredure nou tubadumode kejewu ipo tabo. Mare Jesus rakakare nou ipo tabo. Dukodire tugobaigarege emagore ia imeduji oreduwo nou ipo tabo Jesus rekodaji. Nou imedu iere Simão. Cirene ba kurireu pijiwu nure ema. Maigodu aino nou Simão aregodure ipoguru piji nou Jerusalém ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Boe emagare Jesus kodumode jiwu awaraji. Ia Jerusalém kejewuge areme etragudu rakare Jesus apo. ");
INSERT INTO bor_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Mare Jesus makore nou aremei. Akore: – Tagragudukaba itabo. Tagragududo tagabo. Tagragududo tagorebo. Mare paga karega boe pegareu aregodumode tagae kodi. Boe pega rakamode boe etorei rugadu dukodire areme ekiarigodumode rugadu, etragudumode rugadu torebo. Boe emagomode aino: “Čerdure boe pegare čedorei rugadu dukodire boe pega kuričigore čei rugadu. Dukodi boe pegakare ore bokwareu aremei. Ore bokwareu areme egarere pudui.” Ainore boe egomode. ");
INSERT INTO bor_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mare paga karega. Boe pegamode boei rugadu. Dukodi nou meri keje boe emagomode tori ri butuwo tuwugeje, tuwiwo boe pegareu koda piji. ");
INSERT INTO bor_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iwidodumode nono boe ere joru tugu ia jerigi kidukareu to dumogadure. Mare ia meri keje tagi tamode nono jerigi pemegareure. Boe pegamode tai rugadu nono joru ure jerigi kowu dumogadure. Mare joru ji karega Jesus akoino ei. Boe pega raimodukare pudui. Dujire akoino ei. Toro ia meri keje boe pega kuričigomode Judeu dogei. Dujire akoino ei. ");
INSERT INTO bor_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tugobaigarege eture ia ime pobedu dogebo Jesus apo jamedu. Ro pegareuge nure emage. Ewidodumode jamedu. ");
INSERT INTO bor_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nono etaregodure ture boe ewido kejewu tori ao ka. Nou tori iere “Boe ewireuge etaora era jeta reo”. Nonore ere Jesus bito ipo padure pugajejewu keje. Ere nou ro pegareu ime pobedu doge ewido nono jamedu. Ia rakojere Jesus kana pemegareu jagwai. Metia rakojere Jesus kana pegareu jagwai jamedu. ");
INSERT INTO bor_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nono Jesus akore: – Iogwa. Awiago awu boe ero pegare i dupiji. Erduwakare kaba jiba turoino. Nou tugobaigarege ere Jesus ukudau areia pedo pui. Ere tuwadu rogu towuje tori rogu tabo tuiorduwo duboba umode tugeragu Jesus ukudau areiaji. ");
INSERT INTO bor_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Boe etaregodure nou Jesus ae nou ipo padure pugajejewu ka. Eragojere nono taiwo tabo Jesus bimode dubagai. Nou boe eimijerage ekadakagirire Jesus jiwuge etaregodure nono tuiorduwo Jesus bire duji. Egore: – Are boe ekinorudo boe pegareu piji. Ča akinorudo jamedu nou ipo padure pugajejewu piji. Pao Kurireu ure tugeragu jiwu umode boe ekinorudowu mode aki rugadu dukeje amode akinorudo nou ipo padure pugajejewu piji. ");
INSERT INTO bor_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Tugobaigarege etomeare turore Jesus jituji jamedu. Ere vinho kuru maku Jesus ai mare kudukare če. Nono emagore ji. Egore: – Judeu doge eimijera kurireu nure aki dukeje amode akinorudo awu ipo padure pugajejewu piji. ");
INSERT INTO bor_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nono ere ia ira atugodo. Ere bu Jesus aogeje. Ainore nou ira atugo ure: – Judeu doge eimijera kurireu reo. ");
INSERT INTO bor_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nou ro pegareu pobedu doge epadure ipo padure pugajejewu keje nono jamedu Jesus apo jamedu. Ia makore Jesusji. Akore: – Umode boe ekinorudowu nure aki dukeje amode akinorudo amode čeginorudo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Mare nou metia makore nou timediaji. Akore: – Kočare akare aeku kidugo Pao Kurireuji rugadu. Boe pegare aino pai paro pegare kodi. Boe enure pawido ipo padure pugajejewu keje paro pegareu moriče. Mare awu pagaiadadawu imedu ro pega bokware rugadu. Dukodire ukare turugadu biwo aino pawi mogadure. ");
INSERT INTO bor_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dukeje makore Jesusji. Akore: – Akaregodumode pugeje boe eimijera kurireu ure aki dutabo dukeje awiabutudo iwugeje. ");
INSERT INTO bor_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus akore: – Boe jokodu jire imagomode ai. Awu meriji rugadu aragojemode itabo boe pemegareu keje. ");
INSERT INTO bor_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Meri puredugodure pagaia ka dukeje boečodure tači je moto jamedu boe parugajeje. Boečodure rugadu. Nou boečo kodure kuri toro nou três hora ka. ");
INSERT INTO bor_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Čare rore puku je nou areia kurireu bararere Pao Kurireu uwai ja tadawu ure tuwowuje nou bai ja oto piji moto ka. ");
INSERT INTO bor_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nono Jesus kudugodu rakare. Akore: – Iogwa. Iwinure aino mare imugudo akera keje. Makore aino dukeje bire. ");
INSERT INTO bor_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tugobaigarege eimijera jordure nou inoduji dukeje makore Pao Kurireu bagai baruto. Akore: – Boe rugadu. Awu imedu ro jetororeu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nou etaregodure taiwowo boe ewimode dujiwuge erdure Jesus bire duji dukeje ere tugirimi tuibagi tuwai ka pugeje tugiarigodu tabo. Ere boeto tumororaji nono Judeu doge ero mogadure tuwo boe erdudo tugiarigodure rugadu duji. ");
INSERT INTO bor_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mare nou Jesus metage edu kimore nono taiwo tabo. Nou aregodure Jesus rekodajiwuge Galiléia pijiwuge areme edu kimore nono jamedu taiwo tabo Jesus bire duji. ");
INSERT INTO bor_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ia Judéia moto kejewu Arimatéia ba kurireu kejewu imedu Judeu doge eimijera pemegareu iere José. Upagare umode boe ekinorudowu bagai boe emeartoruwo ji boe ewo tugimijerado Pao Kurireuče. Boe eimijerare ema jamedu mare meardaekare nono tumedage Judeu doge eimijerage emeardaere. Aidukare Jesus bitoduwo. ");
INSERT INTO bor_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","54","Barogwato Judeu doge emaragodumodukare. Dukodire nou José okwamagudure Pilatoji tuwo Jesus tugu ia tori poroto nou Sábado rekodajiwu meri keje. Pilatos akore pegakaie dukodire nou imedu José ure Jesus rawuje nou ipo padure pugajejewu piji. Ure upodo areia pemegareu tabo. Nono ure Jesus reko tumode tugu towu tori poro ka. Boe ere nou tori porodo mare ekare ia bireu tugu to raga. Ča nou José ure Jesus tugu nou tori poroto sexta feira meriji merirekodutabo. ");
INSERT INTO bor_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nou etaregodure Galiléia pijiwuge areme ekodure nou José rekodaji. Erdure José ure tugu tori poro to duji. Ere turemo nou tori poroto tuiorduwo Jesus meture nono duji. ");
INSERT INTO bor_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nono ere tugirimi tuwai ka pugeje tuwo roreboe pemegado tuwo reko nou Jesus biriji. Nono Sábado meri keje nou areme ere tamudo tuwai keje tumeartoruwo Judeu doge eno bakaruji nono turoiaji. ");
INSERT INTO bor_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo boečoto nou areme eture Jesus meture tadawu tori poro ka nou ture tugera pemegado jiwu roreboe tabo. ");
INSERT INTO bor_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Etaregodure toro dukeje erdure nou Jesus meture tadawu tori poro jare duji. Sexta feira meriji ime ere nou tori poro mi ia tori kurireu tabo. Mare aino nou tori kurireu padukare nou tori poro keje pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dukodire nou areme ere turemo. Etaiwore mare Jesus padukare nono pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eragoje kimore nono tuiorduwa bokwa tabo dukeje nou areme etaiwore tubiji. Erore puku je erdure Pao Kurireu utugarege baru tadawugei. Ere pobe. Ekudau kigadure ei rugadu. Kigadure nono boeiaragudu mogadure boe etaiwowo ji. ");
INSERT INTO bor_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ča nou areme epagudugodure rugadu. Ere tubu jodo moto keje. Ere tuie jodo jamedu. Nono nou baru tadawuge egore: – Kodiba tagaregodure woe bireu metumode tadawu tori poro ka? ");
INSERT INTO bor_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tardumodukare tagaiwore bagaiwuji. Tagaiwore bagaiwu jewodure pugeje dukodire rakojekare woe pugeje. Marigudu, toro Galiléia moto keje, ure tawie turomode jiboeji. Tawiabutudo nou makore jiboe keje. ");
INSERT INTO bor_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akore aino: “Imagudumode ro pegareuge etai. Emode iwido ipo padure pugajejewu keje. Mare merimode pobe metia bokware dukeje iewodumode pugeje.” Ainore akore tai marigudu. ");
INSERT INTO bor_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Nono nou areme ewiabuture nou Jesus makore jiboe keje rugadu. Dukodire čare eregodure boe piji toro nou Jesus ure jorduwadowuge etae tureadoduwo tuiordure jiboeji tumeardure jiboeji eiamedu boe ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nou areme ekiere Maria Madalena, Joana, Maria. Nou Maria Tiago uče nure ema. Ia areme ekodure ebo jamedu. Nou areme etaregodure nou Jesus ure jorduwadowuge etae dukeje ereadodure tuiordure jiboe jamedu boeji nou Jesus ure jorduwadowuge ime ewiagai. ");
INSERT INTO bor_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jesus ure nou ime erduwado tuwo etudo tuwadaru tabo boe ewagai moto jamedu boe parugajeje. Mare nou areme ereadodure tuiordure jiboeji nou uture Jesus bataru tabowuge ewiagai dukeje nou ime emeardaere pagare egoino duji. Emeartorukare nou aremei. ");
INSERT INTO bor_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mare Pedro rekodure toro nou Jesus meture tadawu tori poro ka. Aregodure toro dukeje ure turemo mare jordukare boeji. Tu nou areia jire jordure. Nono ure tugirimi tuibagi tuwiagoro tabo. Meardaere tudada nuba boere? ");
INSERT INTO bor_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nou meri keje rugadu nouia Jesus ure jorduwadowuge ere pobedu doge eture Jerusalém ba kurireu piji toro ia boe eda ka. Nou boe eda iere Emaús. Nou Emaús rakojere dez quilômetros Jerusalém ba kurireu piji. ");
INSERT INTO bor_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nou ime pobedu doge ekodure nou Emaús kawu awaraji dukeje emagore pui tuiordure jiboeji Jerusalém ba kurireu tada. ");
INSERT INTO bor_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Emagore aino pui dukeje Jesus aregodure eregodaji tugoduwo ebo jamedu. ");
INSERT INTO bor_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Etaiwore ji mare erduwakare ji. ");
INSERT INTO bor_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nono Jesus makore ei. Akore: – Kaboba jiba tagagoino pui tagodui aino awaraji? Ere tuwuredo ča je. Ekiarigodure rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ia iere Cleopas. Emare makore Jesusji. Akore: – Boe pegare Jerusalém ba kurireu tada rugadu. Nou Jerusalém kejewuge eiamedu boe erduware nou inoduji. Kočare arduwakare? ");
INSERT INTO bor_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesus akore: – Kaba jiba boe eroino? Iwie. Egore: – Boe ero pegare Jesusji rugadu. Nazaré pijiwu Jesus jire eroino. Makore Pao Kurireu bataru jiwu nure ema. Pao Kurireu aidure ji. Boe etaidure ji jamedu. Ro rakare rugadu turo jamedu boe tabo. Mako pemegare jamedu. Jorduware rugadu Pao Kurireu bataruji boe eiamedu boe kori. ");
INSERT INTO bor_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mare nou pagimijerage nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage, nouia pagimijerage jamedu ero pegare ji. Ere maku nouia boe eimijera kurireu ai. Ere tumeardae pegareu maku nou boe eimijera kurireu ai jamedu uwo Jesus maku tugobaigarege etai ewo bito. Dukodire ere bito ipo padure pugajejewu keje rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Čemeartorure Jesusji. Čemeardaere umode pawobe Judeu doge ekinorudo boe pegareuge epiji duji. Ča iaboe kimore. Merire pobe metia bokware jamedu. ");
INSERT INTO bor_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Awu meriji ia čerduware jiwu areme ere čeku kidugo rugadu. Eture nou ere Jesus tugu towu tori poro ka. ");
INSERT INTO bor_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mare erdukare ji nono. Ere tugirimi tuibagi tureadoduwo nou boe ewiagai tuiorduie Pao Kurireu utugarege baru tadawugei. Nou Pao Kurireu utugarege baru tadawuge egoie Jesus jewoduie pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ia čemedage eregodure toro nou tori poro ka jamedu. Erdure jiboe ure nono nou areme emagore jiboe mogadure. Erdukare Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nono Jesus makore nou imei. Akore: – Tagaora rakare boe emagore jiwu Pao Kurireu bakaruji. Dukodire tarduwa jokodukare makore Pao Kurireu bataru jiwuge emagore jiboeji. Tameartoru pemegakare ji jamedu kodi. ");
INSERT INTO bor_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ere boe ewie marigudu boe pegamode nou umode boe ekinorudowuji rugadu. Dukejere rutumoduie baruto pugeje. Ainore nou makore Pao Kurireu bataru jiwuge egore marigudu. ");
INSERT INTO bor_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nono Jesus ure erduwado nou padure bapera kejewu Pao Kurireu bataru makore pudui jiboeji. Makore Moisés ure bu bapera kejewu Pao Kurireu bataruji ewiagai. Makore nouia makore Pao Kurireu bataru jiwuge ewadaruji jamedu tuwo erduwado nuba boemode pudui. Mare erduwakare raga puduire Jesus akoino duji. ");
INSERT INTO bor_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ča etaregoduiago nou boe eda ka dukeje Jesus utuiago nouia awaraji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mare nou ime emagore ji. Egore: – Mato čedabo čewai ka. Merirekodu. Akamudo čewai keje jao. Dukodire Jesus uture ebo ewai ka. ");
INSERT INTO bor_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Etaregodure dukeje ere tumugudo ira keje togwagewo. Nono Jesus imadure Pao Kurireu apo nou tuge amireu paru tabo. Nono ure nou boe eke amireu kado puiato. Ure ia maku nou ime etai. ");
INSERT INTO bor_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dukejere nou ime erduwagodure Jesus nuie ema duji rugadu. Mare Jesus okware tači epiji pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Emagore pui. Egore: – Pagodure awaraji dukeje ure parduwado Pao Kurireu bataruji. Dukejere paebogodure nou makore pai jiboeji rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Dukodire ere tugirimi tumara tabo rugadu Jerusalém ba kurireu ka nou tumedage ewagai tureadoduwo ewiagai. Mare Jesus ure Simão Pedro jordudo pudui. Nono Pedro readodure nouia Jesus ure jorduwadowuge ewiagai dukodire ere bato pui tumagowo pui. Egore: – Boe jokodu! Pagimijera jewodure pugeje! Simão Pedro jordure ji! ");
INSERT INTO bor_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nono nou pobedu doge ereadodure nou boe ewiagai tuiorduie Jesusji jamedu. Ereadodure tuiorduie ji jamedu duji tugoduie Emaús kawu awaraji dutabo. Ereadodure tuiorduware Jesusji ure amireu kado dukeje erduware Jesus uiure ema duji. ");
INSERT INTO bor_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Emago kimore pui dukeje Jesus jepadure tači etoiado. Akore: – Itaregodure pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nou boe epagudugodure rugadu. Emeardaere aroe uiure ema. ");
INSERT INTO bor_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mare Jesus makore ei. Akore: – Mure kodiba tabagudure? Mure kodiba tamororamagadure iwadaruji tarduwa jokodukare imire iroino duji? ");
INSERT INTO bor_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tagaiwodo ikeraji, iwureji. Imi rugadu reo! Aroe karegure imi. Aroe mode imi dukeje ikodu modukare iwiri modukare. Ča tagera pagado i dukeje tameartorumode i. ");
INSERT INTO bor_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Makore aino ei dutabo ure erdudo tugeraji, tuwureji. ");
INSERT INTO bor_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ebogodure ji rugadu. Egarere pudui rugadu. Mare emeartoru jokodukare ji kimo. Nono Jesus unarare ei ia eke bagai togwagewo. ");
INSERT INTO bor_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ere ia karo kodu maku ai. Nono Jesus ure ko egai. ");
INSERT INTO bor_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","45","Nono Jesus ure nou boe emeardae pemegado tuwo erduwado. Akore: – Iragojere tagabo dukeje ire tawie boe mode aino i duji. Ainore Moisés, makore Pao Kurireu bataru jiwuge, ere bu bapera keje iboe jamedu boe jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Egore nou umode boe ekinorudowu bimoduie mare merimoduie pobe metia bokware dukeje jewodumoduie pugeje. ");
INSERT INTO bor_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Egore nou umoduie boe ekinorudowu ie taboie boe etumoduie moto jamedu boe parugajeje tuwo boe eiamedu boe ewie Pao Kurireu bataru pemegareuji boe ewo tugera ra tumeardae pegareu piji, boe emagowo turo pegareuji Pao Kurireu biagai Pao Kurireu biagoduwo nou ero pegareu piji. Boe etumoduie nou bataru tabo Jerusalém ba kurireu kejewuge etae boetoji. Nono etumoduie nou bataru tabo moto jamedu boe parugajeje. Ainore Pao Kurireu akore marigudu. ");
INSERT INTO bor_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","49","– Aino čare nou Pao Kurireu bataru jeture pudui rugadu. Nou umode boe ekinorudowu nure imi. Tagire tarduware i rugadu. Tagire tardure iro rugadu boeji. Dukodire ikie jire tamode boe ewie rugadu imagore jiboeji irore jiboeji nono Pao Kurireu bataru mogadure. Imode Iogwa Kurireu Uwari utudo tagae. Mare tabagado bagai woe Jerusalém ba kurireu keje. Iogwa Kurireu Uwari aregodumode tagae woe. Ema umode taragado rugadu. Nono tareadodumode imagore jiboeji irore jiboeji boe eiamedu boe ewiagai moto jamedu boe parugajeje. ");
INSERT INTO bor_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nono Jesus uture ebo Jerusalém ba kurireu piji nou boe eda Betânia kawu awaraji. Epuredugodure Betânia ka dukeje ure tugera rakojedo ewugajeje tumago pemegawo eiogi. ");
INSERT INTO bor_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mako kimore eiogi dukeje uture epiji. Dukeje čare ruture baruto rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ere tubu jodo moto keje tumago pemegawo ji rugadu. Dukeje čare ere tugirimi tuibagi Jerusalém ba kurireu ka. Eiamedu boe egarere pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nono eture Pao Kurireu uwai ka. Edure tu nono rugadu. Emago pemegare Pao Kurireuji rugadu nou Pao Kurireu uwai tada tu tu je.");
INSERT INTO bor_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Awu motokare raga mare Bakaru Remawu ure. Awu Bakaru Remawu mugure Pao Kurireu apo rugadu. Awu Bakaru Remawu Pao Kurireu nure ema. ");
INSERT INTO bor_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bakaru Remawu mugure Pao Kurireu apo boetoji. Mare Jesus jire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pao Kurireu koiare ure awu Bakaru Remawu udo boe jamedu boe towuje. Ia ukare towujeboe bokwakare moto jamedu boe parugajeje, baru tadaboe jamedu. Ure boe jamedu boe towuje rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","5","Nou Bakaru Remawu koiare ure boe edudo aino. Nou Bakaru Remawu ure nono ia jorugu pemegareu mogadure. Nou Bakaru Remawu umode boe erduwado turo pegareuji, turore jiboeji boečoji nou bakaru remawu ure nono jorugu mogadure. Mare jorugu ji karega inagoino. Nou Bakaru Remawu ure boe erduwado boe pemegareuji rugadu. Dujire inagoino. Nou Bakaru Remawu ure boe erduwado dukeje boe erduwamode turo pegareuji rugadu. Dujire inagoino. Ro pegareuge ere nono boečo mogadure. Mare boečo ji karega inagoino. Ro pegareuge erore jiboe pegare. Dujire inagoino. Mare ro pegareuge emodukare Bakaru Remawu akedudo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pao Kurireu ure tudugare imedu arego mato pagae. Nou imedu iere João Batista. ");
INSERT INTO bor_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","João Batista aregodure tumagowo boei Jorugu Pemegareu paru tabo boe erduwawo ji emeartoruwo ji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jorugu Pemegareu karegure ema. Mare aregodure tuwo boe erduwado Jorugu Pemegareuji. ");
INSERT INTO bor_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jorugu remawu jire João Batista akoino. Urugumode boe eiamedu boei. Mare jorugu karega. Jesus jire akoino. ");
INSERT INTO bor_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pao Kurireu koiare ure Bakaru Remawu udo moto towuje. Nou Bakaru Remawu aregodure moto ka. Jesus jire inagoino. Mare moto kejewuge erduwakare ji. ");
INSERT INTO bor_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aregodure ture towujewu moto ka tuwobe etae, mare uwobe etaidukare ji. ");
INSERT INTO bor_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iagere etaidure ji. Emeartorure ji. Nou meartorure jiwugere ure Pao Kurireu oredo emage. ");
INSERT INTO bor_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ewodukare Pao Kurireu piji nono boe etore ewodu moga tujemage epiji dumogadure. Mare Pao Kurireu ure toredo emage. Emeartorure pudui dukodire ure toredo emage. ");
INSERT INTO bor_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bakaru Remawu ure imedudo pudumi. Rakojere pagabo. Emare meardu kurire boei rugadu. Emare ro pemegare boei jamedu. Boe jokodu jire akoino boe emeartoruwo ji rugadu. Pardure Pao Kurireu ure maku aiwu ro kurireuji. Pao Kurireu onaregedu mitodu nure ema dukodire ure turo rakareu maku nou tonaregedu ai. ");
INSERT INTO bor_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Batista ure boe ewie ji. Akore: – Dujire ire tawie marigudu. Inagore aregodumoduie iregodaji. Kurimoduie ikori. Iwodukare raga dukeje emare rakojere baru tada marigudu. ");
INSERT INTO bor_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Emare meardu kurire boei rugadu dukodire ro pemegare paiamedu boeji. Ukare turo pemegareu akedudo. ");
INSERT INTO bor_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Marigudu Pao Kurireu ure tumeardae maku Moisés ai Judeu doge eno bakaruwo ema. Mare maigodu aino čare Jesus Cristo ure boe erduwado Pao Kurireu meardu kurire boei rugadu duji. Ure boe erduwado Pao Kurireu ro pemegareuji. Ure boe erduwado bakaru remawuji. ");
INSERT INTO bor_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Marigudu boe erdukare Pao Kurireuji. Pao Kurireu onaregedu ure mitotu je. Ure nono tuo mogadure. Mugure Pao Kurireu meki. Dukodire ure boe erduwado Pao Kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalém ba kurireu kejewuge boe eimijerage ere ia boe etudo João Batista ae. Iage Levita doge nure emage. Iage ure Judeu doge enomea maku Pao Kurireu aiwuge nure emage. Enarare João Batistaji. Egore: – Ioguduba nure aki? ");
INSERT INTO bor_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","João Batista mako pemegare ei. Ukare tumeardae biado epiji. Akore: – Pabagare bagaiwu umode boe ekinorudowu karegure imi. ");
INSERT INTO bor_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Egore: – Mare ioguduba nure aki? Elias nure aki? João Batista akore: – Boro. Elias karegure imi. Egore: – Pabagare bagaiwu makore Pao Kurireu bataru jiwu nure aki? João Batista akore: – Boro. ");
INSERT INTO bor_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Egore: – Dukodi čewie. Ioguduba nure aki? Čedaidure čewo čegimijerage ewie kaboba ure aki. Emagere ere čerojino čerduwawo ai. Nuba akagomode čei? ");
INSERT INTO bor_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dukejere João Batista makore Pao Kurireu bataruji ewiagai. Makore Isaías ure bu bapera kejewu Pao Kurireu bataruji ewiagai. Akore: – Kudugodure boe maereu kejewu nure imi. Ainore inagore boe ero pemegaiago Pagimijera aregoduwo boe etae. ");
INSERT INTO bor_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Jerusalém ba kurireu kejewuge boe eimijerage ere fariseu doge etudo nou João Batista ae jamedu. Čare nou fariseu doge emagore João Batistaji jamedu. Egore: – Kočare pabagare bagaiwu umode boe ekinorudowu karegure aki. Elias karegure aki. Pabagare bagaiwu makore Pao Kurireu bataru jiwu karegure aki. Kodiba are boe etao pegodo? ");
INSERT INTO bor_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","João Batista akore: – Imi ire boe etao pegodo pobo tabo. Mare ia tarduwakare jiwu rakojere tagabo. ");
INSERT INTO bor_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Emare aregodumode iregodaji. Mare ipogurumode ipureduwo ji boe kurireu karegure imi dukodi. ");
INSERT INTO bor_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordão po okwa abowu kejere João Batista akoino nou boei ia boe eda keje. Nou boe eda iere Betânia. Nonore João Batista ure boe etao pegodo. ");
INSERT INTO bor_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nou barogwato João Batista jordure Jesus kodure pudae duji. Akore: – Makudure boe ero pegareu mori čewu Pao Kurireu aku ovelha reo. Emare umode boe ero pegareu barigu boe epiji. Jesus jire João Batista akoino. ");
INSERT INTO bor_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","João Batista makore kimo. Akore: – Dujire ire tawie marigudu. Inagore ia imedu aregodumoduie iregodaji. Kurimoduie ikori. Iwodukare raga dukeje rakojere baru tada marigudu. ");
INSERT INTO bor_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Imi iorduwakare ioguduba ure ema. Mare ire boe etao pegodo pobo tabo. Nono Judeu doge erdure irore jiboeji dukeje erduwamode nou makudure boe ero pegareu mori čewu aregodumode kuri aino rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","João Batista ure boe etao pegodo mare ure boe erduwado jamedu. Akore: – Iordure Pao Kurireu Uwariji rugadu. Ure metugodo pudumi. Ure turawuje baru piji. Ure tumugudo Jesus keje. ");
INSERT INTO bor_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dukodi aino iorduware ji. Pao Kurireu ure iwie marigudu. Akore: “Ardumode Iwariji. Umode turawuje baru piji tuwo tumugudo nou imedu kanaura keje. Nou imedu koiare umode Iwari metudo boe eiamedu boe etada.” ");
INSERT INTO bor_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","João Batista mako kimore. Akore: – Iordure ji rugadu. Dukodire inagoino tai. Awu Jesus Pao Kurireu Onaregedu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nou barogwato João Batista rakojere nono ia ture jorduwadowugebo. Ere pobetu je. ");
INSERT INTO bor_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nono jordure Jesusji. Merure awaraji. Nono João Batista akore: – Makudure boe ero pegareu mori čewu Pao Kurireu aku ovelha reo. ");
INSERT INTO bor_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nou ime pobedu doge emeardure nou João Batista bataruji dukeje eture Jesus rekodaji. ");
INSERT INTO bor_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus aiwore tuibagi dukeje jordure nou ime pobedu doge ekodure turegodaji duji. Unarare ei. Akore: – Kaba bagaiba taroino? Egore: – Čerduware jorduwareu nure aki duji. Kaiba amugure? ");
INSERT INTO bor_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus akore: – Mato itabo tarduwo. Merirekodutabore akoino ei. Nono eture Jesus apo. Erdure mugureuji. Eragojere apo nono nou meriji. ");
INSERT INTO bor_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nouia imedu iere André. Simão Pedro umana nure ema. ");
INSERT INTO bor_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ča uture Jesus piji tiemaru tabo tuwie Simão Pedro bagai. Jordure ji dukeje makore ji. Akore: – Čerdure umode boe ekinorudowuji. (Grego bataru tabore egore “Cristo” aino ji.) Pawobe epagare bagaiwu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nono André uture tuwie Simão Pedro apo Jesus ae. Etaregodure ae dukeje Jesus aiwore Simão Pedroji. Nono Jesus makore: – Akiere Simão. João onaregedu nure aki. Mare awu inodu otobiji akiemode Cefas. ");
INSERT INTO bor_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nou barogwato Jesus ure tumeardae tawuje tuduwo Galiléia moto ka. Nono jordure Filipiji. Makore ji. Akore: – Ako itabo. ");
INSERT INTO bor_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nou Filipe boture kejewu ba kurireu iere Betsaida. Nonore André, Pedro emugure jamedu. ");
INSERT INTO bor_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ča Filipe uture imedu Natanael bagai jamedu. Jordure ji dukeje Filipe makore ji. Akore: – Čerdure boe epagare bagaiwuji. Dujire Moisés ure maku Judeu doge etaiwu bakaru akoino. Dujire jaoboe emagore Pao Kurireu bataru jiwuge ere bu bapera keje jamedu. Iere Jesus. José onaregedu nure ema. Mugure kejewu ba kurireu iere Nazaré. ");
INSERT INTO bor_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mare Natanael akore: – Boe pemegareu aregodumodukare Nazaré piji. Mare Filipe akore: – Mato itabo arduwo. ");
INSERT INTO bor_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus jordure Natanael kodure pudae duji. Dukodire čare makore boei. Akore: – Judeu remawu nure ema. Marigudu ukare boe ekiripagado. ");
INSERT INTO bor_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael meardure Jesus akoinoduji. Nono akore: – Kočare arduware i na? Jesus akore: – Iorduware aragojere figo i paru akinaigodu duji. Dukejere Filipe aregodure akae. Iragojekare mare iorduware. ");
INSERT INTO bor_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nono Natanael akore: – Jorduwareu nure aki rugadu. Pao Kurireu Onaregedu nure aki rugadu. Israel doge eimijera kurireu nure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus makore ji pugeje. Akore: – Iorduware aragojere figo i paru duji dukodire ameartorure i. Iro biagareu reo. Iro kurimode rugadu kimo awu iro biagareu kori. ");
INSERT INTO bor_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nono Jesus makore nou boe dogei. Akore: – Boe jokodu jire inagoino tawiagai. Imedu Onaregedu remawu nure imi rugadu. Tardumode barure tuiado duji. Tardumode Pao Kurireu utugarege baru tadawugei etu pemegamode i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Merire pobe dukeje Jesus uture Caná ba kurireu ka ia boe emugure puapowuge ewadae ka. Caná ba kurireu mugure Galiléia moto keje. Jesus uče rakojere nou ba kurireu keje jamedu. Boe emagore Jesus bagai nou ure jorduwadowuge ewagai jamedu etuwo nou boe ewadae ka. Dukodire čare eture. ");
INSERT INTO bor_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eragojere nono ji je. Nono nou boe eke vinho kuru akedure. Dukeje čare Jesus uče makore nou tonaregeduji. Akore: – Vinho kuru akedu. ");
INSERT INTO bor_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus makore tuje bataru jipagi. Akore: – Pao Kurireu koiare umode imaragodae maku inai. Mare meri aregodukare ka raga iwo Pao Kurireu maragodae towuje. ");
INSERT INTO bor_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nono Jesus uče makore boe etugaregei. Akore: – Tarodo nono Jesus makore tai dumogadure. ");
INSERT INTO bor_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Poridoge enodo padu kejewugere seis nono pobo tabo nou boe ewo taimo Judeu doge turoiaji. Pobo oto padure 80 rabodu, oto padure 100 rabodu tu tu je nou pori jamedu boe etada. ");
INSERT INTO bor_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nono Jesus makore nou boe etugaregei. Akore: – Awu poridoge ekorau pobo tabo. Dukeje ere korobadudo rugadu pobo tabo. ");
INSERT INTO bor_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nono Jesus makore ei pugeje. Akore: – Ča nouia pobo tawuje tawo reko toro nou boe ewadae kejewu boe eimijera ae kuduwo če. Dukeje čare ere ia pobo tawuje nou pori piji. Ere reko toro nou boe ewadae kejewu boe eimijera ae. ");
INSERT INTO bor_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mare Jesus ure vinhodo nou poboče. Nono nou boe ewadae kejewu boe eimijera kudure če. Mare jorduwakare kaiba pijiba nou vinho kuru aregodure. (Mare nou boe etugarege erduware.) Dukodire čare nou boe ewadae kejewu boe eimijera makore nou uwiremodewu imedu bagai. ");
INSERT INTO bor_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Akore ji: – Vinho kuru pemegareure boe emode maku boetoji tuwadae keje. Vinho kuru pemegareu akedure dukeje boe emode vinho kuru mori bokwareu maku pugeje. Ainore boe erore. Aki čare are vinho kuru pemegareu maku aino boigodu. ");
INSERT INTO bor_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus ure vinhodo nou poboče. Boetojiwu turo rakareu jire roino nono nou Caná ba kurireu keje. Caná ba kurireu mugure Galiléia moto keje. Nonore ure boe erdudo turagare duji. Ure boe erdudo turo rakamode rugadu duji. Nono nou ure jorduwadowuge emeartorure ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nou turoino dupiji Jesus uture Cafarnaum ba kurireu ka tuje apo, tuwiemagebo, ture jorduwadowugebo jamedu. Rakojere nono du meri makakare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Boe puredugodure Judeu doge ewadumode ia tuwadae ji du ka. Nou ewadae iere Páscoa. Dukodire Jesus uture Jerusalém ba kurireu ka. ");
INSERT INTO bor_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aregodure toro dukeje ure turemo Pao Kurireu uwaito. Nonore jordure boe ere toe maku duji, ere tagu tapira doge, tagu ovelha doge, tagu metugoe emagu diero bagai jordure ere diero maku puai puibagi duji. ");
INSERT INTO bor_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus korigodure ei erore aino duji. Ure ia barogo birido nono bukigure. Dukeje čare ure nou boe doge eguie rugadu boe etudo nou Pao Kurireu uwai piji nou barogo biri bukigu tabo. Ure tapira doge etudo. Ure ovelha doge etudo. Ure nou boe enoe padure kejewu ira jamedu boe butudo tuwo nou eno diero jamedu boe barigu epiji moto ka. ");
INSERT INTO bor_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nono mako rakare nou ure metugoe emaguwugei. Akore: – Tadudo awu bai piji nou tagagu metugoebo. Tare Iogwa Kurireu uwaido nono boe makudure kejewu bai mogadure diero bagai tagoče. Tarokaba aino pugeje! ");
INSERT INTO bor_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nou Jesus ure jorduwadowuge ewiabuture Pao Kurireu bataru keje. Nou Pao Kurireu bataru akore: – Imeardu kurire Pao Kurireu uwaiji rugadu. Ietu pemegamode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judeu doge etaidukare nou Jesus rore jiboeji. Enarare ji. Egore: – Čemeartugure ai. Čegimijera karegure aki rabodu. Ča ia aro rakareu towuje čemeartoruwo ai rugadu. Aro rakareumode dukeje čegimijera mode aki arowo aino aro mogadure woe Pao Kurireu uwai tada. ");
INSERT INTO bor_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dukodi čare Jesus makore ei. Akore: – Awu Pao Kurireu uwai butudo. Nono merimode pobe metia bokware dukeje imode rakojedo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nou boe eimijerage emeartorukare ji. Egore: – Joru oto padure quarenta e seis boei ewo awu Pao Kurireu uwai iado. Merimode pobe metia bokware dukeje amodukare awu Pao Kurireu uwai towuje pugeje. ");
INSERT INTO bor_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mare Pao Kurireu uwai ji karega Jesus akoino. Tuwiri, tugodu jire akoino. Mare tuwimode du jire akoino merimode pobe metia bokware dukeje tuiewodumoduie pugeje. Du jire Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jewodure dukeje ure ture jorduwadowuge ewiabutudo awu tuwadaru keje. Dukodire emeartorure Pao Kurireu bataruji rugadu. Emeartorure Jesus bataru jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nono Jesus rakojere Jerusalém ba kurireu keje jii toro nou Judeu doge ewadae Páscoa akedu ka. Ro rakare nono. Boe erdure Jesus ro rakareuji dukeje emeartorugodure ji. ");
INSERT INTO bor_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mare Jesus jorduware nou boei emeartoru raimodukare pudui duji. Dukodire Jesus meartorukare nou boei. ");
INSERT INTO bor_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Boe ekare Jesus jorduwado nou boei. Jorduware boe eiamedu boe emeardaeji marigudu. ");
INSERT INTO bor_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ia Judeu doge eimijera iere Nicodemos. Fariseu nure ema. ");
INSERT INTO bor_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ia boečoji uture Jesus ae tumagowo ji. Akore: – Boe eimijera nure aki. Pao Kurireu ure akarego mato čedae rugadu. Ema koiare ure ado boe erduwado rugadu. Pao Kurireu rakojemodukare akabo dukeje aro rakamodukare. Mare aro rakare rugadu. Dukodire čerduware Pao Kurireu merure akabo rugadu duji. ");
INSERT INTO bor_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus akore: – Boe jokodu jire inagoino ai. Boe ewodumode pugeje kodire eimijeramode Pao Kurireuče pugeje turuduwo baruto. ");
INSERT INTO bor_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nono Nicodemos akore: – Nuba imedu romode tuwoduwo pugeje? Umodukare turemo tuje kurito tuwoduwo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Mare Jesus akore: – Boe jokodu jire inagoino ai. Boe ewodure tuje piji dukodire emugure woe moto keje. Pao Kurireu Uwari koiare umode boe ewodudo pugeje. Mare ewoduwo pugeje ji karega inagoino. Pao Kurireu Uwari umode boe edo tuwia ra tuiordae tumeardae pegareu piji. Dujire inagoino. Ure edo tuwia ra tuiordae pegareu piji dukeje epemegamode nono ure taimowu biri kabi dumogadure. Mare ewiri ji karega inagoino. Emeardae pegareu jire inagoino boe ewo barigu tubiji. Pao Kurireu Uwari umode emeardae pemegado ewo tugimijerado Pao Kurireuče turuduwo baruto. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dukodire inagoino ai awoduwo pugeje. Kodire apagudugodukaba awu iwadaruče. Boe rakakare ai arduwawo awu iwadaruji. ");
INSERT INTO bor_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ia iwadaru pugeje. Bakuru jomode taidureu ka. Boe emeardumode bakuru akoji mare erduwamodukare kaibowu pijiba nou bakuru aregodure. Boe erduwakare kaiba nou bakuru kodumode. Pao Kurireu Uwari rore nono bakuru mogadure. Mare bakuru ji karega inagoino. Pao Kurireu Uwari koiare umode boe emeardae pemegareu maku etai mare nou boe erduwakare kaibowu pijiba nou tumeardae pemegareu aregodure pudae. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nono Nicodemos akore: – Nuba akagore jiboe mode boei? ");
INSERT INTO bor_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus akore: – Israel doge eimijera nure aki. Are erduwado Israel doge eno bakaruji. Kodiba arduwakare inagoino jiboeji? ");
INSERT INTO bor_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Boe jokodu jire inagoino. Imagore iorduware jiboeji tawiagai. Ireadodure iordure jiboeji tawiagai. Mare taiamedu boe tameartorukare iwadaruji. ");
INSERT INTO bor_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Imagore awu moto kejewu boeji tawiagai mare tameartorukare ji. Imagomode baru tadawu boeji tawiagai jamedu dukeje tameartorumodukare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Imedu Onaregedu nure imi. Iragojere baru tada marigudu. Iaboe iaboe erudukare baruto rugadu. Itaregodure baru piji mato moto ka. ");
INSERT INTO bor_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","– Marigudu Israel doge eragojere toro boe maereu keje dukeje Moisés ure ia merirido nono awagure ipo oto keje. Imedu Onaregedu padumode ipo keje nono nou awagu umogadure. ");
INSERT INTO bor_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nono meartorure iwuge emugumode Pao Kurireu apo rugadu. Du akedumodukare rugadu. Ewimodukare pugeje. ");
INSERT INTO bor_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pao Kurireu meardu kurire boei rugadu. Dukodire ure tonaregedu mitodu rawuje baru piji mato boe etae. Meartorure jiwuge eiamedu boe ewimodukare pugeje. Meartorure jiwuge emugumode Pao Kurireu apo rugadu. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pao Kurireu ure tonaregedu rawuje mato moto ka mare tuwo boe ero pegareu morido. Ukare rawuje uwo boe pegado boei. Mare ure rawuje tuwo boe ekinorudo etukawo bope doge eda kejewu joru pegareu ka. ");
INSERT INTO bor_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","– Pao Kurireu umodukare meartorure iwuge boe pegado ei. Mare meartorukare iwugeire Pao Kurireu umode edo turo pegareu morido rugadu. Pao Kurireu Onaregedu mitodu nure imi. ");
INSERT INTO bor_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","21","Nou ro pegareuge etaidukare joruguji. Emodukare tuburedo ji. Boečo jire etaidure turo pegawo boe erdukawo turoino duji. Mare ro pemegareuge emode tuburedo joruguji urugu pemegawo pudui boe erduwo tumeartorure Pao Kurireu jituji. Čare jorugu pemegareu aregodure moto ka. Mare jorugu ji karega inagoino. Ire inagoino. Mare kočare boe emeardu kurire boečoji jorugu piji. Mare boečo ji karega inagoino. Nou boe ero pegareu jire inagoino emeardu kurire turo pegareuji kodi. Etaidukare tumeartoruwo i rugadu. Dukodire Pao Kurireu umode edo turo pegareu morido rugadu. ");
INSERT INTO bor_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nonore Jesus uture ture jorduwadowugebo toro Judéia moto ka. Nonore rakojere jii je. Ure boe etao pegodo nono. ");
INSERT INTO bor_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João Batista ure boe etao pegodo jamedu boe eda Enom keje. Padu puredure boe eda Salimji. Pobo kurireu mugure nono. ");
INSERT INTO bor_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Boe eimijera pegareu ukare João Batista tugu baičoreuto raga.) ");
INSERT INTO bor_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","João Batista ure jorduwadowuge emago raire ia Judeu imeduji. Emeardaekare nono pumeardae mogadure tuwo taimo turoiaji tuwo turemo Pao Kurireu uwaito. Dujire emago raire pui. ");
INSERT INTO bor_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nono čare eture João Batista ae tumagowo ji. Egore: – Jorduwareu nure aki. Awiabuture čowu rakojere toro Jordão po okwa bakowu kejewu imedu keje? Rakojere pagabo toro. Amagore nou imedu paru tabo čei. Ča unure boe etao pegodo jamedu nono paro mogadure. Dukodi čare boe eture toro ae čebiji. ");
INSERT INTO bor_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João Batista makore nou ture jorduwadowugei. Akore: – Boe emodukare boe pemegado pudui tao biji. Tu Pao Kurireu koiare umode boe pemegado boei rugadu. ");
INSERT INTO bor_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tarduware iwadaruji. Ire tawie marigudu. Inagore: – Pabagare bagaiwu umode boe ekinorudowu karegure imi. Pao Kurireu koiare ure itarego umode boe ekinorudowu otodai. ");
INSERT INTO bor_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Imedu ure timedia bie tuwiremoduie duji. Dukodire metia ure boe pemegado timedia togi timedia uwiremode dukodi dukeje boe ewadumode. Ure boedo turugadu dukeje upagare nou uwiremodewu bagai. Meardure uwiremodewu kudu jitu dukeje jakaregodumode pudui rugadu. Ire nono nou uwiremodewu metia mogadure. Ire boedo turugadu Jesus aregodumode kodi. Čare aregodure dukodire iagarere i rugadu nono nou uwiremodewu metia mogadure. Jesus ro pemegare boei dukodire iagarere i. Ure boe etao pegodo dukodire iagarere i. ");
INSERT INTO bor_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Boe etaidu kurimode ji rugadu. Ewiagodumode ipiji. Du pegakare i rugadu. Ure turugadu iagai. ");
INSERT INTO bor_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","João Batista mako kimore. Akore: – Aregodumode baru pijiwu ro kurimode paiamedu boe kori. Boture moto kejewu jorduware moto kejeboe jamedu boeji. Makomode moto keje boeji. Mare aregodure baru pijiwu ro kurimode moto kejewu eiamedu boe ekori. ");
INSERT INTO bor_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Makomode tuiordure jiboeji tumeardure jiboeji boe ewiagai mare emeartorumodukare ji. ");
INSERT INTO bor_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mare meartorure bataru jiwuge erduware boe jokodu jire Pao Kurireu akoino duji. ");
INSERT INTO bor_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pao Kurireu Uwari umode tugera maku nou Pao Kurireu ure arego matowu tonaregedu ai. Dukodire nou aregodure matowu makomode Pao Kurireu bataruji boe ewiagai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pao Kurireu meardu kurire nou tonaregeduji rugadu. Dukodire ure turaga jamedu boe maku tonaregedu ai rakawo nono turaga mogadure. ");
INSERT INTO bor_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nono nou meartorure Onaregedu jiwuge emugumode Pao Kurireu apo rugadu jii toro rugadu. Dukodire etagedumodukare. Ewimodukare pugeje. Mare meartorukare nou Pao Kurireu Onaregedu jiwuge emugumodukare Pao Kurireu apo jamedu. Pao Kurireu ro pegamode ei jamedu. Nou ro pegare eidu akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseu doge emeardure Jesus ure boe etao pegodo duji. Emeardure nou Jesus ure jorduwadowuge emagagodure nou João Batista ure jorduwadowuge epiji. ");
INSERT INTO bor_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ča Jesus ukare boe etao pegodo. Nou ure jorduwadowuge eigoiare ere boe etao pegodo.) ");
INSERT INTO bor_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nono Jesus jorduware nou fariseu doge emeardaeji. Dukodi čare uture Judéia moto piji tuduwo tuibagi pugeje Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kodure Samaria moto oiagi tuduwo Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dukeje aregodure Sicar ba kurireu ka. Nou Sicar ba kurireu mugure nou Samaria moto keje rugadu. Marigudu jawu Israel doge etuo Jacó ure ia moto maku tonaregedu José ai. Nou Sicar ba kurireu padu jakare nou motoji. ");
INSERT INTO bor_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nou Jacó ure porodowu kačiba mugure nono jamedu. Ča Jesus metugodure dukodi čare ure tuwuredo nono nou kačiba keje. Ure tumugudo nono tuwo tamudo. Meri aregodure pagaia ka dukeje. ");
INSERT INTO bor_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mare nou Jesus ure jorduwadowuge eture otodai nou ba kurireu ka tuwo akirodo tugeji. Jesus mugure nou kačiba po okwai ture tamudo dutabo. Nono ia Samaria kejewudo aredu aregodure pobo bagai nou kačiba po ka. Jesus makore ji. Akore: – Pobo maku inai ikuduwo če. ");
INSERT INTO bor_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nono nou aredu makore: – Judeu nure aki. Imire Samaria kejewudo nure imi. Judeu doge etaidukare čei rugadu. Ekudumodukare poboče čegopo tabo. Enogwagemodukare čeno meriri keje jamedu. Aki čare amagore i pobo bagai akuduwo če. ");
INSERT INTO bor_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus makore: – Arduwakare Pao Kurireu ure maku boe etai boeji. Arduwamode i rugadu dukeje akogwamagudumode i pobo remawu bagai awikawo. ");
INSERT INTO bor_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nou aredu akore: – Are pobo tugu toboe bokware. Pobo padu jaere čemoroi nou kačiba ja tada. Nuba aromode awo akeragu nou akagoino jiwu pobo remawuji? ");
INSERT INTO bor_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jao pawobe etuo Jacó koiare ure awu kačiba towuje. Dukodire pagore aino ema. Emare kudure awu poboče boetoji. Ore ekudure awu poboče. Aku ie ekudure awu poboče jamedu. Ji aino pobore kimo. Aro kodumodukana nou Jacó ro kori? Nuba aromode awo ia pobo maku čenai pugeje? ");
INSERT INTO bor_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus akore: – Boe ekudumode awu poboče mare pobo boeimode ei pugeje. ");
INSERT INTO bor_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mare boe ekudumode ire maku etaiwu poboče dukeje pobo boeimodukare ei pugeje jii toro rugadu. Kačiba mugumode etada kodire nou etadawu pobo akedumodukare epiji rugadu. Mare pobo ji karega Jesus akoino. Boe emeartorumode Jesus ure maku pudaiwu tuwadaruji dukeje ewimodukare pugeje. Jesus umode emugudo Pao Kurireu apo. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mare nou aredu meardaere pobo remawu ji rugadu Jesus akoino. Akore: – Nou akagoino jiwu pobo maku inai ikuduwo če pobo boeikawo i pugeje itaregodukawo woe pugeje pobo bagai. ");
INSERT INTO bor_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus akore: – Toro. Atudo awo akoredu bie. Dukeje amode akirimi mato pugeje. ");
INSERT INTO bor_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aredu akore: – Ikogekare. Itoredu bokwa. Jesus akore: – Uu. Iorduware. Akogere mare are akera ra epiji. ");
INSERT INTO bor_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Akogere ikera aboudure. Aino čare amugure ia apo pugeje mare akoredu karegure ema. Awadunure ji. Boe jokodu jire akagoino iwiagai. ");
INSERT INTO bor_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nou aredu akore: – Kočare arduware i rugadu! Jorduwareu nure aki rugadu. Makore Pao Kurireu bataru jiwu rabodunure aki rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jao iwobe Samaria kejewuge ere tubu jodo tumago pemegawo Pao Kurireuji woe awu tori aogeje. Judeu doge tagire tagagore awu čerore jiboe ukaie turugadu. Tagagore tu Jerusalém ba kurireu kejeie boe emode tubu jodo tumago pemegawo tu Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus akore: – Ameartorudo awu iwadaruji. Tu awu tori aogeje karega boe emode tubu jodo tumago pemegawo Pao Kurireuji. Tu Jerusalém ba kurireu keje karega boe emode tubu jodo tumago pemegawo Pao Kurireuji. Kuri aino boe emode tubu jodo moto keje moto jamedu boe parugajeje tumago pemegawo Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria kejewuge nure tagi. Tamago pemegare Pao Kurireuji mare tarduwakare ji. Judeu doge nure čegi. Čerduware Pao Kurireuji. Ure Judeu doge ewie marigudu tumoduie boe ekinorudo duji. ");
INSERT INTO bor_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kuri aino Pao Kurireu Uwari umode boe eragado emago pemegawo Pao Kurireuji rugadu. Erduwamode Pao Kurireu meardae remawuji rugadu dukodire emode tubu jodo tumago pemegawo Pao Kurireuji rugadu boe remawu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pao Kurireu ure nono tuwari mogadure. Dukodire boe erdukare ji. Kodire boe emodukare tuwadaru udo paga paga tumago tabo Pao Kurireuji. Pao Kurireu Uwari koiare umode boe erduwado Pao Kurireu meardae pemegareuji ewo tubu jodo tumago pemegawo Pao Kurireuji boe remawu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nou aredu makore Jesusji: – Iorduware umode boe ekinorudowu aregodumoduie duji. Aregodumode dukeje umode parduwado boe jamedu boeji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus akore: – Nou akagoino jiwu umode boe ekinorudowu nure imi rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ča nou Jesus ure jorduwadowuge etaregodure ba kurireu piji tuibagi. Erdure Jesus makore nou aredu jituji dukodi čare eku kidure ei. Ere tumagoiago nou areduji kaboba bagaiba roino. Mare emagokare. Ere tumagoiago Jesusji jamedu kodiba akoino nou areduji. Mare emagokare. ");
INSERT INTO bor_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ča nou aredu uture tubori piji toro ba kurireu ka tuibagi. Aregodure ba kurireu ka dukeje makore boei. ");
INSERT INTO bor_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Akore: – Mato itabo tarduwo ia imedu kurireuji. Emare jorduware mariguduwu irore jiboe jamedu boeji rugadu. Ema koia kana umode boe ekinorudo? Ema kana pabagare bagai marigudu? ");
INSERT INTO bor_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dukodi čare nou boe eture nou aredu apo ba kurireu piji toro Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nou aredu rakoje kimore toro ba kurireu tada dukeje nou Jesus ure jorduwadowuge emagore Jesusji. Egore: – Akwagedo. ");
INSERT INTO bor_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mare Jesus akore: – Ire ia tarduwakare jiwu ike rogu kowuje. ");
INSERT INTO bor_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dukeje nou ure jorduwadowuge emagore pui. Egore: – Ia boe etaregodu kana ia tuge tabo tuwo maku ai? ");
INSERT INTO bor_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mare Jesus akore: – Boe eke ji karega inagoino. Pao Kurireu koiare ure itarego mato. Imeartorure bataruji kodire umode iraga maku inai. Imode ure maku inaiwu imaragodae iado rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Boe egore: “Arimode pobe puibiji dukeje boe eno boepa tadaboe kurodumode.” Tagaiwodo boe dogei. Ere turugadu tumeartoruwo Pao Kurireuji marigudu rugadu. Ere nono boepa tadawu kurodureboe mogadure. ");
INSERT INTO bor_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Boe emode tugeragu kurodureboe jitu keje emaragodae mori makudumode etai. Mare boepa tadaboe ji karega inagoino. Boe emode Pao Kurireu bataru maku boe etai dukeje Pao Kurireu umode emaragodae mori maku etai jamedu. Boe emagare tumaragodae tabo tuwo boe emeartorudo Pao Kurireuji rugadu emuguwo Pao Kurireu apo baru tada jii toro rugadu, ewikawo pugeje. Boe emeartorure Pao Kurireu bataruji dukeje nou ure Pao Kurireu bataru maku boe etaiwuge eiamedu boe egaremode pudui rugadu. Egaremode pudui nono nou ure boepa tuguwu jakarere pudui dumogadure. Egaremode pudui nono nou ure tugeragu kurodureboe jiwu jakarere pudui dumogadure. ");
INSERT INTO bor_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Boe jokodu jire boe egoino: “Ia imedu umode to boepa tugu. Ia umode kurodu rawuje.” ");
INSERT INTO bor_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ča tare nono nou umode kurodureboe rawujewu mogadure. Mare boepa tadaboe ji karega inagoino. Tadumodukare boepa ka. Boeire inagoino. Inure tadudo iwadaru tabo boe etae rugadu. Iage ere nou boe erduwado Pao Kurireu bataruji tuwo edo turugadu emeartoruwo i. Aino ča tadumode iwadaru tabo etae emeartoruwo i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ča nou aredu makore nou Samaria kejewu boe ewiagai Jesus bataruji dukodi čare emeartorure Jesusji rugadu. Akore: – Emare jorduware mariguduwu irore jiboe jamedu boeji rugadu. Dukodire nou ba kurireu kejewuge emeartorure Jesusji rugadu. Emagare. ");
INSERT INTO bor_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nono nou Samaria kejewuge etaregodure Jesus ae. Enogwamagudure Jesusji muguwo pudabo jao. Dukodire merire pobe Jesusji toro ebo. ");
INSERT INTO bor_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesus ure erduwado dukodi čare boe emagare nono apo tumeartorure jitu tabo. ");
INSERT INTO bor_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Emagore nou areduji. Egore: – Aino čare pameartorure ji rugadu. Are čewie marigudu. Mare aino čewiapagare ji rugadu. Čewiapagare bataruji dukodire čemeartorure ji. Čerduware emaie umode boe ekinorudo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Merire pobe Jesusji nono nou ba kurireu keje. Dukeje uture pugeje Galiléia moto ka. ");
INSERT INTO bor_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Marigudu akore: – Makore Pao Kurireu bataru jiwu makomode Pao Kurireu bataruji boe eiamedu boe ewiagai. Mare turijodure kejewu moto kejewuge etaidumodukare makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesus aregodure Galiléia moto ka dukeje nou boe ekimadure apo. Judeu doge ewadae Páscoa kejere Jesus ro rakare Jerusalém ba kurireu keje. Awu Galiléia kejewuge edure nono jamedu dukodire erdure Jesus rore jiboeji. Dukodire egarere pudui Jesus aregodure pudae duji. ");
INSERT INTO bor_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dukejere Jesus uture pugeje Caná ba kurireu ka. Marigudu ure pobo udo vinho kuruče nou Caná ba kurireu keje. Ia Cafarnaum ba kurireu kejewu boe eimijera rakojere nono Caná ba kurireu keje jamedu. Onaregedu kogodure toro Cafarnaum keje. ");
INSERT INTO bor_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jorduware Jesus aregodure Judéia moto piji Galiléia moto ka. Dukodire uture ae. Okwamagudure Jesusji tonaregedu paru tabo ure tuwiago kodi. Aidure Jesus utuwo Cafarnaum ba kurireu ka uwo nou tonaregedu pemegago. ");
INSERT INTO bor_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus akore ji: – Taiamedu boe tagaidure tarduwo ia iro rakareuji tameartoruwo i. ");
INSERT INTO bor_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nou boe eimijera akore: – Ikimijera nure aki. Itonaregedu bimode. Mato itabo awo itonaregedu pemegago. ");
INSERT INTO bor_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus akore ji: – Toro. Atudo akinai. Akanaregedu pemegagodumode. Nou boe eimijera meartorure Jesus bataruji dukodire uture. ");
INSERT INTO bor_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nou barogwato nou boe eimijera kodu kimore awaraji dukeje ia utugarege etaregodure togi. Ere bie. Egore: – Akanaregedu pemegagodure. ");
INSERT INTO bor_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Unaragodure kaiba meri jeture dukejeba tonaregedu pemegagodure. Egore: – Jao meriji meri aregodure pagaia ka dukeje biri uru akedure piji. ");
INSERT INTO bor_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nono nou boe eimijera biabuture meri aregodure pagaia ka dukeje Jesus akore tonaregedu pemegagodumoduie. Meri aregodure pagaia ka dukeje pemegagodure rugadu. Dukodire nou boe eimijera meartorure Jesusji tuwobe eiamedu boe ebo. ");
INSERT INTO bor_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus ro rakareu boetojiwu koiare ure vinhodo poboče. Aino aregodure Judéia moto piji Galiléia moto ka pugeje. Dukeje ure nou boe eimijera onaregedu pemegago. Dukodire boe erdure Jesus ro rakareu ure pobetu je nono Galiléia moto keje duji. ");
INSERT INTO bor_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nono Jesus uture Jerusalém ba kurireu ka. Uture tuwaduwo ia Pao Kurireu bowadaeji Judeu dogebo. ");
INSERT INTO bor_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalém kejewu ia baiporo ri iere “Ovelha”. Ia brae etaimoda kejewu pobo puredure nou bai poroji. Hebreu bataru tabo nou brae etaimoda iere “Betezata”. ");
INSERT INTO bor_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Boe emagare tubadu nono dutabo nouia bai koadureu tada nou bai koadureuge enodo padure kejewugere ikera aboudure. Ekogodure kodi. Iage eku bokware. Iage epogora pegare. Emeru bokware. Epadure nono tubaga tabo nou brae etaimoda tadawu pobo magadugoduwo tuwo turemo nou poboto tubemegagoduwo. Nou pobo magadugodu paga karegure. Ia Pao Kurireu utugare baru tadawu koiare ure pobo magadudo toro ia meri keje. Meri jamedu boeji karega nou pobo magadugodumode. Pobo magadugodure dukeje nou ure taredo boetojiwu pobo towu pemegagodure. ");
INSERT INTO bor_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Joru oto padure kejewure ure trinta e oito ia imedu kogodureuji tubaduie nono dutabo. Pogora pegare dukodire meru bokware. ");
INSERT INTO bor_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus jordure padure nono duji. Jorduware nou imedu kogodure marigudu rugadu. Dukodire unarare ji. Akore: – Akaidure apemegagoduwo? ");
INSERT INTO bor_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nou kogodureu imedu akore: – Uu. Itaidure. Mare iroiwakare iwo iremo nou poboto ipemegagoduwo. Awu pobo magadugodure dukeje ia kogodureu ure taredo nou poboto itododai tu tu je tubemegagoduwo. Nou pobo magadugodure dukeje umode boe epemegago. ");
INSERT INTO bor_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus makore ji. Akore: – Aragojedo. Amerudo. Akeragu akudau kodoji atuwo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dukodi čare nou imedu pemegagodure tači rugadu. Ure turagojedo. Ure tugeragu tugudau kodoji. Dukeje uture tumeru tabo rugadu. Sábado meri kejere Jesus rore aino ji. ");
INSERT INTO bor_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ča Judeu doge eimijerage erdure nou imeduji dukeje ekorigodure ji. Egore: – Amerure aino akudau kodo tabo Sábado meri keje du pegare rugadu. Arokaba aino pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nou imedu akore: – Ure ipemegadowu imedu makore i iwo ikeragu awu ikudau kodoji imeruwo tabo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nou boe eimijerage egore: – Duba koiaba ure arodo aino? ");
INSERT INTO bor_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mare nou imedu jorduwakare Jesusji. Jesus ure pemegago dukejere uture piji. Boe emagare nono dukodire nou imedu jordukare uture tubiji duji. Dukodire makokare ji pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Merirekodutabo Jesus jordure nou imeduji pugeje Pao Kurireu uwai tada. Jesus makore ji. Akore: – Awiapaga pemegado iwadaruji. Apemegagodure. Mare akera ra aro pegareu piji jamedu. Amodukare akera ra aro pegareu piji dukeje boe pegamode ai pugeje du kodumode awu boetojiwu akogodae kori rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nono nou imedu uture Jesus piji Judeu doge eimijerage etae. Ure ewie Jesus ieji. Makore ema koiaie uie tubemegago. ");
INSERT INTO bor_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nono nou boe eimijerage erdu pegare Jesus rore aino duji. Etaidukare Jesus ure nou imedu pemegago sábado meri keje duji. Erokare aino kodi. Egore boe ekaiago boe epemegado sábado meriji. Dukodire etaidure tuwo boe pegado Jesusji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mare Jesus makore ewadaru jipagi. Akore: – Iogwa maragodure meri jamedu boeji. Iromode aino jamedu. ");
INSERT INTO bor_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ainore Jesus rore rugadu. Judeu doge eromodukare ia turore jiboeji sábado meriji. Edu pagamode tu tumuga keje rugadu. Mare Jesus meartorukare nou erore jiboeji. Jesus akore tuoie Pao Kurireu rema. Akore aino dutabo akore Pao Kurireu nuie pudumi jamedu. Mare nou Judeu doge eimijerage erdu pegare akoinoduji. Dukodire čare ekorigodure ji. Ere tumeardae tawuje tuwo Jesus bito. ");
INSERT INTO bor_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nono Jesus makore nou Judeu doge eimijeragei. Akore: – Boe jokodu jire inagoino tawiagai. Pao Kurireu Onaregedu romodukare ia boeji tumeardae tabo. Jordumode Tuo Kurireu roji dukeje romode nono nou Tuo ro mogadure. Onaregedu romode nono Tuo ro mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Awu Pao Kurireu Onaregedu nure imi. Iogwa meardu kurire i. Dukodire ure iorduwado turo jamedu boeji irowo nono turo mogadure jamedu. Ča Iogwa ro kurimode nou turo kori pugeje. Umode iorduwado nou turo kurireuji irowo ji jamedu. Tardumode nou iro kurireuji dukeje taebogodumode i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Iogwa Kurireu umode bireuge eewodudo pugeje tuwo emugu pemegado turo pegareu piji. Onaregedu nure imi. Imode itaidure jiwuge emugu pemegado ero pegareu piji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Iogwa Kurireu aiwomodukare boe ero pegareu bagai. Ure boe eimijerado imi. Dukodire imire itaiwomode boe ero pegareu bagai. ");
INSERT INTO bor_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Itaiwomode boe ero pegareu bagai dukodire boe emode ikie kurido nono ere Iogwa Kurireu ie kurido dumogadure. Mare mako pemegakare iwu mako peganure Iogwaji jamedu. Iogwa koiare ure itarego mato boe etae. ");
INSERT INTO bor_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","– Boe jokodu jire inagoino. Iogwa Kurireu ure itarego mato boe etae. Ewiapagamode iwadaruji dukeje emeartorumode Iogwa Kurireuji jamedu. Dukeje emugumode Iogwa Kurireu apo jii toro rugadu. Du akedumodukare. Emeartorumode Iogwaji dukeje umodukare boe pegado boei. Boe ero pegare dukodire ewimode. Dukodire ere nono bireuge emogadure. Mare emeartorumode Iogwaji dukeje ewimodukare pugeje. Emugu pemegamode Iogwapo rugadu jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Boe jokodu jire inagoino tawiagai. Pao Kurireu ure tawie marigudu bireuge emeardumoduie Tonaregedu bataruji. Pao Kurireu Onaregedu nure imi rugadu. Tare nono bireuge emogadure. Ča tameardure iwadaruji. Tameartorumode iwadaruji dukeje tamodukare nono bireugere pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iogwa Kurireu koiare ure boe etowuje erijodudo. Emare jeture boei kodi. Ema koiare ure tonaregedu rakado uwo boe etowuje jamedu. Emare jeture boei jamedu. ");
INSERT INTO bor_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pao Kurireu Onaregedu nure imi. Imedu Onaregedu nure imi. Dukodire Iogwa ure boe eimijerado imi itaiwowo boe ero pegareu bagai ewo turo pegareu morido rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ia meri keje bireuge eiamedu boe eewodumode pugeje bireuge eda piji. Ro pemegareuge eewodumode pugeje. Nono ewimodukare pugeje. Emugu pemegamode Iogwapo. Du akedumodukare. Ro pegareuge eewodumode jamedu mare imago pegamode erore jiboeji dukeje ewarigudumode bope doge eda kejewu joru pegareuto boe pegawo ei jii toro rugadu. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesus mako kimore. Akore: – Imi karega ire boe eimijerado imi. Iromodukare itaidure jiboeji itaobiji. Dukodire imeardae karega mare Pao Kurireu koiare ure imeardae maku inai itaiwowo boe ero pegareu bagai. Pao Kurireu koiare ure itarego woe. Dukodire iromode aidure jiboeji tu tu je rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mare imagomode boei iro pemegaie dukeje emeartorumodukare i. ");
INSERT INTO bor_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mare Pao Kurireu makore boe ewiagai iro pemegaie. Boe jokodu jire akoino. ");
INSERT INTO bor_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Boe jokodu jire João Batista akoino jamedu. Tare boe etudo ae. Ure tawie iromode jiboeji marigudu. ");
INSERT INTO bor_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Itaiwokare mako pemegare iwuge ewadaru bagai iwo tameartorudo i. Pao Kurireu uwo tawie irore jiboeji du pegakare. Mare ire tawiabutudo João Batista bataru keje. Makore boe ewiagai iro pemegamoduie tai duji tameartoruwo i iwo taginorudo boe pegareu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João Batista bataru ure nono jorugu mogadure. Mare jorugu karega. Ure tarduwado. Tagaidure bataruji ia ari keje. ");
INSERT INTO bor_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","João Batista makore tawiagai i boeji. Mare iro pemegareu, iro rakareu, umode tarduwado i rugadu. Iogwa Kurireu ure iragado iro rakawo rugadu. Iro rakamode dukeje tarduwamode Iogwa Kurireu koiare ure itarego mato boe etae duji. ");
INSERT INTO bor_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Iogwa Kurireu koiare ure tawie iromode jiboeji. Ure itarego mato mare marigudure tardukare ji. Marigudu tameardukare makoji. Tameartorukare ji jamedu dukodire tagare Iogwa Kurireu bataru metudo tagaora tada. Tawiagodure piji. ");
INSERT INTO bor_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tagaiwore Pao Kurireu bataru padure kejewu baperaji. Tameardaere nou taro koiare umode tamugu pemegado Pao Kurireu apo tawikawo pugeje. Mare nou tagaiwore jiwu Pao Kurireu bataru unure tawie irore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mare tagaidukare tarduwawo i tagaidukare tameartoruwo i. Tameartorumode i dukeje tamugu pemegamode Pao Kurireu apo jii toro rugadu. Dukodi tawimodukare pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","– Itaiwokare mako pemegare iwuge ewadaru bagai. ");
INSERT INTO bor_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iorduware tai rugadu. Tawiapagakare tameardu kuriwo Pao Kurireuji pugeje. ");
INSERT INTO bor_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iogwa Kurireu koiare ure boe eimijerado imi. Du inodu tabo tameartorukare i. Ia imedu aregodumode tagae. Umode boe eimijerado pudumi dukeje tameartorumode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tagaidure boe emago pemegare tai duji boe ebogoduwo tai. Mare tagaidukare tawiapagawo Pao Kurireu bataruji tameartoruwo ji mako pemegawo tai. Ča. Tameartorumodukare i jamedu. ");
INSERT INTO bor_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mare imago pegamodukare tai Iogwa Kurireu biagai. Tagaidure jawu Judeu doge eimijera Moisés bataruji. Mare emare mako pegamode tai Pao Kurireu biagai tameartorukaie i. ");
INSERT INTO bor_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tameartorumode Moisés bataruji rugadu dukeje tameartorumode i jamedu. Emare makore irore jiboeji. Ure nou tuwadaru bu bapera keje. ");
INSERT INTO bor_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mare tameartorukare nou padure bapera kejewu Moisés bataruji dukodire tameartorumodukare iwadaruji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Jesus ro rakare rugadu. Ure kogodureuge epemegago. Nono Jesus kurugodure nou Galiléia pobo maereu bakowu ka ture jorduwadowugebo. Nou pobo maereu iere Tiberíades jamedu. Boe eture Jesus rekodaji. Emagare rugadu. Erdure Jesus ro rakare jiboeji dukodire eture rekodaji. ");
INSERT INTO bor_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Etaregodure bakowu ka dukeje Jesus ruture ia tori ao ka. Nonore ure tumugudo ture jorduwadowugebo. ");
INSERT INTO bor_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judeu doge ewiapagagodure tuwadae Páscoaji mare nou meri kodu mai kimore nou ewadae ka. ");
INSERT INTO bor_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus aiwore tubiji dukeje jordure boe doge ekodure pudae duji. Emagare rugadu. Nono unarare Filipiji. Akore: – Kaiba pagodumode pawo pageragu boe ekeji awu boe doge ekeje? ");
INSERT INTO bor_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus jorduware tumeardaeji marigudu. Du inodu tabo unarare Filipiji tuiorduwo Filipe meartorumode pudui dubagai. ");
INSERT INTO bor_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe akore: – Awu boe emagare rugadu. Pamode pageragu boe ekeji eiamedu boewo kowuje mare mori kurimode rugadu. Imedu maragodumode kejewu ari oto padumode oito dukeje o diero mode tuwo akirodo boe ekeji. ");
INSERT INTO bor_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jesus ure jorduwadowu ia imedu iere André. Simão Pedro uwie nure ema. ");
INSERT INTO bor_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","André akore: – Čege amireu ure ikera aboudure woe ia imedu rogu apo. Čege karo rogu ure pobe apo jamedu. Mare awu boe eke rogu aregodumodukare enodo ka emagare rugadu kodi. ");
INSERT INTO bor_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Boebutu pemegareu jeture nono dukodire Jesus akore: – Tamagodo awu boei ewo tumugudo nou boebutu keje. Nono nou boe doge eiamedu boe ere tumugudo nou boebutu keje. Ime doge enodo padu kejeboere cinco mil nono. ");
INSERT INTO bor_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus ure tugeragu nou imedu rogu uke amireu roguji. Imadure Pao Kurireu apo nou amireu paru tabo. Dukeje čare ure kado puiato. Ure maku nou boe doge etai. Boe eiamedu boe ere tugeragu ji. Rorino nou kare kugurei jamedu. Ure kado puiato dukeje ure maku etai jamedu. Boe eiamedu boe ere tugeragu ji. Nou boe eiamedu boe enogwagere rugadu. Ere ko jii toro tuguredu ka. ");
INSERT INTO bor_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ekuredure dukeje Jesus makore ture jorduwadowugei. Akore: – Tageragu nou boe eke koboji. Tagaba barigu. ");
INSERT INTO bor_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dukodire nou Jesus ure jorduwadowuge ere tugeragu nou boe eke koboji boe epiji. Ere kadarabo doge korau nou boe eke kobo tabo. Nou kadarabo enodo padu kejeboere doze nou boe eke kobo tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nou boe doge erdure nou Jesus rore aino duji dukeje emagore pui. Egore: – Makore Pao Kurireu bataru jiwu nure ema rugadu. Boe epagare bagai marigudu. Marigudu Pao Kurireu ure boe ewie ia makore Pao Kurireu bataru jiwu aregodumoduie boe etae. Aino čare aregodure boe etae rugadu. Ema rugadu. Pao Kurireu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ere turagado tuwo tugeragu Jesusji tugimijera kurireuwo ema. Mare Jesus jorduware emeardaeji. Dukodire uture epiji turagojewo tuginaigodu toro ia tori aogeje. ");
INSERT INTO bor_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nou boečoji Jesus ure jorduwadowuge eture pobo maereu okwa ka. ");
INSERT INTO bor_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ere turemo ika kurireuto tugurugoduwo pobo maereu kajeje toro Cafarnaum ba kurireu ka. Ča boečodure ei rugadu. Jesus aregodukare etae raga. ");
INSERT INTO bor_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ekurugodu kimore nou pobo maereu kajeje dukeje bakuru rakareu aregodure etogi. Dukodire nou pobo jetu rakare nou ika kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Traiga tabore nou Jesus ure jorduwadowuge emaragodure traiga tabo ika kurireuji. Ekodu ja kimore nou pobo maereu okwaji dukeje erdure Jesus merure pobo ao jituji. Kodu mato etae ika kurireu ka. Nou ure jorduwadowuge epagudugodure če rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mare Jesus makore ei. Akore: – Tabagudukaba. Imire iroino! ");
INSERT INTO bor_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dukodi čare epagudu akedure. Ere udo turemo ika kurireuto pudabo. Dukeje čare erore puku etaregodure toro nou turoino kaboe ka duji. ");
INSERT INTO bor_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nou barogwato nou boe doge edu kimore toro nou pobo maereu bakowu keje. Erduware ika kurireu ure mitotu je duji. Erduware Jesus kodukare ture jorduwadowugebo duji. Nou Jesus ure jorduwadowuge eture ika kurireu tabo Jesus piji. ");
INSERT INTO bor_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Dukeje čare ia boe etaregodure nou boe etae ika kurireu tabo jamedu. Etaregodure Tiberíades ba kurireu piji. Ika kurireuge ebore etaregodure. Etaregodure dukeje erudure Jesus ure boe eke maku boe etaiwu tori ao ka. ");
INSERT INTO bor_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mare Jesus rakojekare nono. Ure jorduwadowuge eragojekare nono jamedu. Dukodi čare nou boe eture tuibagi pobo maereu okwa ka. Ere taredo ika kurireugeto dukeje eture Cafarnaum ba kurireu ka taiwo tabo Jesus bagai. ");
INSERT INTO bor_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nou boe erdure Jesusji nou pobo maereu okwa bakowu keje dukeje eture ae. Egore: – Nuba arore akaregoduwo woe? ");
INSERT INTO bor_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus akore: – Boe jokodu jire inagoino. Tare ire maku tagaiwu amireu kowuje dukodire taguredure. Dukodire taemarure iwagai pugeje. Mare tarduwakare imeardaeji. Tarduwakare kodiba iro rakare aino duji. ");
INSERT INTO bor_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tawiapagakaba tu tage bagai. Pegamode. Mare tawiapagado tu baru tadawu boe eke remawu bagai. Tamode kowuje dukeje tamugumode Pao Kurireu apo rugadu jii toro rugadu. Du akedumodukare. Imedu Onaregedu nure imi. Pao Kurireu ure iro rakado tuwo boe erduwado taidure i duji. Imire imode nou boe eke remawu maku tagai. ");
INSERT INTO bor_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nono enarare Jesusji. Egore: – Nuba čeromode Pao Kurireu ai aiduwo čei? ");
INSERT INTO bor_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus akore: – Pao Kurireu koiare ure itarego mato. Emare aidure tameartoruwo i. ");
INSERT INTO bor_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Egore: – Aro rakamode čegai dukeje čemeartorumode ai rugadu. Nuba aromode? ");
INSERT INTO bor_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jao pawobe ere baru pijiwu boe eke kowuje toro boe maereu keje. Moisés ure turo rakareu to tuwo nou boe eke maku etai. Pao Kurireu bataru padure kejewu bapera akore: “Pao Kurireu ure baru pijiwu boe eke maku etai ewo kowuje.” ");
INSERT INTO bor_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus akore: – Boe jokodu jire inagoino tai. Nou Moisés ure maku etaiwu boe eke baru pijiwu boe eke remawu karega. Pao Kurireu koiare emare umode boe eke remawu maku tagai baru piji. ");
INSERT INTO bor_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aregodure baru piji rugadu. Pao Kurireu ure nou boe eke remawu rawuje mato moto ka tuwo boe emugu pemegado pudabo. Du akedumodukare. ");
INSERT INTO bor_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Erduwakare kaba jiba Jesus akoino. Egore: – Nou akagoino jiwu boe eke remawu maku čenai tu tu je. ");
INSERT INTO bor_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus akore: – Nou boe eke remawu nure imi. Aidure tuiorduwawo iwuge emeartorumode i dukeje eke boeimodukare ei pugeje. Mare boe eke ji karega inagoino. Emugu pemegamode Pao Kurireu apo. Meartorure iwuge pobo boeimodukare ei jamedu. Mare pobo ji karega inagoino. Emugu pemegamode Pao Kurireu apo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aino čare ire tawie. Tardure i mare tameartorumodukare i. ");
INSERT INTO bor_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iogwa Kurireu ure maku inaiwu boe etaregodumode itae rugadu. Imodukare etudo ipiji. ");
INSERT INTO bor_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Itaregodukare iwo itaidure jiboe towuje. Itaregodure baru piji imeartoruwo ure itarego matowu Iogwa bataruji. ");
INSERT INTO bor_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Emare aidukare iwo ia aregodure itaewuge ewarigu ipiji. Dukodire imodukare ewarigu rugadu. Mare awu moto akedumode dukeje imode eewodudo pugeje ewikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pao Kurireu aidure meartorure iwugei. Erdumode i mare emeartorumode i dukeje emugu pemegamode Pao Kurireu apo rugadu. Du akedumodukare. Imire imode eewodudo pugeje awu moto akedu keje. ");
INSERT INTO bor_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesus makore nou baru pijiwu boe eke remawu nuie pudumi mare boe etaidukare nou akoinoduji. ");
INSERT INTO bor_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Egore pui: – José onaregedu nure ema. Parduware uoji učeji. Pagare akoino tuie turawuje baru piji duji. ");
INSERT INTO bor_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mare Jesus akore: – Tagagokaba aino. ");
INSERT INTO bor_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iogwa Kurireu umodukare boe etudo itae dukeje etaregodumodukare itae rugadu. Iogwa Kurireu koiare ure itarego mato. Umode boe etudo itae dukeje emeartorumode i rugadu. Nono imode eewodudo pugeje awu moto akedu keje. ");
INSERT INTO bor_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Makore Pao Kurireu bataru jiwuge ere Pao Kurireu bataru bu bapera keje. Egore: “Pao Kurireu umode boe eiamedu boe erduwado.” Dukodire imagore aino. Biapagare Iogwa Kurireu bataru jiwu aregodumode itae. Iogwa umode jorduwado dukeje aregodumode itae. ");
INSERT INTO bor_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mare inagokare boe erduie Iogwa Kurireuji. Tu nou aregodure Pao Kurireu pijiwu jordure Iogwa Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Boe jokodu jire inagoino. Meartorure iwu mugu pemegamode Pao Kurireu apo. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Boe eke remawu nure imi. ");
INSERT INTO bor_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jawu jaoboe ere ia boe eke kowuje boe maereu keje. Mare ewire tiamedu boe tabo. ");
INSERT INTO bor_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mare baru pijire boe eke remawu aregodure. Umode kowujewuge ewimodukare pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nou boe eke remawu nure imi. Nou aregodure baru pijiwu nure imi. Tamode nou boe eke remawu kowuje dukeje tamugu pemegamode Pao Kurireu apo. Du akedumodukare. Boe eke remawu nure ikoduče. Imode ikodu maku tagai tawo kowuje. Imode ikodu maku boe etai ewikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nou boe erdu pegare nou Jesus batarure aino duji. Etokire pui nou bataru keje. Egore: – Boe emodukare awu imedu kodu kowuje rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus akore: – Boe jokodu jire inagoino. Imedu Onaregedu nure imi. Boe emodukare ikodu kowuje mare emugu pemegamodukare jamedu. Boe ekudumodukare ikuče dukeje emugu pemegamodukare. ");
INSERT INTO bor_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mare boe emode ikodu kowuje, ekudumode ikuče dukeje emugu pemegamode Pao Kurireu apo rugadu. Du akedumodukare. Moto akedumode dukeje imode eewodudo pugeje ewikawo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Boe eke remawu nure ikoduče. Boe eke remawu nure ikuče. ");
INSERT INTO bor_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Boe emode ikodu kowuje dukeje emugumode itabo. Imugumode ebo jamedu. Boe ekudumode ikuče dukeje emugumode itabo. Imugumode ebo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Iogwa Kurireu ure rugadu. Ema koiare ure itarego mato. Ema koiare ure imugu pemegado jamedu. Aino čare boe emode ikowuje dukeje imode emugu pemegado jamedu. ");
INSERT INTO bor_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ainore baru pijiwu boe ekere. Ukare nono nou jawu jaoboe enogwagere jiboere. Jawu jaoboe eiamedu boe ewire. Mare boe emode awu inagoino jiwu boe eke remawu kowuje dukeje ewimodukare pugeje. Emugumode Pao Kurireu apo jii toro rugadu. Du akedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cafarnaum ba kurireu kejere Jesus rakojere. Nou Judeu doge ere bato puiwu bai kejere akoino nou boe dogei. ");
INSERT INTO bor_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nou uture Jesus rekodajiwugere emeardure nou Jesus akoinoduji dukodire etaidukare ji. Egore: – Awu makore jiboe rakare pai. Boe erduwamodukare ji. Boe emeartorumodukare ji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus meardukare ewadaruji mare jorduware emago pegare pudui duji. Dukodire čare makore ei pugeje. Akore: – Kočare tagaidukare imagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tardumode irudure baruto duji ibagi duji dukeje nuba tameardaemode i pugeje? ");
INSERT INTO bor_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Inagore taiago ikodu kowuje. Mare ikodu remawu ji karega inagoino. Pao Kurireu Uwari jire inagoino. Inagore taguduiago ikuče jamedu mare iku remawu ji karega inagoino. Pao Kurireu Uwari jire inagoino. Ema koiare umode meartorure iwuge emugu pemegado Pao Kurireu apo. Taraga tabo karega tamugu pemegamode. Mare Pao Kurireu Uwari koiare umode boe emugu pemegado. ");
INSERT INTO bor_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mare ia tagi tameartorukare i rugadu. Marigudu Jesus jorduware meartorumodukare puduiwugei. Jorduware ia imedu umoduie tumagu boe eimijerage pegareuge etai duji jamedu. Jorduware nou imedu romode pudui duji marigudu. ");
INSERT INTO bor_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nono Jesus makore pugeje. Akore: – Tameartorukare dukodire inagoino. Boe etaregodumodukare itae tao biji. Pao Kurireu koiare umode boe pemegado boei etaregoduwo itae. ");
INSERT INTO bor_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ča Jesus akore aino nou boe dogei dukodi čare emagare tudu tabo piji. Etukare Jesus rekodaji pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dukodire Jesus unarare ture jorduwadowugei. Enodo padu kejeboere doze. Akore: – Tagaidure taduwo ipiji jamedu? ");
INSERT INTO bor_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mare Simão Pedro akore: – Boro. Awadaru koiare umode čemugu pemegado Pao Kurireu apo jii toro rugadu. Čerduwakare ia boe ewagai pugeje. ");
INSERT INTO bor_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aino čare čemeartorure ai rugadu. Čerduware Boe Pemegareu Remawu nure aki duji rugadu. Akire akaregodure Pao Kurireu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus akore: – Tanodo padu kejeboere doze. Ire ikeragu taiamedu boei inai. Mare ia tamedia bope nure ema nono tagabo. ");
INSERT INTO bor_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariotes jire Jesus akoino. Simão Iscariotes onaregedu nure ema. Jesus ure nou Judas Iscariotes jorduwado. Du inodu tabo umode Jesus maku boe eimijerage pegareuge etai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nou inodu otobiji Jesus kodure Galiléia motoji. Judéia moto kejewu Judeu doge eimijerage etaidure tuwo Jesus bito. Dukodire Jesus aidukare tugoduwo Judéia motoji. ");
INSERT INTO bor_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kuri aino Judeu doge ewadumode ia tuwadaeji. Nou ewadure jiwu ewadae iere “Mačebradu”. ");
INSERT INTO bor_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","4","Nono Jesus uwiemage emagore ji. Egore: – Boe etaidumode boe erduwawo pudui boe emodukare turo rakareu biado boe epiji. Ča atudo toro Judéia moto ka. Nou Judéia moto kejewuge emeardure boe egore aro rakaie. Etaidure tuduwo akabo. Atudo toro awo erdudo aro rakareuji. Dukodire boe eiamedu boe erduwamode ai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mare nou Jesus uwiemage emeartorukare ji dukodire egoino. ");
INSERT INTO bor_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mare Jesus makore ei. Akore: – Tameardae pagare. Iorduware itumode toro kejewu meriji. Kajao. ");
INSERT INTO bor_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Boe erdu pegakare tai. Mare imi ire boe ewie ero pegareu jamedu boeji dukodire erdu pegare i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tadudo nou Judeu doge ewadae ka. Itumodukare raga. Nou itumode kejewu meri aregodukare raga. ");
INSERT INTO bor_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesus utukare nou Galiléia moto piji nou meriji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesus uwiemage eture toro nou Judeu doge ewadae ka. Dukejere Jesus uture toro jamedu. Mare ure tuwiado boe epiji. ");
INSERT INTO bor_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nou ewadae kejere nou Judeu doge eimijerage emarure Jesus bagai. Egore: – Ema pa? ");
INSERT INTO bor_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nou ewadae kejewu boe doge enogwa podure pui Jesus jiboeji. Iage egore: – Imedu pemegareu nure ema. Mare iage egore: – Boro. Unure boe ekiripagado. ");
INSERT INTO bor_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mare emagokare nou inodu boeji boe ewiagai. Epagudure tugimijerageče kodi. ");
INSERT INTO bor_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nou Judeu doge ewadure rugadu nou tuwadaeji. Mare ewadu kimore dukeje Jesus uture Pao Kurireu uwai ka. Nonore ure boe erduwado. ");
INSERT INTO bor_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judeu doge eimijerage erore ta je. Egore: – Boe ekare awu imedu jorduwado. Kodiba čare jorduware aino? ");
INSERT INTO bor_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus akore: – Pao Kurireu koiare ure itarego woe. Du bataru jire inagore aino iwo boe erduwado. ");
INSERT INTO bor_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aidure tumeartoruwo Pao Kurireu bataru jiwuge erduwamode iwadaruji. Erduwamode jamedu iwadaru ji karega inagoino. Erduwamode Pao Kurireu bataru remawu jire inagoino duji. ");
INSERT INTO bor_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ia boe emagomode tu pudumie tuiorduware. Nouge etaidure boe etaiwowo tu pudui, boe enojarowo nou tuwadaruji. Mare ia aidumode boe emago pemegawo nou ure tarego matowuji dukeje batrarodumodukare. Boe jokodu jire akoino boe etaiduwo nou ure tarego matowuji. ");
INSERT INTO bor_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mariguduwuge pawobe eimijera Moisés ure Pao Kurireu meardae maku etai eno bakaruče. Dukodire tago bakarure aino jii aino. Mare taiamedu boe tameartorukare nou tago bakaruji rugadu. Kodiba tagaidure tawo iwido? ");
INSERT INTO bor_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nou boe egore: – Čedaidukare čewo awido. Ia bope uwari meture atada rugadu kodire akagoino. ");
INSERT INTO bor_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus akore: – Iro rakare sábado meri keje dukodire taerore ta je. ");
INSERT INTO bor_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Marigudu Moisés ure taro maku tagai tawo tagore ime ewaga oto biri kado. Mare ia jawu jaoboe eigoiare ere nou taro maku tagai boetoji. Nono Moisés rore aino tai jamedu aino boigodu. Dukodire tare tagore ime eiamedu boe ewaga oto biri kado rugadu. Taromode aino sábado meri keje jamedu. ");
INSERT INTO bor_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés ure tago bakaru maku tagai. Akore tamaragodukaiago sábado meri keje mare boe pegakaie tai tawo tagore ime ewaga oto biri kado sábado meri keje. Ire nou imedu pemegado sábado meri keje dukodire tagorigodure aino i. Tagagore boe erokaie aino sábado meri keje. ");
INSERT INTO bor_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tagaiwokaba boei tameardae pegareu tabo. Tagaiwodo boei eromode jiboeji emeardaemode jiboeji jamedu. Dukodire tarduwamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nouia mugure Jerusalém ba kurireu kejewuge egore: – Čowu pagimijerage etaidure tuwo bitowu imedu karegau? ");
INSERT INTO bor_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kočare makore boe eiamedu boe ewiagai boe eiamedu boe egai. Mare boe emago pegareu bokware ia tuwadaruji ji. Pagimijerage erduwa kana umode boe ekinorudowu nure ema duji? Erduwa kana pabagare bagaiwu nure ema duji? ");
INSERT INTO bor_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Boe erduwamodukare kaibowu pijiba umode boe ekinorudowu aregodumode. Mare paiamedu boe parduware kaibowu pijiba awu imedu aregodure. ");
INSERT INTO bor_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus ure boe erduwado Pao Kurireu uwai tada dukeje ure tumago pemegado toro boe etae boe eiamedu boe emearduwo tuwadaruji. Akore: – Tameardaere tarduwaie itaregodure pijiwu motoji. Mare nou ure itarego matowu emare ure itudo jetu. Imi itaobiji karega itaregodure. Nou ure itarego matowu batrarodumodukare. Boe remawu nure ema rugadu. Mare tarduwakare ji. ");
INSERT INTO bor_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iragojere apo dukodire iorduware ji. Ema koiare ure itarego mato. ");
INSERT INTO bor_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nono iage etaidure tuwo tugeragu ji tuwo tugu baičoreuto. Mare Pao Kurireu aidukare dukodire erokare aino ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mare iage emeartorure Jesusji. Awu meartorure jiwuge emagare. Egore: – Awu imedu ro rakare nono pabagare bagaiwu umode boe ekinorudowu mogadure rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseu doge emeardure nou boe enogwa podure pui Jesus jiboe jituji. Dukejere ere tugobaigarege etudo toro tuwo tugeragu Jesusji. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emeardaere nono nou fariseu doge emeardae mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus makore boei. Akore: – Iragoje biagamode tu tagabo. Kuri aino itumode tabiji toro ure itarego matowu bagai ibagi. ");
INSERT INTO bor_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tagaiwomode iwagai mare tardumodukare i. Taroiwamodukare taduwo toro iragojemodewu ka. ");
INSERT INTO bor_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nou Judeu doge egore pui: – Kaiba kodumode? Utumode kana toro pawobe etae toro ia Grécia moto kejewu ba kurireu ka tuwo nou Grécia kejewuge erduwado? Nuba romode pardukawo pudui pugeje? ");
INSERT INTO bor_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Akore pagaiwomoduie tuwagai mare pardumodukaie pudui. Akore paroiwamodukaie paduwo toro turagojemodewu ka. Kaba jiba akoino? ");
INSERT INTO bor_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Awu meriji nou Judeu doge ewadae remawu akedu kejewu meri reo. Jesus ure turagojedo. Ure tumago pemegado boe eiamedu boe emearduwo. Akore: – Pobo boeire ia tai dukeje tadudo itae. ");
INSERT INTO bor_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pao Kurireu bataru padure bapera keje. Akore: “Meartorure iwuge ekudumode nou poboče dukeje umode turedo epiji. Nou pobo umode emugu pemegado rugadu. Du akedumodukare rugadu.” ");
INSERT INTO bor_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mare pobo ji karega Jesus akoino. Pao Kurireu Uwari jire Jesus akoino. Boe emeartorumode Jesusji dukeje Pao Kurireu umode Tuwari maku nou boe etai. Dujire Jesus akoino. Mare Jesus akore aino nou boei kimo mare Pao Kurireu ukare Tuwari maku boe etai raga. Jesus jewodukare tuwi piji raga turuduwo baruto dukodire ukare maku etai raga. ");
INSERT INTO bor_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nou boe emeardure nou Jesus bataruji dukeje iage egore: – Pao Kurireu ure pawie jiwu, makore Pao Kurireu bataru jiwu nure awu imeduče rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iage egore: – Pabagare bagaiwu umode boe ekinorudowu nure ema. Mare iage emeartorukare. Erduwakare Jesus boture Belém ba kurireu keje duji. Dukodire egore: – Ema karega. Awu imedu boture Galiléia moto keje. ");
INSERT INTO bor_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pao Kurireu akore Belém ba kurireu kejeie nou pabagare bagaiwu umode boe ekinorudowu botumode. Jao pagimijera kurireu Davi uwobe moduie ema. Belém ba kurireu kejere nou Davi mugure. Mare awu Jesus botukare Belém ba kurireu keje. Ainore nou boe egore. Mare erduwakare Jesus boture Belém ba kurireu keje duji. Dukodire egoino. ");
INSERT INTO bor_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dukodire emeartorukare ji. Dukodire nou boe emeardaekare pumeardae mogadure Jesus jiture. ");
INSERT INTO bor_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iage etaidure tuwo tugeragu ji tuwo tugu baičoreuto. Mare boe eragakare tuduwo ae. ");
INSERT INTO bor_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dukodire tugobaigarege eture tuibagi tugimijerage fariseu doge etae, tugimijerage ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etae. Nou tugobaigarege eimijerage enarare ei. Egore: – Kodiba tagaregodukare apo? ");
INSERT INTO bor_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nou tugobaigarege egore: – Marigudu boe emagokare nono nou imedu makore jiboe mogadure ji aino. Mako pemegare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nou fariseu doge ekorigodure. Egore: – Ure taekiripagado rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Judeu doge eimijerage eiamedu boe emeartorukare ji rugadu. Fariseu doge nure čegi. Čeiamedu boe čemeartorukare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Awu boe erduwakare Moisés ure maku pagaiwu pago bakaruji paroji. Dukodire Pao Kurireu ro pegare ei. Dukodi čare boe pegamode ei rugadu. Ainore nou fariseu doge egore. ");
INSERT INTO bor_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ia fariseu iere Nicodemos. Emare uture Jesus ae marigudu tuiorduwawo Jesus bataruji. Aino čare makore tumedage fariseu dogei. ");
INSERT INTO bor_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Akore: – Pawiapagamode boe ewadaruji parduwawo eroji dukeje pagaiwomode ero pegareu bagai. Ainore pago bakaru ure. Ainore parore. Paromodukare aino dukeje paro peganure. ");
INSERT INTO bor_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Mare nou fariseu doge egore: – Awodu kana Galiléia moto keje jamedu nono awu imedu Jesus mogadure? Akaidure ji? Akaiwodo Pao Kurireu bataru padure kejewu baperaji. Akaiwomode ji dukeje arduwamode nou makore Pao Kurireu bataru jiwuge eiamedu boe ewodukare nou Galiléia moto keje rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Boe eiamedu boe eture tuibagi tuwai ka pugeje. Mare Jesus ruture ia tori iere Oliveira Ri ao ka. ");
INSERT INTO bor_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Barogwakododu kejere ure turawuje. Uture tuibagi Pao Kurireu uwai ka pugeje. Boe ere bato pui ae. Emagare. Dukodire ure tumugudo boebo dukeje ure erduwado. ");
INSERT INTO bor_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jorduware Judeu doge eno bakaru jiwuge etaregodure ae aredu apo. Fariseu doge etaregodure ebo jamedu. Erdure nou aredu jeribarire tumugukare apowu imedu jituji. Dukodire etaregodure nou aredu apo aino. Nono ere nou aredu rakojedo boe etoiadada. ");
INSERT INTO bor_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Emagore Jesusji. Egore: – Jorduwareu nure aki. Čerdure awu aredu jeribarire tumugukare apowu imedu jituji. ");
INSERT INTO bor_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Marigudu Moisés ure Pao Kurireu meardae maku jawu pawobe etai pago bakaruče kodire parore aino rugadu. Emare akore aredu jeribarie tumugukare apowu imeduji dukeje boe eiago nou aredu bito tori tabo. Ča nuba ameardaere parowo awu areduji? ");
INSERT INTO bor_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nou boe eimijerage etaidure tuwo turokogado Jesusji tumearduwo ia Jesus bataru pegareu bagai. Dukodire egoino ji. Mare Jesus makokare boeji. Ure tubu jodo moto keje tuwo tuwadaru bu moto keje tugerako tabo. ");
INSERT INTO bor_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nou boe eimijerage enara kimore ji dukeje Jesus ure turagojedo pugeje. Dukeje makore ei. Akore: – Ia tagi taro pegareu bokware dukeje tagidomode tori tabo nou areduji boetoji. ");
INSERT INTO bor_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nono Jesus ure tubu jodo moto keje pugeje dukeje ure ia tuwadaru bu moto keje tugerako tabo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nou boe eimijerage emeardure nou Jesus akoino duji dukeje eture Jesus piji etododai. Pegagodureuge eture boetoji. Dukeje iage eture eregodaji. Nono iage eture pugeje. Ča nou boe eimijerage eiamedu boe eture rugadu. Aino Jesus rakojere nono tuginaigodu nou etaregodure apowu aredu apo. ");
INSERT INTO bor_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nono Jesus ure turagodo dukeje makore nou areduji. Akore: – Kaiba ekodure? Boe edukare woe pugeje tumago pegawo ai. ");
INSERT INTO bor_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nou aredu akore: – Boro. Eiamedu boe eture marigudu. Jesus akore: – Ča imago pegamodukare ai jamedu. Atudo awai ka aibagi. Mare paga karega. Aro pegakaba pugeje. ");
INSERT INTO bor_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus makore nou fariseu dogei pugeje. Akore: – Jorugu pemegareu koiare umode boe edo činorudo boe pegareu piji boečoji. Ire nono jorugu pemegareu mogadure. Mare jorugu ji karega inagoino. Imode boe edo činorudo turo pegareu piji. Boe ekodumode itabo dukeje imode boe erdudo turo pegareuji erokawo aino pugeje. Imode eroiwado tuwo tugera ra turo pegareu piji. ");
INSERT INTO bor_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nou fariseu doge egore: – Amagore čei mare aragojere woe akinaigodu. Tu akire akagoino. Dukodire čare awadaru ukare turugadu čegai. ");
INSERT INTO bor_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus akore: – Boro. Iorduware boe jokodu jire inagoino tai duji. Tarduwakare kaibowu pijiba itaregodure. Imire iorduware. Tarduwakare kaiba ikodumode. Imire iorduware. Dukodire inagoino irore jiboeji tawiagai. ");
INSERT INTO bor_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tagaiwomode boe eroji dukeje tamagomode ero pegareuji boe ewiagai nono boe ero mogadure. Mare imi imagokare boe ero pegareu boeji tawiagai. ");
INSERT INTO bor_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Imagomode boe ero pegareu boeji boe ewiagai dukeje iwadrarodumodukare. Boe jokodu jire imagomode. Iragojekare woe ikinaigodu. Iogwa Kurireu rakojere itabo. ");
INSERT INTO bor_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tamode pobe dukeje tamagomode jiboe kodumode puregodaji dukeje boe emeartorumode tagagoino jiboeji. Egomode boe remawu jie tagagoino. Ainore tago bakaru akore. Tagi taro reo. Boere pobe tumago pegare dutabo ia ro pegareu jitu dutabo dukeje boe emeartorumode emagore jiboeji. Umode mito tumagore dutabo dukeje boe emeartorumodukare ji. Ainore tagagore. Padure bapera keje. ");
INSERT INTO bor_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ča imagore irore jiboeji tawiagai. Mare Iogwa Kurireu koiare ure itarego mato. Emare makore irore jiboeji boe ewiagai jamedu. Aino čere pobe jamedu tameartoruwo čemagore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Enarare Jesusji. Egore: – Ao pa? Jesus akore: – Tarduwakare i. Tarduwakare iogwaji jamedu. Tarduwamode i dukeje tarduwamode iogwaji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ainore Jesus akore Pao Kurireu uwai tada. Ure boe erduwado nono. Ia ira mugure nono jamedu boe ewo toe tugu jagi tuwo maku Pao Kurireu ai. ");
INSERT INTO bor_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nono Jesus makore boei pugeje. Akore: – Iturumode tabiji pugeje. Tagaiwomode iwagai. Mare taro pegare kodi tawimode. Itumode tabiji dukeje taroiwakare taduwo iregodaji. ");
INSERT INTO bor_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nou Judeu doge eimijerage emagore pui. Egore: – Emare akoino paroiwamodukaie paduwo turegodaji. Tuwimodedu ji kana akoino? Umokana tuwido? ");
INSERT INTO bor_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus makore ewadaru jipagi. Akore: – Awu moto kejewuge nure tagi. Imi rema itaregodure baru piji. Tawodure woe awu moto keje. Mare imi moto kejewu karegure imi. ");
INSERT INTO bor_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Dukodire inagoino tai tawimode nou taro pegareu kodi. Ča itagedumodukare rugadu. Tameartorumodukare i dukeje tawimode rugadu taro pegareu jamedu boe tabo. ");
INSERT INTO bor_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Egore: – Ioguduba nure aki? Jesus akore: – Ire tawie marigudu. ");
INSERT INTO bor_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Itaidure imago raiwo taro boeji. Itaidure iwo boe ewie taro pegareu jamedu boeji. Mare ure itarego matowu ure tuwadaru maku inai iwo boe ewie. Emare batrarodumodukare. Imagomodukare ia iwadaruji tawiagai. ");
INSERT INTO bor_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pao Kurireu jire Jesus akoino. Mare nou boe erduwakare akoino jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dukeje Jesus makore ei pugeje. Akore: – Imedu Onaregedu nure imi. Tamode ipo padure pugajejewu rakojedo itabo dukeje tarduwamode akedumodukareu nure imi duji. Nono tarduwamode Iogwa Kurireu bataru jire inagoino rugadu. Imeardae ji karega inagoino. Iogwa Kurireu meardae koiare ure inagodo aino tai. ");
INSERT INTO bor_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ema koiare ure itarego mato. Rakojere itabo jamedu. Imeartorure ji rugadu dukodire utukare ipiji. ");
INSERT INTO bor_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Boe emeardure Jesus akoino duji dukodire emagare tumeartorure jitu tabo. ");
INSERT INTO bor_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nono Jesus makore nou meartorure puduiwugei. Akore: – Tameartorumode iwadaruji rugadu dukeje ire jorduwadowuge remawuge emode tagi rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tarduwamode iwadaru remawuji dukodire nou iwadaru remawu umode tadawuje boe pegareu piji. Tawiapagamodukare tameardae pegareuji taibagi pugeje. Tamode tagamudo piji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Egore: – Amode čedawuje boe pegareu piji? Kaba jiba akagoino čei? Čemugu pegakare. Abraão uwobe nure čegi. Marigudu čemaragodukare ia boe tuginaiwuge etai jii aino. Čewiapagakare ei. Čeragojekare boe pegareu keje. ");
INSERT INTO bor_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mare Jesus akore: – Boe jokodu jire inagoino tawiagai. Boe ero pegare dukodire emeardu kurire nou turo pegare jiboeji. Ewiapagamode tu tu nou turo pegareu boeji. ");
INSERT INTO bor_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Boe emaragodumode ia boe etai dukeje utugarege nure emage. Emugumode ebo mare etuwobe karegure emage. Mare boe etore boe etuwobe nure emage rugadu jii toro. ");
INSERT INTO bor_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pao Kurireu Onaregedu nure imi. Imode tadawuje boe pegareu piji tagawo tagirimi nou taro pegareu ka pugeje dukeje tawiapagamodukare taro pega boeji taibagi pugeje. ");
INSERT INTO bor_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iorduware Abraão uwobe nure tagi duji. Mare tameartorukare iwadaruji dukodire tagaidure tawo iwido. ");
INSERT INTO bor_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Imagore Iogwa Kurireu ure iorduwado jiwu tuwadaruji. Mare tagi tameartorure tao bataru pegareu jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Egore: – Iogware Abraão rema. Jesus akore: – Abraão ore mode tagi dukeje taromode nono Abraão ro mogadure. ");
INSERT INTO bor_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Itaidure iwo tarduwado Pao Kurireu makore iwu tuwadaru remawuji tawiagai. Boe jokodu jire Pao Kurireu akoino. Mare tagaidure tawo iwido. Abraão rokare aino. Kodire tao karegure ema. ");
INSERT INTO bor_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mare tagaidure tarowo nono tao remawu ro mogadure. Egore: – Pao Kurireu ure mitotu je kodire ure toredo čegi rugadu. Pao Kurireu ore remawuge nure čegi rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus akore: – Pao Kurireu oremode tagi dukeje tameardu kurimode i. Itaregodure Pao Kurireu piji. Ča imi reo. Pao Kurireu koiare ure itarego mato tuwadaru tabo. Imi igoia karega. ");
INSERT INTO bor_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mare tagaidukare iwadaruji dukodire tagaidukare tawiapagawo imagore jiboeji. Dukodire tarduwakare iwadaruji. ");
INSERT INTO bor_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bope doge eimijera ore nure tagi. Tameartorure tao bope doge eimijera meardaeji. Marigudu ure boe ewido ji aino kimo. Aidukare boe ewadaru pemegareuji rugadu. Tuwadrarodae jire jorduware tu rugadu. Marigudu batrarodure tu tu je ji aino. Batrarodureuge etuo nure ema. ");
INSERT INTO bor_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Boe jokodu jire inagoino tai. Tao batrarodureu koiare ure tawarigu ipiji tameartorukawo i. ");
INSERT INTO bor_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Iro pegakare dukodire tarduwakare ia iro pegareu bagai. Imagore boe remawuji tawiagai tameartoruwo i mare tameartorukare i. ");
INSERT INTO bor_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pao Kurireu ore ewiapagamode Pao Kurireu bataruji. Mare Pao Kurireu ore karegure tagi. Dukodire tagaidukare tawiapagawo ji. ");
INSERT INTO bor_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nono emagore Jesusji. Egore: – Boro. Čegi čerduware boe remawuji rugadu. Samaria moto kejewu nure aki. Bope uwari meture atada. Nou boe erdu pegare Samaria moto kejewugei dukodire erdu pegare Jesusji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus makore ewadaru jipagi. Akore: – Bope uwari metukare itada. Imeartorure Iogwa Kurireu bataruji kodi. Mare tamago pegare ikieji. ");
INSERT INTO bor_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Itaidukare boe emago pemegawo ikieji. Mare Iogware aidure boe emago pemegawo ikieji. Emare aiwore irore jiboeji dukodire mako pemegare irore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Boe jokodu jire inagoino. Boe emeartorumode iwadaruji dukeje ewimodukare jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Egore: – Ča ainore čerduware bope uwari meture atada rugadu duji. Abraão bire marigudu. Nou makore Pao Kurireu bataru jiwuge eiamedu boe ewire marigudu jamedu. Mare aki akagore meartorumode aiwuge ewimodukaie jii toro. ");
INSERT INTO bor_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Iogwa Abraão bire marigudu. Akurikare Abraão kori. Nou makore Pao Kurireu bataru jiwuge eiamedu boe ewire marigudu. Ioguduba nure aki? ");
INSERT INTO bor_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Jesus akore: – Imode ikie kurido ikinaigodu dukeje boe kurireu modukare imi. Mare Iogwa Kurireu koiare ure ikie kurido. Tagagore tameartoruie Pao Kurireuji rugadu. Mare marigudu tarduwakare ji. Mare imire iorduware ji rugadu. Imagomode iorduwakaie jituji dukeje iwadrarodumode nono tawadrarodu mogadure. Mare iorduware ji rugadu. Imeartorure makore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tao Abraão jorduware tuiordumoduie itaregodure duji dukodi jakarere pudui rugadu. Nono jordure i dukeje jakarere pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Egore: – Ako joru oto padukare 50. Dukodire ardukare Abraãoji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus akore: – Boe jokodu jire inagoino tai. Abraão botukare raga mare imire imugure baru tada marigudu. ");
INSERT INTO bor_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nono nou boe ere tugeragu toriji tugidowo tabo ji mare Jesus ure tuwiado epiji. Dukeje uture Pao Kurireu uwai piji. ");
INSERT INTO bor_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus merure awaraji. Nono jordure joku bokwareu imeduji. Nou imedu boture tuioku bokwa tabo ji aino imedure pudumi du ka. ");
INSERT INTO bor_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nono nou Jesus ure jorduwadowuge enarare ji. Egore: – Jorduwareu nure aki. Ioguduba ro pegare? Kodiba awu imedu boture tuioku bokwa tabo? Ema na ro pegare? Dukodi kana joku bokware? Uo kana ro pegare? Uče na ro pegare? Dukodi kana boture tuioku bokwa tabo? ");
INSERT INTO bor_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus akore: – Boe ero pegareu koia karega joku bokware. Boture tuioku bokwa tabo Pao Kurireu uwo pemegago tuwo boe erdudo ture joku pemegago duji tuwo boe erdudo turo rakareuji. ");
INSERT INTO bor_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mare Pao Kurireu ure itarego mato. Pamaragoduwo meri kimoto iwo ure itarego matowu meardae towuje ji je. Mare kuri aino boe pegamode boei. Boe mode boei nono boečo mogadure. Boe emaragodumodukare pugeje. ");
INSERT INTO bor_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iragojere woe moto keje dukeje imode nono jorugu pemegareu mogadure. Mare jorugu ji karega inagoino. Imode boe erduwado boe remawuji rugadu. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus akore aino dukeje ure todoguru barigu mototo. Ure moto bekurudo nou todoguru tabo. Ure tugeragu nou moto bekuruji. Ure bu nou imedu joku bokwareu joku keje. Nono makore ji. ");
INSERT INTO bor_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akore: – Atudo toro nou Siloé po ka awo ae kabi. Nou Judeu doge ewadaru tabore egore “Utudowu”. Ainore egore nou Siloé poji tuwadaru tabo. Nono nou imedu joku bokwareu uture nou Siloé po ka. Ure tuie kabi dukeje joku pemegagodure. Ure tugirimi tuibagi tuwai ka pugeje. ");
INSERT INTO bor_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nono nou jorduware jiwuge erore ta je. Egore: – Čewu imedu joku bokwareu karega? Kočare mugure woe maigodu togwamaguduwo boei diero rogu bagai toče. ");
INSERT INTO bor_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iage egore: – Ema rugadu. Mare iage egore: – Ema karega. Jere nono nou joku bokwareu je mogadure mare ema karega. Mare nou imedu akore: – Imi rugadu reo. ");
INSERT INTO bor_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nou boe egore: – Kočare akaiwo pemegare rugadu? Nuba boere ai? ");
INSERT INTO bor_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dukeje akore: – Ia imedu iere Jesus. Ema koiare ure moto bekurudo todoguru tabo. Ure nou moto bekuru bu ioku keje. Dukeje makore i ituwo toro Siloé po ka iwo ie kabi poče. Dukodi čare iture toro. Ire ie kabi rugadu. Dukodi čare itaiwo pemegare aino rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nou boe egore: – Nou Jesus pa? Imedu akore: – Iorduwakare bagai. ");
INSERT INTO bor_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nou boe ere nou imedu reko toro fariseu doge etae. ");
INSERT INTO bor_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus ure nou imedu joku pemegago Sábado meriji. ");
INSERT INTO bor_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nou fariseu doge enarare nou imeduji. Egore: – Nuba boere ai aeku pemegagoduwo aino? Nou imedu akore: – Ia imedu ure moto bekuru bu ioku keje. Dukeje makore i iwo ie kabi. Dukeje čare itaiwo pemegare aino rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ia fariseu doge egore: – Nou roinowu imedu meartorukare paroji kodire rore aino Sábado meri keje. Pagi parokare aino. Dukodire Pao Kurireu piji karega aregodure. Mare iage egore: – Ia ro pegareu imedu ro rakamodukare nono awu imedu ro raka mogadure. Awu imedu pemegare rugadu. Dukeje čare emeardaekare nono pumeardaere. ");
INSERT INTO bor_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dukodi čare nou fariseu doge enarare nou joku bokwareu imeduji pugeje. Egore: – Nou imedu ure aeku pemegagowu nuba ameardaere ji? Nou imedu pemegare rugadu? Nou joku bokwareu imedu makore ewadaru jipagi. Akore: – Ia makore Pao Kurireu bataru jiwu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mare nou Judeu doge eimijerage etaidukare tumeartoruwo nou joku bokwareu akoino duji. Emeardaere joku bokwareu karegure ema. Dukodire emagore nou imedu uče bagai uo bagai jamedu. ");
INSERT INTO bor_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Enarare nou učeji, nou uoji jamedu. Egore: – Taganaregedu nure awu imeduče? Boture tuioku bokwa tabo? Nuba boere ji joku pemegagoduwo aino? ");
INSERT INTO bor_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nou uče uo egore: – Čedonaregedu nure ema rugadu. Boture tuioku bokwa tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mare čerduwakare nuba boere ji kodiba joku pemegagodure aino. Čerduwakare iduba koiaba ure joku pemegago. Ča. Imedu nure ema. Tanarado ji. Ema koiare umode tawiedu pemegado nuba nou imedu rore pudui duji. ");
INSERT INTO bor_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mare marigudu nou Judeu doge eimijerage emagore boei emeartorukawo Jesusji. Egore ia meartorumoduie Jesusji umode boe ekinorudowu nure ema duji dukeje tumode utudo nou ture bato puiwu bai piji rugadu aregodukawo nou bai ka pugeje. Dukodire nou joku bokwareu uče uo epagudugodure nou tugimijerageče. ");
INSERT INTO bor_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dukodire emagokare Jesus ieji tugimijerage ewiagai. Egore tonaregedu koiaie umoduie ewie iduba roino pudui duji. ");
INSERT INTO bor_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dukodire nou Judeu doge eimijerage emagore nou joku bokwareu imedu bagai pugeje. Emagore ji. Egore: – Pao Kurireu aiwonure ai rugadu. Awadarudo turugadu. Nou ure apemegadowu imedu ro pegareu nure ema rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nono nou imedu joku bokwareu akore: – Imedu ro pegareu mode ema dukeje mare iorduwakare ji. Mare imire ioku bokware rugadu. Aino čare itaiwo pemegare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Egore: – Nuba rore ai tuwo aeku pemegado akaiwo pemegawo pugeje? ");
INSERT INTO bor_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nou imedu akore: – Ire tawie marigudu. Tawiapagakare iwadaruji. Kodiba tanarare i pugeje? Tagaidure tameartoruwo ji uwo tarduwado jamedu? ");
INSERT INTO bor_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nono nou fariseu doge ekorigodure. Emago pegare nou joku bokwareu imeduji. Egore: – Akire ure jorduwadowu nure aki. Mare čegi Moisés ure jorduwadowuge nure čegi. ");
INSERT INTO bor_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pao Kurireu makore Moisesji rugadu. Mare awu imedu karega. Čerduwakare kaibowu pijiba awu imedu aregodure. ");
INSERT INTO bor_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nou joku bokwareu imedu akore: – Nou imedu ure ipemegago itaiwowo pugeje. Ioku bokwakare pugeje. Boe eimijerage nure tagi. Kočare tarduwakare nou imeduji. Kočare arduwakare kaibowu pijiba awu imedu aregodure. ");
INSERT INTO bor_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","32","Iwodure ioku bokwa tabo. Aino ča nou imedu ure itaiwodo pugeje. Marigudu rugadu ia boe erokare nono ro mogadure. Ča Pao Kurireu biapagamodukare ro pegareuge emagore pudui jiboe bagai. Boe jokodu. Mare Pao Kurireu biapagamode meartorure puduiwuge ewagai rugadu. Boe emeartorumode Pao Kurireu bataruji dukeje Pao Kurireu biapagamode ewadaruji. ");
INSERT INTO bor_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nou imedu aregodukare Pao Kurireu piji dukeje ro rakamodukare. Umodukare ipemegago. Kodiba ure ipemegago? Ča aregodure Pao Kurireu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nou boe eimijerage egore: – Awodure dukeje ro pegareu nure aki rugadu jii aino. Aki na akaidure awo čerduwado? Arduwa bokwa. Dukodi čare ere nou imedu utudo nou ture bato puiwu bai piji aregodukawo nou bai ka pugeje. ");
INSERT INTO bor_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus meardure nou boe eimijerage erore aino duji dukeje jemarure nou ture pemegagowu imedu bagai. Jordure ji dukeje makore ji. Akore: – Aki na ameartorure Imedu Onaregeduji rugadu? ");
INSERT INTO bor_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nou imedu akore: – Ioguduba nure ema? Iwie imeartoruwo ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus akore: – Ardure ji marigudu. Imi reo rugadu. Imi rugadu inagoino ai. ");
INSERT INTO bor_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nou imedu ure tubu jodo moto keje Jesus jokorai. Akore: – Imeartorumode ai rugadu. Ikimijera mode aki rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus akore: – Itaregodure woe moto ka itaiwowo boe ero pegareu bagai. Aino joku bokwareuge etaiwomode pugeje. Mare joku bokwareuge ei karega inagoino. Jorduwakare iwugeire inagoino emeartoruwo i rugadu. Mare očarore tuwadaru jiwuge emode nono joku bokwareuge emogadure. Mare joku bokwareuge ei karega inagoino. Egore tuiorduwaie Pao Kurireu meardaeji. Mare pagatu jere egoino. Dukodire erduwamodukare i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ia fariseu doge eragojere nono jamedu. Emeardure nou Jesus akoino duji. Dukodire emagore Jesusji. Egore: – Ameardaere joku bokwareuge nure čegi rugadu? Čedaiwo pemegare. ");
INSERT INTO bor_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus akore: – Inagore joku bokwareugeie. Mare joku bokwareuge ei karega inagoino. Boe egomode turo pegaie mare turo pegamodukaie aino pugeje. Dukeje Pao Kurireu biagodumode nou ero pegare jiboe piji rugadu. Mare tagagore tarduwaie Pao Kurireu meardaeji rugadu. Tagagore taro pega bokwaie. Aino tagojarore tawadaruji rugadu. Dukodi ro pegareuge nure tagi aino rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Jesus akore: – Boe jokodu jire inagoino. Boe emode tagu carneiro doge edu tadawu ibora pemegado eduwo tada boečoji. Jeture carneiro doge eiwu umode turemo etae nou eda ibora baiporoji. Mare iwogureu umodukare turemo nou edu tadawu ibora baiporoji. Umode turemo edu tadawu ibora kujiado. ");
INSERT INTO bor_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nou jeture nou ibora baiporo jiwu umode nou carneiro doge eda baiporo jado nou jeture carneiro doge eiwu uwo turemo carneiro doge etae. Nou jeture carneiro doge eiwu jorduware tagu carneiro doge ekieji. Dukodire makomode tagu carneiro doge ewagai dukeje erduware makoji. Kodire etumode rekodaji tieda piji. ");
INSERT INTO bor_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Umode etawuje eda piji dukeje etumode rekodaji rugadu erduware jetu pemegare puduiwu makoji rugadu. Jeture eiwu utumode etododai. ");
INSERT INTO bor_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Carneiro doge etumodukare ia boe eregodaji rugadu. Ia makomode ewagai mare eregodumode piji rugadu. Erduwakare makoji dukodi eregodumode piji. ");
INSERT INTO bor_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus makore nou inoduji boe ewiagai mare nou boe erduwakare kaba jiba akoino. ");
INSERT INTO bor_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nono Jesus makore ei pugeje. Akore: – Boe jokodu jire inagoino tawiagai. Ire nono nou carneiro doge eda kejewu bai poro mogadure. Mare bai poro ji karega inagoino. ");
INSERT INTO bor_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Meartorure iwuge ere nono carneiro doge emogadure. Mare carneiro dogei karega inagoino. Marigudu iage etaregodure tuwo boe erego ikoda piji mare meartorure iwuge ewiapagakare ei. ");
INSERT INTO bor_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","10","Iwogureu aidure tu tuwo tugeragu boeji boe epiji. Aidure tu tuwo boe ewido. Aidure tu tuwo boe etagedudo. Mare imire ire nono bai poro remawu mogadure. Mare bai poro ji karega inagoino. Boe etumode itae dukeje imode ekodiwado tugodure jiboeji. Ča itaregodure woe iwo boe emugu pemegado. Emugu pemegamode rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","– Jetu pemegare carneiro dogeiwu umode iaboedo tuwido tuwo tagu carneiro doge ekinorudo barege pegareuge epiji. Ča iromode nono nou jetu pemegare carneiro dogeiwu ro mogadure. Mare carneiro doge ewugeje karega imode imagu boe etai. Imode imagu ro pegareuge etai iwo boedo činorudo boe pegareu piji. ");
INSERT INTO bor_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Nou akure carneiro doge ečewu utugare biagoromodukare tietu pemegawo carneiro dogei. Aku ie karega. Dukodire rekodumode nou barogo pegareu piji. Umode tugera ra carneiro doge epiji. Dukeje nou barogo pegareu umode tugeragu ia carneiroji. Umode nouia carneiro doge edo taodo pubiji toro boe maereu ka. ");
INSERT INTO bor_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ča irore nono nou jetu pemegare carneiro dogeiwu ro mogadure. Mare carneiro dogei karega inagoino. Ietu pemegamode boe dogei rugadu. Iogwa Kurireu jorduware i. Iorduware Iogwa Kurireuji jamedu. Nono iorduware meartorure iwugei rugadu. Meartorure iwuge erduware i rugadu. Ire irugadu iwiwo emugato. ");
INSERT INTO bor_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ia boe emeartorumode i jamedu. Mare eragojekare woe. Imode ikeragu ei jamedu emugu pemegawo itabo rugadu. Ewiapagamode iwadaruji rugadu. Meartorumode iwuge eiamedu boe emugumode puapo. Jetu pemegare eiwu umode mitotu je. ");
INSERT INTO bor_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","– Ire irugadu iwiwo dukodire Iogwa Kurireu meardu kurire i rugadu. Dukodire umode iewodudo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Imi imode imagu boe pegareuge etai itaidu tabo ewo iwido. Itaidumode imode imagu. Itaidumode iewoduwo dukeje iewodumode. Ainore Pao kurireu akore iroiago. ");
INSERT INTO bor_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesus makore aino dukeje nou boe emeardaekare nono pumeardae mogadure pugeje nou Jesus bataru keje. ");
INSERT INTO bor_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iage egore: – Ia bope uwari meture awu Jesus tada. Aora bai baire rugadu. Pawiapagamodukare ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mare iage egore: – Ia bope uwari metumode tada dukeje makomodukare aino. Romodukare aino. Ure joku bokwareu aiwodo pugeje. Ča bope uwari meture tadawu romode aino? Romodukare aino! ");
INSERT INTO bor_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Biaku buture dukeje nou Judeu doge ewadure ia tuwadaeji Jerusalém ba kurireu keje. Nou tuwadae tabore ewiabuture ture Pao Kurireu uwai rakojedo du ka. ");
INSERT INTO bor_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus merure Pao Kurireu uwai ja tada. Salomão Uwai Jokora jire merure. ");
INSERT INTO bor_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nono boe ere bato pui ae dukeje enarare ji. Egore: – Akare čewie marigudu dukodire boe raire čerduwawo ai rugadu. Ča čewiedu pemegado. Aki na amode boe ekinorudo? Čebagare bagaiwu nure aki? ");
INSERT INTO bor_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus akore: – Ire tawie marigudu. Mare tameartorukare i. Iogwa Kurireu ure iro rakado tameartoruwo iro rakare rugadu duji. ");
INSERT INTO bor_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mare tameartorukare i. Iwobe karegure tagi. ");
INSERT INTO bor_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Meartorure iwuge eromode nono carneiro doge ero mogadure. Ire nono jeture carneiro dogeiwu mogadure. Mare carneiro dogei karega inagoino. Meartorure iwuge ewiapagamode iwadaruji. Iorduware ei. Ekodumode iregodaji. ");
INSERT INTO bor_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Imode emugu pemegado. Du akedumodukare rugadu. Ewimodukare pugeje. Ia boe emodukare tugeragu ei ipiji. ");
INSERT INTO bor_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Imeardu kurire awu Iogwa ure maku inaiwugei. Iogwa Kurireu jetu pemegamode ei rugadu dukodire ia boe emodukare tugeragu ei Iogwa piji. ");
INSERT INTO bor_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iogwa imi čere aino pure tu je. ");
INSERT INTO bor_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nono boe ere tugeragu toriji tuwo tori to Jesusji. ");
INSERT INTO bor_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mare Jesus makore ei. Akore: – Iogwa Kurireu koiare ure iro rakado. Tardure nou iro pemegareuji. Kodiba tagaidure tawo iwido? ");
INSERT INTO bor_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Egore: – Aro pemegakare kodi. Imedu nure aki. Mare akaidure awo Pao Kurireudo aki. Mare akagoino dutabo amago peganure Pao Kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nono Jesus akore: – Pao Kurireu ure taro maku tagai dukodi nou taro padure bapera keje nou tago bakaru tada. Nou bakaru akore: “Pao Kurireu ore nure tagi.” ");
INSERT INTO bor_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Boe jokodu jire bapera kejewu Pao Kurireu bataru akoino. Ainore ure jii aino. Akedumodukare rugadu. Ča Pao Kurireu ure tuwadaru maku boe etai. Emare makore ei tore nuie emage. ");
INSERT INTO bor_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mare imi. Iogwa Kurireu ure tugeragu i. Ure itarego mato moto ka. Imire inagoino Pao Kurireu Onaregedu nuie imi. Itaidukare tamago pegawo i. Imi imago pegakare Iogwa Kurireuji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iromodukare Iogwa Kurireu aidure jiboeji dukeje tameartorumodukare i. ");
INSERT INTO bor_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tameartorumodukare i mare iromode Iogwa Kurireu aidure jiwu iro rakareuji dukeje tameartorudo iro rakare jiboeji. Tameartorumode irore jiboeji dukeje tarduwamode Iogwa merure itabo rugadu duji. Tarduwamode iragojere Iogwa Kurireu apo rugadu duji. Čere aino pure tu je. ");
INSERT INTO bor_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ča ere tuiago tugeragu Jesusji rugadu mare Jesus ure tumegido pači toro epiji. ");
INSERT INTO bor_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nono uture pugeje. Kurugodure Jordão po kajeje toro João Batista ure boe etao pegodo kejewu ka. Nonore Jesus rakojere tu jao. ");
INSERT INTO bor_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nonore boe etaregodure Jesus ae pugeje. Emagare. Egore: – João Batista ro rakareu bokware. Mare ure boe erduwado Jesus jiboe jamedu boe jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dukodire boe emagare nono tumeartorure Jesus jitu tabo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ia imedu kogodure. Mugure Betânia ba kurireu keje. Nou imedu iere Lázaro. Uwie aredu iere Maria. Nou Maria utuie iere Marta. Eiamedu boe emugure nou Betânia ba kurireu keje. ");
INSERT INTO bor_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Marigudu nou Maria ure roreboe pemegareu reko Jesus bure joki. Ure reko dukejere ure kidudo tao tabo pugeje. Mare aino čare uwuri kogodure. ");
INSERT INTO bor_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dukodire nou Maria, nou Marta ere boe erego tuwadaru tabo toro Jesus bagai. Egore nou boe egoiago nou Jesusji tuwuri kogoduie. Meardu kurire jiwu tuwuri kogoduie. ");
INSERT INTO bor_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nou boe etaregodure Jesus ae dukeje ere Jesus bie nou areme ewadaruji. Jesus meardure nou ewadaruji dukeje akore: – Iorduware nuba boe mode nou imedu Lazaruji. Kogodure mare bimodukare. Kogodure Pao Kurireu ie kuriwo. Lázaro bimodukare dukodi Pao Kurireu ie kurimode boe emago pemegawo ji. Lázaro bimodukare dukodi Pao Kurireu Onaregedu ie kurimode boe emago pemegawo ji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus meardu kurire Martaji, Mariaji, Lazaruji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","Mare utukare toro ewai ka kuri je. Merire pobe ji nono dukejere makore nou ture jorduwadowugei. Akore: – Pugeje. Pawo pagirimi toro Judéia moto ka Lázaro uwai ka. ");
INSERT INTO bor_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mare etaidukare utuwo. Egore: – Čegimijera. Maibari nou jeture Judéia moto kejewuge etaidure tuwo awido tori tabo. Atukaba toro pugeje. ");
INSERT INTO bor_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mare Jesus akore: – Meri oto padukare doze hora raga. Boe emerumode meriji dukeje ewure jetumodukare iaboeji erdure boeji kodi. Meri jire boe etaiwo pemegare. ");
INSERT INTO bor_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mare boe emerumode boečoji dukeje ewure jetumode iaboeji rugadu jorugu bokware kodi. ");
INSERT INTO bor_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nono Jesus makore ei: – Pamedia Lázaro unudunure mare itumode toro bagai iwo jetadudo. ");
INSERT INTO bor_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nou ure jorduwadowuge egore: – Ča unudure. Čare pemegagodumode. ");
INSERT INTO bor_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Erduwakare Jesus ure tuwadaru inodudo pudui duji. Jesus akore Lázaro unudunuie mare jorduware Lázaro bire duji. Dujire akoino. Mare nou ure jorduwadowuge emeardaere Lázaro unudunuie rugadu duji. Emeardaere bikaie raga. ");
INSERT INTO bor_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dukodi čare Jesus mako pemegare ei. Akore: – Lázaro bire rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iragojekare toro apo iwo pemegago. Mare aino tardumode iraga rakare duji. Dukodi tameartorumode i rugadu. Ča paduwo toro bagai. ");
INSERT INTO bor_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nono Tomé makore tumedagei. Akore: – Pagimijera bimode toro Judéia moto keje. Paduwo toro pagimijerapo pawiwo apo jamedu. Boe egore “Tomé” aino ji. Judeu doge ewadaru tabo egore “emegure puapowu”. ");
INSERT INTO bor_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ča Jesus uture toro Betânia ba kurireu ka ture jorduwadowugebo. Etaregodure dukeje boe ere Jesus bie Lázaro bie marigudu. Egore tuie merido pobe puibiji ji meture moto tada dukeje. Aino ča Jesus aregodure. ");
INSERT INTO bor_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Ča Judéia moto kejewuge etaregodure nou Lázaro uwiemage ewai ka tuwo uwie Marta, uwie Maria ewudugugo. Nou boe emagare rugadu. Etaregodure Maria ae Marta ae tuwo etaora butugugo ewiagoduwo nou tuwuri piji. Nou Betânia ba kurireu padu puredure Jerusalém ba kurireuji. Du ure três quilômetros. ");
INSERT INTO bor_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ča Marta jorduware Jesus aregodure duji dukeje ure tudawuje tuwai piji Jesus togi. Mare Maria ukare tudawuje. ");
INSERT INTO bor_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta aregodure Jesus ae dukeje makore ji. Akore: – Aragojemode woe čedabo čewuri bimodukare. ");
INSERT INTO bor_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mare iorduware Pao Kurireu umode amagore bagaiboe maku akai rugadu duji. ");
INSERT INTO bor_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus makore Martaji. Akore: – Awuri jewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta akore: – Iorduware. Ia meri keje awu moto akedumode dukeje iwuri jewodumode pugeje turuduwo baruto. ");
INSERT INTO bor_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nono Jesus makore ji. Akore: – Imire ire boe etowuje. Imire imode boe eewodudo rugadu. Meartorure iwuge ewimode mare eewodumode pugeje. ");
INSERT INTO bor_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Meartorure iwuge ewimodukare pugeje jamedu. Meartorure iwadaru jiwuge ewimodukare pugeje rugadu. Ameartorure nou inoduji? ");
INSERT INTO bor_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta akore: – Uu! Imeartorure rugadu. Čebagare bagaiwu umode boe ekinorudowu nure aki. Pao Kurireu Onaregedu nure aki. Pao Kurireu ure jawu pawobe ewie marigudu akaregodumoduie mato moto ka duji. ");
INSERT INTO bor_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta ure tuwadaru akedudo Jesusji dukeje ure tugirimi tuwai ka. Makore tuwie Maria bagai. Makore tu ji. Akore: – Pagimijera aregodu. Makore awagai. ");
INSERT INTO bor_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria meardure nou tuduie bataruji dukeje ure tuie bu tači je. Ure tumara tabo pudui toro Jesus togi. ");
INSERT INTO bor_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus aregodukare nou Betânia ba kurireu ka raga mare rakoje kimore toro tuiordure Marta jiwu awara keje. ");
INSERT INTO bor_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nou rakojere Maria uwai tadawuge erdure Maria uture toro duji. Dukeje eture rekodaji. Emeardaere Maria utumoduie toro bireu bagai traguduwo joki. ");
INSERT INTO bor_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mare Maria uture Jesus togi. Jordure Jesus jitu keje ure tuwududo moto keje Jesus bure paru. Makore Jesusji. Akore: – Čegimijera. Aragojemode woe dukeje iwuri bimodukare. ");
INSERT INTO bor_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus aiwore ji akoe tragudu tabo duji. Nono jordure nouia boe etragudure jamedu duji. Okudugodure ebo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nono makore ei. Akore: – Kaiba tare tugu? Egore: – Mato ka. ");
INSERT INTO bor_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Eture apo toro ture Lázaro tugu towu tori poro ka. Nono Jesus ragudure. ");
INSERT INTO bor_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nou boe erdure Jesus ragudure duji dukeje emagore pui. Egore: – Ča Jesus meardu kurire Lazaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mare iage egore: – Kočare. Ure joku bokwareuge etaiwodo pugeje. Kodiba aregodukare kuri je tuwo Lázaro pemegago bikawo? ");
INSERT INTO bor_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus okudugodure nou Lázaro uwobebo rugadu. Dukejere ure tuburedo nou bireu padure tadawu tori poroji. Ia tori kurireu padure nou tori poro je keje. ");
INSERT INTO bor_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dukeje Jesus makore nou boei. Akore: – Nou tori kurireu tawuje tori poro je piji. Mare Marta akore: – Merire pobe puibiji ji meture nou tori poro tada duji. Dukodire kigogodure rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mare Jesus makore ji. Akore: – Ire awie. Ameartorumode i dukeje ardumode Pao Kurireu ro rakare duji. ");
INSERT INTO bor_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nono nou boe ere nou tori kurireu tawuje nou tori poro je piji. Nono Jesus aiwore baruto dukeje akore: – Iogwa Kurireu. Awiapagare iwadaruji. Dukodire itaidure imago pemegawo ai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iorduware awiapagare iwadaru jituji rugadu mare itaidure iwo awu boe erduwado nou inoduji jamedu emeartoruwo i, emeartoruwo aki aigoiare are itarego mato rugadu duji. ");
INSERT INTO bor_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesus ure tuwadaru akedudo tuo bagai dukeje makore toro nou Lázaro bagai. Akore: – Lázaro! Ae bu mato nou tori poro piji! ");
INSERT INTO bor_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ča Lázaro ure tudawuje nou tori poro piji rugadu! Bikare pugeje. Jewodure pugeje rugadu. Nou boe ere upodo tabowu areia upo kimore apo. Upo kimore je tabo jamedu. Nono Jesus makore nou boei. Akore: – Nou areia tawuje piji utuwo tuwai ka. ");
INSERT INTO bor_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nou rakojere nonowu boe eiamedu boe erdure Jesus rore aino duji. Dukodire emeartorure Jesusji. ");
INSERT INTO bor_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mare iagere tugirimi tuibagi Jerusalém ba kurireu ka. Eture tugimijerage fariseu doge etae tuwo ewie Jesus rore jiboeji. ");
INSERT INTO bor_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dukodire nou fariseu doge ere bato pui nou Judeu doge eimijeragebo. Nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage edure nono jamedu. Emororamagadure rugadu boe emeartorumodukare pudui pugeje duji. Emagore pui. Egore: – Nuba paromode? Nou imedu Jesus ro rakare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Boe eiamedu boe emeartorumodukare pai pugeje tumeartoruwo awu imedu Jesusji. Nono Roma kejewuge boe eimijerage erdu pegamode boe eroino duji jamedu. Dukodire Roma kejewuge boe eimijerage etaidumode turo pegawo pai. Emode awu Pao Kurireu uwai pegado. Emode pawobe etagedudo. ");
INSERT INTO bor_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Awu joruji nou ure Judeu doge enomea maku Pao Kurireu aiwuge boe eimijera kurireu iere Caifás. Rakojere nono nou boe eimijeragebo jamedu. Makore nou tumedagei. Akore: – Tarduwa bokware. ");
INSERT INTO bor_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Boe pegakawo pai pawo nou imedu bito pawobe ewo činorudo Roma kejewu boe eimijerage pegareuge epiji. Pamodukare bito paiamedu boe pawimode. ");
INSERT INTO bor_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nou Caifás nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu nure ema nou joruji. Dukodire Pao Kurireu ure tumeardae maku ai makowo nou tuwadaruji nou boe eimijerage ewiagai. Mare nou Caifás jorduwakare Pao Kurireu bataru taboie tagoino duji. Akomode pudumie tagoino. Mare ema karega akoino. Pao Kurireure akoino. Ainore Pao Kurireu rore tuwo boe ewie Jesus bimoduie duji Judeu doge ero pegareu boe moriče. ");
INSERT INTO bor_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesus bimode boe eiamedu boe ero pegareu moriče jamedu. Dukodire meartorure Jesus jiwuge eiamedu boe Pao Kurireu oremode emage. Etuwobe mode pugi. ");
INSERT INTO bor_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nou meri otobiji nou Judeu doge eimijerage ere tumeardae pegareu tawuje tuwo Jesus bito. ");
INSERT INTO bor_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesus jorduware emeardaeji. Dukodire merukare Judéia motoji pugeje mare utu jaere ia moto akurugudu maereu ka. Uture ture jorduwadowugebo toro ia boe eda ka. Nou boe eda iere Efraim. Nonore rakojere ture jorduwadowugebo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Boe puredugodure Judeu dogei ewaduwo ia tuwadaeji. Nou ewadae iere Páscoa. Dukodire boe emagare tudu tabo Jerusalém ka Judéia moto piji tuwo tubemegado turowo nou to bakaru tadawu turo boeji tuwaduwo nou tuwadae Pascoaji. ");
INSERT INTO bor_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Nou fariseu doge, nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage emagore boe eiamedu boei ewo Jesus maku pudai. Boe erdumode Jesusji dukeje ewo nou boe eimijerage ewie nou boe eimijerage ewo tugeragu Jesusji. Dukodire nou boe etaiwore Jesus bagai nono Pao Kurireu uwai tada. Emagore pui. Egore: – Nuba tameardaere? Jesus aregodumokana? Iage egore: – Aregodumodukare. Jorduware pagimijerage etaidure turo pegawo pudui duji. ");
INSERT INTO bor_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ča Jesus uture Betânia ba kurireu ka pugeje. Uture ture jewodudowu Lázaro uwai ka. Okwareu meri oto padure seis Judeu doge ewaduwo tuwadae Pascoaji. ");
INSERT INTO bor_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ča Jesus rakojere nou Lázaro uwai keje. Nou uwai kejewuge ere boe eke pemegado Jesus uwo kowuje. Aredu Marta ure ia boe eke maku Jesus ai. Lázaro mugure nou ira keje togwagewo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nono Maria aregodure roreboe mori kurireu tabo. Nou roreboe iere nardo. Nono Maria ure nou roreboe reko Jesus bure joki nou boe erduwawo boe eimijera kurireu nure ema duji. Dukejere ure Jesus bure kidudo tao tabo. Nou roreboe ro jore nou bai oto jamedu boeto. ");
INSERT INTO bor_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nono Jesus ure jorduwadowu imedu makore ji. Nou imedu iere Judas Iscariotes. Ema koiare umode Jesus maku boe eimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Akore: – Kodiba awu aredu ukare nou roreboe maku diero bagai tuwo diero kurido tuwo maku marenarue doge etai? Awu roreboe mori kurire rugadu. Boe emaragodumode jii joru akedu ka tuwo tugeragu nou diero kurireuji tuwo akirodo awu roreboeji. ");
INSERT INTO bor_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mare pagare Judas akoino. Aidukare tuwo diero maku marenarue doge etai. Aidure tugiwoguwo ji. Jesus ure nou Judas jetudo to dieroji. Mare nou Judas iwogure tu tu Jesus o dieroji. ");
INSERT INTO bor_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mare Jesus akore: – Akaba awu aredu pogurudo rore i duji. Ure reko iwure joki tuwo iwiri udo turugadu ituguduwo mototo iwi keje nono Pao Kurireu meardae mogadure. ");
INSERT INTO bor_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Marenarue doge edumode tagabo jii toro rugadu. Mare imire itumode tabiji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Boe erduware Jesus rakojere Lázaro uwai keje Betânia keje duji. Dukodire eture toro ae. Emagare. Etaidure tuiorduwo nou Jesus ure jewodudowu Lazaruji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Mare nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage etaidukare nou Lazaruji jamedu. Jesus ure Lázaro jewodudo dukodire Judeu doge emeartorukare nou ure Judeu doge enomea maku Pao Kurireu aiwugei pugeje tumeartoruwo Jesusji. Dukodire nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere tumeardae pegareu tawuje tuwo Lázaro bito jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nou barogwato boe emagare nono Jerusalém ba kurireu keje tuwaduwo nou tuwadae pascoaji. Erduware Jesus aregodumode pudae duji. ");
INSERT INTO bor_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dukodire ere tugeragu apidoguru aiji. Eture tabo toro Jesus togi. Ekudugodure bagai. Egore: – Israel kejewu boe eimijera kurireu reo! Pao Kurireu ure arego mato pagae. Ure turaga maku ai rugadu. Boe eiamedu boe emago pemegawo ji rugadu! Pao Kurireu uwo boe pemegado ji rugadu! ");
INSERT INTO bor_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nono Jesus jordure ia jumenta onaregeduji. Mugure keje tuduwo Jerusalém ba kurireu ka. Marigudu Pao Kurireu makore ainoie Jesus romode rugadu. Akore: ");
INSERT INTO bor_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","– Awu mugure Jerusalém kejewuge tagi. Tabagudukaba. Tagimijera kurireu mugumode jumenta onaregedu keje taregoduwo tagae. ");
INSERT INTO bor_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nou Jesus ure jorduwadowuge erduwakare nou Pao Kurireu akoino jiboeji. Mare ia meri keje Jesus jewodumode pugeje. Jesus jewodumode pugeje dukeje nou ure jorduwadowuge ewiabutumode nou Pao Kurireu bataru keje. Dukodi čare erduwamode ji. Erduware Pao Kurireu makore Jesus jiboeji jeture pudui rugadu duji. ");
INSERT INTO bor_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesus ure Lázaro jewodudo pugeje dukeje ia boe ere boe eiamedu boe ewie nou Jesus rore aino duji. Erdure Jesus rore aino duji dukodi čare ere boe ewie. Dukodire boe eiamedu boe erduware Jesus ro rakare duji. ");
INSERT INTO bor_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dukodire boe emagare tugodui Jesus togi. ");
INSERT INTO bor_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mare fariseu doge etaidukare. Egore pui: – Tagaiwodo. Boe erore tači pabiji. Boe eiamedu boe emeartorure awu Jesusji. Dukodire erore tači pabiji toro togi. ");
INSERT INTO bor_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ia Grécia kejewuge eragojere Jerusalém ba kurireu keje tuwaduwo nou Judeu doge ewadaeji ebo tumago pemegawo Pao Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eture Filipe ae. Nou Filipe boture Betsaida ba kurireu keje. Nou Betsaida ba kurireu mugure Galiléia moto keje. Nou Grécia kejewuge emagore nou Filipiji. Egore: – Čedaidure čerduwo Jesusji. ");
INSERT INTO bor_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe uture André ae. Ure André bie nou Grécia kejewuge etaidure jiboeji. Dukejere eture puapo Jesus ae tuwo Jesus bie. ");
INSERT INTO bor_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dukeje Jesus makore ewadaru jipagi. Akore: – Imedu Onaregedu nure imi. Kuri aino boe erduwamode boe kurireure imi duji, boe pemegareure imi duji. ");
INSERT INTO bor_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Boe jokodu jire inagoino. Boe emodukare ia trigo a tugu mototo botuwo dukeje botumodukare rugadu. Mare umode mitotu je tu rugadu. Mare boe emode trigo a tugu mototo dukeje nou trigo enogo botumode. Mare botumode dukeje nou trigo a pegagodumode moto tada. Botumode dukeje ričodumode enarimode. A makamode rugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ia boe etaidu kurimode turowo taidure jiboeji turaga tabo tu rugadu. Nou boe eraga akedumode epiji rugadu. Egare remawu modukare. Nou boe ewarigudumode toro bope doge eda kejewu joru pegareuto jamedu. Mare ia boe etaidumodukare tumeardaere jiboeji tuwo tugera ra taidure jiboe piji tumeartoruwo Pao Kurireuji dukeje boe pemegamode ei rugadu. Egare remawumode rugadu. Ewarigudumodukare bope doge eda kejewu joru pegareuto jamedu. Mare emugumode baru tada jii toro rugadu. Du akedumodukare. ");
INSERT INTO bor_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ia boe aidumode tumeartoruwo iwadaruji dukeje umode tugera ra taidure jiwu turo tago pegareu boe piji tuduwo itabo. Dukeje nou meartorure iwu rakojemode itabo. Iogwa Kurireu umode boe pemegado meartorure iwadaru jiwugei. Mako pemegamode ei rugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","– Boe ero pegamode i dukodire ikiarigodure rugadu. Mare imago pegamodukare Iogwa Kurireuji uwo ero pegamode idu utudo ipiji. Boro. Iogwa ure maku inaiwu imaragodae koiare boe ero pegamode i. Dukodire itaregodure woe moto ka. ");
INSERT INTO bor_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dukeje Jesus makore baruto tuo bagai. Akore: – Iogwa. Boe erdudo aro kurireuji boe erduwawo akurire rugadu duji. Nono Pao Kurireu makore baru piji. Akore: – Ire boe erdudo iro rakareuji marigudu. Imode erdudo iro rakareuji pugeje, iro pemegareuji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Boe emeardure nou baru pijiwu makoji. Iage emeardaere boeiaruruie akoino. Mare iage egore: – Ia Pao Kurireu utugare baru tadawure akoino baru piji Jesusji. ");
INSERT INTO bor_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mare Jesus makore ei. Akore: – I karega akoino mare taire akoino tarduwawo Pao Kurireu bataruji. ");
INSERT INTO bor_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kuri aino Pao Kurireu aiwomode awu moto kejewuge eiamedu boe eroji ero pemegareu bagai, ero pegareu bagai jamedu. Kuri aino Pao Kurireu umode awu moto kejewu bope doge eimijera raka ta piji. ");
INSERT INTO bor_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Boe emode ipo padure pugajejewu rakojedo itabo dukeje imode boe emeartorudo i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus akoino nou boei tuwo erduwado nuba boe eromode pudui tuwo tuwido ipo padure pugajejewu keje. ");
INSERT INTO bor_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nou boe egore: – Pago bakaru ure parduwado. Akore umode boe ekinorudowu bimodukaie. Akedumodukaie. Mare akagore Imedu Onaregedu bimoduie ipo padure pugajejewu keje. Ioguduba nure aki? ");
INSERT INTO bor_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus akore: – Jorugu pemegareu rakojemode tagabo tu je. Tamerudo nou jorugu tabo. Tamerumode jorugu tabo dukeje boečomodukare tumaedo taiogi. Merumode boečo kaowu jorduwamodukare kaiba tuiomode. Mare boečo ji karega inagoino. Boe ero pegareu jire inagoino. Jorugu ji karega inagoino jamedu. Ire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iragoje kimore tagabo dukeje tameartorudo i rugadu. Tameartorumode i dukeje tarduwamode taro pemegawo nono boe erdure boeji jorugu tada dumogadure. Mare jorugu ji karega inagoino. Boe ero pemegareu jire inagoino. Jesus ure nou tuwadaru akedudo dukeje uture boe epiji tuwo tuwiado epiji. ");
INSERT INTO bor_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ure turo rakareu towuje nou boe egai. Ure epemegado. Ure boe pemegado ei. Mare emeartorukare Jesusji. ");
INSERT INTO bor_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Erore aino dukodire Isaías makore jiboe mariguduboe jeture pudui rugadu. Emare makore Pao Kurireu bataruji marigudu. Marigudu ure Pao Kurireu bataru bu bapera keje. Akore: – Pao Kurireu nure aki. Boe emeartorumodukare are maku inaiwu awadaruji. Ire boe ewie ji mare emeartorukare Pao Kurireu nure aki duji. Are boe erdudo aragaji. Mare emeartorukare ai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nono nou boe eroiwakare tumeartoruwo rugadu. Ainore Isaías akore marigudu: ");
INSERT INTO bor_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","– Pao Kurireu ure erduwa bokwado emeartorukawo pudui. Pao Kurireu akore: “Ire eku bokwado. Ire etaora pegado. Mare emeardae remawu jire inagoino. Dukodire ekure mare emeardaemodukare taiwowo irore jiboeji. Etaorare mare erduwamodukare irore jiboeji. Dukodire emodukare tugera ra turo pegare jiboe piji tumeartoruwo i rugadu. Dukodire imodukare ekinorudo ero pegareu piji.” ");
INSERT INTO bor_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Marigudu rugadu Isaías makore. Emare jordure Jesus ro pemegamode jiboeji, ro rakamode jiboeji. Dukodire ure awu bataru bu bapera keje. ");
INSERT INTO bor_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma čare ia Judeu doge eimijerage emeartorure Jesusji. Mare fariseu doge etaidukare Jesusji dukodire nou meartorure Jesus jiwuge emagokare boeji. Emagokare tumeartorure Jesus jituji. Emagomode dukeje fariseu doge emode etudo nou Judeu doge ere bato puiwu bai piji. ");
INSERT INTO bor_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Etaidu kurire boe emago pemegawo pudui. Dukodire etaidu kurikare Pao Kurireu mako pemegawo pudui epagudure nou boe eimijerageče dukodi. ");
INSERT INTO bor_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus uwadodure tuwadaru tabo nou boe eiamedu boe emearduwo tagoino jiboeji. Akore: – Meartorure iwuge emeartorumode ure itarego matowuji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jordure iwuge erdure ure itarego matowuji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Itaregodure mato moto ka iwo nono jorugu mogadure. Mare jorugu ji karega inagoino. Iwo boe ewie turo pegareuji. Dujire inagoino. Boe emeartorumode i dukeje emerumodukare boečo kao pugeje. Mare boečo ji karega inagoino. Boe emeartorumode i dukeje emode tugera ra turo pegareu piji. Dujire inagoino. ");
INSERT INTO bor_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mare boe emeartorumodukare iwadaruji du inodu tabo imodukare boe pegado ei kuri aino. Iwo boe pegado boei dubagai karega iroino mato. Itaregodure iwo boe ekinorudo bope doge eda kejewu joru pegareu piji. ");
INSERT INTO bor_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mare ia meri keje boe pegamode meartorukare iwugei, aidukare iwugei. Awu moto akedumode dukeje imode ewiabutudo awu iwadaru keje dukeje boe pegamode ei rugadu emeartorukare i kodi. ");
INSERT INTO bor_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Boe rugadu jire inagoino. Mare iwadaru karega. Iogwa Kurireu koiare ure itarego mato. Emare ure awu iwadaru maku inai iwo boe ewie ji. Dukodire imagore jiboe ure turugadu. ");
INSERT INTO bor_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iogwa Kurireu bataru umode meartorure puduiwuge ekinorudo eduwo pudabo jii toro. Du akedumodukare. Awu tuwadarure Iogwa Kurireu ure maku inai iwo boe ewie ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ča okwareu merire mitotu je Judeu doge ewaduwo tuwadae Pascoaji. Dukodire Jesus jorduware tudumode baruto kuri aino duji awu moto piji Tuo bagai. Jesus meardu kurire meartorure puduiwugei rugadu. Meardu kurire ei jii toro tuwimodedu ka. ");
INSERT INTO bor_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nou boečoji Jesus ure tumugudo ia bai tada togwagewo nou ture jorduwadowugebo. Bope doge eimijera ure tumeardae pegareu tugu Judas aorato tuwo Jesus maku boe eimijera pegareuge etai. Nou Judas uo iere Simão Iscariotes. ");
INSERT INTO bor_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus jorduware Pao Kurireu ure turaga jamedu boe maku pudai duji. Jorduware taregodure Pao Kurireu piji rugadu. Jorduware tudumode tuibagi Pao Kurireu ae pugeje duji. ");
INSERT INTO bor_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dukodire Jesus ure turagojedo nou bai tada. Ure tugudau areia biaku epa tawuje tubiji. Ure ia areia kogudo tubeagajeje. ");
INSERT INTO bor_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dukejere ure pobo redo pori piji ia meririto. Nono ure nou ture jorduwadowuge ewure kabi nou pobo tabo. Ure ewure kabi dukeje ure ekidudo nou areia tabo. ");
INSERT INTO bor_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uiago Simão Pedro bure kabi dukeje Simão Pedro makore ji. Akore: – Ukare turugadu awo iwure kabi. Ikimijera nure aki kodi. ");
INSERT INTO bor_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus makore Simão Pedroji. Akore: – Arduwakare irore jiboeji. Mare ia meri keje arduwamode. ");
INSERT INTO bor_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simão Pedro akore: – Amodukare iwure kabi rugadu! Mare Jesus makore ji pugeje. Akore: – Imodukare awure kabi dukeje ire jorduwadowu modukare aki pugeje. ");
INSERT INTO bor_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nono Simão Pedro akore: – Ča iwure kabi. Itaora kabi. Ikera kabi. Iamedu boe kabi. ");
INSERT INTO bor_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus akore: – Boe emode taimo dukeje ekabidure rugadu. Dukeje etumode tuibagi tuwai ka dukeje emodukare taimo pugeje kuri aino. Tu tuwurere emode kabi. Mare boe ewiri ji karega inagoino. Boe ero pegareu jire inagoino. Ča Pao Kurireu ure taro pegareu jamedu boe barigu tabiji. Mare ia imedu ro pegareu ure mitotu tagabo. Pao Kurireu ukare nou imedu ro pegareu barigu piji. ");
INSERT INTO bor_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus jorduware nou imeduji dukodire akoino. Nou imedu umode Jesus maku boe eimijera pegareuge etai. Jesus jorduware nou imedu romode pudui duji. Dujire akoino nou ture jorduwadowugei. Akore: – Pao Kurireu ukare ia imedu mitotu jedu ro pegareu barigu piji. ");
INSERT INTO bor_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesus ure nou ture jorduwadowuge ewure kabi dukeje ure tugudau areia jamedu tugu pudui pugeje. Dukejere ure tumugudo tumuga ira keje. Nono akore: – Kodiba ire tawure kabi? Imode tarduwado. ");
INSERT INTO bor_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tagagore “Jorduwareu” aino i. Tagagore “Boe Eimijera” aino i. Boe jokodu jire tagagoino. Ure Tarduwadowu nure imi rugadu. Tagimijera nure imi rugadu. ");
INSERT INTO bor_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mare ire ido nono tadugaregere iwo tawure kabi. Tarowo nono iro mogadure. Dukodire tamode pu bure boe kabi. Tamode tagera maku puai. ");
INSERT INTO bor_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ire tardudo iroji tarowo nono iro mogadure tarduwawo nuba taromode. ");
INSERT INTO bor_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Boe jokodu jire inagoino tai. Boe emeartorumodukare ia boe eimijera utugareji ukimijera kori. Boe emeartorumodukare ia boe eimijera utugare uture tugimijera bataru tabowuji tugimijera kori jamedu. ");
INSERT INTO bor_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dukodi čare tarodo nono iro mogadure jamedu. Taromode nono iro mogadure dukeje taegaregodumode tai. Boe pemegamode tai rugadu. Tawiagodukaba awu ire tarduwado jiwu iwadaru piji. ");
INSERT INTO bor_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","– Iorduware ire ikeragu jiwugei. Taire inagoino tarowo nono iro mogadure. Mare ia romodukare aino. Pao Kurireu ure boe ewie marigudu. Akore: “Okwagere itabowu jordu pegamode i.” ");
INSERT INTO bor_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ča itaidure iwo tawie tarduwawo nuba boe mode i duji. Nou iwadaru jetumode pudui dukeje tarduwamode i rugadu. Pao Kurireu nure imi rugadu. Itagedumodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Boe jokodu jire inagoino. Boe emode tugera upodo nou uture iwadaru tabowugebo enure tugera upodo itabo jamedu iragojere nou uture iwadaru tabowugebo kodi. Pao Kurireu koiare ure itarego boe etae rugadu. Dukodire boe emode tugera upodo itabo enure tugera upodo Pao Kurireu apo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus ure nou tuwadaru akedudo dukeje kiarigodure rugadu. Dukodire makore pugeje. Akore: – Iwo tawie boe remawuji. Ia tagi tamode imagu boe eimijerage pegareuge etai. ");
INSERT INTO bor_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nou Jesus ure jorduwadowuge etaiwore pui. Erduwakare kaba jiba Jesus akoino. ");
INSERT INTO bor_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ia mugure Jesus meki. Jesus meardu kurire nou ture jorduwadowuji. ");
INSERT INTO bor_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nono Simão Pedro ure tugera nado ae utuwo pudae. Nono makore ji. Akore: – Anarado ji uwo pawie ioguduba jiba akoino. ");
INSERT INTO bor_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dukodire nou Jesus ure jorduwadowu ure tuburedo Jesusji tunarawo ji. Akore: – Ioguduba jiba akagoino? ");
INSERT INTO bor_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus akore: – Imode awu amireu pegodo nou iaboe kuru to dukeje imode maku ia imedu ai. Nou imedu koiare umode imagu boe eimijerage pegareuge etai. Nono Jesus ure tugeragu amireuji. Ure pegodo tagoino jiboe kuruto. Dukejere ure maku Judas ai. Nou Judas uo iere Simão Iscariotes. ");
INSERT INTO bor_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ure tugeragu nou amireuji dukeje bope doge eimijera pegareu Satanás ure turemo nou Judato. Jesus makore Judaji. Akore: – Ameardae pegareu towuje. Amara tabo! ");
INSERT INTO bor_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nouia rakojere Jesus apowuge erduwakare kodiba Jesus akoino Judaji. ");
INSERT INTO bor_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Marigudu Judas jeture nou eno dieroji. Dukodire iage emeardaere Judas umoduie akirodo ia boe ekeji pugeje. Iage emeardaere Judas umoduie ia diero maku marenarue doge etai. ");
INSERT INTO bor_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas ure tugeragu nou amireuji dukeje uture epiji kuri je. Boečodure marigudu. ");
INSERT INTO bor_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas uture epiji dukeje Jesus makore nouia ture jorduwadowugei. Akore: – Boe erdunure aino Imedu Onaregedu pemegareuji. Awu imedu onaregedu nure imi. Inure Pao Kurireu ro pemegareu towuje dukodire boe erdumode Pao Kurireu ro pemegareuji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iromode Pao Kurireu ro pemegareuji dukeje Pao Kurireu romode iro pemegareuji jamedu boe eiamedu boe erduwawo čero pemegareuji kuri aino rugadu ewo Pao Kurireu ie kurido rugadu kuri je rugadu. ");
INSERT INTO bor_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tare nono itore emogadure. Iragojemodukare tagabo kuri aino pugeje. Tagaiwomode iwagai mare taroiwakare taduwo iregodaji. Ire Judeu doge eimijerage ewie nou inoduji marigudu. ");
INSERT INTO bor_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mare imode ia taro maiwu maku tagai. Tameardu kurido pui. Tameardu kurido pui aino imeardu kurimoga tai dure. ");
INSERT INTO bor_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tameardu kurimode pui dukeje boe erduwamode ire jorduwadowuge nuie tagi duji. ");
INSERT INTO bor_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pedro makore Jesusji. Akore: – Kaiba akodumode? Jesus akore: – Akare arugadu atuwo itabo. Mare ia meri keje atumode toro itae. ");
INSERT INTO bor_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro akore: – Ikimijera nure aki. Itaidure ituwo akabo. Ire irugadu iwiwo amugato. ");
INSERT INTO bor_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus akore: – Iwo awie. Akare arugadu awiwo imugato. Awu boečoji akagomode arduwakaie i dumode pobe metia bokware rugadu. Dukeje čare kagariga kudugodumode. ");
INSERT INTO bor_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus makore ture jorduwadowugei. Akore: – Tamororamagadukaba. Tameartorudo Pao Kurireuji. Tameartorudo i jamedu. ");
INSERT INTO bor_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Iogwa uwai kurireu tadare boe eda kurireu mugure. Itumode toro iwo tawai pemegado nono. Ainore ure rugadu. Dukodire ire tawie aino. ");
INSERT INTO bor_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Imode tawai pemegado toro baru tada dukeje imode ikirimi mato pugeje tawagai iwo tarego baruto taragojewo itabo toro. ");
INSERT INTO bor_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tarduware ikodumode jiwu awaraji. ");
INSERT INTO bor_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mare Tomé makore Jesusji. Akore: – Čegimijera. Čerduwakare kaiba akodumode. Nuba čeromode čerduwawo awaraji čedaregoduwo toro? ");
INSERT INTO bor_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus akore: – Umode boe erego baru towu nure imi. Boe remawu nure imi. Imire imode boe eraga maku boe etai. Imire imode boe eewodudo pugeje. Boe etumodukare tuginaigodu Pao Kurireu ae. Tu imire imode boe erego Pao Kurireu ae. ");
INSERT INTO bor_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tarduware i. Dukodi tarduwamode Iogwa Kurireuji jamedu. Awu meriji čare tarduware ji. Tardure ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe akore: – Čegimijera. Čedaidure čerduwo Pao Kurireuji. Čerdudo ji. Dukodire čemode čerugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus makore Felipeji. Akore: – Iragojere tagabo marigudu. Aki na arduwakare i? Jordure iwu jordure Iogwa Kurireuji. Kodiba akagoino iwo tardudo Iogwa Kurireuji? ");
INSERT INTO bor_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Felipe nure aki. Iragojere Iogwa Kurireu apo. Iogwa Kurireu rakojere itabo. Ameartorure nou inoduji? Imagore tai mare iwadaru ji karega inagoino. Iogwa Kurireu rakojere itabo dukodire inagoino Iogwa bataruji tawiagai. Iogwa maragodae jire iroino. ");
INSERT INTO bor_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tameartorudo awu iwadaruji. Iragojere Iogwa Kurireu apo. Iogwa Kurireu rakojere itabo jamedu. Tameartorumodukare inagoino jiboeji dukeje mare tameartorudo tardure jiwu iro rakareuji tameartoruwo i. ");
INSERT INTO bor_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Boe jokodu jire inagoino. Boe emeartorumode i dukeje eromode nono iro mogadure. Uu. Ero kurimode iro kori rugadu. Itumode Iogwa Kurireu ae. Dukodire meartorure iwuge ero kurimode rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Itumode Iogwa Kurireu ae dukodire iromode tagaidure jiboeji. Tamagomode itaidure jiboe bagai dukeje iromode awu tamagore bagai boeji. Irore aino dutabo imode boe erdudo Iogwa Kurireu ro pemegareu rugadu boeji, ro rakareu rugadu boeji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tamagomode itaidure jiboe bagai dukeje iromode awu tamagore bagai boeji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","– Tameardu kurire i dukeje tameartorumode iwadaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inogwamagudumode Iogwa Kurireuji dukeje umode Tuwari maku tagai rugadu. Nou Uwari umode tugera bararedo tai. Rakojemode tagabo jii toro. Utumodukare tabiji. ");
INSERT INTO bor_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pao Kurireu Uwari nure ema. Emare ure boe erduwado Pao Kurireuji. Boe jokodu jire ure boe erduwado. Meartorukare Pao Kurireu jiwuge erdumodukare Pao Kurireu Uwariji. Erduwamodukare ji jamedu. Dukodi nou meartorukare Pao Kurireu jiwuge emodukare tugeragu Uwariji. Mare tarduware ji. Nou Pao Kurireu Uwari rakojere tagabo. Rakojemode tagabo jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","– Iturumode. Mare ietu pemegamode tai. Nono imode ikirimi tagae. ");
INSERT INTO bor_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kuri aino boe erdumodukare i pugeje. Mare tardumode i rugadu. Iewodumode dukodire taewodumode pugeje jamedu. ");
INSERT INTO bor_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Iewodumode pugeje dukeje tarduwamode iragojere Iogwa Kurireu apo duji. Tarduwamode taragojere itabo duji jamedu. Tarduwamode iragojere tagabo duji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Meardu kurire iwuge etaidumode iwadaruji. Meardu kurire iwuge emeartorumode iwadaruji. Iogwa Kurireu meardu kurimode meardu kurire iwugei. Imeardu kurimode ei jamedu. Imode erduwado i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas makore Jesusji mare Judas Iscariotes karega. Akore: – Čegimijera. Amode čerduwado ai mare amodukare meartorukare aiwuge erduwado ai. Kodiba meartorukare aiwuge erduwamodukare ai? ");
INSERT INTO bor_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus makore ji. Akore: – Meardu kurire iwuge emeartorumode iwadaruji. Iogwa Kurireu meardu kurimode ei jamedu. Itaregodumode etae iogwapo čemuguwo ebo. ");
INSERT INTO bor_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mare meardu kurikare iwuge emeartorumodukare iwadaruji. Ikare tarduwado iwadaruji. Ire tarduwado Iogwa Kurireu bataruji. Ema koiare ure itarego mato tagae. ");
INSERT INTO bor_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Iragoje biagamode tu tagabo dukodire ire tawie aino. ");
INSERT INTO bor_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mare Pao Kurireu umode Tuwari maku tagai imugato. Umode tugera bararedo tai. Umode tarduwado nou imagore jiwu Iogwa bataru rugadu boeji. Umode tawiabutudo awu imagore jiwu Iogwa bataru jamedu boe keje. ");
INSERT INTO bor_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","– Inure tado tagamudo tameardae kuriwo Pao Kurireuji. Meartorukare iwuge emodukare tameardae kurido Pao Kurireuji nono iro mogadure. Tamororamagadukaba. Tagiarigodukaba. Tabagudugodukaba jamedu. ");
INSERT INTO bor_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tameardure iwadaruji marigudu. Ire tawie itumoduie tabiji duji. Mare imoduie ikirimi pugeje tagae. Tameardu kurimode i dukeje taegaremode tai iture Iogwa Kurireu ae duji. Iogwa Kurireu ro kurire iro kori. ");
INSERT INTO bor_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ire tawie nuba boemode tai, nuba boemode i jamedu. Tardumode awu inagoino jiboeji dukeje tameartorumode i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Awu moto kejewu bope doge eimijera aregodumode iwagai awu boečoji rugadu dukodire imago raimodukare tai. Nou bope doge eimijera rakakare i mare Iogwa Kurireu meardae koiare imode imagu ai. Imeardu kurire Iogwaji dukodi. Itaidure boe eiamedu boe erduwawo imeardu kurire Iogwa Kurireu jituji. Dukodire imeartorure Iogwa Kurireu bataruji rugadu. – Ča paduwo awu bai piji. ");
INSERT INTO bor_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus makore kimo ture jorduwadowugei. Akore: – Ire nono uva iku paru pemegareu mogadure. Iogwa Kurireu ure nono jetu pemegare boepa jiwu mogadure. ");
INSERT INTO bor_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","5","Ire nono uva iku paru pemegareu mogadure. Tare nono uva iku mogadure. Iku kadodumode dukeje nou iku bimode, tudumodukare pugeje. Mare iku jetu kimomode čiguto dukeje bimodukare, tudumode rugadu. Iku tudumodukare dukeje Iogwa Kurireu umode nou iku kado tubaru piji. Mare iku tudumode dukeje Iogwa Kurireu umode nou iku pemegado nou iku tudu pemegawo rugadu. Mare uva iku paru ji karega inagoino. I rugadure inagoino. Iku ji karega inagoino. Meartorure iwugeire inagoino. Boepa ji karega inagoino jamedu. Pao Kurireu jire inagoino. Ire tarduwado dukodire ire tabemegado, taro pemegawo. Tameartoru raimode i dukeje iragojemode tagabo. Nono taedu pemegamode itabo rugadu. Tameartoru raimode i dukeje imode taragado taro pemegawo, tawo taro pegareu barigu tabiji. Mare iragojemodukare tagabo dukeje taro pemegamodukare rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Meartorukare iwuge ewarigudumode joruto nono jerigi mogadure. Mare jerigi ji karega inagoino. Ewarigudumode Pao Kurireu piji emeartorukare ji kodi. ");
INSERT INTO bor_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mare tameartoru raimode i tarduwamode iwadaruji rugadu dukeje tamagomode i tagaidure jiboe bagai. Imode tardudo tagaidure jiboeji tameartorure i kodi. ");
INSERT INTO bor_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taro pemegamode nono Iogwa Kurireu ro mogadure dukeje tamode boe erduwado Iogwa Kurireu ro pemegareuji. Taromode aino dukeje ire jorduwadowuge nure tagi. ");
INSERT INTO bor_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","– Imeardu kurire tai nono Iogwa Kurireu meardu kurimoga i dumogadure. Tagaba iwarigu tabiji imeardu kuriwo tai jii toro. ");
INSERT INTO bor_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tameartorumode iwadaruji dukeje tamodukare iwarigu tabiji. Dukodi imeardu kurimode tai jii toro rugadu. Imeartorure Iogwa Kurireu bataruji. Ikare barigu ipiji. Emare meardu kurire i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ire tawie aino tameartoruwo awu inagoino jiboeji, iagarewo tai rugadu. Taegarewo pui jamedu. ");
INSERT INTO bor_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ča iwadaru reo. Tameardu kurido pui nono imeardu kurimoga tai dumogadure. ");
INSERT INTO bor_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ia boe meardu kurimode rugadu ia timediaji dukeje aidumode tuwiwo nou timedia mugato nou timedia bikawo. ");
INSERT INTO bor_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ča tameartorumode iwadaruji dukeje imedage mode tagi. ");
INSERT INTO bor_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Itugarege modukare tagi pugeje. Boe eimijera utugarege erduwakare tugimijera meardaeji. Mare imedage nure tagi. Dukodire ire tawie imeardae jamedu boeji. Ire tawie Iogwa Kurireu makore iwu tuwadaru jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tagare tageragu i. Imire ire ikeragu tai. Imagore tai taro pemegawo, tawo boe pemegado boei. Taro akedumodukare. Dukodire Iogwa Kurireu umode tamagore bagaiboe maku tagai rugadu. Tamagomode itaidure jiboe bagai dukeje Iogwa umode maku tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ča itaidure jiwu taro reo. Tameardu kurido pui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","– Tawiagodukaba. Meartorukare iwuge erdu pegamode tai mare erdu pegare i boetoji. ");
INSERT INTO bor_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Taromode nono meartorukare iwuge ero mogadure dukeje etaidumode tai. Etaidumode tai nono etaidumoga pui dumogadure. Mare ire ikeragu tai nou meartorukare iwuge ero piji tarokawo nono ero mogadure pugeje. Dukodire meartorukare iwuge erdu pegare tai. ");
INSERT INTO bor_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tawiagodukaba imagore tai dupiji. Boe etugarege ekurikare tugimijera kori dukodire boe emeartorumodukare nou boe etugaregei ekimijera piji. Tagimijera nure imi. Boe emeartorumode iwadaruji dukeje emeartorumode ire maku tagaiwu tawadaruji jamedu. Mare boe ero pegare i dukodire ero pegamode tai jamedu. ");
INSERT INTO bor_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ero pegamode tai tameartorure i kodi. Erduwakare ure itarego matowu Iogwa Kurireuji kodi. ");
INSERT INTO bor_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Imodukare ewie ero pegareu boeji dukeje egomode turo pegakaie. Mare ire ewie. Ire ewie ero pegareu boeji. Dukodire egomodukare tuiorduwakaie turo pegareuji. ");
INSERT INTO bor_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jordu pegare iwuge erdu pegare Iogwa Kurireuji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Itaregodure etae iro rakareu tabo. Ire erdudo iro rakareuji. Ia boe erokare nono iro rakareure marigudu. Erdumodukare iro rakareuji dukeje erduwamodukare i. Nono egomode tuiorduwakaie turo pegareuji. Mare erdure iro rakareuji dukodire erduware i. Erduware ipemegare duji. Mare erdu pegare i. Erdu pegare Iogwa Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pao Kurireu makore marigudu nuba eromoduie. Nou bataru padure bapera keje eno bakaruče. Akore: “Iro pegakare ei mare erdu pegare i.” Aino čare awu bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jesus mako kimore. Akore: – Pao Kurireu Uwari aregodumode tagae. Umode tarduwado Pao Kurireuji rugadu. Boe jokodu jire makomode. Imi igoiare imode Pao Kurireu Uwari arego tagae. Umode tarduwado i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nono tamode nou mugu jaereuge pawobe ewie i jamedu. Taragojere itabo marigudu dukodi tamode nou boe erduwado i jamedu. ");
INSERT INTO bor_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesus mako kimore. Akore: – Ire tawie marigudu. Dukodi tagaba tagera ra tameartorure i dupiji. ");
INSERT INTO bor_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judeu doge emode tadudo nou ture bato puiwu bai piji. Emode ia tawido jamedu. Emeardaere ainore Pao Kurireu aidure boe erowo meartorure iwugei. ");
INSERT INTO bor_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mare erduwakare i. Erduwakare Iogwa Kurireuji. Dukodire ero pegamode tai. ");
INSERT INTO bor_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Marigudu iragojere tagabo dukodire ikare tawie. Mare aino čare ire tawie. Dukodi boe ero pegamode tai dukeje tawiabutumode awu iwadaru keje rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesus mako kimore. Akore: – Kuri aino imode ikirimi ure itarego matowu Iogwa bagai. Marigudu tanarakare i kaiba ikodumode. ");
INSERT INTO bor_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ča ire tawie dukodire tagiarigodure rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Boe jokodu jire inagoino tawiagai. Itumode tabiji dukeje boe pegamode tai rugadu. Ire tawie. Mare itumode tabiji boe pemegawo tai dubagai jamedu. Itumode tabiji Pao Kurireu Uwari aregoduwo tagae dubagai jamedu. Itumodukare tabiji dukeje Pao Kurireu Uwari aregodumodukare tagae. Mare itumode tabiji dukeje imode Pao Kurireu Uwari arego tagae rugadu. Dukodire inagoino boe pemegamoduie tai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Boe erduwakare turo pegareu boeji. Mare Pao Kurireu Uwari aregodumode boe etae dukeje umode boe erduwado Pao Kurireu aidukare jiwu boe ero pegareu boeji boe ewo tugera ra turo pegareu boe piji rugadu. Boe emeardaere ro jetororeuge nuie pudumi. Erduwakare tuwo turo jetorodo. Pao Kurireu Uwari aregodumode dukeje umode erduwado ero jetorokare duji. Umode boe erduwado iro jetorore duji. Boe emeardaere tuiorduwaie Pao Kurireuji. Mare Pao Kurireu Uwari umode erduwado erduwakare Pao Kurireu jituji. Pao Kurireu umode boe pegado meartorukare iwugei ero pegareu moriče. ");
INSERT INTO bor_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Emeartorukare i dukodire erduwakare ro pegareuge nuie pudumi duji. ");
INSERT INTO bor_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iro jetorore. Nono itumode Iogwa Kurireu bagai dukeje Iogwa Kurireu umode tona bu ikajeje toro. Pao Kurireu Uwari umode boe erduwado nou inoduji rugadu tuwo erduwado iro jetorore duji. Dukeje čare boe erduwamode iro jetorore duji rugadu. Pao Kurireu Uwari umode boe erduwado ro jetorokareuge nure emage duji jamedu. ");
INSERT INTO bor_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Emeardaere Pao Kurireu ro pegamodukaie pudui. Mare erduwakare. Marigudu ure bope doge eimijera bie tumoduie boe pegado ji nou bope doge eimijera ro pegareu moriče. Ro pegareuge emeartorure nou bope doge eimijeraji jamedu. Dukodire Pao Kurireu ro pegamode ei jamedu ero pegareu moriče rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","– Iwadaru kurire iwo tawie ji. Mare taragakare tarduwawo jamedu boeji. ");
INSERT INTO bor_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mare Pao Kurireu Uwari aregodumode tagae dukeje umode tarduwado Pao Kurireuji rugadu. Umode tarduwado boe jokodu remawuji. Makomodukare tuwadaruji. Makomode tumeardure jiwu Pao Kurireu bataruji tu rugadu. Umode tawie nuba boe mode boei awu moto jituji. ");
INSERT INTO bor_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Umode tawie i jamedu. Umode tawie iwadaruji. Dukodire umode boe erduwado i. Ipemegare rugadu. Dujire umode boe erduwado. ");
INSERT INTO bor_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iogwa Kurireu bataru jire inagoino. Dukodire ire tawie aino. Pao Kurireu Uwari makomode iwadaruji tawiagai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","– Kuri aino tardumodukare i pugeje. Mare ia meri keje tardumode i rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesus ure jorduwadowuge emagore pui. Egore: – Kaba jiba akoino pai? Akore pardumodukare pudui kuri aino. Akore ia meri kejeie pardumoduie pudui pugeje. Akore tudumoduie Pao Kurireu ae kuri aino. ");
INSERT INTO bor_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kaboba jiba akoino? Parduwakare kaba jiba akoino pai. ");
INSERT INTO bor_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus jorduware nou ture jorduwadowuge emeardaeji. Dukodire makore ei pugeje. Akore: – Inagore tai tardumodukaie i kuri aino mare ia meri keje tardumoduie i pugeje. Mare tarduwakare awu iwadaruji dukodire tagagoino aino pui. ");
INSERT INTO bor_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Boe jokodu jire inagoino tawiagai. Tagiarigodumode rugadu. Tagragudumode rugadu. Mare meartorukare iwugere egaremode pudui. Tagiarigodumode mare taegaregodumode tai pugeje. ");
INSERT INTO bor_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aredu kurijirigodure dukeje kiarigodure tugurijiri kori koia. Mare kuri buture dukeje biagodure nou tugurijiriredu piji. Jakarere tonaregeduji rugadu tonaregedu boture kodi. ");
INSERT INTO bor_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tagiarigodure mare iordumode tai pugeje. Dukeje taegaregodumode tai pugeje. Boe emodukare taegare akedudo tabiji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Iwo tawie. Nou meriji Pao Kurireu umode tagaidure jiboe maku tagai dukodire tagogwamagudumodukare i iaboe bagai. Tamagomode tagaidure jiboe bagai ikie tabo dukeje Iogwa Kurireu umode maku tagai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Marigudu tagogwamagudukare i iaboe bagai ikie tabo. Tamagomode bagai dukeje makudumode tagai rugadu. Dukodire taegaregodumode tai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","– Ireadodure boeji tawiagai iwo Iogwa Kurireu jebato iaboeji iwo tarduwado Iogwa Kurireu rore jiboeji. Mare ia meri keje imodukare Iogwa Kurireu jebato iaboeji pugeje. Imago pemegamode iwo tarduwado rugadu Iogwa Kurireuji. ");
INSERT INTO bor_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nou meriji tagi rugadu tamagomode ji rugadu tagaidure jiboe bagai ikie tabo. Imi karega imagomodukare ji. Tagire tamagomode ji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Emare meardu kurire tai. Tameardu kurire i. Tameartorure Pao Kurireu ure itarego mato duji dukodire Iogwa Kurireu meardu kurire tai rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Itaregodure Iogwa Kurireu piji rugadu. Itaregodure mato moto ka. Mare itumode awu moto piji pugeje ituwo Iogwa Kurireu bagai. ");
INSERT INTO bor_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nono nou Jesus ure jorduwadowuge emagore Jesusji. Egore: – Aino čare amago kičarure čewiagai. Akare Pao Kurireu bataru jebato iaboeji pugeje. ");
INSERT INTO bor_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aino čerduware ai. Arduware boe jamedu boeji rugadu. Boe emodukare awie tumeardaeji mare arduware emeardaeji rugadu. Dukodire čerduware ai. Akaregodure Pao Kurireu piji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nono Jesus makore ei. Akore: – Ča. Tameartoru kana i rugadu? ");
INSERT INTO bor_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kuri aino ro pegareuge emode tagaodo ipiji taduwo tawai ka ipiji. Dukodi iragojemode ikinaigodu. Mare ikinaigodu jokodu karega. Iogwa Kurireu rakojemode itabo. ");
INSERT INTO bor_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ire tawie. Dukodi čare tadudo itabo. Tadumode itabo dukeje tamode tagamudo rugadu tameardae kuriwo Pao Kurireuji. Meartorukare iwuge ero pegamode tai. Mare tardu pegakaba. Taragado tai! Toro ia meri keje imode etagedudo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","Jesus ure tuwadaru akedudo ture jorduwadowugei dukeje aiwore baruto tumagowo Pao Kurireu bagai. Akore: – Iogwa. Akanaregedu nure imi. Iwimode kuri aino boe ero pegareu moriče. Mare paga karega iwo boe ekinorudo rugadu. Are boe eiamedu boe eimijerado imi iwo akaidure jiwuge ekinorudo ewikawo pugeje emuguwo akabo jii toro rugadu. Ča iro udo turugadu iwo awu imaragodae iado, iwo imaragodae pemegado. Imode iado dukeje boe erdumode ameardaere jiwu imaragodae pemegare rugadu duji, kurire rugadu duji. Ameardae kurire boe eiamedu boe emeardae piji. Ameardae kurire awo boe ekinorudo ewikawo pugeje emuguwo akabo jii toro rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pao Kurireu nure aki rugadu. Ia bokware. Are mitotu je. Boe remawu nure aki rugadu. Akurire boe eiamedu boe kori. Aire boe erduwamode rugadu tumeartoruwo ai rugadu tumuguwo akabo baru tada du akedukawo. Ameardae koiare are itarego mato moto ka. Ire boe erduwamode jamedu tumeartoruwo i emuguwo pagabo rugadu jii toro rugadu. Jesus Cristo nure imi rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ire boe erduwado aro rakareuji aro pemegareuji woe moto keje. Aino čare ire are maku inaiwu imaragodae iado woe. Dukodire ire boe erdudo apemegare duji. Apemegare boe eiamedu boe piji. ");
INSERT INTO bor_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iogwa Kurireu nure aki. Marigudu akare awu moto to raga dukeje baru tadawuge erduware marigudu ipemegare duji. Dukodire baru tadawuge emago pemegare i. Ere ikie kurido. Aino ire irawuje mato moto ka. Kuri aino itumode ibagi baruto iragojewo akabo pugeje. Itaidure awo boe erdudo ipemegare duji nono baru tadawuge erdu mogadure. ");
INSERT INTO bor_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","– Are ia awu moto kejewu boe emagu inai emeartoruwo i. Ire erduwado ai rugadu. Emeartorure ai. Dukodire are emagu inai iwo erduwado. Nono emeartorure awadaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aino erduware are maku inai boeji. Apijire are maku inai. ");
INSERT INTO bor_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ire awadaru maku etai. Are awadaru maku inai dukeje ire ewie awadaruji. Emeartorure ji rugadu. Erduware itaregodure apiji duji rugadu. Are itarego mato rugadu. Emeartorure rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","– Meartorure aiwuge eparu tabore inagoino baruto awagai. Imagokare meartorukare iwuge eparu tabo. Mare imagore nou are maku inaiwuge boe eparu tabo emeartorure ai kodi. ");
INSERT INTO bor_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Meartorure iwuge emeartorumode ai jamedu. Meartorure aiwuge emeartorumode i jamedu. Emeartorumode iwadaruji dukeje boe eiamedu boe erduwamode imi rugadu iro pemegareu kodure boe eiamedu boe kori duji. ");
INSERT INTO bor_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kuri aino itumode baruto akae. Iragojemodukare meartorukare iwugebo pugeje. Mare meartorure iwuge eragojemode woe awu moto keje kimo. Ča Iogwa Pemegareu nure aki rugadu. Aragare rugadu. Aetu pemegado awu meartorure iwugei emeardae pemegawo pui nono imi aki pamogadure puapo dumogadure. Pameardae ure mitotu je. Are nou araga maku inai marigudu. ");
INSERT INTO bor_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dukodire ietu pemegare awu meartorure iwugei nou are maku inaiwu araga tabo. Dukodire ekare tugera ra tumeartorure i dupiji. Ma kočare ure tugera ra ipijiwu ure mitotu je. Emare meartorukare i rugadu. Marigudu akagore ia ure tugera ra ipijiwu umoduie imagu boe eimijera pegareuge etai amoduie boe pegado ji rugadu. Dukodire boe pegamode nou umode imagu etaiwuji rugadu. Dukodire nou awadaru jetumode pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ča, kuri aino itaregodumode baruto akae pugeje. Ire iwadaru maku awu ire jorduwadowuge etai egarewo iwadaruji rugadu nono iagare mogadure. ");
INSERT INTO bor_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ire awadaru maku awu ire jorduwadowuge etai mare meartorukare iwuge erdu pegare ei rugadu. Awu ire jorduwadowuge emeartorure i dukodire erore nono iro mogadure. Erokare nono meartorukare iwuge ero mogadure. Dukodire meartorukare iwuge erdu pegare ei jamedu. ");
INSERT INTO bor_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Imagokare awagai awo awu meartorure iwuge etawuje awu moto piji. Mare itaidure aetu pemegawo ei rugadu awo ekinorudo bope doge eimijera piji. ");
INSERT INTO bor_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imeardaekare nono awu meartorukare iwuge emeardae mogadure. Awu ire jorduwadowuge emeardaekare nono awu meartorukare iwuge emeardae mogadure jamedu. ");
INSERT INTO bor_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Awadaru ure turugadu. Boe jokodu jire akagoino. Meartorure iwuge ero pemegawo. Emeartoruwo awadaruji atugaregewo emage awo ero jetorodo rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Are itarego mato moto ka meartorukare iwuge etae. Dukodire ire awu ire jorduwadowuge etudo meartorukare iwuge etae jamedu nono are itarego meartorukare iwuge etae dumogadure. ");
INSERT INTO bor_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Dukodire akaidumode jiboe ire irugadu imeartoruwo awadaruji rugadu. Awu ire jorduwadowuge ewo tudo turugadu jamedu tumeartoruwo awadaruji jamedu nono imogadure. ");
INSERT INTO bor_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","– Imagore eparu tabo awagai toro baruto. Emode boe erduwado iwadaruji dukodire boe emeartorumode i rugadu. Imagore nou meartorumode iwuge eparu tabo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Imagore eparu tabo emeardae pemegawo puapo, emeardaewo nono pameardae dumogadure. Aragojere itabo. Iragojere akabo jamedu. Paedure puapo. Pawiapagare tu pu bataruji. Dukodire pameardae ure mitotu je. Itaidure awu meartorure iwuge eduwo pagabo emeardae pemegawo puapo nono pameardae mogadure. Ia boe erdumode nou boe emeardae pemegare puapo duji dukeje emeartorumode i are itarego moto ka duji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Are iro rakado woe moto keje. Are iro pemegado woe moto keje jamedu. Dukodire boe erdure ipemegare rugadu duji. Ča ire awu iro rakareu maku awu meartorure iwuge etai. Dukodire boe erdumode meartorure iwuge epemegare duji jamedu. Nono emeardae pemegamode puapo nono pameardae dumogadure rugadu. Ikare imeardae udo tuginai apiji. Akare ameardae udo tuginai ipiji jamedu. Nono are iraga maku inai. Imode meartorure iwuge eragado jamedu. Nono emodukare tumeardae udo tuginai pubiji jamedu. Nono boe eiamedu boe erdure nou meartorure iwuge emeardae pemegare puapo duji dukeje emeartorumode i, are itarego moto ka duji rugadu. Erduwamode ameardu kurire nou meartorure iwugei duji jamedu. Ameardu kurire ei nono ameardu kurire i dumogadure. ");
INSERT INTO bor_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","– Iogwa Kurireu nure aki. Are nou meartorure iwuge emagu inai. Dukodire itaidure eduwo itabo toro imugureu keje. Eragojemode itabo dukeje erdumode iragare boe jamedu boe jituji, erdumode boe pemegare irore jiboeji. Are iraga maku inai marigudu. Are boe pemegado i marigudu. Akare moto to raga mare are iraga maku inai marigudu. Are boe pemegado i marigudu jamedu. Mare paga karega. Ameardu kurire i dukodire aroino i. ");
INSERT INTO bor_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Iogwa Kurireu nure aki kodi. Apemegare rugadu. Meartorukare iwuge erduwakare ai. Mare imire iorduware ai rugadu. Awu meartorure iwuge erduware ai are itudo mato duji. ");
INSERT INTO bor_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ire ewie ai. Mare imode erduwado ai tu tu je jamedu emeardu kuriwo boei rugadu nono ameardu kurimoga i dumogadure. Imode erduwado iragojere ebo duji emeardu kuriwo boei nono imeardae mogadure. ");
INSERT INTO bor_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus ure nou baru towu tuwadaru iado dukeje uture pugeje ture jorduwadowugebo. Ekurugodure pobo kajeje. Nou pobo iere Cedrom. Nono etaregodure nou oliveira iguru ka. ");
INSERT INTO bor_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas Iscariotes jorduware nou oliveira iguruji. Marigudu Jesus uture ture jorduwadowugebo nou oliveira iguru jetureu ka tu tu je. Dukodire Judas Iscariotes jorduware eragojere nono duji. Meardaere tuwo Jesus maku boe eimijerage pegareuge etai nou tugobaigarege etai jamedu. ");
INSERT INTO bor_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dukodire nou Judas Iscariotes uture nou oliveira iguru ka Roma kejewu tugobaigaregebo. Fariseu doge, nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere Pao Kurireu uwai tadawu tugobaigarege etudo ebo jamedu. Eture tariga kurireu tabo, rago tabo. Eture jorugu tabo jamedu tuiordu pemegawo awaraji. ");
INSERT INTO bor_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus jorduware boe mode nono pudui duji rugadu. Jorduware eromode pudui rugadu boeji. Nono uture etogi. Dukejere unaragodure ei. Akore: – Ioguduba bagaiba taroino? ");
INSERT INTO bor_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Egore: – Čedaiwonure Jesus bagai. Nazaré kejewu nure ema. Jesus akore: – Imireo. Judas Iscariotes rakojere nono ebo jamedu. Emare ure etarego toro Jesus ae tuwo Jesus maku etai. ");
INSERT INTO bor_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus akore “imireo” aino dukeje nou tugobaigarege ere tudaru piji. Dukeje ewudure moto ka. ");
INSERT INTO bor_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nono Jesus unarare ei pugeje. Akore: – Ioguduba bagaiba tagaiwore? Egore: – Čedaiwonure Jesus bagai. Nazaré kejewu nure ema. ");
INSERT INTO bor_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus akore: – Imireo. Iwagaire taroino. Mare tagaba tageragu awugei. Etudo pugeje. ");
INSERT INTO bor_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus akore aino tuwadaru jetuwo pudui. Ture jorduwadowugeire akoino. Marigudu makore Pao Kurireu bagai baruto dukeje akore: – Ietu pemegare nou ire jorduwadowugei dukodire ekare tugera ra tumeartorure i dupiji. ");
INSERT INTO bor_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simão Pedro iedure ia tariga kurireuji. Ure tawuje tuia piji dukeje ure ia imedu bija kado. Nou imedu iere Malco. Maragodure nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu ai. Nou imedu ukana pemegareu jagwaiwu bijare ure kado. ");
INSERT INTO bor_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mare Jesus makore Pedroji. Akore: – Arokaba aino. Tariga kurireu tugu tuiato. Arduwakare. Imode imagu awu boe pegareuge etai boe pegawo i rugadu nono Iogwa Kurireu meardae mogadure. ");
INSERT INTO bor_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nono nou Roma kejewuge tugobaigarege eture Jesus apo. Eimijera uture ebo jamedu. Judeu doge nou tugobaigarege eture ebo jamedu. Ere Jesus kogudo. ");
INSERT INTO bor_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dukejere eture Jesus apo toro nou ure Judeu doge enomea maku Pao Kurireu aiwuge boe eimijerage etae. Ere maku Anás ai. Nou Anás uwagedu iere Caifás. Nou Caifás nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu nure ema nou joruji. ");
INSERT INTO bor_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Marigudu nou Caifás makore tumeardaeji Judeu doge eimijerage ewiagai. Akore: – Boe pegakare pai pawo ia imedu bito pawobe Judeu doge ewo činorudo Roma kejewu boe eimijerage pegareuge epiji. ");
INSERT INTO bor_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro uture Jesus rekodaji. Ia Jesus ure jorduwadowu uture eregodaji jamedu. Caifás jorduware nou Jesus ure jorduwadowu imeduji. Dukodire nou imedu uture Jesus rekodaji nou Caifás uwai ka. ");
INSERT INTO bor_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mare Pedro ukare turemo nou baito. Nono nouia Jesus ure jorduwadowu ure tuie bu nou Caifás uwai piji toro Pedro ae. Makore nou jeture nou baiporo jiwudo areduji Pedro uwo turemo. Dukeje nou jeture baiporo jiwudo ure Pedro udo turemo nou baito. ");
INSERT INTO bor_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mare nou aredu makore Pedroji. Akore: – Ia Jesus ure jorduwadowu karegure aki? Mare Pedro akore: – Boro. Imi karega. ");
INSERT INTO bor_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Biakure ei dukodire nou utugarege, nou tugobaigarege ere jorugu nono nou bai tada. Nono ere taiado nou joru tabo tuwo tuwarudo jao. Nono Pedro ure tuburedo nou joruji tuwo tuwarudo nono ebo jamedu. ");
INSERT INTO bor_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anás unarare Jesusji jorduware jiboe bagai. Akore: – Kaba jiba are boe erduwado? ");
INSERT INTO bor_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus akore: – Ikare iwadaru biado boe epiji marigudu. Boe eiamedu boe emeardure ire boe erduwado jiwu iwadaruji. Ire boe erduwado Judeu doge ere bato puiwu bai ja tada. Ire boe erduwado Pao Kurireu uwai tada. Boe ere bato pui itae tumearduwo iwadaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kočare anarare maigodu i iorduware jiboe bagai? Anarado nou meardure iwadaru jiwugei. Emagere erduware iwadaruji. ");
INSERT INTO bor_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus makore aino dukeje ia tugobaigare ure boeto Jesusji. Dukejere makore Jesusji. Akore: – Akagokaba aino awu ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu bataru jipagi! Boe eimijera kurireu nure ema! ");
INSERT INTO bor_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mare Jesus akore: – Iwadaru pegareumode dukeje awu boe ewie nou iwadaru pegareuji. Mare iwadaru pegareu bokware. Kodiba are boeto i? ");
INSERT INTO bor_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dukejere Anás ure tugobaigarege edo Jesus reko Caifás ae. Jesus kana kogu kimore puapo rugadu. Caifás nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijera kurireu nure ema. ");
INSERT INTO bor_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro rakoje kimore nono joru okwai. Iage emagore ji. Egore: – Ia Jesus ure jorduwadowu karegure aki? Mare Pedro akore: – Boro. Imi karega. ");
INSERT INTO bor_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nono ia Caifás utugare makore Pedroji jamedu. Akore: – Iordure ai Jesus apo toro oliveira iguru keje. Pedro ure bija kadowu imedu uwobe nure ema. ");
INSERT INTO bor_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mare Pedro akore: – Boro. Čare rore puku kagariga kudugodure dukeje rugadu. ");
INSERT INTO bor_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Čaboečoto ere Jesus reko Caifás uwai piji toro Roma pijiwu boe eimijera governador uwai ka. Judeu doge ere tuwaduiago tuwadae Pascoaji kuri aino. Judeu doge eimijerage ere tudo turugadu tuwaduwo nou tuwadaeji nou meri keje dukodire ekare turemo nou boe eimijera uwaito. Judeu karegure ema dukodi. Emode turemo ia boe tuginaiwuge ewaito dukeje epemegamodukare turowo to bakaru tadawu boe ero boeji. Dukodire ewadumodukare nou tuwadaeji pugeje. Enogwagemodukare nou Páscoa jiwu boe ekeji pugeje. Mare eno bakaru tadawu boe ero reo. Dukodire ekare turemo nou Roma eimijera uwaito. ");
INSERT INTO bor_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nou boe eimijera kurireu iere Pilatos. Emare ure tuie bu toro bawadu ka nou Judeu doge eimijerage etogi tumagowo ei. Akore: – Nuba awu imedu rore? Awu imedu ro pegareu pa? ");
INSERT INTO bor_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nou Judeu doge eimijerage egore: – Ro pegamodukare dukeje čedaregodumodukare apo woe akae. Ro pegare rugadu bitoduwo. ");
INSERT INTO bor_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mare Pilatos akore: – Dukodi tadudo apo toro tawai ka tagaiwowo awu imedu ro pegareu bagai taroiaji tawo boe pegado ji tardu jiwu ro pegareu moriče taroiaji. Egore: – Roma kejewu boe eimijera kurireu akore čei čegawo ia boe ewido. Ure ado mitotu woe čedabo. Akagomode bito. Boe emode bito rugadu. Amagomodukare dukeje boe emodukare bito rugadu. ");
INSERT INTO bor_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Erduwakare mare Jesus makore marigudu tuwimoduie duji. Tuwimoduie ipo padure pugajejewu keje. Aino čare Jesus bataru jeture pudui rugadu. ");
INSERT INTO bor_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos ure turemo tuwaito tuibagi tumagowo Jesusji pugeje. Unarare ji. Akore: – Boe rugadu kana? Judeu doge eimijera kurireu nure aki rugadu kana? ");
INSERT INTO bor_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus akore: – Aki na akaidure arduwawo? Ia boe eigoia na ere arduwado? ");
INSERT INTO bor_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatos akore: – Judeu karegure imi. Awobe ere amagu inai. Awobe nou ure Judeu doge enomea maku Pao Kurireu aiwuge eimijerage ere amagu inai. Kaba jiba arore? Kodiba egoino aino ai? ");
INSERT INTO bor_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus akore: – Boe eimijera kurireu nure imi mare awu woewu moto kejewu karegure imi. Boe eimijera mode imi woe moto keje dukeje meartorure iwuge erugodumode awu Judeu doge eimijeragei ekawo tugeragu i. Boe eimijera kurireu nure imi rugadu mare woe karega. ");
INSERT INTO bor_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatos akore: – Boe eimijera kurireu nure aki? Jesus akore: – Uu. Iwodure woe awu moto keje iwo boe erduwado boe jokodu jiboeji. Aidure tuiorduwawo boe remawu jiboe ewiapagamode iwadaruji rugadu. ");
INSERT INTO bor_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mare Pilatos akore: – Boe remawu bokware. Boe pemegareu bokware rugadu. Nono Pilatos ure tie bu toro bawadu ka pugeje nou Judeu doge eimijerage etae. Makore ei. Akore: – Iorduwakare awu imedu ia ro pegareuji. Ro pegakare i. Imodukare bito. ");
INSERT INTO bor_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tawadae Páscoa kejere tare ido ro pegareu tawuje baičoreu piji utuwo pugeje nono taroia mogadure. Ča tagaidu kana iwo awu Judeu doge eimijera kurireu Jesus tawuje baičoreu piji utuwo pugeje? ");
INSERT INTO bor_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mare nou Judeu doge eimijerage ekudugodure. Egore: – Boro! Ema karega! Čedaidukare ji. Čedaidure nou imedu Barrabásji awo tawuje baičoreu piji utuwo pugeje. Nou boe emagore bagaiwu imedu iere Barrabás. Imedu iwogu kigodureu nure ema. Ure boe ewidowu nure ema jamedu. ");
INSERT INTO bor_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nono Pilatos ure tugobaigarege edo boeto Jesusji bukigu tabo. ");
INSERT INTO bor_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nou tugobaigarege ere ia ikuredu otoreu upodo puapo tuwo udo nono boe eimijera atadawu mogadure. Nono ere tugu Jesus aorato koriwo aoraji rugadu. Nono ere boe eimijera ukudau areia rugureu motureu tugu Je