﻿USE sofia;
DROP TABLE IF EXISTS sofia.bon_vpl;
CREATE TABLE bon_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bon_vpl WRITE;
INSERT INTO bon_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ai lui Yeesu Keriso me kaakesaare bime ngii gemi. Yeesu lui Daawida me kaakesaare ge, Daawida lui Abrahamo me kaakesaare ge. ");
INSERT INTO bon_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamo lui Isacako me Babe ge, Isacako lui Yakobu me Babe ge, Yakobu lui Yuuda piiyepu teeme naniganewaleyame bime babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda lui Perese naabi Sera bime babe ge, teeme mage lui Tamara tage. Perese lui Hesoroma me babe ge, Hesoroma lui Arama me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama lui Aminadaba me babe ge, Aminadaba lui Naasona me babe ge, Naasona lui Salamona me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamona lui Boasa me babe ge, teeme mage lui Rahaba tage. Boasa lui Obeda me babe ge, teeme mage lui Ruuta tage. Obeda lui Yese me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese lui Daawida me babe ge, lui te mope biname me äbituji. Daawida lui Solomona me babe ge, teeme mage lui Uriya me coga tage. ");
INSERT INTO bon_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona lui Rehoboamo me babe ge, Rehoboamo lui Abiya me babe ge, Abiya lui Asa me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa lui Yosepata me babe ge, Yosepata lui Yorama me babe ge, Yorama lui Osiya me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiya lui Yotama me babe ge, Yotama lui Ahasa me babe ge, Ahasa lui Hesekiya me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya lui Manasa me babe ge, Manasa lui Amona me babe ge, Amona lui Yosiya me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya lui Yekoniya naabibime babe ge. Pui padare cabu Yosiya liba teeme bägrä bine jepänimuji, Babloniya biname cina Israela biname bine joomläjimujisi teeme cewe me waadename. ");
INSERT INTO bon_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israela biname cina liba Babloniya je icrajimuji, piba Yekoniya Salatiyelu ne jepänuji. Salatiyelu lui Serubabelu me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelu lui Abyuda me babe ge, Abyuda lui Eliyakima me babe ge, Eliyakima lui Asora me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asora lui Sadoka me babe ge, Sadoka lui Akima me babe ge, Akima lui Elyuda me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elyuda lui Eliyasara me babe ge, Eliyasara lui Matana me babe ge, Matana lui Yakobu me babe ge, ");
INSERT INTO bon_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobu lui Yoosepa me babe ge, lui Mariya me rooriye ge. Mariya te Yeesu ne jirnguji, lui ne Keriso ca einenisi. ");
INSERT INTO bon_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yoo siige, footin kaakesaare gemi Abrahamo ca ngälu Daawida ne oomlaname, cuta nuuja footin gemi Daawida cabu ca ngälu Israela biname bine liba ewadimujisi Babloniya cewe me, cuta puma cita ca nuuja footin gemi ngälu Keriso ne oomlana, biname bine niiya cabu ca lui te cire yääsecräremepi. ");
INSERT INTO bon_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yeesu Keriso me aplimla apu gyene: teeme mage Mariya lui Yoosepa me ciwelooloyame ge. Teepi camuge atejäclmuta, Mariya liba umle äbitige, egä tabe Aceji Seemo name mäpumäpu gwene. ");
INSERT INTO bon_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Teeme ciwelooloyame Yoosepa epu biname ge, lui te iyeta mule bine Moose me Cotre ibi jaawenimuge, yepä tabe singi lica ge Mariya ne biname bime sobe cabu teeme mäpumäpu poto cidi me aitnejame, pui Cotre te lipu jiicenige wawename, yepä tabe singi ge teebine ogä ägyime. ");
INSERT INTO bon_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tabe liba ngene jotwananige teebine ägyime, Yageyame me mename seemo te wama cabu piba taboclomtige teeme bau me, jejige egä, “Yoosepa, Daawida me kaakesaare, wälu gone läbitute Mariya ne coga me acatame, ingle tabe Aceji Seemo name mäpumäpu gwene. ");
INSERT INTO bon_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tabe bägrä ne pa jäärngepi, maane ngii einepi Yeesu, ingle tabe te teeme binamewale bine teeme niiya cabu ca cirege äsecrera.” ");
INSERT INTO bon_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Siige, ai mule cina äbitininisi naace tääpume toraca me äbitame Yageyame me yepä mename biname te lipu teeme mene jeitnäjuji egä, ");
INSERT INTO bon_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Camu tääpe cama ngulebägrä te mäpumäpu cirege, siige bägrä ne cire jääpänepi. Teebine Emanuwela ca cire yaainepesi.” Emanuwela lui egä ‘Acejiyame pisi nyene mine cama.’ ");
INSERT INTO bon_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Siige Yoosepa liba arpinantige, tabe Mariya ne coga me jowenige, Yageyame me mename seemo te teebine lipu jejige. ");
INSERT INTO bon_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yepä teepi magebi rooriye bime mule lica jaawenäsi, ngälu Mariya bägrä ne jirngige, siige Yoosepa ngii ecärige Yeesu. ");
INSERT INTO bon_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heroda lui padare cabu mope biname me enajuji, Yeesu piba aplimluji Betelehema cewe je Yuudea probins cabu. Pui ingwe gaabe ca lui cina labiberäjininusi wale poto cidi me, seclige bimu acita gome ca Yerusalema me, ");
INSERT INTO bon_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","biname bine puma itemläjemisi egä, “Kirece bägrä ärngeji luci yene, lui te cirege Israela biname bime mope biname me äbita? Cine teeme wale ne jääpänepesi, bimu acita gome ca liba tacitepi, siige cine naclige teeme gome kokorare ca äpednerame.” ");
INSERT INTO bon_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mope biname Heroda liba itecijige ai mene, tabe mage ngenecu mäpu me äbitige cuta iyeta Yerusalema biname piiyepu. ");
INSERT INTO bon_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tabe ala tesoglicmige iyeta modamoda iiwäreja biname piiyepu cotre abiberäja biname bine, siige itemlimige egä, “Keriso lui te biname bine niiya cabu ca cirege äsecrera, tabe luma cire laplimlepi?” ");
INSERT INTO bon_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Teepi Heroda ne jejisi egä, “Tabe cire laplimlepi Betelehema cewe je Yuudea probins cabu. Cine umle apu gemi, ingle Acejiyame me mename biname te ituge oogära ai poto cidi me apu egä, ");
INSERT INTO bon_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelehema cewe Yuudea gawe cabu, maane papa cewe lica gäte nuuja Yuudea cewe cabu ca, ingle määme cabu ca cirege mope biname otni, lui te cäme Israela biname bine cire yaawademepi.’” ");
INSERT INTO bon_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heroda liba ai mene itecijige, tabe piba ogä ala tesoglecmige bimu acita gome ca lui cina seclumi Yerusalema me, siige itemlimige egä, “Weene liba jääpänepeye wale ne acita?” ");
INSERT INTO bon_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Heroda liba umle äbitige, wale te liba tacitepi, peei ingwe gaabe ca tabe piba pui biname bine jityepimige Betelehema me apu mene cama egä, “Äte naaclege cängena bägrä ne ärngime. Liba jepänepeye, piba täcnäripeye cebine umle wawename. Cane cuta piba pa lädepene kokorare ca äpednutame teeme gome.” ");
INSERT INTO bon_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Siige teepi eclige, gaabegabe jepänisi pui yepä wale ne, teepi lui ne jääpänanepesi bimu acita gome ca. Teepi liba jepänisi, siige mage gege ecisi. Wale te teeme niinäce me äbitige, ngälu emä bojä jegige, bägrä te luma enajige. ");
INSERT INTO bon_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Teepi mete bora me ebäcnisi, siige bägrä ne liba jepänisi teeme mage Mariya cama, teepi kokorare ca ipednemalimisi teeme gome teebine opo gaabe me acitame. Puma cita ca teepi baiko bine jepatnimisi, isemisi gol, miijirage lengo pauda uubudera tääpume piiyepu miijirage lengo uli ngedo ngii miira, siige ecärisi bägrä matikäli ne. ");
INSERT INTO bon_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pui ingwe gaabe ca teepi teeme cewe me nuuja gaabe cabu äcnärige, ingle Acejiyame te teebibine wama ca umle jewenimige egä, “Weene gone läcnärininuye Heroda ne umle wawename.” ");
INSERT INTO bon_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bimu me acita gome ca lui biname cina saaclepi, liba äcnärige teeme cewe me, piba Yageyame me mename seemo te taboclomtige Yoosepa bau me, wama secärige egä, “Arpinanti, bägrä ne ecati teeme mage cama, uucratnäneye Aikupito me. Puma inajäpi, ngälu cane te pa jijipene weene äcnärame. Weene ai ne naace name pi wawename, ingle Heroda bägrä ne pa jäärngepi budre me aglime.” ");
INSERT INTO bon_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Puma cita ca Yoosepa arpinantige, bägrä ne ecatige mage cama, siige ciiye Betelehema ne sebmalänisi Aikupito me otnime. ");
INSERT INTO bon_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Teepi puga aanajänige, ngälu Heroda budre äbitige. Ai mule te naace tääpume äbitige ibibi äbitame mename biname te lipu Yageyame me mene jeitnäjuji egä, “Aikupito ca cane cäme bägrä ne ituge ala asogleca.” ");
INSERT INTO bon_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda liba umle äbitige, egä bimu acita gome ca lui biname cina saaclepi teebine sengletnäjumesi, siige tabe caapocapo claabe te joomlige. Tabe jejemige neeneni kämäge cama imäbägrä bine coo piiyepu teeme iganewale bine iyeta budre me aglecame Betelehema cewe ngalebora je piiyepu teeme wajwa je lui cewe cabu ta. Tabe neeneni kämäge cama imäbägrä bine piiyepu teeme ingwe ca lui imäbägrä bine aglecame naace popi jejemige, ingle bimu acita gome ca lui cina saaclepi, tabe teeme bau ca umle läbitepi, egä neeneni kämäge ngalebora teepi pui wale ne jääpänanepesi. ");
INSERT INTO bon_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Apu toraca me äbitige mename biname Yeremiya lipu niinäce gaabe me itu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Teepi Raama cewe ca ala itecijenemige piiyepu ngenecu bora babo ele. Raakela ele ongenige teeme bägrä bime tääpume, tabe singi lica teebine owe äswime, ingle teepi opo puma lica gemi.” ");
INSERT INTO bon_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroda liba budre äbitige, piba Yageyame me mename seemo te taboclomtige Yoosepa bau me Aikupito je, wama secärige egä, ");
INSERT INTO bon_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Arpinanti, bägrä ne ecati teeme mage cama, äcnäräneye Israela gawe cabu me, ingle lui cina bägrä ne aglime jaawenanepesi, budre gemi.” ");
INSERT INTO bon_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Puma cita ca Yoosepa arpinantige, mage bägrä bine aacatige, äcnäränisi Israela me. ");
INSERT INTO bon_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yoosepa liba itecijige, egä Arkela teeme babe Heroda me puupu itu jaacatepi, mope biname me itu läbitepi Yuudea probins ngalebora, siige tabe wälu äbitige Yuudea me acnenutame. Puma cita ca Acejiyame te cuta nuuja wama secärige tabe otnime Galilaya probins cabu me, siige tabe piiyeme ädige. ");
INSERT INTO bon_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Teepi puga aanajänige cewe ngii Nasareta je. Apu ibibi äbitige Acejiyame me mename biname bime mene egä, “Teebine Nasareta biname ca cire yaainepesi.” ");
INSERT INTO bon_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pui padare cabu Yoane niiye ca äciseja biname te tädige, gije abacitige mene jajanename daapo taatu cewe cabu je Yuudea gawe ngalebora. ");
INSERT INTO bon_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tabe apu jiicemige egä, “Weene niiya mule cabu ca atatrongärineye, ingle Acejiyame te mameta gyene biname bine waadena.” ");
INSERT INTO bon_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yoane peese nyene pui biname, Acejiyame me mename biname Isaya lui poto cidi me itu jiicuji egä, “Daapo taatu cewe cabu biname te babo tagepogogo ca cire jiicepi egä, ‘Gaabe ne emacetnäjeye Yageyame tääpume, weeme mule bine conocäco jewenemeye teeme otni tääpume!’” ");
INSERT INTO bon_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoane me cäbletääpe lui kamela me ngäli ca wawenäneji ge, piiyepu tabe kamela tääpe baagi ca asigräneji ge ibi cabu. Tabe sesi pana gwidape bine yäärngäjimuge piiyepu uri niiye yäänäjuge. ");
INSERT INTO bon_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Biname cina saacluge teeme bau me Yerusalema ca, iyeta poto ta Yuudea gawe cabu ca piiyepu Yoridana baduge neeneni poto ca. ");
INSERT INTO bon_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tabe piba teebibine niiye ca jicisäjemige Yoridana baduge cabu, teepi liba teeme niiya mule bine jewabudnäjimisi. ");
INSERT INTO bon_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoane liba jepänimige bucurage Parisea sigu biname piiyepu Sadukea sigu biname cina otni teeme bau me niiye ca äciseja tääpume, tabe jejemige egä, “Weene cobyame pana angletne-jayame biname gemi! Weene apu jingenininige, egä weebibine liba niiye ca birige äciseja, weene siige piba cire uucratnipeye mäpu daremu cabu ca, Acejiyame te lui ne cire täätyepepi. ");
INSERT INTO bon_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Weene eei mule bine jewenemepeye, lui cina jiwabininusi, egä weene siige bii tatatrongärininiye niiya mule cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Piiyepu cuta weene apu gone jingenininige egä, ‘Ingle Abrahamo lui cime kaakesaare gyene, peei name pi cine mäpu daremu ne lica cirege päpäna Acejiyame bau ca.’ Cane weebibine jijenininine, egä Acejiyame liba singi gyene, tabe ibibi gyene ai kula bine ateplengäjame Abrahamo me kaakesaare tääpume. ");
INSERT INTO bon_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yäpä acitäneji gyene uli maape. Lui uli cina miijirage kuu lica yääyemuge, yaargawimusi, uliobo cabu me yiisabimusi. ");
INSERT INTO bon_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Cane weebibine niiye ca jicisäjenininine awabame, egä weene siige bii tatatrongärininiye weeme niiya mule cabu ca. Yepä laati te pa tädepi cäme ingwe ca, tabe weebibine Aceji Seemo ca piiyepu uliobo ca page jicisäjipi. Uliobo te lipu domäji bine yaabemuge, tabe pepu pagege weeme cabu ca jugijugi mule bine äciseja. Tabe baborage gyene, cane matikäli gäne. Cane ibibi lica gäne teeme ernge gwidape seea iibirame. ");
INSERT INTO bon_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Teeme pisi nyene wiiti kuu ämleceja gwidape wiiti kuu mälwä cama maramara me wawename. Tabe kuu bine teeme mete cabu me cire yaawademepi, mälwä bine ätuma cäco uliobo cabu me cire yiisabemepi ayi tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Piba Yeesu tädige Galilaya gawe cabu ca Yoridana baduge me Yoane te teebine niiye ca puma äcisejame. ");
INSERT INTO bon_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yepä Yoane singi ge Yeesu me ngenecu atatrongtame, siige tabe jejige egä, “Maane te cebine miiji niiye ca äciseja, peei name pi maane ngeno me tädite cäme bau me niiye ca äciseja tääpume?” ");
INSERT INTO bon_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu jejige egä, “Ai taje maane jeweni, cane ngena tääpume naajenine. Apu mule ca mine jewenenago, Acejiyame ngena tääpume singi.” Yoane Yeesu me mene jecatige, siige teebine niiye ca jicisäjige. ");
INSERT INTO bon_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yeesu ne liba niiye ca jicisäjige, tabe piba tarpatige niiye cabu ca. Piba taatu cabucewe te iitnige teeme tääpume, siige tabe jepänige Acejiyame me Seemo te äina je gimäe ele pana teeme papa cabu me. ");
INSERT INTO bon_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Puma cita ca tagepogogo te tädige cabucewe ca egä, “Ai lui cäme ngenecurage bägrä gyene. Cane baborage ngenecu miiji gäne teeme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Puma cita ca Aceji Seemo te Yeesu ne ecanige daapo taatu cewe cabu me Satani te teebine puma apicetnäräjame. ");
INSERT INTO bon_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tabe liba footi bimu footi ciiye cama deedei cäco enajige puma, piba loolomecewe te joomlige. ");
INSERT INTO bon_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Puma cita ca Satani te teeme bau me tädige, jejige egä, “Maane liba Acejiyame me Bägrä gäte, ai kula bine jejemi buluduu me ateplengame.” ");
INSERT INTO bon_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeesu jejige egä, “Oogäräneji mene te apu jiicenige egä, ‘Deedei taatu te ireclota lica yääcärimuge biname bine, yepä iyeta mene Acejiyame lui jiicemuge.’” ");
INSERT INTO bon_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Puma cita ca Satani te Yeesu ne ecanige babo cewe Yerusalema me, Acejiyame tääpume mara me lui cewe wawenäneji ge, siige teebine puga etecwantige iiwäreja mete toro cabu caburage je, ");
INSERT INTO bon_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","jejige egä, “Maane liba Acejiyame me Bägrä gäte, maane ama cita ca uuplacamti gawe me, ingle Oogäräneji mene te jiicenige egä, ‘Acejiyame te teeme mename seemo bine cire jaajemepi määme poto cidi me; siige teepi meebine teeme ime cabu cire naacanepesi, piba maane määme ernge ne kula cabu lica pa jimudnärepi.’” ");
INSERT INTO bon_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu Satani ne jejige egä, “Oogäräneji mene te cuta jiicenige egä, ‘Maane dupe päpäname määmämu gone läbitute Yageyame määme Acejiyame ne apicetnärame, egä tabe kälyä nawenuge.’” ");
INSERT INTO bon_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Puma cita ca Satani te Yeesu ne ecanige babo podo caburage me, puma teebine jewabäjige maramara mope biname bime gawe piiyepu teeme iyeta lijalija gwidape, ");
INSERT INTO bon_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","siige jejige egä, “Iyeta ai cane meebine nääcärenine, maane liba kokorare ca ääpednutenite cebine awejename.” ");
INSERT INTO bon_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeesu teebine jejige egä, “Satani, äyeblingti cäme bau ca, ingle Oogäräneji mene te apu jiicenige egä, ‘Yageyame, määme Acejiyame ne yaawejanuye, cuta teeme taatu singi ne jewenepi.’” ");
INSERT INTO bon_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Siige Satani te Yeesu ne ebmalige; Acejiyame me mename seemo cina piba seclige teebine ätityerame. ");
INSERT INTO bon_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yeesu liba itecijige, egä Yoane ne krokeciiye mete me bisinglantisi, tabe acnenutige Galilaya probins cabu me. ");
INSERT INTO bon_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tabe Nasareta cewe je lica enajige, yepä tabe ädige Kaprenauma cewe je lenajame, lui tage Galilaya sawa gome Seblona Napatali naabime gawe cabu. ");
INSERT INTO bon_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Apu toraca me äbitige mename biname Isaya me mene egä, ");
INSERT INTO bon_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Seblona piiyepu Napatali naabime gawe piiyepu lui gawe Meditareniya malu gome, piiyepu Yoridana baduge me bimu acita gome ca lui gawe piiyepu Galilaya gawe, Acejiyame umle cäco biname cina luma icrajinige; ");
INSERT INTO bon_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ai maramara gawe cabu, lui biname cina krokeciiye cabu icrajinige, teepi babo apaclyera ne cirege päpäna. Cuta lui biname cina wäluwälu icrajinige budre mule name pi, apaclyera te teeme cabu me cire luungepmalepi.” ");
INSERT INTO bon_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yeesu lui padare acnenutige Galilaya me, tabe gije abacitige mene jajanename egä, “Tatatrongärineye weeme niiya mule cabu ca, ingle Acejiyame te mameta gyene biname bine waadena.” ");
INSERT INTO bon_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeesu liba ädige Galilaya sawa ligi ta, tabe jääpänige nanigane wäsi bine, Simona (lui ne einenisi Peteru ca) piiyepu teeme igane Andrea. Teepi net bine yiisabäjemäsi sawa bora me, ingle teepi cibubade biname ge. ");
INSERT INTO bon_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu teebibine jaajige egä, “Siclege cane cama otnime cäme abiberäja bägrä lenajame. Weene niinäce lipu cibu bine toomläjenanemumeye, page cane weebibine ibiberäjinine biname bine cäme bau me pepu waadename.” ");
INSERT INTO bon_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Piba taatu teepi teeme net bine ebmalemäsi Yeesu cama yepä otnime. ");
INSERT INTO bon_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Puma cita ca cerämu tabe ädige, cuta nuuja nanigane wäsi bine jääpänige, Yakobu naabi Yoane Jebedayo me bägrä. Teepi teeme poo cabu jage teeme babe Jebedayo cama, net bine emacetnäjemäsi. Yeesu Yakobu Yoane naabibine ala taasoglicige teta cama otnime. ");
INSERT INTO bon_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Teepi piba taatu teeme babe ne ebmaläsi poo cabu, Yeesu cama aaclige. ");
INSERT INTO bon_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu Galilaya probins cabu iyeta poto ta waatnetnäjuge. Tabe biname bine yaabiberäjimuge teeme abasecretna mete cabu ta, Miiji Mene jaajananemuge, egä Acejiyame te biname bine pagege waadena, piiyepu cuta tabe biname bine maramara pita cabu ca miiji me jaawenanemuge. ");
INSERT INTO bon_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yeesu ne idre jecenanisi iyeta poto ta Suriya gawe cabu. Pipu pi teeme bau me biname bine sewadäjemisi, lui cina cewe loocananinusi maramara pita coo mäpu name pi, naace niiyarage cable teeme trupa cabu, oonina pita piiyepu tääpe nuuja poto budre. Yeesu iyeta teebibine miiji me jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bucurage biname cina Yeesu ne ingwe sicwisi Galilaya gawe cabu ca, Ten Modamoda Cewe gawe cabu ca, Yerusalema ca, Yuudea gawe cabu ca piiyepu Yoridana baduge me bimu acita gome ca. ");
INSERT INTO bon_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeesu biname tomi bine liba jepänimige, tabe piba jegelige podo cabu me, puga adnatige. Teeme abiberäja bägrä cina jewaclomtisi teebine, ");
INSERT INTO bon_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","siige tabe gije jecitige teebibine abiberäjame egä, ");
INSERT INTO bon_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ngenecu miiji eei gemi, laati bemi owecumete seemo ireclota ngalebora; Acejiyame te teebibine yaawadimuge. ");
INSERT INTO bon_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ngenecu miiji eei gemi, laatibi ele yaangenetnemuge; Acejiyame te teebibine owe yääswemuge. ");
INSERT INTO bon_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ngenecu miiji eei gemi, laati bemi Acejiyame taatu cabu me ire; teepi jääpänimusi Acejiyame ngena tääpume ituge iicana. ");
INSERT INTO bon_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ngenecu miiji eei gemi, laati bemi baborage singi wawename Acejiyame me singi; teeme peei singi te toraca me läbituge. ");
INSERT INTO bon_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ngenecu miiji eei gemi, laatibi poto biname bine owecu jaawenimusi; teepi cuta owecu ne jääpänusi teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ngenecu miiji eei gemi, laati bemi yepä taatu ngene atwana cama; teepi Acejiyame ne jääpänusi. ");
INSERT INTO bon_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ngenecu miiji eei gemi, laati bemi poode wawenetnäja biname; teebibine Acejiyame me bägräwale ca birige aina. ");
INSERT INTO bon_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ngenecu miiji eei gemi, biname cina lui bine sabe jaawenanemusi, ingle naace popi teepi Acejiyame me singi ne jaawenusi; Acejiyame te teebibine yaawadimuge. ");
INSERT INTO bon_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Weene ngenecu miiji gemi, biname cina liba niiya mene jiicemusi weeme poto cidi me, sabe jiwenininusi piiyepu walya jicamininusi cämiji pi. ");
INSERT INTO bon_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Weene miiji baborage ngenecu miiji piiyepu gege, ingle weene cabucewe je baborage daremu ne cire jepänepeye. Acejiyame me mename biname lui cina weeme niinäce gaabe itu secluji, teebibine cuta pepu ituge sabe wawena.” ");
INSERT INTO bon_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Weene caapereniiye pana gemi gawecewe biname bime tääpume. Caapereniiye me kaakesea pisi nyene, yepä teeme mite te liba lapiruge, weene ingwe ca äblicäco caapereniiye ne cuta mite me wawena. Mite cäco caapereniiye nuuja miiji lica gyene, peei name pi gaabe cabu yaajarusi, biname cina siige ernge ca jääbrecäjusi. ");
INSERT INTO bon_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Weene apaclyera pana gemi gawecewe biname bime tääpume. Babo cewe te podo papa cabu äblicäco ämlitäneji lenajame. ");
INSERT INTO bon_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Biname te liba lampa ne jaabotuge, tabe diiba ca lica yaacwabuge, yepä cabu me yaatecwantuge, siige puma cita ca biname bine saapaclyäremuge mete ngalebora. ");
INSERT INTO bon_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Weene pepu cuta biname bine yaapaclyäremuye, egä teepi liba weeme miijimiji mule bine jääpänanemusi, siige piba eso yääcärusi weeme Babe ne, cabucewe je lui te enajenige.” ");
INSERT INTO bon_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Weene gone apu angi, egä cane itu tädujine Moose me Cotre mene bine piiyepu Acejiyame me mename biname bime abiberäja mene bine sabe wawename. Eewe, cane tädujine peei mene bine toraca me wawename. ");
INSERT INTO bon_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cane toraca jijenininine, egä cabucewe piiyepu gawecewe liba taatu aanajenige, licarage nuuja leta ne coo matikolä maaku ne cirege äyeblingta Cotre mene cabu ca, ngälu lui mule poto cidi me jiicenenemige, cirege äbita. ");
INSERT INTO bon_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pipu pi laati te liba jaatropangtuge yepä cotre ne, ngänu gyene matikolä cotre, piiyepu biname bine yaabiberäjimuge teepi peei yepä mule wawename, tabe matikäli gyene Acejiyame te lui biname bine yaawadimuge. Yepä laati te cotre bine yääcwetnimuge piiyepu biname bine yaabiberäjimuge teepi peei yepä mule wawename, tabe baborage gyene Acejiyame te lui biname bine yaawadimuge. ");
INSERT INTO bon_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cane toraca mene jijenininine: weeme conocäco mule cina liba lica itucärenenemisi Parisea sigu biname piiyepu cotre abiberäja biname bime conocäco mule bine, siige Acejiyame te piba weebibine lica iwadininuge.” ");
INSERT INTO bon_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Weene ituge ätecija, egä mime saarewale bine sasa jajeji gemi egä, ‘Gone nuuja biname ne budre me yaagluye. Laati te liba yaagluge biname ne budre me, teebine cirege ablawa.’ ");
INSERT INTO bon_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yepä cane te jijenininine weebibine, egä laati te liba claabe läbituge nuuja ätrunga biname tääpume, teebine miiji birige ablawa. Coo laati te liba teebine jaajuge egä, ‘Maane papa biname gäte,’ siige pui biname ne miiji yaacanusi mutre biname cina ablawame. Coo piiyepu laati te liba nuuja ätrunga biname ne jaajuge egä, ‘Maane Acejiyame umle cäco biname gäte,’ tabe epu niiyarage gyene, egä tabe miiji uliobo puupu cabu me otni. ");
INSERT INTO bon_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Peei name pi maane liba yaacanute owecu gwidape ne Acejiyame me mete cabu iiwäreja dade cabu acitame, siige maane puma ngene jwaatwute egä, ‘Nuuja ätrunga biname te claabe gyene cäme tääpume,’ ");
INSERT INTO bon_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","maane owecu gwidape ne ebmalepi iiwäreja dade opo gaabe, ädepi poode wawename määme biname cama, piba tacnenutepi owecu gwidape Acejiyame ne ceerame. ");
INSERT INTO bon_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Laati te liba naaitnäjuge, siige singi birige ablaweja puupu cabu me acaname, maane gaabegabe teebine watawata poode me jaawenute, weene liba cäro camu ge ablaweja puupu cabu me atyaramta. Maane liba poode wawena cäco, cije tabe ablaweja biname me ime cabu naacituge, siige tabe te teeme ätityera biname bine jaajemuge meebine acaname krokeciiye mete cabu acitame. ");
INSERT INTO bon_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cane toraca mene naajenine: maane lica tasatute, ngälu iyeta daremu yaapirute.” ");
INSERT INTO bon_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Weebibine ituge abiberäja egä, ‘Sargi ero mule gone.’ ");
INSERT INTO bon_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yepä cane toraca jijenininine, egä laati te magebi ne coo ngulebägrä ne singisingi jwääpänuge ten cama ero mule wawename, tabe teeme ngenecu bora uja ero jwaawenuge. ");
INSERT INTO bon_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Määme camu poto irecu te liba naawenuge singi ädrime maane niiya mule wawename, maane miiji watatarage määme peei ngene atwana ne äyeblingta, epu pana irecu ne lipu juungyatute, siige yaajarute. Niiya gyene maane yepä piicwa ne apesera, yepä cerämu niiya gyene maane iyeta piicwa cama uliobo puupu cabu me otni. ");
INSERT INTO bon_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Määme camu poto ime te liba naawenuge maane singi ädrime niiya mule wawename, maane miiji pui ngene atwana ne watatarage äyeblingta, epu pana ime ne lipu joopotute, yaajarute määme bau ca. Niiya gyene maane yepä piicwa ne apesera, yepä cerämu niiya gyene maane iyeta piicwa cama uliobo puupu cabu me otni.” ");
INSERT INTO bon_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Biname bine cuta ituge abiberäja egä, ‘Rooriye te liba singi teeme coga ne ägyime, tabe miiji peba ne oogära ägyi poto cidi me, siige pui peba cama jwäätyepuge teeme coga ne.’ ");
INSERT INTO bon_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yepä cane te jijenininine: lui rooriye te liba teeme coga ne jwäägyuge poto ingle name pi yepä lica sargi ero mule name pi, siige tabe teebine jwaawenuge ero wawename, tabe liba nuuja rooriye ne yaacatuge. Cuta nuuja rooriye lui te teebine waacatuge, tabe ero jwaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Weene cuta ituge ätecija, egä mime saarewale bine sasa jajeji gemi egä, ‘Maane gone määme mene atropengta, yepä jewenepi maane Acejiyame me ngii cabu ngena ituge jaji wawename.’ ");
INSERT INTO bon_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yepä cane te jijenininine weebibine, egä weene liba mene iicema je, weene gone nuuja me ngii cama iicana pui mene ne atropengta cäco me wawename. Weene gone cabucewe me ngii cama iicana, ingle Acejiyame me lenaja puupu gyene. ");
INSERT INTO bon_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Cuta gone gawecewe me ngii cama iicana, ingle teeme ernge acita gawe gyene; cuta piiyepu Yerusalema me ngii cama gone iicana, ingle babo mope biname me cewe gyene. ");
INSERT INTO bon_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Määme mope me ngii cama cuta gone jiicute, ingle maane äblicäco gäte yepä matikäli edingäli ne bulubulu me coo cäsäcäsä me wawena. ");
INSERT INTO bon_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Weene gone nuuja mene jiicuye, yepä ‘yoo’ taatu jiicuye, weene liba singi ngena wawename, cuta ‘lica’ taatu jiicuye, weene liba singi lica. Nuuja mene cerämu weene liba jiicuye, peei lui Satani me bau ca gyene.” ");
INSERT INTO bon_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Weebibine ituge abiberäja egä, ‘Biname te liba nuuja biname me irecu ne sabe jaawenuge, pui biname ne cuta miiji daremu awecnista teeme irecu ne sabe wawename. Piiyepu biname te liba nuuja biname me giricu jääglecnutuge, pui biname ne cuta miiji daremu awecnista teeme giricu ne äglecnutame.’ ");
INSERT INTO bon_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yepä cane te jijenininine weebibine, egä nuuja biname me niiya mule gone daremu wawena. Biname te liba camu poto lakace cabu noororuge, maane latatrongtute tabe meebine säwäci poto lakace cabu cuta oororame. ");
INSERT INTO bon_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Piiyepu biname te liba naacanuge ablaweja puupu cabu me, ingle tabe singi läbituge määme soto tääpume, maane miiji cuta määme acwaba gwidape yääcärute. ");
INSERT INTO bon_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Piiyepu biname te liba näädretnicuge maane teeme gwidape bine waadename yepä kilomiita pana padare me, maane neeneni kilomiita pana padare me ewademepi. ");
INSERT INTO bon_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Biname te liba ngena tääpume näätinäruge, maane miiji ecärepi. Coo tabe liba singi määme gwidape watawata acatame, gone läbwäricute.” ");
INSERT INTO bon_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Weebibine ituge abiberäja egä, ‘Weene weeme biname bime tääpume singi inajininuge, yepä lui cina weebibine jimugitninusi, weene cuta teebibine jäämugetnemuye.’ ");
INSERT INTO bon_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yepä cane te jijenininine weebibine, egä lui cina weebibine jimugitninusi, weene teeme tääpume singi inajipi, piiyepu lui cina sabe jiwenininusi, weene teeme tääpume irecu ätumutipeye, ");
INSERT INTO bon_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","weene piba päbitipeye weeme Babe me bägräwale me, cabucewe je lui te enajenige. Tabe yepärage bimu ne jaawenuge acitame niiya biname bime tääpume coo miiji biname bime tääpume. Tabe cuta ngupe sääcärimuge, lui cina conocäco mule jaawenimusi cuta lui cina conocono mule jaawenimusi. ");
INSERT INTO bon_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Weene gone Acejiyame bau ca miiji daremu ne awagrija, weene liba eei biname bime taatu cabu me singi, lui cina weeme tääpume singi. Niiyarage täks rarekaake uutecrena biname cina cuta pepu jaawenusi. ");
INSERT INTO bon_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Piiyepu weene liba weeme binamewale bine taatu jaawablimuye, weene peei lui nuuja mara gwidape ne lica jaawenuye. Acejiyame umle cäco biname cina cuta pepu jaawenusi. ");
INSERT INTO bon_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Weene miiji epucäco lenaja, weeme Babe te lipu cabucewe je epucäco gyene.” ");
INSERT INTO bon_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Weene miiji cängena ire, egä weene gone miijimiji mule bine wawenetnäja biname bime sobe cabu naace tääpume teepi päpäname. Weene liba apu läbitininuye, weene nuuja daremu ne lica cirege päpäna weeme Babe bau ca, cabucewe je lui te enajenige. ");
INSERT INTO bon_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pipu pi maane liba owecumete biname bine yääcäranemute gwidape, gone cabucabu yääcäranemute, walya biname cina lipu läbitaninusi abasecretna mete cabu ta piiyepu gaabe cabu ta. Teepi apu naace name pi läbitininusi egä biname cina teebibine awepyeräjame. Cane toraca mene jijenininine, egä teepi lui awepyeräja ne jepänenisi biname bime bau ca, teeme daremu gyene. Teepi nuuja daremu ne Acejiyame bau ca lica cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yepä maane liba ngena owecumete biname bine yääcäranemute, ogä jewenemepi epu, camu poto ime te liba ngena jaawenuge, säwäci poto ime te umle cäco. ");
INSERT INTO bon_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Piba biname cina umle lica birige määme miijirage mule. Yepä määme Babe lui te iyeta gwidape tääpume umle, tabe meebine miiji daremu cire nääcärepi.” ");
INSERT INTO bon_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Weene liba irecu lätumutinuye, weene gone läbitininuye walya biname bime pana. Teepi liba irecu lätumutinusi, teepi singi birige aclajutame abasecretna mete cabu coo piiyepu gaabe cube cabu, ingle teepi singi biname cina päpäname. Cane toraca mene jijenininine weebibine, egä teepi lui awepyeräja ne jepänenisi biname bime bau ca, teeme daremu gyene. Teepi nuuja daremu ne Acejiyame bau ca lica cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yepä maane liba irecu lätumutute, maane miiji mete bora me abacitepi, grana sermepi, siige piba irecu ätumutepi määme Babe bau me, lui te päpäna cäco gyene. Maane ngena ne ogä jaawenute, määme Babe te nääpänuge, siige daremu nääcäruge. ");
INSERT INTO bon_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Weene liba irecu lätumutinuye, weene gone bucurage papapapa mene iicema Acejiyame umle cäco biname liiyepu, lui cina apu jaangemuge egä, ‘Acejiyame te nitecijinininige, ingle mime irecu ätumuta lui lecarage gyene.’ ");
INSERT INTO bon_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Weene teeme pana gone läbitininuye, ingle weene liba yäätinäruye, tabe weeme Babe te uja umle bäbitige, weene singi ngena tääpu memi. ");
INSERT INTO bon_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Weene apu irecu ätumutipeye: Cime Babe cabucewe je, määme miijirage ngii ne opo gaabe me naacitesi. ");
INSERT INTO bon_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maane te biname bine ewademepi. Määme singi ne gawecewe cabu jaawenesi, cabucewe je lipu jewenenisi. ");
INSERT INTO bon_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Page nicäranini cime bimu gaabegabe deedei. ");
INSERT INTO bon_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Maane gone cime niiya mule bine yaawadimute, cine lipu lica yaawadimusi biname cina lui niiya mule niwenininusi cibibine. ");
INSERT INTO bon_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Maane gone cibibine niwadininute mäpurage apicetnära cabu me, yepä niwärimtipi niiya te oomlana wälu pi. ");
INSERT INTO bon_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Weene liba weemeweme niiya mule bine lica yaawadimuye, piba weeme Babe te cabucewe je weeme niiya mule bine lica yaawadimuge. ");
INSERT INTO bon_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yepä weene liba weemeweme niiya mule bine yaawadimuye, piba cuta weeme Babe cabucewe je weeme niiya mule bine yaawadimuge.” ");
INSERT INTO bon_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Weene liba Acejiyame ne awejena name pi deedei cäco inajininuge, weene gone owecumete opo inajininuge walya biname cina liiyepu. Teepi naace name pi owecumete opo yaacrajuge, ingle teepi singi biname cina päpäname, egä teepi deedei cäco icrajinige Acejiyame ne awejename. Cane toraca mene jijenininine, egä teepi lui awepyeräja ne jääpänusi biname bime bau ca, peei lui teeme daremu birige. Teeme nuuja daremu lica cirege. ");
INSERT INTO bon_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yepä maane liba deedei cäco naanajuge ingle Acejiyame ne awejena name pi, miiji maane opo läcisäjute, mope oil ca laganute. ");
INSERT INTO bon_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pipu pi nuuja te umle lica birige, egä maane deedei cäco naanajuge, yepä määme Babe, lui te päpäna cäco gyene, tabe taatu umle birige. Tabe te daremu cire näcärepi, ingle tabe umle gyene, maane ogä ngena ne jaawenute.” ");
INSERT INTO bon_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Weene gone miijimiji gwidape bine yaatomlicmuye weeme tääpume ai gawecewe cabu, potäte cina luma gwidape bine sabe jaawenimusi, liiya te luma joomlemuge, cuta piiyepu eromaame cina liiyeme saacluge ero me. ");
INSERT INTO bon_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yepä weene jewenemepeye miijimiji mule bine. Peei lui epu pana gyene, egä weene miijimiji gwidape bine yaatomlicmuye weeme tääpume cabucewe je, potäte cina luma sabe lica jaawenimusi, coo liiya te lica joomlemuge coo piiyepu eromaame cina äblicäco äbäcna ero me. ");
INSERT INTO bon_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Määme miijimiji gwidape cina luma, määme ngenecu te cuta puma.” ");
INSERT INTO bon_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Irecu lui tääpe tääpume lampa gegi. Määme irecu cina liba miiji birige, määme tääpe te iyeta apaclyera taatu birige. ");
INSERT INTO bon_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yepä määme irecu cina liba niiya birige, määme tääpe te cuta krokeciiye cabu yaanajuge. Siige määme cabu lui apaclyera liba krokeciiye birige, piba määme krokeciiye lipu baborage gyene.” ");
INSERT INTO bon_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Biname te äblicäco neeneni modamoda biname bine acenena. Tabe nuuja ne jäägyuge, nuuja tääpume singi läbituge. Tabe nuuja ne opo gaabe me yaacituge, nuuja ne kaake ca sääcelyäruge. Peei name pi weene äblicäco gemi neeneni bine acenena, Acejiyame ne piiyepu rarekaake ne. ");
INSERT INTO bon_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Cane peei name pi jijenininine, egä weene ngenecu gone, egä weene ngena yaarwuye, ngena yaanuye, coo piiyepu weene ngena lasigrärinuye. Egäsu ireclota lui baborage gyene, deedei piiyepu niiye papa gemi; piiyepu tääpe lui baborage gyene, cäbletääpe lui papa gemi. ");
INSERT INTO bon_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jepänemeye, cabu je lui ele cina uujananinisi, teepi gije lica yäätemusi, lica yäärucnimusi, deedei cumä lica yaacranimusi, yepä weeme Babe cabucewe je tabe te teebibine cängena ire jetwenenemige. Egäsu weene modamoda gemi, ele lui papa gemi. ");
INSERT INTO bon_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Weene nää miiji gemi weeme ireclota bine ngenecu mäpu ca lecaleca me wawename? ");
INSERT INTO bon_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Piiyepu weene ngena name pi ngenecu mäpu cäbletääpe poto cidi me? Weene jepänemeye baace popo cina lipu uutenininisi. Teepi kaakesea lica jaawenimusi, cuta asigrera gwidape bine lica yaaterutäjimusi. ");
INSERT INTO bon_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yepä cane weebibine jijenininine, egä ngänu gyene, mope biname Solomona puu miijirage cäbletääpe ca abasogäruji, yepä tabe epu miiji opo lica äbituji ai baace popo bime yepä te liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Acejiyame te liba apu yaabasogärimuge baace bine, page lui cina ireclota gemi, ciiyeciye siige uliobo cabu me yiisabimusi, egäsu tabe cuta weebibine isigreräjininuge cäbletääpe ca. Weeme ätrunga lipu matimati gemi! ");
INSERT INTO bon_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Weene miiji mäpu ngene atwanena bine abmaläcemame deedei, niiye piiyepu cäbletääpe poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Acejiyame umle cäco biname teepi te jäärngemusi ai gwidape bine, yepä weeme Babe cabucewe je tabe uja umle gyene, egä ai weeme singi gwidape gemi. ");
INSERT INTO bon_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pätä weene miiji niinäce äbitipeye Acejiyame te weebibine waadename piiyepu weene wawename, tabe ngena tääpume singi, siige Acejiyame te piba icärininuge iyeta weeme singi gwidape. ");
INSERT INTO bon_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pipu pi weene ciiyeciye tääpume ngenecu mäpu gone; ciiyeciye me mäpu lui teeme yene. Ai bimu me mäpu ibibi gyene ai bimu tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Weene gone biname bine jaatranimuye, piba weebibine lica cirege atrana. ");
INSERT INTO bon_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ingle naace popi weene lipu teebibine jaatranimuye, weebibine cuta pepu cirege atrana. Weene luma ngine yaatonäremuye biname bine, weebibine cuta puma ngine birige atonera. ");
INSERT INTO bon_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Peei name pi gone määme nuuja ätrunga biname me irecu cabu pläpu ne ire jaatwanute, maane liba uli pargi ne lica jääpänute määme irecu cabu. ");
INSERT INTO bon_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Baborage uli pargi liba pisi nyene määme irecu cabu, maane miiji lica gäte määme biname ne jaji egä, ‘Cane määme irecu cabu ca pläpu ne jaacatene.’ ");
INSERT INTO bon_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Maane walya biname gäte! Maane miiji niinäce uli pargi ne määme irecu cabu ca acata, piba maane cängenarage jepänenite määme biname me irecu cabu ca pläpu ne acatame. ");
INSERT INTO bon_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lui gwidape ne mara me ituge wawena Acejiyame tääpume, weene drego bine gone yääcärimuye, teepi cije tatatrongärininusi weeme bau me, tuusasemalininusi. Piiyepu cuta weeme kusa bine gone yiisabimuye blome bime bau me, teepi cije jääbrecäjemusi.” ");
INSERT INTO bon_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Itinäreye, piba pagege weebibine ceera: jirngeye, weene piba pagege päpäna; eyäjeye, piba pagege weeme tääpume iitnana. ");
INSERT INTO bon_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iyeta lui cina yäätinärusi, teebibine yääcärimusi; lui cina jäärngusi, teepi jääpänusi; lui cina yääyäjusi, teeme tääpume jiitnusi. ");
INSERT INTO bon_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bägrä te liba yäätinäruge teeme babe ne deedei tääpume, tabe kula lica yääcäruge. ");
INSERT INTO bon_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Coo tabe bägrä te liba cibu tääpume yäätinäruge, tabe niiyarage cobyame lica yääcäruge. ");
INSERT INTO bon_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Weene puu niiya biname gemi, yepä weene umle gemi miijimiji gwidape weeme bägrä bine ceera. Egäsu nata weeme Babe lui cabucewe je enajenige, tabe cuta piba yääcäranemuge miijimiji gwidape, lui cina teebine yäätinärusi. ");
INSERT INTO bon_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Weene singi biname cina ngena wawename weeme tääpume, weene miiji pepu wawena teeme tääpume. Ai abiberäja lui Moose me Cotre cabu pisi nyene piiyepu Acejiyame me mename biname cina apu ebiberäjimujisi.” ");
INSERT INTO bon_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Weene susurage grana cabu me ebäcneye, ingle lui grana gyene uliobo puupu cabu me, daamle gyene pui grana, piiyepu lui gaabe te ädenige pui grana cabu me plowa gyene, siige bucurage cina piiyeme otneninisi. ");
INSERT INTO bon_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yepä lui grana gyene iyeteta ireclota puupu cabu me, susu gyene pui grana, piiyepu lui gaabe te piiyeme ädenige mäpu gyene, siige nesae taatu cina pui gaabe ne jepänanenisi.” ");
INSERT INTO bon_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Weene ireire inajipi walya mename biname bime tääpume. Teepi weeme bau me saacluge maamoi bime opo pana, yepä teepi teeme ngenecu bora agliyame wulp pana birige. ");
INSERT INTO bon_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Weene lipu uli ne opo yaawatnuye teeme kuu cabu ca, weene cuta teebibine pepu opo yaawatnimuye teeme mule cabu ca. Pägepäge seeasea cina waina kuu lica yääyemuge, cuta gargale cina lica piigi kuu yääyemuge. ");
INSERT INTO bon_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Miijirage uli lui miijimiji kuu yääyuge; niiyarage uli lui niiyaniya kuu yääyuge. ");
INSERT INTO bon_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Miijirage uli te äblicäco niiyarage kuu äyi; niiyarage uli te äblicäco miijirage kuu äyi. ");
INSERT INTO bon_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iyeta uli lui cina niiyaniya kuu yääyemuge, yaargawimusi, uliobo cabu yiisabimusi. ");
INSERT INTO bon_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yoo, weene walya mename biname bine cuta teeme mule cabu ca opo yaawatnimuye.” ");
INSERT INTO bon_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Iyeta lui cina najananusi egä, ‘Yageyame, Yageyame,’ teepi iyeteta ireclota ne lica cirege päpäna Acejiyame cama cabucewe je, yepä eei taatu cina cirege päpäna, lui cina jaawenimusi cäme Babe cabucewe je ngena tääpume singi. ");
INSERT INTO bon_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Atrana bimu liba cirege, piba bucurage cina cire najanepesi egä, ‘Yageyame, Yageyame, cine nata määme ngii cabu Acejiyame me tagepogogo mene jaajananemusi, cuta määme ngii cabu niiyaniya cable bine yääyecräjemusi piiyepu bucurage ciitaca mule bine jaawenanemusi.’ ");
INSERT INTO bon_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Puma cita ca cane pui biname bine cire jaajemepene egä, ‘Cane umle cäco gäne weene. Weene niiya mule biname gemi, äyeblengäjineye cäme bau ca.’” ");
INSERT INTO bon_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iyeta biname lui cina yäätecijemuge cäme ai mene, siige pui mene ibi jaawenimusi, teepi umle biname pana birige, lui te mete ne kula papa cabu erangige. ");
INSERT INTO bon_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tabe lui mete ne erangige, siige ngupe te piba secirige, igi cama tädige, cuta babo buuwe te tipwäjige, yepä mete te lica itramige, ingle kula papa cabu jage. ");
INSERT INTO bon_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Iyeta biname lui cina yäätecijemuge cäme ai mene, yepä pui mene ibi lica jaawenimusi, teepi buduma biname pana birige, lui te mete ne koriyo papa cabu je erangige. ");
INSERT INTO bon_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngupe te secirige, igi cama tädige, babo buuwe te tipwäjige, siige pui mete te iyeta peega ecirige.” ");
INSERT INTO bon_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeesu liba teeme ai mene iicema epirige, biname cina mutäcäco ge teeme abiberäja mene name pi, ");
INSERT INTO bon_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ingle teeme abiberäja mene epu lica ge cotre abiberäja biname bime liiyepu. Pätä tabe epu ebiberäjimige, lui biname me conocäco pisi nyene biname bine jajime teepi ngena wawename. ");
INSERT INTO bon_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yeesu liba täinige podo cabu ca, bucurage biname cina teebine ingwe sicwisi. ");
INSERT INTO bon_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Piba yepä lepera pita biname te tädige teeme bau me, kokorare ca ääpednutige teeme opo gaabe je, jejige egä, “Babo biname, maane liba singi gäte, maane miiji gäte cebine pita cäco me wawena.” ");
INSERT INTO bon_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu ime uutige teeme bau me, joomlige, jejige egä, “Yoo, cane singi gäne. Maane pita cäco äbiti!” Piba taatu tabe miiji me äbitige teeme lepera pita cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeesu puma cita ca teebine jejige egä, “Maane näätecijege, gone nuuja biname bine umle jaawenimute, cane lipu meebine miiji naawenine. Yepä maane conocäco ädi iiwäreja biname bau me, tabe te määme tääpe pa naawatnäjepi. Moose lui owecu gwidape jiicuji Acejiyame ne iiwärejame, maane piba pui ecärepi teebine tabe iiwärejame. Biname cina piba umle pa läbitipesi, egä maane miiji gäte.” ");
INSERT INTO bon_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeesu liba abacitige Kaprenauma cewe me, cubu mope biname, lui te Israela biname lica ge, piba tädige teeme bau me, itemlige teebine ätityerame. ");
INSERT INTO bon_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tabe Yeesu ne apu jejige egä, “Babo biname, cäme kaakesea bägrä te ätwitäneji enajenige mete cabu. Tabe pita name pi naabe cewe oocaninige, äblicäco ge arpinenta.” ");
INSERT INTO bon_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu jejige egä “Cane tädenine teebine miiji wawename.” ");
INSERT INTO bon_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yepä tabe pui cubu mope biname te jejige egä, “Oo babo biname, cane nuuja miiji lica gäne! Cäme mete me gone tädute. Maane yepä mene taatu jiicepi cäme kaakesea bägrä te miiji äbitame. ");
INSERT INTO bon_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Cäme cuta piti nemi niinäce gaabe biname piiyepu ingwe gaabe biname. Cane liba cäme ingwe gaabe biname ne jaajune egä, ‘Ädi,’ tabe läduge. Nuuja ne liba jaajune egä, ‘Tädi,’ tabe täduge. Cuta piiyepu cane liba cäme kaakesea bägrä ne jaajune ngena wawename, tabe jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yeesu liba teeme mene jitecijige, tabe mutäcäco äbitige, siige teeme ingwe äcwiyame biname bine jejemige egä, “Toraca gyene, cane nuuja Israela biname ne apu ätrunga cama lica ituge päpäna. ");
INSERT INTO bon_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cane weebibine jijenininine: bucurage cina cire saaclepi bimu acita gome ca piiyepu bimu äpula gome ca, siige cire ladnatärepi Abrahamo, Isacako, Yakobu cama cabucewe je Acejiyame me soriyomu cabu. ");
INSERT INTO bon_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yepä lui cina miiji cirege pui soriyomu cabu äbäcna, teebibine cire yiisabemepesi krokeciiye cabu me. Teepi puma ele cire yaangenetnemepi, giricu cire yaatebecmepesi.” ");
INSERT INTO bon_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Siige puma cita ca Yeesu pui cubu mope biname ne jejige egä, “Äte, acnenuti mete me. Maane ngena ne jitrungenite, peei te läbitege.” Siige teeme kaakesea bägrä te puirage padare cabu miiji äbitige. ");
INSERT INTO bon_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeesu ädige, Peteru me mete me abacitige. Tabe teeme gite ne puma jopänige gebale cama ätwitäneji. ");
INSERT INTO bon_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeesu teebine ime gome jwoomlige, siige gebale te obmalige. Tabe puma cita ca arpinantige, Yeesu ne mogobi jewenige. ");
INSERT INTO bon_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Liba mämleteca ge, piba biname cina bucurage biname bine sewadanemisi Yeesu bau me, lui bime trupa cabu niiyaniya cable puga ge. Yeesu iyeta cable bine mene ca iyecräjemige piiyepu iyeta pita biname bine miiji me jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tabe ai ne naace popi jewenige mename biname Isaya me mene te toraca me äbitame egä, “Tabe cime pita bine teeme cabu icranige, tabe cime tääpe mäpu bine ewadimige.” ");
INSERT INTO bon_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yeesu liba bucurage biname bine jepänimige teebine awaclomta je, tabe teeme abiberäja bägrä bine jejemige teepi sawa nuuja poto doro me uuraname. ");
INSERT INTO bon_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Teepi ingwe yuurisi, niinäce yepä cotre abiberäja biname te tädige Yeesu bau me, jejige egä, “Abiberäja biname, ngänu gyene, maane liiyeme ädenite, cane määme ingwe ädenine.” ");
INSERT INTO bon_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu jejige egä, “Poks bime bora piti nemi lenaja tääpume piiyepu ele bime mete piti nemi, yepä cane lui te Acejiyame bau ca tädujine biname me äbitujine, cäme tääpume puupu lica gyene cäme mope acitame.” ");
INSERT INTO bon_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Puma cita ca lui biname cina Yeesu ne jitrungisi, teeme yepä te jejige egä, “Babo biname, cane singi gäne meebine ingwe äcwime, yepä cane lipu gäne niinäce otni cäme babe ne gape acitame?” ");
INSERT INTO bon_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu jejige egä, “Laati bemi seemo ireclota cabu budre, teepi te teeme budre biname bine gape cabu me yaacranimusi. Maane cebine ingwe näcwi.” ");
INSERT INTO bon_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeesu poo cabu me acenutige, teeme abiberäja bägrä cina teta cama acetnärige. ");
INSERT INTO bon_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Teepi liba eclige, baborage buuwe te tipwäjige sawa cabu, siige uule kuu cina poo ne itrugärisi. Yepä Yeesu ute ge. ");
INSERT INTO bon_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abiberäja bägrä cina eclige, teebine elotnantisi, jejisi egä, “Yageyame, nitityärini! Mine labumitninago!” ");
INSERT INTO bon_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeesu jejemige egä, “Weene wälu ngeno memi? Weeme ätrunga matikolärage gyene.” Tabe abujängtige, kokre cama buuwe piiyepu uule kuu bine mene jejemige, siige piba bulubulu mataru te enajige. ");
INSERT INTO bon_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abiberäja bägrä cina mutäcäco äbitininisi, jiicisi egä, “Ai biname Laasi nyene? Buuwe piiyepu uule cina teeme mene jitecijisi.” ");
INSERT INTO bon_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeesu sawa nuuja poto doro me yuurige, atyaramtige Gadara gawe cabu me, siige neeneni rooriye cina tewacletnäjäsi teebine puma. Kula waja cabu lui gape gemi, teepi pui cabu ca tasatäsi. Teeme trupa ngalebora puga ge niiyarage cable. Teepi mage girigale ge, peei name pi nuuja biname te singi lica ge pui gaabe cabu otnime, teepi luma aanajenanige. ");
INSERT INTO bon_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Siige teepi liba Yeesu ne jepänäsi, ala abayäsi egä, “Acejiyame me Bägrä, maane singi ngena wawename cime tääpume? Maane watrangeca je tädite cibibine sabe wawename.” ");
INSERT INTO bon_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Seeji cudecewe padare puga ge baborage ngeerangera blome tomi, deedei tääpume yuunguretnäjimisi. ");
INSERT INTO bon_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Puma cita ca cable cina Yeesu ne jejisi egä, “Maane liba singi gäte cibibine äyecrejame, nityepini blome bime trupa cabu me.” ");
INSERT INTO bon_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yeesu jejemige egä, “Yoo, naaclege!” Siige teepi aabmalisi pui neeneni biname bine, eclige, blome bime trupa cabu me ebäcnisi. Iyeta blome tomi te podo cabu ca uuwamitnige gawe me, sawa cabu me uupletnärige, siige abumitnige. ");
INSERT INTO bon_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Blome ire atwi biname cina uucratnige, eclige babo cewe me. Puma teepi biname bine jebaitnemisi iyeta, ngena cina bäbitininisi niiya cable cama lui neeneni biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Puma cita ca iyeta biname pui babo cewe cabu ca eclige Yeesu ne päpäname, siige liba jepänisi, jejisi teeme gawe ne abmalame. ");
INSERT INTO bon_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeesu poo cabu acenutige, sawa ne yuurige, atyaramtige teeme cewe me. ");
INSERT INTO bon_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Biname cina waaku cabu secanisi tääpe nuuja poto budre biname ne. Yeesu liba jepänimige, egä teepi baborage ätrunga cama gemi, tabe pui pita biname ne jejige egä, “Cäme biname, wälu gone! Maane kälyä gäte määme niiya mule cabu ca!” ");
INSERT INTO bon_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yeesu gome puga ge cotre abiberäja biname. Teepi teemämu jitranisi egä, “Ai biname te Acejiyame me ngii ne sabe jewenige, ingle tabe taatu gyene biname ne kälyä wawename teeme niiya mule cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yepä Yeesu umle äbitige teeme ngene atwanena, siige tabe jejemige egä, “Weene ngeno memi niiya ngene atwanena cama? ");
INSERT INTO bon_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lui gyene plowa iicana ai pita biname ne jajime egä, ‘Maane kälyä gäte määme niiya mule cabu ca,’ coo ‘Arpinanti, abujängti, siige ädi.’ ");
INSERT INTO bon_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yoo siige, cane lui Acejiyame bau ca tädujine biname me äbitujine, cane lui gwidape jewenenine, weene pui cabu ca opo nawatniniye, egä cäme conocäco pisi nyene biname ne kälyä wawename teeme niiya mule cabu ca.” Siige puma cita ca tabe pui tääpe nuuja poto budre biname ne jejige egä, “Arpinanti, abujängti, määme waaku ne ecati, mete me ädi!” ");
INSERT INTO bon_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Puma cita ca pita biname te arpinantige, mete me ädige. ");
INSERT INTO bon_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lui biname cina jepänisi, teepi cälu te jitemige, Acejiyame ne eso ecärisi, tabe biname bine lipu kokre ituge ceera. ");
INSERT INTO bon_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeesu pui cewe ne sebmalige. Tabe liba ädige, tabe täks rarekaake uutecrena biname ngii Matayo ne jepänige. Tabe adnatäneji enajige teeme kaakesea mete cabu, siige Yeesu teebine jejige egä, “Tädi cane cama otnime.” Matayo abujängtige, teta cama ädige. ");
INSERT INTO bon_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ingwe ca Yeesu liba deedei äbitige Matayo me mete cabu, bucurage täks rarekaake uutecrena biname piiyepu cotre atropengäja biname teepi seclige deedei äbitame Yeesu piiyepu teeme abiberäja bägrä cama. ");
INSERT INTO bon_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisea sigu biname cina liba jepänisi Yeesu teta cama deedei äbita je, teepi teeme abiberäja bägrä bine jejemisi egä, “Weeme abiberäja biname te lipulipu deedei äbitenige täks rarekaake uutecrena biname piiyepu cotre atropengäja biname cama?” ");
INSERT INTO bon_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeesu jitecijemige, jejemige egä, “Lui biname cina miiji birige, teepi dokta tääpume singi lica, yepä lui cina pita cama birige, teepi singi dokta tääpume. ");
INSERT INTO bon_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Weene miiji umle äbitineye, ai mene ngena tääpume myene egä, ‘Cane singi lica gäne biname cina cebine iiwärejame, yepä cane singi gäne teepi nuuja biname bine owecu wawenecame.’ Cane lica tädujine ala asoglecame lui cina apu jaangemuge, egä teepi conocäco biname gemi, yepä cane conocono biname bine ala asoglecame tädujine.” ");
INSERT INTO bon_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yoane niiye ca äciseja biname me abiberäja bägrä cina seclige Yeesu bau me, itemlisi egä, “Ai lipu gyene, egä cine piiyepu Parisea sigu biname jäje deedei ärwäja cäco ninajininuge Acejiyame ne awejename, yepä määme abiberäja bägrä cina umle cäco gemi pipu äbita?” ");
INSERT INTO bon_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu jejemige egä, “Atejäclmuta soriyomu ne liba yaaclitusi, biname cina owecumete opo lica birige, mamye rooriye te liba teta cama pisi nyene. Yepä, padare te cire tädepi liba mamye rooriye ne cire yaacatepesi, teepi piba cire yaacrajemepi deedei ärwäja cäco.” ");
INSERT INTO bon_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nuuja te kirece äciseja cäco cäbletääpe pläsu ne sasa cäbletääpe bora cabu lica yääswäruge. Tabe liba pepu jaawenuge, siige cäbletääpe ne liba jääcisäjuge, pui kirece cäbletääpe pläsu te lacalomluge, siige sasa cäbletääpe ne jääsegläruge. Puma cita ca kirece pläsu te läwälutuge sasa cäbletääpe cabu ca, siige bora te babo läbituge. ");
INSERT INTO bon_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Piiyepu nuuja te kirece waina niiye ne lica yaapaduruge gouti tääpe ca wawenäneji sasa ängära gwidape cabu. Tabe liba yaapaduruge, kirece waina niiye te pui sasa ängära gwidape ne yääpluge, ingle tuutnecuge. Siige waina niiye te lapaduruge gawe me piiyepu ängära gwidape te sabe läbituge. Kirece waina niiye ne miiji kirece gwidape cabu ängära, piba teepi ibibi laanajuge.” ");
INSERT INTO bon_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeesu liba camu mene iicema cabu jage, piba yepä Israela babo biname te teeme bau me tädige. Tabe kokorare ca ääpednutige teeme opo gaabe, jejige egä, “Cäme ngulebägrä budre bäbitige page ai padare cabu. Maane tädi ime acitame teeme papa cabu, tabe piba budre cabu ca arpinantenige.” ");
INSERT INTO bon_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yeesu abujängtige, teebine ingwe icwige teeme abiberäja bägrä cama. ");
INSERT INTO bon_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Teepi liba eclige, Yeesu me kaake poto ca yepä magebi te piba toclige, lui twelb kämäge ngalebora uudi apira pita cama tonajenäjumi. Tabe Yeesu me cäbletääpe pepyämu ne joomlige ogä, ");
INSERT INTO bon_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ingle tabe ngene jotwananige egä, “Cane liba Yeesu me cäbletääpe pepyämu taatu joomlenine, cäme ai pita te piba nabma-lenige cebine.” ");
INSERT INTO bon_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yoo siige, tabe liba joomlige, Yeesu piba tatatrongtige, teebine jopänige, jojige egä, “Bägrä, wälu gone! Määme ätrunga te meebine miiji bii naawenige.” Siige peeirage padare cabu magebi te miiji äbitige. ");
INSERT INTO bon_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Puma cita ca Yeesu liba pui babo biname me mete cabu me atyaramtige, lui me bägrä te budre äbitige, tabe jepänige, biname cina dobidobi bine jecnäjimisi piiyepu papa me äbitininisi bägrä me budre name pi. ");
INSERT INTO bon_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tabe jejemige egä, “Pääye, äyeblengäjineye ama cita ca. Bägrä te budre lica gwene, tabe ute gwene.” Teepi teebine ngange ecwänisi. ");
INSERT INTO bon_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Puma cita ca biname bine liba iyecräjemisi mete cabu ca, Yeesu piba abacitige bägrä me ute puupu cabu me, ime jwoomlige, siige bägrä budre cabu ca arpinantige. ");
INSERT INTO bon_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Teepi idre ecenanisi iyeta pui gawe cabu, egä Yeesu ngena mule ne jewenige. ");
INSERT INTO bon_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeesu pui cewe ne sebmalige. Tabe liba ädige, neeneni irecu määsumäsu biname cina teebine ingwe icwäsi. Teepi ala abayäsi egä, “Daawida me kaakesaare, maane owecu cime tääpume!” ");
INSERT INTO bon_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yeesu liba mete bora me abacitige, pui neeneni irecu määsumäsu biname cina piba taaclige teeme bau me. Yeesu äätemlige egä, “Weene nää toraca nätrungeniye, egä cane miiji gäne weebibine irecu miiji wawename?” Teepi jejäsi egä, “Yoo, babo biname.” ");
INSERT INTO bon_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Puma cita ca Yeesu teeme irecu papa cabu ime bine aacitige, jaajige egä, “Weeme ätrunga te ibibi läbitege.” ");
INSERT INTO bon_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Siige teeme irecu cina aasatäsi. Puma cita ca Yeesu kokre cama mene jaajige egä, “Gone biname bine ai poto cidi me umle jaawenimuye.” ");
INSERT INTO bon_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yepä teepi mete ne sebmaläsi, aaclige, Yeesu ne idre jecanenäsi iyeta pui gawe cabu ta. ");
INSERT INTO bon_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pui neeneni biname cina liba baaclige, piba biname cina Yeesu bau me secanisi mene iicema cäco biname ne, lui me trupa cabu puga ge niiya cable. ");
INSERT INTO bon_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yepä Yeesu liba niiya cable ne iyecräjige, pui biname te piba taatu gije abacitige mene iicemame. Biname cina mutäcäco äbitininisi, jiicisi egä, “Cine niinäce lica ituge Israela gawe cabu apu mule ne päpäna.” ");
INSERT INTO bon_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yepä Parisea sigu biname cina jiicisi egä, “Niiya cable bime mopeyame te Yeesu ne kokre yääcäruge tabe niiya cable bine äyecrejame.” ");
INSERT INTO bon_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeesu puma cita ca otnetnäjige iyeta modamoda piiyepu matimati cewe cabu ta. Tabe biname bine ebiberäjimige teeme abasecretna mete cabu ta piiyepu Miiji Mene jejananemige egä, “Acejiyame te pagege biname bine waadena.” Tabe cuta biname bine miiji jewenanemige iyeta maramara pita cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tabe liba bucurage biname tomi bine jepänimige, tabe owecu äbitige, ingle teepi mage ngenecu mäpu cama ge piiyepu ätityera tääpume singi ge epu pana maamoi, lui bime ire atwi biname lica ge. ");
INSERT INTO bon_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yeesu puma cita ca teeme abiberäja bägrä bine jejemige egä, “Ärucna lui baborage gyene, yepä nesae taatu kaakesea bägrä gemi atomle-came, ");
INSERT INTO bon_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","peei name pi weene miiji irecu ätumutame ärucna Yageyame bau me tabe poto kaakesea bägrä bine ätyepame teeme ärucna tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeesu teeme twelb abiberäja bägrä bine ala tesoglicmige, ecärimige kokre niiyarage cable bine äyecrejame piiyepu iyeta maramara pita bine äyeblengäjame. ");
INSERT INTO bon_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Age tema pui twelb ätyepäneji biname bime ngii: niinäceyame lui Simona, lui ne einenisi Peteru ca, piiyepu teeme igane Andrea; cuta Yakobu teeme igane Yoane lui Jebedayo me bägrä gegi; ");
INSERT INTO bon_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","cuta Pilipo naabi Bartoloma; Tooma piiyepu täks rarekaake uutecra biname ngii Matayo; cuta Yakobu Alaba me bägrä piiyepu Tadeus; ");
INSERT INTO bon_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","cuta Simona lui Kanana sigu biname gyene piiyepu Yuuda Isakariyota lui Yeesu ne budre tääpume awaba biname gyene. ");
INSERT INTO bon_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeesu ai twelb biname bine apu umle mene cama jityepimige kaakesea wawename egä, “Gone biname bime bau me naacluge lui Israela biname lica gemi. Cuta gone naacluge nuuja cewe cabu me Samariya gawe cabu je. ");
INSERT INTO bon_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yepä weene Israela biname bime bau me naacluge, lui cina epu pana gemi apeseräjäneji maamoi cina liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Weene teebibine jejananemepeye egä, ‘Acejiyame te mameta gyene biname bine waadena.’ ");
INSERT INTO bon_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Weene pita biname bine miiji jewenemepeye, budre biname bine erpineräjemepeye, lepera pita biname bine miiji jewenemepeye piiyepu niiyaniya cable bine iyecräjemepeye. Weene kokre ne daremu cäco ituge acata ai mule bine wawenecame, peei name pi weene miiji daremu cäco cuta biname bine itityeräjemepeye. ");
INSERT INTO bon_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Weene gone gol, silba piiyepu rarekaake bine yaawadimuye weene cama. ");
INSERT INTO bon_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gone diiba yaawadimuye, coo tuwängle cäbletääpe piiyepu ernge gwidape coo piiyepu otnetneja suru, ingle kaakesea bägrä ne miiji teeme singi gwidape ceera. ");
INSERT INTO bon_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Weene liba lui babo cewe cabu me coo piiyepu matikolä cewe cabu me latyarininuye, weene miiji ärngi, egä laati te singi weebibine teeme mete cabu me äbäcname, siige weene teta cama inajininuge, ngälu weene peei cewe ne saabmaluye. ");
INSERT INTO bon_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Weene liba mete cabu me yääbäcnuye, jiicuye egä, ‘Poode!’ ");
INSERT INTO bon_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pui mete cabu biname cina liba weebibine jiwablininusi, weeme poode te miiji yaanajuge puma. Yepä teepi liba lica jiwablininusi, weeme poode te lacnenutuge weeme bau me. ");
INSERT INTO bon_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Poto mete coo piiyepu cewe cabu ta liba weebibine lica jiwablininusi coo weeme mene lica jitecijinusi, weeme ernge cabu ca teeme tuuwe bine jääglubäjemuye, siige saabmaluye pui mete ne coo cewe ne. ");
INSERT INTO bon_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cane toraca jijenininine, Acejiyame me atrana bimu cabu Sodoma piiyepu Gomora cewe biname cina lui niiyarage daremu ne cirege päpäna, matikäli cirege. Lui cewe biname cina lica pa jiwablipesi weebibine, teeme niiya daremu lui baborage cirege.” ");
INSERT INTO bon_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Cane weebibine jityepininine biname bime bau me, epu pana maamoi cina lipu yaacluge wulp bime sigu cabu me. Weene miiji cobyame bime pana umleumle inajipi piiyepu gimäe bime pana niiya wawena cäco inajipi. ");
INSERT INTO bon_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Weene ireire inajipi, ingle biname peeci nemi, lui cina weebibine joomlinininusi ablaweja mete me waadename. Piiyepu teepi teeme abasecretna mete bora ta weebibine itemeläjininusi. ");
INSERT INTO bon_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Teepi cämiji pi iwadininusi modamoda biname bime piiyepu gawe mope biname bime opo gaabe me weene teebibine piiyepu gawe maramara biname bine Miiji Mene jajanename. ");
INSERT INTO bon_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yoo, weebibine liba ablaweja tääpume iwadininusi, ngenecu niiya gone, egä weene ngena jiicuye coo lipulipu jiicuye. Liba padare te tatyaramtuge weene mene iicemame, weebibine piba mene birige ceera iicema tääpume. ");
INSERT INTO bon_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Weene lui mene cire jiicemepeye, peei lui weeme mene lica cirege, yepä weeme Babe me Seemo te ngene atwanena cire icäripi weene ngena iicaname. ");
INSERT INTO bon_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Poto biname cina teeme naniganewale bine budre me cirege äyemela. Babe cina peeirage mule cire jaawenepesi teeme bägrä bime tääpume. Cuta bägrä cina cire latatrongäripesi teeme mage babe bine budre me äyemelame. ");
INSERT INTO bon_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Iyeta biname cina weebibine jimugitninusi cäme singi pi, yepä laati te kokre cama cire jaaclajutepi ngälu ngälugaabe me, tabe iyeteta ireclota ne cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Teepi liba yepä cewe cabu weeme tääpume claabe läbitininusi, weene miiji nuuja cewe me uucratna. Cane toraca jijenininine, weene cäro camu Miiji Mene jajanena ne cire epirepeye Israela modamoda cewe cabu ta, cane Acejiyame bau ca lui te tädujine biname me äbitujine, niinäce cire tacnenutepene. ");
INSERT INTO bon_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Abiberäja bägrä te baborage lica birige teeme abiberäja biname bau ca, coo piiyepu aletnäneji biname te baborage lica birige teeme babo biname bau ca. ");
INSERT INTO bon_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pipu pi abiberäja bägrä te bojä jaaguge, tabe liba teeme abiberäja biname cama ibibi läbituge. Cuta aletnäneji biname te bojä jaaguge, tabe liba teeme babo biname cama ibibi läbituge. Yoo, biname cina liba cebine, lui weeme mope biname gäne, nainusi Beelsebul ca, siige piba teepi weebibine, lui cina cäme ingle biname gemi, cuta mage niiyaniya ngii ca iyinininusi.” ");
INSERT INTO bon_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Yoo, weene biname bime tääpume wälu gone! Ngena gyene ämlitäneji, pagege pajecu me äbita. Ngena gemi ogä, pagege awabudnäja. ");
INSERT INTO bon_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cane krokeciiye cabu ngena tääpume jijenininine, weene miiji bimu cabu cääri jajanena; weene siiyä mene ca ngena itecijenininige, weene miiji cabucabu pagege jajanena, epu pana mete toro cabu ca lipu mene tiicemusi. ");
INSERT INTO bon_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wälu gone eei bime tääpume, tääpe ne lui cina budre me yaaglusi, yepä teepi äblicäco seemo ne budre me agli. Pätä miiji weene Acejiyame tääpume wälu, ingle tabe miiji gyene tääpe piiyepu seemo bine niiya puupu cabu me acraname. ");
INSERT INTO bon_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Puu matimati ele cina papa gemi: yepä rarekaake ca neeneni bine jaaletnusi, yepä teeme yepä te lica gawe cabu me saatramuge weeme Babe me umle cäco. ");
INSERT INTO bon_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cuta weene piiyepu, Acejiyame iyeta umle gyene weeme poto cidi me. Tabe umle gyene, egä weeme lija matimati edingäli gemi. ");
INSERT INTO bon_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Peei name pi weene gone wälu! Weene modamoda gemi, ele cina matimati gemi.” ");
INSERT INTO bon_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Laati te biname bime sobe cabu naitnuge, egä tabe umle gyene cane, cane cuta teebine cabucewe je cäme Babe me opo gaabe je cire jaaitnepene. ");
INSERT INTO bon_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yepä laati te biname bime sobe cabu nainuge, egä tabe umle lica gyene cane, cane cuta teebine cabucewe je cäme Babe me opo gaabe je cire jaainepene.” ");
INSERT INTO bon_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Weene gone apu angi, egä cane itu tädujine ai gawecewe cabu me poode ne acaname. Cane lica itu tädujine poode ne acaname yepä cubuturikä ne secanujine. ");
INSERT INTO bon_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Imäbägrä te teeme babe bau me claabe läbituge cämiji pi piiyepu ngulebägrä te teeme mage bau me, cuta cnaatete cina teemeteme claabe läbitininusi cämiji pi. ");
INSERT INTO bon_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Biname me binamewale cina cirege teeme cubuyame me äbita cämiji pi. ");
INSERT INTO bon_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Lui te baborage singi birige teeme mage babe tääpume, yepä matikäli singi cäme tääpume, tabe ibibi lica gyene cäme abiberäja bägrä me lenajame. Coo lui te teeme bägrä bime tääpume baborage singi birige, yepä cäme tääpume matikäli singi, pipu biname te cuta ibibi lica gyene cäme abiberäja bägrä me lenajame. ");
INSERT INTO bon_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Laati te liba teeme baarge uli ne palace cabu lica yaacanuge cäme pana, siige cebine ingwe näcwuge, tabe ibibi lica gyene cäme abiberäja bägrä me lenajame. ");
INSERT INTO bon_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Laati te singi lica gyene teeme ireclota ne mäpu cabu acitame cämiji pi, tabe toraca ireclota ne cire yaapesarepi. Yepä lui te singi gyene cämiji pi teeme ireclota ne mäpu cabu acitame, tabe toraca ireclota ne cire jääpänepi.” ");
INSERT INTO bon_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Laati te liba weebibine jiwablininuge, tabe cebine nawabluge. Piiyepu laati te liba cebine nawabluge, tabe cuta jaawabluge teebine, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Laati te liba Acejiyame me mename biname ne jaawabluge teeme peei ngii name pi, tabe mename biname bime pana daremu ne cire jääpänepi. Laati te liba conocäco biname ne jaawabluge teeme peei ngii name pi, tabe teeme pana daremu ne cire jääpänepi. ");
INSERT INTO bon_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Piiyepu laati te liba ai ngii cäco biname yepä ne gwidape yääcäruge, ngänu gyene puu gäbu niiye, ingle tabe cäme ingwe äcwi biname gyene, Acejiyame te teebine daremu cire yääcärepi.” ");
INSERT INTO bon_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeesu liba teeme twelb abiberäja bägrä bine umle mene jajanena ne epirige, tabe pui cewe ne piba sebmalige, ädige poto mametamameta cewe me biname bine puma abiberäjame piiyepu mene jajanename. ");
INSERT INTO bon_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoane niiye ca äciseja biname lui krokeciiye mete cabu jage, tabe puga itecijige, egä Keriso ngena jewenige. Puma cita ca Yoane teeme abiberäja bägrä bine jityepimige Yeesu bau me. ");
INSERT INTO bon_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Teepi Yeesu ne itemlisi egä, “Nää, maane säte pui biname, iyeta biname cina lui ne jewagrijenisi otnime, coo cine miiji nuuja ne awagrija?” ");
INSERT INTO bon_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu jejemige egä, “Weene Yoane bau me acnenuteye, teebine jejepeye, weene ngena jepänanemeniye piiyepu ngena itecijanininige: ");
INSERT INTO bon_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","naace irecu määsumäsu biname cina cängena jääpänanemusi, ernge niiyaniya biname cina miiji waatninusi, lepera pita biname cina miiji läbitininusi, tablame budubuduma biname cina cängena yäätecijanimuge, budre biname cina larpineräjininusi, cuta owecumete biname bine Miiji Mene jaajananemusi. ");
INSERT INTO bon_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngenecu miiji eei gemi, laati bemi ätrunga ne lica yaapesarusi cäme bau.” ");
INSERT INTO bon_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Puma cita ca Yoane me abiberäja bägrä cina liba äcnärige, Yeesu piba gije abacitige biname bine jajanename Yoane poto cidi me egä, “Weene liba Yoane bau me läsipeye daapo taatu cewe cabu me, weene teebine lipu jääpänepeye? Weene baace ingle pana biname ne lica jääpänepeye, buuwe te lui ne yaajodnäjepi. ");
INSERT INTO bon_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cuta piiyepu weene cängena abasogäräneji biname ne lica jääpänepeye, teeme bau me liba läsipeye, ingle abasogäräneji biname cina gawe mope biname bime mete cabu yaacrajuge. ");
INSERT INTO bon_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Najeye, weene Yoane ne lipu jääpänepeye, weene liba teeme bau me läsipeye? Weene nää Acejiyame me mename biname ne jääpänepeye? Toraca gyene, yepä Yoane lui baborage gyene iyeta poto Acejiyame me mename biname bime bau ca. ");
INSERT INTO bon_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoane pui gyene, Oogäräneji mene te lui poto cidi me jiicenige egä, ‘Cane Acejiyame cäme mename biname ne määme niinäce gaabe me cire jäätyepepene. Tabe te gaabe cire yaamacetnäjepi määme otni tääpume.’ ");
INSERT INTO bon_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cane toraca jijenininine, egä Yoane lui baborage gyene iyeta biname bime cabu ca, lui cina ituge ai gawecewe cabu lenaja ngälu Yoane me padare oomlaname. Yepä page ai kirece padare cabu eei cabu ca lui te matikäli gyene, Acejiyame te lui bine ewadenemige, tabe baborage gyene Yoane cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pui padare cabu ca, Yoane niiye ca äciseja biname te liba bäärmi jaagednemepi, ngälu airage bimu cabu Acejiyame me waadena mule te kokre cama ituge otni. Piiyepu biname piti nemi lui cina kokre läbitininusi Acejiyame me waadena mule cabu me äbäcname. ");
INSERT INTO bon_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moose teeme Cotre cabu piiyepu iyeta Acejiyame me mename biname cina ngälu Yoane me padare oomlaname, teepi niinäce gaabe me jiicemujisi, egä Acejiyame te biname bine cire yaawademepi. ");
INSERT INTO bon_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Weene liba singi teeme mene ätrungame, weene miiji umle äbita, egä Yoane lui Eliya sine, lui me otni poto cidi me teepi niinäce gaabe me jiicemujisi. ");
INSERT INTO bon_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Weene liba tablame piti nemi ätecijame, itecijinege umle äbitame. ");
INSERT INTO bon_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Cane ngena cabu yaatonäremene biname bine, page lui cina ireclota gemi? Teepi epu pana gemi matimati bägrä, lui cina adnatäreji yaacrajuge aletna puupu cabu, siige teemeteme ala labayaninusi egä, ");
INSERT INTO bon_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Cine dobidobi jääcnäjimusi, yepä weene giire lica jääwäjuye. Cine owecumete uupera yaatangusi, yepä weene singi lica ele me.’ ");
INSERT INTO bon_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yoo, Yoane te tädepi. Tabe deedei cäco yaanajepi piiyepu waina niiye lica yäänäjemepi. Yepä biname cina singi lica teeme mule tääpume, siige jiicusi egä, ‘Yoane me niiya cable pisi nyene.’ ");
INSERT INTO bon_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane yäärwäjune, yäänäjune, yepä biname cina cuta singi lica ge cäme mule tääpume, siige teepi jiicusi egä, ‘Jepäneye ai biname ne, mage looloyame gyene piiyepu waina niiye änäjäyame gyene. Tabe täks rarekaake uutecrena biname piiyepu cotre atropengäja biname bime biname gyene.’ Mine liba jääpänusi, egä Acejiyame bau ca lui mule te ngena jaawenuge, mine peei cabu ca opo yaawatnusi, egä Acejiyame me umle toraca gyene.” ");
INSERT INTO bon_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeesu gije abacitige cewe biname bine ablawejame, lui cina lica ituge atatrongära teeme niiya mule cabu ca, ngänuge tabe bucurage ciitaca mule bine itu jaawenanemepi puma. ");
INSERT INTO bon_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Tabe jejemige egä, “Oo Korasine piiyepu Betesaida cewe biname, lipu babo niiyarage cirege weeme tääpume! Cane lui ciitaca mule bine ituge weeme cabu wawena, liga cire jaawenemejine Turo piiyepu Sidona cewe cabu, biname cina puma ragre cire lasigrärinejisi piiyepu mriibe ca cire lapyacinejisi awabame, egä teepi teeme niiyaniya mule bine ituge abmaläcema Acejiyame bau me atatrongärame. ");
INSERT INTO bon_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Korasine piiyepu Betesaida cewe biname, cane weebibine jijenininine, egä Acejiyame me atrana bimu cabu Turo piiyepu Sidona cewe biname cina teepi plowa cire jääpänepesi weeme cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Cuta weene Kaprenauma cewe biname! Weene nää apu jingenininige, egä weebibine awepenta cabu me Acejiyame bau me? Eewe, weebibine niiyarage puupu cabu me cire iyäripesi. Sodoma cewe biname cina liga cire jääpänemejisi ciitaca mule bine, weene lui bine ituge päpäna, pui cewe te page cerämu cire yaanajeji. ");
INSERT INTO bon_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaprenauma cewe biname, cane jijenininine weebibine, egä Acejiyame me atrana bimu cabu Sodoma cewe biname plowa cire jääpänepesi weeme cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Peei padare cabu Yeesu jiicige egä, “Babe, maane lui Yageyame gäte gawecewe piiyepu cabucewe tääpume, cane meebine eso nääcärenine, egä maane ai gwidape bine ituge ämletna umle biname piiyepu miijimiji mopemuli biname bime bau ca, siige abiberäja cäco biname bime bau me ituge aboclomäja. ");
INSERT INTO bon_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Babe, ai lui määme miijirage singi gyene. ");
INSERT INTO bon_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cäme Babe te iyeta gwidape bine itu saabmalemepi cäme ime cabu. Nuuja te umle lica gyene Bägrä, yepä Babe taatu umle gyene; cuta nuuja te umle lica gyene Babe, yepä Bägrä taatu umle gyene piiyepu eei biname cina umle gemi Babe, Bägrä te lui bime tääpume singi aboclomta teebine. ");
INSERT INTO bon_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Naaclepi cäme bau me, lui cina gloose gemi mäpu biijabija bine waadename. Cane weebibine diibe oocana pa icäripene. ");
INSERT INTO bon_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gone jäägyemuye lui mäpu bine jääpänimuye cämiji pi piiyepu cäme bau ca labiberäjininuye, ingle cane owelaamelame biname gäne piiyepu cane awepyeräja umle cäco gäne, siige weene piba poode ne pa jepänepeye. ");
INSERT INTO bon_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Cämiji pi lui mäpu bine jääpänimuye, plowa birige, piiyepu cane ngena bine liba yaacranimune weeme cabu, mäpu lica birige.” ");
INSERT INTO bon_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pui padare yepä Sabade bimu cabu Yeesu teeme abiberäja bägrä cama wiiti calwacupi ngalebora lui gaabe cabu ädige. Abiberäja bägrä loolomecewe te joomlemige. Teepi puma cita ca wiiti mope bine ecrecimisi, kuu bine erwäjimisi. ");
INSERT INTO bon_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisea sigu biname cina jepänimisi, teepi ngena jewenisi, siige Yeesu ne jejisi egä, “Jepänimi! Määme abiberäja bägrä cina mime Sabade cotre ne bii jetropangtisi, teepi lui mule becnisi.” ");
INSERT INTO bon_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeesu jejemige egä, “Egäsu weene ituge acnema, mope biname Daawida lui mule ne jewenuji, tabe piiyepu teta cama lui biname teepi liba loolo me icrajuji, yepä teeme deedei lica. ");
INSERT INTO bon_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tabe iiwäreja mete cabu me abacituji, buluduu ne sisatuji, buluduu lui Acejiyame tääpume acitäneji ge, siige ecäranemuji teta cama lui biname bine, siige teepi erwäjujisi. Teepi pui lui cotre ne jetropangtujisi, ingle iiwäreja biname taatu cina miiji gemi pui buluduu ne loolo. ");
INSERT INTO bon_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Egäsu weene cuta Moose me Cotre mene cabu ituge acnema, egä iiwäreja biname cina Sabade bimu cabu miiji yaacluge iiwäreja mete me kaakesea wawename. Teepi cuta pui lui Sabade cotre ne jaatropangtusi, yepä teepi kälyä birige. ");
INSERT INTO bon_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cane jijenininine weebibine: cane säne baborage, iiwäreja mete matikäli gyene. ");
INSERT INTO bon_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Oogäräneji mene te jiicenige egä, ‘Cane singi lica gäne biname cina cebine iiwärejame, yepä cane singi gäne teepi biname bine owecu wawename.’ Weene liga toraca umle cirege, egä ai mene ngeno myene, weene piba lica cire jaatranemejiye, lui biname cina niiya mule bine lica jaawenimusi. ");
INSERT INTO bon_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Acejiyame bau ca lui te täduji biname me äbituji, teeme conocäco pisi nyene jajime Sabade bimu cabu ngena wawename.” ");
INSERT INTO bon_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeesu pui cewe ne sebmalige, ädige, yepä abasecretna mete cabu me abacitige. ");
INSERT INTO bon_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Biname puga ge, lui me ime duudemu ge. Poto biname puga ge, lui cina singi ge ingle ne päpäname Yeesu ne aitnejame, siige teepi teebine itemlisi egä, “Nää Cotre ibi mule gyene Sabade bimu cabu pita biname ne miiji wawename?” ");
INSERT INTO bon_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeesu jejemige egä, “Weeme yepä me liba maamoi pisi nyene, siige Sabade bimu cabu cupicu bora me yaatramuge, egäsu weene saarpatuye? ");
INSERT INTO bon_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Maamoi matikäli gyene, biname baborage gyene, peei name pi nuuja cotre lica gyene biname tääpume miiji mule wawena Sabade bimu cabu.” ");
INSERT INTO bon_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Piba Yeesu pui pita biname ne jejige egä, “Määme ime tuuti!” Tabe ime uutige Yeesu bau me, piba siige teeme ime te miiji äbitige epu pana nuuja ime liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yepä Parisea sigu biname cina puma cita ca eclige, siige mene jitranisi Yeesu ne budre me acitame. ");
INSERT INTO bon_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeesu itecijige, egä Parisea sigu biname cina mene jitranisi teebine aglime, siige tabe pui cewe ne sebmalige, nuuja gome me äyeblingtige. Bucurage biname cina teebine ingwe icwisi. Laati bemi pita cama, tabe iyeta teebibine miiji jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Puma cita ca tabe teebibine giri jicranimige, egä teebine gone awabudni-ta. ");
INSERT INTO bon_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yeesu lui mule jewenige, ibibi äbitige mename biname Isaya me mene cama egä, ");
INSERT INTO bon_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Age sena, cane lui kaakesea bägrä ne ituge jaji. Tabe cäme singi biname gyene, cane teeme tääpume ngenecu miiji gäne. Cane cäme Seemo ne teeme cabu me cire yaacitepene. Tabe te biname bine umle cire jaawenemepi cäme atrana poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tabe lica cirege mene abaja coo claabe cama ala abayena. Teeme tagepogogo ne lica cirege gaabe cabu ta ätecijana. ");
INSERT INTO bon_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tabe ajodnäneji sogo ne lica cirege ägäbuta, cuta ätuma mameta lampa ne lica cirege ätuma. Tabe apu cire läbitanepi, ngälu biname cina Acejiyame me cotre bine cire jaawenemepesi. ");
INSERT INTO bon_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iyeta maramara gawe biname cina teeme ngene atwanena bine cire yaacranemepesi teeme bau me.” ");
INSERT INTO bon_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Biname cina yepä biname ne secanisi Yeesu bau me, lui te irecu määsumäsu piiyepu mene iicema cäco ge, ingle teeme niiya cable puga ge. Yeesu teebine miiji jewenige, siige tabe mene jiicemige piiyepu tabe irecu aasatige. ");
INSERT INTO bon_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Biname tomi cina mutäcäco äbitininisi. Teepi ätemläjinisi egä, “Nää, tabe pama mope biname Daawida me kaakesaare gyene?” ");
INSERT INTO bon_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisea sigu biname cina liba ai mene itecijemige, teepi jiicisi egä, “Tabe naace popi niiya cable bine yääyecräjemuge, ingle Beelsebul lui niiya cable bime mopeyame gyene, tabe te teebine kokre ecäranenige niiya cable bine äyecrejame.” ");
INSERT INTO bon_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeesu umle äbitige teeme ngene atwana poto cidi me, siige jejemige egä, “Nuuja gawe biname cina liba labelaninusi teemeteme cubu me, teepi watata lapirininusi. Cuta piiyepu babo cewe biname coo ingle biname cina liba labelaninusi teemeteme cubu me, teepi lica birige lenaja. ");
INSERT INTO bon_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Siige Satani lui bine yaawadimuge, teeme yepä tomi te liba nuuja tomi cama cubu jiicäsi, teepi siige uja maramara me läbitininusi, cije Satani me waadena mule te piba lipulipu kokre lenaja? ");
INSERT INTO bon_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yoo, weene jiiceniye egä Beelsebul, lui ne Satani ca cuta einenisi, tabe te cebine kokre näcäruge cane teeme niiya cable bine äyecrejame. Peei toraca lica gyene, ingle Beelsebul singi lica gyene teeme niiya cable bine biname cabu ca äyecrejame. Yoo, poto weeme abiberäja bägrä cina niiya cable bine cuta yääyecräjemusi. Luma cita ca teeme kokre peei mule ne wawename? Lica Beelsebul bau ca. Peei name pi weemerage abiberäja bägrä cina jaawabudnitusi weeme conocono mene, egä cäme kokre cable bine äyecrejame lui Beelse-bul bau ca gyene. ");
INSERT INTO bon_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eewe, cäme kokre lui teeme bau ca lica gyene, yepä Acejiyame me Seemo te kokre näcäruge cane niiya cable bine äyecrejame, siige weene peei name pi umle gemi, egä Acejiyame me waadena mule te weeme cabu me ituge atyaramta. ");
INSERT INTO bon_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nuuja te äblicäco abacita kokre biname me mete cabu me teeme gwidape bine waadename, tabe liba teebine niinäce lica jäätäyuge. Yepä tabe liba teebine niinäce jäätäyuge, tabe piba labacituge teeme mete me gwidape waadename. ");
INSERT INTO bon_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Laati te cäme biname lica gyene, tabe cebine näcisärmutuge. Laati te cäme bau me lica taabasecretnimuge, tabe yaaplidnäremuge. ");
INSERT INTO bon_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Peei name pi cane jijenininine, egä laati te liba ngena niiyaniya mene jiicemuge coo ngena nuuja niiya mule bine jaawenimuge, tabe miiji gyene kälyä äbitame pui niiya cabu ca. Yepä laati te liba niiyarage mene jiicemuge Aceji Seemo poto cidi me, teeme peei niiya te iyeteta yaanajuge. ");
INSERT INTO bon_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Laati te liba näcisärmutuge cebine, Acejiyame bau ca lui te tädujine biname me äbitujine, tabe miiji gyene kälyä äbitame teeme peei niiya mule cabu ca. Yepä laati te Aceji Seemo ne yääcisärmutuge, teeme peei niiya te iyeteta yaanajuge.” ");
INSERT INTO bon_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Uli liba miiji birige, teeme kuu cuta piiyepu miiji birige. Yepä, uli liba niiya birige, teeme kuu cuta niiya birige. Weene uli ne opo yaawatnuye teeme kuu cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Weene cobyame pana gemi! Biname me ngenecu liiyepu, teeme mene cuta piiyepu. Weene lipulipu miijirage mene iicema, ingle weene niiyarage gemi? ");
INSERT INTO bon_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Miiji biname te teeme miiji ngenecu cabu ca miiji mule bine saaboclomäjimuge, niiya biname te teeme niiya ngenecu cabu ca niiya mule bine saaboclomäjimuge. ");
INSERT INTO bon_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Cane jijenininine weebibine, egä Acejiyame me atrana bimu cabu biname cina miiji cire yaaboclomäjemepesi, egä ngena ingle cabu teepi papa kuu cäco mene ituge iicema. ");
INSERT INTO bon_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Weeme mene cabu ca weebibine atrana cirege, egä weene miiji biname gemi coo niiya biname gemi.” ");
INSERT INTO bon_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Poto cotre abiberäja biname piiyepu Parisea sigu biname cina Yeesu ne jejisi egä, “Abiberäja biname, cine singi gemi maane ciitaca mule ne wawename cime päpäname.” ");
INSERT INTO bon_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeesu jejemige egä, “Weene lipu niiyarage ätrunga cäco biname gemi, page ai padare cabu lui cina ireclota gemi! Weene singi gemi cäme bau ca ciitaca mule ne päpäname, yepä weene nuuja ciitaca mule ne lica pa jepänepeye, yepä Acejiyame me mename biname Yoona me ciitaca mule ne taatu pa jepänepeye. ");
INSERT INTO bon_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoona lipu babo cibu me camuge bora enajuji nesae bimu nesae ciiye cama, cane lui Acejiyame bau ca tädujine biname me äbitujine, cane cuta piiyepu gawe bora pagege lenaja nesae bimu nesae ciiye cama. ");
INSERT INTO bon_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Atrana bimu cabu Ninewa cewe biname cina cire talotnäripesi budre cabu ca weene cama gigri atrana tääpume. Teepi weebibine cirege aitneja, ingle teepi teeme niiya mule bine itu ebmalimujisi Yoona me bäärmi mene name pi. Siige cane age säne baborage Yoona bau ca, yepä weene cebine lica ituge ätrunga. ");
INSERT INTO bon_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Cuta Siiba gawe mope magebi te atrana bimu cabu weene cama gigri cire tarpinantepi siige tabe weebibine cirege aitneja, ingle tabe cudecewe cewe ca tocluji Solomona me umle mene ätecijame. Siige cane age säne baborage Solomona bau ca, yepä weene singi lica gemi cebine ätecijame.” ");
INSERT INTO bon_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Niiya cable te liba biname me trupa ne yaabmaluge, tabe waatnetnäjuge niiye cäco cewe cabu ta, puupu ne jäärnguge ngene oocaname. ");
INSERT INTO bon_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Liba lica jääpänuge, tabe jiicuge egä, ‘Cane acnenine piiyeme, cane lui mete ne sebmalumene.’ Tabe siige lacnuge, jääpänuge mete ne apretnäjeji piiyepu miijirage acranäneji. ");
INSERT INTO bon_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tabe piba läduge poto seben mage niiyarage cable bine arwojame, siige teepi iyeta saacluge pui biname me trupa cabu lenajame. Niinäce pui biname miiji lica birige, yepä page tabe siige iyeta mage niiyarage me läbituge. Pui yepä mule te cirege äbita ai niiyarage biname bime tääpume, lui cina ireclota gemi page.” ");
INSERT INTO bon_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeesu liba camu biname bine mene jajanena cabu jage, teeme mage piiyepu iganewale cina piba tatyarige. Teepi puutucu je imyemutäjimige, biname bine itemlimisi Yeesu cama mene me. ");
INSERT INTO bon_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Puma cita ca yepä biname te Yeesu ne jejige egä, “Määme mage piiyepu iganewale puutucu je ete nemä. Teepi singi gemi maane cama mene iicemame.” ");
INSERT INTO bon_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeesu pui biname ne itemlige egä, “Maane lipu ngene jotwa-nenite, laatu nwene cäme mage cuta laati bemi cäme naane igane?” ");
INSERT INTO bon_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Puma cita ca tabe teeme abiberäja bägrä bine teeme ime ca jewabimige, jiicige egä, “Ire, cäme mage piiyepu cäme naane igane age tema. ");
INSERT INTO bon_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Laati te liba jaawenuge cäme Babe cabucewe je teeme singi ne, tabe lui cäme naane, cäme igane, cäme ngule, cäme mage.” ");
INSERT INTO bon_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Peeirage bimu cabu Yeesu mete ne sebmalige, ädige, sawa ligi cabu adnatige. ");
INSERT INTO bon_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bucurage biname cina tabasecretnige teeme bau me, teebine jewaclomtisi, siige tabe poo cabu acenutige, adnatige. Biname cina sawa ligi cabu imyemutäjimige. ");
INSERT INTO bon_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yeesu ngene ca agli mene ca jejemige bucurage mule poto cidi me. Tabe jiicige egä, “Yepä biname te ädige calwacupi me kuu gije bine iisabejame. ");
INSERT INTO bon_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Egäcäro tabe kuu gije bine yiisabäjemige, poto cina gaabe cabu itrametnemige, siige ele cina seclige, erwäjimisi pui kuu gije bine. ");
INSERT INTO bon_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Poto kuu gije cina itrametnemige kula gawe cabu. Gawe puma paple ge. Gije cina watata äpletnärinisi, ingle gawe poone lica gyene. ");
INSERT INTO bon_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bimu te liba tacitige, nuunu te iplatnimige mamye gije bine, siige teepi piba iglumetnemige, ingle teeme braju cina sungabe me lica ebäcnisi. ");
INSERT INTO bon_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Poto kuu gije cina itrametnemige pägepäge mete cabu, siige pägepäge cina uutinisi, gije bine jetäyimisi. ");
INSERT INTO bon_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yepä poto kuu gije cina itrametnemige miijirage gawe cabu, siige miijirage uutinisi. Teepi jeciretnemige, kuu jepänimisi: poto lui yepä hanred, poto lui siksti, poto lui teeti. ");
INSERT INTO bon_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Weeme liba tablame piti nemi ätecijame, itecijinege umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abiberäja bägrä cina seclige Yeesu bau me, itemlisi egä, “Ngena name pi maane biname bine jejananemite ngene ca agli mene ca?” ");
INSERT INTO bon_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeesu jejemige egä, “Weebibine umle ituge wawena, egä Acejiyame lipulipu biname bine waadena, yepä teebibine lica ituge umle wawena pui poto cidi me, pui name pi cane ngene ca agli mene ca jejananemine teebibine. ");
INSERT INTO bon_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lui biname me umle pisi nyene, teebine cerämu umle ceera, siige teeme umle te babo pa läbitepi. Yepä lui biname te singi lica gyene umle tääpume, Acejiyame teeme bau ca pa yaacatepi teeme lui matikäli umle pisi nyene. ");
INSERT INTO bon_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cane naace name pi biname bine ngene ca agli mene jaajananemune, ingle teepi ngene jwaatwananinusi, yepä ngene ca lica yaaglusi; teepi yäätecijemuge, yepä teepi äblicäco ätecija piiyepu opo awatna. ");
INSERT INTO bon_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Teeme cabu ibibi äbitenige Acejiyame me mename biname Isaya lui niinäce gaabe mene jiicemuji egä, ‘Weene itecijinuge cuta itecijinuge, yepä weene lica umle läbitininuye. Weene ire lacitaninuye, ire lacitaninuye, yepä weene lica jääpänuye. ");
INSERT INTO bon_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ai biname bime ngene atwanena krokeciiye gemi, teepi tablame budubuduma gemi, teepi irecu ätumuteji gemi. Teepi apu liga lica cire läbitininejisi, teepi piba teeme irecu ca jääpänimusi, tablame ca yäätecijemuge, ngene atwana ca opo yaawatnusi, siige tatatrongärininusi cäme bau me cane Acejiyame te teebibine miiji wawename.’ ");
INSERT INTO bon_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Weene gege gemi, ingle weene weeme irecu ca jääpänuye, tablame ca itecijinuge, siige opo egäcäro yaawatnuye cäme mene ingle ne. ");
INSERT INTO bon_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cane jijenininine weebibine, egä bucurage Acejiyame me mename biname piiyepu conocäco biname, teepi baborage singi ituge ire me, weene lui gwidape bine jääpänanemepeye, yepä teepi lica ituge päpäna. Teepi singi ituge ätecijame, weene lui itecijanipi, yepä teepi lica ituge ätecija.” ");
INSERT INTO bon_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yeesu abiberäja bägrä bine jejemige egä, “Weene itecijinege, ngena tääpu myene ngene ca agli mene kuu gije iisabeja poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lui kuu gije cina yaatrametnemuge gaabe cabu, pui lui eei biname bime pana gemi, lui cina mene yäätecijemuge Acejiyame te biname bine waadena poto cidi me, yepä teepi opo lica yaawa-tnusi pui mene ne. Puma cita ca Satani te täduge, pui mene bine yääsecräremuge epu pana, ele cina lipu kuu gije bine yäärwäjimusi. ");
INSERT INTO bon_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lui kuu gije cina yaatrametnemuge kula gawe cabu, pui lui eei biname bime pana gemi, lui cina Miiji Mene liba yäätecijemuge, gege cama watawata joomlusi. ");
INSERT INTO bon_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yepä teepi matikolä padare taatu jäätrungusi, ingle teepi epu pana braju cäco gije liiyepu. Teepi liba mäpu ne jääpänusi coo teeme poto cidi me liba jiicetnäjemusi, ingle teepi pui Miiji Mene ne jäätrungusi, teepi piba taatu teeme ätrunga bine yaabmalimusi. ");
INSERT INTO bon_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lui kuu gije cina yaatrametnemuge pägepäge mete cabu, pui lui eei biname bime pana gemi, lui cina Miiji Mene yäätecijemuge, yepä mäpu ngene atwanena cina ai gawe ireclota poto cidi me, cuta singi rarekaake piiyepu poto gwidape tääpume, teepi peei Mene ne jäätäyusi pägepäge mete pana, siige kuu cäco läbituge. ");
INSERT INTO bon_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lui kuu gije cina yaatrametnemuge miiji gawe cabu me, pui lui eei biname bime pana gemi, lui cina Miiji Mene yäätecijemuge, opo yaawatnusi, siige teeme cabu kuu jaawenimuge, poto bime cabu yepä hanred kuu, poto bime cabu siksti kuu, poto bime cabu teeti kuu.” ");
INSERT INTO bon_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu nuuja ngene ca agli mene jejemige egä, “Apu gyene, Acejiyame te liba biname bine yaawadimuge. Calwacupi yageyame te puga ge. Tabe läduge, miiji gije bine yäätemuge teeme calwacupi cabu. ");
INSERT INTO bon_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Biname cina ute liba waagraruge, calwacupi yageyame me cubu biname te täduge, baace popo bine yiisabäjemuge calwacupi cabu me, siige luucruge. ");
INSERT INTO bon_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gije cina luutinusi, teeme mope cabu ca läsinusi kuu. Teepi gäli cina cuta luutinusi. ");
INSERT INTO bon_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Puma cita ca calwacupi yageyame me kaakesea bägrä cina saacluge teeme bau me, jaajusi egä, ‘Babo biname, nää peei miiji gije lica gemi, maane lui sitemumete määme calwacupi cabu? Luma cita ca gäli cina saacluge?’ ");
INSERT INTO bon_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tabe jaajemuge egä, ‘Peei lui cubu biname gyene, lui te baace popo bine sewadimumi, siige seyäräjemumi cäme calwa-cupi cabu.’ Teepi yäätemlusi egä, ‘Nää, maane singi gäte cine otnime gäli amingejame?’ ");
INSERT INTO bon_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tabe calwacupi yageyame te jaajemuge egä, ‘Gone naacluge, ingle weene liba gäli jaa-mingäjemuye, poto gije bine cuta yuutemuye. ");
INSERT INTO bon_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ebmalemepeye, luutipesi gigri ngälu ire acita padare, piba cane ärucna biname bine cire täätyepemepene gäli bine niinäce uutemame, sigu wawename, siige iisabame uliobo cabu me. Piba teepi kuu bine cire yaatomlecmepesi cäme mete cabu me waadename acrana tääpume.’” ");
INSERT INTO bon_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu nuuja ngene ca agli mene jejemige egä, “Apu gyene, Acejiyame te liba biname bine yaawadimuge. Yepä biname te mastad kuu gije ne ecatige, siige jecnige teeme calwacupi cabu. ");
INSERT INTO bon_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pui kuu gije lui matikäli birige iyeta kuu gije cabu ca, yepä liba luutuge, babo läbituge iyeta calwacupi gije cabu ca. Tabe uli pana jaaguge, piba ele cina saacluge teeme mete bine arangejame teeme ciipe cabu.” ");
INSERT INTO bon_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeesu nuuja ngene ca agli mene jejemige egä, “Apu gyene, Acejiyame te liba biname bine yaawadimuge. Yepä magebi te nesae diiba bine saawaduge bulu cama, jaaglemeläjimuge yepä kuke bora, uutneca gwidape ne saacatuge, yaacranimuge, siige jaama-nguge. Puma cita ca iyeta pui buluduu te tuutnecuge.” ");
INSERT INTO bon_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iyeta ai maramara mene Yeesu ngene ca agli mene ca biname bine jejananemige. Tabe nuuja mene ca teebibine lica yaabiberäjimuge yepä ngene ca agli mene ca. ");
INSERT INTO bon_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Apu ibibi äbitige Acejiyame me mename biname me mene egä, “Cane cirege ngene ca agli mene iicema. Cane cirege jajanena mule poto cidi me, lui cina ämletnäreji gemi agedna cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yeesu biname bine sebmalimige, mete bora me abacitige. Teeme abiberäja bägrä cina seclige teeme bau me, jejisi egä, “Maane seboclomti cime tääpume ngene ca agli mene lui jiicite gäli poto cidi me calwacupi je.” ");
INSERT INTO bon_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeesu puma cita ca gije abacitige pui mene ne aboclomtame. Tabe jejemige egä, “Biname lui te miijirage gije bine itemige, peei lui tabe sine, Acejiyame bau ca lui te täduji biname me äbituji. ");
INSERT INTO bon_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Calwacupi lui ai gawecewe gyene. Miijirage gije eei biname gemi, Acejiyame te lui bine ewadenemige; gäli eei biname gemi, Satani te lui bine ewadenemige. ");
INSERT INTO bon_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Cubu biname lui te gäli uutana tääpume baace popo bine calwacupi cabu me yiisabäjemige, tabe lui Satani sine. Ire acita lui gawecewe me ngälugaabe padare gyene. Ärucna biname lui Acejiyame me mename seemo gemi. ");
INSERT INTO bon_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gäli bine lipu tomi jewenimisi ayime, pepu pana cirege ai padare me ngälugaabe je äbita. ");
INSERT INTO bon_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Piba Acejiyame bau ca lui te täduji biname me äbituji, tabe teeme mename seemo bine cire täätyepemepi teeme binamewale bime cabu ca eei bine waadename, lui cina biname bine opo jaawenimusi niiyaniya mule bine wawenecame, piiyepu nuuja niiyaniya mule waweneca biname bine. ");
INSERT INTO bon_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Teepi teebibine cire yiisabäjemepesi baborage uliobo wädräji cabu me. Puma teepi ele cire yaangenetnemepi, giricu cire yaatebecmepesi. ");
INSERT INTO bon_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Piba conocäco biname cina bimu apaclyera pana cirege, teeme Babe te liba cire yaawademepi teebibine. Weeme liba tablame piti nemi ätecijame, itecijinege umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Apu gyene, Acejiyame te biname bine liba yaawadimuge. Yepä biname te babo daremuyame miijirage gwidape ne jääpänuge, lui te gawe ca äclidnäneji ge. Tabe siige cääri cuta jääclidnuge, gege cama läduge, iyeta teeme gwidape bine yaawadimuge aletname. Rarekaake bine liba jääpänimuge, ingwe ca piba läduge, peei gawe ne jaaletnuge. ");
INSERT INTO bon_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Cuta apu gyene Acejiyame te liba biname bine yaawadimuge. Yepä biname te kusa bine jäärngemuge. ");
INSERT INTO bon_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tabe liba yepä jamyacurage ne jääpänuge, tabe läduge, iyeta teeme gwidape bine yaawadimuge aletname. Pui rarekaake ca siige pui jamyacu kusa ne jaaletnuge. ");
INSERT INTO bon_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Cuta apu birige, Acejiyame te liba biname bine yaawadimuge. Cibubade biname cina net sigu ne jaadadnäjusi malu cabu, siige tabe maramara cibu bine joomläjicmuge. ");
INSERT INTO bon_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Liba tapanuge, cibubade biname cina yäälädnusi doro me, ladnatäruge, cibu bine jaatranimusi maramara acraname. Miijiyame bine diiba bora me yääbäcnimusi, niiyaniya bine yiisabimusi. ");
INSERT INTO bon_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Apu mule te ai padare me ngälugaabe je cirege äbita. Acejiyame me mename seemo cina cire saaclepi niiya mule biname bine waadename miiji mule biname bime cabu ca, ");
INSERT INTO bon_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","siige cire yiisabemepesi baborage uliobo wädräji cabu me. Teepi puma ele cire yaangenetnemepi, giricu cire yaatebecmepesi.” ");
INSERT INTO bon_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Siige Yeesu teeme abiberäja bägrä bine itemlimige egä, “Nää, weene opo bewatnimiye iyeta ai ngene ca agli mene bine?” Teepi ‘yoo’ mene jejisi. ");
INSERT INTO bon_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yeesu puma cita ca jejemige egä, “Cotre abiberäja biname, laati te umle gyene mime cotre bine, tabe liba Acejiyame ne conocäco yääcäruge teebine acaname, tabe mete yageyame pana birige, lui te kirece piiyepu sasa gwidape bine sääsemuge teeme cumä cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeesu liba iyeta ai ngene ca agli mene jajanena bine epirimige, tabe pui cewe ne sebmalige, ");
INSERT INTO bon_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","acnenutige teemerage cewe me. Tabe puma biname bine ebiberäjimige abasecretna mete cabu. Lui cina jitecijisi, teepi mage mutäcäco äbitininisi, siige ätemläjinisi egä, “Tabe luma cita ca ituge ai umle ne acata? Cuta luma cita ca kokre ne itu jääpänanepi ciitaca mule bine wawenecame. ");
INSERT INTO bon_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tabe pui mete raranga biname me bägrä gyene. Mariya teeme mage gwene piiyepu Yakobu, Yoosepa, Simona, Yuuda naabi teeme iganewale gemi. ");
INSERT INTO bon_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Teeme ngulewale cuta ama piti nemi. Cije tabe luma cita ca umle äbitanenige iyeta ai mule bine wawenecame?” ");
INSERT INTO bon_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Siige teepi Yeesu ne jigyisi. Yeesu puma cita ca jejemige egä, “Acejiyame me mename biname ne yaacatusi iyeta poto ta, yepä lica teemerage cewe cabu piiyepu teemerage binamewale cina.” ");
INSERT INTO bon_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tabe puma bucurage ciitaca mule bine lica jewenimige, ingle teepi ätrunga lica ge teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pui padare cabu Galilaya probins mope biname ngii Heroda te Yeesu poto cidi me itecijige. ");
INSERT INTO bon_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tabe puma cita ca teeme ingwe gaabe biname bine jejemige egä, “Tabe lui Yoane niiye ca äciseja biname gyene. Tabe budre cabu ca itu tarpinantumi, peei name pi teeme kokre pisi nyene ciitaca mule bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroda ai mene jiicige, ingle tabe sine biname, laati te tejemimumi Yoane ne oomlaname, seea ca ätäyame, krokeciiye mete bora me äsinglentame. Tabe ai mule ne tewenumi ingle Herodiyas name pi, lui teeme igane Pilipo me coga ge, yepä Heroda te juutecrepi, siige teeme coga me jwaawenepi. ");
INSERT INTO bon_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Puma cita ca Yoane te Heroda ne jaajananepi egä, “Peei lui miiji mule lica gyene maane määme igane me coga ne acatame.” ");
INSERT INTO bon_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroda tabe peei name pi singi ge Yoane ne budre me aglime, yepä tabe wälu ge biname name pi, ingle teepi ngene totwananimesi, egä Yoane lui Acejiyame me mename biname gyene. Peei name pi tabe wata lica seglumi, yepä krokeciiye mete bora me secitumi. ");
INSERT INTO bon_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yoo, Yoane niiye ca äciseja biname me budre gaabe apu gyene: liba Heroda me ärngi bimu te tatyaramtige, tabe soriyomu ne jewenige. Pui padare cabu puga ge Herodiyas me beecma bägrä. Tabe giire jewäjige soriyomu biname bime opo gaabe. Heroda mage gege äbitige teeme giire name pi, ");
INSERT INTO bon_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","siige jojige egä, “Cane Acejiyame me opo gaabe je naajenine, egä maane ngena tääpume liba nätinärenite, cane nääcärenine.” ");
INSERT INTO bon_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngulebägrä me mage te jojige tabe Heroda ne apu jajime egä, “Cane singi gäne Yoane niiye ca äciseja biname ne aglime, piba teeme mope ne pleito cabu acaname cäme bau me päpäna tääpume, egä tabe budre gyene.” Siige tabe ngulebägrä te ai mene jejige Heroda ne. ");
INSERT INTO bon_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heroda ngenecu mäpu me äbitige, yepä tabe lui Acejiyame me ngii cabu mene jojige teeme soriyomu biname bime opo gaabe je, peei name pi tabe teeme kaakesea bägrä ne jejige ngulebägrä me singi wawename. ");
INSERT INTO bon_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaakesea bägrä te ädige, Yoane me mope ne teläcnutige krokeciiye mete cabu, ");
INSERT INTO bon_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mope ne secanige pleito cabu, siige ngulebägrä ne ocärige. Tabe teeme mage ne ocärige. ");
INSERT INTO bon_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoane me abiberäja bägrä cina seclige, teeme budrekaake ne isatisi mete cabu ca, gape cabu ecitisi. Puma cita ca teepi äcnärige, Yeesu ne jejisi, egä ngena mule cina bäbitinisi Yoane poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeesu liba Yoane me budre poto cidi me itecijige, tabe pui cewe ne sebmalige, poo gaabe ädige biname cäco cewe me ten taatu. Biname cina liba itecijemige, egä Yeesu bädige, teepi siige teeme cewe bine sebmaläcemisi, ernge ta eclige pui puupu cabu me Yeesu liiyeme ädige. ");
INSERT INTO bon_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Teepi niinäce atyarige, Yeesu me poo te ingwe sipyige. Yeesu liba poo cabu ca arpatige, tabe bucurage biname bine jepänimige. Tabe owecu äbitige teeme tääpume, siige pita biname bine miiji jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pui mämleteca cabu je abiberäja bägrä cina seclige Yeesu bau me, jejisi egä, “Bimu te mage bädige. Biname cäco cewe gyene ai, peei name pi biname bine jityepimi mameta lui cewe gemi, teepi puma cita ca deedei aletname teeme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yepä Yeesu teeme abiberäja bägrä bine jejemige egä, “Teepi nuuja singi lica gemi otnime, ingle weene te teebibine deedei ecäremeye.” ");
INSERT INTO bon_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Teepi jejisi egä, “Cime nata nuujarage deedei ama lica gemi, yepä faib buluduu gemi piiyepu neeneni cibu bumate gegi.” ");
INSERT INTO bon_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeesu jejemige egä, “Sewademeye aima cäme bau me.” ");
INSERT INTO bon_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Puma cita ca Yeesu biname bine jejemige baace papa cabu adnaterame. Tabe piba faib buluduu neeneni cibu cama sewadimige, cabu me ire acitige, Acejiyame ne eso ecärige. Piba tabe buluduu bine itrecimige cibu cama, abiberäja bägrä bine ecärimige, teepi siige biname bine ecäranemisi. ");
INSERT INTO bon_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iyeta biname cina ibibi erwäjimisi. Abiberäja bägrä cina buluduu pacupacu bine etomlicmisi, jengärimisi, twelb diiba cina tapanininisi. ");
INSERT INTO bon_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lui rooriye cina erwäjisi pui deedei, teepi faib tausen ge. Coga bägrä bine lica ecnemisi. ");
INSERT INTO bon_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yeesu teeme abiberäja bägrä bine jejemige poo cabu acetne-rame, niinäce gaabe me äwäcame sawa nuuja poto doro me, tabe liba biname bine jityepäjemige. ");
INSERT INTO bon_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Siige tabe biname bine liba niinäce jityepäjemige, tabe piba jegelige podo cabu me irecu ätumutame. Mämleteca me liba, Yeesu ten taatu puga ge podo cabu. ");
INSERT INTO bon_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Poo te sawa kuukälu cabu jage. Uule kuu cina poo ne eboclomäjisi, ingle buuwe te magerage opopo tipwäjige. ");
INSERT INTO bon_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Paulo ala me Yeesu piba täinige podo cabu ca, niiye papa cabu ta ädige teeme bau me. ");
INSERT INTO bon_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Abiberäja bägrä cina teebine liba tepänisi niiye papa cabu otni je, teepi siige mage wälu ge. Teepi apu jiicisi egä, “Tabe lui dadrange gyene,” siige wälu ala abayininisi. ");
INSERT INTO bon_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yepä Yeesu jejemige egä, “Wälu gone, cane säne!” ");
INSERT INTO bon_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Puma cita ca Peteru Yeesu ne jejige egä, “Yageyame, liba toracarage maane säte, maane naji cane uuplaname niiye papa cabu määme bau me otnime.” ");
INSERT INTO bon_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu jejige egä, “Tädi!” Peteru puma cita ca tuuplige poo cabu ca, gije abacitige niiye papa cabu Yeesu bau me otnime. ");
INSERT INTO bon_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yepä tabe liba jepänige, buuwe te kokre cama titwige, tabe wälu äbitige, siige abumame äbitige. Tabe ala abayige egä, “Yageyame, nätityäri!” ");
INSERT INTO bon_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Piba taatu Yeesu ime uutige, joomlige teebine, jejige egä, “Määme ätrunga matikäli gyene. Maane ngeno me neeneni ngene atwana cama gäte?” ");
INSERT INTO bon_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Teepi liba acenutäsi poo cabu me, buuwe te piba ärputige, siige mataru te enajige. ");
INSERT INTO bon_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Abiberäja bägrä cina poo cabu kokorare ca ipednäremisi Yeesu tääpume, jejisi egä, “Toraca, maane Acejiyame me Bägrä gäte.” ");
INSERT INTO bon_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yeesu teeme abiberäja bägrä cama liba sawa ne yuurisi, teepi atyarige Genesareta gawe cabu me, siige poo te puma ipyige. ");
INSERT INTO bon_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Puma cita ca pui gawe biname cina liba Yeesu ne opo ewatnisi, teepi idre jecananisi cewe gaabegabe ta, siige biname cina iyeta pita biname bine sewadanemisi Yeesu bau me. ");
INSERT INTO bon_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Teepi teebine itemlisi egä, “Pita biname cina lipu gemi määme cäbletääpe pepyämu taatu oomlaname?” Siige iyeta lui cina joomläjisi, teepi miiji äbitaninisi. ");
INSERT INTO bon_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Poto Parisea sigu biname piiyepu cotre abiberäja biname cina seclige Yeesu bau me Yerusalema ca. ");
INSERT INTO bon_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Teepi itemlisi egä, “Lipu pi määme abiberäja bägrä cina mime saarewale bime mule bine lica jaawenimusi? Teepi deedei loolo niinäce gaabe me ime lica läcisäjinusi cude gwidape cabu ca kälyä äbitame.” ");
INSERT INTO bon_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeesu teebibine jejemige egä, “Weene weemämu ngeno me Acejiyame me mene ne kaake me jaawenuye saarewale bime mule wawena ca? ");
INSERT INTO bon_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Acejiyame te itu tiicuji egä, ‘Weene miiji mage babe bine opo gaabe me acita’ cuta piiyepu egä, ‘Laati te liba teeme mage babe bime poto cidi me niiyarage mene jiicemuge, teebine miiji budre me acita.’ ");
INSERT INTO bon_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yepä weene jiicuye, egä biname me liba gwidape pisi nyene mage babe bine ätityerame, yepä tabe liba jiicuge egä, ‘Ai gwidape lui Acejiyame tääpume myene,’ ");
INSERT INTO bon_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","siige tabe teeme peei mene name pi kälyä bäbitige teeme mage babe bine ätityerame pui gwidape ca. Apu pi weene Acejiyame me mene ne kaake me jaawenuye naace tääpume weene saarewale bime abiberäja ne äcwetname. ");
INSERT INTO bon_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Weene walya biname gemi! Toraca gyene Acejiyame me mename biname Isaya lui niinäce gaabe mene jiicuji weeme poto cidi me egä, ");
INSERT INTO bon_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ai biname cina cebine nawepyeräjusi teeme tage miipe ca, yepä teeme ngene atwanena cudecewerage gyene cäme bau ca. ");
INSERT INTO bon_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Teepi nuuja miiji lica gemi cebine awepyeräjame, ingle teepi biname bine yaabiberäjimusi cotre bine äcwetname, lui cäme cotre lica gemi.’” ");
INSERT INTO bon_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeesu biname bine ala tesoglicmige, jejemige egä, “Cängena itecijinege, umle äbitinineye ai mene! ");
INSERT INTO bon_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Biname te ngena ne yaacituge teeme tage cabu, pui te niiya me lica jaawenuge, yepä teeme tage cabu ca ngena te tasatuge, pui te teebine niiya me jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abiberäja bägrä cina seclige Yeesu bau me, jejisi egä, “Nää, maane umle gäte, egä Parisea sigu biname cina niiyarage basicnantinisi määme mene name pi?” ");
INSERT INTO bon_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeesu jejemige egä, “Iyeta gije, cäme Babe cabu je lui bine lica sitemimumi, miiji uutema braju cama. ");
INSERT INTO bon_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Weene ngenecu mäpu gone Parisea biname bime name pi. Teepi epu pana gemi irecu määsumäsu biname, lui cina otnime opo jaawenimusi poto irecu määsumäsu biname bine. Liba irecu määsumäsu biname te otnime opo jaawenuge nuuja teeme pana ne, teepi iyeta cupicu bora me laatramuge.” ");
INSERT INTO bon_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Puma cita ca Peteru Yeesu ne itemlige teeme mene ne aboclomtame. ");
INSERT INTO bon_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeesu abiberäja bägrä bine jejemige egä, “Nää, weene cuta buduma camu gemi? ");
INSERT INTO bon_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Weene nää umle lica bäbitininiye, egä biname te ngena ne yaacituge teeme tage cabu, camuge bora me labacituge, siige puma cita ca tasatuge. ");
INSERT INTO bon_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yepä ngena cina täsuge tage cabu ca, peei lui ngenecu bora ca saacluge. Peei cina biname ne niiya me jaawenusi. ");
INSERT INTO bon_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Teeme ngenecu bora ca täsuge niiyarage ngene atwanena cina, lui cina teebine jaawenusi tabe nuuja biname ne budre me aglime, sargi mule wawename, gwidape ero me, walya mene otromame, niiyaniya mene iicetnejame. ");
INSERT INTO bon_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ai cina biname ne niiya me jaawenusi, yepä tabe liba ime äciseja cäco deedei yäärwäjimuge, pui te teebine niiya me lica jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeesu pui cewe ne sebmalige, ädige Turo piiyepu Sidona gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yepä Kanana cewe magebi, lui te pui gawe cabu tonajenäjumi, tabe Yeesu bau me toclige, ala abayige egä, “Babo biname Daawida me kaakesaare, maane cebine owecu naweni! Cäme bägrä niiyarage gwene. Teeme trupa cabu pisi nyene niiyarage cable.” ");
INSERT INTO bon_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yepä Yeesu nuuja mene lica ge. Puma cita ca abiberäja bägrä cina seclige Yeesu bau me, jejisi egä, “Peei magebi ne uyecräji, ingle tabe ala tabayanenige mime kaake poto ca!” ");
INSERT INTO bon_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu jejemige egä, “Cebine ituge ätyepa Israela biname bime bau me taatu, lui cina epu pana gemi apeseräjäneji maamoi liiyepu.” ");
INSERT INTO bon_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yepä pui magebi liba utecijige, tabe toclige, Yeesu me ernge gome utramige, jejige egä, “Babo biname, nätityäri!” ");
INSERT INTO bon_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu ngene ca agli mene ca teebine jojige egä, “Peei lui miiji lica gyene cane bägrä bime deedei iisabejame drego plongo bime bau me.” ");
INSERT INTO bon_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Magebi te Yeesu me ngene ca agli mene jewe-cnistige, jejige egä, “Toraca babo biname, yepä drego plongo cina nata yäärwäjimusi lui pläpupläpu cina saatrametnemuge bägrä bime dade cabu ca gawe me.” ");
INSERT INTO bon_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeesu jojige egä, “Magebi, määme ätrunga lui baborage gyene! Määme singi te ibibi läbitege.” Peeirage padare cabu teeme bägrä te miiji äbitige. ");
INSERT INTO bon_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeesu pui cewe ne sebmalige, Galilaya sawa ligi me ädige. Tabe puga podo ne jegelige, siige adnatige. ");
INSERT INTO bon_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bucurage biname cina seclige teeme bau me, sewadimisi otnetneja cäco biname bine, irecu määsumäsu biname bine, ernge ime niiyaniya biname bine, mene cäco biname bine cuta bucurage poto maramara pita biname bine. Teebibine icranimisi Yeesu me opo gaabe, tabe siige miiji jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Biname cina mutäcäco äbitininisi, teepi liba jepänimisi mene cäco biname cina lui mene jiicemisi, ernge ime niiyaniya biname cina lui iyeta miiji äbitaninisi, otnetneja cäco biname cina lui cängena otninisi, irecu määsumäsu biname cina lui irecu aasataninisi. Teepi puma cita ca eso ecärisi Israela biname bime Acejiyame ne. ");
INSERT INTO bon_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeesu teeme abiberäja bägrä bine ala tesoglicmige, jejemige egä, “Cane owecu gäne ai biname bime tääpume, ingle teepi nesae bimu cama cane cama sicrajimumi, siige page teeme nuuja deedei lica gemi ärwäjame. Cane singi lica gäne teebibine deedei cäco ätyepame, ingle teepi gaabe je cable jaalocnimuge.” ");
INSERT INTO bon_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abiberäja bägrä cina itemlisi egä, “Mine luma jepänenemisi ibibi deedei ai daapo taatu cewe cabu teebibine ngeerame?” ");
INSERT INTO bon_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu itemlimige egä, “Weeme lija buluduu gemi?” Teepi jejisi egä, “Cime seben buluduu gemi piiyepu nesae matimati cibu.” ");
INSERT INTO bon_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Puma cita ca Yeesu biname bine jejemige gawe cabu adna-terame. ");
INSERT INTO bon_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tabe seben buluduu piiyepu cibu bine sewadimige, Acejiyame ne eso ecärige, itrecimige, abiberäja bägrä bine ecärimige, siige teepi biname bine ecäranemisi. ");
INSERT INTO bon_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Teepi iyeta erwäjisi, ngälu ibibi äbitininisi. Puma cita ca abiberäja bägrä cina deedei pacupacu bine etomlicmisi, seben diiba bine jengärimisi. ");
INSERT INTO bon_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lui rooriye cina erwäjimisi, teepi fooa tausen ge. Coga bägrä bine lica ecnemisi. ");
INSERT INTO bon_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Puma cita ca Yeesu biname bine jityepimige, poo cabu acenutige, Magadan gawe cabu me ädige. ");
INSERT INTO bon_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisea sigu biname piiyepu Sadukea sigu biname cina seclige Yeesu bau me teebine apicetnärame. Teepi jejisi egä, “Maane ciitaca mule jeweni cine päpäname, egä Acejiyame me kokre määme cabu pisi nyene.” ");
INSERT INTO bon_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yepä Yeesu jejemige egä, “Bimu te liba läpulyäruge, weene liba jääpänimuye carbe uudi, weene piba apu jiicuye egä, ‘Ciiyeciye mage bimu te ebenige, ingle carbe lui uudi gemi.’ ");
INSERT INTO bon_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Krokerage weene liba jääpänimuye, egä carbe uudi gemi piiyepu cäsä gemi, piba weene jiicuye egä, ‘Page ngupe te secirenige, ingle carbe uudi piiyepu cäsä gemi.’ Weene carbe cabu ca bimu ne opo yaawatnuye, yepä weene äblicäco gemi opo awatna page ai padare cabu lui mule cina äbitininisi, teepi ngena tääpu memi. ");
INSERT INTO bon_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Weene ätrunga cäco niiyarage biname gemi page. Weene cebine nätemliye ciitaca mule wawename. Weene nuuja ciitaca mule ne lica pa jepänepeye, yepä lui ciitaca mule te Yoona tääpume äbituji.” Puma cita ca Yeesu teebibine sebmalimige, nuuja gome me äyeblingtige. ");
INSERT INTO bon_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yeesu piiyepu abiberäja bägrä cina liba yuurisi sawa nuuja poto doro me, abiberäja bägrä cina ngene jitrimalemige buluduu bine waadename. ");
INSERT INTO bon_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Puma cita ca Yeesu teebibine ngene ca agli mene ca jejemige egä, “Weene ireire inajipi Parisea sigu biname piiyepu Sadukea sigu biname bime uutneca gwidape tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abiberäja bägrä cina teemeteme jitranisi egä, “Tabe naace popi ai mene nijinige, ingle mine buluduu bine lica sewadimisi.” ");
INSERT INTO bon_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesu umle äbitige, egä teepi ngena tääpume jitranisi, siige tabe itemlimige egä, “Weene ngena name pi jitraniye, egä weeme buluduu lica gyene? Weeme ätrunga lipu matikolä gwene. ");
INSERT INTO bon_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Weene nää camu gemi umle äbita? Weene nää uja ngene ituge ätrimela, cane lipu faib buluduu bine sitrecimumene faib tausen rooriye bime tääpume. Weene nää lija diiba bine tengärimumeye pacupacu deedei ca? ");
INSERT INTO bon_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Coo piiyepu weene nää uja ngene ituge ätrimela seben buluduu lipu ibibi ge fooa tausen rooriye bime tääpume. Lija modamoda diiba bine weene tengärimumeye deedei pacupacu ca? ");
INSERT INTO bon_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Äi, lipu pi weene umle lica bäbitininiye, egä cane buluduu tääpume lica bii jijinine. Yoo, cane cääri jijenininine, egä weene ireire inajipi Parisea piiyepu Sadukea biname bime uutneca gwidape tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Abiberäja bägrä cina teepi siige opo ewatni-si, egä tabe teebibine lica jejemige ireire lenajame uutneca gwidape tääpume, yepä Parisea piiyepu Sadukea biname bime abiberäja mene tääpume. ");
INSERT INTO bon_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeesu ädige Kesarea Pilipo babo cewe mameta lui gawe cabu me. Tabe puma abiberäja bägrä bine itemlimige egä, “Biname cina lipu jiicusi, egä cane laasi näne, Acejiyame bau ca lui te biname me äbitujine?” ");
INSERT INTO bon_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Teepi jejisi egä, “Poto cina jiicenisi, egä maane Yoane niiye ca äciseja biname gäte. Poto cina jiicenisi, egä maane Eliya säte; poto cina egä maane Yeremiya säte coo nuuja Acejiyame me mename biname gäte.” ");
INSERT INTO bon_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu itemlimige egä, “Cije weene, weene lipu jiiceniye egä cane laasi näne?” ");
INSERT INTO bon_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Peteru te Yeesu ne jejige egä, “Maane lui Keriso säte, biname bine lui te niiya cabu ca pagege äsecrera. Maane ireclota Acejiyame me Bägrä gäte!” ");
INSERT INTO bon_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeesu Peteru ne jejige egä, “Simona, Yoona me bägrä, maane gege gäte. Nuuja biname te peei ngene atwana lica nääcärige meebine, yepä peei lui cäme Babe bau ca gyene, cabucewe je lui te enajenige. ");
INSERT INTO bon_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Cane naajenine meebine Peteru, egä määme ngii lui ‘Kula’ gyene. Piiyepu maane lui mene bii jiicite cäme poto cidi me cuta kula pana gyene, siige ai kula cabu cane cäme ätrunga ingle ne pa yaacitepene. Tabe epu kokre pa yaanajepi, egä budre te äblicäco apremela teebine. ");
INSERT INTO bon_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Cane meebine kii pa nääcärepene Acejiyame bau lui gaabe ne iitnaname piiyepu armime. Maane ngena mule tääpume gaabe ne jiitnute, Acejiyame te yaacatuge, cuta maane ngena mule tääpume gaabe ne yaarmute, Acejiyame te yaacatuge.” ");
INSERT INTO bon_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Puma cita ca Yeesu abiberäja bägrä bine jejemige egä, “Gone biname bine umle jaawenimuye, egä cane Keriso säne, lui te biname bine niiya cabu ca pa yääsecräremepene.” ");
INSERT INTO bon_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pui padare cabu Yeesu gije abacitige abiberäja bägrä bime tääpume pajecu me wawename, egä tabe miiji Yerusalema me pa lädepi. Tabe puma pagege mäpurage gwidape bine päpäna modamoda iiwäreja biname, cotre abiberäja biname piiyepu nuuja Israela modamoda biname bime bau ca. Teebine pagege budre cabu acita, yepä nesae me lui bimu tabe piba pagege arpinenta. ");
INSERT INTO bon_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Puma cita ca Peteru Yeesu ne ecanige taatu cewe me, kokre cama mene jejige egä, “Eewe, babo biname! Acejiyame te owecu naawenepi! Peei mule te gone läbituge määme tääpume!” ");
INSERT INTO bon_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yeesu tatatrongtige, Peteru ne jejige egä, “Satani, äyeblingti cäme opo gaabe ca! Maane cebine liga iirbutame nawenite. Maane biname bime pana ngene jotwananenite, lica Acejiyame pana.” ");
INSERT INTO bon_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Siige Yeesu abiberäja bägrä bine jejemige egä, “Biname te liba singi gyene cane cama yepä otnime, tabe miiji teemerage singi bine gawe me acrana, teeme baarge uli ne palace cabu acana siige cebine ingwe äcwi. ");
INSERT INTO bon_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Laati te liba singi lica teemerage singi bine abmaläcemame, tabe teeme ireclota ne cirege apesera, yepä laati te singi teemerage singi bine abmaläcemame cämiji pi, tabe iyeteta ireclota ne cire jääpänepi. ");
INSERT INTO bon_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Biname te nuuja miiji ne lica cire jääpänepi, ngänu gyene tabe puu iyeta ai gawecewe ne yaacatuge, yepä teeme ireclota ne yaapesaruge. Nuuja gwidape lica gyene biname te teeme ireclota daremu me ceerame. ");
INSERT INTO bon_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Acejiyame bau ca lui te täduji biname me äbituji, tabe teeme Babe me jamyacu apaclyera cabu teeme mename seemo cama cire tädepi. Siige tabe biname bine piba daremu cire yääcäranemepi teeme mule ibi. ");
INSERT INTO bon_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cane toraca mene jijenininine, egä ama poto lui cina jeclajutäjenemige, teepi lica cirege budre äbita, ngälu teepi teebine cire jääpänepesi mope biname tääpume otni.” ");
INSERT INTO bon_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siks bimu ingwe gaabe ca Yeesu aacanänige Peteru piiyepu nanigane wäsi Yakobu naabi Yoane, siige opo jaawenänige podo caburage me ten taatu. ");
INSERT INTO bon_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Podo cabu je Yeesu mara opo me äbitige abiberäja bägrä bime irewale je. Teeme opo te epu oplacmeläjige bimu iredäri pana, piiyepu teeme cäbletääpe cina äbitininisi bulu taatu me, apaclyera pana. ");
INSERT INTO bon_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Piba Moose naabi Eliya taboclomtäsi teeme cabu me, siige Yeesu cama mene jiicemäsi. ");
INSERT INTO bon_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Puma cita ca Peteru Yeesu ne jejige egä, “Yageyame, cine miijirage gämi ama. Maane liba singi gäte, cane aarangenänine nesae matimati mete bine, yepä määme, yepä Moose me, yepä Eliya me.” ");
INSERT INTO bon_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peteru liba camu mene iicema cabu je, piba carbe te apaclyera cama tädige, iyeta teebibine aacwabänige. Puma cita ca tagepogogo te tasatige carbe bora ca egä, “Ai lui cäme ngenecurage Bägrä gyene. Cane teeme tääpume babo ngenecu miiji gäne. Weene teebine jitecijeye!” ");
INSERT INTO bon_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abiberäja bägrä cina liba itecijemige tagepogogo, teepi mage wälu äbitininisi, oweowe itrametnemige gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeesu teeme bau me tädige, joomlänige, jääjänige egä, “Abujengäneye, wälu gone!” ");
INSERT INTO bon_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Teepi puma cita ca mope ewejengänisi, yepä Yeesu taatu ne jepänisi. ");
INSERT INTO bon_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Siige teepi liba täinetnänige podo cabu ca, Yeesu abiberäja bägrä bine jääjänige egä, “Gone biname bine umle jaawenanemuye, weene lui mule ne bii jepäniye, ngälu cane, Acejiyame bau ca lui te tädujine biname me äbitujine, pagege budre cabu ca arpinenta.” ");
INSERT INTO bon_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Puma cita ca abiberäja bägrä cina Yeesu ne itemlänisi egä, “Ngeno me cotre abiberäja biname cina jiicenisi, egä Eliya te miiji niinäce gaabe me otni, piba ingwe ca Keriso, biname bine niiya cabu ca äsecrera biname te cire tädepi?” ");
INSERT INTO bon_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeesu teebibine jääjänige egä, “Toraca gyene, egä Eliya te miiji niinäce otni iyeta gwidape bine teeme puupu cabu acraname. ");
INSERT INTO bon_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Cane toraca mene jijenänine, egä Eliya uja ituge otni, yepä biname cina opo lica yaawatnepesi, pui name pi teepi teebine jaawenepesi, teepi lipu ituge singi. Cuta piiyepu cane lui te Acejiyame bau ca tädujine biname me äbitujine, cane pagege biname bime bau ca mäpu ne päpäna.” ");
INSERT INTO bon_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Siige abiberäja bägrä cina umle äbitänisi, egä Yeesu lui Yoane niiye ca äciseja biname poto cidi me bii jääjänige. ");
INSERT INTO bon_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yeesu teeme nesae abiberäja bägrä cama liba podo cabu ca täinetnänige biname bime cabu me, piba yepä biname te Yeesu bau me tädige, kokorare ääpednutige, ");
INSERT INTO bon_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","jejige egä, “Babo biname, maane cäme bägrä ne owecu jeweni. Tabe naabe äbitanenige oonina pita cabu ca, siige yaatramanuge uliobo cabu piiyepu niiye cabu. ");
INSERT INTO bon_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cane määme abiberäja bägrä bime bau me secanine, yepä teepi äblicäco ge teebine miiji me wawena.” ");
INSERT INTO bon_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeesu jiicige egä, “Weene lipu ätrunga cäco gemi, niiyarage biname gemi! Luma ngine padare cama cane miiji weene cama lenaja? Luma ngine padare cama cane miiji weeme ätrunga cäco mule päpäna? Secaneye bägrä ne cäme bau me.” ");
INSERT INTO bon_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Puma cita ca Yeesu niiya cable ne jejige asatame, siige tabe asatige. Puirage padare cabu bägrä te miiji äbitige. ");
INSERT INTO bon_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abiberäja bägrä cina Yeesu bau me seclige, ogä jejisi egä, “Cine lipu pi niiya cable äyecreja cäco äbitininago?” ");
INSERT INTO bon_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tabe jejemige egä, “Weeme ätrunga matikäli gyene. Cane toraca mene jijenininine, weeme ätrunga liba pisi nyene, ngänu gyene epu pana duuwe baace kuu matikolärage, weene miiji gemi ai podo ne jaji egä, ‘Awetänti ama cita ca piiyeme!’ siige tabe lawetäntuge. Weeme liba ätrunga pisi nyene, iyeta gwidape ibibi gemi weeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yepä apuyame ne weene äblicäco nuuja mule ca äyecreja yepä irecu ätumuta ca piiyepu pui irecu ätumuta padare cabu weene miiji deedei cäco lenaja.” ");
INSERT INTO bon_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Abiberäja bägrä cina liba iyeta abasecretnige Galilaya me, Yeesu teebibine jejemige egä, “Cane lui Acejiyame bau ca tädujine biname me äbitujine, cebine mameta gyene biname bime ime cabu acita. ");
INSERT INTO bon_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Teepi cebine pa naglepesi budre me, yepä nesae me lui bimu cabu cane piba page larpinantepene budre cabu ca.” Abiberäja bägrä cina mage ngenecu mäpu me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yeesu liba atyaramtige Kaprenauma me teeme abiberäja bägrä cama, biname lui cina yaatomlicmusi Acejiyame me iiwäreja mete tääpume täks rarekaake, teepi piba seclige Peteru ne ätemla-me egä, “Nää, määme abiberäja biname te täks rarekaake yaacranuge iiwäreja mete tääpume?” ");
INSERT INTO bon_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peteru jejemige teebibine egä, “Ngenä pi, yaacranuge.” Tabe liba mete bora me abacitige, Yeesu niinäce me puma mene jiicige, Peteru ne itemlige egä, “Simona, maane lipu ngene jotwanenite, ai gawe cabu lui mope biname teepi nää luma cita ca täks rarekaake bine yaatomlicmusi teeme tääpume, teeme bägrä bime bau ca coo nuuja biname bime bau ca?” ");
INSERT INTO bon_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peteru jejige egä, “Nuuja biname bime bau ca, lica teeme bägrä bime bau ca.” Yeesu jejige egä, “Yoo siige, cane cuta kälyä gäne Acejiyame me mete tääpume täks rarekaake acrana cabu ca, ingle cane teeme Bägrä gäne. ");
INSERT INTO bon_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yepä mine gone teebibine ngenecu mäpu me jaawenemago. Äte ädi, edigiricu jepetäji sawa cabu. Maane niinäce lui cibu ne irpatenite, tage jipälutepi, siige maane yepä rarekaake ne jepänenite puma. Maane pui ne ecatepi, ecäremepi mime täks tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pui padare cabu abiberäja bägrä cina seclige Yeesu ne ätemla-me egä, “Acejiyame te lui biname bine yaawadimuge, laasi nyene baborage?” ");
INSERT INTO bon_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yeesu yepä matikolä bägrä ne tesoglicige, jejige teeme cole je aclajutame, ");
INSERT INTO bon_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","piba abiberäja bägrä bine jejemige egä, “Cane toraca mene jijenininine weebibine, egä weene liba lica weeme ngene atwanena bine yaatatrongärimuye bägrä pana ätrungame, piba weene miiji lica gemi Acejiyame me waadena mule cabu me äbäcname. ");
INSERT INTO bon_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Acejiyame te lui biname bine yaawadimuge, teeme cabu ca eei te baborage yaanajuge, lui te teemämu matikolä läbituge ai bägrä pana. ");
INSERT INTO bon_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Laati te cäme ngii cabu jaawabluge yepä apu pana bägrä ne, tabe cuta nawabluge cebine.” ");
INSERT INTO bon_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ai matimati bägrä lui cina cebine nätrungusi, laati te liba teeme yepä ne jaawenuge niiya mule wawename, pui biname te mäpu ne cire jääpänepi Acejiyame bau ca. Teeme singicace gome liba jaaglotusi baborage kula ne, siige malu cabu yaajarusi budre me, peei mäpu lui plowa birige pui mäpu cabu ca tabe lui ne cire jääpänepi. ");
INSERT INTO bon_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mage niiyarage gyene, egä ai gawecewe cabu piti nemi gwidape, lui cina biname bine jaawenimusi niiya mule wawenecame. Iyeta padare pipu gwidape cina saacluge, yepä babo niiyarage gyene biname tääpume, lui te biname bime cabu me pui gwidape bine saawadimuge.” ");
INSERT INTO bon_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Siige Yeesu puma cita ca teeme abiberäja bägrä bine jejemige egä, “Määme ime te coo ernge te liba naawenuge maane singi ädrime niiya mule wawename, maane miiji pui ngene atwana ne watatarage iyeblingtepi, epu pana ime ne coo ernge ne lipu jääläcnutute, yaajarute. Miiji gyene maane yepä ernge coo ime cama iyeteta ireclota cabu me otni, yepä niiya gyene maane iyeta piicwa cama otni iyeteta uliobo cabu me. ");
INSERT INTO bon_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Cuta määme irecu te liba naawenuge maane singi ädrime niiya mule wawename, maane miiji watatarage peei ngene atwana ne iyeblingtepi, irecu ne lipu juungyatute. Miiji gyene maane yepä irecu cama iyeteta ireclota cabu me otni, yepä niiya gyene maane neeneni irecu cama uliobo puupu cabu me otni.” ");
INSERT INTO bon_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jepäneye, egä weene ai matimati bägrä bime yepä ne gone äseblecäja. Cane jijenininine weebibine, egä teeme mename seemo cina cabucewe je iyeta padare cabu cäme Babe me opo ne jepänanenisi. ");
INSERT INTO bon_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane naace tääpume tädujine, egä lui cina apesareji gemi teebibine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Weene lipu ngene jotwanininiye, biname te ngena jaawenuge teeme liba yepä hanred maamoi piti nemi, siige yepä te liba lapesaruge? Tabe yaabmalimuge naintinain bine podo cabu, siige läduge ärngime, lui te lapesaruge. ");
INSERT INTO bon_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tabe gege birige naintinain maamoi tääpume, lui cina apesareji lica gemi. Yepä cane toraca jijenininine, egä tabe mage gege birige apesareji maamoi ne liba jääpänuge. ");
INSERT INTO bon_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cuta pepu gyene, weeme Babe cabucewe je tabe singi lica gyene apu matimati bägrä yepä te cäme bau ca apeserame.” ");
INSERT INTO bon_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Määme nuuja ätrunga biname te liba niiya mule yaacnuge määme tääpume, maane ädepi, ogä eblawäjepi. Tabe liba näätecijuge, maane teebine bii sewecnistite. ");
INSERT INTO bon_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yepä tabe liba lica näätecijuge, maane piba yepä coo neeneni biname cama ädepi teeme bau me. Maane miiji ai ne naace popi wawena, ingle Oogäräneji mene te jiicenige, egä maane biname ne liba jaaitnäjute, neeneni coo nesae biname cina miiji peema aitneja tääpume. ");
INSERT INTO bon_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tabe liba teebibine cuta lica jäätecijemuge, siige piba ätrunga ingle biname bine umle jewenemepi. Yepä tabe liba cuta teebibine ätecija cäco, siige maane teebine epu jewenepi Acejiyame umle cäco biname ne liiyepu coo täks rarekaake uutecrena biname ne liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Cane toraca mene jijenininine weebibine, egä weene ngena mule tääpume gaabe ne yaarmuye, Acejiyame te yaacatuge, cuta weene ngena mule tääpume gaabe ne jiitnuye, Acejiyame te yaacatuge. ");
INSERT INTO bon_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Cane cerämu poto jijenininine, egä weene neeneni cina liba gawecewe cabu yepä ngene atwana ne yaacituye weene ngena tääpume irecu ätumutame, cäme Babe cabucewe je tabe pa icärepi. ");
INSERT INTO bon_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ingle naace popi neeneni coo nesae cina liba cäme ngii cabu labasecretnänusi, cane pisi näne teta cama.” ");
INSERT INTO bon_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peteru tädige, Yeesu ne itemlige egä, “Yageyame, cäme biname te niiya mule liba nawenanuge, lija gääbu cane miiji teeme niiya mule ngene ätrimelame? Nää, seben gääbu?” ");
INSERT INTO bon_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu jejige egä, “Lica seben gääbu, yepä sebenti gääbu seben! ");
INSERT INTO bon_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Acejiyame te liba biname bine yaawadimuge, tabe epu läbituge gawe mope biname pana, laati te singi ire me teeme kaakesea bägrä cina lipu ire jaatwemusi teeme rarekaake bine. ");
INSERT INTO bon_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tabe liba gije abacitige ai kaakesea wawename, piba yepä kaakesea bägrä ne teeme bau me secanisi, lui te yepä milyon rarekaake itu yaawademepi teeme bau ca. ");
INSERT INTO bon_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ingle pui kaakesea bägrä me rarekaake lica ge daremu aglime, peei name pi babo biname te jejemige teeme coga bägrä, iyeta teeme gwidape piiyepu tabe, teebibine waadename aletname piba pui rarekaake ca daremu aglime. ");
INSERT INTO bon_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Siige pui kaakesea bägrä te teeme babo biname me opo gaabe kokorare ääpednutige, ewejanige egä, ‘Maane owecu nawenepi. Padare näcärepi, cane iyeta rarekaake piba daremu pa naawecnemepene.’ ");
INSERT INTO bon_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Babo biname te teebine owecu jewenige, jejige egä, ‘Daremu gone saawecnimute,’ siige tabe teebine jityepige. ");
INSERT INTO bon_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yepä pui kaakesea bägrä te liba asatige, tabe teeme keege kaakesea bägrä ne jepänige, lui te yepä hanred rarekaake bine itu sewadimumi teeme bau ca, siige singicace gome teebine jejecletnäjige claabe cama, jejige egä, ‘Maane rarekaake daremu nawecnisti.’ ");
INSERT INTO bon_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Teeme keege te kokorare ääpednutige, ewejanige egä, ‘Maane owecu nawenepi! Padare näcärepi, cane iyeta rarekaake piba daremu pa naawecnemepene.’ ");
INSERT INTO bon_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yepä tabe owecu lica ge, siige teebine ijarige krokeciiye mete bora me, ngälu tabe cirege daremu awecnema. ");
INSERT INTO bon_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Babo biname me poto kaakesea bägrä lui cina jepänisi, teepi cälu te jitemige piiyepu teepi mage ngenecu mäpu ge. Teepi babo biname bau me eclige, iyeta jejananisi ai poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Puma cita ca babo biname te ala tesoglicige teeme niinäce kaakesea bägrä ne, jejige egä, ‘Maane niiyarage kaakesea bägrä gäte. Ingle maane nawejanite, cane ngene nätrimalige määme daremu bine awecna-me. ");
INSERT INTO bon_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Maane cuta miiji owecu jaawenejite määme keege ne, cane lipu meebine owecu naawenine.’ ");
INSERT INTO bon_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tabe babo biname te mage claabe me äbitige, siige jityepige teebine krokeciiye mete me, ngälu tabe cirege iyeta pui daremu bine awecna. ");
INSERT INTO bon_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Apu cirege cäme Babe cabu je iyeta weebibine wawena, weene liba weeme ngenecu ca lica ngene jitrimalinuge, weeme nuuja ätrunga biname te ngena niiya mule jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeesu liba mene iicema siigesige äbitige, tabe Galilaya gawe ne sebmalige, Yoridana baduge ne yuurige nuuja poto doro me Yuudea gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bucurage biname cina teebine ingwe icwisi, siige tabe pita biname bine miiji jewenanemige puma. ");
INSERT INTO bon_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Poto Parisea sigu biname cina seclige Yeesu ne apicetnärame. Teepi itemlisi egä, “Nää Cotre ibi mule gyene rooriye te teeme coga ne liba ägyi papa ingle cabu ca?” ");
INSERT INTO bon_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu jejemige egä, “Egäsu weene ituge acnema Oogäräneji mene te lipu jiicenige, egä agedna cabu ca Acejiyame te biname bine jaawenuji rooriye me piiyepu magebi me, ");
INSERT INTO bon_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","siige jiicuji egä, ‘Peei name pi rooriye te miiji teeme mage babe bine gomala coga cama atejäclmutame, siige teepi yepä me läbitäsi.’ ");
INSERT INTO bon_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Teepi siige piba neeneni lica gegi, yepä teepi yepä taatu gegi. Peei name pi biname te gone maramara me wawena, Acejiyame te laati bine laatejäclmutuge.” ");
INSERT INTO bon_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Puma cita ca Parisea sigu biname cina itemlisi egä, “Cije ngena name pi piba Moose me Cotre cabu apu oogäräneji gyene, egä rooriye te liba singi birige coga ne ägyime, tabe miiji peba ne oogära ägyi ingle poto cidi me, siige pui peba cama jwäätyepuge teebine?” ");
INSERT INTO bon_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu jejemige egä, “Moose naace name pi weebibine conocäco icärininuji weene coga ne ägyime, ingle weene ätecija cäco biname gemi. Yepä agedna cabu ca pepu lica ituge. ");
INSERT INTO bon_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cane toraca mene jijenininine weebibine, egä rooriye lui te teeme coga ne jwäägyuge, yepä tabe teeme coga te nuuja ero lica ituge wawena, siige tabe liba nuuja coga ne waacatuge, tabe ero mule ne jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Abiberäja bägrä cina puma cita ca Yeesu ne jejisi egä, “Ai liba gaabe gyene coga rooriye bime tääpume, atejäclmuta cabu ca miiji gyene coga rooriye cäco lenajame.” ");
INSERT INTO bon_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu jejemige egä, “Ai abiberäja lui iyeta biname bime tääpume lica gyene, yepä eei bime tääpume taatu Acejiyame lui bime tääpume singi teepi pepu lenajame. ");
INSERT INTO bon_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maramara ingle piti nemi biname cina atejäclmuta cäco lenajame. Poto cina teeme ärngi cabu ca epu gemi egä teepi äblicäco atejäclmuta; poto bine biname cina pepu me ituge wawena; poto cina teemämu pepu me ituge äbita, ingle teepi singi gemi Acejiyame taatu te teebibine waadename. Laati te miiji gyene ai abiberäja ne acatame, tabe jaawenepi.” ");
INSERT INTO bon_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Biname cina bägrä bine sewadimisi Yeesu bau me naace me tabe ime acitame teeme papa cabu me piiyepu irecu ätumutame teeme tääpume. Yepä abiberäja bägrä cina jicnecimisi teebibine. ");
INSERT INTO bon_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yeesu abiberäja bägrä bine jejemige egä, “Bägrä cina saaclege cäme bau me. Gone jiibemuye, ingle ai bägrä pana ätrunga cama lui biname teebibine Acejiyame te yaawadimuge.” ");
INSERT INTO bon_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Puma cita ca Yeesu teeme ime aacitanige bägrä bime papa cabu me teeme miiji tääpume, siige ai ingwe gaabe ca tabe piba ädige. ");
INSERT INTO bon_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yepä biname te tädige Yeesu bau me, itemlige egä, “Abiberäja biname, cane ngena miiji mule ne miiji wawena iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu jejige egä, “Maane ngeno me nätemlite, egä ngena gyene miiji? Nuuja gwidape te miiji lica gyene, yepä Acejiyame taatu gyene miiji. Maane liba singi gäte iyeteta ireclota ne päpäname, maane miiji cotre bine äcwetna.” ");
INSERT INTO bon_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pui biname te Yeesu ne itemlige egä, “Lui cotre bine?” Yeesu jejige egä, “Biname ne gone budre me agli; sargi mule gone; gwidape ero gone; walya aitneja gone; ");
INSERT INTO bon_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mage babe bine miiji opo gaabe me acitena; maane miiji nuuja biname tääpume epu singi äbitena, maane lipu määme tääpume singi läbitanute.” ");
INSERT INTO bon_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Puma cita ca mamye biname te jejige egä, “Cane ituge iyeta ai cotre bine wawenetnäja. Cerämu cane miiji ngena ne wawena?” ");
INSERT INTO bon_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu jejige egä, “Maane liba singi gäte epucäco lenajame, maane ädi, iyeta määme gwidape bine aletname ewademepi, rarekaake owecumete biname bine ecäranemepi, siige tädepi cane cama yepä otnime, piba maane miijimiji gwidape bine cabucewe je cire jepänemepi.” ");
INSERT INTO bon_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mamye biname te liba itecijige, tabe ngenecu mäpu cama äyeblingtige, ingle tabe babo dogwe biname ge. ");
INSERT INTO bon_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Puma cita ca Yeesu teeme abiberäja bägrä bine jejemige egä, “Toraca gyene, dogwe biname tääpume mäpurage birige Acejiyame me cabucewe waadena cabu äbäcname!” ");
INSERT INTO bon_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cane cerämu jijenininine, egä peei lui mäpu birige kamela te nilo bora cabu me abacitame siige asatame, yepä baborage mäpu birige dogwe biname te Acejiyame me waadena cabu abacitame.” ");
INSERT INTO bon_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abiberäja bägrä cina liba itecijemige, teepi siige iyeta mutäcäco äbitininisi, itemlisi egä, “Laati te piba miiji gyene iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu ire acitige teeme bau me, jejemige egä, “Biname te ibibi lica gyene pui ne wawename, yepä Acejiyame te miiji gyene iyeta gwidape bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Puma cita ca Peteru Yeesu ne jejige egä, “Cije cine lipu gemi? Cine iyeta gwidape bine itu saabmalemepesi maane cama yepä otnime, cine siige ngena miiji ne cirege päpäna?” ");
INSERT INTO bon_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu jejemige egä, “Cane toraca mene jijenininine: ai padare te liba cirege apira, kirece padare te liba cirege atyaramta, cane lui Acejiyame bau ca tädujine biname me äbitujine, cane piba jamyacu apaclyera cama cäme babo adnata puupu cabu ca biname bine cire yaawademepene. Weene, cäme ingwe äcwiyame biname, cuta piba cire adnatäripeye twelb babo adnata puupu cabu twelb Israela ingle bine atraname. ");
INSERT INTO bon_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iyeta lui cina ituge abmala teeme mete bine, teeme naane igane bine, teeme ngule bine, teeme mage babe coo bägrä bine coo piiyepu teeme gawe bine cäme name pi, teepi cirege päpäna tuwängle yepä hanred gääbu cuta piiyepu teebibine iyeteta ireclota cirege ceera. ");
INSERT INTO bon_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yepä bucurage biname page lui cina niinäce gaabe biname gemi, teepi ciige ireclota cabu ingwe gaabe me cire täcnäripesi. Cuta piiyepu laati bemi page ingwe gaabe biname gemi, teepi ciige ireclota cabu niinäce gaabe me cire läbitipesi.” ");
INSERT INTO bon_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Acejiyame te liba biname bine yaawadimuge, peei lui epu pana ge, calwacupi yageyame te lipu ädige krokerage biname bine jajanename daremu cama kaakesea wawename teeme waina calwacupi cabu. ");
INSERT INTO bon_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Teepi mene conocäco jewenisi tabe kaakesea bägrä bine yepä bimu me camlecamle daremu ceerame, siige tabe jityepäjemige teeme waina calwacupi cabu kaakesea wawename. ");
INSERT INTO bon_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yageyame te cääri asatige krokebimu me, ädige, jepänimige poto biname cina papa ämyemuteji icrajige aletna puupu gome. ");
INSERT INTO bon_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tabe jejemige egä, ‘Weene cuta naaclege cäme waina calwacupi cabu kaakesea wawename, cane piba weebibine icärininine, ngena daremu gyene miiji.’ ");
INSERT INTO bon_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Siige teepi eclige. Puma cita ca bimu duusa cabu yageyame te cääri kaakesea bägrä bine jityepimige teeme calwacupi me, cuta cääri mämlebimu me. ");
INSERT INTO bon_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mämleteca me yageyame te liba cuta ädige aletna puupu me, tabe puma jepänimige poto biname papa ämyemuteji icrajige. Puma cita ca tabe itemlimige egä, ‘Weene ama bimu lecaleca ngeno me inaji-ninige, padare te papa ädenige?’ ");
INSERT INTO bon_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Teepi jejisi egä, ‘Ingle nuuja biname te cibibine lica biiri nijinige kaakesea tääpume.’ Yageyame te jejemige egä, ‘Weene cuta naaclege cäme waina calwacupi cabu kaakesea wawename.’ ");
INSERT INTO bon_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mämlerage me kaakesea te liba apirige, yageyame te teeme kaakesea ire atwi biname ne jejige egä, ‘Kaakesea bägrä bine ala tesoglicmi, teebibine daremu ecäranemi. Niinäce eei bine ecäranemi, lui cina ceräcerägääburage kaakesea me eclige, piiyepu lui cina niinäcerage eclige kaakesea tääpume, pui bine ingwerage ecäranemepi.’ ");
INSERT INTO bon_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Biname lui cina kaakesea jegednimisi mämleteca me, teepi camlecamle bimu me daremu ne ecatisi. ");
INSERT INTO bon_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Puma cita ca biname lui cina niinäcerage me eclige kaakesea me, teepi apu jengenetnemige, egä teepi baborage daremu ne ecatenisi, yepä teebibine yepä ibi daremu ecäranemisi. ");
INSERT INTO bon_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Teepi teeme daremu bine ewademisi, siige calwacupi yageyame ne jiyingäjisi. ");
INSERT INTO bon_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Teepi teebine jejisi egä, ‘Lui biname bine ingwerage ca jejemite, teepi matikäli padare cabu taatu kaakesea jewenisi; cine te magerage kaakesea jewenisi bimu nuunu cabu, yepä maane teebibine cine cama yepä ibi daremu becäranemite!’ ");
INSERT INTO bon_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yageyame te teeme yepä ne jejige egä, ‘Cäme biname, maane näätecijege! Cane lica naangletnäjine meebine, ingle cane nääcärine, mine lipu tääpume mene conocäco bii jewenisi. ");
INSERT INTO bon_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Määme daremu ne ecati, acnenuti cewe me. Lui biname ne ingwerage jejine kaakesea me otnime, cane singi gäne teebine maane cama yepä ibi daremu ceerame. ");
INSERT INTO bon_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Egäsu cäme conocäco pisi nyene cäme rarekaake ca wawename cane ngena tääpume singi. Maane nää ire patre eglenenemite, lui cina matikäli padare cabu kaakesea jewenisi, yepä cane camle-camle daremu bii becäranemine.’ ");
INSERT INTO bon_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Apu pi ingwe gaabe je lui cina, teepi niinäce gaabe me cire läbitipesi; niinäce gaabe je lui cina, teepi ingwe gaabe me cire täcnäripesi.” ");
INSERT INTO bon_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeesu liba Yerusalema me ädige, tabe biname sobe cabu ca mara me äbitige teeme twelb abiberäja bägrä cama teebibine gaabe cabu mene jajanename. ");
INSERT INTO bon_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Tabe jejemige egä, “Itecijinege, mine aga naclenige Yerusalema me. Puma pagege cebine ceera, Acejiyame bau ca lui te tädujine biname me äbitujine, modamoda iiwäreja biname piiyepu cotre abiberäja biname bime ime cabu me. Teepi mene pa jaatranepesi cebine budre me aglime, ");
INSERT INTO bon_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","siige pa näcärepesi nuuja gawe cabu ca biname bime cabu me. Teepi cebine ätutena pana pa nawenepesi, pa nadnanepesi, baarge uli cabu pa näbyecrepesi. Yepä nesae me lui bimu liba pa joomlepi, cane piba cuta budre cabu ca pa larpinantepene ireclota me.” ");
INSERT INTO bon_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jebedayo me coga te teeme neeneni bägrä cama toclige Yeesu bau me, kokorare ca ipednemalige teeme opo gaabe, itinärige teeme singi ne wawename. ");
INSERT INTO bon_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu utemlige egä, “Maane ngena tääpu mäte singi?” Magebi te jejige egä, “Maane toraca tiicepi, egä cäme ai neeneni bägrä cina cirege adnata määme camu poto ca piiyepu säwäci poto ca, maane liba biname bine cire ewademepi.” ");
INSERT INTO bon_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu Yakobu naabine Yoane jaajige egä, “Weene umle lica gegi, weene ngena tääpume najiye. Weene nää ibibi gegi epu mäpu cabu lenajame, cane lui mäpu ne mameta gäne päpäna?” Teepi jejäsi egä, “Cine ibibi gegi.” ");
INSERT INTO bon_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu jaajige, “Weene cire inajepi mäpu cabu cäme pana, yepä cäme conocäco lica gyene jajime, egä laati te cire ladnatepi cäme camu poto ca piiyepu säwäci poto ca. Cäme Babe te pui puupu bine ituge amacetnäja, tabe lui bime tääpume singi teepi puma adnaterame.” ");
INSERT INTO bon_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nuuja ten abiberäja bägrä cina liba itecijemige, teepi claabe me äbitininisi pui nanigane wäsi bime tääpume. ");
INSERT INTO bon_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Puma cita ca Yeesu iyeta teebibine ala tesoglicmige, jejemige egä, “Weene umle gemi, egä laatibi Acejiyame umle cäco biname bine yaawadimusi, teeme conocäco pisi nyene jajime teepi ngena wawename. Teeme ingwe gaabe lui modamoda biname teeme cuta kokre pisi nyene biname bine mene jajanename. ");
INSERT INTO bon_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yepä weene apu gone läbitininuye. Weeme yepä te liba singi baborage me äbitame, tabe miiji nuuja bime tääpume kaakesea wawena; ");
INSERT INTO bon_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","cuta weeme yepä te liba singi niinäce me äbitame, tabe miiji weeme tääpume epu matikäli me äbita aletnäneji biname te lipu läbituge teeme yageyame tääpume. ");
INSERT INTO bon_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane cuta lica tädujine biname cina cäme tääpume kaakesea wawename, yepä cane te teeme tääpume kaakesea wawename piiyepu cäme ireclota ne ceerame daremu tääpume teebibine kälyä wawename.” ");
INSERT INTO bon_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Teepi liba Yeriko ne sebmalisi, baborage biname sange te tädige Yeesu me ingwe poto ca. ");
INSERT INTO bon_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gaabe wajwa je puga ge adnatäneji neeneni irecu määsumäsu biname. Teepi äätecijige egä, “Yeesu cibibine nisuplingtenige.” Teepi puma cita ca gije abacitäsi ala abayename egä, “Babo biname, mope biname Daawida me kaakesaare, maane owecu cibibine niwenepi!” ");
INSERT INTO bon_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Biname cina liga jiibananisi teebibine, teepi babo tage ca cuta ala abayenäsi egä, “Mope biname Daawida me kaakesaare, maane cibibine owecu niwenepi!” ");
INSERT INTO bon_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeesu imyemutige, siige teebibine ala taasoglicige, äätemlige egä, “Weene singi cane ngena wawename weeme tääpume?” ");
INSERT INTO bon_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Teepi jejäsi egä, “Babo biname, cine singi gegi maane cime irecu asatame.” ");
INSERT INTO bon_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeesu owecu jaaglige, teeme ime bine aarpenutige teeme irecu cabu me. Piba taatu teepi irecu aasatäsi, siige Yeesu ne ingwe icwäsi. ");
INSERT INTO bon_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeesu teeme abiberäja bägrä cama ädige Yerusalema ne oomlaname. Teepi liba Yerusalema ne mameta me jewenisi oomla-name, teepi atyarecanige cewe ngii Betepage me lui Olibi Uli podo cabu jage. Puma cita ca Yeesu teeme neeneni abiberäja bägrä bine niinäce gaabe me jäätyepige ");
INSERT INTO bon_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","apu mene cama egä, “Weene iclege weeme niinäce gaabe me lui cewe peese nyene. Weene puma jepäneniye yepä dongki ne seea ca ägräräneji gyene, teeme cuta bägrä pisi nyene teeme gome. Jiitnepeye, taacanepeye cäme bau me. ");
INSERT INTO bon_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Biname te liba nuuja mene jaji je, weene apu jejepeye egä, ‘Yageyame te singi gyene ai dongki tääpume teeme bägrä cama, cuta tabe watawata pa taawecnistepi.’” ");
INSERT INTO bon_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ai mule te äbitige Acejiyame me mename biname me mene te ibibi äbitame egä, ");
INSERT INTO bon_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Weene jejemepeye Siiyona podo cabu lui babo cewe cabu biname cina icrajenige egä, ‘Ire, weeme mope biname te peega tädenige weeme bau me! Tabe awamla cäco tädenige mamye dongki papa cabu, dongki me bägrä papa cabu.’” ");
INSERT INTO bon_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Puma cita ca abiberäja bägrä cina aaclige, jewenäsi, Yeesu ngena tääpume jaajige. ");
INSERT INTO bon_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Teepi dongki ne teeme bägrä cama taacanisi Yeesu bau me, cäbletääpe bine teeme papa cabu seretne-mäsi, siige Yeesu acenutige. ");
INSERT INTO bon_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bucurage biname cina teeme cäbletääpe bine gaabe cabu eretnimisi. Poto cina uli ciipe bine icnapimisi gaabe cabu aretname. ");
INSERT INTO bon_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yeesu me niinäce gaabe, ingwe gaabe lui biname cina teepi ala abayaninisi egä, “Daawida me kaakesaare ne yaawepyeräjesi! Acejiyame te miiji meebine naawenege lui te Yageyame me ngii cabu tädenite! Mine yaawepyeräjesi Acejiyame ne, cabucewe je lui te enajenige!” ");
INSERT INTO bon_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeesu liba Yerusalema me atyaramtige, biname cina cälu te jitemige. Teepi teemeteme ätemläjinisi egä, “Baa, laasi nyene ai biname?” ");
INSERT INTO bon_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yeesu cama lui biname cina seclige, teepi jejemisi egä, “Tabe Acejiyame me mename biname Yeesu sine, Nasareta ceweyame gyene Galilaya probins cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeesu iiwäreja mete caale bora me abacitige, siige teebibine iyecräjemige, lui cina saawadanemusi gwidape bine aletname piiyepu lui cina jaaletnimusi. Tabe rarekaake äbäsuwäja biname bime dade bine eboclomäjimige cuta eei bime adnatera dade bine, gimäe ele bine lui cina saawadanemusi aletname. ");
INSERT INTO bon_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tabe jejemige egä, “Acejiyame te jiicenige Oogäräneji mene cabu egä, ‘Cäme mete ne irecu ätumuta mete ca yaainusi,’ yepä weene te itu setatrongärumeye epu puupu me, eromaame cina luma lämletne-räjininusi.” ");
INSERT INTO bon_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Irecu määsumäsu biname, ernge niiyaniya biname cina seclige Yeesu bau me iiwäreja mete caale bora je, siige tabe teebibine miiji jewenanemige. ");
INSERT INTO bon_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Modamoda iiwäreja biname piiyepu cotre abiberäja biname cina claabe me äbitininisi, liba jepänisi, Yeesu lipu miijirage mule bine jewenemige piiyepu teepi liba itecijemige, bägrä cina iiwäreja mete cabu lipu ala abayaninisi egä, “Mope biname Daawida me kaakesaare ne ewepyeräjeye!” ");
INSERT INTO bon_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Siige teepi Yeesu ne jejisi egä, “Maane nää lica näätecijenige teepi ngena jiicenenemisi? Maane ngena name pi lica jiibenenemite teebibine?” Yeesu jejemige egä, “Yoo, cane nätecijenige. Egäsu weene ituge acnema Oogäräneji mene egä, ‘Maane bägrä piiyepu ngame meeramera bägrä bine ituge wawena meebine epucäco awepyeräjame.’” ");
INSERT INTO bon_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Puma cita ca Yeesu teebibine sebmalimige, siige Yerusalema ca asatige, Betaniya cewe me ädige. Tabe ciiye puga enajige. ");
INSERT INTO bon_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Krokerage Yeesu liba acnenutige babo cewe Yerusalema me, gaabe cabu cubrowe te joomlige. ");
INSERT INTO bon_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tabe piigi uli ne jepänige gaabe wajwa je, ädige, teeme gome jeclajutige, yepä laame taatu jepänimige, kuu lica. Tabe puma cita ca uli ne jejige egä, “Maane ingwe ca lica page nääyepi kuu päpäname.” Yeesu ai mene liba jejige, uli te piba taatu laame jedacromtige, siige budre äbitige. ");
INSERT INTO bon_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abiberäja bägrä cina liba jepänisi, teepi cälu te jitemige, jejisi egä, “Lipu pi ai piigi uli te jedacromtige watatarage?” ");
INSERT INTO bon_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu jejemige egä, “Cane toraca jijenininine weebibine, egä weene liba yepä ngene atwana cama ätrunga birige, weene ibibi gemi apu wawena, cane ai piigi uli ne lipu jewenine. Cuta ai taatu lica, yepä weene cuta ibibi gemi ai podo ne jajime egä, ‘Awetänti, malu cabu me ajari,’ siige pui mule te pa läbitepi. ");
INSERT INTO bon_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Weene liba Acejiyame ne ngena tääpume yäätinäruye tabe icärininuge, weene liba jäätrunguye egä, ‘Tabe nicärininige.’” ");
INSERT INTO bon_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeesu liba acnenutige iiwäreja mete caale bora me biname bine abiberäjame, piba modamoda iiwäreja biname piiyepu nuuja modamoda biname cina seclige teeme bau me, itemlisi egä, “Määme ngena conocäco pisi nyene ai mule bine wawenecame? Määme conocäco laati bau ca gyene?” ");
INSERT INTO bon_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu jejemige egä, “Cane weebibine yepä taatu mene itemlininine, siige weene liba cäme mene nawecnisteniye, cane piba weebibine jijenininine, cäme ngena conocäco gyene ai mule bine wawenecame. ");
INSERT INTO bon_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoo, weene najeye, laati te Yoane ne conocäco yääcärepi tabe biname bine niiye ca äcisejame, Acejiyame te coo nää biname cina?” Teepi siige teemeteme mene jitranisi apu egä, “Mine ngena daremu mene jewecnistenisi? Mine liba jejenisi egä, ‘Acejiyame te Yoane ne conocäco yääcärepi tabe biname bine niiye ca äcisejame,’ tabe piba nijenininige egä, ‘Cije weene ngena name pi piba teebine lica jäätrungepeye?’ ");
INSERT INTO bon_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yepä mine liba apu jejenisi egä, ‘Biname cina Yoane ne conocäco yääcärepesi tabe niiye ca biname bine äcisejame,’ mine piba miiji wälu biname bime tääpume, ingle teepi iyeta jitrungenisi, egä Yoane lui Acejiyame me mename biname ge.” ");
INSERT INTO bon_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Siige teepi Yeesu ne mene jewecnistisi egä, “Cine umle lica gemi, laati te Yoane ne conocäco yääcärepi tabe biname bine niiye ca äcisejame.” Yeesu jejemige egä, “Cane cuta weebibine lica jijenininine, egä cebine laati te conocäco näcärepi cane ai mule bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu ngene ca agli mene jejemige egä, “Weene lipu ngene jotwanininiye ai poto cidi me? Yepä biname puga ge teeme neeneni imäbägrä cama. Tabe niinäceyame ne jejige egä, ‘Cäme bägrä, page ädi waina calwacupi cabu me kaakesea wawename.’ ");
INSERT INTO bon_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bägrä te jejige egä, ‘Cane singi lica gäne,’ yepä ingwe ca tabe ngenecu etatrongtige, siige ädige kaakesea wawename. ");
INSERT INTO bon_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Puma cita ca babe te ädige teeme nuuja bägrä bau me, cuta peei yepä mene jejige. Pui bägrä te jejige egä, ‘Yoo, cane ädenine,’ yepä tabe lica ädige. ");
INSERT INTO bon_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Siige lui bägrä te teeme babe me singi jecatige, jewenige?” Biname cina Yeesu ne jejisi egä, “Niinäceyame te teeme babe me singi jewenige!” Yeesu jejemige egä, “Cane toraca mene jijenininine: peei bägrä lipu niinäce beswa äbitige teeme babe me singi wawename, yepä ingwe ca ngenecu etatrongtige, cuta pepu pana gyene täks rarekaake uutecrena biname piiyepu magebi lui bine daremu jaawenimusi sargi mule wawename, teepi weebibine itucärenininisi Acejiyame ne acatame teeme mope biname me. ");
INSERT INTO bon_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoane niiye ca äciseja biname te tädepi, weebibine toraca gaabe jiwabipi, yepä weene lica jäätrungepeye teebine, yepä täks rarekaake uutecrena biname piiyepu magebi lui bine daremu jaawenimusi sargi mule wawename, teepi te jäätrungepesi Yoane ne. Ngänuge puu weene ai mule ne jääpänepeye, yepä weene ingwe lica ngenecu yaatatrongäremepeye Yoane ne ätrungame.” ");
INSERT INTO bon_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeesu jiicige egä, “Itecijinege nuuja ngene ca agli mene. Puga ge gawe yageyame biname. Tabe cotäri ne erangige, waina gije itemige, cupicu ne juurige waina kuu ämulecame waina niiye wawena tääpume, siige cabucabu mete ne erangige calwacupi ne awamutame. Piba tabe biname bine calwacupi ecärimige daremu wawename, siige ädige cudecewe cewe me. ");
INSERT INTO bon_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Padare te liba tatyaramtige waina kuu ärucname, tabe teeme kaakesea bägrä bine jityepimige teemanu kupae ne acatame. ");
INSERT INTO bon_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Daremu wawenena biname cina yageyame me kaakesea bägrä bine joomläjecmisi, siige yepä ne etemeläjisi, nuuja ne budre tama eglisi, cuta nuuja ne kula ca jibyecrisi. ");
INSERT INTO bon_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Cuta cääri yageyame te poto kaakesea bägrä bine jityepimige teeme bau me, bucurage bine niinäce cabu ca. Cuta teepi yepä mule ne jepänisi daremu wawenena biname bime bau ca. ");
INSERT INTO bon_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ceräcerägääburage me tabe teemerage bägrä ne jityepige. Tabe jiicige egä, ‘Toraca, teepi pama cäme bägrä ne opo gaabe me ecitenisi.’ ");
INSERT INTO bon_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yepä lui biname cina daremu jewenanisi, teepi liba teeme bägrä ne jepänisi, teepi jiicisi egä, ‘Ai lui yageyamerage me bägrä gyene. Biiri naclege, yaaglesi, mine piba ai calwacupi ne ecatenisi!’ ");
INSERT INTO bon_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Siige puma cita ca teepi teebine joomlisi, isatisi calwacupi kaake poto cidi me, puma budre me eglisi.” ");
INSERT INTO bon_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeesu itemlimige egä, “Waina calwacupi yageyame te liba cire tacnenutepi, tabe ngena cire jaawenepi pui calwacupi daremu wawenena biname bime tääpume?” ");
INSERT INTO bon_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lui biname cina itecijemige, jejisi egä, “Tabe pui niiyarage biname bine budre me cire yaaglecemepi, siige epu biname bine calwacupi cire yääcäremepi, lui cina yageyame ne teemanu kupae cire yääcärepesi ärucna padare cabu.” ");
INSERT INTO bon_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeesu teebibine jejemige egä, “Egäsu weene ituge acnema Oogäräneji mene te ngena jiicenige cäme poto cidi me egä, ‘Lui kula ne raranga biname cina jigyisi, baborage bäbitige iyeta nuuja cabu ca. Ai lui Acejiyame miji wawenäneji gyene; cuta lipu miijirage gyene mime tääpume.’ ");
INSERT INTO bon_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cane weebibine jijenininine, egä Acejiyame te cire lätecitepi weebibine waadename, siige eei bine pa yaawademepi, lui cina miijirage mule bine cire jaawenemepesi. ");
INSERT INTO bon_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Laati te liba ai kula cabu yaatramuge, tabe laglemaluge. Yepä ai kula te liba biname cabu saatramuge, iyeta yäämulicuge.” ");
INSERT INTO bon_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Modamoda iiwäreja biname piiyepu Parisea sigu biname cina lui itecijemige ai ngene ca agli mene, teepi opo ewatnisi, egä Yeesu teeme poto cidi me biiri jiicemige. ");
INSERT INTO bon_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Teepi singi ge teebine oomlaname, yepä teepi wälu ge biname bime name pi, ingle teepi apu ngene jotwanininisi, egä Yeesu Acejiyame me mename biname gyene. ");
INSERT INTO bon_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu biname bine cerämu ebiberäjimige ngene ca agli mene ca. ");
INSERT INTO bon_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Tabe apu jiicige egä, “Acejiyame te liba biname bine yaawadimuge, pui lui epu pana ge mope biname, lui te teeme bägrä tääpume atejäclmuta soriyomu ne jewenige. ");
INSERT INTO bon_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tabe teeme kaakesea bägrä bine jityepimige ala asogläcneji biname bine jajanename soriyomu tääpume otnime, yepä teepi äbwäricinisi otnime. ");
INSERT INTO bon_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Puma cita ca tabe nuuja kaakesea bägrä bine cuta jityepimige teeme bau me apu mene cama egä, ‘Cane soriyomu ne biiri jewenine. Kau piiyepu teeme plongo bine betweclimisi, iyeta gwidape siige amacetnäjäneji gemi. Naaclege atejäclmuta soriyomu tääpume!’ ");
INSERT INTO bon_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yepä ala asogläcneji biname cina singi lica ge, siige teeme gaabe cabu otninisi. Yepä te teeme calwacupi me ädige, nuuja te teeme aletna mete me ädige. ");
INSERT INTO bon_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Poto cina kaakesea bägrä bine joomläjecmisi, etemeläjimisi, budre me eglecimisi. ");
INSERT INTO bon_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mope biname te claabe me äbitige. Tabe teeme cubu biname bine jityepimige budre me aglecame pui biname bine, lui cina teeme kaakesea bägrä bine budre tama eglecimisi, piiyepu teeme babo cewe ne uubuderame. ");
INSERT INTO bon_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Puma cita ca tabe teeme kaakesea bägrä bine ala tesoglicmige, jejemige egä, ‘Cäme bägrä me atejäclmuta soriyomu amacetnäjäneji gyene, yepä ala asogläcneji biname miiji lica gemi ai soriyomu tääpume. ");
INSERT INTO bon_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Peei name pi weene naaclege gaabe cube gome me, laati bine opopa jewenenemiye, ala tesogle-cmeye soriyomu tääpume.’ ");
INSERT INTO bon_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Siige kaakesea bägrä cina eclige gaabe cube gome me, jebasecretnimisi, lui bine opopa jewenanemisi, niiyaniya biname coo miijimiji biname, iyeta. Teepi eclige, siige soriyomu puupu te iyeta tapanige. ");
INSERT INTO bon_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mope biname te tabacitige, biname bine ire jetwananemige, siige yepä biname ne jepänige, lui te soriyomu cäbletääpe cäco tädige. ");
INSERT INTO bon_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tabe teebine jejige egä, ‘Cäme biname, maane lipulipu soriyomu cäbletääpe cäco tabacitite?’ Yepä tabe pui biname te nuuja mene lica. ");
INSERT INTO bon_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Siige tabe mope biname te teeme kaakesea bägrä bine jejemige egä, ‘Teeme ernge ime jetäyemeye, puutucu me ijareye krokeciiye cabu me. Tabe puma ele pa yaangenanege, giricu pa yaatebecmege.’” ");
INSERT INTO bon_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Puma cita ca Yeesu jejemige egä, “Bucurage biname bine ala asogläcneji gemi, nesae bine äjäcräneji gemi.” ");
INSERT INTO bon_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisea sigu biname cina eclige teemämu mene atraname egä, “Mine Yeesu ne lipu itemläjenisi teebine teeme mene cabu ca oomlaname?” ");
INSERT INTO bon_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Puma cita ca teepi poto teeme abiberäja bägrä bine jityepimisi Heroda me sigu biname cama Yeesu bau me. Teepi Yeesu ne jejisi egä, “Abiberäja biname, cine umle gemi, egä maane toraca biname gäte piiyepu cängena ebiberäjenemite Acejiyame me gaabe poto cidi me. Maane nuuja ngenecu lica gäte, biname cina lipu ngene jwaatwanininusi määme poto cidi me, ingle maane teebibine opo gaabe je lica yaacranimute teeme ngii name pi. ");
INSERT INTO bon_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yoo siige, maane nijini, maane lipu ngene jotwanenite, nää mime Cotre te lica niibenininige mine täks rarekaake ceerame Rooma gawe mope biname Siisa ne?” ");
INSERT INTO bon_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yepä Yeesu uja umle äbitige, egä teepi singi gemi teebine teeme mene cabu ca oomlaname, siige tabe jejemige egä, “Weene walya biname gemi! Weene ngena name pi cebine cäme mene cabu ca oomlaname naweniniye? ");
INSERT INTO bon_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Baa rarekaake nawabeye täks tääpume.” Teepi rarekaake ne secanisi. ");
INSERT INTO bon_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tabe puma cita ca itemlimige egä, “Laati me opo piiyepu ngii gemi ai rarekaake cabu?” ");
INSERT INTO bon_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Teepi jejisi egä, “Siisa me opo gyene piiyepu teeme ngii gyene.” Yeesu jejemige egä, “Lui gwidape gemi Siisa me, teebine ecäreye pui; piiyepu lui gwidape gemi Acejiyame me, teebine ecäreye pui. ");
INSERT INTO bon_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Teepi liba itecijemige, mutäcäco äbitininisi teeme mene name pi, siige teepi Yeesu ne ebmalisi, eclige. ");
INSERT INTO bon_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Puirage bimu cabu poto Sadukea sigu biname cina seclige Yeesu bau me. Teepi eei biname gemi, lui cina ätrunga lica, egä budre cabu ca arpinenta pisi nyene. ");
INSERT INTO bon_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Teepi Yeesu ne itemlisi egä, “Abiberäja biname, Moose itu ebiberäjemuji, egä biname te liba bägrä cäco budre läbituge, teeme igane te miiji cuubla ne acata siige bägrä wawena teeme naane me ngii tääpume. ");
INSERT INTO bon_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Siige nuuja taje puga ge seben naniganewaleyame. Teepi aga yaacrajanemepi. Uuge te coga ne waacatepi, bägrä cäco budre läbitepi, siige teeme cuubla ne twaabmalepi teeme gomecayame igane tääpume. ");
INSERT INTO bon_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cuta peeirage mule te läbitepi teeme tääpume, cuta teeme gome ca lui igane tääpume, cuta iyeta pui seben naniganewaleyame bime tääpume. ");
INSERT INTO bon_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ceräcerägääbu cuubla te budre läbitepi. ");
INSERT INTO bon_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tabe laati me coga cire waanajepi, budre biname cina liba cire larpinäripesi, ingle tabe iyeta pui seben naniganewaleyame bime coga gwene?” ");
INSERT INTO bon_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu jejemige egä, “Ingle weene umle lica gemi Oogäräneji mene piiyepu Acejiyame me kokre, weene peei name pi betäjiye. ");
INSERT INTO bon_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Biname cina liba budre cabu ca cire larpinäripesi, teepi epu pana cire yaacrajemepi Acejiyame me mename seemo cina cabucewe je liiyepu. Teepi atejäclmuta lica cirege. ");
INSERT INTO bon_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Egäsu weene ituge acnema Acejiyame te ngena itu jijinuji budre biname bime arpinera poto cidi me. Tabe apu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Cane lui Abrahamo, Isacako, Yakobu naabibime Acejiyame gäne.’ Siige tabe nata budre biname bime Acejiyame lica gyene yepä eei bime, lui cina ireclota gemi.” ");
INSERT INTO bon_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lui biname cina itecijemige, teepi mutäcäco äbitininisi Yeesu me abiberäja mene name pi. ");
INSERT INTO bon_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisea sigu biname cina liba itecijemige, egä Yeesu Sadukea sigu biname bine mene cäco me jewenimige, teepi tomi yootisi. ");
INSERT INTO bon_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Puma cita ca teeme yepä te, lui cotre abiberäja biname ge, tabe singi Yeesu ne mene cabu ca oomlaname. Tabe itemlige egä, ");
INSERT INTO bon_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Abiberäja biname, Moose lui Cotre nicärininuji, lui gyene baborage?” ");
INSERT INTO bon_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu jejige egä, “‘Weene miiji singi äbitena Yageyame, weeme Acejiyame tääpume, siige ai ne aboclomta iyeta weeme owecu mule ca, iyeta weeme ireclota ca, iyeta weeme ngene atwanena ca.’ ");
INSERT INTO bon_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ai cotre lui niinäcegaabe cotre gyene, piiyepu baborage gyene. ");
INSERT INTO bon_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pui gomecayame baborage cotre lui age sena: ‘Weene miiji biname bime tääpume singi lenaja, weene lipu weeme tääpume singi birige.’ ");
INSERT INTO bon_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ai neeneni cotre cabu peete nemi iyeta Moose me Cotre mene piiyepu Acejiyame me mename biname bime abiberäja mene.” ");
INSERT INTO bon_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Poto Parisea sigu biname cina liba yepä cewe me tabasecre-tnige, Yeesu teebibine itemlimige egä, ");
INSERT INTO bon_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Weene lipu ngene jotwanininiye, egä Keriso biname bine lui te niiya cabu ca cire yääsecräremepi, tabe laati me kaakesaare gyene?” ");
INSERT INTO bon_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Teepi jejisi egä, “Tabe mope biname Daawida me kaakesaare gyene.” Yeesu puma cita ca itemlimige egä, “Cije piba ngena name pi Aceji Seemo te Daawida ne ngene atwana ecäruji tabe Keriso ne Yageyame ca ainame? Tabe Daawida apu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yageyame te cäme Yageyame ne jejuji: Ama adnati cäme camu poto cidi ca ngälu cane määme cubuyame bine määme ernge gawe me cire yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cije piba Keriso lipu gyene Daawida me kaakesaare, Daawida liba teebine Yageyame ca einuji?” ");
INSERT INTO bon_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nuuja biname te äblicäco Yeesu ne daremu mene awecnistame, siige pui padare cabu ca niinäce gaabe me teepi wälu icrajimige Yeesu ne ätemlejame. ");
INSERT INTO bon_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Puma cita ca Yeesu biname bine piiyepu abiberäja bägrä bine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Cotre abi-beräja biname piiyepu Parisea sigu biname bime conocäco pisi nyene Moose me Cotre mene bine aboclomäjame. ");
INSERT INTO bon_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Peei name pi weene miiji ätrunga piiyepu äcwetna, teepi ngena tääpume jijinusi wawename, yepä weene gone teebibine jäätutanemuye, ingle teepi teeme abiberäja mene ibi lica läbitininusi. ");
INSERT INTO bon_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Piti nemi bucurage mäpurage cotre. Teepi singi gemi biname cina pui bine äcwetname, yepä teepi nuuja gwidape ne lica jaawenusi biname bine ätityerame pui cotre bine äcwetname. ");
INSERT INTO bon_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Teepi iyeta gwidape bine jaawenimusi biname cina päpäna taatu name pi. Teeme puga ge matimati boks Moose me Cotre mene äbäcname, siige mangace piiyepu ime cabu seea ca jäätäyimusi. Teepi peei boks bine daamledamle jaawenimusi biname cina päpäname. Teepi cuta teeme cäbletääpe fooa mutre cabu lecaleca wul seea sigu bine yaaterutäjimusi. ");
INSERT INTO bon_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Soriyomu ne liba yaaclitusi, teepi miijimiji puupu cabu ladnatäruge, cuta abasecretna mete cabu piiyepu teepi niinäce gaabe me ladna-täruge. ");
INSERT INTO bon_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Teepi baborage singi birige aletna puupu cabu biname cina teebibine cängenarage awablame piiyepu abiberäja biname ca ainame. ");
INSERT INTO bon_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yepä weebibine gone abiberäja biname ca aina, ingle weeme yepä taatu abiberäja biname gyene, piiyepu weene iyeta naniganewaleyame gemi. ");
INSERT INTO bon_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Weene gone ai gawecewe cabu weemeweme babe ca lainininuye, ingle weeme yepä taatu Babe pisi nyene cabucewe je. ");
INSERT INTO bon_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Cuta weene gone weeme nuuja ne babo biname ca yaainuye, ingle cane Keriso lui weeme yepä taatu babo biname gäne. ");
INSERT INTO bon_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Laasi nyene weeme baborage, tabe miiji birige weeme kaakesea bägrä lenaja. ");
INSERT INTO bon_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Laati te teemämu babo me läbituge, teebine matikolä me birige wawena; laati te teemämu matikäli me läbituge, teebine babo me birige wawena.” ");
INSERT INTO bon_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea sigu biname! Weene lui walya biname gemi! Weene gaabe ne yaarmuye biname cina Acejiyame bau me otnime. Weene lica yääbäcnuye piiyepu cuta jiibemuye lui cina singi gemi äbäcname. ");
INSERT INTO bon_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea biname! Weene lui walya biname gemi! Weene niinäce cuublacubla bime gwidape bine angletneja mule ca yaawadimuye, piba sinäme lecaleca irecu lätumutinuye, ingle weene singi gemi weeme peei angletneja mule ne acwabame. Peei name pi weeme daremu niiyarage gyene poto biname bime daremu cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea biname! Weene walya biname gemi! Weene iyeta poto ta waatnetnäjinuye, malu cabu ta piiyepu doro cabu ta, naace tääpume biname ngänu gyene tabe puu yepä, teebine atatrongtame weeme mule cabu me. Tabe liba weeme mule cabu me labacituge, weene teebine weeme cabu ca neeneni gääbu niiyarage me jaawenuye, siige tabe uliobo puupu cabu me cirege otni weene liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lipu mäpu cirege weeme tääpume weene irecu määsumäsu gaabe awabeja biname! Weene yaabiberäjimuye, egä laati te liba iiwäreja mete me ngii cama mene jiicemuge, papa gyene tabe peei mene ne atropengta. Yepä laati te liba iiwäreja mete cabu lui gol, pui me ngii cama mene jiicemuge, pui mene ne tabe äblicäco atropengta. ");
INSERT INTO bon_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Weene irecu määsumäsu buduma biname gemi! Egäsu gol matikäli birige, yepä iiwäreja mete lui te pui gol ne Acejiyame tääpume mara me jaawenuge, tabe baborage birige. ");
INSERT INTO bon_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Cuta weene yaabiberäjimuye, egä laati te liba mene jiicemuge iiwäreja mete cabu lui iiwäreja dade, teeme ngii cama, papa gyene tabe pui mene ne atropengta. Yepä laati te liba mene jiicemuge owecu gwidape me ngii cama, lui pui iiwäreja dade papa cabu, pui mene ne tabe äblicäco atropengta. ");
INSERT INTO bon_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Weene irecu määsumäsu biname gemi! Egäsu owecu gwidape matikäli gyene, yepä dade lui te pui owecu gwidape ne Acejiyame me tääpume mara me jaawenuge, tabe baborage gyene. ");
INSERT INTO bon_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yoo, laati te liba mene jiicemuge iiwäreja dade me ngii cama, tabe cuta iyeta owecu gwidape bime ngii cama jiicemuge, lui pui dade papa cabu. ");
INSERT INTO bon_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Cuta laati te liba mene jiicemuge iiwäreja mete me ngii cama, tabe cuta Acejiyame me ngii cama jiicemuge, puma lui te enajenige. ");
INSERT INTO bon_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Coo laati te liba mene jiicemuge cabucewe me ngii cama, tabe cuta Acejiyame me adnata puupu me ngii cama jiicemuge cuta piiyepu teeme ngii cama, lui te enajenige puma. ");
INSERT INTO bon_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea sigu biname! Weene lui walya biname gemi! Weene Acejiyame ne yepä yääcäruye weeme iyeta ten deedei mite wawena gwidape ngii minti, dili, kumina cabu ca, ngänu gyene Cotre cabu pui mule lui baborage lica gyene. Yepä weene lica jaawenimuye conocäco mule, owecu mule piiyepu toraca mule, Cotre cabu lui cina modamoda mule gemi. Weene miiji ai modamoda mule bine wawenetnäja, cuta gone ngene ätrimela poto matimati mule bine wawenetnäjame. ");
INSERT INTO bon_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Weene irecu määsumäsu gaabe awabeja biname gemi! Weene matimati cotre bine cängena yääcwetnimuye, yepä modamoda cotre bine jaatropengäjimuye. Weeme peei mule lui epu pana gyene, egä iidreba lui matikäli jugi gwidape gyene, weene weeme nani niiye ne sobläbi cabu yaapaduruye pui te ätyepurame, yepä weene kamela ne yäärmituye, lui baborage jugi gwidape gyene. ");
INSERT INTO bon_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea sigu biname! Weene lui walya biname gemi! Weene kaapo piiyepu pleito bine kaakepoto ca taatu jääcisäjemuye, yepä ngalebora ca weene jäängärimuye angletneja mule ca piiyepu ceera cäco mule ca. ");
INSERT INTO bon_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Irecu määsumäsu Parisea biname, weene niinäce miiji jicisäjemeye kaapo bora ngena jugi piti nemi, piba cuta kaakepoto ca jugi cäco yaanajuge. ");
INSERT INTO bon_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea sigu biname! Weene lui walya biname gemi! Weene epu pana gemi, kula bora gape lui owe poto bulu ca yaaganusi, siige kaake poto ca opo lacituge, yepä ngalebora apanäneji gyene budre biname bime kaake ca piiyepu poto jugijugi gwidape ca. ");
INSERT INTO bon_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cuta pepu gyene, biname cina weebibine jipänininusi, egä weene miiji biname gemi, yepä weeme ngalebora pisi nyene walya piiyepu niiya mule.” ");
INSERT INTO bon_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Lipu mäpu cirege weeme tääpume weene cotre abiberäja biname piiyepu Parisea sigu biname! Weene lui walya biname gemi! Weene kula gape bine yaarangimuye Acejiyame me mename biname bime tääpume piiyepu conocäco biname bime ngene ape-cna kula bine yaabasogärimuye. ");
INSERT INTO bon_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Weene jiicemuye egä, ‘Sasa cine liba cire ninajineji cime saarewale cama, cine lica cire yaaglecemejisi budre me Acejiyame me mename biname bine teepi liiyepu.’ ");
INSERT INTO bon_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yepä apu pi weene awabudnäjininiye, egä weene teeme kaakesaare gemi, lui cina Acejiyame me mename biname bine budre me eglecimujisi. ");
INSERT INTO bon_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yoo, weene jimlitäjepeye weeme saarewale cina lui gije itu jebacitujisi mename biname bine aglecame! ");
INSERT INTO bon_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Weene cobyame gemi, cobyame bime bägrä gemi! Weene äblicäco uucratna atrana cabu ca, yepä weebibine cirege atrana uliobo puupu cabu me otnime! ");
INSERT INTO bon_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cane mename biname bine, umleumle biname bine piiyepu cotre abiberäja biname bine cire jäätyepemepene weeme bau me. Weene poto bine budre me cire eglecemepeye, poto bine baarge uli cabu cire jibyecremepeye, poto bine cire etemeläjemepeye weeme abasecretna mete cabu ta piiyepu cire iyecräjemepeye yepä cewe ca nuuja cewe me. ");
INSERT INTO bon_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pipu pi iyeta niiya daremu cina conocäco biname bime agleca name pi weeme bau me cire saaclepi, conocäco biname Abela me agli cabu ca ngälu Baraki me bägrä Sakariya teeme agli cabu me, weeme kaakesaare cina lui ne budre me eglujisi iiwäreja mete puutucu cabu iiwäreja dade gome. ");
INSERT INTO bon_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cane toraca mene jijenininine, page lui biname cina icrajinige, teepi te iyeta agleca daremu ne cire jääpänepesi.” ");
INSERT INTO bon_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalema biname, Yerusalema biname, weene te Acejiyame me mename biname bine budre me yaaglecimuye piiyepu cuta Acejiyame me ätyepäneji biname bine kula ca jääbyecrimuye. Bucurage gääbu cane singi ituge weebibine cäme bau me abasecretna, epu pana paulo te teeme plongo bine lipu taabasecretnimuge teeme taame ca ätrugerame, yepä weene singi lica ituge. ");
INSERT INTO bon_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ingle weene cebine nägyuye, peei name pi weeme cewe piiyepu Acejiyame me mete cirege kaake lenaja. ");
INSERT INTO bon_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cane jijenininine weebibine, egä weene ingwe ca cebine cääri lica cire näpänepeye, ngälu weene liba cire najepeye egä, ‘Maane lui te tädenite Yageyame me ngii cabu, Acejiyame te meebine miiji mule naawenege!” ");
INSERT INTO bon_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeesu liba iiwäreja mete ne ebmalige, siige ädige, abiberäja bägrä cina piba seclige teebine awabetnärame poto kula ca rarangäneji mete, lui iiwäreja mete caale bora jage. ");
INSERT INTO bon_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeesu teebibine jejemige egä, “Weene ire iyeta ai nema! Cane weebibine toraca jijenininine, egä lica yepä kula ne cirege abmala teeme puupu cabu ai mete cabu. Iyeta bine cirege äyära gawe me.” ");
INSERT INTO bon_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeesu liba adnatäneji enajige Olibi Uli podo cabu je ten taatu, abiberäja bägrä cina seclige, itemlisi egä, “Nijini cibibine, egä maane lui gwidape tääpume nijinite, liba cire läbitipesi. Ngena cina cirege äbitena awabame, egä maane tacnenite piiyepu ai padare me ngälugaabe te joomlenige?” ");
INSERT INTO bon_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu jejemige egä, “Weene ireire inajipi! Gone ire taatu acrana weebibine angletnejame. ");
INSERT INTO bon_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bucurage biname cina cire saaclepi cäme ngii cabu, siige cire jiicemepesi egä, ‘Cane age säne Keriso, biname bine lui te niiya cabu ca pa yääsecräremepene,’ siige bucurage biname bine cire yaangletnäjemepesi. ");
INSERT INTO bon_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Weene mameta cubu ala cirege ätecijana piiyepu weene idre cire itecijanipi cubu poto cidi me cudecewe je, yepä wälu gone läbitininuye. Pepu gwidape cina miiji cire läpletnicipesi, yepä cäro padare me ngälugaabe camu gyene. ");
INSERT INTO bon_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yepä gawe biname cina cubu cire jiicepesi nuuja gawe biname cama. Yepä babo mope biname te nuuja cama cubu cire jiicepi. Iyeta poto ta gane piiyepu ocneja cirege. ");
INSERT INTO bon_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yepä ai iyeta lui mäpu padare me agedna taatu gyene, epu mäpumäpu magebi te lipu cupace laplongamtuge bägrä ärngi tääpume. ");
INSERT INTO bon_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pui mäpu padare cabu weebibine cire joomläjipesi, siige cire icäripesi mäpu cabu lenajame piiyepu budre me aglecame. Iyeta biname cina cämiji pi cire jimugetnipesi weebibine. ");
INSERT INTO bon_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bucurage biname cina piba teeme ätrunga bine cire yaabmalecmepesi. Teepi teemeteme cire laitnäjipesi, cire lämugetnäjipesi. ");
INSERT INTO bon_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bucurage walya mename biname cina cire saaclepi, teepi siige bucurage biname bine cire yaangletnäjemepesi. ");
INSERT INTO bon_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ingle naace popi conocono mule te daamledamle cire läbitepi, peei name pi biname cina singi cäco cire läbitipesi cäme tääpume. ");
INSERT INTO bon_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yepä laati te ngenecu kokre cire yaanajepi ngälu ngälugaabe, tabe iyeteta ireclota ne cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iyeta poto ta ai gawecewe cabu biname bine cirege jajanena Miiji Mene Acejiyame te biname bine waadena poto cidi me. Pipu pi iyeta maramara gawe biname cirege ätecija, piba ai padare me ngälugaabe cire tädepi.” ");
INSERT INTO bon_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Acejiyame me mename biname Daniyela lui niiyarage wälumeteyame poto cidi me jiicuji, weene liba cire jepänepeye aclajuteji puupu cabu, Acejiyame tääpume lui puupu ne mara me ituge wawena,” (acnema biname tabe miiji umle ai ngena tääpume myene), ");
INSERT INTO bon_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“piba lui biname cina cire yaacrajepi Yuudea probins cabu, teepi miiji podo cabu me uucratna. ");
INSERT INTO bon_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lui biname te mete toro cabu lui puupu cabu cire yaanajepi, tabe miiji lica cirege mete bora me abacita gwidape waadename. ");
INSERT INTO bon_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lui biname te calwacupi je, tabe miiji lica cirege acnenuta teeme cäbletääpe acatame. ");
INSERT INTO bon_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ogi nemi pui padare cabu lui mäpumäpu magebi piiyepu bägrä ngame meeramera magebi. ");
INSERT INTO bon_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Irecu ätumutipeye, egä weene gäbu padare cabu coo Sabade bimu cabu lica cirege uucratna, ");
INSERT INTO bon_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ingle pui padare cabu lui mäpu cirege, epu baborage cirege, egä niinäce pepu mäpu ne lica ituge päpäna ai gawecewe me agedna cabu ca ngälu page ai taje piiyepu ingwe ca cääri lica cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yoo, Acejiyame te teeme ngene atwanena cabu pui mäpu padare ne uja tuube me itu jewenuji. Tabe liga pepu lica cire jaaweneji, biname cina ireclota lica cire yaacrajemepi. Yepä tabe pui padare ne tuube me cire jaawenepi teeme äjäcräneji biname bime name pi. ");
INSERT INTO bon_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Siige pui padare cabu laati te liba cire jijipi egä, ‘Keriso age sena,’ coo egä ‘Tabe peese nyene,’ weene gone ätrunga. ");
INSERT INTO bon_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Walya Keriso piiyepu walya mename biname cina cire saaclepi. Teepi ciitaca mule bine piiyepu cälu te äti mule bine cire jaawenanemepesi Acejiyame me äjäcräneji biname bine angletne-jame, teepi liba ibibi cirege peei ne wawename. ");
INSERT INTO bon_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Weene ngene gone jitrimalinuge, egä cane ai mule poto cidi me niinäce gaabe me ituge jajanena. ");
INSERT INTO bon_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Biname cina liba weebibine cirege jaji egä, ‘Keriso lui daapo taatu cewe cabu sine,’ gone naacluge piiyeme. Coo teepi liba cirege jaji egä, ‘Tabe mete cabu ämlitäneji enajenige,’ gone jäätrunguye. ");
INSERT INTO bon_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cane, Acejiyame bau ca lui te tädujine biname me äbitujine, paamlepamle pana cire tacnepene, lui te twaaplacmeläjuge carbe cabu bimu acita gome ca bimu äpula gome me. ");
INSERT INTO bon_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Budrekaake luma, sändäyame cina piiyeme labasecretnuge.” ");
INSERT INTO bon_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pui mäpu padare ingwe gaabe ca piba taatu bimu te krokeciiye me cire läbitepi, mabye te lica cire saapaclyärepi, wale cina cabu ca cire saatrametnemepi piiyepu dume cabu lijalija nuuja gwidape gemi, teepi teeme otnetneja gaabe cabu ca cire läyeblengäjipesi. ");
INSERT INTO bon_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Piba cane lui te Acejiyame bau ca tädujine biname me äbitujine, cäme cewecu te cire taboclomtepi carbe cabu, siige iyeta maramara gawe biname cina ele cire yaangenetnemepi, teepi liba cebine, Acejiyame bau ca lui te tädujine biname me äbitujine, cire näpänepesi carbe cabu äina baborage kokre piiyepu jamyacu apaclyera cama. ");
INSERT INTO bon_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Baborage moole te liba cire saange-nepi, cane cäme mename seemo bine cire jäätyepemepene Acejiyame me äjäcräneji biname bine abasecretname iyeta poto ca ai gawecewe cabu.” ");
INSERT INTO bon_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Weene abiberäjineye piigi uli cabu ca. Teeme ciipe cina liba migi ca tapanininusi, ngänglä laame liba taawenimuge, weene piba umle gemi, egä kämäge mameta gyene. ");
INSERT INTO bon_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pepu gyene, weene liba ai gwidape bine cire jepänanemepeye, weene umle gemi, egä cäme otni lui mameta gyene. Cane grana gome säne. ");
INSERT INTO bon_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cane toraca mene jijenininine, egä biname lui cina ireclota page ai taje, teepi iyeta budre lica cirege äbita, ngälu iyeta ai mule cina liba cire läbitipesi. ");
INSERT INTO bon_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dume piiyepu gawe cirege apira, yepä cäme mene te lica cirege apira.” ");
INSERT INTO bon_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nuuja biname te umle lica gyene lui bimu coo padare cabu cane cire täinepene. Acejiyame me mename seemo cina cabucewe je umle lica gemi, cane Bägrä te umle lica gäne, yepä tabe Babe taatu umle gyene. ");
INSERT INTO bon_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane liba cire täinepene, pui padare lui epu pana cirege Nooa me padare liiyepu. ");
INSERT INTO bon_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Igi me niinäce gaabe biname cina piba yäärwäjimusi, yäänäjimusi, lawadricninusi ngälu puirage bimu, Nooa liba acenutuji baborage buto cabu me. ");
INSERT INTO bon_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Teepi nuuja umle lica ge, egä ngena te äbitinige, ngälu igi te liba tädige, iyeta teebibine yiisibrecmige. Pepu cirege äbita, cane lui te Acejiyame bau ca tädujine biname me äbitujine, liba cire tacne-nutepene. ");
INSERT INTO bon_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pui padare cabu neeneni rooriye cina kaakesea cire jaawenepäsi calwacupi cabu; nuuja ne cire yaacatepesi, nuuja ne cire yaabmalepesi. ");
INSERT INTO bon_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Neeneni magebi cina wiiti kuu bine kula ca cire jäämulecemepäsi; nuuja ne cire waacatepesi, nuuja ne cire waabmalepesi. ");
INSERT INTO bon_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Weene amacetnäjäneji inajipi, ingle weene umle lica gemi, lui bimu cabu weeme Yageyame te cire tädepi. ");
INSERT INTO bon_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mete yageyame te liba umle je, egä eromaame te liba tädenige, tabe piba ireclota yaanajuge. Tabe ire taatu lica jaacituge eromaame te teeme mete me abacita. ");
INSERT INTO bon_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mete yageyame te lipu ireclota yaanajuge ingle eromaame te abacita wälu, weene miiji cuta pepu amacetnäjäneji lenaja, ingle cane lui te Acejiyame bau ca tädujine biname me äbitujine, cane weeme umle cäco padare cabu cire tädepene.” ");
INSERT INTO bon_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Laasi nyene toraca ngenecu piiyepu umle cama kaakesea bägrä? Tabe peese nyene, teeme babo biname te lui ne ituge acita teeme nuuja kaakesea bägrä bine ire atwime, egä teepi toraca padare cabu deedei yaawadanemusi. ");
INSERT INTO bon_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pui kaakesea bägrä te lipu gege birige, teeme babo biname te liba tacnenutuge, siige jääpänuge, egä tabe cängena kaakesea jaawenuge. ");
INSERT INTO bon_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cane toraca jijenininine, egä teeme babo biname te jaajuge tabe iyeta gwidape bine ire atwemame. ");
INSERT INTO bon_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yepä tabe liba niiyarage kaakesea bägrä birige, tabe lajuge egä, ‘Cäme babo biname te wata lica tacnenutenige,’ ");
INSERT INTO bon_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","siige puma cita ca gije jaacranimuge poto kaakesea bägrä bine aglecame piiyepu ärwäjame, änäjame poto nänäja biname cama. ");
INSERT INTO bon_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Puma cita ca teeme babo biname te tacnenutuge tabe lui padare cabu lica jaawagrijuge, ");
INSERT INTO bon_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","siige teebine mage yaagluge. Tabe nuuja walya biname bime cama yepä ibi daremu ne yaacatuge: tabe teta cama läduge uliobo puupu cabu me, ele puma yaangenanenuge piiyepu giricu yaatebicmuge.” ");
INSERT INTO bon_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Pui padare cabu cane liba cire tacnenutepene, Acejiyame te lui biname bine yaawadimuge, teepi lui ten ngulebägrä pana cirege, lui cina lampa cama eclige teeme ciwelooloyame ne awacletnäjame. ");
INSERT INTO bon_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Poto faib lui buduma ge, poto faib lui umleumle ge. ");
INSERT INTO bon_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Buduma ngulebägrä cina teeme lampa bine ewadimisi, yepä teepi tuwängle niiye bine lica ewadimisi. ");
INSERT INTO bon_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Umleumle ngulebägrä cina, teepi teeme lampa bine ewadimisi cuta tuwängle niiye. ");
INSERT INTO bon_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ciwelooloyame te däägurage täbitige, peei name pi ngulebägrä cina ute me jicriranemige, siige ograrige. ");
INSERT INTO bon_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ciiye duusa liba joomlige, teepi ala itecijemige egä, ‘Ciwelooloyame te tädenige! Naaclege teebine awacletnäjame!’ ");
INSERT INTO bon_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Puma cita ca iyeta ngulebägrä cina arpineräjininisi, lampa bine emacetnäjimisi, jebotanemisi. ");
INSERT INTO bon_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Buduma ngulebägrä cina jejemisi umleumleyame bine egä, ‘Cime niiye nicärineye, ingle cime lampa cina siige ätumetnenige.’ ");
INSERT INTO bon_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Umleumle ngulebägrä cina jejemisi egä, ‘Cine äblicäco gemi weebibine ceera, ingle ibibi lica gemi weene piiyepu cine. Äte aletna mete me naaclege weeme tääpume aletna-me.’ ");
INSERT INTO bon_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Siige buduma ngulebägrä cina eclige aletname. Teepi liba puga ge, piba ciwelooloyame te tatyaramtige. Siige lui cina amacetnäjäneji ge, teepi teta cama eclige, ebäcnisi atejäclmuta soriyomu tääpume, siige grana te tarmige. ");
INSERT INTO bon_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ingwe ca buduma ngulebägrä cina tatyarige, jiicisi egä, ‘Babo biname, babo biname, cine yääbäcnesi!’ ");
INSERT INTO bon_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ciwelooloyame te puma cita ca teebibine tejemige egä, ‘Cane toraca jijenininine, egä cane umle lica gäne weene.’” ");
INSERT INTO bon_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Puma cita ca Yeesu jejemige egä, “Peei name pi weene ireire inajipi, ingle weene umle lica gemi padare coo bimu cäme acnenuta tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pui padare cabu cane liba cire tacnenutepene, Acejiyame te lui biname bine yaawadimuge, teepi yepä babo biname me nesae kaakesea bägrä pana gemi. Yoo, pui babo biname te otnime äbitige cudecewe cewe me. Tabe teeme kaakesea bägrä bine ala tesoglicmi-ge, jejemige teeme gawe piiyepu gwidape bine ire atwemame. ");
INSERT INTO bon_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tabe rarekaake yepäyepä ecäranemige teeme ngene atwanena ibi teepi pui ca kaakesea wawename ingwe ca awecna tääpume. Tabe yepä ne faib tausen rarekaake ecärige, cuta nuuja ne neeneni tausen rarekaake ecärige, cuta nuuja ne yepä tausen rarekaake ecärige, siige tabe abyemärige otnime. ");
INSERT INTO bon_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lui kaakesea bägrä te faib tausen rarekaake ewadimige, tabe piba taatu kaakesea jewenimige pui rarekaake ca, siige nuuja faib tausen jepänimige. ");
INSERT INTO bon_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pipu pana mule te äbitige neeneni tausen rarekaake bine lui kaakesea bägrä te ewadimige, tabe cuta jepänimige nuuja neeneni tausen. ");
INSERT INTO bon_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yepä lui kaakesea bägrä te yepä tausen rarekaake bine ewadimige, tabe ädige, gawe ne juurige, imletnige teeme babo biname me rarekaake bine. ");
INSERT INTO bon_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lecaleca padare ingwe ca babo biname te piba tacnenutige, ala taasogläcnige teeme kaakesea bägrä bine teebine awabame, egä teepi luma ngälu kaakesea ituge wawena teeme rarekaake ca. ");
INSERT INTO bon_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lui kaakesea bägrä te yaawademepi faib tausen rarekaake, tädige, nuuja faib tausen sewadimige, jejige egä, ‘Babo biname, maane faib tausen rarekaake näcärepete. Age sena nuuja faib tausen, cane lui bine ituge päpäna.’ ");
INSERT INTO bon_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Babo biname te jejige egä, ‘Babo miijirage! Maane miijirage kaakesea bägrä gäte, cängena lipu ire tetwumete matikäli rarekaake ne, siige cane naacitenine bucurage bine ire atwemame. Tädi cäme soriyomu cabu me cane cama gege me!’ ");
INSERT INTO bon_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Puma cita ca lui kaakesea bägrä te neeneni tausen rarekaake bine yaawademepi, tädige, babo biname ne jejige egä, ‘Babo biname, maane cebine neeneni tausen rarekaake näcärepete. Age sena nuuja neeneni tausen, cane lui bine ituge päpäna.’ ");
INSERT INTO bon_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Teeme babo biname te jejige egä, ‘Babo miijirage! Maane miijirage kaakesea bägrä gäte, cängena lipu ire tetwumete matikäli rarekaake ne, siige cane meebine naacitenine bucurage bine ire atwemame. Tädi cäme soriyomu cabu me cane cama gege me!’ ");
INSERT INTO bon_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Cuta lui kaakesea bägrä te yaawademepi yepä tausen rarekaake bine, tädige babo biname bau me, jejige egä, ‘Babo biname, cane umle gäne, egä maane owelale biname lica gäte. Maane emä yäärucnimute, maane luma lica yäätemimute; maane emä taabasecretnimute, kuu gije bine luma lica yiisabäjemute. ");
INSERT INTO bon_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cane wälu ge, peei name pi lädepene, määme rarekaake gawe bora yäämletnepene. Siige age sena, maane lui näcärepete.’ ");
INSERT INTO bon_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tabe babo biname te jejige egä, ‘Maane niiyarage durau kaakesea bägrä gäte. Maane umle ge, egä cane emä yäärucnimune, luma lica yäätemimune piiyepu emä taabasecretnimune, luma kuu gije bine lica yiisabäjemune. ");
INSERT INTO bon_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maane cäme rarekaake cire yaacranejite rarekaake ire atwi mete cabu, siige cäme acnenuta padare cabu cane cerämu cire jääpänemejine niinäce rarekaake me kaakesea cabu ca. ");
INSERT INTO bon_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ewademeye peei rarekaake bine teeme bau ca, ecäreye laati me ten tausen rarekaake piti nemi. ");
INSERT INTO bon_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lui biname me umle pisi nyene, teebine cerämu ceera, siige teeme umle te babo läbituge. Yepä lui biname me umle lica gyene, piiyepu tabe singi lica abiberäjame, teeme tääpume nuuja gaabe lica gyene tabe umle ne päpäname. ");
INSERT INTO bon_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ai niiyarage kaakesea bägrä ne puutucu me ijareye krokeciiye cabu me. Tabe puma ele cire yaangenanepi, giricu cire yaatebecmepi.’” ");
INSERT INTO bon_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane liba cabucewe cabu ca cire täinepene cäme jamyacu apaclyera cama piiyepu cäme mename seemo cama, cane piba cäme babo adnata puupu cabu cire ladnatepene biname bine atraname. ");
INSERT INTO bon_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iyeta gawe maramara biname bine cirege abasecretna cäme opo gaabe me. Cane teebibine cire jaabelanemepene neeneni sigu wawename, maamoi ire atwi biname te lipu maamoi piiyepu gouti bine jaabelanemuge maramara sigu me. ");
INSERT INTO bon_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cane piba maamoi bine cäme camu poto cidi me cire yaacranemepene piiyepu gouti bine cäme säwäci poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Piba cane mope biname te cire jaajemepene cäme camu poto cidi ca biname bine egä, ‘Cäme Babe te weebibine miiji itu jiwenaninuji, siige naaclege iyeteta ireclota cabu me. Tabe peei ne weeme tääpume ituge amacetnäja, tabe lui padare cabu gawecewe ne yootonutuji. ");
INSERT INTO bon_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cane loolomecewe ge, weene deedei näcärujiye; niiyemecewe ge, weene niiye näcärujiye. Cane ciitaca biname ge, weeme cewe me tatyaramtujine, weene nawablujiye, weeme mete me nacanujiye. ");
INSERT INTO bon_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cane cuutacuta ge, weene cäbletääpe nasigrujiye; cane pita cama ge, weene nängrärujiye. Cane krokeciiye mete cabu liba, weene nädärujiye.’ ");
INSERT INTO bon_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cäme camu poto cidi ca conocäco biname cina teepi piba cebine cire najepesi egä, ‘Yageyame, cine liba meebine nääpänujisi loolomecewe, siige deedei nääcärujisi; coo piiyepu niiyemecewe, siige niiye nääcärujisi? ");
INSERT INTO bon_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Cine liba nääpänujisi ciitaca biname, siige naawablujisi, cime mete me naacanujisi, coo cuutacuta je cäbletääpe naasigrujisi? ");
INSERT INTO bon_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Cine liba nääpänujisi pita jajwi je, siige näängrärujisi, coo piiyepu krokeciiye mete cabu liba, siige cine meebine näädärujisi?’ ");
INSERT INTO bon_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Puma cita ca cane babo mope biname te teebibine cire jaajemepene egä, ‘Cane toraca mene jijenininine weebibine, egä weene ngena jewenujiye cäme ai papa biname yepä tääpume, peei lui weene cäme tääpume jewenujiye.’ ");
INSERT INTO bon_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Puma cita ca cane cire jaajemepene cäme säwäci poto cidi biname bine egä, ‘Acejiyame te weebibine niiya daremu cire icäripi. Äyeblengäjinineye cäme bau ca ngälu cäco uliobo cabu me, lui amacetnäjäneji gyene Diyabolo piiyepu teeme mename seemo bime tääpume. ");
INSERT INTO bon_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cane loolomecewe ge, yepä weene deedei lica näcärujiye. Cane niiyemecewe ge, weene niiye lica näcärujiye. ");
INSERT INTO bon_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cane ciitaca biname ge, weene lica nawablujiye, weeme mete me lica nacanujiye. Cane cuutacuta ge, weene cäbletääpe lica nasigrujiye. Cane pita cama ge piiyepu krokeciiye mete cabu jage, yepä weene lica nängrärujiye.’ ");
INSERT INTO bon_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Piba teepi cebine cire najepesi egä, ‘Yageyame, liba cine meebine loolomecewe nääpänujisi coo piiyepu niiyemecewe coo ciitaca biname, cuutacuta biname, piiyepu pita cama biname, krokeciiye mete cabu biname, siige cine piba meebine lica näätityärujisi?’ ");
INSERT INTO bon_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Cane teebibine cire jaajemepene egä, ‘Weene liba cäme ai papa biname yepä ne ätityera cäco ituge, peei lui weene cebine ätityera cäco ituge.’ ");
INSERT INTO bon_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Teepi siige niiyarage daremu ne cire jääpänepesi, lui iyeteta gyene; yepä conocäco biname, teepi cire jääpänepesi iyeteta ireclota ne.” ");
INSERT INTO bon_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeesu liba teeme abiberäja mene bine epirimige, tabe teeme abiberäja bägrä bine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Weene umle gemi, egä neeneni bimu niinäce gaabe äsuplengta trii te liba pa yaanajepi, cane lui te Acejiyame bau ca tädujine biname me äbitujine, cebine piba pa nacitepesi biname bime ime cabu teepi cebine baarge uli cabu äbyecrame.” ");
INSERT INTO bon_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Puma cita ca modamoda iiwäreja biname piiyepu poto modamoda biname cina abasecretnige iiwäreja mope biname ngii Kayapa me mete cabu me. ");
INSERT INTO bon_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Teepi mene jewenisi Yeesu ne ogä oomlaname siige budre me acitame. ");
INSERT INTO bon_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Teepi jiicisi egä, “Mine trii padare cabu gone jaawenusi, cije biname cina mibibine cubu me niwenininusi.” ");
INSERT INTO bon_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeesu Betaniya cewe jage yepä biname ngii Simona me mete cabu, lui te niinäce lepera pita cama ge. ");
INSERT INTO bon_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yeesu liba deedei cabu jage, yepä magebi te piba toclige mararage lengo oil cama, lui ne baborage daremu ca jaaletnusi. Tabe pui oil ne secanige karpu cabu, lui alabasta kula ca wawenäneji ge, siige epadurige Yeesu me mope cabu. ");
INSERT INTO bon_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abiberäja bägrä cina liba ai mule ne jepänisi, teepi claabe me äbitininisi, jiicisi egä, “Ngeno me ai oil ne papa bepadurige? ");
INSERT INTO bon_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Miiji cire yaacanejisi babo daremu ca aletname, siige pui rarekaake owecumete biname bine cire yääcäranemejisi!” ");
INSERT INTO bon_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeesu umle äbitige, teepi ngena tääpume jiicemisi, siige tabe jejemige egä, “Weene ngeno me ai magebi ne jwiicetniniye, ngenecu mäpu me joweniniye? Tabe ai lui babo miijirage mule ne biiri jewenige cäme tääpume. ");
INSERT INTO bon_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Owecumete biname cina iyeteta pa yaacrajepi weene cama, yepä cane weene cama iyeteta lica pagege lenaja. ");
INSERT INTO bon_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tabe liba ai oil ca naganige cebine, tabe cäme tääpe ne beganige gape cabu me acitame. ");
INSERT INTO bon_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cane toraca mene jijenininine, egä Miiji Mene luma cirege iicema ai gawecewe cabu, teeme ngene apecname cirege iicema, tabe lui mule ne bii jewenige cäme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Puma cita ca twelb abiberäja bägrä bime yepä te ngii Yuuda Isakariyota ädige modamoda iiwäreja biname bime bau me, ");
INSERT INTO bon_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jejemige egä, “Weene cebine ngena näcäreniye, cane liba Yeesu jiwabininine weebibine?” Teepi teeti silba rarekaake ecnemisi, teebine ecärisi. ");
INSERT INTO bon_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Puma cita ca Yuuda miijirage padare ne jirngige Yeesu ne teeme ime cabu acitame. ");
INSERT INTO bon_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Trii padare puga ge Israela biname cina liba uutneca cäco buluduu bine yäärwäjimusi. Pui padare me niinäce bimu cabu abiberäja bägrä cina seclige Yeesu ne ätemlame egä, “Maane singi luma mäte cine äsuplengta deedei ne amacetnäjame määme tääpume?” ");
INSERT INTO bon_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeesu jejemige egä, “Äte naaclege pui yepä biname bau me babo cewe je, teebine jejepeye egä, ‘Abiberäja biname te jiicenige egä cäme budre padare mameta gyene atyaramta. Cane cäme abiberäja bägrä cama tädenine määme mete me äsuplengta deedei äbitame.’” ");
INSERT INTO bon_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abiberäja bägrä cina jewenisi, Yeesu lipu jejemige. Teepi äsuplengta deedei ne emacetnäjisi. ");
INSERT INTO bon_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Liba mämleteca ge, Yeesu teeme twelb abiberäja bägrä cama adnatige deedei loolo me. ");
INSERT INTO bon_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Teepi liba deedei äbitininisi, Yeesu jejemige egä, “Cane toraca mene jijenininine, weeme yepä te cebine pa nawabepi budre me aglime.” ");
INSERT INTO bon_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abiberäja bägrä cina ngenecu mäpu me äbitininisi, siige teepi yepäyepä teebine jejananisi egä, “Yageyame, cane lica.” ");
INSERT INTO bon_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeesu jejemige egä, “Laati te buluduu ne yiiglenutenige disi cabu cane cama, tabe sine pui biname. ");
INSERT INTO bon_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cane lui te Acejiyame bau ca tädujine biname me äbitujine, Oogäräneji mene te lipu jiicenige, cane pepu budre äbitenine. Yepä lipu niiyarage gyene, lui te cebine nawabenige budre me, Acejiyame bau ca lui te tädujine biname me äbitujine. Pui biname tääpume miiji cirege, tabe liba lica cire laplimleji.” ");
INSERT INTO bon_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Puma cita ca Yuuda Yeesu ne budre me awaba biname te jejige egä, “Abiberäja biname, cane lica.” Yeesu jejige egä, “Maane peese näte lui te jiicite egä, ‘Cane lica.’” ");
INSERT INTO bon_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Teepi liba erwäjisi, Yeesu buluduu ne ecatige, Acejiyame ne eso ecärige, itrecige, abiberäja bägrä bine ecärimige, siige jejemige egä, “Ecateye, erweye. Ai lui cäme tääpe gyene.” ");
INSERT INTO bon_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Puma cita ca tabe kwäye ne ecatige waina niiye cama, Acejiyame ne eso ecärige, siige teebibine ecärimige, jejemige egä, “Weene iyeta eneye. ");
INSERT INTO bon_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ai lui cäme uudi gyene; klaje jecnenige Acejiyame lui kirece mene ituge jaji biname bine niiya cabu ca äsecrerame; bucurage biname bime tääpume tapirenige teeme niiya mule bine iisibrecame. ");
INSERT INTO bon_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cane toraca jijenininine weebibine, egä cane ingwe ca lica cirege waina niiye ne nani, ngälu pui bimu cabu liba kirece waina niiye ne weene cama cire yaanepene, mine liba cirege abasecretna cäme Babe me puupu cabu cabucewe je.” ");
INSERT INTO bon_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Puma cita ca teepi uupera ne etangisi, siige äsige, eclige Olibi Uli podo cabu me. ");
INSERT INTO bon_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeesu abiberäja bägrä bine jejemige egä, “Page ai ciiye cabu weene uucratnininiye, cebine nabmaliniye, ingle Oogäräneji mene te jiicenige egä, ‘Acejiyame te maamoi ire atwi biname ne eglenige budre me, siige maamoi tomi te maramara äbitenige.’ ");
INSERT INTO bon_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yepä cane liba budre cabu ca pa larpinantepene, cane piba weeme niinäce gaabe me Galilaya me pa lädepene.” ");
INSERT INTO bon_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Puma cita ca Peteru Yeesu ne jejige egä, “Ngänu gyene liba iyeta poto cina meebine abmala, yepä cane licarage naabmalenine meebine.” ");
INSERT INTO bon_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu jejige egä, “Cane toraca naajenine, egä ai ciiye cabu paulo te ingwe ca ala sengenenige, maane niinäce nesae gääbu cebine nainenite.” ");
INSERT INTO bon_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peteru jejige egä, “Ngänu gyene teepi cebine maane cama budre me agli, yepä cane meebine licarage naainenine.” Iyeta abiberäja bägrä cina cuta yepä mene jejanisi. ");
INSERT INTO bon_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yeesu teeme abiberäja bägrä cama ädige cewe ngii Getesemane me. Puma tabe teebibine jejemige egä, “Ama adnatärineye, cane liba ädenine eeyeme irecu ätumutame.” ");
INSERT INTO bon_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tabe teta cama aacanänige Peteru piiyepu Jebedayo me neeneni bägrä bine. Yeesu babo ngenecu mäpu me äbitige. ");
INSERT INTO bon_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tabe teebibine jääjänige egä, “Cane budre pana ngenecu mäpu gäne. Weene cane cama ireclota sinajänege.” ");
INSERT INTO bon_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Puma cita ca tabe matikäli padare abotäntige, oweowe ajarige gawe cabu me, irecu ätumutige egä, “Cäme Babe, liba miiji gyene, maane ai mäpu ne cäme bau ca iyeblingti. Yepä maane cäme singi ne gone jaawenute, määme singi ne jewenepi.” ");
INSERT INTO bon_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Puma cita ca tabe tacnenutige, abiberäja bägrä bine ute cabu äädäränige. Tabe Peteru ne jejige egä, “Nää, weene kokre lica gämi matikäli padare ireclota lenajame cane cama? ");
INSERT INTO bon_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ireclota sinajänege irecu ätumutame, weene piba lica pagege atrametna apicetnära padare cabu. Weeme seemo cina singi gämi cäme singi ne wawename, yepä weeme tääpe cina kokre cäco gämi.” ");
INSERT INTO bon_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeesu cuta cääri acnige irecu ätumutame. Tabe jiicige egä, “Cäme Babe, maane liba toraca singi gäte cane ai mäpu cabu lenajame, yoo siige määme singi te läbitege.” ");
INSERT INTO bon_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tabe liba tacne-nutige, tabe cääri teebibine ute cabu äädäränige. Teepi äblicäco ge irecu aasatäneji lenaja. ");
INSERT INTO bon_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Puma cita ca Yeesu teebibine cääri taabmalänige, nesae me ädige irecu ätumutame yepä mene iicemame. ");
INSERT INTO bon_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tabe liba tacnenutige abiberäja bägrä bime bau me, tabe jääjänige egä, “Weene ute camu gämi. Diibe oocenäniye. Padare te biiri tatyaramtige, cane lui te Acejiyame bau ca tädujine biname me äbitujine, cebine ceerame conocono biname bime ime cabu me. ");
INSERT INTO bon_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Abujengäneye, biiri wääjene! Ire, lui biname te cebine nawabenige budre me aglime, tabe mameta gyene!” ");
INSERT INTO bon_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeesu liba camu mene iicema cabu jage, Yuuda twelb abiberäja bägrä bime yepä te piba tatyaramtige. Modamoda iiwäreja biname piiyepu poto Israela modamoda biname cina teta cama tityepimisi bucurage biname bine cubu turikä piiyepu gabagaba cama. ");
INSERT INTO bon_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yeesu ne budre me awabayame biname te cewecu ne bii becitige pui biname bime tääpume egä, “Cane lui biname ne jetecnenine, peese nyene weene lui tääpume singi. Joomlepeye!” ");
INSERT INTO bon_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yoo siige, Yuuda liba tatyaramtige, tabe conocäco ädige Yeesu bau me, jejige egä, “Abiberäja biname, poode!” siige jetecni-ge teebine. ");
INSERT INTO bon_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu jejige egä, “Cäme biname, maane wata jeweni, maane ngena tääpume tädite!” Puma cita ca lui biname cina Yuuda cama seclige, teepi Yeesu ne jewaclomtisi, kokrerage joomli-si. ");
INSERT INTO bon_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yeesu cama lui biname cina, teeme yepä te teeme cubu turikä ne suusuratige, iiwäreja mope biname me kaakesea bägrä me tablame ne iyeta jeläcnutige. ");
INSERT INTO bon_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeesu jejige egä, “Isinglanti määme turikä ne siiti bora, ingle laatibi cubu turikä ca larnginusi, teebibine cubu turikä te budre me yaaglecimuge. ");
INSERT INTO bon_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nää, maane apu naangeninige, egä cane äblicäco gäne cäme Babe ne ätinera cebine ätityerame? Cane liba ätinera je, tabe piba taatu mage twelb mename seemo sange bine ätyepa cäme ätityera tääpume. ");
INSERT INTO bon_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yepä pepu liba äbita je, piba lipu toraca me page läbitepi, lui mene oogäräneji gyene, egä ai mule te miiji äbita.” ");
INSERT INTO bon_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Puma cita ca Yeesu biname bine jejemige egä, “Weene cubu turikä piiyepu gabagaba cama naaclige cebine oomlaname epu pana, egä cane cubucubu biname gäne. Bimu gaabegabe cane iiwäreja mete cabu ladnatune, puga yaabiberäjimune, weene ngena name pi piba cebine lica noomlepeye. ");
INSERT INTO bon_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yepä iyeta ai cina bäpletnärige Acejiyame me mename biname bime oogäräneji mene cina toraca me äbitame.” Piba taatu iyeta abiberäja bägrä cina teebine ebmalisi, siige uucratnige. ");
INSERT INTO bon_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lui cina Yeesu ne joomlisi, teepi teebine ecanisi iiwäreja mope biname ngii Kayapa me mete me. Cotre abiberäja biname piiyepu nuuja Israela modamoda biname cina uja piiyeme biiri tabasecretnige. ");
INSERT INTO bon_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peteru Yeesu ne cudecewe ca ingwe icwige iiwäreja mope biname me mete puutucu cabu me. Tabe puga kaakesea bägrä cama adnatige ireme, egä baa lipu äbitininisi iyeta ai mule cina Yeesu tääpume. ");
INSERT INTO bon_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Modamoda iiwäreja biname piiyepu iyeta mutre biname cina, teepi liga walya aitneja ne jirngisi Yeesu ne atraname budre tääpume, ");
INSERT INTO bon_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yepä teepi äblicäco nuuja ne päpäna, ngänuge puu bucurage biname cina seclige teebine walya aitnejame. Ceräcerägääburage neeneni biname cina taaclige, ");
INSERT INTO bon_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","siige jiicäsi egä, “Ai biname te itu jiicepi egä, ‘Cane miiji gäne Acejiyame me iiwäreja mete ne iigarecame cuta nesae bimu cama cääri raranga-me.’” ");
INSERT INTO bon_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iiwäreja mope biname te abujängtige, Yeesu ne jejige egä, “Teepi meebine bii naitnisi. Määme nuuja daremu mene lica gyene?” ");
INSERT INTO bon_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yepä Yeesu bojäcu enajige. Puma cita ca iiwäreja mope biname te cääri teebine jejige egä, “Ireclota Acejiyame me ngii cabu maane nijini, maane liba Keriso säte, Acejiyame me Bägrä.” ");
INSERT INTO bon_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu jejige egä, “Yoo, maane peega bii jiicite. Yepä cane jijenininine weebibine, egä cane lui Acejiyame bau ca tädujine biname me äbitujine, ai padare cabu ca niinäce gaabe me weene cebine pa näpänepeye babo kokrerage Acejiyame me camu poto cidi ca adnatäneji piiyepu cuta cire näpänepeye, cane carbe cabu liba cire täinepene.” ");
INSERT INTO bon_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Puma cita ca iiwäreja mope biname te teemanu cäbletääpe ne idericige awabame, egä tabe Yeesu ne panyamete jepänige, siige jiicige egä, “Tabe Acejiyame me ngii ne sabe bii jewenige. Mine nuuja singi lica gemi nuuja aitneja tääpume. Weene siige peega bitecijinige, tabe lipu Acejiyame me ngii ne sabe jewenige. ");
INSERT INTO bon_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Weene lipu ngene jotwanininiye teeme poto cidi me?” Teepi jejisi egä, “Tabe conocono biname gyene. Tabe miiji budre.” ");
INSERT INTO bon_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Puma cita ca teepi gije jecitisi teebine mote ca ätyewame opo cabu piiyepu oororename. Poto cina teebine lakace cabu jidnanisi, ");
INSERT INTO bon_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jiicisi egä, “See Keriso, baa maane nijini, egä laati te noororige meebine.” ");
INSERT INTO bon_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peteru Kayapa me mete puutucu je adnatäneji enajige. Puma cita ca yepä kaakesea ngulebägrä te toclige, teebine jejige egä, “Maane cuta peese näte nuuja, Yeesu Galilaya biname cama lui te waatnute.” ");
INSERT INTO bon_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yepä Peteru biname bime sobe cabu jeinige, jojige pui ngulebägrä ne egä, “Cane umle lica gäne maane ngena tääpume jiicenite.” ");
INSERT INTO bon_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Puma cita ca tabe asatige caale grana gome me. Piba nuuja kaakesea ngulebägrä te Peteru ne jepänige, biname bine puma jejemige egä, “Ai biname te Yeesu Nasareta biname cama waatnuge.” ");
INSERT INTO bon_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peteru cääri jeinige, jiicige egä, “Cane Acejiyame me ngii cabu jiicenine, egä cane umle lica gäne peei biname.” ");
INSERT INTO bon_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Matikäli padare ingwe gaabe ca lui biname cina puga aclajuteji icrajige, seclige Peteru bau me, jejisi egä, “Toraca, maane peese näte teeme yepä. Määme tagepogogo te niwabininige, egä maane ten cama yepä ceweyame gäte.” ");
INSERT INTO bon_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Puma cita ca Peteru mene kokre cama jiicige egä, “Acejiyame me ngii cabu cane jijenininine, egä cane umle lica gäne peei biname. Acejiyame niiya daremu näcäruge, cäme mene liba toraca lica.” Piba taatu paulo te ala sengenige. ");
INSERT INTO bon_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peteru ngene jotwige, Yeesu lipu jejige egä, “Paulo te ingwe ca ala sengenenige, maane niinäce nesae gääbu cebine nainenite.” Peteru asatige, agli pana ele engenige. ");
INSERT INTO bon_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Krokerage iyeta modamoda iiwäreja biname piiyepu nuuja Israela modamoda biname cina mene jitranisi Yeesu ne budre me aglime. ");
INSERT INTO bon_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Teepi seea ca teebine jetäyisi, siige ecanisi Pilato bau me, lui Rooma gabmani babo biname ge pui gawe ne ire atwime. ");
INSERT INTO bon_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuuda Yeesu ne budre me awabayame biname te liba itecijige, egä Yeesu ne budre me bii jitranisi, tabe niiyarage asicnantige, peei teeti silba rarekaake bine ewecnimige, modamoda iiwäreja biname piiyepu nuuja modamoda biname bine ecärimige. ");
INSERT INTO bon_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tabe jejemige egä, “Cane niiya mule ne bii becnine, conocäco biname lipu bicärininine budre me agli tääpume.” Yepä teepi jejisi egä, “Cine ngeno me pa yaaratepesi. Määme mule gyene peei.” ");
INSERT INTO bon_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Puma cita ca Yuuda rarekaake bine eyärimige iiwäreja mete cabu, ädige, ete aglotige. ");
INSERT INTO bon_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Modamoda iiwäreja biname cina rarekaake bine etomlecmisi, jiicisi egä, “Ingle naace popi ai rarekaake uudi me daremu gyene, peei name pi cotre gyene acraname, iiwäreja mete tääpume luma rarekaake yaacranimusi.” ");
INSERT INTO bon_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Teepi mene jitranisi, egä lui biname te disi bine gawe ca jaawenimuge, pui rarekaake ca teeme bau ca gawe ne jeletnisi idne biname bime gapecewe tääpume. ");
INSERT INTO bon_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ingle naace popi pui gawe ne lui uudi daremu rarekaake ca jeletnisi, peei name pi einenisi Uudi Gawe ca ngälu page ai taje. ");
INSERT INTO bon_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ai te ibibi äbitige Acejiyame me mename biname Yeremiya me mene cama egä, “Teepi teeti silba rarekaake bine ewadimisi, Israela biname cina luma ngälu me singi äbitininisi teebine daremu wawename, ");
INSERT INTO bon_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","siige pui rarekaake ca eei biname bau ca gawe ne jeletnisi, lui biname te disi bine jaawenimuge gawe ca, Yageyame te lipu cebine ituge jaji wawename.” ");
INSERT INTO bon_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeesu Rooma gabmani babo biname Pilato me opo gaabe jeclajutige. Pilato Yeesu ne itemlige egä, “Nää, maane Israela biname bime mope biname gäte?” Yeesu jejige egä, “Maane peega bii jiicite.” ");
INSERT INTO bon_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Modamoda iiwäreja biname piiyepu nuuja Israela modamoda biname cina liba teebine jeitnäjisi, tabe nuuja mene lica. ");
INSERT INTO bon_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Puma cita ca Pilato jejige egä, “Nää, maane lica näätecijenige, meebine lui naaitnäjenisi?” ");
INSERT INTO bon_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yepä Yeesu daremu mene lica jewecnistige, peei name pi Pilato mage cälu te jitige. ");
INSERT INTO bon_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Israela biname cina liba kämäge gaabegabe äsuplengta trii ne jaawenusi, piba Rooma gabmani babo biname te krokeciiye mete cabu ca yaasatuge yepä biname ne, teepi lui tääpume birige singi. ");
INSERT INTO bon_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Peeirage padare cabu krokeciiye mete bora biname puga ge ngii Baraba, lui tääpume biname cina baborage umle. ");
INSERT INTO bon_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Biname cina liba tomi yootisi, Pilato itemlimige egä, “Weene singi cane lui ne asatame krokeciiye mete cabu ca, Baraba ne coo nää Yeesu ne, Keriso ca lui ne einenisi.” ");
INSERT INTO bon_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato apu naace popi itemlimige, ingle tabe umle ge, egä modamoda iiwäreja biname cina naace popi Yeesu ne secanisi teeme bau me, ingle teepi teebine ire patre eglisi. ");
INSERT INTO bon_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato liba adnatäneji enajige atrana puupu cabu, teeme coga te piba mene jityepige egä, “Gone nuuja gwidape ne jaawenute peei conocäco biname tääpume, ingle cane wama cabu mage cewe boocananine temiji pi.” ");
INSERT INTO bon_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Modamoda iiwäreja biname piiyepu nuuja Israela modamoda biname cina biname bine tii jewenanemisi Pilato ne jajime tabe Baraba ne asatame Yeesu ne budre me aglime. ");
INSERT INTO bon_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Siige Pilato itemlimige egä, “Ai neeneni cabu ca weene singi gemi cane laati ne isatinine?” Teepi jejisi egä, “Baraba ne!” ");
INSERT INTO bon_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato teebibine itemlimige egä, “Cane piba ngena jewenenine Yeesu tääpume, Keriso ca lui ne einenisi?” Teepi iyeta jiicisi egä, “Teebine baarge uli cabu jibyecreye!” ");
INSERT INTO bon_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato jejemige egä, “Ngena name pi? Tabe ngena niiya ne ituge wawena?” Yepä biname cina mage ala abayaninisi egä, “Baarge uli cabu jibyecreye!” ");
INSERT INTO bon_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato jepänige, egä ai lui niiyarage me äbitenige, cije cubu te läpletnutuge, siige tabe niiye siitige, ime äcisäjige biname bime opo gaabe, jiicige egä, “Cane yageyame lica gäne ai biname me budre tääpume. Peei lui weeme bau sine.” ");
INSERT INTO bon_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iyeta biname cina gigri ala tabayaninisi egä, “Cine piiyepu cime bägräwale cama, cine temi yageyame teeme budre tääpume. Cine te cirege daremu acata teeme budre name pi!” ");
INSERT INTO bon_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Puma cita ca Pilato Baraba ne sisatige, cubu biname bine jejemige Yeesu ne adnaname, siige jityepige baarge uli cabu äbyecrame. ");
INSERT INTO bon_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilato me cubu biname cina Yeesu ne ecanisi Pilato me mete opo gome me. Teepi ala tesoglicmisi teta cama lui yepä sange cubu biname bine, siige teepi Yeesu ne jewaclomtisi. ");
INSERT INTO bon_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Teepi teeme cäbletääpe bine jiirecimisi, ududi cäbletääpe ca esigrisi ätutename, egä tabe mope biname gyene. ");
INSERT INTO bon_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Teepi pägepäge seeasea ne jemle-maltisi krauni tääpume, siige teeme mope cabu ecitisi. Teeme camu poto ime cabu suru ecärisi, siige kokorare ca ipednanemisi teeme opo gaabe je. Teepi ai ne ätutena pana jewenisi, egä tabe babo mope biname gyene. Puma cita ca teepi jewablisi teebine, jejisi egä, “Sebore Israela biname bime mopeyame!” ");
INSERT INTO bon_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Teepi teebine mote ca ityewäjisi, lui suru ne ecitisi teeme ime cabu, pui ca eglisi mope gome. ");
INSERT INTO bon_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Teepi liba ätecitinisi teebine apu ätutena pana wawename, ududi cäbletääpe jiiremutisi, teemerage cäbletääpe ca esigrisi, siige ecanisi baarge uli cabu äbyecrame. ");
INSERT INTO bon_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Teepi liba äsige, gaabegabe je Simona Kurene cewe biname ne jepänisi, jejisi Yeesu me baarge uli ne acaname, siige tabe ecanige. ");
INSERT INTO bon_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Teepi atyarige cewe ngii Gologota me, lui me aboclomta egä ‘Mopekaake Cewe’. ");
INSERT INTO bon_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Puga teepi Yeesu ne caapocapo waina niiye ecärisi nanime, lui traci gwidape cama alengläciteji teeme pita diibe ceerame, yepä mite agli ingwe gaabe ca tabe singi lica nanime. ");
INSERT INTO bon_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Teepi teebine baarge uli cabu jibyecrisi. Puma cita ca teepi matimati kula cabu teeme ngii bine yoogärimisi, piba yiisabäjemisi pui kula bine umle äbitame, egä teepi lipulipu Yeesu me cäbletääpe bine abelename. ");
INSERT INTO bon_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Peei ingwe ca teepi puga adnatärige, Yeesu ne ire jetwisi. ");
INSERT INTO bon_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Teeme mope gome me mene ne ecitisi teeme budre ingle poto cidi me egä, AI LUI YEESU SINE, ISRAELA BINAME BIME MOPE BINAME. ");
INSERT INTO bon_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Piba teepi neeneni cubucubu biname bine baarge uli cabu jääbyecrisi Yeesu me wajwa je, nuuja te camu poto ca, nuuja te säwäci poto ca. ");
INSERT INTO bon_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Laatibi teebibine ääsuplengäjänisi, teepi mope akocnäjinisi, Yeesu ne jisädanisi. ");
INSERT INTO bon_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Teepi jiicisi egä, “Maane peese näte, iiwäreja mete ne lui te yiigarecenite, cuta cääri nesae bimu cama erange-nite. Maane miiji äbiti, maane liba Acejiyame me Bägrä gäte. Täini baarge uli cabu ca!” ");
INSERT INTO bon_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Modamoda iiwäreja biname, cotre abiberäja biname piiyepu nuuja modamoda biname cina teebine cuta pipu jisädanisi, ");
INSERT INTO bon_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","jiicisi egä, “Tabe nuuja biname bine miiji tewenanemumi, yepä tabe äblicäco teemämu miiji äbita. Cije tabe Israela mope biname lica gyene? Tabe liba baarge uli cabu ca täinenige, cine piba teebine jitrungenisi. ");
INSERT INTO bon_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tabe teeme ngene atwanena bicranige Acejiyame bau me, piiyepu teeme Bägrä ca ainenige. Yoo siige mine jääpänesi, egä Acejiyame liba singi teebine miiji wawename.” ");
INSERT INTO bon_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Piiyepu peei neeneni cubucubu biname, lui bine teeme gome jääbyecrisi, teepi cuta pepu jejananisi teebine. ");
INSERT INTO bon_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bimu duusa me krokeciiye te cewe ne iyeta icwabige, siige nesae awa pepu enajige. ");
INSERT INTO bon_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Piba mämle bimu cabu Yeesu mage ala abayige egä, “Eeli, Eeli lama sabatani.” Peei lui egä, “Cäme Acejiyame, cäme Acejiyame, maane ngeno me cebine nägyite?” ");
INSERT INTO bon_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Poto biname lui cina aclajuteji puga ge, jitecijisi, jiicisi egä, “Tabe Eliya ne ala tesoglecenige.” ");
INSERT INTO bon_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Teeme yepä te piba taatu tuuwamige, waarpopale pana gwidape ne yiiglenutige caapocapo waina niiye cabu, suru ca jigadige, siige cabu me ewepäntige tabe nanime. ");
INSERT INTO bon_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Poto cina jiicisi egä, “Cäro, mine jääpänesi, egä Eliya liba tädenige teebine miiji wawename.” ");
INSERT INTO bon_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeesu cääri mage ala abayige, ceräcerägääbu buuwe mope bine yiisabimige, siige teeme ireclota ecärige. ");
INSERT INTO bon_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iiwäreja mete cabu Acejiyame me puupu ne lui cäbletääpe te jilyengenige biname bime puupu cabu ca, pui cäbletääpe te äderärige cabu ca ngälu gawe me. Ocneja puga ge, modamoda kula cina äplegicininisi, ");
INSERT INTO bon_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","gape cina iitnetnäjinisi, siige bucurage Acejiyame me biname laatibi budre, teepi tarpineräjininisi ireclota me. ");
INSERT INTO bon_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Teepi teeme gape bine sebmalimisi. Yeesu liba budre cabu ca tarpinantige, teepi piba Yerusalema me eclige, puga aboclomäjininisi bucurage biname bime bau me. ");
INSERT INTO bon_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cubu mope biname piiyepu teeme ingwe gaabe biname laatibi Yeesu ne ire jetwisi, liba jepänisi ocneja ne piiyepu iyeta ngena cina äbitininisi, teepi mage wälu äbitininisi, jiicisi egä, “Tabe toracarage Acejiyame me Bägrä gyene.” ");
INSERT INTO bon_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Puga ge bucurage magebi cudecewe ca ire. Teepi Yeesu cama Galilaya probins cabu ca seclumi teebine ätityerame. ");
INSERT INTO bon_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Teeme sigu cabu Mariya Magadala cewe magebi piiyepu Yakobu Yoosepa naabime mage ngii Mariya cuta Jebedayo me coga. ");
INSERT INTO bon_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Liba mämleteca ge, yepä dogwe biname ngii Yoosepa te Arimatea cewe cabu ca piba tatyaramtige. Tabe cuta nuuja Yeesu me abiberäja bägrä ge. ");
INSERT INTO bon_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tabe Pilato bau me ädige Yeesu me budrekaake tääpume ätinerame. Pilato jejemige budrekaake Yoosepa ne ceerame, ");
INSERT INTO bon_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","siige tabe budrekaake ne baarge uli cabu ca sitrungamtige, kirece bulubulu cäbletääpe ca tope etnige, ");
INSERT INTO bon_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ecanige, teeme Yoosepa me tääpume lui gape ne cemacema tuurumesi baborage kula bora, pui ngalebora me ecitige. Tabe baborage kula ne epetrengäjige gape grana armi tääpume, siige acnenutige. ");
INSERT INTO bon_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadala cewe magebi piiyepu nuuja Mariya, teepi puga adnatäneji aanajige, opire gape cabu mage. ");
INSERT INTO bon_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nuuja bimu cabu lui Sabade bimu ge, modamoda iiwäreja biname piiyepu Parisea sigu biname cina Pilato bau me eclige, ");
INSERT INTO bon_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","jejisi egä, “Babo biname, cine ngene jotwinago, egä pui walya biname liba ireclota senajumi, tabe tiicumi egä, ‘Cane nesae bimu ingwe gaabe ca budre cabu ca pa larpinantepene.’ ");
INSERT INTO bon_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jejemi gape ne cängena awamutame nesae bimu ngalebora, piba teeme abiberäja bägrä cina äblicäco otni teebine ero ca acatame, puma cita ca jajanename egä, ‘Tabe budre cabu ca tarpinantige.’ Apu liba äbita je, teeme ai ingwe ca walya te niiyarage cirege teeme niinäce walya cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato jejemige egä, “Awamuta biname bine ewademeye, naaclege, gape ne jewamuteye, weene lipu miiji gemi.” ");
INSERT INTO bon_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Siige, teepi Pilato ne ebmalisi, eclige gape gome me. Teepi gape grana cabu lui kula ne etengäcitisi, awamuta biname bine puga sebmalimisi. ");
INSERT INTO bon_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabade bimu me ingwe ca Sande baani te liba seclitige, Mariya Magadala cewe magebi piiyepu nuuja Mariya teepi aaclige gape ängrärame. ");
INSERT INTO bon_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Puma cita ca babo kokre ocneja te tädige. Yageyame me mename seemo te cabucewe ca täinige, kula ne epetrengäjige Yeesu me gape grana cabu ca, siige pui kula papa cabu adnatige. ");
INSERT INTO bon_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Teeme opo paamlepamle pana ge, cäbletääpe lui toraca bulurage ge. ");
INSERT INTO bon_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Awamuta biname cina babo wälu äbitininisi, jelonecmige, siige gawe cabu itrametnemige budre biname pana. ");
INSERT INTO bon_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mename seemo te magebi bine jaajige egä, “Wälu gone läbituye. Cane umle gäne, egä weene Yeesu ne jirngeniye, baarge uli cabu lui ne tibyecrumesi. ");
INSERT INTO bon_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tabe ama lica gyene. Tabe barpi-nantige, tabe lipu itu tiicumi. Siclege, jepäneye tabe luma ätwitäneji senajumi. ");
INSERT INTO bon_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Äte watata iclege, teeme abiberäja bägrä bine jejemepeye, egä tabe budre cabu ca barpinantige, siige Galilaya me pa lädepi teeme niinäce gaabe me; teepi teebine puma pa jääpänepesi. Ngene gone jitrimaluge, cane lipu bii jijine.” ");
INSERT INTO bon_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Magebi cina watatarage gape ne sebmaläsi. Teepi nuuja poto wälu nuuja poto gege ge, siige uuwamäsi Yeesu me abiberäja bägrä bine jajime, ngena te bäbitige. ");
INSERT INTO bon_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Puma cita ca Yeesu teebibine opopa jaawenige, jaajige egä, “Poode weeme bau me!” Teepi teeme bau me taaclige, ernge gome joomläsi, siige ngenecu miiji cama teebine jepänäsi. ");
INSERT INTO bon_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeesu jaajige egä, “Wälu gone läbituye! Iclege, cäme naane igane bine jejemeye teepi Galilaya me otnime. Teepi cebine puma pa näpänepesi.” ");
INSERT INTO bon_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Magebi cina liba gaabe cabu jage, lui cubu biname cina gape ne jewamutisi, teeme poto cina äcnärige babo cewe me, modamoda iiwäreja biname bine jejemisi, ngena te bii bäbitige. ");
INSERT INTO bon_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Modamoda iiwäreja biname cina nuuja modamoda biname bime cama yepä cewe me abasecretninige mene atraname. Teepi baborage rarekaake cubu biname bine ecäremisi, ");
INSERT INTO bon_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","jejemisi egä, “Weene miiji biname bine jajanename egä, ‘Teeme abiberäja bägrä cina ciiye seclige, teeme budrekaake ne ero ca becatisi, cine liba ute ge.’ ");
INSERT INTO bon_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Siige Pilato liba ai poto cidi me ätecija je, cine te teebine miiji ngenecu me pa jaawenepesi. Weene nuuja singi lica gemi ngenecu mäpu äbitame.” ");
INSERT INTO bon_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Awamuta biname cina rarekaake ewadimisi, jewenisi, teepi lipu jejemisi. Ai mene ne Israela biname cina ecenanenisi ngälu page pisi nyene. ");
INSERT INTO bon_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lebin abiberäja bägrä cina eclige podo cabu me Galilaya je, Yeesu liiyeme tejemumi teepi otnime. ");
INSERT INTO bon_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Teepi liba teebine jepänisi, siige ngenecu miiji me äbitininisi, yepä poto cina toracarage lica jitrungisi, egä Yeesu sine. ");
INSERT INTO bon_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeesu teeme gome tädige, jejemige egä, “Cebine iyeta kokre ituge ceera cabucewe je piiyepu gawecewe cabu. ");
INSERT INTO bon_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Naaclege, iyeta maramara gawe biname bine jewenemepeye cäme abiberäja bägrä tääpume. Niiye ca jicisäjemepeye Babe, Bägrä, Aceji Seemo teeme ngii cabu, ");
INSERT INTO bon_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","piiyepu ebiberäjemepeye teepi ätecijame iyeta cane lui tääpume itu jijananipene. Cane weene cama pagege iyeta padare ngälu ai padare me ngälugaabe me.” Mene ngälu peese. ");
INSERT INTO bon_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ai lui Miiji Mene me agedna gyene Yeesu Keriso, Acejiyame me Bägrä poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Acejiyame me mename biname ngii Isaya yoogäruji, Acejiyame te teeme Bägrä ne lipu jejuji egä, “Cane cäme mename biname ne cire täätyepepene määme niinäce gaabe me määme tääpume gaabe amacetnäjame. ");
INSERT INTO bon_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tabe daapo taatu cewe cabu babo tagepogogo ca cire jiicepi egä, ‘Gaabe ne emacetnäjeye Yageyame tääpume, weeme mule bine conocäco jewenemeye teeme otni tääpume.’” ");
INSERT INTO bon_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isaya lui mene soogäruji, toraca me äbitige Yoane liba taboclomtige daapo taatu cewe cabu, biname bine niiye ca jicisäjemige piiyepu mene jejananemige egä, “Weene weeme niiya mule cabu ca atatrongärineye, cane piba weebibine niiye ca jicisäjeninine, siige Acejiyame te weeme niiya mule bine piba pa yiisibrecmepi.” ");
INSERT INTO bon_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bucurage biname babo cewe Yerusalema ca piiyepu nuuja maramara cewe Yuudea probins ngalebora ca totni-nisi Yoane ne ätecijame. Teepi teeme niiya mule bine liba jewabudnäjimisi, piba Yoane te teebibine niiye ca jicisäjemige Yoridana baduge cabu. ");
INSERT INTO bon_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoane me cäbletääpe lui kamela me ngäli ca wawenäneji ge piiyepu tabe kamela tääpe ca wawenäneji baagi ca asigräneji ge ibi cabu. Tabe sesi pana gwidape bine yäärngäjimuge piiyepu uri niiye bine yäänäjimuge. ");
INSERT INTO bon_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tabe biname bine jejananemige egä, “Cäme ingwe ca lui biname te pa tädepi, tabe baborage gyene, cane matikäli gäne. Cane ibibi lica gäne teeme ernge gwidape seea iibirame. ");
INSERT INTO bon_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Cane weebibine niiye ca jicisäjenininine, yepä tabe te weebibine pagege Aceji Seemo ca äciseja.” ");
INSERT INTO bon_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yoane lui padare cabu biname bine mene jejananemige, Yeesu piba tädige babo cewe Nasareta cabu ca lui Galilaya probins ngalebora, siige Yoane te teebine niiye ca jicisäjige Yoridana baduge cabu je. ");
INSERT INTO bon_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tabe liba niiye cabu ca tarpatige, tabe piba taatu jepänige, cabucewe te iitnige, cuta jepänige Aceji Seemo te lipu täinige gimäe ele pana teeme papa cabu me. ");
INSERT INTO bon_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Puma cita ca tagepogogo te cabucewe ca tädige egä, “Maane lui cäme ngenecurage Bägrä gäte. Cane baborage ngenecu miiji gäne määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Piba watata Acejiyame me Seemo te Yeesu ne jityepige daapo taatu cewe me. ");
INSERT INTO bon_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tabe puma enajige footi bimu cama, siige Satani te teebine puga epicetneräjige. Glunubora girigale gwidape cuta puga ge, yepä Acejiyame me mename seemo cina seclige teebine ätityerame. ");
INSERT INTO bon_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yoane ne liba niinäce krokeciiye mete bora me ecitisi, pui ingwe gaabe ca Yeesu piba ädige Galilaya probins cabu me, siige Acejiyame bau ca lui Miiji Mene, tabe puma jejananemige. ");
INSERT INTO bon_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tabe apu jiicige egä, “Ingle Acejiyame te lui padare ne secituji, bii tatyaramtige, siige mameta gyene tabe biname bine waadena, peei name pi atatrongärineye weeme niiya mule cabu ca, Miiji Mene ne jitrungeye.” ");
INSERT INTO bon_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeesu liba otnetnäjige Galilaya sawa ligi ta, tabe jääpänige nanigane wäsi bine ngii Simona piiyepu Andrea. Teepi net bine yiisabäjemäsi sawa cabu je, ingle teepi cibubade biname ge. ");
INSERT INTO bon_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Puma cita ca Yeesu jaajige egä, “Ayo, siclege cane cama otnime. Cane jiwenenine weebibine biname bine waadename cäme bau me, epu pana weene lipu niinäce cibu bine toomläjenanemumeye.” ");
INSERT INTO bon_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Piba taatu teepi sebmalemäsi teeme net bine, siige Yeesu cama aaclige. ");
INSERT INTO bon_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Teepi liba matikäli padare ujige, Yeesu cuta piba nuuja nanigane wäsi bine jääpänige. Teepi lui Jebedayo me bägrä ge, ngii Yakobu piiyepu teeme igane Yoane. Teepi teeme poo cabu net bine iswärenemujäsi. ");
INSERT INTO bon_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Piba taatu Yeesu teebibine cuta ala taasoglicige. Teepi teeme babe Jebedayo piiyepu teeme kaakesea bägrä bine poo cabu sebmalemäsi, siige Yeesu cama aaclige. ");
INSERT INTO bon_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeesu teeme abiberäja bägrä cama Kaprenauma cewe me atyaramtige. Nuuja Sabade cabu Yeesu abasecretna mete cabu me ädige, siige gije abacitige biname bine abiberäjame. ");
INSERT INTO bon_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Teepi mutäcäco äbitininisi teeme abiberäja mene name pi, ingle tabe epu ebiberäjimige, lui me conocäco pisi nyene abiberäjame lica cotre abiberäja biname bime pana, lui cina nuuja biname bime ngene atwanena bine yaawadäjemusi. ");
INSERT INTO bon_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Puma cita ca biname te tabacitige, lui me trupa ngalebora puga ge niiya cable. Tabe niiya ala abayige, jiicige egä, ");
INSERT INTO bon_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yeesu Nasareta ceweyame, maane nää singi ngena wawename cime tääpume? Maane nää tädite cibibine sabe wawename? Cane umle gäne maane laasi näte, maane Acejiyame me conocäcorage Bägrä gäte.” ");
INSERT INTO bon_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Puma cita ca Yeesu niiya cable ne kokre cama jejige egä, “Maane bojä naagege. Tasati teeme trupa cabu ca!” ");
INSERT INTO bon_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Cable te teebine kokre cama itretnutige, niiya ala isatige, siige tasatige teeme trupa cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iyeta biname cina mutäcäco äbitininisi, siige ätemläjinisi egä, “Ai lui baa ngena gyene? Nää kirece abiberäja gyene? Teeme conocäco pisi nyene niiyaniya cable bine mene jajanename, siige teepi jäätecijusi teebine.” ");
INSERT INTO bon_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Teepi piba taatu Yeesu ne idre watata jecananisi Galilaya probins cabu iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeesu teeme abiberäja bägrä cama abasecretna mete ne ebmalisi. Cuta Yakobu naabi Yoane teta cama ge. Teepi eclige, ebäcnisi Simona Andrea naabime mete cabu me. ");
INSERT INTO bon_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Puga Simona me gite molyege gebale cama ätwitäneji ge, siige teepi piba taatu Yeesu ne umle jewenisi teeme poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tabe teeme bau me ädige, ime gome jwoomlige, owejängtige. Gebale te teebine obma-lige, siige tabe teebibine mogobi jewenimige. ");
INSERT INTO bon_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pui mämleteca, bimu me äpula ingwe gaabe ca Yeesu bau me sewadimisi iyeta pita biname bine piiyepu laati bage niiyaniya cable cama, ");
INSERT INTO bon_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","pui name pi bucurage biname cina pui babo cewe cabu ca tabasecretnige pui mete gaabe gome me, Yeesu luma enajige. ");
INSERT INTO bon_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeesu miiji me jewenimige bucurage maramara pita cama biname bine piiyepu bucurage niiyaniya cable bine iyecräjemige teeme trupa cabu ca. Tabe padare lica ecärimige niiyaniya cable cina mene iicemame teeme poto cidi me, ingle teepi umle ge, egä tabe laasi nyene. ");
INSERT INTO bon_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nuuja bimu krokerage baani te liba camu ge äpli, Yeesu Simona naabibime mete ne ebmalige, taatu cewe me ädige, puma irecu ätumutige. ");
INSERT INTO bon_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simona piiyepu teta cama lui biname, teepi teebine jirngisi ngälu jepänisi, ");
INSERT INTO bon_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","siige jejisi egä, “Iyeta biname cina meebine näärngenisi.” ");
INSERT INTO bon_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yepä Yeesu jejemige egä, “Biiri naclege poto mametamameta cewe me cane cuta puma mene jajanename, ingle cane bucurage biname bime tääpume tädujine ai gawecewe cabu me.” ");
INSERT INTO bon_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Puma cita ca tabe otnetnäjige iyeta Galilaya gawe cabu ta. Tabe lui cewe me läduge, tabe puma abasecretna mete cabu mene jaajemuge piiyepu niiyaniya cable bine yääyecräjemuge. ");
INSERT INTO bon_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yepä lepera pita biname te tädige Yeesu bau me, kokorare ca ääpednutige teeme opo gaabe je, ewejanige egä, “Maane liba singi gäte, maane miiji gäte cebine pita cäco me wawena.” ");
INSERT INTO bon_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeesu babo owecu äbitige teeme tääpume, siige ime uutige, joomlige, jejige egä, “Cane singi gäne. Maane pita cäco äbiti!” ");
INSERT INTO bon_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Piba taatu lepera pita te teebine ebmalige, siige tabe miiji me äbitige. ");
INSERT INTO bon_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yeesu teebine kokre cama umle mene jejige, piba ingwe ca jityepige teeme mete me. ");
INSERT INTO bon_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Tabe apu jejige egä, “Näätecijege, gone nuuja biname ne umle jaawenute ai poto cidi me, yepä maane conocäco ädepi iiwäreja biname bau me tabe määme tääpe ne awatnejame. Cuta Moose me Cotre ibi maane ecanepi teeme bau me cibu ne tabe pui ca Acejiyame ne iiwärejame biname cina piba umle äbitame, egä maane siige miiji gäte.” ");
INSERT INTO bon_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yepä tabe liba ädige, tabe gije abacitige ai mule poto cidi me idre acenename iyeta poto ta, peei name pi Yeesu äblicäco ge otni nuuja cewe me biname bime irewale je. Miiji pätä tabe biname cäco cewe cabu yaanajuge, siige biname cina iyeta poto ca twaatninusi teeme bau me. ");
INSERT INTO bon_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nesae bimu ingwe gaabe ca Yeesu acnenutige Kaprenauma cewe me, siige biname cina itecijemige, egä tabe mete cabu jage. ");
INSERT INTO bon_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Puma cita ca epu bucurage biname cina tabasecretnige teeme bau me, egä mete te tapanige, cuta nuuja puupu lica ge gaabe gome. Yeesu liba teebibine Acejiyame me mene jejemige, ");
INSERT INTO bon_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","piba fooa biname cina tatyarige, waaku cabu pita biname ne secanisi, lui me nuuja poto tääpe budre ge. ");
INSERT INTO bon_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Teepi äblicäco ge Yeesu mameta me otni bucurage biname name pi, peei name pi mete toro cabu me jegelisi, toro cabu bora ne jewenisi Yeesu me tuumeji, siige pui bora cabu ca waaku ne siyinisi, pita biname te lui cabu ätwitäneji ge. ");
INSERT INTO bon_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yeesu liba jepänimige, egä teepi babo ätrunga cama gemi, tabe jejige pita biname ne egä, “Cäme biname, maane kälyä gäte määme niiya mule cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Poto cotre abiberäja biname cina puga adnatäreji icrajige. Teepi ngene jotwaninisi egä, ");
INSERT INTO bon_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ai biname te baa ngena name pi ai mene jiicenige? Tabe Acejiyame me ngii ne sabe jewenenige, ingle nuuja te äblicäco gyene biname ne kälyä wawena teeme niiya mule cabu ca yepä Acejiyame taatu.” ");
INSERT INTO bon_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piba taatu Yeesu teeme ngenecu bora umle äbitige, teepi lipu ngene jotwaninisi, siige tabe jejemige egä, “Weene ngena name pi peei ngene jotwanininiye? ");
INSERT INTO bon_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lui gyene plowa iicana ai pita biname ne jajime egä, ‘Maane kälyä gäte määme niiya mule cabu ca’ coo ‘Arpinanti, abujängti, määme waaku ne ecati, siige äte ädi.’ ");
INSERT INTO bon_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yoo siige, cane lui Acejiyame bau ca tädujine biname me äbitujine, cane lui gwidape ne ama jewenenine, weene pui cabu ca opo nawatniniye, egä cäme conocäco pisi nyene biname ne kälyä wawename teeme niiya mule cabu ca.” Puma cita ca tabe pui pita biname ne jejige egä, ");
INSERT INTO bon_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Cane meebine naajenine, arpinanti, abujängti, waaku ne ecati, määme mete me ädi.” ");
INSERT INTO bon_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Piba taatu tabe arpinantige, teeme waaku ne ecatige, asatige biname bime irewale je. Teepi mutäcäco äbitininisi, Acejiyame ne eso ecärisi, jiicisi egä, “Cine apu mule ne niinäce lica ituge päpäna.” ");
INSERT INTO bon_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeesu cääri acnenutige Galilaya sawa ligi me. Bucurage biname cina teeme bau me seclige, siige tabe teebibine ebiberäjimige. ");
INSERT INTO bon_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Puma cita ca tabe liba ädige, yepä täks rarekaake uutecrena biname ne jepänige ngii Leebi Alaba me bägrä. Tabe adnatäneji enajige täks rarekaake uutecrena mete cabu. Yeesu teebine jejige egä, “Maane tädi cane cama otnime.” Leebi abujängtige, teta cama ädige. ");
INSERT INTO bon_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ai mule ingwe gaabe ca Yeesu deedei äbitige Leebi me mete cabu. Puga ge cuta bucurage täks rarekaake uutecrena biname piiyepu cotre atropengäja biname. Teepi Yeesu piiyepu teeme abiberäja bägrä cama deedei erwäjisi. Ai lui cälu te äti lica gyene, ingle bucurage biname cina iyeta padare cabu Yeesu cama waatni-nusi. ");
INSERT INTO bon_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Puma cita ca cotre abiberäja biname, lui cina Parisea sigu biname gemi, teepi liba jepänisi, egä Yeesu deedei äbitige täks rarekaake uutecrena biname cama piiyepu cotre atropengäja biname cama, teepi teeme abiberäja bägrä bine jejemisi egä, “Tabe baa ngena name pi pepu biname cama deedei erwäjinige?” ");
INSERT INTO bon_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yeesu liba ai mene itecijige, tabe jejemige egä, “Lui biname cina miiji birige, teepi singi lica dokta tääpume. Yepä lui cina pita cama birige, teepi singi dokta tääpume. Cane lica tädujine ala asoglecame lui biname cina apu jaangemuge, egä teepi conocäco gemi; yepä cane conocono biname bine ala asoglecame tädujine.” ");
INSERT INTO bon_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yepä padare cabu Yoane niiye ca äciseja biname me abiberäja bägrä piiyepu Parisea sigu biname cina deedei ärwäja cäco icrajige Acejiyame ne awejename. Puma cita ca poto biname seclige Yeesu bau me, itemlisi egä, “Ngena name pi Yoane me abiberäja bägrä piiyepu Parisea biname bime abiberäja bägrä cina deedei ärwäja cäco yaacrajuge, yepä määme abiberäja bägrä cina deedei yäärwäjimusi?” ");
INSERT INTO bon_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu jejemige egä, “Atejäclmuta soriyomu ne liba yaaclitusi, mamye rooriye me binamewale cina deedei ärwäja cäco lica yaacrajuge, tabe liba pisi nyene teta cama. ");
INSERT INTO bon_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yepä padare te pa tädepi, liba mamye rooriye ne pa yaacatepesi, piba teepi deedei cäco pagege lenaja teeme owecu name pi.” ");
INSERT INTO bon_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yeesu cuta jejemige egä, “Nuuja te kirece äciseja cäco cäbletääpe pläsu ne sasa cäbletääpe bora cabu lica yääswäruge. Tabe liba pepu jaawenuge, siige cäbletääpe ne liba jääcisäjuge, pui kirece pläsu te lacalomluge, siige sasa cäbletääpe ne jääsegläruge. Puma cita ca kirece pläsu te läwälutuge sasa cäbletääpe cabu ca, siige bora te babo läbituge. ");
INSERT INTO bon_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Piiyepu nuuja te lica kirece waina niiye ne yaapaduruge gouti tääpe ca wawenäneji sasa ängära gwidape cabu. Tabe liba yaapaduruge, kirece waina niiye te pui sasa ängära gwidape ne yääpluge, ingle tuutnecuge, siige waina niiye te gawe me lapaduruge piiyepu ängära gwidape te sabe läbituge. Pätä kirece waina niiye miiji apadura kirece ängära gwidape cabu.” Ai neeneni ngene ca agli mene Yeesu naace popi jejemige, tabe singi biname cina umle äbitame, egä teepi liba singi Acejiyame me mule ne oomlaname, teepi piba äblicäco sasa saarewale bime mule bine äcwetna. ");
INSERT INTO bon_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabade bimu cabu Yeesu teeme abiberäja bägrä cama wiiti calwacupi ngalebora lui gaabe, pui cabu ädige. Teepi liba eclige, abiberäja bägrä cina wiiti mope bine ecrecimisi, ime cabu mälwä bine jimlecäjemisi, kuu bine erwäjemisi. ");
INSERT INTO bon_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Puma cita ca Parisea sigu biname cina Yeesu ne jejisi egä, “Maane ire, määme abiberäja bägrä cina baa ngena name pi jewenenisi lui cotrerage gyene Sabade bimu cabu wawename?” ");
INSERT INTO bon_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeesu teebibine jejemige egä, “Egäsu weene ituge acnema, Daawida ngena jewenuji, tabe piiyepu teta cama lui biname teepi liba cubrowe icrajuji deedei cäco. ");
INSERT INTO bon_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tabe abacituji iiwäreja mete cabu. Puga ge Acejiyame tääpume ceereji deedei. Puma cita ca iiwäreja mope biname ngii Abita pui deedei Daawida ne ecäruji. Tabe erwuji cuta ecärimuji teta cama lui biname bine. Ai lui Daawida te cotre ne jetropangtuji, ingle pui deedei loolo lui cotre ge iyeta biname bime tääpume yepä lica iiwäreja biname bime tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Puma cita ca Yeesu jejemige egä, “Acejiyame te biname bine niinäce jewenimuji, piba ecituji Sabade bimu ne teeme diibe oocaname. Tabe lica niinäce ecituji Sabade bimu ne, piba jewenimuji biname bine Sabade cotre bine äcwetname. ");
INSERT INTO bon_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cane lui te Acejiyame bau ca tädujine biname me äbitujine, cane cuta Yageyame gäne Sabade bimu tääpume. Cäme conocäco pisi nyene iicaname, ngena ne miiji wawena ai bimu cabu.” ");
INSERT INTO bon_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yeesu cääri abacitige abasecretna mete cabu me. Yepä biname puga ge, lui me nuuja poto ime duudemu ge. ");
INSERT INTO bon_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Poto biname cina puma iregalerage icrajige päpäname, egä Yeesu liba ai biname ne miiji jewenenige Sabade bimu cabu, ingle teepi singi ge ingle ne päpäname teebine aitname, egä tabe cotre ne bii jetropangtige. ");
INSERT INTO bon_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeesu pita biname ne jejige abujengtame niinäce gaabe me otnime, ");
INSERT INTO bon_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","piba biname bine itemlimige egä, “Mime cotre te lipu nijenininige Sabade bimu cabu ngena wawename, miiji mule wawename coo niiya mule wawename; biname ne ätityerame ireclota me coo teeme ireclota ne sabe wawename?” Yepä teepi nuuja mene lica ge. ");
INSERT INTO bon_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeesu claabe cama teeme bau me ire acitige piiyepu tabe ngenecu mäpu ge, ingle teepi owecu cäco ge pui biname tääpume. Puma cita ca tabe teebine jejige egä, “Määme ime tuuti.” Tabe teeme ime uutige, siige cääri miiji me äbitige pui ime te. ");
INSERT INTO bon_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Puma cita ca Parisea sigu biname cina äsecrärige, piba taatu abasecretnige Heroda me sigu biname cama, siige teepi mene jitranisi Yeesu ne budre me aglime. ");
INSERT INTO bon_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yeesu abiberäja bägrä cama ädige Galilaya sawa ligi me. Bucurage biname cina Galilaya probins cabu ca teebine ingwe icwisi. Bucurage biname cina cuta seclige babo cewe Yerusalema ca piiyepu nuuja cewe cabu ca Yuudea probins ngalebora piiyepu Idumea probins cabu ca cuta Yoridana baduge nuuja poto doro ca piiyepu cewe maramara cabu ca, lui gemi Turo piiyepu Sidona modamoda cewe mameta. Teepi naace name pi totninisi, ingle teepi ituge ätecija, Yeesu ngena mule bine tewenimumi. ");
INSERT INTO bon_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Biname bucurage name pi Yeesu abiberäja bägrä bine jejemige poo te amacetnäjäneji lenajame teeme tääpume tabe acenutame piba teepi teebine lica äjwejeräja. ");
INSERT INTO bon_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ingle tabe bucurage biname bine miiji me tewenanemumi, peei name pi iyeta pita biname cina lätyepecäjininusi Yeesu bau me teeme tääpe ne oomlaname. ");
INSERT INTO bon_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lui biname bime trupa cabu niiyaniya cable puga ge, teepi liba Yeesu ne jääpänusi, teepi teeme opo gaabe je yaatrametnemuge, ala labayaninusi egä, “Maane lui Acejiyame me Bägrä gäte.” ");
INSERT INTO bon_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yepä Yeesu cable bine kokre cama jaajemuge egä, “Aitneja gone, egä cane laasi näne.” ");
INSERT INTO bon_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeesu puma cita ca podo cabu me jegelige, ala tesoglicmige, tabe lui biname tääpume singi ge, teepi siige eclige teeme bau me. ");
INSERT INTO bon_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tabe twelb bine jejäcrimige teta cama otnetnejame piiyepu tabe teebibine ingwe ca ätyepame Miiji Mene jajanename ");
INSERT INTO bon_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","cuta niiyaniya cable bine äyecrejame. ");
INSERT INTO bon_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Age tema pui biname: Simona, Yeesu lui ne einige Peteru ca; ");
INSERT INTO bon_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu piiyepu teeme igane Yoane, Jebedayo me bägrä, Yeesu lui bine aainige Boargenes ca, peei lui egä, ‘Maadubi me bägrä’; ");
INSERT INTO bon_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","poto lui Andrea, Pilipo, Bartoloma, Matayo, Tooma, Yakobu Alapeus me bägrä, Tadeus, Simona Kanana sigu biname ");
INSERT INTO bon_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","piiyepu Yuuda Isakariyota, lui te Yeesu ne budre me jewabuji. ");
INSERT INTO bon_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yeesu teeme mete me acnenutige. Cääri bucurage biname cina abasecretnige teeme bau me, peei name pi tabe teeme abiberäja bägrä cama padare lica ge deedei äbitame. ");
INSERT INTO bon_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yeesu me inglewale cina liba itecijemige ai poto cidi me, teepi eclige teebine oomlaname, ingle biname cina jiicisi egä, “Tabe buduma te bii joomlige.” ");
INSERT INTO bon_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Poto cotre abiberäja biname lui cina Yerusalema ca itu seclumi, teepi apu jiicisi egä, “Yeesu me trupa cabu pisi nyene niiya cable bime mopeyame ngii Beelsebul. Tabe teeme kokre ca niiya cable bine yääyecräjemuge.” ");
INSERT INTO bon_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Puma cita ca Yeesu teebibine tesoglicmige, ngene ca agli mene ca jejemige egä, “Satani te baa lipu yääyecräjemuge niiya cable bine? ");
INSERT INTO bon_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nuuja gawe biname cina liba labelaninusi teemeteme cubu me, teepi watawata lapirininusi. ");
INSERT INTO bon_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cuta yepä ingle te liba labelanuge teemeteme cubu me, pui ingle te lica birige lenaja. ");
INSERT INTO bon_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yepä pana gyene, Satani piiyepu tabe lui bine yaawadimuge teepi liba labelaninusi teemeteme cubu me, teeme Satani me kokre te peega lapiruge, siige tabe yaatramuge. ");
INSERT INTO bon_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pätä laati te liba singi birige kokre biname me mete me abacita teeme gwidape bine waadename, tabe miiji niinäce teebine ätäya. Piba tabe labacituge teeme mete me, yaawadimuge teeme ngena yaacrajuge puma. ");
INSERT INTO bon_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cane toraca mene jijenininine: biname cina liba lijalija niiya mule bine jaawenimusi coo lipu bucurage niiyaniya mene jiicemusi, teepi miiji gemi kälyä äbitame pui niiya cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yepä laati te liba Aceji Seemo poto cidi me niiyaniya mene jiicemuge, pui niiya cabu ca tabe kälyä lica läbituge, ingle pui lui iyeteta niiya gyene.” ");
INSERT INTO bon_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeesu ai mene naace popi jiicige, ingle poto biname cina lipu jiicisi egä, “Teeme trupa ngalebora pisi nyene niiyarage cable. Pui te kokre yääcäruge tabe niiya cable bine äyecrejame.” Teepi opo lica ewatnisi, egä Aceji Seemo name kokre gyene ai. ");
INSERT INTO bon_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yeesu me mage piiyepu iganewale cina tatyarige mete gome, Yeesu luma enajige. Teepi puutucu je jeclajutemige, mene jityepisi teeme bau me, egä teepi singi teebine päpäname. ");
INSERT INTO bon_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bucurage biname cina adnatäreji puga ge, Yeesu ne jewaclomtisi, siige teepi jejisi egä, “Eei, määme mage piiyepu iganewale ete nemä puutucu je. Teepi singi määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeesu jejemige egä, “Laatu nwene cäme mage piiyepu laati bemi cäme naane igane?” ");
INSERT INTO bon_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tabe piba ire acitanige biname bime cabu me, lui cina adnatäreji icrajige, teebine jewaclomtisi, siige jejemige egä, “Ire, age tema cäme mage piiyepu cäme naane igane. ");
INSERT INTO bon_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Laati te liba Acejiyame me singi ne jaawenuge, tabe lui cäme naane, cäme igane, cäme ngule, cäme mage.” ");
INSERT INTO bon_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeesu cääri gije abacitige abiberäjame Galilaya sawa ligi je. Bucurage biname cina abasecretnige, teebine jewaclomtisi, tabe peei name pi poo cabu acenutige, adnatige, siige poo ne jityepäntisi. Biname cina sawa ligi je icrajimige. ");
INSERT INTO bon_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yeesu teebibine ngene ca agli mene ca ebiberäjimige bucurage mule poto cidi me. Tabe apu jiicige egä, ");
INSERT INTO bon_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Itecijinege! Yepä biname te ädige calwacupi me kuu gije bine iisabejame. ");
INSERT INTO bon_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Egäcäro tabe kuu gije bine yiisabäjemige, poto cina gaabe cabu itrametnemige, siige ele cina seclige, erwäjimisi. ");
INSERT INTO bon_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Poto kuu gije cina itrametnemige kula gawe cabu. Gawe puma paple gyene. Ingle gawe poone lica gyene, peei name pi gije cina watata tuupletnärige. ");
INSERT INTO bon_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yepä, bimu te liba nuunu täbitige, gije bine ebemimige, siige jedacromtemige, ingle teeme braju gawe ngalebora me lica ebäcnisi. ");
INSERT INTO bon_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Cuta poto kuu gije cina itrametnemige pägepäge mete bora. Pägepäge cina uutinisi, gije bine jetäyemisi, siige kuu lica jepänimisi. ");
INSERT INTO bon_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yepä poto kuu gije cina itrametnemige miijirage gawe cabu, tuupletnärige, uutinisi, jeciretnemige, siige kuu jepänimisi. Poto cina lui jepänimisi teeti kuu, poto cina lui siksti kuu, poto cina lui yepä hanred kuu. ");
INSERT INTO bon_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Weeme liba tablame piti nemi ätecijame, weene itecijinege umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yeesu taatu liba enajige, poto lui cina teta cama waatne-tnäjinusi, teepi abiberäja bägrä cama seclige teeme bau me, siige itemlisi ngene ca agli mene ne aboclomtame. ");
INSERT INTO bon_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yeesu jejemige egä, “Weeme bau me ituge aboclomta, Acejiyame te lipu biname bine waadena, yepä lui cina camu ge teeme mule oomlana, teeme bau me ngene ca agli mene taatu ituge iicema. ");
INSERT INTO bon_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Peei name pi toraca gyene, Acejiyame me mename biname lipu ituge iicana teeme poto cidi me egä, ‘Teepi puu jääpänusi cane ngena jaawenune, yepä teepi umle lica ngena tääpu myene. Cuta teepi puu yäätecijemuge cane lui mene jiicune, yepä teepi opo lica yaawatnusi. Peei name pi teepi lica tatatrongärininusi Acejiyame te teebibine kälyä wawename teeme niiya mule cabu ca.’” ");
INSERT INTO bon_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Puma cita ca Yeesu teebibine jejemige egä, “Weene liba lica ngene ca begliye cäme mene kuu gije iisabeja poto cidi me, weene cuta piba ngene ca lica peglemepeye poto ngene ca agli mene bine? Yoo siige, cane eboclomtenine. ");
INSERT INTO bon_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lui biname te kuu gije bine yiisabäjemuge, tabe Acejiyame me Mene jaajananemuge. ");
INSERT INTO bon_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lui kuu gije cina yaatrametnemuge gaabe cabu, pui lui eei biname bime pana gemi, lui cina mene liba yäätecijemuge, piba Satani te täduge, yääsecräremuge pui mene bine. ");
INSERT INTO bon_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lui kuu gije cina yaatrametnemuge kula gawe cabu, pui lui eei biname bime pana gemi, lui cina liba Miiji Mene yäätecijemuge, siige gege cama watata joomlusi. ");
INSERT INTO bon_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yepä teepi matikäli padare taatu jäätrungusi, ingle teepi epu pana braju cäco gije liiyepu. Teepi liba mäpu ne jääpänusi coo teeme poto cidi me liba jiicetnäjemusi, ingle teepi pui Miiji Mene ne jäätrungusi, teepi piba taatu teeme ätrunga bine yaabmalicmusi. ");
INSERT INTO bon_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lui kuu gije cina yaatrametnemuge pägepäge mete cabu, pui lui eei biname bime pana gemi, lui cina Miiji Mene yäätecijemuge, ");
INSERT INTO bon_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yepä mäpu ngene atwanena cina ai gawe ireclota poto cidi me cuta singi rarekaake piiyepu poto gwidape tääpume, teepi peei Mene ne jäätäyusi pägepäge seeasea pana, siige kuu cäco läbituge pui mene te. ");
INSERT INTO bon_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lui kuu gije cina yaatrametnemuge miijirage gawe cabu, pui lui eei biname bime pana gemi, lui cina Miiji Mene yäätecijemuge, opo yaawatnusi, siige teeme cabu kuu jaawenimuge, poto bime cabu teeti kuu, poto bime cabu siksti kuu, poto bime cabu yepä hanred kuu.” ");
INSERT INTO bon_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeesu cuta nuuja ngene ca agli mene jejemige egä, “Biname te liba lampa ne jaabotuge, tabe diiba ca lica yäätrugäruge coo lica yaacituge dade lolebora me, yepä cabu je yaatecwantuge mete ne apaclyerame. ");
INSERT INTO bon_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cuta pepu gyene, page biname bime bau ca ngena ämlitäneji gyene, pajecu me pagege äbita teeme tääpume, piiyepu page teepi lui mule umle lica gemi, teepi pagege umle äbita. ");
INSERT INTO bon_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Weeme liba tablame piti nemi ätecijame, weene itecijinege umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yeesu cuta jejemige egä, “Weene ngena itecijinuge, weeme mope cabu eciteye. Weene luma ngälu yääcärimuye biname bine, weebibine cuta puma ngälu birige ceera, cuta poto cerämu weebibine birige ceera. ");
INSERT INTO bon_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lui biname me umle pisi nyene, teebine cerämu ceera. Yepä lui biname umle cäco gyene, ingle tabe singi lica gyene umle tääpume, Acejiyame te teeme bau ca pa yaacatepi, teeme lui matikäli umle pisi nyene. ");
INSERT INTO bon_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeesu jejemige egä, “Apu gyene, Acejiyame te liba biname bine yaawadimuge. Yepä biname te kuu gije bine yiisabäjemuge teeme calwacupi cabu. ");
INSERT INTO bon_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tabe ciiye cabu ute waagruge, bimu cabu ireclota yaanajuge, cuta ciiye je waagruge. Peei padare cabu gije cina täpletnäruge, siige luutinusi, yepä tabe umle lica birige, egä ai mule te lipu läbituge. ");
INSERT INTO bon_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gawe te teemämu jaawenimuge gije bine uutaname, kuu wawename. Niinäce ingle cina luutinusi, puma cita ca mope, siige ingwe ca kuu cina täsuge mope cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kuu cina liba ngade läbitininusi, tabe ingle bine jaaclanimuge, ingle ärucna padare te bii tatyaramtige.” ");
INSERT INTO bon_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeesu jejemige egä, “Mine ngena mule ca yaatonärusi Acejiyame te biname bine lipu waadena? Mine pui mule ne lipu ngene ca agli mene ca yaaboclomtusi? ");
INSERT INTO bon_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Peei lui epu pana gyene mastad kuu gije, lui te matikälirage iyeta poto kuu gije bau ca. Liba jaacnuge gawe ngalebora me, ");
INSERT INTO bon_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","täpletnutuge, luutuge, siige baborage läbituge iyeta calwacupi gije cabu ca. Tabe uli pana jaaguge, modamoda ciipe bine jaawenimuge, siige ele cina saacluge, mete bine pui uuwa cabu yaarangäjemusi.” ");
INSERT INTO bon_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bucurage apu pana ngene ca agli mene ca Yeesu biname bine ebiberäjemige. Teepi luma ngälu ibi ge umle äbitame, tabe pui ibi jejananemige. ");
INSERT INTO bon_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tabe biname bine ngene ca agli mene taatu ca jejananemige, yepä tabe liba teeme abiberäja bägrä cama taatu enajige, tabe piba iyeta pui ngene ca agli mene bine eboclomäjimige teeme bau me. ");
INSERT INTO bon_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pui bimu mämleteca Yeesu abiberäja bägrä bine jejemige egä, “Biiri naclege, yuuresi sawa nuuja poto doro me.” ");
INSERT INTO bon_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Puma cita ca abiberäja bägrä cina biname bine sebmalimisi, acetnärige poo cabu me, Yeesu luma enajige, siige teepi teta cama abyemärinisi. Nuuja poo cina teebibine ingwe icwemimisi. ");
INSERT INTO bon_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Puma cita ca kokre buuwe te titwige, uule kuu cina tacetneräjininisi poo cabu me, siige poo te mameta ge niiye ca apana. ");
INSERT INTO bon_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeesu lui waapo jage ute, mope pila papa cabu jage. Puma cita ca abiberäja bägrä cina teebine elotnantisi, jejisi egä, “Abiberäja biname, maane nää owecu lica gäte, egä mine mameta gemi abumetna?” ");
INSERT INTO bon_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Siige tabe abujängtige, kokre cama buuwe ne jejige piiyepu uule kuu bine jejemige egä, “Siige! Bojä jiginege!” Puma cita ca buuwe te äjutige, siige bulubulu mataru te enajige. ");
INSERT INTO bon_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tabe jejemige egä, “Miiji lica gyene weene wälu äbita. Nää, weene cäro camu gemi cebine ätrunga?” ");
INSERT INTO bon_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Teepi mage wälu me äbitininisi, ätemläjinisi egä, “Baa laasi nyene ai biname? Buuwe piiyepu uule cina teeme mene jitecijisi.” ");
INSERT INTO bon_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeesu teeme abiberäja bägrä cama yuurige Galilaya sawa nuuja poto doro me Gerasene gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tabe liba poo cabu ca arpatige, tabe opopa eyige biname cama, lui tasatige kula waja cabu ca, budre biname bine luma gape yaacranimusi. Pui biname me trupa ngalebora puga ge niiyarage cable, ");
INSERT INTO bon_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","siige tabe kula waja cabu lui gape gemi, pui cabu yaanajuge. Nuuja te äblicäco ge teebine seea ca ätäya. ");
INSERT INTO bon_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bucurage gääbu teeme ernge piiyepu ime ituge ätäya ayana ca piiyepu seea ca, yepä iyeta padare cabu tabe seea bine jijweclimuge, ayana bine yaagabicmuge. Nuuja te kokre lica ge teebine iibaname. ");
INSERT INTO bon_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tabe iyeta padare, ciiye bimu, kula waja gape cabu ta piiyepu podo cabu ta diibe cäco waatnetnäjuge. Tabe niiya ala yaasatuge, kula ca däcu läcäranuge. ");
INSERT INTO bon_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tabe cudecewe pana ge, Yeesu ne liba jepänige, siige uuwamige teeme bau me, teeme opo gaabe je kokorare ca ääpednu-tige. ");
INSERT INTO bon_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yeesu jejige egä, “Niiya cable, ai biname cabu ca tasati!” Tabe babo ala abayige egä, “Yeesu, caburage Acejiyame me Bägrä, maane singi ngeno mäte cäme tääpume? Cane Acejiyame me ngii cabu naawejanenine, gone sabe nawenute cebine.” ");
INSERT INTO bon_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeesu itemlige egä, “Maane ngii laasi näte?” Tabe jejige egä, “Cane ngii lui Sange gäne, ingle cine bucurage gemi.” ");
INSERT INTO bon_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tabe Yeesu ne ewejanige egä, tabe teebibine lica yääyecräjemuge peei gawe cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Baborage ngeerangera blome tomi puga ge teeme mameta, podo wajwa cabu deedei tääpume yuunguretnäjemisi. ");
INSERT INTO bon_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Siige niiya cable cina Yeesu ne ewejanisi egä, “Cibibine nityepini blome bime trupa bora äbäcname,” ");
INSERT INTO bon_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","siige Yeesu jejemige teepi otnime. Puma cita ca niiya cable cina täsecrärige pui biname me trupa cabu ca, siige blome bime trupa cabu me ebäcnisi. Pui blome tomi lui neeneni tausen pana ge, podo wajwa ta uuwamitnige, sawa cabu me uupletnärige, siige abumetnige. ");
INSERT INTO bon_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Blome ire atwi biname cina uucratnige, idre ecenanisi babo cewe cabu me piiyepu teeme gome lui poto cewe piti nemi. Biname cina eclige päpäname, egä ngena te bäpletnutige. ");
INSERT INTO bon_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Teepi liba atyarige Yeesu bau me, teepi jepänisi biname ne, lui te niinäce niiya cable bine sewadenanemumi. Tabe puga ge adnatäneji, cäbletääpe asigräneji ge, miijirage ngene atwanena cama ge, siige teepi wälu me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lui cina jepänisi ai mule ne, teepi biname bine jejananemisi, ngena te bäpletnutige niiya cable cama biname tääpume piiyepu blome bime tääpume. ");
INSERT INTO bon_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Siige teepi Yeesu ne jejisi teeme gawe ne abmalame. ");
INSERT INTO bon_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yeesu liba biiri poo cabu me acenutige, niiya cable cina lui biname ne secenenanumesi, tabe Yeesu ne jejige teta cama otnime. ");
INSERT INTO bon_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yepä Yeesu äbwäricige, jejige egä, “Acnenuti määme binamewale bime bau me, jejemepi, määme Yageyame te ngena miiji bii naawenige piiyepu tabe lipu owecu ge määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pui biname te siige abyemärige, Ten Modamoda Cewe gawe cabu ta otnetnäjige, jejananemige, Yeesu ngena ituge wawena teeme tääpume. Iyeta biname cina mutäcäco äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeesu sawa ne yuurige, poo cabu ca arpatige, siige bucurage biname cina teeme bau me tabasecretnige, teebine jewaclomtisi sawa ligi je. ");
INSERT INTO bon_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yepä rooriye te cuta tädige ngii Yairus, lui yepä babo biname gyene pui cewe me abasecretna mete tääpume. Tabe Yeesu ne liba jepänige, ajarige teeme opo gaabe ernge gome, ");
INSERT INTO bon_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ewejanige egä, “Cäme matikäli bägrä budre mameta gwene. Tädi määme ime acitame teeme papa cabu me teebine miiji wawename, siige tabe piba ireclota ne jepäninige.” ");
INSERT INTO bon_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Puma cita ca Yeesu teta cama ädige. Bucurage biname cina teebine ingwe icwisi, siige jidudnecäjisi iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Puga ge cuta yepä magebi, lui te uudi apira pita cama ge twelb kämäge ngalebora. ");
INSERT INTO bon_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tabe magerage mäpu cabu waanajenanepi, liba maramara dokta bime bau me waatnanepi. Tabe puu iyeta teeme rarekaake bine yaaswemepi dokta bime bau me, yepä teepi äblicäco ge teebine ätityera, yepä teeme pita te baborage me läbitepi. ");
INSERT INTO bon_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tabe Yeesu poto cidi me ituge ätecija, siige ngene jotwanige egä, “Cane liba teeme cäbletääpe taatu joomlenine, cane pama miiji äbitenine.” Puma cita ca tabe biname bime sobe cabu oclige Yeesu me kaake poto cidi ca, ");
INSERT INTO bon_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","teeme cäbletääpe ne joomlige, siige pita te piba taatu apirige. Tabe asicnantige egä, “Cane miiji bäbitine!” ");
INSERT INTO bon_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yepä Yeesu piba taatu umle äbitige, egä kokre te basatige teeme cabu ca. Tabe biname bime sobe cabu atatrongtige, jejemige egä, “Cäme cäbletääpe ne laati te bii noomli-ge?” ");
INSERT INTO bon_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Teeme abiberäja bägrä cina jejisi egä, “Maane jepänenemite biname cina lipu näädudnecäjinisi, peei name pi maane ngeno me pepu nijinite, egä laati te cäme cäbletääpe noomlige.” ");
INSERT INTO bon_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yepä Yeesu ire acitanige biname bime bau me umle äbitame, egä laati te cebine bii noomlige. ");
INSERT INTO bon_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Siige pui magebi, lui te umle ge Yeesu ngena jewenige teeme tääpume, tabe wälu piiyepu aloneca cama toclige Yeesu bau me. Tabe teeme opo gaabe je ernge gawe me ajarige, jejige iyeta ngena cina bäbitininisi teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeesu jojige egä, “Bägrä, määme ätrunga te meebine miiji bii naawenige. Äte, maane ocli ngenecu poode cama. Määme pita te ingwe ca meebine lica pa noomlepi.” ");
INSERT INTO bon_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yeesu liba magebi cama camu mene iicema cabu, Yairus me mete cabu ca mene secanisi teeme bau me egä, “Määme bägrä siige budre gwene. Maane ngeno me cerämu jewagrijenite abiberäja biname ne maane cama otnime.” ");
INSERT INTO bon_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeesu liba itecijige, tabe Yairus ne jejige egä, “Wälu gone, miiji ätrunga taatu.” ");
INSERT INTO bon_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Siige puma cita ca tabe ädige teeme mete me. Tabe nuuja biname ne padare lica ecärige teta cama otnime yepä Peteru piiyepu Yakobu teeme igane Yoane cama. ");
INSERT INTO bon_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Teepi liba atyarige, Yeesu jepänige, biname cina lipu papa me äbitininisi, ele jolwisi. ");
INSERT INTO bon_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tabe mete cabu abacitige, biname bine jejemige egä, “Weene ngena guugla gemi? Weene ngena ele gemi? Bägrä budre lica gwene, tabe ute gwene.” ");
INSERT INTO bon_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yepä teepi Yeesu ne ngange ecwänisi, siige tabe teebibine puutucu me isemige. Piba tabe abacitige bägrä me mage, babe piiyepu teeme nesae abiberäja bägrä cama puupu cabu me, bägrä luma ätwitäneji ge. ");
INSERT INTO bon_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tabe ime gome jwoomlige, jojige egä, “Talita kuum,” lui egä, “Matikäli ngulebägrä, arpinanti!” ");
INSERT INTO bon_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tabe piba taatu arpinantige, siige gije abacitige otnetnejame. Tabe lui twelb kämäge ge. Lui cina ai mule ne jepänisi, teepi mutäcäco äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeesu kokre cama mene jejemige egä, “Gone biname bine jaajananemuye ai poto cidi me,” yepä tabe jejemige bägrä ne deedei ceerame. ");
INSERT INTO bon_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeesu teeme abiberäja bägrä cama pui cewe ne sebmalige, teemerage cewe me tacnenutige. ");
INSERT INTO bon_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabade bimu cabu tabe gije abacitige abiberäjame abasecretna mete cabu. Bucurage biname puga ge teeme mene itecijemige. Teepi mutäcäco äbitininisi, jiicisi egä, “Ai biname te luga tabiberäjumi iyeta ai? Tabe luma cita ca ai mule ne secatumi? Tabe lipulipu kokre cama mule bine jewenenemige? ");
INSERT INTO bon_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Egäsu tabe pui mete raranga biname gyene, Mariya me bägrä, Yakobu Yoose Yuuda Simona naabibime naane gyene. Teeme ngulewale aga icrajenanemige mine cama.” Puma cita ca teepi teebine jigyisi. ");
INSERT INTO bon_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeesu teebibine jejemige egä, ‘Acejiyame me mename biname ne yaacatusi iyeta poto ta, yepä lica teemerage cewe cabu je, teemerage inglewale cina piiyepu teeme mete biname cina.” ");
INSERT INTO bon_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tabe puu teeme ime aacitige nesae biname bime papa cabu me, siige teebibine miiji me jewenimige, yepä tabe bucurage ciitaca mule äblicäco ge wawena puma, ingle biname cina ätrunga cäco ge. ");
INSERT INTO bon_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tabe mutäcäco ge teeme ätrunga cäco mule name pi. Puma cita ca Yeesu otnetnäjige mameta cewe gaabegabe ta, biname bine ebiberäjimige. ");
INSERT INTO bon_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tabe pui twelb abiberäja bägrä bine tesoglicmige, neeneni neeneni jityepäjemige kaakesea wawename. Tabe kokre ecärimige niiya cable bine äyecrejame, ");
INSERT INTO bon_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","piiyepu jejemige egä, “Weeme otnetneja cabu je weene nuuja gwidape bine gone yaawadimuye yepä otnetneja suru taatu bine. Gone yaawadimuye deedei coo diiba coo rarekaake. ");
INSERT INTO bon_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Weene ernge gwidape asigräripeye, yepä gone yaawadimuye tuwängle cäbletääpe.” ");
INSERT INTO bon_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tabe cuta jejemige egä, “Weene liba lui cewe me naacluge, inajininuge biname cama, lui cina iwadininusi teeme mete me, ngälu weene pui cewe ne liba saabmaluye. ");
INSERT INTO bon_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yepä lui cewe cabu biname cina liba weebibine lica jiwablininusi coo lica jitecijinusi, teeme tuuwe bine jääglubäjemuye weeme ernge cabu ca, siige saabmaluye pui cewe ne. Teepi ai cabu ca umle läbitininusi, egä teepi pagege niiya daremu ne päpäna.” ");
INSERT INTO bon_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Siige puma cita ca abiberäja bägrä cina otnetnäjinisi, biname bine jejananemisi, egä teepi miiji teeme niiya mule cabu ca atatrongärame. ");
INSERT INTO bon_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Teepi bucurage niiya cable bine iyecräjemisi biname bime trupa cabu ca piiyepu pita biname bine oil ca eganimisi, siige teepi miiji äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Galilaya probins mope biname Heroda te itecijige Yeesu poto cidi me, ingle teeme ngii babo äbitige. Poto biname cina jiicisi egä, “Yeesu lui Yoane niiye ca äciseja biname sine. Acejiyame te teebine budre cabu ca yaarpinantepi, pui name pi teeme kokre pisi nyene ciitaca mule bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Poto cina jiicisi egä, “Tabe lui Eliya sine,” poto cina egä, “Tabe lui Acejiyame me yepä mename biname gyene, epu pana teeme sasa mename biname cina liiyepu.” ");
INSERT INTO bon_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yepä Heroda liba itecijige Yeesu poto cidi me, tabe jiicige egä, “Tabe Yoane sine, cane lui tääpume jaajemepene mope äläcnutame. Tabe te tacnenutumi ireclota me.” ");
INSERT INTO bon_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Heroda apu jiicige, ingle tabe teeme igane Pilipo me coga Herodiyas ne itu waacatepi. Yoane Heroda ne itu jaajananepi egä, “Peei lui conocono gyene maane määme igane me coga uutecra.” Puma cita ca Herodiyas te Heroda ne jaajepi Yoane ne oomlaname, seea ca ätäyame, krokeciiye mete cabu me acitame, siige Heroda te teeme singi ibi jaawenepi. ");
INSERT INTO bon_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiyas Yoane ne jäämugetnepi teeme mene name pi. Tabe singi ge teebine budre me acitame, yepä tabe äblicäco ge Heroda name pi. ");
INSERT INTO bon_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heroda lui wälu ge Yoane tääpume, ingle tabe opo yaawatnepi, egä Yoane lui miijirage conocäco biname gyene, tabe siige cängenarage ire jaatwepi. Tabe singi ge teeme mene ätecijame, ngänuge tabe puu ngenecu mäpu me läbitanuge, tabe liba jäätecijanuge. ");
INSERT INTO bon_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Siige Herodiyas te miiji padare ne jääpänepi, Heroda liba soriyomu ne jaawenepi teeme ärngi bimu tääpume. Tabe ala taasoglecmepi teeme ingwe gaabe ca lui modamoda biname bine, cubu mope biname bine piiyepu nuuja Galilaya ngii biname bine. ");
INSERT INTO bon_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Teepi liba deedei cabu jage, Herodiyas me beecma bägrä te piba tabacitige, giire jewäjige, siige Heroda piiyepu soriyomu biname bime ngenecu gege jewenimige. Heroda ngulebägrä ne jojige egä, “Naji, maane singi ngeno mäte? Cane nääcärenine. ");
INSERT INTO bon_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cane Acejiyame me ngii cabu naajenine, egä maane liba ngena tääpume nätinärenite, cane nääcärenine, ngänu gyene puu cäme gawe cebocebo.” ");
INSERT INTO bon_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Puma cita ca ngulebägrä te oclige mage ne ätemlame egä, “Cane ngena tääpume itinärenine?” Mage te jojige egä, “Jejepi Yoane niiye ca äciseja biname me mope tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngulebägrä te piba taatu acnenutige Heroda bau me, jejige egä, “Cane singi gäne maane cebine watata ceerame Yoane niiye ca äciseja biname me mope. Pleito cabu secanepi cäme bau me päpäna tääpume egä tabe budre.” ");
INSERT INTO bon_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ai mene te puu Heroda ne ngenecu mäpu me jewenige, yepä tabe äblicäco ge ngulebägrä me singi ne kaake me wawename, ingle tabe lui mene jojige soriyomu biname bime opo gaabe je. ");
INSERT INTO bon_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Siige tabe piba taatu yepä awamuta biname ne jityepige Yoane me mope ne äläcnutame, acaname. Awamuta biname te ädige krokeciiye mete me, Yoane me mope ne jeläcnutige, ");
INSERT INTO bon_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","pleito cabu secanige soriyomu puupu cabu me, siige ngulebägrä ne ocärige. Ngulebägrä te ocärige teeme mage ne. ");
INSERT INTO bon_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yoane me abiberäja bägrä cina liba itecijemige ai poto cidi me, teepi seclige, teeme budrekaake ne ecatisi, siige gape cabu me ecitisi. ");
INSERT INTO bon_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeesu me ätyepäneji biname cina täcnärige teeme bau me, jejisi, iyeta teepi ngena ituge wawena piiyepu abiberäja. ");
INSERT INTO bon_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Puma cita ca Yeesu teebibine jejemige egä, “Mine min taatu naclege taatu cewe me. Weene puma matikolä padare ngene poocineye.” Tabe apu naace popi jejemige, ingle bucurage biname cina iyeta padare cabu teeme bau me twaatninusi, peei name pi tabe teeme abiberäja bägrä cama padare lica ge deedei äbitame. ");
INSERT INTO bon_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Siige teepi taatu eclige poo gaabe biname cäco cewe me. ");
INSERT INTO bon_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yepä bucurage biname cina jepänimisi, teepi liba abyemärinisi, siige teepi opo ewatnimisi teebibine. Puma cita ca teepi iyeta maramara cewe cabu ca ernge ta uuwamitnige, niinäce puupu ne joomlisi, Yeesu lui puupu cabu me teeme abiberäja bägrä cama ädige. ");
INSERT INTO bon_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Teepi liba atyarige, Yeesu poo cabu ca arpatige, siige baborage biname tomi ne edärige. Tabe baborage owecu jeglemige teebibine, ingle teepi epu pana icrajige maamoi liiyepu, lui bime ire atwi biname lica gyene. Siige tabe gije abacitige teebibine abiberäjame bucurage mule poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Liba mämle bimu me äbitige, abiberäja bägrä cina seclige Yeesu bau me, jejisi egä, “Siige mämle gyene, cuta ai lui biname cäco cewe gyene, ");
INSERT INTO bon_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","peei name pi ai biname bine jityepimi mameta calwacupi cewe me piiyepu maramara cewe me teepi deedei aletname.” ");
INSERT INTO bon_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yepä Yeesu jejemige egä, “Weene te deedei ecäremeye teeme loolo me.” Teepi itemlisi egä, “Cije cine lipulipu teebibine engärenemisi? Mine liba singi gemi teebibine ngeerame, mine miiji neeneni hanred silba rarekaake ca deedei aletna.” ");
INSERT INTO bon_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu itemlimige egä, “Weeme lija buluduu gemi? Äte, naaclege päpäname!” Teepi jepänimisi, jejisi egä, “Cime faib buluduu gemi piiyepu neeneni cibu bumate gegi.” ");
INSERT INTO bon_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeesu puma cita ca abiberäja bägrä bine jejemige biname bine abelename maramara tomi wawename siige adnaterame baace cabu, ");
INSERT INTO bon_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","siige teepi maramara tomi cabu adnatärige. Poto tomi lui fifti biname ge, poto cerämu ngälu yepä hanred oomlaname. ");
INSERT INTO bon_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Puma cita ca Yeesu pui faib buluduu bine sewadimige neeneni cibu cama, cabu me ire acitige, Acejiyame ne eso ecärige, itrecimige, siige abiberäja bägrä bine ecärimige biname bine ceeraname. Tabe cuta pui neeneni cibu bine jaabelanige biname bine ceeraname. ");
INSERT INTO bon_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Teepi erwäjimisi, ngene jeglemige. ");
INSERT INTO bon_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abiberäja bägrä cina etomlicmisi lui deedei cibu cina cebo abamutinisi, jengärimisi, siige twelb diiba cina tapanininisi. ");
INSERT INTO bon_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lui rooriye cina erwäjimisi, teepi faib tausen ge. ");
INSERT INTO bon_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Piba taatu Yeesu abiberäja bägrä bine jejemige poo cabu acetnerame teeme niinäce gaabe otnime sawa nuuja poto doro me uuraname Betesaida cewe me, piba tabe pui padare cabu biname bine jityepäjemige. ");
INSERT INTO bon_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yeesu liba biname bine yewo jewenanemige, pui ingwe gaabe ca tabe ädige podo cabu me irecu ätumutame. ");
INSERT INTO bon_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Liba ciiye tumlige, poo lui sawa cunäcäpu jage, Yeesu teeme taatu doro cabu jage. ");
INSERT INTO bon_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tabe liba jepänige, egä teeme abiberäja bägrä cina niiya ne bii jepänisi poo äwäca cabu, ingle buuwe te opoporage tipwäjige, tabe sewali mameta me teeme bau me ädige niiye papa cabu ta. Tabe singi ge teebibine äsuplengame, ");
INSERT INTO bon_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","yepä abiberäja bägrä cina teebine jepänisi niiye papa cabu otni je. Teepi apu jengemige, egä dadrange ge, siige teepi niiya ala abayininisi. ");
INSERT INTO bon_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Teepi iyeta teebine jepänisi, siige babo wälu me äbitininisi. Puma cita ca Yeesu teebibine jejemige egä, “Wälu gone läbitininuye. Cane säne.” ");
INSERT INTO bon_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Puma cita ca tabe poo cabu acenutige, siige buuwe te äjutige. Abiberäja bägrä cina mutäcäco äbitininisi temiji pi. ");
INSERT INTO bon_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Teepi puu jepänisi, Yeesu buluduu piiyepu cibu bine bucurage me lipu jewenimige, yepä teepi opo lica ewatnisi teeme kokre ne, ingle teeme ngene atwanena tuuberage ge. ");
INSERT INTO bon_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yeesu teeme abiberäja bägrä cama sawa ne yuurige, atyaramtige Genesareta gawe cabu me, siige poo te puma ipyige. ");
INSERT INTO bon_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Teepi liba poo cabu ca ärpige, biname cina Yeesu ne piba taatu opo ewatnisi, ");
INSERT INTO bon_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","siige uuwamitnige, cewe gaabegabe ta idre ecenanisi. Biname cina liba itecijemige, egä Yeesu luci yene, teepi siige pita biname bine piiyeme waaku cabu ewadanemisi. ");
INSERT INTO bon_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iyeta poto ta Yeesu luma waatnetnäjuge: modamoda cewe, matimati cewe piiyepu calwacupi cewe cabu ta, puupu luma pajecu ge, piiyeme pita biname bine yaawadanemusi. Teepi Yeesu ne yaawejanusi pita biname cina teeme cäbletääpe pepyämu taatu oomlaname. Iyeta lui cina joomläjusi, miiji läbitininusi. ");
INSERT INTO bon_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisea sigu biname piiyepu Yerusalema ca lui poto cotre abiberäja biname cina seclumi, teepi abasecretnige Yeesu bau me. ");
INSERT INTO bon_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","3","Teepi jepänisi, egä teeme abiberäja bägrä cina ime äciseja cäco deedei erwäjemisi. Teepi peei lui saarewale bime mule ne lica jaawenusi Parisea biname piiyepu nuuja Israela biname bime pana, lui cina deedei lica loolo, teepi liba conocäcorage mule ca niinäce ime lica lääcisäjinusi cude gwidape cabu ca kälyä äbitame. ");
INSERT INTO bon_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cuta teepi liba täcnäruge aletna puupu cabu ca deedei cama, teepi pui deedei lica yäärwäjimusi, liba niinäce lica jääcisäjemusi. Piti nemi cuta bucurage poto saarewale bime mule, teepi lui bine jaawenimusi, naace teepi lipu conocäcorage mule ca jääcisäjemusi kaapo, pani, piiyepu lijalija ängära gwidape bine cuta piiyepu ute gwidape bine. ");
INSERT INTO bon_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Siige pui Parisea biname piiyepu cotre abiberäja biname cina Yeesu ne itemlisi egä, “Ngena name pi määme abiberäja bägrä cina saarewale bime mule bine lica yääcwetnimusi, yepä teepi äciseja cäco ime ca deedei loolo?” ");
INSERT INTO bon_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeesu jejemige egä, “Toraca gyene, mename biname Isaya lui niinäce gaabe mene jiicuji weeme poto cidi me. Weene walya biname gemi, tabe lipu soogäruji egä, ‘Ai biname cina cebine, lui Acejiyame gäne, teeme tage miipe ca nawepyeräjusi, yepä teeme ngene atwanena cudecewerage gyene cäme bau ca. ");
INSERT INTO bon_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nuuja miiji lica gyene teepi cebine opo gaabe me acitame, ingle teepi biname bine yaabiberäjimusi cotre bine äcwetname, lui cäme cotre lica gemi.’” ");
INSERT INTO bon_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeesu cuta jejemige egä, “Weene läbwäricinuye wawenecame, Acejiyame te ngena jijinuge, yepä weene saarewale bime mule bine jaawenimuye. ");
INSERT INTO bon_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Weene mage umle gemi Acejiyame me Mene ägyi saarewale bime mule bine cängenarage äcwetname. ");
INSERT INTO bon_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moose te jiicuji egä, ‘Weene miiji mage babe bine opo gaabe me acita,’ piiyepu egä, ‘Laati te liba teeme mage babe poto cidi me niiyarage mene jiicemuge, teebine miiji budre me acita.’ ");
INSERT INTO bon_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yepä weene te yaabiberäjimuye, egä laati te liba teeme mage babe bine jaajuge egä, ‘Cane äblicäco gäne weebibine ätityera, ingle cane lui gwidape ca ätityerame weebibine, cane itu secitumene Acejiyame tääpume,’ ");
INSERT INTO bon_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","siige tabe kälyä läbituge teeme mage babe bine ätityera cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Weene Acejiyame me Mene ne kaake me jaawenuye saarewale bime mule ca, weene lui yaabiberäjimuye. Piti nemi bucurage apu pana mule, weene lui bine jaawenimuye.” ");
INSERT INTO bon_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeesu biname bine cääri tesoglicmige teeme bau me, jejemige egä, “Weene iyeta cebine nätecijeye, umle äbitinineye. ");
INSERT INTO bon_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lui gwidape te labacituge biname me trupa ngalebora me, pui te äblicäco gyene teebine niiya me wawename. Yepä lui te tasatuge teeme ngenecu cabu ca, pui te teebine niiya me jaawenuge. ");
INSERT INTO bon_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Weeme liba tablame piti nemi ätecijame, weene itecijinege.” ");
INSERT INTO bon_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Puma cita ca Yeesu biname bine sebmalimige, mete me abacitige. Puma teeme abiberäja bägrä cina teebine itemlisi pui ngene ca agli mene ne aboclomtame. ");
INSERT INTO bon_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yeesu jejemige egä, “Baa weene cuta umle lica gemi! Weene nää lica jepäneniye, egä ngena te labacituge biname me trupa cabu me, peei te äblicäco teebine niiya me wawename, ");
INSERT INTO bon_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ingle lica labacituge teeme ngenecu bora me yepä teeme came cabu me, siige ingwe ca tasatuge teeme cabu ca.” Ai iicema cabu Yeesu jiicige, egä nuuja deedei cibu cude lica gemi. ");
INSERT INTO bon_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Puma cita ca tabe jiicige egä, “Lui te tasatuge biname me ngalebora ca, peei te teebine niiya me jaawenuge. ");
INSERT INTO bon_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngalebora ca, biname me ngenecu bora ca saacluge niiyarage ngene atwanena cina. Puma cita ca cuta saacluge singi sargi ero mule wawename, singi gwidape ero me, budre me aglime, ");
INSERT INTO bon_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mule wawename biname cama lui te teeme coga coo rooriye lica birige. Ngenecu bora ca cuta saacluge gwidape singisingi cina, piiyepu singi nuuja maramara niiya mule bine wawenetnäjame, angletnejame, ajiri cama mule wawename, ire patre aglime, niiyaniya mene iicetnejame, teemämu awepyeräjame, budubuduma mule wawenecame. ");
INSERT INTO bon_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyeta ai niiya singisingi cina, lui ngalebora ca saacluge, biname ne niiya me jaawenusi.” ");
INSERT INTO bon_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Puma cita ca Yeesu abyemärige, ädige babo cewe Turo gawe cabu me. Tabe yepä mete cabu me abacitige, siige tabe singi lica ge nuuja biname te umle äbitame, egä tabe pisi nyene mete cabu, yepä tabe äblicäco ge ämlitäneji lenaja. ");
INSERT INTO bon_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yepä magebi, lui me ngulebägrä niiya cable cama ge, liba utecijige Yeesu poto cidi me, tabe piba taatu teeme bau me toclige, siige ajarige teeme opo gaabe je ernge gome. ");
INSERT INTO bon_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ai magebi lui Israela biname lica gwene, tabe Griik meneyame magebi gwene. Tabe Poenikiya babo cewe je aplimluji Suriya gawe cabu je. Siige tabe Yeesu ne ewejanige niiya cable ne asatame teeme bägrä me trupa cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yepä Yeesu ngene ca agli mene ca jojige egä, “Miiji niinäce bägrä bine deedei ceera. Niiya gyene teeme deedei acata, drego plongo bime tääpume iisaba.” ");
INSERT INTO bon_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Magebi te Yeesu ne teeme ngene ca agli mene jewecnistige, jejige egä, “Toraca babo biname, yepä dade gawe me lui drego plongo cina lätwitaninusi, teepi yäärwäjimusi pläpupläpu bine, bägrä bime bau ca lui cina saatrametnemuge.” ");
INSERT INTO bon_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu jojige egä, “Maane miijirage mene ca nawecnistite. Äte ocli mete me. Niiya cable te bii tasatige määme bägrä me trupa cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Magebi te acnenutige teeme mete me, puma bägrä ne jopänige ätwitäneji ge ute puupu cabu, siige umle äbitige, egä cable te bii basatige. ");
INSERT INTO bon_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeesu ebmalige babo cewe Turo gawe ne, Sidona babo cewe ta ädige piiyepu Ten Modamoda Cewe gawe cabu ta, ngälu Galilaya sawa ne joomlige. ");
INSERT INTO bon_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Puma teeme bau me ecanisi tablame buduma biname ne, lui te mene cängena lica jiicemuge. Teepi Yeesu ne ewejanisi teeme tääpe ne oomlaname. ");
INSERT INTO bon_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeesu teebine ecatige biname bime sobe cabu ca, taatu cewe me ecanige. Puma tabe teeme ime kukluta aacitige teeme tablame bora me, piba mote eclemutige teeme ime kukluta cabu me, siige joomlige teeme wätä ne. ");
INSERT INTO bon_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Piba tabe ire acitige cabu me, ngenecu mäpu äbitige owecu name pi, siige jejige Aramea mene ca egä, “Epata” lui egä, “Iitneye”. ");
INSERT INTO bon_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Piba taatu teeme tablame cina iitnäsi, siige tabe cängenarage mene itecijige piiyepu teeme wätä te apinicige, tabe siige piba mene cängena jiicemige. ");
INSERT INTO bon_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Puma cita ca Yeesu biname bine jejemige, egä teepi gone ai poto cidi me mene jajanena. Ngänuge, tabe puu jiibanemige, yepä teepi jejananemisi. ");
INSERT INTO bon_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Siige iyeta biname cina mutäcäco äbitininisi, jiicisi egä, “Iyeta mule tabe lui itu tewenetnäjimumi, babo miijirage gemi. Tabe cuta tablame buduma biname bine jaawenimuge mene ätecijame piiyepu mene iicema cäco biname bine jaawenimuge mene iicemame.” ");
INSERT INTO bon_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pui padare cabu bucurage biname cina cääri tabasecretnige Yeesu bau me. Teeme liba nuuja deedei lica abmalige loolo me, Yeesu abiberäja bägrä bine tesoglicmige, jejemige egä, ");
INSERT INTO bon_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cane baborage owecu gäne ai biname bime tääpume, ingle teepi cane cama ituge lenaja nesae bimu cama, siige teeme deedei bämlige. ");
INSERT INTO bon_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cane liba loolomecewe jityepenemine teeme cewe me, teepi gaabegabe cije irecu laboclomäjininusi, ingle poto cina cudecewe cewe ca seclumi.” ");
INSERT INTO bon_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abiberäja bägrä cina Yeesu ne mene jewecnistisi egä, “Mine äblicäco gemi ama ai daapo taatu cewe cabu ai biname bine ängära.” ");
INSERT INTO bon_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeesu itemlimige egä, “Weeme lija buluduu gemi?” Teepi jejisi egä, “Cime seben gemi.” ");
INSERT INTO bon_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Puma cita ca Yeesu biname bine jejemige gawe cabu adna-terame. Piba tabe pui seben buluduu bine sewadimige, Acejiyame ne eso ecärige, itrecimige, ecärimige abiberäja bägrä bine teepi biname bine ceeraname, siige teepi ecäranemisi. ");
INSERT INTO bon_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Teeme cuta puga ge nesae matimati cibu bumate. Yeesu eso ecärige cibu tääpume, jejemige abiberäja bägrä cina biname bine ceeraname. ");
INSERT INTO bon_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Iyeta biname cina erwäjimisi, siige ngene jeglemige. Teepi lui fooa tausen biname ge. Abiberäja bägrä cina deedei pacupacu bine etomlicmisi, seben modamoda diiba bine jengärimisi, siige teepi tapanininisi. Puma cita Yeesu biname bine jityepimige teeme cewe me. ");
INSERT INTO bon_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pui ingwe gaabe ca tabe piba taatu acenutige poo cabu teeme abiberäja bägrä cama, siige teepi eclige Dalmanuta gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Poto Parisea sigu biname cina seclige, gije abacitinisi Yeesu cama äcelame. Teepi singi teebine apicetnärame, siige jejisi ciitaca mule wawename pui ca awabame, egä Acejiyame te teebine ituge ätyepa. ");
INSERT INTO bon_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeesu ngenecu mäpu me äbitige, jejemige egä, “Weene puu tepänanemimuye cane lui ciitaca mule bine tewenanemumene, yepä weene nätemläjeniye cane cerämu wawename. Cane toraca jijenininine: cane licarage nuuja ciitaca mule ne wawena weene päpäname.” ");
INSERT INTO bon_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Puma cita ca tabe teebibine sebmalimige, acenutige poo cabu teeme abiberäja bägrä cama, siige teepi sawa ne yuurisi nuuja poto doro me. ");
INSERT INTO bon_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abiberäja bägrä cina ngene jitrimalemige buluduu waadename, peei name pi teeme yepä taatu buluduu puga ge poo cabu. ");
INSERT INTO bon_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeesu teebibine umle mene jejemige Heroda piiyepu Parisea sigu biname bime poto cidi me. Tabe ngene ca agli mene ca apu jiicige egä, “Weene cängena ire Parisea biname bime piiyepu Heroda me uutneca gwidape tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Teepi mene opo lica ewatnisi, siige teemeteme jitranisi egä, “Tabe pama apu nijenininige, ingle mime buluduu lica gemi.” ");
INSERT INTO bon_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeesu umle äbitige, teepi ngena tääpume jiicemisi, siige tabe jejemige egä, “Weene ngena name pi jitraniniye, egä weeme buluduu lica gemi? Weene nää camu gemi cäro opo awatna coo umle äbita? Weeme ngene atwanena nää tuuberage gemi? ");
INSERT INTO bon_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Weeme puu tablame piti nemi, yepä weene lica itecijinuge, piiyepu weeme puu irecu piti nemi, yepä weene lica jääpänimuye. Weene nää ngene lica jotwiniye, ");
INSERT INTO bon_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","cane liba faib buluduu bine yäätrecemepene faib tausen biname bime tääpume, weene lija diiba apanäneji jäängäremepeye deedei pacupacu ca?” Teepi jejisi egä, “Twelb diiba.” ");
INSERT INTO bon_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tabe cuta itemlimige egä, “Cane liba seben buluduu bine sitrecimumene fooa tausen biname bime tääpume, lija modamoda diiba apanäneji weene tengärimumeye deedei pacupacu ca?” Teepi jejisi egä, “Seben diiba.” ");
INSERT INTO bon_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Puma cita ca Yeesu jejemige egä, “Weene cäro camu gemi umle äbita cäme poto cidi me.” ");
INSERT INTO bon_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Teepi atyarige cewe ngii Betesaida me. Puma biname cina irecu määsumäsu biname ne secanisi Yeesu bau me, siige ewejanisi teeme tääpe oomlaname. ");
INSERT INTO bon_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeesu teebine ime gome joomlige, ecanige taatu cewe me. Tabe teeme irecu bine mote ca äätyewärige, ime aacitige teeme papa cabu me, itemlige egä, “Nää, maane gwidape bine jepänenemite?” ");
INSERT INTO bon_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tabe ire acitanige, jiicige egä, “Yoo, cane biname bine jepänenemine, yepä teepi epu pana gemi uli, lui cina otnenininisi.” ");
INSERT INTO bon_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeesu cääri ime aacitige teeme irecu cabu me. Puma cita ca pui biname te kokre cama ire acitanige, siige teeme irecu cina aasatäsi, piba tabe iyeta gwidape bine cängena jepänanemige. ");
INSERT INTO bon_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeesu teebine jityepige cewe me apu mene cama egä, “Gone loclomute cewe me biname bine jajanename ai poto cidi me, yepä gaabe ta ädepi määme mete me.” ");
INSERT INTO bon_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeesu teeme abiberäja bägrä cama ädige Kesarea Pilipo gawe cabu lui cewe gemi, pui cewe cabu ta otnetnejame. Gaabegabe Yeesu teebibine itemlimige egä, “Biname cina lipu jiicusi, egä cane laasi näne?” ");
INSERT INTO bon_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Teepi jejisi egä, “Poto cina lui jiicusi, egä maane Yoane niiye ca äciseja biname säte. Poto cina jiicusi, egä maane Acejiyame me mename biname Eliya säte; poto cina egä, maane teeme nuuja mename biname gäte.” ");
INSERT INTO bon_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yeesu teebibine itemlimige egä, “Cije weene, weene lipu jiiceniye, egä cane laasi näne?” Peteru jejige egä, “Maane Keriso säte, biname bine lui te niiya cabu ca pa yääsecräremepi.” ");
INSERT INTO bon_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeesu kokre cama jejemige, egä teepi nuuja biname bine gone jajanena teeme poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yeesu gije abacitige abiberäja bägrä bine abiberäjame. Tabe jejemige egä, “Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane miiji mäpurage gwidape bine pagege päpäna piiyepu Israela modamoda biname, modamoda iiwäreja biname piiyepu cotre abiberäja biname cina pagege cebine ägyi. Cebine budre me pagege acita, yepä nesae me lui bimu cabu cane piba pa larpinantepene ireclota me.” ");
INSERT INTO bon_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tabe pajecurage jiicige ai poto cidi me. Puma cita ca Peteru Yeesu ne taatu cewe me ecanige, gije jebacitige teeme mene name pi ablawejame. ");
INSERT INTO bon_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yepä Yeesu atatrongtige, teeme abiberäja bägrä bime cabu me ire acitige, siige Peteru ne kokre cama mene jejige egä, “Satani, cäme opo gaabe ca äyeblingti. Määme ngene atwanena lui Acejiyame bau ca lica gyene, yepä biname bime cabu ca gyene.” ");
INSERT INTO bon_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Puma cita ca Yeesu biname bine piiyepu teeme abiberäja bägrä bine tesoglicmige, jejemige egä, “Biname te liba singi cane cama otnime, tabe miiji teemerage singi bine gawe me acrana, teeme baarge uli ne palace cabu acana siige cebine ingwe äcwi. ");
INSERT INTO bon_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Laati te liba singi lica teemerage singi bine abmaläcemame, tabe teeme ireclota ne cirege apesera. Yepä, laati te singi ge teemerage singi bine abmaläcemame ingle cane piiyepu Miiji Mene name pi, tabe toraca ireclota ne cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Biname te nuuja miiji ne lica cire jääpänepi, ngänu gyene tabe puu iyeta ai gawecewe ne yaacatuge, yepä teeme ireclota ne yaapesaruge. ");
INSERT INTO bon_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nuuja gwidape lica gyene ceerame teeme ireclota awecnista daremu me. ");
INSERT INTO bon_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Laati te liba cebine nägyenige piiyepu cäme mene ibi lica äbitenige ai padare cabu, biname cina liba niiya mule bine jaawenimusi piiyepu sargi mule yaacnemusi, cane lui te Acejiyame bau ca tädujine biname me äbitujine, cane cuta teebine cirege ägyi, cane liba Babe me jamyacu apaclyera cama piiyepu teeme mename seemo cama cire tacnepene ai gawecewe cabu me.” ");
INSERT INTO bon_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tabe cuta jejemige egä, “Cane toraca mene jijenininine: ama poto lui cina jeclajutäjenemige, budre lica cire läbitipesi, ngälu teepi niinäce cire jääpänepesi Acejiyame te biname bine waadena kokre cama.” ");
INSERT INTO bon_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siks bimu ingwe gaabe ca Yeesu aacanänige Peteru, Yakobu piiyepu Yoane teta cama, teebibine opo jaawenänige baborage podo cabu me, siige teepi puma taatu ge. Podo cabu abiberäja bägrä bime opo gaabe je Yeesu mara opo me äbitige, ");
INSERT INTO bon_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","piiyepu teeme cäbletääpe äbitininisi aiyai me, epu bulu me, egä nuuja te äblicäco gyene äciseja pepu bulu me. ");
INSERT INTO bon_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Puma cita ca Eliya naabi Moose taboclomtäsi iyeta teeme bau me, siige teepi mene jiicemäsi Yeesu cama. ");
INSERT INTO bon_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peteru Yeesu ne jejige, “Abiberäja biname, cine miijirage gämi ama. Cine nesae matimati mete bine aarange-nänogo: yepä määme, yepä Moose me, yepä Eliya me.” ");
INSERT INTO bon_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peteru umle lica ge, ngena nuuja mene iicana, ingle teepi iyeta pipu wälu ge. ");
INSERT INTO bon_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Piba carbe te tädige, teebibine aacwabänige. Carbe cabu ca tagepogogo te tädige egä, “Ai lui cäme ngenecurage Bägrä gyene. Weene teebine jitecijeye.” ");
INSERT INTO bon_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Abiberäja bägrä cina liba wata ire acranänisi, teepi yepä Yeesu ne jepänisi. ");
INSERT INTO bon_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Teepi liba podo cabu ca täinetnänisi, Yeesu jääjänige egä, “Weene lui mule ne bii jepäniye, gone biname bine jajanena, ngälu cane lui Acejiyame bau ca tädujine biname me äbitujine, budre cabu ca pagege arpinenta.” ");
INSERT INTO bon_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Teepi puu teeme mene jitecijänisi, yepä teemeteme jitranänisi, egä teeme budre cabu ca arpinenta baa ngena gyene? ");
INSERT INTO bon_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Puma cita ca teepi Yeesu ne itemlänisi egä, “Ngena name pi cotre abiberäja biname cina jiicusi, egä Eliya cirege otni Keriso me niinäce gaabe me?” ");
INSERT INTO bon_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yeesu Yoane niiye ca äciseja biname poto cidi me jääjänige egä, “Peei toraca gyene, egä Eliya miiji niinäce otni iyeta gwidape amacetnäjame. Cuta cane jijenininine, egä tabe uja itu tädepi, yepä biname cina teebine epu jaawenepesi, teepi lipu singi ituge, Oogäräneji mene te teeme poto cidi me lipu jiicenige. Yepä Oogäräneji mene te ngena name pi jiicenige cäme poto cidi me, Acejiyame bau ca lui te tädujine biname me äbitujine, egä cane miiji mäpu cabu lenaja piiyepu biname cina cebine pagege ägyi?” ");
INSERT INTO bon_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Teepi liba nuuja abiberäja bägrä bime bau me täcnäränisi, teepi jepänimisi bucurage biname cina teebibine jewaclomtemisi piiyepu poto cotre abiberäja biname cina jicelisi teta cama. ");
INSERT INTO bon_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Egäcäro biname cina Yeesu ne jepänisi, teepi cälu te jitemige, piba taatu uuwamitnige teebine awablame. ");
INSERT INTO bon_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeesu abiberäja bägrä bine itemlimige egä, “Weene teta cama ngeno me jiceliniye?” ");
INSERT INTO bon_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Siige biname bime sobe cabu ca yepä te jejige egä, “Abiberäja biname, cane cäme bägrä ne secanine määme bau me, ingle niiya cable te teebine mene iicema cäco me jaawenuge. ");
INSERT INTO bon_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Liba teebine joomluge, gawe me yaajaruge, siige tage cabu ca bulubulu mote cina täsuge, tabe giricu bine yaatebicmuge cuta duudemu te yaagluge. Cane puu määme abiberäja bägrä bine jejemine cable ne äyecrejame, yepä teepi äblicäco ge wawena.” ");
INSERT INTO bon_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeesu teebibine jejemige egä, “Oo weene ätrunga cäco biname gemi! Luma ngälu padare cane miiji weene cama lenaja? Luma ngälu padare cane miiji weeme ätrunga cäco mule päpäna? Peei bägrä ne secaneye.” ");
INSERT INTO bon_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Puma cita ca teepi teebine Yeesu bau me ecanisi. Cable te liba Yeesu ne jepänige, tabe bägrä ne came jedenutäjige, siige bägrä te itramige gawe me, adimlicige, bulubulu mote cina täsige teeme tage cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeesu babe ne itemlige egä, “Tabe luma ngälu padare ituge apu lenaja?” Tabe jewecnistige egä, “Matikäli bägrä cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cable te cuta teebine yaajaräjuge uliobo cabu me piiyepu niiye cabu me teebine budre me acitame. Maane cibibine owecu niweni, nitityäri, liba ibibi gäte.” ");
INSERT INTO bon_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeesu jejige egä, “Maane ngeno me najite, egä cane liba ibibi gäne. Lui me ätrunga pisi nyene, tabe miiji gyene iyeta gwidape wawenetnäja.” ");
INSERT INTO bon_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Piba babe te babo tage ca jiicige egä, “Cäme ätrunga pisi nyene, yepä nätityäri cane cerämu ätrungame!” ");
INSERT INTO bon_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yeesu liba jepänige, egä biname cina tuuwamitnige teeme bau me, tabe cable ne kokre cama mene jejige egä, “Niiya cable, lui te ai bägrä ne jewenenite tablame buduma me piiyepu mene iicema cäco me, cane naajenine, maane tasati teeme trupa cabu ca piiyepu ingwe ca gone labacitute.” ");
INSERT INTO bon_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cable te babo ala isatige, bägrä me came kokre cama jedenutäjige, siige ebmalige teebine. Bägrä te apineca cäco enajige budre pana, siige bucurage biname cina jiicisi egä, “Tabe budre gyene.” ");
INSERT INTO bon_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yepä Yeesu teebine ime gome joomlige, erpinantige, siige tabe jeclajutige. ");
INSERT INTO bon_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yeesu liba mete bora me abacitige, abiberäja bägrä cina ogä itemlisi egä, “Cine ngena name pi äblicäco ge niiya cable ne äyecreja?” ");
INSERT INTO bon_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tabe jejemige egä, “Apuyame ne weene äblicäco nuuja mule ca äyecreja yepä irecu ätumuta ca.” ");
INSERT INTO bon_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Teepi pui gawe ne sebmalisi, otnetnäjinisi Galilaya gawe cabu ta. Yeesu singi lica ge nuuja biname te umle äbitame, egä teepi puga ge, ");
INSERT INTO bon_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ingle tabe abiberäja bägrä bine ebiberäjimige. Tabe jejemige egä, “Lui te Acejiyame bau ca täduji biname me äbituji pagege acita biname bime ime cabu, siige teepi pa yaacitepesi budre me, yepä nesae me lui bimu cabu tabe piba pagege arpinenta budre cabu ca ireclota me.” ");
INSERT INTO bon_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Teepi ai mene ne opo lica ewatnisi, yepä teepi wälu ge Yeesu ne ätemlame. ");
INSERT INTO bon_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Teepi atyarige Kaprenauma cewe me, siige mete me ebäcnisi. Puma Yeesu abiberäja bägrä bine itemlimige egä, “Weene gaabegabe ngena tääpume titraniye?” ");
INSERT INTO bon_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yepä teepi bojä ge, ingle teepi gaabegabe je titranisi, egä teeme cabu ca laasi nyene baborage. ");
INSERT INTO bon_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeesu adnatige, twelb abiberäja bägrä bine tesoglicmi-ge, jejemige egä, “Laati te liba singi niinäce gaabe me äbitame, tabe miiji teemämu ceräcerägääbu me äbita piiyepu iyeta biname bime ätityera biname lenajame.” ");
INSERT INTO bon_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Puma cita ca tabe bägrä ne ecatige, abiberäja bägrä bime cole je ecitige, jejecletnäjige, jejemige egä, ");
INSERT INTO bon_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Laati te apu bägrä yepä ne jaawabluge cäme ngii cabu, tabe cebine nawabluge; piiyepu laati te cebine nawabluge, tabe cebine taatu lica nawabluge, yepä pui ne jaawabluge, lui te cebine nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoane te Yeesu ne jejige egä, “Abiberäja biname, cine biname ne jepänisi, lui te niiya cable bine yääyecräjemuge määme ngii cabu. Cine jejisi tabe pui mule ne abmalame, ingle tabe mime yepä lica gyene.” ");
INSERT INTO bon_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yeesu abiberäja bägrä bine jejemige egä, “Weene teebine gone iibana, ingle lui biname te kokre mule ne jaawenuge cäme ngii cabu, tabe äblicäco watata cäme poto cidi me niiya mene iicana. ");
INSERT INTO bon_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Laati te liba lica nicisärmutininuge, tabe lui mime tääpu myene. ");
INSERT INTO bon_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cane toraca mene jijenininine, laati te liba icärininuge niiye nanime cäme ngii cabu, ingle weene Keriso me abiberäja bägrä gemi, tabe cirege teeme miiji daremu ne päpäna.” ");
INSERT INTO bon_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ai matimati bägrä lui cina cebine nätrungusi, laati te liba teeme yepä ne jaawenuge niiya mule wawename, pui biname te mäpu ne cirege päpäna Acejiyame bau ca. Teeme singicace cabu liba jaaglotusi mäpu kula ne siige malu cabu yaajarusi budre me, peei mäpu lui plowa birige pui mäpu cabu ca, tabe lui ne cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Peei name pi määme ime te liba naawenuge maane singi ädrime niiya mule wawename, maane watatarage yääyeblingtute pui ngene atwana ne, epu pana ime ne lipu jääläcnutute. Miiji gyene, maane yepä ime cama otni iyeteta ireclota cabu me, yepä niiya gyene maane neeneni ime cama otni niiya puupu cabu me, uliobo luma ätuma cäco gyene. ");
INSERT INTO bon_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Puma lui cuple cina teebibine yäärngäjimusi, teepi budre lica cirege, piiyepu lui uliobo te teebibine yaabemuge, ätuma cäco cirege. ");
INSERT INTO bon_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Piiyepu määme ernge te liba naawenuge maane singi ädrime niiya mule wawename, maane watatarage pui ngene atwana ne yääyeblingtute, epu pana ernge ne lipu jääläcnutute. Miiji gyene maane yepä ernge cama iyeteta ireclota cabu me otni, yepä niiya gyene maane neeneni ernge cama uliobo puupu cabu me otni. ");
INSERT INTO bon_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Puma lui cuple cina teebibine yäärngäjimusi, teepi budre lica cirege, piiyepu lui uliobo te teebibine yaabemuge, ätuma cäco cirege. ");
INSERT INTO bon_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Cuta piiyepu määme irecu te liba naawenuge maane singi ädrime niiya mule wawename, maane watatarage pui ngene atwana ne yääyeblingtute, epu pana irecu ne lipu juungyatute. Miiji gyene maane yepä irecu cama iyeteta ireclota cabu me otni, yepä niiya gyene maane neeneni irecu cama uliobo puupu cabu me otni. ");
INSERT INTO bon_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Puma lui cuple cina teebibine yäärngäjimusi, teepi budre lica cirege, piiyepu lui uliobo te teebibine yaabemuge, ätuma cäco cirege. ");
INSERT INTO bon_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mäpu cabu lenaja lui weebibine jugi cäco me jiwenininusi Acejiyame tääpume, epu pana uliobo te lipu domäji bine yaabemuge piiyepu iiwäreja cibu bine lipu caapere niiye ca yaamacetnäjimusi Acejiyame me tääpume. ");
INSERT INTO bon_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Caapereniiye me kaakesea pisi nyene, yepä liba teeme mite ne apesera, weene ingwe ca äblicäco wawena caapereniiye mite me. Weene cuta miiji caapereniiye pana mitemite lenaja. Cuta weene miiji weemeweme poode cama lenaja.” 9 0 9 0 ");
INSERT INTO bon_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeesu pui cewe ne sebmalige, Yuudea probins cabu me ädige, siige Yoridana baduge ne yuurige. Bucurage biname cina cääri tabasecretnige teeme bau me, teebine jewaclomtisi, siige tabe teebibine ebiberäjimige teeme mule liiyepu. ");
INSERT INTO bon_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Puma cita ca poto Parisea sigu biname cina seclige teebine apicetnärame. Teepi itemlisi egä, “Nää, Cotre ibi gyene rooriye te teeme coga ne ägyi?” ");
INSERT INTO bon_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeesu teebibine itemlimige egä, “Moose lipu itu jijinuji weene wawename?” ");
INSERT INTO bon_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Teepi jejisi egä, “Moose te rooriye ne conocäco ecäruji peba ne oogärame ägyi ingle poto cidi me, siige piba pui peba cama coga ne jwäätyepute.” ");
INSERT INTO bon_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeesu jejemige egä, “Ingle weene ätecija cäco gemi, peei name pi Moose pui mene yoogäruji weeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yepä agedna padare cabu Acejiyame te liba biname bine jewenimuji, tabe magebi me piiyepu rooriye me jewenimuji. ");
INSERT INTO bon_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pui name pi rooriye te miiji teeme mage babe bine gomala teeme coga cama atejäclmutame, ");
INSERT INTO bon_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","siige teepi neeneni cina yepä me läbitäsi. Teepi page neeneni lica gegi, teepi yepä gegi. ");
INSERT INTO bon_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Peei name pi lui coga cama Acejiyame te rooriye ne yaatejäclmutuge, nuuja biname te gone teebibine mara me wawena.” ");
INSERT INTO bon_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ingwe ca Yeesu liba teeme abiberäja bägrä cama mete cabu jage, teepi cääri itemlisi ai poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tabe jejemige egä, “Rooriye te liba teeme coga ne jwäägyuge, nuuja ne waacatuge, tabe ero mule ne jaawenuge. ");
INSERT INTO bon_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cuta coga te liba teeme rooriye ne jäägyuge, nuuja ne yaacatuge, tabe cuta ero mule ne jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Biname cina bägrä bine sewadimisi Yeesu bau me tabe ime acitame teeme papa cabu me, yepä abiberäja bägrä cina teebibine jicnecimisi. ");
INSERT INTO bon_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yeesu liba jepänige, abiberäja bägrä cina ngena jewenisi, tabe claabe ge, siige jejemige egä, “Bägrä cina saaclege cäme bau me. Gone jiibemuye, ingle bägrä pana ätrunga cama biname bine Acejiyame te yaawadimuge. ");
INSERT INTO bon_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cane toraca jijenininine: laati te bägrä pana lica yaacatuge Acejiyame ne teeme mopeyame me lenajame, pui biname ne Acejiyame te äblicäco acana.” ");
INSERT INTO bon_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Puma cita ca tabe bägrä bine jejecletnäjimige, teeme ime aacitanige teeme papa cabu me teeme miiji tääpume. ");
INSERT INTO bon_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeesu liba asatige gaabe cabu me, abyemärige, yepä biname te piba uuwamige teeme bau me, kokorare ca ääpednutige teeme opo gaabe je, itemlige egä, “Miijirage abiberäja biname, cane ngena ne miiji wawena iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeesu jejige egä, “Maane ngena name pi miijirage ca bii nainite cebine? Acejiyame taatu gyene miijirage, nuuja cina miijirage lica gemi. ");
INSERT INTO bon_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yoo siige, maane umle gäte Moose me ten cotre poto cidi me: ‘Gone biname ne budre me agli; sargi mule gone wawena; gone gwidape ero; walya aitneja gone; angletneja gone; mage babe bine miiji opo gaabe me acita.’” ");
INSERT INTO bon_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pui biname te Yeesu ne jejige egä, “Abiberäja biname, cane bägrä cabu ca iyeta peei cotre bine itu sicwetnanemumene.” ");
INSERT INTO bon_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeesu ire acitige teeme bau me ngenecu miiji cama, siige jejige egä, “Yepä gwidape pisi nyene, maane lui ne lica ituge wawena. Äte ädi, määme iyeta gwidape bine ewademepi aletname, rarekaake ecäranemepi owecumete biname bine, siige maane cabucewe je miijimiji gwidape bine cire jepänemepi. Piba tädepi cane cama otnime.” ");
INSERT INTO bon_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tabe liba ai mene itecijige, teeme opo te mara opo me äbitige, siige tabe ngenecu mäpu cama ädige, ingle tabe babo dogwe biname ge. ");
INSERT INTO bon_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Puma cita ca Yeesu ingwe gaabe me ire jetwige, teeme abiberäja bägrä bine jejemige egä, “Dogwe biname bime tääpume mäpu gyene Acejiyame me biname bine waadena cabu äbäcname.” ");
INSERT INTO bon_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abiberäja bägrä cina mutäcäco äbitininisi teeme mene name pi. Yepä Yeesu cerämu jejemige egä, “Cäme binamewale, mäpu gyene biname bime tääpume Acejiyame me biname bine waadena cabu äbäcname. ");
INSERT INTO bon_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela tääpume mäpu birige nilo bora cabu me abacitame siige asatame, yepä baborage mäpu birige dogweyame biname te Acejiyame me waadena cabu abacita.” ");
INSERT INTO bon_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abiberäja bägrä cina mutäcäco ge, teepi ätemläjinisi egä, “Baa laati te piba miiji gyene iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu ire acitige teeme bau me, jejemige egä, “Biname cina äblicäco teemämu peei ne wawena, yepä Acejiyame te miiji gyene iyeta gwidape bine waweneca.” ");
INSERT INTO bon_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Puma cita ca Peteru Yeesu ne jejige egä, “Cije cine lipu gemi, ingle cine iyeta gwidape bine itu saabmalemepesi maane cama otnetneja name pi.” ");
INSERT INTO bon_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeesu jejemige egä, “Cane toraca mene jijenininine; laati te liba saabmaluge teeme mete ne, saabma-limuge teeme naane igane bine, ngule bine, mage babe bine, bägrä bine coo gawe bine cäme name pi piiyepu Miiji Mene name pi, ");
INSERT INTO bon_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tabe yepä hanred gääbu tuwängle jääpänimuge mete bine, naane igane bine, ngule bine, mage bine, bägrä bine, cuta gawe bine, piiyepu peei cama biname cina teebine jäägyusi, yepä tabe ciige padare cabu cirege iyeteta ireclota ne päpäna. ");
INSERT INTO bon_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yepä bucurage biname lui cina page niinäce gaabe biname gemi, teepi ciige padare cabu ingwe gaabe me cire täcnäripesi; piiyepu bucurage biname lui cina page ingwe gaabe biname gemi, teepi ciige padare cabu niinäce gaabe me cire täbitipesi.” ");
INSERT INTO bon_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yeesu teeme abiberäja bägrä cama ädige Yerusalema me. Tabe teeme niinäce gaabe me ädige. Abiberäja bägrä cina mutäcäco ge piiyepu lui cina ingwe icwemisi, teepi wälu ge. Yeesu abiberäja bägrä bine biname bime sobe cabu ca mara me ewadimige, cääri jejemige, ngena te pa läpletnutepi teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tabe jejemige egä, “Siige mine biiri naclenige Yerusalema me. Cane lui Acejiyame bau ca tädujine biname me äbitujine, cebine puma pagege ceera modamoda iiwäreja biname piiyepu cotre abiberäja biname bime ime cabu me. Teepi budre me pa natranepesi, siige pa näcärepesi nuuja gawe cabu ca biname bime cabu me. ");
INSERT INTO bon_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Teepi cebine ätutena pana pa nawenepesi, mote ca pa nätyewepesi, pa nadnanepesi, budre me pa naglepesi. Yepä nesae me lui bimu cabu cane piba pa larpinantepene ireclota me.” ");
INSERT INTO bon_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Puma cita ca Yakobu naabi Yoane, Jebedayo me bägrä cina Yeesu bau me taaclige, jejäsi egä, “Abiberäja biname, cine singi gegi maane wawename, cine ngena tääpu megi singi.” ");
INSERT INTO bon_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeesu äätemlige egä, “Weene singi cane ngena ne wawename weeme tääpume?” ");
INSERT INTO bon_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Teepi jejäsi egä, “Maane liba biname bine cirege waadena, maane conocäco nicärepi cine babo äbitame siige nuuja te adnatame määme camu poto me, nuuja te määme säwäci poto me.” ");
INSERT INTO bon_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yepä Yeesu jaajige egä, “Weene umle lica gegi, weene ngena tääpume nätemleniye. Nää, weene miiji gegi cäme pana mäpu cabu lenajame piiyepu cäme pana budre äbitame?” ");
INSERT INTO bon_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Teepi jejäsi egä, “Cine miiji gegi.” Yeesu jaajige egä, “Toraca gyene, weene cäme pana mäpu cabu pagege lenaja piiyepu cäme pana budre cirege äbita. ");
INSERT INTO bon_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yepä peei lui cäme bau lica gyene jajime, lui te cirege cäme camu poto ca piiyepu säwäci poto ca adnata. Pui puupu lui teeme tääpu memi, Acejiyame lui bime tääpume ituge amacetnäja.” ");
INSERT INTO bon_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nuuja ten abiberäja bägrä cina liba itecijemige Yakobu Yoane naabime mene, teepi claabe me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Puma cita ca Yeesu iyeta abiberäja bägrä bine tesoglicmige, jejemige egä, “Weene umle gemi, egä lui cina mope biname me yaacrajuge Acejiyame umle cäco biname bime tääpume, teepi teebibine jaawenimusi teeme singi gaabe cabu otnetnejame. Piiyepu teeme modamoda biname bime conocäco pisi nyene biname bine jajime teepi ngena wawename. ");
INSERT INTO bon_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yepä weene apu gone läbitininuye. Weeme yepä te liba singi baborage me äbitame, tabe miiji nuuja biname bime ätityera biname me lenajame; ");
INSERT INTO bon_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","piiyepu weeme yepä te liba singi niinäce gaabe me äbita, tabe miiji weeme tääpume epu matikäli me äbita, aletnäneji biname te lipu läbituge teeme yageyame tääpume. ");
INSERT INTO bon_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cane lui te Acejiyame bau ca tädujine biname me äbitujine, cane cuta lica itu tädujine biname cina cäme tääpume kaakesea wawename, ceewe, yepä cane te teeme tääpume kaakesea wawename piiyepu cäme ireclota ne ceerame daremu tääpume teebibine kälyä wawename. ");
INSERT INTO bon_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yeesu piiyepu teeme abiberäja bägrä cina seclige Yeriko cewe me. Teepi liba puma cita ca abyemärinisi, bucurage biname cina teebibine ingwe icwemisi. Gaabe wajwa je yepä irecu määsumäsu biname ngii Bartima, Tiima me bägrä, te adnatäneji enajige, gwidape tääpume yäätineräjimuge. ");
INSERT INTO bon_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tabe liba itecijige, egä Yeesu Nasaretayame te näsuplingtenige, tabe piba gije abacitige ala abayame egä, “Yeesu Daawida me kaakesaare, maane cebine owecu naweni!” ");
INSERT INTO bon_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Biname cina liga teebine jiibisi tabe bojä agime, yepä tabe cerämu baborage ala abayige egä, “Daawida me kaakesaare, maane cebine owecu naweni!” ");
INSERT INTO bon_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Puma cita ca Yeesu gaabe cabu imyemutige, jejemige egä, “Tesogleceye teebine.” Siige teepi teebine tesoglicisi, jejisi egä, “Wälu gone! Abujängti, tabe meebine ala naasoglicige.” ");
INSERT INTO bon_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tabe teeme acwaba cäbletääpe ne ijarige, ädige Yeesu bau me. ");
INSERT INTO bon_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeesu itemlige egä, “Maane singi cane ngena wawename määme tääpume?” Tabe jejige egä, “Babo biname, cane singi cääri irecu asatame.” ");
INSERT INTO bon_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeesu jejige egä, “Äte ädi! Määme ätrunga te miiji bii naawenige meebine.” Piba taatu teeme irecu cina aasatäsi, siige tabe Yeesu ne ingwe icwige gaabe cabu. ");
INSERT INTO bon_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yeesu teeme abiberäja bägrä cama liba Yerusalema ne mameta me jewenisi oomlaname, teepi piba atyarige Olibi Uli Podo cabu me. Pui podo cabu puga ge cewe ngii Betepage piiyepu cewe ngii Betaniya. Yeesu teeme neeneni abiberäja bägrä bine jäätyepige ");
INSERT INTO bon_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","apu mene cama egä, “Weene iclege weeme niinäce gaabe ca lui cewe peese nyene, siige liba atyaramteniye, weene jepäneniye mamye dongki ne seea ca ägräräneji gyene. Nuuja biname te camu ge teeme papa cabu adnata. Jiibirepeye teebine, secanepeye aima. ");
INSERT INTO bon_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Laati te liba itemlenige weebibine egä, ‘Ngena tääpume peei ne jeweneniye,’ jejepeye egä, ‘Yageyame te singi gyene teeme tääpume, yepä tabe watata pa saawecnistepi.’” ");
INSERT INTO bon_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Puma cita ca teepi aaclige, jepänäsi mamye dongki ne babo gaabe cabu seea ca ägräräneji ge yepä mete grana gome, siige jiibiräsi. ");
INSERT INTO bon_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Poto biname lui cina puga icrajige, teebibine äätemlisi egä, “Weene ngena name pi peei dongki ne jiibireniye?” ");
INSERT INTO bon_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Teepi jejemäsi, Yeesu lipu bii jaajige teepi jajime, siige pui biname cina ire taatu jaatwisi teepi dongki ne acaname. ");
INSERT INTO bon_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Abiberäja bägrä cina dongki ne ecanäsi Yeesu bau me, teeme cäbletääpe bine eretnemäsi teeme papa cabu, siige Yeesu acenutige, ädige. ");
INSERT INTO bon_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bucurage biname cina cäbletääpe bine eretnimisi gaabe cabu. Poto cina uli ciipe bine icnapimisi, gaabe cabu eretnimisi. ");
INSERT INTO bon_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lui biname cina teeme niinäce gaabe eclige piiyepu lui cina ingwe ca sicwisi, teepi ala abayaninisi egä, “Acejiyame ne yaawepyeräjesi! Maane lui tädenite Yageyame me ngii cabu, tabe miiji naawenege meebine! ");
INSERT INTO bon_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lui te tädenite mime kaakesaare Daawida pana biname bine waadename, Acejiyame te miiji naawenege meebine! Mine yaawepyeräjesi Acejiyame ne, cabucewe je lui te enajenige.” ");
INSERT INTO bon_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Puma cita ca Yeesu atyaramtige babo cewe Yerusalema me, siige abacitige iiwäreja mete cabu me. Tabe ire ecananemige gwidape bine, yepä mämle bimu name pi tabe acnenutige teeme twelb abiberäja bägrä cama Betaniya me. ");
INSERT INTO bon_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nuuja bimu cabu Yeesu liba abiberäja bägrä cama Betaniya ne sebmalige, tabe loolomecewe te joomlige. ");
INSERT INTO bon_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tabe cudecewe ca piigi uli ne jepänige laame cama, ädige uli gome me kuu ireme. Yepä tabe liba atyaramtige, laame taatu jepänimige, ingle kuu padare cäro camu ge. ");
INSERT INTO bon_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tabe uli ne jejige egä, “Nuuja biname te määme cabu ca lica pagege kuu loolo.” Teeme abiberäja bägrä cina itecijemige, tabe ngena jiicige. ");
INSERT INTO bon_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Teepi atyarige Yerusalema me, siige Yeesu ädige iiwäreja mete caale bora me. Puma tabe gije abacitige biname bine äyecrejame, lui cina piiyeme gwidape bine yaawadanemusi aletna-me piiyepu lui cina jaaletnimusi. Tabe rarekaake äbäsuwäja biname bime dade bine eboclomäjimige. Lui biname cina gimäe ele bine yaawadanemusi aletname, tabe cuta teeme adnatera dade bine eboclomäjimige. ");
INSERT INTO bon_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Piiyepu lui cina gwidape bine yaawadanemusi, tabe padare lica ecärimige teepi Acejiyame me mete caale cabu argemelame. ");
INSERT INTO bon_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tabe piba biname bine ebiberäjimige, jiicige egä, “Acejiyame te jiicenige Oogäräneji mene cabu egä, ‘Cäme mete ne irecu ätumuta mete ca cirege aina, luma iyeta maramara gawe biname cina cirege irecu ätumuta,’ yepä weene itu setatrongärumeye epu puupu me, eromaame cina luma lämletneräjininusi.” ");
INSERT INTO bon_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Modamoda iiwäreja biname piiyepu cotre abiberäja biname cina teeme mene liba jitecijisi, teepi siige gaabe ne jirngisi Yeesu ne budre me acitame. Teepi wälu ge teeme tääpume, ingle iyeta biname cina mutäcäco ge teeme abiberäja name pi. ");
INSERT INTO bon_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Liba tumlige mämleteca me, Yeesu abiberäja bägrä cama Yerusalema ne sebma-lisi. ");
INSERT INTO bon_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nuuja bimu krokerage Yeesu liba abiberäja bägrä cama gaabe cabu ädige, egäcäro pui piigi uli ne jepänisi, tabe lui cabu ca nuuja kuu ne lica tepänumi. Teeme laame jedacromtige piiyepu braju cina iyeta acalomlinisi, siige budre ge. ");
INSERT INTO bon_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peteru ngene jotwige, ngena te täpletnutumi, siige tabe Yeesu ne jejige egä, “Ire abiberäja biname, maane lui uli ne mene ca seglumete, siige budre gyene.” ");
INSERT INTO bon_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeesu teebibine jejemige, “Weene miiji Acejiyame bau ca ätrunga ne joomleye. ");
INSERT INTO bon_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cane toraca mene jijenininine, laati te liba jaajuge ai podo ne egä, ‘Awetänti, malu cabu me ajari,’ piiyepu tabe liba lica neeneni ngene atwana cama, yepä jäätrunguge, egä tabe ngena tääpume jaajuge, pa läbitepi, siige peei te pagege äbita teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Peei name pi cane jijenininine, egä weene irecu ätumuta cabu liba ngena tääpume yäätinäruye, siige jäätrunguye, egä weene uja ituge päpäna, siige weene piba jääpänuye. ");
INSERT INTO bon_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Weene liba labujengäjininuye irecu ätumutame, weene miiji ngene ätrimela weeme tääpume lui niiya mule jiwenininusi, piba weeme Babe cabucewe je weeme niiya mule ngene jäätrimaluge. ");
INSERT INTO bon_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yepä weene liba lica birige ngene ätrimela poto biname bime niiya mule bine, piba weeme Babe cabucewe je cuta lica birige ngene ätrimela weeme niiya mule bine.” ");
INSERT INTO bon_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeesu teeme abiberäja bägrä cama cääri acnenutige babo cewe Yerusalema me. Egäcäro Yeesu otnetnäjige iiwäreja mete caale bora modamoda iiwäreja biname, cotre abiberäja biname piiyepu nuuja modamoda biname cina seclige teeme bau me, ");
INSERT INTO bon_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","itemlisi egä, “Määme ngena conocäco pisi nyene ai mule bine wawenecame? Laati bau ca gyene määme conocäco?” ");
INSERT INTO bon_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu jejemige egä, “Cane yepä gwidape poto cidi me itemlininine. Weene liba nawecnisteniye, cane piba jijenininine, laati te conocäco näcärepi cane ai mule bine wawenecame. ");
INSERT INTO bon_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Weene najeye, laati te Yoane ne conocäco yääcärepi tabe biname bine niiye ca äcisejame, Acejiyame te coo biname cina?” ");
INSERT INTO bon_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Teepi teemeteme jitranisi egä, “Mine liba jewecnistenisi egä, ‘Acejiyame te Yoane ne conocäco yääcärepi,’ tabe piba apu nijenininige egä, ‘Cije weene piba ngena name pi teebine lica jäätrungepeye?’ ");
INSERT INTO bon_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cuta mine äblicäco gemi iicana egä, ‘Biname cina Yoane ne conocäco yääcärepesi.’” Teepi apu naace popi jiicisi, ingle teepi biname bime tääpume wälu ge, ingle iyeta biname cina ngene jotwananeninisi, egä Yoane lui Acejiyame me mename biname ge. ");
INSERT INTO bon_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Siige teepi Yeesu ne jejisi egä, “Cine umle lica gemi, laati te Yoane ne conocäco yääcärepi biname bine niiye ca äcisejame.” Yeesu jejemige egä, “Cane cuta piba lica jijenininine, laati te cebine conocäco näcärepi ai mule bine wawenecame.” 11 ");
INSERT INTO bon_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeesu biname bine ngene ca agli mene ca jejemige, teepi ngena ituge wawena Acejiyame me mename biname bime tääpume. Tabe apu jiicige egä, “Yepä biname te waina gije bine itemige. Tabe cotäri ne erangige, cupicu ne juurige waina kuu ämulecame, piiyepu cabucabu mete ne erangige calwacupi ne awamutame. Piba tabe calwacupi ecärimige biname bine ire atwime siige kuu padare cabu teepi yageyame ne poto kuu ceerame daremu tääpume. Puma cita ca tabe cewe ne sebmalige, ädige cudecewe cewe me. ");
INSERT INTO bon_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kuu padare cabu tabe teeme kaakesea bägrä ne jityepige calwacupi ire atwi biname bime bau me poto kuu bine waadename. ");
INSERT INTO bon_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Teepi teebine joomlisi, etemeläjisi, jityepisi ime ta. ");
INSERT INTO bon_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yageyame te cuta nuuja kaakesea bägrä ne jityepige. Teepi dupe ecärisi mope cabu, ajiri me jewenisi. ");
INSERT INTO bon_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ingwe ca tabe cuta cääri jityepige nuuja ne, yepä teepi budre me eglisi. Teepi bucurage bine pepu jewenanemisi, poto bine etemeläjimisi, poto bine eglecimisi budre me. ");
INSERT INTO bon_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Siige Yageyame me bägrä taatu te abmalige, teeme ngenecurage bägrä. Ceräcerägääbu tabe teebine jityepige teeme bau me, ingle tabe apu jengige, egä teepi pama cäme bägrä ne opo gaabe me ecitenisi. ");
INSERT INTO bon_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yepä calwacupi ire atwi biname cina liba yageyame me bägrä ne jepänisi, teepi teemeteme jitranisi egä, ‘Ai yageyame me bägrä gyene. Tabe te ai calwacupi ne cire yaacatepi. Biiri naclege, yaaglesi, siige calwacupi mime yene.’ ");
INSERT INTO bon_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Teepi teebine ecatisi, eglisi, budrekaake ne ijarisi cotäri sici me. ");
INSERT INTO bon_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Cane jijenininine weebibine, calwacupi yageyame te ngena cirege wawena. Tabe cirege otni budre me aglecame pui calwacupi ire atwi biname bine piiyepu calwacupi cire yääcäremepi nuuja biname bine ire atwime. ");
INSERT INTO bon_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Weene ituge acnema Oogäräneji mene egä, ‘Lui kula ne raranga biname cina jigyisi, baborage bäbitige iyeta nuuja cabu ca. ");
INSERT INTO bon_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yageyame te ai ne bii jewenige piiyepu babo miijirage gyene mine päpäname.’” ");
INSERT INTO bon_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Siige Israela modamoda biname cina Yeesu ne oomlaname äbitininisi, ingle teepi opo ewatnisi, egä tabe teeme poto cidi me bii jiicige. Yepä teepi wälu ge bucurage biname name pi, siige teepi teebine ebmalisi, eclige. ");
INSERT INTO bon_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Modamoda biname cina jityepimisi poto Parisea sigu biname piiyepu Heroda me sigu biname bine Yeesu bau me teebine mene cabu ca oomlaname. ");
INSERT INTO bon_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Teepi seclige, jejisi egä, “Abiberäja biname, cine umle gemi, egä maane toraca mene jiicenenemite piiyepu maane nuuja ngenecu lica gäte, biname cina lipu ngene jwaatwananinusi määme poto cidi me, ingle maane nuuja ne lica yaacatute teeme ngii name pi, yepä maane toracarage yaabiberäjimute Acejiyame me gaabe poto cidi me. Siige maane toraca nijini, nää mime cotre te lica niibenininige mine täks rarekaake ceerame Rooma mope biname Siisa ne?” ");
INSERT INTO bon_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yepä Yeesu opo ewatnige, egä teepi singi teebine mene cabu ca oomlaname, siige tabe jejemige egä, “Weene ingle ne jirngeniye cebine oomlaname. Rarekaake ne secaneye, cane jääpänene.” ");
INSERT INTO bon_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Teepi secanisi, siige tabe itemlimige egä, “Laati me opo gyene piiyepu ngii gyene ai rarekaake cabu?” Teepi jejisi egä, “Siisa me opo gyene piiyepu teeme ngii gyene.” ");
INSERT INTO bon_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeesu jejemige egä, “Lui gwidape gemi Siisa me, teebine ecäreye pui; piiyepu lui gwidape gemi Acejiyame me, teebine ecäreye pui.” Teepi mutäcäco äbitininisi teeme mene name pi. ");
INSERT INTO bon_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Poto Sadukea sigu biname cina seclige Yeesu bau me. Teepi eei gemi, lui cina jiicusi, egä biname cina budre cabu ca lica arpinera. Teepi Yeesu ne jejisi egä, ");
INSERT INTO bon_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Abiberäja biname, Moose te cotre ne soogäruji mime tääpume, egä biname te liba budre läbituge, coga ne bägrä cäco twaabmaluge, teeme igane te miiji cuubla ne acata bägrä wawename teeme naane me ngii tääpume. ");
INSERT INTO bon_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yoo, nuuja taje puga ge seben naniganewaleyame. Uuge te coga ne ocatige, siige bägrä cäco budre äbitige. ");
INSERT INTO bon_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Teeme gomecayame igane te cuubla ne ocatige. Tabe cuta budre äbitige bägrä cäco. Cuta pepu äbitige puma cita ca gomeyame tääpume ");
INSERT INTO bon_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","piiyepu iyeta teeme iganewale bime tääpume. Iyeta seben naniganewaleyame peei yepä magebi ne ocananisi, siige budre äbitininisi bägrä cäco. Ingwe ca magebi te cuta budre äbitige. ");
INSERT INTO bon_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Siige liba pui seben naniganewaleyame budre cabu ca cirege arpinera, tabe piba laati me coga cirege?” ");
INSERT INTO bon_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu teebibine jejemige egä, “Weene betäjiye, ingle weene umle lica gemi Oogäräneji mene piiyepu weene umle lica gemi Acejiyame me kokre. ");
INSERT INTO bon_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Budre biname cina liba cirege arpinera, teepi coga rooriye lica awadreca, yepä teepi epu pana cire yaacrajemepi Acejiyame me mename seemo cina cabucewe je liiyepu. ");
INSERT INTO bon_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Egäsu weene Moose miji Oogäräneji mene cabu ituge acnema, Acejiyame Moose ne ngena jejuji budre cabu ca arpinera poto cidi me. Moose liba aclajuteji enajuji ayeji uli gome, Acejiyame te jejuji egä, ‘Cane Abrahamo, Isacako, Yakobu naabibime Acejiyame gäne.’ ");
INSERT INTO bon_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tabe nata budre biname bime Acejiyame lica gyene yepä eei bime, lui cina ireclota gemi. Weene mage betäjiye, egä budre biname cina lica cirege ireclota me arpinera.” ");
INSERT INTO bon_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yepä cotre abiberäja biname te liba itecijige Yeesu piiyepu Sadukea sigu biname cina lipu jicelisi, piiyepu tabe liba jepänige, egä Yeesu teebibine lipu miiji mene ca jewecnimige, tabe piba ädige Yeesu bau me, itemlige egä, “Lui cotre gyene baborage?” ");
INSERT INTO bon_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeesu jejige egä, “Age sena lui baborage cotre: ‘Israela biname weene itecijinege! Yageyame, lui sine mime Acejiyame, tabe yepä taatu Yageyame gyene. ");
INSERT INTO bon_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Weene miiji singi äbita Yageyame, weeme Acejiyame tääpume, siige pui ne aboclomta iyeta weeme owecu mule ca, iyeta weeme ireclota ca, iyeta weeme ngene atwanena ca piiyepu iyeta weeme kokre ca.’ ");
INSERT INTO bon_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pui gomecayame babo cotre lui age sena: ‘Maane miiji biname bime tääpume singi lenaja, maane lipu määme tääpume singi birige.’ Nuuja apu baborage cotre lica gyene ai neeneni cina liiyepu.” ");
INSERT INTO bon_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Piba pui cotre abiberäja biname te Yeesu ne jejige egä, “Abiberäja biname, maane miiji jiicite. Maane toraca jiicite, egä Acejiyame lui yepä taatu gyene, nuuja Acejiyame lica gyene. ");
INSERT INTO bon_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cuta biname te miiji singi Acejiyame tääpume, siige pui ne yaaboclomtuge teeme iyeta owecu mule ca, teeme iyeta ngene atwanena ca piiyepu teeme iyeta kokre ca, cuta tabe miiji singi biname bime tääpume, tabe lipu singi teeme tääpume. Ai lui baborage gyene iyeta iiwäreja cibu cabu ca, lui bine juubudäremusi Acejiyame tääpume, piiyepu nuuja iiwäreja gwidape cabu ca.” ");
INSERT INTO bon_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yeesu lui opo ewatnige, egä tabe umle mene ca jewecnistige, siige tabe jejige egä, “Maane mameta gäte biname me äbita, Acejiyame lui ne yaacanuge.” Ai ingwe gaabe ca biname cina wälu ge Yeesu ne cerämu ätemlejame. ");
INSERT INTO bon_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeesu liba iiwäreja mete caale bora je ebiberäjimige, tabe jiicige egä, “Peei lipu gyene, egä cotre abiberäja biname cina jiicenisi, egä Keriso lui Daawida me kaakesaare gyene. ");
INSERT INTO bon_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aceji Seemo te Daawida ne ngene atwana ecäruji Keriso poto cidi me iicaname egä, ‘Yageyame te cäme Yageyame ne jejuji: Maane adnati cäme camu poto cidi ca, ngälu cane määme cubuyame bine määme ernge gawe me cire yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Siige tabe Daawida te liba Keriso ne einuji teeme Yageyame ca, cije tabe piba lipu gyene Daawida me kaakesaare?” Biname cina jitecijisi gege cama Yeesu me mene. ");
INSERT INTO bon_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yeesu teeme abiberäja mene cabu apu jiicige egä, “Weene ire cängena cotre abiberäja biname bime tääpume, lui cina singi gemi lecaleca cäbletääpe cama otnetnejame naace me awabame, egä teepi umlerage biname gemi, piiyepu lui cina singi gemi biname cina teebibine aletna puupu cabu cängena awablame. ");
INSERT INTO bon_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Abasecretna mete cabu teepi singi ngii biname bime puupu cabu adnaterame, piiyepu soriyomu ne liba yaaclitusi, teepi ladna-täruge miijirage puupu cabu. ");
INSERT INTO bon_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Teepi cuublacubla bime gwidape bine yaawadimusi piiyepu sinäme lecaleca padare irecu lätumutanininusi. Peei name pi teepi Acejiyame bau ca mäpurage daremu ne cirege päpäna.” ");
INSERT INTO bon_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeesu liba adnatäneji enajige iiwäreja mete caale bora rarekaake acrana gwidape gome, tabe ire ca ewadanemige biname cina lipu rarekaake ebäcnisi. Bucurage dogwe biname cina ebäcnisi mage rarekaake bine. ");
INSERT INTO bon_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Puma cita ca yepä owecumete cuubla te toclige, neeneni matimati rarekaake aacitige. ");
INSERT INTO bon_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeesu abiberäja bägrä bine ala tesoglicmige, jejemige egä, “Cane toraca mene jijenininine, ai owecumete cuubla te magerage becitige, poto cina matimati bicranimisi. ");
INSERT INTO bon_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Naace, teepi matimati rarekaake bine bicranimisi teeme bucurage cabu ca, yepä cuubla te iyeta becitige, teeme lui pisi nyene lenaja tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeesu liba iiwäreja mete ne sebmalige, teeme yepä abiberäja bägrä te jejige egä, “Abiberäja biname, maane ire lipu modamoda kula gemi piiyepu lipu modamoda mete gemi!” ");
INSERT INTO bon_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeesu jejige egä, “Maane jepänenemite ai modamoda mete bine. Ai iyeta iigareca cirege, siige lica yepä kula ne abmala nuuja kula me tumeca.” ");
INSERT INTO bon_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pui ingwe gaabe ca Yeesu liba adnatäneji enajige Olibi Uli Podo cabu, iiwäreja mete cabu opire enajige, piba Peteru Yakobu Yoane Andrea naabi tujige teeme bau me, siige ogä itemlänisi egä, ");
INSERT INTO bon_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nijini ai mule cina liba cire läbitipesi. Ngena cewecu cina cirege awaba, egä padare te bii tatyaramtige ai mule cina äpletnecame?” ");
INSERT INTO bon_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeesu jääjänige egä, “Weene miiji cängena ire, cije nuuja te weebibine ingletnäjinuge. ");
INSERT INTO bon_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bucurage biname cina cire saaclepi cäme ngii cabu, cire jiicemepesi egä, ‘Cane Keriso säne’, siige teepi bucurage biname bine cire yaangletnäjemepesi. ");
INSERT INTO bon_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Cuta weene liba cire itecijanipi cubu ala mameta piiyepu liba idre cire itecijanipi cubu poto cidi me cudecewe je, weene cälu te gone jitinuge, ingle ai te miiji cire läbitepi. Yepä ai padare me ngälugaabe cäro camu gyene. ");
INSERT INTO bon_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yepä gawe biname cina cirege cubu iicana nuuja gawe biname cama, cuta yepä gawe mope biname te nuuja gawe mope biname cama. Cuta ocneja cina cirege maramara cewe cabu ta, piiyepu gane cirege. Ai iyeta lui mäpu padare me agedna taatu gyene, epu pana mäpumäpu magebi te lipu cupace laplongamtuge bägrä ärngime. ");
INSERT INTO bon_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pui padare cabu weene ire cängena biname bime tääpume. Teepi weebibine cirege oomlana ablaweja puupu cabu waadename piiyepu weebibine abasecretna mete cabu ta cirege atemeläja. Weene cirege aclajuta gawe mope biname bime opo gaabe je cämiji pi naace tääpume teebibine Miiji Mene jajanename. ");
INSERT INTO bon_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Miiji Mene miiji niinäce acenena iyeta cewe gaabegabe ta, ingwe ca piba ai padare me ngälugaabe te cire tädepi. ");
INSERT INTO bon_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Weebibine liba cire iwadipesi ablaweja puupu me, weene niinäce gaabe me ngenecu gone, egä weene ngena cire jiicemepeye, yepä weene eei mene jiicuye Acejiyame te ngena mene icärininuge peei padare cabu. Peei lui weeme mene lica cirege, yepä Aceji Seemo te ngene atwana cire icäranipi. ");
INSERT INTO bon_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cuta piiyepu biname cina cirege teeme naane igane bine budre me ceera piiyepu babe cina teeme bägrä bine. Bägrä cina teeme mage babe bine cirege äingeja piiyepu budre me ceera. ");
INSERT INTO bon_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iyeta biname cina weebibine cire jimugitnipesi cämiji pi. Yepä laati te ngenecu kokre cire yaanajepi ngälu ngälugaabe, tabe iyeteta ireclota ne cire jääpänepi.” ");
INSERT INTO bon_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yeesu abiberäja bägrä bine cerämu jejemige egä, “Weene liba niiyarage wälumeteyame ne cire jepänepeye aclajuteji puupu cabu, lui teeme tääpume cude gyene,” (acnema biname tabe miiji umle ai ngena tääpu myene) “piba Yuudea gawe cabu lui biname cina miiji uucratna podo cabu me. ");
INSERT INTO bon_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lui cina mete toro cabu lui puupu cabu diibe loocinusi, mete me gone äbäcna gwidape waadename, ");
INSERT INTO bon_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","piiyepu lui cina calwacupi cabu, teepi gone äcnära cewe me cäbletääpe waadename, yepä teepi iyeta miiji watata uucratna. ");
INSERT INTO bon_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ogi nemi eei magebi, lui cina mäpumäpu cirege pui padare cabu piiyepu lui cina ngame meeramera bägrä cama. ");
INSERT INTO bon_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Irecu ätumutipeye, egä pui mule te gone läpletnutuge gäbu padare cabu, ");
INSERT INTO bon_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ingle pui padare cabu lui mäpu baborage gyene iyeta poto mäpu cabu ca, lui cina ituge äpletnuta ai gawecewe me agedna cabu ca ngälu ai taje, cuta ingwe ca lica cirege äpletnuta. ");
INSERT INTO bon_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yepä Acejiyame te teeme ngene atwanena cabu pui mäpu padare ne uja tuube me itu jewenuji. Tabe liga pepu lica cire jaaweneji, nuuja te ireclota lica cire yaanajepi, pui mule cina liba cire läpletneräjipesi. Yepä teeme äjäcräneji biname bime name pi tabe ngene itu jotwananuji pui padare ne tuube me wawename. ");
INSERT INTO bon_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pui padare cabu liba nuuja te cire jijipi egä, ‘Ire, age sena Keriso,’ coo egä, ‘Tabe isino,’ gone jäätrunguye. ");
INSERT INTO bon_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Walya Keriso piiyepu walya mename biname cina cire saaclepi. Teepi ciitaca mule bine piiyepu cälu te äti mule bine cire jaawenanemepesi Acejiyame me äjäcräneji biname bine angletnejame, teepi liba ibibi cirege peei ne wawename. ");
INSERT INTO bon_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Weene ireire inajipi, ingle cane niinäce gaabe me weebibine ituge umle mene jajanena.” ");
INSERT INTO bon_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yeesu cuta jejemige egä, “Pui mäpu padare me ingwe gaabe ca bimu te krokeciiye me cire läbitepi, piiyepu mabye te lica cire saapaclyärepi. ");
INSERT INTO bon_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wale cina cabu ca cire saatrametnemepi, piiyepu lijalija nuuja gwidape gemi puma, teepi teeme otnetneja gaabe cabu ca cirege äyeblengäja. ");
INSERT INTO bon_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Piba biname cina cire näpänepesi cebine, Acejiyame bau ca lui te tädujine biname me äbitujine, carbe cabu cirege äina baborage kokre piiyepu jamyacu apaclyera cama. ");
INSERT INTO bon_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Puma cita ca cane mename seemo bine cire jäätyepemepene Acejiyame me äjäcräneji biname bine abasecretname iyeta poto ca ai gawecewe cabu.” ");
INSERT INTO bon_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Weene labiberäjininuye piigi uli cabu ca. Teeme ciipe liba migi ca tapanininusi, ngänglä laame tucu taawenimuge, siige weene umle gemi, egä kämäge mameta gyene. ");
INSERT INTO bon_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cuta weene liba cirege päpäna, cane lui mule poto cidi me bii jijininine, weene piba umle cire äbitipeye, egä cäme acnenuta padare mameta gyene. Cane grana gome säne. ");
INSERT INTO bon_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cane toraca mene jijenininine, biname lui cina ireclota page ai taje, teepi iyeta budre lica cirege äbita, ngälu iyeta ai mule cina liba cire läbitipesi. ");
INSERT INTO bon_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dume piiyepu gawe cirege apira, yepä cäme mene te lica cirege apira.” ");
INSERT INTO bon_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yepä nuuja biname te umle lica gyene bimu coo padare, cane lui te Acejiyame bau ca tädujine biname me äbitujine, cäme acnenuta tääpume. Cabucewe je lui Acejiyame me mename seemo teepi umle lica gemi, cuta cane Acejiyame me Bägrä cane cuta umle lica gäne, yepä Babe taatu umle gyene. ");
INSERT INTO bon_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Peei name pi weene miiji cängena ire, ireclota inajipi, ingle weene umle lica gemi ai mule cina liba cire läbitipesi. ");
INSERT INTO bon_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ai lui epu pana gyene, lui biname te cewe ne saabmaluge, läduge cudecewe cewe me. Tabe teeme mete piiyepu iyeta gwidape bine saabmalimuge teeme kaakesea bägrä bime ime cabu. Tabe teeme yepäyepä bine maramara kaakesea yääcäranemuge. Grana ire atwi biname ne tabe jaajuge ireire lenajame. ");
INSERT INTO bon_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yepä pana weene cuta miiji ireire inajipi, ingle weene umle lica gemi mete yageyame te liba tacnenige. Ai lui pama mämleteca me, coo ciiye duusa me, coo sewali mameta me, coo bimu acitame. ");
INSERT INTO bon_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Weene ireire inajipi! Tabe liba bojäcu tädenige, niiya gyene tabe weebibine ute cabu ädära. ");
INSERT INTO bon_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cane aga ngena bii jijenininine weebibine, ai lui iyeta biname bime tääpu myene. Weene ireire inajipi!” ");
INSERT INTO bon_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Neeneni bimu ingwe gaabe ca biname cina äsuplengta trii ne jewenisi piiyepu uutneca cäco buluduu bine erwäjanemisi seben bimu ngalebora ngene apecname, teeme saarewale bine liba sisemujisi Aikupito ca. Pui padare cabu modamoda iiwäreja biname piiyepu cotre abiberäja biname cina gläämu jecijemige Yeesu ne lipulipu ogä oomlaname siige budre me aglime. ");
INSERT INTO bon_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Teepi jiicisi egä, “Mine äblicäco teebine oomlana trii biname bime irewale, cije teepi cubu jaagednusi mine cama.” ");
INSERT INTO bon_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pui padare cabu Yeesu Simona me mete cabu jage Betaniya je. Simona lui lepera pita cama ge niinäce. Yeesu deedei liba äbitige, yepä magebi te tabacitige alabasta kula karpu cama. Karpu ngalebora puga ge miijirage lengo nardus oil, lui ne baborage daremu ca jaaletnusi. Tabe karpu ne etebicige, oil ne epadurige Yeesu me mope cabu. ");
INSERT INTO bon_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Poto biname cina claabe me äbitininisi, ajanininisi egä, “Niiyarage gyene ai oil ne pepu papa apadura. ");
INSERT INTO bon_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Miiji cire yaacanejisi aletname trii hanred rarekaake ca, siige pui rarekaake owecumete biname bine cire yääcäremejisi.” Siige teepi teebine ujäclisi. ");
INSERT INTO bon_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yepä Yeesu jejemige egä, “Obmaleye teebine. Weene ngeno me ngenecu mäpu me joweneniye? Tabe miijirage mule ne bii jewenige cäme tääpume. ");
INSERT INTO bon_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iyeta padare cabu owecumete biname cina weene cama yaacrajimuge, siige weene miiji gemi teebibine ätityerame weene lui padare cabu singi, yepä cane weene cama lica pagege iyeta padare cabu lenaja. ");
INSERT INTO bon_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Peei name pi miiji gyene, egä tabe jewenige, tabe lui mule ne ibibi ge wawena. Tabe cäme tääpe ne niinäce gaabe me bii beganige gape me acitame. ");
INSERT INTO bon_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cane toraca mene jijenininine, biname cina luma Miiji Mene ne yaacenanusi ai gawecewe cabu ta, teepi cirege jajanena ai magebi me ngene apecna tääpume, tabe ngena ne bii jewenige cäme tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yeesu me twelb abiberäja bägrä bime yepä te ngii Yuuda Isakariyota ädige modamoda iiwäreja biname bime bau me, jejemige tabe Yeesu ne awabame agli tääpume. ");
INSERT INTO bon_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Teepi liba itecijemige, teepi gege ecisi, siige jejisi Yuuda ne teebine daremu ceerame. Puma cita ca tabe miiji gaabe ne jirngige Yeesu ne awabame teeme budre tääpume. ");
INSERT INTO bon_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Trii padare puga ge Israela biname cina liba uutneca cäco buluduu bine yäärwäjimusi. Pui padare me niinäce bimu cabu, teepi liba maamoi bine yaaglecimusi äsuplengta deedei tääpume, Yeesu me abiberäja bägrä cina teebine itemlisi egä, “Maane singi luma mäte cine äsuplengta deedei ne amacetnäjame määme tääpume?” ");
INSERT INTO bon_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tabe teeme neeneni abiberäja bägrä bine apu mene cama jäätyepige egä, “Weene iclege babo cewe me. Weene puma opopa eyeniye rooriye cama, lui te niiye karpu ne secanenige, ");
INSERT INTO bon_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","siige teebine ingwe icwepeye tabe lui mete cabu abacitenige. Jejepeye mete yageyame ne egä, ‘Abiberäja biname te singi umle äbitame, egä lese nyene puupu, tabe luma teeme abiberäja bägrä cama äsuplengta deedei äbitenige?’ ");
INSERT INTO bon_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tabe weebibine jiwabenige baborage cabu puupu ne. Pui puupu cabu piti nemi iyeta gwidape, siige puma emacetnäjepeye deedei mime tääpume.” ");
INSERT INTO bon_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abiberäja bägrä cina abyemeräsi, aaclige babo cewe me, jepänemäsi iyeta gwidape Yeesu me mene ibi. Teepi äsuplengta deedei puma emacetnäjäsi. ");
INSERT INTO bon_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Liba mämleteca ge, Yeesu atyaramtige teeme twelb abiberäja bägrä cama pui mete cabu me. ");
INSERT INTO bon_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Teepi liba deedei äbitininisi, Yeesu jejemige egä, “Cane toraca mene jijenininine, weeme yepä lui te deedei äbitenige cane cama, cebine budre me pa nawabepi.” ");
INSERT INTO bon_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Teepi ngenecu mäpu me äbitininisi, siige yepäyepä jejananisi egä, “Yageyame, cane lica.” ");
INSERT INTO bon_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeesu jejemige egä, “Ai lui weene twelb bime yepä gyene, lui te buluduu ne yiiglenutenige cane cama disi cabu. ");
INSERT INTO bon_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cane lui te Acejiyame bau ca tädujine biname me äbitujine, budre pa läbitepene, Oogäräneji mene te lipu jiicenige cäme poto cidi me. Yepä oge yene pui biname, cebine lui te nawabenige budre tääpume. Teeme tääpume miiji cirege tabe liba lica cire laplimleji.” ");
INSERT INTO bon_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Teepi liba deedei erwäjisi, Yeesu piba buluduu ne ecatige, Acejiyame ne eso ecärige, itrecige, abiberäja bägrä bine ecärimige, jejemige egä, “Ecateye. Ai lui cäme tääpe gyene.” ");
INSERT INTO bon_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tabe cuta kwäye ne waina niiye cama ecatige, Acejiyame ne eso ecärige, ecärimige teebibine, siige teepi iyeta pui kwäye cabu ca enisi. ");
INSERT INTO bon_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yeesu jejemige egä, “Ai lui cäme uudi gyene, lui te mameta gyene apira bucurage biname bime tääpume piiyepu lui te klaje jecnenige Acejiyame lui kirece mene ituge jaji biname bine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cane toraca mene jijenininine, cane cääri waina niiye lica cirege nani ngälu pui padare cabu, cane liba kirece waina niiye cire yaanepene Acejiyame me puupu cabu cabucewe je.” ");
INSERT INTO bon_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Puma cita ca teepi uupera ne etangisi, siige äsige, eclige Olibi Uli Podo cabu me. ");
INSERT INTO bon_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeesu abiberäja bägrä bine jejemige egä, “Weene page iyeta cebine nabmaleniye, uucratnininiye, ingle mene oogäräneji gyene cäme poto cidi me egä, ‘Acejiyame te maamoi ire atwi biname ne budre me cire yaaglepi, siige maamoi cina maramara cire yaaplidnärepesi.’ ");
INSERT INTO bon_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yepä cane liba budre cabu ca pa larpinantepene, cane piba weeme niinäce gaabe me Galilaya me pa lädepene.” ");
INSERT INTO bon_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peteru Yeesu ne jejige egä, “Ngänu gyene liba iyeta poto cina meebine abmala, cane licarage naabmalenine meebine.” ");
INSERT INTO bon_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeesu jejige egä, “Cane toraca naajenine, airage ciiye cabu maane cebine niinäce nesae gääbu nainenite, piba paulo te neeneni manu ala sengenenige.” ");
INSERT INTO bon_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peteru kokre cama jejige egä, “Ngänu gyene teepi cebine maane cama budre me agli, yepä cane licarage naainenine meebine.” Iyeta abiberäja bägrä cina cuta yepä mene jejanisi. ");
INSERT INTO bon_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Teepi eclige cewe ngii Getesemane me. Yeesu abiberäja bägrä bine jejemige egä, “Weene ama adnatärineye, cane lädene irecu ätumutame. ");
INSERT INTO bon_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tabe Peteru Yakobu Yoane naabibine aacanänige teta cama. Yeesu babo ngenecu mäpu me äbitige piiyepu wälu te joomlige, ");
INSERT INTO bon_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","siige tabe jääjänige egä, “Ai baborage ngenecu mäpu te cebine budre pana nawenenige. Weene ama ireclota sinäjänege, cebine nawagrijeye.” ");
INSERT INTO bon_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Puma cita ca tabe matikäli padare abotäntige, oweowe ajarige gawe cabu me, irecu ätumutige, egä liba miiji gyene ai mäpu padare te teebine äsuplengtame. ");
INSERT INTO bon_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tabe apu jiicige egä, “Cäme Babe, maane miiji gäte iyeta gwidape bine wawenecame. Maane ai mäpu ne cäme bau ca iyeblingti. Yepä gone cäme singi ne jaawenute, määme singi ne jewenepi.” ");
INSERT INTO bon_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Puma cita ca tabe tacnenutige, abiberäja bägrä bine ute cabu täädäränige. Tabe Peteru ne jejige egä, “Simona, maane nää ute gäte? Maane nää äblicäco gäte ireclota lenaja matikäli padare? ");
INSERT INTO bon_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Weene ireclota inajänege piiyepu irecu ätumutäneye, piba apicetnära padare cabu weene lica itrametnenänige. Weeme seemo cina singi gemi cäme singi ne wawename, yepä weeme tääpe cina kokre cäco gemi.” ");
INSERT INTO bon_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tabe cuta cääri acnenutige, pepu pana mene ca irecu ätumutige niinäce liiyepu. ");
INSERT INTO bon_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tabe liba tacnenutige, cuta ute cabu cääri teebibine täädäränige, ingle teeme irecu mäpurage ge. Teepi liba alotneränisi, teepi umle lica ge teebine ngena mene jajime. ");
INSERT INTO bon_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yeesu nesae me abotäntige irecu ätumutame, siige tabe liba tacnenutige, abiberäja bägrä bine jääjänige egä, “Weene ute camu gämi, ngene oocenäniye. Siige, padare te bii tatyaramtige. Cane lui te Acejiyame bau ca tädujine biname me äbitujine, cebine mameta gyene ceera conocono biname bime ime cabu me. ");
INSERT INTO bon_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Arpineräneye, biiri wääjene. Lui biname te cebine nawabenige budre me aglime, tabe mameta gyene.” ");
INSERT INTO bon_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeesu liba camu mene iicema cabu jage, Yuuda teeme twelb abiberäja bägrä bime yepä te piba tatyaramtige. Teta cama biname cina seclige cubu turikä piiyepu gabagaba cama. Modamoda iiwäreja biname, cotre abiberäja biname piiyepu poto Israela modamoda biname cina jityepimisi teebibine. ");
INSERT INTO bon_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yeesu ne budre me awabayame biname te cewecu ne bii becitige pui biname bime tääpume egä, “Cane lui biname ne jetecnenine, peese nyene weene lui tääpume singi gemi. Joomlepeye, weeme ire atwi ngalebora ecanepeye.” ");
INSERT INTO bon_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuuda liba tatyaramtige, tabe piba conocäco ädige Yeesu bau me, jejige egä, “Abiberäja biname,” siige jetecnige teebine. ");
INSERT INTO bon_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Biname cina piba Yeesu ne kokre cama joomlisi. ");
INSERT INTO bon_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lui cina aclajuteji puga icrajige, teeme yepä te cubu turikä ne sisatige, yoororige, siige yepä biname me tablame ne iyeta jeläcnutige. Pui lui iiwäreja mope biname me kaakesea bägrä ge. ");
INSERT INTO bon_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeesu biname bine jejemige egä, “Weene naaclige cubu turikä piiyepu gabagaba cama cebine oomlaname epu pana, egä cane cubucubu biname gäne. ");
INSERT INTO bon_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iyeta bimu gaabegabe cane weene cama ge, iiwäreja mete cabu yaabiberäjimune, weene piba cebine lica noomluye. Apu gyene, ingle lui mene oogäräneji gyene cäme poto cidi me, miiji toraca me äbita.” ");
INSERT INTO bon_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Puma cita ca iyeta abiberäja bägrä cina teebine ebmalisi, siige uucratnige. ");
INSERT INTO bon_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yepä mamye biname te Yeesu ne ingwe icwige. Tabe yepä taatu cäbletääpe ca asigräneji ge. Biname cina liga teebine joomli-si, ");
INSERT INTO bon_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tabe cäbletääpe ne sebmalige, siige cuutacuta uucrige. ");
INSERT INTO bon_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yeesu ne ecanisi iiwäreja mope biname me mete me, liiyeme iyeta modamoda iiwäreja biname, cotre abiberäja biname piiyepu nuuja Israela modamoda biname cina abasecretnuji. ");
INSERT INTO bon_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peteru seeji cude padare ca Yeesu ne ingwe icwige, siige abacitige iiwäreja mope biname me mete caale bora me. Tabe puga adnatige awamuta biname bime cama, gäbu jemajige uliobo gome. ");
INSERT INTO bon_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Modamoda iiwäreja biname piiyepu iyeta mutre biname teepi biname bine jirngemisi Yeesu ne aitnejame budre me agli tääpume, yepä teepi nuuja ne lica jepänisi. ");
INSERT INTO bon_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bucurage biname cina puu Yeesu ne walya jeitnäjisi, yepä teeme mene yepä lica ge. ");
INSERT INTO bon_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Piba poto biname cina abujengäjige, walya jeitnäjisi egä, ");
INSERT INTO bon_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Cine jitecijisi tabe iicana je egä, ‘Cane ai iiwäreja mete ne yiigarecenine, biname cina lui ne erangujisi, piba nesae bimu cama cääri cuta pa yaarangepene nuuja ne, lui biname biji arangäneji mete lica ge.’” ");
INSERT INTO bon_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yepä ai biname bime mene cuta yepä ibi lica gemi. ");
INSERT INTO bon_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iiwäreja mope biname te biname bime opo gaabe abujängtige, Yeesu ne itemlige egä, “Baa, määme nuuja daremu mene lica gyene, teepi lipu meebine naitnäjenisi.” ");
INSERT INTO bon_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yepä tabe bojäcu enajige. Iiwäreja mope biname te cääri itemlige egä, “Nää, maane Keriso säte, biname bine niiya cabu ca lui te isecrärenenemite, cine lui me ngii ne yaawepyeräjusi, teeme Bägrä?” ");
INSERT INTO bon_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu jejige egä, “Yoo, cane säne. Cuta weene cebine pagege päpäna, Acejiyame bau ca lui te tädujine biname me äbitujine, kokre Acejiyame me camu poto ca adnatäneji piiyepu carbe cabu äina gawe me.” ");
INSERT INTO bon_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iiwäreja mope biname te teeme cäbletääpe ne idericige awabame, egä tabe Yeesu ne panyamete jepänige, siige jiicige egä, “Mine nuuja singi lica gemi cerämu poto biname cina teebine aitnejame, ");
INSERT INTO bon_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ingle weene bii bitecijinige, tabe lipu Acejiyame me ngii ne sabe bii jewenige, teeme bägrä ca lipu bainige. Weene lipu ngene jotwanininiye teeme poto cidi me?” Teepi iyeta jiicisi egä, “Teeme niiya pisi nyene, pui name pi teebine miiji budre me agli.” ");
INSERT INTO bon_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Piba teeme poto cina gije abacitinisi teebine mote ca ätyewame. Teepi cäbletääpe ca teeme opo icwabisi, yoororisi, jejisi egä, “Nijini, laati te noororige?” Awamuta biname cina cuta teebine yoororisi. ");
INSERT INTO bon_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peteru liba puga ge pui mete puutucu je, iiwäreja mope biname me kaakesea ngulebägrä te toclige, ");
INSERT INTO bon_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","teebine jepänige gäbu amaja je uliobo gome. Tabe cängena ire acitige teeme bau me, jejige egä, “Maane cuta totnetnäjumete Yeesu Nasareta biname cama.” ");
INSERT INTO bon_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yepä tabe ainige, jojige egä, “Cane umle lica gäne maane ngena poto cidi me jiicenite.” Tabe puma cita ca awetäntige, ädige caale grana wajwa me, siige paulo te ala sengenige. ");
INSERT INTO bon_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pui kaakesea ngulebägrä te cuta cääri jepänige teebine, jejemige lui biname cina puga aclajuteji icrajige egä, “Ai biname lui teeme yepä gyene.” ");
INSERT INTO bon_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yepä Peteru cääri ainige. Matikäli padare ingwe ca lui cina aclajuteji puga ge Peteru ne jejisi egä, “Toraca gyene, maane teeme yepä gäte, ingle maane Galilaya biname gäte.” ");
INSERT INTO bon_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peteru jejemige, “Cane Acejiyame me ngii cabu jijenininine, egä cane umle lica gäne pui biname, weene lui poto cidi me jiicenenemiye.” ");
INSERT INTO bon_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Piba taatu paulo te neeneni me ala sengenige. Peteru ngene jotwige, Yeesu lipu teebine jejige egä, “Maane cebine niinäce nesae gääbu nainenite, piba paulo te neeneni manu ala sengenenige.” Siige tabe ele jiplecmalige. ");
INSERT INTO bon_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Liba kroke sewalige, piba taatu modamoda iiwäreja biname, cotre abiberäja biname, piiyepu nuuja modamoda Israela biname, iyeta lui mutre biname, cina mene jitranisi Yeesu tääpume ngena wawename. Teepi teebine seea ca jetäyisi, Pilato bau me ecanisi. ");
INSERT INTO bon_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Siige, tabe Yeesu ne itemlige egä, “Maane nää Israela biname bime mope biname gäte?” Tabe jejige egä, “Yoo, maane peega bii jiicite.” ");
INSERT INTO bon_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Modamoda iiwäreja biname cina Yeesu ne bucurage gwidape poto cidi me jeitnäjisi, ");
INSERT INTO bon_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","siige Pilato Yeesu ne cääri itemlige egä, “Nää, määme nuuja daremu mene lica gyene? Egäsu maane näätecijenige, teepi lipu meebine bucurage gwidape poto cidi me naaitnäjenisi.” ");
INSERT INTO bon_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yepä Yeesu bojäcu enajige, daremu mene lica jewecnistige, siige Pilato cälu te jitige. ");
INSERT INTO bon_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Israela biname cina liba kämäge gaabegabe äsuplengta soriyomu ne jaawenusi, Pilato piba krokeciiye mete cabu ca yaasatuge teepi lui biname tääpume birige singi. ");
INSERT INTO bon_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pui padare cabu puga ge krokeciiye mete cabu biname ngii Baraba. Tabe poto biname cama cubu itu jiicananepi Rooma modamoda biname bime tääpume. Teepi biname ne itu yaaglepesi budre me teeme cubu ngalebora, siige krokeciiye mete bora yaacranemepesi. ");
INSERT INTO bon_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Siige, biname cina eclige, Pilato ne itemlisi yepä biname ne krokeciiye mete cabu ca asatame, tabe lipu jaawenuge pui padare cabu iyeta kämäge gaabegabe. ");
INSERT INTO bon_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato itemlige egä, “Nää, weene singi gemi cane Israela mope biname ne asatame weeme tääpume?” ");
INSERT INTO bon_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato umle ge, egä modamoda iiwäreja biname cina teebine Yeesu bii becärisi, ingle teepi teebine ire patre jeglisi. ");
INSERT INTO bon_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Puma cita ca modamoda iiwäreja biname cina biname bine giri jicranimige teepi Pilato ne jajime tabe Baraba ne asatame lica Yeesu ne. ");
INSERT INTO bon_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Siige Pilato biname bine cääri itemlimige egä, “Cije cane piba ngena jewenenine teeme tääpume weene lui ne yaainuye Israela biname bime mopeyame ca?” ");
INSERT INTO bon_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Teepi ala abayaninisi egä, “Baarge uli cabu jääbyecresi!” ");
INSERT INTO bon_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato itemlimige egä, “Ngena name pi? Tabe ngena niiya ne itu tewenumi?” Yepä teepi baborage ala abayaninisi egä, “Baarge uli cabu jääbyecresi!” ");
INSERT INTO bon_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato singi ge biname bime ngenecu miiji me wawename, siige tabe Baraba ne sisatige krokeciiye mete cabu ca teeme tääpume. Puma cita ca tabe jejemige Yeesu ne adnaname, siige biname bine ecärimige teepi baarge uli cabu äbyecrame. ");
INSERT INTO bon_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Puma cita ca Rooma cubu biname cina Yeesu ne ecanisi Pilato me mete opo gome me, siige ala tesoglicmisi lui cina yepä sange teta cama. ");
INSERT INTO bon_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Teepi Yeesu ne ciriyäciriyä cäbletääpe esigrisi, pägepäge seeasea ne jemlemaltisi, teeme mope cabu ecitisi krauni tääpume. Teepi ai ne ätutena pana jewenisi, egä tabe babo mope biname gyene. ");
INSERT INTO bon_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Puma cita ca teepi jewablisi teebine, jejisi egä, “Sebore Israela biname bime mopeyame!” ");
INSERT INTO bon_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Teepi teebine suru ca yoororanisi mope gome, mote ca ityewäjisi, siige sinäme kokorare ca ipednanemisi teebine opo gaabe me acitame. ");
INSERT INTO bon_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Teepi teebine apu ätutena pana jewenisi, piba ciriyäciriyä cäbletääpe ne jiiremutisi, teemerage cäbletääpe esigrärisi. Puma cita ca teepi teebine ecanisi baarge uli cabu äbyecrame. ");
INSERT INTO bon_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Puga ge yepä rooriye ngii Simona. Tabe lui Kurene cewe biname gyene, Aleksanda Rupus naabime babe. Tabe calwacupi cewe ca tacnige, siige cubu biname cina giri jecitisi Yeesu me baarge uli ne acaname. ");
INSERT INTO bon_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Puma cita ca teepi Yeesu ne ecanisi cewe ngii Gologota me, lui me aboclomta egä, ‘Mopekaake Cewe’. ");
INSERT INTO bon_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Teepi teebine liga ecärisi miira traci cama alengläciteji waina niiye, yepä tabe lica enige. ");
INSERT INTO bon_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Piba teepi teebine toto ca jibyecrisi baarge uli cabu. Siige puma cita ca teepi matimati kula cabu teeme ngii bine yoogärimisi, piba yiisabäjemisi pui kula bine umle äbitame, egä teepi lipulipu Yeesu me cäbletääpe bine abelename. ");
INSERT INTO bon_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Peei lui krokebimu ge, teepi liba teebine baarge uli cabu jibyecrisi. ");
INSERT INTO bon_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yeesu me mope gome oogäräneji ge teeme budre ingle poto cidi me egä, ISRAELA BINAME BIME MOPE BINAME. ");
INSERT INTO bon_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Teepi cuta neeneni cubucubu biname bine jääbyecrisi baarge uli cabu. Yepä lui Yeesu me camu poto ca, nuuja lui teeme säwäci poto ca. ");
INSERT INTO bon_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Apu mule ca ai Oogäräneji mene te toraca me äbitige egä, “Teebine cubucubu biname pana jewenisi.” ");
INSERT INTO bon_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lui biname cina Yeesu ne isuplengäjisi, teepi jisädanisi, mope akocnäjinisi, jejisi egä, “Baa, maane age säte, iiwäreja mete ne lui te yiigarecenite, siige nesae bimu ngalebora cääri erangenite. ");
INSERT INTO bon_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Maane määmämu miiji äbiti, baarge uli cabu ca täini.” ");
INSERT INTO bon_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cuta modamoda iiwäreja biname piiyepu cotre abiberäja biname cina Yeesu ne pepu jisädanisi. Teepi ajanininisi egä, “Tabe poto bine miiji jaawenanemuge, yepä tabe äblicäco teemämu miiji äbita. ");
INSERT INTO bon_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tabe Keriso ca lainuge, biname bine lui te niiya cabu ca birige äsecrera, piiyepu Israela biname bime mope biname ca, siige tabe täinege baarge uli cabu ca cine päpäname, cine piba jitrunge-nisi teebine.” Lui bine jääbyecrisi teeme gome, teepi cuta teebine jisädenäsi. ");
INSERT INTO bon_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Liba bimu duusa ge, krokeciiye te cewe ne iyeta icwabige nesae awa cama. ");
INSERT INTO bon_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mämle bimu me Yeesu babo tagepogogo ca ala abayige egä, “Eeli, Eeli lama sabatani,” peei lui egä, “Cäme Acejiyame, cäme Acejiyame, maane ngeno me cebine nägyite?” ");
INSERT INTO bon_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Poto lui cina aclajuteji icrajige teeme gome, jitecijisi, jiicisi egä, “Itecijinege, tabe Eliya ne ala tesoglecenige.” ");
INSERT INTO bon_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Puma cita ca yepä te tuuwamige, waarpopale pana gwidape ne caapocapo waina niiye cabu yiiglenutige, suru ca jigadige, isinglantige Yeesu me tage cabu me, jiicige egä, “Mine jääpänesi, Eliya liba tädenige teebine ätrungentame.” ");
INSERT INTO bon_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Piba Yeesu baborage tagepogogo ca ala abayige, siige budre äbitige. ");
INSERT INTO bon_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iiwäreja mete cabu lui baborage cäbletääpe adadnäneji ge, äderärige cabu ca ngälu gawe me. ");
INSERT INTO bon_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cubu biname bime mope biname, lui te aclajuteji enajige Yeesu me opo gaabe, liba jepänige tabe lipu budre äbitige, tabe jiicige egä, “Toraca, ai biname lui Acejiyame me Bägrä gyene.” ");
INSERT INTO bon_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Magebi puga ge cudecewe ca ire. Teeme yepä lui Mariya Magadala cewe magebi tage, nuuja lui Mariya tage lui iganerage Yakobu piiyepu Yoose naabime mage, yepä lui Salome tage. ");
INSERT INTO bon_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Teepi Yeesu cama jage, tabe liba Galilaya je waatnetnäjuge, teebine yäätityeräjusi. Cuta poto cerämu magebi puga ge, lui cina saaclepi Yeesu cama Yerusalema me. ");
INSERT INTO bon_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mämleteca liba mameta ge, Yoosepa Arimatea cewe biname te tatyaramtige. Tabe yepä miijirage mutre biname ge, lui te padare ne jewagrijige Acejiyame te biname bine waadename. Ingle peei lui Fraide ge, Sabade bimu me amacetnäja bimu ge, tabe tii ecanige, Pilato bau me ädige Yeesu me budrekaake tääpume. ");
INSERT INTO bon_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato cälu te jitige ätecijame, egä Yeesu uja budre bäbitige. Tabe jejige ala asoglecame cubu mope biname ne, siige itemlige egä, “Yeesu nää uja budre bäbitige.” ");
INSERT INTO bon_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tabe liba umle äbitige cubu mope biname bau ca, egä Yeesu budre ge, tabe Yoosepa ne jejige teeme budrekaake ne acatame. ");
INSERT INTO bon_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Puma cita ca Yoosepa ädige, bulubulu cäbletääpe ne jeletnige, Yeesu ne sitru-ngamtige, cäbletääpe ca tope etnige, siige gape cabu me ecitige, lui gape ne ituge uurana baborage kula ngalebora. Piba tabe baborage kula ne epetrengäjige gape grana armime. ");
INSERT INTO bon_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magadala cewe magebi piiyepu Mariya Yoose me mage teepi jepänäsi, tabe Yeesu ne luma ecitige. ");
INSERT INTO bon_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabade bimu liba apirige, Mariya Magadala cewe magebi, Mariya Yakobu me mage, piiyepu Salome, teepi miijirage lengo ngängye bine jeletnemänisi Yeesu me budrekaake ne aganame. ");
INSERT INTO bon_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande krokerage, bimu te liba tacitige, teepi ujige gape gome me. ");
INSERT INTO bon_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Gaabe cabu teepi ajanänisi egä, “Laati te pui kula ne epeträngtenige gape grana cabu ca mime tääpume?” ");
INSERT INTO bon_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Teepi apu ajanänisi, ingle kula lui baborage ge. Siige teepi liba atyaräninisi, ire acranänisi, siige jepänänisi, egä kula lui apeträngteji ge. ");
INSERT INTO bon_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Teepi gape cabu me ebäcnänisi, mamye biname ne jepänänisi bulubulu lecaleca cäbletääpe ca asigräneji ge, camu poto cidi ca adnatäneji ge, siige magebi cina cälu te jäätänige. ");
INSERT INTO bon_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tabe teebibine jääjänige egä, “Gone cälu te jitänuge. Weene Yeesu Nasareta cewe biname ne jirngenäneniye, lui ne baarge uli cabu tibyecrumesi. Tabe ama lica gyene. Acejiyame te teebine budre cabu ca berpinantige. Weene ire! Agesa lui puupu cabu teebine sitwitumesi. ");
INSERT INTO bon_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Äte ujeye! Peteru naabibine jejemeye, egä tabe teeme niinäce gaabe me ädenige Galilaya me. Puma teepi opopa eyenisi teta cama, tabe lipu itu jaajemepi teebibine.” ");
INSERT INTO bon_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Magebi cina äsänisi gape cabu ca, siige uucratnänisi, ingle teepi mage cälu te jäätänige piiyepu jaalocnänige wälu name pi. Teepi nuuja biname ne lica jejisi ai poto cidi me, ingle teepi wälu ge. ");
INSERT INTO bon_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande bimu krokerage Yeesu budre cabu ca liba arpinantige, tabe aboclomtige niinäce Mariya Magadala cewe magebi bau me, lui me trupa cabu ca tabe itu yääsecräremepi seben niiya cable bine. ");
INSERT INTO bon_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tabe oclige abiberäja bägrä bime bau me, lui cina Yeesu ne ele jelwisi, jejemige ai poto cidi me. ");
INSERT INTO bon_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yepä teepi liba itecijemige, egä Yeesu barpinantige piiyepu tabe teebine bii jepänige, teepi lica jitrungisi. ");
INSERT INTO bon_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ai ingwe gaabe ca Yeesu aboclomtige mara opo ca neeneni abiberäja bägrä bime bau me, teepi liba gaabe cabu aaclige babo cewe kaake poto cidi ca. ");
INSERT INTO bon_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Siige teepi babo cewe me acnenutäsi poto abiberäja bägrä bime bau me, jejemäsi, egä teepi Yeesu ne bii jepänäsi, yepä teepi lica jäätrungisi teebibine. ");
INSERT INTO bon_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ingwe ca Yeesu aboclomtige lebin abiberäja bägrä bime bau me, teepi liba deedei cabu jage. Tabe teebibine jicnecimige teeme ätrunga cäco piiyepu ätecija cäco mule name pi, ingle teepi lica pui biname bine titrungimumesi, lui cina teebine tepänanumesi, egä tabe budre cabu ca itu tarpinantumi. ");
INSERT INTO bon_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tabe teebibine jejemige egä, “Äte naaclepi, iyeta cewe gaabegabe ta Miiji Mene ne ecananepeye iyeta biname bime bau me ai gawecewe cabu. ");
INSERT INTO bon_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Laati te liba Miiji Mene ne jäätrunguge piiyepu teebine liba niiye ca cuta jääcisäjuye, tabe cirege iyeteta ireclota ne päpäna. Laati te liba lica jäätrunguge, teeme niiya mule cina yaacrajuge, siige teebine cirege atrana. ");
INSERT INTO bon_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lui biname cina Miiji Mene jäätru-ngusi, teepi ai ciitaca mule bine pagege waweneca: teepi cäme ngii cabu niiya cable bine pagege äyecreja biname bime trupa cabu ca, piiyepu teepi teeme umle cäco mene ca pagege iicema. ");
INSERT INTO bon_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Teepi liba cobyame bine joomlemusi coo piiyepu budre niiye liba yaanusi, pui cina äblicäco teebibine sabe wawena. Teepi pagege teeme ime acrana pita biname bime papa cabu me, siige teepi miiji läbitininusi.” ");
INSERT INTO bon_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yeesu Yageyame te liba ai mene teebibine jejananemige, pui kaake poto cidi ca Acejiyame te teebine ecanige cabucewe me, siige tabe Acejiyame me camu poto cidi ca adnatige. ");
INSERT INTO bon_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abiberäja bägrä cina ecluji, Miiji Mene ne ecananujisi iyeta poto ta. Yageyame te kokre ecärimuji teepi ciitaca mule bine wawenecame naace tääpume awabame, egä Miiji Mene toraca gyene. ");
INSERT INTO bon_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yoo, Babo biname Teopilo, maane umle gäte egä bucurage biname cina ituge gije abacita mene oogärame pui modamoda mule poto cidi me lui cina cime gome täbitenäjimesi. ");
INSERT INTO bon_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Cine peei poto cidi me mene ituge ätecija biname bau ca lui cina teemämu ituge päpäna iyeta peei mule teeme agedna cabu ca, piba peei poto cidi me jaajananemepesi. ");
INSERT INTO bon_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yoo, ai name pi cane iyeta pui mule poto cidi me cängenarage itu yaabiberäjemepene, cane jitranine cängena mene oogärame määme tääpume, ");
INSERT INTO bon_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","maane ai cabu ca toraca umle äbitame pui mule poto cidi me teepi meebine lui itu naabiberäjepesi. ");
INSERT INTO bon_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ai mene ne gije jebacitenine Heroda liba Mopeyame tääpume enajuji Israela gawe cabu. Puga ge yepä Acejiyame me iiwäreja biname teeme ngii Sakariya. Tabe yepä iiwäreja babo biname ngii Abija me sange cabu kaakesea jaawenuge. Teeme coga ngii Elisabeta cama teepi neeneni lui Aarona me kaakesaare gegi. ");
INSERT INTO bon_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Teepi miijirage laanajuge Acejiyame me opo gaabe je, iyeta mime Yageyame me singi piiyepu cotre conocäco jaawenäsi. ");
INSERT INTO bon_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yepä teepi bägrä cäco ge, ingle Elisabeta äblicäco bägrä päpäna, cuta piiyepu teepi moda molyege ge. ");
INSERT INTO bon_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nuuja taje teeme padare cabu Sakariya teeme iiwäreja kaakesea jewenanuji Acejiyame tääpume. ");
INSERT INTO bon_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yoo, pui iiwäreja biname bime mule apu ge: teepi matimati kula bine teeme ngii cama yiisabäjemusi teeme maramara kaakesea peema cita ca päpäname. Pui bimu cabu Sakariya lui kaakesea jepänige pui kula yiisabeja cabu ca miijimiji lengo gwidape Acejiyame tääpume uubuderame. Uubudera padare te tatyaramtige, tabe piba Acejiyame me iiwäreja mete ngalebora me abacitige, ");
INSERT INTO bon_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","bucurage biname cina liba tabasecretnige pui mete caale bora me irecu ätumutame. ");
INSERT INTO bon_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Piba Acejiyame me mename seemo te Sakariya bau me taboclomtige, pui miiji lengo gwidape uubudera dade camu poto ca jeclajutige. ");
INSERT INTO bon_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariya liba jepänige teebine, cälu te jitige, wälu te joomlige. ");
INSERT INTO bon_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yepä, mename seemo te jejige egä, “Sakariya, wälu gone! Acejiyame te määme awejena ne secatumi; määme coga Elisabeta imäbägrä ne pa jääpänepi. Maane teebine ngii ecärepi Yoane ca. ");
INSERT INTO bon_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maane ngenecu miiji piiyepu gege pa äbitepi, piiyepu bucurage biname cina babo gege pa läbitipesi teeme aplimla name pi. ");
INSERT INTO bon_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tabe babo cirege äbita Acejiyame me opo gaabe je. Tabe gone waina niiye, coo nuuja sice pana niiye nänäja. Teeme aplimla cabu ca Aceji Seemo teeme trupa cabu babo pa läbitepi. ");
INSERT INTO bon_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tabe bucurage Israela biname bine pa yaatatrongäremepi Acejiyame mime Yageyame bau me. ");
INSERT INTO bon_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Teeme otni lui mime Yageyame me niinäce gaabe myene. Teeme seemo ireclota piiyepu kokre mename biname Eliya pana pagege äbita. Yoo, tabe te babe bime ngenecu pa jaatatrongäremepi teeme bägrä bime bau me, piiyepu ätecija cäco biname bime ngene atwanena pa jaatatrongäremepi toraca conocäco mule wawename. Tabe Yageyame me biname bine pa yaamacetnäjemepi teeme otni tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Siige, Sakariya piba mename seemo ne mene jejige egä, “Cane lipu ai mene toraca umle äbita? Cane moda gäne; cäme coga cuta molyege gwene.” ");
INSERT INTO bon_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mename seemo te jejige egä, “Cane Gabriyela säne, Acejiyame me opo gaabe naclajutuge. Tabe te cebine nätyepige ai miijirage mene meebine jajime. ");
INSERT INTO bon_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yepä, maane cäme mene lica nacatite, peei name pi maane buduma pana äbitenite mene iicemame. Maane bojäcu naanajepi, ngälu pui bimu cabu cäme mene te liba toraca me pa läbitepi. Yoo, peei te teeme padare cabu toraca me pa läbitepi.” ");
INSERT INTO bon_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Siige, iiwäreja mete caale bora je biname cina Sakariya ne jewagrijisi egä, “Ngena te bäbitige mete ngalebora je? Mage leca padare, tabe ngena name pi enajenige, lica tasatenige?” ");
INSERT INTO bon_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Siige, tabe liba tasatige, äblicäco teebibine mene jaji. Teepi puma cita ca umle äbitininisi egä tabe pama apaclyera gwidape ne bii jepänige puma. Mene cäco tabe ime ca teebibine umle jewenemige. ");
INSERT INTO bon_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Siige teeme pui kaakesea padare liba apirige, Sakariya acnenutige cewe me. ");
INSERT INTO bon_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pui ingwe ca teeme coga Elisabeta mäpumäpu äbitige. Tabe mete gome waanajuge faib mabye cama, jiicige egä, ");
INSERT INTO bon_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yageyame te cebine nätityärumi apu äbitame. Ingwe ca cane lica nuuja biname cama ajiri pana lenaja bägrä cäco.” ");
INSERT INTO bon_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta liba siks mabye mäpumäpu cama onajige, pui padare cabu Acejiyame teeme mename seemo Gabriyela ne jityepige Nasareta cewe Galilaya probins cabu me. ");
INSERT INTO bon_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Teeme mene puga ge yepä ngulebägrä tääpume, ngii Mariya. Teeme ciwelooloyame ngii Yoosepa, tabe sasa Mopeyame Daawida me ingle biname ge. ");
INSERT INTO bon_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yoo, Gabriyela Mariya bau me ädige, jojige egä, “Sebore Mariya! Acejiyame maane cama gyene. Tabe babo singi gyene määme tääpume meebine miiji ceerame.” ");
INSERT INTO bon_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya liba peei mene utecijige, tabe ngenecu joclonige, mage ngene jotwananige pui mene ngena tääpume. ");
INSERT INTO bon_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Puma cita ca mename seemo teebine jojige egä, “Mariya, wälu gone, ingle Acejiyame te babo ngenecu miiji gyene määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maane mäpumäpu pa äbitepi, imäbägrä ne pa jepänepi. Teebine ngii ecärepi Yeesu. ");
INSERT INTO bon_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tabe lui baborage cirege; Caburage Acejiyame me bägrä ca pa yaainepesi. Yageyame Acejiyame teebine mopeyame me cire jaawenepi epu pana teeme kaakesaare Daawida lipu mopeyame itu enajuji. ");
INSERT INTO bon_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tabe te Yakobu me kaakesaare bine iyeteta cire yaawademepi, ingle teeme waadena lui ngälu cäco gyene. ");
INSERT INTO bon_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya mename seemo ne itemlige egä, “Cane mäpumäpu lipu äbita, ingle camu gäne rooriye cama atejäclmuta?” ");
INSERT INTO bon_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mename seemo te jojige egä, “Aceji Seemo te määme bau me pa tädepi, piba Caburage Acejiyame me kokre määme cabu pa yaanajepi, peei name pi peei bägrä maane lui ne pa eplimlepi tabe Acejiyame tääpu myene, piiyepu Acejiyame me bägrä ca pa yaainepesi. ");
INSERT INTO bon_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yoo, määme ingle biname Elisabeta cuta imäbägrä pa jääpänepi. Teebine lui tääpume biname cina jwaajusi egä “äblicäco bägrä päpäna,” ngänu gwene page molyege, tabe siks mabye cama mäpumäpu gwene. ");
INSERT INTO bon_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Iyeta gwidape Acejiyame tääpume ibibi gemi wawena.” ");
INSERT INTO bon_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Siige, Mariya piba jejige egä, “Cane Acejiyame me biname gäne teeme singi wawename. Iyeta miiji gyene cäme tääpume äbita maane lui mene bii najite.” Siige, mename seemo piba teebine obmalige. ");
INSERT INTO bon_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yoo, pui mene ingwe ca, Mariya gwidape emacetnäjige, wata oclige yepä cewe Yuudea doro gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tabe Sakariya me mete me puga abacitige, Elisabeta ne sebore jowenige. ");
INSERT INTO bon_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yoo, Elisabeta liba Mariya me mene utecijige, teeme bägrä te piba apinyarige came bora ätni diiba cabu, piiyepu Aceji Seemo Elisabeta me trupa cabu babo äbitige. ");
INSERT INTO bon_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tabe babo tage ca Mariya ne jojige egä, “Acejiyame te meebine babo miiji naawenige iyeta magebi cabu ca, piiyepu maane lui bägrä ne pa eplimlepi, tabe Acejiyame me babo miiji cama gyene. ");
INSERT INTO bon_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cane ngeno me ai miiji ne päpäna, cäme Yageyame me mage te cebine nädärenige! ");
INSERT INTO bon_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cane liba määme sebore mene nätecijige, piba taatu bägrä te gege cama apinyarige cäme came bora ätni diiba cabu. ");
INSERT INTO bon_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Maane ngenecu gege gäte, ingle mime Yageyame me mene maane jaatrungepete egä määme poto cidi me pagege äbita.” Siige. ");
INSERT INTO bon_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya jiicige egä, “Cane Acejiyame ne ewepyeräjenine iyeta cäme ngenecu cama. ");
INSERT INTO bon_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cäme seemo te gege äbitenige Acejiyame tääpume, lui te cebine niiya cabu ca cirege asata. ");
INSERT INTO bon_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tabe owecu cama cebine näpänumi, cane lui teeme matikolä kaakesea bägrä gäne. Ama cita ca iyeta biname cina cebine pa nainepesi “gege gwene,” ");
INSERT INTO bon_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","peei modamoda gwidape name pi Acejiyame lui bine teeme kokre ca itu tewenemumi cäme tääpume. Teeme ngii lui jamyacu conocäco gyene. ");
INSERT INTO bon_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bägrä bime padare cabu ca piiyepu maramara kaakesaare bime padare cabu ca, tabe biname bine owecu jaawenemuge, lui cina teebine opo gaabe me yaacitusi. ");
INSERT INTO bon_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tabe kokre mule bine ime ca itu jaawenemepi; biname lui cina ngenecu bora teemeteme babo me läbituge, teebibine jaawenemepi maramara me aplidnerame. ");
INSERT INTO bon_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tabe modamoda mope biname bine gawe me itu yaajaremepi teeme miijimiji puupu cabu ca, yepä matimati biname bine ituge awepenta. ");
INSERT INTO bon_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Deedei cäco biname bine tabe yäängäremepi miijimiji deedei ca, yepä dogwe biname bine deedei cäco yääyecräjemepi. ");
INSERT INTO bon_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tabe cängena jaawenemepi lui mene mime kaakesaare bine ituge jaji; mibibine itu nitityäripi lui gemi teeme kaakesea bägrä ngii Israela cabu ca. Tabe teeme mene lica ngene jäätrimalepi, owecu wawename Abrahamo piiyepu teeme kaakesaare bine iyeteta.” ");
INSERT INTO bon_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Siige, Mariya Elisabeta cama onajige nesae mabye cama, piba acnenutige teeme cewe me. ");
INSERT INTO bon_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yoo, Elisabeta me padare liba tatyaramtige, tabe imäbägrä ne eplimlige. ");
INSERT INTO bon_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Siige, teeme inglewale piiyepu cewe mameta lui biname cina liba mene itecijemige Yageyame te lipu Elisabeta ne babo owecu jowenige, teepi ten cama gege äbitininisi. ");
INSERT INTO bon_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Imäbägrä te liba eit bimu joomlige, teeme binamewale cina seclige Acejiyame me cewecu acita mule wawename tääpe matikolä iirputa ca. Teepi singi bägrä ne babe me ngii ceerame, Sakariya, ");
INSERT INTO bon_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","yepä teeme mage te jejemige egä, “Eewe! Teeme ngii lui Yoane.” ");
INSERT INTO bon_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Teepi mage me mene jowecnistisi egä, “Peei ngii weeme ingle cabu lica gyene.” ");
INSERT INTO bon_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Teepi puma cita ca babe ne ime ca jewenisi teebine ätemlame egä, “Maane ngena ngii tääpume singi bägrä ceerame?” ");
INSERT INTO bon_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakariya oogära gwidape tääpume jejige, peei cabu yoogärige egä, “Teeme ngii lui Yoane.” Biname cina cälu te jitemige. ");
INSERT INTO bon_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Piba taatu Sakariya me wätä te miiji me äbitige, piiyepu teeme tagepogogo te tasatige. Tabe mene me gije abacitige Acejiyame ne awepyeräjame. ");
INSERT INTO bon_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cewe mameta biname cina wälu äbitininisi; peema cita ca idre ecenanisi Yuudea podo gawe cabu iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyeta lui cina peei mene itecijemige, mage ngene jotwa-naninisi, ätemläjinisi egä, “Ai bägrä tääpume lipu äbitenige?” Yoo, Biname bime tääpume pajecu ge egä Acejiyame me kokre ime puga ge pui bägrä cama. ");
INSERT INTO bon_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aceji Seemo te Yoane me babe Sakariya me trupa cabu me babo äbitige; tabe Acejiyame me tagepogogo mene jiicemige egä, ");
INSERT INTO bon_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Acejiyame mime Israela biname bime Yageyame ne mine pa yaawepyeräjesi, ingle tabe mibibine bii ningrärininige piiyepu mime niiya cabu ca äsecrera gaabe bii nicärininige. ");
INSERT INTO bon_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tabe mime tääpume kokre äsecrera biname ne bii tityepige, lui teeme kaakesea bägrä Daawida me kaakesaare gyene. ");
INSERT INTO bon_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ujarage, tabe teeme conocäco mename biname bime tagepogogo ca jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tabe mibibine cire niyeblingipi mime cubuyame bau ca, piiyepu teeme ime cabu ca lui cina mibibine nimugetninininusi. ");
INSERT INTO bon_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tabe te jiicuji egä tabe mime kaakesaare bine owecu wawename, piiyepu teeme conocäco jajeji mene tabe lica ngene ätrimelame. ");
INSERT INTO bon_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tabe mime kaakesaare Abrahamo ne teeme kokre ngii cabu jejuji ");
INSERT INTO bon_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","egä mibibine cirege äsecrera cubuyame me ime cabu ca, mine piba teeme tääpume kaakesea wälu cäco wawenecame, ");
INSERT INTO bon_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","piiyepu ngenecu epucäco conocäco lenajame teeme opo gaabe je iyeta mime ireclota ngalebora. ");
INSERT INTO bon_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yoo, cäme bägrä, biname cina meebine pa naainepesi mename biname ca mime Caburage Acejiyame tääpume, Ingle maane niinäce pa ädepi gaabe amacetnäjame Yageyame tääpume, ");
INSERT INTO bon_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","teeme biname bine umle wawename egä äsecrera gaabe pisi nyene, teepi liba kälyä jääpänemusi Acejiyame bau ca teeme niiya mule tääpume. ");
INSERT INTO bon_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mime Acejiyame lui baborage owecu piiyepu owelaamelame cama; teeme äsecrera biname te bimu me ajara pana, cabucewe ca mime bau me pa tädepi, ");
INSERT INTO bon_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","saapaclyärepi biname cabu lui cina krokeciiye mule cabu icrajinige, piiyepu teeme budre mule name pi wälu gemi. Tabe cuta mibibine pa niwadipi poode ireclota gaabe cabu otnime.” ");
INSERT INTO bon_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yoo siige, pui bägrä te uutige, babo me äbitige, cuta teeme seemo kokre me äbitige. Tabe daapo taatu cewe cabu enajige, ngälu pui bimu tabe liba teeme kaakesea gije jebacitige Israela biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pui padare cabu, Rooma Babo Mopeyame Siisa Agusto te mene jityepäjemige iyeta cewe cabu ta egä iyeta biname cina miiji otni teeme ngii acranecame biname acnema tääpume. ");
INSERT INTO bon_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yoo, biname ngii Kwairiniyus tabe Suriya probins Mopeyame ge pui mule te liba äbitige. ");
INSERT INTO bon_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iyeta biname cina otninisi teeme saare bime cewe me teeme ngii acranecame. ");
INSERT INTO bon_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoo, biname ngii Yoosepa tabe ädige Nasareta cewe cabu ca, piba Galilaya probins ne sebmalige, Yuudea probins abacitige, ädige Betelehema cewe me, sasa Israela Mopeyame Daawida luma aplimluji, ingle tabe Daawida me kaakesaare ge. ");
INSERT INTO bon_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yoo, teeme ciwelooloyame Mariya ten cama oclige ngii acitame. Mariya mäpumäpu gwene. ");
INSERT INTO bon_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Egäcäro teepi liba Betelehema cewe cabu puga ge, piba teeme padare te tatyaramtige iigyärame. ");
INSERT INTO bon_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tabe teeme niinäce bägrä ne jepänige, imäbägrä, teebine cäbletääpe ca etnige, kau bime deedei acrana puupu cabu ecwanige, ingle teepi kau mete cabu aanajige. Teeme tääpume puupu lica ge otnetneja biname bime ute mete cabu. ");
INSERT INTO bon_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yoo, pui cewe mameta puga ge maamoi ire atwi biname lui cina baace cewe cabu uta cama icrajige teeme maamoi bine cängena ire atwime. ");
INSERT INTO bon_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mime Yageyame me mename seemo te teeme bau aboclomtige, piba taatu mime Yageyame me jamyacu apaclyera te teeme gome tuungepmalige. Babo wälu te teebibine joomlemige, ");
INSERT INTO bon_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","piba pui mename seemo te jejemige egä, “Wälu gone! Cäme babo miijirage mene agesa weeme tääpume. Peei mene te iyeta biname bine baborage ngenecu gege me pa jaawenemepi. ");
INSERT INTO bon_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Page ai ciiye imäbägrä te aplimlige Daawida me cewe cabu je. Tabe weeme niiya cabu ca äsecrera biname pagege äbita; tabe Keriso sine weeme Yageyame. ");
INSERT INTO bon_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yoo, weene ai cabu ca umle pa äbitineye cäme mene toraca gyene: weene bägrä ne jepäneniye cäbletääpe ca tope atneji gyene, siige kau bime deedei acrana puupu cabu acwanäneji gyene.” ");
INSERT INTO bon_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Piba taatu bucurage mename seemo cina aboclomäjininisi pui niinäce mename seemo gome. Teepi Acejiyame ne uupera ca ewepyeräjisi egä, ");
INSERT INTO bon_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Jamyacu apaclyera lui mime caburage Acejiyame tääpu myene. Gawe cabu biname cina ngenecu poode pa läbitipesi, tabe lui bime tääpume ngenecu miiji gyene.” ");
INSERT INTO bon_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Siige, pui mename seemo cina liba teeme bau ca cabucewe me äcnärige, piba maamoi ire atwi biname cina teemeteme ajananinisi egä, “Biiri naclege Betelehema me ai mule ne päpäname Yageyame te lui poto cidi me mibibine nijinige.” ");
INSERT INTO bon_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Siige, puma cita ca teepi watawata eclige, Mariya Yoosepa naabibine jääpänisi piiyepu teeme bägrä ne jepänisi pui kau bime deedei acrana puupu cabu. ");
INSERT INTO bon_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Liba bägrä ne jepänisi, piba biname bine pui mene jejananemisi, mename seemo te lipu jejemige teebibine ai bägrä poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyeta lui cina itecijemige, cälu te jitemige pui maamoi ire atwi biname bime mene poto cidi me, ");
INSERT INTO bon_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","yepä Mariya teeme ngenecu bora icranemige iyeta pui mene bine. Tabe baborage ngene jotwananige peei poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pui maamoi ire atwi biname cina piba äcnärige teeme cewe me. Teepi Acejiyame ne uupera ca ewepyeräjisi iyeta gwidape tääpume teepi lui itecijemige piiyepu jepänemisi. Yoo, iyeta pepu äbitige mename seemo te lipu itu tejemumi. Siige. ");
INSERT INTO bon_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Eit bimu ingwe ca padare te tatyaramtige bägrä tääpume Acejiyame me cewecu mule wawename tääpe matikolä iirputa ca. Teepi teebine ngii einäsi Yeesu. Peese nyene pui ngii mename seemo te lui Mariya ne jwaajepi tabe mäpumäpu piba lica ge pui padare cabu. ");
INSERT INTO bon_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yoo, padare te piba tatyaramtige Yoosepa naabi Mariya Acejiyame me cotre mule cängena wawename, Moose lui ne itu soogäruji marnga äyeblingta poto cidi me. Teepi pui yepä padare cabu bägrä ne ecanäsi Yerusalema me teebine Yageyame tääpume mara me wawename. ");
INSERT INTO bon_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yoo, mime Yageyame me Oogäräneji Mene pisi nyene egä iyeta niinäce aplimläneji imäbägrä bine miiji Acejiyame tääpume mara me wawename, cuta piiyepu niinäce aplimläneji rooriye ngeerangera cibu plongo bine miiji Acejiyame Yageyame tääpume mara me wawename. ");
INSERT INTO bon_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Siige, puga Yeesu me mage babe cina teeme owecu gwidape Acejiyame ne ecäräsi iiwärejame marnga äyeblingta mule apirame, ingle mime Yageyame me Cotre Mene jiicenige egä miiji neeneni giiwi ele, coo neeneni gimäe plongo ca iiwäreja pui mule me apira tääpume. ");
INSERT INTO bon_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yoo, puga ge Yerusalema babo cewe cabu yepä biname ngii Simeona. Tabe miijirage biname ge; Acejiyame bau irecu lätumutanuge. Tabe Acejiyame me padare ne jewagrijenige Israela biname bine teeme niiya cabu ca äsecrerame. Aceji Seemo lui teeme cabu yaanajuge, ");
INSERT INTO bon_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","teebine ituge jaji egä, “Maane lica budre päpäna ngälu maane Yageyame me biname ne cire jepänepi, Israela biname cina lui ne jewagrijenisi teebibine niiya cabu ca äsecrerame.” ");
INSERT INTO bon_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yoo, pui bimu cabu tabe iiwäreja mete caale bora abacitige. Piba Yeesu me mage babe cina bägrä ne ecanäsi pui mete puupu cabu me, Cotre Mene teeme poto cidi me cängena wawename. ");
INSERT INTO bon_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeona bägrä ne teeme ime ca ecatige, Acejiyame ne piba eso ecärige egä, ");
INSERT INTO bon_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Oo, Yageyame, cane määme kaakesea bägrä ngenecu poode cama budre pagege, ingle maane lui mene cebine itu najujite page toraca me bäbitige. ");
INSERT INTO bon_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Cane irecu ca bii jepänine määme biname, cibibine lui te cirege niiya cabu ca äsecrera, ");
INSERT INTO bon_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","maane lui poto cidi me ituge jaji tabe aboclomtenige iyeta biname bime opo gaabe. ");
INSERT INTO bon_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tabe ngale pana pagege äbita gaabe ceerame maramara gawe biname bine niiya cabu ca äsecrerame, piiyepu jamyacu apaclyera ne acaname määme Israela biname bime bau me.” ");
INSERT INTO bon_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Siige, bägrä me mage babe cina cälu te jäätige Simeona me mene tääpume. ");
INSERT INTO bon_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeona teebibine miiji jaawenänige teeme mene ca, piba bägrä me mage Mariya ne umle mene jojige egä, “Maane ngenecu mäpu cirege päpäna, epu pana turikä te määme ngenecu lipu cire naatrapepi, ingle bucurage Israela biname cina ai bägrä ne cire jäägyepesi piba peei cabu ca teeme mäpu daremu päpäname. Yepä, nuuja cina babo miiji teeme bau ca cirege päpäna. Yoo, Acejiyame teebine pa yaaboclomtepi Israela biname bime tääpume, piiyepu lui cina teebine jääsädusi, teepi teeme niiya ngene atwanena pepu yaaboclomäjemusi.” ");
INSERT INTO bon_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Siige, cuta puga ge yepä Acejiyame me mename biname, magebi gwene, teeme ngii Ana tune. Teeme babe me ngii Panuela, Asera me ingle cabu ca. Tabe molyege gwene, lui te teeme mamye cabu rooriye ne ecatige, ten cama seben kämäge taatu onajige, ");
INSERT INTO bon_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","piba tabe cuubla waanajepi ngälu pui padare eitifooa kämäge oomlaname. Tabe lica nuuja gome waacluge, yepä iiwäreja mete caale bora waanajuge ciiye bimu, Acejiyame me ngii ne yaawepäntuge irecu ätumuta ca cuta piiyepu deedei cäco lenaja ca. ");
INSERT INTO bon_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tabe mameta me toclige, pui padare Simeona mene jiicemige. Tabe Acejiyame ne eso ecärige teeme Bägrä tääpume, piba mene pui bägrä poto cidi me jejananemige iyeta biname bine, Yerusalema ngalebora lui cina Acejiyame me padare ne jewagrijenisi teebibine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Teepi liba iyeta pui cotre mule epiremäsi, lui Yageyame me Oogäräneji Mene cabu, piba Galilaya gawe cabu teeme cewe Nasareta me äcnäränisi. ");
INSERT INTO bon_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bägrä te uutige, kokre äbitige. Tabe babo umle cama äbitige, piiyepu Acejiyame te teebine babo miiji me jewenanige. ");
INSERT INTO bon_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yoo, iyeta kämäge gaabegabe Yeesu me mage babe cina Yerusalema me waatnetnejäsi Äsuplengta trii tääpume, Israela biname bime äsecrera Aikupito cabu ca ngene apecname. ");
INSERT INTO bon_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yeesu liba twelb kämäge joomlige, tabe teeme mage babe cama pui trii tääpume ädige, teeme mule lipu ge. ");
INSERT INTO bon_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yoo, iyeta pui trii mule liba apirininisi, teeme mage babe liba gaabe cabu aaclige cewe me acnenutame, teeme bägrä Yeesu lui Yerusalema je puma enajige, yepä mage babe nuuja umle lica ge peei poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Teepi apu jaangige egä tabe niinäce gaabe me biname cama bädige, peei name pi pui bimu teepi papa aaclige ngälu mämleteca me, piba gije jecitäsi teebine ärngime teeme binamewale bau ca, piiyepu gaabe cabu lui nuuja teeme biname cina otninisi teeme bau ca. ");
INSERT INTO bon_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yepä, teepi teebine lica jepänäsi, peei name pi acnenutäsi Yerusalema me teebine puma ärngime. ");
INSERT INTO bon_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Neeneni bimu ingwe ca teepi teebine iiwäreja mete caale bora je jepänäsi, poto abiberäja biname cama adnatäneji ge. Tabe teebibine itemläjemige piiyepu teeme mene cängena jitecijemige. ");
INSERT INTO bon_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyeta biname lui cina teeme mene jitecijisi, cälu te jitemige teeme miiji daremu mene piiyepu teeme umle poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Teeme mage babe cina cälu te jäätige liba teebine puma jepänäsi. Mage te jejige egä, “Cäme bägrä, maane ngeno me cibibine pepu niwenite? Määme babe cama cine mage ngenecu mäpu cama meebine näärngenago.” ");
INSERT INTO bon_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tabe teebibine mene jaajige egä, “Weene ngena tääpume cebine närngeniye? Baa, weene umle lica gegi egä cane miiji cäme Babe me mete cabu nanajenige?” ");
INSERT INTO bon_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yepä, teepi teeme mene ne opo lica ewatnäsi. ");
INSERT INTO bon_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yoo, Yeesu ten cama acnenutige Nasareta cewe me. Tabe teeme mene iyeta padare cängena yäätecijanuge. Teeme mage te iyeta pui mule bine ngenecu bora icranemige. ");
INSERT INTO bon_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Siige, Yeesu babo äbitige, piiyepu toraca umle cama äbitige. Biname cina teeme tääpume ngenecu miiji me äbitininisi; Acejiyame cuta piiyepu ngenecu miiji ge teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yoo, padare apu ge: Fiftin kämäge cama Babo Mopeyame Tiberiyu pui gawe ire jetwige Rooma cewe cabu ca. Poto teeme mameta biname ai fooa cina ai gawe maramara ire jetwemisi. Pontiyo Pilato te Yuudea gawe ne ire jetwige, Heroda te Galilaya gawe ne ire jetwige, teeme naane Pilipo te Iturea piiyepu Trakoniti gawe bine ire jaatwige, piiyepu Lusaniya te Abilene gawe ne ire jetwige. ");
INSERT INTO bon_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pui padare cabu Anas piiyepu Kayapa lui iiwäreja mope biname ge. Yoo, pui padare cabu Acejiyame me mene te tatyaramtige Sakariya me bägrä Yoane bau me. Tabe lui puga ge daapo taatu cewe cabu je. ");
INSERT INTO bon_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tabe piba otnetnäjige iyeta cewe maramara Yoridana baduge wajwa ta, biname bine jejananemige egä, “Weene weeme niiya mule cabu ca atatrongärineye Acejiyame bau me, niiye ca äciseja ne ecateye weeme kirece mule ne awabudnitame, siige Acejiyame te weeme niiyaniya mule bine pa yääyeblengemepi.” ");
INSERT INTO bon_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yoo, mename biname Isaya te mene itu soogäremuji Yoane poto cidi me egä, “Daapo taatu cewe cabu biname te babo tagepogogo ca cire jiicepi egä, ‘Yageyame me gaabe emacetnäjeye, weeme mule bine conocäco jewenemeye teeme otni tääpume. ");
INSERT INTO bon_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iyeta payapaya bine miiji äclidna, piiyepu iyeta dorodoro gawe bine miiji ämuleca. Cubecube gaabe bine miiji conocäco waweneca, piiyepu dräcudräcu gaabe bine miiji lale wawena. ");
INSERT INTO bon_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Piba iyeta biname cina pa jääpänepesi Acejiyame me niiya cabu ca äsecrera teeme tääpume.’” ");
INSERT INTO bon_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Siige, bucurage biname cina Yoane bau totninisi niiye ca äciseja tääpume. Tabe teebibine jejemige egä, “Weeme angletneja lui cobyame pana gyene! Weene ai äciseja mule ca singi uucraname niiya mule cabu ca, piba muye puupu cabu me lica otni, yepä weene lica toraca Acejiyame bau me latatrongärininuye. ");
INSERT INTO bon_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Weene miiji pui mule bine waweneca lui cina yaaboclomäjininusi egä weene niiya mule cabu ca ituge atatrongära. Gone weemeweme lajananinuye egä, ‘Cine Abrahamo me kaakesaare gemi, peei name pi miiji gemi. Cane jijenininine egä Acejiyame ibibi gyene nuuja bägrä Abrahamo tääpume wawena ai kula cabu ca, tabe liba singi gyene. ");
INSERT INTO bon_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Weene epu pana gemi uli liiyepu. Yäpä acitäneji gyene uli maape je. Iyeta uli lui cina miijirage kuu lica, yääyemepesi, pa yaargawemepesi, muye cabu me pa yiisabepesi ayime.” ");
INSERT INTO bon_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Siige, biname cina teebine itemlisi egä, “Cine ngena ne miiji wawena?” ");
INSERT INTO bon_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tabe teebibine jejemige egä, “Laati te neeneni cäbletääpe cama, miiji gyene yepä ceera biname ne lui teeme cäbletääpe lica gyene, piiyepu lui cina deedei cama yaacrajuge, miiji gyene pacupacu ätreca.” ");
INSERT INTO bon_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Poto täks rarekaake atomleca biname cina cuta teeme bau otninisi niiye ca äciseja tääpume, siige itemlisi egä, “Abiberäja biname, cine te cuta ngena miiji wawena?” ");
INSERT INTO bon_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tabe teebibine jejemige egä, “Gone rarekaake papa uutecrena, yepä weene biname bime toraca täks rarekaake taatu yaawadanemuye.” ");
INSERT INTO bon_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Piba poto cubu biname cina teebine itemlisi egä, “Cine cuta lipu? Cine ngena ne miiji wawena?” Tabe cuta teebibine jejemige egä, “Gone nuuja biname bime rarekaake juutecranemuye, coo rarekaake walya aitneja cabu ca gone yaacatuye, yepä weeme kaakesea daremu pui rarekaake ibibi yaawadanemuye. Gone cerämu poto tääpume singi.” ");
INSERT INTO bon_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yoo, iyeta Israela biname cina niiya cabu ca äsecrera biname ne jewagrijenisi. Teepi liba Yoane me umle mene itecijemige, piba ngene jotwananinisi egä pama tabe sine. ");
INSERT INTO bon_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piba Yoane teebi-bine jejemige egä, “Cane weebibine niiye ca jicisäjenininine Acejiyame me ngii cabu, yepä lui biname te tädenige, tabe cäme bau ca epu baborage gyene egä cane ibibi lica gäne teeme ernge gwidape seea bine iibirame. Tabe weebibine Aceji Seemo ca piiyepu muye ca pa jicisäjipi. ");
INSERT INTO bon_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Teeme padare cudecewe lica gyene miiji mule biname piiyepu niiya mule biname bine abelename. Tabe epu pana gyene calwacupi biname liiyepu lui teeme wiiti kuu ämleceja gwidape pisi nyene ime cabu. Tabe miiji kuu bine pa jaabalodnemepi, piba pa yaawademepi mete me, yepä mälwä pa juubudäremepi ätuma cäco muye cabu.” ");
INSERT INTO bon_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoo, bucurage mene ca Yoane te biname bine cängena yaablawäjemuge, teebibine miiji mene jaajananemuge. ");
INSERT INTO bon_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tabe cuta Mopeyame Heroda ne eblawäjige, ingle Heroda teeme naane me coga Herodiyas juutecrige, teeme coga me jowenige, piiyepu bucurage nuuja niiya mule bine jaawenemuge. ");
INSERT INTO bon_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Piba Heroda nuuja niiyarage mule ne jewenige, tabe liba Yoane ne krokeciiye mete bora ecitige. ");
INSERT INTO bon_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iyeta biname liba Yoane bau me seclige, tabe te teebibine niiye ca äcisejame Acejiyame me ngii cabu, cuta Yeesu äciseja ne becatige Yoane bau ca. Egäcäro Yeesu Acejiyame bau irecu ätumutige, cabucewe te äplige, ");
INSERT INTO bon_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","piiyepu Aceji Seemo te täinige teeme papa cabu me gimäe ele pana opo cama. Siige, tagepogogo te cabucewe ca tiicige egä, “Maane cäme ngenecurage bägrä gäte. Cane baborage ngenecu miiji gäne määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yeesu liba gije jebacitige teeme abiberäja kaakesea wawename, tabe piba teeti kämäge cama ge. Biname cina apu jengemige tabe Yoosepa me bägrä ge. Yoosepa me babe lui Heli sine; Heli me babe lui Matat sine; ");
INSERT INTO bon_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat me babe lui Leebi sine; Leebi me babe lui Melki sine; Melki me babe lui Yanai sine; Yanai me babe lui Yoosepa sine; ");
INSERT INTO bon_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoosepa me babe lui Matatiya sine; Matatiya me babe lui Aamos sine; Aamos me babe lui Nahuma sine; Nahuma me babe lui Cesili sine; Cesili me babe lui Nagai sine; Nagai me babe lui Maati sine; ");
INSERT INTO bon_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maati me babe lui Matatiya sine; Matatiya me babe lui Semei sine; Semei me babe lui Yoseka sine; Yoseka me babe lui Yooda sine; ");
INSERT INTO bon_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yooda me babe lui Yoanan sine; Yoanan me babe lui Reesa sine; Reesa me babe lui Serubabelu sine; Serubabelu me babe lui Salatiyelu sine; Salatiyelu me babe lui Neeri sine; ");
INSERT INTO bon_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri me babe lui Melki sine; Melki me babe lui Aadi sine; Aadi me babe lui Kosam sine; Kosam me babe lui Elmada sine; Elmada me babe lui Cera sine; ");
INSERT INTO bon_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Cera me babe lui Yosuwa sine; Yosuwa me babe lui Eliyesa sine; Eliyesa me babe lui Yorim sine; Yorim me babe lui Matat sine; Matat me babe lui Leebi sine; ");
INSERT INTO bon_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leebi me babe lui Simeona sine; Simeona me babe lui Yuuda sine; Yuuda me babe lui Yoosepa sine; Yoosepa me babe lui Yoonam sine; Yoonam me babe lui Eliyakima sine; ");
INSERT INTO bon_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakima me babe lui Melea sine; Melea me babe lui Mena sine; Mena me babe lui Matata sine; Matata me babe lui Natana sine; Natana me babe lui Daawida sine; ");
INSERT INTO bon_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawida me babe lui Yese sine; Yese me babe lui Obeda sine; Obeda me babe lui Boasa sine; Boasa me babe lui Salamona sine; Salamona me babe lui Naasona sine; ");
INSERT INTO bon_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasona me babe lui Aminadaba sine; Aminadaba me babe lui Arama sine; Arama me babe lui Hesoroma sine; Hesoroma me babe lui Perese sine; Perese me babe lui Yuuda sine; Yuuda me babe lui Yakobu sine; ");
INSERT INTO bon_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yakobu me babe lui Isacako sine; Isacako me babe lui Abrahamo sine; Abrahamo me babe lui Teera sine; Teera me babe lui Nahora sine; Nahora me babe lui Seruge sine; ");
INSERT INTO bon_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruge me babe lui Reeu sine; Reeu me babe lui Pelege sine; Pelege me babe lui Ebere sine; Ebere me babe lui Seela sine; ");
INSERT INTO bon_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seela me babe lui Kainan sine; Kainan me babe lui Arpasada sine; Arpasada me babe lui Seem sine; Seem me babe lui Nooa sine; Nooa me babe lui Laameke sine; ");
INSERT INTO bon_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laameke me babe lui Metusela sine; Metusela me babe lui Eenoka sine; Eenoka me babe lui Yaarede sine; Yaarede me babe lui Mahalalel sine; Mahalalel me babe lui Kainan sine; ");
INSERT INTO bon_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan me babe lui Enosa sine; Enosa me babe lui Seeta sine; Seeta me babe lui Adamu sine; piiyepu Adamu me babe lui Acejiyame sine. ");
INSERT INTO bon_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeesu liba acnenutige Yoridana Baduge gome ca, Aceji Seemo te babo äbitige ten cabu, teebine ecanige daapo taatu cewe me. ");
INSERT INTO bon_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Puga Satani te teebine mage epicetneräjige footi bimu cama. Iyeta pui padare tabe nuuja deedei lica erwige, peei name pi pui footi bimu liba apirininisi, tabe baborage loolomecewe ge. ");
INSERT INTO bon_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satani piba teebine jejige egä, “Maane liba Acejiyame me Bägrä gäte, ai kula ne jeji buluduu me ateplengtame.” ");
INSERT INTO bon_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yepä, Yeesu jejige egä, “Oogäräneji Mene te apu jiicenige egä, ‘Deedei taatu te ireclota lica yääcärimuge biname bine’.” ");
INSERT INTO bon_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Piba Satani teebine caburage me ecanige, wata jewabäjige iyeta maramara mope biname bime gawe, ");
INSERT INTO bon_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","jejige egä, “Cane meebine yageyame pa naawenepene iyeta ai gawecewe tääpume, piiyepu iyeta teeme biname piiyepu iyeta teeme jamyacu gwidape bine määme ime cabu pa yaacranemepene, ingle cane te iyeta ituge waadena, peei name pi cane laati ne singi ceera, cane miiji gäne teebine ceerame. ");
INSERT INTO bon_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Maane liba kokorare ca ääpednutenite cäme tääpume cebine awejename, piba ai gwidape iyeta lui määmi nemi.” ");
INSERT INTO bon_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Siige, Yeesu jejige egä, “Oogäräneji Mene te jiicenige, ‘Yageyame määme Acejiyame ne yaawejanuye, cuta teeme taatu singi ne jewenepi.’” ");
INSERT INTO bon_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Puma cita ca Satani teebine Yerusalema me ecanige, iiwäreja mete caburage toro cabu etecwamtige, puma jejige egä, “Maane liba Acejiyame me bägrä gäte, maane ama cita ca uuplacamti gawe me, ");
INSERT INTO bon_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ingle Oogäräneji Mene te jiicenige egä, ‘Acejiyame te teeme mename seemo bine pa jaajemepi meebine cängena ire atwime. ");
INSERT INTO bon_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Teepi meebine teeme ime cabu pa naacanepesi, piba maane määme ernge ne kula cabu lica pa jimudnärepi.’” ");
INSERT INTO bon_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yepä, Yeesu jejige egä, “Oogäräneji Mene te jiicenige egä, ‘Maane gone läbitute Yageyame määme Acejiyame ne apicetnärame.’” ");
INSERT INTO bon_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Siige, Satani liba iyeta epirige Yeesu ne apicetnära, tabe piba teebine ebmalige, ingwe padare ne jewagrijenige. ");
INSERT INTO bon_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Puma cita ca Yeesu acnenutige Galilaya probins me; Aceji Seemo me kokre lui ten cama ge. Teeme poto cidi me idre mene ecanisi pui gawe iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tabe biname bine ebiberäjemige teeme maramara abasecretna mete cabu, piiyepu iyeta biname cina teebine ewepyeräjisi. ");
INSERT INTO bon_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeesu ädige Nasareta cewe me, tabe luma babo me äbituji. Israela biname bime Sabade bimu cabu, tabe abasecretna mete me ädige, teeme mule liiyepu. Tabe puma abujängtige Oogäräneji Mene acnemame. ");
INSERT INTO bon_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Teepi peba ecärisi Isaya lui ne soogäruji. Tabe peba ne jiitnige, jepänige ai mene luma oogäräneji ge, siige ecnemige egä, ");
INSERT INTO bon_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yageyame me Seemo pisi nyene cäme cabu. Tabe peei name pi cebine itu najepi teeme Miiji Mene owecu mete biname bine jajanename. Tabe cebine itu nätyepepi krokeciiye mete biname bine mene jajanena teeme äsecrera poto cidi me, piiyepu irecu määsumäsu biname bine jajanena egä teepi teeme irecu ca cängena cirege päpänena. Tabe cebine itu nätyepepi biname bine ätityerame teeme mäpu ireclota cabu ca äsecrerame, ");
INSERT INTO bon_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","piiyepu iicemame egä, ‘Yageyame me ätityera padare lui age sena.’” ");
INSERT INTO bon_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Siige, Yeesu piba peba ne iclubicige, kaakesea biname bau me ewecnistige, adnatige. Iyeta biname pui abasecretna cabu teebine ire jetwisi. ");
INSERT INTO bon_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tabe teebibine jejemige egä, “Page ai Oogäräneji Mene te toraca me äbitenige weeme ätecija cabu.” ");
INSERT INTO bon_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Siige, teepi iyeta singi ge teeme mule tääpume, cälu te jitemige, ingle babo miijirage mene täsige teeme tage cabu ca. Piba teemeteme ätemläjinisi egä, “Nää, ai lui Yoosepa me bägrä gyene?” ");
INSERT INTO bon_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu piba teebibine jejemige egä, “Cane umle gäne weene singi cebine mime sasa mene jajime egä, ‘Dokta maane määmämu miiji me äbiti!’ Weene cuta singi cebine jajime egä, ‘Cine mene nitecijinige egä maane ciitaca mule ne Kaprenauma cewe cabu tewenemumete. Maane peei bine ama jewenemi määmerage cewe cabu!’ ");
INSERT INTO bon_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cane weebibine jijenininine egä ngänu gyene nuuja cewe biname cina mename biname tääpume singi, teemerage cewe biname cina teeme mene lica jaacatusi. ");
INSERT INTO bon_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yoo, weene mename biname Eliya me padare poto cidi me ngene jotwananineye. Puga ngupe te lica seciruji nesae kämäge cebo cama, piiyepu gane te täduji iyeta poto ta. Cane weebibine jijenininine egä cuubla bucurage ge pui padare Israela gawe cabu, ");
INSERT INTO bon_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yepä Acejiyame te lica Eliya ne jityepuji teeme yepä ne ätityerame. Eewe, Acejiyame teebine jityepuji Sidona gawe cabu, Sarepata cewe me, puga tabe yepä cuubla ne utityäruji. ");
INSERT INTO bon_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yoo, weene ngene jotwananineye cuta nuuja mename biname Elisa me padare poto cidi me. Piba puga ge Israela gawe cabu bucurage biname niiyarage tääpe pita cama, yepä lica teeme yepä te miiji ne jepänuji, yepä Nacamano lui Suriya gawe biname ge, tabe taatu miiji ne jepänuji. Yoo, pui sasa mename biname cina ätrunga ne jepänäsi nuuja gawe cabu, yepä lica teeme Israela biname bime bau ca.” ");
INSERT INTO bon_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pui abasecretna biname cina liba Yeesu me mene itecijemige, baborage claabe te teebibine joomlemige. ");
INSERT INTO bon_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Teepi abujänginisi, teebine iyecräjisi cewe cabu ca, ecanisi pui podo papa cabu, teeme cewe lui podo wajwa cabu jage, siige teepi singi teebine puma cita ca ajarame, ");
INSERT INTO bon_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","yepä Yeesu teeme ngalebora ädige, siige ebmalemige teebibine. ");
INSERT INTO bon_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yeesu puma cita ca Kaprenauma cewe me ädige, lui gyene Galilaya Probins ngalebora. Tabe biname bine ebiberäjemige Sabade bimu cabu. ");
INSERT INTO bon_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Teepi iyeta mutäcäco äbitininisi teeme abiberäja mene name pi, ingle teeme mene kokre piiyepu conocäco cama ge. ");
INSERT INTO bon_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Abasecretna mete cabu puga ge yepä biname niiya cable te lui ne yaacananuge. Tabe babo tage ca jejige egä, ");
INSERT INTO bon_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yeesu Nasareta ceweyame, maane singi ngena wawename cime tääpume? Maane cibibine sabe wawename? Cane umle gäne maane laasi näte: maane lui Acejiyame me conocäcorage Bägrä gäte!” ");
INSERT INTO bon_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu niiya cable ne kokre cama jejige egä, “Maane bojä naagege. Tasati teeme trupa cabu ca!” Niiya cable te pui biname ne gawe cabu ijarige, iyeta biname bime opo gaabe piba tasatige teeme cabu ca, yepä teebine lica nuuja niiya jewenige. ");
INSERT INTO bon_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyeta peei biname mutäcäco äbitininisi, siige teemeteme ätemläjinisi egä, “Ai lipu mene gyene? Teeme conocäco piiyepu kokre pisi nyene niiya cable bine mene jajime, siige teepi täsige!” ");
INSERT INTO bon_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Siige, teeme poto cidi me idre ecanisi pui gawe iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeesu piba abasecretna mete ne sebmalige, Simona me mete me ädige. Simona me gite molyege puga ge gebale cama ge. Pita name pi teepi Yeesu ne jejisi teebine ätityerame. ");
INSERT INTO bon_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tabe ädige teeme ute puupu gome jeclajutige, teeme gebale pita ne jejige teeme bau ca äyeblingtame. Siige, pita te obmalige teebine, tabe piba taatu abujängtige, teebibine mogobi jewenemige. ");
INSERT INTO bon_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yoo, bimu äpula ingwe ca, iyeta biname cina teeme pita biname bine sewademisi Yeesu bau me. Tabe ime ecitanige teeme papa cabu, iyeta miiji me jewenemige. ");
INSERT INTO bon_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Niiya cable cina poto pui biname bine sebmalemisi. Teepi babo tage ca jiicemisi egä, “Maane Acejiyame me Bägrä gäte!” Yeesu teebibine bojä jewenemige, ingle teepi umle ge egä tabe Keriso sine, Israela biname cina lui ne jewagrijenisi teebibine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baani liba siplige, Yeesu pui cewe ne sebmalige, ädige biname cäco cewe me. Siige, biname cina gije abacitinisi teebine ärngime, siige liba jepänisi, jejisi egä, “Gone cibibine nibmalininute!” ");
INSERT INTO bon_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yepä, tabe jejemige egä, “Ai Miiji Mene Acejiyame te biname bine Waadena poto cidi me, cane miiji cuta nuuja cewe maramara cabu jajanena, ingle Acejiyame peei tääpume cebine itu nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Piba Yeesu biname bine mene jejananemige teeme maramara abasecretna mete cabu Yuudea gawe iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nuuja taje Yeesu liba Genesareta Sawa ligi je jeclajutige, biname cina seclige, teebine jewaclomtisi, teeme mameta me ätyepecäjininisi Acejiyame me mene teeme bau ca ätecijame. ");
INSERT INTO bon_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tabe piba neeneni poo bine jääpänige doro cabu, cibu bade biname lui bine aabmalisi net äcisejame. ");
INSERT INTO bon_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yeesu piba acenutige yepä pui poo cabu, pui lui Simona me poo ge, siige teebine itemlige poo ne matikolä atyepeitame niiye cabu me. Yeesu poo cabu adnatige, piiyepu puma cita ca biname bine cängena ebiberäjemige. ");
INSERT INTO bon_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tabe liba mene jajanena siige, Simona ne jejige egä, “Piiyeme ai poo ne jewetänti uugle niiye cabu me. Weeme net bine niiye bora icranemeye cibu oomläjecame.” ");
INSERT INTO bon_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona piba teebine jejige egä, “Babo biname, cine ciiye baborage kaakesea jewenisi ngälu sewalige, piiyepu nuuja cibu bine lica joomlemisi, yepä määme mene name pi, cane net bine icranenenine.” ");
INSERT INTO bon_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Teepi peei jewenisi, piba bucurage cibu bine joomläjemisi, net te mameta ädereca cibu mäpu name pi. ");
INSERT INTO bon_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Teepi teeme cibubade binamewale nuuja poo cabu ca ime ca tewenemisi, teebibine ätityerame. Teepi aaclige, piba neeneni poo bine cibu ca gigri jäängärisi ngälu poo cina mameta abuma. ");
INSERT INTO bon_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yoo, Simona Peteru liba peei mule ne jepänige, kokorare ääpednutige Yeesu gome, teebine jejige egä, “Yageyame, cäme bau ca äyeblingti, ingle cane conocono mule biname gäne!” ");
INSERT INTO bon_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tabe peei mene jiicige, ingle tabe teeme biname cama iyeta mutäcäco äbitininisi cibu lipu bucurage jepänemisi. ");
INSERT INTO bon_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cuta teeme nuuja cibubade binamewale Yakobu piiyepu Yoane, Jebedayo me bägrä, teepi cuta mutäcäco äbitäsi. Yeesu piba Simona ne jejige egä, “Wälu gone! Weene ingwe ca lica cibu bine joomlemuye, yepä biname bine pa joomlemepeye cäme bau waadename.” ");
INSERT INTO bon_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Teepi poo neeneni aatecwamtisi doro cabu, piba iyeta gwidape sebmalemisi Yeesu cama otnime. ");
INSERT INTO bon_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nuuja taje Yeesu liba yepä cewe cabu jage, biname puga ge lepera pita cama. Tabe liba Yeesu ne jepänige, teemämu gawe cabu ajarige Yeesu gome, teebine itinärige egä, “Babo biname, maane liba singi gäte, maane miiji gäte cebine pita cäco me wawena!” ");
INSERT INTO bon_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu ime uutige, teebine joomlige, jejige egä, “Yoo, cane singi gäne. Maane pita cäco äbiti!” Piba taatu pui lepera pita te teebine ebmalige. ");
INSERT INTO bon_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu piba teebine kokre cama jejige egä, “Gone nuuja biname bine ai poto cidi me jaajananemute, yepä maane conocäco ädi iiwäreja biname bau me, tabe meebine ire pa naatwanäjepi egä maane miiji gäte. Piba määme owecu gwidape teebine ecäri tabe Acejiyame ne iiwärejame, Moose lipu mule ne ebiberäjemuji. Peei ne jewenepi, piba biname cina umle pa läbitipesi egä määme pita siige.” ");
INSERT INTO bon_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yepä, Yeesu poto cidi me idre ecananisi iyeta poto ta. Bucurage biname cina piba teeme bau me saacluge teeme mene ätecijame piiyepu teeme maramara pita cabu ca miiji me äbitame. ");
INSERT INTO bon_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yepä, tabe liba padare bine jääpänanemuge, piba biname cäco cewe me waatnetnäjuge Acejiyame ne puma awejename. ");
INSERT INTO bon_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nuuja bimu Yeesu liba biname bine ebiberäjemige, poto Parisea sigu biname piiyepu poto cotre abiberäja biname puga adnatäreji ge. Teepi ituge abasecretna iyeta cewe Galilaya Probins cabu ca piiyepu Yuudea Probins cabu ca cuta poto lui babo cewe Yerusalema ca. Siige, mime Yageyame me kokre puga ge pita biname bine miiji me wawenecame. ");
INSERT INTO bon_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yoo, poto biname cina piba waaku cabu secanisi biname ne lui me tääpe nuuja poto budre ge. Teepi liga teebine ecanisi mete ngalebora Yeesu me opo gaabe je acitame, ");
INSERT INTO bon_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","biname ca mete tapanige, peei name pi äblicäco teebine äsinglenta piiyeme. Yoo, teepi piba teebine ecanisi mete toro cabu me, puma bora cängena jewenisi, teebine waaku cabu puma cita ca siyinisi mete bora biname tomi ngalebora me, Yeesu me opo gaabe je ecitisi. ");
INSERT INTO bon_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yoo, Yeesu liba jepänemige egä teepi baborage ätrunga cama gemi, piba tääpe nuuja poto budre biname ne jejige egä, “Cäme biname, maane kälyä gäte määme niiyaniya mule cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Siige, pui Parisea sigu biname piiyepu cotre abiberäja biname cina teemeteme ätemläjinisi egä, “Luma cita ca gyene ai biname, lui te Acejiyame me ngii pepu jiseblecäjenige? Nuuja biname te ibibi lica ge biname bime niiya mule äyeblengame, yepä Acejiyame taatu ibibi gyene peei ne wawename.” ");
INSERT INTO bon_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeesu teeme ngene atwanena umle äbitige, teebibine jejemige egä, “Weene ngeno me pepu ngene jotwananiniye weeme ngenecu bora je? ");
INSERT INTO bon_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lui gyene plowa iicana ai pita biname ne jajime egä, ‘Maane kälyä gate määme niiya mule cabu ca,’ coo ‘Arpinanti, abujängti, siige ädi’? ");
INSERT INTO bon_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cane weeme tääpume aboclomtenine egä cane lui Acejiyame bau ca tädujine biname me äbitujine, cäme conocäco pisi nyene ai gawecewe cabu biname bime niiya mule äyeblengame.” Tabe piba pui tääpe nuuja poto budre biname ne jejige egä, “Cane meebine naajenine, abujängti, määme waaku ne ecati, mete me ädi!” ");
INSERT INTO bon_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Piba taatu peei biname te iyeta biname bime opo gaabe abujängtige, teeme waaku ne ecatige, gege cama mete me ädige. Tabe Acejiyame ne ewepyeräjenige. ");
INSERT INTO bon_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Biname iyeta mutäcäco äbitininisi. Wälu cama teepi Acejiyame ne ewepyeräjisi egä, “Mararage ciitaca mule ne cine page bii jepänisi.” ");
INSERT INTO bon_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Peei mule ingwe ca Yeesu asatige sawa ligi me, puga babo gaabe gome yepä täks rarekaake uutecrena biname ne jepänige, ngii Leebi. Tabe adnatäneji ge kaakesea puupu cabu. Yeesu teebine jejige egä, “Tädi cane cama otnime.” ");
INSERT INTO bon_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Piba Leebi abujängtige, teeme kaakesea iyeta gwidape cama ebmalemige Yeesu cama otnime. ");
INSERT INTO bon_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Siige, Leebi babo soriyomu jewenige Yeesu tääpume. Bucurage täks rarekaake uutecrena biname piiyepu nuuja biname cina puga ten cama deedei äbitininisi. ");
INSERT INTO bon_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Puma cita ca poto Parisea sigu biname piiyepu cotre abiberäja biname lui cina teeme yepä sigu cabu, teepi Yeesu me abiberäja bägrä bine jejemisi egä, “Weene ngeno me deedei äbitinininiye täks rarekaake uutecrena biname piiyepu cotre atropengäja biname cama?” ");
INSERT INTO bon_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu pui mene itecijige, teebibine jejemige egä, “Biname lui cina miiji birige, teepi singi lica dokta tääpume, yepä biname lui cina pita cama birige, teepi singi dokta tääpume. ");
INSERT INTO bon_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yoo, cane lica tädujine biname bine ala asoglecame lui cina apu jaangemuge, egä teepi conocäco biname gemi, yepä cane conocono biname bine ala asoglecame tädujine teeme ngenecu atatrongärame Acejiyame bau me. ");
INSERT INTO bon_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Poto biname cina Yeesu ne mene jejisi egä, “Yoane niiye ca äciseja biname me abiberäja bägrä cina deedei ärwäja cäco yaacrajuge poto bimu cabu Acejiyame ne awejename, piiyepu Parisea sigu biname bime abiberäja bägrä cina cuta peei yepä mule ne jaawenusi, yepä määme abiberäja bägrä cina deedei yäärwäjimusi iyeta bimu gaabegabe.” ");
INSERT INTO bon_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu teebibine jejemige egä, “Yoo, Atejäclmuta soriyomu ne liba yaaclitusi, mamye rooriye me binamewale cina deedei ärwäja cäco lica yaacrajuge. ");
INSERT INTO bon_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yepä, padare te pa tatyaramtepi liba mamye rooriye ne pa yaacatepesi. Teepi piba pa yaacrajemepi deedei ärwäja cäco. ");
INSERT INTO bon_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeesu ngene ca agli mene jejemige, neeneni mule bine aaboclomtige. Tabe jejemige egä, “Biname te licarage pläsu ne yääderäruge kirece cäbletääpe cabu ca sasa cäbletääpe bora cabu acitame, ingle peei mule te neeneni cäbletääpe bine sabe jaawenuge: kirece cäbletääpe piba äderera birige, piiyepu sasa cäbletääpe miiji opo lica birige kirecerage pläsu cama.” Yeesu pepu jejemige, naace popi tabe singi biname cina umle äbitame egä teepi liba singi Acejiyame me kirece mule ne oomlaname, teepi piba äblicäco sasa saarewale bime mule bine äcwetna. ");
INSERT INTO bon_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tabe piba jejemige egä, “Piiyepu nuuja te kirece waina niiye ne lica yaapaduruge gouti tääpe ca wawenäneji sasa ängära gwidape cabu. Tabe liba yaapaduruge, kirece waina niiye teeme kokre te sasa tääpe ca wawenäneji gwidape ne yääpluge, ingle tuutnecuge. Siige, waina niiye te lapaduruge gawe me piiyepu ängära gwidape te sabe läbituge. ");
INSERT INTO bon_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eewe! Umle biname te kirece waina niiye kirece tääpe cabu jäängäruge. ");
INSERT INTO bon_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yoo, nuuja biname te lica kirece waina niiye tääpume singi, tabe liba sasa ne yaapicnantuge, yepä jiicuge egä, ‘Sasa lui miijirage gyene.’” Siige, Yeesu peei mene biname bine jejemige aboclomtame egä biname cina singi lica sasa mule ne abmalame kirece mule tääpume. ");
INSERT INTO bon_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Israela biname bime Sabade bimu cabu Yeesu teeme abiberäja bägrä cama wiiti calwacupi ngalebora gaabe cabu ädige. Teeme otni cabu abiberäja bägrä cina wiiti mope bine ecrecimisi, ime ca mälwä bine jimlecäjemisi, kuu taatu bine erwäjemisi, gaabe cabu otnetneja biname bime mule lipu ge. ");
INSERT INTO bon_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Poto Parisea biname cina piba abiberäja bägrä bine jejemisi egä, “Weene ngena ne jeweniye? Mime cotre pisi nyene pepu kaakesea wawena Sabade bimu cabu!” ");
INSERT INTO bon_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeesu teebibine jejemige egä, “Nää, weene lica mene ituge acnema Daawida teeme biname cama ngena itu jewenuji, teepi liba loolomecewe icrajuji? ");
INSERT INTO bon_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tabe Acejiyame me iiwäreja mete me abacituji, buluduu ne ecatuji, lui Acejiyame tääpume iiwäräneji ge, peei ne erwuji, piiyepu lui biname ten cama teebibine ecäremuji teeme deedei tääpume. Yoo, mime tääpume cotre gyene buluduu puma cita ca acata loolo me, yepä iiwäreja biname taatu peei bine yäärwäjimusi.” ");
INSERT INTO bon_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Siige, Yeesu piba jejemige egä, “Yoo, cane lui Acejiyame bau ca tädujine biname me äbitujine, cane Yageyame gäne Sabade bimu tääpume. Cäme conocäco pisi nyene jajime ai bimu cabu ngena wawename.” ");
INSERT INTO bon_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cuta nuuja taje Sabade bimu cabu, Yeesu abasecretna mete me abacitige biname bine ebiberäjemige. Biname puga ge lui me camu poto ime duudemu ge. ");
INSERT INTO bon_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Poto cotre abiberäja biname piiyepu Parisea sigu biname cina singi ingle ne päpäname Yeesu ne aitnejame. Teepi peei name pi Yeesu ne cängena ire jetwisi egä tabe pama pui biname ne miiji me jewenige Sabade bimu cabu. ");
INSERT INTO bon_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yepä, Yeesu teeme ngene atwanena umle ge, pui biname lui me ime duudemu ge, teebine jejige egä, “Abujängti, tädi aima niinäce gaabe me.” Puma cita ca pui biname te abujängtige, Yeesu gome jeclajutige. ");
INSERT INTO bon_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yeesu piba teebibine jejemige egä, “Yoo, cäme ätemla pisi nyene weeme tääpume. Cotre mene te lipu jiicenige, mine ngena miiji ge wawena Sabade bimu cabu: biname ne miiji wawena, coo biname ne niiya wawena? Biname ne ätityera ireclotame, coo biname me ireclota ne sabe wawena?” ");
INSERT INTO bon_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tabe iyeta biname bine cängena ire jetwemige, piba peei ime duudemu biname ne jejige egä, “Määme ime tuuti.” Tabe pepu jewenige, siige teeme ime te miiji me äbitige. ");
INSERT INTO bon_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yepä, pui cotre abiberäja biname piiyepu Parisea sigu biname teepi iyeta mage claabe te joomlemige, teemeteme ätemläjinisi egä, “Mine ngena jewenenisi ai biname tääpume?” ");
INSERT INTO bon_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nuuja taje Yeesu podo cabu me jegelige irecu ätumutame. ");
INSERT INTO bon_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tabe iyeta pui ciiye puma enajige Acejiyame bau irecu ätumutanige. Bimu te liba tacitige, tabe teeme abiberäja bägrä bine ala tesoglecmige teeme bau otnime, piba twelb bine jejäcremige pui tomi cabu ca teeme ätyepäneji biname tääpume äbitame. ");
INSERT INTO bon_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Age tema pui twelb biname: Simona tabe lui ne einige Peteru ca, piiyepu teeme igane Andrea; Yakobu piiyepu Yoane; Pilipo piiyepu Bartoloma; ");
INSERT INTO bon_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo piiyepu Tooma; Yakobu Alapeus me bägrä piiyepu Simona, lui Kanana sigu biname ge; ");
INSERT INTO bon_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda, lui nuuja Yakobu me bägrä ge, piiyepu Yuuda Isakariyota, lui te Yeesu ne budre tääpume awaba biname äbitige. ");
INSERT INTO bon_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu pui biname cama täinige podo cabu ca, jeclajutige gawe miiji cabu. Bucurage teeme abiberäja bägrä puga ge ten cama, piiyepu bucurage biname lui cina teeme bau me seclige iyeta Yuudea gawe cabu ca, piiyepu babo cewe Yerusalema cabu ca, cuta piiyepu neeneni malu cewe Turo piiyepu Sidona cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Teepi seclige teeme mene ätecijame piiyepu teeme maramara pita cabu ca miiji me äbitame. Lui bine niiyaniya cable cina niiyarage ngene atwanena cama yaawadanemusi, teepi cuta miiji me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yoo, iyeta biname cina singi teebine oomlaname, ingle kokre te teeme cabu ca tasatenige teebibine iyeta miiji me wawename. ");
INSERT INTO bon_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeesu teeme abiberäja bägrä bine ire jetwemige, jejemige egä, “Weene lui owecumete pana inajininige, ngenecu miiji äbitineye, ingle weene Acejiyame me waadena cabu itu yääbäcnepeye. ");
INSERT INTO bon_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Weene lui loolomecewe gemi page, ngenecu miiji äbitineye, ingle weene camuge cirege päpäna. Weene page lui cina ele ingenininige, ngenecu miiji äbitineye, ingle weene ngange gege cama cirege. ");
INSERT INTO bon_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ngenecu miiji äbitineye biname cina liba weebibine jimugetninusi, jigyinusi, jicnecinusi, coo piiyepu weeme ngii sabe jiwenininusi, ai name pi ingle weene cebine nätrunguye, cane lui te Acejiyame bau ca tädujine biname me äbitujine. ");
INSERT INTO bon_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yoo, piba ngenecu miiji me äbitineye piiyepu gege cama uuplatäjineye, ingle miijirage daremu pisi nyene weeme tääpume cabucewe je. Yoo, teepi lui cina weebibine niiya jiwenininusi, teeme kaakesaare cina pepu mule itu tewenenanemumesi Acejiyame me mename biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yepä, weene lui cina dogwe biname pana inajininige page, weene ngenecu mäpu äbitineye, ingle weeme lui plowa pana ireclota ituge päpäna, siige cirege apira. ");
INSERT INTO bon_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Weene lui cina camuge apanininiye page, ngenecu mäpu äbitipeye, ingle weene loolomecewe cirege lenaja. Piiyepu weene lui cina ngange cama inajininige page, weene ngenecu mäpu äbitipeye, ingle weene ele cire ingenitnipi. ");
INSERT INTO bon_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngenecu mäpu me äbitipeye, weene lui bine iyeta biname cina jäje iwepyeräjininusi. Yoo, teeme kaakesaare cina pepu mule itu tewenenanemumesi walya mename biname bime tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yeesu cääri biname bine mene jejemige egä, “Cäme mene piti nemi weeme tääpume lui cina cebine nätecijeniye egä weeme cubuyame bime tääpume singi inajipi. Lui biname cina weebibine jimugetninusi, weene teebibine cuta yäätityeräjemuye. ");
INSERT INTO bon_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lui biname cina weebibine mene ca niiya me jiwenininusi, weene Acejiyame ne yaawejanuye teeme miiji tääpume. Cuta teeme tääpume irecu lätumutinuye lui cina weeme ireclota mäpu me jiwenininusi. ");
INSERT INTO bon_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yoo, biname te liba weeme nuuja ne yoororuge lakace cabu, tabe miiji cuta atatrongta nuuja poto lakace ne ceerame. Biname te liba weeme nuuja me ätrugera gwidape ne yaacatuge, gone teebine iibana cuta soto ne acata. ");
INSERT INTO bon_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lui biname te weebibine liba itinärinuge, weene teeme singi gwidape yääcäruye, piiyepu biname te liba weeme gwidape ne yaacatuge, gone teebine jaajuye peei ne awecnistame. ");
INSERT INTO bon_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yoo, weene singi biname cina ngena wawename weeme tääpume, weene miiji pepu wawena teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Weene gone Acejiyame bau ca miiji daremu ne awagrija, weene liba eei biname bime taatu cabu me singi, lui cina weeme tääpume singi, ingle cuta niiya mule biname cina pepu jaawenemusi. ");
INSERT INTO bon_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Piiyepu gone Acejiyame bau ca miiji daremu ne awagrija, weene liba eei biname bine taatu miiji jaawenemuye lui cina weebibine miiji niwenininuge. Cuta niiya mule biname cina pepu jaawenemusi. ");
INSERT INTO bon_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Piiyepu gone Acejiyame bau ca miiji daremu ne awagrija, weene liba eei biname bine taatu gwidape watawata yääcäremuye lui cina weebibine gwidape pagege awecnista. Cuta niiya mule biname cina teeme gwidape nuuja niiya mule biname bine yääcäremusi, teepi liba yepä pana gwidape teeme bau ca pagege päpäna. ");
INSERT INTO bon_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pepu mule lica ge ibibi, yepä weene weeme cubuyame bime tääpume singi inajipi, teebibine miiji jaawenemuye, piiyepu gwidape liba watawata yääcäremuye biname bine, gone awagrija peei awecnista tääpume. Acejiyame te piba weebibine babo daremu cire icäripi, piiyepu Caburage Acejiyame me bägrä pagege weene lenaja. Ingle tabe cuta niiya mule biname bine owecu jaawenemuge, piiyepu eei bine lui cina eso mene umle cäco iicana. ");
INSERT INTO bon_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yoo, weene iyeta biname bine epu pana owecu jaawenemuye, mime Babe Cabu je biname bine owecu lipu jewenininige.” ");
INSERT INTO bon_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Weene gone biname bine jaatranemuye, piba Acejiyame weebibine lica cirege atrana; gone singi nuuja biname te mäpu daremu ne päpäname, piba Acejiyame weebibine lica mäpu daremu cirege ceera. Nuuja biname bime niiya mule bine weeme ngene atwanena cabu ca yääyecräjemuye, piba Acejiyame weeme niiya mule bine cirege äyecreja. ");
INSERT INTO bon_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nuuja biname bine gwidape yääcäremuye, piba Acejiyame weebibine gwidape pa icäripi. Yoo, tabe bucurage ätityera weebibine pa icäripi. Epu pana diiba te deedei ca lipu tapanuge, weeme ime ibibi lica birige iyeta teeme miiji oomlana, weeme ireclota cuta pa tapanepi teeme miiji ca. Yoo, weene liba nuuja biname ne matimati yäätityäruye coo baborage yäätityäruye, Acejiyame te yepä ibi weebibine pagege ätityera.” ");
INSERT INTO bon_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu cuta ngene ca agli mene jiicige egä, “Yepä, irecu määsumäsu biname te äblicäco nuuja irecu määsumäsu biname ne gaabe cabu awecluja. Tabe liba peei ne jaawenuge, siige teepi iyeta cäsu cabu me laatramuge. ");
INSERT INTO bon_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yoo, abiberäja bägrä te lica ge baborage teeme abiberäja biname cabu ca, yepä iyeta abiberäja bägrä lui cina iyeta cängena labiberäjininusi, piba teepi teeme abiberäja biname pana pagege äbita. ");
INSERT INTO bon_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Weene ngeno me singi matikolä conocono weeme nuuja biname me ireclota cabu päpäname, yepä baborage conocono weeme ireclota cabu weene lica päpäna? ");
INSERT INTO bon_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Peei lui epu pana määme irecu cabu baborage uli pargi liba pisi nyene piiyepu maane liba määme biname ne jaji egä, ‘Cäme biname, cane määme irecu cabu ca pläpu ne jaacatene!’ Weene walya biname gemi! Weene miiji niinäce uli pargi ne weeme irecu cabu ca acata, piba weene cängenarage jepäneniye weeme biname me irecu cabu ca pläpu ne acatame.” ");
INSERT INTO bon_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yeesu piba jiicige egä, “Miijirage uli te lica yääyuge niiyarage kuu cama; cuta piiyepu niiyarage uli te lica miijirage kuu cama yääyuge. ");
INSERT INTO bon_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yoo, weene iyeta uli bine opo yaawatnemuye teeme kuu cabu ca: weene äblicäco miijirage kuu epu piigi kuu bine äwäcuta gaalegale seea cabu ca, coo waina kuu bine äwäcuta käkäco mete cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yoo pepu pana gemi, biname lui me miijimiji ngene atwanena teeme ngenecu bora piti nemi, teeme mule piiyepu teeme mene cuta miijirage gemi. Yepä, biname lui me niiyaniya ngene atwanena teeme ngenecu bora piti nemi, teeme mule piiyepu teeme mene cuta niiyarage gemi. Ingle biname bime tage cabu ca lui mene cina täsuge, peei lui teeme ngenecu bora cabu ca saacluge.” ");
INSERT INTO bon_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yeesu cuta jejemige egä, “Weene ngenome cebine nainuye ‘Yageyame’ ca, yepä cäme singi mene lica jaawenuye? ");
INSERT INTO bon_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yoo, iyeta biname lui cina cäme bau me saacluge, cäme mene yäätecijemuge, piba cuta yaacatusi ibi wawename, ");
INSERT INTO bon_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","teepi lui epu pana biname liiyepu lui te miijirage mete ne erangige. Tabe gawe ngalebora me juurige kula luma birige, piba cängena caage bine jermecimige, mete ne peei cabu erangige. Siige, igi te tädige, pui mete ne irmitige, yepä lica apinicige, ingle kokrerage caage cabu rarangäneji ge. ");
INSERT INTO bon_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yepä, lui biname te cäme mene papa yäätecijuge, yepä lica jaawenuge, tabe lui epu pana biname liiyepu lui te caage bine tumerage je jermecimige, cuta peei cabu mete ne erangige. Igi liba tädige, pui mete ne ijarige, mete te itramige, siige iyeta sabe äbitige.” ");
INSERT INTO bon_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeesu liba iyeta peei mene epiremige biname bine jajanename, piba tabe Kaprenauma cewe me abacitige. ");
INSERT INTO bon_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pui cewe cabu puga ge yepä Rooma cabu ca cubu mope biname. Teeme ngenecurage kaakesea bägrä baborage pita cama ge budre mameta. ");
INSERT INTO bon_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pui Rooma cubu mope biname te liba mene itecijige Yeesu poto cidi me, tabe poto Israela modamoda biname bine Yeesu bau me jityepemige teebine ätemlame teeme kaakesea bägrä ne miiji wawename. ");
INSERT INTO bon_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pui Israela modamoda biname cina seclige, Yeesu ne owecu cama itineräjisi egä, “Maane miiji teebine ätityerame, ingle tabe miiji biname gyene. ");
INSERT INTO bon_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tabe babo owecu mime biname bime tääpume, piiyepu cime abasecretna mete ne eranguji teeme rarekaake ca.” ");
INSERT INTO bon_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yoo, Yeesu piba ten cama ädige. Tabe teeme mete mameta me liba atyaramtige, piba pui Rooma cubu mope biname te poto teeme binamewale bine tityepemige Yeesu bau me mene cama egä, “Babo Biname, gone mäpu me läbitute cäme tääpume. Cane ibibi lica gäne maane abacitame cäme mete me, ");
INSERT INTO bon_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","peei name pi cane lica otni määme opo gaabe me. Maane mene taatu jiici, piba cäme kaakesea bägrä te miiji pa läbitege. ");
INSERT INTO bon_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yoo, cane umle gäne mene lipu kokre gyene. Cane miiji cäme babo biname bime mene ätecija, piiyepu cäme ire atwi cabu piti nemi cubu biname. Cane yepä ne jaajune, ‘Ädi,’ siige tabe läduge; cane nuuja ne jaajune, ‘Tädi,’ siige tabe täduge. Cane cäme kaakesea bägrä ne jaajune, ‘Ai jeweni,’ siige tabe peei ne jaawenuge. Peei name pi cane umle gäne egä määme mene cabu kokre pisi nyene.” ");
INSERT INTO bon_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yeesu mutäcäco äbitige, pui mene liba itecijige. Tabe ingwe gaabe me tatadrongtige, ten cama lui biname cina seclige, teebibine jejemige egä, “Cane weebibine jijenininine egä apu baborage ätrunga ne cane lica ituge päpäna Israela biname bime cabu ca, yepä ai biname cabu taatu jepänine.” ");
INSERT INTO bon_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pui mename biname cina liba äcnärige Rooma cubu mope biname me mete me, siige teepi pui kaakesea bägrä ne miiji jepänisi. ");
INSERT INTO bon_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Peei ingwe ca Yeesu ädige yepä matikolä cewe me, ngii Naina. Teeme abiberäja bägrä piiyepu bucurage nuuja biname cina ten cama eclige. ");
INSERT INTO bon_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tabe liba pui cewe grana gome atyaramtige, biname cina yepä budre biname ne secanisi cewe cabu ca. Tabe mamye biname ge, teeme mage me japurage imäbägrä; cuta mage lui cuubla ge. Bucurage pui cewe biname cina ten cama seclige. ");
INSERT INTO bon_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yageyame liba teebine jopänige, tabe baborage owecu äbitige teeme tääpume, jojige egä, “Ele gone!” ");
INSERT INTO bon_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tabe piba awetäntige, budre biname me keeso kaake ne joomlige. Pui keeso acana biname cina piba imyemutemige, siige Yeesu pui budre biname ne jejige egä, “Mamye biname, cane meebine naajenine arpinanti!” ");
INSERT INTO bon_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Siige, pui budre biname te arpinantige, piba gije abacitige mene me. Yeesu teeme mage ne ocärige. ");
INSERT INTO bon_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iyeta biname cina wälu me äbitininisi, Acejiyame ne ewepyeräjisi egä, “Acejiyame me baborage mename biname te mime bau me tädige!” Teepi cuta jiicisi egä, “Acejiyame bii tädige teeme biname bine ätityerame.” ");
INSERT INTO bon_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yeesu ne idre jecenanisi Yuudea gawe iyeta poto ta piiyepu cuta poto gawe mameta cabu ta. ");
INSERT INTO bon_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoane iyeta peei mule poto cidi me itecijige teeme äbiberäja bägrä bime bau ca. Tabe piba ala taasoglicige teeme neeneni abiberäja bägrä, ");
INSERT INTO bon_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","teebibine Yageyame bau me jäätyepige, teebine ätemlame egä, “Nää, maane säte pui biname, iyeta biname cina lui ne jewagrijenisi otnime, coo cine miiji nuuja ne awagrija?” ");
INSERT INTO bon_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pui neeneni biname cina Yeesu bau me liba atyaramtäsi, jejäsi egä, “Yoane niiye ca äciseja biname te cibibine määme bau me nityepige meebine ätemlame egä, ‘Nää, maane säte pui biname, iyeta biname cina lui ne jewagrijenisi otnime, coo cine pama miiji nuuja ne awagrija?” ");
INSERT INTO bon_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Puirage padare cabu Yeesu bucurage biname bine miiji me jewenemige maramara pita cabu ca, piiyepu niiya cable bine iyecräjemige, piiyepu bucurage irecu määsumäsu biname bine miiji me jewenemige. ");
INSERT INTO bon_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pui neeneni biname lui Yoane bau ca tabe teebibine mene jaawecnistige egä, “Weene Yoane bau me acne-nuteye, teebine jejepeye weene ngena ituge päpäna piiyepu ätecija naace irecu määsumäsu biname cina cängena jääpänanemusi; ernge niiyaniya biname cina miiji waatninusi; lepera pita biname cina miiji me läbitininusi; tablame buduma biname cina cängena yäätecijanemuge; budre biname cina larpineräjininusi ireclota me; cuta piiyepu owecumete biname bine Miiji Mene jaajananemusi. ");
INSERT INTO bon_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yoo, ngenecu miiji eei gemi laati bemi ätrunga ne lica yaapesarusi cäme bau.” ");
INSERT INTO bon_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pui biname Yoane bau ca liba acnenutäsi teeme bau me, Yeesu gije abacitige biname bine mene Yoane poto cidi me jajanename. Tabe teebibine itemlemige egä, “Weene liba daapo taatu cewe me läsipeye, weene singi puma ngena päpäname? Weene lica otni duuwe baace päpäname buuwe te papa yaacenanuge. ");
INSERT INTO bon_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Liba peei lica, weene ngena päpäname läsipeye peeyeme? Weene lica otni biname ne päpäname, lui te labasogäruge miijimiji cäbletääpe cama, ingle pepu pana biname cina modamoda biname bime mete cabu yaacrajuge luma miijimiji gwidape birige. ");
INSERT INTO bon_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cebine najeye, weene ngena päpäname läsipeye peeyeme? Weene nää Acejiyame me mename biname ne singi päpäname? Yoo, cane weebibine jijenininine egä weene baborage mename biname ne puga ituge päpäna. ");
INSERT INTO bon_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Oogäräneji Mene cabu Acejiyame te Yoane poto cidi me jiicenige egä, ‘Cane cäme mename biname ne määme niinäce gaabe me cire jäätyepepene. Tabe te gaabe cire yaamacetnäjepi määme otni tääpume.’” ");
INSERT INTO bon_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeesu piba jejemige, “Cane weebibine jijenininine egä Yoane lui baborage gyene iyeta ai gawecewe biname bime cabu ca lui cina ituge ai gawecewe cabu lenaja ngälu Yoane me padare oomlaname, yepä page ai kirece padare cabu, eei cabu ca lui te matikäli gyene Acejiyame te lui bine ewadenemige, tabe baborage gyene Yoane cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yoo, iyeta biname piiyepu cuta täks rarekaake uutecrena biname cina liba Yeesu me mene yäätecijemepi, piba jiicepesi egä, “Acejiyame me gaabe toraca conocäco gyene,” siige teepi peei name pi äciseja mule ne ituge acatena Yoane bau ca. ");
INSERT INTO bon_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yepä, Parisea sigu biname piiyepu cotre abiberäja biname cina Yoane me äciseja mule ne jäägyusi, pepu pi teepi cuta Acejiyame me teeme tääpume singi gaabe ne jäägyusi. ");
INSERT INTO bon_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Siige, Yeesu jiicige egä, “Cane ngena cabu yaatonäremene biname bine page lui cina ireclota gemi? ");
INSERT INTO bon_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Teepi epu pana gemi matimati bägrä liiyepu, lui cina adnatäreji yaacrajuge aletnaletna puupu cabu, siige teemeteme ala abayaninusi egä, ‘Cine dobidobi bine jääcnäjemusi, yepä weene giire lica jääwäjuye. Cine owecumete uupera yaatangusi, yepä weene singi lica ele me.’ ");
INSERT INTO bon_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yoo, Yoane niiye ca äciseja biname te tädepi piiyepu poto bimu deedei cäco yaanajuge piiyepu waina niiye lica yäänäjuge. Weene singi lica teeme mule tääpume, teeme poto cidi me jiicemuye egä, ‘Niiya cable te teebine ecanenige.’ ");
INSERT INTO bon_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cane lui Acejiyame bau ca tädujine biname me äbitujine, cane piba tädepene. Cane deedei läbitune piiyepu niiye yäänäjune, yepä weene cuta singi lica cäme mule tääpume, cäme poto cidi me jiicemuye egä, ‘Jepäneye ai biname ne! Tabe mage looloyame gyene piiyepu waina niiye änäjäyame! Täks rarekaake uutecrena biname piiyepu cotre atropengäja biname teepi lui teeme biname gemi!’ ");
INSERT INTO bon_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yoo, weene pepu jiicemuye, yepä lui biname cina yaacatusi Acejiyame me singi mule bine, teeme ireclota cabu ca mine opo yaawatnusi egä Acejiyame lui umlerage gyene.” ");
INSERT INTO bon_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yepä Parisea sigu biname ngii Simona tabe Yeesu ne ala tesoglicige ten cama deedei äbitame. Yeesu ädige teeme mete me, puga adnatige deedei me. ");
INSERT INTO bon_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Puga ge pui cewe cabu yepä eroero magebi. Tabe liba mene utecijige egä Yeesu deedei äbitenige pui Parisea biname me mete cabu, tabe piba matikolä karpu ne miiji lengo ngedo cama ecatige, peei cama oclige Simona me mete me. ");
INSERT INTO bon_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Puga tabe Yeesu me kaake poto ca joclajutige teeme ernge gome. Tabe ele ongenige piiyepu teeme ele mäcu cina sitrametnemige Yeesu me ernge cabu. Tabe pui ele mäcu bine jicisäjemige, teeme lecaleca edingäli ca, teeme ernge jetecnige, piba pui miiji lengo cama ngedo ne ernge cabu epadurige. ");
INSERT INTO bon_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yoo, pui Parisea biname lui te Yeesu ne ala tesoglicige, tabe liba peei mule ne jepänige, teeme ngenecu bora jiicige Yeesu poto cidi me egä, “Ai biname liba toraca mename biname gyene, tabe piba umle cama gyene ai magebi poto cidi me, lui te teebine joomlemige, egä teeme ireclota lui magerage conocono gyene!” ");
INSERT INTO bon_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Piba Yeesu pui Parisea biname ne jejige egä, “Simona, cane singi gäne meebine matikolä mene jajime.” Simona jejige egä, “Abiberäja biname, ngena mene gyene?” ");
INSERT INTO bon_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yeesu ngene ca agli mene teebine jejige egä, “Neeneni biname cina rarekaake ituge waadena yepä rarekaake ire atwi biname bau ca. Pui yepä biname te faib hanred rarekaake yaawademepi piiyepu nuuja te fifti taatu rarekaake yaawademepi. Yoo, yepä pui rarekaake me ibi lui daremu gyene yepä bimu me kaakesea tääpume. ");
INSERT INTO bon_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Siige, ingwe ca pui neeneni äblicäco ge pui rarekaake awecnistame, peei name pi rarekaake ire atwi biname te teebibine jaajige egä, ‘Ngänu gyene peei bine awecnista. Cane weeme ngii ituge äyeblingta daremu oogäräneji peba cabu ca.’ Yoo, Simona cane meebine näätemlenine egä pui neeneni cabu ca laasi nyene baborage singi pui rarekaake ire atwi biname tääpume?” ");
INSERT INTO bon_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona teebine jejige egä, “Pama pui biname lui me baborage daremu ne ituge äyeblingta.” Yeesu jejige, “Yoo, määme mene toraca gyene.” ");
INSERT INTO bon_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tabe piba pui magebi bau me atatrongärige, Simona ne jejige egä, “Jopäni ai magebi? Cane liba määme mete me abacitine, maane cebine niiye lica näcärite ernge äciseja tääpume, mime mule lipu gyene, yepä ai magebi cäme ernge teeme ele mäcu ca näcisäjige, piba nebo jicisäjige teeme edingäli ca. ");
INSERT INTO bon_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Maane cebine lica natecnite awablame, mime mule liiyepu, yepä cäme abacita cabu ca ai magebi te cäme ernge jäje natecnanige. ");
INSERT INTO bon_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Maane cäme mope olibi migi ca lica napyacite, mime mule liiyepu, yepä tabe te cäme ernge miijimiji ngedo ca bii napyacige. ");
INSERT INTO bon_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cane meebine naajenine egä teeme bucurage conocono mule bine ituge äyeblenga, peei name pi teeme owecu baborage gyene cäme tääpume. Yepä, lui biname me nesae taatu niiya mule ituge äyeblenga, teeme matikolä singi taatu pisi nyene.” ");
INSERT INTO bon_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yeesu puma cita ca magebi ne jojige egä, “Määme niiyaniya mule bine ituge äyeblenga.” ");
INSERT INTO bon_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Piba pui nuuja biname lui cina pui dade gome adnatäreji gemi, teepi teemämu ätemläjinisi egä, “Laasi nyene ai biname lui te cuta biname bime niiyaniya mule bine yääyeblengemuge?” ");
INSERT INTO bon_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yeesu piba magebi ne jojige egä, “Acejiyame te meebine näätityärige määme niiya mule cabu ca asatame, ingle maane cebine nätrungite. Äte, ngenecu poode cama ocli.” ");
INSERT INTO bon_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Peei padare ingwe ca Yeesu modamoda cewe piiyepu matimati cewe cabu ta otnetnäjige, puga Miiji Mene biname bine jejananemige Acejiyame te biname bine waadena poto cidi me. Teeme twelb abiberäja bägrä cina ten cama otninisi. ");
INSERT INTO bon_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuta ten cama puga ge poto magebi, Yeesu lui bine pita cabu ca miiji me itu jaawenemepi piiyepu niiya cable bine itu yääyecräjemepi teeme poto cabu ca. Teeme poto ngii age temi: Yepä lui Mariya, teeme nuuja ngii Magadala tage, Yeesu lui me trupa cabu ca seben niiya cable bine itu yääyecräjemepi. ");
INSERT INTO bon_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nuuja teeme ngii Yoana tage. Tabe lui Kusa me coga gwene, Kusa lui te Mopeyame Heroda me mete piiyepu gwidape bine ire jaatwemuge. Cuta nuuja teeme ngii Susana tage, cuta piiyepu bucurage nuuja magebi cina ten cama puga ge. Teepi Yeesu piiyepu teeme abiberäja bägrä bine yäätityäremusi teemerage rarekaake piiyepu gwidape cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biname cina Yeesu bau me totninisi maramara cewe cabu ca. Liba bucurage biname cina abasecretnige, tabe ai ngene ca agli mene jebaitnemige egä: ");
INSERT INTO bon_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yepä biname te äduji calwacupi me kuu gije bine iisabejame. Egäcäro tabe kuu bine gweeti cabu yiisabäjemige, poto cina gaabe cabu itrametnemige. Puga biname cina kuu bine jibrecäjemisi piiyepu ele cina erwäjemisi. ");
INSERT INTO bon_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Poto kuu cina itrametnemige kula gawe cabu. Kuu cabu ca gije liba tuupletnärige, teepi maaje me äbitininisi, ingle pui kula gawe cabu niiye lica ge. ");
INSERT INTO bon_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Poto kuu cina itrametnemige pägepäge mete bora me. Pägepäge cina gije cama uutinisi, siige gije bine jetäyemisi. ");
INSERT INTO bon_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Poto kuu cina itrametnemige miijirage gawe cabu. Pui cabu ca gije cina tuupletnärige, uutinisi, kuu jepänemisi, nuuja cina yepä hanred kuu jepänemisi.” Yeesu peei mene jejemige, piba babo tage ca jiicige egä, “Weeme liba tablame piti nemi ätecijame, itecijinege umle äbitame!” ");
INSERT INTO bon_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ingwe ca Yeesu me abiberäja bägrä cina teebine itemlisi pui ngene ca agli mene me aboclomta poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yeesu teebibine jejemige egä, “Lui umle niinäce aboclomtäneji lica ge, egä Acejiyame te lipu biname bine waadena, weebibine umle ituge ceera. Yepä nuuja biname bime bau me cane ngene ca agli mene ca jiicune, ai name pi ‘puu ire acita cabu, teepi lica jääpänusi, piiyepu puu ätecija cabu, teepi lica umle läbitininusi.’” ");
INSERT INTO bon_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yeesu abiberäja bägrä bine jejemige egä, “Cane kuu gije iisabeja poto cidi me mene ne eboclomtenine: Pui kuu lui epu pana Acejiyame me mene liiyepu. ");
INSERT INTO bon_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lui kuu cina gaabe cabu itrametnemige, pui gawe epu pana biname lui cina Miiji Mene yäätecijemuge, yepä Satani te läduge, pui mene ne wata yääyeblingtuge teeme ngenecu bora ca, ingle tabe singi lica ge teepi pui mene ätrungame, piba teeme niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lui kuu cina kula gawe cabu itrametnemige, pui gawe lui epu pana biname liiyepu lui cina Miiji Mene yäätecijemuge, gege cama yaacatusi, yepä epu pana gije me braju te äblicäco kula gawe bora abacitame, pui mene te äblicäco teeme ngenecu bora me abacitame. Matikolä padare teepi jäätrungusi, yepä apicetnära te liba täduge, teepi piba teeme ätrunga ne yaabmalusi. ");
INSERT INTO bon_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lui kuu cina pägepäge mete cabu itrametnemige, pui gawe lui epu pana biname liiyepu lui cina Miiji Mene yäätecijemuge, yepä teeme ngenecu mäpu, coo teeme bucurage gwidape, coo piiyepu teeme singi ai ireclota me gege mule tääpume, peei cina pägepäge seeasea pana Miiji Mene ne jäätäyusi. Peei name pi teeme ireclota cabu pui mene te äblicäco nuuja kuu wawename. ");
INSERT INTO bon_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lui kuu cina miiji gawe cabu itrametnemige, pui gawe lui epu pana biname liiyepu lui cina miijirage piiyepu toraca ngenecu cama Miiji Mene yäätecijemuge, ngenecu cabu cängena joomlusi, piiyepu durau cäco miijimiji mule bine jaawenemusi kuu tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nuuja biname te lampa ne lica jaabotuge, piba diiba ca yäätrugäruge coo yaacituge dade lolebora me. Yepä, tabe lampa ne cabu je yaatecwantuge, piba biname lui cina mete me yääbäcnusi, teepi lampa apaclyera ne jääpänusi. ");
INSERT INTO bon_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pepu pana ge page biname bime bau ca ngena ämlitäneji gyene, pajecu me pagege äbita teeme tääpume, piiyepu lui mule biname cina umle lica gemi page, teepi pagege umle äbita. ");
INSERT INTO bon_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Peei name pi weene cängena ngene jotwananineye lipulipu ätecijame, ingle lui biname me umle pisi nyene, Acejiyame teebine cerämu pa yääcärepi; piiyepu lui biname me umle lica gyene, Acejiyame teeme bau ca pa yaacatepi lui matikäli umle tabe apu angi egä pisi nyene.” ");
INSERT INTO bon_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yeesu me mage piiyepu iganewale cina teeme bau seclige, yepä teepi äblicäco teeme mameta me otni biname tomi name pi. ");
INSERT INTO bon_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yepä biname te Yeesu ne piba jejige egä, “Määme mage piiyepu iganewale mete kaake poto je jeclajutemige. Teepi singi määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeesu piba iyeta biname bine jejemige egä, “Lui cina Acejiyame me mene jäätecijusi piiyepu yaacatusi wawename, teepi cäme tääpume epu pana mage piiyepu iganewale liiyepu.” ");
INSERT INTO bon_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nuuja bimu Yeesu teeme abiberäja bägrä cama acetnärige poo cabu me, teebibine jejemige egä, “Mine sawa ne yuuresi nuuja poto doro me,” siige teepi abyemärinisi. ");
INSERT INTO bon_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Poo te liba niiye cabu ädige, Yeesu ute ogrige. Piba baborage buuwe te tipwäjige sawa cabu. Pui poo cabu uule kuu cina tatacweräjenisi, poo te mameta abuma. ");
INSERT INTO bon_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Puma cita ca Yeesu me abiberäja bägrä cina awetenäjininisi teeme mameta me, teebine elotnantisi ute cabu ca, jejisi egä, “Abiberäja biname, mine labumetninago!” Yeesu abujängtige, buuwe piiyepu uule kuu bine kokre mene ca jiibemige, siige sawa te bulubulu mataru enajige. ");
INSERT INTO bon_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tabe piba teeme abiberäja bägrä bine jejemige egä, “Lese nyene weeme ätrunga?” Teepi wälu piiyepu mutäcäco äbitininisi, siige teemeteme ätemläjinisi egä, “Ai biname tabe laasi nyene? Tabe mene jejemige buuwe piiyepu uule bine, siige teepi jitecijisi teeme mene!” ");
INSERT INTO bon_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Teepi poo cabu eclige ngälu atyarininisi Gerasene biname bime gawe cabu. Pui gawe lui Galilaya sawa nuuja poto doro ca. ");
INSERT INTO bon_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yeesu liba poo cabu ca arpatige doro me, yepä pui cewe biname te opopa eyige ten cama, lui biname ne niiya cable cina yaacananusi. Leca padare cama tabe cäbletääpe cäco waatnetnäjuge, singi lica ge mete cabu lenajame, yepä kula waja cabu yaanajuge, cewe biname cina luma teeme budre biname bine gape yaacranemusi. ");
INSERT INTO bon_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pui biname te Yeesu ne liba jepänige, ala abayige, teeme bau me piba itramige, babo tage ca jejige egä, “Yeesu, maane lui Caburage Acejiyame me Bägrä gäte, maane singi gäte cäme tääpume ngena wawename? Cane meebine naawejanenine, maane cebine gone sabe nawenute!” ");
INSERT INTO bon_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yoo, tabe peei mene jejige, ingle Yeesu niiya cable ne bii jejige asatame peei biname ne abmalame. Yoo, bucurage padare pui niiya cable te pui biname ne joomlananuge, ngänuge tabe ätäyäneji yaanajuge ayana seea teeme ime piiyepu ernge cama, pepu padare cabu tabe ayana seea bine yaagabicmuge, siige cable te piba teebine yaacanuge daapo taatu cewe cabu me. ");
INSERT INTO bon_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yoo, Yeesu teebine itemlige egä, “Maane ngii laasi näte?” Tabe jejige egä, “Cane ngii lui Sange,” ingle bucurage niiya cable teeme trupa cabu yaacrajuge. ");
INSERT INTO bon_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pui cable cina Yeesu ne jejisi egä, “Gone cibibine nityepininute piiyemrage cupicu cabu me. ");
INSERT INTO bon_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Puga ge teeme mameta je baborage ngeerangera blome tomi lui cina podo wajwa cabu deedei tääpume yuunguretnäjemisi. Pui niiya cable cina Yeesu ne jejisi teebibine ätyepame blome bime trupa ngalebora me; siige tabe teebibine piiyeme jityepemige. ");
INSERT INTO bon_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yoo, cable cina pui biname ne ebmalisi, blome cabu me ebäcnisi, siige iyeta pui blome cina podo cabu ca uuwametnige, sawa niiye bora uupletnärige, puga abumitnige, siige. ");
INSERT INTO bon_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pui blome ire atwi biname cina liba peei ne jepänisi, teepi cewe me uuwametnige, idre ne ecanenisi matimati cewe cabu ta piiyepu pui babo cewe cabu me. ");
INSERT INTO bon_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Cewe biname cina äsecrärige pui mule ne päpäname. Teepi liba Yeesu bau me eclige, piba pui niiya cable cama biname ne jepänisi Yeesu gome adnatäneji ge, cäbletääpe asigräneji ge, piiyepu miiji ngene atwanena cama ge. Teepi piba iyeta wälu äbitininisi. ");
INSERT INTO bon_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lui biname cina peei mule ne jepänisi, teepi nuuja biname bine jejemisi Yeesu lipu peei biname ne miiji me jewenige. ");
INSERT INTO bon_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Puma cita ca iyeta pui Gerasene gawe biname cina Yeesu ne jejisi teeme bau ca äyeblingtame, ingle teepi mage wälu gemi. Peei name pi Yeesu poo cabu ca acenutige otnime. ");
INSERT INTO bon_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Piba pui biname, cable cina lui ne ebmalisi, tabe Yeesu ne jejige egä, “Nää, lipu gäne cane maane cama otnime?” Yepä, Yeesu teebine jityepige apu mene cama egä, ");
INSERT INTO bon_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Maane ama. Cewe me acnenuti biname bine jajanename Acejiyame te ngena miiji määme tääpume bii naawenige.” Pui biname te puma cita ca iyeta pui cewe cabu otnetnäjige, biname bine jejananemige Yeesu ngena ne teeme tääpume jewenige. ");
INSERT INTO bon_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeesu liba atyaramtige sawa nuuja poto doro me, biname tomi puga ge teebine jewablisi, ingle teepi iyeta teeme acnenuta tääpume jewagrijenisi. ");
INSERT INTO bon_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Piba biname ngii Yairus te teeme bau me atyaramtige. Tabe lui yepä babo biname gyene pui cewe me abasecretna mete tääpume. Tabe teemämu gawe me ajarige Yeesu me ernge gome, teebine ewejanige teeme mete otnime, ");
INSERT INTO bon_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ingle teeme bägrä mameta ge budre. Teeme lui yepä taatu bägrä, twelb kämäge cama gwe, ngulebägrä gwe. Yoo, Yeesu liba abyemärige Yairus me mete otnime, biname bucurage ge tomi cabu, teepi teebine gaabe cabu jityepecäjisi. ");
INSERT INTO bon_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Puga ge biname tomi cabu yepä magebi lui te uudi apira pita cama ge twelb kämäge ngalebora. Tabe iyeta teeme rarekaake ituge apira dokta bime bau otnetnejame, yepä teepi äblicäco teebine miiji me wawena. ");
INSERT INTO bon_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tabe Yeesu me kaake poto ca toclige, teeme cäbletääpe pepyämu ne joomlige, siige piba taatu ätecitige teeme uudi pita te. ");
INSERT INTO bon_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu biname bine itemlemige egä, “Laati te cebine noomlige?” Iyeta biname cina liba aininisi, Peteru piba jejige egä, “Abiberäja biname, biname piti nemi iyeta poto ta, meebine naawaclomtisi, teepi te iyeta näädudnecäjisi.” ");
INSERT INTO bon_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yepä, Yeesu jiicige egä, “Yepä biname te cebine bii noomlige. Cane asicnantine egä cäme kokre te basatige.” ");
INSERT INTO bon_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pui magebi liba ngene ca beglige egä tabe äblicäco ge ämlita, ngena te teeme tääpume bäbitige, tabe piba aloneca cama oclige, Yeesu me opo gaabe utramige. Tabe piba biname bime sobe cabu teebine jejige ngena name pi teeme cäbletääpe ne joomlige, piiyepu tabe lipu wata miiji me bäbitige. ");
INSERT INTO bon_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu teebine piba jojige egä, “Bägrä, määme ätrunga te meebine miiji bii naawenige. Äte, ngenecu poode cama ocli.” ");
INSERT INTO bon_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Egäcäro Yeesu peei mene jiicige, biname te mene cama tädige pui babo biname me mete cabu ca. Tabe Yairus ne jejige egä, “Määme ngulebägrä te budre gwene. Gone Abiberäja Biname ne papa yaacanute.” ");
INSERT INTO bon_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yepä, Yeesu liba peei mene itecijige, Yairus ne jejige egä, “Wälu gone, yepä cebine nätrungi. Määme ngulebägrä te miiji pa läbitepi.” ");
INSERT INTO bon_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yeesu liba Yairus me mete me atyaramtige, tabe biname bine jiibemige puutucu je, yepä Peteru, Yoane, Yakobu, piiyepu pui ngulebägrä me mage babe taatu ten cama abacitige. ");
INSERT INTO bon_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iyeta biname cina ele engenetnemige pui ngulebägrä tääpume. Yeesu teebibine ele jiibemige, jejemige egä, “Ele gone! Bägrä te budre lica, yepä ute gwene.” ");
INSERT INTO bon_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Teepi teebine ngange ewäcnisi, ingle teepi umle gemi egä peei ngulebägrä toraca budre gwene. ");
INSERT INTO bon_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeesu piba ngulebägrä ne ime gome jwoomlige, babo tage ca jojige egä, “Bägrä, arpinanti!” ");
INSERT INTO bon_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tabe ireclota jepänige, ingle seemo te tacnenutige, siige wata abujängtige. Siige, Yeesu piba teebibine jejemige egä, “Ngulebägrä ne deedei ocäreye!” ");
INSERT INTO bon_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Teeme mage babe cina mutäcäco äbitäsi. Yeesu teebibine jaajige egä, “Gone nuuja biname bine jaajananemuye ai poto cidi me.” ");
INSERT INTO bon_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeesu teeme twelb abiberäja bägrä bine teeme gome tebasecretnemige, teebibine kokre piiyepu conocäco ecäranemige iyeta niiya cable bine äyecrejame piiyepu maramara pita bine äyeblengäjame. ");
INSERT INTO bon_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tabe piba teebibine jityepäjemige Acejiyame te biname bine waadena poto cidi me mene jajanename piiyepu pita biname bine miiji me wawenecame. ");
INSERT INTO bon_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tabe teebibine jejemige egä, “Weene gone nuuja gwidape bine yaawademuye weeme otni tääpume. Gone yaawademuye otnetneja suru piiyepu diiba. Rarekaake piiyepu deedei gone yaawademuye, cuta tuwängle cäbletääpe gone yaawademuye. ");
INSERT INTO bon_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lui biname cina weebibine jiwablininusi, teeme mete cabu inajininuge ngälu weene pui cewe ne saabmaluye. ");
INSERT INTO bon_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Cewe biname cina liba weebibine lica awabla, pui cewe ne liba saabmaluye, tuuwe bine jääglubäjemuye weeme ernge cabu ca. Teepi ai mule cabu ca umle läbitininusi egä teepi pagege niiya daremu ne päpäna.” ");
INSERT INTO bon_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Siige, abiberäja bägrä cina Yeesu ne puga ebmalisi, teepi otnininisi iyeta pui cewe cabu ta, biname bine Miiji Mene jejananemisi piiyepu pita biname bine miiji me jewenanemisi iyeta poto ta. ");
INSERT INTO bon_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yoo, Galilaya probins mope biname Heroda te mene itecijige iyeta Yeesu me waweneca poto cidi me. Pajecu lica ge teeme tääpume ngena cina äbitenininisi, ingle biname bime mene maramara ge. Poto biname cina jiicusi egä, “Pama Yoane pui niiye ca äciseja biname te budre cabu ca tarpinantige!” ");
INSERT INTO bon_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nuuja cina jiicusi egä, “Pama Eliya te taboclomtige.” Piiyepu nuuja cina jiicusi egä, “Pama yepä sasa mename biname te budre cabu ca tarpinantige.” ");
INSERT INTO bon_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroda piba jiicige egä, “Peei lui lica ge Yoane, ingle cane te itu jaajemepene teeme mope ne äläcnutame; tabe budre ge. Peei biname tabe baa laasi nyene, cane lui poto cidi me mene nätecijige?” Tabe peei name pi äbitenige Yeesu ne päpäname. ");
INSERT INTO bon_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yoo, ätyepäneji biname cina täcnärininisi, Yeesu ne jejisi iyeta teepi ngena ituge wawena. Tabe piba teebibine ewademige, siige teepi taatu eclige yepä cewe me, ngii Betesaida, ");
INSERT INTO bon_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","yepä biname cina liba umle äbitininisi, teepi Yeesu ne ingwe icwisi. Tabe iyeta teebibine jewablimige, mene jejananemige Acejiyame te lipu biname bine yaawademuge, piiyepu pita biname bine miiji me jewenemige. ");
INSERT INTO bon_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mämle bimu me liba, teeme twelb abiberäja bägrä cina Yeesu bau me seclige, teebine jejisi egä, “Maane biname bine jityepemi mameta calwacupi cewe me piiyepu maramara cewe me teeme deedei piiyepu ute puupu bine päpäname, ingle biname cäco cewe gyene ai.” ");
INSERT INTO bon_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yepä, Yeesu teebibine jejemige egä, “Weene te teebibine deedei ecäremeye.” Teepi puma cita ca jejisi egä, “Cime nuuja deedei lica gyene, yepä ai faib buluduu piiyepu neeneni bumate cibu taatu gemi. Baa, maane singi cine otni deedei aletname ai bucurage biname tääpume?” ");
INSERT INTO bon_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yoo, puga ge pama faib tausen rooriye, magebi bägrä cama. Yeesu teeme abiberäja bägrä bine piba jejemige egä, “Weene biname bine jejemeye adnaterame maramara tomi cabu, fifti pana biname yepäyepä tomi cabu.” ");
INSERT INTO bon_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Abiberäja bägrä cina pepu jewenemisi Yeesu me singi liiyepu. Iyeta biname cina liba adnatärinisi, ");
INSERT INTO bon_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu piba ewademige pui faib buluduu piiyepu neeneni bumate cibu bine. Tabe cabu me ire acitige, Acejiyame ne eso ecärige, pui deedei cibu bine itrecimige, abiberäja bägrä bine piba ecäremige biname bime bau awadename. ");
INSERT INTO bon_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iyeta biname cina teeme ibi jepänisi liba erwäjisi. Piba abiberäja bägrä cina deedei pacupacu diiba bora ebäcnemisi, siige twelb diiba cina tapanininisi. ");
INSERT INTO bon_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nuuja taje Yeesu liba ten taatu Acejiyame bau irecu ätumutige, piiyepu teeme abiberäja bägrä puga ge teeme gome, tabe piba teebibine itemlemige egä, “Nää, biname cina lipu jiicusi egä cane laasi näne?” ");
INSERT INTO bon_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Teepi jejisi egä, “Poto cina jiicusi egä maane niiye ca äciseja biname Yoane säte. Nuuja cina jiicusi egä maane Eliya säte. Piiyepu nuuja cina jiicusi egä maane yepä sasa mename biname gäte lui te budre cabu ca tarpinantumete.” ");
INSERT INTO bon_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tabe itemlemige egä, “Cije weene, weene lipu jiiceniye egä cane laasi näne?” Peteru jejige teebine egä, “Maane Keriso säte, Acejiyame lui ne ituge ätyepa biname bine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Piba Yeesu teeme abiberäja bägrä bine kokre cama jejemige egä, “Ai poto cidi me gonerage nuuja biname ne jaji. ");
INSERT INTO bon_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tabe cuta jejemige egä, “Cane lui Acejiyame bau ca tädujine, biname me äbitujine, cane miiji mäpurage gwidape bine pagege päpäna. Yoo, Israela modamoda biname, piiyepu modamoda iiwäreja biname, piiyepu cotre abiberäja biname, teepi cebine pa nägyepesi, budre me pa nawenepesi, yepä cane ireclota me pa larpinantepene nesae bimu ingwe ca.” ");
INSERT INTO bon_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeesu puma cita ca iyeta biname bine jejemige egä, “Biname te liba singi cane cama otnime, tabe miiji teemerage singi bine gawe me acrana, teeme baarge uli ne palace cabu bimu gaabegabe acanena, siige cebine ingwe äcwi. ");
INSERT INTO bon_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ingle lui biname te ai gawecewe ireclota cäme tääpume yaapesaruge, tabe toraca ireclota ne cire jääpänepi, yepä lui te ai gawecewe ireclota tääpume wälu cama ire jaatwuge piiyepu singi lica cäme ime cabu acitame, tabe toraca ireclota ne cire yaapesarepi. ");
INSERT INTO bon_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yoo, biname te nuuja miiji ne lica cire jääpänepi, ngänu gyene tabe puu iyeta ai gawecewe ne yaacatuge, yepä peei cabu ca teeme ireclota ne yaapesaruge. ");
INSERT INTO bon_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yoo, biname te liba ajiri birige cäme tääpume piiyepu cäme mene tääpume, piba cane lui Acejiyame bau ca tädujine biname me äbitujine, cane teebine cire jäägyepene pui padare cane liba jamyacu apaclyera cama cire tacnenutepene ai gawecewe me. Yoo, pui padare cabu Aceji Babe me jamyacu apaclyera piiyepu iyeta mename seemo bime jamyacu apaclyera cane cama cirege lenaja. ");
INSERT INTO bon_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cane toraca mene weebibine jijenininine egä ama poto lui cina jeclajutäjenemige, teepi lica pagege budre äbita, ngälu teepi pa jääpänepesi Acejiyame te lipu biname bine yaawademusi.” ");
INSERT INTO bon_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yoo, pama eit bimu ingwe ca Yeesu liba peei mene jaajemepi, tabe Peteru, Yoane, Yakobu naabibine aacanänige podo cabu me irecu ätumutame. ");
INSERT INTO bon_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Egäcäro tabe irecu ätumutige, teeme opo te piba mara me äbitige piiyepu teeme cäbletääpe bulubulurage äbitige, paamlepamle pana. ");
INSERT INTO bon_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Piba taatu neeneni biname cina cabucewe apaclyera cama puga teeme gome taboclomtäsi. Teepi sasa mename biname Moose naabi Eliya tage. Teepi Yeesu cama mene jiicemäsi egä teeme padare mameta ge budre päpäname Yerusalema babo cewe cabu je, tabe lipu Acejiyame me singi pa jaawenepi biname bine ätityerame. ");
INSERT INTO bon_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yoo, Peteru piiyepu ten cama lui biname teepi ute opo pana aanajänige. Liba peei cabu ca cängena alotneränänisi, piba Yeesu ne jamyacu apaclyera cama jepänänisi, piiyepu peei neeneni biname bine jääpänänisi lui ten cama jeclajutäsi. ");
INSERT INTO bon_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pui neeneni liba mameta gegi Yeesu ne abmala, Peteru te piba Yeesu ne jejige egä, “Abiberäja biname, cine miijirage gämi cama. Cine nesae matimati mete bine pa yaarangemesi: yepä määme tääpume, yepä Moose tääpume, piiyepu yepä Eliya tääpume.” Yoo, Peteru cängena umle lica ge tabe ngena mene jiicemige. ");
INSERT INTO bon_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tabe liba mene cabu jage, carbe te piba tädige, teebibine aacwabänige. Abiberäja bägrä cina wälu me äbitininisi carbe te liba icwabemige teebibine. ");
INSERT INTO bon_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Piba carbe cabu ca tagepogogo te tädige egä, “Ai lui cäme bägrä gyene, cane teebine jejujine cäme kaakesea wawena tääpume. Weene teebine jitecijeye!” ");
INSERT INTO bon_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Liba apirige pui tagepogogo te, teepi Yeesu ne taatu jepänänisi. Yoo, abiberäja bägrä cina peei poto cidi me bojä me äbitininisi. Pui padare cabu teepi lica nuuja biname ne jaji ngena ne bii jepänisi. ");
INSERT INTO bon_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nuuja bimu teepi liba podo cabu ca täinetnänige, bucurage biname cina ten cama opopa eyisi. ");
INSERT INTO bon_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Biname tomi cabu ca yepä biname te babo tage cama Yeesu ne jejige egä, “Abiberäja biname, cäme bägrä ne jepäni. Tabe lui cäme yepä taatu imäbägrä gyene. ");
INSERT INTO bon_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Niiya cable te teebine liba joomluge ala abayename jaawenuge, piba tabe uumanumana me läbituge, teeme tage cabu ca mote acwe cina täsuge. Cable te teebine jäje joomlanuge, teeme tääpe ne iyeta sabe jaawenuge. ");
INSERT INTO bon_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cane määme abiberäja bägrä bine liga jaajemune pui cable ne äyeblingtame, siige teepi äblicäco ge.” ");
INSERT INTO bon_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu biname bine jejemige egä, “Weene ätrunga cäco biname gemi, weeme mule lui niiyarage gyene! Luma ngälu padare cane miiji weene cama lenaja? Luma ngälu padare cane miiji weeme ätrunga cäco mule päpäna?” Tabe piba pui biname ne jejige egä, “Bägrä ne secani!” ");
INSERT INTO bon_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Egäcäro bägrä te tädige, cable te teebine ijarige gawe cabu, tabe juumemige. Yeesu piba niiya cable ne jejige äyeblingtame, imäbägrä ne miiji me jewenige, piba teeme babe bau me ewecnistige. ");
INSERT INTO bon_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Siige, iyeta biname cina mutäcäco äbitininisi Acejiyame me babo kokre name pi. Yoo, biname cina mage ngene jotwananinisi Yeesu me mara mule poto cidi me, ");
INSERT INTO bon_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","piba Yeesu teeme abiberäja bägrä bine jejemige egä, “Weene cängena ngene jotwananiniye ai mene poto cidi me: Cane lui Acejiyame bau ca tädujine, biname me äbitujine, teepi cebine biname bime ime cabu pa nacitepesi.” ");
INSERT INTO bon_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yepä, abiberäja bägrä cina teeme mene ne opo lica ewatnisi, ingle teeme tääpume ämlitäneji pana ge pui mene, peei name pi teepi cängena umle lica ge, piiyepu teepi wälu ge teebine ätemlame. ");
INSERT INTO bon_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abiberäja bägrä cina gije jebacitisi atraname egä laati te teeme cabu ca baborage pagege äbita. ");
INSERT INTO bon_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeesu teeme ngene atwanena umle ge, peei name pi bägrä matikolä ne ala tosoglicige teeme opo gaabe je aclajutame. ");
INSERT INTO bon_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tabe piba abiberäja bägrä bine jejemige egä, “Biname lui te apu matikolä bägrä ne jaawabluge cäme ngii cabu, tabe cuta nawabluge cebine; piiyepu biname lui te cebine nawabluge, tabe Acejiyame ne cuta jaawabluge lui te cebine nätyepuji. Yoo, weeme cabu ca lui te matikolä gyene biname bime opo gaabe, tabe sine baborage Acejiyame me opo gaabe.” ");
INSERT INTO bon_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoane te piba jejige egä, “Abiberäja biname, cine biname ne jepänisi lui te niiya cable bine yääyecräjemuge määme ngii cabu. Cine teebine jejisi peei mule ne abmalame, ingle tabe lica mine cama labasutuge.” ");
INSERT INTO bon_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeesu piba Yoane piiyepu nuuja abiberäja bägrä bine jejemige egä, “Teebine gone jiibuye, ingle biname lui te mibibine lica nicisärmutininuge, tabe lui mime tääpu myene.” ");
INSERT INTO bon_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yoo, Yeesu me acnenuta padare cabucewe me seeji mameta me täbitige, tabe ngene piba jotwige Yerusalema me otnime, siige abyemärige. ");
INSERT INTO bon_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tabe biname bine niinäce gaabe me jityepemige Samariya gawe cabu yepä cewe me teeme lenaja puupu ne amacetnäjame. ");
INSERT INTO bon_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yepä, pui cewe biname cina singi lica ge teebibine puupu ceerame, ingle teepi umle ge egä tabe mara iiwäreja mule tääpume Yerusalema me ädenige. ");
INSERT INTO bon_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yoo, abiberäja bägrä Yakobu naabi Yoane liba peei ägyi mule ne jepänäsi, teepi claabe cama jejäsi egä, “Yageyame, nää maane singi gäte cine Acejiyame ne awejename muye ne ätyepame ai biname bine aglecame?” ");
INSERT INTO bon_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yepä, Yeesu atadrengtige, teeme abiberäja bägrä bine jejemige pepu mene gone iicemame. ");
INSERT INTO bon_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Puma cita ca teepi iyeta abyemärinisi nuuja cewe otnime. ");
INSERT INTO bon_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Teepi liba teeme gaabe cabu otninisi, yepä biname te Yeesu ne jejige egä, “Ngänu gyene maane liiyeme ädenite, cane määme ingwe ädenine!” ");
INSERT INTO bon_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu teebine jejige egä, “Poks bime bora piti nemi lenaja tääpume, piiyepu ele bime mete uli cabu piti nemi, yepä cane lui Acejiyame bau ca tädujine, biname me äbitujine, cäme tääpume puupu lica gyene cäme mope acitame. Nää, maane singi gäte pepu otnetnejame cane cama ireclota tääpume?” ");
INSERT INTO bon_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu piba nuuja biname ne jejige egä, “Tädi, cane cama otnime,” Yepä, pui biname te jejige egä, “Babo biname, cane singi gäne meebine ingwe äcwime, yepä cane lipu gäne niinäce otni cäme babe ne gape acitame?” ");
INSERT INTO bon_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu teebine jejige egä, “Laati bemi seemo ireclota cabu budre, teeme tääpume ebmalepi budre biname bine gape cabu acraname; yepä maane ädi, biname bine jajanename Acejiyame te lipu biname bine yaawademuge.” ");
INSERT INTO bon_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nuuja biname te jejige, “Babo biname, cane maane cama ädenine, yepä cane niinäce cäme binamewale bine yewo tawenemene.” ");
INSERT INTO bon_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu teebine jejige egä, “Lui biname te gije labacituge gawe ängwädname cooso piiyepu ängwädna gwidape cama, piba latadrengtuge ingwe gaabe ireme, tabe miiji biname lica birige Acejiyame me biname bine waadena kaakesea tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yoo, peei ingwe ca Yeesu sebentituu biname bine jejäcremige, neeneni neeneni jityepäjemige niinäce otnime iyeta cewe tabe liiyeme singi ingwe ca otnime. ");
INSERT INTO bon_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tabe teebibine jejemige egä, “Ai padare lui epu pana calwacupi gyene liiyepu, deedei luma bucurage, yepä kaakesea biname nesae gemi pui deedei waadename. Miiji Yageyame ne awejena egä tabe kaakesea biname bine pa jäätyepemepi biname bine teeme bau me waadename. ");
INSERT INTO bon_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Äte naaclege! Cane weebibine maamoi plongo pana jityepininine, girigale drego pana biname cina luma icrajenige. ");
INSERT INTO bon_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gone rarekaake waadena, cuta diiba piiyepu ernge gwidape gone waadena. Awabla je gone aclajutame gaabe cabu. ");
INSERT INTO bon_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Weene lui mete me labacitinuye, niinäce jiicuye egä, ‘Poode yaanajege iyeta ai mete biname cabu.’ ");
INSERT INTO bon_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yoo, biname liba pisi nyene lui te singi poode cama lenajame, pui poode te piba teeme bau yaanajuge, yepä liba puma pepu biname lica gyene, peei poode te piba pa tacnenutepi weeme cabu me. ");
INSERT INTO bon_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Weene pui yepä mete cabu pa inajipi, gone mete maramara cabu waatninuye. Lipu deedei piiyepu niiye bine teepi icärininusi, weene miiji gemi peei bine ärwäja piiyepu änäja, ingle biname miiji gemi daremu ne päpäna teeme kaakesea cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yoo, weene liba nuuja cewe me labacitinuye, piiyepu pui cewe biname cina weebibine jiwablininusi, teepi lipu deedei icärininusi, peei bine yäärwäjuye. ");
INSERT INTO bon_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pita biname bine miiji me jaawenemuye pui cewe cabu, piiyepu biname bine jaajemuye egä, ‘Acejiyame mameta gyene weebibine waadename.’ ");
INSERT INTO bon_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yepä, weene liba cewe me labacitinuye, piiyepu cewe biname cina liba lica jiwablininusi, piba cewe gaabe cabu jiclajutinuge, piba jaajemuye egä, ");
INSERT INTO bon_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Cine weeme cewe tuuwe bine jiglubäjenemisi cime ernge cabu ca awabame egä pepu ätecija cäco mule lui miiji lica gyene. Yepä, weene ngene gone ätrimela egä Acejiyame mameta ge weebibine waadename, yepä weene peei ne bii jigyiye.’ ");
INSERT INTO bon_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Siige, cane weebibine umle jiwenininine egä atrana bimu cabu Acejiyame me daremu pui cewe tääpume mäpurage cirege äbita Sodoma cewe me daremu cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasine cewe biname, babo niiyarage cirege weeme tääpume! Betesaida cewe biname cuta piiyepu, babo niiyarage cirege weeme tääpume! Cane lui ciitaca mule bine ituge wawena weeme bau me, liba peei bine Turo piiyepu Sidona cewe biname bime bau me cire jaawenemejine, teepi teeme niiya mule bine cire yaabmalecmejisi, cäme bau cire tatatrongärinejisi. Teepi ragre cire lasigrärinejisi, piiyepu mriibe ca cire lapyacinejisi awabudnitame egä teepi ituge abmaläcema teeme niiya mule bine. Puu weene te ciitaca mule bine ituge päpäna, yepä weene licarage cäme bau me tatatrongäripeye. ");
INSERT INTO bon_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yoo, atrana bimu cabu Acejiyame me owecu Turo piiyepu Sidona cewe biname bime tääpume baborage cirege äbita, teeme owecu cabu ca Korasine piiyepu Betesaida cewe biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Cuta weene Kaprenauma cewe biname, nää weene toraca apu jingenininige egä Acejiyame te weebibine cabu me jiwenininige? Eewe, weene gawerage me cirege otni, niiya puupu cabu me, weeme ätrunga cäco mule name pi.” ");
INSERT INTO bon_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeesu piba teeme abiberäja bägrä bine jejemige egä, “Yoo, lui cina weeme mene jitecijinusi, teepi cuta cebine nätecijusi, piiyepu weebibine lui cina jigyinusi, teepi cuta cebine nägyusi, cuta piiyepu lui cina cebine nägyusi, teepi cuta teebine jäägyusi lui te cebine itu nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Siige, pui sebentituu biname Yeesu lui bine jäätyepemepi, teepi ngenecu gege cama täcnärininisi, Yeesu ne jejisi egä, “Niiya cable cina biname bime cabu ca läyeblinginusi, cine liba teebibine määme ngii cama jaajemusi!” ");
INSERT INTO bon_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu teebibine jejemige egä, “Yoo, cane Satani ne jääpänepene, tabe paamlepamle pana saatramepi cabucewe cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nätecijeye, cane weebibine kokre ituge ceera uutrutame mime cubuyame Satani cabu ca. Weene ibibi gemi cobyame piiyepu potetagetage cabu otni; nuuja gwidape te äblicäco weebibine niiya wawena. ");
INSERT INTO bon_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yoo, weene gege gemi, ingle weeme mene te niiya cable bine yääyeblengemuge, yepä nuuja gwidape baborage gyene peei cabu ca. Weene miiji baborage ngenecu gege läbitininuye, ingle naace gyene weeme ngii oogäräneji piti nemi cabucewe je Acejiyame bau.” ");
INSERT INTO bon_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yoo, pui padare cabu Aceji Seemo te babo ngenecu gege me jewenige Yeesu ne. Yeesu jejige egä, “Cäme Babe, maane lui Yageyame gäte cabucewe piiyepu gawecewe tääpume. Cane meebine babo eso nääcärenine naace tääpume egä maane ai gwidape bine ituge ämletna umle biname piiyepu miijimiji mopemuli biname bime bau ca, siige abiberäja cäco biname bime bau me ituge aboclomäja. Yoo, Babe, peei lui määme miijirage singi gyene.” ");
INSERT INTO bon_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yeesu puma cita ca biname bine jejemige egä, “Cäme Babe te iyeta gwidape itu saabmalemepi cäme ime cabu me. Nuuja biname te umle lica gyene cäme tääpume, cane lui Aceji Bägrä gäne, yepä Babe taatu umle gyene. Piiyepu nuuja biname te umle lica gyene Aceji Babe tääpume, yepä cane teeme Bägrä taatu umle gäne, cuta piiyepu lui biname tääpume cane singi teebine aboclom-ta, teepi taatu umle gemi.” ");
INSERT INTO bon_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeesu piba atatrongtige teeme abiberäja bägrä bime bau me, teebibine taatu jejemige egä, “Babo ngenecu miiji weeme tääpume lui cina ai gwidape bine irecu ca jepänenemiye. ");
INSERT INTO bon_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cane weebibine jijenininine egä sasa cabu ca bucurage mename biname piiyepu mope biname cina babo singi ge päpäname, weene page lui mule bine jepänenemiye, yepä teepi lica itu jepänemujisi, piiyepu teepi babo singi ge ätecijame weene page lui mene itecijenenige, yepä lica itu itecijinuji.” ");
INSERT INTO bon_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yepä cotre abiberäja biname te Yeesu gome jeclajutige. Tabe singi Yeesu me abiberäja ne apicetnerame, peei name pi itemlige egä, “Abiberäja biname, cane miiji ngena ne wawena iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu teebine jejige egä, “Oogäräneji Mene te lipu jiicenige? Maane ngena mene bine peei cabu yaacnemute?” ");
INSERT INTO bon_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pui biname te jejige egä, “‘Biname te miiji Acejiyame teeme Yageyame tääpume singi iyeta teeme ngenecu cama, iyeta teeme seemo cama, iyeta teeme kokre cama, piiyepu iyeta teeme ngene atwanena cama,’ piiyepu, ‘biname te miiji teeme nuuja biname ne yepä pana singi cama jaawenuge tabe lipu singi cama teemämu lasicnantuge.” ’ ");
INSERT INTO bon_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu jejige egä, “Määme mene conocäco gyene. Peei ne liba jaawenute, maane piba iyeteta ireclota cire jepänepi.” ");
INSERT INTO bon_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yepä, pui cotre abiberäja biname te singi teeme mene conocäco me wawename biname bime opo gaabe, peei name pi tabe Yeesu ne cääri itemlige egä, “Cane miiji lui biname tääpume pepu wawena?” ");
INSERT INTO bon_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu teebine ngene ca agli mene ca umle jewenige apu egä, “Yoo, yepä biname te äduji Yerusalema ca Yeriko me. Gaabe cabu ero biname cina teebine joomlisi, iyeta teeme gwidape bine jiirecimisi, teebine eglisi, gaabe gome ebmalisi ejijejija. ");
INSERT INTO bon_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yepä iiwäreja biname te pui gaabe cabu ädige, liba biname ne jepänige ätwitäneji, gaabe nuuja poto ca ädige. ");
INSERT INTO bon_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cuta yepä iiwäreja biname me ätitye-rayame te ädige, pui biname ne liba jepä-nige, mameta me ädige ireme, piba gaabe ne jeclänu-tige, nuuja poto ca ädige. ");
INSERT INTO bon_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Puma cita ca yepä Samariya gawe biname te pui gaabe cabu cuta ädige, liba pui bina-me ne dupe cama jepänige, siige babo owecu me äbitige. ");
INSERT INTO bon_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tabe teeme bau me ädige, olibi migi piiyepu waina niiye dupe cabu icranemige, piba cäbletääpe pläsu ca jetäyemige dupe bine. Tabe piba pui dupe biname ne teeme dongki cabu etecwamtige, otnetneja biname bime mete me ecanige. Tabe puga teebine ire jetwige. ");
INSERT INTO bon_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nuuja bimu tabe neeneni silba rarekaake bine aasatige, pui otnetneja mete ire atwi biname ne ecärige, jejige, ‘Peei biname ne cängena ire jetwepi! Ai rarekaake liba ibibi lica gyene, cane cerämu meebine pa nääcärepene, cane liba ai gaabe cabu pagege acnenuta.’” ");
INSERT INTO bon_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Siige, Yeesu puma cita ca cotre abiberäja biname ne itemlige egä, “Lipu gyene määme ngene atwanena? Pui nesae biname cabu ca laati te dupe biname ne toraca biname me jewenige?” ");
INSERT INTO bon_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Cotre abiberäja biname te jejige egä, “Pui biname lui te teebine owecu cama itityärige.” Yeesu jejige egä, “Maane ädi, pepu pana mule bine jaawenemute!” ");
INSERT INTO bon_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yoo, Yeesu teeme abiberäja bägrä cama gaabe cabu liba eclige, yepä cewe me atyarige. Puga yepä magebi ngii Maareta teebine teeme mete cabu jewablige. ");
INSERT INTO bon_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Teeme maade Mariya puga ge. Tabe Yeesu gome adnatige, iyeta teeme abiberäja mene cängena utecijige. ");
INSERT INTO bon_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yepä, Maareta iyeta teeme maramara mete kaakesea name pi ngenecu mäpu me äbitige, puma cita ca Yeesu bau me oclige, jejige egä, “Yageyame, maane lica jepänite egä cäme maade te iyeta kaakesea cäme bau me sebmalemige? Teebine joji cebine ätityerame!” ");
INSERT INTO bon_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Siige, Yageyame teebine jojige egä, “Maareta, Maareta, bucurage gwidape cina meebine ngenecu mäpu me naawenenisi, ");
INSERT INTO bon_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","yepä pisi nyene yepä taatu baborage gwidape. Mariya peei miiji gwidape bii jepänige, siige peei ne lica gyene teeme bau ca uutecra.” ");
INSERT INTO bon_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nuuja taje Yeesu Acejiyame bau me irecu ätumutige yepä cewe cabu. Teeme irecu ätumuta liba siige, yepä teeme abiberäja bägrä te teebine jejige egä, “Yageyame, nibiberäjinini cibibine irecu ätumutame, Yoane teeme abiberäja bägrä bine lipu itu sebiberäjemumi.” ");
INSERT INTO bon_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu piba teebibine jejemige egä, “Weene liba irecu lätimutinuye, apu jiicemuye egä: ‘Babe, Määme miijirage ngii ne opo gaabe me naacitesi. Maane tädepi biname bine waadename. ");
INSERT INTO bon_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cime bimu gaabegabe deedei nicäranipi. ");
INSERT INTO bon_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cime niiya mule bine yääyeblengemute. Iyeta nuuja biname bime niiya mule cime tääpume cine cuta iyeblengemepi cime ngene atwanena cabu ca. Cuta gone cibibine niwadininute mäpurage apicetnära cabu me.’” ");
INSERT INTO bon_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Siige, Yeesu piba teeme abiberäja bägrä bine ngene ca agli mene jejemige egä, “Pama weeme yepä te teeme biname bau me läduge ciiye duusa, teebine jaajuge egä, ‘Cäme biname, maane nesae buluduu watata näcäri. ");
INSERT INTO bon_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Cäme yepä biname te teeme gaabe cabu ca bii tatyaramtige. Cäme nuuja deedei lica gemi teebine ceerame.’ ");
INSERT INTO bon_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yoo, määme biname te mete cabu ca piba meebine naajuge egä, ‘Gone cebine sabe nawenute, ingle cime grana armeji gyene; cine iyeta bägrä cama ute puupu cabu temi. Cane äblicäco gäne arpinenta määme singi gwidape ceerame.’ ");
INSERT INTO bon_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yoo, ngänu gyene tabe teeme biname ge, tabe singi lica ciiye duusa arpinentame buluduu ceerame, yepä cane weebibine jijenininine egä, tabe pa larpinantege iyeta teeme singi gwidape ceerame, pui nuuja te liba ajiri lica teebine jäje ätineräja. ");
INSERT INTO bon_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yoo, peei name pi cane weebibine jijenininine: Acejiyame ne itinäreye, tabe pa icäripi; jirngeye, weene pa jepänepeye; eyäjeye, piba Acejiyame te gaabe pa jiitnepi weeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ingle iyeta lui cina yäätinärusi, teebibine yääcäremusi; lui cina jäärngusi, teepi jääpänusi; piiyepu lui cina yääyäjusi, gaabe teeme tääpume jiitnusi. ");
INSERT INTO bon_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yoo, weene lui babe gemi, weeme bägrä cina liba cibu tääpume jaji, weeme nuuja te licarage teeme bägrä ne niiyarage cobyame ne ceera. ");
INSERT INTO bon_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Coo, tabe liba paulo kuu tääpume jaji, weeme nuuja te licarage potetagetage ne ceera. ");
INSERT INTO bon_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Toraca gyene, weene miiji biname lica gemi, yepä weene umle gemi miiji gwidape taatu bägrä bine ceera. Siige, mime Babe cabucewe je lui miijirage gyene iyeta biname cabu ca, tabe Aceji Seemo toraca pa täätyepepi teeme bau me lui cina teebine yäätineräjusi. ");
INSERT INTO bon_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yeesu te yepä niiya cable ne biname cabu ca iyecräjige. Pui cable te äblicäco mene iicana, peei name pi liba asatige, tabe pui biname te piba gije abacitige mene iicaname. Tomi cabu lui biname cina mutäcäco äbitininisi, ");
INSERT INTO bon_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","yepä poto cina walya mene jiicisi egä, “Beelsebul lui niiya cable bime mopeyame gyene, tabe te teebine kokre ecäranenige niiya cable bine äyecrejame.” ");
INSERT INTO bon_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yoo, nuuja biname cina singi Yeesu me kokre ne apicetne-rame, peei name pi teebine jejisi mara ciitaca mule wawename, awabame teeme kokre liba Acejiyame bau ca täduge. ");
INSERT INTO bon_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yepä, Yeesu teeme ngene atwanena umle äbitige, teebibine jejemige egä, “Nuuja gawe biname cina liba labelaninusi teemeteme cubu me, teepi wata lapirininusi, cuta piiyepu ingle biname cina liba teemeteme labelaninusi cubu me, peei ingle te wata lapiruge. ");
INSERT INTO bon_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Peei name pi Satani me niiya cable cina liba maramara tomi cabu läbitininusi, teemeteme laglinusi, Satani me waadena mule te piba lipulipu kokre lenaja? Yoo, weene apu jiicemuye egä Beelsebul, lui ne Satani ca yaainusi, tabe te cebine kokre näcäruge teeme niiya cable bine äyecrejame. Peei toraca lica gyene, ingle Satani singi lica gyene teeme niiya cable bine biname cabu ca äyecrejame. ");
INSERT INTO bon_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yoo, poto weeme abiberäja bägrä cina niiya cable bine cuta yääyecräjemusi. Luma cita ca teeme kokre peei mule ne wawename? Licarage Beelsebul bau ca. Peei name pi weemerage abiberäja bägrä cina jaawabudnitusi egä weeme mene cäme poto cidi me lui conocono gyene. ");
INSERT INTO bon_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eewe, cäme kokre lui Beelsebul, coo Satani, bau ca lica gyene. Cäme kokre niiya cable bine äyecrejame lui Acejiyame me ime cabu ca gyene. Peei kokre te jaawabudnituge egä Acejiyame me biname bine waadena mule te ituge atyaramta weeme bau me. ");
INSERT INTO bon_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Yoo, Satani te apu pana gyene kokre biname, lui te teeme cubu gwidape cama teeme mete gome ire cama yaanajuge, siige iyeta teeme gwidape cängena yaacrajuge, ");
INSERT INTO bon_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","yepä cane lui te teeme cabu ca kokre gyene, cane liba teebine joomlune, cubu cama yuutrutune, iyeta teeme cubu gwidape bine piba juutecrune, tabe lui bine jäätrungemuge, siige teeme ero ca awadäneji gwidape bine piba jaabelanemune. ");
INSERT INTO bon_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yoo, laati te cäme biname lica gyene, tabe cebine näcisärmutuge; piiyepu laati te cäme bau me lica taabasecretni-muge, tabe yaaplidnäremuge. ");
INSERT INTO bon_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Yoo, niiya cable te liba biname cabu ca lasatuge, tabe niiye cäco cewe cabu ta waatnetnäjuge, puupu ne jäärnguge ngene oocaname. Liba lica jääpänuge, tabe jiicuge egä, ‘Cane acnenine piiyeme, cane lui mete ne sebmalumene.’ ");
INSERT INTO bon_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tabe siige lacnuge, mete ne jääpänuge lui apretnäneji piiyepu cängena acranäneji ge. ");
INSERT INTO bon_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tabe piba läduge seben mage niiyarage cable bine arwojame, siige teepi iyeta saacluge pui biname cabu lenajame. Niinäce pui biname miiji lica birige, yepä page tabe siige mage niiyarage me läbituge.” ");
INSERT INTO bon_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yeesu liba pui mene bine jiicemige, biname tomi cabu ca yepä magebi te babo tage ca jejige egä, “Gege gwene pui magebi lui te meebine itu naplimluji, ngame näcäranuji!” ");
INSERT INTO bon_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yeesu teebine jojige egä, “Teepi toraca gege gemi lui cina Acejiyame me mene cängena yäätecijemuge piiyepu jaawenusi.” ");
INSERT INTO bon_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Biname cina Yeesu gome liba tomi yootisi, tabe piba teebibine jejemige egä, “Weene lipu niiyarage biname gemi page ai padare cabu lui cina ireclota gemi! Weene singi gemi cäme bau ca ciitaca mule ne päpäname, yepä weene nuuja ciitaca mule ne lica pa jepänepeye, yepä taatu Acejiyame me mename biname Yoona tääpume lipu mule te äbituji, peei ne pa jääpänepesi. ");
INSERT INTO bon_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yoo, Yoona tääpume lipu ituge äbita, peei te Ninewa biname bime tääpume itu jewabudnituji egä teeme mene lui Acejiyame bau ca ge. Cane lui Acejiyame bau ca tädujine, biname me äbitujine, cäme tääpume lipu pagege äbita, peei te pa jaawabudnitepi egä cäme mene ai padare cabu lui Acejiyame bau ca gyene. ");
INSERT INTO bon_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yoo, atrana bimu cabu Siiba gawe mope magebi lui sasa padare cabu onajuji, teebine liba weene cama cire twaarpinantepi atrana tääpume, tabe weebibine cire jiwabipi egä weene ätecija cäco biname gemi, ingle tabe mage cudecewe ca tocluji uule poto ca Solomona me umle mene ätecijame. Yoo, cane weebibine jijenininine egä cane age säne baborage Solomona cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yoo, atrana bimu cabu Ninewa cewe biname cina cirege abujenga, weebibine cire jiwabipesi egä weene ätecija cäco gemi, ingle teepi te niiya mule cabu ca itu tatatrongärininujisi, liba Yoona me mene itecijemuji. Yoo, cane age säne baborage Yoona cabu ca, yepä weene singi lica gemi cäme mene ätecijame!” ");
INSERT INTO bon_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nuuja biname te lica lampa ne jaabotuge piba yäämlituge, coo diiba ca yäätrugäruge, yepä tabe cabu me yaatecwantuge. Piba biname cina apaclyera ne jääpänusi mete cabu me, liba yääbäcnusi. ");
INSERT INTO bon_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yoo, irecu lui lampa pana gegi tääpe tääpume. Määme irecu liba miiji birige, määme tääpe te, iyeta apaclyera taatu birige, yepä määme irecu liba niiya birige, määme tääpe te cuta krokeciiye cabu yaanajuge. ");
INSERT INTO bon_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yoo, cängena ire egä määme cabu lui apaclyera te lica krokeciiye gyene. ");
INSERT INTO bon_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Siige, määme cabu apaclyera te liba babo läbituge, piiyepu määme cabu nuuja krokeciiye liba lica birige, piba määme ireclota iyeta lui apaclyera cabu birige, epu pana apaclyera te lampa cabu ca meebine lipu naapaclyäruge. ");
INSERT INTO bon_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeesu pui mene bine liba epiremige, yepä Parisea sigu biname te teebine ala tesoglicige ten cama matikolä deedei äbitame. Siige, Yeesu teeme mete me abacitige, deedei tääpume adnatige. ");
INSERT INTO bon_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pui Parisea sigu biname älu te jitige, liba jepänige egä Yeesu lica bäcisäjige ingwe ca piba deedei äbitame, Parisea biname bime mule liiyepu. ");
INSERT INTO bon_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Peei name pi Yageyame teebine jejige egä, “Yoo, weene Parisea biname cina weeme tääpe cängena jääcisäjemuye, piiyepu weeme niiye kwäye piiyepu deedei kwäye liiyepu kaakepoto bine jääcisäjemuye, yepä weeme trupa ngalebora niiya singisingi piiyepu conocono piti nemi. ");
INSERT INTO bon_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Weene buduma gemi! Acejiyame lui te weeme tääpe bine ituge wawena, tabe cuta weeme trupa bine ituge wawena. ");
INSERT INTO bon_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yepä, weeme kwäye ngalebora ngena piti nemi, ecäremepeye owecumete biname bine, siige iyeta jugi cäco pa läbitepi weeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yoo, Parisea biname, mage mäpu cirege weeme tääpume! Weene Acejiyame ne yepä yääcäruye weeme iyeta ten deedei mite wawena laame ngii minti, ruu, piiyepu lija nuuja laame cabu ca, ngänu gyene Cotre cabu pui mule lui baborage lica gyene. Yepä, weene lica jaawenemuye lui Cotre mule modamoda gemi apu egä iyeta biname bine yepä pana ire jaatwemuye, piiyepu toraca singi läbitininuye Acejiyame tääpume. Weene miiji ai modamoda mule bine wawenetnäja, cuta gone ngene ätrimela poto matimati mule bine wawenetnäjame. ");
INSERT INTO bon_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisea biname, mage mäpu cirege weeme tääpume! Weene singi modamoda biname bime puupu cabu adnaterame abasecre-tna mete cabu, piiyepu weene singi gemi biname cina weebibine awablame aletna puupu cabu. ");
INSERT INTO bon_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Weene mäpu cirege päpäna, ingle weene epu pana gemi gape liiyepu lui gawe cabu ämlitäneji yaanajuge. Lui biname cina peei cabu waatninusi, teepi nuuja umle lica gemi egä ocwäwäneji gwidape pisi nyene gawe bora. Pepu pana, biname lui cina weeme mameta me otni, teepi nuuja umle lica gemi egä ngalebora weene niiya gemi.” ");
INSERT INTO bon_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Puma cita ca yepä cotre abiberäja biname te jejige egä, “Abiberäja biname, määme mene te cuta cibibine ngenecu mäpu me niwenininige!” ");
INSERT INTO bon_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu jejemige teebibine egä, “Yoo, cotre abiberäja biname, weene cuta piiyepu mage mäpu cirege päpäna. Weene biname bine mäpu me jaawenemuye weeme bucurage cotre liba teebibine owecu cäco yääcäremuye, yepä weene singi lica teebibine ätityerame peei cotre bine cängena wawenecame. ");
INSERT INTO bon_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yoo, mage mäpu cirege weeme tääpume! Weene miijimiji kula caale bine yaarangemuye Acejiyame me sasa mename biname bine ngene apecname, puirage mename biname weeme kaakesaare cina lui bine itu eglecimujisi. ");
INSERT INTO bon_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Page weeme mule mara lica gyene weeme kaakesaare bime cabu ca. Teepi mename biname itu eglecimujisi, cuta page weene pui mename biname bime ngene apecna kula bine jaawenemuye. ");
INSERT INTO bon_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yoo, Acejiyame umle cama itu jiicemuji egä, ‘Cane maramara mename biname bine teeme bau pa jäätyepemepene. Poto bine teepi niiya pa jaawenemepesi; poto bine budre me pa yaaglecemepesi.’ ");
INSERT INTO bon_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yoo, weene lui gemi ireclota cama page, weene pui mäpu daremu cirege päpäna iyeta mename biname bime agleca tääpume piiyepu teeme uudi apira tääpume agedna padare cabu ca ngälu page. ");
INSERT INTO bon_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela lui niinäce biname ge lui ne budre egluji, siige puma cita ca agleca mule te enajuji ngälu Sakariya ne budre me eglujisi iiwäreja mete piiyepu iiwäreja dade cole puupu cabu je. Yoo, cane weebibine jijenininine egä page lui biname cina icrajinige, teepi te iyeta ai agleca tääpume daremu ne cire jääpänepesi! ");
INSERT INTO bon_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yoo, cotre abiberäja biname, mage mäpu cirege weeme tääpume! Weene gaabe ne ituge armi biname cina Acejiyame me singi toraca umle äbitame. Weene weemämu lica umle äbita, piiyepu weene biname bine jiibemuye lui cina singi gemi umle äbitame!” ");
INSERT INTO bon_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Siige, teeme mene liba epiremige, Yeesu pui mete ne sebma-lige. Cotre abiberäja biname piiyepu Parisea sigu biname cina teebine jimugetnisi. Pui padare cabu ca teepi bucurage maramara gwidape poto cidi me itemläjisi, ");
INSERT INTO bon_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ingle teepi singi teebine giri acita yepä conocono mene iicaname, piba pui cabu ca teebine oomlaname. ");
INSERT INTO bon_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pui padare cabu bucurage tausen biname cina abasecretnige; teepi tomi cabu ädudnecäjininisi. Siige, Yeesu niinäce teeme abiberäja bägrä bine jejemige egä, “Weene walya mule gone, ai Parisea sigu biname liiyepu. Uutneca gwidape te buluduu ne lipu joomluge, siige iyeta poto ta juutnecuge, pepu pana walya mule te biname me ireclota ne iyeta joomluge. ");
INSERT INTO bon_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Weene äblicäco walya mule cabu iyeteta lenaja. Ngena gyene ämlitäneji, pagege pajecu me äbita; ngena gemi ogä, pagege awabudnäja. ");
INSERT INTO bon_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yoo, lui mene bine weene krokeciiye cabu jiicemuye, biname cina bimu cabu pa yäätecijemepi, piiyepu mete bora weene siiyä mene ca biname me tablame cabu ngena ituge jaji, mete toro cabu ca pagege jajanena.” ");
INSERT INTO bon_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Cäme binamewale, cane weebibine jijenininine egä, “Wälu gone biname tääpume. Biname te nuuja biname ne yaagluge, yepä budre ingwe ca tabe äblicäco pui biname ne nuuja niiya wawena. ");
INSERT INTO bon_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pätä, weene miiji Acejiyame tääpume wälu, ingle teeme kokre pisi nyene biname me budre ingwe gaabe ca teeme seemo ne cuta niiya puupu cabu me ajarame. Yoo, peei name pi cane weebibine jijenininine egä weene miiji Acejiyame tääpume wälu. ");
INSERT INTO bon_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yoo, faib matimati ele bine biname cina jaaletnemusi neeneni cäsäcäsä rarekaake ca, yepä Acejiyame te lica yepä pui ele poto cidi me ngene jäätrimaluge. ");
INSERT INTO bon_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yoo, tabe cuta weeme poto cidi me iyeta umle gyene; tabe umle weeme edingäli lija gemi. Peei name pi weene wälu gone, ingle Acejiyame me singi weeme tääpume lui baborage gyene teeme ele tääpume singi cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Cane lui Acejiyame bau ca tädujine, biname me äbitujine, cane weebibine jijenininine egä lui biname te biname bime sobe cabu jaajemuge egä, ‘Cane Yeesu Keriso me biname gäne,’ cane te Acejiyame me mename seemo bine pa jaajemepene pui biname poto cidi me egä, ‘Tabe cäme biname gyene.’ ");
INSERT INTO bon_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yepä, lui biname te cebine biname bime sobe cabu nainuge, cane cuta teebine pa jaainepene Acejiyame me mename seemo bime opo gaabe je. ");
INSERT INTO bon_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yoo, lui biname te cebine näcisecräjuge, cane lui Acejiyame bau ca tädujine, biname me äbitujine, Acejiyame pui niiya ne cirege äyeblingta, yepä lui biname te niiyarage mene jiicemuge Aceji Seemo poto cidi me, peei niiya ne lica cirege äyeblingta. ");
INSERT INTO bon_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yoo, weebibine liba ablaweja tääpume iwadininusi abasecre-tna mete cabu me, coo nuuja mope biname bime opo gaabe je, piba bucurage ngene atwanena gone egä, ‘Cane ngena mene pa jaajemepene?’ coo, ‘Cane lipu gäne daremu mene awecnistame?’ ");
INSERT INTO bon_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ingle naace gyene Aceji Seemo pui padare cabu meebine mene pa icäripi iicemame.” ");
INSERT INTO bon_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tomi cabu ca yepä biname te piba jejige egä, “Abiberäja biname, cäme naane ne jeji cäme tääpume abelename cime babe te lui gwidape bine itu saabmalemepi!” ");
INSERT INTO bon_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu teebine jejige egä, “Nuuja biname te lica cebine najepi weeme ablaweja biname coo atrana biname me äbitame. Gone cebine najute gwidape bine abelename weeme tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tabe puma cita ca iyeta biname bine jejemige egä, “Cängena ire, gone singisingi läbitininuye bucurage maramara gwidape tääpume, ingle biname me ireclota baborage gyene gwidape cabu ca, ngänu gemi teeme peei gwidape lipu bucurage.” ");
INSERT INTO bon_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tabe piba teebibine jejemige ai ngene ca agli mene egä, “Yepä gwidape dogwe biname te yaanajepi. Teeme gawe cabu bucurage deedei cina luutipesi. ");
INSERT INTO bon_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tabe ngene jwaatwananepi egä, ‘Cane ngena pa jaawenepene, ingle cäme cumä tääpume mete ibibi lica gemi iyeta ai deedei bine äbäcname?’ ");
INSERT INTO bon_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tabe piba jiicige egä, ‘Cane apu pa jaawenene! Cane cumä tääpume mete bine pa jiitnemepene, piba cuta modamoda bine pa yaarangemepene. Iyeta cäme calwa-cupi deedei piiyepu cäme nuuja gwidape bine peei cabu pa yääbäcnemepene cumä tääpume. ");
INSERT INTO bon_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Piba cane cämämu pa jiicepene egä, “Cäme gwidape bucurage gemi, ibibi gemi poto kämäge tääpume. Cane ngene pa loocepene, deedei äbitame, niiye nanime, gege taatu lenajame.” ’ ");
INSERT INTO bon_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yepä, Acejiyame teebine jejige, ‘Maane buduma gäte! Ai ciiye cabu määme ireclota te apirenige. Iyeta gwidape maane lui määme tääpume tomitomi tewenemumete, baa laati te pa yaawademepi?’” ");
INSERT INTO bon_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu pui mene ne epirige egä, “Pepu pana pa läbitepi teeme tääpume lui cina gwidape tomitomi äbitininisi, yepä gwidape singisingi name pi, teeme padare lica gyene Acejiyame tääpume. ");
INSERT INTO bon_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeesu piba teeme abiberäja bägrä bine jejemige egä, “Yoo, peei name pi ngenecu mäpu gone läbitininuye weeme ireclota tääpume ngena yaarwuye, coo weeme tääpe tääpume ngena lasigrärinuye. ");
INSERT INTO bon_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ingle naace gyene weeme ireclota lui baborage gyene deedei cabu ca, piiyepu weeme tääpe baborage gyene cäbletääpe cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yoo, sändäyame bine jepänemeye. Teepi gije lica yäätemusi, lica yäärucnemusi, teeme nuuja puupu lica ge deedei cumä tääpume acraname, yepä Acejiyame te teebibine cängena ire jetwenenemige. Yoo, ele cabu ca weene modamoda gemi Acejiyame me ngene atwanena cabu! ");
INSERT INTO bon_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nää, weene ibibi gemi weeme ireclota yepä bimu cerämu leca me wawena weeme bucurage ngene atwanena cabu ca? Weene äblicäco! ");
INSERT INTO bon_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yoo, weeme bucurage ngene atwanena liba ibibi lica ai matikolä gwidape wawename, piba ngeno me bucurage ngene atwanena iyeta nuuja gwidape poto cidi me? ");
INSERT INTO bon_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Baace popo bine jepänemeye teepi lipu uutenininisi miijirage. Teepi kaakesea lica jaawenemusi, coo piiyepu cäbletääpe lica yaaterutäjemusi. Yepä, cane weebibine jijenininine egä ngänu gyene mope biname Solomona puu jamyacurage cäbletääpe ca abasogäruji, yepä tabe epu miiji opo lica äbituji ai baace popo bime yepä te liiyepu. ");
INSERT INTO bon_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Acejiyame te liba apu yaabasogäremuge baace bine, lui cina page luutinusi, ciiyeciye siige muye cabu me yiisabemusi, egäsu tabe cuta weebibine isigreräjininuge cäbletääpe ca. Weeme ätrunga lipu matimati gemi! ");
INSERT INTO bon_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Weeme ngenecu gone deedei piiyepu niiye cabu me yaacranemuye; gonerage ngenecu mäpu me äbita. ");
INSERT INTO bon_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Acejiyame umle cäco biname teepi te jäärngemusi iyeta ai gwidape bine, yepä weeme Cabucewe je Babe te umle gyene egä weeme singi piti nemi ai gwidape tääpume. ");
INSERT INTO bon_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pätä weene miiji äbitipeye tabe te weebibine waadename, siige tabe cuta weeme singi gwidape bine pa icäranipi.” ");
INSERT INTO bon_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yeesu jejemige egä, “Weene lui epu pana matikolä maamoi tomi, yepä wälu gone, ingle weeme Babe gege gyene weebibine piiyeme waadename. ");
INSERT INTO bon_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Weene gwidape bine yaacranemuye aletna tääpume, siige pui cabu ca lui rarekaake owecumete biname bine yääcäremuye. Yoo, rarekaake äbäcna diiba cina sasa me läbitininusi; ai gawecewe gwidape cina lämletnininusi. Peei name pi miijimiji gwidape cabucewe je puupu cabu yaacranimuye. Weene liba miiji mule jaawenemuye, peei lui apu gyene weene miijimiji gwidape bine cabucewe je cumä tääpume acraname. Puma teepi lica lämletnininusi, ingle ero biname te äblicäco gyene waadena, piiyepu potäte cina lica jaatecimusi. ");
INSERT INTO bon_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yoo, määme miijimiji gwidape luma, määme ngenecu cuta puma birige.” ");
INSERT INTO bon_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yeesu jejemige egä, “Amacetnäjäneji inajininuge, cäbletääpe labasogärininuye, piiyepu weeme lampa bine abotäneji yaacranemuye. ");
INSERT INTO bon_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Weene epu pana läbitininuye kaakesea bägrä liiyepu, lui cina teeme babo biname ne jaawagrijusi soriyomu cabu ca liba acnenutame. Tabe liba tädige, grana cabu soororäjuge, siige teepi grana ne wata jiitnusi teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Babo miijirage teeme tääpume lui bine teeme babo biname te ireclota cama amacetnäjäneji jääpänemuge teeme acnenuta padare cabu. Cane weebibine toraca jijenininine egä, tabe cäbletääpe pa lasigrepi kaakesea me, teebibine deedei tääpume pa yaawednetäjemepi, teebibine cängena ire pa jaatwemepi. ");
INSERT INTO bon_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yoo, babo miijirage pui kaakesea biname bime tääpume, teeme babo biname liba ciiyedusa täduge, coo sewali mameta liba täduge, yepä teebibine cuta ireclota cama jääpänemuge. ");
INSERT INTO bon_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cuta ai poto cidi me ngene jwaatwa-naninuye. Mete yageyame liba ero biname me otni padare poto cidi me umle ge, tabe piba ero biname ne jiibuge teeme mete cabu abacitame. ");
INSERT INTO bon_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yoo, weene miiji amacetnäjäneji lenaja, ingle cane lui Acejiyame bau ca tädujine, biname me äbitujine, cane lica weeme singi padare cabu acnenuta, yepä weene nuuja umle lica gemi cäme otni padare.” ");
INSERT INTO bon_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peteru Yeesu ne itemlige egä, “Yageyame, maane peei ngene ca agli mene, nää cime tääpume taatu jiicemite, coo iyeta biname bime tääpume jiicemite?” ");
INSERT INTO bon_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yageyame teebine jejige egä, “Cäme mene lui iyeta toraca ngenecu piiyepu umle cama biname bime tääpume. Teepi lui epu pana gemi kaakesea bägrä liiyepu, teeme babo biname te lui ne mete ire atwi kaakesea pa yääcärepi teeme nuuja kaakesea bägrä bine teeme deedei kupae toracarage padare cabu ceerame. ");
INSERT INTO bon_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tabe babo biname te piba nuuja cewe me pa lädepi. Yoo, babo miiji, babo gege pui kaakesea bägrä tääpume, teeme babo biname lui ne cängenarage kaakesea cabu pa jääpänepi teeme acnenuta padare cabu. ");
INSERT INTO bon_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yoo, cane weebibine jijenininine egä pui babo biname te piba teebine pa jaajepi iyeta teeme gwidape bine ire atwemame. ");
INSERT INTO bon_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yepä, pui kaakesea bägrä te liba lajuge egä, ‘Cäme babo biname te pama lica wata pa tacnenutepi,’ piba nuuja kaakesea ngulebägrä imäbägrä bine pa yaatemeläjemepi, bucurage deedei pa läbitepi, sice pa yäänäjemepi, siige sice buduma pa läbitepi. ");
INSERT INTO bon_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yoo, pui babo biname te liba pa tatyaramtepi, kaakesea bägrä piba cälu te pa jäätepi, ingle tabe teeme acnenuta padare umle lica ge. Babo biname te piba teebine pa yaaglepi, pa yaajarepi muye puupu cabu me, mene ätecija cäco biname cina luma cirege lenaja. ");
INSERT INTO bon_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yoo, lui kaakesea bägrä te umle ge teeme babo biname ngena kaakesea tääpume singi tabe wawename, yepä tabe lica amacetnäjige pui kaakesea wawename, babo biname te teebine mäpu cmecme ca pa yaatemeläjepi. ");
INSERT INTO bon_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yepä, kaakesea bägrä lui te umle lica ge teeme babo biname ngena kaakesea tääpume singi tabe pui ne wawename, piba teeme umle cäco name pi tabe buduma mule jaawenuge, lui tääpume teebine miiji ge atemeläja, piba teeme babo biname teebine däägu pa yaatemeläjepi. Yoo, lui biname ne bucurage gwidape ituge ceera, bucurage gwidape cuta teeme bau ca pa saacwetnemepi, piiyepu lui biname ne ire atwi kaakesea tääpume itu jaajepi, tabe miiji teeme kaakesea mage cängenarage wawename.” ");
INSERT INTO bon_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yeesu cuta jejemige egä, “Cane tädujine ai gawecewe ne muye ca abotame. Cane baborage singi egä pui muye te gije tabacitumi ayime. ");
INSERT INTO bon_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yepä, niinäce gaabe cane miiji mäpurage padare cabu abacitame, epu pana abacita biname liiyepu lui te niiye bora liiglenutuge äcisejame, peei name pi cane ngenecu mäpu cama nanajenige page, ngälu peei mäpu cabu ca pa lasatepene. ");
INSERT INTO bon_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nää, weene apu jingenininige egä cane tädujine poode ne ai gawecewe cabu acaname? Eewe, cane weebibine jijenininine egä cane lica poode ne secanujine, yepä biname cina maramara me pagege äbita cäme name pi. ");
INSERT INTO bon_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yoo, ai padare cabu ca, biname lui cina cebine nätrungenisi piiyepu teeme ätrunga cäco binamewale, teepi maramara pa läbitipesi. Faib biname yepä mete cabu ca teepi neeneni tomi pa jaawenemepesi: nesae cina mara me pagege äbita nuuja neeneni cabu ca, piiyepu neeneni cina mara me pagege äbita pui nesae cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Babe cina mara me pa läbitipesi teeme imäbägrä cabu ca, piiyepu mage cina mara me pa läbitipesi teeme ngulebägrä cabu ca, cuta piiyepu cnaatete cina teepi maramara me pa läbitipesi.” ");
INSERT INTO bon_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeesu biname bine jejemige egä, “Weene liba cäsäcäsä carbe ne jääpänuye ciiye poto ca tädenige, weene piba jiicuye egä, ‘Ngupe te tädenige aimopo,’ siige pepu läbituge. ");
INSERT INTO bon_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Piiyepu weene liba uule buuwe jääpänuye, weene piba jiicuye egä, ‘Bimu nuunu me pa läbitege,’ siige pepu läbituge. ");
INSERT INTO bon_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Weene walya umleumle biname gemi! Weene umle gemi gawe piiyepu dume cabu ca bimu ne opo awatname, yepä weene äblicäco gemi opo awatna page ai padare cabu lui mule cina äbitininisi, teepi ngena tääpu memi.” ");
INSERT INTO bon_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Weene ngenome lica weemämu atranineye ngena mule gemi conocäco wawename? ");
INSERT INTO bon_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yoo, nuuja biname te liba singi weeme yepä ne ablaweja puupu cabu me acaname, pui neeneni liba gaabe cabu otni, tabe miiji apicetnera pui nuuja ne puma gaabe cabu je poode wawename. Piba pui biname te lica teebine yaacanuge ablaweja biname me opo gaabe me, cuta piba ablaweja biname te teebine teeme ätityera biname me ime cabu lica yaacituge krokeciiye mete bora äsinglentame. ");
INSERT INTO bon_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cane weebibine jijenininine egä tabe liba krokeciiye mete me labacituge, tabe peema cita ca lica tasatuge, ngälu iyeta pui rarekaake yääcäruge lui teeme conocono mule me daremu.” ");
INSERT INTO bon_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pui padare cabu puga ge poto biname lui cina Yeesu ne umle jewenisi yepä mäpu mule poto cidi me. Teepi jejisi egä Mopeyame Pilato te poto Israela biname bine Galilaya probins cabu ca eglecimige iiwäreja mete caale bora je, teepi liba yiiwäräjisi Acejiyame ne. ");
INSERT INTO bon_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeesu piba teebibine itemlemige egä, “Weene lipu ngene jotwananiniye, nää peei Galilaya biname cina baborage niiya itu tewenumesi nuuja Galilaya biname bime cabu ca, ingle teepi pepu budre ne tepänumesi? Eewe pepu lica ge. ");
INSERT INTO bon_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cane weebibine jijenininine egä weene liba lica atatrongäripeye weeme niiya mule cabu ca, piba weene iyeta niiya budre ne pa jepänepeye. ");
INSERT INTO bon_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Piiyepu, weene pui eitin Siloama cewe biname bime poto cidi me ngene jotwananineye, lui cina budre ne itu jääpänepesi cabu me lecarage mete te teeme cabu liba itu saatramepi. Nää, weene apu jingenininige egä teepi niiyarage biname gemi iyeta nuuja biname cabu ca lui cina Yerusalema babo cewe cabu icrajenige? ");
INSERT INTO bon_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eewe, teeme niiya baborage lica ge weeme cabu ca. Cane weebibine jijenininine egä weene liba lica atatrongäripeye weeme niiya mule cabu ca, piba weene iyeta niiya budre ne pa jepänepeye.” ");
INSERT INTO bon_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yeesu piba jiicemige ai ngene ca agli mene biname bine umle wawename egä Acejiyame te matikolä padare taatu ecärenemige teepi teeme ireclota cängena amacetnäjame. Teeme mene apu ge, “Yepä biname teeme piigi uli puga ge teeme calwacupi cabu je. Yoo, nuuja taje tabe piigi kuu tääpume ädige, yepä kuu lica jepänige. ");
INSERT INTO bon_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tabe puma cita ca teeme calwacupi kaakesea biname ne jejige egä, ‘Ai uli jepäni! Cane liba aima twaatnepene nesae kämäge cama, kuu bine jäärngemepene, yepä lica jääpänemepene. Ai uli ne irgi! Miiji lica ai gawe cabu papa kuu cäco lenajame!’ ");
INSERT INTO bon_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yepä, calwacupi kaakesea biname te jejige egä, ‘Babo biname, ai yepä kämäge tääpume ebmali. Cane ai gome gawe calwacalwa pa jaawenepene, piiyepu kau bime liiya ca pa jääsicnepene uli ingle ne. ");
INSERT INTO bon_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ai liba kuu bine pa jääpänemepi nuuja kämäge, piba babo miiji gyene, yepä liba kuu cäco pa yaanajepi, piba pagege ärgi.’” ");
INSERT INTO bon_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yepä Sabade bimu cabu, Yeesu biname bine ebiberäjemige teeme abasecretna mete cabu je. ");
INSERT INTO bon_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Puga ge yepä magebi lui te niiya cable cama waanajenanepi eitin kämäge cama. Tabe äpednu-teji uuwe kukuku totnäjumi, ingle tabe äblicäco conocäco aclajuta. ");
INSERT INTO bon_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yeesu liba teebine jopänige, tosoglicige teeme bau otnime, piba jojige egä, “Magebi, maane pita cabu ca miiji bäbitite!” ");
INSERT INTO bon_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tabe ime bine teeme papa cabu aacitige, siige magebi te piba taatu conocäco joclajutige, Acejiyame ne piba ewepyeräjige. ");
INSERT INTO bon_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yepä, pui abasecretna mete babo biname te claabe me äbitige, ingle Yeesu lipu magebi ne omacetnäjige Sabade bimu cabu. Tabe abasecretna biname bine jejemige egä, “Mime siks bimu piti nemi kaakesea tääpume; weene miiji pui bimu cabu weeme tääpe amacetnäja tääpume otnime, yepä Sabade bimu cabu gone!” ");
INSERT INTO bon_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yageyame teebine jejige egä, “Maane walya biname gäte! Weene umle gemi weeme kau piiyepu dongki bine iibira piiyepu waadena niiye nänäjame Sabade bimu cabu. ");
INSERT INTO bon_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yoo, age tuna weeme biname, Abrahamo me kaakesaare gwene, Satani te lui ne eitin kämäge cama tocenenäjumi. Nää, cane miiji gäne Sabade bimu cabu peei pita cabu ca teebine miiji me wawename?” ");
INSERT INTO bon_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iyeta Yeesu me cubuyame cina ajiri me äbitininisi, teeme mene liba jitecijisi, yepä bucurage biname cina gege äbitininisi iyeta miijirage gwidape name pi tabe lui bine jewenanemige. ");
INSERT INTO bon_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeesu itemlemige egä, “Acejiyame me mule biname bine waadena tääpume lipu pana gyene? Cane lipu peei mule ne etonärenine weeme tääpume? ");
INSERT INTO bon_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Peei lui epu pana gyene mastad kuu gije liiyepu, biname te lui ne ecatige teeme calwacupi cabu jecnige. Pui gije uutige, uli pana äbitige, siige ele cina ciipe cabu teeme mete bine yaarangemusi. Pepu pana gyene Acejiyame me waadena mule, lui mastad kuu pana matikolärage, peei cabu ca uli pana babo me läbituge.” ");
INSERT INTO bon_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu cääri itemlemige egä, “Yoo, cane lipu Acejiyame me biname bine waadena mule weeme tääpume etonärenine? ");
INSERT INTO bon_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Peei lui epu pana gyene uutneca gwidape liiyepu, magebi te lui ne ecatige, baborage bulu cama elenglecäjige, ngälu siige peei iyeta te tuutnecuge.” ");
INSERT INTO bon_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeesu liba gaabe cabu ädige Yerusalema me, tabe cewe yepäyepä cabu biname bine ebiberäjemige. ");
INSERT INTO bon_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nuuja taje gaabe cabu yepä biname te teebine itemlige egä, “Babo biname, nää Acejiyame te nesae taatu biname bine niiya cabu ca pa yääsecräremepi?” Yeesu biname bine piba jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Weene kokre äbitipeye susurage grana cabu me äbäcname, ingle cane weebibine jijenininine egä bucurage biname cina naabe äbitininisi äbäcname. ");
INSERT INTO bon_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Padare te cire tädepi, mete yageyame te grana ne liba cire saarmepi. Piba weene liba mete kaakepoto ca cire inajipi, grana ne cire seyäjepeye, cire jejepeye egä, ‘Babo biname, grana ne tiitni cime tääpume!’ Yepä, tabe weebibine cire jiwecnistipi egä, ‘Cane umle lica gäne weene. Weene luma cita ca gemi?’ ");
INSERT INTO bon_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Weene piba cire jejepeye egä, ‘Cine ituge deedei äbita piiyepu niiye nänäja maane cama. Maane cime cewe cole puupu cabu itu nibiberäjipete.’ ");
INSERT INTO bon_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tabe puma cita ca cire jijipi egä, ‘Cane umle lica gäne weeme tääpume, weene luma cita ca gemi! Weene niiya mule biname, iyeta äyeblingineye cäme bau ca!’ ");
INSERT INTO bon_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Weene piba ele cire ingenitnipi piiyepu giricu cire etebecmepeye, liba Abrahamo, Isacako, Yakobu, piiyepu iyeta sasa mename biname bine cire jepänemepeye Acejiyame me waadena cabu ge, yepä weene äyeblingeji gemi. ");
INSERT INTO bon_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yoo, biname cina cire saaclepi bimu acita gome ca piiyepu bimu äpula gome ca, piiyepu kämäge poto ca piiyepu uule poto ca. Teepi cire ladnatärepi soriyomu tääpume Acejiyame me waadena padare cabu je. ");
INSERT INTO bon_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yoo, poto biname lui ingwe gaabe biname gemi page, teepi niinäce gaabe me cire läbitipesi pui padare cabu, cuta piiyepu poto lui niinäce gaabe biname gemi page, teepi ingwe gaabe me cire läbitipesi.” ");
INSERT INTO bon_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Puirage padare poto Parisea sigu biname cina Yeesu bau me seclige, jejisi egä, “Maane ama cita ca äyeblingti, nuuja gome ädi, ingle ai Probins Mopeyame Heroda singi meebine aglime.” ");
INSERT INTO bon_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeesu teebibine jejemige egä, “Naclege, pui angletneja biname ne jejeye egä, ‘Cane cäme kaakesea jewenenine: niiya cable bine iyecräjenenemine piiyepu pita biname bine emacetnäjenemine page piiyepu ciiyeciye, piba nesae bimu ingwe ca ai kaakesea ne pa yaapirepene.’ ");
INSERT INTO bon_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yoo, cane miiji cäme kaakesea gaabe cabu otni ai poto bimu cama, siige Yerusalema ne piba oomlaname, ingle iyeta Acejiyame me mename biname cina Yerusalema je teepi budre jääpänanusi.” ");
INSERT INTO bon_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yeesu piba ngenecu mäpu cama jiicige egä, “Yerusalema biname, Yerusalema biname, weene lui cina Acejiyame me mename biname bine yaaglecimuye, piiyepu kula ca jääbyecremuye lui bine weeme bau me ätyepäneji gemi! Bucurage padare cama, cane singi ituge weeme biname bine yepä gome waadena, epu pana paulo te lipu teeme plongo bine yepä gome jaabasecretnimuge taame ca ätrugerame, yepä weene singi lica ge. ");
INSERT INTO bon_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ire, weeme iiwäreja mete lui abmaläneji gyene Acejiyame bau ca. Cane weebibine page jijenininine egä weene cebine ingwe ca lica päpäna ngälu pui padare weene liba pa jiicepeye egä, ‘Miiji pa läbitege lui te Yageyame me ngii cabu tädenige.’” ");
INSERT INTO bon_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yepä Sabade bimu cabu, yepä Parisea sigu babo biname te Yeesu ne teeme mete me ala tesoglicige deedei tääpume. Puga iyeta biname cina teebine ire jetwanisi, ");
INSERT INTO bon_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ingle puga ge teeme opo gaabe yepä biname lui me ime piiyepu ernge ädreji ge. ");
INSERT INTO bon_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu puma cita ca cotre abiberäja biname piiyepu Parisea sigu biname bine itemlemige egä, “Mime cotre mene te lipu jiicenige, nää miiji gyene pita biname ne miiji me wawena Sabade bimu cabu, coo liiyepu?” ");
INSERT INTO bon_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yepä, teepi nuuja mene lica jejisi. Yeesu piba pui pita biname ne ecatige, teebine miiji me jewenige, siige jityepige. ");
INSERT INTO bon_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tabe piba peei biname bine jejemige egä, “Sabade bimu cabu weeme yepä me bägrä te, coo kau te, uugle cupicu bora me liba yaatramuge, tabe pui bimu cabu wata cuta saarpatuge, nää toraca?” ");
INSERT INTO bon_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Siige, teepi äblicäco nuuja mene teebine jaji. ");
INSERT INTO bon_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeesu biname bine jepänemige egä pui mete cabu lui cina deedei tääpume adnatäreji ge, teepi singi ge modamoda biname bime puupu cabu lenajame. Tabe peei name pi ai ngene ca agli mene teebibine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Yoo, biname te liba weebibine soriyomu tääpume ala tisoglicinuge, gone modamoda biname bime puupu cabu adnatera, ingle pama soriyomu ire atwi biname te nuuja biname ne cuta ala taasoglicuge, lui ge baborage weeme cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tabe piba weeme yepä ne pa jaajepi egä, ‘Agesa babo biname, teebine ai miijirage puupu ecäri.’ Piba weeme yepä te ajiri cama puupu ne saabmaluge, läduge papa biname cina luma yaacrajuge. ");
INSERT INTO bon_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yepä, weebibine liba ala tisoglicinisi soriyomu tääpume, weene papa biname bime puupu cabu ladnatärinuye. Piba soriyomu ire atwi biname te weebibine pa jijipi egä, ‘Ayo, cäme biname, ai miiji puupu cabu adnatame.’ Piba weene miiji opo pa päbitipeye nuuja biname bime opo gaabe. ");
INSERT INTO bon_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Siige, lui biname te singi teeme ngii babo me wawename, tabe matikolä me pa läbitepi, piiyepu lui biname te teeme ngii ne teemämu matikolä me jaawenuge, tabe babo ngii ne pagege päpäna.” ");
INSERT INTO bon_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Piba Yeesu te pui mete yageyame ne jejige egä, “Maane liba biname bine ala tasoglecemute määme mete me niiye nänäjame, coo deedei äbitame, gone määme binamewale, coo dogwe biname taatu ala tasoglecemute, ingle teepi piba meebine cuta pagege ala asogleca määme mule ne awecnistame. ");
INSERT INTO bon_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yepä, maane liba biname bine babo deedei tääpume ala tasoglecemute, maane miiji owecumete biname piiyepu tääpe niiyaniya biname, irecu määsumäsu biname, cuta piiyepu ernge niiya biname ala tasoglecemute. ");
INSERT INTO bon_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pepu biname cina äblicäco määme miiji mule ne daremu wawena. Piba maane Acejiyame bau ca miiji daremu ne cire jääpänepete, tabe liba conocäco biname bine budre cabu ca cire yaarpinärepi.” ");
INSERT INTO bon_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yepä te, pui biname cabu ca lui cina Yeesu cama deedei äbitininisi, Yeesu me ngene ca agli mene liba itecijige, teebine piba jejige egä, “Babo miijirage gyene teeme tääpume lui cina cabucewe je cire ladnatäripesi deedei tääpume Acejiyame luma biname bine yaawademuge.” ");
INSERT INTO bon_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeesu teebine ai nuuja ngene ca agli mene piba jejige egä, “Yepä, biname te babo soriyomu ne jewenige. Tabe bucurage biname bine ala tesoglecmige pui soriyomu cabu otnime. ");
INSERT INTO bon_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iyeta liba amacetnäjäneji ge soriyomu tääpume, tabe piba teeme kaakesea biname ne jityepige ala asogläcneji biname bine jajanename egä, ‘Weene iyeta naaclege, cane bamacetnäjine soriyomu tääpume’. ");
INSERT INTO bon_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yepä, iyeta lui bine ituge ala asogleca, teepi yepäyepä gije abacitinisi teeme singi gaabe bine aboclomäjame. Niinäce biname te mene jityepige pui kaakesea biname cama soriyomu yageyame bau me egä, ‘Owecu, cane äblicäco gäne otni, ingle cane gawe ne bii jeletnine. Page cane miiji otni peei ne päpäname.’ ");
INSERT INTO bon_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nuuja te mene jityepige egä, ‘Owecu, cane äblicäco gäne otni, ingle cane ten kau bine bii jeletnemine cäme kaakesea wawename. Cane page ädenine teeme kokre apicetnärame! ");
INSERT INTO bon_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Cuta nuuja te mene jityepige egä, ‘Owecu, cane äblicäco gäne otni, ingle cane coga ne bii bocatine.’ ");
INSERT INTO bon_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yoo, pui kaakesea biname te tacne-nutige, iyeta pui mene teeme babo biname ne jejige. Puma cita ca pui mete yageyame te claabe me äbitige, teeme kaakesea biname ne piba jejige egä, ‘Maane wata ädi ai babo cewe iyeta gaabe cabu ta, siige puma cita ca biname bine sewademepi aimopo: owecumete biname piiyepu tääpe niiya biname, ernge niiya biname, irecu määsumäsu biname iyeta sewademepi.’ ");
INSERT INTO bon_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Matikolä padare ingwe ca pui kaakesea biname te tacnenutige, jejige egä, ‘Babo biname, cine määme singi ne bii jewenisi, yepä puupu cuta pisi nyene.’ ");
INSERT INTO bon_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Soriyomu yageyame te piba teebine jejige egä, ‘Maane cewe cabu ca asati iyeta gaabe cabu ta, biname bine jejemepi cewe äbäcname, siige cäme mete te piba tapanenige. ");
INSERT INTO bon_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cane meebine naajenine egä pui niinäce ala asogläcneji biname bime cabu ca, nuuja te lica cäme deedei pa läbitepi!’” ");
INSERT INTO bon_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bucurage biname cina Yeesu cama otninisi. Tabe teeme bau me atatrongtige, jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Biname te liba cäme bau otni, tabe miiji teeme mage babe, coga bägrä, nanigane, cuta piiyepu teemämu, iyeta ingwe me acrana, tabe liba singi cäme biname me äbitame. ");
INSERT INTO bon_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tabe miiji teeme nuuja singi bine abmalame. Yoo, cane baarge uli cabu budre lipu pagege päpäna, tabe cuta miiji amacetnäjäneji lenaja mäpu cämiji pi päpäname. Lui te singi lica cebine pepu pana ingwe äcwime, tabe äblicäco cäme abiberäja bägrä me lenajame. ");
INSERT INTO bon_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yoo, niinäce cängena ngene jotwanani weeme yepä te, liba singi gyene cäme abiberäja bägrä me äbitame. Pui lui epu pana gyene biname liiyepu, lui te singi cabu me lecarage mete ne rarangame. Tabe niinäce ladnatuge, rarekaake poto cidi me mage ngene jwaatwananuge liba teeme rarekaake ibibi gyene pui mete ne ämlitame. ");
INSERT INTO bon_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tabe umle ge egä teeme rarekaake liba ibibi lica ge, tabe miiji mete kaake ne abmala. Piba iyeta biname lui cina päpäna, teepi teebine ngange pa yääcwäcnepesi egä, ");
INSERT INTO bon_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ai biname te mete ne gije jebacitige rara-ngame, yepä tabe ibibi lica gyene ämlitame!’ ");
INSERT INTO bon_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yoo, pepu pana gyene gawe mope biname te liba singi cubu iicaname nuuja gawe mope biname cama. Tabe niinäce ladnatuge, mage ngene jwaatwananuge egä teeme ten tausen cubu biname liba ibibi gemi cubu iicaname nuuja twenti tausen cubu biname cama lui cina saaclenuge. ");
INSERT INTO bon_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tabe liba ngene jwaatwananuge egä, ‘Cine äblicäco gemi!’ piba mename biname bine pa jäätyepemepi pui nuuja mope biname bau me, tabe liba cudecewe gyene, teebine ätemlame egä, ‘Mine miiji conocäco ngene atwanena pa jääpänago, piba poode ne wawename.’ ");
INSERT INTO bon_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yoo, pepu pana gyene weeme tääpume. Weene miiji cängena ngene atwanena niinäce gaabe me egä weene nää toraca singi gemi iyeta abmalame cäme tääpume? Weene liba singi lica gemi, weene piba äblicäco cäme abiberäja bägrä me lenajame.” ");
INSERT INTO bon_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yoo, ätrunga biname bime miijirage kaakesea pisi nyene ai gawecewe cabu, cuta caapereniiye tääpume miiji kaakesea pisi nyene, yepä teeme mite te liba lapiruge, siige ingwe ca äblicäco caapereniiye ne wawena mite me. ");
INSERT INTO bon_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Piba mite cäco teeme nuuja kaakesea lica birige, cuta gawe tääpume teeme kaakesea lica. Biname cina papa yaajarusi. Weeme liba tablame piti nemi ätecijame, itecijinege umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nuuja padare bucurage täks rarekaake uutecrena biname piiyepu nuuja conocono mule biname cina abasecretnige Yeesu me mene ätecijame. ");
INSERT INTO bon_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Piba Parisea sigu biname piiyepu cotre abiberäja biname cina mudru mene jiicemisi egä, “Ai biname te babo singi gyene conocono biname cama lenajame cuta piiyepu deedei äbitame ten cama!” ");
INSERT INTO bon_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Peei name pi Yeesu ai ngene ca agli mene teebibine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Weeme yepä me hanred maamoi liba piti nemi, piiyepu yepä maamoi te liba lapesaruge, tabe ngena jaawenuge? Tabe teeme nuuja naintinain maamoi bine yaabmalemuge baace cewe cabu, piba waatnetnäjuge pui yepä ne ärngime ngälu päpäname. ");
INSERT INTO bon_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Liba jääpänuge, baborage gege cama saatecwantuge teeme palace cabu, ");
INSERT INTO bon_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","saacanuge cewe me. Piba teeme binamewale bine ala tasogle-cmuge, teebibine jaajemuge egä, ‘Agesa cäme maamoi lui te tapesarumi, siige bii jepänine teebine. Mine gege pa läbitipago.’ ");
INSERT INTO bon_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yoo, yepä pana mule pisi nyene cabucewe je luma gege baborage birige yepä taatu conocono mule biname tääpume, lui teeme niiya mule cabu ca latatrongtuge. Cane weebibine jijenininine egä peei gege baborage birige nuuja gege cabu ca naintinain conocäco biname tääpume, lui bime singi lica gyene atatrongärame.” ");
INSERT INTO bon_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yoo, magebi me liba ten silba rarekaake piti nemi, siige yepä ne liba pa yaapesarepi, tabe ngena jaawenuge? Tabe lampa ne jaabotuge, mete ne yaapretnäjuge, iyeta poto ta cängena jäärnguge, ngälu siige jääpänuge. ");
INSERT INTO bon_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Liba jääpänuge, teeme binamewale bine gege cama ala taasoglecmuge, jaajemuge egä, ‘Agesa cäme rarekaake lui ne sepesarumene, bii jepänine!’ ");
INSERT INTO bon_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yoo pepu pana, cane weebibine jijenininine egä cabucewe je Acejiyame me mename seemo babo gege me läbitusi, yepä conocono mule biname te liba niiya mule cabu ca latatrongtuge.” ");
INSERT INTO bon_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu cuta ai mene jejemige: “Yepä, biname teeme neeneni imäbägrä puga ge. ");
INSERT INTO bon_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iganeyame te babe ne jejige egä, ‘Cäme babe, määme lui gwidape bine jebelanemi, cäme poto näcäri!’ Puma cita ca teeme babe te gwidape jebelanemige teeme neeneni bägrä tääpume. ");
INSERT INTO bon_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nesae bimu ingwe ca, igane te teeme gwidape tomi iyeta aletna tääpume ewademige, pui rarekaake cama piba abyemärige otnime cudecewe gawe cabu me. Tabe cudecewe me ädige, puma teeme rarekaake iyeta papapapa jimlemige. ");
INSERT INTO bon_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Liba teeme rarekaake bine epiremige, mage gane padare te pui gawe cabu me tatyaramtige. Tabe gwidape cäco enajige, ");
INSERT INTO bon_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","peei name pi kaakesea jepänige yepä pui gawe biname bau ca. Tabe teebine blome bime lenaja puupu me jityepige, blome bine ire atwime. ");
INSERT INTO bon_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Loolomecewe name pi tabe singi blome bime deedei ärwäjame; yepä, nuuja biname te teebine lica nuuja gwidape yääcäruge. ");
INSERT INTO bon_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Piba taatu teeme ngene atwanena te tatyaramtige, tabe jiicige egä, ‘Iyeta cäme babe me kaakesea bägrä bime deedei bucurage gemi, yepä cane budre mameta gäne deedei cäco! ");
INSERT INTO bon_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cane abyemärenine, cäme babe bau ädenine, teebine pa jaajepene egä, ‘Cäme babe, cane conocono mule itu tewenumene Acejiyame tääpume piiyepu määme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cane äblicäco gäne määme bägrä me cuta äbita, yepä määme kaakesea bägrä me cebine naweni.’ ");
INSERT INTO bon_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yoo, tabe piba abujängtige babe bau me acnenutame. Cudecewe ca teeme babe te teebine gaabe cabu tepänige. Tabe baborage owecu äbitige, teeme bägrä bau me uuwamige, teebine jejecletnäjige, lakace cabu jetecnige. ");
INSERT INTO bon_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Puma cita ca bägrä te babe ne jejige egä, ‘Cäme babe, cane conocono mule itu tewenumene Acejiyame tääpume piiyepu määme tääpume. Cane äblicäco gäne määme bägrä me cuta äbita.’ ");
INSERT INTO bon_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yepä, babe te kaakesea bägrä bine ala tesoglecmige, jejemige egä, ‘Wata, kirece miijirage cäbletääpe secaneye teeme asigrame. Oplacmeläja pana gwidape teeme ime kukluta cabu esigreye, cuta piiyepu ernge gwidape esigreye. ");
INSERT INTO bon_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Piba mime ngeerangera kau plongo ne secaneye aglime. Mine soriyomu ne gege name pi pa jaawenesi! ");
INSERT INTO bon_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ingle ai bägrä te budre pana itu läbitepi, yepä page ireclota gyene. Tabe mime bau ca lapesarepi, yepä page bii jepänisi.’ Siige, teepi soriyomu jewenisi. ");
INSERT INTO bon_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pui padare cabu naane te calwacupi cabu jage. Tabe liba tacnenutige, mete mameta liba tatyaramtige, siige giire uupera itecijige puma. ");
INSERT INTO bon_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tabe puma cita ca yepä kaakesea bägrä ne ala tesoglicige, itemlige egä, ‘Teepi ngena ne jewenenisi?’ ");
INSERT INTO bon_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pui kaakesea bägrä te jejige egä, ‘Määme igane te tatyaramtige page. Määme babe te nijinige ngeerangera kau plongo ne aglime, ingle teeme bägrä cängenarage bii tacnenutige.’ ");
INSERT INTO bon_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Siige, naane te claabe me äbitige, lica mete cabu me abacitige. Piba babe te tasatige, teebine jejige abacitame. ");
INSERT INTO bon_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naane te babe ne jejige egä, ‘Maane näätecijege! Iyeta kämäge gaabegabe cane baborage kaakesea määme tääpume jaawenune, iyeta määme singi cabu waatnune. Maane cäme tääpume ngena ituge wawena? Maane cebine gouti plongo licarage itu näcärepete cane soriyomu ne cäme ceegecege cama wawename! ");
INSERT INTO bon_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yepä, määme ai bägrä lui te määme gwidape bine papa itu yaapeseräjemepi eroero magebi cama, teeme rarekaake liba apirininisi, piba tacnenutige. Siige, maane ngeerangera kau plongo ne cuta teeme tääpume eglite!’ ");
INSERT INTO bon_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Babe te jejige egä, ‘Cäme bägrä, maane cane cama naanajenige, iyeta cäme gwidape lui määme nemi. ");
INSERT INTO bon_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yepä, mine miiji gemi ai soriyomu wawena gege äbitame, ingle määme igane te budre pana itu läbitepi, yepä page ireclota gyene. Tabe mime bau ca lämlitepi, page bii tacnenutige.’” ");
INSERT INTO bon_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu teeme abiberäja bägrä bine ai ngene ca agli mene jejemige egä, “Yepä dogwe biname me kaakesea bägrä puga ge teeme gwidape bine ire atwime. Tabe mene itecijige egä peei ire atwi kaakesea bägrä te teeme gwidape bine papa yaajaremuge. ");
INSERT INTO bon_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tabe pui kaakesea bägrä ne tesoglicige, jejige egä, ‘Cane ngena ne nätecijumi egä maane cäme gwidape bine papa me tewenemumete. Iyeta määme peba bine rarekaake piiyepu gwidape poto cidi me emacetnäjemi cäme ire me, ingle cane singi lica gäne maane cäme gwidape bine ingwe ca ire atwime.’ ");
INSERT INTO bon_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pui kaakesea biname teemämu jejige egä, ‘Cäme babo biname te cebine pa näyeblingtepi; cane ngena pa jaawenene? Cäme kokre ibibi lica gyene kaakesea wawename cäsu bine äplegecame, piiyepu cane ajiri gäne papa ätineräjame. ");
INSERT INTO bon_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yoo, cane umle gäne ngena ne wawename! Cane liba ai ne cängena jewenenine, cebine liba näyeblingtepi cäme ire atwi kaakesea cabu ca, piba cäme piti nemi binamewale cebine teeme mete cabu me nacananusi.’ ");
INSERT INTO bon_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Puma cita ca tabe iyeta biname bine tesoglecmige lui bime ngii piti nemi teeme peba cabu gwidape coo rarekaake awecna poto cidi me. Tabe niinäceyame ne itemlige egä, ‘Maane lija gwidape bine ituge waadena, yepä daremu camu gäte ceera?’ ");
INSERT INTO bon_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Biname te jejige egä, ‘Yepä hanred dram olibi migi cama itu yaawademepene.’ Pui ire atwi biname te piba teebine jejige egä, ‘Yoo, agesa peba pui acnema cama. Maane adnati wata yoogäri fifti taatu peei hanred me puupu cabu.’ ");
INSERT INTO bon_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pui ire atwi biname te cuta nuuja ne itemlige egä, ‘Maane cuta lija gwidape bine ituge waadena, yepä daremu camu gäte ceera?’ Pui biname te jejige egä, ‘Yepä tausen wiiti kuu baiko.’ Ire atwi biname te jejige, ‘Yoo, peba agesa pui acnema cama, eit hanred yoogäri peei tausen me puupu cabu!’ ");
INSERT INTO bon_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yoo, ingwe ca pui dogwe biname te teeme conocono kaakesea bägrä poto cidi me jiicige egä, ‘Mage umle gyene pui conocono biname te!’ Siige, peei conocono biname me mule cabu ca mine opo ewatneye egä ai gawecewe biname cina umle ge lipu nuuja teeme pana biname bine binamewale me wawename, yepä biname lui cina Acejiyame me apaclyera cabu yaacrajuge, nuuja taje teepi umle lica gemi nuuja biname bine teeme binamewale me wawena.” ");
INSERT INTO bon_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yeesu cuta jejemige egä, “Cane peei name pi weebibine jijenininine egä nuuja biname bine itityeräjemeye ai gawecewe me gwidape piiyepu rarekaake ca, teebibine binamewale me wawena weeme conocäco mule ca. Piba ai gawecewe iyeta teeme gwidape cama liba cirege apira, weeme puupu pisi nyene cabucewe je lenajame iyeteta ngälu cäco. ");
INSERT INTO bon_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yoo, biname lui te matimati gwidape cängena ire jaatwemuge, tabe cuta modamoda gwidape cängena ire jaatwemuge; cuta piiyepu biname lui te angletneja umle ge matimati gwidape poto cidi me, tabe cuta angletneja umle ge modamoda gwidape poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Peei name pi biname lui te ai gawecewe me gwidape bine cängenarage conocäco lica ire jaatwemuge, tabe cuta lipu Acejiyame me toraca gwidape bine cängenarage ire atwema. ");
INSERT INTO bon_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Cuta piiyepu biname te liba nuuja biname me gwidape bine cängena lica ire jaatwemuge, nuuja te lica teebine teemerage gwidape pa yääcärepi. ");
INSERT INTO bon_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yoo, kaakesea biname te äblicäco neeneni babo biname tääpume kaakesea wawena yepä padare cabu. Tabe yepä ne jäägyuge; nuuja tääpume singi läbituge. Tabe yepä ne opo gaabe me yaacituge, nuuja ne kaake ca sääcelyäruge. Weene äblicäco neeneni bine acenena: Acejiyame piiyepu rarekaake.” ");
INSERT INTO bon_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisea sigu biname cina Yeesu me mene itecijemige, siige teebine ngange ecwänisi, ingle teepi baborage singi rarekaake tääpume. ");
INSERT INTO bon_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeesu teebibine jejemige egä, “Weene peete nemi lui babo singi gemi biname cina weebibine päpäname egä, ‘conocäco biname,’ yepä Acejiyame umle gyene weeme ngenecu lipu gemi. Weene awepyeräja ne biname bau ca jääpänuye sinäme miiji mule name pi, yepä Acejiyame pui mule ne jäägyuge. ");
INSERT INTO bon_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moose lui Cotre Mene itu soogäremuji, piiyepu mename biname cina lui mene ituge oogära, peei mene cina weebibine ituge waadena ngälu Yoane niiye ca äciseja biname te tatyaramtige. Teeme padare cabu ca Miiji Mene jejananemisi egä Acejiyame te biname bine yaawademuge, siige iyeta biname cina kokre me äbitenininisi teeme waadena mule cabu me äbäcname. ");
INSERT INTO bon_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yepä, Cotre Mene me kaakesea cuta pisi nyene page, lica ituge äyeblingta; iyeta matimati cotre piti nemi page. Yoo, gawecewe piiyepu cabucewe teeme lenaja lipu lecarage, Acejiyame me Cotre Mene me lenaja pepu lecarage gyene. ");
INSERT INTO bon_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Page cuta pisi nyene cotre egä biname lui te coga ne jwäägyuge, piba nuuja coga ne waacatuge, tabe sargi ero mule ne jaawenuge; cuta pepu gyene biname lui te pui ägyeji magebi ne waacatuge, tabe cuta sargi ero mule ne jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Puga ge yepä dogwe biname lui te mararage ududi piiyepu bulubulu cäbletääpe bine lasigreräjuge. Tabe iyeta teeme singi gwidape iyeta bimu gaabegabe yaawadanemuge. ");
INSERT INTO bon_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cuta puga ge yepä owecumete biname, teeme ngii Lajaro, droobodrobo tääpe cama ge. Biname cina teebine yaacanusi pui dogwe biname me mete grana gome, ");
INSERT INTO bon_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ingle tabe singi deedei pacupacu ärwäja, lui cina dogwe biname me dade cabu ca saatrametnemuge. Yoo, drego cina waatninusi teeme gome teeme tääpe droobo aclotejame. ");
INSERT INTO bon_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Siige, pui owecumete biname te budre äbitige. Acejiyame me mename seemo cina piba teeme seemo ne ecanisi cabucewe me Abrahamo gome me. Pui dogwe biname te cuta budre äbitige, siige gape cabu ecitisi. ");
INSERT INTO bon_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tabe muye puupu cabu yaanajuge baborage pita cama. Puma cita ca tabe ire cabu me acitige, Abrahamo ne jepänige cudecewe ca, piiyepu Lajaro teeme gome puga ge. ");
INSERT INTO bon_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tabe babo tage ca jejige egä, ‘Cäme Babe Abrahamo! Cebine owecu naweni! Lajaro ne tityepi teeme ime kukluta niiye cabu iiglenutame cäme wätä ne gäbu wawename, ingle cane babo pita gäne ai muye puupu cabu!’ ");
INSERT INTO bon_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yepä, Abrahamo jejige egä, ‘Cäme bägrä, maane ngene jepecni määme gawecewe ireclota padare poto cidi me. Maane miijimiji gwidape cama naanajuge, yepä Lajaro me ireclota puga niiyarage ge. Page teeme lenaja miijirage gyene, yepä maane niiya cabu naanajenige. ");
INSERT INTO bon_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Cuta piiyepu, pisi nyene mime cole je baborage cäsu, biname te peei name pi ama cita ca äblicäco peeyeme otni, cuta peema cita ca biname cuta piiyepu äblicäco aimopo otni.’ ");
INSERT INTO bon_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Piba pui dogwe biname te cuta jejige egä, ‘Yoo, cäme babe, cane naajenine, owecu, Lajaro ne gawecewe cabu me jityepi cäme babe me mete me. ");
INSERT INTO bon_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cäme faib iganewale puma piti nemi. Lajaro ne jityepi teebibine umle mene jajime, teepi piba lica ai muye puupu cabu me otni.’ ");
INSERT INTO bon_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamo jejige egä, ‘Oogäräneji Mene piti nemi määme iganewale tääpume, Moose piiyepu sasa mename biname cina lui mene ituge oogära. Määme iganewale miiji gemi teeme peei mene ätecija.’ ");
INSERT INTO bon_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yepä, tabe jejige egä, ‘Cäme babe Abrahamo, peei mene taatu ibibi lica gyene, yepä biname te liba budre cabu ca teeme bau acnenutame, teepi piba teeme niiya mule cabu ca pa latatrongäripesi.’ ");
INSERT INTO bon_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yepä, Abrahamo jejige egä, ‘Teepi liba singi lica Moose piiyepu mename biname bime oogäräneji mene ätecijame, teepi cuta piiyepu biname ne lica ätecija tabe liba budre cabu ca acnenuta teebibine mene jajime.’” ");
INSERT INTO bon_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu teeme abiberäja bägrä bine jejemige egä, “Yoo, maramara gwidape cina saacluge lui biname bine jaawenemusi niiya mule wawenecame, yepä babo niiyarage gyene biname tääpume lui te pui gwidape bine saawademuge. ");
INSERT INTO bon_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pepu biname mäpu kula ne liba teeme singicace cabu jaaglotusi, siige malu cabu yaajarusi budre me, peei mäpu lui plowa birige pui mäpu cabu ca tabe lui ne cirege päpäna liba ai matimati bägrä yepä ne niiya mule cabu yaacanuge. ");
INSERT INTO bon_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Peei name pi cängena inajininuge!” “Yoo, määme biname te liba niiya mule jaawenuge, maane teebine umle mene jaajute. Tabe liba tatatrongtuge pui niiya cabu ca, maane miiji teeme niiya mule äyeblingta määme ngene atwanena cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yoo, tabe liba meebine niiya naawenanuge cuta seben gääbu yepä bimu cabu, cuta seben gääbu määme bau me liba lacnenutanuge, naajananuge egä, ‘Cäme ngenecu te batatrongtige,’ piba maane miiji iyeta teeme niiya äyeblenga määme ngene atwanena cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Puma cita ca pui twelb ätyepäneji biname cina Yageyame Yeesu ne jejisi egä, “Cime ätrunga babo me jeweni!” ");
INSERT INTO bon_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tabe Yageyame te jejemige egä, “Weeme ätrunga liba epu pana baborage gyene ai matikolä mastad kuu gije liiyepu, weene piba ibibi gemi ai uli ne jaji egä, ‘Määmämu ai gawe cabu ca äpäcuti iyeta braju cama, piba malu cabu acni määmämu!’ Siige, ai uli te weeme mene piba pa jaawenepi.” ");
INSERT INTO bon_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Weeme yepä me kaakesea bägrä liba pisi nyene, teebine liba jäätyepuge calwa wawename, coo nuuja taje maamoi ire atwime, tabe liba kaakesea cabu ca mete me tiinuge, teeme babo biname te lica teebine piba jaajuge egä, ‘Määme deedei agesa.’ ");
INSERT INTO bon_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yepä, tabe teebine jaajuge egä, ‘Cäme deedei nawenemi, piba määmämu amacetnäji cäme deedei piiyepu niiye ceerame. Peei ingwe ca, maane määme deedei äbiti piiyepu niiye nani.’ ");
INSERT INTO bon_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nää, pui babo biname teeme kaakesea bägrä ne eso pa jaajepi liba teeme mene cängena jaawenemuge? Eewe, pama lica! ");
INSERT INTO bon_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Weene pepu pana kaakesea bägrä gemi. Weene liba iyeta Acejiyame me singi kaakesea cängena ituge wawena, piba gone singi awepyeräja teeme bau ca päpäname, yepä apu jiicuye egä, ‘Cine kaakesea bägrä gemi; cine cime kaakesea taatu bine jaawenemusi.’” ");
INSERT INTO bon_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeesu liba Yerusalema me ädige, tabe Galilaya piiyepu Samariya gawe teeme ngälugaabe cabu ädige. ");
INSERT INTO bon_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tabe liba yepä cewe me atyaramtige, ten biname bine opopa jewenemige lui cina niiyarage tääpe pita, lepera pita, cama ge. Teepi cudecewe ca imyemutenige, ");
INSERT INTO bon_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","puma cita ca babo tage ca jejisi egä, “Yeesu, Babo Biname, cibibine owecu niwenini!” ");
INSERT INTO bon_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeesu teebibine jepänemige, jejemige egä, “Naaclege modamoda iiwäreja biname bime bau me teepi weeme tääpe awatnejame egä miiji.” Siige, gaabe cabu teepi liba eclige, teeme tääpe iyeta miiji me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Teeme yepä te liba jepänige egä teeme tääpe miiji ge, piba tacnenutige Yeesu bau me, Acejiyame ne babo tage ca ewepyeräjige. ");
INSERT INTO bon_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tabe teemämu gawe cabu ajarige Yeesu me ernge gome, teebine baborage eso ecärige. Pui biname lica Israela biname, yepä Samariya gawe biname ge. ");
INSERT INTO bon_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeesu biname bine itemlemige egä, “Cane ten biname bine miiji me jewenemine, cije nain cina lete nemi? ");
INSERT INTO bon_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nää, nuuja biname te lica tacnige Acejiyame ne awepyeräjame, yepä ai catecewe biname taatu?” ");
INSERT INTO bon_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Siige, Yeesu teebine jejige egä, “Abujängti, ädi määme gaabe cabu. Määme ätrunga te meebine miiji me bii naawenige.” ");
INSERT INTO bon_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yoo, poto Parisea sigu biname cina Yeesu ne itemlisi egä Acejiyame me biname bine waadena padare te liba pa tatyaramtepi? Tabe jejemige egä, “Yoo, biname cina äblicäco Acejiyame me biname bine waadena padare ne irecu ca päpäna egä tatyaramtenige. ");
INSERT INTO bon_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Biname cina äblicäco apu iicana egä, ‘Ire, age sena!’, coo ‘Peese nyene!’, ingle Acejiyame te weebibine iwadininige weeme ngenecu cabu.” ");
INSERT INTO bon_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tabe piba teeme abiberäja bägrä bine jejemige egä, “Padare te pa tädepi weene piba babo singi cane cama lenajame yepä bimu taatu, yepä cane lui te Acejiyame bau ca tädujine, biname me äbitujine, cane ama lica pagege pui bimu cabu. ");
INSERT INTO bon_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Biname cina piba weebibine pa jijipesi egä, ‘Tabe peese,’ coo ‘Tabe age sena,’ yepä teeme ingwe ca gone naacluge cebine ärngime, ");
INSERT INTO bon_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ingle cäme acnenuta te liba cire tatyaramtepi, weene piba cängena umle cire äbitipeye. Yoo, pamlepamle te dume cabu lipu tuungepmeläjuge, iyeta poto yaapaclyeräjuge, cane lui te Acejiyame bau ca tädujine, biname me äbitujine, cäme acnenuta te cuta pepu pana cire läbitepi. ");
INSERT INTO bon_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yepä, peei te cäro camuge äbita; cane miiji niinäce babo mäpurage padare ne päpäna, piiyepu ai padare me biname cina cebine pa nägyepesi. ");
INSERT INTO bon_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yoo, ujarage Nooa me padare cabu lipu itu äbituji, pepu pana cäme acnenuta padare cabu cirege äbita. ");
INSERT INTO bon_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pui padare iyeta biname cina deedei täbitenäjumesi, niiye senäjenäjemumesi, piiyepu biname cina tawadrecanimumesi, ngälu pui bimu cabu Nooa liba baborage buto cabu me acenutuji. Siige, babo igi te piba täduji iyeta biname bine eglecimuji. ");
INSERT INTO bon_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yoo, Loota me padare cabu lipu itu äbituji, cuta pepu pana cäme acnenuta padare cabu cirege äbita. Iyeta biname cina deedei täbitenäjumesi, niiye senäjenäjemumesi, gwidape teletne-mäjemumesi, gije sitememäjumesi, piiyepu mete bine serangemäjumesi, ");
INSERT INTO bon_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ngälu pui bimu Loota te Sodoma cewe ne liba sebmaluji. Piba muye wiiryere piiyepu matimati nuunurage kula cina cabucewe ca sitrametnemuji, siige iyeta biname bine eglecimujisi. ");
INSERT INTO bon_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yoo, biname cina pepu pana mule cire jaawenemepesi cäme acnenuta bimu cabu, teepi liba iyeteta umle cire läbitipesi egä cane Acejiyame bau ca gäne. ");
INSERT INTO bon_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pui bimu cabu, lui biname te mete toro cabu, lui puupu cabu yaanajuge, tabe miiji lica mete me abacita teeme gwidape äsecrerame, cuta piiyepu biname lui te calwacupi cabu gyene, tabe miiji lica cewe me acnenutame. ");
INSERT INTO bon_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loota me coga poto cidi me ngene jotwananineye, tabe lipu teeme ingwe gaabe me ire acituji. Yoo, pui bimu cabu gone pepu pana äbita! ");
INSERT INTO bon_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Lui biname te singi teeme ai gawecewe ireclota ne teemämu ire atwime, ingle tabe wälu ge teeme ireclota ne apeserame, tabe toraca ireclota ne cire yaapesarepi; yepä, lui biname te teeme ireclota ne cäme tääpume yaapesaruge, tabe toraca ireclota ne cire jääpänepi. ");
INSERT INTO bon_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yoo, cane weebibine jijinininine egä cäme acnenuta padare cabu, ciiye padare liba, neeneni biname cina piba yepä puupu cabu ute wagräsi: yepä ne cire yaacatepesi, nuuja ne cire yaabmalepesi. ");
INSERT INTO bon_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bimu padare liba, neeneni magebi cina wiiti kuu bine kula ca cire jäämulecemepäsi, yepä ne cire waacatepesi, nuuja ne cire waabmalepesi. ");
INSERT INTO bon_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Neeneni rooriye cina babo calwacupi cabu kaakesea cire jaawenemepäsi: yepä ne cire yaacatepesi, nuuja ne cire yaabmalepesi.” ");
INSERT INTO bon_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Siige, abiberäja bägrä cina piba teebine itemlisi egä, “Yageyame peei te luma cire läbitepi?” Yeesu teebibine jejemige egä, “Budrekaake luma, sändäyame cina piiyeme labasecretnuge. Pepu pana pui padare te liba cire tatyaramtepi, weene piba umle cire äbitipeye.” ");
INSERT INTO bon_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Puma cita ca Yeesu teeme abiberäja bägrä bine jejemige ai ngene ca agli mene umle ceerame egä teepi durau gone äbita Acejiyame ne awejename. ");
INSERT INTO bon_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tabe apu jiicige egä, “Yepä cewe cabu puga ge ablaweja biname lui te nuuja singi lica ge Acejiyame tääpume, cuta piiyepu nuuja singi lica ge biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cuta puga ge cuubla, lui te ablaweja biname bau me jäje waatnuge jajanename egä, ‘Cebine nätityäri cäme cubuyame cabu ca uutrutame.’ ");
INSERT INTO bon_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Siige, leca padare cabu pui ablaweja biname te singi lica teebine ätityerame, yepä ingwe ca tabe teemämu jiicige egä, ‘Cane nuuja singi lica gäne biname bime tääpume, coo piiyepu Acejiyame tääpume, ");
INSERT INTO bon_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yepä ai magebi te cebine mage tii nawenenige, peei name pi cane teebine pa wäätityärepene. Cane liba lica utityärenine, tabe jäje pa twacnepi aima, ngälu siige gloose te cebine pa noomlepi.’” ");
INSERT INTO bon_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Siige, Yageyame piba jejemige egä, “Yoo, weene pui conocono ablaweja biname me mene jitecijeye. Weene lipu ngene jotwa-naniniye? ");
INSERT INTO bon_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pui conocono biname te liba cuubla ne utityärige teeme tii name pi, Acejiyame lui conocäco gyene, tabe piba teemerage binamewale bine pa yäätityäremepi lui cina teebine ciiye bimu cama yaawejanusi? Nää, tabe weebibine wata lica pa itityäripi? ");
INSERT INTO bon_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cane weebibine jijenininine egä tabe wata pa itityäripi conocäco päpäname. Yepä, cane lui te Acejiyame bau ca tädujine, biname me äbitujine, cane liba cire tacnenutepene, nää cane biname bine ätrunga cama cire jääpänemepene, coo lica?” ");
INSERT INTO bon_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeesu cuta ngene ca agli mene biname bine jejemige lui cina apu jaangemuge egä teepi conocäco biname gemi, cuta peei name pi iyeta nuuja biname bine gawe me yaapremalemusi. ");
INSERT INTO bon_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tabe apu jiicige egä, “Neeneni biname cina iiwäreja mete me aacluji irecu ätumutame. Yepä lui Parisea sigu biname ge, cuta nuuja lui täks rarekaake uutecrena biname ge. ");
INSERT INTO bon_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisea sigu biname te jeclajutige, teeme poto cidi me irecu ätumutige egä, ‘Acejiyame, cane meebine eso nääcärenine egä cane lica nuuja biname bime pana gäne, lui cina biname bime gwidape juutecranemusi, nuuja conocono mule jaawenemusi, coo piiyepu sargi mule jaawenemusi. Yoo, cane meebine eso nääcärenine egä cane lica gäne ai täks rarekaake uutecrena biname pana. ");
INSERT INTO bon_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iyeta wiik ngalebora cane neeneni bimu cama deedei cäco nanajuge; piiyepu iyeta cäme ten rarekaake cabu ca cane yepä nääcärune, siige.’ ");
INSERT INTO bon_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yepä, pui täks rarekaake uutecrena biname te matikolä cudecewe padare cuta jeclajutige. Tabe cabu me lica ire äbitige, yepä ergo ecirige irecu ätumutame, cuta jejige egä, ‘Acejiyame, cebine owecu nawenepi, ingle cane conocono biname gäne.’ ");
INSERT INTO bon_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yoo siige, cane weebibine jijenininine egä pui täks rarekaake uutecrena biname te Acejiyame bau ca kälyä jepänige teeme niiyaniya mule cabu ca, siige pui conocäco cama acnenutige mete me, yepä pui nuuja te kälyä ne lica jepänige. Ai ingle naace gyene lui biname te teemämu babo me läbituge, tabe matikolä me pagege äbita, cuta piiyepu lui biname te teemämu matikolä pana me läbituge, tabe babo me pagege äbita.” ");
INSERT INTO bon_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Poto biname cina teeme matimati bägrä bine Yeesu bau me sewademisi tabe ime teeme papa cabu acitename bägrä bime miiji tääpume. Yepä, abiberäja bägrä cina peei mule ne liba jepänisi, teepi piba biname bine jicnecimisi. ");
INSERT INTO bon_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yepä, Yeesu te bägrä bine teeme bau me ala tesoglecmige, cuta abiberäja bägrä bine jejemige egä, “Bägrä cina saaclege cäme bau me. Gone jiibemuye, ingle lui biname bime ätrunga ai matimati bägrä pana me, Acejiyame teebibine yaawademuge. ");
INSERT INTO bon_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cane weebibine toraca jijenininine egä lui biname te singi lica gyene Acejiyame me waadena ne matikolä bägrä pana yaacatuge, tabe licarage abacitame.” ");
INSERT INTO bon_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yepä Israela babo biname te Yeesu ne itemlige egä, “Miijirage abiberäja biname, cane ngena ne miiji wawena iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu teebine jejige egä, “Maane ngenome cebine nainite miijirage ca? Acejiyame taatu miijirage gyene, nuuja cina miijirage lica gemi. ");
INSERT INTO bon_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Maane cotre mene umle gäte egä: ‘Sargi mule gone; gone biname ne budre me agli; gone gwidape ero; walya aitneja gone; mage babe bine miiji opo gaabe me acita.’” ");
INSERT INTO bon_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Siige, pui biname te jejige egä, “Cane bägrä cabu ca iyeta peei cotre bine itu sicwetnanemumene.” ");
INSERT INTO bon_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Siige, Yeesu liba teeme mene itecijige, teebine piba jejige egä, “Yoo, määme yepä gwidape pisi nyene wawename. Määme gwidape iyeta ewademepi aletna tääpume, pui rarekaake owecumete biname bine ecäranemepi, maane peema cita ca miijimiji gwidape bine cirege päpäna cabucewe je. Piba tädepi cane cama otnime.” ");
INSERT INTO bon_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yepä, peei biname te liba Yeesu me mene itecijige, tabe babo ngenecu mäpu me äbitige, ingle tabe babo dogwe biname ge. Tabe singi lica ge teeme gwidape bine abmaläcema Yeesu cama otnime. ");
INSERT INTO bon_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeesu jepänige egä tabe babo ngenecu mäpu ge, piba jiicige egä, “Mage mäpu gyene dogwe biname cina Acejiyame me waadena cabu äbäcname! ");
INSERT INTO bon_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Baborage gwidape kamela cibu pana, tabe äblicäco matikolä gaabe epu pana nilo bora me abacita, siige asata, yepä mäpurage gyene cuta peei cabu ca dogwe biname te Acejiyame me waadena cabu abacitame.” ");
INSERT INTO bon_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Biname lui cina peei mene itecijemige, teepi piba Yeesu ne itemlisi egä, “Piba laati te miiji gyene teeme niiya cabu ca asata iyeteta ireclota ne päpäname?” ");
INSERT INTO bon_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu jejemige egä, “Biname cina äblicäco teemämu peei ne wawena, yepä Acejiyame te miiji gyene iyeta gwidape bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peteru piba jejige egä, “Cije cine lipu gemi? Cine iyeta ituge abmala maane cama otnime.” ");
INSERT INTO bon_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu teebibine jejemige egä, “Yoo, cane toraca mene jijenininine egä lui biname te cewe ne saabmaluge piiyepu coga, bägrä, mage, babe, naane, iganewale saabmaläcemuge Acejiyame me biname bine waadena name pi, ");
INSERT INTO bon_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pui biname bucurage cerämu tuwängle pa jääpänemepi ai padare cabu, cuta piiyepu ciige padare cabu iyeteta ireclota ne cire jääpänepi.” ");
INSERT INTO bon_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeesu teeme twelb abiberäja bägrä bine biname bime sobe cabu ca mara me ewademige, jejemige egä, “Itecijinege, mine Yerusalema cewe me naclenige. Puma iyeta mene sasa mename biname cina lui ituge oogära cäme poto cidi me toraca me pa läbitipesi. Cane lui te Acejiyame bau ca tädujine, biname me äbitujine, ");
INSERT INTO bon_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","cebine nuuja gawe cabu ca biname bime ime cabu pa nacitepesi. Teepi cebine ätutena pana pa nawenepesi, pa näcnecepesi, piiyepu mote ca pa nätyewepesi. ");
INSERT INTO bon_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Teepi cebine pa nadnanepesi, cuta budre me pa naglepesi, yepä nesae me lui bimu cabu cane pa larpinantepene cääri ireclota me.” ");
INSERT INTO bon_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Siige, abiberäja bägrä cina cängena lica opo ewatnisi iyeta peei mene bine, ingle teeme aboclomta lui ämlitäneji ge teeme bau ca, peei name pi teeme tääpume pajecu lica ge. ");
INSERT INTO bon_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeesu liba Yeriko cewe mameta me atyaramtige, gaabe wajwa je yepä irecu määsumäsu biname adnatäneji enajige, gwidape piiyepu rarekaake tääpume yäätineräjemuge. ");
INSERT INTO bon_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pui biname te liba biname guugla itecijige, itemlemige egä, “Ngena te äbitenige?” ");
INSERT INTO bon_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Biname cina teebine jejisi egä, “Yeesu Nasareta ceweyame te mime cewe ne isuplingtenige.” ");
INSERT INTO bon_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tabe puma cita ca babo tage ca jejige egä, “Yeesu, Daawida me Kaakesaare, cebine owecu nawenepi!” ");
INSERT INTO bon_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Niinäce gaabe biname cina teebine eblawisi, jejisi bojä agime. Yepä, tabe cuta baborage tage ca jejige egä, “Daawida me Kaakesaare, cebine owecu nawenepi!” ");
INSERT INTO bon_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeesu imyemutige, mene jejemige irecu määsumäsu biname ne teeme bau me acaname. Tabe liba teeme mameta me tädige, Yeesu teebine itemlige egä, ");
INSERT INTO bon_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Maane ngeno mäte singi cane määme tääpume wawename?” Tabe jejige egä, “Babo Biname, cane singi cääri irecu asatame.” ");
INSERT INTO bon_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu piba teebine jejige egä, “Irecu aasati! Määme ätrunga te miiji bii naawenige meebine.” ");
INSERT INTO bon_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Piba taatu tabe irecu aasatige päpäname. Tabe piba Yeesu ne ingwe icwige, Acejiyame ne eso ecäranige. Siige, biname cina jepänisi, piba iyeta Acejiyame ne ewepyeräjisi. ");
INSERT INTO bon_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeesu peema cita ca Yeriko cewe me abacitige, piiyepu gaabe ta isuplingtenige. ");
INSERT INTO bon_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Cewe cabu puga ge täks rarekaake uutecrena babo biname, ngii Sakaiyo, tabe lui mage dogwe biname ge. ");
INSERT INTO bon_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yoo, Sakaiyo baborage singi Yeesu ne irecu ca päpäname, yepä äblicäco ge, biname tomi name pi, ingle tabe tuube biname ge, piiyepu pui niinäce gaabe biname cina teebine jilyengisi. ");
INSERT INTO bon_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tabe peei name pi niinäce gaabe me uuwamige, sukumuro piigi uli ne jegelige Yeesu ne puma cita ca päpäname, tabe peei gaabe cabu liba tädige. ");
INSERT INTO bon_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yeesu liba teeme mameta me atyaramtige, cabu me ire acitige, jepänige, piba jejige egä, “Sakaiyo, wata täini! cane määme mete cabu page nanajenige.” ");
INSERT INTO bon_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Siige, Sakaiyo wata täinige, babo gege cama teebine teeme mete me ecanige. ");
INSERT INTO bon_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iyeta biname liba peei ne jepänisi, Yeesu ne jiicetnisi egä, “Ai biname te singi conocono biname ne ädärame. Tabe teeme mete cabu me cuta abacitenige!” ");
INSERT INTO bon_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mete je Sakaiyo abujängtige, Yageyame ne jejige egä, “Babo biname, cebine näteciji. Cane cebo iyeta cäme gwidape cabu ca pa yääcäremepene owecumete biname bine, cuta piiyepu cane liba nuuja biname bime rarekaake angletneja mule ca itu yaawadanemepene, cane fooa rarekaake bine pa yaawecnepene tuwängle me iyeta yepäyepä tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Piba Yeesu teebine jejige egä, “Yoo, Acejiyame te ai mete biname bine teeme niiya cabu ca page bisecräremige, ingle Sakaiyo lui Abrahamo me kaakesaare lui ituge apesera, yepä page bii tacnenutige teeme ingle cabu me. ");
INSERT INTO bon_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yoo, cane lui Acejiyame bau ca ätyepäneji gäne biname me äbitame, cane ai tääpume tädujine: apesäreji biname bine ärngemame teeme niiya mule cabu ca äsecrerame, piba Acejiyame bau me waadename.” ");
INSERT INTO bon_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Siige, gaabe cabu biname cina Yeesu me mene itecijemige. Tabe mameta ge atyaramta Yerusalema cewe cabu me, piiyepu biname cina apu jengemige egä Acejiyame me biname bine waadena padare mametarage gyene gije abacitame. Tabe singi biname bine umle wawename egä waadena padare te camurage gyene, yepä kaakesea pisi nyene ai awagrija padare cabu wawename. ");
INSERT INTO bon_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tabe peei name pi ai ngene ca agli mene teebibine jejemige egä, “Yoo, yepä babo biname te enajuji. Tabe abyemärige cudecewe gawe me otnime mope biname me ngii puma cita ca päpäname, piba teeme gawe me acnenutame. ");
INSERT INTO bon_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Camuge abyemera, tabe ten kaakesea bägrä bine tesoglecemige, teebibine yepäyepä gol rarekaake ecäranemige, jejemige egä, ‘Cane liba biiri, cäme looye cabu je weene kaakesea tewenepeye ai rarekaake babo me wawename.’ ");
INSERT INTO bon_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yoo, teeme gawe biname cina teebine mage jimugetnisi, peei name pi poto teeme biname bine teeme ingwe jityepemisi mene cama egä, ‘Cine singi lica ai biname te cime mopeyame tääpume lenajame.’ ");
INSERT INTO bon_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Peei mene ngänuge, tabe mopeyame ngii ne jepänige, piba tacnenutige. Teeme atyaramta ingwe ca tabe wata mene jejemige pui kaakesea bägrä bine, lui cina teeme ten gol rarekaake bine itu sewademumesi, teepi teeme bau otnime. Tabe singi teeme bau ca umle äbitame pui niinäce rarekaake ca teepi lija rarekaake bine bii tepänemumesi. ");
INSERT INTO bon_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yoo, niinäce kaakesea bägrä te tädige, jejige egä, ‘Babo biname, cane ten gol rarekaake bine cuta tepänemumene pui yepä cabu ca.’ ");
INSERT INTO bon_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Babo biname teebine jejige egä, ‘Maane miiji tewenumete. Maane miiji kaakesea bägrä gäte! Ai ingle naace gyene maane kaakesea cängena tewenumete matikolä gwidape ire atwime, peei name pi page cane ten cewe bine määme ire atwi cabu pa yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Piba nuuja pui kaakesea bägrä te tädige, jejige egä, ‘Babo biname, cane faib gol rarekaake bine cuta tepänemumene pui yepä rarekaake ca maane lui itu näcärepete.’ ");
INSERT INTO bon_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Babo biname pui kaakesea bägrä ne jejige egä, ‘Yoo miiji, cane piba faib cewe bine määme ire atwi cabu pa yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Piba nuuja pui kaakesea bägrä te tädige, jejige egä, ‘Babo biname, agesa määme gol rarekaake. Cane cumä tääpume cäbletääpe cabu yäämlitune. ");
INSERT INTO bon_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cane wälu ge määme tääpume, pui name pi cäbletääpe pläsu ngalebora simlitumene. Cane umle gäne maane mage kokre babo biname gäte. Maane ime kaakesea lica jaawenemute, yepä maane gwidape yaawadanemute nuuja biname bime kaakesea cabu ca, piiyepu maane calwacupi deedei yaawademute maane te luma gije lica ätema.’ ");
INSERT INTO bon_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Babo biname te teebine jejige egä, ‘Maane niiyarage kaakesea bägrä gäte! Määmerage mene te meebine naaitnäjige! Maane umle gäte egä cane kokre cama babo biname gäne, lui te gwidape yaawadanemune nuuja biname bime kaakesea cabu ca, piiyepu calwacupi deedei bine yaawademune cane te luma gije lica yäätemune. ");
INSERT INTO bon_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yoo, maane piba ngena name pi cäme rarekaake lica acita rarekaake ire atwi mete cabu? Piba cane cerämu rarekaake cire jääpänejine pui niinäce rarekaake me kaakesea cabu ca.’ ");
INSERT INTO bon_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Babo biname te piba teeme gome kaakesea bägrä bine jejemige egä, ‘Peei gol rarekaake ne teeme bau ca juutecreye, teebine ecäreye lui te ten gol rarekaake cama gyene.’ ");
INSERT INTO bon_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kaakesea bägrä cina teebine jejisi egä, ‘Babo biname, pui biname me ten gol rarekaake piti nemi!’ ");
INSERT INTO bon_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Babo biname te jejige egä, ‘Cane weebibine jijenininine egä biname lui teeme kaakesea cabu ca kuu piti nemi, teebine cuta gaabe pa yääcärepene cerämu kuu waadename, yepä biname lui me kaakesea kuu cäco gyene, cuta teeme lui matimati gwidape piti nemi, peei bine teeme bau ca pa yääyeblingemepene. ");
INSERT INTO bon_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yoo, cäme cubuyame poto cidi me, lui cina singi lica cane teeme mope biname tääpume lenaja, teebibine aima sewademeye, eglecemeye cäme opo gaabe!’” ");
INSERT INTO bon_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeesu peei mene jejemige, piba teeme niinäce gaabe me ädige Yerusalema gaabe cabu. ");
INSERT INTO bon_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tabe liba mameta atyaramta neeneni matimati cewe cabu me, ngii Betepage piiyepu Betaniya, lui puga ge Olibi Uli podo cabu jage, teeme neeneni abiberäja bägrä bine niinäce gaabe me jäätyepige. ");
INSERT INTO bon_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Camuge ätyepa tabe teebibine jaajige egä, “Äte, iclege niinäce gaabe me, lui cewe peese. Weene liba abaciteniye, piba jepäneniye mamye dongki ne ägräräneji gyene, pui papa cabu biname te camu ge adnata. Peei ne tiibirepeye, aima secanepeye. ");
INSERT INTO bon_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Biname te liba weebibine itemlenige egä, ‘Ngenome jiibireniye?’ piba teebine jejepeye egä, ‘Yageyame te singi gyene teeme tääpume.’” ");
INSERT INTO bon_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Siige, teepi aaclige, iyeta gwidape bine ibibi jepänemäsi Yeesu lipu jaajige. ");
INSERT INTO bon_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Egä cäro teepi pui mamye dongki ne jiibiräsi, dongki yageyame cina teebibine äätemlisi egä, “Weene dongki ne ngeno me jiibireniye?” ");
INSERT INTO bon_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Teepi piba jejemäsi egä, “Yageyame te singi gyene teeme tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Siige, teepi mamye dongki ne Yeesu bau me ecanäsi, teeme cäbletääpe bine papa cabu eretnemäsi, Yeesu ne piba itityäräsi acenutame mamye dongki papa cabu. ");
INSERT INTO bon_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yeesu liba ädenige, biname cina teeme cäbletääpe bine gaabe cabu eretnemisi teeme otni tääpume. ");
INSERT INTO bon_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tabe liba Yerusalema mameta me tatyaramtige Olibi Uli podo cabu ca, gaabe te luma täinige Yerusalema abacitame, puga teeme bucurage abiberäja bägrä cina gije abacitinisi Acejiyame ne eso ceerame gege cama, piiyepu teebine babo tage ca ewepyeräjisi iyeta miijirage ciitaca mule tääpume, teepi lui bine ituge päpäna Yeesu bau ca. ");
INSERT INTO bon_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Teepi jiicemisi egä, “Acejiyame te cime mope biname miiji naawenege lui te Yageyame me ngii cabu tädenite! Mime poode pisi nyene cabucewe je. Acejiyame lui caburage gyene, jamyacu apaclyera te täduge teeme cabu ca.” ");
INSERT INTO bon_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Piba poto Parisea sigu biname pui tomi cabu ca Yeesu ne jejisi egä, “Abiberäja Biname, määme bägrä bine jejemi bojä agime!” ");
INSERT INTO bon_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeesu teebibine jejemige egä, “Cane weebibine jijenininine egä ai biname liba bojä äbitininisi, piba gaabe wajwa lui kula cina ala pa labayipesi!” ");
INSERT INTO bon_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeesu babo cewe Yerusalema mametarage me ädige, cewe ne liba jepänige, tabe owecu cama ele engenige pui cewe biname cina lipu mäpu ne ciige cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tabe jiicemige egä, “Yerusalema cewe biname, miiji page weene umle cama icrajeji lipu gyene poode ne päpäname, yepä page ämlitäneji gyene weeme päpäna cabu ca! ");
INSERT INTO bon_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yoo, bimu cina cire saaclepi weeme cubuyame cina piba weebibine cire jiwaclomtipesi; teepi gawe ca caale cire jaawenepesi, iyeta poto ta pepu weeme bau me cire saaclenepi. ");
INSERT INTO bon_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Teepi weeme cewe ne pa jiibyagecepesi cuta piiyepu iyeta biname bine cewe caale ngalebora lui cina yaacrajuge; licarage yepä raranga kula ne teeme puupu cabu cire yaabmalepesi, ingle weene padare ne lica opo ewatneniye Acejiyame liba weeme bau me otni weebibine niiya cabu ca äsecrerame.” ");
INSERT INTO bon_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeesu ädige iiwäreja mete caale ngalebora me, puma gije abacitige aletnaletna biname bine äyecrejame, ");
INSERT INTO bon_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","teebibine jejemige egä, “Acejiyame te jiicenige Oogäräneji mene cabu egä, ‘Cäme mete lui irecu ätumuta mete tääpume cirege lenaja,’ yepä weene te itu setatrongärumeye epu puupu me eromaame cina luma lämletneräjininusi!” ");
INSERT INTO bon_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yoo, piba iyeta bimu gaabegabe Yeesu biname bine yaabiberäjemuge iiwäreja mete caale bora puutucu je. Modamoda iiwäreja biname, cotre abiberäja biname, piiyepu nuuja mope biname cina singi ge teebine aglime, ");
INSERT INTO bon_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","yepä teepi padare ne lica jepänisi peei ne wawename, ingle iyeta biname cina baborage singi teeme mene ätecijame. ");
INSERT INTO bon_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nuuja bimu, Yeesu liba puga ge iiwäreja mete caale bora je biname bine ebiberäjemige piiyepu Miiji Mene jejananemige, piba modamoda iiwäreja biname piiyepu cotre abiberäja biname cina nuuja modamoda biname cama teeme bau me seclige, ");
INSERT INTO bon_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","jejisi egä, “Cibibine nijini, määme ngena conocäco pisi nyene ai mule bine wawenecame? Laati bau ca gyene määme conocäco?” ");
INSERT INTO bon_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeesu jejemige egä, “Yoo, cäme ätemla cuta pisi nyene weeme tääpume. Cebine najeye, ");
INSERT INTO bon_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","laati te Yoane ne conocäco yääcärepi tabe biname bine niiye ca äcisejame, Acejiyame te coo nää biname bine?” ");
INSERT INTO bon_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Siige, teepi teemeteme mene jitranisi egä, “Mine lipu jejenisi? Mine liba jejenisi egä, ‘Yoane me conocäco lui Acejiyame bau ca gyene,’ tabe piba nijenininige egä, ‘Cije weene ngena name pi piba Yoane ne lica jäätrungepeye?’ ");
INSERT INTO bon_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yepä, mine liba apu jejenisi egä, ‘Yoane me conocäco lui biname bime cabu ca gyene,’ piba ai biname tomi te mibibine kula ca nibyecrininisi, ingle teepi jitru-ngenisi egä Yoane lui Acejiyame me mename biname ge.” ");
INSERT INTO bon_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Siige, teepi Yeesu ne jejisi egä, “Cine umle lica gemi laati te Yoane ne conocäco yääcärepi biname bine niiye ca äcisejame.” ");
INSERT INTO bon_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeesu teebibine jejemige egä, “Piba cane cuta weebibine lica jijenininine laati te cebine conocäco näcärepi ai mule bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeesu piba biname bine ai ngene ca agli mene jejemige egä, “Yepä biname te waina gije bine itemige. Tabe kaakesea biname bime ime cabu ecitige ire atwime, kämäge gaabegabe teepi te poto kuu teebine ceeraname. Tabe piba teeme gawe ne sebmalige leca padare cama. ");
INSERT INTO bon_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yoo, padare liba tatyaramtige waina kuu ngade awacame, tabe pui yageyame te kaakesea bägrä ne jityepige teeme poto kuu bine waadena calwacupi ire atwi biname cabu ca. Yepä, pui calwacupi ire atwi biname cina pui kaakesea bägrä ne etemeläjisi, piba ime taatu jityepisi teeme babo biname bau me. ");
INSERT INTO bon_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Calwacupi yageyame te piba nuuja kaakesea bägrä ne cuta jityepige, siige calwacupi ire atwi biname cina cuta teebine etemeläjisi, ajiri me jewenisi, piba cuta ime taatu jityepisi. ");
INSERT INTO bon_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Calwacupi yageyame cuta nuuja kaakesea bägrä ne jityepige; siige, pui calwacupi ire atwi biname cuta teebine niiya jewenisi, calwacupi cabu ca piba iyecräjisi. ");
INSERT INTO bon_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Piba calwacupi yageyame te jiicige egä, ‘Cane ngena pa jaawenepene? Cäme ngenecurage bägrä ne pama miiji cane ätyepa. Teepi pama teebine opo gaabe me ecitenisi.’ ");
INSERT INTO bon_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yepä, calwacupi ire atwi biname cina yageyame me bägrä ne liba jepänisi, piba teemeteme ajananinisi egä, ‘Age sena yageyame me bägrä. Tabe te ai calwacupi ne cire yaacatepi. Mine pa yaaglesi, siige calwacupi mime yene.’ ");
INSERT INTO bon_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Siige, teepi puma cita ca pui bägrä ne calwacupi cabu ca iyeblingtisi, piba budre me eglisi.” Yeesu piba itemlemige egä, “Siige, Pui calwacupi yageyame te ngena ne pa jaawenepi calwacupi ire atwi biname bime tääpume? ");
INSERT INTO bon_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tabe pa tädepi, pui biname bine budre me pa yaaglecemepi, piba teeme calwacupi ne nuuja biname bine pa jaajemepi ire atwime.” Siige, biname cina liba peei mene itecijemige, jiicisi egä, “Peei te pepu gone äbita!” ");
INSERT INTO bon_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yeesu piba teebibine ire jetwemige, itemlemige egä, “Piba ngena gyene ai Oogäräneji Mene me aboclomta? Mene egä: ‘Lui kula ne raranga biname cina jigyisi, baborage bäbitige iyeta nuuja cabu ca.’ ");
INSERT INTO bon_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Cane säne pui kula piiyepu iyeta biname lui cina cäme papa cabu pa yaatrametnemepesi, teepi cuta pa laglemeläjipesi. Cäme kokre te liba yepä biname cabu kula pana pa saatramepi, pui biname te secre pana pa lapliweräjepi.” ");
INSERT INTO bon_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Siige, cotre abiberäja biname piiyepu modamoda iiwäreja biname cina singi Yeesu ne puirage padare cabu oomlaname, ingle teepi opo ewatnisi egä peei ngene ca agli mene lui teeme poto cidi me. Yepä teepi biname tääpume wälu ge, ingle peei biname tomi te singi ge Yeesu tääpume. ");
INSERT INTO bon_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Teepi peei name pi teebine ire ca ecananisi, piiyepu teeme poto biname bine jityepemisi Yeesu bau me sinäme abiberäjame. Teepi singi Yeesu ne teeme mene cabu ca oomlaname, piba Rooma cabu ca mope biname me kokre ime cabu acitame. ");
INSERT INTO bon_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Peei name pi pui sinäme abiberäja bägrä cina Yeesu ne itemlisi egä, “Abiberäja biname, cine umle gemi määme mene piiyepu abiberäja lui conocäco gyene. Cine umle gemi egä iyeta biname lui yepä pana gemi määme opo gaabe je, lica nuuja te baborage, yepä maane iyeta biname bine toraca mene yaabiberäjemute Acejiyame me gaabe poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yoo, maane cibibine nijini, nää miiji gyene cine täks rarekaake Rooma Babo Mope Biname Siisa ne ceerame, coo miiji lica gyene ceera?” ");
INSERT INTO bon_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yepä, Yeesu opo ewatnige egä teepi singi teebine mene cabu ca oomlaname, siige teebibine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yepä bulubulu rarekaake secani! Laati me opo piiyepu laati me ngii, laati me cewecu pisi nyene ai rarekaake cabu?” Teepi jejisi egä, “Siisa teemi yene.” ");
INSERT INTO bon_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeesu piba jejemige egä, “Yoo, lui gwidape gemi Siisa me, teebine ecäreye pui, piiyepu lui gwidape gemi Acejiyame me, teebine ecäreye pui.” ");
INSERT INTO bon_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Siige, teepi äblicäco teebine teeme mene cabu ca oomlana puma biname bime sobe cabu. Siige, teepi mutäcäco äbitininisi Yeesu me mene name pi, bojä jegemige. ");
INSERT INTO bon_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Piba poto Sadukea sigu biname cina Yeesu bau me seclige. Yoo, Sadukea biname cina apu jiicusi egä, “Biname cina lica budre cabu ca cirege arpinera.” Yoo, teepi Yeesu ne itemlisi egä, ");
INSERT INTO bon_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Abiberäja biname, Moose te cotre ne mime tääpume soogäruji egä, ‘Biname te liba budre läbituge, coga ne bägrä cäco twaabmaluge, teeme igane te miiji cuubla ne acata bägrä wawename teeme naane me ngii tääpume.’ ");
INSERT INTO bon_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yoo, seben naniganewale icrajuji. Naane te coga ne ocatige, siige bägrä cäco budre äbitige. ");
INSERT INTO bon_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Piba teeme gomecayame igane te pui cuubla ne ocatige, siige bägrä cäco cuta budre äbitige. ");
INSERT INTO bon_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pepu cuta äbitige puma cita ca gomeyame tääpume, piiyepu iyeta teeme iganewale bime tääpume, iyeta seben teepi budre äbitininisi bägrä cäco. ");
INSERT INTO bon_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ingwe ca pui magebi te cuta budre äbitige. ");
INSERT INTO bon_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yoo, pui bimu cabu budre biname cina liba cirege arpinera ireclotame, piba tabe laati me coga cirege lenaja, ingle iyeta pui seben nanigane cina teebine ocananisi teeme coga tääpume?” ");
INSERT INTO bon_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeesu teebibine jejemige egä, “Yoo, ai gawecewe ireclota cabu magebi rooriye cama lawadrininusi. ");
INSERT INTO bon_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yepä, pui magebi rooriye lui cina ibibi gemi cirege arpinera ciige ireclota cabu lenajame, teepi puma lica awadreca, ");
INSERT INTO bon_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","cuta puma biname cina lica budre cirege äbita. Teeme ireclota lui Acejiyame me mename seemo pana budre cäco. Teepi Acejiyame me bägrä gemi, tabe lui bine ituge budre cabu ca arpinera ten cama iyeteta lenajame. ");
INSERT INTO bon_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yoo, Oogäräneji Mene, Moose lui itu soogäruji, peei cabu mene cuta pisi nyene budre biname me arpinera poto cidi me. Pui padare cabu Moose te jeclajutuji ayeji uli gome, tabe mime Yageyame me mene itecijuji, ingwe ca yoogäruji egä, ‘Cane Abrahamo, Isacako, Yakobu naabibime Acejiyame gäne.’ ");
INSERT INTO bon_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yoo, Acejiyame lui ireclota cama biname bime Acejiyame gyene; tabe lica budre biname bime Acejiyame, ingle biname cina lica iyeteta budre, yepä iyeta biname tääpume ireclota cuta pisi nyene.” ");
INSERT INTO bon_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Puma cita ca poto cotre abiberäja biname cina jejisi egä, “Abiberäja biname, maane miiji tiicite!” ");
INSERT INTO bon_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yoo, pui padare cabu ca biname cina singi lica teebine cääri ätemlejame. ");
INSERT INTO bon_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yeesu teebibine jejemige egä, “Biname cina lipu jiicemusi egä, ‘Keriso biname bine lui te niiya cabu ca cire yääsecräremepi, tabe Daawida me ingle cabu ca pa tädepi?’ ");
INSERT INTO bon_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yepä, Daawida teemämu jiicenige Salamo uupera peba cabu egä, ‘Yageyame te cäme Yageyame ne jejuji: Maane adnati cäme camu poto cidi ca, ");
INSERT INTO bon_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ngälu cane määme cubuyame bine määme ernge gawe me cire yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yoo, Daawida teebine einuji teeme Yageyame ca. Cije Keriso te piba lipu Daawida me kaakesaare gyene?” ");
INSERT INTO bon_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iyeta biname cina liba Yeesu me mene jitecijisi, tabe teeme abiberäja bägrä bine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cängena ire cotre abiberäja biname bime tääpume. Teepi singi gemi teeme lecaleca cäbletääpe cama otnetnejame, piiyepu biname bime bau ca awabla piiyepu awepyeräja päpäna aletna puupu cabu. Teepi singi gemi modamoda biname bime puupu cabu adnaterame abasecretna mete cabu, cuta piiyepu soriyomu ne liba yaaclitusi, teepi ladna-täruge miijirage puupu cabu. ");
INSERT INTO bon_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Teepi cuublacubla bine baborage rarekaake ngälu yääcäremusi, pepu pi teeme gwidape piiyepu mete iyeta jäämlemusi, piba teepi lecaleca irecu ätumuta jaawenemusi biname bime sobe cabu. Yoo, teepi teeme mage mäpu daremu ne cirege päpäna!” ");
INSERT INTO bon_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeesu ire acitige, jepänemige dogwe biname bine lui cina rarekaake ebäcnemisi iiwäreja mete rarekaake acrana gwidape cabu. ");
INSERT INTO bon_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tabe piba yepä owecumete cuubla ne jopänige lui te neeneni matimati rarekaake ääsinglantige pui rarekaake acrana gwidape cabu. ");
INSERT INTO bon_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Siige, tabe abiberäja bägrä bine jejemige egä, “Cane toraca mene jijenininine, ai owecumete cuubla te baborage becitige iyeta pui nuuja biname cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pui nuuja biname bime rarekaake lui bucurage gemi, piiyepu peei cabu ca teepi poto bine ecärisi, yepä cuu-bla te becitige iyeta teeme lui pisi nyene lenaja tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Poto abiberäja bägrä cina mene abaitninisi iiwä-reja mete poto cidi me egä pui mete me opo jamyacu ge, oplacmeläja kula ca rarangä-neji ge, piiyepu biname cina miijimiji gwidape Acejiyame ne ituge ceera peei mete cängena wawename. Yeesu piba teebibine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Weene ire iyeta ai miiji-miji gwidape, padare te cirege atyaramta liba iyeta ai kula bine teeme puupu cabu ca cirege äyeblenga. Yoo, iyeta cirege iisabeja.” ");
INSERT INTO bon_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abiberäja bägrä cina teebine itemlisi egä, “Abiberäja biname, ai mule te liba pagege äbita? Mine lipu peei padare ne pagege opo awatna?” ");
INSERT INTO bon_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yeesu jejemige egä, “Cängena ire! Piba nuuja te lica weebibine ingletnäjinuge, ingle bucurage biname cina cäme ngii cabu pa twaatnipesi, mene pa jiicemepesi egä, ‘Cane age säne tabe!’ coo piiyepu, ‘Padare bii tatyaramtige!’ Yepä, pepu biname bime mene gone jäätecijemuye. ");
INSERT INTO bon_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cuta piiyepu, weene liba idre pa itecijanipi egä, ‘Biname cina teeme mopeyame ne cubu cama iyeblingtisi,’ coo, ‘Biname cina cubu jiicenisi,’ piba wälu gone läbitininuye. Pepu mule pa läbitipesi, yepä ai padare me ngälugaabe cäro camu gyene.” ");
INSERT INTO bon_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tabe piba jejemige egä, “Yepä gawe biname cina nuuja gawe biname cama cubu cire jiicepesi, piiyepu yepä mope biname te nuuja mope biname cama cubu cire jiicepäsi. ");
INSERT INTO bon_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Modamoda ocneja piiyepu gane padare cina cewe maramara cabu ta cire twaatnipesi. Niiya pita cina cire twaatnipesi biname bine oomläjecame. Wälu cama cewecu gwidape dume cabu cirege aboclomäja. ");
INSERT INTO bon_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yepä, ai mule cina liba camu ge äbitena, peei niinäce gaabe me, biname cina weebibine pa joomläjicipesi, mäpu cabu pa icranipesi. Teepi weebibine maramara abasecretna mete cabu pa iwadipesi atrana tääpume, piba krokeciiye mete bora pa ibäcnipesi. Weene mope biname piiyepu nuuja modamoda biname bime opo gaabe pa jiclajutipi cäme ngii name pi. ");
INSERT INTO bon_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Piba peese nyene weeme padare Miiji Mene teebibine jajanename. ");
INSERT INTO bon_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yoo, weeme ngene atwanena yaacituye, piba bucurage maramara ngene atwanena gone pui padare cabu egä ngena mene teebibine awecnistame, ");
INSERT INTO bon_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ingle cane te umle piiyepu mene pa icäripene. Piba iyeta weeme cubuyame cina äblicäco pui mene aina, coo äseblecäja. ");
INSERT INTO bon_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yoo, weeme ätrunga cäco inglewale piiyepu binamewale cina weebibine weeme cubuyame bime ime cabu pa icäripesi, lui cina weeme poto bine cuta budre me pa yaaglecemepesi. ");
INSERT INTO bon_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iyeta biname weebibine pa jimugetnipesi weeme cäme bau ätrunga name pi. ");
INSERT INTO bon_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yepä, teepi äblicäco weeme ireclota papa acata Acejiyame liba singi lica weeme budre tääpume. Teeme kokre epu baborage gyene egä tabe ibibi cuta iyeta weeme edingäli cängena ire atwime. ");
INSERT INTO bon_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Peei name pi weeme ätrunga cabu cängena jiclajutinuge ngälu weene iyeteta ireclota cabu äbäcname.” ");
INSERT INTO bon_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yeesu jejemige egä, “Yoo, weene liba bucurage cubu biname bine cire jepänemepeye Yerusalema cewe ne jewaclomäjenisi, piba weene umle gemi egä padare te mameta me täbitenige pui cewe ne iigarecame. ");
INSERT INTO bon_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Piba pui biname lui cina Yuudea gawe cabu icrajininige, teepi miiji podo cabu me uucratna; piiyepu lui cina babo cewe cabu icrajininige, teepi miiji cewe abmala; piiyepu lui cina babo cewe kaake poto je icrajininige, teepi miiji lica cewe me äbäcname, yepä cudecewe me miiji uucratna. ");
INSERT INTO bon_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ingle pui padare cabu Yerusalema cewe biname cina mäpu daremu cirege päpäna, piba Oogäräneji Mene te ibibi me cire läbitepi. ");
INSERT INTO bon_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ogi nemi pui padare cabu lui mäpumäpu magebi piiyepu bägrä ngame meeramera magebi. Mage mäpu padare cire tädepi ai gawecewe cabu me; ai biname cina mäpu daremu cire jääpänepesi. ");
INSERT INTO bon_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cubuyame cina poto bine cubu turikä ca cire yaaglecemepesi, piiyepu nuuja bine ätäyäneji cire jäätyepäjemepesi iyeta gawe maramara cabu me. Siige, nuuja gawe biname cina Yerusalema cewe ne cire yiiglicnäjepesi, piiyepu pui gawe ire jaatwepesi, ngälu pui biname bime padare cire lapirepi.” ");
INSERT INTO bon_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yeesu piba jejemige egä, “Maramara cewecu cina cire tateplengäjipesi bimu cabu, piiyepu mabye, wale cabu je. Ai gawecewe cabu, maramara gawe biname cina ngenecu niiya cire läbitipesi. Teepi wälu name pi cuta mutäcäco cire läbitipesi, malu te liba uule mumwämu cama cire tädepi, cuta piiyepu gobe gotäte te babo uule kuu ne cire saacanepi. ");
INSERT INTO bon_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yoo, poto biname cina irecu cire laboclomäjipesi wälu name pi, teepi liba cire jääpänanepesi lui niiya cina totninisi gawecewe iyeta poto ta. Ingle dume cabu lijalija kokre gwidape piti nemi, pui bine teeme otnetneja gaabe cabu ca cire yääyecräjemepi. ");
INSERT INTO bon_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Piba cane säne lui te Acejiyame bau ca tädujine, biname me äbitujine, cane piba carbe cabu cire täinepene baborage kokre piiyepu jamyacu apaclyera cama. ");
INSERT INTO bon_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yoo, ai mule cina liba cire gije labacitipesi, piba weene abujängipeye, piiyepu mope ewepengäjemepeye, ingle weeme äsecrera piba mameta gyene Acejiyame bau otnime.” ");
INSERT INTO bon_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeesu teebibine piba ai ngene ca agli mene jejemige egä, “Jepänemeye piigi uli piiyepu iyeta nuuja uli bine. ");
INSERT INTO bon_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kirece laame cina liba täsuge, weene piba umle egä kämäge mameta birige. ");
INSERT INTO bon_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pepu pana weene liba pui mäpu mule bine cire jääpänemepeye, weene piba umle cirege äbita egä Acejiyame me biname bine waadena padare te mameta gyene. ");
INSERT INTO bon_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cane weebibine toraca jijenininine egä biname lui cina ireclota page ai taje, teepi iyeta budre lica cirege äbita, ngälu iyeta ai mule cina liba cire läbitipesi. ");
INSERT INTO bon_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yoo, dume piiyepu gawe cirege apira, yepä cäme mene te lica cirege apira.” ");
INSERT INTO bon_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yeesu cuta jejemige egä, “Weene ireire inajipi! Miiji lica cäme acnenuta bimu te weebibine buduma mule cabu oomlaname. Weeme ngene atwanena gone acrana singisingi mule cabu, coo sice nänäja cabu, coo piiyepu ngenecu mäpu cabu ai gawecewe me gwidape poto cidi me. Piba pui bimu te weebibine lica buduma mule cabu ädära mage, cuta piba dici pana weebibine pa jibrecipi. ");
INSERT INTO bon_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ingle pui bimu te cire tädepi iyeta biname bime bau me lui cina ai gawecewe cabu yaacrajuge. ");
INSERT INTO bon_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Peei name pi ire cama cängena inajipi, piiyepu Acejiyame ne yaawejanuye kokre ceerame iyeta pui gwidape cabu ca cängena äsecrerame, piba cäme opo gaabe je aclajutäjame, cane lui te Acejiyame bau ca tädujine, biname me äbitujine.” ");
INSERT INTO bon_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Siige, pui poto bimu gaabegabe Yeesu biname bine yaabiberäjemuge iiwäreja mete caale bora je. Ciiye liba, tabe babo cewe cabu ca tasatuge Olibi Podo cabu lenajame. ");
INSERT INTO bon_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kroke gaabegabe, iyeta biname cina iiwäreja mete me cuta yaacluge teeme mene ätecijame. ");
INSERT INTO bon_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Trii padare mameta ge Israela biname cina liba uutneca cäco buluduu bine yäärwäjemusi, lui deedei teepi Äsuplengta Trii ca yaainusi. ");
INSERT INTO bon_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yoo, iiwäreja babo biname piiyepu cotre abiberäja biname cina singi gaabe ne päpäname Yeesu ne aglime, yepä biname bime name pi wälu, teepi singi ogä oomlaname. ");
INSERT INTO bon_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yuuda lui yepä ge Yeesu me twelb abiberäja bägrä cabu ca, teeme nuuja ngii Isakariyota. Satani te Yuuda me ngalebora me abacitige. ");
INSERT INTO bon_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tabe piba modamoda iiwäreja biname piiyepu iiwäreja mete awamuta mope biname bime bau me ädige, ten cama mene jiicemige lipulipu Yeesu ne teeme ime cabu acitame. ");
INSERT INTO bon_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Siige, teepi gege ge teeme ätityera tääpume, mene jejisi rarekaake daremu teebine ceerame. ");
INSERT INTO bon_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuuda teeme mene ecatige, miijirage padare ne jirngige Yeesu ne teeme ime cabu acitame, biname sobe liba lica ge. ");
INSERT INTO bon_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Teepi uutneca cäco buluduu bine yäärwäjinusi seben bimu ngalebora, siige pui padare me niinäce bimu te tädige teepi liba maamoi plongo bine yaaglecimusi Äsuplengta Trii deedei wawename. ");
INSERT INTO bon_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yeesu te Peteru naabi Yoane jaajige egä, “Weene iclege mime deedei amacetnäjame Äsuplengta Trii tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Teepi teebine itemläsi egä, “Maane singi cine ai deedei ne luma wawename?” ");
INSERT INTO bon_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tabe jaajige egä, “Cängena nätecijeye. Weene liba babo cewe me abaciteniye, piba weene biname ne jepäneniye niiye iitana cabu ca lui te tacnenige. Weene teebine ingwe icwepeye, tabe lui mete me abacitenige, weene peei mete me cuta abacitepeye, ");
INSERT INTO bon_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","pui mete yageyame ne jejepeye egä, ‘Cime mene pisi nyene Abiberäja Biname bau ca egä: Puupu lese nyene cane cäme abiberäja bägrä cama Äsuplengta deedei äbitame?’ ");
INSERT INTO bon_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tabe piba baborage cabu puupu ne jiwabenige lui iyeta gwidape cama gyene. Weene puma deedei emacetnäjemepeye!” ");
INSERT INTO bon_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Siige, teepi aaclige, iyeta gwidape ibibi jepänemäsi Yeesu lipu teebibine jaajige. Teepi puga äsuplengta deedei ne emacetnäjäsi. ");
INSERT INTO bon_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yoo, padare liba tatyaramtige, Yeesu dade gome adnatige teeme twelb ätyepäneji biname cama. ");
INSERT INTO bon_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tabe teebibine jejemige egä, “Cane baborage singi ai Äsuplengta deedei weene cama äbitame. Cane ebä jepänenine mäpu padare ne, yepä niinäce cane weene cama deedei äbitenine. ");
INSERT INTO bon_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cane weebibine jijenininine egä cane ai äsuplengta deedei ne ingwe ca lica pa yaarwepene ngälu teeme aboclomta toraca me cire läbitepi, cane liba biname bine niiya cabu ca äsecrerame, Acejiyame me waadena cabu äbäcname. ");
INSERT INTO bon_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yeesu kwäye ne ecatige, Acejiyame ne eso ecärige, piba jejemige egä, “Weene ecateye, iyeta eneye. ");
INSERT INTO bon_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yoo, cane weebibine jijenininine egä cane waina niiye ne cuta cääri lica pa yaanepene ngälu padare te cire tatyaramtepi Acejiyame te biname bine waadename.” ");
INSERT INTO bon_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tabe piba buluduu ne ecatige, Acejiyame ne eso ecärige, itrecige, teebibine ecäremige, jejemige egä, “Ai lui cäme tääpe gyene lui weeme tääpume budre äbitenine. Erweye, cebine ngene apecname.” ");
INSERT INTO bon_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Deedei ingwe ca, tabe yepä pana mule ca kwäye ne ecatige, jejemige egä, “Ai kwäye te klaje jecnenige weeme tääpume Acejiyame lui kirece mene ituge jaji biname bine niiya cabu ca äsecrerame, cäme uudi liba tapirenige. ");
INSERT INTO bon_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yepä, ire! Biname lui te cebine cäme cubuyame bime bau me nawabenige, tabe age sena mine cama ai dade cabu. ");
INSERT INTO bon_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yoo, cane lui te Acejiyame bau ca tädujine, biname me äbitujine, cane budre me ädenine, ingle Acejiyame te singi gyene cane peei ne wawename. Yepä, mage mäpu gyene teeme tääpume lui te cebine cubuyame bime tääpume nawabenige!” ");
INSERT INTO bon_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Siige, abiberäja bägrä cina teemeteme ätemläjinisi egä, “Mime tomi cabu ca laasi nyene, lui te peei ne jewenenige?” ");
INSERT INTO bon_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Abiberäja bägrä cina jicelisi egä teeme cabu ca lui te babo biname me pagege äbita. ");
INSERT INTO bon_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeesu peei name pi jejemige egä, “Ai gawecewe mope biname cina teeme biname bine babo kokre cama ire jaatwemusi, piiyepu biname cina teebibine yaainemusi ‘Babo Ätityera Biname.’ ");
INSERT INTO bon_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yepä, gone teeme pana mule ne yaacatuye. Eewe, weeme cabu ca laasi nyene baborage, tabe miiji matikolä pana äbita, piiyepu weeme babo biname tabe miiji kaakesea bägrä pana lenajame. ");
INSERT INTO bon_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yoo, laasi nyene baborage ai neeneni cabu ca, nää biname lui te ladnatuge deedei äbitame, coo biname lui te deedei teeme bau me yaawaduge? Yoo, tabe sine baborage lui te ladnatuge, yepä cane lui weeme tääpume epu pana gäne weeme kaakesea bägrä liiyepu. ");
INSERT INTO bon_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yoo, weene cebine lica ituge abmala mine liba mäpu bine jääpänanemepesi, ");
INSERT INTO bon_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","cuta epu pana cäme Babe te lipu cebine conocäco ituge ceera cane biname bine waadename, cane cuta pepu weebibine conocäco cirege ceera weene biname bine waadename. ");
INSERT INTO bon_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Weene piba cabucewe je cäme dade cabu deedei cirege äbita piiyepu niiye nänäja cäme waadena padare cabu. Weene babo puupu cabu cire adnatäripeye Israela biname bime twelb ingle biname bine atraname.” ");
INSERT INTO bon_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeesu jejige egä, “Simona, Simona, cebine näteciji! Satani teeme singi bii jepänige weebibine iyeta apicetnerame, epu pana calwacupi biname te kuu bine mälwä lipu jäämlecäjemuge miiji kuu taatu waadename. ");
INSERT INTO bon_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yepä, Simona, cane cuta määme tääpume ituge awejena egä maane lica määme ätrunga ne abma-lame. Maane liba pui apicetnera cabu ca pa tacnenutepete, piba maane määme binamewale bine cuta ngenecu kokre jewenemepi.” ");
INSERT INTO bon_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peteru jejige egä, “Yageyame, cane amacetnäjäneji gäne maane cama otnime krokeciiye mete cabu me, coo budre äbitame.” ");
INSERT INTO bon_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu piba jejige egä, “Peteru, cane meebine naajenine egä maane cebine nesae gääbu nainenite, paulo te ingwe ca ala sengenenige.” ");
INSERT INTO bon_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yeesu piba teeme abiberäja bägrä bine itemlemige egä, “Pui niinäce padare cabu, cane liba weebibine jityepäjipene rarekaake cäco, bulu diiba cäco, cuta piiyepu ernge gwidape cäco, nää weeme singi puga ge nuuja gwidape tääpume?” Teepi jejisi egä, “Cine singi lica ge nuuja gwidape tääpume.” ");
INSERT INTO bon_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yeesu jejemige egä, “Yepä, page laati me bulu diiba piiyepu rarekaake piti nemi, tabe miiji ten cama waadena. Piiyepu cuta laati te cubu turikä cäco gyene, tabe miiji aletname teeme acwaba cäbletääpe ca. ");
INSERT INTO bon_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cane weebibine jijenininine egä Oogäräneji Mene te cäme poto cidi me miiji ibibi äbitame egä, ‘Teebine ecitenisi conocono biname cama yepä.’ Yoo, ngena mene cäme poto cidi me oogäräneji gyene, toraca me äbitenige.” ");
INSERT INTO bon_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abiberäja bägrä cina piba jejisi egä, “Yageyame, age tegi neeneni cubu turikä.” Tabe jejemige egä, “Siige, ibibi gyene!” ");
INSERT INTO bon_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeesu piba cewe ne sebmalige, Olibi Uli podo cabu me ädige, teeme bimu gaabegabe mule lipu ge. Teeme abiberäja bägrä cina teeme ingwe ca eclige. ");
INSERT INTO bon_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tabe liba teeme singi puupu ne joomlige, piba teebibine jejemige egä, “Acejiyame ne ewejaneye egä weene apicetnera cabu ca lica pagege atrametna.” ");
INSERT INTO bon_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tabe piba matikolä äyeblingtige teeme bau ca, epu pana kula me ajara leca liiyepu. Tabe kokorare ääpednutige, Acejiyame ne ewejanige egä, ");
INSERT INTO bon_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Cäme babe, maane liba singi gäte, ai mäpu ne iyeblingti cäme bau ca, yepä gone jaawenute cäme singi ne, määme singi ne jewenepi.” ");
INSERT INTO bon_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Piba mename seemo te cabucewe ca teeme bau me taboclomtige teebine kokre ceerame. ");
INSERT INTO bon_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeesu baborage ngenecu mäpu cama ewejanige. Teeme mlage cina uudi ipecu pana sitrametnemige gawe cabu. ");
INSERT INTO bon_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tabe liba abujängtige teeme irecu ätumuta cabu ca, teeme abiberäja bägrä bime bau me liba ädige, teebibine ute cabu jepänemige, ingle teepi mage ngenecu mäpu ge. ");
INSERT INTO bon_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tabe teebibine jejemige egä, “Weene ngena ute gemi? Arpinärineye, Acejiyame ne ewejaneye egä weene apicetnera cabu ca lica pagege atrametna.” ");
INSERT INTO bon_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yeesu liba peei mene cabu jage, piba taatu biname sange te tatyaramtige. Pui biname, ngii Yuuda, lui yepä ge twelb abiberäja bägrä cabu ca, tabe te opo jewenemige teebibine. Tabe Yeesu gome ädige teebine lakace cabu atecname, teeme awabla mule liiyepu ge. ");
INSERT INTO bon_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yepä, Yeesu jejige egä, “Yuuda, cane lui te Acejiyame cabu ca tädujine, biname me äbitujine, nää maane cebine nawabenite budre me atecna cabu ca?” ");
INSERT INTO bon_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yoo, Yeesu cama lui abiberäja bägrä cina liba jepänemisi ngena te pa läbitege, teepi jejisi egä, “Yageyame, nää cine miiji agleca cubu turikä ca?” ");
INSERT INTO bon_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Puma cita ca teeme yepä te iiwäreja mope biname me kaakesea bägrä ne jemomäntige turikä ca, camu poto tablame ne jeläcnutige. ");
INSERT INTO bon_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yepä, Yeesu jejemige egä, “Siige ai mule!” Tabe ime ne ecitige pui kaakesea bägrä me tablame cabu, teebine miiji me jewenige. ");
INSERT INTO bon_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Piba pui modamoda iiwäreja biname piiyepu poto iiwäreja mete awamuta mope biname, piiyepu poto Israela modamoda biname bine, iyeta lui cina seclige Yeesu ne oomlaname, tabe teebibine jejemige egä, “Weene ngenome cubu turikä piiyepu gabagaba cama naaclige, epu pana egä cane cubucubu biname gäne? ");
INSERT INTO bon_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yoo, cane weene cama liba nanajuge iiwäreja mete caale bora bimu gaabegabe, weene piba singi lica cebine oomlaname. Yepä, ai lui weeme padare gyene, krokeciiye te liba weebibine joomlinige waadename.” ");
INSERT INTO bon_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Siige, teepi Yeesu ne joomlisi, teebine ecanisi Iiwäreja Mope Biname me mete me. Peteru cudecewe pana teebine ingwe icwige. ");
INSERT INTO bon_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Poto biname cina muye yuungisi cole puupu cabu puutucu je, puga adnatäreji icrajige, cuta Peteru teeme gome adnatige. ");
INSERT INTO bon_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yepä mete kaakesea ngulebägrä te teebine jepänige, muye apaclyera cabu adnatäneji ge. Tabe teebine cängena ewatnäjige, piba jiicige egä, “Ai biname te ten cama waatnuge!” ");
INSERT INTO bon_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yepä, Peteru ainige, jojige egä, “Ngulebägrä, cane umle lica gäne tabe!” ");
INSERT INTO bon_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Matikolä ingwe ca, nuuja biname te teebine jepänige, jejige egä, “Maane cuta yepä teeme tomi cabu ca gäte!” Yepä, Peteru jejige egä, “Eewe, cane lica!” ");
INSERT INTO bon_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yepä awa ingwe ca cuta nuuja biname te kokre cama jiicige egä, “Toraca gyene, ai biname ten cama waatnetnäjuge, ingle tabe Galilaya biname gyene.” ");
INSERT INTO bon_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yepä, Peteru te jejige egä, “Maane lui tääpume jiicenenite, cane umle lica gäne!” Tabe liba camu peei mene iicema cabu jage, piba taatu paulo te ala sengenige. ");
INSERT INTO bon_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yageyame te tatatrongtige, Peteru ne conocäco ire jetwige, siige Peteru piba ngene jotwige Yageyame lui mene teebine bii jejige egä, “Page paulo te ingwe ca ala sengenenige, niinäce maane nesae gääbu cebine nainenite.” ");
INSERT INTO bon_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Siige, Peteru asatige, mage ele engenige. ");
INSERT INTO bon_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lui biname cina Yeesu ne jewamutisi, teepi teebine niiya bääclena me jewenisi, piiyepu jidnanenisi. ");
INSERT INTO bon_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Teepi teeme irecu icwabisi cäbletääpe ca, piba jejisi egä, “Nijini, laati te meebine noororige?” ");
INSERT INTO bon_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Teepi cuta bucurage nuuja niiya mene ca teebine jicnecisi. ");
INSERT INTO bon_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bimu te liba tacitige, Israela mutre biname, epu egä modamoda iiwäreja biname piiyepu cotre abiberäja biname, teepi abasecretnige, piba Yeesu ne ecanisi teeme opo gaabe je aclajutame, ");
INSERT INTO bon_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","teebine jejisi egä, “Nijini, nää maane Acejiyame bau ca Keriso säte?” Yeesu teebibine jejemige egä, “Cane liba weebibine jijenininine, weene lica cäme mene ätrunga, ");
INSERT INTO bon_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","cuta piiyepu, cane liba weebibine itemläjinine, weene lica daremu mene awecnista. ");
INSERT INTO bon_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yepä, ai padare cabu ca cane lui te Acejiyame cabu ca tädujine, biname me äbitujine, cane Kokre Acejiyame me camu poto ime cabu pa ladnatepene.” ");
INSERT INTO bon_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Teepi iyeta piba itemlisi egä, “Nää maane jiicite apu egä maane Acejiyame me Bägrä gäte?” Tabe teebibine jejemige egä, “Yoo, weene toraca jiicemiye egä cane tabe säne.” ");
INSERT INTO bon_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Teepi piba ajananinisi egä, “Ngänuge mime nuuja aitneja biname. Cine bii nitecijinige tabe lipu teemämu taitnige!” Siige. ");
INSERT INTO bon_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Siige, pui abasecretnäneji biname iyeta abujängige, Yeesu ne ecanisi Rooma ca Mope Biname Pilato bau me. ");
INSERT INTO bon_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Puga teepi teebine aitnejame gije abacitinisi egä, “Cine ai biname ne jepänisi cime biname bine conocono abiberäja cabu ewademige. Tabe teebibine apu jejemige egä täks rarekaake gone ceera Babo Mope Biname Siisa ne, cuta piiyepu jejemige egä tabe lui nuuja mope biname gyene, lui me ngii Keriso.” ");
INSERT INTO bon_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato teebine itemlige egä, “Nää, maane Israela biname bime mope biname säte?” Yeesu jejige egä, “Yoo, maane peega bii jiicite.” ");
INSERT INTO bon_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Puma cita ca Pilato te modamoda iiwäreja biname piiyepu tomi cabu lui biname bine jejemige egä, “Cane lica nuuja ingle ne jepänine ai biname ne mäpu cabu acitame.” ");
INSERT INTO bon_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yepä, teepi kokre cama Pilato ne jejisi egä, “Teeme mara abiberäja cabu ca Yuudea gawe iyeta poto ta tabe biname bine giri jaacranimuge teeme singi acatame. Tabe mene jajanename gije itu labacitepi Galilaya gawe cabu, cuta puma cita ca tädumi aimopo.” ");
INSERT INTO bon_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato liba peei mene itecijige, piba itemlemige egä, “Ai, nää Galilaya biname gyene?” ");
INSERT INTO bon_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tabe liba umle äbitige egä Yeesu lui Galilaya probins cabu ca ge, Heroda luma mope biname tääpume enajenige, piba teebine Heroda bau me jityepige, ingle pui padare Heroda cuta Yerusalema cewe cabu enajige. ");
INSERT INTO bon_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yoo, Heroda te gege äbitige Yeesu ne päpäname, ingle tabe mene ituge ätecija Yeesu poto cidi me, peei name pi leca padare cama tabe singi ge teebine päpäname. Tabe babo singi ciitaca mule päpäname Yeesu bau ca, ");
INSERT INTO bon_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","siige teebine bucurage mene ca itemläjige, yepä Yeesu nuuja daremu mene lica jewecnistige. ");
INSERT INTO bon_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yoo, modamoda iiwäreja biname piiyepu cotre abiberäja biname cina abujängisi, teebine mage kokre mene ca jeitnäjisi. ");
INSERT INTO bon_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda teeme cubu biname cama piba Yeesu ne niiyarage bääclena me jewenisi piiyepu niiyaniya mene jiicemisi teeme poto cidi me. Teepi mope biname me sasa cäbletääpe ca esigrisi, teebine pui cama sewecnistisi Pilato bau me. ");
INSERT INTO bon_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yoo, pui bimu cabu Heroda naabi Pilato biname me äbitäsi. Peei niinäce gaabe me teepi cubuyame ge. ");
INSERT INTO bon_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Piba Pilato te modamoda iiwäreja biname, mope biname, piiyepu iyeta biname bine ala tesoglecemige abasecretname, ");
INSERT INTO bon_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","teebibine jejemige egä, “Weene ai biname ne secaniye cäme bau me, piiyepu cebine najiye egä tabe biname bine niiya mule bine yaabiberäjemuge lui gemi cotre kaake poto ca. Cane teeme ireclota bii jirngine weeme opo gaabe, yepä lica jepänine nuuja niiya ne teeme bau ca iyeta weeme aitneja mene cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Cuta Heroda piiyepu, tabe nuuja niiya ne lica jepänige teeme cabu, peei name pi teebine cuta sewecnistige. Ai biname te nuuja niiya ne lica ituge wawena lui ibibi gyene teebine budre daremu ceerame. ");
INSERT INTO bon_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cane peei name pi cäme cubu biname bine pa jaajemene teebine adnaname, piba asatame.” ");
INSERT INTO bon_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yoo, Pilato iyeta kämäge gaabegabe apu läbitanuge, tabe yepä biname ne krokeciiye mete cabu ca saasatuge äsuplengta trii padare cabu, Israela biname cina lui biname tääpume singi. ");
INSERT INTO bon_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Siige, iyeta biname cina pui tomi cabu ala abayaninisi egä, “Ai biname ne budre me eglepi! Baraba ne sisati cime tääpume!” ");
INSERT INTO bon_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yoo, pui biname Baraba te cubu ituge iicana Yerusalema cewe ngalebora cewe mope biname me kaakesea biname cama, cuta piiyepu tabe nuuja biname ne ituge agli, peei name pi krokeciiye mete bora me itu yaacitepi. ");
INSERT INTO bon_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Siige, Pilato te singi ge Yeesu ne asatame, peei name pi biname bine cääri jejemige peei poto cidi me, ");
INSERT INTO bon_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","yepä teepi jäje ala abayanenisi egä, “Baarge uli cabu jibyecreye; baarge uli cabu jibyecreye!” ");
INSERT INTO bon_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yepä, Pilato teebibine nesae me jejemige egä, “Tabe ngena niiya ne ituge wawena? Cane teeme cabu nuuja niiya ne lica jepänine lui ibibi gyene teebine budre daremu ceerame! Cane cäme cubu biname bine pa jaajemene teebine adnaname, piba pa yaasatene.” ");
INSERT INTO bon_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yepä, pui biname cina ala abayaninisi egä teebine baarge uli cabu toto ca äbyecrame. Siige, teeme kokre mene te ibibi äbitige, ");
INSERT INTO bon_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato piba mene jejemige biname bime singi wawename Yeesu ne budre me acitame. ");
INSERT INTO bon_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Teepi lui biname tääpume singi, tabe teebine isatige, lui ne cubu name pi piiyepu biname agli name pi krokeciiye mete bora me acitäneji ge. Tabe Yeesu ne piba teeme ime cabu ecitige teepi teeme singi ne wawename teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Siige, Rooma cubu biname cina Yeesu ne liba ecanisi cewe cabu ca, teepi piba opopa eyisi yepä biname cama, teeme ngii Simona. Tabe Kurene cewe biname ge, lui te babo cewe me tabacitenige calwacupi cewe cabu ca. Yoo, cubu biname cina Simona ne joomlisi, Yeesu me baarge uli ne teeme palace cabu ecitisi, teebine jejisi Yeesu me ingwe ca acaname. ");
INSERT INTO bon_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bucurage biname cina Yeesu ne ingwe icwisi. Puga ge poto magebi pui biname tomi cabu lui cina mage ele engenetnemige teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeesu teeme bau me tatatrongtige, jejemige egä, “Yerusalema magebi, ele gone cäme tääpume, yepä weene miiji ele weeme tääpume piiyepu weeme bägrä bime tääpume. ");
INSERT INTO bon_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ingle naace gyene padare te cire tatyaramtepi, biname cina piba cire jiicemepesi egä, ‘Lipu gege gemi peei magebi lui cina bägrä cäco gemi, lui cina bägrä bine lica jäärngecusi piiyepu bägrä bine lica ngame meeramera, teepi page cuta lica teeme bägrä bime mäpu jepänanemisi.’ ");
INSERT INTO bon_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pui mäpu padare cabu biname cina podo bine cire jaajemepesi egä, ‘Cibibine nitrugärineye!’ piiyepu doro bine cire jaajemepesi egä, ‘Cibibine nicwabärineye!’ ");
INSERT INTO bon_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yoo, teepi cebine liba apu nawenenisi, cate uli pana närgenisi, teepi piba weebibine lipu cire jiwenipesi, weene lui cina maaje uli pana gemi?” ");
INSERT INTO bon_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Rooma cubu biname cina cuta nuuja neeneni biname bine aacanisi Yeesu cama yepä padare cabu budre me wawename, yepä pui neeneni lui niiyarage mule biname ge. ");
INSERT INTO bon_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Teepi iyeta liba pui puupu cabu me atyarige, ngii Mopekaake, puga Yeesu ne baarge uli cabu toto ca jibyecrisi. Teepi pui neeneni niiya mule biname bine cuta uli cabu jääbyecrisi, yepä biname Yeesu me camu poto ca, cuta nuuja teeme säwäci poto ca. ");
INSERT INTO bon_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeesu jejige egä, “Cäme Babe, ai niiya mule ne iyeblingti määme ngene atwanena cabu ca, ingle teepi toraca umle lica gemi teepi ngena ne tewenenisi.” Rooma cubu biname cina matimati kula cabu teeme ngii bine yoogäremisi, piba yiisabäjemisi pui kula bine umle äbitame egä teepi lipulipu Yeesu me cäbletääpe bine abelename. ");
INSERT INTO bon_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yoo, biname cina ire tääpume imyemutemige. Israela mope biname cina teebine niiya bääclena me jewenanisi, jejisi egä, “Tabe nuuja biname bine niiya cabu ca yääsecräremuge, tabe miiji cuta teemämu ai niiya cabu ca asata, tabe liba toraca Acejiyame bau ca jajeji gyene Keriso tääpume!” ");
INSERT INTO bon_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rooma cubu biname cina teebine cuta niiya bääclena me jewenanisi. Teepi teeme mameta me eclige, caapocapo waina niiye singi ge ceerame, ");
INSERT INTO bon_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","piba jejisi egä, “Maane määmämu ai niiya cabu ca asati, maane liba nää toraca Israela biname bime mopeyame gäte!” ");
INSERT INTO bon_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yoo, ai oogära mene teepi ecitisi Yeesu me baarge uli cabu mope gome egä, “Ai biname lui Israela biname bime mopeyame gyene.” ");
INSERT INTO bon_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Siige, yepä pui niiya biname lui Yeesu me wajwa je acitäneji ge, tabe cuta teebine jicnecige egä, “Maane lui Acejiyame me Keriso gäte, nää? Piba ai niiya cabu ca asati, cuta piiyepu cibibine nisati!” ");
INSERT INTO bon_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yepä, pui nuuja te niinäceyame ne eblawäjige egä, “Nää, maane wälu lica gäte Acejiyame tääpume? Mine iyeta yepä pana daremu cabu temi. ");
INSERT INTO bon_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mime daremu lui conocäco gyene, mime niiya mule ibibi gyene, yepä tabe, nuuja niiya mule ne lica ituge wawena. ");
INSERT INTO bon_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tabe puma cita ca Yeesu ne jejige egä, “Maane cäme tääpume ngene totwepi, maane liba biname bine waadename cire twaatnepi!” ");
INSERT INTO bon_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu teebine jejige egä, “Cane meebine naajenine, maane page cane cama naanajenige Acejiyame me jamyacu lenaja puupu cabu.” ");
INSERT INTO bon_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yoo, bimu duusa liba äbitige, bimu te gawe me lica sepa-clyärige, krokeciiye te iyeta gawe ne sicwabige nesae awa cama. ");
INSERT INTO bon_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pui padare cabu baborage cäbletääpe lui iiwäreja mete cabu atecwanteji ge, pui te äderärige, siige neeneni pargi äbitäsi. ");
INSERT INTO bon_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeesu piba babo ala abayige egä, “Cäme Babe, cäme seemo ne määme ime cabu ecitenine!” Tabe peei mene jiicige, siige budre äbitige. ");
INSERT INTO bon_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yoo, Rooma cubu biname bime mope biname te liba peei mule ne jepänige, Acejiyame ne ewepyeräjige egä, “Toraca, ai lui conocäco biname ge!” ");
INSERT INTO bon_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yoo, iyeta lui biname cina abasecretnige puma ireme, teepi liba peei mule ne jepänisi, iyeta piba dare adnaninisi, ngenecu mäpu cama äcnärige mete me. ");
INSERT INTO bon_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yepä, iyeta lui cina umlerage gemi Yeesum tääpume, cuta piiyepu lui magebi cina ten cama seclumi Galilaya Probins cabu ca, teepi cudecewe pana amyemuteji icrajige peei mule bine päpäname. ");
INSERT INTO bon_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Puga ge yepä biname ngii Yoosepa, lui Israela biname bime matikolä cewe cabu ca, ngii Arimatea. Tabe conocäco, miiji biname ge lui Acejiyame me biname bine waadena padare ne jewagrijenige. Tabe Israela mutre biname bime abasecretna cabu ge, yepä singi lica ge teeme atrana piiyepu waweneca Yeesu poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tabe Pilato bau ädige, Yeesu me budrekaake tääpume itinärige. ");
INSERT INTO bon_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tabe piba Yeesu me budrekaake baarge uli cabu ca sitrungamtige, lecaleca cäbletääpe ca tope etnige, piba gape cabu isinglantige, puupu cabu ecitige. Pui gape lui kula uureji ge, kirece wawenäneji ge, piiyepu lica ituge nuuja biname ne acita puma. ");
INSERT INTO bon_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bimu lui Fraide ge, Sabade bimu me amacetnäja bimu, piiyepu teeme Sabade bimu mameta ge atyaramta. ");
INSERT INTO bon_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pui magebi lui cina Yeesu cama seclumi Galilaya Probins cabu ca, teepi Yoosepa cama eclige, gape ne engrärisi, ewatnäjisi Yeesu me budrekaake lipu ge acitäneji puma. ");
INSERT INTO bon_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Teepi piba mete me äcnärige, miiji lengo ngängye bine emacetnäjemisi teeme tääpe ne ingwe ca piba apyacame. Yepä, Israela biname bime Sabade bimu cabu teepi ngene oocinisi teeme cotre lipu jiicusi. ");
INSERT INTO bon_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande krokerage, pui magebi cina lui miiji lengo gwidape bine tewenimumesi, teepi pui cama gape me eclige. ");
INSERT INTO bon_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Teepi puma jepänisi egä kula te apeträngteji ge gape gaabe cabu ca, ");
INSERT INTO bon_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","siige ebäcnisi, yepä Yageyame Yeesu me budrekaake ne lica jepänisi. ");
INSERT INTO bon_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Teepi puga jeclajutemige maramara ngene atwanena cama, piba taatu neeneni biname cina apaclyäreji cäbletääpe cama teeme gome jaaclajutige. ");
INSERT INTO bon_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Magebi cina wälu name pi ergo eciretnemige gawe me. Pui neeneni cina teebibine jejemäsi egä, “Weene ngenome gape cabu ireclota biname ne jirngeniye? ");
INSERT INTO bon_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tabe ama lica gyene; tabe barpinantige ireclota me! Yoo, weene ngene jotwineye tabe lui mene weebibine ituge jaji weene liba Galilaya je egä, ");
INSERT INTO bon_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Cane lui te Acejiyame bau ca tädujine, biname me äbitujine, cane miiji niiyaniya mule biname bime ime cabu lenajame. Teepi cebine baarge uli cabu pa näbyecrepesi budre me, yepä nesae me lui bimu cane pa larpinantepene ireclota cama.’” ");
INSERT INTO bon_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Magebi cina pui mene piba ngene jotwinisi, ");
INSERT INTO bon_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","gape cabu ca täcnärininisi, peei mule ne jeitnäjisi pui lebin abiberäja bägrä bime bau me piiyepu iyeta bime bau me lui cina ten cama ge. ");
INSERT INTO bon_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pui magebi lui Mariya Magadala, Yoana, naabi Mariya Yakobu me mage, cuta piiyepu poto lui ten cama ge. Yoo, teepi peei mule poto cidi me ätyepäneji biname bine jejemisi, ");
INSERT INTO bon_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","yepä pui magebi bime mene teepi lica jitrungemisi, ingle apu jengemige egä walya mene ge. ");
INSERT INTO bon_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yepä, Peteru te abujängtige, gape gome me uuwamige. Puga gape cabu me äcupige, apepmeläjige, cäbletääpe taatu bine jepänemige lui ca teeme tääpe ne tope setnumesi. Tabe piba mete me acnenutige, mage ngene jotwananige ngena te bii bäbitige. ");
INSERT INTO bon_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pui yepä bimu cabu, neeneni Yeesu me biname cina Emaus cewe me aaclige. Peei lui cebocebo bimu me otni ge Yerusalema cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Teepi mene abaitnenäsi iyeta gwidape poto cidi me lui cina pui nesae bimu cabu täbitimesi. ");
INSERT INTO bon_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Egäcäro teepi liba mene ajana piiyepu ätemleja cabu ge, Yeesu piba mameta me tädige, piiyepu ten cama gaabe cabu ädige. ");
INSERT INTO bon_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yepä, teepi biname taatu jepänäsi, äblicäco teebine opo awatna. ");
INSERT INTO bon_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yeesu teebibine ääte-mlige egä, “Weene ngena poto cidi me jiicenenemiye gaabe cabu?” Teepi puma cita ca ngenecu mäpu cama äämyemutige. ");
INSERT INTO bon_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Teeme yepä te, ngii Kleopa, teebine jejige egä, “Maane pama yepä taatu biname gäte Yerusalema cabu ca lui te umle lica ngena mule cina täbitimesi ai nesae bimu ngalebora!” ");
INSERT INTO bon_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tabe äätemlige egä, “Ngena mule?” Teepi jejemige egä, “Pui mule cina Yeesu Nasareta ceweyame tääpume lui cina täbitimesi. Pui biname te Acejiyame me mename biname ge. Tabe kokre ciitaca mule bine jaawenemuge, piiyepu kokre cama mene jaajanemuge. Iyeta biname cina teeme kokre ne opo sewatnumesi egä Acejiyame bau ca ge. ");
INSERT INTO bon_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Cime modamoda iiwäreja biname piiyepu nuuja mope biname cina teebine Rooma ca mope biname me ime cabu secitumesi budre tääpume. Piba Rooma cubu biname cina teebine baarge uli cabu tibyecrumesi. ");
INSERT INTO bon_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yoo, cine cime ngene atwana teeme cabu itu yaacitepesi egä tabe pama peese nyene biname Israela biname bine niiya cabu ca äsecrerame. Cuta peei taatu lica, page lui nesae me bimu gyene peei mule ingwe ca. ");
INSERT INTO bon_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Page poto magebi cime tomi cabu ca teepi cibibine mutäcäco me niwenininisi. Teepi liba krokerage gape gome eclige, ");
INSERT INTO bon_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","teeme budrekaake ne lica jepänisi puma. Siige, teepi täcnärige, cibibine nijinininisi egä neeneni mename seemo bine jääpänisi lui cina teebibine jejemäsi egä Yeesu ireclota gyene. ");
INSERT INTO bon_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yoo, piba poto cime tomi cabu ca gape ne engrärisi. Teepi iyeta gwidape bine pepu jepänemisi magebi cina lipu jiicemisi, yepä teepi Yeesu ne lica jepänisi.” ");
INSERT INTO bon_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeesu piba teebibine jaajige egä, “Weene lipu pi umle cäco gegi? Weene däägudägurage joomleniye sasa mename biname bime mene! ");
INSERT INTO bon_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Weene cire umle läbitejiye egä biname bime niiya cabu ca äsecrera biname te miiji mäpurage padare ne päpäna, piba peei cabu ca jamyacu apaclyera padare cabu me abacitame.” ");
INSERT INTO bon_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Puma cita ca Yeesu teeme tääpume eboclomäjige iyeta mene lui teeme poto cidi me oogäräneji gemi. Tabe gije abacitige mene cabu ca Moose lui bine itu soogäremuji, puma cita ca teeme mene te otnige iyeta sasa mename biname bime cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Siige, teepi lui cewe me singi otni, pui mameta me atyaränisi, piba Yeesu tabe otni taatu äbitige, ");
INSERT INTO bon_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","yepä teepi teebine jiibecläsi, jejäsi egä, “Maane cine cama naanajege! Bimu te mameta gyene äpula, krokeciiye me äbitenige.” Peei name pi tabe teeme mete me abacitige ten cama lenajame. ");
INSERT INTO bon_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tabe ten cama dade cabu adnatige, buluduu ne ecatige, Acejiyame ne eso ecärige, piba itrecige, ääcärige teebibine. ");
INSERT INTO bon_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Teeme irecu piba pajecu me äbitininisi, siige teebine opo ewatnäsi, yepä tabe puma cita ca teeme bau ca äyeblingtige. ");
INSERT INTO bon_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Teepi piba teemeteme ajanäsi egä, “Toraca, mime ngenecu cina niclonige gaabe cabu, tabe liba mene nijanige piiyepu Oogäräneji Mene bine mime tääpume eboclomäjemige!” ");
INSERT INTO bon_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Teepi dade gome ca wata abujengtäsi, Yerusalema cewe me acnenutäsi, puga edäremäsi pui lebin abiberäja bägrä bine piiyepu ten cama lui biname cina abasecretnige. ");
INSERT INTO bon_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Puma iyeta jaajisi teebibine egä, “Yageyame te toraca barpinantige! Tabe Simona bau bii taboclomtige!” ");
INSERT INTO bon_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Piba pui neeneni cina teebibine jejemäsi teeme tääpume ngena te äbitige gaabe cabu, piiyepu teepi lipu Yageyame ne opo ewatnäsi, tabe liba buluduu ne itremantige. ");
INSERT INTO bon_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Teepi liba peei mene cabu jage, piba taatu Yageyame Yeesu te teeme gome jeclajutige, teebibine jejemige egä, “Poode weene cama yaanajege!” ");
INSERT INTO bon_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Teepi cälu te jitemige wälu name pi, ingle teepi apu jenge-mige egä, “Cable gyene ai!” ");
INSERT INTO bon_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yepä, tabe teebibine jejemige egä, “Weene ngenome ngenecu jiclonininige? Ngenome neeneni ngene atwanena cama gemi? ");
INSERT INTO bon_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jepänemeye cäme ime piiyepu cäme ernge. Cane säne! Cebine noomleye, piba umle äbitininiye, ingle cable te lica mäju piiyepu kaake cama ge, weene cebine lipu näpäneniye tääpe cama.” ");
INSERT INTO bon_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tabe peei mene jejemige, teeme ime ernge jewabemige. ");
INSERT INTO bon_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Siige, teepi camuge cängena ätrunga, ingle teepi mutäcäco äbitininisi gege name pi. Tabe peei name pi teebibine itinärige egä, “Nää, deedei pisi nyene?” ");
INSERT INTO bon_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Teepi teebine toce cibu ecärisi, ");
INSERT INTO bon_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","tabe ecatige, siige teeme opo gaabe je erngige. ");
INSERT INTO bon_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tabe piba teebibine jejemige egä, “Age tema pui mule cane lui poto cidi me weebibine ituge jaji liba weene cama nanajepi. Yoo, cane apu jijipene egä iyeta Oogäräneji Mene cäme poto cidi me miiji ibibi me äbita; apu ge pui mene Moose lui itu soogäremuji, piiyepu mename biname lui mene soogäremujisi, cuta piiyepu iyeta Salamo uupera cabu lui mene.” ");
INSERT INTO bon_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tabe piba teeme ngene atwanena jiitnemige Oogäräneji Mene cängena umle äbitame. ");
INSERT INTO bon_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tabe teebibine jejemige egä, “Apu mene oogäräneji ge egä, Keriso, Israela biname bime niiya cabu ca äsecrera biname te miiji mäpu piiyepu budre päpäna, piba nesae bimu ingwe ca cirege arpinenta budre cabu ca. ");
INSERT INTO bon_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cuta apu oogäräneji ge egä, biname cina miiji ai mene jajanena iyeta mene maramara biname bine. Pui kaakesea miiji Yerusalema cewe cabu gije abacitame, piba cuta jajanena iyeta poto ta. Teepi miiji biname bine jajanena egä biname lui cina niiya mule cabu ca latatrongärininusi piiyepu cebine nätrungusi, Acejiyame teeme niiya mule bine pa yääyeblingemepi teebibine teeme biname me wawenecame. ");
INSERT INTO bon_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Weene lui ire arbi biname gemi iyeta ai mule poto cidi me. ");
INSERT INTO bon_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yoo, cane weeme bau me pa tätyepepene cäme Babe te lui ne ituge jaji weebibine ceerame, peei lui Aceji Seemo gyene. Yepä, weene ama ai babo cewe cabu inajininige ngälu teeme kokre te cabucewe ca pa täinepi weeme cabu me.” ");
INSERT INTO bon_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeesu teeme abiberäja bägrä bine ewademige Yerusalema cabu ca Betaniya cewe mameta me. Puma tabe ime aawepäntige miiji ne acitame teeme cabu me. ");
INSERT INTO bon_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Egäcäro teebibine miiji ecäremige, tabe teebibine sebmalemige. Acejiyame me kokre te teebine cabu me ewepäntige. ");
INSERT INTO bon_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Abiberäja bägrä cina teebine ewepyeräjisi, piba babo gege piiyepu ngenecu miiji cama äcnärige Yerusalema cewe me. ");
INSERT INTO bon_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Teepi iiwäreja mete caale bora yaacrajuge, puga Acejiyame ne eso yääcäranusi. Siige mene ngälu peese. ");
INSERT INTO bon_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gawecewe te cäro camu ge aci, Mene te uja ge. Mene te Acejiyame cama ge, tabe Acejiyame ge. ");
INSERT INTO bon_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Agedna me niinäce gaabe me tabe lui Acejiyame cama ge. ");
INSERT INTO bon_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iyeta gwidape bine Acejiyame teeme cabu ca jewenimuji; teeme cäco je nuuja gwidape te lica äbituji. ");
INSERT INTO bon_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Teeme cabu ireclota puga ge; pui ireclota lui apaclyera ge biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pui apaclyera te krokeciiye cabu me tuungepmalenige, yepä biname lui cina krokeciiye cabu je, teepi opo lica ituge awatna pui apaclyera ne. ");
INSERT INTO bon_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Acejiyame te tityepuji biname ngii Yoane ne ");
INSERT INTO bon_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","pui apaclyera ne aitnejame naace tääpume iyeta biname cina teebine ätecijame piiyepu ätrungame. ");
INSERT INTO bon_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tabe te lica ge pui apaclyera, tabe yepä jeitnäjuji teebine. ");
INSERT INTO bon_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Toraca apaclyera, lui te iyeta biname bine saapaclyäremuge, täduji gawecewe cabu me. ");
INSERT INTO bon_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tabe gawecewe cabu jage, Acejiyame lui ne teeme cabu ca jewenuji, yepä biname cina teebine opo lica ewatnujisi. ");
INSERT INTO bon_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tabe teemerage gawe cabu me täduji, yepä teemerage biname cina teebine lica ecatujisi. ");
INSERT INTO bon_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yepä lui cina teebine ecatujisi piiyepu jitrungujisi, tabe teebibine conocäco ecärimuji Acejiyame me bägräwale tääpume. ");
INSERT INTO bon_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Teepi Acejiyame me bägräwale me epu lica äbitininujisi, biname bime cabu ca lipu laplimlininusi binamerage babe me bägrä me, yepä tabe Acejiyamerage te jewenimuji teeme bägräwale me. ");
INSERT INTO bon_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yoo, Mene te äbituji biname me, mine cama senajenäjumi. Tabe lui Babe me japurage Bägrä ge. Mine jepänujisi kokre ne, Babe te lui secäruji teebine. Tabe lui toraca piiyepu owecu biname ge. ");
INSERT INTO bon_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoane te teebine jeitnäjuji, ala abayanuji egä, “Age sena, cane lui tääpume jiicepene egä: Cäme ingwe poto ca lui te pa tädepi, baborage gyene cäme bau ca, ingle cane liba camu ge aplimla, tabe piba Babe cama jage.” ");
INSERT INTO bon_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tabe baborage owecu mime tääpume, peei name pi tabe bucurage miijimiji mule bine tewenemäjumi mime tääpume. Tabe iyeta padare cabu miiji niwenenanimi. ");
INSERT INTO bon_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Acejiyame te Cotre mene secäruji Moose ne, yepä Yeesu Keriso te taacanuji owecu mule ne piiyepu toraca mule ne. ");
INSERT INTO bon_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nuuja te lica ituge Acejiyame ne päpäna, yepä teeme japurage Bägrä, lui te Acejiyame cama yepä gyene, piiyepu lui te Babe gome enajenige, tabe te teebine biname bime cabu me seboclomtuji. ");
INSERT INTO bon_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israela biname cina Yerusalema ca jityepimisi iiwäreja biname bine piiyepu Leebi me ingle cabu ca biname bine Yoane bau me teebine ätemlame egä, “Maane laasi näte?” ");
INSERT INTO bon_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yoane lica ainige, yepä tabe cängenarage awabudnitige egä, “Cane Keriso lica gäne, Acejiyame te lui ne ätyepame tiicuji biname bine niiya cabu ca äsecrerame. Cane pui lica gäne.” ");
INSERT INTO bon_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Teepi piba itemlisi egä, “Cije maane laasi näte? Maane nää Acejiyame me mename biname Eliya säte?” Tabe jejemige egä, “Eewe, cane Eliya lica gäne.” Teepi cuta itemlisi egä, “Nää, maane pui mename biname gäte, cine lui ne jewagrijenisi?” Tabe jejemige egä, “Eewe, cane tabe lica gäne.” ");
INSERT INTO bon_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Teepi puma cita ca jejisi egä, “Nijini toracarage, maane laasi näte, cine piba daremu mene jewecnistenemisi, lui cina cibibine nityepinisi. Maane lipu ngene jotwananenite, egä maane laasi näte?” ");
INSERT INTO bon_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoane jejemige teebibine mename biname Isaya me mene ca egä, “Cane age säne pui biname, lui te ala abayanenine daapo taatu cewe cabu ca egä, ‘Gaabe ne conocäcorage emacetnäjeye Yageyame me otni tääpume!’” ");
INSERT INTO bon_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pui biname cina seclige Yoane bau me, ingle Parisea sigu biname cina tityepimisi. ");
INSERT INTO bon_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yoo siige, teepi cuta teebine itemlisi egä, “Cije maane piba ngena tääpume biname bine niiye ca jääcisäjemute, maane liba Keriso lica gäte, coo liba Eliya lica gäte coo piiyepu pui Acejiyame me mename biname, cine lui ne jewagrijenisi?” ");
INSERT INTO bon_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Puma cita ca Yoane teebibine jejemige egä, “Cane niiye ca biname bine jicisäjenenemine, yepä weene cama pisi nyene nuuja biname, weene lui tääpume umle lica gemi. ");
INSERT INTO bon_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tabe cäme ingwe gaabe ca teeme kaakesea ne tegedninige, yepä tabe baborage gyene cäme cabu ca. Cane ibibi lica gäne teeme ernge gwidape seea bine iibirame.” ");
INSERT INTO bon_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ai mule te äpletnutige Betaniya cewe je Yoridana baduge me bimu acita gome ca, Yoane luma biname bine niiye ca jicisäjemige. ");
INSERT INTO bon_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nuuja bimu cabu Yoane jepänige Yeesu ne otni je teeme bau me, siige tabe jiicige egä, “Ire, Acejiyame me Maamoi peese nyene, gawecewe me niiya ne lui te pa yaacatepi. ");
INSERT INTO bon_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tabe sine pui biname, cane lui tääpume tiicumene egä, ‘Cäme ingwe gaabe ca biname te pa tädepi, yepä tabe baborage gyene cäme bau ca, ingle cane liba camu ge aplimla, tabe uja Babe cama jage.’ ");
INSERT INTO bon_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Cane cuta niinäce umle lica ge, tabe laati tage, yepä cane puu gije labacitepene Israela biname bine niiye ca äcisejame teepi umle äbitame teeme poto cidi me.” ");
INSERT INTO bon_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Puma cita ca Yoane Yeesu ne jeitnäjige egä, “Cane jepänine Aceji Seemo ne äina je cabucewe ca gimäe ele pana siige teeme papa cabu lenaja je. ");
INSERT INTO bon_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cane umle lica ge tabe, yepä Acejiyame lui te cebine nätyepepi biname bine niiye ca äcisejame, tabe najepi egä, ‘Maane lui me papa cabu pa jepänepi Aceji Seemo te äina je siige teeme papa cabu lenaja je, tabe peese nyene, lui te biname bine Aceji Seemo ca pagege äciseja.’ ");
INSERT INTO bon_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cane siige ai mule ne tepänumene, siige jeitnäjenine, egä tabe peese nyene Acejiyame me Bägrä.” ");
INSERT INTO bon_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nuuja bimu cabu Yoane niiye ca äciseja biname cääri cuta puga ge teeme neeneni abiberäja bägrä cama. ");
INSERT INTO bon_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tabe liba Yeesu ne jepänige teebibine äsuplengta je, tabe jaajige egä, “Ire, Acejiyame me Maamoi peese nyene!” ");
INSERT INTO bon_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Teeme neeneni abiberäja bägrä cina liba äätecijige tabe apu iicana je, teepi Yeesu me ingwe poto ca aaclige. ");
INSERT INTO bon_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu tatatrongtige, jääpänige teeme bau me otni je, äätemlige egä, “Baa, weene ngena ne jirngeniye?” Teepi jejäsi egä, “Raabi, maane luma naanajinige?” (Raabi me aboclomta mene lui ‘Abiberäja biname.’) ");
INSERT INTO bon_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tabe jaajige egä, “Siclege päpäname.” Teepi aaclige, siige jepänäsi teeme lenaja puupu ne. Ai mule te äbitige mämle bimu me, siige teepi pui bimu ne epiräsi Yeesu cama lenaja je. ");
INSERT INTO bon_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoo, Yoane me mene lui neeneni biname cina äätecijige, siige Yeesu cama aaclige, teeme yepä lui Andrea tage. Andrea lui Simona Peteru me igane ge. ");
INSERT INTO bon_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Teeme otni ingwe ca ge, tabe niinäce teeme naane Simona ne jirngige, jejige egä, “Cine Mesaya ne bii jepänago. Tabe peese nyene biname, lui te biname bine niiya cabu ca cirege äsecrera.” (Mesaya me aboclomta lui yepä gyene Keriso cama.) ");
INSERT INTO bon_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Siige Andrea te Simona ne Yeesu bau me ecanige. Yeesu ire acitige teeme cabu me, jejige egä, “Maane lui Simona säte, Yoane me bägrä. Cane meebine ngii naainenine Keepa ca.” (Keepa Griik mene ca lui Peteru, lui me aboclomta mene egä ‘Kula’.) ");
INSERT INTO bon_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nuuja bimu Yeesu ngene jotwanige Galilaya probins me otnime. Puma cita ca tabe Pilipo ne jepänige, jejige egä, “Tädi cane cama otnime!” ");
INSERT INTO bon_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo lui Betesaida ceweyame ge, Andrea naabi Simona luma cita ca ge. ");
INSERT INTO bon_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo Natanaela ne jepänige, jejige egä, “Cine pui biname ne jepänisi, Moose lui poto cidi me ituge Cotre cabu mene iicana, piiyepu cuta Acejiyame me mename biname cina lui poto cidi me ituge oogära. Tabe lui Yeesu sine, Yoosepa me bägrä Nasareta babo cewe cabu ca.” ");
INSERT INTO bon_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaela Pilipo ne itemlige, “Nää, nuuja miiji gwidape miiji gyene pepu papa cewe ca otni Nasareta liiyepu?” Pilipo jejige egä, “Maane tädi aima päpäname!” ");
INSERT INTO bon_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yeesu liba jepänige Natanaela ne teeme bau me otni je, tabe jiicige teeme poto cidi me egä, “Ai biname lui toraca Israela biname gyene. Teeme cabu nuuja walya lica gyene.” ");
INSERT INTO bon_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaela Yeesu ne itemlige egä, “Maane lipu umle gäte cane?” Yeesu jejige egä, “Cane niinäce meebine nääpänine piigi uli gawe je, Pilipo ingwe ca ala naasoglicige.” ");
INSERT INTO bon_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Puma cita ca Natanaela teebine jejige egä, “Abiberäja biname, maane Acejiyame me Bägrä gäte! Maane Israela biname bime mope biname gäte!” ");
INSERT INTO bon_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu Natanaela ne jejige, “Maane naace name pi cebine nätrungenite, ingle cane lipu naajine, egä cane meebine nääpänine piigi uli gawe je. Ai puu matikäli mule gyene, yepä ebä pagege maane modamoda mule bine päpänena. ");
INSERT INTO bon_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Cane toraca jijenine weebibine, egä weene cabucewe ne pagege päpäna iitneji, siige Acejiyame me mename seemo cina page yaaclepi cabu me cuta puma cita ca page täinetnepi biname cabu me, Acejiyame bau ca lui te täduji biname me äbituji.” ");
INSERT INTO bon_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nesae bimu ingwe gaabe ca atejäclmuta soriyomu puga ge Kaana cewe je Galilaya probins ngalebora. Yeesu me mage puga ge, ");
INSERT INTO bon_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","cuta Yeesu ne teeme abiberäja bägrä cama ituge ala asogleca. ");
INSERT INTO bon_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Biname cina liba deedei loolo cabu jage, waina niiye te piba apirige. Puma cita ca Yeesu me mage te teebine jejige egä, “Teeme waina niiye lica gyene.” ");
INSERT INTO bon_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu teeme mage ne jojige, “Magebi, maane cebine gone jaji cane ngena wawename. Cäme padare te lica bii tatyaramtige.” ");
INSERT INTO bon_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yepä mage te kaakesea bägrä bine jejemige egä, “Weene jeweneye, Yeesu ngena tääpume jijenininige.” ");
INSERT INTO bon_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Teeme Israela biname bime cotre puga ge teepi lipulipu äcisejame cude gwidape oomlana cabu ca. Ai ingle name pi pui mete cabu puga ge kula ca wawenäneji siks modamoda niiye ängärena gwidape; teepi iyeta ibibi ge yepä hanred liita niiye tääpume. ");
INSERT INTO bon_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Puma Yeesu kaakesea bägrä bine jejemige, “Weene ai bine niiye jengäremeye!” Teepi siige jengärimisi, ngälu tapananinisi. ");
INSERT INTO bon_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Piba tabe teebibine jejemige, “Weene niiye siiteye ängära gwidape cabu ca, ecaneye deedei ire atwi biname bau me.” Siige kaakesea bägrä cina ängära gwidape cabu ca niiye siitisi, ecanisi deedei ire atwi biname bau me. ");
INSERT INTO bon_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tabe liba mite eglige, niiye te uja waina niiye me bäbitige. Laatibi siitisi niiye ne, teepi umle ge, egä waina niiye luma cita ca gyene, yepä deedei ire atwi biname te tabe umle lica ge. Peei name pi tabe ala tesoglicige mamye rooriye ne, ");
INSERT INTO bon_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","jejige egä, “Mime mule gyene soriyomu biname bine miiji waina niiye niinäce ceera, siige teepi liba bucurage yäänäjimusi, ingwe ca piba yääcäranemusi papa waina niiye. Maane lipulipu miijirage waina niiye ne ewetnite ceräcerägääbu ceerame?” ");
INSERT INTO bon_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeesu ai teeme niinäcerage ciitaca mule ne jewenige Kaana cewe je Galilaya probins ngalebora. Apu pi tabe teeme kokre ne eboclomtige, siige teeme abiberäja bägrä cina teebine jitrungisi. ");
INSERT INTO bon_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ai ingwe gaabe ca Yeesu ädige Kaprenauma cewe me teeme mage, iganewale piiyepu abiberäja bägrä cama. Teepi puga icrajige nesae bimu cama. ");
INSERT INTO bon_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israela biname bime äsuplengta soriyomu padare te liba mameta ge Yeesu piba ädige Yerusalema me. ");
INSERT INTO bon_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Puma tabe abacitige iiwäreja mete caale bora me, siige jepänimige biname bine kau, maamoi piiyepu gimäe ele bine aletnena je iiwäreja tääpume. Tabe cuta jepänimige rarekaake äbäsuwäja biname adnatäreji ge teeme dade gome. ");
INSERT INTO bon_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Puma cita ca tabe seea bine sigu jewenimige, siige teebibine teeme kau piiyepu maamoi cama iyecräjemige iiwäreja mete caale bora ca. Piba tabe rarekaake äbäsuwäja biname bime rarekaake bine jeglemeläjimige gawe cabu me piiyepu teeme dade bine eboclomäjimige. ");
INSERT INTO bon_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gimäe bine lui cina aletname saawadanemusi, tabe teebibine jejemige egä, “Gimäe bine isemeye! Weene cäme Babe me mete ne gone jeweneniye aletnaletna puupu me!” ");
INSERT INTO bon_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abiberäja bägrä cina liba jepänisi, Yeesu ngena jewenige, teepi ngene jotwinisi mene lipu oogäräneji gyene egä, “Cäme ngenecu nabenige Acejiyame me mete tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israela modamoda biname cina liba jepänisi Yeesu ngena jewenige, teepi itemlisi egä, “Maane ngena ciitaca mule ne jewenenite cine päpäname, egä määme conocäco pisi nyene ai mule ne wawename?” ");
INSERT INTO bon_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu jejemige egä, “Ai iiwäreja mete ne yiigarecepeye. Cane te nesae bimu cama cääri pa yaarangepene.” ");
INSERT INTO bon_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Teepi teeme mene ingle ne opo lica ewatnisi, siige jejisi egä, “Ai iiwäreja mete ne lui footisiks kämäge ngalebora erangujisi. Nää, maane te nesae bimu cama pa perangepi?” ");
INSERT INTO bon_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yepä Yeesu pui iiwäreja mete poto cidi me lica jiicuji, yepä tabe teeme tääpe poto cidi me jiicuji. ");
INSERT INTO bon_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ingwe gaabe ca tabe liba budre cabu ca arpinantuji, teeme abiberäja bägrä cina piba ngene jotwinujisi teeme ai mene, siige teepi jitrungujisi lui mene oogäräneji gyene, cuta teepi jitrungujisi Yeesu ngena ituge iicana. ");
INSERT INTO bon_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yeesu liba Yerusalema je puga ge äsuplengta trii padare cabu, bucurage biname cina teebine jitrungisi, teepi lipu jepänisi tabe lui ciitaca mule bine jewenimige. ");
INSERT INTO bon_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yepä Yeesu lica awabudni-tige biname bime bau me, ingle tabe umle ge, teepi iyeta lipu gemi. ");
INSERT INTO bon_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yeesu singi lica ge nuuja te teebine umle wawename, egä biname lipu gemi, ingle tabe iyeta umle ge teeme poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Puga ge yepä Parisea sigu biname ngii Nikodemo. Tabe Israela biname bime yepä mutre biname ge. ");
INSERT INTO bon_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ciiye cabu tabe Yeesu bau me ädige, jejige egä, “Raabi, cine umle gemi, egä Acejiyame te meebine näätyepuji abiberäjame. Nuuja te äblicäco gyene apu ciitaca mule bine wawenena maane lui bine jewenenemite, liba Acejiyame lica gyene teta cama.” ");
INSERT INTO bon_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu teebine jejige egä, “Cane toraca naajenine, biname te liba kirece lica laplimluge, tabe äblicäco äbita biname me, Acejiyame lui ne yaacanuge.” ");
INSERT INTO bon_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yepä Nikodemo Yeesu me mene opo lica ewatnige, siige itemlige egä, “Babo biname te lipulipu cääri laplimluge? Tabe äblicäco mage me came bora me abacita cuta cääri aplimla tääpume!” ");
INSERT INTO bon_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu jejige egä, “Cane toraca naajenine, biname te liba lica birige aplimla niiye piiyepu Aceji Seemo cabu ca, Acejiyame te lica teebine acana. ");
INSERT INTO bon_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Biname me tääpe laplimluge mage cabu ca, yepä Acejiyame me Seemo te teeme seemo ne ireclota yääcäruge. ");
INSERT INTO bon_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Peei name pi cälu te gone näätuge, cane lipu naajine, egä weene miiji kirece aplimla. ");
INSERT INTO bon_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buuwe te singi liiye yene, tabe piiyeme jääpwäjuge. Weene mumwämu itecijinuge, yepä weene umle lica gemi, luma cita ca tädenige coo liiyeme ädenige. Pepu gyene biname bime tääpume, lui cina Aceji Seemo cabu ca laplimli-ninusi.” ");
INSERT INTO bon_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo Yeesu ne itemlige, “Peei lipu gyene?” ");
INSERT INTO bon_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu jejige egä, “Maane Israela biname bime abiberäja biname gäte, maane lipulipu umle lica gäte ai poto cidi me! ");
INSERT INTO bon_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cane toraca naajenine meebine, egä cine jiicemusi, cine lui tääpume umle, cuta jaaitnimusi cine lui bine jääpänimusi, yepä weene lica yaacatuye cime mene ne. ");
INSERT INTO bon_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Weene cebine lica nätrunguye, cane liba jijananinune ai gawecewe me mule poto cidi me; weene piba lipulipu cije ätrunga cebine, cane liba jijananinune cabucewe me mule poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nuuja te lica ituge otni cabucewe me, yepä Acejiyame bau ca lui te täduji biname me äbituji, tabe taatu ge. ");
INSERT INTO bon_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moose te daapo taatu cewe cabu cobyame ne ewepäntuji cabu me. Lui cina pui cobyame cabu me ire acranininujisi, teepi ireclota icrajuji. Cuta pepu pana pagege baarge uli cabu awepenta teebine, Acejiyame bau ca lui te täduji biname me äbituji, ");
INSERT INTO bon_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","siige iyeta lui cina teebine jäätrungusi, teepi iyeteta ireclota ne birige päpäna. ");
INSERT INTO bon_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Acejiyame te epu babo singi ge biname bime tääpume, egä tabe teeme japurage Bägrä ne tityepuji, siige laati te liba teebine jäätrunguge, tabe lica birige apesera yepä tabe iyeteta ireclota ne päpäna. ");
INSERT INTO bon_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Acejiyame te lica teeme Bägrä ne tityepuji ai gawecewe cabu me biname bine atraname niiya puupu cabu me otnime, yepä tabe naace tääpume tityepuji tabe teebibine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Laati te teebine jäätrunguge, Acejiyame te lica pui biname ne jaatranuge. Yepä laati te lica jäätrunguge teebine, pui biname ne uja ituge atrana, ingle tabe lica ituge ätrunga acita Acejiyame me japurage Bägrä me ngii cabu me. ");
INSERT INTO bon_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Teepi atranäneji gemi, ingle apaclyera te itu täduji ai gawecewe cabu me, yepä teepi singi lica ge apaclyera tääpume; teepi krokeciiye tääpume singi, ingle teeme mule lui niiyarage gemi. ");
INSERT INTO bon_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iyeta lui cina niiyaniya mule bine jaawenimusi, teepi apaclyera ne jäägyusi. Teepi lica saacluge apaclyera cabu me, cije apaclyera te teeme mule bine jaawabudnemuge. ");
INSERT INTO bon_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yepä laatibi toraca mule bine jaawenimusi, teepi apaclyera cabu me saacluge, siige apaclyera te jaawabudne-muge, egä teepi lui mule bine jaawenimusi, Acejiyame me singi ibi gemi.” ");
INSERT INTO bon_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ai ingwe gaabe ca Yeesu teeme abiberäja bägrä cama ädige Yuudea probins cabu me. Tabe puga teta cama enajige matikolä padare cabu, biname bine niiye ca jicisäjemige. ");
INSERT INTO bon_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoane cuta niiye ca biname bine jicisäjemige cewe ngii Aenona je lui Salima cewe mameta ge, ingle baborage niiye puga ge, siige biname cina totninisi Yoane bau me niiye ca äciseja tääpume. ");
INSERT INTO bon_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yoane ne camu ge pui padare cabu krokeciiye mete cabu me äsinglenta. ");
INSERT INTO bon_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Puma cita ca Yoane me abiberäja bägrä cina gije abacitinisi yepä Israela biname cama äcelame teeme Israela biname bime äciseja mule poto cidi me, teepi lipulipu cude gwidape cabu ca kälyä läbitaninusi. ");
INSERT INTO bon_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Siige teepi seclige Yoane bau me, jejisi egä, “Abiberäja biname, maane cama lui biname tage Yoridana baduge nuuja poto doro ca, maane lui ne teitnäjumete, tabe cuta page biname bine niiye ca jicisäjenenemige, siige bucurage cina piiyeme otnenininisi teeme bau me.” ");
INSERT INTO bon_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoane jejemige egä, “Nuuja biname te äblicäco pepu mule ne acata, Acejiyame te liba lica yääcäruge teebine. ");
INSERT INTO bon_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Weene weemämu ituge ätecija, cane lipu itu jiicepene, egä cane Keriso lica gäne, Acejiyame te lui ne ätyepa biname bine niiya cabu ca äsecrerame, yepä cebine teeme niinäce gaabe me ituge ätyepa. ");
INSERT INTO bon_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mamye magebi lui mamye rooriye tääpu mwene. Yepä mamye rooriye me biname lui te jaaclajutuge teeme gome, teeme mene jäätecijuge, tabe gege birige teeme tagepogogo ätecijame. Yeesu lui mamye rooriye pana gyene, peei name pi cane babo gege gäne teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tabe miiji baborage me äbita, cane matikolä me äbita. ");
INSERT INTO bon_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Lui te cabucewe ca täduji, tabe sine baborage iyeta bime cabu ca. Lui te gawecewe cabu ca gyene, tabe gawecewe tääpu myene, siige gawecewe mule poto cidi me jiicemimuge. Yepä cabucewe ca lui te täduji, tabe baborage gyene iyeta poto bime bau ca. ");
INSERT INTO bon_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tabe eei bine jeitnäjenenemige, tabe lui bine ituge päpänena piiyepu tabe lui poto cidi me ituge ätecijana, yepä biname cina lica ecatisi teeme aitneja ne. ");
INSERT INTO bon_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yepä laati te liba yaacatuge teeme mene ne, tabe jaawabudnituge, egä Acejiyame lui toraca gyene. ");
INSERT INTO bon_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Acejiyame lui ne tityepuji, tabe Acejiyame me Mene jiicemimuge, ingle Acejiyame te teebine Aceji Seemo iyeta teeme kokre cama ituge ceera. ");
INSERT INTO bon_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Babe te singi gyene teeme Bägrä tääpume, siige iyeta gwidape ituge acrana teeme ime cabu. ");
INSERT INTO bon_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Laati te Bägrä ne jäätrunguge, tabe iyeteta ireclota ne jääpänuge. Yepä laati te Bägrä ne lica jäätrunguge, tabe pui ireclota ne lica jääpänuge, yepä Acejiyame me claabe te yaanajuge teeme cabu.” ");
INSERT INTO bon_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisea sigu biname cina itecijemige, egä Yeesu bucurage biname bine niiye ca jicisäjemige, Yoane nesae bine; cuta teeme abiberäja bägrä bucurage ge, Yoane me nesae ge. ");
INSERT INTO bon_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Puu Yeesurage te biname bine lica jicisäjemige yepä teeme abiberäja bägrä cina. ");
INSERT INTO bon_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yeesu liba umle äbitige, egä Parisea sigu biname cina umle bäbitininisi ai poto cidi me, tabe Yuudea probins ne ebmalige, ädige Galilaya probins cabu me. ");
INSERT INTO bon_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tabe miiji ge Samariya probins cabu ta otni Galilaya probins ne oomlaname. ");
INSERT INTO bon_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tabe liba ädige, tabe atyaramtige yepä Samariya cewe ngii Suuka me. Pui cewe lui calwacupi mameta gyene, Yakobu lui calwacupi teeme bägrä Yoosepa ne ecäruji. ");
INSERT INTO bon_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakobu me niiye cupicu cuta puga ge. Yeesu worämu te joomlige, ingle lecaleca padare lipu otnige, siige tabe adnatige cupicu gome. Pui lui bimu duusa ge. ");
INSERT INTO bon_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Puma cita ca yepä Samariya magebi te toclige niiye iitaname. Yeesu jojige egä, “Cäme niiye niiti nanime!” ");
INSERT INTO bon_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Abiberäja bägrä puga lica ge. Teepi cewe me beclige deedei aletname. ");
INSERT INTO bon_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Siige magebi te Yeesu ne jejige egä, “Maane lui Israela biname gäte, maane lipulipu najite cane Samariya magebi te määme niiye iitaname?” Tabe naace popi apu jejige, ingle Israela biname piiyepu Samariya biname teepi cude padare ge. Teepi gigri deedei gwidape bine lica jääbämuyäjimusi. ");
INSERT INTO bon_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeesu magebi ne jojige egä, “Maane liba umle cirege, egä Acejiyame te ngena bine miiji gyene ceera piiyepu cane laasi näne lui te meebine niiye tääpume näätinärine, maane nätinärejite, cane ireclota niiye nääcärejine meebine.” ");
INSERT INTO bon_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Magebi te jejige, “Babo biname, cupicu lui uuglerage gyene, cuta määme iitana gwidape lica gyene; luma cita ca pui ireclota niiye ne siitenite? ");
INSERT INTO bon_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nää, maane baborage gäte mime kaakesaare Yakobu bau ca, ai cupicu ne lui te nicärinuji? Tabe ama cita ca niiye ne senajenäjumi, cuta teeme bägrä cina piiyepu cuta teeme ngeerangera cibu cina.” ");
INSERT INTO bon_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu jojige egä, “Iyeta, lui cina ai niiye ne enenisi, pagege cääri niiyemecewe jajwi. ");
INSERT INTO bon_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yepä laati te yaanuge, cane lui niiye yääcärune, tabe ingwe ca lica pagege niiyemecewe jajwi. Cane lui niiye yääcärune, teeme cabu waja me läbituge, siige tuudruge iyeteta ireclota tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Piba magebi te jejige, “Babo biname, näcäri pui niiye! Piba ingwe ca cane lica pagege niiyemecewe jajwi, cuta lica pa twaatnepene aima niiye iitanename.” ");
INSERT INTO bon_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu jojige egä, “Äte, määme rooriye ne serwojuti!” ");
INSERT INTO bon_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tabe jejige egä, “Eewe, cäme rooriye lica gyene.” Yeesu jojige egä, “Toraca gyene, maane lipu najite, egä määme rooriye lica gyene. ");
INSERT INTO bon_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Maane niinäce faib rooriye bine yaawadanemepete, page lui rooriye ne ecananenite, määmerage rooriye lica gyene peei. Maane peei toraca najite.” ");
INSERT INTO bon_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Magebi te Yeesu ne jejige egä, “Babo biname, cane ngene ca naagline, egä maane Acejiyame me mename biname gäte. ");
INSERT INTO bon_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Cine Samariya biname bime kaakesaare cina ai podo cabu irecu lätumutanininusi Acejiyame bau me, yepä weene Israela biname cina jiicuye, egä Acejiyame ne miiji Yerusalema taatu je awejena. Maane lipu ngene jotwananenite ai poto cidi me?” ");
INSERT INTO bon_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu jowecnistige egä, “Cäme mene nacati, padare te pa tädepi, biname cina liba lica Acejiyame bau me pagege irecu ätumuta ai podo cabu coo Yerusalema je. ");
INSERT INTO bon_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Weene Samariya biname toraca umle lica gemi, weene laati bau me irecu lätumutanininuye, yepä cine Israela biname cina umle gemi, cine laati bau me irecu lätumutanininago, ingle Israela biname bime cabu ca gyene biname, lui te pagege biname bine niiya cabu ca äsecrera. ");
INSERT INTO bon_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Padare te tädenige – siige uja bii tatyaramtige – liba toraca irecu ätumuta biname cina Acejiyame bau me pagege irecu ätumuta teeme seemo ca piiyepu toraca ngene atwanena cama. Apu irecu ätumuta biname tääpume Acejiyame singi gyene. ");
INSERT INTO bon_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Acejiyame lui Seemo gyene, siige laatibi teeme bau me irecu lätumutanininusi, teepi miiji irecu ätumuta teeme seemo ca piiyepu toraca ngene atwana cama.” ");
INSERT INTO bon_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Puma cita ca magebi te Yeesu ne jejige egä, “Cane nata umle gäne, egä Mesaya, lui ne yaainusi Keriso ca, pagege otni, siige tabe te iyeta gwidape bine mime bau me pagege aboclomäja.” ");
INSERT INTO bon_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu jojige egä, “Cane age säne pui biname, lui te mene naajanenine.” ");
INSERT INTO bon_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Puirage padare cabu abiberäja bägrä cina tatyarige, cälu te jitemige, liba Yeesu ne jepänisi magebi cama mene iicema je. Yepä nuuja te lica itemlige, egä tabe ngena tääpume singi, cuta magebi cama ngena tääpume mene jiicemenige. ");
INSERT INTO bon_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Puma cita ca magebi te teeme niiye iitana gwidape ne ebmalige cupicu gome, oclige babo cewe me, siige biname bine jejemige puma egä, ");
INSERT INTO bon_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Naaclege biname ne päpäname, lui te umle gyene iyeta, cane ngena ituge wawenetnäja. Nää pama Keriso sine, Acejiyame te lui ne ätyepame biname bine äsecrerame niiya cabu ca?” ");
INSERT INTO bon_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Siige teepi babo cewe ne sebmalisi, Yeesu bau me seclige. ");
INSERT INTO bon_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Magebi te liba babo cewe jage, abiberäja bägrä cina piba Yeesu ne jejisi egä deedei äbitame. ");
INSERT INTO bon_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yepä tabe jejemige egä, “Cäme piti nemi deedei loolo me, weene lui tääpume umle cäco gemi.” ");
INSERT INTO bon_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Abiberäja bägrä cina teemeteme jitranisi, egä nuuja biname te pama bii tewadimige deedei teeme loolo me. ");
INSERT INTO bon_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu piba jejemige egä, “Cäme deedei lui eei gyene, cane teeme singi ne wawename lui te cebine itu nätyepuji piiyepu ämlitejame tabe lui kaakesea itu näcäruji cane wawename. ");
INSERT INTO bon_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Weene jiiceniye egä, ‘Cerämu fooa mabye piti nemi piiyeme ärucna padare oomla-name.’ Yepä cane jiicenine, egä calwacupi bine jepänemeye! Iyeta gwidape kuu cama gemi ärucna tääpume. ");
INSERT INTO bon_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Siige ärucna biname te page daremu ne jepänenige, kuu bine etomlecnemige iyeteta ireclota tääpume. Siige ätema biname piiyepu ärucna biname teepi gigri gege äbitenäsi. ");
INSERT INTO bon_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ai iicana lui toraca gyene egä, ‘Nuuja te yäätemuge, nuuja te yäärucnimuge.’ ");
INSERT INTO bon_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Cane weebibine itu jityepipene ärucname, weene luma kaakesea lica ituge wawena. Poto cina ituge puma kaakesea wawena, weene yepä ärucna taatu memi.” ");
INSERT INTO bon_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bucurage biname pui Samariya cewe cabu Yeesu ne jitru-ngisi, ingle pui magebi te lipu teebine jeitnäjige egä, “Tabe umle gyene iyeta cane lui bine ituge wawenetnäja.” ");
INSERT INTO bon_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Puma cita ca Samariya biname cina liba eclige Yeesu bau me, teepi jejisi teta cama lenajame, siige tabe puma enajige neeneni bimu cama. ");
INSERT INTO bon_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cerämu bucurage biname cina Yeesu ne jitrungisi, teepi liba itecijemige teeme mene. ");
INSERT INTO bon_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Teepi pui magebi ne jojisi egä, “Siige page cine cerämu määme mene name pi taatu teebine lica jitrunge-nisi, ingle cine cinerage te bii nitecijinige teeme mene. Cine siige umle gemi, egä peese nyene biname, lui te biname bine pa yääsecräremepi niiya cabu ca.” ");
INSERT INTO bon_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Neeneni bimu ingwe gaabe ca Yeesu Samariya probins ne sebmalige Galilaya probins cabu me ädige, teemerage cewe luma. ");
INSERT INTO bon_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tabe apu ituge iicana egä, “Acejiyame me mename biname ne yaacatusi iyeta poto ta, yepä lica teemerage cewe cabu je.” ");
INSERT INTO bon_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yepä ai taje tabe liba Galilaya probins cabu me ädige, biname cina miijirage jewablisi, ingle teepi niinäce itu yaaclepi Yerusalema babo cewe me äsuplengta bimu ne ngene apecname; siige teepi puga jääpänepesi, Yeesu ngena mule bine jaawenemepi. ");
INSERT INTO bon_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Puma cita ca Yeesu Kaana cewe me acnenutige lui Galilaya probins cabu jage. Peese nyene pui cewe, tabe luma niinäce niiyerage ne waina niiye tääpume yaateplingtepi. Galilaya probins cabu Kaprenauma cewe je yepä Rooma gabmani babo biname puga ge, lui me bägrä pita cama ge. ");
INSERT INTO bon_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tabe liba itecijige, egä Yeesu Yuudea probins cabu ca tacnige Galilaya probins cabu me, tabe ädige, siige jejige tabe Kaprenauma cewe me otnime teeme bägrä, lui te budre mameta ge, teebine pita cabu ca miiji wawename. ");
INSERT INTO bon_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeesu teebine jejige, “Weene liba ciitaca mule piiyepu kokre mule bine lica jääpänimuye, weene ätrunga lica birige.” ");
INSERT INTO bon_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yepä tabe Yeesu ne jejige egä, “Yageyame, tädi watata, cije cäme bägrä te budre läbituge.” ");
INSERT INTO bon_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeesu jejige egä, “Äte acnenuti, määme bägrä te ireclota gyene!” Siige tabe Yeesu me mene jecatige, acnenutige teeme cewe me. ");
INSERT INTO bon_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tabe liba acnenutige, teeme kaakesea bägrä cina teebine potera jewenisi gaabe lamlecu je, jejisi egä, “Määme bägrä ireclota gyene.” ");
INSERT INTO bon_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Siige tabe itemlimige, egä lui padare cabu tabe gije abacitige miiji äbitame. Teepi jejisi egä, “Birice bimu duusa kaake poto cidi ca gebale te piba sebmalumi teebine.” ");
INSERT INTO bon_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Babe te ngene jotwige, egä puirage padare cabu Yeesu piba najumi egä, “Määme bägrä ireclota gyene.” Siige tabe teeme binamewale cama Yeesu ne jitrungige. ");
INSERT INTO bon_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ai lui neeneni manu ciitaca mule gyene Yeesu wawename, tabe liba Yuudea probins cabu ca Galilaya probins cabu me tacnenutige. ");
INSERT INTO bon_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ai ingwe gaabe ca Yeesu Yerusalema babo cewe me ädige Israela biname bime yepä soriyomu tääpume. ");
INSERT INTO bon_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalema lui kula ca atreji ge. Teeme yepä grana ne yaainusi Maamoi grana ca. Pui grana gome cupicu puga ge, lui awaclomteji ge faib caagecage toro mete ca. Heberu mene ca pui cupicu me ngii lui Beteseda. ");
INSERT INTO bon_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mete gawe me bucurage pita biname ge ätwitäneji: irecu määsumäsu biname, ernge niiyaniya biname, nuuja poto tääpe budre biname. Teepi jaawagrijusi niiye apineca padare ne, ");
INSERT INTO bon_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ingle nuuja taje Yageyame me mename seemo te täinuge niiye ne iibricname. Lui pita biname te niinäce läglenutuge niiye cabu me, niiye te liba lapinicuge, tabe miiji läbituge teeme pita cabu ca. ");
INSERT INTO bon_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yepä biname puga ge, lui te pita cama senajenäjumi teetieit kämäge ngalebora. ");
INSERT INTO bon_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yeesu teebine jepänige ätwitäneji puma, siige tabe umle ge, egä tabe lecaleca padare pita cama itu senajenäjumi. Tabe puma cita ca itemlige egä, “Nää, maane singi gäte miiji äbitame?” ");
INSERT INTO bon_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pita biname te jejige egä, “Babo biname, nuuja biname lica gyene cebine ätityerame cupicu cabu me acaname, niiye te liba tuudruge. Cane liga cäme ca otnime läbitune, nuuja te uja luupluge.” ");
INSERT INTO bon_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeesu jejige egä, “Arpinanti, määme waaku ne ecati, siige ädi!” ");
INSERT INTO bon_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tabe piba taatu miiji äbitige, teeme waaku ne ecatige, siige ädige. Yepä pui lui Sabade bimu ge. ");
INSERT INTO bon_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Israela biname cina jejisi, lui te miiji äbitige egä, “Ai lui Sabade bimu ge. Egäsu cotre gyene maane waaku ne acaname.” ");
INSERT INTO bon_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tabe jejemige egä, “Lui biname te miiji nawenige, tabe te najige cane waaku ne acatame siige otnime.” ");
INSERT INTO bon_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Teepi itemlisi egä, “Laasi nyene pui biname, lui te naajige maane waaku ne acatame siige otnime?” ");
INSERT INTO bon_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yepä lui te miiji äbitige, tabe umle lica ge, egä laati tage, ingle bucurage biname puga ge, piiyepu Yeesu puma cita ca nuuja gome me uja äyeblingtuji. ");
INSERT INTO bon_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ingwe ca Yeesu liba teebine jepänige iiwäreja mete caale bora je, tabe jejige egä, “Maane siige miiji gäte page. Ingwe ca niiya mule gone jaawenute, cije maane baborage niiya ne jääpänute.” ");
INSERT INTO bon_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Puma cita ca pui biname te ädige, Israela biname bine jejemige egä, “Pui lui Yeesu tage, lui te cebine miiji nawenige.” ");
INSERT INTO bon_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Siige puma cita ca Israela biname cina gije abacitinisi Yeesu ne sabe wawename, ingle tabe Sabade bimu cabu pita biname ne miiji jewenige. ");
INSERT INTO bon_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yepä Yeesu teebibine jejemige egä, “Cäme Babe te iyeta padare cabu kaakesea jewenenige, cane cuta piiyepu miiji kaakesea wawena.” ");
INSERT INTO bon_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yeesu me ai mene name pi Israela biname cina magerage singi äbitininisi teebine budre me aglime, ingle tabe Sabade cotre taatu ne lica jetropangtige, yepä tabe Acejiyame cama yepä me äbitige, teebine lipu Babe ca einige. ");
INSERT INTO bon_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeesu Israela biname bine jejemige egä, “Cane toraca jijenininine weebibine, egä Bägrä te nuuja gwidape teemerage singi ca lica jaawenuge, yepä tabe ngena ne jääpänuge Babe te wawena je, tabe cuta pui ne jaawenuge. Babe te ngena ne jaawenuge, cuta Bägrä te pui ne jaawenuge. ");
INSERT INTO bon_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Babe te singi gyene Bägrä tääpume, siige jaawabuge iyeta gwidape, tabe lui bine jaawenimuge. Weene jepäniye Bägrä te pita biname ne lipu miiji jewenige, yepä Babe te teebine cerämu poto modamoda kaakesea pagege awaba tabe wawenecame, weene lui cabu ca cälu te pa jitäjipi. ");
INSERT INTO bon_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Babe te lipu biname bine budre cabu ca cirege arpinera siige ireclota ceera teebibine, Bägrä te cuta piiyepu biname bine pagege ireclota ceera, tabe lui bime tääpume singi ceerame. ");
INSERT INTO bon_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Babe te nuuja biname ne lica atrana, yepä tabe Bägrä ne ituge conocäco ceera atrana tääpume ");
INSERT INTO bon_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","naace tääpume biname cina teebine cuta opo gaabe me acitame, Babe ne lipu opo gaabe me yaacitusi. Laati te Bägrä ne opo gaabe me lica yaacituge, cuta Babe ne piiyepu opo gaabe me lica yaacituge, lui te Bägrä ne tityepuji. ");
INSERT INTO bon_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cane toraca mene jijenininine, egä laati te cäme mene yäätecijuge, siige jäätrunguge teebine, lui te nätyepuji cebine, tabe iyeteta ireclota ne jääpänuge. Pui biname ne lica pagege atrana, ingle tabe uja ituge budre gaabe ne abmala, siige ireclota gaabe cabu ädenige. ");
INSERT INTO bon_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cane toraca jijenininine, egä padare te tädenige – siige uja biiri tatyaramtige – budre biname cina liba Acejiyame me Bägrä me tagepogogo ätecija. Laatibi yäätecijemuge, teepi ireclota ne pa jääpänepesi. ");
INSERT INTO bon_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Babe te Bägrä ne yepä kokre ituge ceera, teeme lui pisi nyene biname bine ireclota ceerame. ");
INSERT INTO bon_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cuta tabe Bägrä ne conocäco ituge ceera atrana tääpume, ingle tabe Acejiyame bau ca täduji biname me äbituji. ");
INSERT INTO bon_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cälu te gone jitinuge, egä padare te cire tädepi budre biname cina teeme tagepogogo ne ätecijame teeme gape bora ca, ");
INSERT INTO bon_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","siige cire täsipesi puma cita ca. Laatibi miijimiji mule ituge waweneca, teepi ngälu cäco ireclota cabu me cire tarpinärepi. Yepä laatibi niiyaniya mule bine ituge waweneca, teepi atrana tääpume cire tarpinärepi teeme mule ibi daremu ne päpäname.” ");
INSERT INTO bon_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Cane cäme singi ca äblicäco gäne nuuja mule ne wawena. Cane jaatranimune, Babe te lipu najuge. Cäme atrana lui conocäco gyene, ingle cane cäme singi ne lica jaawenune yepä teeme singi ne jaawenune, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cane liba cämämu laitnäjune, cäme aitneja lui toraca lica birige. ");
INSERT INTO bon_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yepä pisi nyene nuuja biname, lui te cebine naitnäjenige. Cane umle gäne, egä teeme aitneja cäme poto cidi me lui toraca gyene. ");
INSERT INTO bon_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yoo, weene biname bine täätyepemepeye Yoane niiye ca äciseja biname bau me teeme mene ätecijame. Lui toraca gyene, tabe peei ne jaaitnäjepi. ");
INSERT INTO bon_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Cane nuuja singi lica gäne biname me aitneja tääpume, yepä cane ai ne naace name pi jiicenine, egä weene pagege ireclota ne päpäname. ");
INSERT INTO bon_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoane lui epu pana ge lampa liiyepu, lui te layenuge, siige yaapaclyäruge. Weene singi ge teeme apaclyera cabu matikolä padare lenajame. ");
INSERT INTO bon_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tabe cebine naitnäjepi, yepä nuuja aitneja cuta pisi nyene, lui baborage gyene. Babe te lui kaakesea itu näcäruji cane wawename, siige cane lui kaakesea jewenenemine, pui cina naitnäjenisi cebine, egä Babe te cebine itu nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Cuta piiyepu Babe lui te cebine nätyepuji, tabe cuta naitnäjenige. Weene teeme tagepogogo lica ituge ätecija piiyepu teeme opo lica ituge päpäna. ");
INSERT INTO bon_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Teeme mene te weeme cabu lica yaanajuge, ingle weene lica jäätrunguye Babe te lui ne ituge ätyepa. ");
INSERT INTO bon_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Weene Oogäräneji mene cabu ca abiberäjininiye, siige apu jingenininige, egä weene iyeteta ireclota ne peema cita ca jääpänuye. Yepä weene ngene ca lica egleniye, egä cäme poto cidi me jiicenige. ");
INSERT INTO bon_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Weene äbwäricinininiye cäme bau me otnime ireclota ne päpäname. ");
INSERT INTO bon_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Cane nuuja singi lica gäne biname cina cebine awepyeräjame. ");
INSERT INTO bon_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yepä cane umle gäne weeme poto cidi me; cane umle gäne, weeme ngenecu bora nuuja singi lica gemi Acejiyame tääpume. ");
INSERT INTO bon_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cane itu tädepene cäme Babe me ngii cabu, yepä weene lica itu nawablepeye cebine. Nuuja te liba täduge teemerage ngii cabu, teebine weene jaawabluye. ");
INSERT INTO bon_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cuta weene lipulipu ätrungame, ingle weemeweme awepyeräja ne jäärnguye, yepä weene eei awepyeräja ne lica jäärnguye, yepä taatu Acejiyame bau ca lui te täduge. ");
INSERT INTO bon_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Weene gone apu jinginuge, egä cane te cirege weebibine Babe me opo gaabe je aitneja. Eewe, weeme aitneja biname lui Moose sine, weene lui cabu me weeme ngene atwanena singi bine ituge acrana. ");
INSERT INTO bon_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Weene liga toraca cire jäätrungejiye teebine, weene cuta cebine piba nätrungejiye, ingle tabe cäme poto cidi me ituge oogära. ");
INSERT INTO bon_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yepä ingle weene teeme oogäräneji mene ne lica jitrungeniye, peei name pi weene lipulipu ätrungame cäme mene ne.” ");
INSERT INTO bon_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ai ingwe gaabe ca Yeesu Galilaya sawa ne yuurige, Tiberiya sawa ca lui ne cuta einenisi. ");
INSERT INTO bon_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bucurage biname cina teebine ingwe icwisi, ingle teepi itu jääpänanepesi tabe teeme kokre ca pita biname bine miiji wawenena. ");
INSERT INTO bon_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yeesu podo cabu me teeme abiberäja bägrä cama jegelige, siige puga adnatige. ");
INSERT INTO bon_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pui padare Israela biname bime äsuplengta trii padare mameta ge. ");
INSERT INTO bon_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yeesu ire acitige, jepänige bucurage biname cina teeme bau me otni je. Tabe puma cita ca Pilipo ne jejige egä, “Mine ai biname bime ibibi deedei luma jeletnenemisi?” ");
INSERT INTO bon_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tabe ai lui naace tääpume jiicige Pilipo ne apicetnärame, yepä tabe umle ge, tabe ngena ne jewenenige. ");
INSERT INTO bon_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo Yeesu ne jejige egä, “Mine puu neeneni hanred silba rarekaake ca buluduu bine liba aletna je, poto cina erwäjinisi, poto cina abamutenisi.” ");
INSERT INTO bon_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Piba teeme nuuja abiberäja bägrä, Simona Peteru me igane Andrea te Yeesu ne jejige egä, ");
INSERT INTO bon_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ama pisi nyene yepä bägrä, lui me piti nemi faib buluduu piiyepu neeneni bumate cibu, yepä puu ibibi lica gemi iyeta ai biname bime tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pui cewe cabu puga ge babo baace. Yeesu teeme abiberäja bägrä bine jejemige egä, “Biname bine jejemeye adnateräjame baace papa cabu,” siige teepi adnateräjige. Teepi iyeta lui faib tausen rooriye ge. ");
INSERT INTO bon_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yeesu buluduu bine ewadimige, Acejiyame ne eso ecärige, siige biname bine ecäremige, lui cina adnatäreji icrajimige puma. Tabe cuta cibu ecäremige, siige teepi erwäjimisi, teepi luma ngälu singi ge. ");
INSERT INTO bon_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Teepi liba iyeta ngene jeglemige, Yeesu abiberäja bägrä bine jejemige egä, “Deedei, cibu pacupacu etomle-cmeye iyeta, nuuja ne gone yaabmaluye.” ");
INSERT INTO bon_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Teepi siige etomlecmisi, lui deedei pacupacu abmalininisi pui faib buluduu cabu ca, biname cina liba erwäjimisi, siige twelb diiba bine jengärimisi apaname. ");
INSERT INTO bon_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Biname cina liba jepänisi ai ciitaca mule ne, Yeesu lui jewenige, teepi jiicisi egä, “Toraca, ai lui Acejiyame me pui mename biname gyene, mine lui ne jewagrijenisi otnime.” ");
INSERT INTO bon_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeesu umle ge egä, “Teepi teeme singi ca cebine acitame naweninisi mope biname tääpume, yepä cäme singi lica ge.” Siige tabe cääri taatu ädige podo cabu me. ");
INSERT INTO bon_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Liba mämleteca me, abiberäja bägrä cina piba podo cabu ca täinitnige, sawa ligi me eclige, ");
INSERT INTO bon_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","poo cabu me acetnärige, siige sawa ne yuurisi Kaprenauma cewe me äcnärame. Teepi liba sawa cabu jage, ciiye te piba tumlige, yepä Yeesu cäro camu ge teeme bau me atyaramta. ");
INSERT INTO bon_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Buuwe te kokre cama tipwäjige, siige uule kuu cina modamoda me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Abiberäja bägrä cina liba poo ne biiri ewäcisi faib kilomiita pana padare me doro cabu ca, teepi puma cita ca jepänisi Yeesu ne niiye papa cabu otni je poo gome me, siige teepi mage wälu ge. ");
INSERT INTO bon_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yepä Yeesu teebibine jejemige egä, “Wälu gone, cane säne!” ");
INSERT INTO bon_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Piba teepi singi ge teebine acenutame, siige piba taatu poo te doro ne joomlige, teepi liiyeme singi ge otnime. ");
INSERT INTO bon_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nuuja bimu cabu lui biname cina sawa nuuja poto doro cabu itu tabmalimesi, teepi umle äbitininisi egä, “Yepä taatu poo lui te birice aga ge, abiberäja bägrä cina pui gaabe suurumesi sawa nuuja poto doro me, cuta Yeesu teta cama lica tädumi.” ");
INSERT INTO bon_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Piba poto poo cina seclige Tiberiya cewe cabu ca eeyeme, teepi luma deedei bine serwäjimumesi, Yageyame te lui deedei tääpume Acejiyame ne eso secärumi. ");
INSERT INTO bon_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lui cina puga ge piiyepu lui cina seclige, teepi liba umle äbitininisi egä, “Yeesu ama lica gyene, cuta abiberäja bägrä lica gemi,” teepi poo cabu me acetneräjininisi, Kaprenauma cewe me yuurisi Yeesu ne ärngime. ");
INSERT INTO bon_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lui biname cina Yeesu ne jirngisi, teepi teebine puma jepänisi sawa nuuja poto doro je, siige itemlisi egä, “Abiberäja biname, maane cuta liba tädite aima?” ");
INSERT INTO bon_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu jejemige egä, “Cane toraca jijenininine weebibine, egä weene cebine naace name pi lica närngeniye, ingle weene ciitaca mule bine itu tepänanemumeye cäme bau ca. Yepä weene naace popi närngeniye, ingle weene ibibi deedei bine serwäjimumeye. ");
INSERT INTO bon_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Weene gone watata deedei bine jäärngemuye, yepä eei deedei ne jirngepeye, lui te iyeteta ireclota biname bine yääcäranemuge. Lui te Acejiyame bau ca täduji biname me äbituji, tabe te pa icäripi weebibine pui deedei, ingle Aceji Babe te teebine ituge conocäco ceera peei ne wawename.” ");
INSERT INTO bon_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teepi Yeesu ne itemlisi egä, “Cine miiji ngena wawena, egä cine Acejiyame me kaakesea bine jaawenimusi?” ");
INSERT INTO bon_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu jejemige egä, “Peei lui Acejiyame me kaakesea gyene weeme cabu, egä weene cebine nätrungeniye, tabe lui ne nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Teepi jejisi egä, “Maane ngena ciitaca mule ne jewenenite cine päpäname siige cine piba meebine ätrungame? Maane ngena jewenenite? ");
INSERT INTO bon_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maane lipu gäte cibibine maana deedei ceerame, cime kaakesaare cina lui deedei bine serwäjenanemumesi daapo taatu cewe cabu je. Oogäräneji mene te jiicenige ai poto cidi me egä, ‘Acejiyame te cabucewe ca teebibine deedei secäranemuji.’” ");
INSERT INTO bon_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu jejemige egä, “Cane toraca jijenininine, egä Moose cabucewe ca weebibine deedei lica icäraninuji, yepä cäme Babe te toracarage deedei cabucewe ca sicäraninuge. ");
INSERT INTO bon_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Acejiyame me deedei lui tabe sine, cabucewe ca lui te täduji biname bine ireclota ceerame.” ");
INSERT INTO bon_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Teepi puma cita ca Yeesu ne jejisi egä, “Babo biname, maane pui deedei iyeta padare cabu nicäranipi.” ");
INSERT INTO bon_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeesu jejemige egä, “Cane säne pui ireclota deedei. Lui te cäme bau me täduge, tabe lica pagege loolomecewe jajwi. Cuta lui te cebine nätrunguge, tabe lica pagege niiyemecewe jajwi. ");
INSERT INTO bon_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yepä cane weebibine ituge jaji, egä weene itu näpänanumeye cebine, yepä weene ätrunga lica gemi. ");
INSERT INTO bon_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iyeta lui cäme Babe te näcäranuge, teepi cäme bau me saacluge, piiyepu laati te cäme bau me täduge, cane lica yääyecräjune. ");
INSERT INTO bon_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Cane cabucewe ca lica tädujine cäme singi ne wawename, yepä cane tädujine teeme singi ne wawename, lui te cebine nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Piiyepu lui te cebine nätyepuji, tabe singi gyene, egä cane nuuja ne lica apesera tabe lui cebine ituge ceera, yepä cane teebibine ireclota cabu me cire yaarpinäremepene ceräcerägääbu bimu cabu je. ");
INSERT INTO bon_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Cäme Babe te singi gyene, egä iyeta lui cina näpänusi cane teeme Bägrä ne piiyepu nätrungusi, teepi iyeteta ireclota ne cire jääpänepesi piiyepu cane teebibine cire yaarpinäremepene ceräcerägääbu bimu cabu je.” ");
INSERT INTO bon_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Israela biname cina gije abacitinisi Yeesu ne äingejame, ingle tabe lipu jiicige egä, “Cane säne deedei, lui te cabucewe ca tädujine.” ");
INSERT INTO bon_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Teepi jiicisi egä, “Cije ai lui Yeesu lica gyene, Yoosepa me bägrä. Cine umle gemi teeme mage babe. Cije tabe piba lipulipu jiicenige, egä tabe cabucewe ca itu täduji.” ");
INSERT INTO bon_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeesu teebibine jejemige egä, “Weene peei äingeja mene ne ebmaleye! ");
INSERT INTO bon_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nuuja te äblicäco cäme bau me otni, liba Babe lui te cebine nätyepuji, teebine lica taawenuge cäme bau me otnime, siige cane teebine ireclota cabu me cire yaarpinantepene ceräcerägääbu bimu cabu je. ");
INSERT INTO bon_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Acejiyame me mename biname cina itu yoogärujisi egä, ‘Acejiyame te iyeta biname bine pagege abiberäja.’ Iyeta lui cina Babe ne jäätecijusi, teeme bau ca labiberäjininusi, teepi cäme bau me saacluge. ");
INSERT INTO bon_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ai lui naace tääpume lica gyene, egä nuuja te ituge Babe ne päpäna, yepä tabe taatu lui te Babe bau ca täduji, tabe te teebine ituge päpäna. ");
INSERT INTO bon_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cane toraca jijenininine: laati te birige ätrunga, tabe ireclota ne jääpänuge. ");
INSERT INTO bon_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Cane lui ireclota deedei gäne. ");
INSERT INTO bon_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Weeme kaakesaare cina daapo taatu cewe cabu puu maana deedei ne serwäjenanemumesi, yepä teepi budre täbitenäjimesi. ");
INSERT INTO bon_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yepä laati te liba yaarwuge cabucewe ca lui deedei te täduge, tabe budre ne lica jääpänuge. ");
INSERT INTO bon_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Cane age säne pui ireclota deedei, cabucewe ca lui te tädujine. Laati te liba ai deedei yaarwuge, tabe iyeteta yaanajuge. Cane lui deedei ceera, cäme tääpe gyene, cane lui ne pagege äyemela biname cina iyeteta ireclota ne päpäname.” ");
INSERT INTO bon_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Puma cita ca Israela biname cina gije abacitinisi teemeteme atraname egä, “Tabe lipulipu mibibine teeme tääpe ceera mine arwime?” ");
INSERT INTO bon_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeesu jejemige egä, “Cane toraca jijenininine: weene liba cäme tääpe ne lica yaarwuye, Acejiyame bau ca lui te tädujine biname me äbitujine, piiyepu liba lica cäme uudi ne yaanuye, weeme cabu ireclota lica birige. ");
INSERT INTO bon_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yepä laati te cäme tääpe ne yaarwuge piiyepu cäme uudi ne yaanuge, tabe iyeteta ireclota ne jääpänuge, siige cane teebine ireclota cabu me cire yaarpinantepene ceräcerägääbu bimu cabu je. ");
INSERT INTO bon_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cäme tääpe lui toraca deedei gyene, cäme uudi lui toraca niiye gyene. ");
INSERT INTO bon_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Laati te cäme tääpe ne yaarwuge, cäme uudi ne yaanuge, tabe cäme cabu yaanajuge, cane teeme cabu nanajuge. ");
INSERT INTO bon_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ireclota Babe te cebine nätyepuji, siige cane teeme cabu ca ireclota ituge päpäna. Pipu pi laati te cäme tääpe ne yaarwuge, tabe cäme bau ca ireclota ne jääpänuge. ");
INSERT INTO bon_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ai pui deedei gyene, cabucewe ca lui ituge otni. Ai lui epu deedei lica gyene, weeme kaakesaare cina lui ne serwanenanumesi, yepä teepi äblicäco ge budre cabu ca uucratna. Yepä laati te ai deedei yaarwuge, tabe iyeteta yaanajuge.” ");
INSERT INTO bon_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeesu iyeta ai mene jiicemige Kaprenauma cewe je, tabe liba biname bine ebiberäjimige teeme abasecretna mete cabu. ");
INSERT INTO bon_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yeesu ne lui cina ingwe icwisi, teepi liba itecijemige ai mene, teeme bucurage cina jiicisi egä, “Ai abiberäja lui mage mäpurage gyene. Laati te miiji gyene ai ne acatame?” ");
INSERT INTO bon_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nuuja te Yeesu ne lica jejige, yepä tabe umle äbitige, teepi ngena poto cidi me jitranisi, siige tabe itemlimige egä, “Nää, cäme abiberäja te weebibine niiya opo me jiwenininige? ");
INSERT INTO bon_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cije piba lipu gyene, weene liba äpäna je Acejiyame bau ca lui te täduji biname me äbituji acnenuta cabucewe me, tabe luma niinäce ituge. ");
INSERT INTO bon_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Aceji Seemo te biname bine ireclota me jaawenimuge, teepi teeme ca äblicäco nuuja gwidape wawena. Cane lui mene bii jijananinine, Aceji Seemo piiyepu ireclota cama. ");
INSERT INTO bon_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yepä weene poto cina cebine lica nätrungeniye.” Yeesu ai mene naace name pi jiicige, ingle tabe ujarage umle äbituji, laati bemi lica teebine ätrunga piiyepu laati te teebine budre me pa jaawabepi. ");
INSERT INTO bon_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Puma cita ca tabe cääri jiicige egä, “Ai ingle name pi cane bii jijinine weebibine, egä nuuja te äblicäco gyene cäme bau me otni, Babe te liba lica teebine jaawenuge otnime.” ");
INSERT INTO bon_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yeesu me ai mene name pi bucurage teeme ingwe ca äcwi biname cina teebine ebmalisi, siige teta cama lica otninisi. ");
INSERT INTO bon_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Piba Yeesu teeme twelb abiberäja bägrä bine itemlimige egä, “Weene nää cuta singi gemi cebine abmalame?” ");
INSERT INTO bon_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Peteru te jewecnistige teeme mene egä, “Yageyame, cije cine ingwe ca laati bau me otni? Määme piti nemi mene iyeteta ireclota tääpume! ");
INSERT INTO bon_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cine siige näätrungenisi piiyepu umle gemi, egä maane peese näte, Acejiyame te lui ne mara me ituge wawena teeme tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yeesu teebibine jejemige egä, “Cane weene twelb bine puu iyeta itu jijäcripene, yepä weeme yepä cabu pisi nyene Satani.” ");
INSERT INTO bon_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yeesu Yuuda, Simona Isakariyota me bägrä tääpume jiicige. Ngänuge, tabe puu teeme twelb abiberäja bägrä cabu ca yepä ge, tabe te teebine budre me pa jaawabepi. ");
INSERT INTO bon_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ai ingwe gaabe ca Yeesu Galilaya probins cabu ta otnetnäjige. Tabe singi lica ge cääri cuta Yuudea probins me otnime, ingle Israela biname cina puma padare ne jirngisi teebine budre me acitame. ");
INSERT INTO bon_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Padare te mameta me äbitige Israela biname bime Wäbuyaga mete trii tääpume. ");
INSERT INTO bon_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Siige iganewale cina Yeesu ne jejisi egä, “Ai cewe ne ebmali, Yuudea me ädi, piba määme ingwe äcwiyame biname cina jepänenemisi maane lui mule bine jewenenemite, ");
INSERT INTO bon_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ingle laati te singi birige biname cina teeme poto cidi me umle äbitame, tabe nuuja mule ne ogä lica jaawenuge. Yoo, ingle maane apu mule bine jaawenanemute, maane miiji pajecu me äbita biname cina määme poto cidi me umle äbitame.” ");
INSERT INTO bon_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Teeme iganewale cina naace popi ai mene jiicisi, ingle cuta teepi teebine lica jitrungisi. ");
INSERT INTO bon_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yeesu jejemige egä, “Iyeta padare cabu weeme tääpume papa gyene otni, yepä cäme padare te camu gyene atyaramta. ");
INSERT INTO bon_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ai gawecewe biname bime nuuja ingle lica gyene weebibine ämugetname, yepä teepi cebine nämugetnusi, ingle cane jeitnäjenenemine, egä teeme mule lui niiyarage gemi. ");
INSERT INTO bon_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Äte naaclege weene ai trii tääpume. Cane lica ädenine, ingle cäme tääpume miiji padare lica gyene otnime.” ");
INSERT INTO bon_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tabe apu jiicige, siige Galilaya je enajige. ");
INSERT INTO bon_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yepä iganewale cina liba beclige trii tääpume, Yeesu teeme ingwe ca piba ogä ädige, ingle tabe singi lica ge biname cina umle äbitame teeme otni poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yerusalema je puma Israela biname cina teebine trii biname bime sobe cabu jirngisi. Teepi biname bine itemläjemisi egä, “Lese nyene pui biname?” ");
INSERT INTO bon_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Biname cina siiyä mene ca ajananinisi teeme poto cidi me. Poto cina jiicisi egä, “Tabe lui miiji biname gyene.” Poto cina jiicisi egä, “Eewe, tabe miiji biname lica gyene. Tabe biname bine yaangletnäjemuge.” ");
INSERT INTO bon_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yepä teepi cabucabu lica jiicemisi teeme poto cidi me, ingle teepi wälu ge Israela biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Trii padare lamlecu je Yeesu iiwäreja mete me abacitige biname bine abiberäjame. ");
INSERT INTO bon_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israela biname cina cälu te jitemige, jiicisi egä, “Tabe lipulipu baborage umle gyene. Tabe nuuja abiberäja cabu me lica ituge otni.” ");
INSERT INTO bon_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yeesu jejemige egä, “Cäme abiberäja lui cäme lica gyene, yepä Acejiyame myene, lui te cebine itu nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Laasi nyene liba singi Acejiyame me singi ne wawename, tabe umle pa läbitepi, egä cäme abiberäja lui Acejiyame te itu näcäruji coo cane nää cämerage mene jiicemenine. ");
INSERT INTO bon_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Laati te liba teemerage ngene atwanena mene jiicemuge, tabe teeme tääpume awepyeräja ne jäärnguge. Yepä laati te teeme tääpume awepyeräja ne jäärnguge, teebine lui te itu tityepuji, tabe lui conocäco gyene piiyepu teeme cabu nuuja walya lica gyene. ");
INSERT INTO bon_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Egäsu Moose nata weebibine Cotre icärininuji, yepä weeme nuuja te lica Cotre bine yääcwetnimuge. Weene ngena name pi cebine aglime naweniniye?” ");
INSERT INTO bon_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Biname cina teebine jejisi egä, “Eewe, cine meebine aglime lica naawenenisi. Määme niiya cable pisi nyene!” ");
INSERT INTO bon_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu jejemige egä, “Weene cälu te jitipi, cane lipu yepä gääbu Sabade bimu cabu kaakesea jaawenepene. ");
INSERT INTO bon_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moose te cotre icärininuji weene weeme tääpe matikolä iirputame Acejiyame me cewecu acata tääpume. (Puu toraca Moose te lica ge, yepä mime kaakesaare cina jegednu-jisi pui mule ne.) Siige weene pui cewecu bägrä ne jaawenuye tääpe iirputa ca, ngänu gyene liba Sabade bimu. ");
INSERT INTO bon_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yoo siige, weene liba bägrä me tääpe cabu cewecu jaawenuye Sabade bimu cabu naace tääpume Moose me cotre ne äcwetname, weene piba ngeno memi claabe, cane liba biname ne iyeta miiji jaawenepene Sabade bimu cabu. ");
INSERT INTO bon_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ätecitipeye papapapa atrana mule, miiji weene niinäce cängena ingle ne ärngi, piba atrana.” ");
INSERT INTO bon_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Poto Yerusalema biname cina jiicisi egä, “Cije ai lui pui biname lica gyene, teepi lui ne aglime jewenenisi? ");
INSERT INTO bon_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Weene jepäneye, tabe lipu pajecurage jiicemenige, yepä teepi nuuja mene lica ge! Ire taatu jetwisi! Pama modamoda biname cina umle bäbitininisi, egä toraca tabe Keriso sine biname bine niiya cabu ca äsecrerame? ");
INSERT INTO bon_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yepä tabe äblicäco gyene Keriso lenaja, ingle mine umle gemi, egä tabe luma cita ca gyene. Keriso te liba otni, nuuja biname te umle lica gyene, egä tabe luma cita ca gyene.” ");
INSERT INTO bon_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yeesu iiwäreja mete caale bora je biname bine ebiberäjimige. Tabe baborage tagepogogo ca jiicemige egä, “Yoo, weene umle gemi cane, piiyepu weene umle gemi cane luma cita ca gäne. Yepä cane cäme singi ca lica itu tädujine. Lui te cebine itu nätyepuji, tabe sine toraca, yepä weene umle lica gemi tabe. ");
INSERT INTO bon_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Cane umle gäne tabe, ingle cane teeme bau ca itu tädujine. Tabe te cebine nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Piba teepi singi ge teebine oomlaname, yepä nuuja te ime ne lica ecitige teeme papa cabu me, ingle teemerage padare te camu ge atyaramta. ");
INSERT INTO bon_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bucurage biname cina teebine jitrungisi, siige teemeteme ätemläjinisi egä, “Keriso liba cire tädepi, nää tabe pama cerämu apu poto ciitaca mule bine cire jaawenemepi ai biname te lipu jewenenemige?” ");
INSERT INTO bon_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisea sigu biname cina itecijemige, biname cina lipu siiyä mene ca jiicemisi Yeesu poto cidi me, siige teepi modamoda iiwäreja biname cama poto iiwäreja mete awamuta biname bine jityepimisi Yeesu ne oomlaname. ");
INSERT INTO bon_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yeesu biname bine jejemige egä, “Cane matikäli padare cerämu nanajinige weene cama, piba cane teeme bau me pa lacnenutepene, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Weene piba cebine pa närngepeye, yepä weene lica pa näpänepeye, ingle weene äblicäco gemi otni, cane lui puupu cabu me pa lädepene lenajame.” ");
INSERT INTO bon_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Puma cita ca Israela modamoda biname cina teemeteme jitranisi egä, “Tabe baa liiyeme otnime äbitinige, siige piba mine äblicäco teebine päpäna? Nää, tabe pama ngene jotwanenige Griik gawe cabu me otnime, Israela biname cina luma icrajinige, siige puma Griik biname bine abiberäjame? ");
INSERT INTO bon_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngena tääpume tabe apu jiicige egä, ‘Weene cebine pa närngepeye, lica pa näpänepeye,’ cuta egä ‘Cane liiyeme pa lädepene lenajame, weene äblicäco piiyeme otni.’ Tabe ngena tääpume pepu jiicige?” ");
INSERT INTO bon_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Trii padare me ngälugaabe bimu lui baborage gyene. Yeesu piba abujängtige, baborage tagepogogo ca jiicige egä, “Laati te liba niiyemecewe, tabe miiji cäme bau me otni niiye nanime! ");
INSERT INTO bon_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mene oogäräneji gyene, egä laati te cebine nätrunguge, ireclota niiye te teeme ngenecu cabu ca tuudruge.” ");
INSERT INTO bon_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeesu ai mene Aceji Seemo poto cidi me jiicige. Laatibi Yeesu ne jäätrungusi, teepi pagege Aceji Seemo ne päpäna. Pui padare cabu teebine cäro camu ge ätyepa, ingle Yeesu camu ge acnenuta cabucewe me teeme apaclyera cabu me. ");
INSERT INTO bon_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Laatibi Yeesu me ai mene itecijemige, teeme poto cina jiicisi egä, “Toraca, ai biname lui pui mename biname gyene, mine lui ne jewagrijenisi.” ");
INSERT INTO bon_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Poto bime ngene atwanena apu ge egä Yeesu lui Keriso sine, Acejiyame te lui ne cirege ätyepa biname bine niiya cabu ca äsecrerame. Yepä poto cina jiicemisi egä, “Keriso äblicäco Galilaya probins cabu ca otni, ");
INSERT INTO bon_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ingle Oogäräneji mene te jiicenige egä tabe Daawida me kaakesaare gyene, siige tabe Daawida me cewe Betelehema cabu ca cire tädepi.” ");
INSERT INTO bon_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Puma cita ca biname cina abelaninisi Yeesu miji pi. ");
INSERT INTO bon_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Poto cina singi ge teebine oomlaname, yepä nuuja te ime ne lica ecitige teeme papa cabu. ");
INSERT INTO bon_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Iiwäreja mete ne lui cina jaawamutusi, modamoda iiwäreja biname piiyepu Parisea sigu biname cina lui bine jityepimisi Yeesu ne oomlana tääpume, siige teepi ime taatu äcnärige. Lui cina teebibine jityepimisi, teepi itemlimisi egä, “Weene ngena name pi teebine lica secaniye aima?” ");
INSERT INTO bon_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Awamuta biname cina jejemisi egä, “Cine nuuja biname ne niinäce lica ituge ätecija apu mene iicema cabu je.” ");
INSERT INTO bon_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Piba Parisea sigu biname cina jejemisi egä, “Oo siige, tabe cuta weebibine bingletnäjinige? ");
INSERT INTO bon_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Weene nää ituge ätecija, egä Parisea biname bime yepä te coo modamoda biname bime yepä te teebine jitrungenige? ");
INSERT INTO bon_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yepä ai papa biname, lui bime cabu Acejiyame me claabe pisi nyene, ingle teepi umle lica gemi Moose me Cotre, teepi te jitrungenisi teebine.” ");
INSERT INTO bon_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo, lui pui Parisea biname bime cabu ca yepä ge piiyepu lui te Yeesu ne niinäce yäädärepi ciiye cabu je, tabe jejemige egä, ");
INSERT INTO bon_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mime Cotre te nijenininige, egä mine äblicäco biname ne papa atrana. Mine miiji niinäce teebine ätecija piiyepu umle äbita, egä tabe ngena ne ituge wawena.” ");
INSERT INTO bon_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Puma cita ca teepi jejisi egä, “Cuta maane peese näte nuuja Galilaya biname! Maane Oogäräneji mene miiji abiberäjepi umle äbitame, egä Acejiyame me nuuja mename biname te Galilaya probins cabu ca lica cire tädepi.” ");
INSERT INTO bon_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Siige puma cita ca teepi iyeta mete me etengläjisi. ");
INSERT INTO bon_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeesu Olibi Uli podo cabu me ädige. ");
INSERT INTO bon_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nuuja bimu krokerage tabe cuta cääri acnenutige iiwäreja mete cabu me. Biname cina abasecretnige teeme bau me, siige tabe adnatige, gije abacitige teebibine abiberäjame. ");
INSERT INTO bon_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Puma cita ca cotre abiberäja biname piiyepu Parisea sigu biname cina yepä magebi ne tocanisi, lui ne jwoomlisi sargi mule wawena cabu, biname sobe cabu ocitisi, ");
INSERT INTO bon_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","siige Yeesu ne jejisi egä, “Abiberäja biname, cine ai magebi ne sargi mule wawena cabu twoomlisi. ");
INSERT INTO bon_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moose me Cotre te apu nijinininige, egä apu muleyame biname bine miiji kula ca äbyecra budre me aglime. Maane lipu ngene jotwanenite ai poto cidi me?” ");
INSERT INTO bon_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Teepi ai mene naace name pi jejisi, ingle teepi singi ge teebine mene cabu oomlaname, siige ingle ne päpäname teebine aitnejame. Yeesu äcupige, ime kukluta ca mene yoogärige gawe cabu. ");
INSERT INTO bon_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Teepi liga teebine tii jewenanisi, tabe jeclajutige, jejemige egä, “Weeme cabu liba biname pisi nyene, lui te umle cäco niiya mule wawena, tabe te niinäce kula ne yaajarege teeme cabu me.” ");
INSERT INTO bon_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tabe cuta cääri äcupige, gawe cabu ngii yoogärige. ");
INSERT INTO bon_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Teepi liba Yeesu me mene itecijemige, teepi ngene ca eglisi egä cime niiya mule piti nemi. Siige teepi gije abacitinisi yepäyepä atenglejame, modamoda biname cabu ca ngälu matimati biname, ngälu Yeesu taatu te ityepurige pui magebi cama, teeme opo gaabe je lui te joclajutige. ");
INSERT INTO bon_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Piba Yeesu jeclajutige, utemlige egä, “Magebi, lete nemi teepi, lui cina meebine naacanisi aima kula ca äbyecrame? Cije teepi lica jewenisi peei mule ne?” ");
INSERT INTO bon_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tabe jejige egä, “Eewe babo biname.” Puma cita ca Yeesu jojige egä, “Cane cuta meebine kula ca lica naacnenine. Äte ocli, ingwe ca niiya mule gone jaawenute!” ");
INSERT INTO bon_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeesu liba biname bine cääri ebiberäjimige, tabe jejemige apu egä, “Cane age säne apaclyera ai gawecewe tääpume. Laati te cebine ingwe näcwuge, tabe krokeciiye cabu lica waatnuge, ingle tabe apaclyera ne jääpänuge teeme ireclota tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Puma cita ca Parisea sigu biname cina Yeesu ne jejisi egä, “Maane määmämu aitnäjenite, pipu pi määme aitneja lui toraca lica gyene.” ");
INSERT INTO bon_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu jejemige egä, “Cane puu cämämu aitnäjenine, yepä cäme aitneja lui papa me lica äbitenige, ingle cane umle gäne, cane luma cita ca gäne piiyepu liiyeme ädenine. Yepä weene nuuja umle lica gemi, cane luma cita ca gäne piiyepu liiyeme ädenine. ");
INSERT INTO bon_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Weeme atrana lui biname bime pana gyene. Cane nuuja biname ne licarage pa jaatranepene. ");
INSERT INTO bon_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yepä cane liba atrana je, cäme atrana lui conocäcorage ge, ingle cane taatu lica gäne. Babe lui te cebine nätyepuji, tabe cane cama gyene. ");
INSERT INTO bon_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nata weeme Cotre mene te cuta jiicenige, egä neeneni biname bime aitneja lui ibibi birige. ");
INSERT INTO bon_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yoo siige, cane cämämu aitnäjenine piiyepu Babe, lui te cebine nätyepuji, tabe cuta naitnäjenige cebine.” ");
INSERT INTO bon_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Puma cita ca teepi Yeesu ne itemlisi egä, “Baa, lese nyene määme babe?” Yeesu jejemige egä, “Weene umle lica gemi cane piiyepu cäme Babe. Weene liga umle cirege cane, weene cuta piba umle cirege tabe.” ");
INSERT INTO bon_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeesu ai mene jiicemige, tabe liba biname bine ebiberäjimige iiwäreja mete caale bora je rarekaake acrana puupu gome. Siige nuuja te teebine lica joomlige, ingle teeme padare te camu ge atyaramta. ");
INSERT INTO bon_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu biname bine cääri mene jejanemige. Tabe apu jiicige egä, “Cane ama cita ca äyeblingtenine. Weene pa närngepeye cebine, yepä weene weeme niiya mule cabu budre cire äbitipeye. Weene äblicäco gemi otni, cane liiyeme ädenine.” ");
INSERT INTO bon_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Puma cita ca Israela biname cina jiicisi egä, “Nää, tabe pama teemämu aglime pa läbitepi, ingle tabe jiicige egä, ‘Weene äblicäco gemi otni, cane liiyeme pa lädepene?’” ");
INSERT INTO bon_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu jejemige egä, “Weene lui gawecewe cabu ca gemi, yepä cane lui cabucewe cabu ca gäne. Weene ai gawecewe tääpu memi, yepä cane lica gäne ai gawecewe tääpume. ");
INSERT INTO bon_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cane jijinine, egä weene budre läbitininuye weeme niiya mule cabu. Weene liba ätrunga lica birige, egä cane pui biname gäne, cane lui poto cidi me jiicenenemine, weene toraca budre cire äbitipeye.” ");
INSERT INTO bon_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Teepi puma cita ca teebine itemlisi, “Baa, maane laasi näte?” Yeesu jejemige egä, “Cane uja weebibine lipu ituge jaji? ");
INSERT INTO bon_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cäme bucurage mene piti nemi weeme poto cidi me iicemame piiyepu weebibine ablawejame. Yepä cane peei taatu mene jaajananemune biname bine, cane lui mene nätecijanuge teeme bau ca, cebine lui te nätyepuji. Tabe lui toraca gyene.” ");
INSERT INTO bon_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Teepi opo lica ewatnisi, egä Yeesu Babe poto cidi me jiicige. ");
INSERT INTO bon_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Puma cita ca Yeesu teebibine cuta cääri jejemige egä, “Weene liba pa nawepäntepeye cebine, Acejiyame bau ca lui te tädujine biname me äbitujine, piba weene umle pa äbitipeye, egä cane pui biname gäne, cane lui poto cidi me jiicemimune. Cane nuuja gwidape ne cäme singi ca lica jaawenune, yepä Babe te ngena ituge abiberäja cebine, cane peei poto cidi me taatu jiicemimune. ");
INSERT INTO bon_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lui te cebine nätyepuji, tabe pisi nyene cane cama. Tabe cebine taatu lica ituge abmala, ingle cane ngena bine jaawenetnäjimune, peei cina teebine ngenecu miiji me jaawenusi.” ");
INSERT INTO bon_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bucurage biname cina Yeesu ne jitrungisi, teepi liba itecijemige tabe apu iicema je. ");
INSERT INTO bon_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lui Israela biname cina Yeesu ne jitrungisi, tabe teebibine jejemige egä, “Weene liba cäme abiberäja ne kokre cama joomle-niye, weene cäme toracarage abiberäja bägrä gemi piba. ");
INSERT INTO bon_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Piba weene umle läbitininuye, toraca ngena gyene, siige pui toraca te weebibine kälyä jiwenininuge.” ");
INSERT INTO bon_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Teepi opo lica jewatnisi, Yeesu ngena tääpume jejemige, siige teepi jejisi egä, “Cine lui Abrahamo me kaakesaare gemi. Cine nuuja biname me aletnäneji biname lica gemi, cije maane ngena name pi nijinite cine kälyä äbitame?” ");
INSERT INTO bon_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu jejemige egä, “Cäme mene nacateye: iyeta lui cina niiya mule bine yaacnemusi, pui niiya mule cina teebibine kokre joomle-musi epu pana, aletnäneji biname ne teeme yageyame te lipu kokre joomluge. ");
INSERT INTO bon_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aletnäneji biname te iyeteta lica yaanajuge teeme babo biname me mete cabu. Yepä bägrä te iyeteta teeme babe me mete cabu yaanajuge. ");
INSERT INTO bon_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Siige Bägrä te liba weebibine kälyä jiwenininuge niiya mule cabu ca, weene piba toraca kälyä birige. ");
INSERT INTO bon_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yoo, cane umle gäne, egä weene Abrahamo me kaakesaare gemi. Yepä weene cebine aglime naweniniye, ingle weene singi lica gemi cäme mene ätecijame. ");
INSERT INTO bon_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cane jijananinune, cane ngena ituge päpäna Babe me gome. Weene cuta piiyepu jaawenimuye, weeme babe te ngeno me jijananinuge weebibine.” ");
INSERT INTO bon_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Teepi jejisi egä, “Cime babe Abrahamo sine.” Yeesu jejemige egä, “Weene liga Abrahamo me bägrä cirege, weene epu mule bine cire jaawenemejiye tabe liiyepu. ");
INSERT INTO bon_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yepä weene siige cebine aglime naweniniye, ingle cane toraca mene poto cidi me ituge jajanena, Babe bau ca cane lui mene ituge ätecijana. Abrahamo weeme pana lica äbituji. ");
INSERT INTO bon_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Weene weemerage babe ne jitutaneniye.” Teepi puma cita ca Yeesu ne jejisi egä, “Cine babe cäco biname lica gemi. Cime yepä taatu Babe pisi nyene. Tabe lui Acejiyame sine.” ");
INSERT INTO bon_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu jejemige egä, “Liga Acejiyame weeme Babe cirege, weene piba cäme tääpume singi cirege, ingle cane teeme bau ca tädujine, siige cane page age säne. Cane cäme singi ca lica tädujine, yepä tabe te cebine nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Weene ngena name pi cäme mene umle lica gemi? Weene naace name pi umle lica gemi cäme mene, ingle weeme tablame bermemiye cäme mene ätecija wälu name pi. ");
INSERT INTO bon_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satani peese nyene weeme babe, siige weene weeme babe me singi bine jaawenemuye. Tabe lui agliyame gyene agedna cabu ca ngälu page. Tabe toraca mene ne jigyenige, ingle teeme bau ca cude padare gyene. Tabe liba walya waatromuge, tabe teemerage mule ne jaawenuge; tabe walya biname gyene, babe gyene iyeta walya tääpume. ");
INSERT INTO bon_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Cebine weene pui name pi lica nätrunguye, ingle cane jiicemimune, ngena gyene toraca. ");
INSERT INTO bon_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Baa, weeme nuuja te jaawabudnitege, egä cane ngena niiya ne ituge wawena. Cane liba toraca mene poto cidi me jiicemune, weene piba ngena name pi lica cebine nätrunguye. ");
INSERT INTO bon_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Laati te Acejiyame bau ca gyene, tabe te teeme mene jäätecijuge. Yepä weene Acejiyame me bägräwale lica gemi, peei name pi weene lica teebine jäätecijuye.” ");
INSERT INTO bon_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israela biname cina Yeesu ne jejisi egä, “Cime mene pama toraca gyene, egä maane Samariya biname gäte, cuta määme niiya cable pama pisi nyene?” ");
INSERT INTO bon_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeesu teebibine icisäremige egä, “Eewe, cane niiya cable cama lica gäne. Cane cäme Babe ne opo gaabe me ecitenine, yepä weene cebine opo gaabe me lica naciteniye. ");
INSERT INTO bon_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cane singi lica gäne cäme ngii te babo äbitame. Nuuja te pisi nyene, lui te singi ge cäme ngii te babo äbitame. Tabe te biname bine cirege atrana. ");
INSERT INTO bon_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cane toraca jijenininine weebibine, egä laati te cebine nätrunguge, tabe budre lica läbituge.” ");
INSERT INTO bon_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Puma cita ca Israela biname cina jejisi egä, “Siige cine aga toraca umle bäbitininago, egä määme niiya cable pisi nyene. Abrahamo uja budre äbituji, piiyepu Acejiyame me mename biname cina uja budre äbitininujisi, siige maane piba cije lipu jiicenite, egä laati te liba määme mene yäätecijuge, tabe budre lica läbituge. ");
INSERT INTO bon_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nata maane baborage lica gäte mime kaakesaare Abrahamo bau ca, lui te budre itu läbitepi. Piiyepu mename biname cina budre ituge äbita. Maane lipu ngene jotwaninite, egä maane baa laasi näte?” ");
INSERT INTO bon_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu teebibine jejemige, “Cane liba cämämu babo läbitune, peei lui toraca lica ge. Yepä Babe te cäme ngii ne babo jaawenuge, weene lui ne weeme Acejiyame ca eineniye. ");
INSERT INTO bon_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Weene lica ituge umle äbita teeme poto cidi me, yepä cane umle gäne tabe. Cane liba iicana je, egä cane umle lica gäne tabe, cane piba weeme pana walya biname gäne. Yepä cane umle gäne tabe piiyepu teeme mene jäätecijune. ");
INSERT INTO bon_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Weeme kaakesaare Abrahamo gege ge, ingle tabe umle ge, egä tabe cebine cirege päpäna. Tabe näpänuji, siige mage gege äbituji.” ");
INSERT INTO bon_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Israela biname cina jejisi egä, “Maane camu gäte fifti kämäge oomlana, maane piba cije lipu pi jiicenite, egä maane Abrahamo ne ituge päpäna?” ");
INSERT INTO bon_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu jejemige egä, “Cane toraca jijenininine weebibine, egä cane uja ge, Abrahamo ingwe ca aplimluji.” ");
INSERT INTO bon_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Puma cita ca Israela biname cina kula bine ewadimisi teebine äbyecrame, yepä Yeesu ämlitige, siige iiwäreja mete ne sebmalige. ");
INSERT INTO bon_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yeesu otni cabu irecu määsumäsu biname ne jepänige, lui te pepu ärngeji ge. ");
INSERT INTO bon_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abiberäja bägrä cina Yeesu ne itemlisi egä, “Abiberäja biname, laati me niiya mule name pi tabe apu gyene, teeme coo teeme mage babe bime?” ");
INSERT INTO bon_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tabe jejemige egä, “Tabe irecu määsumäsu ärngeji lica gyene teeme niiya mule ingle name pi coo teeme mage babe bime niiya mule name pi. Tabe naace name pi irecu määsumäsu gyene egä Acejiyame me kokre ne teeme cabu ca päpäname. ");
INSERT INTO bon_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bimu apaclyera te liba enajenige, mine miiji teeme kaakesea wawena, cebine lui te nätyepuji. Ciiye te tädenige, piba nuuja te äblicäco kaakesea wawena. ");
INSERT INTO bon_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cane liba gawecewe cabu säne, cane apaclyera gäne gawecewe tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ai mene ingwe gaabe ca Yeesu mote ne eclemutige gawe cabu me, gawe cama elengläcitige, siige pui ngate ne ecatige, teeme irecu bine aaganige. ");
INSERT INTO bon_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Piba tabe jejige egä, “Äte ädi, opo äcisäji Siloama cupicu cabu.” (Siloama me aboclomta lui ‘Ätyepäneji’.) Tabe ädige, opo äcisäjige, siige irecu aasatäneji tacnige. ");
INSERT INTO bon_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Puma cita ca lui biname cina teeme gome icrajige, cuta lui cina teebine niinäce ituge päpänena ätinera je, teepi ätemläjinisi egä, “Nää, age sena pui biname, mine lui ne ätinera je jääpänanusi?” ");
INSERT INTO bon_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Poto cina jiicisi egä, “Yoo, tabe sine,” poto cina egä, “Eewe, tabe lica gyene, yepä teeme opo pui biname me pana gyene.” Yepä tabe pui biname te teemämu jiicige egä, “Cane age säne pui biname.” ");
INSERT INTO bon_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Teepi itemlisi egä, “Määme irecu cina lipulipu baasatäsi?” ");
INSERT INTO bon_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tabe jejemige egä, “Biname ngii Yeesu, tabe te mote ne elengläcitige gawe cama, siige pui ngate ca naganige cäme irecu, nätyepige Siloama cupicu cabu cane opo äcisejame. Cane liba ädine, siige jicisäjine, piba cäme irecu cina aasatäsi.” ");
INSERT INTO bon_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Teepi teebine itemlisi egä, “Lese nyene tabe?” Tabe jejemige egä, “Cane umle lica gäne.” ");
INSERT INTO bon_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lui irecu määsumäsu biname te miiji bäbitige, teebine ecanisi Parisea sigu biname bime cabu me. ");
INSERT INTO bon_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lui bimu cabu Yeesu gawe ne mote cama elengläcitige, siige teeme irecu bine miiji jaawenige, pui lui Sabade bimu ge. ");
INSERT INTO bon_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Puma cita ca Parisea sigu biname cina teebine itemlisi egä, “Määme irecu lipulipu miiji bäbitäsi?” Tabe jejemige egä, “Pui biname, tabe gawe ne teeme mote cama elengläcitige, pui ngate ca cäme irecu naganige. Cane opo äcisäjine, siige page cane gwidape bine jepänenemine.” ");
INSERT INTO bon_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Piba poto Parisea sigu biname cina apu jiicisi egä, “Lui biname te pepu mule ne jewenige, tabe äblicäco ge Acejiyame bau ca otni, ingle Sabade cotre ne jetropangtige.” Yepä poto cina jiicisi egä, “Lipu miiji gyene conocono biname te apu ciitaca mule bine waweneca?” Siige teepi yepä ngene atwana lica ge Yeesu poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Parisea sigu biname cina cuta cääri itemlisi pui biname ne egä, “Maane lipu ngene jotwaninite pui biname poto cidi me, meebine lui te miiji naawenige?” Tabe jejemige egä, “Cane apu ngene jotwaninine, egä tabe lui Acejiyame me mename biname gyene.” ");
INSERT INTO bon_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yepä Israela biname cina ätrunga lica ge, egä tabe irecu määsumäsu ärngeji ge, siige page jepänenemige, peei name pi teepi teeme mage babe bine ala taasoglicisi, ");
INSERT INTO bon_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","äätemlisi egä, “Nää, ai lui weeme bägrä gyene? Lipu, tabe irecu määsumäsu ärngeji ge? Tabe page siige lipulipu jepänenemige?” ");
INSERT INTO bon_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mage babe cina jejemäsi egä, “Yoo, cine umle gegi egä tabe cime bägrä gyene, cuta irecu määsumäsu ärngeji ge, ");
INSERT INTO bon_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","yepä cine nuuja umle lica gegi, tabe lipulipu irecu bii baasatige coo laati te miiji bii jewenige teebine. Weene teebine itemleye. Tabe baborage gyene weebibine daremu mene jajime.” ");
INSERT INTO bon_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Teepi naace popi apu jiicäsi, ingle teepi wälu ge Israela modamoda biname bime tääpume. Israela biname cina apu ituge iicana, egä laati te jaawabudnituge Yeesu ne, egä tabe Keriso sine, Acejiyame lui ne cirege ätyepa biname bine niiya cabu ca äsecrerame, piba pui biname ne yääyeblingtusi teeme irecu ätumuta cabu ca. ");
INSERT INTO bon_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Peei name pi teeme mage babe cina jiicäsi egä, “Tabe baborage gyene. Teebine itemleye.” ");
INSERT INTO bon_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Puma cita ca Parisea sigu biname cina cuta cääri ala tesoglicisi irecu määsumäsu ärngeji biname ne, jejisi egä, “Cine umle gemi, egä lui biname te meebine miiji naawenige, tabe conocono biname gyene. Maane lipu ngene jotwaninite teeme poto cidi me? Maane ngene gone näätrimaluge, egä Acejiyame te näätecijenige, peei name pi maane toraca mene nijini.” ");
INSERT INTO bon_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tabe jejemige egä, “Cane umle lica gäne, egä tabe conocono biname gyene coo liiyepu, yepä cane umle gäne, cane irecu määsumäsu ge niinäce, siige page jepänenemine.” ");
INSERT INTO bon_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Puma cita ca Parisea sigu biname cina itemlisi egä, “Tabe ngena jewenige määme irecu cabu? Tabe lipulipu meebine irecu miiji naawenige?” ");
INSERT INTO bon_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tabe jejemige egä, “Cane uja bii jijinine, yepä weene lica bitecijinige. Weene ngena tääpume singi gemi peei yepä gwidape tääpume cääri ätecijaname? Pama weene singi gemi cuta teeme abiberäja bägrä me äbitame!” ");
INSERT INTO bon_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Parisea biname cina teebine jisädisi, jejisi egä, “Maane peese näte teeme abiberäja bägrä. Cine Moose me abiberäja bägrä gemi. ");
INSERT INTO bon_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Cine umle gemi, egä Acejiyamerage te Moose ne jejanuji, yepä cine peei biname poto cidi me umle lica gemi, egä tabe luma cita ca gyene.” ");
INSERT INTO bon_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pui biname te jejemige, “Tabe cäme irecu bii napatnige, yepä weene umle lica gemi, tabe laasi nyene. Cane cälu te nätige wemiji pi. ");
INSERT INTO bon_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mine umle gemi, egä Acejiyame te conocono biname ne lica jäätecijuge, yepä tabe eei biname ne jäätecijuge, lui te teebine opo gaabe me yaacitanuge piiyepu teeme singi ibibi jaawenimuge. ");
INSERT INTO bon_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Agedna cabu ca ngälu page nuuja biname te lica ituge ätecija, egä biname te irecu määsumäsu ärngeji biname me irecu bine jaapatnige. ");
INSERT INTO bon_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Acejiyame te peei biname ne liga lica cire täätyepeji, tabe ibibi lica gyene apu mule bine wawenecame.” ");
INSERT INTO bon_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Parisea biname cina jejisi teebine egä, “Maane niiyarage biname gäte määme aplimla cabu ca ngälu page. Maane ngena miiji gäte cibibine abiberäjame!” Siige teepi teebine teeme abasecretna mete cabu ca ijarisi. ");
INSERT INTO bon_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yeesu itecijige, egä tabe lui biname ne miiji jewenige, teebine sijarisi abasecretna mete cabu ca. Tabe liba teebine jepänige, tabe jejige egä, “Maane nää jitrungenite Acejiyame bau ca lui te täduji biname me äbituji?” ");
INSERT INTO bon_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tabe pui biname te Yeesu ne jejige egä, “Babo biname, naji cebine, tabe laasi nyene, cane teebine piba jitrungenine?” ");
INSERT INTO bon_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu jejige egä, “Maane uja biiri jepänite teebine. Tabe page maane cama mene jiicemenige.” ");
INSERT INTO bon_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tabe Yeesu ne jejige egä, “Yageyame, cane näätrungenine meebine.” Piba tabe kokorare ca ääpednutige teeme opo gaabe je. ");
INSERT INTO bon_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yeesu puma cita ca jiicige egä, “Cane naace tääpume ai gawecewe cabu me itu tädujine biname bine atraname siige piba irecu määsumäsu cina päpänename, cuta lui cina jääpänanemusi teepi irecu määsumäsu me äbitame.” ");
INSERT INTO bon_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Poto Parisea sigu biname lui cina teta cama puga ge, itecijemige Yeesu ai mene iicema je, siige teepi teebine itemlisi egä, “Nää, maane apu naangeninige, egä cine cuta irecu määsumäsu gemi?” ");
INSERT INTO bon_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu jejemige egä, “Weene liba toraca irecu määsumäsu lenaja je, piba nuuja te äblicäco weebibine niiya mule poto cidi me aitneja; yepä weene jiicenenemiye, egä weene cängena jepänenemiye, siige weebibine cirege atrana, ingle weeme niiya mule piti nemi.” ");
INSERT INTO bon_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeesu jiicemige egä, “Cane toraca jijenininine weebibine, egä lui biname te maamoi caale bora me lica labacituge grana cabu, yepä tabe jaageluge caale nuuja poto ca, tabe lui eromaame birige piiyepu cuta agliyame birige. ");
INSERT INTO bon_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yepä lui biname te labacituge caale granarage cabu, tabe peese nyene maamoi ire atwi biname. ");
INSERT INTO bon_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Teeme tääpume grana ire atwi biname te grana ne jiitnuge, piiyepu maamoi cina umle gemi teeme tagepogogo, siige tabe teemerage maamoi bine ngiirage ca jääjäcrimuge, caale cabu ca yääsemuge. ");
INSERT INTO bon_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tabe liba teebibine yääsemuge, tabe niinäce gaabe me läduge. Maamoi cina teebine ingwe yääcwusi, ingle teepi umle birige teeme tagepogogo. ");
INSERT INTO bon_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Teepi idne biname ne ingwe lica yääcwusi. Teepi teeme bau ca luucratnuge, ingle teepi umle lica birige teeme tagepogogo.” ");
INSERT INTO bon_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu teebibine ai ngene ca agli mene jejemige, yepä teepi opo lica ewatnisi, egä ngena tääpu myene. ");
INSERT INTO bon_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeesu cääri jiicemige egä, “Cane toraca jijenininine weebibine, egä cane age säne grana maamoi bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iyeta lui cina cäme niinäce gaabe ca itu saaclepi, teepi lui eromaame gemi piiyepu aglecayame gemi, yepä maamoi cina teebibine lica jäätecijemusi. ");
INSERT INTO bon_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Cane age säne grana. Laati te cäme cabu ca tabacituge, tabe ireclota ne jääpänuge. Tabe tabacituge caale ngalebora me, cuta lasatuge, siige tabe jääpänimuge baace loolo me. ");
INSERT INTO bon_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Eromaame te yepä täduge acatame, sabe wawename piiyepu budre me aglime. Yepä cane te tädujine naace tääpume egä maamoi cina toraca miijirage ireclota ne päpäname. ");
INSERT INTO bon_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Cane age säne miijirage maamoi ire atwi biname, lui te teeme ireclota ne yääyemaluge maamoi name pi. ");
INSERT INTO bon_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Liba daremu cama biname te maamoi bine ire jaatwemuge, lui te toraca ire atwi biname lica birige piiyepu lui me maamoi lica birige, tabe liba jääpänuge wulp ne otni je, tabe maamoi bine yaabmalimuge, luucruge. Puma cita ca wulp te maamoi bine jäängecreräjimuge, maamoi cina maramara yaaplidnärusi. ");
INSERT INTO bon_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Daremu cama lui ire atwi biname te luucruge, ingle teeme toracarage ngenecu lica gyene maamoi bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Cane säne miijirage maamoi ire atwi biname. Cane umle gäne cäme maamoi, teepi umle gemi cane, ");
INSERT INTO bon_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","epu pana Babe te lipu umle gyene cane, cane lipu umle gäne tabe. Cane cäme ireclota ne pa yääyemalepene maamoi name pi. ");
INSERT INTO bon_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cäme piti nemi poto maamoi ai caale cabu lui lica gemi. Cane cuta miiji teebibine awecetnära, siige teepi cäme tagepogogo cire nätecijepesi. Siige yepä maamoi tomi cirege, cuta teeme tääpume yepä ire atwi biname cirege. ");
INSERT INTO bon_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Babe te singi gyene cäme tääpume, ingle cane singi gäne cäme ireclota ne äyemelame naace tääpume cuta cääri päpäname. ");
INSERT INTO bon_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nuuja biname te lica pagege cebine teeme singi ca agli, yepä cane cämämu pagege cäme ireclota ceera budre tääpume. Cäme conocäco pisi nyene cäme ireclota ceerame cuta cääri päpäname. Cäme Babe te apu ituge jaji cane wawename.” ");
INSERT INTO bon_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yeesu me ai mene te Israela biname bine cuta cääri maramara ngene atwanena me jewenimige. ");
INSERT INTO bon_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Teeme bucurage cina jiicisi egä, “Teeme niiya cable pisi nyene. Tabe buduma biname gyene. Weene teebine ngeno me jitecijeniye?” ");
INSERT INTO bon_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yepä poto cina jiicisi egä, “Niiya cable cama biname te äblicäco apu mene iicema. Ingle naace gyene, niiya cable cama biname te lipulipu irecu määsumäsu biname bine jaawenimuge teepi päpänename.” ");
INSERT INTO bon_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Padare te tatyaramtige Yerusalema je iiwäreja mete ne ngene apecname. Pui lui gäbu padare ge. ");
INSERT INTO bon_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeesu liba ädige Solomona me caagecage toro mete gawe cabu Acejiyame me iiwäreja mete caale bora je, ");
INSERT INTO bon_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","piba Israela biname cina teebine jewaclomtisi, jejisi egä, “Maane lipu lecaleca padare naanajinige cibibine jaji cäco, egä maane laasi näte? Nijini conocäco, maane liba Keriso säte, Acejiyame te lui ne ätyepame tiicuji biname bine mäpu cabu ca äsecrerame.” ");
INSERT INTO bon_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu jejemige, “Cane uja ituge jaji weebibine, yepä weene lica itu nätrungepeye cebine. Cane lui ciitaca mule bine ituge waweneca cäme Babe me ngii cabu je, pui cina cebine naitnäjenisi. ");
INSERT INTO bon_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yepä weene lica nätrungeniye cebine, ingle weene cäme maamoi lica gemi. ");
INSERT INTO bon_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cäme maamoi cina cäme tagepogogo nätecijusi, siige cane umle gäne teepi. Teepi cäme ingwe poto ca saacluge. ");
INSERT INTO bon_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nuuja te äblicäco teebibine cäme bau ca äsecrera, yepä cane teebibine iyeteta ireclota cire yääcäremepene, siige teepi budre ne lica cire jääpänepesi. ");
INSERT INTO bon_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Cäme Babe lui te ituge cebine ai maamoi ceera, tabe sine baborage. Nuuja te äblicäco gyene teebibine Babe me ime cabu ca äsecrera. ");
INSERT INTO bon_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Cine Babe cama yepä gegi.” ");
INSERT INTO bon_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Piba Israela biname cina cuta cääri kula bine etomlicmisi Yeesu ne äbyecrame. ");
INSERT INTO bon_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yeesu teebibine jejemige egä, “Cane weeme opo gaabe bucurage miijimiji mule ituge waweneca, Babe te lui tääpume ituge jaji. Lui mule name pi weene cebine kula ca äbyecrame naweniniye?” ");
INSERT INTO bon_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Israela biname cina jejisi egä, “Cine määme miiji mule name pi kula ca äbyecrame lica naaweninisi, yepä maane lipu Acejiyame me ngii ne sabe itu tewenumete. Maane binamerage gäte, yepä maane Acejiyame me äbitenite!” ");
INSERT INTO bon_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu jejemige egä, “Weeme Cotre cabu oogäräneji gyene, egä Acejiyame te jiicuji, ‘Weene acejiyame gemi!’ ");
INSERT INTO bon_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mine umle gemi, egä Oogäräneji mene te ngena jiicenige, iyeteta toraca enajenige. Siige Acejiyame te liba acejiyame ca einemuji pui biname bine, Acejiyame me Mene lui bine ecäremujisi, ");
INSERT INTO bon_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","cije weene piba ngena name pi najeniye cebine, Babe te lui ne teeme tääpume mara me nawenuji, siige gawecewe cabu me nätyepuji, egä cane Acejiyame me ngii ne sabe jaawenune, teeme Bägrä ca liba lainune. ");
INSERT INTO bon_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cane liba cäme Babe me kaakesea bine lica jaawenimune, piba weene gone cebine nätrunguye. ");
INSERT INTO bon_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yepä cane liba jaawenimune, weene miiji cäme kaakesea poto cidi me ätrunga, ngänu gyene liba weene cebine lica nätrunguye. Piba weene umle läbitininuye, egä Babe te cäme cabu pisi nyene, cane Babe cabu pisi näne.” ");
INSERT INTO bon_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Israela biname cina cuta cääri äbitininisi Yeesu ne oomla-name, yepä tabe uucrige. ");
INSERT INTO bon_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Puma cita ca Yeesu cääri acnenutige Yoridana baduge nuuja poto doro me, pui puupu cabu me, Yoane luma niinäce biname bine niiye ca jääcisäjemepi, siige tabe puga enajige. ");
INSERT INTO bon_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bucurage biname cina totninisi teeme bau me. Teepi jiicisi egä, “Yoane nuuja ciitaca mule ne lica itu jaawenepi, yepä tabe lui mene jiicemepi ai biname poto cidi me, toraca gyene.” ");
INSERT INTO bon_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bucurage biname cina Yeesu ne puma jitrungisi. ");
INSERT INTO bon_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yepä biname ngii Lajaro pita cama ge. Tabe Betaniya cewe je enajige teeme neeneni ngule cama Maareta piiyepu Mariya. ");
INSERT INTO bon_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Age tona pui Mariya, lui te miiji lengo oil ne yaapadurepi Yageyame me ernge cabu, siige teeme edingäli ca jääcisäjepi. Teeme wate Lajaro tage, lui te pita cama ge. ");
INSERT INTO bon_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Siige ngule cina mene jityepäsi Yeesu bau me egä, “Yageyame, määme miijirage biname te pita cama gyene.” ");
INSERT INTO bon_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yeesu liba peei mene itecijige, tabe jiicige egä, “Ai pita te Lajaro ne budre me lica pa jaawenepi, yepä biname bine pa jaawenemepi Acejiyame me jamyacu apaclyera ne awepyeräjame. Piiyepu ai cabu ca Acejiyame me Bägrä me jamyacu apaclyera ne pa jääpänepesi.” ");
INSERT INTO bon_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesu babo singi ge Maareta teeme maade cama piiyepu teeme wate Lajaro tääpume. ");
INSERT INTO bon_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yoo, Yeesu liba itecijige, egä Lajaro pita cama ge, tabe cäro camu puga enajige neeneni bimu cama. ");
INSERT INTO bon_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Puma cita ca tabe teeme abiberäja bägrä bine jejemige, “Biiri naclege Yuudea probins cabu me.” ");
INSERT INTO bon_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Teepi jejisi egä, “Abiberäja biname, cemacema Israela biname cina meebine kula ca puga liga nääbyecrinumesi budre me, nää maane cuta piiyeme otnime äbitinite?” ");
INSERT INTO bon_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu jejemige egä, “Cije bimu me ngalebora twelb awa lica gemi kroke cabu ca ngälu mämleteca oomlaname? Laati te bimu apaclyera cabu läduge, tabe lica yaatramuge, ingle tabe ai gawecewe me apaclyera ne jääpänuge. ");
INSERT INTO bon_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yepä ciiye cabu laati te liba läduge, tabe yaatramuge, ingle teeme cabu nuuja apaclyera lica birige.” ");
INSERT INTO bon_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Puma cita ca tabe abiberäja bägrä bine jejemige, “Mime biname Lajaro ute gyene, yepä cane ädenine teebine alotnentame.” ");
INSERT INTO bon_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Teepi jejisi egä, “Yageyame, tabe liba ute ogrenige, miiji äbitenige teeme pita cabu ca.” ");
INSERT INTO bon_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeesu ai mene Lajaro me budre poto cidi me jiicige, yepä abiberäja bägrä cina apu jengemige, egä papa ute me jiicige. ");
INSERT INTO bon_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Piba Yeesu pajecurage jejemige teebibine egä, “Lajaro budre gyene. ");
INSERT INTO bon_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cane wemiji pi gege gäne, egä cane puga lica ge, tabe lui padare cabu budre täbitumi, ingle peei cabu ca weene umle päbitipeye cebine ätrungame. Biiri naclege teeme bau me!” ");
INSERT INTO bon_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Puma cita ca Tooma, ‘Päädepäde’ ca lui ne einenisi, nuuja abiberäja bägrä bine jejemige egä, “Yoo siige, mine biiri naclege iyeta Yeesu cama budre me.” ");
INSERT INTO bon_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yeesu liba Betaniya me atyaramtige, tabe umle äbitige, egä Lajaro ne uja secitumesi, siige gape ngalebora fooa bimu cama senajumi. ");
INSERT INTO bon_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya lui trii kilomiita padare ge Yerusalema ca. ");
INSERT INTO bon_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bucurage Israela biname cina itu tabasecretnumi Maareta Mariya naabi bau me sigita tääpume teeme wate me budre name pi. ");
INSERT INTO bon_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maareta liba utecijige, egä Yeesu biiri tädenige, tabe oclige teebine awacletnäjame, yepä Mariya mete cabu je onajige. ");
INSERT INTO bon_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maareta liba Yeesu ne jepänige, tabe jejige egä, “Yageyame, maane liga ama cirege, cäme wate te budre lica cire läbiteji. ");
INSERT INTO bon_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yoo, tabe puu budre gyene, yepä cane umle gäne, egä Acejiyame te nääcärenige, maane ngeno me jejenite.” ");
INSERT INTO bon_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeesu Maareta ne jojige, “Määme wate te budre cabu ca alotnantenige ireclota me.” ");
INSERT INTO bon_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tabe jejige egä, “Yoo, cane umle gäne, egä ceräcerägääbu bimu cabu iyeta biname cina liba budre cabu ca ireclota me cire larpinäripesi, tabe cuta piba cirege arpinenta.” ");
INSERT INTO bon_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu jojige egä, “Cane age säne budre cabu ca lui te biname bine cirege arpinera piiyepu ireclota ceera. Laati te cebine nätrunguge, ngänuge tabe puu budre gyene, yepä tabe ireclota gyene. ");
INSERT INTO bon_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Piiyepu laati te ai ireclota cabu nätrunguge cebine, tabe iyeteta budre ne lica jääpänuge. Nää, maane cäme mene nätrungenite?” ");
INSERT INTO bon_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tabe jejige egä, “Yoo Yageyame, cane näätrungenine, egä maane Keriso säte, Acejiyame lui ne itu näätyepuji biname bine äsecrerame mäpu cabu ca. Maane lui Acejiyame me Bägrä gäte, lui ne jewagrijenisi otnime.” ");
INSERT INTO bon_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Puma cita ca Maareta Yeesu ne ebmalige, acnenutige cewe me, teeme igane Mariya ne ogä jojige egä, “Abiberäja biname te bii tädige, tabe määme tääpume nätemlige cebine.” ");
INSERT INTO bon_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya liba utecijige, tabe watatarage mete cabu ca asatige, oclige teebine päpäname. ");
INSERT INTO bon_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeesu cäro camu ge cewe ngalebora me abacita, yepä tabe camu puga ge Maareta luma teebine niinäce edärige. ");
INSERT INTO bon_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sigita me lui Israela biname cina seclumi, teepi liba jopänisi Mariya ne abujengta je watatarage asata je, siige teepi teebine ingwe ucwisi, ingle teepi apu jengemige, egä tabe gape cabu me oclenige ele me. ");
INSERT INTO bon_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya liba pui puupu cabu me atyaramtige, Yeesu luma enajige, siige teebine liba jepänige puma, tabe teeme opo gaabe je utramige, jejige egä, “Yageyame, maane ama liga cirege, cäme wate te budre lica cire läbiteji.” ");
INSERT INTO bon_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yeesu liba jopänige teebine ele angena je cuta liba jepänimige teta cama lui Israela biname cina seclige ele angenetna je, tabe ngenecu mäpu me äbitige. ");
INSERT INTO bon_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tabe itemli-mige egä, “Weene teebine luma secitumeye?” Teepi jejisi egä, “Yageyame, maane tädi ire me.” ");
INSERT INTO bon_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Puma cita ca Yeesu ele enge-nige. ");
INSERT INTO bon_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Israela biname cina jiicisi egä, “Jepäneye, tabe lipu baborage singi ge teeme tääpume!” ");
INSERT INTO bon_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yepä poto cina jiicisi egä, “Tabe irecu määsumäsu biname ne miiji jaawenepi. Tabe ama liga cirege, tabe pama Lajaro me budre gaabe ne cuta cire yaarmeji.” ");
INSERT INTO bon_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeesu cääri ngenecu mäpu me äbitige, siige ädige gape gome me. Pui gape lui kula bora uureji ge. Grana kula ca armeji ge. ");
INSERT INTO bon_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu biname bine jejemige kula ne apetrengtame. Puma cita ca budre biname me ngule Maareta te jejige egä, “Yageyame gone, tabe niiyarage lengo cama gyene, ingle fooa bimu cama gape bora senajumi!” ");
INSERT INTO bon_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeesu jojige, “Egäsu nata cane naajine meebine, egä maane liba ätrunga cama gäte, maane Acejiyame me kokre ne jepänenite.” ");
INSERT INTO bon_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Puma cita ca teepi kula ne epeträngtisi. Yeesu piba cabu me ire acitige, jiicige egä, “Babe, cane eso nääcärenine, egä maane cebine nätecijenite. ");
INSERT INTO bon_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cane umle gäne, egä maane iyeta padare cabu cebine nätecijanute, yepä cane ai mene biname bime name pi jiicenine piba teepi ätrungame, egä maane te cebine itu nätyepujite.” ");
INSERT INTO bon_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ai mene iicana ingwe gaabe ca tabe baborage tagepogogo ca ala abayige egä, “Lajaro, tasati peema cita ca!” ");
INSERT INTO bon_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Siige tabe tasatige gape cabu ca, teeme ime ernge cäbletääpe ca tope atneji ge piiyepu opo cäbletääpe ca acwabäneji ge. Yeesu piba biname bine jejemige, “Jiibiremeye, siige lädege tabe.” ");
INSERT INTO bon_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariya bau me lui Israela biname cina sigita me saaclepi, teepi jepänisi Yeesu ngena mule ne jewenige, siige teeme bucurage cina jitrungisi teebine. ");
INSERT INTO bon_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yepä teeme nesae cina äcnärige Parisea sigu biname bime bau me, teebibine jejemisi, Yeesu ngena mule ne jewenige. ");
INSERT INTO bon_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Puma cita ca Parisea sigu biname piiyepu modamoda iiwäreja biname cina, teepi iyeta mutre biname bine ala tesoglicmisi mene atraname, siige jejemisi egä, “Mine ngena ne jewenenisi? Ai biname te bucurage ciitaca mule bine jewenetnäjenemige. ");
INSERT INTO bon_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mine liba ire taatu jecitenisi tabe apu mule wawenecame, piba iyeta biname cina teebine jitrungenisi, siige teeme bau me eclenige. Piba Rooma cubu biname cina pa saaclepi iiwäreja mete ne sabe wawename piiyepu cuta iyeta biname bine sabe wawename, ingle Rooma gabmani te singi lica gyene nuuja biname te mope me äbitame.” ");
INSERT INTO bon_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Teeme yepä te ngii Kayapa, lui tage iiwäreja mope biname pui padare cabu, jejemige egä, “Weene lipu buduma gemi! ");
INSERT INTO bon_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nää, weene umle lica gemi, egä yepä biname te miiji budre äbita iyeta biname bime tääpume, lica iyeta biname cina?” ");
INSERT INTO bon_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ai lui teeme ngene atwanena mene lica ge. Yepä pui padare cabu tabe tage iiwäreja mope biname, siige Acejiyame te piba ngene atwanena ecärige, egä Yeesu te miiji budre äbita iyeta Israela biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Cuta tabe teeme taatu tääpume lica budre yepä iyeta Acejiyame me bägräwale bime tääpume, lui cina aplidnäreji gemi ai gawecewe cabu iyeta poto ta, naace name pi teebibine yepä gome me abasecretname. ");
INSERT INTO bon_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pui padare cabu ca Israela mutre biname cina gläämu jecijemige Yeesu ne budre me acitame. ");
INSERT INTO bon_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Peei ingwe gaabe ca Yeesu cabucabu lica otnetnäjige Yuudea probins cabu. Tabe pui gawe ne piba sebmalige, ädige yepä cewe me ngii Eperema, lui daapo taatu cewe gome jage. Tabe puga teeme abiberäja bägrä cama enajige. ");
INSERT INTO bon_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israela biname bime äsuplengta trii mameta ge, siige bucurage biname cina abasecretnige cewe maramara cabu ca Yerusalema me. Trii padare camuge, teepi niinäce eclige naace tääpume cude gwidape cabu ca kälyä äbitame piba ingwe ca trii cabu me äbäcname. ");
INSERT INTO bon_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Teepi puma Yeesu ne jirngisi, siige iiwäreja mete cabu ätemläjinisi egä, “Weene lipu ngene jotwanininiye, nää tabe pama tädenige ai trii padare tääpume coo lica?” ");
INSERT INTO bon_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Modamoda iiwäreja biname piiyepu Parisea sigu biname cina jiicisi egä, “Laati te liba päpäna je, egä tabe luma enajenige, pui biname te miiji cibibine umle wawename, cine piba teebine oomlana.” ");
INSERT INTO bon_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Piiyeme siks bimu ge äsuplengta trii padare oomlaname, Yeesu piba Betaniya cewe me ädige, Lajaro luma senajenäjumi, tabe lui ne budre cabu ca yaarpenantepi. ");
INSERT INTO bon_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yeesu ne deedei puga ecärisi. Lajaro pui bime yepä ge, lui cina teta cama deedei äbitininisi. Maareta mogobi jewenimige. ");
INSERT INTO bon_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Piba Mariya ecatige miiji lengo camlecamle nardus oil karpu ne, babo daremu ca lui oil ne jaaletnusi, epadurige Yeesu me ernge cabu, piba edingäli ca jicisäjige. Miijirage lengo te mete ne iyeta joomlige. ");
INSERT INTO bon_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yeesu me yepä abiberäja bägrä ngii Yuuda Isakariyota, lui te teebine pagege budre me awaba, tabe Yeesu ne jejige egä, ");
INSERT INTO bon_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngena name pi mine ai oil ne acata cäco aletname trii hanred silba rarekaake ca, siige pui rarekaake owecumete biname bine ceerame?” ");
INSERT INTO bon_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tabe ai mene naace name pi lica jiicige, egä tabe owecumete biname bime tääpume owecu ge, yepä tabe naace popi jiicige, ingle tabe eromaame ge. Tabe te teeme iyeta bime rarekaake ire jaatwemuge, siige peema cita ca yaawadimuge rarekaake bine teeme singi gaabe wawenetnäjame. ");
INSERT INTO bon_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yeesu Yuuda ne jejige egä, “Obmali teebine. Tabe ewetnenige teeme lui oil cebo pisi nyene cebine gape cabu acita bimu tääpume. ");
INSERT INTO bon_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Owecumete biname cina weene cama iyeteta pa yaacrajepi, yepä cane weene cama iyeteta lica pagege lenaja.” ");
INSERT INTO bon_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bucurage Israela biname cina itecijemige, egä Yeesu Betaniya sine. Puma cita ca teepi eclige Betaniya cewe me lica Yeesu taatu name pi, yepä teepi cuta singi Lajaro ne päpäname, Yeesu lui ne budre cabu ca itu yaarpinantepi. ");
INSERT INTO bon_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Siige modamoda iiwäreja biname cina gläämu jicrajige Lajaro ne cuta budre me aglime, ");
INSERT INTO bon_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ingle temiji pi bucurage Israela biname cina Yeesu me poto cidi me äbitininisi, teebine jitrungisi. ");
INSERT INTO bon_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nuuja bimu cabu äsuplengta trii tääpume lui biname cina itu tabasecretnumi, teepi itecijemige, egä Yeesu biiri tädenige Yerusalema me. ");
INSERT INTO bon_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Teepi uli ciipe bine icnapimisi, eclige teebine awacletnäjame. Teepi baborage tagepogogo ca abayininisi egä, “Acejiyame ne yaawepyeräjesi! Yageyame me ngii cabu lui te tädenite, tabe miiji naawenege meebine! Acejiyame te Israela mope biname ne miiji naawenege!” ");
INSERT INTO bon_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yeesu mamye dongki ne jepänige, siige acenutige teeme papa cabu me. Apu ibibi äbitige Oogäräneji mene, lui te jiicenige egä, ");
INSERT INTO bon_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Babo cewe lui Siiyona podo cabu, maane wälu gone! Määme mope biname te aga tädenige mamye dongki papa cabu.” ");
INSERT INTO bon_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pui padare cabu abiberäja bägrä cina ai mule ne opo lica ewatnujisi, yepä Acejiyame te liba Yeesu ne budre cabu ca erpinan-tuji, teepi piba ngene jotwinujisi, egä apu oogäräneji gyene teeme poto cidi me, cuta teepi apu ituge wawena teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lui biname cina jääpänepesi Yeesu lipu Lajaro ne gape cabu ca ala taasoglecepi, siige budre cabu ca yaarpinantepi ireclota me, teepi biname bine umle jaawenanemepesi. ");
INSERT INTO bon_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Siige biname cina seclige Yeesu ne awacletnäjame, ingle teepi peei ciitaca mule poto cidi me ituge ätecija. ");
INSERT INTO bon_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Puma cita ca Parisea sigu biname cina teemeteme ajananinisi egä, “Jepäneye! Mine äblicäco gemi nuuja mule ne wawena! Iyeta biname cina teebine ingwe icwenisi!” ");
INSERT INTO bon_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Poto Griik biname cina cuta puga ge pui biname bime sobe cabu, lui cina Yerusalema me seclumi äsuplengta trii padare cabu Acejiyame ne awejename. ");
INSERT INTO bon_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Teepi Pilipo bau me seclige. Tabe lui Betesaida cewe biname ge, lui cewe Galilaya probins ngalebora jage. Teepi Pilipo ne jejisi egä, “Babo biname, cine singi gemi Yeesu ne päpäname.” ");
INSERT INTO bon_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Puma cita ca Pilipo ädige, Andrea ne jejige, siige teepi gigri aaclige Yeesu ne umle wawename. ");
INSERT INTO bon_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeesu teebibine jaajige egä, “Padare te bii tatyaramtige Acejiyame te awabudni-tame, egä teeme bau ca lui te täduji biname me äbituji, tabe lipu jamyacu apaclyera cama gyene. ");
INSERT INTO bon_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cane toracarage jijenine weebibine: wiiti kuu te liba gawe cabu me lica yaatramuge, siige budre liba lica läbituge, teeme cabu ca äblicäco nuuja gwidape te agi. Yepä liba budre läbituge, siige bucurage kuu cina täpletnäruge. ");
INSERT INTO bon_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Laati te teeme ireclota tääpume singi yaanajuge, tabe teeme ireclota ne yaapesaruge. Yepä laati te liba teeme ireclota tääpume singi lica birige ai gawecewe cabu, tabe teeme ireclota ne yaamacetnäjuge iyeteta ireclota tääpume. ");
INSERT INTO bon_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Laati te liba singi cäme kaakesea wawename, tabe cane cama tädenige naace name pi egä cäme kaakesea bägrä te emä lenajame cane luma. Cäme Babe te eei ne opo gaabe me yaacituge, lui te cäme kaakesea ne jaawenuge.” ");
INSERT INTO bon_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Page cäme ngenecu mäpu gyene, siige cane miiji ngena iicaname! Nää, cane apu irecu lätumutene egä, ‘Babe, lui mäpu te tädenige cäme niinäce gaabe me, maane iyeblingtepi.’ Eewe, cane äblicäco pepu irecu ätumuta, ingle cane aima tädujine ai mäpu cabu cewe oocaname. ");
INSERT INTO bon_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Babe, määme ngii me jamyacu apaclyera ne seboclomtepi!” Puma cita ca tagepogogo te cabucewe ca tädige egä, “Cane cäme ngii me jamyacu apaclyera ne ituge aboclomta, cuta cane pagege cääri aboclomta!” ");
INSERT INTO bon_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lui biname cina puma aclajuteji icrajige, teepi liba ai tagepogogo itecijemige, teepi jiicisi egä, “Maadubi ala ge pama,” yepä poto cina jiicisi egä, “Acejiyame me mename seemo te mene tejige teebine.” ");
INSERT INTO bon_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yeesu puma cita ca teebibine jejemige egä, “Ai tagepogogo te lica tädige cäme name pi, yepä weeme name pi. ");
INSERT INTO bon_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Siige page padare gyene ai gawecewe ne atraname. Ai gawecewe ne lui te ecanenige, teebine iyeblingtenisi page. ");
INSERT INTO bon_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cebine liba gawe cabu ca atecwenta cabu me, cane iyeta biname bine pa saawademepene cäme bau me.” ");
INSERT INTO bon_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ai mene iicema ca tabe eboclomtige, tabe lipulipu gaabe cabu budre pa läbitepi. ");
INSERT INTO bon_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Puma cita ca biname cina jejisi teebine egä, “Mime Cotre te nijenininige, egä Keriso, biname bine mäpu cabu ca lui te cirege äsecrera, tabe iyeteta lenaja myene. Maane cije piba lipulipu jiicite, egä Acejiyame bau ca lui te otni biname me äbitame, teebine miiji cabu me atecwenta? Laasi nyene ai, lui te Acejiyame bau ca cirege otni biname me äbitame?” ");
INSERT INTO bon_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeesu jejemige egä, “Apaclyera te cerämu matikolä padare weene cama pa yaanajepi. Weene otni-neye, apaclyera liba taatu camu pisi nyene weene cama, cije krokeciiye te itrugärinuge weebibine. Krokeciiye cabu lui te waatnuge, tabe umle lica gyene liiyeme otni. ");
INSERT INTO bon_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Weene ätrunga eciteye apaclyera cabu me, tabe liba pisi nyene weene cama, piba weene apaclyera cama biname birige.” Ai mene ingwe gaabe ca Yeesu piba ädige, ämlitige biname bime bau ca. ");
INSERT INTO bon_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeesu puu bucurage ciitaca mule bine ituge waweneca Israela biname bime irewale je, yepä teepi lica jitrungisi teebine ");
INSERT INTO bon_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","naace tääpume Acejiyame me mename biname Isaya me mene te toraca me äbitame egä, “Yageyame, biname cina ätrunga cäco ituge cime mene poto cidi me, piiyepu teepi umle cäco määme kokre.” ");
INSERT INTO bon_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Teepi naace popi äblicäco ge ätrungame, ingle Isaya cuta itu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Acejiyame te teeme irecu bine iredärime me jewenimuji, egä teepi cije cängena jääpänusi. Tabe teebibine mopemuli cäco me jewenemuji, egä teepi cije umle läbitininusi, piiyepu cuta tatatrongäruge cäme bau me lui Acejiyame gäne naace name pi egä cane teebibine miiji wawename.” ");
INSERT INTO bon_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya ai mene jiicuji, ingle tabe niinäce gaabe me Yeesu me kokre ne jepänuji, peei name pi tabe teeme poto cidi me apu jiicuji. ");
INSERT INTO bon_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ngänuge puu iyeta ai mule cina äpletnera, yepä cuta bucurage modamoda Israela biname cina Yeesu ne jitrungisi. Yepä Parisea sigu biname bime wälu name pi teepi cabucabu lica jitrungisi, cije teebibine äyeblengäja mage teeme irecu ätumuta cabu ca. ");
INSERT INTO bon_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Teepi singi biname cina teeme tääpume miijirage ngene atwana cama lenajame, yepä lica Acejiyame te. ");
INSERT INTO bon_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeesu baborage tagepogogo ca jiicemige egä, “Laati te nätrunguge cebine, tabe cebine taatu lica nätrunguge, yepä cuta teebine jäätrunguge, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Laati te cebine näpänuge, tabe cuta jääpänuge eei ne, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cane tädujine ai gawecewe cabu biname bine apaclyera tääpume, egä iyeta lui cina cebine nätrungusi, teepi krokeciiye cabu lica page yaacrajemepi. ");
INSERT INTO bon_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Laati te yäätecijuge cäme mene, yepä lica yaacatuge, cane teeme atrana biname lica gäne, ingle cane lica itu tädujine aima biname bine atraname yepä niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Atrana pisi nyene pui biname tääpume, lui te cebine nägyuge piiyepu cäme mene jäägyemuge. Cane lui mene bine ituge iicema, pui cina teebine cirege atrana. ");
INSERT INTO bon_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cane cämerage ngii cabu lica ituge iicema, yepä Babe lui te cebine nätyepuji, tabe te ituge ajanena cane ngena jajanename piiyepu iicemame. ");
INSERT INTO bon_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cuta cane umle gäne, egä Acejiyame lui mene jiicemimuge, iyeteta ireclota yääcäranemuge biname bine pui mene te. Yoo siige, cane jiicemimune, Babe te ngena ituge jajanena cebine.” ");
INSERT INTO bon_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Äsuplengta trii liba nuuja bimu ge, Yeesu tabe umle ge, egä teeme padare te bii tatyaramtige ai gawecewe ne abmalame siige Babe bau me acnenutame. Tabe iyeta padare singi ituge pui bime tääpume, ai gawecewe cabu lui teemi nemi. Teeme budre te liba mameta me täbitige, tabe lica teebibine jigyemige, yepä tabe singi ge teeme tääpume ngälu ngälugaabe oomlaname. ");
INSERT INTO bon_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeesu teeme abiberäja bägrä cama liba deedei cabu jage, Satani te uja ngene atwana ecäruji Yuuda ne, lui Simona Isakariyota me bägrä ge, tabe Yeesu ne awabame budre me aglime. ");
INSERT INTO bon_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu umle ge, egä Babe te iyeta kokre teebine ituge ceera. Tabe cuta umle ge, egä tabe Acejiyame bau ca itu täduji cuta teeme bau me acnenutenige. ");
INSERT INTO bon_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Siige tabe abujängtige deedei loolo dade cabu ca, teeme cäbletääpe ne iyeblingtige, taweli ca amlemaltige ibi cabu. ");
INSERT INTO bon_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Piba tabe niiye ne disi cabu epadurige, siige gije abacitige abiberäja bägrä bine ernge äcisejame. Liba yepä ne jääcisäjuge, pui taweli ca cuta nebo jääcisäjuge, lui te teeme ibi cabu amlemalteji ge. ");
INSERT INTO bon_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tabe liba Simona Peteru gome tädige teeme ernge äcisejame, Peteru jejige egä, “Yageyame, nää maane te äbitenite cäme ernge äcisejame?” ");
INSERT INTO bon_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu jejige egä, “Maane page umle lica gäte, cane ai lui ngena ne jewenenine, yepä maane ingwe ca umle pagege äbita.” ");
INSERT INTO bon_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peteru jejige egä, “Eewe, pipu padare te lica tädenige egä maane cäme ernge äcisejame!” Yeesu jejige egä, “Cane liba määme ernge lica nääcisäjenine, maane piba cäme abiberäja bägrä lica gäte.” ");
INSERT INTO bon_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Peteru te jejige egä, “Yageyame, piba cäme ernge taatu gone näcisäjute, yepä ime piiyepu mope cama näcisäjepi!” ");
INSERT INTO bon_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeesu jejige egä, “Laati te liba gooni loowanguge, tabe nuuja gwidape tääpume singi lica, yepä tabe ernge taatu jääcisäjuge, siige tabe piba jugi cäco birige. Weene jugi cäco gemi, yepä weeme iyeta cina lica.” ");
INSERT INTO bon_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeesu umle ge, egä laati te teebine budre me pa jaawabepi, peei name pi tabe jiicige, egä teepi iyeta jugi cäco lica gemi. ");
INSERT INTO bon_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeesu liba apirige abiberäja bägrä bine ernge äciseja ca, tabe teeme cäbletääpe asigrige, acnenutige teeme puupu cabu me adnatame, piba abiberäja bägrä bine itemlimige egä, “Weene nää umle bäbitininiye, cane ngena bii jewenine weeme tääpume? ");
INSERT INTO bon_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Weene naininiye Abiberäja biname ca piiyepu Yageyame ca. Weene peei lui toraca mene jiiceniye, ingle cane pipu gäne. ");
INSERT INTO bon_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Siige liba cane, weeme Yageyame piiyepu Abiberäja biname te weeme ernge bii jicisäjemine, weene cuta miiji pepu weemeweme ernge äcisejana. ");
INSERT INTO bon_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Cane ai ne naace tääpume bii jewenine weene cebine ätutename. ");
INSERT INTO bon_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cane toraca jijenininine, egä kaakesea bägrä te lica birige baborage teeme babo biname bau ca, cuta mename biname te babo lica birige teeme bau ca, teebine lui te jäätyepuge. ");
INSERT INTO bon_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Weene aga umle bäbitininiye ai mule poto cidi me, siige lipu gege gemi weene, liba apu läbitininuye. ");
INSERT INTO bon_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Cane weeme iyeta poto cidi me ai mene lica jiicenine, ingle cane umle gäne weene lipu biname gemi, cane lui bine ituge äjäcra. Oogäräneji mene te lipu jiicenige egä, ‘Lui te cane cama deedei äbitenige, tabe cebine pa näcisärmutepi,’ ai mene te miiji toraca me äbitame. ");
INSERT INTO bon_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cane ai mene naace name pi niinäce gaabe me jijenininine weebibine, egä ai mule te liba pa läbitepi weene piba ätrungame, egä cane pui biname gäne, lui tääpume cane jijananinune weebibine. ");
INSERT INTO bon_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cane toraca jijenininine, egä laati te yaacatuge, cane lui ne jäätyepune, tabe cebine nacatuge. Piiyepu laati te cebine nacatuge, tabe cuta teebine yaacatuge, cebine lui te nätyepuji.” ");
INSERT INTO bon_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ai mene iicema ingwe gaabe ca Yeesu mage ngenecu mäpu me äbitige, pajecurage jiicige egä, “Cane toraca jijenininine weebibine, egä weeme yepä te page nawabenige cebine budre tääpume!” ");
INSERT INTO bon_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Abiberäja bägrä cina teemeteme ire atwananinisi umle cäco, egä tabe laati poto cidi me jiicige ai mene. ");
INSERT INTO bon_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Abiberäja bägrä bime yepä te, Yeesu lui tääpume babo singi, tabe teeme gome adnatäneji ge. ");
INSERT INTO bon_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simona Peteru teebine irecu cubu ca jewenige Yeesu ne ätemlame, egä tabe laati poto cidi me jiicige peei mene. ");
INSERT INTO bon_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Siige pui abiberäja bägrä te äbyenutige Yeesu bau me, itemlige egä, “Yageyame, maane laati tääpume jiicite peei mene?” ");
INSERT INTO bon_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu teebine jejige egä, “Cane liba buluduu pacu ne yiiglenutenine jurä cabu me, siige liba laati ne ecärenine, peese nyene pui biname.” Siige tabe buluduu pacu ne ecatige, yiiglenutige, ecärige Yuuda ne, lui Simona Isakariyota me bägrä ge. ");
INSERT INTO bon_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Liba Yuuda buluduu ne juutecrige, piba taatu Satani te abacitige teeme trupa cabu me. Yeesu Yuuda ne jejige egä, “Maane ngena wawena mäte singi, watawata jeweni.” ");
INSERT INTO bon_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nuuja abiberäja bägrä cina nuuja umle lica ge, egä Yeesu ngena tääpume teebine apu jejige. ");
INSERT INTO bon_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ingle Yuuda lui teeme rarekaake ire atwi biname ge, poto abiberäja bägrä cina apu jengemige, egä Yeesu teebine jejige ai soriyomu tääpume gwidape aletname coo owecumete biname bine rarekaake ceerame. ");
INSERT INTO bon_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Siige Yuuda liba buluduu pacu juutecrige, tabe piba taatu asatige. Pui lui ciiye ge. ");
INSERT INTO bon_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuuda liba asatige, Yeesu piba abiberäja bägrä bine jejemige egä, “Siige Acejiyame bau ca lui te täduji biname me äbituji, teeme jamyacu apaclyera ne page jepänenisi, cuta Acejiyame me jamyacu apaclyera ne jepänenisi teeme cabu ca. ");
INSERT INTO bon_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siige Acejiyame me jamyacu apaclyera ne liba jepänenisi teeme cabu ca, piba Acejiyame te teeme Acejiyamerage cabu ca pajecu me jewenenige pui me jamyacu apaclyera ne, teeme bau ca lui te täduji biname me äbituji. Tabe peei ne watatarage jewenenige. ");
INSERT INTO bon_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cäme miijirage bägräwale, cane matikäli padare taatu cerämu nanajinige weene cama. Weene cebine pa närngepeye, yepä cane peei yepä mene jijenininine weebibine, cane lipu Israela biname bine ituge jaji, egä cane liiyeme ädenine, weene peeyeme äblicäco gemi otni. ");
INSERT INTO bon_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cane weebibine kirece cotre icärininine: weene miiji weemeweme singi äbitena. Cane lipu weeme tääpume singi ituge, weene cuta miiji pepu weemeweme singi äbitena. ");
INSERT INTO bon_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Weene liba weemeweme singi läbitaninuye, pui cabu ca biname cina umle birige, egä weene cäme abiberäja bägrä gemi.” ");
INSERT INTO bon_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Peteru te Yeesu ne itemlige egä, “Yageyame, maane liiyeme ädenite?” Yeesu jejige egä, “Page maane äblicäco gäte cane cama otni, cane liiyeme ädenine, yepä maane ingwe ca cire tädepi.” ");
INSERT INTO bon_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peteru jejige egä, “Yageyame, ngena name pi cane äblicäco gäne page maane cama otnime? Cane bamacetnäjine mämiji pi budre äbitame.” ");
INSERT INTO bon_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu jejige egä, “Maane nää toraca bamacetnäjite cämiji pi budre äbitame? Cane toraca mene naajenine, airage ciiye cabu maane niinäce cebine nesae gääbu nainenite, paulo te ingwe ca ala piba sengenenige.” ");
INSERT INTO bon_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Weene ngenecu mäpu gone! Acejiyame ne jitrungeye cuta cebine nätrungeye. ");
INSERT INTO bon_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cäme Babe me mete cabu bucurage puupu piti nemi, siige cane ädenine weeme tääpume amacetnäjame. Puupu liga lica cirege, cane piba weebibine apu lica cire jijinejine. ");
INSERT INTO bon_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cane puu niinäce ädenine weeme tääpume puupu ne amacetnäjame, cane cuta cire tacnepene weebibine arwojame cäme bau me. Weene puma cire inajipi, cane luma. ");
INSERT INTO bon_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Weene umle gemi gaabe, pui puupu cabu me lui gaabe te ädenige, cane luma pagege lenaja.” ");
INSERT INTO bon_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tooma Yeesu ne jejige, “Yageyame, cine umle lica gemi, maane liiyeme ädenite, cine piba lipulipu pagege umle äbita gaabe piiyeme otnime?” ");
INSERT INTO bon_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu Tooma ne jejige egä, “Cane age säne gaabe, cane age säne toraca, cane age säne ireclota. Nuuja gaabe lica gyene Babe bau me otni me, yepä cane säne gaabe. ");
INSERT INTO bon_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Weene liba toraca umle cirege cane, weene piba cuta umle cirege Babe. Siige page ama cita ca weene umle gemi tabe; weene ituge teebine päpäna.” ");
INSERT INTO bon_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo Yeesu ne jejige, “Yageyame, Babe niwabini cibibine! Cine peei taatu memi singi.” ");
INSERT INTO bon_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu teebine jejige egä, “Pilipo, maane nää toraca umle cäco gäte cane, ngänuge cane puu lecaleca padare weene cama itu nanajenanumi. Laati te liba cebine näpänuge, tabe cuta Babe ne jääpänuge, peei name pi maane lipulipu jiicite egä, ‘Babe niwabini cibibine.’ ");
INSERT INTO bon_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Maane nää ätrunga lica gäte, egä cane pisi näne Babe cabu, Babe pisi nyene cäme cabu. Cane cäme ngene atwana mene lica jiicemimune, yepä Babe te cäme cabu sine, siige cäme cabu ca kaakesea jewenenige. ");
INSERT INTO bon_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Weene miiji ätrunga, egä cane Babe cabu säne, Babe cäme cabu sine. Weene liba nuuja ingle name pi lica birige ätrunga, weene miiji cäme kaakesea miji pi ätrunga. ");
INSERT INTO bon_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cane toraca jijenininine weebibine, egä laati te cebine nätrunguge, tabe epu mule bine jaawenimuge cane liiyepu. Cuta cerämu poto jaawenimuge, ingle cane Babe bau me ädenine. ");
INSERT INTO bon_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iyeta weene lui tääpume yäätemluye cäme ngii cabu, cane jaawenune weeme tääpume naace name pi biname cina piba Bägrä cabu ca päpäname Babe me jamyacu apaclyera ne. ");
INSERT INTO bon_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Weene liba ngena tääpume yäätemluye cäme ngii cabu, cane icärininune.” ");
INSERT INTO bon_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Weene liba singi cäme tääpume, weene cäme mene ibi jaawenimuye. ");
INSERT INTO bon_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Cane Babe ne itemlenine, tabe te nuuja Ätityerayame pa sicäripi weebibine. Pui te weene cama iyeteta pa yaanajepi. Tabe lui Seemo gyene, lui te saaboclomtuge, ngena gyene toraca. ");
INSERT INTO bon_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ätrunga cäco biname cina äblicäco teebine acata, ingle teepi äblicäco teebine päpäna coo teeme poto cidi me umle äbita. Yepä weene umle gemi tabe, ingle tabe weene cama enajenige piiyepu tabe weeme cabu pagege lenaja. ");
INSERT INTO bon_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Cane weebibine taatu lica pa sibmalipene, yepä cane cuta pa tacnenutepene weeme bau me. ");
INSERT INTO bon_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Matikäli padare ingwe gaabe ca ätrunga cäco biname cina cebine lica pa näpänepesi, yepä weene pa näpänepeye. Ingle naace popi cane ireclota nanajinige, weene cuta ireclota pinajipi. ");
INSERT INTO bon_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pui bimu cabu weene umle page äbitipeye, egä cane Babe cabu säne, weene cäme cabu temi, cane weeme cabu säne. ");
INSERT INTO bon_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Laati te cäme mene ne yaacatuge, siige yääcwetnuge, tabe peese nyene biname, lui te cäme tääpume singi. Laati te cäme tääpume singi, cäme Babe te teeme tääpume singi birige. Cane cuta singi gäne teeme tääpume, siige teeme bau me pa laboclomtepene.” ");
INSERT INTO bon_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuuda, lica Isakariyota me bägrä yepä nuuja Yuuda, tabe Yeesu ne jejige egä, “Yageyame, peei lipu gyene, egä maane cime bau me pa taboclomtepi, lica ätrunga cäco biname bime bau me?” ");
INSERT INTO bon_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu Yuuda ne jejige, “Laati te liba cäme tääpume singi, tabe cäme abiberäja mene bine yääcwetnimuge. Cäme Babe te teeme tääpume singi, siige cine cäme Babe cama pa niclepi teeme bau me teeme cabu lenajame. ");
INSERT INTO bon_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yepä laati te liba cäme tääpume singi lica, tabe cäme abiberäja mene bine lica yääcwetnimuge. Weene lui abiberäja mene bine ituge ätecija, cäme lica gemi, yepä cäme Babe memi, lui te cebine nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cane ai mene bii jijananinine weebibine, page cane liba weene cama camu pisi näne. ");
INSERT INTO bon_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yepä Aceji Seemo, Acejiyame te lui ne cäme ngii cabu pagege ätyepa weebibine ätityeraname, tabe te iyeta mule poto cidi me pa sibiberäjipi piiyepu cääri umle pa tiwenanipi, cane ngena poto cidi me itu jijananipene. ");
INSERT INTO bon_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Cane poode ne sebmalenine weeme bau me. Cane cämerage poode icärininine weebibine, peei name pi ngenecu mäpu gone, wälu gone! Pepu pana poode ne weene äblicäco päpäna ai gawecewe cabu ca. ");
INSERT INTO bon_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Weene bii nätecijiye cane iicana je egä, ‘Cane weebibine page sibmalipene, cuta page tacnenutepene weeme bau me.’ Weene liba cäme tääpume toraca singi gemi, weene gege gemi, egä cane Babe bau me ädenine, ingle tabe baborage gyene cäme bau ca. ");
INSERT INTO bon_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cane aga niinäce gaabe me iyeta bii jijananinine weebibine naace tääpume, egä ai cina liba pa läbitipesi, weene piba pagege ätrunga. ");
INSERT INTO bon_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Cane äblicäco gäne cerämu weene cama mene iicema, ingle ai gawecewe ne lui te ecaninige, tabe te tädenige. Tabe nuuja kokre lica gyene cäme tääpume, ");
INSERT INTO bon_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","yepä ätrunga cäco biname cina miiji gemi umle äbita, egä cane singi gäne Babe tääpume piiyepu jaawenimune iyeta, tabe ngena tääpume cebine ituge jaji. Abujängineye! Biiri läsinago, naclege ama cita ca.” ");
INSERT INTO bon_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Cane age säne toraca waina uli, piiyepu cäme Babe te calwacupi ire atwiyame gyene. ");
INSERT INTO bon_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tabe cäme cabu ca yaacnapimuge iyeta ciipe bine, lui cina kuu cäco gemi. Yepä lui ciipe cina kuu cama birige, tabe cängenarage yaamacetnäjimuge, jugi bine jääglubäjemuge naace tääpume teepi cerämu kuu päpäname. ");
INSERT INTO bon_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Cäme mene te uja weebibine jugi cäco me ituge wawena. ");
INSERT INTO bon_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Inajinege cäme cabu, piba cane cuta weeme cabu pagege lenaja. Ciipe te liba lica uli mage cabu birige lenaja, tabe äblicäco kuu päpäna. Pepu gemi weene cuta äblicäco kuu päpäna, weene liba cäme cabu lica birige lenaja. ");
INSERT INTO bon_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Cane waina uli gäne, weene ciipe gemi. Laati te cäme cabu yaanajuge, cane lui me cabu nanajuge, tabe bucurage kuu jääpänimuge. Cäme cäco je weene nuuja gwidape ne äblicäco wawena. ");
INSERT INTO bon_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Laati te cäme cabu lica yaanajuge, teebine yaajarusi uli ciipe ne liiyepu, siige maaje me läbituge. Maaje ciipe bine yaatomli-cmusi, uliobo cabu me yiisabimusi, siige teepi puma layinusi. ");
INSERT INTO bon_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Weene liba cäme cabu inajininuge piiyepu cäme mene te liba weeme cabu pisi nyene, piba weene jääpänimuye iyeta, weene lui tääpume cebine nätinäruye. ");
INSERT INTO bon_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Weene liba bucurage kuu bine jääpänimuye, peei cabu ca cäme Babe me jamyacu apaclyera te babo läbituge, siige weene lawabudnitininuye, egä weene cäme abiberäja bägrä gemi. ");
INSERT INTO bon_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cäme Babe te lipu singi gyene cäme tääpume, cane cuta pipu singi gäne weeme tääpume. Weene cäme singi cabu inajipi. ");
INSERT INTO bon_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Weene liba cäme mene bine yääcwetnimuye, cäme singi te weeme cabu yaanajuge, epu pana cane lipu cäme Babe me mene bine yääcwetnimune, siige teeme singi te cäme cabu yaanajuge. ");
INSERT INTO bon_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Cane ai mene naace tääpume jijananinine egä cäme gege te weeme cabu lenajame, cuta weeme gege te babo äbitame. ");
INSERT INTO bon_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cane weebibine jijenininine, egä weene weemämu singi äbitanipeye, cane lipu weeme tääpume singi ituge. ");
INSERT INTO bon_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Eei gyene baborage singi, biname te liba teeme ireclota ne yääyemaluge budre me teeme binamewale bime tääpume. ");
INSERT INTO bon_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Weene liba cäme mene ibi jaawenimuye, weene cäme binamewale gemi. ");
INSERT INTO bon_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cane ingwe ca lica iyinininine weebibine kaakesea bägrä ca, ingle kaakesea bägrä te umle cäco teeme babo biname te ngena jewenenige. Yepä cane iyinininine cäme binamewale ca, ingle cane ituge weebibine jajanena iyeta, cane cäme Babe bau ca ngena ituge ätecijana. ");
INSERT INTO bon_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Weene te cebine lica itu noomlepeye, yepä cane te weebibine itu joomlipene. Cane weebibine joomlipene, jijipene otnime bucurage kuu bine päpäname, pepu kuu lui cina iyeteta gemi. Piba Babe te page icäripi iyeta gwidape, weene lui tääpume yäätinäruye cäme ngii cabu. ");
INSERT INTO bon_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ai lui cäme singi gyene, egä weene miiji weemämu singi äbitanipeye.” ");
INSERT INTO bon_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Liba ätrunga cäco biname cina weebibine jimugitninusi, weene gone ngene jitrimalinuge, egä teepi cebine niinäce pepu ituge ämugetna. ");
INSERT INTO bon_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Weene liga ai gawecewe biname cama yepä cirege, teepi piba singi cirege weeme tääpume, teepi lipu singi teeme tääpume. Yepä weene teta cama yepä lica gemi, ingle cane te ituge weebibine teeme cabu ca oomlana, peei name pi teepi weebibine jimugitninusi. ");
INSERT INTO bon_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Weene ngene gone jitrimalinuge, cane lipu jijininine egä, ‘Kaakesea bägrä te baborage lica gyene teeme babo biname bau ca.’ Peei name pi cebine liba ituge sabe wawena, cuta weebibine piba pagege sabe wawena. Biname cina liba cäme mene ituge ätecija, teepi cuta weeme mene piba pepu pagege ätecija. ");
INSERT INTO bon_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yepä teepi weebibine iyeta ai pa jiwenanipesi cämiji pi, ingle teepi umle lica gemi tabe, cebine lui te nätyepuji. ");
INSERT INTO bon_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Cane liga lica cire tädejine teebibine mene jajanename, piba teepi umle lica cirege, egä teepi niiya mule biname gemi. Yepä page teepi äblicäco iicana, egä teepi niiya mule biname lica gemi. ");
INSERT INTO bon_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Laati te cebine nämugitnuge, tabe cuta cäme Babe ne jäämugetnuge. ");
INSERT INTO bon_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cane liga biname bime sobe cabu epu mule lica cire jaawenemejine, lui bine nuuja te lica ituge waweneca, teepi piba umle lica cirege, egä teepi niiya mule biname gemi. Yepä teepi ituge päpäna, cane ngena ituge wawenena, siige teepi nimugetnusi cibibine Babe cama. ");
INSERT INTO bon_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Apu ibibi äbitenige teeme Cotre mene te egä, ‘Teepi papa taatu cewe je cebine nämugetnusi.’ ");
INSERT INTO bon_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Cane pa täätyepepene weeme bau me Aceji Seemo ne weebibine ätityeräjame piiyepu aboclomtame, ngena gyene toraca. Tabe Babe bau ca pa tädepi, siige cebine pa naitnäjepi. ");
INSERT INTO bon_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Weene cuta pagege cebine aitneja, ingle weene cane cama ituge lenaja cäme kaakesea agedna cabu ca.” ");
INSERT INTO bon_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Cane naace tääpume ai mene jijanininine egä weene ätrunga ne lica apesera. ");
INSERT INTO bon_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Israela biname cina weebibine teeme irecu ätumuta cabu ca pagege äyecreja. Cuta padare te page tädepi, liba lui cina weebibine budre me pa iglecipesi, teepi apu pa jaangemepi egä, ‘Cine miiji mule ne jewenisi Acejiyame tääpume.’ ");
INSERT INTO bon_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Teepi naace name pi apu pagege wawena, ingle teepi umle lica ituge Babe piiyepu cane. ");
INSERT INTO bon_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yepä cane ai mene naace tääpume jijanininine egä weene cäme mene ngene apecname, ai cina liba pagege äbita.” “Cane niinäce ai poto cidi me lica jijipene weebibine, ingle cane weene cama ge. ");
INSERT INTO bon_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Siige page cane teeme bau me ädenine, lui te cebine itu nätyepuji; yepä weeme nuuja te lica nätemlenige egä, ‘Maane liiyeme ädenite?’ ");
INSERT INTO bon_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Siige page cane lipu jijanininine weebibine, pui name pi weene ngenecu mäpu gemi. ");
INSERT INTO bon_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cane toraca mene jijenininine weebibine, egä ai lui miiji gyene cane weeme bau ca äyeblingtame, ingle cane liba lica äyeblingtenine, piba Aceji Seemo te lica pagege weeme bau me otni weebibine ätityerame. Yepä cane liba äyeblingtenine, cane pa täätyepepene teebine weeme bau me. ");
INSERT INTO bon_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Siige Ätityerayame te liba pa tädepi, tabe te pagege awabudnäja ai gawecewe biname bime tääpume niiya mule piiyepu ngena gyene conocäco piiyepu Acejiyame te lipu biname bine atrana. ");
INSERT INTO bon_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Teepi cängena umle lica gemi, niiya mule ngena gyene, ingle teepi cebine lica nätrungenisi. ");
INSERT INTO bon_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Teepi cängena umle lica gemi, ngena gyene conocäco, ingle cane ädenine Babe bau me, siige weene cebine ingwe ca lica pa näpänepeye. ");
INSERT INTO bon_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Piiyepu teepi atrana poto cidi me cängena umle lica gemi, ingle ai gawecewe ne lui te ecanenige, teebine uja ituge atrana. ");
INSERT INTO bon_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Cäme bucurage mene piti nemi weebibine jajanename, yepä page weene ibibi lica gemi umle äbitame. ");
INSERT INTO bon_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yepä Aceji Seemo, lui toraca gyene, liba pagege otni, tabe te pa sibiberäjipi iyeta ngena gyene toraca. Tabe teemerage ngii cabu lica pagege iicema, yepä tabe eei mene pa jiicemepi, tabe ngena ituge ätecija. Tabe ciige gwidape poto cidi me pa jijananipi. ");
INSERT INTO bon_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tabe te weeme tääpume pagege awaba, egä cane lipu jamyacu apaclyera cama gäne, ingle tabe cäme bau ca ngena mene pa yäätecijanepi, pui mene pa jijananipi weebibine. ");
INSERT INTO bon_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iyeta lui cina cäme Babe memi, teepi cuta cämi nemi. Peei name pi cane apu jiicine, egä Aceji Seemo te pa yaacatepi, cane teebine ngena pagege ceera, siige piba weebibine pa jijananipi.” ");
INSERT INTO bon_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Matikäli padare ingwe gaabe ca weene cebine lica page näpänepeye. Cuta puma cita ca matikäli padare ingwe gaabe ca weene cuta cääri cebine page näpänepeye.” ");
INSERT INTO bon_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Poto abiberäja bägrä cina teemeteme ätemläjinisi egä, “Tabe baa ngena tääpume nijinige egä, ‘Matikolä padare ingwe gaabe ca weene lica page näpänepeye cebine. Cuta puma cita ca matikolä padare ingwe gaabe ca weene cääri cuta page näpänepeye cebine.’ Tabe cuta jiicige egä, ‘Apu gyene, ingle cane Babe bau me ädenine.’ ");
INSERT INTO bon_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ngena gyene ingle teeme ai ‘matikäli padare ingwe gaabe ca’ mene tääpume. Mine umle lica gemi, tabe ngena tääpume jiicenige.” ");
INSERT INTO bon_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesu umle äbitige, egä teepi singi peei poto cidi me ätemlame, siige tabe jejemige egä, “Weene nää pui poto cidi me ngene jotwanininiye, cane lipu jijininine egä, ‘Matikäli padare ingwe gaabe ca weene lica cebine pa näpänepeye. Cuta puma cita ca matikäli padare ingwe gaabe ca weene cuta cääri cebine pa näpänepeye.’ ");
INSERT INTO bon_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cane toraca jijenininine, egä weene ele pingeni-tnipi, yepä ätrunga cäco biname cina gege pagege. Weene ngenecu mäpu cama pinajipi, yepä weeme peei ngenecu mäpu te gege me pa lateplingtepi. ");
INSERT INTO bon_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Magebi te liba bägrä ärngime läbituge, tabe ngenecu mäpu birige, ingle pui padare cabu baborage pita ne jaasicnantuge. Yepä liba bägrä ne jäärnguge, tabe pita ngene jwäätrimaluge, ingle tabe gege birige, bägrä te lipu laplimluge ai gawecewe cabu me. ");
INSERT INTO bon_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Cuta pepu gyene weeme tääpume, weene page ngenecu mäpu cama gemi, yepä cane weebibine cääri pa jipänipene. Piba weene gege taatu pinajipi, siige nuuja te äblicäco gyene weebibine pui gege uutecra. ");
INSERT INTO bon_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pui padare cabu weene cebine lica pagege ätemla nuuja gwidape poto cidi me. Cane toraca jijenininine, egä weene liba ngena tääpume yäätinäruye Babe ne cäme ngii cabu, tabe icärininuge. ");
INSERT INTO bon_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Weene Babe ne lica ituge ätinera nuuja gwidape tääpume cäme ngii cabu ngälu page. Itinärepeye, siige weene pa jepänepeye piba weeme gege te babo pa läbitepi.” ");
INSERT INTO bon_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Cane ngene ca agli mene ca bii jijanininine weebibine ai mule poto cidi me. Yepä padare te pa tädepi, cane liba ngene ca agli mene ca lica pagege jajanena weebibine yepä cane pajecurage page jijanipene cäme Babe poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pui padare cabu weene weemämu irecu pa pätumutanipeye Babe bau me cäme ngii cabu; siige cane lica jijenininine, egä cane pagege weeme tääpume irecu ätumuta Babe bau me, ");
INSERT INTO bon_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ingle Babe te teemämu singi gyene weeme tääpume. Tabe naace popi singi gyene weeme tääpume, ingle weene singi ituge cäme tääpume piiyepu weene ituge ätru-nga, egä cane Acejiyame bau ca tädujine. ");
INSERT INTO bon_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Cane Babe bau ca tädujine ai gawecewe cabu me, siige page cane ai gawecewe ne sebmalenine, acnenutenine Babe bau me.” ");
INSERT INTO bon_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Puma cita ca abiberäja bägrä cina Yeesu ne jejisi egä, “Maane siige page pajecurage jiicenenemite, lica ngene ca agli mene ca. ");
INSERT INTO bon_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Page cine siige umle bäbitinago, egä maane umle gäte iyeta gwidape. Maane niinäce umle läbitute biname cina singi ngena tääpume ätemlame. Peei name pi cine siige jitrungenisi, egä maane Acejiyame bau ca itu tädujite.” ");
INSERT INTO bon_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu jejemige teebibine egä, “Weene siige page jitrungeniye. ");
INSERT INTO bon_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Padare te tädenige – siige uja bii tatyaramtige – weene liba eplidnäreniye weeme yepäyepä bime mete me, cebine taatu nabmaleniye. Yepä cane taatu lica gäne, cäme Babe pisi nyene cane cama. ");
INSERT INTO bon_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cane naace name pi weebibine iyeta ai mene bii jijanininine egä weene cäme cabu ca poode ne päpäname. Ai gawecewe cabu weene mäpu bine jääpänanemuye, yepä wälu gone äbita, cane gawecewe mule bine ituge apremela.” ");
INSERT INTO bon_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yeesu liba mene iicema iyeta apirige, tabe ire acitige cabucewe me, jiicige egä, “Babe, cäme padare te biiri tatyaramtige. Maane biname bime bau me eboclomtepi, egä cane määme Bägrä lipu jamyacu apaclyera cama gäne piba cane biname bime cabu me pagege aboclomta, egä maane lipu jamyacu apaclyera cama gäte. ");
INSERT INTO bon_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Maane cebine conocäco itu näcärepete iyeta biname bine waadename naace tääpume cane iyeteta ireclota ceerame iyeta eei biname bine, maane lui ituge ceera cebine. ");
INSERT INTO bon_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lui cina umle gemi maane, lui säte yepä taatu toraca Acejiyame piiyepu cuta lui cina umle gemi cane, Yeesu Keriso, maane lui ne ai gawecewe cabu me nätyepujite, teepi uja iyeteta ireclota cabu me bebäcnisi. ");
INSERT INTO bon_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Babe, cane määme jamyacu apaclyera ne ituge aboclomta ai gawecewe cabu, ingle cane siige bepirine, maane lui kaakesea itu näcärepete cane te wawename. ");
INSERT INTO bon_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Babe, määme opo gaabe je maane pui yepä jamyacu apaclyera näcärepi, cäme lui apaclyera puga ge, cane liba maane cama jage agedname niinäce gaabe me. ");
INSERT INTO bon_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Cane ai biname bine umle ituge wawena määme poto cidi me, maane lui ituge äjäcra cäme tääpume ai gawecewe cabu ca. Teepi lui määme biname ge, yepä cebine itu näcärepete maane. Teepi määme mene ituge ätrunga, ");
INSERT INTO bon_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","siige page teepi umle gemi, egä iyeta maane lui ituge ceera cebine, määme bau ca gemi. ");
INSERT INTO bon_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Maane lui mene itu näcärepete cebine, cane teebibine ituge jajanena, siige teepi becatisi. Teepi umle gemi, egä toraca gyene, egä cane määme bau ca itu tädujine. Teepi jitrungenisi, egä maane te cebine itu nätyepujite. ");
INSERT INTO bon_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Cane irecu ätumutenine teeme tääpume. Cane lica irecu ätumutenine biname bime tääpume, lui cina icrajenige gawecewe mule cabu, yepä cane ai bime tääpume irecu ätumutenine, maane lui ituge cebine ceera, ingle teepi määmi nemi. ");
INSERT INTO bon_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iyeta lui cina cämi nemi, cuta määmi nemi; piiyepu lui cina määmi nemi, cuta cämi nemi. Biname cina teeme cabu ca jääpänusi, egä cane lipu jamyacu apaclyera cama gäne. ");
INSERT INTO bon_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Babe, cane siige page määme bau me ädenine. Cane ai gawecewe cabu lica pa nanajepi, yepä teepi ama pagege. Miijirage Babe, maane miiji määme ngii me kokre ca ire atwemame teebibine, lui ngii maane ituge cebine ceera, piba teepi yepä äbitame, mine liiyepu yepä gegi. ");
INSERT INTO bon_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cane liba taatu aga ge teta cama, cane teebibine cängena ire jaatwemune määme ngii me kokre ca, maane lui ngii cebine ituge ceera. Cane ituge cängenarage teebibine ire atwema, siige nuuja te lica ituge apesera, yepä pui taatu gyene, lui te miiji otni niiya puupu cabu me naace tääpume Oogäräneji mene te toraca me äbitame. ");
INSERT INTO bon_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Babe, cane page ädenine määme bau me. Cane ai mene naace tääpume jiicenenemine, cane liba taatu ai gawecewe cabu je, egä cäme gege te teeme cabu babo äbitame. ");
INSERT INTO bon_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cane määme mene ituge jajanena teebibine, siige ai gawecewe muleyame biname cina teebibine jäämugetnemusi, ingle teepi gawecewe me lica gemi epu pana, cane lipu ai gawecewe me lica gäne. ");
INSERT INTO bon_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cane lica naawejanenine maane teebibine äsecrerame ai gawecewe cabu ca, yepä cane naawejanenine maane teebibine awecetnärame Satani te oomlana wälu pi. ");
INSERT INTO bon_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Teepi ai gawecewe me lica gemi cane liiyepu. ");
INSERT INTO bon_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Määme mene ca lui toraca gyene, maane teebibine mara me jewenemepi määme tääpume. ");
INSERT INTO bon_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Maane cebine lipu itu nätyepujite ai gawecewe cabu me, cane cuta piiyepu teebibine ituge ätyepa ai gawecewe cabu me. ");
INSERT INTO bon_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cane temiji pi cäme ireclota ecitenine määme ime cabu naace tääpume teepi cuta toracarage mara me äbitame määme tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Cane ai abiberäja bägrä bime tääpume taatu irecu lica ätumutenine, yepä cane cuta irecu ätumutenine eei bime tääpume, lui cina cebine pa nätrungepesi teeme aitneja name pi. ");
INSERT INTO bon_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cane irecu ätumutenine naace tääpume teepi yepä me äbitame epu pana maane Babe te lipu cäme cabu, cuta cane liiyepu määme cabu. Cane irecu ätumutenine, egä teepi cuta mine cama yepä me äbitame naace tääpume ai gawecewe muleyame biname cina piba ätrungame, egä maane te nätyepujite cebine. ");
INSERT INTO bon_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cane teebibine yepä jamyacu apaclyera ituge ceera, maane lui näcärujite cebine, naace tääpume teepi yepä me äbitame mine lipu yepä gegi. ");
INSERT INTO bon_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cane teeme cabu pisi näne, maane cäme cabu pisi näte teepi piba toraca yepä äbitame. Siige piba ai gawecewe muleyame biname cina umle äbitininisi, egä maane te itu nätyepujite cebine piiyepu maane te singi ituge teeme tääpume, maane lipu singi ituge cäme tääpume. ");
INSERT INTO bon_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Babe, maane cebine ai abiberäja bägrä itu näcärepete, siige cane singi gäne teepi cane cama lenajame, cane luma pagege lenaja, cuta cane singi gäne teepi päpäname jamyacu apaclyera ne, maane lui cebine ituge ceera, ingle maane niinäce singi ituge cäme tääpume, ingwe ca ai gawecewe ne jewenujite. ");
INSERT INTO bon_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Conocäco Babe, ai gawecewe muleyame biname cina umle lica gemi maane, yepä cane umle gäne maane piiyepu ai cina umle gemi, egä maane te cebine itu nätyepujite. ");
INSERT INTO bon_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cane meebine ituge awabudnita teeme bau me, cuta cerämu naawabudnäjinine naace name pi, egä määme lui singi pisi nyene cäme tääpume teeme cabu cuta lenajame cuta cane teeme cabu lenajame.” ");
INSERT INTO bon_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ai irecu ätumuta mene ingwe gaabe ca Yeesu piba ädige teeme abiberäja bägrä cama, siige teepi Kidrona calame ne yuurisi. Calame nuuja poto doro ca puga ge calwacupi cewe. Yeesu abiberäja bägrä cama piiyeme ädige. ");
INSERT INTO bon_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Teeme budre me awaba biname Yuuda, tabe cuta umle ge pui cewe, ingle Yeesu teeme abiberäja bägrä cama bucurage gääbu labasecretnininusi puma. ");
INSERT INTO bon_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Puma cita ca Yuuda tädige pui calwacupi cabu me. Modamoda iiwäreja biname piiyepu Parisea sigu biname cina teta cama jityepimisi yepä sange cubu biname bine piiyepu poto iiwäreja mete awamuta biname bine. Teepi lampa piiyepu ngale bine ewadimisi. Teeme cuta cubu gwidape puga ge. ");
INSERT INTO bon_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeesu umle ge ngena te äbitenige teeme tääpume, peei name pi tabe niinäce gaabe me awetäntige, jejemige egä, “Weene laati ne jirngeniye?” ");
INSERT INTO bon_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Teepi jejisi egä, “Cine Yeesu Nasareta cewe biname ne jirngenisi.” Yeesu jejemige egä, “Cane age säne.” Pui biname bime sobe cabu cuta Yuuda puga ge, Yeesu ne budre tääpume awabayame biname te. ");
INSERT INTO bon_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yeesu liba apu jejemige egä, “Cane age säne,” teepi ingwe gaabe me äsinininisi, siige itrametne-malemige gawe cabu me. ");
INSERT INTO bon_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu cääri itemlimige egä, “Weene laati ne jirngeniye?” Teepi jejisi egä, “Cine Yeesu Nasareta cewe biname ne jirngenisi.” ");
INSERT INTO bon_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeesu jejemige egä, “Cane nata uja bii jijinine, egä cane age säne. Yoo, weene liba cebine närngeniye, weene ire taatu jicranemeye ai cina otnime.” ");
INSERT INTO bon_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Apu toraca me bäbitige teeme niinäce gaabe mene te egä, “Cane nuuja ne lica ituge apesera, maane lui ituge cebine ceera.” ");
INSERT INTO bon_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Peteru me cubu turikä puga ge, siige tabe sisatige, jeläcnutige yepä biname me camu poto tablame ne iyeta. Tabe lui iiwäreja mope biname me kaakesea bägrä, ngii Malkus tage. ");
INSERT INTO bon_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yepä Yeesu Peteru ne jejige egä, “Isinglanti cubu turikä ne siiti bora me. Nää, maane apu naangenenige, egä cane singi gäne uucraname ai mäpu cabu ca, cäme Babe te lui mäpu cebine ituge ceera?” ");
INSERT INTO bon_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Cubu biname, teeme mope biname piiyepu iiwäreja mete awamuta biname, teepi Yeesu ne joomlisi, seea ca jetäyisi, ");
INSERT INTO bon_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","siige ecanisi Anas bau me. Anas lui sasa mope iiwäreja biname ge, Kayapa me gite ge. Kayapa tage pui kämäge cabu iiwäreja mope biname. ");
INSERT INTO bon_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tabe peese nyene biname, lui te Israela biname bine jejemige egä, “Ai lui miiji gyene yepä biname te budre äbitame iyeta biname bime tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Peteru piiyepu nuuja abiberäja bägrä, teepi Yeesu ne ingwe icwäsi. Iiwäreja mope biname te umle ge pui nuuja abiberäja bägrä, peei name pi tabe Yeesu cama abacitige iiwäreja mope biname me mete caale ngalebora me. ");
INSERT INTO bon_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peteru caale kaake poto ca imyemutige. Puma cita ca pui nuuja abiberäja bägrä, iiwäreja mope biname te lui poto cidi me umle ge, tabe tacnenutige, grana ire atwi ngulebägrä ne jojige, siige Peteru ne sisinglantige caale ngalebora me. ");
INSERT INTO bon_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Puma cita ca pui grana ire atwi ngulebägrä te Peteru ne itemlige egä, “Nää, maane pui biname me abiberäja bägrä yepä gäte?” Peteru jojige egä, “Eewe, cane lica.” ");
INSERT INTO bon_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pui lui gäbu padare ge. Kaakesea bägrä piiyepu iiwäreja mete awamuta biname cina uliobo yuungisi, siige gäbu jemajimige. Peteru cuta puga ge teeme sobe cabu gäbu jemajige. ");
INSERT INTO bon_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Iiwäreja mope biname te Yeesu ne itemläjige teeme abiberäja bägrä poto cidi me piiyepu teeme abiberäja mene poto cidi me. ");
INSERT INTO bon_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu teebine jejige egä, “Cane pajecurage biname bine jaajananemune piiyepu yaabiberäjimune abasecretna mete cabu ta piiyepu iiwäreja mete cabu, iyeta Israela biname cina liiyeme labasecretnaninusi. Cane nuuja mene ogä lica ituge iicana. ");
INSERT INTO bon_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Peei name pi maane ngeno me cebine nätemlite? Pui bine itemlimi, lui cina yäätecijanimuge, cane ngena ituge jajanena. Teepi umle gemi, cane ngena ituge iicema.” ");
INSERT INTO bon_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yeesu ai mene liba jiicige, yepä awamuta biname lui tage teeme gome, ime ca maapace gome yoororige, jejige egä, “Iiwäreja mope biname gyene tabe. Maane lipulipu mene jejite teebine!” ");
INSERT INTO bon_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu jejige egä, “Cane liba niiyaniya jiicine, nawabudniti, ngena gyene niiya. Yepä cane liba conocäco jiicine, maane piba ngeno me cebine noororite?” ");
INSERT INTO bon_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Piba Anas Yeesu ne ätäyäneji jityepige iiwäreja mope biname Kayapa bau me. ");
INSERT INTO bon_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Peteru camu aclajuteji ge puga uliobo gome, gäbu jemajige. Lui biname cina aclajuteji ge teta cama, jejisi egä, “Nää, maane age säte nuuja teeme abiberäja bägrä?” Yepä tabe jeinige, jejemige egä, “Eewe, cane lica.” ");
INSERT INTO bon_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iiwäreja mope biname me kaakesea biname bime yepä te, pui me ingle biname Peteru lui me tablame jeläcnutige, tabe Peteru ne itemlige egä, “Cije cane meebine lica nääpänine teta cama calwacupi je?” ");
INSERT INTO bon_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peteru cääri jeinige, siige piba taatu paulo te ala sengenige. ");
INSERT INTO bon_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yeesu ne iiwäreja mope biname Kayapa me mete cabu ca isatisi, Rooma gabmani babo biname ngii Pilato bau me ecanisi. Pui lui krokerage ge. Israela biname cina lica ebäcnisi Pilato me mete cabu me, ingle teeme tääpume cude gyene äsuplengta deedei loolo, teepi liba yääbäcnusi biname me mete cabu me, lui Israela biname lica ge. ");
INSERT INTO bon_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Siige Pilato asatige mete cabu ca teeme bau me, itemlimige egä, “Weene ai biname ne ngeno me secaniye cäme bau me? Tabe ngena niiya ne ituge wawena?” ");
INSERT INTO bon_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Teepi jejisi egä, “Tabe liga conocäco cirege, cine piba määme bau me lica cire saacanejisi.” ");
INSERT INTO bon_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato jejemige egä, “Yoo siige, weene ecaneye, weemämu eblawäjepeye weeme cotre ibi.” Israela biname cina Pilato ne jejisi egä, “Cime conocäco lica gyene biname ne budre me acitame.” ");
INSERT INTO bon_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ai te naace tääpume äbitige Yeesu me niinäce gaabe mene teeme budre gaabe poto cidi me toraca me äbitame. ");
INSERT INTO bon_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Piba Pilato acnenutige teeme mete cabu me, Yeesu ne ala tesoglicige teeme bau me otnime, siige itemlige egä, “Nää, maane Israela biname bime mope biname gäte?” ");
INSERT INTO bon_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeesu jejige egä, “Maane nää määme ngene atwanena mene jiicite, coo nuuja cina bii naajisi meebine?” ");
INSERT INTO bon_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato jejige egä, “Ebägä cane Israela biname gäne. Peei lui weemerage biname piiyepu teeme modamoda iiwäreja biname, lui cina naacanisi meebine cäme bau me. Maane ngena niiya ne itu tewenumete?” ");
INSERT INTO bon_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu jejige Pilato ne egä, “Cane ai gawecewe mope biname bime pana lica gäne. Cane liga teeme pana cirege, cäme kaakesea bägrä cina cire larnginejisi, cebine lica cire nabmalejisi Israela biname bime ime cabu. Yepä cane ai gawecewe mope biname bime pana lica gäne.” ");
INSERT INTO bon_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piba Pilato Yeesu ne itemlige egä, “Nää siige toraca gyene, egä maane mope biname gäte?” Yeesu jejige egä, “Maane nata peega bii najite egä, ‘Maane mope biname gäte’. Cane aplimlujine piiyepu ai gawecewe cabu me naace tääpume tädujine biname bine jajanename, egä ngena gyene toraca. Laatibi toraca mene ibi yaacrajuge, teepi nätecijusi cebine.” ");
INSERT INTO bon_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato Yeesu ne jejige egä, “Ngena gyene toraca?” Puma cita ca Pilato asatige mete cabu ca biname bime bau me, jejemige egä, “Cane nuuja ingle ne lica jepänine teebine budre me atraname. ");
INSERT INTO bon_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yepä ai lui mule gyene egä cane äsuplengta soriyomu padare cabu yepä biname ne asatame krokeciiye mete cabu ca weeme tääpume. Weene nää singi gemi cane Israela biname bime mope biname ne asatame?” ");
INSERT INTO bon_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Biname cina ala abayaninisi egä, “Eewe, tabe lica! Cine singi maane Baraba ne asatame!” Baraba lui cubucubu biname ge. ");
INSERT INTO bon_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Piba Pilato jejemige Yeesu ne acaname adnana tääpume. ");
INSERT INTO bon_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cubu biname cina pägepäge seeasea ne jemlemaltisi, teeme mope cabu ecitisi krauni tääpume piiyepu ciriyäciriyä cäbletääpe ca esigreräjisi. Teepi ai ne ätutena pana jewenisi, egä tabe babo mope biname gyene. ");
INSERT INTO bon_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Piba teepi seclige teeme bau me, jewablisi egä, “Sebore Israela biname bime mope biname,” siige ime ca yoororisi. ");
INSERT INTO bon_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Puma cita ca Pilato cuta cääri asatige teeme mete cabu ca, biname bine puutucu je jejemige egä, “Weene ire! Cane teebine sisatenine weene päpäname, egä cane nuuja ingle ne lica jepänenine teebine atraname budre tääpume.” ");
INSERT INTO bon_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Puma cita ca Yeesu tasatige. Pägepäge seeasea puga ge teeme mope cabu piiyepu pui ciriyäciriyä cäbletääpe cama ge tabe. Pilato jejemige egä, “Jepäneye, age sena biname!” ");
INSERT INTO bon_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Liba modamoda iiwäreja biname piiyepu iiwäreja mete awamuta biname cina teebine jepänisi, teepi ala abayaninisi egä, “Baarge uli cabu jibyecreye! Baarge uli cabu jibyecreye!” Pilato teebibine jejemige egä, “Weene weemämu ecaneye teebine, baarge uli cabu jibyecreye. Cane nuuja ingle ne lica jepänenine teebine budre me acitame.” ");
INSERT INTO bon_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israela biname cina Pilato ne jejisi egä, “Cime cotre te jiicenige, egä tabe miiji budre äbita, ingle tabe itu tainanumi Acejiyame me Bägrä ca.” ");
INSERT INTO bon_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato liba itecijige ai mene, tabe baborage wälu äbitige, ");
INSERT INTO bon_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","abacitige mete bora me. Tabe puga Yeesu ne itemlige, “Maane luma cita ca gäte?” Yepä Yeesu bojäcu ge, nuuja mene lica jiicige. ");
INSERT INTO bon_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato jejige egä, “Nää, maane singi lica gäte cäme mene awecnistame? Cije maane umle lica gäte, egä cäme conocäco pisi nyene meebine asatame coo baarge uli cabu acitame?” ");
INSERT INTO bon_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu jejige egä, “Määme conocäco ebä lica cirege, Acejiyame te liba lica cire nääcäreji meebine, peei name pi laati te cebine nacitige määme ime cabu, teeme niiya lui baborage gyene.” ");
INSERT INTO bon_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato liba ai mene itecijige, tabe naabe liga äbitanige Yeesu ne asatame, yepä Israela biname cina ala abayaninisi egä, “Maane liba teebine sisatenite, maane Rooma gawe babo mope biname Siisa me biname lica gäte. Lui biname te lainuge mope biname ca, tabe Siisa ne yääcisärmutuge.” ");
INSERT INTO bon_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato liba itecijige biname cina apu ala abayena je, tabe puma cita ca Yeesu ne sisatige, ädige, adnatige emä, biname bine luma jaatranimusi. Pui puupu lui kula ca acwabäneji ge, peei name pi einenisi ‘Kula Puupu’ ca. Heberu mene ca lui egä ‘Gabata’. ");
INSERT INTO bon_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ai mule te äpletnutige bimu duusa poto cidi me, äsuplengta trii bimu me niinäce gaabe ca lui bimu ge. Pilato Israela biname bine jejemige egä, “Peese nyene weeme mope biname.” ");
INSERT INTO bon_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Teepi ala abayaninisi Pilato bau me egä, “Budre me egli, budre me egli! Baarge uli cabu jibyecreye!” Pilato teebibine itemlimige egä, “Cije weene singi gemi cane weeme mope biname ne baarge uli cabu me äbyecrame?” Modamoda iiwäreja biname cina jejisi egä, “Cime nuuja mope biname lica gyene, yepä Siisa sine!” ");
INSERT INTO bon_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Puma cita ca Pilato Yeesu ne ecitige teeme ime cabu teepi teebine baarge uli cabu acitame. Puma cita ca teepi Yeesu ne ecanisi. ");
INSERT INTO bon_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tabe teeme baarge uli ne teemämu ecanige. Teepi atyarige cewe me lui ne einenisi ‘Mopekaake Cewe’ ca, Heberu mene ca lui ‘Gologota’. ");
INSERT INTO bon_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Teepi puga teebine toto ca jibyecrisi baarge uli cabu. Neeneni biname bine cuta puga jääbyecrisi teeme gome, yepä lui nuuja poto ca cuta yepä lui nuuja poto ca, siige Yeesu teeme cole je. ");
INSERT INTO bon_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato jejemige oogärame egä, YEESU NASARETA CEWEYAME, ISRAELA BINAME BIME MOPE BINAME, siige pui mene äbyecrame baarge uli cabu Yeesu me mope gome. ");
INSERT INTO bon_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bucurage Israela biname cina ecnemisi pui mene bine, ingle lui puupu cabu jibyecrisi, cudecewe lica ge babo cewe gome ca. Pui mene lui oogäräneji ge Heberu mene ca, Latin mene ca, Griik mene ca. ");
INSERT INTO bon_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Modamoda iiwäreja biname cina jejisi Pilato ne, “Maane ngeno me yoogärite egä, ‘Israela biname bime mope biname.’ Maane cire yoogärejite egä ‘Ai biname te teemämu lainuge Israela biname bime mope biname ca.’” ");
INSERT INTO bon_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato jejemige egä, “Cane ngena bii byoogärine, pepu yaanajepi!” ");
INSERT INTO bon_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cubu biname cina liba Yeesu ne baarge uli cabu toto ca jibyecrisi, peei ingwe gaabe ca teepi teeme cäbletääpe bine jewadimisi, jebelanemisi, fooa tomi bine jewenimisi, ingle teepi fooa biname ge. Puga ge nuuja cäbletääpe, lui mucmucu ge, äswäräneji deedi lica ge, Yeesu lui asigräneji yaacananuge ngalebora ca. ");
INSERT INTO bon_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Teepi jiicisi egä, “Mine ai ne gone yäädericusi, yepä mine ngii cama kula bine yiisabäjenenemisi päpäname, egä laati te ecatenige.” Apu ibibi äbitige Oogäräneji mene te egä, “Teepi cäme cäbletääpe bine jebelanemisi, piiyepu bääclena äbäclaninisi cäme yepä cäbletääpe tääpume.” Yoo, cubu biname cina pepu jewenisi. ");
INSERT INTO bon_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yeesu me baarge uli gome jeclajutemige teeme mage, piiyepu teeme mage me maade, cuta Kloopa me coga Mariya piiyepu Mariya Magadala ceweyame magebi. ");
INSERT INTO bon_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yeesu liba jopänige teeme mage ne ämyemuteji teeme baarge uli gawe me pui abiberäja bägrä cama, tabe lui tääpume babo singi, siige tabe teeme mage ne piba jojige egä, “Yääye, ire määme bägrä peese nyene määme gome!” ");
INSERT INTO bon_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Piba tabe pui abiberäja bägrä ne jejige, “Ire, määme mage peeto nwene!” Peema cita ca pui abiberäja bägrä te ocanige Yeesu me mage ne teeme mete me lenajame. ");
INSERT INTO bon_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeesu umle ge, egä teeme kaakesea ne bepirige. Naace tääpume Oogäräneji mene te toraca me äbitame tabe jiicige egä, “Cane niiye mäne.” ");
INSERT INTO bon_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Caapocapo waina niiye puga ge. Puma cita ca yepä biname te waarpopale pana gwidape ne yiiglenutige pui waina niiye cabu me, cusopi suru ca jigadige, ewepäntige, Yeesu me tage cabu ecitige, ");
INSERT INTO bon_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","siige tabe enige. Piba ingwe ca tabe jiicige egä, “Iyeta cäme kaakesea bine siige biiri bepirimine.” Piba teeme mope te ergo ecirige, siige tabe budre äbitige. ");
INSERT INTO bon_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pui lui Israela biname bime Sabade amacetnäja bimu ge, peei name pi teepi eclige Pilato ne jajime, egä lipu gyene baarge uli cabu lui nesae biname bime pupuwace kaake bine acnapecame piiyepu budrekaake bine ätrungame. Teepi singi lica Sabade bimu te puma wawename budrekaake bine atacwäneji baarge uli cabu, ingle pui Sabade lui baborage bimu ge teeme tääpume. ");
INSERT INTO bon_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Puma cita ca cubu biname cina eclige, Yeesu cama lui neeneni biname bine jääbyecrisi, teepi teeme pupuwace kaake bine icnapimisi. ");
INSERT INTO bon_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Teepi liba seclige Yeesu bau me, teepi teebine jepänisi budre, peei name pi teeme pupuwace kaake bine lica ääcnäputisi. ");
INSERT INTO bon_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piba teeme yepä te kalaku ca jigadige teebine drawace gome. Pui dupe cabu ca uudi piiyepu niiye cina tapiräsi. ");
INSERT INTO bon_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yoo lui te ai ne jepänuji, tabe jeitnäjenige naace tääpume weene cuta piba ätrungame. Tabe ngena jeitnäjenige, toraca gyene. Tabe umle gyene, egä tabe toraca mene jiicenige. ");
INSERT INTO bon_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Peei cina äbitininisi ai Oogäräneji mene te ibibi äbitame egä, “Teeme nuuja kaake ne lica pagege ägäbuta.” ");
INSERT INTO bon_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cuta nuuja gome jiicenige egä, “Teepi teebine ire jetwenisi, kalaku ca lui ne drawace gome jigadisi.” ");
INSERT INTO bon_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ai ingwe gaabe ca yepä biname ngii Yoosepa, Arimatea cewe biname, te ädige Pilato bau me. Tabe cuta peese nyene yepä Yeesu me abiberäja bägrä. Yepä tabe cabucabu lica jitrungige, ingle tabe wälu ge Israela modamoda biname bime tääpume. Tabe Pilato ne itinärige Yeesu me budrekaake ne ätrungentame. Pilato teebine ‘yoo’ mene jejige, siige Yoosepa ädige Yeesu me budrekaake ne ätrungentame. ");
INSERT INTO bon_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yepä biname ngii Nikodemo, tabe peese nyene Yeesu ne lui te ciiye cabu yäädärepi, tabe cuta tädige piiyeme. Tabe secanige teeti kilo miijirage lengolengo ngängye, lui wawenäneji ge miira uli ngedo ca piiyepu aloe uli migi ca. ");
INSERT INTO bon_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Teepi Yeesu ne itrungentäsi, cäbletääpe bine ipyacemäsi pui ngängye ca, siige tope etnäsi. Israela biname cina apu jaawenimusi teeme budrekaake bine gape cabu acraname. ");
INSERT INTO bon_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pui puupu gome Yeesu ne luma baarge uli cabu ecitisi, calwacupi puga ge. Pui calwacupi cabu kula bora uureji ätruna cäco gape puga ge. ");
INSERT INTO bon_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ingle Sabade bimu me amacetnäja bimu ge, peei name pi teepi puma ecitisi, ingle pui gape lui teeme budre puupu mameta ge. ");
INSERT INTO bon_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande krokerage baani te liba seclitige, Mariya Magadala cewe magebi te piba oclige gape ängrärame, siige jepänige, egä baborage kula te apeträngteji gyene gape grana gome ca. ");
INSERT INTO bon_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Puma cita ca tabe uuwamenamena oclige Simona Peteru piiyepu pui nuuja abiberäja bägrä bau me, Yeesu lui tääpume baborage singi, siige jaajige egä, “Teepi mime Yageyame ne becatisi gape cabu ca. Cine umle lica gemi, teebine luma bii becitisi?” ");
INSERT INTO bon_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piba Peteru piiyepu pui nuuja abiberäja bägrä aaclige gape cabu me. ");
INSERT INTO bon_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Teepi niinäce yepä ibi uuwamäsi, yepä pui nuuja abiberäja bägrä te Peteru ne itucärige, siige niinäce atyaramtige gape gome me. ");
INSERT INTO bon_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tabe äcupige, apepmalige gape bora me, bulubulu cäbletääpe bine jepänimige, yepä tabe lica abacitige. ");
INSERT INTO bon_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Teeme ingwe ca Simona Peteru te tädige, siige gaabe ta abacitige gape bora me. Tabe jepänimige bulubulu cäbletääpe bine puma, Yeesu ne lui ca tope setnumesi, ");
INSERT INTO bon_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","cuta cäbletääpe ne jepänige, teeme mope ne lui ca tope setnumesi. Pui cäbletääpe lui mara gome enajige, lica poto cäbletääpe luma. Pepu tope enajige, Yeesu me mope ne lipu setnumesi. ");
INSERT INTO bon_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Piba pui nuuja abiberäja bägrä, lui te niinäce atyaramtige, tabe cuta abacitige. Tabe liba jepänige iyeta, siige tabe piba jitrungige. ");
INSERT INTO bon_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Teepi camu umle cäco aanajige, Oogäräneji mene te lipu jiicenige, egä tabe budre cabu ca cirege arpinenta. ");
INSERT INTO bon_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Puma cita ca abiberäja bägrä cina acnenutäsi mete me. ");
INSERT INTO bon_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya puga ge ele cama aclajuteji gape grana gome. Tabe liba ele cabu camu ge, tabe piba apepmalige gape cabu me, ");
INSERT INTO bon_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","neeneni Acejiyame me mename seemo bine jääpänige adnatäneji ge pui puupu cabu, Yeesu ne luma secitumesi. Teepi bulubulu cäbletääpe asigräreji ge. Nuuja te lui mopingle jage, nuuja te lui ernge gome jage, siige teepi Mariya ne jojäsi egä, ");
INSERT INTO bon_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","“Magebi, maane ngeno mäte ele?” Tabe jaajige egä, “Teepi cäme Yageyame ne becatisi. Cane umle lica gäne baa luma becitisi.” ");
INSERT INTO bon_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ai mene ingwe gaabe ca tabe atatrongtige, jepänige Yeesu ne aclajuteji, yepä tabe teebine opo lica ewatnige. ");
INSERT INTO bon_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeesu utemlige egä, “Magebi, maane ngeno mäte ele? Laati ne jirngenite?” Mariya apu jongige, egä calwacupi ire atwi biname ge, peei name pi tabe jejige egä, “Babo biname, maane liga Yageyame ne becatite, cebine naji, maane luma bii becitite, cane piba oclenine acatame.” ");
INSERT INTO bon_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeesu jojige teebine egä, “Mariya!” Piba Mariya cääri atatrongtige, teebine jejige Heberu mene ca egä, “Raboni.” Peei lui egä ‘Abiberäja biname.’ ");
INSERT INTO bon_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu Mariya ne jojige egä, “Gone cebine noomlute, ingle cane camu gäne cäro Babe bau me otni. Maane äte ocli cäme abiberäja bägrä bime bau me, jejemepi, egä cane ädenine teeme bau me, lui sine cäme Babe piiyepu teeme Babe, cäme Acejiyame piiyepu teeme Acejiyame.” ");
INSERT INTO bon_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Piba Mariya Magadala cewe magebi te oclige, teeme abiberäja bägrä bine jejemige egä, “Cane Yageyame ne bii jepänine,” piiyepu tabe jejemige Yeesu teebine ngena jojige. ");
INSERT INTO bon_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pui Sande mämleteca me abiberäja bägrä cina abasecretnige yepä mete cabu me, siige gaabe armeji ge Israela modamoda biname bime wälu name pi. Yeesu puma cita ca tädige, teeme cole je jeclajutige, jejemige egä, “Poode weene cama yaanajege!” ");
INSERT INTO bon_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ai mene iicema ingwe gaabe ca tabe teeme ime aaboclomtige teeme bau me cuta drawace ne eboclomtige. Abiberäja bägrä cina babo gege ge, teepi lipu Yageyame ne jepänisi. ");
INSERT INTO bon_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Piba Yeesu cääri jejemige egä, “Poode weene cama yaanajege! Cäme Babe te lipu cebine nätyepuji, cane pepu jityepininine weebibine.” ");
INSERT INTO bon_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Puma cita ca tabe buuwemope ne jipwälutige teeme bau me, jejemige egä, “Aceji Seemo ne ecateye! ");
INSERT INTO bon_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Weene liba biname ne jaajuye egä ‘Määme niiya mule äcisäjeji gemi,’ siige tabe kälyä läbituge. Yepä weene liba jaji cäco peei mene, tabe piba kälyä lica läbituge.” ");
INSERT INTO bon_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tooma, twelb abiberäja bägrä bime yepä, lui ne einenisi ‘Päädepäde’ ca, tabe poto abiberäja bägrä cama lica ge pui tomi cabu, Yeesu liba teeme bau me aboclomtige. ");
INSERT INTO bon_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teepi Tooma ne jejisi egä, “Cine Yageyame ne biiri jepänisi.” Tooma jejemige egä, “Cane ebä jitrungininine weebibine, cane liba toto dupe bine jääpänenine teeme ime cabu, piiyepu ime kukluta aacitenine piiyeme, cuta liba ime ecitenine teeme drawace cabu.” ");
INSERT INTO bon_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Seben bimu ingwe gaabe ca abiberäja bägrä cina cääri abasecretnige yepä mete me. Tooma cuta puga ge. Gaabe armeji ge, yepä Yeesu abacitige, jeclajutige teeme cole je, jejemige egä, “Poode weene cama yaanajege!” ");
INSERT INTO bon_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Puma cita ca tabe Tooma ne jejige egä, “Maane ire cäme ime cabu me! Määme ime kukluta taaciti ama cäme ime dupe cabu, cuta drawace cabu määme ime seciti. Gone ätrunga cäco naanajuge, yepä maane miiji ätrunga!” ");
INSERT INTO bon_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tooma Yeesu ne jejige, “Cäme Yageyame, cäme Acejiyame!” ");
INSERT INTO bon_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu teebine jejige egä, “Maane ätrunga gäte page, maane lipu näpänite cebine. Gege gemi eei biname, päpäna cäco je lui cina ätrunga.” ");
INSERT INTO bon_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu bucurage poto ciitaca mule bine jewenimige teeme abiberäja bägrä bime irewale je, yepä teepi oogäräneji lica gemi ai peba cabu. ");
INSERT INTO bon_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ai bine ituge oogäretnäja weene piba ätrungame, egä Yeesu lui Keriso sine, Acejiyame me Bägrä gyene, siige weene liba birige ätrunga, weene piba iyeteta ireclota ne jääpänuye. ");
INSERT INTO bon_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ai ingwe gaabe ca Yeesu teeme abiberäja bägrä bime bau me cääri aboclomtige Tiberiya sawa gome. Peei mule lui apu gyene: ");
INSERT INTO bon_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Peteru piiyepu Tooma, lui ne ‘Päädepäde’ ca einenisi, piiyepu Natanaela Kaana cewe biname Galilaya probins cabu ca piiyepu Jebedayo me bägrä neeneni, cuta nuuja abiberäja bägrä neeneni, iyeta teepi puga ge. ");
INSERT INTO bon_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Peteru poto bine jejemige egä, “Cane cibubade me lädene.” Teepi jejisi egä, “Cine cuta naclenige maane cama.” Piba teepi eclige, poo cabu me acetnärige, yepä pui ciiye cabu teepi nuuja cibu ne lica joomlisi. ");
INSERT INTO bon_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Krokerage bimu te liba tajarige, Yeesu niiye ligiligi jeclajutige, yepä abiberäja bägrä cina opo lica ewatnisi teebine. ");
INSERT INTO bon_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Piba tabe itemlimige egä, “Cäme binamewale, cibu bine weene lica bii joomlemiye?” Teepi jejisi egä, “Eewe, cime nuuja gwidape lica gyene.” ");
INSERT INTO bon_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tabe jejemige egä, “Weeme net ne ijareye poo camu poto cidi ca, piba weene cibu bine joomlenenemiye,” siige teepi net ne pui poto cidi me ijarisi piiyeme. Mäpu name pi teepi äblicäco ge net ne aswecla poo cabu me acenutame, ingle bucurage cibu bine joomlemige. ");
INSERT INTO bon_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Puma cita ca pui abiberäja bägrä, Yeesu lui tääpume babo singi ge, Peteru ne jejige egä, “Ai lui Yageyame sine.” Simona Peteru liba itecijige, egä Yageyame sine ai, tabe cäbletääpe ca amlemaltige, ingle tabe cäbletääpe bine iirecäneji ge, siige piba niiye cabu me uuplige doro atwangame. ");
INSERT INTO bon_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Poto abiberäja bägrä cina poo ne sewäcisi doro me, net ne cuta selädnisi teeme cibu cama, ingle teepi cudecewe lica ge doro cabu ca, yepä hanred miita pana padare ge doro oomlaname. ");
INSERT INTO bon_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Teepi liba poo cabu ca ärpige, teepi jepänisi egä cibu muye wiiryere cabu puga ge piiyepu buluduu cuta puga ge. ");
INSERT INTO bon_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu jejemige egä, “Sewademeye poto cibu, weene lui bine joomlemiye.” ");
INSERT INTO bon_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yoo, poo liba doro jage, Simona Peteru acenutige poo cabu me, net ne piba selädnige doro me bucurage modamoda cibu cama. Pui lui yepä hanred fiftitri cibu ge. Ngänuge puu bucurage cibu, yepä net te lica äderärige. ");
INSERT INTO bon_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu jejemige egä, “Naaclege deedei äbitame.” Abiberäja bägrä cina wälu ge ätemlame egä, “Maane laasi näte?” ingle teepi umle ge, egä ai lui Yageyame sine. ");
INSERT INTO bon_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Puma cita ca Yeesu ädige, buluduu sewadige, teebibine ecäranemige piiyepu cibu ecäranemige. ");
INSERT INTO bon_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ai lui Yeesu nesae me aboclomtige abiberäja bägrä bime bau me, tabe liba budre cabu ca arpinantige. ");
INSERT INTO bon_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Teepi liba deedei äbita siige, piba Yeesu Simona Peteru ne itemlige, “Simona Yoane me bägrä, määme singi cäme tääpume nää baborage gyene ai poto bime singi cabu ca?” Tabe jejige egä, “Yoo Yageyame! Maane umle gäte, egä cane singi gäne määme tääpume.” Yeesu teebine cuta jejige, “Maane cäme maamoi bine cängena engäremepi!” ");
INSERT INTO bon_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Puma cita ca tabe neeneni me itemlige egä, “Simona Yoane me bägrä, äi nää maane singi gäte cäme tääpume?” Peteru jejige, “Yoo Yageyame! Maane umle gäte, egä cane singi gäne määme tääpume.” Yeesu jejige, “Maane cäme maamoi bine ire natwemepi.” ");
INSERT INTO bon_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Puma cita ca tabe nesae gääbu me cuta itemlige egä, “Simona Yoane me bägrä, äi nää maane singi gäte cäme tääpume?” Peteru ngenecu mäpu me äbitige, ingle Yeesu lipu nesae gääbu teebine itemläjige yepä mene ca. Puma cita ca tabe Yeesu ne jejige egä, “Yageyame, maane umle gäte iyeta gwidape, cije maane umle gäte, egä cane singi gäne määme tääpume!” Yeesu jejige teebine, “Cäme maamoi bine engäremepi. ");
INSERT INTO bon_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cane toraca naajenine, maane liba mamye biname ge, maane lamacetnäjute, siige lädute maane liiyeme singi otnime. Yepä maane liba moda je cirege, maane ime cire uutepi, siige nuuja te cire naamacetnäjepi otnime, cire naacanepi, maane liiyeme singi lica gäte otnime.” ");
INSERT INTO bon_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ai iicema ca Yeesu eboclomtige Peteru lipulipu gaabe ca cirege budre päpäna Acejiyame me ngii ne awepentame. Piba Yeesu Peteru ne jejige egä, “Cebine ingwe näcwepi!” ");
INSERT INTO bon_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Puma cita ca Peteru atatrongtige ingwe gaabe me, pui nuuja abiberäja bägrä ne jepänige, Yeesu lui tääpume babo singi ge. Tabe peese nyene, lui te Yeesu cabu me läbyenutepi, teepi liba deedei äbita cabu jage, yäätemlepi egä, “Yageyame, laati te meebine naawabenige budre me?” ");
INSERT INTO bon_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yoo siige, Peteru liba teebine jepänige, tabe Yeesu ne jejige egä, “Yageyame, ai biname tääpume ngena te cire läbitepi?” ");
INSERT INTO bon_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu Peteru ne jejige egä, “Cane liba singi gäne tabe ama lenajame ngälu cane cire tacnenutepene, peei määme bau lica gyene. Maane cebine yepä ingwe näcwepi!” ");
INSERT INTO bon_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Siige mene te iyeta otnetnäjige eei biname bime cabu me, Yeesu ne lui cina jitrungenisi, egä ai abiberäja bägrä te lica budre cire läbitepi. Yepä Yeesu lica jiicige, egä tabe budre lica cire läbitepi, yepä tabe jiicige egä, “Cane liba singi gäne tabe ama lenajame ngälu cane cire tacnenutepene, peei määme bau lica gyene.” ");
INSERT INTO bon_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tabe sine pui abiberäja bägrä, lui te jeitnäjemige iyeta ai mule bine, cuta tabe te yoogäremige iyeta ai mene bine. Mine umle gemi, egä tabe ngena jiicemige, toraca gyene. ");
INSERT INTO bon_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeesu bucurage poto mule bine jewenimige. Iyeta peei bine liba oogära je yepäyepä, cane apu ngene jotwanenine, egä puupu ibi lica gyene ai gawecewe cabu iyeta peei peba bine acraname. Cäme mene ngälu peese nyene. ");
INSERT INTO bon_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yoo Teopilo, cane niinäce lui mene ne itu yogärepene, pui cabu puga ge mene Yeesu me kaakesea piiyepu abiberäja poto cidi me, teeme kaakesea me gije abacita cabu ca ");
INSERT INTO bon_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ngälu Acejiyame te teebine cabucewe me ecatuji. Yeesu camuge cabucewe me otni, tabe lui biname bine ituge jäjäcra teeme ätyepäneji biname me äbitame, teebibine bäärmi jegednemige Aceji Seemo me kokre ca. ");
INSERT INTO bon_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yoo, teeme budre ingwe ca, Yeesu lui footi bimu ngalebora bucurage padare cabu awabudnitanige teeme opo gaabe, pipu pi teepi toraca umle äbitininisi egä tabe lui ireclota ge. Teepi teebine jepänanisi, tabe mene teebibine jejananemige Acejiyame te lipu biname bine yaawademuge. ");
INSERT INTO bon_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tabe liba ten cama enajige, jejemige teebibine egä, “Gone saabmaluye Yerusalema ne, yepä puma jewagrijepeye Babe te lui ätityera poto cidi me umle ituge wawena, piiyepu cane lui poto cidi me jijipene. ");
INSERT INTO bon_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoo, Yoane niiye yaacituge biname bime cabu teeme niiya mule äcisejame, yepä nesae pana bimu ingwe ca Acejiyame pa yaacitepi Aceji Seemo weeme yepäyepä trupa cabu me. ");
INSERT INTO bon_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yeesu me ätyepäneji biname cina ten cama liba abasecretnige, teebine itemlisi egä, “Yageyame, nää maane ai padare cabu Israela biname cääri padare nicärininite cimyägämu ire atwime?” ");
INSERT INTO bon_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeesu teebibine jejemige egä, “Peei lui weeme cabu lica gyene umle äbitame Babe te lui bimu piiyepu lui padare ituge acrana, ingle iyeta mule lui teeme ime cabu temi. ");
INSERT INTO bon_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yepä, Aceji Seemo liba pa tädepi weeme yepäyepä trupa cabu me, weene piba kokre ne pa jepänepeye teeme bau ca, siige mene pa jiicemepeye cebine aitnejame Yerusalema cewe ngalebora, piiyepu iyeta Yuudea gawe cabu ta, Samariya gawe cabu ta, cuta piiyepu iyeta gawecewe cabu ta.” ");
INSERT INTO bon_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ai mene liba siige, Acejiyame te Yeesu ne ecatige cabu me teeme ätyepäneji biname bime opo gaabe je. Carbe te teebine piba icwabige teeme päpäna ca. ");
INSERT INTO bon_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yoo, tabe liba ädige cabu me, teepi ire ca ecanisi. Piba taatu neeneni biname bulubulu cäbletääpe cama tawabudnitäsi, jaaclajutige teeme gome, ");
INSERT INTO bon_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","jejemäsi egä, “Galilaya biname, weene ngena tääpume aclajuteji gemi ire cabu me? Peei Yeesu lui Acejiyame becatige weeme bau ca, tabe cire tacnenutepi yepä pana mule ca weene lipu jepäniye tabe otni cabu me.” ");
INSERT INTO bon_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Siige, piba Yeesu me ätyepäneji biname cina Olibi Uli podo cabu ca äcnärige Yerusalema me. Peei podo lui babo cewe mameta ge. ");
INSERT INTO bon_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Teepi liba atyarige babo cewe cabu me, yepä mete cabu puupu cabu me eclige, teepi luma icrajinige: Peteru, Yoane, Yakobu piiyepu Andrea, Pilipo piiyepu Tooma, Bartoloma piiyepu Matayo, Yakobu lui Alapeus me bägrä, Simona lui Kanana sigu biname ge, piiyepu Yuuda lui nuuja Yakobu me bägrä ge. ");
INSERT INTO bon_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Teepi jäje labasecretnuge yepä gome irecu ätumutame, cuta ten cama puga ge poto magebi piiyepu Yeesu me mage Mariya piiyepu Yeesu me iganewale. ");
INSERT INTO bon_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Poto bimu ingwe ca Yeesu bau me ätrunga biname cina abasecretnige, iyeta lui pama yepä hanred twenti biname ge. Puma cita ca Peteru abujängtige mene jajanename. Tabe jejemige egä, ");
INSERT INTO bon_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Cäme binamewale, Acejiyame me Oogäräneji Mene te ibibi bäbitige, Aceji Seemo lui mene jiicuji Daawida me tage cabu ca ciige ngena cire läbitepesi Yuuda poto cidi me, lui Yeesu ne jaawabepi cubuyame bau me. ");
INSERT INTO bon_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuuda mime tomi cabu ge, ingle Yeesu teebine itu ecatuji mime gigri kaakesea wawename.” ");
INSERT INTO bon_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yoo, Yuuda lui rarekaake ecatuji teeme niiya kaakesea tääpume, tabe peei ca yepä gawe ne jeletnuji. Puga pui gawe cabu tabe itramuji, camuge ipluji, came iyeta täsuji, siige budre äbituji. ");
INSERT INTO bon_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iyeta biname lui cina icrajuji Yerusalema cabu je, mene itecijemuji peei poto cidi me. Peei name pi teepi pui gawe ne teeme mene ca einujisi Akeladama ca, peei me aboclomta lui Uudi Gawe. ");
INSERT INTO bon_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Siige, Peteru puma cita ca jejemige egä, “Salamo uupera peba cabu mene pisi nyene Yuuda poto cidi me egä, ‘Teeme mete te kaake läbitege; nuuja te puma gone yaanajuge.’ Cuta nuuja mene egä: ‘Nuuja te teeme kaakesea puupu ne yaacatege.’ ");
INSERT INTO bon_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Siige, pepu pi miiji nuuja biname te mine cama abasuta mene iicaname Yeesu me arpinenta poto cidi me. Miiji yepä ne acata mime tomi cabu ca; yepä lui te mine cama waatnetnäjuge iyeta pui padare cabu, Yageyame Yeesu liba mine cama ge. Pui padare ne gije jebacituji, Yoane liba niiye ca äciseja mene jiicemuji; siige pui padare teeme ngälu gaabe gyene, Yeesu liba lädepi mime bau ca cabucewe me.” ");
INSERT INTO bon_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Teepi puma cita ca jaajisi neeneni rooriye bine ngii: Yoosepa lui ne yaainusi Barsaba ca, teeme nuuja ngii lui Yuustus sine. Tabe yepä biname gyene, cuta nuuja biname ngii lui Matiya sine. ");
INSERT INTO bon_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Teepi piba irecu ätumutinisi egä, “Yageyame, maane umle gäte iyeta biname bime ngene atwanena, peei name pi ai neeneni biname cabu ca niwabinini, maane lui ne ituge jaji. ");
INSERT INTO bon_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nää, maane singi laati te ai ätyepäneji biname me kaakesea pa yaacatege Yuuda lui ne itu saabmalepi, tabe liba budre täbitumi, niiyarage puupu cabu me tädumi?” ");
INSERT INTO bon_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yoo siige, teepi peei neeneni biname ngii bine yoogärisi matimati kula cabu. Matiya me kula te yuutrutige, siige teebine ecitisi pui lebin ätyepäneji biname cama abasutame. ");
INSERT INTO bon_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos bimu liba tädige, iyeta Yeesu bau me ätrunga biname cina abasecretnige yepä mete cabu me. ");
INSERT INTO bon_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Teepi piba taatu itecijemige babo mumwämu carbe cabu ca. Pui mumwämu lui babo kokre buuwe pana ge, mete iyeta ngalebora tabacitige teepi luma icrajige. ");
INSERT INTO bon_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Teepi puma cita ca jepänisi muye wädräji pana gwidape bine lui cina äpletnärige, otninisi iyeta biname bime mope papa cabu. ");
INSERT INTO bon_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aceji Seemo te abacitanige teeme yepäyepä trupa ngalebora iyeta poto cabu lenajame. Teepi mene maramara jiicemisi. Aceji Seemo te lui mene ecäremige, teepi papa jiicemisi. ");
INSERT INTO bon_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Puga ge Yerusalema je Israela biname lui cina itu saaclepi iyeta gawe maramara cabu ca. Teepi iyeta Acejiyame ne yaawejanusi. ");
INSERT INTO bon_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bucurage biname cina abasecretnige peei mene maramara liba itecijemige. Teepi iyeta ngenecu jelonecmige mene ätecijame, ingle Yeesu bau me ätrunga biname cina mene jiicemisi pui biname bime yepäyepä tagepogogo ca. ");
INSERT INTO bon_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Teepi mutäcäco äbitininisi, piba jiicemisi egä, “Lui biname cina mene jiicenenemisi, teepi iyeta Galilaya biname gemi! ");
INSERT INTO bon_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Peei lipu gyene egä mine teebibine jitecijenemisi mimerage cewe mene iicema cabu ca? ");
INSERT INTO bon_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mine Partiya gawe cabu ca, Mediya cabu ca, piiyepu Elama cabu ca; Mesopotamiya gawe cabu ca, Yuudea piiyepu Kapadokiya gawe cabu ca gemi; Pontus piiyepu Asiya cabu ca gemi; ");
INSERT INTO bon_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirugiya piiyepu Pampuliya cabu ca gemi; cuta piiyepu Aikupito cabu ca, piiyepu poto Libiya cewe cabu ca gemi, lui Kurene cewe mameta gyene. Poto mine lui Rooma cabu ca gemi; ");
INSERT INTO bon_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","cuta piiyepu pui tomi cabu ca poto lui Israela biname gemi, poto lui Israela biname lica gemi, yepä mine iyeta Israela biname bime mule jäätrungemusi; cuta piiyepu poto mine lui Krete curä cabu ca piiyepu Arabiya gawe cabu ca gemi; yepä mine iyeta jitecijemisi teepi mimerage mene maramara ca jiicetnäjemisi. Teeme mene lui peei babe miiji mule poto cidi me Acejiyame lui bine itu jaawenemepi.” ");
INSERT INTO bon_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yoo siige, biname cina mutäcäco äbitininisi piiyepu maramara ngene atwanena jepänemisi, piba teemeteme ätemläjinisi egä, “Ai ngena mule gyene?” ");
INSERT INTO bon_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yepä, poto cina ätrunga biname bine bääclena me jewenemisi, jiicemisi egä, “Ai biname lui sice buduma gemi!” ");
INSERT INTO bon_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peteru puma cita ca jeclajutige pui lebin ätyepäneji biname cama, piiyepu babo tage ca gije abacitige mene jajanename biname bine egä, “Israela biname piiyepu weene iyeta lui cina Yerusalema cabu je inajininige, cäme mene nätecijeye! Cane weebibine umle jiwenininine ai mule lui ngena tääpu myene. ");
INSERT INTO bon_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ai biname sice buduma lica gemi, weene lipu jiiceniniye, ingle bimu lui nain oklok kroke gyene. Peei lui sice nänäja padare lica gyene. ");
INSERT INTO bon_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yepä, ai mule lui eei tääpu myene Acejiyame me mename biname Yoele lipu itu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Acejiyame jiicige: Age sena mene cane ngena cire jaawenepene ceräcerägääbu padare cabu. Cane cäme Seemo ne cire yaacitepene iyeta biname bime trupa cabu. Weeme imäbägrä piiyepu ngulebägrä cina cäme tagepogogo mene cirege iicema; weeme mamye rooriye cina maramara mule bine wama pana cirege päpäna; piiyepu weeme moda cina wama bine cirege päpäna. ");
INSERT INTO bon_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yoo, cäme kaakesea biname, rooriye cuta magebi piiyepu, pui padare cabu cäme Seemo cane cire yaacitepene teeme yepäyepä trupa cabu. Teepi cuta piiyepu cäme tagepogogo mene cirege iicema. ");
INSERT INTO bon_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cane owowä gwidape cirege wawena dume cabu, piiyepu kokre mule gwidape cirege wawena gawe cabu. Uudi, muyemuye, piiyepu waaniwaniba kloka weene cirege päpäna; ");
INSERT INTO bon_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","bimu te cäsä me cirege äbita, cuta mabye te uudi pana uududi me cirege äbita. Iyeta ai mule cina niinäce cirege äbita, piba ingwe ca mime Yageyame me babo ceräcerägääbu bimu te cire tädepi. ");
INSERT INTO bon_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Siige, iyeta biname lui cina Yageyame me ngii yaawejanusi, tabe teebibine niiya cabu ca cire yääsecräremepi.’ Siige. ");
INSERT INTO bon_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israela biname, ai mene itecijinege! Acejiyame ciitaca mule, cälu täti gwidape, piiyepu owowä gwidape bine cängena jaawabäjemepi weeme opo gaabe; tabe pui bine Yeesu Nasaretayame cabu ca jaawenanemepi. Weene pui umle gemi, ingle weeme gome jaawenanemepi. Tabe pepu pi singi weebibine umle wawename egä Yeesu lui ätyepäneji ge teeme bau ca. ");
INSERT INTO bon_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Acejiyame teeme singi ca itu iyemaluji Yeesu ne weeme bau me ätyepame. Tabe pui padare umle ge ngena cirege äbita. Weene teebine piba budre me jaawenepeye, liba niiya mule biname bine giri jaacranemepeye teebine baarge uli cabu äbyecrame. ");
INSERT INTO bon_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yepä, Acejiyame teebine budre cabu ca yaarpinantepi, teeme budre mäpu cabu ca yääyeblingtepi, ingle naace gyene budre te teebine äblicäco cängena gawe me apremela. ");
INSERT INTO bon_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yoo, Daawida te mene jiicuji teeme poto cidi me egä, ‘Iyeta padare cane Yageyame ne jääpänune cäme niinäce gaabe je; cane niiya päpäna äblicäco gäne, ingle tabe iyeta padare cane cama gyene. ");
INSERT INTO bon_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Peei name pi cane ngenecu miiji gäne, piiyepu gege cama mene jiicune. Yoo, Acejiyame, cane budre cire läbitepene, yepä cane määme trämä papa nanajenige, ");
INSERT INTO bon_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ingle maane licarage cäme seemo ne cire nabmalepi biname bime cable cewe cabu je, cuta piiyepu lica cirege cäme trupa ne abmala gape cabu ocwäwame, cane lui määme miijirage kaakesea biname gäne. ");
INSERT INTO bon_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Maane ireclota gaabe itu nawabepete; piiyepu cane määme gome gege cama nanajenige.’” ");
INSERT INTO bon_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Siige, Peteru piba jejemige, “Cäme binamewale, lui mene mime kaakesaare Daawida poto cidi me, cane miiji weeme tääpume pajecu me wawena. Tabe budre ge, gape cabu ecitujisi; teeme gape pisi nyene ama mime gome. ");
INSERT INTO bon_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tabe Acejiyame me mename biname ge. Tabe umle ge Acejiyame lui mene teeme kokre ngii cama teebine ituge jaji egä, ‘Yepä määme kaakesaare cane mope biname ne cire jaawenepene maane liiyepu.’ ");
INSERT INTO bon_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Siige, Daawida ngene ca egluji Acejiyame ngena singi cirege wawena, peei name pi tabe mene jiicuji Keriso me arpinenta poto cidi me egä, ‘Acejiyame teebine lica ebmalige biname bime cable cewe cabu je; teeme trupa te lica gape cabu ocwäwige.’ ");
INSERT INTO bon_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Siige, ai mene lui Yeesu poto cidi me. Acejiyame teebine yaarpinantepi budre cabu ca. Cine iyeta teebine tepänanumesi ireclota ge. ");
INSERT INTO bon_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Acejiyame liba teebine yaarpinantepi, puupu teeme gome yääcärepi, piba teebine Aceji Seemo cuta yääcärepi, teeme Babe te lipu itu jejuji wawename. Yoo, page weene lui bine jepänemiye piiyepu lui maramara mene itecijenininige, peei iyeta lui Yeesu bau ca gyene. ");
INSERT INTO bon_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Siige, Daawida lica Yeesu pana äduji cabucewe me, yepä tabe apu mene jiicuji egä, ‘Yageyame te cäme Yageyame ne jejuji: Ama adnati cäme camu poto cidi ca, ");
INSERT INTO bon_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ngälu cane määme cubuyame bine määme ernge gawe me cire yaacranemepene.’ ");
INSERT INTO bon_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yoo, Israela biname iyeta, weene miiji cängena umle egä peese nyene pui Yeesu weene lui ne itu yaacitepeye baarge uli cabu. Acejiyame teebine itu jaawenepi Yageyame piiyepu Keriso.” ");
INSERT INTO bon_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Siige, biname cina Peteru me mene liba itecijemige, teepi mage ngenecu mäpu äbitininisi teeme conocono mule name pi. Teepi Peteru piiyepu nuuja ätyepäneji biname bine itemlemisi egä, “Binamewale, cine ngena ne miiji wawena?” ");
INSERT INTO bon_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peteru teebibine jejemige egä, “Atatrongärineye weeme niiyaniya mule cabu ca, piiyepu niiye ca äciseja ne ecateye Yeesu Keriso me ngii cabu. Piba Acejiyame te weebibine niiya cabu ca pa isecräripi, cuta teeme miijirage owecu gwidape pa täätyepepi weeme bau me, peei lui Aceji Seemo gyene. ");
INSERT INTO bon_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Peei mene Acejiyame bau ca lui weeme tääpume, piiyepu weeme bägrä, weeme saarewale tääpume, cuta piiyepu iyeta biname bime tääpume lui cina cudecewe cabu icrajenige, iyeta biname Acejiyame mime Yageyame lui bine cire taasoglecmepi teeme bau otnime.” ");
INSERT INTO bon_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peteru jegednemige peei bäärmi, piiyepu bucurage nuuja mene ca teebibine sewadanemige egä, “Täsecräripeye conocono mule cabu ca, ingle mäpu daremu te tädenige ai niiyarage biname bime bau me!” ");
INSERT INTO bon_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bucurage biname cina ätrunga ca ecatisi teeme mene ne, piiyepu niiye ca äciseja ne ecatisi Yeesu me ngii cabu. Pui yepä bimu cabu pama trii tausen biname cina ätrunga biname bime tomi cabu ebäcnisi. ");
INSERT INTO bon_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bucurage padare teepi singi ge Yeesu me ätyepäneji biname bime bau ca mene abiberäjame. Teepi labasecretnininusi mene abaitname, deedei gigri läbitininusi, piiyepu cuta Acejiyame bau gigri irecu lätumutinusi. ");
INSERT INTO bon_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Acejiyame me ätyepäneji biname cina bucurage ciitaca mule piiyepu kokre mule gwidape Acejiyame me kokre ca jaawenemusi. Biname iyeta mutäcäco läbitaninusi. ");
INSERT INTO bon_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iyeta lui cina Yeesu ne jitrungisi, teepi yepä gome labasecretnuge piiyepu teeme gwidape lui gigri. ");
INSERT INTO bon_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Teepi poto gwidape piiyepu gawe bine aletnename jaawenemusi, siige rarekaake jääpänemusi. Lui bime singi piti nemi, teeme tääpume jaabelanemusi. ");
INSERT INTO bon_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iyeta bimu teepi labasecretnuge Acejiyame me iiwäreja mete caale ngalebora, puma cita ca toraca gege cama yaacluge teeme mete me deedei gigri äbitame. ");
INSERT INTO bon_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Teepi eso yääcärusi egä, “Acejiyame lui babo miiji gyene!” Iyeta biname teeme ngenecu miiji ge pui ätrunga biname bime bau me. Iyeta bimu gaabegabe Yageyame Yeesu te biname bine yääbäcnanemuge teeme tomi cabu me, lui cina niiya cabu ca äsecräreji gemi. ");
INSERT INTO bon_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nuuja bimu Peteru Yoane naabi aaclige Acejiyame me iiwäreja mete me teeme mämle irecu ätumuta padare trii oklok. ");
INSERT INTO bon_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Puga ge iiwäreja mete caale cabu yepä grana, ngii Jamyacu. Cuta puga ge peei grana gaabe gome yepä rooriye lui me ernge niiyaniya ge. Tabe otnetneja äblicäco, ingle pepu ärngeji ge. Iyeta bimu gaabegabe biname cina teebine yaacananusi, peei grana gome yaabmalusi biname bine rarekaake tääpume ätineräjame, lui cina yääbäcnusi iiwäreja mete caale ngalebora me. ");
INSERT INTO bon_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tabe liba Peteru Yoane naabibine jääpänige abacita je, teebibine äätinäruji rarekaake tääpume. ");
INSERT INTO bon_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Teepi ire acitäsi teeme bau me, Peteru piba jejige, “Ire cime bau me!” ");
INSERT INTO bon_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tabe puma cita ca ire jaatwige teebibine, teemämu ngene jotwanige egä, “Teepi pama ceera me singi gegi.” ");
INSERT INTO bon_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peteru jejige, “Cäme rarekaake licarage gyene, yepä cäme lui pisi nyene, cane pa nääcärene: Yeesu Keriso Nasareta ceweyame me ngii cabu, cane meebine naajenine egä abujängti otnime!” ");
INSERT INTO bon_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tabe teeme camu poto ime ca joomlige, teebine ewejängtige. Piba taatu pui biname me ernge dugulace kokre äbitige. ");
INSERT INTO bon_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tabe piba abujängtige, jeclajutige teeme ernge ca, piba gije abacitige otnetnejame. Tabe ten cama iiwäreja mete caale ngalebora me abacitige. Tabe otnetnäjige, uuplatäjige, piiyepu Acejiyame ne ewepyeräjige. ");
INSERT INTO bon_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Biname cina teebine jepänisi otni je piiyepu Acejiyame ne awepyeräja je. ");
INSERT INTO bon_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Teepi liba umle äbitininisi egä pui ätineräja biname peese nyene, lui te ladnatuge iiwäreja mete caale grana ngii Jamyacu gome, teepi cälu te jitemige, lui miiji te tädige teeme bau me. ");
INSERT INTO bon_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pui ernge niiyaniya biname egäcäro Peteru Yoane naabibime ime joomlige, iyeta biname ngenecu aloneca cama tuuwametnige teeme bau me. Teepi iiwäreja mete caale ngalebora pui puupu cabu jage, lui ne ngii yaainusi “Solomona me Caagecage Toro Mete” ca. ");
INSERT INTO bon_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peteru te liba biname bine jepänemige, jejemige egä, “Israela biname, weene ngena name pi cälu te jitemige? Weene ngena tääpume cime bau me ire sinajininige? Nää, weene apu jinge-nininige egä cime kokre ca, coo cime miiji mule ca, ai biname ne otnetnejame jewenago? Licarage! ");
INSERT INTO bon_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Acejiyame peese nyene lui ne Abrahamo, Isacako, piiyepu Yakobu yaawejanusi; Acejiyame peese lui ne mime sasa kaakesaare cina yaawejanusi. Tabe te peei ne bii jewenige, teeme miiji kaakeseayame Yeesu ne jamyacu apaclyera ceerame. Yoo, weene Yeesu ne yääcärepeye Israela modamoda biname bime bau me, piiyepu teebine jäägyepeye Pilato me opo gaabe, ngänu gyene tabe itu ngene jwaatwanepi teebine asatame. ");
INSERT INTO bon_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yeesu lui mara conocäco biname gyene, yepä weene teebine jäägyepeye, Pilato ne jaajepeye cubucubu biname weebibine ceerame, lica Yeesu. ");
INSERT INTO bon_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Weene pepu pi teebine budre me jaawenepeye, lui te biname bine ireclota gaabe jaawabäjemuge, yepä Acejiyame teebine yaarpinatepi budre cabu ca. Cine ire arbi biname gemi peei poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Peei Yeesu me ngii te ai biname ne kokre becärige. Yoo ai biname weene lui ne jepäneniye piiyepu sasa umle gemi, teeme ernge dugulace kokre bäbitige teeme ätrunga ca Yeesu me ngii cabu. Yeesu bau ätrunga te teebine miiji bii jewenige weeme opo gaabe je. ");
INSERT INTO bon_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yoo cäme binamewale, cane umle gäne, weene liba Yeesu ne niiya jaawenepeye, weene umle lica gemi weene ngena jaawenepeye. Weeme modamoda biname piiyepu, teepi umle lica gemi. ");
INSERT INTO bon_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yepä, peei mule ca Acejiyame te teeme sasa mene ibibi itu jaawenepi. Sasa cabu ca iyeta teeme mename biname cina peei mene jaaitnäjusi egä teeme Keriso mage mäpu cire jääpänepi. ");
INSERT INTO bon_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yoo, ebmaleye page weeme niiyaniya ngene atwanena Yeesu poto cidi me, atatrongärineye Acejiyame bau me. Tabe piba weeme niiyaniya mule pa yääyeblengemepi. Peei jewenepeye, ");
INSERT INTO bon_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","piba ngenecu plowa pa tädepi Yageyame bau ca, piiyepu tabe cire täätyepepi Yeesu Keriso, lui ne ituge jaji weeme bau ätyepame. ");
INSERT INTO bon_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Page tabe miiji cabucewe je yaanajuge, ngälu pui padare te cire tädepi Acejiyame liba iyeta gwidape bine kirece me cire jaawenemepi. Ujarage Acejiyame te mene jiicuji peei poto cidi me, piiyepu teeme miiji mename biname cina jaaitnäjusi pui mene bine. ");
INSERT INTO bon_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moose jiicenige Oogäräneji Mene cabu egä, ‘Acejiyame weeme Yageyame te nuuja mename biname cire täätyepepi, cebine liiyepu itu nätyepuji. Tabe lui weeme biname cabu ca cirege otni. Weene iyeta teeme mene miiji jewenepeye. ");
INSERT INTO bon_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Laati te teeme mene lica yaacatuge, teebine yääyeblingtusi Acejiyame me biname bime bau ca iyeteta.’ ");
INSERT INTO bon_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iyeta mename biname, Samwela piiyepu iyeta teeme ingwe ca lui cina secluji, iyeta lui cina Acejiyame me tagepogogo mene jiicemusi, teepi mene jiicemujisi ngena cina täbitimesi ai padare cabu. ");
INSERT INTO bon_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Acejiyame me sasa mename biname cina jeitnujisi tabe ngena cire jaawenepi. Teeme pui mene lui weeme tääpu myene. Cuta piiyepu weeme tääpu myene ai nuuja mene, Acejiyame te weeme sasa kaakesaare bine lui ecäranemuji, tabe liba Abrahamo ne jejuji egä, ‘Cane iyeta biname bine ai gawecewe cabu je miiji cire jaawenemepene määme ingwe kaakesaare cabu ca.’ ");
INSERT INTO bon_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yoo, Acejiyame liba teeme kaakesea bägrä Yeesu ne yaarpinantepi, siige teebine tityepepi niinäce weeme bau me weebibine miiji ceerame, tabe liba weebibine iyeta pa itatrongäripi weeme niiya mule cabu ca.” ");
INSERT INTO bon_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peteru Yoane naabi liba mene jejemäsi biname bine, poto Acejiyame tääpume iiwäreja biname, piiyepu iiwäreja mete awamuta mope biname, cuta piiyepu poto Sadukea sigu biname, teepi iyeta piba atyarininisi. ");
INSERT INTO bon_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Teepi ngenecu niiya cama itecijemige Peteru naabi Yoane biname bine ebiberäjemäsi egä, “Yeesu lui budre cabu ca itu larpinantepi, peei name pi teeme kokre pisi nyene cuta biname bine budre cabu ca arpinerame.” ");
INSERT INTO bon_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yoo, pui biname cina singi lica teeme peei mene ätecijame, peei name pi Peteru Yoane naabibine joomlisi. Mämlerage ge, peei name pi krokeciiye mete bora me ääsinglantisi ngälu nuuja kroke. ");
INSERT INTO bon_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yepä, bucurage biname cina lui Peteru Yoane naabibime mene itecijemige, teepi peei mene jitrungisi, siige ätrunga biname cina bucurage äbitininisi, faib tausen joomlige. ");
INSERT INTO bon_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nuuja bimu cabu, poto Israela mope biname, nuuja modamoda biname, piiyepu cotre abiberäja biname cina yepä gome me abasecretnige Yerusalema cewe cabu je. ");
INSERT INTO bon_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Teepi mene ajananinisi iiwäreja babo biname Anas cama piiyepu Kayapa cama, Yoane piiyepu Aleksanda cama, cuta piiyepu Anas me poto ingle biname cama. ");
INSERT INTO bon_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Teepi piba Peteru Yoane naabibine taasoglicisi teeme opo gaabe je aclajutame, piba teebibine äätemlisi egä, “Weene peei biname ne lipu miiji tewenumeye? Nää, ngena kokre ca piiyepu laati me ngii cama tewenumeye?” ");
INSERT INTO bon_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Siige, Aceji Seemo te babo äbitige Peteru me trupa cabu. Tabe puma cita ca teebibine jejemige egä, “Mope biname piiyepu nuuja modamoda biname, ");
INSERT INTO bon_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","weene nää cibibine nitemleniye pui mule poto cidi me lui te täbitumi ernge niiyaniya biname tääpume? Nää, weene singi umle äbitame cine lipu tewenumago peei mule ne? ");
INSERT INTO bon_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Weene iyeta miiji umle äbita, piiyepu Israela biname iyeta miiji umle, egä Yeesu miji kokre te ai biname ne iyeta miiji me tewenumi, lui biname te aclajuteji gyene weeme opo gaabe je. Yeesu Keriso Nasareta ceweyame peese nyene, weene lui ne baarge uli cabu itu yaatecwamtepeye. Acejiyame teebine budre cabu ca itu yaarpinantepi. ");
INSERT INTO bon_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tabe peese nyene lui poto cidi me Oogäräneji mene te jiicenige egä, ‘Lui kula ne weene raranga biname cina jigyisi, baborage bäbitige iyeta nuuja cabu ca.’ ");
INSERT INTO bon_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Siige, Yeesu peese nyene lui taatu ibibi gyene biname bine niiya cabu ca äsecrerame. Ai gawecewe cabu Acejiyame te nuuja biname me ngii lica ituge ceera lui te ibibi gyene mibibine niiya cabu ca äsecrerame.” ");
INSERT INTO bon_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Siige, pui mutre biname cina mutäcäco äbitininisi Peteru naabibine Yoane päpäname egä teepi lui wälu umle cäco gegi, cuta umle äbitame egä teepi papa biname gegi, sukulu cäco. Teepi puma cita ca umle äbitininisi Peteru naabi Yoane Yeesu cama cuta waatnetnejäsi. ");
INSERT INTO bon_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yepä, teepi nuuja mene äblicäco ge iicana, ingle teepi ernge niiyaniya biname ne jepänisi Peteru Yoane cama aclajuteji ge, lui ne miiji me tewenumäsi. ");
INSERT INTO bon_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Siige, teepi Peteru Yoane naabibine jaajisi pui mutre biname tomi äyeblengame puutucu me asatame puma awagrijame. Puma cita ca teemeteme mene ajananinisi egä, ");
INSERT INTO bon_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Mine ngena ne jaawenesi ai neeneni biname poto cidi me? Iyeta biname Yerusalema cabu umle gemi egä teepi peei mara ciitaca mule ne tewenumäsi. Mine äblicäco peei ne aina. ");
INSERT INTO bon_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yepä, mine singi lica ai mene te otnetnejame, peei name pi mine miiji teebibine ablawejame egä, ‘Ingwe ca gone Yeesu me ngii cabu nuuja biname ne mene jaji.’” ");
INSERT INTO bon_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Siige, teepi Peteru Yoane naabibine cääri taasoglecisi, jaajisi egä, “Gone Yeesu me ngii cabu mene jaajanemuye, coo biname bine yaabiberäjimuye!” ");
INSERT INTO bon_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yepä, Peteru naabi Yoane jejemäsi egä, “Weene weemämu atranineye egä Acejiyame me opo gaabe je lui gyene conocäco, nää weebibine ätrungame, coo Acejiyame ne ätrungame. ");
INSERT INTO bon_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Cine ngena ituge päpäna piiyepu ätecija, cine äblicäco bojä lenaja peei poto cidi me.” ");
INSERT INTO bon_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Puma cita ca pui mutre biname cina teebibine kokre mene cama aablawäjisi, siige jäätyepisi. Teepi äblicäco teebibine niiya cabu acita, ingle biname tääpume wälu ge. Biname iyeta Acejiyame me ngii ne ewepyeräjisi pui gwidape tääpume lui cina ituge äbita. ");
INSERT INTO bon_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lui biname te ciitaca mule cabu ca miiji me täbitumi, tabe footi kämäge cama senajumi piiyepu cerämu poto. ");
INSERT INTO bon_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peteru naabi Yoane liba tasatäsi, teepi acnenutäsi teeme ätrunga binamewale bime bau me, teebibine jeitnemäsi ngena mene modamoda iiwäreja biname piiyepu nuuja modamoda biname cina bii jaajisi teebibine. ");
INSERT INTO bon_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ätrunga biname cina teeme mene liba itecijemige, teepi iyeta irecu ätumutinisi Acejiyame bau me egä, “Yageyame, maane lui tewenemujite cabucewe, gawecewe, malu, piiyepu iyeta lui peei cabu temi, maane mene itu jejujite määme kaakesea biname, cime kaakesaare Daawida ne. ");
INSERT INTO bon_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tabe piba Aceji Seemo me ätityera ca peei mene jeitnuji apu egä, ‘Ngena name pi maramara gawe biname cina babo claabe gemi? Teepi ngena name pi gläämu bine papapa jewenemisi? ");
INSERT INTO bon_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gawe maramara mope biname cina cubu gwidape bine emacetnäjenemisi. Modamoda biname cina yepä gome abasecretnenige cubu agedname Yageyame piiyepu teeme jaji biname Keriso cama.’ ");
INSERT INTO bon_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Siige, ai mene te ibibi läbitepi Heroda piiyepu Pontiyo Pilato liba ai cewe ngalebora nuuja gawe biname piiyepu poto Israela biname cama labasecretnipesi määme conocäco kaakeseayame Yeesu ne äciseräjame, maane lui ne ituge jaji biname bine niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Teepi labasecretnepi iyeta määme singi wawename, maane lipu uja ngene jotwanujite Yeesu bau ngena te äbitame. ");
INSERT INTO bon_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yoo, Yageyame, cuta page maane mene bii näätecijige, teepi lipu opo cabu nirmäjininisi. Gone ätecija taatu, yepä maane määme kaakesea bägrä bine nitityäripi määme mene wälu cäco iicemame. ");
INSERT INTO bon_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Määme kokre niwabinini pita biname bine miiji me wawenecame, piiyepu owowä piiyepu ciitaca mule bine wawenecame Yeesu määme conocäco kaakeseayame me ngii cabu.” ");
INSERT INTO bon_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Teeme irecu ätumuta mene liba siige, piba taatu pui mete teepi luma tabasecretnige, peei te akocnäjige. Aceji Seemo te babo äbitige iyeta teeme yepäyepä trupa cabu. Teepi gije abacitinisi Acejiyame me mene wälu cäco iicemame. ");
INSERT INTO bon_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iyeta ätrunga biname teeme ngenecu piiyepu teeme singi lui yepä ge. Nuuja biname te lica jiicige egä, “Cäme gwidape lui cämi nemi,” yepä teepi iyeta teemeteme jebelanemisi. ");
INSERT INTO bon_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yeesu me ätyepäneji biname cina babo kokre cama ire jerbisi Yageyame Yeesu me arpinenta poto cidi me, piiyepu Acejiyame me baborage miiji ten cama ge. ");
INSERT INTO bon_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Teeme tomi cabu nuuja biname lica ge lui te singi cama enajige bimu gaabegabe gwidape tääpume. Laatibi yageyame ge gawe coo mete tääpume, teepi aletname jaawenimusi, aletna rarekaake saawecnemusi, ");
INSERT INTO bon_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","piba ätyepäneji biname bine yääcäremusi. Teepi peei rarekaake jaabelanemusi teeme yepäyepä laati bemi gwidape cäco. ");
INSERT INTO bon_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Biname ngii Yoosepa pepu jewenige. Tabe Leebi me ingle cabu ca ge; teeme aplimla puupu lui Kupro curä cabu. Ätyepäneji biname cina teebine yaainusi Banaba ca, peei me aboclomta lui kokre ne ceerayame biname ge. ");
INSERT INTO bon_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yoosepa poto gawe aletname jewenige, gawe aletnäneji rarekaake bine ewademige, puma cita ca ätyepäneji biname bime ime cabu icranemige. ");
INSERT INTO bon_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Yepä, puga ge rooriye ngii Ananiya lui teeme coga Sapira cama poto teeme gawe aletname jewenäsi. ");
INSERT INTO bon_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yepä, tabe poto aletnäneji rarekaake mara gome icranemige teeme tääpume, poto taatu ecäremige ätyepäneji biname bine, engletnäjemige egä, “Camle-camle daremu gyene ai pui gawe tääpume.” Teeme coga iyeta umle ge peei poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peteru rooriye ne jejige, “Ananiya, maane ngenome ire taatu jecitite Satani te meebine acaname. Maane angletneja mule bii jewenite Aceji Seemo bau me, maane liba poto gawe aletna rarekaake ne cumä tewenumete. ");
INSERT INTO bon_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pui gawe liba aletna cäco ge, määme yene piba, cuta peei gawe tääpume lui rarekaake sewademumete, määmi nemi iyeta. Peei name pi maane ngenome ngene totwananumete peei angletneja mene iicemame? Maane walya mene lica jiicite biname bau me, yepä maane Acejiyame bau me walya bii jiicite!” ");
INSERT INTO bon_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya liba peei mene itecijige, puirage padare cabu budre tama itramige. Siige, iyeta lui cina itecijemige peei poto cidi me, teepi mage wälu. ");
INSERT INTO bon_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mamye rooriye cina mete ne sebäcnisi, Ananiya me budrekaake ne etnisi, ecanisi, gape piba ecitisi. ");
INSERT INTO bon_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Matikolä padare ingwe gaabe ca, Sapira te peei mete me tabacitige, yepä tabe umle lica ge ngena te bäbitige teeme rooriye poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peteru teebine utemlige egä, “Cebine naji, nää ai rarekaake lui camlecamle daremu gyene, maane piiyepu määme rooriye lui secatumeye weeme gawe tääpume?” Tabe jejige egä, “Yoo, camlecamle daremu peese nyene.” ");
INSERT INTO bon_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Siige, Peteru jojige teebine, “Maane piiyepu määme rooriye weene ngenome mene tewenumeye Aceji Seemo ne walya mene ca apicnentame? Pui biname cina lui määme rooriye ne gape me becitisi, age tema mete grana gome, cuta meebine naasatenisi!” ");
INSERT INTO bon_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Piba taatu tabe utramige Peteru me ernge gome, siige budre äbitige. Pui mamye rooriye cina mete ne sebäcnisi, jopänisi budre, puma cita ca teebine usatisi, cuta gape ocitisi teeme rooriye gome. ");
INSERT INTO bon_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iyeta Yeesu bau ätrunga biname piiyepu iyeta nuuja biname lui ai mule poto cidi me itecijemige, teepi iyeta mage wälu äbitininisi. ");
INSERT INTO bon_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yeesu me ätyepäneji biname cina bucurage owowä mule piiyepu ciitaca mule bine jaawenemusi biname sobe cabu. Ätrunga biname iyeta yepä gome labasecretnuge iiwäreja mete caale ngalebora me, Solomona me Caagecage Toro Mete cabu je. ");
INSERT INTO bon_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nuuja laatibi ätrunga biname lica, teepi wälu ge ten cama abasecretname, ngänu gyene iyeta biname cina miiji mene taatu jiicusi teeme poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yepä bucurage magebi piiyepu rooriye cina mime Yageyame Yeesu ne jäätrungusi, piiyepu ätrunga biname bime tomi cabu ebäcnisi. ");
INSERT INTO bon_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ätyepäneji biname bime ätityera mule name pi, biname cina pita biname bine yaawademusi babo gaabe gome, waaku coo tiire cabu yaabmalemusi, ingle naace popi teepi singi Peteru me ceege teebibine awabame, tabe liba peei pita biname bine yääsuplingtemuge. ");
INSERT INTO bon_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bucurage biname lui yaacrajemuge Yerusalema mameta, cewe matimati cabu, teepi babo cewe me yääbäcnusi ätyepäneji biname bime bau me yaacluge, pita biname yaawademusi piiyepu poto biname lui niiya cable cama gemi. Siige, teepi iyeta miiji me läbitininusi. ");
INSERT INTO bon_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iiwäreja babo biname piiyepu iyeta lui cina ten cama ge, teepi iyeta lui Sadukea sigu biname ge. Teepi claabemete jepänanemisi, ingle biname cina babo singi ätyepäneji biname bime tääpume. Teepi peei claabe name pi mene jitranisi ätyepäneji biname bine niiya wawename. ");
INSERT INTO bon_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Teepi teebibine joomlemisi, babo cewe krokeciiye mete cabu me ebäcnemisi. ");
INSERT INTO bon_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yepä, mime Yageyame me mename seemo te peei ciiye cabu tädige, krokeciiye mete gaabe ne jiitnige, ätyepäneji biname bine pui mete cabu ca ewademige, teebibine piba jejemige egä, ");
INSERT INTO bon_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Weene biiri, naaclege iiwäreja mete me. Puma jiclajutipi, biname bine ebiberäjemepeye iyeta mene ai kirece ireclota poto cidi me.” ");
INSERT INTO bon_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ätyepäneji biname cina peei ne jewenisi. Bimu liba tacitige, teepi iiwäreja mete me ebäcnisi, gije abacitinisi biname bine abiberäjame. Pui iiwäreja babo biname piiyepu teeme binamewale tesoglecimisi iyeta Israela modamoda biname cina abasecretname mutre biname tomi tääpume. Teepi piba teeme ätityera biname bine krokeciiye mete me jityepemisi ätyepäneji biname bine teeme bau me waadename. ");
INSERT INTO bon_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yepä, pui biname cina liba atyarige, teepi lica krokeciiye mete cabu jepänemisi teebibine, peei name pi cuta äcnärige, abasecretna biname bime bau jeitnemisi egä, ");
INSERT INTO bon_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Cine liba krokeciiye mete me atyarinago, gaabe jepänisi armeji ge, iyeta awamuta biname gaabe bine jewamutemisi, yepä cine liba gaabe jiitnisi, mete ngalebora pui biname bine lica jepänemisi!” ");
INSERT INTO bon_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Modamoda iiwäreja biname piiyepu iiwäreja mete awamuta mope biname, teepi liba peei itecijemige, cälu te jitemige egä, “Baa, ngena te bäbitige? Lete nemi pui biname?” ");
INSERT INTO bon_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Puma cita ca yepä biname te tabacitige, teebibine jejemige egä, “Cäme mene nätecijeye! Peei rooriye weene lui bine krokeciiye mete me sebäcnimumeye, teepi iiwäreja mete cabu temi, biname bine puma ebiberäjenemisi!” ");
INSERT INTO bon_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pui awamuta mope biname te piba ädige teeme ätityera biname cama, ätyepäneji biname bine sewademisi, yepä teepi ime ca lica joomlemisi, ingle teepi wälu ge egä biname cina pama teebibine kula ca äbyecra mage, ai name pi teepi owecu gemi ätyepäneji biname bime tääpume. ");
INSERT INTO bon_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Teepi ätyepäneji biname bine ebäcnemisi mutre biname bime opo gaabe je aclajutame. Iiwäreja babo biname te piba teebibine jejemige egä, ");
INSERT INTO bon_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Cine weebibine uja itu jijanipago kokre mene ca egä, ‘Gone peei biname me ngii cabu yaabiberäjemuye,’ yepä weene cime mene lica ituge ätecija, siige iyeta biname bine Yerusalema ngalebora je ebiberäjanemiye, piiyepu weene singi cibibine aitna-me egä cine te Yeesu ne budre me itu yaacitepesi.” ");
INSERT INTO bon_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peteru piiyepu nuuja Acejiyame me ätyepäneji biname cina mene jewecnistisi egä, “Cine miiji Acejiyame me singi wawena, lica biname bime singi ne. ");
INSERT INTO bon_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Acejiyame peese nyene laati ne mime sasa kaakesaare cina yaawejanusi. Tabe te Yeesu ne budre cabu ca yaarpinantepi, weene liba teebine budre me itu yaacitepeye baarge uli cabu. ");
INSERT INTO bon_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Acejiyame teebine itu yaarpinantepi teeme camu poto me, teebine biname bine Waadena Biname piiyepu niiya cabu ca Äsecrera Biname me itu jaawenepi. Yoo, tabe singi Israela biname bine padare ceerame teeme niiya mule abmaläcemame piiyepu pui niiya cabu ca äsecrerame. ");
INSERT INTO bon_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Cine ire arbi biname gemi peei gwidape poto cidi me, cuta Aceji Seemo piiyepu, Acejiyame lui ne täätyepuge biname bime cabu me, laatibi teeme singi jaawenusi.” ");
INSERT INTO bon_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Siige, peei mutre biname cina ai mene liba itecijemige, teepi mage claabe ge, singi ge ätyepäneji biname bine budre me wawename. ");
INSERT INTO bon_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yepä, puga ge yepä Parisea biname teeme ngii Gamaliya. Tabe cotre abiberäja biname ge, lui te baborage ge iyeta biname bime ngene atwanena cabu. Tabe abujängtige pui mutre biname bime sobe cabu, jejemige egä ätyepäneji biname bine miiji äsime puutucu me. ");
INSERT INTO bon_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Siige, tabe piba mutre biname bine bäärmi jegednemige egä, “Cäme Israela binamewale, weene miiji cängena ngene jotwananineye weene singi peei biname poto cidi me ngena wawename. ");
INSERT INTO bon_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Weene ngene jepecneye biname ngii Tiyudas poto cidi me. Poto kämäge niinäce gaabe me tabe täduji, biname bine jejemuji egä, ‘Cane babo biname gäne.’ Pama fooa hanred rooriye cina ten cama abasutinujisi. Yepä, tabe budre jepänuji, teeme biname cina piba maramara äbitinininujisi, siige wata apiruji teeme sigu te. ");
INSERT INTO bon_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tiyudas me ingwe ca, biname bime ngii acnema padare cabu, Yuuda Galilaya ceweyame te piba täduji. Tabe cuta bucurage biname ewademuji ten cama otnetnejame, yepä tabe cuta budre jepänuji, siige teeme biname cina maramara äbitininujisi. ");
INSERT INTO bon_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yoo, peei name pi ai biname bime poto cidi me cane weebibine jijenininine, gone teebibine niiya jaawenemuye, yepä ebmalemepeye! Liba biname bau ca gyene teeme ngene atwanena piiyepu teeme waweneca, piba peei te papa me pagege äbita, ");
INSERT INTO bon_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yepä liba Acejiyame bau ca gyene, weene äblicäco teebibine iibana. Weene piba Acejiyame cama pa aglipeye!” Siige, mutre biname cina Gamaliya me mene jecatisi. ");
INSERT INTO bon_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Teepi tesoglecemisi ätyepäneji biname bine, teebibine etemeläjemisi, piba jejemisi, “Gone mene cääri jiicemuye Yeesu me ngii cabu,” siige teebibine jityepemisi. ");
INSERT INTO bon_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ätyepäneji biname cina peei mutre biname bine ebmalemisi gege cama, ingle naace popi Acejiyame ngene jotwanige egä teepi miiji ge Yeesu me ngii name pi mäpu päpäname. ");
INSERT INTO bon_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Iyeta bimu teepi iiwäreja mete cabu piiyepu biname bime mete maramara cabu mene jaajananemusi, biname bine yaabiberäjemusi Miiji Mene Yeesu Keriso poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ingwe ca Yeesu me ätrunga biname cina liba bucurage äbitininisi, Israela biname lui cina Griik mene jiicemusi, teepi jicnecimisi Heberu mene biname bine egä, “Teepi liba cuublacubla bine rarekaake yääcäranemusi, cime cuublacubla bine kupae lica jaawenemusi.” ");
INSERT INTO bon_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Puma cita ca pui twelb ätyepäneji biname cina tesoglecemisi iyeta ätrunga biname bine yepä gome abasecretna-me, jejemisi teebibine egä, “Miiji lica gyene cine liba Acejiyame me bäärmi mene jajanena kaakesea ne abmalame rarekaake ire atwi tääpume. ");
INSERT INTO bon_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Cime binamewale, peei name pi weeme cabu ca jejäcremeye seben rooriye bine, lui cina umle biname gemi, piiyepu Aceji Seemo ne cängena jäätrungusi, cuta piiyepu iyeta biname cina lui tääpume ngenecu miiji gemi. Cine teebibine rarekaake ire atwi kaakesea pa yääcäremepesi. ");
INSERT INTO bon_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Siige, cine piba iyeta padare irecu ätumuta piiyepu bäärmi kaakesea cabu pa lacranipago.” ");
INSERT INTO bon_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Siige, iyeta ätrunga biname singi ge pepu wawename. Teepi seben rooriye bine ngii jejäcremisi. Age temi teeme ngii: Setepano lui me ätrunga baborage ge piiyepu lui me trupa cabu Aceji Seemo te baborage ge, cuta Pilipo, Prokora, Nikano, Timona, Parmenas, piiyepu Nikolas lui Antiyoka ceweyame ge. Tabe Israela biname lica, yepä tabe Israela biname bime irecu ätumuta mule ne ituge acata. ");
INSERT INTO bon_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Siige, ätrunga biname cina teebibine ewademisi ätyepäneji biname bime bau me. Teepi irecu ätumutinisi piiyepu ime etacwe-misi peei seben biname bime papa cabu. ");
INSERT INTO bon_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Siige, Acejiyame me Miiji Mene te otnetnäjige iyeta poto ta. Yeesu bau ätrunga biname cina ablinisi Yerusalema ngalebora, cuta piiyepu bucurage Acejiyame tääpume iiwäreja biname cina peei Miiji Mene ne jitrungisi. ");
INSERT INTO bon_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Setepano lui te baborage ätityera piiyepu kokre jääpänuge Acejiyame bau ca, tabe ciitaca mule piiyepu owowä mule bine jaawenemuge Aceji Seemo me kokre ca biname bime opo gaabe je. ");
INSERT INTO bon_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yepä, poto biname cina Setepano cama mene abajininisi. Teepi lui Israela biname bime yepä abasecretna mete cabu ca, pui mete ngii yaainusi egä ‘abasecretna mete asatäneji biname bime tääpume.’ Puga ge pui abasecretna cabu Israela biname lui Kurene piiyepu Aleksandriya cewe cabu ca gemi, piiyepu poto nuuja Israela biname Kilikiya piiyepu Asiya Probins cabu ca. Teepi iyeta gije abacitininisi Setepano cama mene abajame. ");
INSERT INTO bon_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yepä, Aceji Seemo te Setepano ne babo umle ecärige. Peei umle cama tabe liba mene jiicemuge, teepi äblicäco daremu mene iicana. ");
INSERT INTO bon_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Teepi peei name pi poto biname bine ogä rarekaake ecäremisi walya mene jajime. Teepi apu jiicisi egä, “Cine Setepano ne jitecijisi, tabe Moose me cotre mene bine jiseblecäjemige, cuta piiyepu Acejiyame ne jiseblecäjige.” ");
INSERT INTO bon_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pepu pana teepi ngenecu alonecame jewenemisi biname bine, piiyepu modamoda biname, cuta piiyepu cotre abiberäja biname. Teepi Setepano ne joomlisi, ecanisi mutre biname bime opo gaabe me. ");
INSERT INTO bon_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Teepi piba poto biname bine ebäcnemisi walya mene iicaname Setepano poto cidi me. Pui cina jejemisi egä, “Ai biname te jääseblecäjemuge ai cudege iiwäreja mete poto cidi me piiyepu Moose me cotre mene poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cine ituge ätecija tabe jaji je egä Yeesu pui Nasareta ceweyame te ai iiwäreja mete ne pagege iibyageca, piiyepu mime sasa mule lui Moose bau ca gyene, peei ne mara me pagege wawena!” ");
INSERT INTO bon_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iyeta lui cina mutre biname tomi cabu adnatärenige, teepi ire jetwa-nanisi Setepano ne, jepänisi egä teeme opo lui mename seemo pana ge. ");
INSERT INTO bon_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iiwäreja babo biname te Setepano ne itemlige egä, “Nää, teeme mene toraca gyene määme poto cidi me?” ");
INSERT INTO bon_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Setepano jejemige egä, “Cäme babewale, binamewale, cäme mene nätecijeye! Ujarage mime kaakesaare Abrahamo liba camuge Harana cewe me otni, Acejiyame lui jamyacu apaclyera cama ge, tabe teemämu aboclomtuji Abrahamo bau. Pui padare tabe Mesopotamiya gawe cabu enajuji. ");
INSERT INTO bon_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Acejiyame teebine jejige egä, ‘Ebmalemi määme inglewale bine, piiyepu määme gawecewe ne ebmali, nuuja gawe cabu me ädi, cane lui gawe ne pagege awaba määme tääpume.’ ");
INSERT INTO bon_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Siige, Abrahamo piba ebmaluji Kaladea gawe ne, äduji Harana cewe me lenajame. Liba Abrahamo me babe budre äbituji, Acejiyame piba teebine jityepuji otnime ai Kanana gawe cabu me, weene page luma inajininige. ");
INSERT INTO bon_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yepä, pui padare Acejiyame te yepä gawe matikolä lica ecäruji Abrahamo ne teemerage gawe lenaja tääpume, yepä Acejiyame teebine mene jejuji gawe ceera teeme tääpume piiyepu teeme kaakesaare tääpume ingwe ca. Yoo, pui padare Acejiyame liba peei mene jejuji, Abrahamo bägrä cäco enajuji. ");
INSERT INTO bon_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Age Acejiyame me mene teeme bau me: ‘Määme ingwe kaakesaare cina cirege otni mage cudecewe me nuuja biname bime gawe cabu lenajame, puma mäpurage daremu cäco kaakesea cirege wawena. Teeme ireclota mäpu cirege fooa hanred kämäge cama. ");
INSERT INTO bon_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yepä, pui gawe biname lui bime tääpume teepi mäpurage kaakesea cire jaawenepesi, cane teebibine teeme mäpu daremu cirege ceera. Ingwe ca määme kaakesaare cirege äsecrera peei gawecewe cabu ca. Teepi cäme bau piba cirege awejena airage gawe cabu.’ ");
INSERT INTO bon_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Siige liba peei mene apiruji, Acejiyame piba Abrahamo ne jejuji teeme cewecu acitame teeme tääpe matikolä iirputa ca. Peei cewecu ca Abrahamo te Acejiyame me jajeji mene ecatuji teeme tääpume teeme biname me äbitame. Pui name pi Abrahamo, Isacako te liba aplimluji, teeme tääpe matikolä jiirputuji seben bimu teeme aplimla ingwe ca; piiyepu ingwerage Isacako teeme bägrä Yakobu me tääpe matikolä cuta jiirputuji. Yakobu me padare liba, tabe cuta teeme twelb imäbägrä bime tääpe matimati cuta jiirpeclimuji pui cewecu acitame. Pui twelb imäbägrä cina kaakesaare me äbitinininujisi mime twelb ingle lenajame. ");
INSERT INTO bon_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pui bägrä cina claabemete jepänujisi Yoosepa ne lui teeme yepä ge, siige teebine aletname ecanujisi daremu cäco kaakesea wawename Aikupito gawe cabu je. Yepä, Acejiyame puga ge ten cama, ");
INSERT INTO bon_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","teebine cängena isatuji iyeta teeme peei mäpu cabu ca. Yoosepa liba jeclajutuji Aikupito gawe Mopeyame Parao me opo gaabe je, Acejiyame te Parao ne ngenecu miiji jewenuji Yoosepa tääpume, piiyepu Yoosepa ne babo umle ecäruji. Parao piba Yoosepa ne ecituji Aikupito gawe piiyepu iyeta Parao me mete bine ire atwime. ");
INSERT INTO bon_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Gane padare piba täduji Aikupito piiyepu Kanana gawe cabu iyeta; biname cina mage loolo me cewe icrajuji. Mime kaakesaare licarage nuuja deedei bine jepänemujisi. ");
INSERT INTO bon_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Peei name pi Yakobu liba itecijuji egä deedei puga ge Aikupito je, tabe teeme bägräwale, lui gemi mime kaakesaare, teebibine jityepemuji teeme niinäce gaabe me piiyeme. ");
INSERT INTO bon_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ingwe ca teepi liba cääri äcnäruji, Yoosepa teeme naniganewale bime bau aboclomtuji. Parao pui padare cabu umle äbituji Yoosepa me ingle biname poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yoosepa piba mene jityepuji teeme babe Yakobu te otnime teeme inglewale cama Aikupito me. Teepi iyeta lui sebenti faib biname ge. ");
INSERT INTO bon_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Puma cita ca Yakobu äduji Aikupito me. Tabe puga ge budre, cuta teeme bägrä iyeta budre puga ge. ");
INSERT INTO bon_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ingwe ca teeme kaakesaare cina pui saarewale bime budrekaake ewademujisi Kanana gawe cabu me cewe ngii Sekem me, puga kaake bine gape jerbemujisi, lui gapecewe ne Abrahamo te rarekaake ca itu jeletnuji Hamora biname bime bau ca.” ");
INSERT INTO bon_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Setepano mene jiicemige egä, “Acejiyame me padare liba mameta ge atyaramta teeme jajeji mene toraca me äbitame, lui mene Abrahamo ne itu jejuji, mime biname cina piba Aikupito gawe cabu bucurage itu ablinujisi. ");
INSERT INTO bon_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pui padare cabu kirece mope biname te gije abacituji Aikupito gawe ne ire atwime; tabe umle lica ge Yoosepa poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pui mopeyame piiyepu teeme biname cina mime biname bine engletnäjemujisi, mime kaakesaare bime ireclota mäpu me jewenemujisi. Teepi teebibine giri jicranemujisi teeme engäbägrä bine puutucu abmalame budre äbitame. ");
INSERT INTO bon_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Siige, Moose pui padare cabu aplimluji; tabe jamyacu bägrä ge. Nesae mabye teeme mage babe cina teebine mete cabu ire jetwujäsi. ");
INSERT INTO bon_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Moose ne liba nuuja puupu cabu me imlitäsi, pui Parao me ngulebägrä te teebine esicrutuji, joomluji teeme bägrä tääpume. ");
INSERT INTO bon_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aikupito umleumle biname cina Moose ne ebiberäjujisi. Tabe babo me äbituji teeme mene piiyepu teeme waweneca cabu. ");
INSERT INTO bon_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moose liba footi kämäge joomluji, tabe ngene jotwananuji teeme Israela binamewale bine ädärame. ");
INSERT INTO bon_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tabe jepänuji Aikupito biname te yepä Israela biname ne egluji. Moose pui ne itityäruji, Aikupitoyame ne daremu jewecnistuji, budre tama egluji, siige. ");
INSERT INTO bon_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moose apu jengenuji egä teemerage Israela biname cina umle ge egä Acejiyame te teebine pa jaajepi teebibine äsecrerame teeme mäpu ireclota cabu ca, yepä Israela biname umle lica ge peei poto cidi me. ");
INSERT INTO bon_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nuuja bimu tabe jääpänuji neeneni Israela biname arngi cabu jage. Moose singi teeme claabe ne agawame, jaajuji egä, ‘Siige, weene yepä biname gegi. Weene ngenome weemämu arngeniye?’ ");
INSERT INTO bon_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yepä, lui te nuuja ne egluji, tabe Moose ne iyeblingäjuji, teebine itemluji egä, ‘Meebine laati te bii naajige cime ire atwi biname piiyepu ablaweja biname äbitame? ");
INSERT INTO bon_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wää, maane singi cebine agli mäte, maane lipu birice Aikupito biname yepä ne seglumete?’ ");
INSERT INTO bon_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Siige, Moose liba peei mene itecijuji, tabe Aikupito gawe cabu ca äyeblingtuji cudecewe me, siige Midiyan gawe cabu gije abacituji lenajame. Puga teeme coga te neeneni imäbägrä bine aaplimluji.” Setepano cerämu cuta jiicemige egä, ");
INSERT INTO bon_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Footi kämäge liba apirininujisi, Moose piba Sinai podo wajwa je daapo taatu gawe cabu enajuji, siige Acejiyame me mename seemo te teeme bau taboclomtuji. Uli te puga ayige, pui wädräji cabu peei mename seemo ne jepänuji. ");
INSERT INTO bon_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moose cälu te jituji peei uli ne liba jepänuji ayi je, äduji mameta me cängena ireme. Tabe piba Acejiyame me tagepogogo itecijuji egä, ");
INSERT INTO bon_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Cane Acejiyame säne, lui ne määme kaakesaare Abrahamo, Isacako, piiyepu Yakobu yaawejänusi.’ Moose me tääpe te wälu name pi jeclonuji, tabe wälu ge ireme. ");
INSERT INTO bon_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Acejiyame teebine jejuji, ‘Määme ernge gwidape yiirecimi, ingle maane aclajuteji gäte cude puupu cabu. ");
INSERT INTO bon_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yoo, cane jääpänemune cäme biname bime ireclota Aikupito je lui mage mäpurage ge. Cane teeme mäpu cabu cewe oocanena nätecijanuge; cane bii täinine teebibine mäpu cabu ca äsecrerame. Ayo, cane meebine Aikupito me pa näätyepene.’ ");
INSERT INTO bon_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Siige, Moose peese Israela biname cina lui ne itu jigyujisi, teebine jejujisi egä, ‘Laati te meebine naajige cibibine ire atwime piiyepu ablawejame?’ Yepä, Moose peese nyene lui ne Acejiyame te itu tityepuji Israela biname bine ire atwime piiyepu teebibine teeme mäpu ireclota cabu ca äsecrerame. Pui mename seemo lui te ayeji uli cabu taboclomtuji, tabe Moose ne itityäruji. ");
INSERT INTO bon_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moose peese nyene lui te biname bine ewademuji Aikupito gawe cabu ca. Footi kämäge cama tabe ciitaca gwidape bine jewenanemuji Aikupito ngalebora piiyepu Uududi Malu gome piiyepu pui daapo taatu cewe cabu. ");
INSERT INTO bon_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moose peese nyene lui te Israela biname bine jejemuji egä, ‘Acejiyame nuuja mename biname ne cire täätyepepi, tabe cebine liiyepu itu nätyepuji. Tabe weeme cabu ca yepä cirege.’ ");
INSERT INTO bon_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Siige, Moose peese nyene lui puga ge Israela biname cama pui daapo taatu cewe cabu je. Tabe puga ge mime sasa kaakesaare cama piiyepu pui mename seemo cama, lui teebine mene jejuji Sinai Podo cabu je. Tabe puga sewademuji Acejiyame miji ireclota mene mibibine jajanename. ");
INSERT INTO bon_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Yepä, mime kaakesaare cina äbwäricninujisi teeme mene ätecijame, siige Moose ne jigyujisi. Teepi singi ge cuta Aikupito me äcnärame. ");
INSERT INTO bon_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Peei name pi teepi Moose me naane Aarona ne jejujisi egä, ‘Mime uuje bine jewenemi mime niinäce gaabe otnime. Mine nuuja umle lica gemi ngena te itu täbitumi Moose tääpume podo cabu je, lui te mibibine Aikupito gawe cabu ca niwadipi.’ ");
INSERT INTO bon_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Teepi puma cita ca uuje ne jewenujisi awejename, teeme opo lui kau plongo pana ge. Teepi peei ne yiiwäräjujisi, babo deedei jewenujisi, lui teeme ime ca wawenäneji gwidape ge. ");
INSERT INTO bon_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Peei name pi Acejiyame te kaake ca icelyäremuji teebibine, ire ta jicranemuji teeme peei singi gaabe cabu otnime dume piiyepu wale bine iiwärejame. Mene pisi nyene Oogäräneji Mene cabu Acejiyame me mename biname bime bau ca egä, ‘Israela biname, peei lui cäme tääpume lica gyene weene lui footi kämäge cabu cibucibu gwidape yaaglecimuye, yiiwäräjemuye pui daapo taatu cewe cabu je. ");
INSERT INTO bon_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yepä, Moloko uuje tääpume weene cäbletääpe ca mete ne erangujiye, pui ne ecanujiye, cuta piiyepu weeme uuje Rapana, teeme ämyeji wale ne ecanujiye. Teepi lui ime ca wawenäneji gwidape ge iiwäreja tääpume. Cane peei name pi weebibine cudecewe me cirege ätyepa Babloniya nuuja poto me.’ ");
INSERT INTO bon_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Siige, mime kaakesaare bime iiwäreja mete puga ge pui daapo taatu cewe cabu je. Peei watata rarangäneji mete lui cäbletääpe ca wawenäneji ge. Peei lui Acejiyame me mete ge biname cama lenajame. Teepi peei ne cängena jewenujisi epu pana Acejiyame te Moose bau me lipu eboclomtuji mene taatu ca mete raranga tääpume. ");
INSERT INTO bon_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ingwe ca teepi peei mete teeme bägrä bine ecäremujisi. Teeme bägrä cina pui mete ne piba ecanujisi ten cama, teepi liba Yosuwa cama ecluji ai Kanana gawe bine waadename, Acejiyame te teeme niinäce gaabe ca liba iyecräjemuji maramara biname bine. Pui mete te ten cama enajuji ngälu Daawida me padare. ");
INSERT INTO bon_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yoo, Acejiyame ngenecu miiji ge Daawida tääpume. Tabe Acejiyame ne itemluji tabe te meterage wawename Acejiyame tääpume, lui ne iyeta mine Yakobu me kaakesaare cina yaawejanusi. ");
INSERT INTO bon_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yepä, Daawida me bägrä Solomona te peei mete ne eranganuji. ");
INSERT INTO bon_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yepä, Caburage Acejiyame tabe lica yaanajuge mete cabu lui ne biname cina yaarangusi, teeme mename biname te lipu jiicuji egä, ");
INSERT INTO bon_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Yageyame te jiicenige: cäme puupu gyene cabucewe je, cane biname bine puma cita ca ire pa taatwemepene. Gawecewe lui cäme ernge acita puupu gyene. Lipu mete ne weene singi cäme tääpume rarangame? Lese nyene puupu cäme lenajame? ");
INSERT INTO bon_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Cije cane iyeta gwidape cämämu lica jewenemujine?’” ");
INSERT INTO bon_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Siige, puma cita ca Setepano cuta jejemige egä, “Weene ätrunga cäco gemi. Weene ngene atwana Acejiyame bau lica gemi. Weene Acejiyame me mene ätecija cäco gemi. Weeme sasa kaakesaare liiyepu weene pepu gemi. Teepi lipu singi lica Aceji Seemo ne ätecijame, weene cuta piiyepu. ");
INSERT INTO bon_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wää, nuuja mename biname puga ge weeme kaakesaare cina lui ne niiya lica jaawenusi? Eewe, teepi niiya jaawenemusi iyeta mename biname bine! Teepi Acejiyame me mename biname bine budre me jaawenemusi lui cina mene jeitnäjujisi teeme Conocäco Kaakeseayame Yeesu me otni poto cidi me. Siige, ai padare weene walya mule ca teebine budre me itu yaaglepeye. ");
INSERT INTO bon_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Weene peete nemi lui cina Acejiyame me cotre mene ewademujiye, mename seemo cina lui cotre weebibine icärininujisi, yepä weene lica peei cotre bine jaawenemuye!” ");
INSERT INTO bon_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Siige, pui mutre biname cina liba Setepano me mene itecijemige, teepi claabemete jepänisi, giricu bine etebecmisi teeme claabe name pi. ");
INSERT INTO bon_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yepä, Aceji Seemo Setepano me trupa cabu baborage ge. Setepano cabu me ire acitige, Acejiyame me jamyacu apaclyera ne jepänige piiyepu Yeesu ne jepänige aclajuteji ge Acejiyame me camu poto ca. ");
INSERT INTO bon_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tabe jiicige, “Ire cabu me! Cane jepänenine dume äpäcuteji ge piiyepu teebine, lui Acejiyame bau ca täduji biname me äbituji, tabe aclajuteji ge Acejiyame me camu poto ime je!” ");
INSERT INTO bon_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Baborage ala cama pui mutre biname cina teeme tablame bine ime ca ermemisi, piba taatu Setepano bau me tuuwametnige, ");
INSERT INTO bon_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","teebine babo cewe cabu ca wata iyeblingtisi, kula ca jibyecrisi. Teepi teeme acwabeja cäbletääpe ebmalemisi yepä mamye biname gome je, teeme ngii Saulo. ");
INSERT INTO bon_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Teepi Setepano ne jäje jibyecranisi, siige tabe mime Yageyame ne jejige egä, “Yageyame Yeesu, nacati cäme seemo!” ");
INSERT INTO bon_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tabe kokorare ca ääpednutige, piba babo tage ca jejige egä, “Yageyame, gone ngene taapecnute teeme poto cidi me ai niiya mule ne.” Tabe ai mene jiicige, siige budre äbitige. ");
INSERT INTO bon_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Yoo, Saulo singi ge Setepano me budre tääpume. Puirage bimu cabu poto biname cina gije abacitinisi ätrunga ingle biname bime ireclota mäpurage wawename Yerusalema je. Teepi iyeta ätrunga biname bine iyecräjemisi, siige teepi uucratni-ge cewe maramara me Yuudea piiyepu Samariya probins ngalebora me. Ätyepäneji biname taatu icrajige Yerusalema je. ");
INSERT INTO bon_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Poto cängena ätrunga biname cina Setepano ne gape me ecitisi, mage ele ewäyisi. ");
INSERT INTO bon_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yepä, Saulo gije abacitige ätrunga biname bine äyeblengame. Tabe mete yepäyepä ngalebora abacitanige, ätrunga biname bine sisecreräjemige, siige magebi rooriye bine icranemige krokeciiye mete bora me. ");
INSERT INTO bon_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lui ätrunga biname bine iyecräjemisi, teepi otninisi cewe gaabegabe ta, Miiji Mene iyeta poto ta jejananemisi. ");
INSERT INTO bon_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipo ädige babo cewe Samariya me, puga biname bine umle jewenemige Keriso poto cidi me, lui te biname bine niiya cabu ca yääsecräremuge. ");
INSERT INTO bon_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bucurage biname tomitomi cabu teepi cängena itecijemige Pilipo ngena mene jejananemige. Teepi iyeta teeme mene jitecijanisi, piiyepu ciitaca mule bine jepänemisi, tabe lui bine jewenemige. ");
INSERT INTO bon_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Niiya cable cina mage ala cama äsinisi bucurage biname cabu ca; piiyepu biname lui bime ime ernge apineca cäco ge, piiyepu biname lui eepanepana otni, teepi miiji me äbitininisi. ");
INSERT INTO bon_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yoo, peei name pi baborage gege puga ge Samariya cewe cabu je. ");
INSERT INTO bon_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pui babo cewe cabu yepä biname ngii Simona te enajige. Mage padare cama tabe Samariya biname bine cälu te ätime jaawenemuge teeme piiseba mule ca. Tabe jiicemige egä tabe babo biname ge. ");
INSERT INTO bon_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Iyeta biname pui babo cewe Samariya cabu, matimati cabu ca ngälu modamoda me, teepi teeme mene jäätecijusi, jiicusi egä, “Tabe peese nyene biname lui Acejiyame me kokre cama gyene, lui ne yaainusi Babo Kokreyame ca.” ");
INSERT INTO bon_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lecaleca padare cama teeme piiseba mule name pi biname cina mutäcäco läbitininusi, peei name pi teeme mene jäätecijanusi. ");
INSERT INTO bon_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yepä, teepi liba Pilipo me mene jitecijisi, Miiji Mene Acejiyame te biname bine waadena poto cidi me piiyepu Yeesu Keriso poto cidi me, teepi piba niiye ca äciseja ne ecatisi, rooriye magebi iyeta. ");
INSERT INTO bon_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona cuta peei mene liba itecijige, teebine cuta niiye ca jicisäjisi Yeesu me ngii cabu. Peei ingwe gaabe ca, tabe Pilipo me mameta je enajige, piba cälu te jitige kokre mule gwidape piiyepu ciitaca mule bine liba jepänemige, Pilipo lui bine jaawenemuge Aceji Seemo me kokre ca. ");
INSERT INTO bon_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalema cabu lui ätyepäneji biname cina liba itecijemige egä Samariya biname cina itu yaacatepesi Acejiyame me mene ne, siige teepi piba Peteru Yoane naabibine jäätyepisi teeme bau me. ");
INSERT INTO bon_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Teepi liba atyaramtäsi, Acejiyame ne puma ewejenäsi pui ätrunga biname bime tääpume egä Aceji Seemo te pa labacitanege teeme yepäyepä trupa cabu me, ");
INSERT INTO bon_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ingle naace popi Aceji Seemo te camuge abacitana teeme nuuja biname cabu, yepä teepi niiye ca äciseja taatu itu yaacatepesi mime Yageyame Yeesu me ngii cabu. ");
INSERT INTO bon_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Puma cita ca Peteru naabi Yoane ime icranemäsi teeme papa cabu, siige Aceji Seemo te piba teeme yepäyepä trupa cabu abacitanige. ");
INSERT INTO bon_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simona liba jepänige egä Aceji Seemo te ätrunga biname bime trupa cabu babacitanige, ätyepäneji biname cina liba ime icranemäsi teeme papa cabu, tabe piba singi rarekaake ceerame Peteru Yoane naabibine, ");
INSERT INTO bon_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","jaajige teebibine egä, “Cuta cebine näcäreye peei kokre, egä cane lui biname cabu cäme ime laacitune, Aceji Seemo te piba labacituge teeme cabu me.” ");
INSERT INTO bon_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yepä, Peteru teebine jejige egä, “Maane äte, määme rarekaake cama ädi ngälu cäco niiya puupu me, ingle naace popi maane ngene bii jotwanite Acejiyame me owecu gwidape ne aletname rarekaake ca! ");
INSERT INTO bon_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maane äblicäco gäte cine cama gigri kaakesea wawename, ingle määme ngene atwana conocono gyene Acejiyame me opo gaabe. ");
INSERT INTO bon_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ebmali page ai niiya mule ne, Acejiyame ne ewejani määme niiya ngene atwanena poto cidi me. Tabe pama meebine kälyä pa naawenege. ");
INSERT INTO bon_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Cane nääpänenine egä maane niiya claabe gäte cime kokre poto cidi me. Määme niiya mule te meebine bii noomlige.” ");
INSERT INTO bon_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Puma cita ca Simona te Peteru Yoane naabibine jaajige egä, “Owecu, weene Yageyame ne ewejaneye cäme tääpume egä nuuja peei niiya gwidape te, weene lui poto cidi me bii najiye, lica pagege äbita cäme tääpume.” ");
INSERT INTO bon_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Siige, Peteru naabi Yoane Yeesu me ireclota poto cidi me liba jiicemäsi, piiyepu Yageyame me mene liba jejananemäsi, teepi peei ingwe ca acnenutäsi Yerusalema me. Cuta gaabe cabu liba aaclige, Miiji Mene jejananemäsi Samariya gawe biname yepäyepä cewe cabu ta. ");
INSERT INTO bon_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Acejiyame me mename seemo te Pilipo ne jejige, “Maane amacnepi, uule poto me ädi, ngälu gaabe cabu atyaramtepi, lui gaabe gyene Yerusalema ca Gaasa me.” Yoo, ai taje biname lica waatnetnäjinusi peei gaabe cabu. ");
INSERT INTO bon_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Siige, Pilipo amacetnäjige, abyemärige. Yepä Etiyopiya gawe ngii biname puga ge gaabe cabu teeme cewe otnime. Tabe lui rarekaake ire atwi mope biname ge magebi tääpume lui te Etiyopiya gawe ne ire jaatwuge. Tabe itu lädepi Yerusalema me Acejiyame ne iiwärejame; tabe tacne-nutenige cewe me teeme älädnalädna gwidape cabu. Gaabegabe liba tädige, tabe Oogäräneji Mene bine secnemige, Acejiyame me menameyame Isaya lui bine soogäruji. ");
INSERT INTO bon_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Aceji Seemo te Pilipo ne jejige egä, “Ädi älädnalädna gwidape gome me.” ");
INSERT INTO bon_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Puma cita ca Pilipo uuwamige Etiyopiya biname mameta me, teebine jitecijige Isaya me Oogäräneji Mene acnema cabu. Tabe teebine itemlige egä, “Nää, iyeta umle gäte ai mene lui ecnenenemite maane?” ");
INSERT INTO bon_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiyopiya biname te jejige egä, “Cane lipu umle äbita; nuuja biname liba lica pisi nyene cebine abiberäjame?” Tabe piba Pilipo ne jejige, “Tacenuti älädnalädna gwidape cabu, cäme gome adna-ti!” ");
INSERT INTO bon_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Age peei neeneni Oogäräneji Mene pargi Yeesu poto cidi me tabe lui bine aacnenige: ‘Tabe epu maamoi pana, aglime lui ne ecanisi. Tabe maamoi plongo pana, lui te bojäcu ya