﻿USE sofia;
DROP TABLE IF EXISTS sofia.boj_vpl;
CREATE TABLE boj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES boj_vpl WRITE;
INSERT INTO boj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Endi Yesus Kristus aqa moma naŋgo ñam kalil. Yesus Kristus a Devit aqa leŋ na ŋambabej. Devit a Abraham aqa leŋ na ŋambabej. ");
INSERT INTO boj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham a Aisak aqa abu. Aisak a Jekop aqa abu. Jekop a Juda aqa was naŋgi ti naŋgo abu. ");
INSERT INTO boj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda a Peres Sera wo naŋgo abu. Naŋgo ai Tamar. Peres a Hesron aqa abu. Hesron a Ram aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram a Aminadap aqa abu. Aminadap a Nason aqa abu. Nason a Salmon aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon a Boas aqa abu. Boas aqa ai Rahap. Boas a Obet aqa abu. Obet aqa ai Rut. Obet a Jesi aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi a Mandor Koba Devit aqa abu. Devit a Solomon aqa abu. Solomon aqa ai a nami Uria aqa ŋauŋ soqnej. ");
INSERT INTO boj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon a Rehoboam aqa abu. Rehoboam a Abiya aqa abu. Abiya a Asa aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a Jehosafat aqa abu. Jehosafat a Jehoram aqa abu. Jehoram a Usia aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia a Jotam aqa abu. Jotam a Ahas aqa abu. Ahas a Hesekia aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia a Manase aqa abu. Manase a Emon aqa abu. Emon a Josaia aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia a Jehoiakin aqa was naŋgi ti naŋgo abu. Aqa bati qa jeu tamo naŋgi na Israel naŋgi tontnjrsib joqsib Babilon qureq di taqatnjresoqneb. ");
INSERT INTO boj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon qureq di naŋgi tontnjrnab sonabqa Jehoiakin aqa aŋgro Sealtiel a ŋambabej. Sealtiel a Serubabel aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel a Abiut aqa abu. Abiut a Eliakim aqa abu. Eliakim a Asor aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor a Sadok aqa abu. Sadok a Akim aqa abu. Akim a Eliut aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut a Eleasar aqa abu. Eleasar a Matan aqa abu. Matan a Jekop aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop a Josep aqa abu. Josep a Maria aqa gumbuluŋ. Maria aqa miligiq na Yesus a ŋambabej. Naŋgi a qa mareqnub, a Kristus. ");
INSERT INTO boj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Deqa Abraham aqaq dena bosi bosiq Devit a ŋambabej di moma 14. Devit aqaq dena bosi bosiq Israel naŋgi Babilon qureq di soqneb di dego moma 14. Naŋgi Babilon qureq di soqneb dena bosi bosiq Kristus a ŋambabej di dego moma 14. ");
INSERT INTO boj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus a endegsi ŋambabej. Aqa ai Maria Josep na oqajqa saga qameb. Ariya Josep a Maria ombla ŋereŋosaisonabqa Mondor Bole a Maria aqaq ainaqa a gumaŋej. ");
INSERT INTO boj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Onaqa Maria aqa gumbuluŋ Josep a endegsi quej, “Maria a gumaŋqo.” Josep aqa kumbra tulaŋ boledamu deqa a endegsi are qalej, “E lumu na Maria uratqai. E boleq di uratqasai. Maria a jemaiyo uge.” ");
INSERT INTO boj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Degsi are qaleqnaqa Tamo Koba aqa laŋ aŋgro bei a Josep aqaq ainaqa ŋeiobilqei na unej. Unnaqa laŋ aŋgro na minjej, “O Josep, Devit aqa moma, ni Maria ame. Ni ulaaim. Ni que. Mondor Bole a Maria aqaq aiqoqa a gumaŋqo. ");
INSERT INTO boj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Deqa a aŋgro mel oqas. Amqa bunuqna aŋgro dena aqa segi tamo uŋgasari naŋgo une kobotetnjrsim naŋgi eleŋqas. Deqa ni aqa ñam Yesus waiyqam.” ");
INSERT INTO boj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kumbra kalil di brantej deqa anjam bei Tamo Koba aqa medabu o tamo bei nami marej qaji di aqa damu brantej. A endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Niŋgi quiy. Bunuqna duŋgeŋge bei a tamo ombla ŋereŋosaisosimqa a gumaŋosim aŋgro mel oqas. Amqa naŋgi aqa ñam Emanuel waiyqab.” Ñam di aqa damu, “Qotei a iga koba na unum.” ");
INSERT INTO boj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Onaqa Josep a qutuosiqa Tamo Koba aqa laŋ aŋgro na anjam minjej qaji di dauryosiqa Maria ej. ");
INSERT INTO boj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bati deqa a Maria ombla ŋereŋosaioqneb. Gilsi gilsiq Maria a aŋgro mel ej. Onaqa Josep na aŋgro di aqa ñam Yesus waiyej. ");
INSERT INTO boj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus a Betlehem qureq di ŋambabej. Qure di Judia sawaq di unu. Bati deqa Mandor Herot a Judia sawa taqatesoqnej. Yesus a ŋambabonaqa bongar sisiyo qaji tamo qudei naŋgi seŋ oqo sawaq na walwelosib gilsib Jerusalem qureq di brantosib tamo qudei naŋgi endegsib nenemnjroqneb, ");
INSERT INTO boj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda naŋgo mandor koba ŋambabej qaji a qabi unu? Iga seŋ oqo sawaq di aqa bongar unsimqa dauryosim bonum. Iga a qa louqajqa deqa bonum.” ");
INSERT INTO boj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Onaqa Mandor Herot a naŋgo anjam di qusiqa a are koba qaloqnej. Tamo uŋgasari kalil Jerusalem di soqneb qaji naŋgi dego are koba qaloqneb. ");
INSERT INTO boj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Deqa Herot a Israel naŋgo atra tamo kokba ti naŋgo dal anjam qalie tamo naŋgi ti kalil metnjrnaqa naŋgi bosib koroonabqa a na naŋgi endegsi nenemnjrej, “Kristus a qabia ŋambabqas?” ");
INSERT INTO boj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Onaqa naŋgi na kamba minjeb, “Kristus a Betlehem qureq di ŋambabqas. Qure di agi Judia sawaq di unu. Qotei aqa medabu o qaji tamo bei a nami endegsi neŋgreŋyej, ");
INSERT INTO boj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem tamo uŋgasari, nuŋgo qure Judia sawaq di unu. Qure kokba kalil Judia sawaq di unub qaji naŋgi na nuŋgo qure buŋyqasai. Di kiyaqa? Nuŋgo qureq dena gate koba bei tigelosimqa a na ijo segi Israel tamo uŋgasari naŋgi taqatnjrqas.’” ");
INSERT INTO boj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Onaqa Herot a anjam di qusiqa bongar sisiyo qaji tamo naŋgi lumu na metnjrnaqa naŋgi aqa areq bonabqa nenemnjrej, “Bati gembu bongar di brantej?” ");
INSERT INTO boj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Onaqa naŋgi bongar brantej qaji aqa bati di ubtosib Herot minjnabqa a na kamba minjrej, “Niŋgi Betlehem aisib aŋgro deqa geregere ŋamoiy. Ŋamosib a tal qabi unu di unsib bosib e merbiy. Yim e kamba aisiy a qa louqai.” ");
INSERT INTO boj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Onaqa naŋgi Mandor Herot aqa anjam di qusib Betlehem aiyeb. Aisib ŋam atsibqa bongar nami seŋ oqo sawaq di uneb qaji di namo aisiq aŋgro soqnej qaji tal di tiŋsi sonaq uneb. ");
INSERT INTO boj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Unsib naŋgi tulaŋ areboleboleinjrej. ");
INSERT INTO boj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Onaqa naŋgi tal miligiq gilsib aŋgro aqa ai Maria wo sonab unjrsibqa aŋgro aqa areq di siŋga pulutosib a qa loueb. Osib naŋgo qasaŋ iŋgi iŋgi qudei ti gol ti goreŋ ti qa ti walaqajqa quleq bole bole di eleŋosib aŋgro atraiyeb. Iŋgi iŋgi di naŋgi nami silali kokba na awaiyeleŋeb. ");
INSERT INTO boj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ariya naŋgi tal uratosib olo puluqa laqnabqa Qotei a ŋeiobilqei na minjrej, “Niŋgi olo Herot aqaq di brantaib.” Degsi minjrnaqa naŋgi gam bei dauryosib naŋgo segi qure utruq aiyeb. ");
INSERT INTO boj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Naŋgi ainabqa bati di Tamo Koba aqa laŋ aŋgro bei a Josep aqaq gilsiq ŋeiobilqei na minjej, “Herot a bosim aŋgro Yesus qalsim moiyotqajqa ŋamqas. Deqa ni tigelosim aŋgro aqa ai wo joqsim Isip sawaq sumiy. Sumsib di soqnibqa bunuqna e ni mermitqa sawa endeq olo bqab.” ");
INSERT INTO boj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Onaqa Josep a qolo tigelosiqa aŋgro aqa ai wo joqsiq Isip sawaq sumeb. ");
INSERT INTO boj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sumsib di sonabqa bunuqna Herot a moiyej. Josep a kumbra di yej deqa anjam bei Tamo Koba aqa medabu o tamo nami marej qaji di aqa damu brantej. A endegsi marej, “Ijo aŋgro mel a Isip sawaq di soqnimqa e dena metit a Isip sawa uratosim ijoq bqas.” ");
INSERT INTO boj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot a bongar sisiyo qaji tamo naŋgi qa tariŋonaq ugeiyonaq qalieej, naŋgi a gisaŋyeb. Deqa a minjiŋ ani oqetonaqa aqa qaja tamo qudei naŋgi qariŋnjrnaqa aisib Betlehem qureq di aŋgro mel kiñilala wausau aiyel osaisoqneb qaji naŋgi kalil ñumeleŋosib moiyotnjreb. Qure qure Betlehem jojomq di soqneb qaji dia dego aŋgro mel kiñilala wausau aiyel osaisoqneb qaji naŋgi kalil moiyotnjreb. Herot a bongar brantej qaji aqa bati dauryosiq kumbra degyej. ");
INSERT INTO boj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Deqa anjam bei Qotei aqa medabu o tamo Jeremaia nami marej qaji di aqa damu brantej. A endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama qureq di Resel a akamkobaoqnsiq pailoqnej. Aqa aŋgro kalil naŋgi ñumnab moreŋeb deqa akameqnaqa tamo uŋgasari naŋgi aqa are latetqa yeqnab a naŋgo anjam quqwa uratoqnej. Di kiyaqa? Aqa aŋgro kalil naŋgi moreŋekriteb deqa.” ");
INSERT INTO boj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bati Herot a moinaqa Tamo Koba aqa laŋ aŋgro bei a Isip sawaq di Josep aqaq di brantosiqa ŋeiobilqei na minjej, ");
INSERT INTO boj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ni tigelosim aŋgro kiñala Yesus aqa ai Maria wo joqsim olo Israel sawaq gile. Tamo naŋgi Yesus qalsib moiyotqa maroqneb qaji naŋgi moreŋekriteb deqa ni olo gile.” ");
INSERT INTO boj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Onaqa Josep a tigelosiqa Yesus aqa ai Maria wo joqsiq olo Israel sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bati deqa Arkelaus a na aqa abu Herot aqa sawa osiq Judia sawa taqatesoqnej. Deqa Josep a anjam di qusiqa Judia sawaq gilqa ulaej. Onaqa Qotei a Josep ŋeiobilqei na minjej, “Ni Galili sawaq gile.” ");
INSERT INTO boj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Onaqa Josep a Qotei aqa anjam di dauryosiqa Galili sawaq gilej. Gilsiq qure bei aqa ñam Nasaret di soqnej. A di soqnej deqa anjam bei Qotei aqa medabu o tamo qudei naŋgi nami maroqneb qaji di aqa damu brantej. Naŋgi endegsib maroqneb, “Naŋgi a qa maroqnqab, ‘A Nasaret tamo.’” ");
INSERT INTO boj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bunuqna Jon yansnjro qaji a Judia naŋgo wadau sawaq di brantej. Brantosiq dia tamo uŋgasari naŋgi Qotei aqa anjam palontosiq endegsi minjroqnej, ");
INSERT INTO boj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Qotei laŋ qureq di unu qaji a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa bati jojomqo. Deqa niŋgi are bulyiy.” ");
INSERT INTO boj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon a kumbra degyej deqa anjam bei Qotei aqa medabu o tamo Aisaia nami marej qaji di aqa damu brantej. A Jon qa endegsi marej, “Tamo bei a wadau sawaq di tigelosimqa a tulaŋ leleŋoqnsim tamo uŋgasari naŋgi endegsim minjroqnqas, ‘Tamo Koba a bqajqa gam gereiyetiy. Gam tingitetiy.’” ");
INSERT INTO boj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon a wadau sawaq di sosiqa a gara jugo kamel aqa juŋgum na gereiyo qaji di jugoqnsiqa alalag na siŋgilatosiq laqnej. A iŋgi uyo saiqoji deqa a sis ti bisim qaq ti uyoqnej. ");
INSERT INTO boj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bati deqa tamo uŋgasari Jerusalem di soqneb qaji naŋgi ti Judia sawaq di soqneb qaji naŋgi ti qure kalil Jordan ya qalaq di soqneb qaji naŋgi ti tigelosib Jon aqa areq boqneb. ");
INSERT INTO boj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Boqnsibqa naŋgo une kalil babteqnab Jon na Jordan yaq di yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bati deqa Farisi tamo ti Sadyusi tamo ti tulaŋ gargekoba naŋgi Jon na yansnjrqa marsibqa aqa areq beqnabqa unjrsiqa naŋgi endegsi minjroqnej, “Niŋgi kumbra uge yo qaji tamo. Niŋgi amal uge bul. Niŋgi yai na merŋgwoqa mondoŋ Qotei aqa minjiŋ nuŋgoq aiyaim deqa ulaosib ijoq bonub? ");
INSERT INTO boj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Niŋgi are bulyosib nuŋgo kumbra uge kalil uratosib kumbra bole bole yoqniy. Yim e unsiy marqai, ‘Bole, niŋgi are bulyonub.’ Osiy niŋgi yansŋgwai. ");
INSERT INTO boj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Niŋgi endegsib are qalaib, ‘Abraham a gago moma utru unu deqa iga Qotei aqa ŋamgalaq di tamo bole.’ Niŋgi degsib are qalaib. Niŋgi quiy. Qotei na marimqa meniŋ kalil endi dego tamo bulyosib tigelosib Abraham aqa moma brantqab. ");
INSERT INTO boj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Qotei na tapor qalat ojsiqa ŋam qomqajqa utruq di atej unu. Deqa ŋam kalil gei bole atosaieqnub qaji di Qotei na tapor dena qomeleŋosim ŋamyuwoq di breinjrqas. ");
INSERT INTO boj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Niŋgi are bulyqajqa deqa e ya na niŋgi yansŋgeqnum. Ariya Tamo Koba a bunuqna ijo qoreq na bqas. A tamo siŋgila koba. Ijo siŋgila aqa siŋgila ti keresai. Deqa e a kaŋgalyqajqa e tamo bolesai. A bosimqa Mondor Bole aqa siŋgila na ti ŋamyuwo na ti niŋgi yansŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A bem sum ñoqoryosim damu eleŋosim aqa talq di atqas. Osim a bem sum aqa suwi breinjrim ŋamyuwo gaigai yuejunu qaji dia yuekritqab.” ");
INSERT INTO boj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bati deqa Yesus a Galili sawaq dena tigelosiqa walwelosiq Jordan yaq gilej. A Jon na yansqa marsiqa aqa areq gilej. ");
INSERT INTO boj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gilnaqa Jon na saidyosiq minjej, “Ni e yansbqam di kere. Kiyaqa e ni yansmqa marsim ijoq bonum?” ");
INSERT INTO boj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Onaqa Yesus na kamba minjej, “Uŋgum. Ni ijo anjam dauryosim e yansbe. Yimqa kumbra dena iga Qotei aqa areqalo kalil keretosim dauryqom.” Onaqa Jon a Yesus aqa anjam di dauryosiqa a yansej. ");
INSERT INTO boj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus a yanso osiqa a yaq na tigelosiqa tarosiq laŋ goge koqyonaqa laŋ waqej. Laŋ waqonaqa Qotei aqa Mondor a binoŋ bulosiq aisiq Yesus aqa jejamuq di awoonaq unej. ");
INSERT INTO boj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Unnaqa laŋ goge dena Qotei aqa anjam bei endegsi brantej, “Endi ijo aŋgro qujai. E a tulaŋ qalaqalaiyeqnum. E a qa tulaŋ areboleboleibeqnu.” ");
INSERT INTO boj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Onaqa bati deqa Mondor a Yesus wadau sawaq osi gilsiqa di uratonaqa Satan bosiqa Yesus a une bei atqa marsiqa walawalaiyoqnej. ");
INSERT INTO boj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Qanam 40 qolo 40 Yesus a wadau sawaq di soqnej. Sosiqa iŋgi uratoqnsiqa qurieŋ ti soqnej. Deqa bati 40 di koboonaqa a mamyej. ");
INSERT INTO boj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Onaqa walawalaiyo tamo Satan a Yesus aqa areq bosiqa minjej, “Ni Qotei aqa Ŋiriamqa meniŋ kalil endi minjrim bem bulyibqa ni uye.” ");
INSERT INTO boj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Degsi minjnaqa Yesus na kamba minjej, “Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Tamo naŋgi iŋgi uyo na segi ŋambile sqasai. Anjam kalil Qotei aqa medabuq na branteqnu qaji dena naŋgi ŋambile sqab.’” ");
INSERT INTO boj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Onaqa Satan na Yesus olo osiqa Qotei aqa qure koba Jerusalem gilsiq atra tal quraq oqsiq goge dia Yesus atsiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ni Qotei aqa Ŋiriamqa endena prugosim mandamq aiye. Agi Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Qotei na aqa laŋ aŋgro naŋgi minjrimqa bosib ni taqatmqab.’ Anjam bei dego neŋgreŋq di unu. Anjam agiende, ‘Laŋ aŋgro naŋgi bosib baŋ na ni soqtmibqa ino siŋga meniŋ na qalqasai.’” ");
INSERT INTO boj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Onaqa Yesus na kamba Satan minjej, “Qotei aqa anjam bei dego neŋgreŋq di unu. Anjam agiende, ‘Ni ino Tamo Koba Qotei aqa siŋgila laŋa tenemtqa osim a gisaŋyaim.’” ");
INSERT INTO boj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Degsi minjnaqa Satan a Yesus olo osiqa mana goge kobaq oqsiq dia Yesus tigeltosiqa sawa sawa kalil mandor kokba naŋgi na taqatejunub qaji naŋgo siŋgila ti ñoro ti di Yesus osoryosiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ni ijo ulatamuq endi siŋga pulutosim e qa louimqa sawa sawa kalil di naŋgo siŋgila ti ñoro ti ni emqai.” ");
INSERT INTO boj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Onaqa Yesus na minjej, “Satan, ni ulaŋ. Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Ino Tamo Koba Qotei a segi qa louoqnsimqa aqa sorgomq di soqne.’” ");
INSERT INTO boj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Degsi minjnaqa Satan a Yesus uratosiq ulaŋej. Onaqa Qotei aqa laŋ aŋgro naŋgi bosib Yesus siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bati bei Jon a tonto talq di waiyonab sonaqa Yesus a di qusiqa olo tigelosiq Galili sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gilsiq Nasaret qureq di brantej. Dena walwelosiqa Kaperneam qureq gilsiq di soqnej. Kaperneam qure agi Galili ya agu kobaquja qalaqsi unu. Ya agu jojomq di Sebulun sawa ti Naptali sawa ti unub. ");
INSERT INTO boj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus a Kaperneam qureq gilej deqa anjam bei Qotei aqa medabu o tamo Aisaia nami marej qaji di aqa damu brantej. A endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Gam kobaquja Jordan ya qalaq dena aiyejunu qaji di Galili sawa ambleq na aiyejunu. Aisiq yuwalq di diŋejunu. Gam qalaq di Sebulun ti Naptali ti unub. Sawa bei bei qaji naŋgi beleŋosib Galili di unub. ");
INSERT INTO boj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Deqa tamo uŋgasari ambruq di unub qaji naŋgi puloŋ kobaquja unqab. Tamo uŋgasari padalo gam dauryosib ambruq di unub qaji naŋgi puloŋ dena suwantnjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bati deqa Yesus na aqa wau utru atsiqa Qotei aqa anjam palontoqnsiqa tamo uŋgasari naŋgi endegsi minjroqnej, “Qotei laŋ qureq di unu qaji a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa bati jojomqo. Deqa niŋgi are bulyiy.” ");
INSERT INTO boj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Osiqa a Galili ya agu qalaq aisiq alile dia walweloqnsiqa ŋam atej di Saimon aqa ñam bei Pita aqa was Andru wo sonab unjrej. Naŋgi aiyel qe o qaji tamo soqneb deqa naŋgi kakaŋ waiyeqnab unjrsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Niŋgi e daurbiy. Niŋgi qe o qaji tamo unub deqa niŋgi qe eqnub. Dego kere e wau eŋgitqa niŋgi olo tamo oqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yesus a naŋgi degsi minjrnaqa naŋgi naŋgo kakaŋ uratosib Yesus dauryeb. ");
INSERT INTO boj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Onaqa Yesus a olo walwelosiq aisiqa Sebedi aqa ŋiri Jems aqa was Jon wo naŋgi aiyel qobuŋ miligiq di naŋgo abu ti kakaŋ braŋo qandimeqnabqa unjrsiqa metnjrej. ");
INSERT INTO boj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Metnjrnaqa naŋgo abu Sebedi a qobuŋ miligiq di sonaqa uratosib Yesus dauryeb. ");
INSERT INTO boj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus a dena walwelosiqa Galili sawa keretoqnsiqa Juda naŋgo Qotei tal miligiq giloqnsiqa dia Qotei aqa anjam palontoqnej. Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam bole di Yesus na palontoqnej. Osiqa tamo ma utru segi segi kalil naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yeqnaqa tamo uŋgasari kalil Siria sawaq di soqneb qaji naŋgi Yesus qa quoqnsib deqa tamo ma utru segi segi joqsib aqa areq boqneb. Tamo jejamu jaqatiŋnjro qaji naŋgi ti tamo mondor uge uge na ojeleŋo qaji naŋgi ti tamo nanarioqnsib maŋgaloqneb qaji naŋgi ti tamo jejamu lainjro qaji naŋgi ti kalil joqsib beqnab Yesus na boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bati deqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus dauryoqnsib laqneb. Galili sawa naŋgi ti Dekapolis sawa naŋgi ti Jerusalem qure naŋgi ti Judia sawa naŋgi ti qure qure Jordan ya taqal beiq di soqneb qaji naŋgi ti kalil Yesus dauryoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Onaqa Yesus na tamo uŋgasari kalil naŋgi di unjrsiqa a manaq oqsiq di awesonaqa aqa segi aŋgro naŋgi aqa areq beb. ");
INSERT INTO boj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bonabqa a Qotei aqa anjam palontosiq endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tamo uŋgasari qudei naŋgi poinjrqo, naŋgi Qotei aqa ŋamgalaq di sougetejunub. Tamo uŋgasari naŋgi di areboleboleinjreme. Qotei laŋ qureq di unu qaji a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Tamo uŋgasari akam ti unub qaji naŋgi dego areboleboleinjreme. Qotei na naŋgo are olo boletetnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Tamo uŋgasari lawo na sosib naŋgo segi ñam aguq ateqnub qaji naŋgi dego areboleboleinjreme. Qotei na mandam kalil osim naŋgi enjrqas. ");
INSERT INTO boj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Tamo uŋgasari kumbra bole dauryqajqa arearetnjreqnu qaji naŋgi dego areboleboleinjreme. Naŋgi tulaŋ kere na sqab. Iga iŋgi ti ya ti uyqajqa arearetgeqnu dego kere. ");
INSERT INTO boj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Tamo uŋgasari duleqnub qaji naŋgi dego areboleboleinjreme. Qotei a kamba naŋgi qa duloqnqas. ");
INSERT INTO boj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Tamo uŋgasari naŋgo are miligiq di jiga bei saiqoji unub qaji naŋgi dego areboleboleinjreme. Naŋgi Qotei aqa ulatamu unqab. ");
INSERT INTO boj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Tamo uŋgasari jeu turyeqnub qaji naŋgi dego areboleboleinjreme. Qotei a naŋgi qa marqas, ‘Naŋgi ijo segi aŋgro bole.’ ");
INSERT INTO boj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Tamo uŋgasari qudei naŋgi kumbra bole dauryeqnub deqa jeu tamo naŋgi na naŋgi gulbe enjreqnub. Tamo uŋgasari naŋgi di dego areboleboleinjreme. Qotei laŋ qureq di unu qaji a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Niŋgi ijo ñam ti unub deqa bunuqna tamo qudei na niŋgi misiliŋgoqnsib ugeugeiŋgoqnsib nuŋgo jejamu laŋa gisaŋyoqnqab. Di uŋgum. Niŋgi areboleboleiŋgeme. ");
INSERT INTO boj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Od, nuŋgo are tulaŋ boleiŋgim soqniy. Nuŋgo awai bole agi laŋ goge di unu. Nami jeu tamo naŋgi na Qotei aqa medabu o qaji tamo naŋgi dego degsib ugeugeinjroqneb.” ");
INSERT INTO boj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Osiqa Yesus a olo marej, “Niŋgi mandamq endi bar bul soqniy. Ariya bar aqa qajarara koboqas di iŋgi kiye na olo qajararatqas? Di keresai. Bar aqa qajarara koboqas di a ugeqas. Deqa bar di mandamq di waiyibqa tamo qudei naŋgi bosib siŋga na sosqab. ");
INSERT INTO boj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Niŋgi mandamq endi puloŋ bul soqniy. Niŋgi are qaliy. Qure kobaquja a mana gogeqsi sqas di a boleq di sqas. A uliesqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tamo bei a lam qatrentosim guwe na kabutqasai. Boleq di gaintim warum suwaŋamqa tamo kalil tal miligiq di unub qaji naŋgi warum geregere unqab. ");
INSERT INTO boj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dego kere niŋgi puloŋ bul sosib boleq di kumbra bole bole yoqniy. Yoqnibqa tamo uŋgasari naŋgi na nuŋgo kumbra di unoqnsib nuŋgo Abu laŋ qureq di unu qaji aqa ñam soqtoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Osiqa Yesus a olo marej, “E Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti kalil dauryosiy keretqajqa deqa mandamq aiyem. Niŋgi endegsib are qalaib, ‘Yesus a dal anjam di taqal waiyqajqa bej.’ Di sai. ");
INSERT INTO boj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","E bole merŋgwai. Laŋ ti mandam ti koboosaisoqnimqa dal anjam mutu kiñala bei koboqasai bole sai. Dal anjam soqnim soqnim Qotei na aqa wau kalil keretqas. ");
INSERT INTO boj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Deqa niŋgi quiy. Tamo bei a dal anjam mutu kiñala bei uge qa marsim tamo uŋgasari naŋgi dego titnjroqnim naŋgi uge qa marqab tamo di aqa ñam tulaŋ aguq aiqas. Deqa Qotei laŋ qureq di unu qaji a na tamo di taqatqasai. Osim aqa Mandor Koba sqasai dego. Ariya tamo bei a dal anjam kalil dauryosim tamo uŋgasari naŋgi dego dauryqa minjroqnqas tamo di aqa ñam tulaŋ kobaqas. Deqa Qotei na tamo di taqatosim aqa Mandor Koba sqas. ");
INSERT INTO boj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","E niŋgi endegsi merŋgwai. Niŋgi kumbra tulaŋ bolequja yoqniy. Yoqnib nuŋgo kumbra bole dena dal anjam qalie tamo naŋgi ti Farisi ti naŋgo kumbra bole buŋyoqneme. Buŋyqasai di Qotei laŋ qureq di unu qaji a nuŋgo Mandor Koba sosim niŋgi taqatŋgwasai. ");
INSERT INTO boj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Niŋgi dal anjam endegsib queb, ‘Niŋgi tamo bei moiyotaib. Niŋgi tamo bei moiyotqab di niŋgi une ti sqab.’ Dal anjam di nuŋgo moma naŋgi nami minjreb. ");
INSERT INTO boj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Tamo bei na aqa was ŋiriŋtqas di a une ti sqas. Tamo bei na aqa was misiliŋyqas di une kobaquja aqa jejamuq di sqas. Deqa a ojsib anjam pegiyo talq di tigeltosib aqa une ubtetqab di kere. Tamo bei na aqa was minjqas, ‘Ni tulaŋ nanari, areqalo saiqoji,’ degyqas di aqa une deqa Qotei na a osim ŋamyuwoq waiyqas di kere. ");
INSERT INTO boj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Deqa ni Qotei atraiyqa marsimqa ino was bei a ni qa ŋiriŋ ti soqnimqa ni deqa are qalsim atraiyo iŋgi iŋgi mati atra bijal qalaq di uratosim ino was aqaq gile. Gilsim a ombla anjam gereiyekritosim dena bosim Qotei atraiyqam. ");
INSERT INTO boj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Deqa tamo bei a ni qa anjam bei soqnimqa niŋgi ombla walwelosib anjam pegiyo talq giloqnsibqa gamq di niŋgi segi aiyel na anjam urur gereiyoqujatiy. Yosib anjam moiyotosib a ni osim anjam pegiyo talq gilqasai. Ariya niŋgi gamq di anjam gereiyqasai di a na ni osi gilsimqa anjam pegiyo tamo aqa ulatamuq di tigeltmimqa anjam pegiyo tamo a ni osim qaja tamo naŋgo baŋq di atqas. Yimqa naŋgi na ni osib tonto talq di waimqab. ");
INSERT INTO boj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Deqa e bole mermqai. Ni tonto talq dena olo oqedqasai. Ni mati ino une aqa awai kalil keretimqa qaja tamo naŋgi na ni uratmib oqedqam. ");
INSERT INTO boj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Niŋgi dal anjam endegsib queb, ‘Niŋgi tamo bei aqa uŋa jejamu ojetaib.’ ");
INSERT INTO boj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Tamo bei a uŋa bei laŋa kokoqyosiqa are prugyqo di aqa are miligiq na a uŋa di aqa jejamu ojetqo. ");
INSERT INTO boj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ino ŋamdamu wo na ni titmosim uneq waimqa laqnimqa ŋamdamu di otorosim waiy. Ni degye. Di kiyaqa? Ino ŋamdamu qujai loumimqa ni une yqasai di kere. Ariya ni ŋamdamu aiyel ti soqnimqa Qotei na ni ŋamyuwoq waimqas di keresai. ");
INSERT INTO boj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ino baŋ wo na ni titmosim uneq waimqa laqnimqa baŋ di gentosim waiy. Ni degye. Di kiyaqa? Ino baŋ qujai loumimqa ni une yqasai di kere. Ariya ni baŋ aiyel ti soqnimqa Qotei na ni ŋamyuwoq waimqas di keresai. ");
INSERT INTO boj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nami naŋgi dal anjam endegsib mareb, ‘Tamo bei na aqa uŋa uratqa osimqa pepa bei neŋgreŋyosim yosim di a uratqas.’ ");
INSERT INTO boj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Tamo bei na aqa ŋauŋ laŋa uratim a olo tamo bei oqas di tamo dena aqa ŋauŋ kumbra ugeq waiyqo. Tamo bunuj a dego une atqo. Di kiyaqa? Uŋa di a nami tamo bei ombla une atosai deqa. ");
INSERT INTO boj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Niŋgi dal anjam endegsib queb, ‘Ni anjam bei siŋgilatosim Tamo Koba minjqam di ni na olo urataim. Ni anjam di dauryosim ye.’ Dal anjam di nuŋgo moma naŋgi nami minjreb. ");
INSERT INTO boj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Niŋgi anjam bei siŋgilataib. Niŋgi anjam bei marqa osibqa iŋgi bei na siŋgilataib. Laŋ qure a Qotei aqa awo jaram koba. Deqa niŋgi laŋ qure aqa ñam na anjam bei siŋgilataib. ");
INSERT INTO boj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mandam a Qotei aqa siŋga atqajqa sawa. Deqa niŋgi mandam aqa ñam na anjam bei siŋgilataib. Jerusalem a Mandor Koba aqa segi qure koba. Deqa niŋgi Jerusalem aqa ñam na anjam bei siŋgilataib. ");
INSERT INTO boj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni anjam bei marqa osimqa ino gate na anjam siŋgilataim. Ni segi na marimqa ino gate baŋga sara qat bei oqwa keresai. Tulu bei dego oqwa keresai. Deqa ni ino gate na anjam siŋgilataim. ");
INSERT INTO boj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Niŋgi od qa segi marsib said qa dego segi mariy. Niŋgi anjam bei totoryosib marqab di niŋgi Satan aqa areqalo dauryqab. ");
INSERT INTO boj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Niŋgi dal anjam endegsib queb, ‘Tamo bei na tamo bei aqa ŋamdamu ugetetqas di niŋgi kamba aqa ŋamdamu ugetetiy. Tamo bei na tamo bei aqa qalagei ugetetqas di niŋgi kamba aqa qalagei ugetetiy.’ ");
INSERT INTO boj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Tamo bei na ni kumbra uge emimqa ni kamba a kumbra uge yaim. Tamo bei na ula poŋmimqa belosim waliŋe bei osoryimqa poŋyem. ");
INSERT INTO boj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tamo bei a ni qa anjam bei soqnim ino gara jugo yaimqajqa mermimqa ni na saidyaim. Olo ino gara olekoba dego ye. ");
INSERT INTO boj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Qaja tamo bei na ni ojsim siŋgila na mermqas, ‘Ni ijo iŋgi iŋgi qoboiyetbosim e daurbosim gam truquyala endeq gile.’ A degsi mermimqa ni aqa anjam di buŋyosim aqa iŋgi iŋgi qoboiyetosim dauryosim gam olekobaq osi gilete. ");
INSERT INTO boj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tamo bei na ino iŋgi bei yaimqajqa mermimqa ye. Tamo bei na ino iŋgi bei yaimosim bunuqna a kamba olo ni emqajqa mermimqa iŋgi di ye. A saidyaim. ");
INSERT INTO boj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Niŋgi dal anjam endegsib queb, ‘Ni ino was naŋgi qalaqalainjroqne. Osim ino jeu tamo naŋgi qoreinjroqne.’ ");
INSERT INTO boj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ariya e dal anjam di buŋyosiy niŋgi endegsi merŋgwai. Niŋgi nuŋgo jeu tamo naŋgi dego qalaqalainjroqniy. Tamo qudei na niŋgi ugeugeiŋgibqa niŋgi olo naŋgi qa Qotei pailyoqniy. ");
INSERT INTO boj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Niŋgi kumbra degyqab di niŋgi nuŋgo Abu laŋ qureq di unu qaji aqa aŋgro bole sqab. Niŋgi qalie, Qotei a dego tamo bole ti tamo uge ti naŋgi turtnjroqnsiq kumbra bole bole enjreqnu. Agi a na aqa seŋ qariŋyeqnaqa tamo bole ti tamo uge ti naŋgoq aiyeqnu. Awa dego qariŋyeqnaqa tamo bole ti tamo uge ti naŋgoq aiyeqnu. ");
INSERT INTO boj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tamo uŋgasari niŋgi qalaqalaiŋgeqnub qaji naŋgi segi niŋgi kamba qalaqalainjroqnqab di kumbra tulaŋ bolesai. Nuŋgo kumbra deqa Qotei a niŋgi awai bole eŋgwasai. Takis o qaji tamo naŋgi dego kumbra degyeqnub. ");
INSERT INTO boj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niŋgi nuŋgo was naŋgi segi gereinjroqnqab di kumbra tulaŋ bolesai. Nuŋgo kumbra dena niŋgi na tamo qudei buŋnjrqasai. Tamo naŋgi Qotei qaliesai qaji naŋgi dego naŋgo segi was naŋgi gereinjreqnub. ");
INSERT INTO boj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuŋgo Abu laŋ qureq di unu qaji a gaigai kumbra bole bole keretoqnsiq yeqnu. Deqa niŋgi dego nuŋgo Abu aqa kumbra di dauryosib kumbra bole bole keretoqnsib yoqniy. ");
INSERT INTO boj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tamo qudei naŋgi endegsib are qaleqnub, ‘E laŋa babaŋ na kumbra bole yoqnit tamo naŋgi e nuboqnsib ijo ñam soqtetboqnqab.’ Ariya niŋgi degyaib. Niŋgi degyqab di nuŋgo Abu laŋ qureq di unu qaji a niŋgi awai bole eŋgwasai. ");
INSERT INTO boj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Niŋgi gisaŋ tamo naŋgo kumbra dauryaib. Gisaŋ tamo naŋgo kumbra agiende. Naŋgi na tamo iŋgi iŋgi saiqoji naŋgi aqaryainjrqa oqnsib tamo qudei qariŋnjreqnab naŋgi qa namooqnsib gul anjameqnub. Gul anjameqnab tamo uŋgasari naŋgi na gisaŋ tamo naŋgi di unjroqnsib naŋgo ñam soqtetnjreqnub. Gisaŋ tamo naŋgi di Qotei tal miligiq di, gam kokbaq di kumbra degyeqnub. Deqa e bole merŋgwai. Qotei a tamo naŋgi di awai bole enjrqasai. Naŋgo awai agi tamo uŋgasari naŋgi na naŋgo ñam soqtetnjreqnub di kere. ");
INSERT INTO boj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Deqa ni degyaim. Ni tamo iŋgi iŋgi saiqoji naŋgi aqaryainjrqa osimqa baŋ qonaŋ a uli na aqaryainjrimqa baŋ wo a qalieqasai. ");
INSERT INTO boj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Di yawo anjam. Aqa damu endegsi unu. Ni uli na tamo iŋgi iŋgi saiqoji naŋgi aqaryainjrimqa tamo uŋgasari kalil naŋgi qalieqasai. Ni kumbra di uli na yoqnim ino Abu a segi unoqnqas. Deqa a segi na ino ñam soqtetmosim ni awai bole emoqnqas.” ");
INSERT INTO boj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Osiqa Yesus a olo marej, “Niŋgi Qotei pailyqa osibqa gisaŋ tamo naŋgi pailyeqnub degsib pailyaib. Gisaŋ tamo naŋgi Qotei pailyqa oqnsib tamo uŋgasari kalil naŋgo ŋamdamuq di tigeleqnab unjroqnsib naŋgo ñam soqtetnjreqnub. Tamo naŋgi di Qotei tal miligiq di, qure ambleq di, gam kokba qalaq di kumbra degyeqnub. Deqa e bole merŋgwai. Qotei a naŋgi awai bole enjrqasai. Naŋgo awai agi tamo uŋgasari naŋgi na naŋgo ñam soqtetnjreqnub di kere. ");
INSERT INTO boj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Deqa ni degsi pailyaim. Ni Qotei pailyqa osimqa ino segi warum miligiq gilsim siraŋ qandimtosim ino Abu uliejunu qaji a pailyimqa tamo kalil naŋgi ni numqasai. Ni kumbra di uli na yoqnim ino Abu a segi unoqnqas. Deqa a segi na ino ñam soqtetmosim ni awai bole emoqnqas. ");
INSERT INTO boj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Tamo naŋgi Qotei qaliesai qaji naŋgi laŋa laŋa pailyo olekokba yoqnsibqa endegsib are qaleqnub, ‘Iga pailyo olekokba yoqnimqa Qotei a gago pailyo quqwas.’ Di gisaŋ. Deqa niŋgi Qotei pailyqa osibqa degsib pailyaib. ");
INSERT INTO boj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niŋgi naŋgo kumbra di dauryaib. Niŋgi iŋgi bei qa truquosib nuŋgo Abu pailyosaisoqnibqa a nami qalieqo. ");
INSERT INTO boj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Deqa niŋgi endegsib Qotei pailyoqniy, ‘O gago Abu, ni laŋ qureq di unum. Ino ñam tulaŋ getento. ");
INSERT INTO boj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ni bosim gago Mandor Koba sosim iga taqatgoqnime. Laŋ qureq di naŋgi ino areqalo dauryeqnub dego kere iga mandamq endi ino areqalo dauryoqnqom. ");
INSERT INTO boj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O Abu, gago iŋgi uyo bati gaigai keretgoqnime. ");
INSERT INTO boj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tamo naŋgi iga qa une ateqnub qaji naŋgo une kalil iga na kobotetnjreqnum deqa ni kamba gago une kalil dego kobotetgime. ");
INSERT INTO boj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gulbe bei na iga walawalaigosim uneq waigwa laqnimqa ni iga aqaryaigime. Yim Satan na iga ugetgwasai.’ ");
INSERT INTO boj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“O ijo aŋgro, niŋgi degsib Qotei pailyoqniy. Niŋgi quiy. Niŋgi tamo bei qa anjam soqnimqa niŋgi na aqa une kobotiy. Yimqa nuŋgo Abu laŋ qureq di unu qaji a na kamba nuŋgo une kalil kobotetŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Niŋgi aqa une kobotetqasai di nuŋgo Abu a dego nuŋgo une kobotetŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Osiqa Yesus a olo marej, “Niŋgi qurieŋqa marsibqa gisaŋ tamo naŋgi qurieŋeqnub niŋgi degsib qurieŋaib. Gisaŋ tamo naŋgi qurieŋoqnsibqa ulatamu ugeinjreqnu. Tamo uŋgasari kalil naŋgi na unjrsib naŋgo ñam soqtetnjrqajqa deqa naŋgi kumbra degyeqnub. Deqa e bole merŋgwai. Tamo naŋgi di Qotei na awai bole enjrqasai. Naŋgo awai agi tamo uŋgasari naŋgi na naŋgo ñam soqtetnjreqnub di kere. ");
INSERT INTO boj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ariya ni kumbra degyaim. Ni qurieŋqa osimqa ino ulatamu geregere yansoqnsim ino gate baŋga praŋyoqnsim ino jejamu gereiyoqnsim laqne. ");
INSERT INTO boj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yimqa tamo uŋgasari kalil naŋgi ni numoqnsib ni qurieŋ ti unum di naŋgi qalieqasai. Ni kumbra di uli na yoqnim ino Abu a segi na unoqnqas. Deqa a segi na ino ñam soqtetmosim awai bole emoqnqas.” ");
INSERT INTO boj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Osiqa Yesus a olo marej, “Niŋgi mandam qa iŋgi iŋgi koroiyaib. Di sisimbiŋ na ugetqab. Baisuwi ojqas. Bajiŋ tamo naŋgi tal paratosib oqab. ");
INSERT INTO boj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Deqa niŋgi laŋ qure qa iŋgi iŋgi koroiyiy. Di sisimbiŋ na ugetqasai. Baisuwi ojqasai. Bajiŋ tamo naŋgi tal paratosib oqasai dego. ");
INSERT INTO boj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sawa qabia ino ñoro bole unu dia ino are miligi dego siŋgilatim sqas.” ");
INSERT INTO boj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Osiqa Yesus a olo marej, “Ino ŋamdamu a ino jejamu qa puloŋ bul. Deqa ino ŋamdamu boleqas di ino jejamu kalil suwaŋesqas. ");
INSERT INTO boj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ariya ino ŋamdamu ugeqas di ino jejamu kalil ambruesqas. Deqa puloŋ ino are miligiq di unu qaji a olo ambruqas di ino are miligi kalil ambruekritqas.” ");
INSERT INTO boj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Osiqa Yesus a olo marej, “Tamo qujai a tamo kokba aiyel naŋgi wauetnjrqa keresai. A tamo kobaquja bei qalaqalaiyosim olo tamo kobaquja bei jeutqas. Bei aqa anjam dauryosim olo bei qoreiyqas. Dego kere niŋgi silali ti Qotei ti turtnjrsib naŋgi wauetnjrqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Osiqa Yesus a olo marej, “Niŋgi mandamq endi bole sqajqa deqa areqalo kobaiyaib. Osib endegsib maraib, ‘Iga iŋgi ti ya ti qabe na osim uyqom? Gara qabe na osim gago jejamu kabutqom?’ Niŋgi degsib maraib. Niŋgi iŋgi uyo na segi ŋambile oqasai. Niŋgi gara jugoqnqab dena segi nuŋgo jejamu bole sqasai. ");
INSERT INTO boj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Niŋgi qebari naŋgi unjriy. Naŋgi iŋgi yagosaieqnub. Iŋgi otorosib talq di atosaieqnub. Ariya nuŋgo Abu laŋ qureq di unu qaji a na qebari naŋgi iŋgi anainjreqnu. Niŋgi qalie, qebari naŋgi qunuŋ saiqoji. Niŋgi tamo qunuŋ ti. Niŋgi na qebari naŋgi tulaŋ buŋnjrejunub. ");
INSERT INTO boj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Niŋgi mandamq endi sokobaiyqajqa deqa are koba qalaib. Niŋgi are koba qalqab dena niŋgi nuŋgo segi sqajqa bati olo yala totoryqa keresai. Sai bole sai. ");
INSERT INTO boj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Deqa niŋgi kiyaqa gara qabe na osib jejamu kabutqajqa are koba qaleqnub? Niŋgi ŋam so unjriy. Naŋgo wala kiyersib branteqnub di niŋgi qaliesai. Naŋgi segi wauosaieqnub. Naŋgo segi wala gereiyosaieqnub. ");
INSERT INTO boj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Deqa e niŋgi endegsi merŋgwai. Nami Solomon a gara wala boledamu jugoqnej. Ariya ŋam so aqa wala dena Solomon aqa wala tulaŋ buŋyejunu. ");
INSERT INTO boj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Maŋ laŋaj a bini oqwas nebe tamo naŋgi na giŋgeŋyosib ŋamyuwoq waiyqab. Maŋ laŋaj di Qotei na wala enjreqnu. Deqa niŋgi kiyaqa Qotei qa nuŋgo areqalo siŋgilatqa yonub keresaiiŋgwo? Niŋgi maŋ laŋaj sai. Niŋgi tamo qunuŋ ti. Deqa niŋgi endegsi poiŋgem, Qotei a niŋgi dego gara eŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Niŋgi areqalo kobaiyosib endegsib maraib, ‘Iga iŋgi ti ya ti qabe na osim uyqom? Gara qabe na osim gago jejamu kabutqom?’ Niŋgi degsib maraib. ");
INSERT INTO boj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tamo uŋgasari Qotei qaliesai qaji naŋgi iŋgi iŋgi deqa are koba qaleqnub. Ariya niŋgi deqa are koba qalaib. Nuŋgo Abu laŋ qureq di unu qaji a qalie, niŋgi laŋa sqa keresai. Niŋgi iŋgi iŋgi deqaji oqnsib sqab. ");
INSERT INTO boj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Deqa niŋgi kumbra qujai endi yoqniy. Niŋgi Qotei na taqatŋgosim nuŋgo Mandor Koba sqajqa ti aqa kumbra bole bole dauryqajqa ti siŋgilaoqniy. Niŋgi degyqab di Qotei na kamba iŋgi uyo ti gara ti dego eŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Deqa nebe kumbra kiye nuŋgoq di brantqas niŋgi deqa are koba qalaib. Nebe a bati bei. Nebe qa gulbe di aqa segi gulbe. Bati segi segi aqa gulbe di naŋgo segi segi. Deqa niŋgi are koba qalaib.” ");
INSERT INTO boj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Osiqa Yesus a olo marej, “Niŋgi na tamo qudei naŋgi peginjraib. Niŋgi peginjrqasai di Qotei a kamba dego niŋgi pegiŋgwasai. ");
INSERT INTO boj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ariya niŋgi na tamo naŋgi peginjrqab kere dego Qotei a kamba niŋgi pegiŋgwas. Niŋgi na tamo naŋgo jejamuq di une qametnjrqab kere dego Qotei a kamba nuŋgo jejamuq di une qametŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kiyaqa ni ino was aqa ŋamdamuq di ŋam ñeŋgi kiñala unu di unsimqa ino segi ŋamdamuq di ŋampaŋ kobaquja unu di ni unosai? ");
INSERT INTO boj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kiyaqa ino segi ŋamdamuq di ŋampaŋ kobaquja soqnimqa ni na tentosim ino was minjqam, ‘Was, e ino ŋamdamuq di ŋam ñeŋgi kiñala unonum di osiy taqal waiyetmqai’? ");
INSERT INTO boj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ni gisaŋ tamo. Ni mati ŋampaŋ kobaquja ino segi ŋamdamuq di unu qaji di taqal waiyosim ŋamdamu suwaŋmimqa ariya degam ŋam ñeŋgi kiñala ino was aqa ŋamdamuq di unu qaji di geregere unsim taqal waiyete. ");
INSERT INTO boj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Niŋgi ñoro bole bole oqnsib bauŋ naŋgi enjroqnaib. Enjrqab di naŋgi ñoro di taqal waiyosib bosib niŋgi uñiŋgwab. Niŋgi kolilei bole bole oqnsib bel naŋgi enjroqnaib. Enjrqab di naŋgi kolilei di mandamq di waiyosib naŋgo siŋga na soseleŋqab.” ");
INSERT INTO boj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Osiqa Yesus a olo marej, “Niŋgi iŋgi bei qa Qotei pailyqab di a na eŋgwas. Niŋgi iŋgi bei oqa marsibqa ŋamqab di itqab. Niŋgi siraŋme kindokindoŋabqa Qotei na siraŋ waqtetŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tamo kalil Qotei pailyeqnub qaji naŋgi iŋgi eqnub. Tamo kalil iŋgi qa ŋameqnub qaji naŋgi iteqnub. Tamo kalil siraŋme kindokindoŋeqnub qaji naŋgi Qotei na siraŋ waqtetnjreqnu. ");
INSERT INTO boj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Tamo bei aqa aŋgro a mamyim iŋgi qa minjimqa a iŋgi yqas. A meniŋ yqasai. ");
INSERT INTO boj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A na qe qa minjimqa a qe yqas. A amal yqasai. ");
INSERT INTO boj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Deqa niŋgi quiy. Niŋgi tamo bolesai. Ariya niŋgi nuŋgo aŋgro naŋgi iŋgi bole bole enjreqnub. Niŋgi naŋgi saidnjrosaieqnub. Nuŋgo kumbra dena niŋgi endegsi poiŋgem, nuŋgo Abu laŋ qureq di unu qaji a dego niŋgi saidŋgosaieqnu. Niŋgi pailyqab di a na iŋgi bole bole niŋgi eŋgoqnqas. A na niŋgi saidŋgwasai bole sai. ");
INSERT INTO boj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kumbra bole bole tamo naŋgi na niŋgi eŋgwajqa arearetŋgeqnu qaji di niŋgi na olo naŋgi enjroqniy. Niŋgi degyqab di niŋgi Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti kalil keretosib dauryqab.” ");
INSERT INTO boj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Osiqa Yesus a olo marej, “Niŋgi siraŋme kiñala miligiq giliy. Niŋgi siraŋme kobaquja miligiq gilqab di niŋgi padalo sawaq aiqab. Gam di kobaquja. Tamo gargekoba naŋgi gam di dauryeqnub. ");
INSERT INTO boj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Niŋgi siraŋme kiñala miligiq gilqab di niŋgi gam kiñala dauryosib ŋambile gaigai sqajqa sawaq di brantqab. Tamo quja quja segi gam di itosib dauryeqnub.” ");
INSERT INTO boj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Osiqa Yesus a olo marej, “Niŋgi geregere ŋam atoqniy. Tamo qudei na bosib gisaŋosib merŋgwab, ‘Iga Qotei aqa medabu o qaji tamo bole.’ Di sai. Tamo naŋgi di kaja bul lawo na boqnsib niŋgi walawalaiŋgoqnsib anjam merŋgeqnub. Ariya naŋgo are miligiq di naŋgi tamo uge. Naŋgi bauŋ juwaŋ kaja naŋgi ñumeqnub dego bul. ");
INSERT INTO boj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Niŋgi naŋgo kumbra di geregere tenemtosib poiŋgwas, naŋgi Qotei aqa medabu o qaji tamo bolesai. Niŋgi are qaliy. Tamo naŋgi sil luwit mariŋq dena wain gei osib uyeqnub e? Sai. Maŋ luwit mariŋq dena qura gei osib uyeqnub e? Sai. ");
INSERT INTO boj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Niŋgi qalie, ŋam bole naŋgi gei bole ateqnub. Ŋam uge naŋgi gei uge ateqnub. ");
INSERT INTO boj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ŋam bole naŋgi gei uge atosaieqnub. Ŋam uge naŋgi gei bole atosaieqnub. ");
INSERT INTO boj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ŋam kalil gei bole atosaieqnub qaji di tamo naŋgi na qomeleŋoqnsib ŋamyuwoq di breinjreqnub. ");
INSERT INTO boj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dego kere niŋgi gisaŋ tamo naŋgo kumbra geregere tenemtosib poiŋgwas, naŋgi Qotei aqa medabu o qaji tamo bolesai. ");
INSERT INTO boj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Niŋgi endegsib are qalaib. Tamo uŋgasari naŋgi ‘O Tamo Koba, O Tamo Koba’ e degsib metbqab di Qotei na naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Di sai. Tamo uŋgasari ijo Abu aqa areqalo dauryeqnub qaji naŋgi segi Qotei na taqatnjrsim naŋgo Mandor Koba sqas. Qotei agi laŋ qureq di unu. ");
INSERT INTO boj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mondoŋ diŋo bati bamqa tamo uŋgasari gargekoba naŋgi ijo ulatamuq di tigelosib endegsib merbqab, ‘O Tamo Koba, iga ino ñam na anjam mare mare laqnem. Iga ino ñam na mondor uge uge winjroqnsimqa maŋwa gargekoba yoqnem.’ Naŋgi e degsib merbqab. ");
INSERT INTO boj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Merbibqa e kamba minjrqai, ‘Niŋgi tal qabe? E niŋgi qaliesai. Deqa niŋgi jaraiyiy. Niŋgi kumbra uge yo qaji tamo.’” ");
INSERT INTO boj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Osiqa Yesus a olo marej, “Tamo a ijo anjam kalil endi qusim dauryqas di a tamo bei meniŋ quraq di aqa tal atej a bul sqas. ");
INSERT INTO boj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bunuqna awa jagwa ti bosimqa ya meli dosim tal di qamsim putqasai. Siŋgila na tigelesqas. Di kiyaqa? A meniŋ quraq di tal atej deqa. ");
INSERT INTO boj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ariya tamo a ijo anjam kalil endi qusim olo dauryqa uratqas di a nanari tamo bei laŋa sub gogeq di aqa tal atej qaji a bul sqas. ");
INSERT INTO boj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tal atnaq sonaqa awa jagwa ti bosiqa ya meli dosiqa tal di qamsiq reŋgiŋtosiq putonaq aisiq tulaŋ niñaqej. Od, tal di a torei padalej.” ");
INSERT INTO boj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus a anjam kalil di marsiq koboonaqa tamo uŋgasari tulaŋ gargekoba naŋgi queb. Qusib naŋgi prugugeteb. ");
INSERT INTO boj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Di kiyaqa? Yesus aqa anjam maroqnej di siŋgila ti. Dal anjam qalie tamo naŋgo anjam maroqneb de ti keresai. Yesus a segi anjam di aqa abu. ");
INSERT INTO boj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus a manaq dena aiyeqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi a dauryosib aiyeb. ");
INSERT INTO boj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Onaqa tamo bei yu na aqa jejamu ugeeleŋej qaji a Yesus aqa areq bosiqa aqa siŋgaq di siŋga pulutosiqa minjej, “O Tamo Koba, ni e boletbqa are soqnimqa e boletbe.” ");
INSERT INTO boj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Degsi minjnaqa Yesus a baŋ waiyosiq tamo di ojsiqa minjej, “E ni boletmqa are unu. Deqa ino jejamu olo boleeme.” Onaqa bati qujai deqa aqa yu kalil mosoosiq aqa jejamu boleej. ");
INSERT INTO boj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Onaqa Yesus na olo minjej, “Ni que. Ino jejamu boleqo deqa ni tamo qudei naŋgi minjraim. Ni gilsim ino jejamu atra tamo osoryosim atraiyqajqa iŋgi iŋgi Moses a nami marej qaji di osim Qotei atraiyime. Yimqa tamo uŋgasari naŋgi ni numsib marqab, ‘Bole, ino jejamu boleqo.’” ");
INSERT INTO boj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Onaqa Yesus a walwelosiq Kaperneam qureq di brantej. Dia qaja tamo gate bei soqnej. A Rom tamo. A Yesus aqa areq bosiqa pailyosiq minjej, ");
INSERT INTO boj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Tamo Koba, ijo kaŋgal tamo a makobaiyqo. Aqa tanu kalil laiyosiq jejamu tulaŋ jaqatiŋyqoqa talq di ŋeiejunu.” ");
INSERT INTO boj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Onaqa Yesus na minjej, “E gilsiy boletqai.” ");
INSERT INTO boj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Degsi minjnaqa qaja tamo gate na olo minjej, “O Tamo Koba, e tamo bolesai deqa ni ijo talq baim. Ni anjam segi marimqa ijo kaŋgal tamo a boleqas. ");
INSERT INTO boj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","E dego tamo kokba qudei naŋgo sorgomq di unum. Ijo qaja tamo naŋgi ijo sorgomq di unub. E bei minjqai, ‘Ni gile.’ Yimqa a gilqas. Bei minjqai, ‘Ni au.’ Yimqa a bqas. Ijo kaŋgal tamo bei minjqai, ‘Wau di ye.’ Degsi minjitqa a ijo anjam dauryqas.” ");
INSERT INTO boj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Onaqa Yesus a qaja tamo gate aqa anjam di qusiqa tulaŋ prugugetej. Osiqa bulosiq tamo uŋgasari gargekoba a dauryoqneb qaji naŋgi minjrej, “E bole merŋgwai. Qaja tamo gate endi a e qa aqa areqalo tulaŋ siŋgilatqo. Israel tamo nami e qa degsi aqa areqalo siŋgilato qaji bei unosai. ");
INSERT INTO boj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Deqa e niŋgi endegsi merŋgwai. Tamo uŋgasari gargekoba naŋgi sawa guta na guma na ti bosib koroosib Abraham, Aisak, Jekop naŋgi koba na awoosib iŋgi uyoqnqab. Yimqa Qotei laŋ qureq di unu qaji a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ariya tamo qudei Qotei a nami taqatnjrqa osiq metnjrej qaji naŋgi a qa naŋgo areqalo siŋgilatosai deqa a naŋgo Mandor Koba sosim naŋgi taqatnjrqasai. A na naŋgi osim qalaq di breinjrimqa naŋgi sawa ambruq di sqab. Sawa dia naŋgi akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas.” ");
INSERT INTO boj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Osiqa Yesus a qaja tamo gate di minjej, “Ni gile. Ni e qa ino areqalo siŋgilatonum deqa ni gilsim unime. Ino kaŋgal tamo a boleosiq unu.” Degsi minjnaqa bati qujai deqa aqa kaŋgal tamo aqa ma koboonaqa a boleej. ");
INSERT INTO boj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Onaqa Yesus a Pita aqa tal gogetosiqa Pita aqa mimibe makobaiyonaqa jejamu kaŋkaŋyonaq bijalq di ŋeiesonaq unej. ");
INSERT INTO boj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Unsiqa aqa baŋ ojsiqa tigeltonaqa aqa jejamu kaŋkaŋ di koboonaqa a tigelosiqa iŋgi goiyetej. ");
INSERT INTO boj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Seŋ aiqa laqnaqa tamo uŋgasari mondor uge uge na ojeleŋo qaji naŋgo was naŋgi na joqsib Yesus aqa areq osi boqneb. Osi beqnabqa Yesus a anjam segi minjreqnaqa mondor uge naŋgi aqa anjam quoqnsib jaraiyoqneb. Tamo ma utru segi segi so qaji naŋgi dego osi beqnab Yesus na boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A kumbra di yoqnej deqa anjam bei Qotei aqa medabu o tamo Aisaia nami marej qaji di aqa damu brantej. A endegsi marej, “Kristus a gago ma utru segi segi kalil yaiyetgoqnsiq taqal waiyeqnu.” ");
INSERT INTO boj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bati deqa Yesus a ŋam atej di tamo uŋgasari tulaŋ gargekoba naŋgi aqa areq di koroesonab unjrej. Deqa a na aqa aŋgro naŋgi minjrej, “Iga qobuŋ gogetosim jaraiyosim ya agu taqal beiq gilqom.” ");
INSERT INTO boj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Degsi minjrsiqa naŋgi joqsiq koba na gilqa laqnabqa dal anjam qalie tamo bei a Yesus aqa areq bosiqa minjej, “O Qalie Tamo, ni sawa sawaq giloqnimqa e ni daurmoqnqai.” ");
INSERT INTO boj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Onaqa Yesus na minjej, “Bauŋ juwaŋ naŋgi tal ti. Agi sub miligiq di ŋereŋeqnub. Qebari naŋgi simi ti. Deqa naŋgi simiq di ŋereŋeqnub. Ariya e Tamo Aŋgro ŋeiqajqa tal saiqoji. Deqa ni e daurbqajqa gulbe koba.” ");
INSERT INTO boj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Onaqa Yesus aqa aŋgro bei na minjej, “O Tamo Koba, ni e odbimqa e mati aisiy ijo abu qa tariŋoqnqai. A moiyimqa subq atsiy di e ni daurmqai.” ");
INSERT INTO boj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Onaqa Yesus na minjej, “Uŋgum. Tamo moiyo qaji naŋgi segi na tamo moiyo qaji naŋgi subq ateleŋoqnqab. Ariya ni bosim e daurbe.” ");
INSERT INTO boj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Osiqa Yesus a qobuŋ gogetonaqa aqa aŋgro naŋgi a dauryosib koba na qobuŋ gogetosib gileb. ");
INSERT INTO boj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naŋgi gileqnabqa Yesus a qobuŋ miligiq di ŋeisiq qambumtej. Onaqa jagwa tulaŋ koba tigelosiq ya korkortosiqa qobuŋ qaloqnsiqa mormaŋ miligiq aiyeqnaqa ya maqej. ");
INSERT INTO boj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Deqa Yesus aqa aŋgro naŋgi tulaŋ ulaugetosib aqa areq bosib dudumyosib minjeb, “O Tamo Koba, ni iga aqaryaige. Iga padalqa laqnum.” ");
INSERT INTO boj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Onaqa Yesus a tigelosiqa minjrej, “Niŋgi e qa nuŋgo areqalo siŋgilatqa yonub tulaŋ keresaiiŋgwo. Niŋgi kiyaqa ulaonub?” Degsi minjrsiqa jagwa ti ya ti ŋiriŋtnjrnaqa naŋgi laeb. ");
INSERT INTO boj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Onaqa Yesus aqa aŋgro naŋgi are koba qalsib segi segi maroqneb, “Yesus a tamo kiyero deqa jagwa ti ya ti minjrqoqa aqa anjam qusib laonub?” ");
INSERT INTO boj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Onaqa Yesus aqa aŋgro naŋgi ti qobuŋ na gilsib ya agu taqal beiq di brantosib Gadara naŋgo sawaq di tiryeb. Tiryonabqa tamo aiyel naŋgi tamo sub ato sawaq dena brantosib walwelosib Yesus aqa areq beb. Tamo naŋgi di mondor uge uge na ojeleŋo qaji. Naŋgi aiyel qaja ani. Deqa tamo kalil naŋgi gam dena walwelqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Naŋgi aiyel Yesus aqa areq bosib leleŋkobaosib minjeb, “O Qotei aqa Ŋiri, ni iga kiyergwajqa bonum? Iga padalqajqa bati bosaisonaqa ni laŋa ambleq di iga jaqatiŋ egwa bonum e?” ");
INSERT INTO boj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bati deqa isaq yala dia bel tulaŋ gargekoba naŋgi suwaroqneb. ");
INSERT INTO boj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Deqa mondor uge naŋgi siŋgila na pailosib Yesus minjeb, “Ni iga qariŋgimqa iga bel naŋgo jejamuq gileleŋqom.” ");
INSERT INTO boj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Onaqa Yesus na minjrej, “Di kere. Niŋgi jaraiyosibqa bel naŋgo jejamuq gileleŋoiy.” Degsi minjrnaqa mondor uge naŋgi na tamo aiyel di uratnjrsib bel naŋgo jejamuq gileleŋeb. Gilnabqa bel kalil naŋgi gurgurosib botau dena prugeleŋosib yaq aisib ya uysib moreŋeb. ");
INSERT INTO boj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Onaqa bel taqatoqneb qaji tamo naŋgi kumbra di unsibqa jaraiyosib qure miligiq aiyeb. Aisib bel qa ti tamo aiyel mondor uge uge na ojeleŋo qaji naŋgi qa ti saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Onaqa qure deqaji kalil naŋgi qusibqa Yesus unqajqa aqa areq beb. Bosib Yesus unsib minjeb, “Ni gago sawa endi uratosim sawa beiq gile.” ");
INSERT INTO boj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Onaqa Yesus aqa aŋgro naŋgi ti olo qobuŋ gogetosibqa ya agu taqal beiq aisib Yesus aqa segi qureq di branteb. ");
INSERT INTO boj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Brantosib sonabqa tamo qudei na tamo bei jejamu laiyej qaji a saperaq di atsib Yesus aqa areq osi beb. Onaqa Yesus a naŋgo areqalo unej di naŋgo areqalo qujai Yesus na tamo jejamu laiyej qaji di boletqa kere. Degsi unsiq deqa tamo di minjej, “O ijo aŋgro, ni areboleimeme. Ino une kalil e na kobotetmonum.” ");
INSERT INTO boj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Onaqa dal anjam qalie tamo qudei naŋgi Yesus aqa anjam di qusibqa naŋgo areqalo na mareb, “Yesus a Qotei misiliŋyqo.” ");
INSERT INTO boj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naŋgi degsib are qaleqnabqa Yesus a naŋgo areqalo di qalieosiqa minjrej, “Niŋgi kiyaqa areqalo uge di onub? ");
INSERT INTO boj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anjam kiye e na tamo jejamu laiyqo qaji di minjit niŋgi qusib e qa poiŋgwas? ‘Ino une kalil e na kobotetmonum,’ anjam de kiyo, ‘Ni tigelosim walwel,’ anjam de kiyo? ");
INSERT INTO boj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ariya e segi Tamo Aŋgro. E mandamq endi siŋgila ti unum deqa e na tamo naŋgo une kobotetnjrqa kere. Niŋgi degsi poiŋgwajqa deqa e na tamo di boletqai.” Yesus a naŋgi degsi minjrsiqa tamo jejamu laiyej qaji di koqyosiqa minjej, “Ni tigelosim ino sapera osim ino talq gile.” ");
INSERT INTO boj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Degsi minjnaqa aqa jejamu boleonaqa a tigelosiqa aqa talq gilej. ");
INSERT INTO boj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsibqa naŋgi tulaŋ ulaosib Qotei aqa ñam soqtoqneb. Di kiyaqa? Qotei na siŋgila kobaquja Yesus yej deqa. ");
INSERT INTO boj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Onaqa Yesus a dena walwelosiqa takis o qaji tamo bei aqa ñam Matyu a takis o talq di awesonaq gilsiq itej. Osiqa minjej, “Ni e daurbe.” Degsi minjnaqa a tigelosiqa Yesus dauryej. ");
INSERT INTO boj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Onaqa bati bei Yesus aqa aŋgro naŋgi ti Matyu aqa talq gilsib awoosib iŋgi uyoqneb. Naŋgi segi sai. Takis o qaji tamo ti une tamo ti tulaŋ gargekoba naŋgi dego bosib awoosib Yesus aqa aŋgro naŋgi ti iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Onaqa Farisi qudei naŋgi bosib Yesus a takis o qaji tamo ti une tamo ti naŋgi koba na iŋgi uyeqnab unjrsibqa Yesus aqa aŋgro naŋgi nenemnjreb, “Nuŋgo Qalie Tamo a kiyaqa takis o qaji tamo ti une tamo ti naŋgi koba na awoosib iŋgi uyeqnub?” ");
INSERT INTO boj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Onaqa Yesus a Farisi naŋgo anjam di qusiqa minjrej, “Tamo ma saiqoji naŋgi yu qaŋgra tamo aqaq gilosaieqnub. Tamo ma ti naŋgi segi yu qaŋgra tamo aqaq gileqnub. ");
INSERT INTO boj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Qotei aqa anjam bei nami neŋgreŋyeb qaji di niŋgi sisiyosib geregere poiŋgem. Agi endegsib neŋgreŋyeb, ‘Niŋgi e laŋa atraibeqnub. E nuŋgo kumbra deqa arearetbosaieqnu. Ariya niŋgi tamo naŋgi qa duloqnsib kumbra bole bole enjroqnqab di e tulaŋ arearetbqas.’” Osiqa Yesus a olo anjam endegsi minjrej, “Tamo bei a marqas, ‘E tamo bole. E une saiqoji.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyosai. Tamo a marqas, ‘E une ti.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bati bei Jon aqa aŋgro naŋgi Yesus aqa areq bosib minjeb, “Iga ti Farisi naŋgi ti iŋgi uratoqnsim qurieŋeqnum. Kiyaqa ino aŋgro naŋgi qurieŋosaieqnub?” ");
INSERT INTO boj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Onaqa Yesus na kamba minjrej, “Tamo bei a uŋa baŋ ojqa bati qa aqa was naŋgi ti soqnibqa naŋgi are gulbeinjrqas e? Sai. Bunuqna naŋgo was a naŋgi uratnjrimqa bati deqa naŋgi qurieŋoqnsib sqab. ");
INSERT INTO boj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tamo bei a gara jugo bunuj osim dena mutu gentosim gara jugo sari braŋoq di qandimqa keresai. Degsi qandimqas di bunuqna a na gara jugo sari di yansimqa gara mutu bunuj a kiñalaosim gara jugo sari di uratim braŋ qelikobaqas. ");
INSERT INTO boj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tamo bei a wain bunuj osim ya nobu sariq di qamqa keresai. Ya nobu sari di nami kaŋgraŋosiq siŋgilaej deqa tamo dena wain bunuj qamimqa wain a didiqosim ya nobu sari paratosimqa wain bileŋosim mandamq aiqas. Ya nobu a dego ugeqas. A wain bunuj osim ya nobu bunujq di qamqas di naŋgi ombla bole sqab.” ");
INSERT INTO boj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus na Jon aqa aŋgro naŋgi yawo anjam degsi minjrsiq koboonaqa Qotei tal taqato tamo bei a walwelosiq Yesus aqa areq bosiqa siŋga pulutosiqa minjej, “O Tamo Koba, ijo aŋgro sebiŋ a endego moiqo. Deqa ni bosim ino baŋ aqa jejamuq di atimqa a olo ŋambile sqas.” ");
INSERT INTO boj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Onaqa Yesus na tamo di odyosiqa tigelosiq a dauryosiq gileqnaqa aqa aŋgro naŋgi dego naŋgi aiyel daurnjrsib gileb. ");
INSERT INTO boj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naŋgi gileqnabqa uŋa bei ma ti soqnej qaji a Yesus aqa qoreq na dadauryosiqa baŋ waiyosiq Yesus aqa gara mutu ojej. Uŋa di a nami bai na unej leŋ aiyoqnsiq degsi soqnej wausau 12 uratej. ");
INSERT INTO boj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A endegsi are qalej, “E Yesus aqa gara mutu segi baŋ na ojitqa ijo ma koboqas.” Degsi are qalsiqa baŋ waiyosiq Yesus aqa gara mutu ojej. ");
INSERT INTO boj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ojnaqa Yesus a bulosiqa uŋa di unsiqa minjej, “O ijo aŋgro, ni are lawo soqnime. Ni ino areqalo e qa siŋgilatosim ijoq bonum deqa ino ma agi koboqo.” Onaqa bati qujai deqa aqa leŋ aiyoqnej qaji di koboej. ");
INSERT INTO boj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesus a dena walwelosiq Qotei tal taqato tamo aqa talq di brantosiqa ŋam atej di tamo uŋgasari naŋgi yumba anjamoqnsib akam murqumyeqnab unjrej. ");
INSERT INTO boj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Unjrsiqa minjrej, “Niŋgi sasaloiy. Aŋgro sebiŋ di a moiyosai. A laŋa ŋeisiq qambumtejunu.” Degsi minjrnaqa naŋgi Yesus kikiyeb. ");
INSERT INTO boj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Osib naŋgi sasalosib tal uratonabqa Yesus a aŋgro moiyej qaji aqa warum miligiq gilsiqa aŋgro aqa baŋ ojsiq soqtonaqa a olo ŋambile osiq tigelosiq awoej. ");
INSERT INTO boj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Onaqa bunuqna sawa sawa kalilq di tamo uŋgasari naŋgi Yesus aqa maŋwa deqa saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Onaqa Yesus a qure di uratosiq walwelosiq gileqnaqa tamo aiyel ŋam qandimnjro qaji naŋgi gam na Yesus dauryosib giloqneb. Naŋgi giloqnsib leleŋoqnsib Yesus minjoqneb, “O Devit aqa Ŋiri, ni iga qa are ugeimeme.” ");
INSERT INTO boj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Degsib Yesus minjeqnabqa a tal bei gogetej. Tal gogetosiq sonaqa naŋgi aiyel Yesus aqa areq bonabqa minjrej, “E niŋgi boletŋgwa kere niŋgi degsib are qalonub e?” Onaqa naŋgi aiyel na minjeb, “Od, Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Onaqa Yesus na minjrej, “Niŋgi e qa nuŋgo areqalo siŋgilatosib ijoq bonub deqa e niŋgi boletŋgwai.” Osiqa aqa baŋ waiyosiq naŋgo ŋamdamu ojej. ");
INSERT INTO boj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ojnaqa naŋgo ŋamdamu poinjrnaqa naŋgi sawa uneb. Onaqa Yesus a siŋgila na minjrej, “Nuŋgo ŋamdamu boleqo deqa niŋgi tamo qudei naŋgi ubtosib minjraib.” ");
INSERT INTO boj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Onaqa naŋgi Yesus aqa anjam di dauryosai. Yesus a naŋgi aiyel boletnjrej deqa naŋgi gilsib mare mare laqnab sawa deqaji tamo uŋgasari kalil naŋgi quekriteb. ");
INSERT INTO boj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Naŋgi aiyel gileqnabqa tamo bei mondor uge na ojnaq medabu geteŋyej qaji a tamo qudei na osib Yesus aqa areq beb. ");
INSERT INTO boj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bonabqa Yesus na mondor uge di wiyetonaqa aqa meŋ otyonaqa medabu waqtosiqa anjam maroqnej. Onaqa tamo uŋgasari kalil naŋgi maŋwa di unsibqa are koba qaloqnsib maroqneb, “Israel sawaq endi tamo bei na kumbra deqaji bei yeqnaq iga nami unosaioqnem.” ");
INSERT INTO boj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Onaqa Farisi naŋgi maroqneb, “Mondor uge naŋgo gate koba Satan a Yesus aqa jejamuq di unu. Siŋgila dena Yesus na mondor uge naŋgi winjreqnu.” ");
INSERT INTO boj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus a dena walwelosiqa qure kokba ti qure kiñilala ti dia brantoqnsiqa Juda naŋgo Qotei tal miligiq giloqnsiqa Qotei aqa anjam palontoqnsiq minjroqnej. Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam bole di Yesus na palontoqnsiq Juda naŋgi minjroqnej. Osiqa tamo ma utru segi segi so qaji naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tamo uŋgasari tulaŋ gargekoba naŋgi Yesus aqa areq beqnabqa unjroqnsiq a naŋgi qa duloqnej. Di kiyaqa? Naŋgi tulaŋ sougetesoqneb deqa. Naŋgi kaja bul mandor saiqoji. ");
INSERT INTO boj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Deqa Yesus na aqa aŋgro naŋgi yawo anjam bei endegsi minjrej, “Wauq di iŋgi gargekoba melionub. Ariya iŋgi meli bunuj otorqajqa wau tamo gargekoba sai. ");
INSERT INTO boj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Deqa niŋgi wau lanja minjibqa a na wau tamo naŋgi qariŋnjrimqa naŋgi aqa wauq gilsib iŋgi meli bunuj otoreleŋqab.” ");
INSERT INTO boj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Onaqa Yesus na aqa aŋgro 12 naŋgi metnjrnaqa aqa areq beb. Bonabqa a na naŋgi siŋgila enjrej. Naŋgi na tamo uŋgasari naŋgo jejamuq dena mondor uge uge winjrqajqa ti tamo uŋgasari naŋgo ma utru segi segi kalil kobotetnjrqajqa ti deqa marsiq naŋgi siŋgila enjrej. ");
INSERT INTO boj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aqa anjam maro tamo 12 siŋgila enjrej qaji naŋgo ñam agiende. Bei Saimon. Yesus na aqa ñam bei Pita waiyej. Naŋgi aqa was Andru wo. Bei Sebedi aqa ŋiri Jems aqa was Jon wo. ");
INSERT INTO boj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ariya Filip Bartolomyu wo. Bei Tomas naŋgi takis o qaji tamo Matyu wo. Bei Alfias aqa ŋiri Jems naŋgi Tadius wo. ");
INSERT INTO boj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Bei Saimon agi Rom naŋgi winjrqajqa maroqnej qaji. Ariya bei Judas Iskariot agi bunuqna Yesus osiqa jeu tamo naŋgo baŋq di atej qaji. ");
INSERT INTO boj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Osiqa Yesus na aqa aŋgro 12 naŋgi di qariŋnjrqa osiqa minjrej, “Niŋgi qure qureq giloqniy. Niŋgi sawa bei bei qaji naŋgoq giloqnaib. Samaria naŋgo qureq dego giloqnaib. ");
INSERT INTO boj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Niŋgi Israel naŋgo segiq giloqniy. Israel naŋgi sougetejunub. Naŋgi kaja bul mandor saiqoji. ");
INSERT INTO boj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Deqa niŋgi giloqnsibqa anjam endegsib minjroqniy, ‘Qotei laŋ qureq di unu qaji a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","O ijo aŋgro, niŋgi na Israel naŋgi degsib minjroqnsibqa naŋgo ma tamo naŋgi boletnjroqniy. Tamo moreŋoqnibqa olo tigeltnjroqniy. Tamo naŋgo jejamu yu na ugeeleŋo qaji naŋgi olo gereinjroqniy. Mondor uge uge naŋgi dego tamo uŋgasari naŋgo jejamuq dena winjroqniy. E siŋgila eŋgonum qaji di niŋgi awaiyosai. E laŋa eŋgonum. Deqa niŋgi dego tamo naŋgi laŋa gereinjroqniy. Naŋgi awai bei yainjraib. ");
INSERT INTO boj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Niŋgi meniŋ silali agi gol ti silva ti kapa ti di osib gilaib. ");
INSERT INTO boj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Niŋgi walwelosib nuŋgo qaquŋ aib. Gara jugo aiye aiyel aib. Siŋga tatal aiye aiyel aib. Walwelqajqa toqoŋ ojaib. Niŋgi Qotei aqa wau tamo unub deqa niŋgi qure qureq giloqnibqa naŋgi na iŋgi iŋgi deqaji niŋgi eŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Niŋgi qure bei beiq di brantoqnsibqa tamo bole bei itoqnsib aqa talq di soqniy. Dia sosib dena tigeloqnsib olo qure beiq giloqniy. ");
INSERT INTO boj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Niŋgi tal bei gogetoqnsibqa tamo uŋgasari tal miligiq di unub qaji naŋgi endegsib minjroqniy, ‘Niŋgi lawo na soqniy.’ ");
INSERT INTO boj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Degsib minjroqnibqa naŋgi niŋgi joqsib gereiŋgibqa nuŋgo lawo anjam di naŋgoq di uratib soqnem. Ariya naŋgi niŋgi gereiŋgosaiabqa nuŋgo lawo anjam di olo puluosim nuŋgoq bem. ");
INSERT INTO boj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tamo bei a niŋgi gereiŋgwa uratimqa kiyo nuŋgo anjam quqwa asgiyimqa kiyo niŋgi qure di uratqa oqnsib nuŋgo siŋga tumbrum butuyoqniy. ");
INSERT INTO boj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","E bole merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgo une qa peginjrqa batiamqa Qotei na qure deqaji naŋgi tulaŋ padaltnjrougetqas. Sodom qure ti Gomora qure ti naŋgi Qotei na mondoŋ degsim padaltnjrqasai. A naŋgi gulbe kiñala enjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Osiqa Yesus a olo marej, “Niŋgi quiy. Niŋgi kaja du du bul unub deqa e na niŋgi qariŋgitqa gilsib bauŋ juwaŋ naŋgo ambleq di wauoqnqab. Deqa niŋgi amal naŋgo kumbra dauryiy. Agi amal naŋgi gaigai ŋam atoqnsib laqnub. Niŋgi binoŋ naŋgo kumbra dego dauryiy. Agi binoŋ naŋgi kumbra bole segi yeqnub. Naŋgi kumbra uge yosaieqnub. ");
INSERT INTO boj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Deqa niŋgi tamo naŋgi qa geregere ŋam atoqniy. Naŋgi bosib niŋgi ojeleŋosib anjam pegiyo talq di niŋgi tigeltŋgoqnqab. Osib naŋgo Qotei tal miligiq di niŋgi kumbaiŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Osib niŋgi olo joqoqnsib Rom naŋgo gate ti naŋgo mandor ti naŋgo ulatamuq di niŋgi tigeltŋgoqnqab. Yimqa niŋgi ijo anjam bole palontoqnsib naŋgi minjroqnqab. Osib sawa bei bei qaji naŋgi dego ijo anjam minjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naŋgi na niŋgi ojoqnsib anjam pegiyo talq di tigeltŋgoqnibqa niŋgi ulaaib. Osib endegsib are qalaib, ‘Iga na kamba anjam kiyersim minjrqom?’ Niŋgi degaib. Bati deqa Qotei na powo eŋgimqa niŋgi kamba anjam minjrqab. ");
INSERT INTO boj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Niŋgi segi na anjam minjrqasai. Nuŋgo Abu aqa Mondor na nuŋgo medabu siŋgilatetŋgim niŋgi anjam marqab. ");
INSERT INTO boj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Bati deqa kumbra uge endeqaji branteleŋqas. Tamo qudei na naŋgo segi was naŋgi ojoqnsib jeu tamo naŋgo baŋq di atoqnibqa naŋgi na naŋgi ñumoqnib moreŋoqnqab. Tamo qudei na naŋgo segi aŋgro naŋgi dego degsib ojoqnqab. Aŋgro qudei na naŋgo segi ai abu naŋgi ojoqnsib jeu tamo naŋgo baŋq di atoqnibqa naŋgi na naŋgi ñumoqnib moreŋoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Niŋgi ijo ñam ejunub deqa tamo uŋgasari kalil naŋgi niŋgi qa tulaŋ ugeoqnsib jeutŋgoqnqab. Ariya niŋgi ijo ñam siŋgila na ojsib gilsib diŋo bati itqab di Qotei na niŋgi eleŋqas. ");
INSERT INTO boj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Niŋgi qure bei beiq di brantoqnibqa tamo uŋgasari naŋgi na niŋgi ugeugeiŋgoqnibqa niŋgi naŋgo qure di uratoqnsib olo qure beiq giloqniy. E bole merŋgwai. Niŋgi Israel naŋgo qure kalil keretosaisoqnibqa e Tamo Aŋgro olo bqai. ");
INSERT INTO boj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Skul aŋgro na aqa qalie tamo a buŋyqa keresai. Kaŋgal tamo na aqa tamo koba a buŋyqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Skul aŋgro a kobaqujaosimqa di aqa qalie tamo ombla kerekereqab. Kaŋgal tamo a powo koba osimqa di aqa tamo koba ombla kerekereqab. E tal aqa abu bul. Jeu tamo naŋgi na e merbeqnub, ‘Ni Satan.’ Degsib ñam merbeqnub. Niŋgi ijo talq di unub deqa jeu tamo naŋgi na niŋgi dego ñam tulaŋ ugedamu merŋgoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Osiqa Yesus a olo marej, “Niŋgi jeu tamo naŋgi di ulainjraib. Kumbra kalil kabuejunu qaji di boleq dqas. Anjam kalil uliejunu qaji di tamo naŋgi qusib poinjrqas. ");
INSERT INTO boj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Deqa anjam e ambruq di merŋgeqnum qaji di niŋgi olo suwaŋoq di maroqniy. Anjam niŋgi lumu na queqnub qaji di niŋgi olo bijal gogeq di tigelosib palontoqniy. ");
INSERT INTO boj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Niŋgi jeu tamo naŋgi ulainjraib. Naŋgi nuŋgo qunuŋ moiyotqa keresai. Naŋgi nuŋgo jejamu segi moiyotqa kere. Deqa niŋgi naŋgi ulainjraib. Qotei a segi ulaiyiy. A na qujai tamo naŋgo qunuŋ ti jejamu ti turtnjrsim ŋamyuwoq di breinjrqa kere. ");
INSERT INTO boj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Niŋgi qalie. Tamo naŋgi qebari sinjir silali kobaquja na awaiyosaieqnub. Silali kiñala na awaiyeqnub. 10 toea dego. Ariya nuŋgo Abu a na qebari sinjir naŋgi geregere taqatnjreqnu. A na marimqa bei a uloŋosim mandamq aiqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dego kere Qotei a nuŋgo gate baŋga segi segi sisiyoqnsiq geregere taqateqnu. ");
INSERT INTO boj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Deqa niŋgi ulaaib. Niŋgi qebari kalil naŋgi tulaŋ buŋnjrejunub.” ");
INSERT INTO boj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Osiqa Yesus a olo marej, “Niŋgi mandam tamo naŋgo ulatamuq di ijo ñam boleq atsib marqab di mondoŋ e kamba ijo Abu laŋ qureq di unu qaji aqa ulatamuq di nuŋgo ñam boleq atsiy marqai. ");
INSERT INTO boj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ariya niŋgi mandam tamo naŋgo ulatamuq di ijo ñam marqajqa asgiŋgwas di mondoŋ e kamba ijo Abu laŋ qureq di unu qaji aqa ulatamuq di nuŋgo ñam marqajqa asgibqas.” ");
INSERT INTO boj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Osiqa Yesus a olo marej, “Niŋgi kiyersib are qalonub? E na qaja kobotitqa tamo uŋgasari naŋgi geregere lawo na sqajqa e deqa bem kiyo? Sai. E na qaja kobotqajqa bosai. E na tamo uŋgasari naŋgi pupoinjritqa naŋgi jeu jeu sqajqa deqa bem. ");
INSERT INTO boj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Od, e jeu kumbra tigeltqa bem. Deqa aŋgro mel naŋgi na naŋgo segi abu naŋgi jeutnjroqnqab. Aŋgro sebiŋ naŋgi na naŋgo segi ai naŋgi jeutnjroqnqab. Aiŋ yala naŋgi na naŋgo segi aiŋ qeli naŋgi jeutnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamo uŋgasari tal qujaiq di unub qaji naŋgi jeu jeu sqab. ");
INSERT INTO boj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Deqa niŋgi quiy. Tamo bei na aqa ai abu naŋgi tulaŋ qalaqalainjrsimqa ariya di buŋyosim e tulaŋ qalaqalaibqasai di a e ombla wauqa keresai. Tamo bei na aqa aŋgro mel naŋgi ti aqa aŋgro sebiŋ naŋgi ti tulaŋ qalaqalainjrsimqa ariya di buŋyosim e tulaŋ qalaqalaibqasai di a e ombla wauqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tamo bei na aqa segi ŋamburbas qoboiyosim e daurbqasai di a e ombla wauqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tamo bei a aqa segi ŋambile taqatqajqa arearetqas di a padalqas. Ariya tamo bei a e qa are qalsimqa aqa segi ŋambile uratqas di a olo ŋambile bole oqas.” ");
INSERT INTO boj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Osiqa Yesus a olo marej, “Tamo bei na niŋgi osim geregereiŋgwas di a na e dego osim geregereibqas. Tamo a e oqas di a na ijo Abu e qariŋbej qaji di dego oqas. ");
INSERT INTO boj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tamo bei a endegsi are qalqas, ‘Tamo di a Qotei aqa medabu o qaji tamo.’ A degsi are qalsimqa tamo di osim gereiyqas di Qotei na kamba awai bole yqas. Di kiyaqa? A na Qotei aqa medabu o qaji tamo di gereiyqo deqa. Tamo bei a endegsi are qalqas, ‘Tamo di a Qotei aqa anjam dauryeqnu qaji tamo.’ A degsi are qalsimqa tamo di osim gereiyqas di Qotei na kamba awai bole yqas. Di kiyaqa? A na Qotei aqa anjam dauryeqnu qaji tamo di gereiyqo deqa. ");
INSERT INTO boj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tamo bei a ijo aŋgro bei unsim endegsi are qalqas, ‘Tamo di a Yesus aqa aŋgro.’ A degsi are qalsimqa ijo aŋgro di osim ya ulili tigsim anaiyqas di Qotei na kamba awai bole yqas. E bole merŋgwai. A ijo segi aŋgro gereiyqo deqa aqa awai bole Qotei na yqas qaji di tamo bei na olo yaiyqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus na aqa aŋgro 12 naŋgi anjam degsi minjrsiq koboonaqa a sawa di uratosiqa qure qureq giloqnsiqa tamo uŋgasari naŋgi Qotei aqa anjam plaltosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bati deqa Jon yansnjro qaji a tonto talq di soqnej. Sonaqa wau kalil Kristus a yoqnej qaji di tamo qudei naŋgi unsib deqa mare mare laqnab Jon a quej. Qusiqa aqa aŋgro qudei naŋgi qariŋnjrnaq Yesus aqa areq gilsib endegsib nenemyeb, ");
INSERT INTO boj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Kristus agi Qotei na nami qariŋyim bqajqa marej qaji di ni kiyo? Ni saiamqa iga tamo bei qa tariŋqom kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Onaqa Yesus na kamba minjrej, “Niŋgi aisib anjam niŋgi queqnub qaji deqa ti kumbra niŋgi uneqnub qaji deqa ti Jon saiyosib minjiy. ");
INSERT INTO boj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Endegsib minjiy, ‘Tamo ŋam qandimnjro qaji naŋgi olo ŋam poinjreqnaqa sawa uneqnub. Tamo jejamu lainjro qaji naŋgi olo walweleqnub. Tamo naŋgo jejamu yu na ugeeleŋo qaji naŋgo yu kalil koboeqnu. Tamo dabkala geteŋnjro qaji naŋgo dabkala olo waqeqnu. Tamo moreŋo qaji naŋgi olo tigeleqnub. Tamo sougetejunub qaji naŋgi Qotei aqa anjam bole queqnub. ");
INSERT INTO boj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tamo naŋgi e qa naŋgo areqalo siŋgilatoqnsib olo ijo ñam ulontosaieqnub qaji naŋgi tulaŋ areboleboleinjreqnu.’” ");
INSERT INTO boj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Onaqa Jon aqa aŋgro naŋgi Yesus aqa anjam di qusibqa olo puluosib Jon minjqajqa aiyeb. Aiyeqnabqa Yesus na tamo uŋgasari gargekoba a ombla soqneb qaji naŋgi Jon qa endegsi minjrej, “Niŋgi tamo kiyero unqajqa wadau sawaq gileb? Niŋgi tamo silai aqa baŋga bul jagwa na pileteqnaqa di unqajqa gileb kiyo? Sai. Jon a tamo deqaji sai. ");
INSERT INTO boj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Deqa niŋgi tamo kiyero unqajqa wadau sawaq gileb? Niŋgi tamo gara bole walaosi laqnu qaji di unqajqa gileb kiyo? Di dego sai. Tamo gara bole walaeqnub qaji naŋgi mandor kokba naŋgo talq di unub. ");
INSERT INTO boj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Deqa niŋgi kiyaqa wadau sawaq gileb? Niŋgi Qotei aqa medabu o qaji tamo bei unqajqa gileb kiyo? Od. Agide. Niŋgi deqa unqa gileb. Deqa e niŋgi endegsi merŋgwai. Jon a Qotei aqa medabu o qaji tamo kobaquja. A na Qotei aqa medabu o qaji tamo kalil naŋgi tulaŋ buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Agi nami e mandamq aiyosaisonamqa Qotei a Jon qa endegsi merbej, ‘Ni que. E na ijo anjam maro tamo qariŋyitqa a ni qa namoosim ino gam gereiyetmqas.’ Tamo di agi Jon. Anjam di Qotei aqa neŋgreŋq di unu. ");
INSERT INTO boj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Deqa e bole merŋgwai. Jon yansnjro qaji a na tamo kalil mandamq endi unub qaji naŋgi tulaŋ buŋnjrejunu. Ariya tamo qudei ñam saiqoji unub qaji naŋgi Qotei na taqatnjroqnsiqa naŋgo Mandor Koba unu deqa naŋgi olo Jon tulaŋ buŋyejunub. ");
INSERT INTO boj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Nami Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti maroqneb dena bosi bosiq Jon yansnjro qaji aqa bati brantej. Dena bosiq bini tamo uŋgasari naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqajqa tulaŋ siŋgilaeqnub. Qotei agi laŋ qureq di unu. ");
INSERT INTO boj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Niŋgi quiy. Qotei aqa medabu o qaji tamo Elaija a olo bqas. Anjam di neŋgreŋq di unu. Elaija agi bej. E Jon qa merŋgwa osimqa Elaija aqa ñam na yawo anjam merŋgeqnum. Niŋgi ijo anjam di quqwa are soqnimqa quiy. ");
INSERT INTO boj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tamo a dabkala ti sqas di a ijo anjam di geregere quem. ");
INSERT INTO boj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra qa e yawo anjam kiyersiy marqai? E naŋgo kumbra qa endegsi marqai. Naŋgi aŋgro du du bul qure ambleq di alaŋoqnsib aŋgro qudei na qudei minjreqnub, ");
INSERT INTO boj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Iga yumba anjamonumqa niŋgi lou tuosai. Iga are uge qa louonumqa niŋgi akamosai.’” ");
INSERT INTO boj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Osiqa Yesus a olo marej, “Jon a bosiqa iŋgi ti wain ti uratosiq sonaqa tamo naŋgi a qa maroqneb, ‘A mondor uge ti unu.’ ");
INSERT INTO boj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ariya e Tamo Aŋgro bosimqa iŋgi ti wain ti uyeqnamqa tamo naŋgi e nuboqnsib mareqnub, ‘Niŋgi uniy. Yesus a qunjaŋ ani. A wain uyo ani. A takis o qaji tamo ti une tamo ti naŋgi koba na walweleqnub.’” Osiqa Yesus a olo marej, “Qotei aqa tamo uŋgasari naŋgi aqa wau kalil unoqnsib dena naŋgi bole qalieeqnub, aqa powo tulaŋ kobaquja.” ");
INSERT INTO boj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Qure qudei Yesus a dia maŋwa gargekoba yoqnej qaji naŋgi are bulyosai deqa a naŋgi qa ŋiriŋej. ");
INSERT INTO boj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Osiqa minjrej, “O Korasin qure ti Betsaida qure ti, niŋgi tulaŋ padalougetqab. Di kiyaqa? Maŋwa e nuŋgoq di yoqnem qaji di Tair qure ti Saidon qure ti naŋgoq di brantej qamu naŋgi nami are bulyosib are uge qa gara jigsib ŋam sumq di awoeb qamu. ");
INSERT INTO boj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Deqa e niŋgi endegsi merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgo une qa peginjrqa batiamqa a na niŋgi tulaŋ padaltŋgougetqas. Qotei na Tair qure ti Saidon qure ti naŋgi degsim padaltnjrqasai. A naŋgi gulbe kiñala enjrqas. ");
INSERT INTO boj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","O Kaperneam tamo uŋgasari, niŋgi laŋ qureq oqwa kere e? Keresai. Qotei na niŋgi breiŋgimqa moiyo qureq aiqab. Di kiyaqa? Maŋwa e nuŋgoq di yoqnem qaji di Sodom qure naŋgoq di brantej qamu naŋgi bini unub qamu. Naŋgi padalosai qamu. ");
INSERT INTO boj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Deqa e niŋgi endegsi merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgo une qa peginjrqa batiamqa a na niŋgi tulaŋ padaltŋgougetqas. Qotei na Sodom qure naŋgi degsim padaltnjrqasai. A naŋgi gulbe kiñala enjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bati deqa Yesus a endegsi Qotei pailyej, “O Abu, ni segi laŋ qa ti mandam qa ti Koba. E ino ñam soqteqnum. Di kiyaqa? Ni ijo anjam kalil powo tamo naŋgi qa ulitoqnsimqa tamo naŋgi aŋgro du du bul unub qaji naŋgi segi qa babteqnam naŋgi poinjreqnu. ");
INSERT INTO boj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Od, Abu, ni ino segi areqalo dauryosim agi degyeqnum.” ");
INSERT INTO boj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus a degsi Qotei pailyej. Osiqa marej, “Ijo Abu na iŋgi iŋgi kalil ijo baŋq di ateleŋej unu. E segi Qotei aqa Ŋiri. Tamo bei a e qa qaliesai. Ijo Abu a segi e qa qalie. Tamo bei a ijo Abu qa qaliesai dego. E segi ijo Abu qa qalie. E na tamo qudei naŋgi ijo Abu osornjrqa areibqas di osornjrqai. Yim naŋgi dego ijo Abu qa qalieqab. ");
INSERT INTO boj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Niŋgi gulbe qoboiyoqnsib waukobaeqnub qaji niŋgi kalil ijoq babqa e na aqaryaiŋgitqa niŋgi aqaratqab. ");
INSERT INTO boj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","E ijo segi ñam aguq atoqnsim tamo naŋgi lawo kumbra enjreqnum. Deqa niŋgi e qa geregere qalieosib ijo anjam dauryoqniy. Yim niŋgi aqaratqab. ");
INSERT INTO boj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Niŋgi ijo anjam dauryqajqa di gulbe sai. Di oto. Wau e na niŋgi eŋgeqnum qaji di dego gulbe sai. Di oto.” ");
INSERT INTO boj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yori bati bei Yesus aqa aŋgro naŋgi ti wau ambleq na giloqnsibqa aqa aŋgro naŋgi mamnjrnaqa bem sum gei eleŋoqnsib uye uye giloqneb. ");
INSERT INTO boj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naŋgi degsib gileqnabqa Farisi qudei naŋgi bosib naŋgi unjrsib Yesus minjeb, “Ni une. Ino aŋgro naŋgi gago dal anjam groteqnub. Yori bati qa kumbra degyo di getento koba.” ");
INSERT INTO boj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Onaqa Yesus na kamba Farisi naŋgi minjrej, “Nami Devit aqa wau tamo naŋgi ti mamnjrnaqa kumbra yeb qaji di niŋgi buk miligiq di sisiyosai kiyo? ");
INSERT INTO boj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit a atra tal miligiq gilsiqa Qotei atraiyqajqa bem osiqa aqa wau tamo naŋgi koba na uyeb. Bem di getento. Di atra tamo naŋgo segi uyqajqa bem. Devit a degyej di a dal anjam grotej. Ariya a Qotei aqa ŋamgalaq di une saiqoji. ");
INSERT INTO boj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dal anjam bei dego neŋgreŋq di unu. Anjam agiende. Atra tamo naŋgi yori bati gaigai atra tal miligiq di waueqnub. Naŋgo kumbra dena naŋgi dal anjam groteqnub. Ariya naŋgi Qotei aqa ŋamgalaq di une saiqoji. Niŋgi anjam di nami buk miligiq di sisiyosai kiyo? ");
INSERT INTO boj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ariya e niŋgi endegsi merŋgwai. Bini tamo bei atra tal tulaŋ buŋyejunu qaji a nuŋgo ambleq di unu. ");
INSERT INTO boj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Qotei aqa anjam bei dego nami endegsib neŋgreŋyeb unu, ‘Niŋgi e laŋa atraibeqnub. E nuŋgo kumbra deqa arearetbosaieqnu. Niŋgi tamo naŋgi qa duloqnsib kumbra bole bole enjroqnqab di e tulaŋ arearetbqas.’ O Farisi, niŋgi Qotei aqa anjam di sisiyosib poiŋgo qamu niŋgi tamo une saiqoji naŋgi gulbe enjrosai qamu. ");
INSERT INTO boj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","E Tamo Aŋgro. Deqa e segi na yori bati taqatejunum. E segi yori bati aqa Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Onaqa Yesus a dena walwelosiqa qure beiq di brantosiqa Juda naŋgo Qotei tal miligiq gilej. ");
INSERT INTO boj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Qotei tal miligiq di tamo bei baŋ qandamyej qaji a soqnej. Deqa tamo qudei naŋgi Yesus aqa jejamuq di anjam laŋa qametqa marsibqa endegsib nenemyeb, “Iga yori bati qa tamo boletqom di kere kiyo? Dal anjam a kiyersi marqo?” ");
INSERT INTO boj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Onaqa Yesus na kamba minjrej, “Tamo bei aqa kaja a yori bati qa uloŋosim subq aiyimqa a uratqasai. A na aqaryaiyosim olo subq dena osim goge atqas. Di niŋgi qalie. ");
INSERT INTO boj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ariya tamo naŋgi kaja sai. Naŋgi tamo qunuŋ ti. Deqa iga yori bati qa tamo aqaryaiyim a bole sqas di kumbra bole.” ");
INSERT INTO boj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesus a naŋgi degsi minjrsiqa tamo baŋ qandamyej qaji di minjej, “Ni ino baŋ waiy.” Degsi minjnaqa aqa baŋ waiyonaq boleej. Aqa baŋ bei ombla na kerekereeb. ");
INSERT INTO boj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Onaqa Farisi naŋgi Qotei talq dena oqedosib naŋgi gam kiyersib Yesus qalib moiqajqa deqa qairoqneb. ");
INSERT INTO boj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Farisi naŋgi Yesus qalqajqa qairoqneb di qalieosiqa qure di uratosiq walwelosiq gilej. A gileqnaqa tamo uŋgasari gargekoba naŋgi a dauryeqnab a naŋgo ma tamo kalil naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Osiqa a na naŋgi saidnjroqnej, “Niŋgi ijo ñam ubtosib maraib.” ");
INSERT INTO boj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesus a kumbra di yej deqa anjam bei Qotei aqa medabu o tamo Aisaia nami marej qaji di aqa damu brantej. A anjam endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Endi ijo wau tamo e segi na giltem qaji. E a tulaŋ qalaqalaiyeqnum. E a qa areboleboleibeqnu. E ijo Mondor aqaq di atitqa a na sawa bei bei qaji naŋgi endegsim minjroqnqas, ‘Niŋgi kumbra bole dauryiy.’ ");
INSERT INTO boj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A ŋiriŋ anjam maroqnqasai. A leleŋkobaoqnqasai. Gamq di tamo uŋgasari naŋgi aqa kakro quoqnqasai. ");
INSERT INTO boj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Silai aqa baŋga geŋqa laqnimqa a na torei gentqasai. Waŋal aqa puloŋ kiñalaamqa a na torei mosotqasai. A degsim lawo na wauoqnsim gilsim gilsim kumbra bole torei siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yimqa sawa bei bei qaji naŋgi a qa naŋgo areqalo siŋgilatosib a na naŋgi aqaryainjrqajqa deqa tariŋoqnsib sqab.” ");
INSERT INTO boj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Onaqa bati di tamo bei mondor uge na medabu getentosiq ŋam qandimyej qaji a soqnej. Sonaqa tamo qudei na a osib Yesus aqa areq beb. Bonabqa Yesus na mondor uge di wiyetonaqa aqa meŋ otyonaqa aqa ŋamdamu boleosiq a sawa unsiqa anjam bole maroqnej. ");
INSERT INTO boj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsibqa tulaŋ prugugetosib maroqneb, “Tamo di a Devit aqa Ŋiri kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Onaqa Farisi naŋgi naŋgo anjam di qusibqa maroqneb, “Sai. Mondor uge naŋgo gate koba Belsebul a Yesus aqa jejamuq di unu. Siŋgila dena a na mondor uge naŋgi winjreqnu.” ");
INSERT INTO boj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Onaqa Yesus a naŋgo areqalo di qalieosiqa yawo anjam bei endegsi minjrej, “Tamo naŋgi sawa qujaiq di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi koba na geregere sqa keresai. Naŋgi niñaqosib koboqab. Tamo naŋgi qure qujai kiyo tal qujai kiyo di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi dego koba na geregere sqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dego kere Satan na aqa segi mondor uge naŋgi winjrqas di naŋgi poaiyelqab. Deqa Satan a kiyersim aqa mondor uge naŋgi olo taqatnjrqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Niŋgi mareqnub, ‘Yesus a Belsebul aqa siŋgila na mondor uge naŋgi winjreqnu.’ Di sai. E Belsebul aqa siŋgila na mondor uge naŋgi winjrqai di yai aqa siŋgila na nuŋgo aŋgro naŋgi mondor uge winjrqab? Deqa naŋgi segi na merŋgwab, niŋgi anjam groteqnub. ");
INSERT INTO boj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ariya e Qotei aqa Mondor aqa siŋgila na mondor uge naŋgi winjrqai di niŋgi endegsi poiŋgwas, ‘Bole, Qotei a gago Mandor Koba sosim iga taqatgwajqa bati brantqo.’ Niŋgi degsi poiŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Tamo bei a kiyersim tamo siŋgila koba bei aqa tal gogetosim aqa iŋgi iŋgi kalil bajiŋqas? E marqai. A mati tamo di sil na tontim soqnimqa di aqa iŋgi iŋgi kalil bajiŋqas. Tontqasai di aqa iŋgi iŋgi bajiŋqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tamo bei na e beterbqasai di a na e jeutbqas. Tamo bei a e ombla wauqasai di a na ijo wau ugetetbqas. ");
INSERT INTO boj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Deqa e niŋgi endegsi merŋgwai. Tamo uŋgasari naŋgo une kalil Qotei na kobotetnjrqas. Naŋgo misiliŋ anjam mareqnub qaji une di dego Qotei na kobotetnjrqas. Ariya naŋgi Qotei aqa Mondor misiliŋyqab une di Qotei na kobotetnjrqasai. ");
INSERT INTO boj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","E Tamo Aŋgro. Tamo a e misiliŋbqas une di Qotei na kobotqas. Ariya tamo a Mondor Bole misiliŋyqas une di Qotei na kobotqasai. Bini bati endeqa Qotei na kobotqasai. Mondoŋ dego Qotei na kobotqasai.” ");
INSERT INTO boj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Osiqa Yesus a olo marej, “Ŋam bole naŋgi gei bole ateqnub. Ŋam uge naŋgi gei uge ateqnub. Deqa tamo naŋgi ŋam aqa gei unsibqa dena poinjrqas, ‘Ŋam di bole. Ŋam di uge.’ ");
INSERT INTO boj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Niŋgi amal uge bul. Niŋgi tamo uge. Deqa niŋgi kiyersib anjam bole maroqnqab? Tamo naŋgo areqalo kalil naŋgo are miligiq na oqoqnsiq medabuq na branteqnu. ");
INSERT INTO boj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamo bole naŋgo are miligi di areqalo bole na maqejunu. Deqa naŋgi kumbra bole yeqnub. Ariya tamo uge naŋgo are miligi di areqalo uge na maqejunu. Deqa naŋgi kumbra uge yeqnub. ");
INSERT INTO boj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Deqa e niŋgi endegsi merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgi peginjrqa batiamqa naŋgo anjam kalil naŋgi laŋa laŋa mareqnub qaji di Qotei na naŋgo jejamuq di qametnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ino anjam boleamqa Qotei na mermqas, ‘Ni tamo bole.’ Ino anjam ugeamqa Qotei na mermqas, ‘Ni tamo uge.’” ");
INSERT INTO boj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Onaqa dal anjam qalie tamo qudei ti Farisi qudei ti naŋgi na kamba Yesus minjeb, “O Qalie Tamo, ni Qotei aqa maŋwa bei babtim iga unqom.” ");
INSERT INTO boj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Onaqa Yesus na kamba minjrej, “Tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra tulaŋ ugedamu. Naŋgi Qotei areiyosaieqnub. Naŋgi gaigai ijo maŋwa laŋa unqajqa metbeqnub. Deqa e na ijo maŋwa bei naŋgi osornjrqasai. Qotei aqa medabu o tamo Jona aqa maŋwa segi osornjritqa naŋgi unqab. ");
INSERT INTO boj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Agi Jona a bati qalub qolo qalub qe ani aqa miligiq di soqnej. Dego kere e Tamo Aŋgro bati qalub qolo qalub sub miligiq di sqai. ");
INSERT INTO boj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mondoŋ Qotei na tamo uŋgasari naŋgi peginjrqa batiamqa Ninive tamo naŋgi tigelqab. Tigelosibqa tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra uge babtetnjrqab. Naŋgi degyqab. Di kiyaqa? Ninive tamo naŋgi nami Jona aqa anjam qusib are bulyeb deqa. Ariya bini tamo bei Jona tulaŋ buŋyejunu qaji a nuŋgo ambleq di unu. ");
INSERT INTO boj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mondoŋ Qotei na tamo uŋgasari naŋgi peginjrqa batiamqa uŋa mandor nami guta di sawa taqatoqnej qaji a dego tigelqas. Tigelosimqa tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra uge babtetnjrqas. A degyqas. Di kiyaqa? Uŋa di a nami Solomon aqa powo kobaquja unqa marsiqa sawa isaq na walwelosi bej deqa. Ariya bini tamo bei Solomon tulaŋ buŋyejunu qaji a nuŋgo ambleq di unu.” ");
INSERT INTO boj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Osiqa Yesus a olo marej, “Mondor uge a tamo bei aqa jejamuq dena ulaŋosim sawa kaŋgraŋoq gilqas. Gilsim dia laqnsimqa aqaratqajqa sawa ŋamam ugeiyim marqas, ");
INSERT INTO boj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","45","‘E olo puluosiy ijo tal uratem qaji deq olo aiqai.’ A degsi marsimqa aisim tal di laŋa unu degsim unqas. Tal di nami maŋ solsib iŋgi iŋgi kalil gereiyeb milalejunu di unsimqa olo puluosim gilsim mondor uge 7 tulaŋ ugedamu naŋgi joqsim bosim koba na tal dia sqab. Soqnibqa tamo di aqa so tulaŋ ugeqas. Aqa so uge namij degwasai. Aqa so olo tulaŋ ugedamuqas. Dego kere tamo uŋgasari bini bati endeqa kumbra uge uge yeqnub qaji naŋgi degsib sougetesqab.” ");
INSERT INTO boj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus na tamo uŋgasari gargekoba naŋgi anjam degsi minjreqnaqa aqa was naŋgi aqa ai koba na Yesus qa bosib talq di iteb. Yesus a warum miligiq di sonaqa naŋgi na anjam bei minjqajqa deqa oqeq di tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Onaqa tamo bei na Yesus minjej, “Ni que. Ino was naŋgi ino ai ombla na ni anjam bei mermqa bonub agi oqeq di tigelejunub.” ");
INSERT INTO boj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Onaqa Yesus na kamba minjej, “Ijo ai ijo was naŋgi tal qabe?” ");
INSERT INTO boj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Degsi minjsiqa aqa baŋ na aqa segi aŋgro naŋgi osoryosiqa minjej, “Ni une. Ijo ai ijo was naŋgi agide. ");
INSERT INTO boj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tamo a ijo Abu laŋ qureq di unu qaji aqa areqalo dauryoqnqas di a ijo was bole. A ijo jaja. A ijo ai.” ");
INSERT INTO boj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bati deqa Yesus a tal uratosiqa alile aisiq ya agu qalaq di awoej. ");
INSERT INTO boj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Onaqa tamo uŋgasari tulaŋ gargekoba naŋgi bosib aqa areq di koroonabqa a sasalosiqa qobuŋ gogetosiq di awoej. Awesonaqa tamo uŋgasari kalil naŋgi alile di tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tigelesonabqa a na yawo anjam gargekoba naŋgi minjroqnej. Yawo anjam bei endegsi minjrej, “Niŋgi quiy. Tamo bei a gilsiqa aqa iŋgi wauq di saga yago breiyeleŋej. ");
INSERT INTO boj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Breiyonaqa saga yago qudei gam qalaq aiyeleŋeb. Ainabqa qebari naŋgi bosib uyekriteb. ");
INSERT INTO boj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Saga yago qudei mandam lanjaq di aiyeleŋeb. Mandam di guma meniŋ ti. Gogeq di mandam kiñala. Deqa saga yago aiyeleŋosib urur oqoqujateb. ");
INSERT INTO boj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Naŋgo jirim tulaŋ guma aiyosai deqa seŋ oqsiq kaŋkaŋonaqa naŋgi laosib moreŋeb. ");
INSERT INTO boj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Saga yago qudei sil luwit ambleq di aiyeleŋeb. Dena oqeb qaji sil luwit na dego dauryosiq oqsiq kabutnjrnaq geitosai. ");
INSERT INTO boj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Saga yago qudei mol mandam boledamuq di aiyeb. Di aisib oqoboledamuyosib gei tulaŋ gargekoba ateleŋeb. Qudei 100. Qudei 60. Qudei 30. ");
INSERT INTO boj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Onaqa Yesus aqa aŋgro naŋgi aqa yawo anjam di qusibqa naŋgi aqa areq bosib nenemyeb, “Ni kiyaqa tamo uŋgasari naŋgi yawo anjam minjreqnum?” ");
INSERT INTO boj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Onaqa Yesus na kamba minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Anjam di aqa utru uliejunu. Di Qotei na babtimqa ijo aŋgro niŋgi segi utru qalieqab. Ariya a na tamo uŋgasari laŋaj naŋgi yawo anjam aqa utru osornjrqasai. ");
INSERT INTO boj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tamo a powo ti sqas di Qotei na powo olo yimqa a powo koba oqas. Ariya tamo a powo ti sqasai di powo kiñala aqaq di unu qaji di Qotei na olo yaiyimqa a laŋa sqas. ");
INSERT INTO boj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tamo uŋgasari naŋgi di ŋam atoqnsib ijo anjam aqa damu unosaieqnub. Naŋgi dab atoqnsib ijo anjam aqa utru quosaieqnub. Osib poinjrosaieqnu. Deqa e na naŋgi yawo anjam segi minjreqnum. ");
INSERT INTO boj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Naŋgo kumbra dena anjam bei Qotei aqa medabu o tamo Aisaia nami marej qaji di aqa damu branteqnu. A endegsi marej, ‘Niŋgi dab atoqnqab di ijo anjam aqa utru poiŋgwasai. Niŋgi ŋam atoqnqab di ijo anjam aqa damu dego poiŋgwasai. ");
INSERT INTO boj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tamo uŋgasari di naŋgo are miligi geteŋnjrejunu. Naŋgo dabkala na ijo anjam quqwajqa asginjreqnu. Naŋgi ŋam bruŋejunub. Deqa naŋgo ŋamdamu na ijo kumbra unqasai. Naŋgo dabkala na ijo anjam qusib utru poinjrqasai. Naŋgi are bulyosib ijoq bqasai dego. Deqa e na naŋgi boletnjrqasai.’ Qotei a nami degsi marej. ");
INSERT INTO boj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“O ijo aŋgro, niŋgi nuŋgo ŋamdamu na ijo kumbra uneqnub. Nuŋgo dabkala na ijo anjam queqnub. Deqa niŋgi tulaŋ areboleboleiŋgem. ");
INSERT INTO boj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","E bole merŋgwai. Nami Qotei aqa medabu o tamo naŋgi ti tamo bole bole naŋgi ti gargekoba kumbra niŋgi bini uneqnub qaji di unqajqa are koba soqnej. Ariya naŋgi unosaioqneb. Anjam niŋgi bini queqnub qaji di dego naŋgi quqwajqa are koba soqnej. Ariya naŋgi quosaioqneb.” ");
INSERT INTO boj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Osiqa Yesus a olo marej, “Saga yago qa yawo anjam e maronum di aqa utru e na babtitqa niŋgi quiy. ");
INSERT INTO boj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Saga yago qudei gam qalaq ainabqa qebari naŋgi bosib uyekriteb di aqa utru endegsi unu. Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Anjam di tamo qudei naŋgi qusibqa ariya naŋgi geregere poinjrosai. Deqa Satan a bosim anjam di olo yainjrqas. Qotei na naŋgo are miligiq di anjam di atej ariya Satan a bosim olo yainjrqas. ");
INSERT INTO boj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Saga yago qudei mandam lanjaq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib tulaŋ areboleboleinjrimqa anjam di oqujatosib naŋgo areq atqab. ");
INSERT INTO boj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ariya anjam di naŋgo are miligiq tulaŋ guma aiyosai. Deqa sokiñala Qotei aqa anjam gotraŋyo qaji tamo qudei na bosib naŋgi gulbe enjrsib ugeugeinjrqab. Yimqa naŋgo areqalo Yesus qa siŋgilateqnub qaji di naŋgi olo ulontqab. ");
INSERT INTO boj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Saga yago qudei sil luwit ambleq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusibqa ariya bunuqna naŋgi olo mandam qa iŋgi iŋgi qa are koba qaloqnsib ñoro koba oqajqa are prugnjroqnqas. Yimqa kumbra dena naŋgi gisaŋnjrsim Qotei aqa anjam naŋgo are miligiq di tentim loumqas. Saga yago uge naŋgi gei bole atosaieqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Saga yago qudei mol mandam boledamuq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib geregere poinjrimqa naŋgo are miligiq di siŋgilatqab. Deqa Qotei aqa anjam di naŋgo are miligiq di saga bul tulaŋ kobaqas. Qudei 100. Qudei 60. Qudei 30.” ");
INSERT INTO boj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Osiqa Yesus a olo yawo anjam bei tamo uŋgasari naŋgi endegsi minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo bei a gilsiqa aqa iŋgi wauq di bem sum yageleŋej dego kere. ");
INSERT INTO boj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bem sum yageleŋonaqa qolo tamo uŋgasari naŋgi ŋereŋesonabqa jeu tamo bei a bosiqa bem sum yago ambleq di pilagiŋ yago dego breiyej. Breiyosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ariya bunuqna bem sum oqsib geiteleŋonabqa pilagiŋ na dego dauryosiq oqej. ");
INSERT INTO boj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Deqa kaŋgal tamo naŋgi na bosib unsibqa wau lanja minjeb, ‘O Tamo Koba, ni bem sum segi yagem. Deqa kiyaqa bem sum oqsib geitonubqa pilagiŋ dego dauryosib oqonub?’ ");
INSERT INTO boj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Onaqa wau lanja na kamba minjrej, ‘Jeu tamo bei a bosiq pilagiŋ yago breiyej.’ Degsi minjrnaqa naŋgi na kamba minjeb, ‘O Tamo Koba, ni marimqa iga pilagiŋ di otoreleŋqom.’ ");
INSERT INTO boj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Onaqa minjrej, ‘Niŋgi pilagiŋ otoraib. Niŋgi otorqab di bem sum ti turtosib otoro uge. ");
INSERT INTO boj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Deqa niŋgi uratib soqneb. Bem sum ti pilagiŋ ti koba na oqsib geiteleŋabqa e na ijo wau tamo qudei naŋgi endegsi minjrqai, “Niŋgi pilagiŋ otorosib ruwoeleŋosib ŋamyuwoq di koitiy. Koitosib bem sum olo osib ijo talq di ateleŋiy.” ’” ");
INSERT INTO boj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Osiqa Yesus a olo yawo anjam bei endegsi minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo bei na sis yago osiq aqa wauq di yagej dego kere. ");
INSERT INTO boj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sis yago naŋgi tulaŋ kiñilala kas yago bul. Iŋgi iŋgi qudei naŋgo yago kokba yala. Sis yago naŋgi tulaŋ kiñilala. Ariya sis yago di tamo bei na osim aqa wauq di yagimqa bunuqna a oqsim tulaŋ kobaqujaqas. Osim ŋam qudei buŋnjrsim dani kokba ateleŋqas. Amqa qebari naŋgi bosib aqa daniq di simi ateleŋqab.” ");
INSERT INTO boj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Osiqa Yesus a olo yawo anjam bei endegsi minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di bem tiyeqnu qaji sum bul. Uŋa bei a bem tiyeqnu qaji sum kiñala osiqa bem sum laŋaj ti turtosiq web kobaqujaq di bulyonaqa bem kalil tiyekritej.” ");
INSERT INTO boj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus a na tamo uŋgasari naŋgi yawo anjam gargekoba deqaji minjroqnej. A anjam bei minjrosaioqnej. Yawo anjam segi minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A kumbra di yej deqa anjam bei Qotei aqa medabu o tamo bei nami marej qaji di aqa damu brantej. A endegsi marej, “E yawo anjam tamo uŋgasari naŋgi minjroqnqai. Tulaŋ nami yawo anjam di aqa utru uliesoqnej. Sosiq agi bini uliejunu. Deqa e na ubtosiy maroqnqai.” ");
INSERT INTO boj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Osiqa Yesus na tamo uŋgasari naŋgi uratnjrsiqa tal gogetosiq di sonaqa aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, ni na pilagiŋ qa yawo anjam di aqa utru geregere plaltosim merge.” ");
INSERT INTO boj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Onaqa Yesus na minjrej, “Tamo bem sum yagej qaji di agi e segi. E Tamo Aŋgro. ");
INSERT INTO boj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Bem sum aqa wau di mandam endi. Bem sum yago di tamo uŋgasari Qotei na taqatnjreqnu qaji naŋgi. Pilagiŋ yago di Satan aqa segi tamo uŋgasari naŋgi. ");
INSERT INTO boj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jeu tamo pilagiŋ yago breiyej qaji di Satan. Bem sum geiteleŋo bati di diŋo bati. Wau tamo bem sum otoreleŋeb qaji di laŋ aŋgro naŋgi. ");
INSERT INTO boj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Deqa niŋgi quiy. Wau tamo naŋgi bosib pilagiŋ otorosib ŋamyuwoq di koiteleŋeb dego kere laŋ aŋgro naŋgi diŋo bati qa kumbra degyqab. ");
INSERT INTO boj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bati deqa e Tamo Aŋgro na ijo laŋ aŋgro naŋgi qariŋnjritqa aisib iŋgi uge uge kalil tamo naŋgi uneq breinjreqnub qaji naŋgi ti tamo kalil kumbra uge uge yeqnub qaji naŋgi ti pilagiŋ bul breinjrib ŋamyuwo kobaq aiqab. Deqa Qotei a naŋgo Mandor Koba sqasai. Osim naŋgi taqatnjrqasai dego. ");
INSERT INTO boj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Naŋgi ŋamyuwo kobaq aisib dia akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas. ");
INSERT INTO boj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bati deqa tamo uŋgasari kumbra bole bole yeqnub qaji naŋgo Abu Qotei na naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Deqa naŋgi seŋ bul tulaŋ suwaŋesqab. Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Osiqa Yesus a olo marej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo qudei na silali kobaquja osib ŋam moŋgum miligiq di ateb dego kere. Atsib nañu agu beiq di sub bogsib sub miligiq di ŋam moŋgum uliteb. Onaqa tamo bei na bosiq ŋam moŋgum di itosiq tulaŋ areboleboleiyej. Deqa a ŋam moŋgum di olo subq di mororyosiq gilsiq aqa iŋgi iŋgi kalil qariŋyosiq dena silali osiq nañu agu di awaiyej.” ");
INSERT INTO boj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Osiqa Yesus a olo marej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di iŋgi iŋgi qariŋyo tamo bei a kolilei qa ŋamoqnej dego kere. ");
INSERT INTO boj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A gilsiq kolilei tulaŋ boledamu bei itosiq olo puluosi bosiq aqa iŋgi iŋgi kalil qariŋyosiq dena silali osiq kolilei di awaiyej.” ");
INSERT INTO boj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Osiqa Yesus a olo marej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo naŋgi yuwalq di kakaŋ waiyosib qe gargekoba utru segi segi eleŋeb dego kere. ");
INSERT INTO boj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kakaŋ maqonaqa tamo naŋgi na titosib bosib ululq di goge atsib awoosib qe bole bole gumbaq di jigeleŋeb. Osib qe uge uge uratosib qalaq di breinjreb. ");
INSERT INTO boj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Kumbra deqaji diŋo bati qa brantqas. Laŋ aŋgro naŋgi bosib tamo bole bole naŋgi eleŋqab. Osib tamo uge uge naŋgi breinjribqa ŋamyuwoq aiqab. Ŋamyuwo koba dia naŋgi akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas.” ");
INSERT INTO boj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Osiqa Yesus na aqa aŋgro naŋgi endegsi nenemnjrej, “Yawo anjam kalil merŋgonum qaji endi niŋgi utru poiŋgwo e?” Onaqa naŋgi na minjeb, “Od.” ");
INSERT INTO boj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Onaqa Yesus na olo minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Anjam di dal anjam qalie tamo qudei naŋgi poinjreqnu. Poinjreqnu qaji naŋgi tal aqa abu bul sqab. Deqa naŋgi naŋgo talq dena ñoro bunuj ti ñoro namij ti eleŋoqnsib oqeq atoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus a yawo anjam di kalil marsiq koboonaqa a sawa di uratej. ");
INSERT INTO boj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Osiqa aqa segi qure utruq gilsiq di sonaqa yori batiej. Deqa a Juda naŋgo Qotei tal miligiq gilsiqa tamo uŋgasari gargekoba sonab tigelosiqa Qotei aqa anjam palontosiq minjroqnej. Minjreqnaqa tamo uŋgasari naŋgi aqa anjam qusibqa tulaŋ prugugetosib maroqneb, “Yesus a powo qabe na osiqa anjam siŋgila deqaji palontosiq mergeqnu? A kiyersiq maŋwa deqaji babteleŋeqnu? ");
INSERT INTO boj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aqa abu a laŋa tal gereiyo qaji tamo. A Maria aqa ŋiri. A Jems na Josep na Saimon na Judas na naŋgo was. ");
INSERT INTO boj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aqa jaja kalil naŋgi agi iga koba na endi unum. Deqa a kiyersiq maŋwa deqaji babteleŋeqnu?” ");
INSERT INTO boj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naŋgi degsib yomu anjam marsib Yesus qa ugeeb. Onaqa a na minjrej, “Qotei aqa medabu o qaji tamo bei aqa segi qure utruq gilsim anjam minjroqnqas di naŋgi aqa anjam quetqa asginjrqas. Deqa a ñam saiqoji sqas. Aqa segi talq di dego a ñam saiqoji sqas. Ariya a qure bei beiq giloqnsim anjam minjroqnqas di naŋgi aqa anjam quetoqnsib aqa ñam soqtoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesus na tamo uŋgasari naŋgi degsi minjrej. Aqa segi qure utruq di a maŋwa gargekoba yosai. Di kiyaqa? Naŋgi a qa naŋgo areqalo siŋgilatosai deqa. ");
INSERT INTO boj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bati deqa tamo uŋgasari naŋgi Yesus qa saosib laqnabqa Mandor Herot a quej. ");
INSERT INTO boj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Qusiqa aqa wau tamo naŋgi minjrej, “Tamo di a Jon yansnjro qaji. A moisiq olo subq na tigelqo. A deqa siŋgila osiqa maŋwa babteleŋeqnu.” ");
INSERT INTO boj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot a nami aqa was Filip aqa ŋauŋ Herodias yaiyosiq ej. Deqa Jon na Herot minjoqnej, “Ni ino segi was aqa uŋa em di kumbra bolesai. Ni kumbra ugeteqnum.” Jon na Herot degsi minjoqnej. Deqa Herot a Jon qa minjiŋ oqetonaqa aqa qaja tamo qudei qariŋnjrnaqa gilsib Jon ojsib sil na qosisib tonto talq di waiyeb. ");
INSERT INTO boj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jon a tonto talq di sonaqa Herot a endegsi are qaloqnej, “E Jon qalit moiqas.” Ariya tamo uŋgasari kalil naŋgi maroqneb, “Jon a Qotei aqa medabu o qaji tamo bole.” Naŋgi degsib maroqneb deqa Herot a naŋgi ulainjrsiq Jon qalqa uratej. ");
INSERT INTO boj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ariya bati bei Herot a Jon qalim moiqajqa gam endegsi itej. Aqa ŋambabo bationaqa a na maruro atsiqa tamo qudei naŋgi metnjrnaq bosib aqa talq di koroeb. Koroosib iŋgi uyeqnabqa Herot aqa ŋauŋ aqa aŋgro sebiŋ a warum miligiq bosiqa naŋgi lou tuetnjroqnej. Onaqa Herot a di unsiqa tulaŋ areboleboleiyej. ");
INSERT INTO boj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Deqa a na aŋgro sebiŋ di minjej, “Ni ijo iŋgi kiye oqajqa merbqam e ni emqai.” Osiqa aqa anjam di olo siŋgilatosiq minjej, “Ijo anjam di e bole dauryqai. E uratqasai bole sai.” ");
INSERT INTO boj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Onaqa aŋgro sebiŋ aqa ai na minjej, “Ni Jon aqa gate qa Herot minje.” Onaqa aŋgro sebiŋ na Herot minjej, “Ni Jon yansnjro qaji aqa gate tabirq di atsim ebe.” ");
INSERT INTO boj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Onaqa Herot a Jon qalim moiqajqa are sosai deqa a are tulaŋ gulbekobaiyej. Ariya aqa segi anjam tamo kalil naŋgo ulatamuq di marsiq siŋgilatej qaji deqa are qalsiqa aŋgro sebiŋ di minjej, “Di kere.” ");
INSERT INTO boj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Osiqa aqa qaja tamo bei qariŋyonaq gilsiqa tonto talq di Jon aqa kakro gentetej. ");
INSERT INTO boj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Osiqa aqa gate tabirq di atsiqa osi bosiq aŋgro sebiŋ di yonaqa a na osi gilsiqa aqa ai yej. ");
INSERT INTO boj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Onaqa bunuqna Jon aqa aŋgro naŋgi deqa qusibqa bosib Jon aqa qusa osi gilsib subq ateb. Osib Yesus aqa areq gilsib minjeb, “Herot na Jon qalnaq moiyej.” ");
INSERT INTO boj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Onaqa Yesus a anjam di qusiqa a sawa di uratosiq qobuŋ bei gogetosiqa wadau sawaq gilej. Aqa aŋgro naŋgi ti gileb. A gileqnaqa tamo uŋgasari kalil naŋgi deqa qusibqa naŋgo segi segi qureq na tigelosib siŋga na gurgurosib Yesus ŋamqajqa gileb. ");
INSERT INTO boj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Onaqa Yesus a qobuŋ na gilsiq tiryosiqa ŋam atej di tamo uŋgasari tulaŋ gargekoba naŋgi nami tiryqa sawaq di tariŋesonab unjrej. Unjrsiqa a naŋgi qa are ugeiyej. Deqa a naŋgo areq aisiqa naŋgo ma tamo kalil boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Onaqa seŋ aisiq bilaqtonaqa Yesus aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, endi wadau sawa. Seŋ aiqo. Qoloqas. Deqa ni na tamo uŋgasari naŋgi minjrimqa qure qureq gilsib di iŋgi awaiyosib uyqab.” ");
INSERT INTO boj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Onaqa Yesus na minjrej, “Naŋgi kiyaqa qure qureq gilqab? Niŋgi segi na iŋgi anainjriy.” ");
INSERT INTO boj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Degsi minjrnaqa naŋgi na kamba minjeb, “Iga iŋgi sai. Iga bem 5 qe aiyela segi unu.” ");
INSERT INTO boj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Onaqa Yesus na minjrej, “Bem ti qe ti di ijoq osib boiy.” ");
INSERT INTO boj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Onaqa naŋgi bem ti qe ti di osi bosib Yesus yonabqa a na tamo uŋgasari kalil naŋgi minjrej, “Niŋgi kalil ñiŋq di awoeleŋoiy.” Onaqa naŋgi kalil awoonabqa Yesus na bem 5 ti qe aiyel ti di osiqa laŋ goge tarosiq Qotei pailyej. Pailyo koboonaqa bem ti qe ti giŋgeŋyosiqa aqa aŋgro naŋgi enjrnaqa naŋgi na osi giloqnsibqa tamo uŋgasari naŋgi jeisib enjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Uynab kalil menetnjrej. Onaqa iŋgi oto urateleŋeb qaji di Yesus aqa aŋgro naŋgi na koroiyosib gumba kokba 12 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tamo kalil bem ti qe ti uyeb qaji naŋgi sisiyeb 5,000. Ariya uŋgasari ti aŋgro du du ti naŋgi sisiyosai. ");
INSERT INTO boj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi qobuŋ gogetosib namoosib gilsib ya agu taqal beiq di tiryosib soqniy. E na tamo uŋgasari naŋgi minjritqa naŋgo qure qureq jaraiyoqnib e bqai.” ");
INSERT INTO boj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Onaqa Yesus aqa aŋgro naŋgi namoosib qobuŋ na gileqnabqa Yesus na tamo uŋgasari naŋgi minjrnaq jaraiyeqnabqa a segi Qotei pailyqa marsiq manaq oqej. Oqsiq a segi mana goge di sonaqa bilaqtej. ");
INSERT INTO boj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Onaqa aqa aŋgro naŋgi qobuŋ na gileqnabqa ya agu ambleq di jagwa koba tigelosiqa ya korkortosiqa naŋgi pulutnjrej. ");
INSERT INTO boj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nobqolo ambru Yesus a aqa aŋgro naŋgoq bosiqa ya baŋgaq na walwelosiqa naŋgi daurnjrsiq gilej. ");
INSERT INTO boj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Onaqa naŋgi ŋam ateb di Yesus a ya baŋgaq na walwelosiq naŋgo areq beqnaqa unsib mareb, “Di buga beqnu.” Osib naŋgi tulaŋ ulaugetosib leleŋkobaeb. ");
INSERT INTO boj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Onaqa Yesus na minjrej, “Nuŋgo are siŋgilatiy. Endi e beqnum. Ulaaib.” ");
INSERT INTO boj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Onaqa Pita na minjej, “O Tamo Koba, ni kiyo beqnum? Ni degam e odbimqa e kamba ya baŋgaq na walwelosiy ino areq bqai.” ");
INSERT INTO boj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Onaqa Yesus na Pita minjej, “Od, endi e. Ni au.” Degsi minjnaqa Pita a qobuŋ uratosiqa ya baŋgaq na walwelosi gilsiq Yesus jojomyej. ");
INSERT INTO boj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yesus jojomyosiqa ŋam atsiq jagwa unsiq ulaej. Ulaosiq tuqoqnsiq maosiq Yesus minjej, “O Tamo Koba, e tuqeqnum. Deqa ni e aqaryaibe.” ");
INSERT INTO boj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Onaqa Yesus na aqa baŋ waiyosiq Pita ojsiq soqtej. Soqtosiq minjej, “Kiyaqa ni areqalo aiyeltonum? Ni e qa ino areqalo siŋgilatqa yonum keresaiimqo.” ");
INSERT INTO boj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Degsi minjsiqa naŋgi aiyel qobuŋ gogetonabqa jagwa laej. ");
INSERT INTO boj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Onaqa tamo qobuŋq di soqneb qaji naŋgi Yesus aqa maŋwa di unsibqa naŋgi aqa ñam soqtosib minjeb, “Bole, ni Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesus aqa aŋgro naŋgi koba na qobuŋ na gilsib ya agu taqal beiq di brantosib Genesaret sawaq di tiryeb. ");
INSERT INTO boj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tiryonabqa qure deqaji naŋgi na Yesus unsibqa aqa ulatamu poinjrej. Poinjrnaqa anjam qariŋyonab qure qure kalil jojom di soqneb naŋgi quoqnsib naŋgo ma tamo naŋgi joqoqnsib Yesus aqa areq osi beleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Beleŋoqnsib Yesus endegsib minjoqneb, “Naŋgi ino gara mutu segi ojibqa naŋgo ma kobooqnqas.” Onaqa Yesus na odnjrnaqa tamo uŋgasari kalil ma ti soqneb qaji naŋgi aqa gara mutu ojoqneb. Ojoqneb qaji kalil naŋgo ma kobooqnej. ");
INSERT INTO boj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Onaqa bati deqa Farisi naŋgi ti dal anjam qalie tamo qudei ti naŋgi Jerusalem dena bosibqa Yesus aqa areq di koroeb. Koroosib minjeb, ");
INSERT INTO boj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ino aŋgro naŋgi kiyaqa gago moma naŋgo kumbra gotraŋyeqnub? Agi naŋgi iŋgi uyqa oqnsib mati baŋ yansosaisosib laŋa uyeqnub.” ");
INSERT INTO boj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Onaqa Yesus na kamba minjrej, “Niŋgi kiyaqa Qotei aqa dal anjam gotraŋyoqnsibqa olo nuŋgo segi moma naŋgo kumbra dauryeqnub? ");
INSERT INTO boj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Qotei a nami marej, ‘Ni ino ai abu naŋgo sorgomq di geregere sosimqa naŋgo anjam dauryoqne. Tamo bei na aqa ai abu naŋgi misiliŋnjrimqa a qalib moiyem.’ Qotei a nami degsi marej. ");
INSERT INTO boj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ariya niŋgi mareqnub, ‘Tamo bei aqa ai kiyo aqa abu kiyo iŋgi qa truquamqa a na minjqas, “Ijo iŋgi iŋgi ejunum endi e ni emqa kere. Eo. E ni emqasai. E nami Qotei atraiyqa giltem deqa e ni aqaryaimqasai.” ’ ");
INSERT INTO boj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A degsi minjqas di niŋgi marqab, ‘A keretqo. A na aqa ai abu naŋgi aqaryainjraiq.’ Niŋgi degsib marqab. Nuŋgo kumbra dena niŋgi Qotei aqa anjam gotraŋyoqnsibqa olo nuŋgo segi moma naŋgo kumbra dauryeqnub. ");
INSERT INTO boj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Niŋgi gisaŋ tamo. Niŋgi anjam maro aiyelteqnub. Qotei aqa medabu o qaji tamo Aisaia a kere niŋgi qa anjam endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tamo naŋgi di naŋgo medabu na ijo ñam soqteqnub. Ariya naŋgo are miligi e qa sosai. Isaq di unu. ");
INSERT INTO boj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naŋgi laŋa babaŋ na e qa loueqnub. Osib mandam tamo naŋgo dal anjam palontoqnsib olo beltoqnsib mareqnub, “Anjam endi Qotei aqa anjam.” ’” ");
INSERT INTO boj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus a Farisi naŋgi anjam degsi minjrsiqa olo tamo uŋgasari kalil naŋgi metnjrnaqa aqa areq bonabqa minjrej, “Niŋgi ijo anjam endi geregere qusib poiŋgem. ");
INSERT INTO boj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tamo bei a iŋgi uyimqa aqa miligiq aiqas dena tamo jiga yqasai. Iŋgi uge uge tamo aqa medabuq na branteqnu qaji dena tamo jiga yeqnu.” ");
INSERT INTO boj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesus na tamo uŋgasari naŋgi anjam degsi minjrsiq koboonaqa aqa aŋgro naŋgi aqa areq bosib minjeb, “Farisi naŋgi ino anjam di qusib ni qa are ugeinjrqo. Di ni qalie e?” ");
INSERT INTO boj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Onaqa Yesus na minjrej, “Ijo Abu laŋ qureq di unu qaji a iŋgi yagobuleqnu. Iŋgi kalil a yagosai qaji di a na jirim qoji otorosim taqal breinjrqas. ");
INSERT INTO boj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Deqa niŋgi Farisi naŋgi uratnjrib soqneb. Naŋgi tamo ŋam qandimo bul unub deqa naŋgi na tamo bei gam osoryqa keresai. Niŋgi qalie, tamo ŋam qandimo bei na tamo ŋam qandimo bei aqa baŋ ojsim ombla walwelqab di ombla maŋgalsib subq aiqab. Farisi naŋgi tamo deqaji bul.” ");
INSERT INTO boj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Onaqa Pita na Yesus minjej, “O Tamo Koba, iŋgi jiga qa yawo anjam ni maronum di aqa utru geregere plaltosim mergim iga quqwom.” ");
INSERT INTO boj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Onaqa Yesus na kamba aqa aŋgro naŋgi endegsi minjrej, “Niŋgi dego ijo yawo anjam di aqa utru poiŋgosai e? ");
INSERT INTO boj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tamo naŋgi iŋgi uyeqnabqa aisiq meneq di unu. Meneq dena bi talq di waiyeqnub. Niŋgi di poiŋgosai kiyo? ");
INSERT INTO boj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iŋgi uge uge tamo aqa are miligiq na oqoqnsiq medabuq na branteqnu qaji dena tamo jiga yeqnu. ");
INSERT INTO boj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iŋgi uge uge di agi ubtosiy merŋgwai. Areqalo uge uge, tamo qaloqa, uŋa qa laoqa, was aqa ŋauŋ anjamyoqa, bajiŋoqa, was aqa jejamu laŋa gisaŋyoqa, was yomuiyoqa. ");
INSERT INTO boj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kumbra uge uge dena tamo jiga yeqnu. Tamo a baŋ yansosaisosim laŋa iŋgi uyqas dena a jiga yqasai.” ");
INSERT INTO boj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Onaqa Yesus a dena tigelosiqa walwelosiq Tair qure ti Saidon qure ti naŋgo sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Gilsiq di sonaqa Kenan qaji uŋa bei a sawa dena brantosiqa Yesus aqa areq bosiqa siŋgila na pailyosiq minjej, “O Tamo Koba, Devit aqa Ŋiri, ni e qa are ugeimeme. Mondor uge na ijo aŋgro sebiŋ a tulaŋ ugeugeiyoqnsiq jaqatiŋ koba yeqnu.” ");
INSERT INTO boj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Onaqa Yesus a uŋa di aqa anjam qusiq quosaibulosiq anjam bei kamba minjosai. A mequmej. Deqa Yesus aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, uŋa di a siŋgila na iga pailgoqnsiqa daurgeqnu. Deqa ni na saidyimqa a puluosim ulaŋqas.” ");
INSERT INTO boj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Onaqa Yesus na minjrej, “Israel naŋgi sougetejunub. Naŋgi kaja bul mandor saiqoji. Qotei na e qariŋbonaq naŋgo segiq bem.” ");
INSERT INTO boj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Onaqa uŋa di a Yesus aqa areq di siŋga pulutosiqa pailyosiq minjej, “O Tamo Koba, ni e aqaryaibe.” ");
INSERT INTO boj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Onaqa Yesus na kamba minjej, “Iga aŋgro du du naŋgo iŋgi yainjrsim olo bauŋ naŋgi anainjrqom di kumbra bolesai.” ");
INSERT INTO boj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Onaqa uŋa dena olo Yesus minjej, “O Tamo Koba, ni kere maronum. Ariya e kamba anjam bei mermit ni que. Aŋgro du du naŋgi iŋgi uyeqnabqa iŋgi ñeŋgi ululoŋeqnaqa bauŋ naŋgi dego uyeqnub.” ");
INSERT INTO boj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Onaqa Yesus a anjam di qusiqa minjej, “O uŋa, ni e qa ino areqalo tulaŋ siŋgilatonum. Osim agi ni na anjam degsi merbonum. Deqa ni gilime. Ino anjam di e na dauryosiy ino aŋgro boletqai.” Degsi minjnaqa bati qujai deqa mondor uge na aqa aŋgro di uratonaqa a boleej. ");
INSERT INTO boj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Onaqa Yesus a sawa di uratosiqa walwelosiq Galili ya aguq di brantej. Brantosiq dena manaq oqsiq dia awesoqnej. ");
INSERT INTO boj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Awesonaqa tamo uŋgasari tulaŋ gargekoba naŋgi na tamo siŋga qandamnjro qaji ti tamo ŋam qandimnjro qaji ti tamo jejamu lainjro qaji ti tamo meŋ siŋgilainjro qaji ti tamo ma utru segi segi so qaji naŋgi ti joqsib boqnsib Yesus aqa areq di atoqneb. Ateqnabqa a na naŋgi kalil boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Deqa tamo meŋ siŋgilainjro qaji naŋgi olo anjam bole maroqneb. Tamo jejamu lainjro qaji naŋgo jejamu olo siŋgilaoqnej. Tamo siŋga qandamnjro qaji naŋgi olo tigelosib walweloqneb. Tamo ŋam qandimnjro qaji naŋgi olo ŋam poinjreqnaqa sawa unoqneb. Deqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unoqnsib tulaŋ prugoqnsib Israel naŋgo Qotei aqa ñam soqtoqneb. ");
INSERT INTO boj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Onaqa Yesus na aqa aŋgro naŋgi olo metnjrnaqa aqa areq bonabqa minjrej, “Tamo uŋgasari naŋgi bati qalub e koba na soqneb naŋgi iŋgi saiqoji. Deqa e naŋgi qa are ugeibqo. E naŋgi mam ti suweinjritqa gamq di naŋgi mam na lao uge.” ");
INSERT INTO boj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Degsi minjrnaqa naŋgi na kamba minjeb, “Sawa endi wadau. Deqa iga iŋgi qabe na osimqa tamo uŋgasari gargekoba endi anainjronam kereqas?” ");
INSERT INTO boj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Onaqa Yesus na minjrej, “Niŋgi bem gembub unu?” Onaqa minjeb, “Bem 7 unu. Qe kiñilala quja quja dego unu.” ");
INSERT INTO boj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Onaqa Yesus na tamo uŋgasari naŋgi minjrej, “Niŋgi kalil mandamq di awoeleŋoiy.” ");
INSERT INTO boj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Degsi minjrnaqa naŋgi kalil mandamq di awoonabqa Yesus na bem 7 ti qe ti di osiqa Qotei pailyej. Pailyosiqa bem ti qe ti giŋgeŋyosiqa aqa aŋgro naŋgi enjreqnaqa naŋgi na osi giloqnsibqa tamo uŋgasari naŋgi anainjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Uynab kalil menetnjrej. Onaqa iŋgi oto urateleŋeb qaji di Yesus aqa aŋgro naŋgi na koroiyosib gumba kokba 7 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tamo kalil iŋgi uyeb qaji naŋgi sisiyeb 4,000. Ariya uŋgasari ti aŋgro du du ti naŋgi sisiyosai. ");
INSERT INTO boj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Onaqa Yesus na tamo uŋgasari kalil naŋgi suweinjrnaqa naŋgo qure qureq gileqnabqa a qobuŋ gogetosiqa Magadan sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Onaqa Farisi ti Sadyusi ti naŋgi Yesus aqa areq bosibqa a anjam bei grotimqa qusib a ojqajqa deqa gisaŋyosib minjeb, “Ni endego Qotei aqa maŋwa bei babtim iga unqom.” ");
INSERT INTO boj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Onaqa Yesus na kamba minjrej, “Bilaqteqnaqa niŋgi mareqnub, ‘Seŋ lentqo. Laŋbi usriŋqo. Deqa sawa boleqas.’ ");
INSERT INTO boj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nebeeqnaqa niŋgi mareqnub, ‘Laŋbi tuluqo. Seŋ lentqo. Deqa jagwa awa ti bqas.’ Od, niŋgi laŋ unoqnsib geregere pegiyeqnub. Ariya Qotei aqa maŋwa bini branteqnu qaji di niŋgi kiyaqa utru poiŋgosaieqnu? ");
INSERT INTO boj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra tulaŋ ugedamu. Naŋgi Qotei areiyosaieqnub. Naŋgi gaigai Qotei aqa maŋwa laŋa unqajqa metbeqnub. Deqa e na Qotei aqa maŋwa bei naŋgi osornjrqasai. Jona aqa maŋwa segi osornjritqa naŋgi unqab.” Yesus na Farisi ti Sadyusi ti naŋgi degsi minjrsiqa uratnjrsiq gilej. ");
INSERT INTO boj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa koba na olo qobuŋ gogetosibqa ya agu taqal beiq di branteb. Bati deqa aqa aŋgro naŋgi bem oqajqa are walnjrej. ");
INSERT INTO boj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Onaqa Yesus a naŋgi endegsi minjrej, “Niŋgi geregere ŋam atsib soqniy. Bem tiyeqnu qaji sum Farisi naŋgo bem ti bulyimqa bem dena tiyekritosim tulaŋ kobaqujaqas. Sadyusi naŋgo bem dego tiyekritosim tulaŋ kobaqujaqas.” ");
INSERT INTO boj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Onaqa Yesus aqa aŋgro naŋgi aqa yawo anjam di qusibqa segi segi maroqneb, “Iga bem osai deqa kiyo mergwo?” ");
INSERT INTO boj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Onaqa Yesus a naŋgo anjam di qalieosiqa minjrej, “Nuŋgo areqalo e qa siŋgilatqa yonub tulaŋ keresaiiŋgwo. Niŋgi kiyaqa bem osai deqa mareqnub? ");
INSERT INTO boj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niŋgi e qa poiŋgosai unu kiyo? E nami bem 5 giŋgeŋyosimqa tamo 5,000 anainjronam uynab menetnjrnaqa niŋgi iŋgi oto koroiyosib gumba kokba 12 di jignab maqeleŋej. Niŋgi deqa are walŋgwo kiyo? ");
INSERT INTO boj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E bati bei bem 7 dego giŋgeŋyosimqa tamo 4,000 anainjronam uynab menetnjrnaqa niŋgi iŋgi oto koroiyosib gumba kokba 7 di jignab maqeleŋej. Niŋgi deqa are walŋgwo kiyo? ");
INSERT INTO boj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","O ijo aŋgro, e niŋgi bem tiyeqnu qaji sum qa merŋgonum di e niŋgi yawo anjam merŋgonum. E niŋgi bem bole qa merŋgosai. Niŋgi kiyaqa deqa poiŋgosai? Niŋgi quiy. Bem tiyeqnu qaji sum Farisi ti Sadyusi ti naŋgo bem ti bulyimqa bem dena tiyekritosim tulaŋ kobaqujaqas. Niŋgi deqa geregere ŋam atsib soqniy.” ");
INSERT INTO boj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus na aqa aŋgro naŋgi degsi minjrnaqa naŋgi qusib poinjrej, “Bole, Yesus a bem bole tiyosim kobaqujaqas deqa iga mergosai. Farisi ti Sadyusi ti naŋgo gisaŋ anjam bem bul tulaŋ kobaqas deqa iga mergwo.” ");
INSERT INTO boj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Onaqa bati bei Yesus na aqa aŋgro naŋgi olo joqsiqa koba na walwelosib Sisaria Filipai qure naŋgo sawaq di branteb. Brantosib Yesus na aqa aŋgro naŋgi endegsi nenemnjrej, “Tamo uŋgasari naŋgi e Tamo Aŋgro e qa kiyersib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Onaqa naŋgi na minjeb, “Tamo qudei naŋgi mareqnub, ni Jon yansnjro qaji. Qudei naŋgi mareqnub, ni Elaija. Qudei naŋgi mareqnub, ni Jeremaia kiyo Qotei aqa medabu o tamo naŋgi nami soqneb deqaji bei kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Onaqa Yesus a naŋgi olo nenemnjrej, “Niŋgi segi e qa kiyersib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Onaqa Saimon Pita na minjej, “Ni Kristus. Ni Qotei ŋambile gaigai unu qaji aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pita a kamba Yesus degsi minjnaqa a na minjej, “O Saimon, Jona aqa ŋiri, ni tulaŋ areboleboleimeme. Di kiyaqa? Ino anjam merbonum di mandam tamo bei na babtosiq mermosai. Ijo Abu laŋ qureq di unu qaji a segi na anjam di babtosiq mermqo. ");
INSERT INTO boj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Deqa e ni endegsi mermqai. Ni Pita. Ni meniŋ bul. Meniŋ quraq di e na ijo segi tamo uŋgasari kalil naŋgi koroinjrqai. Koroinjritqa Moiyo Qure aqa siŋgila na naŋgi ugetnjrqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","O Pita, ni que. Qotei a laŋ qureq di Mandor Koba unu deqa e ni siŋgila emqai. Emitqa ni mandamq endi gam getentqam di Qotei a dego laŋ qureq di gam getentqas. Ni mandamq endi gam waqtqam di Qotei a dego laŋ qureq di gam waqtqas.” ");
INSERT INTO boj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesus na Pita degsi minjsiqa olo aqa aŋgro naŋgi endegsi minjrej, “E Kristus. Niŋgi ijo ñam di ubtosib tamo qudei minjraib.” ");
INSERT INTO boj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bati deqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “E Jerusalem aiyeqnum. Dia Juda gate naŋgi ti atra tamo kokba ti dal anjam qalie tamo naŋgi ti e jaqatiŋ koba ebsib lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” Yesus a anjam di ubtosiq minjrej. ");
INSERT INTO boj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Onaqa Pita a anjam di qusiqa Yesus osiqa qalaq gilsiqa ŋiriŋtosiq minjej, “O Tamo Koba, kumbra di inoq di degsi brantqa maraim.” ");
INSERT INTO boj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Onaqa Yesus a bulosiqa Pita koqyosiqa ŋiriŋtosiq minjej, “Ni Satan bul. Deqa ni ijo qoreq gile. Ni e uneq waibaim. Ni Qotei aqa areqalo dauryosai. Ni mandam tamo naŋgo areqalo dauryonum. Dauryosim agi ni na anjam di merbonum.” ");
INSERT INTO boj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Osiqa Yesus na aqa aŋgro kalil naŋgi endegsi minjrej, “Tamo bei na e daurbqa osimqa a aqa segi areqalo kalil uratekritosim aqa segi ŋamburbas qoboiyosim e daurbem. ");
INSERT INTO boj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tamo bei na aqa segi ŋambile taqatqajqa arearetqas di a padalqas. Ariya tamo bei a e qa are qalsimqa aqa segi ŋambile uratqas di a olo ŋambile bole oqas. ");
INSERT INTO boj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamo bei a mandam qa ñoro kalil koroiyosim ariya mondoŋ aqa segi qunuŋ padalqas di ñoro dena a kiyersim aqaryaiyqas? Di keresai. Aqa qunuŋ padalqas di a awai kiye atsim dena aqa qunuŋ olo aqaryaiyosim a ŋambile sqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","E Tamo Aŋgro. Mondoŋ e ijo Abu aqa riaŋ na ti aqa laŋ aŋgro naŋgo riaŋ na ti bqai. Bosiy tamo uŋgasari kalil naŋgo kumbra qa peginjrsiy awai keretosiy enjrqai. ");
INSERT INTO boj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","E bole merŋgwai. Tamo qudei ijo areq endi tigelejunub qaji naŋgi moreŋosaisoqnibqa e Tamo Aŋgro bqai. Bosiy naŋgi taqatnjrsiy naŋgo Mandor Koba soqnit naŋgi e nubqab.” ");
INSERT INTO boj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Osiqa bati 6 onaqa Yesus a tigelosiqa Pita na Jems na aqa was Jon na naŋgi segi qalub joqsiqa koba na mana goge kobaq oqsib di soqneb. ");
INSERT INTO boj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sosibqa Yesus aqa jejamu bulyonaq naŋgi unobeiteb. Aqa ulatamu seŋ bul tulaŋ suwaŋoqnej. Aqa gara dego tulaŋ puloŋosiq qatekritej. ");
INSERT INTO boj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","4","Onaqa Moses Elaija wo naŋgi brantosib Yesus koba na anjam maroqneb. Mareqnabqa Yesus aqa aŋgro naŋgi na naŋgi aiyel unjrsibqa Pita a Yesus minjej, “O Tamo Koba, Moses Elaija wo naŋgi bosib iga koba na endi unum di bolequja. Deqa ni na e odbimqa e tal kiñilala qalub gereiyqai. Bei ino. Bei Moses aqa. Bei Elaija aqa.” ");
INSERT INTO boj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita a degsi mareqnaqa laŋbi tulaŋ suwaŋosiq aisiqa naŋgi kabutnjrej. Onaqa laŋbi miligiq dena anjam bei endegsi brantonaq naŋgi queb, “Endi ijo Aŋgro qujai e na tulaŋ qalaqalaiyeqnum qaji. E a qa areboleboleibeqnu. Deqa niŋgi aqa anjam quetoqniy.” ");
INSERT INTO boj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Onaqa Yesus aqa aŋgro naŋgi anjam di qusibqa tulaŋ ulaugeteb. Osib siŋga pulutosib mandamq di ŋam quosib ŋereŋeb. ");
INSERT INTO boj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Onaqa Yesus a naŋgo areq gilsiqa naŋgo gateq di aqa baŋ atsiqa minjrej, “Niŋgi tigeliy. Niŋgi ulaaib.” ");
INSERT INTO boj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Degsi minjrnaqa naŋgi tigelosib ŋam ateb di Yesus a segi naŋgi koba na sonab uneb. Naŋgi tamo bei unosai. ");
INSERT INTO boj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naŋgi Yesus ombla manaq dena olo aiyoqnsibqa Yesus a siŋgila na minjrej, “Maŋwa niŋgi mana goge di unonub qaji di ubtosib tamo qudei minjraib. Bunuqna e Tamo Aŋgro moisiy olo subq na tigelotqa bati deqa niŋgi na ubtosib minjroqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Onaqa naŋgi Yesus aqa anjam di qusib kamba minjeb, “Dal anjam qalie tamo naŋgi mareqnub, ‘Elaija a namo bamqa Kristus a bunuqna bqas.’ Anjam di kiyaqa degsib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Onaqa Yesus na minjrej, “Naŋgo anjam di bole. Elaija a namo bosim tamo uŋgasari kalil naŋgo areqalo gereiyetnjrsim soqnimqa bunuqna Kristus a bqas. ");
INSERT INTO boj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ariya e niŋgi endegsi merŋgwai. Elaija agi bej. Bonaqa tamo naŋgi a qa poinjrosai. Deqa gulbe kalil naŋgi a yqajqa are soqnej qaji agi yeb. E Tamo Aŋgro dego degsib jaqatiŋ ebqab.” ");
INSERT INTO boj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Onaqa naŋgi Yesus aqa anjam di qusib endegsi poinjrej, “Bole, Yesus a Elaija qa bole marosai. A Jon yansnjro qaji qa marqa osiqa Elaija aqa ñam na yawo anjam marqo.” ");
INSERT INTO boj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Onaqa Yesus na aqa aŋgro qalub naŋgi di joqsiqa koba na aisib tamo uŋgasari tulaŋ gargekoba mana utruq di tariŋesonab itnjreb. Onaqa tamo bei a bosiqa Yesus aqa areq di siŋga pulutosiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“O Tamo Koba, ni ijo aŋgro mel qa are ugeimimqa aqaryaiye. A bati gaigai nanarioqnsiqa dena aqa jejamu tulaŋ ugeeqnu. Bati gargekoba a uloŋoqnsiqa ŋamyuwoq o yaq aiyeqnu. ");
INSERT INTO boj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Deqa e a osim ino aŋgro naŋgoq osi bonumqa naŋgi na boletqa yonub keresaiinjrqo.” ");
INSERT INTO boj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Onaqa Yesus a anjam di qusiqa endegsi marej, “Niŋgi tamo uŋgasari bini bati endeqa unub qaji nuŋgo areqalo e qa siŋgilatosai bole sai. Nuŋgo kumbra tulaŋ uge. Bati gembub e niŋgi koba na sosiyqa nuŋgo gulbe di qoboiyoqnqai? Aŋgro mel di ijo areq osib boiy.” ");
INSERT INTO boj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Onaqa osi bonabqa Yesus na mondor uge di ŋiriŋtosiq minjej, “Ni aŋgro di uratosim ulaŋ.” Degsi minjnaqa mondor uge na aŋgro di uratosiq ulaŋej. Ulaŋonaqa bati qujai deqa aŋgro a boleej. ");
INSERT INTO boj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Onaqa Yesus aqa aŋgro naŋgi aqa areq lumu bosib nenemyeb, “Iga kiyaqa mondor uge di wiyqa yonum keresaiigwo?” ");
INSERT INTO boj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Onaqa Yesus na minjrej, “Utru agiende. Niŋgi e qa nuŋgo areqalo siŋgilatqa yonub niŋgi tulaŋ truquonub. E bole merŋgwai. Nuŋgo areqalo e qa siŋgilato qaji di sis yago bul kiñala sqas di kereqas. Degesqas di niŋgi mana kobaquja endi minjibqa a nuŋgo anjam dauryosim tigelosim sawa beiq gilqas. Nuŋgo areqalo e qa siŋgilato qaji degesqas di niŋgi kumbra kalil yqa kereiŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Deqa niŋgi mondor uge deqaji winjrqa osibqa niŋgi mati iŋgi uratosib qurieŋosib Qotei pailyoqniy. Dena qujai niŋgi na mondor uge winjrib jaraiqab.” ");
INSERT INTO boj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Onaqa Yesus na aqa aŋgro naŋgi olo joqsiqa koba na sawa di uratosib Galili sawaq gilsib dia sosibqa Yesus na minjrej, “E Tamo Aŋgro. Jeu tamo naŋgi na e ojsib tamo qudei naŋgo baŋq di e atqab. ");
INSERT INTO boj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Atib lubib moiqai. Bati qalub koboamqa e olo subq na tigelqai.” Onaqa Yesus aqa aŋgro naŋgi anjam di qusib utru poinjrosai. Deqa naŋgi are tulaŋ gulbekobainjrej. ");
INSERT INTO boj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Onaqa bati bei Yesus aqa aŋgro naŋgi koba na walwelosib Kaperneam qureq gileb. Gilsib di sonabqa atra tal takis o tamo naŋgi Pita aqa areq bosib nenemyeb, “Nuŋgo Qalie Tamo a atra tal takis oqnsiq ateqnu e?” ");
INSERT INTO boj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Onaqa Pita na minjrej, “Od, a ateqnu.” Osiqa Pita a tal gogetosiqa takis o tamo naŋgo anjam di Yesus minjqa laqnaqa Yesus a nami qalieosiq deqa minjoqujatej, “O Saimon, ni kiyersi are qalonum? Mandam endeqaji mandor naŋgi yai naŋgoq dena takis eqnub? Naŋgo segi aŋgro naŋgoq dena eqnub kiyo tamo laŋaj naŋgoq dena eqnub kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Onaqa Pita na kamba minjej, “Tamo laŋaj naŋgoq dena eqnub. Naŋgo segi aŋgro naŋgoq dena osaieqnub.” Onaqa Yesus na minjej, “Ni kere maronum. E Qotei aqa Aŋgro unum deqa e atra tal takis atqa uratqai di kere. ");
INSERT INTO boj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Uŋgum. Iga takis o tamo naŋgo are ugetetnjrqasai. Deqa ni alile aisim yima waiyosim qe namoqna oqam qaji di aqa medabu waqtosimqa aqa medabu miligiq di silali bei soqnim unqam. Unsim silali di osi gilsim gago aiyel qa takis atqa osimqa takis o tamo naŋgi enjre.” ");
INSERT INTO boj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bati deqa Yesus aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, Qotei laŋ qureq di unu qaji a na iga taqatgosim gago Mandor Koba soqnim bati deqa ino aŋgro yai a iga kalil buŋgosim ñam ti sqas?” ");
INSERT INTO boj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Onaqa Yesus na aŋgro kiñala bei metonaq aqa areq bonaqa naŋgo ambleq di tigeltosiqa osornjrej. ");
INSERT INTO boj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Osornjrsiqa minjrej, “E bole merŋgwai. Niŋgi are bulyosib aŋgro kiñala endeqaji bulqasai di Qotei laŋ qureq di unu qaji a na niŋgi taqatŋgwasai. Osim a nuŋgo Mandor Koba sqasai dego. ");
INSERT INTO boj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tamo bei na aqa segi ñam aguq atsim aŋgro kiñala endeqaji bulqas di Qotei na tamo di aqa ñam olo soqtetimqa a tamo kalil naŋgi buŋnjrsim a ñam ti sqas. Deqa Qotei na a taqatosim aqa Mandor Koba sqas. ");
INSERT INTO boj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Tamo bei a e qa are qalsimqa aŋgro kiñala endeqaji bei osim geregereiyqas di a e dego osim geregereibqas.” ");
INSERT INTO boj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Osiqa Yesus a olo marej, “Tamo bei na aŋgro kiñala endeqaji bei e qa aqa areqalo siŋgilateqnu qaji di osim uneq waiyqas di a kumbra tulaŋ ugedamu yqo. Iga tamo di ojsim meniŋ kobaquja osim sil na aqa kakroq di tontosim waiyim ya robuq aisim moiqas di kere. ");
INSERT INTO boj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Bunuqna tamo qudei naŋgi tamo qudei uneq breinjroqnqab. Bole, kumbra di brantoqnqas. Ariya tamo naŋgi kumbra di yoqnqab qaji naŋgi tulaŋ padalougetqab. ");
INSERT INTO boj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ino baŋ na kiyo ino siŋga na kiyo ni titmosim uneq waimqa laqnimqa di gentosim waiy. Ni degye. Di kiyaqa? Ni baŋ geŋo kiyo siŋga geŋo kiyo sosimqa une bei yqasai di kere. Di ni ŋambile gaigai sqam. Ariya ni baŋ aiyel ti kiyo siŋga aiyel ti kiyo sosimqa une yqam di keresai. Di Qotei na ni ŋamyuwoq waimqas. Ŋamyuwo di gaigai yuoqnsim sqas. ");
INSERT INTO boj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ino ŋamdamu na ni titmosim uneq waimqa laqnimqa ŋamdamu di otorosim waiy. Ni degye. Di kiyaqa? Ni ŋamdamu qujai ti sosimqa une bei yqasai di kere. Di ni ŋambile gaigai sqam. Ariya ni ŋamdamu aiyel ti sosimqa une yqam di keresai. Di Qotei na ni ŋamyuwoq waimqas. ");
INSERT INTO boj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Deqa niŋgi aŋgro kiñilala endeqaji naŋgi qa ugeaib. E merŋgwai. Naŋgo laŋ aŋgro naŋgi na ijo Abu laŋ qureq di unu qaji aqa ulatamu gaigai koqyeqnub. ");
INSERT INTO boj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","E segi Tamo Aŋgro. E na tamo uŋgasari padalo gamq di unub qaji naŋgi eleŋeqnum. E deqa mandamq aiyem. ");
INSERT INTO boj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Niŋgi kiyersib are qalonub? Tamo bei aqa kaja 100 naŋgi manaq di soqnibqa qujai bei alelamqa a kiyerqas? E merŋgwai. A na kaja 99 naŋgi uratnjrsim qujai alelqo qaji di ŋamosim gilsim itqas. ");
INSERT INTO boj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E bole merŋgwai. A na kaja qujai di itosim tulaŋ areboleboleiyqas. A kaja du du 99 alelosai qaji naŋgi qa tulaŋ areboleboleiyqasai. Qujai alelqo qaji a qa tulaŋ areboleboleiyqas. ");
INSERT INTO boj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dego kere nuŋgo Abu laŋ qureq di unu qaji a aŋgro kiñala endeqaji bei padalqajqa a deqa are sosai.” ");
INSERT INTO boj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Osiqa Yesus a olo marej, “Ino Kristen was bei na ni une bei emimqa niŋgi segi aiyel ombla awoosib aqa une ni emqo qaji di ubtosim minje. Minjimqa a ino anjam qusim are bulyqas di ni na ino was olo onum. ");
INSERT INTO boj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ariya a ino anjam quetmosaiamqa ni na Kristen tamo qujai kiyo aiyel kiyo joqsimqa naŋgi ni taqmosib ino was aqa une di olo ubtosib minjqab. ");
INSERT INTO boj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ariya a naŋgo anjam dego quetnjrosaiamqa ni na Kristen tamo uŋgasari kalil naŋgi metnjrim koroosib ni taqmosib ino was aqa une di olo ubtosib minjqab. Ariya a naŋgo anjam dego quetnjrosaiamqa ni na a qoreiye. Ni na une tamo ti takis o qaji tamo ti naŋgi qoreinjreqnum dego kere ni na ino was di qoreiye. ");
INSERT INTO boj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“E bole merŋgwai. Niŋgi mandamq endi gam getentqab di Qotei a dego laŋ qureq di gam getentqas. Niŋgi mandamq endi gam waqtqab di Qotei a dego laŋ qureq di gam waqtqas. ");
INSERT INTO boj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“E olo merŋgwai. Mandamq endi ijo aŋgro aiyel naŋgi iŋgi bei oqa marsibqa areqalo qujaitosib ijo Abu laŋ qureq di unu qaji a pailyqab di a na iŋgi di enjrqas. ");
INSERT INTO boj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tamo aiyel kiyo qalub kiyo ijo ñam qa are qalsib koroqab di e naŋgo ambleq di sqai.” ");
INSERT INTO boj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Onaqa bati deqa Pita a Yesus aqa areq bosiq nenemyej, “O Tamo Koba, ijo Kristen was bei na e une gembub ebimqa e aqa une di moiyotqai? E endegyqai kiyo? A na une 7 ebimqa aqa une di moiyotqai. Ariya a olo une bei ebimqa e moiyotqasai. Degyqai kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Onaqa Yesus na kamba minjej, “Ino was bei na ni une 7 emimqa aqa une di segi moiyotqam di keresai. A na une gargekoba emoqnsim soqnim ni aqa une kalil di dego moiyotoqne. A ni une 7 emoqnim une di moiyotoqne. Olo une 7 emoqnim moiyotoqne. Degsim giloqnem. ");
INSERT INTO boj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Niŋgi quiy. Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di mandor bei aqa kumbra sigitejunu. Mandor dena aqa kaŋgal tamo qudei nami silali yaiyeb qaji di kamba olo yqajqa minjrej. ");
INSERT INTO boj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aqa kaŋgal tamo bei 10 milion kina yaiyej qaji di osib aqa ulatamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tigeltonabqa a na silali di kamba olo yqajqa keresaiiyej. Deqa mandor a na minjej, ‘Ni silali di kamba olo e ebqa keresaiimqo deqa e ni ino ŋauŋ wo ino aŋgro naŋgi ti osiy tamo bei aqa baŋq di uratŋgitqa tamo dena silali ebimqa niŋgi a laŋa wauetoqnqab. Ino iŋgi iŋgi kalil dego e ni yaimosiy tamo qudei naŋgi enjritqa naŋgi na kamba silali ebqab. Gam dena ni silali nami yaibem qaji di kobotqam.’ ");
INSERT INTO boj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Degsi minjnaq qusiqa aqa areq di siŋga pulutosiqa pailyosiq minjej, ‘O Tamo Koba, ni e kumbra degbaim. Ni e qa dulosim mati e qa tariŋoqnime. E silali nami yaimem qaji di kalil itosiy e kamba emekritqai.’ ");
INSERT INTO boj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Onaqa mandor a kaŋgal tamo deqa dulosiqa silali kalil nami yaiyej qaji di laŋa kobotej. Osiqa a uratonaq gilej. ");
INSERT INTO boj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Gilsiqa kaŋgal tamo bei ombla wauo qaji a itosiqa ojsiq kakro apiyetosiq minjej, ‘Ni nami 10 kina yaibem qaji di kamba olo ebe.’ ");
INSERT INTO boj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Degsi minjnaq qusiqa aqa areq di siŋga pulutosiqa pailyosiq minjej, ‘Ni e qa dulosim mati e qa tariŋoqnime. E 10 kina nami yaimem qaji di itosiy e kamba emekritqai.’ ");
INSERT INTO boj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Degsi minjnaqa a aqa anjam di quetqa asgiyonaqa a osi gilsiqa tonto talq di waiyosiq minjej, ‘Ni tonto talq endi soqne. Bunuqna ni 10 kina nami yaibem qaji di kamba ebekritimqa e ni olo uratmit oqedqam.’ ");
INSERT INTO boj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“A degyonaqa kaŋgal tamo qudei a koba na wauo qaji naŋgi unsibqa are ugeinjrnaqa aisib naŋgo mandor a deqa saiyosib minjeb. ");
INSERT INTO boj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Minjnab qusiqa kaŋgal tamo di metonaq bonaqa minjej, ‘Ni kaŋgal tamo uge. Ni e pailbonumqa silali ni nami yaibem qaji di e na kobotonum. ");
INSERT INTO boj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","E ni qa dulosim silali di kobotonum. Ariya kiyaqa ni olo gilsim kaŋgal tamo bei ni ombla wauo qaji a qa dulosai? Osim silali a na nami yaimej qaji di ni kobotosai?’ ");
INSERT INTO boj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Degsi minjsiqa a qa tulaŋ minjiŋ oqetonaqa osiq qaja tamo naŋgo baŋq di atsiqa minjrej, ‘Niŋgi a wau koba yibqa a jaqatiŋ ti wauosim gilsim gilsim silali kalil nami yaibej qaji di kamba ebekritimqa niŋgi a olo uratib gilqas.’ ");
INSERT INTO boj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“O ijo aŋgro, dego kere niŋgi nuŋgo are miligiq na nuŋgo Kristen was naŋgo une kobotetnjrqasai di ijo Abu laŋ qureq di unu qaji a dego nuŋgo une kobotetŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus a anjam degsi marsiq koboonaqa a Galili sawa uratosiqa Judia sawaq gilsiq Jordan ya taqal beiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A di sonaqa tamo uŋgasari tulaŋ gargekoba naŋgi a dauryosib aqa areq di koroonabqa a na naŋgo ma tamo kalil naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Onaqa Farisi naŋgi olo Yesus aqa areq bosibqa a anjam bei grotimqa qusib naŋgi a ojqajqa deqa gisaŋyosib endegsib nenemyeb, “Tamo bei aqa ŋauŋ aqa jejamuq di une kiñala bei soqnimqa tamo dena a uratqa kere e? Gago dal anjam a kiyersi marqo?” ");
INSERT INTO boj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Onaqa Yesus na kamba minjrej, “Qotei aqa anjam bei neŋgreŋq di so qaji di niŋgi nami sisiyosai kiyo? Anjam endegsi unu, ‘Tulaŋ nami Qotei a mandam ti iŋgi iŋgi kalil ti gereiyosiqa bati deqa a tamo uŋa wo dego gereinjrej. ");
INSERT INTO boj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gereinjrsiqa marej, “Tamo bei na aqa ai abu naŋgi uratnjrsimqa aqa ŋauŋ wo beterosib jejamu qujaitosib sqab.” ’ ");
INSERT INTO boj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Qotei aqa anjam di agi neŋgreŋq di unu. Deqa tamo uŋa wo naŋgi jejamu qujai sqab. Naŋgi olo jejamu aiyel sqasai. Qotei na naŋgi aiyel turtnjrej deqa tamo bei na olo potnjraiq.” ");
INSERT INTO boj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Onaqa Farisi naŋgi na kamba Yesus minjeb, “Ni anjam degsi mergonum deqa Moses a kiyaqa dal anjam endegsi marej, ‘Tamo bei na aqa ŋauŋ uratqa osimqa pepa bei neŋgreŋyosim yosim di a uratqas’?” ");
INSERT INTO boj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Onaqa Yesus na kamba minjrej, “Nuŋgo are geteŋgejunu deqa Moses a niŋgi uŋa uratqa merŋgej. Ariya tulaŋ nami kumbra degsi sosai. ");
INSERT INTO boj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niŋgi quiy. Tamo bei na aqa ŋauŋ laŋa uratosim olo uŋa bei oqas di a na aqa ŋauŋ kumbra ugeq waiyqo. Di kiyaqa? Uŋa di a nami tamo bei ombla une atosai deqa.” ");
INSERT INTO boj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Onaqa Yesus aqa aŋgro naŋgi na minjeb, “Tamo uŋa ti unub qaji naŋgi gulbe deqaji oqab deqa uŋgum. Naŋgi uŋa aib. Naŋgi laŋa soqneb.” ");
INSERT INTO boj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Onaqa Yesus na kamba minjrej, “Niŋgi anjam maronub di tamo kalil naŋgi dauryqa keresai. Tamo naŋgi Qotei na siŋgila enjreqnu qaji naŋgi segi anjam di dauryqa kere. ");
INSERT INTO boj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tamo qudei naŋgo jejamu bolesai. Naŋgi degsib ai miligiq na ŋambabeb. Deqa naŋgi uŋa oqa keresai. Tamo qudei naŋgi tamo qudei na welum etnjreb deqa naŋgi aŋgrotqa keresai. Deqa naŋgi dego uŋa oqa keresai. Naŋgi laŋa unub. Ariya tamo qudei naŋgo segi areqalo na Qotei aqa wau ojqa marsibqa uŋa oqa urateqnub. Tamo naŋgi ijo anjam endi dauryqa kereamqa naŋgi dauryebe.” ");
INSERT INTO boj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Onaqa tamo uŋgasari qudei naŋgi naŋgo aŋgro du du joqsib Yesus na aqa baŋ naŋgo gateq di atetnjrsim naŋgi qa Qotei pailyqajqa deqa marsib Yesus aqa areq beb. Beqnabqa Yesus aqa aŋgro naŋgi na saidnjrsib minjreb, “Nuŋgo aŋgro du du naŋgi joqsib endeq baib.” ");
INSERT INTO boj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Degsib saidnjrnabqa Yesus na aqa aŋgro naŋgi minjrej, “Aŋgro du du naŋgi uratnjrib ijo areq beb. Naŋgi saidnjraib. Tamo uŋgasari naŋgi aŋgro du du bul sqab di Qotei laŋ qureq di unu qaji a naŋgo Mandor Koba sosim naŋgi taqatnjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Osiqa Yesus na aŋgro du du naŋgo gateq di aqa baŋ atetnjrsiqa a sawa di uratosiq gilej. ");
INSERT INTO boj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Onaqa tamo bei a Yesus aqa areq bosiqa nenemyej, “O Qalie Tamo, e kumbra bole kiye dauryosiy dena e ŋambile gaigai sqai?” ");
INSERT INTO boj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Onaqa Yesus na kamba minjej, “Ni kiyaqa e kumbra bole qa nenembonum? Qotei a segi qujai tamo bole. Ariya ni ŋambile gaigai sqajqa osimqa ni Qotei aqa dal anjam daurye.” ");
INSERT INTO boj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Onaqa tamo dena olo Yesus nenemyej, “E dal anjam kiye dauryqai?” Onaqa Yesus na minjej, “‘Ni tamo bei qalsim moiyotaim. Ni tamo bei aqa uŋa jejamu ojetaim. Ni bajiŋaim. Ni tamo bei aqa jejamu laŋa gisaŋyaim. ");
INSERT INTO boj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni ino ai abu naŋgo sorgomq di geregere sosimqa naŋgo anjam dauryoqne. Ni ino segi jejamu gereiyeqnum dego kere ino was naŋgi degsim gereinjroqne.’” ");
INSERT INTO boj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Onaqa aŋgro wala dena olo Yesus minjej, “E dal anjam kalil di nami dauryosim boqnem agi bini degsi unum. Deqa e Qotei aqa kumbra kiye keretosai unum?” ");
INSERT INTO boj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Onaqa Yesus na kamba minjej, “Ni Qotei aqa kumbra kalil keretqa osimqa endegye. Ni gilsim ino iŋgi iŋgi kalil qariŋyosim silali osim tamo iŋgi iŋgi saiqoji naŋgi jeisim enjre. Degsim enjrsim bosim e daurbe. Osim bunuqna ni laŋ qureq di awai bole itqam.” ");
INSERT INTO boj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yesus na tamo di degsi minjnaq qusiqa are tulaŋ gulbeiyej. A iŋgi iŋgi koba ti soqnej deqa ulatamu ugeiyonaqa ulaŋej. ");
INSERT INTO boj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Onaqa Yesus na aqa aŋgro naŋgi minjrej, “E bole merŋgwai. Tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba. ");
INSERT INTO boj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E niŋgi olo merŋgwai. Kamel a yumba miligiq gilqajqa baŋgi koba. Dego kere tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba.” ");
INSERT INTO boj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Onaqa Yesus aqa aŋgro naŋgi anjam di qusibqa tulaŋ prugugetosib minjeb, “Ni anjam degsi mergonum deqa tamo yai naŋgi Qotei na eleŋamqa naŋgi ŋambile gaigai sqa kere?” ");
INSERT INTO boj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Onaqa Yesus a naŋgi koqnjrsiqa minjrej, “Tamo naŋgi segi ŋambile sqa keresai. Ariya Qotei na naŋgi eleŋqa kere. Di kiyaqa? Qotei a kumbra kalil yqa kere.” ");
INSERT INTO boj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Onaqa Pita na Yesus minjej, “O Tamo Koba, ni une. Iga gago iŋgi iŋgi kalil uratosim ni daurmeqnum. Deqa iga awai kiye oqom?” ");
INSERT INTO boj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Onaqa Yesus na minjrej, “E bole merŋgwai. Mondoŋ Qotei a laŋ bunuj ti mandam bunuj ti atimqa bati deqa e Tamo Aŋgro ñam kobaquja osiy ijo segi awo jaram kobaq di awesqai. Awesosiyqa niŋgi tamo e daurbeqnub qaji metŋgitqa niŋgi dego awo jaram kokba 12 di awoeleŋqab. Awoosib Jekop aqa aŋgro 12 naŋgo moma kalil naŋgi taqatnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Deqa tamo naŋgi ijo ñam qa are qaloqnsib naŋgo segi tal, naŋgo was naŋgi, naŋgo jaja naŋgi, naŋgo ai abu naŋgi, naŋgo aŋgro naŋgi ti naŋgo wau kalil dego uratnjrsib e daurbqab di Qotei na olo iŋgi bole bole tulaŋ gargekoba naŋgi enjrqas. Yimqa mondoŋ naŋgi ŋambile gaigai sqab. ");
INSERT INTO boj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Deqa niŋgi quiy. Tamo gargekoba bini ñam ti unub qaji naŋgi mondoŋ ñam saiqoji sqab. Ariya tamo gargekoba bini ñam saiqoji unub qaji naŋgi mondoŋ ñam ti sqab.” ");
INSERT INTO boj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Osiqa Yesus a olo aqa aŋgro naŋgi endegsi minjrej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di wau lanja bei aqa kumbra sigitejunu. Wau lanja dena nobqolo ambru tigelosiqa aisiq tamo qudei naŋgi aqa iŋgi wauq di wauetqajqa itnjrej. ");
INSERT INTO boj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Itnjrsiqa minjrej, ‘Niŋgi ijo iŋgi wauq di wauoqnib wau qa bati koboamqa e na silali quruŋo quja quja eŋgwai.’ Degsi minjrsiq qariŋnjrnaqa naŋgi gilsib aqa iŋgi wauq di wauoqneb. ");
INSERT INTO boj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Seŋ kiñala goge oqnaqa wau lanja a koro sawaq aisiqa dia tamo qudei naŋgi laŋa tigelesonab unjrsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Niŋgi dego gilsib ijo wauq di wauoiy. Wauab kere dego awai eŋgwai.’ ");
INSERT INTO boj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Degsi minjrnaqa naŋgi gilsib aqa iŋgi wauq di wauoqneb. Qanam jige tamo qudei naŋgi dego laŋa tigelesonab unjrsiqa minjrej, ‘Niŋgi dego gilsib ijo wauq di wauoiy. Wauab kere dego awai eŋgwai.’ Degsi minjrnaqa naŋgi gilsib aqa wauq di wauoqneb. Seŋ keliŋtonaqa olo tamo qudei dego degsi minjrnaqa naŋgi gilsib wauoqneb. ");
INSERT INTO boj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Seŋ bilaqtonaqa wau lanja a aisiqa gamq di tamo qudei naŋgi laŋa tigelesonab unjrsiqa nenemnjrej, ‘Niŋgi kiyaqa laŋa tigelesonab seŋ bilaqtqo?’ ");
INSERT INTO boj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Onaqa naŋgi na minjeb, ‘Tamo bei na iga wau egosai deqa iga laŋa tigelejunum.’ Onaqa wau lanja na minjrej, ‘Niŋgi dego gilsib ijo iŋgi wauq di wauoiy.’ ");
INSERT INTO boj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ariya wau qa bati koboonaqa wau lanja na aqa wau taqato tamo bei qariŋyosiq minjej, ‘Ni gilsim wau tamo naŋgi di metnjrim ino areq di koroabqa naŋgo awai enjre. Enjrqa osimqa tamo naŋgi bilaq bosib wauonub qaji naŋgo awai namo enjrsimqa ariya tamo naŋgi nobqolo ambru bosib wauosib bilaqtonub qaji naŋgo awai bunuqna enjre.’ ");
INSERT INTO boj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Degsi minjnaq qusiqa tamo naŋgi bilaq bosib waueb qaji naŋgi namo metnjrnaq aqa areq bonabqa silali quruŋo quja quja enjrej. ");
INSERT INTO boj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Onaqa tamo naŋgi nobqolo ambru bosib wauosib bilaqteb qaji naŋgi degsib unsibqa are qaleb, ‘Iga nobqolo ambru bosim wauosim bilaqtonum. Deqa iga silali kobaquja oqom.’ Degsib are qalnabqa wau taqato tamo na naŋgi metnjrnaq aqa areq bonabqa naŋgi dego silali quruŋo quja quja enjrej. ");
INSERT INTO boj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Onaqa naŋgi degsib unsibqa naŋgi na wau lanja ŋiriŋtosib minjeb, ");
INSERT INTO boj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Tamo naŋgi di bilaq bosib waukiñalayonubqa silali ni na iga egonum qaji dego kere naŋgi enjronum. Iga nobqolo ambru waueqnam seŋ oqsiq gago jejamu tulaŋ kaŋkaŋeqnaqa bilaqtqo. Iga silali koba osai.’ ");
INSERT INTO boj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Onaqa wau lanja a naŋgo anjam di qusiqa bei endegsi minjej, ‘O was, e ni kumbra uge emosai. Aqo ombla bini nobqolo anjam keretosimqa e ni silali quruŋo qujai emqa mermonum. ");
INSERT INTO boj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Deqa ni ino silali quruŋo qujai osim aiye. E ni silali quruŋo qujai emonum dego kere tamo naŋgi bunuqna bosib wauonub qaji naŋgi silali quruŋo quja quja enjronum. E ijo segi areqalo na degyonum. ");
INSERT INTO boj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Silali di ijo segi silali. Deqa e ijo segi areqalo dauryosiy ijo silali jeiqa kere. E na tamo naŋgi bunu bonub qaji naŋgi kumbra bole enjrqa areibqas enjrqai. Deqa ni kiyaqa e qa are ugeimqo?’” ");
INSERT INTO boj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesus a yawo anjam degsi marsiqa olo marej, “Dego kere tamo bini ñam ti unub qaji naŋgi mondoŋ ñam saiqoji sqab. Ariya tamo bini ñam saiqoji unub qaji naŋgi mondoŋ ñam ti sqab.” ");
INSERT INTO boj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Osiqa Yesus na aqa aŋgro 12 naŋgi joqsiqa koba na walwelosib Jerusalem aiyoqneb. Aiyoqnsibqa Yesus na naŋgi segitnjrsiqa endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Niŋgi quiy. E Tamo Aŋgro. Iga Jerusalem aiyeqnum. Dia tamo qudei na e ojsib atra tamo kokba ti dal anjam qalie tamo ti naŋgo baŋq di e atqab. Yimqa naŋgi na ijo jejamuq di une qamsib merbqab, ‘Ni une ti. Deqa ni moiqam.’ ");
INSERT INTO boj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Naŋgi e degsib merbosib tamo naŋgi Qotei qaliesai qaji naŋgo baŋq di e atqab. Yimqa naŋgi na e misiliŋboqnsib bu toqoŋ na kumbaiŋboqnsib ŋamburbasq di lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Onaqa Sebedi aqa ŋiri aiyel naŋgo ai ombla na Yesus aqa areq bosibqa naŋgo ai a siŋga pulutosiqa Yesus minjej, “O Tamo Koba, e ni anjam bei mermitqa ni ijo anjam dauryqa kere kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Onaqa Yesus na kamba minjej, “Ni iŋgi kiye qa merbqam?” Onaqa a na Yesus minjej, “Mondoŋ ni gago Mandor Koba sosimqa bati deqa ni marimqa ijo aŋgro aiyel endi naŋgi ino baŋ woq ino baŋ qonaŋq di awoqab.” ");
INSERT INTO boj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Onaqa Yesus na kamba naŋgi aiyel endegsi minjrej, “Anjam niŋgi merbonub di aqa utru niŋgi geregere poiŋgosai. E jaqatiŋ koba oqai. Jaqatiŋ di ya uge uyo bul. Jaqatiŋ e oqai di niŋgi aiyel dego oqa kere e?” Onaqa naŋgi na minjeb, “Od, aqo aiyel oqa kere.” ");
INSERT INTO boj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Onaqa Yesus na olo naŋgi aiyel minjrej, “Bole, jaqatiŋ e oqai di niŋgi dego oqab. Ariya tamo yai naŋgi ijo baŋ woq ijo baŋ qonaŋq di awoqab di e na marqa keresai. Di ijo wau sai. Tamo naŋgi ijo Abu na giltnjrej qaji naŋgi segi ijo baŋ woq ijo baŋ qonaŋq di awoqab.” ");
INSERT INTO boj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesus aqa aŋgro 10 naŋgo ŋamdamuq di was aiyel naŋgi na anjam di Yesus minjeb deqa qusib naŋgi aiyel qa ŋiriŋeb. ");
INSERT INTO boj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Onaqa Yesus na aqa aŋgro 10 naŋgi metnjrnaqa aqa areq bonabqa minjrej, “Niŋgi qalie, mandor kokba sawa sawa kalil taqateqnub qaji naŋgi naŋgo segi ñam soqtoqnsib tamo uŋgasari naŋgi ŋiriŋ na taqatnjreqnub. ");
INSERT INTO boj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ariya kumbra di nuŋgoq di saiq. Nuŋgo ambleq di aŋgro bei a ñam ti sqa marsimqa a mati nuŋgo wau tamo soqnem. Osim a ñam ti sqas. ");
INSERT INTO boj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nuŋgo ambleq di aŋgro bei a tamo kobaquja sqa marsimqa a mati nuŋgo kaŋgal tamo soqnem. Osimqa a olo tamo kobaqujaqas. ");
INSERT INTO boj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","E Tamo Aŋgro. Niŋgi ijo kumbra qalieosib degsib dauryoqniy. Ijo kumbra agiende. E na tamo uŋgasari naŋgi wauetnjreqnum. E deqa bem. Tamo uŋgasari naŋgi e wauetbqajqa e deqa bosai. Bunuqna e ijo segi ŋambile uratosiy tamo uŋgasari gargekoba naŋgi eleŋqai.” ");
INSERT INTO boj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa koba na walwelosib aisib Jeriko qureq di branteb. Brantosib Jeriko qure ambleq na walwelosib olo Jeriko uratosib aiyeqnabqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus dauryosib koba na aiyoqneb. ");
INSERT INTO boj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aiyeqnabqa tamo aiyel ŋam qandimnjro qaji naŋgi gam qalaq di awesosibqa anjam endegsib queb, “Yesus a beqnu.” Naŋgi degsib qusibqa tulaŋ leleŋosib mareb, “O Tamo Koba, Devit aqa Ŋiri, ni aqo aiyel qa dulame.” ");
INSERT INTO boj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Onaqa tamo uŋgasari gargekoba Yesus dauryosib aiyoqneb qaji naŋgi na naŋgi aiyel ŋiriŋtnjrsib minjreb, “Niŋgi leleŋkobaaib. Kirioiy.” Degsib minjrnabqa naŋgi aiyel kiriosai. Naŋgi olo tulaŋ leleŋoqnsib Yesus minjoqneb, “O Tamo Koba, Devit aqa Ŋiri, ni aqo aiyel qa dulame.” ");
INSERT INTO boj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Onaqa Yesus a tigelosiqa naŋgi aiyel metnjrnaqa aqa areq bonabqa minjrej, “E niŋgi aiyel kiyerŋgwajqa deqa niŋgi e qa leleŋoqnab?” ");
INSERT INTO boj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Onaqa naŋgi aiyel na minjeb, “O Tamo Koba, aqo aiyel olo ŋam poigim sawa unqajqa deqa iga ni qa leleŋoqnam.” ");
INSERT INTO boj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Onaqa Yesus a naŋgi aiyel qa dulosiqa aqa baŋ waiyosiq naŋgo ŋamdamu ojetnjrej. Ojetnjrnaqa naŋgi aiyel ŋam poinjrnaqa sawa unsibqa tigelosib Yesus dauryosib aiyeb. ");
INSERT INTO boj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Onaqa Yesus aqa aŋgro naŋgi koba na walwelosib aisib Jerusalem jojomyosib Betfage qureq di branteb. Betfage qure agi Oliv mana utruq di unu. Di brantosib Yesus na aqa aŋgro aiyel qariŋnjrsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Niŋgi aisib qure bei jojom di unu di brantosib donki bei aqa du wo tontnjronub unub di unjrqab. Unjrsib sil palontosib titnjrsib joqsib boiy. ");
INSERT INTO boj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Niŋgi sil palontoqnibqa tamo bei na nenemŋgwas kiyo, ‘Niŋgi kiyaqa donki aiyel naŋgo sil palonteqnub?’ Degsi nenemŋgimqa niŋgi na minjiy, ‘Tamo Koba a wau ti deqa donki aqa du wo qa mergwo.’ Yimqa a na donki aqa du wo naŋgi qariŋnjrim ijoq bqab.” ");
INSERT INTO boj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesus a kumbra di yej deqa anjam bei Qotei aqa medabu o tamo bei nami marej qaji di aqa damu brantej. A endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Niŋgi na Saion qure naŋgi endegsib minjriy, ‘Niŋgi uniy. Nuŋgo Mandor Koba a nuŋgoq beqnu. A lawo na beqnu. A areqalo minjiŋ saiqoji. Deqa a donki quraq di awoosiq beqnu. Od, a donki aqa du quraq di awoosiq beqnu.’” ");
INSERT INTO boj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Onaqa Yesus aqa aŋgro aiyel naŋgi aisib anjam Yesus na minjrej qaji di dauryeb. ");
INSERT INTO boj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Osib naŋgi donki aqa du wo Yesus aqa areq joqsib beb. Bosib naŋgo segi gara jugo piqtosib donki aiyel naŋgo quraq di tunabqa Yesus a segi donki gogetosiqa quraq di awoej. ");
INSERT INTO boj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Awoonaqa donki aiyel naŋgi walwelosib aiyeqnabqa tamo uŋgasari tulaŋ gargekoba naŋgi beleŋosib naŋgo segi gara jugo piqteleŋosib gamq di tueleŋoqneb. Tamo qudei naŋgi nañuq dena ŋam baŋga giŋgeŋyosibqa osi bosib di dego gamq di tueleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Onaqa Yesus a donki quraq di awoosiq walweleqnaqa tamo uŋgasari namooqneb qaji naŋgi ti bunuoqneb qaji naŋgi ti tulaŋ leleŋoqnsibqa maroqneb, “O Devit aqa Ŋiri, iga ni qa tulaŋ areboleboleigeqnu. Ni Tamo Koba aqa ñam na bonum deqa a ni tulaŋ geregereimeqnu. Deqa iga Qotei laŋ goge di unu qaji aqa ñam tulaŋ soqtoqnqom.” Tamo uŋgasari naŋgi degoqnsib leleŋ ti Yesus dauryoqneb. ");
INSERT INTO boj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Onaqa Yesus a walwelosi aisiq Jerusalem di brantonaqa tamo uŋgasari kalil naŋgi a unsibqa tulaŋ prugugetosib segi segi maroqneb, “Tamo endi yaiyo?” ");
INSERT INTO boj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Degsib mareqnabqa tamo uŋgasari qudei Yesus dauryosib aiyoqneb qaji naŋgi na kamba minjreb, “Tamo endi Yesus. A Qotei aqa medabu o qaji tamo bole. Aqa qure utru Nasaret. Qure di Galili sawaq di unu.” ");
INSERT INTO boj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Onaqa Yesus a walwelosi aisiqa atra tal koba miligiq gilej. Gilsiqa ŋam atej di tamo uŋgasari gargekoba naŋgi iŋgi iŋgi qariŋyoqnsibqa dena silali eqnab unjrsiqa naŋgi winjrnaq jaraiyeb. Tamo qudei naŋgi silali piloqneb. Qudei naŋgi binoŋ qariŋyoqnsib dena silali oqneb. Deqa Yesus a naŋgo jar ti jaram ti bilbelyosiqa naŋgi dego winjrnaq jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naŋgi kalil jaraiyeqnabqa Yesus na minjrej, “Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Ijo tal endi pailyqajqa tal.’ Ariya niŋgi na olo tal endi ugetonubqa a bajiŋ tamo naŋgo tal bulqo.” ");
INSERT INTO boj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus a atra tal miligiq di sonaqa tamo ŋam qandimnjro qaji ti tamo siŋga qandamnjro qaji ti naŋgi aqa areq beqnabqa a na naŋgi kalil boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Onaqa aŋgro du du atra tal miligiq di soqneb qaji naŋgi Yesus aqa maŋwa di unsibqa tulaŋ leleŋoqnsib minjoqneb, “O Devit aqa Ŋiri, iga ni qa tulaŋ areboleboleigeqnu.” Onaqa dal anjam qalie tamo naŋgi ti atra tamo kokba ti naŋgi aŋgro du du naŋgo anjam di qusibqa Yesus qa ugeeb. ");
INSERT INTO boj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Osib Yesus minjeb, “Aŋgro du du naŋgi leleŋoqnsib anjam mareqnub di ni queqnum e?” Onaqa Yesus na kamba minjrej, “Od, e naŋgo anjam queqnum. Ariya anjam bei neŋgreŋq di unu qaji di niŋgi nami sisiyosai kiyo? Anjam agiende, ‘O Abu, aŋgro du du ti aŋgro mom ti naŋgi ino ñam soqteqnub.’” ");
INSERT INTO boj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesus a naŋgi degsi minjrsiq koboonaqa a tigelosiq Jerusalem uratosiq Betani qureq gilej. Gilsiq qoloonaq di ŋeiej. ");
INSERT INTO boj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nebeonaqa Yesus a olo tigelosiqa Jerusalem aiyoqnsiqa gamq di a mamyej. ");
INSERT INTO boj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mamyonaqa ŋam atsiqa qura baŋga ti gam qalaq di tigelesonaq unsiqa aqa gei unqajqa utruq gilej. Gilsiq unej qura gei bei saiqoji. Baŋga segi sonab unej. Unsiqa qura di minjej, “Ni olo bunu geitqasai.” Degsi minjnaqa bati qujai deqa qura di utru ti kalil laosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Onaqa Yesus aqa aŋgro naŋgi aqa kumbra di unsibqa tulaŋ prugugetosib Yesus nenemyeb, “Qura di kiyersi urur laosiq moiqo?” ");
INSERT INTO boj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. Niŋgi Qotei qa nuŋgo areqalo siŋgilatosib nuŋgo areqalo aiyeltqasai di niŋgi dego qura minjibqa a laosim moiqas. Qura segi sai. Niŋgi mana kobaquja endi dego minjqab, ‘Ni tigelosim yuwalq aiye.’ Minjibqa a nuŋgo anjam di dauryosim tigelosim yuwalq aiqas. ");
INSERT INTO boj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Deqa niŋgi Qotei qa nuŋgo areqalo siŋgilatosib iŋgi bei qa pailyqab di niŋgi iŋgi di oqab.” ");
INSERT INTO boj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Osiqa Yesus a olo atra tal miligiq gilsiq dia Qotei aqa anjam palontoqnej. Onaqa Israel naŋgo gate naŋgi ti atra tamo kokba ti naŋgi na Yesus aqa areq bosib nenemyeb, “Ni iga merge. Ni siŋgila qabe na osimqa kumbra endi yeqnum? Yai na ni qariŋmej deqa ni bosim wau endi yeqnum?” ");
INSERT INTO boj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Onaqa Yesus na minjrej, “E kamba anjam bei niŋgi nenemŋgwai. Nenemŋgitqa niŋgi e merbibqa e yai na qariŋbonaq bosim wau endi yeqnum di ubtosiy merŋgwai. ");
INSERT INTO boj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Niŋgi na merbiy. Yai na Jon qariŋyonaq bosiqa tamo uŋgasari naŋgi yansnjroqnej? Qotei na kiyo? Tamo bei na kiyo?” Onaqa naŋgi Yesus aqa anjam di qusibqa segi segi qairosib mareb, “Iga Yesus minjqom, ‘Qotei na Jon qariŋyej,’ degsi minjqom di a iga mergwas, ‘Kiyaqa niŋgi Jon aqa anjam quetosai?’ ");
INSERT INTO boj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ariya iga minjqom, ‘Tamo bei na Jon qariŋyej,’ degsi minjqom di dego keresai. Tamo uŋgasari naŋgi mareqnub, ‘Jon a Qotei aqa medabu o qaji tamo bole.’ Deqa iga naŋgi ulainjronum.” ");
INSERT INTO boj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naŋgi degsib qairosib olo Yesus minjeb, “Yai na kiyo Jon qariŋyej di iga qaliesai.” Onaqa Yesus na kamba minjrej, “Niŋgi degsib merbonub deqa e dego yai na qariŋbonaq bosim wau endi yeqnum di niŋgi merŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Osiqa Yesus a olo Juda gate naŋgi ti atra tamo kokba ti naŋgi endegsi minjrej, “Niŋgi kiyersib are qalonub? Tamo bei aqa ŋiri aiyel soqneb. Bati bei a aqa ŋiri matu aqaq bosiqa minjej, ‘O ijo aŋgro, ni gilsim ijo iŋgi wauq di wauame.’ ");
INSERT INTO boj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Onaqa aqa ŋiri matu na minjej, ‘Sai. E wauqa uratonum.’ Degsi aqa abu saidyosiqa bunuqna areqalo bei osiqa gilsiq wauetej. ");
INSERT INTO boj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Onaqa abu a aqa ŋiri yala aqaq bosiqa minjej, ‘O ijo aŋgro, ni gilsim ijo iŋgi wauq di wauame.’ Onaqa aqa ŋiri yala na minjej, ‘Od, Abu, e wauqai.’ Degsi aqa abu odyosiqa ariya a wauosai. A laŋa talq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Deqa niŋgi na merbiy. Aŋgro yai na aqa abu aqa anjam dauryej?” Onaqa naŋgi na kamba Yesus minjeb, “Ŋiri matu a na aqa abu aqa anjam dauryej.” Naŋgi degsib Yesus minjnabqa a na olo minjrej, “E bole merŋgwai. Takis o qaji tamo ti gam qaji uŋa ti naŋgi na niŋgi buŋgosib namoosib Qotei aqaq oqibqa a naŋgi eleŋosim naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Di kiyaqa? Jon yansnjro qaji a nuŋgoq bosiqa Qotei aqa kumbra bole niŋgi osorŋgonaqa niŋgi Jon aqa anjam quetosai. Ariya takis o qaji tamo ti gam qaji uŋa ti naŋgi Jon aqa anjam geregere queteb. Quetonab niŋgi di unsibqa ariya niŋgi olo are bulyosai. Osib niŋgi Jon aqa anjam quetosai dego.” ");
INSERT INTO boj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus a Juda tamo kokba naŋgi degsi minjrsiqa olo endegsi minjrej, “E niŋgi yawo anjam bei merŋgit niŋgi quiy. Tamo bei a tigelosiqa aqa wauq gilej. Gilsiqa wain sil yageleŋosiqa jeŋ qosej. Qoso koboonaqa meniŋ qura gogeq di tabir kuru bul gereiyej. Wain sil geitimqa wain gei koroiyosib paraparaiyosib aqa ya dia bilentqajqa deqa gereiyej. Osiqa wauq di tal atsiqa wau taqato tamo qudei naŋgo baŋq di aqa wau uratetnjrsiqa sawa isaq gilsiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sonaqa wain gei melionaqa a na aqa kaŋgal tamo qudei naŋgi qariŋnjrnaqa wau taqato tamo naŋgoq aisib minjreb, ‘Wau lanja a na iga qariŋgwo bonum. Deqa niŋgi wain gei egibqa iga na osi gilqom.’ ");
INSERT INTO boj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Degsi minjrnabqa naŋgi na naŋgi ojeleŋosib bei qalougeteb. Bei qalnab moiyej. Bei meniŋ na qalnab moiyej. ");
INSERT INTO boj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Onaqa wau lanja a di qusiqa olo aqa kaŋgal tamo gargekoba naŋgi qariŋnjroqnej. Qariŋnjreqnaqa aiyeqnab naŋgi dego ñumoqneb. ");
INSERT INTO boj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Onaqa wau lanja a endegsi are qalej, ‘E ijo segi aŋgro qujai qariŋyit aiqas di naŋgi a qalqasai. Naŋgi aqa anjam quetqab.’ Degsi are qalsiqa aqa segi ŋiri qariŋyonaq aiyej. ");
INSERT INTO boj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aiyeqnaqa wau taqato tamo naŋgi a unsibqa segi segi qairosib mareb, ‘Tamo a bqo endi wau lanja aqa segi ŋiri. A na aqa abu aqa iŋgi iŋgi kalil oqas. Deqa iga a qalsim moiyotosimqa wau endi iga na oqom.’ ");
INSERT INTO boj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Degsib marsibqa wau lanja aqa ŋiri ojsib osi gilsib wau qalaq di qalnab moiyej. ");
INSERT INTO boj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Deqa niŋgi kiyersib are qalonub? Wau lanja a bosimqa wau taqato tamo uge naŋgi di kiyernjrqas? Niŋgi na merbiy.” ");
INSERT INTO boj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Onaqa naŋgi na minjeb, “Wau lanja a bosimqa tamo uge naŋgi di tulaŋ ugeugeinjrsim padaltnjrougetqas. Osim aqa wau di olo yainjrsim tamo qudei naŋgo baŋq di uratetnjrimqa naŋgi na kamba wau taqatosib wain gei melioqnimqa koroiyoqnsib wau lanja yoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naŋgi degsib Yesus minjnabqa a na olo minjrej, “Qotei aqa anjam bei unu. Niŋgi anjam di nami sisiyosai kiyo? Anjam agiende, ‘Tal gereiyo qaji tamo naŋgi na tal ai arqsibqa uge qa marsib taqal waiyeb. Onaqa tal ai di Qotei na olo osiq tumaq di tigeltej unu. Tal ai di tal siŋgilatqajqa deqa tigeltej. Tamo Koba a segi na tal ai di tigeltej deqa iga unsim mareqnum, “Tal ai di tulaŋ bolequja.” ’ ");
INSERT INTO boj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Deqa e niŋgi endegsi merŋgwai. Qotei a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa uratosim niŋgi taqal breiŋgwas. Osim olo tamo uŋgasari qudei aqa kumbra bole dauryeqnub qaji naŋgi eleŋosim naŋgo Mandor Koba sosim naŋgi taqatnjrqas. Naŋgi gei bole atobuleqnub deqa Qotei na naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tamo uŋgasari ululoŋosib tal ai quraq aiqab qaji naŋgi di tal ai dena naŋgo tanu giŋgeŋyqas. Ariya tal ai di uloŋosim tamo uŋgasari qudei naŋgoq aisim jejamu ti tanu ti torei paraparainjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Onaqa atra tamo kokba ti Farisi naŋgi ti yawo anjam di qusib endegsib qalieeb, Yesus a yawo anjam dena naŋgo jejamuq di une qametnjrej. ");
INSERT INTO boj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Naŋgi degsib qalieosib deqa naŋgi Yesus ojqa mareb. Ariya naŋgi tamo uŋgasari naŋgi ulainjrsib deqa Yesus ojqa urateb. Di kiyaqa? Tamo uŋgasari kalil naŋgi maroqneb, “Yesus a Qotei aqa medabu o qaji tamo bole.” ");
INSERT INTO boj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Onaqa Yesus a olo Juda tamo kokba naŋgi yawo anjam bei endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di mandor bei aqa ŋiri uŋa baŋ ojqa bationaqa maruro atej dego kere. ");
INSERT INTO boj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A maruro atsiqa aqa kaŋgal tamo qudei qariŋnjrnaqa naŋgi gilsib tamo uŋgasari nami aqa maruro unqa minjrej qaji naŋgi metnjreb, ‘Niŋgi boiy.’ Onaqa naŋgi bqa asginjrej. ");
INSERT INTO boj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Asginjrnaqa mandor a deqa qusiqa aqa kaŋgal tamo qudei olo qariŋnjrsiqa minjrej, ‘Niŋgi gilsib tamo uŋgasari e ijo maruro unqa minjrem qaji naŋgi olo endegsib minjriy, “Niŋgi quiy. Mandor a iŋgi iŋgi kalil gereiyosiq atqo unu. Makau ti wagme namur bole bole ñumsiqa goiqo. Deqa niŋgi asgiŋgaiq. Niŋgi bosib aqa maruro uniy.” O kaŋgal tamo, niŋgi gilsib naŋgi degsib minjriy.’ ");
INSERT INTO boj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Onaqa naŋgi gilsib tamo uŋgasari naŋgi di minjreb, ‘Niŋgi boiy.’ Minjrnabqa naŋgi kalil bqa asginjrej. Bei a ulaŋosiqa aqa iŋgi wauq gilej. Bei a ulaŋosiqa aqa silali wauq gilej. ");
INSERT INTO boj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Qudei na kaŋgal tamo naŋgi di ojeleŋosib ugeugeinjrsib ñumnab moreŋeb. ");
INSERT INTO boj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Onaqa mandor a deqa qusiqa minjiŋ oqetonaqa aqa qaja tamo naŋgi qariŋnjrnaqa gilsib tamo naŋgi kaŋgal tamo ñumeb qaji naŋgi kamba ñumekriteb. Osib naŋgo tal iŋgi iŋgi kalil qatrentonab yuekriteb. ");
INSERT INTO boj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Onaqa mandor a olo aqa kaŋgal tamo qudei qariŋnjrsiqa minjrej, ‘Ijo aŋgro aqa uŋa baŋ ojqa bati kereqo deqa e na maruro atonum unu. Tamo uŋgasari e nami ijo maruro unqa minjrem qaji naŋgi bqa asginjrej. Naŋgi tamo uŋgasari bolesai deqa naŋgi ijo maruro unqa keresai. ");
INSERT INTO boj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Deqa niŋgi gilsib gamq di tamo uŋgasari laŋa laŋaj naŋgi turosib metnjrib ijo maruro unqa beb.’ ");
INSERT INTO boj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Onaqa naŋgi gilsib gamq di tamo uŋgasari gargekoba bole ti uge ti naŋgi turosib metnjrnabqa naŋgi kalil maruro unqajqa bosib koroonabqa tal tamo na maqej. ");
INSERT INTO boj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Onaqa mandor a na tamo uŋgasari naŋgi di unjrqa marsiqa tal miligiq gilej. Gilsiq ŋam atej di tamo bei a maruro qa gara wala jugosai di unsiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘O was, ni kiyaqa maruro qa gara wala jugosai? Ni degsim maruro unqa baim.’ Degsi minjnaqa tamo di a na kamba olo anjam bei minjqa keresaiiyonaqa laŋa kiriesoqnej. ");
INSERT INTO boj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Onaqa mandor a na aqa kaŋgal tamo naŋgi minjrej, ‘Niŋgi na tamo di siŋga ti baŋ ti tontetosib oqeq waiyibqa sawa ambruq di soqnem. Sawa dia tamo naŋgi akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas.’” ");
INSERT INTO boj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Osiqa Yesus a olo marej, “Niŋgi quiy. Qotei a tamo tulaŋ gargekoba naŋgi metnjreqnu. Ariya a tamo quja quja segi giltnjreqnu.” ");
INSERT INTO boj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Onaqa Farisi naŋgi gilsib naŋgi anjam kiye Yesus nenemyib a anjam grotim qusib a ojqajqa deqa qairoqneb. ");
INSERT INTO boj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Qairosib anjam kereonaq naŋgo aŋgro qudei Herot aqa wau tamo qudei ti qariŋnjrnab Yesus aqa areq bosib minjeb, “O Qalie Tamo, iga qalie, ni anjam bole maro qaji tamo. Ni anjam bole segi tamo uŋgasari naŋgi minjroqnsim Qotei aqa kumbra osornjreqnum. Ni tamo bei ulaiyosaieqnum. Ni tamo ñam ti naŋgi anjam bei minjroqnsim olo tamo ñam saiqoji naŋgi anjam bei minjrosaieqnum. Ni anjam qujai tamo kalil naŋgi minjreqnum. ");
INSERT INTO boj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Deqa ni iga merge. Iga Sisar takis yqom e? Yqasai e? Ni kiyersi are qalonum?” ");
INSERT INTO boj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Onaqa Yesus a naŋgo areqalo uge di poiyonaqa minjrej, “Niŋgi gisaŋ tamo. Kiyaqa niŋgi e anjam bei grotitqa qusib e ojqajqa deqa gisaŋbeqnub? ");
INSERT INTO boj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Niŋgi meniŋ silali bei osorbiy.” Degsi minjrnaqa naŋgi meniŋ silali bei osi bosib osoryonab unsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Meniŋ silali quraq endi tamo yai aqa ulatamu ti ñam ti unu?” ");
INSERT INTO boj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Onaqa naŋgi na minjeb, “Di Sisar aqa.” Onaqa a na minjrej, “Deqa Sisar aqa iŋgi iŋgi a qa olo yiy. Qotei aqa iŋgi iŋgi a qa olo yiy.” ");
INSERT INTO boj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Onaqa naŋgi Yesus aqa anjam di qusibqa tulaŋ prugugeteb. Osib naŋgi Yesus uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Onaqa bati deqa Sadyusi tamo qudei naŋgi Yesus aqa areq beb. Sadyusi naŋgi mareqnub, “Tamo moreŋo qaji naŋgi olo subq na tigelqasai.” Deqa naŋgi bosib Yesus endegsib minjeb, ");
INSERT INTO boj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“O Qalie Tamo, ni que. Moses a nami endegsi marej, ‘Tamo bei a moiyimqa aqa ŋauŋ aŋgro saiqoji soqnimqa aqa was bei na olo uŋa qobul di osim aqa was moiyej qaji aqa aŋgro ŋambabtetqas.’ Moses a nami degsi marej. ");
INSERT INTO boj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Deqa ni que. Was 7 naŋgi soqneb. Naŋgo was matu a uŋa osiqa moiyej. A aŋgro saiqoji. Onaqa aqa was yala na olo uŋa qujai di ej. ");
INSERT INTO boj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Osiqa a dego moiyej. A aŋgro saiqoji. Onaqa aqa was yala na olo uŋa qobul di osiqa a dego moiyej. A aŋgro saiqoji. Was 7 kalil naŋgi uŋa qujai di osib moreŋeb. Naŋgi aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Naŋgi kalil moreŋonabqa ariya bunuqna uŋa di a dego moiyej. ");
INSERT INTO boj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Deqa ni iga merge. Mondoŋ subq na tigelo batiamqa tamo kalil naŋgi subq na tigelabqa uŋa di a yai aqa ŋauŋ tiŋtiŋ sqas? Ni qalie, was 7 kalil naŋgi uŋa qujai di eb.” ");
INSERT INTO boj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Onaqa Yesus na minjrej, “Qotei aqa anjam neŋgreŋq di unu qaji di aqa damu niŋgi poiŋgosai. Qotei aqa siŋgila dego niŋgi poiŋgosai. Deqa niŋgi anjam grotonub. Grotosib agi nenembonub. ");
INSERT INTO boj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mondoŋ tamo uŋgasari naŋgi subq na tigelosibqa naŋgi uŋatqasai. Naŋgi tamotqasai. Naŋgi laŋ aŋgro bul laŋa sqab. ");
INSERT INTO boj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Niŋgi quiy. Tamo naŋgi moisib olo subq na tigelqab anjam di aqa utru Qotei a nami babtosiq niŋgi merŋgej. Di niŋgi sisiyosai kiyo? Qotei a endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘E Abraham aqa Qotei. E Aisak aqa Qotei. E Jekop aqa Qotei.’ Qotei a degsi marej deqa iga qalieonum, Qotei a tamo moreŋo qaji naŋgo Qotei sai. A tamo ŋambile so qaji naŋgo Qotei.” ");
INSERT INTO boj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Onaqa tamo uŋgasari kalil naŋgi Yesus aqa anjam di qusibqa tulaŋ prugugeteb. ");
INSERT INTO boj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesus a Sadyusi naŋgi anjam degsi minjrnaqa naŋgi na kamba olo anjam bei minjqa keresaiinjrej. Onaqa Farisi naŋgi deqa qusib olo Yesus aqa areq beb. ");
INSERT INTO boj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naŋgo ambleq dena dal anjam qalie tamo bei a tigelosiqa Yesus gisaŋyosiq nenemyej, ");
INSERT INTO boj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O Qalie Tamo, ni mare. Qotei aqa dal anjam kiye a segi qujai tulaŋ bolequja? Dal anjam kiye a dal anjam kalil buŋnjrejunu?” ");
INSERT INTO boj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Onaqa Yesus na minjej, “Dal anjam tulaŋ bolequja agi mermqai. Dal anjam agiende. ‘Ni ino Tamo Koba Qotei a tulaŋ qalaqalaiyime. Qalaqalaiyosim ino are miligi ti ino qunuŋ ti ino areqalo ti kalil a yekritime.’ ");
INSERT INTO boj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dal anjam di a segi qujai tulaŋ bolequja. A na dal anjam kalil buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ariya dal anjam deqaji bei dego mermqai. Dal anjam agiende. ‘Ni ino segi jejamu gereiyeqnum dego kere ino was naŋgi degsim geregereinjroqnime.’ Dal anjam boledamu aiyel agi e na mermonum. ");
INSERT INTO boj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ni dal anjam aiyel di dauryqam di ni Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti kalil keretosim dauryqam.” ");
INSERT INTO boj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Onaqa Farisi naŋgi olo Yesus aqa areq di koroesonabqa a na nenemnjrej, ");
INSERT INTO boj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Niŋgi Kristus qa kiyersib are qalonub? A yai aqa ŋiri?” Onaqa naŋgi na kamba minjeb, “Kristus a Devit aqa ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Onaqa Yesus na olo minjrej, “Devit a nami marej, ‘Kristus a ijo Tamo Koba.’ Agi Qotei aqa Mondor na Devit aqa medabu siŋgilatetonaqa a endegsi marej, ");
INSERT INTO boj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tamo Koba a na ijo Tamo Koba minjej, “Ni ijo baŋ woq endi awo. Awesoqnimqa e ino jeu tamo kalil naŋgi eleŋosiy ino sorgomq di atitqa ni na naŋgi taqatnjroqnqam.” ’ ");
INSERT INTO boj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Niŋgi uniy. Devit a marej, ‘Kristus a ijo Tamo Koba.’ Deqa Kristus a kiyersim Devit aqa ŋiri sqas?” ");
INSERT INTO boj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesus a Farisi naŋgi anjam degsi minjrnaqa tamo bei na kamba anjam bei minjqa keresai. Deqa tamo naŋgi olo bunuqna anjam bei Yesus nenemyqajqa ulaeb. ");
INSERT INTO boj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Onaqa Yesus na olo aqa aŋgro naŋgi ti tamo uŋgasari kalil naŋgi ti endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Dal anjam qalie tamo naŋgi ti Farisi naŋgi ti Moses aqa ñam osib dal anjam plaltoqnsib niŋgi merŋgeqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Deqa anjam kalil naŋgi na merŋgeqnub qaji di niŋgi qusib dauryoqniy. Ariya kumbra naŋgi yeqnub qaji di niŋgi dauryaib. Naŋgi anjam maroqnsib ariya naŋgi segi anjam di dauryosaieqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Naŋgi gulbe kokba tamo uŋgasari naŋgi enjreqnab qoboiyoqnsib unub. Ariya naŋgi olo tamo uŋgasari naŋgo gulbe di qoboiyetnjrosaieqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kumbra kalil naŋgi yeqnub qaji di tamo uŋgasari naŋgi unoqnsib naŋgo ñam soqtetnjrqajqa deqa yeqnub. Naŋgo kumbra bei agiende. Naŋgi Qotei aqa dal anjam mutu qudei pepa kiñilalaq di neŋgreŋyoqnsibqa lopo miligiq di jigeleŋoqnsib naŋgo lanjaq di gara ñeŋgi na qoseqnub. Osib naŋgo gara jugo mutuq di gara burbur neŋgreŋ ti wala bole bole tonteqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Naŋgi goiyo kokbaq di, Qotei tal miligiq di sosibqa tamo ñam ti naŋgo awo jaramq di awoqajqa tulaŋ areboleboleinjreqnu. ");
INSERT INTO boj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Naŋgi koro sawaq di tamo uŋgasari naŋgi na naŋgo ñam soqtoqnsib baŋ ojetnjrqajqa deqa areboleboleinjreqnu. Tamo uŋgasari naŋgi na ‘O Qalie Tamo Koba’ degsib minjroqnqajqa deqa ti naŋgi areboleboleinjreqnu. ");
INSERT INTO boj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“O ijo aŋgro, tamo qudei na niŋgi ‘O Qalie Tamo Koba’ degsib merŋgaib. Tamo qujai a segi nuŋgo Qalie Tamo. Niŋgi kalil was. ");
INSERT INTO boj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mandamq endi niŋgi na tamo bei endegsib minjaib, ‘O Abu.’ Tamo qujai a segi nuŋgo Abu. Agi a laŋ qureq di unu. ");
INSERT INTO boj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tamo qudei na niŋgi endegsib merŋgaib, ‘O Gate Koba.’ Tamo qujai a segi nuŋgo Gate Koba. Agi e Kristus. ");
INSERT INTO boj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nuŋgo ambleq di aŋgro bei a ñam ti sqa marsimqa a mati nuŋgo wau tamo soqnem. Osimqa a ñam ti sqas. ");
INSERT INTO boj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tamo kalil naŋgo segi ñam soqteqnub qaji naŋgi Qotei na olo ñam aguq atetnjrqas. Ariya tamo kalil naŋgo segi ñam aguq ateqnub qaji naŋgi Qotei na olo ñam soqtetnjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Osiqa Yesus a olo marej, “O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi tamo uŋgasari naŋgi laŋ qureq oqwajqa gam itqa mareqnabqa niŋgi na olo gam getentetnjreqnub. Niŋgi segi laŋ qureq oqwajqa gam itqa keresai. Deqa tamo uŋgasari naŋgi dego laŋ qureq oqwajqa gam itqa yeqnab niŋgi na gam getentetnjreqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi niŋgi uŋa qobul naŋgi gisaŋnjroqnsibqa naŋgo tal ti iŋgi iŋgi ti laŋa yainjreqnub. Osib tamo uŋgasari naŋgi na niŋgi nuŋgsib nuŋgo ñam soqtetŋgwajqa deqa pailyo olekokba yeqnub. Deqa mondoŋ Qotei na tamo naŋgi peginjrqa batiamqa a na niŋgi awai tulaŋ uge eŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi niŋgi na tamo qujai segi niŋgi daurŋgwa maroqnsib siŋga na kiyo qobuŋ na kiyo sawa sawa kalil keretoqnsib laqnub. Ariya tamo qujai di a niŋgi daurŋgwas di a na niŋgi buŋgosim tamo tulaŋ ugedamu sqas. Deqa a niŋgi qa namoosim torei ŋamyuwoq aiqas. ");
INSERT INTO boj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Niŋgi tamo ŋam qandimo bul unub. Deqa niŋgi tamo naŋgi gam osornjrqa keresai. Agi niŋgi mareqnub, ‘Tamo bei a anjam siŋgilatqa osimqa atra tal aqa ñam na siŋgilatqas di aqa anjam siŋgilaqasai. Deqa a na anjam di uratqas di kere. Ariya a gol atra tal miligiq di unu qaji aqa ñam na anjam siŋgilatqas di aqa anjam bole siŋgilaqas. Deqa a anjam di urataiq.’ Niŋgi degsib mareqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Niŋgi tamo ŋam qandimo bul unub. Niŋgi tulaŋ nanari. Niŋgi na merbiy. Iŋgi kiye a Qotei aqa ŋamgalaq di tulaŋ bole? Atra tal a tulaŋ bole kiyo atra tal aqa gol a tulaŋ bole kiyo? Od, atra tal a tulaŋ bole. Ariya gol atra tal miligiq di unu qaji a dego iŋgi bole. ");
INSERT INTO boj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Niŋgi endegsib mareqnub, ‘Tamo bei a anjam siŋgilatqa osimqa atra bijal aqa ñam na siŋgilatqas di aqa anjam siŋgilaqasai. Deqa a na anjam di uratqas di kere. Ariya a atraiyo iŋgi iŋgi atra bijal gogeq di unub qaji naŋgo ñam na anjam siŋgilatqas di aqa anjam bole siŋgilaqas. Deqa a anjam di urataiq.’ Niŋgi degsib mareqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Niŋgi tamo ŋam qandimo bul unub. Niŋgi na merbiy. Iŋgi kiye a Qotei aqa ŋamgalaq di tulaŋ bole? Atra bijal a tulaŋ bole kiyo atraiyo iŋgi iŋgi atra bijal gogeq di unub qaji naŋgi tulaŋ bole kiyo? Od, atra bijal a tulaŋ bole. Ariya atraiyo iŋgi iŋgi atra bijal gogeq di unub qaji naŋgi dego bole kalil. ");
INSERT INTO boj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Deqa niŋgi quiy. Tamo bei a atra bijal aqa ñam na anjam siŋgilatqas di a atra bijal ti iŋgi iŋgi kalil atra bijal gogeq di unub qaji naŋgi ti naŋgo ñam na anjam siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tamo bei a atra tal aqa ñam na anjam siŋgilatqas di a atra tal ti Qotei agi atra tal miligiq di unu qaji a ti naŋgo ñam na anjam siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tamo bei a laŋ qure aqa ñam na anjam siŋgilatqas di a Qotei ti aqa awo jaram ti naŋgo ñam na dego anjam siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi niŋgi dal anjam kiñilala segi dauryeqnub. Niŋgi lei ti lombo ti saga ti oqnsib poto 10 yoqnsib oto qujai Qotei atraiyeqnub. Ariya niŋgi Qotei aqa dal anjam kokba dauryqajqa urateqnub. Agi niŋgi kumbra bole bole dauryqa asgiŋgeqnu. Niŋgi tamo naŋgi qa dulosaieqnub. Niŋgi Qotei qa nuŋgo areqalo siŋgilatosaieqnub. Niŋgi dal anjam kiñilala segi dauryeqnub. Deqa e niŋgi endegsi merŋgwai. Niŋgi are bulyosib dal anjam kokba dauryosib laqniy. Niŋgi dal anjam kiñilala dego dauryqa urataib. ");
INSERT INTO boj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niŋgi tamo ŋam qandimo bul unub. Deqa niŋgi tamo naŋgi gam osornjrqa keresai. Agi niŋgi qui uyqa oqnsib añiñig kiñala quiq di sonaqa unoqnsib taqal ateqnub. Ariya kamel a quiq di sonaqa niŋgi unosaieqnub. Qoji uyeqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi niŋgi ya gambaŋ ti tabir ti qore segi yanseqnub. Niŋgi miligi yansosaieqnub. Dego kere niŋgi babaŋ na tamo bole. Ariya nuŋgo are miligi bajiŋ kumbra ti jejamu qa kumbra uge ti dena maqejunu. ");
INSERT INTO boj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O Farisi niŋgi tamo ŋam qandimo bul unub. Deqa niŋgi endegyiy. Niŋgi mati ya gambaŋ ti tabir ti miligi yansiy. Yansib milalamqa qore dego milalqas. ");
INSERT INTO boj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Agi niŋgi tamo moiyo qaji sub bul unub. Sub gogeq di wala boledamu. Ŋam qaq na liyeb. Ariya sub miligiq di tamo aqa qusa ti tanu ti dena maqejunu. ");
INSERT INTO boj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niŋgi sub di bul. Deqa tamo uŋgasari naŋgi na niŋgi nuŋgoqnsib mareqnub, niŋgi tamo bole. Ariya nuŋgo are miligi gisaŋ kumbra ti dal anjam gotraŋyqajqa kumbra ti dena maqejunu.” ");
INSERT INTO boj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Osiqa Yesus a olo marej, “O dal anjam qalie tamo ti Farisi ti, niŋgi gisaŋ tamo. Deqa niŋgi tulaŋ padalougetqab. Niŋgi anjam maro aiyelteqnub. Bole, niŋgi Qotei aqa medabu o tamo naŋgo sub gereiyoqnsib tamo uŋgasari nami kumbra bole bole yoqneb qaji naŋgo sub walateqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ariya niŋgi olo endegsib mareqnub, ‘Iga nami soqnem qamu iga gago moma naŋgi ti beterosim Qotei aqa medabu o tamo naŋgi ñumosai qamu.’ Di gisaŋ koba. Niŋgi nuŋgo moma naŋgi ti areqalo qujai. ");
INSERT INTO boj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Niŋgi mareqnub, ‘Gago moma.’ Nuŋgo anjam dena niŋgi segi qa ubtosib endegsib marobuleqnub, ‘Tamo naŋgi na Qotei aqa medabu o tamo naŋgi ñumoqneb qaji naŋgo aŋgro agi iga.’ ");
INSERT INTO boj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Niŋgi degsib marobuleqnub. Deqa uŋgum. Nuŋgo moma naŋgo kumbra uge di niŋgi na olo keretosib yoqniy. ");
INSERT INTO boj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Niŋgi amal uge bul. Deqa mondoŋ Qotei a nuŋgo une qa merŋgsim niŋgi ŋamyuwoq di breiŋgwas. Yimqa niŋgi kiyersib olo bole sqab? Keresai. ");
INSERT INTO boj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Deqa niŋgi quiy. E na Qotei aqa medabu o tamo naŋgi ti Qotei aqa powo tamo naŋgi ti Qotei aqa dal anjam qalie tamo naŋgi ti qariŋnjroqnit nuŋgoq boqnqab. Boqnibqa niŋgi na naŋgi qudei ñumoqnsib moiyotnjroqnqab. Osib naŋgi qudei ŋamburbasq di gaintnjrqab. Osib naŋgi qudei ojeleŋosib nuŋgo Qotei tal miligiq di kumbaiŋnjroqnqab. Osib naŋgi qudei teteinjribqa naŋgi jaraiyosib qure bei beiq giloqnqab. ");
INSERT INTO boj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Niŋgi naŋgi degnjroqnibqa bati deqa Qotei a nuŋgo moma naŋgo une kalil osim nuŋgo jejamuq di ateleŋqas. Nuŋgo moma naŋgo une agiende. Naŋgi na tamo uŋgasari kumbra bole bole yoqneb qaji naŋgi ñumoqneb. Naŋgo une di agi naŋgi nami yqajqa utru atsib Kein na Abel qalnaq moiyej. Dena bosi bosib Berekia aqa ŋiri Sekaraia atra bijal ti atra tal ti ambleq di qalnab moiyej. Une kalil di Qotei na osim nuŋgo jejamuq di ateleŋqas. ");
INSERT INTO boj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","E bole merŋgwai. Une kalil di aqa awai uge Qotei na osim tamo uŋgasari bini bati endeqa unub qaji naŋgi enjrqas.” ");
INSERT INTO boj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Osiqa Yesus a olo marej, “O Jerusalem qure, O Jerusalem qure, ni na Qotei aqa medabu o tamo naŋgi ñumoqnsim moiyotnjreqnum. Osim tamo uŋgasari Qotei na inoq qariŋnjreqnu qaji naŋgi meniŋ na ñumeqnam moreŋeqnub. Bati gargekoba e ino aŋgro naŋgi tuwe du du bul koroinjrqajqa yeqnam niŋgi saideqnub. ");
INSERT INTO boj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Deqa niŋgi quiy. Qotei a nuŋgo atra tal koba uratetŋgimqa a laŋa sqas. ");
INSERT INTO boj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Deqa e niŋgi endegsi merŋgwai. Niŋgi olo e nubqasai. Degsim gilsim mondoŋ e olo laŋ qureq na boqnitqa niŋgi e nubsib marqab, ‘Tamo a bqo endi Tamo Koba aqa ñam na bqo. Deqa Qotei na a tulaŋ geregereiyeqnu.’” ");
INSERT INTO boj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Osiqa Yesus a atra tal koba uratosiq gileqnaqa aqa aŋgro naŋgi na aqa areq bosib atra tal osoryeb. ");
INSERT INTO boj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Osoryonab Yesus na minjrej, “E bole merŋgwai. Atra tal niŋgi unonub endi bunuqna jeu tamo naŋgi na bosib tulaŋ niñaqyosib aqa meniŋ kalil paraparainjrsibqa taqal breinjrqab. Yimqa meniŋ bei meniŋ bei aqa quraq di sqasai. Meniŋ kalil segi segiqab.” ");
INSERT INTO boj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus na aqa aŋgro naŋgi degsi minjrsiqa Oliv manaq oqsiq goge di awesonaqa aqa aŋgro naŋgi aqa areq bosib lumu nenemyeb, “Ni iga merge. Bati gembu jeu tamo naŋgi bosib atra tal endi niñaqyqab? Mandam endi koboqa laqnimqa ni olo laŋ qureq na boqnim kumbra kiye namoqna brantim iga unsim poigwas, ‘Bati di jojomqo’?” ");
INSERT INTO boj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Onaqa Yesus na kamba minjrej, “Niŋgi geregere ŋam atoqniy. Tamo qudei na niŋgi gisaŋgo uge. ");
INSERT INTO boj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bunuqna gisaŋ tamo gargekoba naŋgi ijo ñam na boqnsib tamo uŋgasari naŋgi endegsib minjroqnqab, ‘E Kristus.’ Degsib tamo uŋgasari tulaŋ gargekoba naŋgi gisaŋnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bunuqna sawa bei bei qaji naŋgi aŋ na qotokobaoqnqab. Niŋgi deqa qusib ulaaib. Qotei a nami marej, ‘Kumbra di brantqas.’ Deqa brantem. Ariya kumbra di brantimqa diŋo bati urur brantqasai. Soboleiyosim brantqas. ");
INSERT INTO boj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bati deqa sawa bei ti sawa bei ti qotoqnqab. Mandor qudei naŋgi tigeloqnsibqa mandor qudei naŋgi qoto itnjroqnqab. Sawa bei beiq di mimiŋ kokba ti mam ti iŋgi saio bati dego branteleŋqas. ");
INSERT INTO boj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kumbra kalil di uŋa aŋgrotqa osiqa mati jaqatiŋ kiñala eqnu dego kere. ");
INSERT INTO boj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bati deqa naŋgi na niŋgi ojeleŋoqnsib jaqatiŋ ti gulbe ti eŋgoqnqab. Osib niŋgi qudei luŋgsib moiyotŋgwab. Niŋgi ijo ñam ejunub deqa sawa bei bei qaji naŋgi niŋgi qa tulaŋ ugeoqnsib jeutŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bati deqa tamo uŋgasari gargekoba e qa naŋgo areqalo siŋgilato qaji naŋgi ijo ñam ulontosib segi segi jeu sqab. Sosibqa naŋgo segi was naŋgi ojeleŋoqnsib tamo uge naŋgo baŋq di atoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Gisaŋ tamo tulaŋ gargekoba naŋgi boqnsib ijo segi tamo uŋgasari naŋgi endegsib minjroqnqab, ‘E Qotei aqa medabu o qaji tamo bole.’ Degsib naŋgi gisaŋnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kumbra uge deqaji tulaŋ kobaoqnimqa tamo gargekoba naŋgi qalaqalaiyo kumbra uratoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ariya niŋgi ijo ñam siŋgila na ojsib gilsib diŋo bati itqab di Qotei na niŋgi eleŋqas. ");
INSERT INTO boj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ijo wau tamo naŋgi sawa sawa kalil keretoqnsibqa Qotei aqa anjam bole mare mare laqnqab. Amqa diŋo bati brantqas. Anjam bole di aqa damu agiende. Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas.” ");
INSERT INTO boj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Osiqa Yesus a olo aqa aŋgro naŋgi endegsi minjrej, “Diŋo batiamqa iŋgi tulaŋ ugedamu Qotei aqa medabu o tamo Daniel a nami deqa marej qaji di brantim niŋgi unqab. Iŋgi ugedamu di a Qotei aqa getento warum miligiq di tigelesqas.” E Matyu. Tamo uŋgasari ijo anjam endi sisiyeqnub qaji naŋgi geregere sisiyosib poinjrem. Poinjrim marqab, bole. ");
INSERT INTO boj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Osiqa Yesus na aqa aŋgro naŋgi olo endegsi minjrej, “Niŋgi iŋgi ugedamu di unsibqa bati deqa tamo uŋgasari Judia sawaq di unub qaji naŋgi jaraiyosib manaq oqoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tamo uŋgasari tal meq di unub qaji naŋgi jaraiqa oqnsib iŋgi iŋgi oqa osibqa olo warum miligiq gilaib. Naŋgi jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tamo uŋgasari wauq di unub qaji naŋgi jaraiqa oqnsib naŋgo gara jugo oqa osibqa olo puluosib qureq baib. Naŋgi torei dena jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bati deqa uŋa gumaŋ ti uŋa aŋgro mom ti jaraiyo baŋgioqnsib gulbe koba oqab. ");
INSERT INTO boj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Deqa niŋgi endegsib pailyoqniy, ‘Gulbe di awa bati qa brantaiq. Yori bati qa dego brantaiq.’ ");
INSERT INTO boj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Niŋgi degsib pailyoqniy. Di kiyaqa? Bati deqa tamo uŋgasari naŋgi gulbe tulaŋ kobaquja oqab. Gulbe deqaji nami brantosaioqnej. Qotei na mandam atej bati deqa gulbe deqaji brantosai dena bosi bosiq agi bini unum. Bunuqna laŋa ambleq di dego brantqasai. Agi bati qujai deqa brantqas. ");
INSERT INTO boj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gulbe di aqa bati Qotei na truqutqas. A na truqutqasai di tamo uŋgasari kalil naŋgi padalekritqab. Aqa segi tamo uŋgasari nami giltnjrej qaji naŋgi padalaib deqa a na gulbe di aqa bati truqutqas. ");
INSERT INTO boj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bati deqa tamo qudei na merŋgwab, ‘Niŋgi uniy. Kristus bqo agiende’ o ‘Kristus bqo agide.’ Degsib merŋgibqa niŋgi naŋgo anjam quetnjraib. ");
INSERT INTO boj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tamo qudei naŋgi bosib gisaŋosib marqab, ‘E Kristus.’ Qudei marqab, ‘E Qotei aqa medabu o qaji tamo bole.’ Degsib maroqnsib maŋwa kokba babtoqnqab. Naŋgo maŋwa dena naŋgi na tamo uŋgasari kalil areqalo niñaqyetnjroqnqab. Osib Qotei aqa segi tamo uŋgasari nami giltnjrej qaji naŋgi dego areqalo niñaqyetnjrqajqa wauoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Niŋgi quiy. Kumbra kalil di brantosaisonaqa e namoqna merŋgonum. ");
INSERT INTO boj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Deqa tamo qudei na niŋgi endegsib merŋgwab, ‘Niŋgi uniy. Kristus bqo agi wadau sawaq di unu.’ Degsib merŋgibqa niŋgi naŋgo anjam di dauryosib wadau sawaq gilaib. Tamo qudei na niŋgi merŋgwab, ‘Kristus bqo agi talq di unu.’ Degsib merŋgibqa niŋgi naŋgo anjam quetnjraib. ");
INSERT INTO boj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Niŋgi qalie, kola minjaleqnaqa laŋ kalil suwaŋeqnu. Dego kere e Tamo Aŋgro laŋ qureq na boqnitqa tamo uŋgasari kalil naŋgi e nubqab. ");
INSERT INTO boj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Tamo naŋgo jejamu qusaeqnu qaji sawa dia qal naŋgi koroqab.” ");
INSERT INTO boj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Osiqa Yesus a olo marej, “Gulbe kalil di naŋgo bati koboamqa seŋ ambruqas. Bai dego suwaŋqasai. Bongar naŋgi laŋ goge na ululoŋosib mandamq aiyeleŋqab. Laŋ goge dia iŋgi iŋgi kalil reŋgiŋyeleŋqab. ");
INSERT INTO boj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bati deqa e Tamo Aŋgro bqai. Ijo toqor a laŋ goge dia brantimqa tamo uŋgasari sawa sawa kalilq di unub qaji naŋgi e qa akamugetqab. E siŋgila ti riaŋ ti laŋbiq na boqnit tamo uŋgasari kalil naŋgi e nubqab. ");
INSERT INTO boj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yimqa e siŋgila na gul anjamosiy ijo laŋ aŋgro naŋgi qariŋnjritqa naŋgi sawa sawa kalil keretosib Qotei aqa segi tamo uŋgasari nami giltnjrej qaji naŋgi laŋ utru utruq na koroinjrqab.” ");
INSERT INTO boj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Osiqa Yesus a olo marej, “E na qura qa yawo anjam niŋgi merŋgitqa dena poiŋgwas. Qura baŋga qalsim olo ñalguyoqnimqa niŋgi unsib qalieqab, ‘Seŋ aqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dego kere kumbra kalil e ubtosim merŋgonum qaji endi brantimqa niŋgi unsib endegsib qalieoiy, ‘Bole, Kristus bqajqa bati jojomqo. A siraŋmeq di tigelejunu.’ ");
INSERT INTO boj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","E bole merŋgwai. Tamo uŋgasari bini bati endeqa unub qaji naŋgi kalil moreŋosaisoqnibqa kumbra kalil endi branteleŋqas. ");
INSERT INTO boj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Laŋ ti mandam ti koboqab. Ariya ijo anjam koboqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Osiqa Yesus a olo marej, “Ijo bqajqa bati tamo qujai bei a qaliesai. Laŋ aŋgro naŋgi qaliesai. E Qotei aqa Ŋiri e segi dego qaliesai. Ijo Abu a segi qalie. ");
INSERT INTO boj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa aqa bati qa tamo uŋgasari naŋgi kumbra yoqneb dego kere e Tamo Aŋgro bqajqa bati qa tamo uŋgasari naŋgi kumbra degyoqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Agi Noa aqa bati qa mandam ya maqosaisonaqa tamo uŋgasari naŋgi iŋgi ti ya ti uyoqnsib uŋa baŋ ojeleŋoqnsib sonabqa Noa a qobuŋ miligiq gilej. ");
INSERT INTO boj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mandam ya maqosim naŋgi padaltnjrqas naŋgi deqa qaliesai. Naŋgi laŋa nanari soqneb. Sonabqa gulbe di naŋgoq di brantej. Dego kere e Tamo Aŋgro bqajqa bati qa tamo uŋgasari naŋgi nanari degsib sqab. ");
INSERT INTO boj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tamo aiyel wau qujaiq di iŋgi yagoqnibqa Qotei na bei laŋ qureq osi oqsimqa bei uratim sqas. ");
INSERT INTO boj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uŋa aiyel tal qujaiq di saplaŋ gereiyoqnibqa Qotei na bei laŋ qureq osi oqsimqa bei uratim sqas. ");
INSERT INTO boj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Deqa niŋgi geregere ŋam atiy. E nuŋgo Tamo Koba. E bati gembu bqai di niŋgi qaliesai. ");
INSERT INTO boj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Niŋgi are qaliy. Bati gembu bajiŋ tamo a bosim tal paratqas di tal lanja a qalieqasai. A nami qalieosiq sonaq qamu bajiŋ tamo bosiq tal paratqa yonaq unsiq wiyej qamu. ");
INSERT INTO boj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dego kere e Tamo Aŋgro bqajqa bati niŋgi qaliesai. E bosiy niŋgi pruqtŋgaim deqa niŋgi geregere ŋam atoqnsib e qa tariŋoqnsib soqniy.” ");
INSERT INTO boj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Osiqa Yesus a olo marej, “Kaŋgal tamo yai a areqalo bole ti sosiqa gaigai wau bole yeqnu? Kaŋgal tamo di tal lanja na endegsi minjqas, ‘Ni na ijo kaŋgal tamo kalil naŋgi geregere taqatnjroqnsimqa naŋgo iŋgi uyqajqa batioqnimqa iŋgi anainjroqnsim soqne.’ ");
INSERT INTO boj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Degsi minjsimqa sawa beiq gilsim di sqas. Olo puluosim wau kalil a na aqa kaŋgal tamo yej qaji di kalil keretosim soqnimqa a bosim unimqa kaŋgal tamo di a tulaŋ areboleboleiyqas. ");
INSERT INTO boj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Deqa e bole merŋgwai. Kaŋgal tamo di a wau boledamu yej deqa tal lanja na aqa iŋgi iŋgi kalil osim aqa baŋq di atim a na taqatetoqnqas. ");
INSERT INTO boj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ariya kaŋgal tamo di a tamo uge sqas di a endegsi are qalqas, ‘Ijo tamo koba a urur bqasai.’ ");
INSERT INTO boj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Degsi are qalsimqa a na kaŋgal tamo qudei a ombla wauo qaji naŋgi laŋa laŋa kumbaiŋnjroqnqas. Osim wain uyo tamo qudei naŋgi joqsim koba na iŋgi ti wain ti uyoqnsib nanarioqnqab. ");
INSERT INTO boj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aqa tamo koba bqajqa bati a qaliesai deqa a kumbra degsim yoqnimqa aqa tamo koba brantoqujatosim unimqa a tulaŋ prugugetqas. ");
INSERT INTO boj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Deqa aqa tamo koba a na qalougetosim gisaŋ tamo naŋgo so sawaq waiyim aiqas. Sawa dia tamo naŋgi tulaŋ akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas.” ");
INSERT INTO boj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Osiqa Yesus a olo marej, “Qotei laŋ qureq di unu qaji a na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di duŋgeŋge 10 naŋgo kumbra sigitejunu. E deqa niŋgi saiŋgwai. Tamo bei a uŋa baŋ ojej. A uŋa baŋ ojqa sawaq gilqa laqnaqa duŋgeŋge 10 naŋgi a ombla gilqa marsib naŋgo segi segi lam osib walwelosib aisib gamq di a qa tariŋoqneb. ");
INSERT INTO boj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Duŋgeŋge 5 naŋgi nanari. Duŋgeŋge 5 naŋgi powo ti. ");
INSERT INTO boj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Duŋgeŋge nanari naŋgo lam miligiq di ya kiñala segi soqnej. Naŋgi lam ya bei o ti aiyosai. ");
INSERT INTO boj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Duŋgeŋge powo ti naŋgi naŋgo lam osibqa lam ya jaliŋaq di qamsib o ti aiyeb. ");
INSERT INTO boj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ariya tamo a uŋa baŋ ojqa sawaq urur gilosai. A sokobaiyej. Deqa duŋgeŋge 10 naŋgi gamq di a qa tariŋosib sonabqa urŋamnjrnaqa ŋereŋeb. ");
INSERT INTO boj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ŋereŋesonabqa qolo jige tamo qudei naŋgi maosib mareb, ‘Tamo uŋa baŋ ojqo qaji agi gileqnu. Deqa niŋgi tigelosib walwelosib gamq di a turoiy.’ ");
INSERT INTO boj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Onaqa duŋgeŋge 10 naŋgi tigelosib naŋgo lam gereiyeb. ");
INSERT INTO boj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gereiyoqnsibqa duŋgeŋge nanari naŋgi na duŋgeŋge powo ti naŋgi minjreb, ‘Niŋgi lam ya kiñala egiy. Gago lam ya saiqo deqa mosoqa laqnu.’ ");
INSERT INTO boj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Onaqa duŋgeŋge powo ti naŋgi na kamba minjreb, ‘Lam ya endi gago segi qa kere. Iga niŋgi qa ti keresai. Deqa niŋgi olo sumsib nuŋgo segi lam ya awaiyiy.’ ");
INSERT INTO boj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Onaqa duŋgeŋge nanari 5 naŋgi tigelosib lam ya awaiyqajqa sumeqnabqa tamo di a uŋa baŋ ojqa sawaq giloqnej. Gileqnaqa duŋgeŋge powo ti naŋgi nami naŋgo lam gereiyosib soqneb deqa naŋgi na tamo di dauryosib uŋa baŋ ojqa sawaq gileb. Gilsib tal miligiq gilekritosib siraŋ kabuteb. ");
INSERT INTO boj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Sokiñalayonaq duŋgeŋge nanari naŋgi tal meq di brantosib maosib tamo di minjeb, ‘O Tamo Koba, iga bonum. Ni na siraŋme waqtetgime.’ ");
INSERT INTO boj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Onaqa a na kamba minjrej, ‘E bole merŋgwai. E niŋgi qaliesai.’” ");
INSERT INTO boj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Osiqa Yesus a olo marej, “Dego kere niŋgi geregere ŋam atsib soqniy. Di kiyaqa? Ijo bqajqa bati niŋgi qaliesai deqa.” ");
INSERT INTO boj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Osiqa Yesus a olo marej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo bei a sawa isaq gilsiq di soqnej dego kere. A gilqa osiqa aqa kaŋgal tamo naŋgi koroinjrsiqa naŋgi na aqa silali taqatqa minjrsiq naŋgo baŋq di uratetnjrej. ");
INSERT INTO boj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A na aqa kaŋgal tamo naŋgo segi segi siŋgila pegiyetnjrsiqa naŋgi wau yqajqa kere dego silali pupoiyosiqa enjrej. Bei 5,000 kina yej. Bei 2,000 kina yej. Bei 1,000 kina yej. Osiqa a sawa isaq gilsiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sonaqa kaŋgal tamo 5,000 kina ej qaji a silali dena wauosiqa olo 5,000 kina bei ej. ");
INSERT INTO boj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kaŋgal tamo 2,000 kina ej qaji a dego silali dena wauosiqa olo 2,000 kina bei ej. ");
INSERT INTO boj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ariya kaŋgal tamo 1,000 kina ej qaji a silali dena wauosai. A silali di osi gilsiqa mandamq di sub bogsiqa sub miligiq di ulitonaq soqnej. ");
INSERT INTO boj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bati olekoba yala koboonaqa tamo koba a olo puluosi bosiqa aqa kaŋgal tamo naŋgi wauqa silali enjrej qaji di metnjrej. Metnjrnaqa naŋgi aqa areq bonabqa a na minjrej, ‘E nami silali eŋgem qaji dena niŋgi waueb olo silali di osorbiy.’ ");
INSERT INTO boj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Onaqa kaŋgal tamo 5,000 kina ej qaji a na 5,000 kina bei osi bosiqa aqa tamo koba minjej, ‘O Tamo Koba, ni unime. Ino 5,000 kina nami ebem qaji dena e wauonamqa olo 5,000 kina bei brantej agiende.’ ");
INSERT INTO boj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Onaqa aqa tamo koba a na minjej, ‘Ni kaŋgal tamo bolequja. Ni wau kiñala geregere taqatonum deqa e wau gargekoba olo ino baŋq di uratitqa ni na taqatoqnqam. Deqa ni bosim e ombla areboleboleigim sqom.’ ");
INSERT INTO boj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Onaqa kaŋgal tamo 2,000 kina ej qaji a bosiqa aqa tamo koba minjej, ‘O Tamo Koba, ni unime. Ino 2,000 kina ebem qaji dena e wauonamqa olo 2,000 kina bei brantej agiende.’ ");
INSERT INTO boj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Onaqa aqa tamo koba a na minjej, ‘Ni dego kaŋgal tamo bolequja. Ni wau kiñala geregere taqatonum deqa e wau gargekoba olo ino baŋq di uratitqa ni na taqatoqnqam. Deqa ni bosim e ombla areboleboleigim sqom.’ ");
INSERT INTO boj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Onaqa kaŋgal tamo 1,000 kina ej qaji a bosiqa aqa tamo koba minjej, ‘O Tamo Koba, ni que. E nami qalieem, ni tamo ŋiriŋ ani. Tamo qudei naŋgi iŋgi yageqnab melieqnaqa ni segi na otorosim uyeqnum. Tamo qudei naŋgi saga yago breiyeqnab boleeqnaq ni segi na koroiyoqnsim uyeqnum. ");
INSERT INTO boj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Deqa e ni qa ulaosim ino 1,000 kina ebem qaji di osi gilsimqa mandamq di sub bogsim sub miligiq di ulitonam soqnej agiende.’ ");
INSERT INTO boj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Onaqa aqa tamo koba a na minjej, ‘Ni kaŋgal tamo uge. Ni lola ani. Ni nami qalieem, tamo qudei naŋgi iŋgi yageqnab melieqnaqa e segi na otorosim uyeqnum. Tamo qudei naŋgi saga yago breiyeqnab boleeqnaq e segi na koroiyoqnsim uyeqnum. Ni nami e qa degsim qalieem. ");
INSERT INTO boj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Deqa ni kiyaqa ijo silali di osi gilsim silali talq atosai? Ni di atem qamu e bosimqa silali talq dena ijo silali aqa oto kobaqo qamu turtosim onum qamu.’ ");
INSERT INTO boj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Degsi minjsiqa aqa kaŋgal tamo qudei naŋgi minjrej, ‘Niŋgi 1,000 kina di yaiyosibqa kaŋgal tamo nami wauosiqa 10,000 kina ejunu qaji di olo yiy. ");
INSERT INTO boj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Niŋgi degyiy. Di kiyaqa? Tamo a wau geregere taqatoqnqas di Qotei na olo wau yimqa a wau gargekoba taqatoqnqas. Ariya tamo a wau geregere taqatqasai di wau kiñala a na taqatejunu qaji di a olo bunu taqatqasai. Qotei na a kobotimqa a laŋa sqas. ");
INSERT INTO boj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Deqa niŋgi na kaŋgal tamo uge di qalaq di waiyibqa sawa ambruq di soqnem. Sawa dia naŋgi akamkobaoqnsib pailoqnsib naŋgo jaqatiŋ qa qalagei anjam atoqnqas.’” ");
INSERT INTO boj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Osiqa Yesus a olo marej, “Mondoŋ e Tamo Aŋgro ñam kobaquja oqai. Osiy laŋ aŋgro kalil naŋgi joqsiy mandamq aisiy ijo segi awo jaram kobaq di awesqai. ");
INSERT INTO boj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Awesoqnit sawa bei bei qaji kalil naŋgi bosib ijo ulatamuq di koroabqa e na naŋgi peginjrqai. E na naŋgi qudei ijo baŋ woq di ateleŋosiy olo naŋgi qudei ijo baŋ qonaŋq di ateleŋqai. Wagme taqato tamo naŋgi na kaja ti meme ti naŋgi peginjreqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Osiy tamo uŋgasari ijo baŋ woq di unub qaji naŋgi endegsi minjrqai, ‘Ijo Abu a niŋgi qa tulaŋ areboleboleiyeqnu. Nami a mandam atej bati deqa a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa gam gereiyetŋgej. Deqa niŋgi ijoq babqa ijo Abu na niŋgi taqatŋgwas. ");
INSERT INTO boj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Di kiyaqa? E mambonaqa niŋgi na e iŋgi anaibeb. E ya qarbonaqa niŋgi na e ya anaibeb. E yauŋ tamo sonamqa niŋgi na e osib nuŋgo talq di gereibeb. ");
INSERT INTO boj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","E gara saiqoji sonamqa niŋgi na gara tigetbeb. E maibonaqa niŋgi na e taqatbeb. E tonto talq di sonamqa niŋgi na bosib e gereibeb.’ ");
INSERT INTO boj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“E na tamo uŋgasari ijo baŋ woq di unub qaji naŋgi degsi minjritqa naŋgi e kamba nenembqab, ‘O Tamo Koba, bati gembu ni mammonaqa iga na iŋgi anaimem? Bati gembu ni ya qarmonaqa iga na ya anaimem? ");
INSERT INTO boj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bati gembu ni yauŋ tamo sonamqa iga ni osim gago talq di gereimem? Bati gembu ni gara saiqoji sonamqa iga na gara tigetmem? ");
INSERT INTO boj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bati gembu ni maimonaqa iga na taqatmem? Bati gembu ni tonto talq di sonamqa iga bosim ni gereimem?’ ");
INSERT INTO boj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Naŋgi e degsib nenembibqa e na kamba minjrqai, ‘E bole merŋgwai. Niŋgi na ijo was ñam saiqoji unub qaji naŋgi geregereinjroqneb di agi niŋgi e dego gereiboqneb.’ ");
INSERT INTO boj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ariya e na tamo uŋgasari ijo baŋ qonaŋq di unub qaji naŋgi endegsi minjrqai, ‘Niŋgi tamo uŋgasari tulaŋ ugedamu. Deqa niŋgi jaraiyiy. Jaraiyosib aisib ŋamyuwo gaigai yuejunu qaji dia soqniy. Satan aqa laŋ aŋgro naŋgi ti dia sqab. Qotei a nami ŋamyuwo di naŋgi gereiyetnjrej. ");
INSERT INTO boj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Deqa niŋgi ŋamyuwo deq aiyiy. Di kiyaqa? E mambonaqa niŋgi na e iŋgi anaibosai. E ya qarbonaqa niŋgi na e ya anaibosai. ");
INSERT INTO boj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","E yauŋ tamo sonamqa niŋgi na e osib nuŋgo talq di gereibosai. E gara saiqoji sonamqa niŋgi na gara tigetbosai. E maibonaqa niŋgi na e taqatbosai. E tonto talq di sonamqa niŋgi na bosib e gereibosai.’ ");
INSERT INTO boj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“E na tamo uŋgasari ijo baŋ qonaŋq di unub qaji naŋgi degsi minjritqa naŋgi e kamba nenembqab, ‘O Tamo Koba, bati gembu ni mammej? Bati gembu ni ya qarmej? Bati gembu ni yauŋ tamo soqnem? Bati gembu ni gara saiqoji soqnem? Bati gembu ni maimej? Bati gembu ni tonto talq di soqnem? O Tamo Koba, bati gembu ni degsi sonamqa iga ni numsim gereimosai?’ ");
INSERT INTO boj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Naŋgi e degsib nenembibqa e na kamba minjrqai, ‘E bole merŋgwai. Niŋgi na ijo was ñam saiqoji unub qaji naŋgi gereinjrosaioqneb di agi niŋgi e dego gereibosaioqneb.’ ");
INSERT INTO boj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","E na naŋgi degsi minjrsiyqa naŋgo awai uge enjrsiy breinjrit ŋamyuwoq aiqab. Dia naŋgi bati gaigai jaqatiŋ oqnsib sqab. Ariya tamo uŋgasari kumbra bole yeqnub qaji naŋgi ŋambile gaigai sqab.” ");
INSERT INTO boj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus a anjam kalil di marsiq koboonaqa a na aqa aŋgro naŋgi endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Niŋgi qalie, yori bati koba jojomqo. Bati aiyel unu. Yori bati di brantimqa Juda tamo kokba naŋgi na e Tamo Aŋgro ojsib jeu tamo naŋgo baŋq di atqab. Atibqa naŋgi na e ŋamburbasq di lubib moiqai.” Yesus na aqa aŋgro naŋgi degsi minjrej. Yori bati di Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa aqaryainjrej deqa olo are qalqajqa bati. ");
INSERT INTO boj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yori bati di jojomej deqa atra tamo kokba ti Israel naŋgo gate naŋgi ti gilsib atra tamo gate aqa ñam Kaiafas aqa talq di koroeb. ");
INSERT INTO boj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Koroosib endegsib nenemoqneb, “Iga kiyersim Yesus lumu na ojsim qalsim moiyotqom?” ");
INSERT INTO boj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Osib mareb, “Iga yori bati qa Yesus ojqasai. Ojqom di tamo uŋgasari naŋgi iga nugsib ŋiriŋosib qoto tigelto uge.” ");
INSERT INTO boj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Onaqa Yesus a Betani qureq gilsiqa tamo bei nami yu na aqa jejamu ugeeleŋej qaji aqa ñam Saimon aqa talq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sosiqa iŋgi uyeqnaqa uŋa bei a goreŋ quleq ti tulaŋ boledamu silali kobaquja na awaiyej qaji di jaliŋaq jigsiqa osi bosiqa Yesus aqa gateq di bilentej. ");
INSERT INTO boj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Onaqa Yesus aqa aŋgro naŋgi uŋa di aqa kumbra unsibqa ŋiriŋosib segi segi maroqneb, “Uŋa di a kiyaqa goreŋ di laŋa ñaŋguiyqo? ");
INSERT INTO boj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A goreŋ di osiq tamo qudei enjrqo qamu silali kobaquja yonub qamu gilsiq tamo iŋgi iŋgi saiqoji naŋgi jeisi enjrqo qamu di kere.” ");
INSERT INTO boj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Onaqa Yesus a naŋgo areqalo di qalieosiqa minjrej, “Niŋgi kiyaqa uŋa di gulbe yeqnub? A kumbra bole ebqo. ");
INSERT INTO boj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tamo iŋgi iŋgi saiqoji naŋgi bati gaigai niŋgi ti sqab. Ariya e bati gaigai niŋgi ti sqasai. ");
INSERT INTO boj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","E moiqai. Moiyitqa e subq atqab. Uŋa di a e qa are qalsiqa ijo jejamuq di goreŋ bilentosiq dena ijo jejamu subq atqajqa gereiyetbqo. ");
INSERT INTO boj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E bole merŋgwai. Bunuqna ijo wau tamo naŋgi sawa sawa kalilq di ijo anjam bole mare mare laqnsibqa uŋa endena kumbra ebqo qaji deqa are qaloqnsib a qa saoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Onaqa Judas Iskariot a tigelosiqa atra tamo kokba naŋgoq gilej. Judas a Yesus aqa aŋgro 12 naŋgi deqaji bei. ");
INSERT INTO boj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A naŋgoq gilsiqa minjrej, “Niŋgi na awai kiye ebibqa e Yesus osiy nuŋgo baŋq di atqai?” Onaqa naŋgi na meniŋ silali 30 yeb. ");
INSERT INTO boj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yonab a gilsiqa a Yesus osim naŋgo baŋq di atqajqa gam ŋamoqnej. ");
INSERT INTO boj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ariya Bem Tiyosai Qaji Uyqajqa Bati brantonaqa Yesus aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, ni iga merge. Iga aisim tal qabia yori bati aqa iŋgi iŋgi gereiyetmonamqa ni iŋgi uyqam?” ");
INSERT INTO boj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Onaqa Yesus na kamba minjrej, “Niŋgi aisib qure ambleq di tamo bei itqab. Itosib minjiy, ‘Qalie Tamo a marqo, “Ijo bati jojomqo. Deqa e ijo aŋgro naŋgi koba na ino talq di awoosim yori bati aqa iŋgi uyqom.” ’” ");
INSERT INTO boj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Onaqa Yesus aqa aŋgro naŋgi qure miligiq aisib anjam kalil Yesus na minjrej qaji degsib brantonab dauryosib iŋgi iŋgi kalil gereiyeleŋeb. ");
INSERT INTO boj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Onaqa bilaqtonaqa Yesus aqa aŋgro 12 naŋgi ti koba na aisib tal gogetosib awoosib iŋgi uyoqnsibqa Yesus na naŋgi endegsi minjrej, “E bole merŋgwai. Niŋgi ijo aŋgro 12. Nuŋgo ambleq dena aŋgro bei a tigelosim e osim tamo qudei naŋgo baŋq di atqas.” ");
INSERT INTO boj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Degsi minjrnaq qusibqa are tulaŋ gulbeinjrnaqa segi segi Yesus nenemyoqneb, “O Tamo Koba, ni e qa kiyo maronum?” ");
INSERT INTO boj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Onaqa minjrej, “Aŋgro aqo ombla endego tabir qujaiq di bem quiq di tuqteqnum qaji a na e osim tamo qudei naŋgo baŋq di atqas. ");
INSERT INTO boj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Niŋgi quiy. E Tamo Aŋgro moiqai. Nami Qotei aqa anjam degsib e qa neŋgreŋyeb. Deqa uŋgum. E anjam di dauryosiy moiqai. Ariya aŋgro e osim tamo qudei naŋgo baŋq di atqas qaji a tulaŋ padalougetqas. A nami ŋambabosai qamu di kere.” ");
INSERT INTO boj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Onaqa Judas agi Yesus osim jeu tamo naŋgo baŋq di atqas qaji a na Yesus nenemyej, “O Tamo Koba, ni e qa kiyo ubtosim maronum?” Onaqa Yesus na kamba minjej, “Od. Anjam agi ni na maronum.” ");
INSERT INTO boj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Osiqa Yesus aqa aŋgro naŋgi koba na iŋgi uyoqnsibqa Yesus a Qotei pailyosiqa bem bei osiq giŋgeŋyosiqa aqa aŋgro naŋgi enjrsiqa endegsi minjrej, “Endi ijo jejamu. Osib uyiy.” ");
INSERT INTO boj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Osiqa wain osiqa gambaŋq di bilentosiqa Qotei pailyosiqa aqa aŋgro naŋgi enjrsiqa minjrej, “Niŋgi kalil wain endi uyiy. ");
INSERT INTO boj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Endi ijo leŋ. Tamo uŋgasari gargekoba naŋgo une kobotetnjrqajqa deqa ijo leŋ aiqas. Aisim Qotei aqa anjam bunuj nami gereiyej qaji di siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","E niŋgi merŋgwai. E wain endi olo uyqasai. Degsi gilsiy mondoŋ diŋo batiamqa ijo Abu a nuŋgo Mandor Koba soqnimqa e niŋgi koba na awoosiy olo wain bunuj uyqai.” ");
INSERT INTO boj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesus na aqa aŋgro naŋgi degsi minjrsiqa naŋgi koba na louosib koboonaqa qure uratosib Oliv manaq oqeb. ");
INSERT INTO boj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesus aqa aŋgro naŋgi ti manaq oqoqnsibqa Yesus na minjrej, “Qolo qujai endeqa niŋgi kalil ijo ñam ulontosib e uratbosib jaraiqab. Nuŋgo kumbra deqa Qotei aqa anjam bei nami endegsib neŋgreŋyeb, ‘E na kaja naŋgo mandor qalitqa kaja naŋgi segi segi jaraiqab.’ Qotei aqa anjam nami degsib neŋgreŋyeb. ");
INSERT INTO boj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ariya bati qalub koboamqa e olo subq na tigelosiy niŋgi qa namoosiy Galili sawaq gilitqa niŋgi bunuqna e daurbosib dia e itbqab.” ");
INSERT INTO boj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Onaqa Pita na minjej, “Aŋgro kalil naŋgi ino ñam ulontosib jaraiqab e segi ino ñam ulontqasai.” ");
INSERT INTO boj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Onaqa Yesus na kamba minjej, “E bole mermqai. Qolo qujai endeqa ni ijo ñam ulitqam. Tuwe anjamosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai.’” ");
INSERT INTO boj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Onaqa Pita a tulaŋ saidosiq minjej, “Sai. E ni ombla moiqa marimqa, uŋgum, e ino ñam ulitqasai bole sai.” Onaqa Yesus aqa aŋgro kalil naŋgi anjam qujai di minjoqneb. ");
INSERT INTO boj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus aqa aŋgro naŋgi koba na walwelosib nañu agu beiq di branteb. Nañu agu di aqa ñam Getsemani. Di brantosib Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi endi awesoqniy. E kiñala sasalosiy ijo Abu pailyosiy bqai.” ");
INSERT INTO boj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Degsi minjrsiqa aqa aŋgro qalub agi Sebedi aqa ŋiri aiyel naŋgi Pita koba na joqsiqa pailyqajqa sasalej. Sasalosiqa pailyoqnsiqa a are tulaŋ gulbekobaiyej. ");
INSERT INTO boj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Osiqa aqa aŋgro qalub naŋgi minjrej, “E are tulaŋ gulbekobaibqo. Gulbe dena e moiyepratonum. Deqa niŋgi e ombla endi sosimqa ŋam atoqniy.” ");
INSERT INTO boj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Degsi minjrsiqa olo kiñala sasalosiqa mandamq di ŋam quosiqa Qotei pailyosiq minjej, “O ijo Abu, gam bei soqnimqa ni na marimqa gulbe endi ijoq baiq. Gulbe endi ya uge uyo bul. Uŋgum, ni ijo areqalo dauryaim. Ni ino segi areqalo dauryosim ye.” ");
INSERT INTO boj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesus a degsi Qotei pailyosiq olo tigelosiqa aqa aŋgro naŋgo areq aisiq ŋam atej di naŋgi are gulbe na ŋereŋesonab unjrej. Deqa Yesus na Pita minjej, “Niŋgi e ombla na ŋam sokiñalayqa keresai e? ");
INSERT INTO boj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Niŋgi ŋereŋaib. Niŋgi ŋam sosib pailyoqniy. Yim gulbe bei nuŋgoq bqas di gulbe dena niŋgi uneq waiŋgwasai. Bole, nuŋgo are miligiq di niŋgi e daurbqajqa are unu. Ariya niŋgi segi gulbe di oqajqa siŋgila saiqoji.” ");
INSERT INTO boj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Osiqa Yesus a olo puluosi sasalosiq endegsi pailyej, “O ijo Abu, gam bei saiamqa, uŋgum, ni ino segi areqalo dauryosim marimqa e gulbe endi oqai.” ");
INSERT INTO boj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Degsi pailyosiq bosiqa aqa aŋgro qalub naŋgi urŋamnjrnaqa ŋereŋesonab unjrej. ");
INSERT INTO boj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Unjrsiqa olo naŋgi uratnjrsiq puluosi gilsiq a nami pailyej qaji degsi olo pailyej. ");
INSERT INTO boj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Osiqa a olo aqa aŋgro naŋgo areq aisiq minjrej, “Niŋgi aqaratosib geregere ŋereŋejunub e? Uŋgum. Bati koboqo. Niŋgi uniy. E Tamo Aŋgro osib une tamo naŋgo baŋq di atqajqa bati bqo. ");
INSERT INTO boj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Niŋgi tigelab gilqom. Tamo e osim naŋgo baŋq di atqajqa agi brantqo.” ");
INSERT INTO boj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Onaqa Yesus aqa aŋgro 12 naŋgi deqaji bei agi Judas a na tamo gargekoba naŋgi sebru ti torom ti eleŋonab joqsiqa Yesus aqa areq di branteb. Israel naŋgo gate naŋgi ti atra tamo kokba ti naŋgi na naŋgi qariŋnjrnab Yesus ojqa beb. ");
INSERT INTO boj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas a nami naŋgi ti qairosib anjam gereiyosib a na endegsi minjrej, “E tamo kundoqyqai agide. A ojsib osib giliy.” ");
INSERT INTO boj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Onaqa Judas a Yesus aqa areq bosiq minjej, “O Tamo Koba, qolo bole.” Degsi minjsiq kundoqyej. ");
INSERT INTO boj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kundoqyonaqa Yesus na minjej, “O was, ni kumbra kiye e ebqa bonum ni degye.” Degsi minjnaqa tamo naŋgi di brantosib baŋ waiyosib Yesus ojeb. ");
INSERT INTO boj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Onaqa Yesus aqa aŋgro bei na aqa sebru osiqa atra tamo gate aqa kaŋgal tamo gateq di qalqajqa sebru waiyej grotosiqa dabkala segi gentetej. ");
INSERT INTO boj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Onaqa Yesus na aqa aŋgro di minjej, “Ino sebru olo ate. Tamo kalil sebru na qotqab qaji naŋgi sebru na moreŋqab. ");
INSERT INTO boj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ni que. E ijo Abu minjqai di a na laŋ aŋgro 72,000 naŋgi qariŋnjrimqa bosib e aqaryaibqab. Ni di qaliesai kiyo? ");
INSERT INTO boj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ariya e ijo Abu degsi minjqasai. Minjqai di aqa anjam neŋgreŋq di unu qaji di aqa damu brantqasai. Agi nami endegsib neŋgreŋyeb, ‘Kristus a moiqas.’” ");
INSERT INTO boj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Osiqa bati deqa Yesus na tamo naŋgi di minjrej, “E leŋ ojo tamo unum deqa kiyo niŋgi sebru ti torom ti eleŋosib e ojqa bonub e? E bati gaigai atra tal miligiq di sosimqa Qotei aqa anjam plaltoqnem. Bati deqa niŋgi yala baŋ waiyosib e ojosai. ");
INSERT INTO boj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Niŋgi kumbra degyeb deqa Qotei aqa medabu o tamo naŋgo anjam neŋgreŋq di unu qaji di aqa damu agi brantej.” Yesus a naŋgi degsi minjrnaqa aqa aŋgro kalil naŋgi a uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Onaqa tamo Yesus ojeb qaji naŋgi na a osib atra tamo gate aqa ñam Kaiafas aqa talq osi gileb. Dia Juda gate naŋgi ti dal anjam qalie tamo naŋgi ti kalil koroesoqneb. Koroesonabqa tamo naŋgi na Yesus osi gilsib naŋgo ulatamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Naŋgi Yesus osi gileqnabqa Pita a kiñala isa isaq na Yesus dauryosiq uli uliosiq gilsiq torei atra tamo gate aqa tal meq di brantej. Brantosiqa naŋgi Yesus kiyeryib unqajqa deqa are qalsiq qaja tamo qudei naŋgo ambleq di awesoqnej. ");
INSERT INTO boj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Onaqa atra tamo kokba ti Juda gate naŋgi ti kalil koroesosibqa naŋgi gisaŋ anjam na Yesus aqa jejamuq di une qametqa are qalsib anjam ŋamoqneb. Di kiyaqa? Anjam dena naŋgi Yesus qalib moiqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Anjam ŋamonab ŋamonab ugeinjrej. Deqa naŋgi tamo gargekoba metnjreqnab boqnsib gisaŋ anjam Yesus aqa jejamuq di qameleŋoqneb. Naŋgo ambleq dena tamo aiyel tigelosib Yesus aqa jejamu laŋa gisaŋyosib mareb, ");
INSERT INTO boj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Tamo endi a endegsi marnaq iga quem, ‘E Qotei aqa atra tal koba endi koŋgrontosiyqa bati qalub qa olo tigeltqai.’” ");
INSERT INTO boj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Onaqa atra tamo gate a naŋgo anjam di qusiqa a tigelosiqa Yesus aqa areq bosiq nenemyej, “Tamo naŋgi endi une gargekoba ino jejamuq di qameqnub. Di ni kamba anjam bei marqasai e?” ");
INSERT INTO boj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Onaqa Yesus a torei mequmej. A anjam bei yala marosai. Deqa atra tamo gate na olo nenemyej, “Qotei ŋambile gaigai unu qaji aqa ñam na e ni nenemmqai, ni Kristus e? Ni Qotei aqa Ŋiri e? Ni e merbe.” ");
INSERT INTO boj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Onaqa Yesus na minjej, “Od. Anjam ni maronum di kere. Ni que. E Tamo Aŋgro. Bunuqna e laŋ qureq oqsiy Qotei siŋgila koba ti unu qaji aqa baŋ woq di awesosiy olo laŋbiq na boqnit niŋgi e nubqab.” ");
INSERT INTO boj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Onaqa atra tamo gate a Yesus aqa anjam di qusiqa a tulaŋ minjiŋ oqetonaqa aqa segi gara jugo bumbraŋyosiqa marej, “Aqa une agi a segi babtqo iga quonum. Deqa iga kiyaqa tamo bei olo metonam bosim aqa une marqas? Aqa misiliŋ anjam niŋgi quonub. ");
INSERT INTO boj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Deqa niŋgi kiyersib marqab?” Onaqa naŋgi kalil mareb, “A bole une ti. Deqa qalib moiyem.” ");
INSERT INTO boj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Naŋgi kalil degsib marnabqa naŋgo ambleq dena tamo qudei naŋgi tigelosib Yesus aqa ulatamuq di miselyoqnsib baŋ na qaloqneb. Osib aqa ŋamdamu gara na qosetosib ula poŋyoqnsib minjoqneb, “Ni Kristus amqa ni ubtosim mare, yai na ni lumqo?” ");
INSERT INTO boj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ariya Pita a tal meq di awesonaqa kaŋgal uŋa bei na aqa areq bosiqa minjej, “Ni dego Yesus Galili qaji aqa aŋgro bei. Ni nami a dauryosim laqnem.” ");
INSERT INTO boj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Onaqa Pita a tamo kalil naŋgo ŋamdamuq di tulaŋ saidosiq uŋa di minjej, “Ni anjam merbonum di e qaliesai.” ");
INSERT INTO boj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Degsi minjsiqa tigelosiq tal qala beiq gilsiq di soqnej. Sonaqa kaŋgal uŋa bei na Pita unsiqa tamo naŋgi Pita aqa areq di tigelesoqneb qaji naŋgi minjrej, “Tamo di a dego Yesus Nasaret qaji aqa aŋgro bei. A nami Yesus dauryosiq laqnej.” ");
INSERT INTO boj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Onaqa Pita a olo tulaŋ saidosiq marej, “E tamo di qaliesai bole sai. E bole maronum.” ");
INSERT INTO boj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Olo kiñala soboleiyonaq tamo qudei jojom di tigelesoqneb qaji naŋgi Pita aqa areq bosib minjeb, “Iga ino anjam maro na qalieonum, ni Galili qaji tamo. Dena iga poigwo, ni Yesus aqa aŋgro bei.” ");
INSERT INTO boj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Onaqa Pita a olo tulaŋ siŋgila na saidosiq marej, “E tamo di qaliesai bole sai. E bole maronum. E gisaŋot Qotei na e lubem.” A degsi marnaqa tuwe anjamej. ");
INSERT INTO boj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tuwe anjamonaqa Pita a qusiqa anjam nami Yesus na minjej qaji, “Tuwe anjamosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai,’” anjam deqa olo are qalsiqa poiyonaqa oqedosiqa tulaŋ akamugetej. ");
INSERT INTO boj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Onaqa nobqolo malu qameqnaq atra tamo kokba ti Israel naŋgo gate naŋgi ti kalil koroesosibqa Yesus qalib moiqajqa anjam keretoqneb. Anjam kereonaq naŋgi Yesus aqa baŋ tontetosib osi gilsib Rom naŋgo gate Pailat aqa baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Atra tamo kokba ti Juda gate naŋgi ti Yesus qalib moiqajqa anjam keretonabqa Judas a qusiqa olo areqalo bei osiqa naŋgo areq bosiq minjrej, “E une kobaquja yonum. Tamo e nuŋgo baŋq di atonum qaji a une saiqoji. Niŋgi a laŋa qalsib moiyotqab. Deqa meniŋ silali 30 niŋgi na ebeb qaji endi olo oiy.” Degsi minjrnaqa naŋgi na kamba minjeb, “Di gago gulbe sai. Di ino segi gulbe.” ");
INSERT INTO boj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Onaqa Judas a silali di olo osi gilsiqa atra tal meq di breiyosiqa aisiq a segi na aqa kakroq di sil waiyosiq gaiŋosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Onaqa atra tamo kokba naŋgi mareb, “Silali endi tamo qalib moiqajqa aqa awai. Deqa iga silali endi atra tal aqa silali ti turtqasai.” ");
INSERT INTO boj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naŋgi degsib marsibqa silali di olo osib web gereiyo qaji tamo bei aqa mandam mutu bei awaiyeb. Yauŋ tamo naŋgi moreŋoqnibqa mandam mutu dia subq ateleŋqajqa deqa awaiyeb. ");
INSERT INTO boj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mandam mutu di “Leŋ Aiyo Qaji Mandam” ñam degsib waiyeb. Ñam di bini mareqnub. ");
INSERT INTO boj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Deqa anjam bei Qotei aqa medabu o tamo Jeremaia a nami marej qaji di aqa damu brantej. A endegsi marej, “Israel naŋgi Kristus aqa jejamu awaiyqa marsib meniŋ silali 30 atqab. Atsib silali di olo osib web gereiyo qaji tamo bei aqa mandam mutu bei awaiyqab. Tamo Koba a na anjam degsi merbqo.” Jeremaia a nami degsi marej. ");
INSERT INTO boj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Onaqa Yesus a Pailat aqa ulatamuq di tigelonaqa Pailat na nenemyej, “Ni Juda naŋgo Mandor Koba e?” Onaqa Yesus na minjej, “Od. Anjam ni maronum di kere.” ");
INSERT INTO boj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Onaqa atra tamo kokba ti Juda gate naŋgi ti Yesus aqa anjam di qusib minjiŋ oqetnjrnaqa Yesus gisaŋyoqnsib aqa jejamuq di une gargekoba qameleŋoqneb. Onaqa Yesus a torei mequmej. A anjam bei kamba yala marosai. ");
INSERT INTO boj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Deqa Pailat na olo Yesus nenemyej, “Naŋgi une gargekoba ino jejamuq di qameqnub. Di ni queqnum e?” ");
INSERT INTO boj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Onaqa Yesus a kamba anjam bei marosai. Deqa Pailat a tulaŋ prugugetej. ");
INSERT INTO boj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat aqa kumbra agiende. Wausau gaigai yori bati koba brantoqnimqa Juda tamo uŋgasari naŋgi tamo qujai aqa ñam maroqnibqa Pailat na tamo di tonto talq dena uratoqnsim enjroqnqas. ");
INSERT INTO boj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bati deqa tamo bei aqa ñam Barabas a tonto talq di soqnej. A leŋ ojo tamo. ");
INSERT INTO boj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Deqa tamo uŋgasari kalil naŋgi Pailat aqa areq di koroonabqa a na nenemnjrej, “E tamo yai tonto talq dena uratosiy eŋgwai? E Barabas uratosiy eŋgwai kiyo Yesus agi niŋgi Kristus qa mareqnub qaji a uratosiy eŋgwai kiyo? Niŋgi na merbiy.” ");
INSERT INTO boj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat a naŋgi degsi nenemnjrej. Di kiyaqa? A qalieej, atra tamo kokba naŋgi Yesus qa ugeosib deqa a ojsib Pailat aqa baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bati di Pailat a une pegiyo qaji awo jaramq di awesonaqa aqa ŋauŋ na anjam bei pepa mutu kiñalaq di neŋgreŋyosiq Pailat aqaq qariŋyej. A endegsi neŋgreŋyej, “Yesus aqa jejamuq di une saiqoji. Deqa ni a kumbra uge bei yaim. Qolo e ŋeiobilqeiosim Yesus unonum. Deqa e are tulaŋ gulbekobaibqo.” ");
INSERT INTO boj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Onaqa Juda gate naŋgi ti atra tamo kokba ti naŋgi na tamo uŋgasari naŋgo areqalo tigeltetnjreb. Tamo uŋgasari naŋgi Pailat minjibqa a na Barabas uratosim enjrsim olo Yesus qalim moiqajqa deqa naŋgo areqalo tigeltetnjreb. ");
INSERT INTO boj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Onaqa Pailat na olo tamo uŋgasari naŋgi nenemnjrej, “E tamo yai uratosiy eŋgwai? Barabas kiyo Yesus kiyo? Niŋgi na merbiy.” Onaqa naŋgi na kamba minjeb, “Ni Barabas uratosim ege.” ");
INSERT INTO boj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Onaqa Pailat na olo minjrej, “E niŋgi Barabas eŋgwajqa merbonub deqa e Yesus kiyeryqai? Agi niŋgi a qa mareqnub. ‘A Kristus.’” Onaqa naŋgi kalil murqumyosib minjeb, “Ni Yesus osim ŋamburbasq di qame.” ");
INSERT INTO boj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Onaqa minjrej, “Kiyaqa Yesus qalit moiqas? A une kiye yqo deqa a ŋamburbasq di qamqai?” Degsi minjrnaqa naŋgi olo tulaŋ murqumyoqnsib waiŋyoqnsib minjoqneb, “Ni a ŋamburbasq di qame.” ");
INSERT INTO boj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Onaqa Pailat a naŋgo anjam di qusiqa endegsi poiyej, “Tamo uŋgasari naŋgi ijo anjam quetbqasai. E naŋgi saidnjrqai di naŋgi ŋiriŋosib qoto tigeltqab.” Pailat a degsi poiyej deqa a tamo uŋgasari naŋgo ulatamuq di ya bei tabirq di qamsiqa ya dena aqa baŋ yansosiqa minjrej, “Yesus a moiqas di nuŋgo une. Di ijo une sai.” ");
INSERT INTO boj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Onaqa tamo uŋgasari naŋgi na minjeb, “Di kere. Uŋgum. Yesus a moiqas di gago une. Di gago aŋgro naŋgo une dego.” ");
INSERT INTO boj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naŋgi Pailat degsib minjnabqa a naŋgo anjam di dauryosiqa Barabas tonto talq dena oqeq atsiqa naŋgi enjrej. Enjrsiqa olo Yesus osiq qaja tamo naŋgo baŋq di atsiqa minjrej, “Niŋgi Yesus bu toqoŋ na kumbaiŋyiy.” Degsi minjrnaqa naŋgi na Yesus osib kumbaiŋyeb. Kumbaiŋyosib koboonaqa Pailat na olo minjrej, “Niŋgi Yesus ŋamburbasq di qamqajqa osib giliy.” ");
INSERT INTO boj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailat na qaja tamo naŋgi degsi minjrnaqa naŋgi Yesus osib Rom naŋgo tal kobaqujaq osi gileb. Osi gilsib qaja tamo kalil naŋgi metnjrnab bosib tal dia koroeb. ");
INSERT INTO boj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Koroosib Yesus aqa gara piqtetosib gara jugo olekoba lent mandor kokba naŋgi gaigai jigeqnub deqaji bei osib Yesus jigeteb. ");
INSERT INTO boj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Osib sil luwit osib lulumosib sil dena mandor naŋgo gate tatal bul gereiyosib aqa gateq di atetosib siŋgila na teqiyeb. Osib bu toqoŋ kaneŋo osib Yesus aqa baŋ woq di yonab a mandor koba bul ojsiq tigelesoqnej. Osib aqa areq di siŋga pulutosib a gisaŋ na biŋiyoqnsib minjoqneb, “O Juda naŋgo Mandor Koba, kaiye.” ");
INSERT INTO boj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Degsib Yesus minjoqnsib a miselyoqnsib bu toqoŋ esoqnej qaji di tatruiyosib dena aqa gateq di qaloqneb. ");
INSERT INTO boj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Naŋgi degsib Yesus misiliŋyosib koboonaqa gara lent di piqtetosib aqa segi gara olo jigetosib aqa qawarq di ŋamburbas atetosib a baŋ ojsib gaintqa sawaq osi gileb. ");
INSERT INTO boj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Naŋgi Yesus osi giloqnsibqa gamq di tamo bei walwelosiq aiyeqnaqa a turosib ojsib Yesus aqa qawarq dena ŋamburbas yaiyosib tamo di yonabqa a kamba qoboiyosiqa gam na Yesus dauryosiq giloqnej. Tamo di aqa ñam Saimon. A Sairini qure qaji. ");
INSERT INTO boj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naŋgi Yesus osi gilsib sawa agu kiñala bei aqa ñam Golgota di branteb. Ñam di aqa damu, “Tamo gate tanu.” ");
INSERT INTO boj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Di brantosib qaja tamo naŋgi na wain ya ti kial aqa ya isa koba de ti bulyosib Yesus anaiyonab uyo oneiyonaq ugeiyonaq uratej. ");
INSERT INTO boj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Onaqa qaja tamo naŋgi na Yesus osib ŋamburbasq di qameb. Qamsib Yesus aqa gara eleŋqa marsib gilteleŋeb. Osib meniŋ silali alaŋeb. Tamo yai aqa meniŋ na buŋnjrqas di a na gara oqas. Degsib marsib meniŋ silali alaŋosib gara eleŋeb. ");
INSERT INTO boj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Onaqa Yesus a ŋamburbas goge di gaiŋesonaqa qaja tamo naŋgi ŋamburbas utruq di awoosib Yesus taqatesoqneb. ");
INSERT INTO boj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Osib ŋamburbas mutu gogeq di anjam endegsib neŋgreŋyeb, “Tamo endi Yesus. A Juda naŋgo Mandor Koba.” Yesus a nami maroqnej, “E Juda naŋgo Mandor Koba.” Yesus aqa une deqa osib anjam di neŋgreŋyeb. ");
INSERT INTO boj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bati deqa bajiŋ tamo aiyel dego ŋamburbasq di gaintnjrsib ñumeb. Bei Yesus aqa baŋ woq di qameb. Bei Yesus aqa baŋ qonaŋq di qameb. ");
INSERT INTO boj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yesus a ŋamburbas goge di sonaqa tamo uŋgasari naŋgi aqa ulatamuq dena walwelosib gile beoqnsib a misiliŋyoqnsib gate gaiŋyoqnsib minjoqneb, ");
INSERT INTO boj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ni nami marem, ‘E atra tal koba koŋgrontosiyqa bati qalub qa olo tigeltqai.’ Ni degsi marem deqa ni ino segi jejamu aqaryaiye. Ni Qotei aqa Ŋiriamqa ni ŋamburbas uratosim mandamq aiye.” ");
INSERT INTO boj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Atra tamo kokba ti dal anjam qalie tamo naŋgi ti Juda gate naŋgi ti dego Yesus degsib misiliŋyoqneb. Osib segi segi maroqneb, “A na tamo uŋgasari gargekoba naŋgi aqaryainjroqnej. Ariya a na aqa segi jejamu aqaryaiyqa keresai. A Israel naŋgo Mandor Koba boleamqa a ŋamburbas uratosim mandamq aiyimqa iga unsim marqom, ‘Bole.’ ");
INSERT INTO boj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A segi mareqnu, ‘E Qotei qa ijo areqalo siŋgilatejunum. E segi Qotei aqa Ŋiri.’ Aqa anjam di boleamqa Qotei na endego aqaryaiyem.” ");
INSERT INTO boj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Onaqa bajiŋ tamo aiyel Yesus ombla gaintnjreb qaji naŋgi dego Yesus degsib misiliŋ anjam minjoqneb. ");
INSERT INTO boj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Qanam jige seŋ bati 12 onaqa sawa kalil tulaŋ ambruosi sonaq gilsiq seŋ bati 3 onaq bilaqtej. ");
INSERT INTO boj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Onaqa Yesus a tulaŋ leleŋosiqa marej, “Eloi, Eloi, lema sabaktani?” Di Hibru anjam. Anjam di aqa damu, “O ijo Qotei, O ijo Qotei. Ni kiyaqa e qoreibonum?” ");
INSERT INTO boj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Onaqa tamo qudei Yesus aqa areq di tigelesoqneb qaji naŋgi aqa anjam di qusib mareb, “A Elaija meteqnu.” ");
INSERT INTO boj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Degsib marnabqa tamo bei a urur ti gilsiq gara ñeŋgi bei osiq wain isa kobaq di tuqtosiqa soruq di qosisiqa osi bosiqa Yesus anaiyqajqa soqtosiqa aqa medabuq di atej. ");
INSERT INTO boj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Onaqa tamo qudei naŋgi mareb, “Iga mati tariŋosim koqyesqom. Elaija a bosim Yesus ŋamburbasq dena osim mandamq atqas kiyo?” ");
INSERT INTO boj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Onaqa Yesus a olo tulaŋ leleŋosiqa mondor titosiq aqa ŋambile uratosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bati qujai deqa gara kobaquja atra tal miligiq di gaiŋesoqnej qaji a goge na braŋosiq aisiq poaiyelej. Onaqa mimiŋ kobaquja dego dosiq mandam reŋgiŋyonaqa meniŋ kokba paraparaeleŋeb. ");
INSERT INTO boj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Bati deqa Qotei aqa segi tamo uŋgasari gargekoba nami moreŋeb qaji naŋgo sub waqeleŋonabqa naŋgi olo subq na tigeleb. Bunuqna Yesus a dego subq na tigelonaqa tamo uŋgasari naŋgi di Qotei aqa qure koba Jerusalem miligiq gileb. Gilnabqa tamo gargekoba naŋgi na unjreb. ");
INSERT INTO boj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ariya qaja tamo naŋgi ŋamburbas utruq di Yesus taqatesoqneb qaji naŋgo gate ombla na mimiŋ dosiq mandam reŋgiŋyonaq meniŋ kokba paraparaeleŋonab unsibqa naŋgi tulaŋ ulaugetosib mareb, “Bole. Tamo endi a Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Uŋgasari gargekoba naŋgi isaq di tigelesosib Yesus koqyoqneb. Bei Maria Makdala qure qaji. Maria bei agi Jems Josep wo naŋgo ai. Ariya uŋa bei Sebedi aqa ŋiri aiyel naŋgo ai. Yesus a nami Galili sawaq di sonaqa uŋgasari naŋgi dena a dauryosib laqnsib kaŋgalyoqneb. Bati Yesus a Galili sawa uratosiqa a na naŋgi joqsiqa koba na Jerusalem beleŋeb. ");
INSERT INTO boj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Onaqa bilaqtonaqa ñoro tamo bei aqa ñam Josep a Yesus aqa jejamu osim subq atqa marsiqa Pailat a nenemyqa gilej. Josep a Arimatea qure qaji. A dego Yesus dauryoqnej qaji. Deqa a Pailat aqa talq gilsiqa nenemyej, “Ni e odbimqa e Yesus aqa jejamu osiy subq atqa kere e?” Onaqa Pailat na odyosiqa aqa qaja tamo qudei naŋgi minjrej, “Niŋgi Yesus aqa jejamu osib Josep yiy.” ");
INSERT INTO boj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Onaqa Josep na Yesus aqa jejamu osi gilsiqa gara qat omu na dalaosiq aqa segi sub bunuj nami meniŋ miligiq di gereiyej qaji dia atej. Atsiqa meniŋ kobaquja belbeltosiq dena sub me getentej. Osiqa olo aiyej. ");
INSERT INTO boj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Onaqa Maria Makdala qure qaji wo Maria bei wo bosib sub areq di awoosib taqatesoqneb. ");
INSERT INTO boj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Juda naŋgo yori bati brantqa laqnej deqa yori bati aqa iŋgi iŋgi kalil gereiyosib atnab soqnej. Deqa atra tamo kokba ti Farisi naŋgi ti Pailat aqa talq gilsib minjeb, ");
INSERT INTO boj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“O Tamo Koba, Yesus a gisaŋ tamo. Deqa a moiyosaisosiqa endegsi marnaq iga quem, ‘Bati qalub koboamqa e olo subq na tigelqai.’ A degsi marnaq iga quem. ");
INSERT INTO boj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Deqa ni ino qaja tamo qudei qariŋnjrimqa naŋgi gilsib sub me geregere getentosib taqatesoqnibqa bati qalub koboqas. Ni degye. Ni degyqasai di Yesus aqa aŋgro naŋgi gilsib aqa jejamu bajiŋosib gisaŋosib tamo uŋgasari naŋgi minjrqab, ‘Yesus a subq na tigelqo.’ Yimqa naŋgo gisaŋ anjam di tulaŋ kobaosim Yesus aqa gisaŋ anjam nami marej qaji di tulaŋ buŋyqas.” ");
INSERT INTO boj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Onaqa Pailat na minjrej, “Niŋgi nuŋgo segi qaja tamo qudei joqsib gilibqa naŋgi sub me geregere getentosib taqatesqab.” ");
INSERT INTO boj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pailat a naŋgi degsi minjrnaqa naŋgi na qaja tamo qudei naŋgi joqsib gilsib minjreb, “Niŋgi na sub me geregere taqatesoqniy.” Degsib minjrsib meniŋ kobaquja nami sub me getentesoqnej qaji di olo geregere siŋgilatosib sub meq di saga waiyeb. Naŋgi degyeb. Di kiyaqa? Yesus aqa aŋgro naŋgi bunuqna bosib saga olo taqal atqab di tamo kalil naŋgi poinjrqas, Yesus aqa aŋgro naŋgi aqa jejamu bajiŋonub. ");
INSERT INTO boj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yori bati koboonaqa nebeonaq nobqolo ambru Maria Makdala qure qaji wo Maria bei wo tigelosib Yesus aqa sub unqajqa gileb. ");
INSERT INTO boj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naŋgi gileqnabqa Tamo Koba aqa laŋ aŋgro bei a laŋ goge na aisiqa meniŋ kobaquja sub me getentesoqnej qaji di belbeltosiq qalaq di atsiqa meniŋ quraq di awesoqnej. Awesonaqa mimiŋ kobaquja dej. ");
INSERT INTO boj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Laŋ aŋgro di aqa ulatamu kola bul tulaŋ minjalej. Aqa gara laŋbi bul tulaŋ qat. ");
INSERT INTO boj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Onaqa qaja tamo sub me taqatesoqneb qaji naŋgi na laŋ aŋgro di unsibqa naŋgi tulaŋ ulaugetosib gindagindaŋosib mandamq di ululoŋosib tamo moreŋo bul tindaŋesoqneb. ");
INSERT INTO boj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Onaqa laŋ aŋgro na uŋa aiyel di minjrej, “Niŋgi ulaaib. E qalie, niŋgi Yesus ŋamburbasq di qameb qaji a qa ŋameqnub. ");
INSERT INTO boj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A endi sosai. A subq na tigelqo. Agi a nami niŋgi endegsi merŋgej, ‘E subq na tigelqai.’ Deqa niŋgi aiyel bosib sub miligi uniy. A ŋeioteb qaji lume agi unu. ");
INSERT INTO boj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Niŋgi unsibqa olo puluosib gurgur ti aisib Yesus aqa aŋgro naŋgi endegsib minjriy, ‘Yesus a subq na tigelqo. Tigelosiq niŋgi qa namoosiq Galili sawaq gilqo. Niŋgi dego Galili sawaq gilsib dia a itqab.’ O uŋa aiyel, e niŋgi anjam di merŋgwa bonum.” ");
INSERT INTO boj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Onaqa uŋa aiyel di naŋgi tulaŋ ulaugeteb. Osib naŋgi olo areboleboleinjrej. Deqa naŋgi subq dena olo puluosib laŋ aŋgro na anjam minjrej qaji di Yesus aqa aŋgro naŋgi minjrqajqa gurgur ti aiyeb. ");
INSERT INTO boj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aiyeqnabqa gamq di Yesus a segi naŋgi aiyel turosiqa minjrej, “Nobqolo bole.” Degsi minjrnaqa naŋgi aiyel aqa areq bosibqa aqa siŋga ojsib a biŋiyeb. ");
INSERT INTO boj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Onaqa Yesus na minjrej, “Niŋgi ulaaib. Niŋgi aisib ijo was naŋgi endegsib minjriy, ‘Niŋgi Galili sawaq giliy. Gilsib dia Yesus itqab.’” ");
INSERT INTO boj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Uŋa aiyel aiyeqnabqa qaja tamo qudei sub taqatesoqneb qaji naŋgi tigelosib qure miligiq aiyeb. Aisib kumbra kalil subq di brantonaq uneb qaji di atra tamo kokba naŋgi sainjreb. ");
INSERT INTO boj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sainjrnab qusibqa Juda gate kalil naŋgi metnjrnab bosib koroosib anjam qosisib qaja tamo naŋgi di silali kobaquja enjreb. Osib minjreb, ");
INSERT INTO boj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Niŋgi na tamo uŋgasari naŋgi anjam endegsib minjroqniy, ‘Iga sub taqatosim ŋereŋesonamqa Yesus aqa aŋgro naŋgi qolo bosib subq dena Yesus aqa jejamu bajiŋosib jaraiyeb.’ ");
INSERT INTO boj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yimqa Pailat a nuŋgo anjam di qusim niŋgi qa ŋiriŋamqa iga na aqa are olo latetosim anjam gereiyonamqa a niŋgi gulbe bei eŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Onaqa qaja tamo naŋgi silali di osib atra tamo kokba naŋgo anjam dauryosib Yesus aqa aŋgro naŋgi na aqa jejamu subq dena bajiŋeb anjam di mare mare laqneb. Laqnab Juda tamo uŋgasari tulaŋ gargekoba naŋgi anjam di queleŋosib naŋgi kamba saoqneb agi bini saoqnsib unub. ");
INSERT INTO boj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Onaqa Yesus aqa aŋgro 11 naŋgi Galili sawaq gilsib mana bei Yesus a nami naŋgi deq oqwajqa minjrej qaji deq oqeb. ");
INSERT INTO boj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Oqsib dia Yesus itosib a biŋiyosib aqa ñam soqteb. Ariya naŋgi qudei areqalo aiyelteb. ");
INSERT INTO boj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Onaqa Yesus a naŋgo areq gilsiqa minjrej, “Ijo Abu na siŋgila kalil ijo baŋq di atej deqa e mandam ti laŋ ti taqatejunum. ");
INSERT INTO boj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Deqa niŋgi walwelosib sawa sawa kalil keretoqnsibqa tamo uŋgasari naŋgi ijo anjam minjre minjre laqniy. Yim naŋgi e daurbqajqa deqa. Niŋgi ijo Abu aqa ñam na ti e Qotei aqa Ŋiri ijo segi ñam na ti Mondor Bole aqa ñam na ti naŋgi yansnjroqniy. ");
INSERT INTO boj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","O ijo aŋgro, anjam kalil e nami merŋgoqnem qaji di niŋgi walwelosib tamo uŋgasari naŋgi minjroqniy. Yim naŋgi anjam di dauryqajqa deqa. Niŋgi quiy. E bati gaigai niŋgi koba na wauoqnsiy sqai. Degsim soqnim soqnim diŋo bati brantqas.” ");
INSERT INTO boj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Qotei aqa Ŋiri Yesus Kristus aqa anjam bole e utruq na saqai. ");
INSERT INTO boj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nami Qotei na aqa Ŋiri Yesus endegsi minjej, “Ni que. E na ijo anjam maro tamo qariŋyitqa a ni qa namoosim ino gam gereiyetmqas. ");
INSERT INTO boj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A wadau sawaq di tulaŋ leleŋoqnsim tamo uŋgasari naŋgi endegsi minjroqnqas, ‘Tamo Koba a bqajqa gam gereiyetiy. Aqa gam tingitetiy.’” Qotei a nami aqa Ŋiri degsi minjej. Onaqa aqa medabu o qaji tamo Aisaia a anjam di neŋgreŋyonaq soqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Bunuqna Jon yansnjro qaji a wadau sawaq di brantej. Brantosiq dia tamo uŋgasari naŋgi Qotei aqa anjam palontosiq minjroqnej. Tamo uŋgasari Judia sawaq di soqneb qaji naŋgi ti Jerusalem qureq di soqneb qaji naŋgi ti kalil Jon aqa areq gileqnabqa a na naŋgi endegsi minjroqnej, “Niŋgi are bulyibqa Qotei na nuŋgo une kalil kobotetŋgwas. Amqa e na niŋgi yansŋgwai.” Degsi minjreqnaqa naŋgi na naŋgo une kalil babteqnabqa Jordan yaq di yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon a wadau sawaq di soqnej di a iŋgi iŋgi saiqoji. Deqa a gara jugo kamel aqa juŋgum na gereiyo qaji di jugoqnsiqa alalag na siŋgilatosiq laqnej. A iŋgi uyo saiqoji deqa a sis ti bisim qaq ti uyoqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A Qotei aqa anjam palontoqnsiqa tamo uŋgasari naŋgi endegsi minjroqnej, “Tamo Koba a bunuqna ijo qoreq na bqas. A tamo siŋgila koba. Ijo siŋgila aqa siŋgila ti keresai. Deqa e a kaŋgalyqajqa e tamo bolesai. ");
INSERT INTO boj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","E ya na niŋgi yansŋgeqnum. Ariya Tamo Koba a bosimqa Mondor Bole aqa siŋgila na niŋgi yansŋgwas.” Jon na tamo uŋgasari naŋgi anjam degsi minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bati bei Yesus a Jon na yansqa marsiqa Nasaret qureq dena tigelosiqa Galili sawa uratosiq Jon aqa areq bej. Bonaqa Jon na Jordan yaq di yansej. ");
INSERT INTO boj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yansonaqa a yaq na tigelosiqa tarosiq laŋ goge koqyonaqa laŋ waqej. Laŋ waqonaqa Qotei aqa Mondor a binoŋ bulosiq aisiq Yesus aqa jejamuq di awoej. ");
INSERT INTO boj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Awoonaqa laŋ goge dena Qotei na Yesus metonaqa aqa kakro quej. A endegsi minjnaq quej, “Ni ijo Aŋgro qujai. E ni tulaŋ qalaqalaimeqnum. E ni qa tulaŋ areboleboleibeqnu.” ");
INSERT INTO boj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Onaqa Mondor a Yesus wadau sawaq osi gilsiqa di uratonaqa bati 40 a di laqnej. Di laqnaqa Satan bosiqa Yesus a une bei atqa marsiqa walawalaiyoqnej. Yesus a wagme juwaŋ naŋgi ti soqneb. Sonabqa Qotei aqa laŋ aŋgro naŋgi bosib Yesus siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bati bei Jon a tonto talq di waiyonab sonaqa Yesus a olo Galili sawaq aiyej. Aisiq dia Qotei aqa anjam bole palontoqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A endegsi maroqnej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqajqa bati jojomqo. Deqa niŋgi are bulyosib Qotei aqa anjam bole nuŋgo areqaloq di siŋgilatiy.” ");
INSERT INTO boj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Osiqa Yesus a Galili ya agu kobaqujaq gilej. Gilsiq alile dia walweloqnsiqa ŋam atej di Saimon aqa was Andru wo naŋgi qe o qaji tamo soqneb deqa naŋgi kakaŋ waiyeqnab unjrej. ");
INSERT INTO boj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Unjrsiqa minjrej, “Niŋgi aiyel e daurbiy. Niŋgi qe o qaji tamo unub deqa niŋgi qe eqnub. Dego kere e wau eŋgitqa niŋgi olo tamo oqnqab.” ");
INSERT INTO boj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yesus a naŋgi degsi minjrnaqa naŋgi naŋgo kakaŋ uratosib Yesus dauryeb. ");
INSERT INTO boj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Onaqa Yesus a olo walwelosiq gilokiñalayosiqa Sebedi aqa ŋiri Jems aqa was Jon wo naŋgi aiyel qobuŋ miligiq di kakaŋ braŋo qandimeqnabqa unjrsiqa metnjrej. ");
INSERT INTO boj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Metnjrnaqa naŋgo abu Sebedi wau tamo ti qobuŋ miligiq di sonabqa naŋgi uratnjrsib Yesus dauryeb. ");
INSERT INTO boj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Onaqa Yesus aqa aŋgro naŋgi ti walwelosib gilsib Kaperneam qureq di branteb. Brantosib sonabqa Juda naŋgo yori batiej. Deqa Yesus a Juda naŋgo Qotei tal miligiq gilsiqa Qotei aqa anjam palontosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aqa anjam palontej di siŋgila ti. Dal anjam qalie tamo naŋgo anjam maroqneb de ti keresai. Yesus a segi anjam di aqa abu. Aqa anjam dena dal anjam qalie tamo naŋgo anjam tulaŋ buŋyoqnej. Deqa tamo uŋgasari naŋgi Yesus aqa anjam di qusib tulaŋ prugeb. ");
INSERT INTO boj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bati di tamo bei mondor uge na ojej qaji a Qotei tal miligiq di awesoqnej. Deqa a Yesus unsiqa tulaŋ leleŋosiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Yesus Nasaret qaji tamo, ni iga kiyergwajqa bonum? Ni iga padaltgwa bonum e? E ni qalie. Ni Qotei aqa Tamo Boledamu. Ino jejamuq di une bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Onaqa Yesus na mondor uge di ŋiriŋtosiq minjej, “Ni medabu getentosim tamo di uratosim ulaŋ.” ");
INSERT INTO boj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Degsi minjnaqa mondor uge dena tamo di kunjimyosiqa tulaŋ leleŋosiqa a uratosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Onaqa tamo uŋgasari naŋgi Yesus aqa maŋwa di unsibqa naŋgi tulaŋ prugosib segi segi maroqneb, “Yesus a tamo kiyero? A anjam bunuj mareqnu. Aqa anjam bunuj di siŋgila ti mareqnu. A segi anjam di aqa abu. Agi a na mondor uge naŋgi minjreqnaqa naŋgi aqa anjam dauryosib jaraiyeqnub.” ");
INSERT INTO boj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tamo uŋgasari naŋgi degsib maroqneb. Osib naŋgi walwelosib Galili sawa keretosib Yesus aqa maŋwa deqa saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Onaqa Yesus aqa aŋgro naŋgi ti Qotei tal uratosib Saimon Andru wo naŋgo tal gogeteb. Jems Jon wo naŋgi koba na tal gogeteb. ");
INSERT INTO boj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tal gogetosibqa Saimon aqa mimibe makobaiyonaq jejamu tulaŋ kaŋkaŋyonaqa ŋeiesonaq uneb. Deqa Yesus aqa aŋgro naŋgi na Yesus minjeb, “Ni na uŋa di boletqa kere e?” Onaqa minjrej, “Od, e na boletqa kere.” ");
INSERT INTO boj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Degsi minjrsiqa uŋa maiyej qaji aqa areq gilsiqa baŋ ojsiqa tigeltej. Tigeltonaqa aqa jejamu kaŋkaŋ di koboonaqa a tigelosiqa naŋgi iŋgi goiyetnjrej. ");
INSERT INTO boj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Seŋ aiyeqnaqa qure deqaji tamo uŋgasari ma utru segi segi so qaji naŋgi ti mondor uge uge na ojeleŋo qaji naŋgi ti naŋgo was naŋgi na joqoqnsib Yesus aqa areq boqneb. ");
INSERT INTO boj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Boqnsib Yesus soqnej qaji tal meq di korooqneb. ");
INSERT INTO boj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Onaqa Yesus na tamo uŋgasari kalil ma ti soqneb qaji naŋgi boletnjroqnej. Osiqa mondor uge naŋgi dego winjroqnej. Mondor uge naŋgi di Yesus qa qalieeb deqa naŋgi aqa ñam ubtqa mareqnab a na naŋgi saidnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Onaqa nobqolo ambru Yesus na tamo uŋgasari naŋgi alelnjrsiqa wadau sawaq gilsiqa dia Qotei pailyoqnej. ");
INSERT INTO boj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Pailyeqnaqa aqa aŋgro naŋgi Saimon koba na a qa ŋamosib gilsib itosib minjeb, “Tamo uŋgasari kalil naŋgi ni qa ŋameqnub.” ");
INSERT INTO boj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Onaqa Yesus na kamba minjrej, “Niŋgi tigelabqa iga qure qureq giloqnsimqa dia Qotei aqa anjam palontoqnsim tamo uŋgasari naŋgi minjroqnqom. E wau di yqajqa deqa mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Degsi minjrsiqa walweloqnsiqa qure qure kalil Galili sawaq di brantoqnsiqa Juda naŋgo Qotei tal miligiq giloqnsiqa Qotei aqa anjam palontoqnsiq minjroqnej. Osiqa mondor uge uge naŋgi winjreqnaqa naŋgi na tamo uŋgasari naŋgoq dena jaraiyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Onaqa tamo bei yu na aqa jejamu ugeeleŋej qaji a Yesus aqa areq bosiqa aqa siŋgaq di siŋga pulutosiqa pailyosiq minjej, “O Tamo Koba, ni e boletbqa are soqnimqa e boletbe.” ");
INSERT INTO boj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Onaqa Yesus na tamo di aqa yu unsiqa a qa dulosiqa baŋ waiyosiq ojej. Ojsiqa minjej, “E ni boletmqa are unu. Deqa ino jejamu olo boleeme.” ");
INSERT INTO boj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Onaqa bati qujai deqa aqa yu kalil mosoosiq aqa jejamu boleej. ");
INSERT INTO boj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Onaqa Yesus a siŋgila na minjej, “Ni tigelosim gile. ");
INSERT INTO boj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ino jejamu boleqo deqa ni tamo qudei naŋgi minjraim. Ni gilsim ino jejamu atra tamo osoryosim atraiyqajqa iŋgi iŋgi Moses a nami marej qaji di osim Qotei atraiye. Yimqa tamo uŋgasari naŋgi ni numsib marqab, ‘Bole, ino jejamu boleqo.’” ");
INSERT INTO boj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Onaqa a gilsiqa ariya a Yesus aqa anjam di dauryosai. Yesus na boletej deqa a anjam mare mare laqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi quekriteb. Deqa Yesus a segitosiqa gilsiq wadau sawaq di soqnej. Tamo uŋgasari naŋgi a jujuŋyaib deqa a qure beiq di brantosaioqnej. A wadau sawaq di sonaqa tamo uŋgasari tulaŋ gargekoba naŋgi qure qure kalilq dena tigeloqnsib aqa areq beleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bati bei Yesus a olo Kaperneam gilsiq di sonaqa qure deqaji naŋgi endegsib queb, “Yesus a gago qureq olo bqo. A talq di unu.” ");
INSERT INTO boj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Deqa tamo uŋgasari gargekoba naŋgi bosib siraŋmeq di jujuŋonabqa Yesus a Qotei aqa anjam palontosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Onaqa tamo qolqe naŋgi na tamo bei jejamu laiyej qaji a saperaq di atsibqa qoboiyosib Yesus aqa talq osi beb. ");
INSERT INTO boj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Osi bosib ŋam ateb di tamo uŋgasari gargekoba naŋgi siraŋme juŋonab unjreb. Deqa naŋgi Yesus aqa areq gilqa keresaiinjrnaqa tal quraq oqsib goge na waqtosibqa tamo sapera qoji gulaintosib ura uratonab Yesus aqa areq aiyej. ");
INSERT INTO boj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Onaqa Yesus a naŋgo areqalo unej di naŋgo areqalo qujai Yesus na tamo jejamu laiyej qaji di boletqa kere. Degsi unsiq deqa tamo di minjej, “O ijo aŋgro, ino une kalil e na kobotetmonum.” ");
INSERT INTO boj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Onaqa dal anjam qalie tamo qudei warum dia awesoqneb qaji naŋgi Yesus aqa anjam di qusibqa naŋgo areqalo na mareb, ");
INSERT INTO boj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yesus a kiyaqa anjam degsi marqo? A Qotei misiliŋyqo. Yai na tamo naŋgo une kobotqa kere? Qotei a segi qujai.” ");
INSERT INTO boj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naŋgi degsib are qaleqnabqa Yesus a naŋgo areqalo di qalieosiqa minjrej, “Niŋgi kiyaqa areqalo di onub? ");
INSERT INTO boj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Anjam kiye e na tamo jejamu laiyqo qaji di minjitqa niŋgi qusib e qa poiŋgwas? ‘Ino une kalil e na kobotetmonum,’ anjam de kiyo, ‘Ni tigelosim ino sapera osim walwel,’ anjam de kiyo? ");
INSERT INTO boj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ariya e segi Tamo Aŋgro. E mandamq endi siŋgila ti unum deqa e na tamo naŋgo une kobotetnjrqa kere. Niŋgi degsi poiŋgwajqa deqa e na tamo di boletqai.” Yesus a naŋgi degsi minjrsiqa tamo jejamu laiyej qaji di koqyosiqa minjej, ");
INSERT INTO boj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“E ni mermqai. Ni tigelosim ino sapera osim ino talq gile.” ");
INSERT INTO boj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Degsi minjnaqa aqa jejamu boleonaqa a tigelosiqa aqa sapera osiqa tamo uŋgasari kalil naŋgo ŋamdamuq di walwelosiq gilej. Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsibqa naŋgi tulaŋ prugugetosib Qotei aqa ñam soqtosib mareb, “Maŋwa iga endego unonum di kumbra tulaŋ bei. Tamo bei na maŋwa deqaji bei yeqnaq iga nami unosaioqnem.” ");
INSERT INTO boj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Onaqa Yesus a olo alile ainaqa tamo uŋgasari gargekoba naŋgi bosib aqa areq di koroonabqa a na Qotei aqa anjam palonteqnaq naŋgi quoqneb. ");
INSERT INTO boj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dena walwelosiq takis o qaji tamo bei aqa ñam Livai a takis o talq di awesonaq gilsiq itej. A Alfias aqa ŋiri. A itosiq minjej, “Ni e daurbe.” Degsi minjnaqa a tigelosiqa Yesus dauryej. ");
INSERT INTO boj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Onaqa bati bei Yesus aqa aŋgro naŋgi ti Livai aqa talq gilsib awoosib iŋgi uyoqneb. Naŋgi segi sai. Une tamo ti takis o qaji tamo ti gargekoba naŋgi dego koba na Yesus dauryosib Livai aqa talq di awoosib Yesus aqa aŋgro naŋgi ti iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Onaqa Farisi qudei naŋgi bosib Yesus a une tamo ti takis o qaji tamo ti naŋgi koba na iŋgi uyeqnab unjrsibqa Yesus aqa aŋgro naŋgi minjreb, “Yesus a kiyaqa une tamo ti takis o qaji tamo ti naŋgi koba na iŋgi uyeqnub?” ");
INSERT INTO boj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Onaqa Yesus a Farisi naŋgo anjam di qusiqa minjrej, “Tamo ma saiqoji naŋgi yu qaŋgra tamo aqaq gilosaieqnub. Tamo ma ti naŋgi segi yu qaŋgra tamo aqaq gileqnub. Tamo bei a marqas, ‘E tamo bole. E une saiqoji.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyosai. Tamo a marqas, ‘E une ti.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bati bei Jon aqa aŋgro naŋgi ti Farisi naŋgi ti iŋgi uratoqnsib qurieŋoqneb. Deqa naŋgi Yesus aqa areq bosib minjeb, “Jon aqa aŋgro naŋgi iŋgi uratoqnsib qurieŋeqnub. Farisi naŋgo aŋgro naŋgi dego iŋgi uratoqnsib qurieŋeqnub. Ariya ino aŋgro naŋgi kiyaqa qurieŋosaieqnub?” ");
INSERT INTO boj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Onaqa Yesus na kamba minjrej, “Tamo bei a uŋa baŋ ojqa bati qa aqa was naŋgi ti soqnibqa naŋgi qurieŋqab e? Sai. ");
INSERT INTO boj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bunuqna naŋgo was a naŋgi uratnjrimqa bati deqa naŋgi qurieŋoqnsib sqab. ");
INSERT INTO boj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tamo bei a gara jugo bunuj osim dena mutu gentosim gara jugo sari braŋoq di qandimqa keresai. Degsi qandimqas di bunuqna a na gara jugo sari di yansimqa gara mutu bunuj a kiñalaosim gara jugo sari di uratim braŋ qelikobaqas. ");
INSERT INTO boj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tamo bei a wain bunuj osim ya nobu sariq di qamqa keresai. Ya nobu sari di nami kaŋgraŋosiq siŋgilaej deqa a wain bunuj qamimqa wain a didiqosim ya nobu sari paratosimqa wain bileŋosim mandamq aiqas. Ya nobu a dego ugeqas. A wain bunuj osim ya nobu bunujq di qamqas di kere.” ");
INSERT INTO boj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yori bati bei Yesus aqa aŋgro naŋgi ti wau ambleq na giloqnsibqa aqa aŋgro naŋgi bem sum gei eleŋoqnsib uye uye giloqneb. ");
INSERT INTO boj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naŋgi degsib gileqnabqa Farisi qudei naŋgi bosib unjrsibqa Yesus minjeb, “Ino aŋgro naŋgi kiyaqa kumbra degyeqnub? Yori bati qa kumbra degyo di getento koba.” ");
INSERT INTO boj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Onaqa Yesus na kamba Farisi naŋgi minjrej, “Nami Devit aqa wau tamo ti naŋgi mamnjrnaqa kumbra yeb qaji di niŋgi buk miligiq di sisiyosai kiyo? ");
INSERT INTO boj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar a atra tamo gate sonaqa bati deqa Devit a atra tal miligiq gilsiqa Qotei atraiyqajqa bem uysiqa aqa wau tamo naŋgi dego anainjrnaq uyeb. Bem di getento. Di atra tamo naŋgo segi uyqajqa bem. Devit a degyej di a dal anjam grotej. Ariya a Qotei aqa ŋamgalaq di une saiqoji. Niŋgi anjam di sisiyosai kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Osiqa minjrej, “Qotei a yori bati qa are qalsiq tamo naŋgi atosai. A tamo naŋgi qa are qalsiq yori bati atej. ");
INSERT INTO boj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","E Tamo Aŋgro. Deqa e segi na yori bati taqatejunum. E segi yori bati aqa Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Olo yori bati bei Yesus a Juda naŋgo Qotei tal miligiq gilsiqa tamo bei baŋ qandamyej qaji a di sonaq unej. ");
INSERT INTO boj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Onaqa Farisi naŋgi Yesus koqyoqneb. Naŋgi are qaleb, “Yesus a yori bati qa tamo di boletqas kiyo? Yimqa minjqom, ‘Ni na yori bati grotonum.’” Deqa naŋgi Yesus koqyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Onaqa Yesus a tamo baŋ qandamyej qaji di minjej, “Ni tigelosim au.” ");
INSERT INTO boj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Degsi minjnaqa a tigelosiqa Yesus aqa areq gileqnaqa Yesus na Farisi naŋgi nenemnjrej, “Iga yori bati qa kumbra bole yqom kiyo kumbra uge yqom kiyo? Tamo bei a padalqa laqnimqa iga na aqaryaiyonam a bole sqas di kere kiyo iga na uratonam a padalqas di kere kiyo? Dal anjam a kiyersi marqo? Niŋgi na merbiy.” Onaqa Farisi naŋgi kamba olo anjam bei Yesus minjosai. Naŋgi mequmesoqneb. ");
INSERT INTO boj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naŋgo are geteŋnjresoqnej deqa Yesus a naŋgi koqnjrej. Osiqa naŋgi qa minjiŋ oqetonaqa tamo baŋ qandamyej qaji di minjej, “Ni ino baŋ waiy.” Degsi minjnaqa aqa baŋ waiyonaq boleej. ");
INSERT INTO boj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Onaqa Farisi naŋgi Qotei talq dena oqedosib Herot aqa wau tamo naŋgi ti koba na koroosib naŋgi kiyersib Yesus qalib moiqajqa deqa qairoqneb. ");
INSERT INTO boj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Onaqa Yesus aqa aŋgro naŋgi ti tigelosib tamo uŋgasari kalil naŋgi uratnjrsib alile aisib di soqneb. Bati deqa tamo uŋgasari tulaŋ gargekoba naŋgi endegsib queb, “Yesus a maŋwa gargekoba yeleŋeqnu.” Degsib qusibqa Yesus dauryosib alile aisib aqaq di korooqneb. Galili sawa naŋgi ti Judia sawa naŋgi ti Jerusalem qure naŋgi ti Idumia sawa naŋgi ti qure kalil Jordan ya taqal beiq di soqneb qaji naŋgi ti Tair qure ti Saidon qure ti naŋgi kalil beleŋosib Yesus aqaq di korooqneb. ");
INSERT INTO boj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Qobuŋ bei atib soqnem. Tamo uŋgasari naŋgi bosib e jujuŋbaib deqa e qobuŋ gogetosiy di awoqai.” Onaqa aqa aŋgro naŋgi qobuŋ bei atnab soqnej. Naŋgi degyeb. Di kiyaqa? ");
INSERT INTO boj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesus a nami tamo uŋgasari gargekoba naŋgi boletnjroqnej. Deqa tamo ma ti kalil naŋgi aqa areq boqnsibqa naŋgo baŋ aqa jejamuq di atqa maroqnsib a jujuŋyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tamo mondor uge uge na ojeleŋo qaji naŋgi dego Yesus aqa areq boqneb. Boqnsibqa mondor uge naŋgi na Yesus unoqnsib aqa siŋgaq di siŋga pulutoqnsib leleŋoqnsib minjoqneb, “Ni Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Degsib minjeqnabqa a naŋgi siŋgila na saidnjroqnsiq minjroqnej, “Niŋgi ijo ñam ubtosib maraib.” ");
INSERT INTO boj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Onaqa Yesus a dena walwelosiqa manaq oqej. A endegsi are qalej, “E na tamo qudei giltnjritqa naŋgi e koba na laqnsibqa ijo wau ojoqnqab.” A degsi are qalsiqa manaq oqsiq dia tamo qudei naŋgi metnjrnaqa aqa areq beb. ");
INSERT INTO boj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bonabqa a na tamo 12 naŋgi giltnjrej. Naŋgi a ombla sqajqa deqa ti a na naŋgi qariŋnjrimqa naŋgi aqa anjam mare mare laqajqa deqa ti naŋgi giltnjrej. ");
INSERT INTO boj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Naŋgi na mondor uge uge tamo uŋgasari naŋgo jejamuq dena winjrqajqa deqa ti naŋgi giltnjrej. ");
INSERT INTO boj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tamo 12 giltnjrej qaji naŋgo ñam agiende. Bei Saimon. Yesus na aqa ñam bei Pita waiyej. ");
INSERT INTO boj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bei Sebedi aqa ŋiri Jems aqa was Jon wo. Naŋgo ñam bei Yesus na Boanerges wainjrej. Ñam di aqa damu, “Tamo kola bul.” ");
INSERT INTO boj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ariya Andru Filip wo. Bei Bartolomyu Matyu wo. Bei Tomas. Bei Alfias aqa ŋiri Jems. Bei Tadius. Bei Saimon agi Rom naŋgi winjrqajqa maroqnej qaji. ");
INSERT INTO boj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ariya bei Judas Iskariot agi bunuqna Yesus osiqa jeu tamo naŋgo baŋq di atej qaji. ");
INSERT INTO boj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Onaqa Yesus a tal bei gogetosiq di sonaqa tamo uŋgasari gargekoba naŋgi olo bosib korooqneb. Deqa aqa aŋgro naŋgi ti iŋgi uyqa bati saiinjrej. ");
INSERT INTO boj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus aqa was naŋgi aqa ai koba na degsib qusibqa Yesus oqajqa marsib qure deq gileb. Naŋgi maroqneb, “Yesus a nanariqo kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Onaqa dal anjam qalie tamo qudei Jerusalem dena beb qaji naŋgi Yesus yomuiyoqnsib maroqneb, “Mondor uge naŋgo gate koba Belsebul a Yesus aqa jejamuq di unu. Siŋgila dena Yesus na mondor uge naŋgi winjreqnu.” ");
INSERT INTO boj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Onaqa Yesus a naŋgi metnjrnaqa aqa areq bonabqa yawo anjam bei endegsi minjrej, “Satan na aqa segi mondor uge naŋgi kiyersim winjrqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tamo naŋgi qure qujaiq di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi koba na geregere sqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tamo naŋgi tal qujaiq di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi dego koba na geregere sqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dego kere Satan na aqa segi mondor uge naŋgi jeutnjrsim winjrqas di aqa siŋgila koboosim aqa wau uloŋqas. ");
INSERT INTO boj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tamo bei a tamo siŋgila koba bei aqa tal gogetosim aqa iŋgi iŋgi kalil bajiŋqa keresai. A mati tamo siŋgila di sil na tontim soqnimqa di aqa iŋgi iŋgi kalil bajiŋqas. Tontqasai di aqa iŋgi iŋgi bajiŋqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“E bole merŋgwai. Tamo uŋgasari naŋgo une kalil Qotei na kobotetnjrqas. Tamo uŋgasari naŋgi misiliŋ anjam mareqnub une di dego Qotei na kobotetnjrqas. ");
INSERT INTO boj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ariya tamo a Mondor Bole misiliŋyqas une di Qotei na kobotqasai. Une di tamo aqa jejamuq di gaigai sqas.” ");
INSERT INTO boj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus na dal anjam qalie tamo naŋgi anjam degsi minjrej. Di kiyaqa? Naŋgi maroqneb, “Yesus a mondor uge ti.” ");
INSERT INTO boj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Onaqa Yesus aqa was naŋgi aqa ai koba na bosib tal oqeq di tigeleb. Yesus a warum miligiq di sonaqa naŋgi oqeq di tigelosib tamo qudei minjreb, “Iga Yesus qa bonum. Deqa niŋgi a minjib endeq bem.” ");
INSERT INTO boj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Onaqa tamo uŋgasari Yesus aqa areq di awesoqneb qaji naŋgi na Yesus minjeb, “Ino was naŋgi ino ai ombla na ni qa bonub agi oqeq di tigelejunub.” ");
INSERT INTO boj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Onaqa Yesus na kamba minjrej, “Ijo ai ijo was naŋgi tal qabe?” ");
INSERT INTO boj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Degsi minjrsiqa tamo uŋgasari aqa areq di awesoqneb qaji naŋgi koqnjrsiqa minjrej, “Niŋgi segi ijo ai ijo was naŋgi. ");
INSERT INTO boj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Niŋgi quiy. Tamo a Qotei aqa areqalo dauryoqnqas di a ijo was bole. A ijo jaja bole. A ijo ai bole.” ");
INSERT INTO boj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Onaqa Yesus a olo alile ainaqa tamo uŋgasari tulaŋ gargekoba naŋgi bosib aqaq di koroonabqa a sasalosiqa qobuŋ bei gogetosiq di awoej. Awoosiqa tamo uŋgasari kalil naŋgi alile di sonabqa a na yawo anjam gargekoba minjroqnej. A na yawo anjam bei endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Niŋgi quiy. Tamo bei a gilsiqa aqa iŋgi wauq di saga yago breiyeleŋej. ");
INSERT INTO boj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Breiyonaqa jagwa na saga yago qudei puyonaqa gam qalaq aiyeleŋeb. Ainabqa qebari naŋgi bosib uyekriteb. ");
INSERT INTO boj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Saga yago qudei mandam lanjaq di aiyeleŋeb. Mandam di guma meniŋ ti. Gogeq di mandam kiñala. Deqa saga yago aiyeleŋosib urur oqoqujateb. ");
INSERT INTO boj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Naŋgo jirim tulaŋ guma aiyosai deqa seŋ oqsiq kaŋkaŋonaqa naŋgi laosib moreŋeb. ");
INSERT INTO boj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Saga yago qudei sil luwit ambleq di aiyeleŋeb. Dena oqeb qaji sil luwit na dego dauryosiq oqsiq kabutnjrnaq geitosai. ");
INSERT INTO boj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Saga yago qudei mol mandam boledamuq di aiyeb. Di aisib oqoboledamuyosib gei tulaŋ gargekoba ateleŋeb. Qudei 30. Qudei 60. Qudei 100.” ");
INSERT INTO boj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesus na tamo uŋgasari naŋgi yawo anjam degsi minjrsiq koboonaqa olo endegsi minjrej, “Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Onaqa Yesus na tamo uŋgasari naŋgi uratnjrsiqa a kiñala qalaq gilsiqa a segi sonaqa aqa aŋgro 12 naŋgi ti tamo qudei a dauryosib laqneb qaji naŋgi ti aqa areq bosibqa aqa yawo anjam di aqa utru geregere qalieqajqa deqa nenemyeb. ");
INSERT INTO boj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nenemyonabqa a na kamba endegsi minjrej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Anjam di aqa utru uliejunu. Di Qotei na babtimqa ijo aŋgro niŋgi segi utru qalieqab. Ariya tamo uŋgasari qala qalaq di unub qaji naŋgi yawo anjam segi minjroqnqai. ");
INSERT INTO boj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Deqa naŋgi ŋam atoqnqab di ijo anjam aqa damu unsib poinjrqasai. Naŋgi dab atoqnqab di ijo anjam aqa utru quqwasai. Osib poinjrqasai dego. Deqa naŋgi are bulyosib Qotei aqaq bqa keresai. Deqa Qotei a naŋgo une kobotetnjrqasai.” ");
INSERT INTO boj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Osiqa Yesus a olo aqa aŋgro naŋgi endegsi minjrej, “Saga yago qa yawo anjam maronum di aqa utru niŋgi poiŋgosai e? Dego di niŋgi kiyersib ijo yawo anjam kalil qa poiŋgwas? ");
INSERT INTO boj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamo a saga yago breiyej di a Qotei aqa anjam breiyej. ");
INSERT INTO boj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Saga yago qudei gam qalaq ainabqa qebari naŋgi bosib uyekriteb di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam quqwab. Ariya anjam di naŋgo are miligiq di soqnimqa Satan a urur bosim anjam di olo yainjrqas. Qotei na naŋgo are miligiq di anjam di atej ariya Satan a bosim olo yainjrqas. ");
INSERT INTO boj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Saga yago qudei mandam lanjaq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib tulaŋ areboleboleinjrimqa anjam di oqujatosib naŋgo areq atqab. ");
INSERT INTO boj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ariya anjam di naŋgo are miligiq tulaŋ guma aiyosai. Deqa sokiñala Qotei aqa anjam gotraŋyo qaji tamo qudei na bosib naŋgi gulbe enjrsib ugeugeinjrqab. Yimqa naŋgo areqalo Yesus qa siŋgilateqnub qaji di naŋgi olo ulontqab. ");
INSERT INTO boj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Saga yago qudei sil luwit ambleq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusibqa ariya bunuqna naŋgi olo mandam qa iŋgi iŋgi qa are koba qaloqnsib ñoro koba oqnqajqa are prugnjroqnqas. Yimqa kumbra dena naŋgi gisaŋnjrsim Qotei aqa anjam naŋgo are miligiq di tentim loumqas. Saga yago uge naŋgi gei bole atosaieqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Saga yago qudei mol mandam boledamuq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib naŋgo are miligiq di geregere ojsib siŋgilatqab. Deqa Qotei aqa anjam di naŋgo are miligiq di saga bul tulaŋ kobaqas. Qudei 30. Qudei 60. Qudei 100.” ");
INSERT INTO boj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Osiqa Yesus a olo minjrej, “Tamo bei a lam qatrentosim puloŋamqa guwe na kabutqasai. Bijal surumq di atqasai. Boleq di gaintim warum suwaŋesqas. ");
INSERT INTO boj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dego kere kumbra kalil uliejunu qaji di Qotei na boleq atqas. Kumbra kalil kabuejunu qaji di dego Qotei na babtqas. ");
INSERT INTO boj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Osiqa Yesus a olo minjrej, “Anjam niŋgi queqnub qaji di geregere quoqniy. Niŋgi geregere quoqnqab kere dego Qotei a kamba powo eŋgoqnqas. Osim olo powo tulaŋ koba eŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tamo a powo ti sqas di Qotei na powo olo yimqa a powo koba oqas. Ariya tamo a powo ti sqasai di powo kiñala aqaq di unu qaji di Qotei na olo yaiyim a laŋa sqas.” ");
INSERT INTO boj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Osiqa Yesus a olo marej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di tamo bei a saga yago breiyeqnu dego kere. ");
INSERT INTO boj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tamo di a qolo ŋeioqnsiqa nobqolo a olo tigeloqnsiqa walweleqnu. A kumbra degyeqnaqa saga yago naŋgi segi kokitoqnsibqa oqeleŋeqnub. Saga yago naŋgi kiyersib oqeleŋeqnub di tamo a qaliesai. ");
INSERT INTO boj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mandam a segi waueqnaqa saga yago naŋgi kokitoqnsibqa baŋgateqnub. Dena sotoqnsibqa geitoqnsibqa melieqnub. ");
INSERT INTO boj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Meli sau bqo deqa tamo di a bosim serie na giŋgeŋyosim oqas.” ");
INSERT INTO boj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Osiqa Yesus a olo marej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Kumbra di aqa utru niŋgi geregere poiŋgwajqa deqa yawo anjam bei endegsi merŋgwai. ");
INSERT INTO boj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Kumbra di tamo bei na sis yago osiq aqa wauq di yagej dego kere. Sis yago naŋgi tulaŋ kiñilala kas yago bul. Iŋgi iŋgi qudei naŋgo yago kokba yala. Sis yago naŋgi tulaŋ kiñilala. Ariya sis yago di tamo bei na osim aqa wauq di yagimqa bunuqna a oqsim tulaŋ kobaqujaqas. Osim ŋam qudei buŋnjrsim dani kokba ateleŋqas. Amqa qebari naŋgi bosib aqa waburq di awoeleŋqab.” ");
INSERT INTO boj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus na tamo uŋgasari naŋgi yawo anjam gargekoba deqaji minjroqnej. Naŋgi aqa yawo anjam quqwa kere deqa a degsi minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A anjam bei minjrosaioqnej. Yawo anjam segi minjroqnej. Olo segitoqnsiqa aqa segi aŋgro naŋgi yawo anjam aqa utru geregere plaltosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Onaqa bilaqtonaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Iga gilsim ya agu taqal beiq di brantqom.” ");
INSERT INTO boj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Degsi minjrsiqa naŋgi koba na tamo uŋgasari kalil naŋgi uratnjrsibqa qobuŋ na gileqnabqa tamo qudei naŋgi dego naŋgo qobuŋ osib Yesus dauryosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yesus aqa aŋgro naŋgi ti qobuŋ na gileqnabqa jagwa tulaŋ koba tigelosiq ya korkortosiqa qobuŋ qaloqnsiqa mormaŋ miligiq aiyeqnaqa ya maqej. ");
INSERT INTO boj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus a nami qobuŋ bunuq di gate kuluŋ atsiqa ŋeisiq qambumtej. Deqa aqa aŋgro naŋgi tulaŋ ulaugetosib aqa areq bosib dudumyosib minjeb, “O Qalie Tamo, iga padalqa laqnum. Ni deqa are qalosai kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Onaqa Yesus a tigelosiqa jagwa ti ya ti siŋgila na minjrej, “Niŋgi laoiy.” Minjrnaqa jagwa laej. Ya dego maninej. ");
INSERT INTO boj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi kiyaqa ulaosib e qa yala poiŋgosai?” ");
INSERT INTO boj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Onaqa aqa aŋgro naŋgi olo tulaŋ ulaugetosib segi segi maroqneb, “Yesus a tamo kiyero deqa jagwa ti ya ti minjrqoqa aqa anjam qusib laonub?” ");
INSERT INTO boj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Onaqa Yesus aqa aŋgro naŋgi ti qobuŋ na gilsib ya agu taqal beiq di brantosib Gerasa sawaq di tiryeb. ");
INSERT INTO boj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tiryosib Yesus a qobuŋ uratosiq mandamq ainaqa tamo bei a tamo sub ato sawaq dena brantosiq Yesus aqa areq bej. Tamo di a mondor uge uge na ojeleŋo qaji. ");
INSERT INTO boj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A bati gaigai tamo sub ato sawaq di ŋeioqnej. A tamo siŋgila koba. Tamo bei na a ojqa keresai. Sil kokba na a tontqa keresai dego. ");
INSERT INTO boj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bati gargekoba tamo qudei naŋgi aqa siŋga ti baŋ ti sil kokba na tonteqnabqa a olo kukoqyoqnej. Tamo bei na a ojqa keresai bole sai. ");
INSERT INTO boj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A bati gaigai qolo ti qanam ti tamo sub ato sawaq di tulaŋ leleŋoqnsiqa aqa segi jejamu meniŋ na pupoiyoqnej. A manaq di dego kumbra di yoqnej. ");
INSERT INTO boj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Deqa a isaq na ŋam atsiqa Yesus unsiqa urur ti aqa areq bosiqa aqa siŋgaq di siŋga pulutej. Onaqa Yesus na mondor uge di minjej, “O mondor uge, ni tamo di uratosim ulaŋ.” Degsi minjnaqa mondor uge dena tulaŋ leleŋosiqa siŋgila na pailosiq Yesus minjej, “O Yesus, Qotei Goge Koba aqa Ŋiri, ni e kiyerbqajqa bonum? E Qotei aqa ñam na ni mermqai, ni e jaqatiŋ ebaim.” ");
INSERT INTO boj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Onaqa Yesus na mondor uge di nenemyej, “Ino ñam yai?” Degsi nenemyonaqa minjej, “Ijo ñam Qoto Tamo Gargekoba. Iga mondor tulaŋ gargekoba tamo endi aqa jejamuq di unum.” ");
INSERT INTO boj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Osiqa siŋgila na pailosiq Yesus minjej, “Ni iga sawaq beiq waigaim.” ");
INSERT INTO boj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bati deqa bel tulaŋ gargekoba naŋgi mana goge dia suwaroqneb. ");
INSERT INTO boj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Deqa mondor uge naŋgi na Yesus minjeb, “Ni iga qariŋgimqa iga bel naŋgo jejamuq gileleŋqom.” ");
INSERT INTO boj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mondor uge naŋgi degsib Yesus minjnabqa a na naŋgi odnjrnaqa tamo di uratosibqa bel naŋgo jejamuq gileleŋeb. Gilnabqa bel kalil naŋgi gurgurosib botau dena prugeleŋosib yaq aisib ya uysib moreŋeb. Bel moreŋeb qaji naŋgi sisiyeb 2,000. ");
INSERT INTO boj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Onaqa bel taqatoqneb qaji tamo naŋgi kumbra di unsibqa jaraiyosib qure miligiq aisib tamo uŋgasari kalil naŋgi sainjroqnsib laqneb. Gamq di dego sainjroqnsib laqneb. Onaqa tamo uŋgasari naŋgi kumbra di unqajqa beb. ");
INSERT INTO boj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bosib Yesus aqa areq di koroosib ŋam ateb di tamo nami mondor uge ti soqnej qaji aqa areqalo boleosiq gara tigsiq awesonaq uneb. Unsib tulaŋ ulaugeteb. Di kiyaqa? Mondor uge tulaŋ gargekoba nami tamo di aqa jejamuq di soqneb deqa. ");
INSERT INTO boj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Onaqa tamo naŋgo ŋamdamu na Yesus a mondor uge di winjrnaq uneb qaji naŋgi bel qa ti mondor uge qa ti tamo uŋgasari naŋgi sainjrnab queb. ");
INSERT INTO boj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Qusibqa Yesus minjeb, “Ni gago sawa endi uratosim sawa beiq gile.” ");
INSERT INTO boj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Onaqa Yesus a qobuŋ gogetosiq gilqa laqnaqa tamo aqaq na Yesus na mondor uge uge winjretej qaji a siŋgila na pailosiq minjej, “E ni daurmqai.” ");
INSERT INTO boj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Onaqa Yesus na saidyosiq minjej, “Ni olo ino segi qureq gile. Gilsim Tamo Koba a ni qa dulosiqa kumbra tulaŋ boledamu emqo deqa ino was naŋgi sainjre.” ");
INSERT INTO boj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Onaqa a puluosiq aqa qureq gilsiq Yesus na a kumbra tulaŋ boledamu yej deqa Dekapolis sawa (ñam di aqa damu, Qure 10) dia tamo uŋgasari kalil naŋgi sainjroqnsiq laqnej. Sainjreqnaqa naŋgi aqa anjam quoqnsib tulaŋ prugoqneb. ");
INSERT INTO boj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Onaqa Yesus a olo qobuŋ gogetosiqa ya agu taqal beiq gilej. Gilsiq qobuŋ tiryonaq mandamq aisiq alile di sonaqa tamo uŋgasari tulaŋ gargekoba bosib aqaq di korooqneb. ");
INSERT INTO boj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Koroosib sonabqa Qotei tal taqato tamo bei aqa ñam Jairus a walwelosiq Yesus unsiqa aqa areq bosiqa siŋga pulutosiqa siŋgila na pailyosiq minjej, “O Tamo Koba, ijo aŋgro sebiŋ a moiqa laqnu. Deqa ni bosim ino baŋ aqa jejamuq di atimqa a olo boleosim ŋambile sqas.” ");
INSERT INTO boj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Onaqa Yesus na Jairus odyosiqa a dauryosiq gileqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi dego naŋgi aiyel daurnjrsib jujuŋosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gileqnabqa naŋgo ambleq di uŋa bei ma ti soqnej qaji a naŋgi daurnjrsiq giloqnej. Uŋa di a nami bai na unej leŋ aiyoqnsiq degsi soqnej wausau 12 uratej. ");
INSERT INTO boj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yu qaŋgra tamo gargekoba naŋgi nami a boletqa yeqnab a jaqatiŋkobaiyoqnej. A ma gereiyo talq giloqnsiqa silali koba urateqnaqa naŋgi aqa jejamu gereiyeqnabqa a boleosaioqnej. Aqa ma olo kobaqujaoqnej. ");
INSERT INTO boj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Deqa a Yesus aqa ñam qusiqa are qalej, “E aqa gara mutu segi baŋ na ojitqa ijo ma koboqas.” Degsi are qalsiqa Yesus aqa qoreq na dadauryosiqa baŋ waiyosiq aqa gara mutu ojej. ");
INSERT INTO boj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ojnaqa aqa leŋ aiyoqnej qaji di koboej. Koboonaqa a aqa segi jejamu qalieosiqa marej, “Bole, ijo ma saiqo.” ");
INSERT INTO boj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Onaqa Yesus a poiyej, “Siŋgila qudei ijo jejamu uratosiq gilqo.” Degsi poiyonaqa bulosiq tamo uŋgasari tulaŋ gargekoba soqneb qaji naŋgi unjrsiqa nenemnjrej, “Yai na ijo gara ojqo?” ");
INSERT INTO boj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Degsi nenemnjrnaqa aqa aŋgro naŋgi na minjeb, “Ni kiyaqa degsi nenemonum? Ni une. Tamo uŋgasari tulaŋ gargekoba naŋgi ni daurmosib jujuŋmejunub.” ");
INSERT INTO boj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Onaqa Yesus a uŋa gara mutu ojej qaji di unqajqa ŋam atoqnej. ");
INSERT INTO boj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Onaqa uŋa di a endegsi qalieej, “Ijo ma saiqo deqa Yesus a e nubqajqa ŋam ateqnu.” A degsi qalieosiqa tulaŋ ulaugetosiq are toŋtoŋyonaqa jiŋga na bosiq Yesus aqa areq di siŋga pulutosiq a segi qa ubtosiq minjej, “E na ino gara mutu ojonum.” ");
INSERT INTO boj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Onaqa Yesus na minjej, “O uŋa, ni ino areqalo e qa siŋgilatosim ijoq bonum deqa ino ma agi koboqo. Deqa ni are lawo na gilsim bole soqnime.” ");
INSERT INTO boj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus a uŋa degsi minjeqnaqa tamo qudei naŋgi Jairus aqa talq dena bosibqa gamq di Jairus Yesus wo turosib naŋgi na Jairus minjeb, “Uŋgum. Ino aŋgro a nami moiqo. Deqa ni na Qalie Tamo a laŋa wau koba yaim. Uratim aiyem.” ");
INSERT INTO boj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Onaqa Yesus a naŋgo anjam di qusiqa Jairus minjej, “Ni ulaaim. Ni e qa ino areqalo siŋgilatime.” ");
INSERT INTO boj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","39","Degsi minjsiqa tamo uŋgasari kalil naŋgi a dauryqa saidnjrsiqa Jems aqa was Jon wo Pita ombla naŋgi segi joqsiqa Jairus koba na gilsib aqa talq di branteb. Brantosib Yesus a ŋam atej di tamo uŋgasari gargekoba naŋgi qatroŋ koba yoqnsib akam murqumyeqnab unjrej. Unjrsiqa tal gogetosiqa minjrej, “Niŋgi kiyaqa qatroŋ koba yoqnsib akameqnub? Aŋgro di a moiyosai. A laŋa ŋeisiq qambumtejunu.” ");
INSERT INTO boj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Degsi minjrnaqa naŋgi Yesus kikiyeb. Naŋgi qalieeb, “Aŋgro a nami moiyoboletqo.” Degsib qalieosib deqa Yesus kikiyeb. Onaqa Yesus a naŋgi kalil minjrej, “Niŋgi sasaloiy.” Degsi minjrnaqa naŋgi sasalonabqa Yesus a aŋgro moiyej qaji aqa ai abu osiqa aqa segi aŋgro qalub naŋgi dego joqsiqa aŋgro aqa warum miligiq gilej. ");
INSERT INTO boj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gilsiq aŋgro aqa baŋ titosiqa minjej, “Talita, kum.” Di Hibru anjam. Anjam di aqa damu, “O aŋgro, ni tigel.” ");
INSERT INTO boj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Degsi minjnaqa aŋgro di a olo ŋambile osiqa urur tigelej. Tigelosiq walwelej. Aŋgro aqa wausau 12. Onaqa naŋgi kalil Yesus aqa maŋwa di unsibqa tulaŋ prugeb. ");
INSERT INTO boj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Onaqa Yesus a naŋgi siŋgila na endegsi minjrej, “Niŋgi ijo maŋwa endi unonub deqa tamo qudei minjraib.” Osiqa marej, “Niŋgi aŋgro endi iŋgi anaiyiy.” ");
INSERT INTO boj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Onaqa Yesus a sawa di uratosiqa aqa aŋgro naŋgi joqsiqa aqa segi qure utruq gilej. ");
INSERT INTO boj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Gilsiq di sonaqa yori batiej. Deqa a Juda naŋgo Qotei tal miligiq gilsiqa tamo uŋgasari gargekoba sonabqa tigelosiqa Qotei aqa anjam palontosiq minjroqnej. Minjreqnaqa tamo uŋgasari naŋgi aqa anjam qusibqa tulaŋ prugugetosib maroqneb, “Yesus a powo qabe na osiqa anjam siŋgila endeqaji palontosiq mergeqnu? A kiyersiq maŋwa endeqaji babteleŋeqnu? ");
INSERT INTO boj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iga qalie, a laŋa tal gereiyo qaji tamo. A Maria aqa ŋiri. A Jems na Joses na Judas na Saimon na naŋgo was. Aqa jaja kalil naŋgi agi iga koba na endi unum.” Tamo uŋgasari naŋgi degsib yomu anjam marsib Yesus qa ugeeb. ");
INSERT INTO boj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Onaqa Yesus na kamba minjrej, “Qotei aqa medabu o qaji tamo bei aqa segi qure utruq gilsim anjam minjroqnqas di naŋgi aqa anjam quetqa asginjrqas. Deqa a ñam saiqoji sqas. Aqa segi talq di dego a ñam saiqoji sqas. Ariya a qure bei beiq giloqnsim anjam minjroqnqas di naŋgi aqa anjam quetoqnsib aqa ñam soqtoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesus a naŋgi degsi minjrsiqa aqa segi qure utruq di maŋwa bei yqajqa keresaiiyej. A tamo quja quja segi naŋgo gateq di aqa baŋ atnaqa naŋgo ma koboej. ");
INSERT INTO boj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aqa segi qure utru naŋgi a qa naŋgo areqalo siŋgilatosai deqa a are gulbeiyej. Onaqa Yesus a walwelosiqa qure bei beiq giloqnsiqa Qotei aqa anjam palontoqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Osiqa bati bei a na aqa aŋgro 12 naŋgi metnjrnaqa aqa areq bonabqa naŋgi tamo uŋgasari naŋgo jejamuq na mondor uge uge winjroqnqajqa deqa siŋgila enjrej. Osiqa minjrej, “Niŋgi aiye aiyel giloqnsibqa qure qureq di ijo anjam palontoqnsib laqniy. ");
INSERT INTO boj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Niŋgi iŋgi iŋgi osib gilaib. Iŋgi uyo bei aib. Nuŋgo qaquŋ aib. Silali osib gilaib. Toqoŋ segi osib walweliy. ");
INSERT INTO boj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Siŋga tatal dego jigsib giliy. Gara jugo aiye aiyel aib.” ");
INSERT INTO boj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Osiqa minjrej, “Niŋgi qure bei beiq di brantoqnsibqa tal qujaiq di soqniy. Dia sosib dena olo tigelosib qure beiq giloqniy. ");
INSERT INTO boj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tamo bei na niŋgi gereiŋgwa uratimqa kiyo nuŋgo anjam quqwa asgiyimqa kiyo niŋgi qure di uratqa oqnsib nuŋgo siŋga tatal tumbrum butuyoqniy. Yimqa naŋgi nuŋgo kumbra di unsib poinjrqas, ‘Bole, iga kumbra ugetonum.’” ");
INSERT INTO boj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesus na aqa aŋgro 12 naŋgi degsi minjrsiq qariŋnjrnaqa naŋgi qure qureq giloqnsibqa Qotei aqa anjam palontoqnsib tamo uŋgasari naŋgi endegsib minjroqneb, “Niŋgi are bulyiy.” ");
INSERT INTO boj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Osib mondor uge uge naŋgi winjroqnsibqa tamo uŋgasari naŋgo gateq di goreŋ bilenteqnabqa naŋgo ma saioqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesus aqa aŋgro naŋgi aqa ñam mare mare laqnabqa Mandor Herot a quej. Tamo uŋgasari gargekoba naŋgi dego qusib maroqneb, “Tamo di a Jon yansnjro qaji. A moisiq olo subq na tigelqo. A deqa siŋgila osiqa maŋwa endeqaji babteleŋeqnu.” ");
INSERT INTO boj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Onaqa tamo qudei naŋgi maroqneb, “Tamo di a Elaija olo bqo.” Onaqa qudei naŋgi maroqneb, “Tamo di a Qotei aqa medabu o tamo naŋgi nami soqneb deqaji bei.” ");
INSERT INTO boj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ariya Herot a segi Yesus aqa ñam qusiqa marej, “Tamo di a Jon e nami kakro gentetem qaji. A moisiq olo subq na tigelqo.” ");
INSERT INTO boj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herot a nami aqa was Filip aqa ŋauŋ Herodias yaiyosiq ej. Deqa Jon yansnjro qaji a na Herot minjoqnej, “Ni ino segi was aqa uŋa em di kumbra bolesai. Ni kumbra ugeteqnum.” Jon na Herot degsi minjoqnej. Deqa Herot a Jon qa minjiŋ oqetonaqa aqa qaja tamo qudei naŋgi qariŋnjrnaqa gilsib Jon ojsib sil na qosisib tonto talq di waiyeb. ");
INSERT INTO boj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bati deqa Herot aqa ŋauŋ a Jon qa tulaŋ ŋiriŋugetej deqa a na Herot waiŋyosiq minjoqnej, “Ni na Jon qalim moiyem.” Yeqnaqa Herot na saidyoqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Di kiyaqa? A Jon qa ulaoqnej deqa. Deqa a Jon geregere taqatoqnej. A endegsi qalieej, “Jon a tamo bole. Aqa jejamuq di une bei saiqoji. A Qotei aqa tamo tiŋtiŋ.” Herot a degsi qalieosiq deqa a Jon taqatoqnsiqa aqa anjam quoqnej. Quoqnsiqa are koba qaloqnej. A Jon aqa anjam quqwajqa tulaŋ arearetoqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ariya bati bei Herot aqa ŋauŋ a Jon qalim moiqajqa gam endegsi itej. Herot aqa ŋambabo bationaqa Herot na maruro atsiqa aqa tamo kokba ti aqa qaja tamo naŋgo gate kokba ti Galili sawa taqato tamo naŋgi ti metnjrnaq bosib aqa talq di koroeb. ");
INSERT INTO boj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Koroosib iŋgi uyeqnabqa Herot aqa ŋauŋ aqa aŋgro sebiŋ a warum miligiq bosiqa naŋgi lou tuetnjreqnaqa naŋgi a unsibqa tulaŋ areboleboleinjrej. Deqa Herot na aŋgro sebiŋ di minjej, “Ni ijo iŋgi kiye oqajqa merbqam e ni emqai.” ");
INSERT INTO boj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Osiqa aqa anjam di olo siŋgilatosiqa minjej, “Ni ijo ñoro kalil ambleq na potosim oqajqa marqam emqai. E ijo anjam di uratqasai bole sai.” ");
INSERT INTO boj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Onaqa aŋgro sebiŋ a gilsiqa aqa ai nenemyej, “E iŋgi kiye qa Herot minjqai?” Onaqa minjej, “Ni Jon yansnjro qaji aqa gate qa mare.” ");
INSERT INTO boj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Onaqa a olo urur ti warum miligiq gilsiqa Herot minjej, “Ni Jon yansnjro qaji aqa gate tabirq di atsim ebe.” ");
INSERT INTO boj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Onaqa Herot a Jon qalim moiqajqa are sosai deqa a are tulaŋ gulbekobaiyej. Ariya aqa segi anjam tamo kalil naŋgo ulatamuq di marsiq siŋgilatej qaji deqa are qalsiq aŋgro sebiŋ di saidyqa uratej. ");
INSERT INTO boj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Osiqa aqa qaja tamo bei qariŋyosiqa minjej, “Ni gilsim Jon aqa kakro gentosim aqa gate osau.” Degsi minjnaqa a gilsiqa tonto talq di Jon aqa kakro gentosiqa aqa gate tabirq di atsiqa osi bosiq aŋgro sebiŋ di yej. Yonaqa a na osi gilsiqa aqa ai yej. ");
INSERT INTO boj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Onaqa bunuqna Jon aqa aŋgro naŋgi deqa qusibqa bosib Jon aqa qusa osi gilsib subq ateb. ");
INSERT INTO boj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bati bei Yesus aqa anjam maro tamo naŋgi olo aqa areq di koroosib kumbra kalil naŋgi yoqneb qaji deqa ti anjam kalil naŋgi palontoqneb qaji deqa ti Yesus saiyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bati deqa tamo uŋgasari tulaŋ gargekoba naŋgi gile be eqnab Yesus aqa aŋgro naŋgi ti iŋgi uyqa bati saiinjrej. Deqa a na naŋgi endegsi minjrej, “Niŋgi tigeliy. Iga tamo uŋgasari naŋgi uratnjrsim segitosim wadau sawaq di kiñala aqaratqom.” ");
INSERT INTO boj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Degsi minjrsiqa aqa aŋgro naŋgi joqsiqa koba na qobuŋ gogetosib wadau sawaq gileb. ");
INSERT INTO boj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Naŋgi qobuŋ na gileqnabqa tamo uŋgasari kalil naŋgi Yesus unsibqa aqa ulatamu poinjrnaqa naŋgo qure qureq na tigelosib siŋga na gurgurosib gilsib Yesus tiryqajqa sawaq di namoqna branteb. ");
INSERT INTO boj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Onaqa Yesus a qobuŋ na gilsiq tiryosiqa ŋam atej di tamo uŋgasari tulaŋ gargekoba naŋgi nami tiryqa sawaq di tariŋesonab unjrej. Naŋgi kaja bul mandor saiqoji. Deqa Yesus a naŋgi qa dulosiqa Qotei aqa anjam gargekoba minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Onaqa seŋ aisiq bilaqtonaqa Yesus aqa aŋgro naŋgi aqa areq bosib minjeb, “O Tamo Koba, endi wadau sawa. Seŋ aiqo. Qoloqas. ");
INSERT INTO boj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Deqa ni na tamo uŋgasari naŋgi minjrimqa qure qureq gilsib dia iŋgi uysib ŋereŋqab.” ");
INSERT INTO boj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Onaqa Yesus na minjrej, “Niŋgi na iŋgi anainjriy.” Degsi minjrnaqa naŋgi na kamba minjeb, “Iga kiyersim iŋgi anainjrqom? Iga 200 kina qabe na osimqa iŋgi awaiyosim naŋgi anainjrqom?” ");
INSERT INTO boj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Onaqa Yesus na nenemnjrej, “Niŋgi iŋgi gembub unu? Niŋgi gilsib uniy.” Onaqa naŋgi gilsib unsib minjeb, “Iga bem 5 qe aiyela segi unu.” ");
INSERT INTO boj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Onaqa Yesus na tamo uŋgasari kalil naŋgi minjrej, “Niŋgi qur segi segi yosibqa ñiŋq di awoeleŋoiy.” ");
INSERT INTO boj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Onaqa naŋgi kalil dedegsib awoeb. Qudei naŋgi qur segi segi 100 awoeleŋeb. Qudei naŋgi qur segi segi 50 awoeleŋeb. ");
INSERT INTO boj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Awoonabqa Yesus na bem 5 ti qe aiyel ti di osiqa laŋ goge tarosiq Qotei pailyej. Pailyo koboonaqa bem giŋgeŋyosiqa aqa aŋgro naŋgi enjrsiqa minjrej, “Bem endi jeisib tamo uŋgasari naŋgi anainjriy.” Osiqa qe aiyel dego giŋgeŋyosiqa aqa aŋgro naŋgi enjrsiqa minjrej, “Qe endi dego jeisib tamo uŋgasari naŋgi anainjriy.” Degsi minjrnaqa naŋgi bem ti qe ti osi giloqnsibqa tamo uŋgasari naŋgi jeisib anainjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Uynab kalil menetnjrej. ");
INSERT INTO boj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Onaqa iŋgi oto urateleŋeb qaji di Yesus aqa aŋgro naŋgi na koroiyosib gumba kokba 12 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tamo kalil bem ti qe ti uyeb qaji naŋgi sisiyeb 5,000. ");
INSERT INTO boj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi qobuŋ gogetosib namoosib gilsib Betsaida qureq di tiryosib soqniy. E na tamo uŋgasari naŋgi minjritqa naŋgo qure qureq jaraiyoqnib e bqai.” ");
INSERT INTO boj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Onaqa Yesus aqa aŋgro naŋgi namoosib qobuŋ na gileqnabqa Yesus na tamo uŋgasari naŋgi minjrnaq jaraiyeqnabqa a segi Qotei pailyqa marsiq manaq oqej. ");
INSERT INTO boj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Oqsiq a segi mana goge di sonaqa bilaqtej. Onaqa aqa aŋgro naŋgi qobuŋ na gileqnabqa ya agu ambleq di jagwa koba tigelosiqa ya korkortosiqa naŋgi pulutnjrej. Nobqolo ambru Yesus a ya baŋgaq na walwelosiqa aqa aŋgro naŋgi daurnjrsiq gilej. Gilsiq naŋgi jojomnjrsiq buŋnjrqa laqnaqa ŋam ateb di Yesus a ya baŋgaq na walwelosiq naŋgoq beqnaqa unsib mareb, “Di buga beqnu.” Osib tulaŋ ulaugetosib leleŋkobaeb. Onaqa Yesus na minjrej, “Nuŋgo are siŋgilatiy. Endi e beqnum. Ulaaib.” ");
INSERT INTO boj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Degsi minjrsiqa qobuŋ gogetonaqa jagwa laej. Onaqa Yesus aqa aŋgro naŋgi tulaŋ prugugeteb. Di kiyaqa? Naŋgi Yesus aqa maŋwa di unsib utru geregere poinjrosai deqa. Nami Yesus na tamo 5,000 naŋgi iŋgi anainjrej maŋwa di dego aqa aŋgro naŋgi unsib poinjrosai. Naŋgo are geteŋnjresoqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ariya Yesus aqa aŋgro naŋgi koba na qobuŋ na gilsib ya agu taqal beiq di brantosib Genesaret sawaq di tiryeb. ");
INSERT INTO boj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Tiryonabqa qure deqaji naŋgi na Yesus unsibqa aqa ulatamu poinjrnaqa gurgur ti qure qureq giloqnsibqa Yesus tiryej qaji sawa di ubtosib tamo uŋgasari naŋgi minjroqneb. Minjreqnab quoqnsib naŋgo ma tamo naŋgi saperaq di ateleŋoqnsib qoboiyoqnsib Yesus aqa areq osi beleŋeqnab a na naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A qure kiñilala ti qure kokba ti ga gamq di dego branteqnaqa tamo uŋgasari naŋgi a unoqnsibqa tamo ma ti naŋgi joqoqnsib naŋgo qure ambleq di atoqnsib endegsib minjoqneb, “O Tamo Koba, naŋgi ino gara mutu segi ojibqa naŋgo ma saioqnqas.” Onaqa Yesus a naŋgi odnjreqnaqa ma tamo kalil naŋgi aqa gara mutu ojoqneb. Ojeqnab naŋgo ma kalil kobooqnej. ");
INSERT INTO boj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Onaqa Farisi naŋgi ti dal anjam qalie tamo qudei ti naŋgi Jerusalem dena bosibqa Yesus aqa areq di koroeb. ");
INSERT INTO boj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Koroosib ŋam ateb di Yesus aqa aŋgro qudei naŋgi baŋ yansosaisosib laŋa iŋgi uyeqnab unjreb. ");
INSERT INTO boj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi naŋgo kumbra agiende. Bati gaigai naŋgi iŋgi uyqa oqnsib mati baŋ yanseqnub. Naŋgi baŋ yansqasai di naŋgi iŋgi uyqasai. Juda kalil naŋgi kumbra degyeqnub. Di naŋgo moma naŋgo kumbra dauryeqnub. ");
INSERT INTO boj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Naŋgi iŋgi qariŋyo sawaq dena boqnsibqa iŋgi uyqa oqnsib mati naŋgo jejamu geregere yanseqnub. Naŋgi naŋgo jejamu yansqasai di naŋgi iŋgi uyqasai. Naŋgi kumbra deqaji gargekoba yeqnub. Naŋgo ya gambaŋ, ya nobu, web dego mati geregere yanseleŋoqnsib iŋgi uyeqnub. Kumbra di naŋgo moma naŋgoq dena eleŋosib dauryeqnub. ");
INSERT INTO boj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Deqa bati di Farisi naŋgi ti dal anjam qalie tamo naŋgi ti Yesus nenemyeb, “Ino aŋgro naŋgi kiyaqa gago moma naŋgo kumbra gotraŋyeqnub? Agi naŋgi iŋgi uyqa oqnsib mati baŋ yansosaisosib laŋa uyeqnub.” ");
INSERT INTO boj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Onaqa Yesus na kamba minjrej, “Niŋgi gisaŋ tamo. Niŋgi anjam maro aiyelteqnub. Qotei aqa medabu o qaji tamo Aisaia a kere niŋgi qa anjam endegsi neŋgreŋyej, ‘Tamo naŋgi di naŋgo medabu na ijo ñam soqteqnub. Ariya naŋgo are miligi e qa sosai. Isaq di unu. ");
INSERT INTO boj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naŋgi laŋa babaŋ na e qa loueqnub. Osib mandam tamo naŋgo dal anjam palontoqnsib olo beltoqnsib mareqnub, “Anjam endi Qotei aqa anjam.” ’ ");
INSERT INTO boj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaia a anjam degsi neŋgreŋyej. Aqa anjam di bole. Agi niŋgi Qotei aqa dal anjam gotraŋyoqnsibqa olo mandam tamo naŋgo dal anjam dauryqajqa tulaŋ siŋgilaeqnub.” ");
INSERT INTO boj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus na Farisi naŋgi anjam degsi minjrsiqa olo minjrej, “Niŋgi Qotei aqa dal anjam gotraŋyoqnsibqa olo nuŋgo segi moma naŋgo kumbra dauryeqnub. ");
INSERT INTO boj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses a marej, ‘Ni ino ai abu naŋgo sorgomq di geregere sosimqa naŋgo anjam dauryoqne. Tamo bei na aqa ai abu naŋgi misiliŋnjrimqa a qalib moiyem.’ Moses a degsi marej. ");
INSERT INTO boj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ariya niŋgi mareqnub, ‘Tamo bei aqa ai kiyo aqa abu kiyo iŋgi qa truquamqa a na minjqas, “Ijo iŋgi iŋgi ejunum endi e ni emqa kere. Eo. E ni emqasai. E nami Qotei atraiyqa giltem deqa e ni aqaryaimqasai.” ’ ");
INSERT INTO boj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A degsi minjqas di niŋgi marqab, ‘A keretqo. A na aqa ai abu naŋgi aqaryainjraiq.’ Niŋgi degsib marqab. ");
INSERT INTO boj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nuŋgo kumbra dena niŋgi Qotei aqa anjam gotraŋyoqnsibqa olo nuŋgo segi moma naŋgo kumbra dauryeqnub. Niŋgi kumbra deqaji gargekoba yeqnub.” ");
INSERT INTO boj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus a Farisi naŋgi anjam degsi minjrsiqa olo tamo uŋgasari kalil naŋgi metnjrnaqa aqa areq bonabqa minjrej, “Niŋgi kalil ijo anjam endi geregere qusib poiŋgem. ");
INSERT INTO boj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tamo bei a iŋgi uyimqa aqa miligiq aiqas dena tamo jiga yqasai. Iŋgi uge uge tamo aqa miligiq na oqoqnsiq branteqnu qaji dena tamo jiga yeqnu. ");
INSERT INTO boj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus na tamo uŋgasari naŋgi anjam degsi minjrsiq koboonaqa a naŋgi uratnjrsiqa tal miligiq gilej. A tal miligiq gilsiq di sonaqa aqa aŋgro naŋgi na aqa yawo anjam di aqa utru qa nenemyeb. ");
INSERT INTO boj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Nenemyonabqa minjrej, “Niŋgi dego ijo yawo anjam di aqa utru poiŋgosai e? Niŋgi quiy. Tamo naŋgi iŋgi uyeqnabqa aisiq meneq di unu. Meneq dena bi talq di waiyeqnub. Iŋgi di tamo aqa are miligiq aiyosai. Aqa bi aniq aiqo koboqo. Deqa iŋgi dena tamo jiga yqa keresai.” Yesus aqa anjam dena a iŋgi uyo kalil jiga saiqoji qa marej. ");
INSERT INTO boj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Osiqa aqa aŋgro naŋgi olo minjrej, “Iŋgi uge uge tamo aqa miligiq na oqoqnsiq branteqnu qaji dena tamo jiga yeqnu. ");
INSERT INTO boj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Di kiyaqa? Iŋgi uge uge di tamo aqa are miligiq na branteqnu. Iŋgi uge uge di agi ubtosiy merŋgwai. Areqalo uge uge, uŋa qa laoqa, bajiŋoqa, tamo qaloqa, ");
INSERT INTO boj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","was aqa ŋauŋ anjamyoqa, was aqa ñoro qa maulyoqa, kumbra uge uge yoqa, gisaŋoqa, laŋa laŋa laoqa, was qa ugeoqa, was yomuiyoqa, aqa segi ñam soqtoqa, nanari kumbra yoqa. ");
INSERT INTO boj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kumbra uge uge deqaji tamo aqa are miligiq na brantoqnsiq dena tamo jiga yeqnu.” ");
INSERT INTO boj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Onaqa Yesus a dena tigelosiqa walwelosiq Tair qure naŋgo sawaq gilej. Tamo naŋgi a qa qalieaib deqa a uliosiq gilej. Gilsiq tal bei gogetosiq sosiqa a uliesqa keresai. Tamo qudei naŋgi a unsib mareb, “Yesus a gago sawaq bqo. A talq di unu.” ");
INSERT INTO boj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Degsib marnabqa uŋa bei a qusiqa aqa aŋgro sebiŋ a mondor uge ti soqnej deqa a Yesus aqa talq giloqujatosiqa aqa areq di siŋga pulutej. ");
INSERT INTO boj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uŋa di a Grik qaji. A Juda uŋa sai. A Siria sawaq di ŋambabej. A Fonisia qure qaji. A Yesus aqa areq di siŋga pulutosiq a waiŋyoqnsiqa minjoqnej, “Ni na mondor uge di wiyimqa a ijo aŋgro uratosim ulaŋqas.” ");
INSERT INTO boj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Onaqa Yesus na minjej, “Iga aŋgro du du naŋgi mati iŋgi anainjrim uyib menetnjrqas di kumbra bole. Iga aŋgro du du naŋgo iŋgi yainjrsim olo bauŋ naŋgi anainjrqom di kumbra bolesai.” ");
INSERT INTO boj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Onaqa uŋa dena olo Yesus minjej, “O Tamo Koba, ni kere maronum. Ariya e kamba anjam bei mermit ni que. Aŋgro du du naŋgi iŋgi uyeqnabqa iŋgi ñeŋgi ululoŋeqnaqa bauŋ naŋgi dego uyeqnub.” ");
INSERT INTO boj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Onaqa Yesus na minjej, “O uŋa, ni kere maronum. Ni degsi maronum deqa ni gilime. Mondor uge a ino aŋgro uratosiq ulaŋqo.” ");
INSERT INTO boj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Degsi minjnaqa a aqa talq gilsiqa ŋam atej di mondor uge a nami aqa aŋgro uratonaqa a bijalq di ŋeiesonaq unej. ");
INSERT INTO boj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Onaqa Yesus a Tair qure naŋgo sawa uratosiqa Saidon qure ambleq na walwelosiqa Dekapolis sawaq gilsiqa Galili ya aguq di brantej. ");
INSERT INTO boj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Di brantosiq sonaqa tamo qudei na tamo bei dabkala geteŋo meŋ siŋgilaej qaji a osi bosibqa Yesus pailyosib minjeb, “O Tamo Koba, ni ino baŋ aqa gateq di atimqa a boleqas.” ");
INSERT INTO boj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Onaqa Yesus a tamo di osiqa tamo uŋgasari naŋgi uratnjrsiq a segi sosiqa aqa baŋ gei aiyel tamo di aqa dabkalaq jigej. Jigsiqa aqa segi maul osiqa tamo di aqa meŋ toŋyetej. ");
INSERT INTO boj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Osiqa laŋ tarosiqa are tulaŋ gulbekobaiyonaqa jagwa titosiq marej, “Efata.” Di Hibru anjam. Anjam di aqa damu, “Dabkala waqeme.” ");
INSERT INTO boj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A degsi marnaqa tamo di aqa dabkala waqej. Aqa meŋ dego boleej. Boleonaqa a anjam bole maroqnej. ");
INSERT INTO boj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Onaqa Yesus na tamo uŋgasari naŋgi endegsi minjrej, “Niŋgi kumbra unonub endi tamo qudei naŋgi ubtosib minjraib.” Degsi minjrnaqa naŋgi aqa anjam di quetosai. Naŋgi giloqnsibqa Yesus aqa maŋwa deqa mare mare laqneb. ");
INSERT INTO boj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mare mare laqnabqa tamo gargekoba naŋgi quoqnsib tulaŋ prugoqnsib maroqneb, “Maŋwa kalil Yesus a yeqnu qaji di a geregere yeqnu. Agi a na tamo dabkala geteŋnjro qaji naŋgi boletnjreqnaqa naŋgo dabkala olo waqeqnaqa naŋgi anjam queqnub. Tamo meŋ siŋgilainjro qaji naŋgi dego gereinjreqnaqa naŋgi anjam bole mareqnub.” ");
INSERT INTO boj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Onaqa bati bei Yesus a wadau sawaq di sonaqa tamo uŋgasari tulaŋ gargekoba naŋgi olo aqa areq di korooqneb. Naŋgi iŋgi saiqoji. Deqa Yesus na aqa aŋgro naŋgi metnjrnaqa aqa areq bonabqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tamo uŋgasari naŋgi bati qalub e koba na soqneb naŋgi iŋgi saiqoji. Deqa e naŋgi qa are ugeibqo. ");
INSERT INTO boj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naŋgi qudei isaq na beb. Deqa e naŋgi mam ti suweinjritqa gamq di naŋgi mam na lao uge.” ");
INSERT INTO boj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Degsi minjrnaqa naŋgi na kamba minjeb, “Sawa endi wadau. Deqa iga qabe na iŋgi osimqa tamo uŋgasari gargekoba endi anainjronam kereqas?” ");
INSERT INTO boj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Onaqa Yesus na minjrej, “Niŋgi bem gembub unu?” Onaqa minjeb, “Bem 7 unu.” ");
INSERT INTO boj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Onaqa Yesus na tamo uŋgasari naŋgi minjrej, “Niŋgi kalil mandamq di awoeleŋoiy.” Degsi minjrnaqa naŋgi kalil mandamq di awoonabqa Yesus na bem 7 di osiqa Qotei pailyej. Pailyosiqa bem giŋgeŋyosiqa aqa aŋgro naŋgi enjreqnaqa naŋgi na osi giloqnsibqa tamo uŋgasari naŋgi anainjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Qe kiñilala qudei dego soqneb. Deqa Yesus na qe di osiqa Qotei pailyosiqa aqa aŋgro naŋgi minjrej, “Qe endi dego tamo uŋgasari naŋgi anainjriy.” Degsi minjrnaqa naŋgi na qe di osib tamo uŋgasari naŋgi jeisib anainjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Uynab kalil menetnjrej. Onaqa iŋgi oto urateleŋeb qaji di Yesus aqa aŋgro naŋgi na koroiyosib gumba kokba 7 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tamo kalil iŋgi uyeb qaji naŋgi sisiyeb 4,000. Onaqa Yesus na tamo uŋgasari kalil naŋgi suweinjrnaqa naŋgo qure qureq giloqneb. ");
INSERT INTO boj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Naŋgi gileqnabqa Yesus na aqa aŋgro naŋgi olo joqsiqa koba na qobuŋ gogetosib Dalmanuta sawaq gileb. ");
INSERT INTO boj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Onaqa Farisi naŋgi Yesus aqa areq bosibqa a anjam bei grotimqa qusib a ojqajqa deqa a ombla anjam na qoteb. Osib gisaŋyosib minjeb, “Ni Qotei aqa maŋwa bei babtim iga unqom.” ");
INSERT INTO boj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Degsib Yesus minjnabqa a naŋgi qa are tulaŋ gulbeiyonaqa jagwa titosiqa minjrej, “Niŋgi tamo uŋgasari bini bati endeqa unub qaji kiyaqa e Qotei aqa maŋwa bei laŋa babtit niŋgi unqajqa metbeqnub? Niŋgi quiy. E Qotei aqa maŋwa bei niŋgi osorŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesus a Farisi naŋgi degsi minjrsiqa naŋgi uratnjrsiqa olo qobuŋ gogetosiqa ya agu taqal beiq gilej. ");
INSERT INTO boj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bati deqa Yesus aqa aŋgro naŋgi bem oqajqa are walnjrej. Bem qujai bole qujai qobuŋ miligiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Onaqa Yesus a yawo anjam bei endegsi minjrej, “Niŋgi geregere ŋam atsib soqniy. Bem tiyeqnu qaji sum Farisi naŋgo bem ti bulyimqa bem dena tiyekritosim tulaŋ kobaqujaqas. Herot aqa bem dego tiyekritosim tulaŋ kobaqujaqas.” ");
INSERT INTO boj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Onaqa Yesus aqa aŋgro naŋgi aqa yawo anjam di qusibqa segi segi maroqneb, “Iga bem osai deqa kiyo mergwo?” ");
INSERT INTO boj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Onaqa Yesus a naŋgo anjam di qalieosiqa nenemnjrej, “Niŋgi kiyaqa bem osai deqa mareqnub? Kiyaqa niŋgi e qa poiŋgosai unu? Nuŋgo are geteŋgejunu kiyo? ");
INSERT INTO boj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Niŋgi ijo siŋgila unoqnsib unosaibuleqnub. Niŋgi ijo anjam quoqnsib quosaibuleqnub. ");
INSERT INTO boj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","E nami bem 5 giŋgeŋyosimqa tamo 5,000 anainjronam uynab menetnjrnaqa niŋgi iŋgi oto koroiyosib gumba kokba gembub jignab maqeleŋej?” Onaqa naŋgi na Yesus minjeb, “Gumba 12.” ");
INSERT INTO boj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Onaqa olo minjrej, “Bati bei e bem 7 dego giŋgeŋyosimqa tamo 4,000 anainjronam uynab menetnjrnaqa niŋgi iŋgi oto koroiyosib gumba kokba gembub jignab maqeleŋej?” Onaqa minjeb, “Gumba 7.” ");
INSERT INTO boj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Onaqa minjrej, “Niŋgi kiyaqa e qa poiŋgosai unu?” ");
INSERT INTO boj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus na aqa aŋgro naŋgi degsi minjrsiqa koba na qobuŋ na gilsib Betsaida qureq di tiryeb. Tiryosib mandamq ainabqa tamo qudei na tamo bei ŋam qandimyej qaji a Yesus aqa areq osi bosib minjeb, “Ni ino baŋ aqa gateq di atimqa a olo boleosim ŋam poiyqas.” ");
INSERT INTO boj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Onaqa Yesus a tamo di aqa baŋ ojsiqa qure polomq osi gilsiqa aqa ŋamdamuq di misel atetej. Osiqa aqa gateq di aqa baŋ atsiqa nenemyej, “Ni sawa unqa kere e?” ");
INSERT INTO boj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Onaqa a ŋam atsiqa marej, “E tamo naŋgi unjronum naŋgi ŋamtaŋ bul anŋileqnub.” ");
INSERT INTO boj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Onaqa Yesus a olo tamo di aqa ŋamdamuq di aqa baŋ atnaqa a ŋam atej ŋamdamu bole suwaŋej. A sawa kalil geregere unej. ");
INSERT INTO boj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Onaqa Yesus na minjej, “Ni ino talq gilime. Ni qure miligiq gilaim.” ");
INSERT INTO boj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Onaqa Yesus na aqa aŋgro naŋgi olo joqsiqa koba na walwelosib Sisaria Filipai qure naŋgo sawaq di brantosib gamq di Yesus na aqa aŋgro naŋgi endegsi nenemnjrej, “Tamo uŋgasari naŋgi e qa kiyersib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Onaqa naŋgi na minjeb, “Tamo qudei naŋgi mareqnub, ni Jon yansnjro qaji. Qudei naŋgi mareqnub, ni Elaija. Qudei naŋgi mareqnub, ni Qotei aqa medabu o tamo naŋgi nami soqneb deqaji bei.” ");
INSERT INTO boj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Onaqa Yesus na olo nenemnjrej, “Niŋgi segi e qa kiyersib mareqnub?” Onaqa Pita na minjej, “Ni Kristus.” ");
INSERT INTO boj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita a anjam degsi ubtonaqa Yesus na aqa aŋgro naŋgi siŋgila na getentnjrsiqa minjrej, “Niŋgi anjam di olo tamo qudei minjraib.” ");
INSERT INTO boj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Osiqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “E Tamo Aŋgro. Bunuqna e jaqatiŋ koba oqai. Juda gate naŋgi ti atra tamo kokba ti dal anjam qalie tamo naŋgi ti e qoreibosib lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus a anjam degsi ubtosiq marnaqa Pita na Yesus osiqa qalaq gilsiqa ŋiriŋtej. ");
INSERT INTO boj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Onaqa Yesus a bulosiqa aqa aŋgro naŋgi koqnjrsiqa Pita ŋiriŋtosiq minjej, “Ni Satan bul. Deqa ni ijo qoreq gile. Ni Qotei aqa areqalo dauryosai. Ni mandam tamo naŋgo areqalo dauryonum. Dauryosim agi ni na anjam di merbonum.” ");
INSERT INTO boj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Osiqa Yesus na tamo uŋgasari kalil naŋgi ti aqa segi aŋgro naŋgi ti metnjrnaqa aqa areq bonabqa minjrej, “Tamo bei na e daurbqa osimqa a aqa segi areqalo kalil uratekritosim aqa segi ŋamburbas qoboiyosim e daurbem. ");
INSERT INTO boj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tamo bei na aqa segi ŋambile taqatqajqa arearetqas di a padalqas. Ariya tamo bei a e qa ti ijo anjam bole qa ti are qalsimqa aqa segi ŋambile uratqas di a olo ŋambile bole oqas. ");
INSERT INTO boj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamo bei a mandam qa ñoro kalil koroiyosim ariya mondoŋ aqa segi qunuŋ padalqas di ñoro dena a kiyersim aqaryaiyqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aqa qunuŋ padalqas di a awai kiye atsim dena aqa qunuŋ olo aqaryaiyosim a ŋambile sqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","E Tamo Aŋgro. Tamo uŋgasari bini bati endeqa unub qaji naŋgi Qotei torei qoreiyoqnsib une atoqnsib laqnub. Deqa bini bati endi tamo bei a e qa ti ijo anjam qa ti jemaiyqas di mondoŋ e ijo Abu aqa riaŋ na ti aqa laŋ aŋgro naŋgo riaŋ na ti bosiyqa e kamba tamo deqa jemaibqas.” ");
INSERT INTO boj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Osiqa Yesus a olo aqa aŋgro naŋgi endegsi minjrej, “E bole merŋgwai. Tamo qudei ijo areq endi tigelejunub qaji naŋgi moreŋosaisoqnibqa Qotei a siŋgila ti bqas. Bosim naŋgi taqatnjrsim naŋgo Mandor Koba soqnim naŋgi unqab.” ");
INSERT INTO boj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Osiqa bati 6 onaqa Yesus a tigelosiqa Pita na Jems na Jon na naŋgi segi qalub joqsiqa koba na mana goge kobaq oqsib di soqneb. Sosibqa Yesus aqa jejamu bulyonaq naŋgi unobeiteb. ");
INSERT INTO boj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aqa gara dego tulaŋ puloŋosiq qatekritej. Tamo bei na gara yansqas degsim qatqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","5","Onaqa Moses Elaija wo naŋgi brantosib Yesus koba na anjam maroqneb. Mareqnabqa Yesus aqa aŋgro naŋgi na naŋgi aiyel unjrsibqa Pita a Yesus minjej, “O Tamo Koba, Moses Elaija wo naŋgi bosib iga koba na endi unum di bolequja. Deqa ni marimqa iga tal kiñilala qalub gereiyqom. Bei ino. Bei Moses aqa. Bei Elaija aqa.” ");
INSERT INTO boj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yesus aqa aŋgro naŋgi tulaŋ ulaugeteb deqa Pita a anjam bei marqa saiiyonaqa anjam di laŋa marej. ");
INSERT INTO boj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Onaqa laŋbi aisiqa naŋgi kabutnjrnaqa laŋbi miligiq dena anjam bei endegsi brantonaq naŋgi queb, “Endi ijo Aŋgro qujai e na tulaŋ qalaqalaiyeqnum qaji. Niŋgi aqa anjam quetoqniy.” ");
INSERT INTO boj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Onaqa Yesus aqa aŋgro naŋgi bulosib ŋam ateb di Yesus a segi naŋgi koba na sonab uneb. Naŋgi tamo bei unosai. ");
INSERT INTO boj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Onaqa naŋgi Yesus ombla manaq dena olo aiyoqnsibqa Yesus na minjrej, “Maŋwa niŋgi mana goge di unonub qaji di ubtosib tamo qudei minjraib. Bunuqna e Tamo Aŋgro moisiy olo subq na tigelotqa bati deqa niŋgi na ubtosib minjroqnqab.” ");
INSERT INTO boj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Onaqa naŋgi Yesus aqa anjam di qusib segi segi maroqneb, “Yesus a kiyaqa subq na tigelqa marqo? Anjam di aqa utru iga poigosai.” Degsib maroqnsib Yesus aqa anjam di naŋgo areqaloq di atnab soqnej. ");
INSERT INTO boj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Osib naŋgi Yesus minjeb, “Dal anjam qalie tamo naŋgi mareqnub, ‘Elaija a namo bamqa Kristus a bunuqna bqas.’ Anjam di kiyaqa degsib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Onaqa Yesus na minjrej, “Naŋgo anjam di bole. Elaija a namo bosim tamo uŋgasari kalil naŋgo areqalo gereiyetnjrsim soqnim bunuqna Kristus a bqas. Ariya anjam kiye neŋgreŋq di unu? Anjam agiende. Jeu tamo naŋgi na e Tamo Aŋgro kumbra uge ebibqa e jaqatiŋ koba oqai. ");
INSERT INTO boj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","E niŋgi olo merŋgwai. Elaija agi bej. Bonaqa gulbe kalil naŋgi a yqajqa are soqnej qaji agi yeb. Anjam di nami a qa neŋgreŋyeb unu.” ");
INSERT INTO boj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Onaqa Yesus na aqa aŋgro qalub naŋgi di joqsiqa koba na aisib mana utruq di branteb. Brantosib ŋam ateb di Yesus aqa aŋgro qudei naŋgi ti dal anjam qalie tamo qudei ti anjam na qoteqnab unjreb. Tamo uŋgasari gargekoba naŋgi dego Yesus aqa aŋgro naŋgi kaiŋnjresonab unjreb. ");
INSERT INTO boj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Onaqa tamo uŋgasari kalil naŋgi Yesus unsibqa tulaŋ prugugetosib gurgur ti aqa areq bosib minjeb, “O Tamo Koba, bilaq bole.” ");
INSERT INTO boj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Degsib minjnabqa Yesus na aqa aŋgro naŋgi nenemnjrej, “Niŋgi naŋgi ti anjam kiye na qoteqnub?” ");
INSERT INTO boj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Onaqa tamo uŋgasari naŋgo ambleq dena tamo bei brantosiqa Yesus minjej, “O Qalie Tamo, e ijo aŋgro mel osi bonum agiende. Ni na a boletqajqa deqa osi bonum. A mondor uge ti. Deqa aqa medabu geteŋyejunu. ");
INSERT INTO boj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mondor uge dena aqa jejamu ojoqnsiqa mandamq waiyeqnaqa ara gijiriqtoqnsiqa tindaŋeqnu. Oqnsiqa maul aiyeqnu. Deqa e na ino aŋgro naŋgi minjronum, ‘Niŋgi mondor uge di wiyiy.’ Minjronumqa naŋgi na wiyqa yonub keresaiinjrqo.” ");
INSERT INTO boj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Onaqa Yesus a anjam di qusiqa marej, “Niŋgi tamo uŋgasari bini bati endeqa unub qaji nuŋgo areqalo e qa siŋgilatosai bole sai. Bati gembub e niŋgi koba na sosiyqa nuŋgo gulbe di qoboiyoqnqai? Aŋgro mel di ijo areq osi boiy.” ");
INSERT INTO boj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Onaqa osi bonabqa mondor uge dena Yesus unsiqa aŋgro di qunjimyonaqa a mandamq aisiqa belbelonaqa aqa medabuq na maul aiyoqnej. ");
INSERT INTO boj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Onaqa Yesus na aŋgro di aqa abu nenemyej, “Bati gembub a degesoqnej?” Onaqa minjej, “A aŋgro kiñala qa degesoqnej agi bini unu. ");
INSERT INTO boj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mondor uge na a qalsim moiyotqa oqnsiqa bati gaigai a ŋamyuwoq o yaq waiyeqnu. Deqa ni na iga aqaryaigwa kereamqa aqaryaige.” ");
INSERT INTO boj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Onaqa Yesus na minjej, “‘Kereamqa’ degsi merbaim. Tamo bei a e qa aqa areqalo siŋgilatqas di a kumbra kalil yqa kere.” ");
INSERT INTO boj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Onaqa tamo dena leleŋosiqa Yesus minjej, “E ni qa ijo areqalo siŋgilatonum. Ariya ijo areqalo olo gulbeibeqnu. Deqa ni na aqaryaibimqa e geregere ijo areqalo ni qa siŋgilatqai.” ");
INSERT INTO boj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Onaqa tamo uŋgasari gargekoba naŋgi gurgur ti bosib Yesus aqa areq di koroeqnabqa Yesus a naŋgi unjrsiqa mondor uge di ŋiriŋtosiq minjej, “Ni mondor uge. Ni na aŋgro di aqa dabkala getentonum. Ni aqa medabu dego getentonum. Deqa ni aŋgro di uratosim olo aqa jejamuq gilaim.” ");
INSERT INTO boj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Degsi minjnaqa mondor uge a leleŋkobaosiqa aŋgro di siŋgila na qunjimyosiqa a uratosiq ulaŋej. Ulaŋonaqa aŋgro di a moiyobulosiqa ŋeiesonaqa tamo qudei naŋgi unsib mareb, “A moiqo.” ");
INSERT INTO boj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Onaqa Yesus na aŋgro di aqa baŋ titonaqa a boleosiq tigelej. ");
INSERT INTO boj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Onaqa Yesus aqa aŋgro naŋgi aqa areq lumu bosib nenemyeb, “Iga kiyaqa mondor uge di wiyqa yonumqa keresaiigwo?” ");
INSERT INTO boj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Onaqa Yesus na minjrej, “Niŋgi mondor uge deqaji winjrqa osibqa Qotei pailyoqniy. Dena qujai niŋgi na mondor uge winjrib jaraiqab. Gam bei na sai.” ");
INSERT INTO boj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Onaqa Yesus na aqa aŋgro naŋgi olo joqsiqa koba na sawa di uratosib Galili sawa ambleq na walwelosib giloqneb. Tamo uŋgasari naŋgi a qa qalieaib deqa naŋgi uliosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Giloqnsibqa gamq di Yesus na aqa aŋgro naŋgi anjam endegsi minjrej, “E Tamo Aŋgro. Jeu tamo naŋgi na e ojsibqa tamo qudei naŋgo baŋq di atib lubib moiqai. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di geregere poinjrosai. Deqa naŋgi a olo nenemyqajqa ulaeb. ");
INSERT INTO boj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Onaqa Yesus aqa aŋgro naŋgi ti gilsib Kaperneam qureq di branteb. Brantosib tal bei gogetosib di sosibqa Yesus na aqa aŋgro naŋgi endegsi nenemnjrej, “Niŋgi gamq di anjam kiye na qotoqnab?” ");
INSERT INTO boj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Onaqa naŋgi mequmosib soqneb. Di kiyaqa? Naŋgi gamq di Yesus aqa aŋgro yai a naŋgi kalil buŋnjrsim ñam ti sqas deqa anjam na qotoqneb. ");
INSERT INTO boj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Onaqa Yesus a awoosiqa aqa aŋgro 12 naŋgi metnjrnaqa aqa areq bonabqa minjrej, “Tamo bei a ñam ti sqa marsimqa a mati tamo kalil naŋgo kaŋgal tamo soqnem. Osimqa a ñam ti sqas.” ");
INSERT INTO boj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesus a naŋgi degsi minjrsiqa aŋgro kiñala bei osiqa naŋgo ambleq di tigeltosiqa olo soqoŋyosiqa naŋgi minjrej, ");
INSERT INTO boj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tamo bei a ijo ñam qa are qalsimqa aŋgro kiñala endeqaji bei osim geregereiyqas di a e dego osim geregereibqas. Tamo a e osim geregereibqas di a na e segi geregereibqasai. A na ijo Abu e qariŋbej qaji di dego osim geregereiyqas.” ");
INSERT INTO boj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Onaqa Jon na Yesus minjej, “O Qalie Tamo, ni que. Iga tamo bei unem. A ino ñam na mondor uge naŋgi winjreqnaqa iga na unsim saidyem. Di kiyaqa? A iga koba na wauosaieqnu deqa.” ");
INSERT INTO boj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Onaqa Yesus na minjej, “Niŋgi a saidyaib. A ijo ñam na maŋwa bei babtqas di a urur olo e misiliŋbqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tamo naŋgi iga jeutgosaieqnub di naŋgi iga koba na wau qujai. ");
INSERT INTO boj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tamo bei a endegsi are qalqas, ‘Tamo di a Kristus dauryeqnu qaji tamo.’ A degsi are qalsimqa tamo di osim ya tigsim anaiyqas di Qotei na kamba awai bole yqas. Yimqa aqa awai bole di tamo bei na olo yaiyqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Osiqa Yesus a olo marej, “Tamo bei na aŋgro kiñala bei e qa aqa areqalo siŋgilateqnu qaji di osim uneq waiyqas di a kumbra tulaŋ ugedamu yqo. Iga tamo di ojsim meniŋ kobaquja osim sil na aqa kakroq di tontosim waiyim ya robuq aiqas di kere. ");
INSERT INTO boj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ino baŋ na ni titmosim uneq waimqa laqnimqa baŋ di gentosim waiy. Ni degye. Di kiyaqa? Ni baŋ geŋo sosimqa une bei yqasai di kere. Di ni ŋambile gaigai sqam. Ariya ni baŋ aiyel ti sosimqa une yqam di keresai. Di Qotei na ni ŋamyuwoq waimqas. Ŋamyuwo di mosoqasai. Gaigai yuoqnqas. ");
INSERT INTO boj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ino siŋga na ni titmosim uneq waimqa laqnimqa siŋga di gentosim waiy. Ni degye. Di kiyaqa? Ni siŋga geŋo sosimqa une bei yqasai di kere. Di ni ŋambile gaigai sqam. Ariya ni siŋga aiyel ti sosimqa une yqam di keresai. Di Qotei na ni ŋamyuwoq waimqas. ");
INSERT INTO boj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ino ŋamdamu na ni titmosim uneq waimqa laqnimqa ŋamdamu di otorosim waiy. Ni degye. Di kiyaqa? Ni ŋamdamu qujai ti sosimqa une bei yqasai di kere. Di Qotei a ino Mandor Koba sosim ni taqatmqas. Ariya ni ŋamdamu aiyel ti sosimqa une yqam di keresai. Di Qotei na ni ŋamyuwoq waimqas. ");
INSERT INTO boj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ŋamyuwo di mosoqasai. Gaigai yuoqnqas. Ŋamyuwoq di tamo naŋgo ambli bati gaigai sqab. Naŋgi moreŋqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Osiqa Yesus a olo marej, “Ijo aŋgro kalil naŋgi jaqatiŋ oqnsib sqab. Atraiyo iŋgiq di bar atoqnsib ŋamyuwo na koiteqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Bar a bole. A qajarara koba. Ariya bar aqa qajarara koboqas di iŋgi kiye na olo qajararatqas? Di keresai. Dego kere niŋgi bar bul sosibqa nuŋgo was naŋgi koba na geregere lawo na laqniy.” ");
INSERT INTO boj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Osiqa Yesus a sawa di uratosiqa Judia sawaq gilsiq Jordan ya taqal beiq di soqnej. A di sonaqa tamo uŋgasari gargekoba naŋgi bosib aqaq di koroonabqa aqa kumbra gaigai yoqnej qaji di olo dauryosiqa Qotei aqa anjam plaltosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Onaqa Farisi naŋgi olo Yesus aqa areq bosibqa a anjam bei grotimqa qusib naŋgi a ojqajqa deqa laŋa gisaŋyosib endegsib nenemyeb, “Tamo bei na aqa uŋa uratqa kere e? Gago dal anjam degsi unu e?” ");
INSERT INTO boj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Onaqa Yesus na kamba minjrej, “Moses a dal anjam kiyersi marej?” ");
INSERT INTO boj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Onaqa naŋgi na minjeb, “Moses a marej, ‘Tamo bei na aqa ŋauŋ uratqa osimqa pepa bei neŋgreŋyosim yosim di a uratqas.’” ");
INSERT INTO boj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Onaqa Yesus na minjrej, “Nuŋgo are geteŋgejunu deqa Moses a dal anjam degsi neŋgreŋyosiq niŋgi eŋgej. ");
INSERT INTO boj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ariya niŋgi quiy. ‘Tulaŋ nami Qotei a mandam ti iŋgi iŋgi kalil ti gereiyosiqa a tamo uŋa wo dego gereinjrej. ");
INSERT INTO boj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Deqa tamo bei na aqa ai abu naŋgi uratnjrsimqa aqa ŋauŋ wo beterosib jejamu qujaitosib sqab.’ Qotei aqa anjam di neŋgreŋq di unu. Deqa tamo uŋa wo naŋgi jejamu qujai sqab. Naŋgi olo jejamu aiyel sqasai. ");
INSERT INTO boj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Qotei na naŋgi aiyel turtnjrej deqa tamo bei na olo potnjraiq.” ");
INSERT INTO boj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Osiqa Yesus a tal bei gogetosiq di sonaqa aqa aŋgro naŋgi aqa areq bosib aqa anjam deqa nenemyeb. ");
INSERT INTO boj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nenemyonabqa minjrej, “Tamo bei na aqa ŋauŋ uratosim olo uŋa bei oqas di a na aqa ŋauŋ kumbra ugeq waiyqo. ");
INSERT INTO boj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uŋa a dego aqa gumbuluŋ uratosimqa olo tamo bei oqas di a na aqa gumbuluŋ kumbra ugeq waiyqo.” ");
INSERT INTO boj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Onaqa tamo uŋgasari qudei naŋgi naŋgo aŋgro du du joqsib Yesus na aqa baŋ naŋgo gateq di atetnjrqa marsib Yesus aqa areq beb. Beqnabqa Yesus aqa aŋgro naŋgi na saidnjrsib minjreb, “Nuŋgo aŋgro du du naŋgi joqsib endeq baib.” ");
INSERT INTO boj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Degsib saidnjrnabqa Yesus na aqa aŋgro naŋgi ŋiriŋtnjrsiqa minjrej, “Aŋgro du du naŋgi uratnjrib ijo areq beb. Naŋgi saidnjraib. Tamo uŋgasari naŋgi aŋgro du du deqaji bul sqab di Qotei a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","E bole merŋgwai. Tamo naŋgi aŋgro du du bul sqasai di Qotei na naŋgi osim taqatnjrqasai. Deqa a naŋgo Mandor Koba sqasai dego.” ");
INSERT INTO boj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Osiqa Yesus na aŋgro du du naŋgi di soqoŋnjrsiqa aqa baŋ naŋgo gateq di atetnjrsiqa naŋgi qa Qotei pailyej. ");
INSERT INTO boj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Osiqa Yesus a dena tigelosiqa gam dauryosiq gileqnaqa tamo bei urur ti aqa areq bosiqa aqa siŋgaq di siŋga pulutosiqa nenemyej, “O Qalie Tamo Bole, e kumbra bole kiye dauryosiy dena e ŋambile gaigai sqai?” ");
INSERT INTO boj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Onaqa Yesus na kamba minjej, “Ni kiyaqa e tamo bole qa merbonum? Qotei a segi qujai tamo bole. ");
INSERT INTO boj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ariya ni Qotei aqa dal anjam qalie. Anjam agiende. ‘Ni tamo bei qalsim moiyotaim. Ni tamo bei aqa uŋa jejamu ojetaim. Ni bajiŋaim. Ni tamo bei aqa jejamu laŋa gisaŋyaim. Ni was bei aqa iŋgi iŋgi laŋa gisaŋ na yaiyaim. Ni ino ai abu naŋgo sorgomq di geregere sosimqa naŋgo anjam dauryoqne.’” ");
INSERT INTO boj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Onaqa tamo dena olo Yesus minjej, “O Qalie Tamo, e aŋgro kiñala qa dal anjam kalil di dauryosim boqnem agi bini degsi unum.” ");
INSERT INTO boj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Onaqa Yesus a tamo di koqyosiqa qalaiyosiq minjej, “Ni dal anjam kalil di dauryosim keretonum. Ariya kumbra qujai ni keretosai. Deqa e ni mermqai. Ni gilsim ino iŋgi iŋgi kalil qariŋyosim silali osim tamo iŋgi iŋgi saiqoji naŋgi jeisim enjre. Degsim enjrsim bosim e daurbe. Yimqa bunuqna ni laŋ qureq di awai bole itqam.” ");
INSERT INTO boj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesus na tamo di degsi minjnaq qusiqa are tulaŋ gulbekobaiyej. A iŋgi iŋgi koba ti soqnej deqa ulatamu ugeiyonaqa ulaŋej. ");
INSERT INTO boj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Onaqa Yesus na aqa aŋgro naŋgi koqnjrsiqa endegsi minjrej, “Tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa baŋgi koba.” ");
INSERT INTO boj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di qusibqa tulaŋ prugeb. Onaqa Yesus na olo minjrej, “O ijo aŋgro, niŋgi quiy. Tamo uŋgasari naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba. ");
INSERT INTO boj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel a yumba miligiq gilqajqa baŋgi koba. Dego kere tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba.” ");
INSERT INTO boj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di qusibqa olo tulaŋ prugugetosib segi segi maroqneb, “Yesus a anjam degsi mergwo deqa tamo yai naŋgi Qotei na eleŋamqa naŋgi ŋambile gaigai sqa kere?” ");
INSERT INTO boj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Onaqa Yesus a naŋgi koqnjrsiqa minjrej, “Tamo naŋgi segi ŋambile sqa keresai. Ariya Qotei na naŋgi eleŋqa kere. Di kiyaqa? Qotei a kumbra kalil yqa kere.” ");
INSERT INTO boj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Onaqa Pita na Yesus minjej, “O Tamo Koba, ni une. Iga gago iŋgi iŋgi kalil uratosim ni daurmeqnum.” ");
INSERT INTO boj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Onaqa Yesus na minjrej, “E bole merŋgwai. Tamo naŋgi e qa ti ijo anjam bole qa ti are qaloqnsib naŋgo segi tal, naŋgo was naŋgi, naŋgo jaja naŋgi, naŋgo ai abu naŋgi, naŋgo aŋgro naŋgi ti naŋgo wau kalil dego uratnjrsib e daurbqab di Qotei na olo tal, was, jaja, ai, aŋgro, wau gargekoba naŋgi enjrqas. Yimqa jeu tamo naŋgi dego bosib naŋgi gulbe enjroqnqab. Ariya mondoŋ naŋgi ŋambile gaigai sqab. ");
INSERT INTO boj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Deqa niŋgi quiy. Tamo gargekoba bini ñam koba ti unub qaji naŋgi mondoŋ ñam saiqoji sqab. Ariya tamo gargekoba bini ñam saiqoji unub qaji naŋgi mondoŋ ñam koba ti sqab.” ");
INSERT INTO boj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa koba na gam dauryosib Jerusalem aiyoqneb. Aiyoqnsibqa Yesus a namoeqnaqa aqa aŋgro naŋgi bunuqna dauryoqnsibqa are toŋtoŋnjroqnej. Tamo uŋgasari qudei gam na dauryoqneb qaji naŋgi dego ulaosib aiyoqneb. Onaqa Yesus na aqa aŋgro 12 naŋgi segitnjrsiqa a une kiye turqas deqa naŋgi sainjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","A na naŋgi endegsi minjrej, “Niŋgi quiy. E Tamo Aŋgro. Iga Jerusalem aiyeqnum. Dia tamo qudei na e ojsib dal anjam qalie tamo naŋgi ti atra tamo kokba ti naŋgo baŋq di e atqab. Yimqa naŋgi na ijo jejamu laŋa gisaŋyosib merbqab, ‘Ni une ti. Deqa ni moiqam.’ Naŋgi e degsib gisaŋbosib e olo ojsib tamo naŋgi Qotei qaliesai qaji naŋgo baŋq di e atqab. Yimqa naŋgi na e misiliŋboqnsib miselboqnsib bu toqoŋ na e kumbaiŋboqnqab. Osib e ŋamburbasq di lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Onaqa Sebedi aqa ŋiri aiyel Jems Jon wo naŋgi Yesus aqa areq bosib minjeb, “O Qalie Tamo, aqo aiyel anjam bei mermonam ni gago anjam dauryqa kere kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Onaqa Yesus na naŋgi aiyel nenemnjrej, “E niŋgi kiyerŋgwajqa deqa niŋgi ijoq bonub?” ");
INSERT INTO boj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Onaqa naŋgi aiyel na Yesus minjeb, “Mondoŋ ni riaŋ koba ti laŋ goge na bosim gago Mandor Koba sosimqa bati deqa ni marimqa aqo aiyel ino baŋ woq ino baŋ qonaŋq di awoqom.” ");
INSERT INTO boj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Onaqa Yesus na kamba minjrej, “Anjam niŋgi merbonub di aqa utru niŋgi geregere poiŋgosai. E jaqatiŋ koba oqai. Jaqatiŋ di ya uge uyo bul. E gulbe koba dego oqai. Gulbe di tamo naŋgi ya tuqtnjro bul. Jaqatiŋ ti gulbe ti e oqai di niŋgi aiyel dego oqa kere e?” ");
INSERT INTO boj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Onaqa naŋgi na minjeb, “Od, aqo aiyel oqa kere.” Onaqa Yesus na olo naŋgi aiyel minjrej, “Bole, jaqatiŋ e oqai di niŋgi dego oqab. Gulbe e oqai di niŋgi dego oqab. ");
INSERT INTO boj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ariya tamo yai naŋgi ijo baŋ woq ijo baŋ qonaŋq di awoqab di e na marqa keresai. Di ijo wau sai. Tamo naŋgi Qotei na giltnjrej qaji naŋgi segi ijo baŋ woq ijo baŋ qonaŋq di awoqab.” ");
INSERT INTO boj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesus aqa aŋgro 10 naŋgo ŋamdamuq di Jems Jon wo naŋgi na anjam di Yesus minjeb deqa qusib naŋgi aiyel qa ŋiriŋeb. ");
INSERT INTO boj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Onaqa Yesus na aqa aŋgro 10 naŋgi metnjrnaqa aqa areq bonabqa minjrej, “Niŋgi qalie, mandor kokba sawa sawa kalil taqateqnub qaji naŋgi naŋgo segi ñam soqtoqnsib tamo uŋgasari naŋgi ŋiriŋ na taqatnjreqnub. ");
INSERT INTO boj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ariya kumbra di nuŋgoq di saiq. Nuŋgo ambleq di aŋgro bei a ñam ti sqa marsimqa a mati nuŋgo wau tamo soqnem. Osim a ñam ti sqas. ");
INSERT INTO boj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nuŋgo ambleq di aŋgro bei a tamo kobaquja sqa marsimqa a mati nuŋgo kaŋgal tamo soqnem. Osimqa a olo tamo kobaqujaqas. ");
INSERT INTO boj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","E Tamo Aŋgro. Niŋgi ijo kumbra qalieosib degsib dauryoqniy. Ijo kumbra agiende. E na tamo uŋgasari naŋgi wauetnjreqnum. E deqa bem. Tamo uŋgasari naŋgi e wauetbqajqa e deqa bosai. Bunuqna e ijo segi ŋambile uratosiy tamo uŋgasari garkekoba naŋgi eleŋqai.” ");
INSERT INTO boj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa koba na walwelosib aisib Jeriko qureq di branteb. Brantosib Jeriko qure ambleq na walwelosib olo Jeriko uratosib aiyeqnabqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus dauryosib koba na aiyoqneb. Aiyeqnabqa tamo bei ŋam qandimyej qaji aqa ñam Bartimeus a gam qalaq di awesosiqa tamo uŋgasari naŋgi silali qa ŋilnjroqnej. Bartimeus a Timeus aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A gam qalaq di awesosiqa anjam endegsi quej, “Yesus Nasaret qaji a beqnu.” A degsi qusiqa tulaŋ leleŋosiq marej, “O Yesus, Devit aqa Ŋiri, ni e qa dulame.” ");
INSERT INTO boj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Onaqa tamo uŋgasari gargekoba Yesus dauryosib aiyoqneb qaji naŋgi na Bartimeus ŋiriŋtosib minjeb, “Ni leleŋkobaaim. Kiri.” Degsib minjeqnabqa a naŋgo anjam quetnjrosai. A olo tulaŋ leleŋoqnsiq Yesus minjoqnej, “O Devit aqa Ŋiri, ni e qa dulame.” ");
INSERT INTO boj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Onaqa Yesus a tigelosiqa tamo uŋgasari naŋgi minjrej, “Tamo di metib ijo areq bem.” Onaqa naŋgi na tamo ŋam qandimyej qaji di metosib minjeb, “Ni are siŋgilat. Ni tigel. Yesus a ni metmeqnu.” ");
INSERT INTO boj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Degsib minjnab qusiqa aqa gara jugo taqal atsiqa urur tigelosiqa Yesus aqa areq bej. ");
INSERT INTO boj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bonaqa Yesus na nenemyej, “E ni kiyermqajqa deqa ni e qa leleŋoqnam?” Onaqa minjej, “O Tamo Koba, e olo ŋam poibim sawa unqajqa deqa e ni qa leleŋoqnam.” ");
INSERT INTO boj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Onaqa Yesus na minjej, “Ni e qa ino areqalo siŋgilatonum deqa e ni boletmqai. Deqa ino ŋamdamu olo poimimqa ni aiye.” Degsi minjnaqa aqa ŋamdamu poiyonaqa sawa unsiqa tigelosiq Yesus dauryosiq aiyej. ");
INSERT INTO boj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Onaqa Yesus aqa aŋgro naŋgi koba na walwelosib aisib Jerusalem jojomyosib Betfage qure ti Betani qure ti dia branteb. Qure aiyel di agi Oliv mana utruq di unu. Di brantosib Yesus na aqa aŋgro aiyel qariŋnjrsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Niŋgi aisib qure bei jojom di unu di brantosib donki bei tontonub unu di unqab. Donki di bunuj tamo bei nami aqa quraq di awoosaioqnej qaji. Niŋgi donki di unsib sil palontosib titosib osi boiy. ");
INSERT INTO boj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Niŋgi sil palontoqnibqa tamo bei na nenemŋgwas kiyo, ‘Niŋgi kiyaqa donki aqa sil palonteqnub?’ Degsi nenemŋgimqa niŋgi na minjiy, ‘Tamo Koba a wau ti deqa donki qa mergwo.’ Yimqa a na donki qariŋyim ijoq bqas.” ");
INSERT INTO boj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Yesus a naŋgi aiyel degsi minjrsiq qariŋnjrnaqa aisib gam jojomq di donki uneb. Donki di tal meq di tontonab sonaq uneb. Unsib sil palonteqnabqa tamo qudei gamq di tigelesoqneb qaji naŋgi na naŋgi aiyel nenemnjreb, “Niŋgi kiyaqa donki aqa sil palonteqnub?” ");
INSERT INTO boj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Onaqa naŋgi aiyel na anjam Yesus a minjrej qaji di tamo naŋgi di minjrnab odnjrnabqa donki di osib Yesus aqa areq osi beb. ");
INSERT INTO boj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bosib naŋgo aiyel gara jugo piqtosib donki aqa quraq di tunabqa Yesus a segi donki gogetosiqa quraq di awoej. ");
INSERT INTO boj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Awoonaqa donki a walwelosi aiyeqnaqa tamo uŋgasari gargekoba naŋgi beleŋosib naŋgo segi gara jugo piqteleŋosib gamq di tueleŋoqneb. Tamo qudei naŋgi nañuq dena ŋam baŋga giŋgeŋyosibqa osi bosib di dego gamq di tueleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Onaqa Yesus a donki quraq di awoosiq walweleqnaqa tamo uŋgasari namooqneb qaji naŋgi ti bunuoqneb qaji naŋgi ti tulaŋ leleŋoqnsibqa maroqneb, “Iga ni qa tulaŋ areboleboleigeqnu. Ni Tamo Koba aqa ñam na bonum deqa a ni tulaŋ geregereimeqnu. ");
INSERT INTO boj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ni gago moma Devit aqa wau osimqa ni kamba gago Mandor Koba sosim iga taqatgwajqa bonum. Deqa iga Qotei laŋ goge di unu qaji aqa ñam soqtoqnqom!” Tamo uŋgasari naŋgi degoqnsib leleŋ ti Yesus dauryoqneb. ");
INSERT INTO boj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Onaqa Yesus a walwelosi aisiq Jerusalem di brantosiqa atra tal koba miligiq gilej. Gilsiq iŋgi iŋgi kalil atra tal miligiq di soqnej qaji di koqyoqnej. Osiq bilaqtonaqa a olo atra tal koba uratosiq aqa segi aŋgro 12 naŋgi joqsiqa koba na puluosib Betani qureq gileb. ");
INSERT INTO boj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nebeonaqa Yesus aqa aŋgro naŋgi ti olo tigelosib Betani qure uratosib aiyeb. Naŋgi aiyoqnsibqa gamq di Yesus a mamyej. ");
INSERT INTO boj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Onaqa a isaq na ŋam atsiqa qura baŋga ti sonaq unsiqa aqa gei unqajqa utruq gilej. Gilsiq unej qura gei bei saiqoji. Geitqa bati sai deqa baŋga segi sonab unej. ");
INSERT INTO boj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Unsiqa qura di minjej, “Ni olo bunu geitqasai. Tamo bei a bosim ino gei bei oqasai.” Degsi minjnaqa aqa aŋgro naŋgi queb. ");
INSERT INTO boj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Onaqa Yesus aqa aŋgro naŋgi ti walwelosi aisib Jerusalem di branteb. Brantosib Yesus a atra tal koba miligiq gilsiqa ŋam atej di tamo uŋgasari gargekoba naŋgi iŋgi iŋgi qariŋyoqnsibqa dena silali eqnab unjrsiqa naŋgi winjrnaq jaraiyeb. Tamo qudei naŋgi silali piloqneb. Qudei naŋgi binoŋ qariŋyoqnsib dena silali oqneb. Deqa Yesus a naŋgo jar ti jaram ti bilbelyosiqa naŋgi dego winjrnaq jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Osiqa tamo uŋgasari atra tal miligiq di iŋgi iŋgi osi laqneb qaji naŋgi dego saidnjrsiqa winjrnaq jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naŋgi kalil jaraiyeqnabqa Yesus na minjrej, “Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Ijo tal endi tamo uŋgasari kalil naŋgo pailyqajqa tal.’ Qotei aqa anjam degsi unu. Ariya niŋgi na olo tal endi ugetonubqa a bajiŋ tamo naŋgo tal bulqo.” ");
INSERT INTO boj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Onaqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti Yesus aqa anjam di qusibqa naŋgi a qa ulaosib a qalib moiqajqa gam ŋamoqneb. Di kiyaqa? Tamo uŋgasari kalil naŋgi Yesus aqa anjam quqwajqa tulaŋ arearetnjroqnej deqa. ");
INSERT INTO boj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ariya bilaqtonaqa Yesus aqa aŋgro naŋgi koba na olo Jerusalem uratosib gileb. ");
INSERT INTO boj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nebeonaqa Yesus aqa aŋgro naŋgi ti olo tigelosib gam dauryosib aiyoqnsib qura di olo uneb utru ti kalil laosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Onaqa Pita a Yesus aqa anjam nami qura minjej qaji deqa olo are qalsiqa Yesus minjej, “O Tamo Koba, ni unime. Qura ni ya ŋiriŋtem qaji agi laosiq moiqo.” ");
INSERT INTO boj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi Qotei qa nuŋgo areqalo siŋgilatiy. ");
INSERT INTO boj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","E bole merŋgwai. Tamo bei a areqalo aiyeltqasai di a mana kobaquja endi minjqas, ‘Ni tigelosim yuwalq aiye.’ Aqa are miligiq di a endegsi are qalqas, ‘Bole, mana di a ijo anjam dauryqas.’ Degsi are qalqas di mana a aqa anjam dauryosim tigelosim yuwalq aiqas. ");
INSERT INTO boj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Deqa niŋgi quiy. Niŋgi iŋgi bei qa Qotei pailyqa osibqa endegsib are qaliy, ‘Iŋgi di Qotei na egwas.’ Degsib are qalsib pailyqab di a na eŋgwas. ");
INSERT INTO boj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Deqa niŋgi Qotei pailyqa osibqa tamo bei qa anjam soqnimqa niŋgi na aqa une kobotosib Qotei pailyiy. Yimqa nuŋgo Abu laŋ qureq di unu qaji a kamba nuŋgo une kalil kobotetŋgwas. ");
INSERT INTO boj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ariya niŋgi tamo di aqa une kobotetqasai di nuŋgo Abu laŋ qureq di unu qaji a dego nuŋgo une kobotetŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Osiqa Yesus a aqa aŋgro naŋgi koba na walwelosib aisib olo Jerusalem di branteb. Brantosib Yesus a atra tal koba miligiq gilsiq dia walweleqnaqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti Juda gate naŋgi ti Yesus aqa areq bosib nenemyeb, ");
INSERT INTO boj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ni iga merge. Ni siŋgila qabe na osimqa kumbra endi yeqnum? Yai na ni qariŋmej deqa ni bosim wau endi yeqnum?” ");
INSERT INTO boj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Onaqa Yesus na minjrej, “E kamba anjam bei niŋgi nenemŋgwai. Nenemŋgitqa niŋgi e merbibqa e yai na qariŋbonaq bosim wau endi yeqnum di ubtosiy merŋgwai. ");
INSERT INTO boj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Niŋgi na merbiy. Yai na Jon qariŋyonaqa bosiqa tamo uŋgasari naŋgi yansnjroqnej? Qotei na kiyo? Tamo bei na kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Onaqa naŋgi Yesus aqa anjam di qusibqa segi segi qairosib mareb, “Iga Yesus minjqom, ‘Qotei na Jon qariŋyej,’ degsi minjqom di a iga mergwas, ‘Kiyaqa niŋgi Jon aqa anjam quetosai?’ ");
INSERT INTO boj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ariya iga minjqom, ‘Tamo bei na Jon qariŋyej,’ degsi minjqom di dego keresai.” Naŋgi tamo uŋgasari naŋgi ulainjrsib deqa degsib qaireb. Di kiyaqa? Tamo uŋgasari naŋgi maroqneb, “Jon a Qotei aqa medabu o qaji tamo bole.” ");
INSERT INTO boj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Naŋgi degsib qairosib olo Yesus minjeb, “Yai na kiyo Jon qariŋyej di iga qaliesai.” Onaqa Yesus na kamba minjrej, “Niŋgi degsib merbonub deqa e dego yai na qariŋbonaq bosim wau endi yeqnum di niŋgi merŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus na Juda tamo kokba naŋgi degsi minjrsiqa olo yawo anjam bei endegsi minjrej, “Tamo bei a tigelosiqa aqa wauq gilej. Gilsiqa wain sil yageleŋosiqa jeŋ qosej. Qoso koboonaqa meniŋ qura gogeq di tabir kuru bul gereiyej. Wain sil geitimqa wain gei koroiyosib paraparaiyosib aqa ya dia bilentqajqa deqa gereiyej. Osiqa wauq di tal atsiqa wau taqato tamo qudei naŋgo baŋq di aqa wau uratetnjrsiqa sawa isaq gilsiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sonaqa wain gei melionaqa a na aqa kaŋgal tamo bei qariŋyonaqa wau taqato tamo naŋgoq aisiqa minjrej, ‘Wau lanja na e qariŋbqo bonum. Deqa niŋgi wain gei ebibqa e na osi gilqai.’ ");
INSERT INTO boj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Degsi minjrnaqa naŋgi na a ojsib qalougetosib wiyonab laŋa puluosiq gilej. ");
INSERT INTO boj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gilnaqa wau lanja na olo kaŋgal tamo bei qariŋyonaq ainaqa a dego ojsib aqa gate paratetosib tulaŋ ugeugeiyeb. ");
INSERT INTO boj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Onaqa wau lanja na olo kaŋgal tamo bei qariŋyonaq ainaqa a dego qalougetosib moiyoteb. Olo kaŋgal tamo gargekoba naŋgi qariŋnjreqnaqa aiyeqnab qudei ñumougetoqneb. Qudei moiyotnjroqneb. ");
INSERT INTO boj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Onaqa wau lanja a endegsi are qalej, ‘Ijo segi aŋgro qujai e na tulaŋ qalaqalaiyeqnum qaji di qariŋyit aiqas di naŋgi a qalqasai. Naŋgi aqa anjam quetqab.’ ");
INSERT INTO boj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Degsi are qalsiqa aqa segi ŋiri qariŋyonaq aiyej. Aiyeqnaqa wau taqato tamo naŋgi a unsibqa segi segi qairosib mareb, ‘Tamo a bqo endi wau lanja aqa segi ŋiri. A na aqa abu aqa iŋgi iŋgi kalil oqas. Deqa iga a qalsim moiyotosimqa wau endi iga na oqom.’ ");
INSERT INTO boj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Degsib marsibqa wau lanja aqa ŋiri ojsib qalnab moinaqa aqa jejamu osib wau qalaq di waiyeb. ");
INSERT INTO boj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Deqa niŋgi kiyersib are qalonub? Wau lanja a bosimqa wau taqato tamo uge naŋgi di kiyernjrqas? E niŋgi merŋgwai. A bosim naŋgi ñumsim moiyotnjrqas. Osim aqa wau di olo yainjrsim tamo qudei naŋgo baŋq di uratetnjrimqa naŋgi na kamba taqatesqab. ");
INSERT INTO boj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Qotei aqa anjam bei unu. Niŋgi anjam di nami sisiyosai kiyo? Anjam agiende, ‘Tal gereiyo qaji tamo naŋgi na tal ai arqsibqa uge qa marsib taqal waiyeb. Onaqa tal ai di Qotei na olo osiq tumaq di tigeltej unu. Tal ai di tal siŋgilatqajqa deqa tigeltej. ");
INSERT INTO boj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tamo Koba a segi na tal ai di tigeltej deqa iga unsim mareqnum, “Tal ai di tulaŋ bolequja.” ’” ");
INSERT INTO boj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Onaqa Juda tamo kokba naŋgi yawo anjam di qusib endegsib qalieeb, Yesus a yawo anjam dena naŋgo jejamuq di une qametnjrej. Naŋgi degsib qalieosib deqa Yesus ojqa mareb. Ariya naŋgi tamo uŋgasari naŋgi ulainjrsib deqa naŋgi Yesus ojqa uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","14","Juda tamo kokba naŋgi jaraiyosib Farisi naŋgi ti Herot aqa wau tamo qudei ti naŋgoq aisib minjreb, “Niŋgi Yesus aqaq gilsib anjam bei nenemyibqa a anjam grotim iga qusim ojqom.” Degsib minjrsib naŋgi qariŋnjrnab Yesus aqa areq gilsib minjeb, “O Qalie Tamo, iga qalie, ni anjam bole maro qaji tamo. Ni anjam bole segi tamo uŋgasari naŋgi minjroqnsim Qotei aqa kumbra osornjreqnum. Ni tamo bei ulaiyosaieqnum. Ni tamo ñam ti naŋgi anjam bei minjroqnsim olo tamo ñam saiqoji naŋgi anjam bei minjrosaieqnum. Ni anjam qujai tamo kalil naŋgi minjreqnum. Deqa ni iga merge. Iga Sisar takis yqom e? Yqasai e? Ni kiyersi are qalonum?” ");
INSERT INTO boj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Onaqa Yesus a naŋgo gisaŋ anjam di poiyonaqa minjrej, “Kiyaqa niŋgi e anjam bei grotitqa qusib e ojqajqa deqa gisaŋbeqnub? Meniŋ silali bei osi boiy. Osbab e unqai.” ");
INSERT INTO boj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Degsi minjrnaqa naŋgi meniŋ silali bei osi bosib osoryonab unsiqa minjrej, “Meniŋ silali quraq endi tamo yai aqa ulatamu ti ñam ti unu?” Onaqa naŋgi na minjeb, “Di Sisar aqa.” ");
INSERT INTO boj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Onaqa a na minjrej, “Deqa Sisar aqa iŋgi iŋgi a qa olo yiy. Qotei aqa iŋgi iŋgi a qa olo yiy.” Onaqa naŋgi Yesus aqa anjam di qusibqa tulaŋ prugugeteb. ");
INSERT INTO boj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Onaqa bati deqa Sadyusi tamo qudei naŋgi Yesus aqa areq beb. Sadyusi naŋgi mareqnub, “Tamo moreŋo qaji naŋgi olo subq na tigelqasai.” Deqa naŋgi bosib Yesus endegsib minjeb, ");
INSERT INTO boj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“O Qalie Tamo, ni que. Moses a nami dal anjam endegsi neŋgreŋyej, ‘Tamo bei a moiyimqa aqa ŋauŋ aŋgro saiqoji soqnimqa aqa was bei na olo uŋa qobul di osim aqa was moiyej qaji aqa aŋgro ŋambabtetqas.’ Moses a nami dal anjam degsi neŋgreŋyej. ");
INSERT INTO boj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Deqa ni que. Was 7 naŋgi soqneb. Naŋgo was matu a uŋa osiqa moiyej. A aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Onaqa aqa was yala na olo uŋa qujai di osiqa a dego moiyej. A aŋgro saiqoji. Onaqa aqa was yala na olo uŋa di ej. Osiqa a dego moiyej. A aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Was 7 kalil naŋgi uŋa qujai di osib moreŋeb. Naŋgi aŋgro saiqoji. Naŋgi kalil moreŋonabqa ariya bunuqna uŋa di a dego moiyej. ");
INSERT INTO boj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Deqa ni iga merge. Mondoŋ subq na tigelo batiamqa tamo kalil naŋgi subq na tigelabqa uŋa di a yai aqa ŋauŋ tiŋtiŋ sqas? Ni qalie, was 7 kalil naŋgi uŋa qujai di eb.” ");
INSERT INTO boj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Onaqa Yesus na minjrej, “Qotei aqa anjam neŋgreŋq di unu qaji di aqa damu niŋgi poiŋgosai e? Qotei aqa siŋgila dego niŋgi poiŋgosai e? Od, niŋgi poiŋgosai. Utru deqa niŋgi anjam grotonub. Grotosib agi nenembonub. ");
INSERT INTO boj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mondoŋ tamo uŋgasari naŋgi subq na tigelosibqa naŋgi uŋatqasai. Naŋgi tamotqasai. Naŋgi laŋ aŋgro bul laŋa sqab. ");
INSERT INTO boj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Niŋgi quiy. Tamo naŋgi moisib olo subq na tigelqab anjam di aqa utru Moses a nami babtosiq neŋgreŋyej. Di niŋgi sisiyosai kiyo? Ŋam mariŋ miligiq di puloŋeqnaqa Qotei a ŋam puloŋq di sosiqa Moses metosiq endegsi minjej, ‘E Abraham aqa Qotei. E Aisak aqa Qotei. E Jekop aqa Qotei.’ ");
INSERT INTO boj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Qotei na Moses degsi minjej deqa iga qalieonum, Qotei a tamo moreŋo qaji naŋgo Qotei sai. A tamo ŋambile so qaji naŋgo Qotei. Anjam di niŋgi tulaŋ grotonub!” ");
INSERT INTO boj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Onaqa dal anjam qalie tamo bei a bosiqa Yesus a Sadyusi naŋgi ti anjam na qoteqnab unjrej. Yesus a geregere Sadyusi naŋgi kamba anjam minjrnaqa qusiqa Yesus nenemyej, “Qotei aqa dal anjam kiye a segi qujai tulaŋ bolequja? Dal anjam kiye a dal anjam kalil buŋnjrejunu?” ");
INSERT INTO boj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Onaqa Yesus na minjej, “Dal anjam tulaŋ bolequja agi mermqai. ‘O Israel niŋgi quiy. Gago Tamo Koba Qotei a segi qujai Tamo Koba. ");
INSERT INTO boj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Deqa ni ino Tamo Koba Qotei a tulaŋ qalaqalaiyime. Qalaqalaiyosim ino are miligi ti ino qunuŋ ti ino areqalo ti ino siŋgila ti kalil a yekritime.’ Dal anjam di a segi qujai tulaŋ bolequja. A na dal anjam kalil buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ariya dal anjam deqaji bei dego mermqai. Dal anjam agiende. ‘Ni ino segi jejamu gereiyeqnum dego kere ino was naŋgi degsim geregereinjroqnime.’ Dal anjam boledamu aiyel agi e na mermonum. Dal anjam deqaji bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Onaqa dal anjam qalie tamo dena kamba Yesus minjej, “O Qalie Tamo, ni bole maronum. Qotei a segi qujai. Qotei bei saiqoji. ");
INSERT INTO boj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iga a tulaŋ qalaqalaiyosim gago are miligi ti gago powo ti gago siŋgila ti kalil a yekritqom di kumbra bolequja. Iga gago segi jejamu gereiyeqnum dego kere gago was naŋgi degsim geregereinjroqnqom di dego kumbra bolequja. Dal anjam aiyel di tulaŋ boledamu. Iga iŋgi iŋgi Qotei atraiyqom di laŋa kiñala. Iga iŋgi bei ŋamyuwo na koitosim Qotei atraiyqom di dego laŋa kiñala. Ariya iga dal anjam aiyel di dauryqom di tulaŋ bolequja.” ");
INSERT INTO boj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dal anjam qalie tamo di a tulaŋ poiyonaqa anjam degsi marnaqa Yesus a qusiqa minjej, “Ni anjam tulaŋ boledamu maronum. Deqa sokiñala Qotei na ni taqatmosim ino Mandor Koba sqas.” Onaqa tamo uŋgasari naŋgi olo anjam bei Yesus nenemyqajqa ulaeb. ");
INSERT INTO boj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Onaqa Yesus a atra tal koba miligiq di sosiqa Qotei aqa anjam plaltoqnej. Osiqa tamo uŋgasari naŋgi anjam bei endegsi minjrej, “Dal anjam qalie tamo naŋgi kiyaqa mareqnub, ‘Kristus a Devit aqa ŋiri’? ");
INSERT INTO boj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit a nami marej, ‘Kristus a ijo Tamo Koba.’ Agi Mondor Bole na Devit aqa medabu siŋgilatetonaqa a endegsi marej, ‘Tamo Koba a na ijo Tamo Koba minjej, “Ni ijo baŋ woq endi awo. Awesoqnimqa e ino jeu tamo kalil naŋgi eleŋosiy ino sorgomq di atitqa ni na naŋgi taqatnjroqnqam.” ’ ");
INSERT INTO boj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Niŋgi uniy. Devit a marej, ‘Kristus a ijo Tamo Koba.’ Deqa Kristus a kiyersim Devit aqa ŋiri sqas?” Tamo uŋgasari gargekoba naŋgi sosibqa Yesus aqa anjam quqwajqa tulaŋ arearetnjroqnej. ");
INSERT INTO boj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus a anjam bei endegsi plaltosiq minjrej, “Niŋgi dal anjam qalie tamo naŋgo kumbra uge geregere tenemtoqniy. Naŋgi koro sawaq di tamo uŋgasari naŋgi na naŋgo ñam soqtetnjrsib baŋ ojetnjrqajqa deqa gara olekokba jugoqnsib laqnub. ");
INSERT INTO boj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Naŋgi Qotei tal miligiq di, goiyo kokbaq di sosibqa tamo ñam ti naŋgo awo jaramq di awooqnqajqa deqa areboleboleinjreqnu. ");
INSERT INTO boj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naŋgi uŋa qobul naŋgi gisaŋnjroqnsibqa naŋgo tal ti iŋgi iŋgi ti laŋa yainjreqnub. Osib tamo uŋgasari naŋgi na unjrsib naŋgo ñam soqtetnjrqajqa deqa pailyo olekokba yeqnub. Deqa mondoŋ Qotei na naŋgi awai tulaŋ ugedamu enjrqas.” ");
INSERT INTO boj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Osiqa Yesus a atra tal miligiq di sosiqa silali ato qaji kulum jojomq di awoej. Awoosiqa ŋam atej di tamo uŋgasari naŋgi boqnsib silali ateqnab unjroqnej. Ñoro tamo gargekoba naŋgi boqnsib silali tulaŋ kokba atoqneb. ");
INSERT INTO boj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Onaqa uŋa qobul bei ñoro tulaŋ saiqoji a dego bosiqa meniŋ silali kiñilala aiyel segi atej. ");
INSERT INTO boj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Atnaqa Yesus na unsiqa aqa aŋgro naŋgi metnjrnaqa aqa areq bonabqa minjrej, “E bole merŋgwai. Uŋa qobul endi a ñoro tulaŋ saiqoji. Deqa a na ñoro tamo kalil naŋgi buŋnjrsiqa silali kobaquja atqo. ");
INSERT INTO boj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ñoro tamo naŋgi silali koba ejunub. Naŋgi oto kiñala segi ateqnub. Ariya uŋa qobul endi a silali tulaŋ sai bole sai. Aqa meniŋ silali kiñilala aiyel segi naj agi atekritqo.” ");
INSERT INTO boj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa koba na atra tal koba uratosib giloqnsibqa aqa aŋgro bei na minjej, “O Qalie Tamo, ni unime. Atra tal endi tulaŋ bolequja. Atra tal walato qaji meniŋ di tulaŋ boledamu!” ");
INSERT INTO boj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Onaqa Yesus na kamba minjej, “Atra tal ni unonum endi bunuqna jeu tamo naŋgi na bosib tulaŋ niñaqyosib aqa meniŋ kalil paraparainjrsibqa taqal breinjrqab. Yimqa meniŋ bei meniŋ bei aqa quraq di sqasai. Meniŋ kalil segi segiqab.” ");
INSERT INTO boj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Osiqa Yesus a Oliv manaq oqsiq atra tal areiyosiq awesonaqa Pita na Jems na Jon na naŋgi qalub Yesus aqa areq bosib lumu nenemyeb, ");
INSERT INTO boj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ni iga merge. Bati gembu jeu tamo naŋgi bosib atra tal endi niñaqyqab? Niñaqyqa osibqa kumbra kiye namoqna brantim iga unsim poigwas, ‘Bati di jojomqo’?” ");
INSERT INTO boj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Onaqa Yesus na minjrej, “Niŋgi geregere ŋam atoqniy. Tamo qudei na niŋgi gisaŋgo uge. ");
INSERT INTO boj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bunuqna gisaŋ tamo gargekoba naŋgi ijo ñam na bosib tamo uŋgasari naŋgi minjroqnqab, ‘E Kristus.’ Degsib tamo uŋgasari tulaŋ gargekoba naŋgi gisa gisaŋnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Bunuqna sawa bei bei qaji naŋgi aŋ na qotokobaoqnqab. Niŋgi deqa qusib ulaaib. Qotei a nami marej, ‘Kumbra di brantqas.’ Deqa brantem. Ariya kumbra di brantimqa diŋo bati urur brantqasai. Soboleiyosim brantqas. ");
INSERT INTO boj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bati deqa sawa bei ti sawa bei ti qotoqnqab. Mandor qudei naŋgi tigeloqnsibqa mandor qudei naŋgi qoto itnjroqnqab. Sawa bei beiq di mimiŋ kokba ti mam ti iŋgi saio bati branteleŋqas. Kumbra kalil di uŋa aŋgrotqa osiqa mati jaqatiŋ kiñala eqnu dego kere. ");
INSERT INTO boj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Deqa niŋgi geregere ŋam atoqniy. Kumbra kalil di brantosaisoqnimqa Juda naŋgi na bosib niŋgi ojeleŋosib anjam pegiyo talq di niŋgi tigeltŋgoqnqab. Osib naŋgo Qotei tal miligiq di niŋgi kumbaiŋgoqnsib olo niŋgi joqoqnsib Rom naŋgo gate ti naŋgo mandor ti naŋgo ulatamuq di niŋgi tigeltŋgoqnqab. Yimqa niŋgi ijo anjam bole palontoqnsib naŋgi minjroqnqab. ");
INSERT INTO boj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sawa sawa kalilq di dego niŋgi ijo anjam bole ubtosib mare mare laqnibqa tamo uŋgasari naŋgi quoqnqab. Amqa diŋo bati brantqas. ");
INSERT INTO boj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naŋgi na niŋgi ojoqnsib anjam pegiyo talq di tigeltŋgoqnibqa niŋgi endegsib are qalaib, ‘Iga na kamba anjam kiyersi minjrqom?’ Niŋgi degaib. Bati deqa Qotei na powo eŋgoqnimqa niŋgi kamba anjam minjroqnqab. Niŋgi segi na anjam minjrqasai. Mondor Bole na nuŋgo medabu siŋgilatetŋgim niŋgi anjam marqab. ");
INSERT INTO boj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bati deqa kumbra uge endeqaji brantqas. Tamo qudei na naŋgo segi was naŋgi ojoqnsib qaja tamo naŋgo baŋq di atoqnibqa naŋgi na naŋgi ñumoqnib moreŋoqnqab. Tamo qudei na naŋgo segi aŋgro naŋgi dego degsib ojoqnqab. Aŋgro qudei na naŋgo segi ai abu naŋgi jeutnjroqnsib ojoqnsib qaja tamo naŋgo baŋq di atoqnibqa naŋgi na naŋgi ñumoqnib moreŋoqnqab. ");
INSERT INTO boj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Niŋgi ijo ñam ejunub deqa tamo kalil naŋgi niŋgi qa are tulaŋ ugeinjroqnqas. Ariya niŋgi ijo ñam siŋgila na ojsib gilsib diŋo bati itqab di Qotei na niŋgi eleŋqas.” ");
INSERT INTO boj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Osiqa Yesus a olo marej, “Diŋo batiamqa iŋgi tulaŋ ugedamu a Qotei aqa getento warum miligiq di tigelesoqnim niŋgi unqab.” E Mak. Tamo uŋgasari ijo anjam endi sisiyeqnub qaji naŋgi geregere sisiyosib poinjrem. Poinjrim marqab, bole. Osiqa Yesus na aqa aŋgro naŋgi olo endegsi minjrej, “Niŋgi iŋgi ugedamu di unsibqa bati deqa tamo uŋgasari Judia sawaq di unub qaji naŋgi jaraiyosib manaq oqoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tamo uŋgasari tal meq di unub qaji naŋgi jaraiqa oqnsib iŋgi iŋgi oqa osibqa olo warum miligiq gilaib. Naŋgi jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tamo uŋgasari wauq di unub qaji naŋgi jaraiqa oqnsib naŋgo gara jugo oqa osibqa olo puluosib qureq baib. Naŋgi torei dena jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bati deqa uŋa gumaŋ ti uŋa aŋgro mom ti naŋgi jaraiyo baŋgioqnsib gulbe koba oqab. ");
INSERT INTO boj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Deqa niŋgi endegsib pailyoqniy, ‘Gulbe di awa bati qa brantaiq.’ ");
INSERT INTO boj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Niŋgi degsib pailyoqniy. Di kiyaqa? Bati deqa tamo uŋgasari naŋgi gulbe tulaŋ kobaquja oqab. Gulbe deqaji nami brantosaioqnej. Qotei na mandam atej bati deqa gulbe deqaji brantosai dena bosi bosiq agi bini unum. Bunuqna laŋa ambleq di dego brantqasai. Agi bati qujai deqa brantqas. ");
INSERT INTO boj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gulbe di aqa bati Tamo Koba a na truqutqas. A na truqutqasai di tamo uŋgasari kalil naŋgi padalekritqab. Aqa segi tamo uŋgasari nami giltnjrej qaji naŋgi padalaib deqa a na gulbe di aqa bati truqutqas. ");
INSERT INTO boj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bati deqa tamo qudei na merŋgwab, ‘Niŋgi uniy. Kristus a bqo agiende’ o ‘Kristus a bqo agide.’ Degsib merŋgibqa niŋgi naŋgo anjam quetnjraib. ");
INSERT INTO boj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tamo qudei naŋgi bosib gisaŋosib maroqnqab, ‘E Kristus.’ Qudei naŋgi maroqnqab, ‘E Qotei aqa medabu o qaji tamo bole.’ Degsib maroqnsib maŋwa kokba gargekoba babtoqnqab. Naŋgo maŋwa dena naŋgi na tamo uŋgasari kalil areqalo niñaqyetnjroqnqab. Osib Qotei aqa segi tamo uŋgasari nami giltnjrej qaji naŋgo areqalo dego niñaqyetnjrqajqa wauoqnqab. ");
INSERT INTO boj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Deqa niŋgi geregere ŋam atsib soqniy. Kumbra kalil di brantosaisonaqa e namoqna merŋgonum.” ");
INSERT INTO boj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Osiqa Yesus a olo marej, “Gulbe kalil di naŋgo bati koboamqa seŋ ambruqas. Bai dego suwaŋqasai. ");
INSERT INTO boj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bongar naŋgi laŋ goge na ululoŋosib mandamq aiyeleŋqab. Laŋ goge dia iŋgi iŋgi kalil reŋgiŋyeleŋqab. ");
INSERT INTO boj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bati deqa e Tamo Aŋgro siŋgila ti riaŋ koba ti laŋbiq na mandamq aiyoqnit tamo uŋgasari naŋgi tarosib e nubqab. ");
INSERT INTO boj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yimqa bati deqa e na ijo laŋ aŋgro naŋgi qariŋnjritqa naŋgi sawa sawa kalil keretosib Qotei aqa segi tamo uŋgasari nami giltnjrej qaji naŋgi laŋ utru utruq na koroinjrqab.” ");
INSERT INTO boj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Osiqa Yesus a olo marej, “E na qura qa yawo anjam niŋgi merŋgitqa dena geregere poiŋgem. Qura baŋga qalsim olo ñalguyoqnimqa niŋgi unsib qalieqab, ‘Seŋ aqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Dego kere kumbra kalil e ubtosim merŋgonum qaji endi brantimqa niŋgi unsib endegsib qalieoiy, ‘Bole, Kristus bqajqa bati jojomqo. A siraŋmeq di tigelejunu.’ ");
INSERT INTO boj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","E bole merŋgwai. Tamo uŋgasari bini bati endeqa unub qaji naŋgi kalil moreŋosaisoqnibqa kumbra kalil endi brantqas. ");
INSERT INTO boj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Laŋ ti mandam ti koboqab. Ariya ijo anjam koboqa keresai.” ");
INSERT INTO boj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Osiqa Yesus a olo marej, “Ijo bqajqa bati tamo qujai bei a qaliesai. Laŋ aŋgro naŋgi qaliesai. E Qotei aqa Ŋiri e segi dego qaliesai. Ijo Abu a segi qalie. ");
INSERT INTO boj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Niŋgi ijo bqajqa bati qaliesai deqa niŋgi geregere ŋam atsib soqniy. ");
INSERT INTO boj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ijo bqajqa bati di tamo bei a sawa isaq gilej dego kere. A gilqa osiqa aqa kaŋgal tamo naŋgo baŋq di aqa tal ti iŋgi iŋgi ti uratetnjrsiqa naŋgi wau segi segi enjrej. Aqa kaŋgal tamo bei minjej, ‘Ni siraŋmeq di tigelesosim geregere ŋam atoqne.’ ");
INSERT INTO boj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Degsi minjej. Dego kere niŋgi geregere ŋam atsib soqniy. Di kiyaqa? Tal lanja a olo bqajqa bati niŋgi qaliesai. A bilaq kiyo, qolo kiyo, tuwe anjamoqnimqa kiyo, nobqolo kiyo bqas. ");
INSERT INTO boj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A boqujatosim niŋgi ŋereŋesoqnib nuŋgaim deqa niŋgi geregere ŋam atsib soqniy. ");
INSERT INTO boj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","E anjam merŋgonum qaji endi tamo kalil naŋgi dego minjreqnum. Ijo anjam agiende, ‘Niŋgi geregere ŋam atsib soqniy.’” Yesus na aqa aŋgro naŋgi degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Onaqa Juda naŋgo yori bati koba jojomej. Yori bati di aqa ñam Bem Tiyosai Qaji Uyqajqa Bati. Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa aqaryainjrej. Deqa olo are qalqajqa bati jojomej. Bati aiyel soqnej. Deqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti endegsib nenemoqneb, “Iga kiyersim Yesus lumu na ojsim qalsim moiyotqom?” ");
INSERT INTO boj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Osib mareb, “Iga yori bati qa Yesus ojqasai. Ojqom di tamo uŋgasari naŋgi iga nugsib ŋiriŋosib qoto tigelto uge.” ");
INSERT INTO boj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Onaqa Yesus a Betani qureq gilsiqa tamo bei nami yu na aqa jejamu ugeeleŋej qaji aqa ñam Saimon aqa talq di soqnej. Sosiqa iŋgi uyeqnaqa uŋa bei a goreŋ quleq ti tulaŋ boledamu silali kobaquja na awaiyej qaji di jaliŋaq jigsiqa osi bosiqa aqa medabu paratosiqa Yesus aqa gateq di bilentej. ");
INSERT INTO boj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Onaqa tamo qudei tal miligiq di awesoqneb qaji naŋgi uŋa di aqa kumbra unsibqa ŋiriŋosib segi segi maroqneb, “Uŋa di a kiyaqa goreŋ di laŋa ñaŋguiyqo? ");
INSERT INTO boj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A goreŋ di osiq tamo qudei enjrqo qamu meniŋ silali 300 yonub qamu gilsiq tamo iŋgi iŋgi saiqoji naŋgi jeisi enjrqo qamu di kere.” Osib naŋgi uŋa di ŋiriŋteb. ");
INSERT INTO boj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Onaqa Yesus na kamba minjrej, “Niŋgi kiyaqa uŋa di gulbe yeqnub? A kumbra bole ebqo. ");
INSERT INTO boj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tamo iŋgi iŋgi saiqoji naŋgi bati gaigai niŋgi ti sqab. Deqa niŋgi na naŋgi aqaryainjrqa are soqnimqa aqaryainjroqniy. Ariya e bati gaigai niŋgi ti sqasai. ");
INSERT INTO boj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","E moiqai. Moiyitqa e subq atqab. Uŋa di a e qa are qalsiqa ijo jejamuq di goreŋ bilentosiq dena ijo jejamu subq atqajqa gereiyetbqo. A na kumbra di e qa yqa kere agi yqo. ");
INSERT INTO boj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","E bole merŋgwai. Bunuqna ijo wau tamo naŋgi sawa sawa kalilq di ijo anjam bole mare mare laqnsibqa uŋa endena kumbra ebqo qaji deqa are qaloqnsib a qa saoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Onaqa Judas Iskariot a tigelosiqa atra tamo kokba naŋgoq gilej. Judas a Yesus aqa aŋgro 12 naŋgi deqaji bei. A naŋgoq gilsiqa minjrej, “E Yesus osiy nuŋgo baŋq di atqai.” ");
INSERT INTO boj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Degsi minjrnaqa naŋgi qusib tulaŋ areboleboleinjrnaqa minjeb, “Ni Yesus osim gago baŋq di atimqa iga ni silali emqom.” Degsib minjnabqa a gilsiqa a Yesus osim naŋgo baŋq di atqajqa gam ŋamoqnej. ");
INSERT INTO boj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ariya Bem Tiyosai Qaji Uyqajqa Bati brantej. Qotei a nami Israel naŋgi endegsi minjrej, “Niŋgi kaja du du naŋgi ñumeleŋosib siraŋmeq di leŋ liyibqa e na unsiy niŋgi uratŋgwai. E niŋgi padaltŋgwasai.” Qotei a nami Israel naŋgi degsi minjrej. Kumbra deqa olo are qalqajqa yori bati brantonaqa Juda naŋgi mareb, “Iga kaja du du naŋgi ñumeleŋosim Qotei atraiyqom.” Onaqa bati deqa Yesus aqa aŋgro naŋgi na endegsib nenemyeb, “Ni iga merge. Iga aisim tal qabia yori bati aqa iŋgi iŋgi gereiyetmonamqa ni iŋgi uyqam?” ");
INSERT INTO boj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Onaqa Yesus na aqa aŋgro aiyel qariŋnjrsiqa minjrej, “Niŋgi aiyel aisib qure ambleq di tamo bei ya nobu qoboiyosim giloqnim gamq di itosib dauryiy. ");
INSERT INTO boj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Niŋgi a dauryosib tal a gogetqas qaji di miligiq gilsib tal lanja endegsib minjiy, ‘Qalie Tamo a marqo, “E ijo aŋgro naŋgi koba na awoosim yori bati aqa iŋgi uyqajqa warum a qabi unu?” ’ ");
INSERT INTO boj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Niŋgi degsib minjibqa a na warum kobaquja bei gogeqsi unu di niŋgi osorŋgwas. Warum dia nami jar ti awo jaram ti ateleŋeb unu. Niŋgi aiyel aisib warum dia gago iŋgi iŋgi gereiyeleŋoiy.” ");
INSERT INTO boj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Onaqa naŋgi aiyel qure miligiq aisib anjam kalil Yesus na minjrej qaji degsi brantonab unsibqa iŋgi iŋgi kalil warum dia gereiyeleŋeb. ");
INSERT INTO boj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Onaqa bilaqtonaqa Yesus aqa aŋgro 12 naŋgi ti koba na aisib tal gogetosib awoosib iŋgi uyoqnsibqa Yesus a naŋgi endegsi minjrej, “E bole merŋgwai. Niŋgi ijo aŋgro 12. Nuŋgo ambleq dena aŋgro bei a tigelosim e osim tamo qudei naŋgo baŋq di atqas. Aŋgro di agi iga koba na iŋgi uyeqnum.” ");
INSERT INTO boj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Degsi minjrnaq qusibqa are tulaŋ gulbekobainjrnaqa segi segi Yesus nenemyoqneb, “O Tamo Koba, ni e qa kiyo maronum?” ");
INSERT INTO boj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Onaqa minjrej, “Aŋgro aqo ombla endego tabir qujaiq di bem quiq di tuqteqnum qaji a na e osim tamo qudei naŋgo baŋq di atqas. A dego ijo aŋgro 12 niŋgi deqaji bei. ");
INSERT INTO boj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Niŋgi quiy. E Tamo Aŋgro moiqai. Nami Qotei aqa anjam e qa degsib neŋgreŋyeb. Deqa uŋgum. E anjam di dauryosiy moiqai. Ariya aŋgro e osim tamo qudei naŋgo baŋq di atqas qaji a tulaŋ padalougetqas. A nami ŋambabosai qamu di kere.” ");
INSERT INTO boj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Osiqa Yesus aqa aŋgro naŋgi koba na iŋgi uyoqnsibqa Yesus a Qotei pailyosiqa bem bei osiq giŋgeŋyosiqa naŋgi enjrsiqa endegsi minjrej, “Endi ijo jejamu. Osib uyiy.” ");
INSERT INTO boj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Osiqa wain osiqa gambaŋq di bilentosiqa Qotei pailyosiqa aqa aŋgro naŋgi enjrnaqa naŋgi kalil osib uyeb. ");
INSERT INTO boj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Onaqa Yesus na minjrej, “Wain gambaŋ endi ijo leŋ. Tamo uŋgasari gargekoba naŋgo une kobotetnjrqajqa deqa ijo leŋ aiqas. Aisim Qotei aqa anjam bunuj nami gereiyej qaji di siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","E bole merŋgwai. E wain endi olo uyqasai. Degsi gilsiy mondoŋ diŋo batiamqa Qotei a nuŋgo Mandor Koba soqnimqa e olo wain bunuj uyqai.” ");
INSERT INTO boj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesus na aqa aŋgro naŋgi degsi minjrsiqa naŋgi koba na louosib koboonaqa qure uratosib Oliv manaq oqeb. ");
INSERT INTO boj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus aqa aŋgro naŋgi ti manaq oqoqnsibqa Yesus na minjrej, “Niŋgi kalil ijo ñam ulontosib e uratbosib jaraiqab. Nuŋgo kumbra deqa Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘E na kaja naŋgo mandor qalitqa kaja naŋgi segi segi jaraiqab.’ Qotei aqa anjam nami degsib neŋgreŋyeb. ");
INSERT INTO boj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ariya bati qalub koboamqa e olo subq na tigelosiy niŋgi qa namoosiy Galili sawaq gilitqa niŋgi bunuqna e daurbosib dia e itbqab.” ");
INSERT INTO boj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Onaqa Pita na minjej, “Aŋgro kalil naŋgi ino ñam ulontosib jaraiqab e segi ino ñam ulontqasai.” ");
INSERT INTO boj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Onaqa Yesus na kamba Pita minjej, “E bole mermqai. Qolo qujai endeqa ni ijo ñam ulitqam. Tuwe anjamoaiyeltosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai.’” ");
INSERT INTO boj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Onaqa Pita a tulaŋ saidosiq minjej, “Sai. E ni ombla moiqa marimqa, uŋgum, e ino ñam ulitqasai bole sai.” Onaqa Yesus aqa aŋgro kalil naŋgi anjam qujai di minjoqneb. ");
INSERT INTO boj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus aqa aŋgro naŋgi koba na walwelosib nañu agu beiq di branteb. Nañu agu di aqa ñam Getsemani. Di brantosib Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi endi awesoqniy. E kiñala sasalosiy ijo Abu pailyosiy bqai.” ");
INSERT INTO boj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Degsi minjrsiqa aqa aŋgro qalub agi Pita na Jems na Jon na naŋgi segi joqsiqa pailyqajqa sasalej. Sasalosiqa pailyoqnsiqa a are tulaŋ gulbekobaiyej. ");
INSERT INTO boj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Osiqa aqa aŋgro qalub naŋgi di minjrej, “E are tulaŋ gulbekobaibqo. Gulbe dena e moiyepratonum. Deqa niŋgi e ombla endi sosimqa ŋam atoqniy.” ");
INSERT INTO boj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Degsi minjrsiqa olo kiñala sasalosiqa mandamq di ŋam quosiqa endegsi pailyej, “O Aba. (Di Hibru anjam. Aqa damu, “O Abu.”) Gam bei soqnimqa ni na marimqa gulbe aqa bati bqo endi e buŋbosim gilem. Ni kumbra kalil yqa kere. Deqa ni marimqa gulbe endi ijoq baiq. Gulbe endi ya uge uyo bul. Uŋgum, ni ijo areqalo dauryaim. Ni ino segi areqalo dauryosim ye.” ");
INSERT INTO boj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesus a degsi Qotei pailyosiq olo tigelosiqa aqa aŋgro naŋgo areq aisiq ŋam atej di naŋgi are gulbe na ŋereŋesonab unjrej. Deqa Yesus na Pita minjej, “O Saimon, ni ŋeiejunum e? Ni ŋam sokiñalayqa keresai e? ");
INSERT INTO boj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niŋgi ŋereŋaib. Niŋgi ŋam sosib pailyoqniy. Yim gulbe bei nuŋgoq bqas di gulbe dena niŋgi uneq waiŋgwasai. Bole, nuŋgo are miligiq di niŋgi e daurbqajqa are unu. Ariya niŋgi segi gulbe di oqajqa siŋgila saiqoji.” ");
INSERT INTO boj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","40","Osiqa Yesus a olo puluosi sasalosiq a nami pailyej qaji degsi olo pailyosiq bosiqa aqa aŋgro qalub naŋgi urŋamnjrnaqa ŋereŋesonab unjrej. Unjrnaqa naŋgi Yesus anjam bei minjqa keresaiinjrej. ");
INSERT INTO boj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Olo gilsiq Qotei pailyosiq bosiq aqa aŋgro naŋgi itnjrsiq minjrej, “Niŋgi aqaratosib geregere ŋereŋejunub e? Uŋgum. Bati koboqo. Niŋgi uniy. E Tamo Aŋgro osib une tamo naŋgo baŋq di atqajqa bati bqo. ");
INSERT INTO boj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Niŋgi tigelab gilqom. Tamo e osim une tamo naŋgo baŋq di atqajqa agi brantqo.” ");
INSERT INTO boj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Onaqa Yesus aqa aŋgro 12 naŋgi deqaji bei agi Judas a na tamo gargekoba naŋgi sebru ti torom ti eleŋonab joqsiqa Yesus aqa areq di branteb. Juda gate naŋgi ti dal anjam qalie tamo naŋgi ti atra tamo kokba ti naŋgi na naŋgi qariŋnjrnab Yesus ojqa beb. ");
INSERT INTO boj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas a nami naŋgi ti qairosib anjam gereiyosib a na endegsi minjrej, “E na tamo kundoqyqai agide. A ojsib geregere taqatosib osib giliy.” ");
INSERT INTO boj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Onaqa Judas a Yesus aqa areq bosiq minjej, “O Tamo Koba.” Degsi minjsiq kundoqyej. ");
INSERT INTO boj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kundoqyonaqa tamo naŋgi brantosib baŋ waiyosib Yesus ojeb. ");
INSERT INTO boj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Onaqa Yesus aqa aŋgro bei jojom di tigelesoqnej qaji a na aqa sebru osiqa atra tamo gate aqa kaŋgal tamo gateq di qalqajqa sebru waiyej grotosiqa dabkala segi gentetej. ");
INSERT INTO boj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Onaqa Yesus na tamo naŋgi di minjrej, “E leŋ ojo tamo unum deqa kiyo niŋgi sebru ti torom ti eleŋosib e ojqa bonub e? ");
INSERT INTO boj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","E bati gaigai atra tal miligiq di niŋgi koba na sosimqa Qotei aqa anjam plaltoqnem. Bati deqa niŋgi yala baŋ waiyosib e ojosai. Niŋgi kumbra degyeb deqa Qotei aqa anjam neŋgreŋq di so qaji di aqa damu brantej.” ");
INSERT INTO boj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus a naŋgi degsi minjrnaqa aqa aŋgro kalil naŋgi a uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bati deqa aŋgro wala bei a ŋeio gara segi na kabuosiq Yesus dauryej. Onaqa tamo naŋgi na aŋgro di ojeb. ");
INSERT INTO boj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ojnabqa a ŋeio gara segi naŋgo baŋq di uratosiqa yosi ulaŋej. ");
INSERT INTO boj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Onaqa tamo naŋgi na Yesus osib atra tamo gate aqa talq osi gileb. Dia atra tamo kokba ti Juda gate naŋgi ti dal anjam qalie tamo naŋgi ti kalil koroesoqneb. Koroesonabqa tamo naŋgi na Yesus osi gilsib naŋgo ulatamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Naŋgi Yesus osi gileqnabqa Pita a kiñala isa isaq na Yesus dauryosiq uli uliosiq gilsiq torei atra tamo gate aqa tal meq di brantej. Brantosiqa naŋgi Yesus kiyeryib unqajqa deqa are qalsiq qaja tamo qudei naŋgi tal meq di ŋam tuŋguyosib awesonabqa bosiq naŋgi koba na ŋam yoroqneb. ");
INSERT INTO boj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Onaqa atra tamo kokba ti Juda gate naŋgi ti kalil koroesosibqa naŋgi Yesus aqa jejamuq di une qametqa are qalsib anjam ŋamoqneb. Di kiyaqa? Anjam dena naŋgi Yesus qalib moiqajqa deqa. Anjam ŋamonab ŋamonab ugeinjrej. ");
INSERT INTO boj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Deqa naŋgi tamo gargekoba metnjreqnab boqnsib gisaŋ anjam Yesus aqa jejamuq di qameleŋoqneb. Naŋgi anjam laŋa laŋa maroqneb. Naŋgo anjam di qujaiosai. ");
INSERT INTO boj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Onaqa naŋgo ambleq dena tamo qudei naŋgi tigelosib Yesus aqa jejamu laŋa gisaŋyosib mareb, ");
INSERT INTO boj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tamo endi a endegsi marnaq iga quem, ‘E atra tal koba endi tamo na gereiyo qaji di koŋgrontosiyqa bati qalub qa olo atra tal bei tamo na gereiyosai qaji di tigeltqai.’” ");
INSERT INTO boj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ariya naŋgo anjam di dego qujaiosai. Naŋgi anjam laŋa laŋa maroqneb. ");
INSERT INTO boj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Onaqa atra tamo gate a naŋgo anjam di qusiqa a tigelosiqa Yesus aqa areq bosiq nenemyej, “Tamo naŋgi endi une gargekoba ino jejamuq di qameqnub. Di ni kamba anjam bei marqasai e?” ");
INSERT INTO boj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Onaqa Yesus a torei mequmej. A anjam bei yala marosai. Deqa atra tamo gate na olo nenemyej, “Ni Kristus e? Ni Qotei Goge Koba aqa Ŋiri e? Ni e merbe.” ");
INSERT INTO boj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Onaqa Yesus na minjej, “Od. Agi e segi. Ni que. E Tamo Aŋgro. Bunuqna e laŋ qureq oqsiy Qotei siŋgila koba ti unu qaji aqa baŋ woq di awesosiy olo laŋbiq na boqnit niŋgi e nubqab.” ");
INSERT INTO boj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Onaqa atra tamo gate a Yesus aqa anjam di qusiqa a tulaŋ minjiŋ oqetonaqa aqa segi gara jugo bumbraŋyosiqa marej, “Aqa une agi a segi na babtqo iga quonum. Deqa iga kiyaqa tamo bei olo metonam bosim aqa une marqas? ");
INSERT INTO boj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aqa misiliŋ anjam niŋgi quonub. Deqa niŋgi kiyersib marqab?” Onaqa naŋgi kalil mareb, “A bole une ti. Deqa qalib moiyem.” ");
INSERT INTO boj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naŋgi kalil degsib marnabqa naŋgo ambleq dena tamo qudei naŋgi tigelosib Yesus miselyoqneb. Osib aqa ŋamdamu gara na qosetosib baŋ na qaloqnsib minjoqneb, “Ni Kristus amqa ni ubtosim mare, yai na ni lumqo?” Onaqa qaja tamo qudei naŋgi Yesus aqa areq boqnsib a ula poŋyoqneb. ");
INSERT INTO boj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ariya Pita a tal meq di awesosiq ŋam yoreqnaqa atra tamo gate aqa kaŋgal uŋa bei a bosiqa Pita unsiqa koqyosiq minjej, “Ni dego Yesus Nasaret qaji aqa aŋgro bei. Ni nami a dauryosim laqnem.” ");
INSERT INTO boj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Onaqa Pita a tulaŋ saidosiq minjej, “Ni anjam merbonum di e qaliesai.” Degsi minjsiqa tigelosiq tal qala beiq gilsiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sonaqa kaŋgal uŋa dena olo Pita unsiqa tamo naŋgi jojom di tigelesoqneb qaji naŋgi minjrej, “Tamo di a dego Yesus aqa aŋgro bei.” ");
INSERT INTO boj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Onaqa Pita a olo tulaŋ saidej. Olo kiñala soboleiyonaq tamo qudei Pita aqa areq di tigelesoqneb qaji naŋgi Pita koqyosib minjeb, “Ni Galili qaji tamo. Deqa iga qalieonum, ni Yesus aqa aŋgro bei.” ");
INSERT INTO boj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Onaqa Pita a olo tulaŋ siŋgila na saidosiq marej, “E tamo di qaliesai bole sai. E bole maronum. E gisaŋot Qotei na e lubem.” ");
INSERT INTO boj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A degsi marnaqa tuwe anjamej. Tuwe anjamonaqa Pita a qusiqa anjam nami Yesus na minjej qaji, “Tuwe anjamoaiyeltosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai,’” anjam deqa olo are qalsiqa poiyonaqa tulaŋ akamugetej. ");
INSERT INTO boj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Onaqa nobqolo malu qameqnaq atra tamo kokba ti Juda gate naŋgi ti dal anjam qalie tamo naŋgi ti kalil koroesosibqa Yesus qalib moiqajqa anjam keretoqneb. Anjam kereonaq naŋgi Yesus aqa baŋ tontetosib osi gilsib Rom naŋgo gate Pailat aqa baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Onaqa Pailat na Yesus nenemyej, “Ni Juda naŋgo Mandor Koba e?” Onaqa Yesus na minjej, “Od. Anjam ni maronum di kere.” ");
INSERT INTO boj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Onaqa atra tamo kokba naŋgi Yesus aqa anjam di qusib minjiŋ oqetnjrnaqa aqa jejamuq di une gargekoba qametoqneb. ");
INSERT INTO boj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Deqa Pailat na olo Yesus minjej, “Naŋgi une gargekoba ino jejamuq di qameleŋeqnub. Ni kamba anjam bei marqasai e?” ");
INSERT INTO boj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Onaqa Yesus a torei mequmej. A anjam bei yala marosai. Deqa Pailat a tulaŋ prugugetej. ");
INSERT INTO boj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailat aqa kumbra agiende. Wausau gaigai yori bati koba brantoqnimqa Juda tamo uŋgasari naŋgi tamo qujai aqa ñam maroqnibqa Pailat na tamo di tonto talq dena uratoqnsim enjroqnqas. ");
INSERT INTO boj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bati deqa tamo bei aqa ñam Barabas a tonto talq di soqnej. A nami tamo qudei joqsiqa Rom naŋgi ti qotsib tamo qudei ñumnab moreŋeb. Deqa a ojsib tonto talq di waiyeb. ");
INSERT INTO boj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Waiyonab sonaqa tamo uŋgasari kalil naŋgi Pailat aqa areq gilsibqa a naŋgo yori bati qa kumbra gaigai yoqnej qaji di olo yqajqa minjeb. ");
INSERT INTO boj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Minjnabqa a na nenemnjrej, “E Juda naŋgo Mandor Koba uratosiy eŋgwai e? Niŋgi na merbiy.” ");
INSERT INTO boj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat a naŋgi degsi nenemnjrej? Di kiyaqa? A qalieej, atra tamo kokba naŋgi Yesus qa ugeosib deqa a ojsib Pailat aqa baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Onaqa atra tamo kokba naŋgi na tamo uŋgasari kalil naŋgo areqalo tigeltetnjreb. Tamo uŋgasari naŋgi Pailat minjibqa a na Barabas uratosim enjrsimqa olo Yesus qalim moiqajqa deqa naŋgo areqalo tigeltetnjreb. ");
INSERT INTO boj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Onaqa Pailat na olo minjrej, “E niŋgi Barabas eŋgwajqa merbonub deqa e Yesus kiyeryqai? Agi niŋgi a qa mareqnub, ‘A Juda naŋgo Mandor Koba.’” ");
INSERT INTO boj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Onaqa naŋgi kalil murqumyosib minjeb, “Ni a ŋamburbasq di qame.” ");
INSERT INTO boj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Onaqa minjrej, “Kiyaqa Yesus qalit moiqas? A une kiye yqo deqa a ŋamburbasq di qamqai?” Degsi minjrnaqa naŋgi olo tulaŋ murqumyoqnsib waiŋyoqnsib minjoqneb, “Ni a ŋamburbasq di qame.” ");
INSERT INTO boj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Onaqa Pailat a naŋgo are latetnjrqa osiqa naŋgo anjam di dauryosiqa Barabas tonto talq dena oqeq atsiqa naŋgi enjrej. Enjrsiqa olo Yesus osiq qaja tamo naŋgo baŋq di atsiqa minjrej, “Niŋgi Yesus bu toqoŋ na kumbaiŋyiy.” Degsi minjrnaqa naŋgi na Yesus osib kumbaiŋyeb. Kumbaiŋyosib koboonaqa Pailat na olo minjrej, “Niŋgi Yesus ŋamburbasq di qamqajqa osib giliy.” ");
INSERT INTO boj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","17","Pailat na qaja tamo naŋgi degsi minjrnaqa naŋgi Yesus baŋ ojsib Rom naŋgo tal kobaqujaq osi gileb. Osi gilsib qaja tamo kalil naŋgi metnjrnab bosib tal dia koroeb. Koroosib gara jugo olekoba lent mandor kokba naŋgi gaigai jigeqnub deqaji bei osib Yesus jigeteb. Osib sil luwit osib lulumosib sil dena mandor naŋgo gate tatal bul gereiyosib aqa gateq di atetosib siŋgila na teqiyeb. ");
INSERT INTO boj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Osib gisaŋ na Yesus biŋiyoqnsib minjoqneb, “O Juda naŋgo Mandor Koba, kaiye!” ");
INSERT INTO boj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Degsib Yesus minjoqnsib bu toqoŋ na aqa gateq di qaloqnsib miselyoqnsib aqa areq di siŋga pulutoqneb. ");
INSERT INTO boj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Naŋgi degsib Yesus misiliŋyosib koboonaqa gara lent di piqtetosib aqa segi gara olo jigetosib aqa qawarq di aqa segi ŋamburbas atetosib a baŋ ojsib gaintqa sawaq osi gileb. ");
INSERT INTO boj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Naŋgi Yesus osi giloqnsibqa gamq di tamo bei walwelosiq Jerusalem aiyeqnaqa a turosib ojsib Yesus aqa qawarq dena ŋamburbas yaiyosib tamo di yonabqa a kamba qoboiyosiqa gam na Yesus dauryosiq giloqnej. Tamo di aqa ñam Saimon. A Sairini qure qaji. A Aleksander Rufus wo naŋgo abu. ");
INSERT INTO boj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naŋgi Yesus osi gilsib sawa agu kiñala bei aqa ñam Golgota di branteb. Ñam di aqa damu, “Tamo gate tanu.” ");
INSERT INTO boj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Di brantosib qaja tamo naŋgi na wain ti kial aqa ya isa koba de ti bulyosib Yesus anaiyonab uyo oneiyonaq ugeiyonaq uratej. ");
INSERT INTO boj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Onaqa qaja tamo naŋgi na Yesus osib ŋamburbasq di qameb. Qamsib Yesus aqa gara eleŋqa marsib gilteleŋeb. Osib meniŋ silali alaŋeb. Tamo yai aqa meniŋ na buŋnjrqas di a na gara oqas. Degsib marsib meniŋ silali alaŋosib gara eleŋeb. ");
INSERT INTO boj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Seŋ bati 9 onaqa nobqolo naŋgi Yesus ŋamburbasq di qameb. ");
INSERT INTO boj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Qamsib ŋamburbas mutu gogeq di anjam endegsib neŋgreŋyeb, “Tamo endi a Juda naŋgo Mandor Koba.” Yesus a nami maroqnej, “E Juda naŋgo Mandor Koba.” Yesus aqa une deqa osib anjam di neŋgreŋyeb. ");
INSERT INTO boj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bati deqa bajiŋ tamo aiyel dego ŋamburbasq di gaintnjrsib ñumeb. Bei Yesus aqa baŋ woq di qameb. Bei Yesus aqa baŋ qonaŋq di qameb. ");
INSERT INTO boj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kumbra dena Qotei aqa anjam bei neŋgreŋq di so qaji di aqa damu brantej. Agi endegsib neŋgreŋyeb, “Tamo uŋgasari naŋgi marqab, ‘Kristus a dego une tamo.’” ");
INSERT INTO boj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yesus a ŋamburbas goge di sonaqa tamo uŋgasari naŋgi aqa ulatamuq dena walwelosib gile beoqnsib a misiliŋyoqnsib gate gaiŋyoqnsib minjoqneb, “Ni nami marem, ‘E atra tal koba koŋgrontosiyqa bati qalub qa olo tigeltqai.’ Ni nami degsi marem. ");
INSERT INTO boj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ino anjam di boleamqa ni ino segi jejamu aqaryaiyosim ŋamburbas uratosim mandamq aiye.” ");
INSERT INTO boj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atra tamo kokba ti dal anjam qalie tamo naŋgi ti dego Yesus degsib misiliŋyoqneb. Osib segi segi maroqneb, “A na tamo uŋgasari gargekoba naŋgi aqaryainjroqnej. Ariya a na aqa segi jejamu aqaryaiyqa keresai. ");
INSERT INTO boj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A maroqnej, ‘E segi Kristus. E Israel naŋgo Mandor Koba.’ Aqa anjam di boleamqa a ŋamburbas uratosim mandamq aiyimqa iga unsim marqom, ‘Bole.’” Onaqa bajiŋ tamo aiyel Yesus ombla gaintnjreb qaji naŋgi dego Yesus degsib misiliŋ anjam minjoqneb. ");
INSERT INTO boj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Qanam jige seŋ bati 12 onaqa sawa kalil tulaŋ ambruosi sonaq gilsiq seŋ bati 3 onaq bilaqtej. ");
INSERT INTO boj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Onaqa Yesus a tulaŋ leleŋosiqa marej, “Eloi, Eloi, lama sabaktani?” Di Hibru anjam. Anjam di aqa damu, “O ijo Qotei. O ijo Qotei. Ni kiyaqa e qoreibonum?” ");
INSERT INTO boj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Onaqa tamo qudei Yesus aqa areq di tigelesoqneb qaji naŋgi aqa anjam di qusib mareb, “Niŋgi quiy. A Elaija meteqnu.” ");
INSERT INTO boj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Degsib marnabqa tamo bei a urur ti gilsiq gara ñeŋgi bei osiq wain isa kobaq di tuqtosiqa soruq di qosisiqa osi bosiqa Yesus anaiyqajqa soqtosiqa aqa medabuq di atej. Osiqa marej, “Iga mati tariŋosim koqyesqom. Elaija a bosim Yesus ŋamburbasq dena osim mandamq atqas kiyo?” ");
INSERT INTO boj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Onaqa Yesus a olo tulaŋ leleŋosiqa mondor titosiq aqa ŋambile uratosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bati qujai deqa gara kobaquja atra tal miligiq di gaiŋesoqnej qaji a goge na braŋosiq aisiq poaiyelej. ");
INSERT INTO boj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesus a degsi mondor titosiq moiyej deqa qaja tamo naŋgo gate Yesus aqa areq di tigelesoqnej qaji a unsiqa marej, “Bole. Tamo endi a Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Uŋgasari qudei naŋgi isaq di tigelesosib Yesus koqyoqneb. Bei Maria Makdala qure qaji. Maria bei agi Jems yala Joses wo naŋgo ai. Uŋa bei Salome. ");
INSERT INTO boj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesus a nami Galili sawaq di sonaqa uŋgasari naŋgi dena a dauryosib laqnsib kaŋgalyoqneb. Bunuqna Yesus a Galili sawa uratosiqa a na naŋgi qalub uŋgasari qudei ti joqsiqa koba na Jerusalem beleŋeb. ");
INSERT INTO boj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Juda naŋgo yori bati brantqa laqnej deqa yori bati aqa iŋgi iŋgi kalil gereiyosib atnab soqnej. ");
INSERT INTO boj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Onaqa bilaqtonaqa tamo bei aqa ñam Josep a Yesus aqa jejamu osim subq atqa marsiqa Pailat nenemyqa gilej. Josep a Juda naŋgo gate bei. A Arimatea qure qaji. Aqa kumbra tulaŋ boledamu. Deqa tamo uŋgasari kalil naŋgi a qa maroqneb, “A tamo bolequja.” A endegsi are qaloqnej, “Bunuqna Qotei a bosim gago Mandor Koba sosim iga taqatgwas.” A degsi are qaloqnsiq Qotei qa tariŋoqnsiq soqnej. A Pailat aqa talq gilsiqa aqa areq di tigelej. A ulaosai. Osiqa Pailat nenemyej, “Ni e odbimqa e Yesus aqa jejamu osiy subq atqa kere e?” ");
INSERT INTO boj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Onaqa Pailat a tulaŋ prugugetosiq marej, “Yesus a urur moiqo e?” Osiqa qaja tamo naŋgo gate a metonaq bonaq nenemyej, “Yesus a bole moiqo e?” ");
INSERT INTO boj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Onaqa minjej, “Od, a moiqo.” Onaqa Pailat a anjam di qusiqa Josep odyosiq minjej, “Di kere. Ni Yesus aqa jejamu am. Osim subq ate.” ");
INSERT INTO boj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Onaqa Josep a gilsiqa gara qat awaiyosiqa Yesus aqa jejamu ŋamburbasq dena osiqa gara qat na dalaosiq osi gilej. Osi gilsiqa sub bei nami meniŋ miligiq di gereiyeb qaji dia atsiqa meniŋ kobaquja belbeltosiq dena sub me getentej. ");
INSERT INTO boj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Josep na Yesus subq ateqnaqa Maria Makdala qure qaji wo Maria bei agi Joses aqa ai wo bosib koqyesoqneb. ");
INSERT INTO boj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Onaqa yori bati koboonaqa Salome na Maria Makdala qure qaji na Jems aqa ai Maria na naŋgi qalub ŋam so aqa ya quleq tulaŋ boledamu awaiyeb. Ŋam so aqa ya di Yesus aqa jejamuq di liyqajqa deqa awaiyeb. ");
INSERT INTO boj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Osib nobqolo ambru naŋgi tigelosib Yesus aqa jejamuq di liyqajqa deqa subq giloqnsib gamq di segi segi maroqneb, “Yai na meniŋ kobaquja sub me getentejunu qaji di beltosim taqal atetgwas?” ");
INSERT INTO boj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Degsib maroqnsib gilsib ŋam ateb di meniŋ kobaquja waqosiq taqal di sonaq uneb. Meniŋ di tulaŋ kobaquja. ");
INSERT INTO boj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Onaqa naŋgi sub miligiq aisib aŋgro wala bei baŋ woq di awesonaq unsib ulaugeteb. Aŋgro wala di aqa gara tulaŋ qat. ");
INSERT INTO boj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Onaqa aŋgro wala na minjrej, “Niŋgi ulaaib. E qalie, niŋgi Nasaret tamo Yesus ŋamburbasq di qameb qaji a qa ŋameqnub. A endi sosai. A subq na tigelqo. Niŋgi bosib sub miligi uniy. A ŋeioteb qaji lume agi unu. ");
INSERT INTO boj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Niŋgi unsibqa olo puluosib aisib Yesus aqa aŋgro qudei naŋgi Pita ombla endegsib minjriy, ‘Yesus a subq na tigelqo. Tigelosiq niŋgi qa namoosiq Galili sawaq gilqo. Agi a nami niŋgi endegsi merŋgej, “E niŋgi qa namoosiy Galili sawaq gilqai.” Deqa niŋgi dego Galili sawaq gilsib dia a itqab.’” ");
INSERT INTO boj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Onaqa naŋgi qalub tulaŋ ulaugetosib are toŋtoŋnjrnaqa sub uratosib olo puluosib aiyeb. Aiyoqnsibqa gamq di tamo uŋgasari naŋgi turoqnsib anjam bei minjrosaioqneb. Naŋgi laŋa aiyoqneb. Di kiyaqa? Naŋgi tulaŋ ulaugeteb deqa. ");
INSERT INTO boj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yori bati koboonaqa nobqolo ambru Yesus a subq na tigelosiqa mati Maria Makdala qure qaji aqaq di brantonaq unej. Maria agi nami Yesus na mondor uge 7 naŋgi aqaq dena winjretej qaji. ");
INSERT INTO boj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","A Yesus unsiqa olo puluosi gilsiq Yesus aqa aŋgro qudei nami Yesus dauryosib laqneb qaji naŋgi are ugeinjrnaqa akameqnabqa itnjrsiqa minjrej, “E Yesus unonum. A ŋambile unu.” Onaqa naŋgi Maria aqa anjam di qunab ugeinjrej. Naŋgi aqa anjam deqa poinjrosai. ");
INSERT INTO boj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Olo bati bei Yesus aqa aŋgro aiyel naŋgi nañu gam bei dauryosib gileqnabqa Yesus aqa jejamu bulyosiqa naŋgoq di brantonaq uneb. ");
INSERT INTO boj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Unsibqa naŋgi olo puluosib aisib Yesus aqa aŋgro qudei naŋgi minjreb, “Yesus a gagoq di brantqoqa iga unonum.” Degsib minjrnabqa naŋgi dego qunab ugeinjrej. Naŋgi anjam deqa poinjrosai. ");
INSERT INTO boj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Olo bati bei Yesus aqa aŋgro 11 naŋgi tal miligiq di awoosib iŋgi uyeqnabqa Yesus a naŋgoq di brantej. A nami subq na tigelonaqa tamo qudei na unsib naŋgi sainjrnab qunab ugeinjrej. Naŋgo are geteŋnjresoqnej. Deqa Yesus a segi naŋgoq di brantosiqa naŋgi ŋiriŋtnjrej. ");
INSERT INTO boj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Osiqa minjrej, “Niŋgi tigelosib sawa sawa kalil keretoqnsib tamo uŋgasari kalil naŋgi ijo anjam bole minjre minjre laqniy. ");
INSERT INTO boj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tamo uŋgasari naŋgi e qa naŋgo areqalo siŋgilatosib yanso oqab di Qotei na naŋgi eleŋqas. Ariya tamo uŋgasari naŋgi e qa naŋgo areqalo siŋgilatqasai di Qotei na naŋgi eleŋqasai. A na naŋgo une qa peginjrsim awai uge enjrqas. ");
INSERT INTO boj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tamo uŋgasari e qa naŋgo areqalo siŋgilatqab qaji naŋgi maŋwa gargekoba endeqaji babtoqnqab. Naŋgi ijo ñam na mondor uge uge winjroqnqab. Qotei na naŋgo meŋ bulyetnjroqnimqa naŋgi qure utru bei bei naŋgo anjam bunuj maroqnqab. ");
INSERT INTO boj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Naŋgi baŋ waiyosib amal uge ojoqnqab. Naŋgi ya isa koba qaja ti di uyoqnib dena moreŋqasai. Naŋgi ma tamo naŋgo gateq di baŋ atoqnib naŋgi olo boleoqnqab.” ");
INSERT INTO boj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tamo Koba Yesus na aqa aŋgro naŋgi degsi minjrnaqa Qotei a Yesus laŋ qureq osi oqsiqa aqa baŋ woq di awotej. ");
INSERT INTO boj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Onaqa aqa aŋgro naŋgi jaraiyosib sawa sawa kalil keretoqnsib Qotei aqa anjam palontoqneb. Palonteqnabqa Tamo Koba a naŋgi koba na wauoqnsiqa maŋwa gargekoba babtoqnsiqa dena naŋgo anjam siŋgilatoqnej. ");
INSERT INTO boj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","O Tamo Koba Tiofilus, kumbra kalil Qotei a nami gago ambleq di yoqnej qaji di aqa wau tamo naŋgi unoqnsib deqa iga saigoqneb. Naŋgo anjam di tamo gargekoba naŋgi quoqnsib neŋgreŋyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Deqa e dego anjam di neŋgreŋyosiy inoq qariŋyqa are qalem. Are qalsimqa anjam aqa damu geregere qalieqajqa deqa nenemosim laqnem. Nenemosim laqnsimqa anjam di utruq na neŋgreŋyosim agi inoq qariŋyonum. ");
INSERT INTO boj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Deqa ni sisiyosim qalieqam, anjam ni nami mermoqneb qaji di bole kalil. ");
INSERT INTO boj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot a Judia sawa naŋgo mandor sonaqa bati deqa atra tamo bei aqa ñam Sekaraia a soqnej. A atra tamo Abiya aqa moma. Sekaraia aqa ŋauŋ a atra tamo gate Aron aqa moma. Aqa ñam Elisabet. ");
INSERT INTO boj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaraia aqa ŋauŋ wo naŋgo kumbra tulaŋ boledamu. Naŋgi Qotei aqa dal anjam kalil geregere dauryoqnsib soqneb. Naŋgi Tamo Koba aqa ŋamgalaq di une saiqoji. ");
INSERT INTO boj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet aqa miligi ugeej deqa aqa gumbuluŋ wo aŋgro saiqoji sosibqa qelieb. ");
INSERT INTO boj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bati bei Sekaraia aqa wau qujai naŋgi ti Qotei atraiyqa marsibqa Jerusalem gileb. ");
INSERT INTO boj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Naŋgo ambleq dena tamo bei giltibqa a Tamo Koba aqa atra tal miligiq gilsim ŋam qaq koitim quleqamqa Qotei atraiyqajqa deqa Jerusalem gileb. Gilsib naŋgi tamo yai giltqab di qalieqajqa deqa naŋgi meniŋ alaŋo bubuŋeb. Meniŋ alaŋonabqa Sekaraia aqa meniŋ na buŋyej. Deqa naŋgi Sekaraia giltonabqa a atra tal miligiq gilsiqa Qotei atraiyej. ");
INSERT INTO boj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Qotei atraiyeqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi atra tal oqeq di koroosib Qotei pailyosib soqneb. ");
INSERT INTO boj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Onaqa Tamo Koba aqa laŋ aŋgro bei aisiq Sekaraia aqa ulatamuq di brantosiqa atra bijal ŋam qaq koitoqnej qaji baŋ woq di tigelonaq unsiqa tulaŋ ulaugetej. ");
INSERT INTO boj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Onaqa laŋ aŋgro na minjej, “Sekaraia, ni ulaaim. Qotei a ino pailyo quetmqo. Deqa ino ŋauŋ Elisabet a gumaŋosim aŋgro mel oqas. Yim ni aqa ñam Jon waiyqam. ");
INSERT INTO boj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aŋgro di a ŋambabimqa ni tulaŋ areboleboleimqas. Tamo uŋgasari gargekoba naŋgi dego a unsibqa tulaŋ areboleboleinjrqas. ");
INSERT INTO boj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aŋgro di a Tamo Koba aqa ŋamgalaq di ñam koba ti sqas. A wain ti ya siŋgila ti uyoqnqasai. A aqa ai miligiq di soqnimqa Mondor Bole na a siŋgilatoqnqas. ");
INSERT INTO boj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bunuqna a na Israel gargekoba naŋgi are bulyetnjroqnim naŋgi naŋgo Tamo Koba Qotei areiyoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kristus a bqa laqnimqa Jon a namoosim Qotei aqa medabu o tamo Elaija aqa kumbra ti siŋgila ti osim Kristus aqa gam gereiyetqas. A Kristus aqa gam endegsi gereiyetqas. Abu naŋgo aŋgro naŋgi ti jeu jeu soqnibqa a na naŋgi are bulyetnjroqnim naŋgi are qujaitosib sqab. Tamo uŋgasari Qotei aqa anjam gotraŋyeqnub qaji naŋgi dego a na are bulyetnjroqnim naŋgi kumbra bole bole dauryoqnqab. Jon na degsim tamo uŋgasari naŋgo areqalo gereiyetnjrim soqnibqa Tamo Koba a bqas.” ");
INSERT INTO boj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Onaqa Sekaraia na kamba laŋ aŋgro di minjej, “E tulaŋ qelionum. Ijo ŋauŋ a dego qeliqo. Deqa e kiyersiy qalieqai, ino anjam di bole?” ");
INSERT INTO boj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Onaqa laŋ aŋgro na Sekaraia minjej, “Ijo ñam Gebriel. E Qotei aqa ulatamuq di tigelejunum. Qotei a segi na e qariŋbqoqa bosim anjam bole endi ni mermonum. ");
INSERT INTO boj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Deqa ni que. Ni ijo anjam poimosai deqa bini medabu geteŋmimqa sqam. Bunuqna anjam e ni mermonum qaji aqa damu kalil brantimqa ino medabu olo waqtosim anjam maroqnqam. Bati Qotei na giltqo qaji batiamqa ijo anjam aqa damu kalil brantim ni unqam.” Laŋ aŋgro na degsiqa Sekaraia minjej. ");
INSERT INTO boj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tamo uŋgasari naŋgi Sekaraia a olo atra talq dena oqedqajqa deqa tariŋoqneb. Osib maroqneb, “Sekaraia a kiyaqa atra tal miligiq di sokobaiyqo?” ");
INSERT INTO boj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Onaqa Sekaraia a oqedosiqa naŋgi anjam minjrqa yonaq keresaiiyej. Deqa naŋgi mareb, “Qotei aqa maŋwa bei atra tal miligiq di brantqoqa Sekaraia a unqo. Deqa a anjam marqa keresai.” Sekaraia aqa medabu geteŋyej deqa a baŋ na segi naŋgi anjam minjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ariya bunuqna aqa atraiyo wauqa bati koboonaqa a olo puluosiqa aqa qureq oqej. ");
INSERT INTO boj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bati bei aqa ŋauŋ Elisabet a gumaŋej. Deqa a bai 5 aqa talq di soqnej. A boleq di walwelosaioqnej. Osiqa marej, ");
INSERT INTO boj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Bini Tamo Koba a kumbra tulaŋ boledamu e ebsiqa tamo uŋgasari naŋgo ŋamgalaq di ijo gulbe kobotetbqo.” ");
INSERT INTO boj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Onaqa bai 5 di koboonaqa Qotei na aqa laŋ aŋgro Gebriel olo qariŋyonaqa Galili sawa naŋgo qure bei ñam Nasaret deq aiyej. ");
INSERT INTO boj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Aisiq dia duŋgeŋge bei aqa ñam Maria aqaq di brantej. Tamo bei aqa ñam Josep a na Maria oqajqa saga qameb. Josep a Mandor Koba Devit aqa moma. ");
INSERT INTO boj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebriel a Maria aqaq di brantosiqa minjej, “O Maria, kaiye. Tamo Koba a ni ombla unub. A ni kumbra tulaŋ boledamu emqo.” ");
INSERT INTO boj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Onaqa Maria a anjam di qusiqa tulaŋ prugugetej. Osiqa are qalej, “Laŋ aŋgro di aqa anjam e poibosai.” ");
INSERT INTO boj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Onaqa laŋ aŋgro na minjej, “Maria, ni ulaaim. Qotei a ni qa are tulaŋ boledamuiyqo. ");
INSERT INTO boj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Deqa ni gumaŋosim aŋgro mel oqam. Osim aqa ñam Yesus waiyqam. ");
INSERT INTO boj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A ñam tulaŋ kobaquja oqas. Naŋgi a qa maroqnqab, ‘A Qotei Goge Koba aqa Ŋiri.’ Qotei na a giltimqa a Mandor Koba sqas. A na aqa moma Devit nami mandor koba soqnej qaji aqa wau osim a kamba Mandor Koba sqas. ");
INSERT INTO boj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Deqa a Jekop aqa moma kalil naŋgo Mandor Koba sosimqa naŋgi bati gaigai taqatnjroqnqas. Aqa wau di koboqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Onaqa Maria na laŋ aŋgro di minjej, “Kumbra di kiyersi brantqas? E tamo osaiunum.” ");
INSERT INTO boj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Onaqa laŋ aŋgro na minjej, “Mondor Bole a inoq aisim Qotei Goge Koba aqa siŋgila emimqa ni aŋgro oqam. Deqa naŋgi a qa maroqnqab, ‘A Qotei aqa Ŋiri.’ A Qotei aqa segi kumbra ti sqas. ");
INSERT INTO boj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ni que. Ino gagai Elisabet a dego aŋgro mel oqas. A qeliosiq gumaŋqo. Naŋgi nami a qa maroqneb, ‘A aŋgro oqa keresai.’ Ariya bini a gumaŋqo bai 6 gilqo. ");
INSERT INTO boj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Qotei a kumbra kalil yqa kere. Kumbra bei a yqa keresai di sosai.” ");
INSERT INTO boj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Onaqa Maria na laŋ aŋgro di minjej, “E Tamo Koba Qotei aqa kaŋgal uŋa. Anjam ni e merbonum qaji di Qotei na dauryosim kumbra degsi ebem.” Onaqa laŋ aŋgro a Maria uratosiqa gilej. ");
INSERT INTO boj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bati deqa Maria a tigelosiqa urur ti Sekaraia aqa qureq oqej. Qure di yambaŋ. A Judia sawaq di unu. ");
INSERT INTO boj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oqsiq Sekaraia aqa talq di brantosiqa Elisabet itosiq metej, “O gagai Elisabet, kaiye.” ");
INSERT INTO boj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Metonaqa Elisabet a Maria aqa anjam di qunaqa aŋgro a Elisabet aqa meneq di anŋilej. Onaqa Mondor Bole a Elisabet aqaq aisiq siŋgila yonaqa a tulaŋ maosiqa Maria minjej, “Qotei a kumbra tulaŋ boledamu ni emqo. Kumbra deqaji Qotei a nami uŋgasari qudei naŋgi enjrosaioqnej. Aŋgro ino meneq di unu qaji a dego Qotei na kumbra tulaŋ boledamu yqo. ");
INSERT INTO boj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","O Maria, ni ijo Tamo Koba aqa ai. E uŋa kiyero deqa ni ijo talq bonum? ");
INSERT INTO boj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ni que. Ni e metbonum e ino anjam quonumqa aŋgro ijo meneq di unu qaji a areboleboleiyqoqa anŋilqo. ");
INSERT INTO boj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tamo Koba a na ni kumbra boledamu emqas anjam di mermonaqa ni qusim marem, ‘Bole, Qotei aqa anjam di aqa damu brantqas.’ Ni degsi marem deqa ni tulaŋ areboleboleimim sqam.” Elisabet na degsiqa Maria minjej. ");
INSERT INTO boj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Onaqa Maria a kamba medabu waqtosiqa marej, “Ijo are na e Tamo Koba aqa ñam soqtosim a biŋiyeqnum. ");
INSERT INTO boj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","E Qotei qa tulaŋ areboleboleibeqnu. Agi a na iga padalo sawaq na eleŋej. ");
INSERT INTO boj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","E aqa kaŋgal uŋa. E ñam saiqoji. Di uŋgum. Qotei na e uratbosai. A na e nubsiqa areibqo. Deqa bati endeqa ti bunuq qa ti tamo uŋgasari kalil naŋgi e qa endegsib maroqnqab, ‘Qotei na Maria kumbra tulaŋ boledamu yej.’ ");
INSERT INTO boj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Qotei siŋgila koba ti unu qaji a na e aqaryaibeqnu. Qotei aqa ñam getento koba. Une bei aqaq di sosai. ");
INSERT INTO boj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Qotei a tamo uŋgasari kalil aqa sorgomq di unub qaji naŋgi qa tulaŋ duleqnu. Bati endeqa ti bunuq qa ti Qotei a naŋgi qa duloqnsim sqas. ");
INSERT INTO boj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Qotei a wau siŋgila koba yeqnu. Tamo uŋgasari naŋgo segi ñam soqtqa are qaleqnub qaji naŋgi Qotei na olo winjreqnaq jaraiyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A na mandor kokba naŋgi kobotnjroqnsiqa tamo uŋgasari naŋgo segi ñam aguq ateqnub qaji naŋgi olo ñam soqtetnjreqnu. ");
INSERT INTO boj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tamo uŋgasari mam unub qaji naŋgi Qotei na iŋgi anainjreqnaq naŋgi kere na unub. Ariya tamo uŋgasari iŋgi koba ti unub qaji naŋgi a na uratnjreqnaqa naŋgi iŋgi saiinjreqnu. ");
INSERT INTO boj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A na aqa wau tamo Israel naŋgi aqaryainjreqnu. A nami marej, ‘E Israel naŋgi qa gaigai duloqnqai.’ A aqa anjam deqa are qaloqnsiqa agi bini Israel naŋgi aqaryainjreqnu. Qotei aqa anjam di a na nami gago moma utru naŋgi minjrej. Agi a na anjam di Abraham aqa moma kalil naŋgi ti minjrej.” Maria a medabu waqtosiqa anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bai qalub Maria a Elisabet aqa talq di soqnej. Di koboonaqa a olo puluosiqa aqa qureq gilej. ");
INSERT INTO boj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Onaqa Elisabet aqa bati kereonaqa a aqaratej. Aqaratonaqa aqa aŋgro mel ŋambabej. ");
INSERT INTO boj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ŋambabonaqa aqa qure qujai naŋgi ti aqa leŋ naŋgi ti kalil endegsi poinjrej, “Tamo Koba a Elisabet qa tulaŋ dulosiqa aqa miligi gereiyqoqa aŋgro mel oqo.” Naŋgi degsi poinjrej deqa naŋgi Elisabet koba na areboleboleinjrej. ");
INSERT INTO boj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Bati 8 koboonaqa naŋgi aŋgro di muluŋ waiyqa marsib koroeb. Koroosib aqa ñam Sekaraia waiyqa laqnabqa aqa ai na saidnjrsiqa minjrej, “Iga aqa ñam Jon waiyqom.” ");
INSERT INTO boj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Onaqa naŋgi na minjeb, “Ñam di ino leŋ naŋgoq di sosai.” ");
INSERT INTO boj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Degsi minjsib baŋ na Sekaraia nenemyeb, “Ni ino aŋgro ñam yai waiyqam?” ");
INSERT INTO boj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Onaqa a baŋ na minjrej, “Pepa bei osbabqa e aqa ñam neŋgreŋyit niŋgi unqab.” Pepa osi bonabqa endegsi neŋgreŋyej, “Aqa ñam Jon waiyqom.” Degsi neŋgreŋyonaqa naŋgi kalil tulaŋ prugeb. ");
INSERT INTO boj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Onaqa bati qujai deqa Sekaraia aqa meŋ otyonaqa medabu waqtosiqa anjam maroqnsiqa Qotei aqa ñam soqtoqnej. ");
INSERT INTO boj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bati deqa tamo uŋgasari kalil qure dia soqneb qaji naŋgi kumbra deqa qusib ulaeb. Ulaosib kumbra deqa mare mare laqnabqa naŋgo anjam di tulaŋ kobaonaqa qure kalil Judia sawaq di so qaji naŋgi quekriteb. ");
INSERT INTO boj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tamo uŋgasari anjam di queb qaji naŋgi kalil maroqneb, “Aŋgro di a tamo kiyero sqas?” Naŋgi degsi maroqneb. Di kiyaqa? Qotei aqa siŋgila aŋgro di aqaq di sonaq uneb deqa. ");
INSERT INTO boj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Onaqa Mondor Bole a Jon aqa abu Sekaraia aqaq aisiq siŋgila yonaqa medabu waqtosiqa anjam endegsi marej, ");
INSERT INTO boj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Iga Tamo Koba Qotei aqa ñam tulaŋ soqtoqnqom. A Israel gago Qotei. Iga aqa segi tamo uŋgasari unum deqa a na bosim iga awaigim iga padalqasai. ");
INSERT INTO boj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aqa wau tamo Devit aqa leŋ na tamo siŋgila koba bei ŋambabqas. Qotei na tamo di giltej deqa a na iga eleŋqas. ");
INSERT INTO boj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Qotei aqa kumbra deqa nami aqa segi medabu o qaji tamo naŋgi anjam palontoqneb. ");
INSERT INTO boj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naŋgi anjam endegsib palontoqneb, ‘Qotei a gago jeu tamo naŋgo baŋq dena iga eleŋqas. Osim tamo kalil iga qa ugeeqnub qaji naŋgo baŋq na dego iga eleŋqas.’ Naŋgi anjam degsib palontoqneb. ");
INSERT INTO boj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Qotei a gago moma utru naŋgi qa dulosiqa aqaryainjrej. Aqa segi anjam nami siŋgilatej qaji deqa are qalsiqa naŋgi aqaryainjrej. ");
INSERT INTO boj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aqa anjam di a siŋgilatosiq gago moma utru Abraham minjej. ");
INSERT INTO boj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Deqa a na gago jeu tamo naŋgo baŋq dena iga eleŋamqa iga aqa wau ojoqnqom. Iga ulaqasai. ");
INSERT INTO boj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iga bati gaigai Qotei aqa ŋamgalaq di aqa segi kumbra bole tiŋtiŋ dauryoqnqom. ");
INSERT INTO boj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O ijo aŋgro Jon, bunuqna ni Qotei Goge Koba aqa medabu o qaji tamo sqam. Tamo uŋgasari naŋgi degsib ni qa maroqnqab. Tamo Koba a bqa laqnimqa ni namoosim aqa gam gereiyetosim soqnim a bqas. ");
INSERT INTO boj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Ni na Qotei aqa segi tamo uŋgasari naŋgi anjam minjroqnimqa naŋgi quoqnsib endegsi poinjroqnqas, ‘Bole, Qotei a iga qa dulej deqa a na gago une kobotetgosim iga eleŋqas.’ Gago Qotei a laŋ goge na suwaŋ qariŋyim gagoq bqas. ");
INSERT INTO boj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tamo uŋgasari ambruq di sosib moreŋqa ulaeqnub qaji naŋgi Qotei na suwantnjroqnqas. Osim a na iga gam osorgoqnimqa iga lawo kumbra dauryoqnqom.” Sekaraia a anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Onaqa Jon a kobaqujaeqnaqa Qotei aqa Mondor na siŋgila yoqnej. A wadau sawaq di sosiqa a na Israel tamo uŋgasari naŋgi Qotei aqa anjam minjrqajqa bati qa tariŋoqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bati deqa Rom naŋgo mandor koba Sisar Ogastus a marej, “Iga sawa sawa kalilq di tamo uŋgasari naŋgo ñam sisiyqom.” ");
INSERT INTO boj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Degsi marnaqa Kwirinius a Siria sawaq di gate sonaqa naŋgi na ñam sisiyeb. Naŋgi nami ñam sisiyosaioqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Deqa tamo uŋgasari kalil naŋgi na naŋgo ñam ateleŋqajqa marsibqa naŋgo segi segi qure utruq gileleŋeb. ");
INSERT INTO boj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep a Nasaret qureq dena tigelosiqa Devit aqa qure utruq oqej. Nasaret qure a Galili sawaq di unu. Devit aqa qure utru aqa ñam Betlehem. Betlehem a Judia sawaq di unu. Josep a deq oqej. Di kiyaqa? A Devit aqa leŋ na ŋambabej deqa. ");
INSERT INTO boj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maria a Josep aqa ŋauŋ soqnej deqa naŋgi aiyel ombla na naŋgo ñam atqa marsibqa Betlehem oqeb. Bati deqa Maria a gumaŋ ti. ");
INSERT INTO boj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Naŋgi Betlehem di sonabqa Maria aqa bati kereonaqa a aŋgro ej. Ŋereŋo tal koba qaji tamo na maqej deqa aqa aŋgro matu mel ŋambabonaqa gara na dalaosiq makau naŋgo iŋgi uyo tabirq di ŋeiotej. ");
INSERT INTO boj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Qolo qujai deqa qure qalaq di tamo qudei naŋgo kaja ñiŋ uyeqnabqa taqatnjresoqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Onaqa Tamo Koba aqa laŋ aŋgro bei aisiqa naŋgo areq di tigelonaq uneb. Aqa riaŋ na naŋgi suwantnjrnaqa naŋgi unsib tulaŋ ulaugeteb. ");
INSERT INTO boj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Onaqa laŋ aŋgro dena naŋgi minjrej, “Niŋgi ulaaib. E niŋgi anjam bole merŋgwajqa bonum. Merŋgitqa niŋgi qusib tulaŋ areboleboleiŋgwas. Tamo uŋgasari sawa sawa kalilq di unub qaji naŋgi dego tulaŋ areboleboleinjrqas. ");
INSERT INTO boj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Anjam bole agiende. Bini Tamo Koba Kristus a Devit aqa qure utruq di ŋambabqo. A na qujai tamo uŋgasari naŋgi eleŋamqa naŋgi padalqasai. ");
INSERT INTO boj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aŋgro mom di gara na dalaosib makau naŋgo iŋgi uyo tabirq di ŋeiotonub unu. Niŋgi aisib unsib poiŋgwas.” ");
INSERT INTO boj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Degsi minjreqnaqa laŋ aŋgro tulaŋ gargekoba naŋgi laŋ goge na bosib laŋ aŋgro nami bej qaji a ombla tigelosibqa Qotei aqa ñam soqtoqnsib endegsib maroqneb, ");
INSERT INTO boj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Laŋ goge di Qotei a ñam kobaquja oqo. Mandamq endi tamo uŋgasari naŋgi lawo na soqnebe. Qotei a naŋgi qa are tulaŋ boleiyeqnu.” ");
INSERT INTO boj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Laŋ aŋgro naŋgi olo puluosib laŋ qureq oqeqnabqa kaja taqato tamo naŋgi qairosib mareb, “Iga tigelosim Betlehem aisim Tamo Koba a iga kumbra deqa mergwo qaji di unqom.” ");
INSERT INTO boj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Degsib marsibqa gurgur ti aisib Maria Josep wo naŋgo aŋgro mom a makau naŋgo iŋgi uyo tabirq di ŋeiotosib sonab unjreb. ");
INSERT INTO boj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Unjrsibqa aŋgro deqa anjam laŋ aŋgro na minjrej qaji di kalil ubtosib saoqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Saeqnab tamo uŋgasari kalil anjam di queb qaji naŋgi prugugetosib are koba qaloqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ariya Maria a anjam di qusiqa aqa areqaloq di atsiq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Onaqa kaja taqato tamo naŋgi olo puluosib gileb. Anjam kalil laŋ aŋgro na minjrnaq queb qaji deqa ti kumbra kalil naŋgi uneb qaji deqa ti naŋgi tulaŋ areboleboleinjrnaqa Qotei aqa ñam soqtoqnsib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ariya Yesus a ŋambabosiq sonaqa bati 8 kereonaqa a muluŋ waiyeb. Osib aqa ñam Yesus waiyeb. Ñam di nami laŋ aŋgro na Maria gumaŋosaisonaq minjej qaji. ");
INSERT INTO boj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Juda naŋgo dal anjam bei agiende. Uŋa aŋgrotimqa bati 40 koboamqa naŋgi uŋa aqa jejamu yansetqab. Dal anjam di Moses a nami marej. Deqa Maria aqa jejamu yansetqa bati kereonaqa aqa gumbuluŋ wo Jerusalem gilsibqa atra tal miligiq di Maria aqa jejamu yansetosib Yesus osib Tamo Koba aqa baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Agi Moses a nami Tamo Koba aqa dal anjam endegsi neŋgreŋyej, “Aŋgro matu mel ŋambabamqa niŋgi Tamo Koba Qotei aqa baŋq di atiy. Atibqa a Qotei aqa segi tamo sqas.” ");
INSERT INTO boj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naŋgi aiyel Tamo Koba Qotei aqa dal anjam di dauryosib wagme bei osib Qotei atraiyeb. Agi dal anjam endegsi unu, “Binoŋ aiyel kiyo qebari bunuj aiyel kiyo osib Qotei atraiyiy.” ");
INSERT INTO boj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem dia tamo bei soqnej aqa ñam Simeon. Aqa kumbra tulaŋ boledamu. A Qotei aqa sorgomq di geregere soqnej. Mondor Bole na a siŋgilatonaq soqnej. A endegsi are qaloqnej, “Bati brantimqa Qotei na Israel tamo uŋgasari naŋgo are boletetnjrqas.” A degsi are qaloqnsiq deqa bati di brantqajqa tariŋoqnsiq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mondor Bole na nami Simeon minjej, “Ni mati moiqasai. Ni moiyosaisoqnimqa Tamo Koba a na aqa Kristus qariŋyim bamqa ni unsim moiqam.” ");
INSERT INTO boj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Onaqa bati bei Qotei aqa Mondor na Simeon aqa are tigeltetonaqa atra tal miligiq gilej. Gilsiq di sonaqa Maria Josep wo naŋgi dal anjam dauryosib naŋgo aŋgro Yesus osib Qotei aqa baŋq di atqa marsibqa atra tal miligiq gileb. ");
INSERT INTO boj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Onaqa Simeon a Yesus unsiqa a osiq soqoŋyej. Soqoŋyosiqa Qotei aqa ñam soqtosiq endegsi pailyej, ");
INSERT INTO boj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Tamo Koba, e ino wau tamo. Ino anjam ni nami e merbem qaji di ni uratosai. Deqa e lawo na moiqai. ");
INSERT INTO boj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ni na ino segi tamo uŋgasari naŋgi eleŋam naŋgi padalaib deqa ino Kristus qariŋyem agi e unonum. ");
INSERT INTO boj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tamo uŋgasari kalil naŋgo ŋamdamuq di ni kumbra di yqajqa gam gereiyem. ");
INSERT INTO boj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kristus aqa riaŋ na sawa bei bei qaji naŋgi suwantnjroqnqas. Osim ino segi tamo uŋgasari Israel naŋgi dego suwantnjrimqa naŋgo ñam kobaqas.” ");
INSERT INTO boj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon a Yesus qa anjam degsi marnaqa Yesus aqa ai abu naŋgi qusib tulaŋ prugeb. ");
INSERT INTO boj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Onaqa Simeon a naŋgi aiyel qa Qotei pailyosiqa Yesus aqa ai Maria minjej, “Ni que. Qotei na aŋgro endi giltej deqa Israel gargekoba naŋgi uloŋosib padalqab. Gargekoba dego olo tigelosib ŋambile bole oqab. Aŋgro endi a toqor bul soqnimqa gargekoba naŋgi na a jeutoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Deqa gargekoba naŋgo areqalo uliejunu qaji di olo boleq dqas. Yimqa serie na ino are qametmo bul are jaqatiŋ oqnqam.” ");
INSERT INTO boj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bati deqa Qotei aqa medabu o qaji uŋa bei soqnej aqa ñam Ana. A Fanuel aqa aŋgro. A Aser aqa moma. A tulaŋ qeliej. A nami tamo osiqa gumbuluŋ wo wausau 7 soqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aqa gumbuluŋ moinaqa a segi qobul soqnej. Aqa wausau kalil 84. A qobul sosiqa a bati gaigai qolo ti qanam ti atra tal miligiq giloqnsiqa iŋgi ti ya ti uratoqnsiqa Qotei pailyoqnej. A atra tal uratosaioqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon a anjam marsiq koboonaqa Ana a bosiqa aŋgro kiñala di unsiqa Qotei aqa ñam soqtej. Osiqa Jerusalem tamo uŋgasari kalil Qotei na awainjrqa marsib tariŋoqneb qaji naŋgi Yesus qa sainjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maria Josep wo naŋgi Jerusalem dia Tamo Koba aqa dal anjam kalil dauryekritosib naŋgi olo puluosib Galili sawaq gilsib naŋgo segi qure utru Nasaret di soqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Di sosibqa naŋgo aŋgro kiñala Yesus a boleoqnsiqa siŋgilaoqnsiq powo qelikoba oqnej. Qotei a Yesus qa are tulaŋ boleiyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesus aqa ai abu naŋgi wausau gaigai Juda naŋgo yori bati koba ñam Pasova di unqajqa maroqnsib Jerusalem aiyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Deqa Yesus aqa wausau 12 kereonaqa a na aqa ai abu naŋgi daurnjrsiqa yori bati di unqajqa koba na Jerusalem aiyeb. ");
INSERT INTO boj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aisib yori bati di unsib koboonaqa tamo uŋgasari kalil naŋgi puluosib naŋgo segi segi qureq olo gileqnabqa aŋgro wala Yesus a segi Jerusalem di soqnej. Aqa ai abu naŋgi deqa qaliesai. ");
INSERT INTO boj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Naŋgi are qaleb, “Yesus a tamo qudei naŋgi daurnjrsiqa nami gilqo kiyo?” Degsib are qalsibqa qanam qujai naŋgi walwelosib gileb. Gilsib gamq di Yesus unosai deqa naŋgi na naŋgo segi kadoi naŋgi ti naŋgo segi leŋ naŋgi ti Yesus qa nene nenemnjroqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Onaqa ugeinjrnaqa naŋgi aiyel olo puluosib Jerusalem aisib dia Yesus qa ŋamoqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bati qalub naŋgi Yesus qa ŋamoqneb. Ŋamosib gilsib atra tal miligiq di ŋam atsib Yesus a di awesonaq uneb. A dal anjam qalie tamo naŋgo ambleq di awesosiqa naŋgo anjam quoqnsiqa anjam qudei naŋgi nenemnjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aqa powo tulaŋ kobaquja deqa a dal anjam qalie tamo naŋgi kamba anjam bole bole minjreqnaqa tamo kalil aqa anjam di quoqneb qaji naŋgi prugoqneb. ");
INSERT INTO boj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Onaqa aqa ai abu naŋgi a unsib prugugetosib aqa ai na minjej, “O ijo aŋgro, ni kiyaqa aqo ino abu wo kumbra deggonum? Ni que. Aqo aiyel are tulaŋ gulbeigwoqa ni qa ŋamoqnam.” ");
INSERT INTO boj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Onaqa Yesus na minjrej, “Niŋgi kiyaqa e qa ŋamoqnab? E ijo Abu aqa talq endi sqai. Niŋgi di qaliesai kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Onaqa aqa ai abu naŋgi aqa anjam di qusib poinjrosai. ");
INSERT INTO boj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Onaqa Yesus a tigelosiqa aqa ai abu naŋgi daurnjrsiqa Nasaret qureq gileb. Gilsib dia a naŋgo aiyel anjam geregere dauryoqnsiqa naŋgo sorgomq di soqnej. Aqa kumbra kalil di aqa ai na unoqnsiqa tulaŋ areboleboleiyeqnaqa aqa areqaloq di atnaq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus a Nasaret qureq di sosiqa a tamo kobaqujaoqnsiqa aqa powo dego qelikobaoqnej. Qotei a Yesus qa are boleiyoqnej. Tamo uŋgasari naŋgi dego Yesus qa are boleinjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Bunuqna Sekaraia aqa ŋiri Jon a wadau sawaq di sonaqa Qotei na aqa anjam minjnaq quej. Bati deqa Sisar Taiberius a wausau 15 Rom naŋgo mandor koba soqnej. Pontius Pailat a Judia sawa naŋgo gate soqnej. Herot a Galili sawa taqatoqnej. Herot aqa was Filip a Ituria sawa ti Trakonitis sawa ti taqatoqnej. Lisanias a Abilene sawa taqatoqnej. Anas Kaiafas wo naŋgi aiyel atra tamo gate soqneb. ");
INSERT INTO boj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon a sawa kalil Jordan ya qalaq di soqneb qaji deq giloqnsiqa Qotei aqa anjam palontoqnsiq tamo uŋgasari naŋgi endegsi minjroqnej, “Niŋgi are bulyibqa e na niŋgi yansŋgwai. Amqa Qotei a nuŋgo une kalil kobotetŋgwas.” ");
INSERT INTO boj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon a kumbra degyej deqa anjam bei Qotei aqa medabu o tamo Aisaia nami neŋgreŋyej qaji di aqa damu brantej. A Jon qa anjam endegsi neŋgreŋyej, “Tamo bei a wadau sawaq di tigelosimqa a tulaŋ leleŋoqnsim tamo uŋgasari naŋgi endegsim minjroqnqas, ‘Tamo Koba a bqajqa gam gereiyetiy. Gam tingitetiy. ");
INSERT INTO boj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Botau kalil mororyiy. Mana kokba ti mana kiñilala ti kalil giŋgeŋnjrsib taqal atiy. Gam kaneŋo kalil tingitiy. Gam niñaqejunub qaji kalil di dego gereiyiy. ");
INSERT INTO boj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yimqa tamo uŋgasari sawa sawa kalilq di unub qaji naŋgi Qotei na padalo sawaq dena eleŋam unqab.’” ");
INSERT INTO boj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tamo uŋgasari tulaŋ gargekoba naŋgi Jon na yansnjrqa marsibqa aqa areq beqnabqa siŋgila na endegsi minjroqnej, “Niŋgi kumbra uge yo qaji tamo. Niŋgi amal uge bul. Niŋgi yai na merŋgwoqa mondoŋ Qotei aqa minjiŋ nuŋgoq aiyaim deqa ulaosib ijoq bonub? ");
INSERT INTO boj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Niŋgi are bulyiy. Osib nuŋgo kumbra uge kalil uratosib kumbra bole bole yoqniy. Yim e unsiy marqai, ‘Bole, niŋgi are bulyonub.’ Osiy niŋgi yansŋgwai. Niŋgi endegsib are qalaib, ‘Abraham a gago moma utru unu deqa iga Qotei aqa ŋamgalaq di tamo bole.’ Niŋgi degsib are qalaib. Niŋgi quiy. Qotei na marimqa meniŋ kalil endi dego tamo bulyosib tigelosib Abraham aqa moma brantqab. ");
INSERT INTO boj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Qotei na tapor qalat ojsiqa ŋam qomqajqa utruq di atej unu. Deqa ŋam kalil gei bole atosaieqnub qaji di Qotei na tapor dena qomeleŋosim ŋamyuwoq di breinjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon a tamo uŋgasari naŋgi anjam degsi minjrnaqa naŋgi na kamba nenemyeb, “Ni anjam degsi mergonum deqa iga kumbra kiyeryqom?” ");
INSERT INTO boj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Onaqa Jon na minjrej, “Ni gara aiyel soqnimqa bei osim tamo gara saiqoji di ye. Ni iŋgi uyo soqnimqa qudei osim tamo iŋgi saiqoji di anaiye.” ");
INSERT INTO boj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Onaqa takis o qaji tamo qudei naŋgi Jon na yansnjrqa marsibqa aqa areq bosib nenemyeb, “O Qalie Tamo, ni mare. Iga takis o qaji tamo. Deqa iga kumbra kiyeryqom?” ");
INSERT INTO boj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Onaqa Jon na minjrej, “Nuŋgo gate kokba naŋgi takis silali gembub niŋgi oqajqa merŋgonub kere dego oqniy. Silali bei laŋa goge ataib.” ");
INSERT INTO boj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Onaqa qaja tamo qudei naŋgi Jon aqa areq gilsib nenemyeb, “Ni mare. Iga kumbra kiyeryqom?” Onaqa Jon na minjrej, “Niŋgi tamo naŋgi ugeugeinjraib. Osib naŋgo silali bajiŋoqnaib. Niŋgi tamo qudei gisaŋ na naŋgo jejamuq di une qametnjraib. Niŋgi endegsib are qaloqniy, ‘Gago awai iga eqnum di iga qa kere.’” ");
INSERT INTO boj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bati di tamo uŋgasari naŋgi Kristus bqajqa tariŋoqnsib soqneb. Deqa naŋgi Jon aqa anjam quoqnsib are qaloqneb, “Jon a Kristus kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Onaqa Jon a naŋgo areqalo di qalieosiqa minjrej, “Tamo Koba a bunuqna ijo qoreq na bqas. A tamo siŋgila koba. Ijo siŋgila aqa siŋgila ti keresai. Deqa e a kaŋgalyqajqa e tamo bolesai. E ya na laŋa yansŋgeqnum. Ariya Tamo Koba a bosimqa Mondor Bole aqa siŋgila na ti ŋamyuwo na ti niŋgi yansŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A bem sum ñoqoryosim damu eleŋosim aqa talq di atqas. Osim a bem sum aqa suwi breinjrim ŋamyuwo gaigai yuejunu qaji dia yuekritqab.” ");
INSERT INTO boj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon na tamo uŋgasari naŋgo are qametnjrqa osiq deqa anjam gargekoba naŋgi minjroqnej. A Qotei aqa anjam bole naŋgi minjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bati bei Jon na mandor Herot aqa une qa ŋiriŋtej. Aqa une agi a na aqa segi was aqa ŋauŋ Herodias yaiyosiq ej. Une deqa ti kumbra uge uge kalil Herot a yoqnej qaji deqa ti Jon na ŋiriŋtej. ");
INSERT INTO boj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Deqa Herot a olo kumbra uge bei dego yej. Aqa kumbra uge bei agiende. A Jon ojsiqa tonto talq di waiyej. ");
INSERT INTO boj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ariya tamo uŋgasari kalil naŋgi yanso eqnabqa Yesus a dego yanso ej. Yanso osiqa bati deqa a tarosiq laŋ goge koqyosiq Qotei pailyeqnaqa laŋ waqej. ");
INSERT INTO boj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Laŋ waqonaqa Mondor Bole a binoŋ bulosiq aisiqa Yesus aqa jejamuq di awoej. Awoonaqa laŋ goge na Qotei aqa anjam bei endegsi brantej, “Ni ijo segi aŋgro qujai. E ni tulaŋ qalaqalaimeqnum. E ni qa tulaŋ areboleboleibeqnu.” ");
INSERT INTO boj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus aqa wausau 30 kereonaqa aqa wau utru atej. Naŋgi Yesus qa endegsib maroqneb, “A Josep aqa ŋiri.” Yesus aqa moma naŋgo ñam kalil agi marqai. Josep a Heli aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli a Matat aqa ŋiri. Matat a Livai aqa ŋiri. Livai a Melki aqa ŋiri. Melki a Janai aqa ŋiri. Janai a Josep aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep a Matatias aqa ŋiri. Matatias a Amos aqa ŋiri. Amos a Nahum aqa ŋiri. Nahum a Esli aqa ŋiri. Esli a Nagai aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai a Mat aqa ŋiri. Mat a Matatias aqa ŋiri. Matatias a Semen aqa ŋiri. Semen a Josek aqa ŋiri. Josek a Joda aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda a Joanan aqa ŋiri. Joanan a Resa aqa ŋiri. Resa a Serubabel aqa ŋiri. Serubabel a Sealtiel aqa ŋiri. Sealtiel a Neri aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri a Melki aqa ŋiri. Melki a Adi aqa ŋiri. Adi a Kosam aqa ŋiri. Kosam a Elmadam aqa ŋiri. Elmadam a Er aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er a Josua aqa ŋiri. Josua a Elieser aqa ŋiri. Elieser a Jorim aqa ŋiri. Jorim a Matat aqa ŋiri. Matat a Livai aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai a Simeon aqa ŋiri. Simeon a Juda aqa ŋiri. Juda a Josep aqa ŋiri. Josep a Jonam aqa ŋiri. Jonam a Eliakim aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim a Melea aqa ŋiri. Melea a Mena aqa ŋiri. Mena a Matata aqa ŋiri. Matata a Natan aqa ŋiri. Natan a Devit aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit a Jesi aqa ŋiri. Jesi a Obet aqa ŋiri. Obet a Boas aqa ŋiri. Boas a Salmon aqa ŋiri. Salmon a Nason aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason a Aminadap aqa ŋiri. Aminadap a Atmin aqa ŋiri. Atmin a Arni aqa ŋiri. Arni a Hesron aqa ŋiri. Hesron a Peres aqa ŋiri. Peres a Juda aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda a Jekop aqa ŋiri. Jekop a Aisak aqa ŋiri. Aisak a Abraham aqa ŋiri. Abraham a Tera aqa ŋiri. Tera a Nahor aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor a Seruk aqa ŋiri. Seruk a Reu aqa ŋiri. Reu a Pelek aqa ŋiri. Pelek a Eber aqa ŋiri. Eber a Sela aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela a Kainan aqa ŋiri. Kainan a Arpaksat aqa ŋiri. Arpaksat a Siem aqa ŋiri. Siem a Noa aqa ŋiri. Noa a Lamek aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek a Metusela aqa ŋiri. Metusela a Enok aqa ŋiri. Enok a Jaret aqa ŋiri. Jaret a Mahalalel aqa ŋiri. Mahalalel a Kenan aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan a Enos aqa ŋiri. Enos a Set aqa ŋiri. Set a Adam aqa ŋiri. Adam a Qotei aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Mondor Bole a Yesus aqa jejamuq di awoonaqa a Jordan yaq dena olo pulueqnaqa Mondor na a wadau sawaq osi gilej. Osi gilsiq uratonaqa bati 40 a di laqnej. Di laqnaqa Satan bosiqa Yesus a une bei atqa marsiqa walawalaiyoqnej. Bati deqa Yesus a iŋgi uratoqnsiqa qurieŋ ti soqnej. Bati 40 koboonaqa a mamyej. ");
INSERT INTO boj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Onaqa Satan na minjej, “Ni Qotei aqa Ŋiriamqa meniŋ kalil endi minjrim bem bulyibqa ni uye.” ");
INSERT INTO boj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Degsi minjnaqa Yesus na kamba minjej, “Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Tamo naŋgi iŋgi uyo na segi ŋambile sqasai.’” ");
INSERT INTO boj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Onaqa Satan a Yesus olo osiqa mana goge kobaq oqsiq dia Yesus tigeltosiqa sawa sawa kalil mandor kokba naŋgi na taqatejunub qaji di Yesus osoryej. ");
INSERT INTO boj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Osoryosiqa minjej, “Sawa sawa kalil di naŋgo siŋgila ti ñoro ti ni emqai. Sawa sawa kalil di ijo. Qotei na nami ebej. Deqa e na tamo bei yqa are soqnim yqai. ");
INSERT INTO boj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Deqa ni ijo ulatamuq endi siŋga pulutosim e qa louimqa sawa sawa kalil di ni emqai.” ");
INSERT INTO boj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Onaqa Yesus na minjej, “Nami Qotei aqa anjam bei endegsib neŋgreŋyeb unu, ‘Ino Tamo Koba Qotei a segi qa louoqnsimqa aqa sorgomq di soqne.’” ");
INSERT INTO boj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Onaqa Satan na Yesus olo osiqa Jerusalem gilsiq atra tal quraq oqsiq goge dia Yesus atsiqa minjej, “Ni Qotei aqa Ŋiriamqa endena prugosim mandamq aiye. ");
INSERT INTO boj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Agi Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Qotei na aqa laŋ aŋgro naŋgi minjrimqa bosib ni taqatmqab.’ ");
INSERT INTO boj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Anjam bei dego neŋgreŋq di unu. Anjam agiende, ‘Laŋ aŋgro naŋgi bosib baŋ na ni soqtmibqa ino siŋga meniŋ na qalqasai.’” ");
INSERT INTO boj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Onaqa Yesus na kamba Satan minjej, “Qotei aqa anjam bei dego neŋgreŋq di unu. Anjam agiende, ‘Ni ino Tamo Koba Qotei aqa siŋgila laŋa tenemtqa osim a gisaŋyaim.’” ");
INSERT INTO boj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan a kumbra kalil dena Yesus uneq waiyqa yonaq ugeiyonaqa a uratosiq ulaŋej. Bunuqna a na olo Yesus walawalaiyqa marsiqa tariŋosiq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Qotei aqa Mondor aqa siŋgila Yesus aqaq di soqnej deqa a olo puluosiqa Galili sawaq aiyej. Aisiq di sonaqa qure kalilq di tamo uŋgasari naŋgi a qa saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A bati gaigai Juda naŋgo Qotei tal miligiq giloqnsiqa tamo uŋgasari naŋgi Qotei aqa anjam minjreqnaqa naŋgi quoqnsib aqa ñam soqtoqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Onaqa Yesus a dena walwelosiq Nasaret qureq aiyej. Di aqa qure utru. A dia boleej. Aisiq di sosiqa yori bationaqa aqa kumbra gaigai yoqnej qaji di dauryosiqa Juda naŋgo Qotei tal miligiq gilsiqa Qotei aqa anjam sisiyqa osiq tigelej. ");
INSERT INTO boj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Onaqa buk Baibel yonabqa a na waqtosiqa Qotei aqa medabu o tamo Aisaia aqa anjam nami neŋgreŋyej qaji mutu bei itosiq endegsi sisiyej, ");
INSERT INTO boj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tamo Koba aqa Mondor ijoq di unu deqa a na e giltbosiqa merbej, ‘Ni na tamo uŋgasari sougetejunub qaji naŋgi ijo anjam bole minjroqne.’ Osiqa a na e qariŋbosiq merbej, ‘Ni na tamo uŋgasari ŋam qandimo unub qaji naŋgi boletnjroqne. Osim tamo uŋgasari naŋgo segi une na ojejunu qaji naŋgi gereinjroqne. Osim tamo uŋgasari jeu tamo naŋgi na ugeugeinjreqnub qaji naŋgi aqaryainjroqne. ");
INSERT INTO boj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Osim anjam endegsi palontoqne, “Tamo Koba a na tamo uŋgasari naŋgi boletnjrqajqa bati brantqo.” ’” ");
INSERT INTO boj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus a anjam degsi sisiyosiq koboonaqa buk Baibel kabutosiqa Qotei tal taqato tamo yosiq a olo awoej. Onaqa tamo uŋgasari kalil Qotei tal miligiq di soqneb qaji naŋgi Yesus koqyesoqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Onaqa Yesus na naŋgi minjrej, “Qotei aqa anjam e endego sisiyonum niŋgi quonub qaji di aqa damu agi bini brantqo.” ");
INSERT INTO boj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Degsi minjrnaqa naŋgi kalil aqa anjam di qusib mareb, “Yesus aqa anjam di bolequja.” Osib olo areqalo kobaiyoqnsib maroqneb, “Yesus a Josep aqa ŋiri. Deqa a powo qabe na osiqa anjam bole endeqaji palontosiq mergeqnu?” ");
INSERT INTO boj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Onaqa Yesus na minjrej, “Niŋgi yawo anjam endegsib merbqab kiyo, ‘O yu qaŋgra tamo, ni ino segi jejamu gereiye.’ Osib niŋgi endegsib merbqab, ‘Kaperneam qureq di ni maŋwa babteqnam iga deqa queqnum. Maŋwa kere dego ni ino segi qure utruq endi babtim iga unqom.’” ");
INSERT INTO boj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Osiqa Yesus a olo endegsi minjrej, “E bole merŋgwai. Qotei aqa medabu o tamo bei aqa segi qure utruq gilsim anjam minjroqnqas di naŋgi aqa anjam quetqa asginjrqas. Deqa a ñam saiqoji sqas. ");
INSERT INTO boj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E bole merŋgwai. Elaija aqa bati qa laŋ geteŋesonaqa wausau qalub bai 6 gilsiq awa bosaioqnej. Deqa sawa sawa kalilq di naŋgi mam koba eb. Bati deqa Israel sawaq di uŋa qobul gargekoba soqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sonabqa Qotei na Elaija naŋgoq qariŋyosai. A na Elaija qariŋyonaqa Saidon sawaq gilsiq Sarefat qureq di uŋa qobul bei aqaq di segi brantosiq aqaryaiyej. ");
INSERT INTO boj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Qotei aqa medabu o tamo Elisa dego aqa bati qa tamo gargekoba naŋgo jejamu yu na ugeeleŋej qaji naŋgi Israel sawaq di soqneb. Ariya Elisa a naŋgi boletnjrosai. A Siria sawaq gilsiq dia tamo bei yu na aqa jejamu ugeeleŋej qaji aqa ñam Naman a segi boletej.” ");
INSERT INTO boj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Yesus na tamo uŋgasari Qotei tal miligiq di soqneb qaji naŋgi anjam degsi minjrnaqa naŋgi kalil qusibqa minjiŋ ani oqetnjrnaqa tigelosib Yesus ojsib tututosib qure qalaq osi gileb. Naŋgo qure mana goge di soqnej deqa naŋgi Yesus mana goge dena waiyqa mareb. ");
INSERT INTO boj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Onaqa a naŋgo ambleq na loumosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Onaqa Yesus a Kaperneam qureq gilej. Qure di Galili sawaq di unu. Gilsiq di sosiqa yori batieqnaqa tamo uŋgasari naŋgi Qotei aqa anjam plaltoqnsiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yesus aqa anjam maroqnej di siŋgila ti. A segi anjam di aqa Abu. Deqa tamo uŋgasari kalil naŋgi aqa anjam di quoqnsib tulaŋ prugugetoqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yori bati bei tamo mondor uge na ojej qaji a Qotei tal miligiq di soqnej. Deqa a tulaŋ leleŋosiqa Yesus minjej, ");
INSERT INTO boj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O Yesus Nasaret qaji tamo, ni iga kiyergwajqa bonum? Ni iga padaltgwa bonum e? E ni qalie. Ni Qotei aqa segi Ŋiri bolequja. Ino jejamuq di une bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mondor uge dena Yesus degsi minjnaqa a siŋgila na ŋiriŋtosiq minjej, “Ni medabu getentosim tamo di uratosim ulaŋ.” Onaqa mondor uge dena tamo di uratqa osiqa tamo uŋgasari naŋgo ambleq di a waiyonaq mandamq di ŋeiesonaqa uratosiq ulaŋej. Tamo di aqa jejamu yala ugetosai. A bole soqnej. ");
INSERT INTO boj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsibqa naŋgi tulaŋ prugugetosib segi segi maroqneb, “Yesus a anjam bunuj mareqnu. Aqa anjam bunuj di siŋgila ti mareqnu. Agi a na mondor uge naŋgi anjam minjreqnaqa naŋgi aqa anjam dauryoqnsib jaraiyeqnub.” ");
INSERT INTO boj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tamo uŋgasari naŋgi degsib maroqnsib olo walwelosib sawa sawa kalilq di Yesus aqa maŋwa deqa saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Onaqa Yesus a tigelosiqa Qotei tal uratosiq Saimon aqa ñam bei Pita aqa tal gogetej. Tal gogetosiqa Saimon aqa mimibe makobaiyonaqa jejamu kaŋkaŋyonaq unej. Deqa Yesus aqa aŋgro naŋgi na minjeb, “Ni a boletime.” ");
INSERT INTO boj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Onaqa Yesus a gilsiq uŋa maiyej qaji aqa areq di tigelosiqa anjam segi minjnaqa aqa jejamu kaŋkaŋ di koboej. Onaqa uŋa a tigelosiqa naŋgi iŋgi goiyetnjrej. ");
INSERT INTO boj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Seŋ aiqa laqnaqa tamo uŋgasari ma utru segi segi so qaji naŋgo was naŋgi na joqoqnsib Yesus aqa areq boqneb. Beqnabqa Yesus na aqa baŋ naŋgo gateq di ateqnaqa naŋgo ma koboeqnaqa naŋgi jaraiyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mondor uge gargekoba dego Yesus na winjreqnaqa naŋgi olo tamo uŋgasari naŋgi uratnjroqnsib jaraiyoqneb. Jaraiyoqnsib tulaŋ leleŋoqnsib Yesus minjoqneb, “Ni Qotei aqa Ŋiri.” Yeqnabqa Yesus a siŋgila na saidnjroqnej, “Niŋgi ijo ñam ubtosib maraib.” Degsi saidnjroqnej. Di kiyaqa? Naŋgi qalie, Yesus a Kristus. ");
INSERT INTO boj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Onaqa nobqolo ambru Yesus na tamo uŋgasari naŋgi alelnjrsiqa qure di uratosiq wadau sawaq gilej. Gilsiq di sonaqa naŋgi a qa ŋamosib gilsib itosib minjeb, “Ni iga uratgaim.” ");
INSERT INTO boj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Onaqa Yesus na minjrej, “E qure bei beiq dego giloqnsiyqa Qotei aqa anjam bole endegsi minjroqnqai, ‘Niŋgi are bulyibqa Qotei a nuŋgo Mandor Koba sosim niŋgi taqatŋgwas.’ Degsi minjroqnqai. Qotei a deqa e qariŋbonaq mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yesus na tamo uŋgasari naŋgi degsi minjrsiqa naŋgi uratnjrsiq gilsiq Judia sawaq di walweloqnsiqa Juda naŋgo Qotei tal miligiq giloqnsiqa Qotei aqa anjam palontoqnej. ");
INSERT INTO boj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bati bei Yesus a Genesaret ya agu kobaqujaq gilsiqa alile dia tigelesonaqa tamo uŋgasari tulaŋ gargekoba naŋgi Qotei aqa anjam quqwajqa are qalsibqa Yesus aqa areq bosib koroeb. ");
INSERT INTO boj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Koroesonabqa Yesus a ŋam atsiqa qobuŋ aiyel alile di tiryosib sonab unjrej. Qe o qaji tamo naŋgi qobuŋ dena mandamq aisib naŋgo kakaŋ yansoqneb. ");
INSERT INTO boj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Qobuŋ bei Saimon aqa qobuŋ. Yesus a Saimon aqa qobuŋ gogetosiq di awoosiqa Saimon minjej, “Qobuŋ tututim kiñala sasalem.” Onaqa Saimon na qobuŋ tututonaq sasalonaqa Yesus a qobuŋ miligiq di awoosiqa tamo uŋgasari kalil naŋgi alile di sonabqa Qotei aqa anjam plaltosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Anjam minjrsiq koboonaqa a na Saimon minjej, “Niŋgi qobuŋ oyoosib ya robuq oqsib nuŋgo kakaŋ waiyqab qe oqab.” ");
INSERT INTO boj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Onaqa Saimon na kamba minjej, “O Tamo Koba, iga qolo waukobaonum gilsiq nebeqo. Iga qe bei yala osai. Di uŋgum. Ni maronum deqa e kakaŋ olo waiyqai.” ");
INSERT INTO boj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Onaqa qe o qaji tamo naŋgi ya robuq oqsib kakaŋ olo waiyosib qe tulaŋ ani eb. Qe ani onabqa naŋgo kakaŋ qe na maqej deqa braŋqa laqnaqa titqa keresaiinjrej. Deqa naŋgi na naŋgo was qudei qobuŋ beiq di soqneb qaji naŋgi metnjrnab bosib koba na kakaŋ titosib qe osib qobuŋ aiyel miligiq di jugonab maqosib tugwa laqneb. ");
INSERT INTO boj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Onaqa Saimon aqa ñam bei Pita a Yesus aqa maŋwa di unsiqa aqa siŋgaq di siŋga pulutosiq minjej, “O Tamo Koba, e une tamo. Deqa ni e uratbosim gile.” ");
INSERT INTO boj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon na Yesus degsi minjej. Di kiyaqa? Aqa was naŋgi ti qe tulaŋ koba eleŋosib prugugeteb deqa. ");
INSERT INTO boj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi aqa ŋiri aiyel Jems Jon wo naŋgi Saimon ombla wau qujai. Naŋgi dego Yesus aqa maŋwa di unsibqa tulaŋ prugeb. Onaqa Yesus na Saimon minjej, “Ni ulaaim. Ni qe o tamo unum deqa ni qe eqnum. Bunuqna ni degsim olo tamo oqnqam.” ");
INSERT INTO boj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Onaqa naŋgi naŋgo qobuŋ alile dia atsib naŋgo ai abu naŋgi uratnjrsib naŋgo ñoro ti iŋgi iŋgi kalil ti uratosib Yesus dauryeb. ");
INSERT INTO boj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naŋgi Yesus dauryosib bati bei naŋgi koba na qure beiq gileb. Dia tamo bei yu na aqa jejamu ugeeleŋej qaji a Yesus unsiqa aqa areq bosiqa siŋga pulutosiqa mandamq di ŋam quosiqa Yesus pailyosiq minjej, “O Tamo Koba, ni e boletbqa are soqnim e boletbe. E qalie, ni e boletbqa kere.” ");
INSERT INTO boj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Degsi minjnaqa Yesus a baŋ waiyosiq tamo di aqa jejamu ojej. Ojsiqa minjej, “E ni boletmqa are unu. Deqa ino jejamu olo boleeme.” Onaqa bati qujai deqa aqa yu uge kalil mosoosiq aqa jejamu boleej. ");
INSERT INTO boj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Onaqa Yesus na minjej, “Ino jejamu boleqo deqa ni tigelosim gile. Ni tamo qudei naŋgi ijo ñam ubtosim minjraim. Ni gilsim ino jejamu atra tamo osoryosim atraiyqajqa iŋgi iŋgi Moses a nami marej qaji di osim Qotei atraiyime. Yimqa tamo uŋgasari naŋgi ni numsib marqab, ‘Bole, ino jejamu boleqo.’” ");
INSERT INTO boj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Onaqa a gilsiqa ariya a Yesus aqa anjam di dauryosai. Yesus na a boletej deqa mare mare laqnaqa aqa anjam tulaŋ kobaosiqa sawa sawa kalil keretej. Deqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus aqa anjam quqwajqa ti a na naŋgo ma boletetnjrqajqa ti are qalsibqa boqnsib aqa areq di korooqneb. ");
INSERT INTO boj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ariya bati gargekoba Yesus a tamo uŋgasari naŋgi alelnjroqnsiq wadau sawaq giloqnsiqa dia a segi sosiq Qotei pailyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","18","Bati bei tamo uŋgasari naŋgi olo koroesonabqa Yesus a Qotei aqa anjam palontoqnsiq minjroqnej. Minjreqnaqa bati di Farisi naŋgi ti dal anjam qalie tamo naŋgi ti bosib Yesus aqa areq di awesoqneb. Naŋgi Galili sawa ti Judia sawa ti naŋgo qure qureq dena beleŋeb. Naŋgi Jerusalem dena dego beleŋeb. Tamo Koba Qotei aqa siŋgila Yesus aqaq di soqnej deqa a na tamo uŋgasari naŋgo ma boletetnjrqajqa wauoqnej. Onaqa tamo qudei naŋgi tamo bei jejamu laiyej qaji a saperaq di ŋeiotosib Yesus aqa areq di atqa marsibqa qoboiyosib beb. ");
INSERT INTO boj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bosib ŋam ateb di tamo tulaŋ gargekoba siraŋmeq di jujuŋeb. Deqa naŋgi Yesus aqa areq gilqa keresaiinjrnaqa tal quraq oqsib goge na waqtosibqa tamo sapera qoji gulaintosib ura uratonab Yesus aqa areq aiyej. ");
INSERT INTO boj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Onaqa Yesus a naŋgo areqalo unej di naŋgo areqalo qujai Yesus na tamo jejamu laiyej qaji di boletqa kere. Deqa a na tamo di minjej, “O ijo was, ino une kalil e na kobotetmonum.” ");
INSERT INTO boj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Onaqa dal anjam qalie tamo naŋgi ti Farisi naŋgi ti tal dia awesoqneb qaji naŋgi Yesus aqa anjam di qusibqa naŋgo areqalo na mareb, “Yesus a Qotei misiliŋyqo. Yai na tamo naŋgo une kobotqa kere? Qotei a segi qujai.” ");
INSERT INTO boj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naŋgi degsib are qaleqnabqa Yesus a naŋgo areqalo di qalieosiqa minjrej, “Niŋgi kiyaqa degsib are qaleqnub? ");
INSERT INTO boj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Anjam kiye e na tamo jejamu laiyqo qaji di minjit niŋgi qusib e qa poiŋgwas? ‘Ino une kalil e na kobotetmonum,’ anjam de kiyo, ‘Ni tigelosim walwel,’ anjam de kiyo? ");
INSERT INTO boj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","E segi Tamo Aŋgro. E mandamq endi siŋgila ti unum deqa e na tamo naŋgo une kobotetnjrqa kere. Niŋgi degsi poiŋgwajqa deqa e na tamo di boletqai.” Yesus a naŋgi degsi minjrsiqa tamo jejamu laiyej qaji di koqyosiqa minjej, “E ni mermqai. Ni tigelosim ino sapera osim ino talq gile.” ");
INSERT INTO boj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Degsi minjnaqa a tamo uŋgasari kalil naŋgo ŋamdamuq di tigelosiqa aqa sapera ŋeiesoqnej qaji di qoboiyosiqa Qotei aqa ñam soqtosiqa walwelosiq aqa talq gilej. ");
INSERT INTO boj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Onaqa tamo uŋgasari kalil naŋgi Qotei aqa maŋwa di unsibqa naŋgi tulaŋ prugugetosib Qotei aqa ñam soqtosib a biŋiyeb. Osib naŋgi ulaosib mareb, “Maŋwa iga endego unonum di kumbra bei. Tamo qudei na maŋwa deqaji yeqnab iga nami unosaioqnem.” ");
INSERT INTO boj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus a dena walwelosiqa takis o qaji tamo bei aqa ñam Livai a takis o talq di awesonaq gilsiq itej. Itosiqa minjej, “Ni e daurbe.” ");
INSERT INTO boj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Onaqa a na aqa iŋgi iŋgi kalil uratosiqa tigelosiq Yesus dauryej. ");
INSERT INTO boj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Osiqa bati bei Livai a maruro atsiqa takis o qaji tamo tulaŋ gargekoba naŋgi ti Yesus aqa segi aŋgro naŋgi ti tamo laŋa laŋaj naŋgi ti metnjrnaq bosib koba na awoosib iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Onaqa Farisi naŋgi ti dal anjam qalie tamo naŋgi ti bosib kumbra di unsibqa Yesus aqa aŋgro naŋgi ŋiriŋtnjrsib minjreb, “Niŋgi kiyaqa takis o qaji tamo ti une tamo ti naŋgi koba na awoosib iŋgi ti ya ti uyeqnub?” ");
INSERT INTO boj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Onaqa Yesus a naŋgo anjam di qusiqa minjrej, “Tamo ma saiqoji naŋgi yu qaŋgra tamo aqaq gilosaieqnub. Tamo ma ti naŋgi segi yu qaŋgra tamo aqaq gileqnub. ");
INSERT INTO boj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tamo bei a marqas, ‘E tamo bole. E une saiqoji.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyosai. Tamo a marqas, ‘E une ti.’ E tamo deqaji naŋgi metnjrit ijoq bqajqa deqa mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Onaqa Farisi naŋgi na olo Yesus minjeb, “Jon aqa aŋgro naŋgi bati gaigai iŋgi uratoqnsib qurieŋoqnsib Qotei pailyoqnsib unub. Farisi naŋgo aŋgro naŋgi dego kumbra degyeqnub. Ariya ino aŋgro naŋgi kiyaqa qurieŋosaieqnub? Agi naŋgi bati gaigai iŋgi ti ya ti uyoqnsib unub.” ");
INSERT INTO boj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Onaqa Yesus a naŋgo anjam di qusiqa a kamba yawo anjam bei endegsi minjrej, “Tamo bei a uŋa baŋ ojqa bati qa aqa was naŋgi ti soqnibqa naŋgi qurieŋqab e? Sai. ");
INSERT INTO boj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bunuqna naŋgo was a naŋgi uratnjrimqa bati deqa naŋgi qurieŋoqnsib sqab.” ");
INSERT INTO boj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Osiqa Yesus a olo yawo anjam bei endegsi minjrej, “Tamo bei a gara jugo bunuj osim dena mutu gentosim gara jugo sari braŋoq di qandimqa keresai. Degsi qandimqas di a na gara jugo bunuj di ugeugeiyqas. Amqa gara sari aqa uno bolesaiqas. Di kiyaqa? Gara sari ti gara bunuj ti kerekereqasai. ");
INSERT INTO boj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tamo bei a wain bunuj osim ya nobu sariq di qamqa keresai. Ya nobu sari di nami kaŋgraŋosiq siŋgilaej. Deqa a wain bunuj qamimqa wain a didiqosim ya nobu sari paratosimqa wain bileŋosim mandamq aiqas. Ya nobu a dego ugeqas. ");
INSERT INTO boj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A ya nobu bunujq di wain bunuj qamimqa ombla bole sqab. ");
INSERT INTO boj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tamo bei a wain namij uysimqa a olo wain bunuj uyqasai. Di kiyaqa? A marqas, ‘Namij di bole.’” ");
INSERT INTO boj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yori bati bei Yesus aqa aŋgro naŋgi ti wau ambleq na giloqnsibqa aqa aŋgro naŋgi bem sum gei eleŋoqnsib baŋ na ñoqoryoqnsib uye uye giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naŋgi degsib gileqnabqa Farisi qudei naŋgi bosib naŋgi unjrsib minjreb, “Niŋgi kiyaqa kumbra degyeqnub? Yori bati qa kumbra degyo di getento koba.” ");
INSERT INTO boj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Onaqa Yesus na kamba Farisi naŋgi minjrej, “Nami Devit aqa wau tamo naŋgi ti mamnjrnaqa kumbra yeb qaji di niŋgi buk miligiq di sisiyosai kiyo? ");
INSERT INTO boj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit a atra tal miligiq gilsiqa Qotei atraiyqajqa bem uysiqa aqa wau tamo naŋgi dego anainjrnaq uyeb. Bem di getento. Di atra tamo naŋgo segi uyqajqa bem. Devit a degyej di a dal anjam grotej. Ariya a Qotei aqa ŋamgalaq di une saiqoji. Niŋgi anjam di sisiyosai kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Osiqa minjrej, “E Tamo Aŋgro. Deqa e segi na yori bati taqatejunum. E segi yori bati aqa Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Olo yori bati bei Yesus a Juda naŋgo Qotei tal miligiq gilsiqa Qotei aqa anjam plaltosiq minjroqnej. Qotei tal miligiq di tamo bei baŋ wo qandamyej qaji a soqnej. ");
INSERT INTO boj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Onaqa dal anjam qalie tamo naŋgi ti Farisi naŋgi ti Yesus koqyoqneb. Naŋgi are qaleb, “Yesus a yori bati qa tamo di boletqas kiyo? Yimqa minjqom, ‘Ni na yori bati grotonum.’” Deqa naŋgi Yesus koqyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","9","Onaqa Yesus a naŋgo areqalo di qalieosiqa tamo baŋ qandamyej qaji di minjej, “Ni tigelosim gago ambleq au.” Degsi minjnaqa a tigelosiq naŋgo ambleq bonaqa Yesus na Farisi naŋgi minjrej, “E niŋgi anjam bei nenemŋgwai. Iga yori bati qa kumbra bole yqom kiyo kumbra uge yqom kiyo? Tamo bei a padalqa laqnimqa iga na aqaryaiyonam bole sqas di kere kiyo iga a uratonam padalqas di kere kiyo? Dal anjam a kiyersi marqo?” ");
INSERT INTO boj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus na naŋgi kalil degsi minjrsiq koqnjrsiqa tamo baŋ qandamyej qaji di minjej, “Ni ino baŋ waiy.” Degsi minjnaqa aqa baŋ waiyonaq boleej. ");
INSERT INTO boj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Onaqa Farisi naŋgi Yesus aqa kumbra di unsibqa minjiŋ oqetnjrnaqa naŋgi Yesus kiyeryqajqa deqa qairoqneb. ");
INSERT INTO boj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bati deqa Yesus a segi Qotei pailyqa marsiq manaq oqej. Manaq oqsiq dia Qotei pailyeqnaqa nebeej. ");
INSERT INTO boj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nebeonaqa Yesus na tamo kalil a dauryosib laqneb qaji naŋgi metnjrnaqa aqa areq bonabqa naŋgo ambleq dena aŋgro 12 giltnjrej. Naŋgi a ombla sosib aqa anjam mare mare laqajqa deqa giltnjrej. ");
INSERT INTO boj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Naŋgo ñam agiende. Bei Saimon. Yesus na aqa ñam bei Pita waiyej. Naŋgi aqa was Andru wo. Bei Jems. Naŋgi aqa was Jon wo. Bei Filip. Bei Bartolomyu. ");
INSERT INTO boj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ariya Matyu Tomas wo. Bei Alfias aqa ŋiri Jems. Bei Saimon agi Rom naŋgi winjrqajqa maroqnej qaji. ");
INSERT INTO boj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ariya bei Jems aqa ŋiri Judas. Bei Judas Iskariot agi bunuqna Yesus osiqa jeu tamo naŋgo baŋq di atej qaji. ");
INSERT INTO boj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Onaqa Yesus na aqa aŋgro naŋgi di joqsiqa koba na manaq dena olo aiyeb. Aisib sawa guŋ dia sonabqa tamo uŋgasari gargekoba a dauryosib laqneb qaji naŋgi bosib aqa anjam quqwajqa ti a naŋgo ma boletetnjrqajqa ti koroeb. Tamo uŋgasari laŋa laŋaj gargekoba dego Judia sawa naŋgo qure qureq dena ti Jerusalem dena ti Tair qure wo Saidon qure wo naŋgo sawa alile jojom dena ti beleŋeb. Bonabqa Yesus a tamo kalil mondor uge uge na ojeleŋo qaji naŋgi boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aqa jejamuq na siŋgila gileqnaqa tamo ma ti kalil naŋgo ma kobooqnej. Deqa naŋgi kalil aqa jejamuq di naŋgo baŋ atqa maroqnsib baŋ waiyoqnsib ojoqneb. ");
INSERT INTO boj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Onaqa Yesus a bulosiqa aqa aŋgro naŋgi koqnjrsiqa endegsi minjrej, “Niŋgi bini sougetejunub qaji bunuqna Qotei a nuŋgo Mandor Koba sosim niŋgi taqatŋgwas. Deqa niŋgi tulaŋ areboleboleiŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Niŋgi bini mam unub qaji bunuqna kere na sqab. Deqa niŋgi tulaŋ areboleboleiŋgwas. “Niŋgi bini akam ti unub qaji bunuqna akam uratosib olo kikiqab. Deqa niŋgi tulaŋ areboleboleiŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Niŋgi e Tamo Aŋgro daurbeqnub deqa bunuqna tamo qudei na niŋgi jeutŋgoqnsib misiliŋgoqnsib nuŋgo ñam ugeugeiyoqnqab. Nami naŋgo moma naŋgi na Qotei aqa medabu o qaji tamo naŋgi degsib ugeugeinjroqneb. Naŋgi niŋgi ugeugeiŋgibqa, di uŋgum, niŋgi tulaŋ areboleboleiŋgem. Niŋgi quiy. Nuŋgo awai bole agi laŋ goge di unu. Bunuqna niŋgi oqsib awai di itqab. ");
INSERT INTO boj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ariya niŋgi bini ñoro koba ti unub qaji niŋgi ŋam atoqniy. Nuŋgo are boletetŋgwajqa iŋgi iŋgi agi niŋgi mandamq endi ekritonub deqa bunuqna niŋgi gulbe koba oqab. ");
INSERT INTO boj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Niŋgi bini iŋgi qa kere na unub qaji niŋgi dego ŋam atoqniy. Bunuqna niŋgi mam oqab. “Niŋgi bini kikieqnub qaji niŋgi dego ŋam atoqniy. Bunuqna niŋgi are ugeiŋgim akam ti sqab. ");
INSERT INTO boj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tamo kalil naŋgi na nuŋgo ñam soqtetŋgwab di uge. Deqa niŋgi ŋam atoqniy. Nami naŋgo moma naŋgi na dego gisaŋ anjam maro tamo naŋgo ñam soqtetnjroqneb. ");
INSERT INTO boj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Niŋgi ijo anjam endi queqnub qaji e na olo endegsi merŋgwai. Tamo qudei na niŋgi jeutŋgoqnibqa niŋgi kamba olo naŋgi jeutnjraib. Niŋgi naŋgi qa boleoqnsib qalaqalainjroqniy. ");
INSERT INTO boj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tamo qudei na niŋgi misiliŋgoqnibqa niŋgi kamba olo naŋgi misiliŋnjraib. Niŋgi anjam bole bole minjroqniy. Tamo qudei na niŋgi ugeugeiŋgoqnibqa niŋgi kamba olo naŋgi ugeugeinjraib. Niŋgi naŋgi qa Qotei pailyoqniy. ");
INSERT INTO boj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamo bei na ula poŋmimqa belosim waliŋe bei osoryimqa poŋyem. Tamo bei a ino gara jugo yaimimqa ni na saidyaim. Olo ino gara jugo bei dego ye. ");
INSERT INTO boj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tamo bei na ino iŋgi bei yaimqajqa mermimqa ye. Yosim a na kamba olo ni emqajqa minjaim. ");
INSERT INTO boj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kumbra bole bole tamo naŋgi na niŋgi eŋgwajqa arearetŋgeqnu qaji di niŋgi na olo naŋgi enjroqniy. ");
INSERT INTO boj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Tamo uŋgasari niŋgi qa boleeqnub qaji naŋgi qa segi niŋgi kamba boleoqnqab di kumbra bolesai. Dal anjam gotraŋyo qaji tamo naŋgi dego kumbra degyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tamo uŋgasari niŋgi geregereiŋgeqnub qaji naŋgi segi niŋgi na kamba geregereinjroqnqab di kumbra bolesai. Dal anjam gotraŋyo qaji tamo naŋgi dego kumbra degyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Niŋgi na tamo qudei naŋgi iŋgi bei enjrqa osibqa naŋgi kamba olo niŋgi eŋgwajqa minjrsib iŋgi enjrqab di kumbra tulaŋ bolesai. Dal anjam gotraŋyo qaji tamo naŋgi dego kumbra degyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Deqa niŋgi ijo anjam endi quiy. Tamo qudei na niŋgi jeutŋgoqnibqa niŋgi kamba olo naŋgi jeutnjraib. Niŋgi naŋgi qa boleoqnsib naŋgi qalaqalainjroqniy. Osib iŋgi bole bole enjroqnsib naŋgi na kamba olo niŋgi eŋgwajqa minjroqnaib. Niŋgi kumbra degyqab di niŋgi Qotei Goge Koba aqa aŋgro bole sosib awai tulaŋ boledamu oqab. Niŋgi qalie, tamo uŋgasari kumbra uge uge yoqnsib Qotei biŋiyqa urateqnub qaji naŋgi di Qotei na kamba kumbra uge uge enjrosaieqnu. A na naŋgi olo kumbra bole bole enjreqnu. Deqa niŋgi dego Qotei aqa kumbra di dauryosib tamo bole ti tamo uge ti naŋgi turtnjroqnsib kumbra bole bole enjroqniy. Niŋgi kumbra degyqab di niŋgi Qotei aqa aŋgro bole sqab. ");
INSERT INTO boj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nuŋgo Abu a tamo naŋgi qa duleqnu deqa niŋgi dego Qotei aqa kumbra di dauryosib tamo naŋgi qa duloqniy. ");
INSERT INTO boj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Niŋgi na tamo qudei naŋgi peginjraib. Niŋgi peginjrqasai di Qotei a kamba dego niŋgi pegiŋgwasai. Niŋgi na tamo qudei naŋgo jejamuq di une qametnjraib. Yimqa Qotei a kamba dego nuŋgo jejamuq di une qametŋgwasai. Niŋgi na tamo naŋgo une kalil taqal atetnjroqniy. Yimqa Qotei a dego nuŋgo une kalil taqal atetŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niŋgi na tamo naŋgi lueinjroqnsib iŋgi iŋgi enjroqniy. Yimqa Qotei a kamba dego niŋgi lueiŋgoqnsim iŋgi iŋgi eŋgoqnqas. Osim iŋgi iŋgi tulaŋ koba eŋgoqnsim nuŋgo mogomq di bilentoqnimqa ojqa keresaiiŋgoqnimqa bileŋoqnsib dobulq aiyoqnqab. Niŋgi tamo naŋgi kumbra enjroqnqab kere dego Qotei a kamba niŋgi kumbra eŋgoqnqas.” Yesus na aqa aŋgro naŋgi anjam degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Osiqa Yesus a olo yawo anjam bei endegsi minjrej, “Tamo bei ŋam qandimo unu qaji a na tamo bei dego ŋam qandimo unu qaji di gam osoryqa keresai. A na aqa baŋ ojsim ombla walwelqab di ombla maŋgalsib subq aiqab. ");
INSERT INTO boj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul aŋgro na aqa qalie tamo a buŋyqa keresai. A kobaqujaosimqa di aqa qalie tamo ombla kerekereqab. ");
INSERT INTO boj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kiyaqa ni ino was aqa ŋamdamuq di ŋam ñeŋgi kiñala unu di unsimqa ino segi ŋamdamuq di ŋampaŋ kobaquja unu di ni unosai? ");
INSERT INTO boj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kiyaqa ino segi ŋamdamuq di ŋampaŋ kobaquja soqnimqa ni na tentosim ino was minjqam, ‘Was, e ino ŋamdamuq di ŋam ñeŋgi kiñala unonum di osiy taqal waiyetmqai’? Kiyaqa ni degsi minjqam? Kiyaqa ŋampaŋ kobaquja ino segi ŋamdamuq di unu qaji di ni unosai? Ni gisaŋ tamo. Ni mati ŋampaŋ kobaquja ino segi ŋamdamuq di unu qaji di taqal waiyosim ŋamdamu suwaŋmimqa ariya degam ŋam ñeŋgi kiñala ino was aqa ŋamdamuq di unu qaji di geregere unsim taqal waiyete.” ");
INSERT INTO boj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Osiqa Yesus a olo marej, “Ŋam bole naŋgi gei bole ateqnub. Naŋgi gei uge atosaieqnub. Ŋam uge naŋgi gei uge ateqnub. Naŋgi gei bole atosaieqnub. ");
INSERT INTO boj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Deqa tamo naŋgi ŋam aqa gei unsibqa dena naŋgi poinjrqas, ‘Ŋam di bole. Ŋam di uge.’ Niŋgi maŋ luwit mariŋq dena qura gei osib uyosaieqnub. Sil luwit mariŋq dena wain gei osib uyosaieqnub. ");
INSERT INTO boj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dego kere tamo bole naŋgo are miligiq di areqalo bole na maqejunu. Deqa naŋgi kumbra bole yeqnub. Ariya tamo uge naŋgo are miligiq di areqalo uge na maqejunu. Deqa naŋgi kumbra uge yeqnub. Tamo naŋgo areqalo kalil naŋgo are miligiq na oqoqnsiq medabuq na branteqnu.” ");
INSERT INTO boj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Osiqa Yesus a olo marej, “Kiyaqa niŋgi ‘O Tamo Koba, O Tamo Koba’ e degsib metboqnsib olo ijo anjam dauryosaieqnub? ");
INSERT INTO boj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Niŋgi quiy. Tamo uŋgasari naŋgi ijoq bosib ijo anjam qusib dauryqab di naŋgi tal gereiyo tamo bul sqab. Tal gereiyo tamo di a tal utru atqa osiqa tal ai sub bogeleŋosiq guma koba aiyeleŋosiq meniŋ iteleŋej. Bunuqna awa koba bosimqa ya meli dosim tal di qamsim putqasai. Siŋgila na tigelesqas. Di kiyaqa? A meniŋ quraq di tal atej deqa. ");
INSERT INTO boj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ariya tamo uŋgasari naŋgi ijo anjam qusib olo dauryqa uratqab di naŋgi tamo bei laŋa sub gogeq di aqa tal atej qaji a bul sqas. Tal atnaq sonaqa awa koba bosiqa ya meli dosiqa tal di qamsiq reŋgiŋtosiq putonaq aisiq tulaŋ niñaqej.” ");
INSERT INTO boj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus a anjam kalil degsi marnaqa tamo uŋgasari naŋgi qunabqa a naŋgi uratnjrsiqa Kaperneam qureq aiyej. ");
INSERT INTO boj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dia qaja tamo gate bei soqnej. A Rom tamo. Aqa kaŋgal tamo a tulaŋ qalaqalaiyoqnej qaji di makobaiyosiqa moiqa laqnej. ");
INSERT INTO boj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Deqa tamo qudei na qaja tamo gate di minjeb, “Yesus a bqo Kaperneam endi unu.” Degsi minjnab quej. Qusiqa Juda gate qudei naŋgi Yesus minjib bosim aqa kaŋgal tamo boletqajqa deqa qariŋnjrnaq gileb. ");
INSERT INTO boj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gilsib Yesus itosib siŋgila na pailyosib minjeb, “O Tamo Koba, ni iga uratgaim. Qaja tamo gate di a tamo bolequja. ");
INSERT INTO boj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","A Juda kalil naŋgi qa tulaŋ boleoqnsiqa gaigai geregereinjreqnu. Agi a na gago Qotei tal gereiyej.” ");
INSERT INTO boj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naŋgi degsib Yesus minjnab qusiqa tigelosiq naŋgi daurnjrsiq koba na aiyeb. Aisib tal jojomyqa laqnabqa qaja tamo gate dena aqa was qudei naŋgi olo qariŋnjrnaq gilsib gamq di Yesus turosib minjeb, “O Tamo Koba, gago was a marqo, ‘Uŋgum, ni laŋa waukobaaim. E tamo bolesai deqa ni ijo talq baim. ");
INSERT INTO boj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E dego ino areq bqa keresai. Deqa ni anjam segi marimqa ijo kaŋgal tamo a boleqas. ");
INSERT INTO boj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","E dego tamo kokba qudei naŋgo sorgomq di unum. Ijo qaja tamo naŋgi ijo sorgomq di unub. E bei minjqai, “Ni gile.” Yimqa a gilqas. Bei minjqai, “Ni au.” Yimqa a bqas. Ijo kaŋgal tamo bei minjqai, “Wau di ye.” Degsi minjitqa a ijo anjam dauryqas.’” ");
INSERT INTO boj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Onaqa Yesus a anjam di qusiqa tulaŋ prugugetej. Osiqa bulosiq tamo uŋgasari gargekoba a dauryoqneb qaji naŋgi minjrej, “E niŋgi endegsi merŋgwai. Qaja tamo gate di a e qa aqa areqalo tulaŋ siŋgilatqo. Israel tamo nami e qa degsi aqa areqalo siŋgilato qaji bei unosai.” ");
INSERT INTO boj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Onaqa qaja tamo gate aqa was naŋgi a na qariŋnjrej qaji naŋgi olo puluosib aqa talq gilsib kaŋgal tamo di a boleosiq sonaq uneb. ");
INSERT INTO boj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Olo bati bei Yesus a qure beiq aiyej. Qure di aqa ñam Nain. Tamo uŋgasari gargekoba naŋgi Yesus aqa aŋgro ti koba na aiyeb. ");
INSERT INTO boj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus a qure polomq di branteqnaqa tamo bei nami moiyej qaji a subq atqajqa qoboiyosib giloqneb. Tamo di aqa ai qobulej. Aqa aŋgro qujai bole qujai agi a segi. Aŋgro di qoboiyosib gileqnabqa tamo uŋgasari tulaŋ gargekoba qure dia soqneb qaji naŋgi uŋa di koba na walwelosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Onaqa Tamo Koba a uŋa di unsiqa a qa tulaŋ dulosiqa minjej, “Ni akamaim.” ");
INSERT INTO boj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Degsi minjsiq walwelosiqa baŋ waiyosiq kulum aŋgro jigeb qaji di ojnaqa tamo naŋgi a qoboiyosib giloqneb qaji tigeleb. Onaqa Yesus na aŋgro moiyej qaji di minjej, “O aŋgro, e ni mermqai, ni tigel.” ");
INSERT INTO boj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Degsi minjnaqa a tigelosiq awoosiq anjam maroqnej. Onaqa Yesus na a baŋ ojsiqa osi gilsiqa aqa ai yej. ");
INSERT INTO boj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Onaqa tamo uŋgasari kalil qure dia soqneb qaji naŋgi Qotei aqa maŋwa di unsibqa naŋgi tulaŋ prugugetosib Qotei aqa ñam soqtosib maroqneb, “Bole, bini Qotei aqa medabu o qaji tamo kobaquja a gago ambleq endi brantqo. Qotei na aqa segi tamo uŋgasari naŋgi aqaryainjrqajqa deqa tamo di qariŋyqo bqo.” ");
INSERT INTO boj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesus a maŋwa di yonaqa tamo uŋgasari naŋgi unsib deqa mare mare laqnab Judia sawaq di, sawa bei beiq di naŋgi quekriteb. ");
INSERT INTO boj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon aqa aŋgro naŋgi maŋwa kalil Yesus a yoqnej qaji deqa Jon saiyeb. ");
INSERT INTO boj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Saiyonab Jon na aqa aŋgro aiyel naŋgi metnjrnaq aqa areq bonabqa minjrej, “Niŋgi Tamo Koba aqa areq gilsib endegsib nenemyiy, ‘Kristus agi Qotei na nami qariŋyim bqajqa marej qaji di ni kiyo? Ni saiamqa iga tamo bei qa tariŋqom kiyo?’” ");
INSERT INTO boj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jon na naŋgi aiyel degsi minjrsiq qariŋnjrnaqa Yesus aqa areq gilsib minjeb, “Jon yansnjro qaji a na iga qariŋgwoqa inoq bonum. A ni endegsi nenemmqo, ‘Kristus agi Qotei na nami qariŋyim bqajqa marej qaji di ni kiyo? Ni saiamqa iga tamo bei qa tariŋqom kiyo?’” ");
INSERT INTO boj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bati deqa Yesus na tamo uŋgasari tulaŋ gargekoba ma utru segi segi naŋgi ti tamo naŋgo jejamu mondor uge uge na ojeleŋo qaji naŋgi ti boletnjroqnej. Tamo ŋam qandimo gargekoba dego boletnjreqnaqa ŋam poinjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Deqa Yesus a tamo aiyel Jon na qariŋnjrej qaji naŋgi di minjrej, “Niŋgi aisib kumbra niŋgi uneqnub qaji deqa ti anjam niŋgi queqnub qaji deqa ti Jon saiyosib minjiy. Endegsib minjiy, ‘Tamo ŋam qandimnjro qaji naŋgi olo ŋam poinjreqnaqa sawa uneqnub. Tamo jejamu lainjro qaji naŋgi olo walweleqnub. Tamo naŋgo jejamu yu na ugeeleŋo qaji naŋgo yu kalil koboeqnu. Tamo dabkala geteŋnjro qaji naŋgo dabkala olo waqeqnu. Tamo moreŋo qaji naŋgi olo tigeleqnub. Tamo sougetejunub qaji naŋgi Qotei aqa anjam bole queqnub. ");
INSERT INTO boj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tamo naŋgi e qa naŋgo areqalo siŋgilatoqnsib olo ijo ñam ulontosaieqnub qaji naŋgi tulaŋ areboleboleinjreqnu.’” ");
INSERT INTO boj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Onaqa Jon aqa aŋgro aiyel naŋgi Yesus aqa anjam di qusibqa naŋgi olo puluosib Jon minjqajqa aiyeb. Aiyeqnabqa Yesus na tamo uŋgasari gargekoba a ombla soqneb qaji naŋgi Jon qa endegsi minjrej, “Niŋgi tamo kiyero unqajqa wadau sawaq gileb? Niŋgi tamo silai aqa baŋga bul jagwa na pileteqnaqa di unqajqa gileb kiyo? Sai. Jon a tamo deqaji sai. ");
INSERT INTO boj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Deqa niŋgi tamo kiyero unqajqa wadau sawaq gileb? Niŋgi tamo gara bole walaosi laqnu qaji di unqajqa gileb kiyo? Di dego sai. Tamo gara bole walaoqnsib ñoro koba ti unub qaji naŋgi mandor kokba naŋgo talq di unub. ");
INSERT INTO boj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Deqa niŋgi tamo kiyero unqajqa wadau sawaq gileb? Niŋgi Qotei aqa medabu o qaji tamo bei unqajqa gileb kiyo? Od. Agide. Niŋgi deqa unqa gileb. Deqa e niŋgi endegsi merŋgwai. Jon a Qotei aqa medabu o qaji tamo kobaquja. A na Qotei aqa medabu o qaji tamo kalil naŋgi tulaŋ buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Agi nami e mandamq aiyosaisonamqa Qotei a Jon qa endegsi merbej, ‘Ni que. E na ijo anjam maro tamo qariŋyitqa a ni qa namoosim ino gam gereiyetmqas.’ Tamo di agi Jon. Anjam di Qotei aqa neŋgreŋq di unu. ");
INSERT INTO boj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Deqa e bole merŋgwai. Jon yansnjro qaji a na tamo kalil mandamq endi unub qaji naŋgi tulaŋ buŋnjrejunu. Ariya tamo qudei ñam saiqoji unub qaji naŋgi Qotei na taqatnjroqnsiqa naŋgo Mandor Koba unu deqa naŋgi olo Jon tulaŋ buŋyejunub.” ");
INSERT INTO boj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Onaqa tamo uŋgasari naŋgi ti takis o qaji tamo naŋgi ti anjam di qusib mareb, “Bole. Qotei aqa kumbra kalil di bole tiŋtiŋ.” Naŋgi degsib mareb. Di kiyaqa? Naŋgi nami are bulyonab Jon na yansnjrej deqa. ");
INSERT INTO boj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ariya Farisi naŋgi ti dal anjam qalie tamo naŋgi ti Jon na yansnjrqa urateb deqa naŋgi gam bole Qotei na osornjrej qaji di qoreiyeb. ");
INSERT INTO boj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Onaqa Yesus a olo marej, “Tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra qa e yawo anjam kiyersiy marqai? ");
INSERT INTO boj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","E naŋgo kumbra qa endegsi marqai. Naŋgi aŋgro du du bul qure ambleq di alaŋoqnsib aŋgro qudei na qudei minjreqnub, ‘Iga yumba anjamonumqa niŋgi lou tuosai. Iga are uge qa louonumqa niŋgi akamosai.’” ");
INSERT INTO boj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Osiqa Yesus a olo marej, “Jon yansnjro qaji a bosiqa iŋgi ti wain ti uratosiq sonaqa niŋgi a qa mareqnub, ‘A mondor uge ti unu.’ ");
INSERT INTO boj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ariya e Tamo Aŋgro bosimqa iŋgi ti wain ti uyeqnamqa niŋgi e nuboqnsib mareqnub, ‘Niŋgi uniy. Yesus a qunjaŋ ani. A wain uyo ani. A takis o qaji tamo ti une tamo ti naŋgi koba na walweleqnub.’” ");
INSERT INTO boj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Osiqa Yesus a olo marej, “Qotei aqa tamo uŋgasari naŋgi bole qalieeqnub, aqa powo tulaŋ kobaquja.” ");
INSERT INTO boj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bati bei Farisi tamo bei aqa ñam Saimon a Yesus minjej, “Ni ijo talq bamqa aqo ombla iŋgi uyqom.” Onaqa Yesus a Saimon odyosiqa aqa talq gilsiqa Saimon ombla awoosib iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Onaqa sambala uŋa bei qure dia soqnej qaji a anjam endegsi quej, “Yesus a Saimon aqa talq di sosiqa iŋgi uyeqnu.” A anjam degsi qusiqa goreŋ jaliŋa quleq ti osiqa Saimon aqa tal miligiq gilsiq Yesus aqa qoreq na bosiqa aqa siŋga jojomq di tigelosiq akamej. Akamonaqa aqa ŋam ya Yesus aqa siŋgaq ainaqa siŋga tombol na awoosiq aqa ŋam ya siŋgaq aiyej qaji di aqa segi gate baŋga na piyoqnsiqa Yesus aqa siŋga kundoqyoqnsiqa goreŋ quleq ti dena Yesus aqa siŋga liyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Uŋa a kumbra di yonaqa Saimon a unsiqa are qalej, “Yesus a Qotei aqa medabu o tamo unu qamu uŋa endi bosiq aqa jejamu ojqo qaji di sambala uŋa a degsi poiyqo qamu.” ");
INSERT INTO boj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Onaqa Yesus a Saimon aqa areqalo di qalieosiqa minjej, “Saimon, e ni anjam bei mermqai.” Onaqa Saimon na minjej, “O Qalie Tamo, ni mare.” ");
INSERT INTO boj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Onaqa Yesus na yawo anjam endegsi Saimon minjej, “Tamo aiyel na tamo bei silali yaiyeb. Bei na 100 kina yaiyej. Bei na 10 kina yaiyej. Yaiyonabqa minjrej, ‘Bunuqna niŋgi na kamba silali di olo e ebqab.’ ");
INSERT INTO boj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ariya bunuqna naŋgi aiyel na kamba silali di a olo yqa keresai deqa a na naŋgi aiyel minjrej, ‘Uŋgum, niŋgi na silali di olo ebaib. Uratiy.’ Degsi minjrej. Deqa Saimon, ni merbe, tamo yai a tamo deqa tulaŋ are boledamuiyqas? Tamo 100 kina yaiyej qaji a kiyo tamo 10 kina yaiyej qaji a kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Onaqa Saimon na minjej, “E are qalonum, tamo 100 kina ej qaji a tamo deqa tulaŋ are boledamuiyqas.” Onaqa Yesus na Saimon minjej, “Ni kere maronum.” ");
INSERT INTO boj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Osiq bulosiqa sambala uŋa di areiyosiq Saimon minjej, “Ni uŋa endi unime. E ino tal miligiq gilonumqa ni ijo siŋga yansetbosai. Ariya uŋa endi a bosiqa aqa ŋam ya na ijo siŋga yansetbosiqa aqa gate baŋga na ijo siŋga piyqo. ");
INSERT INTO boj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","E ino tal miligiq gilonumqa ni e kundoqbosai. Ariya uŋa endi a bosiqa ijo siŋga kundoqyoqnaj agi kundoqyoqnsiq unu. ");
INSERT INTO boj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni na ijo gate goreŋ na liyosai. Ariya uŋa endi a goreŋ boledamu quleq ti osi bosiqa dena ijo siŋga liyqo. ");
INSERT INTO boj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Deqa Saimon, e ni mermqai. Sambala uŋa endi aqa une tulaŋ gargekoba. E na aqa une kalil kobotetonum deqa a e qa are tulaŋ boledamuiyqo. Ariya e na tamo bei aqa une quja quja segi kobotetqai di a e qa are bolekiñalayqas.” ");
INSERT INTO boj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Osiqa uŋa di minjej, “Ino une kalil e na kobotetmonum.” ");
INSERT INTO boj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Onaqa tamo naŋgi Yesus koba na awoosib iŋgi uyoqneb qaji naŋgi aqa anjam di qusibqa segi segi maroqneb, “Yesus a tamo kiyero deqa a na tamo naŋgo une kobotetnjreqnu?” ");
INSERT INTO boj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Onaqa Yesus na uŋa di minjej, “Ni ino areqalo e qa siŋgilatonum deqa Qotei na ni oqo. Deqa ni are lawo na gilime.” ");
INSERT INTO boj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bati bei Yesus a walwelosiqa qure kokba ti qure kiñilala ti dia brantoqnsiqa Qotei a tamo uŋgasari naŋgo Mandor Koba sosim naŋgi taqatnjrqas anjam bole di minjre minjre laqnej. Tamo 12 Yesus na giltnjrej qaji naŋgi a ti walweloqneb. ");
INSERT INTO boj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Uŋgasari qudei nami naŋgo jejamuq dena Yesus na mondor uge uge winjrej qaji naŋgi ti uŋa qudei nami mainjrnaqa Yesus na boletnjrej qaji naŋgi ti Yesus dauryosib koba na walweloqneb. Uŋa bei aqa ñam Maria. A Makdala qure qaji. Nami mondor uge 7 naŋgi aqa jejamuq di sonabqa Yesus na winjretej. ");
INSERT INTO boj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Uŋa bei aqa ñam Joana. A Kusa aqa ŋauŋ. Kusa a Mandor Herot aqa tal taqatoqnej qaji. Uŋa bei aqa ñam Susana. Uŋgasari gargekoba naŋgi dego Yesus dauryoqneb. Naŋgi naŋgo segi silali na Yesus aqa aŋgro naŋgi ti iŋgi awaiyetnjroqneb. ");
INSERT INTO boj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bati deqa tamo uŋgasari tulaŋ gargekoba naŋgi qure qure kalilq dena bosib Yesus aqa areq di koroonabqa a tigelosiqa yawo anjam endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tamo bei a saga yago osiq aqa iŋgi wauq di breiyej. Breiyonaqa saga yago qudei gam qalaq aiyeleŋeb. Ainabqa tamo qudei naŋgi walwelosib saga yago di soseleŋonabqa qebari naŋgi bosib uyekriteb. ");
INSERT INTO boj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Saga yago qudei mandam lanjaq di aiyeleŋeb. Mandam di guma meniŋ ti. Gogeq di mandam kiñala. Deqa saga yago aiyeleŋosib urur oqoqujateb. Onaqa mandam olo kaŋgraŋonaq saga yago laosib moreŋeb. ");
INSERT INTO boj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Saga yago qudei sil luwit ambleq di aiyeleŋeb. Dena oqeb qaji sil luwit na dego dauryosiq oqsiq kabutnjrnaq geitosai. ");
INSERT INTO boj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Saga yago qudei mol mandam boledamuq di aiyeb. Di aisib oqoboledamuyosib gei tulaŋ gargekoba ateb. 100 dego.” Yesus na tamo uŋgasari naŋgi yawo anjam degsi minjrsiq koboonaqa a tulaŋ leleŋosiq marej, “Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Onaqa Yesus aqa aŋgro naŋgi aqa yawo anjam di qusibqa naŋgi anjam aqa utru geregere qalieqajqa deqa Yesus nenemyeb. ");
INSERT INTO boj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nenemyonabqa a na kamba endegsi minjrej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Anjam di aqa utru uliejunu. Di Qotei na babtimqa ijo aŋgro niŋgi segi utru qalieqab. Ariya tamo uŋgasari laŋaj naŋgi yawo anjam segi minjroqnqai. Deqa naŋgi ŋam atoqnqab di naŋgi ijo anjam aqa damu unqasai. Naŋgi dab atoqnqab di naŋgi ijo anjam aqa utru poinjrqasai.” ");
INSERT INTO boj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Osiqa Yesus a olo marej, “Saga yago qa yawo anjam maronum di aqa utru e na babtitqa niŋgi quiy. Saga yago di Qotei aqa anjam. ");
INSERT INTO boj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Saga yago qudei gam qalaq aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib naŋgo are miligiq di atib soqnimqa Satan a bosim anjam di olo yainjrqas. Yim naŋgi Qotei aqa anjam naŋgo areqaloq di siŋgilatqa keresai. Deqa Qotei a naŋgi eleŋqasai. ");
INSERT INTO boj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Saga yago qudei mandam lanjaq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib tulaŋ areboleboleinjrimqa anjam di oqujatosib naŋgo areq atqab. Ariya anjam di naŋgo are miligiq tulaŋ guma aiyosai. Deqa sokiñala gulbe bei bei naŋgoq bamqa naŋgo areqalo Yesus qa siŋgilateqnub qaji di naŋgi olo ulontqab. ");
INSERT INTO boj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Saga yago qudei sil luwit ambleq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam quqwab. Ariya bunuqna naŋgo segi jejamu qa ulaqajqa ti ñoro koba oqajqa ti mandam qa iŋgi iŋgi qa areboleboleinjrqajqa ti kumbra dena anjam bole naŋgo are miligiq di unu qaji di tentim loumqas. Saga yago uge naŋgi gei bole atosaieqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Saga yago qudei mol mandam boledamuq di aiyeb qaji di aqa utru endegsi unu. Tamo qudei naŋgi Qotei aqa anjam qusib ojsib dauryoqnqab. Naŋgo are miligi bolequja deqa naŋgi siŋgila na tigelesosib gulbe qoboiyoqnqab. Saga yago bole naŋgi gei bole ateleŋeqnub dego kere.” ");
INSERT INTO boj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Osiqa Yesus a olo marej, “Tamo bei a lam qatrentosim web na kabutqasai. A bijal surumq di atqasai. Boleq di gaintim warum suwaŋamqa tamo uŋgasari naŋgi tal miligiq gilsib warum geregere unqab. ");
INSERT INTO boj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dego kere kumbra kalil uliejunu qaji di olo boleq dqas. Iŋgi iŋgi kalil kabuejunu qaji di dego olo boleq dimqa tamo uŋgasari naŋgi unsib utru qalieqab. ");
INSERT INTO boj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Deqa niŋgi ijo anjam geregere qusib poiŋgem. Tamo a powo ti sqas di Qotei na powo olo yimqa a powo koba oqas. Ariya tamo a powo ti sqasai di powo kiñala aqaq di unu qaji di Qotei na olo yaiyimqa a laŋa sqas. Tamo di a marqas, ‘E powo ti.’ Di sai. A powo saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Onaqa Yesus aqa was naŋgi aqa ai koba na Yesus aqaq bosib talq di iteb. Itosib tamo uŋgasari gargekoba siraŋmeq di jujuŋeb deqa naŋgi aqa areq gilqa keresaiinjrej. ");
INSERT INTO boj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Deqa tamo qudei na Yesus minjeb, “Ino was naŋgi ino ai ombla na ni numqa bonub agi oqeq di tigelejunub.” ");
INSERT INTO boj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Onaqa Yesus na kamba minjrej, “Tamo uŋgasari Qotei aqa anjam qusib dauryeqnub qaji naŋgi ijo ai bole. Naŋgi ijo was bole dego.” ");
INSERT INTO boj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","23","Bati bei Yesus aqa aŋgro naŋgi ti qobuŋ bei gogetosibqa Yesus na minjrej, “Iga ya agu taqal beiq gilqom.” Degsi minjrsiqa naŋgi koba na qobuŋ na gileqnabqa Yesus a urŋamyonaqa qobuŋ miligiq di ŋeisiq qambumtej. Onaqa jagwa koba tigelosiq ya korkortosiqa qobuŋ qaloqnsiqa mormaŋ miligiq aiyeqnaqa ya maqonaqa qobuŋ tugwa laqnej. ");
INSERT INTO boj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Deqa Yesus aqa aŋgro naŋgi tulaŋ ulaugetosib aqa areq bosib dudumyosib minjeb, “O Tamo Koba, iga padalqa laqnum.” Degsi minjnabqa Yesus a naŋgo anjam di qusiqa qutuosiqa tigelej. Tigelosiqa jagwa ti ya ti siŋgila na minjrej, “Niŋgi laoiy.” Onaqa jagwa ti ya ti laosib tulaŋ maninej. ");
INSERT INTO boj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Onaqa Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi kiyaqa e qa nuŋgo areqalo siŋgilatosai?” Degsi minjrnaqa naŋgi tulaŋ ulaugetosib segi segi maroqneb, “Yesus a tamo kiyero deqa jagwa ti ya ti minjrqoqa aqa anjam qusib laonub?” ");
INSERT INTO boj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Onaqa Yesus aqa aŋgro naŋgi ti Galili sawa uratosib ya agu ambleq na potosib qobuŋ na gilsib Gerasa sawaq di tiryeb. ");
INSERT INTO boj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tiryosib Yesus a mandamq ainaqa qure deqaji tamo bei a bosiqa Yesus itej. Tamo di a mondor uge uge na ojeleŋo qaji. A bati gaigai yosi laqnej. A nami koba degsi soqnej. A talq di ŋeiosaioqnej. A gaigai tamo sub ato sawaq di ŋeioqnej. ");
INSERT INTO boj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Deqa a Yesus unsiqa tulaŋ leleŋosiqa bosiq Yesus aqa areq di siŋga pulutosiqa minjej, “O Yesus, Qotei Goge Koba aqa Ŋiri, ni e kiyerbqa bonum? E ni endegsi mermqai, ni e jaqatiŋ ebaim.” ");
INSERT INTO boj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mondor uge dena Yesus degsi minjej. Di kiyaqa? Yesus na siŋgila na minjoqnej, “Ni tamo di uratosim ulaŋ.” Mondor uge dena bati gargekoba tamo di aqa jejamu ugeugeiyeteqnaqa tamo qudei na ojoqnsib sil kokba na aqa siŋga ti baŋ ti tontoqnsib geregere taqatoqneb. Yeqnaqa mondor uge dena sil kokba kukoqyeleŋoqnsiqa tamo di oqnsiqa wadau sawaq osi giloqnej. ");
INSERT INTO boj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Deqa Yesus na mondor uge di nenemyej, “Ino ñam yai?” Onaqa minjej, “Ijo ñam Qoto Tamo Gargekoba.” A na Yesus degsi minjej. Di kiyaqa? Mondor uge tulaŋ gargekoba tamo di aqa jejamuq di soqneb deqa. ");
INSERT INTO boj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Onaqa mondor uge naŋgi siŋgila na pailosib Yesus minjeb, “Ni iga sub guma kobaq di waigaim.” ");
INSERT INTO boj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","33","Bati deqa bel tulaŋ gargekoba naŋgi mana goge dia suwaroqneb. Deqa mondor uge naŋgi na Yesus minjeb, “Ni iga qariŋgimqa iga bel naŋgo jejamuq gileleŋqom.” Onaqa Yesus a mondor uge naŋgi odnjrnaqa naŋgi na tamo di uratosibqa segi segi bel naŋgo jejamuq gileleŋeb. Gilnabqa bel kalil naŋgi gurgurosib botau dena prugeleŋosib yaq aisib ya uysib moreŋeb. ");
INSERT INTO boj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Onaqa bel taqatoqneb qaji tamo naŋgi kumbra di unsibqa jaraiyosib qure miligiq aisib tamo uŋgasari kalil naŋgi sainjroqnsib laqneb. Gamq di dego sainjroqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Onaqa tamo uŋgasari naŋgi kumbra di unqajqa beb. Bosib Yesus aqa areq di koroosib ŋam ateb di tamo nami mondor uge ti sosiq yosi laqnej qaji aqa areqalo boleosiq gara tigsiq Yesus aqa siŋga jojomq di awesonaq uneb. Unsib ulaugeteb. ");
INSERT INTO boj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Onaqa tamo naŋgi Yesus aqa maŋwa di uneb qaji naŋgi na tamo uŋgasari naŋgi sainjreb. Yesus na mondor uge winjrnaq tamo a boleej deqa sainjreb. ");
INSERT INTO boj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yesus a maŋwa di babtej deqa tamo uŋgasari kalil Gerasa sawaq di soqneb qaji naŋgi tulaŋ ulaugetosib minjeb, “Ni iga uratgosim ulaŋ.” Onaqa Yesus a qobuŋ gogetosiqa naŋgi uratnjrsiq aiyej. ");
INSERT INTO boj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aiqa laqnaqa tamo Yesus na mondor uge winjretej qaji a siŋgila na pailosiq minjej, “E ni daurmqai.” Onaqa Yesus na saidyosiq minjej, ");
INSERT INTO boj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ni olo ino segi qureq gilsim Qotei na kumbra tulaŋ boledamu emqo deqa naŋgi sainjre.” Onaqa a puluosiq aqa qureq gilsiq Yesus na kumbra tulaŋ boledamu yej deqa tamo uŋgasari kalil naŋgi sainjroqnsiq laqnej. ");
INSERT INTO boj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Onaqa Yesus a olo qobuŋ gogetosiqa Galili sawaq gilej. Gilsiq qobuŋ tiryonaq mandamq aisiq ŋam atej di tamo uŋgasari tulaŋ gargekoba naŋgi nami bosib a qa tariŋesonab unjrej. Deqa naŋgi a unsibqa tulaŋ areboleboleinjrej. ");
INSERT INTO boj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Onaqa Qotei tal taqato tamo bei aqa ñam Jairus a bosiq Yesus aqa areq di siŋga pulutosiqa pailyosiq minjej, “Ni ijo talq au.” ");
INSERT INTO boj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Degsi minjej. Di kiyaqa? Aqa aŋgro sebiŋ qujai bole qujai moiqa laqnej deqa. Aŋgro aqa wausau 12. Onaqa Yesus na Jairus odyosiqa tigelosiq a dauryosiq gileqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi dego naŋgi aiyel daurnjrsib jujuŋosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gileqnabqa naŋgo ambleq di uŋa bei ma ti soqnej qaji a naŋgi daurnjrsiq giloqnej. Uŋa di nami bai na unej leŋ aiyoqnsiq degsi soqnej wausau 12 uratej. Tamo gargekoba naŋgi nami a boletqa yeqnab naŋgi keresaiinjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Deqa a Yesus aqa qoreq na dadauryosiqa baŋ waiyosiq Yesus aqa gara mutu ojej. Ojnaqa aqa leŋ aiyoqnej qaji di koboej. ");
INSERT INTO boj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Onaqa Yesus a marej, “Yai na ijo gara ojqo?” Onaqa tamo uŋgasari kalil naŋgi saidonabqa Pita na Yesus minjej, “O Tamo Koba, ni unime. Tamo uŋgasari tulaŋ gargekoba naŋgi ni daurmosib jujuŋmejunub.” ");
INSERT INTO boj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Onaqa Yesus a kamba marej, “E qalieonum, bei na ijo gara ojqoqa siŋgila qudei ijo jejamu uratosiq aqaq gilqo.” ");
INSERT INTO boj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Onaqa uŋa di a are qalej, “E Yesus aqa gara ojonum ijo ma koboqo di ulitqa keresai.” A degsi are qalsiqa are toŋtoŋyonaqa jiŋga na bosiq Yesus aqa areq di siŋga pulutosiq tamo uŋgasari kalil naŋgo ŋamdamuq di aqa kumbra yej qaji di ubtekritej. A Yesus aqa gara ojej deqa ti aqa ma urur koboej deqa ti ubtej. ");
INSERT INTO boj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Onaqa Yesus na minjej, “O uŋa, ni ino areqalo e qa siŋgilatosim ijoq bonum deqa ino ma agi koboqo. Deqa ni are lawo na gilsim bole soqnime.” ");
INSERT INTO boj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus na uŋa degsi minjeqnaqa tamo bei a Jairus aqa talq dena bosiqa Jairus minjej, “Uŋgum. Ino aŋgro nami moiqo. Deqa ni Qalie Tamo a laŋa wau koba yaim. Uratim aiyem.” ");
INSERT INTO boj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Degsi minjnaqa Yesus a anjam di qusiqa Jairus minjej, “Ni ulaaim. Ni e qa ino areqalo siŋgilatimqa ino aŋgro a boleosim ŋambile sqas.” ");
INSERT INTO boj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Osiqa Jairus ombla gilsib Jairus aqa talq di branteb. Brantosib Yesus na tamo uŋgasari kalil naŋgi tal gogetqa saidnjrsiqa aŋgro moiyej qaji aqa ai abu aqa aŋgro qalub agi Pita na Jon na Jems na naŋgi segi joqsiqa tal gogeteb. ");
INSERT INTO boj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tamo uŋgasari kalil naŋgi na aŋgro moiyej qaji a akamkobatoqneb. Deqa Yesus na minjrej, “Niŋgi akamaib. Aŋgro di a moiyosai. A laŋa ŋeisiq qambumtejunu.” ");
INSERT INTO boj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Degsi minjrnaqa naŋgi Yesus kikiyeb. Naŋgi qalieeb, “Aŋgro a nami moiyoboletqo.” Degsib qalieosib deqa Yesus kikiyeb. ");
INSERT INTO boj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Onaqa Yesus a warum miligiq gilsiqa aŋgro aqa baŋ ojsiqa soqtosiq minjej, “O Aŋgro, ni tigel.” ");
INSERT INTO boj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Degsi minjnaqa a olo ŋambile osiqa urur tigelej. Onaqa Yesus na aqa ai abu naŋgi minjrej, “Niŋgi iŋgi osib a anaiyiy.” ");
INSERT INTO boj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aqa ai abu naŋgi Yesus aqa maŋwa di unsib deqa naŋgi tulaŋ prugugeteb. Onaqa Yesus na minjrej, “Niŋgi ijo maŋwa endi unonub deqa niŋgi ijo ñam ubtosib tamo qudei minjraib.” ");
INSERT INTO boj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Bati bei Yesus na aqa aŋgro 12 naŋgi koroinjrsiqa siŋgila enjrej. Naŋgi tamo uŋgasari naŋgo jejamuq dena mondor uge uge winjrqajqa ti tamo naŋgo ma kobotetnjrqajqa ti deqa siŋgila enjrej. ");
INSERT INTO boj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Osiqa naŋgi qariŋnjrsiqa minjrej, “Niŋgi giloqnsibqa Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam di minjre minjre laqnsibqa naŋgo ma kobotetnjroqniy.” ");
INSERT INTO boj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Osiqa olo minjrej, “Niŋgi iŋgi iŋgi osib gilaib. Toqoŋ ojaib. Nuŋgo qaquŋ aib. Iŋgi uyo bei osib gilaib. Silali osib gilaib. Gara jugo aiye aiyel aib. ");
INSERT INTO boj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Niŋgi qure bei beiq di brantoqnsibqa tal qujaiq di soqniy. Dena olo tigeloqnsib qure beiq giloqniy. ");
INSERT INTO boj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tamo naŋgi niŋgi gereiŋgosaiabqa niŋgi qure di uratqa oqnsib nuŋgo siŋga tumbrum butuyoqniy. Yimqa naŋgi nuŋgo kumbra di unsib poinjrqas, ‘Bole, iga kumbra ugetonum.’” ");
INSERT INTO boj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Onaqa Yesus aqa aŋgro 12 naŋgi tigelosib qure qureq giloqnsibqa Yesus aqa anjam bole tamo uŋgasari naŋgi minjre minjre laqnsib naŋgo ma kobotetnjroqneb. ");
INSERT INTO boj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mandor Herot a maŋwa kalil Yesus a yoqnej qaji deqa quej. Qusiqa areqalo kobaiyej. Di kiyaqa? Tamo qudei naŋgi maroqneb, “Tamo di a Jon yansnjro qaji. A moisiq olo subq na tigelqo.” ");
INSERT INTO boj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Onaqa qudei naŋgi maroqneb, “Tamo di a Elaija kiyo olo bqo?” Olo qudei naŋgi maroqneb, “Tamo di a Qotei aqa medabu o tamo naŋgi nami soqneb deqaji bei. A olo subq na tigelqo.” ");
INSERT INTO boj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ariya Herot a segi marej, “Tamo di a Jon sai. Jon agi e na kakro gentem moiyej koboej. Di tamo yai olo bqo? E a qa anjam gargekoba queqnum.” Herot a degsi marsiqa Yesus unqajqa are qalsiq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Onaqa Yesus aqa anjam maro tamo 12 naŋgi olo bosib aqa areq di koroosibqa kumbra kalil naŋgi yoqneb qaji deqa saiyosib minjoqneb. Minjnabqa Yesus a qusiqa naŋgi joqsiq qure bei ñam Betsaida gileb. ");
INSERT INTO boj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gileqnabqa tamo uŋgasari naŋgi endegsib queb, “Yesus a Betsaida gileqnu.” Degsib qusibqa Yesus dauryosib gileb. Dauryosib gileqnabqa unjrsiqa Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam di minjroqnej. Tamo uŋgasari ma ti so qaji naŋgi dego Yesus dauryosib gileqnabqa a na naŋgi kalil boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Onaqa seŋ aisiq bilaqtonaqa Yesus aqa aŋgro 12 naŋgi aqa areq bosib minjeb, “O Tamo Koba, ni na tamo uŋgasari naŋgi minjrimqa qure qureq gilsib dia iŋgi uysib ŋereŋqab. Endi wadau sawa. Iŋgi saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Onaqa Yesus na minjrej, “Niŋgi na iŋgi anainjriy.” Degsi minjrnaqa naŋgi na kamba minjeb, “Iga iŋgi sai. Iga bem 5 qe aiyela segi unu. Di keresai. Iga aisim iŋgi tulaŋ koba awaiyosim tamo uŋgasari kalil endi naŋgi anainjrqom di dego kereqasai.” ");
INSERT INTO boj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Naŋgi degsib mareb. Di kiyaqa? Tamo 5,000 soqneb deqa. Onaqa Yesus a kamba aqa aŋgro naŋgi endegsi minjrej, “Niŋgi na tamo uŋgasari naŋgi minjribqa qur segi segi 50 awoeleŋqab.” ");
INSERT INTO boj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Onaqa Yesus aqa aŋgro naŋgi na tamo uŋgasari naŋgi minjrnab dedegsib awoeleŋeb. ");
INSERT INTO boj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Awoonabqa Yesus na bem 5 ti qe aiyel ti di osiqa laŋ goge tarosiqa Qotei pailyej. Pailyo koboonaqa bem ti qe ti giŋgeŋyosiqa aqa aŋgro naŋgi enjreqnaqa naŋgi na osi giloqnsibqa tamo uŋgasari naŋgi jeisib enjreqnab uyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Uynab kalil menetnjrej. Onaqa iŋgi oto urateleŋeb qaji di Yesus aqa aŋgro naŋgi na koroiyosib gumba kokba 12 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bati bei Yesus aqa aŋgro naŋgi ti sasalosib naŋgi segi sosibqa Yesus a Qotei pailyoqnej. Pailyo koboonaqa a na aqa aŋgro naŋgi endegsi nenemnjrej, “Tamo uŋgasari naŋgi e qa kiyersib mareqnub?” ");
INSERT INTO boj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Onaqa aqa aŋgro naŋgi na minjeb, “Tamo qudei naŋgi mareqnub, ni Jon yansnjro qaji. Qudei naŋgi mareqnub, ni Elaija. Qudei naŋgi mareqnub, ni Qotei aqa medabu o tamo naŋgi nami soqneb deqaji bei agi subq na tigelqo.” ");
INSERT INTO boj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Onaqa Yesus a naŋgi olo nenemnjrej, “Niŋgi segi e qa kiyersib mareqnub?” Onaqa Pita na minjej, “Ni Qotei aqa Kristus.” ");
INSERT INTO boj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita a anjam degsi marnaqa Yesus na aqa aŋgro naŋgi siŋgila na getentnjrsiqa minjrej, “Niŋgi anjam di ubtosib tamo qudei minjraib.” ");
INSERT INTO boj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Osiqa minjrej, “E Tamo Aŋgro. Bunuqna e jaqatiŋ koba oqai. Juda gate naŋgi ti atra tamo kokba ti dal anjam qalie tamo naŋgi ti e qoreibosib lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Osiqa aqa aŋgro kalil naŋgi endegsi minjrej, “Tamo bei na e daurbqa osimqa a aqa segi areqalo kalil uratekritosim bati gaigai aqa segi ŋamburbas qoboiyosim e daurboqnem. ");
INSERT INTO boj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tamo bei na aqa segi ŋambile taqatqajqa arearetqas di a padalqas. Ariya tamo bei a e qa are qalsimqa aqa segi ŋambile uratqas di a olo ŋambile bole oqas. ");
INSERT INTO boj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tamo bei a mandam qa ñoro kalil koroiyosim ariya mondoŋ aqa segi qunuŋ padalqas di ñoro dena a kiyersim olo aqaryaiyqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","E Tamo Aŋgro. Tamo bei a e qa ti ijo anjam qa ti jemaiyqas di mondoŋ e bosiyqa e kamba tamo deqa jemaibqas. Bati di e ijo segi riaŋ na ti ijo Abu aqa riaŋ na ti ijo Abu aqa laŋ aŋgro naŋgo riaŋ na ti bqai. ");
INSERT INTO boj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","E bole merŋgwai. Tamo qudei ijo areq endi tigelejunub qaji naŋgi moreŋosaisoqnibqa Qotei na naŋgi taqatnjrsim naŋgo Mandor Koba soqnimqa naŋgi unqab.” ");
INSERT INTO boj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus a anjam degsi marsiq koboonaqa bati 8 onaqa a Qotei pailyqa marsiqa Pita na Jon na Jems na naŋgi qalub joqsiqa koba na manaq oqeb. ");
INSERT INTO boj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Manaq oqsib dia Yesus a Qotei pailyeqnaqa aqa ulatamu bulyonaq naŋgi unobeiteb. Aqa gara dego tulaŋ puloŋosiq qatekritej. ");
INSERT INTO boj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Onaqa tamo aiyel brantosib Yesus ombla anjam maroqneb. Tamo aiyel di Moses Elaija wo. ");
INSERT INTO boj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naŋgi aiyel riaŋ koba ti Qotei aqa siŋgila ti beb. Bosibqa Yesus a bunuqna Jerusalem dia aqa wau kobotosim moisim mandam uratqas anjam deqa Yesus ombla qairoqneb. ");
INSERT INTO boj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yesus aqa aŋgro qalub naŋgi tulaŋ urŋamnjrnaqa ŋereŋesoqneb deqa olo qutuosibqa ŋam poinjrnaqa Yesus aqa riaŋ koba de ti tamo aiyel a ombla tigelesoqneb qaji naŋgi ti unjreb. ");
INSERT INTO boj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Onaqa Moses Elaija wo naŋgi olo Yesus urateqnabqa Pita na minjej, “O Tamo Koba, Moses Elaija wo bosib iga koba na endi unum di bolequja. Deqa iga tal kiñilala qalub gereiyqom. Bei ino. Bei Moses aqa. Bei Elaija aqa.” Pita a anjam bei marqa saiiyonaqa anjam di laŋa marej. ");
INSERT INTO boj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mareqnaqa laŋbi aisiqa naŋgi kabutnjrnaqa naŋgi ulaugeteb. ");
INSERT INTO boj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Onaqa laŋbi miligiq dena anjam bei endegsi brantonaq naŋgi queb, “Endi ijo Aŋgro qujai e segi na giltem qaji. Niŋgi aqa anjam quetoqniy.” ");
INSERT INTO boj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Onaqa Yesus aqa aŋgro naŋgi anjam di qusib ŋam ateb di Yesus a segi naŋgi koba na sonab uneb. Naŋgi tamo bei unosai. Bati deqa naŋgi kumbra uneb qaji di ubtosib tamo qudei naŋgi minjrosaioqneb. Naŋgi mequmosib soqneb. ");
INSERT INTO boj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nebeonaqa naŋgi manaq dena olo aisib tamo uŋgasari tulaŋ gargekoba mana utruq di tariŋesonab itnjreb. ");
INSERT INTO boj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Onaqa tamo uŋgasari naŋgo ambleq dena tamo bei a brantosiqa tulaŋ maosiq Yesus minjej, “O Qalie Tamo, ni ijo aŋgro mel unime. A ijo aŋgro qujai bole qujai. ");
INSERT INTO boj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mondor uge na aqa jejamu ojoqnsiqa mandamq waiyeqnaqa a tulaŋ leleŋoqnsiqa aqa medabuq na maul aiyeqnu. Mondor uge dena a qunjimyoqnsiqa aqa jejamu tulaŋ ugeugeiyeqnu. A olo uratosaieqnu. ");
INSERT INTO boj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Deqa e na ino aŋgro naŋgi minjronum, ‘Niŋgi mondor uge di wiyiy.’ Minjronumqa naŋgi na wiyqa yonub keresaiinjrqo.” ");
INSERT INTO boj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Onaqa Yesus a anjam di qusiqa marej, “Niŋgi tamo uŋgasari bini bati endeqa unub qaji nuŋgo areqalo e qa siŋgilatosai bole sai. Nuŋgo areqalo ti kumbra ti tulaŋ uge. Bati gembub e niŋgi koba na sosiyqa nuŋgo gulbe di qoboiyoqnqai?” Degsi marsiqa aŋgro di aqa abu minjej, “Ino aŋgro mel di osau.” ");
INSERT INTO boj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Onaqa osi beqnaqa mondor uge dena aqa jejamu ojsiq mandamq waiyosiq qunjimyoqnej. Yeqnaqa Yesus na mondor uge di ŋiriŋtosiq wiyonaq aŋgro aqa jejamu uratonaq boleej. Boleonaqa Yesus na aŋgro di baŋ ojsiq osi gilsiqa aqa abu yej. ");
INSERT INTO boj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Onaqa tamo uŋgasari kalil mana utruq di soqneb qaji naŋgi Qotei aqa maŋwa di unsibqa tulaŋ prugugeteb. Tamo uŋgasari naŋgi maŋwa kalil Yesus a yoqnej qaji deqa are koba qaleqnabqa a na aqa aŋgro naŋgi endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Niŋgi ijo anjam endi geregere quiy. E Tamo Aŋgro. Jeu tamo naŋgi na e ojsib tamo qudei naŋgo baŋq di atqab.” ");
INSERT INTO boj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di qusib anjam aqa utru Qotei na ulitej deqa naŋgi poinjrosai. Deqa naŋgi Yesus nenemyqajqa ulaeb. ");
INSERT INTO boj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bati bei Yesus aqa aŋgro naŋgi segi segi ŋiriŋosib aŋgro yai a naŋgi kalil buŋnjrsim ñam ti sqas deqa anjam na qotoqneb. ");
INSERT INTO boj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Onaqa Yesus a naŋgo areqalo di qalieosiqa aŋgro kiñala bei osiqa aqa areq di tigeltosiqa naŋgi osornjrej. Osornjrsiqa minjrej, “Tamo bei a ijo ñam qa are qalsimqa aŋgro kiñala endeqaji bei osim geregereiyqas di a e dego osim geregereibqas. Tamo a e osim geregereibqas di a na ijo Abu e qariŋbej qaji di dego osim geregereiyqas. Nuŋgo ambleq di tamo bei a aqa segi ñam soqtqa uratqas di tamo dena niŋgi kalil buŋgosim ñam ti sqas.” ");
INSERT INTO boj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Onaqa Jon na Yesus minjej, “O Tamo Koba, ni que. Iga tamo bei unem. A ino ñam na mondor uge naŋgi winjreqnaqa iga na unsim saidyem. Di kiyaqa? A iga koba na wauosaieqnu deqa.” ");
INSERT INTO boj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Onaqa Yesus na minjej, “Niŋgi a saidyaib. Tamo naŋgi niŋgi jeutŋgosaieqnub di naŋgi niŋgi koba na wau qujai.” ");
INSERT INTO boj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Onaqa Yesus a mandam uratosim laŋ qureq oqwajqa bati jojomonaqa a Jerusalem aiqajqa areqalo qujaitosiqa Jerusalem areiyosiq walwelej. ");
INSERT INTO boj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","53","Walweloqnsiqa aqa aŋgro qudei naŋgi qariŋnjrnaqa naŋgi namo aisib Samaria naŋgo qure beiq di brantosib Yesus a di ŋeiqajqa minjrnabqa naŋgi na saideb. Di kiyaqa? A Jerusalem aiyoqnej deqa. ");
INSERT INTO boj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Onaqa Yesus aqa aŋgro aiyel Jems Jon wo naŋgi kumbra di unsibqa minjiŋ oqetnjrnaqa Yesus minjeb, “O Tamo Koba, ni marimqa iga ŋamyuwo metonam laŋ goge na aisim tamo naŋgi di koitnjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Onaqa Yesus a bulosiqa naŋgi aiyel ŋiriŋtnjrej. ");
INSERT INTO boj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Osiqa aqa aŋgro kalil naŋgi joqsiqa koba na qure beiq aiyeb. ");
INSERT INTO boj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Naŋgi gam dauryosib aiyeqnabqa tamo bei na Yesus minjej, “Ni sawa sawaq giloqnimqa e ni daurmoqnqai.” ");
INSERT INTO boj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Onaqa Yesus na minjej, “Bauŋ juwaŋ naŋgi tal ti. Agi sub miligiq di ŋereŋeqnub. Qebari naŋgi simi ti. Deqa naŋgi simiq di ŋereŋeqnub. Ariya e Tamo Aŋgro ŋeiqajqa tal saiqoji. Deqa ni e daurbqajqa gulbe koba.” ");
INSERT INTO boj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Osiqa tamo bei minjej, “Ni e daurbe.” Degsi minjnaqa tamo dena minjej, “O Tamo Koba, ni e odbimqa e mati aisiy ijo abu qa tariŋoqnqai. A moiyimqa subq atsiy di e ni daurmqai.” ");
INSERT INTO boj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Onaqa Yesus na minjej, “Uŋgum. Tamo moiyo qaji naŋgi segi na tamo moiyo qaji naŋgi subq ateleŋoqnqab. Ariya ni sawa sawaq giloqnsimqa Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam di minjre minjre laqne.” ");
INSERT INTO boj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Onaqa tamo bei na Yesus minjej, “O Tamo Koba, ni marimqa e mati gilsiy ijo was naŋgi baŋ ojeleŋosiy bosiy ni daurmqai.” ");
INSERT INTO boj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Onaqa Yesus na minjej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam di ni mare mare laqne. Ni que. Tamo bei a kuñi ojsimqa a bulosim qoreq ŋam atoqnqas di a Qotei aqa wau ojqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bati bei Tamo Koba a na tamo kalil a dauryoqneb qaji naŋgi metnjrnaqa aqa areq bonabqa naŋgo ambleq dena tamo 72 naŋgi giltnjrej. Naŋgi aqa anjam mare mare laqajqa deqa giltnjrej. Giltnjrsiqa naŋgi aiye aiyel namoosib qure kalil a segi bunuqna walwelosim aiqas qaji naŋgi deq aiqajqa minjrsiqa qariŋnjrnaq aiyeb. ");
INSERT INTO boj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A naŋgi qariŋnjrqa osiqa yawo anjam endegsi minjrej, “Wauq di iŋgi gargekoba melionub. Ariya iŋgi meli bunuj otorqajqa wau tamo gargekoba sai. Deqa niŋgi wau lanja minjibqa a na wau tamo naŋgi qariŋnjrimqa naŋgi aqa wauq gilsib iŋgi meli bunuj otoreleŋqab. ");
INSERT INTO boj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Deqa niŋgi aiyiy. Niŋgi kaja du du bul unub deqa e na niŋgi qariŋgitqa aisib bauŋ juwaŋ naŋgo ambleq di wauoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niŋgi silali osib aiyaib. Nuŋgo qaquŋ aib. Siŋga tatal jigaib. Niŋgi aiyoqnsibqa gamq di tamo qudei turoqnsibqa naŋgi anjam bei minjraib. ");
INSERT INTO boj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Niŋgi tal bei gogetoqnsibqa tamo uŋgasari tal miligiq di unub qaji naŋgi endegsib minjroqniy, ‘Niŋgi lawo na soqniy.’ ");
INSERT INTO boj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Degsib minjroqnibqa lawo tamo bei sqas di a nuŋgo lawo anjam di oqas. Ariya lawo tamo bei sqasai di nuŋgo lawo anjam di olo puluosim nuŋgoq bqas. ");
INSERT INTO boj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Niŋgi qure bei beiq di brantoqnsibqa tal qujaiq di soqniy. Olo tal bei bei gogetoqnaib. Naŋgi na niŋgi joqsib iŋgi ti ya ti anaiŋgoqnibqa uyoqniy. Niŋgi Qotei aqa wau tamo unub deqa nuŋgo awai agi oqniy. ");
INSERT INTO boj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Niŋgi qure beiq di brantoqnibqa naŋgi niŋgi joqoqnsib iŋgi anaiŋgoqnibqa uyoqniy. ");
INSERT INTO boj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Niŋgi qure dia sosibqa tamo uŋgasari ma ti unub qaji naŋgi boletnjroqnsib endegsib minjroqniy, ‘Qotei a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ariya niŋgi qure beiq di brantoqnibqa naŋgi niŋgi gereiŋgosaiabqa niŋgi naŋgi uratnjrqa oqnsib naŋgo qure ambleq di tigeloqnsibqa endegsib minjroqniy, ");
INSERT INTO boj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Niŋgi Qotei qoreiyonub deqa nuŋgo qure qa tumbrum gago siŋga qandratqo qaji agi butuyetŋgonum. Ariya niŋgi endegsib qalieoiy, Qotei a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa bati jojomqo.’ O ijo aŋgro, niŋgi degsib minjroqniy. ");
INSERT INTO boj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","E niŋgi merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgo une qa peginjrqa batiamqa a na qure deqaji naŋgi tulaŋ padaltnjrougetqas. A na Sodom qure naŋgi degsim padaltnjrqasai. A naŋgi gulbe kiñala enjrqas. ");
INSERT INTO boj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O Korasin qure ti Betsaida qure ti, niŋgi tulaŋ padalougetqab. Di kiyaqa? Maŋwa e nuŋgoq di yoqnem qaji di Tair qure ti Saidon qure ti naŋgoq di brantej qamu naŋgi nami are bulyosib are uge qa gara jigsib ŋam sumq di awoeb qamu. ");
INSERT INTO boj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Deqa e niŋgi endegsi merŋgwai. Mondoŋ Qotei a tamo uŋgasari naŋgo une qa peginjrqa batiamqa a na niŋgi tulaŋ padaltŋgougetqas. A na Tair qure ti Saidon qure ti naŋgi degsim padaltnjrqasai. A naŋgi gulbe kiñala enjrqas. ");
INSERT INTO boj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","O Kaperneam tamo uŋgasari, niŋgi laŋ qureq oqwa kere e? Keresai. Qotei na niŋgi breiŋgimqa moiyo qureq aiqab.” ");
INSERT INTO boj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Osiqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Tamo bei a nuŋgo anjam qusim dauryqas di a ijo anjam dego qusim dauryqas. Ariya tamo a niŋgi qoreiŋgwas di a na e dego qoreibqas. Tamo a e qoreibqas di a na ijo Abu e qariŋbej qaji di dego qoreiyqas.” ");
INSERT INTO boj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesus na tamo 72 naŋgi di qariŋnjrnaq aisib aqa anjam mare mare laqneb. Onaqa bunuqna naŋgo wau di koboonaqa naŋgi olo puluosib Yesus aqa areq bosib areboleboleinjrnaqa minjeb, “O Tamo Koba, iga ino ñam na mondor uge uge naŋgi winjreqnamqa naŋgi gago anjam dauryoqnsib jaraiyoqneb.” ");
INSERT INTO boj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Onaqa Yesus na minjrej, “Kola minjal urur mandamq aiyeqnu dego kere Satan a urur laŋ goge na uloŋosiq aiyeqnaq e unonum. ");
INSERT INTO boj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Niŋgi quiy. E na Qotei aqa siŋgila niŋgi eŋgonum. Deqa niŋgi siŋgila di osib amal uge ti degiŋ ti naŋgo siŋgila tentoqnsib laqnqab. Gago jeu tamo Satan aqa siŋgila kalil dego niŋgi na kobotoqnqab. Deqa iŋgi bei na yala niŋgi ugeugeiŋgwa keresai. ");
INSERT INTO boj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mondor uge naŋgi nuŋgo anjam dauryoqnsib jaraiyeqnub di bolequja. Ariya niŋgi deqa tulaŋ areboleboleiŋgaiq. Qotei a nuŋgo ñam laŋ qureq di neŋgreŋyej unu. Niŋgi deqa tulaŋ areboleboleiŋgem.” ");
INSERT INTO boj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bati deqa Mondor Bole a Yesus aqaq aisiq areqalo siŋgilatetonaqa a tulaŋ areboleboleiyonaqa Qotei endegsi pailyej, “O Abu, ni segi laŋ qa ti mandam qa ti Koba. E ino ñam soqteqnum. Di kiyaqa? Ni ijo anjam kalil powo tamo naŋgi qa ulitoqnsimqa tamo naŋgi aŋgro du du bul unub qaji naŋgi segi qa babteqnam naŋgi poinjreqnu. Od, Abu, ni ino segi areqalo dauryosim agi degyeqnum.” ");
INSERT INTO boj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesus a degsi Qotei pailyej. Osiqa marej, “Ijo Abu na iŋgi iŋgi kalil ijo baŋq di ateleŋej unu. E segi Qotei aqa Ŋiri. Tamo bei a e qa qaliesai. Ijo Abu a segi e qa qalie. Tamo bei a ijo Abu qa qaliesai dego. E segi ijo Abu qa qalie. E na tamo qudei naŋgi ijo Abu osornjrqa areibqas di osornjrqai. Yim naŋgi dego ijo Abu qa qalieqab.” ");
INSERT INTO boj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesus a degsi marsiqa aqa aŋgro naŋgi joqsiqa naŋgi segi sasalosib a na minjrej, “Niŋgi nuŋgo ŋamdamu na ijo kumbra uneqnub deqa niŋgi tulaŋ areboleboleiŋgem. ");
INSERT INTO boj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Niŋgi quiy. Nami mandor kokba ti Qotei aqa medabu o tamo naŋgi ti gargekoba kumbra niŋgi bini uneqnub qaji di unqajqa are koba soqnej. Ariya naŋgi unosaioqneb. Anjam niŋgi bini queqnub qaji di dego naŋgi quqwajqa are koba soqnej. Ariya naŋgi quosaioqneb.” ");
INSERT INTO boj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Onaqa dal anjam qalie tamo bei a Yesus aqa siŋgila laŋa tenemtqa osiqa endegsi nenemyej, “O Qalie Tamo, e kumbra bole kiye dauryosiy dena e ŋambile gaigai sqai?” ");
INSERT INTO boj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Onaqa Yesus na kamba minjej, “Dal anjam neŋgreŋq di kiyersi unu? Ni gaigai sisiyeqnum. Deqa ni segi na mare.” ");
INSERT INTO boj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Onaqa tamo dena minjej, “Dal anjam endegsi unu, ‘Ni ino Tamo Koba Qotei a tulaŋ qalaqalaiyime. Qalaqalaiyosim ino are miligi ti ino qunuŋ ti ino siŋgila ti ino areqalo ti kalil a yekritime. Osim ni ino segi jejamu gereiyeqnum dego kere ino was naŋgi degsim geregereinjroqnime.’” ");
INSERT INTO boj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Onaqa Yesus na minjej, “Ni kere maronum. Deqa ni kumbra di yoqnqam dena ni ŋambile oqam.” ");
INSERT INTO boj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Onaqa tamo di a diqosiq aqa segi powo babtqa are qalsiq deqa olo Yesus nenemyej, “Tamo yai a ijo was unu deqa e na gereiyqai?” ");
INSERT INTO boj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Onaqa Yesus na kamba yawo anjam endegsi minjej, “Tamo bei a Jerusalem dena tigelosiqa gam dauryosiq Jeriko qureq aiyeqnaqa gamq di bajiŋ tamo qudei naŋgi na a ojsib aqa iŋgi iŋgi kalil yaiyekriteb. Osib aqa gara palontetosib qalougetonab a moiqa jojomonaqa gam qalaq di a uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A gam qalaq di ŋeiesonaqa atra tamo bei a gam dena walwelosiq gilsiq tamo di unej. Unsiqa a aqaryaiyqa uratosiqa gam qala beiq na buŋyosiqa gilej. ");
INSERT INTO boj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Onaqa sokiñalayonaq tamo bei a dego gam dena walwelosiq gilej. A Livai tamo. A atra tal taqatoqnej qaji. A gam dena walwelosiq tamo di gam qalaq di ŋeiesonaq unsiqa a dego tamo di aqaryaiyqa uratosiqa gam qala beiq na buŋyosiqa walwelosiq gilej. ");
INSERT INTO boj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","“Ariya olo sokiñalayonaq Samaria tamo bei a dego gam dena walwelosiq gilej. Gilsiq tamo di unsiqa a qa tulaŋ dulosiqa aqa areq bosiqa goreŋ ti wain ti osiq aqa jejamu pupoiyeleŋeb qaji di yanseleŋosiqa qoseleŋetej. Osiqa a soqtosiqa aqa donki quraq di atsiqa osi gilsiqa tamo ŋereŋo qaji talq di gereiyosiq taqatoqnej. ");
INSERT INTO boj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Onaqa nebeonaqa Samaria tamo di aqa segi qureq gilqa osiqa ŋereŋo qaji tal taqato tamo aqa baŋq di silali baŋga qudei atsiqa minjej, ‘Ni silali endena tamo di geregereiyoqne. E bosiy ino segi silali baŋga gembub ni olo uratqam di ni kamba emqai.’” ");
INSERT INTO boj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus na dal anjam qalie tamo di yawo anjam degsi minjsiqa olo minjej, “Tamo qalub naŋgi gam dena walwelosib gileb. Deqa ni merbe. Tamo yai a tamo gam qalaq di qalnab ŋeiesoqnej qaji aqa was bole?” ");
INSERT INTO boj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Onaqa dal anjam qalie tamo na kamba Yesus minjej, “Samaria tamo agi tamo deqa dulej qaji di aqa was bole.” Onaqa Yesus na minjej, “Ni kere maronum. Deqa ni gilsim kumbra degsim yoqne.” ");
INSERT INTO boj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Onaqa bati bei Yesus aqa aŋgro naŋgi koba na walwelosib aisib qure beiq di branteb. Qure dia uŋa bei soqnej aqa ñam Marta. A naŋgi joqsiq koba na aqa tal gogeteb. ");
INSERT INTO boj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta aqa jaja bei soqnej aqa ñam Maria. A Tamo Koba aqa siŋga jojomq di awoosiqa aqa anjam quoqnej. ");
INSERT INTO boj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ariya Marta a naŋgo iŋgi goiyetnjrqa marsiqa wau koba yoqnej. Osiqa Yesus aqa areq bosiq minjej, “O Tamo Koba, ijo jaja na e uratbqoqa e segi iŋgi goiyoqnsim iŋgi iŋgi kalil gereiyeqnum. A na e yala aqaryaibosai. Deqa ni na minjimqa a e aqaryaibem.” ");
INSERT INTO boj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Onaqa Tamo Koba a na kamba Marta minjej, “O Marta, ni iŋgi iŋgi kalil qa are koba qaleqnum. Ni iŋgi iŋgi deqa are kobaimaiq. ");
INSERT INTO boj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iŋgi qujai qa are qalqam di kere. Maria a iŋgi qujai di oqo. Iŋgi di tulaŋ boledamu. Iŋgi di tamo bei na olo yaiyqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Onaqa bati bei Yesus a sawa beiq gilsiq dia Qotei pailyosiq sonaqa aqa aŋgro bei na minjej, “O Tamo Koba, Jon a nami aqa aŋgro naŋgi pailyqajqa gam osornjroqnej dego kere ni na iga dego pailyqajqa gam osorge.” ");
INSERT INTO boj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Onaqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi Qotei pailyqa osibqa endegsib pailyoqniy, ‘O Abu, ino ñam tulaŋ getento. Ni bosim gago Mandor Koba sosim iga taqatgoqnime. ");
INSERT INTO boj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gago iŋgi uyo bati gaigai keretgoqnime. ");
INSERT INTO boj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tamo naŋgi iga qa une ateqnub qaji naŋgo une kalil iga na kobotetnjreqnum deqa ni kamba gago une kalil dego kobotetgoqnime. Gulbe bei na iga walawalaigosim uneq waigwa laqnimqa ni iga aqaryaigoqnime.’” ");
INSERT INTO boj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Osiqa Yesus na olo minjrej, “Ino kadoi bei a qolo jige ino talq bosimqa oqeq di tigelosim mermqas, ‘O kadoi, ijo was a sawa isaq na walwelosiq ijo talq bqoqa e iŋgi bei anaiyqajqa di saiqoji. Deqa ni bem qalub ebimqa e anaiyqai.’ ");
INSERT INTO boj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A degsi mermimqa ni na kamba minjqam, ‘Ni e ŋeio ŋam gentbaim. E siraŋ qandimtonum. E ijo aŋgro naŋgi ti ŋeiejunum. Deqa e ni bem emqa keresai.’ ");
INSERT INTO boj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ni na ino kadoi degsi minjimqa a ni tulaŋ waiŋmqas. Waiŋmimqa ni tigelosim bem yqam. A ino kadoi unu ni deqa are qalsim bem yqasai. A ni tulaŋ waiŋmqo deqa ni tigelosim iŋgi keretosim yqam. ");
INSERT INTO boj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Deqa e niŋgi endegsi merŋgwai. Niŋgi iŋgi bei qa Qotei pailyqab di a na eŋgwas. Niŋgi iŋgi bei oqa marsibqa ŋamqab di itqab. Niŋgi siraŋme kindokindoŋabqa Qotei na siraŋ waqtetŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tamo kalil Qotei pailyeqnub qaji naŋgi iŋgi eqnub. Tamo kalil iŋgi qa ŋameqnub qaji naŋgi iteqnub. Tamo kalil siraŋme kindokindoŋeqnub qaji naŋgi Qotei na siraŋ waqtetnjreqnu. ");
INSERT INTO boj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Tamo bei aqa aŋgro a mamyim qe qa minjimqa a qe yqas. A amal uge yqasai. ");
INSERT INTO boj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A na tuwe tawel qa minjimqa a tuwe tawel yqas. A degiŋ yqasai. ");
INSERT INTO boj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Deqa niŋgi quiy. Niŋgi tamo bolesai. Ariya niŋgi nuŋgo aŋgro naŋgi iŋgi bole bole enjreqnub. Niŋgi naŋgi saidnjrosaieqnub. Nuŋgo kumbra dena niŋgi endegsi poiŋgem, nuŋgo Abu laŋ qureq di unu qaji a dego niŋgi saidŋgosaieqnu. Niŋgi pailyqab di a na aqa Mondor Bole eŋgwas. A na niŋgi saidŋgwasai bole sai.” ");
INSERT INTO boj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Onaqa Yesus a tamo bei mondor uge na medabu getentesoqnej qaji di mondor uge wiyetej. Wiyetonaqa a olo boleosiqa anjam maroqnej. Deqa tamo uŋgasari naŋgi Yesus aqa maŋwa di unsibqa tulaŋ prugugeteb. ");
INSERT INTO boj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Onaqa tamo qudei naŋgi dego Yesus aqa maŋwa di unsib Yesus yomuiyosib maroqneb, “Mondor uge naŋgo gate koba Belsebul a Yesus aqa jejamuq di unu. Siŋgila dena a na mondor uge naŋgi winjreqnu.” ");
INSERT INTO boj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Onaqa tamo qudei naŋgi Yesus aqa siŋgila laŋa tenemtqa osib gisaŋyosib minjeb, “Ni Qotei laŋ goge di unu qaji aqa siŋgila bei babtim iga unqom.” ");
INSERT INTO boj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Onaqa Yesus a naŋgo areqalo di qalieosiqa yawo anjam endegsi minjrej, “Tamo naŋgi sawa qujaiq di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi koba na geregere sqa keresai. Naŋgi niñaqosib koboqab. Tamo naŋgi tal qujaiq di unub qaji naŋgi segi poaiyelosib qotqab di naŋgi dego koba na geregere sqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dego kere Satan na aqa segi mondor uge naŋgi winjrqas di naŋgi poaiyelqab. Deqa Satan a kiyersim aqa mondor uge naŋgi olo taqatnjrqas? Di keresai. Niŋgi mareqnub, ‘Yesus a Belsebul aqa siŋgila na mondor uge naŋgi winjreqnu.’ ");
INSERT INTO boj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Di sai. E Belsebul aqa siŋgila na mondor uge naŋgi winjrqai di yai aqa siŋgila na nuŋgo aŋgro naŋgi mondor uge winjrqab? Deqa naŋgi segi na merŋgwab, niŋgi anjam groteqnub. ");
INSERT INTO boj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ariya e Qotei aqa siŋgila na mondor uge naŋgi winjrqai di niŋgi endegsi poiŋgwas, ‘Bole, Qotei a gago Mandor Koba sosim iga taqatgwajqa bati brantqo.’ Niŋgi degsi poiŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tamo siŋgila koba bei a aŋ ti qaja ti ojeleŋosim aqa segi tal geregere taqatqas di aqa iŋgi iŋgi kalil bole sqab. ");
INSERT INTO boj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ariya tamo bei tulaŋ siŋgila koba a bosim tamo di ombla qotsim siŋgilaqas di a na qaja ti aŋ ti tal aqa abu a dena siŋgilaoqnej qaji di yaiyeleŋosim aqa iŋgi iŋgi kalil eleŋqas. Osim iŋgi iŋgi di tamo qudei naŋgo baŋq di olo ateleŋqas. ");
INSERT INTO boj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tamo bei na e beterbqasai di a na e jeutbqas. Tamo bei a e ombla wauqasai di a na ijo wau ugetetbqas.” ");
INSERT INTO boj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Osiqa Yesus a olo marej, “Mondor uge a tamo bei aqa jejamuq dena ulaŋosim sawa kaŋgraŋoq gilqas. Gilsim dia laqnsimqa aqaratqajqa sawa ŋamam ugeiyim marqas, ‘E olo puluosiy ijo tal uratem qaji deq olo aiqai.’ ");
INSERT INTO boj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","26","A degsi marsimqa aisim tal di nami maŋ solsib iŋgi iŋgi kalil gereiyeb milalejunu di unsimqa olo puluosim gilsim mondor uge 7 tulaŋ ugedamu naŋgi joqsim bosim koba na tal dia sqab. Soqnibqa tamo di aqa so tulaŋ ugeqas. Aqa so uge namij degwasai. Aqa so olo tulaŋ ugedamuqas.” ");
INSERT INTO boj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus a anjam degsi marnaqa tamo uŋgasari naŋgo ambleq dena uŋa bei a brantosiqa tulaŋ leleŋosiqa Yesus minjej, “Ino ai agi ni nami ŋambabtmosiqa muŋgum anaimoqnej qaji a Qotei aqa ŋamgalaq di uŋa tulaŋ bolequja. Deqa a tulaŋ areboleboleiyim sqas.” ");
INSERT INTO boj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Onaqa Yesus na kamba minjej, “Ijo ai a segi areboleboleiyqasai. Tamo naŋgi Qotei aqa anjam quoqnsib dauryeqnub qaji naŋgi dego tulaŋ areboleboleinjrim sqab.” ");
INSERT INTO boj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Onaqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus aqa areq di koroeqnabqa a na naŋgi endegsi minjroqnej, “Tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra tulaŋ ugedamu. Naŋgi gaigai Qotei aqa maŋwa laŋa unqajqa metbeqnub. Deqa e na Qotei aqa maŋwa bei naŋgi osornjrqasai. Jona aqa maŋwa segi osornjritqa naŋgi unqab. ");
INSERT INTO boj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Agi Jona a segi maŋwa bul sonaqa tamo uŋgasari Ninive qureq di soqneb qaji naŋgi maŋwa di uneb. Dego kere e Tamo Aŋgro maŋwa bul soqnit tamo uŋgasari bini bati endeqa unub qaji naŋgi maŋwa di unqab. ");
INSERT INTO boj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mondoŋ Qotei na tamo uŋgasari naŋgi peginjrqa batiamqa uŋa mandor nami guta di sawa taqatoqnej qaji a tigelqas. Tigelosimqa tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra uge babtetnjrqas. A degyqas. Di kiyaqa? Uŋa di a nami Solomon aqa powo kobaquja unqa marsiqa sawa isaq na walwelosi bej deqa. Ariya bini tamo bei Solomon tulaŋ buŋyejunu qaji a nuŋgo ambleq di unu. ");
INSERT INTO boj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mondoŋ Qotei na tamo uŋgasari naŋgi peginjrqa batiamqa Ninive tamo naŋgi dego tigelqab. Tigelosibqa tamo uŋgasari bini bati endeqa unub qaji naŋgo kumbra uge babtetnjrqab. Naŋgi degyqab. Di kiyaqa? Ninive tamo naŋgi nami Jona aqa anjam qusib are bulyeb deqa. Ariya bini tamo bei Jona tulaŋ buŋyejunu qaji a nuŋgo ambleq di unu.” ");
INSERT INTO boj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Osiqa Yesus a olo marej, “Tamo bei a lam qatrentosim tal surumq di atqasai. Kulum miligiq jugwasai. Boleq di gaintim warum suwaŋamqa tamo uŋgasari naŋgi tal miligiq gilsib warum geregere unqab. ");
INSERT INTO boj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ino ŋamdamu a ino jejamu qa puloŋ bul. Deqa ino ŋamdamu boleqas di ino jejamu kalil suwaŋesqas. Ariya ino ŋamdamu ugeqas di ino jejamu kalil ambruesqas. ");
INSERT INTO boj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Deqa niŋgi geregere unoqniy. Nuŋgo jejamu suwaŋejunu qaji di olo ambruo uge. ");
INSERT INTO boj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ino jejamu kalil suwaŋekritqas di taqal bei ambruqa keresai. Deqa ino jejamu kalil suwaŋoq di soqneme. Lam puloŋosiq ni suwantmeqnu dego kere.” ");
INSERT INTO boj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus a anjam degsi marsiq koboonaqa Farisi tamo bei a Yesus aqa areq bosiq minjej, “Aqo ombla ijo talq gilsim iŋgi uyqom.” Osiqa naŋgi ombla aqa talq gilsib awoeb. ");
INSERT INTO boj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Awoosib Yesus a iŋgi uyqa osiqa a mati baŋ yansosaisosiq laŋa uyej. Deqa Farisi tamo a Yesus aqa kumbra di unsiqa tulaŋ prugugetej. ");
INSERT INTO boj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Onaqa Tamo Koba a na minjej, “Niŋgi Farisi nuŋgo kumbra uge agi ubtosiy merŋgwai. Niŋgi ya gambaŋ ti tabir ti qore segi yanseqnub. Niŋgi miligi yansosaieqnub. Di yawo anjam. Aqa damu agiende. Niŋgi babaŋ na tamo bole. Ariya nuŋgo are miligi kumbra uge ti bajiŋ kumbra ti dena maqejunu. ");
INSERT INTO boj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Niŋgi nanari tamo! Qotei a nuŋgo jejamu gereiyosiqa nuŋgo are miligi dego gereiyej. Di niŋgi qaliesai kiyo? ");
INSERT INTO boj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Deqa iŋgi iŋgi kalil nuŋgo are miligiq di unu qaji di niŋgi eleŋosib tamo iŋgi saiqoji naŋgi enjroqniy. Niŋgi kumbra degyibqa nuŋgo iŋgi iŋgi kalil milalesqas. ");
INSERT INTO boj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Farisi tamo, niŋgi tulaŋ padalougetqab. Di kiyaqa? Niŋgi dal anjam kiñilala segi dauryeqnub. Agi niŋgi lei ti lombo ti saga ti oqnsib poto 10 yoqnsib oto qujai Qotei atraiyeqnub. Ariya niŋgi Qotei aqa dal anjam kokba dauryqajqa urateqnub. Agi niŋgi kumbra bole bole dauryosaieqnub. Niŋgi Qotei qalaqalaiyosaieqnub. Niŋgi dal anjam kiñilala segi dauryeqnub. Deqa e niŋgi endegsi merŋgwai. Niŋgi are bulyosib dal anjam kokba dauryosib laqniy. Niŋgi dal anjam kiñilala dego dauryqa urataib. ");
INSERT INTO boj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O Farisi tamo, niŋgi tulaŋ padalougetqab. Di kiyaqa? Niŋgi Qotei tal miligiq di tamo ñam ti naŋgo awo jaramq di awoqajqa tulaŋ areboleboleiŋgeqnu. Niŋgi koro sawaq di dego tamo uŋgasari naŋgi na nuŋgo ñam soqtetŋgosib baŋ ojetŋgwajqa deqa areboleboleiŋgeqnu. ");
INSERT INTO boj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“O Farisi tamo, niŋgi tulaŋ padalougetqab. Di kiyaqa? Niŋgi tamo moiyo qaji sub bul unub. Sub gogeq di mariŋ na kabutqo. Deqa tamo uŋgasari naŋgi quraq na walweloqnqab di naŋgi qalieqasai.” ");
INSERT INTO boj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesus a anjam degsi marnaqa dal anjam qalie tamo bei a Yesus aqa anjam di qusiqa minjej, “O Qalie Tamo, ni Farisi naŋgi anjam degsi minjronum deqa ni gago ñam dego ugetoiyonum.” ");
INSERT INTO boj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Onaqa Yesus na kamba minjej, “O dal anjam qalie tamo, niŋgi dego tulaŋ padalougetqab. Di kiyaqa? Niŋgi tamo uŋgasari naŋgi gulbe kokba enjreqnab qoboiyoqnsib unub. Ariya niŋgi na olo naŋgo gulbe di qoboiyetnjrosaieqnub. ");
INSERT INTO boj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Niŋgi tulaŋ padalougetqab. Di kiyaqa? Nuŋgo moma naŋgi nami Qotei aqa medabu o qaji tamo naŋgi ñumeqnab moreŋoqneb. Ariya niŋgi na olo naŋgo sub gereiyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nuŋgo kumbra dena niŋgi endegsib marobuleqnub, ‘Gago moma naŋgo kumbra bole.’ Niŋgi degsib marobuleqnub. Agi nuŋgo moma naŋgi Qotei aqa medabu o qaji tamo naŋgi ñumoqneb. Ariya niŋgi na olo naŋgo sub gereiyeqnub. ");
INSERT INTO boj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Utru deqa Qotei powo koba ti unu qaji a endegsi marej, ‘E ijo medabu o tamo naŋgi ti ijo anjam maro tamo naŋgi ti qariŋnjritqa tamo uŋgasari bini bati endeqa unub qaji naŋgoq giloqnibqa naŋgi na naŋgi jeutnjroqnsib tulaŋ ugeugeinjroqnqab. Osib qudei ñumoqnib moreŋoqnqab.’ ");
INSERT INTO boj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","O dal anjam qalie tamo, Qotei a nuŋgo moma naŋgo une kalil osim tamo uŋgasari bini bati endeqa unub qaji naŋgo jejamuq di ateleŋqas. Nuŋgo moma naŋgo une di agi naŋgi nami yqajqa utru atsib Kein na Abel qalnaq moiyej. Qotei a mandam atej bati deqa naŋgi une di yqajqa utru ateb. Dena bosi bosib Sekaraia atra bijal ti atra tal ti ambleq di qalnab moiyej. E bole merŋgwai. Une kalil di aqa awai uge Qotei na osim tamo uŋgasari bini bati endeqa unub qaji naŋgi enjrqas. ");
INSERT INTO boj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O dal anjam qalie tamo, niŋgi tulaŋ padalougetqab. Di kiyaqa? Tamo uŋgasari naŋgi Qotei qalieqajqa gam itqa mareqnabqa niŋgi na olo gam getentetnjreqnub. Niŋgi segi Qotei qalieqajqa gam itqa keresai. Deqa tamo uŋgasari naŋgi dego gam di itqa yeqnab niŋgi na olo gam getentetnjreqnub.” ");
INSERT INTO boj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Osiqa Yesus a tigelosiqa tal di uratosiq gilej. Bati deqa dal anjam qalie tamo naŋgi ti Farisi naŋgi ti a qa minjiŋ oqetnjrnaqa anjam gargekoba nenemyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","A anjam bei grotimqa naŋgi a ojqajqa deqa anjam gargekoba nenemyoqnsib a dadauryoqneb. ");
INSERT INTO boj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Onaqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus unqajqa bosib koroosib jujuŋkobaeb. Siŋga waiyosib walwelqa keresai. Deqa tamo qudei na tamo qudei naŋgo siŋga sosetnjroqneb. Bati deqa Yesus a aqa aŋgro naŋgi joqsiqa naŋgi sasalosib a na minjrej, “Niŋgi geregere ŋam atoqniy. Farisi naŋgi gisaŋ tamo. Naŋgi anjam maro aiyelteqnub. Bem tiyeqnu qaji sum Farisi naŋgo bem ti bulyimqa bem dena tiyekritosim tulaŋ kobaqujaqas. ");
INSERT INTO boj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Deqa niŋgi quiy. Kumbra kalil kabuejunu qaji di boleq dqas. Anjam kalil uliejunu qaji di tamo naŋgi qusib poinjrqas. ");
INSERT INTO boj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Deqa anjam kalil niŋgi ambruq di mareqnub qaji di suwaŋamqa tamo naŋgi quqwab. Anjam kalil niŋgi warum miligiq di mareqnub qaji di tamo naŋgi bijal gogeq di tigelosib palontqab.” ");
INSERT INTO boj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Osiqa Yesus a olo marej, “O ijo aŋgro, niŋgi quiy. Niŋgi jeu tamo naŋgi ulainjraib. Naŋgi nuŋgo jejamu segi qalsib moiyotqa kere. Naŋgi niŋgi gulbe bei eŋgwa keresai. Deqa niŋgi naŋgi ulainjraib. ");
INSERT INTO boj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tamo niŋgi ulaiyqab qaji agi deqa merŋgwai. Qotei a segi nuŋgo jejamu moiyotosim bunuqna nuŋgo qunuŋ dego ŋamyuwoq waiyqa kere. Deqa niŋgi a segi ulaiyiy. ");
INSERT INTO boj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Niŋgi qalie. Tamo naŋgi qebari sinjir silali kobaquja na awaiyosaieqnub. Silali kiñala na awaiyeqnub. Ariya Qotei na qebari sinjir naŋgi geregere taqatnjreqnu. A na naŋgi uratnjrosaieqnu. ");
INSERT INTO boj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dego kere Qotei a nuŋgo gate baŋga segi segi sisiyoqnsiq geregere taqateqnu. Deqa niŋgi ulaaib. Niŋgi qebari kalil naŋgi tulaŋ buŋnjrejunub.” ");
INSERT INTO boj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Osiqa Yesus a olo marej, “E Tamo Aŋgro. Niŋgi mandam tamo naŋgo ulatamuq di ijo ñam boleq atsib marqab di mondoŋ e na kamba Qotei aqa laŋ aŋgro naŋgo ulatamuq di nuŋgo ñam boleq atsiy marqai. ");
INSERT INTO boj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ariya niŋgi mandam tamo naŋgo ulatamuq di ijo ñam marqajqa asgiŋgwas di mondoŋ e kamba dego Qotei aqa laŋ aŋgro naŋgo ulatamuq di nuŋgo ñam marqajqa asgibqas. ");
INSERT INTO boj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“E Tamo Aŋgro. Tamo bei na e misiliŋbqas une di Qotei na kobotqas. Ariya tamo bei na Mondor Bole misiliŋyqas une di Qotei na kobotqasai. ");
INSERT INTO boj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bunuqna Juda tamo kokba naŋgi niŋgi ojsib naŋgo Qotei tal miligiq di tigeltŋgosib nenemŋgibqa niŋgi na kamba anjam kiye minjrqajqa deqa are koba qalaib. Rom naŋgo gate ti naŋgo mandor ti naŋgo ulatamuq di dego niŋgi tigeltŋgibqa niŋgi na kamba anjam minjrqajqa ulaaib. ");
INSERT INTO boj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bati deqa Mondor Bole na areqalo eŋgimqa niŋgi anjam marqab.” ");
INSERT INTO boj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Onaqa tamo uŋgasari koroesoqneb qaji naŋgo ambleq dena tamo bei a tigelosiqa Yesus minjej, “O Qalie Tamo, ni ijo was minjimqa a na gago abu moiyej qaji aqa ñoro kalil ambleq na potosim taqal bei ebqas.” ");
INSERT INTO boj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Onaqa Yesus na minjej, “Tamo yai na e giltbqo deqa e nuŋgo gulbe di gereiyqai?” ");
INSERT INTO boj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Degsi minjsiqa tamo uŋgasari kalil naŋgi endegsi minjrej, “Niŋgi ñoro koba oqajqa mamaulŋgaiq. Niŋgi ñoro koba ti sqab dena niŋgi ŋambile bole oqa keresai. Niŋgi ijo anjam deqa geregere are qaloqniy.” ");
INSERT INTO boj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Osiqa yawo anjam bei endegsi minjrej, “Ñoro tamo bei soqnej. Aqa wauq di iŋgi tulaŋ koba melioqnej. ");
INSERT INTO boj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Deqa a endegsi are qalej, ‘E kiyerqai? Ijo iŋgi tulaŋ koba melieleŋqo. Deqa e iŋgi di atqajqa tal keresaiibqo.’ ");
INSERT INTO boj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Osiqa marej, ‘E endegyqai. E ijo tal kalil koŋeleŋosiy olo tal kokba ateleŋqai. Osiy ijo iŋgi meli kalil tal kokbaq di jugwai. Ijo ñoro kalil dego dia jugeleŋqai. ");
INSERT INTO boj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jugeleŋosiy marqai, “Ijo iŋgi iŋgi tulaŋ koba agi atonum unu. Deqa e aqaratosiy laŋa awesqai. Sosiy iŋgi ti ya ti uyoqnsiy areboleboleiboqnqas. Wausau gargekoba gilqas ijo iŋgi iŋgi di koboqasai.” ’ ");
INSERT INTO boj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tamo di a degsi marnaqa Qotei na minjej, ‘Ni nanari tamo. Qolo qujai endeqa e ino qunuŋ yaimitqa ni moiqam. Yimqa iŋgi iŋgi kalil ni na gereiyosim atonum qaji di tamo yai na olo oqas?’ Qotei na degsi minjej. ");
INSERT INTO boj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dego kere tamo naŋgi ñoro koba koroiyejunub qaji naŋgo ñoro qoji padalqab. Naŋgi laŋ qure qa ñoro saiqoji unub deqa naŋgi Qotei aqa ŋamgalaq di sougetesosib moreŋqab.” ");
INSERT INTO boj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Osiqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “Niŋgi mandamq endi bole sqajqa deqa areqalo kobaiyaib. Osib endegsib maraib, ‘Iga iŋgi qabe na osim uyqom? Gara qabe na osim gago jejamu kabutqom?’ Niŋgi degsib maraib. ");
INSERT INTO boj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Niŋgi iŋgi uyo na segi ŋambile oqasai. Niŋgi gara jugoqnqab dena segi nuŋgo jejamu bole sqasai. ");
INSERT INTO boj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Niŋgi qebari naŋgi unjriy. Naŋgi iŋgi yagosaieqnub. Iŋgi otorosib talq di atosaieqnub. Ariya Qotei na qebari naŋgi iŋgi anainjreqnu. Niŋgi qalie, qebari naŋgi qunuŋ saiqoji. Niŋgi tamo qunuŋ ti. Niŋgi qebari naŋgi tulaŋ buŋnjrejunub. ");
INSERT INTO boj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Niŋgi mandamq endi sokobaiyqajqa deqa are koba qalaib. Niŋgi are koba qalqab dena niŋgi nuŋgo segi sqajqa bati olo yala totoryqa keresai. Sai bole sai. ");
INSERT INTO boj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Niŋgi wau kiñala deqaji yqa keresai deqa niŋgi kiyaqa iŋgi qudei qa are koba qaleqnub? ");
INSERT INTO boj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Niŋgi ŋam so unjriy. Naŋgo wala kiyersib branteqnub di niŋgi qaliesai. Naŋgi segi wauosaieqnub. Naŋgo segi wala gereiyosaieqnub. Deqa e niŋgi endegsi merŋgwai. Nami Solomon a gara wala boledamu jugoqnej. Ariya ŋam so aqa wala dena Solomon aqa wala tulaŋ buŋyejunu. ");
INSERT INTO boj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Maŋ laŋaj a bini oqwas nebe tamo naŋgi na giŋgeŋyosib ŋamyuwoq waiyqab. Maŋ laŋaj di Qotei na wala enjreqnu. Deqa niŋgi kiyaqa Qotei qa nuŋgo areqalo siŋgilatqa yonub keresaiiŋgwo? Niŋgi maŋ laŋaj sai. Niŋgi tamo qunuŋ ti. Deqa niŋgi endegsi poiŋgem, Qotei a niŋgi dego gara eŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Niŋgi areqalo kobaiyosib endegsib maraib, ‘Iga iŋgi ti ya ti qabe na osim uyqom?’ Niŋgi degsib maraib. ");
INSERT INTO boj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tamo uŋgasari Qotei qaliesai qaji naŋgi iŋgi iŋgi deqa are koba qaleqnub. Ariya niŋgi deqa are koba qalaib. Nuŋgo Abu a qalie, niŋgi laŋa sqa keresai. Niŋgi iŋgi iŋgi deqaji oqnsib sqab. ");
INSERT INTO boj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Deqa niŋgi Qotei na taqatŋgosim nuŋgo Mandor Koba sqajqa siŋgilaoqniy. Niŋgi degyqab di Qotei na kamba iŋgi uyo ti gara ti dego eŋgoqnqas.” ");
INSERT INTO boj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Osiqa Yesus a olo marej, “O ijo kaja du du niŋgi ulaaib. Nuŋgo Abu a nuŋgo Mandor Koba sosim niŋgi taqatŋgwajqa areareteqnu. ");
INSERT INTO boj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Deqa niŋgi kumbra endegyiy. Niŋgi nuŋgo ñoro kalil qariŋyosib silali osib tamo iŋgi iŋgi saiqoji naŋgi di jeisib enjriy. Osib silali jugwajqa quŋ ugeosaieqnu qaji di gereiyosib laŋ qure qa iŋgi iŋgi eleŋosib di jugeleŋoiy. Iŋgi iŋgi di koboqa keresai. Bajiŋ tamo naŋgi bosib oqasai. Sisimbiŋ na ugetqasai. Iŋgi iŋgi di gaigai sqas. ");
INSERT INTO boj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sawa qabia ino ñoro bole unu dia ino are miligi dego siŋgilatim sqas.” ");
INSERT INTO boj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Osiqa Yesus a olo marej, “Niŋgi nuŋgo gara tigeleŋosib nuŋgo iŋgi iŋgi kalil gereiyosib waŋal qatrentosib ijo bqajqa bati qa tariŋosib soqniy. ");
INSERT INTO boj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tamo bei a goiyo kobaq dena olo bosim aqa talq di brantosim siraŋme kindokindoŋamqa aqa kaŋgal tamo naŋgi a qa tariŋejunub qaji naŋgi siraŋme waqtoqujatqab. Dego kere niŋgi ijo bqajqa bati qa tariŋosib soqniy. ");
INSERT INTO boj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tal lanja aqa kaŋgal tamo naŋgi a qa tariŋosib ŋam atoqnibqa bosim degsi unjrimqa naŋgi tulaŋ areboleboleinjrqas. Deqa a na naŋgi metnjrim awoeleŋabqa iŋgi anainjroqnqas. ");
INSERT INTO boj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A qolo jige kiyo nebeqa laqnimqa kiyo bosim aqa kaŋgal tamo naŋgi a qa tariŋosib ŋam atoqnibqa degsi unjrimqa naŋgi tulaŋ areboleboleinjrqas. ");
INSERT INTO boj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Niŋgi are qaliy. Bati gembu bajiŋ tamo a bosim tal paratqas di tal lanja a qalieqasai. A nami qalieosiq sonaq qamu bajiŋ tamo a bosiq tal paratqa yonaq unsiq wiyej qamu. ");
INSERT INTO boj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dego kere e Tamo Aŋgro bqajqa bati niŋgi qaliesai. E bosiy niŋgi pruqtŋgaim deqa niŋgi geregere ŋam atoqnsib e qa tariŋoqnsib soqniy.” ");
INSERT INTO boj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Onaqa Pita na Yesus minjej, “O Tamo Koba, ni yawo anjam maronum di iga segi quqwajqa kiyo tamo uŋgasari kalil naŋgi dego quqwajqa kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Onaqa Tamo Koba a na minjej, “Kaŋgal tamo yai a areqalo bole ti sosiqa gaigai wau bole yeqnu? Kaŋgal tamo di tal lanja na endegsi minjqas, ‘Ni na ijo kaŋgal tamo kalil naŋgi geregere taqatnjroqnsimqa naŋgo iŋgi uyqajqa batioqnimqa iŋgi anainjroqne.’ ");
INSERT INTO boj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Degsi minjsimqa sawa beiq gilsim di sqas. Olo puluosim wau kalil a na aqa kaŋgal tamo yej qaji di kalil keretosim soqnimqa a bosim unimqa kaŋgal tamo di a tulaŋ areboleboleiyqas. ");
INSERT INTO boj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Deqa e bole merŋgwai. Kaŋgal tamo di a wau boledamu yej deqa tal lanja na aqa iŋgi iŋgi kalil osim aqa baŋq di atim a na taqatetoqnqas. ");
INSERT INTO boj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ariya kaŋgal tamo di a endegsi are qalqas, ‘Ijo tamo koba a urur bqasai.’ Degsi are qalsimqa a na kaŋgal tamo ti kaŋgal uŋa ti naŋgi laŋa laŋa kumbaiŋnjroqnqas. Osim iŋgi ti wain ti uyoqnsim nanarioqnqas. ");
INSERT INTO boj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aqa tamo koba bqajqa bati a qaliesai deqa a kumbra degsim yoqnimqa aqa tamo koba brantoqujatosim unimqa a tulaŋ prugugetqas. Deqa aqa tamo koba na a qalougetosim tamo naŋgi Qotei qa naŋgo areqalo siŋgilatosaieqnub qaji naŋgo so sawaq waiyim aiqas. ");
INSERT INTO boj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tal lanja na aqa kaŋgal tamo bei minjqas, ‘Ni wau di ye.’ Yimqa a geregere qusim ariya a olo asgimosim wau di yosaiamqa tal lanja na a kumbaiŋyogargekobatqas. ");
INSERT INTO boj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ariya tal lanja na aqa kaŋgal tamo bei minjqas, ‘Ni wau di ye.’ Yimqa a geregere quosai deqa a wau di yosaiamqa tal lanja na a jiŋga na kumbaiŋyoqujaitqas. Niŋgi quiy. Qotei na tamo bei wau koba yimqa a wau di ojsim olo wau tulaŋ koba dego ojeme. Qotei na tamo bei aqa baŋq di wau koba atimqa a wau di taqatosim olo wau tulaŋ koba dego taqateme.” ");
INSERT INTO boj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Osiqa Yesus a olo marej, “E ŋamyuwo waiyit mandamq aiqas. E deqa bem. Deqa e Qotei endegsi pailyeqnum, ‘O Abu, ŋamyuwo di urur puloŋeme.’ ");
INSERT INTO boj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Niŋgi quiy. E yanso bei oqai. E yanso di osaiunum deqa e are tulaŋ gulbekobaibeqnu. ");
INSERT INTO boj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","O ijo aŋgro, niŋgi kiyersib are qalonub? E na qaja kobotitqa tamo uŋgasari naŋgi geregere lawo na sqajqa e deqa bem kiyo? Sai. E na qaja kobotqajqa bosai. E na tamo uŋgasari naŋgi pupoinjritqa naŋgi jeu jeu sqajqa deqa bem. ");
INSERT INTO boj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bini bati endeqa ti bunuq qa ti tamo 5 tal qujaiq di unub qaji naŋgi ijo ñam qa jeu jeu sqab. Tamo qalub naŋgi na tamo aiyel jeutnjroqnqab. Tamo aiyel naŋgi na tamo qalub jeutnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abu naŋgi na naŋgo segi aŋgro mel naŋgi jeutnjroqnqab. Aŋgro mel naŋgi na naŋgo segi abu naŋgi jeutnjroqnqab. Ai naŋgi na naŋgo segi aŋgro sebiŋ naŋgi jeutnjroqnqab. Aŋgro sebiŋ naŋgi na naŋgo segi ai naŋgi jeutnjroqnqab. Aiŋ qeli naŋgi na naŋgo segi aiŋ yala naŋgi jeutnjroqnqab. Aiŋ yala naŋgi na naŋgo segi aiŋ qeli naŋgi jeutnjroqnqab.” ");
INSERT INTO boj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Osiqa Yesus na tamo uŋgasari kalil naŋgi endegsi minjrej, “Seŋ aiyoq dena laŋbi tigelamqa niŋgi unsib marqab, ‘Awa bqas.’ Degsib marqab awa bqas. ");
INSERT INTO boj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Meli jagwa bamqa niŋgi unsib marqab, ‘Sawa kaŋkaŋqas.’ Degsib marqab sawa kaŋkaŋqas. ");
INSERT INTO boj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Niŋgi gisaŋ ani. Niŋgi mandam ti laŋ ti unoqnsib geregere pegiyeqnub. Ariya kiyaqa kumbra bini branteqnu qaji di niŋgi unoqnsib utru poiŋgosaieqnu?” ");
INSERT INTO boj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Osiqa Yesus a olo marej, “Kumbra bole ti kumbra uge ti di niŋgi kiyaqa geregere pegiyosaieqnub? ");
INSERT INTO boj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamo bei a ni qa anjam soqnimqa niŋgi ombla walwelosib anjam pegiyo talq giloqnsibqa gamq di niŋgi segi aiyel anjam urur gereiyoqujatiy. Yosib anjam moiyotosib a ni osim anjam pegiyo talq gilqasai. Ariya niŋgi gamq di anjam gereiyqasai di a na ni osi gilsimqa anjam pegiyo tamo aqa ulatamuq di tigeltmimqa anjam pegiyo tamo a ni osim qaja tamo naŋgo baŋq di atqas. Yimqa naŋgi na ni osib tonto talq di waimqab. ");
INSERT INTO boj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Deqa e ni mermqai. Ni tonto talq dena olo oqedqasai. Ni mati ino une aqa awai kalil keretimqa di ni uratmib oqedqam.” ");
INSERT INTO boj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Onaqa bati deqa tamo qudei naŋgi Yesus aqa areq bosib minjeb, “O Tamo Koba, Galili tamo qudei naŋgi wagme osib Qotei atraiyeqnabqa Pailat na aqa qaja tamo naŋgi qariŋnjrnaq gilsib naŋgi ñumnab naŋgo leŋ aisiq wagme naŋgo leŋ ti tuturej.” ");
INSERT INTO boj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Onaqa Yesus na minjrej, “Niŋgi kiyersib are qalonub? Galili tamo naŋgi di une gargekoba yoqneb deqa gulbe di naŋgoq di brantej. Galili tamo qudei naŋgi une gargekoba yosaieqnub. Niŋgi degsib are qalonub kiyo? ");
INSERT INTO boj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Di sai. E niŋgi merŋgwai. Niŋgi are bulyqasai di niŋgi kalil dego padalqab. ");
INSERT INTO boj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jerusalem dia tal olekoba aqa ñam Siloam di puosiqa tamo 18 naŋgi ñumnaq moreŋeb. Deqa niŋgi kiyersib are qalonub? Tamo 18 moreŋeb qaji naŋgi une gargekoba yoqneb deqa naŋgi degsib moreŋeb. Tamo qudei Jerusalem di unub qaji naŋgi une gargekoba yosaieqnub. Niŋgi degsib are qalonub kiyo? ");
INSERT INTO boj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Di sai. E niŋgi merŋgwai. Niŋgi are bulyqasai di niŋgi kalil dego padalqab.” ");
INSERT INTO boj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Osiqa Yesus a yawo anjam bei endegsi marej, “Tamo bei a aqa wauq di qura yagej. Bunuqna a qura gei oqajqa marsiq bej. Bosiq unej qura geitosai. ");
INSERT INTO boj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Deqa a na aqa wau taqato tamo minjej, ‘Ni que. Wausau qalub gilqo e boqnsim ŋam atoqnem qura geitosai. Deqa uŋgum. Qomsim waiy. A kiyaqa mandam aqa namur laŋa saitqas?’ ");
INSERT INTO boj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Onaqa wau taqato tamo na minjej, ‘O Tamo Koba, ni mati uratim soqnem. Wausau qujai endeqa e na qura utruq di moror qamsiy namur atsiy unqai. ");
INSERT INTO boj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Degyitqa wausau bei qa geitqas kiyo sai kiyo? Saiamqa ni marim e qomsiy waiyqai.’” Yesus a yawo anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","11","Onaqa yori bationaqa Yesus a Juda naŋgo Qotei tal miligiq gilsiqa Qotei aqa anjam minjroqnej. Minjroqnsiqa ŋam atej uŋa bei sonaq unej. Uŋa di a maiyej. Mondor uge na ma yonaqa wausau 18 a groŋosiq laqnej. A tiŋtiŋ tigelqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Deqa Yesus na uŋa di unsiq metonaqa aqa areq bonaqa minjej, “O uŋa, ni que. Endego ino ma di ni uratmqas.” ");
INSERT INTO boj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Degsi minjsiqa uŋa aqa jejamuq di baŋ atnaqa aqa ma koboonaqa a tiŋtiŋ tigelosiqa Qotei aqa ñam soqtoqnej. ");
INSERT INTO boj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Onaqa Qotei tal taqato tamo a Yesus aqa maŋwa di unsiqa minjiŋ oqetej. Di kiyaqa? Yesus a yori bati qa uŋa di boletej deqa. Deqa Qotei tal taqato tamo na tamo uŋgasari naŋgi endegsi minjrej, “Bati 6 iga waueqnum. Deqa wau qa bati segi nuŋgo ma boletqajqa boqniy. Yori bati qa nuŋgo ma boletqajqa baib.” ");
INSERT INTO boj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Onaqa Tamo Koba a na kamba minjej, “Niŋgi gisaŋ tamo. Niŋgi yori bati gaigai nuŋgo makau ti donki ti tontonub unub di sil palontoqnsib joqoqnsib ya anainjreqnub. ");
INSERT INTO boj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ariya uŋa endi a Abraham aqa moma. Satan na ma yonaqa wausau 18 ma ti soqnej. Deqa e kiyaqa yori bati qa aqa ma di uratit sqas? Sai. E boletqai.” ");
INSERT INTO boj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus a degsi marnaqa aqa jeu tamo kalil naŋgi aqa anjam di qusibqa jemainjrej. Kumbra kalil Yesus a yoqnej qaji di tulaŋ bolequja deqa tamo uŋgasari kalil naŋgi tulaŋ areboleboleinjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Onaqa Yesus a olo marej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Yawo anjam kiye niŋgi merŋgitqa Qotei aqa kumbra di aqa utru niŋgi geregere poiŋgwas? ");
INSERT INTO boj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Od, e qalieonum. Qotei aqa kumbra di tamo bei na sis yago osiq aqa wauq di yagej dego kere. Bunuqna sis a oqsiq tulaŋ kobaqujaonaqa qebari naŋgi bosib aqa daniq di simi ateleŋeb.” ");
INSERT INTO boj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Osiqa Yesus a olo marej, “Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Yawo anjam kiye niŋgi merŋgitqa Qotei aqa kumbra di aqa utru niŋgi geregere poiŋgwas? ");
INSERT INTO boj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Od, e qalieonum. Qotei aqa kumbra di bem tiyeqnu qaji sum bul. Uŋa bei a bem tiyeqnu qaji sum kiñala osiqa bem sum laŋaj ti turtosiq web kobaqujaq di bulyonaqa bem kalil tiyekritej.” ");
INSERT INTO boj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus a dena tigelosiqa Jerusalem aiqajqa gam dauryosiq qure kokba ti qure kiñilala ti dia Qotei aqa anjam minjre minjre aiyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aiyeqnaqa tamo bei na minjej, “O Tamo Koba, Qotei na tamo quja quja segi eleŋqas kiyo? Ni iga geregere merge.” Onaqa Yesus na kamba minjrej, ");
INSERT INTO boj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Niŋgi siraŋme kiñala miligiq gilqajqa siŋgilaoiy. E niŋgi merŋgwai. Tamo gargekoba naŋgi siraŋme kiñala miligiq gilqajqa siŋgilaoqnib ugeinjroqnqas. ");
INSERT INTO boj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tal aqa abu a tigelosim siraŋme kabutimqa niŋgi oqeq di tigelosibqa siraŋme kindokindoŋosib minjoqnqab, ‘O Tamo Koba, ni na siraŋme waqtetgime.’ Amqa a na kamba merŋgwas, ‘Niŋgi tal qabe? E niŋgi qaliesai.’ ");
INSERT INTO boj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Degsi merŋgimqa niŋgi na minjqab, ‘O Tamo Koba, iga ni ombla iŋgi ti ya ti uyoqnem. Ni gago qureq di Qotei aqa anjam plaltosim mergoqnem.’ ");
INSERT INTO boj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Degsib minjibqa a na kamba merŋgwas, ‘Niŋgi tal qabe? E niŋgi qaliesai. Deqa niŋgi kalil jaraiyiy. Niŋgi kumbra uge yo qaji tamo.’ ");
INSERT INTO boj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","A na niŋgi degsim merŋgsim niŋgi qalaq di breiŋgwas. Yimqa Abraham, Aisak, Jekop, Qotei aqa medabu o qaji tamo kalil naŋgi ti Qotei na taqatnjrsim naŋgo Mandor Koba sqas. Soqnimqa niŋgi naŋgi unjrsibqa akamkobaoqnsib pailoqnsib nuŋgo jaqatiŋ qa qalagei anjam atoqnqas. ");
INSERT INTO boj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamo uŋgasari gargekoba naŋgi sawa guta na guma na tauŋ na bebeŋ na ti bosib Qotei aqa siŋgaq di koroeleŋabqa Qotei a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. Yimqa naŋgi Qotei ombla awoosib iŋgi uyoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Deqa niŋgi quiy. Tamo qudei bini ñam ti unub qaji naŋgi mondoŋ ñam saiqoji sqab. Ariya tamo qudei bini ñam saiqoji unub qaji naŋgi mondoŋ ñam ti sqab.” ");
INSERT INTO boj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Onaqa bati deqa Farisi qudei naŋgi Yesus aqa areq bosib minjeb, “Mandor Herot a ni lumsim moiyotmqa mareqnu. Deqa ni sawa endi uratosim ulaŋ.” ");
INSERT INTO boj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Onaqa Yesus na kamba minjrej, “Niŋgi gilsib gisaŋ tamo Herot a endegsib minjiy, ‘Yesus a marqo, “Bini e mondor uge uge naŋgi winjroqnsiyqa tamo ma ti naŋgi boletnjroqnqai. Nebe dego e wau di yoqnqai. Ariya alieb e ijo wau di kobotqai.” ’ Niŋgi gilsib Herot degsib minjiy. ");
INSERT INTO boj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bini e walwelosi aisiy nebe olo tigelosiy aisiy ariya alieb e Jerusalem di brantqai. E degyqai. Di kiyaqa? Jerusalem dia qujai jeu tamo naŋgi na Qotei aqa medabu o tamo naŋgi ñumeqnab moreŋeqnub. Naŋgi qure beiq di naŋgi ñumosaieqnub. ");
INSERT INTO boj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem qure, O Jerusalem qure, ni na Qotei aqa medabu o tamo naŋgi ñumoqnsim moiyotnjreqnum. Osim tamo uŋgasari Qotei na inoq qariŋnjreqnu qaji naŋgi meniŋ na ñumeqnam moreŋeqnub. Bati gargekoba e ino aŋgro naŋgi tuwe du du bul koroinjrqajqa yeqnam ni saideqnum. ");
INSERT INTO boj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Deqa niŋgi quiy. Qotei a nuŋgo atra tal koba uratetŋgimqa a laŋa sqas. Deqa e niŋgi endegsi merŋgwai. Niŋgi olo e nubqasai. Degsim gilsim mondoŋ e olo laŋ qureq na boqnitqa niŋgi e nubsib marqab, ‘Tamo a bqo endi Tamo Koba aqa ñam na bqo. Deqa Qotei na a tulaŋ geregereiyeqnu.’” ");
INSERT INTO boj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yori bati bei Yesus a Farisi gate bei aqa talq gilsiqa a ombla iŋgi uyoqneb. Iŋgi uyeqnabqa tamo qudei tal dia soqneb qaji naŋgi Yesus koqyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yesus aqa areq di tamo bei jejamu suŋyeleŋej qaji a awesoqnej. ");
INSERT INTO boj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Deqa Yesus na tamo di unsiqa dal anjam qalie tamo naŋgi ti Farisi naŋgi ti endegsi nenemnjrej, “Niŋgi mariy. Yori bati qa tamo boletqajqa di kere kiyo? Dal anjam a kiyersi marqo?” ");
INSERT INTO boj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Onaqa naŋgi na kamba anjam bei Yesus minjosai. Naŋgi mequmesoqneb. Deqa Yesus na tamo di aqa jejamu ojsiqa aqa ma boletej. Osiqa qariŋyonaq gilej. ");
INSERT INTO boj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Onaqa Yesus na Farisi naŋgi olo nenemnjrej, “Nuŋgo aŋgro kiyo nuŋgo makau kiyo yori bati qa uloŋosim subq aiyimqa niŋgi na aqaryaiyosib subq dena osib goge atqab e? Niŋgi na merbiy.” ");
INSERT INTO boj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Onaqa naŋgi na kamba olo anjam bei Yesus minjqa yonab keresaiinjrej. ");
INSERT INTO boj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bati deqa Yesus a ŋam atej di tamo qudei naŋgi iŋgi uyo qa marsib talq bosib tamo ñam ti naŋgo awo jaramq di awoosib iŋgi uyeqnab unjrej. Deqa a na naŋgi yawo anjam endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Tamo bei na maruro atsim ni metmimqa ni tamo ñam ti naŋgo awo jaramq di namo awoaim. Ni tamo ñam ti naŋgo awo jaramq di awoqam di goiyo lanja na tamo ñam ti bei metim bam ni mermqas, ‘Ni awo jaram di uratosim tamo endi yim awoqas.’ Yim ni jemaimim tamo laŋaj naŋgo awo jaramq di awoqam. ");
INSERT INTO boj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Deqa tamo bei na maruro atsim metmimqa ni tamo laŋaj naŋgo awo jaramq di awo. Yimqa goiyo lanja na bosim mermqas, ‘O was, ni bosim tamo ñam ti naŋgo awo jaramq endi awo.’ Yim tamo kalil iŋgi uyeqnub qaji naŋgo ŋamgalaq di ni ñam ti sqam. ");
INSERT INTO boj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tamo kalil naŋgo segi ñam soqteqnub qaji naŋgi Qotei na olo ñam aguq atetnjrqas. Ariya tamo naŋgo segi ñam aguq ateqnub qaji naŋgi Qotei na olo ñam soqtetnjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Osiqa Yesus na goiyo lanja minjej, “Ni maruro atsimqa ino segi was naŋgi ti ino segi kadoi naŋgi ti tamo uŋgasari ñoro koba ejunub qaji naŋgi ti metnjraim. Ni degyqam di ni endegsi are qalqam, ‘Naŋgi na kamba maruro atsib e metbib gilit iŋgi anaibqab.’ ");
INSERT INTO boj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ni degyaim. Ni maruro atsimqa tamo ñoro saiqoji naŋgi ti tamo jejamu lainjro qaji naŋgi ti tamo siŋga uge naŋgi ti tamo ŋam qandimo naŋgi ti metnjrim bab iŋgi anainjre. ");
INSERT INTO boj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Amqa ni tulaŋ areboleboleimqas. Di kiyaqa? Naŋgi ni kamba iŋgi anaimqa keresai. Deqa mondoŋ tamo bole bole naŋgi olo subq na tigelo batiamqa Qotei na kamba awai tulaŋ boledamu ni emqas.” ");
INSERT INTO boj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesus a anjam degsi marnaqa tamo bei Yesus ombla awoosib iŋgi uyoqneb qaji a qusiqa minjej, “Mondoŋ Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas. Sosimqa a na naŋgi iŋgi anainjrim awoosib koba na iŋgi uyoqnqab. Deqa naŋgi tulaŋ areboleboleinjrim sqab.” ");
INSERT INTO boj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Onaqa Yesus na kamba yawo anjam bei endegsi minjej, “Tamo bei a maruro atqa osiqa tamo gargekoba naŋgi aqa maruro unqa metnjrej. ");
INSERT INTO boj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aqa maruro bati brantonaqa a na aqa kaŋgal tamo bei qariŋyonaq gilsiqa tamo naŋgi di minjrej, ‘Niŋgi boiy. Iŋgi iŋgi kalil gereiyosib atonub unu.’ ");
INSERT INTO boj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Degsi minjrnaqa naŋgi kalil bqa urateb. Osib minjoqneb, ‘Iga bqa keresai.’ Bei na minjej, ‘E mandam bunuj awaiyonum. Di unqajqa aiqai. Deqa ni goiyo lanja minje, “E bqa keresai.” ’ ");
INSERT INTO boj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Bei na minjej, ‘E makau bunuj 10 awaiyem. Deqa bini e naŋgi wau enjrqai. Deqa ni goiyo lanja minje, “E bqa keresai.” ’ ");
INSERT INTO boj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bei na minjej, ‘E bini uŋa bunuj onum. Deqa e dego bqa keresai.’ ");
INSERT INTO boj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Onaqa kaŋgal tamo a olo puluosiq aisiq anjam kalil naŋgi na minjeb qaji di aqa tamo koba minjnaqa a minjiŋ oqetonaqa olo qariŋyosiqa minjej, ‘Ni urur gilsimqa gam kokbaq di gam kiñilalaq di tamo iŋgi iŋgi saiqoji naŋgi ti tamo jejamu lainjro qaji naŋgi ti tamo ŋam qandimnjro qaji naŋgi ti tamo siŋga ugeinjro qaji naŋgi ti itnjrsimqa joqsim ijo talq boiy.’ ");
INSERT INTO boj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Onaqa kaŋgal tamo a olo gilsiqa tamo naŋgi di kalil joqsi bosiqa aqa tamo koba minjej, ‘O Tamo Koba, e ino anjam dauryosim agi naŋgi kalil joqsi bonum. Ariya ino tal tamo na maqosai unu.’ ");
INSERT INTO boj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Onaqa goiyo lanja na olo aqa kaŋgal tamo qariŋyosiqa minjej, ‘Ni gilsim gam kalilq dena ti nañuq dena ti tamo naŋgi joqsim boiy. Naŋgi kalil babqa ijo tal magwas. ");
INSERT INTO boj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","E ni mermqai. Tamo naŋgi e nami metnjronum bqa uratonub qaji naŋgi ijo maruro unqasai.’” ");
INSERT INTO boj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesus a dena tigelosiqa walwelosiq aiyeqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi a dauryosib aiyoqneb. Deqa a bulosiqa naŋgi endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tamo bei a e daurbqa osimqa aqa abu, aqa ai, aqa ŋauŋ, aqa aŋgro naŋgi, aqa was naŋgi, aqa jaja naŋgi, aqa segi jejamu dego jeutnjrqasai di a ijo aŋgro sqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tamo bei na aqa segi ŋamburbas qoboiyosim e daurbqasai di a ijo aŋgro sqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Osiqa naŋgi endegsi minjrej, “Tamo bei a tal atqa osimqa a mati awoosim tal kobotqajqa aqa awai geregere are qalsim aqa silali sisiyqas. Aqa silali kereqas kiyo sai kiyo degsi are qalqas. ");
INSERT INTO boj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","A mati degsi are qalqasai di a tal aqa utru atsim bati amble di aqa silali saiamqa tal kobotqa keresaiiyimqa tamo naŋgi unsib a kikiyosib minjqab, ‘Ni tal aqa utru atem di ni kobotqa keresai.’ Yim a jemaiyqas. ");
INSERT INTO boj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Mandor bei na mandor bei qoto itqa marsimqa a mati awoosim geregere endegsi are qalqas, ‘Ijo qaja tamo 10 tausen naŋgi na mandor di aqa qaja tamo 20 tausen naŋgi ñumsib winjrqa kere kiyo?’ ");
INSERT INTO boj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A degsi are qalsim marqas, ‘E na mandor di qoto buŋyqa keresai.’ Degsi marsimqa aqa wau tamo qudei naŋgi qariŋnjrim gilsib mandor di minjqab, ‘Uŋgum, iga qotqa uratonum.’ ");
INSERT INTO boj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Dego kere tamo bei na e daurbqa osimqa a mati aqa segi iŋgi iŋgi kalil uratqasai di a ijo aŋgro sqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Osiqa Yesus a olo marej, “Bar a bole. Iŋgiq di bar atoqnib aqa uyo boledamuqas. Ariya bar aqa qajarara koboqas di iŋgi kiye na olo qajararatqas? Di keresai. ");
INSERT INTO boj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bar aqa qajarara koboqas di a ugeqas. Iga bar di mandam ti bulyonamqa mandam namuryqa keresai. Deqa iga bar di uratosim waiyqom. Tamo a dabkala ti sqas di a ijo anjam endi geregere quem.” ");
INSERT INTO boj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bati bei takis o qaji tamo naŋgi ti une tamo naŋgi ti kalil Yesus aqa anjam quqwa marsibqa aqa areq bosib koroeb. ");
INSERT INTO boj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Koroonabqa Farisi naŋgi ti dal anjam qalie tamo naŋgi ti Yesus yomuiyosib mareb, “Yesus a une tamo naŋgi joqoqnsiqa koba na iŋgi uyeqnub.” ");
INSERT INTO boj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Degsib marnabqa Yesus a naŋgo anjam di qusiqa yawo anjam endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tamo bei aqa kaja 100 naŋgi ñiŋ uyoqnibqa qujai bei alelamqa a na kaja 99 naŋgi uratnjrsim qujai alelqo qaji di ŋamosim gilsim itqas. ");
INSERT INTO boj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Itosim areboleboleiyim soqtosim qoboiyqas. ");
INSERT INTO boj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Qoboiyosim aisim aqa qureq di brantosim aqa was naŋgi ti aqa qure qujai naŋgi ti kalil koroinjrsimqa minjrqas, ‘Niŋgi uniy. Ijo kaja alelqo qaji agi olo itonum! Deqa niŋgi e ombla areboleboleigim sqom!’” ");
INSERT INTO boj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Osiqa Yesus a olo marej, “Dego kere une tamo qujai a are bulyqas di laŋ goge dia naŋgi a qa tulaŋ areboleboleinjrqas. Tamo 99 naŋgi mareqnub, ‘Iga tamo bole une saiqoji. Deqa iga are bulyqasai.’ Naŋgi qa laŋ goge dia naŋgi areboleboleinjrqasai. Ariya une tamo qujai a are bulyqas di naŋgi a qa tulaŋ areboleboleinjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Osiqa Yesus a olo marej, “Uŋa bei aqa meniŋ silali 10 soqnimqa meniŋ silali qujai loumimqa a waŋal qatrentosim aqa talq di maŋ solsim ŋamosim itqas. ");
INSERT INTO boj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Itosim gilsim aqa was naŋgi ti aqa qure qujai naŋgi ti kalil koroinjrsimqa minjrqas, ‘Ijo meniŋ silali qujai loumqo qaji agi olo itonum! Deqa niŋgi e ombla areboleboleigim sqom!’” ");
INSERT INTO boj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Osiqa Yesus a olo marej, “Dego kere une tamo qujai a are bulyqas di Qotei aqa laŋ aŋgro naŋgi a qa tulaŋ areboleboleinjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Osiqa Yesus a olo marej, “Tamo bei aqa ŋiri aiyel soqneb. ");
INSERT INTO boj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bati bei ŋiri yala na aqa abu minjej, ‘O Abu, ni ino ñoro kalil ambleq na potosim taqal bei e ebe.’ Degsi minjnaqa abu na aqa ñoro ambleq na potosiqa taqal bei aqa ŋiri yala yej. Taqal bei aqa ŋiri koba yej. ");
INSERT INTO boj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Onaqa bati bei ŋiri yala na aqa ñoro kalil qariŋyosiqa silali osiq tigelosiqa sawa beiq gilej. Gilsiq dia diqosi laqnsiqa aqa silali kalil uyekritej. ");
INSERT INTO boj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Onaqa sawa dia mam koba aiyej deqa ŋiri yala a iŋgi tulaŋ saiiyej. ");
INSERT INTO boj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Deqa a sawa deqaji tamo bei aqaq gilnaqa minjej, ‘Ni ijo bel taqatnjroqnsim iŋgi anainjroqne.’ ");
INSERT INTO boj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Onaqa a bel naŋgi taqatnjroqnsiqa iŋgi anainjroqnej. Osiqa are qaloqnej, ‘E mam koba unum. Deqa e endegyqai. Bel naŋgi iŋgi oto uratoqnibqa di oqnsiy uyoqnitqa dena e kereoqnqas.’ A degsi are qalsiq soqnej. Di kiyaqa? Tamo bei na iŋgi anaiyosaioqnej deqa. ");
INSERT INTO boj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Osiqa olo are qalej, ‘E kumbra grotonum deqa e mam na moiqa laqnum. Ijo abu aqa wau tamo naŋgi iŋgi koba uyeqnub. E segi qujai mam na moiqa laqnum. ");
INSERT INTO boj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Deqa e olo puluosiy ijo abu aqaq aisiy minjqai, “O Abu, e Qotei aqa ŋamgalaq di une kobaquja atonum. Ino ŋamgalaq di dego e une kobaquja atonum. ");
INSERT INTO boj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Deqa e ino aŋgro sqa keresai. Deqa ni marimqa e ino wau tamo sosiy ni wauetmoqnqai.” ’ ");
INSERT INTO boj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Degsi are qalsiqa tigelosiq aqa abu aqaq olo aiyej. “Aiyeqnaqa aqa abu ŋam atsiqa isaq di unsiq a qa tulaŋ dulosiqa urur ti gilsiq a soqoŋyosiqa qalaqalaiyoqnsiqa kundoqyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Onaqa minjej, ‘O Abu, e Qotei aqa ŋamgalaq di une kobaquja atonum. Ino ŋamgalaq di dego e une kobaquja atonum. Deqa e ino aŋgro sqa keresai.’ ");
INSERT INTO boj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Degsi minjnaqa aqa abu na aqa kaŋgal tamo qudei naŋgi minjrej, ‘Niŋgi urur ti gilsib gara jugo tulaŋ boledamu olekoba di osi bosib jigetiy. Baŋriŋ dego osi bosib aqa baŋ duq di jigetiy. Siŋga tatal dego osib aqa siŋgaq di jigeleŋetiy. ");
INSERT INTO boj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Makau meli bunuj didiqo di qalsib goiyiy. Goisib osib babqa iga koba na uysim areboleboleigim sqom. ");
INSERT INTO boj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iga degyqom. Di kiyaqa? Ijo aŋgro yala a moiyobulosiq olo ŋambile sosiq bqo deqa. A loumej agi gagoq di olo brantqo.’ Degsi minjrnaqa naŋgi aqa anjam kalil di dauryosib makau goisib koba na awoosib areboleboleinjrnaq soqneb. ");
INSERT INTO boj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","“Ariya ŋiri koba a wauq di sosiq dena puluosi bosiq tal jojomyosiqa naŋgi areboleboleinjreqnaq lou tueqnab qusiqa kaŋgal aŋgro bei metonaq aqa areq bonaqa nenemyej, ‘Naŋgi kiyaqa lou tueqnub?’ ");
INSERT INTO boj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Degsi nenemyonaqa kaŋgal aŋgro dena minjej, ‘Ino was yala a olo bqo. Deqa ino abu na makau meli bunuj didiqo di qalqo naŋgi uyoqnsib areboleboleinjreqnaq lou tueqnub. Aqa aŋgro a bole sosiq olo brantqo deqa lou tueqnub.’ ");
INSERT INTO boj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Degsi minjnaq qusiqa ŋiriŋosiq qudalej. Osiqa tal miligiq gilqa uratej. Deqa aqa abu a talq dena oqedosiqa minjej, ‘O ijo aŋgro, ni tal miligiq au. Bamqa iga koba na awoosim iŋgi uysim areboleboleigim sqom.’ ");
INSERT INTO boj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Onaqa ŋiri koba a na kamba aqa abu minjej, ‘O Abu, ni que. E wausau gargekoba ino anjam dauryosim ni wauetmoqnem. E ino anjam bei gotraŋyosaioqnem. Ni deqa e qa are qalsim kaja du bei qalsim goiyosaieqnum. E ijo kadoi naŋgi ti koba na areboleboleigosaieqnu. ");
INSERT INTO boj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ariya ino aŋgro yala a na ino ñoro osiqa gam qaji uŋa naŋgi ombla sambalaoqnsiq silali kalil uyekritej. Osiq olo bqoqa ni a qa tulaŋ areboleboleimqoqa makau meli bunuj didiqo di agi qaletonum.’ ");
INSERT INTO boj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Degsi minjnaqa aqa abu na kamba minjej, ‘O ijo aŋgro, ni gaigai e ombla unum. Ijo iŋgi iŋgi kalil di ino dego. ");
INSERT INTO boj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ariya bini iga maruro atsimqa areboleboleigeqnu. Di kiyaqa? Ino was a moiyobulosiq olo ŋambile sosiq bqo. A loumej agi gagoq di olo brantqo.’” ");
INSERT INTO boj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Osiqa Yesus a olo aqa aŋgro naŋgi endegsi minjrej, “Ñoro tamo bei soqnej. Aqa ñoro kalil aqa wau tamo bei na taqatoqnej. Bati bei tamo qudei na ñoro tamo di minjeb, ‘Ino ñoro taqato tamo a ino ñoro kalil laŋa uyeqnu.’ ");
INSERT INTO boj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Degsi minjnabqa a na ñoro taqato tamo di metonaq aqa areq bonaqa minjej, ‘Ni qa anjam degsi merbonubqa e quonum. Ni kiyaqa kumbra degyonum? Deqa ijo ñoro kalil ni uyonum qaji di sisiyosim merbimqa e geregere qalieosiy ni kobotmqai. Yim ni ijo ñoro olo bunu taqatqasai.’ ");
INSERT INTO boj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Onaqa ñoro taqato tamo di a segi are qalej, ‘E kiyerqai? Ijo tamo koba a na e kobotbqa marqo. E siŋgila saiqoji deqa e wau bei yqa keresai. E tamo qudei naŋgi minjrit silali laŋa ebqab di e jemaibqas. ");
INSERT INTO boj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Deqa e kiyerqai? E qalieonum. Tamo qudei nami ijo tamo koba aqaq dena ñoro osib naŋgi a kamba olo yqajqa minjeb qaji naŋgi di metnjrqai. Metnjrit ijoq babqa ñoro nami eb qaji di e na aguq atitqa naŋgi e qa tulaŋ areboleboleinjrqas. Deqa ijo tamo koba a na e wibimqa tamo naŋgi dena e osib naŋgo talq di e geregereiboqnqab.’ ");
INSERT INTO boj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","A degsi are qalsiqa tamo kalil nami aqa tamo koba aqaq dena ñoro eb qaji naŋgi metnjrnaq bonabqa tamo namo bej qaji di nenemyej, ‘Ni ñoro gembub ijo tamo koba aqaq dena em?’ ");
INSERT INTO boj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Onaqa minjej, ‘E goreŋ kulum 100 em.’ Degsi minjnaqa ñoro taqato tamo na minjej, ‘Ni olo goreŋ kulum 50 segi neŋgreŋye.’ ");
INSERT INTO boj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Osiqa tamo bei nenemyej, ‘Ni ñoro gembub ijo tamo koba aqaq dena em?’ Onaqa minjej, ‘E bem sum aqa quŋ 100 em.’ Degsi minjnaqa ñoro taqato tamo na minjej, ‘Ni olo bem sum aqa quŋ 80 segi neŋgreŋye.’ ");
INSERT INTO boj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Onaqa ñoro tamo a aqa ñoro taqato tamo aqa kumbra gisaŋ di poiyonaqa aqa ñam soqtosiq minjej, ‘Ni keretonum.’ Degsi minjej. Di kiyaqa? Ñoro taqato tamo uge di a powo ti sosiq deqa kumbra gisaŋ di yej. Deqa niŋgi quiy. Mandam endeqa tamo uŋgasari naŋgi mandam qaji powo koba ti unub. Ariya suwaŋqa tamo uŋgasari naŋgi mandam qaji powo kiñala ti unub. ");
INSERT INTO boj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Deqa e niŋgi endegsi merŋgwai. Niŋgi mandam qaji ñoro uge oqnsib dena tamo uŋgasari naŋgi kumbra bole enjroqnib naŋgi niŋgi qa tulaŋ areboleboleinjroqnqas. Yim bunuqna niŋgi moisib mandam qaji ñoro uge kalil uratibqa Qotei na niŋgi joqsim tal gaigai sqas qaji dia niŋgi geregereiŋgwas. ");
INSERT INTO boj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Niŋgi ñoro kiñala geregere taqatqab di niŋgi ñoro qelikoba dego geregere taqatqab. Ariya niŋgi ñoro kiñala geregere taqatqasai di niŋgi ñoro qelikoba dego geregere taqatqasai. ");
INSERT INTO boj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Niŋgi mandam qaji ñoro uge geregere taqatqasai di niŋgi laŋ qure qaji ñoro dego geregere taqatqasai. Deqa tamo yai na laŋ qure qaji ñoro nuŋgo baŋq di atqas? Tamo dego bei sosai. ");
INSERT INTO boj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Niŋgi tamo bei aqa ñoro geregere taqatqasai di niŋgi nuŋgo segi ñoro dego geregere taqatqasai. Deqa tamo yai na ñoro bei nuŋgo baŋq di atqas? Tamo dego bei sosai. ");
INSERT INTO boj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tamo qujai a tamo kokba aiyel naŋgi wauetnjrqa keresai. A tamo kobaquja bei qalaqalaiyosim olo tamo kobaquja bei jeutqas. Bei aqa anjam dauryosim olo bei qoreiyqas. Dego kere niŋgi silali ti Qotei ti turtnjrsib naŋgi wauetnjrqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Onaqa Farisi naŋgi Yesus aqa anjam di qusib a yomuiyeb. Farisi naŋgi bati gaigai silali oqnqajqa are koba soqnej. Utru deqa naŋgi Yesus yomuiyeb. ");
INSERT INTO boj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Onaqa Yesus na kamba minjrej, “Niŋgi are qaleqnub, ‘Iga kumbra bole bole laŋa babaŋ na yoqnim tamo uŋgasari naŋgi na iga nugoqnsib iga tamo bole qa mergwab.’ Niŋgi degsib are qaleqnub. Di gisaŋ. Nuŋgo are miligi di Qotei a segi qalie. Kumbra qudei tamo naŋgi deqa arearetnjreqnu qaji di Qotei aqa ŋamgalaq di kumbra tulaŋ ugedamu. ");
INSERT INTO boj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nami Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti maroqneb dena bosi bosiq Jon aqa bati brantej. Jon aqa bati brantej dena bosiq bini ijo anjam maro tamo naŋgi Qotei aqa anjam bole palonteqnub. Palonteqnab tamo uŋgasari kalil naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqajqa tulaŋ siŋgilaeqnub. ");
INSERT INTO boj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Laŋ ti mandam ti koboqab. Ariya Qotei aqa dal anjam mutu kiñala bei koboqasai bole sai.” ");
INSERT INTO boj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Osiqa Yesus a olo marej, “Tamo bei na aqa ŋauŋ uratosim olo uŋa bei oqas di a na aqa ŋauŋ kumbra ugeq waiyqo. Uŋa bei dego aqa gumbuluŋ na a uratimqa bunuqna tamo bei na olo oqas di tamo bunuj dena uŋa di kumbra ugeq waiyqo.” ");
INSERT INTO boj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Osiqa Yesus a olo marej, “Ñoro tamo bei soqnej. A bati gaigai gara wala bole jugoqnsiqa tulaŋ areboleboleiyeqnaqa iŋgi bole bole uyoqnsiq soqnej. ");
INSERT INTO boj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aqa tal meq di tamo bei iŋgi tulaŋ saiqoji aqa ñam Lasarus a bati gaigai awooqnsiq ŋeioqnsiq soqnej. Aqa jejamu kalil yu na ugetej. ");
INSERT INTO boj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Deqa a tal meq di awesonaqa ñoro tamo a iŋgi uyeqnaqa ñeŋgi ululoŋeqnaqa osiq uyoqnej. Aqa yuq dena leŋ aiyeqnaqa bauŋ naŋgi boqnsib naŋgo meŋ na yu bilgetoqneb. ");
INSERT INTO boj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Bati bei Lasarus a moiyej. Moinaqa Qotei aqa laŋ aŋgro naŋgi bosib aqa qunuŋ osib Abraham aqa areq di awoteb. Bunuqna ñoro tamo a dego moinaqa subq ateb. ");
INSERT INTO boj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","24","Subq atnabqa aqa qunuŋ aisiq moiyo qureq di soqnej. Sosiqa jaqatiŋ kobaiyeqnaqa tarosiqa Abraham isaq di sonaq unej. Lasarus a Abraham aqa areq di awesonaq unsiqa tulaŋ maosiqa Abraham minjej, ‘O Abu Abraham, e ŋamyuwoq endi sosimqa tulaŋ kaŋkaŋoqnsim jaqatiŋ koba eqnum. Deqa ni e qa are ugeimimqa Lasarus minjim aqa baŋ gei yaq di tuqtosim bosim ijo meŋq di atimqa kiñala ulilibqas.’ ");
INSERT INTO boj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Onaqa Abraham na minjej, ‘O aŋgro, ni are qale. Ni nami mandamq di sosimqa ni iŋgi bole bole uyoqnem. Ariya Lasarus a iŋgi uge uge uyoqnej. Deqa bini Lasarus a sawa boleq endi sosiqa a tulaŋ areboleboleiyeqnu. Ariya ni ŋamyuwoq di sosimqa jaqatiŋ koba eqnum. ");
INSERT INTO boj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ni ŋam atsim une. Ni iga ti ambleq di sub guma koba unu. Deqa iga sub di laqaiosim nuŋgoq bqa keresai. Niŋgi dego sub di laqaiosib gagoq bqa keresai.’ ");
INSERT INTO boj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Onaqa ñoro tamo dena kamba Abraham minjej, ‘O Abraham, ni na Lasarus minjimqa olo puluosim ijo abu aqa talq gilsim ijo was 5 naŋgi saidnjrimqa naŋgi sawa uge endeq bqasai.’ ");
INSERT INTO boj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Onaqa Abraham na minjej, ‘Ino was naŋgi Moses aqa dal anjam qalieonub. Naŋgi Qotei aqa medabu o qaji tamo naŋgo anjam dego qalieonub. Naŋgi anjam di dauryqab di kere.’ ");
INSERT INTO boj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Onaqa ñoro tamo dena olo minjej, ‘O Abu Abraham, di keresai. Ariya tamo moiyej qaji a subq na tigelosim anjam minjrqas di naŋgi qusib are bulyosib dauryqab.’ ");
INSERT INTO boj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Onaqa Abraham na minjej, ‘Tamo naŋgi Moses aqa dal anjam ti Qotei aqa medabu o qaji tamo naŋgo anjam ti qusib are bulyqasai di tamo bei a subq na tigelosim naŋgi anjam minjrqas di dego naŋgi qusib are bulyqasai.’” ");
INSERT INTO boj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Osiqa Yesus na aqa aŋgro naŋgi olo endegsi minjrej, “Bunuqna tamo qudei na tamo qudei uneq breinjroqnqab. Bole, kumbra di brantoqnqas. Ariya tamo naŋgi kumbra di yoqnqab qaji naŋgi tulaŋ padalougetqab. ");
INSERT INTO boj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iga tamo deqaji naŋgi ojsim meniŋ kobaquja osim sil na naŋgo kakroq di tontosim breinjrim ya robuq aiqab di kere. Yim naŋgi bunuqna aŋgro kiñala bei uneq waiyqasai. ");
INSERT INTO boj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Deqa niŋgi geregere ŋam atoqniy. Ino was bei a une bei atimqa ni na minje, ‘Une di urat.’ Yim a ino anjam di qusim are bulyqas di ni aqa une di torei moiyotime. ");
INSERT INTO boj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ariya a bati qujai qa une 7 ni emoqnsim olo boqnsim ni mermoqnqas, ‘O was, e kumbra grotonum.’ Degsi mermo 7 yimqa ni aqa une kalil di torei moiyotime.” ");
INSERT INTO boj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Onaqa Yesus aqa anjam maro tamo naŋgi na minjeb, “O Tamo Koba, gago areqalo ni qa siŋgilateqnum qaji di ni na olo kobaqujatime.” ");
INSERT INTO boj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Onaqa Tamo Koba a na kamba minjrej, “Nuŋgo areqalo e qa siŋgilato qaji di sis yago bul kiñala sqas di kereqas. Degesqas di niŋgi subar endi minjibqa a nuŋgo anjam dauryosim jirim qoji waqosim aisim yuwalq di tigelqas.” ");
INSERT INTO boj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Osiqa Yesus a olo marej, “Tamo bei na aqa kaŋgal tamo qariŋyonaqa gilsiqa aqa iŋgi wauq di mandam qamsiq bulyej. Osiqa aqa kaja naŋgi dego taqatnjrej. Ariya a wau di kobotimqa aqa tamo koba a na kiyersi minjqas? ‘Ni namo iŋgi uye’ degsi minjqas e? Sai. ");
INSERT INTO boj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A minjqas, ‘Ni ijo iŋgi goiyetbosim gara tigsim iŋgi suweiyosim ebimqa iŋgi ti ya ti uyqai. Uyit menetbimqa bunu ni kamba iŋgi ti ya ti uyqam.’ A na aqa kaŋgal tamo degsi minjqas. Di kiyaqa? A kaŋgal tamo laŋaj deqa. ");
INSERT INTO boj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kaŋgal tamo dena aqa tamo koba aqa anjam dauryimqa a na kamba aqa ñam soqtetqasai. Osim ‘Ni keretonum’ degsi minjqasai. Di kiyaqa? A kaŋgal tamo laŋaj deqa. ");
INSERT INTO boj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dego kere niŋgi Qotei aqa kaŋgal tamo sosibqa wau kalil a na niŋgi eŋgoqnqas qaji di yoqniy. Yoqnsib maroqniy, ‘Iga kaŋgal tamo laŋaj. Deqa wau kalil Qotei na iga egeqnu qaji di agi yeqnum.’” ");
INSERT INTO boj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus a dena tigelosiqa Jerusalem aiqajqa gam dauryosiqa Samaria sawa ti Galili sawa ti ambleq na walwelosiq aiyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Aiyoqnsiq qure beiq di brantej. Onaqa tamo 10 naŋgo jejamu yu na ugeeleŋej qaji naŋgi bosib Yesus itosibqa naŋgi kiñala isaq di tigelosib tulaŋ maosib minjeb, “O Tamo Koba, ni iga qa dulosim aqaryaige.” ");
INSERT INTO boj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Onaqa Yesus a naŋgi unjrsiqa minjrej, “Niŋgi olo puluosib aisib nuŋgo jejamu atra tamo naŋgi osornjriy.” Degsi minjrnaqa naŋgi aiyoqnsibqa gamq di naŋgo yu kalil mosoonaqa naŋgo jejamu boleonaq uneb. ");
INSERT INTO boj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Onaqa naŋgo ambleq dena qujai a segi olo puluosiqa Yesus aqa areq gilej. A leleŋ ti Qotei aqa ñam soqtoqnsiq giloqnej. ");
INSERT INTO boj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Gilsiq Yesus aqa siŋgaq di siŋga pulutosiqa biŋiyosiq minjej, “O Tamo Koba, ni keretosim ijo jejamu boletonum.” Tamo di a Samaria qaji. ");
INSERT INTO boj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Onaqa Yesus a tamo di unsiqa marej, “E na tamo 10 naŋgo jejamu boletetnjronumqa ariya qujai a segi ijoq bqo. Tamo 9 naŋgi qabi unub? ");
INSERT INTO boj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Naŋgi olo ijoq bosai. Naŋgi Qotei aqa ñam soqtosai dego. Sawa bei qaji tamo endi a segi qujai olo bosiq Qotei aqa ñam soqtqo.” ");
INSERT INTO boj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus a degsi marsiqa tamo di minjej, “Ni tigelosim aiye. Ni ino areqalo e qa siŋgilatonum deqa ino jejamu boleqo.” ");
INSERT INTO boj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bati bei Farisi naŋgi Yesus endegsib nenemyeb, “Bati gembu Qotei a bosim aqa segi tamo uŋgasari naŋgo Mandor Koba sosim naŋgi taqatnjrqas?” Onaqa Yesus na minjrej, “Qotei a Mandor Koba sqajqa bati brantoqnimqa maŋwa bei namoqna bam niŋgi unqasai. ");
INSERT INTO boj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tamo bei na endegsi merŋgwasai, ‘Niŋgi uniy, Mandor Koba a bqo agiende,’ o ‘Mandor Koba a bqo agide.’ Degyqasai. Niŋgi quiy. Bini Qotei a nuŋgo ambleq endi Mandor Koba unu.” ");
INSERT INTO boj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Osiqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “E Tamo Aŋgro. Bati bei brantimqa niŋgi ijo bqajqa bati unqa maroqnsib unqasai. ");
INSERT INTO boj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamo qudei na niŋgi gisaŋgoqnsib merŋgoqnqab, ‘Niŋgi uniy. Tamo Aŋgro bqo agide,’ o ‘Tamo Aŋgro bqo agiende.’ Degsib merŋgoqnibqa niŋgi naŋgi daurnjraib. ");
INSERT INTO boj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kola minjaleqnaqa laŋ kalil suwaŋeqnu dego kere mondoŋ e Tamo Aŋgro brantitqa tamo uŋgasari kalil naŋgi e nubqab. ");
INSERT INTO boj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ariya e brantosaisoqnitqa tamo uŋgasari bini bati endeqa unub qaji naŋgi na e qoreibosib jaqatiŋ koba ebqab. ");
INSERT INTO boj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noa aqa bati qa tamo uŋgasari naŋgi kumbra yoqneb dego kere e Tamo Aŋgro bqajqa bati qa naŋgi kumbra degyoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Agi Noa aqa bati qa tamo uŋgasari kalil naŋgi iŋgi ti ya ti uyoqnsib uŋa baŋ ojeleŋoqnsib sonabqa Noa a qobuŋ miligiq gilnaqa awa koba aisiqa mandam ya maqonaqa naŋgi kalil moreŋekriteb. ");
INSERT INTO boj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Lot aqa bati qa dego tamo uŋgasari naŋgi iŋgi ti ya ti uyoqnsib iŋgi iŋgi awaiyoqnsib silali oqnsib iŋgi yagoqnsib tal atoqneb. Naŋgi kumbra degyoqnsib sonabqa Lot a Sodom qure uratosiq ulaŋeqnaqa ŋamyuwo ti meniŋ puloŋ ti laŋ goge na awa bul aisiqa Sodom tamo uŋgasari kalil naŋgi padaltnjrej. ");
INSERT INTO boj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dego kere bunuqna tamo uŋgasari naŋgi kumbra degyoqnsib soqnibqa e Tamo Aŋgro brantqai. ");
INSERT INTO boj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Bati deqa tamo uŋgasari tal meq di unub qaji naŋgi jaraiqa oqnsib iŋgi iŋgi oqa osibqa olo warum miligiq gilaib. Naŋgi jaraiyoqujatebe. Tamo uŋgasari wauq di unub qaji naŋgi jaraiqa oqnsib iŋgi iŋgi oqa osibqa olo puluosib qureq baib. Naŋgi torei dena jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbra nami Lot aqa ŋauŋ aqaq di brantej qaji niŋgi deqa are qaliy. ");
INSERT INTO boj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tamo bei a aqa segi ŋambile taqatqajqa areqalo kobaiyqas di a padalqas. Ariya tamo bei a aqa segi ŋambile uratqas di a olo ŋambile bole oqas. ");
INSERT INTO boj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“E niŋgi endegsi merŋgwai. Ijo bqajqa bati brantimqa qolo deqa tamo aiyel warum qujaiq di ŋereŋesoqnibqa Qotei na bei laŋ qureq osi oqsimqa bei uratim sqas. ");
INSERT INTO boj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uŋa aiyel tal qujaiq di saplaŋ gereiyoqnibqa Qotei na bei laŋ qureq osi oqsimqa bei uratim sqas. ");
INSERT INTO boj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tamo aiyel wau qujaiq di iŋgi yagoqnibqa Qotei na bei laŋ qureq osi oqsimqa bei uratim sqas.” Yesus na aqa aŋgro naŋgi anjam degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Onaqa naŋgi na kamba nenemyeb, “O Tamo Koba, kumbra kalil di sawa qabia brantqas?” Onaqa Yesus a naŋgi yawo anjam endegsi minjrej, “Tamo naŋgo jejamu qusaeqnu qaji sawa dia qal naŋgi koroqab.” ");
INSERT INTO boj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yesus aqa aŋgro naŋgi bati gaigai Qotei pailyoqnib asginjraim deqa a na yawo anjam bei endegsi minjrej, “Qure beiq di anjam pegiyo tamo soqnej. Tamo di aqa kumbra bolesai. A Qotei ulaiyosaioqnej. A tamo uŋgasari naŋgi qa dego are qalosaioqnej. ");
INSERT INTO boj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Qure dia uŋa qobul soqnej. A bati gaigai anjam pegiyo tamo di aqa areq giloqnsiqa minjoqnej, ‘Tamo bei na e gulbe ebeqnu. Deqa ni na aqaryaibosim gago aiyel anjam pegiyetgimqa tamo dena e olo gulbe ebqasai.’ ");
INSERT INTO boj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","A degsi minjeqnaqa a aqaryaiyqa uratoqnej. Bunuqna a areqalo bei osiqa marej, ‘Bole, e Qotei ulaiyosaieqnum. E tamo uŋgasari naŋgi qa are qalosaieqnum. ");
INSERT INTO boj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ariya uŋa qobul di a bati gaigai e waiŋboqnsiqa merbeqnu, “Ni aqaryaibe.” A merbo gaigai yeqnu deqa uŋgum e aqa anjam gereiyetqai. E aqa anjam gereiyetqasai di a bati gaigai ijo areq boqnsim sqas. Yim e tulaŋ asgibo uge.’” ");
INSERT INTO boj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Osiqa Tamo Koba a olo marej, “Anjam pegiyo tamo uge aqa anjam marej qaji di niŋgi quiy. ");
INSERT INTO boj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Qusib are qaliy. Qotei a tamo bole. A anjam pegiyo tamo di bul sai. Deqa tamo uŋgasari a na giltnjrej qaji naŋgi qolo ti qanam ti pailyoqnqab di a naŋgo pailyo qusimqa tariŋsokobaiyqasai. A naŋgi urur aqaryainjrqas. ");
INSERT INTO boj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","E niŋgi merŋgwai. Qotei na naŋgi urur aqaryainjroqujatqas. Ariya mondoŋ e Tamo Aŋgro bosiyqa tamo uŋgasari mandamq endi unub qaji naŋgi e qa naŋgo areqalo siŋgilatosib soqnib degsi unqai e?” ");
INSERT INTO boj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tamo qudei naŋgi mareqnub, “Iga tamo bole. Iga tamo qudei naŋgi unub dego sai.” Yesus na tamo deqaji naŋgi yawo anjam bei endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamo aiyel naŋgi Qotei pailyqa marsibqa atra tal miligiq gileb. Bei Farisi tamo. Bei takis o qaji tamo. ");
INSERT INTO boj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Naŋgi atra tal miligiq gilsibqa Farisi tamo a namo tigelosiqa endegsi pailyej, ‘O Qotei, e tamo qudei naŋgi unub dego sai. E gisaŋ na tamo uŋgasari naŋgi silali yainjrosaieqnum. E sambala kumbra yosaieqnum. E kumbra uge bei dego yosaieqnum. E takis o qaji tamo di bul sai. ");
INSERT INTO boj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","E gaigai ni pailmqa oqnsim iŋgi ti ya ti urateqnum. E ijo segi iŋgi iŋgi kalil poteleŋoqnsim oto bei ni atraimeqnum.’ ");
INSERT INTO boj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Farisi tamo a degsiqa Qotei pailyej. Onaqa takis o qaji tamo a kiñala isaq di tigelesosiqa laŋ goge koqyosim pailyqajqa jemaiyonaqa turuosiqa are soqoŋyosiqa marej, ‘O Qotei, e une ti. Deqa ni e qa dulosim ijo une kalil kobotetbime.’ Takis o qaji tamo a degsiqa Qotei pailyej.” ");
INSERT INTO boj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesus a yawo anjam degsi minjrsiqa olo minjrej, “E niŋgi merŋgwai. Takis o qaji tamo di aqa une kalil Qotei na kobotetonaqa a olo puluosiqa aqa talq aiyej. Ariya Farisi tamo di aqa une Qotei na kobotetosai. Di kiyaqa? Tamo kalil naŋgo segi ñam soqteqnub qaji naŋgi Qotei na olo ñam aguq atetnjrqas. Ariya tamo naŋgo segi ñam aguq ateqnub qaji naŋgi Qotei na olo ñam soqtetnjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Onaqa tamo uŋgasari qudei naŋgi naŋgo aŋgro du du ti aŋgro mom ti joqsib Yesus na aqa baŋ naŋgo gateq di atetnjrqa marsib aqa areq beb. Beqnabqa Yesus aqa aŋgro naŋgi na saidnjrsib minjreb, “Nuŋgo aŋgro du du naŋgi joqsib endeq baib.” ");
INSERT INTO boj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Degsib saidnjrnabqa Yesus na aŋgro du du naŋgi di metnjrej. Osiqa aqa aŋgro naŋgi minjrej, “Aŋgro du du naŋgi uratnjrib ijo areq beb. Naŋgi saidnjraib. Tamo uŋgasari naŋgi aŋgro du du bul sqab di Qotei a naŋgo Mandor Koba sosim naŋgi taqatnjrqas. ");
INSERT INTO boj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","E bole merŋgwai. Niŋgi aŋgro du du naŋgi bul sqasai di Qotei a niŋgi osim taqatŋgwasai. Deqa a nuŋgo Mandor Koba sqasai dego.” ");
INSERT INTO boj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Onaqa Juda gate bei na Yesus endegsi nenemyej, “O Qalie Tamo Bole, e kiyersiyqa ŋambile gaigai sqai?” ");
INSERT INTO boj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Onaqa Yesus na kamba minjej, “Ni kiyaqa e tamo bole qa merbonum? Qotei a segi qujai tamo bole. ");
INSERT INTO boj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ariya ni Qotei aqa dal anjam kalil qalie unum. ‘Ni tamo bei aqa uŋa jejamu ojetaim. Ni tamo bei qalsim moiyotaim. Ni bajiŋaim. Ni tamo bei aqa jejamu laŋa gisaŋyaim. Ni ino ai abu naŋgo sorgomq di geregere sosimqa naŋgo anjam dauryoqne.’” ");
INSERT INTO boj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Onaqa Juda gate dena olo Yesus minjej, “E aŋgro kiñala qa dal anjam kalil di dauryosim boqnem agi bini degsi unum.” ");
INSERT INTO boj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Degsi minjnaq qusiqa kamba minjej, “Ni dal anjam kalil di dauryosim keretonum. Ariya kumbra qujai ni keretosai. Deqa e ni mermqai. Ni gilsim ino iŋgi iŋgi kalil qariŋyosim silali osim tamo iŋgi iŋgi saiqoji naŋgi jeisim enjre. Degsim enjrsim bosim e daurbe. Osim bunuqna ni laŋ qureq di awai bole itqam.” ");
INSERT INTO boj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesus na tamo di degsi minjnaq qusiqa are gulbekobaiyej. Di kiyaqa? A iŋgi iŋgi koba ti soqnej deqa. ");
INSERT INTO boj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Onaqa Yesus a tamo di koqyosiqa marej, “Tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba. ");
INSERT INTO boj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel a yumba miligiq gilqajqa baŋgi koba. Dego kere tamo uŋgasari iŋgi iŋgi koba ti unub qaji naŋgi Qotei na taqatnjrsim naŋgo Mandor Koba sqa marsibqa laŋ qureq oqwajqa tulaŋ baŋgi koba.” ");
INSERT INTO boj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Onaqa tamo qudei Yesus aqa anjam di queb qaji naŋgi na minjeb, “Ni anjam degsi maronum deqa tamo yai naŋgi Qotei na eleŋamqa naŋgi ŋambile gaigai sqa kere?” ");
INSERT INTO boj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Onaqa Yesus na kamba minjrej, “Tamo naŋgi segi ŋambile sqa keresai. Ariya Qotei na naŋgi eleŋqa kere. Di kiyaqa? Qotei a kumbra kalil yqa kere.” ");
INSERT INTO boj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yesus a naŋgi degsi minjrnaqa Pita na minjej, “O Tamo Koba, ni une. Iga gago iŋgi iŋgi kalil uratosim ni daurmeqnum.” ");
INSERT INTO boj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Onaqa Yesus na minjrej, “E bole merŋgwai. Tamo bei a Qotei na taqatosim aqa Mandor Koba sqa marsimqa aqa segi qure, aqa ŋauŋ, aqa was naŋgi, aqa ai abu naŋgi, aqa aŋgro naŋgi ti kalil uratnjrsim e daurbqas tamo di Qotei na iŋgi iŋgi gargekoba olo yeleŋqas. Yimqa mondoŋ a ŋambile gaigai sqas.” ");
INSERT INTO boj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus na aqa aŋgro 12 naŋgi anjam degsi minjrsiq koboonaqa naŋgi joqsiqa segitnjrsiqa endegsi minjrej, “Niŋgi quiy. E Tamo Aŋgro. Iga Jerusalem aiyeqnum. Dia anjam kalil Qotei aqa medabu o tamo naŋgi nami e qa neŋgreŋyeb qaji di aqa damu brantqas. ");
INSERT INTO boj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Agi tamo qudei na e ojqab. E ojsib tamo naŋgi Qotei qaliesai qaji naŋgo baŋq di e atqab. Yimqa naŋgi na e misiliŋboqnsib miselboqnsib ugeugeiboqnqab. ");
INSERT INTO boj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Osib e kumbaiŋbosib lubsib moiyotbqab. Bati qalub koboamqa e olo subq na tigelqai.” ");
INSERT INTO boj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesus na aqa aŋgro naŋgi anjam degsi minjrnaq qusibqa anjam di aqa utru Qotei na ulitej deqa naŋgi geregere poinjrosai. ");
INSERT INTO boj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Onaqa Yesus a walwelosi aisiq Jeriko qure jojomyeqnaqa tamo bei ŋam qandimyej qaji a gam qalaq di awesosiqa tamo uŋgasari naŋgi silali qa ŋilnjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tamo uŋgasari tulaŋ gargekoba naŋgi Yesus dauryosib qatroŋoqnsib aiyeqnab tamo dena qusiqa nenemnjrej, “Niŋgi kiyaqa qatroŋeqnub?” ");
INSERT INTO boj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Onaqa naŋgi na minjeb, “Yesus Nasaret qaji a aiyeqnu.” ");
INSERT INTO boj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Degsi minjnabqa a tulaŋ leleŋosiqa marej, “O Yesus, Devit aqa Ŋiri, ni e qa dulame.” ");
INSERT INTO boj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Onaqa tamo uŋgasari namoeb qaji naŋgi na tamo di ŋiriŋtosib minjeb, “Ni leleŋkobaaim. Kiri.” Degsi minjnabqa a naŋgo anjam quetnjrosai. A olo tulaŋ leleŋoqnsiq Yesus minjoqnej, “O Devit aqa Ŋiri, ni e qa dulame.” ");
INSERT INTO boj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Onaqa Yesus a tigelosiqa tamo uŋgasari naŋgi minjrej, “Tamo di osib ijo areq osi boiy.” Onaqa naŋgi na a osib Yesus aqa areq osi beb. Osi bonabqa nenemyej, ");
INSERT INTO boj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“E ni kiyermqajqa deqa ni e qa leleŋoqnam?” Onaqa minjej, “O Tamo Koba, e olo ŋam poibim sawa unqajqa deqa e ni qa leleŋoqnam.” ");
INSERT INTO boj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Onaqa Yesus na minjej, “Ni e qa ino areqalo siŋgilatonum deqa e ni boletmqai. Deqa ino ŋamdamu olo poimeme.” ");
INSERT INTO boj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Degsi minjnaqa aqa ŋamdamu poiyonaqa sawa unsiqa Qotei aqa ñam soqtosiqa tigelosiq Yesus dauryosiq aiyej. Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsibqa naŋgi dego Qotei aqa ñam soqtoqneb. ");
INSERT INTO boj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Onaqa Yesus a aisiqa Jeriko qureq di brantosiq qure ambleq na walweleqnaqa tamo bei aqa ñam Sakius a Yesus tamo kiyero degosiq unqajqa dauryej. Sakius a takis o qaji tamo naŋgo gate. A ñoro koba ti soqnej. A tamo truquyala deqa a Yesus dauryosiq unqajqa yonaq ugeiyej. Di kiyaqa? Tamo gargekoba naŋgi na sawa getenteb deqa. ");
INSERT INTO boj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Deqa Sakius a urur ti aisiq tamo uŋgasari kalil naŋgi buŋnjrsiqa namoosiq gam qalaq di ŋam bei oqsiq ŋam atej. Ŋam atsiqa are qalej, “Yesus a gam endena bamqa e geregere unqai.” ");
INSERT INTO boj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Onaqa Yesus a gam dena walwelosi aisiq ŋam utruq di tigelosiq tarosiq Sakius unsiqa minjej, “O Sakius, ni mandamq aiyoqujat. Bini e ino talq di sqai.” ");
INSERT INTO boj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Degsi minjnaqa a qusiqa mandamq aiyoqujatosiqa tulaŋ areboleboleiyonaqa Yesus osiqa ombla na aqa talq gileb. ");
INSERT INTO boj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gileqnabqa tamo uŋgasari kalil naŋgi di unsib ŋiriŋosib mareb, “Niŋgi uniy. Yesus a une tamo aqa talq gileqnu.” ");
INSERT INTO boj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Onaqa talq di Sakius a tigelosiqa Yesus minjej, “O Tamo Koba, ni que. E ijo iŋgi iŋgi kalil ambleq na potosiy tamo iŋgi iŋgi saiqoji naŋgi jeisi enjrqai. E nami tamo bei gisaŋyosim silali dala qujai yaiyem kiyo? Degamqa e kamba silali dala qolqe olo yqai.” ");
INSERT INTO boj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Onaqa Yesus a Sakius aqa anjam di qusiqa tamo uŋgasari naŋgi minjrej, “Bini Sakius a dego Abraham aqa aŋgro tiŋtiŋqo. Deqa Qotei na a ti tamo kalil aqa talq endi unub qaji naŋgi ti eleŋqo. ");
INSERT INTO boj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","E segi Tamo Aŋgro. E na tamo uŋgasari padalo gamq di unub qaji naŋgi ŋamoqnsim eleŋeqnum. E deqa mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Onaqa tamo uŋgasari naŋgi Yesus aqa anjam di qusib are qaleb, “Bini kiyo Qotei a gago Mandor Koba sosim iga taqatgwajqa bati brantqas?” ");
INSERT INTO boj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naŋgi degsib are qaleb. Di kiyaqa? Yesus a Jerusalem jojomyej deqa. Onaqa Yesus a yawo anjam bei endegsi minjrej, “Tamo kobaquja bei a sawa isaq gilej. Tamo di a are qalej, ‘E sawa deq gilitqa sawa deqaji naŋgi na e mandor atqab. Yibqa e olo puluosiy bosiy ijo segi qure qujai naŋgo mandor sosiy naŋgi taqatnjrqai.’ A degsi are qalsiqa sawa isaq gilej. ");
INSERT INTO boj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A gilqa osiqa aqa kaŋgal tamo 10 naŋgi metnjrnaqa aqa areq bonabqa naŋgi segi segi 20 kina enjrsiqa minjrej, ‘Silali endena wauosib silali aqa oto dego oiy. Bunuqna e olo bosiy unqai.’ ");
INSERT INTO boj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tamo kobaquja a degsi minjrsiqa sawa isaq gilsiq di sonaqa aqa qure qujai naŋgi a qa tulaŋ ugeosib are qaleb, ‘A gago mandor sqasai.’ Degsib are qalsibqa tamo qudei naŋgi qariŋnjrnab sawa deq gilsib sawa deqaji naŋgi minjreb, ‘Tamo di a gago mandor ataib. A na iga taqatgwajqa iga uratonum.’ ");
INSERT INTO boj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ariya sawa deqaji naŋgi na tamo di mandor ateb. Onaqa bunuqna a olo puluosiq aqa segi qureq aisiqa kaŋgal tamo naŋgi wau qa silali enjrej qaji naŋgi metnjrej. Metnjrnaqa naŋgi aqa areq bonabqa a na minjrej, ‘E nami silali eŋgem qaji dena niŋgi wauoqneb olo silali di osorbiy.’ ");
INSERT INTO boj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Onaqa kaŋgal tamo deqaji bei a bosiqa minjej, ‘O Tamo Koba, ino 20 kina ebem qaji dena e waueqnamqa olo 200 kina brantej agiende.’ ");
INSERT INTO boj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Onaqa aqa tamo koba a na minjej, ‘Ni kaŋgal tamo bolequja. Ni wau kiñala geregere taqatonum deqa e qure kokba 10 ino baŋq di uratitqa ni na taqatnjroqnqam.’ ");
INSERT INTO boj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Onaqa kaŋgal tamo bei a bosiqa aqa tamo koba minjej, ‘O Tamo Koba, ino 20 kina ebem qaji dena e waueqnamqa olo 100 kina brantej agiende.’ ");
INSERT INTO boj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Onaqa aqa tamo koba a na minjej, ‘E qure kokba 5 ino baŋq di uratitqa ni na taqatnjroqnqam.’ ");
INSERT INTO boj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Onaqa kaŋgal tamo bei a bosiqa aqa tamo koba minjej, ‘O Tamo Koba, ni unime. Ino 20 kina ebem qaji agi olo osibetmonum. E gara ñeŋgi na dalaosim atnam soqnej. ");
INSERT INTO boj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","E kumbra degyem. Di kiyaqa? E ni qa ulaem deqa. E qalieem, ni tamo ŋiriŋ ani. Tamo qudei naŋgi waueqnab silali branteqnaqa ni segi na eqnum. Tamo qudei naŋgi iŋgi yageqnab melieqnaqa ni segi na otorosim uyeqnum.’ ");
INSERT INTO boj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Onaqa tamo koba dena kamba endegsi minjej, ‘Ni kaŋgal tamo uge. Ino segi anjam dena e ino une ubtosiy ni pegimqai. Ni nami qalieem, e tamo ŋiriŋ ani. Tamo qudei naŋgi waueqnab silali branteqnaqa e segi na eqnum. Tamo qudei naŋgi iŋgi yageqnab melieqnaqa e segi na otorosim uyeqnum. Ni nami e qa degsim qalieem. ");
INSERT INTO boj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Deqa ni kiyaqa ijo silali di osi gilsim silali talq di atosai? Ni di atem qamu e bosimqa silali talq dena ijo silali aqa oto kobaqo qamu turtosim onum qamu.’ ");
INSERT INTO boj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Degsi minjsiqa tamo qudei aqa areq di tigelesoqneb qaji naŋgi minjrej, ‘Niŋgi aqa 20 kina di yaiyosibqa kaŋgal tamo nami wauosiqa 200 kina ej qaji di olo yiy.’ ");
INSERT INTO boj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Onaqa naŋgi na minjeb, ‘O Tamo Koba, a 200 kina ejunu. Deqa ni kiyaqa 20 kina olo yqa maronum?’ ");
INSERT INTO boj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Onaqa tamo koba a na minjrej, ‘E niŋgi merŋgwai. Tamo a wau geregere taqatoqnqas di Qotei na olo wau koba yimqa a na taqatoqnqas. Ariya tamo a wau geregere taqatqasai di wau kiñala a na taqatejunu qaji di a olo bunu taqatqasai. Qotei na a kobotimqa a laŋa sqas.’ ");
INSERT INTO boj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Osiqa minjrej, ‘Tamo naŋgi e qa jeu ateb qaji naŋgi di joqsib boiy. Naŋgi e qa mareb, “Tamo di a gago mandor ataib.” Deqa tamo naŋgi di joqsib bosib ijo ulatamuq endi naŋgi ñumib moreŋqab.’” ");
INSERT INTO boj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus a yawo anjam degsi marsiqa a Jerusalem aiqajqa gam dauryosiq aiyoqnej. ");
INSERT INTO boj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Yesus a aisiqa Betfage qure ti Betani qure ti Oliv mana utruq di jojomyosiqa aqa aŋgro aiyel qariŋnjrsiqa minjrej, “Niŋgi aisib qure bei jojom di unu di brantosib donki bei tontonub unu di unqab. Donki di bunuj tamo bei nami aqa quraq di awoosaioqnej qaji. Niŋgi donki di unsibqa sil palontosib titosib osib boiy. ");
INSERT INTO boj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Niŋgi sil palontoqnibqa tamo bei na nenemŋgwas kiyo, ‘Niŋgi kiyaqa donki aqa sil palonteqnub?’ Degsi nenemŋgimqa niŋgi na minjiy, ‘Tamo Koba a wau ti. Deqa a donki qa mergwo.’” ");
INSERT INTO boj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesus a naŋgi aiyel degsi minjrsiq qariŋnjrnaqa aisib anjam Yesus na minjrej qaji di dauryosib donki di uneb. ");
INSERT INTO boj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Unsib sil palonteqnabqa donki aqa abu naŋgi na naŋgi aiyel nenemnjreb, “Niŋgi kiyaqa donki aqa sil palonteqnub?” ");
INSERT INTO boj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Degsi nenemnjrnabqa naŋgi aiyel na kamba minjreb, “Tamo Koba a wau ti. Deqa a donki qa mergwo.” ");
INSERT INTO boj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Degsi minjrnab odnjrnab naŋgi aiyel donki di osib Yesus aqa areq osi gileb. Osi gilsib naŋgo segi gara jugo piqtosib donki aqa quraq di tusib Yesus soqtosib donki aqa quraq di awoteb. ");
INSERT INTO boj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesus a donki aqa quraq di awoonaqa donki a walwelosi aiyeqnaqa tamo uŋgasari naŋgi naŋgo gara jugo piqteleŋosib gamq di tueleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Onaqa Yesus a Oliv mana utru jojomyeqnaqa aqa aŋgro gargekoba naŋgi tulaŋ areboleboleinjreqnaqa leleŋoqneb. Yesus a nami maŋwa gargekoba yeqnaqa naŋgi unoqneb deqa naŋgi Qotei aqa ñam soqtoqnsib endegsib maroqneb, ");
INSERT INTO boj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ni Tamo Koba aqa ñam na bonum deqa a ni tulaŋ geregereimeqnu. Ni gago Mandor Koba. Iga Qotei Goge Koba aqa ñam tulaŋ soqtoqnqom! Laŋ qureq di lawo kumbra gaigai sqas.” ");
INSERT INTO boj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Onaqa tamo uŋgasari naŋgo ambleq dena Farisi qudei naŋgi tigelosib Yesus minjeb, “O Qalie Tamo, ni ino aŋgro naŋgo medabu getentetnjrime.” ");
INSERT INTO boj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Onaqa Yesus na minjrej, “Ijo aŋgro naŋgo medabu getentqab di meniŋ naŋgi tamo bulyosib tulaŋ murqumyoqnsib Qotei aqa ñam soqtoqnqab.” ");
INSERT INTO boj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Osiqa Yesus a Jerusalem jojomyosiq unsiqa akamej. ");
INSERT INTO boj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akamosiq marej, “O Jerusalem tamo uŋgasari, bini bati endeqa niŋgi Qotei aqa kumbra qalieeb qamu niŋgi geregere lawo na unub qamu. Ariya kumbra di niŋgi qa uliejunu deqa niŋgi qalieqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Deqa niŋgi quiy. Bati bei brantimqa tamo qudei na bosib niŋgi jeutŋgosib nuŋgo qure koba endi agutibqa niŋgi jaraiqa keresaiiŋgwas. Amqa naŋgi na niŋgi qoto itŋgosib tulaŋ ugeugeiŋgosib nuŋgo qure koba endi niñaqyekritqab. Osib qure aqa meniŋ kalil paraparainjrsib breinjribqa meniŋ bei meniŋ bei aqa quraq di sqasai. Meniŋ kalil segisegiqab. Jeu tamo naŋgi bosib niŋgi degŋgwab. Di kiyaqa? Qotei na niŋgi aqaryaiŋgwajqa bati brantqo di niŋgi poiŋgosai deqa.” ");
INSERT INTO boj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Osiqa Yesus a atra tal koba miligiq gilsiqa ŋam atej di tamo uŋgasari gargekoba naŋgi iŋgi iŋgi qariŋyoqnsibqa dena silali eqnab unjrsiqa naŋgi winjrnaq jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naŋgi jaraiyeqnabqa Yesus na minjrej, “Qotei aqa anjam bei nami endegsib neŋgreŋyeb unu, ‘Ijo tal endi pailyqajqa tal.’ Qotei aqa anjam degsi unu. Ariya niŋgi na olo tal endi ugetonubqa a bajiŋ tamo naŋgo tal bulqo.” ");
INSERT INTO boj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus a bati gaigai atra tal miligiq giloqnsiq dia tamo uŋgasari naŋgi Qotei aqa anjam palontosiq minjroqnej. Bati deqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti Juda gate naŋgi ti Yesus qalib moiqajqa gam ŋamoqneb. ");
INSERT INTO boj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ariya tamo uŋgasari kalil naŋgi Yesus aqa anjam quqwajqa tulaŋ arearetnjroqnej. Deqa Juda gate naŋgi Yesus qalib moiqajqa gam ŋamonab ugeinjrej. ");
INSERT INTO boj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Bati bei Yesus a atra tal koba miligiq gilsiq dia tamo uŋgasari naŋgi Qotei aqa anjam bole palontosiq minjroqnej. Onaqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti Juda gate naŋgi ti bosib nenemyeb, “Ni iga merge. Ni siŋgila qabe na osimqa kumbra endi yeqnum? Yai na ni qariŋmej deqa ni wau endi yeqnum?” ");
INSERT INTO boj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Onaqa Yesus na minjrej, “E kamba anjam bei niŋgi nenemŋgitqa niŋgi e merbiy. ");
INSERT INTO boj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yai na Jon qariŋyonaqa bosiqa tamo uŋgasari naŋgi yansnjroqnej? Qotei na kiyo? Tamo bei na kiyo? Niŋgi na merbiy.” ");
INSERT INTO boj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Onaqa naŋgi Yesus aqa anjam di qusibqa segi segi qairosib maroqneb, “Iga Yesus minjqom, ‘Qotei na Jon qariŋyej’ degsi minjqom di a iga mergwas, ‘Kiyaqa niŋgi Jon aqa anjam quetosai?’ ");
INSERT INTO boj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ariya iga minjqom, ‘Tamo bei na Jon qariŋyej’ degsi minjqom di tamo uŋgasari naŋgi ŋiriŋosib bosib iga meniŋ na lugwab. Di kiyaqa? Naŋgi mareqnub, ‘Jon a Qotei aqa medabu o qaji tamo bole.’” ");
INSERT INTO boj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Naŋgi degsib qairosib olo Yesus minjeb, “Yai na kiyo Jon qariŋyej di iga qaliesai.” ");
INSERT INTO boj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Onaqa Yesus na kamba minjrej, “Niŋgi degsib merbonub deqa e dego yai na qariŋbonaq bosim wau endi yeqnum di niŋgi merŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Osiqa Yesus a olo tamo uŋgasari naŋgi yawo anjam bei endegsi minjrej, “Tamo bei a tigelosiqa aqa wauq gilej. Gilsiqa wain sil yageleŋosiqa wau taqato tamo qudei naŋgo baŋq di aqa wau uratetnjrsiqa sawa isaq gilsiq dia sokobaiyej. ");
INSERT INTO boj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sonaqa wain gei melionaqa a na aqa kaŋgal tamo bei qariŋyonaqa wau taqato tamo naŋgoq aisiq minjrej, ‘Wau lanja na e qariŋbqo bonum. Deqa niŋgi wain gei ebibqa e na osi gilqai.’ Degsi minjrnaqa naŋgi na a ojsib qalougetosib wiyonab laŋa puluosiq gilej. ");
INSERT INTO boj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Gilnaqa wau lanja na olo kaŋgal tamo bei qariŋyonaq ainaqa a dego qalougetosib ugeugeiyosib wiyonabqa a laŋa puluosiq gilej. ");
INSERT INTO boj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Onaqa wau lanja na olo kaŋgal tamo bei qariŋyonaq ainaqa a dego qalougetosib ugeugeiyosib wiyonab gilej. ");
INSERT INTO boj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Onaqa wau lanja a are qalej, ‘E kiyerqai? E endegyqai. E ijo segi aŋgro qujai e na tulaŋ qalaqalaiyeqnum qaji di qariŋyit aiqas naŋgi aqa anjam quetqab.’ ");
INSERT INTO boj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Degsi are qalsiqa aqa segi ŋiri qariŋyonaq aiyej. Aiyeqnaqa wau taqato tamo naŋgi a unsibqa segi segi qairosib mareb, ‘Tamo a bqo endi wau lanja aqa segi ŋiri. A na aqa abu aqa iŋgi iŋgi kalil oqas. Deqa iga a qalsim moiyotosimqa wau endi iga na oqom.’ ");
INSERT INTO boj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Degsib marsibqa wau lanja aqa ŋiri ojsib wau qalaq osi gilsib dia qalnab moiyej. “Deqa niŋgi kiyersib are qalonub? Wau lanja a bosimqa wau taqato tamo uge naŋgi di kiyernjrqas? ");
INSERT INTO boj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E niŋgi merŋgwai. A bosim naŋgi ñumsim moiyotnjrqas. Osim aqa wau di olo yainjrsim tamo qudei naŋgo baŋq di uratetnjrimqa naŋgi na kamba taqatesqab.” Yesus na tamo uŋgasari naŋgi yawo anjam degsi minjrnaqa naŋgi qusib minjeb, “Wau taqato tamo naŋgi kumbra uge di yaib.” ");
INSERT INTO boj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Onaqa Yesus na naŋgi koqnjrsiqa minjrej, “Qotei aqa anjam bei neŋgreŋq di unu. Aqa damu niŋgi poiŋgwo e? Anjam agiende, ‘Tal gereiyo qaji tamo naŋgi na tal ai arqsibqa uge qa marsib taqal waiyeb. Onaqa tal ai di Qotei na olo osiq tumaq di tigeltej unu. Tal ai di tal siŋgilatqajqa deqa tigeltej.’ ");
INSERT INTO boj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Niŋgi quiy. Tamo uŋgasari ululoŋosib tal ai quraq aiqab qaji naŋgi di tal ai dena naŋgo tanu giŋgeŋyqas. Ariya tal ai di uloŋosim tamo uŋgasari qudei naŋgoq aisim jejamu ti tanu ti torei paraparainjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Onaqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti yawo anjam di qusib endegsib qalieeb, Yesus a yawo anjam dena naŋgo jejamuq di une qametnjrej. Naŋgi degsib qalieosib deqa minjiŋ oqetnjrnaqa Yesus ojqa mareb. Ariya naŋgi tamo uŋgasari naŋgi ulainjrsib deqa naŋgi Yesus ojqa uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ariya atra tamo kokba ti dal anjam qalie tamo naŋgi ti Yesus koqyesoqneb. Osib endegsib are qaleb, “Iga tamo qudei qariŋnjrnam naŋgi Yesus aqa areq gilsib gisaŋyosib anjam bei nenemyibqa a naŋgi tamo bole edegwas. Osim anjam grotimqa iga qusim ojsim Rom naŋgo gate aqa baŋq di atqom.” Naŋgi degsib are qalsibqa tamo qudei qariŋnjrnab naŋgi Yesus aqa areq gileb. ");
INSERT INTO boj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gilsib minjeb, “O Qalie Tamo, iga qalie, ni anjam bole maro qaji tamo. Ni anjam bole segi tamo uŋgasari naŋgi minjroqnsim Qotei aqa kumbra osornjreqnum. Ni tamo bei ulaiyosaieqnum. Ni tamo ñam ti naŋgi anjam bei minjroqnsim olo tamo ñam saiqoji naŋgi anjam bei minjrosaieqnum. Ni anjam qujai tamo kalil naŋgi minjreqnum. ");
INSERT INTO boj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Deqa ni iga merge. Iga Sisar takis yqom e? Yqasai e? Ni kiyersi are qalonum?” ");
INSERT INTO boj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Onaqa Yesus a naŋgo areqalo uge di poiyonaqa minjrej, ");
INSERT INTO boj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Niŋgi meniŋ silali bei osorbiy.” Degsi minjrnaqa naŋgi meniŋ silali bei osi bosib osoryonab unsiqa minjrej, “Meniŋ silali quraq endi tamo yai aqa ulatamu ti ñam ti unu?” Onaqa naŋgi na minjeb, “Di Sisar aqa.” ");
INSERT INTO boj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Onaqa a na minjrej, “Deqa Sisar aqa iŋgi iŋgi a qa olo yiy. Qotei aqa iŋgi iŋgi a qa olo yiy.” ");
INSERT INTO boj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Onaqa naŋgi Yesus aqa anjam di qusibqa tulaŋ prugugetosib mequmosib soqneb. Tamo uŋgasari naŋgo ŋamdamuq di naŋgi Yesus gisaŋyib a anjam bei grotqa yonab ugeinjrej. ");
INSERT INTO boj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Onaqa Sadyusi tamo qudei naŋgi Yesus aqa areq beb. Sadyusi naŋgi mareqnub, “Tamo moreŋo qaji naŋgi olo subq na tigelqasai.” ");
INSERT INTO boj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Deqa naŋgi bosib Yesus endegsib minjeb, “O Qalie Tamo, ni que. Moses a nami dal anjam endegsi neŋgreŋyej, ‘Tamo bei a moiyimqa aqa ŋauŋ aŋgro saiqoji soqnimqa aqa was bei na olo uŋa qobul di osim aqa was moiyej qaji aqa aŋgro ŋambabtetqas.’ Moses a nami dal anjam degsi neŋgreŋyej. ");
INSERT INTO boj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Deqa ni que. Was 7 naŋgi soqneb. Naŋgo was matu a uŋa osiqa moiyej. A aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Onaqa aqa was yala na olo uŋa qujai di osiqa a dego moiyej. A aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Onaqa aqa was yala na olo uŋa qobul di osiqa a dego moiyej. A aŋgro saiqoji. Was 7 kalil naŋgi uŋa qujai di osib moreŋeb. Naŋgi aŋgro saiqoji. ");
INSERT INTO boj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Naŋgi kalil moreŋonabqa ariya bunuqna uŋa di a dego moiyej. ");
INSERT INTO boj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Deqa ni iga merge. Mondoŋ subq na tigelo batiamqa tamo kalil naŋgi subq na tigelabqa uŋa di a yai aqa ŋauŋ tiŋtiŋ sqas? Ni qalie, was 7 kalil naŋgi uŋa qujai di eb.” ");
INSERT INTO boj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Onaqa Yesus na minjrej, “Mandamq endi tamo naŋgi uŋateqnub. Uŋa naŋgi tamoteqnub. ");
INSERT INTO boj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ariya mondoŋ tamo uŋgasari Qotei na subq na tigelqa giltnjrej qaji naŋgi subq na tigelosibqa naŋgi tamotqasai. Naŋgi uŋatqasai. ");
INSERT INTO boj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Naŋgi laŋ aŋgro bul laŋa sqab. Qotei na naŋgi subq na tigeltnjrimqa naŋgi aqa segi aŋgro bole sqab. Deqa naŋgi olo moreŋqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Niŋgi quiy. Tamo naŋgi moisib olo subq na tigelqab anjam di aqa utru Moses a nami babtosiq endegsi neŋgreŋyej, ‘Ŋam mariŋ miligiq di puloŋeqnaqa Qotei a ŋam puloŋq di sosiqa Moses metosiq minjej, “E Abraham aqa Qotei. E Aisak aqa Qotei. E Jekop aqa Qotei.” ’ ");
INSERT INTO boj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Qotei na Moses degsi minjej deqa iga qalieonum, Qotei a tamo moreŋo qaji naŋgo Qotei sai. A tamo ŋambile so qaji naŋgo Qotei. Deqa tamo kalil naŋgi Qotei aqa ŋamgalaq di ŋambile unub.” ");
INSERT INTO boj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Onaqa dal anjam qalie tamo naŋgi Yesus aqa anjam di qusibqa naŋgi olo anjam bei nenemyqajqa ulaeb. Deqa naŋgi na minjeb, “O Qalie Tamo, ino anjam di bole.” ");
INSERT INTO boj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Onaqa Yesus a olo naŋgi endegsi minjrej, “Dal anjam qalie tamo naŋgi kiyaqa mareqnub, ‘Kristus a Devit aqa ŋiri’? ");
INSERT INTO boj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit a nami marej, ‘Kristus a ijo Tamo Koba.’ Agi louqa buk miligiq di Devit a anjam endegsi neŋgreŋyej, ‘Tamo Koba a na ijo Tamo Koba minjej, “Ni ijo baŋ woq endi awo. Awesoqnimqa e ino jeu tamo kalil naŋgi eleŋosiy ino sorgomq di atitqa ni na naŋgi taqatnjroqnqam.” ’ ");
INSERT INTO boj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Niŋgi uniy. Devit a marej, ‘Kristus a ijo Tamo Koba.’ Deqa Kristus a kiyersim Devit aqa ŋiri sqas?” ");
INSERT INTO boj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tamo uŋgasari kalil naŋgi Yesus aqa anjam di queqnabqa a na aqa aŋgro naŋgi endegsi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Niŋgi dal anjam qalie tamo naŋgo kumbra uge geregere tenemtoqniy. Naŋgi koro sawaq di tamo uŋgasari naŋgi na naŋgo ñam soqtetnjrsib baŋ ojetnjrqajqa deqa gara jugo olekokba jugoqnsib laqnub. Naŋgi Qotei tal miligiq di, goiyo kokbaq di sosibqa tamo ñam ti naŋgo awo jaramq di awoqajqa tulaŋ areboleboleinjreqnu. ");
INSERT INTO boj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naŋgi uŋa qobul naŋgi gisaŋnjroqnsibqa naŋgo tal ti iŋgi iŋgi ti laŋa yainjreqnub. Osib tamo uŋgasari naŋgi na unjrsib naŋgo ñam soqtetnjrqajqa deqa pailyo olekokba yeqnub. Deqa mondoŋ Qotei na naŋgi awai tulaŋ ugedamu enjrqas.” ");
INSERT INTO boj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus a atra tal miligiq di sosiqa ŋam atej di ñoro tamo naŋgi boqnsib silali ato qaji kulumq di silali ateqnab unjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Onaqa uŋa qobul bei ñoro tulaŋ saiqoji a dego bosiqa meniŋ silali kiñilala aiyel segi atej. Atnaqa Yesus na unsiqa aqa aŋgro naŋgi minjrej, ");
INSERT INTO boj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“E bole merŋgwai. Uŋa qobul endi a ñoro tulaŋ saiqoji. Deqa a na ñoro tamo kalil naŋgi buŋnjrsiqa silali kobaquja atqo. ");
INSERT INTO boj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ñoro tamo naŋgi silali koba ti unub. Naŋgi oto kiñala segi ateqnub. Ariya uŋa qobul endi a silali tulaŋ sai bole sai. Aqa meniŋ silali kiñilala aiyel segi naj agi atekritqo.” ");
INSERT INTO boj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Onaqa Yesus aqa aŋgro qudei naŋgi atra tal di koqyosibqa Yesus minjeb, “O Tamo Koba, ni unime. Atra tal walato qaji meniŋ di tulaŋ boledamu. Qotei atraiyqajqa iŋgi iŋgi ti meniŋ ti turtosib atra tal endi walateb.” Onaqa Yesus na kamba minjrej, ");
INSERT INTO boj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Atra tal niŋgi unonub endi bunuqna jeu tamo naŋgi na bosib tulaŋ niñaqyosib aqa meniŋ kalil paraparainjrsibqa taqal breinjrqab. Yimqa meniŋ bei meniŋ bei aqa quraq di sqasai. Meniŋ kalil segisegiqab.” ");
INSERT INTO boj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Onaqa Yesus aqa aŋgro naŋgi na kamba nenemyeb, “O Qalie Tamo, bati gembu jeu tamo naŋgi bosib atra tal endi niñaqyqab? Niñaqyqa osibqa kumbra kiye namoqna brantim iga unsim poigwas, ‘Bati di jojomqo’?” ");
INSERT INTO boj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Onaqa Yesus na minjrej, “Niŋgi geregere ŋam atoqniy. Tamo qudei na niŋgi gisaŋgo uge. Bunuqna gisaŋ tamo gargekoba naŋgi ijo ñam na boqnsib maroqnqab, ‘E Kristus.’ Qudei maroqnqab, ‘Kristus bqajqa bati agi jojomqo.’ Degsib gisaŋosib maroqnibqa niŋgi naŋgi daurnjraib. ");
INSERT INTO boj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bunuqna sawa bei bei qaji naŋgi aŋ na qotokobaoqnqab. Niŋgi deqa qusib ulaaib. Qotei a nami marej, ‘Kumbra di brantqas.’ Deqa brantem. Ariya kumbra di brantimqa diŋo bati urur brantqasai. Soboleiyosim brantqas.” ");
INSERT INTO boj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesus a naŋgi degsi minjrsiqa olo minjrej, “Bati deqa sawa bei ti sawa bei ti qotoqnqab. Mandor kokba qudei naŋgi dego tigeloqnsibqa mandor kokba qudei naŋgi qoto itnjroqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sawa bei beiq di mimiŋ kokba ti ma uge ti mam ti iŋgi saio bati branteleŋqas. Laŋ goge di maŋwa bei bei brantoqnibqa tamo uŋgasari naŋgi unoqnsib ulaugetoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ariya kumbra kalil di brantosaisoqnimqa Juda naŋgi na bosib niŋgi jeutŋgoqnsib ugeugeiŋgoqnsib ojeleŋoqnqab. Ojeleŋoqnsib anjam pegiyo talq di niŋgi tigeltŋgoqnsib tonto talq di breiŋgoqnqab. Osib ijo ñam ugetqa are qaloqnsib niŋgi joqoqnsib Rom naŋgo mandor ti naŋgo gate ti naŋgo ulatamuq di niŋgi tigeltŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yimqa gam dena niŋgi ijo anjam bole palontoqnsib naŋgi minjroqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Deqa niŋgi na kamba anjam kiye minjrqajqa deqa nami are koba qalaib. ");
INSERT INTO boj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","E segi na nuŋgo medabu siŋgilatetŋgosiy powo eŋgitqa niŋgi kamba anjam minjroqnqab. Minjroqnibqa naŋgi nuŋgo anjam di gotraŋyqa yoqnib ugeinjroqnqas. ");
INSERT INTO boj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Bati deqa nuŋgo ai abu naŋgi ti nuŋgo was naŋgi ti nuŋgo leŋ naŋgi ti nuŋgo kadoi naŋgi ti tigeloqnsib niŋgi ojeleŋoqnsib jeu tamo naŋgo baŋq di ateleŋoqnqab. Osib niŋgi qudei luŋgoqnib moreŋoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Niŋgi ijo ñam ejunub deqa tamo uŋgasari kalil naŋgi niŋgi qa tulaŋ ugeoqnsib jeutŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ariya Qotei na niŋgi geregere taqatŋgoqnqas deqa ijo aŋgro bei padalqasai. Niŋgi kalil bole sqab. Nuŋgo gate baŋga bei dego ugeqasai. ");
INSERT INTO boj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Deqa niŋgi gulbe di qoboiyoqnsib siŋgila na tigelesoqniy. Sosib dena niŋgi ŋambile bole oqab. ");
INSERT INTO boj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bunuqna qaja tamo naŋgi bosib Jerusalem agutesqab. Agutesoqnib niŋgi unsibqa endegsib qalieqab, ‘Bole, Jerusalem padalqajqa bati brantqo.’ ");
INSERT INTO boj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bati deqa tamo uŋgasari Judia sawaq di unub qaji naŋgi jaraiyosib manaq oqoqujatebe. Tamo uŋgasari Jerusalem di unub qaji naŋgi qure uratosib jaraiyoqujatebe. Tamo uŋgasari wauq di, gamq di unub qaji naŋgi olo puluosib qureq baib. Naŋgi torei dena jaraiyoqujatebe. ");
INSERT INTO boj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bati deqa Qotei na tamo uŋgasari naŋgo une qa kambatnjrougetqas. Yimqa aqa anjam kalil nami neŋgreŋyeb qaji di aqa damu brantqas. ");
INSERT INTO boj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","O aiyo! Bati deqa Qotei aqa minjiŋ Juda naŋgoq aiyimqa gulbe tulaŋ kobaquja naŋgo mandamq di brantqas. Deqa uŋa gumaŋ ti uŋa aŋgro mom ti naŋgi jaraiyo baŋgioqnsib gulbe gargekoba oqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jeu tamo naŋgi bosib Juda naŋgi serie na ñumoqnib moreŋoqnqab. Osib qudei ojeleŋosib joqsib sawa bei beiq di uratnjroqnqab. Tamo Juda sai naŋgi bosib Jerusalem tulaŋ niñaqyosib siŋgila na taqatesqab. Taqatesoqnib bati Qotei a nami giltej qaji di kereamqa a na naŋgi olo taqal breinjrqas. ");
INSERT INTO boj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bati deqa seŋ ambruqas. Bai dego suwaŋqasai. Bongar naŋgi ululoŋosib mandamq aiyeleŋqab. Yuwal dego korkortosim anjam atoqnqas. Yimqa sawa bei bei qaji naŋgi quoqnib areqalo niñaqyetnjroqnimqa naŋgi tulaŋ ulaugetoqnqab. ");
INSERT INTO boj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Laŋ goge di iŋgi iŋgi kalil reŋgiŋyeleŋamqa tamo uŋgasari naŋgi unsib maroqnqab, ‘Bole, gulbe oqa batiqo.’ Naŋgi degsib maroqnsib ulaugetoqnsib ŋam eririqnjroqnqas. ");
INSERT INTO boj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bati deqa e Tamo Aŋgro siŋgila ti riaŋ koba ti laŋbiq na mandamq aiyoqnit tamo uŋgasari naŋgi tarosib e nubqab. ");
INSERT INTO boj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kumbra kalil di brantqa utru atoqnimqa niŋgi ulaaib. Niŋgi tigelosib tarosib ŋam atoqniy. Di kiyaqa? Qotei na niŋgi awaiŋgim niŋgi bole sqajqa bati jojomqo deqa.” ");
INSERT INTO boj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Osiqa Yesus a yawo anjam endegsi minjrej, “Niŋgi qura ti ŋam kalil ti unjriy. ");
INSERT INTO boj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ŋam baŋga qalsim olo ñalguyoqnimqa niŋgi unsib qalieqab, ‘Seŋ aqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dego kere kumbra kalil e ubtosim merŋgonum qaji endi brantimqa niŋgi unsib endegsib qalieoiy, ‘Bole, Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqajqa bati jojomqo.’ ");
INSERT INTO boj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“E bole merŋgwai. Tamo uŋgasari bini bati endeqa unub qaji naŋgi kalil moreŋosaisoqnibqa kumbra kalil e ubtosim merŋgonum qaji endi branteleŋqas. ");
INSERT INTO boj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Laŋ ti mandam ti koboqab. Ariya ijo anjam koboqa keresai.” ");
INSERT INTO boj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Osiqa Yesus a olo marej, “Niŋgi geregere ŋam atsib soqniy. Niŋgi ya uge uyoqnsib nanarioqnaib. Nuŋgo segi jejamu qa iŋgi iŋgi qa areqalo kobaiyoqnaib. Aliem urur bel qaleqnu dego kere bati uge di bosim niŋgi pruqtŋgo uge. ");
INSERT INTO boj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Od, bati uge di bosim tamo uŋgasari sawa sawa kalilq di unub qaji naŋgoq di brantoqujatqas. ");
INSERT INTO boj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Deqa niŋgi gaigai ŋam atoqnsib Qotei pailyoqnsib soqniy. Yimqa Qotei a siŋgila eŋgoqnimqa kumbra kalil branteleŋqas qaji di niŋgi na britosib e Tamo Aŋgro ijo ulatamuq di tigelesqab.” Yesus a degsi marej. ");
INSERT INTO boj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bati gaigai qanam Yesus a atra tal miligiq di sosiqa tamo uŋgasari naŋgi Qotei aqa anjam palontoqnsiq minjroqnej. Qoloeqnaqa a olo qure uratoqnsiqa mana ñam Oliv di ŋeioqnej. ");
INSERT INTO boj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tamo uŋgasari kalil naŋgi Yesus aqa anjam quqwa maroqnsib nobqolo ambru tigeloqnsibqa atra tal miligiq giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Onaqa Juda naŋgo yori bati koba jojomej. Yori bati di aqa ñam Bem Tiyosai Qaji Uyqajqa Bati. Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa aqaryainjrej. Deqa olo are qalqajqa yori bati jojomej. ");
INSERT INTO boj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yori bati jojomonaqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti Yesus qalsib moiyotqajqa gam ŋamoqneb. Di kiyaqa? Naŋgi tamo uŋgasari naŋgi ulainjreb deqa. ");
INSERT INTO boj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Onaqa Satan a Judas aqa miligiq aiyej. Judas aqa ñam bei Iskariot. A dego Yesus aqa aŋgro 12 naŋgi deqaji bei. ");
INSERT INTO boj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan a Judas aqa miligiq aisiq walawalaiyonaqa tigelosiqa atra tamo kokba ti atra tal taqato tamo naŋgi ti naŋgoq gilsiqa minjrej, “E Yesus osiy nuŋgo baŋq di atqai.” ");
INSERT INTO boj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Degsi minjrnaqa naŋgi areboleboleinjrnaqa minjeb, “Ni Yesus osim gago baŋq di atimqa iga ni silali emqom.” ");
INSERT INTO boj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Degsi minjnabqa a naŋgo anjam di qusiqa minjrej, “Di kere.” Osiqa Judas a gilsiq a na Yesus osim naŋgo baŋq di atqajqa gam ŋamoqnej. A are qalej, “Yesus a tamo uŋgasari naŋgi uratnjrsim a segi soqnimqa e na osiy Juda tamo kokba naŋgo baŋq di atqai.” ");
INSERT INTO boj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Onaqa Bem Tiyosai Qaji Uyqajqa Bati brantej. Qotei a nami Israel naŋgi endegsi minjrej, “Niŋgi kaja du du naŋgi ñumeleŋosib siraŋmeq di leŋ liyibqa e na unsiy niŋgi uratŋgwai. E niŋgi padaltŋgwasai.” Qotei a nami Israel naŋgi degsi minjrej. Kumbra deqa olo are qalqajqa yori bati brantonaqa Juda naŋgi mareb, “Iga kaja du du naŋgi ñumeleŋosim Qotei atraiyqom.” ");
INSERT INTO boj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Onaqa bati deqa Yesus na Pita Jon wo naŋgi minjrej, “Bini yori bati koba. Deqa niŋgi aiyel aisib gago iŋgi iŋgi gereiyetgibqa iga koba na iŋgi uyqom.” ");
INSERT INTO boj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Onaqa naŋgi aiyel na minjeb, “Ni iga merge. Iga aisim tal qabia iŋgi iŋgi gereiyqom?” ");
INSERT INTO boj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Onaqa Yesus na naŋgi aiyel qariŋnjrsiqa minjrej, “Niŋgi aiyel aisib qure ambleq di tamo bei ya nobu qoboiyosim giloqnim gamq di itosib dauryiy. Niŋgi a dauryosib tal a gogetqas qaji di miligiq gilsib tal lanja endegsib minjiy, ‘Qalie Tamo a marqo, “E ijo aŋgro naŋgi koba na awoosim yori bati aqa iŋgi uyqajqa warum a qabi unu?” ’ ");
INSERT INTO boj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niŋgi degsib minjibqa a na warum kobaquja bei gogeqsi unu di niŋgi osorŋgwas. Warum dia nami jar ti awo jaram ti ateleŋeb unu. Niŋgi aiyel aisib warum dia gago iŋgi iŋgi gereiyeleŋoiy.” ");
INSERT INTO boj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Onaqa naŋgi aiyel aisib anjam kalil Yesus na minjrej qaji degsi brantonab unsibqa iŋgi iŋgi kalil gereiyeleŋeb. ");
INSERT INTO boj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Onaqa iŋgi uyqa bati brantonaqa Yesus aqa anjam maro tamo naŋgi ti koba na awoosib iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naŋgi iŋgi uyoqnsibqa Yesus na naŋgi endegsi minjrej, “E jaqatiŋ osaiunum. Deqa e niŋgi koba na awoosim yori bati aqa iŋgi uyqajqa tulaŋ areboleboleibqo. ");
INSERT INTO boj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","E niŋgi merŋgwai. E iŋgi endi olo uyqasai. Degsi gilsiy mondoŋ Qotei na niŋgi taqatŋgosim a nuŋgo Mandor Koba soqnimqa iŋgi endi aqa utru e na geregere babtosiy olo uyqai.” ");
INSERT INTO boj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Osiqa a wain osiq gambaŋq di bilentosiqa Qotei pailyosiqa aqa aŋgro naŋgi endegsi minjrej, “Niŋgi wain gambaŋ endi osib uyiy. ");
INSERT INTO boj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","E niŋgi merŋgwai. E wain endi olo uyqasai. Degsi gilsiy mondoŋ Qotei na niŋgi taqatŋgosim a nuŋgo Mandor Koba soqnimqa e olo uyqai.” ");
INSERT INTO boj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Osiqa Yesus a olo Qotei pailyosiqa bem osiq giŋgeŋyosiqa naŋgi enjrsiqa minjrej, “Endi ijo jejamu. E niŋgi aqaryaiŋgwa osim deqa eŋgonum. Deqa niŋgi osib uyiy. Bunuqna niŋgi gaigai uyoqnsib e qa are qaloqniy.” ");
INSERT INTO boj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Onaqa naŋgi bem uynabqa Yesus na olo wain gambaŋ osiq Qotei pailyosiqa minjrej, “Wain gambaŋ endi ijo leŋ. Nuŋgo une kobotqajqa deqa ijo leŋ aisim Qotei aqa anjam bunuj nami gereiyej qaji di siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ariya niŋgi quiy. Ijo aŋgro bei na e osim tamo qudei naŋgo baŋq di atqas. Aŋgro di agi iga koba na endego awoosim iŋgi uyeqnum. ");
INSERT INTO boj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","E Tamo Aŋgro. Deqa Qotei na nami merbej, ‘Ni moiqam.’ A degsi merbej deqa e aqa anjam di dauryosiy moiqai. Ariya aŋgro e osim tamo qudei naŋgo baŋq di atqas qaji a tulaŋ padalougetqas.” ");
INSERT INTO boj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesus na aqa aŋgro naŋgi degsi minjrnaq qusibqa segi segi maroqneb, “Aŋgro yai a kumbra di yqas?” ");
INSERT INTO boj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Onaqa Yesus aqa aŋgro naŋgi segi segi ŋiriŋosib yai a aŋgro kalil buŋnjrsim ñam ti sqas deqa anjam na qotoqneb. ");
INSERT INTO boj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Onaqa Yesus na minjrej, “Mandor kokba sawa sawa kalil taqateqnub qaji naŋgi ŋiriŋ na sawa taqateqnub. Yeqnab tamo uŋgasari naŋgi na naŋgo ñam soqtoqnsib mareqnub, ‘Naŋgi sawa taqato tamo bole.’ ");
INSERT INTO boj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ariya kumbra di nuŋgoq di saiq. Nuŋgo ambleq di aŋgro bei a tamo kobaquja sqa marsimqa a mati tamo laŋaj bul soqnem. Osim a tamo kobaquja sqas. Nuŋgo ambleq di aŋgro bei a ñam ti sqa marsimqa a mati nuŋgo wau tamo soqnem. Osimqa a ñam ti sqas. ");
INSERT INTO boj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Niŋgi are qaliy. Tamo yai a tamo kobaquja? Tamo awoosiq iŋgi uyeqnu a kiyo? Tamo wauosiq iŋgi suweiyeqnu a kiyo? Tamo agi awoosiq iŋgi uyeqnu qaji a tamo kobaquja. Ariya ijo kumbra degsi sosai. E nuŋgo ambleq endi sosim niŋgi wauetŋgeqnum. ");
INSERT INTO boj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“O ijo aŋgro, e gulbe qoboiyeqnam niŋgi e uratbosaieqnub. Niŋgi e beterbeqnub. ");
INSERT INTO boj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ijo Abu na e Mandor Koba atej dego kere e kamba niŋgi mandor ateleŋqai. ");
INSERT INTO boj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Osiy mondoŋ e nuŋgo Mandor Koba sosiy niŋgi koba na iŋgi ti ya ti uyoqnqom. Yimqa niŋgi awo jaram kokbaq di awoosib Jekop aqa aŋgro 12 naŋgo moma kalil naŋgi taqatnjroqnqab.” ");
INSERT INTO boj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Osiqa Yesus a olo marej, “O ijo aŋgro kalil Saimon ombla niŋgi quiy. Satan na niŋgi uneq waiŋgwa marqo. Niŋgi siŋgila na tigelesosib e daurbqab kiyo e uratbosib jaraiqab kiyo di Satan a nuŋgo areqalo tenemtosim qalieqajqa deqa niŋgi uneq waiŋgwa marqo. Agi tamo naŋgi bem sum ñoqoryoqnsib damu eleŋeqnub dego kere. ");
INSERT INTO boj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","O Pita, e ni qa gaigai endegsim pailyeqnum, ‘O Abu, ni na Pita aqa areqalo siŋgilatetimqa a e uratbqasai.’ E ni qa degsim pailyeqnum. Bole, ni mati uloŋqam. Ariya bunuqna ni olo are bulyosim ijoq bqam. Bosim ino was naŋgi siŋgilatnjroqnqam.” ");
INSERT INTO boj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Onaqa Pita na Yesus minjej, “O Tamo Koba, ni na marimqa aqo ombla tonto talq aisim moreŋqom. E ulaqasai.” ");
INSERT INTO boj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Onaqa Yesus na minjej, “O Pita, ni que. Bini tuwe anjamosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai.’” ");
INSERT INTO boj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Osiqa Yesus na aqa aŋgro naŋgi endegsi minjrej, “E niŋgi nami qariŋgosim merŋgem, ‘Niŋgi gilsib ijo anjam mare mare laqniy. Niŋgi silali ti gilaib. Nuŋgo qaquŋ aib. Siŋga taqal jigaib.’ Degsi merŋgonamqa niŋgi iŋgi bei qa truqueb e?” Onaqa naŋgi na minjeb, “Sai. Iga iŋgi bei qa truquosai.” ");
INSERT INTO boj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Onaqa a na minjrej, “Ariya bini e anjam di beltosiy olo endegsi merŋgwai. Nuŋgo silali bei soqnim oiy. Nuŋgo qaquŋ bei soqnim di dego oiy. Niŋgi sebru saiamqa nuŋgo gara jugo bei qariŋyosib silali osib dena sebru awaiyiy. ");
INSERT INTO boj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","E niŋgi merŋgwai. Anjam e qa nami neŋgreŋyeb qaji di aqa damu brantqas. Anjam agiende, ‘Tamo uŋgasari naŋgi marqab, “Kristus a une tamo.” ’” ");
INSERT INTO boj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Onaqa Yesus aqa aŋgro naŋgi na minjeb, “O Tamo Koba, ni unime. Iga sebru aiyel ejunum.” Onaqa Yesus na minjrej, “Di kere.” ");
INSERT INTO boj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus aqa kumbra gaigai yoqnej qaji di dauryosiqa Jerusalem uratosiq Oliv manaq oqej. Aqa aŋgro naŋgi dego a dauryosib oqeb. ");
INSERT INTO boj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oqsib nañu agu beiq di brantosib Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi endegsib pailyiy, ‘O Abu, gulbe bei na iga uneq waigaiq.’” ");
INSERT INTO boj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yesus a degsi minjrsiqa naŋgi uratnjrsiq kiñala sasalej. Tamo bei na meniŋ waiyim isaq yala gilqas dego kere a sasalosiqa siŋga pulutosiq Qotei pailyej. ");
INSERT INTO boj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","A endegsi pailyej, “O Abu, ni marimqa gulbe endi ijoq baiq. Gulbe endi ya uge uyo bul. Uŋgum, ni ijo areqalo dauryaim. Ni ino segi areqalo dauryosim ye.” ");
INSERT INTO boj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Yesus a degsi siŋgila na Qotei pailyoqnsiqa a are tulaŋ gulbekobaiyej. Onaqa a ŋeskobaiyosiqa aqa ŋes leŋ ti mandamq aiyoqnej. Bati deqa laŋ aŋgro bei aisiqa Yesus taqyosiqa siŋgilatej. ");
INSERT INTO boj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","46","Yesus a pailyo koboonaqa a olo tigelosiqa aqa aŋgro naŋgo areq aisiq ŋam atej di naŋgi are gulbe na ŋereŋesonab unjrej. Unjrnaqa minjrej, “Niŋgi kiyaqa ŋereŋejunub? Niŋgi tigelosib Qotei pailyoqniy. Yim gulbe bei nuŋgoq bqas di gulbe dena niŋgi uneq waiŋgwasai.” ");
INSERT INTO boj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus a anjam degsi mareqnaqa aqa aŋgro 12 naŋgi deqaji bei agi Judas a na tamo gargekoba naŋgi joqsiqa Yesus aqa areq di branteb. Brantonabqa Judas a Yesus aqa areq bosiq kundoqyej. ");
INSERT INTO boj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kundoqyonaqa minjej, “O Judas, e Tamo Aŋgro. Tamo naŋgi endi e ojqajqa deqa ni na e kundoqbonum e?” ");
INSERT INTO boj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Onaqa tamo naŋgi di Yesus ojqa laqnabqa aqa aŋgro naŋgi unsibqa Yesus minjeb, “O Tamo Koba, ni marimqa iga gago sebru osim tamo naŋgi di ñumnam moreŋqab.” ");
INSERT INTO boj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Degsi minjsibqa aqa aŋgro bei na aqa sebru osiqa atra tamo gate aqa kaŋgal tamo bei gateq di qalqajqa sebru waiyej grotosiqa dabkala wo segi gentetej. ");
INSERT INTO boj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Onaqa Yesus na aqa aŋgro naŋgi minjrej, “Kumbra degyaib. Uratiy.” Degsi minjrsiqa tamo di aqa dabkala ojnaqa olo boleej. ");
INSERT INTO boj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Onaqa Yesus na atra tamo kokba ti atra tal taqato tamo naŋgi ti Juda gate naŋgi ti minjrej, “E leŋ ojo tamo unum deqa kiyo niŋgi sebru ti torom ti eleŋosib e ojqa bonub e? ");
INSERT INTO boj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","E bati gaigai atra tal miligiq di niŋgi koba na soqnem. Bati deqa niŋgi yala baŋ waiyosib e ojosai. Ariya bati uge nuŋgoq di brantqo deqa niŋgi e ojonub. Endego ambru aqa siŋgila agi brantqo.” ");
INSERT INTO boj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","55","Onaqa naŋgi Yesus ojsib walwelosib atra tamo gate aqa talq osi gileb. Naŋgi Yesus osi gileqnabqa Pita a kiñala isa isaq na naŋgi daurnjrsiq gilej. Gilsiqa atra tamo gate aqa tal meq di brantej. Brantosiqa qaja tamo qudei naŋgi tal meq di ŋam tuŋguyosib awesonabqa bosiq naŋgi koba na ŋam yoroqnej. ");
INSERT INTO boj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita a ŋamyuwo areq di awesonaqa kaŋgal uŋa bei na unsiqa koqyosiq qaja tamo naŋgi minjrej, “Tamo endi Yesus ombla soqneb.” ");
INSERT INTO boj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Onaqa Pita a saidosiq minjej, “Uŋa, e tamo di qaliesai.” ");
INSERT INTO boj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sokiñalayonaq tamo bei na olo Pita unsiqa minjej, “Ni dego Yesus aqa aŋgro bei.” Onaqa Pita na minjej, “E aqa aŋgro sai.” ");
INSERT INTO boj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Olo kiñala soboleiyonaq tamo bei na Pita koqyosiqa siŋgila na marej, “Tamo endi a dego Galili qaji tamo. Deqa e qalieonum, a Yesus ombla soqneb.” ");
INSERT INTO boj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Onaqa Pita na minjej, “Ni anjam maronum di e poibosai bole sai.” Degsi minjnaqa tuwe anjamej. ");
INSERT INTO boj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Tuwe anjamonaqa Tamo Koba a bulosiqa Pita koqyej. Koqyonaqa anjam nami Yesus na minjej qaji, “Bini tuwe anjamosaisoqnimqa ni gisaŋoqalubtosim marqam, ‘E Yesus qaliesai,’” anjam deqa olo are qalsiqa poiyonaqa tal qalaq gilsiqa tulaŋ akamugetej. ");
INSERT INTO boj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tamo Yesus ojeb qaji naŋgi a misiliŋyoqnsibqa baŋ na qaloqneb. ");
INSERT INTO boj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Qaloqnsibqa aqa ŋamdamu gara na qosetosib minjoqneb, “Ni Kristus amqa ni ubtosim mare, yai na ni lumqo?” ");
INSERT INTO boj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Degsib minjoqnsib olo misiliŋ anjam gargekoba minjoqneb. ");
INSERT INTO boj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Onaqa nobqolo malu qameqnaq Juda gate naŋgi ti atra tamo kokba ti dal anjam qalie tamo naŋgi ti koroosib Yesus osib tigeltosib nenemyeb, ");
INSERT INTO boj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ni Kristus amqa geregere merge.” Onaqa a na minjrej, “E kamba anjam merŋgwai di niŋgi ijo anjam quetbqasai. ");
INSERT INTO boj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","E anjam bei nenemŋgwai di niŋgi olo anjam merbqasai. ");
INSERT INTO boj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Deqa e niŋgi endegsi merŋgwai. E Tamo Aŋgro. Bini bati endeqa ti bunuq qa ti e Qotei siŋgila koba ti unu qaji aqa baŋ woq di awesqai.” ");
INSERT INTO boj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yesus a naŋgi degsi minjrnaqa naŋgi na minjeb, “Deqa ni Qotei aqa Ŋiri e?” Onaqa a na minjrej, “Od. Anjam niŋgi maronub di kere.” ");
INSERT INTO boj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Onaqa naŋgi Yesus aqa anjam di qusib tulaŋ minjiŋ oqetnjrnaqa segi segi maroqneb, “Aqa une agi a segi babtqo iga quonum. Deqa iga kiyaqa tamo bei olo metonam bosim aqa une marqas?” ");
INSERT INTO boj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Juda tamo kokba naŋgi degsib marsibqa Yesus osi gilsib Rom naŋgo gate Pailat aqa ulatamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tigeltosib Pailat minjeb, “Iga Yesus uneqnum, a na Juda tamo uŋgasari naŋgi kumbra ugeq breinjreqnu. Osiqa naŋgi mandor koba Sisar takis yqajqa saidnjroqnsiqa minjreqnu, ‘E segi nuŋgo Mandor Koba. E segi Kristus.’” Juda tamo kokba naŋgi degsib Yesus aqa jejamuq di une qameteb. ");
INSERT INTO boj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Onaqa Pailat a naŋgo anjam di qusiqa Yesus nenemyej, “Ni Juda naŋgo Mandor Koba e?” Onaqa Yesus na minjej, “Od. Anjam ni maronum di kere.” ");
INSERT INTO boj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Onaqa Pailat na atra tamo kokba ti tamo uŋgasari kalil naŋgi ti minjrej, “E segi are qalonum, Yesus aqa jejamuq di une bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Degsi minjrnaqa naŋgi na kamba minjeb, “Yesus a tamo uŋgasari naŋgi kumbra uge dauryqajqa are tigeltetnjreqnu. Agi a Galili sawaq di aqa wau utru atsiqa dena Judia sawaq aisiq qure qure kalilq di walweloqnsiqa dena bosiq gago qure endia dego kumbra degyeqnu.” ");
INSERT INTO boj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Onaqa Pailat a naŋgo anjam di qusiqa nenemnjrej, “Yesus a Galili qaji tamo e?” ");
INSERT INTO boj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Degsi nenemnjrnaqa naŋgi na minjeb, “Od, a Galili qaji tamo.” Onaqa Pailat a naŋgo anjam di qusiqa minjrej, “Mandor Herot a Galili sawa taqatejunu. Bini a Jerusalem endi unu. Deqa e Yesus qariŋyitqa a Herot aqaq gilimqa a kamba Yesus aqa anjam quqwas.” Degsi minjrsiqa Yesus qariŋyonaqa Herot aqaq gilej. ");
INSERT INTO boj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot a nami Yesus qa anjam quoqnej deqa a Yesus itqajqa arearetoqnej. Yesus a bosim Herot aqa ulatamuq di maŋwa bei yim unqajqa deqa are qaloqnej. Deqa a Yesus aqa ulatamu unsiqa tulaŋ areboleboleiyej. ");
INSERT INTO boj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Onaqa a na Yesus anjam gargekoba nenemyoqnej. Nenemyeqnaqa Yesus a kamba anjam bei marosai. A torei mequmesoqnej. ");
INSERT INTO boj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Deqa atra tamo kokba ti dal anjam qalie tamo naŋgi ti bosib Herot aqa ulatamuq di tigelosib Yesus aqa jejamuq di une gargekoba qameleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Onaqa Herot aqa qaja tamo qudei naŋgi ti Yesus tulaŋ ugeugeiyosib misiliŋyoqneb. Osib gara jugo olekoba mandor kokba naŋgi gaigai jigeqnub deqaji bei osib jigetosib qariŋyonab olo Pailat aqaq aiyej. ");
INSERT INTO boj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bati qujai deqa Herot Pailat wo naŋgi jeu turyeb. Nami naŋgi ombla jeu soqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Onaqa Pailat na atra tamo kokba ti Juda gate naŋgi ti tamo uŋgasari kalil naŋgi ti metnjrnaqa aqa areq bosib koroonabqa endegsi minjrej, “Niŋgi Yesus osib ijo areq di tigeltosib merbonub, ‘Tamo endi a tamo uŋgasari naŋgi kumbra ugeq breinjreqnu.’ Merbonubqa e segi Yesus geregere nenemyonum niŋgi quonub. Une kalil niŋgi aqa jejamuq di qameqnub qaji di e quonum ugeibqo. E aqa jejamuq di une bei itosai. ");
INSERT INTO boj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot a dego Yesus aqa jejamuq di une bei itosai. Deqa a na Yesus olo qariŋyqoqa ijoq bqo. Deqa niŋgi quiy. Niŋgi Yesus aqa une bei babtosai. Deqa e a laŋa moiyotqa keresai. ");
INSERT INTO boj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Deqa e ijo qaja tamo naŋgi minjrit naŋgi bu toqoŋ na kumbaiŋyosib a uratib gilqas.” ");
INSERT INTO boj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Onaqa tamo uŋgasari kalil naŋgi Pailat aqa anjam di qusibqa naŋgi tulaŋ murqumyosib minjeb, “Ni Yesus urataim. Ni a moiyotime. Osim Barabas oqeq atsim iga ege.” ");
INSERT INTO boj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas a nami tamo qudei naŋgi joqsiqa Rom naŋgi ti qotsib tamo qudei ñumeb deqa qaja tamo naŋgi Barabas osib tonto talq di waiyeb. ");
INSERT INTO boj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ariya Pailat a Yesus uratim oqedqajqa are soqnej deqa a na tamo uŋgasari naŋgi olo minjrej, “Niŋgi marib e Yesus uratit gilqas.” ");
INSERT INTO boj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Onaqa naŋgi olo tulaŋ murqumyoqnsib waiŋyoqnsib minjoqneb, “Ni Yesus urataim. Ni a ŋamburbasq di qame! Ni a ŋamburbasq di qame!” ");
INSERT INTO boj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Onaqa olo minjrej, “Kiyaqa Yesus qalit moiqas? A une kiye yej deqa a ŋamburbasq di qamqai? Niŋgi Yesus aqa une bei babtosai. Deqa e a laŋa moiyotqa keresai. Deqa e ijo qaja tamo naŋgi minjrit naŋgi bu toqoŋ na kumbaiŋyosib a uratib gilqas.” ");
INSERT INTO boj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Onaqa tamo uŋgasari naŋgi olo tulaŋ murqumyoqnsib siŋgila na Pailat saidyoqnsibqa waiŋyoqnsib minjoqneb, “Ni Yesus ŋamburbasq di qame!” Degsib siŋgila na Pailat minjeqnab naŋgo anjam dena Pailat aqa anjam qalotoqnej. Deqa a naŋgo anjam di dauryosiqa minjrej, “Di kere. Uŋgum. E na ijo qaja tamo naŋgi minjrit Yesus osi gilsib ŋamburbasq di qamib moiqas.” ");
INSERT INTO boj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Degsi minjrsiqa Barabas tonto talq dena oqeq atsiqa naŋgi enjrej. Osiqa tamo uŋgasari naŋgo areqalo dauryosiqa Yesus osiqa qaja tamo naŋgo baŋq di atnaqa naŋgi na aqa qawarq di aqa segi ŋamburbas atetosib a osib gileb. ");
INSERT INTO boj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naŋgi Yesus osi giloqnsibqa gamq di tamo bei walwelosiq Jerusalem aiyeqnaqa a turosib ojsib Yesus aqa qawarq dena ŋamburbas yaiyosib tamo di yonabqa a kamba qoboiyosiqa gam na Yesus dauryosiq giloqnej. Tamo di aqa ñam Saimon. A Sairini qure qaji. ");
INSERT INTO boj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tamo uŋgasari tulaŋ gargekoba naŋgi Yesus gam na dauryosib giloqneb. Giloqnsibqa naŋgo ambleq di uŋa qudei naŋgi are tulaŋ gulbeinjrnaqa Yesus qa akamoqnsib lou ti giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Gileqnabqa Yesus a qusiqa bulosiqa naŋgi minjrej, “O Jerusalem uŋgasari, niŋgi e qa akamaib. Niŋgi nuŋgo aŋgro naŋgi qa ti niŋgi segi qa ti akamoiy. ");
INSERT INTO boj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Niŋgi quiy. Bati bei brantimqa tamo naŋgi endegsib marqab, ‘Uŋa naŋgo miligi ugeej qaji naŋgi ti uŋa aŋgrotosaieqnub qaji naŋgi ti areboleboleinjrqas. Uŋa aŋgro muŋgum anainjrosaieqnub qaji naŋgi dego areboleboleinjrqas.’ Tamo naŋgi degsib marqab. ");
INSERT INTO boj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Osib mana naŋgi minjrqab, ‘Niŋgi bosib iga kabutgosib ulitgiy.’ ");
INSERT INTO boj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","O uŋgasari, e ŋam gesgi bul. Tamo naŋgi na e kumbra uge ebeqnub. Tamo naŋgi di ŋam moiyo bul. Deqa kumbra tulaŋ ugedamu naŋgoq di brantqas.” ");
INSERT INTO boj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bajiŋ tamo aiyel dego ŋamburbasq di ñumib moreŋqajqa marsib Yesus koba na joqsib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Naŋgi giloqnsib sawa agu kiñala bei aqa ñam Tamo Gate Tanu di brantosib dia Yesus ŋamburbasq di qameb. Qamsib bajiŋ tamo aiyel naŋgi dego ŋamburbasq di ñumeb. Bei Yesus aqa baŋ woq di qameb. Bei Yesus aqa baŋ qonaŋq di qameb. ");
INSERT INTO boj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus a ŋamburbas goge di sosiqa a endegsi pailyej, “O Abu, ni na tamo naŋgi e gaintbonub qaji naŋgo une di kobotime. Naŋgi une yonub di naŋgi qaliesai.” Bati deqa qaja tamo naŋgi Yesus aqa gara eleŋqa marsib gilteleŋeb. Osib meniŋ silali alaŋeb. Tamo yai aqa meniŋ na buŋnjrqas di a na gara oqas. Degsib marsib meniŋ silali alaŋosib gara eleŋeb. ");
INSERT INTO boj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Onaqa tamo uŋgasari kalil naŋgi tigelesosib Yesus koqyeqnabqa Juda gate naŋgi na Yesus misiliŋyoqnsib endegsib maroqneb, “A na tamo uŋgasari naŋgi aqaryainjroqnej. Ariya a na aqa segi jejamu aqaryaiyqa keresai. A maroqnej, ‘E Qotei aqa Kristus. A na e giltbej.’ Anjam di boleamqa a na aqa segi jejamu aqaryaiyosim ŋamburbas uratosim mandamq aiyem.” ");
INSERT INTO boj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Qaja tamo naŋgi dego Yesus degsib misiliŋyoqneb. Osib aqa areq gilsib wain isa koba anaiyosib minjeb, “Ni Juda naŋgo Mandor Koba boleamqa ni ino segi jejamu aqaryaiyosim ŋamburbas urat.” ");
INSERT INTO boj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Osib ŋamburbas mutu gogeq di anjam endegsib neŋgreŋyeb, “Tamo endi a Juda naŋgo Mandor Koba.” ");
INSERT INTO boj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Onaqa bajiŋ tamo bei ŋamburbasq di qameb qaji a na Yesus misiliŋyosiqa minjej, “Ni Kristus amqa ni ino segi jejamu aqaryaiyosim aqo aiyel dego aqaryaige.” ");
INSERT INTO boj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Onaqa bajiŋ tamo bei na aqa anjam di qusiqa ŋiriŋtosiq minjej, “Gulbe Yesus a oqo endi ni dego onum. Deqa ni kiyaqa Qotei ulaiyosai? ");
INSERT INTO boj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aqo aiyel une tamo. Deqa iga kere moreŋqom. Ariya Yesus aqa jejamuq di une bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Osiqa Yesus minjej, “O Yesus, mondoŋ ni olo bosim Mandor Koba sosimqa ni e qa are qalsim e ame.” ");
INSERT INTO boj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Onaqa Yesus na minjej, “Bini qujai ni e ombla laŋ qureq di sqom. E bole mermonum.” ");
INSERT INTO boj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Qanam jige seŋ bati 12 onaqa sawa kalil tulaŋ ambruosi sonaq gilsiq seŋ bati 3 onaq bilaqtej. Bati qujai deqa gara kobaquja atra tal miligiq di gaiŋesoqnej qaji a goge na braŋosiq aisiq poaiyelej. ");
INSERT INTO boj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Onaqa Yesus a tulaŋ leleŋosiqa marej, “O Abu, e na ijo qunuŋ osim ino baŋq di atonum.” Degsi marsiqa mondor titosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Onaqa qaja tamo naŋgo gate a Yesus degsi mondor titosiq moiyej di unsiqa Qotei aqa ñam soqtosiqa marej, “Bole, Yesus aqa jejamuq di une bei saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Onaqa tamo uŋgasari kalil Yesus unqa beleŋeb qaji naŋgi dego Yesus degsi moiyej di unsibqa a qa are tulaŋ gulbeinjrnaqa are soqoŋyeb. Osib jaraiyosib naŋgo segi segi talq gileleŋeb. ");
INSERT INTO boj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesus aqa kadoi kalil naŋgi ti uŋgasari qudei nami Yesus dauryosib Galili sawa uratosib Jerusalem beleŋeb qaji naŋgi ti isaq di tigelesosibqa Yesus a ŋamburbasq di gaiŋosiq moinaq koqyoqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tamo bei aqa ñam Josep a soqnej. A Juda naŋgo gate bei. A Arimatea qure qaji. Arimatea a Judia sawaq di unu. Josep a tamo bolequja. Aqa kumbra tulaŋ boledamu. ");
INSERT INTO boj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A endegsi are qaloqnej, “Bunuqna Qotei a bosim gago Mandor Koba sosim iga taqatgwas.” A degsi are qaloqnsiq Qotei qa tariŋoqnsiq soqnej. Juda gate kokba naŋgi Yesus qalib moiqajqa anjam qoseb bati deqa Josep a naŋgi koba na anjam qososai. A naŋgo anjam di uratoqnej. ");
INSERT INTO boj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tamo di a Pailat aqa areq bosiq nenemyej, “Ni e odbimqa e Yesus aqa jejamu osiy subq atqa kere e?” ");
INSERT INTO boj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Onaqa Pailat na odyonaqa gilsiq Yesus aqa jejamu ŋamburbasq dena osiq gara qat na dalaosiq osi gilsiq sub bei nami meniŋ miligiq di gereiyeb qaji dia atej. Sub di bunuj. Sub dia nami tamo bei jugosaioqneb. ");
INSERT INTO boj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Juda naŋgo yori bati brantqa laqnej deqa yori bati aqa iŋgi iŋgi kalil gereiyosib atnab soqnej. ");
INSERT INTO boj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bati di uŋgasari qudei nami Yesus dauryosib Galili sawaq dena beleŋeb qaji naŋgi Josep koba na subq gileb. Gilsib Josep na Yesus subq atnaq uneb. ");
INSERT INTO boj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Unsib olo puluosib naŋgo talq aisib ŋam so aqa ya quleq tulaŋ boledamu di gereiyosib atnab soqnej. Ŋam so aqa ya di Yesus aqa jejamuq di liyqajqa marsib deqa gereiyeb. Onaqa yori bati brantonaqa naŋgi Qotei aqa dal anjam dauryosib wau getentosib aqaratosib soqneb. ");
INSERT INTO boj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yori bati koboonaqa nebeonaq nobqolo ambru uŋgasari naŋgi olo tigelosib ŋam so aqa ya quleq boledamu nami gereiyeb qaji di osib Yesus aqa jejamuq di liyqajqa deqa subq gileb. ");
INSERT INTO boj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Naŋgi gilsib ŋam ateb di meniŋ kobaquja sub me getentesoqnej qaji di waqosiq taqal di sonaq uneb. ");
INSERT INTO boj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Unsib sub miligiq aiyeb di naŋgi Tamo Koba Yesus aqa jejamu unosai. ");
INSERT INTO boj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","5","Deqa naŋgi are tulaŋ kobainjrej. Onaqa tamo aiyel naŋgi brantosib uŋgasari naŋgo areq di tigelesonab unjrsib tulaŋ ulaugetosib turuosib mandamq di ŋam queb. Tamo aiyel di naŋgo gara tulaŋ minjalo. Onaqa naŋgi na uŋgasari naŋgi minjreb, “Niŋgi kiyaqa tamo moiyo sawaq endi tamo ŋambile unu qaji a qa ŋameqnub? ");
INSERT INTO boj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesus a endi sosai. A olo subq na tigelqo. Nami a Galili sawaq di sosiqa bati deqa a na niŋgi endegsi merŋgej, ‘E olo subq na tigelqai.’ Niŋgi aqa anjam deqa olo are walŋgwo kiyo? ");
INSERT INTO boj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Agi a niŋgi endegsi merŋgej, ‘E Tamo Aŋgro ojsibqa une tamo naŋgo baŋq di atib lubib moiqai. Bati qalub koboamqa e olo subq na tigelqai.’” ");
INSERT INTO boj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Onaqa uŋgasari naŋgi Yesus aqa anjam deqa olo are qalsibqa subq dena puluosib aisib anjam kalil tamo aiyel na minjreb qaji di Yesus aqa aŋgro 11 naŋgi tamo qudei ti sainjreb. ");
INSERT INTO boj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Uŋa bei aqa ñam Maria. A Makdala qure qaji. Bei Joana. Bei Maria. A Jems aqa ai. Uŋgasari qudei dego tamo aiyel naŋgo anjam di qusib aisib Yesus aqa anjam maro tamo naŋgi sainjreb. ");
INSERT INTO boj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sainjrnab qunab ugeinjrnaq mareb, “Uŋgasari naŋgo anjam di laŋa sa anjam.” ");
INSERT INTO boj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Onaqa Pita a tigelosiqa urur ti gilsiq sub miligiq di tirosiq ŋam atej di Yesus dalaeb qaji gara di segi sonaq unej. Unsiqa olo puluosiq aqa talq aisiq kumbra deqa are koba qaloqnej. ");
INSERT INTO boj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bati qujai deqa Yesus aqa aŋgro aiyel naŋgi Jerusalem uratosib qure bei aqa ñam Emeus deq giloqneb. Jerusalem dena tigelosib Emeus qureq gilqajqa kiñala isaq 11 kilomita dego. ");
INSERT INTO boj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Naŋgi aiyel giloqnsibqa kumbra kalil jeu tamo naŋgi na Yesus yoqneb qaji deqa ombla maroqnsib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gileqnabqa Yesus a segi naŋgoq di brantosiqa naŋgi koba na walwelosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naŋgi Yesus uneb ariya naŋgi a qa poinjrosai. ");
INSERT INTO boj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Deqa a na naŋgi aiyel endegsi nenemnjrej, “Niŋgi anjam kiye maroqnsib gileqnub?” Degsi nenemnjrnaqa naŋgi tigeleb. Yesus a moiyej deqa naŋgi aiyel ulatamu tulaŋ ugeinjrej. ");
INSERT INTO boj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Onaqa bei aqa ñam Kliopas a na kamba Yesus minjej, “Tamo gargekoba naŋgi Jerusalem endi unub. Ni segi kiyo kumbra brantej qaji deqa qaliesai?” ");
INSERT INTO boj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Onaqa Yesus na kamba nenemnjrej, “Kumbra kiye brantej?” Onaqa naŋgi aiyel na minjeb, “Kumbra kalil Nasaret tamo Yesus aqaq di brantej qaji iga deqa mareqnum. A Qotei aqa medabu o qaji tamo bole soqnej. A Qotei ti tamo uŋgasari kalil ti naŋgo ŋamdamuq di maŋwa kokba yoqnej. Osiqa anjam siŋgila ti dego maroqnej. ");
INSERT INTO boj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ariya a kumbra degyeqnaqa gago gate naŋgi ti atra tamo kokba ti naŋgi na a ojsib Rom naŋgo baŋq di ateb. Atnabqa naŋgi na a osib tigeltosib minjeb, ‘Ni une tamo. Deqa ni moiqam.’ Degsib minjsib a osib ŋamburbasq di qalnab moiyej. ");
INSERT INTO boj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iga are qalem, ‘Yesus a na qujai iga Israel tamo uŋgasari awaigim iga bole sqom.’ “Anjam bei dego unu. Yesus a moiyej bati qalub gilqo. ");
INSERT INTO boj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Yqoqa nobqolo ambru gago uŋgasari qudei naŋgi Yesus aqa subq gilonub naŋgi aqa jejamu unosai. Dena puluosib bosib iga mergonub, ‘Iga subq di laŋ aŋgro qudei unjronumqa naŋgi na mergonub, “Yesus a subq na tigelqo. Deqa a ŋambile unu.” ’ Uŋgasari naŋgi na iga degsi mergonubqa iga tulaŋ prugugetonum. ");
INSERT INTO boj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tamo qudei naŋgi iga koba na sonam naŋgi dego subq gilonub. Gilsib kumbra kalil uŋgasari naŋgi na unsib saigonub qaji di unonub. Ariya naŋgi Yesus aqa jejamu unosai.” ");
INSERT INTO boj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Onaqa Yesus na kamba minjrej, “Nuŋgo areqalo tulaŋ truquiŋgwo. Qotei aqa medabu o tamo naŋgo anjam nami maroqneb qaji di niŋgi poiŋgosai. ");
INSERT INTO boj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anjam agiende. Kristus a jaqatiŋ koba osim moisim laŋ qureq oqimqa Qotei na ñam kobaquja yqas.” ");
INSERT INTO boj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Osiqa Yesus a segi qa anjam kalil neŋgreŋq di so qaji di naŋgi sainjrej. A Qotei aqa medabu o tamo kalil naŋgi Moses ombla naŋgo anjam neŋgreŋq di so qaji dena utru atsiq anjam geregere plaltosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Ariya naŋgi qalub koba na walwelosib qure naŋgi gilqa mareb qaji di jojomyosib Yesus a naŋgi uratnjrsim gam bei dauryqa laqnaqa naŋgi aiyel na saidyosib minjeb, “Ni iga uratgaim. Qoloqas. Deqa ni iga koba na sqom.” Degsi minjnabqa a naŋgi aiyel daurnjrsiqa naŋgo tal gogetosib koba na soqneb. ");
INSERT INTO boj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sosib awoosib iŋgi uyoqnsib Yesus a bem osiq Qotei pailyosiqa bem giŋgeŋyosiqa naŋgi aiyel anainjrej. ");
INSERT INTO boj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Anainjrnaqa bati deqa naŋgi Yesus qa poinjrnaqa mareb, “Bole, tamo endi Yesus.” Degsib marnabqa Yesus a naŋgo ambleq na loumosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ulaŋonaq naŋgi mareb, “Bole, aqo aiyel gamq di walweleqnamqa Yesus a Qotei aqa anjam neŋgreŋq di so qaji di aqa utru geregere plaltosiq mergeqnaqa iga quoqnsim tulaŋ arearetgoqnaj.” ");
INSERT INTO boj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naŋgi aiyel degsib marsib bati qujai deqa naŋgi tigelosib olo puluosib Jerusalem aisib Yesus aqa aŋgro 11 naŋgi tamo qudei ti koroesonab itnjreb. ");
INSERT INTO boj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Onaqa naŋgi na naŋgi aiyel endegsib minjreb, “Tamo Koba a bole subq na tigelqo. Agi a subq na tigelosiq Saimon aqaq di brantqoqa a bole unqo.” ");
INSERT INTO boj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Degsib minjrnabqa naŋgi aiyel kamba anjam kalil gamq di Yesus na minjrej qaji deqa ti a na bem giŋgeŋyosiq anainjrnaqa naŋgi a qa poinjrej deqa ti naŋgi sainjreb. ");
INSERT INTO boj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Degsib sainjreqnabqa Yesus a segi naŋgo ambleq di brantosiq minjrej, “Niŋgi are lawo soqniy.” ");
INSERT INTO boj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Degsi minjrnaqa naŋgi kalil ulaosib tulaŋ prugugetosib are qaleb, “Iga buga bei unonum kiyo?” ");
INSERT INTO boj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Onaqa Yesus na minjrej, “Niŋgi kiyaqa e buga qa marsib ulaosib prugonub? ");
INSERT INTO boj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Endi e di. Niŋgi ijo baŋ bile unsib ijo siŋga unsib baŋ waiyosib ijo jejamu ojsib poiŋgwas, e damu ti tanu ti. Buga a damu ti tanu ti saiqoji.” ");
INSERT INTO boj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","41","Yesus na naŋgi degsi minjrsiqa aqa baŋ ti siŋga ti naŋgi osornjrnaqa naŋgi unsib tulaŋ areboleboleinjrej. Onaqa naŋgi olo areqalo aiyeltoqnsib are koba qaloqneb. Yeqnaqa Yesus na minjrej, “Niŋgi iŋgi bei unu e?” ");
INSERT INTO boj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Onaqa naŋgi qe bei koiteb qaji di gentosib mutu bei Yesus yonab osiq naŋgo ŋamdamuq di uyej. ");
INSERT INTO boj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Uysiqa minjrej, “E nami niŋgi koba na sosimqa endegsi merŋgoqnem, ‘Dal anjam kalil Moses a e qa neŋgreŋyej qaji di aqa damu brantqas. Anjam kalil Qotei aqa medabu o tamo naŋgi e qa neŋgreŋyeb qaji di dego aqa damu brantqas. Anjam kalil louqa buk miligiq di e qa neŋgreŋyeb qaji di dego aqa damu brantqas.’ E nami niŋgi degsi merŋgoqnem.” ");
INSERT INTO boj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Osiqa Yesus a naŋgo areqalo waqtetnjrnaqa naŋgi Qotei aqa anjam neŋgreŋq di so qaji di aqa utru geregere poinjrej. ");
INSERT INTO boj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Onaqa Yesus na olo minjrej, “Kristus a jaqatiŋ koba osim moisim bati qalub koboamqa a olo subq na tigelqas anjam di neŋgreŋq di unu. ");
INSERT INTO boj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Deqa ijo anjam maro tamo naŋgi sawa sawa kalilq giloqnsibqa dia ijo anjam palontoqnqab. Palontoqnib tamo uŋgasari naŋgi quoqnsib are bulyoqnqab. Yimqa Qotei a ijo ñam na naŋgo une kobotetnjroqnqas. O ijo aŋgro, niŋgi segi ijo anjam maro tamo unub deqa kumbra kalil e nami nuŋgo ŋamdamuq di yoqnem qaji deqa tamo uŋgasari naŋgi sainjroqniy. Niŋgi Jerusalem endia wau di utru atsib laqniy. ");
INSERT INTO boj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Niŋgi quiy. Mondor Bole ijo Abu a nami nuŋgoq qariŋyqa marej qaji di e na qariŋyit nuŋgoq bqas. Deqa niŋgi qure endia tariŋoqniy. Tariŋosib soqnibqa laŋ goge na Qotei aqa siŋgila nuŋgoq bqas.” ");
INSERT INTO boj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Osiqa Yesus na aqa aŋgro naŋgi joqsiqa Jerusalem uratosib Betani qureq gileb. Gilsib dia aqa baŋ soqtosiqa naŋgi qa pailyej. ");
INSERT INTO boj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pailyeqnaqa Qotei na a metonaq naŋgi uratnjrsiqa laŋ qureq oqej. ");
INSERT INTO boj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A laŋ qureq oqeqnaqa naŋgi siŋga pulutosibqa a qa louosib tulaŋ areboleboleinjrej. Onaqa naŋgi olo puluosib Jerusalem aiyeb. ");
INSERT INTO boj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aisib bati gaigai atra tal miligiq di sosibqa Qotei aqa ñam soqtoqneb. ");
INSERT INTO boj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tulaŋ nami iŋgi iŋgi kalil brantosaisonabqa Anjam a soqnej. Anjam a Qotei ombla soqneb. Anjam a segi Qotei. ");
INSERT INTO boj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tulaŋ nami Anjam a Qotei ombla soqneb. ");
INSERT INTO boj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anjam a siŋgila ti soqnej. Siŋgila dena Qotei na iŋgi iŋgi kalil gereiyej. Iŋgi bei gam bei na brantosai. Iŋgi iŋgi kalil branteleŋeb qaji di Anjam a segi na gereiyej. ");
INSERT INTO boj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Anjam a segi ŋambile qa utru. Ŋambile di puloŋ bul. Ŋambile dena tamo uŋgasari naŋgi suwantnjreqnu. ");
INSERT INTO boj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Puloŋ di ambruq di suwaŋeqnu. Ambru na puloŋ di mosotqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tamo bei brantej aqa ñam Jon. Qotei na a qariŋyonaq bej. ");
INSERT INTO boj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A bosiqa puloŋ qa anjam palontoqnej. Di kiyaqa? Tamo uŋgasari kalil naŋgi aqa anjam qusib puloŋ qa naŋgo areqalo siŋgilatqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon a puloŋ sai. A puloŋ qa anjam palontqajqa bej. ");
INSERT INTO boj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Puloŋ di puloŋ bole. A mandamq aisiqa tamo uŋgasari kalil naŋgi suwantnjreqnu. ");
INSERT INTO boj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Anjam a mandamq di soqnej. Aqa siŋgila na Qotei a mandam atej. Ariya tamo uŋgasari mandamq di soqneb qaji naŋgi a qa poinjrosai. ");
INSERT INTO boj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A aqa segi qure utruq ainaqa aqa leŋ qujai naŋgi a areiyosai. ");
INSERT INTO boj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ariya tamo uŋgasari a areiyosib aqa ñam qa naŋgo areqalo siŋgilateb qaji naŋgi a na giltnjrnaqa naŋgi Qotei aqa aŋgro tiŋtiŋ branteb. ");
INSERT INTO boj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ai abu na ŋambabtnjro qaji naŋgoq dena naŋgi Qotei aqa aŋgro brantosai. Naŋgo segi areqalo na naŋgi Qotei aqa aŋgro brantosai. Tamo bei aqa areqalo na dego naŋgi Qotei aqa aŋgro brantosai. Qotei a segi na marnaqa naŋgi aqa aŋgro tiŋtiŋ branteb. ");
INSERT INTO boj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Anjam di a tamo bulyosiqa gago ambleq di soqnej. Sonaqa iga aqa ñam koba ti aqa siŋgila koba ti unem. A segi qujai Qotei aqa Ŋiri. A iga qa are tulaŋ boleiyeqnu. A segi anjam bole qa utru. ");
INSERT INTO boj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A qa nami Jon a anjam palontoqnsiqa endegsi leleŋoqnej, “E nami maroqnem, ‘Tamo di a ijo qoreq na bqas. E ŋambabosaisonamqa a nami soqnej. Deqa a na e tulaŋ buŋbejunu.’” ");
INSERT INTO boj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Qotei aqa Ŋiri a iga kalil qa are tulaŋ boleiyeqnu. Aqa kumbra dena a na iga tulaŋ geregereigeqnu. ");
INSERT INTO boj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bole, nami Qotei a Moses aqa wau na iga dal anjam egej. Ariya Yesus Kristus aqa wau na Qotei a iga qa are boleiyosiqa anjam bole egej. ");
INSERT INTO boj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tamo bei na Qotei aqa ulatamu unosai. Qotei aqa Ŋiri a na qujai iga Qotei osorgej. Qotei aqa Ŋiri a segi Qotei. A aqa Abu aqa areq di sosiq beteryejunu. ");
INSERT INTO boj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bati bei Juda tamo kokba naŋgi na atra tamo ti Livai naŋgi ti qariŋnjrnabqa Jerusalem qure uratosib Jon aqa areq gilsib nenemyeb, “Ni tamo yai?” ");
INSERT INTO boj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ariya Jon a anjam ulitosai. A segi qa ubtosiqa minjrej, “E Kristus sai.” ");
INSERT INTO boj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Onaqa naŋgi na olo nenemyeb, “Deqa ni tamo yai? Ni Elaija kiyo?” Onaqa a na minjrej, “Sai.” Onaqa naŋgi na olo nenemyeb, “Ni Qotei aqa medabu o tamo iga a qa tariŋeqnum qaji tamo de kiyo?” Onaqa a na kamba minjrej, “Sai. E a sai.” ");
INSERT INTO boj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Deqa olo nenemyeb, “Ni tamo yai? Ni segi qa kiyersi mareqnum di geregere mergimqa iga olo aisim tamo naŋgi iga qariŋgonub qaji di minjrqom.” ");
INSERT INTO boj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Onaqa Jon na minjrej, “Nami Qotei aqa medabu o qaji tamo Aisaia a anjam endegsi neŋgreŋyej, ‘Tamo bei a wadau sawaq di tulaŋ leleŋoqnsim tamo uŋgasari naŋgi minjroqnqas, “Tamo Koba a bqajqa gam gereiyetiy.” ’ Aisaia a nami anjam degsi neŋgreŋyej. Gam gereiyqa tamo agi e segi.” ");
INSERT INTO boj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tamo naŋgi di Farisi naŋgi na qariŋnjrnab Jon aqaq gileb. ");
INSERT INTO boj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Deqa naŋgi olo Jon nenemyeb, “Ni Kristus sai. Ni Elaija sai. Ni Qotei aqa medabu o qaji tamo di sai. Deqa ni kiyaqa tamo uŋgasari naŋgi yansnjreqnum?” ");
INSERT INTO boj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Onaqa Jon na kamba minjrej, “E ya na naŋgi yansnjreqnum. Ariya nuŋgo ambleq di tamo bei unu. Niŋgi a qa qaliesai. ");
INSERT INTO boj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A ijo qoreq na bqas. A ñam ti unu. E ñam saiqoji. Deqa e na a kaŋgalyqajqa e tamo bolesai.” ");
INSERT INTO boj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon a Betani qureq di naŋgi anjam degsi minjroqnej. Betani qure di Jordan ya taqal beiq di unu. Dia Jon na tamo uŋgasari naŋgi yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nebeonaqa Yesus a walwelosiq Jon aqa areq beqnaqa unsiq marej, “Niŋgi uniy. Tamo di a Qotei aqa Kaja Du. A na qujai tamo uŋgasari mandamq endi unub qaji naŋgo une kobotetnjrqas. ");
INSERT INTO boj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","E tamo deqa nami endegsi merŋgoqnem, ‘A ijo qoreq na bqas. E ŋambabosaisonamqa a nami soqnej. Deqa a na e tulaŋ buŋbejunu.’ ");
INSERT INTO boj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","E nami a qa qaliesai. Ariya Israel naŋgi a qa qalieqajqa deqa e bosim ya na tamo uŋgasari naŋgi yansnjreqnum.” ");
INSERT INTO boj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon a naŋgi degsi minjrsiqa olo minjrej, “Qotei aqa Mondor a laŋ qure uratosiq binoŋ bulosiq mandamq aisiqa Yesus aqa gateq di awoonaq e unem. ");
INSERT INTO boj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","E nami Yesus qa qaliesai. Ariya Qotei agi e ya na tamo uŋgasari naŋgi yansnjrqajqa qariŋbej qaji a na merbej, ‘Ijo Mondor Bole a aisim tamo bei aqa gateq di awoamqa ni unqam. A na qujai Mondor aqa siŋgila na tamo uŋgasari naŋgi yansnjroqnqas.’ ");
INSERT INTO boj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Qotei na e degsi merbonaqa e tamo di unsim marem, ‘Bole, a Qotei aqa Ŋiri.’” ");
INSERT INTO boj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Olo nebeonaqa Jon aqa aŋgro aiyel naŋgi ti koba na tigelesonabqa Yesus a walwelosiq gileqnaqa Jon na unsiqa naŋgi aiyel minjrej, “Niŋgi uniy. Tamo di a Qotei aqa Kaja Du.” ");
INSERT INTO boj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Degsi minjrnaqa naŋgi aiyel Jon dauryqa uratosib olo Yesus dauryosib gileb. ");
INSERT INTO boj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Onaqa Yesus a bulosiqa naŋgi aiyel a dauryosib beqnabqa unjrsiqa nenemnjrej, “Niŋgi aiyel kiyaqa e daurbeqnub?” Onaqa minjeb, “Rabai, ni tal qabia unum?” Ñam “Rabai” di Hibru anjam. Gago anjam, “Qalie Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Onaqa Yesus na naŋgi aiyel minjrej, “Niŋgi bosib ijo tal uniy.” Onaqa naŋgi Yesus dauryosib gilsib tal a soqnej qaji di uneb. Unsib seŋ bati 4 onaq bilaqtej deqa naŋgi a ombla soqneb. ");
INSERT INTO boj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tamo aiyel Jon aqa anjam qusib Yesus dauryeb qaji bei aqa ñam Andru. A Saimon Pita aqa was. ");
INSERT INTO boj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A Yesus uratosiq walwelosiq aqa was Saimon itosiq minjej, “Iga Mesaia unonum.” Ñam “Mesaia” di Hibru anjam. Gago anjam, “Kristus.” ");
INSERT INTO boj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Degsi minjsiqa Saimon osiq Yesus aqa areq osi gilej. Onaqa Yesus na Saimon unsiqa minjej, “Ni Saimon. Ni Jon aqa ŋiri. Bunuqna ino ñam Sifas mermoqnqab.” Ñam “Sifas” di Hibru anjam. Gago anjam, “Pita.” Aqa damu, “Meniŋ.” ");
INSERT INTO boj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Olo nebeonaqa Yesus a Galili sawaq gilqa osiqa tamo bei aqa ñam Filip itosiq minjej, “Ni e daurbe.” ");
INSERT INTO boj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip a Betsaida qure qaji. Di Andru Pita wo naŋgo qure utru. ");
INSERT INTO boj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Onaqa Filip a aisiqa tamo bei aqa ñam Nataniel itosiq minjej, “Ni au. Iga tamo a qa nami Moses marsiq dal anjamq di neŋgreŋyej qaji a unonum. Qotei aqa medabu o qaji tamo naŋgi dego a qa maroqnsib neŋgreŋyoqneb. Tamo di Yesus Nasaret qure qaji. A Josep aqa ŋiri.” ");
INSERT INTO boj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Onaqa Nataniel na kamba Filip minjej, “Nasaret di qure kiñala. Di qure kobaquja sai. Tamo bole bei a qure dena brantqa kere kiyo?” Onaqa Filip na minjej, “Ni bosim tamo di unime.” ");
INSERT INTO boj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Onaqa Nataniel a walwelosiq Yesus aqa areq beqnaqa unsiqa a qa marej, “Niŋgi uniy. Tamo di a Israel tamo bolequja. A gisaŋ anjam marosaieqnu.” ");
INSERT INTO boj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Onaqa Nataniel na Yesus nenemyej, “Ni kiyersi e qa qalieonum?” Onaqa Yesus na kamba minjej, “Filip a ni metmosaisonaqa ni qura utruq di awesonamqa e ni numonum.” ");
INSERT INTO boj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Onaqa Nataniel a Yesus aqa anjam di qusiqa minjej, “O Qalie Tamo Koba, ni degsi maronum deqa e poibqo, ni Qotei aqa Ŋiri. Ni Israel naŋgo Mandor Koba.” ");
INSERT INTO boj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Onaqa Yesus na kamba minjej, “Ni qura utruq di awesonam e ni numonum e degsi ubtosim mermonumqa ni qusim ino areqalo e qa siŋgilatonum e? Di ijo siŋgila kiñala segi e babtonum. Bunuqna e ijo siŋgila kokba babtoqnit ni unoqnqam.” ");
INSERT INTO boj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Osiqa naŋgi kalil minjrej, “Niŋgi quiy. E bole merŋgwai. E segi Tamo Aŋgro. Deqa bunuqna laŋ waqamqa Qotei aqa laŋ aŋgro naŋgi ijo jejamuq na laŋ qureq oqoqnsib olo mandamq aiyoqnib niŋgi unjrqab.” ");
INSERT INTO boj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bati aiyel koboonaqa Kana qure agi Galili sawaq di unu dia tamo bei uŋa baŋ ojqa bati brantej. Deqa tamo uŋgasari naŋgi koroosib iŋgi goiyeb. Anjam qariŋyonab Yesus aqa ai a koro deq gilej. ");
INSERT INTO boj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus aqa aŋgro naŋgi ti dego metnjrnab koro deq gileb. ");
INSERT INTO boj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Koroosib iŋgi uyeqnabqa wain saiinjrnaqa Yesus aqa ai na minjej, “Naŋgi wain saiinjrqo.” ");
INSERT INTO boj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Onaqa Yesus na minjej, “Ai, di ino wau. Di ijo wau sai. Ijo wauqa bati brantosaiunu.” ");
INSERT INTO boj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Onaqa aqa ai na kaŋgal tamo naŋgi endegsi minjrej, “Yesus a anjam kiye merŋgimqa di dauryiy.” ");
INSERT INTO boj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tal dia ya nobu 6 kokba meniŋ na gereiyo qaji ateleŋonab soqneb. Juda naŋgi Qotei pailyqa oqnsib ya nobu dena ya tigoqnsib naŋgo baŋ ti jejamu ti yansoqneb. Deqa ya nobu di ateleŋonab soqneb. Ya nobu quja quja 100 lita. ");
INSERT INTO boj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ariya Yesus na kaŋgal tamo naŋgi minjrej, “Ya nobu di maqteleŋiy.” Onaqa naŋgi ya nobuq di ya qameleŋonab maqej. ");
INSERT INTO boj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Onaqa Yesus na olo minjrej, “Ya bei tigsib osi gilsib goiyo lanja a yiy.” Onaqa kaŋgal tamo naŋgi Yesus aqa anjam di dauryosib ya bei tigsib osi gilsib goiyo lanja a yeb. ");
INSERT INTO boj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ya di Yesus na bulyonaq wain babej. Wain babonaqa goiyo lanja a uyo oneiyosiq marej, “Endi wain bolequja.” Wain di qabe na bej di a qaliesai. Kaŋgal tamo ya tigeb qaji naŋgi segi qalie. Onaqa goiyo lanja a na tamo uŋa baŋ ojej qaji di metonaq aqa areq bonaq minjej, ");
INSERT INTO boj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Bati gaigai tamo naŋgi iŋgi goiyoqnsib wain qaqatiŋ bole namo tamo naŋgi anainjreqnab uyeqnub. Uyeqnab olo bunu wain qaqatiŋ bolesai di anainjreqnub. Ariya ni degyosai. Ni wain qaqatiŋ bole tentosim namo wain qaqatiŋ bolesai anainjronum uyonub olo bunu wain qaqatiŋ bole anainjronum.” ");
INSERT INTO boj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesus a Kana qureq di maŋwa di babtej. Kana qure agi Galili sawaq di unu. A nami maŋwa bei babtosaioqnej. Bati di qujai a na maŋwa babtqa utru atej. Maŋwa dena a na aqa segi ñam koba ti aqa siŋgila koba ti boleq atej. Onaqa aqa aŋgro naŋgi maŋwa di unsibqa a qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ariya uŋa baŋ ojqa bati di koboonaqa Yesus aqa was naŋgi ti aqa aŋgro naŋgi ti aqa ai koba na Kana qure uratosib Kaperneam qureq gileb. Gilsib dia bati qudei soqneb. ");
INSERT INTO boj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa naŋgi eleŋej. Deqa olo are qalqajqa yori bati jojomonaqa Yesus a Jerusalem aiyej. ");
INSERT INTO boj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aisiq atra tal kobaquja miligiq gilej. Gilsiqa ŋam atej di tamo naŋgi na makau ti kaja ti binoŋ ti qariŋyeqnabqa tamo qudei na awaiyeqnab unjrej. Silali piloqneb qaji tamo naŋgi naŋgo awo jaramq di awesosib silali pileqnabqa naŋgi dego Yesus na unjrej. ");
INSERT INTO boj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Unjrsiqa rauŋga osiq dena toqoŋ gereiyosiq ganiŋyoqnsiq naŋgi kalil naŋgo kaja ti naŋgo makau ti winjrnaqa atra tal uratosib jaraiyeb. Silali piloqneb qaji tamo naŋgi dego winjrsiq naŋgo awo jaram bilbelyosiq silali bimbleŋyetnjrej. ");
INSERT INTO boj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Osiqa tamo naŋgi binoŋ qariŋyoqnsibqa dena silali oqneb qaji naŋgi endegsi minjrej, “Niŋgi binoŋ di eleŋosib jaraiyiy. Niŋgi na ijo Abu aqa tal endi iŋgi qariŋyo tal bulyaib.” ");
INSERT INTO boj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Onaqa Yesus aqa aŋgro naŋgi aqa kumbra di unsibqa Qotei aqa anjam bei neŋgreŋq di so qaji deqa olo are qaleb. Agi nami endegsib neŋgreŋyeb, “O Abu, e ino tal qa tulaŋ arearetbqo. Deqa e ino tal bole sqajqa siŋgilaeqnum.” ");
INSERT INTO boj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesus na tamo naŋgi di winjrnaqa Juda tamo kokba naŋgi unsibqa deqa nenemyeb, “Ni maŋwa kiye babtim dena iga poigwas, ni Qotei aqa ñam na kumbra endi yeqnum?” ");
INSERT INTO boj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Onaqa Yesus na kamba minjrej, “Niŋgi na atra tal kobaquja endi koŋgrontibqa bati qalub qa e olo tigeltqai.” ");
INSERT INTO boj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Onaqa naŋgi na minjeb, “Atra tal endi gereiyeqnab wausau 46 koboej. Ni kiyaqa bati qalub qa olo tigeltqa maronum? Keresai.” ");
INSERT INTO boj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesus a atra tal qa marej di aqa segi jejamu sigitosiqa yawo anjam marej. ");
INSERT INTO boj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Deqa bunuqna a subq na tigelonaqa aqa aŋgro naŋgi aqa anjam deqa olo are qalsibqa Qotei aqa anjam nami neŋgreŋyeb qaji deqa poinjrnaqa Yesus qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa naŋgi eleŋej. Deqa olo are qalqajqa yori bati brantonaqa Yesus a Jerusalem di sosiqa maŋwa babteqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi unoqnsib aqa ñam qa naŋgo areqalo siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ariya Yesus a naŋgi areinjrosai. A tamo kalil naŋgi qa qalie bole. ");
INSERT INTO boj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A powo bei qa truquosaieqnu. Deqa tamo bei na tamo naŋgi qa ubtosim Yesus minjaiq. A segi tamo naŋgo areqalo qalie bole. ");
INSERT INTO boj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jerusalem dia tamo bei soqnej aqa ñam Nikodemus. A Farisi tamo. A Juda naŋgo gate bei. ");
INSERT INTO boj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A qolo Yesus aqa areq bosiqa minjej, “O Qalie Tamo Koba, iga qalieonum, ni powo tamo bole. Ni Qotei aqaq na bem. Qotei a ni siŋgila emosai qamu maŋwa ni yeqnum qaji di ni babtqa keresai qamu.” ");
INSERT INTO boj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Onaqa Yesus na kamba minjej, “E bole mermqai. Tamo bei a aŋgro mom bunuj bulosim ŋambabqasai di Qotei na a taqatosim aqa Mandor Koba sqasai. Deqa a Qotei unqa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Onaqa Nikodemus na nenemyej, “Tamo a qeliqo di a kiyersim olo aqa ai miligiq aisim aŋgro mom bulosim ŋambabqas?” ");
INSERT INTO boj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Onaqa Yesus na kamba minjej, “E bole mermqai. Tamo bei a ya na ti Qotei aqa Mondor na ti aŋgro mom bunuj bulosim ŋambabqasai di Qotei na a taqatosim aqa Mandor Koba sqasai. ");
INSERT INTO boj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Niŋgi nuŋgo ai abu naŋgo jejamuq dena ŋambabeqnub deqa niŋgi mandam tamo unub. Ariya Qotei aqa Mondor na tamo bei ŋambabtqas di a mondor ti sqas. ");
INSERT INTO boj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","E ni mermonum, ‘Niŋgi aŋgro mom bunuj bulosib ŋambaboiy.’ Ni ijo anjam di qusim prugugetaim. ");
INSERT INTO boj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jagwa a segi puyoqnsiqa sawa sawaq gileqnaqa ni aqa anjam ato queqnum. Ariya a qabe na kiyo boqnsiq qabiteqnu di ni qaliesai. Tamo kalil Qotei aqa Mondor aqa siŋgila na aŋgro mom bunuj bulosib ŋambabeqnub qaji naŋgi kere dego.” ");
INSERT INTO boj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Onaqa Nikodemus na olo Yesus nenemyej, “Kumbra di kiyersi brantqas?” ");
INSERT INTO boj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Onaqa Yesus na kamba minjej, “Ni Israel naŋgo qalie tamo koba. Ni kiyaqa ijo anjam endeqa poimosai? ");
INSERT INTO boj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","E bole mermqai. Anjam iga qalieonum qaji deqa mareqnum. Kumbra iga uneqnum qaji deqa saeqnum. Ariya niŋgi gago anjam endi ojosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Endego e mandam qa anjam merŋgonumqa niŋgi qusib nuŋgo areqaloq di siŋgilatosai. Deqa e laŋ qure qa anjam dego merŋgit niŋgi kiyersib nuŋgo areqaloq di siŋgilatqab? ");
INSERT INTO boj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tamo bei a laŋ qureq oqosai. E Tamo Aŋgro e segi qujai laŋ qureq dena mandamq aiyem. ");
INSERT INTO boj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nami Moses a wadau sawaq di sosiqa a amal sigitosiq soqtosiqa gaintej. Dego kere e Tamo Aŋgro soqtbosib gaintbqab. ");
INSERT INTO boj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Amqa tamo kalil e qa naŋgo areqalo siŋgilatqab qaji naŋgi ŋambile gaigai sqab. ");
INSERT INTO boj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Qotei aqa Ŋiri qujai unu. Qotei na tamo uŋgasari kalil mandamq endi unub qaji naŋgi tulaŋ qalaqalainjrsiq deqa aqa segi Ŋiri qujai di naŋgi enjrej. A endegsi are qalej, ‘Tamo uŋgasari naŋgi ijo Aŋgro qa naŋgo areqalo siŋgilatqab di naŋgi padalqasai. Naŋgi ŋambile gaigai sqab.’ Qotei a degsi are qalsiq deqa aqa segi Ŋiri qujai naŋgi enjrej. ");
INSERT INTO boj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Qotei a tamo uŋgasari mandamq endi unub qaji naŋgo une qa peginjrqa marsiq aqa Ŋiri qariŋyosai. A naŋgi eleŋam naŋgi padalaib deqa osiq aqa Ŋiri qariŋyonaq mandamq aiyej. ");
INSERT INTO boj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateqnub qaji naŋgi Qotei na peginjrqasai. Ariya tamo uŋgasari Yesus qa naŋgo areqalo siŋgilatosaieqnub qaji naŋgi Qotei na peginjrqas. Di kiyaqa? Naŋgi aqa segi Ŋiri qujai aqa ñam qa naŋgo areqalo siŋgilatosai deqa. ");
INSERT INTO boj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Qotei na tamo uŋgasari naŋgi di peginjrqas di aqa utru agiende. Puloŋ a mandamq ainaqa naŋgi ambru qa arearetnjroqnej. Naŋgi puloŋ qa arearetnjrosaioqnej. Di kiyaqa? Naŋgi kumbra uge yoqneb deqa. ");
INSERT INTO boj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tamo uŋgasari kalil kumbra uge yeqnub qaji naŋgi puloŋ jeuteqnub. Naŋgo kumbra uge di puloŋ na boleq ataim deqa naŋgi puloŋ aqaq bosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ariya tamo uŋgasari anjam bole dauryeqnub qaji naŋgi puloŋ aqaq beqnub. Boqnsib wau bole bole yeqnabqa tamo naŋgi unoqnsib mareqnub, ‘Bole, naŋgi Qotei aqa siŋgila na wau di yeqnub.’” ");
INSERT INTO boj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bati bei Yesus aqa aŋgro naŋgi ti walwelosib Judia sawaq gileb. Gilsib dia sosibqa Yesus na tamo uŋgasari naŋgi yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon yansnjro qaji a Ainon qureq di sosiqa a dego tamo uŋgasari naŋgi yansnjroqnej. Ainon qure di Salim qure jojomq di unu. Dia ya koba soqnej deqa tamo uŋgasari naŋgi Jon aqa areq beqnabqa a na yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Herot na Jon tonto talq di waiyosaisoqnej deqa Jon a kumbra di yoqnej. ");
INSERT INTO boj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bati bei Jon aqa aŋgro qudei naŋgi Juda tamo bei ti jejamu yanso kumbra qa anjam na qotoqneb. ");
INSERT INTO boj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Osib naŋgi Jon aqa areq gilsib minjeb, “O Qalie Tamo, nami tamo ni ombla Jordan ya taqal beiq di sosibqa ni a qa anjam maroqnem qaji bini tamo uŋgasari kalil naŋgi aqa areq gileqnabqa a na yansnjreqnu. Naŋgi inoq bosaieqnub.” ");
INSERT INTO boj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Onaqa Jon na kamba minjrej, “Qotei laŋ qureq di unu qaji a na iga iŋgi bei egwasai di iga iŋgi bei oqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Niŋgi segi ijo anjam bei quoqneb. Agi e merŋgoqnem, ‘E Kristus sai. Qotei na e namoqna qariŋbonaq e Kristus bqajqa gam gereiyetem.’ ");
INSERT INTO boj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tamo uŋa baŋ ojqas qaji a segi na uŋa di oqas. Aqa was a laŋa qalaq di tigelesosimqa tamo uŋa baŋ ojqo qaji aqa anjam quoqnqas. Qusimqa tulaŋ areboleboleiyqas. Dego kere e bini tulaŋ areboleboleibqo. ");
INSERT INTO boj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kristus aqa ñam tulaŋ kobaqas. Ijo ñam aguq aiqas.” Jon na aqa aŋgro naŋgi degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tamo laŋ qureq di sosiqa dena mandamq aiyej qaji a na iŋgi iŋgi kalil tulaŋ buŋnjrejunu. Mandam qaji tamo uŋgasari naŋgi mandam endeqa kumbra yoqnsib anjam mareqnub. Ariya tamo laŋ qureq di sosiqa dena mandamq aiyej qaji a na iŋgi iŋgi kalil tulaŋ buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kumbra a uneqnu qaji a deqa saeqnu. Anjam a queqnu qaji di a na babtosiq mareqnu. Ariya mandam qaji tamo uŋgasari naŋgi aqa anjam di ojosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tamo uŋgasari Yesus aqa anjam di ojeqnub qaji naŋgi a qa naŋgo areqalo siŋgilatoqnsib mareqnub, “Bole, Qotei a anjam bole qa utru.” Naŋgi degsib mareqnub. ");
INSERT INTO boj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tamo Qotei na qariŋyej qaji a Qotei aqa anjam babtosiq mareqnu. Di kiyaqa? Qotei na aqa Mondor a torei yekritej deqa. A na aqa Mondor potosiq taqal bei segi Yesus yosai. ");
INSERT INTO boj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abu na aqa segi Ŋiri qalaqalaiyeqnu deqa a na iŋgi iŋgi kalil aqa baŋq di ateleŋej. ");
INSERT INTO boj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tamo uŋgasari Qotei aqa Ŋiri qa naŋgo areqalo siŋgilateqnub qaji naŋgi ŋambile gaigai sqab. Ariya tamo uŋgasari Qotei aqa Ŋiri aqa anjam dauryqa urateqnub qaji naŋgi ŋambile itqasai. Qotei aqa minjiŋ naŋgoq di sqas. ");
INSERT INTO boj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Farisi naŋgi endegsib queb, “Yesus a Jon buŋyosiqa tamo uŋgasari tulaŋ gargekoba yansnjreqnaqa naŋgi a dauryeqnub. Jon a tamo gargekoba yansnjrosaieqnu.” Farisi naŋgi degsib queb. Bole, Yesus a segi na tamo uŋgasari naŋgi yansnjrosaioqnej. Aqa aŋgro naŋgi na yansnjroqneb. Tamo Koba Yesus a qalieej, Farisi naŋgi degsib queb. Deqa a Judia sawa uratosiqa olo Galili sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","A gam dauryosiqa Samaria sawa amble potosiqa walwelosiq gilej. ");
INSERT INTO boj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Gilsiq Samaria naŋgo qure kiñala bei aqa ñam Sikar di brantej. Qure qalaq di mandam mutu bei soqnej. Mandam mutu di Jekop a nami aqa ŋiri Josep yej. ");
INSERT INTO boj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya uyqajqa sub dia soqnej. Ya sub di Jekop a nami bogej qaji. Yesus a walwelosiq qanam jige seŋ bati 12 onaqa aqa jejamu asgiyonaqa aqaratqa osiqa ya sub qalaq di awoej. ");
INSERT INTO boj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Onaqa aqa aŋgro naŋgi iŋgi awaiyqa marsib qure miligiq aiyeb. Aiyeqnabqa Samaria uŋa bei a ya tugwajqa bej. Bonaqa Yesus na minjej, “Ya gambaŋ tigsim e anaibe.” ");
INSERT INTO boj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Onaqa Samaria uŋa dena Yesus kamba minjej, “Ni Juda tamo. E Samaria uŋa. Deqa ni kiyaqa e merbonum, ‘Ya gambaŋ tigsim e anaibe’?” Uŋa na degsiqa Yesus minjej. Di kiyaqa? Juda naŋgi Samaria naŋgi ti koba na anjam marosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Onaqa Yesus na uŋa di minjej, “Ni iŋgi bole Qotei na laŋa emqajqa di qalieosim qamu tamo ni na ya tigsim anaiyqajqa mermqo qaji a qa poimqo qamu ni e merbimqa ŋambile gaigai sqajqa ya anaimonum qamu.” ");
INSERT INTO boj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Onaqa uŋa dena minjej, “O Tamo Koba, ni ya tugwajqa gambaŋ saiqoji. Ya sub endi tulaŋ guma koba. Deqa ni qabe na ŋambile gaigai sqajqa ya di oqam? ");
INSERT INTO boj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gago moma utru Jekop a nami ya sub endi bogsiqa gago moma naŋgi enjrej. A sub endena ya uyoqnej. Aqa aŋgro naŋgi ti aqa makau ti aqa kaja ti naŋgi dego sub endena ya uyoqneb. Ni na gago moma utru Jekop buŋyqam kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Onaqa Yesus na kamba minjej, “Tamo naŋgi sub endena ya uyoqnqab di naŋgi olo bunu ya qarnjroqnqas. ");
INSERT INTO boj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ariya e na tamo naŋgi ya anainjrqai di naŋgi bunu ya qarnjrqasai. Ya e na anainjrqai di naŋgi uyibqa naŋgo are miligiq di ya ani bul polyoqnimqa naŋgi ŋambile gaigai sqab.” ");
INSERT INTO boj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Onaqa uŋa dena Yesus minjej, “O Tamo Koba, ni na ya di anaibimqa e olo ya qarboqnqasai. Amqa e olo bosiy sub endena ya tugoqnqasai.” ");
INSERT INTO boj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Onaqa Yesus na minjej, “Ni mati aisim ino gumbuluŋ metosim niŋgi ombla endeq boiy.” ");
INSERT INTO boj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Onaqa uŋa na minjej, “E gumbuluŋ saiqoji.” Onaqa Yesus na minjej, “Ni gumbuluŋ saiqoji di kere maronum. ");
INSERT INTO boj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ni nami gumbuluŋ 5 osim uratnjrem. Ariya tamo ni bini ombla unum qaji di ino gumbuluŋ sai. Deqa ino anjam di bole.” ");
INSERT INTO boj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Onaqa uŋa dena minjej, “O Tamo Koba, ni anjam di ubtosim merbonum deqa e poibqo, ni Qotei aqa medabu o qaji tamo bole. ");
INSERT INTO boj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gago moma naŋgi nami manaq endi korooqnsib Qotei qa louoqneb. Ariya Juda naŋgi mareqnub, ‘Qotei qa louqajqa sawa qujai agi Jerusalem.’” ");
INSERT INTO boj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Onaqa Yesus na olo minjej, “O uŋa, e ni anjam bei mermit ni qusim poimeme. Anjam agiende. Bati bei brantimqa manaq endi niŋgi Abu qa louoqnqasai. Jerusalem dia dego niŋgi Abu qa louoqnqasai. ");
INSERT INTO boj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niŋgi Samaria qaji. Deqa niŋgi Abu qa loueqnub qaji a qa geregere poiŋgosai. Ariya iga Juda qaji. Deqa iga Abu qa loueqnum qaji a qa geregere poigeqnu. Di kiyaqa? Abu na tamo uŋgasari naŋgi eleŋqajqa utru agi Juda iga segi. ");
INSERT INTO boj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ariya bati bei brantimqa tamo naŋgi Mondor na ti anjam bole na ti Abu qa louoqnqab. Osib naŋgo lou dena naŋgi Abu qa bole louoqnqab. Yim Abu a naŋgi qa tulaŋ areboleboleiyqas. Bati di agi brantqo. ");
INSERT INTO boj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Qotei a segi Mondor. Deqa tamo naŋgi Qotei qa louqa oqnsib Mondor na ti anjam bole na ti louoqnqab di naŋgi Qotei qa bole louoqnqab.” ");
INSERT INTO boj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Onaqa uŋa dena Yesus minjej, “E qalie, Mesaia a bqas.” “Mesaia” di Hibru anjam. Gago anjam, “Kristus.” Osiqa Yesus minjej, “Mesaia a bosimqa Qotei aqa anjam kalil ubtosim mergekritqas.” ");
INSERT INTO boj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Onaqa Yesus na minjej, “Mesaia agi e segi. Aqo ombla anjam mareqnum.” ");
INSERT INTO boj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesus a uŋa degsi minjnaqa aqa aŋgro naŋgi olo qureq na bosibqa a uŋa de wo anjam mareqnab unsibqa tulaŋ prugugeteb. Ariya naŋgi Yesus nenemyosai, “Ni kiyaqa uŋa de wo anjam mareqnub?” Degyosai. ");
INSERT INTO boj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Onaqa uŋa dena aqa ya nobu uratosiqa olo qure miligiq aisiqa tamo uŋgasari naŋgi minjrej, ");
INSERT INTO boj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Niŋgi bosib tamo di uniy. E kumbra nami yoqnem qaji di a na ubtekritqo. Tamo di a Kristus kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Degsi minjrnaqa naŋgi qure uratosib Yesus unqajqa beb. ");
INSERT INTO boj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Beqnabqa Yesus aqa aŋgro naŋgi na minjeb, “O Qalie Tamo Koba, ni bosim iŋgi uye.” ");
INSERT INTO boj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Onaqa Yesus na minjrej, “Ijo iŋgi uyo bei unu di niŋgi qaliesai.” ");
INSERT INTO boj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Onaqa aqa aŋgro naŋgi aqa anjam di qusibqa segi segi maroqneb, “Tamo bei na iŋgi bei osi bosiq anaiyqo kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Onaqa Yesus na minjrej, “Qotei e qariŋbej qaji aqa areqalo e dauryosiy aqa wau kobotqai. Ijo iŋgi uyo bole agide. ");
INSERT INTO boj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Niŋgi mareqnub, ‘Bai qolqe koboeqnaqa iŋgi melieqnu.’ Niŋgi degsib mareqnub. Ariya e na niŋgi yawo anjam bei endegsi merŋgwai. Niŋgi iŋgi wauq di ŋam atsib iŋgi meliosiq unu di unqab. ");
INSERT INTO boj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tamo iŋgi meli gentoqnsib koroiyeqnub qaji naŋgi awai eqnub. Naŋgo awai agi naŋgi ŋambile gaigai sqab. Deqa tamo naŋgi iŋgi yageqnub qaji ti tamo naŋgi iŋgi meli genteqnub qaji ti koba na areboleboleinjrqas. ");
INSERT INTO boj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Deqa anjam endi bole, ‘Tamo bei na iŋgi yagwas. Olo tamo bei na iŋgi meli gentqas.’ ");
INSERT INTO boj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","E niŋgi qariŋgonumqa gilsib wau niŋgi na wauosai qaji dena iŋgi eleŋeqnub. Tamo qudei naŋgi nami waukobaeb. Ariya niŋgi laŋa gilsib iŋgi eleŋeqnub.” ");
INSERT INTO boj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Uŋa dena Samaria tamo uŋgasari gargekoba qure dia soqneb qaji naŋgi Yesus qa sainjrnaq qusibqa Yesus qa naŋgo areqalo siŋgilateb. Di kiyaqa? Uŋa na minjrej, “Kumbra kalil e nami yoqnem qaji di tamo dena ubtekritqo.” ");
INSERT INTO boj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Degsi minjrnaq qusibqa Yesus aqa areq bosib minjeb, “Ni gago qureq endi iga koba na sqom.” Degsi minjnabqa Yesus a bati aiyel naŋgo qureq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sosiqa Qotei aqa anjam palonteqnaqa tamo uŋgasari gargekoba naŋgi aqa anjam quoqnsib poinjreqnaqa a qa naŋgo areqalo siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Deqa naŋgi na uŋa di minjeb, “Ni Yesus qa anjam mergonam qusim gago areqaloq di siŋgilatem. Siŋgilatosim sonamqa a segi na olo anjam mergwo qusim turtosim gago areqalo a qa torei siŋgilatonum. Osim deqa iga endegsi poigwo, ‘Bole, Yesus a na qujai tamo uŋgasari mandamq endi unub qaji naŋgi eleŋqas.’” ");
INSERT INTO boj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Onaqa bati aiyel koboonaqa Yesus a qure di uratosiqa walwelosiq Galili sawaq gilej. ");
INSERT INTO boj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A segi nami endegsi marej, “Qotei aqa medabu o qaji tamo bei aqa segi qure utruq gilsim anjam minjroqnqas di naŋgi aqa anjam quetqa asginjrqas. Deqa a qure dia ñam saiqoji sqas.” ");
INSERT INTO boj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesus a Galili sawaq di brantonaqa tamo uŋgasari sawa dia soqneb qaji naŋgi a qa tulaŋ areboleboleinjrej. Di kiyaqa? Nami Juda naŋgo yori bati koba qa Yesus a Jerusalem dia maŋwa babteqnaq naŋgi unoqneb deqa. ");
INSERT INTO boj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ariya Yesus a olo Kana qureq aiyej. Qure di agi Galili sawaq di unu. Qure dia nami Yesus a ya bulyonaqa wain babej. Aisiq di sonaqa Kaperneam qureq di Rom naŋgo mandor aqa tamo gate bei aqa ŋiri makobaiyonaq ŋeiesoqnej. ");
INSERT INTO boj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Deqa tamo gate di Yesus a Judia sawa uratosiq bosiq Galili sawaq di soqnej di qusiqa walwelosiq aqa areq aisiq pailyosiq minjej, “O Tamo Koba, ijo aŋgro a moiqa laqnu. Deqa ni bosim a boletime.” ");
INSERT INTO boj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Onaqa Yesus na tamo di minjej, “Niŋgi ijo maŋwa bei nuŋgo ŋamdamu na unqasai di niŋgi e qa nuŋgo areqalo siŋgilatqasai.” ");
INSERT INTO boj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Onaqa tamo dena olo Yesus minjej, “O Tamo Koba, ni boqujat. Ijo aŋgro a moiyo uge.” ");
INSERT INTO boj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Onaqa Yesus na minjej, “Ni gile. Endego ino aŋgro a boleqo ŋambile unu. A moiqasai.” Onaqa a Yesus aqa anjam di qusiqa bole qa marsiq gilej. ");
INSERT INTO boj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A gileqnaqa aqa kaŋgal tamo qudei naŋgi aqa talq dena bosib gamq di turosib minjeb, “Ino aŋgro a boleosiq ŋambile unu.” ");
INSERT INTO boj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Onaqa a na nenemnjrej, “Seŋ bati gembu a boleqo?” Onaqa minjeb, “Ya qanam seŋ bosiq iŋgi uyo bati tiŋyonaqa aqa jejamu kaŋkaŋ koboonaqa a boleej.” ");
INSERT INTO boj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Degsi minjnabqa a qalieej, seŋ bati deqa tiŋtiŋ Yesus na minjej, “Endego ino aŋgro a boleqo ŋambile unu. A moiqasai.” A degsi qalieosiq deqa a Yesus qa aqa areqalo siŋgilatej. Tamo kalil a ombla tal qujaiq di soqneb qaji naŋgi dego Yesus qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesus a Judia sawa uratosiq bosiq Galili sawaq di sosiqa bati deqa a maŋwa di yej. A nami Galili sawaq di maŋwa bei yosaioqnej. Aqa maŋwa qujai nami yej qaji agi a ya bulyonaq wain babej. ");
INSERT INTO boj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bati bei Yesus a Juda naŋgo yori bati koba unqa marsiqa Jerusalem aiyej. ");
INSERT INTO boj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem dia ya kuru bei soqnej. Ya kuru di kaja naŋgo siraŋme qalaq di soqnej. Ya kuru di aqa ñam Betesda. Di Hibru anjam na mareqnub. Ya kuru areqsi jagwa oqajqa tal kiñilala 5 soqneb. ");
INSERT INTO boj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tal dia tamo ma ti, tamo ŋam qandimo, tamo siŋga uge, tamo jejamu lainjro qaji tulaŋ gargekoba soqneb. Naŋgi ya anŋilqajqa tariŋoqneb. ");
INSERT INTO boj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bati qudei Tamo Koba aqa laŋ aŋgro ya kuru miligiq aiyoqnsiqa ya enteqnaqa anŋiloqnej. Ya anŋiloqnimqa tamo a namo yaq aiqas qaji aqa ma koboqas. Utru deqa naŋgi ya anŋilqajqa tariŋoqneb. ");
INSERT INTO boj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ariya bati deqa tamo bei wausau 38 ma ti soqnej qaji a dia tariŋoqnej. ");
INSERT INTO boj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Onaqa Yesus na tamo di ŋeiesonaq unsiqa a bati olekoba ma de ti soqnej di qalieosiqa nenemyej, “Ni boleqajqa are unu e?” ");
INSERT INTO boj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Onaqa minjej, “O Tamo Koba, ya anŋiloqnimqa tamo yai na e aqaryaibosim urur yaq osi aiqas? Tamo dego bei sosai. E aiqa yeqnam ma tamo qudei naŋgi e buŋboqnsib namo yaq aiyeqnub.” ");
INSERT INTO boj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Onaqa Yesus na minjej, “Ni tigelosim ino sapera qoboiyosim walwel.” ");
INSERT INTO boj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Degsi minjnaqa bati qujai deqa aqa jejamu boleonaqa a tigeloqujatosiq aqa sapera qoboiyosiqa walwelosiq gilej. Bati di Juda naŋgo yori bati. ");
INSERT INTO boj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Deqa Juda tamo kokba naŋgi na tamo boleej qaji di unsib minjeb, “Bini yori bati. Iga wauqa getento. Deqa ni ino sapera qoboiyaim.” ");
INSERT INTO boj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Onaqa a na kamba minjrej, “Tamo e boletbqo qaji a na merbqo, ‘Ni ino sapera qoboiyosim walwel.’” ");
INSERT INTO boj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Degsi minjrnaqa naŋgi na nenemyeb, “Tamo yai na ni mermqo, ‘Ni ino sapera qoboiyosim walwel’?” ");
INSERT INTO boj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Onaqa a na minjrej, “Tamo e boletbqo qaji aqa ñam di e qaliesai.” A naŋgi degsi minjrej. Di kiyaqa? Tamo gargekoba sonab Yesus a naŋgo ambleq na ulaŋej. ");
INSERT INTO boj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Onaqa nebeonaqa Yesus a atra tal miligiq gilsiqa tamo di itosiq minjej, “Ni que. E ni boletmonum deqa ni olo une bei ataim. Gulbe kobaquja bei ino jejamuq di olo branto uge.” ");
INSERT INTO boj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Onaqa tamo di aisiqa Juda tamo kokba naŋgi minjrej, “Tamo e boletbej qaji agi Yesus.” ");
INSERT INTO boj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Onaqa Juda tamo kokba naŋgi Yesus ugeugeiyqajqa maroqneb. Di kiyaqa? A maŋwa di yori bati qa yoqnej deqa. ");
INSERT INTO boj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Onaqa Yesus na kamba minjrej, “Ijo Abu a nami gaigai wauoqnej agi bini wauoqnsiq unu. Deqa e dego waueqnum.” ");
INSERT INTO boj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Onaqa Juda tamo kokba naŋgi Yesus aqa anjam di qusibqa naŋgi a qalib moiqajqa torei siŋgilaoqneb. Di kiyaqa? A yori bati segi gentosai. A dego marej, “Qotei a ijo Abu.” Aqa anjam dena a segi qa marej, “Aqo Qotei wo ombla kerekere.” ");
INSERT INTO boj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. E Qotei aqa Ŋiri. E ijo segi areqalo na kumbra bei yqa keresai. Kumbra ijo Abu na yeqnaq e uneqnum qaji di e dego yeqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","E ijo Abu aqa Ŋiri. Deqa a na e qalaqalaiboqnsiqa kumbra kalil a yeqnu qaji di e olo osorbeqnu. Bunuqna a kumbra tulaŋ siŋgila kokba dego osorboqnqas. Yim niŋgi unsib tulaŋ prugwab. ");
INSERT INTO boj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ijo Abu na tamo moreŋo qaji naŋgi olo ŋambile enjroqnsiqa subq na tigeltnjreqnu. Deqa e Qotei aqa Ŋiri e kamba dego ijo segi areqalo na tamo naŋgi ŋambile enjreqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ijo Abu na tamo naŋgo une qa naŋgi peginjrosaieqnu. Wau di a na e ebej. E Qotei aqa Ŋiri deqa e na tamo naŋgo une qa naŋgi peginjreqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","E wau di yeqnum. Di kiyaqa? Tamo kalil naŋgi ijo ñam soqtetboqnqajqa deqa. Agi naŋgi ijo Abu aqa ñam soqteqnub dego kere. Tamo a ijo ñam soqtetbosaieqnu di a ijo Abu e qariŋbej qaji aqa ñam dego soqtosaieqnu. ");
INSERT INTO boj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“E bole merŋgwai. Tamo a ijo anjam qusim ijo Abu e qariŋbej qaji a qa aqa areqalo siŋgilatqas di a ŋambile gaigai sqas. Deqa e aqa une qa pegiyqasai. A moiyo gam uratosim olo ŋambile oqas. ");
INSERT INTO boj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“E bole merŋgwai. E Qotei aqa Ŋiri. Bati bei brantimqa tamo uŋgasari moreŋo qaji naŋgi ijo kakro qusib ŋambile oqab. Bati di agi brantqo. ");
INSERT INTO boj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijo Abu a segi ŋambile qa utru. E aqa Ŋiri. A na e siŋgila ebej deqa e dego ŋambile qa utru. ");
INSERT INTO boj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E Tamo Aŋgro unum deqa ijo Abu na e siŋgila ebej. Siŋgila dena e na tamo uŋgasari naŋgo une qa peginjreqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Niŋgi ijo anjam di qusib tulaŋ prugaib. Bati bei brantimqa tamo uŋgasari kalil subq di unub qaji naŋgi ijo kakro quqwab. ");
INSERT INTO boj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Qusib olo sub uratosib tigelqab. Tamo uŋgasari kumbra bole bole yeqnub qaji naŋgi tigelosib ŋambile sqab. Tamo uŋgasari kumbra uge uge yeqnub qaji naŋgi tigelabqa e na naŋgi peginjrsiy padaltnjrqai.” ");
INSERT INTO boj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Osiqa Yesus a olo marej, “E ijo segi areqalo na wau bei yqa keresai. Ijo Abu na e anjam merbeqnaq quoqnsim tamo uŋgasari naŋgi peginjreqnum. E kumbra tiŋtiŋ na naŋgi peginjreqnum. E ijo segi areqalo dauryosaieqnum. Ijo Abu e qariŋbej qaji aqa areqalo dauryeqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“E segi na ijo kumbra ti ijo wau ti ubtosiy marqai di tamo naŋgi bole qa maraib. ");
INSERT INTO boj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tamo bei unu agi Qotei. A dego ijo kumbra ti ijo wau ti ubtosiq mareqnu. E qalieonum, anjam a mareqnu qaji di bole. ");
INSERT INTO boj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Niŋgi na tamo qudei qariŋnjrnab Jon aqaq gilnabqa a anjam bole ubtosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bole, mandam tamo bei na ijo kumbra ti ijo wau ti ubtqa keresai. Ariya Qotei na niŋgi eleŋqajqa deqa e niŋgi Jon qa merŋgonum. ");
INSERT INTO boj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon a ŋam puloŋ bul sosiqa tamo uŋgasari naŋgi suwantnjreqnaqa niŋgi aqa suwaŋoq di sokiñalayoqnsib areboleboleiŋgoqnej. ");
INSERT INTO boj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ijo anjam e ubtosim mareqnum qaji di anjam kobaquja. Anjam dena Jon aqa anjam tulaŋ buŋyejunu. Di kiyaqa? Wau kalil ijo Abu na ebej qaji di e yeqnam tamo uŋgasari naŋgi unoqnsib endegsi poinjreqnu, bole, ijo Abu na e qariŋbonaq bem. ");
INSERT INTO boj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ijo Abu e qariŋbej qaji a e qa anjam ubtosiq mareqnu. Ariya niŋgi aqa kakro nami quosaioqneb. Aqa ulatamu dego niŋgi nami unosaioqneb. ");
INSERT INTO boj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Qotei aqa anjam dego nuŋgo are miligiq di sosai. Tamo Qotei na qariŋyonaq mandamq aiyej qaji aqa anjam niŋgi nuŋgo areqaloq di siŋgilatosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Bole, niŋgi Qotei aqa anjam neŋgreŋq di unu qaji di sisiyoqnsib peleiyeqnub. Niŋgi are qaleqnub, anjam dena niŋgi ŋambile gaigai sqab. Ariya anjam di e ubtosiq mareqnu. ");
INSERT INTO boj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Niŋgi kiyaqa ŋambile oqajqa are qaloqnsib olo ijoq bqajqa urateqnub? ");
INSERT INTO boj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“E mandam tamo naŋgoq dena ñam koba osaieqnum. ");
INSERT INTO boj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ariya e niŋgi qa qalieonum. Nuŋgo are miligiq di niŋgi Qotei qalaqalaiyosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","E ijo Abu aqa ñam na bonamqa niŋgi ijo anjam osai. Tamo bei aqa segi ñam na bqas di niŋgi aqa anjam oqujatqab. ");
INSERT INTO boj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Niŋgi nuŋgo segi was naŋgoq dena ñam koba oqajqa are qaleqnub. Ariya niŋgi Qotei aqaq dena ñam koba oqajqa are qalosaieqnub. Qotei agi a segi qujai Qotei bole. Niŋgi kumbra degyeqnub deqa niŋgi kiyersib e qa nuŋgo areqalo siŋgilatqab? Di keresai. ");
INSERT INTO boj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“E ijo Abu aqa ŋamdamuq di nuŋgo une qa merŋgwai edegaib. Nuŋgo une qa merŋgwajqa tamo qujai agi Moses. Niŋgi are qaleqnub, Moses a na niŋgi aqaryaiŋgwas. Di sai. ");
INSERT INTO boj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Niŋgi Moses aqa anjam nuŋgo areqaloq di siŋgilateqnub qamu ijo anjam dego nuŋgo areqaloq di siŋgilateqnub qamu. Di kiyaqa? Moses a nami e qa anjam neŋgreŋyej. ");
INSERT INTO boj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Niŋgi Moses aqa anjam nami neŋgreŋyej qaji di nuŋgo areqaloq di siŋgilatosaieqnub deqa niŋgi kiyersib ijo anjam dego nuŋgo areqaloq di siŋgilatqab? Di keresai.” ");
INSERT INTO boj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bati bei Yesus a Galili ya agu taqal beiq gilej. Ya agu di yuwal bul tulaŋ kobaquja. Ya agu di aqa ñam bei Taiberias ya agu. ");
INSERT INTO boj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesus a tamo mainjro qaji naŋgoq di maŋwa babteqnaqa tamo uŋgasari tulaŋ gargekoba naŋgi unoqneb. Deqa a ya agu taqal beiq gileqnaqa naŋgi a dauryosib giloqneb. ");
INSERT INTO boj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bati di Yesus na aqa aŋgro naŋgi joqsiqa koba na manaq oqsibqa mana goge dia awesoqneb. ");
INSERT INTO boj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa naŋgi eleŋej. Deqa olo are qalqajqa yori bati jojomej. ");
INSERT INTO boj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Deqa Yesus a ŋam atsiqa tamo uŋgasari tulaŋ gargekoba a dauryosib aqa areq beqnabqa unjrsiqa Filip nenemyej, “Iga qabe na iŋgi awaiyosim tamo uŋgasari kalil di anainjronam kereqas?” ");
INSERT INTO boj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filip a kamba Yesus kiyersi minjim quqwajqa deqa Yesus na laŋa nenemyej. Yesus a kumbra kiye yqas di a segi nami qalieej. ");
INSERT INTO boj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Onaqa Filip na kamba Yesus minjej, “Tamo uŋgasari naŋgi di tulaŋ gargekoba. Iga 200 kina osim dena iŋgi awaiyosim iŋgi kiñala kiñala anainjrqom di tulaŋ kereqasai.” ");
INSERT INTO boj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Onaqa Yesus aqa aŋgro bei Andru di Saimon Pita aqa was a na Yesus minjej, ");
INSERT INTO boj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aŋgro wala bei unu. A bem 5 qe kiñilala aiyel ojejunu. Iŋgi di dego tamo uŋgasari gargekoba endi anainjrqom di tulaŋ kereqasai.” ");
INSERT INTO boj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Onaqa Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi na tamo uŋgasari kalil naŋgi minjribqa mandamq di awoeleŋeb.” Sawa dia ñiŋ koba soqnej deqa Yesus aqa aŋgro naŋgi na tamo uŋgasari minjrnabqa kalil ñiŋq di awoeleŋeb. Tamo awoeleŋeb qaji sisiyeb 5,000. ");
INSERT INTO boj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Awoonabqa Yesus na bem ti qe ti di osiqa Qotei pailyosiqa tamo uŋgasari awoeleŋeb qaji naŋgi jeisi anainjreqnaq uyoqneb. Uynab kalil menetnjrej. ");
INSERT INTO boj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Menetnjrnaqa Yesus na aqa aŋgro naŋgi minjrej, “Niŋgi iŋgi oto kalil koroiyiy. Oto bei urataib.” ");
INSERT INTO boj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Degsi minjrnaqa naŋgi bem 5 aqa oto kalil tamo uŋgasari naŋgi urateleŋeb qaji di koroiyosib gumba kokba 12 di jignab maqeleŋej. ");
INSERT INTO boj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Onaqa tamo uŋgasari kalil naŋgi Yesus aqa maŋwa di unsib maroqneb, “Bole, Qotei aqa medabu o tamo nami Qotei na qariŋyim mandamq aiqajqa marej qaji agi a di.” ");
INSERT INTO boj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Onaqa Yesus a naŋgo anjam di qusiqa endegsi qalieej, “Naŋgi bosib e ojsib e naŋgo Mandor Koba atqajqa are qaleqnub.” A degsi qalieosiq deqa a sawa di uratosiqa a segi manaq oqsiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ariya bilaqtonaqa Yesus aqa aŋgro naŋgi alile aiyeb. ");
INSERT INTO boj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Alile aisib qobuŋ bei gogetosib qobuŋ suweiyosib gileb. Naŋgi mareb, “Iga ya agu taqal beiq gilsim Kaperneam qureq di tiryqom.” Naŋgi degsib marsib gileb. Qoloonaqa Yesus a naŋgoq bosaisoqnej. ");
INSERT INTO boj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Naŋgi ya agu ambleq di gileqnabqa jagwa koba tigelosiqa ya korkortosiqa naŋgi pulutnjrej. ");
INSERT INTO boj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Naŋgi 5 o 6 kilomita oyoosib gileqnabqa Yesus a ya baŋgaq na walwelosiqa naŋgi daurnjrsiq gilej. Gilsiq qobuŋ jojomyonaqa ŋam ateb di a ya baŋgaq na walwelosiq beqnaqa unsib ulakobaeb. ");
INSERT INTO boj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Deqa a na minjrej, “Endi e beqnum. Ulaaib.” ");
INSERT INTO boj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Degsi minjrnaqa naŋgi areboleboleinjrnaqa a metonab qobuŋ gogetej. Onaqa qobuŋ a ururosiq sawa naŋgi gilqajqa mareb qaji di tiryej. ");
INSERT INTO boj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nebeonaqa tamo uŋgasari qudei naŋgi ya agu taqal beiq di soqneb. Naŋgi qalie, ya bilaq qobuŋ qujai segi dia tiryosiq soqnej. Yesus aqa aŋgro naŋgi qobuŋ di gogetosib gileb. Yesus a naŋgi koba na qobuŋ di gogetosai. ");
INSERT INTO boj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ariya tamo uŋgasari naŋgi alile di sonabqa qobuŋ qudei Taiberias qureq dena beb. Bosib sawa Tamo Koba Yesus a pailyosiq naŋgi iŋgi anainjrej qaji sawa jojomq di tiryeb. ");
INSERT INTO boj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesus aqa aŋgro naŋgi ti di sosai. Tamo uŋgasari naŋgi degsi unsibqa qobuŋ di gogetosib gilsib Kaperneam qureq di Yesus qa ŋamoqneb. ");
INSERT INTO boj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ariya naŋgi ya agu taqal beiq di Yesus itosib nenemyeb, “O Qalie Tamo Koba, ni seŋ bati gembu endeq bem?” ");
INSERT INTO boj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. E maŋwa babteqnam niŋgi unoqneb niŋgi deqa are qalsib e qa ŋamosai. E niŋgi bem anaiŋgonam uynab menetŋgej niŋgi deqa are qalsib e qa ŋameqnub. ");
INSERT INTO boj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jejamu qa iŋgi a koboqas. Niŋgi iŋgi deqa wauaib. Ŋambile gaigai sqajqa iŋgi deqa niŋgi wauoqniy. Iŋgi di e na niŋgi anaiŋgit uyqab. E Tamo Aŋgro. Ijo Abu Qotei na e giltbej.” ");
INSERT INTO boj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Onaqa naŋgi na kamba Yesus nenemyeb, “Iga Qotei aqa wau kiye yoqnqom?” ");
INSERT INTO boj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Onaqa Yesus na minjrej, “Qotei aqa wau agi merŋgwai. Niŋgi tamo Qotei na qariŋyej qaji a qa nuŋgo areqalo siŋgilatiy. Tamo di agi e segi.” ");
INSERT INTO boj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Onaqa naŋgi Yesus aqa anjam di qusibqa olo nenemyeb, “Ni maŋwa kiye babtim iga unsim ni qa gago areqalo siŋgilatqom? Nami gago moma naŋgi wadau sawaq di sosibqa bem uyoqneb. Agi Qotei aqa anjam bei endegsi unu, ‘Moses a laŋ qure qa bem tamo uŋgasari naŋgi anainjreqnaq uyoqneb.’ Deqa ni wau kiye yim iga unsim ni qa poigim gago areqalo ni qa siŋgilatqom?” ");
INSERT INTO boj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. Bem Moses na tamo uŋgasari naŋgi anainjrej qaji di laŋ qure qa bem bolesai. Bem Ijo Abu na niŋgi anaiŋgoqnqas qaji di laŋ qure qa bem bole. ");
INSERT INTO boj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bem di Qotei aqa segi bem. Bem di laŋ qureq dena mandamq aisiq tamo uŋgasari mandamq endi unub qaji naŋgi ŋambile enjreqnu.” ");
INSERT INTO boj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Onaqa naŋgi na Yesus minjeb, “O Tamo Koba, bati gaigai bem di anaigoqne.” ");
INSERT INTO boj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Onaqa Yesus na minjrej, “E segi ŋambile qa bem uyo bole. Deqa tamo bei a ijoq bqas di a bunu mamyqasai. Tamo bei a e qa aqa areqalo siŋgilatqas di a bunu ya qaryqasai dego. ");
INSERT INTO boj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Niŋgi nuŋgo ŋamdamu na e nubeqnub. Ariya niŋgi e qa nuŋgo areqalo siŋgilatosaieqnub. E nami degsi merŋgem. ");
INSERT INTO boj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Niŋgi quiy. Tamo uŋgasari kalil Qotei na e ebej qaji naŋgi ijoq boqnqab. Tamo uŋgasari ijoq bqab qaji naŋgi di e na olo winjrqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","E ijo segi areqalo dauryqajqa deqa e laŋ qure uratosim mandamq aiyosai. Abu e qariŋbej qaji aqa areqalo dauryqajqa deqa e laŋ qure uratosim mandamq aiyem. ");
INSERT INTO boj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Abu e qariŋbej qaji aqa areqalo agiende. Tamo uŋgasari a na ebej qaji bei e uratit padalqasai. E naŋgi kalil diŋo bati qa olo subq na tigeltnjrqai. ");
INSERT INTO boj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Od, ijo Abu aqa areqalo agiende. Tamo uŋgasari kalil e nuboqnsib e qa naŋgo areqalo siŋgilateqnub qaji naŋgi ŋambile gaigai sqab. Diŋo bati qa e na naŋgi olo subq na tigeltnjrqai. E Qotei aqa Ŋiri unum deqa e kumbra di yqai.” ");
INSERT INTO boj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Onaqa Juda naŋgi Yesus aqa anjam di qusibqa naŋgi a qa ugeosib yomuoqneb. Di kiyaqa? A marej, “E segi bem bole laŋ qure uratosim mandamq aiyem qaji.” ");
INSERT INTO boj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Naŋgi a qa yomuoqnsib maroqneb, “Tamo di Yesus. A Josep aqa ŋiri. Aqa ai abu naŋgi qa iga qalie bole. A kiyaqa marqo, ‘E laŋ qure uratosim mandamq aiyem’?” ");
INSERT INTO boj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Onaqa Yesus na kamba minjrej, “Niŋgi e qa laŋa laŋa ŋiriŋoqnaib. ");
INSERT INTO boj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tamo bei aqa segi areqalo na ijoq bqa keresai. Ijo Abu e qariŋbej qaji a na tamo bei aqa are tigeltetim ijoq bqas. Yim diŋo bati qa e na olo subq na tigeltqai. ");
INSERT INTO boj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Agi Qotei aqa medabu o qaji tamo naŋgi nami anjam endegsib neŋgreŋyeb, ‘Qotei na tamo kalil naŋgi anjam plaltosim minjroqnqas.’ Anjam degsib neŋgreŋyeb. Deqa tamo kalil ijo Abu aqa anjam quoqnsib a qa poinjreqnu qaji naŋgi ijoq boqnqab. ");
INSERT INTO boj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Tamo bei a ijo Abu aqa ulatamu unosai bole sai. E segi qujai ijo Abu aqa ulatamu unem. Agi e nami Qotei aqaq dena mandamq aiyem. ");
INSERT INTO boj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","E bole merŋgwai. Tamo a e qa aqa areqalo siŋgilatqas di a ŋambile gaigai sqas. ");
INSERT INTO boj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","E segi ŋambile qa bem uyo bole. ");
INSERT INTO boj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nami nuŋgo moma naŋgi wadau sawaq di sosibqa bem uyoqneb. Bunuqna naŋgi kalil moreŋekriteb. ");
INSERT INTO boj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ariya e segi qujai bem bole laŋ qure uratosim mandamq aiyem qaji. Tamo uŋgasari naŋgi bem di uyqab di naŋgi moreŋqasai. ");
INSERT INTO boj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","E segi ŋambile qa bem bole laŋ qure uratosim mandamq aiyem qaji. Tamo bei a bem di uyqas di a ŋambile gaigai sqas. Bem di agi ijo jejamu. E na tamo uŋgasari mandamq endi unub qaji naŋgi ijo jejamu anainjrit uyqab. Uysib naŋgi ŋambile sqab.” ");
INSERT INTO boj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Onaqa Juda naŋgi Yesus aqa anjam di qusib segi segi anjam na qotoqnsib maroqneb, “Tamo di a kiyersim aqa jejamu iga anaigim uyqom?” ");
INSERT INTO boj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. E Tamo Aŋgro. Deqa niŋgi ijo jejamu ti ijo leŋ ti uyqasai di niŋgi ŋambile sqasai. ");
INSERT INTO boj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tamo naŋgi ijo jejamu ti ijo leŋ ti uyqab di naŋgi ŋambile gaigai sqab. Deqa diŋo bati qa e na naŋgi olo subq na tigeltnjrqai. ");
INSERT INTO boj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ijo jejamu di iŋgi uyo bole. Ijo leŋ di ya uyo bole. ");
INSERT INTO boj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tamo naŋgi ijo jejamu ti ijo leŋ ti uyqab di naŋgi e beterbesqab. E dego naŋgi beternjresqai. ");
INSERT INTO boj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ijo Abu ŋambile unu qaji a na e qariŋbej deqa aqa siŋgila na e dego ŋambile unum. Dego kere tamo naŋgi ijo jejamu ti ijo leŋ ti uyqab di naŋgi ijo siŋgila na ŋambile sqab. ");
INSERT INTO boj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","E segi bem bole laŋ qure uratosim mandamq aiyem qaji. Nuŋgo moma naŋgi nami bem uyoqneb dego sai. Naŋgi bem uyoqnsib olo moreŋoqneb. E segi bem uyo bole. Deqa tamo naŋgi bem bole di uyqab di naŋgi moreŋqasai. Naŋgi ŋambile gaigai sqab.” ");
INSERT INTO boj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus a Kaperneam qureq Juda naŋgo Qotei tal miligiq di sosiqa Qotei aqa anjam di palontosiq tamo uŋgasari naŋgi minjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Onaqa tamo uŋgasari Yesus dauryoqneb qaji naŋgi aqa anjam di qusibqa naŋgi gargekoba endegsib maroqneb, “Anjam di gulbe koba. Tamo yai naŋgi anjam di poinjrqa kere?” ");
INSERT INTO boj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Degsib maroqnsib Yesus qa yomueqnabqa di qalieosiqa minjrej, “Ijo anjam dena nuŋgo areqalo ugetetŋgwoqa niŋgi ijo ñam ulontonub e? ");
INSERT INTO boj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","E Tamo Aŋgro. Qure e nami soqnem qaji deq olo oqoqnitqa niŋgi e nubsibqa kiyersib are qalqab? ");
INSERT INTO boj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Qotei aqa Mondor a segi na tamo uŋgasari naŋgi ŋambile enjreqnu. Nuŋgo jejamu na niŋgi aqaryaiŋgwa keresai. Ijo anjam kalil e niŋgi merŋgeqnum qaji endi Mondor aqa anjam. Anjam dena niŋgi ŋambile oqab. ");
INSERT INTO boj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ariya niŋgi qudei e qa nuŋgo areqalo siŋgilatosaieqnub.” Yesus a naŋgi degsi minjrej. Di kiyaqa? Tamo yai naŋgi a qa naŋgo areqalo siŋgilatqasai di a nami qalieej. Bunuqna aqa aŋgro bei na a osim jeu tamo naŋgo baŋq di atqas di dego a nami qalieej. ");
INSERT INTO boj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Osiqa minjrej, “Utru deqa e niŋgi merŋgonum, ‘Qotei na tamo bei aqa are tigeltetqasai di a ijoq bqa keresai.’” ");
INSERT INTO boj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesus a anjam degsi marnaqa tamo uŋgasari gargekoba a nami dauryoqneb qaji naŋgi a dauryqa uratosib jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Onaqa Yesus na aqa aŋgro 12 naŋgi nenemnjrej, “Niŋgi dego e uratbosib jaraiqab e?” ");
INSERT INTO boj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Onaqa Saimon Pita na minjej, “O Tamo Koba, iga ni uratmosim tamo yai aqaq gilqom? Tamo dego bei sosai. Ni segi qujai ŋambile gaigai sqajqa anjam mergeqnum. ");
INSERT INTO boj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iga ni qa gago areqalo siŋgilatosim endegsi qalieonum, Qotei aqa segi Tamo Bole a na nami giltej qaji agi ni qujai.” ");
INSERT INTO boj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Onaqa Yesus na minjrej, “E segi na ijo aŋgro 12 niŋgi giltŋgem. Ariya nuŋgo ambleq di aŋgro bei a mondor uge ti unu.” ");
INSERT INTO boj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesus a Saimon Iskariot aqa ŋiri Judas a qa degsi marej. Yesus aqa aŋgro 12 naŋgi deqaji bei agi Judas. A na bunuqna Yesus osiq jeu tamo naŋgo baŋq di atej qaji. ");
INSERT INTO boj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bati bei Yesus a Judia sawaq di laqajqa uratosiq walwelosiq Galili sawaq di laqnej. Di kiyaqa? Juda tamo kokba naŋgi a qalib moiqajqa maroqneb deqa. ");
INSERT INTO boj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ariya Juda naŋgo yori bati koba jojomej. Yori bati di aqa utru agiende. Juda naŋgo moma naŋgi nami jagwa oqajqa tal gereiyoqnsib osi laqneb. ");
INSERT INTO boj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Deqa Yesus aqa was naŋgi na minjeb, “Ni Galili sawaq endi saim. Ni tigelosim Judia sawaq aiye. Aisim dia ino maŋwa babtoqnimqa ino aŋgro naŋgi unoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni ino maŋwa boleq atqajqa are soqnim ni uli na yaim. Ni tamo uŋgasari kalil naŋgo ŋamdamuq di yoqne.” ");
INSERT INTO boj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesus aqa was naŋgi a qa naŋgo areqalo siŋgilatosai deqa naŋgi degsib misiliŋ anjam minjeb. ");
INSERT INTO boj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Onaqa Yesus na kamba minjrej, “Ijo bati kereosaiunu. Ariya bati kalil di nuŋgo bati. ");
INSERT INTO boj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mandam tamo naŋgi niŋgi jeutŋgwa keresai. Ariya naŋgi e jeutbeqnub. Di kiyaqa? E naŋgo kumbra uge uge babtetnjreqnum deqa. ");
INSERT INTO boj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Niŋgi segi aisib yori bati di uniy. Ijo bati kereosai unu deqa e aiqasai.” ");
INSERT INTO boj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesus na aqa was naŋgi degsi minjrsiqa a Galili sawaq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ariya aqa was naŋgi yori bati di unqajqa ainabqa a dego aiyej. A boleq di aiyosai. Tamo naŋgi a unaib deqa a loumosiq aiyej. ");
INSERT INTO boj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yori bati di brantonaqa Juda tamo kokba naŋgi Yesus qa ŋamoqneb. Ŋamoqnsib maroqneb, “Yesus a qabi unu?” ");
INSERT INTO boj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Onaqa tamo uŋgasari gargekoba naŋgi segi segi ŋiriŋoqnsib anjam laŋa laŋa Yesus qa maroqneb. Qudei naŋgi maroqneb, “Yesus a tamo bolequja.” Qudei naŋgi maroqneb, “Sai. A na tamo uŋgasari naŋgi gisa gisaŋnjreqnu.” ");
INSERT INTO boj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Naŋgi degsib maroqneb. Ariya naŋgi Juda tamo kokba naŋgi ulainjrsib deqa naŋgi Yesus qa boleq di anjam marosaioqneb. ");
INSERT INTO boj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ariya yori bati gilsiq ambleqyonaqa Yesus a segi brantosiqa atra tal miligiq gilsiq dia tamo uŋgasari naŋgi Qotei aqa anjam palontosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Onaqa Juda tamo kokba naŋgi Yesus aqa anjam di qusibqa naŋgi tulaŋ prugugetosib segi segi maroqneb, “Yesus aqa powo kobaquja di qabe na osiqa anjam mareqnu? A nami skul beiq gilosai.” ");
INSERT INTO boj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Onaqa Yesus na kamba minjrej, “Anjam e mareqnum endi ijo anjam sai. Anjam endi ijo Abu e qariŋbej qaji aqa anjam. ");
INSERT INTO boj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tamo bei a Qotei aqa areqalo dauryqajqa are soqnimqa anjam e mareqnum qaji endi aqa utru a geregere poiyqas. Osim qalieqas, ijo anjam endi Qotei aqaq na bej. E ijo segi areqalo na marosaieqnum. A degsim qalieqas. ");
INSERT INTO boj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tamo bei aqa segi areqalo na anjam marqas di a aqa segi ñam soqtqa osim deqa anjam marqas. Ariya e Qotei aqa ñam soqtqa are qaleqnum. Agi a na e qariŋbej. Deqa e tamo bole. E gisaŋ tamo sai. ");
INSERT INTO boj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Nami Moses na niŋgi dal anjam eŋgej. Ariya niŋgi dal anjam di dauryosaieqnub. Kiyaqa niŋgi e lubsib moiyotbqa mareqnub?” ");
INSERT INTO boj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Onaqa tamo uŋgasari naŋgi na kamba Yesus minjeb, “Mondor uge inoq di unu. Yai na ni lumsim moiyotmqa mareqnu?” ");
INSERT INTO boj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Onaqa Yesus na kamba minjrej, “E maŋwa qujai babtem deqa niŋgi kalil prugugeteqnub. ");
INSERT INTO boj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ariya niŋgi are qaliy. Moses a niŋgi muluŋ eŋgej deqa nuŋgo aŋgro mel naŋgo muluŋ waiyqa bati bosiq yori bati tiŋtiŋeqnu di niŋgi yori bati qa naŋgi muluŋ breinjreqnub. Bole, Moses a muluŋ qa utru sai. Nuŋgo moma naŋgi muluŋ qa utru. ");
INSERT INTO boj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Niŋgi Moses aqa dal anjam dauryqa maroqnsib yori bati qa nuŋgo aŋgro mel naŋgi muluŋ breinjreqnub. Ariya e yori bati qa tamo qujai aqa jejamu boletonamqa niŋgi unsibqa kiyaqa e qa ŋiriŋeqnub? ");
INSERT INTO boj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Niŋgi laŋa ŋamdamu na ijo kumbra tenemtaib. Geregere ijo kumbra tenemtosib bole qa maroqniy.” ");
INSERT INTO boj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bati deqa tamo uŋgasari qudei Jerusalem di soqneb qaji naŋgi segi segi endegsib maroqneb, “Yesus a kiyo Juda gate naŋgi na qalib moiqajqa laqnub? ");
INSERT INTO boj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Niŋgi uniy. A boleq di anjam palonteqnaqa naŋgi a anjam bei minjosaieqnub. Naŋgi qalie kiyo, a Kristus? ");
INSERT INTO boj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kristus a qabe na bqas di tamo bei a qalieqasai. Ariya tamo endi aqa qure utru di iga qalie bole.” ");
INSERT INTO boj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Onaqa Yesus a atra tal miligiq di sosiqa a leleŋosiqa Qotei aqa anjam palontosiq tamo uŋgasari naŋgi endegsi minjrej, “Niŋgi e qa qalie e? E qabe na bem di dego niŋgi qalie e? Ariya e ijo segi areqalo na bosai. Ijo Abu na e qariŋbonaq bem. Ijo Abu a segi anjam bole qa utru. Niŋgi a qa qaliesai. ");
INSERT INTO boj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","E a qa qalie bole. E aqaq na bem. A na e qariŋbej.” ");
INSERT INTO boj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Onaqa Juda tamo kokba naŋgi Yesus aqa anjam di qusibqa naŋgi a ojsib tonto talq di waiyqa maroqneb. Ariya a ojqa bati kereosaisoqnej deqa tamo bei na a ojosai. ");
INSERT INTO boj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bati deqa tamo uŋgasari gargekoba naŋgi Yesus qa naŋgo areqalo siŋgilatoqneb. Osib maroqneb, “Tamo endi a maŋwa gargekoba babteqnu. Kristus a bosim tamo endi buŋyqa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tamo uŋgasari naŋgi Yesus qa anjam degsib mareqnab Farisi naŋgi qusibqa atra tamo kokba ti koroosib qaja tamo qudei qariŋnjrnab Yesus ojqa gileb. ");
INSERT INTO boj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Deqa Yesus a endegsi marej, “E niŋgi koba na sokiñalayosiy ijo Abu e qariŋbej qaji aqaq olo oqwai. ");
INSERT INTO boj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Oqitqa niŋgi e qa ŋamqab e nubqasai. Qure e sqai di niŋgi oqwa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Onaqa Juda tamo kokba naŋgi segi segi maroqneb, “Yesus a qabitimqa iga a unqasai? A Grik naŋgo sawaq oqsim dia Juda tamo qudei ti sosib Grik naŋgi anjam plaltosim minjroqnqas kiyo? ");
INSERT INTO boj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A marqo, ‘Niŋgi e qa ŋamqab di niŋgi e nubqasai. Qure e sqai di niŋgi oqwa keresai.’ Utru kiyaqa a degsi marqo?” ");
INSERT INTO boj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ariya yori bati gilsiq koboqa laqnaqa yori kobaquja brantonaqa Yesus a tigelosiqa leleŋosiq marej, “Tamo bei a ya qaryimqa ijoq bosim ya uyem. ");
INSERT INTO boj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tamo bei a e qa aqa areqalo siŋgilatqas di aqa are miligiq na ŋambile gaigai sqajqa ya oqoqnsim ya ani bul polyoqnqas. Nami Qotei aqa anjam degsib neŋgreŋyeb unu.” ");
INSERT INTO boj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus a ya qa marej di a Mondor Bole sigitosiqa yawo anjam marej. A laŋ qureq oqosaisosiq deqa a ñam koba osaisoqnej. Deqa bati di tamo naŋgi a qa naŋgo areqalo siŋgilateb qaji naŋgi Mondor Bole di osaisoqneb. ");
INSERT INTO boj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Onaqa tamo uŋgasari qudei naŋgi Yesus aqa anjam di qusib maroqneb, “Bole, Qotei aqa medabu o tamo nami Qotei na qariŋyim bqajqa marej qaji agi a endi.” ");
INSERT INTO boj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Onaqa qudei maroqneb, “Tamo endi a bole Kristus.” Onaqa qudei maroqneb, “Sai. Kristus a bqas di a Galili sawaq dena bqasai. ");
INSERT INTO boj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kristus a Devit aqa leŋ na ŋambabosim aqa qure utru Betlehem dena bqas. Nami Qotei aqa anjam degsib neŋgreŋyeb unu.” ");
INSERT INTO boj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tamo uŋgasari naŋgi degsib Yesus qa anjam tititosib ŋiriŋosib poaiyeleb. ");
INSERT INTO boj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Osib naŋgi qudei Yesus ojqa mareb. Mareb di tamo bei na a ojosai. ");
INSERT INTO boj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Onaqa qaja tamo naŋgi olo puluosib atra tamo kokba ti Farisi ti naŋgoq ainabqa minjreb, “Niŋgi kiyaqa Yesus ojsib osi bosai?” ");
INSERT INTO boj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Onaqa qaja tamo naŋgi na kamba minjreb, “Iga Yesus aqa anjam quonum di anjam bolequja maroqnaj. Tamo bei nami anjam deqaji marosaioqnej. Deqa iga a ojosai.” ");
INSERT INTO boj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Onaqa Farisi naŋgi na minjreb, “Yesus a niŋgi dego gisaŋgwo e? ");
INSERT INTO boj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Niŋgi uniy. Juda gate bei Yesus qa aqa areqalo siŋgilatosai. Farisi tamo bei dego Yesus qa aqa areqalo siŋgilatosai. Sai bole sai. ");
INSERT INTO boj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ariya tamo uŋgasari laŋa laŋaj naŋgi dal anjam qaliesai deqa naŋgi Yesus qa naŋgo areqalo siŋgilateqnub. Tamo uŋgasari naŋgi di Qotei na torei qoreinjrim padalqab.” ");
INSERT INTO boj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Onaqa Juda gate Nikodemus agi nami Yesus aqaq gilsiq anjam minjej qaji a Farisi naŋgo ambleq di tigelosiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gago dal anjam kiyersi unu? Iga tamo bei laŋa ojsim aqa une qa pegiyqom e? Sai. Gago dal anjam degsi sosai. Iga mati aqa anjam qusim aqa kumbra geregere qalieqom.” ");
INSERT INTO boj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Onaqa Farisi naŋgi na kamba minjeb, “Ni dego Galili qaji tamo kiyo? Qotei aqa anjam neŋgreŋq di unu qaji di geregere peleiye. Peleiyim endegsi poimqas, Qotei aqa medabu o qaji tamo bei a Galili sawaq dena bqasai.” ");
INSERT INTO boj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Onaqa koro koboonaqa tamo uŋgasari kalil naŋgi jaraiyosibqa naŋgo segi segi talq gileleŋeb. ");
INSERT INTO boj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ariya Yesus a Oliv manaq oqej. ");
INSERT INTO boj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nobqolo ambru a olo tigelosiqa atra tal miligiq gilej. Gilsiq di sonaqa tamo uŋgasari kalil naŋgi aqa areq beqnabqa a awoosiqa Qotei aqa anjam palontosiq minjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ariya uŋa bei a tamo bei wo une ateqnab tamo qudei na uneb. Unsibqa dal anjam qalie tamo naŋgi ti Farisi naŋgi ti minjrnab qusibqa uŋa di ojsib osi bosib tamo uŋgasari naŋgo ŋamdamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Osib Yesus minjeb, “O Qalie Tamo Koba, uŋa endi a tamo bei wo une ateqnab tamo qudei na unjronub. ");
INSERT INTO boj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ni qalie, Moses a nami dal anjam endegsi neŋgreŋyej, ‘Uŋa bei a tamo bei wo une atibqa meniŋ na a qalib moiyem.’ Deqa ni kiyersi marqam?” ");
INSERT INTO boj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Naŋgi Yesus degsib nenemyeb. Di kiyaqa? Naŋgi a laŋa are qametib a anjam bei grotimqa qusib a ojqajqa deqa. Onaqa Yesus a kamba naŋgi anjam bei minjrosai. A mana qamsiq turuosiqa baŋ gei na mandamq di neŋgreŋyoqnej. ");
INSERT INTO boj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Onaqa naŋgi na olo anjam di Yesus nenemyonabqa a tigelosiqa minjrej, “Nuŋgo ambleq di tamo bei une saiqoji unu kiyo? Soqnimqa niŋgi na minjib a namo meniŋ osim uŋa di qalem.” ");
INSERT INTO boj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Osiqa olo turuosiqa mandamq di neŋgreŋyoqnej. ");
INSERT INTO boj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Onaqa naŋgi Yesus aqa anjam di qusibqa segi segi oqedosib jaraiyeb. Tamo qeli naŋgi namoosib jaraiyonab qudei bunueb. Osib naŋgi kalil Yesus uratonab a segi soqnej. Uŋa di a Yesus aqa ulatamuq di tigelesoqnej. ");
INSERT INTO boj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Onaqa Yesus a olo tigelosiqa uŋa di minjej, “Uŋa, tamo naŋgi qabitonub? Ni unime. Tamo bei na ino une qa olo ni mermosai.” ");
INSERT INTO boj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Onaqa uŋa dena Yesus minjej, “Od, Tamo Koba, tamo bei na ijo une qa olo merbosai.” Onaqa Yesus na minjej, “E dego ino une qa mermqasai. Deqa ni gile. Olo une bei ataim.” ");
INSERT INTO boj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Osiqa Yesus na tamo uŋgasari naŋgi olo endegsi minjrej, “E mandamq endi puloŋ bul unum. Tamo a e daurbqas di a ambruq di walwelqasai. A suwaŋoq di walweloqnsim ŋambile gaigai sqas.” ");
INSERT INTO boj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Onaqa Farisi naŋgi Yesus aqa anjam di qusib minjeb, “Ni segi ino kumbra ti ino wau ti ubtosim mareqnum. Deqa iga bole qa marqasai.” ");
INSERT INTO boj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Onaqa Yesus na kamba minjrej, “E segi ijo kumbra ti ijo wau ti ubtosiy marqai di niŋgi bole qa marqa kere. Di kiyaqa? E qabe na bem di e segi qalie bole. E puluosiy olo qabitqai di dego e qalie. Ariya e qabe na bem di niŋgi qaliesai. E puluosiy olo qabitqai di dego niŋgi qaliesai. ");
INSERT INTO boj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niŋgi mandam qa kumbra na tamo naŋgi peginjreqnub. E tamo naŋgi peginjrosaieqnum. ");
INSERT INTO boj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ariya e tamo naŋgi peginjrqai di e kumbra tiŋtiŋ na peginjrqai. Di kiyaqa? E segi na tamo naŋgi peginjrosaieqnum. Ijo Abu e qariŋbej qaji a ombla na tamo naŋgi peginjreqnum. ");
INSERT INTO boj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nuŋgo dal anjam bei endegsib neŋgreŋyeb unu, ‘Tamo aiyel naŋgi anjam qujai marqab di naŋgo anjam bole brantqas.’ ");
INSERT INTO boj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Deqa e segi ijo kumbra ti ijo wau ti ubtosim mareqnum. Ijo Abu e qariŋbej qaji a dego e ombla ijo kumbra ti ijo wau ti ubtosim mareqnum.” ");
INSERT INTO boj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Onaqa Farisi naŋgi na Yesus nenemyeb, “Ino Abu a qabi unu?” Onaqa Yesus na kamba minjrej, “Niŋgi e qa qaliesai deqa niŋgi ijo Abu qa dego qaliesai. Niŋgi e qa qalie qamu niŋgi ijo Abu qa dego qalie qamu.” ");
INSERT INTO boj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus a atra tal miligiq di sosiqa anjam degsi plaltosiq marej. A silali ato qaji warum jojomq di awesoqnej. Warum dia tamo naŋgi Qotei atraiyoqnsibqa silali atoqneb. Yesus ojqa bati kereosaisoqnej deqa tamo bei na a ojosai. ");
INSERT INTO boj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Onaqa Yesus na tamo uŋgasari naŋgi olo endegsi minjrej, “E niŋgi uratŋgitqa niŋgi e qa ŋamqab e nubqasai. Niŋgi nuŋgo une ti sosib moreŋqab. Qure e oqwai di niŋgi oqwa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Onaqa Juda naŋgi Yesus aqa anjam di qusibqa segi segi endegsib maroqneb, “Yesus a kiyaqa marqo, ‘Qure e oqwai di niŋgi oqwa keresai’? A na aqa segi jejamu qalim moiqas kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Onaqa Yesus na olo minjrej, “Niŋgi mandam endena branteb. E laŋ goge na bem. Niŋgi mandam qaji tamo. E mandam qaji tamo sai. ");
INSERT INTO boj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Deqa niŋgi e qa nuŋgo areqalo siŋgilatiy. Osib poiŋgem, e segi qujai gaigai degsi unum. Niŋgi degyqasai di niŋgi nuŋgo une ti sosib moreŋqab. Agi e nami niŋgi degsi merŋgonum.” ");
INSERT INTO boj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Onaqa naŋgi na Yesus nenemyeb, “Ni tamo yai?” Onaqa Yesus na minjrej, “E nami ijo kumbra ti ijo wau ti ubtosim merŋgoqnsim agi bini merŋgeqnum. ");
INSERT INTO boj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E anjam gargekoba merŋgsiy nuŋgo une qa pegiŋgwajqa ijo areqaloq di unu. Ariya ijo Abu e qariŋbej qaji a anjam bole qa utru. Deqa anjam kalil a na merbeqnu qaji di e quoqnsim tamo uŋgasari mandamq endi unub qaji naŋgi minjreqnum.” Yesus a naŋgi degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Juda naŋgi qaliesai, Yesus a Abu qa naŋgi minjrej. ");
INSERT INTO boj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Deqa a na olo minjrej, “Niŋgi e Tamo Aŋgro soqtbosib gaintbibqa bati deqa niŋgi poiŋgwas, e segi qujai gaigai degsi unum. Osib qalieqab, e ijo segi areqalo na kumbra bei yosaieqnum. Anjam kalil ijo Abu na merbeqnaq queqnum qaji di segi e mareqnum. ");
INSERT INTO boj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ijo Abu e qariŋbej qaji a e ombla sosiqa taqbejunu. E gaigai kumbra kalil a tulaŋ areareteqnu qaji di dauryeqnum. Deqa a na e uratbosaieqnu.” ");
INSERT INTO boj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus a anjam degsi marnaqa tamo uŋgasari naŋgi qusibqa naŋgi gargekoba a qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Juda naŋgi Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi a na endegsi minjrej, “Niŋgi ijo anjam siŋgila na dauryoqniy. Niŋgi degyqab di niŋgi ijo aŋgro tiŋtiŋ sqab. ");
INSERT INTO boj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sosibqa niŋgi anjam bole geregere qalieqab. Yimqa anjam bole dena niŋgi aqaryaiŋgimqa iŋgi bei na niŋgi ojsim taqatŋgwa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Onaqa naŋgi na kamba minjeb, “Iga Abraham aqa moma. Iga nami tamo bei aqa kaŋgal tamo sosai. Deqa ni kiyaqa mergonum, ‘Iŋgi bei na niŋgi ojsim taqatŋgwa keresai’?” ");
INSERT INTO boj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. Tamo kalil une yeqnub qaji naŋgi une aqa kaŋgal tamo bul unub. ");
INSERT INTO boj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kaŋgal tamo naŋgi laŋa wau tamo unub deqa naŋgi abu saiqoji. Ariya aŋgro naŋgi abu ti unub deqa naŋgi gaigai naŋgo abu ombla sqab. ");
INSERT INTO boj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","E Qotei aqa Ŋiri deqa e Abu ti unum. Deqa e na niŋgi aqaryaiŋgitqa nuŋgo une na niŋgi ojsim taqatŋgwa keresai bole sai. ");
INSERT INTO boj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“E qalie, niŋgi Abraham aqa moma unub. Ariya ijo anjam nuŋgo are miligiq di sosai. Utru deqa niŋgi e lubsib moiyotbqa mareqnub. ");
INSERT INTO boj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kumbra kalil ijo Abu na e osorbeqnu qaji deqa e saeqnum. Niŋgi dego kumbra kalil nuŋgo abu na osorŋgeqnu qaji di dauryeqnub.” ");
INSERT INTO boj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Onaqa Juda naŋgi Yesus aqa anjam di qusibqa olo kamba minjeb, “Gago abu bole agi Abraham.” Onaqa Yesus na minjrej, “Niŋgi Abraham aqa aŋgro unub qamu kumbra Abraham a yoqnej qaji di niŋgi dego dauryeqnub qamu. ");
INSERT INTO boj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ariya niŋgi dauryosaieqnub. Anjam bole kalil Qotei na e merbeqnaq queqnum qaji di e niŋgi olo merŋgeqnam niŋgi e lubsib moiyotbqa mareqnub. Abraham a kumbra deqaji yosaioqnej. ");
INSERT INTO boj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Niŋgi nuŋgo abu aqa kumbra dauryeqnub.” Onaqa naŋgi na minjeb, “Gago ai naŋgi laŋa laŋa laosib iga ŋambabtgosai. Gago Abu qujai agi Qotei.” ");
INSERT INTO boj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Onaqa Yesus na minjrej, “Qotei a nuŋgo Abu qamu niŋgi e qalaqalaibonub qamu. Di kiyaqa? E Qotei aqaq na bem deqa. E ijo segi areqalo na bosai. Qotei na e qariŋbonaq bem. ");
INSERT INTO boj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Kiyaqa niŋgi ijo anjam endi poiŋgosai? E merŋgwai. Niŋgi ijo anjam quqwa keresai deqa. ");
INSERT INTO boj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Niŋgi nuŋgo abu Satan aqa aŋgro sosib aqa areqalo dauryqajqa tulaŋ siŋgilaeqnub. Satan a nami leŋ ojo tamo soqnej agi a bini degsi unu. A kumbra bole dauryosaieqnu. A kumbra bole dauryqajqa torei urateqnu. A gisaŋ tamo. A anjam marqas di a gisaŋ anjam segi marqas. A gisaŋ anjam qa utru. A gisaŋ anjam kalil qa abu. ");
INSERT INTO boj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ariya e anjam bole palonteqnam niŋgi ijo anjam nuŋgo areqaloq di siŋgilatosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Niŋgi ijo jejamuq di une qametbeqnub e? E anjam bole maritqa niŋgi kiyaqa ijo anjam nuŋgo areqaloq di siŋgilatqasai? ");
INSERT INTO boj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tamo uŋgasari Qotei aqaq na beb qaji naŋgi aqa anjam queqnub. Niŋgi Qotei aqaq na bosai deqa niŋgi aqa anjam quosaieqnub.” ");
INSERT INTO boj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Onaqa Juda naŋgi Yesus aqa anjam di qusibqa minjeb, “Iga bole maronum, ni Samaria qaji tamo. Mondor uge inoq di unu.” ");
INSERT INTO boj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Onaqa Yesus na kamba minjrej, “Mondor uge ijoq di sosai. E ijo Abu aqa ñam soqteqnam niŋgi na olo ijo ñam ugetetbeqnub. ");
INSERT INTO boj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","E ijo segi ñam soqtqa are qalosaieqnum. Ijo Abu a segi na ijo ñam soqtetbqa are qaleqnu. Agi a na qujai nuŋgo une qa niŋgi pegiŋgeqnu. ");
INSERT INTO boj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","E bole merŋgwai. Tamo bei na ijo anjam qusim dauryqas di a moiqa keresai. Sai bole sai.” ");
INSERT INTO boj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Onaqa Juda naŋgi na minjeb, “Endego iga qalieonum, mondor uge inoq di unu. Abraham a moiyej. Qotei aqa medabu o qaji tamo kalil naŋgi dego moreŋekriteb. Ariya ni maronum, ‘Tamo bei na ijo anjam qusim dauryqas di a moiqa keresai.’ ");
INSERT INTO boj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ni gago moma utru Abraham buŋyqam kiyo? A moiyej. Qotei aqa medabu o qaji tamo kalil naŋgi dego moreŋeb. Deqa ni segi qa kiyersi marqam?” ");
INSERT INTO boj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Onaqa Yesus na kamba minjrej, “E ijo segi ñam soqteqnum qamu e laŋa soqteqnum qamu. Ariya ijo Abu na ijo ñam soqtetbeqnu. Agi niŋgi a qa mareqnub, ‘A gago Qotei.’ ");
INSERT INTO boj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niŋgi a qa qaliesai. E segi a qa qalie. E a qa qaliesai degsi marqai di e niŋgi bul gisaŋ tamo sqai. E a qa qalieosim deqa agi aqa anjam dauryeqnum. ");
INSERT INTO boj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Nuŋgo moma utru Abraham a nami ijo bqajqa bati unqa marsiqa areboleboleiyonaq soqnej. A unsiqa tulaŋ areboleboleiyej.” ");
INSERT INTO boj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Onaqa Juda naŋgi Yesus aqa anjam di qusibqa minjeb, “Ino wausau 50 osaiunu. Ni Abraham unem e?” ");
INSERT INTO boj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Onaqa Yesus na kamba minjrej, “E bole merŋgwai. Abraham a ŋambabosaisonaqa e segi qujai gaigai degsi unum.” ");
INSERT INTO boj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Onaqa naŋgi Yesus aqa anjam di qusibqa minjiŋ oqetnjrnaqa meniŋ eleŋosib Yesus meniŋ na qalsib moiyotqa yonab a loumosiq atra tal uratosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus a walwelosiq gilsiq gam qalaq di tamo bei ai miligiq na ŋam qandimo ŋambabej qaji di awesonaq unej. ");
INSERT INTO boj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Onaqa Yesus aqa aŋgro naŋgi na nenemyeb, “O Qalie Tamo Koba, yai aqa une na tamo di a ŋam qandimo ŋambabej? Aqa segi une na kiyo aqa ai abu naŋgo une na kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Onaqa Yesus na kamba minjrej, “Tamo di aqa une na sai. Aqa ai abu naŋgo une na sai dego. A ŋam qandimo ŋambabej di aqa utru agiende. Qotei na a boletimqa tamo uŋgasari naŋgi Qotei aqa wau unsib aqa ñam soqtqab. ");
INSERT INTO boj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sawa suwaŋesoqnimqa ijo Abu e qariŋbej qaji aqa wau yoqnqom. Ambruamqa tamo naŋgi wauqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E mandamq endi sosimqa e mandam endeqa puloŋ bul unum.” ");
INSERT INTO boj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesus na aqa aŋgro naŋgi degsi minjrsiqa mandamq di miselosiq aqa misel mandam ti ojnaq jagi bulonaq osiqa tamo di aqa ŋamdamuq di atej. ");
INSERT INTO boj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Atsiqa qariŋyosiq minjej, “Ni gilsim ya bei ñam Siloam di yal.” “Siloam” di Hibru anjam. Aqa damu, “Qariŋyqo.” Onaqa tamo di a gilsiq yalonaqa ŋam poiyonaqa sawa unej. Sawa unsiqa olo puluosi bej. ");
INSERT INTO boj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bonaqa aqa qure qujai naŋgi ti tamo naŋgi a nami ŋam qandimo sosiqa silali qa ŋilnjroqnej qaji naŋgi ti a unsibqa mareb, “Tamo nami silali qa ŋilgoqnej qaji agiende kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Onaqa tamo qudei naŋgi mareb, “Od, agi a qujai.” Onaqa tamo qudei naŋgi mareb, “A sai. Endi tamo bei. Aqa ulatamu tamo ŋam qandimo aqa ulatamu bul.” Onaqa a segi na minjrej, “Agi e segi.” ");
INSERT INTO boj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Onaqa tamo uŋgasari naŋgi na nenemyeb, “Ni ŋamdamu kiyersi poimqoqa sawa unonum?” ");
INSERT INTO boj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Onaqa a na kamba minjrej, “Tamo bei aqa ñam Yesus a na jagi gereiyosiq ijo ŋamdamuq di atsiqa merbqo, ‘Ni gilsim Siloam yaq di yal.’ Degsi merbqoqa e gilsim yalonumqa ŋam poibqoqa sawa unonum.” ");
INSERT INTO boj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Onaqa tamo uŋgasari naŋgi na olo nenemyeb, “Tamo ni boletmqo qaji a qabi unu?” Onaqa a na minjrej, “A qabitqo kiyo di e qaliesai.” ");
INSERT INTO boj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Onaqa tamo uŋgasari naŋgi na tamo nami ŋam qandimyesoqnej qaji di osib Farisi naŋgoq osi gileb. ");
INSERT INTO boj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bati Yesus na jagi gereiyosiq tamo di boletej di Juda naŋgo yori bati. ");
INSERT INTO boj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Deqa Farisi naŋgi na tamo di endegsib nenemyeb, “Ni ŋamdamu kiyersi poimqoqa sawa unonum?” Onaqa a na minjrej, “Tamo bei aqa ñam Yesus a jagi misel ti bulyosiq ijo ŋamdamuq di atqoqa e yalonum ŋam poibqoqa sawa unonum.” ");
INSERT INTO boj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Onaqa Farisi qudei naŋgi mareb, “Yesus a yori bati grotqo deqa iga qalieonum, Qotei na a qariŋyosai.” Ariya Farisi qudei naŋgi mareb, “Sai. Une tamo a kiyersim maŋwa deqaji babtqas?” Farisi naŋgi anjam deqa ŋiriŋosib poaiyeleb. ");
INSERT INTO boj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Onaqa naŋgi na tamo di olo nenemyeb, “Yesus a ino ŋamdamu boletqo deqa ni a qa kiyersi are qalonum?” Onaqa a na minjrej, “E are qalonum, a Qotei aqa medabu o qaji tamo bole.” ");
INSERT INTO boj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tamo di a nami ŋam qandimo sosiqa olo ŋam poiyej deqa Juda tamo kokba naŋgi areqalo kobaiyeb. Osib aqa ai abu naŋgi metnjrnab beb. ");
INSERT INTO boj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bonabqa endegsib nenemnjreb, “Tamo endi nuŋgo aŋgro e? A bole ŋam qandimo ŋambabej e? Boleamqa niŋgi na mergibqa iga quqwom. A kiyersi bini ŋam poiyqoqa sawa uneqnu?” ");
INSERT INTO boj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Onaqa aqa ai abu naŋgi na kamba minjreb, “Di bole, a gago aŋgro. A ŋam qandimo ŋambabej di iga qalie. ");
INSERT INTO boj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ariya a kiyersi bini ŋam poiyqoqa sawa uneqnu di iga qaliesai. Tamo yai na aqa ŋamdamu boletqo di dego iga qaliesai. A tamo boleqo. A segi nenemyibqa a segi na marqas.” ");
INSERT INTO boj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aqa ai abu naŋgi Juda tamo kokba naŋgi ulainjrsib deqa anjam degsib minjreb. Juda tamo kokba naŋgi nami maroqneb, “Tamo bei a marqas, ‘Yesus a bole Kristus,’ degsi marimqa tamo di iga taqal waiyonam a bunu olo Qotei tal miligiq gilqasai.” ");
INSERT INTO boj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Deqa naŋgi aiyel Juda tamo kokba naŋgi ulainjrsib minjreb, “A tamo boleqo. A segi nenemyiy.” ");
INSERT INTO boj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Onaqa tamo nami ŋam qandimyesoqnej qaji di Farisi naŋgi na olo metonab bonaq minjeb, “Ni Qotei aqa ñam soqtosim anjam bole merge. Iga qalieonum, Yesus a une tamo. Ni degsi merge.” ");
INSERT INTO boj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Onaqa a na kamba minjrej, “A une tamo kiyo sai kiyo di e qaliesai. Ariya e nami ŋam qandimo soqnem bini e olo ŋam poibqoqa sawa uneqnum di e qalieonum.” ");
INSERT INTO boj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Onaqa naŋgi na olo nenemyeb, “Yesus a ni kiyermqo? A kiyersi ino ŋamdamu boletqoqa ni sawa uneqnum?” ");
INSERT INTO boj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Onaqa a na kamba minjrej, “E nami merŋgonum niŋgi ijo anjam quetbosai. Kiyaqa ololo merŋgit quqwab? Niŋgi dego Yesus aqa aŋgro sqajqa are unu e?” ");
INSERT INTO boj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Onaqa Farisi naŋgi na tamo di misiliŋyosib minjeb, “Ni Yesus aqa aŋgro. Iga Moses aqa aŋgro. ");
INSERT INTO boj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Iga qalie, Qotei a bole Moses anjam minjoqnej. Ariya Yesus a qabe na kiyo bej di iga qaliesai.” ");
INSERT INTO boj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Onaqa tamo dena kamba minjrej, “E nuŋgo anjam di quonum ugeibqo. Niŋgi mareqnub, ‘Yesus a qabe na kiyo bej di iga qaliesai.’ Ariya Yesus a ijo ŋamdamu boletqoqa e sawa uneqnum. ");
INSERT INTO boj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Iga qalie, tamo naŋgi une ateqnub qaji naŋgi Qotei pailyqab di a naŋgo pailyo quqwasai. Ariya tamo naŋgi Qotei qa ulaoqnsib aqa areqalo dauryeqnub qaji naŋgi pailyqab di a naŋgo pailyo quqwas. ");
INSERT INTO boj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tamo ai miligiq na ŋam qandimo ŋambabo qaji di tamo bei na nami boletonaq iga quosaioqnem. ");
INSERT INTO boj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Qotei na Yesus qariŋyosai qamu a maŋwa bei babtqa keresai qamu.” ");
INSERT INTO boj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Onaqa Farisi naŋgi na kamba minjeb, “Une aqa kumbra inoq di beterejunu. Ni une ti sosim ŋambabem agi bini ni degsi unum. Deqa ni Qotei aqa anjam iga mergaim.” Degsib minjsib a taqal waiyosib a olo Qotei tal miligiq gilqajqa saidyeb. ");
INSERT INTO boj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Farisi naŋgi na tamo di taqal waiyonab Yesus a di qusiqa a qa ŋamosiq itosiq nenemyej, “Ni Tamo Aŋgro qa ino areqalo siŋgilatonum e?” ");
INSERT INTO boj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Onaqa a na kamba Yesus minjej, “O Tamo Koba, Tamo Aŋgro di yai? Ni merbimqa e qusiy ijo areqalo a qa siŋgilatqai.” ");
INSERT INTO boj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Onaqa Yesus na minjej, “Ni na Tamo Aŋgro agi itonum. Endego aqo ombla anjam mareqnum.” ");
INSERT INTO boj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Onaqa a na Yesus minjej, “Od, Tamo Koba, e ni qa ijo areqalo siŋgilatonum.” A degsi Yesus minjsiqa aqa areq di siŋga pulutosiqa a biŋiyej. ");
INSERT INTO boj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Onaqa Yesus a marej, “E tamo uŋgasari naŋgi peginjrqajqa deqa mandamq aiyem. Deqa tamo ŋam qandimo unub qaji naŋgi olo ŋamdamu bole atoqnqab. Tamo ŋamdamu bole ateqnub qaji naŋgi olo ŋam qandimnjresqas.” ");
INSERT INTO boj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Onaqa Farisi qudei Yesus aqa jojomq di tigelesoqneb qaji naŋgi aqa anjam di qusib nenemyeb, “Iga dego ŋam qandimgejunu kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Onaqa Yesus na kamba minjrej, “Niŋgi ŋam qandimŋgejunu qamu niŋgi une saiqoji unub qamu. Ariya niŋgi mareqnub, ‘Iga ŋamdamu bole ateqnum.’ Dego di niŋgi une ti unub.” ");
INSERT INTO boj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Osiqa Yesus a olo marej, “E bole merŋgwai. Tamo bei a kaja naŋgo jeŋ miligiq gilqa osimqa a siraŋmeq na gilqa uratosim qalaq na jeŋ prugosim miligiq gilqas di a bajiŋ tamo. ");
INSERT INTO boj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tamo a siraŋmeq na jeŋ miligiq gilqas di a kaja naŋgo mandor bole. ");
INSERT INTO boj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Deqa siraŋme taqato tamo na siraŋ waqtetoqnim miligiq giloqnsim aqa segi kaja naŋgo ñam metnjroqnqas. Metnjroqnim naŋgi aqa kakro qusib boqnib joqsim oqedoqnqas. ");
INSERT INTO boj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A na aqa segi kaja kalil naŋgi joqsim oqedoqnsim a naŋgi qa namoosim giloqnimqa naŋgi aqa kakro qa poinjrim deqa naŋgi a dauryoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tamo laŋaj bei na naŋgi metnjrqas di naŋgi aqa kakro qalieqasai deqa naŋgi a dauryqasai. Naŋgi a uratosib jaraiqab.” ");
INSERT INTO boj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus na yawo anjam degsi minjrnaqa naŋgi qusib utru poinjrosai. ");
INSERT INTO boj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Deqa Yesus a damu ubtosiqa endegsi minjrej, “E bole merŋgwai. Kaja naŋgi di ijo segi tamo uŋgasari naŋgi sigitnjrejunub. Jeŋ miligiq gilqajqa siraŋme agi e segi. ");
INSERT INTO boj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Anjam plalto tamo kalil e bosaisonam nami beb qaji naŋgi bajiŋ tamo bul. Deqa kaja naŋgi naŋgo medabu dauryosaioqneb. ");
INSERT INTO boj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","E segi siraŋme. Tamo uŋgasari naŋgi ijoq na jeŋ miligiq giloqnqab di Qotei na naŋgi eleŋqas. Amqa naŋgi miligiq gile oqede oqnsib iŋgi bole uyoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Niŋgi qalie, bajiŋ tamo naŋgi kaja bajiŋosib ugeugeinjrsib ñumqajqa deqa beqnub. Ariya e degyqa bosai. E na kaja naŋgi ŋambile enjritqa naŋgi ŋambile tulaŋ boledamu oqajqa e deqa bem. ");
INSERT INTO boj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","E kaja naŋgo mandor bole. Mandor bole aqa kumbra agiende. A kaja naŋgi aqaryainjrqa marsimqa aqa segi ŋambile uratosim moiqas. ");
INSERT INTO boj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ariya tamo laŋaj aqa kumbra degosai. A silali qa segi wauqas deqa a kaja naŋgi geregere taqatnjrqasai. A kaja naŋgo mandor bolesai. Kaja naŋgi aqa sai. Deqa bauŋ juwaŋ bamqa unsim kaja naŋgi uratnjrsim ulaŋqas. Yimqa bauŋ juwaŋ na kaja qudei ñumim kalil segisegiosib jaraiqab. ");
INSERT INTO boj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A silali qa segi wauqas deqa a kaja naŋgi geregere taqatnjrqasai. A kaja naŋgi qa are qalosai. Bauŋ juwaŋ bamqa a kaja naŋgi uratnjrsim ulaŋqas. ");
INSERT INTO boj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“E kaja naŋgo mandor bole. E ijo segi kaja naŋgi qa qalie bole. Ijo segi kaja naŋgi e qa dego qalie bole. ");
INSERT INTO boj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ijo Abu a e qa qalie bole. E ijo Abu qa qalie bole. Dego kere e ijo segi kaja naŋgi qa qalie bole. Naŋgi dego e qa qalie bole. Deqa e na ijo kaja naŋgi aqaryainjrqa marsiy ijo segi ŋambile uratosiy moiqai. ");
INSERT INTO boj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ijo kaja qudei dego jeŋ oqeq di unub. Naŋgi jeŋ miligiq di sosai. Deqa e naŋgi dego joqsiy bosiy ijo kaja jeŋ miligiq di unub qaji naŋgi ti turtnjrsiy jeŋ qujaiq di breinjrit naŋgi mandor qujai ti sqab. Sosib ijo medabu quoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ijo Abu na e tulaŋ qalaqalaibeqnu. Di kiyaqa? E ijo segi ŋambile uratosiy moisiy olo subq na tigelqai. ");
INSERT INTO boj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tamo bei na ijo ŋambile yaibqa keresai. E ijo segi areqalo na ijo ŋambile uratosiy moiqai. E siŋgila ti unum deqa e na ijo ŋambile uratqa kere. Osiy olo ijo ŋambile oqa kere. Ijo Abu a nami merbej, ‘Ni degye.’ Deqa e degyqai.” ");
INSERT INTO boj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Onaqa Juda naŋgi Yesus aqa anjam deqa ŋiriŋosib poaiyeleb. ");
INSERT INTO boj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Osib naŋgi gargekoba endegsib maroqneb, “Yesus a mondor uge ti unu deqa a tulaŋ nanariqo. Kiyaqa niŋgi aqa anjam queteqnub?” ");
INSERT INTO boj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Onaqa naŋgi qudei maroqneb, “Tamo a mondor uge ti sqas di a anjam bole deqaji marqa keresai. Mondor uge na tamo ŋam qandimo boletqa kere e? Sai.” ");
INSERT INTO boj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nami Juda naŋgo moma naŋgi atra tal bunuj siraŋ waqteb. Deqa olo are qalqajqa yori bati Jerusalem dia brantej. Bati di ulili aiqa bati. ");
INSERT INTO boj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Onaqa Yesus a atra tal miligiq gilsiqa tal me ñam Solomon dia walweloqnej. ");
INSERT INTO boj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Walweleqnaqa Juda tamo kokba naŋgi aqa areq di koroosib minjeb, “Bati gembub koboamqa ni na ino kumbra ti ino wau ti ubtosim geregere mergwam? Ni Kristus amqa geregere merge.” ");
INSERT INTO boj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Onaqa Yesus na kamba minjrej, “E nami niŋgi merŋgem, ‘E Kristus.’ Merŋgonam niŋgi qunab ugeiŋgej. Wau kalil e ijo Abu aqa ñam na yeqnum qaji di niŋgi geregere tenemtoqniy. Tenemtosib endegsi poiŋgwas, bole, e Qotei aqa Ŋiri. ");
INSERT INTO boj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Niŋgi ijo kaja sai deqa niŋgi e qa nuŋgo areqalo siŋgilatosaieqnub. ");
INSERT INTO boj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ijo kaja naŋgi ijo medabu queqnub. E naŋgi qa qalie bole. Naŋgi e daurbeqnub. ");
INSERT INTO boj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","E naŋgi ŋambile enjreqnum deqa naŋgi ŋambile gaigai sqab. Naŋgi padalqasai. Sai bole sai. Tamo bei na naŋgi ijo baŋq dena yaibqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ijo Abu na naŋgi e ebej. A segi qujai iŋgi iŋgi kalil tulaŋ buŋnjrejunu. Deqa tamo bei na ijo kaja naŋgi ijo Abu aqa baŋq dena yaiyqa keresai bole sai. ");
INSERT INTO boj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aqo ijo Abu wo tamo qujai.” ");
INSERT INTO boj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Onaqa Juda tamo kokba naŋgi Yesus aqa anjam di qusibqa naŋgi a qalib moiqajqa marsib meniŋ eleŋeb. ");
INSERT INTO boj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Osib Yesus qalqa laqnab endegsi minjrej, “E na Abu aqa wau bole gargekoba niŋgi osorŋgoqnem. Wau bole kiye qa niŋgi e lubsib moiyotbqa meniŋ eleŋonub?” ");
INSERT INTO boj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Onaqa Juda tamo kokba naŋgi na kamba endegsib minjeb, “Wau bole bei qa iga ni meniŋ na lumqasai. Ni Qotei misiliŋyonum deqa lumqom. Agi ni segi qa maronum, ni Qotei. Ni degsi maraim. Ni mandam tamo. Deqa ni lumqom.” ");
INSERT INTO boj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Onaqa Yesus na kamba naŋgi minjrej, “Nuŋgo dal anjam bei nami endegsib neŋgreŋyeb, ‘E niŋgi merŋgonum, “Niŋgi qotei.” ’ ");
INSERT INTO boj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Agi Qotei na tamo qudei naŋgi minjrej, ‘Niŋgi qotei.’ A na naŋgi degsi minjrej. Niŋgi qalie, iga Qotei aqa neŋgreŋ bei gentqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Abu a segi na e giltbosiqa qariŋbonaq mandamq aiyem deqa e maronum, ‘E Qotei aqa Ŋiri.’ E degsi maronum deqa niŋgi kiyaqa merbonub, ‘Ni Qotei misiliŋyonum’? ");
INSERT INTO boj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“E ijo Abu aqa wau yosaiotqa niŋgi ijo anjam quetbaib. ");
INSERT INTO boj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ariya e Abu aqa wau yitqa niŋgi ijo anjam quib ugeiŋgim olo ijo wau unsib dena geregere poiŋgem, bole, Abu na e beterbesonaqa e kamba Abu beteryejunum.” ");
INSERT INTO boj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Onaqa naŋgi Yesus aqa anjam di qusib a ojqa yonab a naŋgi qa loumosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ulaŋosiqa olo Jordan ya taqal beiq gilej. Gilsiqa Jon na nami tamo uŋgasari naŋgi yansnjroqnej qaji sawaq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sonaqa tamo uŋgasari gargekoba naŋgi aqaq giloqnsib segi segi maroqneb, “Jon a maŋwa bei babtosaioqnej. Ariya anjam kalil Jon a Yesus qa maroqnej qaji di bole.” ");
INSERT INTO boj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naŋgi degsib maroqneb deqa Yesus a sawa dia sonaqa tamo uŋgasari gargekoba naŋgi a qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tamo bei aqa ñam Lasarus a maiyej. Lasarus aqa qure utru Betani. Qure di Maria aqa jaja Marta wo naŋgo qure utru. ");
INSERT INTO boj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria agi bunuqna Tamo Koba Yesus aqa siŋgaq di goreŋ bilentosiq aqa gate baŋga na piyej qaji a di. Aqa jaja Lasarus a maiyej. ");
INSERT INTO boj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Deqa Maria Marta wo naŋgi na tamo qudei qariŋnjrnab Yesus aqaq gilsib minjeb, “O Tamo Koba, tamo ni tulaŋ qalaqalaiyeqnum qaji a maiyqo.” ");
INSERT INTO boj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Onaqa Yesus a naŋgo anjam di qusiqa minjrej, “Ma di moiqajqa ma sai. A maiyqo di aqa utru agiende. Qotei aqa siŋgila boleq dimqa tamo uŋgasari naŋgi unsib Qotei aqa ñam soqtqajqa deqa a ma di oqo. E Qotei aqa Ŋiri dego ñam koba oqai.” ");
INSERT INTO boj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus a Marta aqa jaja Maria wo naŋgi aiyel qalaqalainjrej. A Lasarus dego qalaqalaiyej. ");
INSERT INTO boj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasarus a maiyej anjam di qusiqa quosaibulosiqa sawa a soqnej qaji dia bati aiyel olo soqnej. ");
INSERT INTO boj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sosiqa aqa aŋgro naŋgi minjrej, “Iga olo Judia sawaq aiqom.” ");
INSERT INTO boj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Onaqa naŋgi na Yesus minjeb, “O Qalie Tamo Koba, nami yala Juda naŋgi meniŋ na ni lumqa mareb. Di ni olo deq aiqam e?” ");
INSERT INTO boj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Onaqa Yesus na kamba minjrej, “Seŋ oqsiq qanam jigeqo sawa suwaŋqo. Deqa tamo naŋgi walwelqa kere. Maŋgalqasai. ");
INSERT INTO boj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ariya seŋ aisiq qoloqo sawa ambruqo. Deqa tamo naŋgi walwelqa keresai. Maŋgalqab.” ");
INSERT INTO boj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus a anjam degsi marsiqa olo minjrej, “Gago was Lasarus a ŋeiejunu. E aisiy dudumyqai.” ");
INSERT INTO boj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di qusibqa minjeb, “O Tamo Koba, a ŋeiejunu degam aqa ma saiqas.” ");
INSERT INTO boj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Naŋgi Lasarus a bole ŋeiejunu edegeb. Di sai. A bole moiyej. Yesus a Lasarus aqa moiyo sigitosiqa ŋeio qa marej. ");
INSERT INTO boj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Deqa a na ubtosiq minjrej, “Lasarus a bole moiyej. ");
INSERT INTO boj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Niŋgi ijo siŋgila unsib e qa nuŋgo areqalo siŋgilatqajqa deqa e aqaq aiyosaisonam a moiyej. E niŋgi qa are qalsim kumbra degyem. E ijo kumbra deqa areboleboleibeqnu. Niŋgi tigelab iga Lasarus aqaq aiqom.” ");
INSERT INTO boj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Onaqa Tomas aqa ñam bei Didimus a na Yesus aqa aŋgro qudei naŋgi minjrej, “Uŋgum. Iga kalil aisim Yesus a koba na moiqom.” ");
INSERT INTO boj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Onaqa Yesus aqa aŋgro naŋgi koba na aisib Betani qure jojomyosib anjam endegsib queb, “Lasarus a nami moiyej subq ateb. Bati qolqe koboqo.” ");
INSERT INTO boj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani qure di Jerusalem jojom. Kilomita qalub. ");
INSERT INTO boj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Deqa Juda tamo uŋgasari gargekoba naŋgi Betani qureq bosib Marta Maria wo naŋgo jaja moiyej deqa are latetnjrqajqa koroosib soqneb. ");
INSERT INTO boj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Onaqa Marta a anjam endegsi quej, “Yesus a beqnu.” A degsi qusiqa walwelosiqa gamq di Yesus turqajqa gilej. Maria a talq di awesoqnej. ");
INSERT INTO boj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta a gilsiq gamq di Yesus turosiq minjej, “O Tamo Koba, ni nami endi so qamu ijo jaja a moiyosai qamu. ");
INSERT INTO boj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E qalieonum, ni iŋgi kiye qa Qotei pailyqam a ni emqas.” ");
INSERT INTO boj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Onaqa Yesus na Marta minjej, “Ino jaja a olo subq na tigelqas.” ");
INSERT INTO boj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Onaqa Marta na kamba minjej, “E qalie, diŋo bati qa tamo uŋgasari kalil naŋgi subq na tigelabqa ijo jaja dego ombla tigelqab.” ");
INSERT INTO boj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Onaqa Yesus na minjej, “E segi subq na tigelo qa utru. E segi ŋambile sqajqa utru. Tamo a e qa aqa areqalo siŋgilatosim moiqas di uŋgum. A ŋambile sqas. ");
INSERT INTO boj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tamo kalil ŋambile sosib e qa naŋgo areqalo siŋgilateqnub qaji naŋgi olo bunu moiqasai. O Marta, ni ijo anjam di qusim ino areqaloq di siŋgilatonum e?” ");
INSERT INTO boj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Onaqa Marta na Yesus minjej, “Od, Tamo Koba. E qalieonum, ni Kristus, Qotei aqa Ŋiri. Ni qujai Qotei na qariŋmonaqa mandamq aiyem qaji. Deqa e ni qa ijo areqalo siŋgilatonum.” ");
INSERT INTO boj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta a anjam degsi marsiqa olo puluosi aisiq aqa jaja Maria metonaq aqa areq bonaq ombla sasalosibqa minjej, “Qalie Tamo Koba a bqo. A ni qa marqo.” ");
INSERT INTO boj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Onaqa Maria a Marta aqa anjam di qusiqa tigeloqujatosiq Yesus unqa gilej. ");
INSERT INTO boj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus a qure miligiq aiyosaisoqnej. A Marta wo anjam mareb qaji sawaq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sonaqa Juda tamo uŋgasari talq di Maria are latetoqneb qaji naŋgi Maria a tigeloqujatosiq tal uratosiq gileqnaqa unsib are qaleb, “A Lasarus aqa subq di akamtqajqa gileqnu kiyo.” Naŋgi degsib are qalsib tigelosib Maria dauryosib gileb. ");
INSERT INTO boj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria a gilsiq Yesus soqnej qaji sawaq di brantosiqa Yesus unsiqa aqa areq di siŋga pulutosiqa minjej, “O Tamo Koba, ni nami endi so qamu ijo jaja a moiyosai qamu.” ");
INSERT INTO boj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Onaqa Yesus a Juda tamo uŋgasari Maria dauryosib beb qaji naŋgi Maria ombla akamoqneb di unsiqa naŋgi qa are gulbeiyonaqa nenemnjrej, ");
INSERT INTO boj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Niŋgi Lasarus qabia subq ateb?” Onaqa naŋgi na minjeb, “O Tamo Koba, ni bosim aqa sub une.” ");
INSERT INTO boj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Degsi minjnabqa Yesus a dego akamej. ");
INSERT INTO boj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A akamonaqa Juda naŋgi di unsibqa mareb, “Niŋgi uniy. Yesus a Lasarus tulaŋ qalaqalaiyoqnej deqa akamqo.” ");
INSERT INTO boj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Onaqa naŋgi qudei Yesus qa yomuosib mareb, “Yesus a nami tamo ŋam qandimo boletej. A kiyaqa Lasarus boletosai? Yim a moiqasai.” ");
INSERT INTO boj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Onaqa Yesus a naŋgo yomu anjam di qusiqa are gulbeiyonaqa walwelosiq Lasarus aqa subq gilej. Sub di mana miligiq di bogeb. Lasarus nami subq atsib meniŋ kobaquja na sub me getenteb. ");
INSERT INTO boj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Deqa Yesus na tamo qudei minjrej, “Niŋgi meniŋ kobaquja di taqal atiy.” Onaqa tamo moiyej qaji aqa jaja Marta na Yesus minjej, “O Tamo Koba, a nami moiyej bati qolqe gilqo. Iga meniŋ taqal atqom di aqa qusa quleqwas.” ");
INSERT INTO boj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Onaqa Yesus na kamba minjej, “E nami mermonum, ni e qa ino areqalo siŋgilatqam di ni Qotei aqa siŋgila unqam.” ");
INSERT INTO boj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Degsi minjnaqa naŋgi meniŋ kobaquja di taqal atnabqa Yesus a laŋ goge tarosiqa Qotei endegsi pailyej, “O Abu, ni ijo pail endi quonum deqa e ni qa tulaŋ areboleboleibqo. ");
INSERT INTO boj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E qalieonum, ni gaigai ijo pail queqnum. Ariya tamo uŋgasari ijo areq endi tigelejunub qaji naŋgi e qa naŋgo areqalo siŋgilatqajqa deqa e ni pailmonum. Yim naŋgi qalieqab, ni na e qariŋbonam bem.” ");
INSERT INTO boj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus a degsi Qotei pailyosiq koboonaqa a tulaŋ maosiq marej, “O Lasarus, ni subq dena tigelosim au.” ");
INSERT INTO boj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Degsi marnaqa tamo moiyej qaji a subq dena tigelosiq oqedej. Aqa siŋga ti baŋ ti ulatamu ti nami gara na dalaeb. Deqa Yesus na minjrej, “Aqa gara di pambloŋyib walwelosim gilem.” ");
INSERT INTO boj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bati deqa Juda tamo uŋgasari Maria aqa are latetqa beb qaji naŋgi Yesus aqa maŋwa di unsibqa naŋgi gargekoba Yesus qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ariya naŋgi qudei tigelosib Farisi naŋgoq gilsib kumbra Yesus yej qaji deqa sainjreb. ");
INSERT INTO boj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sainjrnab qusibqa atra tamo kokba ti Juda tamo kokba ti metnjrnab naŋgo areq bosib koba na koroosib mareb, “Iga kiyerqom? Yesus a maŋwa gargekoba yeleŋeqnu. ");
INSERT INTO boj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Iga a uratonam degsi kumbra yoqnqas di tamo uŋgasari kalil naŋgi a qa naŋgo areqalo siŋgilatqab. Yim Rom naŋgi bosib gago atra tal niñaqyosib iga dego kobotgwab.” ");
INSERT INTO boj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wausau deqa tamo bei aqa ñam Kaiafas a Juda naŋgo atra tamo gate soqnej. Deqa a naŋgo ambleq di tigelosiqa minjrej, “Niŋgi tulaŋ nanarionub. Anjam laŋa laŋa mareqnub. ");
INSERT INTO boj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Niŋgi are qaliy. Tamo qujai a tamo uŋgasari kalil naŋgi qa moiqas di kere. Amqa iga padalqasai.” ");
INSERT INTO boj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas aqa segi areqalo na anjam di marosai. A wausau deqa atra tamo gate soqnej deqa a Qotei aqa medabu osiqa anjam di marej. Yesus a Juda naŋgi qa moiqas anjam di ubtosiq marej. ");
INSERT INTO boj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bole, Yesus a Juda naŋgi segi qa moiqasai. Qotei aqa aŋgro kalil sawa bei beiq di unub qaji naŋgi qa ti moiqas. Moisim naŋgi kalil koroinjrimqa naŋgi aqa segi tamo uŋgasari sqab. Kaiafas a anjam di ubtosiq marej. ");
INSERT INTO boj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bati qujai deqa Juda tamo kokba naŋgi Yesus qalib moiqajqa anjam gereiyqa utru ateb. ");
INSERT INTO boj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesus a di qalieosiq deqa a Juda naŋgo ambleq di walwelosaioqnej. A segitosiqa qure kiñala bei wadau sawa jojom deq gilsiqa aqa aŋgro naŋgi koba na dia soqneb. Qure di aqa ñam Efraim. ");
INSERT INTO boj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Qotei a nami Israel naŋgi Isip sawaq di padalqa laqnabqa naŋgi eleŋej. Deqa olo are qalqajqa yori bati jojomej. Yori bati jojomonaqa Juda tulaŋ gargekoba naŋgo qure qureq dena tigelosib yori bati di unqajqa deqa Jerusalem beb. Juda naŋgo kumbra agiende. Yori bati di brantosaisoqnimqa naŋgi Jerusalem bosib naŋgo segi jejamu yansosib yori bati qa tariŋqab. Utru deqa naŋgi Jerusalem beb. ");
INSERT INTO boj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ariya naŋgi Jerusalem bosib Yesus qa ŋamoqneb. Ŋamoqnsib atra tal miligiq bosib segi segi maroqneb, “Niŋgi kiyersib are qalonub? Yesus a yori bati unqajqa Jerusalem bqas kiyo sai kiyo?” ");
INSERT INTO boj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Naŋgi degsib maroqneb. Di kiyaqa? Atra tamo kokba ti Farisi ti naŋgi na tamo uŋgasari naŋgi nami endegsib minjreb, “Tamo bei a Yesus qabi soqnimqa unsim bosim iga mergim iga na ojqom.” ");
INSERT INTO boj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ariya Juda naŋgo yori bati koba jojomej. Bati 6 amqa brantqas. Deqa Yesus a tigelosiqa Betani qureq gilej. Qure di Lasarus agi Yesus na subq na tigeltej qaji aqa qure utru. ");
INSERT INTO boj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gilnaqa qure deqaji tamo uŋgasari naŋgi a unsibqa areboleboleinjrnaqa iŋgi goiyeteb. Marta a iŋgi suweiyosiq Lasarus Yesus wo tamo qudei ti metnjrnaq bosib koba na awoosib iŋgi uyoqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Onaqa Maria a goreŋ quleq tulaŋ boledamu silali kobaquja na awaiyej qaji di jaliŋaq jigsiqa osi bosiqa Yesus aqa siŋgaq di bilentosiqa aqa segi gate baŋga na piyetej. Onaqa goreŋ aqa quleq na tal keretej. ");
INSERT INTO boj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Onaqa Yesus aqa aŋgro bei Judas Iskariot agi bunuqna Yesus osiq jeu tamo naŋgo baŋq di atej qaji a Maria aqa kumbra di unsiqa ŋiriŋosiq marej, ");
INSERT INTO boj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“A kiyaqa goreŋ di qariŋyosiq meniŋ silali 300 osiq dena tamo iŋgi iŋgi saiqoji naŋgi aqaryainjrosai?” ");
INSERT INTO boj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas a tamo iŋgi iŋgi saiqoji naŋgi qa are qalsiq anjam di marosai. A bajiŋ tamo. A Yesus aqa aŋgro naŋgo silali jugwajqa quŋ taqatoqnej. Deqa naŋgi quŋ miligiq di silali ateqnab a na olo bajiŋoqnej. A deqa are qalsiq anjam di marej. ");
INSERT INTO boj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Onaqa Yesus a Judas aqa anjam di qusiqa minjej, “Uŋa di urat. A goreŋ di ojesoqnem. A ijo jejamu subq atqajqa are qalsiq nami gereiyqo. ");
INSERT INTO boj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tamo iŋgi iŋgi saiqoji naŋgi bati gaigai niŋgi ti sqab. Ariya e bati gaigai niŋgi ti sqasai.” ");
INSERT INTO boj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juda tulaŋ gargekoba naŋgi qalieeb, Yesus a Betani qureq gilsiq di soqnej. Deqa naŋgi a unqa beleŋeb. Naŋgi Yesus segi unqajqa bosai. Yesus a nami Lasarus subq na tigeltej deqa naŋgi a dego unqa beb. ");
INSERT INTO boj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Atra tamo kokba naŋgi Lasarus dego qalsib moiyotqa qairoqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Di kiyaqa? Yesus a Lasarus subq na tigeltonaqa Juda gargekoba naŋgi atra tamo kokba naŋgi uratnjrsib olo Yesus qa naŋgo areqalo siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tamo uŋgasari tulaŋ gargekoba naŋgi yori bati unqajqa marsib Jerusalem beleŋeb. Beleŋosib nebeonaqa naŋgi endegsib queb, “Yesus a Jerusalem bqas.” ");
INSERT INTO boj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Naŋgi degsib qusib deqa naŋgi tuwom baŋga eleŋosib Yesus gamq di turqajqa aiyeb. Aisib Yesus beqnaqa unsib tulaŋ leleŋoqnsib endegsib minjoqneb, “Iga ni qa tulaŋ areboleboleigeqnu. Ni Tamo Koba aqa ñam na bonum deqa a ni tulaŋ geregereimeqnu. Ni Israel naŋgo Mandor Koba.” ");
INSERT INTO boj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Onaqa Yesus a donki osiqa quraq di awoej. Aqa kumbra deqa nami Qotei aqa anjam bei endegsib neŋgreŋyeb unu, ");
INSERT INTO boj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Saion tamo uŋgasari, niŋgi ulaaib. Niŋgi uniy. Nuŋgo Mandor Koba a donki bunuj quraq di awoosiq beqnu.” ");
INSERT INTO boj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bati deqa Yesus aqa aŋgro naŋgi anjam di aqa utru poinjrosai. Bunuqna Yesus a moisiq ñam koba onaqa naŋgi anjam deqa olo are qalsib endegsib mareb, “Bole, anjam di Yesus qa neŋgreŋyeb deqa tamo uŋgasari naŋgi leleŋoqnsib a biŋiyoqneb.” ");
INSERT INTO boj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ariya tamo uŋgasari Yesus a Lasarus metosiq subq na tigeltonaq uneb qaji naŋgi maŋwa deqa saoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Laqnab tamo uŋgasari tulaŋ gargekoba naŋgi quoqneb. Deqa Yesus a donki bunuj quraq di awoosiq Jerusalem beqnaqa naŋgi a gamq di turqajqa aiyeleŋeb. ");
INSERT INTO boj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ainabqa Farisi naŋgi na unjrsibqa segi segi maroqneb, “Iga Yesus siŋgila na saidyeqnamqa keresaiigeqnu. Niŋgi uniy. Tamo uŋgasari kalil naŋgi a dauryeqnub.” ");
INSERT INTO boj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tamo uŋgasari Qotei louqa marsib yori bati unqajqa Jerusalem aiyeleŋeb qaji naŋgo ambleq di Grik tamo qudei soqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik tamo naŋgi di Filip aqaq di branteb. Di kiyaqa? Filip a dego Grik tamo. Filip aqa qure utru Betsaida. Qure di Galili sawaq di unu. Naŋgi Filip aqaq di brantosib nenemyeb, “O gago was, iga Yesus unqa kere e?” ");
INSERT INTO boj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Onaqa Filip a aisiqa naŋgo anjam di Andru minjsiqa Andru ombla gilsib olo Yesus minjeb. ");
INSERT INTO boj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Minjnab qusiqa naŋgi kamba minjrej, “E Tamo Aŋgro. Deqa e ñam koba oqajqa bati brantqo. ");
INSERT INTO boj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","E bole merŋgwai. Kurgus yago breiyibqa mandamq aisim moiqasai di a laŋa sqas. Moiqas di a olo qoqi oqsim gei gargekoba ateleŋqas. ");
INSERT INTO boj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dego kere tamo bei na aqa segi ŋambile tulaŋ qalaqalaiyqas di a padalqas. Ariya a mandamq endi aqa segi ŋambile qoreiyqas di a ŋambile gaigai sqas. ");
INSERT INTO boj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tamo bei na e wauetbqa osimqa a e daurbem. Yimqa qure e sqai di a dego e ombla sqom. A ijo wau yoqnqas di ijo Abu na a ñam kobaquja yqas.” ");
INSERT INTO boj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Osiqa Yesus a olo anjam endegsi marej, “Endego e are tulaŋ gulbekobaibqo. Deqa e endegsi Qotei pailyqai kiyo, ‘O ijo Abu, ni na marimqa bati uge endi ijoq baiq’? Uŋgum, e degsi pailyqasai. Bati uge endi branteme. E deqa mandamq aiyem. ");
INSERT INTO boj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O ijo Abu, ni na ino ñam tulaŋ kobaqujatime.” Yesus a degsi marnaqa laŋ goge dena anjam endegsi brantej, “E ijo ñam kobaqujatonum. Ololo kobaqujatqai.” ");
INSERT INTO boj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Anjam degsi brantonaqa tamo uŋgasari Yesus aqa areq di tigelesoqneb qaji naŋgi qusibqa segi segi maroqneb, “Kola anjam atqo kiyo?” Onaqa tamo qudei naŋgi mareb, “Sai. Laŋ aŋgro bei na Yesus anjam minjqo.” ");
INSERT INTO boj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Onaqa Yesus na kamba minjrej, “Anjam niŋgi quonub qaji di e aqaryaibqajqa brantosai. Di niŋgi aqaryaiŋgwajqa brantqo. ");
INSERT INTO boj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Niŋgi quiy. Qotei na tamo uŋgasari mandamq endi unub qaji naŋgi peginjrqajqa bati bqo. A na mandam endeqa gate koba Satan taqal waiyqajqa bati dego bqo. ");
INSERT INTO boj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","E bini mandamq endi unum. Ariya bunuqna jeu tamo naŋgi na e soqtbosib goge gaintbqab. Yimqa bati deqa e na tamo uŋgasari kalil naŋgi are tigeltetnjritqa ijoq bqab.” ");
INSERT INTO boj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus a aqa segi moiqajqa gam boleq atqa osiqa deqa degsi marej. ");
INSERT INTO boj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Onaqa tamo uŋgasari naŋgi na kamba Yesus minjeb, “Kristus a bati gaigai sqas. Dal anjam nami degsib marnab iga quem. Deqa ni kiyaqa maronum, ‘E Tamo Aŋgro soqtbosib goge gaintbqab’? Tamo Aŋgro di tamo yai?” ");
INSERT INTO boj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Onaqa Yesus na minjrej, “Puloŋ a nuŋgo ambleq di sokiñalayosim niŋgi olo uratŋgwas. Deqa niŋgi puloŋ ti sosib puloŋq na laqniy. Yimqa niŋgi ambruiŋgwasai. Tamo ambruq na laqnu qaji a qabiteqnu kiyo di a qalieqasai. ");
INSERT INTO boj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Niŋgi puloŋ ti sosib puloŋ qa nuŋgo areqalo siŋgilatiy. Niŋgi degyqab di niŋgi puloŋ aqa aŋgro sqab.” Yesus na tamo uŋgasari naŋgi anjam degsi minjrsiqa naŋgi uratnjrnaq naŋgi a olo unosai. ");
INSERT INTO boj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A Qotei aqa maŋwa gargekoba naŋgo ŋamdamuq di yeqnaqa naŋgi unoqneb. Unoqnsib ariya naŋgi Yesus qa naŋgo areqalo siŋgilatosaioqneb. ");
INSERT INTO boj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Naŋgi kumbra di yeb deqa anjam bei Qotei aqa medabu o tamo Aisaia a nami marej qaji di aqa damu brantej. A endegsi marej, “O Tamo Koba, tamo yai a gago anjam endi qusiqa aqa areqaloq di siŋgilatqo? Tamo yai a Tamo Koba aqa siŋgila unsiq poiyqo? Tamo dego bei sosai.” Aisaia a nami anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Deqa naŋgi Yesus qa naŋgo areqalo siŋgilatqa keresai. Utru deqa Aisaia a anjam bei dego endegsi neŋgreŋyej, ");
INSERT INTO boj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Qotei a naŋgo ŋamdamu getentetnjrej. A naŋgo are miligi dego getentetnjrej. Deqa naŋgi naŋgo ŋamdamu na Qotei aqa kumbra bei unqa keresai. Naŋgi naŋgo are miligiq na Qotei aqa anjam dego poinjrqa keresai. Deqa naŋgi are bulyosib ijoq bqa keresai. Deqa e na naŋgi boletnjrqasai.” ");
INSERT INTO boj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia a nami Yesus aqa siŋgila unsiq deqa anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bole, Juda gate gargekoba naŋgi are bulyosib Yesus qa naŋgo areqalo siŋgilateb. Ariya naŋgi Farisi naŋgi ulainjrsib deqa naŋgi boleq di Yesus aqa ñam marosaioqneb. Naŋgi are qaleb, “Iga boleq di Yesus aqa ñam marqom di Farisi naŋgi iga Qotei tal miligiq gilqa saidgwab.” ");
INSERT INTO boj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Naŋgi degsib are qaleb. Di kiyaqa? Naŋgi Qotei na naŋgo ñam soqtqajqa arearetnjrosaioqnej. Tamo naŋgi na naŋgo ñam soqtqajqa deqa arearetnjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Onaqa Yesus a tulaŋ leleŋosiq marej, “Tamo bei a e qa aqa areqalo siŋgilatqas di a e qa segi aqa areqalo siŋgilatqasai. Ijo Abu e qariŋbej qaji a qa dego aqa areqalo siŋgilatqas. ");
INSERT INTO boj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tamo bei a e nubqas di a ijo Abu e qariŋbej qaji di dego unqas. ");
INSERT INTO boj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","E puloŋ bulosim mandamq aiyem. Deqa tamo uŋgasari kalil e qa naŋgo areqalo siŋgilateqnub qaji naŋgi ambruq di sqasai. ");
INSERT INTO boj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tamo bei a ijo anjam qusimqa ariya a dauryqasai di e na a pegiyqasai. E tamo uŋgasari naŋgi peginjrqa bosai. E naŋgi eleŋqajqa bem. ");
INSERT INTO boj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tamo uŋgasari naŋgi e qoreibosib ijo anjam quqwa uratqab di naŋgi peginjrqajqa tamo bei unu. Anjam e mareqnum qaji a segi tamo sigitosim tamo uŋgasari naŋgi peginjrqas. Diŋo batiamqa anjam dena naŋgi peginjrqas. ");
INSERT INTO boj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","E ijo segi areqalo na anjam marosaieqnum. Ijo Abu e qariŋbej qaji a na anjam merbeqnaqa quoqnsim agi mareqnum. ");
INSERT INTO boj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E qalieonum, ijo Abu aqa anjam di ŋambile gaigai sqajqa anjam. Deqa anjam kalil e mareqnum qaji di ijo Abu na e merbeqnaq quoqnsim agi mareqnum.” ");
INSERT INTO boj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Juda naŋgo yori bati koba jojomonaqa Yesus a endegsi qalieej, “E mandamq endi so bati koboqo. E moisiy ijo Abu aqaq olo oqwa bati brantqo.” Yesus na aqa segi aŋgro mandamq di soqneb qaji naŋgi tulaŋ qalaqalainjroqnsiq gilsi gilsiq aqa moiqa bati itej. ");
INSERT INTO boj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Deqa a naŋgi koba na awoosib iŋgi uyoqneb. Di bilaq. Iŋgi uyeqnabqa Satan a Judas Iskariot aqaq aiyej. Aisiqa Judas na Yesus osim jeu tamo naŋgo baŋq di atqajqa deqa are tigeltetej. Judas a Saimon Iskariot aqa ŋiri. ");
INSERT INTO boj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus a qalieej, aqa Abu na iŋgi iŋgi kalil aqa baŋq di ateleŋej. A Qotei aqaq na bej puluosim Qotei aqaq olo oqwas di dego qalieej. ");
INSERT INTO boj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Deqa a aqa aŋgro naŋgi koba na iŋgi uyoqnsibqa a tigelosiqa aqa gara olekoba piqtosiq jejamu piyo qaji gara osiqa tigej. ");
INSERT INTO boj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tigsiqa kaŋgal tamo bulosiqa tabirq di ya qamsiq aqa aŋgro naŋgo siŋga yansetnjroqnsiqa jejamu piyo qaji gara dena piyetnjroqnej. ");
INSERT INTO boj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Osiqa Pita aqa siŋga yansetqa laqnaqa minjej, “O Tamo Koba, ni ijo siŋga yansetbqam e?” ");
INSERT INTO boj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Onaqa Yesus na kamba minjej, “Kumbra e endego yeqnum endi ni utru poimosai unu. Bunuqna ni poimqas.” ");
INSERT INTO boj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Onaqa Pita na Yesus saidyosiq minjej, “Ni ijo siŋga yansqasai. Sai bole sai.” Onaqa Yesus na minjej, “E ni yansmqasai di ni e ombla sqa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Onaqa Saimon Pita na minjej, “O Tamo Koba, ni ijo siŋga segi yansaim. Ijo baŋ ti gate ti dego yansetbe.” ");
INSERT INTO boj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Onaqa Yesus na minjej, “Tamo a yalqo a olo yalqasai. Aqa siŋga segi yansqas di kere. Dena a torei milalo sqas. Niŋgi milalo unub. Ariya niŋgi kalil milalo sosai.” ");
INSERT INTO boj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus a qalieej, aqa aŋgro bei agi Judas a na Yesus osim jeu tamo naŋgo baŋq di atqas. Deqa a na minjrej, “Niŋgi kalil milalo sosai.” ");
INSERT INTO boj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus a naŋgo siŋga yansetnjrsiq koboonaqa aqa segi gara olekoba olo jigsiqa awoosiq nenemnjrej, “Kumbra e endego niŋgi eŋgonum qaji di niŋgi utru poiŋgwo e? ");
INSERT INTO boj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Niŋgi e merbeqnub, ‘O Qalie Tamo Koba. O gago Tamo Koba.’ Niŋgi kere e merbeqnub. Agi e segi qujai. ");
INSERT INTO boj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","E nuŋgo Tamo Koba. E nuŋgo Qalie Tamo Koba dego. Ariya e nuŋgo siŋga yansetŋgonum deqa niŋgi dego segi segi qa kumbra degyoqniy. ");
INSERT INTO boj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kumbra e endego niŋgi osorŋgonum qaji di niŋgi kamba dego degsib yoqniy. ");
INSERT INTO boj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","E bole merŋgwai. Kaŋgal tamo na aqa tamo koba buŋyqa keresai. Tamo a wau qa gilqas di a na tamo a qariŋyqo qaji di buŋyqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kumbra e yeqnum endi aqa utru niŋgi poiŋgim dauryiy. Yimqa niŋgi tulaŋ areboleboleiŋgwas. ");
INSERT INTO boj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ijo anjam endi e niŋgi kalil qa marosai. E na niŋgi giltŋgem deqa e niŋgi qa qalie bole. Ariya Qotei aqa anjam bei neŋgreŋq di unu qaji di aqa damu brantqas. Anjam agiende, ‘Tamo e ombla bem quiq di tuqtosim uyqas qaji a na e jeutbqas.’ ");
INSERT INTO boj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kumbra di brantosaisonaqa e nami merŋgonum. Deqa kumbra di brantimqa niŋgi e qa nuŋgo areqalo siŋgilatosib marqab, ‘Bole, Yesus a segi qujai gaigai degsi unu.’ ");
INSERT INTO boj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","E bole merŋgwai. Tamo bei na tamo uŋgasari e qariŋnjronum qaji naŋgi osim geregereinjrqas di a e dego osim gereibqas. A e osim gereibqas di a na ijo Abu e qariŋbej qaji a dego osim gereiyqas.” ");
INSERT INTO boj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus a degsi marsiqa are tulaŋ gulbekobaiyonaqa olo marej, “E bole merŋgwai. Ijo aŋgro bei na e osim jeu tamo naŋgo baŋq di atqas.” ");
INSERT INTO boj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Onaqa Yesus aqa aŋgro naŋgi segi segi kokoqoqneb. Yesus a aŋgro yai qa degsi marej di naŋgi qaliesai deqa naŋgi degyoqneb. ");
INSERT INTO boj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesus aqa aŋgro bei agi Yesus na tulaŋ qalaqalaiyoqnej qaji a Yesus aqa areq di awesoqnej. ");
INSERT INTO boj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Deqa Saimon Pita a baŋ na aŋgro di minjej, “Ni na Yesus nenemyimqa a aŋgro yai qa degsi marqo di mermqas.” ");
INSERT INTO boj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Onaqa aŋgro dena Yesus beteryosiqa nenemyej, “O Tamo Koba, ni aŋgro yai qa degsi maronum?” ");
INSERT INTO boj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Onaqa Yesus na minjej, “Aŋgro e endego bem osiy quiq di tuqtosiy anaiyqai qaji a na e osim jeu tamo naŋgo baŋq di atqas.” Degsi minjsiqa bem quiq di tuqtosiq Saimon Iskariot aqa ŋiri Judas anaiyej. ");
INSERT INTO boj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Anaiyonaq Satan a Judas aqa are miligiq ainaqa Yesus na minjej, “Ni kumbra yqam qaji di endego yoqujat.” ");
INSERT INTO boj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesus a Judas degsi minjnaqa aqa aŋgro kalil awesoqneb qaji naŋgi qusibqa Yesus na Judas kiyaqa anjam di minjej naŋgi deqa poinjrosai. ");
INSERT INTO boj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas a naŋgo silali jugwajqa quŋ taqatoqnej deqa naŋgi qudei are qaleb, Judas a gilsim yori bati aqa iŋgi iŋgi awaiyqajqa deqa kiyo Yesus na degsi minjej. Naŋgi qudei are qaleb, Judas a gilsim iŋgi awaiyosim tamo sougetejunub qaji naŋgi anainjrqas. ");
INSERT INTO boj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Onaqa Judas a bem di uysiqa warum uratosiq oqedej. Di qolo. ");
INSERT INTO boj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas a oqedonaqa Yesus a endegsi marej, “Bini e Tamo Aŋgro ñam koba oqai. E ñam koba otqa Qotei a dego ñam koba oqas. ");
INSERT INTO boj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Qotei a ñam koba osimqa a na e dego ñam koba ebqas. A urur ñam koba ebqas. ");
INSERT INTO boj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O ijo aŋgro niŋgi quiy. E niŋgi koba na sokiñalayosiy uratŋgitqa niŋgi e qa ŋamoqnqab. Qure e oqwai di niŋgi oqwa keresai. E nami Juda tamo kokba naŋgi degsi minjroqnem agi bini niŋgi dego olo merŋgonum. ");
INSERT INTO boj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Endego e dal anjam bunuj eŋgwai. Dal anjam bunuj agiende. Niŋgi segi segi qa qalaqalaiyo kumbra yoqniy. E niŋgi qalaqalaiŋgeqnum dego kere niŋgi kamba dego segi segi qa qalaqalaiyo kumbra yoqniy. ");
INSERT INTO boj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Niŋgi segi segi qa qalaqalaiyo kumbra yoqnibqa tamo kalil naŋgi nuŋgo kumbra di unoqnsib dena qalieoqnqab, niŋgi ijo aŋgro bole.” ");
INSERT INTO boj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Onaqa Saimon Pita na Yesus nenemyej, “O Tamo Koba, ni qabitqam?” Onaqa Yesus na minjej, “Qure e oqwai di ni mati oqwa keresai. Bunuqna ni e daurbosim qure deq oqwam.” ");
INSERT INTO boj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Onaqa Pita na olo Yesus nenemyej, “O Tamo Koba, kiyaqa e bini ni daurmqa keresai? Ni marimqa e ni qa ijo ŋambile uratosiy moiqai.” ");
INSERT INTO boj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Onaqa Yesus na kamba minjej, “Ni e qa ino ŋambile uratosim moiqam e? E bole mermqai. Tuwe anjamosaisoqnimqa ni maroqalubtqam, ‘E Yesus qaliesai.’” ");
INSERT INTO boj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Osiqa Yesus a olo marej, “Niŋgi are gulbeiŋgaiq. Niŋgi Qotei qa nuŋgo areqalo siŋgilateqnub ariya niŋgi e qa dego nuŋgo areqalo siŋgilatoqniy. ");
INSERT INTO boj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ijo Abu aqa talq di warum gargekoba unub. E oqsiy nuŋgo segi segi warum gereiyetŋgwai. Ijo anjam di bolesai qamu e niŋgi merŋgosai qamu. ");
INSERT INTO boj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E nuŋgo segi segi warum gereiyetŋgsiy olo bosiy niŋgi joqsiy qure e sqai di niŋgi dego e ombla sqab. ");
INSERT INTO boj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Qure e sqai deq oqwajqa gam di niŋgi qalie.” ");
INSERT INTO boj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Onaqa Tomas na Yesus minjej, “O Tamo Koba, qure ni oqwam di iga qaliesai. Deqa iga kiyersim qure deq oqwajqa gam qalieqom?” ");
INSERT INTO boj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Onaqa Yesus na minjej, “E segi gam. E segi anjam bole qa utru. E segi ŋambile qa utru dego. Tamo bei a gam bei na ijo Abu aqaq oqwa keresai. Ijo Abu aqaq oqwajqa gam agi e segi qujai. ");
INSERT INTO boj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Niŋgi e qa qalieonub qamu niŋgi ijo Abu qa dego qalieonub qamu. Agi endego niŋgi ijo Abu qa qalieqa utru atonub. Osib niŋgi a unonub.” ");
INSERT INTO boj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Onaqa Filip na Yesus minjej, “O Tamo Koba, ni na ino Abu osorgimqa di iga qa kereqas.” ");
INSERT INTO boj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Onaqa Yesus na minjej, “O Filip, e bati olekoba niŋgi koba na soqnem. Ni e qa qalieosai unum e? Tamo a e nubqo di a ijo Abu dego unqo. Deqa ni kiyaqa e merbonum, ‘Ni na ino Abu iga osorge’? ");
INSERT INTO boj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","E ijo Abu beteryesonam a e dego beterbejunu di ni poimosai kiyo? Anjam e na niŋgi merŋgeqnum qaji endi ijo segi areqalo na merŋgosai. Ijo Abu na e beterbesosiqa aqa wau ojeqnu. ");
INSERT INTO boj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","E ijo Abu beteryesonam a e dego beterbejunu. Niŋgi ijo anjam di qusib e qa nuŋgo areqalo siŋgilatiy. Saiamqa wau kalil e nuŋgo ŋamdamuq di yeqnum qaji di niŋgi unsib e qa nuŋgo areqalo siŋgilatiy. ");
INSERT INTO boj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“E bole merŋgwai. Tamo bei a e qa aqa areqalo siŋgilatqas di wau kalil e yeqnum qaji a dego yoqnqas. Osim ijo wau di buŋyosim wau tulaŋ kokba yoqnqas. Di kiyaqa? E ijo Abu aqaq olo oqwai deqa. ");
INSERT INTO boj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E Qotei aqa Ŋiri unum deqa niŋgi ijo ñam na iŋgi bei qa Qotei pailyqab di e na iŋgi di eŋgwai. Yim dena ijo Abu a ñam koba oqas. ");
INSERT INTO boj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Niŋgi ijo ñam na iŋgi bei qa Qotei pailyqab di e na iŋgi di eŋgwai.” ");
INSERT INTO boj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Osiqa Yesus a olo marej, “Niŋgi e qalaqalaibqab di niŋgi ijo anjam dauryoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Amqa e ijo Abu minjitqa a na Aqaryaiŋgo Tamo qariŋyim nuŋgoq bosim siŋgilatŋgwas. Osim a bati gaigai niŋgi koba na sqas. ");
INSERT INTO boj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aqaryaiŋgo Tamo di a anjam bole qa Mondor. Tamo uŋgasari mandamq endi unub qaji naŋgi Mondor di oqa keresai. Naŋgi a unosaieqnub. Naŋgi a qa qaliesai dego. Ariya niŋgi a qa qalie. A niŋgi koba na unub. Bunuqna a bosim nuŋgo are miligiq di sqas. ");
INSERT INTO boj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“E niŋgi mandum aŋgro bul uratŋgwasai. E nuŋgoq olo bqai. ");
INSERT INTO boj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sokiñala tamo uŋgasari mandamq endi unub qaji naŋgi e olo nubqasai. Ariya niŋgi e nubqab. E ŋambile unum deqa niŋgi dego ŋambile sqab. ");
INSERT INTO boj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sosibqa bati deqa niŋgi endegsib qalieqab, e na ijo Abu beteryesonam niŋgi kamba e beterbesonab e niŋgi beterŋgejunum. ");
INSERT INTO boj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Niŋgi quiy. Tamo bei na e qalaqalaibqas di a ijo dal anjam dego qusim dauryoqnqas. Yim ijo Abu na kamba tamo di qalaqalaiyqas. E na dego tamo di qalaqalaiyoqnsiy aqaq di brantoqnsiyqa e segi qa babtoqnqai.” ");
INSERT INTO boj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Onaqa Judas bei Judas Iskariot sai a na Yesus endegsi nenemyej, “O Tamo Koba, kiyaqa ni tamo uŋgasari kalil mandamq endi unub qaji naŋgoq di brantqa saidosim gago segiq di brantoqnsim ni segi qa babtoqnqam?” ");
INSERT INTO boj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Onaqa Yesus na minjej, “Tamo bei na e qalaqalaibqas di a ijo anjam dauryoqnqas. Yim ijo Abu na kamba tamo di qalaqalaiyimqa aqo ijo Abu wo aqaq bosim a ombla gaigai sqom. ");
INSERT INTO boj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tamo bei a e qalaqalaibqasai di a ijo anjam dauryqasai. Anjam e na niŋgi merŋgeqnum qaji endi ijo anjam sai. Anjam endi ijo Abu e qariŋbej qaji aqa anjam. ");
INSERT INTO boj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Anjam endi e niŋgi koba na sosim merŋgeqnum. ");
INSERT INTO boj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bunuqna Aqaryaiŋgo Tamo a nuŋgoq bosim siŋgilatŋgwas. A Mondor Bole. Ijo Abu na a qariŋyim ijo ñam na bosim anjam kalil niŋgi merŋgekritqas. Osim nuŋgo areqalo tigeltetŋgimqa anjam kalil e niŋgi merŋgeqnum qaji deqa olo are qaloqnqab. ");
INSERT INTO boj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“E niŋgi uratŋgwa osiy nuŋgo are latetŋgwai. E segi are lawo unum deqa e nuŋgo are latetŋgwai. Mandam tamo bei na degsim nuŋgo are latetŋgwa keresai. Deqa niŋgi are gulbeiŋgaiq. Osib ulaaib. ");
INSERT INTO boj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","E niŋgi endegsim merŋgonum quonub, ‘E niŋgi uratŋgsiy olo nuŋgoq bqai.’ Niŋgi e qalaqalaibonub qamu niŋgi ijo anjam deqa areboleboleiŋgwo qamu. Di kiyaqa? E ijo Abu aqaq olo oqwai deqa. Ijo Abu agi a na e tulaŋ buŋbejunu. ");
INSERT INTO boj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","E ijo Abu aqaq oqosaisosim anjam endi merŋgonum. Deqa bunuqna e ijo Abu aqaq oqitqa niŋgi e qa nuŋgo areqalo torei siŋgilatqab. ");
INSERT INTO boj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Mandam endeqa gate koba Satan a beqnu. A na e gulbe bei ebqa keresai. Deqa e olo anjam olekoba totoryosiy merŋgwasai. ");
INSERT INTO boj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ijo are koba endegsi unu. Mandam qaji tamo uŋgasari naŋgi qalieqab, e ijo Abu qalaqalaiyeqnum deqa anjam a na merbeqnu qaji di e dauryeqnum. Ariya niŋgi tigelab iga gilqom.” ");
INSERT INTO boj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Osiqa Yesus a olo marej, “E segi wain ŋamtaŋ bole. Ijo Abu a wain wau qa lanja. ");
INSERT INTO boj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ijo dani qudei naŋgi gei bole atqasai di ijo Abu na naŋgi giŋgeŋnjrsim taqal breinjrqas. Ijo dani naŋgi gei bole ateleŋqab di ijo Abu na gereinjrimqa naŋgi olo gei koba ateleŋqab. ");
INSERT INTO boj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Anjam kalil e nami merŋgoqnem qaji dena niŋgi gereiŋgej koboej. ");
INSERT INTO boj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Niŋgi e beterbesoqniy. Yimqa e dego niŋgi beterŋgesqai. Ŋam dani a segi sqas di a geitqa keresai. Qoboq di beteresqas di a geitqas. Dego kere niŋgi e beterbesqasai di niŋgi gei bole atqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“E segi wain ŋamtaŋ bole. Niŋgi ijo dani bul. Tamo bei a e beterbesqas di e dego a beteryesqai. Yimqa a gei koba ateleŋqas. Niŋgi e uratbqab di niŋgi wau bei yqa keresai. ");
INSERT INTO boj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tamo bei a e beterbesqasai di a ŋam dani uge bul giŋgeŋyosib taqal breiyib kaŋgraŋamqa koroiyosib ŋamyuwoq di breiyib yugwas. ");
INSERT INTO boj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Niŋgi e beterbesosib ijo anjam nuŋgoq di soqnimqa niŋgi iŋgi bei qa Qotei pailyqab di a na iŋgi di eŋgwas. ");
INSERT INTO boj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Niŋgi gei koba ateleŋosib ijo aŋgro bole soqniy. Yimqa ijo Abu aqa ñam tulaŋ kobaqas. ");
INSERT INTO boj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ijo Abu na e qalaqalaibeqnu dego kere e na niŋgi qalaqalaiŋgeqnum. Deqa niŋgi gaigai ijo qalaqalaiyo kumbraq di soqniy. ");
INSERT INTO boj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Niŋgi ijo dal anjam kalil dauryoqnqab di niŋgi ijo qalaqalaiyo kumbraq di sqab. E ijo Abu aqa dal anjam dauryoqnsimqa aqa qalaqalaiyo kumbraq di unum dego kere. ");
INSERT INTO boj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","E segi areboleboleibeqnu deqa niŋgi dego areboleboleiŋgoqnem. Ijo arebolebole di nuŋgoq di tulaŋ kobaoqnem. Utru deqa e na anjam endi niŋgi merŋgonum. ");
INSERT INTO boj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ijo dal anjam agiende. E na niŋgi qalaqalaiŋgeqnum dego kere niŋgi segi segi qa qalaqalaiyo kumbra yoqniy. ");
INSERT INTO boj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Qalaqalaiyo kumbra tulaŋ bolequja bei agiende. Tamo bei na aqa was naŋgi aqaryainjrqa osimqa aqa segi ŋambile uratosim moiqas. Qalaqalaiyo kumbra dena qalaqalaiyo kumbra kalil tulaŋ buŋnjrejunu. ");
INSERT INTO boj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Niŋgi ijo anjam kalil e na merŋgeqnum qaji endi dauryqab di niŋgi ijo segi was bole sqab. ");
INSERT INTO boj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Anjam kalil ijo Abu na e merbeqnaq queqnum qaji di e ubtosim niŋgi merŋgeqnum. Deqa e niŋgi ‘was’ merŋgeqnum. E niŋgi ‘kaŋgal tamo’ merŋgosaieqnum. Kaŋgal tamo a aqa tamo koba aqa wau qaliesai. ");
INSERT INTO boj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Niŋgi na e giltbosai. E na niŋgi giltŋgem. Osim niŋgi wau eŋgem. Niŋgi gilsib gei koba ateleŋoqnibqa nuŋgo gei gaigai sqajqa deqa e na niŋgi wau eŋgem. Deqa niŋgi ijo ñam na iŋgi bei qa ijo Abu pailyqab di a na iŋgi di eŋgwas. ");
INSERT INTO boj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","E na niŋgi dal anjam endegsi merŋgwai. Niŋgi segi segi qa qalaqalaiyo kumbra yoqniy.” ");
INSERT INTO boj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Osiqa Yesus a olo marej, “Mandam qaji tamo uŋgasari naŋgi na niŋgi jeutŋgeqnub. Deqa niŋgi endegsi poiŋgem, naŋgi namoqna e dego jeutboqneb. ");
INSERT INTO boj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Niŋgi mandam qaji tamo unub qamu mandam qaji tamo uŋgasari naŋgi na niŋgi qalaqalaiŋgeqnub qamu. Agi naŋgi na naŋgo segi was naŋgi qalaqalainjreqnub dego kere. Ariya niŋgi mandam qaji tamo sai. E na niŋgi giltŋgem deqa niŋgi mandam qaji kumbra urateb. Utru deqa mandam qaji tamo uŋgasari naŋgi na niŋgi jeutŋgeqnub. ");
INSERT INTO boj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","E nami merŋgonum, kaŋgal tamo na aqa tamo koba buŋyqa keresai. Niŋgi anjam deqa are qaliy. Jeu tamo naŋgi na e ugeugeiboqneb dego kere naŋgi na niŋgi ugeugeiŋgoqnqab. Naŋgi ijo anjam dauryoqneb qamu naŋgi nuŋgo anjam dego dauryeqnub qamu. ");
INSERT INTO boj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ariya naŋgi ijo Abu e qariŋbej qaji a qa qaliesai. Deqa naŋgi niŋgi ugeugeiŋgoqnqab. Di kiyaqa? Niŋgi ijo ñam ejunub deqa. ");
INSERT INTO boj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“E bosim naŋgi anjam minjrosai qamu naŋgi une saiqoji unub qamu. Ariya e naŋgi anjam minjrem deqa naŋgi naŋgo une ulitqa gam saiqoji. ");
INSERT INTO boj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tamo bei na e jeutbqas di a na ijo Abu dego jeutqas. ");
INSERT INTO boj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","E maŋwa qudei tamo bei na nami yosaioqnej qaji di naŋgo ambleq di babtosai qamu naŋgi une saiqoji unub qamu. Ariya e naŋgo ambleq di maŋwa qudei babteqnamqa naŋgi unoqnsib aqo ijo Abu wo jeutgeqnub. ");
INSERT INTO boj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Naŋgo kumbra dena dal anjam bei neŋgreŋq di unu qaji di aqa damu brantej. Anjam agiende, ‘Tamo naŋgi e laŋa jeutbeqnub.’ ");
INSERT INTO boj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aqaryaiŋgo Tamo a ijo Abu ombla unub. E na a qariŋyit nuŋgoq bqas. A anjam bole qa Mondor. A ijo Abu aqaq dena bqas. Bosim ijo kumbra ti ijo wau ti ubtosim marqas. ");
INSERT INTO boj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Niŋgi dego ijo kumbra ti ijo wau ti ubtosib marqab. Di kiyaqa? Nami e ijo wau utru atem bati deqa niŋgi e ombla sosib ijo wau unoqneb dena bosi bosib agi bini niŋgi e ombla unum. ");
INSERT INTO boj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Niŋgi ijo ñam uratosib uloŋaib deqa e na anjam endi merŋgeqnum. ");
INSERT INTO boj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bunuqna jeu tamo naŋgi na niŋgi taqal breiŋgosib niŋgi olo Qotei tal miligiq gilqa saidŋgwab. Osib bati bei bamqa naŋgi na niŋgi moiyotŋgoqnqab. Osib endegsib are qaloqnqab, ‘Iga Qotei aqa wau ojeqnum deqa iga na naŋgi moiyotnjreqnum.’ ");
INSERT INTO boj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","O ijo aŋgro, jeu tamo naŋgi aqo ijo Abu wo qa qaliesai deqa naŋgi niŋgi degŋgwab. ");
INSERT INTO boj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naŋgi niŋgi degŋgibqa niŋgi ijo anjam e bini merŋgeqnum qaji endeqa olo are qaliy.” Osiqa Yesus a olo marej, “Nami e niŋgi koba na soqnem bati deqa e na anjam endi niŋgi merŋgosaioqnem. ");
INSERT INTO boj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sokiñala e niŋgi uratŋgsiy ijo Abu e qariŋbej qaji aqaq olo oqwai deqa bini e anjam endi niŋgi merŋgeqnum. Ariya niŋgi kamba e nenembosaieqnub, ‘Ni qabitqam?’ degbosai. ");
INSERT INTO boj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","E niŋgi anjam endi merŋgeqnum deqa niŋgi are gulbeiŋgeqnu. ");
INSERT INTO boj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E bole merŋgwai. E niŋgi uratŋgsiy oqwai. E oqwasai di Aqaryaiŋgo Tamo agi Mondor Bole a nuŋgoq bqasai. Utru deqa e niŋgi uratŋgsiy oqwai. E oqsiy Mondor qariŋyitqa a nuŋgoq bqas. ");
INSERT INTO boj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bosimqa mandam qaji tamo uŋgasari naŋgo une babtetnjroqnim naŋgi poinjroqnqas. Kumbra bole qa utru dego a na osornjroqnim naŋgi qalieoqnqab. Qotei a tamo uŋgasari naŋgi peginjrqas kumbra di dego naŋgi qalieqajqa deqa Mondor na naŋgi osornjroqnqas. ");
INSERT INTO boj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","A na mandam qaji tamo uŋgasari naŋgo une babtetnjroqnqas. Di kiyaqa? Naŋgi e qa naŋgo areqalo siŋgilatosaieqnub deqa. ");
INSERT INTO boj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kumbra bole qa utru dego a na naŋgi osornjroqnqas. Di kiyaqa? E ijo Abu aqaq oqitqa niŋgi e olo nubqasai. ");
INSERT INTO boj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Qotei a tamo uŋgasari naŋgi peginjrqas kumbra di dego Mondor na naŋgi osornjroqnqas. Di kiyaqa? Qotei na mandam endeqa gate koba Satan pegiyosim ŋamyuwoq waiyqas. ");
INSERT INTO boj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“E anjam gargekoba niŋgi merŋgwajqa ijo areqaloq di unu. Bini e merŋgwasai. Di kiyaqa? Nuŋgo areqalo na ojqa keresai deqa. ");
INSERT INTO boj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ariya anjam bole qa Mondor a bosimqa nuŋgo areqalo gereiyetŋgimqa niŋgi anjam bole kalil poiŋgekritqas. Aqa segi areqalo na anjam merŋgwasai. A anjam quoqnsim di segi niŋgi merŋgoqnqas. Osim kumbra mondoŋ branteleŋqas qaji di dego ubtoqnsim merŋgoqnqas. ");
INSERT INTO boj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A ijo anjam osim niŋgi merŋgoqnqas. Kumbra dena a na ijo ñam koba ti ijo siŋgila koba ti boleq atqas. ");
INSERT INTO boj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ijo Abu aqa iŋgi iŋgi kalil di ijo iŋgi iŋgi dego. Deqa e niŋgi merŋgonum, Qotei aqa Mondor na ijo anjam osim niŋgi merŋgoqnqas.” ");
INSERT INTO boj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Osiqa Yesus a olo marej, “Sokiñala niŋgi e nubqasai. Olo sokiñala niŋgi e nubqab.” ");
INSERT INTO boj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Onaqa Yesus aqa aŋgro naŋgi segi segi maroqneb, “Yesus a marqo, ‘Sokiñala niŋgi e nubqasai. Olo sokiñala niŋgi e nubqab.’ A dego marqo, ‘E ijo Abu aqaq olo oqwai.’ A kiyaqa degsi marqo?” ");
INSERT INTO boj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Naŋgi degsib maroqnsib olo maroqneb, “Yesus a kiyaqa marqo, ‘Sokiñala’? Anjam di aqa utru iga poigosai.” ");
INSERT INTO boj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Naŋgi Yesus aqa anjam deqa nenemyqa laqnab di qalieosiqa endegsi minjrej, “E niŋgi merŋgonum, ‘Sokiñala niŋgi e nubqasai. Olo sokiñala niŋgi e nubqab.’ Ijo anjam di aqa utru niŋgi poiŋgosai deqa niŋgi segi segi qaireqnub. ");
INSERT INTO boj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","O ijo aŋgro, e bole merŋgwai. Niŋgi akam ti sosib are tulaŋ gulbeiŋgwas. Amqa mandam qaji tamo uŋgasari naŋgi areboleboleinjrqas. Ariya nuŋgo are gulbe di olo koboamqa niŋgi tulaŋ areboleboleiŋgwas. ");
INSERT INTO boj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uŋa a aŋgro oqajqa batieqnaqa aqa jejamu tulaŋ jaqatiŋyeqnaqa a are gulbekobaiyeqnu. Ariya a aŋgro osim aqa jaqatiŋ koboamqa a aqa jaqatiŋ deqa olo are qalqasai. A aŋgro osim deqa tulaŋ areboleboleiyqas. ");
INSERT INTO boj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dego kere bini niŋgi are gulbeiŋgwo. Ariya bunuqna e niŋgi olo niŋgitqa niŋgi are gulbe di uratosib tulaŋ areboleboleiŋgwas. Nuŋgo arebolebole di tamo bei na olo yaiŋgwa keresai. ");
INSERT INTO boj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bati deqa niŋgi olo e anjam bei nenembqasai. E bole merŋgwai. Niŋgi ijo ñam na iŋgi bei qa Abu pailyqab di a na iŋgi di eŋgwas. ");
INSERT INTO boj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Niŋgi nami ijo ñam na Qotei pailyosaioqneb. Ariya bini niŋgi iŋgi bei oqajqa are soqnimqa niŋgi ijo ñam na Qotei pailyoqniy. Osib deqa niŋgi iŋgi di osib tulaŋ areboleboleiŋgwas.” ");
INSERT INTO boj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Osiqa Yesus a olo marej, “E niŋgi yawo anjam merŋgoqnam. Bunuqna e olo yawo anjam bei niŋgi merŋgwasai. Anjam aqa damu geregere plaltosiy ijo Abu qa merŋgoqnqai. ");
INSERT INTO boj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bati deqa e segi niŋgi qa Abu pailyqasai. Niŋgi ijo ñam na Abu pailyoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ijo Abu a segi na niŋgi qalaqalaiŋgeqnu. Di kiyaqa? Niŋgi e qalaqalaiboqnsib e Qotei aqaq na bem degsi poiŋgeqnu deqa. ");
INSERT INTO boj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nami e ijo Abu aqaq na bosim mandamq aiyem. Sokiñala e olo mandam uratosiy aqaq olo oqwai.” ");
INSERT INTO boj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Onaqa Yesus aqa aŋgro naŋgi aqa anjam di qusib minjeb, “Od, endego ni boleq di anjam ubtosim mergonum. Ni yawo anjam mergosai. ");
INSERT INTO boj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Deqa bini iga poigwo, ni kumbra kalil qa qalieonum. Deqa iga ni anjam bei nenemmqasai. Ni namoqna gago nenem qalieonum. Utru deqa iga ni qa gago areqalo siŋgilatosim maronum, bole, ni Qotei aqaq na bem.” ");
INSERT INTO boj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Onaqa Yesus na kamba minjrej, “Niŋgi e qa nuŋgo areqalo siŋgilatonub e? Di keretonub. ");
INSERT INTO boj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Niŋgi quiy. Bati bei bqas agi bqo. Sokiñala jeu tamo naŋgi na niŋgi teteiŋgibqa niŋgi kalil segisegiosib nuŋgo qureq jaraiqab. Jaraiyibqa e segi sqai. Bole, e segi sqasai. Ijo Abu a e ombla sqom. ");
INSERT INTO boj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","E anjam endi niŋgi merŋgeqnum. Di kiyaqa? Niŋgi na e beterbosib are lawo sqajqa deqa. Bole, niŋgi mandamq endi gulbe koba oqnqab. Di uŋgum. E segi na mandam endeqa siŋgila kalil gotraŋyosim tigelejunum. Deqa niŋgi are siŋgilatosib soqniy.” ");
INSERT INTO boj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus a anjam degsi marsiq koboonaqa laŋ goge tarosiqa Qotei endegsi pailyej, “O Abu, bati brantqo. E ino segi Aŋgro qujai unum deqa ni ijo ñam kobaqujatimqa e kamba dego ino ñam kobaqujatqai. ");
INSERT INTO boj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ni e siŋgila ebem. Siŋgila dena e na tamo uŋgasari kalil naŋgi taqatnjroqnqai. Osiy tamo kalil ni na ebem qaji naŋgi ŋambile enjritqa naŋgi ŋambile gaigai sqab. ");
INSERT INTO boj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ŋambile gaigai sqajqa kumbra agiende. Tamo e na ŋambile enjreqnum qaji naŋgi ni qa bole qalieeqnub. Agi ni segi Qotei bole. Naŋgi e Yesus Kristus qa dego bole qalieeqnub. Agi ni na e qariŋbonam mandamq aiyem. Ŋambile gaigai sqajqa kumbra agide. ");
INSERT INTO boj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","5","“O Abu, e mandamq endi ino ñam koba ti ino siŋgila koba ti babtoqnem. Osim wau kalil ni na ebem qaji di yekritem. Nami mandam a brantosaisonaqa e ni ombla ñam koba ti soqnem. Ñam di ni na olo ebimqa aqo ombla ñam koba ti sqom. ");
INSERT INTO boj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tamo kalil ni na ebem qaji naŋgi di e na ino ñam osornjroqnem. Deqa naŋgi ino anjam dauryoqneb. Naŋgi ino segi tamo soqneb deqa ni na naŋgi mandamq endena eleŋosim e ebem. ");
INSERT INTO boj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bini naŋgi qalieonub, iŋgi iŋgi kalil ni na e ebem qaji di inoq dena branteb. ");
INSERT INTO boj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Naŋgi degsib qalieonub. Di kiyaqa? Anjam kalil ni na e merbem qaji di e kamba naŋgi minjrnam naŋgi queb. Qusib ni na e qariŋbonam bem anjam di naŋgo areqaloq di siŋgilateb. Osib endegsi poinjrej, e inoq dena bem. ");
INSERT INTO boj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“E naŋgi qa ni pailmonum. E mandam qaji tamo uŋgasari naŋgi qa ni pailmosai. Tamo ni na ebem qaji naŋgi qa segi e ni pailmonum. Di kiyaqa? Naŋgi ino tamo unub deqa. ");
INSERT INTO boj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ijo tamo kalil naŋgi di ino dego. Ino tamo kalil naŋgi di ijo dego. Naŋgoq dena e ñam kobaquja eqnum. ");
INSERT INTO boj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“E inoq olo bqai. Deqa e mandamq endi olo sqasai. Ariya tamo ni na ebem qaji naŋgi mandamq endi sqab. O Abu, ino kumbra kalil tulaŋ boledamu. Ni segi qujai une saiqoji. Ino ñam koba ni na ebem qaji ñam dena ni na ijo tamo naŋgi taqatnjroqnime. Amqa aqo aiyel are qujaitosim unum dego kere naŋgi kamba are qujaitosib sqab. ");
INSERT INTO boj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","E naŋgi koba na sosimqa ino ñam kobaquja ni na ebem qaji ñam dena naŋgi taqatnjroqnem. Deqa ijo aŋgro bei padalosai. Aŋgro qujai agi ni nami padalqajqa giltem qaji a segi padalqas. A padalamqa ino anjam neŋgreŋq di unu qaji di aqa damu brantqas. ");
INSERT INTO boj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","E olo inoq bqai. Ijo segi arebolebole tulaŋ kobaosim tamo ni na ebem qaji naŋgoq di gaigai sqajqa deqa e mandamq endi sosimqa anjam endi mareqnum. ");
INSERT INTO boj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“E na naŋgi ino anjam minjroqnem. Utru deqa mandam qaji tamo uŋgasari naŋgi na naŋgi jeutnjreqnub. Naŋgi mandam qaji tamo sai. Agi e dego mandam qaji tamo sai. ");
INSERT INTO boj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ni na naŋgi joqsim naŋgi mandam uratosib laŋ qureq oqwajqa deqa e ni pailmosai. Naŋgi mandamq endi soqnib ni na naŋgi taqatnjroqnim tamo uge Satan na naŋgi ugeugeinjraim deqa e ni pailmonum. ");
INSERT INTO boj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naŋgi mandam qaji tamo sai. Agi e dego mandam qaji tamo sai. ");
INSERT INTO boj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ino anjam kalil bole. Ni ino anjam bole di naŋgi minjroqne. Yimqa anjam di naŋgo are miligiq di wauoqnimqa naŋgi ino segi tamo tiŋtiŋ sqab. ");
INSERT INTO boj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nami ni na e qariŋbonam mandamq aisim tamo uŋgasari naŋgo ambleq di soqnem. Deqa e kamba tamo ni na ebem qaji naŋgi qariŋnjritqa mandam qaji tamo uŋgasari naŋgo ambleq di sqab. ");
INSERT INTO boj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","E naŋgi qa are qalsiy ijo segi jejamu ni emekritqai. Ijo kumbra dena naŋgi ino segi tamo tiŋtiŋ sosib ino anjam bole dauryoqnqab. ");
INSERT INTO boj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“E ijo aŋgro 11 naŋgi qa segi ni pailmosai. Bunuqna naŋgi ijo anjam mare mare laqnibqa tamo uŋgasari gargekoba naŋgi naŋgo anjam quoqnsib e qa naŋgo areqalo siŋgilatoqnqab. E naŋgi qa dego ni pailmonum. ");
INSERT INTO boj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Abu, ni ijoq di unum. E dego inoq di unum. Aqo aiyel are qujaitosim unum. Ijo segi tamo uŋgasari kalil naŋgi dego aqo aiyel koba na are qujaitosim sqajqa deqa e ni pailmonum. Yimqa mandam qaji tamo uŋgasari naŋgi qalieqab, ni na e qariŋbonam bem. ");
INSERT INTO boj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aqo aiyel are qujaitosim unum. Ñam koba ni na ebem qaji di e kamba olo ijo segi tamo uŋgasari naŋgi enjrem. Di kiyaqa? Naŋgi dego aqo aiyel koba na are qujaitosim sqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","E ijo segi tamo uŋgasari naŋgoq di unum. Ni ijoq di unum. Kumbra dena naŋgi kalil dego aqo aiyel koba na are qujaitosim sqom. Soqnimqa mandam qaji tamo uŋgasari naŋgi na naŋgi unjrsibqa qalieqab, ni na e qariŋbonam bem. Osib qalieqab, ni e qalaqalaibeqnum dego kere ni ijo segi tamo uŋgasari naŋgi qalaqalainjreqnum. ");
INSERT INTO boj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Abu, tamo uŋgasari ni na ebem qaji qure e sqai di naŋgi dego e ombla qure dia sqom. E deqa ni pailmonum. Naŋgi e ombla sosibqa ñam koba ni na ebem qaji di unqajqa deqa ti e ni pailmonum. Nami ni mandam atosaisosimqa ñam koba di e ebem. Di kiyaqa? Ni na e qalaqalaiboqnem deqa. ");
INSERT INTO boj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Abu, ino kumbra kalil tulaŋ bole tiŋtiŋ. Mandam qaji tamo uŋgasari naŋgi ni qa qaliesai. Ariya e ni qa qalie bole. Ijo segi tamo uŋgasari naŋgi dego ni qa qalie bole. Deqa naŋgi qalieonub, ni na e qariŋbonam bem. ");
INSERT INTO boj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","E ino ñam naŋgi osornjroqnem. Naŋgi olo osornjrqai. Yimqa ni na e qalaqalaibeqnum dego kere naŋgi ino qalaqalaiyo kumbraq di sqab. Amqa e segi naŋgi koba na sqom.” ");
INSERT INTO boj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus a degsi Qotei pailyosiq koboonaqa a na aqa aŋgro naŋgi joqsiqa koba na walwelosib Kidron ya dosib taqal beiq aisib nañu agu beiq di soqneb. ");
INSERT INTO boj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Bati gaigai Yesus aqa aŋgro naŋgi koba na nañu agu dia korooqneb. Deqa Yesus aqa aŋgro Judas agi Yesus osim jeu tamo naŋgo baŋq di atqas qaji a nañu agu di qaliesoqnej. ");
INSERT INTO boj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Deqa a na qaja tamo gargekoba naŋgi waŋal ti lam ti sebru ti eleŋonab joqsiqa nañu agu deq gileb. Atra tamo kokba ti Farisi ti naŋgi na naŋgi qariŋnjrnab Yesus ojqa gileb. Rom naŋgo qaja tamo qudei dego naŋgi koba na gileb. ");
INSERT INTO boj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gulbe kalil Yesus aqaq di brantqas qaji di a nami qaliesoqnej. Deqa qaja tamo naŋgi aqaq bonabqa a naŋgo areq aisiqa nenemnjrej, “Niŋgi yai qa bonub?” ");
INSERT INTO boj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Onaqa naŋgi na kamba minjeb, “Iga Yesus Nasaret qaji a qa bonum.” Onaqa Yesus na minjrej, “E agiende.” Judas agi Yesus osiqa qaja tamo naŋgo baŋq di atej qaji a naŋgi koba na tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Onaqa naŋgi Yesus aqa anjam di qusibqa qore na ululoŋosib ŋereŋeb. ");
INSERT INTO boj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Onaqa Yesus na olo nenemnjrej, “Niŋgi yai qa bonub?” Onaqa naŋgi na minjeb, “Iga Yesus Nasaret qaji a qa bonum.” ");
INSERT INTO boj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Onaqa Yesus na minjrej, “E nami merŋgonum, e agiende. Niŋgi e qa bonub di e segi ojiy. Ijo aŋgro naŋgi uratnjrib gileb.” ");
INSERT INTO boj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesus a naŋgi degsi minjrej deqa aqa anjam bei nami marej qaji di aqa damu brantej. Agi a nami endegsi marej, “O Abu, tamo naŋgi ni na ebem qaji bei e uratit padalqasai.” ");
INSERT INTO boj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Onaqa jeu tamo naŋgi Yesus ojeqnab Saimon Pita na aqa sebru osiqa atra tamo gate aqa kaŋgal tamo bei gateq di qalqajqa waiyej grotosiqa dabkala segi gentetej. Kaŋgal tamo di aqa ñam Malkus. ");
INSERT INTO boj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Onaqa Yesus na Pita minjej, “Ino sebru olo ate. E jaqatiŋ koba oqai. Jaqatiŋ di ya uge uyo bul. Di uyqai. Ijo Abu na merbej, ‘Ni jaqatiŋ di oqam.’” ");
INSERT INTO boj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Onaqa qaja tamo naŋgi ti naŋgo gate koba a ombla na Yesus ojsib aqa baŋ tonteteb. ");
INSERT INTO boj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Osib Kaiafas aqa sou Anas aqa talq osib aiyeb. Kaiafas a wausau deqa Juda naŋgo atra tamo gate soqnej. ");
INSERT INTO boj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Agi a nami Juda tamo kokba naŋgi minjrej, “Tamo qujai a tamo uŋgasari kalil naŋgi qa moiqas di kere.” ");
INSERT INTO boj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Qaja tamo naŋgi Yesus osi aiyeqnabqa Saimon Pita a qoreq na Yesus dauryosiq aiyej. Yesus aqa aŋgro bei dego a dauryosiq aiyej. Aŋgro di atra tamo gate a qalie. Deqa a Yesus dauryosiq torei jeŋ miligiq gilsiq atra tamo gate aqa talq di brantej. ");
INSERT INTO boj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ariya Pita a siraŋme qala oqeq di tigelesoqnej. Onaqa Yesus aqa aŋgro agi atra tamo gate a qaliesoqnej qaji a na siraŋme taqato uŋa minjnaqa odyonaqa Pita osiq ombla na jeŋ miligiq gilsib tal qalaq di tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Onaqa siraŋme taqato uŋa a na Pita nenemyej, “Ni Yesus aqa aŋgro kiyo?” Onaqa Pita na kamba minjej, “Eo. E aqa aŋgro sai.” ");
INSERT INTO boj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kaŋgal tamo naŋgi ti tal taqato tamo naŋgi ti yornjrnaqa ŋam tuŋguyosib ŋamyuwo areq di tigelesosib ŋam yoroqneb. Onaqa Pita a dego bosiq naŋgi koba na tigelesosib ŋam yoroqneb. ");
INSERT INTO boj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bati deqa atra tamo gate a anjam gargekoba Yesus nenemyoqnej. Yesus aqa aŋgro naŋgi qa ti aqa anjam a na tamo uŋgasari naŋgi minjroqnej qaji deqa ti nenemyoqnej. ");
INSERT INTO boj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Onaqa Yesus na kamba minjej, “E boleq di tamo uŋgasari naŋgi anjam minjroqnem. E bati gaigai Qotei tal miligiq di, atra tal miligiq di, Juda naŋgo koro sawaq di anjam palontoqnsim minjroqnem. E uliosim anjam minjrosaioqnem. ");
INSERT INTO boj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Deqa ni kiyaqa e nenemkobaibeqnum? Tamo uŋgasari ijo anjam quoqneb qaji naŋgi segi nenemnjrimqa naŋgi na mermqab. E anjam minjroqnem qaji di naŋgi qalie.” ");
INSERT INTO boj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus a atra tamo gate degsi minjnaqa qaja tamo bei Yesus aqa areq di tigelesoqnej qaji a baŋ lubtosiqa Yesus aqa ulatamuq di qalej. Osiqa minjej, “Ni kiyaqa atra tamo gate aqa medabu ojonum?” ");
INSERT INTO boj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Onaqa Yesus na kamba minjej, “E anjam maronum endi gisaŋamqa ubtosim merbe. Ariya ijo anjam boleamqa ni kiyaqa e lubonum?” ");
INSERT INTO boj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Onaqa Anas na aqa qaja tamo naŋgi minjrnaqa Yesus osib atra tamo gate Kaiafas aqaq gileb. Yesus aqa baŋ tonto qorbi sonaq osi gileb. ");
INSERT INTO boj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita a ŋamyuwo areq di tigelesosiq ŋam yoreqnaqa tamo qudei na minjeb, “Ni dego Yesus aqa aŋgro bei kiyo?” Onaqa Pita a saidosiq minjrej, “Eo. E aqa aŋgro sai.” ");
INSERT INTO boj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Onaqa atra tamo gate aqa kaŋgal tamo bei na Pita minjej, “E ni kiyo Yesus ombla nañu aguq di sonam numonum?” Tamo di agi Pita na tamo dabkala gentetej qaji aqa was. ");
INSERT INTO boj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Onaqa Pita a olo saidosiq minjej, “Di e sai.” Pita a degsi gisaŋoqalubtonaqa tuwe anjamej. ");
INSERT INTO boj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Onaqa nobqolo malu qameqnaq Juda tamo kokba naŋgi na Kaiafas aqa talq dena Yesus osib Rom naŋgo mandor Pailat aqa tal kobaqujaq gileb. Naŋgi tal miligiq gilosai. Naŋgi endegsib are qaleb, “Pailat a Juda tamo sai. A sawa bei qaji tamo. Deqa iga aqa tal miligiq gilqa getento. Gago dal anjam degsi unu. Iga aqa tal miligiq gilqom di iga une ti sqom. Deqa gago yori bati koba brantimqa iga iŋgi uyqa keresaiigwas.” Naŋgi degsib are qalsib deqa naŋgi Pailat aqa tal miligiq gilosai. ");
INSERT INTO boj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Naŋgi oqeq di tigelesonabqa Pailat a segi oqedosiq naŋgoq di brantej. Brantosiqa nenemnjrej, “Tamo endi aqa une kiye qa niŋgi a osib ijoq bonub?” ");
INSERT INTO boj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Onaqa naŋgi na Pailat minjeb, “Tamo endi a kumbra uge yosai qamu iga inoq osi bosai qamu.” ");
INSERT INTO boj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Onaqa Pailat na olo minjrej, “Niŋgi a olo osi aisib nuŋgo segi dal anjam na aqa une qa pegiyiy.” Onaqa naŋgi na kamba Pailat minjeb, “Iga Juda tamo. Deqa iga na tamo moiyotqa keresai.” ");
INSERT INTO boj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Naŋgi Pailat degsib minjeb deqa anjam bei Yesus a nami marej qaji di aqa damu brantej. Agi Yesus a gam kiye na moiqas di a segi nami ubtej. ");
INSERT INTO boj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Onaqa Pailat a olo puluosiqa aqa tal miligiq gilsiq aqa qaja tamo naŋgi minjrnaqa naŋgi na Yesus osib aqa areq beb. Bonabqa Pailat na nenemyej, “Ni Juda naŋgo Mandor Koba e?” ");
INSERT INTO boj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Onaqa Yesus na kamba minjej, “Ni ino segi areqalo na anjam di merbonum kiyo tamo qudei na e qa saimonub qusim anjam di merbonum kiyo? Ni e merbe.” ");
INSERT INTO boj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Onaqa Pailat na olo minjej, “E Juda tamo e? Sai. Ni que. Ino segi leŋ agi Juda naŋgi ti atra tamo kokba ti naŋgi na ni osib ijoq bonub. Deqa ni merbe. Ni une kiye yonum deqa ni osi bonub?” ");
INSERT INTO boj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Onaqa Yesus na minjej, “E mandam qaji mandor sosai. Degsi so qamu Juda naŋgi na e ojeqnab ijo wau tamo naŋgi ŋiriŋosib qoto itnjreb qamu.” ");
INSERT INTO boj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Onaqa Pailat na olo Yesus nenemyej, “Ni bole mandor e?” Onaqa Yesus na minjej, “Od, ni kere merbonum. E mandor. E anjam bole ubtqajqa deqa mandamq aisim ŋambabem. Tamo kalil anjam bole dauryeqnub qaji naŋgi ijo anjam queqnub.” ");
INSERT INTO boj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Onaqa Pailat na nenemyej, “Anjam bole di kiye?” Pailat a degsi marsiqa olo oqedosiqa Juda tamo kokba naŋgoq gilsiqa minjrej, “E tamo endi aqa jejamuq di une bei unosai. ");
INSERT INTO boj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Deqa e nuŋgo kumbra bei dauryqai. Wausau gaigai nuŋgo yori bati koba branteqnaqa e na tamo qujai tonto talq dena uratoqnsim eŋgeqnum. Deqa niŋgi na merbiy. Wausau endeqa e tamo yai uratosiy eŋgwai? E Juda naŋgo mandor endi uratosiy eŋgwai e?” ");
INSERT INTO boj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Onaqa Juda tamo kokba naŋgi olo tulaŋ saidosib minjeb, “Ni a uratim oqedaiq. Tonto tamo Barabas a uratim oqedem.” Naŋgi Pailat degsib minjeb. Barabas a leŋ ojo tamo. ");
INSERT INTO boj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Onaqa Pailat a Yesus osiqa aqa qaja tamo naŋgo baŋq di atsiqa minjrej, “Niŋgi Yesus bu toqoŋ na kumbaiŋyiy.” Degsi minjrnaqa naŋgi na Yesus osib bu toqoŋ na kumbaiŋyeb. ");
INSERT INTO boj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kumbaiŋyosib koboonaqa naŋgi na sil luwit osib lulumosib dena mandor kokba naŋgo gate tatal bul gereiyosib aqa gateq di atetosib siŋgila na teqiyeb. Osib gara jugo olekoba lent mandor kokba naŋgi gaigai jigeqnub deqaji bei osib Yesus jigeteb. A segi qa Mandor Koba maroqnej deqa naŋgi na kumbra degyeb. ");
INSERT INTO boj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Osib naŋgi Yesus aqa areq bosib a misiliŋyoqnsib gisaŋ na biŋiyoqnsib minjoqneb, “O Juda naŋgo Mandor Koba, kaiye.” Naŋgi degsib Yesus misiliŋyoqnsib baŋ lubtosib aqa ulatamuq di qaloqneb. ");
INSERT INTO boj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Onaqa Pailat a olo aqa talq dena oqedosiqa Juda tamo kokba naŋgi minjrej, “Niŋgi uniy. E Yesus aqa jejamuq di une bei yala unosai bole sai. Niŋgi di qalieqajqa deqa e Yesus olo nuŋgoq osi bonum.” ");
INSERT INTO boj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Degsi minjrnaqa Yesus a oqedej. Gate tatal sil luwit na gereiyosib aqa gateq di ateteb qaji de ti gara lent a jigeteb qaji de ti qorbi oqedej. Onaqa Pailat na minjrej, “Niŋgi tamo endi uniy.” ");
INSERT INTO boj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Degsi minjrnaqa atra tamo kokba ti naŋgo qaja tamo naŋgi ti Yesus unsibqa naŋgi murqumyoqnsib Pailat waiŋyoqnsib minjoqneb, “Ni a ŋamburbasq di qame! Ni a ŋamburbasq di qame!” Onaqa Pailat na minjrej, “Niŋgi segi na Yesus osib ŋamburbasq di qamiy. E aqa jejamuq di une bei unosai.” ");
INSERT INTO boj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Onaqa Juda tamo kokba naŋgi na olo Pailat minjeb, “Yesus a segi qa marqo, ‘E Qotei aqa Ŋiri.’ Aqa une deqa a moiyem. Gago dal anjam degsi unu.” ");
INSERT INTO boj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Onaqa Pailat a naŋgo anjam di qusiqa a tulaŋ ulaugetej. ");
INSERT INTO boj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Osiqa a olo Yesus osiq tal miligiq gilsiqa nenemyej, “Ni sawa qabe qaji? Ni e merbe.” Onaqa Yesus a mequmesoqnej. A na kamba anjam bei Pailat minjosai. ");
INSERT INTO boj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Deqa Pailat na olo minjej, “Ni anjam bei merbqasai e? Ni que. E tamo kobaquja. Deqa e ni uratmit ni gilqam. E ni uratmqasai di ni ŋamburbasq di gaiŋosim moiqam. Ni degsi poimosai e?” ");
INSERT INTO boj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Onaqa Yesus na Pailat minjej, “Qotei laŋ qureq di unu qaji a na ni siŋgila emosai qamu ni e gulbe bei ebqa keresai qamu. Deqa ino une kiñala. Ariya atra tamo gate agi e ojsiq ino baŋq di atqo qaji aqa une kobaquja.” ");
INSERT INTO boj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesus na Pailat degsi minjnaq qusiqa olo oqedosiqa Juda tamo kokba naŋgi minjrej, “Uŋgum. E Yesus uratit gilqas.” A naŋgi degsi minjreqnaqa naŋgi na olo tulaŋ saidoqnsib murqumyoqnsib minjoqneb, “Ni Yesus uratim gilaiq. Ni a uratqam di ni mandor koba Sisar aqa wau tamo bolesai. Yesus a marqo, ‘E segi mandor koba.’ A degsi marqo deqa a na Sisar jeu atqo.” ");
INSERT INTO boj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Naŋgi na Pailat degsib minjeqnab qusiqa a olo Yesus osiq oqedosiqa aqa awo jaram kobaq di awoej. Pailat a gaigai tamo naŋgo une qa peginjrqa oqnsiq dia awooqnej. Jaram so qaji sawa di aqa ñam Meniŋ Bijal. Hibru anjam na “Gabata” mareqnub. ");
INSERT INTO boj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Juda naŋgo yori bati koba brantqa laqnej deqa yori bati aqa iŋgi iŋgi kalil gereiyosib atnab soqnej. Seŋ bati 12 onaq qanam jigeej. Deqa Pailat na Yesus osiqa Juda tamo kokba naŋgi minjrej, “Niŋgi nuŋgo mandor koba uniy.” ");
INSERT INTO boj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Onaqa naŋgi tulaŋ leleŋoqnsib minjoqneb, “Ni a taqal waiy! Osim ŋamburbasq di qame!” Onaqa Pailat na nenemnjrej, “E nuŋgo mandor koba osiy ŋamburbasq di qamqai e?” Onaqa atra tamo kokba naŋgi na kamba minjeb, “Gago mandor bei saiqoji. Gago mandor qujai agi Sisar.” ");
INSERT INTO boj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Onaqa Pailat a naŋgo areqalo dauryosiqa Yesus osiq naŋgo baŋq di atsiqa minjrej, “Niŋgi na Yesus osib ŋamburbasq di qamiy.” ");
INSERT INTO boj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pailat a Juda tamo kokba naŋgi degsi minjrnaqa qaja tamo naŋgi Yesus osib aqa qawarq di aqa segi ŋamburbas atetosib a baŋ ojsib Jerusalem uratosib osi gilsib sawa agu kiñala bei aqa ñam Tamo Gate Tanu di branteb. Ñam di Hibru anjam na “Golgota” mareqnub. ");
INSERT INTO boj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Di brantosib Yesus osib ŋamburbasq di qameb. Tamo aiyel dego ŋamburbasq di qameleŋeb. Yesus a ambleq di tigeltosib tamo bei aqa baŋ qonaŋq di tigelteb. Bei aqa baŋ woq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Onaqa Pailat a anjam bei neŋgreŋyosiq ŋamburbas mutu gogeq di atej. A endegsi neŋgreŋyej, “Yesus Nasaret qaji a Juda naŋgo Mandor Koba.” ");
INSERT INTO boj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sawa agu Yesus ŋamburbasq di gainteb qaji di Jerusalem jojom. Deqa Juda tamo uŋgasari gargekoba naŋgi gile beoqnsib anjam Pailat na neŋgreŋyej qaji di sisiyoqneb. Anjam di Hibru anjam na ti Rom naŋgo anjam na ti Grik naŋgo anjam na ti turtosiq neŋgreŋyej. ");
INSERT INTO boj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Onaqa Juda naŋgo atra tamo kokba naŋgi na Pailat minjeb, “‘Yesus a Juda naŋgo Mandor Koba’ anjam degsi neŋgreŋyaim. ‘A marej, “E Juda naŋgo Mandor Koba,” ’ anjam degsi neŋgreŋye.” ");
INSERT INTO boj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Onaqa Pailat na minjrej, “Uŋgum. E anjam neŋgreŋyonum degesoqnem.” ");
INSERT INTO boj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ariya qaja tamo naŋgi na Yesus ŋamburbasq di qamsibqa aqa gara eleŋqa marsib gilteleŋeb. Gilteleŋosib tumbol qolqe ateb. Aqa gara jugo olekoba di gara baŋga qujai na gereiyeb. Gara baŋga bei na totoryosai. Gara di tulaŋ boledamu. ");
INSERT INTO boj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Deqa qaja tamo naŋgi segi segi qairosib mareb, “Iga gara di bumbraŋyqasai. Iga meniŋ silali alaŋonam tamo yai aqa meniŋ na buŋnjrqas a na gara di oqas.” Degsib marsib meniŋ silali alaŋeb. Naŋgi kumbra di yeb deqa Qotei aqa anjam bei neŋgreŋq di unu qaji di aqa damu brantej. Anjam agiende, “Naŋgi ijo gara eleŋqa marsib gilteleŋqab. Gilteleŋosib meniŋ silali alaŋqab.” ");
INSERT INTO boj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesus aqa ai wo aqa ai yala wo ŋamburbas utruq di tigelesoqneb. Maria Makdala qure qaji wo Klopas aqa ŋauŋ Maria wo naŋgi aiyel dego bosib koba na tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Onaqa Yesus a tirosiqa aqa ai wo aqa aŋgro agi a tulaŋ qalaqalaiyoqnej qaji de wo ŋamburbas utruq di tigelesonab unjrsiqa aqa ai metosiq minjej, “O ai, di ino aŋgro.” ");
INSERT INTO boj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Osiqa aŋgro di minjej, “Di ino ai.” Onaqa bati qujai deqa aŋgro dena Yesus aqa ai osiqa aqa segi talq di ombla sosibqa taqatoqnej. ");
INSERT INTO boj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus a qalieej, wau kalil aqa Abu na yej qaji di kobotej. Osiqa marej, “E ya qarbqo.” A degsi marej. Di kiyaqa? Qotei aqa anjam bei neŋgreŋq di so qaji di aqa damu brantqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Onaqa qaja tamo naŋgi Yesus aqa anjam di qusibqa gara ñeŋgi bei osib wain isa kobaq di tuqteb. Tuqtosib ŋamtaŋ bei aqa dani osib mutuq di gara ñeŋgi qosisib osib Yesus anaiyqajqa soqtosib aqa medabuq di ateb. Wain di ya nobu bei ŋamburbas utruq di nami atnab soqnej qaji dena tigsib Yesus anaiyeb. ");
INSERT INTO boj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Onaqa Yesus a wain isa koba di uysiqa marej, “Bini e ijo wau kobotonum.” Degsi marsiqa aqa gate gulaiŋosiqa mondor titosiq moiyej. ");
INSERT INTO boj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Juda naŋgo yori bati koba brantqa laqnej deqa yori bati aqa iŋgi iŋgi kalil gereiyosib atnab soqnej. Nebe yori bati. Deqa Juda naŋgi mareb, “Iga yori bati qa tamo naŋgi ŋamburbasq di uratnjrim sqasai.” Osib naŋgi Pailat aqa areq bosib minjeb, “Ni ino qaja tamo naŋgi minjrimqa gilsib tamo ŋamburbasq di gaiŋejunub qaji naŋgo siŋga gentetnjribqa urur moreŋabqa osib subq atqab.” ");
INSERT INTO boj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Onaqa Pailat a naŋgo anjam di qusiqa odosiq aqa qaja tamo qudei qariŋnjrnaq gilsib tamo aiyel Yesus koba na ŋamburbasq di gaiŋesoqneb qaji naŋgo siŋga gentetnjreb. ");
INSERT INTO boj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Osib Yesus aqa areq gilsib uneb a nami moiyej. Deqa naŋgi aqa siŋga gentosai. ");
INSERT INTO boj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Onaqa qaja tamo bei na aqa qaja osiq Yesus aqa jar baŋgaq di qamnaq leŋ ti ya ti aiyej. ");
INSERT INTO boj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Naŋgi kumbra di yonabqa e ijo segi ŋamdamu na unem. E kumbra deqa saoqnsim laqnum. E segi qalieonum, ijo anjam bole. Deqa niŋgi qusib nuŋgo areqaloq di siŋgilatiy. ");
INSERT INTO boj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Qaja tamo naŋgi kumbra di yeb deqa Qotei aqa anjam bei neŋgreŋq di so qaji di aqa damu brantej. Agi endegsib neŋgreŋyeb, “Naŋgi aqa tanu bei gentqasai.” ");
INSERT INTO boj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qotei aqa anjam bei dego aqa damu brantej. Anjam agiende, “Naŋgi qaja na aqa jar baŋgaq di qamsibqa a koqyesqab.” ");
INSERT INTO boj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Onaqa tamo bei aqa ñam Josep a Yesus aqa jejamu osim subq atqa marsiqa Pailat a nenemyqa gilej. Josep a Arimatea qure qaji. A Yesus dauryoqnej qaji. A Juda tamo kokba naŋgi ulainjrsiq deqa uliosiq Yesus dauryoqnej. A boleq di dauryosaioqnej. Ariya a Pailat aqa areq gilsiqa nenemyej, “Ni e odbimqa e Yesus aqa jejamu osiy subq atqa kere e?” Onaqa Pailat na Josep odyonaqa a Yesus aqa jejamu osiq subq atqa gilej. ");
INSERT INTO boj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus agi nami qolo Yesus aqaq gilej qaji a dego Josep ombla na Yesus aqa jejamu osib subq atqa gileb. Nikodemus a gilqa osiqa ŋam so aqa ya quleq ti utru aiyela turtosiq gereiyosiq osi gilej. Ŋam so aqa ya di aqa gulbe 30 kilogram. ");
INSERT INTO boj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Onaqa naŋgi aiyel Yesus aqa jejamu osib gara boledamu na dalaosib ŋam so aqa ya di osib aqa jejamuq di liyeb. Juda naŋgi na tamo subq atqa oqnsib degyeqnub. ");
INSERT INTO boj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sawa Yesus ŋamburbasq di qameb qaji qalaq di nañu agu bei soqnej. Nañu agu dia sub bunuj bei soqnej. Sub dia nami tamo bei atosaisoqneb. ");
INSERT INTO boj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sub di isaq di sosai. A jojom di soqnej. Juda naŋgo yori bati aqa iŋgi iŋgi kalil gereiyqa bati brantej deqa naŋgi aiyel na Yesus aqa jejamu osib sub miligiq di jugeb. ");
INSERT INTO boj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yesus a subq di sonaq yori batiej. Olo nebeonaqa nobqolo ambru Maria Makdala qure qaji a tigelosiqa Yesus aqa subq gilej. Gilsiq ŋam atej meniŋ kobaquja sub me getenteb qaji di waqosiq taqal di sonaq unej. ");
INSERT INTO boj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Unsiqa olo puluosiq urur ti aisiq Saimon Pita wo Yesus aqa aŋgro agi a tulaŋ qalaqalaiyoqnej qaji de wo naŋgi aiyel itnjrsiqa minjrej, “Gago Tamo Koba aqa jejamu subq dena osib jaraiyonub. Qabia kiyo atonub di iga qaliesai.” ");
INSERT INTO boj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Degsi minjrnaqa Pita aŋgro de wo naŋgi anjam di qusibqa Yesus aqa sub unqajqa gileb. ");
INSERT INTO boj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Naŋgi aiyel gurgurosib giloqnsib aŋgro dena Pita buŋyosiqa namoosi gilsiq subq di brantej. ");
INSERT INTO boj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Osiq sub meq di tigelosiqa miligi tirosiq gara Yesus dalaeb qaji di sonaq unej. A sub miligiq aiyosai. ");
INSERT INTO boj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Onaqa Saimon Pita a bunuqna bosiq torei sub miligiq aiyej. Aisiq a dego gara Yesus dalaeb qaji di unej. ");
INSERT INTO boj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Gara mutu bei Yesus aqa gate qoseteb qaji di lubosiq taqal beiq di sonaq unej. Gara mutu di gara qudei ti turtosiq sosai. A segiq di soqnej. ");
INSERT INTO boj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Onaqa aŋgro namo subq di brantej qaji a dego sub miligiq aiyej. Aisiq gara di unsiq marej, “Bole.” ");
INSERT INTO boj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bati deqa naŋgi aiyel Qotei aqa anjam bei neŋgreŋq di so qaji di aqa utru geregere poinjrosaisoqnej. Anjam agiende, “Kristus a olo subq na tigelqas.” ");
INSERT INTO boj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ariya naŋgi olo puluosib naŋgo qureq aiyeb. ");
INSERT INTO boj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Onaqa Maria a sub qalaq di tigelesosiqa akamoqnej. Akamoqnsiqa sub miligi tirej. ");
INSERT INTO boj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tirosiqa laŋ aŋgro aiyel sub miligiq di sonab unjrej. Naŋgi gara qat jigsib Yesus ŋeioteb qaji lumeq di awesoqneb. Bei gateqsi bei siŋgaqsi awesoqneb. ");
INSERT INTO boj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Awesosibqa Maria minjeb, “Uŋa, ni kiyaqa akameqnum?” Onaqa minjrej, “Naŋgi ijo Tamo Koba osib jaraiyonub. Qabia kiyo atonub di e qaliesai.” ");
INSERT INTO boj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria a naŋgi degsi minjrsiq bulosiqa aqa qoreq di Yesus a tigelesonaq unej. A qaliesai, di Yesus. ");
INSERT INTO boj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Onaqa Yesus na Maria minjej, “O uŋa, ni kiyaqa akameqnum? Ni yai unqa bonum?” Onaqa Maria a are qalej, “Tamo endi a nañu agu taqateqnu kiyo?” Degsi are qalsiq minjej, “Ni na kiyo ijo Tamo Koba osim sawa qabia atonum di merbimqa e gilsiy oqai.” ");
INSERT INTO boj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Onaqa Yesus na minjej, “O Maria.” Degsi minjnaqa Maria a Yesus qa poiyonaqa areiyosiq minjej, “O Rabonai.” Di Hibru anjam. Aqa damu, “O Qalie Tamo Koba.” ");
INSERT INTO boj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Onaqa Yesus na Maria minjej, “E ijo Abu aqaq oqosaiunum deqa ni e ojaim. Ni ijo was naŋgoq gilsim endegsi minjre, ‘Yesus a marqo, “E ijo Abu aqaq olo oqwai. Ijo Abu agi nuŋgo Abu dego. Ijo Qotei agi nuŋgo Qotei dego.” ’ Ni gilsim naŋgi degsi minjre.” ");
INSERT INTO boj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Onaqa Maria Makdala qaji a Yesus aqa anjam di qusiqa gilsiq Yesus aqa aŋgro naŋgi itnjrsiqa minjrej, “E gago Tamo Koba a unonum.” Osiqa anjam kalil Yesus na minjej qaji di olo naŋgi sainjrej. ");
INSERT INTO boj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yori bati koboosiq bilaqtonaqa Yesus aqa aŋgro naŋgi tal bei gogetosib siraŋme kalil qandimteleŋosib warum miligiq di soqneb. Naŋgi Juda tamo kokba naŋgi ulainjrsib deqa degyeb. Onaqa bati qujai deqa Yesus a tal miligiq di brantosiqa naŋgo ambleq di tigelosiq minjrej, “O ijo aŋgro, niŋgi are lawo soqniy.” ");
INSERT INTO boj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Osiqa aqa baŋ ti jar baŋga ti naŋgi osornjrej. Onaqa naŋgi kalil Tamo Koba a unsibqa tulaŋ areboleboleinjrej. ");
INSERT INTO boj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Onaqa Yesus na olo minjrej, “Niŋgi are lawo soqniy. Ijo Abu na e qariŋbej dego kere e niŋgi qariŋgeqnum.” ");
INSERT INTO boj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesus na aqa aŋgro naŋgi anjam degsi minjrsiqa aqa mondor puynjrsiqa minjrej, “Niŋgi Qotei aqa Mondor Bole oiy. ");
INSERT INTO boj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Niŋgi tamo uŋgasari naŋgo une kobotetnjrqab di Qotei a dego naŋgo une kobotetnjrqas. Ariya niŋgi tamo uŋgasari naŋgo une kobotetnjrqasai di Qotei a dego naŋgo une kobotetnjrqasai.” ");
INSERT INTO boj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesus a naŋgoq di brantej di Tomas a naŋgi koba na sosai. Tomas a Yesus aqa aŋgro 12 deqaji bei. Aqa ñam bei Didimus. ");
INSERT INTO boj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Onaqa Yesus aqa aŋgro naŋgi gilsib Tomas itosib minjeb, “Iga gago Tamo Koba a unonum.” Degsi minjnabqa a naŋgo anjam di qunaq ugeiyonaq minjrej, “E ijo ŋamdamu na Yesus aqa baŋ bile tutu na qameb qaji pirigi di unsiy ojqai di e marqai, ‘Bole.’ E aqa jar baŋga qaja na qameb qaji pirigi di dego unsiy ojqai di e marqai, ‘Bole.’ E unqasai di e bole qa marqasai.” ");
INSERT INTO boj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ariya bati 7 koboonaqa Yesus aqa aŋgro naŋgi olo tal miligiq di soqneb. Tomas a dego naŋgi koba na soqneb. Siraŋme kalil qandimesonabqa Yesus a tal miligiq di brantosiqa naŋgo ambleq di tigelosiq minjrej, “O ijo aŋgro, niŋgi are lawo soqniy.” ");
INSERT INTO boj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Osiqa Tomas minjej, “O Tomas, ni ino baŋ gei na ijo baŋ bile qameb qaji pirigi ojsim unime. Ino baŋ waiyosim ijo jar baŋga qameb qaji pirigi dego oje. Areqalo aiyeltaim. Areqalo qujaitosim e qa ino areqalo siŋgilat.” ");
INSERT INTO boj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Onaqa Tomas na Yesus minjej, “O Yesus, ni ijo Tamo Koba. Ni ijo Qotei dego.” ");
INSERT INTO boj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Onaqa Yesus na olo Tomas minjej, “Ni ino ŋamdamu na e nubsim deqa ino areqalo e qa siŋgilatonum e? Ariya tamo uŋgasari naŋgo ŋamdamu na e nubosaieqnub qaji naŋgi e qa naŋgo areqalo siŋgilatqab di naŋgi tulaŋ areboleboleinjrqas.” ");
INSERT INTO boj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus a Qotei aqa maŋwa tulaŋ gargekoba aqa aŋgro naŋgo ŋamdamuq di yoqnej. E aqa maŋwa quja quja segi buk miligiq endi neŋgreŋyonum. ");
INSERT INTO boj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","E anjam endi neŋgreŋyonum. Di kiyaqa? Niŋgi sisiyosib Yesus qa nuŋgo areqalo siŋgilatosib a bole Kristus Qotei aqa Ŋiri degsi poiŋgwajqa deqa. Osib niŋgi Yesus aqa ñam na ŋambile gaigai sqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Onaqa bati bei Yesus a Taiberias ya agu qalaq di sosiqa aqa aŋgro naŋgoq di olo brantej. E deqa kiñala saqai. ");
INSERT INTO boj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ya agu qalaq di Yesus aqa aŋgro 7 naŋgi soqneb. Aŋgro bei Saimon Pita. Bei Tomas aqa ñam bei Didimus. Bei Nataniel. Nataniel aqa qure utru Kana. Kana a Galili sawaq di unu. Sebedi aqa ŋiri aiyel naŋgi dego ya agu qalaq di soqneb. Ariya Yesus aqa aŋgro aiyel dego naŋgi koba na soqneb. ");
INSERT INTO boj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Onaqa Saimon Pita na naŋgi minjrej, “E qe oqajqa deqa kakaŋ waiyqa aiyeqnum.” Onaqa naŋgi na minjeb, “Iga kalil koba na aiqom.” Degsi minjsib naŋgi koba na aisib qobuŋ gogetosib ya robuq oqsib kakaŋ waiyoqneb. Di qolo. Waiyeqnab nebeej. Naŋgi qe bei osai bole sai. ");
INSERT INTO boj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nobqolo ambru naŋgi qobuŋ miligiq di sosib ŋam ateb Yesus a alile di tigelesonaq uneb. Naŋgi qaliesai, di Yesus. ");
INSERT INTO boj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Deqa a na nenemnjrej, “O ijo aŋgro, niŋgi qe onub e?” Onaqa naŋgi na minjeb, “Eo. Iga qe osai.” ");
INSERT INTO boj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Onaqa minjrej, “Niŋgi qobuŋ aqa qala bei baŋ woq di kakaŋ waiyiy. Waiyosib niŋgi qe oqab.” Onaqa naŋgi Yesus aqa anjam di dauryosib baŋ woq di kakaŋ waiyeb qe tulaŋ ani eb. Qe di tulaŋ gargekoba deqa naŋgi na soqtosib qobuŋ goge di atqa keresaiinjrej. ");
INSERT INTO boj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Onaqa Yesus aqa aŋgro agi a tulaŋ qalaqalaiyoqnej qaji a na Pita minjej, “Tamo di gago Tamo Koba.” Onaqa Saimon Pita a anjam di qusiqa aqa gara jugo wauqa osiq piqtej qaji di olo jigsiqa qobuŋ dena prugosiq yaq aisiq qawaiŋosiq Yesus aqa areq gilej. ");
INSERT INTO boj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesus aqa aŋgro qobuŋ miligiq di soqneb qaji naŋgi alile jojom 100 mita. Deqa kakaŋ qe na maqesonaq naŋgi qobuŋ na titosib aisib alile di tiryeb. ");
INSERT INTO boj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Alile di tiryosib ŋam ateb di Yesus a nami ŋam tuŋguyosiq qe koitonaq ŋamyuwoq di sonaq uneb. Bem qudei dego sonaq uneb. ");
INSERT INTO boj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Deqa Yesus na minjrej, “Niŋgi qe onub di qudei osi boiy.” ");
INSERT INTO boj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Onaqa Pita a olo qobuŋ gogetosiqa kakaŋ qe ti titosiq alile di atej. Qe di kokba. Qe kalil sisiyeb 153. Di qe gargekoba. Ariya kakaŋ yala braŋosai. ");
INSERT INTO boj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Onaqa Yesus na minjrej, “Niŋgi bosib iŋgi uyiy.” Aŋgro bei na yala nenemyosai, “Ni tamo yai?” Degosai. Naŋgi qalie, di naŋgo Tamo Koba. ");
INSERT INTO boj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Onaqa Yesus a ŋamyuwo jojomyosiqa bem ti qe ti di osiq naŋgi anainjronaq uyeb. ");
INSERT INTO boj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus a subq na tigelosiqa aqa aŋgro naŋgoq di brantoaiyeltej. Bini qalubqo. ");
INSERT INTO boj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naŋgi iŋgi uynab koboonaqa Yesus na Saimon Pita nenemyej, “O Saimon, Jon aqa ŋiri, ni ijo aŋgro kalil naŋgi buŋnjrsimqa ni segi e tulaŋ qalaqalaibeqnum e?” Onaqa Pita na minjej, “Od, Tamo Koba, ni qalieonum, e ni qalaqalaimeqnum.” Onaqa Yesus na minjej, “Ni ijo kaja du du naŋgi gereinjrime.” ");
INSERT INTO boj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Osiqa olo Pita nenemyej, “O Saimon, Jon aqa ŋiri, ni e tulaŋ qalaqalaibeqnum e?” Onaqa Pita na minjej, “Od, Tamo Koba, ni qalieonum, e ni qalaqalaimeqnum.” Onaqa Yesus na minjej, “Ni ijo kaja naŋgi taqatnjrime.” ");
INSERT INTO boj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Osiqa olo nenemyej, “O Saimon, Jon aqa ŋiri, ni e qalaqalaibeqnum e?” Yesus na Pita anjam di nenemyoqalubtej deqa Pita a are gulbeiyonaq minjej, “O Tamo Koba, ni kumbra kalil qa qalie. Deqa ni qalieonum, e ni qalaqalaimeqnum.” Onaqa Yesus na olo minjej, “Ni ijo kaja naŋgi gereinjrime. ");
INSERT INTO boj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“O Pita, e bole mermqai. Ni aŋgro wala sosimqa ni ino segi areqalo dauryoqnsim sawa ni gilqajqa are soqnej qaji deq giloqnem. Ariya bunuqna ni qeliosimqa ino baŋ aiyel soqtim tamo bei na ni tontmosim sawa ni gilqajqa asgimqas qaji deq osi gilqas.” ");
INSERT INTO boj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pita aqa moiqajqa gam di Yesus na ubtosiqa degsi minjej. Pita a gam dena moiyim Qotei aqa ñam goge oqwas. Pita a di qalieqajqa deqa Yesus na degsi minjej. Osiqa Pita minjej, “Ni e daurbe.” ");
INSERT INTO boj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Osiqa Yesus a Pita ombla walweloqnsibqa Pita a bulosiqa aŋgro Yesus na tulaŋ qalaqalaiyoqnej qaji a naŋgi aiyel daurnjreqnaq unej. Aŋgro di agi nami Yesus aqa aŋgro naŋgi koba na iŋgi uyoqnsibqa a Yesus beteryosiq nenemyej, “O Tamo Koba, aŋgro yai na ni osim jeu tamo naŋgo baŋq di atqas?” ");
INSERT INTO boj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Deqa Pita a aŋgro di unsiqa Yesus nenemyej, “O Tamo Koba, bunuqna ino aŋgro di a kumbra kiye turqas?” ");
INSERT INTO boj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Onaqa Yesus na Pita minjej, “Aŋgro di a moiyosaisoqnimqa e olo bqai degsi minjitqa ni deqa are koba qalaim. Di ino wau sai. Di ijo wau. Ni e daurbe.” ");
INSERT INTO boj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesus na Pita degsi minjej. Deqa aŋgro di a moiqasai anjam di sawa sawaq gileqnaqa Kristen was kalil naŋgi quoqneb. Aŋgro di a moiqasai Yesus na Pita degsi minjosai. A na minjej, “Aŋgro di a moiyosaisoqnimqa e olo bqai degsi minjitqa ni deqa are koba qalaim.” ");
INSERT INTO boj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yesus aqa aŋgro di agi e segi. E na anjam endi neŋgreŋyonum. E ijo segi ŋamdamu na Yesus aqa kumbra kalil endi unsim deqa neŋgreŋyonum. Iga qalieonum, ijo anjam endi bole. ");
INSERT INTO boj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus a mandamq endi sosiqa a kumbra tulaŋ gargekoba yoqnej. Deqa e are qalonum, Yesus aqa kumbra kalil deqa neŋgreŋyqom di buk tulaŋ tumbol kobaosim sawa sawa kalilq di maqosim sawa atqa keresaiqas. ");
INSERT INTO boj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofilus, e nami anjam bei neŋgreŋyosim inoq qariŋyem. Kumbra kalil Yesus a yoqnej qaji deqa ti anjam kalil a na tamo uŋgasari naŋgi minjroqnej qaji deqa ti utruq na neŋgreŋyem. ");
INSERT INTO boj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Neŋgreŋyosim gilsimqa Qotei na Yesus osiq laŋ qureq oqej di patem. Yesus a laŋ qureq oqosaisosiqa aqa segi aŋgro giltnjrej qaji naŋgi koroinjrnaqa Mondor Bole na aqa medabu siŋgilatetonaqa minjrej, “Niŋgi ijo wau ojoqnsib ijo anjam mare mare laqniy.” ");
INSERT INTO boj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesus a jaqatiŋ osiq moisiq olo ŋambile sosiqa aqa aŋgro naŋgoq di brantoqnsiqa maŋwa gargekoba yeqnaqa naŋgi unoqneb. Unoqnsib maroqneb, “Bole.” Bati 40 qa a naŋgoq di brantoqnej. Brantoqnsiqa Qotei a tamo uŋgasari naŋgo Mandor Koba sosim naŋgi taqatnjrqas anjam di minjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Onaqa bati bei Yesus na aqa aŋgro naŋgi di olo koroinjrsiqa minjrej, “Niŋgi Jerusalem urataib. Ijo Abu aqa Mondor niŋgi nami eŋgwa marej qaji deqa tariŋoqnsib soqniy. E nami niŋgi deqa merŋgoqnem. ");
INSERT INTO boj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon a ya na tamo uŋgasari naŋgi yansnjroqnej. Ariya bati qudei koboamqa e Mondor Bole aqa siŋgila na niŋgi yansŋgwai.” ");
INSERT INTO boj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Onaqa bati bei Yesus a olo aqa aŋgro naŋgi koroinjrnaqa naŋgi na endegsib nenemyeb, “O Tamo Koba, bini bati endeqa kiyo ni na Rom naŋgo siŋgila kobotosim iga Israel tamo uŋgasari siŋgila egimqa iga kamba mandam endi taqatqom?” ");
INSERT INTO boj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Onaqa Yesus na minjrej, “Niŋgi bati di qalieqa maraib. Di nuŋgo wau sai. Di ijo Abu aqa wau. A segi na bati di giltej unu. ");
INSERT INTO boj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ariya Mondor Bole a nuŋgoq bamqa niŋgi siŋgila osib e qa anjam mare mare laqniy. Niŋgi Jerusalem endia, Judia sawaq di, Samaria sawaq di, sawa sawa kalil keretosib e qa anjam mare mare laqniy.” ");
INSERT INTO boj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus na aqa aŋgro naŋgi anjam degsi minjrsiqa a mandam uratosiq laŋ goge oqeqnaqa naŋgi a koqyesoqneb. Onaqa laŋbi na a kabutonaqa naŋgi a olo unosai. ");
INSERT INTO boj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Naŋgi laŋ goge tarosib ŋam ateqnabqa tamo aiyel gara qat jigeb qaji naŋgi bosib naŋgo areq di tigelosib minjreb, “O Galili tamo, niŋgi kiyaqa laŋ goge tarosib ŋam ateqnub? Yesus a niŋgi uratŋgsiqa laŋ goge oqeqnaq niŋgi unonub mondoŋ a degsim olo bqas.” ");
INSERT INTO boj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","13","Mana naŋgi soqneb qaji aqa ñam Oliv mana. Mana di Jerusalem jojomq di unu. Naŋgi dena olo puluosib Jerusalem aisib tal gogetosib naŋgo warum bei gogeqsi naŋgi gaigai soqneb qaji deq gileb. Yesus aqa aŋgro warum deq gileb qaji naŋgo ñam agiende. Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Alfius aqa ŋiri Jems, Jems bei aqa ŋiri Judas, Saimon agi nami Rom naŋgi winjrqajqa maroqnej qaji. Yesus aqa aŋgro 11 naŋgi di warum deq gileb. ");
INSERT INTO boj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naŋgi ti uŋgasari qudei ti Yesus aqa was naŋgi ti aqa ai Maria dego naŋgi koba na gaigai warum dia korooqnsibqa are qujaitoqnsib Qotei pailyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bati bei tamo uŋgasari 120 Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi koroosib sonabqa Pita a naŋgo ambleq di tigelosiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“O ijo was niŋgi quiy. Qotei aqa anjam bei neŋgreŋq di unu qaji di aqa damu bini brantqo. Anjam di aqa damu Qotei a nami brantqa marej deqa agi brantqo. Anjam di Qotei aqa Mondor na Devit minjnaq qusiqa neŋgreŋyonaq soqnej. A Judas qa neŋgreŋyej. Judas agi iga koba na sosimqa Yesus aqa wau ojoqnem. Niŋgi qalie, bunuqna a na jeu tamo naŋgi gam osornjrnaqa Yesus ojeb.” Pita a naŋgi anjam degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas aqa kumbra tulaŋ uge. Aqa kumbra uge agiende. Juda tamo kokba naŋgi na a silali yonabqa Yesus osiqa naŋgo baŋq di atej. A silali di osiqa mandam taqal bei awaiyej. Awaiyosiqa a mandam dia uloŋosiqa aqa mene paraonaqa bi bileŋej. ");
INSERT INTO boj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bunuqna tamo uŋgasari kalil Jerusalem di soqneb qaji naŋgi deqa qusibqa mandam di aqa ñam “Akeldama” waiyeb. Di naŋgo segi anjam na ñam waiyeb. Ñam di aqa damu, “Leŋ Aiqajqa Mandam.” ");
INSERT INTO boj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ariya Pita a olo marej, “Devit a nami Qotei louqa buk miligiq di Judas qa endegsi neŋgreŋyej, ‘Aqa tal laŋa sqas. Tamo bei na olo aqa tal oqasai.’ Osiqa olo Judas qa endegsi neŋgreŋyej, ‘Tamo bei na kamba aqa wau ojqas.’ ");
INSERT INTO boj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Deqa ijo was niŋgi quiy. Iga tamo bei giltonamqa a na Judas aqa sawa osim iga ti Yesus aqa wau ojqom. Iga nami Tamo Koba Yesus dauryosim laqnamqa bati deqa tamo naŋgi iga koba na soqnem deqaji bei giltqom. ");
INSERT INTO boj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon yansnjro qaji aqa bati qa Yesus na aqa wau utru atej dena bosi bosiq Qotei a Yesus yaigosiqa laŋ qureq oqej. Bati deqa tamo naŋgi iga koba na soqnem deqaji bei giltonamqa a iga ti Yesus aqa wau ojqom. Ojsimqa Yesus a moisiq olo subq na tigelej deqa mare mare laqnqom.” ");
INSERT INTO boj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita a naŋgi anjam degsi minjrnaqa naŋgi na tamo aiyel giltnjreb. Josep Matias wo giltnjreb. Josep aqa ñam bei Barsabas. Aqa ñam bei Jastas. ");
INSERT INTO boj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Naŋgi aiyel giltnjrsibqa endegsib pailyeb, “O Tamo Koba, ni tamo kalil naŋgo areqalo qalie. Deqa tamo aiyel endi ni yai giltqam di iga osorgimqa tamo dena Judas aqa sawa osim aqa wau ojqas. ");
INSERT INTO boj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas a wau di uratosiqa moisiq sawa uge ni nami a aiqajqa giltem qaji deq aiyej.” ");
INSERT INTO boj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naŋgi degsib pailyosib koboonaqa tamo yai na kamba Judas aqa wau ojqas deqa marsibqa meniŋ silali alaŋeb. Alaŋonabqa Matias aqa meniŋ na buŋyej. Deqa naŋgi Matias giltonabqa a Yesus aqa anjam maro tamo 11 naŋgi koba na sosib wauoqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","2","Onaqa Juda naŋgo yori bati koba ñam Pentikos di brantej. Juda naŋgo moma naŋgi nami iŋgi meli bunuj otoreleŋeb. Deqa olo are qalqajqa yori bati brantonaqa Yesus aqa tamo uŋgasari naŋgi tal qujaiq di koroosib soqneb. Sonabqa laŋ goge na jagwa koba anjam ato bulosiq tal naŋgi awesoqneb qaji deq aiyej. Aisiq tal keretej. ");
INSERT INTO boj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Onaqa iŋgi bei a ŋam puloŋ bulosiqa aisiq segi segiosiqa naŋgo gateq di awoeleŋonaq uneb. ");
INSERT INTO boj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bati deqa Mondor Bole a naŋgo segi segi are miligiq aisiq meŋ bulyetnjrnaqa naŋgi kalil qure utru segi segi naŋgo anjam mareleŋoqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bati deqa Juda tulaŋ gargekoba sawa sawa kalilq di ŋambabeb qaji naŋgi Jerusalem di soqneb. Naŋgi kalil Qotei qa louoqneb qaji. ");
INSERT INTO boj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","7","Jagwa koba di anjam ato bulonaqa naŋgi kalil queb. Qusibqa maŋwa di unqajqa bosib koroeb. Koroosib naŋgo segi segi qure utru anjam Yesus aqa tamo uŋgasari naŋgi na mareqnab qusibqa prugugetoqneb. Osib maroqneb, “Tamo uŋgasari kalil endi Galili qaji. ");
INSERT INTO boj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naŋgi kiyersib gago segi segi qure utru anjam mareqnab iga queqnum? ");
INSERT INTO boj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Iga qudei Partia, Midia, Elam, Mesopotemia, Judia, Kapadosia, Pontus, Esia qaji. ");
INSERT INTO boj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Iga qudei Frigia, Pamfilia, Isip qaji. Iga qudei Libia sawa agi Sairini sawa jojom deqaji. Iga qudei Rom qaji. ");
INSERT INTO boj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iga qudei Juda tamo tiŋtiŋ. Iga qudei Juda naŋgo lou dauryqa marsim naŋgo miligiq aiyem. Iga qudei Krit. Iga qudei Arebia qaji. Naŋgi kiyersib gago segi segi qure utru anjam na Qotei aqa maŋwa kalil qa saeqnab iga queqnum?” ");
INSERT INTO boj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Juda kalil naŋgi anjam degsib marsibqa prugugetoqnsib segi segi maroqneb, “Endi kumbra kiyero?” ");
INSERT INTO boj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Onaqa naŋgi qudei yomuoqnsib maroqneb, “Naŋgi wain bunuj uysib deqa nanariosib anjam laŋa laŋa mareqnub.” ");
INSERT INTO boj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Onaqa Yesus aqa aŋgro 11 naŋgi Pita ombla tigelosibqa Pita na aqa medabu waqtosiqa endegsi marej, “Niŋgi Juda ti tamo kalil Jerusalem endi unub qaji niŋgi ti ijo anjam endi qusib poiŋgem. ");
INSERT INTO boj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Niŋgi maronub, ‘Tamo uŋgasari naŋgi di wain uysib nanarionub.’ Di sai. Endego nobqolo koba. Wain uyqa bati sai. ");
INSERT INTO boj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Maŋwa niŋgi bini unonub qaji endeqa Qotei aqa medabu o tamo Joel a nami marej. Agi a endegsi marej, ");
INSERT INTO boj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Qotei a marqo, “Diŋo bati jojomoqnimqa e na ijo Mondor qariŋyitqa tamo uŋgasari kalil naŋgoq aiqas. Aisim nuŋgo aŋgro mel ti nuŋgo aŋgro sebiŋ ti naŋgi siŋgila enjrimqa naŋgi ijo medabu osib anjam maroqnqab. Nuŋgo aŋgro wala naŋgi ti nuŋgo tamo bole bole naŋgi ti areqalo waqtetnjroqnimqa ŋeio buloqnsibqa ijo kumbra gargekoba unoqnqab. ");
INSERT INTO boj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bati deqa e na ijo Mondor qariŋyitqa ijo wau tamo ti ijo wau uŋa ti naŋgoq aisim siŋgila enjroqnimqa naŋgi ijo medabu osib anjam maroqnqab. ");
INSERT INTO boj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Laŋ goge dia e maŋwa gargekoba yoqnqai. Mandamq di dego maŋwa gargekoba yoqnqai. Leŋ ti ŋamyuwo ti qurem koba ti qariŋyit mandamq aiqas. ");
INSERT INTO boj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Seŋ ambruqas. Bai lentosim leŋ bulqas. Amqa Tamo Koba a riaŋ koba ti siŋgila koba ti bqas. ");
INSERT INTO boj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bati deqa tamo uŋgasari gargekoba naŋgi Tamo Koba aqa ñam metosib pailyibqa a na naŋgo pailyo qusim naŋgi kalil eleŋamqa naŋgi so bole gaigai sqab.” ’ Qotei aqa medabu o qaji tamo Joel a nami anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Deqa Israel tamo uŋgasari, niŋgi ijo anjam endi quiy. Niŋgi qalie, Qotei a Yesus Nasaret qaji aqa siŋgila na maŋwa gargekoba nuŋgo ambleq di yoqnej. A degyoqnej. Di kiyaqa? Niŋgi poiŋgwajqa, Qotei na a qariŋyonaq bej. ");
INSERT INTO boj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bunuqna Qotei na Yesus olo osiq nuŋgo baŋq di atej. A nami kumbra degyqa marsiq aqa segi areqalo dauryosiq degyej. Degyonaqa niŋgi na Yesus ojsib tamo uge naŋgo baŋq di atnabqa naŋgi a osib ŋamburbasq di qalnab moiyej. Nuŋgo kumbra dena niŋgi segi na Yesus qalsib moiyoteb. ");
INSERT INTO boj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Onaqa Qotei na Yesus olo subq na tigeltosiqa moiyo aqa gulbe kobotej. Deqa moiyo na Yesus a olo ojqa keresai. ");
INSERT INTO boj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Agi Devit a nami Yesus qa endegsi marej, ‘Tamo Koba a bati gaigai ijo ulatamuq di sonaq e uneqnum. A ijo baŋ woq di unu deqa e padalqasai. ");
INSERT INTO boj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Deqa e tulaŋ areboleboleibeqnu. E arebolebole na anjam mareqnum. O Qotei, iŋgi bole bole ni na e ebqajqa marem qaji di e oqajqa tariŋoqnsim unum. ");
INSERT INTO boj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ni ijo qunuŋ uratim moiyo qureq aiqasai. Ni ino segi aŋgro bolequja ni na giltem qaji aqa jejamu dego subq di uratim qusaqasai. ");
INSERT INTO boj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ŋambile sqajqa gam di ni na e osorbeqnum. Ni e ombla sqam deqa e tulaŋ areboleboleibeqnu.’ Devit a nami anjam degsi marej. ");
INSERT INTO boj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“O ijo was, e bole merŋgwai. Gago moma Devit a moinaqa subq ateb. Aqa sub agi bini unu iga gaigai uneqnum. ");
INSERT INTO boj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Nami Qotei na Devit minjej, ‘Mondoŋ ino moma naŋgi paraosibqa leŋ dena tamo bei a ŋambabqas. Amqa e na tamo di giltitqa ni mandor koba unum dego kere a kamba ino sawa osim Mandor Koba sqas.’ Qotei a nami Devit anjam degsi minjsiqa aqa anjam di siŋgilatosiqa olo minjej, ‘E ijo anjam di uratqasai. E dauryqai.’ Devit a Qotei aqa medabu o tamo soqnej deqa kumbra Qotei na mondoŋ yqas qaji di Devit a nami qalieej. Osiqa Kristus qa endegsi marej, ‘Bunuqna a subq na tigelqas.’ Osiqa olo marej, ‘Qotei na Kristus moiyo qureq di uratqasai. Aqa jejamu dego subq di uratim qusaqasai.’ ");
INSERT INTO boj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","O ijo was, Yesus qujai di Qotei a subq na tigeltonaqa iga kalil ŋamdamu na unem. Deqa bini iga a qa mare mare laqnum. ");
INSERT INTO boj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A laŋ qureq oqsiq ñam kobaquja osiq Qotei aqa baŋ woq di awoej. Osiqa Mondor Bole niŋgi nami eŋgwa marej qaji di aqa Abu aqaq dena yaiyosiqa qariŋyqo aiqoqa niŋgi unsib nuŋgo dabkala na dego quonub. ");
INSERT INTO boj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit a subq na tigelosiq laŋ qureq oqosai. Ariya a Kristus qa endegsi marej, ‘Tamo Koba a na ijo Tamo Koba minjej, “Ni ijo baŋ woq endi awo. ");
INSERT INTO boj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Awesoqnimqa e ino jeu tamo kalil naŋgi eleŋosiy ino sorgomq di atitqa ni na naŋgi taqatnjrqam.” ’ Devit a nami Kristus qa degsi marej. ");
INSERT INTO boj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Deqa Israel tamo uŋgasari, niŋgi kalil endegsi poiŋgem. Yesus agi niŋgi na ŋamburbasq di qalnab moiyej qaji a Qotei na olo giltosiqa a gago Tamo Koba Kristus ñam waiyej.” ");
INSERT INTO boj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Onaqa tamo uŋgasari naŋgi Pita aqa anjam di qunabqa anjam dena naŋgo are qametnjrej. Deqa naŋgi na Yesus aqa aŋgro naŋgi Pita ombla minjreb, “O gago was niŋgi na mergiy. Iga kiyeronamqa Qotei na iga eleŋamqa iga padalqasai?” ");
INSERT INTO boj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Onaqa Pita na kamba minjrej, “Niŋgi segi segi are bulyosib Qotei aqaq boiy. Babqa iga Yesus Kristus aqa ñam na niŋgi yansŋgonam Qotei na nuŋgo une kalil kobotetŋgwas. Osim aqa Mondor Bole niŋgi laŋa eŋgwas. Awai saiqoji. ");
INSERT INTO boj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Qotei a nami marej, ‘E na niŋgi ti nuŋgo aŋgro ti tamo kalil isa isaq di unub qaji naŋgi ti ijo Mondor eŋgwai.’ Qotei a nami degsi marej. Deqa niŋgi quiy. Gago Tamo Koba Qotei a aqa anjam di uratqasai. Tamo uŋgasari kalil a na metnjrim aqaq bqab qaji naŋgi aqa Mondor enjrqas.” ");
INSERT INTO boj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita a anjam deqaji gargekoba siŋgila na naŋgi minjroqnej. Osiqa olo endegsi minjrej, “Tamo uŋgasari bini bati endeqa unub qaji naŋgi kumbra uge uge yoqnsib laqnub. Niŋgi naŋgi ti Qotei na padaltŋgaim deqa niŋgi geregere ŋam atoqniy.” ");
INSERT INTO boj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita a anjam degsi marnaqa bati deqa tamo uŋgasari 3,000 naŋgi aqa anjam di qusib naŋgo are miligiq di ateb. Osib naŋgi yanso eb. Naŋgi Yesus qa naŋgo areqalo siŋgilateb deqa naŋgi tamo uŋgasari nami Yesus qa naŋgo areqalo siŋgilateb qaji naŋgo miligiq aisib koba na soqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi bati gaigai aqa anjam maro tamo naŋgo anjam quoqnsib dauryoqneb. Naŋgi are qujaitoqnsib bem gentoqnsib uyoqnsibqa Qotei pailyoqnsib soqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Qotei na Yesus aqa anjam maro tamo naŋgi di siŋgila enjreqnaqa naŋgi maŋwa gargekoba yoqneb. Yeqnab Yesus aqa tamo uŋgasari kalil naŋgi maŋwa di unoqnsib Qotei aqa ñam soqtoqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tamo uŋgasari kalil Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi bati gaigai korooqnsibqa are qujaitoqnsib soqneb. Naŋgo iŋgi iŋgi kalil di koba qaji degsib maroqnsib segi segi qa jei jeiyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Naŋgo mandam ti iŋgi iŋgi ti qariŋyeleŋeqnab tamo qudei na awaiyoqnsib silali enjreqnab oqnsib Yesus aqa tamo uŋgasari iŋgi iŋgi saiqoji naŋgi jeisib enjroqneb. ");
INSERT INTO boj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Naŋgi bati gaigai are qujaitoqnsib sosibqa atra tal miligiq di korooqnsib louoqneb. Naŋgo segi segi talq di dego korooqnsibqa bem gentoqnsib uyoqneb. Naŋgi arebolebole ti lawo na sosibqa Qotei aqa ñam soqtoqnsib koba na iŋgi uyoqneb. Degyeqnabqa tamo uŋgasari kalil naŋgi naŋgo kumbra di unoqnsib naŋgi qa tulaŋ areboleboleinjroqnej. Bati gaigai tamo uŋgasari qudei naŋgi are bulyeqnab Tamo Koba a na naŋgi eleŋeqnaqa naŋgi boqnsib tamo uŋgasari nami Yesus qa naŋgo areqalo siŋgilateb qaji naŋgo miligiq aiyoqnsib koba na soqneb. ");
INSERT INTO boj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","Bati gaigai bilaq seŋ keliŋteqnaqa Juda tamo uŋgasari naŋgi atra tal miligiq giloqnsib dia Qotei pailyoqneb. Pailyo bati bei Pita Jon wo naŋgi aiyel pailyqa marsib atra tal miligiq gilqa laqnabqa tamo bei ai miligiq na siŋga qandamo ŋambabej qaji a atra tal siraŋme jojomq di awesoqnej. Bati gaigai aqa was naŋgi a qoboiyoqnsib boqnsib siraŋme jojomq di ateqnabqa awooqnsiqa tamo uŋgasari atra tal miligiq gileqnabqa silali qa ŋilnjroqnej. Siraŋme di aqa ñam Siraŋme Boledamu. ");
INSERT INTO boj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bati deqa Pita Jon wo naŋgi atra tal miligiq gilqa laqnabqa unjrsiqa silali qa ŋilnjrej. ");
INSERT INTO boj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Onaqa naŋgi aiyel na tamo di koqyosibqa Pita na minjej, “Ni aqo nige.” ");
INSERT INTO boj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Degsi minjnaqa a are qalej, “Naŋgi aiyel silali bei ebqab.” Degsi are qalsiqa naŋgi aiyel koqnjresoqnej. ");
INSERT INTO boj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Onaqa Pita na minjej, “E silali saiqoji. Ijo iŋgi bei unu di ni emqai. Yesus Kristus Nasaret qaji aqa ñam na e ni mermonum, ‘Ni tigelosim walwel.’” ");
INSERT INTO boj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Degsi minjsiqa aqa baŋ woq di ojsiq tigeltonaqa aqa siŋga tombol siŋgilaonab tigeloqujatosiq walwelej. Osiqa Pita Jon wo naŋgi aiyel daurnjrsiqa atra tal miligiq gilsiq tulaŋ areboleboleiyeqnaqa pruprugoqnsiq Qotei aqa ñam soqtoqnej. ");
INSERT INTO boj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","A degyeqnaqa tamo uŋgasari kalil naŋgi a unsibqa are koba qaloqneb. Osib maroqneb, “Tamo siŋga qandamo bati gaigai atra tal siraŋme jojomq di awooqnsiqa silali qa ŋileqnu qaji agi a di.” ");
INSERT INTO boj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tamo di a Pita Jon wo naŋgi aiyel daurnjrsiq laqnaqa tamo uŋgasari kalil naŋgi a unoqnsib are koba qaloqneb. Deqa naŋgi gurgur ti bosib atra tal meq di Pita Jon wo sonabqa koba na korooqneb. Atra tal me di aqa ñam Solomon aqa Tal Me. ");
INSERT INTO boj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tamo uŋgasari naŋgi bosib koroeqnab Pita a naŋgi unjrsiqa endegsi minjrej, “O Israel tamo uŋgasari, niŋgi kiyaqa aqo aiyel tamo di boletonum unsibqa are koba qaleqnub? Niŋgi kiyaqa aqo aiyel nugsibqa endegsib mareqnub, ‘Naŋgo segi siŋgila na ti kumbra bole na ti tamo di boletonub walwelqo’? Niŋgi degsib maraib. ");
INSERT INTO boj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Qotei aqa wau tamo Yesus aqa siŋgila na tamo di boleosiq walwelqo. Qotei a Abraham, Aisak, Jekop, gago moma kalil naŋgi ti naŋgo Qotei. A na Yesus laŋ qureq osi oqsiq ñam kobaquja yej. Yesus qujai di niŋgi na osib jeu tamo naŋgo baŋq di ateb. Onaqa Pailat a olo Yesus tonto talq dena oqeq atqajqa marnaqa niŋgi na saideb. ");
INSERT INTO boj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesus a Qotei aqa segi Tamo Boledamu. A une saiqoji. Ariya niŋgi na Yesus qoreiyosib saidosib Pailat minjeb, ‘Tonto tamo bei oqeq atsim ege.’ Niŋgi na Pailat degsib minjnabqa a nuŋgo anjam di dauryosiqa leŋ ojo tamo osiqa oqeq atsiq eŋgej. ");
INSERT INTO boj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ariya Yesus a segi ŋambile qa utru. Di niŋgi na qalnab moiyej. Moinaqa Qotei na olo subq na tigeltonaqa iga gago ŋamdamu na unem. Deqa bini iga a qa mare mare laqnum. ");
INSERT INTO boj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aqo aiyel Yesus qa gago areqalo siŋgilateqnum deqa iga aqa ñam na tamo siŋga qandamo di boletonum a siŋgilaqo. Tamo siŋga qandamo di niŋgi qalie. Niŋgi gaigai a unoqneb. Yesus a segi na aqo aiyel siŋgila egwoqa a qa gago areqalo siŋgilatosim tamo di boletonumqa nuŋgo ŋamdamuq di walwelqo. ");
INSERT INTO boj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O gago was, e qalieonum, niŋgi ti nuŋgo gate naŋgi ti une kobaquja ateb di niŋgi poiŋgosai. ");
INSERT INTO boj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Niŋgi kumbra di yeb deqa Qotei aqa medabu o tamo kalil naŋgo anjam nami maroqneb qaji di aqa damu Qotei na babtej. Agi Qotei na naŋgo medabu siŋgilatetnjreqnaqa naŋgi endegsib maroqneb, ‘Qotei aqa Kristus a jaqatiŋ koba osim moiqas.’ ");
INSERT INTO boj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Deqa ijo was kalil, niŋgi are bulyosib Tamo Koba aqaq boiy. Babqa a na nuŋgo une kobotetŋgsim niŋgi siŋgila bunuj eŋgwas. Osim mondoŋ a na Yesus olo qariŋyim nuŋgoq bqas. Tamo di agi Kristus Qotei a nami niŋgi qa osiq giltej qaji. ");
INSERT INTO boj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","A laŋ qureq oqej di unu. A di soqnimqa Qotei na mandam bunuj ti laŋ bunuj ti atqa bati brantimqa a olo bqas. Qotei a nami aqa kumbra deqa anjam marej. Osiqa aqa anjam di aqa medabu o qaji tamo naŋgi minjreqnaqa naŋgi na neŋgreŋyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Nami Moses a Yesus qa endegsi marej, ‘Mondoŋ Tamo Koba Qotei na aqa medabu o qaji tamo bei e bul nuŋgo ambleq dena tigeltimqa a anjam merŋgoqnqas. Anjam merŋgoqnimqa niŋgi aqa anjam kalil qusib dauryoqniy. ");
INSERT INTO boj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tamo uŋgasari kalil aqa anjam quqwa uratqab qaji naŋgi Qotei na ñumim moreŋqab. Deqa naŋgi olo Qotei aqa tamo uŋgasari naŋgo ambleq di sqasai.’ Moses a nami Yesus qa degsi marej. ");
INSERT INTO boj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Qotei aqa medabu o qaji tamo kalil naŋgi dego nami Yesus qa anjam degsib maroqneb. Agi Samuel a utru atsiqa a Yesus bqajqa bati qalieosiq deqa Yesus qa anjam maroqnej. Samuel a moinaqa Qotei aqa medabu o tamo kalil bunuqna branteleŋeb qaji naŋgi dego Yesus bqajqa bati qalieosib deqa anjam maroqneb. ");
INSERT INTO boj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Qotei a niŋgi eleŋqa osiq deqa aqa medabu o qaji tamo naŋgi qariŋnjreqnaqa aqa anjam mare mare laqneb. A nami nuŋgo moma utru naŋgi ti koba na anjam qosisibqa Abraham endegsi minjej, ‘Mondoŋ ino moma naŋgi paraosibqa leŋ dena tamo bei ŋambabqas. Ŋambabosim tamo uŋgasari sawa sawa kalilq di unub qaji naŋgi boletnjrqas.’ Qotei a niŋgi eleŋqa osiq deqa anjam di Abraham minjej. ");
INSERT INTO boj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Osiqa bunuqna aqa wau tamo Yesus a qariŋyonaq nuŋgoq aiyej. Qotei a are qalej, a Yesus qariŋyim a niŋgi kalil boletŋgimqa niŋgi nuŋgo kumbra uge uge kalil uratqab. Qotei a degsi are qalsiq Yesus qariŋyonaq nuŋgoq aiyej.” ");
INSERT INTO boj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Pita Jon wo naŋgi na tamo uŋgasari naŋgi Qotei aqa anjam minjreqnabqa atra tamo naŋgi ti Sadyusi naŋgi ti atra tal taqato tamo naŋgo gate ombla na tulaŋ minjiŋ oqetnjrnaqa bosib naŋgi aiyel ojeleŋosib tonto talq di breinjreb. Di kiyaqa? Naŋgi aiyel maroqneb, “Yesus a moisiq olo subq na tigelej deqa tamo kalil naŋgi dego moisib olo subq na tigelqab.” Deqa naŋgi aiyel tonto talq di breinjreb. Bilaqtej deqa naŋgi aiyel tonto talq di uratnjrnab sonab nebeej. ");
INSERT INTO boj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bati deqa tamo uŋgasari tulaŋ gargekoba naŋgi Qotei aqa anjam quoqnsib Yesus qa naŋgo areqalo siŋgilatoqneb. Naŋgi kalil turteb 5,000. ");
INSERT INTO boj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nebeonaqa Juda naŋgo tamo kokba ti gate naŋgi ti dal anjam qalie tamo naŋgi ti Jerusalem di koroeb. ");
INSERT INTO boj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Atra tamo gate Anas aqa leŋ kalil naŋgi ti dego koroeb. Bei Kaiafas. Bei Jon. Bei Aleksanda. ");
INSERT INTO boj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Koroosib Pita Jon wo naŋgi metnjrnab bonab naŋgo ambleq di tigeltnjreb. Tamo siŋga qandamyonaq olo boleej qaji a dego osi bosib tigelteb. Osib Pita Jon wo nenemnjreb, “Niŋgi siŋgila qabe na osib tamo endi boleteb? Niŋgi yai aqa ñam na boleteb?” ");
INSERT INTO boj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Onaqa Mondor Bole a Pita aqa miligiq aisiq medabu siŋgilatetonaqa a na naŋgi endegsi minjrej, “O Israel tamo kokba ti gate niŋgi ti ijo anjam endi quiy. Aqo aiyel na tamo siŋga qandamo endi boletem deqa niŋgi iga osib nuŋgo ŋamdamuq di tigeltgonub. Tamo endi a kiyersi boleej deqa niŋgi qalieqa osib nenemgonub. ");
INSERT INTO boj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Deqa niŋgi ti Israel tamo uŋgasari kalil ti ijo anjam endi qusib poiŋgem. Nasaret tamo Yesus Kristus agi niŋgi na ŋamburbasq di qalnab Qotei a olo subq na tigeltej qaji aqa ñam na tamo endi a boleqo. Boleosiq nuŋgo ulatamuq endi tigelesonaq niŋgi unonub. ");
INSERT INTO boj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus a tal ai bul. Niŋgi tal gereiyo qaji tamo bul. Niŋgi na tal ai di arqsibqa uge qa marsib taqal waiyeb. Onaqa Qotei na olo tal ai di osiqa tal siŋgilatqajqa deqa tumaq di tigeltej unu. ");
INSERT INTO boj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Niŋgi quiy. Tamo bei aqa ñam na Qotei na iga eleŋqasai. Yesus aqa ñam na qujai Qotei na iga eleŋqas. Amqa iga padalqasai. Iga eleŋqajqa tamo bei saiqoji. Sawa bei beiq di Qotei na tamo bei iga osorgosai bole sai.” ");
INSERT INTO boj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jon wo naŋgi siŋgila na anjam di maroqneb naŋgi ulaosai. Deqa Juda tamo kokba naŋgi tulaŋ prugeb. Di kiyaqa? Naŋgi qalieeb, naŋgi aiyel nami skul beiq gilosai. Naŋgi tamo laŋaj. Degsib qalieosib poinjrej, naŋgi aiyel nami Yesus ombla laqneb. ");
INSERT INTO boj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tamo siŋga qandamyonaq olo boleej qaji a Pita Jon wo naŋgo areq di tigelesonaq Juda tamo kokba naŋgi unsibqa anjam bei kamba marqa keresaiinjrej. ");
INSERT INTO boj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Deqa naŋgi na Pita Jon wo minjrnabqa taqal beiq gilnabqa naŋgi segi qairosib mareb, ");
INSERT INTO boj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Iga naŋgi aiyel kiyernjrqom? Naŋgi aiyel maŋwa kobaquja yonubqa Jerusalem tamo uŋgasari kalil naŋgi quekritonub. Deqa iga gisaŋ qa marqa keresai. ");
INSERT INTO boj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Uŋgum, iga na naŋgi aiyel Yesus aqa ñam mare mare laqajqa saidnjrqom. Yimqa naŋgo anjam kobaqasai.” ");
INSERT INTO boj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Juda tamo kokba naŋgi degsib qairosib naŋgi aiyel olo metnjrnab bonabqa siŋgila na saidnjrsib minjreb, “Niŋgi aiyel olo Yesus aqa ñam maroqnaib. Medabu getentiy.” ");
INSERT INTO boj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Onaqa Pita Jon wo naŋgi na kamba minjreb, “Aqo aiyel Qotei aqa anjam dauryqa uratosim olo nuŋgo anjam dauryqom di Qotei aqa ŋamgalaq di kumbra bole e? Niŋgi segi mariy. ");
INSERT INTO boj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aqo aiyel medabu getentqa keresai. Qotei aqa maŋwa kalil gago ŋamdamu na unoqnem qaji deqa iga mare mare laqnqom. Aqa anjam kalil gago dabkala na quoqnem qaji di dego iga mare mare laqnqom. Iga uratqa keresai.” ");
INSERT INTO boj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Onaqa Juda tamo kokba naŋgi na olo naŋgi aiyel Yesus aqa ñam marqajqa siŋgila na saidnjrsib uratnjrnab gileb. Naŋgi aiyel na tamo siŋga qandamo boletonabqa tamo uŋgasari tulaŋ gargekoba naŋgi unsibqa Qotei aqa ñam soqtoqneb. Deqa Juda tamo kokba naŋgi tamo uŋgasari naŋgi ulainjreb. Naŋgi naŋgo aiyel jejamuq di une bei babtosai deqa naŋgi ñumqa keresai. Utru deqa naŋgi tamo uŋgasari naŋgi ulainjrsib naŋgi aiyel uratnjrnab gileb. ");
INSERT INTO boj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tamo siŋga qandamo naŋgi aiyel na boleteb qaji di aqa wausau 40. ");
INSERT INTO boj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Juda tamo kokba naŋgi na naŋgi aiyel uratnjrnab gilsib tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgoq di branteb. Brantosib anjam kalil atra tamo kokba ti tamo gate ti naŋgi na minjreb qaji deqa sainjreb. ");
INSERT INTO boj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sainjrnab qusibqa tulaŋ areboleboleinjrej. Deqa naŋgi kalil medabu qujaitosib Qotei endegsib pailyeb, “O Tamo Koba, ni na laŋ ti mandam ti yuwal ti iŋgi iŋgi kalil ti atem unub. ");
INSERT INTO boj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nami ni na Mondor Bole qariŋyonamqa aisiq ino wau tamo agi gago moma Devit aqa medabu siŋgilatetonaqa endegsi marej, ‘Kiyaqa sawa bei bei qaji naŋgi minjiŋ oqetnjreqnu? Kiyaqa naŋgo areqalo tulaŋ nanarieqnaq naŋgi Qotei ti qotqajqa qaireqnub? ");
INSERT INTO boj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sawa bei beiq di mandor kokba naŋgi tigeloqnsib Kristus qalib moiqajqa deqa siŋgilaeqnub. Gate kokba naŋgi na Tamo Koba aqa Kristus wo qoto itnjrqajqa deqa koroeqnub.’ ");
INSERT INTO boj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“O Qotei, Devit aqa anjam di aqa damu gam endena brantej. Herot wo Pontius Pailat wo Israel naŋgi ti sawa bei bei qaji naŋgi ti kalil qure endia koroosibqa ino segi wau tamo bole Yesus ni nami giltem qaji a ugeugeiyqa marsibqa anjam kereteb. ");
INSERT INTO boj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","O Qotei, ni nami marem, ‘Naŋgi Yesus qalib moiqas.’ Ino anjam di agi naŋgi dauryosib Yesus qalnab moiyej. Naŋgo segi areqalo na naŋgi Yesus qalosai. Ino siŋgila na ti ino areqalo na ti naŋgi Yesus qalnab moiyej. ");
INSERT INTO boj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Tamo Koba, Juda tamo kokba naŋgi minjiŋ oqetnjrqoqa iga ula egwajqa anjam mergonub di ni unime. Iga ino wau tamo unum. Deqa ni iga siŋgila egoqnimqa iga ino anjam maroqnqom. Iga ulaqasai. ");
INSERT INTO boj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ni iga siŋgila egoqnimqa iga ino wau tamo bole Yesus aqa ñam na tamo uŋgasari naŋgi boletnjroqnqom. Osim ino maŋwa kokba babtoqnqom.” ");
INSERT INTO boj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Naŋgi degsib Qotei pailyosib koboonaqa tal naŋgi koroesoqneb qaji di reŋgiŋej. Onaqa Mondor Bole aisiqa naŋgi siŋgila enjrnaqa naŋgi Qotei aqa anjam mare mare laqneb. Naŋgi ulaosai. ");
INSERT INTO boj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bati deqa tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi kalil are qujaitoqnsib soqneb. Tamo bei na aqa iŋgi iŋgi saiaosiq aqa segi qa marosaioqnej. Naŋgo iŋgi iŋgi kalil di koba qaji degsib maroqnsib segi segi qa jei jeiyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tamo Koba Yesus aqa anjam maro tamo kalil naŋgi aqa wau ojoqneb. A subq na tigelej anjam di naŋgi mare mare laqneb. Naŋgo anjam di siŋgila ti. Naŋgi mare mare laqnab Qotei a naŋgi qa are tulaŋ boleiyoqnej. ");
INSERT INTO boj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi kalil iŋgi kere soqneb. Bei a iŋgi qa truquosaioqnej. Di kiyaqa? Naŋgi naŋgo segi mandam ti tal ti qariŋyeqnabqa tamo qudei na awaiyoqnsib silali enjroqneb. Enjreqnab silali di osi boqnsib Yesus aqa anjam maro tamo naŋgo baŋq di ateqnab naŋgi na tamo iŋgi iŋgi saiqoji naŋgi jeisib enjroqneb. ");
INSERT INTO boj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Naŋgo ambleq di tamo bei soqnej aqa ñam Josep. Aqa ñam bei Barnabas. Yesus aqa anjam maro tamo naŋgi na ñam di waiyeb. Aqa ñam di aqa damu, “Tamo are siŋgilatetnjro qaji.” Barnabas a Livai aqa leŋ. A Saiprus nui qaji. ");
INSERT INTO boj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aqa mandam bei soqnej di tamo qudei na awaiyosib silali yonab osi gilsiq Yesus aqa anjam maro tamo naŋgo baŋq di atej. ");
INSERT INTO boj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Ariya tamo bei soqnej aqa ñam Ananaias. Aqa ŋauŋ aqa ñam Safaira. Ananaias aqa mandam bei tamo qudei na awaiyosib silali yonabqa a silali di osiqa aqa ŋauŋ wo anjam keretosib silali oto aqa segi qa ulitosiq oto bei osi gilsiq Yesus aqa anjam maro tamo naŋgo baŋq di atej. ");
INSERT INTO boj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Onaqa Pita na minjej, “Ananaias, kiyaqa Satan a ino are miligiq aiqoqa ni Mondor Bole a gisaŋyonum? Ino mandam awaiyonub silali osim kiyaqa oto bei ino segi qa marsim ulitonum? ");
INSERT INTO boj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nami ino mandam awaiyosaisonabqa di ino segi mandam. Ariya bunuqna mandam awaiyosib silali emonub di ino segi silali. Ni segi na silali di taqatosim ni wau kiye yqa osim ye. Ni kiyaqa gisaŋosim maronum, ‘Silali kalil agi osi bonum’? Ni kiyaqa kumbra uge di yqajqa are qalonum? Ni que. Ino gisaŋ anjam di ni na tamo naŋgi minjrosai. Ni Qotei gisaŋyqa osim minjonum.” ");
INSERT INTO boj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pita a degsi marnaqa Ananaias a anjam di qusiqa moiyoqujatosiq mandamq di uloŋej. Onaqa aŋgro wala naŋgi bosib aqa jejamu gara na dalaosib osi gilsib subq ateb. Subq atnabqa tamo uŋgasari kumbra deqa queb qaji naŋgi tulaŋ ulaugeteb. ");
INSERT INTO boj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sokiñalayonaq Ananaias aqa ŋauŋ bej. Aqa gumbuluŋ moiyej di a qaliesai. ");
INSERT INTO boj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A bonaqa Pita na minjej, “Ni mare. Ni ino gumbuluŋ wo nuŋgo mandam bei tamo qudei na awaiyosib silali eŋgonub qaji agi ino gumbuluŋ na osi bosiq ebqo endi segi e?” Onaqa minjej, “Od. Silali kalil agide.” ");
INSERT INTO boj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Degsi minjnaqa Pita na minjej, “Kiyaqa ni ino gumbuluŋ wo anjam keretosib kumbra uge di yonub? Niŋgi are qalonub, Tamo Koba aqa Mondor a nuŋgo kumbra di unqasai. Degosib niŋgi yonub. Ni que. Aŋgro wala ino gumbuluŋ subq atonub qaji naŋgi bosib siraŋmeq di tigelonub. Naŋgi ni dego qoboimosib gilsib subq atqab.” ");
INSERT INTO boj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Degsi minjnaqa a dego moiyoqujatosiq Pita aqa siŋgaq di uloŋej. Onaqa aŋgro wala naŋgi bosib a moiyej di unsib qoboiyosib gilsib aqa gumbuluŋ aqa areq di subq ateb. ");
INSERT INTO boj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Onaqa tamo uŋgasari kalil kumbra deqa queb qaji naŋgi tulaŋ ulaugeteb. Kristen kalil naŋgi dego ulaugeteb. ");
INSERT INTO boj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bati deqa Qotei na Yesus aqa anjam maro tamo naŋgi siŋgila enjreqnaqa naŋgi maŋwa gargekoba yeqnabqa tamo uŋgasari naŋgi unoqneb. Tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi kalil are qujaitoqnsibqa atra tal meq di korooqnsibqa Qotei qa louoqneb. Tal me di aqa ñam Solomon aqa Tal Me. ");
INSERT INTO boj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jerusalem dia tamo uŋgasari laŋa laŋaj kalil naŋgi na tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgo ñam soqtetnjroqnsibqa naŋgi ti koba na koroqajqa ulaoqneb. ");
INSERT INTO boj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tamo ti uŋa ti tulaŋ gargekoba naŋgi Tamo Koba Yesus qa naŋgo areqalo siŋgilatoqnsib boqnsib tamo uŋgasari nami Yesus qa naŋgo areqalo siŋgilateb qaji naŋgo miligiq aiyeqnab naŋgi tulaŋ kobaoqneb. ");
INSERT INTO boj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kobaoqnsib naŋgo ma tamo naŋgi saperaq di ŋeiotnjroqnsib qoboinjroqnsib gam qalaq di ateleŋoqneb. Di kiyaqa? Pita a gam na walwelosim giloqnimqa aqa seŋ qunuŋ na naŋgi waburtnjroqnimqa naŋgo ma kobooqnqajqa deqa. ");
INSERT INTO boj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Qure kiñilala kalil Jerusalem jojomq di soqneb qaji dena dego tamo mainjro qaji naŋgi ti tamo mondor uge uge na ojeleŋo qaji naŋgi ti joqsib boqneb. Joqsib beqnab naŋgi kalil boleoqneb. ");
INSERT INTO boj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Yesus aqa anjam maro tamo naŋgi kumbra degyeqnabqa atra tamo gate aqa wau qujai agi Sadyusi naŋgi ti koba na unsib minjiŋ oqetnjrnaqa naŋgi ojeleŋosib tonto talq di breinjrnab soqneb. ");
INSERT INTO boj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sonabqa qoloej. Onaqa Tamo Koba aqa laŋ aŋgro bei aisiqa tonto tal siraŋme waqtosiq naŋgi joqsiq oqedeb. Oqedonabqa laŋ aŋgro na minjrej, ");
INSERT INTO boj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Niŋgi gilsib atra tal miligiq di tigelosib tamo uŋgasari naŋgi ŋambile gaigai sqajqa anjam palontosib minjroqniy.” ");
INSERT INTO boj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Onaqa naŋgi laŋ aŋgro aqa anjam di dauryosib nobqolo malu qameqnaqa atra tal miligiq gilsib dia tigelosib tamo uŋgasari naŋgi Qotei aqa anjam palontosib minjroqneb. Bati deqa atra tamo gate aqa wau qujai ti naŋgi na Juda tamo kokba ti Israel tamo gate ti naŋgi metnjrnab bosib koroeb. Koroosib anjam keretosib naŋgo qaja tamo naŋgi minjreb, “Niŋgi aisib Yesus aqa anjam maro tamo naŋgi tonto talq dena joqsib boiy.” ");
INSERT INTO boj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Onaqa qaja tamo naŋgi aisib tonto talq di brantosib ŋam ateb Yesus aqa anjam maro tamo naŋgi di sosai. Naŋgi degsi unsib deqa olo puluosib bosib Juda tamo kokba naŋgi minjreb, ");
INSERT INTO boj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Iga aiyonum di tonto tal siraŋme qandimesonaq unonum. Tal taqato tamo naŋgi aŋ ti siraŋmeq di tigelenab. Ariya iga siraŋ waqtosim miligiq gilonum di iga tamo bei unosai.” ");
INSERT INTO boj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Degsib minjrnabqa atra tamo kokba ti atra tal taqato tamo naŋgo gate ombla na anjam di qusib are koba qalsib maroqneb, “Tamo naŋgi di kiyersib tonto tal uratosib jaraiyonub?” ");
INSERT INTO boj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Onaqa tamo bei bosiqa naŋgi minjrej, “Niŋgi quiy. Tamo niŋgi na tonto talq di breinjreb qaji naŋgi atra tal miligiq di sosibqa anjam plalteqnab tamo uŋgasari naŋgi queqnub.” ");
INSERT INTO boj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Degsi minjrnaqa qaja tamo naŋgi ti atra tal taqato tamo naŋgo gate ombla na atra tal miligiq gileb. Gilsib Yesus aqa anjam maro tamo naŋgi di sonab unjrsib ojeleŋosib joqsib gileb. Siŋgila na ojsib gilosai. Lawo na joqsib gileb. Tamo uŋgasari naŋgi ŋiriŋosib meniŋ osib naŋgi ñumaib deqa ulaosib lawo na joqsib gileb. ");
INSERT INTO boj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Joqsib gilsib Juda tamo kokba naŋgo ulatamuq di tigeltnjreb. Tigelonabqa atra tamo gate na naŋgi ŋiriŋtnjrsiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Niŋgi Yesus aqa ñam mare mare laqajqa iga siŋgila na saidŋgem. Di niŋgi na olo mare mare laqnabqa tamo uŋgasari kalil Jerusalem endi unub qaji naŋgi quekriteqnub. Di segi sai. Niŋgi gago jejamuq di une qamoqnsib mareqnub, iga na Yesus ŋamburbasq di qalnam moiyej.” ");
INSERT INTO boj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Atra tamo gate na Yesus aqa anjam maro tamo naŋgi degsi minjrnaqa naŋgi Pita ombla na kamba minjeb, “Iga Qotei aqa anjam segi dauryqom di kere. Iga tamo naŋgo anjam dauryqasai. ");
INSERT INTO boj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Di bole, niŋgi na Yesus ŋamburbasq di qalnab moiyej. Moinaqa gago moma utru naŋgo Qotei na olo subq na tigeltej. ");
INSERT INTO boj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yesus qujai di Qotei na laŋ qureq osi oqsiqa aqa baŋ woq di awotej. Deqa Yesus a gago Tamo Koba. A na qujai iga eleŋamqa iga padalqasai. Yesus qujai dena iga Israel tamo uŋgasari are bulyetgoqnsiqa gago une kobotetgeqnu. ");
INSERT INTO boj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Iga gago segi ŋamdamu na Yesus aqa kumbra di unoqnem deqa mare mare laqnum. Mondor Bole a dego Yesus aqa kumbra di ubtosiq mareqnu. Mondor di agi Qotei na tamo uŋgasari aqa anjam dauryeqnub qaji naŋgi enjreqnu.” ");
INSERT INTO boj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Onaqa Juda tamo kokba naŋgi Yesus aqa anjam maro tamo naŋgo anjam di qusibqa minjiŋ ani oqetnjrnaqa naŋgi ñumib moreŋqajqa maroqneb. ");
INSERT INTO boj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Onaqa naŋgo ambleq dena Farisi tamo bei aqa ñam Gamaliel a tigelej. A dal anjam qalie tamo kobaquja. Tamo kalil naŋgi bati gaigai a qa maroqneb, “A tamo bolequja.” A tigelosiqa Juda tamo kokba naŋgi minjrej, “Niŋgi mati tamo naŋgi endi minjrib taqal beiq gileb.” ");
INSERT INTO boj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Onaqa naŋgi taqal beiq gilnabqa Gamaliel na olo Juda tamo kokba naŋgi minjrej, “O Israel tamo, niŋgi na tamo naŋgi endi gulbe enjrqa osibqa mati geregere are qaliy. ");
INSERT INTO boj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Niŋgi qalie, nami yala tamo bei aqa ñam Teudas a tigelosiqa aqa segi ñam soqtoqnsiqa maroqnej, ‘E tamo kobaquja.’ Degsi mareqnaqa tamo 400 a dauryoqneb. Onaqa Rom naŋgi na bosib a qalnab moinaqa tamo kalil a dauryoqneb qaji naŋgi segi segi jaraiyonab aqa wau koboej. ");
INSERT INTO boj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bunuqna tamo uŋgasari naŋgo ñam sisiyo bati qa Galili qaji tamo bei aqa ñam Judas a dego tigelosiqa Rom naŋgi ti qotqajqa maroqnsiqa tamo naŋgo are tigeltetnjreqnaqa naŋgi a dauryoqneb. Onaqa Rom naŋgi na a qalnab moinaqa tamo kalil a dauryoqneb qaji naŋgi segi segi jaraiyeb. ");
INSERT INTO boj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Deqa niŋgi quiy. Niŋgi tamo naŋgi endi uratnjrib naŋgo wau yoqnebe. Naŋgi naŋgo segi areqalo na wau endi tigeltqab di naŋgo wau koboqas. ");
INSERT INTO boj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ariya naŋgi Qotei aqa areqalo na wau endi tigeltqab di niŋgi na naŋgi kobotnjrqa keresai. Niŋgi naŋgi ñumqab di niŋgi Qotei ti qotqab.” Gamaliel na Juda tamo kokba naŋgi degsi minjrnaqa naŋgi aqa anjam di dauryosib Yesus aqa anjam maro tamo naŋgi ñumqa urateb. ");
INSERT INTO boj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Osib naŋgi metnjrnabqa naŋgi olo bonabqa bu toqoŋ na naŋgi kumbaiŋnjrsib naŋgi Yesus aqa ñam olo marqajqa siŋgila na saidnjrsib naŋgi uratnjreb. ");
INSERT INTO boj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Onaqa naŋgi koro sawa di uratosib gileb. Qotei a are qalej, naŋgi Yesus aqa ñam qa jaqatiŋ ti jemai ti oqa kere. Deqa naŋgi areboleboleinjrnaq gileb. ");
INSERT INTO boj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naŋgi Yesus aqa anjam mare mare laqajqa uratosaioqneb. Naŋgi bati gaigai Yesus aqa anjam plaltoqnsib maroqneb. Atra tal miligiq di, tamo uŋgasari naŋgo segi segi talq di naŋgi anjam endegsib maroqneb, “Yesus a bole Kristus.” ");
INSERT INTO boj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bati deqa Juda tulaŋ gargekoba naŋgi are bulyoqnsib Yesus qa naŋgo areqalo siŋgilatoqneb. Juda qudei naŋgi Grik qaji. Deqa naŋgi Grik anjam qalie. Juda qudei naŋgi Hibru qaji. Deqa naŋgi Hibru anjam qalie. Bati bei Grik qaji Juda naŋgi tigelosib Hibru qaji Juda naŋgi qa ŋiriŋeb. Di kiyaqa? Iŋgi jeiyo batieqnaqa Hibru qaji Juda naŋgi na Grik qaji Juda naŋgo uŋa qobul naŋgi uratnjroqnsib naŋgo segi uŋa qobul naŋgi iŋgi jeisib enjroqneb. ");
INSERT INTO boj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Deqa Yesus aqa anjam maro tamo 12 naŋgi na tamo uŋgasari kalil Yesus dauryoqneb qaji naŋgi koroinjrsib minjreb, “Iga Yesus aqa anjam maro tamo unum. Gago wau qujai agi iga Qotei aqa anjam mare mare laqnum. Iga gago wau di uratosim iŋgi jei jeiyoqnqasai. ");
INSERT INTO boj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Deqa ijo was, niŋgi tamo 7 nuŋgo ambleq dena giltnjriy. Tamo endeqaji giltnjriy. Naŋgo kumbra tulaŋ boledamu. Qotei aqa Mondor a naŋgoq di sosiqa naŋgi siŋgilatnjreqnu. Naŋgi powo koba ti unub. Niŋgi tamo deqaji giltnjrsib wau enjribqa naŋgi na iŋgi jeiyetŋgoqnqab. ");
INSERT INTO boj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iga Yesus aqa anjam maro tamo unum deqa iga bati gaigai Qotei pailyoqnsim Yesus aqa anjam mare mare laqnqom. Gago wau bole agide.” ");
INSERT INTO boj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Onaqa Kristen naŋgi kalil anjam di qusib odosib tamo 7 naŋgi giltnjreb. Bei aqa ñam Stiven. Stiven aqa areqalo kalil Yesus qa siŋgilatoqnej. A areqalo aiyeltosaioqnej. Mondor Bole a Stiven aqa are miligiq aiyoqnsiqa siŋgilatoqnej. Bei aqa ñam Filip. Bei Prokorus. Bei Nikanor. Bei Timon. Bei Parmenas. Bei Nikolas. Nikolas aqa qure utru Antiok. A Juda tamo sai. A nami Jerusalem bosiqa Juda naŋgo lou dauryqa marsiq naŋgo miligiq aiyej. ");
INSERT INTO boj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kristen naŋgi na tamo 7 naŋgi di giltnjrsib Yesus aqa anjam maro tamo naŋgo ulatamuq di tigeltnjrnab naŋgo gateq di baŋ atsib naŋgi qa Qotei pailyeb. ");
INSERT INTO boj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bati deqa Qotei aqa anjam tulaŋ kobaoqnej. Jerusalem dia tamo uŋgasari tulaŋ gargekoba naŋgi Yesus qa naŋgo areqalo siŋgilatoqneb. Atra tamo gargekoba naŋgi dego Qotei aqa anjam dauryoqnsibqa Yesus qa naŋgo areqalo siŋgilatoqneb. ");
INSERT INTO boj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Qotei a Stiven qa are tulaŋ boleiyoqnsiq a siŋgila yeqnaqa a na tamo uŋgasari kalil Jerusalem di soqneb qaji naŋgo ŋamdamuq di maŋwa gargekoba yoqnej. ");
INSERT INTO boj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Onaqa bati bei Juda tamo qudei naŋgi tigelosib Stiven ombla anjam na qotoqneb. Tamo naŋgi di Juda naŋgo Qotei tal beiq di gaigai louoqneb. Naŋgi nami kaŋgal tamo sosibqa olo bunuqna naŋgo segi wau ojoqneb deqa naŋgi Qotei tal dia louoqneb. Qotei tal di aqa ñam endegsib waiyeb, “Tamo Naŋgo Segi Wau Ojo Qaji Naŋgo Qotei Tal.” Tamo naŋgi di Stiven ombla anjam na qotoqneb. Naŋgi nami Sairini qure ti Aleksandria qure ti Silisia sawa ti Esia sawaq dena ti beleŋeb. ");
INSERT INTO boj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Naŋgi Stiven ombla anjam na qoteqnab Qotei aqa Mondor na Stiven powo koba yoqnej deqa naŋgi aqa anjam qalotqa keresai. ");
INSERT INTO boj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Deqa naŋgi lumu na tamo qudei naŋgi metnjrnab bonab minjreb, “Niŋgi Stiven aqa jejamu laŋa gisaŋyiy.” Degyosib silali enjreb. Silali enjrnab naŋgi gisaŋosib mareb, “Stiven a Moses Qotei wo qa misiliŋ anjam mareqnaq iga quoqnem.” ");
INSERT INTO boj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Naŋgi anjam degsib marnabqa Juda tamo uŋgasari naŋgi ti Juda gate naŋgi ti dal anjam qalie tamo naŋgi ti qusibqa Stiven qa minjiŋ oqetnjrnaqa a ojeb. A ojsib koro sawaq osi gilsib Juda tamo kokba naŋgo ulatamuq di tigelteb. ");
INSERT INTO boj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tigeltosib tamo qudei naŋgi dego osi bonab naŋgi Stiven aqa jejamu laŋa gisaŋyosib mareb, “Tamo endi a bati gaigai Qotei aqa atra tal qa ti Moses aqa dal anjam qa ti misiliŋ anjam mareqnu. ");
INSERT INTO boj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bati bei a endegsi marnaq iga quem, ‘Nasaret tamo Yesus a na atra tal endi niñaqyosim Moses aqa dal anjam iga nami egej qaji di dego kobotosim dal anjam bunuj egwas.’” ");
INSERT INTO boj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Onaqa tamo kalil koro sawaq di awesoqneb qaji naŋgi Stiven koqyoqneb. Koqyoqnsib aqa ulatamu laŋ aŋgro aqa ulatamu bulonaq uneb. ");
INSERT INTO boj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Onaqa atra tamo gate a na Stiven nenemyej, “Naŋgo anjam maronub di bole e?” ");
INSERT INTO boj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Onaqa Stiven a kamba marej, “O ijo was ijo abu ti niŋgi ijo anjam endi quiy. Nami gago moma utru Abraham a Mesopotemia sawaq di sosiqa Haran qureq gilosaisonaqa gago Qotei laŋ qureq di unu qaji a Abraham aqa ulatamuq di brantosiqa minjej, ‘O Abraham, ni ino sawa ti ino was naŋgi ti uratnjrsimqa mandam mutu bei e na osormitqa deq gilime.’ ");
INSERT INTO boj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Qotei na Abraham degsi minjnaqa a tigelosiqa Kaldia sawa uratosiq Haran qureq gilsiq di soqnej. Bunuqna aqa abu moinaqa Qotei na a qariŋyonaq mandam mutu iga bini unum qaji endeq bosiq soqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sonaqa Qotei na mandam mutu endi a yosai. A aŋgro saiqoji sonaqa Qotei na minjej, ‘Bunuqna e na ni ti ino moma kalil ŋambabqab qaji naŋgi ti mandam mutu endi eŋgwai.’ ");
INSERT INTO boj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Osiqa minjej, ‘Mati ino moma kalil naŋgi sawa beiq di yauŋ tamo soqnibqa sawa deqaji tamo naŋgi na wau koba enjroqnsib ugeugeinjroqnibqa wausau 400 gilqas. ");
INSERT INTO boj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yimqa e na kamba sawa deqaji tamo naŋgi peginjrsiy ñumitqa ino moma naŋgi sawa di uratosib bosib mandam mutu endia sosib e qa louoqnqab.’ Qotei na nami Abraham degsi minjej. ");
INSERT INTO boj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Osiqa Abraham ombla anjam qosisiqa minjej, ‘Ni muluŋ unqam.’ Degsi minjnaqa Abraham aqa aŋgro Aisak a ŋambabonaqa bati 8 qa muluŋ waiyej. Bunuqna Aisak aqa aŋgro Jekop a ŋambabej. Olo bunuqna Jekop aqa aŋgro 12 naŋgi dego ŋambabeb. Di gago moma utru 12. ");
INSERT INTO boj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Onaqa bati bei Jekop aqa aŋgro 11 naŋgi naŋgo was Josep qa ugeosib a ojsib tamo qudei naŋgo baŋq di atnabqa naŋgi na silali enjrsib Josep osi sumsib Isip sawaq di uratonab soqnej. Josep a Isip sawaq di gulbe ti sonaqa Qotei na aqaryaiyoqnsiqa geregereiyoqnej. Osiqa Josep powo koba yeqnaqa Isip naŋgo mandor a di unoqnsiqa Josep qa are boleiyonaq soqnej. Deqa a na Josep minjej, ‘Ni gate koba sosim Isip sawa taqatqam.’ Degsi minjej deqa Josep a Isip sawa taqatoqnej. A mandor aqa tal dego taqatoqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Bunuqna Isip sawa ti Kenan sawa ti naŋgi mam koba osib gulbe kobaquja iteb. Gago moma utru naŋgi dego iŋgi saiinjrej. ");
INSERT INTO boj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Onaqa Jekop a endegsi quej, ‘Isip sawaq di iŋgi unu.’ Qusiqa gago moma utru naŋgi qariŋnjrnaq iŋgi awaiyqajqa Isip sumeb. Sumsib iŋgi awaiyosib olo puluosib beb. ");
INSERT INTO boj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bunuqna Jekop na gago moma utru naŋgi olo iŋgi awaiyqa qariŋnjrnaq Isip sumeb. Sumsib naŋgo was Josep aqa ulatamuq di tigelonab a segi qa babtonaq naŋgi a qa poinjrej. Josep a aqa abu qa ti aqa was naŋgi qa ti dego babtonaq Isip naŋgo mandor a naŋgi qa poinjrej. ");
INSERT INTO boj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Deqa Josep na aqa was naŋgi olo qariŋnjrnaq aisib Josep aqa leŋ kalil aqa abu Jekop ombla joqsib Isip sumeb. Tamo ti uŋa ti kalil turtonab 75. ");
INSERT INTO boj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bati deqa Jekop a Isip sumsiqa dia sosiq moiyej. Gago moma utru naŋgi dego dia moreŋeb. ");
INSERT INTO boj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Onaqa naŋgo qusa osi bosib Sekem qureq di subq ateleŋeb. Sub di nami Abraham a Hamor aqa aŋgro naŋgoq dena awaiyej. ");
INSERT INTO boj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ariya Israel naŋgi Isip uratosib mandam mutu iga bini unum qaji endeq bqajqa bati jojomej. Bati jojomonaqa Israel naŋgi tulaŋ gargekobaeb. Agi nami Qotei na Abraham minjej, ‘Bunuqna e na ni ti ino moma naŋgi ti mandam mutu endi eŋgwai.’ ");
INSERT INTO boj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bati deqa Isip naŋgo mandor bei tigelej. A Josep qa poiyosai. ");
INSERT INTO boj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Deqa a na gago moma naŋgi gisa gisaŋnjroqnsiq ugeugeinjroqnej. Naŋgo aŋgro ŋambabeqnab a na naŋgi minjreqnaq osi giloqnsib nañuq di uratnjreqnab moreŋoqneb. ");
INSERT INTO boj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Bati deqa Moses a ŋambabej. Qotei a Moses qa are tulaŋ boleiyonaq soqnej. Bai qalub qa Moses aqa ai abu naŋgo talq di a ulitosib geregereiyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bunuqna naŋgi Moses osib yaq di uratonab sonaqa Isip naŋgo mandor aqa aŋgro sebiŋ na itosiq aqa segi qa marsiq a boletonaq tamo kobaqujaej. ");
INSERT INTO boj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A Isip naŋgo skul kobaq giloqnsiq powo koba oqnej. Deqa a tamo siŋgila koba soqnej. A siŋgila na wauoqnsiqa anjam maroqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","24","“Moses aqa wausau 40 kereonaqa a na aqa was Israel naŋgi unjrqajqa marsiqa gilsiq naŋgoq di brantej. Brantonaqa Isip tamo bei na Israel tamo bei qalougeteqnaq unsiqa a kamba Israel tamo di aqaryaiyosiq Isip tamo qalnaq moiyej. ");
INSERT INTO boj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Osiqa are qalej, ‘Ijo was Israel naŋgi ijo kumbra di unsib endegsi poinjrqas, “Bole, Qotei a Moses giltimqa a na iga joqsim Isip sawa uratqom.” ’ Naŋgi degsi poinjrosai. ");
INSERT INTO boj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nebeonaqa Moses a olo walwelosi gilsiq Israel tamo aiyel qoteqnab unjrsiqa naŋgi aiyel potnjrsiq minjrej, ‘Niŋgi aiyel was wo. Kiyaqa niŋgi qoteqnub?’ ");
INSERT INTO boj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Degsi minjrnaqa tamo aqa was qaloqnej qaji a na tigelosiqa Moses aqa baŋ gotraŋyetosiqa minjej, ‘Yai na ni gago gate koba atqoqa iga taqatgosim gago une gereiyqa bonum? ");
INSERT INTO boj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ya ni na Isip tamo bei qalnam moiyej degsim e olo lubsim moiyotbqam e?’ ");
INSERT INTO boj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Onaqa Moses a anjam di qusiqa a ulaŋosiq gilsiq Midian sawaq di yauŋej. Di sosiqa uŋa osiqa aŋgro mel aiyel ŋambabtnjrej. ");
INSERT INTO boj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“A di sosiqa wausau 40 koboonaqa Sainai mana aqa wadau sawaq di ŋam luwit yusiq puloŋeqnaqa Qotei aqa laŋ aŋgro bei ŋam puloŋq di sonaq unej. ");
INSERT INTO boj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Unsiqa are koba qalsiqa olo geregere unqa osiqa ŋam luwit utruq gilej. Gilnaqa ŋam puloŋ miligiq di Tamo Koba a na anjam endegsi minjej, ‘O Moses, e ino moma naŋgo Qotei. E Abraham aqa Qotei. E Aisak aqa Qotei. E Jekop aqa Qotei.’ Degsi minjnaqa Moses a qusiqa ulaugetosiq gindagindaŋej. Osiqa ŋam puloŋ di unqa uratosiqa turuej. ");
INSERT INTO boj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Onaqa Tamo Koba a na olo minjej, ‘Mandam mutu kiñala ni tigelejunum endi getento koba. Deqa ino siŋga tatal piqt. ");
INSERT INTO boj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ni que. Ijo segi tamo uŋgasari naŋgi Isip sawaq di gulbe koba ti sonab e unjreqnum. Naŋgi akamkobaeqnab e queqnum. Deqa e na naŋgi Isip naŋgo mandor aqa baŋq dena eleŋqai. E deqa ni mermqa bonum. Deqa ni tigel. E ni qariŋmitqa Isip aiqam.’ Qotei na Moses degsi minjej. ");
INSERT INTO boj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“O ijo was, Moses qujai di nami Israel naŋgi na qoreiyosib minjeb, ‘Yai na ni gago gate koba atqoqa iga taqatgosim gago une gereiyqa bonum?’ Agi a qujai Qotei na gate koba atsiqa qariŋyonaqa a Israel naŋgoq aisiqa aqaryainjrej. Laŋ aŋgro ŋam luwitq di sosiqa Moses aqaq di brantej qaji a Moses siŋgilatonaq a kumbra di yej. ");
INSERT INTO boj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses qujai dena Isip aisiq dia maŋwa gargekoba yoqnej. Osiqa Israel naŋgi joqsiqa Isip uratosib gilsib wadau sawaq di, Yuwal Lentq di Moses na maŋwa gargekoba yeqnaqa wausau 40 koboej. ");
INSERT INTO boj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses qujai dena Israel naŋgi minjrej, ‘Bunuqna Qotei na aqa medabu o qaji tamo bei e bul nuŋgo ambleq dena tigeltimqa a na niŋgi anjam merŋgoqnqas.’ ");
INSERT INTO boj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses qujai dena Israel naŋgi joqsiq wadau sawaq di korooqneb. Di gago moma naŋgi. Moses qujai di Sainai manaq oqsiq dia laŋ aŋgro bei na anjam minjnaqa a ombla soqneb. Sosibqa Moses a anjam ŋambile unu qaji di Qotei aqaq dena yaiyosiqa gago moma naŋgi enjrej. ");
INSERT INTO boj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ariya Moses a Sainai mana goge di sonaqa gago moma naŋgi na aqa anjam dauryqa uratosib a qoreiyosib olo puluosib Isip aiqajqa maroqneb. ");
INSERT INTO boj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Osib atra tamo gate Aron endegsib minjeb, ‘Ni gago qotei qudei gereiyetgimqa naŋgi na iga joqsib puluosim Isip olo aiqom. Moses agi iga Isip dena joqsi bej qaji bini a qabitqo kiyo di iga qaliesai.’ Naŋgi na Aron degsib minjeb. ");
INSERT INTO boj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Minjsib bati deqa naŋgi na makau sigitosib aqa sulum gereiyosib gisaŋ qotei di atraiyosib areboleboleinjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Naŋgi kumbra degyeb deqa Qotei na naŋgi qoreinjrnaqa naŋgi seŋ ti bai ti bongar ti biŋinjroqneb. Naŋgo kumbra deqa Qotei aqa medabu o qaji tamo naŋgi bunuqna endegsib neŋgreŋyeb, ‘O Israel tamo uŋgasari, niŋgi wausau 40 wadau sawaq di sosibqa makau ti kaja ti ñumoqnsib gisaŋ qotei naŋgi atrainjroqneb. Niŋgi e atraibosaioqneb. ");
INSERT INTO boj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Niŋgi gisaŋ qotei Molek aqa tal ti gisaŋ qotei Refan aqa bongar ti sigitosib naŋgo sulum gereiyosib wadau sawaq di osi laqnsib naŋgi biŋinjroqneb. Nuŋgo une deqa e niŋgi wiŋgitqa niŋgi sawa endi uratosib Babilon qure taqal beiq gilsib di sqab.’ Qotei aqa medabu o qaji tamo naŋgi anjam degsib neŋgreŋyeb. ");
INSERT INTO boj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Gago moma naŋgi wadau sawaq di sosibqa Qotei aqa tal gara na gereiyo qaji di osi laqneb. Tal di Qotei na nami sigitosiqa Moses osoryonaqa degsi gereiyej. Tal dia Qotei na aqa anjam bole babtoqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bunuqna gago moma naŋgi tal di onabqa Josua na naŋgi joqsi bosiqa mandam mutu endia soqneb. Sonabqa Qotei a Josua minjnaqa a na sawa bei bei qaji naŋgi winjrnaq jaraiyonabqa Qotei a gago moma naŋgi mandam mutu endi enjrej. Bati deqa gago moma naŋgi Qotei aqa tal di osi bosib mandam mutu endia atnab soqnej gilsi gilsiq Devit aqa batiej. ");
INSERT INTO boj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Qotei a Devit qa are boleiyonaq soqnej deqa Devit a endegsi pailyej, ‘O Jekop aqa Qotei, ni e odbimqa e ni sqajqa tal kobaquja gereiyetmqai.’ ");
INSERT INTO boj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ariya a tal gereiyosai. Bunuqna Devit aqa ŋiri Solomon a na tal di Qotei gereiyetej. ");
INSERT INTO boj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“O was niŋgi quiy. Qotei Goge Koba a tal tamo na gereiyo qaji dia sqasai. Aqa medabu o qaji tamo bei a nami anjam endegsi marej, ");
INSERT INTO boj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tamo Koba a marqo, “Laŋ qure a ijo awo jaram koba. Mandam a ijo siŋga atqajqa sawa. Deqa e sqajqa tal niŋgi na gereiyetbqa keresai. E aqaratqajqa sawa bei sosai. ");
INSERT INTO boj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","E ijo segi baŋ na iŋgi iŋgi kalil di gereiyem unu.” ’” ");
INSERT INTO boj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven a anjam kalil di marekritosiq olo Juda tamo kokba naŋgi siŋgila na endegsi minjrej, “Niŋgi anjam gotraŋyo ani tamo. Nuŋgo are Qotei aqaq di sosai. Niŋgi sawa bei bei qaji naŋgi bul. Niŋgi Qotei aqa anjam quqwa urateqnub. Niŋgi bati gaigai Mondor Bole aqa anjam dego quqwa urateqnub. Nuŋgo moma naŋgi kumbra deqaji yoqneb agi niŋgi na olo yeqnub. ");
INSERT INTO boj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Qotei aqa medabu o qaji tamo naŋgi na nuŋgo moma naŋgi anjam endegsib minjroqneb, ‘Kumbra Bole Yeqnu Qaji Tamo a bqas.’ Degsib minjreqnab naŋgi quqwa uratoqneb. Osib Qotei aqa medabu o qaji tamo kalil naŋgi ugeugeinjroqnsib ñumoqneb. Bei uratosaioqneb. Ariya tamo di a bonaqa niŋgi na nuŋgo moma naŋgo kumbra uge di dauryosib agi tamo di ojsib jeu tamo naŋgo baŋq di ateb. Atnabqa naŋgi na qalnab moiyej. Tamo di agi Yesus. ");
INSERT INTO boj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Moses a laŋ aŋgro naŋgo baŋq dena dal anjam yainjrej. Dal anjam di niŋgi na osib olo dauryqa urateqnub.” Stiven a Juda tamo kokba naŋgi degsi minjrej. ");
INSERT INTO boj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Onaqa Juda tamo kokba naŋgi Stiven aqa anjam di qunab are qametnjrnaqa minjiŋ ani oqetnjrnaqa qalagei anjam atoqnej. ");
INSERT INTO boj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bati qujai deqa Mondor Bole na Stiven siŋgila yonaqa a laŋ goge tarosiqa Qotei aqa riaŋ koba unej. Unsiqa Yesus a dego Qotei aqa baŋ woq di tigelesonaq unej. ");
INSERT INTO boj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Osiqa Juda tamo kokba naŋgi minjrej, “Niŋgi quiy. Laŋ waqwoqa Tamo Aŋgro a Qotei aqa baŋ woq di tigelesonaq e unonum.” ");
INSERT INTO boj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Stiven a naŋgi degsi minjrnaqa naŋgi kalil aqa anjam di quqwa uratosib tulaŋ murqumyosib naŋgo dabkala baŋ na getentosib gurgur ti gilsib siŋgila na Stiven ojeb. ");
INSERT INTO boj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ojsib meniŋ na qalib moiqajqa titosib qure polomq osi gileb. Osi gilsib meniŋ na qaloqneb. Tamo naŋgi nami Stiven aqa jejamu laŋa gisaŋyeb qaji naŋgi na naŋgo gara jugo piqteleŋosib aŋgro wala bei aqa ñam Sol aqa siŋgaq di koroiyeb. ");
INSERT INTO boj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tamo kalil naŋgi meniŋ na Stiven qaleqnabqa a moiqa osiqa endegsi pailyej, “O Tamo Koba Yesus, ni na ijo qunuŋ ame.” ");
INSERT INTO boj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Degsi pailyosiqa siŋga tombol na awoosiq tulaŋ maosiq marej, “O Tamo Koba, naŋgi e lubonub naŋgo une deqa ni na kambatnjraime.” A degsi pailyosiqa moiyej. ");
INSERT INTO boj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Naŋgi Stiven qalnab moinaqa Sol a di unsiqa tulaŋ areboleboleiyej. Osiqa marej, “Keretosib Stiven qalnub moiqo.” Onaqa tamo qudei Qotei aqa kumbra dauryoqneb qaji naŋgi Stiven moiyej deqa akamkobaoqnsib bosib aqa jejamu osib subq ateb. Bati deqa Jerusalem dia Juda tamo kokba naŋgi Kristen naŋgi qa minjiŋ oqetnjrnaqa ugeugeinjroqneb. Deqa Kristen naŋgi segi segi jaraiyosib Judia sawa ti Samaria sawa ti deq giloqneb. Yesus aqa anjam maro tamo naŋgi segi Jerusalem di soqneb. Naŋgi jaraiyosai. ");
INSERT INTO boj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol a dego Kristen naŋgi qa minjiŋ oqeqnaqa ugeugeinjroqnej. A naŋgo segi segi talq giloqnsiqa tamo ti uŋa ti ojeleŋoqnsiqa naŋgi joqoqnsiq aiyoqnsiqa tonto talq di breinjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesus aqa tamo uŋgasari jaraiyeb qaji naŋgi sawa bei beiq di Qotei aqa anjam bole palontoqnsib laqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip a Samaria naŋgo qure kobaqujaq gilsiq dia naŋgi Kristus aqa anjam minjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Minjroqnsiqa maŋwa gargekoba yeqnaqa naŋgi unoqnsib Filip aqa anjam dauryoqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tamo uŋgasari gargekoba naŋgi mondor uge ti sonabqa Filip na mondor uge wiyetnjreqnaqa mondor uge naŋgi naŋgo jejamu uratoqnsib tulaŋ leleŋoqnsib jaraiyoqneb. Tamo uŋgasari jejamu lainjro qaji ti siŋga qandamnjro qaji ti gargekoba Filip na boletnjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Deqa qure dia tamo uŋgasari naŋgi tulaŋ areboleboleinjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Qure dia quñam tamo bei soqnej aqa ñam Saimon. A nami quñam gargekoba yoqnsiqa aqa segi ñam soqtoqnsiqa maroqnej, “E tamo kobaquja.” Degyeqnaqa tamo uŋgasari qure dia soqneb qaji naŋgi a ulaiyoqnsibqa biŋiyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Deqa tamo ñam ti tamo laŋaj ti kalil qure dia soqneb qaji naŋgi Saimon aqa anjam quoqnsib dauryoqneb. Osib aqa ñam soqtoqnsib maroqneb, “Tamo endi a siŋgila koba. A Qotei aqa siŋgila na waueqnu.” ");
INSERT INTO boj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naŋgi degyoqneb. Di kiyaqa? Saimon a nami quñam qaloqnsiq maŋwa gargekoba yoqnej deqa. Degsi yonaq yonaq naŋgi a unoqnsib biŋiyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ariya Qotei na aqa segi tamo uŋgasari naŋgi taqatnjrsim naŋgo Mandor Koba sqas anjam bole di Filip a palontoqnsiqa Yesus Kristus aqa ñam mare mare laqnej. Laqnaqa tamo uŋgasari gargekoba naŋgi quoqnsib are bulyoqnsib Yesus qa naŋgo areqalo siŋgilatoqneb. Degyeqnabqa Filip na naŋgi yansnjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Onaqa Saimon a dego Filip aqa anjam di qusiqa quñam uratosiq are bulyosiq aqa areqalo Yesus qa siŋgilatej. Deqa Filip na Saimon dego osiq yansej. Yansonaqa Saimon a Filip dauryosiq laqnsiqa Qotei na Filip aqa baŋ na maŋwa gargekoba yeqnaq unoqnsiqa tulaŋ prugoqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","15","Bati deqa Samaria tamo uŋgasari gargekoba naŋgi Qotei aqa anjam osib Yesus qa naŋgo areqalo siŋgilatoqneb. Deqa Yesus aqa anjam maro tamo Jerusalem di soqneb qaji naŋgi degsi qusibqa Pita Jon wo qariŋnjrnab Samaria naŋgoq gileb. Gilsib Samaria naŋgi qa endegsib Qotei pailyeb, “O Abu, ni na Samaria naŋgi ino Mondor Bole enjrime.” Degsib Qotei pailyeb. ");
INSERT INTO boj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Di kiyaqa? Bati di Qotei aqa Mondor naŋgoq aiyosaisoqnej deqa. Naŋgi Tamo Koba Yesus aqa ñam na segi yanso eb. ");
INSERT INTO boj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ariya naŋgi aiyel Samaria naŋgi qa pailyoqnsibqa naŋgo gateq di baŋ ateqnab naŋgi Qotei aqa Mondor oqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pita Jon wo naŋgi degyeqnabqa Saimon a unsiqa silali osi bosiqa naŋgi aiyel silali enjrqa osiqa minjrej, ");
INSERT INTO boj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Niŋgi e dego siŋgila ebibqa e kamba tamo qudei naŋgo gateq di baŋ atoqnitqa naŋgi Mondor Bole oqnqab.” ");
INSERT INTO boj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Degsi minjrnaqa Pita na minjej, “Qotei aqa siŋgila endi a na iga laŋa egwo. Iga silali na awaiyosai. Deqa ni silali na awaiyqa maraim. Ni kumbra ugetonum. Deqa ni ino silali qoji padalqam. ");
INSERT INTO boj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ino are miligi Qotei na unqo bolesai. Deqa ni iga ombla wau endi ojqa keresai. ");
INSERT INTO boj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","E ni numonum ino are miligi tulaŋ uge. Ino kumbra uge dena ni siŋgila na ojejunu. Deqa ni are bulyosim ino kumbra uge di urat. Osim Tamo Koba pailyimqa a ino are uge di taqal waiyetmqas. Yim a ni qa olo are boleiyqas.” ");
INSERT INTO boj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Onaqa Saimon na minjrej, “Niŋgi segi aiyel e qa Tamo Koba pailyiy. Yimqa e padalqa merbonub di e padalqasai.” ");
INSERT INTO boj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ariya Pita Jon wo naŋgi qure dia Tamo Koba aqa anjam bole palontoqnsib aqa kumbra kalil qa saoqneb. Osib bati bei olo puluosib Jerusalem aiyoqnsib Samaria naŋgo qure qure kalilq di brantoqnsib Yesus aqa anjam bole minjre minjre aiyeqnab quoqneb. ");
INSERT INTO boj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Onaqa Tamo Koba aqa laŋ aŋgro bei a Filip aqaq aisiqa minjej, “Ni tigelosim gam Jerusalem dena Gasa qureq aiyejunu deq aiye.” Gam di wadau sawaq di unu. ");
INSERT INTO boj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Onaqa Filip a laŋ aŋgro aqa anjam di qusiqa tigelosiq gam deq aiyej. Aisiq ŋam atej di Itiopia tamo bei a Qotei louqajqa Jerusalem gilsiq dena puluosiq Itiopia sawaq olo aiyeqnaqa gamq di turej. Tamo di a tamo kobaquja. A Itiopia naŋgo mandor aqa ñoro taqatoqnej. Mandor di aqa ñam Kandasi. A uŋa. Aqa ñoro ti silali ti kalil tamo dena taqatoqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aqa karis goge di awoosiqa Qotei aqa medabu o tamo Aisaia aqa anjam neŋgreŋq di so qaji di sisiyoqnsiq aiyoqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Onaqa Mondor na Filip minjej, “Ni gilsim karis di jojomye.” ");
INSERT INTO boj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Degsi minjnaqa Filip a ururosiq karis jojomyosiqa tamo di a Aisaia aqa anjam sisiyeqnaqa qusiqa nenemyej, “Ni anjam sisiyeqnum di aqa damu poimqo e?” ");
INSERT INTO boj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Onaqa tamo dena minjej, “E kiyersiy anjam endi aqa damu poibqas? Tamo bei na anjam endi aqa damu plaltosim merbimqa e poibqas.” Osiqa Filip metonaqa a karis gogetosiqa ombla awoeb. ");
INSERT INTO boj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tamo di a Qotei aqa anjam endegsi sisiyoqnej, “A kaja du bul qalib moiqajqa osi gileb. Kaja naŋgi juŋgum joqetnjreqnab mequmosib unub dego kere a mequmesoqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Naŋgi a tulaŋ ugeugeiyosib gisaŋ anjam gargekoba aqa jejamuq di laŋa qametoqneb. Deqa a mandamq endi olo sqasai. A aŋgro saiqoji unu deqa tamo qudei na aqa aŋgro bei qa marqa keresai.” ");
INSERT INTO boj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itiopia tamo dena anjam di sisiyekritosiq Filip minjej, “Ni e merbe. Qotei aqa medabu o qaji tamo aqa anjam endi yai qa neŋgreŋyej? A segi qa kiyo tamo bei qa kiyo neŋgreŋyej?” ");
INSERT INTO boj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Onaqa Filip a anjam dena utru atsiq Qotei aqa anjam qudei ti turtosiq Yesus qa saiyoqnej. ");
INSERT INTO boj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Onaqa naŋgi gam dauryosib aiyoqnsib gam qalaq di ya bei sonaq unsibqa Itiopia tamo dena Filip minjej, “Ni une. Ya agide. Iŋgi bei na e getentbqa keresai. Deqa ni e yansbe.” ");
INSERT INTO boj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Onaqa Filip na minjej, “Ni are bulyosim ino areqalo kalil Yesus qa siŋgilatqam di e ni yansmqai.” Onaqa minjej, “E ijo areqalo Yesus Kristus qa siŋgilatosim poibqo, a Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Degsi minjsiqa aqa karis tigeltosiq naŋgi aiyel mandamq aisib Filip na a osiq yaq aisiq yansej. ");
INSERT INTO boj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Onaqa naŋgi aiyel yaq dena tigelonabqa Tamo Koba aqa Mondor na Filip loumtosiq osi gilsiqa sawa beiq di atnaqa Itiopia tamo a olo Filip unosai. A yanso ej deqa a tulaŋ areboleboleiyonaqa gam dauryosiq aiyej. ");
INSERT INTO boj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Onaqa Filip a Asdot qureq di brantosiq dena walweloqnsiqa qure qureq di Yesus aqa anjam bole tamo uŋgasari naŋgi minjroqnsiq gilsiq Sisaria qureq di brantej. ");
INSERT INTO boj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bati deqa Sol na tamo uŋgasari Tamo Koba Yesus dauryoqneb qaji naŋgi ugeugeinjrsim moiyotnjrqajqa siŋgila na maroqnej. Deqa a atra tamo gate aqaq gilsiqa minjej, ");
INSERT INTO boj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Ni anjam bei neŋgreŋyosim ebimqa e anjam di osiy gilsiy Damaskus qureq di Juda tamo kokba naŋgi enjrqai. Enjritqa naŋgi na anjam di sisiyosib e odbibqa tamo uŋgasari Damaskus qureq di Yesus aqa gam dauryeqnub qaji naŋgi tontnjrsiy joqsiy Jerusalem bqai.” ");
INSERT INTO boj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","4","Degsi minjnaqa anjam di neŋgreŋyosiq yonaqa walwelosi gilsiq Damaskus qure jojomyeqnaqa gamq di puloŋ siŋgila koba minjal ti laŋ goge na aqaq aisiq tulaŋ riaŋonaqa a uloŋosiq mandamq di ŋeiej. Ŋeiesosiqa Yesus aqa kakro quej. Yesus na minjej, “O Sol, ni kiyaqa e ugeugeibeqnum?” ");
INSERT INTO boj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Onaqa Sol na minjej, “O Tamo Koba, ni yai?” Onaqa minjej, “E Yesus agi ni na ugeugeibeqnum. ");
INSERT INTO boj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Deqa ni tigelosim Damaskus qureq gile. Gilsim dia tamo bei itqam. A na ni wau kiye yqam di mermqas.” ");
INSERT INTO boj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Onaqa tamo naŋgi Sol ombla walweloqneb qaji naŋgi Yesus aqa kakro qusib ŋam ateb naŋgi tamo bei unosai. Deqa naŋgi ulaosib mequmosib laŋa tigelesoqneb. ");
INSERT INTO boj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Onaqa Sol a mandamq dena tigelosiqa ŋam plaltej a sawa unqa keresai. Deqa naŋgi a babaŋyosib Damaskus qureq osi gileb. ");
INSERT INTO boj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sol a bati qalub ŋam qandimyonaq soqnej. Deqa a iŋgi bei uyosai. A ya uyosai dego. ");
INSERT INTO boj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskus qureq di tamo bei aqa ñam Ananaias a soqnej. A Yesus dauryoqnej qaji. Tamo Koba a na aqa areqalo waqtetosiqa ŋeiobilqei na minjej, “O Ananaias.” Onaqa minjej, “Tamo Koba, e agiende.” ");
INSERT INTO boj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Onaqa Tamo Koba a na minjej, “Ni tigelosimqa gam bei aqa ñam Tiŋtiŋ di dauryosim gilsim Judas aqa talq di brantqam. Tarsus tamo bei aqa ñam Sol a dia pailyoqnsiq unu di unqam. ");
INSERT INTO boj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","E na Sol aqa areqalo waqtetonumqa a ŋeiobilqei na kumbra endegsi unqo. Tamo bei aqa ñam Ananaias a bosim Sol aqaq di baŋ atimqa ŋam poiyim sawa unqas.” ");
INSERT INTO boj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","14","Onaqa Ananaias na kamba minjej, “O Tamo Koba, Sol a Jerusalem dia ino tamo uŋgasari naŋgi tulaŋ ugeugeinjreqnu. Atra tamo kokba naŋgi na a qariŋyonab Damaskus qure endeq bej. A qure endia tamo uŋgasari ino ñam metoqnsib pailmeqnub qaji naŋgi tontnjrsim joqsim Jerusalem aiqajqa deqa bej. Tamo gargekoba naŋgi degsib mareqnab e queqnum.” ");
INSERT INTO boj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Onaqa Tamo Koba a na Ananaias minjej, “Ni ijo anjam dauryosim Sol aqaq gile. Sol a ijo wau tamo. E na a giltem deqa a ijo ñam osi walwelosim sawa sawa kalilq di tamo uŋgasari Qotei qaliesai qaji naŋgi ti mandor kokba ti Israel naŋgi ti ijo ñam ubtosim minjroqnqas. ");
INSERT INTO boj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","A ijo ñam qa gulbe gargekoba itoqnqas. Gulbe di e na osoryoqnit itoqnqas.” ");
INSERT INTO boj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Onaqa Ananaias na minjej, “Od, Tamo Koba, e ino anjam dauryqai.” Osiqa tigelosiq gilsiq Sol soqnej qaji tal di gogetosiqa Sol aqaq di baŋ atsiqa minjej, “O ijo was Sol, Tamo Koba Yesus agi gamq di a segi qa babtonaq ni unem qaji a na e endegsi merbqo, ‘Ni gilsim Sol boletimqa aqa ŋamdamu olo poiyqas. Yimqa Mondor Bole a Sol aqa are miligiq aisim a siŋgilatqas.’ O Sol, Yesus na e degsi merbosiqa qariŋbqoqa agi e inoq bonum.” ");
INSERT INTO boj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias na Sol degsi minjnaqa bati qujai deqa iŋgi bei qe gajige bul Sol aqa ŋamdamuq dena uloŋonaq ŋam poiyonaqa sawa unej. Sawa unsiqa tigelonaq Ananaias na Yesus aqa ñam na yansej. ");
INSERT INTO boj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","20","Yansonaqa a iŋgi uynaqa jejamu siŋgilaej. Sol a bati qudei Damaskus qureq di tamo uŋgasari Yesus dauryoqneb qaji naŋgi koba na korooqneb. A Juda naŋgo Qotei tal dego miligiq giloqnsiqa naŋgi endegsi minjroqnej, “Yesus a Qotei aqa Ŋiri.” ");
INSERT INTO boj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yeqnaqa tamo uŋgasari aqa anjam quoqneb qaji naŋgi tulaŋ prugoqnsib maroqneb, “Niŋgi uniy. Sol a Yesus aqa anjam mare mare laqnu. A nami Jerusalem dia tamo uŋgasari Yesus aqa ñam metoqnsib pailyeqnub qaji naŋgi ugeugeinjroqnej. Osiqa Damaskus endia dego naŋgi tontnjrsim atra tamo kokba naŋgoq olo joqsim aiqajqa bej.” Tamo uŋgasari naŋgi degsib maroqnsib tulaŋ prugoqneb. ");
INSERT INTO boj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol a siŋgila na Qotei aqa wau yeqnaqa aqa siŋgila ti powo ti tulaŋ kobaoqnej. Deqa a Qotei aqa anjam geregere plaltoqnsiqa endegsi maroqnej, “Yesus a bole Kristus Qotei na qariŋyej qaji.” Degsi mareqnaqa Juda tamo kokba Damaskus di soqneb qaji naŋgi aqa anjam qalotqa keresaiinjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Onaqa bati gargekoba yala koboonaqa Juda tamo kokba naŋgi koroosib mareb, “Iga Sol qalsim moiyotqom.” ");
INSERT INTO boj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","25","Naŋgi degsib marsibqa Sol a ulaŋaim deqa naŋgi qolo ti qanam ti qure aqa siraŋme kalil taqatesoqneb. Taqatesonabqa tamo uŋgasari Sol dauryoqneb qaji naŋgi na qolo a osib gumbaq di jigsib qure aqa jeŋ gogetosib sil na gumba tontosib goge na ura uratonab jeŋ qalaq aiyej. ");
INSERT INTO boj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bunuqna Sol a walwelosiqa Jerusalem di brantosiq tamo uŋgasari Yesus dauryoqneb qaji naŋgoq gilsiqa minjrej, “E niŋgi koba na Qotei aqa wau ojqom.” Degsi minjrnaqa naŋgi a ulaiyosib saidyeb. Di kiyaqa? A Yesus dauryoqnej di naŋgi poinjrosai deqa. ");
INSERT INTO boj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Onaqa Barnabas na Sol osiqa Yesus aqa anjam maro tamo naŋgoq gilsiqa Sol a nami gamq di Tamo Koba unnaqa anjam minjej qaji deqa naŋgi sainjrej. Sol a Damaskus dia Yesus aqa ñam na anjam mare mare laqnej a ulaosaioqnej deqa ti Barnabas na naŋgi sainjrej. ");
INSERT INTO boj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Deqa naŋgi Sol osib koba na soqneb. Sosibqa Sol a Jerusalem dia Tamo Koba aqa ñam na anjam mare mare laqnej. A ulaosaioqnej. ");
INSERT INTO boj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Bati bei Sol a Juda tamo qudei ti anjam na qotoqneb. Tamo naŋgi di Grik anjam maro qaji. Naŋgi Sol ombla anjam na qotsibqa naŋgi a qa ugeosib mareb, “Iga Sol qalsim moiyotqom.” ");
INSERT INTO boj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Onaqa Yesus aqa tamo uŋgasari naŋgi deqa qusibqa Sol osib Sisaria qureq osi gileb. Gilsib dena Sol qariŋyonabqa Tarsus qureq gilej. ");
INSERT INTO boj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bati deqa Judia sawaq di, Galili sawaq di, Samaria sawaq di dego tamo uŋgasari Yesus qa naŋgo areqalo siŋgilateb qaji naŋgi geregere lawo na soqneb. Naŋgi bati gaigai Tamo Koba aqa sorgomq di sonabqa Mondor Bole na are siŋgilatetnjroqnej. Tamo uŋgasari gargekoba naŋgi are bulyoqnsib Kristen naŋgo miligiq aiyeqnab naŋgi tulaŋ kobaoqneb. ");
INSERT INTO boj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ariya Pita a sawa bei beiq di laqnsiqa gilsiq Lida qureq di brantej. Brantosiqa Qotei aqa segi tamo uŋgasari qure dia soqneb qaji naŋgi itnjrej. ");
INSERT INTO boj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","34","Dia tamo bei soqnej aqa ñam Ainias. A jejamu laiyonaq soqnej. Wausau 8 a bijalq di ŋeiesoqnej. Onaqa Pita na unsiqa minjej, “Ainias, Yesus Kristus na ni boletmqo. Deqa ni tigelosim ino bijal qale.” Degsi minjnaqa aqa jejamu siŋgilaonaq a tigelej. ");
INSERT INTO boj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Onaqa tamo uŋgasari kalil Lida qure ti Saron sawa ti dia soqneb qaji naŋgi tamo di boleonaq unsibqa naŋgi are bulyosib Tamo Koba qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa qureq di uŋa bei soqnej aqa ñam Tabita. A Yesus dauryoqnej qaji. Grik anjam na aqa ñam Dorkas. A uŋa bolequja. A gaigai kumbra tulaŋ bolequja yoqnsiqa tamo uŋgasari iŋgi iŋgi saiqoji naŋgi lueinjroqnsiq iŋgi anainjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bati bei a maiyosiq moiyej. Moinaqa uŋa qudei na aqa jejamu yansosib warum bei goge di atnab soqnej. ");
INSERT INTO boj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida qure di Jopa qure jojom. Deqa Jopa qureq di tamo uŋgasari Yesus dauryoqneb qaji naŋgi Pita a Lida qureq di soqnej di qusibqa tamo aiyel qariŋnjrnab aisib Pita minjeb, “Ni urur au. Ni iga daurgosim koba na Jopa qureq gilqom.” ");
INSERT INTO boj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Onaqa Pita a tigelosiqa naŋgi daurnjrsiqa koba na gilsib Jopa qureq di branteb. Brantonabqa naŋgi Pita osib uŋa moiyej qaji aqa warum miligiq gileb. Gilnabqa uŋa qobul kalil naŋgi Pita aqa areq di koroosib akamoqneb. Osib gara jugo ti gara tugo ti nami Dorkas a naŋgi koba na sosibqa gereiyeleŋej qaji di Pita osoryeb. ");
INSERT INTO boj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Onaqa Pita a naŋgi minjrej, “Niŋgi kalil oqediy.” Degsi minjrnaqa naŋgi oqedonab siŋga pulutosiq Qotei pailyej. Pailyosiq koboonaqa uŋa moiyej qaji aqa areq gilsiqa minjej, “O Tabita, ni tigel.” Degsi minjnaqa a ŋam plaltosiqa Pita unsiq tigelosiq awoej. ");
INSERT INTO boj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Onaqa Pita na aqa baŋ ojsiq tigeltej. Tigeltosiqa Qotei aqa segi tamo uŋgasari naŋgi ti uŋa qobul naŋgi ti metnjrnaqa naŋgi warum miligiq bosib Tabita uneb a ŋambile soqnej. ");
INSERT INTO boj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Onaqa Jopa qureq di tamo uŋgasari kalil naŋgi maŋwa deqa qusibqa naŋgi gargekoba Tamo Koba qa naŋgo areqalo siŋgilateb. ");
INSERT INTO boj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Onaqa Pita a bati gargekoba yala Jopa qureq di soqnej. Tamo bei wagme aqa jegara na iŋgi iŋgi gereiyo qaji aqa ñam Saimon aqa talq di a ombla soqneb. ");
INSERT INTO boj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria qureq di tamo bei soqnej aqa ñam Kornilius. A Rom tamo. A qaja tamo naŋgo gate. A na qaja tamo 100 naŋgi taqatnjroqnej. Qaja tamo naŋgi di Itali sawa qaji. ");
INSERT INTO boj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius a Qotei aqa kumbra dauryoqnej qaji. Deqa tamo uŋgasari kalil a ombla tal qujaiq di soqneb qaji naŋgi a ti Qotei aqa sorgomq di soqneb. Juda naŋgi iŋgi iŋgi saiinjreqnaqa a naŋgi silali qa aqaryainjroqnej. A bati gaigai Qotei pailyoqnej. ");
INSERT INTO boj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ariya bati bei seŋ keliŋtonaqa Qotei na Kornilius aqa areqalo waqtetonaqa ŋeio bulosiqa Qotei aqa laŋ aŋgro bei aqaq bonaq unej. Unnaqa laŋ aŋgro dena minjej, “O Kornilius.” ");
INSERT INTO boj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Onaqa Kornilius na laŋ aŋgro di koqyosiqa tulaŋ ulaugetosiq minjej, “O Tamo Koba, ni kiyaqa ijoq bonum?” Onaqa laŋ aŋgro dena minjej, “Qotei a gaigai ino pailyo queqnu. Juda naŋgi iŋgi iŋgi saiinjreqnaqa ni na naŋgi aqaryainjreqnum. Ino kumbra di Qotei a unoqnsiq deqa a ni qa tulaŋ areboleboleiyeqnu. ");
INSERT INTO boj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Deqa ni que. Ni na tamo qudei naŋgi qariŋnjrimqa Jopa qureq aisib dia tamo bei aqa ñam Saimon ñam bei Pita a itqab. A itosib osib babqa a na anjam bei ni mermqas. ");
INSERT INTO boj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A tamo bei wagme aqa jegara na iŋgi iŋgi gereiyo qaji aqa ñam Saimon aqa talq di unu. Aqa tal agi alile qalaq di unu.” ");
INSERT INTO boj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Laŋ aŋgro dena Kornilius anjam degsi minjsiq olo ulaŋonaqa Kornilius na aqa kaŋgal tamo aiyel metnjrnaqa aqa areq beb. Qaja tamo qujai dego metonaq aqa areq bej. Qaja tamo di a Qotei aqa kumbra dauryoqnej qaji. A bati gaigai Kornilius ombla sosiqa wauetoqnej. ");
INSERT INTO boj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Onaqa Kornilius na anjam kalil laŋ aŋgro a marej qaji di naŋgi qalub minjrsiqa qariŋnjrnaq Jopa qureq aiyeb. ");
INSERT INTO boj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naŋgi walwelosi aisib gamq di qoloinjrnaqa ŋereŋeb. Olo nebeonaqa tigelosib aisib Jopa qure jojomyeqnabqa bati qujai deqa Pita a Qotei pailyqa osiqa warum bei gogeqsi deq oqej. Di qanam jige. ");
INSERT INTO boj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Oqsiq warum dia sonaqa a mamyonaqa uŋa qudei naŋgi minjrnaqa iŋgi goiyeteb. Iŋgi goiyeqnabqa Qotei na Pita aqa areqalo waqtetonaqa a ŋeio bulej. A ŋeio bulosiqa laŋ waqonaq iŋgi bei gara kobaquja bul plalosiq mutu qolqeq di ojeleŋosib laŋ goge dena ura uratonab aiyeqnaq unej. ");
INSERT INTO boj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Gara miligiq di wagme utru segi segi soqneb. Bel ti bauŋ ti amal ti bagu ti qebari ti sonab unjrej. ");
INSERT INTO boj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Unjrsiqa kakro bei quej. A marej, “Pita, ni tigelosim wagme bei qalsim uye.” ");
INSERT INTO boj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Onaqa Pita na minjej, “O Tamo Koba, e uyqasai! Wagme uge uge deqaji e nami uyosaioqnem. Wagme deqaji uyqajqa di getento koba.” ");
INSERT INTO boj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Osiqa Pita a kakro di olo quej. A marej, “Iŋgi iŋgi e jiga saiqoji qa maronum di ni olo uge qa maraim.” ");
INSERT INTO boj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gara di degsi aiyoqalubtosiqa olo torei oqej. ");
INSERT INTO boj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ŋeio di aqa utru Pita a poiyosai. Deqa a are koba qalsiq soqnej. Onaqa tamo qalub Kornilius na qariŋnjrej qaji naŋgi Jopa qureq di brantosib tamo qudei naŋgi endegsib nenemnjreb, “Saimon aqa tal qabi unu?” Degsib nenemnjrnabqa naŋgi na minjreb, “Saimon aqa tal agide.” Onaqa naŋgi walwelosib Saimon aqa tal meq di tigeleb. ");
INSERT INTO boj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tigelosib maosib mareb, “Saimon ñam bei Pita a tal endi unu e?” ");
INSERT INTO boj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita a ŋeio deqa are koba qaleqnaqa Qotei aqa Mondor na minjej, “Ni que. Tamo qalub bosib ni qa maronub. ");
INSERT INTO boj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Deqa ni tigelosim naŋgi daurnjrsim gile. Ni are gulbeimaiq. E na naŋgi qariŋnjronum bonub.” ");
INSERT INTO boj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Onaqa Pita a tal uratosiq mandamq aisiq naŋgo areq di brantosiq minjrej, “Niŋgi tamo ŋameqnub qaji agi e di. Niŋgi kiyaqa bonub?” ");
INSERT INTO boj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Onaqa naŋgi na minjeb, “Qaja tamo gate aqa ñam Kornilius a tamo bolequja. A Qotei aqa sorgomq di sosiqa kumbra bole dauryeqnu. Juda kalil naŋgi a qa mareqnub, ‘A tamo bolequja.’ Ni que. Ya bilaq Qotei aqa laŋ aŋgro bei a Kornilius aqaq di brantosiq minjej, ‘Ni tamo qudei naŋgi qariŋnjrimqa aisib Pita minjib ino talq bosim anjam bei mermim quqwam.’” ");
INSERT INTO boj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Onaqa Pita a naŋgo anjam di qusiqa naŋgi joqsiqa tal a soqnej qaji dia koba na soqneb. Ŋereŋosib nebeonaqa Pita a naŋgi koba na tigelosib gileb. Jopa tamo qudei Yesus dauryoqneb qaji naŋgi dego koba na gileb. ");
INSERT INTO boj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Naŋgi gilsib gamq di qoloinjrnaqa ŋereŋeb. Olo nebeonaqa naŋgi tigelosib gilsib Sisaria qureq di branteb. Kornilius a naŋgi qa tariŋoqnsiq ŋam atoqnej. A na aqa tamo si naŋgi ti aqa segi leŋ naŋgi ti kalil minjrnaq bosib a ti koroosib tariŋoqneb. ");
INSERT INTO boj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Onaqa Pita a gilsiqa Kornilius aqa talq di brantej. Brantosiqa tal gogetonaqa Kornilius a bosiqa Pita aqa siŋgaq di siŋga pulutosiqa a biŋiyej. ");
INSERT INTO boj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Onaqa Pita na Kornilius tigeltosiq minjej, “Ni tigel. Ni e biŋibaim. Aqo ombla mandam tamo.” ");
INSERT INTO boj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Degsi minjsiqa naŋgi ombla anjam qairosib warum bei miligiq gileb. Warum miligiq di tamo uŋgasari gargekoba naŋgi koroesonab unjrej. ");
INSERT INTO boj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Unjrsiqa minjrej, “Niŋgi qalie, e Juda tamo. Niŋgi Juda tamo sai. Niŋgi sawa bei qaji. Deqa gago Juda kumbra agiende. Iga nuŋgo tal gogetqajqa getento koba. Iga niŋgi koba na laqajqa dego getento koba. Moses aqa dal anjam nami degsi neŋgreŋyej unu. Ariya Qotei na e endegsi merbej, ‘Sawa bei bei qaji naŋgi ijo ŋamgalaq di tamo uge edegaim.’ Qotei na e degsi merbej. ");
INSERT INTO boj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Deqa niŋgi e qa anjam qariŋyonab e nuŋgo anjam gotraŋyosai. E nuŋgo anjam dauryosim bosim nuŋgo tal gogetonum. Deqa niŋgi merbiy, niŋgi kiyaqa e qa anjam qariŋyeb?” ");
INSERT INTO boj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","31","Onaqa Kornilius na Pita minjej, “Ya ya endi bati qolqe gilqo seŋ bati kere endego seŋ keliŋtonaqa e pailyeqnamqa tamo bei gara tulaŋ qat jigsiqa bosiq ijo ulatamuq di tigelosiqa merbej, ‘O Kornilius, Qotei a gaigai ino pailyo queqnu. Juda naŋgi iŋgi iŋgi saiinjreqnaqa ni na naŋgi aqaryainjreqnum. Ino kumbra di Qotei a unoqnsiq deqa a ni qa tulaŋ areboleboleiyeqnu. ");
INSERT INTO boj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Deqa ni que. Ni na tamo qudei naŋgi qariŋnjrimqa Jopa qureq aisib dia tamo bei aqa ñam Saimon ñam bei Pita a itqab. A itosib osib babqa a na anjam bei ni mermqas. A tamo bei wagme aqa jegara na iŋgi iŋgi gereiyo qaji aqa ñam Saimon aqa talq di unu. Aqa tal agi alile qalaq di unu.’ ");
INSERT INTO boj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Laŋ aŋgro na e degsi merbonaqa e tamo qudei naŋgi urur qariŋnjrnam Jopa qureq aisib inoq di branteb. Brantonabqa ni na naŋgi daurnjrsim agi ijo talq bonum. Deqa e ni qa tulaŋ areboleboleibqo. Endego iga kalil endia koroosimqa Qotei aqa ŋamgalaq di awejunum. Deqa anjam kalil Tamo Koba a na ni mermej qaji di mergimqa iga quqwom.” Kornilius na Pita degsi minjej. ");
INSERT INTO boj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Onaqa Pita a tigelosiqa naŋgi endegsi minjrej, “Endego e qalieonum, Qotei a tamo qudei bole qa maroqnsiq olo tamo qudei uge qa marosaieqnu. Aqa ŋamgalaq di tamo kalil kerekere unub. ");
INSERT INTO boj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Deqa sawa sawa kalilq di tamo uŋgasari kumbra bole bole yoqnsib Qotei aqa sorgomq di unub qaji naŋgi Qotei na tulaŋ areinjreqnu. ");
INSERT INTO boj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bole, nami Qotei na aqa anjam bole qariŋyonaqa Israel naŋgo segiq aiyej. Anjam bole di aqa damu endegsi unu. Tamo uŋgasari naŋgi Qotei ti ombla jeu atoqnsib sonabqa Yesus Kristus na jeu kobotej. Yesus a tamo kalil naŋgo Tamo Koba. ");
INSERT INTO boj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Niŋgi qalie, Jon a bosiqa tamo uŋgasari naŋgi yanso qa anjam minjroqnej. Bati deqa Yesus Nasaret qaji a Galili sawaq di aqa wau utru atsiqa walweloqnsiqa Judia sawa naŋgo qure kalil keretoqnsiq wauoqnej. ");
INSERT INTO boj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Qotei na aqa Mondor Bole ti aqa siŋgila ti Yesus yonaqa a walweloqnsiqa kumbra bole bole yoqnej. Yoqnsiqa tamo uŋgasari Satan na ugetnjro qaji naŋgi kalil boletnjroqnej. Qotei a Yesus ombla soqneb deqa a siŋgila ti wauoqnej. ");
INSERT INTO boj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yesus a Juda naŋgo sawa ti Jerusalem qure ti dia maŋwa gargekoba yeqnaqa iga gago ŋamdamu na unoqnem. Iga deqa bini saoqnsim laqnum. Ariya naŋgi na Yesus osib ŋamburbasq di qalsib moiyoteb. ");
INSERT INTO boj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bati qalub koboonaqa Qotei na Yesus olo subq na tigeltonaqa a tigelosiqa gago ŋamdamuq di branteqnaqa iga unoqnem. ");
INSERT INTO boj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A Juda kalil naŋgo ŋamdamuq di brantosaioqnej. Iga Qotei na aqa anjam mare mare laqajqa giltgej qaji gagoq di segi brantoqnej. Agi a subq na tigelosiqa iga koba na awooqnsimqa iŋgi ti ya ti uyoqnem. ");
INSERT INTO boj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A na mergej, ‘E segi qujai Qotei na giltbej qaji. Deqa mondoŋ e na tamo ŋambile so qaji ti tamo moreŋo qaji ti naŋgi peginjrqai. Niŋgi na tamo uŋgasari naŋgi e qa degsib minjroqniy.’ Yesus na iga degsi mergej. ");
INSERT INTO boj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","O ijo was, Qotei aqa medabu o qaji tamo kalil naŋgi nami endegsib maroqneb, ‘Qotei na tamo uŋgasari kalil Kristus qa naŋgo areqalo siŋgilatqab qaji naŋgi aqa ñam na naŋgo une kobotetnjrqas.’” ");
INSERT INTO boj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Pita a anjam degsi mareqnaqa bati qujai deqa Mondor Bole aisiqa tamo kalil Pita aqa anjam quoqneb qaji naŋgo meŋ bulyetnjrnaqa naŋgi qure utru segi segi naŋgo anjam poinjrnaqa mareleŋoqneb. Maroqnsib Qotei aqa ñam soqteqnabqa Juda Kristen Pita koba na beb qaji naŋgi di qusibqa tulaŋ prugeb. Di kiyaqa? Bati di Qotei na sawa bei bei qaji naŋgi dego aqa Mondor enjrej deqa. Onaqa Pita a endegsi marej, ");
INSERT INTO boj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iga Juda tamo unum. Iga nami Qotei aqa Mondor em. Dego kere bini sawa bei bei qaji naŋgi aqa Mondor onub. Deqa tamo bei na iga naŋgi yansnjrqajqa saidgwa keresai.” ");
INSERT INTO boj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Osiqa naŋgi minjrej, “Niŋgi Yesus Kristus aqa ñam na yanso oiy.” Degsi minjrnaqa naŋgi na yanso osib Pita minjeb, “Ni bati qudei iga koba na endi sqom.” Degsi minjnabqa a naŋgi koba na soqneb. ");
INSERT INTO boj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesus aqa anjam maro tamo naŋgi ti Yesus aqa tamo uŋgasari kalil Judia sawaq di soqneb qaji naŋgi ti anjam endegsib queb, “Sawa bei bei qaji naŋgi dego Qotei aqa anjam osib naŋgo areqaloq di siŋgilateb.” ");
INSERT INTO boj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Onaqa bati bei Pita a Jerusalem aisiq di sonaqa Juda tamo qudei Yesus dauryoqneb qaji naŋgi na Pita ŋiriŋtosib minjeb, ");
INSERT INTO boj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Sawa bei bei qaji naŋgi muluŋ unosaieqnub. Deqa ni kiyaqa naŋgo tal gogetosim naŋgi ti awoosim iŋgi uyoqnem?” ");
INSERT INTO boj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Onaqa Pita a naŋgo anjam di qusiqa utruq na anjam endegsi sainjrej, ");
INSERT INTO boj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“E Jopa qureq di pailyeqnamqa Qotei na ijo areqalo waqtetbonaqa e ŋeio bulem. E ŋeio bulosimqa iŋgi bei gara kobaquja bul plalosiq mutu qolqeq di ojeleŋosib laŋ goge na ura uratonab ijo ulatamuq ainaq unem. ");
INSERT INTO boj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Unsim geregere gara miligi peleiyosim wagme utru segi segi unjrem. Wagme juwaŋ ti amal ti bagu ti qebari ti gara miligiq di sonab unjrem. ");
INSERT INTO boj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Unjrsimqa kakro bei quem. A merbej, ‘O Pita, ni tigelosim wagme bei qalsim uye.’ ");
INSERT INTO boj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Onaqa e marem, ‘O Tamo Koba, e uyqasai! Wagme uge uge deqaji e nami uyosaioqnem. Wagme uge deqaji uyqajqa di getento koba.’ ");
INSERT INTO boj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Onaqa kakro di a olo laŋ goge na brantej. A marej, ‘Iŋgi iŋgi e jiga saiqoji qa maronum di ni olo uge qa maraim.’ ");
INSERT INTO boj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gara di degsi aiyoqalubtosiqa wagme kalil gara ti olo torei goge oqej. ");
INSERT INTO boj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Bati qujai deqa tamo qalub naŋgi bosib e soqnem qaji tal meq di tigeleb. Tamo bei na naŋgi Sisaria qureq dena qariŋnjrnaq ijoq beb. ");
INSERT INTO boj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bonab Qotei aqa Mondor na e merbej, ‘Ni tigelosim naŋgi qalub daurnjrsim gile. Ni are gulbeimaiq.’ Degsi merbonaqa e tigelosim naŋgi qalub daurnjrsim Yesus aqa tamo 6 agi endia tigelejunub qaji naŋgi koba na gilem. Gilsim Sisaria qureq di brantosim tamo di aqa tal gogetem. ");
INSERT INTO boj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Gogetonamqa tamo dena iga endegsi saigej, ‘Laŋ aŋgro bei a bosiqa ijo talq endi tigelesonaq e unem. Unnamqa merbej, “Ni na tamo qudei naŋgi qariŋnjrimqa Jopa qureq aisib dia tamo bei aqa ñam Saimon ñam bei Pita a itqab. A itosib osib babqa a na ni Qotei aqa anjam mermimqa anjam dena Qotei na ni oqas. Osim tamo uŋgasari kalil ni ombla tal qujaiq endi unub qaji naŋgi dego eleŋqas.” ’ ");
INSERT INTO boj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","O ijo was, tamo dena iga degsi saigonaqa e kamba anjam marqa yeqnamqa Mondor Bole a tamo kalil tal dia koroesoqneb qaji naŋgoq aiyej. Mondor a nami iga Juda gagoq aiyej dego kere naŋgoq aiyej. ");
INSERT INTO boj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Naŋgoq ainaqa e unsimqa Tamo Koba aqa anjam nami marej qaji deqa olo are qalem. Agi a endegsi marej, ‘Jon a ya na tamo uŋgasari naŋgi yansnjroqnej. Ariya e Mondor Bole aqa siŋgila na niŋgi yansŋgwai.’ ");
INSERT INTO boj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","O ijo was niŋgi quiy. Iga nami Tamo Koba Yesus Kristus qa gago areqalo siŋgilatonamqa Qotei na aqa Mondor Bole iga egej. Bini sawa bei bei qaji naŋgi dego Yesus qa naŋgo areqalo siŋgilateqnabqa Qotei na aqa Mondor naŋgi enjreqnu. Deqa Qotei aqa wau di e na getentqa keresai.” ");
INSERT INTO boj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Onaqa Juda tamo Pita ŋiriŋteb qaji naŋgi aqa anjam di qunabqa naŋgo ŋiriŋ koboej. Deqa naŋgi Qotei aqa ñam soqtosib mareb, “Bole, Qotei a sawa bei bei qaji naŋgi dego are bulyetnjreqnu. Deqa naŋgi dego ŋambile gaigai sqab.” ");
INSERT INTO boj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ariya Juda tamo Stiven qaleb qaji naŋgi na Kristen naŋgi ugeugeinjreqnab segi segi jaraiyosib Fonisia sawa ti Saiprus nui ti Antiok qure ti deq gileleŋeb. Gilsib dia Qotei aqa anjam mare mare laqneb. Laqnsibqa Juda naŋgi segi Qotei aqa anjam minjroqneb. Sawa bei bei qaji naŋgi Qotei aqa anjam minjrosaioqneb. ");
INSERT INTO boj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ariya Kristen qudei naŋgi Saiprus ti Sairini ti dena tigelosib Antiok qureq aisib Grik naŋgi dego Tamo Koba Yesus aqa anjam bole minjroqneb. ");
INSERT INTO boj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kristen naŋgi di Tamo Koba aqa siŋgila ti wauoqneb deqa tamo uŋgasari tulaŋ gargekoba naŋgi Yesus qa naŋgo areqalo siŋgilatoqnsib are bulyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Onaqa Yesus aqa tamo uŋgasari Jerusalem di soqneb qaji naŋgi kumbra deqa qusibqa Barnabas qariŋyonab Antiok gilej. ");
INSERT INTO boj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Antiok gilsiqa Qotei a Grik naŋgi qa dego are boleiyoqnsiqa aqaryainjroqnej di unej. Unsiqa tulaŋ areboleboleiyej. Deqa a na naŋgi kalil are siŋgilatetnjroqnsiqa minjroqnej, “Niŋgi Tamo Koba a gaigai dauryoqnsib soqniy.” ");
INSERT INTO boj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas a tamo bolequja. Mondor Bole aqaq di sonaqa a siŋgila ti wauoqnej. Aqa areqalo kalil Tamo Koba Yesus qa siŋgilatosiq soqnej. Deqa a Yesus aqa anjam mareqnaqa tamo uŋgasari gargekoba naŋgi quoqnsib Yesus aqaq boqneb. ");
INSERT INTO boj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ariya bati bei Barnabas a Sol ŋamqajqa marsiq Tarsus qureq gilej. ");
INSERT INTO boj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Gilsiq Sol ŋamosiq itosiq ombla puluosib Antiok olo aiyeb. Aisib dia wausau qujai Yesus aqa tamo uŋgasari naŋgi koba na wauoqneb. Wauoqnsibqa tamo uŋgasari tulaŋ gargekoba naŋgi Qotei aqa anjam minjroqneb. Antiok dia tamo uŋgasari Yesus dauryoqneb qaji naŋgo ñam Kristen wainjreb. ");
INSERT INTO boj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Onaqa bati bei Qotei aqa medabu o qaji tamo qudei naŋgi Jerusalem dena walwelosib Antiok beb. ");
INSERT INTO boj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bei aqa ñam Agabus. Naŋgi Antiok bonabqa Qotei aqa Mondor na Agabus medabu siŋgilatetonaqa a tigelosiqa marej, “Sawa sawa kalilq di naŋgi mam koba oqab.” Agabus a degsi marej. Mam di bunuqna Mandor Koba Klodius aqa bati qa brantej. ");
INSERT INTO boj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yesus aqa tamo uŋgasari naŋgi Agabus aqa anjam di qusibqa naŋgi naŋgo segi segi silali soqnej di koroiyeb. Koroiyosib naŋgo Kristen was Judia sawaq di soqneb qaji naŋgi aqaryainjrqa marsib silali qariŋyonab naŋgoq aiyej. ");
INSERT INTO boj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Silali di naŋgi Barnabas Sol wo enjrnabqa naŋgi na osi aisib Kristen gate Judia sawaq di soqneb qaji naŋgo baŋq di ateb. ");
INSERT INTO boj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bati deqa Mandor Herot na Yesus aqa tamo uŋgasari qudei naŋgi ojeleŋosiqa ugeugeinjroqnej. ");
INSERT INTO boj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Osiqa a na qaja tamo bei qariŋyonaqa gilsiq Jon aqa was Jems serie na qalnaq moiyej. ");
INSERT INTO boj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A degyonaqa Juda tamo kokba naŋgi areboleboleinjrej di qalieosiq deqa Pita dego ojej. Bati di Bem Tiyosai Qaji Uyqajqa Yori Bati Koba. ");
INSERT INTO boj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herot a Pita ojsiqa tonto talq di waiyosiqa qaja tamo 16 naŋgi minjrnaqa naŋgi Pita taqatesoqneb. Herot a endegsi are qalej, “Yori bati koba ñam Pasova di koboamqa e Pita osiy Juda naŋgo ulatamuq di tigeltqai.” ");
INSERT INTO boj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita a tonto talq di sonaqa Yesus aqa tamo uŋgasari naŋgi siŋgila na Pita qa pailyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot a marej, “Nebeamqa e na Pita osiy Juda naŋgo ulatamuq di tigeltqai.” Qolo deqa qaja tamo aiyel na Pita osib tonto tal miligiq di warum beiq waiyosib ambletosib sil kokba aiyel na tontonab ŋeiesoqnej. Qaja tamo qudei naŋgi tonto tal siraŋme jojomq di tigelesosib taqatoqneb. ");
INSERT INTO boj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Onaqa qolo qujai deqa Tamo Koba aqa laŋ aŋgro bei a warum miligiq di brantoqujatej. Aqa riaŋ na warum di tulaŋ suwantej. Onaqa laŋ aŋgro dena Pita jar baŋgaq di kontosiqa dudumyej. Dudumyosiq minjej, “Ni tigeloqujat.” Degsi minjnaqa sil kokba aiyel Pita aqa baŋ qoseb qaji di pambloŋosib uloŋeb. ");
INSERT INTO boj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Onaqa laŋ aŋgro na olo Pita minjej, “Ino gara tigsim ino siŋga tatal jige.” Onaqa Pita a degyonaqa olo minjej, “Ino gara jugo dego jigsim e daurbe.” ");
INSERT INTO boj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Degsi minjnaqa Pita a warum di uratosiq laŋ aŋgro dauryosiq gilej. Laŋ aŋgro a bole Pita oqeq atej di Pita a poiyosai. A are qalej, “E ŋeiobilqeionum kiyo?” ");
INSERT INTO boj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Naŋgi walwelosib qaja tamo bei tonto tal taqatesoqnej qaji di buŋyosib gilsib olo qaja tamo bei buŋyosib siraŋme kobaquja ain na gereiyo qaji di brantonab siraŋ a segi waqonaqa naŋgi aiyel oqedeb. Siraŋme di tonto talq dena oqedosim qureq aiqajqa siraŋme. Naŋgi siraŋme dena oqedosib gam dauryosib giloqnsib laŋ aŋgro na Pita uratosiq ulaŋej. ");
INSERT INTO boj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Onaqa Pita a poiyonaqa marej, “Bole. Endego e qalieonum, Juda naŋgi e lubqa laqnabqa Tamo Koba a na aqa laŋ aŋgro qariŋyqoqa bosiq e aqaryaibosiqa Herot aqa baŋq dena e oqo.” ");
INSERT INTO boj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita a degsi poiyonaqa walwelosi gilsiq Jon aqa ñam bei Mak aqa ai Maria aqa talq di brantej. Tal miligiq di Kristen gargekoba naŋgi koroesosib Pita qa pailyoqneb. ");
INSERT INTO boj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","14","Onaqa Pita a tal meq di brantosiqa siraŋmeq di tigelosiq kindokindoŋosiq maeqnaqa kaŋgal uŋa bei aqa ñam Roda a bosiqa siraŋ waqtqa osiqa Pita aqa kakro qusiq tulaŋ areboleboleiyej. Onaqa a siraŋ waqtqa uratosiqa olo urur ti warum miligiq gilsiqa naŋgi minjrej, “Pita bqo agi tal meq di tigelejunu!” ");
INSERT INTO boj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Onaqa naŋgi na minjeb, “Ni nanarionum. Di Pita sai.” Degsi minjnabqa a tulaŋ siŋgilaosiqa minjrej, “E nanariosai. E bole maronum. Pita a bqo aqa kakro quonum.” Onaqa naŋgi 