﻿USE sofia;
DROP TABLE IF EXISTS sofia.bodn_vpl;
CREATE TABLE bodn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bodn_vpl WRITE;
INSERT INTO bodn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ཐོག་མར་དཀོན་མཆོག་གིས་ནམ་མཁའ་དང་ས་གཞི་གསར་དུ་བཀོད་པ་ལགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ས་གཞི་ནི་སྟོངས་ཤིང་གོ་རིམ་མེད་པ་དང་མཚོ་ཆེན་པོའི་ངོས་སུ་མུན་ནག་གིས་ཁེབས༌ཤིང༌། དཀོན་མཆོག་གི་ཐུགས་ཉིད་མཚོའི་ངོས་སུ་ཕར་ཚུར༌རྒྱུའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","དེ་ནས་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། འོད་ཡོད་པར་གྱུར་ཅིག་ཅེས་གསུངས་པ་དང་འོད་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ཁོང་གིས་འོད་ནི་ལེགས་པར་དགོངས་ཏེ་འོད་དང་མུན་པའི་དབྱེ་བ༌ཕྱེས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ཁོང་གིས་འོད་ལ་ཉིན་མོ་ཞེས་བཏགས་པ༌དང༌། མུན་པར་མཚན་མོ་ཞེས་མིང་བཏགས༌སོ། །དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་དང༌པོའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ཆུའི་བར་དུ་དབྱིངས་དང་ལྡན་པར་གྱུར་ནས་ཆུ་དང་ཆུའི་བར་མཚམས་ཕྱེས་ཤིག་ཅེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ཁོང་གིས་དབྱིངས་མཛད༌དེ། དབྱིངས་ཀྱི་གོང་དུ་ཡོད་པའི་ཆུ་དང་དབྱིངས་ཀྱི་འོག་ཏུ་ཡོད་པའི་ཆུ་གཉིས་སོ་སོར་ཕྱེས་ནས་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","དཀོན་མཆོག་གིས་དབྱིངས་ཀྱི་མིང་ལ་ནམ་མཁའ་ཞེས་བཏགས༌སོ། །དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་གཉིས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ནམ་མཁའི་འོག་ཏུ་ཡོད་པའི་ཆུ་རྣམས་གནས་གཅིག་ཏུ་འདུས་ཏེ་སྐམ་ས་མངོན་པར་གྱུར་ཅིག་ཅེས་གསུངས་པ་དང་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","དཀོན་མཆོག་གིས་སྐམ་སའི་མིང་ལ་ས་གཞི་ཞེས་བཏགས་པ༌དང༌། ཆུ་རྣམས་ལྷན་དུ་འདུས་པ་ལ་རྒྱ་མཚོ་ཞེས་མིང་བཏགས༌ཤིང༌། ཁོང་གིས་དེ་ནི་ལེགས་པར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ས་ལས་སྔོ་རིགས༌ཏེ། ས་བོན་བསྐྱེད་པའི་སྔོ་ཚལ༌དང༌། ས་བོན་ལྡན་པའི་ཤིང་འབྲས་བསྐྱེད་པའི་ལྗོན་ཤིང་ཐམས་ཅད་རང་རང་གི་རིགས་བཞིན་དུ་སྐྱེ་བར་གྱུར་ཅིག་ཅེས་གསུངས་པ་དང་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","དེ་ནས་ས་ལས་སྔོ་རིགས༌ཏེ། རང་རང་གི་རིགས་བཞིན་དུ་ས་བོན་བསྐྱེད་པའི་སྔོ་ཚལ༌དང༌། ས་བོན་ལྡན་པའི་ཤིང་འབྲས་བསྐྱེད་པའི་ལྗོན་ཤིང་ཐམས་ཅད་རང་རང་གི་རིགས་བཞིན་དུ་སྐྱེས་པར་གྱུར༌ཏོ། །ཁོང་གིས་དེ་ནི་ལེགས་པར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་གསུམ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ཉིན་མོ་དང་མཚན་མོ་འབྱེད་པའི་ཕྱིར་ནམ་མཁའི་དབྱིངས་སུ་འོད་ཀྱི་ཕུང་པོ་རྣམས་ཡོད་པར་གྱུར༌ཅིག དེ་ནི་དུས་ཚིགས༌དང༌། ཉིན༌མོ། ལོ་ཟླའི་རྟགས་སུ་འགྱུར་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ནམ་མཁའི་དབྱིངས་སུ་འོད་འཕྲོ་བ་དང་ས་ལ་འོད་སྣང་བའི་ཕྱིར་རོ་ཞེས་གསུངས་པ་དང་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","དེ་ནས་ཁོང་གིས་འོད་ཆེན་པོ་གཉིས་མཛད༌ཅིང༌། དེ་ནི་འོད་ཆེན་པོས་ཉིན་མོ་ལ་དབང་བྱེད་པ༌དང༌། འོད་ཆུང་བས་མཚན་མོ་ལ་དབང་བྱེད་པའི་ཕྱིར་ཡིན༌ཞིང༌། ཡང་སྐར་མ་རྣམས་ཀྱང་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ཁོང་གིས་འོད་དེ་གཉིས་ནམ་མཁའི་དབྱིངས་སུ་བཤམས་པར་མཛད༌དོ། །ཅིའི་ཕྱིར་ཞེ༌ན། དེ་གཉིས་ས་གཞི་ལ་སྣང་བར་བྱེད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ཉིན་དང་མཚན་ལའང་དབང་བྱེད་པར་འགྱུར་བ༌དང༌། འོད་དང་མུན་པ་འབྱེད་པའི་ཕྱིར༌རོ། །ཁོང་གིས་དེ་ནི་ལེགས་པར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་བཞི༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ཆུའི་ནང་དུ་སྲོག་དང་ལྡན་པའི་སེམས་ཅན་ཧ་ཅང་མང་དུ་འབྱུང་བ༌དང༌། འདབ་ཆགས་རྣམས་ས་སྟེང་གི་བར་སྣང་དུ་ཕུར་ཅིག་ཅེས་གསུངས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ཁོང་གིས་ཆུ་ལ་གནས་པའི་སྲོག་ལྡན་ཆེན་པོ༌དང༌། ཆུའི་ནང་དུ་བྱུང་བའི་སྲོག༌ལྡན། འདབ་ཆགས་རྣམས་ཀྱང་རང་རང་གི་རིགས་བཞིན་དུ་བཀོད་པར་མཛད་ཅིང་ཁོང་གིས་དེ་ནི་ལེགས་པར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ཡང་དཀོན་མཆོག་གིས་དེ་དག་ལ་བྱིན་གྱིས་བརླབས་ཏེ་འདི་སྐད༌དུ། རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་དུ་སྤེལ་ཏེ་རྒྱ་མཚོའི་ཆུ་ལ་གང་བར་གྱིས༌དང༌། འདབ་ཆགས་རྣམས་ཀྱང་ས་ལ་འཕེལ་བར་གྱུར་ཅིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་ལྔ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ས་གཞིའི་སྟེང་དུ་རང་རང་གི་རིགས་བཞིན་དུ་སྲོག་ལྡན་ཏེ་ཕྱུགས་ཟོག༌དང༌། ལྟོ་འགྲོ་དང་འབུ༌སྲིན། རི་དྭགས་རྣམས་སྐྱེ་བར་གྱུར་ཅིག་ཅེས་གསུངས་པ་དང་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","དཀོན་མཆོག་གིས་རི་དྭགས༌དང༌། ཕྱུགས༌ཟོག ས་སྟེང་གི་ལྟོ་འགྲོ་དང་འབུ་སྲིན་ཐམས་ཅད་རང་རང་གི་རིགས་བཞིན་དུ་བཀོད་པར་མཛད༌ཅིང༌། དཀོན་མཆོག་གིས་དེ་ནི་ལེགས་པར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ངེད་ཅག་ གིས་རང་གི་སྣང་བརྙན༌ལྟར། ངེད་ཅག་དང་མཚུངས་པའི་མིའི་རིགས་བསྐྲུན་པར༌བྱའོ། །དེ་དག་གིས་རྒྱ་མཚོའི་ཉ་རྣམས༌དང༌། ནམ་མཁའི༌བྱ། ཕྱུགས༌ཟོག ས་གཞི༌ཡོངས། ས་སྟེང་གི་ལྟོ་འགྲོ་དང་འབུ་སྲིན་ཐམས་ཅད་ལ་དབང་བྱེད་པར་གྱུར་ཅིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","དཀོན་མཆོག་གིས་རང་གི་སྣང་བརྙན་ལྟར་མིའི་རིགས་བསྐྲུན་པར་མཛད༌ཅིང༌། དེ་ནི་དཀོན་མཆོག་ཉིད་ཀྱི་སྣང་བརྙན་བཞིན་ཕོ་མོ་གཉིས་སུ་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","དཀོན་མཆོག་གིས་དེ་གཉིས་ལ་བྱིན་གྱིས་བརླབས་ཏེ་འདི་སྐད༌དུ། ཁྱོད་རྣམས་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་དུ་སྤེལ་ཏེ་ས་གཞིར་གང་བར་བྱོས༌ཤིག ཡང་ས་གཞིར་དབང་བསྒྱུར་བ་དང་རྒྱ་མཚོའི་ཉ༌དང༌། ནམ་མཁའི༌བྱ། ས་ཐོག་ཏུ་རྒྱུ་བའི་སྲོག་ཆགས་ཀུན་ལའང་དབང་བྱེད་པར་གྱིས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ལྟོས༌དང༌། བདག་གིས་ས་སྟེང་དུ་ས་བོན་བསྐྱེད་པའི་སྔོ་ཚལ་དང་ས་བོན་ལྡན་པའི་ཤིང་འབྲས་བསྐྱེད་པའི་ལྗོན་ཤིང་ཐམས་ཅད་ཁྱོད་ཅག་ལ་ཟས་སུ་སྦྱིན་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ཡང་ས་སྟེང་གི་དུད་འགྲོ་ཐམས་ཅད༌དང༌། ནམ་མཁའི་བྱ་མཐའ་དག༌དང༌། ས་ཐོག་ཏུ་རྒྱུ་བའི་སྲོག་ལྡན་ཡོངས་ལ་སྔོ་རིགས་ཟས་སུ་སྦྱིན་ནོ་ཞེས་གསུངས་པ་དང་དེ་བཞིན་དུ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","དེ་ནས་དཀོན་མཆོག་གིས་རང་ཉིད་ཀྱིས་ཇི་བཞིན་མཛད་པ་ཐམས་ཅད་ལ་གཟིགས་ཤིང་དེ་ནི་ཤིན་ཏུ་ལེགས་པར་དགོངས༌སོ། །དེ་ནི་མཚན་མོ་དང་ཞོགས་པ་བྱུང་བའི་ཉིན་མཚན་དྲུག༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","དེ་ལྟར་ནམ་མཁའ་དང་ས་གཞི་དང་དངོས་པོ་ཐམས་ཅད་ལེགས་པར་བཀོད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ཉིན་བདུན་པའི་སྔོན་དུ་དཀོན་མཆོག་གིས་མཛད་པའི་འཕྲིན་ལས་ཐམས་ཅད་ལེགས་པར་གྲུབ་པ་དང་ཉིན་བདུན་པ་ལ་ངལ་གསོ་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","དཀོན་མཆོག་གིས་ཉིན་བདུན་པ་ལ་བྱིན་གྱིས་བརླབས་ཤིང་ཉིན་དེ་ནི་དམ་པར་མཛད་པ༌སྟེ། རྒྱུ་མཚན་ནི་ཉིན་དེར་ཁོང་གིས་བཀོད་པའི་འཕྲིན་ལས་ཐམས་ཅད་འགྲུབ་པར་མཛད་ནས་ངལ་གསོ་གནང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","དེ་ཡང་ནམ་མཁའ་དང་ས་གཞི་བཀོད་པའི་ལོ་རྒྱུས་ནི་འདི་ལྟ༌སྟེ། དཀོན་མཆོག་ཡ་ཝཱེས་ ནམ་མཁའ་དང་ས་གཞི་བཀོད་པའི་དུས༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ས་རྒོད་སྟེང་དུ་སྡོང་ཕྲན་མེད་ལ་ཞིང་ཁར་སྔོ་ཚལ་ཡང་སྐྱེ་མེད༌དེ། དཀོན་མཆོག་ཡ་ཝཱེས་ད་དུང་ས་ལ་ཆར་བ་འབབ་པར་མ་མཛད༌ཅིང༌། ཞིང་འདེབས་མཁན་ཡང་མེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","འོན་ཀྱང་ས་ནས་རླངས་པ་འཕྱུར་ཏེ་ས་གཞི་ཡོངས་སུ་བརླན་པར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","དཀོན་མཆོག་ཡ་ཝཱེས་ས་རྡུལ་གྱིས་སྐྱེས་པ་ཞིག་བཟོས་པ༌དང༌། དེའི་སྣ་ཁུང་ལ་ཚེ་སྲོག་གི་ཞལ་ཕུ་བརྒྱབ་ནས་སྲོག་དང་ལྡན་པའི་མི་ཞིག་ཏུ་འགྱུར་བར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཤར་ཕྱོགས་ཀྱི་ཨེ་དེན་ཡུལ་དུ་ལྡུམ་ར་ཞིག་བསྐྲུན་ཅིང་ཁོང་གིས་བཟོས་པའི་སྐྱེས་པ་དེའང་ཡུལ་དེར་བསྐྱལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","དཀོན་མཆོག་ཡ་ཝཱེས་ས་ནས་ལྗོན་ཤིང་སྣ་ཚོགས་སྐྱེ་རུ་བཅུག་ཅིང་དེ་དག་ནི་ལྟ་ན་སྡུག་པ་དང་དེ་དག་གི་ཤིང་ཏོག་ཟོས་ན་ཞིམ་མངར་ལྡན་པར་མཛད༌ཅིང༌། ལྡུམ་རའི་དཀྱིལ་དུ་ཚེ་སྲོག་གི་ལྗོན་ཤིང་དང་བཟང་ངན་རྟོགས་པའི་ལྗོན་ཤིང་ཡང་ཡོད་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","དེ་ཡང་ཨེ་དེན་ཡུལ་ནས་ཆུ་བོ་ཞིག་བཞུར་འོངས་ཏེ་ལྡུམ་ར་བརླན་པར་བྱས་པ༌དང༌། གནས་དེར་ཆུ་བོ་བཞི་རུ་གྱེས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ཆུ་བོ་དང་པོའི་མིང་ལ་ཕི་ཤོན་ཟེར་བ༌དང༌། དེ་ནི་ཧ་བེ་ལཱའི་ཡུལ་ཐམས་ཅད་བརྒྱུད་ནས་བཞུར་བ་དང་ཡུལ་དེ་རུ་གསེར་ཡང་ཡོད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ཡུལ་དེའི་གསེར་ནི་ཤིན་ཏུ་ལེགས༌སོ། །ཡུལ་དེ་རུ་པེ་དེལ་ཡོན་ཞེས་པའི་ཐང་ཆུ་དང་རིན་པོ་ཆེ་གཟིའང་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ཆུ་བོ་གཉིས་པའི་མིང་ལ་གེ་ཧོན་ཟེར་བ་དང་དེ་ནི་གུ་ཤའི་ཡུལ་ཐམས་ཅད་བརྒྱུད་ནས་བཞུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ཆུ་བོ་གསུམ་པའི་མིང་ལ་ཧི་དཱི་ཀེལ་ཟེར་ཞིང་ཨ་སུར་ཡུལ་གྱི་ཤར་ཕྱོགས་སུ་བཞུར༌རོ། །ཆུ་བོ་བཞི་པའི་མིང་ལ་ཕི་རཱད་ཅེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་སྐྱེས་པ་དེ་ཨེ་དེན་ལྡུམ་རར་བསྐྱལ་ནས་བདག་གཉེར་བྱེད་མཁན་དུ་བསྐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ཁོང་གིས་སྐྱེས་པ་དེ་ལ་འདི་སྐད༌དུ། ལྡུམ་ར་ནང་གི་ལྗོན་ཤིང་སྣ་ཚོགས་ཀྱི་ཤིང་ཏོག་ཟས་སུ་སྤྱོད་རུང༌མོད། ");
INSERT INTO bodn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","འོན་ཀྱང་བཟང་ངན་རྟོགས་པའི་ལྗོན་ཤིང་དེའི་ཤིང་ཏོག་བཟའ་མི༌རུང༌། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ཀྱིས་དུས་ནམ་ཞིག་ལ་ཟོས་པར་གྱུར་ན་འཆི་བར་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་བཀའ་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། སྐྱེས་པ་དེ་གཅིག་པུ་བསྡད་ན་མི་ལེགས༌ཏེ། བདག་གིས་ཁོ་ལ་འཚམ་པའི་ལས་གྲོགས་ཤིག་བཟོ་བར་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ས་སྟེང་གི་དུད་འགྲོ་དང་ནམ་མཁའི་བྱ་ཐམས་ཅད་ས་ལས་བཟོས་པ་དང་སྐྱེས་པ་དེའི་མདུན་དུ་ཁྲིད་ཡོང༌སྟེ། ཁོས་དེ་དག་ལ་མིང་ཅི་གདགས་པར་གཟིགས༌སོ། །སྐྱེས་པ་དེས་སེམས་ཅན་རྣམས་ལ་མིང་གང་ཞིག་བཏགས་པ་བཞིན་སེམས་ཅན་མཐའ་དག་ལ་མིང་ཡོད་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","སྐྱེས་པ་དེས་ཕྱུགས་ཟོག་ཐམས་ཅད༌དང༌། ནམ་མཁའི་བྱ༌དང༌། ས་སྟེང་གི་དུད་འགྲོ་རེ་རེ་བཞིན་དུ་མིང་བཏགས༌ཀྱང༌། ཨ་དམ་ གྱིས་རང་ལ་འོས་པའི་ལས་གྲོགས་ཤིག་རྩ་བ་ནས་མ་མཐོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་དམ་གཉིད་ལྕི་མོ་ཁུགས་སུ་བཅུག་པ༌དང༌། ཁོང་གིས་ཨ་དམ་གྱི་རྩིབ་རུས་གཅིག་བླངས་ཤིང་རྨ་ཤུལ་ཤ་ཡིས་སྦྱར་བར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","དེར་དཀོན་མཆོག་ཡ་ཝཱེས་སྐྱེས་པ་དེའི་རྩིབ་མ་ལས་བུད་མེད་ཅིག་མཛད་དེ་ཁོའི་གམ་དུ་ཁྲིད་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ཁོས་འདི་ལྟར་སྨྲས༌པ། འདི་ནི་རུས་པ་ལས་བྱུང་རུས་པ༌དང༌།། བདག་གི་ཤ་ལས་བྱུང་བའི་ཤ་ཡིན༌ནོ།། ཁོ་མོའི་མིང་ལ་སྐྱེས་མ་འདོགས་པར༌བྱ།། དེ་ནི་སྐྱེས་པའི་ལུས་ནས་བྱུང་ཕྱིར༌རོ། །ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","དེ་བས་སྐྱེས་པ་ནི་རང་གི་ཕ་མ་དང་ཁ་བྲལ་ནས་རང་གི་ཆུང་མར་འབྲེལ་ཏེ་ཁོ་གཉིས་ལུས་པོ་གཅིག་ཏུ་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","དུས་དེར་ཁྱོ་ཤུག་གཉིས་ལུས་པོ་གཅེར་བུ་ཡིན་ཡང་ངོ་གནོང་བ་མེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མཛད་པའི་སྦྲུལ་ནི་ས་སྟེང་གི་སེམས་ཅན་ཐམས་ཅད་ལས་ཆེས་གཡོ་སྒྱུ་ཆེ་བ་ཞིག་ཡིན༌པས། སྦྲུལ་གྱིས་བུད་མེད་དེ་ལ་འདི་ལྟར་དྲིས༌པ། དཀོན་མཆོག་གིས་ལྡུམ་ར་ནང་གི་ལྗོན་ཤིང་ཐམས་ཅད་ཀྱི་ཤིང་ཏོག་བཟའ་མི་རུང་ཞེས་དངོས་གནས་བཀའ་གནང་ངམ་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","བུད་མེད་ན༌རེ། ངེད་གཉིས་ཀྱིས་ལྡུམ་ར་ནང་གི་ལྗོན་ཤིང་གི་ཤིང་ཏོག་བཟའ་རུང༌མོད། ");
INSERT INTO bodn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","འོན་ཀྱང་ལྡུམ་རའི་དཀྱིལ་དུ་ཡོད་པའི་ལྗོན་ཤིང་དེའི་ཤིང་ཏོག་བཟའ་མི་རུང༌སྟེ། དཀོན་མཆོག་གིས་དེ་ནི་བཟའ་མི་རུང་ལ་རེག་ཀྱང་མི༌རུང༌། གལ་ཏེ་ཟོས་ན་འཆི་བར་འགྱུར་ཞེས་བཀའ་གནང་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ཡང་སྦྲུལ་ན༌རེ། ཁྱོད་ནི་ཅིས་ཀྱང་འཆི་མི་སྲིད༌དེ། ");
INSERT INTO bodn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ཁྱོད་ཀྱིས་དེ་ཉིད་ཟོས་པ་ཙམ་གྱིས་མིག་ཟུང་གསལ་པོར་གྱུར༌ཏེ། དཀོན་མཆོག་དང་འདྲ་བར་གྱུར་ནས་བཟང་ངན་ཤེས་པར་འགྱུར་བ་དཀོན་མཆོག་གིས་མཁྱེན་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","དེ་ནས་བུད་མེད་ཀྱིས་ལྗོན་ཤིང་དེའི་ཤིང་ཏོག་ནི་ཁ་ལ་ཞིམ་ཞིང་ལྟ་ན་སྡུག་པ༌དང༌། མཁས་པར་འགྱུར་ཆེད་ཡིད་དུ་འོང་བ་མཐོང་ནས། ཤིང་ཏོག་བཏོགས་ནས་ཟོས་ཤིང་རང་གི་ཁྱོ་ག་ལའང་སྤྲད་པ་དང་དེས་ཀྱང་ཟོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","དེར་ཁོ་གཉིས་ཀྱི་མིག་ཟུང་གསལ་པོར་གྱུར་ཏེ་རང་ལུས་གཅེར་བུ་ཡིན་པ་མཐོང༌བས། སེ་ཡབ་ཤིང་གི་ལོ་མ་བསླས་ནས་རང་ཉིད་ལ་སྨད་གོས་བཟོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","དེ་ནས་བསིལ་རླུང་ལྡང་བའི་དུས༌སུ། དཀོན་མཆོག་ཡ་ཝཱེ་ལྡུམ་རའི་ནང་དུ་ཕེབས་པ༌དང༌། སྐྱེས་པ་དེ་དང་ཁོའི་ཆུང་མ་གཉིས་ཀྱིས་ཁོང་ཉིད་ཕེབས་པའི་སྒྲ་ཐོས་ནས་སྡོང་གསེབ་ཏུ་ཁོང་ལ་གཡོལ་བ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","དཀོན་མཆོག་ཡ་ཝཱེས་སྐྱེས་པ་དེ་ལ་ཁྱོད་གང་དུ་ཡོད་ཅེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ཁོ་ན༌རེ། ངས་ལྡུམ་རའི་ནང་ཁྱེད་ཀྱི་སྒྲ་ཐོས་པས་འཇིགས༌ཤིང༌། བདག་གི་ལུས་པོ་གཅེར་བུ་ཡིན་པས་སྦས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ཡང་ཁོང་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་ལུས་གཅེར་བུ་ཡིན་པ་སུ་ཞིག་གིས་སྨྲས༌སམ། བདག་གིས་བཟའ་མི་རུང་བར་བཀའ་བསྒོས་པའི་ཤིང་ཏོག་དེ་ཟོས་སམ་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ཁོ་ན༌རེ། ཁྱེད་ཀྱིས་བདག་ལ་གནང་ཞིང་བདག་དང་འགྲོགས་པའི་བུད་མེད་དེས་ལྗོན་ཤིང་དེའི་ཤིང་ཏོག་བདག་ལ་སྤྲད་པས་ངས་ཀྱང་ཟོས་པ་ཡིན་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་བུད་མེད་དེ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ཅི་ཞིག་བྱས་སམ་ཞེས་དྲིས་པ༌ལ། ཁོ་མོ་ན༌རེ། སྦྲུལ་གྱིས་བདག་ལ་བསླུ་བྲིད་བྱས་པས་བདག་གིས་ཟོས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་སྦྲུལ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ལས་དེ་བྱས་པའི་དབང་གིས་ཕྱུགས་ཟོག་དང་ས་སྟེང་གི་དུད་འགྲོ་ཐམས་ཅད་ལས་ཁྱོད་ལ་ལྷག་ཏུ་དམོད་པ་འཕོག་པ༌དང༌། ལྟོ་བས་འགྲོ་ཞིང་ནམ་ཡང་ས་རྡུལ་བཟའ་བར་གྱུར༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","བདག་གིས་ཁྱོད་དང་བུད་མེད་གཉིས༌དང༌། ཁྱོད་དང་བུད་མེད་གཉིས་ཀྱི་བུ་རྒྱུད་བར་ཕན་ཚུན་དགྲ་ཟླར་ལངས་པ༌དང༌། བུད་མེད་ཀྱི་བུ་རྒྱུད་དེས་ ཁྱོད་ཀྱི་མགོ་བོ་རྨ་བར་བྱེད་པ༌དང༌། ཁྱོད་ཀྱིས་ཁོང་གི་རྐང་པའི་ཕྱི་རྟིང་རྨ་བར་བྱེད་ཅེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ཡང་ཁོང་གིས་བུད་མེད་ལ་འདི་སྐད༌དུ། བདག་གིས་ཁྱོད་ལ་མངལ་སྦྲུམ་པའི་སྡུག་བསྔལ་ཆེ་རུ་བསྐྱེད༌དེ། ཕྲུ་གུ་བཙའ་དུས་ཟུག་གཟེར་ཆེན་པོ་འབྱུང་བར་འགྱུར་ངེས༌སོ། །ཁྱོད་ནི་ཁྱོ་གར་ཞེན་ཅིང་ཆགས་པ༌དང༌། ཁྱོ་གས་ཁྱོད་ལ་དབང་བྱེད་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ཡང་ཁོང་གིས་ཨ་དམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་བུད་མེད་ཀྱི་ངག་ལ་མཉན་པ༌དང༌། བདག་གིས་བཟའ་མི་རུང་ཞེས་སྨྲས་པའི་ལྗོན་ཤིང་དེའི་ཤིང་ཏོག་ཟོས་པའི༌ཕྱིར། ཁྱོད་ཀྱི་རྐྱེན་གྱིས་ས་སྟེང་དུ་དམོད་པ་འབྱུང༌ངོ༌། །ཁྱོད་ཀྱིས་ཇི་སྲིད་འཚོ་བའི་བར་དུ་ངལ་རྩོལ་བྱས་ན་ད་གཟོད་ས་ལས་ཁྱོད་ལ་ཁ་ཟས་འཐོབ་པར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ཁྱོད་ཀྱི་རྐྱེན་གྱིས་ས་གཞི་ལས་ཚེར་མ་དང་སྤྱང་ཚེར་སྐྱེ་བ༌དང༌། ཁྱོད་ཀྱིས་ས་ཞིང་གི་སྔོ་ཚལ་ཡང་བཟའ་བར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ཁྱོད་ཀྱིས་རང་ཉིད་ས་ལ་འཐིམ་པའི་བར་དུ་རྔུལ་ཆུ་མང་པོ་བཏོན་ན་ད་གཟོད་ལྟོ་བ་འགྲང་བར་འགྱུར༌ཏེ། ཁྱོད་ནི་ས་རྡུལ་ལས་བྱུང་བ༌དང༌། ཁྱོད་ས་རྡུལ་ཡིན་པས་སླར་ཡང་ས་རྡུལ་དུ་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","དེ་ནས་ཨ་དམ་གྱིས་རང་གི་ཆུང་མའི་མིང་ལ་ཧ་ཝཱ་ཞེས་བཏགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་མོ་ནི་མིའི་རིགས་ཀྱི་མ་ཡུམ་ཡིན་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་དམ་དང་ཁོའི་ཆུང་མ་གཉིས་ལ་ཀོ་བའི་གྱོན་པ་བཟོས་ནས་ལུས་ལ་བསྐོན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། ལྟོས༌དང༌། མི་དེ་ནི་ངེད་ཅག་དང་འདྲ་བར་གྱུར༌ཏེ་བཟང་ངན་ཤེས༌སོ། །ད་ལྟ་སླར་ཡང་ལག་པ་བརྐྱངས་ནས་ཚེ་སྲོག་གི་ལྗོན་ཤིང་གི་ཤིང་ཏོག་ཟོས༌ན། ནམ་ཡང་གསོན་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","དེའི༌ཕྱིར། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་ཨེ་དེན་ལྡུམ་ར་ནས་བཏོན༌ཏེ། སྔར་ཁོ་རང་མཛད་པའི་ས་དེ་རྨོ་བར་བཏང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ཕྱིར་བསྐྲད་པའི་རྗེས༌སུ། ཨེ་དེན་ལྡུམ་རའི་ཤར་ཕྱོགས་སུ་ཀེ་རུབ་ མངགས་པ༌དང༌། ཕྱོགས་བཞིར་འཁོར་བའི་མེ་ཡི་རལ་གྲི་ཞིག་བཙུགས་པར་མཛད༌དེ། ཚེ་སྲོག་གི་ལྗོན་ཤིང་ཡོད་སར་འགྲོ་བའི་ལམ་དེ་བསྲུང་དགོས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","དེ་ཡང་ཨ་དམ་རང་གི་ཆུང་མ་ཧ་ཝཱ་དང་ལུས་འབྲེལ་བྱས་ཤིང་ཁོ་མོ་མངལ་དང་ལྡན་པར་གྱུར༌ཏེ། བུ་ཀཱ་ཡན་ཞེས་པ་སྐྱེས་པས་ཁོ་མོ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེ་ ལ་བརྟེན་ནས་བདག་ལ་བུ་ཞིག་ཐོབ་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ཡང་ཁོ་མོར་ཀཱ་ཡན་གྱི་ནུ་བོ་ཧ་བེལ་ཞེས་པ་སྐྱེས༌སོ། །ཧ་བེལ་ལུག་རྫི་ཡིན་ཞིང་ཀཱ་ཡན་ཞིང་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","དེ་ནས་དུས་ཤིག་ལ་ཀཱ་ཡན་གྱིས་ས་ཞིང་ལས་སྐྱེས་པའི་འབྲས་བུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པར་ཕུལ་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ཧ་བེལ་གྱིས་ཀྱང་ལུག་ཁྱུ་ལས་བཙས་པའི་ལུ་གུ་ཐོག་མ་དང་ལུག་ཚིལ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པར་ཕུལ༌ཞིང༌། ཁོང་ཉིད་ཧ་བེལ་དང་ཁོའི་མཆོད་པ་ལ་ཐུགས་དགྱེས་ཀྱང་། ");
INSERT INTO bodn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ཀཱ་ཡན་དང་ཁོའི་མཆོད་པ་ལ་ཐུགས་མ་དགྱེས་པས། ཀཱ་ཡན་ཤིན་ཏུ་ཁྲོས་ཤིང་ངོ་མདངས་ཀྱང་འགྱུར་བར་གྱུར་ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཀཱ་ཡན་ལ་འདི་སྐད༌དུ། ཁྱོད་ཁྲོས་ནས་ངོ་མདངས་འགྱུར་བ་ཅི་ཡིན༌ནམ། ");
INSERT INTO bodn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ཁྱོད་རང་སྤྱོད་ལམ་བཟང་ན་ཁྱོད་ཀྱི་མགོ་ཡར་འདེགས་ཐུབ་པ་མ་ཡིན༌ནམ། གལ་ཏེ་སྤྱོད་ལམ་ངན་ན་སྡིག་པས་སྒོ་མདུན་ནས་ཁྱོད་ལ་འཇབ་འདུག༌གོ །དེས་ཁྱོད་འདོད་ཀྱང་ཁྱོད་ཀྱིས་དེ་ལ་དབང་བསྒྱུར་དགོས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","དེ་ནས་ཀཱ་ཡན་གྱིས་ཧ་བེལ་ལ་གཏམ་གླེང་བ༌དང༌། ཁོ་གཉིས་ཞིང་བར་དུ་ཡོད་པའི་ཚེ༌ན། ཀཱ་ཡན་ལངས་ནས་རང་གི་སྤུན་ཧ་བེལ་ལ་བརྒྱབ་སྟེ་བསད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","དེར་དཀོན་མཆོག་ཡ་ཝཱེས་ཀཱ་ཡན་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་སྤུན་ཧ་བེལ་གང་དུ་ཡོད་ཅེས་དྲིས་པ༌ལ། ཀཱ་ཡན་ན༌རེ། ངས་མི༌ཤེས། ང་ནི་སྤུན་སྲུང་མཁན་ཡིན་ནམ་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ཡང་ཁོང་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ཅི་བྱས༌སམ། ཁྱོད་ཀྱི་སྤུན་ཧ་བེལ་གྱི་ཁྲག་གིས་ས་འོག་ནས་བདག་ལ་ངུ་སྐད་འདོན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ས་ཡིས་ཁ་གདངས་ཏེ་ཁྱོད་ཀྱི་ལག་ནས་ཁྱོད་རང་གི་སྤུན་ཆུང་ཧ་བེལ་གྱི་ཁྲག་བླངས༌པས། ད་ལྟ་ཁྱོད་ལ་ས་འདི་ལས་དམོད་པ་ཐེབས༌དགོས། ");
INSERT INTO bodn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ཁྱོད་ཀྱིས་ཞིང་རྨོས་ཀྱང་ས་ཡིས་ཁྱོད་ལ་འབྲས་བུ་མི་བསྐྱེད་པས་ཁྱོད་ས་སྟེང་དུ་འཁྱམ་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","དེ་ནས་ཀཱ་ཡན་ན༌རེ། ང་ལ་ཉེས་ཆད་བཅད་པ་ལྗིད་དྲགས་པས་འཁུར་མི་ནུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ཁྱེད་ཀྱིས་ད་ལྟ་ང་རང་ས་ཆ་འདི་ནས་བདས་པས་ངས་ཁྱེད་རང་མཇལ་མི་ནུས་པ༌དང༌། ང་རང་ས་མཐར་འཁྱམ་པ་སུ་ཞིག་གིས་མཐོང༌ན། དེས་ང་གསོད་པར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། སུ་ཞིག་གིས་ཀཱ་ཡན་བསད་ན་དེ་ལ་ཉེས་ཆད་ལན་བདུན་འཕོག་ངེས་ཡིན་ཞེས་གསུངས་པ༌དང༌། ཀཱ་ཡན་ལ་རྟགས་ཤིག་གནང་སྟེ་སུས་མཐོང་ཡང་མི་གསོད་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","དེ་ནས་ཀཱ་ཡན་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་ནས་ཁ་གྱེས་ཏེ་ཨེ་དེན་ཡུལ་གྱི་ཤར་ཕྱོགས་སུ་ཡོད་པའི་ནོད་ཅེས་པའི་ཡུལ་དུ་སོང་ནས་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","དེ་ནས་ཀཱ་ཡན་རང་གི་ཆུང་མ་དང་ལུས་འབྲེལ་བྱས༌ཤིང༌། ཁོའི་ཆུང་མར་མངལ་སྦྲུམ་སྟེ་བུ་ཧ་ནོག་སྐྱེས༌སོ། །ཀཱ་ཡན་གྱིས་གྲོང་ཁྱེར་ཞིག་བརྩིགས་ཤིང་རང་གི་བུའི་མིང་བཞིན་ཧ་ནོག་གྲོང་ཁྱེར་ཞེས༌བཏགས། ");
INSERT INTO bodn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ཧ་ནོག་ལ་བུ་ཨི་རཱད་སྐྱེས་པ༌དང༌། ཨི་རཱད་ལ་བུ་མཱ་ཧུ་ཡ་ཨེལ་སྐྱེས་པ༌དང༌། མཱ་ཧུ་ཡ་ཨེལ་ལ་བུ་མཱ་ཐུ་ཤཱ་ཨེལ་སྐྱེས་པ༌དང༌། མཱ་ཐུ་ཤཱ་ཨེལ་ལ་བུ་ལཱ་མེག་སྐྱེས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","དེ་ནས་ལཱ་མེག་གིས་ཆུང་མ་གཉིས་བླངས་ཤིང་གཅིག་གི་མིང་ལ་ཨ་དཱ་ཞེས་ཟེར་བ་དང་ཅིག་ཤོས་ལ་ཚི་ལཱ་ཞེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ཨ་དཱ་ལ་བུ་ཡཱ་བལ་སྐྱེས༌ཤིང༌། དེ་ནི་གུར་དུ་སྡོད་པ་དང་ཕྱུགས་འཚོ་བའི་མི་རྣམས་ཀྱི་མེས་པོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","དེ་ཡང་ཡཱ་བལ་ལ་ཡུ་བཱལ་ཞེས་ཟེར་བའི་སྤུན་ཞིག་ཡོད་པ་ནི་པི་ཝང་འཁྲོལ་བ་དང་འཕྲེད་གླིང་འབུད་པའི་མི་ཐམས་ཅད་ཀྱི་མེས་པོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ཚི་ལཱ་ཡིས་ཀྱང་བུ་ཐུ་བཱལ་ཀཱ་ཡན་བཙས༌ཤིང༌། དེ་ནི་ཟངས་ལྕགས་ལས་སྣོན་བྱེད་མཁན་གྱི་མགར་པ་ཐོག་མ༌ཡིན། ཐུ་བཱལ་ཀཱ་ཡན་ལ་སྲིང་མོ་ཞིག་ཡོད་པ་ནི་ནཱ་ཨ་མཱ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","དེ་ནས་ལཱ་མེག་གིས་རང་གི་ཆུང་མ་གཉིས་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ང་ཡི་སྐད་ལ་ཉོན་ཅིག་ཨ་དཱ་དང་ཚི༌ལཱ།། ང་ཡི་གཏམ་ལ་གསོན་དང་ལཱ་མེག་གི་ཆུང༌མ།། ང་རང་རྨས་པར་བྱས་པས་མི་ཞིག་བདག་གིས༌བསད།། ང་ལ་བརྒྱབ་པས་གཞོན་ནུ་ཞིག་ཀྱང་བདག་གིས༌བསད།། ");
INSERT INTO bodn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ཀཱ་ཡན་བསད་ན་ཉེས་ཆད་ལན་བདུན་དུ་འབྱུང༌ཞིང༌།། ང་རང་བསད་ན་ཉེས་ལན་དོན་བདུན་ནི་དགོས༌སོ། །ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ཨ་དམ་སླར་ཡང་རང་གི་ཆུང་མ་དང་ལུས་འབྲེལ་བྱས༌ཤིང༌། ཁོ་མོས་བུ་ཞིག་བཙས་པ་དང་མིང་ལ་སེད་ཐུ་ཞེས་བཏགས་པ༌སྟེ། ཀཱ་ཡན་གྱིས་ཧ་བེལ་བསད་པས་དཀོན་མཆོག་གིས་བདག་ལ་ཧ་བེལ་གྱི་ཚབ་ཏུ་བུ་འདི་གནང་བ་ཡིན་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","དེ་ནས་སེད་ཐུ་ལའང་བུ་ཞིག་སྐྱེས་ཤིང་མིང་ལ་ཨེ་ནོ་ཤཱ་ཞེས་བཏགས༌སོ། །དུས་དེ་ནས༌བཟུང༌། མི་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ནས་འབོད་པའི་འགོ་ཚུགས་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","འདིའི་མན་ནི་ཨ་དམ་གྱི་རིགས་རྒྱུད་ཀྱི་མིང་ཐོ་ཡིན༌ནོ། །དེ་ཡང་དཀོན་མཆོག་གིས་མིའི་རིགས་བསྐྲུན་པའི་ཉིན༌ལ། ཁོང་གིས་རང་ཉིད་ཀྱི་སྣང་བརྙན་ལྟར་མི་བསྐྲུན་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ཕོ་མོ་གཉིས་སུ་མཛད་ཅིང་བྱིན་གྱིས་བརླབས་ཏེ་མིང་ལ་མི་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","དེ་ནས་ཨ་དམ་དགུང་ལོ་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པའི་དུས༌སུ། བྱད་གཟུགས་དང་སྣང་བརྙན་རང་ཉིད་དང་མཚུངས་པའི་བུ་ཞིག་སྐྱེས་པ་ལ་སེད་ཐུ་ཞེས་མིང་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ཨ་དམ་ལ་བུ་སེད་ཐུ་སྐྱེས༌རྗེས། ཡང་ལོ་བརྒྱད་བརྒྱ་ལ་བཞུགས་ཤིང་བུ་དང་བུ་མོ་གཞན་དག་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","དེ་ལྟར་ཨ་དམ་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་སུམ་ཅུར་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","དེ་ནས་སེད་ཐུ་ལོ་བརྒྱ་དང་ལྔ་ལོན་པའི་དུས་སུ་བུ་ཨེ་ནོ་ཤཱ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ཨེ་ནོ་ཤཱ་སྐྱེས་པའི་རྗེས་སུ་སེད་ཐུ་ཡང་ལོ་བརྒྱད་བརྒྱ་དང་བདུན་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","དེ་ལྟར་སེད་ཐུ་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་བཅུ་གཉིས་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","དེ་ཡང་ཨེ་ནོ་ཤཱ་ལོ་དགུ་བཅུ་ལོན་པའི་དུས་སུ་བུ་ཀེ་ནན༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ཀེ་ནན་སྐྱེས་རྗེས་ཨེ་ནོ་ཤཱ་ཡང་ལོ་བརྒྱད་བརྒྱ་དང་བཅོ་ལྔར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ཨེ་ནོ་ཤཱ་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་ལྔ་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","དེ་ནས་ཀེ་ནན་ལོ་བདུན་ཅུ་ལོན་པའི་དུས་སུ་བུ་མཱ་ཧ་ལ་ཨེལ་ཞེས་པ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","དེའི་རྗེས་སུ་ཀེ་ནན་ཡང་ལོ་བརྒྱད་བརྒྱ་དང་བཞི་བཅུར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","དེ་ལྟར་ཀེ་ནན་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་བཅུ་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","དེ་ནས་མཱ་ཧ་ལ་ཨེལ་ལོ་དྲུག་ཅུ་རེ་ལྔ་ལོན་པའི་དུས་སུ་བུ་ཡཱ་རཱད༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","དེའི་རྗེས་སུ་མཱ་ཧ་ལ་ཨེལ་ཡང་ལོ་བརྒྱད་བརྒྱ་དང་སུམ་ཅུར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","དེ་ལྟར་མཱ་ཧ་ལ་ཨེལ་བསྡོམས་པས་ལོ་བརྒྱད་བརྒྱ་དང་གོ་ལྔར་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","དེ་ནས་ཡཱ་རཱད་ལོ་བརྒྱ་དང་རེ་གཉིས་ཡིན་པའི་དུས་སུ་བུ་ཧ་ནོག་ཅེས་པ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","དེའི་རྗེས་སུ་ཡཱ་རཱད་ཡང་ལོ་བརྒྱད་བརྒྱར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","དེ་ལྟར་ཡཱ་རཱད་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་རེ་གཉིས་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","དེ་ནས་ཧ་ནོག་ལོ་དྲུག་ཅུ་རེ་ལྔ་ལོན་རྗེས་བུ་མཱ་ཐུ་ཤ་ལཱ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","དེའི་རྗེས་སུ་ཧ་ནོག་ནི་ལོ་སུམ་བརྒྱར་དཀོན་མཆོག་དང་ལྷན་དུ་བསྐྱོད་དེ་བུ་དང་བུ་མོ་གཞན་དག་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","དེ་ལྟར་ཧ་ནོག་བསྡོམས་པས་ལོ་སུམ་བརྒྱ་དང་རེ་ལྔ་ལ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ཧ་ནོག་ནི་དཀོན་མཆོག་དང་མཉམ་དུ་འགྲོགས་པ༌དང༌། དཀོན་མཆོག་གིས་ཁོ་རང་འཇིག་རྟེན་ལས་དྲངས་པས་ མི་མཐོང་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","དེ་ནས་མཱ་ཐུ་ཤ་ལཱ་ལོ་བརྒྱ་དང་གྱ་བདུན་ལོན་རྗེས་བུ་ལཱ་མེག༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","དེའི་རྗེས་སུ་མཱ་ཐུ་ཤ་ལཱ་ཡང་ལོ་བདུན་བརྒྱ་དང་གྱ་གཉིས་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","དེ་ལྟར་མཱ་ཐུ་ཤ་ལཱ་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་རེ་དགུ་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","དེ་ནས་ལཱ་མེག་ལོ་བརྒྱ་དང་གྱ་གཉིས་ལོན་ནས་བུ་ཞིག་སྐྱེས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ཁོང་གིས་བུའི་མིང་ལ་ནོ་ཨ་ཞེས་བཏགས༌ཏེ། བུ་འདིས་རང་ཅག་གི་ངལ་རྩོལ་དང་དཀའ་ཚེགས་ལ་སེམས་གསོ་བྱེད་པར་འགྱུར༌རོ། །རྒྱུ་མཚན་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ས་ལ་དམོད་པ་མཛད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","དེ་ནས་ལཱ་མེག་ལ་བུ་ནོ་ཨ་སྐྱེས༌རྗེས། ཡང་ལོ་ལྔ་བརྒྱ་དང་གོ་ལྔར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་དག་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","དེ་ལྟར་ལཱ་མེག་བསྡོམས་པས་ལོ་བདུན་བརྒྱ་དང་དོན་བདུན་ལ་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","དེ་ནས་ནོ་ཨ་ལོ་ལྔ་བརྒྱ་ལོན་པའི་དུས་སུ་ཤེམ་དང་ཧཱམ་དང་ཡ་ཕེད་ཅེས་བྱ་བའི་བུ་གསུམ་སྐྱེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","དེ་ཡང་ས་སྟེང་དུ་མིའི་རིགས་ཇེ་མང་དུ་གྱུར་པ༌དང༌། ཁོ་རྣམས་ལ་བུ་མོ་སྐྱེ་བའི་དུས༌སུ། ");
INSERT INTO bodn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","དཀོན་མཆོག་གི་བུ་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་མོ་རྣམས་མཛེས་མ་ཡིན་པར་མཐོང༌སྟེ། རང་གི་འདོད་མོས་བཞིན་བདམས་ནས་ཆུང་མར་བླངས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། མི་ནི་ཤ་ཁྲག་གདོས་བཅས་ཀྱི་ཕུང་བོ་ཡིན༌ཏེ། བདག་གི་སེམས་ཉིད་ནི་དེ་དག་གི་ཁྲོད་དུ་ཇི་སྲིད་བར་དུ་མི་གནས༌ཀྱང༌། དེ་དག་ཚེ་ལོ་བརྒྱ་དང་ཉི་ཤུའི་རིང་ལ་འཚོ་ཐུབ་པར་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","དེའི་དུས་སུ་ས་སྟེང་དུ་ནེ་ཕེ་ལིམ་པ་རྣམས་ཀྱང་ཡོད་པ༌དང༌། རྗེས་སུ་དཀོན་མཆོག་གི་བུ་རྣམས་མིའི་བུ་མོ་རྣམས་ཀྱི་གྲས་སུ་ཚུད་ཅིང་དེ་དག་དང་འབྲེལ་ཏེ་བུ་སྐྱེས་པ༌ནི། གནའ་དུས་ཀྱི་མི་ཆེན་ཏེ་དཔའ་རྩལ་ཅན་དུ་གྲགས་པའི་མི་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ས་སྟེང་གི་མི་རྣམས་ཀྱི་སྤྱོད་ངན་ཤིན་ཏུ་ཚབས་ཆེ་ཞིང་སེམས་སུ་དྲན་པ་ནི་ནམ་ཡང་ངན་པ་ཤ་སྟག་ཡིན་པར་གཟིགས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ཁོང་གིས་འཇིག་རྟེན་དུ་མིའི་རིགས་བསྐྲུན་པར་འགྱོད་ཅིང་ཐུགས་སེམས་ཤིན་ཏུ་སྐྱོ༌བའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། བདག་གིས་བསྐྲུན་པའི་མི༌དང༌། དུད་འགྲོ༌དང༌། ལྟོ་འགྲོ་འབུ༌སྲིན། ནམ་མཁའི་བྱ་དང་བཅས་པ་ཐམས་ཅད་ས་སྟེང་ནས་མེད་པར༌བྱའོ། །རྒྱུ་མཚན་ནི་དེ་རྣམས་བསྐྲུན་པ་ལ་བདག་འགྱོད་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ནོ་ཨ་ཁོ་ནར་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་ནས་ཐུགས་རྗེ་ཐོབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","དེ་ཡང་ནོ་ཨ་ཡི་རིགས་རྒྱུད་ནི་གཤམ་གསལ༌ལྟར། ནོ་ཨ་ནི་གཞུང་རྒྱུད་དྲང་པོ་ཞིག་ཡིན༌ཞིང༌། སྐབས་དེའི་མི་རབས་ལས་ཁོ་ནི་ཕུལ་དུ་བྱུང་བ་ཞིག་ཀྱང་ཡིན༌ལ། ཁོ་དཀོན་མཆོག་དང་ལྷན་དུ་བསྐྱོད་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ནོ་ཨ་ལ་བུ་གསུམ་སྐྱེས་པ༌ནི། ཤེམ༌དང༌། ཧཱམ། ཡ་ཕེད་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","དེ་ཡང་དཀོན་མཆོག་གི་སྤྱན་སྔར་འཇིག་རྟེན་ནི་ངན་རུལ་དུ་གྱུར་ཅིང་གདུག་རྩུབ་ཀྱིས་ཁེངས་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ཁོང་གིས་འཇིག་རྟེན་ལ་གཟིགས༌པའི་ཚེ། ཀྱེ་མ། འཇིག་རྟེན་ནི་ངན་པས་ཁེངས་འདུག ཅིའི་ཕྱིར་ཞེ་ན། མི་ཐམས་ཅད་ཀྱིས་ས་སྟེང་དུ་རང་རང་གི་བྱ་སྤྱོད་ངན་པ་སྤེལ་བས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","དེ་ནས་དཀོན་མཆོག་གིས་ནོ་ཨ་ལ་འདི་སྐད༌དུ། ཤ་ཁྲག་གདོས་བཅས་ཀྱི་མི་དེ་དག་གི་མཇུག་འབྲས་བདག་གི་མདུན་དུ་སླེབས༌ཤིང༌། ས་སྟེང་དུ་དེ་དག་གི་གདུག་རྩུབ་ཀྱིས་བཀང་ཡོད་པའི༌ཕྱིར། ལྟོས༌དང༌། བདག་གིས་དེ་རྣམས་ས་གཞི་དང་མཉམ་དུ་མེད་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ཁྱོད་ཀྱིས་རང་ཉིད་ལ་ཐང་ཤིང་གིས་གྲུ་གཟིངས་ཁང་མིག་མང་པོ་ཅན་ཞིག་བཟོ་བར༌གྱིས། གྲུའི་ཕྱི་ནང་གཉིས་ལ་ཐང་ཆུ་བསྐུས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","གྲུ་གཟིངས་བཟོ་ཚུལ་ནི་འདི་ལྟ༌སྟེ། རིང་ཐུང་ཁྲུ་སུམ་བརྒྱ༌དང༌། ཞེང་ཚད་ཁྲུ་ལྔ༌བཅུ། མཐོ་ཚད་ཁྲུ་སུམ༌ཅུའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","གྲུའི་སྟེང་དུ་དཀར་ཁུང་མཐོ་ཚད་ཁྲུ་གཅིག་ཅན་ཞིག་བཟོ་བར༌གྱིས། གྲུའི་སྒོ་ནི་འགྲམ་དུ་འབྱེད་པར་བྱེད་པ༌དང༌། གྲུ་དེ་རིམ་པ་སྟེང་འོག་བར་གསུམ་དུ་ཕྱེས་ནས་བཟོས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ལྟོས༌དང༌། བདག་གིས་ས་སྟེང་དུ་ཆུ་ལོག་བཏང་ནས་གནམ་འོག་ཐམས་ཅད་མེད་པར་བྱས༌ཏེ། ས་སྟེང་གི་དབུགས་དང་ལྡན་པའི་སྲོག་ལྡན་མཐའ་དག་གཅིག་ཀྱང་མི་ལུས་པར་འཆི་བར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","འོན་ཀྱང་བདག་གིས་ཁྱོད་དང་ཁ་ཆད་འཇོག༌སྟེ། ཁྱོད་དང་རང་གི་ཆུང་མ༌དང༌། བུ་དང་མནའ་མ་རྣམས་གྲུ་གཟིངས་ནང་དུ་འཇུག༌དགོས། ");
INSERT INTO bodn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","སྲོག་དང་ལྡན་པ་ཐམས་ཅད་ལས་ཕོ་མོ་ཆ་རེ་བྱས་ནས་ཁྱོད་ཀྱིས་གྲུ་གཟིངས་ནང་དུ་འཇུག་པར༌གྱིས། ཅིའི་ཕྱིར་ཞེ༌ན། དེ་དག་ཁྱོད་དང་མཉམ་དུ་སྲོག་བསྐྱབ་པར་འགྱུར་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","བྱ་དང་དུད༌འགྲོ། ས་སྟེང་གི་ལྟོ་འགྲོ་དང་འབུ་སྲིན་བཅས་པ་ཆ་རེ་བྱས་ནས་ཐམས་ཅད་རང་རང་གི་རིགས་བཞིན་དུ་སྲོག་སྐྱོབ་པའི༌ཕྱིར་ཁྱོད་ཀྱི་གནས་དེར་ཡོང་ངེས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ཁྱོད་ཀྱིས་རང་ཉིད་དང་དེ་དག་གི་ཟས་སུ་བཟའ་ཆས་སྣ་ཚོགས་གསོག་པར་གྱིས་ཤིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","དེ་ནས་ནོ་ཨས་ཀྱང་དེ་ལྟར་བྱས་པ༌རེད། དཀོན་མཆོག་གིས་ཇི་ལྟར་བཀའ་གནང་བ་བཞིན་ཁོས་ཀྱང་དོན་ཐམས་ཅད་དེ་ལྟར་བསྒྲུབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ནོ་ཨ་ལ་འདི་སྐད༌དུ། ཁྱོད་དང་ཁྱོད་ཀྱི་ཁྱིམ་མི་ཐམས་ཅད་གྲུ་གཟིངས་ནང་དུ་སོང༌ཞིག རྒྱུ་མཚན་ནི་བདག་གིས་དུས་རབས་འདིར་ཁྱོད་ཁོ་ན་བདག་གི་དྲུང་དུ་མི་གཞུང་དྲང་ཞིག་ཡིན་པ་མཐོང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ཁྱོད་ཀྱིས་དུད་འགྲོ་གཙང་མའི་རིགས་རེ་རེ་ལས་ཕོ་མོ་ཆ་བདུན་རེ༌དང༌། དུད་འགྲོ་མི་གཙང་བའི་རིགས་རེ་རེ་ལས་ཕོ་མོ་ཆ་གཅིག༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","བར་སྣང་དུ་འཕུར་བའི་འདབ་ཆགས་ཀྱི་རིགས་རེ་རེ་ལས་ཕོ་མོ་ཆ་བདུན་རེ་བཅས་ཁྱོད་དང་མཉམ་དུ་ཁྲིད༌ཅིག དེ་ནི་ས་གཞི་ཡོངས་སུ་རིགས་རྒྱུད་ཀྱི་ས་བོན་གསོན་པོར་གནས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","རྒྱུ་མཚན་ནི་ད་ནས་ཉིན་བདུན་སོང་བ༌ན། བདག་གིས་ཉིན་ཞག་བཞི་བཅུའི་རིང་ལ་ས་སྟེང་དུ་ཆར་བ་འབབ་ཏུ་བཅུག༌སྟེ། བདག་གིས་བསྐྲུན་པའི་སྲོག་ལྡན་ཐམས་ཅད་ས་སྟེང་ནས་མེད་པར་བཟོ་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ནོ་ཨས་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་ཇི་ལྟར་བཀའ་གནང་བ་བཞིན་དུ་བསྒྲུབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","དེ་ནས་ས་སྟེང་དུ་ཆུ་ལོག་བྱུང་བའི་སྐབས་སུ་ནོ་ཨ་དགུང་ལོ་དྲུག་བརྒྱ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ནོ་ཨ་དང་རང་གི་ཆུང༌མ། བུ་དང་མནའ་མ་རྣམས་མཉམ་དུ་གྲུ་གཟིངས་ནང་དུ་སོང་ནས་ཆུ་ལོག་ལ་བྱོལ་བར༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","དཀོན་མཆོག་གིས་ནོ་ཨ་ལ་བཀའ་གནང་བ༌ལྟར། དུད་འགྲོ་གཙང་མི་གཙང༌དང༌། བྱ་རྣམས༌དང༌། ལྟོ་འགྲོ་དང་འབུ་སྲིན་ཐམས་ཅད༌ལས། ");
INSERT INTO bodn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ཕོ་མོ་ཆ་རེ་ཡོད་པ་ཐམས་ཅད་ནོ་ཨའི་མདུན་དུ་ཡོང་ནས་གྲུ་གཟིངས་ནང་ལ་ཞུགས། ");
INSERT INTO bodn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","དེ་ནས་ཉིན་བདུན་གྱི་རྗེས་སུ་ས་སྟེང་དུ་ཆུ་ལོག་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ནོ་ཨ་དགུང་ལོ་དྲུག་བརྒྱ་ལོན་པའི་ཟླ་གཉིས་པའི་ཚེས་བཅུ་བདུན༌ཉིན། རྒྱ་མཚོའི་གཏིང་འོག་གི་ཆུ་མིག་ཐམས་ཅད་བརྡོལ་ཞིང་ནམ་མཁའི་སྒེའུ་ཁུང་ཡང་ཕྱེས་པ་དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ཉིན་ཞག་བཞི་བཅུའི་རིང་ལ་ས་སྟེང་དུ་ཆར་བ་ཆེན་པོ་བབས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","དེ་ཡང་ཉིན་དེ་ལ་ནོ་ཨ་དང་ཁོའི་བུ་ཤེམ༌དང༌། ཧཱམ། ཡ་ཕེད་བཅས༌དང༌། ཁོའི་ཆུང་མ་དང་མནའ་མ་གསུམ་པོ་དང་བཅས་པ་ཐམས་ཅད་གྲུ་གཟིངས་ནང་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ཁོ་རྣམས༌དང༌། དུད༌འགྲོ། ཕྱུགས༌ཟོག ས་སྟེང་གི་ལྟོ་འགྲོ་དང་འབུ་སྲིན་ཐམས་ཅད༌དང༌། འདབ་ཆགས་ཀྱི་རིགས་སུ་གྱུར་པ་ཐམས་ཅད་རང་རང་གི་རིགས་བཞིན་དུ་ཚང་མ་གྲུ་གཟིངས་ནང་དུ༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","དེ་ལྟར་སྲོག་དང་ལྡན་པ་ཐམས་ཅད་ལས་ཆ་རེ་བཞིན་ནོ་ཨའི་མདུན་དུ་ཡོང་ནས་གྲུ་གཟིངས་ནང་ལ་ཞུགས། ");
INSERT INTO bodn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","དཀོན་མཆོག་གིས་ནོ་ཨ་ལ་བཀའ་གནང་བ་བཞིན་སྲོག་ཆགས་ཕོ་མོ་ཆ་རེ་བཞིན་གྲུ་གཟིངས་ནང་དུ་སོང་བ༌དང༌། ཁོང་གིས་ནོ་ཨའི་རྒྱབ་ཏུ་གྲུ་གཟིངས་ཀྱི་སྒོ་བརྒྱབ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","དེ་ཡང་ཉིན་བཞི་བཅུའི་རིང་ལ་ས་སྟེང་དུ་ཆུ་ལོག་བྱུང་སྟེ་ཆུ་རྒྱས་ནས་གྲུ་གཟིངས་ཀྱང་ཡར་བཏེགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ཆུ་ཤུགས་ཆེན་པོར་གྱུར་ཏེ་ས་སྟེང་དུ་ཆུ་ཆེན་པོ་རྒྱས་པས་གྲུ་གཟིངས་ནི་ཆུའི་ངོས་སུ་ཕར་གཡོ་ཚུར་གཡོ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","དེ་ནས་ས་སྟེང་དུ་ཆུ་ཆེར་རྒྱས་པས་གནམ་འོག་གི་རི་མཐོན་པོ་ཐམས་ཅད་བསྣུབས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ཆུ་རྒྱས་པ་ནི་རི་བོ་ལས་ཁྲུ་བཅོ་ལྔས་མཐོ་བས་རི་ལུང་ཐམས་ཅད་བསྣུབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ས་སྟེང་དུ་ཡོད་པའི་སྲོག་ལྡན༌ཏེ། འདབ་ཆགས༌དང༌། ཕྱུགས༌ཟོག རི༌དྭགས། ལྟོ་འགྲོ་དང་འབུ་སྲིན་དང་མིའི་རིགས་དང་བཅས་པ་ཐམས་ཅད་འཆི་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","དེ་ཡང་སྐམ་སའི་སྟེང་གི་དབུགས་དང་ལྡན་པའི་སྲོག་ལྡན་ཐམས་ཅད་འཆི་བར་གྱུར་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","གྲུ་གཟིངས་ཀྱི་ནང་དུ་ནོ་ཨ་དང་མཉམ་དུ་ཡོད་པ་དག་ལས༌གཞན། ས་སྟེང་གི་སྲོག་དང་ལྡན་པ༌སྟེ། མིའི་རིགས༌དང༌། དུད་འགྲོ་དང་ལྟོ་འགྲོ་འབུ༌སྲིན། ནམ་མཁའི་བྱ་དང་བཅས་པ་ཐམས་ཅད་ས་སྟེང་ནས་མེད་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","དེ་ལྟར་ས་སྟེང་དུ་ཆུ་ལོག་ཆེན་པོ་རྒྱས་ཏེ་བསྡོམས་པས་ཉིན་བརྒྱ་དང་ལྔ་བཅུ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","དེ་ཡང་དཀོན་མཆོག་གིས་ནོ་ཨ་དང་ཁོའི་གྲུ་གཟིངས་ནང་གི་སྲོག་ལྡན་ཐམས་ཅད་ཐུགས་ལ་དགོངས༌ཏེ། ས་རུ་རླུང་གཡུག་ཏུ་བཅུག་པས་ཆུ་རིམ་གྱིས་བྲི་བར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","དེ་ནས་རྒྱ་མཚོའི་གཏིང་འོག་གི་ཆུ་མིག་དང་ནམ་མཁའི་དཀར་ཁུང་བཅད་དེ་ཆར་བའང་འབབ་མཚམས་བཞག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ས་གཞིའི་སྟེང་དུ་ཆུ་ལོག་བྱུང་བ་ནས་ཉིན་བརྒྱ་དང་ལྔ་བཅུ་འགོར་རྗེས་ཆུ་རིམ་གྱིས༌བྲིའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ཟླ་བདུན་པའི་ཚེས་བཅུ་བདུན་ཉིན༌ལ། གྲུ་གཟིངས་དེ་རི་རྒྱུད་ཨ་ར་རད་ ཅེས་པ་དེའི་སྟེང་དུ་བསྡད་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ཡང་ཆུ་རིམ་གྱིས་བྲི་ཞིང་ཟླ་བཅུ་པའི་ཚེས་གཅིག་ཉིན༌ལ། རི་རྩེ་གཞན་དག་ཀྱང་ཕྱིར་མངོན་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","དེ་ནས་ཉིན་བཞི་བཅུ་འགོར་བ༌ན། ནོ་ཨས་དེ་སྔར་བཟོས་པའི་གྲུ་གཟིངས་ཀྱི་སྒེའུ་ཁུང་ཕྱེས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","བྱ་ཕོ་རོག་ཅིག་ཕྱིར་བཏང་བ༌དང༌། ས་སྟེང་གི་ཆུ་བྲི་བའི་བར་དུ་ཕོ་རོག་ཕར་ཚུར་འཕུར་བསྐྱོད་བྱས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ཡང་ཁོས་ཕུག་རོན་ཅིག་ཕྱིར་བཏང་ནས་ཆུ་ས་སྟེང་ནས་བྲི་མིན་ལ་བལྟས༌ཀྱང༌། ");
INSERT INTO bodn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ས་གཞི་ཡོངས་ལ་ད་དུང་ཆུས་བཀང་ཡོད་པས་ཕུག་རོན་ས་ལ་འབབ་ས་མེད་པར་ཕྱིར་གྲུ་གཟིངས་ཀྱི་ཕྱོགས་སུ་ནོ་ཨའི་རྩར་འཕུར་འོངས་པ༌དང༌། ཁོས་ལག་པ་བརྐྱངས་ནས་ཕུག་རོན་གྲུ་གཟིངས་ཀྱི་ནང་དུ་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ཡང་ཉིན་བདུན་ལ་བསྒུགས༌རྗེས། ནོ་ཨས་སླར་ཡང་ཕུག་རོན་དེ་གྲུ་ལས་བཏང་བ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ས་རུབ་རྗེས་ཕུག་རོན་གྱི་མཆུ་ཏོར་སྐྱུ་རུ་རའི་ལོ་མ་གསར་པ་ཞིག་བཟུང་ནས་ཕྱིར་ཡོང༌བས། ནོ་ཨས་ས་སྟེང་གི་ཆུ་བྲི་སོང་བ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ཡང་ཉིན་བདུན་ལ་བསྒུགས༌རྗེས། ནོ་ཨས་ཕུག་རོན་དེ་གྲུ་ལས་བཏང་བ་ལ་ཕུག་རོན་ཕྱིར་མ་ལོག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","དེ་ནས་ནོ་ཨ་ལོ་དྲུག་བརྒྱ་དང་གཅིག་ལོན་པའི་ཟླ་དང་པོའི་ཚེས་གཅིག༌ཉིན། ས་སྟེང་གི་ཆུ་ཐམས་ཅད་བྲི༌ཞིང༌། ནོ་ཨས་གྲུ་གཟིངས་ཀྱི་དཀར་ཁུང་ཕྱེས་ནས་བལྟས་པ་ན་ས་ངོས་སྐམ་འདུག་པ༌མཐོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ཟླ་གཉིས་པའི་ཚེས་ཉེར་བདུན༌ཉིན་ས་གཞི་ཡོངས་སུ་སྐམ་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","དེ་ནས་དཀོན་མཆོག་གིས་ནོ་ཨ་ལ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","ཁྱོད་དང་ཁྱོད་ཀྱི་ཆུང་མ༌དང༌། བུ་དང་མནའ་མ་ཐམས་ཅད་གྲུ་གཟིངས་ལས་བོབས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ཁྱོད་དང་མཉམ་དུ་ཡོད་པའི་སྲོག་ལྡན་ཐམས་ཅད༌དེ། འདབ་ཆགས༌དང༌། དུད༌འགྲོ། ལྟོ་འགྲོ་དང་འབུ་སྲིན་མཐའ་དག་ཕྱི་རོལ་ཏུ་ཁྲིད༌ཅིག ཅིའི་ཕྱིར་ཞེ༌ན། དེ་རྣམས་ས་སྟེང་དུ་ཧ་ཅང་མང་དུ་འབྱུང་བ༌དང༌། རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་པོར་འཕེལ་བར་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","དེ་ནས་ནོ་ཨ་དང་ཁོའི་ཆུང་མ༌དང༌། བུ་དང་མནའ་མ་བཅས་ཐམས་ཅད་ཕྱི་རོལ་ཏུ་ཐོན༌ཞིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","དུད་འགྲོ་ཐམས་ཅད༌དང༌། ལྟོ་འགྲོ་འབུ༌སྲིན། འདབ༌ཆགས། ས་སྟེང་དུ་རྒྱུ་བའི་སྲོག་ཆགས་ཐམས་ཅད་ཀྱང་རང་རང་གི་རིགས་བཞིན་དུ་གྲུ་གཟིངས་ལས་ཕྱིར་བུད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","དེ་ནས་ནོ་ཨས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་ཁྲི་ཞིག་བཞེངས༌ཤིང༌། ཕྱུགས་ཟོག་དང་འདབ་ཆགས་ལས་སྲོག་ལྡན་གཙང་མ་འགའ་ཤས་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་ཏུ་ཕུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","དཀོན་མཆོག་ཡ་ཝཱེས་དྲི་བསུང་ཞིམ་པོ་འཐུལ་འོང་བ་བསྣམས༌ཏེ། ཁོང་གི་ཐུགས༌ལ། མིའི་རིགས་ནི་ལོ་ན་གཞོན་པའི་དུས་ནས་ངན་སེམས་བཅངས་ཡོད༌ནའང༌། དེང་ཕྱིན་བདག་གིས་མིའི་རྐྱེན་ལ་བརྟེན་ནས་ས་གཞིར་དམོད་པ་མི༌བྱའོ། །ད་ལྟ་བྱས་པ་བཞིན་དུ་སྲོག་དང་ལྡན་པ་རྣམས་བརླག་པར་ཡང་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ས་གཞི་གནས་པའི་དུས༌སུ། ས་བོན་འདེབས་པ་དང་སྟོན་བསྡུ༌བ། གྲང་ངར་དང་ཚ༌བ། དབྱར་དང༌དགུན། ཉིན་མོ་དང་མཚན་མོའི་རྒྱུན་ནི་ནམ་ཡང་གཅོད་པར་མི་བྱ་བར་དགོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","དེ་ནས་དཀོན་མཆོག་གིས་ནོ་ཨ་དང་ཁོའི་བུ་རྣམས་ལ་བྱིན་གྱིས་བརླབས་ཏེ་འདི་སྐད༌དུ། ཁྱོད་རྣམས་ཀྱིས་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་དུ་སྤེལ་ཏེ་ས་གཞིར་གང་བར་གྱིས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","བདག་གིས་ས་སྟེང་དུ་རྒྱུ་བའི་དུད་འགྲོ༌དང༌། ནམ་མཁའི༌བྱ། ས་སྟེང་གི་ལྟོ་འགྲོ་དང་འབུ་སྲིན་དང་རྒྱ་མཚོའི་ཉ་ཐམས་ཅད་ཁྱོད་ཅག་ལ་དབང་བར་བྱས༌ཤིང༌། དེ་རྣམས་ཁྱོད་ཅག་ལ་འཇིགས་ཤིང་སྐྲག་པར་གྱུར༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","སྲོག་ཆགས་ཐམས་ཅད་ཁྱོད་རྣམས་ཀྱིས་ཟས་སུ་བྱོས༌དང༌། འདི་ཐམས་ཅད་ནི་སྔོན་ལ་སྔོ་ཚལ་སྤྲད་པ་བཞིན་དུ་བདག་གིས་ཁྱོད་ཅག་ལ་སྦྱིན་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","འོན་ཀྱང་ཤ་ལ་ཁྲག་འདྲེས་པ་ནི་དེ་དག་གི་ཚེ་སྲོག་ཡིན་པས་བཟའ་མི་རུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ཁྱོད་ཅག་ལ་ཁྲག་བཞུར་བར་བྱེད༌ན། བདག་གིས་དེ་ལས་སྐྱིན་ཚབ་ལེན་པ༌དང༌། གཅན་གཟན་གང་གིས་ཁྱོད་རྣམས་ཀྱི་སྲོག་བཅད༌ན། བདག་གིས་དེ་ལས་སྐྱིན་ཚབ་ལེན་པར༌ངེས། ལག་དམར་སུ་ཡིན་ཡང་དེ་ལས་རང་གི་སྤུན་ཟླའི་ཚེ་སྲོག་གི་སྐྱིན་ཚབ་ཏུ་དེའི་ཚེ་སྲོག་ཀྱང་ལེན་དགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ཡང་སུ་ཞིག་གིས་མི་བསད༌ན། ལག་དམར་དེའི་སྲོག་ཀྱང་མི་གཞན་གྱིས་ལེན་དགོས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། དཀོན་མཆོག་གིས་མིའི་རིགས་བསྐྲུན་པ་ནི་རང་གི་སྣང་བརྙན་ལྟར་བསྐྲུན་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ཡང་ཁྱོད་རྣམས་ཀྱིས་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་དུ་སྤེལ་ཏེ་ས་སྟེང་དུ་དར་ཞིང་རྒྱས་པར་གྱིས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་ནོ་ཨ་དང་ཁོའི་བུ་རྣམས་ལ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","ལྟོས༌དང༌། བདག་གིས་ཁྱོད་དང་ཁྱོད་ཅག་གི་མི་རབས་ཕྱི་མ་རྣམས་ལ་ཁ་ཆད་འཇོག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ཁྱོད་ཅག་དང་མཉམ་དུ་ཡོད་པའི་སྲོག་ཆགས་ཐམས་ཅད༌དེ། འདབ་ཆགས༌དང༌། ཕྱུགས་ཟོག་དང་རི་དྭགས་ཐམས༌ཅད། གྲུ་གཟིངས་ལས་ཕྱིར་འོངས་པའི་སྲོག་ལྡན་ཐམས་ཅད་ལའང་ཁ་ཆད་འཇོག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","བདག་དང་ཁྱོད་རྣམས་ཀྱི་བར་དུ་ཁ་ཆད་འཇོག༌སྟེ། དུས་ད་ནས༌བཟུང༌། སྲོག་དང་ལྡན་པ་ཐམས་ཅད་ཆུ་ལོག་གིས་བསྣུབ་པར་མི་བྱེད་པ༌དང༌། ས་གཞིའང་ཆུ་ལོག་གིས་བསྣུབ་པར་མི་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། བདག་གིས་ཁྱོད་དང་ཁྱོད་ཅག་དང་མཉམ་དུ་ཡོད་པའི་སྲོག་ཆགས་ཐམས་ཅད༌དང༌། མི་རབས་ཕྱི་མ་ཐམས་ཅད་ལ་ཁ་ཆད་ཀྱི་རྟགས་ཤིག་བཀོད་ཡོད༌དེ། ");
INSERT INTO bodn_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","བདག་གིས་འཇའ་ཚོན་ནི་སྤྲིན་ཕུང་ནང་དུ་བཞག༌ཅིང༌། དེ་ནི་བདག་དང་ས་གཞིའི་བར་དུ་ཁ་ཆད་བཞག་པའི་རྟགས་སུ་བྱས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ཕྱིས་སུ་སྤྲིན་ཕུང་གིས་ས་གཞི་ཡོངས་སུ་བསྒྲིབས་པའི་དུས༌སུ། བདག་གིས་སྤྲིན་ཕུང་ལས་འཇའ་ཚོན་མཐོང་བར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","དེས་ན་བདག་གིས་ཁྱོད་ཅག་དང་སྲོག་ལྡན་ཐམས་ཅད་ཀྱི་བར་དུ་བཞག་པའི་ཁ་ཆད་དྲན་པར་འགྱུར་ཞིང་ཆུ་ཡང་བསྐྱར་རྒྱས་ནས་ས་གཞིའི་སྟེང་གི་སྲོག་དང་ལྡན་པ་ཐམས་ཅད་མེད་པར་མི་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","འཇའ་ཚོན་ནི་སྤྲིན་གྱི་ནང་དུ་འཆར་ངེས་པ་དང་བདག་གིས་དེ་མཐོང་བ༌ན། བདག་གིས་སྲོག་དང་ལྡན་པ་ཐམས་ཅད་ཀྱི་བར་དུ་བཞག་པའི་དུས་གཏན་གྱི་ཁ་ཆད་དེ་དྲན་པར་ངེས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་ནོ་ཨ་ལ་འདི་སྐད༌དུ། འདི་ནི་བདག་གིས་ས་གཞིའི་སྟེང་གི་སྲོག་དང་ལྡན་པ་ཐམས་ཅད་ལ་ཁ་ཆད་བཞག་པའི་རྟགས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","དེ་ནས་གྲུ་གཟིངས་ལས་ཕྱིར་བུད་པའི་ནོ་ཨའི་བུ་ནི་ཤེམ་དང་ཧཱམ་དང་ཡ་ཕེད་གསུམ་ཡིན༌ལ། ཧཱམ་ནི་ཀ་ན་ཨན་གྱི་ཕ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","འདི་གསུམ་པོ་ནི་ནོ་ཨའི་བུ་ཡིན༌ལ། ཁོ་ཚོའི་རིགས་རྒྱུད་ས་གཞི་ཡོངས་སུ་ཁྱབ་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","དེ་ཡང་ནོ་ཨ་ཡིས་ཞིང་ལས་བྱེད་འགོ་བརྩམས༌ཏེ། ཁོས་རྒུན་འབྲུམ་ར་བ་ཞིག༌བཙུགས། ");
INSERT INTO bodn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ཁོས་རྒུན་ཆང་བཏུང་བ་དང་བཟི་བར་གྱུར་ཏེ་སྦྲ་གུར་ནང་དུ་ལུས་གཅེར་བུར་བསྡད་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ཀ་ན་ཨན་གྱི་ཕ་ཧཱམ་གྱིས་ཁོའི་ཕ་ལུས་གཅེར་བུར་སྡོད་པ་མཐོང༌སྟེ། ཕྱི་རུ་སོང་ནས་ཁོའི་སྤུན་གཉིས་ལ་སྨྲས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","དེ་ནས་ཤེམ་དང་ཡ་ཕེད་གཉིས་ཀྱིས་རང་གི་ཕྲག་པར་གྱོན་གོས་བཀལ་ནས་ཕྱི་ནུར་གྱིས་གུར་ནང་དུ་སོང་སྟེ་ཕ་ཡི་ལུས་ལ་བཀབ༌བོ། །སྐབས་དེར་ཁོ་གཉིས་ཀྱིས་ཁ་རྒྱབ་ལ་གཏད་དེ་ཕྱི་ནུར་བྱས་ནས་སོང་ཞིང་དེ་ནི་ཕ་གཅེར་བུ་ཡིན་པ་མི་མཐོང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","དེ་ནས་ནོ་ཨ་བཟི་དྭངས་པར་གྱུར་པ༌དང༌། བུ་ཆུང་བ་ཧཱམ་གྱིས་ཁོ་ལ་ལས་ཅི་བྱས་པ་ཤེས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ཁོ་ན༌རེ། ཀ་ན་ཨན་ལ་དམོད་པ་འཕོག་ཅིང་ཁོའི་སྤུན་གྱི་གཡོག་པོ་རྣམས་ཀྱི་གཡོག་པོ་བྱེད་པར་གྱུར་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ཡང་ཁོ་ན༌རེ། ཤེམ་གྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་ཅིང་བསྔགས་པར༌གྱིས། ཀ་ན་ཨན་ནི་ཁོའི་གཡོག་པོར་འགྱུར་བར༌སྨོན། ");
INSERT INTO bodn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","དཀོན་མཆོག་གིས་ཡ་ཕེད་ཀྱི་རིགས་རྒྱུད་དར་ཞིང་རྒྱས་པར་མཛོད༌ཅིག ཡ་ཕེད་ནི་ཤེམ་གྱི་སྦྲ་གུར་ནང་དུ་སྡོད་པར་གྱུར༌ཅིག ཡང་ཀ་ན་ཨན་ནི་ཡ་ཕེད་ཀྱི་གཡོག་པོར་གྱུར་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ཆུ་ལོག་བྱུང་བའི་རྗེས༌སུ། ནོ་ཨ་ཡང་ལོ་སུམ་བརྒྱ་དང་ལྔ་བཅུར་བཞུགས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ནོ་ཨ་བསྡོམས་པས་ལོ་དགུ་བརྒྱ་དང་ལྔ་བཅུར་བཞུགས་རྗེས་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","དེ་ཡང་ཆུ་ལོག་བྱུང་བའི་རྗེས་སུ་ནོ་ཨའི་བུ་ཤེམ་དང་ཧཱམ་དང་ཡ་ཕེད་བཅས་ལའང་བུ་སྐྱེས༌སོ། །ནོ་ཨའི་བུ་སོ་སོའི་རིགས་རྒྱུད་རྣམས་ནི་འདི་ལྟ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ཡ་ཕེད་ཀྱི་བུ་རྣམས་ནི་གོ་མེར༌དང༌། མ༌གཱོག མཱ་ཏི། ཡཱ༌ཝན། ཐུ༌བཱལ། མེ༌ཤེག ཐི་རཱ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","གོ་མེར་གྱི་བུ་རྣམས་ནི་ཨ་ཤ་ཀེ་ནཱ༌དང༌། རི༌ཕད། ཐོ་གར་མཱ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ཡཱ་ཝན་གྱི་བུ་རྣམས་ནི་ཨི་ལི་ཤཱ༌དང༌། ཐཱར༌ཞིས། ཀི༌ཐིམ། དོའུ་དཱ་ནིམ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","དེ་རྣམས་ལས་མཚོ་འགྲམ་དུ་སྡོད་པའི་མི་རིགས་དེ་དག་ནི་སོ་སོའི་སྐད་རིགས༌དང༌། ཁྱིམ༌རྒྱུད། རྒྱལ་ཕྲན་ལྟར་རང་རང་གི་ཡུལ་དུ་དར་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ཧཱམ་གྱི་བུ་རྣམས་ནི་གུ་ཤ༌དང༌། མུས་རཱ༌ཡིམ ། ཕུ༌ཏཱ། ཀ་ན་ཨན་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","གུ་ཤ་ཡི་བུ་རྣམས་ནི་སེ་བཱ༌དང༌། ཧ་བེ༌ལཱ། སཱབ༌ཐ། རཱ་ཨེ༌མཱ། སཱབ་ཐེ་ཀཱ་བཅས༌སོ། །རཱ་ཨེ་མཱའི་བུ་ནི་ཤེ་བཱ་དང་དི་དན་ཞེས་བྱ༌བའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","དེ་ནས་གུ་ཤ་ཞེས་པ་ལས་ནིམ་རོད་མཆེད་ཅིང༌། དེ་ནི་འཇིག་རྟེན་གྱི་དཔའ་རྒོད་ཐོག༌མའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ཁོ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་རྔོན་པ་དཔའ་བོ་ཞིག་ཡིན༌པས། ཁ་དཔེ༌ལ། དཀོན་མཆོག་ཡ་ཝཱེ་དྲུང་གི་རྔོན་པ་དཔའ་བོ་ནིམ་རོད་དང་འདྲ་བ་ཡིན་ཞེས་བརྗོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ནིམ་རོད་ཀྱི་རྒྱལ་སྲིད་ཐོག་མ་ནི་ཤིན་ཨར་ཡུལ་གྱི་པཱ་པེལ༌དང༌། ཨེ༌རེགས། ཨ༌ཁཱད། ཀལ་ནེ་བཅས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ཁོ་རང་གནས་དེ་ནས་ཨ་སུར་ཡུལ་དུ་སོང༌སྟེ། ནིན་ཝེ༌དང༌། རེའེ་ཧོ་པེད༌ཨིར། ཀ་ལཱ་བཅས་བཞེངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ནིན་ཝེ་དང་ཀ་ལཱ་གཉིས་བར་དུ་གྲོང་ཁྱེར་ཆེན་པོ་ཞིག་བཞེངས་པ་ནི་རེའེ་སཱན་ཞེས་པ་དེ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","དེ་ནས་མུས་རཱ་ཡིམ་ལས་ལུ་དཱ་པ༌དང༌། ཨ་ནཱམ༌པ། ལེ་ཧ༌པ། ནཱབ་ཐུ༌པ། ");
INSERT INTO bodn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ཕཱད་རུའུ༌པ། ཀཱ་སི་ལི༌པ། ༼འདི་བརྒྱུད་ནས་ཕེ་ལེ་ཤེད་མི་རིགས༌བྱུང༌།༽ ཀབ་ཐོར་པ་བཅས༌མཆེད་དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","དེ་ནས་ཀ་ན་ཨན་ལས་བུ་སྐྱེས་འགོ་ཚི་ཏུན་དང་། ཡང་ཧེད་དང་། ");
INSERT INTO bodn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ཡེ་བུ་སི་པ། ཨེ་མོར༌པ། གིར་གས༌པ། ");
INSERT INTO bodn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ཧེ་བི༌པ། ཨར་ཀི༌པ། སི་ནེ༌པ། ");
INSERT INTO bodn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ཨར་ཝཱ་དིའུ༌པ། ཚཱ་མཱ་རེའེ༌པ། ཧ་མཱད་པ་བཅས་མཆེད་དོ། །ཕྱིས་སུ་ཀ་ན་ཨན་གྱི་རིགས་རྒྱུད་འཐོར་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ཀ་ན་ཨན་པའི་ས་མཚམས་ནི་ཚི་ཏུན་ནས་གེ་རཱར་གྱི་ཕྱོགས་སུ་འགྲོ་བའི་ལམ་ནས་གཱ་ཟཱ་བར་ཡིན་པ༌དང༌། དེ་ནས་སཱ་དོམ༌དང༌། གཱ་མོ༌ར། ཨད༌མཱ། ཚཱ་བོ་ཡིམ་བཅས་ཀྱི་ཕྱོགས་སུ་འགྲོ་བའི་ལམ་ནས་ལཱ་ཤཱ་ཞེས་པའི་བར་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","དེ་དག་ནི་ཧཱམ་གྱི་བུ་རྒྱུད༌དེ། སོ་སོའི་ཁྱིམ་རྒྱུད༌དང༌། སྐད༌རིགས། ཡུལ༌ལུང༌། རྒྱལ་ཕྲན་བཞིན་དུ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","དེ་ཡང་ཡ་ཕེད་ཀྱི་ཕུ་བོ་ཤེམ་ནི་ཨེ་བེར་ཞེས་པའི་རིགས་རྒྱུད་རྣམས་ཀྱི་མེས་པོ་ཡིན༌ལ། ཁོ་ལ་བུ་སྐྱེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ཤེམ་གྱི་བུ་རྣམས་ནི་ཨེ་ལཱམ༌དང༌། ཨ༌ཤུར། ཨར་པག༌ཤད། ལུ༌ཏི། ཨ་རམ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ཨ་རམ་གྱི་བུ་རྣམས་ནི་ཨུ་ཟཱ༌དང༌། ཧུལ། གེ༌ཐེར། མཱ་ཤཱ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ཨར་པག་ཤད་ལས་ཤེ་ལཱ་མཆེད་པ་དང༌། ཤེ་ལཱ་ནས་ཨེ་བེར་མཆེད་དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ཨེ་བེར་ལས་བུ་གཉིས་མཆེད་ཅིང། གཅིག་ལ་ཕེ་ལེག་ཅེས་བྱ༌སྟེ། རྒྱུ་མཚན་ནི་དེའི་དུས་སུ་ས་གཞིའི་མི་རྣམས་ཁག་སོ་སོར་གྱེས་པའི་ཕྱིར་རོ། །ཁོའི་ནུ་བོའི་མིང་ལ་ཡོག་ཏན་ཞེས་བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ཡོག་ཏན་ལས་ཨལ་མོ་དཱད༌དང༌། ཤེ་ལཱ༌ཕཱ། ཧ་ཚཱར་མ༌ཝེད། ཡཱ༌ར། ");
INSERT INTO bodn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ཧ་དོ༌རམ། ཨུ༌ཟཱལ། དིག༌ལཱ། ");
INSERT INTO bodn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ཨོ༌བཱལ། ཨ་བི་མཱ༌ཨེལ། ཤེ༌བཱ། ");
INSERT INTO bodn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ཨོ་ཕིར། ཧ་བེ༌ལཱ། ཡོ་བཱབ་བཅས༌མཆེད་ཅིང་། དེ་ཐམས་ཅད་ཡོག་ཏན་གྱི་བུ་རྣམས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ཁོ་རྣམས་ཀྱི་སྡོད་གནས་ནི་མེ་ཤཱ་ཡུལ་ནས་སེ་ཕཱར་ཡུལ་གྱི་ཤར་ཕྱོགས་ཀྱི་རི་ཁུལ་བར༌དུའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","དེ་དག་ནི་ཤེམ་གྱི་བུ་རྒྱུད༌དེ། སོ་སོའི་ཁྱིམ་རྒྱུད༌དང༌། སྐད༌རིགས། ཡུལ༌ལུང༌། རྒྱལ་ཕྲན་བཞིན་དུ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","དེ་དག་ནི་ནོ་ཨའི་བུ་རྣམས་ཀྱི་རྒྱུད་པ༌སྟེ། སོ་སོའི་རིགས་རྒྱུད་དང་རྒྱལ་ཕྲན་བཞིན་དུ༌ཡིན། ཆུ་ལོག་བྱུང་བའི་རྗེས༌སུ། དེ་རྣམས་ལས་ས་སྟེང་གི་རྒྱལ་ཕྲན་རྣམས་སོ་སོའི་གནས་སུ་དར་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","དེ་ཡང་སྐབས་དེར་ས་སྟེང་གི་མི་ཀུན་གྱི་སྐད་དང་བརྗོད་པ་གཅིག་མཚུངས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","མི་དེ་རྣམས་ཤར་ཕྱོགས་སུ་གནས་སྤོར་བའི་དུས༌སུ། ཤིན་ཨར་ཡུལ་གྱི་ཐང་བདེ་མོ་ཞིག་མཐོང་སྟེ་གནས་དེར༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","དེ་ནས་ཁོ་རྣམས་ཀྱིས་ཕན་ཚུན་ལ་ན༌རེ། རང་ཅག་གིས་སོ་ཕག་བཟོ་བར༌བྱའོ། །མེར་བསྲེག་པར་བྱའོ་ཞེས་གྲོས་བྱས༌ཤིང༌། མི་དེ་རྣམས་ཀྱིས་སོ་ཕག་བླངས་ཏེ་རྡོ་རུ་བྱས་པ༌དང༌། འཇིམ་པའི་ཚབ་ལ་རྒྱ་སྐྱེགས་བཀོལ་ཏེ་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ཤོག༌དང༌། རང་ཅག་གི་མཚན་སྙན་གྲགས་རྒྱས་པའི༌ཕྱིར། རང་ཅག་གིས་གྲོང་ཁྱེར་ཞིག་དང་ལྕོག་མཁར་ཞིག་བཟོ་བར༌བྱའོ། །ལྕོག་མཁར་གྱི་རྩེ་མོ་གནམ་ལ་ཟུག་པ་ཞིག་བཟོ་བར༌བྱའོ། །དེ་ལྟར་མ་བྱས༌ཚེ། རང་ཅག་རྣམས་ས་སྟེང་ཀུན་ལ་འཐོར་ཉེན་ཆེ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","དེ་ཡང་འཇིག་རྟེན་མི་ཀུན་གྱིས་གྲོང་ཁྱེར་དང་ལྕོག་མཁར་བཞེང་བཞིན་པ་མཐོང་བའི་ཆེད་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་མར་འཇིག་རྟེན་དུ་ཕེབས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ཁོང་གིས་འདི་སྐད༌དུ། ལྟོས༌དང༌། དེ་རྣམས་མི་རིགས་གཅིག་ཡིན་ཞིང་སྐད་རིགས་གཅིག་སྨྲ་བ༌དང༌། དེང་སང་དོན་འདི་སྒྲུབ་འགོ་བརྩམས༌ཤིང༌། ཕྱིས་སུ་དེ་དག་གིས་བསྒྲུབ་པར་འགྱུར་བའི་ལས་ལ་མི་འགྲུབ་པ་ཅི་ཡང༌མེད། ");
INSERT INTO bodn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ངེད་རྣམས་སོང་ནས་དེ་དག་གི་སྐད་ལ་འགྱུར་བ་བྱུང་དུ་བཅུག༌སྟེ། ཕན་ཚུན་བར་གོ་བརྡའང་མི་འཕྲོད་པར་བྱའོ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མི་དེ་རྣམས་ས་སྟེང་ཀུན་ལ་གཏོར་བ༌དང༌། དེ་རྣམས་ཀྱིས་ཀྱང་གྲོང་ཁྱེར་བཟོ་མཚམས་བཞག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","གྲོང་ཁྱེར་དེའི་མིང་ལ་པཱ་པེལ་ཞེས་ཟེར༌ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་ས་སྟེང་ཀུན་གྱི་སྐད་རིགས་ཉོག་ཏུ་བཅུག་པ༌དང༌། མི་ཐམས་ཅད་ཀྱང་ས་གཞི་ཡོངས་ལ་འཐོར་བར་མཛད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ཤེམ་གྱི་རིགས་རྒྱུད་ནི་གཤམ་གསལ༌ལྟར། དེ་ཡང་ཆུ་ལོག་བྱུང་བའི་ལོ་གཉིས་ཀྱི་རྗེས༌སུ། ཤེམ་ལོ་བརྒྱ་ལོན་པའི་དུས་ལ་བུ་ཨར་པག་ཤད༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ཨར་པག་ཤད་སྐྱེས་པའི་རྗེས༌སུ། ཤེམ་ཡང་ལོ་ལྔ་བརྒྱར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ཨར་པག་ཤད་ལོ་སོ་ལྔ་ལོན་པའི་དུས་སུ་བུ་ཤེ་ལཱ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ཤེ་ལཱ་སྐྱེས་པའི་རྗེས་སུ་ཨར་པག་ཤད་ཡང་ལོ་བཞི་བརྒྱ་དང་གསུམ་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་དག་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ཤེ་ལཱ་ལོ་སུམ་ཅུ་ལོན་པའི་དུས་སུ་བུ་ཨེ་བེར༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ཨེ་བེར་སྐྱེས་པའི་རྗེས་སུ་ཤེ་ལཱ་ཡང་ལོ་བཞི་བརྒྱ་དང་གསུམ་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ཨེ་བེར་ལོ་སོ་བཞི་ལོན་པའི་དུས་སུ་བུ་ཕེ་ལེག༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ཕེ་ལེག་སྐྱེས་པའི་རྗེས་སུ་ཨེ་བེར་ཡང་ལོ་བཞི་བརྒྱ་དང་སུམ་ཅུ་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ཕེ་ལེག་ལོ་སུམ་ཅུ་ལོན་པའི་དུས་སུ་བུ་རེའེ་ཨུ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","རེའེ་ཨུ་སྐྱེས་པའི་རྗེས་སུ་ཕེ་ལེག་ཡང་ལོ་ཉིས་བརྒྱ་དང་དགུ་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","རེའེ་ཨུ་ལོ་སུམ་ཅུ་སོ་གཉིས་ལོན་པའི་དུས་སུ་བུ་སེ་རུག༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","སེ་རུག་སྐྱེས་པའི་རྗེས་སུ་རེའེ་ཨུ་ཡང་ལོ་ཉིས་བརྒྱ་དང་བདུན་ལ་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་དག་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","སེ་རུག་ལོ་སུམ་ཅུ་ལོན་པའི་དུས་སུ་བུ་ནཱ་ཧོར༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ནཱ་ཧོར་སྐྱེས་པའི་རྗེས་སུ་སེ་རུག་ཡང་ལོ་ཉིས་བརྒྱར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ནཱ་ཧོར་ལོ་ཉེར་དགུ་ལོན་པའི་དུས་སུ་བུ་ཐ་རཱ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ཐ་རཱ་སྐྱེས་པའི་རྗེས་སུ་ནཱ་ཧོར་ཡང་ལོ་བརྒྱ་དང་བཅུ་དགུར་བཞུགས་ཏེ་བུ་དང་བུ་མོ་གཞན་རྣམས་ཀྱང་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ཐ་རཱ་ལོ་བདུན་ཅུ་ལོན་པའི་དུས་སུ་བུ་ཨབ་རམ༌དང༌། ནཱ་ཧོར༌དང༌། ཧཱ་རན་བཅས་སྐྱེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ཐ་རཱའི་རིགས་རྒྱུད་རྣམས་གཤམ་དུ་བཀོད་པ་འདི་ལྟ༌སྟེ། ཐ་རཱ་ལ་བུ་ཨབ་རམ༌དང༌། ནཱ་ཧོར༌དང༌། ཧཱ་རན་བཅས་སྐྱེས༌ཤིང༌། ཧཱ་རན་ལ་བུ་ལོད་ཐུ༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ཧཱ་རན་ནི་ཁོའི་ཕ་སྟེ་ཐ་རཱ་འཇིག་རྟེན་དུ་བཞུགས་དུས་ཚེ་ལས་འདས༌སོ། །གང་དུ་ཞེ༌ན། ཀལ་དི་ཡུལ་དུ་ཡོད་པའི་རང་གི་ཕ་ཡུལ་ཨུར་གྲོང་ཁྱེར་ནས་ཤི༌བའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ཨབ་རམ་དང་ནཱ་ཧོར་གཉིས་ཀྱིས་ཆུང་མ་བླངས༌ཤིང༌། ཨབ་རམ་གྱི་ཆུང་མའི་མིང་ལ་སཱ་ར་ཡུ་ཞེས་ཟེར་བ༌དང༌། ནཱ་ཧོར་གྱི་ཆུང་མའི་མིང་ལ་མིལ་ཀཱ་ཞེས་འབོད༌དོ། །ཁོ་མོ་ནི་ཧཱ་རན་གྱི་བུ་མོ་ཡིན་ཞིང་ཧཱ་རན་ནི་མིལ་ཀཱ་དང་ཡེས་ཀཱ་ཞེས་བྱ་བའི་ཕ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","སཱ་ར་ཡུ་ནི་མོ་གཤམ་ཡིན་པས་བུ་མ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","དེ་ནས་ཐ་རཱ་ཡིས་རང་གི་བུ་ཨབ་རམ་དང་རང་གི་ཚ་བོ་སྟེ་ཧཱ་རན་གྱི་བུ་ལོད་ཐུ༌དང༌། གཞན༌ཡང༌། བུ་ཨབ་རམ་གྱི་ཆུང་མ་སཱ་ར་ཡུ་བཅས་ཁྲིད༌དེ། ཀལ་དི་ཡུལ་དུ་ཡོད་པའི་ཨུར་ནས་ཀ་ན་ཨན་ཡུལ་དུ་འགྲོ་བའི་ལམ་ལ༌ཆས། འོན་ཀྱང་ཁོ་རྣམས་ཧཱ་རན་གྲོང་ཁྱེར་དུ་ཕྱིན་ཏེ་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ཐ་རཱ་བསྡོམས་པས་ལོ་ཉིས་བརྒྱ་དང་ལྔ་ལ་བཞུགས་ཏེ་ཧཱ་རན་གྲོང་ཁྱེར་དུ་ཚེ་ལས་འདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ནི་རང་གི་ཕ་ཡུལ་དང་ཉེ༌འབྲེལ། ཕ་གཞིས་བཅས་དང་ཁ་བྲལ་ནས་བདག་གིས་ཁྱོད་ལ་སྟོན་པར་འགྱུར་བའི་ཡུལ་དེར་སོང༌ཞིག ");
INSERT INTO bodn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","བདག་གིས་ཁྱོད་རྒྱལ་ཁབ་ཆེན་པོར་འགྱུར་བར་བྱེད་པ༌དང༌། བདག་གིས་ཁྱོད་ལ་བྱིན་གྱིས་བརླབས་ཏེ་ཁྱོད་སྙན་གྲགས་དང་ལྡན་པར་བྱེད༌པས། ཁྱོད་ཀྱིས་ཀྱང་མི་གཞན་ལ་བདེ་སྐྱིད་བསྐྲུན་ངེས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ཁྱོད་ལ་བདེ་བ་སྐྲུན་མཁན་གང་ཞིག་ལ་བདག་གིས་ཀྱང་བྱིན་རླབས་གནང་བར༌བྱའོ། །ཁྱོད་ལ་སྡིགས་དམོད་བྱེད་མཁན་གང་ཞིག་ལ་བདག་གིས་ཀྱང་སྡིགས་དམོད༌བྱའོ། །ཡང་ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལ་ཁྱོད་རང་བརྒྱུད་ནས་བྱིན་རླབས་འཐོབ་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","དེ་ནས་ཨབ་རམ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ལྟར་ཕར་ཕྱིན༌ཅིང༌། ལོད་ཐུའང་ཨབ་རམ་དང་མཉམ་དུ་སོང༌ངོ༌། །ཨབ་རམ་ཞེས་བྱ་བ་ཧཱ་རན་གྲོང་ཁྱེར་ནས་འགྲོ་དུས་དགུང་ལོ་བདུན་ཅུ་དོན་ལྔ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ཨབ་རམ་གྱིས་ཁོང་གི་ཆུང་མ་སཱ་ར་ཡུ་དང་ཚ་བོ་ལོད་ཐུ་ཁྲིད༌དེ། ཁོ་རྣམས་ཀྱིས་ཧཱ་རན་དུ་བསགས་པའི་རྒྱུ་ནོར་ཁྱེར་ནས་མི་རྣམས་དང་བཅས་པ་ཀ་ན་ཨན་ཡུལ་དུ་ཆས་ཤིང་དེ་རུ་སླེབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ཨབ་རམ་ཡུལ་དེ་བརྒྱུད་ནས་སི་ཀེམ་ཡུལ་གྱི་མོར་རེའེ་ཡི་བེ་ཤིང་རྩར་སླེབས་པ༌དང༌། དུས་དེར་ཀ་ན་ཨན་གྱི་མི་རྣམས་ཀྱང་ཡུལ་དེར་བསྡད་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་མངོན་པར་མཛད་དེ་འདི་སྐད༌དུ། བདག་གིས་ཡུལ་འདི་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་སྦྱིན་པར་བྱའོ་ཞེས་གསུངས༌པས། ཨབ་རམ་གྱིས་ཡུལ་དེ་ནས་རང་ལ་མངོན་པར་མཛད་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་ཁྲི་ཞིག༌བཞེངས། ");
INSERT INTO bodn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ཡང་ཨབ་རམ་ཡུལ་དེ་ནས་པེད་ཨེལ་གྱི་ཤར་ཕྱོགས་སུ་ཡོད་པའི་རི་བོའི་གནས་སུ་སྤར་ཏེ་སྦྲ་གུར་ཕུབ་པར་མཛད༌དོ། །ཡུལ་དེའི་ནུབ་ཕྱོགས་ནི་པེད་ཨེལ་དང་ཤར་ཕྱོགས་ནི་ཨེ་ཡུ་གཉིས༌སོ། །ཡང་ཁོང་གིས་ཡུལ་དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་ཁྲི་ཞིག་བཞེངས་ཏེ་ཁོང་གི་མཚན་ལ་ཞུ་བ༌ཞུས། ");
INSERT INTO bodn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ཕྱིས་སུ་ཨབ་རམ་ཡང་རིམ་གྱིས་ནེ་གུབ་ཡུལ་ཕྱོགས་སུ་གནས་སྤར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","དེ་ཡང་ཀ་ན་ཨན་ཡུལ་དུ་མུ་གེ་ཤིན་ཏུ་ཆེན་པོ་བྱུང༌བས། ཨབ་རམ་འཁོར་དང་བཅས་པ་གནས་སྐབས་སུ་སྡོད་པའི་ཕྱིར་མར་ཨེ་ཅིབ་ཡུལ་དུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ཨེ་ཅིབ་ཡུལ་དུ་སླེབས་ལ་ཉེ་བ༌ན། ཁོས་རང་གི་ཆུང་མ་སཱ་ར་ཡུ་ལ་འདི༌ལྟར། ཉོན༌དང༌། བདག་གིས་ཁྱོད་ནི་མཛེས་ཤིང་སྡུག་པའི་བུད་མེད་ཅིག་ཡིན་པ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ཀྱིས་ཁྱོད་རང་མཐོང་བ༌ན། འདི་ནི་ཁོའི་ཆུང་མ་ཡིན་ཞེས་སྨྲ་ངེས༌ཤིང༌། དེ་དག་གིས་ང་རང་གསོད་པར་འགྱུར་ཡང་ཁྱོད་ནི་གསོན་པར་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","དེའི༌ཕྱིར། ཁྱོད་ནི་བདག་གི་སྲིང་མོ་ཡིན་ཞེས་སྨྲ་བར༌མཛོད། ཅིའི་ཕྱིར་ཞེ༌ན། ང་རང་ཁྱོད་ལ་བརྟེན་ནས་བདེ་བར་གནས༌ཤིང༌། ངའི་ཚེ་སྲོག་ཀྱང་ཁྱོད་ལ་བརྟེན་ནས་གསོན་ཐུབ་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","དེ་ནས་ཨབ་རམ་འཁོར་དང་བཅས་པ་ཨེ་ཅིབ་ཡུལ་དུ་སླེབས་པ༌དང༌། ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ཀྱིས་བུད་མེད་དེ་ཤིན་ཏུ་མཛེས་པར་མཐོང༌ཞིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","རྒྱལ་པོ་ཕཱར་ཨོལ་གྱི་བློན་ཆེན་རྣམས་ཀྱིས་བུད་མེད་མཛེས་མ་དེ་མཐོང་ཞིང་ཁོའི་མདུན་དུ་བསྟོད་བསྔགས་བྱས༌པས། བུད་མེད་དེའང་རྒྱལ་པོའི་ཕོ་བྲང་དུ་ཁྲིད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","རྒྱལ་པོས་བུད་མེད་དེའི་དབང་གིས་ཨབ་རམ་ལ་སྣེ་ལེན་རྒྱ་ཆེན་པོ་མཛད༌ཅིང༌། ཁོང་ལ་ར་ལུག༌དང༌། བ༌གླང༌། རྔ༌མོང༌། བོང༌གསེབ། བོང༌མ། གཡོག་པོ་དང་གཡོག་མོ་རྣམས་ཀྱང་ཐོབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་གྱི་ཆུང་མ་སཱ་ར་ཡུའི་དོན་རྐྱེན་གྱི་དབང་གིས་ཕཱར་ཨོལ་དང་ཁོའི་ཁྱིམ་མི་ཡོངས་ལ་སྡུག་བསྔལ་ཆེན་པོ་ཕོག་པར་མཛད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ཕཱར་ཨོལ་གྱིས་ཨབ་རམ་བོས་ཏེ་ན༌རེ། ཁྱོད་ཀྱིས་བདག་ལ་ཅི་བྱས༌སམ། བུད་མེད་དེ་ཁྱོད་ཀྱི་ཆུང་མ་ཡིན་ཞེས་མི་སྨྲ་བའི་རྒྱུ་མཚན༌ཅི། ");
INSERT INTO bodn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","བུད་མེད་དེ་ཁྱོད་ཀྱི་སྲིང་མོ་ཡིན་ཞེས་སྨྲས༌ཏེ། ཁོ་མོ་བདག་གི་ཆུང་མར་ལེན་དུ་འཇུག་དོན༌ཅི། ད་ལྟ་ཁྱོད་ཀྱི་ཆུང་མ་འདི་རུ་ཡོད་པས་ཁྱོད་ཀྱིས་ཕྱིར་ཁྲིད་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","དེ་ནས་ཕཱར་ཨོལ་གྱིས་རང་གི་མི་རྣམས་ལ་བཀའ་བསྒོས༌ཏེ། ཨབ་རམ་དང་ཁོའི་ཆུང༌མ། ད་དུང་ཁོ་ལ་དབང་བ་ཐམས་ཅད་ཀྱང་ཕྱིར་བསྐྱལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","དེ་ནས་ཨབ་རམ་གྱིས་ཁོའི་ཆུང་མ་དང་ལོད་ཐུ༌དང༌། རང་ལ་དབང་བ་ཐམས་ཅད་ཁྱེར༌ཏེ། ཨེ་ཅིབ་ཡུལ་ནས་ཡར་ནེ་གུབ་ཡུལ་དུ་ཕྱིན་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ཨབ་རམ་ལ་གསེར་དང་དངུལ་དང་ཕྱུགས་ཟོག་ཤིན་ཏུ་མང་པོ་མཆིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","དེ་ནས་ཨབ་རམ་དང་བཅས་པ་ནེ་གུབ་ཡུལ་ནས་རིམ་གྱིས་པེད་ཨེལ་གྱི་ཕྱོགས་སུ་སོང༌སྟེ། པེད་ཨེལ་དང་ཨེ་ཡུ་གཉིས་ཀྱི་བར་དུ་སླེབས་སོ། །དེ་ནི་སྔོན་ཆད་ཁོ་རྣམས་ཀྱིས་སྦྲ་གུར་ཕུབ་པའི་གནས་དེ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ཁོང་གིས་ཐོག་མར་མཆོད་ཁྲི་བཞེངས་པའི་གནས་དེའང་ཡིན༌ནོ། །ཁོང་གིས་གནས་དེ་རུ་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ནས་བོས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ཨབ་རམ་དང་མཉམ་དུ་སོང་བའི་ལོད་ཐུ་ལའང་བ་ཁྱུ༌དང༌། ར་ལུག་གི་ཁྱུ༌དང༌། སྦྲ་གུར་བཅས་ལྡན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ཁོ་རྣམས་ལ་རྒྱུ་ནོར་དེ་འདྲ་མང་པོ་ཡོད་པས་ཡུལ་དེར་ཁོ་རྣམས་མ་ཤོང་བ་དང་ལྷན་དུའང་སྡོད་མ་ནུས༌པར། ");
INSERT INTO bodn_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ཨབ་རམ་གྱི་རྫི་བོ་དང་ལོད་ཐུའི་རྫི་བོ་རྣམས་ཀྱི་བར་དུ་འཁྲུག་རྩོད་བྱུང་བ༌རེད། དུས༌དེར། ཀ་ན་ཨན་མི་རིགས་དང་ཕེ་རེ་ཟི་མི་རིགས་ཀྱང་གནས་དེར་བསྡད་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","དེ་ནས་ཨབ་རམ་གྱིས་ལོད་ཐུ་ལ་འདི་སྐད༌དུ། ངེད་གཉིས་འཁྲུག་རྩོད་བྱ་མི་འོས༌ལ། ཁྱོད་ཀྱི་རྫི་བོ་དང་བདག་གི་རྫི་བོ་གཉིས་ཀྱང་རྩོད་མི་འོས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། རང་ཅག་ནི་སྤུན་མཆེད་ཡིན་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ས་གཞི་ཐམས་ཅད་ཁྱོད་ཀྱི་མིག་མདུན་དུ་ཡོད་པ་མ་ཡིན༌ནམ། ཁྱོད་བདག་དང་ཁ་འབྲལ་བར༌གྱིས། ཁྱོད་རང་གཡོན་ཕྱོགས་སུ་སོང༌ན། ང་རང་གཡས་ཕྱོགས་སུ༌འགྲོའོ། །ཁྱོད་རང་གཡས་ཕྱོགས་སུ་སོང༌ན། ང་རང་གཡོན་ཕྱོགས་སུ་འགྲོ་བར་བྱའོ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","དེ་ནས་ལོད་ཐུས་མགོ་ཡར་བཀྱགས་ཏེ་ཡོར་དན་གཙང་པོའི་ཡུལ་འཁོར་ཐམས་ཅད་ལ་བལྟས་པ༌ན། ས་ཆ་ཡོངས་སུ་ཆུ་ཤིན་ཏུ་མང་བ༌མཐོང༌། ཡུལ་དེ་ནི་ཚོ་ཨར་གྱི་བར་དུ་དཀོན་མཆོག་ཡ་ཝཱེས་སཱ་དོམ་དང་གཱ་མོ་ར་གཉིས་འཇོམས་པར་མ་མཛད་སྔོན་གྱི་དཀོན་མཆོག་ཡ་ཝཱེའི་ལྡུམ་ར་དང་འདྲ༌ཞིང༌། ཨེ་ཅིབ་ཀྱི་ཡུལ་དང་མཚུངས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ལོད་ཐུ་ཡིས་ཡོར་དན་གཙང་པོའི་ཡུལ་འཁོར་ཐམས་ཅད་བདམས༌ཏེ། ཤར་ཕྱོགས་སུ་གནས་སྤར་བ་དང་ཁོ་རྣམས་ཕན་ཚུན་ཁ་གྱེས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","དེ་ནས་ཨབ་རམ་ཞེས་བྱ་བ་ཀ་ན་ཨན་ཡུལ་དུ་བསྡད་པ༌དང༌། ལོད་ཐུ་ཡུལ་འཁོར་གྱི་གྲོང་ཁྱེར་རྣམས་སུ་བསྡད༌ཅིང༌། ཡང་རིམ་གྱིས་སྦྲ་གུར་རྣམས་སཱ་དོམ་བར་དུ་གནས་སྤར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","དེ་ཡང་སཱ་དོམ་གྱི་མི་རྣམས་ངན་པ་ཤ་སྟག་ཡིན༌ཞིང༌། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་སྡིག་པ་ཚབས་ཆེན་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","དེ་ནས་ལོད་ཐུ་ཞེས་བྱ་བ་ཨབ་རམ་དང་ཁ་གྱེས༌རྗེས། དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་རང་གི་གནས་ཡུལ་ནས་མགོ་ཡར་བཀྱགས་ཏེ་ཤར་ལྷོ་ནུབ་བྱང་གི་ཕྱོགས་སུ་ལྟོས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ཁྱོད་ཀྱི་མིག་གིས་མཐོང་ཚད་ཐམས་ཅད་བདག་གིས་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྒྱུད་ལ་གཏན་དུ་སྦྱིན་པར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","བདག་གིས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་རྡུལ་གྲངས་དང་མཉམ་པར་བྱ་ངེས༌ཡིན། སུ་ཞིག་གིས་ས་ཡི་རྡུལ་གྲངས་ལ་རྩིས་ལེན་ཐུབ༌ན། ད་གཟོད་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ལའང་རྩིས་ལེན་ནུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ཁྱོད་ཡར་ལོངས༌དང༌། ཡུལ་འདིའི་ཕྱོགས་ཀུན་ལ་སོང༌ཞིག རྒྱུ་མཚན་ནི་བདག་གིས་ས་འདི་ཁྱོད་ལ་སྦྱིན་ངེས་ཡིན་པའི་ཕྱིར་རོ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","དེ་ནས་ཨབ་རམ་གྱིས་རང་གི་སྦྲ་གུར་གནས་སྤར༌ཞིང༌། ཧེབ་རོན་གྱི་མཱན་རེའེ་ཞེས་བྱ་བའི་བེ་ཤིང་སྐྱེད་ཚལ་གྱི་ཉེ་འགྲམ་དུ་བསྡད་པ་དང་། གནས་དེ་རུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་ཁྲི་ཞིག་བཞེངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","དེ་ཡང་ཤིན་ཨར་ཡུལ་གྱི་རྒྱལ་པོ་ཨམ་རཱ་ཕིལ༌དང༌། ཨེལ་ལ་སཱར་ཡུལ་གྱི་རྒྱལ་པོ་ཨར༌ཡོག ཨེ་ལཱམ་ཡུལ་གྱི་རྒྱལ་པོ་ཀཱ་དོར་ལཱ་ཨོ༌མེར། གོ་ཡེམ་ཡུལ་གྱི་རྒྱལ་པོ་ཐིད་ཨལ་བཅས་ཀྱི་དུས༌སུ། ");
INSERT INTO bodn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","རྒྱལ་པོ་འདི་བཞི་པོས་སཱ་དོམ་གྱི་རྒྱལ་པོ་པེ་རཱ༌དང༌། གཱ་མོ་ར་ཡི་རྒྱལ་པོ་པེར༌ཤཱ། ཨད་མཱ་ཡི་རྒྱལ་པོ་ཤིན༌ཨབ། ཚཱ་བོ་ཡིམ་གྱི་རྒྱལ་པོ་ཤེམ་ཨེ༌བེར། པེ་ལཱ་༼དེང་སང་ཚོ་ཨར་ཞེས་ཀྱང་བྱ།༽ཡི་རྒྱལ་པོ་དང་བཅས་པར་དམག་དྲངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","དེ་ནས་རྒྱལ་པོ་དེ་རྣམས་སིད་དིམ་ལུང་པར་གཅིག་ཏུ༌འདུས། ལུང་པ་དེ་ནི་ཚྭ་མཚོ༌དེའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","དེ་སྔར་དེ་དག་ཀཱ་དོར་ལཱ་ཨོ་མེར་གྱི་མངའ་འོག་ཏུ་ལོ་བཅུ་གཉིས་རིང་ལ་བསྡད་ཅིང་ལོ་བཅུ་གསུམ་པར་ངོ་ལོག༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","དེ་ཡང་ལོ་བཅུ་བཞི༌པར། ཀཱ་དོར་ལཱ་ཨོ་མེར་གྱི་མནའ་འབྲེལ་རྒྱལ་པོ་ཐམས་ཅད་ཨ་ཤ་ཐ་རོད་ཀར་ནཱ་ཡེམ་ཞེས་པའི་ཡུལ་དུ་འོངས༌ཏེ། རེ་པཱ་མི་རིགས༌དང༌། ཧཱམ་ཞེས་པའི་ཡུལ་གྱི་ཟུ་ཟ་མི༌རིགས། ཤཱ་ཝེ་ཀིར་ཡ་ཐཱ་ཡེམ་ཡུལ་གྱི་ཨེ་མཱ་མི༌རིགས། ");
INSERT INTO bodn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","དབེན་སྟོང་གི་འགྲམ་དུ་ཡོད་པའི་ཨེལ་ཕཱ་རན་ཡུལ་ནས་སེ་ཨིར་རི་བོའི་བར་དུ་གནས་པའི་ཧོར་མི་རིགས་བཅས་ལ་དམག་དྲངས་ཤིང་དེ་ལས་རྣམ་པར་རྒྱལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","དེ་ནས་ཁོ་རྣམས་ཕྱིར་ལོག་པའི་ལམ་བར་དུ་ཨིན་མུས་ཕཱད་ཅེས་པ་སྟེ་ཀཱ་དེའེ་ཤཱ་ཡུལ་དུ་སོང༌སྟེ། ཨ་མཱད་ལེག་མི་རིགས་ཀྱི་ཡུལ་ཐམས་ཅད༌དང༌། ཧ་ཚོན་ཐལ་མཱར་ཡུལ་དུ་གནས་པའི་ཨེ་མོར་མི་རིགས་བཅས་ལ་དམག་དྲངས་ཤིང་དེ་ལས་རྣམ་པར་རྒྱལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","དེ་ནས་སཱ་དོམ༌དང༌། གཱ་མོ༌ར། ཨད༌མཱ། ཚཱ་བོ༌ཡིམ། པེ་ལཱའམ་ཚོ་ཨར་བཅས་ཀྱི་རྒྱལ་པོ་རྣམས་སླེབས་པ༌དང༌། སིད་དིམ་ལུང་པ་ནས་གཡུལ་བཤམས་ཏེ་ཁོ་རྣམས་ལ་གཡུལ་འགྱེད་པ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ཨེ་ལཱམ་གྱི་རྒྱལ་པོ་ཀཱ་དོར་ལཱ་ཨོ་མེར༌དང༌། གོ་ཡེམ་གྱི་རྒྱལ་པོ་ཐིད༌ཨལ། ཤིན་ཨར་གྱི་རྒྱལ་པོ་ཨམ་རཱ་ཕིལ། ཨེལ་ལ་སཱར་གྱི་རྒྱལ་པོ་ཨར་ཡོག་བཅས་ཡིན༌ཞིང༌། རྒྱལ་པོ་བཞི་པོས་རྒྱལ་པོ་ལྔ་པོར་གཡུལ་འགྱེད༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","དེ་ཡང་སིད་དིམ་ལུང་པར་རྒྱ་སྐྱེགས་ཀྱིས་བཀང་བའི་དོང་མང་པོ་ཡོད༌ལ། སཱ་དོམ་གྱི་རྒྱལ་པོ་དང་གཱ་མོ་ར་ཡི་རྒྱལ་པོ་གཉིས་བྲོས་ཏེ་རྒྱ་སྐྱེགས་ཀྱི་དོང་ནང་དུ་ལྷུང་ཞིང་གཞན་རྣམས་རི་ཁྲོད་དུ༌བྲོས། ");
INSERT INTO bodn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","དེ་ནས་རྒྱལ་པོ་བཞི་པོས་སཱ་དོམ་དང་གཱ་མོ་ར་ཡི་རྒྱུ་ནོར་དང་འབྲུ་རིགས་ཐམས་ཅད་ཕྲོགས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ཨབ་རམ་གྱི་ཚ་བོ་ལོད་ཐུ་དང་ཁོའི་རྒྱུ་ནོར་ཡང་ཕྲོགས་ནས་སོང༌། ཅིའི་ཕྱིར་ཞེ༌ན། དུས་དེར་ལོད་ཐུ་ནི་སཱ་དོམ་དུ་བསྡད་ཡོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","དེ་ཡང་ཕྱིར་བྲོས་འོངས་པའི་མི་ཞིག་གིས་ཨིབ་རི་པ་ཨབ་རམ་ལ་གནས་ཚུལ་དེའི་སྐོར༌སྨྲས། ཨབ་རམ་ནི་སྐབས་དེར་ཨེ་མོར་མི་རིགས་ཀྱི་མཱན་རེའེ་ཞེས་བྱ་བའི་བེ་ཤིང་སྐྱེད་ཚལ་གྱི་ཉེ་འགྲམ་དུ་བསྡད་ཡོད༌ཅིང༌། མཱན་རེའེ་བྱ་བ་ནི་ཨེ་ཤ་ཀོལ་དང་ཨ་ནེར་གཉིས་ཀྱི་སྤུན་ཡིན༌ལ། ཁོ་རྣམས་ཀྱིས་ཨབ་རམ་དང་མནའ་འབྲེལ་བྱས་མྱོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","དེ་ནས་ཨབ་རམ་གྱིས་ཁོང་གི་ཚ་བོ་ལོད་ཐུ་བཙན་བཟུང་བྱས་པའི་གནས་ཚུལ་ཐོས༌ཏེ། རང་ཁྱིམ་ནས་ནར་སོན་ཅིང་དམག་རྩལ་སྦྱངས་པའི་ཕོ་རྒོད་སུམ་བརྒྱ་དང་བཅོ་བརྒྱད་ཁྲིད་ནས་དཱན་ཞེས་པའི་ཡུལ་བར་དུ་ར་མདར༌རྒྱུགས། ");
INSERT INTO bodn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","མཚན་མོའི་དུས༌སུ། ཨབ་རམ་གྱིས་རང་ཉིད་དང་དམག་མི་སྡེ་ཚན་བགོས་ནས་དགྲ་བོ་འཇོམས་པར་བྱས་པ༌དང༌། དེ་ནས་ཡང་དཱ་མེ་སེག་གི་བྱང་ཕྱོགས་སུ་ཡོད་པའི་ཧོ་བཱ་ཡུལ་བར་དུ་བདས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","སྔར་ཕྲོགས་ཟིན་པའི་རྒྱུ་ནོར་ཐམས་ཅད་ཕྱིར་བླངས་པར་མ༌ཟད། ད་དུང་ཁོང་གི་ཚ་བོ་ལོད་ཐུ༌དང༌། ཁོའི་རྒྱུ་ནོར་དང་བུད༌མེད། འབངས་མི་ཐམས་ཅད་ཀྱང་ཕྱིར་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","དེ་ཡང་ཨབ་རམ་བྱ་བ་ཀཱ་དོར་ལཱ་ཨོ་མེར་དང་དེའི་མནའ་འབྲེལ་རྒྱལ་པོ་གཞན་རྣམས་ལས་རྣམ་པར་རྒྱལ་ཏེ་ཕྱིར་ལོག་པའི་དུས༌སུ། སཱ་དོམ་གྱི་རྒྱལ་པོ་འོངས་ནས་ཤཱ་ཝེ་ལུང་པ་རུ་ཁོང་ལ་བསུ་བ༌བྱས། ཤཱ་ཝེ་ལུང་པ་ལ་རྒྱལ་པོའི་ལུང་པ་ཞེས་ཀྱང༌ཟེར། ");
INSERT INTO bodn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","དེ་ནས་སཱ་ལེམ་གྱི་རྒྱལ་པོ་མཱལ་ཀི་ཚེ་དེག་གིས་ཀྱང་བག་ལེབ་དང་རྒུན་ཆང་ཁྱེར་ནས་བསུ་བ་བྱེད་དུ༌ཕེབས། ཁོང་ནི་བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་མཆོད་དཔོན་ཞིག་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ཁོང་གིས་ཨབ་རམ་ལ་བྱིན་གྱིས་བརླབས་ཏེ་འདི་སྐད༌དུ། གནམ་ས་གཉིས་ཀྱི་བྱེད་པོ༌དང༌།། བླ་ན་མེད་པའི་དཀོན་མཆོག༌གིས།། ཨབ་རམ་ཁྱོད་ལ་བྱིན་བརླབས༌མཛོད།། ");
INSERT INTO bodn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","དགྲ་བོ་ཐམས་ཅད་ཁྱོད་སྤྲད༌པའི།། བླ་ན་མེད་པའི་དཀོན་མཆོག༌ལ།། བསྟོད་ཅིང་བསྔགས་པར་འོས་སོ༌ལོ། །ཞེས་གསུངས༌སོ།། ཨབ་རམ་གྱིས་རང་ལ་ཐོབ་པའི་བཅུ་ཆ་གཅིག་ནི་མཱལ་ཀི་ཚེ་དེག་ལ་ཕུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","དེ་ནས་སཱ་དོམ་གྱི་རྒྱལ་པོས་ཨབ་རམ་ལ་འདི་ལྟར། ཁྱོད་ཀྱིས་འབངས་མི་རྣམས་བདག་ལ་བྱིན༌དང༌། རྒྱུ་ནོར་རྣམས་ཁྱོད་ཀྱིས་ཁྱེར་ཞིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","དེ་ནས་ཨབ་རམ་གྱིས་སཱ་དོམ་གྱི་རྒྱལ་པོ་ལ་འདི་སྐད༌དུ། བདག་གིས་གནམ་ས་གཉིས་ཀྱི་བྱེད་པོ་སྟེ་བླ་ན་མེད་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་བཅས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ཁྱོད་ལ་གཏོགས་པའི་རྒྱུ་རྫས་ནི་སྐུད་པ་ཞིག༌གམ། ཡང་ན་ལྷམ་མདུད་ཅིག་ཡིན་ཡང་བདག་གིས་མི་འཁྱེར༌རོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ན༌རེ། བདག་གིས་ཨབ་རམ་ཕྱུག་པོར་བཏང་བ་ཡིན་ཞེས་མི་སྨྲ་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","དམག་མི་རྣམས་ཀྱིས་གང་ཞིག་ཟོས་པ༌དང༌། བདག་དང་མཉམ་དུ་ཕྱིན་པའི་ཨ་ནེར༌དང༌། ཨེ་ཤ༌ཀོལ། མཱན་རེའེ་བཅས་ལ་རང་གི་བགོ་སྐལ་འཁྱེར་དུ་འཇུག་པ་ལས༌གཞན། བདག་གིས་ཅི་ཡང་མི་འཁྱེར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","དོན་དེའི་རྗེས༌སུ། ཨབ་རམ་གྱི་ཞལ་གཟིགས་ནང་དུ་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་བབས་ཤིང་ཁོང་ལ་འདི་སྐད༌དུ། ཨབ༌རམ། ཁྱོད་རང་འཇིགས་མི་དགོས༌ཏེ། བདག་ནི་ཁྱོད་ཀྱི་ཕུབ་ཡིན༌ཞིང༌། བདག་གིས་ཁྱོད་ལ་བྱ་དགའ་ཆེན་པོ་ཞིག་སྦྱིན་པར་བྱ་ཞེས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ཨབ་རམ་ན༌རེ། ཀྱེ། གཙོ་བོ་ཡ་ཝཱེ༌ལགས། བདག་ལ་བུ་མེད་པས་ཁྱེད་ཀྱིས་བདག་ལ་ཅི་ཞིག་གནང་བར༌བྱའམ། བདག་གི་ཁྱིམ་རྒྱུད་འཛིན་མཁན་ནི་དཱ་མེ་སེག་གི་ཨེ་ལི་ཨེ་བཟིར་ཡིན་ཞེས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ཡང་ཨབ་རམ་ན༌རེ། ཁྱེད་ཀྱིས་བདག་ལ་བུ་རྒྱུད་མ་གནང༌བས། བདག་གི་ཁྱིམ་དུ་སྐྱེས་པའི་མི་དེ་ནི་བདག་གི་ཁྱིམ་རྒྱུད་འཛིན་མཁན་ཡིན་ནོ་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་བབས་ཏེ་འདི་སྐད༌དུ། མི་དེ་ཁྱོད་ཀྱི་ཁྱིམ་རྒྱུད་འཛིན་མཁན་དུ་མི༌འགྱུར། ཁྱོད་རང་ལས་སྐྱེས་པའི་བུ་ནི་ཁྱོད་ཀྱི་ཁྱིམ་རྒྱུད་འཛིན་མཁན་དུ་འགྱུར་བ་ཡིན་ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","དེ་ནས་ཁོང་གིས་ཨབ་རམ་ཕྱི་རོལ་ཏུ་ཁྲིད་དེ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ནམ་མཁར་ལྟོས༌དང༌། ནམ་མཁའི་སྐར་མ་ཐམས་ཅད་བརྩི་ནུས༌སམ། བརྩི་ནུས་ན་རྩིས་ཤིག་ཅེས༌དང༌། ཡང་ཁོང་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཀྱང་དེ་བཞིན་དུ་འབྱུང་བར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","དེ་ནས་ཨབ་རམ་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དད་པ་བྱས་ཤིང་དཀོན་མཆོག་ཡ་ཝཱེས་ཀྱང་ཁོང་ནི་མི་རྣམ་དག་ཏུ་བརྩིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་འདི་སྐད༌དུ། བདག་ནི་ཡ་ཝཱེ་ཡིན༌ཏེ། བདག་གིས་ཀ་ན་ཨན་གྱི་ཡུལ་འདི་ཁྱོད་ལ་བགོ་སྐལ་དུ་སྦྱིན་པའི༌ཕྱིར། དེ་སྔར་ཁྱོད་རང་ཀལ་དི་ཡུལ་གྱི་ཨུར་ནས་ཁྲིད་ཡོང་བ་ཡིན་ཞེས་གསུངས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ཨབ་རམ་ན༌རེ། ཀྱེ། གཙོ་བོ་ཡ་ཝཱེ༌ལགས། ངས་ཡུལ་འདི་བདག་གི་བགོ་སྐལ་ཡིན་པ་ཅི་ལྟར་ཤེས་ནུས་སམ་ཞེས་ཞུས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་བ་དྲུས་མ༌དང༌། ར༌མ། ལུག་ཐུག་བཅས་ལོ་གསུམ་ཅན་གཅིག་རེ༌དང༌། གཞན༌ཡང༌། བྱ་ཐི་བ་དང་ཕུག་རོན་ཆུང་ངུ་གཅིག་རེ་བདག་གི་མདུན་དུ་ཁྱེར་ཤོག་ཅེས་གསུངས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ཨབ་རམ་གྱིས་ཀྱང་དེ་ལྟར་ཁྱེར་ཡོང་བ༌དང༌། དེ་དག་རེ་རེ་བཞིན་དུམ་བུ་གཉིས་སུ་བགོས་ཤིང་དུམ་བུ་རེ་རེ་བཞིན་བཤམས་ནས༌བཞག འོན༌ཀྱང༌། བྱ་ཐི་བ་དང་ཕུག་རོན་ཆུང་ངུ་གཉིས་དུམ་བུར་མ་བགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","དེ་ནས་བྱ་རྒོད་རྣམས་འཕུར་འོངས་ནས་ཕྱུགས་ཟོག་གི་ཤ་སྟེང་དུ་བབས་པས་ཨབ་རམ་གྱིས་དེ་རྣམས་བདས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","དེ་ཡང་ཉི་མ་ནུབ་པའི་དུས༌སུ། ཨབ་རམ་ལ་གཉིད་ལྕི་མོ་ཁུགས་པ་དང་འཇིགས་སུ་རུང་བའི་མུན་ནག་ཆེན་པོ་ཁོང་གི་ལུས་ལ་ཁྱབ་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ངེས་པར་ཤེས་དགོས་པ༌ནི། ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་མི་རིགས་གཞན་གྱི་ཡུལ་དུ་སྡོད་པར་བྱེད༌ཅིང༌། ཁོ་རྣམས་ཀྱིས་ལོ་འཁོར་བཞི་བརྒྱའི་རིང་ལ་ཡུལ་དེའི་མི་རྣམས་ལ་གཡོག་བྱེད་པ་དང་དེ་དག་གི་གཉའ་གནོན་མྱང་བར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","དེ་ནས་ཁོ་རྣམས་ཀྱིས་གཡོག་བྱེད་པའི་རྒྱལ་ཁབ་དེ་ལ་བདག་གིས་ཉེས་ཆད་གཅོད་པར་འགྱུར༌ཞིང༌། དེའི་རྗེས༌སུ། ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་ཀྱིས་ཡུལ་དེ་ནས་རྒྱུ་ནོར་མང་པོ་ཁྱེར་ནས་ཡུལ་དེ་དང་ཁ་འབྲལ་བར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","འོན༌ཀྱང༌། ཁྱོད་ནི་ཚེ་རིང་བར་འགྱུར༌ཞིང༌། མཇུག་མཐར་བདེ་བའི་ངང་ཕ་མེས་ཡང་མེས་རྣམས་ཀྱི་གམ་དུ་འགྲོ་བ་དང་དུར་ལ་འཇུག་པར་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","དེ་ནས་མི་རབས་བཞི༌པར། ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་ཕྱིར་ཡུལ་འདིར་འབྱོན་ངེས༌ཏེ། ཨེ་མོར་མི་རིགས་ཀྱི་ནག་ཉེས་ད་དུང་ལོངས་མེད་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","དེ་ནས་ཉི་མ་ནུབ་ནས་མུན་རུབ་པ༌ན། གློ་བུར༌ཉིད་དུ། དུ་བ་འཕྱུར་བའི་ཐབ་ཀ་དང་དམར་ལམ་ལམ་བྱེད་པའི་དཔལ་འབར་དེ་གཉིས་ནི་ཕྱུགས་ཟོག་གི་ཤ་རྣམས་ཀྱི་བར་བརྒྱུད་ནས་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ཉིན་དེ༌ལ། དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་རམ་ལ་ཞལ་ཆད་བཞག་སྟེ་འདི་སྐད༌དུ། བདག་གིས་ཨེ་ཅིབ་ཀྱི་ཆུ་བོ་ནས་ཕི་རཱད་ཆུ་བོའི་བར་གྱི་ས་ཆ་འདི་དག་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ལ་སྤྲད་ཟིན༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","དེའང་ས་ཆ་དེ་དག་གི་ད་ལྟའི་བདག་པོ་ནི་ཀེ་ནེ་མི་རིགས༌དང༌། ཀ་ནེ་ཟི་མི༌རིགས། ཀད་མོན་མི༌རིགས། ");
INSERT INTO bodn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ཧེད་མི༌རིགས། ཕེ་རེ་ཟི་མི༌རིགས། རེ་པཱ་མི༌རིགས། ");
INSERT INTO bodn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ཨེ་མོར་མི༌རིགས། ཀ་ན་ཨན་མི༌རིགས། གིར་གས་མི༌རིགས། ཡེ་བུ་སི་མི་རིགས་བཅས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","དེ་ཡང་ཨབ་རམ་གྱི་ཆུང་མ་སཱ་ར་ཡུ་ལ་བུ་དང་བུ་མོ་མ་སྐྱེས༌ཤིང༌། ཁོ་མོར་ཧ་གར་ཞེས་པའི་གཡོག་མོ་ཞིག་ཡོད༌ལ། ཁོ་མོ་ནི་ཨེ་ཅིབ་ཀྱི་མི༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","དེ་ནས་སཱ་ར་ཡུ་ཡིས་ཨབ་རམ་ལ་འདི༌ལྟར། ལྟོས༌དང༌། དཀོན་མཆོག་ཡ་ཝཱེས་བདག་ལ་བུ་ཕྲུག་མི་སྐྱེ་བར་མཛད༌པས། ཁྱོད་བདག་གི་གཡོག་མོ་དང་ལུས་འབྲེལ་བྱེད་པར༌ཞུ། ཁོ་མོར་བརྟེན་ནས་བདག་ལ་བུ་ཕྲུག་ཡོད་ཀྱང་སྲིད་ཅེས་སྨྲས༌ཤིང༌། ཨབ་རམ་གྱིས་ཀྱང་སཱ་ར་ཡུའི་གཏམ་ལ་མཉན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","དེ་ཡང་ཨབ་རམ་ནི་ཀ་ན་ཨན་ཡུལ་དུ་ལོ་བཅུར་བསྡད་པའི་རྗེས༌སུ། ཨབ་རམ་གྱི་ཆུང་མ་སཱ་ར་ཡུ་ཡིས་ཨེ་ཅིབ་ཀྱི་གཡོག་མོ་ཧ་གར་ཞེས་པ་རང་གི་ཁྱོ་ག་ལ་ཆུན་མར་ལེན་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","དེ་ནས་ཨབ་རམ་དང་ཧ་གར་གཉིས་ལུས་འབྲེལ་བྱས་པས་ཧ་གར་ལ་མངལ་ཆགས་པ༌དང༌། ཧ་གར་གྱིས་རང་ལ་མངལ་སྦྲུམ་པ་ཤེས༌རྗེས། རང་གི་བདག་མོར་མཐོང་ཆུང་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","སཱ་ར་ཡུ་ཡིས་ཨབ་རམ་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ཁྱོད་ཀྱི་རྐྱེན་གྱིས་བདག་ལ་མ་ཉེས་ཁག་གཡོགས་ཐེབས་པ༌སྟེ། བདག་གིས་རང་གི་གཡོག་མོ་ཁྱོད་ཀྱི་པང་ཁར་གཏད༌ཅིང༌། ཁོ་མོས་རང་ལ་མངལ་སྦྲུམ་པ་ཤེས་རྗེས་ང་ལ་མཐོང་ཆུང་བྱེད༌དོ། །ཀྱེ། དཀོན་མཆོག་ཡ་ཝཱེས་ངེད་གཉིས་བར་དུ་ལེགས་ཉེས་ཀྱི་ཤན་འབྱེད་པར་སྨོན་ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","དེ་ནས་ཨབ་རམ་གྱིས་སཱ་ར་ཡུ་ལ་འདི་སྐད༌དུ། གཡོག་མོ་ནི་ཁྱོད་ཀྱི་དབང་འོག་ཏུ་ཡོད༌པས། ཁྱོད་ཀྱིས་ཁོ་མོར་ཇི་ལྟར་བྱས་ཀྱང་རུང་ཞེས་སྨྲས༌སོ། །དེ་ནས་སཱ་ར་ཡུ་ཡིས་ཧ་གར་ལ་མནར་གཅོད་བྱས་པས་ཧ་གར་ཁོ་མོའི་མདུན་ནས་བྲོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་དབེན་སྟོང་གི་ཆུ་མིག་དྲུང་དུ་གཡོག་མོ་ཧ་གར་དང་ཕྲད་ཅིང༌། དབེན་སྟོང་དེ་ནི་ཤུར་ཞེས་པའི་ཡུལ་གྱི་ལམ་བར་དུ་ཡོད་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","དེ་ནས་ཕོ་ཉས་འདི་སྐད༌དུ། སཱ་ར་ཡུའི་གཡོག་མོ་ཧ་གར་ཁྱོད་གང་ནས་འོངས་པ་དང་གང་དུ་འགྲོའམ་ཞེས་དྲིས་པ༌ལ། ཧ་གར་ན༌རེ། ང་ནི་རང་གི་བདག་མོ་སཱ་ར་ཡུའི་མདུན་ནས་བྲོས་ཡོང་བ་ཡིན་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉས་ཁོ་མོ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཕྱིར་རང་གི་བདག་མོའི་དྲུང་དུ་སོང་སྟེ་ཁོ་མོའི་དབང་འོག་ཏུ་སྡོད་ཅིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ཡང་འདི་སྐད༌དུ། བདག་གིས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་མང་དུ་སྤེལ་ནས་བགྲང་གིས་མི་ལང་བར་བྱའོ་ཞེས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ཡང་འདི་སྐད༌དུ། ལྟོས་དང་ཁྱོད་ཀྱི་མངལ་དུ་སྦྲུམ་པར་བུ་སྐྱེས༌ཏེ།། ཡ་ཝཱེས་ཁྱོད་ཀྱི་སྐྱོ་སྡུག་རྟོགས་པའི་རྐྱེན་གྱིས༌ནི།། བུ་ཡི་མིང་ལ་ཡེས་མ་ཨེལ་ཞེས་འདོགས་པར༌གྱིས།། ");
INSERT INTO bodn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","བུ་དེ་ངེས་པར་བོང་བུ་ཇི་བཞིན་ཨུ་ཚུགས༌ཀྱིས།། མི་རྣམས་ཀུན་ལ་དགག་ཅིང་རྒོལ་བར་འགྱུར་བ༌དང༌།། མི་རྣམས་ཀྱིས་ཀྱང་བུ་དེར་དགག་ཅིང་རྒོལ་བར༌འགྱུར།། བུ་དེ་རང་གི་སྤུན་ཟླའི་ཤར་དུ་སྡོད་པར༌འགྱུར། །ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","དེ་ནས་ཧ་གར་གྱིས་རང་ལ་བཀའ་གསུང་མཁན་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ལ་ཁྱེད་ནི་ང་རང་གཟིགས་པའི་དཀོན་མཆོག་ཡིན་ཞེས་བཏགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། དེ་སྔར་ཁོ་མོ་ན༌རེ། ངས་གནས་འདི་རུ་ང་རང་མཐོང་བའི་དཀོན་མཆོག་མཇལ་ནུས་སམ་ཞེས་སྨྲས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","དེ་བས་ཆུ་མིག་དེའི་མིང་ལ་པེར་ལཱ་ཧེད་རོའུ་ཞེས་བཏགས་ཤིང་དེ་ནི་ཀཱ་དེའེ་ཤཱ་དང་པེ་རཱད་ཅེས་པའི་ཡུལ་གཉིས་བར་དུ་མཆིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ཕྱིས་སུ་ཧ་གར་གྱིས་ཨབ་རམ་ལ་བུ་ཞིག་བཙས༌ཤིང༌། ཨབ་རམ་གྱིས་བུའི་མིང་ལ་ཡེས་མ་ཨེལ་ཞེས༌བཏགས། ");
INSERT INTO bodn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ཧ་གར་གྱིས་ཨབ་རམ་ལ་བུ་ཡེས་མ་ཨེལ་བཙའ་བའི་དུས༌སུ། ཨབ་རམ་དགུང་ལོ་གྱ་དྲུག་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","དེ་ཡང་ཨབ་རམ་དགུང་ལོ་དགུ་བཅུ་གོ་དགུ་ལོན་པའི་དུས༌སུ། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོང་ལ་མངོན་པར་མཛད་དེ་འདི་སྐད༌དུ། བདག་ནི་ཀུན་དབང་དཀོན་མཆོག་ཡིན༌ལ། ཁྱོད་ཀྱིས་བདག་གི་དྲུང་དུ་མི་རྣམ་དག་གི་སྤྱོད་པ་ཟུངས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","བདག་གིས་ཁྱོད་དང་ཁ་ཆད་བཞག༌ནས། ཁྱོད་ཀྱི་རིགས་རྒྱུད་དར་ཞིང་རྒྱས་པར་བྱའོ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","དེ་ནས་ཨབ་རམ་གྱིས་ཕྱག་བཙལ་ནས་བསྡད་པ༌ལ། ཡང་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","བདག་གིས་ཁྱོད་ལ་ཁ་ཆད་འཇོག༌སྟེ། ཁྱོད་ནི་མི་རིགས་མང་པོ་ཞིག་གི་མེས་པོར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ད་ནས་བཟུང་ཁྱོད་ཀྱི་མིང་ལ་ཨབ་རམ་མི་ཟེར་བར་ཨབ་ར་ཧམ་ཞེས་འབོད་པར་བྱ༌སྟེ། བདག་གིས་ཁྱོད་མི་རིགས་མང་པོའི་མེས་པོར་བྱེད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","བདག་གིས་ངེས་པར་ཁྱོད་ཀྱི་རིགས་རྒྱུད་དར་ཞིང་རྒྱས་པ༌དང༌། ཁྱོད་ལས་མི་རིགས་མང་པོ་འབྱུང་བ༌དང༌། ཁྱོད་ལས་རྒྱལ་པོ་འབྱུང་བར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","བདག་གིས་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་ཐམས་ཅད་ལ་དུས་གཏན་གྱི་ཁ་ཆད་འཇོག་པར་བྱ༌སྟེ། བདག་ནི་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ཀྱི་དཀོན་མཆོག༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","བདག་གིས་ད་ལྟ་ཁྱོད་རང་སྡོད་པའི་ཡུལ་ཏེ་ཀ་ན་ཨན་གྱི་ས་ཆ་ཐམས་ཅད་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་སྦྱིན་པ༌དང༌། ཁྱོད་རྣམས་རྟག་ཏུ་ཡུལ་འདིའི་བདག་པོར་བྱེད་ཅིང་བདག་ནི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ཀྱི་དཀོན་མཆོག་ཀྱང་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ཡང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་ཐམས་ཅད་ཀྱིས་དུས་ནམ་ཡང་བདག་གི་ཁ་ཆད་བསྲུང་དགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ཁྱོད་རྣམས་ལས་ཕོ་ཐམས་ཅད་ཀྱི་མཚན་སྐྱི་གཅོད་པར༌གྱིས། འདི་ནི་བདག་དང༌ཁྱོད། ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་བར་གྱི་ཁ་ཆད་ཡིན༌ལ། ཁྱོད་རྣམས་ཀྱིས་བསྲུང་བར་བྱ༌འོས། ");
INSERT INTO bodn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ཁྱོད་ཅག་ཐམས་ཅད་ཀྱི་མཚན་སྐྱི་གཅོད་དགོས༌ཏེ། འདི་ནི་བདག་དང་ཁྱོད་རྣམས་བར་གྱི་ཁ་ཆད་ཀྱི་རྟགས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ཁྱོད་ཅག་སྐྱེས་པ་ཐམས་ཅད་ནི་རང་ཁྱིམ་ནས་སྐྱེས༌པའམ། ཡང་ན་ཁྱོད་ཀྱི་རིགས་རྒྱུད་མ་ཡིན་པའི་ཕྱི་ཕྱོགས་པ་ལས་དངུལ་གྱིས་ཉོས་པ་གང་ཡིན༌ཡང༌། ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་ཐམས་ཅད་ཀྱིས་བུ་སྐྱེས་ནས་ཉིན་བརྒྱད་པར་མཚན་སྐྱི་གཅོད༌དགོས། ");
INSERT INTO bodn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ཁྱོད་ཀྱི་ཁྱིམ་ནས་སྐྱེས་པའམ་ཁྱོད་ཀྱིས་དངུལ་སྤྲད་ནས་ཉོས་པ་གང་ཡིན་ཡང་ཐམས་ཅད་ཀྱི་མཚན་སྐྱི་གཅོད་དགོས༌སོ། །འདི་ལྟར་བྱས༌ན། བདག་གི་ཁ་ཆད་ཁྱོད་ཅག་གི་ལུས་སྟེང་དུ་མཆིས་ཤིང་དུས་གཏན་གྱི་ཁ་ཆད་ཡིན་པར་བསྟན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","འོན༌ཀྱང༌། མཚན་སྐྱི་མ་བཅད་པའི་སྐྱེས་པ་རྣམས་ནི་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ལས་ཕྱིར་ཕུད་པར་བྱ༌སྟེ། དེ་དག་བདག་གི་ཁ་ཆད་དང་འགལ་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","དེ་ནས་ཡང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་ཆུང་མ་སཱ་ར་ཡུའི་མིང་ལ་སཱ་ར་ཡུ་ཞེས་མི་ཟེར་བར་སཱ་ར་ཞེས་འབོད་པར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","བདག་གིས་ཁོ་མོར་བྱིན་རླབས་གནང་བ༌དང༌། ཁོ་མོ་ལས་ཁྱོད་ལ་བུ་ཞིག་སྦྱིན་པར་བྱའོ། །ཡང་བདག་གིས་ཁོ་མོར་བྱིན་རླབས་གནང་བ༌དང༌། ཁོ་མོ་མི་རིགས་མང་པོ་ཞིག་གི་ཡུམ་ཡིན་པར་འགྱུར༌ཞིང༌། འབངས་མི་རྣམས་ཀྱི་རྒྱལ་པོའང་ཁོ་མོ་ལས་འབྱུང་བར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་ཕྱག་བཙལ་ནས་བསྡད༌དེ། ལོ་བརྒྱ་ལོན་པའི་མི་ཞིག་ལ་བུ་འཐོབ་སྲིད༌དམ། སཱ་རའང་ལོ་དགུ་བཅུ་ལོན་པས་བུ་སྐྱེ་སྲིད་དམ་ཞེས་སེམས་ལ་དྲན་ཞིང་དགོད་བྲོ་བར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་དཀོན་མཆོག༌ལ། ཁྱེད་ཀྱི་སྤྱན་སྔར་ཡེས་མ་ཨེལ་འཚོ་བར་གྱུར་ན་ཅི་མ་རུང་ཞེས་ཞུས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ཡང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། དེ་འདྲ་མིན༌ཏེ། ཁྱོད་ཀྱི་ཆུང་མ་སཱ་རས་ཁྱོད་ལ་བུ་ཞིག་བཙའ་བ༌དང༌། ཁྱོད་ཀྱིས་བུའི་མིང་ལ་ཨི་སཱག་ཅེས་འདོགས་པར༌གྱིས། བདག་གིས་ཁོ་དང་ཁོའི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་དུས་གཏན་གྱི་ཁ་ཆད་འཇོག་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","དེ་ཡང་ཡེས་མ་ཨེལ་ལ་མཚོན༌ན། བདག་གིས་ཁྱོད་ཀྱི་ངག་བཞིན་དུ་ཁོ་ལའང་བྱིན་རླབས་གནང་སྟེ་དར་ཞིང་རྒྱས་པ་དང་རིགས་རྒྱུད་མང་དུ་འཕེལ་བར༌བྱའོ། །ཁོ་ལས་ཚོ་དཔོན་བཅུ་གཉིས་འབྱུང་བ་དང་བདག་གིས་ཁོ་རྒྱལ་ཁབ་ཆེན་པོར་འགྱུར་བར་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","སང་ལོའི་དུས་འདི༌ལ། སཱ་རས་ཁྱོད་ལ་བུ་ཨི་སཱག་བཙའ་ཞིང་བདག་གིས་དེ་ལ་ཁ་ཆད་འཇོག་པར་བྱ་ཞེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","དཀོན་མཆོག་ཨབ་ར་ཧམ་དང་ཁ་བྲལ་ནས་ནམ་མཁའི་ཞིང་ཁམས་སུ་འཕགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ཉིན་དེ༌ལ། ཨབ་ར་ཧམ་གྱིས་དཀོན་མཆོག་གི་བཀའ་བསྲུངས་པ༌དང༌། ཁོང་གི་བུ་ཡེས་མ་ཨེལ་དང་རང་ཉིད་ཀྱི་ཁྱིམ་དུ་ཡོད་པའི་སྐྱེས་པ་ཐམས་ཅད༌དེ། ཁྱིམ་ལས་བཙས་པའམ་དངུལ་གྱིས་ཉོས་པའི་སྐྱེས་པ་ཐམས་ཅད་ཀྱི་མཚན་སྐྱི་བཅད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","དེ་ཡང་ཨབ་ར་ཧམ་རང་ཉིད་ཀྱི་མཚན་སྐྱི་གཅོད་པའི་དུས༌སུ། ཁོང་ནི་དགུང་ལོ་དགུ་བཅུ་གོ་དགུ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ཁོང་གི་བུ་ཡེས་མ་ཨེལ་གྱི་མཚན་སྐྱི་གཅོད་པའི་དུས༌སུ། བུ་དེ་ལོ་བཅུ་གསུམ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ཉིན་དེ༌ལ། ཨབ་ར་ཧམ་དང་ཁོང་གི་བུ་ཡེས་མ་ཨེལ་གཉིས་མཉམ་དུ་མཚན་སྐྱི་བཅད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","གཞན་ཡང་ཁོང་གི་ཁྱིམ་དུ་ཡོད་པའི་སྐྱེས་པ་ཐམས་ཅད༌དེ། ཁྱིམ་དུ་བཙས་པའམ་ཕྱི་ཕྱོགས་པ་ལས་དངུལ་གྱིས་ཉོས་པའི་སྐྱེས་པ་ཐམས་ཅད་ཀྱི་མཚན་སྐྱིའང་ཁོང་དང་མཉམ་དུ་བཅད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མཱན་རེའེ་ཟེར་བའི་བེ་ཤིང་ཡོད་སར་ཨབ་ར་ཧམ་ལ་མངོན་པར༌མཛད། ཉིན་མོར་ཚ་བ་ཆེ་བའི་སྐབས་དེར་ཨབ་ར་ཧམ་སྦྲ་གུར་གྱི་སྒོ་མདུན་དུ་བསྡད་ཡོད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ཁོང་གིས་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། མདུན་ཕྱོགས་སུ་མི་གསུམ་ཡར་ལངས་ནས་བསྡད་ཡོད་པ༌མཐོང༌། ཁོང་གིས་དེ་མཐོང་བ༌དང༌། སྦྲ་གུར་གྱི་སྒོ་མདུན་ནས་བརྒྱུགས་ཏེ་མི་དེ་རྣམས་བསུ་རུ་སོང་བ་དང་ཕྱག་བཙལ་ནས་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ཇོ་བོ༌ལགས། བདག་ལ་ཁྱེད་ཀྱི་སྤྱན་དྲུང་ནས་ཐུགས་རྗེ་ཐོབ༌ན། ཁྱེད་ནི་རང་གི་ཞབས་ཕྱི་པ་བདག་དང་ཁ་བྲལ་ནས་ཕར་མི་ཕེབས་པར༌ཞུ། ");
INSERT INTO bodn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ངས་ཆུ་ཁྱེར་འོང་ལ་ཁྱེད་རྣམས་ཀྱིས་རྐང་པ་བཀྲུས་རྗེས་ལྗོན་ཤིང་གི་གྲིབ་བསིལ་འོག་ཏུ་ངལ་གསོ༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ཡང་ཁྱེད་རྣམས་ཀྱི་ལུས་ལ་སྟོབས་རྒྱས་པའི༌ཕྱིར། ངས་ཁྱེད་རྣམས་ལ་བག་ལེབ་ཁྱེར་འོང་བར༌བྱའོ། །དེའི་རྗེས་ཁྱེད་རྣམས་ཕར་ཕེབས་པར༌བྱ། ཁྱེད་རྣམས་རང་གི་ཞབས་ཕྱི་པའི་གམ་དུ་ཡོང་ན་འདི་ལྟར་བྱ་འོས་ཞེས་སྨྲས་པ༌དང༌། ཁོང་རྣམས་ཀྱིས་འདི་སྐད༌དུ། དེས་ན་ཁྱོད་ཀྱིས་སྨྲས་པ་བཞིན་དུ་བྱོས་ཤིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","དེ་ནས་ཨབ་ར་ཧམ་བྲེལ་འཚབ་ངང་སྦྲ་གུར་ནང་དུ་སོང་སྟེ་སཱ་ར་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ཀྱིས་ཕྱེ་བཟང་པོ་བྲེ་ གསུམ་བླངས་ཏེ་མྱུར་དུ་བརྫིས་ནས་བག་ལེབ་བཟོ་བར་གྱིས་ཞེས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ཨབ་ར་ཧམ་བ་ཁྱུ་ནང་དུ་བརྒྱུགས་ནས་བ་ཕྲུག་ཤ་ཤེད་ཅན་ཞིག་བཟུང་སྟེ་གཡོག་པོར་སྤྲད་ཅིང་གཡོག་པོས་ཀྱང་མྱུར་དུ་སྟ་གོན་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ཡང་ཨབ་ར་ཧམ་གྱིས་ཞོ་དང་འོ༌མ། སྟ་གོན་བྱས་པའི་བ་ཕྲུག་གི་ཤ་བཅས་ཁྱེར་ཡོང་ནས་ཁོང་རྣམས་ཀྱི་མདུན་དུ་བཤམས༌ཤིང༌། ཁོང་རྣམས་ཀྱིས་ཀྱང་ཞལ་ཟས་བཞེས་པ༌དང༌། ཨབ་ར་ཧམ་རང་ཉིད་ནི་ལྗོན་ཤིང་གི་གྲིབ་བསིལ་འོག་ཏུ་ལངས་ནས་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","དེ་ནས་ཁོང་རྣམས་ཀྱིས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་ཆུང་མ་སཱ་ར་གང་དུ་ཡོད་ཅེས་དྲིས་པ༌ན། ཨབ་ར་ཧམ་ན༌རེ། སྦྲ་གུར་ནང་དུ་ཡོད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","དེ་ནས་ཁོང་རྣམས་ལས་གཅིག་ན༌རེ། སང་ལོའི་དུས་འདི༌ལ། ང་རང་ཕྱིར་ཁྱོད་ཀྱི་ཡུལ་འདིར་འོང་ངེས༌ཤིང༌། ཁྱོད་ཀྱི་ཆུང་མ་སཱ་ར་ལ་བུ་ཞིག་སྐྱེ་བར་འགྱུར་ཞེས་གསུངས་པ༌དང༌། སཱ་རས་ཀྱང་མི་དེའི་ལྟག་རྒྱབ་ཀྱི་སྦྲ་གུར་མདུན་ནས་གཏམ་དེར་ཉན་བཞིན༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","སྐབས་དེར་ཨབ་ར་ཧམ་དང་སཱ་ར་གཉིས་དགུང་ལོ་མཐོ༌ཞིང༌། སཱ་རའི་ཟླ་མཚན་ཡང་ཆད་ཟིན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","སཱ་རའི་སེམས་སུ་ཁོང་དགོད་ཅིག་བྱས༌ཏེ། བདག་ནི་རྒས་ཤིང་ཉམས་པ་དང་ངའི་བདག་པོའང་རྒས་ཟིན༌པས། དོན་ལེགས་པོ་འདི་ལྟ་བུ་འབྱུང་སྲིད་དམ་སྙམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། སཱ་རས་ཅིའི་ཕྱིར་ཁོང་དགོད་བྱས༌ཏེ། བདག་ནི་རྒས་འཁོགས་རྒན་མོར་གྱུར་པ་ལ་བུ་སྐྱེ་ནུས་སམ་ཞེས༌སྨྲའམ། ");
INSERT INTO bodn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྒྲུབ་མི་ནུས་པའི་བྱ་བ་ཡོད་སྲིད༌དམ། སང་ལོའི་དུས་འདིར་སླེབས་ཚེ། བདག་ནི་ཁྱོད་ཀྱི་ཡུལ་འདིར་འོང་ངེས༌ཤིང༌། སཱ་ར་ལའང་བུ་ཞིག་སྐྱེ་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","སཱ་རས་གསུང་དེ་ཐོས་པ་དང་འཇིགས་པར་གྱུར་ནས་དོན་དེ་ཁས་མ་བླངས་པར་ན༌རེ། ང་རང་མ་བགད་ཅེས༌སྨྲས། ཡང་ཁོང་གིས་འདི་སྐད༌དུ། དེ་འདྲ་ག་ལ༌ཡིན། ཁྱོད་རང་བགད་བྱུང་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","དེ་ནས་ཁོང་གསུམ་པོ་གནས་དེ་ནས་ལམ་ལ་ཆས་ཏེ་སཱ་དོམ་གྱི་ཕྱོགས་སུ་གཟིགས༌ཤིང༌། ཨབ་ར་ཧམ་ཡང་ཁོང་རྣམས་དང་མཉམ་དུ་ལམ་ལ་ཆས་ཏེ་སྐྱེལ་མ་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། བདག་གིས་བསྒྲུབ་པར་འགྱུར་བའི་དོན་རྣམས་ཨབ་ར་ཧམ་ལ་གསང་འོས༌སམ། ");
INSERT INTO bodn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ཨབ་ར་ཧམ་ནི་རྒྱལ་ཁབ་ཆེན་པོ་ཞིག་ཏུ་འགྱུར་ངེས༌ཤིང༌། ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལ་ཁོ་རང་བརྒྱུད་ནས་བྱིན་རླབས་འཐོབ་པར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ཅིའི་ཕྱིར་ཞེ༌ན། ཁོས་རང་ཉིད་ཀྱི་བུ་ཕྲུག་དང་རིགས་རྒྱུད་རྣམས་ལ་བདེན་པ་བདེན་དྲང་སྒོས་བདག་གི་ལམ་བསྲུང་བར་གདམས་པ༌དང༌། བདག་གིས་ཨབ་ར་ཧམ་གྱི་སྐོར་ལ་སྨྲས་པའི་དོན་རྣམས་ཀྱང་འགྲུབ་པར་འགྱུར་བའི༌ཕྱིར། བདག་གིས་ཁོ་རང་བདམས་པ་ཡིན་ཞེས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ཡང་ཁོང་གིས་འདི་སྐད༌དུ། སཱ་དོམ་དང་གཱ་མོ་ར་གཉིས་ཀྱི་ནག་ཉེས་སྐད་གྲགས་ཆེ་ཞིང་སྡིག་པའང་ཤིན་ཏུ་ཚབས༌ཆེ། ");
INSERT INTO bodn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ད་ལྟ་བདག་མར་སོང་སྟེ་ཁོ་རྣམས་ཀྱི་བྱ་སྤྱོད་ལ་རྟོག་དཔྱོད་བྱེད༌དེ། དངོས་གནས་བདག་གི་རྣ་བས་ཐོས་པའི་གྲགས་སྐད་ཇི་བཞིན་ཡིན༌ནམ། གལ་སྲིད་དེ་འདྲ་མིན་ན་བདག་གིས་རྟོགས་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ཡང་དེ་རྣམས་ལས་མི་གཉིས་ཡུལ་དེ་དང་ཁ་བྲལ་ནས་སཱ་དོམ་གྱི་ཕྱོགས་སུ་སོང༌ནའང༌། ཨབ་ར་ཧམ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་སྔར་བཞིན་ལངས་ནས་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","དེ་ནས་ཨབ་ར་ཧམ་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་དུ་ཡོང་སྟེ་ན༌རེ། ཁྱེད་ཀྱིས་མི་རྣམ་དག་དང་མི་ངན་པ་གང་ཡིན་ཡང་མཉམ་དུ་མེད་པར༌བཟོའམ། ");
INSERT INTO bodn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","གལ༌ཏེ། གྲོང་ཁྱེར་དེ་རུ་མི་རྣམ་དག་ལྔ་བཅུ་ཡོད་ན་ཁྱེད་ཀྱིས་གྲོང་ཁྱེར་དེ་མེད་པར་གཏོང༌ངམ། མི་རྣམ་དག་ལྔ་བཅུ་བོ་དེའི་རྐྱེན་གྱིས་གྲོང་ཁྱེར་དེ་ལ་དགོངས་ཡངས་མི་མཛད༌དམ། ");
INSERT INTO bodn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ཁྱེད་ཀྱིས་མི་རྣམ་དག་དང་མི་ངན་པ་མཉམ་དུ་གསོད༌པའམ། ཡང་ན་མི་རྣམ་དག་དང་མི་ངན་པ་གཉིས་ལ་འདྲ་མཉམ་གྱི་ལྟ་སྟངས་འཛིན༌ནམ། ཁྱེད་ཀྱིས་འདི་ལྟར་བྱ་རུང༌ངམ། ས་གཞི་ཐམས་ཅད་ཀྱི་ཁྲིམས་དཔོན་ཆེན་པོ་ཁྱེད་ཀྱིས་དྲང་བདེན་གྱི་ལས་མི་མཛད་དམ་ཞེས་ཞུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། གལ་སྲིད་བདག་གིས་སཱ་དོམ་གྲོང་ཁྱེར་ནས་མི་རྣམ་དག་ལྔ་བཅུ་མཐོང༌ཚེ། བདག་གིས་ཁོ་རྣམས་ཀྱི་རྐྱེན་གྱིས་ཡུལ་དེ་ཐམས་ཅད་ལ་གུ་ཡངས་གཏོང་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","དེ་ནས་ཨབ་ར་ཧམ་ན༌རེ། བདག་ནི་རྡུལ་ཕྲན་ཙམ་ཡིན༌ཡང༌། དཀོན་མཆོག་ཁྱེད་ལ་འདི་ལྟར་ཞུ་ཕོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","གལ་ཏེ་མི་རྣམ་དག་ལྔ་བཅུ་ལས་མི་ལྔ་ཇེ་ཉུང་དུ་སོང༌ན། ཁྱེད་ཀྱིས་མི་རྣམ་དག་ལྔ་ཇེ་ཉུང་དུ་སོང་བའི་རྒྱུ་མཚན་གྱིས་གྲོང་ཁྱེར་ཡོངས་རྫོགས་མེད་པར་གཏོང་ངམ་ཞེས་ཞུས༌སོ། །ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། གལ་སྲིད་བདག་གིས་ཡུལ་དེ་ནས་མི་རྣམ་དག་བཞི་བཅུ་ཞེ་ལྔ་མཐོང་ན་གྲོང་ཁྱེར་དེ་མེད་པར་མི་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ཡང་ཨབ་ར་ཧམ་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེ༌ལ། གལ་ཏེ་ཡུལ་དེ་ནས་མི་རྣམ་དག་བཞི་བཅུ་མཐོང་ན་ཅི་ལྟར་བྱེད་དམ་ཞེས་ཞུས་པ༌དང༌། ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། བདག་གིས་མི་རྣམ་དག་བཞི་བཅུ་བོ་དེའི་རྐྱེན་གྱིས་དོན་འདི་མི་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ཡང་ཨབ་ར་ཧམ་ན༌རེ། ཀྱེ། གཙོ་བོ༌ལགས། ཁྱེད་རང་དགོངས་པ་མི་ཚོམ་པར༌མཁྱེན། བདག་ལ་གསུང་གནང་བར་མཛོད༌དང༌། གལ་སྲིད་ཁྱེད་ཀྱིས་ཡུལ་དེ་ནས་མི་རྣམ་དག་སུམ་ཅུ་མཐོང་ན་ཅི་ལྟར་བྱའམ་ཞུས་པ༌ལ། ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། གལ་ཏེ་བདག་གིས་ཡུལ་དེ་ནས་མི་རྣམ་དག་སུམ་ཅུ་མཐོང་ན་དོན་འདི་མི་བསྒྲུབ་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ཡང་ཨབ་ར་ཧམ་ན༌རེ། བདག་གིས་ད་དུང་དཀོན་མཆོག་ལ་གཏམ་སྨྲ་བར་ཕོད༌དེ། གལ་སྲིད་ཁྱེད་ཀྱིས་ཡུལ་དེ་ནས་མི་རྣམ་དག་ཉི་ཤུ་མཐོང་ན་ཅི་ལྟར་བྱའམ་ཞེས་ཞུས་པ༌ལ། ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། བདག་གིས་མི་རྣམ་དག་ཉི་ཤུ་བོ་དེའི་རྐྱེན་གྱིས་གྲོང་ཁྱེར་དེ་ཉིད་མེད་པར་མི་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ཡང་ཨབ་ར་ཧམ་ན༌རེ། ཀྱེ། གཙོ་བོ༌ལགས། ཁྱེད་རང་དགོངས་པ་མི་ཚོམ་པར༌མཁྱེན། བདག་ལ་ད་དུང་ཐེངས་གཅིག་ལ་གསུང་གནང་བར༌མཛོད། གལ་ཏེ་ཁྱེད་ཀྱིས་ཡུལ་དེ་ནས་མི་རྣམ་དག་བཅུ་མཐོང་ན་ཅི་ལྟར་བྱའམ་ཞེས་ཞུས་པ༌ལ། ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། བདག་གིས་མི་རྣམ་དག་བཅུ་བོ་དེའི་རྐྱེན་གྱིས་གྲོང་ཁྱེར་དེ་ཉིད་མེད་པར་མི་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་ར་ཧམ་ལ་གསུང་གླེང་མཛད་རྗེས་བཞུད༌ཅིང༌། ཨབ་ར་ཧམ་ཡང་ཕྱིར་རང་ཡུལ་དུ་ལོག༌གོ། ");
INSERT INTO bodn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","དེ་ཡང་མཚན་མོའི་དུས་སུ་ཕོ་ཉ་དེ་གཉིས་སཱ་དོམ་དུ༌སླེབས། སྐབས་དེར་ལོད་ཐུ་ནི་སཱ་དོམ་གྱི་མཁར་སྒོར་སྡོད༌ཅིང༌། ཕོ་ཉ་གཉིས་ཕེབས་པ་མཐོང་སྟེ་ཡར་ལངས་ནས་བསུ་བ་བྱས་པ་དང་ཕྱག་བཙལ་ཏེ་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ཀྱེ། བདག་གི་ཇོ་བོ༌ལགས། ཁྱེད་གཉིས་རང་གི་ཞབས་ཕྱི་པ་བདག་གི་ཁྱིམ་དུ་ཕེབས་ཏེ་རྐང་པ་བཀྲུས་ནས་ཞག་གཅིག་ལ་བཞུགས༌རྗེས། སང་ཉིན་ཞོགས་པ་ཡར་བཞེངས་ནས་ཕེབས་པར་མཛོད་ཅེས་ཞུས་པ༌ལ། ཁོང་གཉིས་ཀྱིས་འདི་སྐད༌དུ། མིན་ཏེ། ངེད་གཉིས་ཁྲོམ་སྲང་དུ་ཞག་སྡོད་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","དེ་ནས་ལོད་ཐུ་ཡིས་གུས་གུས་ཞུམ་ཞུམ་ངང་གདན་འདྲེན་ཡང་ཡང་ཞུས་པ༌ན། ཕོ་ཉ་གཉིས་པོ་ད་གཟོད་ཁོའི་ཁྱིམ་དུ་ཕེབས་པ༌རེད། ལོད་ཐུ་ཡིས་ཕོ་ཉ་གཉིས་ལ་གསོལ་སྟོན་སྟ་གོན་བྱས་ཤིང་སྐྱུར་མེད་བག་ལེབ་བསྲེགས་པ་དང་ཁོང་རྣམས་ཀྱིས་ཞལ་ཟས་བཞེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","དེ་ཡང་ཁོང་རྣམས་མལ་དུ་མ་གཟིམ་པའི་སྐབས༌སུ། སཱ་དོམ་གྲོང་ཁྱེར་གྱི་གནས་སོ་སོའི་སྐྱེས་པ་རྒན་གཞོན་ཐམས་ཅད་ཡོང་ནས་ལོད་ཐུ་ཡི་ཁང་པའི་མཐའ་བསྐོར༌ཞིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ལོད་ཐུའི་མིང་ནས་བོས་ཏེ་ན༌རེ། དོ་དགོང་ཁྱོད་ཚང་ལ་ཡོང་བའི་མི་དེ་གཉིས་གང་དུ༌ཡོད། ངེད་ཅག་མི་དེ་གཉིས་དང་འགྲོགས་འདོད་ པས། སྒོའི་ཕྱི་རོལ་ཏུ་ཁྲིད་ཤོག་ཅེས་འུར་བརྒྱབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","དེ་ནས་ལོད་ཐུ་ཁང་པ་ལས་ཕྱིར་ཐོན༌ཞིང༌། སླར་ཡང་ཁང་པའི་སྒོ་བརྒྱབ་ནས་མི་ཚོགས་ཀྱི་མདུན་དུ་སོང་སྟེ་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ཀྱེ། བདག་གི་སྤུན་ཟླ༌རྣམས། ཁྱོད་ཅག་གིས་དོན་ངན་འདི་བསྒྲུབ་པར་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","བདག་ལ་སྐྱེས་པར་འགྲོགས་མ་མྱོང་བའི་བུ་མོ་གཉིས་ཡོད༌དེ། ད་ལྟ་བདག་གིས་ཁོ་མོ་གཉིས་ཁྲིད་ཡོང་ནས་ཁྱོད་ཅག་གི་འདོད་པ་བཞིན་བྱེད་དུ་འཇུག༌གོ །མི་གཞན་གཉིས་པོ་བདག་གི་ཁྱིམ་དུ་ཡོད༌ན། ཁྱོད་ཅག་གིས་ཁོ་གཉིས་ལ་ཅི་ཡང་མི་བྱེད་པར་མཛོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","མི་ཚོགས་ན༌རེ། ཁྱོད་ཕར་སོང་ཞིག་ཅེས་སྨྲས་པ༌དང༌། ཡང་མི་ཚོགས་ན༌རེ། ཁྱོད་ནི་ཕྱི་མི་ཡིན༌ལ། ད་དུང་ཁྲིམས་དཔོན་གྱི་གོ་ས་འཛིན་འདོད༌དམ། ད་ལྟ་ངེད་རྣམས་ཀྱིས་མི་དེ་གཉིས་ལས་ཀྱང་ཁྱོད་ལ་གནོད་འཚེ་ཆེན་པོ་བྱེད་ངེས་ཡིན་ཞེས་འུར་རྒྱག་བཞིན་ལོད་ཐུ་ཕར་དེད་ནས་སྒོ་གཅོག་རྩིས༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","འོན༌ཀྱང༌། སྐབས་དེར་ཕོ་ཉ་གཉིས་ཀྱིས་ཕྱག་བསྲིངས་ནས་ལོད་ཐུ་ཁང་པའི་ནང་དུ་འཐེན་པ་དང་སྒོ་བརྒྱབ་པར་མ༌ཟད། ");
INSERT INTO bodn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","སྒོའི་ཕྱི་རོལ་ཏུ་ཡོད་པའི་མི་ཚོགས་རྒན་གཞོན་རྣམས་ལ་མིག་འཁྲུལ་བྱུང་དུ་བཅུག༌པས། དེ་རྣམས་ཀྱིས་ལག་སྙོབ་བྱས་ཀྱང་སྒོ་མ་རྙེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","དེ་ནས་ཕོ་ཉ་གཉིས་ཀྱིས་ལོད་ཐུ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་ཡུལ་འདི་རུ་མི་གཞན་སུ་ཡོད༌དམ། མག་པ༌དང༌། བུ་དང་བུ༌མོ། ཁྱོད་ལ་གཏོགས་པའི་གྲོང་ཁྱེར་ནང་གི་མི་ཐམས་ཅད་སུ་ཡིན་ཡང་གནས་འདི་ནས་ཕྱི་རུ་ཁྲིད༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ངེད་གཉིས་ཀྱིས་ས་ཆ་འདི་མྱུར་དུ་མེད་པར༌བཟོའོ། །ཅིའི་ཕྱིར་ཞེ༌ན། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གྲོང་ཁྱེར་ནང་གི་ནག་ཉེས་ཀྱི་གྲགས་སྐད་ཆེ་བའི་ཕྱིར༌རོ། །དེ་བས་དཀོན་མཆོག་ཡ་ཝཱེས་ངེད་གཉིས་ས་ཆ་འདི་མེད་པར་གཏོང་བའི་ཆེད་དུ་མངགས་པ་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","དེ་ནས་ལོད་ཐུ་སྒོའི་ཕྱི་རུ་སོང་ནས་ཁོ་ཚང་གི་མག་པར་འགྱུར་ངེས་པ་གཉིས༌ལ། ཁྱོད་རྣམས་ཡར་ལངས་ནས་ས་ཆ་འདི་དང་ཁ་འབྲལ་བར་གྱུར༌ཅིག རྒྱུ་མཚན་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་གྲོང་ཁྱེར་འདི་མེད་པར་བཟོ་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌ཀྱང༌། ཁོའི་མག་པར་འགྱུར་ངེས་པ་རྣམས་ཀྱིས་ལོད་ཐུས་ཀུ་རེ་སྨྲས་པར་བསམས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","དེ་ནས་ནམ་ལངས་པ༌དང༌། ཕོ་ཉ་གཉིས་ཀྱིས་ལོད་ཐུ་ལ་ནན་སྐུལ་གྱིས་འདི་སྐད༌དུ། ཡར་ལོངས༌དང༌། གནས་འདི་ནས་རང་གི་ཆུང་མ་དང་བུ་མོ་གཉིས་ཀ་ཁྲིད་དེ་སོང༌ཞིག ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་གྲོང་ཁྱེར་འདིའི་ཉེས་ཆད་དང་མཉམ་དུ་མེད་པར་མི་གཏོང་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌ནའང༌། ");
INSERT INTO bodn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ལོད་ཐུ་ཐེ་ཚོམ་སྐྱེས་ཏེ་མྱུར་དུ་མ་སོང༌ངོ༌། །དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ལོད་ཐུ་ལ་ཐུགས་རྗེ་དགོངས་པའི༌ཕྱིར། ཕོ་ཉ་གཉིས་ཀྱིས་ཁོ་དང་ཁོའི་ཆུང་མ་དང་བུ་མོ་གཉིས་ཀྱི་ལག་པར་འཇུས་ནས་ཁོ་རྣམས་ཕྱི་རུ་ཁྲིད༌ཅིང༌། གྲོང་ཁྱེར་ཕྱི་རོལ་ཏུ་བདེ་བར་བཀོད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ཁོ་རྣམས་ཕྱིར་ཁྲིད་པའི་རྗེས༌སུ། ཕོ་ཉ་གཉིས་ཀྱིས་འདི་སྐད༌དུ། ཁྱོད་རྣམས་སྲོག་ཐར་བའི་ཕྱིར་ཕྲོས༌ཤིག ཁ་ཕྱིར་མི་འཁོར་བར༌གྱིས། ཡུལ་འཁོར་དུ་ཡང་མི་སྡོད་པར་རི་ཁྲོད་དུ་ཕྲོས༌ཤིག དེ་ལྟར་མ་བྱས་ན་ཁྱོད་རྣམས་མེད་པར་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","དེ་ནས་ལོད་ཐུ་ན༌རེ། བདག་གི་ཇོ་བོ༌ལགས། དེ་ལྟར་མི་བྱེད་པར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ལ་ཁྱེད་ཀྱི་སྤྱན་དྲུང་ནས་ཐུགས་རྗེ་ཐོབ་ཟིན་པ༌དང༌། ཁྱེད་ཀྱིས་བདག་ལ་སྙིང་རྗེ་ཆེན་པོའང་མངོན་པར་གྱུར་ནས་བདག་གི་སྲོག་བསྐྱབས༌སོ། །འོན༌ཀྱང༌། བདག་ནི་རི་ཁྲོད་དུ་འབྲོ་མི་ཐུབ༌སྟེ། ཆག་སྒོ་འདི་བདག་གི་ལུས་སྟེང་དུ་བྱུང་ནས་ང་རང་འཆི་བར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","གཟིགས་དང༌། ཕ་གིའི་གྲོང་རྡལ་དེ་ནི་ཆུང་བ༌དང༌། བདག་དང་བར་ཐག་ཀྱང་ཉེ་བས་འབྲོ་སླ་བ༌ཡིན། གྲོང་རྡལ་དེ་ཆུང་བ་མ་ཡིན༌ནམ། བདག་གི་སྲོག་སྐྱོབ་པའི༌ཕྱིར་ཁྱེད་ཀྱིས་བདག་གྲོང་རྡལ་དེར་འབྲོ་རུ་འཇུག་པར་མཛོད་ཅེས་ཞུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","དེ་ནས་ཕོ་ཉས་འདི་སྐད༌དུ། བདག་གིས་དོན་འདི་ཁྱོད་ལ་ཁས་བླངས་པ༌དང༌། བདག་གིས་ཁྱོད་ཀྱིས་སྨྲས་པའི་གྲོང་རྡལ་དེ་མེད་པར་མི་གཏོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ཁྱོད་རང་མྱུར་བ་མྱུར་དུ་གྲོང་རྡལ་དེར་ཕྲོས༌ཤིག ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་གྲོང་རྡལ་དེ་ལ་སླེབས་པའི་བར་དུ་བདག་གིས་ཅི་ཡང་བྱ་མི་ནུས་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས༌སོ། །དེ་བས་གྲོང་རྡལ་དེའི་མིང་ལ་ཚོ་ཨར་ཞེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","དེ་ནས་ལོད་ཐུ་ཁོ་རང་ཚོ་ཨར་དུ་སླེབས་དུས་ས་གཞིར་ཉི་མ༌ཤར། ");
INSERT INTO bodn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","སྐབས༌དེར། དཀོན་མཆོག་ཡ་ཝཱེས་ནམ་མཁའ་ནས་མེ་དང་མུ་ཟིའི་ཆར་བ་འབབ་ཏུ་བཅུག༌སྟེ། སཱ་དོམ་དང་གཱ་མོ་ར༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","གྲོང་ཁྱེར་དེ་དག་དང་ཡུལ་འཁོར་ཐམས་ཅད༌དང༌། གྲོང་ཁྱེར་ནང་གི་མི་རྣམས༌དང༌། ས་ལས་སྐྱེས་པ་ཐམས་ཅད་ཀྱང་མེད་པར་བཏང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","དེ་ནས་ལོད་ཐུའི་ཆུང་མས་ཁ་ཕྱིར་འཁོར་ནས་བལྟས་མ་ཐག་ཁོ་མོ་ལན་ཚྭའི་ཀ་བ་ཞིག་ཏུ་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ཞོགས་པར་ཨབ་ར་ཧམ་ཡར་ལངས༌ཏེ། ཁོ་རང་དེ་སྔོན་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་དུ་ལངས་ནས་བསྡད་མྱོང་བའི་གནས་དེར་སོང༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","སཱ་དོམ་དང་གཱ་མོ་ར་གཉིས༌དང༌། ཡུལ་འཁོར་ཐམས་ཅད་ཀྱི་ཕྱོགས་སུ་གཟིགས་པ༌ན། ཡུལ་དེ་དག་ལས་དུ་བ་འཕྱུར༌ཞིང༌། མེ་ཐབ་ལས་དུ་བ་འཕྱུར་བ་དང་མཚུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","དེ་ཡང་དཀོན་མཆོག་གིས་ཡུལ་འཁོར་གྱི་གྲོང་ཁྱེར་ཐམས་ཅད་རྡུལ་དུ་བརླག་པ་དང་ལོད་ཐུ་སྡོད་སའི་གྲོང་ཁྱེར་དེའང་མེད་པར་བཟོ་བའི་དུས༌སུ། ཁོང་གིས་ཨབ་ར་ཧམ་ཐུགས་ལ་དགོངས་ཏེ་ལོད་ཐུའང་གྲོང་ཁྱེར་དེ་ལས་ཕྱི་རུ་ཁྲིད་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","དེ་ཡང་ལོད་ཐུ་ཁོ་རང་ཚོ་ཨར་གྲོང་རྡལ་དུ་སྡོད་པར་འཇིགས༌པས། རང་གི་བུ་མོ་གཉིས་ཀ་ཁྲིད་ཅིང་ཚོ་ཨར་དང་ཁ་བྲལ་ཏེ་རི་ཁྲོད་དུ་སོང་ནས་ཁོ་རྣམས་བྲག་ཁུང་ཞིག་ལ་མཉམ་དུ༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","དེ་ནས་བུ་མོ་ཆེ་བས་བུ་མོ་ཆུང་བར་ན༌རེ། ངེད་གཉིས་ཀྱི་ཕ་ལོ་ན་རྒས༌ཤིང༌། ཡུལ་འདི་རུ་འཇིག་རྟེན་གྱི་ལུགས་སྲོལ་བཞིན་ངེད་གཉིས་དང་འགྲོགས་མཁན་མེད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ཤོག༌དང༌། ངེད་གཉིས་ཀྱིས་རང་གི་ཕ་ལ་རྒུན་ཆང་འདྲེན་པ༌དང༌། ཁོ་དང་འགྲོགས་པར༌བྱའོ། །དེ་ལྟར་བྱས༌ན། ངེད་གཉིས་ལ་ཕ་ལས་རིགས་རྒྱུད་ལྡན་པར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","དེའི༌ཕྱིར། མཚན་མོ་དེར་ཁོ་མོ་གཉིས་ཀྱིས་ཕ་ལ་རྒུན་ཆང་དྲངས་པ༌དང༌། ཐོག་མར་བུ་མོ་ཆེ་བ་སོང་ནས་ཕ་དང་ལུས་འབྲེལ༌བྱས། འོན༌ཀྱང༌། ཁོ་མོ་ག་དུས་ཉལ་བ༌དང༌། དུས་ནམ་ཞིག་ཡར་ལངས་པ་སོགས་ཕ་ཡིས་ཅི་ཡང་མ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","དེའི་ཕྱི༌ཉིན། བུ་མོ་ཆེ་བས་བུ་མོ་ཆུང་བར་ན༌རེ། མདང་ནུབ་བདག་ཕ་དང་འགྲོགས༌ཤིང༌། དོ་དགོང་ཡང་ངེད་གཉིས་ཀྱིས་ཕ་ལ་རྒུན་ཆང་འདྲེན་པ༌དང༌། ཁྱོད་ཕ་དང་འགྲོགས་པར༌བྱའོ། །དེ་ལྟར་བྱས༌ན། ངེད་གཉིས་ལ་ཕ་ལས་རིགས་རྒྱུད་ཡོད་པར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","དེའི༌ཕྱིར། མཚན་མོ་དེར་ཡང་ཁོ་མོ་གཉིས་ཀྱིས་ཕ་ལ་རྒུན་ཆང་དྲངས་པ༌དང༌། བུ་མོ་ཆུང་བ་ཡར་ལངས་ནས་ཕ་དང་ལུས་འབྲེལ་བྱས༌སོ། །འོན༌ཀྱང༌། ཁོ་མོ་ག་དུས་ཉལ་བ༌དང༌། དུས་ནམ་ཞིག་ཡར་ལངས་པ་སོགས་ཕ་ཡིས་ཅི་ཡང་མ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","དེ་ལྟར་ལོད་ཐུའི་བུ་མོ་གཉིས་ལ་རང་གི་ཕ་ལས་མངལ་སྦྲུམ་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","དེ་ཡང་བུ་མོ་ཆེ་བར་བུ་ཞིག་སྐྱེས་ཤིང་མིང་ལ་མོ་ཨབ་ཅེས་བཏགས་པ༌དང༌། དེ་ནི་དེང་དུས་ཀྱི་མོ་ཨབ་མི་རིགས་ཀྱི་མེས་པོ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","བུ་མོ་ཆུང་བས་ཀྱང་བུ་ཞིག་བཙས་ཤིང་མིང་ལ་པེན་ཨ་མེ་ཞེས་བཏགས་པ༌དང༌། དེ་ནི་དེང་དུས་ཀྱི་ཨམ་མོན་མི་རིགས་ཀྱི་མེས་པོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","དེ་ཡང་ཨབ་ར་ཧམ་ཡུལ་དེ་ནས་ནེ་གུབ་ཡུལ་ཕྱོགས་ཀྱི་ཀཱ་དེའེ་ཤཱ་དང་ཤུར་ཞེས་པའི་ཡུལ་བར་དུ་ཁྱིམ་གཞིས་སྤར་བ་དང་གེ་རཱར་གྲོང་ཁྱེར་དུ་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་རང་གི་ཆུང་མ་སཱ་ར་ནི་རང་གི་སྲིང་མོ་ཡིན་ཟེར༌བས། གེ་རཱར་གྱི་རྒྱལ་པོ་ཨ་བི་མེ་ལེག་གིས་མི་མངགས་ནས་སཱ་ར་རང་གི་ཁྱིམ་དུ་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","འོན༌ཀྱང༌། མཚན་མོའི་དུས༌སུ། རྒྱལ་པོ་ཨ་བི་མེ་ལེག་གི་རྨི་ལམ་དུ་དཀོན་མཆོག་དངོས་སུ་ཕེབས་ཏེ་ཁོ་རང་ལ་འདི་སྐད༌དུ། ཁྱོད་ནི་གཤིན་པོ་ལྟ་བུ༌ཡིན། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ཀྱིས་བུད་མེད་དེ་རང་གི་ཁྱིམ་དུ་བླངས་པའི་ཕྱིར༌ཡིན། བུད་མེད་དེ་ནི་མི་གཞན་གྱི་ཆུང་མ་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ཨ་བི་མེ་ལེག་ནི་སཱ་ར་དང་ཉེ་བར་འགྲོགས་མེད༌པས། ཁོ་ན༌རེ། གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་སྐྱོན་གྱི་དྲི་མས་མ་གོས་པའི་རྒྱལ་ཁབ་ཀྱང་མེད་པར༌བཟོའམ། ");
INSERT INTO bodn_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","མི་དེས་བདག་ལ་ཁོ་མོ་ང་ཡི་སྲིང་མོ་ཡིན་ཞེས་སྨྲས་པ་མ་ཡིན༌ནམ། བུད་མེད་དེས་ཀྱང་བདག་ལ་ཁོ་ངའི་གཅེན་པོ་ཡིན་ཞེས་སྨྲས་མྱོང་བ༌དང༌། བདག་གིས་དོན་འདི་བསྒྲུབས་པ་ནི་བསམ་པ་དྲང་ཞིང་སྤྱོད་ལམ་གཙང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ཡང་དཀོན་མཆོག་གིས་ཁོའི་རྨི་ལམ་ལས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་བསམ་པ་དྲང་པོའི་ངང་ནས་དོན་འདི་བསྒྲུབས་པ་བདག་གིས༌ཤེས། ཁྱོད་ཀྱིས་བདག་ལ་འགལ་བའི་སྡིག་པ་མི་བྱེད་པའི་ཕྱིར་ངས་ཁྱོད་རང་བཀག༌པར་མ་ཟད། ཁྱོད་ལ་ཁོ་མོར་རེག་ཏུའང་མ་བཅུག་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ད་ལྟ་ཁྱོད་ཀྱིས་བུད་མེད་དེ་ཕྱིར་ཁོ་མོའི་ཁྱོ་གར་སྤྲོད༌ཅིག ཁོ་མོའི་ཁྱོ་ག་ལུང་སྟོན་པ་ཞིག་ཡིན༌ཞིང༌། ཁོས་ཁྱོད་ཀྱི་ཆེད་དུ་གསོལ་བ་འདེབས་པ་དང་ཁྱོད་ཀྱང་འཆི་བར་མི་འགྱུར༌རོ། །གལ་ཏེ་ཁྱོད་ཀྱིས་ཁོ་མོ་ཕྱིར་མ་སྤྲད༌ན། ཁྱོད་དང་ཁྱོད་ཀྱི་མི་ཐམས་ཅད་འཆི་ངེས་པ་ཁྱོད་ཀྱིས་ཤེས་དགོས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ཞོགས་པར་ཨ་བི་མེ་ལེག་ཡར་ལངས་ཏེ་བློན་པོ་ཐམས་ཅད་བསྡུས༌ཤིང༌། དོན་དེ་དག་ཁོ་རྣམས་ལ་སྨྲས་པ་དང་དེ་དག་ཤིན་ཏུ་འཇིགས་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","དེ་ནས་ཨ་བི་མེ་ལེག་གིས་ཨབ་ར་ཧམ་བོས༌ཏེ། ཁྱོད་ཀྱིས་ངེད་རྣམས་ལ་འདི་ལྟར་བྱེད་དོན༌ཅི། བདག་གིས་དོན་གང་ཞིག་གི་ཆ་ནས་ཁྱོད་ལ་འགལ་བའི་སྡིག་པ་བྱས༌སམ། ཁྱོད་ཀྱིས་བདག་དང་བདག་གི་རྒྱལ་ཁབ་ཀྱི་མི་རྣམས་ལ་མ་ཉེས་ཁག་འགེལ་བྱེད༌དམ། ཁྱོད་ཀྱིས་བདག་ལ་བྱ་མི་འོས་པ་བྱས་སོ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ཡང་ཨ་བི་མེ་ལེག་ན༌རེ། ཁྱོད་ཀྱིས་དོན་གང་ཞིག་མཐོང་སྟེ་འདི་ལྟར་བྱས་སམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ཡང་ཨབ་ར་ཧམ་གྱིས་འདི་སྐད༌དུ། ངས་ས་ཆ་འདིའི་མི་རྣམས་དཀོན་མཆོག་ལ་མི་གུས་མི་འཇིགས་པར་འདོད༌ཅིང༌། ཁྱོད་རྣམས་ཀྱིས་བདག་གི་ཆུང་མའི་རྐྱེན་གྱིས་ང་རང་གསོད་ངེས་པར༌བསམས། ");
INSERT INTO bodn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ཁོ་མོ་དངོས་གནས་བདག་གི་སྲིང་མོ་ཡིན༌ཏེ། ངེད་གཉིས་ནི་ཕ་གཅིག་དང་མ་མི་གཅིག་པའི་མིང་སྲིང་ཡིན་པ༌དང༌། ཕྱིས་སུ་ཁོ་མོ་བདག་གི་ཆུང་མར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","དེ་སྔར་དཀོན་མཆོག་གིས་ང་རང་ཕ་གཞིས་དང་ཁ་བྲལ་ནས་ས་མཐར་འགྲིམས་པར་མཛད་པའི་དུས༌དེར། ངས་ཁོ་མོ་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ངེད་གཉིས་ས་ཆ་གང་དུ་སོང༌ནའང༌། ཁྱོད་ཀྱིས་མི་གཞན་ལ་ཁོ་བདག་གི་གཅེན་པོ་ཡིན་ཞེས་སྨྲོས༌དང༌། དེ་ལྟར་བྱས་ན་ཁྱོད་ཀྱིས་བདག་ལ་རོགས་རམ་བྱས་པ་ཡིན་ཞེས་བཤད་མྱོང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","དེ་ནས་ཨ་བི་མེ་ལེག་གིས་ར་ལུག་དང་བ༌གླང༌། གཡོག་པོ་དང་གཡོག་མོ་དག་ཨབ་ར་ཧམ་ལ་གནང་བ༌དང༌། ཁོང་གི་ཆུང་མ་སཱ་རའང་ཕྱིར་སྤྲད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ཡང་ཁོ་ན༌རེ། ལྟོས༌དང༌། བདག་གི་ས་ཐམས་ཅད་ཁྱོད་ཀྱི་མིག་མདུན་དུ་ཡོད༌པས། ཁྱོད་རང་གི་འདོད་མོས་བཞིན་གང་དུ་བཞུགས་ཀྱང་འོས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ཡང་ཁོས་སཱ་ར་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ངས་ཁྱོད་ཀྱི་གཅེན་པོར་དངུལ་སྒོར་ཆིག་སྟོང་སྤྲད་པ༌དང༌། དེ་ནི་ཁྱོད་རང་མི་ཚོགས་ཀྱི་མདུན་དུ་ངོ་གནོང་མི་དགོས་པ༌དང༌། ཁྱོད་ལ་ཉེས་སྐྱོན་མེད་པའི་སྐྱིན་ཚབ་ཏུ་སྤྲད་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་དཀོན་མཆོག་ལ་གསོལ་བ་བཏབ་པ༌དང༌། དཀོན་མཆོག་གིས་ཨ་བི་མེ་ལེག༌དང༌། ཁོའི་ཆུང་མ༌དང༌། གཡོག་མོ་ཐམས་ཅད་ཀྱི་ནད་གསོས་ཤིང་དེ་དག་ལ་མངལ་ཆགས་ཐུབ་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","རྒྱུ་མཚན་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཨབ་ར་ཧམ་གྱི་ཆུང་མ་སཱ་རའི་རྐྱེན༌གྱིས། དེ་སྔར་ཨ་བི་མེ་ལེག་ཚང་གི་བུད་མེད་ཐམས་ཅད་མངལ་མི་ཆགས་པར་མཛད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་དེ་སྔར་ཞལ་བཞེས་གནང་བ་བཞིན་སཱ་ར་ལ་ཐུགས་རྗེ་གནང་བ་དང་དེ་བཞིན་དུ་འགྲུབ་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","དེ་ནས་ཨབ་ར་ཧམ་དགུང་ལོ་བགྲེས་པའི་དུས་སུ་སཱ་ར་ལ་མངལ་སྦྲུམ་པ༌དང༌། དཀོན་མཆོག་གིས་གསུངས་པའི་དུས་དེར་ཨབ་ར་ཧམ་ལ་བུ་ཞིག༌སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ཨབ་ར་ཧམ་གྱིས་སཱ་ར་ལས་ཐོབ་པའི་བུ་དེའི་མིང་ལ་ཨི་སཱག་ཅེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","བུ་སྐྱེས་ནས་ཉིན་བརྒྱད་པ༌ལ། དཀོན་མཆོག་གིས་བཀའ་གནང་བ་བཞིན་ཨབ་ར་ཧམ་གྱིས་བུའི་མཚན་སྐྱི་བཅད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","བུ་ཨི་སཱག་སྐྱེས་པའི་དུས༌སུ། ཨབ་ར་ཧམ་དགུང་ལོ་བརྒྱ་ཐམ་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","དེ་ནས་སཱ་ར་ན༌རེ། དཀོན་མཆོག་གིས་ང་རང་དགོད་པར་མཛད་པ༌དང༌། ང་ལ་བུ་སྐྱེས་པའི་དོན་འདི་ཐོས་མཁན་སུ་ཡིན་ཡང་བདག་དང་མཉམ་དུ་དགོད་ངེས་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ཡང་ཁོ་མོ་ན༌རེ། སུ་ཞིག་གིས་སྔ་མོ་ནས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། སཱ་རས་བུ་ལ་ནུ་ཞོ་སྟེར་ངེས་ཡིན་ཞེས་སྨྲ་ནུས༌སམ། འོན༌ཀྱང༌། ངས་ཨབ་ར་ཧམ་དགུང་ལོ་མཐོ་བའི་དུས༌སུ་ཁོང་ལ་བུ་ཞིག་བཙས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","དེ་ཡང་བུ་ཨི་སཱག་རིམ་གྱིས་ནར་སོན་པ་དང་ནུ་ཞོ་སྟེར་མཚམས་བཞག༌གོ །བུའི་ནུ་ཞོ་བཀར་བའི་ཉིན༌ལ། ཨབ་ར་ཧམ་གྱིས་གསོལ་སྟོན་གཟབ་རྒྱས་བསྡུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","དུས༌དེར། ཨེ་ཅིབ་ཀྱི་གཡོག་མོ་ཧ་གར་ནས་ཨབ་ར་ཧམ་ལ་སྐྱེས་པའི་བུ་ཡེས་མ་ཨེལ་གྱིས་བུ་ཨི་སཱག་ལ་འཕྱ་དམོད་བྱེད་བཞིན་པ་སཱ་རས་མཐོང༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ཨབ་ར་ཧམ་ལ་འདི་ལྟར་སྨྲས༌པ། གཡོག་མོའི་བུ་ཡིས་བདག་གི་བུ་ཨི་སཱག་དང་མཉམ་དུ་ཁྱིམ་རྒྱུད་འཛིན་མི་རུང༌བས། གཡོག་མོ་མ་བུ་གཉིས་ཀ་ཕྱིར་ཕུད་ཅིག་ཅེས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ཨབ་ར་ཧམ་རང་གི་བུ་ཡི་རྐྱེན་གྱིས་སེམས་སྡུག་ཆེན་པོར༌ལྷུང༌། ");
INSERT INTO bodn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","འོན༌ཀྱང༌། དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་འདི་སྐད༌དུ། བུ་དང་གཡོག་མོའི་ཆེད་དུ་སེམས་སྡུག་མ༌བྱེད། སཱ་རས་གཏམ་གང་ཞིག་སྨྲས་པ་ལ་ཁྱོད་ཀྱིས་ཉན་པར༌བྱའོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཨི་སཱག་བརྒྱུད་ནས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཀྱི་མིང་ཐོན་པར་འགྱུར་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","གཡོག་མོའི་བུ་ལ་མཚོན༌ན། བདག་གིས་ཁོའི་རིགས་རྒྱུད་ལའང་རྒྱལ་ཁབ་ཅིག་འཛུགས་པར༌བྱའོ། །ཅིའི་ཕྱིར་ཞེ༌ན། བུ་དེའང་ཁྱོད་ཀྱི་བུ་ཡིན་པས་སོ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","དེ་ནས་ཞོགས་པར་ཨབ་ར་ཧམ་ཡར་ལངས་ཏེ་ཧ་གར་གྱི་ཕྲག་ལ་བག་ལེབ་དང་སྐྱི་ཁུག་བཀལ་བ་དང་ཁོ་མོའི་བུའང་ཁོ་མོར་སྤྲད་ནས་འགྲོ་རུ༌བཅུག དེ་ལྟར་ཧ་གར་མ་བུ་གཉིས་སོང་བ་དང་པེར་ཤ་བཱ་ཡི་དབེན་སྟོང་དུ༌འཁྱམས། ");
INSERT INTO bodn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","དེར་སྐྱི་ཁུག་ནང་གི་སྐོམ་ཆུ་བཏུངས་ཚར༌བས། ཧ་གར་གྱིས་བུ་ཆུང་སྡོང་ཕྲན་ཞིག་གི་གྲིབ་བསིལ་འོག་ཏུ་བཞག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ཁོ་མོ་མདའ་འཕེན་ཐེངས་གཅིག་གི་མཚམས་སུ་སོང་བ་དང་བུའི་ཕྱོགས་སུ་ཁ་གཏད་ནས་བསྡད༌དེ། ངས་བུ་འཆི་བར་མིག་གིས་བལྟ་མི་བཟོད་ཅེས་སྨྲ་བཞིན་སྐད་ཆེན་པོ་བརྒྱབ་ནས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","དེ་ཡང་དཀོན་མཆོག་གིས་བུ་ཆུང་ཞིག་ངུ་བའི་སྐད་གསན༌ཏོ། །དཀོན་མཆོག་གི་ཕོ་ཉས་ནམ་མཁའི་ཞིང་ཁམས་ནས་ཧ་གར་གྱི་མིང་ནས་བོས་ཏེ་འདི་སྐད༌དུ། ཧ༌གར། ཁྱོད་ཀྱིས་འདི་ལྟར་བྱེད་དོན༌ཅི། ཁྱོད་རང་འཇིགས་མི་དགོས༌ཏེ། དཀོན་མཆོག་གིས་བུ་ཆུང་གི་སྐད་གསན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ཡར་ལོངས༌དང༌། བུ་ཡར་བསྐྱོར་ནས་ཁོའི་ལག་པར་འཇུས༌ཤིག ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་བུའི་རིགས་རྒྱུད་ལ་རྒྱལ་ཁབ་ཆེན་པོ་ཞིག་འཛུགས་པར་བྱ་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","དཀོན་མཆོག་གིས་ཁོ་མོའི་མིག་ཟུང་གསལ་པོར་མཛད་པ༌དང༌། ཁོ་མོས་དོང་ཆུ་ཞིག་མཐོང་ཞིང་སྐྱི་ཁུག་ནང་དུ་ཆུ་བླངས་ནས་བུ་ཆུང་ལ་འཐུང་དུ༌བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","དེ་ལྟར་དཀོན་མཆོག་གིས་བུ་དེ་ལ་གཟིགས་སྐྱོང་གནང་བ༌དང༌། བུ་དེ་རིམ་གྱིས་ནར་སོན་པ་དང་དབེན་སྟོང་གི་ཡུལ་དུ་བསྡད༌ཅིང༌། ཕྱིས་སུ་མདའ་རྩལ་པ་ཞིག་ཏུ་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","བུ་དེ་ཕཱ་རན་ཞེས་པའི་དབེན་སྟོང་དུ་སྡོད༌དུས། ཁོའི་ཡུམ་གྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཁོ་རང་ལ་ཆུང་མ་ཞིག་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","སྐབས་དེར་ཨ་བི་མེ་ལེག་དང་ཁོང་གི་དམག་དཔོན་ཆེན་པོ་ཕི་ཀོལ་ཞེས་བྱ་བ་གཉིས་ཀྱིས་ཨབ་ར་ཧམ་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ཁྱོད་ཀྱིས་དོན་གང་ཞིག་བསྒྲུབས་ཀྱང་དཀོན་མཆོག་གིས་ཁྱོད་ལ་གཟིགས་སྐྱོང་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ད་ལྟ་ཁྱོད་ཀྱིས་འདི་ནས་དཀོན་མཆོག་དཔང་དུ་བཙུགས༌ཏེ། བདག་དང་བདག་གི༌བུ། བདག་གི་རིགས་རྒྱུད་རྣམས་ལ་མགོ་སྐོར་མི་གཏོང་བ༌དང༌། བདག་གིས་ཁྱོད་ལ་ཇི་ལྟར་དྲིན་གཟོ་བ༌བཞིན། ཁྱོད་ཀྱིས་ཀྱང་དེ་ལྟར་བདག་ལ་དྲིན་གཟོ་བ༌དང༌། ཁྱོད་སྡོད་སའི་ཡུལ་འདིའི་འབངས་མི་རྣམས་ལའང་དྲིན་གཟོ་བའི་དམ་བཅའ་འཇོག་པར་གྱིས་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ཨབ་ར་ཧམ་གྱིས་ང་རང་དམ་བཅའ་འཇོག་པར་འཐད་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","དེ་ཡང་སྔོན་ཆད་ཨ་བི་མེ་ལེག་གི་གཡོག་པོ་རྣམས་ཀྱིས་དོང་ཆུ་ཞིག་བཙན་འཕྲོག་བྱས་མྱོང༌བས། ཨབ་ར་ཧམ་གྱིས་དོན་དེའི་ཕྱིར་ཨ་བི་མེ་ལེག་ལ་བཀའ་བཀྱོན་གནང་བ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","དེ་ནས་ཨ་བི་མེ་ལེག་ན༌རེ། དོན་དེ་སུ་ཞིག་གིས་བྱས་པ་བདག་གིས་མི་ཤེས༌ཏེ། ཁྱོད་ཀྱིས་ཀྱང་བདག་ལ་མ་སྨྲས་ཤིང་བདག་གིས་དེ་རིང་བར་དུ་རྣ་བས་ཐོས་མ་མྱོང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་ཨ་བི་མེ་ལེག་ལ་བ་གླང་དང་ར་ལུག་བཅས་སྤྲད་པ༌དང༌། ཁོ་གཉིས་ཕན་ཚུན་བར་གྲོས་འཆམ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ཨབ་ར་ཧམ་གྱིས་མ་མོ་བདུན་གནས་གཞན་དུ་བཞག་ཡོད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ཨ་བི་མེ་ལེག་གིས་ཨབ་ར་ཧམ་ལ་འདི༌ལྟར། ཁྱོད་ཀྱིས་མ་མོ་བདུན་གནས་གཞན་དུ་འཇོག་པའི་རྒྱུ་མཚན་ཅི་ཞེས་དྲིས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ཨབ་ར་ཧམ་གྱིས་འདི་སྐད༌དུ། ངས་དོང་ཆུ་འདི་བརྐོས་པའི་དཔང་རྟགས༌སུ། ཁྱོད་ཀྱིས་བདག་ནས་མ་མོ་བདུན་ལེན་དགོས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","དེའི༌ཕྱིར། ཨབ་ར་ཧམ་གྱིས་གནས་དེའི་མིང་ལ་པེར་ཤ་བཱ་ ཞེས་བཏགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་གཉིས་ཀྱིས་གནས་དེ་རུ་དམ་བཅའ་བཞག་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","དེ་ལྟར་ཁོ་གཉིས་པེར་ཤ་བཱ་ཡུལ་དུ་གྲོས་འཆམ་བྱུང་བ༌དང༌། ཨ་བི་མེ་ལེག་ཁོང་གི་དམག་དཔོན་ཕི་ཀོལ་དང་མཉམ་དུ་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱི་ཡུལ་དུ་ཕྱིར༌ལོག ");
INSERT INTO bodn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ཨབ་ར་ཧམ་གྱིས་པེར་ཤ་བཱ་ཡུལ་དུ་འོམ་བུ་ཤིང་ཕྲན་ཞིག་བཙུགས༌ཤིང༌། གནས་དེ་ནས་ཐོག་མཐའ་མེད་པའི་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ནས་བོས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ཨབ་ར་ཧམ་ཁོང་ཉིད་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱི་ཡུལ་དུ་ཉིན་མང་པོར་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","དོན་དེའི་རྗེས༌སུ། དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་བརྟག་པར་དགོངས་ཏེ་ཨབ་ར་ཧམ་ཞེས་ཁོའི་མིང་ནས་བོས་པ༌ན། ཁོ་ན༌རེ། ང་རང་འདི་རུ་ཡོད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","དེ་ནས་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་རང་གི་གཅེས་པའི་བུ་གཅིག་པུ་སྟེ་ཨི་སཱག་ཁྲིད་ནས་མོ་རེའེ་ཡཱ་ཡུལ་དུ་སོང༌དང༌། བདག་གིས་སྟོན་པར་འགྱུར་བའི་རི་བོ་ཞིག་གི་སྟེང་དུ་བུ་དེ་སྦྱིན་སྲེག་ཏུ་ཕུལ་ཞིག་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","དེ་ནས་ཞོགས་པར་ཨབ་ར་ཧམ་ཡར་ལངས་ཏེ་བོང་བུར་སྒ་གཏད༌ཅིང༌། སྦྱིན་སྲེག་གི་བུད་ཤིང་གཏུབས་རྗེས་གཡོག་པོ་གཉིས་དང་རང་གི་བུ་ཨི་སཱག་བཅས་ཁྲིད་དེ་དཀོན་མཆོག་གི་བཀའ་བཞིན་དུ་ཡུལ་དེའི་ལམ་ལ༌ཆས། ");
INSERT INTO bodn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","དེ་ནས་ཉིན་གསུམ་པ༌ལ། ཨབ་ར་ཧམ་གྱིས་མགོ་ཡར་བཀྱགས་ཏེ་རྒྱང་རིང་ནས་ཡུལ་དེ་མཐོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","གཡོག་པོ་གཉིས་ལ་འདི་སྐད༌དུ། ཁྱོད་གཉིས་ཀྱིས་བོང་བུ་བཟུང་ནས་འདིར་སྒུགས༌དང༌། བདག་དང་བུ་གཉིས་ཀ་གནས་དེར་སོང་ནས་དཀོན་མཆོག་ལ་གུས་ཕྱག་ཕུལ༌རྗེས། ཕྱིར་ཁྱོད་གཉིས་ཀྱི་གམ་དུ་ཡོང་ངེས་ཡིན་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་བུ་ཨི་སཱག་ལ་སྦྱིན་སྲེག་གི་བུད་ཤིང་ཁུར་དུ་བཅུག་པ་དང་རང་གི་ལག་ཏུ་མེ་དང་གྲི་བཟུང་ནས་ཁོ་གཉིས་ཕ་རོལ་ཏུ༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","དེ་ནས་བུ་ན༌རེ། ཕ་ལགས་ཞེས་ཞུས་པ༌དང༌། ཕ་ན༌རེ། བདག་གི༌བུ། ང་རང་འདི་རུ་ཡོད་ཅེས་སྨྲས༌སོ། །ཡང་བུ་ན༌རེ། ཁྱེད་ཀྱིས་གཟིགས༌དང༌། མེ་དང་བུད་ཤིང་ཐམས་ཅད་འཛོམས༌མོད། འོན་ཀྱང་སྦྱིན་སྲེག་ཏུ་ཕུལ་བའི་ལུ་གུ་གང་དུ་ཡོད་ཅེས་ཞུས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ཕ་ན༌རེ། བདག་གི༌བུ། དཀོན་མཆོག་གིས་དངོས་སུ་སྦྱིན་སྲེག་གི་ལུ་གུ་གནང་ངེས་ཡིན་ཞེས་སྨྲས་པ་དང་ཕ་བུ་གཉིས་ཀ་མཉམ་དུ༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","དེ་ནས་ཁོ་གཉིས་དཀོན་མཆོག་གིས་བསྟན་པའི་གནས་དེར་སླེབས་པ༌དང༌། ཨབ་ར་ཧམ་གྱིས་གནས་དེ་རུ་མཆོད་ཁྲི་ཞིག་བཞེངས་པ་དང་དེའི་སྟེང་དུ་བུད་ཤིང་ལེགས་པར་བསྒྲིགས༌རྗེས། རང་གི་བུ་ཨི་སཱག་ཐག་པས་བསྡམས་ཏེ་བུད་ཤིང་གི་སྟེང་དུ༌བཞག ");
INSERT INTO bodn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ཨབ་ར་ཧམ་གྱིས་ལག་པ་བརྐྱངས་ནས་གྲི་བླངས་ཏེ་བུ་གསོད་པར་རྩོམ་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","གློ་བུར་ཉིད་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉས་ནམ་མཁའི་ཞིང་ཁམས་ནས་ཨབ་ར༌ཧམ། ཨབ་ར་ཧམ་ཞེས་ཁོའི་མིང་ནས་བོས་པ༌དང༌། ཁོས་ང་རང་འདི་རུ་ཡོད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","དེ་ནས་ཕོ་ཉས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་བུ་དེ་ལ་ལག་པས་རེག་པར་མི༌བྱའོ། །བུ་དེ་ལ་གནོད་པ་ཅི་ཡང་བྱ་མི་རུང༌ངོ༌། །ཁྱོད་ཀྱིས་དཀོན་མཆོག་ལ་དད་གུས་བྱེད་པ་ད་ལྟ་བདག་གིས༌ཤེས། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ཀྱིས་རང་གི་བུ་གཅིག་པུ་བདག་ལ་འབུལ་བར་ཡང་མ་འཛེམ་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ཨབ་ར་ཧམ་གྱིས་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། ལུག་ཐུག་ཅིག་མཐོང་ཞིང་རྭ་ཅོ་གཉིས་ཚེར་མའི་གསེབ་ཏུ་ཟུག་ཡོད་པ༌ལ། ཁོང་གིས་ལུག་ཐུག་དེ་ཚེར་མ་ལས་བླངས་ཏེ་རང་གི་བུའི་ཚབ་ཏུ་དཀོན་མཆོག་ལ་སྦྱིན་སྲེག་ཏུ་ཕུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ཨབ་ར་ཧམ་གྱིས་གནས་དེའི་མིང་ལ་ཡ་ཝཱེས་ཡིར་ཨེ་ཞེས་བཏགས་ཤིང་དོན་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་གནང་ངེས་ཡིན་ཞེས་པའོ། །ད་ལྟའི་བར་དུ་མི་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་རི་བོར་ཁོང་གིས་གནང་ངེས་ཡིན་ཞེས༌སྨྲའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉས་ཐེངས་གཉིས་པར་ནམ་མཁའི་ཞིང་ཁམས་ལས་ཨབ་ར་ཧམ་ཞེས་ཁོའི་མིང་ནས་བོས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་དོན་འདི་བསྒྲུབས་པར་རང་གི་བུ་གཅིག་པུ་ལའང་མ་འཛེམ༌པས། ངས་རང་ལ་བརྟེན་ནས་དམ་བཅས་པ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","བདག་གིས་ཁྱོད་ལ་བྱིན་རླབས་ཆེན་པོ་གནང་ངེས༌ཤིང༌། ཁྱོད་ཀྱི་བུ་རྒྱུད་ནི་ནམ་མཁའི་སྐར་མ་དང་རྒྱ་མཚོའི་འགྲམ་གྱི་བྱེ་མ་ཇི་བཞིན་མང་དུ་འཕེལ་བར༌བྱ། ཁྱོད་ཀྱི་བུ་རྒྱུད་ཀྱིས་རང་གི་དགྲ་བོ་རྣམས་ཀྱི་མཁར་འཛིན་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ཁྱོད་ཀྱིས་བདག་གི་གཏམ་ལ་མཉན་པའི༌ཕྱིར། ཁྱོད་ཀྱི་བུ་རྒྱུད་བརྒྱུད་ནས་ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལ་བྱིན་རླབས་འཐོབ་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","དེའི༌ཕྱིར། ཨབ་ར་ཧམ་ཕ་བུ་གཉིས་རང་གི་གཡོག་པོའི་གམ་དུ་སོང་བ༌དང༌། ཁོ་རྣམས་ལྷན་དུ་པེར་ཤ་བཱ་རུ་ཕྱིར་ལོག༌རྗེས། ཨབ་ར་ཧམ་ནི་པེར་ཤ་བཱ་ཡུལ་དུ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","དོན་དེའི་རྗེས༌སུ། མི་གཞན་གྱིས་ཨབ་ར་ཧམ་ལ་འདི་ལྟར་སྨྲས༌པ། ལྟོས༌དང༌། མིལ་ཀཱ་ཡིས་ཁྱེད་ཀྱི་སྤུན་ནཱ་ཧོར་ལ་བུ་དུ་མ་བཙས་པ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","བུ་སྐྱེས་འགོ་ནི་ཨུ་ཟཱ་ཡིན༌ལ། ཁོའི་གཅུང་པོ་ནི་པུ་ཟཱ༌དང༌། ཀཱ་མུ༌ཨེལ། ༼དེ་ནི་ཨ་རམ་གྱི་ཕ༌ཡིན།༽ ");
INSERT INTO bodn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ཀེ༌སེད། ཧ༌ཟོ། ཕིལ༌དཱ། ཡེད༌ལིབ། པཱ་ཐུ་ཨེལ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","པཱ་ཐུ་ཨེལ་ནི་ཕྱིས་སུ་བུ་མོ་རིབ་ཀཱ་ཞེས་བྱ་བའི་ཕ་ཡིན༌ལ། བུ་དེ་བརྒྱད་པོ་ནི་མིལ་ཀཱ་ཡིས་ཨབ་ར་ཧམ་གྱི་སྤུན་ནཱ་ཧོར་ལ་བཙས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","དེ་ཡང་ནཱ་ཧོར་གྱི་ཆུན་མ་རཱ་ཨུ་མཱ༌ལས། ཐེ་པཱག༌དང༌། གཱ༌ཧམ། ཐཱ་ཧ༌ཤཱ མཱ་ཨ་ཀཱ་བཅས་བུ་བཞི་སྐྱེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","དེ་ཡང་སཱ་ར་དགུང་ལོ་བརྒྱ་དང་ཉེར་བདུན་ལ་བཞུགས༌ཤིང༌། དེ་ནི་སཱ་རའི་མི་ཚེ་གང་པོའི་ཚེ་ཚད་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ཁོ་མོ་ཀ་ན་ཨན་ཡུལ་གྱི་ཀིར་ཡཱད་ཨར་པཱ་གྲོང་ཁྱེར༌ཏེ། དེང་སང་གི་ཧེབ་རོན་དུ་ཚེ་ལས་འདས༌པས། ཨབ་ར་ཧམ་ནང་དུ་སོང་ནས་མྱ་ངན་དང་ངུ་འབོད་བྱས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ཕྱིས་སུ་ཨབ་ར་ཧམ་འདས་པོ་སཱ་རའི་མདུན་ནས་ཡར་ལངས༌ཏེ། ཧེད་ཀྱི་བུ་རྒྱུད་རྣམས་ལ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","བདག་ནི་ཁྱེད་རྣམས་ཀྱི་ཁྲོད་ནས་ཕྱི་ཕྱོགས་པ་ཡིན༌ལ། བྱེས་པ་ཞིག་ཀྱང་ཡིན༌པས། ཁྱེད་ཅག་གིས་འདི་ནས་བདག་ལ་དུར་ས་ཞིག་གནང་བར༌ཞུ། ངས་ཁོ་མོའི་བེམ་པོ་བདག་གི་མིག་ལམ་ནས་དུར་ལ་སྦ་བར་བྱ་ཞེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ཧེད་ཀྱི་བུ་རྒྱུད་རྣམས་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ཇོ་བོ༌ལགས། ཁྱེད་ཀྱིས་གསན་རོགས༌གནང༌། ཁྱེད་ནི་ངེད་ཅག་གི་ཁྲོད་དུ་རྒྱལ་སྲས་མཆོག་གྱུར་ཞིག་ཡིན༌ལ། ཁྱེད་ཀྱིས་ངེད་ཅག་གི་དུར་ཁྲོད་ལས་ཆེས་བཟང་བའི་གནས་སུ་ཁྱེད་ཀྱི་བེམ་པོ་དུར་ལ་སྦས་ཀྱང་རུང༌སྟེ། ངེད་ཅག་སུ་ཞིག་གིས་ཀྱང་རང་གི་དུར་ཁྲོད་དུ་ཁྱེད་ཀྱི་བེམ་པོ་དུར་ལ་སྦ་རུ་མི་འཇུག་པ་མེད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","དེ་ནས་ཨབ་ར་ཧམ་ཡར་ལངས་ཤིང་གནས་དེའི་ཧེད་ཀྱི་བུ་རྒྱུད་རྣམས་ལ་གུས་པ་བྱས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","འདི་སྐད༌དུ། ངས་ཁོ་མོའི་བེམ་པོ་བདག་གི་མིག་ལམ་ནས་དུར་ལ་སྦ་བར་ཁྱེད་རྣམས་འཐད་པ་ཡིན༌ན། ཁྱེད་ཅག་གིས་གསོན་དང༌། བདག་གི་ཆེད་དུ་ཁྱེད་རྣམས་བར་སྡོད་པ་བྱས་ནས་ཚོ་ཧར་གྱི་བུ་ཨེབ་རོན་ལ་ཞུ་བ་ཞུས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ས་ཞིང་གི་གོང་དུ་ཡོད་པའི་མཱག་ཕེ་ལཱ་བྲག་ཁུང་དེ་བདག་ལ་དུར་ས་རུ་གནང་བ༌དང༌། ཨེབ་རོན་གྱིས་བྲག་ཁུང་དེ་རིན་གོང་དངོས་མ་ལྟར་ཁྱེད་ཀྱི་མིག་མདུན་ནས་བདག་ལ་བཙོང་བར་མཛོད་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","སྐབས་དེར་ཧེད་ཀྱི་བུ་རྒྱུད་ཨེབ་རོན་རང་གི་སྤུན་ཟླ་རྣམས་ཀྱི་ཁྲོད་དུ་ཡོད༌པས། ཨེབ་རོན་གྱིས་མཁར་སྒོ་བརྒྱུད་ནས་འགྲོ་འོང་བྱེད་པའི་ཧེད་ཀྱི་བུ་རྒྱུད་ཐམས་ཅད་ཀྱི་ཁྲོད་དུ་ཨབ་ར་ཧམ་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","དེ་འདྲ་ག་ལ༌ཡིན། བདག་གི་ཇོ་བོ༌ལགས། གསོན་དང༌། བདག་གིས་ས་ཞིང་འདི་ཁྱེད་ལ་སྟེར་བ༌དང༌། ཐ་ན་ཞིང་བར་གྱི་བྲག་ཁུང་ཡང་ཁྱེད་ལ་སྟེར་རྒྱུ༌དང༌། ངེད་ཅག་མི་རིགས་ཀྱི་མིག་མདུན་ནས་ཐམས་ཅད་ཁྱེད་ལ་སྟེར་རྒྱུ་ཡིན༌པས། ཁྱེད་ཀྱིས་རང་གི་བེམ་པོ་དུར་ལ་སྦ་བར་གྱིས་ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","དེ་ནས་ཡང་ཨབ་ར་ཧམ་གྱིས་ཡུལ་དེའི་མི་རྣམས་ལ་གུས་པ་བྱས༌རྗེས། ");
INSERT INTO bodn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ཁོ་རྣམས་ཀྱི་མིག་མདུན་ནས་ཨེབ་རོན་ལ་འདི་སྐད༌དུ། ཁྱེད་རང་འཐད་པ་ཡིན༌ན། བདག་གི་གཏམ་ལ་མཉན་པར༌མཛོད། ངས་ས་རིན་ཐམས་ཅད་ཁྱེད་ལ་སྟེར་རྒྱུ་ཡིན་པ༌དང༌། ཁྱེད་ཀྱིས་ཀྱང་ལེན་པར༌མཛོད། ངས་གནས་དེ་རུ་བདག་གི་བེམ་པོ་དུར་ལ་སྦ་བར་བྱ་ཞེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ཨེབ་རོན་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","བདག་གི་ཇོ་བོ༌ལགས། ཁྱེད་ཀྱིས་གསོན་དང༌། ས་རིན་དངུལ་སྲང་ བཞི་བརྒྱ་ཡིན་པའི་ས་ཞིང་ནི་ངེད་གཉིས་བར་དུ་ཅི་ཡང་མ་ཡིན༌ཏེ། ཁྱེད་ཀྱིས་རང་གི་བེམ་པོ་དུར་དུ་སྦ་བར་གྱིས་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","དེ་ནས་ཨབ་ར་ཧམ་གྱིས་ཨེབ་རོན་གྱི་གཏམ་ལ་མཉན༌ཅིང་། ཁོང་གིས་ཧེད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱི་མདུན་དུ་སྨྲས་པ་བཞིན་བསྒྲུབས༌ཏེ། ཉོ་འཚོང་བྱེད་པར་བཀོལ་བའི་དངུལ་སྲང་བཞི་བརྒྱ་དེ་སྲང་ལ་འཇལ་ནས་ཨེབ་རོན་ལ་སྤྲད་དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","དེ་ལྟར་ཨབ་ར་ཧམ་གྱིས་ཨེབ་རོན་གྱི་ས་ཞིང་ཉོས་པ༌དང༌། ས་ཞིང་དེ་ནི་མཱག་ཕེ་ལཱ་ཞེས་པའི་ས་ཆར་ཡོད་པར་མ༌ཟད། མཱན་རེའེ་ཡུལ་གྱི་མདུན་ཕྱོགས་སུ་ཡོད༌ཅིང༌། ས་ཞིང་དེ་དང་དེ་རུ་ཡོད་པའི་བྲག་ཁུང༌དང༌། ཞིང་བར་དང་དེའི་མཐའ་སྐོར་གྱི་ལྗོན་ཤིང་ཐམས་ཅད་ཨབ་ར་ཧམ་ལ་དབང་བ༌དང༌། ས་ཞིང་དེ་ནི་མཁར་སྒོ་བརྒྱུད་ནས་འགྲོ་འོང་བྱེད་པའི་ཧེད་ཀྱི་བུ་རྒྱུད་ཐམས་ཅད་ཀྱི་མིག་མདུན་ནས་ཉོས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","དོན་དེའི་རྗེས༌སུ། ཨབ་ར་ཧམ་གྱིས་རང་གི་ཆུང་མ་སཱ་རའི་བེམ་པོ་ཀ་ན་ཨན་ཡུལ་གྱི་མཱག་ཕེ་ལཱ་ཞེས་པའི་ས་ཆར་ཡོད་པའི་ས་ཞིང་གི་བྲག་ཁུང་དུ་དུར་ལ་སྦས༌སོ། །བྲག་ཁུང་དེ་མཱན་རེའེ་ཡུལ་གྱི་མདུན་ཕྱོགས་སུ་ཡོད༌ཅིང༌། མཱན་རེའེ་ཞེས་པ་ནི་ཧེབ་རོན༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","དུས་དེ་ནས༌བཟུང༌། ས་ཞིང་དེ་དང་དེ་རུ་ཡོད་པའི་བྲག་ཁུང་ནི་ཧེད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱིས་ཁས་བླངས་པ་ལྟར་ཨབ་ར་ཧམ་ལ་དབང་བ་དང་ཁོང་གི་ཁྱིམ་རྒྱུད་ཀྱི་དུར་ཁྲོད་དུ་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","དེ་ཡང་ཨབ་ར་ཧམ་དགུང་ལོ་མཐོ་བ་དང་དོན་གང་ཅིའི་ཐད་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོང་ལ་བྱིན་རླབས་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ཨབ་ར་ཧམ་གྱིས་རང་ཁྱིམ་གྱི་རྒྱུ་ནོར་ཡོངས་ལ་དོ་དམ་བྱེད་པའི་གཡོག་པོ་ལོ་ན་ཆེས་རྒན་པ་དེ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་རང་གི་ལག་པ་བདག་གི་བརླ་འོག་ཏུ་འཇོག་པར༌གྱིས། ");
INSERT INTO bodn_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ཁྱོད་ཀྱིས་གནམ་ས་གཉིས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་དཔང་དུ་བཙུགས་ནས་དམ་བཅའ་ཞོག༌ཅིག ང་རང་སྡོད་པའི་ཡུལ་འདི་ནས་བདག་གི་བུ་ལ་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་ཆུང་མར་ལེན་པར་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ཁྱོད་རང་བདག་གི་ཕ་ཡུལ་དང་བདག་གི་གཉེན་ཉེའི་གམ་དུ་སོང་ནས་བདག་གི་བུ་ཨི་སཱག་ལ་ཆུང་མ་ཞིག་ལེན་དགོས་ཞེས་གསུངས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","གཡོག་པོ་ན༌རེ། གལ༌སྲིད། བུ་མོ་བདག་དང་མཉམ་དུ་གནས་འདིར་མི་ཡོང༌ན། ངས་ཁྱེད་ཀྱི་བུ་ཕྱིར་ཕ་ཡུལ་དུ་འཁྲིད་དམ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ཡང་ཨབ་ར་ཧམ་གྱིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་མཉམ་འཇོག་པར༌གྱིས། བདག་གི་བུ་ཕྱིར་མ་འཁྲིད༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ནམ་མཁའི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོང་གི་ཕོ་ཉ་ཁྱོད་ཀྱི་མདུན་དུ་མངགས་ངེས༌ཏེ། ཁྱོད་ཀྱིས་གནས་དེ་ནས་བདག་གི་བུ་ལ་ཆུང་མ་ཞིག་ལེན་པར༌བྱའོ། །ཁོང་གིས་སྔོན་ཆད་ང་རང་བདག་གི་ཕ་གཞིས་དང་རང་མི་རིགས་ཀྱི་ཡུལ་དང་ཁ་འབྲལ་བར་མཛད་དེ་འདི་སྐད༌དུ། བདག་གིས་ཡུལ་འདི་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་གནང་བར་བྱ་ཞེས་མནའ་བཞེས་མྱོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","གལ༌ཏེ། བུ་མོ་དེ་ཁྱོད་དང་མཉམ་དུ་ཡོང་མི་འདོད༌ན། ཁྱོད་ཀྱིས་བདག་ལ་དམ་བཅས་པའང་ཁྱོད་དང་འབྲེལ་བ་མེད་པ༌ཡིན། བདག་གི་བུ་གཏན་ནས་ཕྱིར་འཁྲིད་མི་རུང་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","དེ་ནས་གཡོག་པོས་རང་གི་བདག་པོ་ཨབ་ར་ཧམ་གྱི་བརླ་འོག་ཏུ་ལག་པ་བཞག་སྟེ་དོན་འདིའི་ཆེད་དུ་དམ་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","དེར་གཡོག་པོས་རང་གི་བདག་པོའི་རྔ་མོང་ལས་རྔ་མོང་བཅུ་ཁྲིད་ཅིང་ནོར་རྫས་སྣ་ཚོགས་བཟུང༌སྟེ། མེ་སོ་པོ་ཐེམ་ཡཱ་ཡུལ་དུ་སོང་བ་དང་ནཱ་ཧོར་གྲོང་ཁྱེར་དུ༌སླེབས། ");
INSERT INTO bodn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ས་མ་རུབ་སྔོན༌ལ། བུ་མོ་རྣམས་ཆུ་འཁུར་དུ་འགྲོ་བའི་དུས༌སུ། གཡོག་པོས་རྔ་མོང་རྣམས་གྲོང་ཁྱེར་ཕྱི་རོལ་གྱི་ཁྲོན་པ་ཞིག་གི་ཉེ་སར་འདུག་ཏུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","དེ་ནས་གཡོག་པོས་དཀོན་མཆོག་ལ་འདི༌ལྟར། ཀྱེ། དཀོན་མཆོག་ཡ༌ཝཱེ། ང་ཡི་བདག་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག༌ལགས། ཁྱེད་ཀྱིས་ང་ཡི་བདག་པོ་ཨབ་ར་ཧམ་ལ་ཐུགས་རྗེས་གཟིགས༌དང༌། དེ་རིང་བདག་གོ་སྐབས་ལེགས་པོ་ཞིག་དང་འཕྲད་པར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ང་རང་ད་ལྟ་ཁྲོན་པའི་འགྲམ་དུ་ཡོད༌ཅིང༌། གྲོང་ཁྱེར་ནང་གི་བུ་མོ་རྣམས་ཆུ་ལེན་དུ་ཡོང་བཞིན་ཡོད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ངས་བུ་མོ་སུ་ཞིག༌ལ། ཁྱོད་ཀྱིས་ཆུ་ཟོ་ཁྱེར་ཤོག༌དང༌། ངས་ཆུ་འཐུང་འདོད་ཅེས་སྨྲ་བ༌དང༌། གལ༌ཏེ། ཁོ་མོ་ན༌རེ། ཁྱོད་ཀྱིས་འཐུང༌དང༌། ངས་ཁྱོད་ཀྱི་རྔ་མོང་ལའང་ཆུ་ལྡུད་པར་བྱ་ཞེས་སྨྲས༌ན། བུ་མོ་དེ་ནི་ཁྱེད་ཀྱིས་བསྐོས་པ་ལྟར་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ཨི་སཱག་གི་ཆུང་མ་ཡིན་པར༌མཛོད། འདི་ལྟར་གྲུབ༌ཚེ། ཁྱེད་ཀྱིས་ང་ཡི་བདག་པོ་ལ་ཐུགས་རྗེ་གནང་བ་བདག་གིས་ཤེས་ནུས་པ་ཡིན་ཞེས་གསོལ་བ་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","དེ་ལྟར་གཡོག་པོས་གསོལ་བ་བཏབ་མ་ཚར༌བར། རིབ་ཀཱ་ཞེས་བྱ་བའི་བུ་མོས་ཕྲག་ལ་ཆུ་ཟོ་ཁུར་ནས་ཆུ་ལེན་དུ་ཡོང༌ངོ༌། །རིབ་ཀཱ་ནི་པཱ་ཐུ་ཨེལ་གྱི་བུ་མོ་ཡིན༌ནོ། །པཱ་ཐུ་ཨེལ་ནི་མིལ་ཀཱ་ཡི་བུ་ཡིན༌ལ། མིལ་ཀཱ་ནི་ཨབ་ར་ཧམ་གྱི་གཅུང་པོ་ནཱ་ཧོར་གྱི་ཆུང་མ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","བུ་མོ་དེ་ནི་ཤིན་ཏུ་མཛེས་ཤིང་ལྟ་ན་སྡུག་པ་དང་སྐྱེས་པ་སུ་ལའང་འགྲོགས་མ་མྱོང་བ་ཞིག་ཡིན༌ནོ། །བུ་མོ་དེ་མར་ཁྲོན་པའི་འགྲམ་དུ་སོང་ནས་ཆུ་ཟོར་ཆུ་བཅུས་ཏེ་ཕྱིར་ཐོན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","དེ་ནས་གཡོག་པོ་བུ་མོའི་མདུན་དུ་བརྒྱུགས་ཏེ་ན༌རེ། ཁྱོད་ཀྱིས་ཆུ་ཟོ་ནང་གི་ཆུ་དེ་བདག་ལ་འཐུང་བར་མཛོད་ཅིག་ཅེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","བུ་མོ་ན༌རེ། བདག་གི་ཇོ་བོ༌ལགས། ཁྱེད་ཀྱིས་འཐུང་བར་མཛོད་ཅེས་སྨྲ་བཞིན་ཆུ་ཟོ་མྱུར་དུ་མར་བླངས་ཤིང་ལག་པས་ཡར་བཏེགས་ནས་ཁོ་ལ་འཐུང་དུ༌བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","བུ་མོས་ཁོ་ལ་ཆུ་འཐུང་དུ་བཅུག་རྗེས་ན༌རེ། ངས་ཆུ་བླངས་ཏེ་ཁྱེད་ཀྱི་རྔ་མོང་ལའང་ཆུ་བླུད་ནས་འགྲང་བར་བྱེད་ཅེས་སྨྲས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ཁོ་མོས་ཆུ་ཟོ་ལས་ཆུ་གཞོང་ནང་དུ་ཆུ་བླུགས་ཤིང་སླར་ཡང་ཁྲོན་པར་ཆུ་ལེན་དུ་སོང་བ༌དང༌། རྔ་མོང་ཐམས་ཅད་ལ་ཆུ་ལྡུད་པའི་ཕྱིར་ཆུ༌བླངས། ");
INSERT INTO bodn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","སྐབས༌དེར། གཡོག་པོས་སྐད་ཆ་ཅི་ཡང་མ་སྨྲས༌པར། དཀོན་མཆོག་ཡ་ཝཱེས་རང་གི་མཛད་དོན་ལེགས་པར་མཛད་དོ་སྙམ་སྟེ་བུ་མོ་དེར་མིག་གིས་ཡང་ཡང༌བལྟས། ");
INSERT INTO bodn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","དེ་ནས་རྔ་མོང་དག་ཆུས་ངོམས་པ༌དང༌། གཡོག་པོས་ལྗིད་ཚད་སྲང་ཕྱེད་ ཙམ་གྱི་གསེར་གྱི་སྣ་ཆ་གཅིག༌དང༌། སྲང་བཅུ་ཡོད་པའི་གསེར་གྱི་གདུབ་བུ་ཆ་གཅིག་བླངས་ནས་བུ་མོ་དེར་སྤྲད་དེ་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","བདག་ལ་ཤོད༌དང༌། ཁྱོད་ནི་སུ་ཚང་གི་བུ་མོ་ཡིན༌ནམ། ཁྱོད་ཀྱི་ཕ་གཞིས་སུ་ངེད་ཅག་ལ་སྡོད་གནས་ཡོད་དམ་མེད་ཅེས་དྲིས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","བུ་མོ་ན༌རེ། བདག་ནི་ནཱ་ཧོར་དང་མིལ་ཀཱ་གཉིས་ཀྱི་བུ་པཱ་ཐུ་ཨེལ་ཞེས་པའི་བུ་མོ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ཡང་ཁོ་མོ་ན༌རེ། ངེད་ཀྱི་ཡུལ་དུ་གཟན་ཆས་དང་རྩྭ་མོད་པོ་ཡོད་ལ་སྡོད་གནས་ཀྱང་མང་པོ་ཡོད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","དེ་ནས་གཡོག་པོས་མགོ་སྨད་དུ་བསྒུར་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕྱག་བྱས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ཀྱེ། ང་ཡི་བདག་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་ཅིང་བསྔགས་པར༌བྱའོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁོང་གིས་ང་ཡི་བདག་པོ་ལ་བཅངས་པའི་བྱམས་སྙིང་རྗེ་དང་དྲང་བདེན་ནི་ནམ་ཡང་དོར་མ་མྱོང་བའི་ཕྱིར༌རོ། །བདག་ལ་མཚོན༌ན། དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་ལ་ལམ་བསྟན༌ཏེ། ང་ཡི་བདག་པོའི་སྤུན་ཟླའི་ཁྱིམ་དུ་ཐད་ཀར་ཁྲིད་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","དེ་ནས་བུ་མོ་ཡུལ་དུ་བརྒྱུགས་ཏེ་ཁོ་མོའི་ཡུམ་དང་ཡུམ་གྱི་ཁྱིམ་མི་རྣམས་ལ་གཏམ་དེ་དག་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","དེ་ཡང་བུ་མོ་རིབ་ཀཱ་ཞེས་བྱ་བར་གཅེན་པོ་ཞིག་ཡོད་པའི་མིང་ལ་ལཱ་པན་ཞེས༌ཟེར། ཁོས་གསེར་གྱི་སྣ་ཆ་དང་སྲིང་མོའི་ལག་མགོའི་གསེར་གྱི་གདུབ་བུ་གཉིས་མཐོང་བ༌དང༌། ཁོ་མོས་བཤད་པ་ལྟར་མི་དེས་ཁོ་མོ་ལ་ཅི་ལྟར་སྨྲས་པ་སོགས་ཀྱི་སྐད་ཆ་ཐོས༌རྗེས། ཁོ་རང་ཡང་ཁྲོན་པའི་ཕྱོགས་སུ་བརྒྱུགས་ནས་མི་དེའི་གམ་དུ་སླེབས་པ༌དང༌། རྔ་མོང་གི་འགྲམ་དུ་ཡོད་པའི་མི་དེ་ད་དུང་ཁྲོན་པའི་གནས་དེར་ལངས་ནས་བསྡད་ཡོད་པ་མཐོང་སྟེ་ན༌རེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ཁྱོད་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་བྱིན་རླབས་ཐོབ༌ཅིང༌། ཁྱོད་རང་ཁྱིམ་དུ་ཕེབས་པར༌ཞུ། ཕྱི་རུ་འདུག་དགོས་དོན༌མེད། ངས་ཁང་པ་གད་བདར་བྱས་ཚར་བ༌དང༌། རྔ་མོང་འདོགས་སའང་སྟ་གོན་བྱས་ཡོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","དེ་ལྟར་མི་དེའང་ལཱ་པན་གྱི་ཁྱིམ་དུ་སོང་ཞིང་། ལཱ་པན་གྱིས་རྔ་མོང་རྒྱབ་ཀྱི་ཁུར་པོ་མར་ཕོག་པ༌དང༌། རྔ་མོང་དག་ལ་གཟན་ཆས་དང་རྩྭ་བྱིན༌ཅིང༌། མི་དེ་རྣམས་ལ་རྐང་པ་བཀྲུ་བྱེད་ཀྱི་ཆུ་བླུགས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","མདུན་དུ་ཟས་བཤམས་པ་དང་ཟས་བཞེས་པར་གྱིས་ཞེས་སྨྲས་ཀྱང་མི་དེ་ན༌རེ། ངས་ཟས་མི༌བཟའོ། །ངས་ཐོག་མར་རང་གི་དོན་དག་གསལ་པོར་སྨྲས༌རྗེས་ད་གཟོད་ཟས་བཟའ་བར་བྱ་ཞེས་སྨྲས་པ༌དང༌། ལཱ་པན་ན༌རེ། དེས་ན་ཁྱོད་ཀྱིས་རང་གི་དོན་དག་བརྗོད་པར་གྱིས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","དེ་ནས་ཁོ་ན༌རེ། བདག་ནི་ཨབ་ར་ཧམ་གྱི་གཡོག་པོ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","དཀོན་མཆོག་ཡ་ཝཱེས་ང་ཡི་བདག་པོ་ལ་བྱིན་རླབས་ཆེན་པོ་གནང་སྟེ་ཁོང་ལ་ར་ལུག་དང་བ༌གླང་གི་ཁྱུ། གསེར་དང༌དངུལ། གཡོག་པོ་དང་གཡོག༌མོ། རྔ་མོང་དང་བོང་བུ་བཅས་ཐོབ་ཅིང་ཆེས་ཆེར་ཕྱུག་པོར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ང་ཡི་བདག་པོའི་ཆུང་མ་སཱ་ར་ཡིས་དགུང་ལོ་མཐོ་བའི་དུས་སུ་བདག་པོར་བུ་ཞིག་བཙས་ཤིང་བདག་པོས་རྒྱུ་ནོར་ཐམས་ཅད་བུ་དེ་ལ་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","དེ་ནས་ངས་རང་གི་བདག་པོ་ལ་དམ་བཅའ་འཇོག་དགོས་པར་ཁོང་གིས་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་ང་རང་སྡོད་པའི་ཡུལ་འདི་ནས་བདག་གི་བུ་ལ་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་ཞིག་ཆུང་མར་ལེན་པར་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ཁྱོད་རང་བདག་གི་ཕ་གཞིས་དང་བདག་གི་གཉེན་ཉེའི་གམ་དུ་སོང༌སྟེ། ངའི་བུ་ཨི་སཱག་ལ་ཆུང་མ་ཞིག་ལེན་དགོས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","དེ་ནས་ངས་འདི༌ལྟར། བུ་མོ་དེ་བདག་དང་མཉམ་དུ་གནས་འདིར་མི་ཡོང་ན་ཅི་བྱའམ་ཞེས་དྲིས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","བདག་པོ་ན༌རེ། བདག་གིས་ཞབས་ཏོག་བསྒྲུབས་པའི་དཀོན་མཆོག་ཡ་ཝཱེས་ངེས་པར་རང་ཉིད་ཀྱི་ཕོ་ཉ་མངགས་ཏེ་ཁྱོད་དང་མཉམ་དུ་འགྲོ་བ་དང་ཁྱོད་ཀྱི་བགྲོད་ལམ་བདེ་བར་མཛད༌ཅིང༌། ཁྱོད་རང་བདག་གི་ཕ་གཞིས་དང་བདག་གི་གཉེན་ཉེའི་གམ་དུ་སོང༌སྟེ། ངའི་བུ་ཨི་སཱག་ལ་ཆུང་མ་ཞིག་ལེན་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ཁྱོད་རང་བདག་གི་གཉེན་ཉེའི་གམ་དུ་སླེབས་པ༌ན། གལ༌སྲིད། དེ་རྣམས་ཀྱིས་བུ་མོ་དེ་ཁྱོད་ལ་མི་སྟེར༌ན། བདག་གིས་ཁྱོད་ལ་འཇོག་ཏུ་བཅུག་པའི་དམ་བཅའ་ནི་ཁྱོད་དང་འབྲེལ་བ་ཅི་ཡང་མེད་ཅེས་གསུངས་མྱོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","དེ་རིང་བདག་ཁྲོན་པའི་འགྲམ་དུ་སླེབས་ཏེ། ཀྱེ། དཀོན་མཆོག་ཡ༌ཝཱེ། ང་ཡི་བདག་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག༌ལགས། ཁྱེད་ཀྱིས་བདག་གི་དོན་འདི་ལེགས་པར་བསྒྲུབ་ཏུ༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ད་ལྟ་ང་རང་ཁྲོན་པའི་འགྲམ་དུ་ཡོད༌ཅིང༌། ངས་ཆུ་ལེན་བུ་མོ་ལ་འདི་ལྟར་སྨྲ༌སྟེ། ཁྱོད་ཀྱི་ཆུ་ཟོ་ལས་བདག་ལ་ཆུ་གནང་བར་མཛོད་ཅེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","བུ་མོ་ན༌རེ། ལགས༌སོ། །ཁྱོད་ཀྱིས་ཐུངས༌ཤིག ངས་ཁྱོད་ཀྱི་རྔ་མོང་ལའང་ཆུ་ལྡུད་པར་བྱ་ཞེས་སྨྲས༌ན། བུ་མོ་དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ང་ཡི་བདག་པོའི་བུ་ལ་ཆུང་མར་བསྐོས་པ་ཡིན་པར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ངའི་སེམས་ནས་དེ་བཞིན་གསོལ་བ་བཏབ་མ་ཚར་སྔོན༌ལ། བུ་མོ་རིབ་ཀཱས་ཕྲག་ལ་ཆུ་ཟོ་ཁུར་ནས་མར་ཁྲོན་པའི་འགྲམ་དུ་སོང་བ་དང་ཆུ་ཟོར་ཆུ་བཅུས༌ཤིང༌། ངས་ཁོ་མོར་འདི་ལྟར་སྨྲས་པ༌སྟེ། ཁྱོད་ཀྱིས་བདག་ལ་ཆུ་གནང་བར་མཛོད་ཅེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ཁོ་མོས་བྲེལ་འཚབ་ངང་ནས་ཆུ་ཟོ་ཕྲག་ལས་མར་བླངས་ཤིང་ཁྱེད་ཀྱིས་ཐུངས༌ཤིག ངས་ཁྱེད་ཀྱི་རྔ་མོང་ལའང་ཆུ་ལྡུད་པར་བྱ་ཞེས་སྨྲས་པ༌དང༌། བདག་གིས་ཆུ་འཐུང་བ་དང་ཁོ་མོས་བདག་གི་རྔ་མོང་དག་ལའང་ཆུ་འཐུང་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","དེ་ནས་བདག་གིས་ཁོ་མོར་ཁྱོད་སུ་ཚང་གི་བུ་མོ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། ཁོ་མོ་ན༌རེ། བདག་ནི་ནཱ་ཧོར་དང་མིལ་ཀཱ་གཉིས་ཀྱི་བུ་པཱ་ཐུ་ཨེལ་ཞེས་པའི་བུ་མོ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། དེ་ནས་ངས་གསེར་གྱི་སྣ་ཆ་ཁོ་མོའི་སྣ་ལ་བཏགས་པ༌དང༌། གསེར་གྱི་གདུབ་བུ་གཉིས་ཀྱང་ཁོ་མོའི་ལག་པ་གཉིས་ལ་བསྐོན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","དེའི༌རྗེས། ངས་མགོ་སྨད་དུ་བསྒུར་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕྱག་བྱས༌ཏེ། ང་ཡི་བདག་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་ལ་བསྟོད་ཅིང་བསྔགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁོང་གིས་བདག་འོས་ཤིང་འཚམ་པའི་ལམ་དུ་ཁྲིད༌ཅིང༌། ང་ཡི་བདག་པོའི་གཉེན་ཉེའི་བུ་མོ་ནི་ཁོང་གི་བུ་ལ་ཆུང་མར་མཛད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ཁྱེད་རྣམས་ཀྱིས་ང་ཡི་བདག་པོ་ལ་བྱམས་སྙིང་རྗེ་དང་བློས་ཐུབ་སེམས་ཀྱིས་སྣེ་ལེན་བྱ་འདོད༌ན། ད་ལྟ་བདག་ལ་སྨྲ་བར༌བྱའོ། །གལ་ཏེ་ཁྱེད་རྣམས་མི་འཐད་ནའང་བདག་ལ་དྲང་པོར་སྨྲ་བར༌མཛོད། བདག་གིས་ཅི་ཞིག་བྱེད་དགོས་པ་ཐག་གིས་གཅོད་དགོས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","དེ་ནས་པཱ་ཐུ་ཨེལ་དང་ལཱ་པན་གཉིས་ཀྱིས་ལན་འདི་ལྟར་བཏབ་པ༌སྟེ། དོན་འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལས་བྱུང་བ་ཡིན༌པས། ངེད་རྣམས་ཀྱིས་ཁྱོད་ལ་བཟང་ངན་ཅི་ཡང་སྨྲ་མི་ནུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ལྟོས༌དང༌། བུ་མོ་རིབ་ཀཱ་ཁྱོད་ཀྱི་མིག་མདུན་དུ་ཡོད༌དེ། ཁྱོད་ཀྱིས་ཁོ་མོ་ཁྲིད་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པ༌བཞིན། ཁྱོད་ཀྱི་བདག་པོའི་བུ་ལ་ཆུང་མ་བྱེད་པར་མཛོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","དེ་ནས་ཨབ་ར་ཧམ་གྱི་གཡོག་པོས་མི་དེ་གཉིས་ཀྱི་གཏམ་ཐོས་པ་དང་པུས་མོ་སར་བཙུགས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕྱག་བཙལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","གཡོག་པོས་གསེར་དངུལ་གྱི་རྒྱན་ཆ་དང་རྒྱན་གོས་བཅས་བུ་མོ་རིབ་ཀཱ་ལ་སྤྲད་པ༌དང༌། བུ་མོ་རིབ་ཀཱའི་ཡུམ་དང་གཅེན་པོ་ལའང་ནོར་རྫས་གཞན་དག་ཕུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","དེ་ནས་གཡོག་པོ་དང་ཁོའི་འཁོར་གཡོག་རྣམས་ཀྱིས་མཉམ་དུ་བཟའ་བཏུང་ལོངས་སུ་སྤྱད་ཅིང་ཞག་གཅིག་ལ༌བསྡད། ཕྱི་ཉིན་ཞོགས་པ་ཡར་ལངས༌ཏེ། གཡོག་པོ་ན༌རེ། ངེད་རྣམས་རང་གི་བདག་པོའི་དྲུང་དུ་འགྲོ་བར་མཛོད་ཅེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","བུ་མོ་རིབ་ཀཱའི་ཡུམ་དང་གཅེན་པོ་ན༌རེ། བུ་མོ་ངེད་རྣམས་དང་མཉམ་དུ་ཉིན་འགར་འདུག་པར༌གྱིས། མ་མཐའ་ཡང་ཉིན་བཅུ་ལ་སྡོད་པར༌བྱ། དེའི་རྗེས་སུ་ཁོ་མོ་སོང་ཆོག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ཡང་གཡོག་པོ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བདག་ལ་འགྲོ་ལམ་ལེགས་པར་མཛད༌པས། ཁྱེད་རྣམས་ཀྱིས་དལ་འགོར་མི་བྱ༌བར། ངེད་རྣམས་རང་གི་བདག་པོའི་དྲུང་དུ་འགྲོ་བར་མཛོད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ཡང་ཁོ་རྣམས་ན༌རེ། འོ༌ན། ངེད་ཅག་གིས་བུ་མོ་བོས་ཏེ་དྲི་བར་བྱ་ཞེས་སྨྲས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","བུ་མོ་རིབ་ཀཱ་བོས་ནས་འདི༌ལྟར། ཁྱོད་ནི་མི་འདི་དང་མཉམ་དུ་འགྲོའམ་ཞེས་དྲིས་པ༌ལ། བུ་མོ་རིབ་ཀཱ་ན༌རེ། ང་རང་འགྲོ་རྒྱུ་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","དེའི༌ཕྱིར། ཁོ་རྣམས་ཀྱིས་བུ་མོ་རིབ་ཀཱ་དང་ཁོ་མོའི་ཉེ་བའི་མ་མ་སོགས་ཨབ་ར་ཧམ་གྱི་གཡོག་པོ་དང་མཉམ་དུ་འགྲོ་རུ་བཅུག༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","འདི་ལྟར་སྨོན་འདུན་ཞུས་པ༌སྟེ། ཀྱེ་ཀྱེ་ང་ཚོའི་སྲིང་མོ༌ལགས།། ཁྱོད་ནི་ཀུན་གྱི་མ་རུ༌མཛོད།། ཁྱོད་ཀྱི་བུ་རྒྱུད་དེ་ཡིས་ནི།། དགྲ་བོའི་མཁར་ཡང་འཛིན་པར༌ཤོག །ཅེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","དེ་ནས་བུ་མོ་རིབ་ཀཱ་དང་ཁོ་མོའི་གཡོག་མོ་རྣམས་ཡར་ལངས་ནས་རྔ་མོང་ལ་ཞོན་པ༌དང༌། ཨབ་ར་ཧམ་གྱི་གཡོག་པོའི་རྗེས་སུ་འབྲངས་ཤིང་གཡོག་པོས་ཀྱང་བུ་མོ་རིབ་ཀཱ་ཁྲིད་ནས་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","སྐབས༌དེར། ཨི་སཱག་ནི་ནེ་གུབ་ཡུལ་དུ་བཞུགས༌ཤིང༌། ཁོ་རང་པེར་ལཱ་ཧེད་རོའུ་ཞེས་པའི་ཆུ་མིག་ཅེས་པ་ནས་ཡོང་མ་ཐག༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ས་རུབ་ལ་ཉེ་བའི་དུས༌སུ། ཁོ་རང་ཐང་དཀྱིལ་ཞིག་ཏུ་སོང་ནས་བསམ་བློ་གཏོང་བཞིན་བསྡད༌ཅིང༌། ཁོས་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། རྔ་མོང་ལ་བཞོན་མཁན་འགའ་ཤས་ཡོང་བཞིན་པ༌མཐོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","བུ་མོ་རིབ་ཀཱས་ཀྱང་མགོ་ཡར་བཀྱགས་ནས་ཨི་སཱག་མཐོང་བ་དང་མྱུར་དུ་རྔ་མོང་ལས་མར་བབས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ཐང་དཀྱིལ་ནས་རང་ཅག་རྣམས་བསུ་བར་ཡོང་བའི་མི་དེ་སུ་ཡིན་ནམ་ཞེས་གཡོག་པོ་ལ་དྲིས་པ༌དང༌། གཡོག་པོ་ན༌རེ། དེ་ནི་ང་ཡི་བདག་པོ་ཡིན་ཞེས་ལན་བཏབ་པ༌དང༌། བུ་མོ་རིབ་ཀཱས་གདོང་ཁེབས་བླངས་ནས་རང་གི་ཞལ་རས༌བཀབ། ");
INSERT INTO bodn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","དེ་ནས་གཡོག་པོས་རང་གིས་བསྒྲུབས་པའི་ལས་ཐམས་ཅད་ཨི་སཱག་ལ་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ཨི་སཱག་གིས་བུ་མོ་རིབ་ཀཱ་ཁྲིད་ནས་ཁོང་གི་འདས་ཟིན་པའི་ཡུམ་སཱ་རའི་སྦྲ་གུར་ནང་དུ་སོང༌ཞིང༌། བུ་མོ་རིབ་ཀཱ་རང་གི་ཆུང་མར་བླངས་པ་དང་ཁོ་མོར་ཤིན་ཏུ་གཅེས༌སོ། །དེ་ལྟར་རང་གི་ཡུམ་ཚེ་ལས་འདས་པའི་མྱ་ངན་ལས་ཁོང་ལ་ད་གཟོད་སེམས་གསོ་ཐོབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","དེ་ནས་ཡང་ཨབ་ར་ཧམ་གྱིས་མིང་ལ་ཀེ་ཏི་རཱ་ཞེས་བྱ་བ་རང་གི་ཆུང་མར་བླངས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ཁོ་མོས་ཟིམ་རན༌དང༌། ཡོག༌ཤན། མཱ༌དན། མིད༌ཡཱན། ཡེས༌པག ཤུ་ཨག་བཅས་བུ་དྲུག་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","དེ་ཡང་ཡོག་ཤན་ལ་བུ་ཤེ་བཱ་དང་དི་དན་གཉིས་སྐྱེས༌སོ། །བུ་དི་དན་ལས་ཨ་ཤུར་མི་རིགས༌དང༌། ལཱ་ཐུ་མི༌རིགས། ལཱ་ཨུམ་མི་རིགས་གསུམ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","དེ་ཡང་མིད་ཡཱན་ལ་ཨེ་ཕཱ༌དང༌། ཨེ༌ཕེར། ཧ༌ནོག ཨ་བི༌དཱ། ཨེལ་དཱ་ཨ་བཅས་བུ་ལྔ་སྐྱེས༌སོ། །དེ་ཐམས་ཅད་ནི་ཀེ་ཏི་རཱ་ཡི་བུ་རབས་ཚ་རྒྱུད་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","དེ་ཡང་ཨབ་ར་ཧམ་གྱིས་རང་ལ་ཅི་ཡོད་པ་ཐམས་ཅད་བུ་ཨི་སཱག་ལ་གནང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ཆུང་མ་གཞན་དག་གི་བུ་རྣམས་ལའང་གནང་སྦྱིན་ཐོབ༌བོ། །རང་ཉིད་ཚེ་ལས་མ་འདས་པའི་སྔོན་ལ་ཁོ་རྣམས་རང་གི་བུ་ཨི་སཱག་དང་ཁ་བྲལ་ནས་ཤར་ཕྱོགས་ཡུལ་དུ་འགྲོ་བར་བསྐུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","དེ་ཡང་ཨབ་ར་ཧམ་བསྡོམས་པས་ལོ་བརྒྱ་དང་དོན་ལྔར་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ཁོང་དགུང་ལོ་མཐོ་ཞིང་ལོ་ན་རྒས་ཏེ་ཚེ་ལོ་མཐར་ཕྱིན་ནས་སྐུ་གཤེགས་པ་དང་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཛོམས་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ཨབ་ར་ཧམ་གྱི་བུ་ཨི་སཱག་དང་ཡེས་མ་ཨེལ་གཉིས་ཀྱིས་ཁོང་གི་སྐུ་གདུང་མཱག་ཕེ་ལཱ་བྲག་ཁུང་དུ་དུར་ལ་སྦས༌སོ། །བྲག་ཁུང་དེ་ནི་མཱན་རེའེ་ཡུལ་གྱི་མདུན་ཕྱོགས༌དང༌། ཧེ་བི་མི་རིགས་ཀྱི་ཚོ་ཧར་ཞེས་བྱ་བའི་བུ་ཨེབ་རོན་གྱི་ཞིང་ནང་དུ༌ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","དེ་ནི་ཨབ་ར་ཧམ་གྱིས་ཧེད་ཀྱི་བུ་རྒྱུད་ལས་ཉོས་པའི་ས་ཞིང་དེ་ཡིན༌ལ། གནས་དེ་རུ་ཨབ་ར་ཧམ་དང་ཁོང་གི་ཆུང་མ་སཱ་ར་གཉིས་ཀྱི་སྐུ་གདུང་དུར་ལ་སྦས་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ཨབ་ར་ཧམ་སྐུ་གཤེགས༌རྗེས། དཀོན་མཆོག་གིས་ཁོང་གི་བུ་ཨི་སཱག་ལ་བྱིན་རླབས་གནང་བ༌དང༌། ཨི་སཱག་ནི་པེར་ལཱ་ཧེད་རོའུ་ཞེས་པའི་ཆུ་མིག་གི་ཡུལ་དུ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","དེ་ཡང་སཱ་རའི་གཡོག་མོ་སྟེ་ཨེ་ཅིབ་ཀྱི་བུད་མེད་ཧ་གར་གྱིས་ཨབ་ར་ཧམ་ལ་བཙས་པའི་བུ་ཡེས་མ་ཨེལ་གྱི་རིགས་རྒྱུད་ནི་འདི་ལྟ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ཡེས་མ་ཨེལ་གྱི་བུ་སྐྱེས་འགོ་ནི་ནཱ་བ་ཨོད༌དང༌། དེ་ནས་ཀེ་དཱར༌དང༌། ཨད་པཱ༌ཨེལ། མིབ༌སཱམ། ");
INSERT INTO bodn_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","མུས༌མཱ། དུའུ༌མཱ། མཱ༌ས། ");
INSERT INTO bodn_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ཧ༌དཱད། ཐེ༌མཱ། ཡཱ༌ཐར། ནཱ༌ཕིས། ཀད་མཱ་བཅས་བཅུ་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","དེ་རྣམས་ནི་ཡེས་མ་ཨེལ་གྱི་བུ་དག་གི་མིང་ཡིན༌ལ། ཁོ་རྣམས་ནི་གྲོང་སྡེ་དང་ཚོ་པ་བཅུ་གཉིས་ལྟར་ཚོ་དཔོན་བཅུ་གཉིས་ཀྱང་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ཡེས་མ་ཨེལ་དགུང་ལོ་བརྒྱ་དང་སོ་བདུན་ལ་བཞུགས་ཤིང་ལོ་ན་རྒས་ཏེ་ཚེ་ལས་འདས་པ་དང་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཛོམས་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ཁོའི་བུ་རབས་ཚ་རྒྱུད་ཀྱི་སྡོད་གནས་ནི་ཨེ་ཅིབ་ཡུལ་གྱི་ཤར་ཕྱོགས༌ཏེ། ཨ་སུར་ཡུལ་དུ་འགྲོ་བའི་ཧ་བེ་ལཱ་ཡུལ་ནས་ཤུར་ཞེས་པའི་ཡུལ་གྱི་བར་དུ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","དེ་ཡང་ཨབ་ར་ཧམ་གྱི་བུ་ཨི་སཱག་གི་རིགས་རྒྱུད་ནི་འདི་ལྟ༌སྟེ། ཨབ་ར་ཧམ་ལས་བུ་ཨི་སཱག་སྐྱེས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ཨི་སཱག་གིས་རིབ་ཀཱ་ཆུང་མར་ལེན་པའི་དུས༌སུ། ཁོ་དགུང་ལོ་བཞི་བཅུ་ཡིན༌ཞིང༌། རིབ་ཀཱ་ནི་ཕཱ་དན་ཨ་རམ་ཡུལ་གྱི༌ཆར། ཨ་རམ་མི་རིགས་ཀྱི་པཱ་ཐུ་ཨེལ་གྱི་བུ་མོ༌དང༌། ཨ་རམ་མི་རིགས་ཀྱི་ལཱ་པན་གྱི་སྲིང་མོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","དེ་ཡང་ཨི་སཱག་གི་ཆུང་མ་ནི་མོ་གཤམ་ཡིན༌པས། ཨི་སཱག་གིས་ཁོ་མོའི་ཆེད་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་བཏབ༌ཅིང༌། དཀོན་མཆོག་ཡ་ཝཱེས་ཀྱང་གསོལ་བ་བཏབ་པ་ལྟར་མཛད༌པས། ཁོའི་ཆུང་མ་རིབ་ཀཱར་མངལ་ཆགས་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","དེ་ཡང་རིབ་ཀཱའི་མངལ་དུ་མཚེ་མ་ཞིག་ཕན་ཚུན་འཇུ་རེས་བྱས༌པས། ཁོ་མོ་ན༌རེ། དོན་འདི་ཅིའི་ཕྱིར་བདག་གི་ལུས་སྟེང་དུ་བྱུང་ངམ་ཞེས་སྨྲས་ཤིང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྐྱབས་སུ༌རེའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་མངལ་ལས་རིགས་རྒྱུད༌གཉིས།། ངེས་པར་འབྱུང་ཞིང་མི་རིགས༌གཉིས།། དེ་བཞིན་འབྱུང་བས་དེ་གཉིས༌ནི།། གཅིག་ལས་གཅིག་རྒྱལ་མཐའ་མའི༌དུས།། ཆེ་བས་ཆུང་བར་ཞབས་ཕྱི༌འགྱུར། །ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","དེ་ཡང་བུ་བཙའ་བའི་དུས་ལ་སླེབས་པ་དང་ཁོ་མོའི་མངལ་དུ་དངོས་གནས་མཚེ་མ་ཞིག་མཆིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ཐོག་མར་བཙས་པའི་བུ་ཡི་ལུས་པོ་ནི་ཁ་དོག་དམར་པོ་ཡིན་པ་དང་ལུས་ཡོངས་སུ་བ་སྤུས་གང་སྟེ་ལྤགས་པ་ཞིག་དང་མཚུངས༌ཤིང༌། བུ་དེའི་མིང་ལ་ཨེ་སཱབ་ཅེས་བཏགས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","བུ་ཨེ་སཱབ་ལ་སྤུན་ཞིག་བཙས་པ༌ན། དེ་ཡི་ལག་པས་ཨེ་སཱབ་ཀྱི་རྐང་པའི་ཕྱི་རྟིང་ནས་བཟུང་འདུག༌པས། བུ་དེའི་མིང་ལ་ཡ་ཀོབ་ ཅེས༌བཏགས། དེ་ལྟར་རིབ་ཀཱས་བུ་གཉིས་བཙའ་བའི་དུས༌སུ། ཨི་སཱག་དགུང་ལོ་དྲུག་ཅུ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","དེ་ནས་བུ་གཉིས་རིམ་གྱིས་ནར་སོན་པ་དང་བུ་ཆེ་བ་ཨེ་སཱབ་ནི་རི་དྭགས་རྔོན་པར་མཁས་ཤིང་རྟག་ཏུ་དབེན་སྟོང་དུ་མཆིས་པ༌དང༌། བུ་ཆུང་བ་ཡ་ཀོབ་ནི་གཤིས་རྒྱུད་དུལ་བས་ནམ་རྒྱུན་སྦྲ་གུར་དུ་སྡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ཨི་སཱག་གིས་ཨེ་སཱབ་ལ་གཅེས་པར༌བྱེད། ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་ནི་རྟག་ཏུ་རི་དྭགས་ཀྱི་ཤ་བཟའ་བར་དགའ་བའི་ཕྱིར༌ཡིན། འོན་ཀྱང་ཡུམ་རིབ་ཀཱས་ནི་ཡ་ཀོབ་ལ་གཅེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ཉིན་ཞིག༌ལ། ཡ་ཀོབ་ཀྱིས་སྲན་ཁུ་ཞིག་བསྐོལ་ནས་སྡོད་པ༌ལ། ཨེ་སཱབ་དབེན་སྟོང་ནས་ཐོན་ཞིང་ལུས་ཐང་ཆད་དེ་བརྒྱལ་ལ༌ཉེའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","དེ་ནས་ཨེ་སཱབ་ཀྱིས་ཡ་ཀོབ་ལ་འདི༌ལྟར། ང་རང་ལུས་ཐང་ཆད་ནས་བརྒྱལ་ལ༌ཉེ། ཁྱོད་ཀྱིས་སྲན་ཁུ་དམར་པོ་དེ་བདག་ལ་གནང་བར་མཛོད་ཅིག་ཅེས་བརྗོད་པའི༌ཕྱིར། ཨེ་སཱབ་ཀྱི་མིང་ལ་ཨེ་དོམ་ ཞེས་ཀྱང་ཐོགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","དེ་ནས་ཡ་ཀོབ་ན༌རེ། དེ་རིང་ཁྱོད་ཀྱིས་བུ་ཆེ་བའི་ཐོབ་ཐང་ བདག་ལ་བཙོང་བར་མཛོད་ཅེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ཨེ་སཱབ་ན༌རེ། བདག་ནི་འཆི་ལ་ཉེ་བས་བུ་ཆེ་བའི་ཐོབ་ཐང་འདི་བདག་ལ་མཚོན་ན་ཕན་ཐོགས་ཅི་ཞིག་ཡོད་དམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ཡང་ཡ་ཀོབ་ན༌རེ། ཁྱོད་ཀྱིས་དེ་རིང་བདག་ལ་དམ་བཅའ་འཇོག་པར་གྱིས་ཞེས་སྨྲས་པ༌ན། ཨེ་སཱབ་ཀྱིས་ཀྱང་ཁོ་ལ་དམ་བཅས་ཏེ་བུ་ཆེ་བའི་ཐོབ་ཐང་དེ་ཡ་ཀོབ་ལ་བཙོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","དེའི༌ཕྱིར། ཡ་ཀོབ་ཀྱིས་ཨེ་སཱབ་ལ་བག་ལེབ་དང་སྲན་ཁུ་ཕུལ་བ༌དང༌། ཨེ་སཱབ་ཀྱིས་ཀྱང་བཟའ་བཏུང་སྤྱད་རྗེས་ཡར་ལངས་ནས་སོང༌ངོ༌། །དེ་ལྟར་ཨེ་སཱབ་ཀྱིས་བུ་ཆེ་བའི་ཐོབ་ཐང་ལ་མཐོང་ཆུང་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","དེ་ཡང་ཨབ་ར་ཧམ་གྱི་དུས༌སུ། ཡུལ་དེར་མུ་གེ་བྱུང་མྱོང་བ་དང་དུས་འདིར་ཡང་མུ་གེ་བྱུང༌བས། ཨི་སཱག་ཅེས་བྱ་བ་གེ་རཱར་གྲོང་ཁྱེར་དང་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱི་རྒྱལ་པོ་ཨ་བི་མེ་ལེག་གི་དྲུང་དུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","དཀོན་མཆོག་ཡ་ཝཱེས་ཨི་སཱག་ལ་མངོན་པར་མཛད་དེ་འདི་སྐད༌དུ། ཁྱོད་མར་ཨེ་ཅིབ་ཡུལ་དུ་འགྲོ་བར་མི༌བྱའོ། །བདག་གིས་ཁྱོད་ལ་སྟོན་པར་འགྱུར་བའི་ཡུལ་དེ་རུ་སྡོད༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ད་ལྟ་ཁྱོད་རང་ཡུལ་འདིར་བསྡད༌ན། བདག་ནི་ངེས་པར་ཁྱོད་དང་མཉམ་དུ་གནས་ཤིང་ཁྱོད་ལ་བྱིན་རླབས་གནང༌ངོ༌། །ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་ཡུལ་འདི་ཐམས་ཅད་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་སྦྱིན་ངེས་པའི་ཕྱིར༌རོ། །བདག་གིས་ཁྱོད་ཀྱི་ཡབ་ཨབ་ར་ཧམ་ལ་བཞག་པའི་དམ་བཅའ་བཞིན་བྱེད་པར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","བདག་གིས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ནི་ནམ་མཁའི་སྐར་མ་ཇི་བཞིན་མང་དུ་སྤེལ་བ༌དང༌། ས་ཆ་འདི་དག་ཀྱང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་སྦྱིན་པར་མ༌ཟད། ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལའང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་བརྒྱུད་ནས་བྱིན་རླབས་འཐོབ་པར༌འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ཅིའི་ཕྱིར་ཞེ༌ན། ཨབ་ར་ཧམ་གྱིས་བདག་གི་གསུང་ལ་མཉན་པ་དང་། བདག་གི་མན་ངག༌དང༌། བཀའ༌རྒྱ། སྒྲིག་ཁྲིམས། བཀའ་ཁྲིམས་བཅས་བསྲུངས་པའི་ཕྱིར་རོ་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","དེའི༌ཕྱིར། ཨི་སཱག་ནི་གེ་རཱར་གྲོང་ཁྱེར་དུ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","དེ་ནས་ཡུལ་དེའི་མི་རྣམས་ཀྱིས་ཨི་སཱག་ལ་ཁོའི་ཆུང་མའི་སྐོར་དྲིས་པ༌ན། ཨི་སཱག་ན༌རེ། ཁོ་མོ་བདག་གི་སྲིང་མོ་ཡིན་ནོ་ཞེས་སྨྲས༌ཤིང༌། དེ་ནི་བདག་གི་ཆུང་མ་ཡིན་ཞེས་བརྗོད་པར་འཇིགས་པ༌དང༌། ཁོའི་སེམས་སུ་རིབ་ཀཱ་ནི་བུད་མེད་མཛེས་མ་ཞིག་ཡིན་པའི༌ཕྱིར་དེ་དག་གིས་རང་ཉིད་གསོད་ངེས་ཡིན་སྙམ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ཁོ་རང་ཡུལ་དེ་རུ་ཡུན་རིང་པོར༌བསྡད། ཉིན་ཞིག༌ལ། ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱི་རྒྱལ་པོ་ཨ་བི་མེ་ལེག་གིས་སྒེའུ་ཁུང་ལས་ཕྱི་རོལ་ཏུ་བལྟས་པ༌ན། ཨི་སཱག་དང་ཁོའི་ཆུང་མ་རིབ་ཀཱ་གཉིས་རྩེད་མོར་གཡེང་བ་མཐོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ཨ་བི་མེ་ལེག་གིས་ཨི་སཱག་བོས༌ཏེ། ཁོ་མོ་དངོས་གནས་ཁྱོད་ཀྱི་ཆུང་མ་ཡིན༌པས། ཁྱོད་ཀྱིས་ཁོ་མོ་རང་གི་སྲིང་མོ་ཡིན་ཞེས་སྨྲ་བའི་རྒྱུ་མཚན་ཅི་ཞེས་དྲིས་པ༌ལ། ཨི་སཱག་ན༌རེ། བདག་ནི་ཁོ་མོའི་རྐྱེན་ལས་འཆི་བར་ངེས་སྙམ་པ་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","དེ་ནས་ཨ་བི་མེ་ལེག་ན༌རེ། ཁྱོད་ཀྱིས་ངེད་རྣམས་ལ་དོན་ཅི་ཞིག་བྱས༌སམ། མང་ཚོགས་ལས་མི་ཞིག་ཁྱོད་ཀྱི་ཆུང་མར་ལུས་འབྲེལ་བྱས༌ན། ངེད་རྣམས་ལ་ཉེས་པ་འཕོག་ཉེན་ཆེ་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","དེའི༌ཕྱིར། ཨ་བི་མེ་ལེག་གིས་མང་ཚོགས་ལ་འདི༌ལྟར། མི་སུ་ཞིག་གིས་ཁོའམ་ཁོའི་ཆུང་མར་གནོད་འཚེ་བྱས༌ན། མི་དེ་ངེས་པར་གསོད་དགོས་ཞེས་བཀའ་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","དེ་ནས་ཨི་སཱག་གིས་ཡུལ་དེ་རུ་ཞིང་བཏབ་པ་དང་ལོ་དེ་ལ་འབྲས་བུ་ལྡབ་བརྒྱ་ཐོབ༌ཅིང༌། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་བྱིན་རླབས་གནང༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ཁོ་ནི་སྟོབས་དང་ལྡན་པ༌དང༌། གོང་ནས་གོང་དུ་འཕེལ་ཏེ་འབྱོར་ཕྱུག་ལྡན་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ཁོ་ལ་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་ཡོད་པར་མ༌ཟད། གཡོག་པོའང་མང་དུ་ཡོད་པས་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱིས་ཁོ་ལ་ཕྲག་དོག༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","དེ་ཡང་ཁོའི་ཡབ་ཨབ་ར་ཧམ་བཞུགས་པའི་དུས༌སུ། ཡབ་ཀྱི་གཡོག་པོས་བརྐོས་པའི་ཁྲོན་པ་དེ་དག་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱིས་ས་ཡིས་བཅད་ཅིང་སྙོམས་པར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","དེ་ནས་ཨ་བི་མེ་ལེག་གིས་ཨི་སཱག་ལ་འདི༌ལྟར། ཁྱོད་ནི་ངེད་ཅག་ལས་སྟོབས་འབྱོར་ཆེ་བས་ངེད་ཅག་དང་ཁ་བྲལ་ནས་སོང་ཞིག་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ཨི་སཱག་ཡུལ་དེ་དང་ཁ་བྲལ་ཞིང་གེ་རཱར་ལུང་པ་རུ་སོང་ནས་དེར་སྦྲ་གུར་ཕུབ་སྟེ་གནས་བཅས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","དེ་ཡང་ཁོའི་ཡབ་ཨབ་ར་ཧམ་བཞུགས་པའི་དུས་སུ་བརྐོས་པའི་ཁྲོན་པ་དེ་དག་ཕེ་ལེ་ཤེད་མི་རིགས་ཀྱིས་ཨབ་ར་ཧམ་སྐུ་གཤེགས་པའི་རྗེས་སུ་ས་ཡིས་བཅད༌ཀྱང༌། ཨི་སཱག་གིས་ཁྲོན་པ་དེ་དག་སླར་ཡང་བརྐོས་ཤིང་ཁོའི་ཡབ་ཀྱིས་མིང་བཏགས་པ་བཞིན་ཁྲོན་པ་དེ་དག་ལ་མིང་བཏགས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ཡང་ཨི་སཱག་གི་གཡོག་པོས་ལུང་པའི་ནང་དུ་ཁྲོན་པ་ཞིག་བརྐོས་ཏེ་ས་འོག་གི་ཆུ་རྒྱུན་ཆེན་པོ་ཞིག་རྙེད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","གེ་རཱར་ལུང་པར་ཡོད་པའི་ཕྱུགས་རྫི་རྣམས་ཀྱིས་ཨི་སཱག་གི་ཕྱུགས་རྫི་ལ་ཆུ་འདི་ནི་ངེད་ཅག་གི་ཡིན་ཞེས་རྩོད་གླེང་བྱས་པ༌དང༌། ཨི་སཱག་གིས་ཁྲོན་པ་དེ་ལ་ཨེ་སཱ་ ཞེས་མིང་བཏགས༌སོ། །རྒྱུ་མཚན་ནི་ཁོ་རྣམས་ཀྱིས་ཁོ་དང་རྩོད་གླེང་བྱས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","དེ་ནས་ཡང་ཨི་སཱག་གི་གཡོག་པོས་ཁྲོན་པ་གཞན་ཞིག་བརྐོས་པ༌དང༌། དེ་རྣམས་ཁྲོན་པ་དེ་ལ་རྩོད་པ་བྱུང་བས་ཨི་སཱག་གིས་ཁྲོན་པ་དེའི་མིང་ལ་ཤིད་ནཱ་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","དེ་ནས་ཨི་སཱག་ཡུལ་དེ་དང་ཁ་བྲལ་ཞིང་ཁྲོན་པ་གཞན་ཞིག་བརྐོས་པ༌དང༌། མི་དེ་རྣམས་ཀྱིས་རྩོད་པ་མ་བྱས་པས་ཁོས་ཁྲོན་པ་དེའི་མིང་ལ་རེའེ་ཧོ་པེད་ ཅེས་བཏགས༌ཤིང༌། ཁོ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེས་རང་ཅག་རྣམས་ལ་ས་གཞི་རྒྱ་ཆེ་བ་ཞིག་གནང་བ༌དང༌། རང་ཅག་རྣམས་ས་གཞི་འདིའི་སྟེང་ནས་དར་ཞིང་རྒྱས་པར་བྱེད་དགོས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","དེ་ནས་ཨི་སཱག་ཡུལ་དེ་དང་ཁ་བྲལ་ནས་ཡར་པེར་ཤ་བཱ་རུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ཉིན་དེའི་མཚན༌མོར། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་ལ་མངོན་པར་མཛད་དེ་འདི་སྐད༌དུ། བདག་ནི་ཁྱོད་ཀྱི་ཡབ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་ཡིན༌ལ། བདག་ནི་ཁྱོད་དང་མཉམ་དུ་ཡོད་པས་འཇིགས་མི་དགོས༌སོ། །བདག་གིས་ཁྱོད་ལ་བྱིན་རླབས་གནང་བ༌དང༌། བདག་གི་ཞབས་ཕྱི་པ་ཨབ་ར་ཧམ་གྱི་རྐྱེན་གྱིས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་མང་དུ་སྤེལ་བར་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","དེ་ནས་ཨི་སཱག་གིས་གནས་དེ་རུ་མཆོད་ཁྲི་ཞིག་བཞེངས་ཤིང་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ནས་བོས་པ༌དང༌། སྦྲ་གུར་ཡང་ཕུབ་པ་དང་ཁོའི་གཡོག་པོ་རྣམས་ཀྱིས་གནས་དེ་རུ་ཁྲོན་པ་ཞིག་ཀྱང་བརྐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","དེ་ཡང་ཨ་བི་མེ་ལེག་དང་ཁོའི་མནའ་གྲོགས་ཨ་ཧུའུ་ཟད་དང་དམག་དཔོན་ཕི་ཀོལ་བྱ་བ་གསུམ་གེ་རཱར་ནས་སླེབས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ཨི་སཱག་ན༌རེ། དེ་སྔར་ཁྱོད་རྣམས་བདག་ལ་སྡང་ཞིང་ང་རང་འགྲོ་རུ་བཅུག་པ༌དང༌། ད་ལྟ་ཁྱོད་རྣམས་བདག་གི་གམ་དུ་ཡོང་བ་ཅི་ཡིན་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","དེ་རྣམས་ན༌རེ། ངེད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱོད་དང་མཉམ་དུ་བཞུགས་པ་གསལ་པོར་མཐོང༌བས། རང་ཅག་བར་དུ་དམ་བཅའ་བཞག་ནས་གྲོས་འཆམ་བྱུང་ན་ལེགས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ཁྱོད་ཀྱིས་ངེད་ཅག་ལ་གནོད་པ་མི་བྱེད་པའི་ཕྱིར༌རོ། །ངེད་ཅག་གིས་ཁྱོད་ལ་གནོད་པ་བྱས་མ་མྱོང༌བར། སྔར་བཞིན་ཁྱོད་ལ་སྣེ་ལེན་བཟང་པོ་བྱས་པར་མ༌ཟད། ཁྱོད་རང་བདེ་བའི་ངང་འགྲོ་རུ་བཅུག་པ་དེ་བཞིན༌ནོ། །ཁྱོད་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་བྱིན་རླབས་ཐོབ་པའི་མི་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","དེ་ནས་ཨི་སཱག་གིས་ཁོ་རྣམས་ལ་གསོལ་སྟོན་བཤམས་ཤིང་དེ་རྣམས་ཀྱང་བཟའ་བཏུང་ལ་རོལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ཕྱི་ཉིན་ཞོགས༌པར། ཁོ་རྣམས་སྔ་མོ་ནས་ཡར་ལངས་ཏེ་ཕན་ཚུན་བར་དམ་བཅས༌སོ། །དེ་ནས་ཨི་སཱག་གིས་མི་དེ་རྣམས་ཕྱིར་འགྲོ་རུ་བཅུག་ཅིང་དེ་རྣམས་ཀྱང་བདེ་བར་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ཉིན་དེ༌ལ། ཨི་སཱག་གི་གཡོག་པོ་ཡོང་ནས་ངེད་ཅག་གིས་ཆུ་རྙེད་དོ་ཞེས་ཁྲོན་པ་བརྐོས་པའི་དོན་དེ་ཁོ་ལ༌སྨྲས།། ");
INSERT INTO bodn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","དེ་ནས་ཁོས་ཁྲོན་པ་དེའི་མིང་ལ་ཤིབ་ཨ་ཞེས་བཏགས༌པས། གྲོང་ཁྱེར་དེའི་མིང་ལ་པེར་ཤ་བཱ་ཞེས་ཟེར༌ཞིང༌། གྲོང་ཁྱེར་དེའི་མིང་ནི་ད་ལྟའི་བར་དུ་གནས་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","དེ་ཡང་ཨེ་སཱབ་དགུང་ལོ་བཞི་བཅུ་ཡིན་པའི་སྐབས༌སུ། ཧེ་བི་མི་རིགས་ཀྱི་པེ་རེ་ཞེས་བྱ་བའི་བུ་མོ་ཡ་ཧུ་དིད༌དང༌། ཧེ་བི་མི་རིགས་ཀྱི་ཨེད་ལོན་ཞེས་བྱ་བའི་བུ་མོ་པཱ་ས་མཱད་ཅེས་པ་གཉིས་མཉམ་དུ་ཆུང་མར་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","དེ་ནས་ཁོ་རྣམས་ཀྱིས་ཨི་སཱག་དང་རིབ་ཀཱ་གཉིས་ཀྱི་སེམས་དཀྲུག་པར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","དེ་ཡང་ཨི་སཱག་རྒས་ཤིང་མིག་ཟུང་རབ་རིབ་ཏུ་གྱུར་ནས་ཅི་ཡང་མི་མཐོང་བའི་ཚེ། བདག་གི་བུ་ཞེས་རང་གི་བུ་ཆེ་བ་ཨེ་སཱབ་བོས་པ༌དང༌། བུ་ན༌རེ། ཡབ༌ལགས། ང་རང་འདི་རུ་ཡོད་ཅེས་ལན་བཏབ་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ཡབ་ན༌རེ། ལྟོས༌དང༌། ད་ལྟ་ང་རང་རྒས་ཤིང་ནམ་འཆི་ངེས་མེད་ཡིན༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ད་ནི་ཁྱོད་ཀྱིས་རང་གི་མཚོན་ཆ་སྟེ་མདའ་གཞུ་ཐོགས་པ་དང་དབེན་སྟོང་དུ་སོང་ནས་བདག་ལ་རི་དྭགས་རྔོན་པར༌བྱོས། ");
INSERT INTO bodn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","བདག་གི་དགའ་མོས་ལྟར་ཁ་ཟས་ཞིམ་པོ་གཡོས་སྦྱོར་བྱས་ནས་བདག་ལ་ཁྱེར༌ཤོག ང་རང་མ་ཤི་གོང་དུ་ཁྱོད་ལ་བྱིན་རླབས་གནང་བར་བྱ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ཨི་སཱག་གིས་རང་གི་བུ་ལ་དེ་ལྟར་སྨྲས་པ་རིབ་ཀཱས་ཐོས༌སོ། །དེ་ནས་བུ་ཆེ་བ་དབེན་སྟོང་ལ་རི་དྭགས་རྔོན་དུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","རིབ་ཀཱས་རང་གི་བུ་ཡ་ཀོབ་ལ་འདི་ལྟར། ལྟོས༌དང༌། ཁྱོད་ཀྱི་ཡབ་ཀྱིས་ཁྱོད་ཀྱི་གཅེན་པོ་ཨེ་སཱབ༌ལ། ཁྱོད་རང་སོང་ནས་རི་དྭགས་བརྔོན༌ཏེ། ཁ་ཟས་ཞིམ་པོ་གཡོས་སྦྱོར་བྱས་ནས་ང་རང་ལ་བཟའ་བར་ཁྱེར༌ཤོག ང་རང་མ་ཤི་གོང་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་ནས་ཁྱོད་ལ་བྱིན་རླབས་གནང་བར་བྱའོ་ཞེས་སྨྲས་པ་ངས་ཐོས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","བདག་གི༌བུ། ངས་ཁྱོད་ལ་སྨྲས་པ་བཞིན་ད་ལྟ་ཁྱོད་ཀྱིས་བདག་གི་གཏམ་ལ་མཉན་པར་བྱ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ཁྱོད་རང་ར་ཁྱུའི་ནང་དུ་སོང་ནས་རེའུ་ཤ་ཤེད་ཅན་གཉིས་ཁུར་ཤོག༌དང༌། བདག་གིས་ཁྱོད་ཀྱི་ཡབ་ལ་དགའ་བའི་ཁ་ཟས་ཞིམ་པོོ་གཡོས་སྦྱོར་བྱེད་པར༌བྱ། ");
INSERT INTO bodn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ཁྱོད་ཀྱིས་ཁ་ཟས་དེ་རང་གི་ཡབ་ཀྱི་དྲུང་དུ་ཁྱེར་སོང༌དང༌། ཁོང་མ་ཤི་གོང་དུ་ཁོང་གིས་ཁྱོད་ལ་བྱིན་རླབས་གནང་བར་བྱ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","དེ་ནས་ཡ་ཀོབ་ཀྱིས་རང་གི་ཡུམ་རིབ་ཀཱ་ལ་འདི༌ལྟར། བདག་གི་གཅེན་པོ་ཨེ་སཱབ་ཀྱི་ལུས་ཡོངས་ལ་བ་སྤུས་བཀང་ཞིང་བདག་གི་ལུས་ནི་འཇམ་པོ་ཡིན༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","གལ་ཏེ་ཡབ་ཀྱིས་བདག་གི་ལུས་ལ་རེག༌ན། བདག་གིས་ཁོང་ལ་མགོ་སྐོར་བཏང་བ་ཤེས་ངེས༌ཡིན། བདག་ལ་དམོད་པ་འཕོག་ཅིང་བྱིན་རླབས་འཐོབ་པར་མི་འགྱུར་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ཡང་ཁོའི་ཡུམ་ན༌རེ། བདག་གི༌བུ། ཁྱོད་ལ་ཕོག་པའི་དམོད་པ་དེ་བདག་གི་ལུས་ལ་འཕོག་པར༌སྨོན། ཁྱོད་ཀྱིས་བདག་གི་གཏམ་ལ་མཉན་ཏེ་རེའུ་ཁྲིད་ཤོག་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ཁོས་དེ་ལྟར་བྱས་ནས་ཡུམ་ལ་སྤྲད་པ༌དང༌། ཁོ་མོས་ཀྱང་ཡབ་ཀྱི་དགའ་མོས་ལྟར་ཁ་ཟས་ཞིམ་པོ་གཡོས་སྦྱོར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","དེ་ནས་རིབ་ཀཱས་ཡུལ་དུ་ཡོད་པའི་བུ་ཆེ་བའི་གྱོན་གོས་ལེགས་པོ་དེ་བླངས་ནས་རང་གི་བུ་ཆུང་བ་ཡ་ཀོབ་ཀྱི་ལུས་ལ་གྱོན་དུ་བཅུག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ཡང་རིབ་ཀཱས་ར་ལྤགས་ཀྱིས་ཡ་ཀོབ་ཀྱི་ལག་པ་དང་མཇིང་པ་བཅས་འཇམ་པོ་ཡིན་ས་རྣམས་གཡོགས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ཁ་ཟས་ཞིམ་པོ་གཡོས་སྦྱོར་བྱས་པ་དེ་དང་བག་ལེབ་བཅས་རང་གི་བུ་ཆུང་བའི་ལག་ཏུ་བཞག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","དེ་ནས་ཡ་ཀོབ་ཁོ་རང་ཡབ་ཀྱི་དྲུང་དུ་སོང་སྟེ་བདག་གི་ཡབ་ལགས་ཞེས་སྨྲས་པ༌དང༌། ཡབ་ན༌རེ། ང་རང་འདི་རུ་ཡོད། བདག་གི༌བུ། ཁྱོད་ནི་བུ་གང་ཞིག་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ཡ་ཀོབ་ཀྱིས་ཕ་ལ་འདི་ལྟར་སྨྲས་པ༌སྟེ། ང་རང་ཁྱེད་ཀྱི་བུ་སྐྱེས་འགོ་ཨེ་སཱབ༌ཡིན། ཁྱེད་ཀྱི་བྱིན་རླབས་འཐོབ་པའི༌ཕྱིར། བདག་གིས་ཁྱེད་ཀྱི་བཀའ་ལྟར་བསྒྲུབས༌པ་ཡིན། ཁྱེད་རང་ཡར་བཞེངས་ནས་ཁ་ཟས་བཞེས་པར་མཛོད་ཅིག་ཅེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ཨི་སཱག་གིས་རང་གི་བུ་ལ་འདི་ལྟར་སྨྲས༌པ། བདག་གི༌བུ། ཁྱོད་རང་འདི་འདྲ་མགྱོགས་པ་ཅི་ཡིན་ནམ་ཞེས་པ༌ན། བུ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེ་སྟེ་ཁྱེད་ཀྱི་དཀོན་མཆོག་གིས་བདག་ལ་གོ་སྐབས་ལེགས་པོ་གནང་བས་ལག་ཏུ་འབྱོར་བ་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","དེ་ནས་ཨི་སཱག་གིས་ཡ་ཀོབ་ལ་འདི༌ལྟར། བདག་གི༌བུ། ཁྱོད་རང་བདག་གི་ཉེ་སར་ཤོག༌དང༌། བདག་གིས་ཁྱོད་ལ་རེག༌སྟེ། ཁྱོད་ནི་བདག་གི་བུ་ཨེ་སཱབ་ཡིན་མིན་ལ་བལྟ་བར་བྱ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ཡ་ཀོབ་རང་གི་ཡབ་ཨི་སཱག་གི་ཉེ་སར་བཅར་བ༌དང༌། ཨི་སཱག་གིས་ཁོ་ལ་རེག་སྟེ་ན༌རེ། ཁྱོད་ཀྱི་སྐད་ནི་ཡ་ཀོབ་ཀྱི་སྐད་ཡིན་ཡང་ལག་པ་ནི་ཨེ་སཱབ་ཀྱི་ལག་པ་ཡིན་འདུག་ཅེས་སྨྲས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ཨི་སཱག་གིས་བུ་སུ་ཡིན་མ་ཤེས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཁོའི་ལག་པའི་སྟེང་དུའང་བ་སྤུ་ཡོད་པས་ཁོའི་གཅེན་པོ་ཨེ་སཱབ་ཀྱི་ལག་པ་དང་མཚུངས་པའི་ཕྱིར༌རོ། །དེ་ནས་བུ་ཡ་ཀོབ་ལ་བྱིན་རླབས་གནང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ཡང་ཡབ་ན༌རེ། ཁྱོད་ནི་དངོས་གནས་བདག་གི་བུ་ཨེ་སཱབ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། བུ་ཡ་ཀོབ་ཀྱིས་ང་རང་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","དེ་ནས་ཨི་སཱག་ན༌རེ། ཁྱོད་ཀྱིས་བདག་ལ་བྱིན༌དང༌། བདག་གིས་རང་གི་བུས་གཡོས་སྦྱོར་བྱས་པའི་ཁ་ཟས་བཟའ་བར༌བྱ། དེ་ནས་ཁྱོད་ལ་བྱིན་རླབས་གནང་བར་བྱ་ཞེས་སྨྲས༌སོ། །ཡ་ཀོབ་ཀྱིས་ཡབ་ལ་ཁ་ཟས་ཕུལ་བར་ཡབ་ཀྱིས་བཞེས༌ཤིང༌། རྒུན་ཆང་དྲངས་པ་ལ་ཁོང་གིས་དེའང་བཞེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","དེ་ནས་ཡབ་ཀྱིས་བུ་ཨེ་སཱབ་ཡིན་པར་སྙམ་ནས་འདི༌ལྟར། བདག་གི༌བུ། ཁྱོད་བདག་གི་གམ་དུ་ཡོང་ནས་བདག་ལ་འོ་བྱེད་པར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","བུ་ཡ་ཀོབ་ཀྱིས་ཡབ་ལ་འོ་བྱས་པ༌དང༌། ཡབ་ཀྱིས་བུའི་གྱོན་གོས་སྟེང་གི་དྲི་མ་བསྣམས་ནས་བྱིན་རླབས་གནང་སྟེ་འདི་སྐད༌དུ། བདག་གི་བུ་ཡི་ལུས་ཀྱི་དྲི་མ༌དང༌།། ཡ་ཝཱེས་བྱིན་རླབས་གནང་བར་མཛད་པ༌ཡི།། ཞིང་སའི་དྲི་ཞིམ་ལ་ནི་ཡང་དག༌མཚུངས།། ");
INSERT INTO bodn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","དཀོན་མཆོག་གིས་ནི་མཁའ་ལས་ཟིལ་བ༌དང༌།། ས་གཤིས་ལེགས་ཤིང་འབྲུ་རིགས་སྣ་ལྔ༌དང༌།། རྒུན་ཆང་གསར་པ་ཁྱོད་ལ་གནང་བར༌སྨོན།། ");
INSERT INTO bodn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","མི་རྣམས་ཀུན་གྱིས་ཁྱོད་ལ་བསྙེན་བཀུར༌དང༌།། མི་རིགས་ཡོངས་ཀྱིས་ཁྱོད་ལ་བཀུར་སྟི༌དང༌།། ཁྱོད་ནི་སྤུན་ཟླ་རྣམས་ཀྱི་བདག་པོ༌དང༌།། མ་ཡི་བུས་ཀྱང་བཀུར་སྟི་བྱེད་པར༌སྨོན།། ཁྱོད་ལ་དམོད་པའི་མི་རྣམས་ཀུན་ལ༌ཡང༌།། དེ་བཞིན་དམོད་པ་འཕོག་པར་འགྱུར་བ༌དང༌།། ཁྱོད་ལ་བྱིན་རླབས་གནང་མཁན་ཉིད་ལ༌ནི།། དེ་དང་དེ་བཞིན་བྱིན་རླབས་འཐོབ་པར༌སྨོན། །ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","དེ་ནས་ཨི་སཱག་གིས་ཡ་ཀོབ་ལ་བྱིན་རླབས་གནང་ཚར༌རྗེས། ཡ་ཀོབ་ཡབ་ཀྱི་མདུན་ནས་ཕྱིར་ཡོང་མ་ཐག༌ཏུ། ཁོའི་གཅེན་པོ་ཨེ་སཱབ་ཀྱིས་ཀྱང་རི་དྭགས་བརྔོན་ནས་ཕྱིར་སླེབས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ཁོས་ཀྱང་ཁ་ཟས་ཞིམ་པོ་གཡོས་སྦྱོར་བྱས༌ཏེ། ཡབ༌ལགས། ཡར་བཞེངས༌དང༌། བདག་ལ་བྱིན་རླབས་འཐོབ་པའི༌ཕྱིར། ཁྱེད་ཀྱི་བུས་གཡོས་སྦྱོར་བྱས་པའི་ཁ་ཟས་བཞེས་པར་མཛོད་ཅིག་ཅེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ཁོའི་ཡབ་ཀྱིས་ཨེ་སཱབ་ལ་ཁྱོད་རང་སུ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། བུ་ན༌རེ། བདག་ནི་ཁྱེད་ཀྱི་བུ་སྐྱེས་འགོ་ཨེ་སཱབ་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","དེ་ནས་ཨི་སཱག་དྲག་ཏུ་འདར་ཞིང་འདི་ལྟར། ཁྱོད་རང་མ་ཡོང་བའི་སྔོན༌དུ། སུ་ཞིག་གིས་རི་དྭགས་བརྔོན་ཏེ་བདག་ལ་ཁ་ཟས་ཞིམ་པོ་ཁྱེར་ཡོང༌ངམ། བདག་གིས་ཟོས་ནས་དེ་ལ་བྱིན་རླབས་གནང་བ༌དང༌། མ་འོངས་པར་དེ་ལ་བྱིན་རླབས་ཀྱང་འཐོབ་ངེས་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ཨེ་སཱབ་ཀྱིས་ཡབ་ཀྱི་གཏམ་དེ་ཐོས་རྗེས་སྐད་ཆེན་པོ་བརྒྱབ་ནས་ངུ་བཞིན་ན༌རེ། ཀྱེ། བདག་གི་ཡབ༌ལགས། ཁྱེད་ཀྱིས་བདག་ལའང་བྱིན་རླབས་གནང་བར་མཛོད་ཅིག་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ཨི་སཱག་གིས་འདི་ལྟར། ཁྱོད་ཀྱི་གཅུང་པོས་གཡོ་སྒྱུའི་སྦྱོར་བ་སྤེལ་ནས་ཁྱོད་ལ་འཐོབ་ངེས་པའི་བྱིན་རླབས་ཀྱི་བགོ་སྐལ་ཁྱེར་སོང་བ་ཡིན་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ཨེ་སཱབ་ན༌རེ། ཁོའི་མིང་ལ་ཡ་ཀོབ་ཅེས་བཏགས་ཡོད་པ་ཅི་མ༌བདེན། ཅིའི་ཕྱིར་ཞེ༌ན། ཁོས་བདག་ལ་མགོ་སྐོར་ཐེངས་གཉིས་ལ་བཏང་བ༌སྟེ། སྔོན་ཆད་བུ་ཆེ་བ་བདག་གི་ཐོབ་ཐང་ཕྲོགས་ཤིང་། ལྟོས༌དང༌། ད་ལྟ་བདག་གི་བྱིན་རླབས་ཀྱི་བགོ་སྐལ་ཡང་ཕྲོགས་པ་རེད་ཅེས་སྨྲས་པ༌དང༌། ཡང་ཁོ་ན༌རེ། ཁྱེད་ཀྱིས་བདག་ལ་བྱིན་རླབས་ཀྱི་བགོ་སྐལ་མ་བསྐྱུར་རམ་ཞེས་དྲིས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ཨི་སཱག་ན༌རེ། ལྟོས༌དང༌། བདག་གིས་ཁོ་རང་ནི་ཁྱོད་ཀྱི་བདག་པོར་བྱས་ཤིང་། ཁོའི་སྤུན་ཟླ་ཐམས་ཅད་ཁོའི་ཞབས་ཕྱི་པར་བྱས་པ༌དང༌། ཁོ་རང་ལ་འབྲུ་རིགས་སྣ་ལྔ་དང་རྒུན་ཆང་གསར་པ་བསྩལ་ཏེ་འཚོ་བ་བསྐྲུན༌ནོ། །བདག་གི༌བུ། ད་ལྟ་བདག་གིས་ཁྱོད་ལ་ཅི་བྱ་ནུས་སམ་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","དེ་ནས་ཨེ་སཱབ་ཀྱིས་རང་གི་ཡབ་ལ་འདི༌ལྟར། ཀྱེ། ཡབ༌ལགས། ཁྱེད་ལ་བྱིན་རླབས་དེ་མ་གཏོགས་མེད༌དམ། བདག་གི་ཡབ༌ལགས། ཁྱེད་ཀྱིས་བདག་ལའང་བྱིན་རླབས་གནང་བར་ཞུ་ཞེས་སྨྲས་ཤིང་སྐད་ཆེན་པོས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","དེ་ནས་ཡབ་ན༌རེ། ཁྱོད་ནི་ས་གཤིས་ལེགས་པོར་འབྲལ་འགྱུར༌ཞིང༌།། ནམ་མཁའི་ཟིལ་བ་དེ་ཡང་རིང་དུ༌གནས།། ");
INSERT INTO bodn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ཁྱོད་ནི་རལ་གྲིར་བརྟེན་ནས་འཚོ་བ༌དང༌།། ཁྱོད་ཀྱིས་གཅུང་པོ་ལ་ཡང་བསྙེན་བཀུར༌བྱེད།། ཁྱོད་ལ་སྟོབས་འབྱོར་མངའ་ཐང་རྒྱས་པའི༌དུས།། ཁོ་ཡི་གཉའ་ཤིང་ལས་ནི་ཐར་བར༌ངེས། །ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","དེ་ཡང་ཡབ་ཀྱིས་ཡ་ཀོབ་ལ་བྱིན་རླབས་གནང་བའི༌ཕྱིར། ཨེ་སཱབ་ཀྱིས་ཡ་ཀོབ་དགྲ་རུ་བཟུང་སྟེ་ཁོའི་སེམས་སུ་ཕ་ལ་མྱ་ངན་བྱེད་པའི་དུས་སླེབས་ལ༌ཉེའོ། །དེའི་རྗེས༌སུ། བདག་གིས་གཅུང་པོ་ཡ་ཀོབ་གསོད་པར་བྱ་སྙམ་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","དེ་ནས་མི་གཞན་དག་གིས་རིབ་ཀཱའི་བུ་ཆེ་བ་ཨེ་སཱབ་ཀྱིས་སྨྲས་པའི་གཏམ་དེ་ཁོ་མོར་སྨྲས༌ཤིང༌། ཁོ་མོས་མི་མངགས་ཏེ་བུ་ཆུང་བ་ཡ་ཀོབ་ཚུར་བོས་པ༌དང༌། ཁོ་ལ་འདི༌ལྟར། ལྟོས༌དང༌། ཁྱོད་ཀྱི་གཅེན་པོས་ཁྱོད་ལ་དགྲ་ཤ་ལེན་ཕྱིར་གསོད་པར་རྩོམ་མོ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","བདག་གི༌བུ། ད་ལྟ་ཁྱོད་ཀྱིས་བདག་གི་གཏམ་ལ་ཉོན༌ཅིག ཡར་ལངས་ནས་ངའི་མིང་པོ་ལཱ་པན་གྱི་དྲུང་དུ་ཧཱ་རན་ཡུལ་ལ་ཕྲོས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ཁྱོད་ཀྱི་གཅེན་པོའི་ཞེ་སྡང་ཞི་བའི་བར་དུ་ཁོང་དང་མཉམ་དུ་ཉིན་ཁ་ཤས་ལ་སྡོད༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ཁྱོད་ཀྱི་གཅེན་པོའི་ཞེ་སྡང་ཞི་བ་དང་ཁྱོད་ཀྱིས་ཁོ་རང་ལ་བྱས་པའི་ལས་དེ་བརྗེད་པར་གྱུར༌ཚེ། བདག་གིས་མི་མངགས་ནས་ཁྱོད་རང་ཕྱིར་འབོད་པར༌བྱའོ། །ཉིན་གཅིག་ལ་ཁྱོད་སྤུན་གཉིས་ཀ་འཆི་དགོས་དོན་ཅི་ཡོད་དམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","དེ་ནས་ཡང་རིབ་ཀཱས་ཨི་སཱག་ལ་འདི༌ལྟར། བདག་ནི་ཧེད་མི་རིགས་ཀྱི་བུ་མོའི་རྐྱེན་གྱིས་ཡིད་སྐྱོ་བར་གྱུར་ཏེ་སྲོག་ཀྱང་འཚོ་མི་འདོད༌ལ། ཡ་ཀོབ་ཀྱིས་ཀྱང་ཧེད་མི་རིགས་ཀྱི་བུ་མོ་འདི་ལྟ་བུ་ཞིག་ཆུང་མར་བླངས༌ན། བདག་གི་སྲོག་འཚོ་ཐུབ་ཀྱང་ཅི་ལ་ཕན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","དེ་ནས་ཨི་སཱག་གིས་ཡ་ཀོབ་བོས་ཏེ་བྱིན་རླབས་གནང་བ་དང་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ཀྱིས་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་ཆུང་མར་ལེན་པར་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ཁྱོད་རང་ཡར་ལངས་ནས་ཕཱ་དན་ཨ་རམ་ཡུལ་གྱི་སྒྱུག་པོ་པཱ་ཐུ་ཨེལ་གྱི་ཁྱིམ་དུ་སོང༌དང༌། ཨ་མའི་མིང་པོ་ལཱ་པན་གྱི་བུ་མོ་རྣམས་ལས་བུ་མོ་གཅིག་རང་གི་ཆུང་མར་ལོངས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ཀུན་དབང་དཀོན་མཆོག་གིས་ཁྱོད་ལ་བྱིན་གྱིས་རླབས༌ཏེ། ཁྱོད་ནི་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་པོར་འཕེལ་ཏེ་མི་རིགས་ཆེན་པོ་ཞིག་ཏུ་འགྱུར་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ཁྱོད་ཀྱིས་རང་ཉིད་སྡོད་སའི་ཡུལ་འདིར་བདག་པོ་བྱེད་པའི༌ཕྱིར། ཁོང་གིས་མེས་པོ་ཨབ་ར་ཧམ་གྱི་བྱིན་རླབས་དེའང་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ལ་གནང་བར༌སྨོན། ཡུལ་འདི་ནི་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་གྱི་ས་གཞིར་གནང་བ་ཡིན་ཞེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","དེ་ནས་ཨི་སཱག་གིས་ཡ་ཀོབ་མངགས་པ༌དང༌། ཡ་ཀོབ་ཕཱ་དན་ཨ་རམ་ཡུལ་གྱི་ཨ་རམ་མི་རིགས་ཀྱི་པཱ་ཐུ་ཨེལ་ཞེས་བྱ་བའི་བུ་ལཱ་པན་གྱི་དྲུང་དུ༌སོང༌། ལཱ་པན་ནི་ཡ་ཀོབ་དང་ཨེ་སཱབ་གཉིས་ཀྱི་ཞང་པོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","དེ་ནས་ཨི་སཱག་གིས་ཡ་ཀོབ་ལ་བྱིན་རླབས་གནང་ཟིན་པ་ཨེ་སཱབ་ཀྱིས་མཐོང་བ༌སྟེ། ཨི་སཱག་གིས་བུ་ཆུང་བ་ཡ་ཀོབ་ནི་ཕཱ་དན་ཨ་རམ་ཞེས་པའི་ཡུལ་དུ་མངགས༌ཤིང༌། ཡུལ་དེ་ནས་ཁོ་རང་ལ་ཆུང་མ་ཞིག་ལེན་པའི་བྱིན་རླབས་གནང་བའི་གཏམ་འདི༌ལྟར། ཁྱོད་ཀྱིས་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་ཆུང་མར་མི་ལེན་པར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ཡ་ཀོབ་ཀྱིས་ཡབ་ཡུམ་གཉིས་ཀྱི་ངག་ལ་མཉན་ནས་ཕཱ་དན་ཨ་རམ་ཡུལ་དུ་སོང་བའང་ཨེ་སཱབ་ཀྱིས་མཐོང༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ཨེ་སཱབ་ཀྱིས་ཁོའི་ཡབ་ཨི་སཱག་གིས་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་མི་འདོད་པ་ཤེས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ཡེས་མ་ཨེལ་གྱི་དྲུང་དུ་སོང༌སྟེ། རང་ཉིད་ལ་ཆུང་མ་གཞན་ཞིག་ཀྱང་བླངས༌སོ། །ཁོ་མོ་ནི་ཨབ་ར་ཧམ་གྱི་བུ་ཡེས་མ་ཨེལ་གྱི་བུ་མོ་སྟེ་ནཱ་བ་ཨོད་ཀྱི་ནུ་མོ་ཡིན༌ལ། མིང་ལ་མཱ་ཧ་ལཱད་ཅེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","དེ་ནས་ཡ་ཀོབ་ཁོ་རང་པེར་ཤ་བཱ་དང་ཁ་བྲལ་ནས་ཧཱ་རན་གྱི་ལམ་དུ་ཆས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ས་ཆ་ཞིག་ཏུ་སླེབས་རྗེས་ཉི་མ་ནུབ་པས་གནས་དེར་ཞག་སྡོད་བྱས་ཤིང་། རྡོ་ལེབ་ཅིག་ཁྱེར་ཡོང་ནས་སྔས་མགོ་བྱས་ཏེ་ཉལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","དེ་ནས་ཁོའི་རྨི་ལམ་ནང་དུ་སྐས་ཤིག་ས་ནས་ཡར་བསྒྲེངས་ཡོད་པ་དང་སྐས་མགོ་ནམ་མཁར་ཟུག༌ཅིང༌། དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་སྐས་དེ་ལ་བརྟེན་ནས་ཡར་འཕགས་ཤིང་མར་ཕེབས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་ཉིད་ཀྱང་སྐས་དེའི་སྟེང་དུ་ཡར་བཞེངས་ཏེ་འདི་སྐད༌དུ། བདག་ནི་ཡ་ཝཱེ་སྟེ་ཁྱོད་ཀྱི་མེས་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་ཡིན༌ལ། ཨི་སཱག་གི་དཀོན་མཆོག་ཀྱང༌ཡིན། ད་ལྟ་བདག་གིས་ཁྱོད་རང་ཉལ་སའི་ས་ཆ་དེ་ནི་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་ལ་སྦྱིན་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ཁྱོད་ཀྱི་རིགས་རྒྱུད་དག་ནི་ས་སྟེང་གི་རྡུལ་གྲངས་དང་མཉམ་པར་འགྱུར་ངེས༌ཤིང༌། དེ་རྣམས་ཤར་ལྷོ་ནུབ་བྱང་གི་ཕྱོགས་སུ་འཕེལ་བར་འགྱུར་བ༌དང༌། ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལ་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་ལས་བྱིན་རླབས་འཐོབ་པར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","བདག་ནི་ཁྱོད་དང་མཉམ་དུ་གནས་ཤིང་ཁྱོད་རང་གང་དུ་སོང་ནའང་བདག་གིས་ཁྱོད་རང་བསྲུང་བ་དང༌། བདག་གིས་ཁྱོད་ལ་ཁས་བླངས་པ་བཞིན་དུ་འགྲུབ་པའི༌བར་དུ། ཁྱོད་རང་ཁྲིད་ནས་ས་ཆ་འདིར་ཡོང་བ་དང་ནམ་ཡང་ཁྱོད་དང་ཁ་མི་འབྲལ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","དེ་ནས་ཡ་ཀོབ་གཉིད་ལས་སད་དེ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེ་དངོས་གནས་ས་ཆ་འདིར་བཞུགས་ཡོད་ཀྱང་བདག་གིས་མ་ཤེས་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ཡང་ཁོ་རང་འཇིགས་སྐྲག་ངང་ན༌རེ། ས་ཆ་འདི་ཇི་འདྲའི་འཇིགས་སུ་རུང་བ་ལ༌ཨང༌། གནས་འདི་ནི་ཡུལ་གཞན་མ་ཡིན་ཏེ། དཀོན་མཆོག་གི་བཞུགས་གནས་ཡིན༌ལ། ནམ་མཁའི་ཞིང་ཁམས་ཀྱི་སྒོ་ཆེན་ཡང་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","དེ་ཡང་ཞོགས་པར་ཡ་ཀོབ་ཡར་ལངས༌ཤིང༌། སྔས་མགོ་བྱས་པའི་རྡོ་ལེབ་དེ་ཀ་བ་རུ་བསྒྲེངས་པ་དང་དེའི་སྟེང་དུ་སྣུམ་བླུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","དེ་ནས་ཁོས་ས་ཆ་དེའི་མིང་ལ་པེད་ཨེལ་ཞེས༌བཏགས། འོན༌ཀྱང༌། སྔོན་ཆད་གྲོང་ཁྱེར་དེ་ལ་ལོ་ཟི་ཞེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","དེ་ནས་ཡ་ཀོབ་ཀྱིས་དཀོན་མཆོག་ལ་འདི་ལྟར་དམ་བཅས་པ༌སྟེ། གལ༌སྲིད། དཀོན་མཆོག་ཁྱེད་ནི་བདག་དང་མཉམ་དུ་བཞུགས་པ༌དང༌། ང་རང་གང་ལ་འགྲོ་བའི་ལམ་དུ་བདག་ལ་སྲུང་སྐྱོབ་མཛད༌པ། བདག་ལ་ཟས་གོས་གནང༌བ། ");
INSERT INTO bodn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ང་རང་བདེ་འཇགས་ངང་རང་གི་ཕ་གཞིས་སུ་ལོག་ཐུབ་པ་བཅས་ཡིན༌ན། བདག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱེད་ཉིད་ང་རང་གི་དཀོན་མཆོག་ཏུ་བཀུར་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ངས་ཀ་བ་རུ་བསྒྲེངས་པའི་རྡོ་ལེབ་དེའང་དཀོན་མཆོག་གི་བཞུགས་གནས་སུ་བྱེད༌དོ། །ཁྱེད་ཀྱིས་བདག་ལ་གནང་བ་ཐམས་ཅད་ལས་བདག་གིས་བཅུ་ཆ་གཅིག་ཁྱེད་ལ་འབུལ་ངེས་ཡིན་ཞེས་ཞུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","དེ་ནས་ཡ་ཀོབ་ལམ་ལ་ཆས་ནས་ཤར་ཕྱོགས་པའི་ཡུལ་དུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ཞིང་ནང་དུ་ཁྲོན་པ་ཞིག་ཡོད་པ་མཐོང་ཞིང་ལུག་ཁྱུ་སྐོར་གསུམ་ཁྲོན་པའི་འགྲམ་དུ་ཉལ་འདུག་པ༌སྟེ། རྒྱུ་མཚན་ནི་མི་རྣམས་ཀྱིས་ཁྲོན་པ་དེ་ལས་ལུག་ཁྱུ་ལ་ཆུ་ལྡུད་པའི་ཕྱིར༌ཡིན། ཁྲོན་པའི་སྟེང་རྡོ་ལེབ་ཆེན་པོ་ཞིག་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ནམ་རྒྱུན་ཁྲོན་པའི་འགྲམ་དུ་ལུག་ཁྱུས་བཀང་བ༌ན། ལུག་རྫི་རྣམས་ཀྱིས་ཁྲོན་པའི་རྡོ་ལེབ་ཕར་བསྒྲིལ་ཏེ་ལུག་ཁྱུ་ལ་ཆུ་ལྡུད་པར་བྱེད་པ༌དང༌། དེའི་རྗེས་སུ་རྡོ་ལེབ་ཕྱིར་འགེབ་པར་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ལུག་རྫི་ལ་འདི༌ལྟར། སྤུན་ཟླ༌རྣམས། ཁྱོད་ཅག་གང་ནས་ཡོང་བ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ལ། ལུག་རྫི་རྣམས་ན༌རེ། ངེད་ཅག་ཧཱ་རན་ནས་ཡོང་བ་ཡིན་ཞེས་ལན་བཏབ་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ཡང་ཡ་ཀོབ་ན༌རེ། ཁྱོད་ཅག་གིས་ནཱ་ཧོར་གྱི་ཚ་བོ་ལཱ་པན་བྱ་བ་ངོ་ཤེས་སམ་ཞེས་དྲིས་པ༌ན། ཁོ་རྣམས་ན༌རེ། ངེད་ཅག་གིས་ཁོ་རང་ངོ་ཤེས་པ་ཡིན་ཞེས་ལན༌བཏབ། ");
INSERT INTO bodn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ཡང་ཡ་ཀོབ་ན༌རེ། ཁོ་རང་བདེ་ལགས་སམ་ཞེས་དྲིས་པ༌ལ། ཁོ་རྣམས་ན༌རེ། ཁོ་རང་བདེ་བར༌བཞུགས། ལྟོས༌དང༌། ཁོའི་བུ་མོ་རཱ་ཧེལ་གྱིས་ལུག་ཁྱུ་དེད་ནས་སླེབས་བྱུང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","དེ་ནས་ཡ་ཀོབ་ན༌རེ། ད་ལྟ་ཉིན་གུང་ཡིན་པས་ལུག་ཁྱུ་འདེད་པའི་དུས་མ་ཡིན༌ཏེ། ཁྱོད་ཅག་གིས་ལུག་ཁྱུ་ལ་ཆུ་བླུད་ནས་འཚོ་རུ་སོང་ན་ལེགས་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ཁོ་རྣམས་ན༌རེ། མིན༌ཏེ། ངེད་ཅག་གིས་ངེས་པར་ལུག་ཁྱུ་ཐམས་ཅད་བསྡུ་བར་སྒུག་ཅིང་ཁྲོན་པའི་རྡོ་ལེབ་ཕར་བསྒྲིལ་ནས་ལུག་ཁྱུ་ལ་ཆུ་ལྡུད་དགོས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","དེ་ལྟར་ཡ་ཀོབ་དང་ལུག་རྫི་རྣམས་ཀྱིས་ཕན་ཚུན་ལ་ལབ་གླེང་བྱེད་པའི་དུས༌སུ། རཱ་ཧེལ་གྱིས་ཁོ་མོའི་ཕ་ཡི་ལུག་ཁྱུ་དེད་ནས་སླེབས་པ༌དང༌། ཁོ་མོ་ལུག་ཁྱུ་དེའི་ལུག་རྫི་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","དེ་ནས་ཡ་ཀོབ་ཀྱིས་རང་གི་ཞང་པོ་ལཱ་པན་གྱི་བུ་མོ་རཱ་ཧེལ་དང་ལུག་ཁྱུ་མཐོང་བ༌དང༌། ཁྲོན་པའི་རྡོ་ལེབ་ཕར་བསྒྲིལ་ཏེ་ཞང་པོའི་ལུག་ཁྱུ་ལ་ཆུ་བླུད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ཡ་ཀོབ་ཀྱིས་རཱ་ཧེལ་ལ་འོ་བྱས་པ་དང་ངུ་སྒྲ་ཕྱུང་ངོ་།། ");
INSERT INTO bodn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ཡ་ཀོབ་ཀྱིས་རཱ་ཧེལ་ལ་ཁོ་རང་ནི་ཁོ་མོའི་ཕ་ཡི་ཚ་བོ་སྟེ་རིབ་ཀཱའི་བུ་ཡིན་པར་བརྗོད་པ༌དང༌། རཱ་ཧེལ་ཕ་ཡི་གམ་དུ་རྒྱུགས་ཤིང་དོན་དེ་ཕ་ལ་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","དེ་ནས་ལཱ་པན་གྱིས་ཚ་བོ་ཡ་ཀོབ་ཀྱི་གནས་ཚུལ་ཐོས༌རྗེས། མྱུར་དུ་ཁོ་བོའི་མདུན་བསུས་ཤིང་ཁོ་བོར་འཐམས་ནས་འོ་བྱས་ཏེ་རང་ཁྱིམ་དུ་གདན་དྲངས༌སོ། །དེར་ཡ་ཀོབ་ཀྱིས་ཀྱང་དོན་ཐམས་ཅད་ལཱ་པན་ལ་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","དེ་ནས་ལཱ་པན་ན༌རེ། ཁྱོད་ནི་ངའི་ཤ་དང་རུས་པའི་གཉེན་ཉེ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ཡ་ཀོབ་ཟླ་བ་གཅིག་ལ་ལཱ་པན་དང་མཉམ་དུ་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","དེ་ནས་ལཱ་པན་གྱིས་ཡ་ཀོབ་ལ་འདི༌ལྟར། ཁྱོད་བདག་གི་གཉེན་ཉེ་ཡིན་ཡང་གླ་མེད་པར་བདག་ལ་ཞབས་ཕྱི་བྱེད་ག་ལ༌སྲིད། ཁྱོད་ལ་གླ་ཕོགས་ག་ཚོད་དགོས་པ་བདག་ལ་སྨྲོས་ཤིག་ཅེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","དེ་ཡང་ལཱ་པན་ལ་བུ་མོ་གཉིས་ཡོད༌དེ། བུ་མོ་ཆེ་བའི་མིང་ལ་ལེ་ཨ་ཞེས་དང་བུ་མོ་ཆུང་བའི་མིང་ལ་རཱ་ཧེལ་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ལེ་ཨ་ནི་མིག་དབང་ཞན་པ༌དང༌། རཱ་ཧེལ་ནི་བྱད་གཟུགས་མཛེས་ཤིང་ལྟ་ན་སྡུག་པ་ཞིག༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ཡ་ཀོབ་ནི་རཱ་ཧེལ་ལ་དགའ་བར་གྱུར༌ཏེ། འདི༌ལྟར། བདག་གིས་ཁྱེད་ཀྱི་བུ་མོ་ཆུང་བ་རཱ་ཧེལ་གྱི་ཆེད༌དུ། ལོ་ངོ་བདུན་རིང་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབ་འདོད་པ་ཡིན་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ལཱ་པན་ན༌རེ། བདག་གིས་བུ་མོ་ཆུང་བ་མི་གཞན་ལ་སྟེར་བ་ལས་ཁྱོད་ལ་བྱིན་ན༌ལེགས། ཁྱོད་རང་བདག་དང་མཉམ་དུ་འདུག་པར་གྱིས་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","དེ་ནས་ཡ་ཀོབ་ཀྱིས་རཱ་ཧེལ་གྱི་ཆེད༌དུ་ལོ་ངོ་བདུན་རིང་ཞབས་ཕྱི༌བསྒྲུབས། ཡ་ཀོབ་ནི་རཱ་ཧེལ་ལ་དགའ་བའི་དབང་གིས་ལོ་བདུན་གྱི་དུས་ནི་ཉིན་འགའ་ཤས་ཙམ་ལ་སྣང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ལཱ་པན་ལ་འདི་ལྟར་སྨྲས༌པ། ད་ནི་དུས་ལ་སླེབས་པས། ཁྱེད་ཀྱིས་བདག་གི་ཆུང་མ་བདག་ལ་གནང་བར༌མཛོད། བདག་ཁོ་མོར་འགྲོགས་འདོད་པ་ཡིན་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ལཱ་པན་གྱིས་གཉེན་སྟོན་གཟབ་རྒྱས་བསྡུས་ཤིང་ཡུལ་ཕྱོགས་དེའི་མི་རྣམས་མགྲོན་ལ་བོས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","དེར་མཚན་མོའི་དུས༌སུ། ལཱ་པན་གྱིས་བུ་མོ་ལེ་ཨ་བྱ་བ་ཡ་ཀོབ་ཀྱི་གམ་དུ་བསྐྱལ་ཏེ་ཁོ་གཉིས་ལུས་འབྲེལ་བྱས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ལཱ་པན་གྱིས་གཡོག་མོ་ཟིལ་པཱ་ཞེས་བྱ་བ་བུ་མོ་ལེ་ཨའི་གཡོག་མོར་བསྐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ཕྱི་ཉིན་ཞོགས༌པར། ཡ་ཀོབ་ཀྱིས་ལེ་ཨ་ཡིན་པ་མཐོང༌སྟེ། ལཱ་པན་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱེད་ཀྱིས་བདག་ལ་ཅི་བྱས༌སམ། བདག་གིས་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབས་པ་ནི་རཱ་ཧེལ་གྱི་ཆེད་དུ་མ་ཡིན༌ནམ། ཁྱེད་ཀྱིས་བདག་ལ་མགོ་སྐོར་གཏོང་བའི་རྒྱུ་མཚན་ཅི་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ལཱ་པན་ན༌རེ། བུ་མོ་ཆེ་བ་གནས་ལ་མ་བྱིན་པར་བུ་མོ་ཆུང་བ་གནས་ལ་སྟེར་བ་ནི་ངེད་ཅག་གི་ཡུལ་འདིའི་གོམས་སྲོལ་མ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ཁྱོད་ཀྱིས་གཉེན་སྟོན་གྱི་ཉིན་བདུན་ལོངས་སུ་བཅུག༌རྗེས། བདག་གིས་བུ་མོ་ཆུང་བའང་ཁྱོད་ལ་སྟེར་ངེས༌ཤིང༌། ཁྱོད་ཀྱིས་ད་དུང་ལོ་ངོ་བདུན་རིང་བདག་ལ་ཞབས་ཕྱི་བསྒྲུབ་དགོས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","དེ་ནས་ཡ་ཀོབ་ཀྱིས་དེ་ལྟར་བསྒྲུབས༌ཤིང༌། ལེ་ཨའི་གཉེན་སྟོན་གྱི་ཉིན་བདུན་ལོངས༌རྗེས། ལཱ་པན་གྱིས་བུ་མོ་རཱ་ཧེལ་ཡ་ཀོབ་ལ་ཆུང་མར་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ཡང་ལཱ་པན་གྱིས་གཡོག་མོ་པིལ་ཧ་ཞེས་བྱ་བ་བུ་མོ་རཱ་ཧེལ་གྱི་གཡོག་མོར་བསྐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","དེར་ཡ་ཀོབ་ནི་རཱ་ཧེལ་ལའང་ལུས་འབྲེལ་བྱས༌ཤིང༌། ཁོ་རང་ལེ་ཨ་ལས་རཱ་ཧེལ་ལ་ཤིན་ཏུ་དགའ༌བས། ཡང་ལོ་ངོ་བདུན་རིང་ལཱ་པན་ལ་ཞབས་ཕྱི་བསྒྲུབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ལེ་ཨ་ལ་ཡ་ཀོབ་ཀྱི༌བྱམས་བརྩེ་མ་ཐོབ་པ་དེ་གཟིགས༌པས། ཁོ་མོ་ལ་མངལ་སྦྲུམ་ནུས་པར་མཛད་ཀྱང་རཱ་ཧེལ་ནི་མོ་གཤམ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","དེ་ནས་ལེ་ཨ་ལ་མངལ་སྦྲུམ་ཞིང་བུ་ཞིག་བཙས་པ་དང་བུའི་མིང་ལ་རུ་བེན་ཞེས༌བཏགས། ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་མོ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བདག་གི་སྐྱོ་སྡུག་གཟིགས༌པས། ད་ལྟ་བདག་གི་ཁྱོ་གས་ང་རང་ལ་གཅེས་ངེས་ཡིན་ཞེས་བརྗོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","དེ་ནས་ཡང་ཁོ་མོར་མངལ་སྦྲུམ་ཞིང་བུ་ཞིག་བཙས་པ༌ལ། ཁོ་མོ་ན༌རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བདག་ལ་བརྩེ་འདང་མ་ཐོབ་པ་གསན༌པས། ཁོང་གིས་བདག་ལ་བུ་འདིའང་གནང་བ་ཡིན་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་སི་མུ་ཨོན་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","དེ་ནས་ཡང་ཁོ་མོར་མངལ་སྦྲུམ་ཞིང་བུ་ཞིག་བཙས་པ༌དང༌། ཡང་ཁོ་མོ་ན༌རེ། བདག་གིས་ཁྱོ་གར་བུ་གསུམ་བཙས༌པས། ཁོ་ནི་བདག་དང་འབྲེལ་ངེས་ཡིན་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་ལེ་ཝི་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","དེ་ནས་ཡང་ཁོ་མོར་མངལ་སྦྲུམ་ཞིང་བུ་ཞིག་བཙས་པ༌དང༌། ཁོ་མོ་ན༌རེ། ཐེངས་འདིར་བདག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་བསྔགས་བརྗོད་པར་བྱ་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་ཡ་ཧུ་དཱ་ ཞེས༌བཏགས། དེའི་རྗེས་སུ་ཁོ་མོར་མངལ་སྦྲུམ་མཚམས་ཆད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","དེ་ནས་རཱ་ཧེལ་གྱིས་རང་གི་ཁྱོ་ག་ཡ་ཀོབ་ལ་ཕྲུ་གུ་སྐྱེ་མ་ཐུབ་པ་ཤེས་ཏེ་གཅེན་མོ་ལེ་ཨ་ལ་ཕྲག་དོག་བྱས་ནས་ཡ་ཀོབ་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ཀྱིས་བདག་ལ་ཕྲུ་གུ་སྐྱེ་བར་མཛོད༌ཅིག དེ་ལྟར་མི་བྱེད་ན་བདག་འཆིའོ་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ཡ་ཀོབ་ཁོང་ཁྲོ་ལངས་ཏེ་རཱ་ཧེལ་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ལ་ཕྲུ་གུ་མི་སྐྱེ་བར་མཛད་མཁན་ནི་དཀོན་མཆོག་ཡིན་པ༌ལས། བདག་གིས་ཁོང་གི་འཐུས་ཚབ་བྱེད་ག་ལ་ནུས་ཞེས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","རཱ་ཧེལ་ན༌རེ། བདག་གི་གཡོག་མོ་པིལ་ཧ་འདི་རུ་ཡོད༌པས། ཁྱོད་ཁོ་མོར་ལུས་འབྲེལ་བྱེད་ཅིང་ཁོ་མོས་བདག་ལ་ཕྲུ་གུ་སྐྱེ་བར་བྱས༌ན། བདག་ལ་ཁོ་མོ་བརྒྱུད་ནས་ཕྲུ་གུ་ཡོད་པར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","དེའི་ཕྱིར་རཱ་ཧེལ་གྱིས་ཁོ་མོའི་གཡོག་མོ་པིལ་ཧ་རང་གི་ཁྱོ་གའི་ཆུན་མར་བཅོས་ཏེ་ཁོ་གཉིས་ལུས་འབྲེལ་བྱེད་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","དེ་ནས་པིལ་ཧ་ལ་མངལ་སྦྲུམ་སྟེ་ཡ་ཀོབ་ལ་བུ་ཞིག་བཙས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","དེར་རཱ་ཧེལ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་ལ་ཐུགས་རྗེས་གཟིགས་ཤིང་བདག་གི་སྐད་ལའང་གསན༌པས། བདག་ལ་བུ་ཞིག་གནང་བྱུང་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་དཱན་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","རཱ་ཧེལ་གྱི་གཡོག་མོ་པིལ་ཧ་ལ་ཡང་མངལ་སྦྲུམ་སྟེ་ཡ་ཀོབ་ལ་བུ་གཉིས་པ་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ཡང་རཱ་ཧེལ་ན༌རེ། བདག་གིས་གཅེན་མོ་དང་འགྲན་རྩོད་བྱས་ཤིང་ཁོ་མོ་ལས་རྣམ་པར་རྒྱལ་བ་ཡིན་ཞེས་སྨྲས་པའི༌ཕྱིར། བུ་གཉིས་པའི་མིང་ལ་ནཱབ་ཐ་ལི་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","དེ་ཡང་ལེ་ཨས་རང་ལ་མངལ་སྦྲུམ་མཚམས་ཆད་པ་ཤེས་ཏེ་རང་གི་གཡོག་མོ་ཟིལ་པཱ་ཞེས་བྱ་བ་ཡ་ཀོབ་ཀྱི་ཆུན་མར་བཅོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","དེ་ནས་ལེ་ཨའི་གཡོག་མོ་ཟིལ་པཱ་ཞེས་བྱ་བས་ཡ་ཀོབ་ལ་བུ་ཞིག་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","དེར་ལེ་ཨ་ན༌རེ། ཤིན་ཏུ་ལེགས་སོ་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་གཱ་རྡུ་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ལེ་ཨའི་གཡོག་མོ་ཟིལ་པཱ་ཞེས་བྱ་བས་ཡང་ཡ་ཀོབ་ལ་བུ་གཉིས་པ་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","དེ་ནས་ལེ་ཨ་ན༌རེ། བདག་ནི་ཅི་འདྲའི་དགའ་ཞིང་སྤྲོ་བ༌ལ། བུད་མེད་རྣམས་ཀྱིས་ཀྱང་བདག་ལ་དགའ་ཞིང་སྤྲོའོ་ཞེས་འབོད་པར་འགྱུར་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་ཨ་ཤེར་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","དེ་ཡང་སྟོན་ཁར་གྲོ་འབྲེག་པའི་དུས༌སུ། རུ་བེན་ཞིང་ནང་དུ་སོང་ནས་དུའུ་དཱ་ ཞེས་པའི་རྩྭ་སྨན་བཙལ་ཏེ་ཡུམ་ལེ་ཨ་ལ་སྤྲད་དོ། །དེ་ནས་རཱ་ཧེལ་གྱིས་ལེ་ཨ་ལ་འདི༌ལྟར། ཁྱོད་ཀྱིས་རང་གི་བུ་ཡི་རྩྭ་སྨན་དུའུ་དཱ་དེ་བདག་ལའང་ཉུང་ཙམ་གནང་བར་འཚལ་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ལེ་ཨ་ན༌རེ། ཁྱོད་ཀྱིས་བདག་གི་ཁྱོ་ག་ཕྲོགས་པ་དོན་ཆུང་ངུ་ཞིག་ཡིན༌ནམ། ད་ལྟ་བདག་གི་བུ་ཡི་དུའུ་དཱ་ཡང་འཕྲོག་འདོད་དམ་ཞེས་པ༌ན། རཱ་ཧེལ་ན༌རེ། ཁྱོད་ཀྱི་བུ་ཡི་རྩྭ་སྨན་དུའུ་དཱ་ཡི་ཆེད༌དུ། ཡ་ཀོབ་དོ་དགོང་ཁྱོད་དང་འགྲོགས་པར་བྱེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ཉིན་དེའི་མཚན༌མོར། ཡ་ཀོབ་ཞིང་ཁ་ནས་ཕྱིར་ལོག་པ༌ན། ལེ་ཨ་ནི་ཡ་ཀོབ་ཀྱི་མདུན་བསུ་རུ་སོང་སྟེ་ཁྱོད་བདག་དང་འགྲོགས་པར༌བྱ། ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་རང་གི་བུ་ཡི་རྩྭ་སྨན་དུའུ་དཱ་ལ་བརྟེན་ནས་ཁྱོད་རང་གླས་པ་ཡིན་ཞེས་སྨྲས་པ་དང་མཚན་མོ་དེར་ཁོ་གཉིས་ལུས་འབྲེལ་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","དཀོན་མཆོག་གིས་ལེ་ཨ་ལ་གསན་ནས་ཁོ་མོར་མངལ་སྦྲུམ་སྟེ་ཁོ་མོས་ཡ་ཀོབ་ལ་བུ་ལྔ་པ་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","དེ་ནས་ལེ་ཨ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་ལ་གླ་ཆ་གནང༌ངོ༌། །ཅིའི་ཕྱིར་ཞེ༌ན། ངས་རང་གི་གཡོག་མོ་རང་གི་ཁྱོ་ག་ལ་སྤྲད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་པའི་རྐྱེན༌གྱིས། བུ་ལྔ་བའི་མིང་ལ་ཡེས་སི་ཀཱར་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ལེ་ཨར་ཡང་མངལ་སྦྲུམ་སྟེ་ཡ་ཀོབ་ལ་བུ་དྲུག་པ་བཙས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","དེ་ནས་ལེ་ཨ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་ལ་བྱ་དགའ་ལེགས་པོ་གནང་ཞིང་། བདག་གི་ཁྱོ་ག་བདག་དང་མཉམ་དུ་འདུག་ངེས༌ཡིན། ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་ཡ་ཀོབ་ལ་བུ་དྲུག་བཙས་པའི་ཕྱིར་རོ་ཞེས་སྨྲས་པའི༌ཕྱིར། བུ་དྲུག་པའི་མིང་ལ་ཟེ་བུ་ལུན་ ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","དེའི་རྗེས༌སུ། ཡང་ལེ་ཨས་བུ་མོ་ཞིག་བཙས་ཤིང་ཁོ་མོའི་མིང་ལ་དི་ནཱ་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","དེ་ཡང་དཀོན་མཆོག་གིས་རཱ་ཧེལ་ལ་ཐུགས་རྗེ་དགོངས་ཏེ་ཁོ་མོར་མངལ་སྦྲུམ་ནུས་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","རཱ་ཧེལ་ལ་མངལ་སྦྲུམ་སྟེ་བུ་ཞིག་བཙས་པ༌དང༌། ཁོ་མོ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་གི་ངོ་ཚ་སེལ་ཏོ་ཞེས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","དཀོན་མཆོག་ཡ་ཝཱེས་ད་དུང་བདག་ལ་བུ་ཞིག་སྩོལ་བར་སྨོན་ཞེས་སྨྲས་པའི༌ཕྱིར། བུའི་མིང་ལ་ཡོ་སེབ་ ཅེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","དེ་ཡང་རཱ་ཧེལ་གྱིས་ཡོ་སེབ་བཙས་པའི་རྗེས༌སུ། ཡ་ཀོབ་ཀྱིས་ལཱ་པན་ལ་འདི༌ལྟར། ཁྱེད་ཀྱིས་བདག་རང་ཡུལ་དུ་འགྲོ་རུ་མཛོད༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","བདག་གིས་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབས་ནས་ཐོབ་པའི་ཆུང་མ་དང་བུ་ཕྲུག་རྣམས་བདག་ལ་གནང་སྟེ་ང་རང་འགྲོ་རུ་ཆུག ངས་ཁྱེད་ལ་ཞབས་ཕྱི་ཇི་ལྟར་བསྒྲུབས་པ་ཁྱེད་ཀྱིས་ཤེས་སོ་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ལཱ་པན་ན༌རེ། གལ༌ཏེ། བདག་ཁྱོད་ཀྱི་སེམས་ཁོང་དུ་ཡོད༌ན། ཁྱོད་བདག་དང་མཉམ་དུ་འདུག་པར༌གྱིས། བདག་གིས་མོ་བཏབ་པ་ལྟར་དཀོན་མཆོག་ཡ་ཝཱེས་བདག་ལ་བྱིན་རླབས་གནང་བ་ནི་ཁྱོད་ཀྱི་རྐྱེན་གྱིས་ཡིན་པའི་ཕྱིར་རོ་ཞེས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ཡང་ལཱ་པན་ན༌རེ། ཁྱོད་ལ་གླ་ཆ་ག་ཙམ་དགོས་པ་ཤོད༌ཅིག བདག་གིས་ཁྱོད་ལ་སྟེར་ངེས་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ཡ་ཀོབ་ན༌རེ། བདག་གིས་ཁྱེད་ལ་ཞབས་ཕྱི་ཇི་ལྟར་བསྒྲུབས་པ༌དང༌། བདག་གིས་ཁྱེད་ཀྱི་ཕྱུགས་ཟོག་ཇི་ལྟར་འཚོས་པ་ནི་ཁྱེད་ཀྱིས་ཤེས་གསལ་ལྟར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","བདག་མ་ཡོང་བའི་སྔོན༌དུ། ཁྱེད་ཀྱི་ཕྱུགས་ཟོག་ཤིན་ཏུ་ཉུང་ཡང་ད་ལྟ་འཕེལ་ཁ་རྒྱས་པ་དང༌། བདག་གིས་གོམ་པའི་འདེགས་འཇོག་གང་ལ་བསྒྱུར་ནའང་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱེད་ལ་བྱིན་རླབས་གནང༌ངོ༌། །ད་ལྟ་རང་གི་ཁྱིམ་གཞིས་སྐྱོང་བའི་དུས་ནི་ནམ་ཞིག་གམ་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ཡང་ལཱ་པན་ན༌རེ། བདག་གིས་ཁྱོད་ལ་ཅི་ཞིག་སྟེར་རམ་ཞེས་པ༌ན། ཡ་ཀོབ་ན༌རེ། བདག་ལ་རེ་བ་གཅིག་ཁོ་ན་ཡོད་པ་ལས༌གཞན། ཁྱེད་ཀྱིས་བདག་ལ་ཅི་ཡང་སྟེར་མི་དགོས༌སོ། །གལ༌ཏེ། ཁྱེད་ཀྱིས་ཁས་ལེན་པར་བྱེད༌ན། བདག་སླར་ཡང་ཁྱེད་ཀྱི་ལུག་རྫི་བྱེད་འདོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","དེ་རིང་བདག་ཁྱེད་ཀྱི་ལུག་ཁྱུ་ཐམས་ཅད་ཀྱི་ཁྲོད་དུ་སོང་ནས་ལུག་ནག་ཐིག་ཅན༌དང༌། ཐིག་ལེ༌ཅན། ལུ་གུ་ནག་པོ་ཅན་བཅས༌དང༌། ཡང་ར་མའི་ཁྲོད་ཀྱི་ནག་ཐིག་ཅན་དང་ཐིག་ལེ་ཅན་བཅས་བདམས་ནས་དེ་དག་བདག་གི་གླ་ཆ་ཡིན་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ཕྱིས་སུ་ཁྱེད་བདག་གི་གླ་ཆ་ལ་ལྟ་ཞིབ་བྱེད་དུ་ཡོང་བ༌ན། བདག་གི་ར་ལུག་གཉིས་ལས་ར་མ་ནི་ནག་ཐིག་ཅན་དང་ཐིག་ལེ་ཅན༌དང༌། ལུག་ནི་ནག་པོ་ཅན་བཅས་མ་ཡིན༌ན། བདག་གིས་རྐུ་བྱས་པའི་རྟགས་སུ་འགྱུར་བར་མ༌ཟད། བདག་གི་གཞུང་རྒྱུད་དྲང་མིན་ལའང་བདེན་དཔང་བྱེད་ནུས་པ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ཡང་ལཱ་པན་ན༌རེ། དེ་ལེགས༌སོ། །ཁྱོད་ཀྱིས་སྨྲས་པ་བཞིན་གྱུར་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ཉིན༌དེར། ལཱ་པན་གྱིས་ར་ཐུག་སྟག་རིས་ཅན་དང་ཐིག་ལེ་ཅན་གང་ཡོད་པ་ཐམས་ཅད༌དང༌། ར་མ་ནག་ཐིག་ཅན་དང་ཐིག་ལེ༌ཅན། དཀར་ཁྲ་ཅན་མཐའ་དག༌དང༌། ལུག་ནག་པོ་ཅན་བཅས་བདམས་ཏེ་ཁོའི་བུ་ཕྲུག་རྣམས་ལ་བཅོལ་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ཡང་ཁོ་དང་ཡ་ཀོབ་གཉིས་ནི་ཉིན་གསུམ་གྱི་ལམ་ཐག་ཏུ་ཁ་གྱེས་པ༌དང༌། ཡ་ཀོབ་ཀྱིས་མུ་མཐུད་དུ་ལཱ་པན་གྱི་ར་ལུག་གི་ཁྱུ་གཞན་དག་འཚོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ཤིང་སྦྱར་བ༌དང༌། སྟར་ཀའི་སྡོང་པོ། ཤིང་ཙི་ནཱར་བཅས་ཀྱི་མཉེན་ལྕུག་ཡལ་གའི་ཕྱི་ཤུན་ཤར་མ་རེ་རེ་བཞིན་བཤུས་ཏེ་ཡལ་གའི་ཁ་དོག་དཀར་པོ་མངོན་དུ་བཅུག༌རྗེས། ");
INSERT INTO bodn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ཕྱི་ཤུན་བཤུས་པའི་ཡལ་ག་ཁྲ་བོ་དེ་དག་ཆུ་རྐ་དང་ཆུ་གཞོང་ནང་དུ༌བཙུགས། དེ་ནི་ལུག་ཁྱུ་རྣམས་ཆུ་འཐུང་དུ་ཡོང་བའི་སྐབས༌སུ། ར་ལུག་ཕོ་མོ་དག་གིས་འཁྲིག་པ་སྤྱོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","དེ་ལྟར་ར་ལུག་དག་གིས་ཡལ་ག་ཁྲ་བོ་མཐོང་སྟེ་འཁྲིག་སྦྱོར་བྱས་ནས་ར་ལུག་གི་ཁྱུ་ཡིས་སྟག་རིས་ཅན༌དང༌། ཐིག་ལེ༌ཅན། ནག་ཐིག་ཅན་བཅས་རྩེབས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ལུ་གུ་རྣམས་སོ་སོར་བཀར་བ༌དང༌། ལཱ་པན་གྱི་ལུག་ཁྱུ་ལས་ར་ལུག་སྟག་རིས་ཅན་དང་ར་ལུག་ནག་པོ་ཅན་བཅས༌དང༌། ར་ལུག་དཀར་པོའི་ཁྱུ་གཉིས་སོ་སོར་བཀར་ནས་ཁ་གཏད་དུ་བཞག་པ༌དང༌། རང་ཉིད་ཀྱི་ལུ་གུ་ནི་ལཱ་པན་གྱི་ལུག་ཁྱུ་དང་མི་འདྲེས་པར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","དེ་ཡང་ར་ལུག་ཤ་ཤེད་ཅན་དག་གིས་འཁྲིག་པ་སྤྱོད་པའི་སྐབས༌སུ། ཡང་ཡ་ཀོབ་ཀྱིས་ཡལ་ག་ཁྲ་བོ་དེ་དག་ཆུ་རྐའི་ནང་དུ་བཙུགས༌ཏེ། ར་ལུག་ཕོ་མོ་དག་ལ་ཡལ་ག་ཁྲ་བོ་མཐོང་ས་ནས་འཁྲིག་པ་སྤྱོད་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","འོན༌ཀྱང༌། ར་ལུག་རིད་པ་རྣམས་ཀྱིས་འཁྲིག་པ་སྤྱོད་པའི་སྐབས༌སུ། ཡལ་ག་ཁྲ་བོ་དེ་འཛུགས་པར་མི་བྱེད༌དོ། །དེ་ལྟར་ར་ལུག་རིད་པ་དག་ལཱ་པན་ལ་བགོས་པ་དང་ར་ལུག་ཤ་ཤེད་ཅན་རྣམས་རང་ལ་དབང་བར་བྱས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ཡ་ཀོབ་ལ་ར་ལུག༌དང༌། གཡོག་པོ་དང་གཡོག༌མོ། རྔ་མོང་དང་བོང་བུ་མང་པོ་ཐོབ་སྟེ་འབྱོར་ཕྱུག་ལྡན་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","དེ་ཡང་ཡ་ཀོབ་ཀྱིས་ལཱ་པན་གྱི་བུ་རྣམས་ཀྱི་ངག་ལས་ཁོས་ངེད་ཅག་གི་ཕ་ཡི་རྒྱུ་ནོར་ཐམས་ཅད་ཕྲོགས་པ༌དང༌། ངེད་ཅག་གི་ཕ་ལ་བརྟེན་ནས་ད་ལྟ་ཁོ་འབྱོར་ཕྱུག་ལྡན་པར་གྱུར་པ་ཡིན་ཞེས་སྨྲ་བ་ཐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ཡ་ཀོབ་ཀྱིས་ལཱ་པན་ནི་རང་ལ་སྔོན་ཆད་ལྟར་མི་དགའ་བའང་མཐོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཡ་ཀོབ་ལ་འདི་སྐད༌དུ། ད་ལྟ་ཁྱོད་ནི་རང་གི་ཕ་མེས་ཡང་མེས་ཀྱི་ཡུལ་དུ་སོང༌ཞིག ཁྱོད་རང་གི་གཉེན་ཉེའི་གམ་དུ་སོང༌ཞིག བདག་ཁྱོད་དང་མཉམ་དུ་གནས་པར་འགྱུར་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","དེའི་ཕྱིར་ཡ་ཀོབ་ཀྱིས་མི་མངགས་ཏེ་རཱ་ཧེལ་དང་ལེ་ཨ་གཉིས་སྤང་ཐང་དུ་ཡོད་པའི་རང་གི་ར་ལུག་གི་ཁྱུ་ཡི་གམ་དུ་ཡོང་བར་བོས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ཡ་ཀོབ་ཀྱིས་ཁོ་མོ་གཉིས་ལ་འདི༌ལྟར། ཁྱོད་གཉིས་ཀྱི་ཕ་ནི་བདག་ལ་སྔར་བཞིན་མི་དགའ༌ནའང༌། བདག་གི་ཕ་ཡི་དཀོན་མཆོག་ནི་རྒྱུན་དུ་བདག་དང་མཉམ་དུ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ཁྱོད་གཉིས་ཀྱིས་ཤེས་གསལ༌ལྟར། བདག་གིས་ནུས་ཤུགས་ཡོད་ཚད་བཏོན་ནས་ཁྱོད་གཉིས་ཀྱི་ཕ་ལ་ཞབས་ཕྱི་བསྒྲུབས༌ཀྱང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ཁྱོད་གཉིས་ཀྱི་ཕ་ཡིས་བདག་ལ་མགོ་སྐོར་བཏང་བ་དང་བདག་གི་གླ་ཆ་ཐེངས་བཅུ་ལ་བསྒྱུར་ཏོ། །འོན༌ཀྱང༌། ཁོས་བདག་ལ་གནོད་པ་བཟོ་བ་དཀོན་མཆོག་གིས་བཟློག་པར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","གལ་ཏེ་ཁོ་ན༌རེ། ནག་ཐིག་ཅན་ནི་ཁྱོད་ཀྱི་གླ་ཆ་ཡིན་ཞེས་སྨྲས༌ན། ར་ལུག་གི་ཁྱུ་ཐམས་ཅད་ལས་ནག་ཐིག་ཅན་རྩེབས༌སོ། །ཡང་ཁོ་ན༌རེ། སྟག་རིས་ཅན་ནི་ཁྱོད་ཀྱི་གླ་ཆ་ཡིན་ཞེས་སྨྲས༌ན། ར་ལུག་གི་ཁྱུ་ཐམས་ཅད་ལས་སྟག་རིས་ཅན་རྩེབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","དེ་ལྟར་དཀོན་མཆོག་གིས་ཁྱོད་གཉིས་ཀྱི་ཕ་ཡི་ཕྱུགས་ཟོག་བླངས་ཏེ་བདག་ལ་གནང་བ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","དེ་ཡང་ར་ལུག་ཕོ་མོ་རྣམས་ཀྱིས་འཁྲིག་པ་སྤྱོད་པའི་སྐབས༌སུ། བདག་གིས་རྨི་ལམ་ནང་དུ་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། ར་མའི་ཐོག་ཏུ་ལྡིང་བའི་ར་ཐུག་ཐམས་ཅད་ནི་སྟག་རིས་ཅན༌དང༌། ནག་ཐིག༌ཅན། ཁྲ་བོ་ཅན་བཅས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","དེ་ནས་དཀོན་མཆོག་གི་ཕོ་ཉས་རྨི་ལམ་ནང་དུ་ཡ་ཀོབ་ཅེས་ང་རང་བོས་པ༌དང༌། བདག་གིས་ང་རང་འདི་རུ་ཡོད་ཅེས་ལན་བཏབ་པར་ཁོང་གིས་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ཁྱོད་ཀྱིས་མགོ་ཡར་བཀྱགས་ནས་ལྟོས༌དང༌། ར་མའི་སྟེང་དུ་ལྡིང་བའི་ར་ཐུག་ཐམས་ཅད་ནི་སྟག་རིས་ཅན༌དང༌། ནག་ཐིག༌ཅན། ཁྲ་བོ་ཅན་ཡིན༌ནོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ལཱ་པན་གྱིས་ཁྱོད་ལ་ལས་ཅི་ཞིག་བྱས་པ་ཐམས་ཅད་བདག་གིས་མཐོང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","བདག་ནི་པེད་ཨེལ་ཡུལ་གྱི་དཀོན་མཆོག༌སྟེ། ཁྱོད་ཀྱིས་ཀ་བའི་སྟེང་དུ་སྣུམ་བླུགས་ཏེ་བདག་ལ་དམ་བཅའ་ཕུལ་མྱོང་བ་དེ༌ཡིན། ད་ལྟ་ཁྱོད་ཡར་ལངས་ཏེ་ས་ཆ་འདི་དང་ཁ་བྲལ་ནས་རང་ཉིད་ཀྱི་སྐྱེས་ཡུལ་དུ་ལོག་ཅིག་ཅེས་གསུངས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","དེ་ནས་རཱ་ཧེལ་དང་ལེ་ཨ་གཉིས་ཀྱིས་ཡ་ཀོབ་ལ་འདི༌ལྟར། ངེད་གཉིས་ལ་ཕ་གཞིས་ལས་ད་དུང་བགོ་སྐལ་ཡོད༌དམ། ");
INSERT INTO bodn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ཕ་ཡིས་ངེད་གཉིས་ཕྱི་ཕྱོགས་པ་རུ་བྱས་པ་མ་ཡིན༌ནམ། ཅིའི་ཕྱིར་ཞེ༌ན། ཕ་ཡིས་ངེད་གཉིས་བཙོངས་ཏེ་ངེད་གཉིས་ཀྱི་རིན་ཐང་ཐམས་ཅད་ཆུད་ཟོས་སུ་བཏང་བ་མ་ཡིན༌ནམ། ");
INSERT INTO bodn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","དཀོན་མཆོག་གིས་ངེད་གཉིས་ཀྱི་ཕ་ཡི་དྲུང་ནས་ཕྲོགས་པའི་རྒྱུ་ནོར་ཐམས་ཅད་ངེད་གཉིས་དང་ངེད་གཉིས་ཀྱི་བུ་ཕྲུག་རྣམས་ཀྱི༌ཡིན། ད་ལྟ་དཀོན་མཆོག་གིས་ཁྱོད་ལ་ཇི་ལྟར་བཀའ་གནང་བ་བཞིན་ཁྱོད་ཀྱིས་ཀྱང་དེ་ལྟར་བསྒྲུབ་པར་གྱིས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","དེ་ནས་ཡ་ཀོབ་ཡར་ལངས་ཏེ་རང་གི་བུ་དང་ཆུང་མ་བཅས་རྔ་མོང་དག་ལ་བཞོན་དུ་བཅུག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ཡང་ཕཱ་དན་ཨ་རམ་ཡུལ་ནས་ཐོབ་པའི་ཕྱུགས་ཟོག་དང་རྒྱུ་ནོར་ཐམས་ཅད་ཁྱེར་ནས་ཀ་ན་ཨན་ཡུལ་གྱི་ཕ་ཨི་སཱག་གི་ཡུལ་དུ་ཆས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","སྐབས༌དེར། ལཱ་པན་ལུག་བལ་འབྲེག་ཏུ་སོང་བ༌དང༌། རཱ་ཧེལ་གྱིས་ཕ་ཡི་ཁྱིམ་ནས་ལྷ་སྐུ་རྣམས་བརྐུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ཡ་ཀོབ་ཀྱིས་ཨ་རམ་མི་རིགས་ཀྱི་ལཱ་པན་ལ་མགོ་སྐོར་བཏང་ཞིང་ཁོ་ལ་ཅི་ཡང་མ་སྨྲས་པར་བྲོས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","རང་ལ་དབང་བ་ཐམས་ཅད་ཁྱེར་ཏེ་ཆུ་བོ་ཕི་རཱད་བརྒལ་ནས་གིལ་ཨད་རི་ཁུལ་གྱི་ཕྱོགས་སུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","དེ་ནས་ཉིན་གསུམ་པ༌ལ། མི་ཞིག་གིས་ལཱ་པན་ལ་ཡ་ཀོབ་བྲོས་སོང་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ལཱ་པན་གྱིས་ཁོའི་སྤུན་ཟླ་འགའ་ཁྲིད་ནས་ཡ་ཀོབ་ཀྱི་རྗེས་བསྙེགས་པ༌དང༌། ཉིན་བདུན་པ་ལ་གིལ་ཨད་རི་ཁུལ་ནས་རྗེས་ཆོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","མཚན་མོའི་སྐབས༌སུ། དཀོན་མཆོག་ཨ་རམ་མི་རིགས་ཀྱི་ལཱ་པན་ཞེས་བྱ་བའི་རྨི་ལམ་དུ་བྱུང་སྟེ་ཁོ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་གཟབ་གཟབ༌བྱོས། ཡ་ཀོབ་ལ་གཏམ་བཟང་ངན་ཅི་ཡང་མི་སྨྲ་བར་གྱིས་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","དེ་ཡང་ལཱ་པན་གྱིས་ཡ་ཀོབ་ཀྱི་རྗེས་ཆོད༌ཅིང༌། ཡ་ཀོབ་ཀྱིས་རི་ཁུལ་དེ་ནས་གུར་ཕུབ་པ༌དང༌། ལཱ་པན་དང་ཁོའི་སྤུན་རྣམས་ཀྱིས་ཀྱང་གིལ་ཨད་རི་བོའི་སྟེང་དུ་གུར་ཕུབ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","དེ་ནས་ལཱ་པན་གྱིས་ཡ་ཀོབ་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ཀྱིས་ཅི་ཞིག་བྱས་པ་ཡིན༌ནམ། ཁྱོད་ཀྱིས་བདག་ལ་མགོ་སྐོར་བཏང་སྟེ་བདག་གི་བུ་མོ་རྣམས་ཁྲིད་སོང་བ་ནི་དམག་འཁྲུག་བརྒྱབ་ནས་བཙན་འཕྲོག་བྱས་པ་དང་མཚུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ཁྱོད་ཀྱིས་བདག་ལ་མགོ་སྐོར་བཏང་ནས་ལྐོག་ཏུ་བྲོས་པ་ཅི་ཡིན༌ནམ། བདག་ལ་མི་སྨྲ་བའི་རྒྱུ་མཚན༌ཅི། གལ་ཏེ་བདག་ལ་སྨྲས༌ན། བདག་གིས་དགའ་སྟོན་བསྡུས་ཏེ་དགའ་སྐྱིད་ཀྱི་གླུ་གཞས་གཏོང་བ༌དང༌། སིལ་རྔ་རྡུང༌བ། པི་ཝང་དཀྲོལ་བ་བཅས་ཀྱིས་ཁྱོད་ལ་སྐྱེལ་མ་བྱེད་པ་མ་ཡིན༌ནམ། ");
INSERT INTO bodn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ཡང་ཁྱོད་ཀྱིས་བདག་གི་ཚ་རྒྱུད་དང་བུ་མོ་རྣམས་ལ་འོ་བྱེད་དུ་མ་བཅུག་པར་བྲོས་པ་ནི་ཇི་འདྲའི་གླེན་པ་ཞིག་རེད༌ཨང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","བདག་ལ་སྔར་ནས་ཁྱོད་རང་གསོད་པའི་དབང་ཆ་ཡོད༌ནའང༌། མདང་དགོང་ཁྱོད་ཀྱི་ཕ་ཡི་དཀོན་མཆོག་གིས་བདག་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་གཟབ་གཟབ༌བྱོས། ཡ་ཀོབ་ལ་གཏམ་བཟང་ངན་ཅི་ཡང་མི་སྨྲ་བར་གྱིས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ད་ལྟ་ཁྱོད་ཀྱིས་རང་གི་ཕ་ཡི་ཁྱིམ་མི་དང་བཅས་པ་ཤིན་ཏུ་དྲན་ཏེ་ཡུལ་ལ་མི་འགྲོ་ཐབས་མེད་ཡིན༌ཡང༌། ཁྱོད་ཀྱིས་བདག་གི་ལྷ་སྐུ་རྣམས་བརྐུས་པའི་རྒྱུ་མཚན་ཅི་ཞེས་དྲིས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ཡ་ཀོབ་ན༌རེ། ཁྱེད་ཀྱིས་བདག་ལས་ཁྱེད་ཀྱི་བུ་མོ་འཕྲོག་པར་བསམས་ཏེ་འཇིགས་ཤིང་བྲོས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ཁྱེད་ཀྱིས་སུ་ཞིག་གི་ལག་ནས་ལྷ་སྐུ་རྣམས་བཙལ་ཏེ་རྙེད༌ཚེ། མི་དེ་བསད་ཀྱང་རུང༌ངོ༌། །བདག་གི་འདི་རུ་དངོས་པོ་གང་ཞིག་ཁྱེད་ཀྱི་ཡིན་ན་ཁྱེར༌ཞིག ཁྱེད་ཀྱིས་རང་ཅག་སྤུན་ཟླ་རྣམས་ཀྱི་མིག་མདུན་ནས་འཚོལ་ཞིག་ཅེས་སྨྲས༌སོ། །དེ་ནི་ཡ་ཀོབ་ཀྱིས་རཱ་ཧེལ་གྱིས་ལྷ་སྐུ་དག་བརྐུས་ཟིན་པ་མི་ཤེས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","དེ་ནས་ལཱ་པན་ནི་ཡ་ཀོབ༌དང༌། ལེ༌ཨ། གཡོག་མོ་གཉིས་དང་བཅས་པའི་གུར་རེ་རེའི་ནང་དུ་སོང་བ་དང་ཅི་ཡང་མ་རྙེད༌དོ། །དེ་ནས་ཁོ་རང་ལེ་ཨའི་གུར་ལས་ཕྱིར་བུད་དེ་རཱ་ཧེལ་གྱི་གུར་ནང་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","དེ་ཡང་རཱ་ཧེལ་གྱིས་ལྷ་སྐུ་རྣམས་ཏ་ལན་ནང་དུ་སྦས་ཤིང་ཁོ་མོ་ཏ་ལན་སྟེང་དུ་ཙོག་པུར་བསྡད་ཡོད༌དོ། །དེ་ནས་ལཱ་པན་གྱིས་སྦྲ་གུར་ཡོངས་སུ་བཙལ་ཡང་ཅི་ཡང་མ་རྙེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","རཱ་ཧེལ་གྱིས་ཁོ་མོའི་ཕ་ལཱ་པན་ལ་འདི༌ལྟར། ཕ༌ལགས། ད་ལྟ་བདག་གི་ལུས་པོ་དེ་འདྲ་མི་བདེ་བས་ཁྱེད་ཀྱི་དྲུང་དུ་བདག་ཡར་ལངས་མ་ཐུབ༌ན། ཁྱེད་ཉིད་ཐུགས་རྒྱལ་མི་བཞེངས་པར་མཛོད་ཅེས་སྨྲས༌སོ། །དེ་ལྟར་ལཱ་པན་གྱིས་ལྷ་སྐུ་རྣམས་བཙལ་ནས་མ་རྙེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","དེར་ཡ་ཀོབ་ཁོང་ཁྲོ་ལངས་ཏེ་ལཱ་པན་ལ་འདི་ལྟར་སྡིགས་དམོད་བྱས་པ༌སྟེ། བདག་ལ་ནོར་འཁྲུལ་ཅི་དང་ཉེས་པ་ཅི་ཡོད༌དམ། ཁྱེད་ཀྱིས་འདི་ལྟར་བདག་གི་རྗེས་བསྙེགས༌སམ། ");
INSERT INTO bodn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ཁྱེད་ཀྱིས་བདག་གི་ཅ་ལག་ཐམས་ཅད་བསློགས་ཀྱང་ཁྱེད་ཀྱི་དངོས་པོ་བཙལ་ནས་རྙེད༌དམ། གལ༌ཏེ། ད་ལྟ་དངོས་པོ་དེ་བཙལ་ནས་རྙེད༌ན། ངེད་གཉིས་ཀྱི་སྤུན་ཟླ་དག་གི་མིག་མདུན་དུ་བཤམས༌ཏེ། ཁོ་རྣམས་ལ་ངེད་གཉིས་བར་ཤན་འབྱེད་དུ༌བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","བདག་ནི་ཁྱེད་ཀྱི་ཁྱིམ་དུ་ལོ་ངོ་ཉི་ཤུའི་རིང་ལ་བསྡད་མྱོང༌སྟེ། ཁྱེད་ཀྱི་མ་མོ་དང་ར་མ་ལ་མངལ་ཤོར་དུ་བཅུག་མ་མྱོང་བ༌དང༌། བདག་གིས་ཁྱེད་ཀྱི་ལུག་ཁྱུ་ལས་ལུག་ཐུག་གཅིག་ཀྱང་བཤས་མ༌མྱོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","གཅན་གཟན་གྱིས་བསད་པའི་ལུག་རོ་དག་ཀྱང་ཁྱེད་ཀྱི་མདུན་དུ་ཁྱེར་མ་ཡོང་བར་རང་གིས་སྐྱིན་ཚབ་སྤྲད་པ༌དང༌། རྐུན་མས་ཉིན་མཚན་དབྱེ་བ་མེད་པར་བརྐུས་པ་དག་གི་ཚབ་ཀྱང་ཁྱེད་ཀྱིས་བདག་ལས་བླངས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","བདག་གིས་རྒྱུན་དུ་ཉིན་མོར་ཚ་བ་དང་མཚན་མོར་གྲང་ངར་གྱི་དཀའ་བ་མྱངས་ཤིང་གཉིད་ཀྱང་མ༌ཁུགས། ");
INSERT INTO bodn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","དེ་ལྟར་བདག་ནི་ལོ་ངོ་ཉི་ཤུའི་རིང་ལ་ཁྱེད་ཀྱི་ཁྱིམ་དུ་བསྡད༌ཅིང༌། ཁྱེད་ཀྱི་བུ་མོ་གཉིས་ཀྱི་ཆེད་དུ་ལོ་ངོ་བཅུ་བཞིའི་རིང་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབས་པ༌དང༌། བདག་ལ་ར་ལུག་གི་ཁྱུ་འཐོབ་པའི༌ཕྱིར། བདག་གིས་ལོ་ངོ་དྲུག་གི་རིང་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབས་པ༌དང༌། ཡང་ཁྱེད་ཀྱིས་བདག་གི་གླ་ཆ་ཐེངས་བཅུ་ལ་བསྒྱུར་ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","གལ༌ཏེ། བདག་གི་ཕ་ཨི་སཱག་གུས་ཤིང་འཇིགས་པའི་དཀོན་མཆོག༌སྟེ། ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་བདག་དང་མཉམ་དུ་གནས་མེད༌ན། ད་ལྟ་ཁྱེད་ཀྱིས་བདག་ལག་སྟོང་དུ་ཕྱིར་བདའ་བར༌ངེས། འོན༌ཀྱང༌། དཀོན་མཆོག་གིས་བདག་གི་སྐྱོ་སྡུག་དང་ངལ་བ་གཟིགས༌ཏེ། མདང་དགོང་ཁྱེད་ལ་བཀའ་བཀྱོན་གནང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","དེ་ནས་ལཱ་པན་གྱིས་ཡ་ཀོབ་ལ་འདི་ལྟར་ལན་བཏབ༌པ། བུ་མོ་འདི་གཉིས་ནི་བདག་གི་བུ་མོ་ཡིན་པ༌དང༌། བྱིས་པ་འདི་དག་ཀྱང་བདག་གི་བྱིས་པ་ཡིན༌ལ། ར་ལུག་གི་ཁྱུ་འདི་དག་ཀྱང་བདག་གི་ཡིན་པར་མ༌ཟད། ཁྱོད་ཀྱི་མིག་མདུན་དུ་ཡོད་པ་ཐམས་ཅད་བདག་གི་ཡིན༌མོད། འོན་ཀྱང་དེ་རིང་བདག་གི་བུ་མོ་གཉིས་དང་ཁོ་མོ་གཉིས་ཀྱིས་བཙས་པའི་བྱིས་པ་དག་ལ་བདག་གིས་ཅི་བྱ་འོས༌སམ། ");
INSERT INTO bodn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ཤོག༌དང༌། ངེད་གཉིས་ཀྱིས་གྲོས་འཆམ་བཞག༌སྟེ། ངེད་གཉིས་བར་གྱི་དཔང་རྟགས་སུ་བྱའོ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ཡང་ཡ་ཀོབ་ཀྱིས་རྡོ་ལེབ་ཅིག་གྱེན་དུ་བསྒྲེངས་ནས་ཀ་བ་རུ་བྱས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","སྤུན་ཟླ་རྣམས་ལ་ན༌རེ། ཁྱོད་རྣམས་ཀྱིས་རྡོ་སྤུངས་རྒྱོབས་ཤིག་ཅེས་སྨྲས་པ་དང་ཁོ་རྣམས་ཀྱིས་དེ་ལྟར་བྱས་ཤིང་མི་ཚང་མས་རྡོ་སྤུངས་ཀྱི་འགྲམ་དུ་ཁ་ཟས༌སྤྱད། ");
INSERT INTO bodn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ལཱ་པན་གྱིས་རྡོ་སྤུངས་དེ་ལ་ཡཱ་གར་སཱ་ཧ་དཱ་ཐཱ་ཞེས་མིང་བཏགས་པ༌དང༌། ཡ་ཀོབ་ཀྱིས་དེ་ལ་ག་ལེད་ ཅེས༌བཏགས། ");
INSERT INTO bodn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ལཱ་པན་ན༌རེ། དེ་རིང་གི་རྡོ་སྤུངས་འདི་ནི་ངེད་གཉིས་བར་གྱི་དཔང་རྟགས་ཡིན་ཞེས་སྨྲས་པའི་རྐྱེན༌གྱིས། ས་ཆ་འདིའི་མིང་ལ་ག་ལེད་ཅེས་ཟེར་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ས་ཆ་འདིའི་མིང་ལ་མཱས་ཟི་ཕཱ་ཡང༌ཟེར། ཅིའི་ཕྱིར་ཞེ༌ན། ལཱ་པན་ན༌རེ། ངེད་རང་གཉིས་ཁ་བྲལ་བའི་རྗེས༌སུ། དཀོན་མཆོག་ཡ་ཝཱེས་ངེད་གཉིས་བར་དུ་ལྟ་རྟོགས་མཛད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","གལ༌ཏེ། ཁྱོད་ཀྱིས་བདག་གི་བུ་མོ་གཉིས་ཀ་དཀའ་སྡུག་ལ་སྦྱར་བ༌དང༌། ཡང་བདག་གི་བུ་མོ་གཉིས་ཀའི་ཕན་ཆད་ནས་གཞན་ཞིག་ཆུང་མར་བླངས་པ་སུས་ཀྱང་མི་ཤེས༌ནའང༌། དཀོན་མཆོག་གིས་ངེད་གཉིས་བར་དུ་བདེན་དཔང་མཛད་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ཡང་ལཱ་པན་ན༌རེ། བདག་གིས་ངེད་གཉིས་བར་དུ་སྤུངས་པའི་རྡོ་སྤུངས་དང་གྱེན་དུ་བསྒྲེངས་པའི་ཀ་བ་ལ་ལྟོས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","རྡོ་སྤུངས་འདིས་བདེན་དཔང་བྱེད་པར་མ༌ཟད། ཀ་བ་འདིས་ཀྱང་བདེན་དཔང་བྱེད་པར་འགྱུར་བ༌དང༌། བདག་གིས་རྡོ་སྤུངས་འདི་ལས་བརྒལ་ནས་ཁྱོད་ལ་གནོད་པ་བྱེད་མི་སྲིད༌ལ། ཁྱོད་ཀྱིས་ཀྱང་རྡོ་སྤུངས་དང་ཀ་བ་འདི་ལས་བརྒལ་ནས་བདག་ལ་གནོད་པ་བྱེད་མི་རུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ཨབ་ར་ཧམ་དང་ནཱ་ཧོར་གྱི་དཀོན་མཆོག༌སྟེ། ཁོ་གཉིས་ཀྱི་ཕ་ཡི་དཀོན་མཆོག་གིས་ངེད་གཉིས་བར་དུ་ལེགས་ཉེས་ཀྱི་ཤན་འབྱེད་པར་འགྱུར་ཞེས་སྨྲས༌སོ། །དེ་ནས་ཡ་ཀོབ་ཀྱིས་རང་གི་ཕ་ཨི་སཱག་གུས་ཤིང་འཇིགས་པའི་དཀོན་མཆོག་ལ་དམ་བཅས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ཡང་རི་སྒང་དུ་དམར་མཆོད་ཕུལ་བ༌དང༌། སྤུན་ཟླ་རྣམས་གདན་དྲངས་པ་དང་དེ་དག་གིས་ཁ་ཟས་སྤྱད་ནས་རི་སྒང་ནས་ཞག་སྡོད་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","དེ་ནས་ཞོགས་པར་ལཱ་པན་ཡར་ལངས་ཏེ་རང་གི་ཚ་བོ་དང་ཚ༌མོ། བུ་མོ་རྣམས་ལ་འོ་བྱས་པ་དང་བྱིན་རླབས་གནང་རྗེས་ཕྱིར་རང་ཡུལ་དུ་ལོག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","དེ་ནས་ཡ་ཀོབ་མུ་མཐུད་དུ་ལམ་ལ་ཆས་ཤིང་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་ཁོ་དང་ཕྲད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ཡ་ཀོབ་ཀྱིས་ཕོ་ཉ་རྣམས་མཐོང༌སྟེ། འདི་ནི་དཀོན་མཆོག་གི་དམག་དཔུང་ཡིན་ཞེས་སྨྲས་པས་གནས་དེར་མཱ་ཧ་ནཱ་ཡིམ་ ཞེས་མིང་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ཨེ་དོམ་ཡུལ་གྱི་སེ་ཨེར་དུ་ཡོད་པའི་གཅེན་པོ་ཨེ་སཱབ་ཀྱི་གམ་དུ་མི་འགའ་མངགས་ཤིང་དེ་རྣམས་ལ་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ཁྱོད་ཅག་གིས་བདག་གི་ཇོ་བོ་ཨེ་སཱབ་ལ་འདི་ལྟར་ཤོད་ཅིག ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ཡ་ཀོབ་ཀྱིས་ཁྱེད་ལ་འདི༌ལྟར་སྨྲའོ།། བདག་ནི་ད་ལྟའི་བར་དུ་ལཱ་པན་དང་མཉམ་དུ་བསྡད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","བདག་ལ་བ་གླང༌དང༌། བོང༌བུ། ར་ལུག་གི༌ཁྱུ། གཡོག་པོ་གཡོག་མོ་སོགས་ཡོད་པ༌དང༌། ཁྱེད་ཀྱི་སྤྱན་དྲུང་ནས་བདག་ལ་ཐུགས་རྗེ་འཐོབ་པའི༌ཕྱིར། ད་ལྟ་བདག་གིས་དོན་འདི་ཁྱེད་ལ་ཞུ་བར་མི་མངགས་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","དེ་ནས་ཡ་ཀོབ་ཀྱིས་མངགས་པའི་མི་རྣམས་ཕྱིར་ལོག་སྟེ་ན༌རེ། ངེད་ཅག་ཁྱེད་ཀྱི་གཅེན་པོ་ཨེ་སཱབ་ཀྱི་དྲུང་དུ་སོང་བ༌དང༌། ད་ལྟ་ཁོང་གིས་མི་བཞི་བརྒྱ་ཁྲིད་དེ་ཁྱེད་ཀྱི་མདུན་བསུས་ནས་ཡོང་བཞིན་ཡོད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ཡ་ཀོབ་ཤིན་ཏུ་འཇིགས་ནས་སེམས་ཁྲལ་བྱུང་བ༌དང༌། རང་གི་འཁོར་དང་བཅས་པའི་མི་ཐམས་ཅད༌དང༌། ར་ལུག་དང་བ་གླང་གི༌ཁྱུ། རྔ་མོང་སོགས་སྐོར་ཁྱུ་ཆེན་པོ་གཉིས་སུ་བགོས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","སེམས་སུ་གལ་སྲིད་ཨེ་སཱབ་སླེབས་ནས་སྐོར་ཁྱུ་འདི་འཇོམས་པར་བྱས༌ན། སྐོར་ཁྱུ་ཅིག་ཤོས་ནི་ད་དུང་བྲོས་ཆོག་པ་ཡིན་སྙམ༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ཡ་ཀོབ་ན༌རེ། ཀྱེ། དཀོན་མཆོག་ཡ༌ཝཱེ། བདག་གི་མེས་པོ་ཨབ་ར་ཧམ་དང་ཡབ་ཨི་སཱག་གི་དཀོན་མཆོག༌ལགས། ཁྱེད་ཀྱིས་དེ་སྔར་བདག་ལ་ཁྱོད་ནི་རང་གི་ཕ་ཡུལ་དང་གཉེན་ཉེ་རྣམས་ཀྱི་གམ་དུ་སོང༌ཞིག བདག་གིས་ཁྱོད་ལ་སྐྱབས་མཛད་ངེས་ཡིན་ཞེས་གསུངས་པ་མ་ཡིན༌ནམ། ");
INSERT INTO bodn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ཁྱེད་ཀྱིས་ཞབས་ཕྱི་པ་བདག་ལ་གནང་བའི་བྱམས་སྙིང་རྗེ་དང་དྲང་བདེན་ཐམས་ཅད་ནི་བདག་ལ་མི་འོས༌སོ། །སྔོན་ཆད་བདག་གིས་མཁར་བ་བཟུང་ནས་ཡོར་དན་གཙང་པོ་འདི་ལས་བརྒལ་བ༌དང༌། ད་ལྟ་བདག་ནི་སྡེ་ཚན་ཆེན་པོ་གཉིས་སུ་གྱུར༌ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ཁྱེད་ཀྱིས་ང་རང་བདག་གི་གཅེན་པོ་ཨེ་སཱབ་ལས་སྐྱོབ་པར༌མཛོད། ཅིའི་ཕྱིར་ཞེ༌ན། གཅེན་པོས་བདག་དང་བདག་གི་ཆུང་མ་བུ་ཕྲུག་བཅས་མཉམ་དུ་གསོད་པར་འཇིགས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ཁྱེད་ཀྱིས་དེ་སྔར་བདག་ལ་འདི་སྐད༌དུ། བདག་གིས་ཁྱོད་ལ་སྐྱབས་མཛད་ངེས༌ཡིན། ཁྱོད་ཀྱི་རིགས་རྒྱུད་ནི་རྒྱ་མཚོའི་འགྲམ་གྱི་བྱེ་མ་བཞིན་མང་དུ་སྤེལ་བར་ངེས་ཞེས་གསུངས་མྱོང་བ་ཡིན་ཞེས་གསོལ་བ་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ཉིན་དེའི་མཚན༌མོར། ཡ་ཀོབ་ཡུལ་དེར་བསྡད་ཅིང་ཁོ་ལ་དབང་བའི་རྒྱུ་ནོར་ཐམས་ཅད་ལས་རང་གི་གཅེན་པོར་ལེགས་སྐྱེས༌སུ། ");
INSERT INTO bodn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ར་མ་ཉིས་བརྒྱ༌དང༌། ར་ཐུག་ཉི༌ཤུ། མ་མོ་ཉིས༌བརྒྱ། ལུག་ཐུག་ཉི༌ཤུ། ");
INSERT INTO bodn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","འོ་མ་སྣུན་པའི་རྔ་མོང་སུམ་ཅུ་དང་དེའི་ཕྲུ་གུ་དང་བཅས༌པ། བ་མོ་བཞི་བཅུ་དང་བ་གླང༌བཅུ། བོང་མ་ཉི་ཤུ་དང་བོང་གསེབ་བཅུ་བཅས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","རིགས་རེ་རེ་ལས་ཁྱུ་རེ་བླངས་ནས་གཡོག་པོ་རྣམས་ལ་སྤྲད༌དེ། ཁྱོད་ཅག་བདག་གི་སྔོན་ལ་སོང༌དང༌། ཕྱུགས་ཁྱུ་རེ་རེ་བཞིན་སོ་སོར་ཕྱེས་ནས་སོང་ཞིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","དེ་ནས་ཡ་ཀོབ་ཀྱིས་འགྲོ་ཐེངས་ཐོག་མ་རྣམས་ལ་འདི་ལྟར་སྨྲས༌པ། བདག་གི་གཅེན་པོ་ཨེ་སཱབ་ཁྱོད་དང་འཕྲད་པའི་དུས༌སུ། ཁོ་ན༌རེ། ཁྱོད་སུ་ཚང་གི་ཡིན་པ་དང་གང་ལ་འགྲོ་བ༌ཡིན། ཁྱོད་ཀྱི་སྔོན་དུ་ཡོད་པའི་ཕྱུགས་ཁྱུ་འདི་དག་སུ་ཞིག་གི་ཡིན་ནམ་ཞེས་དྲིས༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ཁྱོད་ཀྱིས་འདི་ལྟར་ཤོད༌ཅིག འདི་དག་ནི་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ཡ་ཀོབ་ཀྱི་ཡིན༌ལ། བདག་གི་ཇོ་བོ་ཨེ་སཱབ་ལ་བསྐུར་བའི་ལེགས་སྐྱེས་ཡིན༌ཞིང༌། ཡ་ཀོབ་ཁོ་རང་ཡང་ངེད་ཅག་གི་རྗེས་སུ་ཡོད་ཅེས་སྨྲོས་ཤིག་ཅེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","དེ་ནས་ཡང་ཡ་ཀོབ་ཀྱིས་འགྲོ་ཐེངས་གཉིས་པ་དང་གསུམ༌པ། ཕྱུགས་ཟོག་འདེད་མཁན་གཞན་ཐམས་ཅད་ལ་འདི༌ལྟར། ཁྱོད་ཅག་བདག་གི་གཅེན་པོ་ཨེ་སཱབ་ལ་འཕྲད་པའི་དུས་སུའང་འདི་ལྟར་སྨྲ་དགོས་པར་མ༌ཟད། ");
INSERT INTO bodn_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ཡ་ཀོབ་ནི་ངེད་ཅག་གི་རྗེས་སུ་ཡོད་ཅེས་སྨྲོས་ཤིག་ཅེས་སྨྲས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཡ་ཀོབ་ཀྱི་སེམས༌སུ། བདག་གིས་སྔོན་ལ་མངགས་པའི་ལེགས་སྐྱེས་ལ་བརྟེན་ནས་གཅེན་པོའི་ཞེ་སྡང་ཞི་བར་བྱེད་པ༌དང༌། ཕྱིས་སུ་ཁོ་དང་ངོ་འཕྲད་དུས་སུ་ཁོས་ང་རང་ལ་དགའ་བསུ་བྱེད་ཀྱང་སྲིད་སྙམ་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","དེ་ལྟར་ལེགས་སྐྱེས་ཐམས་ཅད་སྔོན་དུ་བསྐུར་ཟིན༌ལ། ཉིན་དེའི་མཚན༌མོར། ཡ་ཀོབ་ལམ་བར་དུ་ཞག་སྡོད་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","དེ་ནས་ཡ་ཀོབ་མཚན་མོ་དེར་མལ་ལས་ལངས་ཏེ་ཆུང་མ་གཉིས་ཀ༌དང༌། གཡོག་མོ༌གཉིས་ཀ གཞན་ཡང་བུ་ཕྲུག་བཅུ་གཅིག་དང་བཅས་པ་ཁྲིད་དེ་ཡཱབ་པོག་ཆུ་བོའི་རབ་ཁ་བརྒལ་ནས༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","དེ་ཡང་ཡ་ཀོབ་ཀྱིས་ཐོག་མར་ཁོ་རྣམས་ཆུ་བོར་བརྒལ་དུ་བཅུག་པ༌དང༌། དེ་ནས་གཞན་ཐམས་ཅད་ཀྱང་འགྲོ་རུ༌བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ཡ་ཀོབ་ཁོ་ན་ཤུལ་དུ་ལུས་ཤིང་མི་ཞིག་ཡོང་སྟེ་ནམ་ལངས་པའི་བར་དུ་ཁོ་དང་འཇུ་རེས༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","མི་དེས་ཡ་ཀོབ་ལས་རྒྱལ་མི་ཐུབ་པ་ཤེས་ཏེ་ཡ་ཀོབ་ཀྱི་དཔྱི་མིག་ལ་རེག་པ༌ན། ཡ་ཀོབ་ཀྱི་དཔྱི་མགོ་ནི་འཇུ་རེས་བྱེད་སྐབས་ཚིགས་འཁྲོག་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","དེ་ནས་མི་དེ་ན༌རེ། ད་ནི་ནམ་ལངས་སོང་བས་ང་རང་འགྲོ་རུ་ཆུག་ཅེས་སྨྲས་པ༌དང༌། ཡ་ཀོབ་ན༌རེ། ཁྱེད་ཀྱིས་བདག་ལ་བྱིན་རླབས་གནང་བ་མིན༌ན། བདག་གིས་ཁྱེད་འགྲོ་རུ་མི་འཇུག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","དེར་མི་དེ་ན༌རེ། ཁྱོད་ཀྱི་མིང་ལ་ཅི་ཟེར་ཞེས་དྲིས་པ༌དང༌། ཡ་ཀོབ་ན༌རེ། བདག་གི་མིང་ལ་ཡ་ཀོབ་ཟེར་ཞེས་ལན༌བཏབ། ");
INSERT INTO bodn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ཡང་མི་དེ་ན༌རེ། ད་ནས་བཟུང་ཁྱོད་ལ་ཡ་ཀོབ་ཅེས་མི་འབོད་པར་ཡེས་ར་ཨེལ་ཞེས་འདོགས་པར༌གྱིས། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ནི་དཀོན་མཆོག་དང་མིའི་རིགས་ལ་འགྲན་ཏེ་རྣམ་པར་རྒྱལ་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ཡ་ཀོབ་ཀྱིས་མི་དེ་ལ་ཁྱེད་ཀྱི་མིང་ལ་ཅི་ཟེར་ཞེས་དྲིས་པ༌དང༌། མི་དེ་ན༌རེ། བདག་གི་མིང་འདྲི་བའི་རྒྱུ་མཚན་ཅི་ཞེས་སྨྲས་པ་དང་ཡ་ཀོབ་ལ་བྱིན་རླབས་གནང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","དེ་ནས་ཡ་ཀོབ་ཀྱིས་ས་ཆ་དེའི་མིང་ལ་ཕཱ་ནེ་ཨེལ་ཞེས་བཏགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ངས་ཁ་རི་ཁ་ཐུག་ཏུ་དཀོན་མཆོག་མཇལ༌ནའང༌། ཁོང་གིས་བདག་གི་ཚེ་སྲོག་བསྐྱབས་པ་ཡིན་ཞེས་སྨྲས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","དེ་ཡང་ཡ་ཀོབ་ནི་ཕཱ་ནེ་ཨེལ་ཡུལ་བརྒྱུད་ནས་འགྲོ་བའི་དུས༌སུ། ཁོའི་ལུས་ལ་ཉི་འོད་ཤར་བ༌དང༌། ཁོའི་དཔྱི་ཚིགས་ན་བའི་རྐྱེན་གྱིས་རྐང་པ་གྱོལ་བཞིན་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","དེའི༌ཕྱིར། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ད་ལྟའི་བར་དུ་ཕྱུགས་ཟོག་གི་དཔྱི་མགོའི་རྩ་རྒྱུས་མི༌ཟའོ། །ཅིའི་ཕྱིར་ཞེ༌ན། མི་དེས་ཡ་ཀོབ་ཀྱི་དཔྱི་མགོའི་རྩ་རྒྱུས་ལ་རེག་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","དེ་ནས་ཡ་ཀོབ་ཀྱིས་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། ཨེ་སཱབ་དང་མི་བཞི་བརྒྱ་ལྷག་ཡོང་བཞིན་པ་མཐོང༌ངོ༌། །ཡ་ཀོབ་ཀྱིས་བྱིས་པ་རྣམས་སོ་སོར་བཀར་ནས་ལེ་ཨ༌དང༌། རཱ༌ཧེལ། གཡོག་མོ་གཉིས་བཅས་ལ་སྤྲད་པར་མ༌ཟད། ");
INSERT INTO bodn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","གཡོག་མོ་གཉིས་ཀ་དང་ཁོ་ཚོའི་བྱིས་པ་རྣམས་སྔོན་དུ་འགྲོ་བ༌དང༌། ལེ་ཨ་དང་ཁོ་མོའི་བྱིས་པ་རྣམས་བར་དུ་འགྲོ་བ༌དང༌། རཱ་ཧེལ་དང་ཁོ་མོའི་བུ་ཡོ་སེབ་གཉིས་ཀ་རྗེས་སུ་འགྲོ་རུ་བཅུག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ཁོ་རང་དེ་དག་གི་མདུན་དུ་སྐྱོད༌ཅིང༌། ཐེངས་བདུན་ཙམ་ལ་ཕྱག་འཚལ་བཞིན་ཁོའི་གཅེན་པོའི་དྲུང་དུ་སླེབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","དེ་ནས་ཨེ་སཱབ་རྒྱུགས་འོངས་ནས་བསུ་བ་བྱེད་བཞིན་ཡ་ཀོབ་ལ་འཐམས་པ༌དང༌། ཡང་ཡ་ཀོབ་ཀྱི་སྐེ་ལ་དམ་པོར་འཇུས་ཏེ་འོ་བྱས་པ་དང་ཁོ་གཉིས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ཨེ་སཱབ་ཀྱིས་མགོ་ཡར་བཀྱགས་ནས་བུད་མེད་དང་བྱིས་པ་རྣམས་ལ་བལྟས༌ཏེ། ཁྱོད་དང་འགྲོགས་ནས་ཡོང་བ་འདི་དག་སུ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། ཡ་ཀོབ་ན༌རེ། བྱིས་པ་འདི་དག་ནི་དཀོན་མཆོག་གི་ཐུགས་རྗེ་ལས་ཁྱོད་ཀྱི་ཞབས་ཕྱི་པ་ཕྲན་ལ་གནང་བ་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","དེ་ནས་གཡོག་མོ་གཉིས་ཀ་དང་ཁོ་ཚོའི་བྱིས་པ་རྣམས་ཡོང་ནས་ཨེ་སཱབ་ལ་ཕྱག་བཙལ་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ལེ་ཨ་དང་ཁོ་མོའི་བྱིས་པ་རྣམས་ཀྱང་ཡོང་ནས་ཁོ་ལ་ཕྱག་བཙལ་བ༌དང༌། དེའི་འཕྲོར་རཱ་ཧེལ་དང་ཁོ་མོའི་བུ་ཡོ་སེབ་གཉིས་ཀྱང་ཡོང་ནས་ཁོ་ལ་ཕྱག་བཙལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","དེ་ནས་ཨེ་སཱབ་ན༌རེ། བདག་ལ་ཕྱུགས་ཟོག་འདི་དག་གནང་བའི་དོན་ཅི་ཡིན་ནམ་ཞེས་པ༌ལ། ཡ་ཀོབ་ན༌རེ། བདག་གི་ཇོ་བོ༌ལགས། ཁྱེད་ཀྱིས་བདག་ལ་ཐུགས་རྗེས་གཟིགས་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ཡང་ཨེ་སཱབ་ན༌རེ། བདག་གི་གཅུང༌པོ། བདག་ལ་རྒྱུ་ནོར་མང་པོ་ཡོད་པས་ཁྱོད་ཀྱི་རྒྱུ་རྫས་ནི་རང་ཉིད་ལ་དབང་བར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ཡ་ཀོབ་ན༌རེ། མིན༌ཏེ། བདག་ལ་ཁྱེད་ཀྱི་སྤྱན་དྲུང་ནས་ཐུགས་རྗེ་ཐོབ༌ན། ཁྱེད་ཀྱིས་བདག་ལས་ལེགས་སྐྱེས་འདི་དག་ལེན་པར༌མཛོད། ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་ཁྱེད་རང་མཐོང་བ་ནི་དཀོན་མཆོག་གི་ཞལ་རས་མཇལ་བ་དང་མཚུངས་ཤིང་ཁྱེད་ཀྱིས་བདག་ལ་དགའ་བསུའང་བྱས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","བདག་གིས་ཁྱེར་འོངས་པའི་ལེགས་སྐྱེས་འདི་དག་ཁྱེད་ཀྱིས་ལེན་པར༌མཛོད། ཅིའི་ཕྱིར་ཞེ༌ན། དཀོན་མཆོག་གིས་བདག་ལ་ཐུགས་རྗེས་གཟིགས་ཏེ་རྒྱུ་ནོར་མང་པོ་དང་ལྡན་པར་མཛད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ཡ་ཀོབ་ཀྱིས་ཨེ་སཱབ་ལ་ཡང་ཡང་ཞུ་བ་བྱས་པས་ཁོས་ཀྱང་བླངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","དེ་ནས་ཨེ་སཱབ་ན༌རེ། རང་ཅག་ཡར་ལངས་ཏེ་ལམ་དུ་ཆས་པར༌བྱ། ང་ཁྱོད་ཀྱི་སྔོན་དུ་འགྲོ་བར་བྱའོ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ཡ་ཀོབ་ན༌རེ། བྱིས་པ་རྣམས་ལོ་ན་ཕྲ་བ༌དང༌། ཕྱུགས་ཁྱུས་འོ་མ་སྣུན་པའི་དུས༌སུ། བཙན་གྱིས་ཉིན་གཅིག་རིང་ལ་དེད་ན་ར་ལུག་གི་ཁྱུ་ཡོངས་རྫོགས་འཆི་ངེས་པ་ཇོ་བོ་ཁྱེད་ཀྱིས་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ཇོ་བོ༌ལགས། ཁྱེད་ནི་ཞབས་ཕྱི་པ་བདག་གི་སྔོན་དུ་འགྲོ་བར༌མཛོད། བདག་གིས་མདུན་ཕྱོགས་ཀྱི་ཕྱུགས་ཁྱུའི་མྱུར་ཚད༌དང༌། བྱིས་པ་རྣམས་ཀྱི་མགྱོགས་ཚད༌ལྟར། སེ་ཨིར་ཡུལ་ལ་ཇོ་བོའི་མདུན་དུ་སླེབས་པའི་བར་དུ་ག་ལེར་མདུན་དུ་བསྐྱོད་པར་བྱ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ཡང་ཨེ་སཱབ་ན༌རེ། བདག་དང་མཉམ་དུ་ཡོད་པའི་མི་འགའ་ཞིག་ཁྱོད་ཀྱི་གམ་དུ་བསྐྱུར་ཆོག་པར་ཞུ་ཞེས་སྨྲས་པ༌ལ། ཡ་ཀོབ་ན༌རེ། བདག་གི་ཇོ་བོ༌ལགས། དེ་འདྲ་བྱེད་དགོས་དོན་མེད༌དེ། ཁྱེད་ཀྱི་མིག་མདུན་ནས་བདག་ལ་ཐུགས་རྗེས་གཟིགས་པར་ཞུ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","དེའི༌ཕྱིར། ཨེ་སཱབ་ཉིན་དེར་སེ་ཨིར་ཡུལ་དུ་འགྲོ་བའི་ལམ་ལ་ཆས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","དེ་ནས་ཡ་ཀོབ་འཁོར་དང་བཅས་པ་སོའུ་ཀོད་ཡུལ་དུ་སོང་བ་དང་དེ་རུ་རང་ལ་ཁང་པ་དང་ཕྱུགས་ལ་སྤྱིལ་བུའང་བཟོས༌པས། ཡུལ་དེའི་མིང་ལ་སོའུ་ཀོད་ ཅེས་འབོད་པར་བྱེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","དེ་ནས་ཡ་ཀོབ་ཁོ་རང་ཕཱ་དན་ཨ་རམ་ཡུལ་ནས་ཕྱིར་ལོག་པའི་དུས༌སུ། བདེ་བའི་ངང་ཀ་ན་ཨན་ཡུལ་གྱི་སི་ཀེམ་གྲོང་ཁྱེར་དུ་སླེབས་ཤིང་གྲོང་ཁྱེར་དེའི་མདུན་ཕྱོགས་སུ་གུར་ཕུབ་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","སི་ཀེམ་གྱི་ཕ་སྟེ་ཧ་མོར་གྱི་བུ་རྣམས་ལ་དངུལ་སྒོར་བརྒྱ་སྤྲད་དེ་གུར་ཕུབ་སའི་ས་ཉོས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","གནས་དེ་རུ་མཆོད་ཁྲི་ཞིག་ཀྱང་བཞེངས༌ཏེ། མིང་ལ་ཨེལ་ཨེ་ལོ་ཧེ་ཡེས་ར་ཨེལ་ ཞེས་བཏགས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","དེ་ཡང་ལེ་ཨ་ཡིས་ཡ་ཀོབ་ལ་བཙས་པའི་བུ་མོ་དི་ནཱ་བྱ་བ་ཡུལ་དེའི་བུ་མོ་རྣམས་ལ་བལྟ་རུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ཡུལ་དེའི་ས་གནས་དཔོན་པོ་ཧ་མོར་ཞེས་པའི་བུ་སི་ཀེམ་གྱིས་ཁོ་མོ་མཐོང་བ་དང་བཙན་གཡེམ༌བྱས། ཧ་མོར་ནི་ཧེ་བི་མི་རིགས་ལ་གཏོགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","དེ་ནས་སི་ཀེམ་གྱི་སེམས་སུ་ཡ་ཀོབ་ཀྱི་བུ་མོ་དི་ནཱ་ཤིན་ཏུ་འདོད་ཅིང་ཁོ་མོར་དགའ་བར་གྱུར་པས་ཚིག་སྙན་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","སི་ཀེམ་གྱིས་རང་གི་ཕ་ཧ་མོར་ལ་འདི༌ལྟར། ཕ༌ལགས། ཁྱེད་ཀྱིས་བུ་མོ་འདི་བདག་ལ་ཆུང་མར་ལེན་པར་མཛོད་ཅེས་ཞུ་བ༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","དེ་ནས་སི་ཀེམ་གྱིས་བུ་མོ་དི་ནཱ་མི་གཙང་བར་བྱས་པའི་གཏམ་དེ་ཡ་ཀོབ་ཀྱིས་ཐོས༌ཤིང༌། སྐབས༌དེར། ཡ་ཀོབ་ཀྱི་བུ་རྣམས་ཕྱུགས་ཟོག་དང་མཉམ་དུ་སྤང་ཐང་དུ་ཡོད༌པས། ཡ་ཀོབ་ཀྱིས་ཅི་ཡང་མི་སྨྲ་བར་བུ་རྣམས་ཕྱིར་ལོག་པར་སྒུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","དེ་ནས་སི་ཀེམ་གྱི་ཕ་ཧ་མོར་ཞེས་བྱ་བ་ཡ་ཀོབ་ལ་གྲོས་འདེབས་པར་ཡོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ཡ་ཀོབ་ཀྱི་བུ་རྣམས་ཀྱིས་དོན་དེ་ཐོས་པ་དང་སྤང་ཐང་ནས་ཡུལ་དུ་ལོག༌ཅིང༌། ཁོ་རྣམས་སེམས་སྐྱོ་ཞིང་ཁོང་ཁྲོ་ཆེན་པོ༌ལངས། ཅིའི་ཕྱིར་ཞེ༌ན། སི་ཀེམ་གྱིས་ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་དུ་སྐྱུག་བྲོ་བའི་ལས་བྱས་པ༌སྟེ། ཡ་ཀོབ་ཀྱི་བུ་མོ་ལ་བཙན་གཡེམ་བྱས་པ༌དང༌། དོན་དེ་ནི་འབྱུང་མི་འོས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ཧ་མོར་གྱིས་ཡ་ཀོབ་ཕ་བུ་རྣམས་ལ་འདི་ལྟར་གྲོས་བཏབ་པ༌སྟེ། བདག་གི་བུ་སི་ཀེམ་གྱི་སེམས་ནི་བུ་མོ་འདི་ལ་དགའ་བས་ན། ཁྱོད་ཅག་གིས་ཁོ་མོ་བདག་གི་བུ་ལ་ཆུང་མར་གནང་བར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ད་ནས་བཟུང་ངེད་རྣམས་བར་དུ་གཉེན་བཙུགས༌ཏེ། ཁྱོད་ཅག་གིས་བུ་མོ་རྣམས་ངེད་ཅག་ལ་སྟེར་བ༌དང༌། ངེད་ཅག་གི་བུ་མོ་རྣམས་ཀྱང་ཁྱོད་ཅག་གིས་ཆུང་མར་ལེན་པར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ངེད་རྣམས་དང་མཉམ་དུ་འདུག་པར༌གྱིས། ཡུལ་འདི་ནི་ཁྱོད་ཅག་གི་མདུན་དུ་ཡོད༌པས། འདི་རུ་བསྡད་ནས་ཚོང་ལས་གཉེར་བ་དང་ས་ཉོས་ཀྱང་ཆོག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","དེ་ནས་སི་ཀེམ་གྱིས་བུ་མོའི་ཕ་དང་གཅེན་གཅུང་རྣམས་ལ་འདི༌ལྟར། བདག་ལ་ཁྱོད་ཅག་གི་མིག་མདུན་ནས་ཐུགས་རྗེ་ཐོབ༌ན། ཁྱོད་ཅག་གིས་བདག་ལ་ཅི་ཞིག་བསླངས༌ཚེ། བདག་གིས་དེ་ནི་ཁྱོད་ཅག་ལ་སྟེར་ངེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ཁྱོད་ཅག་གིས་ཁོ་མོ་བདག་ལ་སྟེར་རྒྱུ་ཤ་སྟག་ཡིན༌ན། བག་རིན་དང་ལེགས་སྐྱེས་གང་རུང་བདག་ལ་བསླངས༌ནའང༌། བདག་གིས་ཁྱོད་ཅག་གིས་སྨྲས་པ་བཞིན་སྟེར་ངེས་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","དེ་ཡང་སི་ཀེམ་གྱིས་དི་ནཱ་མི་གཙང་བར་བྱས་པའི༌ཕྱིར། ཡ་ཀོབ་ཀྱི་བུ་རྣམས་ཀྱིས་གཡོ་སྒྱུའི་ངང་ནས་སི་ཀེམ་དང་ཁོའི་ཕ་ཧ་མོར་ལ་ལན་འདི་ལྟར་བཏབ་པ༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ངེད་ཅག་གིས་རང་གི་སྲིང་མོ་མཚན་སྐྱི་བཅད་མེད་པའི་མི་ཞིག་ལ་ཆུང་མར་སྟེར་མི༌རུང༌། ཅིའི་ཕྱིར་ཞེ༌ན། དེ་ནི་ངེད་ཅག་གི་ངོ་ཚ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","འོན༌ཀྱང༌། ཁྱོད་ཅག་གིས་དོན་དག་གཅིག་ཁོ་ན་བསྒྲུབ་ཐུབ༌ན་ངེད་ཅག་འཐད་པ་འབྱུང་ངེས་ཡིན༌ཏེ། ཁྱོད་ཅག་གི་སྐྱེས་པ་ཐམས་ཅད་ཀྱིས་ངེད་ཅག་དང་མཚུངས་པར་མཚན་སྐྱི་གཅོད་དགོས་པ༌དེའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","དེས་ན་ངེད་ཅག་གིས་བུ་མོ་རྣམས་ཁྱོད་ལ་སྟེར་བ༌དང༌། ཁྱོད་ཅག་གི་བུ་མོ་རྣམས་ཀྱང་ངེད་ཅག་གི་ཆུང་མར་ལེན་ངེས༌ཡིན། ངེད་རྣམས་ཀྱང་ཁྱོད་ཅག་དང་མཉམ་དུ་བསྡད་ནས་མི་རིགས་གཅིག་ཏུ་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","གལ༌ཏེ། ཁྱོད་ཅག་གིས་ངེད་རྣམས་ཀྱི་ངག་ལ་མི་ཉན་པ་དང་མཚན་སྐྱིའང་མི་གཅོད༌ན། ངེད་ཅག་གིས་སྲིང་མོ་ཁྲིད་ནས་འགྲོ་བར་བྱ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","དེ་ནས་ཧ་མོར་དང་ཁོའི་བུ་སི་ཀེམ་གཉིས་ཀྱིས་གཏམ་དེ་ཐོས་ནས་དགའ་བར་གྱུར་པ་དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","བུ་དེས་དོན་འདི་བསྒྲུབ་པར་འགོར་འགྱངས་ཅི་ཡང་མ་བྱས༌ཏེ། ཁོ་ནི་ཡ་ཀོབ་ཀྱི་བུ་མོ་ལ་ཤིན་ཏུ་དགའ་བའི་ཕྱིར༌རོ། །ཁོ་ཡང་རང་གི་ཕ་ཡི་ཁྱིམ་དུ་ཆེས་བརྩི་བཀུར་ཐོབ་པའི་མི་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","དེ་ནས་ཧ་མོར་དང་ཁོའི་བུ་སི་ཀེམ་གཉིས་གྲོང་ཁྱེར་དེའི་སྒོ་ཁར་སོང་ནས་སྐྱེས་པ་རྣམས་ལ་འདི་ལྟར་སྨྲས༌པ། ");
INSERT INTO bodn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","མི་འདི་རྣམས་ངེད་ཅག་དང་སེམས་མཐུན༌པས། ཁོ་རྣམས་འདི་རུ་སྡོད་པ་དང་ཚོང་ལས་བྱེད་དུ་བཅུག་ནའང་ཡུལ་འདི་ས་རྒྱ་ཆེ་བས་ཁོ་རྣམས་ཤོང༌ཐུབ། ངེད་ཅག་གིས་ཁོ་རྣམས་ཀྱི་བུ་མོ་ཆུང་མར་ལེན་པ༌དང༌། རང་ཅག་གི་བུ་མོ་རྣམས་ཀྱང་ཁོ་རྣམས་ལ་བག་མར་སྟེར་རུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","འོན༌ཀྱང༌། རང་ཅག་གིས་དོན་དག་གཅིག་ཁོ་ན་བསྒྲུབ་དགོས༌ཤིང༌། དེ་ལྟར་བྱས་ན་ཁོ་རྣམས་ད་གཟོད་རང་ཅག་དང་མཉམ་དུ་བསྡད་ནས་མི་རིགས་གཅིག་ཏུ་འགྱུར་བར་འཐད་པ་འབྱུང་བ༌སྟེ། ཁོ་རྣམས་དང་མཚུངས་པར་རང་ཅག་སྐྱེས་པ་ཐམས་ཅད་ཀྱིས་ཀྱང་མཚན་སྐྱི་གཅོད་དགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","དེ་ལྟར་བྱས༌ན། ཁོ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་དང་རྒྱུ་ནོར་ཐམས་ཅད་རང་ཅག་ལ་དབང་བ་མ་ཡིན༌ནམ། དེའི༌ཕྱིར། རང་ཅག་གིས་ཁོ་རྣམས་ལ་བསྟུན་པ་ཡིན་ན། ཁོ་རྣམས་རང་ཅག་དང་མཉམ་དུ་འདུག་པར་བྱེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","དེ་ནས་གྲོང་ཁྱེར་གྱི་མཁར་སྒོ་ལས་ཕར་འགྲོ་ཚུར་འོང་བྱེད་པའི་མི་ཀུན་གྱིས་ཧ་མོར་དང་ཁོའི་བུ་སི་ཀེམ་གཉིས་ཀྱི་གཏམ་ལ་མཉན༌པས། གྲོང་ཁྱེར་གྱི་མཁར་སྒོ་ལས་ཕར་འགྲོ་ཚུར་འོང་བྱེད་པའི་སྐྱེས་པ་ཐམས་ཅད་ཀྱིས་མཚན་སྐྱི་བཅད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","དེ་ནས་ཉིན་གསུམ་པར་སྐྱེས་པ་རྣམས་ལ་ན་ཟུག་ལངས་པའི་སྐབས༌དེར། ཡ་ཀོབ་ཀྱི་བུ་སི་མུ་ཨོན་དང་ལེ་ཝི་ཞེས་བྱ་བ༌སྟེ། དི་ནཱའི་གཅེན་པོ་གཉིས་ཀྱིས་ལག་ཏུ་རལ་གྲི་ཐོགས༌ཏེ། མི་དེ་རྣམས་ཀྱིས་མཉམ་བཞག་མེད་པའི་སྐབས༌སུ། གྲོང་ཁྱེར་དེའི་ནང་དུ་བརྒྱུགས་ནས་སྐྱེས་པ་ཐམས་ཅད་བསད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ཧ་མོར་དང་ཁོའི་བུ་སི་ཀེམ་གཉིས་ཀའང་བསད༌ཅིང༌། སི་ཀེམ་གྱི་ཁྱིམ་ནས་དི་ནཱ་ཁྲིད་དེ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","དེ་ནས་སྲིང་མོ་དི་ནཱ་མི་གཙང་བར་བཟོས་པའི་རྐྱེན༌གྱིས། ཡ་ཀོབ་ཀྱི་བུ་གཞན་རྣམས་བེམ་པོས་བཀང་བའི་གྲོང་ཁྱེར་དེར་ཡོང་ནས་དེ་ཕྲོགས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ར་ལུག་གི་ཁྱུ༌དང༌། བ༌ཁྱུ། བོང༌བུ། གྲོང་ཁྱེར་ནང་དང་ཞིང་བར་དུ་ཡོད་པའི་དངོས་པོ་ཐམས་ཅད་ཁྱེར་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","རྒྱུ་ནོར༌དང༌། བྱིས༌པ། བུད༌མེད། ཁང་པའི་ནང་གི་དངོས་པོ་དང་བཅས་པ་ཕྲོགས་ཏེ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","དེ་ནས་ཡ་ཀོབ་ཀྱིས་བུ་སི་མུ་ཨོན་དང་ལེ་ཝི་གཉིས་ལ་འདི༌ལྟར། ཁྱོད་ཅག་གིས་བདག་སྡུག་ལ་གཏད༌དེ། བདག་ནི་ཡུལ་འདིར་ཡོད་པའི་ཀ་ན་ཨན་མི་རིགས་དང་ཕེ་རེ་ཟི་མི་རིགས་ཀྱི་ཁྲོད་དུ་ངན་པ་རྟགས་ཅན་དུ་བྱས༌སོ། །བདག་གི་མི་གྲངས་ཉུང་བས་དེ་རྣམས་ཀྱིས་མི་ཚོགས་བསྡུས་ནས་བདག་ཅག་ལ་རྒོལ་བར་བྱེད་པ༌དང༌། བདག་དང་བདག་གི་ཁྱིམ་མི་ཐམས་ཅད་རྡུལ་དུ་བརླག་པར་བྱེད་ཅེས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ཁོ་རྣམས་ན༌རེ། སི་ཀེམ་གྱིས་རང་ཅག་གི་སྲིང་མོ་སྨད་འཚོང་མ་བཞིན་དུ་བྱེད་རུང་ངམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","དེ་ནས་དཀོན་མཆོག་གིས་ཡ་ཀོབ་ལ་འདི་སྐད༌དུ། ཡར་ལོངས༌དང༌། པེད་ཨེལ་དུ་སོང་ནས་སྡོད༌ཅིག གནས་དེ་རུ་དཀོན་མཆོག་ལ་མཆོད་ཁྲི་ཞིག་བཞེང་བར་གྱིས། དཀོན་མཆོག་གང་ཞེ༌ན། དེ་སྔར་ཁྱོད་ནི་རང་གི་གཅེན་པོ་ཨེ་སཱབ་ལ་གཞའ་ནས་འབྲོ་བའི་དུས་སུ་ཁྱོད་ལ་མངོན་པ་དེ་ཉིད་ཡིན་ཞེས་གསུངས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ཡ་ཀོབ་ཀྱིས་རང་གི་ཁྱིམ་མི་འཁོར་དང་བཅས་པ་ལ་འདི༌ལྟར། ཁྱོད་ཅག་གིས་ཁྱོད་རྣམས་ཀྱི་ཁྲོད་དུ་ཕྱི་རོལ་པའི་ལྷ་སྐུ་ཡོད་པ་ཐམས་ཅད་དོར༌ཅིག རང་ཉིད་གཙང་མར་བྱས་ནས་གྱོན་གོས་བརྗེ་བར༌གྱིས། ");
INSERT INTO bodn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ངེད་ཅག་ལངས་ནས་ཡར་པེད་ཨེལ་དུ་འགྲོ་བར༌བྱ། བདག་གིས་གནས་དེ་རུ་དཀོན་མཆོག་ལ་མཆོད་ཁྲི་ཞིག་བཞེང་བར་བྱ༌སྟེ། གང་ཡིན་ཟེར༌ན། བདག་ལ་སྡུག་བསྔལ་བྱུང་བའི་དུས༌སུ། བདག་གིས་གསོལ་བ་བཏབ་པར་གསན་པ༌དང༌། ལམ་ལ་ཆས་པའི་སྐབས་སུ་བདག་ལ་སྐྱབས་མཛད་མཁན་དེ་ཉིད་ཡིན་ཞེས་སྨྲས༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ཁྱིམ་མི་འཁོར་དང་བཅས་པས་ཕྱི་རོལ་པའི་ལྷ་སྐུ་དང་རྣ་ཆ་ཐམས་ཅད་བླངས་ནས་ཡ་ཀོབ་ལ་སྤྲད་པ༌དང༌། ཁོས་ཀྱང་དངོས་པོ་དེ་རྣམས་སི་ཀེམ་གྱི་བེ་ཤིང་གི་རྩར་སྦས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","དེ་ནས་ཁོ་རྣམས་ཡར་ལངས་ནས་ལམ་ལ་ཆས༌སྐབས། དཀོན་མཆོག་གིས་ཉེ་འཁོར་གྱི་གྲོང་ཁྱེར་དེ་དག་གི་མི་རྣམས་ལ་འཇིགས་སྣང་བསྐུལ༌བས། མི་དེ་རྣམས་ཡ་ཀོབ་ཀྱི་བུ་རྣམས་ཀྱི་རྗེས་སུ་སྙེག་མ་ནུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","དེའི༌ཕྱིར། ཡ་ཀོབ་འཁོར་དང་བཅས་པ་ཀ་ན་ཨན་ཡུལ་གྱི་ལོ་ཟི་གྲོང་ཁྱེར་ཏེ་པེད་ཨེལ་དུ་སླེབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","དེ་ནས་ཡ་ཀོབ་ཀྱིས་གནས་དེ་རུ་མཆོད་ཁྲི་ཞིག་བཞེངས༌པ་དང་། ཡུལ་དེའི་མིང་ལ་ཨེལ་པེད་ཨེལ་ ཞེས་བཏགས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཡ་ཀོབ་རང་གི་གཅེན་པོ་ལ་གཞའ་ནས་འབྲོ་བའི་དུས༌སུ། དཀོན་མཆོག་གནས་དེ་རུ་ཁོ་ལ་མངོན་པར་མཛད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","དེ་ཡང་རིབ་ཀཱའི་ནུ་ཞོ་མ་ཚབ་སྟེ་དི་བོ་རཱ་ཚེ་ལས་འདས༌ཤིང༌། པེད་ཨེལ་སྨད་ཕྱོགས་ཀྱི་བེ་ཤིང་གི་རྩར་དུར་དུ་སྦས་པ༌དང༌། བེ་ཤིང་དེའི་མིང་ལ་ཨ་ལུན་པཱ་ཀུད་ ཅེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","དེ་ནས་ཡ་ཀོབ་ཁོ་རང་ཕཱ་དན་ཨ་རམ་ཡུལ་ནས་ཐོན་པ༌དང༌། ཡང་དཀོན་མཆོག་གིས་ཁོ་ལ་མངོན་པར་མཛད་ཅིང་བྱིན་རླབས་གནང་སྟེ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ཁྱོད་ཀྱི་མིང་དངོས་ལ་ཡ་ཀོབ་ཅེས་ཟེར༌ཞིང༌། ད་ནས་བཟུང་ཡ་ཀོབ་ཅེས་མི་འབོད་པར་ཡེས་ར་ཨེལ་ཞེས་འབོད་དགོས་ཞེས་གསུངས་པ་དང་ཡ་ཀོབ་ཀྱི་མིང་ལ་ཡེས་ར་ཨེལ་ཞེས༌བཏགས། ");
INSERT INTO bodn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ཡང་དཀོན་མཆོག་གིས་ཡ་ཀོབ་ལ་འདི་སྐད༌དུ། བདག་ནི་ཀུན་དབང་དཀོན་མཆོག༌ཡིན། ཁྱོད་ཀྱིས་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་མང་པོར་སྤེལ་བར༌བྱའོ། །ཁྱོད་ལས་རྒྱལ་ཁབ་ཅིག་དང་མི་རིགས་མང་དུ་འབྱུང༌ཞིང༌། ཁྱོད་རང་བརྒྱུད་ནས་རྒྱལ་པོ་རྣམས་ཀྱང་འབྱུང་བར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","བདག་གིས་ཨབ་ར་ཧམ་དང་ཨི་སཱག་ལ་སྤྲད་པའི་ས་ཆ་དེ་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་དག་ལ་སྦྱིན་པར་བྱ་ཞེས་གསུངས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","དཀོན་མཆོག་ནི་ཡ་ཀོབ་དང་གསུང་མོལ་མཛད་པའི་གནས་དེ་ནས་ནམ་མཁའི་ཞིང་ཁམས་སུ་འཕགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","དེ་ནས་ཡ་ཀོབ་ཀྱིས་གནས་དེ་རུ་རྡོའི་ཀ་བ་ཞིག་གྱེན་དུ་བསྒྲེངས༌ཤིང༌། དེའི་སྟེང་དུ་རྒུན་ཆང་དང་སྣུམ་བླུགས་ནས་མཆོད་པ་ཕུལ་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","གནས་དེའི་མིང་ལ་པེད་ཨེལ་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","དེ་ནས་ཁོ་རྣམས་པེད་ཨེལ་ཡུལ་ནས་ལམ་ལ་ཆས་ཤིང་ཨེབ་རཱད་གྲོང་རྡལ་དང་ཉེ་བའི་ལམ་བར༌དུ། རཱ་ཧེལ་ལ་ཕྲུ་གུ་བཙའ་རན་ཞིང་ཟུག་གཟེར་ཆེན་པོ༌ལངས། ");
INSERT INTO bodn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","དེ་ལྟར་ཟུག་གཟེར་ཆེན་པོ་ལངས་པའི་དུས༌སུ། སྐྱེ་གཡོག་མ་ན༌རེ། ཁྱོད་རང་འཇིགས་མི༌དགོས། ཁྱོད་ལ་ཡང་བུ་ཞིག་སྐྱེས་པ་རེད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","རཱ་ཧེལ་འཆི་ལ་ཉེ་ཞིང་ཁོ་མོའི་ཚེ་འཕོ་བར་རྩོམ་པའི་དུས༌སུ། ཁོ་མོས་རང་གི་བུའི་མིང་ལ་པེན་ཨོ་ནེ་ ཞེས་བཏགས་ནའང་ཡ་ཀོབ་ཀྱིས་རང་གི་བུའི་མིང་ལ་པེན་ཡཱ་མེན་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","དེ་ལྟར་རཱ་ཧེལ་ཚེ་ལས་འདས་ཤིང་ཨེབ་རཱད་ཀྱི་ལམ་འགྲམ་དུ་དུར་ལ་སྦས་པ༌དང༌། ཨེབ་རཱད་ཅེས་པ་པེད་ལེ་ཧེམ་གྲོང་རྡལ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ཡ་ཀོབ་ཀྱིས་ཁོ་མོའི་དུར་སའི་སྟེང་དུ་རྡོ་རིང་ཞིག་བཙུགས་པ༌དང༌། དེ་ནི་རཱ་ཧེལ་གྱི་དུར་རྟགས་ཡིན་ཏེ་ད་ལྟའི་བར་དུ་གནས་ཡོད་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","དེ་ནས་ཡེས་ར་ཨེལ་ལམ་ལ་ཆས་ཤིང་ཨེ་དེར་མཁར་རྫོང་གི་ཕ་རོལ་ཏུ་སླེབས་ནས་གུར་ཕུབ་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ཡེས་ར་ཨེལ་གནས་དེར་སྡོད་པའི་དུས༌སུ། རུ་བེན་ནི་ཕ་ཡི་ཆུན་མ་པིལ་ཧ་ཞེས་པ་དང་ལུས་འབྲེལ་བྱས་ཤིང་དོན་དེ་ཡེས་ར་ཨེལ་གྱིས་ཀྱང་ཐོས༌སོ།། དེ་ཡང་ཡ་ཀོབ་ལ་བུ་བཅུ་གཉིས་ཡོད་པ་གཤམ་གསལ༌ལྟར། ");
INSERT INTO bodn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ལེ་ཨ་ཡིས་བཙས་པའི་བུ་རྣམས་ནི་ཡ་ཀོབ་ཀྱི་བུ་སྐྱེས་འགོ་རུ་བེན༌དང༌། གཞན་ཡང་སི་མུ་ཨོན༌དང༌། ལེ༌ཝི། ཡ་ཧུ༌དཱ། ཡེས་སི༌ཀཱར། ཟེ་བུ་ལུན་བཅས་དྲུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","རཱ་ཧེལ་གྱིས་བཙས་པའི་བུ་ནི་ཡོ་སེབ་དང་པེན་ཡཱ་མེན་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","རཱ་ཧེལ་གྱི་གཡོག་མོ་པིལ་ཧ་ཡིས་བཙས་པའི་བུ་ནི་དཱན་དང་ནཱབ་ཐ་ལི་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ལེ་ཨའི་གཡོག་མོ་ཟིལ་པཱ་ཡིས་བཙས་པའི་བུ་ནི་གཱ་རྡུ་དང་ཨ་ཤེར་གཉིས༌སོ། །བུ་དེ་དག་ནི་ཡ་ཀོབ་ཁོ་རང་ཕཱ་དན་ཨ་རམ་ཡུལ་དུ་ཡོད་པའི་དུས་སུ་སྐྱེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","དེ་ནས་ཡ་ཀོབ་རང་གི་ཕ་ཨི་སཱག་གི་དྲུང་དུ་སླེབས་པ༌དང༌། ཕ་ཡི་ཡུལ་ནི་ཀིར་ཡཱད་ཨར་པཱ་དང་བར་ཐག་ཉེ་བའི་མཱན་རེའེ་ཞེས་པའི་ཡུལ༌ཏེ། ཨབ་ར་ཧམ་དང་ཨི་སཱག་གི་སྡོད་གནས་ཀྱང་ཡིན༌ལ། ཀིར་ཡཱད་ཨར་པཱ་ཞེས་པར་ཧེབ་རོན་ཞེས་ཀྱང་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","དེ་ཡང་ཨི་སཱག་དགུང་ལོ་བརྒྱ་དང་བརྒྱད་ཅུར་བཞུགས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ཨི་སཱག་ལོ་ན་རྒས་ཤིང་ཚེ་ལོ་མཐར་ཕྱིན་ཏེ་ཚེ་ལས་འདས་པ་དང་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཛོམས་པར་གྱུར༌ལ། ཨི་སཱག་གི་བུ་ཨེ་སཱབ་དང་ཡ་ཀོབ་གཉིས་ཀྱིས་ཁོའི་སྐུ་གདུང་དུར་དུ་སྦས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","དེ་ཡང་ཨེ་སཱབ་ཅེས་པ་ཨེ་དོམ་ཡིན༌ཞིང༌། ཁོའི་རིགས་རྒྱུད་ནི་གཤམ་གསལ༌ལྟར། ");
INSERT INTO bodn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ཨེ་སཱབ་ཀྱིས་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུ་མོ་རྣམས་ལས་བུ་མོ་འགའ་ཆུང་མར་བླངས་པ༌སྟེ། ཧེ་བི་མི་རིགས་ཀྱི་ཨེད་ལོན་ཞེས་བྱ་བའི་བུ་མོ་ཨ་དཱ༌དང༌། ཧི་ཝི་མི་རིགས་ཀྱི་ཚིབ་ཨོན་ཞེས་པའི་ཚ་མོ་དང་ཨ་ནཱ་ཞེས་པའི་བུ་མོ་སྟེ་ཨོ་ཧོ་ལི་བཱ་མཱ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ཡེས་མ་ཨེལ་གྱི་བུ་མོ་སྟེ་ནཱ་བ་ཨོད་བྱ་བའི་སྲིང་མོ་པཱ་ས་མཱད་བཅས་གསུམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","དེ་ཡང་ཨ་དཱ་ཡིས་ཨེ་སཱབ་ལ་བུ་ཨེ་ལི་ཕཱ་ཟི་བཙས་ཤིང་། པཱ་ས་མཱད་ཀྱིས་བུ་རུའུ་ཨེལ་བཙས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ཨོ་ཧོ་ལི་བཱ་མཱ་ཡིས་བུ་ཡེ་ཨུ་སི༌དང༌། ཡཱ་ཨེ༌ལཱམ། ཀོ་རཱག་བཅས་གསུམ་བཙས༌སོ། །བུ་དེ་དག་ནི་ཀ་ན་ཨན་ཡུལ་དུ་ཨེ་སཱབ་ལ་ཐོབ་པའི་བུ་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","དེ་ནས་ཨེ་སཱབ་ཀྱིས་རང་གི་ཆུང་མ༌དང༌། བུ་དང་བུ༌མོ། ཁྱིམ་ཚང་ནང་གི་འཁོར་གཡོག་ཐམས་ཅད༌དང༌། ཀ་ན་ཨན་ཡུལ་ནས་ཐོབ་པའི་ཕྱུགས་ཟོག་དང་རྒྱུ་ནོར་ཐམས་ཅད་ཁྱེར༌ཏེ། རང་གི་གཅུང་པོ་ཡ་ཀོབ་དང་ཁ་བྲལ་ནས་ཡུལ་གཞན་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་གཉིས་ལ་རྒྱུ་ནོར་དང་ཕྱུགས་ཟོག་ཤིན་ཏུ་མང་བས་ཡུལ་དེར་མ་ཤོང་བ༌དང༌། ཁོ་གཉིས་མཉམ་དུ་འདུག་ཐབས་མ་བྱུང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","དེའི༌ཕྱིར། ཨེ་སཱབ་ནི་སེ་ཨིར་རི་ཁུལ་དུ་བསྡད༌ཅིང༌། ཨེ་སཱབ་ལ་ཨེ་དོམ་ཞེས་ཀྱང་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ཨེ་སཱབ་ནི་སེ་ཨིར་རི་ཁུལ་གྱི་ཨེ་དོམ་མི་རིགས་ཀྱི་མེས་པོ་ཡིན༌ཞིང༌། ཁོའི་རིགས་རྒྱུད་ནི་འདི་ལྟར་བྲིས་ཡོད༌དེ། ");
INSERT INTO bodn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","དེ་ཡང་ཨེ་སཱབ་ཀྱི་བུ་རྣམས་འདི་ལྟ༌སྟེ། ཨེ་སཱབ་ཀྱི་ཆུང་མ་ཨ་དཱ་ལས་སྐྱེས་པའི་བུ་ནི་ཨེ་ལི་ཕཱ་ཟི༌དང༌། ཨེ་སཱབ་ཀྱི་ཆུང་མ་པཱ་ས་མཱད་ལས་སྐྱེས་པའི་བུ་ནི་རུའུ་ཨེལ་ཞེས་པ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ཨེ་ལི་ཕཱ་ཟི་ཡི་བུ་རྣམས་ནི་ཐེ་མཱན༌དང༌། ཨོ༌མཱར། ཚཱ༌པཱའོ། གཱ༌ཐམ། ཀེ་ནཱ་ཟཱ་བཅས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ཨེ་སཱབ་ཀྱི་བུ་ཨེ་ལི་ཕཱ་ཟིའི་ཆུན་མ་ཐིམ་ནཱ་ཞེས་པ་ལས་བུ་ཨ་མཱད་ལེག་སྐྱེས༌ཤིང༌། དེ་དག་ནི་ཨེ་སཱབ་ཀྱི་ཆུང་མ་ཨ་དཱ་ཡི་ཚ་བོ་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","དེ་ཡང་རུའུ་ཨེལ་གྱི་བུ་རྣམས་ནི་ནཱ་ཧད༌དང༌། ཟེ༌རག ཤམ༌མཱ། མེ་སཱ་ཞེས་བྱ་བ་རྣམས༌སོ། །དེ་དག་ནི་ཨེ་སཱབ་ཀྱི་ཆུང་མ་པཱ་ས་མཱད་ཀྱི་ཚ་བོ་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ཨེ་སཱབ་ཀྱི་ཆུང་མ་ཨོ་ཧོ་ལི་བཱ་མཱ་ནི་ཚིབ་ཨོན་ཞེས་པའི་ཚ་མོ་དང་ཨ་ནཱ་ཞེས་པའི་བུ་མོ་ཡིན༌ལ། ཁོ་མོས་ཨེ་སཱབ་ལ་ཡེ་ཨུ་སི༌དང༌། ཡཱ་ཨེ༌ལཱམ། ཀོ་རཱག་བཅས་བུ་གསུམ་བཙས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","དེ་ཡང་ཨེ་སཱབ་ཀྱི་ཚ་བོ་རྣམས་ལས་ཚོ་དཔོན་དག་ནི་འདི་ལྟར་བྲིས་ཡོད༌དེ། ཨེ་སཱབ་ཀྱི་བུ་སྐྱེས་འགོ་ཨེ་ལི་ཕཱ་ཟི་ཡི་བུ་རྣམས་ལས་ཚོ་དཔོན་དག༌ནི། ཐེ་མཱན༌དང༌། ཨོ༌མཱར། ཚཱ༌པཱའོ། ཀེ་ནཱ༌ཟཱ། ");
INSERT INTO bodn_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ཀོ༌རཱག གཱ༌ཐམ། ཨ་མཱད་ལེག་བཅས༌སོ། །དེ་དག་ནི་ཨེ་དོམ་ཡུལ་དུ་ཨེ་ལི་ཕཱ་ཟི་ནས་མཆེད་པའི་རིགས་རྒྱུད་ཀྱི་ཚོ་དཔོན་རྣམས་ཡིན༌ལ། དེ་དག་ཐམས་ཅད་ཨ་དཱ་ཡི་ཚ་བོ་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","དེ་ཡང་ཨེ་སཱབ་ཀྱི་བུ་རུའུ་ཨེལ་གྱི་བུ་རྣམས་ལས་ཚོ་དཔོན་དག༌ནི། ནཱ་ཧད༌དང༌། ཟེ༌རག ཤམ༌མཱ། མེ་སཱ་བཅས༌སོ། །དེ་དག་ནི་ཨེ་དོམ་ཡུལ་ནས་རུའུ་ཨེལ་ལས་མཆེད་པའི་ཚོ་དཔོན་དག་ཡིན༌ལ། དེ་དག་ཐམས་ཅད་ཨེ་སཱབ་ཀྱི་ཆུང་མ་པཱ་ས་མཱད་ཀྱི་ཚ་བོ་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","དེ་ཡང་ཨེ་སཱབ་ཀྱི་ཆུང་མ་ཨོ་ཧོ་ལི་བཱ་མཱ་ཡི་བུ་རྣམས་ལས་ཚོ་དཔོན་དག་ནི་ཡེ་ཨུ་སི༌དང༌། ཡཱ་ཨེ༌ལཱམ། ཀོ་རཱག་བཅས༌སོ། །དེ་དག་ནི་ཨེ་སཱབ་ཀྱི་ཆུང་མ་དང་ཨ་ནཱ་ཡི་བུ་མོ་སྟེ་ཨོ་ཧོ་ལི་བཱ་མཱ་ལས་མཆེད་པའི་ཚོ་དཔོན་དག་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","གོང་དུ་བརྗོད་པའི་ཚོ་དཔོན་དེ་དག་ནི་ཨེ་སཱབ་ཀྱི་བུ་རབས་ཚ་རྒྱུད་རྣམས་ཡིན༌ཞིང༌། ཨེ་སཱབ་ལ་ཨེ་དོམ་ཞེས་ཀྱང༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","དེ་ཡང་སྔ་མོ་ནས་ཡུལ་དེར་ཡོད་པའི་ཧོར་མི་རིགས་ཀྱི་སེ་ཨིར་ཞེས་བྱ་བའི་བུ་རྣམས་ནི་འདི་ལྟར་བྲིས་ཡོད༌དེ། ལོད་ཐན༌དང༌། ཤོ༌བཱལ། ཚིབ༌ཨོན། ཨ༌ནཱ། ");
INSERT INTO bodn_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","དི༌ཤོན། ཨེ༌བཟིར། དི་ཞན་བཅས༌སོ། །དེ་དག་ནི་ཨེ་དོམ་ཡུལ་གྱི་སེ་ཨིར་གྱི་བུ་རྣམས་ཏེ་ཧོར་མི་རིགས་ཀྱི་ཚོ་དཔོན་རྣམས་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ལོད་ཐན་གྱི་བུ་ནི་ཧོ་རི་དང་ཧེ་མཱམ་ཞེས་པ་གཉིས་ཡིན༌ཞིང༌། ལོད་ཐན་གྱི་སྲིང་མོ་ནི་ཐིམ་ནཱ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ཤོ་བཱལ་གྱི་བུ་ནི་ཨལ་ཝན༌དང༌། མཱ་ན༌ཧད། ཨེ༌བཱལ། ཤེ༌པོ། ཨོ་ནཱམ་བཅས༌ལྔའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ཚིབ་ཨོན་གྱི་བུ་ནི་ཨ་ཡཱ་དང་ཨ་ནཱ་གཉིས༌སོ། །ཨ་ནཱ་ཞེས་པ་ནི་དེ་སྔར་དབེན་སྟོང་ཡུལ་ནས་ཡབ་ཀྱི་བོང་བུ་འཚོ་བའི་དུས་སུ་ཆུ་ཁོལ་གྱི་ཆུ་མིག་རྙེད་མཁན་དེ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ཨ་ནཱ་ཡི་བུ་ནི་དི་ཤོན་ཞེས་པ༌དང༌། ཨ་ནཱའི་བུ་མོ་ནི་ཨོ་ཧོ་ལི་བཱ་མཱ་ཞེས་བྱ༌བའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","དི་ཤོན་གྱི་བུ་ནི་ཧེམ་དཱན༌དང༌། ཨེས༌པཱན། ཡེད༌རཱན། ཀཱ་རཱན་བཅས༌བཞིའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ཨེ་བཟིར་གྱི་བུ་ནི་པིལ་ཧན༌དང༌། ཟ་ཨ༌ཝན། ཨ་ཀན་གསུམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","དི་ཞན་གྱི་བུ་ནི་ཨུ་ཟཱ་དང་ཨ་རན་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","དེ་ཡང་ཧོར་མི་རིགས་ཀྱི་ཚོ་དཔོན་རྣམས་ནི་འདི་ལྟར་བྲིས་ཡོད༌དེ། ཚོ་དཔོན་ལོད་ཐན༌དང༌། ཤོ༌བཱལ། ཚིབ༌ཨོན། ཨ༌ནཱ། ");
INSERT INTO bodn_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","དི༌ཤོན། ཨེ༌བཟིར། དི་ཞན་བཅས༌སོ། །དེ་དག་ནི་ཧོར་མི་རིགས་ལས་བྱུང་བའི་ཚོ་དཔོན་རྣམས་ཡིན༌ལ། ཁོ་རྣམས་ནི་སེ་ཨིར་ཡུལ་དུ་ཡོད་ཅིང་རང་རང་གི་ཚོ་པའི་ཚོ་དཔོན་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","དེ་ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་རྒྱལ་པོ་གང་གིས་ཀྱང་སྲིད་མ་བསྐྱངས་པའི་སྔོན་དུ་ཨེ་དོམ་ཡུལ་གྱི་རྒྱལ་པོ་རྣམས་ནི་འདི་ལྟར་བྲིས་ཡོད༌དེ། ");
INSERT INTO bodn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ཨེ་དོམ་ཡུལ་གྱི་རྒྱལ་པོ་ནི་པཱ་ཨོར་གྱི་བུ་པེ་ལཱ་ཡིན༌ཞིང༌། ཁོའི་གྲོང་ཁྱེར་གྱི་མིང་ལ་དིན་ཧ་བཱ་ཞེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","དེ་ནས་པེ་ལཱ་ཚེ་ལས་འདས༌རྗེས། པོ་ཚ་རཱ་གྲོང་ཁྱེར་གྱི་ཟེ་རག་ཅེས་བྱ་བའི་བུ༌སྟེ། ཡོ་བཱབ་ནི་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","དེ་ནས་ཡོ་བཱབ་ཚེ་ལས་འདས༌རྗེས། ཐེ་མཱན་ཡུལ་གྱི་ཧུ་སཱམ་ནི་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","དེ་ནས་ཧུ་སཱམ་ཚེ་ལས་འདས༌རྗེས། པཱ་དད་ཀྱི་བུ་ཧ་དཱད་ཅེས་པ་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ། །ཧ་དཱད་ནི་མོ་ཨབ་ཀྱི་ཐང་དུ་མིད་ཡཱན་མི་རིགས་འཇོམས་མཁན་དེ་ཡིན༌ལ། ཁོའི་རྒྱལ་སའི་མིང་ལ་ཨ་ཝིད་ཅེས་ཟེར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","དེ་ནས་ཧ་དཱད་ཚེ་ལས་འདས༌རྗེས། མཱས་རེ་ཁཱ་ཡུལ་གྱི་སམ་ལཱ་ཞེས་བྱ་བ་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","དེ་ནས་སམ་ལཱ་ཚེ་ལས་འདས༌རྗེས། གཙང་པོའི་ཕར་འགྲམ་གྱི་རེའེ་ཧོ་པེད་ཡུལ་གྱི་སོ་ལོ་ནི་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","དེ་ནས་སོ་ལོ་ཚེ་ལས་འདས༌རྗེས། ཨག་པོར་གྱི་བུ་པཱ་ཨལ་ཧ་ནན་ཞེས་པ་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","དེ་ནས་ཨག་པོར་གྱི་བུ་པཱ་ཨལ་ཧ་ནན་ཚེ་ལས་འདས༌རྗེས། ཧ་དཱར་ནི་དེའི་རྒྱུན་མཐུད་ནས་རྒྱལ་པོར་བཞུགས་སོ། །ཁོའི་རྒྱལ་སའི་མིང་ལ་ཕཱ་ཨུའུ་ཞེས་ཟེར་བ༌དང༌། ཁོའི་ཆུང་མའི་མིང་ལ་མཱ་ཧེ་ཐབ་ཨེལ་ཞེས་ཟེར༌ཞིང༌། ཁོ་མོ་ནི་མཱད་རཱད་ཅེས་པའི་བུ་མོ་དང་མེ་སཱ་ཧབ་ཅེས་པའི་ཚ་མོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","དེ་ཡང་ཨེ་སཱབ་ནས་བྱུང་བའི་ཚོ་དཔོན་རྣམས་ནི་རང་རང་གི་རིགས་རྒྱུད༌དང༌། སྡོད༌ཡུལ། རུས་མིང་ལྟར་བྲིས་ཡོད༌དེ། ཐིམ་ནཱ༌དང༌། ཨལ༌ཝཱ། ཡཱ༌ཐེད། ");
INSERT INTO bodn_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ཨོ་ཧོ་ལི་བཱ༌མཱ། ཨེ༌ལཱ། ཕི༌ནོན། ");
INSERT INTO bodn_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ཀེ་ནཱ༌ཟཱ། ཐེ༌མཱན། མིབ༌ཚཱར། ");
INSERT INTO bodn_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","མག་དི༌ཨེལ། ཨི་རཱམ་བཅས༌སོ། །དེ་དག་ནི་ཨེ་དོམ་མི་རིགས་ཀྱིས་དབང་བསྒྱུར་བའི་ཡུལ་དང་ཁོ་ཚོའི་སྡོད་གནས་ཀྱི་ཚོ་དཔོན་རྣམས་ཡིན༌ལ། ཐམས་ཅད་ཨེ་དོམ་མི་རིགས་ཀྱི་མེས་པོ་ཨེ་སཱབ་ཀྱི་རིགས་རྒྱུད་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","དེ་ཡང་ཡ་ཀོབ་ནི་ཀ་ན་ཨན་ཡུལ་དུ་སྡོད་ཅིང་ཡུལ་དེ་ཁོའི་ཕ་བསྡད་མྱོང་བའི་ཡུལ་ཡང་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ཡ་ཀོབ་ཀྱི་མཛད་རྗེས་ནི་འདི་ལྟ༌སྟེ། ཡོ་སེབ་ཀྱིས་ལོ་བཅུ་བདུན་སྟེང་རང་གི་གཅེན་པོ་རྣམས་དང་མཉམ་དུ་ར་ལུག་འཚོས༌ཤིང༌། ཁོ་གཞོན་ནུ་ཞིག་ཡིན༌ལ། རྒྱུན་དུ་ཁོའི་ཕ་ཡི་ཆུན་མ་པིལ་ཧ་དང་ཟིལ་པཱ་ཡི་བུ་རྣམས་དང་མཉམ་དུ༌བསྡད། ཡོ་སེབ་ཀྱིས་གཅེན་པོ་རྣམས་ཀྱི་སྤྱོད་ངན་མཐའ་དག་ཕ་ལ་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ཡེས་ར་ཨེལ་གྱིས་བུ་གཞན་རྣམས་ལས་ཡོ་སེབ་ལ་ཤིན་ཏུ་གཅེས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཡོ་སེབ་ནི་ཁོ་རང་ལོ་ན་རྒས་པའི་དུས་སུ་སྐྱེས་པའི་བུ་ཡིན་པའི་ཕྱིར༌རོ། །ཁོས་ཡོ་སེབ་ལ་ཕྱི་གོས་ཁྲ་བོ་ཞིག་ཀྱང༌བཟོས། ");
INSERT INTO bodn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","དེ་ནས་ཡོ་སེབ་ཀྱི་གཅེན་པོ་རྣམས་ཀྱིས་ཕ་ཡིས་ཁོ་རྣམས་ལས་ཡོ་སེབ་ལ་ཤིན་ཏུ་གཅེས་པ་མཐོང༌སྟེ། ཡོ་སེབ་ལ་སྡང་ཞིང་ཡིད་སེམས་མཐུན་པའི་གཏམ་མི༌སྨྲའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","དེ་ཡང་ཡོ་སེབ་ཀྱིས་རྨི་ལམ་ཞིག་རྨིས་ཏེ་གཅེན་པོ་རྣམས་ལ་སྨྲས་པ་དང་ཁོ་རྣམས་ཡོ་སེབ་ལ་ལྷག་ཏུ་སྡང་བར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ཡོ་སེབ་ཀྱིས་གཅེན་པོ་རྣམས་ལ་འདི༌ལྟར། ཁྱོད་ཅག་གིས་བདག་གི་རྨི་ལམ་ལ་གསན་པར༌ཞུ། ");
INSERT INTO bodn_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ལྟོས༌དང༌། རང་ཅག་གིས་ཞིང་ནང་དུ་ཚར་ཕོན་སྡོམ་པའི་སྐབས༌སུ། བདག་གིས་བསྡམས་པའི་ཚར་ཕོན་ནི་གྱེན་དུ་བསྒྲེངས༌ཤིང༌། ཁྱོད་ཅག་གིས་བསྡམས་པའི་ཚར་ཕོན་དག་གིས་བདག་གི་ཚར་ཕོན་གྱི་མཐའ་བསྐོར་ནས་ཕྱག་བཙལ་བ་ཡིན་ཞེས་སྨྲས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","དེ་ནས་ཁོའི་གཅེན་པོ་རྣམས་ན༌རེ། ཁྱོད་ནི་དངོས་གནས་ངེད་ཅག་གི་རྒྱལ་པོར་བྱེད༌དམ། ཁྱོད་ཀྱིས་དངོས་གནས་ངེད་ཅག་ལ་དབང་བསྒྱུར་རམ་ཞེས་སྨྲས་པ༌དང༌། ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་ཀྱི་རྨི་ལམ་དང་ཁོས་སྨྲས་པའི་སྐད་ཆ་ཐོས་པ་དང་ཁོ་ལ་ལྷག་ཏུ་སྡང་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ཕྱིས་སུ་ཡོ་སེབ་ཀྱིས་ཡང་རྨི་ལམ་གཞན་ཞིག་རྨིས་ཤིང་ཁོའི་གཅེན་པོ་རྣམས་ལ་འདི༌ལྟར། ལྟོས༌དང༌། ཡང་བདག་གིས་རྨི་ལམ་ཞིག་རྨིས༌ཏེ། རྨི་ལམ་ནང་དུ་ཉི་མ༌དང༌། ཟླ༌བ། སྐར་མ་བཅུ་གཅིག་བཅས་ཀྱིས་བདག་ལ་ཕྱག་བཙལ་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","དེ་ནས་ཡོ་སེབ་ཀྱིས་ཐེངས་འདིའི་རྨི་ལམ་དེ་རང་གི་ཕ་ལའང་སྨྲས་པ༌ན། ཕ་ན༌རེ། ཁྱོད་ཀྱི་རྨི་ལམ་དེ་ཅི་ཡིན༌ནམ། བདག༌དང༌། ཁྱོད་ཀྱི་མ༌ཡུམ། ཁྱོད་ཀྱི་གཅེན་པོ་རྣམས་དངོས་གནས་ཁྱོད་ཀྱི་མདུན་དུ་ཡོང་སྟེ་ཁྱོད་ལ་ཕྱག་འཚལ་ལམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","དེ་ནས་ཁོའི་གཅེན་པོ་རྣམས་ཀྱིས་ཁོ་ལ་ཕྲག་དོག་བྱས་ནའང་ཕ་ཡིས་བུའི་གཏམ་དེ་སེམས་སུ་བཟུང་བ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","དེ་ཡང་ཡོ་སེབ་ཀྱི་གཅེན་པོ་རྣམས་ནི་ཁོ་རྣམས་ཀྱི་ཕ་ཡི་ར་ལུག་འཚོ་བར་སི་ཀེམ་ཡུལ་དུ་སོང་ཡོད༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། ཁྱོད་ཀྱི་གཅེན་པོ་རྣམས་ཀྱིས་སི་ཀེམ་ཡུལ་དུ་ར་ལུག་འཚོ་བ་མ་ཡིན༌ནམ། ཁྱོད་འདིར་ཤོག༌དང༌། བདག་གིས་ཁྱོད་རང་ཁོ་རྣམས་ཀྱི་གནས་དེར་མངག་པར་བྱ་ཞེས་སྨྲས་པ༌ན། ཡོ་སེབ་ཀྱིས་ལགས་སོ་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ཡང་ཡེས་ར་ཨེལ་ན༌རེ། ཁྱོད་རང་གི་གཅེན་པོ་རྣམས་བདེའམ་མི་བདེ༌དང༌། ར་ཁྱུ་དང་ལུག་ཁྱུ་བདེའམ་མི་བདེ་ལ་བལྟ་རུ་སོང༌སྟེ། ཕྱིར་ཡོང་ནས་བདག་ལ་སྨྲོས་ཤིག་ཅེས་སྨྲས་པ་དང་ཧེབ་རོན་ལུང་པ་ནས་མངགས༌ཤིང༌། ཁོ་རང་ལམ་ལ་ཆས་ཏེ་སི་ཀེམ་ཡུལ་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","དེ་ནས་མི་གཞན་གྱིས་ཁོ་རང་སྤང་ཐང་དུ་མགོ་འཁོར་ནས་ལམ་ནོར་བ་མཐོང༌སྟེ། ཁྱོད་ཀྱིས་ཅི་ཞིག་འཚོལ་བཞིན་ཡོད་ཅེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ཁོ་ན༌རེ། ངས་རང་གི་གཅེན་པོ་རྣམས་འཚོལ་བཞིན༌ཡོད། ཁོ་རྣམས་ཀྱིས་གནས་གང་དུ་ར་ལུག་འཚོ་བཞིན་པ་བདག་ལ་སྨྲ་བར་མཛོད་ཅེས་ཞུས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","མི་དེ་ན༌རེ། ཁོ་རྣམས་ཀྱིས་མཚེར་ས་སྤར༌ཟིན། བདག་གིས་ཐོས་པ་ལྟར༌ན་ཁོ་རྣམས་དོའུ་ཐཱན་ཡུལ་དུ་འགྲོ་བར་སྨྲ་ཞེས༌སྨྲས། དེ་ནས་ཡོ་སེབ་ཀྱིས་རང་གི་གཅེན་པོ་རྣམས་ཀྱི་རྗེས་བསྙེགས༌ཏེ། ཁོ་རྣམས་དོའུ་ཐཱན་དུ་ཡོད་པ་མཐོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ཡོ་སེབ་ཀྱི་གཅེན་པོ་རྣམས་ཀྱིས་རྒྱང་རིང་ནས་ཁོ་རང་མཐོང་བ་དང་ཉེ་བར་མ་སླེབས་པའི་སྐབས་དང་བསྟུན་ནས་ཁོ་རང་གསོད་པར་གྲོས་བྱས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ཕན་ཚུན་ལ་འདི༌ལྟར། ལྟོས༌དང༌། རྨི་ལམ་རྨི་མཁན་དེ་ཡོང་བཞིན༌འདུག ");
INSERT INTO bodn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ཤོག༌དང༌། རང་ཅག་གིས་ཁོ་རང་བསད་ནས་ས་དོང་ཞིག་གི་ནང་དུ་འཕེན་པར༌བྱ། ཁོ་རང་གཅན་གཟན་གྱིས་ཟོས་སོང་ཞེས་སྨྲ་བར༌བྱ། དེས་ན་ཁོའི་རྨི་ལམ་མ་འོངས་པར་ཅི་འདྲ་ཞིག་ཡིན་པར་བལྟ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","དེ་ནས་རུ་བེན་གྱིས་གཏམ་དེ་དག་ཐོས་པ་དང་ཁོ་རྣམས་ལས་ཡོ་སེབ་སྐྱོབ་འདོད་དེ་འདི༌ལྟར། རང་ཅག་གིས་ཁོ་རང་གསོད་མི་རུང་ཞེས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ཡང་ན༌རེ། ཁོ་རང་གསོད་མི༌རུང༌། གནོད་འཚེ་ཅི་ཡང་མི་བྱེད་པར་དབེན་སྟོང་དུ་ཡོད་པའི་ས་དོང་འདིའི་ནང་དུ་འཕེན་པར་བྱ་ཞེས་སྨྲས༌སོ། །རུ་བེན་གྱིས་དེ་ལྟར་སྨྲས་པ་ནི་ཡོ་སེབ་ཁོ་རྣམས་ལས་བསྐྱབས་ཏེ་ཁོའི་ཕ་ལ་སྤྲོད་འདོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","དེ་ནས་ཡོ་སེབ་རང་གི་གཅེན་པོ་རྣམས་ཀྱི་གམ་དུ་སླེབས་པ་དང༌། ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་ཀྱི་ལུས་ལ་གྱོན་ཡོད་པའི་ཕྱི་གོས་ཁྲ་བོ་དེ་ཕུད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ཁོ་རང་ས་དོང་ནང་དུ༌འཕངས། ས་དོང་དེའི་ནང་དུ་ཆུ་མེད་པར་སྟོང་བ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","དེ་ནས་ཁོའི་གཅེན་པོ་རྣམས་ས་ལ་བསྡད་ནས་ཁ་ཟས་སྤྱད་ཅིང་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། ཡེས་མ་ཨེལ་མི་རིགས་ཀྱི་ཚོང་པ་སྐོར་ཞིག་གིལ་ཨད་ཡུལ་ནས་ཡོང་བཞིན་ཡོད་པ༌དང༌། ཁོ་རྣམས་ཀྱིས་བསུང་རྫས༌དང༌། སྤོས་དཀར། གུ་གུལ་བཅས་རྔ་མོང་དག་ལ་བཀལ་ནས་མར་ཨེ་ཅིབ་ཡུལ་དུ་འགྲོ་བཞིན་པ་མཐོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","དེ་ནས་ཡ་ཧུ་དཱ་ཡིས་སྤུན་གཞན་རྣམས་ལ་འདི༌ལྟར། རང་ཅག་གིས་སྤུན་ཆུང་བསད་ནས་དོན་དེ་གསང་ན་ཅི་ལ༌ཕན། ");
INSERT INTO bodn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","དེའི༌ཕྱིར། རང་ཅག་གིས་ཁོ་རང་ཡེས་མ་ཨེལ་མི་རིགས་ལ་བཙོངས་ན་ལེགས༌སོ། །ཁོ་རང་གསོད་མི་འོས༌ཏེ། ཁོ་ནི་རང་ཅག་དང་ཤ་ཁྲག་གཅིག་ལས་མཆེད་པའི་སྤུན་ཡིན༌པའི་ཕྱིར་རོ་ཞེས་སྨྲས་པ་དང་སྤུན་གཞན་རྣམས་ཀྱིས་ཀྱང་ཁོའི་གཏམ་ལ༌མཉན་ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","དེ་ནས་ཡེས་མ་ཨེལ་ཞེས་བྱ་བ་སྟེ་མིད་ཡཱན་མི་རིགས་ཀྱི་ཚོང་པ་འགའ་ཤས་ཡུལ་དེ་བརྒྱུད་ནས་འགྲོ་བའི་ཚེ༌ན། ཡོ་སེབ་ཀྱི་གཅེན་པོ་རྣམས་ཀྱིས་ཁོ་རང་ས་དོང་ལས་བླངས༌ཏེ། དངུལ་སྲང་ཉི་ཤུར་ཐག་བཅད་པ་ལྟར་ཁོ་རང་ཡེས་མ་ཨེལ་མི་རིགས་ཀྱི་ཚོང་པ་རྣམས་ལ་བཙོངས་པ༌དང༌། དེ་རྣམས་ཀྱིས་ཁོ་རང་ཨེ་ཅིབ་ཡུལ་དུ་ཁྲིད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","དེ་ནས་རུ་བེན་ས་དོང་གི་གམ་དུ་ཡོང་བ་དང་ཡོ་སེབ་མེད་པ་མཐོང་ནས་ཡིད་ཤིན་ཏུ་སྐྱོ་སྟེ་རང་གི་གྱོན་གོས་ཀྱང་བཤགས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","སྤུན་རྣམས་ཀྱི་གམ་དུ་སོང༌སྟེ། སྤུན་ཡོ་སེབ་མི༌མཐོང༌། ད་ནི་ང་རང་གང་དུ་འགྲོའམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","དེ་ནས་གཅེན་པོ་རྣམས་ཀྱིས་ར་ཕོ་ཞིག་བཤས་ཤིང་ཡོ་སེབ་ཀྱི་ཕྱི་གོས་དེ་ཁྲག་གི་ནང་དུ་སྦངས༌རྗེས། ");
INSERT INTO bodn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","མི་ཞིག་གྱོན་གོས་དེ་ཁོ་རྣམས་ཀྱི་ཕ་ཡི་དྲུང་དུ་བསྐྱལ་བར་མངགས༌ཤིང༌། ཕ་ལ་འདི་ལྟར་བརྗོད་པ་སྟེ། ངེད་ཅག་གིས་གྱོན་གོས་འདི་རྙེད་པ༌ཡིན། དེ་ནི་ཁྱེད་ཀྱི་བུ་ཡོ་སེབ་ཀྱི་གྱོན་གོས་ཡིན་མིན་ལ་བལྟ་བར་མཛོད་ཅེས་སྨྲས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","དེ་ནས་ཕ་ཡིས་བུའི་གྱོན་གོས་ཡིན་པ་ཤེས་ཏེ་འདི་སྐད༌དུ། འདི་ནི་བདག་གི་བུ་ཡོ་སེབ་ཀྱི་ཕྱི་གོས་ཡིན༌འདུག ཁོ་ནི་ད་ལྟ་གཅན་གཟན་གྱིས་ཟོས༌སོང༌། བུ་ཡོ་སེབ་དུམ་བུ་དུམ་བུར་བྱས་པ་ཤ་སྟག་རེད་ཅེས་སྨྲས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ཡ་ཀོབ་ཀྱིས་རང་གི་གྱོན་གོས་བཤགས་པ༌དང༌། ལུས་སྨད་དུ་རྩིད་རས་གྱོན༌ཏེ་བུ་ཡི་ཆེད་དུ་ཉིན་དུ་མར་མྱ་ངན༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","དེ་ནས་ཡ་ཀོབ་ཀྱི་བུ་བུ་མོ་ཐམས་ཅད་ཡོང་ནས་ཁོང་ལ་སེམས་གསོ་བྱས༌ནའང༌། ཁོང་གིས་དེ་དག་གི་སེམས་གསོའི་གཏམ་ལ་མི་ཉན་པར་མ་ཟད་འདི་སྐད༌དུ། བདག་ནི་མྱ་ངན་གྱི་ངང་ནས་གཤིན་པོའི་གནས་ཀྱི་བུ་ཡོ་སེབ་གམ་དུ་འགྲོ་ངེས་ཡིན་ཞེས་སྨྲས་པ་དང་བུ་ཡི་རྐྱེན་གྱིས་ཡིད་སྐྱོ་བའི་ངང་ནས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","དེ་ཡང་མིད་ཡཱན་པ་དེ་རྣམས་ཀྱིས་ཡོ་སེབ་ཅེས་བྱ་བ་ཨེ་ཅིབ་ཡུལ་དུ་ཁྲིད༌ཅིང༌། ཡང་ཁོ་རང་རྒྱལ་པོ་ཕཱར་ཨོལ་གྱི་ནང་བློན༌ཏེ། རྒྱལ་པོའི་སྐུ་སྲུང་དམག་དཔོན་ཕའོ་ཏི་ཕར་ལ་བཙོངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","སྐབས༌དེར། ཡ་ཧུ་དཱ་རང་གི་སྤུན་ཟླ་རྣམས་དང་ཁ་བྲལ་ནས་ཨ་དུལ་ལཱམ་མི་རིགས་ཀྱི་ཧི་རཱ་ཞེས་པའི་ཁྱིམ་དུ་སོང༌ཞིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ཡ་ཧུ་དཱ་ཡིས་ཁྱིམ་དེ་ནས་ཀ་ན་ཨན་མི་རིགས་ཀྱི་ཤུ་ཨ་ཞེས་པ་དེའི་བུ་མོ་མཐོང་ནས་རང་གི་ཆུང་མར་བླངས་ཤིང་ལུས་འབྲེལ་བྱས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ཁོ་མོར་མངལ་ཆགས་ཏེ་བུ་ཞིག་སྐྱེས་པ་ལ་ཡ་ཧུ་དཱ་ཡིས་བུའི་མིང་ལ་ཨེར་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","དེ་ནས་ཡང་ཁོ་མོར་མངལ་སྦྲུམ་ནས་བུ་ཞིག་སྐྱེས་པ་ལ་མ་ཡིས་བུའི་མིང་ལ་ཨོ་ནན་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","དེ་ནས་ཡང་ཁོ་མོར་མངལ་ཆགས་ཏེ་བུ་ཞིག་སྐྱེས་པ་ལ་ཤེ་ལཱ་ཞེས་བཏགས་པ༌དང༌། ཁོ་མོས་བུ་ཤེ་ལཱ་བཙའ་བའི་དུས་སུ་ཡ་ཧུ་དཱ་ནི་ཀཱ་ཟིབ་གྲོང་རྡལ་དུ་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","དེ་ནས་ཡ་ཧུ་དཱ་ཡིས་བུ་སྐྱེས་འགོ་ཨེར་ལ་ཆུང་མ་ཞིག་བླངས་ཤིང་ཁོ་མོའི་མིང་ལ་ཐལ་མཱར་ཞེས༌ཟེར། ");
INSERT INTO bodn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","འོན༌ཀྱང༌། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་ལམ་དུ་ཡ་ཧུ་དཱའི་བུ་སྐྱེས་འགོ་ཨེར་ནི་མི་ཐ་ཤལ་ཅན་དུ་མཐོང༌བས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་འཆི་བར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","དེ་ནས་ཡ་ཧུ་དཱ་ཡིས་བུ་འབྲིང་བ་ཨོ་ནན་ལ་འདི༌ལྟར། ཁྱོད་ནི་རང་གི་གཅེན་པོའི་ཆུང་མར་འགྲོགས་པ༌དང༌། གཅུང་པོའི་འགན་ཁུར་དང་དུ་བླངས་ཏེ་གཅེན་པོའི་ཆེད་དུ་ཁོ་མོར་བུ་ཞིག་སྐྱེས་པར་གྱིས་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","འོན་ཀྱང་ཨོ་ནན་གྱིས་ཁོ་མོར་བུ་སྐྱེས་ནའང་རང་ལ་མི་དབང་བ་ཤེས༌ཏེ། གཅེན་པོར་རིགས་རྒྱུད་མི་འབྱུང་བའི་ཆེད་དུ་ལུས་འབྲེལ་བྱེད་པའི་དུས་སུ་རང་གི་ཁམས་དཀར་ས་རུ་གཏོར་བ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་ལམ་དུ་ཨོ་ནན་གྱི་ལས་དེ་ནི་ལས་ངན་པར་གཟིགས༌པས། ཁོང་གིས་ཨོ་ནན་ཡང་འཆི་བར་མཛད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","དེ་ནས་ཡ་ཧུ་དཱ་ཡི་སེམས་སུ་བུ་ཆུང་བ་ཤེ་ལཱའང་ཁོའི་གཅེན་པོ་གཉིས་ལྟར་འཆིའོ་སྙམ༌སྟེ། མནའ་མ་ཐལ་མཱར་ལ་འདི༌ལྟར། བདག་གི་བུ་ཤེ་ལཱ་ནར་སོན་པའི་བར༌དུ། ཁྱོད་རང་གི་ཕ་གཞིས་སུ་སོང་ནས་ཡུགས་མོར་སྡོད་ཅིག་ཅེས་སྨྲས་པ༌དང༌། ཁོ་མོ་ཕ་གཞིས་སུ་སོང་ནས༌བསྡད་དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","དེ་ནས་དུས་ཡུན་རིང་པོ་འགོར་བའི་རྗེས༌སུ། ཡ་ཧུ་དཱའི་ཆུང་མ་ཤུ་ཨ་ཡི་བུ་མོ༌ཤིའོ། །དེ་ནས་ཡ་ཧུ་དཱ་མྱ་ངན་ལས་སངས་ཏེ་ཁོའི་གྲོགས་པོ་ཨ་དུལ་ལཱམ་མི་རིགས་ཀྱི་ཧི་རཱ་ཞེས་པ་དང་མཉམ་དུ་ཐིམ་ནཱ་ཡུལ་གྱི་རང་གི་ལུག་བལ་འབྲེག་མཁན་རྣམས་ཀྱི་གམ་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","དེར་མི་ཞིག་གིས་ཐལ་མཱར་ལ་འདི༌ལྟར། ཁྱོད་ཀྱི་སྒྱུག་པོ་ཐིམ་ནཱ་རུ་རང་གི་ལུག་བལ་འབྲེག་ཏུ་སོང་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ཐལ་མཱར་གྱིས་ཤེ་ལཱ་ནར་སོན་ཡོད་པ་མཐོང་ཞིང་ཁོས་ད་དུང་རང་ཉིད་ཆུང་མར་མ་བླངས༌པས། ཡུགས་མོའི་གྱོན་གོས་ཕུད་དེ་གདོང་ཁེབས་ཀྱིས་ངོ་བཀབ་པ་དང་ལུས་པོའང་བཀབ༌རྗེས། ཐིམ་ནཱ་རུ་འགྲོ་བའི་ལམ་དུ་ཨེ་ནཱ་ཡིམ་གྱི་མཁར་སྒོའི་འགྲམ་དུ་ཙོག་པུར༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ཡ་ཧུ་དཱ་ཡིས་ཁོ་མོ་མཐོང་སྟེ་སྨད་འཚོང་མ་ཞིག་ཡིན་པར་སྙམ་པ༌སྟེ། ཁོ་མོས་གདོང་ཁེབས་ཀྱིས་ངོ་བཀབ་ཡོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","དེ་ནས་ཡ་ཧུ་དཱ་ཕྱིར་འཁོར་ནས་ཁོ་མོའི་མདུན་དུ་ཡོང་སྟེ་ན༌རེ། ཤོག༌དང༌། ང་རང་ཁྱོད་དང་འགྲོགས་པར་བྱ་ཞེས་སྨྲས༌སོ། །རྒྱུ་མཚན་ནི་ཡ་ཧུ་དཱས་ཁོ་མོ་རང་གི་མནའ་མ་ཡིན་པ་མ་ཤེས་པའི་ཕྱིར༌རོ། །ཐལ་མཱར་ན༌རེ། ཁྱོད་བདག་དང་འགྲོགས་འདོད༌ན། ཁྱོད་ཀྱིས་བདག་ལ་ཅི་ཞིག་སྟེར་རམ་ཞེས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ཡ་ཧུ་དཱ་ན༌རེ། བདག་གིས་མི་ཞིག་མངགས་ནས་རང་གི་ར་ཁྱུ་ལས་རེའུ་ཞིག་འཁྱེར་ཡོང་སྟེ་ཁྱོད་ལ་སྟེར་ཞེས༌སྨྲས། ཡང་ཐལ་མཱར་ན༌རེ། ཁྱོད་ཀྱིས་རེའུ་མ་བསྐྱལ་བའི་སྔོན༌ལ། བདག་ལ་གཏའ་མ་ཅི་ཞིག་འཇོག་གམ་ཞེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ཡང་ཡ་ཧུ་དཱ་ན༌རེ། བདག་གིས་ཁྱོད་ལ་གཏའ་མ་ཅི་ཞིག་འཇོག་གམ་ཞེས་སྨྲས༌ཤིང༌། ཡང་ཐལ་མཱར་ན༌རེ། ཁྱོད་ཀྱི་ཐམ་ག༌དང༌། ཐམ་གའི་རྒྱུན༌བུ། ལག་ཏུ་ཐོགས་པའི་མཁར་བ་བཅས་འཇོག་པར་མཛོད་ཅིག་ཅེས་སྨྲས་པ༌དང༌། ཡ་ཧུ་དཱ་ཡིས་དངོས་པོ་དེ་དག་ཁོ་མོར་སྤྲད༌རྗེས། ཁོ་མོ་དང་ལུས་འབྲེལ་བྱས་ཤིང་ཁོ་མོར་ཡ་ཧུ་དཱ་ལས་མངལ་སྦྲུམ་པར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","དེ་ནས་ཁོ་མོ་ཡར་ལངས་ནས་སོང་བ་དང༌། གདོང་ཁེབས་བླངས་ཏེ་ཡང་ཡུགས་མོའི་གྱོན་གོས་ལུས་ལ་གྱོན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ཡ་ཧུ་དཱ་ཡིས་རང་གི་གྲོགས་པོ་ཧི་རཱ་ལ་རེའུ་ཞིག་བསྐུར༌ཏེ། བུད་མེད་དེ་ལས་གཏའ་མ་ཕྱིར་ལེན་པར་ཕྱིན་ནའང་བུད་མེད་དེ་མ་རྙེད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ཡུལ་དེ་གའི་སྐྱེས་པ་རྣམས་ལ་ཨེ་ནཱ་ཡིམ་གྱི་ལམ་ཁར་སྡོད་པའི་ཆོས་རྫུ་སྨད་འཚོང་མ་ནི་གང་དུ་ཡོད་ཅེས་དྲིས་པ༌ན། དེ་རྣམས་ཀྱིས་འདི་རུ་ཆོས་རྫུ་སྨད་འཚོང་མ་མེད་ཅེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","དེ་ནས་ཧི་རཱ་ཕྱིར་ཡ་ཧུ་དཱའི་དྲུང་དུ་སོང་སྟེ་འདི༌ལྟར། ངས་ཁོ་མོ་རྙེད་མ༌བྱུང༌། ཡུལ་དེའི་སྐྱེས་པ་རྣམས་ཀྱིས་འདི་རུ་ཆོས་རྫུ་སྨད་འཚོང་མ་མེད་ཟེར་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ཡ་ཧུ་དཱ་ན༌རེ། ལྟོས༌དང༌། བདག་གིས་རེའུ་བསྐྱལ་ནའང་ཁྱོད་ཀྱིས་ཁོ་མོ་བཙལ་ནས་མ༌རྙེད། མི་གཞན་གྱིས་རང་ཅག་ལ་འཕྱ་སྨོད་མི་བྱེད་པའི༌ཕྱིར། ཁོ་མོར་ཁྱེར་ན་འཁྱེར་དུ་ཆུག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","དེ་ནས་ཟླ་བ་གསུམ་ཙམ་འགོར༌རྗེས། མི་ཞིག་གིས་ཡ་ཧུ་དཱ་ལ་འདི་ལྟར་སྨྲས༌པ། ཁྱོད་ཀྱི་མནའ་མ་ཐལ་མཱར་ནི་སྨད་འཚོང་མར་གྱུར་པར་མ༌ཟད། ཁོ་མོས་ལོག་གཡེམ་བྱས་ཏེ་མངལ་སྦྲུམ་འདུག་ཅེས་པ༌ན། ཡ་ཧུ་དཱ་ན༌རེ། ཁོ་མོ་དྲུད་ཡོང་ནས་མེར་བསྲེག་པར་གྱིས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","དེ་ནས་ཐལ་མཱར་དྲུད་ནས་ཡོང་བའི་སྐབས༌སུ། ཁོ་མོས་རང་གི་སྒྱུག་པོར་ངག་འཕྲིན་ཞིག་བསྐུར་བ༌སྟེ། དངོས་པོ་འདི་དག་སུ་ཞིག་གི་ཡིན༌ན། བདག་ལ་དེ་ལས་མངལ་སྦྲུམ་པ༌ཡིན། དེའི༌ཕྱིར། ཁྱོད་ཀྱིས་ཐམ་ག༌དང༌། ཐམ་གའི་རྒྱུན༌བུ། མཁར་བ་འདི་དག་སུ་ཞིག་གི་ཡིན་པ་ངོས་འཛིན་པར་གྱིས་ཞེས་མི་ཞིག་ཡ་ཧུ་དཱའི་དྲུང་དུ༌མངགས། ");
INSERT INTO bodn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","དེ་ནས་ཡ་ཧུ་དཱས་ཀྱང་དངོས་པོ་དེ་དག་ངོས་ཟིན༌ཏེ། ཁོ་མོ་ནི་བདག་ལས་ཀྱང་དྲང་པོ་ཡིན༌ཏེ། བདག་གིས་ཁོ་མོ་རང་གི་བུ་ཤེ་ལཱ་ལ་ཆུང་མར་མ་བྱིན་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ། །དུས་དེ་ནས་བཟུང་ཡ་ཧུ་དཱ་ཁོ་མོ་དང་ལུས་འབྲེལ་མ་མྱོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","དེ་ཡང་ཐལ་མཱར་བུ་བཙའ་རན་ལ་སླེབས་པའི་སྐབས༌སུ། ཁོ་མོའི་མངལ་དུ་མཚེ་མ་ཞིག་ཆགས་ཡོད་པ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ཁོ་མོས་བུ་བཙའ་བའི་དུས༌སུ། ཕྲུ་གུ་ཞིག་གི་ལག་པ་ཐོག་མར་མངལ་ལས་ཐོན་པ༌དང༌། སྐྱེ་གཡོག་མས་སྐུད་པ་དམར་པོ་ཕྲུ་གུའི་ལག་པར་མདུད༌དེ། འདི་ནི་ཕྲུ་གུ་ཐོག་མ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","དེ་ནས་ཅུང་མ་འགོར་བར་ཕྲུ་གུའི་ལག་པ་ཕྱིར་མངལ་ནང་དུ་བསྐུམས་པ༌དང༌། ཕྲུ་གུ་གཞན་དེ་ཐོག་མར༌བཙས། དེ་ནས་སྐྱེ་གཡོག་མ་ན༌རེ། ཁྱོད་ཅིའི་ཕྱིར་འཚང་ནས་ཡོང་ངམ་ཞེས་སྨྲས་པའི༌ཕྱིར། ཕྲུ་གུ་དེའི་མིང་ལ་ཕེ་རེལ་ཟི་ཞེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","དེའི་རྗེས་ནས་ལག་པར་སྐུད་པ་དམར་པོ་མདུད་པའི་ཕྲུ་གུའང་བཙས་པ༌དང༌། ཕྲུ་གུ་དེའི་མིང་ལ་ཟེ་རག་ཅེས་བཏགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","དེ་ཡང་ཡོ་སེབ་ནི་ཨེ་ཅིབ་ཡུལ་དུ་ཁྲིད་པ༌དང༌། ཨེ་ཅིབ་ཀྱི་མི་ཞིག་སྟེ་ཕཱར་ཨོལ་གྱི་ནང་བློན་དང་རྒྱལ་པོའི་སྐུ་སྲུང་དམག་དཔོན་ཕའོ་ཏི་ཕར་གྱིས་ཡེས་མ་ཨེལ་མི་རིགས་ཀྱི་ཚོང་པ་དེ་རྣམས་ལས་ཡོ་སེབ་ཉོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","དེ་ནས་ཡོ་སེབ་ནི་ཨེ་ཅིབ་ཡུལ་གྱི་རང་གི་བདག་པོ་ཕའོ་ཏི་ཕར་གྱི་ཁྱིམ་དུ་བསྡད༌ཅིང༌། དཀོན་མཆོག་ཡ་ཝཱེ་ཡང་ཁོ་དང་མཉམ་དུ་བཞུགས་པས་ཁོའི་བྱ་བ་ཐམས་ཅད་བདེ་བར༌གྲུབ། ");
INSERT INTO bodn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","བདག་པོ་ཕའོ་ཏི་ཕར་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ཁོ་དང་མཉམ་དུ་བཞུགས་པ་དང་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོའི་བྱ་བ་ཐམས་ཅད་བདེ་བར་འགྲུབ་པར་མཛད་པ་མཐོང༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ཡོ་སེབ་ལ་བདག་པོ་ཕའོ་ཏི་ཕར་གྱི་མདུན་དུ་ཐུགས་རྗེ་ཐོབ་པ་དང་ཁོས་བདག་པོ་ལ་ཞབས་ཕྱི་བསྒྲུབས་པར་མ༌ཟད། བདག་པོས་ཁོ་རང་ཁྱིམ་ལས་གཉེར་མཁན་དུ་བསྐོས་ཤིང་རྒྱུ་ནོར་ཐམས་ཅད་ཁོ་ལ་བཅོལ་བ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","དུས་དེ་ནས༌བཟུང༌། དཀོན་མཆོག་ཡ་ཝཱེས་ཡོ་སེབ་ཀྱི་རྐྱེན་ལ་བརྟེན་ནས་ཨེ་ཅིབ་ཀྱི་མི་དེའི་ཁྱིམ་ལ་བྱིན་རླབས་གནང༌སྟེ། བདག་པོའི་ཁྱིམ་ཚང་ཕྱི་ནང་ཐམས་ཅད་ལ་བྱིན་རླབས་ཐོབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","དེ་ལྟར་བདག་པོས་རྒྱུ་ནོར་ཐམས་ཅད་ཡོ་སེབ་ལ་བཅོལ་བ༌དང༌། རང་གི་བཟའ་བཏུང་ཁོ་ན་མ༌གཏོགས། དོན་གཞན་དག་ལ་སེམས་ཁུར་ཅི་ཡང་མི་བྱེད༌དོ།། དེ་ཡང་ཡོ་སེབ་ནི་སྐྱེས་གཟུགས་ལེགས་ཤིང་ཞལ་རས་མཛེས་པའི་ཕོ་གསར་ཞིག་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","དོན་དེའི་རྗེས༌སུ། བདག་པོའི་ཆུང་མས་ཡོ་སེབ་ལ་ཟུར་མིག་བསྟན༌ཏེ། ཁྱོད་བདག་དང་འགྲོགས་པར་གྱིས་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","འོན་ཀྱང་ཡོ་སེབ་ཀྱིས་དོན་དེ་ཁས་མ་བླངས་པར་ཁོ་མོ་ལ་འདི༌ལྟར། ལྟོས༌དང༌། བདག་པོས་རྒྱུ་ནོར་ཐམས་ཅད་བདག་ལ་བཅོལ་བ༌དང༌། ཁྱིམ་ཚང་ལ་སེམས་ཁུར་ཅི་ཡང་མི༌བྱེད། ");
INSERT INTO bodn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ཁྱིམ་འདི་རུ་བདག་ལས་དབང་ཅན་ཞིག༌མེད། བདག་པོས་ཁྱོད་རང་ཁོ་ན་ལས༌གཞན། བདག་ལ་མ་བཅོལ་བ་གཅིག་ཀྱང་མེད༌དེ། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱོད་ནི་བདག་པོའི་ཆུང་མ་ཡིན་པའི་ཕྱིར༌རོ། །དེའི༌ཕྱིར། བདག་གིས་ལས་ངན་པ་འདི་ལྟ་བུ་བྱེད་རུང༌ངམ། གལ་ཏེ་འདི་ལྟར་བྱས་ན་བདག་གིས་དཀོན་མཆོག་ལ་འགལ་བའི་སྡིག་པ་བྱས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ཕྱིས་སུའང་ཁོ་མོས་ནམ་རྒྱུན་ཡོ་སེབ་ལ་དེ་ལྟར་སྨྲས་ཀྱང་ཡོ་སེབ་ཀྱིས་དོན་དེ་ཁས་མི་ལེན་པར་མ༌ཟད། ཁོ་མོ་དང་མཉམ་དུའང་མ་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ཉིན་ཞིག༌ལ། ཡོ་སེབ་ཁྱིམ་ནང་དུ་ཞབས་ཕྱི་བསྒྲུབ་ཏུ་སོང༌ཞིང༌། ཁྱིམ་དུ་ཞབས་ཕྱི་པ་གཞན་སུ་ཡང་མེད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","བུད་མེད་དེས་ཡོ་སེབ་ཀྱི་ལྭ་བ་ནས་བཟུང༌སྟེ། ཁྱོད་བདག་དང་འགྲོགས་པར་གྱིས་ཞེས་སྨྲས་པ༌ན། ཡོ་སེབ་ཀྱིས་ལྭ་བ་བསྐྱུར་ཏེ་སྒོའི་ཕྱི་རོལ་ཏུ་བྲོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","དེ་ནས་བུད་མེད་དེས་ཡོ་སེབ་ཀྱིས་ལྭ་བ་བསྐྱུར་ནས་བྲོས་པ་མཐོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ཞབས་ཕྱི་པ་གཞན་དག་བོས༌ཏེ། ཁྱོད་ཅག་གིས་ལྟོས༌དང༌། བདག་པོས་ཨིབ་རི་པ་ཞིག་རང་ཁྱིམ་དུ་ཁྲིད་ཡོང་ནས་རང་ཅག་ལ་བརྙས་བཅོས་བྱེད༌དོ། །ཡོ་སེབ་ང་རང་ལ་འགྲོགས་སུ་ཡོང་བ་དང་ངས་སྐད་ཆེན་པོས་ཀི་བཏབ་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ཁོས་ཀི་སྒྲ་ཐོས་པ་དང་ལྭ་བ་འདི་རུ་བསྐྱུར་ཏེ་སྒོའི་ཕྱི་རོལ་ཏུ་བྲོས་སོང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","དེ་ནས་བུད་མེད་དེས་ཡོ་སེབ་ཀྱི་ལྭ་བ་ཁོ་མོའི་གནས་དེར་བཞག་སྟེ་བདག་པོ་ཡོང་བར་སྒུག་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","བདག་པོ་ཡོང་བ་དང་ཁོ་མོས་འདི༌ལྟར། ཁྱོད་ཀྱིས་རང་ཁྱིམ་དུ་ཁྲིད་ཡོང་བའི་ཨིབ་རི་པ་གཡོག་པོ་དེས་ང་རང་རྩེད་སྤྱད་བྱེད་པར་རྩོམ་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ངས་སྐད་ཆེན་པོས་ཀི་བཏབ་པ་དང་ཁོས་ལྭ་བ་བསྐྱུར་ནས་བྲོས་སོང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","དེ་ཡང་ཡོ་སེབ་ཀྱི་བདག་པོས་རང་གི་ཆུང་མས་ཁྱོད་ཀྱི་གཡོག་པོས་བདག་ལ་འདི་ལྟར་བྱས་བྱུང་ཞེས་སྨྲས་པའི་གཏམ་ཐོས་པ་དང་ཤིན་ཏུ་ཁྲོས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","རྒྱལ་པོའི་བཙོན་པ་བཙོན་དུ་འཇུག་སར་ཡོ་སེབ་ཀྱང་བཙོན་ལ་བཅུག་པ༌དང༌། ཡོ་སེབ་དེ་རུ་བཙོན་དུ༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","འོན༌ཀྱང༌། དཀོན་མཆོག་ཡ་ཝཱེ་ནི་ཡོ་སེབ་དང་ལྷན་དུ་བཞུགས་ཤིང་ཁོང་གིས་ཡོ་སེབ་ལ་ཐུགས་རྗེས་གཟིགས༌པས། བཙོན་བདག་གི་མིག་མདུན་ནས་ཀྱང་ཁོ་རང་ལ་ཐུགས་རྗེ་ཐོབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","དེ་ནས་བཙོན་བདག་གིས་བཙོན་ཁང་ནང་གི་བཙོན་པ་ཐམས་ཅད་ཡོ་སེབ་ལ་བཅོལ༌བས། བཙོན་ཁང་གི་བྱ་བ་གང་ཡིན་ཡང་ཡོ་སེབ་བརྒྱུད་དགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ཡོ་སེབ་ཀྱིས་བསྒྲུབས་པའི་བྱ་བར་བཙོན་བདག་གིས་ཀྱང་བརྟག་དཔྱོད་མི་བྱེད༌དེ། དཀོན་མཆོག་ཡ་ཝཱེ་ནི་ཡོ་སེབ་དང་ལྷན་དུ་བཞུགས༌ཤིང༌། ཁོང་གིས་ཡོ་སེབ་ཀྱི་བྱ་བ་ཐམས་ཅད་བདེ་བར་འགྲུབ་པར་མཛད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","དེ་ཡང་དོན་དེའི་རྗེས་སུ་ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོའི་ཆང་གཉེར་བློན་ཆེན་དང་གསོལ་དཔོན་བློན་ཆེན་གཉིས་རང་གི་རྒྱལ་པོ་དང་འགལ༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ཕཱར་ཨོལ་ཆང་གཉེར་བློན་ཆེན་དང་གསོལ་དཔོན་བློན་ཆེན་གཉིས་ལ་ཐུགས་ཤིན་ཏུ་ཁྲོས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ཁོ་གཉིས་རྒྱལ་པོའི་སྐུ་སྲུང་དམག་དཔོན་གྱི་བཙོན་ཁང་དུ༌བཅུག དེ་ནི་ཡོ་སེབ་བཙོན་དུ་བཅུག་པའི་གནས༌དེའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","དེ་ནས་སྐུ་སྲུང་དམག་དཔོན་གྱིས་མི་དེ་གཉིས་ཀྱང་ཡོ་སེབ་ལ་བཅོལ་བ༌དང༌། ཡོ་སེབ་ཀྱིས་དེ་གཉིས་ལ་ཞབས་ཕྱི་བསྒྲུབས༌ཤིང༌། ཁོ་རྣམས་དུས་ཡུན་རིང་པོ་ཞིག་ལ་བཙོན་ཁང་ནས་མཉམ་དུ་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","དེ་ཡང་བཙོན་དུ་བཅུག་པའི་རྒྱལ་པོའི་ཆང་གཉེར་པ་དང་གསོལ་དཔོན་གཉིས་ཀྱིས་ཞག་གཅིག་ལ་རྨི་ལམ་རེ་རྨིས༌ཤིང༌། རྨི་ལམ་རེ་ལ་ནང་དོན་རེ་ཡོད་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ཞོགས་པར་སླེབས༌དུས། ཡོ་སེབ་མི་དེ་གཉིས་ཀྱི་གམ་དུ་སོང་བ་དང་ཁོ་གཉིས་ཡིད་སྐྱོ་བའི་གནས་སུ་ལྷུང་བའི་ཉམས་འགྱུར་མཐོང༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ཁོས་ཕཱར་ཨོལ་གྱི་བློན་ཆེན་གཉིས་ཏེ་རང་དང་མཉམ་དུ་བདག་པོའི་བཙོན་དུ་བཅུག་ཡོད་པར་འདི༌ལྟར། དེ་རིང་ཁྱོད་གཉིས་ཀྱི་གདོང་ལ་སྐྱོ་བའི་ཉམས་ཤིག་ཤར་ཡོད་པའི་རྒྱུ་མཚན་ཅི་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ཁོ་གཉིས་ན༌རེ། ངེད་གཉིས་ཀྱིས་རྨི་ལམ་རེ་རྨིས་ནའང་རྨི་ལམ་ལ་བརྟག་མཁན་མེད་ཅེས་ལན་བཏབ་པ༌དང༌། ཡང་ཡོ་སེབ་ན༌རེ། རྨི་ལམ་ལ་བརྟག་མཁན་ནི་དཀོན་མཆོག་མ་ཡིན༌ནམ། ཁྱོད་གཉིས་ཀྱིས་རྨི་ལམ་དེ་བདག་ལ་ཤོད་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","དེ་ནས་ཆང་གཉེར་པས་རང་གི་རྨི་ལམ་ཡོ་སེབ་ལ་འདི༌ལྟར། བདག་གི་རྨི་ལམ་ནང་དུ་ངའི་མདུན་དུ་རྒུན་འབྲུམ་ཤིང་ཞིག་ཡོད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","རྒུན་ཤིང་དེ་ལ་ཡལ་ག་གསུམ་ཡོད་པ༌དང༌། དེ་དག་ལ་ལོ་མ་འབུས་ནས་མེ་ཏོག་བཞད་པ༌དང༌། རྒུན་ཤིང་དེ་ལ་རྒུན་འབྲུམ་ཡང་སྨིན༌ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","བདག་གི་ལག་ཏུ་ཕཱར་ཨོལ་གྱི་ཕོར་བ་ཡོད་པ་དང་བདག་གིས་རྒུན་འབྲུམ་ཕོར་བའི་ནང་བཙིར༌རྗེས། ཕོར་བ་དེ་རྒྱལ་པོའི་ཕྱག་ཏུ་ཕུལ་ཞེས་སྨྲས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","དེ་ནས་ཡོ་སེབ་ན༌རེ། ཁྱོད་ཀྱི་རྨི་ལམ་ལ་བརྟགས་ན་འདི་ལྟ༌སྟེ། ཡལ་ག་གསུམ་ནི་ཉིན་གསུམ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ཉིན་གསུམ་གྱི་ནང༌དུ། ཕཱར་ཨོལ་གྱིས་ཁྱོད་རང་བཙོན་ཁང་ནས་ཕྱིར་གཏོང་བ༌དང༌། ཁྱོད་ལ་དཔོན་ས་སྔར་བཞིན་འཐོབ༌ཅིང༌། ཁྱོད་དེ་སྔར་ཆང་གཉེར་བློན་ཆེན་ཡིན་པ༌བཞིན། མུ་མཐུད་ནས་རྒྱལ་པོའི་ཕྱག་ཏུ་ཕོར་བ་འབུལ་བར་འགྱུར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","འོན་ཀྱང་ཁྱོད་རང་བདེ་བླག་ཡིན་པའི་དུས་སུ་ང་རང་སེམས་སུ་འཛིན་པ་དང་ཐུགས་རྗེ་གནང་བར༌ཞུ། ཕཱར་ཨོལ་གྱི་དྲུང་དུའང་བདག་གླེང༌ནས། ང་རང་བཙོན་ལས་སྐྱོབ་པར༌ཞུ། ");
INSERT INTO bodn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","བདག་ནི་དངོས་གནས་ཨིབ་རི་པའི་ཡུལ་ནས་མི་གཞན་གྱིས་བཙན་ཁྲིད་བྱས་ཏེ་འདིར་ཡོང་བ༌དང༌། བདག་གིས་གནས་འདི་རུ་བཙོན་དུ་འཇུག་དགོས་པའི་ལས་ཅི་ཡང་བྱས་མེད་ཅེས་སྨྲས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","དེ་ཡང་ཡོ་སེབ་ཀྱིས་རྨི་ལམ་ལ་ལེགས་པར་བརྟགས་པ་གསོལ་དཔོན་གྱིས་མཐོང༌སྟེ། ཡོ་སེབ་ལ་འདི༌ལྟར། ངས་རྨི་ལམ་ནང་དུ་བག་ལེབ་སླེ་བོ་གསུམ་མགོ་ལ་ཁུར༌ཞིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","སླེ་བོ་གོང་མའི་ནང་དུ་ཕཱར་ཨོལ་ལ་གཡོས་སྦྱོར་བྱས་པའི་ཟས་རིགས་བསྲེག་མ་སྣ་ཚོགས་ཡོད་པ༌དང༌། བྱ་རྣམས་འཕུར་ཡོང་སྟེ་ཟོས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","དེ་ནས་ཡོ་སེབ་ན༌རེ། ཁྱོད་ཀྱི་རྨི་ལམ་ལ་བརྟགས་ན་འདི་ལྟ༌སྟེ། སླེ་བོ་གསུམ་ནི་ཉིན་གསུམ་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ཉིན་གསུམ་གྱི་ནང༌དུ། ཕཱར་ཨོལ་གྱིས་ཁྱོད་ཀྱི་མགོ་བོ་གཅོད་པ༌དང༌། ཁྱོད་ཀྱི་བེམ་པོ་ལྗོན་ཤིང་གི་སྟེང་དུ་འགེལ༌ཞིང༌། བྱ་རྣམས་འཕུར་ཡོང་ནས་ཁྱོད་ཀྱི་བེམ་པོ་ཐོག་གི་ཤ་ཐམས་ཅད་བཟའ་བར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","དེ་ནས་ཉིན་གསུམ་པར་སླེབས་པ༌དང༌། ཉིན་དེ་ནི་ཕཱར་ཨོལ་གྱི་འཁྲུངས་སྐར་ཡིན༌པས། ཁོང་གིས་ཞབས་ཕྱི་པ་རྣམས་ལ་གསོལ་སྟོན་གཟབ་རྒྱས་བསྡུས༌ཤིང༌། བཙོན་ཁང་དུ་ཡོད་པའི་ཆང་གཉེར་པ་དང་གསོལ་དཔོན་གཉིས་ཀྱང་ཁྲིད་ཡོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ཆང་གཉེར་པ་ནི་སྔར་བཞིན་ཆང་གཉེར་བློན་ཆེན་དུ་བསྐོས་པ༌དང༌། ཁོས་སྔར་བཞིན་ཕཱར་ཨོལ་གྱི་ཕྱག་ཏུ་ཕོར་བ་ཕུལ་ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","འོན༌ཀྱང༌། ཡོ་སེབ་ཀྱིས་རྨི་ལམ་ལ་བརྟགས་པ་བཞིན་གསོལ་དཔོན་ནི་སྡོང་པོའི་སྟེང་དུ༌བཀལ། ");
INSERT INTO bodn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ཡིན་ནའང་ཆང་གཉེར་བློན་ཆེན་གྱིས་ཡོ་སེབ་སེམས་སུ་མ་བཟུང་ཞིང་གཏན་དུ་བརྗེད་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","དེ་ཡང་ལོ་གཉིས་འགོར་བའི་རྗེས་སུ་ཕཱར་ཨོལ་གྱིས་རྨི་ལམ་ཞིག་རྨིས༌ཤིང༌། རྨི་ལམ་ནང་དུ་ཁོ་རང་ནཱ་ཡོལ་གཙང་པོའི་འགྲམ་དུ་བསྡད་ཡོད་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","བ་མོ་བདུན་གཙང་པོ་ལས་ཚུར་ཡོང་བ༌དང༌། བ་མོ་དེ་དག་ལྟ་ན་སྡུག་ཅིང་ཤ་ཤེད་རྒྱས་པ་ཞིག་ཡིན་ལ་ཆུ་ནང་གི་རྩྭ་སྔོན་ཟོས་ནས༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","དེ་ནས་ཡང་བ་མོ་བདུན་གཙང་པོ་ལས་ཚུར་ཡོང་བ༌དང༌། བ་མོ་དེ་དག་ཤིན་ཏུ་བཙོག་ཅིང་ལུས་ཟུངས་རིད་པོ་ཡིན༌ལ། ཤ་ཤེད་རྒྱས་པའི་བ་མོ་བདུན་པོ་དང་མཉམ་དུ་གཙང་པོའི་འགྲམ་དུ༌བསྡད། ");
INSERT INTO bodn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","དེ་ནས་ཤིན་ཏུ་བཙོག་ཅིང་ལུས་ཟུངས་རིད་པའི་བ་མོ་བདུན་པོས་ལྟ་ན་སྡུག་ཅིང་ཤ་ཤེད་རྒྱས་པའི་བ་མོ་བདུན་པོ་ཟོས་པ༌དང༌། དེ་ནས་ཕཱར་ཨོལ་གཉིད་སད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ཕཱར་ཨོལ་སླར་ཡང་གཉིད་དུ་ཡུར་བ་དང་རྨི་ལམ་རྨིས༌སོ། །རྨི་ལམ་གཉིས་པའི་ནང༌དུ། གྲོ་ཡི་རྩི་ཤིང་གཅིག་ལ་སྙེ་མ་བདུན་ཐོགས༌ཤིང༌། སྙེ་མ་རེ་རེ་ནི་ཁ་གང་ཞིང་འབྲས་བུ་སྨིན་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","དེ་ནས་ཡང་སྙེ་མ་བདུན་ཐོགས༌ཤིང༌། སྙེ་མ་དེ་དག་ནི་ཤིན་ཏུ་ཕྲ་ཞིང་འབྲས་བུ་མ་སྨིན་པ་དང་ཤར་རླུང་གིས་བསྐམས་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","དེར་སྙེ་མ་ཤིན་ཏུ་ཕྲ་མོ་དེ་དག་གིས་སྙེ་མ་ཁ་གང་ཞིང་འབྲས་བུ་སྨིན་པ་དེ་དག་ཟོས་པར༌གྱུར། དེ་ནས་ཕཱར་ཨོལ་གཉིད་སད་པ་དང་དོན་དེ་རྨི་ལམ་ཡིན་པ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ནམ་ལངས་པ་དང་ཕཱར་ཨོལ་གྱི་སེམས་འཁྲུགས་པར་གྱུར༌པས། ཨེ་ཅིབ་ཡུལ་གྱི་མོ་པ་དང་བློ་གྲོས་ཅན་ཐམས་ཅད་བོས༌ཏེ། རྨི་ལམ་གྱི་དོན་དེ་སྨྲས་ནའང་སུས་ཀྱང་ཁོ་རང་ལ་འགྲེལ་མ་ནུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","དེ་ནས་ཆང་གཉེར་བློན་ཆེན་གྱིས་ཕཱར་ཨོལ་ལ་འདི༌ལྟར། དེ་རིང་བདག་གིས་རང་གི་ཉེས་པ་དྲན༌བྱུང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","དེ་སྔོན་ཕཱར་ཨོལ་ཐུགས་ཁྲོས༌ཏེ། བདག་དང་གསོལ་དཔོན་གཉིས་ཀ་སྐུ་སྲུང་དམག་དཔོན་གྱི་བཙོན་ཁང་དུ་བཅུག༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ངེད་གཉིས་ཀྱིས་ཞག་གཅིག་ལ་རྨི་ལམ་རེ་རྨིས་ཤིང་རྨི་ལམ་རེ་ལ་ནང་དོན་རེ༌མཆིས། ");
INSERT INTO bodn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","གནས་དེར་ངེད་གཉིས་དང་མཉམ་དུ་ཨིབ་རི་པའི་གཞོན་ནུ་ཞིག་ཀྱང༌ཡོད། ཁོ་རང་ནི་སྐུ་སྲུང་དམག་དཔོན་གྱི་ཞབས་ཕྱི་པ༌རེད། ངེད་གཉིས་ཀྱིས་རྨི་ལམ་ཁོ་ལ་སྨྲས་པ༌ན། ཁོས་ངེད་གཉིས་ཀྱི་རྨི་ལམ་ལ་རེ་རེ་བཞིན་བརྟགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ཕྱིས་སུ་ཁོས་རྨི་ལམ་ལ་བརྟགས་པ༌བཞིན། བདག་ལ་གོ་ས་སྔར་བཞིན་ཐོབ་པ་དང་གསོལ་དཔོན་ནི་སྡོང་པོའི་སྟེང་དུ་བཀལ་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","དེ་ནས་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་གདན་འདྲེན་པར་མི་འགའ་མངགས༌ཤིང༌། དེ་རྣམས་ཀྱིས་མྱུར་བ་མྱུར་དུ་ཡོ་སེབ་བཙོན་ཁང་ལས་ཕྱིར་ཁྲིད༌ཅིང༌། ཁོའི་སྐྲ་དང་སྨྲ་ར་བཞར་བ་དང་གྱོན་པ་བརྗེས་ཏེ་ཕཱར་ཨོལ་གྱི་དྲུང་དུ་ཁྲིད་ཡོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","དེ་ནས་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། བདག་གིས་རྨི་ལམ་ཞིག་རྨིས་ཤིང་སུས་ཀྱང་རྨི་ལམ་ལ་བརྟག་མ༌ཤེས། གོ་ཐོས་ལྟར་ན་ཁྱོད་ཀྱིས་རྨི་ལམ་ཐོས་མ་ཐག་ཏུ་བརྟག་ཤེས་འདུག་ཟེར་ཞེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ཡོ་སེབ་ན༌རེ། དེ་ནི་བདག་ལ་རག་ལས་པ་མིན༌ཏེ། དཀོན་མཆོག་གིས་ཁྱོད་ལ་ལན་ལེགས་པོ་ཞིག་གནང་བར་འགྱུར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ཡང་ཕཱར་ཨོལ་ན༌རེ། རྨི་ལམ་ནང་དུ་བདག་ནི་ནཱ་ཡོལ་གཙང་པོའི་འགྲམ་དུ་བསྡད་ཡོད༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","བ་མོ་བདུན་གཙང་པོ་ལས་ཚུར་ཡོང་བ་དང་དེ་དག་ནི་ལྟ་ན་སྡུག་ཅིང་ཤ་ཤེད་རྒྱས་པ་ཞིག་ཡིན་པ་དང་ཆུ་ནང་གི་རྩྭ་སྔོན་ཟ་བཞིན༌ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","དེ་ནས་ཡང་བ་མོ་བདུན་གཙང་པོ་ལས་ཚུར་ཡོང་བ་དང་དེ་དག་ནི་ཤིན་ཏུ་བཙོག་ཅིང་ཤ་ཤེད་ཞན༌ལ། བདག་གིས་བ་མོ་བཙོག་པོ་དེ་དག་ལྟ་བུ་ནི་ཨེ་ཅིབ་ཡུལ་ཀུན་ཏུའང་མཐོང་མ༌མྱོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","དེ་ནས་ཤིན་ཏུ་བཙོག་ཅིང་ཤ་ཤེད་ཞན་པའི་བ་མོ་བདུན་པོས་དེ་སྔོན་གྱི་ཤ་ཤེད་རྒྱས་པའི་བ་མོ་བདུན་པོ་ཟོས་སོང་བ་དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","དེ་དག་གིས་ཟོས་ཚར་ནའང་ཚུགས་ཀ་བཙོག་པོ་ནི་སྔར་བཞིན་ཡིན༌པས། ཟོས་སམ་མ་ཟོས་སུས་ཀྱང་ལྟ་མི་ཤེས༌ལ། དེ་ནས་ང་རང་ཡང་གཉིད་སད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","དེ་ནས་ཡང་བདག་གིས་རྨི་ལམ་ཞིག་རྨིས་པ༌དང༌། རྨི་ལམ་ནང་དུ་གྲོ་ཡི་རྩི་ཤིང་གཅིག་ལ་སྙེ་མ་བདུན་ཐོགས༌ཤིང༌། སྙེ་མ་རེ་རེ་ནི་ཁ་གང་ཞིང་འབྲས་བུ་སྨིན་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","དེ་ནས་ཡང་སྙེ་མ་བདུན་ཐོགས༌ཤིང༌། སྙེ་མ་དེ་དག་ནི་ཤིན་ཏུ་ཕྲ་ཞིང་འབྲས་བུ་མ་སྨིན་པ་དང་ཤར་རླུང་གིས་བསྐམས་པར་གྱུར༌ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","སྙེ་མ་ཤིན་ཏུ་ཕྲ་མོ་དེ་དག་གིས་ཁ་གང་ཞིང་འབྲས་བུ་སྨིན་པའི་སྙེ་མ་བདུན་པོ་ཟོས་པ༌དང༌། བདག་གིས་རྨི་ལམ་འདི་མོ་པ་རྣམས་ལ་སྨྲས་ནའང་སུས་ཀྱང་བརྟག་མ་ཤེས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","དེ་ནས་ཡོ་སེབ་ཀྱིས་ཕཱར་ཨོལ་ལ་འདི༌ལྟར། རྒྱལ་པོ་ཁྱེད་ཀྱིས་རྨིས་པའི་རྨི་ལམ་གཉིས་ཀ་དོན་གཅིག་ཡིན༌འདུག དཀོན་མཆོག་གིས་གང་ཞིག་མཛད་པར་འགྱུར་བ་ཁྱེད་ལ་བསྟན་ཟིན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","དེ་ཡང་བ་མོ་ཤ་ཤེད་ཅན་བདུན་པོ་ནི་ལོ་བདུན༌དང༌། ཁ་གང་ཞིང་འབྲས་བུ་སྨིན་པའི་སྙེ་མ་བདུན་པོའང་ལོ་བདུན༌ཡིན། འདི་གཉིས་རྨི་ལམ་གཅིག༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","དེའང་ཕྱིས་སུ་ཡོང་བའི་ཚུགས་ཀ་ཤིན་ཏུ་བཙོག་ཅིང་ཤ་ཤེད་ཞན་པའི་བ་མོ་བདུན་ནི་ལོ་བདུན༌དང༌། ཤར་རླུང་གིས་བསྐམས་པའི་སྙེ་མ་བདུན་པོའང་ལོ་བདུན༌ཡིན། དེ་གཉིས་ནི་མུ་གེ་འབྱུང་བའི་ལོ་བདུན༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","དེའི༌ཕྱིར། བདག་གིས་གོང་ནས་ཕཱར་ཨོལ་ལ་སྨྲས་པ་བཞིན་དཀོན་མཆོག་གིས་གང་ཞིག་མཛད་པར་འགྱུར་བ་ཁྱེད་ལ་བསྟན་ཟིན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ཨེ་ཅིབ་ཡུལ་ཡོངས་སུ་ལོ་བདུན་རིང་ལ་ལོ་ལེགས་འབྱུང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","དེ་ནས་ལོ་བདུན་རིང་ལ་མུ་གེ་འབྱུང་ངེས༌ཤིང༌། ཐ་ན་ཨེ་ཅིབ་ཡུལ་གྱི་མི་རྣམས་ཀྱིས་ལོ་ལེགས་བྱུང་བའི་དོན་དེའང་བརྗེད་པར་འགྱུར་བ༌དང༌། ཡུལ་ཡོངས་ལ་མུ་གེ་ཆེན་པོ་བྱུང་ནས་བརླག་པར་འགྱུར༌ངེས། ");
INSERT INTO bodn_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ཕྱིས་སུ་འབྱུང་ངེས་པའི་མུ་གེ་དེ་ནི་ཤིན་ཏུ་ཚབས་ཆེ་བའི༌ཕྱིར། ལོ་ལེགས་བྱུང་བའི་དོན་དེ་མི་རྣམས་ཀྱིས་སེམས་སུ་མི་དྲན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ཕཱར་ཨོལ་ཁྱེད་ཀྱིས་རྨི་ལམ་ཐེངས་གཉིས་ལ་རྨིས་པ་ནི་དཀོན་མཆོག་གིས་ཐུགས་ཐག་བཅད་པའི༌ཕྱིར། ཁོང་གིས་དོན་དེ་མྱུར་དུ་འགྲུབ་པར་མཛད༌ངེས། ");
INSERT INTO bodn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","དེའི༌ཕྱིར། ཕཱར་ཨོལ་ཁྱེད་ཀྱིས་བློ་དང་ཤེས་རབ་ལྡན་པའི་མི་ཞིག་བདམས༌ཏེ། ཨེ་ཅིབ་ཡུལ་སྐྱོང་བ་ལ་བསྐོ་བར༌མཛོད། ");
INSERT INTO bodn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ཕཱར་ཨོལ་ཁྱེད་ཀྱིས་དེ་ལྟར་བྱས་རྗེས་ས་གནས་དཔོན་པོ་རྣམས་ཀྱང་ཡུལ་དེར་མངགས་ནས་དོ་དམ་བྱེད་པར༌མཛོད། དེ་ཡང་ལོ་བདུན་ལ་ལོ་ལེགས་འབྱུང་བའི་དུས༌སུ། ཨེ་ཅིབ་ཡུལ་གྱི་ལྔ་ཆའི་གཅིག་བསྡུས༌ཏེ། ");
INSERT INTO bodn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ས་གནས་དཔོན་པོ་རྣམས་ལ་ལོ་ལེགས་བྱུང་བའི་འབྲུ་རིགས་གྲོན་ཆུང་བྱས་ནས་གྲོང་ཁྱེར་ནང་གསོག་ཏུ་འཇུག་པ་དང་ཕཱར་ཨོལ་གྱི་དབང་འོག་ཏུ་འཇུག་པར་བྱ༌དགོས། ");
INSERT INTO bodn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ཡང་ཡུལ་ཡོངས་ལ་མུ་གེ་ཆེན་པོ་བྱུང་ནས་བརླག་པར་མི་འགྱུར་བའི༌ཕྱིར། འབྲུ་རིགས་གསོག་འཇོག་བྱས་ན་མ་འོངས་པར་ལོ་བདུན་རིང་ལ་མུ་གེ་འབྱུང་བའི་དཀའ་ངལ་སེལ་ཐུབ་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","དེ་ཡང་ཕཱར་ཨོལ་དང་ཁོང་གི་འཁོར་གཡོག་ཐམས་ཅད་ཀྱིས་དོན་དེ་ལེགས་པར༌སྙམ། ");
INSERT INTO bodn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","དེ་ནས་ཕཱར་ཨོལ་གྱིས་རང་གི་འཁོར་གཡོག་རྣམས་ལ་འདི༌ལྟར། དཀོན་མཆོག་གི་ཐུགས་ཉིད་དང་ལྡན་པའི་མི་འདི་ལྟ་བུ་ནི་སུ་ཞིག་གིས་བཙལ་ནས་རྙེད་དམ་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ཡང་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། དཀོན་མཆོག་གིས་དོན་འདི་ཁྱོད་ལ་མངོན་པར་མཛད༌པས། ཁྱོད་བཞིན་དུ་བློ་དང་ཤེས་རབ་ལྡན་པའི་མི་གཞན་ཞིག་ཡོད་མི༌སྲིད། ");
INSERT INTO bodn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ཁྱོད་ཀྱིས་བདག་གི་ཕོ་བྲང་སྐྱོང་བ༌དང༌། བདག་གི་འབངས་མི་ཐམས་ཅད་ཀྱིས་ཁྱོད་ཀྱི་ངག་ལ་ཉན་སྲིད་པ༌དང༌། ཁྲི་སྟེང་དུ་བཞུགས་པ་བདག་ཁོ་ན་ཁྱོད་ལས་མཐོའོ་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ཡང་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། ལྟོས༌དང༌། བདག་གིས་ཁྱོད་ནི་ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་སྐྱོང་བར་བསྐོས་པ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","རང་གི་མཛུབ་མོ་སྟེང་གི་ཐམ་ག་དང་ལྡན་པའི་མཛུབ་དཀྲིས་བླངས་ཏེ་ཡོ་སེབ་ཀྱི་མཛུ་གུར་བསྐོན་པ༌དང༌། ཡོ་སེབ་ཀྱི་ལུས་ལ་སོ་རས་སྲབ་བུའི་གོས་བསྐོན་ཞིང་སྐེ་ལ་གསེར་གྱི་མགུལ་རྒྱན་འདོགས་སུ་བཅུག་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","རྒྱལ་པོའི་ཤིང་རྟ་གཉིས་པར་ཡོ་སེབ་སྡོད་དུ་བཅུག་པ༌དང༌། དེའི་སྔོན་དུ་མི་མངགས་ཤིང་དེ་དག་གིས་ཕྱག་འཚལ་བར་གྱིས་ཞེས༌སྨྲས། དེ་ལྟར་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ནི་ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་སྐྱོང་བར་བསྐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ཡང་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། བདག་ནི་ཕཱར་ཨོལ་ཡིན༌ནོ། །ཨེ་ཅིབ་ཡུལ་ཡོངས་སུ་ཁྱོད་ཀྱི་བཀའ་མེད༌ན། མི་སུས་ཀྱང་གང་འདོད་དུ་བྱ་མི་རུང་ཞེས༌སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","དེ་ནས་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ཀྱི་མིང་ལ་ཚཱབ་ནཱ་ཕཱ་ནེ་ཨ་ཞེས་བཏགས་པ༌དང༌། ཡང་ཨོ་ནཱ་ཡུལ་གྱི་མཆོད་དཔོན་ཕའོ་ཏི་ཕེ་རཱ་ཞེས་པའི་བུ་མོ་ཨ་སི་ནཱ་ཐི་ཁོའི་ཆུང་མར༌གནང༌། དེ་ནས་ཡོ་སེབ་ནི་ཨེ་ཅིབ་ཀྱི་ཡུལ་སོ་སོར་རྟོག་དཔྱོད་བྱེད་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","དེ་ཡང་རྒྱལ་པོ་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ཁོ་རང་ཨེ་ཅིབ་ཀྱི་ཡུལ་སྐྱོང་བར་བསྐོས་པའི་དུས་སུ་ཁོ་ལོ་སུམ་ཅུ་ཡིན༌ལ། ཁོ་རང་རྒྱལ་པོའི་དྲུང་ནས་ཨེ་ཅིབ་ཀྱི་ཡུལ་ཐམས་ཅད་ལ་རྟོག་དཔྱོད་བྱེད་དུ༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ལོ་ལེགས་བྱུང་བའི་ལོ་བདུན་རིང་ལ་འབྲུ་རིགས་ཕུན་སུམ་ཚོགས་པ་ཐོབ་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ཡོ་སེབ་ཀྱིས་ལོ་བདུན་རིང་ལ་ལོ་ལེགས་བྱུང་བའི་འབྲུ་རིགས་ཐམས་ཅད་གྲོང་ཁྱེར་གྱི་འབྲུ་མཛོད་ཁང་དུ་བཅུག༌གོ །གྲོང་ཁྱེར་སོ་སོའི་ཉེ་འཁོར་གྱི་འབྲུ་རིགས་ཐམས་ཅད་གྲོང་ཁྱེར་ནང་དུ༌བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ཡོ་སེབ་ཀྱིས་འབྲུ་རིགས་སྣ་ལྔ་བསགས་པ་ནི་རྒྱ་མཚོའི་འགྲམ་གྱི་བྱེ་མ་དང་མཚུངས་པར་གྲངས་ཀྱིས་མི་ཟིན༌ཏོ། །ཅིའི་ཕྱིར་ཞེ༌ན། འབྲུ་རིགས་ཤིན་ཏུ་མང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","དེ་ཡང་མུ་གེ་མ་བྱུང་བའི་ཡར་སྔོན༌དུ། ཨོ་ནཱ་ཡུལ་གྱི་མཆོད་དཔོན་ཕའོ་ཏི་ཕེ་རཱ་ཞེས་པའི་བུ་མོ་ཨ་སི་ནཱ་ཐི་ཡིས་ཡོ་སེབ་ལ་བུ་གཉིས་བཙས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ཡོ་སེབ་ཀྱིས་བུ་སྐྱེས་འགོའི་མིང་ལ་མཱ་ན་ཤེ་ཞེས༌བཏགས། ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་ལ་དཀའ་ངལ་སྣ་ཚོགས་དང་བདག་གི་ཕ་ཡི་ཁྱིམ་མི་ཐམས་ཅད་བརྗེད་པར་མཛད་པ་ཡིན་ཞེས་སྨྲས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ཡང་བུ་ཆུང་བའི་མིང་ལ་ཨེ་ཕཱར་ཡིམ་ཞེས༌བཏགས། ཅིའི་ཕྱིར་ཞེ༌ན། ཁོ་ན༌རེ། དཀོན་མཆོག་གིས་བདག་ནི་དཀའ་སྡུག་མྱང་བའི་ཡུལ་དུ་དར་ཞིང་རྒྱས་པར་མཛད་པ་ཡིན་ཞེས་སྨྲས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","དེ་ཡང་ཨེ་ཅིབ་ཡུལ་དུ་ལོ་ལེགས་བྱུང་བའི་ལོ་བདུན་པོ་མཇུག་རྫོགས༌རྗེས། ");
INSERT INTO bodn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ཡོ་སེབ་ཀྱིས་སྨྲས་པ་བཞིན་མུ་གེ་འབྱུང་བའི་ལོ་བདུན་དེ་སླེབས༌སོ། །དེ་ནས་ཡུལ་གཞན་ཐམས་ཅད་ལ་མུ་གེ་བྱུང་ནའང་ཨེ་ཅིབ་ཀྱི་ཡུལ་ཁོ་ནར་འབྲུ་རིགས་མཆིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ཨེ་ཅིབ་ཀྱི་ཡུལ་ལའང་མུ་གེ་བྱུང་བས་འབངས་མི་རྣམས་ཀྱིས་ཕཱར་ཨོལ་ལ་འབྲུ་རིགས་བསླངས་པ༌ན། རྒྱལ་པོ་ན༌རེ། ཁྱོད་ཅག་ཡོ་སེབ་ཀྱི་དྲུང་དུ་སོང༌ཞིག ཁོས་ཇི་ལྟར་སྨྲས་པ་ཡིན་ན་ཁྱོད་ཅག་གིས་དེ་ལྟར་སྒྲུབས་ཤིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","སྐབས༌དེར། གནམ་འོག་ཀུན་ལ་མུ་གེ་བྱུང་བ༌དང༌། ཨེ་ཅིབ་ཡུལ་ཀུན་ལའང་མུ་གེ་ཆེན་པོ་བྱུང་བས་ཡོ་སེབ་ཀྱིས་ཡུལ་སོ་སོའི་འབྲུ་མཛོད་ཕྱེས་ཏེ། ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ལ་འབྲུ་རིགས་བཙོངས་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ཡུལ་སོ་སོའི་མི་རྣམས་ཨེ་ཅིབ་ཀྱི་ཡུལ་དུ་སོང་ཞིང་ཡོ་སེབ་ཀྱི་དྲུང་ནས་འབྲུ་རིགས་ཉོས་པ༌སྟེ། གནམ་འོག་ཀུན་ལ་མུ་གེ་ཆེན་པོ་བྱུང་བས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","དེ་ཡང་ཡ་ཀོབ་ཀྱིས་ཨེ་ཅིབ་ཡུལ་དུ་འབྲུ་རིགས་ཡོད་པ་ཤེས་ཏེ་རང་གི་བུ་རྣམས་ལ་འདི་སྐད༌དུ། ཁྱོད་ཅག་གིས་ཅིའི་ཕྱིར་ཕན་ཚུན་ལ༌ལྟའམ། ");
INSERT INTO bodn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","བདག་གིས་ཨེ་ཅིབ་ཡུལ་དུ་འབྲུ་རིགས་ཡོད་པ་ཐོས༌བྱུང༌། རང་ཅག་རྣམས་འཚོ་ཞིང་གཞེས་པ་དང་མི་འཆི་བའི༌ཕྱིར། ཁྱོད་རྣམས་ཀྱང་ཨེ་ཅིབ་ཡུལ་དུ་སོང་ནས་འབྲུ་རིགས་ཉོས་ན་ལེགས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","དེ་ནས་ཡོ་སེབ་ཀྱི་གཅེན་པོ་བཅུ་པོའང་མར་ཨེ་ཅིབ་ཡུལ་དུ་འབྲུ་རིགས་ཉོ་རུ་སོང༌མོད། ");
INSERT INTO bodn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","འོན༌ཀྱང༌། ཡོ་སེབ་ཀྱི་གཅུང་པོ་པེན་ཡཱ་མེན་ནི་ཁོའི་གཅེན་པོ་རྣམས་དང་མཉམ་དུ་མ་མངགས༌ཏེ། ཡ་ཀོབ་ན༌རེ། ཁོ་ལ་བར་ཆད་འབྱུང་སྲིད་ཅེས་སྨྲས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","དེ་ཡང་ཀ་ན་ཨན་ཡུལ་ལའང་མུ་གེ་བྱུང་བས་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བའི་མི་རྣམས་ཀྱི་ཁྲོད་དུ་ཡེས་ར་ཨེལ་ཞེས་བྱ་བ་སྟེ་ཡ་ཀོབ་ཀྱི་བུ་རྣམས་ཀྱང་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","དུས་དེར་ཨེ་ཅིབ་ཀྱི་ཡུལ་ཐམས་ཅད་སྐྱོང་མཁན་ནི་ཡོ་སེབ་ཡིན༌ལ། ཡུལ་སོ་སོའི་མི་རྣམས་ལ་འབྲུ་རིགས་འཚོང་མཁན་ཡང་ཡོ་སེབ༌ཡིན། ཡོ་སེབ་ཀྱི་གཅེན་པོ་རྣམས་ཀྱང་ཡོང་སྟེ་པུས་མོ་སར་བཙུགས་ནས་ཁོང་ལ་ཕྱག་བཙལ་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ཡོ་སེབ་ཀྱིས་རང་གི་གཅེན་པོ་རྣམས་མཐོང་བ་དང་ངོ་ཤེས་ནའང་མ་ཤེས་ཁུལ་གྱིས་ཁྱོད་ཅག་གང་ནས་ཡོང་བ་ཡིན་ཞེས་བཙན་གྱིས་དྲིས་པ༌ན། ཁོ་རྣམས་ན༌རེ། ངེད་ཅག་ཀ་ན་ཨན་ཡུལ་ནས་གནས་འདིར་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ཡོ་སེབ་ཀྱིས་རང་གི་གཅེན་པོ་རྣམས་ངོ་ཤེས་ནའང་ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་མ་ཤེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","དེ་ནས་ཡོ་སེབ་ཀྱིས་སྔོན་ཆད་རྨི་ལམ་གཉིས་རྨིས་མྱོང་བ་ཡིད་ལ་དྲན༌ཏེ། ཁྱོད་རྣམས་མྱུལ་མ༌ཡིན། སྲུང་དམག་མེད་པའི་ཡུལ་འདིར་ལྐོག་ལྟ་བྱེད་དུ་ཡོང་བ་རེད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ཁོ་རྣམས་ན༌རེ། ཇོ་བོ་ལགས། དེ་འདྲ་མིན༌ཏེ། ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་རྣམས་ནི་གནས་འདིར་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ངེད་ཅག་ནི་ཕ་གཅིག་གི་བུ་ཡིན༌ལ། མི་དྲང་པོ་ཡིན་པ་ལས་མྱུལ་མ་མིན་ཞེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ཡོ་སེབ་ན༌རེ། དེ་འདྲ་ག་ལ༌ཡིན། ཁྱོད་རྣམས་སྲུང་དམག་མེད་པའི་ཡུལ་འདིར་ལྐོག་ལྟ་བྱེད་དུ་ཡོང་བ་ཤ་སྟག་རེད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ཁོ་རྣམས་ན༌རེ། ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་ཅག་ལ་སྤུན་བཅུ་གཉིས་ཡོད་ཅིང་ཀ་ན་ཨན་ཡུལ་གྱི་ཕ་གཅིག་གི་བུ་རྣམས་ཡིན༌ལ། སྤུན་རྣམས་ལས་ཆེས་ཆུང་བ་ད་ལྟ་ཕ་ཡི་དྲུང་དུ་ཡོད་པ༌དང༌། སྤུན་གཞན་ཞིག་ཚེ་ལས་འདས་སོང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","དེ་ནས་ཡོ་སེབ་ན༌རེ། བདག་གིས་ཁྱོད་རྣམས་མྱུལ་མ་རེད་ཅེས་སྨྲས་པ་དོན་ལ༌གནས། ");
INSERT INTO bodn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","བདག་གིས་ཕཱར་ཨོལ་དཔང་དུ་བཙུགས་ནས་དམ་བཅའ་བར་བྱ༌སྟེ། གལ༌སྲིད། ཁྱོད་རྣམས་ཀྱི་སྤུན་ཆེས་ཆུང་བ་གནས་འདིར་ཡོང་བ་མིན༌ན། ཁྱོད་རྣམས་ཀྱང་གནས་འདི་ནས་ཕྱིར་འགྲོ་མི་ཐུབ༌ལ། དེ་ལས་ཁྱོད་རྣམས་ག་འདྲ་ཡིན་པའང་ར་སྤྲོད་བྱེད་ཐུབ་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ཁྱོད་རྣམས་ལས་སྤུན་གཅིག་མངགས་ནས་སྤུན་ཆེས་ཆུང་བའང་འདིར་ཁྲིད་ཤོག༌ཅིག ཁྱོད་ཅག་གིས་སྨྲས་པའི་གཏམ་བདེན་མིན་ལ་བརྟག་པའི༌ཕྱིར། ཁྱོད་རྣམས་འདིར་བཙོན་དུ་འདུག་དགོས་པ༌ཡིན། གལ་ཏེ་ཁྱོད་ཅག་གིས་སྨྲས་པའི་གཏམ་དེ་བདེན་པ་མིན༌ན། བདག་གིས་ཕཱར་ཨོལ་དཔང་དུ་བཙུགས་ནས་དམ་བཅའ༌སྟེ། ཁྱོད་རྣམས་མྱུལ་མ་ཤ་སྟག་རེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","དེ་ནས་ཡོ་སེབ་ཀྱིས་རང་གི་སྤུན་གཞན་རྣམས་ཉིན་གསུམ་ལ་བཙོན་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","དེ་ནས་ཉིན་གསུམ་པར་ཡོ་སེབ་ཀྱིས་སྤུན་རྣམས་ལ་འདི༌ལྟར། བདག་ནི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པ་ཞིག་ཡིན༌ཞིང༌། ཁྱོད་ཅག་གིས་དེ་བཞིན་བྱས་ན་རང་སྲོག་འཆོར་མི༌སྲིད། ");
INSERT INTO bodn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ཁྱོད་ཅག་མི་དྲང་པོ་ཡིན༌ན། ཁྱོད་རྣམས་ལས་སྤུན་གཅིག་བཙོན་དུ་བསྡད་དེ། སྤུན་གཞན་རྣམས་ཀྱིས་འབྲུ་རིགས་ཁུར་ནས་རང་ཁྱིམ་གྱི་བཀྲེས་ལྟོགས་སེལ་བར་འགྲོ་རུང་བ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","འོན༌ཀྱང༌། ཁྱོད་རྣམས་ཀྱིས་རང་གི་སྤུན་ཆེས་ཆུང་བ་དེ་འདིར་ཁྲིད་ཤོག༌ཅིག དེ་ལྟར་བྱས༌ན། ཁྱོད་ཅག་གིས་སྨྲས་པའི་གཏམ་ལ་བདེན་དཔང་བྱེད་ཐུབ༌ཅིང༌། ཁྱོད་རྣམས་ཀྱང་འཆི་མི་སྲིད་ཅེས་སྨྲས་པ༌དང༌། སྤུན་དེ་རྣམས་ཀྱིས་ཀྱང་དེ་ལྟར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","དེ་ནས་སྤུན་རྣམས་ཀྱིས་ཕན་ཚུན་ན༌རེ། རང་ཅག་ནི་སྤུན་གྱི་ཆ་ནས་ཉེས་པ་ཡོད༌དེ། ཁོས་སྨྲེ་སྔགས་བཏོན་ནས་རང་ཅག་ལ་ཞུ་བ་བྱེད་པའི་སྐབས༌སུ། ངེད་རྣམས་ཀྱིས་ཁོའི་སེམས་སྐྱོ་སྡུག་གིས་ཁེངས་པ་མཐོང༌ཡང༌། ཁོས་ཞུ་བར་མ་མཉན་པས་ད་ནི་སྡུག་བསྔལ་འདི་ལྟ་བུ་རང་ཅག་རྣམས་ལ་བྱུང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","དེར་རུ་བེན་ན༌རེ། བདག་གིས་ཁྱོད་རྣམས་ལ་བྱིས་པ་དེར་སྡིག་པ་བྱེད་མི་རུང་ཞེས་སྨྲས་མྱོང་བ་མ་ཡིན༌ནམ། ཁྱོད་རྣམས་ཀྱིས་བདག་གི་གཏམ་ལ་མ་མཉན༌པས། ཁོ་རང་ལ་ཁྲག་བཞུར་དུ་བཅུག་པའི་སྡིག་པ་ནི་ད་ལྟ་རང་ཅག་རྣམས་ཀྱིས་འཇལ་དགོས་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ཁོ་རྣམས་ཀྱི་སེམས་སུ་ཁོ་ཚོས་སྨྲས་པའི་གཏམ་དེ་དག་ཡོ་སེབ་ཀྱིས་མ་ཐོས་པར༌སྙམ། རྒྱུ་མཚན་ནི་ཡོ་སེབ་དང་ཁོ་རྣམས་བར་དུ་སྐད་སྒྱུར་བ་ཞིག་ཡོད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","དེ་ནས་ཡོ་སེབ་ཕར་སོང་ནས་ངུས༌ཤིང༌། ཡང་ཕྱིར་ཡོང་ནས་རང་གི་སྤུན་རྣམས་ལ་གླེང་མོལ་བྱས་པ༌དང༌། སྤུན་དེ་རྣམས་ཀྱི་ཁྲོད་ནས་སི་མུ་ཨོན་ཞེས་པ་བདམས་ཏེ་ཁོ་རྣམས་ཀྱི་མིག་མདུན་ནས་བཀྱིགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ཡོ་སེབ་ཀྱིས་མི་མངགས་ནས་རང་གི་སྤུན་རྣམས་ཀྱི་སྒྱེ་མོའི་ནང་དུ་འབྲུ་རིགས་ཀྱིས་གཏམས་པར་མཛད༌ཅིང༌། ཁོ་རྣམས་ཀྱི་དངུལ་སྒོར་ཡང་ཕྱིར་ཁོ་རྣམས་ཀྱི་སྒྱེ་མོའི་ནང་དུ་འཇུག་པ༌དང༌། ཁོ་རྣམས་ལ་ལམ་བྲོའང་སྟེར་དགོས་པའི་བཀའ་ཕབ་པ་དང་དེ་ལྟར་བསྒྲུབས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ཁོ་རྣམས་ཀྱིས་ཀྱང་འབྲུ་རིགས་བོང་བུར་བཀལ་ནས་ཡུལ་དེ་དང་ཁ་བྲལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","དེ་ནས་ཁོ་རྣམས་ལམ་ལ་ཆས་ཤིང་ལམ་བར་ནས་ཞག་སྡོད་བྱེད་སར་སླེབས༌དུས། ཁོ་རྣམས་ལས་སྤུན་ཞིག་གིས་བོང་བུར་གཟན་ཆས་སྟེར་སྙམ་ནས་སྒྱེ་མོའི་ཁ་ཕྱེས་པ་ན། རང་གི་དངུལ་སྒོར་དེ་སྒྱེ་མོའི་ནང་དུ་ཡོད་པ་མཐོང༌སྟེ། ");
INSERT INTO bodn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","སྤུན་གཞན་རྣམས་ལ་འདི༌ལྟར། བདག་གི་དངུལ་སྒོར་ཕྱིར་ཡོང༌ངོ༌། །ལྟོས༌དང༌། བདག་གི་སྒྱེ་མོའི་ནང་དུ་འདུག་ཅེས་སྨྲས་པ༌དང༌། ཁོ་རྣམས་ཤིན་ཏུ་འཇིགས་ཤིང་སྐྲག༌སྟེ། འདི་ནི་དཀོན་མཆོག་གིས་རང་ཅག་ལ་ཅི་ཞིག་མཛད་པ་ཡིན་ནམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","དེ་ནས་ཁོ་རྣམས་ཀ་ན་ཨན་ཡུལ་གྱི་ཡབ་ཡ་ཀོབ་ཀྱི་གམ་དུ་སླེབས་པ༌དང༌། ཁོ་རྣམས་ལ་བྱུང་བའི་དོན་རྣམས་འདི་ལྟར་སྨྲས༌པ། ");
INSERT INTO bodn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ཡུལ་དེའི་བདག་པོས་ངེད་ཅག་ལ་བཙན་གཏམ་སྨྲས་པ༌དང༌། ངེད་ཅག་ཡུལ་དེར་གསང་མྱུལ་དུ་ཡོང་བར་འདོད༌ཅིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ངེད་རྣམས་ཀྱིས་བདག་པོ་དེ༌ལ། ངེད་ཅག་མི་དྲང་པོ་ཡིན་པ་ལས་མྱུལ་མ༌མིན། ");
INSERT INTO bodn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ངེད་རྣམས་ལ་སྤུན་བཅུ་གཉིས་ཡོད་ཅིང་ཐམས་ཅད་ཕ་གཅིག་གི་བུ་རྣམས་ཡིན༌ལ། སྤུན་གཅིག་ཚེ་ལས་འདས་པ༌དང༌། སྤུན་ཆེས་ཆུང་བ་ད་ལྟ་ཕ་དང་མཉམ་དུ་ཀ་ན་ཨན་ཡུལ་དུ་ཡོད་ཅེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ཡུལ་དེའི་བདག་པོ་ན༌རེ། བདག་གིས་ཁྱོད་རྣམས་མི་དྲང་པོ་ཡིན་པ་ཤེས་དགོས༌ན། ཁྱོད་ཅག་རྣམས་ལས་གཅིག་བདག་གི་ཡུལ་འདིར་སྡོད༌དང༌། གཞན་རྣམས་ཀྱིས་འབྲུ་རིགས་ཁུར་ནས་རང་ཁྱིམ་གྱི་བཀྲེས་ལྟོགས་སེལ་བར་སོང༌ཞིག ");
INSERT INTO bodn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","འོན༌ཀྱང༌། ཁྱོད་རྣམས་ཀྱིས་རང་གི་སྤུན་ཆེས་ཆུང་བ་དེ་འདིར་ཁྲིད་ཤོག༌དང༌། བདག་གིས་ཁྱོད་རྣམས་མྱུལ་མ་མིན་པར་མི་དྲང་པོ་ཡིན་པ་ཤེས་ནུས་པ༌ཡིན། དེ་ལྟར་བྱས༌ན། བདག་གིས་ཁྱོད་ཅག་གི་སྤུན་ཕྱིར་ཁྱོད་རྣམས་ལ་སྤྲོད་པ༌དང༌། ཁྱོད་རྣམས་ཀྱིས་ཀྱང་ཡུལ་འདི་ནས་ཚོང་ལས་གཉེར་ཆོག་པ་ཡིན་སྨྲས་ཞེས༌བཤད་དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","དེ་ཡང་ཕྱིས་སུ་ཁོ་རྣམས་ཀྱིས་རང་རང་གི་སྒྱེ་མོའི་ཁ་ཕྱེས་པ་ན། མི་རེ་རེའི་དངུལ་ཁུག་སྒྱེ་མོའི་ནང་དུ་ཡོད་པ༌དང༌། ཡབ་དང་ཁོ་རྣམས་ཀྱིས་དངུལ་ཁུག་མཐོང་བ་དང་འཇིགས་སྐྲག་སྐྱེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","དེ་ནས་ཡབ་ཡ་ཀོབ་ཀྱིས་བུ་རྣམས་ལ་འདི་སྐད༌དུ། ཁྱོད་ཅག་གིས་བདག་གི་བུ་གཉིས་མེད་པར་བྱས༌ཏེ། ཡོ་སེབ་མེད༌ལ། སི་མུ་ཨོན་ཡང་མེད༌དོ། །ཁྱོད་རྣམས་ཀྱིས་ད་དུང་བདག་གི་བུ་པེན་ཡཱ་མེན་ཡང་ཁྲིད་འདོད་པ༌རེད། ད་ལྟ་སྡུག་བསྔལ་འདི་ཐམས་ཅད་བདག་གི་མགོ་ལ་ཡོང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","དེ་ནས་རུ་བེན་གྱིས་ཡབ་ལ་འདི༌ལྟར། སྤུན་པེན་ཡཱ་མེན་བདག་ལ་སྤྲོད༌དང༌། བདག་གིས་ཁྱེད་ལ་ཕྱིར་སྤྲོད་ངེས༌ཡིན། གལ་ཏེ་བདག་གིས་སྤུན་པེན་ཡཱ་མེན་ཕྱིར་ཁྲིད་མ་ཡོང༌ན། ཁྱེད་ཀྱིས་བདག་གི་བུ་གཉིས་ཀ་བསད་ཆོག་ཅེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ཡ་ཀོབ་ན༌རེ། པེན་ཡཱ་མེན་ཁྱོད་རྣམས་དང་མཉམ་དུ་འགྲོ་མི༌ཆོག ཁོའི་གཅེན་པོ་ཚེ་ལས་འདས་ཤིང་ད་ལྟ་ཁོ་རང་ཁོ་ན་ལུས་འདུག་པ༌དང༌། ཁོ་རང་ཁྱོད་རྣམས་དང་མཉམ་དུ་འགྲོ་བའི་ལམ་བར་དུ་བར་ཆད་བྱུང༌ཚེ། ཁྱོད་རྣམས་ཀྱིས་སྐྲ་དཀར་པོར་གྱུར་པའི་རྒན་པོ་བདག་སྡུག་བསྔལ་གྱི་ངང་ནས་གཤིན་པོའི་གནས་སུ་བསྐྱལ་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","དེ་ཡང་ཡུལ་དེར་མུ་གེ་བྱུང་བ་ཚབས་ཆེ༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ཁོ་རྣམས་ཀྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཁྱེར་ཡོང་བའི་འབྲུ་རིགས་ཐམས་ཅད་ཟོས་ཚར་བ༌དང༌། ཡང་ཁོ་རྣམས་ཀྱི་ཕ་ན༌རེ། ཁྱོད་རྣམས་ཡང་འབྲུ་རིགས་ཉོ་རུ་སོང་ཞིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","དེ་ནས་ཡ་ཧུ་དཱ་ན༌རེ། དེ་སྔར་མི་དེས་ངེད་ཅག་ལ་ནན་གྱིས་འདི་སྐད༌དུ། ཁྱོད་ཅག་གི་སྤུན་ཁྱོད་ཅག་དང་མཉམ་དུ་མ་ཡོང༌ན། བདག་དང་ངོ་འཕྲད་པར་ཡོང་མི་དགོས་ཞེས་སྨྲས་མྱོང༌བས། ");
INSERT INTO bodn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ཡབ་ཁྱེད་ཀྱིས་སྤུན་པེན་ཡཱ་མེན་ངེད་ཅག་དང་ལྷན་དུ་འགྲོ་བར་མཛད༌ན། ངེད་ཅག་མར་འབྲུ་རིགས་ཉོ་རུ༌འགྲོ། ");
INSERT INTO bodn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ཁྱེད་ཀྱིས་སྤུན་པེན་ཡཱ་མེན་ངེད་ཅག་དང་མཉམ་དུ་འགྲོ་རུ་མི་འཇུག་ན། ངེད་ཅག་ཀྱང་འགྲོ་བར་མི༌བྱ། ཅིའི་ཕྱིར་ཞེ༌ན། དེ་སྔར་མི་དེས་ངེད་ཅག་ལ་ཁྱོད་ཅག་གི་སྤུན་ཁྱོད་ཅག་དང་མཉམ་དུ་མ་ཡོང་ན་བདག་དང་ངོ་འཕྲད་པར་མི་བྱ་ཞེས་ནན་གྱིས་སྨྲས་མྱོང་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","དེར་ཡེས་ར་ཨེལ་ན༌རེ། ཁྱོད་རྣམས་ཀྱིས་མི་དེར་ངེད་ཅག་ལ་ད་དུང་སྤུན་ཞིག་ཡོད་ཅེས་སྨྲས་ཏེ་བདག་ལ་འདི་ལྟར་གནོད་འཚེ་བྱེད་དོན་ཅི་ཞེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","བུ་རྣམས་ན༌རེ། མི་དེས་ངེད་ཅག་དང་ངེད་ཅག་གི་ཉེ་རིང་སོགས་ཞིབ་ཏུ་འདི༌ལྟར། ཁྱོད་ཅག་གི་ཕ་ནི་བཞུགས་ལགས༌སམ། ཁྱོད་རྣམས་ལ་ད་དུང་སྤུན་གཞན་ཡོད་དམ་ཞེས་དྲིས་པ༌ན། ངེད་ཅག་གིས་ཀྱང་ཁོའི་དྲི་བ་ལྟར་ལན་བཏབ་པ༌ཡིན། ཁོས་ཁྱོད་ཅག་གི་སྤུན་ཁྲིད་ཤོག་ཅིག་ཅེས་སྨྲ་ངེས་པ་ངེད་ཅག་གིས་ཤེས་ནུས་སམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","དེ་ནས་ཡ་ཧུ་དཱ་ཡིས་ཕ་ལ་འདི༌ལྟར། རང་ཅག་ཚང་གི་མི་ཐམས་ཅད་འཚོ་ཞིང་གཞེས་པ་དང་མི་འཆི་བའི༌ཕྱིར། ཁྱེད་ཀྱིས་སྤུན་ཆུང་བདག་དང་ལྷན་དུ་འགྲོ་རུ་ཆུག༌དང༌། ངེད་ཅག་འབྲུ་རིགས་ཉོ་རུ༌འགྲོ། ");
INSERT INTO bodn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","བདག་གིས་སྤུན་གྱི་བདེ་འཇགས་ལ་ཁག་ཐེག་བྱེད་ཅིང་རང་ཉིད་གཏའ་མར་འཇོག༌གོ །གལ་ཏེ་བདག་གིས་སྤུན་ཕྱིར་ཁྱེད་ཀྱི་དྲུང་དུ་ཁྲིད་མ་ཡོང༌ན། བདག་གིས་ནམ་ཡང་སྡིག་པ་འཁུར་ངེས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","གལ་སྲིད་དུས་འགྱངས་བྱས་པ་མིན༌ན། ད་ལྟ་ངེད་ཅག་ཐེངས་གཉིས་ཙམ་ལའང་ཕྱིར་ཡོང་ཟིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","དེ་ནས་ཁོ་རྣམས་ཀྱི་ཕ་ཡེས་ར་ཨེལ་ན༌རེ། དངོས་གནས་དེ་ལྟར་བྱེད་དགོས༌ན། ཁྱོད་ཅག་གིས་དེ་བཞིན་བྱོས༌ཤིག རང་ཅག་གི་ཡུལ་འདིའི་ཕུལ་དུ་བྱུང་བའི་སྤོས་དཀར་དང༌། སྦྲང༌རྩི། བསུང་རྫས། གུ༌གུལ། ཚི་གུའི༌རིགས། སྟར་ཀ་བཅས་རེ་རེ་བཞིན་ཉུང་ངུ་རེ་བླངས་ནས་སྣོད་ཀྱི་ནང་དུ་བཞག༌སྟེ། མར་ཨེ་ཅིབ་ཡུལ་གྱི་མི་དེ་ལ་ལེགས་སྐྱེས་སུ་ཁྱེར༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","གཞན་ཡང་ལག་ཏུ་དངུལ་སྒོར་ལྡབ་གཉིས་མང་དུ་འཛིན་པ༌དང༌། དེ་སྔར་སྒྱེ་མོའི་ནང་དུ་ཡོད་པའི་དངུལ་སྒོར་ཡང་ལག་ཏུ་འཛིན༌དགོས། དེ་ནི་ནོར་འཕྱུག་བྱུང་ནས་སྒྱེ་མོའི་ནང་དུ་བཅུག་པ་ཡིན་ཡང༌སྲིད། ");
INSERT INTO bodn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ཁྱོད་ཅག་གི་སྤུན་ཁྲིད་ནས་མི་དེའི་དྲུང་དུ་སོང༌ཞིག ");
INSERT INTO bodn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ཁྱོད་ཅག་གི་སྤུན་སི་མུ་ཨོན་དང་པེན་ཡཱ་མེན་གཉིས་ཀ་ཕྱིར་སྤྲོད་པའི་ཆེད༌དུ། ཀུན་དབང་དཀོན་མཆོག་གིས་མི་དེའི་མདུན་དུ་ཁྱོད་ཅག་ལ་སྙིང་རྗེས་གཟིགས་པར༌མཁྱེན། གལ་ཏེ་བདག་གི་བུ་གཉིས་ཀ་འཆི་བར་གྱུར་ན་འཆི་རུ་བཅུག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","དེ་ནས་ཁོ་རྣམས་ཀྱིས་ལེགས་སྐྱེས་དང་དངུལ་སྒོར་ལྡབ་གཉིས་བཟུང་ཞིང་པེན་ཡཱ་མེན་ཁྲིད་ནས་ཨེ་ཅིབ་ཡུལ་གྱི་ཡོ་སེབ་དྲུང་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","དེ་ཡང་ཡོ་སེབ་ཀྱིས་པེན་ཡཱ་མེན་ཁོ་རྣམས་དང་མཉམ་དུ་ཡོང་བ་མཐོང་སྟེ་རང་གི་ཁྱིམ་ལས་གཉེར་མཁན་ལ་འདི༌ལྟར། མི་འདི་རྣམས་ཁང་པའི་ནང་དུ་ཁྲིད༌ཅིག ཕྱུགས་ཤ་ཤེད་ཅན་ཞིག་བཤས་ནས་སྤྲོ་སྟོན་ལ་སྟ་གོན་བྱེད་པར༌གྱིས། ཅིའི་ཕྱིར་ཞེ༌ན། བདག་གིས་མི་འདི་རྣམས་དང་མཉམ་དུ་གུང་ཚིགས་འཐུང་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ཁྱིམ་ལས་གཉེར་མཁན་གྱིས་ཀྱང་ཡོ་སེབ་ཀྱི་བཀའ་ལྟར་ཁོ་རྣམས་ཡོ་སེབ་ཀྱི་ཁང་པའི་ནང་དུ༌ཁྲིད། ");
INSERT INTO bodn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","དེ་ཡང་ཡོ་སེབ་ཀྱི་ཁང་པའི་ནང་དུ་ཁྲིད་པས་ཁོ་རྣམས་འཇིགས་ཏེ་འདི༌ལྟར། ངེད་ཅག་འདིར་ཁྲིད་ཡོང་བ་ནི་ཐེངས་དང་པོར་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བའི་དུས༌སུ། སྒྱེ་མོའི་ནང་དུ་དངུལ་སྒོར་བཞག་ཡོད་པའི་ཕྱིར་ཡིན་ངེས༌ཤིང༌། བསམ་བཞིན་ངེད་ཅག་ལ་བསྙོན་བཙུགས་ཏེ་གནོད་འཚེ་བྱེད་པ༌དང༌། བཙན་གྱིས་ངེད་རྣམས་བྲན་གཡོག་ཏུ་འགོད༌པ། ངེད་ཅག་གི་བོང་བུའང་འཕྲོག་པར་རྩོམ་པ་རེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","དེ་ནས་ཁོ་རྣམས་ཡོ་སེབ་ཀྱི་ཁྱིམ་ལས་གཉེར་མཁན་གྱི་གམ་དུ་བཅར་ཏེ་ཁང་པའི་སྒོ་འགྲམ་དུ་འདི༌ལྟར། ");
INSERT INTO bodn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","བདག་པོ༌ལགས། ངེད་ཅག་ཐེངས་དང་པོར་དངོས་གནས་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ཕྱིས་སུ་ལམ་བར་ནས་ཞག་སྡོད་བྱེད་སར་སྒྱེ་མོའི་ཁ་ཕྱེས་པ་ན། མི་རེ་རེའི་དངུལ་སྒོར་མང་ཉུང་མེད་པར་ད་དུང་སྒྱེ་མོའི་ནང་དུ་ཡོད༌ལ། ད་ལྟ་ངེད་ཅག་གིས་ཕྱིར་ཁྱེར་ཡོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ཐེངས་འདིར་ཡང་དངུལ་སྒོར་བཟུང་ནས་འབྲུ་རིགས་ཉོ་རུ་ཡོང་བ༌ཡིན། འོན་ཀྱང་ཐེངས་སྔ་མར་ངེད་ཅག་གི་སྒྱེ་མོའི་ནང་དུ་དངུལ་སྒོར་འཇོག་མཁན་སུ་ཡིན་མི་ཤེས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ཁྱིམ་ལས་གཉེར་མཁན་ན༌རེ། ཁྱོད་ཅག་གི་སེམས་བདེ་བར༌གྱིས། འཇིགས་མི༌དགོས། དེ་ནི་ཁྱོད་ཅག་དང་ཁྱོད་རྣམས་ཀྱི་ཕ་ཡི་དཀོན་མཆོག་གིས་རྒྱུ་ནོར་དེ་དག་སྒྱེ་མོའི་ནང་དུ་བཞག་པ༌ཡིན། ཁྱོད་ཅག་གི་དངུལ་སྒོར་བདག་གིས་སྔ་མོ་ནས་བླངས་ཟིན་ཞེས་སྨྲས་པ༌དང༌། སི་མུ་ཨོན་ཁྲིད་ཡོང་ནས་ཁོ་རྣམས་ལ༌སྤྲད། ");
INSERT INTO bodn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","དེ་ནས་ཁོ་རྣམས་ཁང་པའི་ནང་དུ་ཁྲིད་པ་དང་རྐང་པ་བཀྲུ་བྱེད་ཀྱི་ཆུ་བླུགས༌ཤིང༌། བོང་བུ་དག་ལ་རྩྭའང་བྱིན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ཁོ་རྣམས་ཀྱིས་ལེགས་སྐྱེས་གྲ་སྒྲིག་བྱེད་ཀྱིན་ཡོ་སེབ་གུང་ཚིགས་བཞེས་སུ་ཡོང་བར་སྒུག་པ༌སྟེ། ཡོ་སེབ་ཀྱིས་ཁོ་རྣམས་དང་མཉམ་དུ་གུང་ཚིགས་བཞེས་ངེས་པ་ཐོས་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","དེ་ནས་ཡོ་སེབ་ཁྱིམ་དུ་ལོག་པ༌ན། ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་ལ་ལེགས་སྐྱེས་ཕུལ་བ་དང་ཕྱག་བཙལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ཡོ་སེབ་ཀྱིས་ཀྱང་ཁོ་རྣམས་ལ་འཚམས་འདྲི་བྱས་ཤིང་ན༌རེ། ཁྱོད་རྣམས་ཀྱིས་བརྗོད་པའི་ཕ་ནི༌བདེའམ། ཁོང་ད་དུང་བཞུགས་ལགས་སམ་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ཁོ་རྣམས་ན༌རེ། ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་སྟེ་ངེད་ཅག་གི་ཕ་ནི་བདེ་བར་བཞུགས་པ་ཡིན་ཞེས་སྨྲས་པ་དང་གུས་པས་ཕྱག་བཙལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","དེ་ནས་ཡོ་སེབ་ཀྱིས་མགོ་ཡར་བཀྱགས་ནས་བལྟས་པ༌ན། རང་ཉིད་ཀྱི་མ་གཅིག་གི་སྤུན་པེན་ཡཱ་མེན་མཐོང་སྟེ་འདི༌ལྟར། ཁྱོད་རྣམས་ཀྱིས་དེ་སྔར་བདག་ལ་བརྗོད་པའི་སྤུན་ཆེས་ཆུང་བ་ཞེས་པ་ཁོ་རང་ཡིན་ནམ་ཞེས་དྲིས་པ༌དང༌། ཡང་ཁོ་ན༌རེ། བདག་གི༌བུ། དཀོན་མཆོག་གིས་ཁྱོད་ལ་ཐུགས་རྗེ་གནང་བར་སྨོན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","རང་གི་སྤུན་ལ་བཅངས་པའི་བརྩེ་དུང་ཀུན་ནས་གཡོས༌ཤིང༌། ཁོའི་སེམས་ཁོང་དུ་ངུ་འདོད་པའི་སྣང་བ་ཞིག་སྐྱེས༌ཏེ། མྱུར་དུ་རང་ཉིད་ཀྱི་གཟིམ་ཁང་དུ་སོང་ནས་རབ་ཏུ་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","དེ་ནས་ཁོས་ཁ་ངོ་བཀྲུས་ཤིང་སེམས་སྡུག་གི་བསམ་པ་ནན་གྱིས་གབ་ནས་ཕྱིར་ཐོན་ཏེ་གསོལ་སྟོན་བྱེད་པའི་བཀའ་བསྒོས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ཞབས་ཕྱི་པ་རྣམས་ཀྱིས་ཀྱང་ཡོ་སེབ་ལ་གསོལ་སྟོན་བཤམས༌ཤིང༌། ཁོ་རྣམས་ལའང་གསོལ་སྟོན་བཤམས་པ༌དང༌། ཡང་ཡོ་སེབ་དང་མཉམ་དུ་ཞལ་ཟས་ལ་རོལ་བའི་ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ལའང་གསོལ་སྟོན་བཤམས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཨེ་ཅིབ་ཀྱི་མི་རིགས་དང་ཨིབ་རི་པའི་མི་རིགས་གཉིས་ཀྱིས་ལྷན་དུ་ཟས་མི་བཟའ་བའི་ཕྱིར་ཡིན༌ཞིང༌། ཨེ་ཅིབ་མི་རིགས་ཀྱིས་དོན་དེ་ནི་སྐྱུག་བྲོ་བར་སྙམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","དེ་ནས་ཡོ་སེབ་ཀྱིས་རང་གི་མདུན་དུ་སྐྱེས་རིམ་ལྟར་སྤུན་ཟླ་རྣམས་གྲལ་བསྒྲིགས་ནས་འདུག་ཏུ་བཅུག་པ༌ན། སྤུན་ཟླ་རྣམས་ཀྱིས་ཕན་ཚུན་ལ་ལྟ་བཞིན་དོན་དེར་ངོ་མཚར་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ཡོ་སེབ་ཀྱིས་རང་གི་མདུན་ངོས་ཀྱི་ཟས་རིགས་སོ་སོར་བཀར་ནས་སྤུན་རྣམས་ལ་གནང་དགོས་པའི་བཀའ་ཕབ་པ༌དང༌། པེན་ཡཱ་མེན་ལ་སྤུན་གཞན་ལས་ལྡབ་ལྔ་ཡི་ལྷག་མ་ཐོབ༌ཅིང༌། ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་དང་ལྷན་དུ་ཆང་དང་སྤྲོ་སྟོན་ལ་རོལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","དེ་ནས་ཡོ་སེབ་ཀྱིས་ཁྱིམ་ལས་གཉེར་མཁན་ལ་འདི་སྐད༌དུ། མི་འདི་རྣམས་ཀྱི་སྒྱེ་མོའི་ནང་དུ་འབྲུ་རིགས་ཀྱིས་བཀང་བ་དང་བོང་བུས་ཐེག་ཚད་ཀྱི་ཁལ་འགེལ་བར༌གྱིས། ཡང་ཁོ་རྣམས་ཀྱི་དངུལ་སྒོར་རང་རང་གི་སྒྱེ་མོའི་ནང་དུ་འཇོག་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","བདག་གི་དངུལ་ཕོར་དང་སྤུན་ཆེས་ཆུང་བའི་དངུལ་སྒོར་རྣམས་ལྷན་དུ་ཁོའི་སྒྱེ་མོའི་ནང་དུ་འཇོག་པར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ཁྱིམ་ལས་གཉེར་མཁན་གྱིས་ཀྱང་ཡོ་སེབ་ཀྱི་བཀའ་ལྟར་བསྒྲུབས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","དེའི་ཕྱི་ཉིན་ནམ་ལངས་པ་དང་ཁོ་རྣམས་བོང་བུ་དང་བཅས་ལམ་དུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","དེ་ཡང་ཁོ་རྣམས་གྲོང་ཁྱེར་དང་ཁ་བྲལ་ནས་ཅུང་མ་འགོར༌བར། ཡོ་སེབ་ཀྱིས་ཁྱིམ་ལས་གཉེར་མཁན་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་མྱུར་དུ་ཁོ་རྣམས་ཀྱི་རྗེས་བསྙེག་པར༌གྱིས། ཁོ་རྣམས་ཀྱི་རྗེས་ཆོད་པ༌ན། ཁྱོད་ཅག་གིས་དྲིན་ལན་ངན་འཇལ་བྱེད་པ་ཅི༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","འདི་ནི་ངེད་ཅག་གི་བདག་པོའི་ཆང་ཕོར་མ་ཡིན༌ནམ། འདི་ནི་ངེད་ཅག་གི་བདག་པོའི་མོ་འདེབས་བྱེད་ཀྱི་ཕོར་བ་མ་ཡིན༌ནམ། ཁྱོད་ཅག་གིས་འདི་ལྟར་བྱས་ན་ཉེས་པ་བྱས་པ་མ་ཡིན་ནམ་ཞེས་སྨྲོས་ཤིག་ཅེས་བཤད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ཁྱིམ་ལས་གཉེར་མཁན་གྱིས་ཁོ་རྣམས་བདས་ཏེ་རྗེས་ཆོད་པ་དང་བདག་པོའི་བཀའ་ལྟར་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ཁོ་རྣམས་ན༌རེ། རང་ཅག་གི་བདག་པོས་འདི་ལྟར་སྨྲ་བའི་རྒྱུ་མཚན༌ཅི། ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་རྣམས་ཀྱིས་ལས་འདི་ལྟ་བུ་བྱེད་མི༌སྲིད། ");
INSERT INTO bodn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ལྟོས༌དང༌། དེ་སྔར་ངེད་ཅག་གིས་རང་གི་སྒྱེ་མོའི་ནང་དུ་དངུལ་སྒོར་ཡོད་པ་ཤེས་པ༌དང༌། ཀ་ན་ཨན་ཡུལ་ནས་ཕྱིར་ཁྱེར་ཡོང་ནས་ཁྱེད་ལ་སྤྲད་པ་མ་ཡིན༌ནམ། ངེད་ཅག་གིས་ཁྱེད་ཀྱི་བདག་པོའི་ཁྱིམ་ནས་གསེར་དངུལ་རྐུ་སྲིད༌དམ། ");
INSERT INTO bodn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ཁྱེད་ཀྱི་ཞབས་ཕྱི་པའི་ཁྲོད་ནས་སུ་ཞིག་ལས་བཙལ་ཏེ་རྙེད༌ན། མི་དེ་ནི་གསོད་པར༌བྱ། ངེད་རྣམས་ཀྱང་རང་ཅག་གི་བདག་པོའི་གཡོག་པོར་བྱེད་ངེས་ཡིན་ཞེས་ལན་བཏབ༌བོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ཁྱིམ་ལས་གཉེར་མཁན་ན༌རེ། ད་ལྟ་ཁྱོད་ཅག་གིས་སྨྲས་པ་བཞིན་བྱོས༌ཤིག མི་སུ་ཞིག་ལས་བཙལ་ནས་རྙེད་ན་དེ་ནི་བདག་གི་གཡོག་པོ་བྱེད༌དགོས། གཞན་རྣམས་ལ་ཉེས་པ་མེད་ཅེས་སྨྲས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ཁོ་རྣམས་ཀྱིས་མྱུར་དུ་རང་རང་གི་སྒྱེ་མོ་ས་རུ་བཞག་སྟེ་ཁ་ཕྱེས་པ་དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ཁྱིམ་ལས་གཉེར་མཁན་གྱིས་ཁོ་རྣམས་ལས་ལོ་ཆེ་བ་ནས་ལོ་ཆུང་བའི་བར་དུ་རིམ་བཞིན་བཙལ་བ༌ན། དངུལ་ཕོར་དེ་པེན་ཡཱ་མེན་གྱི་སྒྱེ་མོ་ལས་རྙེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","དེ་ནས་ཁོ་རྣམས་ཡིད་ཤིན་ཏུ་སྐྱོ་བའི་ངང་གྱོན་པ་བཤགས༌ཤིང༌། རང་རང་གི་སྒྱེ་མོ་བོང་བུར་བཀལ་ནས་ཕྱིར་གྲོང་ཁྱེར་དུ་ལོག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","དེ་ནས་ཡ་ཧུ་དཱ་དང་ཁོའི་སྤུན་རྣམས་ཡོ་སེབ་ཀྱི་ཁྱིམ་དུ་སོང་བ་དང་ཡོ་སེབ་ཀྱང་དེ་རུ་ཡོད༌པས། ཁོ་རྣམས་ཀྱིས་ཡོ་སེབ་ཀྱི་དྲུང་དུ་པུས་མོ་སར་བཙུགས་ནས་ཕྱག་བཙལ་བ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ཡོ་སེབ་ན༌རེ། ཁྱོད་རྣམས་ཀྱིས་དེ་ལྟར་བྱེད་དོན༌ཅི། བདག་ལྟ་བུས་མོ་འདེབས་ནུས་པ་ཁྱོད་ཅག་གིས་མི་ཤེས་སམ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ཡ་ཧུ་དཱ་ན༌རེ། ངེད་རྣམས་ཀྱིས་རང་ཅག་གི་བདག་པོར་ཅི་ཞིག༌སྨྲའམ། ངེད་ཅག་གིས་རང་ལ་ཉེས་སྐྱོན་མེད་ཚུལ་ཇི་ལྟར་བདེན་དཔང་བྱེད༌དམ། དཀོན་མཆོག་གིས་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་དག་གི་སྔོན་ཆད་ཀྱི་ཉེས་སྐྱོན་མཁྱེན༌ཞིང༌། ད་ལྟ་ངེད་ཅག་དང་ཕོར་བ་རྙེད་པའི་མི་དང་བཅས་པ་ཐམས་ཅད་རང་ཅག་གི་བདག་པོའི་གཡོག་པོ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ཡོ་སེབ་ན༌རེ། བདག་གིས་འདི་ལྟར་ཅི་ནས་ཀྱང་མི་བྱ༌སྟེ། སུ་ཞིག་ལས་ཕོར་བ་རྙེད་པ་ཡིན༌ན་མི་དེ་བདག་གི་གཡོག་པོར་བྱེད་དགོས་པ༌ལས། གཞན་རྣམས་བདེ་བའི་ངང་ཁྱོད་ཅག་གི་ཕ་ཡི་དྲུང་དུ་སོང་ཞིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ཡང་ཡ་ཧུ་དཱ་ནི་ཡོ་སེབ་ཀྱི་དྲུང་དུ་བཅར་ཏེ་འདི༌ལྟར། བདག་པོ༌ལགས། ཁྱེད་ཀྱིས་ཞབས་ཕྱི་པ་བདག་ལ་གསན་པར༌ཞུ། ཁྱེད་རང་ཐུགས་རྒྱལ་མི་བཞེངས་པར༌མཛོད། ཅིའི་ཕྱིར་ཞེ༌ན། ཁྱེད་ནི་ཕཱར་ཨོལ་དང་འདྲ་མཚུངས་ཡིན་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","བདག་པོ་ཁྱེད་ཀྱིས་དེ་སྔར་ཞབས་ཕྱི་པ་ངེད་རྣམས༌ལ། ཁྱོད་རྣམས་ཀྱི་ཕ་བཞུགས་ལགས༌སམ། སྤུན་གཞན་ནི་ཡོད་དམ་མེད་ཅེས་དྲིས་མྱོང༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ངེད་ཅག་གིས་བདག་པོ་ཁྱེད༌ལ། ངེད་རྣམས་ལ་ཕ་ཡོད་ཅིང་ཁོང་ནི་ལོ་ན་བགྲེས་པ༌དང༌། དགུང་ལོ་མཐོ་བའི་དུས་སུ་སྐྱེས་པའི་བུ་ཞིག་ཡོད༌ལ། ཁོའི་གཅེན་པོ་ཚེ་ལས་འདས༌ཤིང༌། ཁོའི་ཨ་མས་ཁོ་རང་ཁོ་ན་བསྐྱུར་བས་ཕ་ཡིས་བུ་དེ་ལ་ཤིན་ཏུ་གཅེས་པ་ཡིན་ཞེས་ལན་བཏབ་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ཡང་ཁྱེད་ན༌རེ། ཁོ་རང་འདིར་ཁྲིད་ཤོག༌ཅིག བདག་གིས་ཁོ་རང་དངོས་སུ་མཐོང་འདོད་ཅེས་སྨྲས་པ༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ཡང་ངེད་ཅག་གིས་འདི༌ལྟར། བུ་ཆུང་ཕ་དང་མཉམ་དུ་འདུག་དགོས༌ལ། གལ་ཏེ་བུ་ཆུང་ཕ་དང་ཁ་བྲལ༌ན། ཕ་ནི་ཚེ་ལས་འདའ་བར་འགྱུར་ཞེས་སྨྲས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ཡང་ཁྱེད་ན༌རེ། ཁྱོད་རྣམས་ཀྱི་སྤུན་ཆེས་ཆུང་བ་དེ་ཁྱོད་ཅག་དང་མཉམ་དུ་མ་ཡོང༌ན། ཁྱོད་རྣམས་བདག་དང་ངོ་འཕྲད་པར་ཡོང་མི་དགོས་ཞེས་སྨྲས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ངེད་རྣམས་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་སྟེ་བདག་ཅག་གི་ཕ་ཡི་དྲུང་དུ་སོང་ནས་ཁྱེད་ཀྱི་གཏམ་ཇི་བཞིན་ཁོང་ལ་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ངེད་ཅག་གི་ཕ་ན༌རེ། ཁྱོད་རྣམས་སླར་ཡང་འབྲུ་རིགས་ཉོ་རུ་སོང་ཞིག་ཅེས་སྨྲས༌བྱུང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ཡང་ངེད་ཅག་གིས་ཁོང་ལ་འདི༌ལྟར། ངེད་ཅག་འགྲོ་མི༌ནུས། གལ་ཏེ་སྤུན་ཆུང་བ་ངེད་ཅག་དང་མཉམ་དུ་འགྲོ་རུ་བཅུག༌ན། ངེད་ཅག་མར་ཨེ་ཅིབ་ཡུལ་དུ་འབྲུ་རིགས་ཉོ་རུ་འགྲོ༌སྟེ། སྤུན་ཆུང་བ་ངེད་ཅག་དང་མཉམ་དུ་མེད༌ན། ངེད་རྣམས་མི་དེ་དང་ངོ་འཕྲད་མི་ཐུབ་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་མྱོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","དེ་ནས་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་ཅག་གི་ཕ་ཡིས་ངེད་རྣམས་ལ་འདི༌ལྟར། བདག་གི་ཆུང་མས་བདག་ལ་བུ་གཉིས་བཙས་པ་ཁྱོད་རྣམས་ཀྱིས་ཤེས་ལ། ");
INSERT INTO bodn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","བུ་གཅིག་ནི་བདག་དང་ཁ་བྲལ་ནས་སོང༌ངོ༌། །བདག་གིས་ད་ལྟའི་བར་དུ་བུ་ཁོ་རང་མ་མཐོང་བས་ཁོ་གཅན་གཟན་གྱིས་དུམ་བུ་དུམ་བུར་བྱས་ནས་ཟོས་པ་ཤ་སྟག་ཡིན་སྙམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ད་ལྟ་ཁྱོད་རྣམས་ཀྱིས་བདག་གི་བུ་འདིའང་བདག་དང་ཕྲལ་བར་འདོད་པ༌དང༌། གལ་ཏེ་བུ་ཁོ་རང་ལ་བར་ཆད་བྱུང༌ན། ཁྱོད་རྣམས་ཀྱིས་སྐྲ་དཀར་པོར་གྱུར་པའི་རྒན་པོ་བདག་སྡུག་བསྔལ་གྱི་ངང་ནས་གཤིན་པོའི་གནས་སུ་བསྐྱལ་བ་ཡིན་ཞེས་སྨྲས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","བདག་གི་ཕ་ཡི་སེམས་ནི་བུ་ཆེས་ཆུང་བ་འདི་ལ་ཤོར་ཡོད༌པས། ད་ལྟ་བདག་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་ཅག་གི་ཕ་ཡི་དྲུང་དུ་སོང༌ནའང༌། སྤུན་ཆེས་ཆུང་བ་ངེད་ཅག་དང་མཉམ་དུ་མེད༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ངེད་ཅག་གི་ཕ་ཡིས་བུ་ཆེས་ཆུང་བ་མ་མཐོང་བས་ཁོང་ཚེ་ལས་འདའ་བར༌ངེས། དེ་ལྟར་ངེད་རྣམས་ཀྱིས་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་སྟེ་དབུ་སྐྲ་དཀར་པོར་གྱུར་པའི་ངེད་ཅག་གི་ཕ་སྡུག་བསྔལ་གྱི་ངང་ནས་གཤིན་པོའི་གནས་སུ་བསྐྱལ་བ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ཅིའི་ཕྱིར་ཞེ༌ན། ཞབས་ཕྱི་པ་བདག་གིས་དེ་སྔར་ཕ་ཡི་དྲུང་དུ་སྤུན་ཆེས་ཆུང་བ་འདིའི་དོན་དུ་རང་ཉིད་གཏའ་མར་བཞག་པ༌སྟེ། གལ་ཏེ་བདག་གིས་ཁོ་རང་ཕྱིར་ཁྲིད་འོངས་ནས་ཁྱེད་ལ་མ་སྤྲད༌ན། བདག་ཁྱེད་ཀྱི་དྲུང་དུ་ནམ་ཡང་སྡིག་ཅན་ཡིན་ཞེས་སྨྲས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ད་ལྟ་ཞབས་ཕྱི་པ་བདག་སྤུན་ཆེས་ཆུང་བའི་ཚབ་ཏུ་ཁྱེད་ཀྱི་གཡོག་པོ་བྱེད་དུ་ཆུག སྤུན་ཆུང་ནི་སྤུན་གཞན་རྣམས་དང་མཉམ་དུ་འགྲོ་རུ་འཇུག་པར༌མཁྱེན། ");
INSERT INTO bodn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","གལ་ཏེ་སྤུན་ཆུང་བདག་དང་མཉམ་དུ་མ་སོང༌ན། བདག་ཕ་དང་ཇི་ལྟར་མཇལ༌ལམ། བདག་གིས་རང་གི་ཕ་ལ་འབྱུང་ངེས་པའི་སྡུག་བསྔལ་མིག་གིས་མཐོང་མི་ཕོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","དེ་ནས་ཡོ་སེབ་ཀྱིས་འཁོར་གཡོག་མང་པོ་ཚོགས་པའི་མདུན་དུ་རང་དབང་མེད་པར་ཁྱོད་རྣམས་ཐམས་ཅད་ཕར་སོང་ཞིག་ཅེས་སྨྲས་པ༌དང༌། ཡོ་སེབ་དང་སྤུན་རྣམས་ཀྱིས་ཕན་ཚུན་ངོས་འཛིན་པའི་སྐབས༌སུ། ཁོ་རྣམས་ཀྱི་གམ་དུ་མི་གཞན་གཅིག་ཀྱང་མེད༌པས། ");
INSERT INTO bodn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ཡོ་སེབ་ཀྱིས་སྐད་ཆེན་པོ་བརྒྱབ་ནས་ངུས༌ཤིང༌། དོན་དེ་ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ཀྱིས་ཐོས༌པ་དང་། ཕཱར་ཨོལ་གྱི་ཁྱིམ་མི་རྣམས་ཀྱིས་ཀྱང་ཐོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","དེ་ནས་ཡོ་སེབ་ཀྱིས་སྤུན་རྣམས་ལ་འདི༌ལྟར། བདག་ནི་ཡོ་སེབ༌ཡིན། རང་ཅག་གི་ཕ་བདེ་བར་བཞུགས་ལགས་སམ་ཞེས་སྨྲས་ནའང་སྤུན་རྣམས་ཀྱིས་ལན་འདེབས་མ་ནུས༌ཏེ། ཁོ་རྣམས་ཡོ་སེབ་ཀྱི་དྲུང་དུ་འཇིགས་ཤིང་སྐྲག་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","དེ་ནས་ཡོ་སེབ་ན༌རེ། ཁྱོད་རྣམས་མདུན་དུ་ཤོག་ཅིག་ཅེས་སྨྲས་པ་དང་ཁོ་རྣམས་ཀྱང་ཡོ་སེབ་ཀྱི་མདུན་དུ༌ཡོང༌། ཡང་ཡོ་སེབ་ན༌རེ། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་སྤུན་ཡོ་སེབ༌སྟེ། ཁྱོད་ཅག་གིས་ཨེ་ཅིབ་ཡུལ་དུ་བཙོངས་པ་དེ་ཉིད༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ད་ལྟ་ཁྱོད་རྣམས་ཀྱིས་ང་རང་ཡུལ་འདིར་བཙོངས་པའི་རྐྱེན་གྱིས་སེམས་སྡུག་བྱས་ནས་རང་ལ་སྡང་མི་དགོས༌ཏེ། འདི་ནི་དཀོན་མཆོག་གིས་ང་རང་ཁྱོད་རྣམས་ཀྱི་སྔོན་ལ་ཡུལ་འདིར་ཚེ་སྲོག་སྐྱོབ་པར་མངགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ད་ལྟ་ཡུལ་འདིར་མུ་གེ་བྱུང་ནས་ལོ་གཉིས་འགོར༌ཞིང༌། ད་དུང་ལོ་ལྔའི་རིང་ལ་ཞིང་འདེབས་མི་ཐུབ་པ་དང་ལོ་ཏོག་ཀྱང་མི་འབྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","དཀོན་མཆོག་གིས་ང་རང་ཁྱོད་རྣམས་ཀྱི་སྔོན་ལ་ཡུལ་འདིར་མངགས་དོན༌ནི། ས་གཞིའི་སྟེང་དུ་ཁྱོད་རྣམས་ལ་རིགས་རྒྱུད་ཡོད་པ༌དང༌། ཁྱོད་རྣམས་འཇིག་ཉེན་ལས་སྲོག་ཐར་བའི་ཕྱིར༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","དེའི༌ཕྱིར། ང་རང་ཡུལ་འདིར་མངགས་མཁན་ནི་དཀོན་མཆོག་ཡིན་པ་ལས་ཁྱོད་རྣམས་མ་ཡིན༌ལ། ཡང་ཁོང་གིས་བདག་ཕཱར་ཨོལ་གྱི་ཕ་ལྟ་བུར་བསྐོས༌ཤིང༌། རྒྱལ་པོའི་ཕོ་བྲང་གི་བདག་པོ༌དང༌། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཀྱི་བློན་ཆེན་དུ་བསྐོས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ཁྱོད་རྣམས་མྱུར་དུ་ཡར་རང་ཅག་གི་ཕ་ཡི་དྲུང་དུ་སོང་ནས་ཁོང་ལ་འདི་ལྟར་སྨྲ་བར་བྱ༌སྟེ། ཁྱེད་ཀྱི་བུ་ཡོ་སེབ་ན༌རེ། དཀོན་མཆོག་གིས་ང་རང་ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཀྱི་བདག་པོར་བསྐོས་པ༌དང༌། ཁྱོད་རྣམས་མྱུར་དུ་མར་ཡུལ་འདིར་ཤོག༌ཅིག དུས་འགྱངས་མི༌རུང༌། ");
INSERT INTO bodn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ཡབ་ཁྱེད་དང་ཁྱེད་ཀྱི་བུ་དང་བུ༌མོ། ཚ་བོ་དང་ཚ༌མོ། ཐ་ན་ར་ལུག་དང་བ་གླང་གི་ཁྱུ་དང་བཅས་པ་ཐམས་ཅད་བདག་དང་ཉེ་སའི་གོ་ཤེན་ཡུལ་དུ་འདུག་པར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","བདག་གིས་ཡུལ་དེ་ནས་ཁྱེད་ལ་ཞབས་ཕྱི་བསྒྲུབ་པར༌བྱ། ཅིའི་ཕྱིར་ཞེ༌ན། ད་དུང་ལོ་ལྔའི་རིང་ལ་མུ་གེ་འབྱུང༌བས། དེ་ལྟར་མ་བྱས་ཚེ་ཁྱེད་དང་ཁྱེད་ཀྱི་ཁྱིམ་མི་དང་བཅས་པ་ཐམས་ཅད་ལ་ཆག་སྒོ་འབྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ཡང་ཁྱོད་རྣམས་དང་བདག་གི་སྤུན་པེན་ཡཱ་མེན་བཅས་ཀྱི་མིག་གིས་མཐོང་བ་བཞིན་བདག་གིས་ངག་ནས་འདི་ལྟར་སྨྲས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ཁྱོད་རྣམས་ཀྱིས་ཀྱང་ཨེ་ཅིབ་ཡུལ་གྱི་བདག་གི་གཟི་བརྗིད་དང་ཅི་ཞིག་མཐོང་བ་རྣམས་ཕ་ལ་སྨྲ་བར༌གྱིས། ཡང་རང་ཅག་གི་ཕའང་མྱུར་དུ་ཡུལ་འདིར་ཁྲིད་ཤོག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","དེ་ནས་ཡོ་སེབ་སྤུན་པེན་ཡཱ་མེན་གྱི་སྐེ་ལ་འཐམས་ནས་ངུས་པ༌དང༌། པེན་ཡཱ་མེན་ཡང་ཡོ་སེབ་ཀྱི་མཇིང་ལ་འཇུས་ནས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","དེ་ནས་ཡོ་སེབ་ཀྱིས་སྤུན་གཞན་རྣམས་ལ་འོ་བྱེད་བཞིན་ངུས་པ༌རེད། དེའི་རྗེས༌སུ། སྤུན་གཞན་རྣམས་ཀྱིས་ཀྱང་ཡོ་སེབ་ལ་གཏམ་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","དེ་ཡང་དོན་དེ་ཐམས་ཅད་ཕཱར་ཨོལ་གྱི་ཕོ་བྲང་དུ་ཁྱབ༌སྟེ། ཡོ་སེབ་ཀྱི་སྤུན་རྣམས་སླེབས་བྱུང་ཞེས་སྨྲ་བཞིན་ཡོད་པ་ཕཱར་ཨོལ་དང་ཁོང་གི་བློན་ཆེན་རྣམས་ཀྱིས་ཐོས་པ་དང་ཐམས་ཅད་དགའ་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","དེ་ནས་ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱིས་རང་གི་སྤུན་རྣམས༌ལ། ཁྱོད་ཅག་གིས་ཁལ་མར་ཁལ་བཀལ་ནས་ཀ་ན་ཨན་ཡུལ་དུ་སོང༌ཞིག ");
INSERT INTO bodn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ཁྱོད་ཅག་གིས་ཕ་དང་གཉེན་ཉེ་ཐམས་ཅད་འདིར་ཁྲིད་ཤོག༌དང༌། བདག་གིས་ཨེ་ཅིབ་ཡུལ་གྱི་ནོམ་པ་མཆོག་ཏུ་གྱུར་པ་དང་ཡུལ་དེའི་ས་ཞིང་གཤིན་པོའི་འབྲས་བུ་ཁྱོད་རྣམས་ལ་སྟེར་བར་བྱ་ཞེས་སྨྲོས༌ཤིག ");
INSERT INTO bodn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ད་ལྟ་བདག་གིས་ཁྱོད་རྣམས་ལ་འདི་ལྟར་བསྒྲུབ་པར་སྐུལ་བར་བྱ༌སྟེ། ཁྱོད་རྣམས་ཀྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཤིང་རྟ་དེད་དེ་ཀ་ན་ཨན་ཡུལ་དུ་སོང༌ནས། རང་ཅག་གི་ཕ༌དང༌། རང་རང་གི་ཆུང་མ་དང་བུ་ཕྲུག་བཅས་གནས་འདིར་ཁྲིད་ཤོག༌ཅིག ");
INSERT INTO bodn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ཁྱོད་ཅག་གི་སེམས་ནས་ཅ་ལག་གཅེས་སུ་འཛིན་མི་འོས༌ཏེ། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཀྱི་ནོམ་པ་མཆོག་ཏུ་གྱུར་པ་མཐའ་དག་ཁྱོད་ཅག་གི་ཡིན་པའི་ཕྱིར་རོ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","དེ་ནས་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱིས་དེ་ལྟར་བསྒྲུབས༌ཤིང༌། ཡོ་སེབ་ཀྱིས་ཕཱར་ཨོལ་གྱི་བཀའ་ལྟར་སྤུན་རྣམས་ལ་ཤིང་རྟ་དང་ལམ་བྲོ་སྤྲད་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ཡང་ཁོ་རྣམས་ལ་གྱོན་གོས་ཁ་ཚང་རེ་སྤྲད་པ༌དང༌། པེན་ཡཱ་མེན་ཁོ་ནར་དངུལ་སྒོར་སུམ་བརྒྱ་དང་གྱོན་གོས་ཁ་ཚང་ལྔ་སྤྲད་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","རང་གི་ཕ་ལ་བོང་གསེབ་བཅུ་ལ་ཨེ་ཅིབ་ཡུལ་གྱི་ནོམ་པ་མཆོག་ཏུ་གྱུར་པ་བཀལ་བ༌དང༌། ཡང་བོང་མ་བཅུ་ལ་འབྲུ་རིགས་དང་བག་ལེབ་སོགས་བཀལ་ཏེ་ཕ་ཡི་ལམ་བྲོ་རུ༌བྱས། ");
INSERT INTO bodn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","དེ་ནས་ཡོ་སེབ་ཀྱིས་སྤུན་རྣམས་ཡུལ་དུ་འགྲོ་རུ་བཅུག་ཅིང་ཁོ་རྣམས་ལ་ན༌རེ། ཁྱོད་ཅག་གིས་ལམ་བར་དུ་རྩོད་པ་མ་བྱེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","དེ་ནས་སྤུན་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ལམ་ལ་ཆས་ཏེ་ཀ་ན་ཨན་ཡུལ་གྱི་ཕ་ཡ་ཀོབ་ཀྱི་གམ་དུ་སླེབས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ཁོ་རྣམས་ཀྱི་ཕ་ལ་ཡོ་སེབ་ད་དུང་གསོན་པོར་གནས༌ཤིང༌། ཁོ་ནི་ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཀྱི་མངའ་བདག་ཡིན་ནོ་ཞེས་སྨྲས༌ནའང༌། ཕ་ཡ་ཀོབ་ཧ་ལས་ཤིང་ཁོ་རྣམས་ཀྱི་གཏམ་ལ་ཡིད་མ་ཆེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","སྤུན་རྣམས་ཀྱིས་ཁོ་རྣམས་ལ་སྨྲས་པའི་ཡོ་སེབ་ཀྱི་གཏམ་ཐམས་ཅད་ཕ་ལ་སྨྲས་པ༌དང༌། ཡོ་སེབ་ཀྱིས་ཕ་ལེན་པར་མངགས་པའི་ཤིང་རྟ་སོགས་ཡ་ཀོབ་ཀྱིས་མཐོང་བ་དང་མྱ་ངན་ལས་སངས་ཤིང་ཡིད་ཆེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","དེ་ནས་ཡེས་ར་ཨེལ་ན༌རེ། འོ། ལགས༌སོ། །བདག་གི་བུ་ཡོ་སེབ་ད་དུང་གསོན་པོར་གནས༌པས། ང་རང་མ་ཤི་གོང་ལ་ཁོ་དང་འཕྲད་འདོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","དེ་ནས་ཡེས་ར་ཨེལ་གྱིས་རྒྱུ་ནོར་ཐམས་ཅད་ཁྱེར་ཏེ་པེར་ཤ་བཱ་རུ་སོང་བ༌དང༌། རང་གི་ཕ་ཨི་སཱག་གི་དཀོན་མཆོག་ལ་མཆོད་པ་ཕུལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","མཚན་མོའི་དུས༌སུ། དཀོན་མཆོག་གིས་ཞལ་གཟིགས་གནང་ནས་ཡེས་ར་ཨེལ་ལ་འདི་སྐད༌དུ། ཀྱེ། ཡ༌ཀོབ། ཡ་ཀོབ་ཅེས་བོས་པ༌དང༌། ཁོ་ན༌རེ། བདག་འདི་རུ་ཡོད་ཅེས་ལན༌བཏབ། ");
INSERT INTO bodn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","དེ་ནས་དཀོན་མཆོག་གིས་འདི་སྐད༌དུ། བདག་ནི་དཀོན་མཆོག༌སྟེ། ཁྱོད་ཀྱི་ཕ་ཡི་དཀོན་མཆོག༌ཡིན། ཁྱོད་མར་ཨེ་ཅིབ་ཡུལ་དུ་འགྲོ་བར་འཇིགས་མི་དགོས༌ཏེ། བདག་གིས་ཡུལ་དེ་ནས་ཁྱོད་རང་རྒྱལ་ཁབ་ཆེན་པོར་འགྱུར་བར་བྱེད་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","བདག་ནི་ཁྱོད་དང་མཉམ་དུ་མར་ཨེ་ཅིབ་ཡུལ་དུ་འགྲོ༌ཞིང༌། ཡང་ཁྱོད་རང་ཕྱིར་ཁྲིད་ཡོང་བར༌ངེས། ཁྱོད་ཚེ་ལས་འདའ་སྐབས་ཡོ་སེབ་ཀྱིས་ཁྱོད་ཀྱི་མིག་ཟུང་བཙུམ་པར་བྱེད་ཅེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","དེ་ནས་ཡ་ཀོབ་ནི་པེར་ཤ་བཱ་ནས་ལམ་ལ་ཆས༌ཤིང༌། ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱིས་ཕ་ཡ་ཀོབ༌དང༌། ཁོ་ཚོའི་ཆུང་མ་རྣམས༌དང༌། བུ་དང་བུ་མོ་བཅས་ཐམས་ཅད་ཕཱར་ཨོལ་གྱིས་མངགས་ཡོང་བའི་ཤིང་རྟར་འདུག་ཏུ་བཅུག ");
INSERT INTO bodn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ཡང་ཁོ་རྣམས་ཀྱིས་ཀ་ན་ཨན་ཡུལ་ནས་ཐོབ་པའི་ཕྱུགས་ཟོག་རྣམས་དེད་པ་དང་རྒྱུ་ནོར་ཐམས་ཅད་ཨེ་ཅིབ་ཡུལ་དུ་ཁྱེར་བར་མ་ཟད། ཡ་ཀོབ་དང་ཁོའི་བུ་རབས་ཚ་རྒྱུད་ཐམས་ཅད་ཀྱང་ཨེ་ཅིབ་ཡུལ་དུ་སོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ཡ་ཀོབ་ཀྱིས་རང་གི་བུ་དང་བུ༌མོ། ཚ་བོ་དང་ཚ་མོ་བཅས་བུ་རབས་ཚ་རྒྱུད་ཐམས་ཅད་མཉམ་དུ་ཨེ་ཅིབ་ཡུལ་དུ་ཁྲིད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","དེ་ཡང་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིན་པའི་ཡ་ཀོབ་ཀྱི་བུ་རྒྱུད༌དེ། ཡེས་ར་ཨེལ་མི་རིགས་ཀྱི་མིང་ཐོ་ནི་གཤམ་གསལ༌ལྟར། ཡ་ཀོབ་ཀྱི་བུ་སྐྱེས་འགོ་ནི་རུ་བེན་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","རུ་བེན་གྱི་བུ་རྣམས་ནི་ཧ་ནོག༌དང༌། ཕཱ༌ལུའུ། ཧེས༌རོན། ཀར་མའེ་བཅས༌བཞིའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","སི་མུ་ཨོན་གྱི་བུ་རྣམས་ནི་ཡཱ་མུ་ཨེལ༌དང༌། ཡཱ༌མེན། ཨོ༌ཧད། ཡཱ༌ཀིན། ཚོ༌ཧར། དེ་མིན་ཀ་ན་ཨན་མི་རིགས་ཀྱི་བུད་མེད་ལས་སྐྱེས་པའི་བུ་ཤཱ་ཨུལ་བཅས་དྲུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ལེ་ཝིའི་བུ་རྣམས་ནི་གེར་ཤོན༌དང༌། ཀོ༌ཧད། མཱ་རཱ་རེའེ་བཅས་གསུམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ཡ་ཧུ་དཱའི་བུ་རྣམས་ནི་ཨེར༌དང༌། ཨོ༌ནན། ཤེ༌ལཱ། ཕེ་རེ༌ཟི། ཟེ་རག་བཅས༌ལྔའོ། །ཨེར་དང་ཨོ་ནན་གཉིས་ནི་ཀ་ན་ཨན་ཡུལ་ནས་ཚེ་ལས་འདས་པ༌དང༌། ཕེ་རེལ་ཟི་ཡི་བུ་གཉིས་ནི་ཧེས་རོན་དང་ཧ་མུལ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ཡེས་སི་ཀཱར་གྱི་བུ་རྣམས་ནི་ཐོ་ལཱ༌དང༌། ཕུ༌བཱ། ཡོ༌ཨུབ། ཤིམ་རོན་བཅས༌བཞིའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ཟེ་བུ་ལུན་གྱི་བུ་རྣམས་ནི་སེ་རཱད༌དང༌། ཨེད༌ལོན། ཡ་ལཱ་ཨལ་བཅས་གསུམ༌མོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","དེ་དག་ནི་ཕཱ་དན་ཨ་རམ་ཡུལ་ནས་བུད་མེད་ལེ་ཨ་ཡིས་ཡ་ཀོབ་ལ་བཙས་པའི་བུ་རྣམས་ཡིན༌ལ། བུ་མོ་དི་ནཱའང་བཙས༌པའོ། །བུ་རབས་ཚ་རྒྱུད་རྣམས་བསྡོམས་པས་སུམ་ཅུ་སོ་གསུམ་བྱུང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","དེ་ཡང་གཱ་རྡུ་ཡི་བུ་རྣམས་ནི་ཚིབ་ཡོན༌དང༌། ཧ༌གིད། ཤུ༌ནེ། ཨེས༌པོན། ཨེ༌རི། ཨ་ཪོ༌དི། ཨར་ཨེ་ལི་བཅས་བདུན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ཨ་ཤེར་གྱི་བུ་རྣམས་ནི་ཡིམ་ནཱ༌དང༌། ཡེས༌བཱ། ཡེས༌བི། པེ་རེ་ཡཱ་དང༌། བུ་མོ་སེ་རཱ་བཅས་བུ་དང་བུ་མོ༌ལྔའོ། །པེ་རེ་ཡཱ་ཡི་བུ་ནི་ཧེ་བེར་དང་མཱལ་ཀི་ཨེལ་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","དེ་དག་ནི་ལཱ་པན་གྱིས་རང་གི་བུ་མོ་ལེ་ཨ་ལ་གནང་བའི་གཡོག་མོ་ཟིལ་པཱ་ཡིས་ཡ་ཀོབ་ལ་བཙས་པའི་བུ་རབས་ཚ་རྒྱུད་རྣམས་ཡིན༌ལ། བསྡོམས་པས་བཅུ་དྲུག་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","དེ་ཡང་ཡ་ཀོབ་ཀྱི་ཆུང་མ་རཱ་ཧེལ་གྱི་བུ་ནི་ཡོ་སེབ་དང་པེན་ཡཱ་མེན་གཉིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ཡོ་སེབ་ཀྱི་ཆུང་མ་ཨ་སི་ནཱ་ཐི་ཡིས་ཨེ་ཅིབ་ཡུལ་ནས་མཱ་ན་ཤེ་དང་ཨེ་ཕཱར་ཡིམ་ཞེས་བྱ་བའི་བུ་གཉིས་བཙས༌ཤིང༌། ཁོ་མོ་ནི་ཨོ་ནཱ་ཡུལ་གྱི་མཆོད་དཔོན་ཕའོ་ཏི་ཕེ་རཱ་ཡི་བུ་མོ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","པེན་ཡཱ་མེན་གྱི་བུ་རྣམས་ནི་པེ་ལཱ༌དང༌། པེ༌ཀེར། ཨ་ཤ༌བེལ། གེ༌རཱ། ནཱ་ཨ༌མཱན། ཨེ༌ཧི། རའོ༌ཤ། མུ༌ཕིམ། ཧུ༌ཕིམ། ཨར་དཱ་བཅས༌བཅུའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","དེ་དག་ནི་ཡ་ཀོབ་ལ་ཆུང་མ་རཱ་ཧེལ་ནས་མཆེད་པའི་བུ་རབས་ཚ་རྒྱུད་རྣམས་ཡིན༌ལ། བསྡོམས་པས་བཅུ་བཞི་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","དཱན་གྱི་བུ་ནི་ཧུ་ཤིམ་ཡིན༌ནོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ནཱབ་ཐ་ལི་ཡི་བུ་རྣམས་ནི་ཡཱ་སི་ཨེལ༌དང༌། གུ༌ནེ། ཡེ༌ཚིར། ཤིལ་ལེམ་བཅས༌བཞིའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","དེ་དག་ནི་ལཱ་པན་གྱིས་རང་གི་བུ་མོ་རཱ་ཧེལ་ལ་གནང་བའི་གཡོག་མོ་པིལ་ཧ་ཡིས་ཡ་ཀོབ་ལ་བཙས་པའི་བུ་རབས་ཚ་རྒྱུད་རྣམས་ཡིན༌ལ། བསྡོམས་པས་བདུན་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","དེ་ཡང་ཡ་ཀོབ་དང་ལྷན་དུ་ཨེ་ཅིབ་ཡུལ་དུ་སོང་བའི་མནའ་མ་ལས༌གཞན། ད་དུང་རང་ལས་མཆེད་པའི་བུ་རབས་ཚ་རྒྱུད་རྣམས་བསྡོམས་པས་དྲུག་ཅུ་རེ་དྲུག་ཡོད༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ཡོ་སེབ་ལ་ཨེ་ཅིབ་ཡུལ་ནས་ཀྱང་བུ་གཉིས་སྐྱེས༌ཤིང༌། ཨེ་ཅིབ་ཡུལ་དུ་སྤར་བའི་ཡ་ཀོབ་ཀྱི་ཁྱིམ་རྒྱུད་ལ་བསྡོམས་པས་མི་གྲངས་བདུན་ཅུ་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","དེ་ཡང་ཡ་ཀོབ་ཀྱིས་བུ་ཡ་ཧུ་དཱ་ཞེས་པ་ཡོ་སེབ་ཀྱི་དྲུང་དུ་གོ་ཤེན་ཡུལ་ལ་འགྲོ་བར་ལམ་ཁྲིད་པར་མངགས་ཤིང་ཁོ་རྣམས་གོ་ཤེན་ཡུལ་དུ་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ཡོ་སེབ་ཤིང་རྟར་བསྡད་ནས་ཕ་ཡེས་ར་ཨེལ་ལ་དགའ་བསུ་བྱེད་པར་གོ་ཤེན་ཡུལ་དུ་སོང་བ༌དང༌། ཕ་དང་ངོ་ཕྲད་ཅིང་ཕ་ཡི་སྐེ་ལ་འཐམས་ནས་ཡུན་རིང་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། བདག་གིས་ཁྱོད་མིག་གིས་མཐོང༌ཞིང༌། ད་དུང་གསོན་པོར་གནས་པ་ཤེས་པས་ང་རང་འཆི་ཡང་འགྱོད་པ་མེད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ཡོ་སེབ་ཀྱིས་རང་གི་སྤུན་རྣམས་དང་ཕ་ཡི་ཁྱིམ་གང་པོར་འདི༌ལྟར། བདག་ཕཱར་ཨོལ་གྱི་དྲུང་དུ་སོང་ནས་འདི་ལྟར་སྨྲ་བར་བྱ༌སྟེ། བདག་གི་སྤུན་རྣམས་དང་ཕ་ཡི་ཁྱིམ་གང་པོ་སྔོན་ཆད་ཀ་ན་ཨན་ཡུལ་དུ་མཆིས་ཤིང་ད་ལྟ་བདག་གི་གམ་དུ་ཡོང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ཁོ་རྣམས་ཕྱུགས་རྫི་ཡིན་པས་ཕྱུགས་ཟོག་ལ་བརྟེན༌ཞིང་། ཁོ་རྣམས་ཀྱིས་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་བཅས་རྒྱུ་ནོར་ཐམས་ཅད་ཁྱེར་ནས་སླེབས་ཡོད་ཅེས་སྨྲ་བར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ཕཱར་ཨོལ་གྱིས་ཁྱོད་རྣམས་ལ་བཀའ་གསུང་བའི་སྐབས༌སུ། ཁྱོད་རྣམས་ཀྱིས་ལས་ཅི་ཞིག་གཉེར་བ་ཡིན་ཞེས་དྲིས༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ཁྱོད་རྣམས་ཀྱིས་འདི༌ལྟར། རྒྱལ་པོ་ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་ངེད་རྣམས་ཀྱིས་ལོ་ན་གཞོན་པའི་དུས་ནས་ད་ལྟའི་བར་དུ་ཕྱུགས་ལས་གཉེར་བ་ཡིན༌ལ། ཐ་ན་ངེད་ཅག་གི་མེས་པོ་རྣམས་ཀྱིས་ཀྱང་ལས་དོན་འདི་ཉིད་གཉེར་བ་ཡིན་ཞེས་ཤོད༌ཅིག དེ་ནས་ཁྱོད་རྣམས་གོ་ཤེན་ཡུལ་དུ་འདུག་རུང༌ངོ༌། །ཅིའི་ཕྱིར་ཞེ༌ན། ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ཀྱིས་ར་ལུག་འཚོ་མཁན་ནི་མི་ལེགས་སྙམ་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","དེ་ནས་ཡོ་སེབ་ཕཱར་ཨོལ་གྱི་དྲུང་དུ་སོང་ནས་འདི༌ལྟར། བདག་གི་ཕ་དང་སྤུན་རྣམས་ཀྱིས་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་བཅས་རྒྱུ་ནོར་ཐམས་ཅད་ཁྱེར་ཏེ་ཀ་ན་ཨན་ཡུལ་ནས་ད་ལྟ་གོ་ཤེན་ཡུལ་དུ་སླེབས་བྱུང་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ཡོ་སེབ་ཀྱིས་རང་གི་སྤུན་རྣམས་ལས་མི་ལྔ་བདམས༌ཏེ། ཁོ་རྣམས་ཕཱར་ཨོལ་ལ་མཇལ་བར་ཁྲིད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ཀྱི་སྤུན་རྣམས་ལ་འདི་སྐད༌དུ། ཁྱོད་ཅག་གིས་ལས་ཅི་ཞིག་གཉེར་བ་ཡིན་ཞེས་དྲིས་པ༌དང༌། ཁོ་རྣམས་ན༌རེ། ཁྱེད་ཀྱི་ཞབས་ཕྱི་པ་རྣམས་ར་ལུག་གི་རྫི་བོ་ཡིན༌ལ། ངེད་ཅག་གི་མེས་པོ་རྣམས་ཀྱང་ར་ལུག་གི་རྫི་བོ་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ཡང་ཁོ་རྣམས་ན༌རེ། ཀ་ན་ཨན་ཡུལ་དུ་མུ་གེ་བྱུང་བ་ཚབས་ཆེ་བ༌དང༌། ཞབས་ཕྱི་པ་ངེད་ཅག་གི་ར་ལུག་གི་ཁྱུ་ལ་རྩྭ་མེད་པས་ངེད་རྣམས་ཡུལ་འདིར་ཡོང་བ༌ཡིན། དེའི༌ཕྱིར། རྒྱལ་པོ་ཁྱེད་ཀྱིས་ཞབས་ཕྱི་པ་ངེད་རྣམས་གོ་ཤེན་ཡུལ་ནས་འདུག་ཏུ་འཇུག་པར་མཛོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ཕཱར་ཨོལ་གྱིས་ཡོ་སེབ་ལ་འདི་སྐད༌དུ། ཁྱོད་ཀྱི་ཕ་དང་སྤུན་རྣམས་ཁྱོད་ཀྱི་གནས་འདིར་ཡོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ཨེ་ཅིབ་ཀྱི་ཡུལ་ཐམས་ཅད་ཁྱོད་ལ་དབང༌བས། ཁྱོད་ཀྱིས་རང་གི་ཕ་དང་སྤུན་རྣམས་ཆེས་བཟང་བའི་ས་ཆ་སྟེ་གོ་ཤེན་ཡུལ་ནས་འདུག་ཏུ་འཇུག་པར༌གྱིས། ཁྱོད་ཀྱིས་ཁོ་རྣམས་ཀྱི་ཁྲོད་དུ་མི་ནུས་པ་ཅན་ཡོད་པ་ཤེས༌ན། དེ་རྣམས་བདག་གི་ཕྱུགས་ཟོག་འཚོ་བར་མངགས་པར་གྱིས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","དེར་ཡོ་སེབ་ཀྱིས་རང་གི་ཕ་ཡ་ཀོབ་ཁྲིད་ནས་ཕཱར་ཨོལ་གྱི་དྲུང་དུ་སོང་བ༌དང༌། ཡ་ཀོབ་ཀྱིས་ཕཱར་ཨོལ་ལ་བྱིན་རླབས་གནང་ངོ་།། ");
INSERT INTO bodn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ཕཱར་ཨོལ་གྱིས་ཡ་ཀོབ་ལ་ལོ་ག་ཚོད་ཡིན་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ཡ་ཀོབ་ན༌རེ། ང་རང་ད་ལྟའི་བར་འཇིག་རྟེན་དུ་ལོ་བརྒྱ་དང་སུམ་ཅུར་བསྡད་པ༌ཡིན། བདག་གི་ཚེ་ཐག་ཐུང་ཞིང་སྡུག་བསྔལ་མང་དུ༌མྱངས། བདག་ནི་མེས་པོ་རྣམས་འཇིག་རྟེན་དུ་འཚོ་གཞེས་གནང་བའི་ཚེ་ཐག་དང་བསྡུར་ཐབས་མེད་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ཡང་ཡ་ཀོབ་ཀྱིས་ཕཱར་ཨོལ་ལ་བྱིན་རླབས་གནང་རྗེས་ཁོང་དང་ཁ་བྲལ་ནས་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ཡོ་སེབ་ཀྱིས་ཕཱར་ཨོལ་གྱི་བཀའ་བཞིན་དུ་ཨེ་ཅིབ་ཡུལ་གྱི་ཆེས་བཟང་བའི་ས་ཆ་སྟེ་རཱ་ཨམ་སེའེ་ཞེས་པའི་ཡུལ་དེ་རང་གི་ཕ་དང་སྤུན་རྣམས་ལ་ས་སྐལ་དུ་གནང་བ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ཡོ་སེབ་ཀྱིས་རང་གི་ཕ༌དང༌། སྤུན་རྣམས༌དང༌། ཕ་ཡི་ཁྱིམ་མི་ཐམས་ཅད་ལའང་རང་རང་གི་བུ་ཕྲུག་གི་གྲངས་ཀ་ལྟར་འབྲུ་རིགས་གནང་སྟེ་བསྐྱངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","དེ་ཡང་ཡུལ་ཐམས་ཅད་ལ་མུ་གེ་བྱུང་བ་ཚབས་ཆེ་བས་འབྲུ་རིགས་མེད་པར་གྱུར་པ༌དང༌། ཐ་ན་ཨེ་ཅིབ་ཡུལ་དང་ཀ་ན་ཨན་ཡུལ་གྱི་མི་རྣམས་ཀྱང་བཀྲེས་ལྟོགས་ཀྱིས་མ་བཟོད་པར་དྲན་མེད་དུ་བརྒྱལ་བར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ཡོ་སེབ་ཀྱིས་འབྲུ་རིགས་བཙོངས་པའི་ཨེ་ཅིབ་ཡུལ་དང་ཀ་ན་ཨན་ཡུལ་གྱི་དངུལ་སྒོར་ཐམས་ཅད་བསྡུས་ཏེ་ཕཱར་ཨོལ་གྱི་ཕོ་བྲང་དུ་ཁྱེར་སོང༌ངོ༌།། ");
INSERT INTO bodn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ཨེ་ཅིབ་ཡུལ་དང་ཀ་ན་ཨན་ཡུལ་གྱི་དངུལ་སྒོར་ཐམས་ཅད་བཀོལ་ཚར་སོང༌བས། ཨེ་ཅིབ་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ཡོང་ནས་ཡོ་སེབ་ལ་མཇལ་ཏེ་ན༌རེ། ངེད་ཅག་གི་དངུལ་སྒོར་ཐམས་ཅད་བཀོལ་ཚར་སོང་བས་ངེད་རྣམས་ལ་འབྲུ་རིགས་གནང་བར༌ཞུ། ངེད་ཅག་ཁྱེད་ཀྱི་མིག་མདུན་ནས་འཆི་དགོས་པའི་རྒྱུ་མཚན་ཅི་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ཡོ་སེབ་ན༌རེ། གལ༌ཏེ། ཁྱོད་རྣམས་ཀྱི་དངུལ་སྒོར་བཀོལ་ཚར་བ་ཡིན༌ན། ཁྱོད་ཅག་གི་ཕྱུགས་ཟོག་བདག་ལ་སྤྲད་ཀྱང་ཆོག་པ༌དང༌། བདག་གིས་ཁྱོད་རྣམས་ཀྱི་ཕྱུགས་ཟོག་གི་ཚབ་ཏུ་འབྲུ་རིགས་སྟེར་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","དེའི༌ཕྱིར། མང་ཚོགས་ཀྱིས་སྒོ་ཕྱུགས་དེད་ནས་ཡོ་སེབ་ཀྱི་དྲུང་དུ་ཡོང་བ༌དང༌། ཡོ་སེབ་ཀྱིས་འབྲུ་རིགས་ནི་རྟ༌དང༌། ར་ལུག༌དང༌། བ་གླང༌དང༌། བོང་བུ་བཅས་ལ་བརྗེས༌ཤིང༌། ལོ་དེར་སྒོ་ཕྱུགས་དང་འབྲུ་རིགས་བརྗེ་རེས་བྱས་པས་མི་ཚོགས་དེ་རྣམས་ལོ་གཅིག་གི་རིང་ལ་འཚོ་ཐུབ་པར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","དེ་ཡང་ལོ་དེ་འདས་པ་དང་ལོ་གཉིས་པར་མང་ཚོགས་རྣམས་ཡང་ཡོང་སྟེ་ཡོ་སེབ་ལ་འདི༌ལྟར། ངེད་ཅག་གིས་རང་གི་བདག་པོ་ལ་གསང་བ་མིན༌ཏེ། ངེད་རྣམས་ཀྱི་དངུལ་སྒོར་བཀོལ་ཚར་བ་དང་ཕྱུགས་ཟོག་ཀྱང་ཁྱེད་ལ་བརྗེས་ཚར༌བས། ད་ལྟ་རང་གི་བདག་པོ་ལ་ངེད་ཅག་གི་ལུས་པོ་དང་ས་ཆ་ལས་གཞན་ཅི་ཡང་ལྷག་མེད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ཁྱེད་ཀྱིས་ངེད་ཅག་འཆི་བ་དང་ཡུལ་འདི་ས་སྟོང་དུ་ལུས་པར་བལྟ་བཟོད༌དམ། ཁྱེད་ཀྱིས་འབྲུ་རིགས་ལ་བརྟེན་ནས་ངེད་ཅག་དང་ས་ཆ་ཉོ་བར་བྱེད་པ༌དང༌། ངེད་ཅག་དང་ངེད་ཅག་གི་ས་ཆ་ནི་ཕཱར་ཨོལ་ལ་དབང་བར༌མཛོད། ངེད་རྣམས་མི་འཆི་བར་འཚོ་བ་དང་ས་ཞིང་ཡང་དབེན་སྟོང་དུ་མི་འགྱུར་བའི་ཆེད༌དུ། ཁྱེད་ཀྱིས་ངེད་ཅག་ལ་འབྲུ་རིགས་ཀྱི་ས་བོན་གནང་བར་མཛོད་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","དེ་ནས་ཡོ་སེབ་ཀྱིས་ཕཱར་ཨོལ་ལ་ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཉོས༌ཤིང༌། ཨེ་ཅིབ་ཀྱི་མི་རྣམས་ལ་མུ་གེ་ཚབས་ཆེན་བྱུང་བའི་རྐྱེན་གྱིས་མི་ཚང་མས་རང་རང་གི་ས་ཞིང་ཡང་བཙོངས༌པས། ཡུལ་དེ་ཐམས་ཅད་ཕཱར་ཨོལ་ལ་དབང་བར༌གྱུར། ");
INSERT INTO bodn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ཡོ་སེབ་ཀྱིས་མང་ཚོགས་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་གྲོང་ཁྱེར་གཞན་དག་ལ་འགྲོ་རུ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","འོན༌ཀྱང༌། ཡོ་སེབ་ཀྱིས་མཆོད་དཔོན་རྣམས་ཀྱི་ས་ཆ་མ་ཉོས༌སོ། །ཅིའི་ཕྱིར་ཞེ༌ན། ཕཱར་ཨོལ་གྱིས་ལོ་རེ་བཞིན་མཆོད་དཔོན་རྣམས་ལ་ཟས་སྐལ་གནང་བ༌དང༌། ཟས་སྐལ་དེ་ལ་བརྟེན་པའི་དབང་གིས་ཁོ་རྣམས་ཀྱིས་རང་གི་ས་ཆ་མ་བཙོང་བའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ཡོ་སེབ་ཀྱིས་མང་ཚོགས་ལ་འདི་སྐད༌དུ། ལྟོས༌དང༌། དེ་རིང་བདག་གིས་ཕཱར་ཨོལ་གྱི་ཆེད་དུ་ཁྱོད་ཅག་དང་ཁྱོད་རྣམས་ཀྱི་ས་ཆ་ཉོས་པ༌ཡིན། བདག་གིས་འདི་རུ་ཡོད་པའི་ས་བོན་ཁྱོད་ཅག་ལ་སྟེར་བར༌བྱ། ཁྱོད་ཅག་གིས་ཞིང་འདེབས་པར༌གྱིས། ");
INSERT INTO bodn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","སྟོན་བསྡུ་བའི་སྐབས༌སུ། འབྲུ་རིགས་ཀྱི་ལྔ་ཆ་གཅིག་ཕཱར་ཨོལ་ལ་ཁྲལ་འཇལ་བ༌དང༌། ལྔ་ཆ་བཞི་རང་ལ་དབང་ཞིང་ས་བོན་དུ་བྱས་ཀྱང་ཆོག༌ལ། ཁྱོད་ཅག་དང་ཁྱོད་ཅག་གི་ཁྱིམ་མི་ཡོངས་ཀྱི་ཟས་རིགས་སུ་བྱས་ཀྱང་ཆོག་ཅེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","མང་ཚོགས་ན༌རེ། ཀྱེ། ཁྱེད་ཀྱིས་ངེད་ཅག་གི་སྲོག་བསྐྱབས་པར་མཛད༌པས། ངེད་ཅག་ལ་བདག་པོ་ཁྱེད་ཀྱི་སྤྱན་ལམ་ནས་ཐུགས་རྗེ་འཐོབ་པར༌སྨོན། ངེད་ཅག་ཕཱར་ཨོལ་གྱི་གཡོག་པོར་འགྱུར་བར་སྨོན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","དེའི༌ཕྱིར། ཕཱར་ཨོལ་ལ་ལྔ་ཆ་གཅིག་གི་ཁྲལ་འཇལ་བ༌དང༌། མཆོད་དཔོན་གྱི་ས་ཆ་རྒྱལ་པོར་མི་དབང་བ་འདི༌ནི། ཡོ་སེབ་ཀྱིས་ཨེ་ཅིབ་ཡུལ་དུ་གཏན་ལ་ཕབ་པའི་སྒྲིག་ཁྲིམས་ཡིན་ཞིང་ད་ལྟའི་བར་དུ་ཡོད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","དེ་ཡང་ཡེས་ར་ཨེལ་གྱི་མི་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་གོ་ཤེན་ཡུལ་དུ་བསྡད་ཅིང་གནས་དེར་དབང་བསྒྱུར་བ༌དང༌། དེ་རུ་རིགས་རྒྱུད་མང་དུ་འཕེལ་བར་གྱུར༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ཡ་ཀོབ་ནི་ཨེ་ཅིབ་ཡུལ་དུ་ལོ་འཁོར་བཅུ་བདུན་ལ་བསྡད་པ་དང་ཁོའི་ཚེ་ཐག་ལོ་བརྒྱ་དང་ཞེ་བདུན་ཡིན༌ལ། ");
INSERT INTO bodn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ཡེས་ར་ཨེལ་ཚེ་ལས་འདའ༌ཁར། ཁོས་བུ་ཡོ་སེབ་བོས་ཏེ་འདི་སྐད༌དུ། གལ༌ཏེ། བདག་ལ་ཁྱོད་ཀྱི་མིག་མདུན་ནས་ཐུགས་རྗེ་ཐོབ༌ན། ཁྱོད་ཀྱིས་རང་གི་ལག་པ་བདག་གི་བརླ་འོག་ཏུ་འཇོག་པར༌གྱིས། བྱམས་སྙིང་རྗེ་དང་དྲང་བདེན་གྱི་སྒོ་ནས་བདག་ལ་གཅེས་པར༌གྱིས། བདག་གི་བེམ་པོ་ཨེ་ཅིབ་ཡུལ་དུ་དུར་ལ་འཇུག་པར་མི༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ང་རང་ཚེ་ལས་འདས༌རྗེས། ཁྱོད་ཀྱིས་བདག་གི་བེམ་པོ་ཨེ་ཅིབ་ཡུལ་ནས་ཁྱེར་ཏེ་མེས་པོ་རྣམས་དང་ལྷན་དུ་དུར་ལ་འཇུག་པར་གྱིས་ཞེས་སྨྲས་པ༌ལ། ཡོ་སེབ་ན༌རེ། བདག་གིས་ཁྱེད་ཀྱི་གསུང་བཞིན་དུ་བསྒྲུབ་ངེས་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ཡེས་ར་ཨེལ་ན༌རེ། འོ༌ན། ཁྱོད་ཀྱིས་བདག་ལ་དམ་བཅའ་འཇོག་པར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ཡོ་སེབ་ཀྱིས་ཕ་ལ་དམ་བཅའ་བཞག༌ཅིང༌། ཡེས་ར་ཨེལ་གྱིས་མལ་ཁྲིའི་སྔས་མགོ་ནས་གུས་ཕྱག་ཕུལ་ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","དེ་ཡང་དོན་དེའི་རྗེས་སུ་མི་ཞིག་གིས་ཡོ་སེབ་ལ་འདི༌ལྟར། ཁྱེད་ཀྱི་ཡབ་ལ་སྙུང་གཞི་བྱུང་འདུག་ཅེས་སྨྲས་པ་དང་ཁོས་རང་གི་བུ་མཱ་ན་ཤེ་དང་ཨེ་ཕཱར་ཡིམ་གཉིས་ཁྲིད་ནས་ཕ་ལ་བལྟ་རུ༌སོང༌། ");
INSERT INTO bodn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","དེ་ནས་མི་ཞིག་གིས་ཡ་ཀོབ་ལ་འདི༌ལྟར། ལྟོས༌དང༌། ཁྱེད་ཀྱི་བུ་ཡོ་སེབ་འདི་རུ་སླེབས་བྱུང་ཞེས་སྨྲས་པ༌དང༌། ཡེས་ར་ཨེལ་མལ་ལས་ནན་གྱིས་ཡར་དགྱེ་སྟེ་ཙོག་པུར་བསྡད༌དོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ཡ་ཀོབ་ཀྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། ཀུན་དབང་དཀོན་མཆོག་གིས་ཀ་ན་ཨན་ཡུལ་གྱི་ལོ་ཟི་ནས་བདག་ལ་མངོན་པར་མཛད་པ་དང་བྱིན་རླབས་གནང་སྟེ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","བདག་གིས་ཁྱོད་ཀྱི་རིགས་རྒྱུད་མང་དུ་སྤེལ་ནས་མི་རིགས་ཆེན་པོ་ཞིག་ཏུ་བསྒྱུར་ངེས༌ཤིང༌། ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཕྱི་མ་རྣམས་ནི་རྟག་ཏུ་ཡུལ་འདིའི་བདག་པོར་མཛད་པར་བྱ་ཞེས་གསུངས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ང་རང་ཨེ་ཅིབ་ཡུལ་དུ་མ་ཡོང་བའི་སྔོན༌དུ། ཁྱོད་ལ་ཨེ་ཅིབ་ཡུལ་དུ་སྐྱེས་པའི་བུ་ཨེ་ཕཱར་ཡིམ་དང་མཱ་ན་ཤེ་གཉིས་ནི་བདག་གི་བུའང་ཡིན༌ཏེ། ངའི་བུ་རུ་བེན་དང་སི་མུ་ཨོན་དང་མཚུངས་པར་བདག་གི་རིགས་རྒྱུད་ཡིན་པའི་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","འོན༌ཀྱང༌། ཁྱོད་ལ་བུ་དེ་གཉིས་ལས་གཞན་དུ་སྐྱེས་པ་ནི་ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཡིན༌ཞིང༌། བུ་གཞན་རྣམས་ལའང་སྤུན་ཨེ་ཕཱར་ཡིམ་དང་མཱ་ན་ཤེ་གཉིས་ལས་ས་སྐལ་འཐོབ་དགོས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","བདག་ལ་མཚོན༌ན། ཕཱ་དན་ཡུལ་ནས་ཡོང་བའི་དུས༌སུ། རཱ་ཧེལ་ནི་ཀ་ན་ཨན་ཡུལ་གྱི་ལམ་བར་དུ་ངའི་མིག་མདུན་ནས་ཚེ་ལས་འདས་པ༌དང༌། ཨེབ་རཱད་དང་ལམ་ཐག་ངེས་ཅན་ཞིག་ཡོད༌པས། བདག་གིས་ཁོ་མོའི་བེམ་པོ་ཨེབ་རཱད་ཀྱི་ལམ་འགྲམ་དུ་དུར་ལ་སྦས་པ༌ཡིན། ཨེབ་རཱད་ཅེས་པ་པེད་ལེ་ཧེམ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","དེ་ནས་ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ཀྱི་བུ་གཉིས་མཐོང་བ་དང་མི་འདི་གཉིས་སུ་ཡིན་ནམ་ཞེས་དྲིས་པ༌ན། ");
INSERT INTO bodn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ཡོ་སེབ་ན༌རེ། འདི་གཉིས་ནི་དཀོན་མཆོག་གིས་ཡུལ་འདི་ནས་བདག་ལ་གནང་བའི་བུ་ཡིན་ཞེས་ལན་བཏབ་པ༌དང༌། ཡང་ཡེས་ར་ཨེལ་ན༌རེ། ཁྱོད་ཀྱི་བུ་གཉིས་པོ་བདག་གི་གམ་དུ་ཁྲིད་ཤོག༌ཅིག བདག་གིས་ཁོ་གཉིས་ལ་བྱིན་རླབས་གནང་བར་བྱ་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ཡེས་ར་ཨེལ་དགུང་ལོ་མཐོ་ཞིང་མིག་ཟུང་རབ་རིབ་ཏུ་གྱུར་ཡོད་པས་ཅི་ཡང་མ༌མཐོང༌། དེ་ནས་ཡོ་སེབ་ཀྱིས་རང་གི་བུ་གཉིས་པོ་ཕ་ཡི་གམ་དུ་ཁྲིད་ཡོང་བ༌དང༌། ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ཀྱི་བུ་གཉིས་ལ་འཇུས་ཤིང་འོ་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། ངའི་སེམས་སུ་བདག་ཁྱོད་དང་འཕྲད་མི་ཐུབ་པར་སྙམ༌ཡང༌། དཀོན་མཆོག་གི་ཐུགས་རྗེ་ལས་བདག་གིས་ཁྱོད་ཀྱི་བུ་རྒྱུད་ཀྱང་མཐོང་བྱུང་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ཡོ་སེབ་ཀྱིས་རང་གི་བུ་གཉིས་པོ་ཕ་ཡི་དྲུང་ནས་ཚུར་ཁྲིད༌ཅིང༌། ཁོས་ཕ་ཡི་དྲུང་དུ་མགོ་སྨད་དུ་བསྒུར་ནས་ཕྱག་བཙལ༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ཡོ་སེབ་ཀྱིས་བུ་གཉིས་ཕ་ཡི་དྲུང་དུ་ཁྲིད་པ༌སྟེ། ལག་པ་གཡས་པས་ཨེ་ཕཱར་ཡིམ་གྱི་ལག་པར་འཇུས་ཤིང་ཡེས་ར་ཨེལ་གྱི་གཡོན་ཕྱོགས་སུ་གཏད་པ༌དང༌། ལག་པ་གཡོན་པས་མཱ་ན་ཤེའི་ལག་པར་འཇུས་ཏེ་ཡེས་ར་ཨེལ་གྱི་གཡས་ཕྱོགས་སུ་གཏད་པ༌རེད། ");
INSERT INTO bodn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ཡེས་ར་ཨེལ་གྱིས་ལག་པ་གཡས་པ་བརྐྱངས་ཏེ་ཨེ་ཕཱར་ཡིམ་གྱི་མགོ་ལ་བཞག༌གོ །ཨེ་ཕཱར་ཡིམ་ནི་བུ་ཆུང་བ༌ཡིན། ཡང་ཡེས་ར་ཨེལ་གྱིས་ལག་པ་གཡོན་པ་བསྣོལ་ཏེ་མཱ་ན་ཤེའི་མགོ་ལ་བཞག༌གོ །མཱ་ན་ཤེ་ནི་བུ་སྐྱེས་འགོ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","ཡེས་ར་ཨེལ་གྱིས་བུ་ཡོ་སེབ་ལ་འདི་ལྟར་བྱིན་རླབས་གནང་བ༌སྟེ། བདག་གི་མེས་པོ་ཨབ་ར་ཧམ་དང་ཡབ་ཆེན་ཨི་སཱག་གིས་ནི་བཀུར་བ༌དང༌།། ཆུང་ངུའི་དུས་ནས་བདག་ལ་གཅེས་ཤིང་སྐྱོང་བ་བླ་ན་མེད་པའི་དཀོན་མཆོག༌གིས།། བདག་གི་དཀའ་སྡུག་ཐམས་ཅད་བསལ་བར་མཛད་ཅིང་མངགས་པའི་ཕོ་ཉ་དེ་ཡིས༌ནི།། བུ་ཆུང་གཉིས་ལ་བྱིན་རླབས་གནང་ཞིང་དེ་གཉིས་བརྒྱུད་ནས་བདག་གི་མིང་འདི༌དང༌།། མེས་པོ་ཨབ་ར་ཧམ་དང་ཨི་སཱག་མིང་བཅས་འཇིག་རྟེན་ཡོངས་སུ་རྒྱས་པར༌ཤོག ། བུ་ཆུང་གཉིས་ཀྱི་རིགས་རྒྱུད་མང་དུ་འཕེལ་ནས་འཇིག་རྟེན་ཀུན་ལ་ཁྱབ་པར༌སྨོན། །ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","དེ་ནས་ཕ་ཡིས་ལག་པ་གཡས་པ་ཨེ་ཕཱར་ཡིམ་གྱི་མགོ་ལ་བཞག་པའི་དོན་དེ་ཡོ་སེབ་ཀྱིས་མཐོང་ཞིང་ཡིད་མ་དགའ་བར་ཕ་ཡི་ལག་པར་འཇུས་པ༌དང༌། ཕ་ཡི་ལག་པ་བཏེགས་ནས་བུ་མཱ་ན་ཤེའི་མགོ་ལ་འཇོག་པར་བསམས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ཡོ་སེབ་ཀྱིས་ཕ་ལ་འདི༌ལྟར། བདག་གི་ཕ༌ལགས། དེ་ལྟར་མ་ཡིན༌ཏེ། འདི་ནི་བུ་སྐྱེས་འགོ་ཡིན། ཁྱེད་ཀྱིས་ལག་པ་གཡས་པ་ཁོའི་མགོ་ལ་འཇོག་པར་མཛོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ཁོའི་ཕ་ཡིས་དེ་ཁས་མ་བླངས་པར་འདི༌ལྟར། ངས་རྟོགས༌སོ། །བདག་གི༌བུ། ངས་རྟོགས༌སོ། །མཱ་ན་ཤེ་མི་རིགས་ཤིག་ཏུ་འགྱུར་བར་མ་ཟད། ཁོ་རང་མི་རླབས་ཆེན་ཞིག་ཏུའང་འགྱུར་ངེས་མོད། འོན༌ཀྱང༌། ཁོའི་གཅུང་པོ་ནི་མ་འོངས་པ་ན་ཁོ་ལས་ཀྱང་རླབས་ཆེན་པོར་འགྱུར་བ༌དང༌། ཁོའི་གཅུང་པོའི་རིགས་རྒྱུད་ཀྱང་མི་རིགས་མང་པོ་ཞིག་ཏུ་འགྱུར་ངེས་ཡིན་ཞེས་སྨྲས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ཁོང་གིས་ཉིན་དེར་བུ་གཉིས་ལ་འདི༌ལྟར། མ་འོངས་པ་ན་ཡེས་ར་ཨེལ་མི་རིགས་ཀྱིས་ཁྱོད་གཉིས་ཀྱི་མིང་ལ་བརྟེན་ནས་བྱིན་རླབས་འདི་ལྟར་གནང་བ༌སྟེ། དཀོན་མཆོག་གིས་ཨེ་ཕཱར་ཡིམ་དང་མཱ་ན་ཤེ་བཞིན་དུ་ཁྱོད་ལའང་བྱིན་རླབས་གནང་བར་སྨོན་ཞེས་སྨྲ་བར་ངེས་ཞེས་སྨྲས༌པས། ཨེ་ཕཱར་ཡིམ་ནི་མཱ་ན་ཤེ་ལས་མཐོ་བར་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","དེ་ནས་ཡེས་ར་ཨེལ་གྱིས་ཡོ་སེབ་ལ་འདི༌ལྟར། བདག་ནི་འཆི་ལ༌ཉེ། འོན་ཀྱང་དཀོན་མཆོག་ཁྱོད་རྣམས་དང་ལྷན་དུ་བཞུགས་ངེས༌ཤིང༌། ཁོང་གིས་ཁྱོད་རྣམས་ཁྲིད་ནས་ཁྱོད་ཅག་གི་མེས་པོའི་ཕ་སར་འགྲོ་ངེས༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","བདག་གིས་སྔོན་ཆད་མདའ་གཞུ་དང་རལ་གྲིར་བརྟེན་ནས་ཨེ་མོར་མི་རིགས་ཀྱི་ལག་ནས་ཕྲོགས་པའི་ས་ཆ་དེ་དག་སྤུན་གཞན་རྣམས་ལའང་གནང་ཞིང་ཁྱོད་ལ་བགོ་སྐལ་གཅིག་ཇེ་མང་དུ་གནང་བ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ཡ་ཀོབ་ཀྱིས་རང་གི་བུ་རྣམས་བོས་ཏེ་འདི་སྐད༌དུ། བདག་གིས་མ་འོངས་པར་ཁྱོད་ཅག་ལ་འཕྲད་ངེས་པའི་དོན་རྣམས་སྨྲ་བའི༌ཕྱིར། ཁྱོད་རྣམས་ལྷན་དུ་འཛོམ་པར་གྱིས་ཞེས་སྨྲས་པ༌དང༌། ཡང་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ཡ་ཀོབ་ང་ཡི་བུ་རྣམས་ལྷན་དུ་འཛོམ་པར༌བྱ།། ཨ་ཕ་ཡེས་ར་ཨེལ་གྱི་གཏམ་ལ་མཉན་པར༌གྱིས།། ");
INSERT INTO bodn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","རུ་བེན་ཁྱོད་ནི་བདག་གི་བུ་ལས་སྐྱེས་འགོ༌སྟེ།། ང་རང་ལུས་སྟོབས་དར་བའི་དུས་སུ་སྐྱེས་པའི༌ཕྱིར།། ཁྱོད་ནི་མཆོག་དང་དབང་དང་ལྡན་པ་ཡིན་མོད༌ཀྱང༌།། ");
INSERT INTO bodn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ཁྱོད་ནི་ཆུ་ལྟར་རྒྱུགས་པས་གཞན་ལས་མཆོག་གྱུར༌མིན།། ཁྱོད་ནི་རང་གི་ཕ་ཡི་མལ་ཁྲིར་འགོས་པ༌དང༌།། ཁྱོད་ཀྱིས་བདག་གི་གཟིམ་ཁྲི་ཡེ་ནས་རྫོབ་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","སྤུན་ཆུང་སི་མུ་ཨོན་དང་ལེ་ཝི་གཉིས་ཀྱི༌ནི།། རལ་གྲི་ལ་སོགས་གདུག་རྩུབ་སྤྱོད་པའི་མཚོན་ཆ་ཡིན།། ");
INSERT INTO bodn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","བདག་གི་སེམས་ནི་ཁྱོད་ཀྱི་གྲོས་ལ་ཁས་ལེན༌མེད།། བདག་གི་ཡིད་སེམས་དེ་དག་དང་ནི་མཐུན་ཐབས༌མེད།། དེ་དག་ཁྲོ་ཞིང་སྡང་སྟེ་མི་རྣམས་བསད་པ༌དང༌།། དོན་མེད་གླང་ཐུག་བརླ་རྩ་བཅད་ཅིང་གཅོད་ཕྱིར༌རོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","དེ་རྣམས་ཞེ་སྡང་ཆེ་བས་སྡིགས་དམོད་འཕོག་འོས༌ཤིང༌།། དེ་རྣམས་གདུག་རྩུབ་ཆེ་བས་དམོད་པ་འཕོག་པར༌འགྱུར།། བདག་གིས་དེ་རྣམས་ང་ཡི་རིགས་ནང་འཐོར་བ༌དང༌།། ཡེས་ར་ཨེལ་གྱི་ཡུལ་གྲུ་ཀུན་ཏུ་གཏོར་བར༌བྱ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ཡ་ཧུ་དཱ་ཁྱོད་བདག་གི༌བུ།། ཁྱོད་ཀྱི་ལག་པས་དགྲ་བོ༌ཡི།། གཉའ་ནས་དམ་དུ་བཟུང་བའི༌ཕྱིར།། སྤུན་གཞན་གྱིས་ནི་ཁྱོད་ལ༌བསྟོད།། ཁྱོད་ལ་ཕ་ཡི་བུ་རྣམས༌ཀྱིས།། མགོ་བོ་བསྒུར་ནས་ཕྱག་འཚལ༌ལོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ཡ་ཧུ་དཱ་ཁྱོད་བདག་གི༌བུ།། ཁྱོད་ནི་སེང་ཕྲུག་ཇི་བཞིན༌དུ།། རི་དྭགས་བཟུང་ནས་འགྲོ་བར༌བྱེད།། འགྱིང་བའི་ཚེ་ན་ཕོ་སེང༌དང༌།། སྡོད་པའི་ཚེ་ན་མོ་སེང༌བཞིན།། སུ་ཡིས་ཁྱོད་རང་དཀྲོག་པར༌ཕོད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ཞི་ལོ་ཞེས་བྱར་གྲགས་པ་ཁོང་ཉིད་ཕེབས་པ༌དང༌།། མི་རིགས་ཀུན་གྱིས་ཁོང་གི་ངག་བཞིན་སྒྲུབ་པའི༌བར།། ཡ་ཧུ་དཱ་ལས་རྒྱལ་པོའི་མཁར་བ་མི་འཕྲོག༌ཅིང༌།། ཁོང་གི་རྐང་པའི་བར་ནས་མཁར་བ་འཆོར་མི༌སྲིད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ཡ་ཧུ་དཱ་ཡིས་རྒུན་འབྲུམ་ཤིང་ལ་མགྲིན་བཟང༌བཏགས།། མཛེས་ཤིང་མཆོག་གྱུར་རྒུན་འབྲུམ་ཤིང་ལ་བོང་ཕྲུག༌བཏགས།། རྒུན་འབྲུམ་ཆང་ལ་རང་གི་གྱོན་པ་བཀྲུ་བྱེད༌ཅིང༌།། རྒུན་འབྲུམ་ཁུ་བའི་ནང་དུ་གྱོན་གོས་གཙང་མར༌བཀྲུས།། ");
INSERT INTO bodn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ཁོ་ཡི་མིག་ཟུང་རྒུན་ཆང་གིས་ནི་དམར་པོར༌བསྒྱུར།། ཁ་ཡི་དུང་སོ་འོ་མས་དཀར་པོར་བསྒྱུར་ལགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ཟེ་བུ་ལུན་ནི་རྒྱ་མཚོའི་འགྲམ་དུ༌གནས།། མཚོ་འགྲམ་དེ་ནི་རྒྱ་མཚོའི་གྲུ་ཁ༌ལགས།། ཁོ་ཡི་མངའ་ཁོངས་ཚི་ཏུན་བར་དུ༌འཕེལ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ཡེས་སི་ཀཱར་ནི་བོང་བུ་རྒོད་པོ༌བཞིན།། ལུག་རའི་བར་དུ་སོས་དལ་བག་གིས༌ཉལ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ལྷིང་འཇགས་ཡུལ་དེ་ཤིན་ཏུ་ལེགས་པར༌འདོད།། གནས་ཡུལ་དེ་ནི་མཛེས་ཤིང་སྡུག་པར༌འདོད།། ལུས་པོ་སྨད་དུ་བསྒུར་ནས་ཁྲེས་པོ༌ཁུར།། གཞན་གྱི་གཡོག་ཏུ་གྱུར་པ་ཀྱེ་མ༌ཧོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","དཱན་ཞེས་བྱ་བས་ཡེས་ར་ཨེལ་གྱི་ཚོ་པ༌བཞིན།། རང་གི་འབངས་མི་ཀུན་ལ་ཁྲིམས་ཐག་གཅོད་པར༌བྱེད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","དཱན་ཞེས་བྱ་བ་ལམ་ཁའི་ལྕེ་གཉིས༌དང༌།། ལམ་དུ་མཆིས་པའི་ལྟོ་འགྲོ་དུག་ཅན༌བཞིན།། བཞོན་རྟའི་རྨིག་པ་ལ་ནི་སོ་བཏབ༌པས།། ཀག་གིས་ལངས་ཏེ་བཞོན་མཁན་ས་ལ༌ལྷུང༌།། ");
INSERT INTO bodn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","བླ་ན་མེད་པའི་དཀོན་མཆོག་ཡ་ཝཱེ༌ལགས།། བདག་གིས་ནམ་ཡང་ཁྱེད་ཀྱིས་སྐྱོབ་པར༌སྒུག ། ");
INSERT INTO bodn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","དགྲ་བོ་མྱུར་དུ་སླེབས་ནས་གཱ་རྡུར་རྒོལ་ན༌ཡང༌།། ཁོས་ཀྱང་ལམ་སང་དགྲ་བོར་རྒོལ་ཞིང་ཕ་མཐར་བསྐྲད། ། ");
INSERT INTO bodn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ཨ་ཤེར་ཞེས་པའི་བུ་ཡི་གནས་དེ༌རུ།། འབྲུ་རིགས་ཕུན་སུམ་ཚོགས་པ་ཡོད་པའི༌ཕྱིར།། རྒྱལ་པོ་རྣམས་ཀྱི་ཟས་སུ་འགྱུར་ངེས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ནཱབ་ཐ་ལི་ནི་རྙི་ལས་ཐར་བའི་ཤྭ་མོ༌བཞིན།། ཁོ་ཡིས་སྙན་ཞིང་འཇེབས་པའི་གཏམ་ནི་སྨྲ་བར༌བྱེད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ཡོ་སེབ་ཞེས་པ་ཤིང་ཏོག་སྨིན་པའི་འབྲས་བུ༌དང༌།། ཆུ་མིག་འགྲམ་དུ་འབྲས་བུ་ཐོགས་པའི་ཡལ་ག༌བཞིན།། དེ་ཡི་ཡལ་ག་བརྐྱངས་ཏེ་གྱང་ལས་བརྒལ་བར༌བྱེད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","མདའ་གཞུ་འཛིན་མཁན་གྱིས་ནི་གློ་བུར༌ཉིད།། ཁོ་ལ་རྒོལ་བར་བྱེད་ཅིང་མདའ་འཕངས༌ཏེ།། ཁོ་ལ་གནོད་པ་བཟོས་ཤིང་བཟོ་བར༌བྱེད།། ");
INSERT INTO bodn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","འོན་ཀྱང་ཡེས་ར་ཨེལ་གྱི་རྫི་བོ༌དང༌།། ཡེས་ར་ཨེལ་གྱི་ཕ་བོང་ཆེན་པོ༌སྟེ།། ཡ་ཀོབ་ཀྱི་ནི་སྟོབས་ལྡན་ཞེས་གྲགས༌པས།། ཡོ་སེབ་ལག་ཏུ་མདའ་གཞུ་དམ་དུ༌བཟུང༌།། ཁོ་ཡི་ལག་ཟུང་བརྟན་ཅིང་ལྡེམ་མྱུར༌ཆེ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","དེ་ཡང་ཁྱོད་ཀྱི་ཕ་ཡི་དཀོན་མཆོག༌གིས།། ཁྱོད་ལ་སྐྱབས་སུ་མཛད་ཅིང་མཛད་ལགས༌ཏེ།། ཀུན་དབང་ལྡན་པ་ཁོང་གིས་ནམ་མཁའ༌དང༌།། ས་གཞིར་ཁྱབ་པའི་བྱིན་རླབས་མཐའ་དག༌དང༌།། མངལ་ལྡན་ནུ་མའི་བྱིན་རླབས་གནང་བར༌འགྱུར།། ");
INSERT INTO bodn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ཁྱོད་ཀྱི་ཕ་ཡིས་གནང་བའི་བྱིན་རླབས༌ནི།། མེས་པོའི་བྱིན་རླབས་ལས་ཀྱང་བླ་ན༌འཕགས།། དེ་ནི་འཇིག་པ་མེད་པའི་རི་ཀླུང༌དང༌།། མུ་མཐའ་མེད་པའི་མཐའ་མཚམས་གང་དུ༌ཡང༌།། བྱིན་རླབས་དེ་དག་ཁྱོད་ལ་གནང་བར་ཤོག། སྤུན་ཟླའི་ཁྲོད་ནས་རྒྱལ་སྲས་སུ་གྱུར༌པ།། ཁྱོད་ཀྱི་སྤྱི་གཙུག་ལ་ནི་འབབ་གྱུར༌ཅིག། ");
INSERT INTO bodn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","པེན་ཡཱ་མེན་ནི་གདུག་རྩུབ་ཆེ་བའི་སྤྱང་ཀི༌བཞིན།། ཞོགས་པར་རི་དྭགས་བཟུང་སྟེ་བཟའ་བྱེད༌ཅིང༌།། མཚན་མོར་གཞན་ལས་ཕྲོགས་པ་བགོ་བར༌བྱེད། །ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","མི་དེ་ཐམས་ཅད་ནི་ཡེས་ར་ཨེལ་གྱི་ཚོ་པ་བཅུ་གཉིས་ཡིན༌ལ། དོན་དེ་དག་ནི་ཁོ་རྣམས་ཀྱི་ཕ་ཡིས་ཁོ་རྣམས་ལ་བྱིན་རླབས་གནང་བའི་སྐབས་སུ་སྨྲས་པའི་གཏམ་ཡང་ཡིན༌ཏེ། མི་རང་རང་ལ་བསྟུན་ནས་བྱིན་རླབས་གནང༌བའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","དེ་ནས་ཡང་ཡེས་ར་ཨེལ་གྱིས་རང་གི་བུ་རྣམས་ལ་འདི་ལྟར་གདམས༌པ། བདག་ནི་ཅུང་མི་འགོར་བར་རང་གི་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འགྲོའོ། །ཁྱོད་རྣམས་ཀྱིས་བདག་གི་བེམ་པོ་ནི་ཧེ་བི་མི་རིགས་ཀྱི་ཨེབ་རོན་གྱི་ཞིང་སར་ཡོད་པའི་བྲག་ཁུང་དུ་བདག་གི་མེས་པོ་དང་མཉམ་དུ་དུར་ལ་སྦ་བར༌བྱའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","བྲག་ཁུང་དེ་ནི་ཀ་ན་ཨན་ཡུལ་གྱི་མཱན་རེའེ་ས་ཆའི་མདུན་ཕྱོགས་ཀྱི་མཱག་ཕེ་ལཱའི་ཞིང་ནང་དུ་ཡོད༌ཅིང༌། བྲག་ཁུང་དེ་དང་ཞིང་ས་དེ་ནི་ཨབ་ར་ཧམ་གྱིས་ཧེ་བི་མི་རིགས་ཀྱི་ཨེབ་རོན་ནས་ཉོས་ཤིང་དུར་ས་བྱས་པ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","བྲག་ཁུང་དེ་རུ་ཨབ་ར་ཧམ་དང་ཁོང་གི་ཆུང་མ་སཱ་ར་གཉིས་ཀྱི་སྐུ་གདུང་དུར་ལ་བཅུག་པ༌དང༌། ཨི་སཱག་དང་ཡུམ་རིབ་ཀཱ་གཉིས་ཀྱི་སྐུ་གདུང་ཡང་བྲག་ཁུང་དེ་རུ་བཅུག༌པའོ། །ངས་རང་གི་ཆུང་མ་ལེ་ཨའི་བེམ་པོའང་གནས་དེ་རུ་དུར་ལ་བཅུག༌གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ཞིང་ས་དེ་དང་དེའི་ནང་དུ་ཡོད་པའི་བྲག་ཁུང་ནི་ཧེད་ཀྱི་བུ་རྒྱུད་ལས་ཉོས་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","དེ་ལྟར་ཡ་ཀོབ་ཀྱིས་བུ་རྣམས་ལ་ཁ་བསྒོ་གནང༌རྗེས། ཕྱིར་མལ་སར་ལྷུང་སྟེ་ཚེ་ལས་འདས་ཤིང་ཁོང་ཉིད་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་ཕྱིན༌ཏོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","དེ་ནས་ཡོ་སེབ་རང་གི་ཕ་ཡི་གདོང་ལ་སྦར་ཏེ་མྱ་ངན་གྱི་ངང་ནས་ངུས་ཤིང་ཕ་ལ་འོ་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ཡོ་སེབ་ཀྱིས་ཕ་ཡི་བེམ་པོར་དྲི་སྦྱོར་བྱེད་དགོས་ཚུལ་རང་ལ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཨམ་ཆིར་བཀའ་གནང་བ༌དང༌། ཨམ་ཆིས་ཀྱང་ཡེས་ར་ཨེལ་གྱི་བེམ་པོར་དྲི་སྦྱོར་བྱས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ཉིན་བཞི་བཅུའི་རིང་ལ་བེམ་པོར་སྤོས་ཆུ་དང་རྩྭ་སྨན་བྱུགས་ཤིང་རས་ཀྱིས་དཀྲིས་དགོས་པ༌དང༌། ཨེ་ཅིབ་མི་རིགས་ཀྱིས་ཉིན་བདུན་ཅུའི་རིང་ལ་མྱ་ངན་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","དེ་ནས་མྱ་ངན་གྱི་ཉིན་ལོངས་པ་དང་ཡོ་སེབ་ཀྱིས་ཕཱར་ཨོལ་གྱི་ཁྱིམ་མི་རྣམས་ལ་འདི༌ལྟར། གལ༌ཏེ། བདག་ལ་ཁྱོད་རྣམས་ཀྱི་མིག་མདུན་ནས་ཐུགས་རྗེ་ཐོབ༌ན་ཕཱར་ཨོལ་ལ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","བདག་གི་ཕ་ཚེ་ལས་འདའ༌ཁར། ཁོང་གིས་བདག་ལ་འདི་སྐད༌དུ། ང་རང་ད་ལྟ་འཆི་ལ༌ཉེ། ངས་ཀ་ན་ཨན་ཡུལ་དུ་རང་ལ་དུར་ས་བཟོས་ཡོད༌ལ། ཁྱོད་ཀྱིས་ངའི་བེམ་པོ་གནས་དེ་རུ་དུར་ལ་འཇུག་པར་གྱིས་ཞེས་བདག་ལ་དམ་བཅའ་འཇོག་ཏུ་བཅུག་ཡོད༌པས། ད་ལྟ་ཁྱེད་ཀྱིས་ང་རང་ཕ་ཡི་སྐུ་གདུང་དུར་ལ་འཇུག་ཏུ་འགྲོ་བར༌འཚལ། ཕྱིས་སུ་ང་རང་ཕྱིར་ཡོང་ངེས་ཡིན་ཞེས་ཞུ་བར་མཛོད་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ཕཱར་ཨོལ་ན༌རེ། སོང༌དང༌། ཁྱོད་ཀྱི་ཕ་ཡིས་ཁྱོད་ལ་ཇི་ལྟར་དམ་བཅའ་འཇོག་ཏུ་བཅུག་ཡོད་པ༌བཞིན། ཁྱོད་ཀྱིས་ཁོང་གི་བེམ་པོ་དུར་ལ་འཇུག་པར་གྱིས་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","དེ་ནས་ཡོ་སེབ་ཡར་ཕ་ཡི་བེམ་པོ་དུར་དུ་འཇུག་པར༌ཆས། ཁོ་དང་མཉམ་དུ་ཕཱར་ཨོལ་གྱི་བློན་པོ༌དང༌། རྒན༌པོ། ཨེ་ཅིབ་རྒྱལ་ཁབ་ཀྱི་རྒན་པོ་བཅས༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","9","གཞན༌ཡང༌། ཡོ་སེབ་ཀྱི་ཁྱིམ་མི་ཐམས་ཅད༌དང༌། ཁོའི་སྤུན་རྣམས༌དང༌། ཕ་ཡི་ནང་མི་རྣམས༌དང༌། ཤིང་རྟའི་དམག༌དང༌། སྐྱ་དམག་ཀྱང་སོང་བས་མི་གྲངས་ཤིན་ཏུ༌མང༌། ཁོ་རྣམས་ཀྱི་བུད་མེད༌དང༌། བྱིས༌པ། ར་ལུག༌གི་ཁྱུ། བ་གླང་གི་ཁྱུ་བཅས་གོ་ཤེན་ཡུལ་དུ་ལུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ཁོ་རྣམས་ཡོར་དན་གཙང་པོའི་ཕ་རོལ་གྱི་ཨ་ཐད་ཅེས་པའི་གཡུལ་ཁར་སླེབས་ཤིང་། མི་རྣམས་མྱ་ངན་གྱི་ངང་ནས་སྐད་གསང་མཐོན་པོས་ངུས་པ༌དང༌། ཡོ་སེབ་ཀྱང་གནས་དེ་ནས་ཉིན་བདུན་རིང་ལ་མྱ་ངན་གྱི་ངང་ནས་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ཀ་ན་ཨན་མི་རིགས་ཀྱི་ཡུལ་མི་རྣམས་ཀྱིས་ཨ་ཐད་གཡུལ་ཁའི་མྱ་ངན་གྱི་ངུ་སྐད་ཐོས་ཏེ་ན༌རེ། འདི་ནི་ཨེ་ཅིབ་མི་རིགས་ཀྱི་མྱ་ངན་ཆེན་པོ་ཞིག་གོ་ཞེས༌སྨྲས། དེའི༌ཕྱིར། གནས་དེའི་མིང་ལ་ཧ་བེལ་མུས་རཱ་ཡིམ་ཞེས་བཏགས༌ཤིང༌། དེ་ཡོར་དན་གཙང་པོའི་ཤར་ཕྱོགས་སུ་མཆིས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱིས་ཕ་ཡི་ཁ་ཆེམས་ལྟར་བསྒྲུབས༌ཤིང༌། ");
INSERT INTO bodn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ཁོང་གི་བེམ་པོ་ཀ་ན་ཨན་ཡུལ་གྱི་མཱན་རེའེ་ས་ཆའི་མདུན་ཕྱོགས་ཏེ་མཱག་ཕེ་ལཱའི་ཞིང་ནང་དུ་ཡོད་པའི་བྲག་ཁུང་དུ་དུར་ལ༌བཅུག བྲག་ཁུང་དེ་དང་ཞིང་ས་དེ་ནི་ཨབ་ར་ཧམ་གྱིས་ཧེ་བི་མི་རིགས་ཀྱི་ཨེབ་རོན་ལས་ཉོས་ཏེ་དུར་ས་བྱས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ཡོ་སེབ་ཀྱིས་ཕ་ཡི་བེམ་པོ་དུར་དུ་བཅུག༌རྗེས། རང་གི་སྤུན་དང་དུར་འཇུག་པ་གཞན་རྣམས་དང་མཉམ་དུ་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","དེ་ཡང་ཡོ་སེབ་ཀྱི་སྤུན་རྣམས་ཀྱིས་ཕ་ཚེ་ལས་འདས་པ་མཐོང་ནས་འདི༌ལྟར། ཡོ་སེབ་རང་ཅག་རྣམས་ལ་སྡང་སྲིད༌དེ། སྔོན་ཆད་རང་ཅག་གིས་ཁོ་ལ་གནོད་འཚེ་བྱས་མྱོང༌བས། ཁོས་ད་ལྟ་འཁོན་ལན་སློག་ངེས་ཡིན་ཞེས་སྨྲས་པ༌དང༌། ");
INSERT INTO bodn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","སྤུན་རྣམས་ཀྱིས་མི་ཞིག་ཡོ་སེབ་ཀྱི་དྲུང་དུ་མངགས༌ཏེ། ཕ་ཚེ་ལས་མ་འདས་པའི་སྔོན་ལ་ཁོང་གིས་ངེད་ཅག་ལ་འདི་སྐད༌དུ། ");
INSERT INTO bodn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ཁྱོད་ཅག་གིས་ཡོ་སེབ་ལ་འདི་ལྟར་སྨྲ་བར༌གྱིས། སྔོན་ཆད་སྤུན་རྣམས་ཀྱིས་ཁྱོད་ལ་གནོད་འཚེ་བྱས༌ཤིང༌། ཁྱོད་ཀྱིས་ཁོ་རྣམས་ཀྱི་སྡིག་ཉེས་ལ་གུ་ཡངས་གཏོང་བར་མཛོད་ཅིག་ཅེས་ཞུ་བ་བྱོས་ཤིག་ཅེས་སྨྲས་མྱོང༌ལ། ད་ལྟ་ཁྱོད་ཀྱིས་ཕ་ཡི་དཀོན་མཆོག་གི་ཞབས་ཕྱི་པ་ངེད་རྣམས་ཀྱི་ཉེས་སྐྱོན་ལ་གུ་ཡངས་གཏོང་བར་མཛོད་ཅིག་ཅེས་ངག་འཕྲིན༌བསྐུར། སྤུན་རྣམས་ཀྱིས་ཡོ་སེབ་ལ་དེ་ལྟར་སྐད་བསྐུར་བས་ཡོ་སེབ་ངུས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","དེ་ནས་ཡོ་སེབ་ཀྱི་སྤུན་རྣམས་ཁོའི་དྲུང་དུ་སླེབས་པ་དང་ལུས་པོ་སར་བཏུད་དེ་ན༌རེ། ངེད་ཅག་ཁྱོད་ཀྱི་ཞབས་ཕྱི་པ་ཡིན་ཞེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ཡོ་སེབ་ན༌རེ། ཁྱོད་རྣམས་འཇིགས་མི་དགོས༌ཏེ། བདག་གིས་དཀོན་མཆོག་གི་ཚབ་བྱེད་ག་ལ༌ནུས། ");
INSERT INTO bodn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","སྔོན་ཆད་ཁྱོད་ཅག་གིས་བདག་ལ་གནོད་པ་བྱེད་འདོད༌ནའང༌། དཀོན་མཆོག་གིས་ལས་བཟང་པོའི་ཕྱོགས་སུ་དགོངས༌ཏེ། མི་མང་པོ་ཞིག་གི་ཚེ་སྲོག་སྐྱོབ་པའི་ཕྱིར་ད་ལྟའི་རྣམ་པ་འདི་བྱུང་བ༌ཡིན། ");
INSERT INTO bodn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ད་ལྟ་ཁྱོད་རྣམས་འཇིགས་མི་དགོས༌ཏེ། ངས་ཁྱོད་ཅག་དང་ཁྱོད་རྣམས་ཀྱི་བུད་མེད་དང་བྱིས་པ་བཅས་གསོ་བར་བྱ་ཞེས་སྨྲས༌ཤིང༌། ཡོ་སེབ་ཀྱིས་སྙིང་ཉེ་བའི་གཏམ་གྱིས་སྤུན་རྣམས་ལ་སེམས་གསོ་བྱས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","དེ་ཡང་ཡོ་སེབ་དང་རང་གི་ཕ་ཡི་གཉེན་ཉེ་རྣམས་ཨེ་ཅིབ་ཡུལ་དུ་བཞུགས༌ཤིང༌། ཡོ་སེབ་བསྡོམས་པས་ལོ་བརྒྱ་དང་བཅུ་ལ་བཞུགས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ཡོ་སེབ་ཀྱིས་ཨེ་ཕཱར་ཡིམ་གྱི་མི་རབས་གསུམ་པའི་ཚ་བོ་རྣམས་མཐོང་ཐུབ་པར་གྱུར་པ༌དང༌། མཱ་ན་ཤེ་ཡི་བུ་མཱ་ཀིར་ཞེས་བྱ་བའི་བུ་རྣམས་ཀྱང་ཡོ་སེབ་ཀྱི་དྲུང་དུ་སྐྱེས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","དེ་ནས་ཡོ་སེབ་ཀྱིས་རང་གི་སྤུན་རྣམས་ལ་འདི་སྐད༌དུ། བདག་ནི་འཆི་ལ༌ཉེ། འོན་ཀྱང་དཀོན་མཆོག་གིས་ཁྱོད་རྣམས་ལ་གཟིགས་སྐྱོང་གནང་ངེས་པ༌དང༌། ཁྱོད་རྣམས་ཡུལ་འདི་ནས་ལམ་ལ་ཆས་ཏེ། ཁོང་གིས་དེ་སྔར་ཨབ་ར་ཧམ༌དང༌། ཨི༌སཱག ཡ་ཀོབ་བཅས་ལ་གནང་བར་མནའ་བཞེས་པའི་ཡུལ་དེར་འཁྲིད་ངེས་ཡིན་ཞེས་སྨྲས༌པའོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ཡང་ཡོ་སེབ་ཀྱིས་ཡེས་ར་ཨེལ་གྱི་བུ་རབས་ཚ་རྒྱུད་རྣམས་ལ་དམ་བཅའ་འཇོག་ཏུ་བཅུག་སྟེ་འདི་སྐད༌དུ། དཀོན་མཆོག་གིས་ཁྱོད་རྣམས་ལ་གཟིགས་སྐྱོང་མཛད་ངེས༌ཤིང༌། ཁྱོད་ཅག་གིས་བདག་གི་རུས་པ་ཡུལ་འདི་ནས་ཡར་འཁྱེར་བར་མཛོད་ཅིག་ཅེས་སྨྲས༌སོ།། ");
INSERT INTO bodn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","དེ་ལྟར་ཡོ་སེབ་དགུང་ལོ་བརྒྱ་དང་བཅུ་ལ་བཞུགས་ཏེ་སྐུ་གཤེགས་པ༌རེད། མི་རྣམས་ཀྱིས་ཁོང་གི་སྐུ་གདུང་ལ་དྲི་སྦྱོར་བྱས་ཏེ་ཨེ་ཅིབ་ཡུལ་ནས་སྤུར་སྒམ་ནང་དུ་བཞག༌གོ ། །། ");
INSERT INTO bodn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","དེ་ཡང་རང་རང་གི་ཁྱིམ་ཚང་དང་བཅས་ཡ་ཀོབ་དང་ལྷན་དུ་ཨེ་ཅིབ་ཡུལ་དུ་འོངས་པའི་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་ནི་གཤམ་དུ་བཀོད་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","རུ་བེན་དང་། སི་མུ་ཨོན། ལེ་ཝི། ཡ་ཧུ་དཱ། ");
INSERT INTO bodn_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ཡེས་སི་ཀཱར། ཟེ་བུ་ལུན། པེན་ཡཱ་མེན། ");
INSERT INTO bodn_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","དཱན། ནཱབ་ཐ་ལི། གཱ་རྡུ། ཨ་ཤེར་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ཡ་ཀོབ་ནས་བྱུང་བའི་མི་ཐམས་ཅད་ཀྱི་གྲངས་ཀ་ནི་བསྡོམས་པས་བདུན་ཅུ་ཡོད་ཅིང་། ཡོ་སེབ་སྔར་ནས་ཨེ་ཅིབ་ཡུལ་དུ་ཡོད་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","དེ་ནས་ཡོ་སེབ་དང་ཁོའི་སྤུན་ཐམས་ཅད་དང་མི་རབས་དེའི་མི་མཐའ་དག་ཤི་ཟིན་མོད། ");
INSERT INTO bodn_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","འོན་ཀྱང་། ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་རྒྱུད་དང་ལྡན་པར་གྱུར་ནས་གྲངས་ཀ་ཤིན་ཏུ་མང་པོར་འཕེལ་ཏེ་སྟོབས་ཧ་ཅང་ཆེ་བར་གྱུར་ནས་ཡུལ་གྲུ་དེར་བཀང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","དེ་ནས་ཡོ་སེབ་ལ་རྒྱུས་མི་མངའ་བའི་རྒྱལ་པོ་གསར་པ་ཞིག་བྱུང་ཞིང་། དེས་ཨེ་ཅིབ་ལ་དབང་བསྒྱུར་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","དེས་རང་གི་འབངས་མི་རྣམས་ལ། ལྟོས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་རང་ཅག་ལས་མང་ཞིང་སྟོབས་ཀྱང་རྒྱས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ཤོག་དང་། རང་ཅག་གིས་དེ་རྣམས་ལ་གཡོ་སྦྱོར་སྤེལ་བར་བྱའོ། །དེ་ལྟར་མ་བྱས་ན། ཁོ་རྣམས་ད་དུང་འཕེལ་བར་འགྱུར་ཞིང་། ཕྱིས་སུ་དམག་འཁྲུག་འདྲ་བྱུང་ན་དེ་དག་གིས་དགྲ་བོར་གྲོགས་བགྱིས་ནས་རང་ཅག་ལ་རྒོལ་ཏེ་ཡུལ་འདི་དང་འབྲལ་སྲིད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","དེའི་ཕྱིར། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་ཁོ་རྣམས་ལ་ཁྲེས་པོ་ལྕི་མོ་བཀལ་ནས་དྲག་གནོན་ཆེན་པོ་བྱ་ཆེད་ལས་རྒྱབ་པ་རྣམས་བསྐོས་ཤིང་། ཁོ་རྣམས་ཀྱིས་ཕཱར་ཨོལ་ལ་བང་མཛོད་གྲོང་ཁྱེར་ཕི་ཐོམ་དང་རཱ་ཨམ་སེའེ་གཉིས་བརྩིགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","འོན་ཀྱང་དེ་རྣམས་ལ་ཇི་ལྟར་དྲག་གནོན་བྱས་ནའང་དེ་ལས་མང་པོར་འཕེལ་ཞིང་ཕྱོགས་ཀུན་ཏུ་ཁྱབ་པས། ཨེ་ཅིབ་པ་རྣམས་ཡེས་ར་ཨེལ་པའི་རྐྱེན་གྱིས་འཇིགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བཙན་བཀོལ་ནས་ལས་ཀ་བྱེད་དུ་བཅུག་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","སོ་ཕག་དང་འཇིམ་པ་བཟོ་བའི་ལས་ཀ་ལྕི་མོ་དང་། ཞིང་ལས་སྣ་ཚོགས་བྱེད་དུ་བཅུག་ནས་ཁོ་རྣམས་ཀྱི་འཚོ་བ་སྡུག་ལ་སྦྱར་ཅིང་། ལས་ཀ་ཐམས་ཅད་ཀྱི་ཐད་ནས་ཁོ་རྣམས་ལ་གདུག་རྩུབ་སྤྱད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","དེ་ནས་ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོས་ཨིབ་རི་པའི་སྐྱེ་གཡོག་མ་ཤིབ་རཱ་དང་ཕུ་ཨ་བྱ་བ་གཉིས་ལ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ཁྱོད་ཅག་གིས་ཨིབ་རི་པའི་བུད་མེད་རྣམས་ལ་སྐྱེ་གཡོག་བྱེད་པའི་སྐབས་སུ་ཁོ་མོ་ཚོས་བཙའ་ཁྲིའི་སྟེང་ཕྲུ་གུ་བཙའ་དུས་ལྟོས་དང་། བུ་ཡིན་ན་སོད་ཅིག བུ་མོ་ཡིན་ན་འཚོ་བས་ཆོག་ཅེས་བཀའ་བསྒོས། ");
INSERT INTO bodn_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","འོན་ཀྱང་སྐྱེ་གཡོག་མ་རྣམས་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པས། ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོས་གནང་བའི་བཀའ་བཞིན་དུ་མ་བྱས་པར་བུ་རྣམས་ཀྱི་སྲོག་བསྐྱབས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོས་སྐྱེ་གཡོག་མ་རྣམས་བོས་ནས་འདི་ལྟར་དྲིས་པ་སྟེ། ཁྱོད་ཅག་གིས་བུ་རྣམས་ཀྱི་སྲོག་བསྐྱབས་པ་ཅི་ཡིན་ནམ་ཞེས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","སྐྱེ་གཡོག་མ་རྣམས་ཀྱིས་ཕཱར་ཨོལ་ལ། ཨིབ་རི་པའི་བུད་མེད་དང་ཨེ་ཅིབ་ཀྱི་བུད་མེད་རྣམས་མི་འདྲ་སྟེ། ཨིབ་རི་པའི་བུད་མེད་ཀྱི་ལུས་སྟོབས་ཆེ་བས་སྐྱེ་གཡོག་མ་ད་དུང་མ་སླེབས་གོང་དུ་བཙས་ཚར་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","དེའི་ཕྱིར། དཀོན་མཆོག་གིས་སྐྱེ་གཡོག་མ་རྣམས་ལ་བཀའ་དྲིན་མཛད་པ་དང་། ཡེས་ར་ཨེལ་གྱི་མི་རྣམས་ཀྱང་འཕེལ་ཞིང་ཤིན་ཏུ་དར་བར་གྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","སྐྱེ་གཡོག་མ་རྣམས་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པས་ཁོང་གིས་ཁོ་མོ་རྣམས་ལ་ཁྱིམ་གཞིས་མཛད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","དེ་ནས་ཕཱར་ཨོལ་གྱིས་རང་གི་འབངས་མི་རྣམས་ལ་འདི་ལྟར། ཨིབ་རི་པའི་བུ་གསར་སྐྱེས་རེ་རེ་ནཱ་ཡོལ་གཙང་པོར་གཡུགས་དང་། བུ་མོ་རྣམས་འཚོ་རུ་ཆུག་ཅེས་བཀའ་བབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","དེ་ཡང་ལེ་ཝིའི་རྒྱུད་ཀྱི་མི་ཞིག་སོང་ནས་ཚོ་པ་དེའི་བུ་མོ་ཞིག་ཆུང་མར་བླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","བུ་མོ་དེ་མངལ་དང་ལྡན་པར་གྱུར་ནས་བུ་ཞིག་སྐྱེས་ཤིང་། རང་གི་ཕྲུ་གུ་མཛེས་ཤིང་ལྟ་ན་སྡུག་པ་མཐོང་ནས་ཟླ་བ་གསུམ་ལ་སྦས་ནས་བཞག ");
INSERT INTO bodn_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ཕྱིས་སུ་སྦས་ཐབས་མ་བྱུང་བས་ཁོ་མོས་པ་པི་རཱའི་གཟེབ་ཅིག་བླངས་ཏེ་རྒྱ་སྐྱེགས་དང་ཐང་ཆུ་བསྐུས་ཤིང་། ཕྲུ་གུ་དེའི་ནང་དུ་བཞག་ནས་ནཱ་ཡོལ་གཙང་པོ་འགྲམ་གྱི་འདམ་རྩྭའི་གསེབ་ཏུ་བཞག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","བུ་དེའི་གཅེན་མོས་ཁོ་ལ་ཅི་ཞིག་འབྱུང་བར་བལྟ་བའི་ཕྱིར་རྒྱང་རིང་དུ་ལངས་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","དེ་ནས་ཕཱར་ཨོལ་གྱི་སྲས་མོ་ནཱ་ཡོལ་གཙང་པོའི་འགྲམ་ལ་ཁྲུས་བྱེད་དུ་འོངས་པ་དང་། ཁོ་མོའི་གཡོག་མོ་རྣམས་ཆུ་ཁར་སོང་བ་ལ། སྲས་མོས་འདམ་རྩྭའི་གསེབ་ལ་ཡོད་པའི་གཟེབ་དེ་མཐོང་ནས་གཡོག་མོ་ཞིག་ལེན་དུ་བཏང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ཁོ་མོས་གཟེབ་ཀྱི་ཁ་ཕྱེས་པ་ན་བུ་ཞིག་ཡོད་པ་མཐོང་ཞིང་། ལྟོས་དང་། བུ་དེ་ངུ་བཞིན་ཡོད་པར་སྙིང་རྗེ་སྐྱེས་ཏེ་འདི་ལྟར་སྨྲས་པ། འདི་ནི་ཨིབ་རི་པའི་ཕྲུ་གུ་ཞིག་ཡིན་འདུག་ཅེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","སྐབས་དེར། ཕྲུ་གུའི་གཅེན་མོས་ཕཱར་ཨོལ་གྱི་སྲས་མོ་ལ། ང་རང་སོང་སྟེ་ཁྱེད་ལ་ཨིབ་རི་པའི་བུད་མེད་རྣམས་ལས་ཉེ་བའི་མ་མ་ཞིག་བོས་ཏེ་བུ་འདིར་ནུ་མ་བསྣུན་པར་བྱའམ་ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ཕཱར་ཨོལ་གྱི་སྲས་མོས་ཁྱོད་སོང་ཞིག་ཅེས་བཀའ་གནང་བ་དང་། བུ་མོ་སོང་ནས་ཕྲུ་གུའི་ཨ་མ་བོས་ཡོང་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ཕཱར་ཨོལ་གྱི་སྲས་མོས་ཁོ་མོར། ཁྱོད་ཀྱིས་ཕྲུ་གུ་འདི་ཁྱེར་སོང་སྟེ་བདག་གི་དོན་དུ་ཁོ་ལ་ནུ་མ་སྣུན་དང་། ངས་ཁྱོད་ལ་གླ་ཆ་སྟེར་ཞེས་སྨྲས་པ་ན། ཁོ་མོས་ཕྲུ་གུ་ཁྱེར་ནས་ནུ་མ་བསྣུན། ");
INSERT INTO bodn_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","དེ་ནས་ཕྲུ་གུ་ནར་སོན་པ་ན་བུད་མེད་ཀྱིས་བུ་དེ་ཕཱར་ཨོལ་གྱི་སྲས་མོའི་རྩར་ཁྲིད་ནས་དེའི་གསོས་བུར་གྱུར་ཅིང་། སྲས་མོས་བྱིས་པའི་མིང་ལ་མོ་ཤེ་ཞེས་བཏགས་པ་སྟེ། བདག་གིས་ཁོ་རང་ཆུ་ལས་བླངས་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","དེའི་རྗེས་སུ་མོ་ཤེ་ལང་ཚོ་དར་ལ་བབས་པ་ན། ཕྱི་རོལ་ཏུ་རང་གི་སྤུན་ཟླ་རྣམས་ཀྱི་གམ་དུ་སོང་བ་དང་། དེ་དག་གིས་དཀའ་སྡུག་མྱོང་བཞིན་ཡོད་པ་མཐོང་ཞིང་། ཨེ་ཅིབ་པ་ཞིག་གིས་ཁོའི་སྤུན་ཟླ་ཨིབ་རི་པ་ཞིག་ལ་གཅར་རྡུང་བྱེད་པ་མཐོང་ནས། ");
INSERT INTO bodn_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","མོ་ཤེ་ཡིས་གཡས་གཡོན་ལ་བལྟས་ཤིང་སུ་ཡང་མ་མཐོང་བས། ཁོས་ཨེ་ཅིབ་པ་དེ་བསད་ནས་བྱེ་མའི་ནང་དུ་སྦས། ");
INSERT INTO bodn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","དེའི་ཕྱི་ཉིན་ཡང་ཁོ་རང་ཕྱི་རོལ་ཏུ་སོང་བ་ན། ལྟོས་དང་། ཨིབ་རི་པ་གཉིས་འཛིང་རེས་བྱེད་ཀྱིན་འདུག་པ་མཐོང་སྟེ། བརྙས་བཅོས་བྱེད་མཁན་དེ་ལ། ཁྱོད་ཀྱིས་ཅིའི་ཕྱིར་རང་གི་སྤུན་ཟླར་རྡུང་ངམ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","མི་དེ་ན་རེ། སུས་ཁྱོད་རང་ངེད་ཅག་གི་འགོ་དཔོན་ནམ་ཁྲིམས་དཔོན་དུ་བསྐོས་པ་ཡིན་ནམ། ཁྱོད་ཀྱིས་ཨེ་ཅིབ་པ་དེ་བཞིན་དུ་ང་རང་ཡང་གསོད་འདོད་དམ་ཞེས་སྨྲས་པས། མོ་ཤེ་འཇིགས་ནས་དོན་དེ་མི་གཞན་གྱིས་ཀྱང་དངོས་གནས་ཤེས་པ་འདྲ་སྙམ་མོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","དེ་ནས་ཕཱར་ཨོལ་གྱིས་དོན་དེ་ཐོས་ནས་མོ་ཤེ་གསོད་པར་བསམས་མོད། འོན་ཀྱང་མོ་ཤེ་ནི་ཕཱར་ཨོལ་ལས་བྲོས་ཏེ་མིད༌ཡཱན་ཡུལ་དུ་སོང་ནས་བསྡད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ཉིན་ཞིག་ཁོ་རང་ཁྲོན་པ་ཞིག་གི་གམ་དུ་སྡོད་དུས། མིད༌ཡཱན་ཡུལ་གྱི་མཆོད་དཔོན་ལ་བུ་མོ་བདུན་ཡོད་པ་རྣམས་ཕ་ཡི་ར་ལུག་གི་ཁྱུ་ལ་ཆུ་ལྡུད་པའི་ཕྱིར་ཆུ་ལེན་དུ་ཡོང་ཞིང་གཞོང་པ་རྣམས་ཆུས་གང་བར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","དུས་དེར་ལུག་རྫི་རྣམས་ཡོང་སྟེ་ཁོ་མོ་རྣམས་བདས། འོན་ཀྱང༌། མོ་ཤེ་ལངས་ནས་ཁོ་མོ་རྣམས་ལ་རོགས་བྱས་ཏེ་ཁོ་ཚོའི་ར་ལུག་གི་ཁྱུ་ལ་ཆུ་བླུད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","དེ་ནས་ཁོ་མོ་རྣམས་ཕ་རུའུ་ཨེལ་གྱི་གམ་དུ་འོངས་པ་ན། ཕ་ན་རེ། དེ་རིང་ཁྱོད་རྣམས་འདི་ཙམ་མགྱོགས་མྱུར་ངང་སླེབས་པའི་རྒྱུ་མཚན་ཅི་ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ཁོ་མོ་རྣམས་ན་རེ། ཨེ་ཅིབ་པ་ཞིག་གིས་ངེད་རྣམས་རྫི་བོ་སྐོར་ཞིག་གི་ལག་འོག་ནས་བསྐྱབས་པར་མ་ཟད། ད་དུང་ཆུ་བླངས་ནས་ར་ལུག་རྣམས་ལ་བླུད་བྱུང་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","དེ་ནས་ཕ་ཡིས་བུ་མོ་རྣམས་ལ། མི་དེ་གང་དུ་ཡོད་དམ། ཅིའི་ཕྱིར་ཁོ་རང་བསྐྱུར་བ་ཡིན་ནམ། ཁྱོད་རྣམས་སོང་ནས་ཁོ་རང་ཟས་ལ་རོལ་བར་བོས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","མོ་ཤེ་ནི་མི་དེ་དང་མཉམ་དུ་གནས་པར་དགའ་ཞིང་། མི་དེས་ཀྱང་རང་གི་བུ་མོ་ཚིབ་ཕའོ་རཱ་བྱ་བ་ཁོ་ལ་ཆུང་མར་གནང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ཚིབ་ཕའོ་རཱ་ལ་བུ་ཞིག་སྐྱེས་ཤིང་། མོ་ཤེ་ཡིས་བྱིས་པའི་མིང་ལ་གེར་ཤོམ་ཞེས་བཏགས་པ་སྟེ། ང་རང་ཡུལ་གཞན་དུ་བྱེས་པར་གྱུར་ཞེས་སྨྲས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","དེ་ནས་བགྲང་བྱ་མང་པོ་འདས་པ་ན་ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོ་སྐུ་གྲོངས་ཤིང་། ཡེས་ར་ཨེལ་པ་རྣམས་དཀའ་སྡུག་གིས་མནར་ཏེ་ཤུགས་རིང་འཐེན་ནས་ངུ་འབོད་བྱས་པ་དང་། ཁོ་རྣམས་ཀྱི་སྡུག་ཡུས་ཡར་དཀོན་མཆོག་གི་དྲུང་དུ་སླེབས། ");
INSERT INTO bodn_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","དཀོན་མཆོག་གིས་ཁོ་རྣམས་ཀྱི་སྡུག་ཡུས་གསན་ཅིང་། ཨབ་ར་ཧམ་དང་། ཨི་སཱག ཡ་ཀོབ་བཅས་ལ་བཞག་པའི་ཞལ་ཆད་ཐུགས་སུ་དྲན། ");
INSERT INTO bodn_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","དཀོན་མཆོག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གཟིགས་སྐྱོང་མཛད་ཅིང་ཁོང་གིས་དེ་རྣམས་ཀྱི་དཀའ་སྡུག་ཀྱང་མཁྱེན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","དེ་ཡང་མོ་ཤེ་ཡིས་མིད༌ཡཱན་ཡུལ་གྱི་མཆོད་དཔོན་ཏེ་རང་གི་སྒྱུག་པོ་ཡི་ཏྲོའི་ར་ལུག་གི་ཁྱུ་འཚོས་པ་དང་། ཉིན་ཞིག་ལ། ར་ལུག་གི་ཁྱུ་དེད་ནས་ཡུལ་དབེན་པའི་ཕ་རོལ་ཏུ་ཆས་ཤིང་། དཀོན་མཆོག་གི་རི་བོ་སྟེ་ཧོ་རེབ་ཅེས་པར་ཕྱིན། ");
INSERT INTO bodn_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","དུས་དེར་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ཞིག་ཚེར་ཕུང་དཀྱིལ་གྱི་མེ་ལྕེའི་ཁྲོད་ནས་མོ་ཤེ་ལ་མངོན་པར་གྱུར་ཏོ། །མོ་ཤེ་ཡིས་བལྟས་པ་ན། ཚེར་ཕུང་མེ་ལ་འབར་བཞིན་ཡོད་ནའང་མེས་འཚིག་པར་མ་གྱུར་པ་མཐོང་བས། ");
INSERT INTO bodn_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","མོ་ཤེའི་སེམས་ལ་ང་རང་ངོ་མཚཪ་ཆེན་པོ་དེ་ལ་བལྟ་རུ་འགྲོ་དགོས། ཚེར་ཕུང་འདི་མེ་ཡིས་མི་འཚིག་པའི་རྒྱུ་མཚན་ཅི་ཡིན་ནམ་སྙམ་མོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་ཚེར་ཕུང་ལ་བལྟ་རུ་འགྲོ་བ་གཟིགས་ཏེ། ཚེར་ཕུང་གི་དཀྱིལ་ནས་མོ་ཤེ་མོ་ཤེ་ཞེས་ཞལ་འབོད་གནང་བ་ལ། མོ་ཤེ་ཡིས་ང་རང་འདི་རུ་ཡོད་ཅེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","དེ་ནས་ཁོང་གིས་འདི་སྐད་དུ། ཉེ་སར་མ་འོང་ཞིག ཁྱོད་རང་ལངས་ནས་འདུག་ས་འདི་ནི་གནས་དམ་པ་ཡིན་པས། ཁྱོད་ཀྱིས་བསིལ་ལྷམ་ཕུད་ཅིག་ཅེས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ཡང་འདི་སྐད་དུ། བདག་ནི་ཁྱོད་ཀྱི་ཕ་ཡི་དཀོན་མཆོག་དང་། ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང་། ཨི་སཱག་གི་དཀོན་མཆོག་དང་། ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ཡིན་ཞེས་གསུངས་པ་ལ། མོ་ཤེ་ཡིས་དཀོན་མཆོག་ལ་བལྟ་བར་འཇིགས་པས་རང་གི་ངོ་གདོང་བཀབ། ");
INSERT INTO bodn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། བདག་གི་འབངས་མི་རྣམས་ཀྱིས་ཨེ་ཅིབ་ཡུལ་དུ་མྱངས་པའི་དཀའ་སྡུག་ནི་བདག་གིས་དངོས་སུ་མཐོང་ཞིང་། ཁོ་རྣམས་ཀྱིས་ལས་རྒྱབ་པའི་གཉའ་གནོན་དྲག་པོའི་རྐྱེན་གྱིས་སྡུག་ཡུས་བཏོན་པའང་བདག་གིས་ཐོས་ལ། བདག་གིས་སྔར་ནས་དེ་རྣམས་ཀྱི་སྡུག་བསྔལ་ཤེས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ད་ནི་བདག་མར་འོངས་ནས་ཁོ་རྣམས་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་ལག་འོག་ནས་ཐར་བར་བྱེད་ཅིང་། ཡུལ་དེ་ནས་ཡར་ཁྲིད་དེ། མཛེས་ཤིང་ཡངས་ལ་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་ཏེ། ཀ་ན་ཨན་པ་དང་། ཧེད་པ་དང་། ཨེ་མོར་པ་དང་། ཕེ་རེ་ཟི་པ་དང་། ཧེ་བི་པ་དང་། ཡེ་བུ་སི་པ་བཅས་ཀྱི་གནས་སུ་བསླེབ་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ལྟོས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྡུག་ཡུས་བདག་གི་རྣ་བར་སླེབས་ཤིང་། ངས་ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་ཁོ་རྣམས་ལ་ཇི་ལྟར་བརྙས་བཅོས་བྱས་པའང་མཐོང་བྱུང་བས། ");
INSERT INTO bodn_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ད་ནི་བདག་གིས་ཁྱོད་རང་ཕཱར་ཨོལ་གྱི་མདུན་དུ་མངགས་པར་བྱ་སྟེ། ཁྱོད་ནི་བདག་གི་འབངས་མི་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་འཁྲིད་དུ་སོང་ཞིག་ཅེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","འོན་ཀྱང་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ལ། ང་ནི་སུ་ཡིན་ནམ། ཕཱར་ཨོལ་དང་ངོ་འཕྲད་དུ་སོང་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་འཁྲིད་འོང་ནུས་སམ་ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","དཀོན་མཆོག་གིས་འདི་སྐད་དུ། ང་རང་ཁྱོད་དང་མཉམ་དུ་འགྲོགས་ངེས་ཤིང་། ཁྱོད་ཀྱིས་འབངས་མི་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཁྲིད་འོངས་པའི་རྗེས་སུ། ཁྱོད་རྣམས་ཀྱིས་རི་བོ་འདི་ནས་བདག་ལ་བསྙེན་བཀུར་བྱེད་ངེས་ལ། འདི་ནི་ངས་ཁྱོད་རང་མངགས་པའི་དཔང་རྟགས་ཡིན་ཞེས་བཀའ་གནང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ཡང་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ལ། ང་རང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་གམ་དུ་སོང་ནས་དེ་དག་ལ། ཁྱོད་ཅག་གི་ཕ་མེས་ཡང་མེས་ཀྱི་དཀོན་མཆོག་གིས་ང་རང་ཁྱོད་ཅག་གི་གམ་དུ་མངགས་པ་ཡིན་ཞེས་བརྗོད་པར་བྱ་ཞིང་། གལ་ཏེ་ཁོ་རྣམས་ཀྱིས་བདག་ལ་ཁོང་གི་མཚན་ལ་ཅི་ཟེར་ཞེས་དྲིས་ན། ངས་དེ་རྣམས་ལ་ཅི་ཟེར་རམ་ཞེས་ཞུས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ཡང་དཀོན་མཆོག་གིས་མོ་ཤེ་ལ། བདག་ནི་གཏན་དུ་གནས་པ་དེ་ཉིད་ཡིན་ཞེས་གསུངས་པ་དང་། ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲ་བར་བྱ་སྟེ། གཏན་དུ་བཞུགས་པ་ཁོང་ཉིད་ཀྱིས་ང་རང་ཁྱོད་ཅག་གི་གམ་དུ་མངགས་པ་ཡིན་སྨྲོས་ཤིག་ཅེས་གསུངས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ཡང་དཀོན་མཆོག་གིས་མོ་ཤེ་ལ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། ཁྱོད་ཅག་གི་ཕ་མེས་ཡང་མེས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་སྟེ། ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང་། ཨི་སཱག་གི་དཀོན་མཆོག་དང་། ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་གིས་ང་རང་ཁྱོད་རྣམས་ཀྱི་གམ་དུ་མངགས་པ་ཡིན་ཞེས་པའོ། །ཡ་ཝཱེ་ནི་ཇི་སྲིད་བར་དུ་བདག་གི་མིང་ཡིན་ཞིང་། དུས་རབས་ཀུན་ཏུ་ང་རང་དྲན་པའི་རྟེན་ཡང་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ཁྱོད་རང་སོང་ནས་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་བསྡུས་ཏེ་ཁོ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། ཁྱོད་ཅག་གི་ཕ་མེས་ཡང་མེས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་སྟེ། ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང་། ཨི་སཱག་གི་དཀོན་མཆོག་དང་། ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་བདག་ལ་མངོན་པར་མཛད་ཅིང་འདི་སྐད་དུ། བདག་གིས་དངོས་གནས་ཁྱོད་རྣམས་ལ་ལྟ་སྐྱོང་བྱས་པ་དང་། ཨེ་ཅིབ་ཡུལ་ནས་ཁྱོད་རྣམས་ལ་ཇི་ལྟར་བྱས་པའང་མཐོང་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་དཀའ་སྡུག་ལས་ཡར་ཁྲིད་དེ། ཀ་ན་ཨན་པ་དང་། ཧེད་པ་དང་། ཨེ་མོར་པ་དང་། ཕེ་རེ་ཟི་པ་དང་། ཧེ་བི་པ་དང་། ཡེ་བུ་སི་པ་བཅས་ཀྱི་ཡུལ་ཏེ། འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་དུ་འཁྲིད་པར་བྱ་ཞེས་བདག་གིས་སྨྲས་པ་ཡིན་ཞེས་སྨྲ་བར་གྱིས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","དེ་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་བཀའ་ལ་མཉན་ངེས་ཤིང་། ཁྱོད་དང་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོའི་མདུན་དུ་སོང་སྟེ་ཁོ་ལ་འདི་ལྟར། ཨིབ་རི་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་ངེད་རྣམས་ལ་ཕྲད་པ་དང་། ད་ནི་ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་བའི་ཕྱིར། ཞག་གསུམ་གྱི་ལམ་ལ་དབེན་སྟོང་དུ་འགྲོ་བར་གནོངས་ཞེས་སྨྲོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","འོན་ཀྱང་ཨེ་ཅིབ་རྒྱལ་པོ་ལ་མཐུ་ལྡན་ཕྱག་གིས་བསྐུལ་ཡང་ཁྱོད་རྣམས་འགྲོ་རུ་མི་འཇུག་པ་བདག་གིས་ཤེས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","དེའི་ཕྱིར། ངས་ལག་པ་བརྐྱངས་ནས་ཨེ་ཅིབ་པའི་ཁྲོད་དུ་བདག་གི་ངོ་མཚར་བའི་དོན་རྣམས་མཛད་དེ་ཡུལ་དེར་རྒོལ་བར་བྱེད་ཅིང་། དེའི་རྗེས་སུ་ཁོས་ད་གཟོད་ཁྱོད་རྣམས་འགྲོ་རུ་འཇུག་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ཁྱོད་རྣམས་ཡུལ་དེ་ནས་འགྲོ་བའི་དུས་སུ་ལག་ཟུང་སྟོང་བར་མི་འགྲོ་བའི་ཕྱིར་དུ། བདག་གིས་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་མདུན་དུ་མི་འདི་རྣམས་ལ་ཐུགས་རྗེ་འཐོབ་པར་བྱ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","བུད་མེད་སོ་སོས་རང་གི་ཁྱིམ་མཚེས་དང་། ཁོ་མོའི་ཁྱིམ་དུ་སྡོད་པའི་བུད་མེད་ལས་གསེར་ཆས་དང་དངུལ་ཆས། གྱོན་གོས་དག་སློང་ངེས་ཏེ། རང་གི་བུ་དང་བུ་མོ་རྣམས་ལ་བསྐོན་པའི་ཕྱིར་ཡིན་ལ། དེས་ན་ཁྱོད་ཅག་གིས་ཨེ་ཅིབ་པའི་ནོར་རྫས་ཕྲོགས་པ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","དེ་ཡང་མོ་ཤེ་ཡིས་འདི་ལྟར་ལན་ཞུས་པ་སྟེ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་བདག་ལ་ཡིད་མི་ཆེས་ཤིང་ངའི་གཏམ་ལའང་མཉན་མི་སྲིད་ལ། དཀོན་མཆོག་ཡ་ཝཱེ་ནི་ཁྱོད་ལ་མངོན་པར་མ་མཛད་ཅེས་སྨྲ་ངེས་ཡིན་ཞེས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱི་ལག་ཏུ་ཡོད་པ་དེ་ཅི་ཞེས་བཀའ་འདྲི་གནང་བ་ལ། ཁོས་འཁར་བ་ཡིན་ཞེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འཁར་བ་ས་ལ་ཕོངས་ཤིག་ཅེས་བཀའ་བསྩལ་པ་དང་། མོ་ཤེ་ཡིས་དེ་ས་ལ་འཕངས་པ་ན་སྦྲུལ་ཞིག་ཏུ་གྱུར་པས་ཁོ་བྲོས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ། ལག་པ་བརྐྱངས་ཏེ་སྦྲུལ་གྱི་མཇུག་མ་ཟུངས་དང། དེ་ནི་ཁྱོད་ཀྱི་ལག་ཏུ་སྔར་བཞིན་འཁར་བ་རུ་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས་ཤིང་། མོ་ཤེ་ཡིས་ལག་པ་བརྐྱངས་ནས་སྦྲུལ་དེ་བཟུང་བ་ལ་དེ་ཁོའི་ལག་ཏུ་ཕྱིར་འཁར་བ་རུ་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། དེའི་རྒྱུ་མཚན་ནི་ཁོ་རྣམས་ཀྱི་ཕ་མེས་ཡང་མེས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་སྟེ། ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང་། ཨི་སཱག་གི་དཀོན་མཆོག་དང་། ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ནི་ཁྱོད་ལ་མངོན་པར་གྱུར་པ་ལ་ཁོ་རྣམས་ཡིད་ཆེས་སུ་འཇུག་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ། ལག་པ་རུམ་དུ་ཆུག་ཅེས་གསུངས་པ་དང་། ཁོས་ཀྱང་ལག་པ་རུམ་དུ་བཅུག་ནས་ཕྱིར་ཕྱུང་བ་ན། བསམ་ཡིད་ལས་འདས་པ་ཞིག་ལ། ལག་པར་མཛེ་ནད་བྱུང་སྟེ་ཁ་བའི་མདོག་ལྟར་དཀར་པོར་གྱུར་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ཡང་ཁྱོད་ཀྱི་ལག་པ་རུམ་དུ་ཆུག་ཅེས་གསུངས་པ་དང་། ཁོས་ཀྱང་ལག་པ་རུམ་དུ་བཅུག་ནས་ཕྱིར་ཕྱུང་བ་ན། བསམ་ཡིད་ལས་འདས་པ་ཞིག་ལ། ལག་པ་སྔར་བཞིན་གྱུར་ཅིང་ལུས་སྟེང་གི་ཤ་དང་གཅིག་འདྲ་བྱུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ཡང་དཀོན་མཆོག་གིས་འདི་སྐད་དུ། གལ་སྲིད་དེ་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་བཀའ་ལ་མི་མཉན་པ་དང་། གྲུབ་རྟགས་དང་པོར་ཡིད་མ་ཆེས་ན། ཁོ་རྣམས་གྲུབ་རྟགས་གཉིས་པར་ཡིད་ཆེས་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","འོན་ཀྱང་དེ་རྣམས་གྲུབ་རྟགས་འདི་གཉིས་པོར་ཡིད་མི་ཆེས་ཤིང་ཁྱོད་ཀྱི་བཀའ་ལའང་མི་མཉན་ན། ཁྱོད་ཀྱིས་ནཱ་ཡོལ་གཙང་པོ་ནས་ཆུ་ཉུང་ཙམ་བླངས་ཏེ་སྐམ་ས་རུ་གཏོར་ཅིག ཁྱོད་ཀྱིས་གཙང་པོ་ནས་བླངས་པའི་ཆུ་ནི་སྐམ་ས་རུ་ཁྲག་ཏུ་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ཡང་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། ཀྱེ་གཙོ་བོ་ལགས། ང་ནི་མ་གཞི་ནས་སྨྲ་བརྗོད་ལ་མཁས་པ་ཞིག་མིན་ཏེ། ཁྱེད་ཀྱིས་རང་གི་ཞབས་ཕྱི་བདག་ལ་བཀའ་གནང་བའི་རྗེས་སུའང་འདི་ལྟར་ཡིན་ལ། ང་ནི་མ་གཞི་ནས་སྨྲ་ལྕེ་རྟུལ་པོ་ཞིག་ཡིན་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་འདི་སྐད་དུ། མི་རྣམས་ཀྱི་ཁ་ནི་སུས་བཟོས་པ་ཡིན་ནམ། ཡང་སུ་ཞིག་གིས་མི་རྣམས་ལྐུགས་པའམ་ཡང་ན་འོན་པ། མིག་གསལ་བའམ་ཡང་ན་ལོང་པ་སོགས་སུ་བྱས་སམ། དེ་ནི་ཡ་ཝཱེ་ང་རང་མ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ད་ལྟ་སོང་དང་། བདག་གིས་ཁྱོད་ལ་སྨྲ་ལྕེ་སྦྱིན་ཞིང་ཁྱོད་ཀྱིས་ཅི་ཞིག་སྨྲ་འོས་པ་དེ་སྟོན་ངེས་ཡིན་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","མོ་ཤེ་ན་རེ། གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་སུ་ཞིག་མངག་འདོད་ན་དེ་ཉིད་མངག་པར་བྱའོ་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་ཉིད་མོ་ཤེ་ལ་ཐུགས་ཁྲོས་ཏེ་འདི་སྐད་དུ། ལེ་ཝི་པ་ཨ་རོན་ཁྱོད་ཀྱི་གཅེན་པོ་མ་ཡིན་ནམ། ཁོ་ནི་སྨྲ་བརྗོད་ལ་མཁས་པ་ཞིག་ཡིན་པ་ངས་ཤེས་ཤིང་། ད་ལྟ་ཁོ་རང་ཁྱོད་བསུ་བར་ཡོང་བཞིན་ཡོད་དེ། ཁོས་ཁྱོད་རང་མཐོང་བ་དང་སྙིང་ནས་དགའ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ཁྱོད་ཀྱིས་གཏམ་དེ་ཨ་རོན་ལ་སྨྲ་དགོས་ཤིང་། བདག་གིས་ཀྱང་ཁྱོད་གཉིས་ལ་སྨྲ་ལྕེ་སྦྱིན་ཏེ། ལས་ཅི་བྱེད་དགོས་པའང་སྟོན་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ཁོས་ཁྱོད་ཀྱི་ཚབ་ཏུ་འབངས་མི་རྣམས་ལ་གཏམ་སྨྲ་དགོས་ཤིང་། ཁྱོད་ཀྱིས་ཁོ་ནི་རང་གི་ཁ་བཞིན་དུ་བྱེད་པ་དང་། ཁོས་ཁྱོད་ནི་དཀོན་མཆོག་ལྟ་བུར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","གྲུབ་རྟགས་སྟོན་པའི་ཕྱིར་ཁྱོད་ཀྱིས་འཁར་བ་འདི་ལག་ཏུ་ཟུངས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","དེ་ནས་མོ་ཤེ་རང་གི་སྒྱུག་པོ་ཡི་ཏྲོའི་དྲུང་དུ་ཕྱིར་ལོག་སྟེ་ཁོ་ལ། ཨེ་ཅིབ་ཡུལ་དུ་ཡོད་པའི་སྤུན་རྣམས་གསོན་མིན་ལ་བལྟ་བའི་ཕྱིར། ང་རང་དེ་དག་གི་གམ་དུ་འགྲོ་རུ་འཇུག་པར་མཛོད་ཅེས་སྨྲས་པ་ལ། ཡི་ཏྲོས་མོ་ཤེ་ལ། ཁྱོད་རང་བདེ་བར་སོང་ཞིག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","དཀོན་མཆོག་ཡ་ཝཱེས་མིད༌ཡཱན་ཡུལ་དུ་མོ་ཤེ་ལ་འདི་སྐད་དུ། ད་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་ཅིག་དང་། ཁྱོད་རང་གསོད་འདོད་པའི་མི་ཐམས་ཅད་ཤི་ཟིན་པས་ཁྱོད་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་དང་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","མོ་ཤེ་ཡིས་རང་གི་ཆུང་མ་དང་བུ་གཉིས་ཁྲིད་ཅིང་། ཁོ་རྣམས་བོང་བུར་བསྐྱོན་ནས་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་པ་དང་། ཁོའི་ལག་ཏུ་དཀོན་མཆོག་གི་འཁར་བ་ཐོགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་རང་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་རྗེས། ངས་ཁྱོད་ལ་བསྟན་པའི་དོན་ངོ་མཚར་ཅན་ཐམས་ཅད་ཕཱར་ཨོལ་གྱི་མདུན་དུ་སྟོན་པར་གཟབ་གཟབ་གྱིས། འོན་ཀྱང་བདག་གིས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་བྱས་པས་ཁོས་འབངས་མི་རྣམས་འགྲོ་རུ་འཇུག་མི་སྲིད། ");
INSERT INTO bodn_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","དེ་ནས་ཁྱོད་ཀྱིས་ཕཱར་ཨོལ་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་ནི་བདག་གི་སྲས་ཐོག་མ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","བདག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་བདག་གི་སྲས་འགྲོ་རུ་ཆུག་ཅེས་ངས་ཁྱོད་ལ་སྨྲས་མྱོང་ནའང་། ཁྱོད་ཀྱིས་ཁོ་རང་འགྲོ་རུ་མ་བཅུག་པས། ལྟོས་དང་། ངས་ཁྱོད་ཀྱི་བུ་ཐོག་མ་གསོད་པར་བྱ་གསུངས་ཞེས་སྨྲོས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","དེ་ནས་ལམ་ལ་ཞག་སྡོད་བྱེད་པའི་གནས་ཤིག་ཏུ་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཕྲད་དེ་ཁོ་རང་གསོད་རྩིས་བྱས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ཚིབ་ཕའོ་རཱས་མེ་ཆ་ཞིག་བླངས་ནས་རང་གི་བུའི་མཚན་སྐྱི་བཅད་དེ་མོ་ཤེའི་རྐང་པའི་མདུན་དུ་འཕངས་ཏེ་ན་རེ། ཁྱོད་ནི་དངོས་གནས་ངའི་ཁྲག་གི་མག་པ་ཡིན་འདུག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ད་གཟོད་ཁོ་རང་སྲོག་ཐར་བཏང་ཞིང་། ཚིབ་ཕའོ་རཱས་ཁྱོད་ནི་མཚན་སྐྱི་བཅད་པའི་ཕྱིར་ཁྲག་གི་མག་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་རོན་ལ་འདི་སྐད་དུ། ཁྱོད་རང་དབེན་སྟོང་དུ་མོ་ཤེ་བསུ་བར་སོང་ཞིག་ཅེས་བཀའ་གནང་བ་དང་། ཨ་རོན་སོང་ནས་དཀོན་མཆོག་གི་རི་བོ་ནས་མོ་ཤེ་དང་ཕྲད་དེ་འགྲམ་པར་འོ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་མངགས་ཤིང་རང་ལ་བཀའ་ཅི་གནང་བ་ཐམས་ཅད་དང་། གྲུབ་རྟགས་གང་དག་སྟོན་དགོས་པ་ཐམས་ཅད་ཨ་རོན་ལ་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","དེར་མོ་ཤེ་དང་ཨ་རོན་གཉིས་སོང་ནས་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་ཐམས་ཅད་བསྡུས་ནས། ");
INSERT INTO bodn_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གསུངས་པའི་བཀའ་ཐམས་ཅད་ཨ་རོན་གྱིས་ཐེངས་གཅིག་ལ་སྨྲས་པ་དང་། ཡང་མི་རྣམས་ཀྱི་མིག་འདུན་དུ་གྲུབ་རྟགས་བསྟན་པས། ");
INSERT INTO bodn_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","འབངས་མི་རྣམས་ཡིད་ཆེས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཐུགས་བརྩེ་དགོངས་ཤིང་། ཁོ་རྣམས་ཀྱི་སྡུག་བསྔལ་ཡང་གཟིགས་པས། ཁོ་རྣམས་ཀྱིས་མགོ་བོ་བཏུད་ནས་ཕྱག་བཙལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","དེའི་རྗེས་སུ་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཕཱར་ཨོལ་གྱི་གམ་དུ་སོང་ནས་འདི་ལྟར། ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། བདག་གི་འབངས་མིས་དབེན་སྟོང་ནས་བདག་ལ་དུས་ཆེན་བསྲུང་བའི་ཕྱིར་དེ་རྣམས་འགྲོ་རུ་ཆུག་ཅེས་གསུངས་བྱུང་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ཕཱར་ཨོལ་ན་རེ། དཀོན་མཆོག་ཡ༌ཝཱེ་ནི་སུ་ཡིན་ནམ། ངས་ཅིའི་ཕྱིར་ཁོའི་བཀའ་ལ་མཉན་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་འགྲོ་རུ་འཇུག་དགོས་སམ། ངས་ཡ་ཝཱེ་མི་ཤེས་ལ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱང་མི་གཏོང་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","དེ་ནས་ཁོ་གཉིས་ན་རེ། ཨིབ་རི་པའི་དཀོན་མཆོག་ནི་ངེད་ཅག་ལ་ཕྲད་མྱོང་བ་ཡིན། ཁོང་གིས་རིམས་ནད་དམ་རལ་གྲི་ཡིས་རང་ཅག་མི་འགེམ་པའི་ཕྱིར། ངེད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་བར་ཞག་མ་གསུམ་གྱི་ལམ་ལ་དབེན་སྟོང་དུ་འགྲོ་རུ་འཇུག་པར་མཛོད་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ཨེ་ཅིབ་ཀྱི་རྒྱལ་པོས་འདི་ལྟར། མོ་ཤེ་དང་ཨ་རོན་ཁྱོད་གཉིས་ཀྱིས་ཅིའི་ཕྱིར་མི་དེ་རྣམས་ལ་ལས་བྱོལ་བྱེད་དུ་འཇུག་གམ། ཁྱོད་རྣམས་རང་གི་ལས་ཀ་བྱེད་དུ་སོང་ཞིག་ཅེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ཡང་འདི་ལྟར། ད་ལྟ་ཡུལ་འདིའི་མི་རྣམས་ཀྱི་གྲངས་ཀ་ནི་ཤིན་ཏུ་མང་ནའང་། ཁྱོད་གཉིས་ཀྱིས་དེ་རྣམས་ལ་ལས་ཀ་མི་བྱེད་པར་སྡོད་དུ་འཇུག་གམ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ཉིན་དེར། ཕཱར་ཨོལ་གྱིས་མི་རྣམས་ཀྱི་ལས་རྒྱབ་པ་དང་ལས་དཔོན་རྣམས་ལ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","ཁྱོད་ཅག་གིས་མི་རྣམས་ལ་སྔར་བཞིན་སོ་ཕག་བཟོ་བར་རྩྭ་མ་སྟེར་ཅིག ཁོ་རྣམས་རང་ཉིད་རྩྭ་འཐུ་རུ་འགྲོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","འོན་ཀྱང་མི་རྣམས་ཀྱིས་སྔར་ནས་སོ་ཕག་ཇི་ཙམ་བཟོས་པ་དེ་ཙམ་ཁྱོད་ཅག་གིས་ཁོ་རྣམས་ལ་བཀལ་ནས། ཏོག་ཙམ་ཡང་ཇེ་ཉུང་དུ་མ་གཏོང་ཞིག ཅིའི་ཕྱིར་ཞེ་ན། དེ་དག་ནི་སྒྱིད་ལུག་ཡིན་པས། ངེད་རྣམས་རང་གི་དཀོན་མཆོག་ལ་མཆོད་པ་འབུལ་དུ་འགྲོ་བར་མཛོད་ཅེས་སྐད་ཅོར་རྒྱག་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ཁྱོད་ཅག་གིས་མི་འདི་དག་གི་ལས་ཚགས་ཇེ་ལྗིད་དུ་བཏང་ནས། ཁོ་རྣམས་ལ་དཀའ་ལས་མྱང་དུ་བཅུག་སྟེ་རྫུན་གཏམ་ལ་མི་མཉན་པར་བྱེད་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","དེ་ནས་མི་རྣམས་ཀྱི་ལས་རྒྱབ་པ་དང་ལས་དཔོན་རྣམས་སོང་ནས་མི་རྣམས་ལ་འདི་ལྟར། ཕཱར་ཨོལ་གྱིས་འདི་སྐད་དུ། ངས་ཁྱོད་ཅག་ལ་རྩྭ་ནི་མི་སྟེར། ");
INSERT INTO bodn_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ཁྱོད་རྣམས་རང་རང་གིས་གང་དུ་རྩྭ་རྙེད་ཐུབ་ན་དེ་རུ་བཙལ་དུ་སོང་། འོན་ཀྱང་ཁྱོད་ཅག་གི་ལས་ཀ་ཏོག་ཙམ་ཡང་ཉུང་དུ་གཏོང་མི་རུང་གསུངས་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","དེ་ནས་མི་དེ་རྣམས་ཨེ་ཅིབ་ཡུལ་ཀུན་ཏུ་ཐོར་ནས་སོག་མ་བཏུས་ཏེ་རྩྭ་རུ་བྱས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ལས་རྒྱབ་པ་རྣམས་ཀྱིས་ཚ་འདེད་བྱས་ཏེ་ན་རེ། ཁྱོད་རྣམས་ཀྱིས་ཉིན་རེ་བཞིན་ལས་ཀ་བསྒྲུབས་ཚར་དགོས་ལ། དེ་སྔར་རྩྭ་ཡོད་པའི་དུས་བཞིན་བསྒྲུབ་དགོས་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ཡང་ཕཱར་ཨོལ་མངའ་འོག་གི་ལས་རྒྱབ་པ་རྣམས་ཀྱིས་སྔར་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ལས་རྒྱབ་པར་བསྐོས་པའི་ལས་དཔོན་རྣམས་ལ་རྡུང་རྡེག་བྱས་ཏེ་ན་རེ། ཁྱོད་ཅག་གིས་ཁ་སང་དེ་རིང་སྔོན་ཆད་ཀྱི་གྲངས་ཀ་ལྟར་སོ་ཕག་མ་བཟོས་པ་དང་རང་གི་ལས་ཀ་བསྒྲུབས་མ་ཚར་བ་ཅི་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","དེ་ནས་ཡེས་ར་ཨེལ་པའི་ལས་འཛིན་པ་རྣམས་ཕཱར་ཨོལ་གྱི་དྲུང་དུ་འོངས་ཏེ་སྐད་ཆེན་པོས། ཁྱེད་ཀྱིས་རང་གི་བྲན་གཡོག་རྣམས་ལ་འདི་ལྟར་བྱེད་དོན་ཅི། ");
INSERT INTO bodn_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ཁྱེད་ཀྱི་བྲན་གཡོག་རྣམས་ལ་རྩྭ་མ་བྱིན་ཡང་ལས་རྒྱབ་པས་ངེད་ཅག་ལ་སོ་ཕག་བཟོས་ཤིག་ཅེས་ཡང་ཡང་བསྐུལ་ཞིང་། ལྟོས་དང་། ཁྱེད་ཀྱི་བྲན་གཡོག་རྣམས་ལ་རྡུང་རྡེག་ཀྱང་ཐེབས། དོན་དམ་དུ་དེ་ནི་ཁྱེད་ཀྱི་འབངས་མི་རྣམས་ཀྱི་ཉེས་སྐྱོན་ཡིན་ཞེས་ཞུས་ཀྱང་། ");
INSERT INTO bodn_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ཕཱར་ཨོལ་ན་རེ། ཁྱོད་ཅག་ནི་དངོས་གནས་ལེ་ལོ་ཅན་ཡིན་འདུག དེ་བས་ཁྱོད་རྣམས་ཀྱིས་ངེད་ཅག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་དུ་འགྲོ་བར་མཛོད་ཅེས་ཟེར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ད་ནི་ཁྱོད་རྣམས་ལས་ཀ་བྱེད་དུ་སོང་ཞིག ཁྱོད་ཅག་ལ་རྩྭ་མི་སྟེར་ནའང་སོ་ཕག་ནི་གྲངས་ཀ་ལྟར་སྤྲོད་དགོས་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ཡེས་ར་ཨེལ་པའི་ལས་འཛིན་པ་རྣམས་ཀྱིས། ཁྱོད་ཅག་གིས་ཉིན་རེ་བཞིན་སོ་ཕག་བཟོ་བའི་ལས་ཀ་ནི་ཏོག་ཙམ་ཡང་ཉུང་དུ་གཏོང་མི་རུང་ཞེས་པའི་བཀའ་ཐོས་པས། དོན་ངན་ཞིག་དང་ཕྲད་པ་ཤེས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ཡང་ཁོ་རྣམས་ཕཱར་ཨོལ་གྱི་དྲུང་ནས་སོང་བ་ལ། མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་ལངས་ནས་སྒུག་བསྡད་ཡོད་པ་དང་ཕྲད་པས། ");
INSERT INTO bodn_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ཁོ་གཉིས་ལ་འདི་ལྟར། ཁྱོད་གཉིས་ཀྱིས་ཕཱར་ཨོལ་དང་དེའི་འཁོར་གཡོག་གི་མདུན་དུ་ངེད་རྣམས་དྲི་ངན་པར་བྱས་ཤིང་། ངེད་ཅག་གསོད་པའི་ཕྱིར་དེ་དག་གི་ལག་ཏུ་རལ་གྲི་བཞག་པས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་གཉིས་ལ་དཔྱད་ཞིབ་གནང་ནས་ཤན་འབྱེད་པར་ཤོག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","དེ་ནས་མོ་ཤེ་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ལོག་སྟེ་འདི་ལྟར། ཀྱེ་གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་ཅིའི་ཕྱིར་མི་འདི་རྣམས་དཀའ་སྡུག་ལ་སྦྱར་བ་ཡིན་ནམ། ཅིའི་ཕྱིར་ང་རང་མངགས་པ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ཡང་ང་རང་ཕཱར་ཨོལ་གྱི་གམ་དུ་སོང་སྟེ་ཁྱེད་ཀྱི་མཚན་ལ་བརྟེན་ནས་གཏམ་སྨྲས་པའི་དུས་ནས་བཟུང་། ཁོས་མི་འདི་རྣམས་དཀའ་སྡུག་ལ་སྦྱར་ཞིང་། ཁྱེད་ཀྱིས་ཁོ་རྣམས་སྐྱོབ་པར་གཏན་ནས་མ་མཛད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ངས་ཕཱར་ཨོལ་ལ་ཅི་བྱེད་པ་དེ་ཁྱོད་ཀྱིས་ད་ལྟ་མཐོང་བར་འགྱུར། བདག་གི་མཐུ་ལྡན་ལག་པའི་རྐྱེན་གྱིས་ཁོས་ཡེས་ར་ཨེལ་པ་རྣམས་འགྲོ་རུ་འཇུག་པར་མ་ཟད། དེ་རྣམས་ཁོའི་ཡུལ་གྱི་ཕྱི་རུ་སྐྲོད་པར་འགྱུར་ཞེས་གསུངས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","དཀོན་མཆོག་གིས་ཡང་མོ་ཤེ་ལ་འདི་སྐད་དུ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","བདག་ནི་ཀུན་དབང་དཀོན་མཆོག་ཡིན་པ་སྔར་ཨབ་ར་ཧམ་དང་ཨི་སཱག་དང་ཡ་ཀོབ་བཅས་ལ་མངོན་པར་བྱས་པ་ཡིན་མོད། འོན་ཀྱང་བདག་གི་མིང་ཡ་ཝཱེ་ཞེས་པ་དེ་ལས་ངས་རང་ཉིད་ཁོ་རྣམས་ལ་མངོན་པར་མ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","བདག་གིས་ཁོ་རྣམས་བྱེས་སུ་སྡོད་སའི་ཀ་ན་ཨན་ཡུལ་དེ་ཁོ་རྣམས་ཀྱི་དབང་དུ་གཏོང་བར་བྱེད་པའི་ཁ་ཆད་ཀྱང་དེ་རྣམས་ལ་བཞག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","དེ་མིན་ཨེ་ཅིབ་པས་ཡེས་ར་ཨེལ་པ་རྣམས་ཚེ་གཡོག་ཏུ་བཀོལ་བས། དེ་དག་གིས་བཏོན་པའི་སྡུག་ཡུས་བདག་གིས་ཐོས་ཤིང་། རང་གི་ཁ་ཆད་ཀྱང་དྲན་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","དེ་བས་ན་ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟརཤོད་དང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ཏེ། བདག་གིས་ཁྱོད་རྣམས་ཨེ་ཅིབ་པའི་གཉའ་གནོན་འོག་ནས་འདོན་པ་དང་། དེ་དག་གི་ཚེ་གཡོག་བྱེད་པ་ལས་སྒྲོལ་ཞིང་། ཕྱག་བརྐྱངས་ནས་དེ་རྣམས་ལ་ཉེས་ཆད་དྲག་པོ་གཅོད་པའི་སྒོ་ནས་ཁྱོད་ཅག་བླུ་བར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","བདག་གིས་ཁྱོད་རྣམས་ང་ཡི་འབངས་མི་བྱེད་ཅིང་། བདག་ཀྱང་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་བྱེད་རྒྱུ་ཡིན། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པ་དང་། ཁྱོད་རྣམས་ཨེ་ཅིབ་པའི་གཉའ་གནོན་འོག་ནས་ཐར་དུ་འཇུག་མཁན་ཡིན་པ་ཁྱོད་རྣམས་ཀྱིས་ཤེས་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","བདག་གིས་ཨབ་ར་ཧམ་དང་། ཨི་སཱག་དང་། ཡ་ཀོབ་བཅས་ལ་སྦྱིན་པར་མནའ་བསྐྱལ་ནས་ཁས་བླངས་པའི་ཡུལ་དེར་ཁྱོད་རྣམས་འཁྲིད་པ་དང་། ཡུལ་དེ་ཁྱོད་རྣམས་ལ་ཐོབ་སྐལ་དུ་སྦྱིན་པར་བྱ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","མོ་ཤེ་ཡིས་བཀའ་དེ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྨྲས་ནའང་། ཁོ་རྣམས་གཉའ་གནོན་དྲག་པོས་གདུང་བས་མོ་ཤེ་ལ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","ཁྱོད་སོང་ནས་ཨེ་ཅིབ་རྒྱལ་པོ་ཕཱར་ཨོལ་ལ། ཡེས་ར་ཨེལ་པ་རྣམས་ཁྱོད་ཀྱི་ཡུལ་ནས་འགྲོ་རུ་ཆུག་ཅེས་སྨྲོས་ཤིག་ཅེས་གསུངས་མོད། ");
INSERT INTO bodn_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","འོན་ཀྱང་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་འདི་ལྟར། གཟིགས་པར་ཞུ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཀྱང་ང་ལ་མི་མཉན་ན། ཕཱར་ཨོལ་གྱིས་སྨྲ་ལྕེ་རྟུལ་པོ་བདག་ལྟ་བུ་ལ་ཅི་ལྟར་མཉན་སྲིད་དམ་ཞེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་ལ་གསུང་གླེང་གནང་བ་སྟེ། ཡེས་ར་ཨེལ་པ་རྣམས་དང་ཨེ་ཅིབ་རྒྱལ་པོ་ཕཱར་ཨོལ་གྱི་གམ་དུ་སོང་ནས། ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་འཁྲིད་དགོས་པའི་བཀའ་གནང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ཁོ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་རེ་རེའི་ཁྱིམ་དཔོན་དག་གི་མིང་ནི་གཤམ་གསལ་ལྟར། ཡེས་ར་ཨེལ་གྱི་སྐྱེས་འགོ་རུ་བེན་གྱི་བུ་རྣམས་ནི་ཧ་ནོག་དང་ཕཱ༌ལུའུ། ཧེས་རོན། ཀར་མའེ་བཅས་ཡིན་ཞིང་། དེ་རྣམས་ནི་རུ་བེན་གྱི་རུས་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","སི་མུ་ཨོན་གྱི་བུ་རྣམས་ནི་ཡཱ་མུ་ཨེལ་དང་ཡཱ༌མེན། ཨོ་ཧད། ཡཱ་ཀིན། ཚོ་ཧར། ཀ་ན་ཨན་བུད་མེད་ཀྱི་བུ་ཤཱ་ཨུལ་བཅས་ཡིན་ཞིང་། དེ་རྣམས་ནི་སི་མུ་ཨོན་གྱི་རུས་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ལེ་ཝི་ཡི་བུ་རྣམས་ཀྱི་མིང་རྣམས་རང་རང་གི་རིགས་རྒྱུད་བཞིན་བཀོད་པ་གཤམ་གསལ་ལྟར། གེར་ཤོན་དང་ཀོ་ཧད། མཱ་རཱ་རེའེ་བཅས་གསུམ་ཡིན་ཞིང་། ལེ་ཝི་ཡི་ཚེ་ཚད་ནི་ལོ་བརྒྱ་དང་སོ་བདུན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","གེར་ཤོན་གྱི་བུ་ནི་རང་རང་གི་རུས་རྒྱུད་བཞིན་དུ་ལིབ་ནིས་དང་ཤིམ་ཨི་གཉིས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ཀོ་ཧད་ཀྱི་བུ་རྣམས་ནི་ཨམ་རམ་དང་ཡེས་ཧར། ཧེབ་རོན། ཨུ་ཟི་ཨེལ་བཅས་ཡིན་ཞིང་། ཀོ་ཧད་ཀྱི་ཚེ་ཚད་ནི་ལོ་བརྒྱ་དང་སོ་གསུམ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","མཱ་རཱ་རེའེ་ཡི་བུ་རྣམས་ནི་མཱ་ལི་དང་མུ་ཤི་གཉིས་ཡིན་ཞིང་། དེ་རྣམས་ནི་ལེ་ཝི་ཡི་རུས་རྒྱུད་དེ་རང་རང་གི་རིགས་རྒྱུད་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ཨམ་རམ་གྱིས་རང་གི་ཕ་ཡི་སྲིང་མོ་ཡོ་ཀེ་བེད་ཆུང་མར་བླངས་ཤིང་། དེས་ཁོ་རང་ལ་ཨ་རོན་དང་མོ་ཤེ་གཉིས་བཙས། ཨམ་རམ་གྱི་ཚེ་ཚད་ནི་ལོ་བརྒྱ་དང་སོ་བདུན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ཡེས་ཧར་གྱི་བུ་རྣམས་ནི་ཀོ་རཱག་དང༌ནེ་ཕེག ཟིག་རི་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ཨུ་ཟི་ཨེལ་གྱི་བུ་རྣམས་ནི་མེ་ཤཱ་ཨེལ་དང་ཨེལ་ཙ་ཕཱན། སིད་རེའེ་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ཡང་ཨ་རོན་གྱིས་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་མོ་དང་ནཱ་སོན་གྱི་ནུ་མོ་སྟེ་ཨེ་ལི་ཤེ་བཱ་ཆུང་མར་བླངས་ཤིང་། དེས་ཁོ་རང་ལ་བུ་ནཱ་དབ་དང་ཨ་བི་ཧུ། ཨེ་ལི་ཨ་ཟར། ཨི་ཐ་མཱར་བཅས་བཙས། ");
INSERT INTO bodn_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ཀོ་རཱག་གི་བུ་རྣམས་ནི་ཨ་སིར་དང་ཨེལ་ཁ་ནཱ། ཨ་བི་ཨ་སིབ་བཅས་ཡིན་ཞིང་། དེ་རྣམས་ནི་ཀོ་རཱག་པའི་རུས་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ཡང་ཨ་རོན་གྱི་བུ་ཨེ་ལི་ཨ་ཟར་གྱིས་ཕུ་ཏི་ཨེལ་གྱི་བུ་མོ་རྣམས་ལས་གཅིག་ཆུང་མར་བླངས་ཤིང་། དེས་ཁོ་ལ་ཕི་ནེ་ཧེ་བཙས། དེ་རྣམས་ནི་རུས་རྒྱུད་བཞིན་ལེ་ཝི་པའི་ཁྱིམ་རྒྱུད་རེ་རེའི་ཁྱིམ་དཔོན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","སྔར་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ཡེས་ར་ཨེལ་པ་རྣམས་དཔུང་ཚོགས་རེ་རེ་བཞིན་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཁྲིད་ཅིག་ཅེས་པའི་བཀའ་ནི་ཨ་རོན་དང་མོ་ཤེ་འདི་གཉིས་ལ་གནང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ཨེ་ཅིབ་རྒྱལ་པོ་ཕཱར་ཨོལ་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་འཁྲིད་པར་འགྱུར་བའི་གཏམ་སྨྲ་མཁན་ནི་མོ་ཤེ་དང་ཨ་རོན་འདི་གཉིས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་ནས་མོ་ཤེ་ལ་བཀའ་གནང་བའི་ཉིན་མོ་དེར། ");
INSERT INTO bodn_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ཁོང་གིས་འདི་སྐད་དུ། བདག་ནི་ཡ་ཝཱེ་ཡིན། ངས་ཁྱོད་ལ་ཅི་སྨྲ་བ་ཐམས་ཅད་ཁྱོད་ཀྱིས་ཨེ་ཅིབ་རྒྱལ་པོ་ཕཱར་ཨོལ་ལ་སྨྲ་བར་གྱིས་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འདི་ལྟར། གཟིགས་པར་ཞུ། ང་རང་ནི་སྨྲ་ལྕེ་རྟུལ་པོ་ཡིན་པས། ཕཱར་ཨོལ་གྱིས་བདག་ལ་ཅི་ལྟར་མཉན་སྲིད་དམ་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ལྟོས་དང་། ངས་ཕཱར་ཨོལ་གྱི་མདུན་དུ་ཁྱོད་རང་དཀོན་མཆོག་ལྟ་བུར་བྱས་པ་དང་། ཡང་ཁྱོད་ཀྱི་སྤུན་ཨ་རོན་ནི་ཁྱོད་ཀྱི་ལུང་སྟོན་པ་ཡིན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ངས་ཁྱོད་ལ་བཀའ་ཅི་གནང་བ་ཐམས་ཅད་ཁྱོད་ཀྱིས་སྨྲ་དགོས་པ་དང་། ཁྱོད་ཀྱི་སྤུན་ཨ་རོན་གྱིས་ཕཱར་ཨོལ་ལ། ཡེས་ར་ཨེལ་པ་རྣམས་ཁོའི་ཡུལ་ནས་འགྲོ་རུ་འཇུག་པའི་གཏམ་དེ་སྨྲ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ངས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་བྱེད་པ་དང་། ཨེ་ཅིབ་ཡུལ་ནས་ང་ཡི་གྲུབ་རྟགས་དང་དོན་ངོ་མཚར་ཅན་མང་པོའང་སྟོན་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","འོན་ཀྱང་ཕཱར་ཨོལ་གྱིས་ཁྱོད་ཅག་ལ་མི་མཉན་ཞིང་། བདག་གིས་ལག་པ་བརྐྱངས་ནས་ཨེ་ཅིབ་ཡུལ་ལ་ཉེས་ཆད་དྲག་པོ་གཅོད་ཅིང་། བདག་གི་མི་ཚོགས་སྟེ་ང་ཡི་འབངས་མི་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་འཁྲིད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","དེ་ནས་ངས་ལག་པ་བརྐྱངས་ནས་ཨེ་ཅིབ་ཡུལ་ལ་རྒོལ་ཞིང་། ཡེས་ར་ཨེལ་པ་རྣམས་དེ་དག་གི་ཁྲོད་ནས་ཕྱིར་འཁྲིད་པའི་དུས་སུ། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་བདག་ནི་ཡ་ཝཱེ་ཡིན་པ་ཤེས་པར་འགྱུར་ཞེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དེ་ལྟར་བྱས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཇི་ལྟར་བསྩལ་པ་བཞིན་དུ་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ཁོ་གཉིས་ཀྱིས་ཕཱར་ཨོལ་ལ་གཏམ་སྨྲ་བའི་དུས་སུ་མོ་ཤེ་ལོ་བརྒྱད་ཅུ་དང་། ཨ་རོན་ལོ་བརྒྱད་ཅུ་གྱ་གསུམ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ཕཱར་ཨོལ་གྱིས་ཁྱོད་ཅག་ལ་དོན་ངོ་མཚར་ཅན་ཞིག་སྟོན་པར་གྱིས་ཞེས་སྨྲ་བའི་ཚེ། ཁྱོད་ཀྱིས་ཨ་རོན་ལ། རང་གི་འཁར་བ་ཕཱར་ཨོལ་གྱི་མདུན་དུ་གཡུགས་ཤིག དེ་སྦྲུལ་དུ་འགྱུར་བ་ཡིན་སྨྲོས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་བྱས་ཏེ། ཨ་རོན་གྱིས་ཕཱར་ཨོལ་འཁོར་དང་བཅས་པའི་མདུན་དུ་འཁར་བ་གཡུགས་པ་ལ་དེ་སྦྲུལ་དུ་གྱུར་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ཕཱར་ཨོལ་གྱིས་མཁས་པ་དང་སྒྱུ་མ་མཁན་དག་བོས་འོངས་ཤིང་། དེ་རྣམས་ནི་ཨེ་ཅིབ་ཡུལ་གྱི་རྫུ་འཕྲུལ་སྟོན་མཁན་ཡིན་ལ། ཁོ་རྣམས་ཀྱིས་ཀྱང་རྫུ་འཕྲུལ་ལ་བརྟེན་ནས་དེ་བཞིན་བྱས་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","དེ་དག་གིས་རང་རང་གི་འཁར་བ་སར་འཕངས་པ་དང་དེ་སྦྲུལ་དུ་གྱུར་མོད། འོན་ཀྱང་ཨ་རོན་གྱི་འཁར་བས་དེ་དག་གི་འཁར་བ་རྣམས་ཁྱུར་མིད་བཏང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་གྱུར་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པ་བཞིན་དུ་ཁོས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཕཱར་ཨོལ་གྱི་སེམས་ཨུ་ཚུགས་ཆེ་ཞིང་མི་རྣམས་འགྲོ་རུ་མི་འཇུག ");
INSERT INTO bodn_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","སང་ཉིན་ཞོགས་པར་ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ཞིག ལྟོས་དང་། ཁོ་རང་ཕྱི་རུ་འོངས་ནས་ཆུ་ཁར་འགྲོ་བའི་དུས་སུ། ཁྱོད་རང་ནཱ་ཡོལ་གཙང་པོའི་འགྲམ་དུ་ལངས་བསྡད་ནས་ཁོ་བསུ་དགོས་ཤིང་། སྦྲུལ་དུ་གྱུར་མྱོང་བའི་འཁར་བ་དེ་ལག་ཏུ་ཟུངས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","དེ་ནས་ཁོ་ལ་འདི་ལྟར་ཤོད་དང་། ཨིབ་རི་པའི་དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་ཁྱོད་ཀྱི་མདུན་དུ་མངགས་ནས་འདི་སྐད་དུ། བདག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་བདག་གི་འབངས་མི་དབེན་སྟོང་དུ་འགྲོ་རུ་ཆུག་ཅེས་གསུངས་ནའང་། ལྟོས་དང་། ཁྱོད་ཀྱིས་ད་ལྟའི་བར་དུ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ལྟོས་དང་། བདག་གིས་རང་གི་ལག་ཏུ་ཡོད་པའི་འཁར་བས་ནཱ་ཡོལ་གཙང་པོའི་ཆུ་ལ་བརྡེག་ཅིང་ཆུ་ནི་ཁྲག་ཏུ་འགྱུར་བ་དང་། དེར་བརྟེན་ནས་ཁྱོད་ཀྱིས་བདག་ནི་ཡ་ཝཱེ་ཡིན་པ་རྟོགས་ངེས། ");
INSERT INTO bodn_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ནཱ་ཡོལ་གཙང་པོའི་ཉ་རྣམས་ཤི་ནས་གཙང་པོ་ལའང་དྲི་ངན་བྲོ་བར་འགྱུར་ལ། ཨེ་ཅིབ་པ་རྣམས་དེའི་ཆུ་འཐུང་བར་ཞེན་པ་ལོག་ཡོང་ཞེས་སྨྲ་དགོས་པར་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཨ་རོན་ལ་འདི་ལྟར་ཤོད་དང་། ཁྱོད་ཀྱིས་རང་གི་འཁར་བ་ལོངས་ལ་ལག་པ་ཨེ་ཅིབ་ཡུལ་གྱི་ཆུ་རྣམས་ཏེ་གཙང་པོ་དང་། གྲོག་ཆུ་དང་། རྫིང་བུ་དང་། ཆུ་འགག་ཐམས་ཅད་བཅས་ཁྲག་ཏུ་འགྱུར་བའི་ཕྱིར་ཆུ་དེ་རྣམས་ཀྱི་ཕྱོགས་སུ་རྐྱོངས་ཤིག དེ་ནས་ཨེ་ཅིབ་ཡུལ་ཀུན་ཏུ་ཁྲག་ཡོད་པར་འགྱུར་ཞིང་། ཐ་ན་ཤིང་གི་ཡོ་བྱད་དང་། རྡོ་ཡི་ཡོ་བྱད་དུའང་ཁྲག་ཡོད་པར་འགྱུར་ངེས་ཞེས་བཤད་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ་བསྒྲུབས་པ་སྟེ། ཨ་རོན་གྱིས་ཕཱར་ཨོལ་འཁོར་དང་བཅས་པའི་མདུན་དུ་འཁར་བ་ཡར་བཀྱགས་ནས་ནཱ་ཡོལ་གཙང་པོའི་ཆུ་ལ་བརྡེགས་པ་དང་། གཙང་པོའི་ཆུ་ཡོངས་རྫོགས་ཁྲག་ཏུ་གྱུར་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ནཱ་ཡོལ་གཙང་པོའི་ཉ་རྣམས་ཤི་བ་དང་། གཙང་པོར་ཡང་དྲི་ངན་བྲོ་བས། ཨེ་ཅིབ་པས་གཙང་པོ་དེའི་ཆུ་འཐུང་མ་ཕོད་ལ། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ལ་ཁྲག་གིས་གང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","དེ་ནས་ཨེ་ཅིབ་ཡུལ་གྱི་སྒྱུ་མ་མཁན་རྣམས་ཀྱིས་ཀྱང་རྫུ་འཕྲུལ་ལ་བརྟེན་ནས་དེ་བཞིན་བྱས་པ་དང་། ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་གྱུར་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པ་བཞིན་དུ་ཁོས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་མ་མཉན་པའི་ཁར། ");
INSERT INTO bodn_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ཁོ་རང་ཁ་ཕྱིར་འཁོར་ཏེ་ཕོ་བྲང་དུ་ལོག་ཅིང་། དོན་དེར་དོ་སྣང་ཙམ་ཡང་མ་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ཨེ་ཅིབ་པ་ཐམས་ཅད་ཀྱིས་གཙང་པོ་དེའི་ཆུ་འཐུང་མི་ཕོད་པས། འཐུང་ཆུ་འཐོབ་པའི་ཕྱིར་ནཱ་ཡོལ་གཙང་པོའི་འགྲམ་གཉིས་སུ་ས་བརྐོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","དཀོན་མཆོག་ཡ་ཝཱེས་ནཱ་ཡོལ་གཙང་པོར་བརྡེགས་ནས་ཉིན་བདུན་རྫོགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ནས་དེ་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། བདག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་བདག་གི་མི་རྣམས་འགྲོ་རུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","གལ་ཏེ་ཁྱོད་ཀྱིས་དེ་རྣམས་འགྲོ་བར་མི་འཇུག་ན། ལྟོས་དང་། བདག་གིས་ཁྱོད་ཀྱི་རྒྱལ་ཁམས་ཐམས་ཅད་སྦལ་བར་བརྫི་རུ་འཇུག་རྒྱུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ནཱ་ཡོལ་གཙང་པོར་སྦལ་བས་གང་བ་དང་། དེ་དག་ཐོན་ནས་ཁྱོད་ཀྱི་ཕོ་བྲང་དང་། གཟིམ་ཁང་དང་། མལ་ཁྲིའི་སྟེང་དང་། ཁྱོད་ཀྱི་འཁོར་གཡོག་རྣམས་ཀྱི་ཁང་པ་དང་། ཁྱོད་ཀྱི་འབངས་མི་རྣམས་ཀྱི་ལུས་སྟེང་དང་། ཁྱོད་ཀྱི་གཡོས་ཐབ་དང་། ཕྱེ་བརྫི་སའི་གཞོང་པ་བཅས་ཀྱི་ནང་དུ་འོང་བར་འགྱུར་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ཡང་ཁྱོད་དང་ཁྱོད་ཀྱི་འབངས་མི་དང་ཁྱོད་ཀྱི་འཁོར་གཡོག་ཐམས་ཅད་ཀྱི་ལུས་སྟེང་དུ་འོང་བར་འགྱུར་ཞེས་སྨྲོས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཨ་རོན་ལ། ཁྱོད་ཀྱིས་ལག་གི་འཁར་བ་ནི་གཙང་པོ་དང་། གྲོག་ཆུ་དང་། རྫིང་བུ་རྣམས་ཀྱི་ཕྱོགས་སུ་རྐྱོངས་ལ། སྦལ་བ་རྣམས་ཨེ་ཅིབ་ཡུལ་ལ་ཡོང་དུ་ཆུག་སྨྲོས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","དེ་ནས་ཨ་རོན་གྱིས་ལག་པ་ཨེ་ཅིབ་ཡུལ་གྱི་ཆུ་རྣམས་ཀྱི་ཕྱོགས་སུ་བརྐྱངས་པ་ན་སྦལ་བ་ཐོན་ཏེ་ཨེ་ཅིབ་ཡུལ་ཁེབས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","སྒྱུ་མ་མཁན་རྣམས་ཀྱིས་ཀྱང་རྫུ་འཕྲུལ་ལ་བརྟེན་ནས་དེ་བཞིན་བྱས་ཤིང་སྦལ་བ་རྣམས་ཨེ་ཅིབ་ཡུལ་ལ་ཡོང་དུ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་བོས་ཏེ་ན་རེ། ཁྱོད་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་སྦལ་བ་རྣམས་ང་རང་དང་ངའི་འབངས་མི་རྣམས་དང་འབྲལ་བར་མཛད་པའི་ཕྱིར་ཞུ་བ་བྱོས་དང་། བདག་གིས་མི་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་དུ་འགྲོ་རུ་འཇུག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","མོ་ཤེ་ཡིས་ཕཱར་ཨོལ་ལ་འདི་ལྟར། སྦལ་བ་རྣམས་ཁྱོད་དང་ཁྱོད་ཀྱི་ཁང་པ་རྣམས་དང་བྲལ་ནས་ནཱ་ཡོལ་གཙང་པོ་འབའ་ཞིག་གི་ནང་དུ་ལུས་པའི་ཕྱིར། ངས་ཁྱོད་དང་ཁྱོད་ཀྱི་འཁོར་གཡོག་རྣམས་དང་འབངས་མི་རྣམས་ཀྱི་དོན་དུ་དུས་ནམ་ཞིག་ལ་ཞུ་བ་བྱེད་དགོས་པ་ཁྱོད་ཀྱིས་ང་ལ་སྨྲ་བར་གྱིས་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ཁོས་སང་ཉིན་ཞེས་སྨྲས་པ་དང་། མོ་ཤེ་ན་རེ། ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་དང་འདྲ་བ་གཅིག་ཀྱང་མེད་པ་ཁྱོད་ཀྱིས་ཤེས་པའི་ཕྱིར་ཁྱོད་ཀྱི་གཏམ་བཞིན་གྲུབ་གྱུར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","སྦལ་བ་རྣམས་ཁྱོད་དང་ཁྱོད་ཀྱི་ཁང་པ་རྣམས་དང་། འཁོར་གཡོག་དང་འབངས་མི་རྣམས་དང་བྲལ་ནས། ནཱ་ཡོལ་གཙང་པོ་འབའ་ཞིག་གི་ནང་དུ་ལུས་པར་འགྱུར་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཕཱར་ཨོལ་དང་བྲལ་རྗེས། ཕཱར་ཨོལ་ལ་རྙོག་དྲ་བཟོས་པའི་སྦལ་བ་རྣམས་ཀྱི་ཕྱིར་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྐད་ཆེན་པོས་གསོལ་བ་བཏབ་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེའི་ཞུ་བ་བཞིན་མཛད་དེ། ཁང་པ་དང་ར་བ་རྣམས་དང་ཞིང་སའི་ནང་དུ་ཡོད་པའི་སྦལ་བ་དག་ཤི་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","མི་རྣམས་ཀྱིས་སྦལ་རོ་བསྡུ་རུབ་བྱས་ནས་སྤུངས་པ་ལ་ཡུལ་ཕྱོགས་ཀུན་ཏུ་དྲི་ངན་འཐུལ། ");
INSERT INTO bodn_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","འོན་ཀྱང་ཕཱར་ཨོལ་གྱིས་ཆག་སྒོ་ཞི་བ་མཐོང་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པ་བཞིན་དུ་ཁོས་སེམས་གྱོང་པོར་བྱས་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཨ་རོན་ལ་ཁྱོད་ཀྱིས་རང་གི་འཁར་བ་བརྐྱངས་ནས་ས་སྟེང་གི་རྡུལ་ལ་རྡེགས་ཤིག་དང་། ཨེ་ཅིབ་ཡུལ་ཀུན་ཏུ་རྡུལ་ནི་ཤིག་ལ་འགྱུར་བར་ངེས་ཞེས་སྨྲོས་ཤིག་ཅེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ཁོ་གཉིས་ཀྱིས་དེ་བཞིན་དུ་བྱས་ཏེ་ཨ་རོན་གྱིས་ལག་གི་འཁར་བ་བརྐྱངས་ནས་ས་རྡུལ་ལ་བརྡེགས་པ་དང་། མི་དང་དུད་འགྲོའི་སྟེང་དུ་ཤིག་བྱུང་ཞིང་། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ཀྱི་ས་རྡུལ་ཡོངས་རྫོགས་ཤིག་ཏུ་གྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","སྒྱུ་མ་མཁན་དག་གིས་ཀྱང་རྫུ་འཕྲུལ་ལ་བརྟེན་ནས་ཤིག་འབྱུང་དུ་འཇུག་བསམ་ཡང་དེ་ལྟར་བྱེད་མ་ནུས་ཤིང་། མི་དང་དུད་འགྲོ་རྣམས་ཀྱི་སྟེང་དུ་ཤིག་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","དེ་ནས་སྒྱུ་མ་མཁན་རྣམས་ཀྱིས་ཕཱར་ཨོལ་ལ། འདི་ནི་དཀོན་མཆོག་གི་ནུས་མཐུ་ ཡིན་འདུག་ཅེས་སྨྲས་ནའང་། ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་གྱུར་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པ་བཞིན་དུ་ཁོས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཐོ་རངས་ཡར་ལངས་ཏེ། ཕཱར་ཨོལ་ཆུ་ཁར་འགྲོ་དུས་ཁོའི་མདུན་དུ་སོང་ནས་དེ་ལ་འདི་ལྟར་ཤོད་ཅིག དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ང་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་བདག་གི་འབངས་མི་འགྲོ་རུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","གལ་ཏེ་ཁྱོད་ཀྱིས་བདག་གི་འབངས་མི་འགྲོ་རུ་མི་འཇུག་ན། ལྟོས་དང་། བདག་གིས་ཁྱོད་དང་ཁྱོད་ཀྱི་འཁོར་གཡོག་དང་ཁྱོད་ཀྱི་འབངས་མི་རྣམས་ཀྱི་སྟེང་དུ་སྦྲང་ནག་གི་ཁྱུ་ཚོགས་གཏོང་ངེས་པ་དང་། ཁྱོད་ཀྱི་ཕོ་བྲང་ནང་དུ་འཛུལ་བར་མ་ཟད། ཨེ་ཅིབ་པ་རྣམས་ཀྱི་ཁང་པ་དང་དེ་དག་གི་སྡོད་གནས་སུའང་སྦྲང་ནག་གིས་གང་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ཡང་ཉིན་དེ་ལ་ངས་རང་གི་འབངས་མི་གནས་པའི་གོ་ཤེན་ཡུལ་ལོགས་སུ་བཀར་ནས། དེ་རུ་སྦྲང་ནག་གི་ཁྱུ་ཚོགས་ཡོད་པར་མི་འགྱུར་ཏེ། བདག་ནི་གནམ་འོག་གི་ཡ་ཝཱེ་ཡིན་པ་ཁྱོད་ལ་ཤེས་སུ་འཇུག་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","བདག་གིས་རང་གི་འབངས་མི་ཁྱོད་ཀྱི་མི་ལས་ལོགས་སུ་བཀར་བ་དང་། སང་ཉིན་གྲུབ་རྟགས་དེ་འབྱུང་བར་འགྱུར་གསུངས་ཞེས་སྨྲོས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་དེ་བཞིན་མཛད་དེ། སྦྲང་ནག་གི་ཁྱུ་ཚོགས་ཆེན་པོ་ཕཱར་ཨོལ་གྱི་ཕོ་བྲང་དང་དེའི་འཁོར་གཡོག་རྣམས་ཀྱི་ཁང་པ་རུ་བཏབ་པ་དང་། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་སྦྲང་ནག་གི་ཁྱུ་ཚོགས་ཀྱིས་བརླགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","དེ་ནས་ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་བོས་ཏེ་ན་རེ། ཁྱོད་རྣམས་སོང་ལ་ཡུལ་འདི་ནས་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ལ་མཆོད་པ་ཕུལ་ཞིག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","འོན་ཀྱང་མོ་ཤེ་ཡིས་འདི་ལྟར། དེ་ལྟར་བྱེད་མི་འོས་ཏེ། ངེད་རྣམས་ཀྱིས་ཨེ་ཅིབ་པ་རྣམས་ཞེན་པ་ལོག་པ་གང་དེ་ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པར་འབུལ་ཡོང་། ཨེ་ཅིབ་པ་རྣམས་ཞེན་པ་ལོག་པ་གང་དེ་ཁོ་ཚོའི་མིག་མདུན་དུ་མཆོད་པར་ཕུལ་ན་དེ་དག་གིས་ངེད་རྣམས་རྡོ་རུབ་གཏོང་བ་མ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ངེད་རྣམས་ཉིན་གསུམ་གྱི་ལམ་ལ་དབེན་སྟོང་དུ་སོང་ནས། ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་བསྩལ་པ་བཞིན་དུ་ཁོང་ལ་མཆོད་པ་འབུལ་དགོས་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","དེ་ནས་ཕཱར་ཨོལ་ན་རེ། ངས་ཁྱོད་ཅག་དབེན་སྟོང་དུ་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་བར་འགྲོ་རུ་འཇུག་མོད། འོན་ཀྱང་ཁྱོད་རྣམས་ཐག་རིང་ལ་མ་འགྲོ་ཞིག ངའི་དོན་དུ་གསོལ་བ་ཐོབས་ཤིག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","མོ་ཤེ་ཡིས་འདི་ལྟར། ལྟོས་དང་། ང་རང་འདི་ནས་སོང་མ་ཐག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་འདེབས་པར་བྱ་སྟེ། སང་ཉིན་སྦྲང་ནག་གི་ཁྱུ་ཚོགས་ཕཱར་ཨོལ་དང་ཁོའི་འཁོར་གཡོག་རྣམས་དང་། འབངས་མི་རྣམས་དང་འབྲལ་བར་གྱུར་ཅིག་ཅེས་ཞུ་བ་ཡིན་མོད། འོན་ཀྱང་མི་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་བར་འགྲོ་རུ་མི་འཇུག་པའི་གཡོ་སྒྱུའི་སྦྱོར་བ་ནི་ཕཱར་ཨོལ་གྱིས་ཡང་བསྐྱར་སྤེལ་མི་རུང་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","དེ་ནས་མོ་ཤེ་ཡིས་ཕཱར་ཨོལ་དང་བྲལ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་བཏབ་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ཡིས་གསོལ་བ་བཏབ་པ་བཞིན་དུ་མཛད་དེ། སྦྲང་ནག་གི་ཁྱུ་ཚོགས་ཕཱར་ཨོལ་དང་དེའི་འཁོར་གཡོག་རྣམས་དང་། འབངས་མི་རྣམས་དང་བྲལ་བར་མཛད་ནས་གཅིག་ཀྱང་མ་ལུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ཐེངས་དེར་ཕཱར་ཨོལ་གྱིས་ཡང་སེམས་གྱོང་པོར་བྱས་ནས་མི་རྣམས་འགྲོ་རུ་མ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ནས་ཁོ་ལ་འདི་ལྟར་ཤོད་དང་། ཨིབ་རི་པ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ང་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་ངའི་མི་རྣམས་འགྲོ་རུ་ཆུག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","གལ་ཏེ་ཁྱོད་ཀྱིས་དེ་དག་ད་དུང་བཀག་ནས་འགྲོ་རུ་མི་འཇུག་ན། ");
INSERT INTO bodn_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ལྟོས་དང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱག་གིས་ཁྱོད་ཀྱི་ཞིང་ལ་ཡོད་པའི་ཕྱུགས་ཟོག་སྟེ། རྟ་དང་། བོང་བུ་དང་། རྔ་མོང་དང་། བ་གླང་གི་ཁྱུ་དང་། ར་ལུག་གི་ཁྱུ་བཅས་ལ་ནད་ཡམས་ཤིན་ཏུ་ལྕི་མོ་ཞིག་འབྱུང་བར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ནི་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ལས་ལོགས་སུ་བཀར་ཏེ། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་དབང་བའི་ཕྱུགས་ཟོག་ལས་གཅིག་ཀྱང་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་དུས་བཅད་མཛད་དེ་འདི་སྐད་དུ། སང་ཉིན་ཡ་ཝཱེས་ཡུལ་འདིར་དོན་འདི་བསྒྲུབ་ངེས་ཡིན་ཞེས་གསུངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","དེའི་ཕྱི་ཉིན་དཀོན་མཆོག་ཡ་ཝཱེས་དོན་དེ་མཛད་ཅིང་། ཨེ་ཅིབ་པའི་ཕྱུགས་ཟོག་ཐམས་ཅད་ཤི་ནའང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ལས་གཅིག་ཀྱང་མ་ཤིའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ཕཱར་ཨོལ་གྱིས་མི་མངགས་ནས་བལྟ་རུ་ཕྱིན་པ་ན། ལྟོས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ལས་གཅིག་ཀྱང་མ་ཤི་བ་མཐོང་མོད། འོན་ཀྱང་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་གྱུར་ཏེ་མི་རྣམས་འགྲོ་རུ་མ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། སྲེག་ཐབ་ནས་དུ་དྲེག་སྤར་གང་ལོངས་ལ། མོ་ཤེ་ཡིས་ཕཱར་ཨོལ་གྱི་མིག་མདུན་དུ་གནམ་ལ་གཏོར་ཅིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","དུ་དྲེག་དེ་ནི་ཨེ་ཅིབ་ཡུལ་ཡོངས་སུ་རྡུལ་དུ་འགྱུར་ཞིང་། མི་ཕྱུགས་གཉིས་ཀྱི་ལུས་སྟེང་དུ་གཉན་འབུར་ཆུ་བུར་ཅན་དུ་འགྱུར་འོང་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དུ་དྲེག་བླངས་ནས་ཕཱར་ཨོལ་གྱི་མདུན་དུ་འགྲེང་སྟེ། མོ་ཤེ་ཡིས་དེ་གནམ་ལ་གཏོར་བ་ན། མི་ཕྱུགས་གཉིས་ཀྱི་ལུས་སྟེང་དུ་གཉན་འབུར་ཆུ་བུར་ཅན་དུ་གྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","སྒྱུ་མ་མཁན་དེ་དག་དང་ཨེ་ཅིབ་པ་ཐམས་ཅད་ཀྱི་ལུས་སྟེང་དུ་གཉན་འབུར་བྱུང་བས། སྒྱུ་མ་མཁན་དེ་དག་མོ་ཤེའི་མདུན་དུ་ཚུགས་མ་ཐུབ། ");
INSERT INTO bodn_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་མཛད་ཅིང་མོ་ཤེ་ལ་གསུངས་པ་བཞིན་དུ་ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་མ་མཉན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་རང་ཐོ་རངས་ཡར་ལངས་ཏེ། ཕཱར་ཨོལ་གྱི་མདུན་དུ་ལངས་བསྡད་ནས་ཁོ་ལ་འདི་ལྟར་ཤོད་ཅིག ཨིབ་རི་པ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། བདག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་ངའི་འབངས་མི་འགྲོ་རུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","རྒྱུ་མཚན་ནི་ཐེངས་འདིར་བདག་གིས་ཆག་སྒོ་ཐམས་ཅད་ཁྱོད་དང་ཁྱོད་ཀྱི་འཁོར་གཡོག་རྣམས་དང་། ཁྱོད་ཀྱི་འབངས་མི་རྣམས་ཀྱི་སྟེང་དུ་འབབ་པར་བྱ་སྟེ། བདག་དང་འདྲ་བ་ཞིག་གནམ་འོག་ཀུན་ཏུ་མེད་པ་ཁྱོད་ཀྱིས་ཤེས་པར་འགྱུར་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ད་ལྟ་བདག་གིས་ལག་པ་བརྐྱངས་ཏེ་ནད་ཡམས་ཀྱིས་ཁྱོད་དང་ཁྱོད་ཀྱི་འབངས་མི་རྣམས་ལ་རྒོལ་བ་ཡིན་ན། ཁྱོད་རང་སྔར་ནས་ས་སྟེང་དུ་མེད་པར་གྱུར་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","དོན་དམ་དུ་བདག་གི་ནུས་མཐུ་ཁྱོད་ལ་མངོན་པ་དང་། བདག་གི་མིང་ནི་གནམ་འོག་ཀུན་ཏུ་བསྒྲག་པའི་ཕྱིར་ཁྱོད་རང་དར་བར་བྱས་པ་ཡིན་མོད། ");
INSERT INTO bodn_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","འོན་ཀྱང་ཁྱོད་ཀྱིས་ད་དུང་བདག་གི་འབངས་མི་ལ་རང་རློམ་ཆེན་པོ་བྱས་ནས་ཁོ་ཚོ་འགྲོ་རུ་མི་འཇུག་པ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ལྟོས་དང་། སང་ཉིན་གྱི་དུས་འདི་ཙམ་ལ་བདག་གིས་སེར་བ་ཆེན་པོ་ཞིག་འབབ་པར་བྱ་སྟེ། ཨེ་ཅིབ་ཡུལ་ཆགས་པའི་དུས་ནས་བཟུང་སེར་བ་དེ་འདྲ་བབས་མྱོང་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ད་ལྟ་ཁྱོད་ཀྱིས་མི་མངགས་ནས་ཁྱོད་ཀྱི་ཕྱུགས་ཟོག་དང་། ཞིང་ལ་གང་ཡོད་པ་ཐམས་ཅད་ནང་ལ་བསྡུས་ཤིག ཞིང་ལ་བསྐྱུར་ཏེ་ནང་དུ་མ་བསྡུས་པ་མི་ཕྱུགས་གང་ཡིན་རུང་སེར་བ་དེའི་སྟེང་ལ་བབས་ནས་འཆི་བར་འགྱུར་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ཕཱར་ཨོལ་གྱི་འཁོར་གཡོག་རྣམས་ལས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་འདི་ལ་འཇིགས་པ་རྣམས་ཀྱིས་རང་གི་གཡོག་པོ་རྣམས་དང་ཕྱུགས་ཟོག་མྱུར་དུ་ཁང་པའི་ནང་ལ་བསྡུས་མོད། ");
INSERT INTO bodn_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་འདི་སེམས་ལ་མ་བཟུང་བ་དག་གིས་གཡོག་པོ་རྣམས་དང་ཕྱུགས་ཟོག་ཞིང་ནང་དུ་བསྐྱུར་བ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ལག་པ་ནམ་མཁར་རྐྱོངས་དང་། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་དེ། མི་དང་ཕྱུགས་ཟོག་དང་ཞིང་ནང་གི་སྐྱེ་དངོས་ཐམས་ཅད་ཀྱི་སྟེང་དུ་སེར་བ་འབབ་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","མོ་ཤེ་ཡིས་རང་གི་འཁར་བ་ནམ་མཁར་བརྐྱངས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་འབྲུག་སྒྲ་གྲགས་པ་དང་སེར་བ་འབབ་པར་མཛད་དེ། ས་ལ་མེའི་གློག་དམར་འཁྱུག་ཅིང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་དུ་སེར་བ་ཕབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","དུས་དེར་སེར་བ་དང་མེའི་གློག་དམར་གཉིས་འདྲེས་ཤིང་ཤིན་ཏུ་དྲག་པོ་ཡིན་ཏེ། ཨེ་ཅིབ་ཡུལ་ཆགས་པའི་དུས་ནས་བཟུང་དེ་ལྟ་བུ་བྱུང་མྱོང་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་དུ། ཞིང་ལ་ཡོད་པའི་མི་ཕྱུགས་གཉིས་ཀ་དང་སྐྱེ་དངོས་ཡོད་ཚད་སེར་བས་བརྡུངས་པ་དང་། ཞིང་གི་ལྗོན་ཤིང་དང་རྩི་ཤིང་མཐའ་དག་ཀྱང་བཅག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ཡེས་ར་ཨེལ་པ་རྣམས་གནས་པའི་གོ་ཤེན་ཡུལ་འབའ་ཞིག་ཏུ་སེར་བ་མ་བབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","དེ་ནས་ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་བོས་འོངས་ནས་དེ་གཉིས་ལ་འདི་ལྟར། ད་རེས་ངས་སྡིག་པ་བྱས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེ་དྲང་བདེན་ཡིན་ལ། བདག་དང་བདག་གི་འབངས་མི་རྣམས་ནི་ངན་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","དཀོན་མཆོག་གི་འབྲུག་སྒྲ་དང་སེར་བས་ད་ནི་ཆོག་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུ་བ་ཕུལ་ཞིག དེ་ནས་བདག་གིས་ཁྱོད་རྣམས་འགྲོ་རུ་འཇུག་སྟེ་འདི་རུ་འདུག་མི་དགོས་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ཡང་མོ་ཤེ་ན་རེ། ང་རང་གྲོང་ཁྱེར་གྱི་ཕྱི་རོལ་ཏུ་སོང་མ་ཐག་ངས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱོགས་སུ་ལག་ཟུང་བརྐྱངས་ནས་གསོལ་བ་འདེབས་པར་བྱ་སྟེ། འབྲུག་སྒྲ་ཆད་ནས་སེར་བ་ཡང་མེད་པར་འགྱུར་ལ། ས་གཞི་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེའི་ཡིན་པ་ཁྱོད་ཀྱིས་ཤེས་པར་འགྱུར་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","འོན་ཀྱང་ཁྱོད་དང་ཁྱོད་ཀྱི་འཁོར་གཡོག་རྣམས་ད་དུང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མི་འཇིགས་པ་ངས་ཤེས་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","དུས་དེར་ནས་ཀྱི་སྙེ་མ་འབུས་ཤིང་སོ་མའི་མེ་ཏོག་ཀྱང་བཞད་ཡོད་པས། སེར་བས་སོ་མ་དང་ནས་གཉིས་བརྡུངས་ནའང་། ");
INSERT INTO bodn_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","གྲོ་དང་སོ་བ་ནི་ཕྱིས་སུ་སྨིན་པས་མ་བརྡུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","དེ་ནས་མོ་ཤེ་ནི་ཕཱར་ཨོལ་དང་བྲལ་ནས་གྲོང་ཁྱེར་གྱི་ཕྱི་རོལ་ཏུ་སོང་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱོགས་སུ་ལག་ཟུང་བརྐྱངས་ནས་གསོལ་བ་བཏབ་པ་ན། འབྲུག་སྒྲ་དང་སེར་བ་ཆད་ཅིང་། ཆར་བ་ས་ལ་འབབ་མཚམས་ཀྱང་བཞག་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ཕཱར་ཨོལ་གྱིས་ཆར་བ་དང་སེར་བ་དང་འབྲུག་སྒྲ་བཅས་མཚམས་ཆད་པ་མཐོང་ནས་དེ་ལས་ཀྱང་སྡིག་པ་བྱས་ཏེ། ཁོ་དང་ཁོའི་འཁོར་གཡོག་རྣམས་ཀྱིས་སེམས་གྱོང་པོར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","དེ་ལྟར་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་གྱུར་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་དེ་གསུངས་པ་བཞིན་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་འགྲོ་རུ་མ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་རང་ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ཞིག བདག་གིས་ཁོ་དང་ཁོའི་འཁོར་གཡོག་རྣམས་ཀྱི་སེམས་གྱོང་པོར་བྱས་པའི་ཕྱིར་ཡིན། དེ་ནི་ཅི་ལ་ཞེ་ན། ངས་གྲུབ་རྟགས་དེ་རྣམས་ཁོ་ཚོའི་ཁྲོད་དུ་སྟོན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","བདག་གིས་ཨེ་ཅིབ་པ་རྣམས་ལ་ཇི་ལྟར་འཕྲིན་ལས་མཛད་པ་དང་། དེ་དག་གི་ཁྲོད་དུ་གྲུབ་རྟགས་ཅི་ལྟ་བུ་བསྟན་པ་རྣམས་ཁྱོད་ཀྱིས་རང་རང་གི་བུ་དང་ཚ་བོའི་རྣ་བར་སྨྲ་བ་དང་། ཁྱོད་རྣམས་ཀྱིས་བདག་ནི་ཡ་ཝཱེ་ཡིན་པ་ཤེས་པར་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","དེའི་ཕྱིར་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཕཱར་ཨོལ་གྱི་མདུན་དུ་སོང་ནས་དེ་ལ། ཨིབ་རི་པ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་དུས་ནམ་ཞིག་གི་བར་དུ་ངའི་མདུན་དུ་ཁེངས་སྐྱུང་མི་བྱེད་དམ། བདག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་བདག་གི་འབངས་མི་འགྲོ་རུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","གལ་ཏེ་ཁྱོད་ཀྱིས་བདག་གི་འབངས་མི་འགྲོ་རུ་མི་འཇུག་ན། སང་ཉིན་ངས་འབུ་ཆ་ག་པ་ཁྱོད་ཀྱི་ཡུལ་དུ་གཏོང་བར་བྱ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","དེ་དག་གིས་ས་ངོས་ཐམས་ཅད་འགེབ་ཅིང་དེ་མི་མཐོང་བར་འགྱུར་ཞིང་། ཁྱོད་ཅག་ལ་སེར་བ་ནས་ལུས་པ་དང་ཞིང་ལ་སྐྱེས་པའི་ལྗོན་ཤིང་ཐམས་ཅད་ཀྱང་བཟའ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ཡང་ཁྱོད་ཀྱི་ཕོ་བྲང་དང་། ཁྱོད་ཀྱི་འཁོར་གཡོག་ཐམས་ཅད་ཀྱི་ཁང་པ་དང་། ཨེ་ཅིབ་པ་ཀུན་གྱི་ཁང་པ་ལ་འབུ་ཆ་ག་པས་གང་ཡོང་ལ། དེ་ལྟ་བུ་ནི་ཁྱོད་ཀྱི་ཕ་མེས་ཡང་མེས་རྣམས་འཇིག་རྟེན་དུ་སྐྱེས་པའི་དུས་ནས་བཟུང་ད་ལྟའི་བར་དུ་ནམ་ཡང་མཐོང་མ་མྱོང་གསུངས་ཞེས་སྨྲས་པ་དང་། མོ་ཤེ་ཁ་ཕྱིར་འཁོར་ཏེ་ཕཱར་ཨོལ་དང་བྲལ་ནས་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","དེ་ནས་ཕཱར་ཨོལ་གྱི་འཁོར་གཡོག་རྣམས་ཀྱིས་ཁོ་ལ། མི་འདི་དུས་ནམ་ཞིག་གི་བར་དུ་ངེད་ཅག་འཛིན་པའི་རྙི་རུ་འགྱུར་རམ། མི་འདི་རྣམས་ཁོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་འགྲོ་རུ་ཆུག་དང་། ཨེ་ཅིབ་ཡུལ་བརླགས་ཟིན་པ་ཁྱེད་ཀྱིས་ད་དུང་མི་ཤེས་སམ་ཞེས་ཞུས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཕྱིར་ཕཱར་ཨོལ་གྱི་མདུན་དུ་བོས་ནས་དེས་ཁོ་གཉིས་ལ་འདི་ལྟར། ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་དུ་སོང་ཞིག འོན་ཀྱང་སུ་འགྲོ་བར་བྱའམ་ཞེས་དྲིས་པར། ");
INSERT INTO bodn_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","མོ་ཤེ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དུས་ཆེན་བསྲུང་བའི་ཕྱིར་ངེད་རྣམས་རྒན་གཞོན་དང་། བུ་བུ་མོ་རྣམས་མཉམ་དུ་བ་ཁྱུ་དང་ར་ལུག་གི་ཁྱུ་དེད་ནས་འགྲོ་བར་བྱ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ཡང་ཕཱར་ཨོལ་གྱིས་ཁོ་གཉིས་ལ། དེ་བས་ངས་ཁྱོད་རྣམས་བུད་མེད་དང་ཕྲུ་གུ་བཅས་པ་འགྲོ་རུ་འཇུག་དུས། དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱོད་ཅག་དང་མཉམ་དུ་བཞུགས་ཀྱང་སྲིད། ཁྱོད་ཅག་ལ་དམིགས་ཡུལ་ངན་པ་ཡོད་པས་གཟབ་གཟབ་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ཐམས་ཅད་སོང་མི་ཆོག་སྟེ། ཁྱོད་ཅག་སྐྱེས་པ་རྣམས་འབའ་ཞིག་སོང་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱོས་ཤིག དེ་ནི་ཁྱོད་ཅག་གི་འདོད་པ་ཡིན་པས་སོ་ཞེས་སྨྲས་ཤིང་། ཁོ་གཉིས་ཕཱར་ཨོལ་གྱི་མདུན་ནས་ཕྱིར་བཏོན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ལག་པ་ཨེ་ཅིབ་ཡུལ་གྱི་ཕྱོགས་སུ་རྐྱོངས་དང་། འབུ་ཆ་ག་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་དུ་འོངས་ནས་ས་སྟེང་གི་སྐྱེ་དངོས་ཐམས་ཅད་དེ། སེར་ཤུལ་ནས་ལུས་པ་མཐའ་དག་བཟའ་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","མོ་ཤེ་ཡིས་འཁར་བ་ཨེ་ཅིབ་ཡུལ་གྱི་ཕྱོགས་སུ་བརྐྱངས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཉིན་མཚན་དེ་ལ་ཤར་རླུང་གཡུགས་པར་མཛད་དེ། ཐོ་རངས་ལ་སླེབས་དུས་ཤར་རླུང་གིས་འབུ་ཆ་ག་པ་རྣམས་ཁུར་ཡོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","འབུ་ཆ་ག་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ཀུན་ལ་ཁྱབ་ཡོང་སྟེ། ཡུལ་ཐམས་ཅད་ལ་ཤིན་ཏུ་མང་པོ་བབས། དེ་ལྟ་བུའི་འབུ་ཆ་ག་པ་སྔར་བྱུང་མ་མྱོང་ལ། ཕྱིས་སུའང་འབྱུང་བར་མི་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","འབུ་ཆ་ག་པ་ཡིས་ས་ངོས་ཐམས་ཅད་བཀབ་པས་ས་ནི་ནག་པོར་གྱུར་པ་དང་། ཡང་སེར་ཤུལ་ནས་ལུས་པའི་ས་སྟེང་གི་སྐྱེ་དངོས་མཐའ་དག་དང་ལྗོན་ཤིང་གི་འབྲས་བུ་ཐམས་ཅད་ཟོས་ནས། ཨེ་ཅིབ་ཡུལ་ཀུན་གྱི་ལྗོན་ཤིང་དང་ཞིང་ནང་གི་སྐྱེ་དངོས་ལས་སྔོན་པོ་ཅི་ཡང་མ་བསྐྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","དེ་ནས་ཕཱར་ཨོལ་གྱིས་མྱུར་དུ་མོ་ཤེ་དང་ཨ་རོན་གཉིས་བོས་ཏེ་ན་རེ། ངས་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འགལ་བའི་སྡིག་པ་བྱས་ཤིང་། ཁྱོད་གཉིས་ལའང་སྡིག་པ་བྱས་སོང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ད་ལྟ་ཁྱོད་གཉིས་ལ་ཞུ་བ་བྱེད་དེ། ཐེངས་འདི་ཁོ་ནར་ངའི་སྡིག་པ་ལ་གུ་ཡངས་གནང་བར་མཛོད། ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་ད་རེས་འཆི་བ་འདི་ནས་ཐར་བར་མཛད་པའི་ཕྱིར་ཞུ་བ་འབུལ་རོགས་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","མོ་ཤེ་ཡིས་ཕཱར་ཨོལ་དང་བྲལ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་བཏབ་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་རླུང་ནི་ནུབ་རླུང་དྲག་པོར་བསྒྱུར་ཏེ། འབུ་ཆ་ག་པ་རྣམས་གཡུགས་ཤིང་རྒྱ་མཚོ་དམར་པོའི་ནང་དུ་ཁུར་བ་དང་། ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་ནས་འབུ་ཆ་ག་པ་གཅིག་ཀྱང་མ་བསྐྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་མཛད་པས། དེས་ཡེས་ར་ཨེལ་པ་རྣམས་འགྲོ་རུ་མ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ལག་པ་ནམ་མཁའི་ཕྱོགས་སུ་རྐྱོངས་དང་། རེག་ཀྱང་རེག་ནུས་པའི་མུན་པ་ཞིག་ཨེ་ཅིབ་ཡུལ་ལ་འབྱུང་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","མོ་ཤེ་ཡིས་ལག་པ་ནམ་མཁའི་ཕྱོགས་སུ་བརྐྱངས་པས། ཉིན་གསུམ་ལ་ཨེ་ཅིབ་ཡུལ་ཡོངས་སུ་མུན་པ་སྟུག་པོ་ཞིག་བྱུང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ཉིན་གསུམ་གྱི་རིང་མི་རྣམས་ཀྱིས་ཕན་ཚུན་མཐོང་མ་ནུས་ལ། མི་སུ་ཡང་ལངས་ནས་རང་སར་འབྲལ་མ་ཕོད་དོ། །འོན་ཀྱང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྡོད་ཡུལ་རྣམས་ལ་འོད་ཡོད་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","དེ་ནས་ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་བོས་ནས་ཁོ་ལ་འདི་ལྟར། ཁྱོད་ཅག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་དུ་སོང་ཞིག འོན་ཏེ་ཁྱོད་རྣམས་ཀྱི་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་འདི་རུ་བསྐྱུར་དགོས་པ་དང་། བུད་མེད་དང་ཕྲུ་གུ་རྣམས་ཁྱོད་ཅག་དང་མཉམ་དུ་སོང་ཆོག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","མོ་ཤེ་ན་རེ། ངེད་རྣམས་ཀྱིས་ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་ཐུབ་པའི་ཕྱིར། ཁྱོད་ཀྱིས་མཆོད་རྫས་དང་སྦྱིན་སྲེག་ཏུ་འབུལ་བྱའི་སེམས་ཅན་ཅིས་ཀྱང་ངེད་ཀྱི་ལག་ཏུ་གཏད་དེ། ");
INSERT INTO bodn_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ངེད་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ཀྱང་ངེས་པར་ངེད་དང་མཉམ་དུ་འགྲོ་དགོས་ཤིང་། ཐ་ན་རྨིག་པ་གཅིག་ཀྱང་མི་བསྐྱུར། ཅིའི་ཕྱིར་ཞེ་ན། དེ་རྣམས་ལས་འགའ་ཤས་བླངས་ཏེ་ངེད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་དགོས་པའི་ཕྱིར་ཡིན་ལ། ངེད་ཅག་གནས་དེར་མ་སླེབས་པའི་བར་དུ་གང་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་ཅི་ཞིག་བྱེད་དགོས་པ་མི་ཤེས་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་མཛད་པས། ཁོ་རྣམས་འགྲོ་རུ་འཇུག་མ་འདོད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་ལ་འདི་ལྟར། ཁྱོད་འདི་ནས་ཕར་སོང་ཞིག ཕྱིན་ཆད་ང་དང་འཕྲད་པར་གཟབ་གཟབ་བྱོས། རྒྱུ་མཚན་ནི་ང་དང་འཕྲད་པའི་ཉིན་ལ་ཁྱོད་འཆི་བར་ངེས་པས་སོ་ཞེས་སྨྲས་པར། ");
INSERT INTO bodn_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","མོ་ཤེ་ན་རེ། ཁྱོད་ཀྱིས་སྨྲས་པ་བདེན་ནོ། །ང་ནི་ཁྱོད་དང་སླར་ཡང་འཕྲད་མི་སྲིད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། བདག་གིས་ད་དུང་ཆག་སྒོ་ཞིག་ཕཱར་ཨོལ་དང་ཨེ་ཅིབ་ཡུལ་དུ་འབྱུང་བར་བྱ། དེའི་རྗེས་སུ་ཁོས་ཁྱོད་རྣམས་ཡུལ་འདི་ནས་འགྲོ་རུ་འཇུག་པར་མ་ཟད། ཁོས་ཁྱོད་རྣམས་འགྲོ་རུ་འཇུག་པའི་དུས་སུ་ཁྱོད་ཅག་ཡོངས་རྫོགས་སྐྲོད་ངེས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","མི་རྣམས་ཀྱི་རྣ་ལམ་དུ། སྐྱེས་ཕོ་མོ་རེ་རེས་རང་རང་གི་ཁྱིམ་མཚེས་ལ་གསེར་དངུལ་གྱི་ཡོ་བྱད་རྣམས་སློང་དགོས་པའི་གཏམ་འཇོག་པར་གྱིས་ཞེས་གསུངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་པའི་མིག་མདུན་དུ་མི་རྣམས་ལ་ཐུགས་རྗེ་ཐོབ་པར་མཛད་ཅིང་། ཡང་མོ་ཤེ་ནི་ཨེ་ཅིབ་ཡུལ་དང་། ཕཱར་ཨོལ་གྱི་འཁོར་གཡོག་རྣམས་དང་འབངས་མི་དག་གི་མིག་མདུན་དུ་ཤིན་ཏུ་ཆེན་པོ་ཡོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ཡང་མོ་ཤེ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ནམ་ཕྱེད་ཙམ་ལ་ང་རང་ཨེ་ཅིབ་ཡུལ་ཀུན་ཏུ་རྒྱུ་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ཨེ་ཅིབ་ཡུལ་དུ་སྐྱེས་འགོ་ཐམས་ཅད་དེ་ཁྲི་ལ་བཞུགས་པའི་ཕཱར་ཨོལ་ནས་རང་འཐག་ལ་ཡོད་པའི་བྲན་མོའི་བར་དུ་སྐྱེས་འགོ་ཡོད་དོ་ཅོག་དང་། ཕྱུགས་ཕྲུག་འགོ་མ་ཐམས་ཅད་འཆི་ངེས་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ཨེ་ཅིབ་ཡུལ་ཐམས་ཅད་དུ་ངུ་འབོད་ཆེན་པོ་འབྱུང་སྟེ། སྔར་དེ་འདྲ་བྱུང་མ་མྱོང་ལ། ཕྱིས་སུའང་འབྱུང་མི་སྲིད། ");
INSERT INTO bodn_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","འོན་ཀྱང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་མི་ཕྱུགས་གང་ཡིན་ཡང་། ཐ་ན་ཁྱི་ཡིས་ཀྱང་དེ་རྣམས་ལ་ཟུག་མི་ཕོད་ཅེས་གསུངས། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་པ་དང་ཡེས་ར་ཨེལ་པ་རྣམས་སོ་སོར་བཀར་བ་ཁྱོད་ཅག་གིས་ཤེས་པའི་ཕྱིར་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ཁྱོད་ཀྱི་འཁོར་གཡོག་འདི་རྣམས་ཐམས་ཅད་བདག་གི་མདུན་དུ་འོངས་ནས་གུས་འདུད་བྱེད་ཅིང་འདི་ལྟར། ཁྱོད་དང་ཁྱོད་ཀྱི་རྗེས་སུ་འབྲངས་པའི་མི་ཐམས་ཅད་འདི་ནས་སོང་ཞིག་ཅེས་སྨྲ་བར་འགྱུར་ཞིང་། དེའི་རྗེས་སུ་ང་རང་འགྲོ་བར་འགྱུར་ཞེས་སྨྲས་པ་དང་། མོ་ཤེ་ཁོང་ཁྲོ་ཆེན་པོ་དང་བཅས་ཕཱར་ཨོལ་དང་བྲལ་ནས་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ངས་ཨེ་ཅིབ་ཡུལ་དུ་སྒྲུབ་པའི་དོན་ངོ་མཚར་ཅན་ཇེ་མང་དུ་འཕེལ་བའི་ཕྱིར། ཕཱར་ཨོལ་གྱིས་ཁྱོད་ཀྱི་བཀའ་ལ་མཉན་པར་མི་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་ཕཱར་ཨོལ་གྱི་མདུན་དུ་དོན་ངོ་མཚར་ཅན་དེ་ཐམས་ཅད་བསྟན་ནའང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་མཛད་དེ། ཁོས་ཡེས་ར་ཨེལ་པ་རྣམས་རང་གི་ཡུལ་ནས་འགྲོ་རུ་མ་བཅུག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་དུ་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","ཟླ་འདི་ནི་ཁྱོད་ཅག་གི་ཟླ་དང་པོ་ཡིན་པ་དང་། ལོ་གཅིག་གི་ཐོག་མར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ཁྱོད་གཉིས་ཀྱིས་ཡེས་ར་ཨེལ་གྱི་ཚོགས་ཐམས་ཅད་ལ་འདི་ལྟར། ཟླ་འདིའི་ཚེས་བཅུ་པ་ལ་རང་རང་གི་ཕ་ཡི་ཁྱིམ་རྒྱུད་བཞིན་དུ་ཁྱིམ་ཚང་རེ་རེས་ལུ་གུ་ རེ་ལེན་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","གལ་ཏེ་ལུ་གུ་བཟའ་བ་ལ་ཁྱིམ་མི་ཉུང་ངུ་ཡིན་ན། ཁྱིམ་བདག་གིས་ཉེ་བའི་ཁྱིམ་མཚེས་དང་མཉམ་དུ་ལུ་གུ་གཅིག་ལེན་དགོས་ལ། ཁྱིམ་མི་རེ་རེའི་ཟ་ཚད་བཞིན་དུ་སྔོན་རྩིས་རྒྱག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ཁྱོད་ཅག་གི་ལུ་གུ་ནི་ལོ་གཅིག་ཅན་གྱི་ཕོ་ཕྱུགས་སྐྱོན་མེད་པ་ཞིག་ཡིན་དགོས་པ་དང་ལུག་གམ་ར་ཡི་ཁྲོད་གང་ནས་བླངས་ཀྱང་ཆོག ");
INSERT INTO bodn_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ཁྱོད་ཅག་གིས་ཟླ་འདིའི་ཚེས་བཅུ་བཞི་པའི་བར་དུ་བཞག་ནས། ཡེས་ར་ཨེལ་གྱི་ཚོགས་ཐམས་ཅད་ཀྱིས་ས་སྲོས་ཀྱི་དུས་སུ་ལུ་གུ་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ཡང་ཁྱིམ་ཚང་རེ་རེས་དེའི་ཁྲག་ཉུང་ཙམ་བླངས་ཏེ་ལུ་གུ་བཟའ་སའི་ཁང་པ་དག་གི་སྒོ་འགྲམ་གཉིས་ཀ་དང་ཡ་ཐེམ་ལ་བསྐུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","མཚན་མོ་དེར་ལུ་གུའི་ཤ་བཟའ་དགོས་ཏེ། མེ་ལ་བསྲེགས་ནས་སྐྱུར་མེད་བག་ལེབ་དང་སྔོ་ཚོད་ཁ་པོ་དང་ལྷན་དུ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","རློན་པའམ་ཆུ་ལ་བཙོས་པ་ནི་བཟའ་མི་རུང་སྟེ་མགོ་སུག་གཉིས་ཀ་དང་དེའི་ནང་ཁྲོལ་དང་བཅས་པ་མེ་ལ་བསྲེགས་ནས་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ཕྱི་ཉིན་ཞོགས་པའི་བར་དུ་ཅི་ཡང་ལུས་སུ་འཇུག་མི་རུང་ལ། གལ་ཏེ་ཞོགས་པའི་བར་དུ་ལུས་ན་དེ་མེར་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ཡང་ཟ་སྲོལ་ནི་འདི་ལྟ་སྟེ། ཁྱོད་རྣམས་ཀྱིས་ཐུ་བ་བརྫེས་པ་དང་རྐང་པར་ལྷམ་གྱོན་ཞིང་། འཁར་བ་ལག་ཏུ་བཟུང་ནས་བྲེལ་མྱུར་ངང་བཟའ་དགོས་ལ། དེ་ནི་ཡ་ཝཱེའི་པེ་སག་གི་དུས་ཆེན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","མཚན་མོ་དེར་ང་རང་ཨེ་ཅིབ་ཡུལ་དུ་རྒྱུ་ཞིང་། མི་ཕྱུགས་གང་ཡིན་ཡང་ཨེ་ཅིབ་ཡུལ་གྱི་སྐྱེས་འགོ་ཐམས་ཅད་གསོད་པ་དང་། ཨེ་ཅིབ་ཡུལ་གྱི་ལྷ་ཀུན་ལ་ཁྲིམས་ཐག་གཅོད་པར་བྱ། བདག་ནི་ཡ་ཝཱེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ཁྲག་དེ་ཁྱོད་རྣམས་གནས་སའི་ཁང་པའི་སྟེང་རྟགས་སུ་འགྱུར་ལ། ངས་ཁྲག་དེ་མཐོང་བ་དང་ཕར་བརྒལ་ཞིང་། ཨེ་ཅིབ་ཡུལ་ལ་བརྡུང་བའི་ཚེ། མེད་པར་བཟོ་བའི་ཆག་སྒོ་དེ་ཁྱོད་རྣམས་ལ་འཕོག་པར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ཡང་ཉིན་དེ་ནི་ཁྱོད་ཅག་གི་ཕྱིར་རྗེས་དྲན་དུ་འགྱུར་ཞིང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དུས་ཆེན་ཞིག་རོལ་དགོས་པ་དང་། ཁྱོད་རྣམས་ཀྱིས་མི་རབས་ནས་མི་རབས་བར་ཁྲིམས་སྲོལ་དེ་གཏན་དུ་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ཉིན་བདུན་གྱི་རིང་ལ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས་ཤིང་། ཉིན་དང་པོར་ཁྱོད་ཅག་གིས་རང་གི་ཁྱིམ་ནས་སྐྱུར་རྩི་ཕྱི་རུ་དོར་ཅིག ཅི་ལ་ཞེ་ན། ཉིན་དང་པོ་ནས་ཉིན་བདུན་པའི་བར་དུ་མི་སུ་ཞིག་གིས་སྐྱུར་རྩི་དང་ལྡན་པ་ཞིག་ཟོས་ན། མི་དེ་ཡེས་ར་ཨེལ་གྱི་ཁྲོད་ནས་འཕུད་དགོས་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ཉིན་དང་པོར་ཁྱོད་རྣམས་ལ་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས་ལ། ཉིན་བདུན་པར་ཡང་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས། ཉིན་དེ་གཉིས་ལ་མི་རེ་རེར་མཁོ་བའི་ཁ་ཟས་འབའ་ཞིག་སྟ་གོན་བྱེད་པ་ལས་གཞན། ལས་གང་ཡང་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ཉིན་དེ་ཉིད་ལ་ངས་ཁྱོད་རྣམས་ཀྱི་དཔུང་སྡེ་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཁྲིད་པའི་རྐྱེན་གྱིས། ཁྱོད་རྣམས་ཀྱིས་སྐྱུར་མེད་བག་ལེབ་ཀྱི་དུས་ཆེན་བསྲུང་དགོས་ལ། ཉིན་མོ་དེ་བསྲུང་བ་དང་མི་རབས་ནས་མི་རབས་བར་ཁྲིམས་སྲོལ་དེ་གཏན་དུ་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ཟླ་དང་པོའི་ཚེས་བཅུ་བཞི་ཉིན་གྱི་དགོང་མོ་ནས་ཟླ་དེའི་ཚེས་ཉེར་གཅིག་ཉིན་གྱི་དགོང་མོའི་བར་དུ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ཁྱོད་ཅག་གི་ཁྱིམ་རེ་རེར་ཉིན་བདུན་གྱི་རིང་ལ་སྐྱུར་རྩི་ཡོད་མི་རུང་སྟེ། བྱེས་པའམ་ཡུལ་མི་སུ་ཡིན་ཡང་སྐྱུར་རྩི་ཅན་གང་ཞིག་ཟ་མཁན་དེ་ཡེས་ར་ཨེལ་གྱི་ཚོགས་ནས་འཕུད་དགོས་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ཁྱོད་རྣམས་ཀྱིས་སྐྱུར་རྩི་ཅན་གང་ཡིན་ཡང་བཟའ་མི་རུང་ལ། ཁྱོད་ཅག་གང་དུ་གནས་ནའང་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས་ཞེས་སྨྲོས་ཤིག་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་བོས་ནས་དེ་དག་ལ། ཁྱོད་རྣམས་ཀྱིས་ཁྱིམ་མི་བཞིན་དུ་ལུ་གུ་བླངས་ནས་པེ་སག་གི་ལུ་གུ་ཤོས་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ཡང་ཨི་སོབ་རྩྭ་ཤིང་ཕོན་པོ་ཞིག་གཞོང་པ་རུ་ཡོད་པའི་ཁྲག་གི་ནང་དུ་སྦངས་ནས། ཁྲག་དེ་སྒོའི་ཡ་ཐེམ་དང་སྒོ་འགྲམ་གཉིས་ལ་བསྐུ་དགོས་ཤིང་། ཞོགས་པའི་བར་དུ་ཁྱོད་རྣམས་ལས་སུ་ཡང་རང་གི་ཁྱིམ་ནས་སྒོ་རུ་འབུད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ཅི་ལ་ཞེ་ན། དཀོན་མཆོག་ཡ་ཝཱེ་ཕྱོགས་ཀུན་ལ་རྒྱུ་ཞིང་ཨེ་ཅིབ་པ་རྣམས་དགུམ་པ་དང་། སྒོའི་ཡ་ཐེམ་དང་སྒོ་འགྲམ་གཉིས་ལ་བསྐུས་པའི་ཁྲག་གཟིགས་པ་ན། ཁོང་ཉིད་སྒོ་དེ་ལས་ཕར་བརྒལ་ཞིང་སྲོག་གཅོད་མཁན་དེ་ཁྱོད་ཅག་གི་ཁང་པའི་ནང་ལ་ཁྱོད་རྣམས་དགུམ་དུ་ཡོང་བར་མི་མཛད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ཁྱོད་ཅག་གིས་བཀའ་འདི་བསྲུངས་ཏེ། མི་རབས་ནས་མི་རབས་བར་ཁྲིམས་སྲོལ་དེ་གཏན་དུ་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ཡང་ཕྱིས་སུ་ཁྱོད་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་ལ་གནང་བར་ཞལ་གྱིས་བཞེས་པའི་ཡུལ་དུ་སླེབས་དུས། ཁྱོད་ཅག་གིས་ཆོ་ག་དེ་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ཁྱོད་ཅག་གི་བུ་ཕྲུག་རྣམས་ཀྱིས་ཆོ་ག་འདིའི་དོན་ཅི་ཡིན་ཞེས་འདྲི་བའི་ཚེ། ");
INSERT INTO bodn_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ཁྱོད་ཅག་གིས་དེ་རྣམས་ལ། འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་པེ་སག་གི་མཆོད་པ་དེ་ཡིན། ཁོང་གིས་ཨེ་ཅིབ་པ་རྣམས་ལ་བརྡུངས་པའི་ཚེ། ཨེ་ཅིབ་ཡུལ་དུ་ཡོད་པའི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁང་པ་རྣམས་ལས་ཕར་བརྒལ་ཏེ་རང་ཅག་གི་ཁྱིམ་ཚང་རེ་རེ་ཐར་བར་མཛད་པ་ཡིན་སྨྲོས་ཤིག་ཅེས་སྨྲས། དེ་ནས་མི་རྣམས་ཀྱིས་མགོ་བོ་བཏུད་ནས་ཕྱག་བཙལ་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་བཀའ་ཇི་ལྟར་གནང་བ་ཡིན་ན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་བཞིན་དུ་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ཡང་ནམ་ཕྱེད་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་དུ་རྒྱལ་ཁྲི་ལ་སྡོད་པའི་ཕཱར་ཨོལ་གྱི་སྐྱེས་འགོ་ནས་བཙོན་དུ་བཅུག་ཡོད་པའི་བཙོན་པའི་སྐྱེས་འགོའི་བར་དང་། ཕྱུགས་ཕྲུག་འགོ་མ་རྣམས་བཅས་སྐྱེས་འགོ་ཐམས་ཅད་བཀུམས། ");
INSERT INTO bodn_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","མཚན་མོ་དེ་ལ་ཕཱར་ཨོལ་དང་དེའི་འཁོར་གཡོག་རྣམས་དང་། ཨེ་ཅིབ་པ་ཐམས་ཅད་ལངས་ནས་ཨེ་ཅིབ་ཡུལ་དུ་ངུ་སྐད་ཆེན་པོ་ཞིག་བྱུང་བ་སྟེ། འཆི་བ་མེད་པའི་ཁྱིམ་ཚང་གཅིག་ཀྱང་མ་ལུས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","དེ་ནས་མཚན་མོའི་དུས་སུ་ཕཱར་ཨོལ་གྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་བོས་ཏེ་ན་རེ། ཁྱོད་གཉིས་དང་ཡེས་ར་ཨེལ་པ་རྣམས་ངའི་འབངས་མིའི་ཁྲོད་ནས་ཆས་ཏེ་སོང་ཞིག ཁྱོད་གཉིས་ཀྱིས་སྨྲས་པ་བཞིན་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་དུ་སོང་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ཡང་ཁྱོད་ཀྱིས་སྨྲས་པ་བཞིན་དུ་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་དེད་ནས་སོང་ལ། ང་རང་ལ་ཡང་བྱིན་གྱིས་རློབས་ཤིག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་ངེད་ཐམས་ཅད་འཆི་བར་འགྱུར་ཞེས་སྨྲས་པས། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ནན་གྱིས་བསྐུལ་ཏེ་ཁོ་རྣམས་ཡུལ་དེ་ནས་མྱུར་དུ་ཕྱིར་བཏོན། ");
INSERT INTO bodn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","དེ་ནས་ཁོ་རྣམས་ཀྱིས་ད་དུང་སྐྱུར་རྩི་མ་བཏབ་པའི་བག་ཟན་དང་ཟན་གཞོང་བཅས་གྱོན་གོས་ཀྱིས་བཏུམས་ཏེ་ཕྲག་ལ་ཁུར་ནས་ཁྱེར། ");
INSERT INTO bodn_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མོ་ཤེ་ཡིས་སྨྲས་པ་བཞིན་དུ་བསྒྲུབས་པ་སྟེ། ཨེ་ཅིབ་པ་རྣམས་ལས་གསེར་དངུལ་གྱི་ཡོ་བྱད་དང་གྱོན་གོས་བསླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་པ་དག་གི་མིག་མདུན་དུ་མི་རྣམས་ལ་ཐུགས་རྗེ་ཐོབ་པར་མཛད་པས། དེ་དག་གིས་ཅི་བསླངས་པ་བཞིན་དུ་ཐོབ་ཅིང་། ཨེ་ཅིབ་པའི་རྒྱུ་ནོར་དག་བཅོམ་ནས་ཁྱེར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་རཱ་ཨམ་སེའེ་ནས་ཆས་ཏེ་སོའུ་ཀོད་ཡུལ་དུ་ཕྱིན་པ་དང་། བུད་མེད་དང་ཕྲུ་གུ་རྣམས་མ་ཐེ་བར། རྐང་པ་བརྒྱབ་ནས་འགྲོ་བའི་སྐྱེས་པའི་མི་གྲངས་ནི་འབུམ་དྲུག་ཙམ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","མི་ཚོགས་འདྲེས་མ་ཞིག་དང་ར་ལུག་དང་བ་གླང་གི་ཁྱུ་རྣམས་ཏེ་སྒོ་ཕྱུགས་གྲངས་ལས་འདས་པའང་ཁོ་རྣམས་དང་མཉམ་དུ་སོང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ཡང་ཁོ་རྣམས་ཀྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཁྱེར་བའི་བག་ཟན་ནས་སྐྱུར་མེད་བག་ལེབ་བསྲེགས་པ་སྟེ། ཅི་ལ་ཞེ་ན། ཨེ་ཅིབ་ཡུལ་ནས་བཏོན་ཞིང་འགོར་འགྱང་བྱེད་མ་ནུས་པས་བག་ཟན་ལ་སྐྱུར་རྩི་མ་བཅུག་པ་དང་། རང་གི་ཆེད་དུ་བཟའ་བཅའ་ཅི་ཡང་གྲ་སྒྲིག་བྱས་མེད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་དུ་བསྡོམས་པས་ལོ་ངོ་བཞི་བརྒྱ་སུམ་ཅུར་བསྡད། ");
INSERT INTO bodn_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ཡང་ལོ་བཞི་བརྒྱ་སུམ་ཅུ་ཏག་ཏག་ལོན་པའི་ཉིན་དེ་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་དཔུང་སྡེ་ཐམས་ཅད་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཐོན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","མཚན་མོ་དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པའི་མཚན་མོ་ཡིན་པས། ཡེས་ར་ཨེལ་པ་རྣམས་དང་དེ་དག་གི་བུ་རབས་ཐམས་ཅད་ཀྱིས་མཚན་མོ་དེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ནན་བརྩི་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། པེ་སག་དུས་ཆེན་གྱི་ཁྲིམས་སྲོལ་ནི་འདི་ལྟར་ཡིན་ཏེ། ཕྱི་ཕྱོགས་པ་སུ་ཡིན་ཡང་ལུ་གུའི་ཤ་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","འོན་ཀྱང་། དངུལ་སྤྲད་ནས་ཉོས་པའི་གཡོག་པོ་ནི་མཚན་སྐྱི་བཅད་པ་ཡིན་ན་དེས་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","བྱེས་སུ་སྡོད་པའམ་གླ་པ་སུ་ཡིན་ཡང་དེ་ལས་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ཅིས་ཀྱང་ཁང་པ་གཅིག་གི་ནང་དུ་བཟའ་དགོས་ཤིང་། ལུ་གུ་དེའི་ཤ་ལས་ཅུང་ཙམ་ཡང་ཁང་པའི་ཕྱི་རུ་འཁྱེར་མི་འོས་ལ། དེའི་རུས་པ་གཅིག་ཀྱང་གཅོག་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ཡེས་ར་ཨེལ་གྱི་ཚོགས་ཐམས་ཅད་ཀྱིས་ཁྲིམས་སྲོལ་དེ་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","གལ་ཏེ་བྱེས་པ་ཞིག་ཁྱོད་ཅག་གི་ཁྲོད་དུ་གནས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་པེ་སག་གི་དུས་ཆེན་བསྲུང་བར་དགའ་ཞིང་། ཁྱིམ་དེའི་སྐྱེས་པ་ཐམས་ཅད་ཀྱི་མཚན་སྐྱི་བཅད་ན། ད་གཟོད་ཡུལ་མི་ལྟར་ཡོང་ནས་དུས་ཆེན་བསྲུང་དུ་འཇུག་རུང་བ་ཡིན། འོན་ཀྱང་། མཚན་སྐྱི་མ་བཅད་པ་དག་གིས་དེ་ལས་བཟའ་མི་འོས། ");
INSERT INTO bodn_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ཡུལ་མི་དང་ཁྱོད་ཅག་གི་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་རྣམས་ལ་ཁྱད་པར་གང་ཡང་མེད་པར་བཀའ་ཁྲིམས་གཅིག་ཡོད་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་བཀའ་ཇི་ལྟར་གནང་བ་ཡིན་ན། ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཀྱིས་དེ་བཞིན་དུ་བྱས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ཉིན་དེ་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ཁོ་ཚོའི་དཔུང་སྡེ་བཞིན་དུ་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པར་མཛད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་སྐྱེས་འགོ་ནི་མི་ཕྱུགས་གང་ཡིན་རུང་དེ་དག་བདག་གི་ཡིན་ཏེ། ཁོ་རྣམས་ཐམས་ཅད་ང་ལ་དམ་པར་གྱིས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","དེ་ནས་མོ་ཤེ་ཡིས་མི་རྣམས་ལ། ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་བྲན་དུ་བཀོལ་བའི་གནས་ནས་ཐོན་པའི་ཉིན་འདི་རྗེས་སུ་དྲན་པར་གྱིས་ཤིག དཀོན་མཆོག་ཡ་ཝཱེས་ནུས་མཐུ་ཆེན་པོའི་ཕྱག་གིས་ཁྱོད་རྣམས་ཡུལ་དེ་ནས་ཕྱི་རུ་ཁྲིད་པས། སྐྱུར་རྩི་ཅན་གང་ཡང་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ཨ་རྦིབ་ཟླ་བའི་ཉིན་འདི་ལ་ཁྱོད་རྣམས་ཕྱི་རོལ་ཏུ་ཐོན་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","དཀོན་མཆོག་ཡ་ཝཱེས་ཀ་ན་ཨན་པ་དང་། ཧེད་པ་དང་། ཨེ་མོར་པ་དང་། ཧེ་བི་པ་དང་། ཡེ་བུ་སི་པ་རྣམས་ཀྱི་ཡུལ་ཏེ། འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་དེ་ཁྱོད་ཅག་གི་ཕ་མེས་ཡང་མེས་རྣམས་ལ་མནའ་བཞེས་པ་བཞིན་ཁྱོད་རྣམས་ལ་གནང་ངེས་ཤིང་། ཁོང་གིས་ཁྱོད་རྣམས་དེ་ལ་འཁྲིད་པར་འགྱུར་བ་དང་། དེའི་དུས་སུ་ཟླ་བ་འདི་ལ་ཁྱོད་རྣམས་ཀྱིས་ཁྲིམས་སྲོལ་བསྲུང་དགོས་པ་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ཉིན་བདུན་གྱི་རིང་ཁྱོད་རྣམས་ཀྱིས་སྐྱུར་མེད་བག་ལེབ་ཟོ་ལ། ཉིན་བདུན་པར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དུས་ཆེན་བསྲུང་བར་བྱའོ། ");
INSERT INTO bodn_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ཉིན་བདུན་པོའི་རིང་ལ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས་ཤིང་ཁྱོད་རྣམས་ཀྱི་ཁྲོད་དུ་སྐྱུར་རྩི་ཅན་གང་ཡང་མཐོང་མི་འོས། ཁྱོད་རྣམས་ཀྱི་ཡུལ་ཐམས་ཅད་ནས་ཀྱང་སྐྱུར་རྩི་མཐོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ཡང་ཉིན་དེར་ཁྱོད་རྣམས་ཀྱིས་རང་གི་བུ་ལ། འདི་ནི་ང་རང་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཐོན་པའི་སྐབས་སུ་དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་ལ་དེ་ལྟར་མཛད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","དཀོན་མཆོག་ཡ་ཝཱེས་ནུས་མཐུ་ཆེན་པོའི་ཕྱག་གིས་ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པའི་རྐྱེན་གྱིས། ཁྲིམས་སྲོལ་འདི་ནི་ཁྱོད་རྣམས་ཀྱི་ལག་པར་བཏབ་པའི་རྟགས་ཐམ་དང་། ཁྱོད་རྣམས་ཀྱི་དཔྲལ་བར་ཡོད་པའི་རྗེས་དྲན་དུ་འགྱུར་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ཁྲིམས་ནི་དུས་རྒྱུན་ཁྱོད་རྣམས་ཀྱི་ངག་ཏུ་ཡོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","དེ་བས་ཁྱོད་རྣམས་ཀྱིས་ཁྲིམས་སྲོལ་འདི་ལོ་རེ་ནས་ལོ་རེ་བཞིན་དུས་ཚོད་ལྟར་བསྲུང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","དཀོན་མཆོག་ཡ་ཝཱེས་དེ་སྔར་ཁྱོད་དང་ཁྱོད་རྣམས་ཀྱི་ཕ་མེས་ཡང་མེས་ལ་མནའ་བཞེས་པ་བཞིན་དུ། མ་འོངས་པར་ཁྱོད་རྣམས་ཀ་ན་ཨན་པའི་ཡུལ་དུ་ཁྲིད་ནས་ཡུལ་དེ་ཁྱོད་ཅག་ལ་གནང་བའི་ཚེ། ");
INSERT INTO bodn_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ཁྱོད་རྣམས་ཀྱིས་སྐྱེས་འགོ་ཀུན་དང་། ཡང་ཁྱོད་རྣམས་ཀྱི་ཕྱུགས་ཕྲུག་འགོ་མ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས་ལ། ཕོ་ཡིན་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","འོན་ཀྱང་བོང་ཕྲུག་འགོ་མ་ཐམས་ཅད་ནི་ལུ་གུ་ཞིག་གིས་བླུ་དགོས། ཅི་སྟེ་བླུ་བར་མ་བྱས་ན་དེའི་སྐེ་ཚིགས་རྫོག་ཅིག ཁྱོད་རྣམས་ཀྱི་བུ་སྐྱེས་འགོ་ཐམས་ཅད་བླུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","མ་འོངས་པར་ཁྱོད་རྣམས་ཀྱི་བུ་ཡིས་དེའི་དོན་ཅི་ཡིན་པ་ཁྱོད་རྣམས་ལ་འདྲི་བའི་ཚེ། ཁྱོད་ཅག་གིས་དེ་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ནུས་མཐུ་ཆེན་པོའི་ཕྱག་གིས་ངེད་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་བྲན་དུ་བཀོལ་བའི་གནས་ནས་ཕྱི་རུ་ཁྲིད་པར་མཛད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོ་ཡིན་ཞིང་ངེད་རྣམས་འགྲོ་རུ་མི་འཇུག་པ་ཙམ་བྱས་པའི་སྐབས་སུ། དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་གྱི་སྐྱེས་འགོ་ཐམས་ཅད་དེ་མིའི་སྐྱེས་འགོ་ནས་ཕྱུགས་ཕྲུག་འགོ་མའི་བར་དུ་བཀུམས། དེའི་ཕྱིར་ངས་ཕྱུགས་ཕྲུག་འགོ་མ་ཕོ་ཡིན་པ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ། འོན་ཀྱང་བུ་སྐྱེས་འགོ་ཐམས་ཅད་བླུ་བ་ཡིན་ཞེས་སྨྲ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","དོན་འདི་ནི་ཁྱོད་རྣམས་ཀྱི་ལག་པར་བཏབ་པའི་རྟགས་ཐམ་དང་དཔྲལ་བ་རུ་མཚོན་བྱེད་ཡིན་དགོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་ནུས་མཐུ་ཆེན་པོའི་ཕྱག་གིས་རང་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ཡང་ཕཱར་ཨོལ་གྱིས་མི་འགྲོ་རུ་བཅུག་པའི་དུས་སུ། ཕེ་ལེ་ཤེད་ཡུལ་གྱི་ལམ་ཐག་ཉེ་ནའང་དཀོན་མཆོག་གིས་དེ་དག་ཡུལ་དེ་བརྒྱུད་ནས་མ་ཁྲིད་དོ། །ཅིའི་ཕྱིར་ཞེ་ན། ཁོང་གི་ཐུགས་སུ་མི་རྣམས་ཀྱིས་དམག་འཁྲུག་འབྱུང་བ་མཐོང་ན་འགྱོད་ཅིང་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་ཉེན་ཆེ་བར་དགོངས་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","དེའི་ཕྱིར། དཀོན་མཆོག་གིས་མི་རྣམས་རྒྱ་མཚོ་དམར་པོའི་འགྲམ་གྱི་དབེན་སྟོང་ལ་ལམ་བསྐོར་ནས་ཁྲིད་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་དམག་ཆས་དང་བཅས་པ་ཨེ་ཅིབ་ཡུལ་ནས་ཡར་སོང་། ");
INSERT INTO bodn_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","མོ་ཤེ་ཡིས་ཡོ་སེབ་ཀྱི་རུས་པའང་མཉམ་དུ་ཁྱེར་ཏོ། །གང་ལ་ཟེར་ན། ཡོ་སེབ་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་མནའ་སྐྱེལ་དུ་བཅུག་ཅིང་། ཁོ་རྣམས་ལ་འདི་ལྟར། དཀོན་མཆོག་གིས་ཁྱོད་རྣམས་ལ་གཟིགས་སྐྱོང་གནང་བར་འགྱུར། ཁྱོད་ཅག་གིས་ངའི་རུས་པ་འདི་ནས་འཁྱེར་དགོས་ཞེས་བཀའ་གནང་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","དེ་ནས་ཁོ་རྣམས་སོའུ་ཀོད་ཡུལ་ནས་ཆས་ཏེ་དབེན་སྟོང་གི་ལོགས་སུ་ཨེ་ཐཱམ་བྱ་བའི་གནས་སུ་སྒར་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","དཀོན་མཆོག་ཡ་ཝཱེས་ཉིན་མོའི་དུས་སུ་སྤྲིན་གྱི་ཀ་བ་ཞིག་གི་དབྱིབས་ནས་ཁོ་རྣམས་ལ་ལམ་ཁྲིད་པ་དང༌། མཚན་མོར་མེའི་ཀ་བ་ཞིག་གི་དབྱིབས་ནས་དེ་རྣམས་ལ་འོད་སྤྲོས་ཏེ། ཁོ་རྣམས་ཉིན་མཚན་ཀུན་ཏུ་འགྲོ་ནུས་པར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ཉིན་མོར་སྤྲིན་གྱི་ཀ་བ་དང་མཚན་མོར་མེའི་ཀ་བ་ནི་ནམ་ཡིན་ཡང་མི་རྣམས་དང་ཁ་མ་བྲལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཕྱིར་ལོག་སྟེ་མིག་དོལ་དང་རྒྱ་མཚོའི་བར་གྱི་ཕི་ཧཱ་ཧི་རོད་བྱ་བའི་མདུན་དུ། པཱ་ཨལ་ཚཱ་ཕོན་ཁ་གཏད་ཀྱི་རྒྱ་མཚོའི་འགྲམ་ལ་སྒར་འདེབས་པའི་བཀའ་སྒོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","དེ་ནས་ཕཱར་ཨོལ་གྱི་སེམས་སུ་ཡེས་ར་ཨེལ་པ་རྣམས་ཡུལ་འདི་རུ་མགོ་འཐོམས་ཏེ་དབེན་སྟོང་གིས་དེ་དག་འགོག་བཞིན་འདུག་སྙམ་ངེས། ");
INSERT INTO bodn_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","བདག་གིས་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་བྱས་ཏེ། ཁོས་དེ་དག་གི་རྗེས་འདེད་པ་དང་། ཕཱར་ཨོལ་དང་དེའི་དམག་དཔུང་དང་བཅས་པ་ལས་བདག་ལ་གཟི་བརྗིད་ལྡན་པར་འགྱུར་ཞིང་། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་བདག་ནི་ཡ་ཝཱེ་ཡིན་པ་ཤེས་པར་འགྱུར་ཞེས་གསུངས་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་བཞིན་དུ་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ཡང་ཨེ་ཅིབ་རྒྱལ་པོར་མི་རྣམས་བྲོས་སོང་ཞེས་གཞན་ཞིག་གིས་སྨྲས་པ་ལ། ཕཱར་ཨོལ་དང་དེའི་འཁོར་གཡོག་རྣམས་མི་རྣམས་ཀྱི་ཕྱོགས་སུ་སེམས་འགྱུར་ནས། ངེད་རྣམས་ལ་གཡོག་བྱེད་པའི་ཡེས་ར་ཨེལ་པ་རྣམས་འགྲོ་རུ་བཅུག་ཅིང་། ངེད་རྣམས་ཀྱིས་དོན་ཅི་འདྲ་བ་བྱས་སམ་ཞེས་སྨྲས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ཕཱར་ཨོལ་གྱིས་རང་གི་ཤིང་རྟ་སྟ་གོན་བྱས་ཤིང་། དམག་དཔུང་ཁྲིད་ནས་སོང་བ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ཤིང་རྟ་མཆོག་ཏུ་གྱུར་པ་དྲུག་བརྒྱ་དང་། ཨེ་ཅིབ་ཡུལ་གྱི་ཤིང་རྟ་ཇི་ཙམ་ཡོད་པ་ཐམས་ཅད་དང་། དེ་ཐམས་ཅད་ཀྱི་འགོ་དཔོན་རྣམས་མཉམ་དུ་ཁྲིད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་ཡུལ་གྱི་རྒྱལ་པོ་ཕཱར་ཨོལ་གྱི་སེམས་གྱོང་པོར་མཛད་པས། ཁོ་སྤོབས་པ་ཆེན་པོའི་ངང་ནས་ཕར་འགྲོ་བཞིན་པའི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ར་མདར་བརྒྱུགས། ");
INSERT INTO bodn_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","དེ་ནས་ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་དེ་དག་གི་རྗེས་དེད་དེ། ཕཱར་ཨོལ་གྱི་རྟ་དང་ཤིང་རྟ་ཐམས་ཅད་དང་། སྐྱ་དམག་རྣམས་དང་། དམག་དཔུང་བཅས་ཕི་ཧཱ་ཧི་རོད་ཀྱི་ཉེ་སར། པཱ་ཨལ་ཚཱ་ཕོན་གྱི་ཁ་གཏད་དུ་རྒྱ་མཚོའི་འགྲམ་ལ་ཡོད་པའི་སྒར་འདེབས་ས་རུ་རྗེས་ཆོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ཕཱར་ཨོལ་ཉེ་བར་སླེབས་པའི་དུས་སུ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཡར་བལྟས་པ་དང་། ལྟོས་ཤིག ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་རྗེས་དེད་ནས་ཡོང་བཞིན་པ་མཐོང་ནས་ཤིན་ཏུ་འཇིགས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ངུ་འབོད་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","མོ་ཤེ་ལ་འདི་ལྟར། ཨེ་ཅིབ་ཡུལ་དུ་དུར་ས་མེད་པས་ཁྱོད་ཀྱིས་ང་ཚོ་དབེན་སྟོང་ལ་འཆི་བར་ཁྲིད་དམ། ཁྱོད་ཀྱིས་ངེད་རྣམས་ལ་འདི་ལྟར་བྱས་ཏེ་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱིར་ཁྲིད་འོངས་པ་ཅི་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ངེད་ཅག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་ཁྱོད་ལ། ངེད་རྣམས་འདིར་བསྐྱུར་ནས་ཨེ་ཅིབ་པ་རྣམས་ལ་གཡོག་བྱེད་དུ་ཆུག་ཅེས་སྨྲས་པ་མ་ཡིན་ནམ། ཅིའི་ཕྱིར་ཞེ་ན། དབེན་སྟོང་དུ་འཆི་བ་ལས་ཨེ་ཅིབ་པ་རྣམས་ལ་གཡོག་བྱས་ན་ལེགས་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","དེ་ནས་མོ་ཤེ་ཡིས་མི་རྣམས་ལ་འདི་ལྟར། མི་འཇིགས་པར་བརྟན་པོར་སྡོད་ཅིག དཀོན་མཆོག་ཡ་ཝཱེས་དེ་རིང་ཉིན་མོར་ཁྱོད་ཅག་ལ་གནང་ངེས་པའི་ཐར་པ་ལ་ལྟོས་དང་། དེ་རིང་ཉིན་མོར་ཁྱོད་རྣམས་ཀྱིས་མཐོང་བའི་ཨེ་ཅིབ་པ་དེ་དག་ནི་ཕྱིས་སུ་ནམ་ཡང་མཐོང་བར་མི་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ཁྱོད་ཅག་ལྷོད་ལྷོད་གྱིས་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་གི་དོན་དུ་འཐབ་མོ་མཛད་ངེས་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ང་ལ་ངུ་འབོད་བྱེད་དོན་ཅི། ཡེས་ར་ཨེལ་པ་རྣམས་མདུན་དུ་འགྲོ་བའི་བཀའ་གནོངས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ཁྱོད་ཀྱིས་འཁར་བ་ཡར་བཀྱགས་ནས་ལག་པ་རྒྱ་མཚོའི་ཕྱོགས་སུ་རྐྱོངས་ལ་མཚོ་ཁག་གཉིས་སུ་ཕྱེས་ཤིག ཡེས་ར་ཨེལ་པ་རྣམས་རྒྱ་མཚོའི་དཀྱིལ་ནས་སྐམ་སའི་སྟེང་དུ་བགྲོད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ལྟོས་དང་། ངས་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་སེམས་གྱོང་པོར་བྱས་ཏེ་ཁོ་རྣམས་དེ་དག་གི་རྗེས་དེད་ནས་འགྲོ་བ་དང་། ཕཱར་ཨོལ་དང་དེའི་དམག་དཔུང་དང་། ཤིང་རྟ་དང་སྐྱ་དམག་རྣམས་བརྒྱུད་ནས་བདག་ལ་གཟི་བརྗིད་ལྡན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ཡང་ཕཱར་ཨོལ་དང་དེའི་ཤིང་རྟ་དང་སྐྱ་དམག་རྣམས་བརྒྱུད་ནས་བདག་ལ་གཟི་བརྗིད་ཐོབ་པའི་ཚེ། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་བདག་ནི་ཡ་ཝཱེ་ཡིན་པ་ཤེས་པར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ཡེས་ར་ཨེལ་གྱི་སྒར་གྱི་སྔོན་ལ་སྐྱོད་པའི་དཀོན་མཆོག་གི་ཕོ་ཉ་ནི་དེ་དག་གི་རྒྱབ་ཏུ་སླེབས་ཤིང་། སྤྲིན་གྱི་ཀ་བ་ཡང་དེ་དག་གི་མདུན་ཕྱོགས་ནས་སོང་སྟེ་རྒྱབ་ཏུ་འགྲེང་ནས་བཞུགས། ");
INSERT INTO bodn_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","དེ་ལྟར་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་སྒར་དང་ཡེས་ར་ཨེལ་གྱི་སྒར་གཉིས་ཀྱི་བར་དུ་སྤྲིན་གྱི་ཀ་བ་བཞུགས་ཤིང་། ཕྱོགས་གཅིག་ནི་མུན་ནག་ཡིན་ཡང་ཅིག་ཤོས་སུ་འོད་འཕྲོ་བ་ཡིན་པས། མི་དེ་དག་མཚན་གང་པོར་ཕན་ཚུན་ཉེ་བར་མ་བཅར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","དེ་ནས་མོ་ཤེ་ཡིས་ལག་པ་རྒྱ་མཚོའི་ཕྱོགས་སུ་བརྐྱངས་པ་ན། དཀོན་མཆོག་ཡ་ཝཱེས་མཚན་གང་པོར་ཤར་རླུང་དྲག་པོ་གཡུག་ཏུ་བཅུག་ནས། མཚོ་དེད་ཅིང་སྐམ་སར་མཛད་དེ་ཆུ་ཁག་གཉིས་སུ་ཕྱེས། ");
INSERT INTO bodn_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ཡེས་ར་ཨེལ་པ་རྣམས་རྒྱ་མཚོའི་དཀྱིལ་ནས་སྐམ་སར་འགྲུལ་ཏེ། ཆུ་ནི་གཡས་གཡོན་དུ་ལྕགས་རི་ལྟར་གྲུབ། ");
INSERT INTO bodn_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་རྗེས་དེད་ཅིང་། ཕཱར་ཨོལ་གྱི་རྟ་རྣམས་དང་། ཤིང་རྟ། སྐྱ་དམག་བཅས་ཐམས་ཅད་དེ་རྣམས་ཀྱི་རྗེས་དེད་ནས་རྒྱ་མཚོའི་དཀྱིལ་དུ་སོང་། ");
INSERT INTO bodn_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ནམ་ལངས་པའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེས་མེ་དང་སྤྲིན་གྱི་ཀ་བ་ནས་ཨེ་ཅིབ་པའི་དམག་དཔུང་ལ་གཟིགས་ཏེ་ཁོ་རྣམས་འཁྲུག་པར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ཡང་ཁོང་གིས་ཤིང་རྟ་རྣམས་ཀྱི་འཁོར་ལོ་བཏོན་པ་དང་། ཤིང་རྟ་དེ་དག་འདེད་དཀའ་བར་གྱུར་པས། ཨེ་ཅིབ་པ་རྣམས་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རྣམས་ཀྱི་ཕྱིར་དུ་བདག་ཅག་ལ་རྒོལ་བས། ཡེས་ར་ཨེལ་གྱི་མདུན་ནས་འབྲོ་བར་བྱའོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཨེ་ཅིབ་པ་དང་དེ་དག་གི་ཤིང་རྟ་དང་སྐྱ་དམག་རྣམས་ཀྱི་ཐོག་ལ་ཆུ་འབབ་པའི་ཕྱིར། ཁྱོད་ཀྱིས་ལག་པ་རྒྱ་མཚོའི་ཕྱོགས་སུ་རྐྱོངས་ཤིག་ཅེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","མོ་ཤེ་ཡིས་ལག་པ་རྒྱ་མཚོའི་ཕྱོགས་སུ་བརྐྱངས་ཤིང་། ཐོ་རངས་ཀྱི་དུས་སུ་རྒྱ་མཚོ་ནི་སྔར་དང་འདྲ་བར་གྱུར། ཨེ་ཅིབ་པ་རྣམས་དེའི་ཐད་དུ་བྲོས་པ་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རྣམས་རྒྱ་མཚོའི་དཀྱིལ་དུ་མགོ་རྟིང་བསློགས་པར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","དེ་ལྟར་ཆུ་ནི་ཕྱིར་བཞུར་ཏེ་ཤིང་རྟ་དང་སྐྱ་དམག་རྣམས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་རྗེས་དེད་ནས་རྒྱ་མཚོའི་ནང་དུ་སོང་བའི་ཕཱར་ཨོལ་གྱི་དམག་དཔུང་ཐམས་ཅད་བསྣུབས་ཤིང་གཅིག་ཀྱང་མ་ལུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","འོན་ཀྱང་ཡེས་ར་ཨེལ་པ་རྣམས་རྒྱ་མཚོའི་དཀྱིལ་དུ་སྐམ་སར་འགྲུལ་ཏེ། ཆུ་ནི་དེ་དག་གི་གཡས་གཡོན་དུ་ལྕགས་རི་ལྟར་གྲུབ། ");
INSERT INTO bodn_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ཉིན་མོ་དེར་དཀོན་མཆོག་ཡ་ཝཱེས་དེ་ལྟར་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་པ་དག་གི་ལག་ནས་ཐར་བར་མཛད་ཅིང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཨེ་ཅིབ་པ་དག་གི་བེམ་པོ་རྣམས་རྒྱ་མཚོའི་འགྲམ་དུ་ཡོད་པ་མཐོང་། ");
INSERT INTO bodn_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་ཅིབ་པ་རྣམས་ལ་མཛད་པའི་ནུས་མཐུ་ཆེན་པོ་དེ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མཐོང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གུས་ཤིང་འཇིགས་ཏེ། ཁོང་དང་ཁོང་གི་ཞབས་ཕྱི་མོ་ཤེ་ལ་ཡིད་ཆེས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","དེ་ནས་མོ་ཤེ་དང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་གླུ་ཕུལ་བ་འདི་ལྟ་སྟེ། བདག་གིས་ཡ་ཝཱེ་ཁོང་ལ་བསྟོད་གླུ་འབུལ། ། ཁོང་ནི་དཔལ་དང་བཅས་ཏེ་རྒྱལ་བར་གྱུར། ། རྟ་དང་དེ་ལ་ཞོན་མཁན་ཁོང་གིས་ནི། ། རྒྱ་མཚོའི་ནང་དུ་གཡུགས་པར་གྱུར་པ་འོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ཡ་ཝཱེ་ཁོང་ཉིད་ང་ཡི་སྟོབས་ཤུགས་དང་། ། ཡ་ཝཱེ་ཁོང་ཉིད་ང་ཡི་མགུར་མ་ཡིན། ། ཁོང་ནི་ང་ཡི་སྐྱབས་སུ་གྱུར་པ་ཡིན། ། ང་ཡི་དཀོན་མཆོག་ལགས་པས་ངས་ཁོང་ལ། ། བསྟོད་པ་འབུལ་ལོ་ཁོང་ནི་ངའི་ཕ་ཡི། ། དཀོན་མཆོག་ཀྱང་ནི་ཡིན་པས་བཀུར་བར་བྱ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ཡ་ཝཱེ་ཁོང་ཉིད་དམག་གི་དཔའ་བོ་དང་། ། ཡ་ཝཱེ་ཞེས་པ་ཁོང་གི་མཚན་ཡང་ལགས། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ཕཱར་ཨོལ་ཞེས་པའི་ཤིང་རྟ་རྣམས་དང་ནི། ། དེ་ཡི་དམག་དཔུང་བཅས་ནི་རྒྱ་མཚོར་གཡུགས། ། དམག་དཔོན་མཆོག་རྣམས་ཀྱང་ནི་ཁོང་ཉིད་ཀྱིས། ། རྒྱ་མཚོ་དམར་པོའི་ནང་ལ་ནུབ་ཏུ་བཅུག ། ");
INSERT INTO bodn_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","གཏིང་ཟབ་ཆུ་ཡིས་དེ་དག་བསྣུབས་པ་དང་། ། རྡོ་ལྟར་དེ་དག་རྒྱ་མཚོའི་མཐིལ་དུ་ལྷུང་། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ཀྱེ་ཀྱེ་ཡ་ཝཱེ་ལགས་ཀྱེ་ཁྱེད་ཀྱི་ནི། ། ཕྱག་གཡས་དེ་ལ་མཐུ་མངོན་དཔལ་དང་ལྡན། ། ཀྱེ་ཀྱེ་ཡ་ཝཱེ་ལགས་ཀྱེ་ཁྱེད་ཀྱིས་ནི། ། ཕྱག་གཡས་དེ་ཡིས་དགྲ་རྣམས་རྡུལ་དུ་བརླགས། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ཁྱེད་ཀྱིས་བརྗིད་ཉམས་ཆེན་པོ་དང་བཅས་ཏེ། ། ངོ་རྒོལ་བྱེད་མཁན་ཐམས་ཅད་བཟློགས་པ་དང་། ། ཁྱེད་ཀྱིས་རང་གི་ཐུགས་ཁྲོའི་མེ་ཡང་གནང་། ། མེ་དེས་ཁོ་རྣམས་སོག་མ་ལྟར་དུ་བསྲེགས། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ཁྱེད་ཀྱི་ཤངས་ལས་ཐོན་པའི་དབུགས་ཀྱིས་ནི། ། ཆུ་རྣམས་མཉམ་དུ་བསགས་ཤིང་ཆུ་རླབས་དག ། རགས་ལྟར་ལངས་ཏེ་བསྡད་ཅིང་སྡོད་པ་ཡིན། ། རྒྱ་མཚོའི་སྙིང་ནས་ཆུ་རྣམས་གོང་བུར་གྲུབ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","དགྲ་བོ་ན་རེ་ངས་ནི་ཁོ་རྣམས་ཀྱི། ། ར་མདར་བརྒྱུགས་ནས་རྗེས་སུ་ཆོད་པར་བྱ། ། བཅོམ་ནོར་དག་ནི་བགོ་བཤའ་རྒྱག་པར་བྱ། ། ང་རང་དེ་ཚོའི་སྟེང་ནས་རང་གི་ནི། ། འདོད་པ་ཚིམ་པར་འགྱུར་ཞིང་རལ་གྲི་ཕྱུང་། ། དངོས་སུ་དེ་དག་མེད་པར་བྱ་ཞེས་སྨྲ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ཁྱེད་ཀྱིས་ཞལ་ཕུ་དང་བཅས་རླུང་གཡུགས་མཛད། ། རྒྱ་མཚོས་དེ་དག་བསྣུབས་པར་བྱས་པ་དང་། ། ཞ་ཉེ་ལྟར་དུ་ཆུ་བོའི་ཀླུང་དུ་ནུབ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ཀྱེ་ཀྱེ་ཡ་ཝཱེ་ལགས་ཀྱེ་ལྷ་རྣམས་ཁྲོད། ། ཁྱེད་དང་འདྲ་བ་སུ་ཡོད་སུ་ཡང་མེད། ། དམ་པའི་ནང་ཡང་ཁྱེད་ལྟར་དཔལ་ལྡན་པ། ། སུ་ཡང་མེད་དེ་བསྟོད་ཅིང་འཇིགས་འོས་ལ། ། ངོ་མཚར་དོན་རྣམས་མཛད་ལ་ཁྱེད་འདྲ་མེད། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ཁྱེད་ཀྱིས་ཕྱག་གཡས་བརྐྱངས་ཚེ་ས་ཡིས་ནི། ། དེ་དག་ཁྱུར་མིད་བཏང་ཞིང་ཁྱེད་ཀྱིས་ནི། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","བྱམས་དང་སྙིང་རྗེ་ངང་ནས་བླུས་པ་ཡི། ། མི་རྣམས་ཁྲིད་པར་མཛད་ཅིང་མཐུ་ཡིས་ནི། ། ཉིད་ཀྱི་དམ་པའི་གནས་སུ་དེ་དག་དྲངས། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","མི་གཞན་རྣམས་ཀྱིས་གཏམ་དེ་ཐོས་ནས་འདར། ། ཕེ་ལེ་ཤེད་ཀྱི་མི་རྣམས་ཟུག་རྔུས་བཟུང་། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ཨེ་དོམ་དཔོན་རིགས་རྣམས་ནི་ཧོན་འཐོར་ཞིང་། ། མོ་ཨབ་དཔའ་བོ་རྣམས་ཀྱང་འདར་ཞིང་འདར། ། ཀ་ན་ཨན་པ་ཀུན་གྱི་སྙིང་སྟོབས་ཞུམ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","དངངས་སྐྲག་དང་ནི་འཇིགས་སྣང་ཁོ་རྣམས་ཀྱི། ། སྟེང་ལ་བབས་སོང་ཀྱེ་ཀྱེ་ཡ་ཝཱེ་ལགས། ། ཁྱེད་ཀྱི་འབངས་མི་དེ་དག་ཕ་རོལ་ཏུ། ། སླེབས་པའི་བར་དང་ཁྱེད་ཀྱིས་བླུས་པ་ཡི། ། མི་རྣམས་ཕར་རོལ་སླེབས་པའི་བར་དུ་ནི། ། ཁྱེད་ཀྱི་ཕྱག་གི་ནུས་མཐུའི་དབང་གིས་ནི། ། མི་གཞན་རྡོ་བཞིན་གྲགས་འགུལ་མེད་པར་ལུས། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ཀྱེ་ཀྱེ་ཡ་ཝཱེ་ལགས་ཀྱེ་ཁྱེད་ཉིད་ཀྱི། ། གནས་མཆོག་དེ་ནི་ཁྱེད་ཀྱིས་བཞེངས་པ་དང༌། ། རང་གི་ཕྱག་གིས་བཙུགས་པའི་གནས་མཆོག་དེར། ། མི་རྣམས་ཁྲིད་དེ་ཁྱེད་ཀྱི་ནོར་སྐལ་གྱི། ། རི་ལ་སྡོད་དུ་འཇུག་གོ་ཨེ་མ་རྨད། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ཡ་ཝཱེ་ཁྱེད་ཀྱིས་རྒྱུན་ནས་རྒྱུན་དུ་ནི། ། རྒྱལ་སྲིད་བསྐྱངས་ཤིང་སྐྱོང་བར་འགྱུར་བ་འོ། །ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ཕཱར་ཨོལ་གྱི་རྟ་དག་དང་། གཞན་ཤིང་རྟ་དང་སྐྱ་དམག་བཅས་རྒྱ་མཚོར་ཆས་ཚེ། དཀོན་མཆོག་ཡ་ཝཱེས་རྒྱ་མཚོའི་ཆུ་རྣམས་དེ་དག་གི་ཐོག་ཏུ་སླར་དྲངས་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་འབའ་ཞིག་རྒྱ་མཚོའི་དཀྱིལ་ནས་སྐམ་སར་འགྲུལ་ཏེ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ཡང་ཨ་རོན་གྱི་གཅེན་མོ་སྟེ་ལུང་སྟོན་མ་མིར་ཡམ་གྱིས་ལག་ཏུ་སིལ་རྔ་ཞིག་ཐོགས་ནས། བུད་མེད་ཐམས་ཅད་ཀྱང་ཁོ་མོའི་རྗེས་སུ་འབྲངས་ཏེ་ལག་ཏུ་སིལ་རྔ་ཁྱེར་ནས་སླེབས་ཤིང་བྲོ་འཁྲབ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","མིར་ཡམ་གྱིས་དེ་དག་གི་ལན་དུ། ཡ་ཝཱེ་ཁོང་ནི་དཔལ་བཅས་རྣམ་པར་རྒྱལ། ། ཁོང་ལ་བསྟོད་པའི་གླུ་ནི་ལེན་པར་གྱིས། ། རྟ་དང་དེ་ལ་ཞོན་མཁན་ཁོང་གིས་ནི། ། རྒྱ་མཚོའི་ནང་དུ་གཡུགས་པར་གྱུར་པ་འོ། ། ཞེས་བསྟོད་གླུ་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་རྒྱ་མཚོ་དམར་པོ་ནས་ཁྲིད་དེ་མདུན་དུ་བསྐྱོད་ཅིང་། དེ་དག་ཤུར་གྱི་དབེན་སྟོང་དུ་སླེབས་པ་དང་། ཉིན་གསུམ་ལ་དབེན་སྟོང་དུ་འགྲུལ་ནས་ཆུ་མ་ཐོབ། ");
INSERT INTO bodn_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","མཱ་ར་བྱ་བའི་གནས་སུ་སླེབས་པ་ན་མཱ་ར་ཡི་ཆུ་ནི་ཁ་ཏིག་ཡིན་པས་འཐུང་མ་ནུས། དེའི་ཕྱིར་ཡུལ་དེའི་མིང་ལ་མཱ་ར་ཞེས་ཟེར། ");
INSERT INTO bodn_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","དེར་མི་རྣམས་ཀྱིས་མོ་ཤེ་ལ་སྡུག་ཡུས་བཏོན་ཏེ། ངེད་ཅག་གིས་ཅི་འཐུང་ངམ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུ་འབོད་བྱས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་ལྗོན་ཤིང་ཞིག་བསྟན་པ་དང་། ཁོས་དེ་ཆུའི་ནང་དུ་གཡུགས་པ་ན་ཆུ་མངར་མོར་གྱུར། དེར་དཀོན་མཆོག་ཡ་ཝཱེས་དེ་དག་ལ་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་བཙུགས་ནས་ཁོ་རྣམས་ལ་བརྟགས་ཤིང་གསུངས་པ་ནི། ");
INSERT INTO bodn_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ཁྱོད་ཅག་གིས་གཟབ་གཟབ་ངང་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་གསུང་སྐད་ལ་མཉན་ཏེ། ཁོང་གི་སྤྱན་སྔར་ལེགས་པོ་གང་ཡིན་དེ་སྤྱོད་ཅིང་། གཟབ་ནན་ངང་ཁོང་གི་བཀའ་རྣམས་ལ་མཉན་པ་དང་། སྒྲིག་ཁྲིམས་ཐམས་ཅད་བསྲུངས་ན། ངས་ཨེ་ཅིབ་པ་རྣམས་ལ་ཕོག་ཏུ་བཅུག་པའི་ནད་ཡམས་གང་ཡང་ཁྱོད་ཅག་ལ་འབྱུང་བར་མི་བྱ་སྟེ། ང་ནི་ཁྱོད་རང་གསོ་མཁན་ཡ་ཝཱེ་ཡིན་པའི་ཕྱིར་རོ་ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","དེ་ནས་ཁོ་རྣམས་ཨེ་ལིམ་ཡུལ་དུ་སླེབས་ཤིང་དེ་རུ་ཆུ་མིག་བཅུ་གཉིས་དང་ཏ་ལའི་ཤིང་བདུན་ཅུ་ཡོད་པ་ཡིན། དེར་ཁོ་རྣམས་ཀྱིས་ཆུ་འགྲམ་དུ་སྒར་བཏབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ཨེ་ལིམ་ཡུལ་ནས་ཆས་པ་དང་། ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་པའི་ཟླ་གཉིས་པའི་ཚེས་བཅོ་ལྔའི་ཉིན་ཨེ་ལིམ་ཡུལ་དང་རི་བོ་སི་ནཱའི་བར་དུ་ཡོད་པའི་སིན་བྱ་བའི་དབེན་སྟོང་དུ་སླེབས། ");
INSERT INTO bodn_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ཡང་དབེན་སྟོང་ནས་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཐམས་ཅད་ཀྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་སྡུག་ཡུས་བཏོན་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ངེད་ཅག་ཨེ་ཅིབ་ཡུལ་དུ་ཤའི་ཁོག་མའི་རྩར་བསྡད་པ་དང་། གྲོད་ཁོག་འགྲང་བའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱག་ནས་ཤི་བ་ཡིན་ན་ཅི་མ་རུང་། ཁྱོད་གཉིས་ཀྱིས་ངེད་ཅག་གི་ཚོགས་ཐམས་ཅད་བཀྲེས་ལྟོགས་ཀྱིས་འཆི་བའི་ཕྱིར་དབེན་སྟོང་འདིར་ཁྲིད་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ལྟོས་དང་། ཁྱོད་ཅག་གི་ཕྱིར་བདག་གིས་ནམ་མཁའ་ནས་བག་ལེབ་འབབ་པར་བྱ་སྟེ། མི་རྣམས་ཕྱི་རུ་སོང་ནས་ཉིན་རེ་བཞིན་ཉིན་གཅིག་གི་སྐལ་བ་བསྡུ་དགོས་ཏེ། དེ་དག་གིས་ངའི་བཀའ་ཁྲིམས་བཞིན་དུ་བྱའམ་མི་བྱ་ལ་བརྟག་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ཡང་ཉིན་དྲུག་པ་ལ་སོ་སོས་བསྡུས་འོངས་པ་དེ་གྲ་སྒྲིག་བྱེད་དགོས་ཤིང་། དེ་ནི་ཉིན་རེར་བསྡུས་པ་ལས་ལྡབ་གཉིས་ཡོད་པར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་འདི་ལྟར། ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་མཁན་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པ་ཁྱོད་ཅག་གིས་དགོང་མོའི་དུས་སུ་ཤེས་ཡོང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་རྣམས་ཀྱིས་ཁོང་ལ་སྡུག་ཡུས་འདོན་པ་གསན་པས། ཐོ་རངས་ཁྱོད་ཅག་གིས་ཁོང་གི་གཟི་བརྗིད་མཐོང་བར་འགྱུར། ཁྱོད་ཅག་གིས་ངེད་གཉིས་ལ་སྡུག་ཡུས་འདོན་པ་ངེད་གཉིས་ཅི་ཡིན་ནམ་ཞེས་སྨྲས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ཡང་མོ་ཤེ་ན་རེ། ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྡུག་ཡུས་བཏོན་པ་ཁོང་གིས་ཐམས་ཅད་གསན་པས། ཁྱོད་ཅག་ལ་དགོང་མོའི་ཁ་ཟས་སུ་ཤ་དང་ཐོ་རངས་སུ་ལྟོ་བ་འགྲང་བའི་བག་ལེབ་གནང་བར་འགྱུར། ངེད་གཉིས་སུ་ཡིན་ནམ། ཁྱོད་ཅག་གིས་ངེད་གཉིས་ལ་སྡུག་ཡུས་འདོན་པ་མ་ཡིན་པར། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྡུག་ཡུས་འདོན་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","དེ་ནས་མོ་ཤེ་ཡིས་ཨ་རོན་ལ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ལ། ཁོང་གིས་ཁྱོད་ཅག་གི་སྡུག་ཡུས་གསན་པའི་ཕྱིར། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཚུར་ཤོག་ཅེས་སྨྲ་བར་གྱིས་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ཨ་རོན་གྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ལ་གཏམ་སྨྲ་བའི་ཚེ། དེ་དག་གིས་དབེན་སྟོང་གི་ཕྱོགས་སུ་བལྟས་ཤིང་། ཀྱེ་ཧོ། སྤྲིན་གྱི་ནང་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་མངོན་པར་གྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྡུག་ཡུས་གསན་པ་དང་། ཁྱོད་ཀྱིས་དེ་དག་ལ་འདི་ལྟར། ས་སྲོས་ཀྱི་དུས་སུ་ཁྱོད་ཅག་གིས་ཤ་བཟའ་བ་དང་། ཐོ་རངས་བག་ལེབ་ཀྱིས་འགྲང་བར་འགྱུར་ལ། དེ་ནས་ཁྱོད་རྣམས་ཀྱིས་བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པ་ཤེས་པར་འགྱུར་ཞེས་སྨྲ་བར་གྱིས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","དེ་ནས་དགོང་མོ་སྲེག་པ་མང་པོ་ཡོང་ནས་སྒར་ཡོངས་སུ་བཀབ་ཅིང་། ཐོ་རངས་སྒར་གྱི་མཐའ་འཁོར་དུ་ཟིལ་བ་བབས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ཟིལ་བ་དེ་ས་ལ་འཐིམས་པ་དང་། ཀྱེ་ཧོ། དཀར་སྲབ་བ་མོ་ལྟ་བུའི་དངོས་པོ་ཞིག་གིས་དབེན་སྟོང་གི་ངོས་ཡོངས་སུ་བཀབ་ཡོད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་མཐོང་ནས་ཅི་ཡིན་མ་ཤེས་པར་ཕན་ཚུན་ན་རེ། དེ་ཅི་ཡིན་ནམ་ཞེས་དྲིས། དེ་ནས་མོ་ཤེ་ཡིས་དེ་དག་ལ། འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་ལ་བཟའ་བར་གནང་བའི་བག་ལེབ་དེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ནི་འདི་ལྟར་ཡིན་ཏེ། རེ་རེས་རང་གི་ཟ་ཚད་སྡུས་ལ། སོ་སོས་རང་གི་གུར་ནང་གི་མི་གྲངས་བཞིན་དུ་མི་རེ་ལ་ཨོ་མཱར་ རེ་ལོངས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་བཞིན་བྱས་ཏེ། ཁ་ཤས་ཀྱིས་མང་པོ་བསྡུས། ཁ་ཤས་ཀྱིས་ཉུང་ངུ་བསྡུས། ");
INSERT INTO bodn_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ཨོ་མཱར་གྱི་ཚད་འཇལ་བ་ན་མང་པོ་བསྡུ་མཁན་དེར་ལྷག་མ་མ་བྱུང་ལ། ཉུང་ངུ་བསྡུ་མཁན་དེར་མི་འདང་བའང་མེད། མི་རེ་རེས་རང་རང་གི་ཟ་ཚད་བཞིན་བསྡུས། ");
INSERT INTO bodn_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","མོ་ཤེ་ཡིས་དེ་དག་ལ། མི་སུས་ཀྱང་སང་ཉིན་ཞོགས་པའི་བར་དུ་ལྷག་མ་ཅི་ཡང་ལུས་སུ་བཅུག་མི་ཆོག་ཅེས་སྨྲས་ནའང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","དེ་དག་གིས་མོ་ཤེའི་བཀའ་ལ་མ་མཉན་པར་ཁ་ཅིག་གིས་དེའི་ཕྱི་ཉིན་ཞོགས་པའི་བར་དུ་ལྷག་མ་ལུས་སུ་བཅུག་པས། དེ་ལ་འབུ་བཏབ་ནས་དྲི་ངན་བྱུང་ཞིང་། མོ་ཤེ་ཁོ་རྣམས་ལ་ཁྲོས། ");
INSERT INTO bodn_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ཁོ་རྣམས་ཀྱིས་ཞོགས་པ་རེ་རེར་རང་རང་གི་ཟ་ཚད་བཞིན་བསྡུས་ཤིང་། ཤུལ་དུ་ལྷག་པ་རྣམས་ཉི་མ་དྲོས་པ་དང་བཞུས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ཡང་ཉིན་དྲུག་པ་ལ་ཁོ་རྣམས་ཀྱིས་བག་ལེབ་ལྡབ་གཉིས་ཏེ་མི་རེ་རེར་ཨོ་མཱར་གཉིས་རེ་བསྡུས་པ་དང་། ཚོགས་དཔོན་རྣམས་ཡོང་སྟེ་མོ་ཤེ་ལ་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","མོ་ཤེ་ཡིས་དེ་དག་ལ་འདི་ལྟར། དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ནི་འདི་ལྟར་ཡིན་ཏེ། སང་ཉིན་ནི་བསྲུང་དགོས་པའི་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་ཞིང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཆེད་དུ་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་པས། ཁྱོད་ཅག་གིས་ཟས་ཅི་བསྲེག་དགོས་པ་རྣམས་སྲེགས་ཤིག བཙོ་དགོས་པ་རྣམས་ཚོས་ཤིག ཅི་ལུས་པ་ཐམས་ཅད་སང་ཉིན་ཞོགས་པའི་བར་ཞོག་ཅིག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ཁོ་རྣམས་ཀྱིས་མོ་ཤེ་ཡིས་སྨྲས་པ་བཞིན་དུ་དེའི་ཕྱི་ཉིན་ཞོགས་པའི་བར་དུ་བཞག་པ་དང་། དྲི་ངན་མ་བྱུང་ལ། དེའི་ནང་དུ་འབུ་ཡང་མ་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ཡང་མོ་ཤེ་ཡིས་ཁོ་རྣམས་ལ་འདི་ལྟར། དེ་རིང་བག་ལེབ་དེ་ཟོ་ཞིག དེ་རིང་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཆེད་དུ་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན་པས། ཁྱོད་ཅག་གིས་བག་ལེབ་དེ་དག་ཐང་ནས་རྙེད་མི་སྲིད། ");
INSERT INTO bodn_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ཉིན་དྲུག་གི་རིང་ལ་བསྡུས་ཆོག་པ་དང་། ཉིན་བདུན་པ་ནི་ངལ་གསོ་བའི་དུས་ཡིན་པས་ཅི་ཡང་འཐོབ་པར་མི་འགྱུར་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ཉིན་བདུན་པ་ལ་མི་ཚོགས་ཁྲོད་ནས་ཁ་ཤས་བག་ལེབ་བསྡུ་རུ་སོང་ཡང་ཅི་ཡང་མ་ཐོབ། ");
INSERT INTO bodn_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཅག་གིས་ནམ་ཞིག་གི་བར་དུ་ངའི་བཀའ་དང་ངའི་བཀའ་ཁྲིམས་མི་བསྲུང་བ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ལྟོས་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་ལ་ངལ་གསོ་བའི་ཉིན་དེ་གནང་བས། ཁོང་གིས་ཁྱོད་རྣམས་ལ་ཉིན་དྲུག་པར་ཉིན་གཉིས་ཀྱི་ཁ་ཟས་གནང་ཞིང་། ཉིན་བདུན་པར་མི་རེ་རེ་རང་རང་གི་གནས་སུ་འདུག་དགོས་ལ་སུ་ཡང་ཕྱི་རུ་འགྲོ་མི་ཆོག་ཅེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","མི་ཚོགས་ཀྱིས་ཉིན་བདུན་པར་ངལ་གསོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ཡང་ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་ཀྱིས་བག་ལེབ་དེའི་མིང་ལ་མཱན་ནཱ་ཞེས་བཏགས། དེ་ནི་སྔོ་སྨན་འུ་སུ་ལྟར་ཡིན་ཞིང་དཀར་པོ་ཡིན་པ་དང་། དེའི་རོ་ནི་སྦྲང་རྩི་བསྲེས་པའི་གོར་སྲབ་ལྟར་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","དེ་ནས་མོ་ཤེ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་འདི་གནང་བ་སྟེ། ཁྱོད་ཅག་གིས་མི་རབས་ཕྱི་མ་རྣམས་ཀྱི་ཕྱིར་མཱན་ནཱ་ཞེས་པ་དེ་ཨོ་མཱར་གང་གཅེས་སྲུང་བྱོས་ཤིག གང་ལ་ཟེར་ན། བདག་གིས་ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་དེ་དབེན་སྟོང་དུ་ཁྱོད་ཅག་ལ་ཟས་སུ་བྱིན་པའི་བག་ལེབ་དེ་ཁོ་རྣམས་ཀྱིས་མཐོང་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","མོ་ཤེ་ཡིས་ཨ་རོན་ལ། བུམ་པ་ཞིག་ཁྱེར་ནས་མཱན་ནཱ་ཨོ་མཱར་གང་དེའི་ནང་དུ་ཆུག་དང་། ཁྱོད་ཅག་གི་མི་རབས་ཕྱི་མ་རྣམས་ཀྱི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཞོག་ཅིག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་གནང་བ་བཞིན་དུ། ཨ་རོན་གྱིས་དེ་ལྟར་བྱས་ཤིང་། གཅེས་སྲུང་བྱེད་པའི་ཕྱིར་མཱན་ནཱ་དེ་དཔང་མཛད་ཤུར་སྒམ་གྱི་མདུན་དུ་བཞག ");
INSERT INTO bodn_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མི་གཞན་བསྡད་ཡོད་པའི་ཡུལ་ཏེ་ཀ་ན་ཨན་ཡུལ་གྱི་ས་མཚམས་སུ་སླེབས་པའི་བར་དུ་ལོ་ངོ་བཞི་བཅུའི་རིང་ལ་མཱན་ནཱ་ཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ཨོ་མཱར་གང་ནི་ཨེ་ཕཱའི་བཅུ་ཆ་གཅིག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ། ས་ཆ་ས་ཆ་བྱས་ནས་སིན་ཟེར་བའི་དབེན་སྟོང་ནས་ཆས་པ་དང་། རཱ་ཕི་དིམ་བྱ་བའི་གནས་ལ་སྒར་བཏབ། འོན་ཀྱང་མི་རྣམས་ལ་འཐུང་ཆུ་མེད་པས། ");
INSERT INTO bodn_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","མོ་ཤེ་ལ་ཁ་རྩོད་བྱས་ནས་ངེད་རྣམས་ལ་འཐུང་ཆུ་བླུད་ཅེས་སྨྲས་པར། མོ་ཤེ་ཡིས་དེ་དག་ལ། ཁྱོད་ཅག་གིས་ཅིའི་ཕྱིར་ང་ལ་ཁ་རྩོད་བྱེད་དམ། ཅིའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཚོད་བགམ་བྱེད་དམ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","མི་ཚོགས་དེ་སྐོམ་པས་གདུངས་ཏེ་མོ་ཤེ་ལ་སྡུག་ཡུས་བཏོན་ཞིང་ན་རེ། ཁྱོད་ཀྱིས་ངེད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཡར་ཁྲིད་ཡོང་སྟེ། ངེད་ཅག་དང་ངེད་རྣམས་ཀྱི་བུ་ཕྲུག་དང་། ཕྱུགས་ཟོག་རྣམས་སྐོམ་ནས་འཆི་རུ་འཇུག་དོན་ཅི་ཡིན་ཞེས་སྨྲས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུ་འབོད་བྱས་ཏེ། མི་འདི་རྣམས་ལ་བདག་གིས་ཅི་ཞིག་བྱའམ། དེ་དག་གིས་ང་རང་རྡོ་རུབ་གཏོང་གྲབས་འདུག་ཅེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་རང་མི་རྣམས་ཀྱི་མདུན་ཕྱོགས་ནས་ཕར་སྐྱོད་ཅིག ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་འགའ་ཞིག་ཁྱོད་དང་མཉམ་དུ་ཁྲིད་དང་། ནཱ་ཡོལ་གཙང་པོ་ལ་བརྡེགས་པའི་འཁར་བ་དེ་རང་གི་ལག་ཏུ་ཁྱེར་ལ་སོང་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ལྟོས་དང་། ང་རང་ཧོ་རེབ་རི་བོའི་བྲག་རྡོ་ཡོད་སར་ཁྱོད་ཀྱི་མདུན་དུ་སྡོད་པར་བྱ་སྟེ། ཁྱོད་ཀྱིས་བྲག་རྡོ་དེ་ལ་རྡུངས་དང་། མི་རྣམས་ཀྱིས་འཐུང་བའི་ཕྱིར་དེ་ལས་ཆུ་འཐོན་ཡོང་ཞེས་གསུངས་པ་དང་། མོ་ཤེ་ཡིས་ཀྱང་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་ཀྱི་མིག་མདུན་དུ་དེ་བཞིན་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་གནས་དེར་རྩོད་གླེང་སྤེལ་བ་དང་། ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཚོད་བགམས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ངེད་ཅག་གི་དཀྱིལ་དུ་བཞུགས་སམ་མི་བཞུགས་ཞེས་སྨྲས་པས། མོ་ཤེ་ཡིས་གནས་དེའི་མིང་ལ་མཱ་སཱ་ དང་མེ་རི་བཱ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","སྐབས་དེར་ཨ་མཱད་ལེག་གི་མི་རྣམས་འོངས་ཏེ། རཱ་ཕི་དིམ་ཡུལ་དུ་ཡེས་ར་ཨེལ་དང་འཐབ་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","མོ་ཤེ་ཡིས་ཡོ་ཤུ་ཨ་ལ་ན་རེ། རང་ཅག་གི་ཕྱིར་སྐྱེས་པ་རྣམས་བདམས་ནས་ཨ་མཱད་ལེག་པ་རྣམས་དང་འཐབ་ཏུ་སོང་། སང་ཉིན་བདག་གིས་ལག་ཏུ་དཀོན་མཆོག་གི་འཁར་བ་བཟུང་ནས་རི་བོའི་རྩེ་མོར་ལངས་སྡོད་པར་བྱའོ་ཞེས་སྨྲས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ཡོ་ཤུ་ཨ་ཡིས་མོ་ཤེའི་བཀའ་བཞིན་བྱས་ཏེ་ཨ་མཱད་ལེག་པ་རྣམས་དང་འཐབ་ཅིང་། མོ་ཤེ་དང་ཨ་རོན་དང་ཧུ་རཱ་བཅས་རི་བོའི་རྩེ་མོར་འགོས། ");
INSERT INTO bodn_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ཡང་འདི་ལྟར་བྱུང་བ་སྟེ། མོ་ཤེ་ཡིས་ནམ་ཞིག་ལ་ལག་པ་ཡར་བཀྱགས་ཚེ་ཡེས་ར་ཨེལ་པ་རྣམས་རྒྱལ་བ་དང་། ནམ་ཞིག་ལ་ལག་པ་མར་བཞག་ཚེ་ཨ་མཱད་ལེག་པ་རྣམས་རྒྱལ་བ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","འོན་ཀྱང་མོ་ཤེའི་ལག་པ་ངལ་བས། ཨ་རོན་དང་ཧུ་རཱ་གཉིས་ཀྱིས་རྡོ་ཞིག་ཁྱེར་འོངས་ཏེ་ཁོའི་འཕོངས་སྟེགས་བྱེད་དུ་བཅུག་པ་དང་ཁོ་དེ་ལ་བསྡད་ཅིང་། དེ་གཉིས་ཀྱིས་གཅིག་གིས་གཡས་དང་གཅིག་གིས་གཡོན་ནས་ཁོའི་ལག་པ་བསྐྱོར་བ་དང་། ཁོའི་ལག་པ་ཉི་མ་ནུབ་པའི་བར་དུ་བརྟན་པོར་ཚུགས། ");
INSERT INTO bodn_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ཡང་ཡོ་ཤུ་ཨ་ཡིས་ཨ་མཱད་ལེག་རྒྱལ་པོ་དང་དེའི་འབངས་མི་རྣམས་རལ་གྲིས་ཕམ་པར་བརྒྱབ། ");
INSERT INTO bodn_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ངས་ཨ་མཱད་ལེག་གི་མིང་ཡང་གནམ་འོག་ཏུ་རྩ་བ་ནས་གསུབ་པར་བྱ། རྗེས་དྲན་གྱི་ཕྱིར་གཏམ་དེ་ཤོག་སྒྲིལ་སྟེང་བྲིས་ཏེ་ཡོ་ཤུ་ཨའི་རྣ་ལམ་དུ་འཇོག་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","མོ་ཤེ་ཡིས་མཆོད་ཁྲི་ཞིག་བཞེངས་ནས་དེའི་མིང་ལ་དཀོན་མཆོག་ཡ་ཝཱེ་བདག་གི་རུ་དར་ཡིན་ཞེས་བཏགས་ཏེ་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","དཀོན་མཆོག་ཡ་ཝཱེས་མནའ་བཞེས་པ་ཡིན་པས། ཁོང་གིས་ཨ་མཱད་ལེག་མི་རིགས་ལ་མི་རབས་ནས་མི་རབས་བར་དུ་དཔུང་འཇུག་བྱེད་པར་འགྱུར་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ཡང་མིད༌ཡཱན་ཡུལ་གྱི་མཆོད་དཔོན་ཏེ་མོ་ཤེའི་སྒྱུག་པོ་ཡི་ཏྲོ་ཡིས། དཀོན་མཆོག་གིས་མོ་ཤེ་དང་ཉིད་ཀྱི་འབངས་མི་ཡེས་ར་ཨེལ་ལ་ཅི་དང་ཅི་མཛད་པ་ཐམས་ཅད་དེ། དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པ་ཐོས་ནས། ");
INSERT INTO bodn_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","མོ་ཤེའི་ཆུང་མ་ཚིབ་ཕའོ་རཱ་སྟེ་སྔར་མོ་ཤེ་ཡིས་ཕྱིར་ཁྱིམ་ལ་ལོག་ཏུ་བཅུག་པ་དེ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ཚིབ་ཕའོ་རཱ་ཡི་བུ་གཉིས་ཁྲིད་འོངས་པ་རེད། བུ་གཅིག་གི་མིང་ལ་གེར་ཤོམ་ཞེས་ཟེར་ཏེ། རྒྱུ་མཚན་ནི་སྔར་མོ་ཤེ་ཡིས་ང་རང་ཡུལ་གཞན་དུ་བྱེས་པར་གྱུར་ཞེས་སྨྲས་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","བུ་གཞན་དེའི་མིང་ལ་ཨེ་ལི་ཨེ་བཟིར་ཞེས་ཟེར་ཏེ། ཅི་ལ་ཞེ་ན། སྔར་མོ་ཤེ་ཡིས་བདག་གི་ཕ་ཡི་དཀོན་མཆོག་གིས་ང་ལ་རོགས་རམ་གནང་ཞིང་ཕཱར་ཨོལ་གྱི་རལ་གྲི་ནས་ཐར་བར་མཛད་ཅེས་སྨྲས་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","དེ་ལྟར་མོ་ཤེའི་སྒྱུག་པོ་ཡི་ཏྲོ་ཡིས་མོ་ཤེའི་ཆུང་མ་དང་བུ་གཉིས་ཁྲིད་ནས་དཀོན་མཆོག་གི་རི་བོ་སྟེ། མོ་ཤེ་ཡིས་དབེན་སྟོང་དུ་སྒར་འདེབས་སའི་གནས་ལ་སླེབས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ཡང་ཁོས་མི་ཞིག་མངགས་ནས་མོ་ཤེ་ལ་འདི་ལྟར། བདག་ནི་ཁྱེད་ཀྱི་སྒྱུག་པོ་ཡི་ཏྲོ་ཡིན་ཞིང་། ཁྱེད་ཀྱི་ཆུང་མ་དང་བུ་གཉིས་ཁྲིད་ནས་ཁྱེད་རང་ཡོད་ས་འདི་རུ་སླེབས་ཡོད་ཅེས་ངག་འཕྲིན་བཏང་བ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","མོ་ཤེ་སྒྱུག་པོ་བསུ་བར་སོང་སྟེ། དེའི་མདུན་དུ་གུས་ཕྱག་ཕུལ་ནས་འོ་ བྱས་པ་དང་། ཕན་ཚུན་ཁམས་འདྲི་ཞུས་ནས་གུར་གྱི་ནང་དུ་ཞུགས། ");
INSERT INTO bodn_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","དེ་ནས་མོ་ཤེ་ཡིས་སྒྱུག་པོ་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་གྱི་དོན་དུ་ཕཱར་ཨོལ་དང་ཨེ་ཅིབ་པ་རྣམས་ལ་ཅི་དང་ཅི་ཞིག་མཛད་པ་ཀུན་དང་། ལམ་དུ་མྱངས་པའི་སྡུག་བསྔལ་ཐམས་ཅད་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རྣམས་ཅི་ལྟར་བསྐྱབས་པ་བཅས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་ལ་བཀའ་དྲིན་མཛད་ཅིང་། དེ་དག་ཨེ་ཅིབ་པའི་དབང་ནས་ཐར་བར་མཛད་པས་ཡི་ཏྲོའི་སེམས་ཤིན་ཏུ་དགའ་བ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ཡང་ཁོ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་པར་ཤོག ཁོང་གིས་ཁྱེད་ཅག་ཨེ་ཅིབ་པ་རྣམས་དང༌ཕཱར་ཨོལ་གྱི་ལག་ནས་ཐར་བར་མཛད་ཅིང་། ཁོང་གིས་མི་འདི་རྣམས་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་ལག་ནས་བསྐྱབས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ལྷ་ཐམས་ཅད་དང་བསྡུར་ན་དཀོན་མཆོག་ཡ་ཝཱེ་ནུས་མཐུ་ཆེ་བ་ངས་ད་ལྟ་ཤེས་ཏེ། ཅི་ལ་ཞེ་ན། དོན་དེའི་ནང་དུ་ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་མི་རྣམས་ལ་ཁེངས་དྲེགས་ཀྱི་སྤྱོད་ཚུལ་བཟུང་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","དེ་ནས་མོ་ཤེའི་སྒྱུག་པོ་ཡི་ཏྲོས་དཀོན་མཆོག་ལ་སྦྱིན་སྲེག་ཅིག་དང་དམར་མཆོད་རྣམས་ཕུལ་བ་དང་། ཨ་རོན་ནི་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་དང་བཅས་ཡོང་ནས་མོ་ཤེའི་སྒྱུག་པོ་དང་མཉམ་དུ་དཀོན་མཆོག་གི་སྤྱན་སྔར་གསོལ་ཚིགས་བཞེས་པར་ཕེབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","དེའི་ཕྱི་ཉིན། མོ་ཤེ་མི་རྣམས་ལ་ལེགས་ཉེས་འབྱེད་པར་བཞུགས་ཤིང་། ཞོགས་པ་ནས་དགོང་མོའི་བར་དུ་མི་རྣམས་མོ་ཤེའི་དྲུང་དུ་ལངས་ནས་བསྡད། ");
INSERT INTO bodn_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","མོ་ཤེ་ཡིས་མི་རྣམས་ཀྱི་དོན་དུ་ཅི་བྱེད་པ་ཐམས་ཅད་སྒྱུག་པོས་མཐོང་སྟེ་ན་རེ། ཞོགས་པ་ནས་དགོང་མོའི་བར་དུ་མི་རྣམས་ཁྱེད་ཀྱི་དྲུང་དུ་ལངས་ནས་སྡོད་ཅིང་། ཁྱེད་རང་གཅིག་པུ་བཞུགས་ནས་འདུག་དོན་ཅི་ཡིན་ནམ་ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","མོ་ཤེ་ཡིས་སྒྱུག་པོ་ལ། དེ་ནི་མི་རྣམས་འདིར་འོངས་ནས་དཀོན་མཆོག་ལ་བཀའ་འདྲི་ཞུ་བའི་རྐྱེན་དང༌། ");
INSERT INTO bodn_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ཁོ་རྣམས་ལ་རྩོད་པ་འབྱུང་དུས་ཀྱང་ངའི་གམ་དུ་འོངས་ནས། ངས་མི་དང་མིའི་བར་ལ་ཤན་འབྱེད་པ་དང་། དཀོན་མཆོག་གི་སྒྲིག་ལམ་དང་བཀའ་ཁྲིམས་རྣམས་དེ་དག་ལ་བསླབས་པ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","སྒྱུག་པོས་མོ་ཤེ་ལ། ཁྱེད་ཀྱི་བྱེད་ལུགས་དེ་ལེགས་པོ་མི་འདུག ");
INSERT INTO bodn_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ཁྱེད་དང་ཁྱེད་ཀྱི་དྲུང་དུ་འོངས་པའི་མི་རྣམས་ཐང་ཆད་ངེས་ཡིན། དོན་དེ་ནི་ཁྱེད་ཀྱིས་ཐེག་དཀའ་ཞིང་ཁྱེད་གཅིག་པུས་བསྒྲུབ་ཀྱང་མི་ནུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ད་ལྟ་ངའི་གཏམ་ལ་གསན་པར་གྱིས། བདག་གིས་ཁྱེད་ལ་སློབ་སྟོན་བྱེད་དེ། དཀོན་མཆོག་ཁྱེད་དང་མཉམ་དུ་བཞུགས་པར་སྨོན། ཁྱེད་ནི་དཀོན་མཆོག་གི་དྲུང་དུ་འབངས་མིའི་ཚབ་བྱེད་མཁན་ཡིན་ཞིང་། རྩོད་གཞི་རྣམས་དཀོན་མཆོག་གི་དྲུང་དུ་ཕུལ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ཁྱེད་ཀྱིས་དེ་དག་ལ་སྒྲིག་ལམ་དང་བཀའ་ཁྲིམས་རྣམས་སློབས་དང་། ཁོ་རྣམས་ལ་འགྲུལ་དགོས་པའི་ལམ་དང་བྱེད་དགོས་པའི་ལས་རྣམས་སྟོན་པར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","དེ་ནས་ཁྱེད་ཀྱིས་འབངས་མིའི་ཁྲོད་ནས་སྐྱེས་པ་འཇོན་པོ་རྣམས་འདེམས་དགོས་ཏེ། དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པ་དང་། གཤིས་རྒྱུད་དྲང་བ་དང་། ལྐོག་ནོར་ལ་སྡང་བ་རྣམས་ཚོལ་དང་། དེ་དག་སྟོང་དཔོན་དང་། བརྒྱ་དཔོན་དང་། ལྔ་བཅུ་དཔོན་དང་། བཅུ་དཔོན་བཅས་བྱེད་དུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ཁོ་རྣམས་ཀྱིས་དུས་རྒྱུན་མི་རྣམས་ལ་ལེགས་ཉེས་ཀྱི་ཤན་འབྱེད་དགོས་པ་འདི་ལྟ་སྟེ། དོན་ཆེན་གང་བྱུང་བ་དེ་དག་ཁྱེད་ལ་ཞུ་དགོས་པ་དང་། དོན་ཆུང་རྣམས་རང་རང་གིས་ཐག་གིས་གཅོད་དགོས། དེ་ལྟར་བྱས་ན་ཁྱེད་ཀྱི་ལས་ཚགས་ཇེ་ཡང་དུ་འགྲོ་བ་དང་། ཁོ་རྣམས་ཀྱིས་ཁྱེད་དང་མཉམ་དུ་འགན་འཁུར་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","དོན་འདི་དཀོན་མཆོག་གིས་ཁྱེད་ལ་གནང་བའི་བཀའ་ཡིན་པ་དང་ཁྱེད་ཀྱིས་དེ་ལྟར་བྱས་ན། ཁྱེད་ཀྱིས་འགན་ཐེག་སྲིད་ཅིང་། མི་འདི་ཐམས་ཅད་ཀྱང་བདེ་བར་རང་གི་གནས་སུ་འགྲོ་བར་འགྱུར་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","དེ་ནས་མོ་ཤེ་ཡིས་སྒྱུག་པོའི་ངག་ལ་མཉན་ཏེ། ཁོས་ཅི་སྨྲས་པ་བཞིན་དུ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་དག་ལས་སྐྱེས་པ་འཇོན་པོ་རྣམས་བདམས་ཏེ་འབངས་མིའི་འགོ་དཔོན་དུ་བསྐོས་ཤིང་། སྟོང་དཔོན་དང་། བརྒྱ་དཔོན་དང༌། ལྔ་བཅུ་དཔོན་དང་། བཅུ་དཔོན་བཅས་བྱེད་དུ་བཅུག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","དེ་དག་གིས་རྟག་ཏུ་མི་རྣམས་ལ་ལེགས་ཉེས་ཀྱི་ཤན་འབྱེད་ཅིང་། ཐག་གིས་ཆོད་དཀའ་བ་རྣམས་མོ་ཤེ་ལ་གཏད། འོན་ཀྱང་དོན་ཆུང་རྣམས་རང་རང་གིས་ཐག་གཅོད་བྱེད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","དེ་ནས་མོ་ཤེ་ཡིས་རང་གི་སྒྱུག་པོར་སྐྱེལ་མ་བྱས་པ་དང་། ཁོ་ཕྱིར་རང་ཡུལ་དུ་ལོག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་ཕྱི་རུ་ཐོན་པ་ནས་ཟླ་བ་གསུམ་པའི་ཉིན་དེར་སི་ནཱ་བྱ་བའི་དབེན་སྟོང་དུ་སླེབས། ");
INSERT INTO bodn_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ཁོ་རྣམས་རཱ་ཕི་དིམ་ཡུལ་ནས་ཆས་ཏེ་སི་ནཱའི་དབེན་སྟོང་དུ་སླེབས་ནས་དེའི་རི་འདབས་སུ་སྒར་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","མོ་ཤེ་ཡར་དཀོན་མཆོག་གི་དྲུང་དུ་སོང་བ་ལ། ཁོང་གིས་རི་མགོ་ནས་མོ་ཤེ་ལ་ཞལ་འབོད་གནང་སྟེ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡ་ཀོབ་ཀྱི་ཁྱིམ་རྒྱུད་ལ་འདི་ལྟར་སྨྲོས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒྲོགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ངས་ཨེ་ཅིབ་པ་རྣམས་ལ་ཅི་ཞིག་བྱས་པ་དང་། ཇི་ལྟར་ཁྱོད་རྣམས་གླག་གི་གཤོག་པའི་སྟེང་འཁུར་བ་བཞིན་ངའི་དྲུང་དུ་ཁྲིད་པ་དེ་ཁྱོད་ཅག་གིས་མཐོང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ད་ལྟ་ཁྱོད་ཅག་གིས་དངོས་གནས་བདག་གི་ངག་ལ་མཉན་པ་དང་བདག་གི་ཁ་ཆད་བསྲུང་བ་ཡིན་ན། མི་ཐམས་ཅད་ལས་ཁྱོད་ཅག་ནི་ངའི་ནོར་བུ་ཁྱད་པར་ཅན་ཞིག་ཡིན་པར་འགྱུར། ཅིའི་ཕྱིར་ཞེ་ན། ས་གཞི་ཐམས་ཅད་བདག་གི་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ཁྱོད་ཅག་ནི་ངའི་ཕྱིར་མཆོད་དཔོན་གྱི་རྒྱལ་ཁམས་ཤིག་དང་མི་རིགས་དམ་པ་ཞིག་ཏུ་འགྱུར་ཞེས་གཏམ་འདི་དག་ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྨྲ་དགོས་པ་དེ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","དེ་ནས་མོ་ཤེ་ཕྱིར་ལོག་སྟེ་མི་རྣམས་ཀྱི་རྒན་པོ་རྣམས་བོས་ཡོང་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་ལ་གནང་བའི་བཀའ་ཐམས་ཅད་དེ་རྣམས་ལ་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","དེའི་ལན་དུ་མི་ཐམས་ཅད་ཀྱིས་མགྲིན་གཅིག་ཏུ་དཀོན་མཆོག་ཡ་ཝཱེས་ཅི་དང་ཅི་གསུངས་པ་བཞིན་དུ་ངེད་རྣམས་ཀྱིས་བསྒྲུབ་པར་བྱ་ཞེས་སྨྲས་ཤིང་། མོ་ཤེ་ཡིས་མི་རྣམས་ཀྱི་གཏམ་དེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཀྱེ་ཧོ། ང་རང་སྤྲིན་སྟུག་པོ་ཞིག་གི་ནང་ཁྱོད་ཀྱི་གམ་དུ་འོང་སྟེ། ཁྱོད་ལ་གཏམ་སྨྲ་བར་འགྱུར་བ་དེ་མི་རྣམས་ཀྱིས་ཀྱང་ཐོས་པ་དང་། ཁྱོད་ལ་རྟག་ཏུ་ཡིད་ཆེས་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས་པ་དང་། མོ་ཤེ་ཡིས་མི་རྣམས་ཀྱི་གཏམ་དེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ། ཁྱོད་རང་མི་རྣམས་ཀྱི་གམ་དུ་སོང་ནས་དེ་རིང་དང་སང་ཉིན་ཁོ་རྣམས་དམ་པར་བྱོས་ཤིག་དང་། དེ་དག་ལ་རང་གི་གོས་རྣམས་ཀྱང་བཀྲུ་རུ་ཆུག ");
INSERT INTO bodn_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ཉིན་གསུམ་པར་གྲ་སྒྲིག་བྱས་ཚར་དགོས། གང་ལ་ཟེར་ན། ཉིན་གསུམ་པར་དཀོན་མཆོག་ཡ་ཝཱེ་མི་ཐམས་ཅད་ཀྱི་མིག་མདུན་དུ་རི་བོ་སི་ནཱ་ལ་མར་ཕེབས་རྒྱུ་ཡིན་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ཁྱོད་ཀྱིས་རི་བོའི་ཕྱོགས་བཞིར་མི་རྣམས་ལ་དབྱེ་མཚམས་ཕྱེས་ནས་འདི་ལྟར། ཁྱོད་ཅག་གིས་གཟབ་གཟབ་བྱེད་དགོས་ཤིང་། རི་ལ་འགོས་པའམ་དེའི་འདབས་ལ་རེག་མི་རུང་སྟེ། སུ་ཞིག་གིས་རི་ལ་རེག་ན་དེ་ཅིས་ཀྱང་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","མི་དེ་ལྟ་བུ་ལ་ལག་པས་རེག་མི་རུང་སྟེ་རྡོ་རུབ་གཏོང་བའམ་མདའ་ཡིས་བརྒྱབ་ནས་གསོད་དགོས། དུད་འགྲོའམ་མི་གང་ཡིན་རུང་གསོན་མི་འོས་ཞེས་སྨྲ་བར་གྱིས། རྭ་དུང་གི་སྐད་ཡུན་རིང་དུ་བྱུང་ཚེ་དེ་དག་ད་གཟོད་ཡར་རི་ལ་འོང་ཆོག་པ་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","དེ་ནས་མོ་ཤེ་རི་ལས་བབས་ཏེ་མི་རྣམས་ཀྱི་གམ་དུ་འོངས་པ་དང་། ཁོ་རྣམས་དམ་པར་བྱས་ཤིང་། དེ་དག་གིས་རང་གི་གོས་རྣམས་བཀྲུས། ");
INSERT INTO bodn_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ཡང་མོ་ཤེ་ཡིས་མི་རྣམས་ལ། ཉིན་གསུམ་པར་གྲ་སྒྲིག་བྱས་ཚར་དགོས། སུ་ཡང་བུད་མེད་དང་འགྲོགས་མི་རུང་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ཉིན་གསུམ་པའི་ཞོགས་པར། འབྲུག་སྒྲ་ལྡིར་ཞིང་གློག་དམར་འཁྱུགས་པ་དང་རི་ལ་སྤྲིན་སྟུག་པོ་འཐིབས། རྭ་དུང་གི་སྐད་ཤིན་ཏུ་ཆེན་པོ་བྱུང་བས། སྒར་ལ་ཡོད་པའི་མི་ཐམས་ཅད་སྐྲག་ནས་འདར། ");
INSERT INTO bodn_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","མོ་ཤེ་ཡིས་མི་རྣམས་སྒར་གྱི་ཕྱི་རོལ་ཏུ་དཀོན་མཆོག་མཇལ་བར་ཁྲིད་ཅིང་། དེ་དག་རི་འདབས་སུ་ལངས་ནས་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","དཀོན་མཆོག་ཡ་ཝཱེ་མེ་དང་བཅས་རི་བོ་སི་ནཱ་ལ་མར་ཕེབས་པས་གནས་ཐམས་ཅད་ལས་དུ་བ་འཕྱུར་བ་དང་། མེ་ཐབ་ཀྱི་དུ་བ་ལྟར་དུ་བ་དེ་གྱེན་ལ་ལངས་ཤིང་། རི་བོ་ཡོངས་རྫོགས་ལྕིག་ལྕིག་ཏུ་འགུལ། ");
INSERT INTO bodn_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","དེ་ནས་རྭ་དུང་གི་སྐད་རིམ་བཞིན་ཆེ་རུ་ཕྱིན་པའི་སྐབས་སུ། མོ་ཤེ་ཡིས་གཏམ་ཞུས་ཤིང་དཀོན་མཆོག་གིས་གསུང་སྐད་ཞིག་གིས་ཁོ་ལ་ལན་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","དཀོན་མཆོག་ཡ་ཝཱེ་རི་བོ་སི་ནཱའི་རྩེ་མོར་མར་ཕེབས་ཤིང་། ཁོང་གིས་མོ་ཤེ་རི་མགོར་འོང་བའི་ཞལ་འབོད་གནང་བ་དང་མོ་ཤེ་རི་ལ་འགོས། ");
INSERT INTO bodn_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་མར་སོང་ནས་མི་རྣམས་ལ་ཉེན་བརྡ་ཐོངས་ཤིག དེ་ལྟར་མ་བྱས་ན། དེ་རྣམས་ཀྱིས་ང་རང་མཐོང་བའི་ཆེད་དུ་བཙན་གྱིས་མཚམས་ལས་བརྒལ་ནས་མི་མང་པོའང་འཆི་བར་ངེས། ");
INSERT INTO bodn_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་ཉེ་སར་འོང་བའི་མཆོད་དཔོན་རྣམས་ཀྱིས་རང་ཉིད་དམ་པར་བྱེད་དགོས་པ་ཡིན། དེ་མིན་ཚེ་དཀོན་མཆོག་ཡ་ཝཱེ་གློ་བུར་ཉིད་ལ་སླེབས་ནས་དེ་རྣམས་གསོད་ཉེན་ཆེ་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། མི་རྣམས་རི་བོ་སི་ནཱ་ལ་འགོས་མི་རུང་སྟེ། ཁྱེད་ཀྱིས་རི་འདིའི་ཕྱོགས་བཞིར་དབྱེ་མཚམས་ཕྱེས་ལ་དམ་པར་སྲུངས་ཤིག་ཅེས་བཀའ་གནང་བས་སོ་ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རང་ལ། མར་སོང་དང་། དེ་ནས་ཁྱོད་ཨ་རོན་དང་མཉམ་དུ་ཡར་འོང་བར་གྱིས། འོན་ཀྱང་མཆོད་དཔོན་དང་མི་རྣམས་བདག་གི་མདུན་དུ་འོང་ཕྱིར་བཙན་གྱིས་མཚམས་ལས་བརྒལ་མི་རུང་སྟེ། ཅི་ལ་ཞེ་ན། དེ་ལྟར་བྱས་ན་ང་རང་གློ་བུར་ཉིད་ལ་སླེབས་ནས་དེ་དག་གསོད་ཉེན་ཆེ་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","དེའི་ཕྱིར་མོ་ཤེ་རི་ལས་བབས་པ་དང་། མི་རྣམས་ཀྱི་གམ་དུ་སོང་ནས་དེ་དག་ལ་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","དཀོན་མཆོག་གིས་བཀའ་འདི་ཐམས་ཅད་གསུངས་ནས་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞིང་། ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་གྱི་བྲན་དུ་བཀོལ་བའི་གནས་ནས་ཁྲིད་མཁན་ཡང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ང་རང་མ་གཏོགས་པའི་དཀོན་མཆོག་གཞན་ཞིག་ཁྱོད་ལ་ཡོད་མི་ཆོག ");
INSERT INTO bodn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ཁྱོད་ཀྱིས་རང་ཉིད་ལ་སྐུ་འདྲ་དང་། སྟེང་གི་ནམ་མཁའ་འམ། འོག་གི་སའམ། ས་འོག་གི་ཆུ་ལ་ཡོད་པའི་སེམས་ཅན་གྱི་གཟུགས་བརྙན་གང་ཡང་བཟོ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","དེ་དག་ལ་ཕྱག་མ་འཚལ། བསྙེན་བཀུར་ཡང་མ་བྱེད། གང་ལ་ཟེར་ན། ཁྱོད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ང་རང་ནི་ཕྲག་དོག་ཅན་ཞིག་ཡིན་ཏེ། ཕ་རྣམས་ཀྱི་ནག་ཉེས་ཕྱིར་མི་རབས་གསུམ་མམ་བཞིའི་བར་དུ་ང་རང་ལ་སྡང་མཁན་གྱི་བུ་ཕྲུག་རྣམས་ལ་བཀའ་ཆད་གཅོད་མོད། ");
INSERT INTO bodn_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","འོན་ཀྱང་ང་རང་གཅེས་སུ་འཛིན་པ་དང་བདག་གི་བཀའ་སྲུང་མཁན་རྣམས་ལ་མི་སྟོང་ཕྲག་གི་བར་དུ་ཐུགས་བརྩེ་བར་བྱེད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ཁྱོད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་གང་བྱུང་དུ་སྤྱོད་མི་རུང་། ཅི་ལ་ཞེ་ན། སུ་ཞིག་གིས་ཁོང་གི་མཚན་གང་བྱུང་དུ་སྤྱད་ན་དཀོན་མཆོག་ཡ་ཝཱེས་མི་དེ་ཉེས་མེད་དུ་རྩི་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ངལ་གསོ་བའི་ཉིན་མོ་དྲན་ནས་དེ་དམ་པར་སྲུངས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ཉིན་དྲུག་གི་རིང་ལ་འབད་ཅིང་རང་གི་ལས་ཀ་ཚང་མ་སྒྲུབ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","འོན་ཀྱང་ཉིན་བདུན་པ་ནི་ཁྱོད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེའི་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན་པས། ཉིན་མོ་དེ་ལ་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་དང་བུ་མོ། གཡོག་པོ་དང་གཡོག་མོ། སྒོ་ཕྱུགས། རྒྱ་སྒོ་ནང་རོལ་ལ་གནས་པའི་བྱེས་པ་བཅས་ཀྱིས་ལས་ཀ་གང་ཡང་མ་བྱེད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ཅིའི་ཕྱིར་ཞེ་ན། ཉིན་དྲུག་གི་རིང་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ནམ་མཁའ་དང་ས་གཞི་དང་རྒྱ་མཚོ་དང་དེ་དག་གི་ནང་དུ་ཡོད་པ་ཐམས་ཅད་བཀོད་ནས། ཉིན་བདུན་པ་ལ་ངལ་གསོས་པའོ། །དེའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེས་ངལ་གསོ་བའི་ཉིན་མོ་དེ་ལ་བྱིན་གྱིས་བརླབས་ནས་དམ་པར་མཛད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ཁྱོད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་རྣམས་ལ་གནང་བྱའི་ཡུལ་དེར་ཚེ་ཐག་རིང་པོར་གནས་ཐུབ་པའི་ཕྱིར། རང་གི་ཕ་མ་གཉིས་ལ་བཀུར་སྟི་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ཁྱོད་ཀྱིས་མི་མ་གསོད། ");
INSERT INTO bodn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ལོག་གཡེམ་མ་བྱེད། ");
INSERT INTO bodn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","རྐུ་མ་བྱེད། ");
INSERT INTO bodn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","རང་གི་ཁྱིམ་མཚེས་ལ་རྫུན་གྱི་དཔང་པོ་མ་བྱེད། ");
INSERT INTO bodn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","གཞན་གྱི་ཁང་པ་ལ་འདོད་ཧམ་མ་བཅང་། གཞན་གྱི་ཆུང་མ་དང་། གཡོག་པོ་དང་། གཡོག་མོ་དང་། བ་གླང་དང་། བོང་བུ་དང་། དེ་ལྟར་མི་གཞན་གྱི་ཡིན་ཚད་གང་ལའང་ཧམ་པ་བཅང་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","མི་ཐམས་ཅད་ཀྱིས་འབྲུག་སྒྲ་ལྡིར་བ་དང་གློག་དམར་འཁྱུག་པ། རྭ་དུང་གི་སྐད་དང་རི་ལས་དུ་བ་འཕྱུར་བ་བཅས་མཐོང་བས། ཁོ་རྣམས་སྔངས་འདར་དང་བཅས་རྒྱང་རིང་ནས་ལངས་བསྡད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","མོ་ཤེ་ལ་འདི་ལྟར། ཁྱེད་ཀྱིས་ངེད་ཅག་ལ་གཏམ་སྨྲ་བར་མཛོད་དང་ངེད་ཅག་གིས་མཉན་པར་བྱའོ། །འོན་ཀྱང་ངེད་རྣམས་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར། དཀོན་མཆོག་གིས་ངེད་ཅག་ལ་གསུང་འབྱོན་པར་མི་བྱའོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","མོ་ཤེ་ཡིས་མི་རྣམས་ལ། མ་འཇིགས་ཤིག རྒྱུ་མཚན་ནི་དཀོན་མཆོག་ཁྱོད་རྣམས་ལ་བརྟག་པར་ཕེབས་པ་སྟེ། ཁྱོད་རྣམས་ཁོང་ལ་གུས་ཤིང་འཇིགས་པ་དང་སྡིག་པའང་མི་བྱེད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","དེ་ལྟར་མི་རྣམས་རྒྱང་རིང་ནས་ལངས་བསྡད་པ་དང་། མོ་ཤེ་དཀོན་མཆོག་བཞུགས་ཡོད་པའི་མུན་པ་སྟུག་པོའི་ཉེ་སར་བཅར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། བདག་གིས་ནམ་མཁའི་ཞིང་ཁམས་ནས་ཁྱོད་ཅག་ལ་གཏམ་སྨྲས་པ་ཁྱོད་རྣམས་ཀྱིས་མཐོང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ཁྱོད་ཅག་གིས་ང་ཡི་དོ་ཟླར་ཅི་ཡང་བཟོ་མི་རུང་སྟེ། རང་ཉིད་ཀྱི་ཆེད་དུ་དངུལ་གྱི་སྐུ་བརྙན་ནམ་གསེར་གྱི་སྐུ་བརྙན་གང་ཡང་བཟོ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ངའི་ཆེད་དུ་ས་ཡི་མཆོད་ཁྲི་ཞིག་བརྩིག་པར་གྱིས་ལ། དེའི་སྟེང་དུ་ཁྱོད་ཅག་གི་སྦྱིན་སྲེག་དང་། ཞི་བདེའི་མཆོད་པ་རྣམས་དང་། ར་ལུག་དང་བ་གླང་གི་མཆོད་པ་འབུལ་དགོས། ངས་རང་གི་མིང་དྲན་སྐུལ་བྱེད་པའི་གནས་གང་དང་གང་དུ་ང་རང་ཁྱོད་ཅག་གི་གམ་དུ་འོངས་ཏེ་ཁྱོད་ཅག་ལ་བྱིན་རླབས་གནང་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ཡང་གལ་ཏེ་ངའི་ཕྱིར་རྡོ་ཡི་མཆོད་ཁྲི་ཞིག་བརྩིག་པར་བྱེད་ན། མ་བཅོས་པའི་རྡོ་རྣམས་ལས་བརྩིག་པར་གྱིས། རྒྱུ་མཚན་ནི་ཁྱོད་རྣམས་ཀྱིས་དེའི་སྟེང་དུ་བཟོ་བྱེད་བཀོལ་ན་མཆོད་ཁྲི་མི་གཙང་བར་བྱེད་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ཡང་ཁྱོད་རྣམས་ཀྱི་ཁོག་སྨད་གཅེར་བུར་མི་འབུད་པའི་ཕྱིར། ཁྱོད་རྣམས་ཐེམ་སྐས་ཀྱི་སྟེང་ནས་བདག་གི་མཆོད་ཁྲི་སྟེང་དུ་མ་འབུད་ཅིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་འབངས་མིའི་མདུན་དུ་འཛུགས་དགོས་པའི་ཁྲིམས་སྲོལ་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ཁྱོད་རྣམས་ཀྱིས་ཨིབ་རི་པའི་བྲན་གཡོག་ཅིག་ཉོས་ཚེ། ཁོས་ལོ་དྲུག་གི་རིང་ལ་གཡོག་བྱེད་དགོས་པ་དང་། ལོ་བདུན་པར་ཁོ་ཚོར་རང་དབང་འཐོབ་འོས་ཏེ་རིན་ཅི་ཡང་སྤྲོད་མི་དགོས་པར་སོང་ཆོག་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ཁོ་རང་གཅིག་པུ་ཡོང་བ་ཡིན་ན། གཅིག་པུ་ཕྱིར་སོང་ཆོག་ལ། ཁོ་ཆུང་མ་དང་ལྷན་དུ་ཡོང་བ་ཡིན་ན། ཆུང་མ་ཁོ་དང་མཉམ་དུ་སོང་ཆོག ");
INSERT INTO bodn_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","དེའི་བདག་པོས་ཁོ་ལ་ཆུང་མ་ཞིག་སྤྲད་ནས། ཆུང་མ་དེས་ཁོ་ལ་བུའམ་བུ་མོ་བཙས་ན། ཆུང་མ་དང་བུ་ཕྲུག་རྣམས་བདག་པོའི་ཡིན་ཞིང་། ཁོ་རང་གཅིག་པུ་ཕྱིར་འགྲོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","གལ་ཏེ་བྲན་གཡོག་གིས་འདི་ལྟར། ངས་རང་གི་བདག་པོ་དང་ཆུང་མ་དང་བུ་ཕྲུག་རྣམས་ལ་གཅེས་ཤིང་། རང་དབང་གིས་ཕྱིར་འགྲོ་བར་མི་འདོད་ཅེས་གསལ་པོར་སྨྲས་ན། ");
INSERT INTO bodn_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ཁོའི་བདག་པོས་མི་དེ་དཀོན་མཆོག་གི་མདུན་དུ་ཁྲིད་པ་དང་། ཡང་སྒོ་མདུན་ནམ་ཡང་ན་སྒོ་འགྲམ་དུ་ཁྲིད་ནས། སྙུང་བུས་དེའི་རྣ་བ་འབིགས་དགོས་པ་དང་། མི་དེས་གཏན་དུ་བདག་པོར་གཡོག་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ཡང་མི་ཞིག་གིས་རང་གི་བུ་མོ་གཡོག་མོ་བྱེད་དུ་བཙོངས་ན། ཁོ་མོ་གཡོག་པོ་རྣམས་ལ་རང་དབང་ཐོབ་པ་བཞིན་སོང་མི་ཆོག ");
INSERT INTO bodn_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","བདག་པོས་ཁོ་མོ་རང་གི་ཕྱིར་བདམས་ཀྱང་དེ་ལ་མི་དགའ་ན། ཁོ་མོ་བླུ་རུ་འཇུག་དགོས། ཡང་བདག་པོས་ཁོ་མོ་བསླུས་པའི་རྐྱེན་གྱིས། ཁོ་མོ་ཕྱི་ཕྱོགས་པ་ལ་བཙོང་བའི་དབང་ཆ་དེ་ལ་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","གལ་ཏེ་བདག་པོས་རང་གི་བུ་ཡི་ཕྱིར་ཁོ་མོ་བདམས་པ་ཡིན་ན་དེ་ལ་རང་གི་བུ་མོ་ཡིན་པའི་སྲོལ་བཞིན་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ཡང་ཁོས་བུད་མེད་གཞན་ཞིག་ཆུང་མར་བླངས་ན། བུད་མེད་དེའི་ལྟོ་གོས་དང་གཉིས་སྦྱོར་གྱི་ཐོབ་འབབ་ཅི་ཡིན་ཡང་འཕྲི་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","དོན་འདི་གསུམ་ག་མ་བསྒྲུབས་པ་ཡིན་ན། ཁོ་མོ་བླུ་རིན་མ་འཇལ་བར་སོང་ཆོག་པ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ཡང་འདི་སྐད་དུ། སུས་ཀྱང་མི་ཞིག་ལ་བརྡུངས་ནས་བསད་ཚེ། རྡུང་མཁན་དེའི་སྲོག་ཅི་ནས་ཀྱང་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","འོན་ཀྱང་ཁོས་མི་ལ་མ་འཇབ་པར། དཀོན་མཆོག་གིས་མི་དེ་ཁོའི་ལག་ཏུ་གཏད་པ་ཡིན་ན། མི་དེ་འབྲོ་སའི་གནས་ཤིག་བདག་གིས་བཀོད་སྒྲིག་བྱེད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","གལ་ཏེ་མི་ཞིག་གིས་གཡོ་ཐབས་ཀྱིས་མི་གཞན་ཞིག་བསམ་བཞིན་དུ་བསད་ཚེ། ཁོ་རང་བདག་གི་མཆོད་ཁྲིའི་གམ་དུ་སྦས་ན་ཡང་བཟུང་སྟེ་སྲོག་གཅོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ཡང་རང་གི་ཕའམ་མ་ལ་རྡུང་མཁན་དེའི་སྲོག་ཅི་ནས་ཀྱང་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","སུས་ཀྱང་མི་གཞན་ཞིག་བཙན་ཁྲིད་བྱས་ནས་བཙོངས་པའམ་ཡང་ན་རང་གི་དབང་འོག་ཏུ་ཉར་ན། ཁོའི་སྲོག་ཅི་ནས་ཀྱང་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ཡང་རང་གི་ཕའམ་མ་ལ་སྨོན་ལོག་འདེབས་མཁན་དེའི་སྲོག་ཅི་ནས་ཀྱང་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ཡང་མི་རྣམས་འཛིང་ནས་གཅིག་གིས་གཅིག་ལ་རྡོའམ་ལག་པས་བརྡུངས་པ་དང་། ད་དུང་འཆི་བའི་ཚད་ལ་མ་སླེབས་པར་མལ་སར་ལྷུང་བ་ཙམ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","རྨས་མ་དེ་ཡང་བསྐྱར་ལངས་ནས་འཁར་བར་བརྟེན་ཏེ་ཕྱི་རོལ་ཏུ་འགྲོ་ཐུབ་པ་བྱུང་ཚེ། ཁོ་ལ་རྡུང་མཁན་དེ་ཉེས་མེད་དུ་རྩིས་ཆོག་མོད། འོན་ཀྱང་རྡུང་མཁན་གྱིས་རྨས་ཕོག་པའི་མི་དེའི་ལས་ཀར་དལ་འགོར་བྱས་པའི་གྱོང་གུད་འཚབ་དགོས་ཤིང་ཁོ་རང་སངས་དྲག་བྱེད་དུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ཡང་མི་ཞིག་གིས་རང་གི་བྲན་གཡོག་གམ་ཡང་ན་གཡོག་མོ་ལ་དབྱུག་པས་བརྡུངས་ནས་འཕྲལ་དུ་ཁོའི་ལག་ཏུ་ཤི་ན། དེས་ངེས་པར་ཉེས་ཆད་འཁུར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","འོན་ཀྱང་ཉིན་གཅིག་གམ་གཉིས་ལ་ད་དུང་གསོན་པོར་གནས་ན། ཁོ་རང་ནི་བདག་པོའི་རྒྱུ་ནོར་ཡིན་པའི་ཕྱིར་ཉེས་ཆད་འཁུར་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ཡང་མི་གཉིས་འཛིང་རེས་བྱེད་སྐབས་བུད་མེད་མངལ་དང་ལྡན་པ་ཞིག་ལ་ཁེལ་ནས་མངལ་ཤོར་དུ་བཅུག་ནའང་། ཕྱིས་སུ་གནོད་པ་གཞན་མ་བྱུང་ན། གནོད་སྐྱེལ་མཁན་གྱིས་བུད་མེད་དེའི་ཁྱོ་གའི་དགོས་འདོད་དང་། ཁྲིམས་དཔོན་རྣམས་ཀྱི་ཐག་བཅད་པ་བཞིན་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","གནོད་པ་གཞན་བྱུང་ན། དེ་ནས་སྲོག་ལ་སྲོག་ལན་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","མིག་ལ་མིག་ལན། སོ་ལ་སོ་ལན། ལག་པ་ལ་ལག་པའི་ལན། རྐང་པ་ལ་རྐང་པའི་ལན། ");
INSERT INTO bodn_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","འཚིག་རྨ་ལ་འཚིག་རྨའི་ལན། རྨས་ལ་རྨས་ལན། རྡུང་རྡེག་ལ་རྡུང་རྡེག་གིས་འཇལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ཡང་མི་ཞིག་གིས་རང་གི་བྲན་གཡོག་གི་མིག་གམ། ཡང་ན་གཡོག་མོའི་མིག་ལ་བརྒྱབ་ནས་མིག་ཞར་བར་བྱས་ན། མིག་དེའི་ཆེད་དུ་བྲན་གཡོག་དེར་རང་དབང་སྟེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ཡང་ཁོས་རང་གི་བྲན་གཡོག་གི་སོའམ། ཡང་ན་གཡོག་མོའི་སོ་བཅག་ན། སོ་དེའི་ཆེད་དུ་བྲན་གཡོག་དེར་རང་དབང་སྟེར་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ཡང་འདི་སྐད་དུ། གལ་ཏེ་བ་གླང་ཞིག་གིས་སྐྱེས་པའམ་བུད་མེད་ཅིག་ལ་བརྡུངས་ནས་བསད་ན། བ་གླང་དེ་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས། དེའི་ཤ་བཟའ་མི་རུང་། འོན་ཀྱང་གླང་བདག་ལ་ཉེས་པ་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","གལ་ཏེ་བ་གླང་དེ་སྔར་ནས་མི་ལ་རྡུང་བར་གོམས་པ་དང་། གཞན་གྱིས་བདག་པོ་ལ་ཉེན་བརྡ་སྤྲད་ཡོད་ཀྱང་། བདག་པོས་དེ་མ་བཏགས་པར་སྐྱེས་པའམ་བུད་མེད་ཅིག་ལ་བརྡུངས་ནས་བསད་པ་ཡིན་ན། དེ་རྡོ་རུབ་བཏང་སྟེ་གསོད་པ་དང་གླང་བདག་ཀྱང་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","འོན་ཀྱང་བདག་པོ་ནས་བླུ་རིན་ལེན་པ་ཡིན་ན། ཁོས་དེ་བཞིན་དུ་རང་སྲོག་གི་ཆེད་དུ་བླུ་རིན་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","བ་གླང་གིས་བུ་ཞིག་གམ་ཡང་ན་བུ་མོ་ཞིག་ལ་བརྡུངས་པ་ཡིན་ན། ཁྲིམས་དེ་བཞིན་དུ་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","བ་གླང་གིས་བྲན་གཡོག་གམ་ཡང་ན་གཡོག་མོ་ཞིག་ལ་བརྡུངས་ན། དེ་དག་གི་བདག་པོ་ལ་དངུལ་སྲང་སུམ་ཅུ་སྟེར་བ་དང་། བ་གླང་ཡང་རྡོ་རུབ་བཏང་སྟེ་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ཡང་སུ་ཞིག་གིས་དོང་ཁ་ཕྱེས་པའམ། ཡང་ན་དོང་ཞིག་བྲུས་ནས་ཁ་མ་བཀབ་པས་བ་གླང་ངམ་བོང་བུ་ཞིག་དེའི་ནང་དུ་ལྷུང་ན། ");
INSERT INTO bodn_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","དོང་གི་བདག་པོས་དེའི་རིན་དུ་ཕྱུགས་བདག་ལ་ཚབ་བཅལ་ནས། ཕྱུགས་ཤི་རོ་ནི་ཁོ་རང་ལ་དབང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ཡང་མི་ཞིག་གི་བ་གླང་གིས་གཞན་ཞིག་གི་བ་གླང་ལ་བརྡུངས་ནས་བསད་ན། བ་གླང་གསོན་པོ་དེ་བཙོངས་ནས། དེའི་རིན་ཆ་སྙོམས་སུ་བགོ་བ་དང་། བ་གླང་ཤི་རོ་ཡང་ཆ་སྙོམས་སུ་བགོ་བཤའ་རྒྱག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","འོན་ཀྱང་བ་གླང་དེ་སྔར་ནས་མི་ལ་རྡུང་བར་གོམས་ནའང་བདག་པོས་དེ་མ་བཏགས་ན། བ་གླང་ལ་བ་གླང་གིས་ཚབ་འཇལ་བ་དང་། བ་གླང་ཤི་རོ་ནི་ཁོ་རང་ལ་དབང་བ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ཡང་འདི་སྐད་དུ། མི་ཞིག་གིས་བ་གླང་ངམ་ར་ལུག་ཅིག་བརྐུས་ཏེ་བཤས་པའམ་ཡང་ན་བཙོངས་པ་ཡིན་ན། བ་གླང་གཅིག་བ་གླང་ལྔ་ཡིས་འཚབ་དགོས་ཤིང་། ར་ལུག་གཅིག་ར་ལུག་བཞི་ཡིས་འཚབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","མི་ཞིག་གིས་ཆོམ་རྐུན་ཞིག་འཕྲལ་མར་བཟུང་ཞིང་བརྡུངས་ནས་ཤི་བར་གྱུར་ཚེ། དེའི་ཕྱིར་ཁྲག་ལན་ཁྲག་གིས་འཇལ་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","གལ་ཏེ་ཉི་མ་ཤར་བའི་རྗེས་སུ་དོན་དེ་བྱུང་ན་ཁྲག་ལན་འཇལ་དགོས། སྤྱིར་རྐུན་མས་རྒྱུ་ཚབ་འཇལ་དགོས་ཤིང་། ཁོ་ལ་རྒྱུ་ཚབ་འཇལ་རྒྱུ་མེད་ན། ཁོ་རང་ཉིད་བཙོངས་ཏེ་རྒྱུ་ཚབ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","གལ་ཏེ་ཁོས་བརྐུས་པའི་བ་གླང་ངམ་བོང་བུའམ་ར་ལུག་བཅས་རྐུན་མའི་ལག་ནས་གསོན་པོ་ཡིན་ན། ལྡབ་འགྱུར་གྱིས་འཚབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","མི་ཞིག་གིས་རང་གི་ཕྱུགས་ཟོག་ནི་ཞིང་ངམ་རྒུན་ཚལ་དུ་འཚོས་ཏེ། རྗེས་སུ་ཕྱུགས་རྣམས་བཏང་ནས་གཞན་གྱི་ཞིང་ཁའང་བཟའ་བར་གྱུར་ན། རང་གི་ཞིང་དང་རྒུན་ཚལ་ནང་གི་མཆོག་ཡིན་པ་དེ་ཁོ་ལ་འཚབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","མེ་ཤོར་ནས་ཚེར་མ་བསྲེགས་ཏེ། གཞན་གྱི་མཉམ་དུ་སྤུངས་པའི་ཚར་ཕོན་དང་། གྱེན་ལ་འགྲེང་བའི་འབྲུ་སྙེ་དང་། ཡང་ན་ས་ཞིང་བཅས་ཐམས་ཅད་འཇོམས་པར་བྱས་ཚེ། མེ་གཏོང་མཁན་དེས་སྐྱིན་ཚབ་འཇལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","མི་ཞིག་གིས་ཁྱིམ་མཚེས་ལ་དངུལ་དང་ཡང་ན་རྒྱུ་རྫས་བཅོལ་བ་དང་དེའི་ཁྱིམ་ནས་རྐུན་མས་ཁྱེར་བ་དང༌། གལ་ཏེ་རྐུན་མ་བཟུང་ན། རྐུན་མ་དེས་ལྡབ་འགྱུར་གྱིས་འཚབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","གལ་ཏེ་རྐུན་མ་དེ་ལག་ཏུ་མ་ཚུད་ན། ཁྱིམ་མཚེས་ཀྱིས་རྒྱུ་རྫས་ཁྱེར་མིན་ལ་བལྟ་བའི་ཕྱིར་ཁོ་རང་ཁྲིམས་དཔོན་རྣམས་ཀྱི་དྲུང་དུ་བཅར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","མི་གཉིས་ཀྱི་གྱོད་དོན་ནི་ཉེས་པ་གང་གི་ཕྱིར་ཡིན་ཡང་། བ་གླང་ངམ་བོང་བུའམ་ར་ལུག་གམ་གོས་སམ། ཡང་ན་བོར་བའི་རྒྱུ་རྫས་གང་ཞིག་གི་ཕྱིར་དུ་མི་ཞིག་གིས་དེ་ནི་བདག་གི་ཡིན་ཞེས་ཟེར་བའི་དོན་གང་ཞིག་བྱུང་ན། རྩོད་པ་བྱུང་བའི་མི་གཉིས་ཀའི་གྱོད་དོན་ཁྲིམས་དཔོན་རྣམས་ཀྱི་དྲུང་དུ་སྙན་འབུལ་ཞུ་དགོས་པ་དང་། ཁྲིམས་དཔོན་རྣམས་ཀྱིས་མི་གང་ལ་ཉེས་ཆད་བཅད་པ་དེས་ཁྱིམ་མཚེས་ལ་ལྡབ་འགྱུར་གྱིས་འཚབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","མི་ཞིག་གིས་བོང་བུའམ་བ་གླང་ངམ་ར་ལུག་གམ། ཡང་ན་སྒོ་ཕྱུགས་གཞན་གང་ཡིན་པ་ཁྱིམ་མཚེས་ལ་བཅོལ་ཚེ། དེ་ཤི་བའམ་རྨས་སྐྱོན་བྱུང་བའམ། ཡང་ན་སུས་ཀྱང་མ་མཐོང་བར་གཞན་གྱིས་དེད་ཚེ། ");
INSERT INTO bodn_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","དེ་གཉིས་ཀྱི་བར་ལ། ཁྱིམ་མཚེས་ཀྱིས་བཅོལ་མཁན་གྱི་རྒྱུ་རྫས་མ་ཁྱེར་ཞེས་དཀོན་མཆོག་ཡ་ཝཱེ་དཔང་དུ་བཙུགས་ནས་མནའ་བསྐྱལ་དགོས་ཤིང་། བཅོལ་མཁན་གྱིས་ཀྱང་འདྲི་གཅོད་བྱེད་མཚམས་འཇོག་དགོས་པ་དང་། སྐྱིན་ཚབ་ཀྱང་སྤྲོད་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","སྒོ་ཕྱུགས་ནི་འཚོ་མཁན་གྱི་ལག་ནས་རྐུན་མ་ལ་ཤོར་ན། ཁོས་བདག་པོར་སྐྱིན་ཚབ་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","གཅན་གཟན་གྱིས་ཐེར་ཚལ་དུ་དྲལ་བ་ཡིན་ན། དཔང་པོའི་ཕྱིར་དེའི་རོ་ཁྱེར་འོངས་པ་ལས་སྐྱིན་ཚབ་འཇལ་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ཡང་མི་ཞིག་གིས་ཁྱིམ་མཚེས་ནས་ཅི་ཞིག་གཡོར་བ་ལ། བདག་པོ་ཁོ་དང་མཉམ་དུ་མེད་པའི་ཚེ་དེ་ལ་རྨས་སྐྱོན་བྱུང་བའམ་ཤི་བ་ཡིན་ན། ཅིས་ཀྱང་སྐྱིན་ཚབ་འཇལ་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","བདག་པོ་དང་མཉམ་དུ་ཡོད་ན་འཚབ་མི་དགོས། གལ་ཏེ་མི་དེས་ཁྱིམ་མཚེས་ནས་གླས་ པ་ཡིན་ན་གླ་ཆའི་ཕྱིར་ཡིན་པས་འཚབ་མི་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ཡང་འདི་སྐད་དུ། མི་ཞིག་གིས་གཉེན་རྟགས་བརྒྱབ་མེད་པའི་ན་ཆུང་བུ་མོ་ཞིག་བསླུས་ནས་དེ་དང་ལུས་འབྲེལ་བྱས་ན། རྒྱུ་བྱིན་ནས་བག་མར་ལེན་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ཕ་ནི་བུ་མོ་མི་དེ་ལ་སྟེར་བར་ཁྱོན་ནས་མི་དགའ་ན། ན་ཆུང་བུ་མོ་རྣམས་ཀྱི་རྒྱུ་རིན་བཞིན་དུ་དངུལ་འཇལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ངན་སྔགས་ཤེས་པའི་བུད་མེད་ཅིག་འཚོ་རུ་མ་འཇུག ");
INSERT INTO bodn_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","སུ་ཞིག་གིས་དུད་འགྲོ་ཞིག་དང་འཁྲིག་པ་སྤྱད་ན་དེའི་སྲོག་ཅིས་ཀྱང་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","དཀོན་མཆོག་ཡ་ཝཱེ་གཅིག་པུ་མ་གཏོགས་པར་ལྷ་གང་རུང་ལ་མཆོད་པ་འབུལ་བའི་མི་དེ་ཁྱོན་ནས་མེད་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ཁྱོད་ཅག་ཀྱང་ཨེ་ཅིབ་ཡུལ་ནས་བྱེས་པ་བྱས་མྱོང་བའི་ཕྱིར། བྱེས་པ་ཞིག་ལ་སྡུག་པོ་མ་གཏོང་། དེར་གནོན་ཤུགས་ཀྱང་སྦྱིན་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ཡུགས་མོ་དང་དྭ་ཕྲུག་སྡུག་ལ་མ་སྦྱོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","གལ་ཏེ་ཁྱོད་རྣམས་ཀྱིས་ཐབས་ཅི་ཞིག་གིས་དེ་དག་སྡུག་ལ་སྦྱར་བས་དེ་དག་གིས་ང་ལ་ཞུ་བ་ཕུལ་ན། བདག་གིས་དེ་རྣམས་ཀྱི་ཞུ་བར་ཅིས་ཀྱང་མཉན་ངེས་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ང་རང་ཁོང་ཁྲོ་རབ་ཏུ་འབར་ཏེ་ཁྱོད་རྣམས་རལ་གྲིས་འཇོམས་པར་བྱེད་པ་དང་། ཁྱོད་ཅག་གི་ཆུང་མ་རྣམས་ཡུགས་མོ་དང་། ཁྱོད་རྣམས་ཀྱི་བུ་ཕྲུག་རྣམས་དྭ་ཕྲུག་ཏུ་གཏོང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་འབངས་མི་ལས་ཁྱོད་ཅག་དང་མཉམ་དུ་ཡོད་པའི་དབུལ་པོ་རྣམས་ཀྱི་གཅིག་ལ་དངུལ་བསྐྱིས་ན། དེ་ལ་བུན་བདག་གི་ལུགས་བཞིན་མ་བྱེད། དངུལ་བུན་ལེན་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ཁྱིམ་མཚེས་ཀྱི་གོས་གཏའ་མར་བླངས་ན། ཉི་མ་མ་ནུབ་སྔོན་དུ་དེ་ལ་ཕྱིར་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","རྒྱུ་མཚན་ནི་དེ་ལ་གོས་ཁེབས་དང་ལུས་ལ་གྱོན་པ་དེ་ཁོ་ན་ལས་མེད་པས། ཁོས་ཅི་གོན་ནས་གཉིད་ལོག་པར་བྱེད་དམ། ཡང་མི་དེས་ང་ལ་ཞུ་བ་ཕུལ་ན། བདག་ནི་སྙིེང་རྗེ་ཅན་ཡིན་པས་དེ་ལ་མཉན་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","དཀོན་མཆོག་ལ་སྐུར་བ་མི་འདེབས་པ་དང་རང་གི་ཡུལ་མིའི་དཔོན་པོ་ལའང་སྐུར་བ་མི་འདེབས་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ཁྱོད་རྣམས་ཀྱིས་རང་གི་ཞིང་ནང་གི་འབྲུ་རིགས་དང་འཚིར་གཞོང་ནང་གི་བཅུད་ཁུ་དེ་བདག་ལ་མཆོད་པར་འབུལ་དགོས་པ་དང་། དེ་ལ་འགོར་འགྱངས་བྱེད་མི་རུང་། ཁྱོད་ཅག་གིས་བུ་རྣམས་ཀྱི་སྐྱེས་འགོ་ཡང་ང་ལ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","དེ་ལྟར་རང་གི་བ་གླང་དང་ར་ལུག་གི་ཕྱུགས་ཕྲུག་འགོ་མའང་བདག་ལ་འབུལ་དགོས། ཉིན་བདུན་ལ་ཨ་མ་དང་མཉམ་པོར་འདུག་ཏུ་ཆུག་ལ་ཉིན་བརྒྱད་པར་ང་ལ་འབུལ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ཁྱོད་རྣམས་ནི་ངའི་ཕྱིར་མི་དམ་པ་རྣམས་ཡིན་དགོས་པས་ན། ཐང་དུ་གཅན་གཟན་གྱིས་ཐེར་ཚལ་དུ་དྲལ་བའི་ཤ་དེ་ཁྱོད་ཅག་གིས་མི་བཟའ་བར་ཁྱི་རྣམས་ཀྱི་མདུན་ལ་གཡུགས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ཡང་འདི་སྐད་དུ། ཁྱོད་རྣམས་ཀྱིས་རྫུན་གཏམ་བསྒྲག་པར་མི་བྱའོ། །མི་ངན་དང་ཁ་མཐུན་ཏེ་རྫུན་གྱི་བདེན་དཔང་མ་བྱེད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ཁྱོད་ཅག་གིས་མི་ཚོགས་ལ་བསྟུན་ནས་ལས་ངན་པ་བྱེད་མི་རུང་། རྩོད་གཞིའི་ཐད་ནས་མང་ཕྱོགས་སུ་འཐེན་ཞིང་ཁྲིམས་ལོག་པར་བྱ་བའི་ཕྱིར་རྫུན་དཔང་མ་བྱེད། ");
INSERT INTO bodn_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","དབུལ་པོ་ཞིག་ལ་ཁྲིམས་གཅོད་སྐབས་སུ་དེ་ལ་ཕྱོགས་རིས་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ཁྱོད་རྣམས་ནི་དགྲ་ཟླའི་བ་གླང་ངམ་བོང་བུ་འཁྱར་བོ་དག་དང་ཕྲད་ན། དེ་ཅིས་ཀྱང་ཁྲིད་ཡོང་སྟེ་བདག་པོ་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ཁྱོད་ཅག་ལ་སྡང་བའི་མི་ཞིག་གི་བོང་བུ་དོས་ཀྱིས་མནན་པ་མཐོང་ན། ཁྱོད་རྣམས་ཀྱིས་དེ་མི་བསྐྱུར་བར་ཅིས་ཀྱང་དེའི་བདག་པོ་དང་མཉམ་དུ་དོས་འབོགས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ཁྱོད་ཅག་གིས་དབུལ་པོའི་གཏུག་བཤེར་གྱི་ཐད་ནས་དྲང་གཞག་འདོར་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","རྫུན་གྱི་དོན་དང་རིང་དུ་གྱེས་ཤིག ཉེས་མེད་གཞུང་དྲང་ཡིན་པའི་མི་ནི་གསོད་མི་རུང་། ཅིའི་ཕྱིར་ཞེ་ན། ངས་མི་ཉེས་ཅན་ཞིག་གཞུང་དྲང་དུ་རྩི་བར་མི་འགྱུར་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","གསུག་ནོར་གྱིས་མི་བློ་གྲོས་ཅན་གྱི་མིག་ལོང་བར་བྱེད་ཅིང་། མི་དྲང་པོ་རྣམས་ཀྱི་གཏམ་ཡང་གོ་ལྡོག་པར་བྱེད་པས། ཁྱོད་རྣམས་ཀྱིས་གསུག་ནོར་གང་ཡང་མ་ལེན་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","བྱེས་པ་ལ་གཉའ་གནོན་མ་བྱེད་ཅིག ཁྱོད་ཅག་ཀྱང་ཨེ་ཅིབ་ཡུལ་ནས་བྱེས་པ་བྱས་མྱོང་བས། བྱེས་པའི་སྐྱིད་སྡུག་ཁྱོད་ཅག་གིས་ཤེས་པ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ཡང་འདི་སྐད་དུ། ལོ་དྲུག་གི་རིང་ལ་ཁྱོད་རྣམས་ཀྱིས་ཞིང་འདེབས་པ་དང་དེའི་ལོ་ཏོག་བསྡུས་ཆོག ");
INSERT INTO bodn_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","འོན་ཀྱང་ལོ་བདུན་པ་ལ་ཁྱོད་ཅག་གིས་ཞིང་མི་རྨོ་ལ་བསློག་པར་ཡང་མི་བྱའོ། །དེ་ནས་ཁྱོད་ཅག་གི་མི་རྣམས་ལས་དབུལ་པོ་དག་གིས་དེ་ལས་བཟའ་བ་དང་། ལྷག་མ་རྣམས་ས་སྟེང་གི་དུད་འགྲོ་རྣམས་ཀྱིས་ཟོས་ཆོག་པ་ཡིན། ཁྱོད་ཅག་གི་རྒུན་ཚལ་དང་སྐྱུ་རུ་རའི་སྐྱེད་ཚལ་རྣམས་ཀྱང་ལུགས་དེ་བཞིན་དུ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ཉིན་དྲུག་གི་རིང་ལ་ཁྱོད་ཀྱིས་ལས་ཀ་བྱས་ཏེ། ཉིན་བདུན་པར་ངལ་གསོ་དགོས། གང་ལ་ཟེར་ན། ཁྱོད་རྣམས་ཀྱི་བ་གླང་དང་བོང་བུས་ཀྱང་ངལ་གསོ་དགོས་པ་དང་། ཁྱོད་ཅག་གི་གཡོག་མོའི་བུ་དང་བྱེས་པ་ལ་སྟོབས་ཤུགས་གསར་པ་འཐོབ་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ངས་ཁྱོད་རྣམས་ལ་ཅི་དང་ཅི་སྨྲས་པ་ཐམས་ཅད་གཟབ་གཟབ་ངང་སྲུངས་ཤིག གཞན་པའི་ལྷ་རྣམས་ཀྱི་མིང་མ་ཟློ་ཞིག སོ་སོའི་ཁ་ནས་ཐོས་ཀྱང་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ཡང་འདི་སྐད་དུ། ལོ་རེར་ཁྱོད་ཅག་གིས་ལན་གསུམ་དུ་བདག་ལ་དུས་ཆེན་བསྲུང་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","སྐྱུར་མེད་བག་ལེབ་ཀྱི་དུས་ཆེན་འདི་བསྲུང་དགོས། ངས་ཁྱོད་ཅག་ལ་བསྒོས་པ་བཞིན་དུ་ཨ་རྦིབ་ཟླ་བའི་ནང་དུས་བཅད་ལྟར་ཉིན་བདུན་གྱི་རིང་ལ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས་ཏེ། རྒྱུ་མཚན་ནི། ཁྱོད་ཅག་སྐབས་དེར་ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་པས་སོ། །སུ་ཡིན་ཡང་ལག་སྟོང་ལ་ངའི་མདུན་དུ་ཡོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","དེ་ནས་ཁྱོད་ཅག་གིས་ཞིང་ལ་བཏབ་པའི་ས་བོན་ལས་འབྲས་བུ་ཐོག་མ་བསྡུ་བའི་ཕྱིར་སྟོན་བསྡུ་དུས་ཆེན་གཏོང་དགོས་པ་དང་། ལོ་མཇུག་ལ་ཁྱོད་ཅག་གིས་འབྲུ་རིགས་བསྡུ་ཉར་བྱས་ནས་བསྡུ་ཉར་དུས་ཆེན་གཏོང་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ལོ་རེར་ལན་གསུམ་ལ་ཁྱོད་ཅག་གི་སྐྱེས་པ་ཐམས་ཅད་གཙོ་བོ་ཡ་ཝཱེའི་མདུན་དུ་བསླེབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ཁྱོད་ཅག་གིས་བདག་ལ་ཕུལ་བའི་དམར་མཆོད་ཀྱི་ཁྲག་དེ་སྐྱུར་རྩི་ལྡན་པའི་བག་ལེབ་དང་མཉམ་དུ་འབུལ་མི་རུང་ལ། ངའི་དུས་ཆེན་ལ་ཕུལ་བའི་ཚིལ་ནི་ཕྱི་ཉིན་ཞོགས་པའི་བར་དུ་བསྐྱུར་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ཁྱོད་ཅག་གི་ས་ཞིང་ལས་སྨིན་པའི་འབྲས་བུ་ཐོག་མ་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་བཞུགས་གནས་སུ་འབུལ་དགོས། ཁྱོད་ཅག་གིས་རེའུ་ཞིག་དེའི་ཨ་མའི་འོ་མ་ནང་དུ་བཙོ་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ཡང་འདི་སྐད་དུ། ལྟོས་དང་། ངས་ཁྱོད་ཅག་གི་སྔོན་དུ་ཕོ་ཉ་ཞིག་གཏོང་བར་བྱ་སྟེ། དེས་ལམ་བར་ནས་ཁྱོད་ཅག་བསྲུང་ཞིང་། ངས་སྟ་གོན་བྱས་པའི་གནས་སུ་འཁྲིད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ཁྱོད་ཅག་གིས་དེའི་དྲུང་དུ་གཟབ་གཟབ་གྱིས་ཤིག ཁོའི་བཀའ་ལ་ཉོན་ཅིག ཁོ་ལ་རྒྱབ་འགལ་མ་བྱེད་ཅིག ཅི་ཡིན་ཞེ་ན། བདག་གི་མིང་ཁོའི་ནང་དུ་ཡོད་པས། ཁོས་ཁྱོད་རྣམས་ཀྱི་ཉེས་པ་ལ་གུ་ཡངས་གཏོང་བར་མི་འགྱུར་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ཁྱོད་ཅག་གིས་དངོས་གནས་དེའི་བཀའ་ལ་མཉན་པ་དང་། བདག་གིས་ཇི་སྨྲས་པ་བཞིན་དུ་བྱེད་ན། བདག་གིས་ཁྱོད་ཅག་གི་དགྲ་རྣམས་དགྲ་རུ་འཛིན་ཞིང་། ཁྱོད་ཅག་ལ་རྒོལ་མཁན་རྣམས་ལ་རྒོལ་བར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","བདག་གི་ཕོ་ཉ་དེ་ཁྱོད་ཅག་གི་མདུན་དུ་བྱོན་ཏེ། ཁྱོད་ཅག་ཨེ་མོར་པ་དང་། ཧེད་པ་དང་། ཕེ་རེ་ཟི་པ་དང་། ཀ་ན་ཨན་པ་དང་། ཧེ་བི་པ་དང་། ཡེ་བུ་སི་པ་རྣམས་ཀྱི་ཡུལ་དུ་འཁྲིད་པ་དང་། བདག་གིས་མི་རིགས་དེ་རྣམས་རྩ་མེད་གཏོང་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ཁྱོད་ཅག་གིས་དེ་དག་གི་སྐུ་བརྙན་རྣམས་ལ་ཕྱག་མ་འཚལ་ཞིག དེ་རྣམས་ལ་བསྙེན་བཀུར་ཡང་མ་བྱེད་ཅིག དེ་དག་གི་བྱེད་ལུགས་བཞིན་དུ་ཡང་མ་སྤྱོད་ཅིག ཁྱོད་ཅག་གིས་དེ་དག་རྡུལ་དུ་བརླག་པ་དང་། དེ་དག་གི་རྡོ་སྐུ་རྣམས་ཀྱང་རྩ་མེད་དུ་གཏོང་བར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ཡང་ཁྱོད་ཅག་གིས་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྙེན་བཀུར་བྱེད་དགོས་ཤིང་། ཁོང་གིས་ཁྱོད་ཅག་གི་ཁ་ཟས་དང་ཆུ་ལ་བྱིན་རླབས་མཛད་པར་འགྱུར་ཞིང་། ཁྱོད་ཅག་གི་ཁྲོད་ནས་ནད་རིགས་ཀྱང་མེད་པར་བྱེད་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","མངལ་ནས་བྱིས་པ་ཤོར་བའམ་མོ་གཤམ་ནི་ཁྱོད་ཅག་གི་ཡུལ་དུ་ཡོད་མི་སྲིད། བདག་གིས་ཁྱོད་ཅག་གི་ཚེ་ཚད་ལོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ཁྱོད་རང་ཡུལ་གང་དུ་སླེབས་ནའང་། བདག་གིས་ཁྱོད་ཅག་གི་མདུན་ནས་ང་ཡི་རྔམ་བརྗིད་སྟོན་ཞིང་ཡུལ་དེའི་མི་ཐམས་ཅད་འཁྲུག་ཏུ་འཇུག་པ་དང་། ཡང་ཁྱོད་ཅག་གི་དགྲ་བོ་ཐམས་ཅད་ཀྱིས་ཁྱོད་ཅག་ལ་རང་རང་གི་རྒྱབ་སྟོན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ཡང་ངས་ཁྱོད་ཅག་གི་སྔུན་ལ་དུག་སྦྲང་མང་པོ་བཏང་ནས། དེ་དག་གིས་ཧེ་བི་པ་དང་ཀ་ན་ཨན་པ་དང་ཧེད་པ་རྣམས་སྐྲོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ཡུལ་ནི་ས་སྟོང་དུ་ལུས་ཤིང་། ཁྱོད་ཅག་ལ་གནོད་པའི་ས་སྟེང་གི་གཅན་གཟན་རྣམས་འཕེལ་ཉེན་ཡོད་པས། ངས་མི་དེ་དག་ལོ་གཅིག་གི་རིང་ལ་སྐྲོད་པར་མི་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","བདག་གིས་ཁྱོད་ཅག་གི་མི་གྲངས་འཕེལ་ནས་ཡུལ་དེ་བདག་གིར་བཟུང་བའི་བར་དུ་ཁོ་རྣམས་རིམ་བཞིན་སྐྲོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ངས་ཁྱོད་ཅག་གི་མཐའ་རྣམས་སུ་རྒྱ་མཚོ་དམར་པོ་ནས་ཕེ་ལེ་ཤེད་པའི་རྒྱ་མཚོའི་བར་དང་། དབེན་སྟོང་ནས་ཕི་རཱད་ཆུ་བོའི་བར་དུ་མཚམས་ཤིག་ཕྱེ་བར་བྱ། བདག་གིས་ཡུལ་དེའི་མི་རྣམས་ཁྱོད་ཅག་གི་ལག་ཏུ་སྤྲོད་ཅིང་། ཁྱོད་ཅག་གིས་དེ་དག་རང་གི་མདུན་ནས་སྐྲོད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ཁྱོད་ཅག་གིས་དེ་དག་དང་དེ་དག་གི་ལྷ་རྣམས་ཀྱི་བར་ཁ་ཆད་མ་འཇོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","དེ་དག་གིས་ཁྱོད་རྣམས་ལ་ང་དང་འགལ་བའི་སྡིག་པ་བྱེད་དུ་འཇུག་ཉེན་ཡོད་པས། དེ་དག་ཁྱོད་ཅག་གི་ཡུལ་དུ་གནས་པར་མི་འོས་སོ། །གལ་ཏེ་ཁྱོད་ཅག་གིས་དེ་དག་གི་ལྷ་རྣམས་ལ་བསྙེན་བཀུར་བྱེད་ན། དེ་ནི་ཅིས་ཀྱང་ཁྱོད་ཅག་གཟུང་བའི་རྙི་ཞིག་ཏུ་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་དང་ཨ་རོན་དང་ནཱ་དབ་དང་ཨ་བི་ཧུ་དང་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་བདུན་ཅུ་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དུ་ཡར་ཤོག་དང་། རྒྱང་རིང་ནས་གུས་ཕྱག་ཕུལ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","འོན་ཀྱང་མོ་ཤེ་གཅིག་པུ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཉེ་སར་བཅར་ཆོག་ཅིང་། གཞན་དག་ཉེ་སར་ཡོང་མི་རུང་ལ། མི་རྣམས་ཀྱང་མོ་ཤེ་དང་མཉམ་དུ་ཡར་འོང་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","མོ་ཤེ་ཡོང་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་དང་ཁྲིམས་སྲོལ་ཐམས་ཅད་མི་རྣམས་ལ་སྨྲས་པ་དང་། དེའི་ལན་དུ་མི་ཐམས་ཅད་ཁ་མཐུན་ཏེ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཅི་བསྒོས་པ་བཞིན་དུ་ངེད་ཅག་གིས་བསྒྲུབ་པར་བྱ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ཐམས་ཅད་ཡི་གེར་བཀོད་ཅིང་། ཐོ་རངས་ཡར་ལངས་ཏེ་རི་འདབས་སུ་མཆོད་ཁྲི་ཞིག་བཞེངས་པ་དང་། ཡང་ཡེས་ར་ཨེལ་གྱི་ཚོ་པ་བཅུ་གཉིས་བཞིན་དུ་ཀ་བ་བཅུ་གཉིས་བསྒྲེངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ཡང་ཁོས་ཡེས་ར་ཨེལ་པའི་ཁྲོད་ཀྱི་གཞོན་ནུ་རྣམས་བཏང་བ་དང་། དེ་དག་གིས་སྦྱིན་སྲེག་རྣམས་ཕུལ་ཞིང་། གླང་ཐུག་རྣམས་བསད་ནས་ཞི་བདེའི་མཆོད་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ། ");
INSERT INTO bodn_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","མོ་ཤེ་ཡིས་ཁྲག་གི་ཕྱེད་ཀ་གཞོང་པའི་ནང་དུ་བླུགས་ཤིང་། ཕྱེད་ཀ་མཆོད་ཁྲི་ལ་གཏོར་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ཡང་ཞལ་ཆད་ཀྱི་གླེགས་བམ་བླངས་ནས་མི་རྣམས་ཀྱི་མདུན་ནས་བཀླགས་པ་དང་། ཁོ་རྣམས་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཅི་བསྒོས་པ་བཞིན་དུ་ངེད་ཅག་གིས་བྱེད་པ་དང་། བཀའ་ལ་མཉན་པར་བྱའོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","དེ་ནས་མོ་ཤེ་ཡིས་ཁྲག་དེ་བླངས་ནས་མི་རྣམས་ལ་གཏོར་ཅིང་འདི་ལྟར། ལྟོས་དང་། འདི་ནི་ཞལ་ཆད་ཀྱི་ཁྲག་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་འདི་ཐམས་ཅད་བཞིན་ཁྱོད་རྣམས་ལ་མཛད་ཟིན་པའི་ཞལ་ཆད་ཀྱི་གཞི་འཛིན་ས་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་དང་ནཱ་དབ་དང་ཨ་བི་ཧུ། དེ་མིན་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་བདུན་ཅུ་དང་བཅས་པ་ཡར་རི་ལ་འགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ཁོ་རྣམས་ཀྱིས་ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་མཇལ་ཞིང་། ཁོང་གི་ཞབས་འོག་ཏུ་ཨིནྡྲ་ནཱི་ལའི་རྡོ་གཅལ་ཞིག་བཏིངས་ཡོད་པ་དང་མཚུངས་ལ། དེ་ནི་དགུང་ཨ་སྔོན་བཞིན་གསལ་ཞིང་དྭངས་པ་ཞིག་ཡིན་འདུག ");
INSERT INTO bodn_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","འོན་ཀྱང་ཁོང་གི་ཕྱག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་འགོ་དཔོན་རྣམས་ལ་གནོད་མ་བསྐྱལ་ཞིང་། དེ་དག་གིས་དཀོན་མཆོག་མཇལ་བ་དང་བཟའ་བཏུང་སྤྱད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་མི་རྣམས་ལ་ཁྲིད་སྟོན་བྱེད་པའི་ཆེད་དུ། བདག་གིས་རྡོ་ལེབ་རྣམས་ལ་བྲིས་པའི་བཀའ་ཁྲིམས་དང་བཀའ་ཁྱོད་ལ་གནང་ངེས་ཡིན་པས། ཁྱོད་རང་རི་མགོར་ངའི་དྲུང་དུ་ཤོག་ལ་འདི་གར་སྡོད་ཅིག་ཅེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","མོ་ཤེ་དང་ཁོའི་ཞབས་ཕྱི་ཡོ་ཤུ་ཨ་གཉིས་ཆས་ཏེ་དཀོན་མཆོག་གི་རི་ལ་འགོས། ");
INSERT INTO bodn_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","མོ་ཤེ་ཡིས་རྒན་པོ་རྣམས་ལ་འདི་ལྟར། ངེད་གཉིས་ཕྱིར་ལོག་པའི་བར་དུ་ཁྱོད་ཅག་གིས་འདི་རུ་སྒུག་སྡོད་དང་། ཨ་རོན་དང་ཧུ་རཱ་གཉིས་ཁྱོད་ཅག་དང་མཉམ་དུ་ཡོད་པས། སུ་ལ་གྱོད་གཞི་ཡོད་ན། དེ་གཉིས་ཀྱི་གམ་དུ་འགྲོ་དགོས་ཞེས་བཀའ་གནང་། ");
INSERT INTO bodn_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","མོ་ཤེ་རི་ལ་འགོ་སྐབས་རི་ནི་སྤྲིན་གྱིས་གཡོགས་ནས་འདུག ");
INSERT INTO bodn_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","དེ་ནས་སི་ནཱ་རི་བོ་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་བཞུགས་པ་དང་། ཉིན་དྲུག་གི་རིང་ལ་སྤྲིན་གྱིས་རི་བོ་གཡོགས་ཤིང་། ཉིན་བདུན་པར་ཁོང་གིས་སྤྲིན་གྱི་དཀྱིལ་ནས་མོ་ཤེ་ལ་ཞལ་འབོད་གནང་། ");
INSERT INTO bodn_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མིག་ལམ་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་མངོན་པ་ནི་ཡོངས་རྫོགས་རྩ་མེད་གཏོང་བའི་མེ་ལྟར་དུ་རི་རྩེར་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","དེ་ནས་མོ་ཤེ་སྤྲིན་གྱི་དཀྱིལ་དུ་ཞུགས་པ་དང་། རི་ལ་འགོས་ནས་ཉིན་ཞག་བཞི་བཅུའི་རིང་དེར་གནས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ། བདག་ལ་འབུལ་བ་འབུལ་དགོས་པར་སྨྲོས་ཤིག སེམས་ནས་འབུལ་བ་འབུལ་བར་དགའ་བ་རྣམས་ལས་བདག་ལ་འབུལ་བ་བསྡུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","དེ་རྣམས་ལས་བསྡུ་དགོས་པའི་འབུལ་བ་རྣམས་ནི་འདི་ལྟ་སྟེ། གསེར་དང་དངུལ་དང་ལི་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་དང་། སོ་རས་སྲབ་བུ་དང་། ར་མའི་ཁུལ་རྩིད་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ལུག་ཐུག་གི་པགས་པ་རྒྱ་ཚོས་བརྒྱབ་པ་དང་ཀོ་བ་སྤུས་ལེགས་དང་སེང་ལྡེང་ཤིང་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","སྒྲོན་མེའི་ཕྱིར་འཚིར་སྣུམ་དང་། འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་ཀྱི་ཕྱིར་བསུང་རྫས་རྣམས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","གཟི་དང་རིན་པོ་ཆེ་གཞན་དག་དགོས་པ་སྟེ། མཆོད་དཔོན་གྱི་བེར་ཐུལ་དང་བྲང་རྒྱན་ལ་ཕྲ་རྒྱག་དགོས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ཡང་ང་རང་ནི་དེ་དག་གི་དཀྱིལ་དུ་གནས་པའི་ཕྱིར་ཁོ་རྣམས་ཀྱིས་ང་ལ་གནས་མཆོག་ཅིག་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ངས་ཁྱོད་ལ་སྟོན་པར་འགྱུར་བའི་གུར་མཆོག་གི་དཔེ་དང་། དེའི་ནང་ལ་ཡོད་པའི་ཡོ་བྱད་ཐམས་ཅད་ཀྱི་དཔེ་བཞིན་དུ་བཟོ་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ཡང་འདི་སྐད་དུ། ཁོ་རྣམས་ཀྱིས་སེང་ལྡེང་ཤིང་གིས་ཤུར་སྒམ་ཞིག་བཟོ་དགོས། དེའི་རིང་ཚད་ལ་ཁྲུ་གཉིས་དང་ཕྱེད། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད། མཐོ་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད་ཀའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","དེའི་ཕྱི་ནང་གཉིས་གསེར་བཙོ་མས་གཡོགས་ཤིག དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ཡང་གསེར་གྱི་ཨ་ལོང་བཞི་བླུགས་ནས་དེའི་སུག་པ་བཞི་ལ་སྦྱོར་དགོས་ཤིང་། ཨ་ལོང་གཉིས་ལོགས་གཅིག་དང་ཨ་ལོང་གཉིས་ལོགས་ཅིག་ཤོས་ལ་སྦྱོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ཡང་སེང་ལྡེང་ཤིང་གིས་རྒྱུག་པ་གཉིས་བཟོས་ནས་དེ་གསེར་གྱིས་གཡོགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ཤུར་སྒམ་དེ་འཁུར་བའི་ཕྱིར་རྒྱུག་པ་གཉིས་ཤུར་སྒམ་གྱི་ལོགས་གཉིས་ཀའི་ཨ་ལོང་རྣམས་ལ་རྒྱུས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","རྒྱུག་པ་དེ་གཉིས་ཤུར་སྒམ་གྱི་ཨ་ལོང་ནང་དུ་ཡོད་དགོས་ཤིང་དེ་ལས་འདོན་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ཡང་ངས་ཁྱོད་རང་ལ་གནང་རྒྱུ་ཡིན་པའི་དཔང་པོའི་རྡོ་ལེབ་གཉིས་པོ་ཤུར་སྒམ་གྱི་ནང་དུ་འཇུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ཁྱོད་ཀྱིས་གསེར་བཙོ་མས་ཐུགས་རྗེའི་བཞུགས་ཁྲི་ཞིག་བཟོ་དགོས། དེའི་རིང་ཚད་ནི་ཁྲུ་གཉིས་དང་ཕྱེད། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ཁྱོད་ཀྱིས་ཐུགས་རྗེའི་བཞུགས་ཁྲི་ཡི་སྣེ་མོ་གཉིས་ལ་གསེར་གྱིས་འབུར་རྡུང་བྱས་པའི་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་གཉིས་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ཀེ་རུབ་གཅིག་སྣེ་མོ་གཅིག་དང་། ཀེ་རུབ་ཅིག་ཤོས་སྣེ་མོ་གཞན་དེ་ལ་བཟོས་ནས། ཀེ་རུབ་གཉིས་ནི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་ཡི་སྣེ་མོ་གཉིས་ལ་དངོས་པོ་གཅིག་ཏུ་སྦྲེལ་བཟོ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ཀེ་རུབ་གཉིས་ཀྱིས་རང་གི་གཤོག་པ་གྱེན་དུ་རྐྱོང་ཞིང་ཐུགས་རྗེའི་བཞུགས་ཁྲི་གཡོགས་པ་དང་། ཀེ་རུབ་གཉིས་ཕན་ཚུན་ལ་གདོང་གཏོད་དགོས་པ་དང་། ཡང་དེ་གཉིས་ཀྱི་ཞལ་ངོ་ནི་བཞུགས་ཁྲི་ལ་འཁོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ཁྱོད་ཀྱིས་ཐུགས་རྗེའི་བཞུགས་ཁྲི་དེ་ཤུར་སྒམ་གྱི་སྟེང་ལ་བཞག་ནས། ཤུར་སྒམ་གྱི་ནང་དུ་ངས་ཁྱོད་ལ་གནང་བར་འགྱུར་བའི་དཔང་པོའི་རྡོ་ལེབ་གཉིས་པོ་འཇུག་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","གནས་དེ་རུ་ང་རང་ཁྱོད་དང་འཕྲད་པར་འགྱུར་བ་དང་། ཐུགས་རྗེའི་བཞུགས་ཁྲིའི་གོང་ཕྱོགས་དང་། དཔང་མཛད་ཤུར་སྒམ་གྱི་སྟེང་ལ་ཡོད་པའི་ཀེ་རུབ་གཉིས་ཀྱི་དཀྱིལ་ཕྱོགས་ཀྱི་བར་ས་དེ་ནས། བདག་གིས་ཁྱོད་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྒྲོག་པའི་བཀའ་ཐམས་ཅད་སྨྲ་བར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་སེང་ལྡེང་ཤིང་གིས་སྒྲོག་ཙེ་ཞིག་བཟོ་དགོས། དེའི་རིང་ཚད་ནི་ཁྲུ་གཉིས་དང་། ཞེང་ཚད་ལ་ཁྲུ་གཅིག མཐོ་ཚད་ཁྲུ་གཅིག་དང་ཕྱེད་ཀའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","དེ་གསེར་བཙོ་མས་གཡོགས་པ་དང་། དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","མུ་ཁྱུད་དེའི་འགབ་ཏུ་ཡང་མཐོ་ཚད་ལ་སོར་བཞི་ཅན་གྱི་མཐའ་རྒྱན་ཞིག་བྱོས་དང་། དེའི་སྟེང་དུ་ཡང་གསེར་གྱི་མུ་ཁྱུད་ཅིག་སྦྱོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ཡང་དེ་ལ་གསེར་གྱི་ཨ་ལོང་བཞི་བཟོས་ཏེ། དེའི་གྲུ་བཞིའི་སུག་པ་བཞི་ལ་སྦྱོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ཨ་ལོང་དེ་དག་མཐའ་རྒྱན་གྱི་འཁྲིས་སུ་སྦྱར་ཏེ་སྒྲོག་ཙེ་འཁུར་བའི་ཕྱིར་དེ་དག་ནི་རྒྱུག་པ་རྣམས་ཀྱི་བསྐོན་ས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","སྒྲོག་ཙེ་འཁུར་བའི་ཕྱིར་རྒྱུག་པ་དེ་རྣམས་སེང་ལྡེང་ཤིང་གིས་བཟོས་ཏེ་གསེར་གྱིས་གཡོགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","སྒྲོག་ཙེ་སྟེང་གི་གཞོང་པ་དང་སྡེར་མ་རྣམས་དང་། བུམ་པ་དང་། སྐྱེམས་མཆོད་འབུལ་བྱེད་ཨུ་ལུ་བཅས་བཟོ་དགོས་ཤིང་། དེ་དག་གསེར་བཙོ་མས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ཡང་སྒྲོག་ཙེ་དེའི་སྟེང་ལ་ཁྱོད་ཀྱིས་དུས་གཏན་དུ་ངའི་དྲུང་དུ་སྤྱན་བསྟར་བག་ལེབ་འཇོག་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་སྒྲོན་སྟེགས་ཤིག་གསེར་བཙོ་མས་བཟོ་དགོས་ཏེ། སྒྲོན་སྟེགས་དེ་ནི་འབུར་རྡུང་གིས་བཟོ་དགོས་ཤིང་། དེའི་ཞབས་ར་དང་སྟེགས་རྐང་། སྒྲོན་ཕོར། གང་བུའི་གཟུགས། མེ་ཏོག་གི་དབྱིབས་ཚུགས་བཅས་སྒྲོན་སྟེགས་དང་སྦྲེལ་བཟོ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","སྒྲོན་སྟེགས་ཀྱི་ལོགས་གཉིས་ནས་གེལ་པ་དྲུག་འཐོན་པར་བྱེད་དགོས་ཏེ། སྒྲོན་སྟེགས་ཀྱི་ལོགས་གཅིག་ནས་གེལ་པ་གསུམ་དང་ལོགས་ཅིག་ཤོས་སུ་གེལ་པ་གསུམ་འཐོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ལོགས་གཉིས་ཀའི་གེལ་པ་རེ་ལ་སྟར་སྡོང་གི་མེ་ཏོག་ལྟར་བྱས་པའི་སྒྲོན་ཕོར་གསུམ་རེ་ཡོད་པ་དང་། སྒྲོན་ཕོར་རེ་རེའི་སྟེགས་རྐང་དུ་གང་བུའི་གཟུགས་ཤིག་དང་། མེ་ཏོག་གཟུགས་ཤིག་བཅས་ཡོད་དགོས། སྒྲོན་སྟེགས་ཀྱི་སྤྱི་སྡོམ་གེལ་པ་དྲུག་པོ་ཕན་ཚུན་ཆ་མཚུངས་པ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ཡང་སྒྲོན་སྟེགས་རྐང་པའི་སྟར་སྡོང་གི་མེ་ཏོག་ལྟར་བྱས་པའི་སྒྲོན་ཕོར་བཞི་ལ་གང་བུའི་གཟུགས་ཤིག་དང་མེ་ཏོག་གཟུགས་ཤིག་བཅས་ཡོད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","དེའི་གེལ་པ་ཟུང་གཅིག་གི་འོག་ཏུ་གང་བུའི་གཟུགས་ཤིག་དང་། ཡང་དེའི་གེལ་པ་གཞན་ཟུང་གི་འོག་ཏུའང་གང་བུའི་གཟུགས་ཤིག་དང་། ཡང་དེའི་གེལ་པ་གཞན་ཟུང་གི་འོག་ཏུའང་གང་བུའི་གཟུགས་ཤིག་སྟེ། དེ་ལྟར་སྒྲོན་སྟེགས་ལས་བྱུང་བའི་གེལ་པ་དྲུག་པོ་ལ་ཡོད་པར་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","གང་བུའི་གཟུགས་རྣམས་དང་གེལ་པ་རྣམས་ནི་མུ་འབྲེལ་དུ་འབུར་རྡུང་བྱས་པའི་གསེར་བཙོ་མས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ཡང་དེ་ལ་སྒྲོན་མེ་བདུན་བཟོས་ཤིག དེ་རྣམས་ཀྱི་འོད་མདུན་ཕྱོགས་སུ་འཆར་བའི་ཕྱིར་སྒྲོན་སྟེགས་སྟེང་དུ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","དེའི་སྡོང་རས་གཅོད་བྱེད་སྐམ་ཆུང་དང་ཀ་ཏོ་ར་རྣམས་གསེར་བཙོ་མས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་གསེར་བཙོ་མ་རྡོ་ཚད་གཅིག་གིས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","རི་མགོ་ནས་ཁྱོད་ལ་བསྟན་པའི་དཔེ་བཞིན་དུ་དེ་དག་བཟོ་བ་ལ་གཟབ་གཟབ་གྱིས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡོལ་བ་བཅུ་ཡིས་གུར་མཆོག་བཟོ་བར་བྱའོ། །དེའི་རྒྱུ་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་དང་། བལ་སྐུད་མཐིང་ག་དང་། རྒྱ་སྨུག་དང་། མཚལ་དམར་གྱི་མདོག་ཅན་བཅས་ཡིན་ལ་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་དང་ལྡན་པ་དེ་དག་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ཡོལ་བ་རེ་རེའི་རིང་ཚད་ལ་ཁྲུ་ཉི་ཤུ་ཉེར་བརྒྱད་དང་། ཞེང་ཚད་ལ་ཁྲུ་བཞི་ཡོད་པར་བྱོས། ཡོལ་བ་ཐམས་ཅད་ཀྱི་ཚད་ནི་གཅིག་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ཡོལ་བ་ལྔ་ནི་ཕན་ཚུན་འབྲེལ་བར་བྱོས་ལ། ཡོལ་བ་གཞན་ལྔ་པོ་དེ་ཡང་ཕན་ཚུན་འབྲེལ་བར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ཡང་མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་སྔ་མ་དེའི་སྣེ་མོར་མཐིང་མདོག་གི་སྒྲོག་ལུང་རྣམས་བྱོས་ལ། མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་ཕྱི་མ་དེའི་སྣེ་མོ་ལའང་དེ་བཞིན་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་སྔ་མར་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོ་བ་དང་། མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་ཕྱི་མར་ཡང་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོ་དགོས་ཏེ། སྒྲོག་ལུང་རྣམས་ཆ་རེ་ཁ་སྤྲད་ནས་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ཡང་གུར་མཆོག་མུ་གཅིག་ཏུ་བསྒྲིལ་བའི་ཕྱིར་གསེར་ཀྱུ་ལྔ་བཅུ་བཟོས་ནས། ཡོལ་བ་རྣམས་གསེར་ཀྱུས་སྦྲེལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ཡང་ཁྱོད་ཀྱིས་གུར་མཆོག་གི་ཁེབས་རས་ཀྱི་ཕྱིར་ར་རྩིད་ཀྱི་ཡོལ་བ་བཅུ་གཅིག་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ཡོལ་བ་རེ་རེའི་རིང་ཚད་ནི་ཁྲུ་སུམ་ཅུ་དང་། ཞེང་ཚད་ལ་ཁྲུ་བཞི་ཡོད་དགོས། ཡོལ་བ་བཅུ་གཅིག་པོའི་ཚད་གཅིག་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ཡོལ་བ་ལྔ་ནི་གཅིག་ཏུ་སྦྲེལ་དགོས་ཤིང་། ཡོལ་བ་གཞན་དྲུག་པོ་ཡང་གཅིག་ཏུ་སྦྲེལ་བར་གྱིས། ཡོལ་བ་དྲུག་ཅན་དེ་གུར་གྱི་མདུན་ལོགས་སུ་ཉིས་ལྟེབ་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ཡོལ་བ་སྦྲེལ་མ་ལྔ་ཅན་དེའི་སྣེ་མོར་སྒྲོག་ལུང་ལྔ་བཅུ་དང་། ཡོལ་བ་སྦྲེལ་མ་དྲུག་ཅན་དེའི་སྣེ་མོ་ལའང་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ཁྱོད་ཀྱིས་ལི་ཡི་ཀྱུ་ལྔ་བཅུ་བཟོས་ནས། སྒྲོག་ལུང་རྣམས་ལ་བསྐོན་ནས་ཁེབས་རས་ནི་མུ་གཅིག་འཁྱུད་གཅིག་ཡོང་བར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","གུར་མཆོག་གི་ཡོལ་བ་རྣམས་ནས་ལུས་ཤིང་བསྣར་བའི་ཡོལ་བ་ཕྱེད་ཀ་དེ་གུར་མཆོག་གི་རྒྱབ་ལོགས་སུ་བསྣར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","གུར་མཆོག་གི་ཡོལ་བ་རྣམས་ཀྱི་རིང་ཚད་ནས་ལུས་པའི་ཆ་དེ་ཁྲུ་གཅིག་ནི་གུར་མཆོག་དེའི་ཕྱོགས་གཅིག་དང་། ཁྲུ་ཅིག་ཤོས་ནི་གུར་མཆོག་གི་ལོགས་གཞན་ལ་བསྣར་ཏེ་འགེབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","རྒྱ་ཚོས་བརྒྱབ་པའི་ལུག་ཐུག་གི་པགས་པས་ཁེབས་རས་གཡོགས་ཤིག་དང་། དེའི་སྟེང་དུ་ཀོ་བ་སྤུས་ལེགས་རྣམས་ཀྱིས་ཡང་ཁེབས་ཤིག་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","གུར་མཆོག་གི་ཕྱིར་སེང་ལྡེང་ཤིང་གིས་གྱེན་དུ་འགྲེང་བའི་པང་ལེབ་རྣམས་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","པང་ལེབ་རེའི་རིང་ཚད་ནི་ཁྲུ་བཅུ་དང་། ཞེང་ཚད་ནི་ཁྲུ་གཅིག་དང་ཕྱེད་ཀའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","པང་ལེབ་གཅིག་དང་གཅིག་འབྲེལ་བའི་ཕྱིར་རེ་རེ་ལ་ཁོང་གཟེར་གཉིས་བྱོས་ཤིག་དང་། གུར་མཆོག་གི་པང་ལེབ་ཐམས་ཅད་དེ་ལྟར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","གུར་མཆོག་གི་ལྷོ་ཕྱོགས་སུ་པང་ལེབ་ཉི་ཤུ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","པང་ལེབ་ཉི་ཤུ་དེའི་ཞབས་ལ་དངུལ་གྱི་ཞབས་ར་བཞི་བཅུ་བཟོ་དགོས་ལ། པང་ལེབ་རེའི་ཁོང་གཟེར་གཉིས་ལ་ཞབས་ར་ཟུང་རེ་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","གུར་མཆོག་གི་ལོགས་གཞན་ཏེ། བྱང་ཕྱོགས་སུ་ཡང་པང་ལེབ་ཉི་ཤུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","དེའི་དངུལ་གྱི་ཞབས་ར་བཞི་བཅུ་དང་། པང་ལེབ་རེའི་འོག་ལ་ཞབས་ར་ཟུང་རེ་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","གུར་མཆོག་གི་རྒྱབ་ལོགས་ཏེ་ནུབ་ཕྱོགས་སུ་པང་ལེབ་དྲུག་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","གུར་མཆོག་རྒྱབ་ལོགས་ཀྱི་ཟུར་གཉིས་ལ་པང་ལེབ་གཉིས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","དེ་གཉིས་ཀྱི་འགབ་ལ་པང་ལེབ་ཉིས་གཤིབ་དགོས་ཤིང་། དེའི་གོང་ལའང་པང་ལེབ་གཅིག་གི་སྣེ་ནས་པང་ལེབ་གཞན་ཞིག་གི་བར་དུ་ཨ་ལོང་གཅིག་གིས་སྦྲེལ་བར་བྱ་ཞིང་། དེ་བཞིན་དུ་པང་ལེབ་གཉིས་དེ་ལྟར་ཡོད་དགོས་ཤིང་ཟུར་གཉིས་ཡིན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","དེ་ལྟར་པང་ལེབ་བརྒྱད་དང་། དེ་དག་ལ་དངུལ་གྱི་ཞབས་ར་བཅུ་དྲུག་ཡོད་དགོས་ཏེ། པང་ལེབ་རེ་ལ་ཞབས་ར་གཉིས་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","དེ་ནས་སེང་ལྡེང་ཤིང་གིས་འཕྲེད་རྒྱུག་རྣམས་བཟོ་དགོས་ཤིང་། གུར་མཆོག་གི་ལོགས་གཅིག་གི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་འཕྲེད་རྒྱུག་ལྔ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","གུར་མཆོག་གི་ལོགས་གཞན་ལ་ཡོད་པའི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་འཕྲེད་རྒྱུག་ལྔ་དང་། རྒྱབ་ལོགས་ཏེ་ནུབ་ཕྱོགས་ཀྱི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་ཡང་འཕྲེད་རྒྱུག་ལྔ་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","པང་ལེབ་རྣམས་ཀྱི་དཀྱིལ་དུ་ཡོད་པའི་འཕྲེད་རྒྱུག་དག་སྣེ་གཅིག་ནས་སྣེ་གཞན་དུ་སླེབས་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","པང་ལེབ་དེ་དག་གསེར་གྱིས་གཡོགས་ཤིག དེ་དག་གི་འཕྲེད་རྒྱུག་འཛིན་པའི་ཨ་ལོང་རྣམས་གསེར་དུ་བྱོས་ཤིག ཡང་འཕྲེད་རྒྱུག་དག་གསེར་གྱིས་གཡོགས་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","དེ་ལྟར་རི་ནས་ཁྱོད་ལ་བསྟན་པའི་དཔེ་བཞིན་དུ་གུར་མཆོག་ཕུབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ཡང་ཁྱོད་ཀྱིས་ཡོལ་བ་ཞིག་བཟོ་བར་བྱའོ། །དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་། རྒྱ་སྨུག་དང་། མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཡིན་དགོས་ཤིང་། ཡང་དེ་ལ་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་དང་ལྡན་པར་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ཡོལ་བ་དེ་ནི་སེང་ལྡེང་ཤིང་གི་ཀ་བ་བཞི་གསེར་གྱིས་གཡོགས་པར་འགེལ་བ་དང་། དེའི་ཀྱུ་རྣམས་གསེར་ཡིན་དགོས་ཏེ། ཀ་བ་རྣམས་དངུལ་གྱི་ཞབས་ར་ལ་བརྟེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ཡོལ་བ་དེ་ཀྱུ་རྣམས་ཀྱི་སྣེ་རུ་དཔྱངས་པ་དང་། ཡོལ་བའི་ནང་ཐད་དུ་དཔང་མཛད་ཤུར་སྒམ་འཇོག་དགོས། དེ་ལྟར་ཡོལ་བ་དེས་ཁྱོད་རྣམས་ལ་གནས་དམ་པ་དང་གནས་དམ་མཆོག་གི་དབྱེ་མཚམས་འབྱེད་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","གནས་དམ་མཆོག་ནང་གི་དཔང་མཛད་ཤུར་སྒམ་གྱི་སྟེང་དུ་ཐུགས་རྗེའི་བཞུགས་ཁྲི་དེ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","སྒྲོག་ཙེ་ནི་ཡོལ་བའི་ཕྱི་ལོགས་སུ་གུར་མཆོག་གི་བྱང་ཕྱོགས་དང་། སྒྲོན་སྟེགས་ནི་གུར་མཆོག་གི་ལྷོ་ཕྱོགས་སུ་ཕན་ཚུན་ཁ་སྤྲོད་དུ་འཇོག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","གུར་མཆོག་གི་སྒོ་ལ་སྒོ་ཡོལ་ཞིག་བཟོ་དགོས་ཤིང་། དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་། རྒྱ་སྨུག་དང་། མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཡིན་དགོས་ལ། འཐག་མཁན་གྱི་ལས་བཞིན་དུ་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","སྒོ་ཡོལ་གྱི་ཕྱིར་སེང་ལྡེང་ཤིང་གི་ཀ་བ་ལྔ་གསེར་གྱིས་གཡོགས་པར་བྱོས་ལ། དེ་དག་གི་ཀྱུ་རྣམས་ཀྱང་གསེར་ཡིན་དགོས་པ་དང་། དེ་དག་གི་ཕྱིར་ཁྱོད་ཀྱིས་ལི་ཡི་ཞབས་ར་ལྔ་བླུགས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་སེང་ལྡེང་ཤིང་གིས་མཆོད་ཁྲི་ཞིག་བཟོ་དགོས་ཤིང་། དེའི་རིང་ཚད་ལ་ཁྲུ་ལྔ་དང་ཞེང་ཚད་ལ་ཁྲུ་ལྔ་སྟེ་གྲུ་བཞི་མ་ཞིག་དང་། དེའི་མཐོ་ཚད་ལ་ཁྲུ་གསུམ་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","དེའི་ཟུར་བཞི་ལ་རུ་ཐུར་བཞི་བཟོ་དགོས་པ་དང་། རུ་ཐུར་བཞི་ནི་མཆོད་ཁྲི་དང་གཅིག་ཏུ་སྦྲེལ་དགོས་ཤིང་། མཆོད་ཁྲི་ལི་ཡིས་གཡོག་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ཡང་ཁྱོད་ཀྱིས་ཐལ་བ་འཁྱེར་བའི་ཕྱིར་གཞོང་པ་རྣམས་བཟོ་དགོས་པ་དང་། ཡང་མེ་ཁྱེམ་དང་། མཆོད་སྡེར་དང་ཤ་འཛིན་ཁ་དབྲག་དང་མེ་ཕོར་བཅས་བཟོ་དགོས། ཡོ་བྱད་དེ་ཐམས་ཅད་ལི་ཡིས་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ཡང་རྒྱུ་ལི་ཡིན་པའི་ཐག་མིག་ཅིག་བཟོས་ཏེ་ཐག་མིག་དེའི་གྲུ་ག་བཞི་ལ་ལི་ཡི་ཨ་ལོང་རེ་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ཐག་མིག་ནི་མཆོད་ཁྲིའི་མུ་ཁྱུད་ཀྱི་འགབ་ལ་བཅུག་སྟེ་མཆོད་ཁྲིའི་མཐོ་ཚད་ཀྱི་ཕྱེད་ཙམ་ལ་སླེབས་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","མཆོད་ཁྲི་ལ་སེང་ལྡེང་ཤིང་གིས་རྒྱུག་པ་བཟོས་ནས་དེ་གཉིས་ལི་ཡིས་གཡོགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","རྒྱུག་པ་ནི་མཆོད་ཁྲིའི་ལོགས་གཉིས་ཀྱི་ཨ་ལོང་རྣམས་སུ་བརྒྱུས་ཤིང་མཆོད་ཁྲི་འཁུར་བའི་ཕྱིར་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ཡང་པང་ལེབ་ཀྱིས་མཆོད་ཁྲི་བཟོ་དགོས་ཤིང་། དེའི་ནང་ནི་སྟོང་པ་ཡིན་པ་དང་། རི་ནས་ཁྱོད་ལ་བསྟན་པ་ཇི་བཞིན་བཟོ་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་གུར་མཆོག་ལ་ཁྱམས་ར་ཞིག་བཟོས་ཤིག དེའི་ལྷོ་ཕྱོགས་ཀྱི་ཁྱམས་ཡོལ་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་གྱིས་བཟོ་དགོས་ཤིང་། རིང་ཚད་ནི་ཁྲུ་བརྒྱ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","དེ་ལ་ཀ་བ་ཉི་ཤུ་དང་ལི་ཡི་ཞབས་ར་ཉི་ཤུ་བྱའོ། །ཀ་བའི་ཀྱུ་རྣམས་དང་དེ་དག་གི་ཁ་ཐུར་རྣམས་དངུལ་གྱིས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","དེ་ལྟར་བྱང་ཕྱོགས་ཀྱི་ཁྱམས་ཡོལ་རྣམས་ཀྱི་རིང་ཚད་ལ་ཁྲུ་བརྒྱ་ཡོད་དགོས་པ་དང་། ཀ་བ་ཉི་ཤུ་དང་དེ་དག་གི་ལི་ཡི་ཞབས་ར་ཉི་ཤུ་དགོས་ཤིང་། ཀ་བའི་ཀྱུ་དང་ཁ་ཐུར་རྣམས་དངུལ་གྱིས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ཡང་ཁྱམས་རའི་ནུབ་ཕྱོགས་ཀྱི་ཡོལ་བ་རྣམས་ཀྱི་ཞེང་ཚད་ལ་ཁྲུ་ལྔ་བཅུ་ཡོད་དགོས་ཤིང་། དེ་ལ་ཀ་བ་བཅུ་དང་ཞབས་ར་བཅུ་བཅས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ཁྱམས་རའི་ཤར་ཕྱོགས་ཀྱི་ཞེང་ཚད་ལ་ཁྲུ་ལྔ་བཅུ་ཡོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","སྒོའི་ལོགས་གཅིག་གི་ཡོལ་བ་ནི་ཁྲུ་བཅོ་ལྔ་དང་། དེ་ལ་ཀ་བ་གསུམ་དང་ཞབས་ར་གསུམ་བཅས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","སྒོའི་ལོགས་ཅིག་ཤོས་ཀྱི་ཡོལ་བ་ལའང་ཁྲུ་བཅོ་ལྔ་དང་། དེ་ལ་ཀ་བ་གསུམ་དང་། ཞབས་ར་གསུམ་བཅས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ཁྱམས་རའི་སྒོ་ཡོལ་གྱི་རིང་ཚད་ནི་ཁྲུ་ཉི་ཤུ་དང་། དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་ཡིན་དགོས་པ་དང་། འཐག་མཁན་གྱི་ལས་བཞིན་དུ་བཟོ་དགོས་ཏེ། དེ་ལ་ཀ་བ་བཞི་དང་ཞབས་ར་བཞི་བཅས་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ཁྱམས་རའི་ཕྱོགས་བཞིའི་ཀ་བ་ཐམས་ཅད་དངུལ་གྱི་ཁ་ཐུར་གྱིས་སྦྲེལ་དགོས་ཤིང་། དེ་དག་གི་ཀྱུ་རྣམས་དངུལ་གྱིས་བཟོ་བ་དང་དེ་དག་གི་ཞབས་ར་རྣམས་ལི་ཡིས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ཁྱམས་རའི་རིང་ཚད་ལ་ཁྲུ་བརྒྱ་དང་། ཞེང་ཚད་ལ་ཁྲུ་ལྔ་བཅུ། མཐོ་ཚད་ལ་ཁྲུ་ལྔ་བཅས་སོ། །དེ་དག་གི་རྒྱུ་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་ཡིན་དགོས་པ་དང་། ཀ་བའི་ཞབས་ར་རྣམས་ལི་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","གུར་མཆོག་ཏུ་བཀོལ་དགོས་པའི་ཡོ་ཆས་ཐམས་ཅད་དང་། དེའི་ཕུར་བ་ཀུན་དང་། ཁྱམས་རའི་ཕུར་བ་མཐའ་དག་བཅས་ལི་ཡིས་བཟོ་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ། འོད་ཀྱི་ཆེད་དུ་སྐྱུ་རུ་རའི་ཤིང་ལས་བརྡུངས་པའི་སྣུམ་དྭངས་མ་ཁྱོད་ལ་འབུལ་དགོས་པའི་བཀའ་སྒོས་ཤིག དེ་ནི་སྒྲོན་མེ་རྟག་ཏུ་འབར་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་ཡོད་པའི་དཔང་མཛད་ཤུར་སྒམ་མདུན་གྱི་ཡོལ་བའི་ཕྱི་ཕྱོགས་སར། ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་མཚན་མོ་ནས་ཞོགས་པའི་བར་དུ་སྒྲོན་མེ་ལ་ལྟ་སྲུང་བྱེད་དགོས། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་མི་རབས་ནས་མི་རབས་བར་གཏན་དུ་གནས་པའི་སྒྲིག་ཁྲིམས་ཤིག་ཏུ་འགྱུར་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་ནས་ཁྱོད་ཀྱི་ཕུ་བོ་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཏེ། ནཱ་དབ་དང་ཨ་བི་ཧུ་དང་ཨེ་ལི་ཨ་ཟར་དང་ཨི་ཐ་མཱར་བཅས་བདག་གི་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པར་ཁྱོད་ཀྱི་དྲུང་དུ་འོང་བར་ཆུག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ཁྱོད་ཀྱིས་རང་གི་ཕུ་བོ་ཨ་རོན་ལ་འཕགས་གོས་དམ་པ་བརྗིད་ཉམས་དང་མཛེས་སྡུག་ལྡན་པའི་ཕྱིར་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ཨ་རོན་དམ་པར་བྱེད་པ་དང་ཁོས་ཀྱང་བདག་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར། ཁྱོད་ཀྱིས་ལག་རྩལ་ཡོད་པའི་མི་སྟེ། བདག་གིས་ཤེས་རབ་ཀྱི་སེམས་རྒྱུད་ཀྱིས་ཁེངས་པར་མཛད་པའི་མི་དེ་དག་ལ་ཨ་རོན་ལ་འཕགས་གོས་བཟོ་བའི་བཀའ་སྒོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","དེ་དག་གིས་བཟོ་བྱའི་ན་བཟའ་རྣམས་ནི་འདི་དག་ཡིན་ཏེ། བྲང་རྒྱན་དང་བེར་ཐུལ་དང་། གོས་རིང་དང་། ནང་གོས་འབུར་རིས་མ་དང་། ལ་ཐོད་དང་སྐེད་ཆིངས་བཅས་སོ། །དེ་ལྟ་བུའི་ན་བཟའ་དམ་པ་རྣམས་ཁོ་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་ཕུ་བོ་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་བཟོ་དགོས་ལ། དེ་ནི་ཁོ་རྣམས་ཀྱིས་བདག་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","དེ་བཟོ་བྱེད་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བཅས་ཡིན་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ཡང་འདི་སྐད་དུ། བེར་ཐུལ་ཡང་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཀྱིས་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","དེ་ལ་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་དགོས་ཤིང་། བེར་ཐུལ་གྱི་ཕྲག་མགོ་གཉིས་ལ་སྦྲེལ་ཞིང་འཆིང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ཡང་བེར་ཐུལ་དང་འབྲེལ་བའི་སྐེད་ཆིངས་མཆོར་པོ་ཅན་དེ་ནི་བེར་ཐུལ་གྱི་བཟོ་ཚུལ་དང་གཅིག་མཚུངས་ཡིན་དགོས་ཤིང་། དེའི་རྒྱུ་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ཡང་གཟི་གཉིས་ལོངས་ལ། དེའི་ཁར་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་བརྐོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","མིང་དྲུག་ནི་གཟི་གཅིག་གི་སྟེང་ལ་བརྐོ་བར་བྱ་ཞིང་། ཡང་མིང་དྲུག་ནི་གཟི་གཞན་པ་དེའི་སྟེང་དུ་བརྐོ་དགོས། དེ་ཐམས་ཅད་ཁོ་རྣམས་སྐྱེས་པའི་གོ་རིམ་བཞིན་དུ་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","རྡོ་ལ་རྡོ་བཟོས་དམ་ཕྲུག་བརྐོ་བ་བཞིན་དུ་རྡོ་དེ་གཉིས་ཀྱི་སྟེང་དུ་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་བརྐོས་ཏེ་གསེར་གྱིས་འབུར་ཀོང་གཉིས་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","རྡོ་དེ་གཉིས་བེར་ཐུལ་གྱི་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་ལ་སྦྱར་ཏེ། རྡོ་དེ་གཉིས་ལ་བརྟེན་ནས་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ལ་རྗེས་དྲན་ཡོད་དགོས། ཨ་རོན་གྱིས་དེ་དག་གི་མིང་རྣམས་རང་གི་ཕྲག་ལ་ཁུར་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་དྲན་རྟེན་དུ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ཁྱོད་ཀྱིས་གསེར་གྱི་འབུར་ཀོང་གཉིས་བཟོ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","གསེར་བཙོ་མས་བསླེས་པའི་ཉག་ཐག་གཉིས་བཟོས་ནས། དེ་ནི་གསེར་གྱི་འབུར་ཀོང་གཉིས་ལ་སྦྱོར་ཅིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་བློ་འདོན་པའི་བྲང་རྒྱན་བཟོ་བར་བྱའོ། །དེ་ནི་བཟོ་བ་ལག་རྩལ་ཅན་གྱིས་བྱས་པ་ཡིན་དགོས་པ་དང་བེར་ཐུལ་བཞིན་དུ་བཟོ་དགོས་ལ། དེའི་རྒྱུ་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","དེ་ནི་ཁ་གང་ཉིས་ལྟེབ་ཅན་དང་། དེའི་རིང་ཚད་ནི་མཐོ་གང་དང་ཞེང་ལ་ཡང་མཐོ་གང་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","དེ་ལ་ཕ་ལམ་ཤུར་ཕྲེང་བཞི་ཡི་ཕྲ་འདེབས་དགོས་པ་སྟེ། ཤུར་ཕྲེང་དང་པོ་ནི་པདྨ་རཱ་ག་དང་། སྤྲིན་རྡོ། མ་རྒད་བཅས་གསུམ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ཤུར་ཕྲེང་གཉིས་པ་ནི་གཡུ་དང་ཨིནྡྲ་ནཱི་ལ་དང་རྡོ་རྗེ་ཕ་ལམ་བཅས་གསུམ། ");
INSERT INTO bodn_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ཤུར་ཕྲེང་གསུམ་པ་ནི་རྟ་ཀླད་སྨུག་པོ་དང་། ཤེལ་རྡོ་དང་། མུ་མེན་བཅས་གསུམ། ");
INSERT INTO bodn_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ཤུར་ཕྲེང་བཞི་པ་ནི་བཻཌཱུརྱ་ལྗང་སེར་དང་། གཟི་དང་གཡང་ཊི་སྔོན་པོ་བཅས་གསུམ་སྟེ། དེ་དག་ནི་གསེར་གྱི་འབུར་ཀོང་ལ་འདེབས་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","རིན་པོ་ཆེ་དེ་དག་གིས་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་གི་མཚོན་རྟགས་བྱེད་ཅིང་མིང་ལྟར་བཅུ་གཉིས་ཡོད་དེ། དམ་ཕྲུག་བཞིན་དུ་རིན་པོ་ཆེ་རེ་རེའི་སྟེང་དུ་ཡེས་ར་ཨེལ་གྱི་ཚོ་པ་བཅུ་གཉིས་པོའི་མིང་རེ་རེ་ལྟར་དུ་བརྐོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","བྲང་རྒྱན་ལ་གསེར་བཙོ་མས་བསླེས་པའི་ཉག་ཐག་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","བྲང་རྒྱན་གྱི་གྲུ་ག་གཉིས་ལ་གསེར་གྱི་ཨ་ལོང་གཉིས་བཟོས་ཏེ་སྦྱོར་ཅིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ཡང་གསེར་གྱི་ཉག་ཐག་དེ་གཉིས་ནི་བྲང་རྒྱན་གྱི་གྲུ་ག་རུ་ཡོད་པའི་ཨ་ལོང་གཉིས་ལ་རྒྱུས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","དེ་ནས་ཉག་ཐག་གི་སྣེ་གཉིས་འབུར་ཀོང་གཉིས་ལ་བཅུག་སྟེ། བེར་ཐུལ་མདུན་ལོགས་ཀྱི་ཕྲག་ཁེབས་སྟེང་སྦྱོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ཡང་གསེར་གྱི་ཨ་ལོང་གཞན་གཉིས་བཟོས་ནས་བྲང་རྒྱན་གྱི་གྲུ་ག་གཉིས་ལ་སྦྱོར་ཅིག སྦྱོར་ས་དེ་ནི་བྲང་རྒྱན་གྱི་ཟུར་ཁ་ཡིན་ལ་བྲང་རྒྱན་དང་བེར་ཐུལ་གྱི་བར་མཚམས་ཀྱང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ཡང་གསེར་གྱི་ཨ་ལོང་གཉིས་བཟོས་ནས་བེར་ཐུལ་གྱི་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་ཀྱི་མདུན་ལོགས་ཀྱི་འོག་དང་སྐེད་ཆིངས་མཆོར་པོ་ཅན་གྱི་འབྲེལ་སའི་ཅུང་ཟད་གོང་དུ་ཆུག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","བྲང་རྒྱན་དེ་བེར་ཐུལ་གྱི་སྐེད་ཆིངས་མཆོར་པོ་ཅན་དང་དམ་དུ་འབྲེལ་བ་དང་བེར་ཐུལ་ལས་མི་འཆོར་བའི་ཕྱིར། བྲང་རྒྱན་གྱི་ཨ་ལོང་དེ་བེར་ཐུལ་གྱི་ཨ་ལོང་ལ་སྡེམ་ཐག་སྔོན་པོ་ཡིས་བསྡམ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","དེ་ལྟར་ཨ་རོན་གནས་དམ་པར་འགྲོ་བའི་སྐབས་སུ། བློ་འདོན་པའི་བྲང་རྒྱན་ལ་ཡོད་པའི་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་དག་སྙིང་གི་དྲང་ཐད་དུ་འཛིན་པར་བྱེད་དགོས་ཤིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་རྒྱུན་དུ་རྗེས་དྲན་ཡོད་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ཡང་ཨུའུ་རིམ་དང་ཐུའུ་མིམ་ཞེས་པའི་རྟགས་རིལ་གཉིས་བློ་འདོན་པའི་བྲང་རྒྱན་གྱི་ནང་དུ་བཅུག་སྟེ། ཨ་རོན་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་འགྲོ་སྐབས་དེ་གཉིས་ཁོའི་སྙིང་གི་དྲང་ཐད་དུ་ཡོད་ཅིང་། ཁོས་རྒྱུན་པར་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བློ་འདོན་པ་དེ་རང་གི་སྙིང་གི་དྲང་ཐད་དུ་འཁུར་བར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ཡང་འདི་སྐད་དུ། བེར་ཐུལ་འོག་གི་གོས་རིང་ནི་ཁ་དོག་སྔོན་པོས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","དེའི་སྟོད་དཀྱིལ་དུ་མགོའི་ཕྱིར་ཁུང་བུ་ཞིག་འཇོག་དགོས་ཤིང་། དེའི་མཐའ་འཁོར་ལ་འཐག་བཟོ་བྱས་པའི་གོང་བ་ཞིག་ཀྱང་ཡོད་པར་བྱེད་དགོས་ལ། མི་རལ་བའི་ཕྱིར་གོ་ཁྲབ་ཀྱི་གོང་བ་ལྟར་དུ་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ཡང་དེའི་གོས་འདབ་ཀྱི་མཐའ་འཁོར་དུ་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག མཚལ་དམར་བཅས་ཀྱི་སེ་འབྲུས་བརྒྱན་དགོས་ཤིང་། སེ་འབྲུ་རེ་རེའི་བར་གསེབ་ཏུ་ཡང་གསེར་གྱི་གཡེར་ཁ་རྣམས་འདོགས་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","གསེར་གྱི་གཡེར་ཁ་གཅིག་དང་སེ་འབྲུ་གཅིག ཡང་གསེར་གྱི་གཡེར་ཁ་གཅིག་དང་སེ་འབྲུ་གཅིག་བཅས་གོས་རིང་གི་འདབ་ཁ་ཐམས་ཅད་ལ་ཡོད་པར་བྱེད་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ཨ་རོན་གྱིས་ཞབས་ཕྱི་སྒྲུབ་སྐབས་གོས་དེ་གྱོན་དགོས་ཤིང་། གནས་དམ་པ་རུ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་དྲུང་དུ་འགྲོ་བ་དང་ཕྱིར་འོང་སྐབས་ཁོ་རང་མི་འཆི་བའི་ཕྱིར་གོས་དེའི་སྐད་སྒྲ་ཐོས་པར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་གསེར་བཙོ་མའི་བྱང་བུ་ཞིག་བཟོས་ནས་དེའི་སྟེང་ལ་དམ་ཕྲུག་བརྐོ་བ་བཞིན་དུ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་དུ་དམ་པའོ་ཞེས་བརྐོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ཡང་དེ་ལ་རས་སྔོན་པོའི་ཉག་ཐག་ཅིག་སྦྱར་ནས་ལ་ཐོད་དང་སྦྲེལ་བ་དང་། གསེར་གྱི་བྱང་བུ་ནི་ལ་ཐོད་ཀྱི་མདུན་ལོགས་སུ་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","དེ་ལྟར་དེ་ནི་ཨ་རོན་གྱི་དཔྲལ་བར་ཡོད་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མཆོད་པ་དམ་པ་འབུལ་བའི་ཚེ། སྐྱོན་དང་ནོར་བ་གང་ཞིག་ཡོད་ཚེ། དེའི་ཉེས་པ་ཐམས་ཅད་ཨ་རོན་རང་གིས་འཁུར་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་མཆོད་པ་དེ་དག་ལ་ཐུགས་དགྱེས་པའི་ཕྱིར་བྱང་བུ་དེ་གཏན་དུ་ཨ་རོན་གྱི་དཔྲལ་བར་ཡོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ཡང་ཁྱོད་ཀྱིས་སོ་རས་སྲབ་བུ་ཡིས་ནང་གོས་འབུར་རིས་མ་འཐག་དགོས་པ་དང་། ཡང་སོ་རས་སྲབ་བུ་ཡིས་ལ་ཐོད་བཟོ་བ་དང་། འཐག་མཁན་གྱི་ལས་བཞིན་དུ་སྐེད་ཆིངས་བཅས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ཡང་ཨ་རོན་གྱི་བུ་རྣམས་ལ་ནང་གོས་དང་སྐེད་ཆིངས་དང་པྲོག་ཞུ་རྣམས་བརྗིད་ཉམས་དང་མཛེས་སྡུག་ལྡན་པའི་ཕྱིར་དུ་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ཁྱོད་ཀྱིས་ན་བཟའ་དེ་རྣམས་རང་གི་ཕུ་བོ་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་བསྐོན་དགོས་པ་དང་། དེ་དག་གིས་ང་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར། ཁོ་རྣམས་ལ་སྣུམ་གྱིས་བྱུག་པ་དང་། བསྐོས་ནས་དམ་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ཡང་དེ་དག་གི་ཤ་རྗེན་པ་གཡོག་པའི་ཕྱིར་སོ་རས་ཀྱི་ཨང་ཐུང་རྐེད་པ་ནས་བརླའི་བར་དུ་སླེབས་པ་རྣམས་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ཨ་རོན་དང་དེའི་བུ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་འཇུག་པའམ། གནས་དམ་པའི་ནང་ནས་ཞབས་ཕྱི་བྱེད་པའི་ཆེད་དུ་མཆོད་ཁྲིའི་དྲུང་དུ་འོང་ཚེ་དེ་དག་གྱོན་དགོས་པ་སྟེ། གལ་སྲིད་དེ་ལྟར་མ་བྱས་ན་ཉེས་སྐྱོན་ཕོག་ནས་འཆི་དགོས་པའི་ཕྱིར་རོ། །སྒྲིག་ཁྲིམས་དེ་ནི་གཏན་དུ་གནས་དགོས་ཏེ་ཨ་རོན་དང་དེའི་བུ་རྒྱུད་རྣམས་ཀྱི་ཕྱིར་དུ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་དམ་པར་འགྱུར་བ་དང་བདག་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་འདི་ལྟར་གྱིས་ཤིག གླང་ཐུག་ཁ་ཆུང་ཞིག་དང་། ལུག་ཐུག་བཙོག་སྐྱོན་མེད་པ་གཉིས་འདེམས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","སྐྱུར་མེད་བག་ལེབ་དང་སྐྱུར་མེད་བག་ལེབ་ལ་འཚིར་སྣུམ་བསྲེས་པ་ཅན་དང་སྐྱུར་མེད་བག་ལེབ་ལ་འཚིར་སྣུམ་གྱིས་བྱུགས་པ་ཅན་བཅས་གྲོ་ཞིབ་ལྡེ་གུ་ཡིས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","དེ་དག་གཟེབ་ཀྱི་ནང་དུ་བཞག་སྟེ་ཁྱེར་འོང་བ་དང་གླང་ཐུག་དང་ལུག་ཐུག་གཉིས་ཀྱང་དེད་ནས་འོང་དགོས་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ཨ་རོན་དང་ཁོའི་བུ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་འགྲམ་དུ་ཁྲིད་དེ་ཆུས་བཀྲུ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","དེ་ནས་ཨ་རོན་ལ་ནང་གོས་དང་གོས་རིང་དང་བེར་ཐུལ་དང་བྲང་རྒྱན་བཅས་གྱོན་དུ་འཇུག་པ་དང་བེར་ཐུལ་གྱི་སྐེད་ཆིངས་མཆོར་པོ་ཅན་གྱིས་བསྡམ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","དེའི་མགོར་ལ་ཐོད་བསྐོན་ཏེ་ལ་ཐོད་ལ་ཅོད་པན་དམ་པ་སྦྱོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","དེ་ནས་ཁོའི་མགོ་ལ་འབྱུག་སྣུམ་བླུགས་ནས་བྱུགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ཡང་ཁོའི་བུ་རྣམས་ཁྲིད་ཡོང་ནས་ནང་གོས་བསྐོན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་སྐེད་ཆིངས་བཅིངས་ནས་པྲོག་ཞུ་དཀྲི་དགོས་ཤིང་། དེ་ལྟར་ཁོ་རྣམས་ལ་མཆོད་དཔོན་གྱི་གོ་གནས་ཐོབ་པ་ནི་གཏན་དུ་གནས་པའི་སྒྲིག་ཁྲིམས་ཤིག་ཡིན། ཁྱོད་ཀྱིས་དེ་ལྟར་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་བསྐོ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ཁྱོད་ཀྱིས་གླང་ཐུག་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་སར་འཁྲིད་དགོས་ལ། ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་སོ་སོའི་ལག་པ་གླང་ཐུག་གི་མགོ་ལ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་རུ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་གླང་ཐུག་ཤོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ཡང་གླང་ཐུག་གི་ཁྲག་ཉུང་ཙམ་བླངས་ནས་ལག་མཛུབ་ཀྱིས་མཆོད་ཁྲིའི་རུ་ཐུར་བཞི་ལ་བསྐུ་དགོས་པ་དང་། དེ་ནས་ཁྲག་ཡོངས་རྫོགས་མཆོད་ཁྲིའི་འགབ་འོག་ཏུ་བླུགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","དེ་ནས་ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་ཐམས་ཅད་དང་མཆིན་པའི་ཐོག་གི་རྩ་རྒྱུས་དང་། མཁལ་མ་གཉིས་ཀ་དང་དེའི་སྟེང་གི་ཚིལ་བཅས་ལོངས་ལ་མཆོད་ཁྲིའི་ཁ་ནས་མེས་སྲེགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ཡང་གླང་ཐུག་གི་ཤ་དང་པགས་པ་དང་ལྕི་བ་བཅས་ནི་སྒར་གྱི་ཕྱི་རོལ་ཏུ་མེས་བསྲེག་དགོས། ཅི་ཡིན་ཞེ་ན། དེ་ནི་སྡིག་བཤགས་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ཡང་ལུག་ཐུག་ཅིག་ཁྱོད་ཀྱིས་ཁྲིད་ནས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་སོ་སོའི་ལག་པ་ལུག་ཐུག་གི་མགོ་ལ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ལུག་ཐུག་དེ་བཤས་ནས་དེའི་ཁྲག་ལོངས་ལ་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ཁྱོད་ཀྱིས་ལུག་ཐུག་གི་ལྷུ་ཚིགས་རེ་རེ་ཆོད་ལ། ནང་ཁྲོལ་དང་རྐང་ལག་དག་བཀྲུས་ནས་ལྷུ་རྣམས་མགོ་དང་མཉམ་དུ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ལུག་ཐུག་ཧྲིལ་པོ་མཆོད་ཁྲིའི་ཁར་སྦྱིན་སྲེག་ཏུ་ཕུལ་ཞིག དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་སྦྱིན་སྲེག་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་གྱི་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","དེ་ནས་ཁྱོད་ཀྱིས་ལུག་ཐུག་ཅིག་བཤས་ཏེ་ཁྲིད་འོངས་ནས། ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་སོ་སོའི་ལག་པ་དེའི་མགོར་འཇོག་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ལུག་ཐུག་དེ་བཤས་ནས། ཁྲག་ཉུང་ཙམ་བླངས་ཏེ་ཨ་རོན་གྱི་རྣ་ཤལ་གཡས་པ་དང་། དེའི་བུ་རྣམས་ཀྱི་རྣ་ཤལ་གཡས་པ་དང་། དེ་དག་གི་གཡས་ལག་གི་མཐེ་བོང་དང་། དེ་དག་གི་རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་ལ་བསྐུ་བར་བྱའོ། །ཡང་ཁྲག་དེ་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་ལ་གཏོར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ཡང་མཆོད་ཁྲིའི་སྟེང་གི་ཁྲག་ཉུང་ཙམ་དང་འབྱུག་སྣུམ་ཕྲན་བུ་ཙམ་ལོངས་ལ་ཨ་རོན་དང་ཁོའི་གོས་དང་། ཁོ་དང་མཉམ་དུ་ཡོད་པའི་ཁོའི་བུ་རྣམས་དང་དེ་དག་གི་གོས་ཀྱི་སྟེང་ལ་གཏོར་ཅིག དེ་ནས་ཨ་རོན་དང་ཁོའི་གོས་དང་། ཁོའི་བུ་རྣམས་དང་དེ་དག་གི་གོས་དང་བཅས་པ་དམ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","དེ་ནས་ལུག་ཐུག་གི་ཚིལ་ཏེ། རྔ་མ་ཚོན་པོ་དང་། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་མཆིན་པའི་ཐོག་གི་རྩ་རྒྱུས་དང་། མཁལ་མ་གཉིས་ཀ་དང་དེའི་སྟེང་གི་ཚིལ་དང་། བརླ་རྐང་གཡས་པ་བཅས་ཁྱོད་ཀྱིས་ལོངས་ཤིག དེ་ནི་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་རུ་ཡོད་པའི་སྐྱུར་མེད་བག་ལེབ་འཇོག་བྱེད་ཀྱི་གཟེབ་ལས་བག་ལེབ་གཅིག་དང་སྣུམ་གོར་གཅིག་དང་། བག་ལེབ་སྲབ་བུ་གཅིག་བཅས་ལོངས་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","རྫས་དེ་ཐམས་ཅད་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱི་ལག་ཏུ་བཞག་ནས་གཡོབ་མཆོད་དུ་བྱས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕར་ཚུར་ལ་གཡོབ་བར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ཡང་རྫས་དེ་དག་ཁོ་ཚོའི་ལག་ནས་ཕྱིར་བླངས་ཏེ་མཆོད་ཁྲིའི་ཁར་ཡོད་པའི་སྦྱིན་སྲེག་གི་སྟེང་དུ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་དྲི་ཞིམ་གྱི་སྦྱིན་སྲེག་ཏུ་ཕུལ་ཞིག དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","དེ་ནས་ཁྱོད་ཀྱིས་ཨ་རོན་མཆོད་དཔོན་དུ་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་གི་བྲང་ཁོག་དེ་བླངས་ནས་གཡོབ་མཆོད་དུ་བྱས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕར་ཚུར་གཡོབ་བར་གྱིས། དེ་ནི་ཁྱོད་རང་གི་སྐལ་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ཨ་རོན་དང་ཁོའི་བུ་རྣམས་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་གི་ཆ་ཤས་ཏེ། ཕར་ཚུར་གཡོབ་བར་བྱེད་པའི་གཡོབ་མཆོད་ཡིན་པའི་བྲང་ཁོག་དང་། འདེགས་པར་བྱེད་པའི་འདེགས་མཆོད་ཡིན་པའི་བརླ་རྐང་གཉིས་ནི་དམ་པར་བྱེད་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","དེ་གཉིས་ནི་རྟག་ཏུ་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་འབུལ་དགོས་ཤིང་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱི་སྐལ་བ་ཡིན་ཏེ། ཅི་ཡིན་ཞེ་ན། དེ་ནི་འདེགས་མཆོད་ཡིན་པས་སོ། །ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་ཞི་བདེའི་མཆོད་པ་ལས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་འདེགས་མཆོད་དུ་འབུལ་དགོས་ཏེ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་འདེགས་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ཡང་ཨ་རོན་གྱི་ན་བཟའ་དམ་པ་རྣམས་རང་གི་བུ་རྒྱུད་རྣམས་ལ་འཐོབ་དགོས་ཤིང་། དེ་དག་ལ་སྣུམ་གྱིས་བྱུགས་པ་དང་མཆོད་དཔོན་དུ་བསྐོ་བའི་དུས་སུ་ན་བཟའ་དེ་དག་གྱོན་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ཨ་རོན་གྱི་བུ་རྣམས་ལས་ཁོའི་ཚབ་ཏུ་མཆོད་དཔོན་བྱེད་པའི་བུ་དེ་ནི། མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་སོང་སྟེ་གནས་དམ་པ་རུ་ཞབས་ཕྱི་བྱེད་པའི་དུས་སུ། ན་བཟའ་དེ་རྣམས་ཉིན་བདུན་གྱི་རིང་ལ་གྱོན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ཡང་ཁྱོད་ཀྱིས་མཆོད་དཔོན་དུ་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་ལོངས་ལ། དེའི་ཤ་ནི་གནས་མཆོག་ཅིག་ཏུ་བཙོ་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་ལུག་ཐུག་གི་ཤ་དང་གཟེབ་ནང་དུ་ཡོད་པའི་བག་ལེབ་ནི་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱི་སྒོ་ཁ་རུ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","མཆོད་དཔོན་དུ་བསྐོ་བར་བྱེད་པ་དང་དམ་པར་བྱེད་པའི་ཕྱིར་སྡིག་བཤགས་སུ་ཕུལ་བའི་རྫས་ནི་དམ་པ་ཡིན་པས། ཁོ་རྣམས་ཁོ་ན་ལས་མི་གཞན་སུ་ཞིག་གིས་ཀྱང་བཟའ་བར་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","གལ་ཏེ་མཆོད་དཔོན་དུ་བསྐོ་བར་བྱེད་པའི་ཤ་དང་བག་ལེབ་ལས་སང་ཉིན་གྱི་བར་དུ་ལྷག་མ་ལུས་ན། ལྷག་མ་དེ་མེས་བསྲེག་དགོས་ཤིང་། དེ་དམ་པ་ཡིན་པས་བཟའ་བར་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","བདག་གིས་ཁྱོད་ལ་ཅི་དང་ཅི་བསྒོས་པ་བཞིན་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་བྱོས་ཤིག ཉིན་བདུན་གྱི་རིང་དུ་བསྐོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ཡང་སྡིག་པ་བཤག་པའི་ཕྱིར་ཁྱོད་ཀྱིས་ཉིན་རེ་བཞིན་གླང་ཐུག་ཅིག་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས་ཤིང་། ཡང་མཆོད་ཁྲིའི་ཁར་སྡིག་བཤགས་ཕུལ་ནས་དེ་འདག་པར་བྱའོ། །ཡང་དམ་པར་བྱེད་པའི་ཕྱིར་དེ་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ཉིན་བདུན་གྱི་རིང་ལ་མཆོད་ཁྲི་དམ་པར་བྱེད་པའི་ཕྱིར་སྡིག་བཤགས་མཆོད་པ་འབུལ་དགོས་ལ། དེ་ལྟར་མཆོད་ཁྲི་ནི་ཐམས་ཅད་ལས་དམ་པ་ཡིན་དགོས་ཤིང་། སུ་དང་གང་གིས་མཆོད་ཁྲི་ལ་རེག་ན་དེ་དམ་པར་འགྱུར་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ཁྱོད་ཀྱིས་མཆོད་ཁྲི་ལ་ཉིན་རེ་བཞིན་དུས་རྒྱུན་དུ་འབུལ་བྱ་ནི་འདི་ལྟ་སྟེ། ལུ་གུ་ལོ་གཅིག་ཅན་གཉིས་འབུལ་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ལུ་གུ་གཅིག་ནངས་མོའི་དུས་སུ་འབུལ་དགོས་ལ། ལུ་གུ་ཅིག་ཤོས་ས་སྲོས་ཀྱི་དུས་སུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ཕྱེ་བཟང་པོ་ཨེ་ཕཱ་གང་གི་བཅུ་ཆ་གཅིག་ལ་སྣུམ་བརྡུངས་མ་རྫ་བུམ་གང་གི་བཞི་ཆ་གཅིག་བསྲེས་ནས། ད་དུང་སྐྱེམས་མཆོད་ཀྱི་ཕྱིར་རྒུན་ཆང་རྫ་བུམ་གང་གི་བཞི་ཆ་གཅིག་བཅས་ཁྱོད་ཀྱིས་ལུ་གུ་གཅིག་དང་མཉམ་དུ་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ཡང་ལུ་གུ་ཅིག་ཤོས་དེ་ས་སྲོས་ཀྱི་དུས་སུ་འབུལ་དགོས་ལ། ནངས་མོའི་དུས་ལྟར་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་སྐྱེམས་མཆོད་ཀྱི་ལུགས་ཇི་མ་ཇི་བཞིན་གྱིས། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་དུ་འབུལ་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","དེ་ནི་ཁྱོད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱིས་རྒྱུན་མི་ཆད་པར། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་སྟེ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་སྦྱིན་སྲེག་འབུལ་དགོས་པ་དེའོ། །གནས་དེར་ངས་ཁྱོད་ལ་གཏམ་སྨྲ་བའི་ཕྱིར་གནས་དེ་རུ་ཁྱོད་རྣམས་དང་འཕྲད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","དེར་ང་རང་ཡེས་ར་ཨེལ་པ་རྣམས་དང་ཕྲད་དེ། མཇལ་འཕྲད་གུར་མཆོག་ང་ཡི་གཟི་བརྗིད་ཀྱིས་དམ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ཡང་བདག་གིས་མཇལ་འཕྲད་གུར་མཆོག་དང་མཆོད་ཁྲི་དམ་པར་བྱའོ། །ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱང་བདག་ལ་ཞབས་ཕྱི་བྱེད་པའི་མཆོད་དཔོན་དུ་དམ་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ཡང་ང་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་དཀྱིལ་དུ་གནས་ཤིང་། དེ་དག་གི་དཀོན་མཆོག་ཡིན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ང་རང་དེ་དག་གི་དཀྱིལ་དུ་གནས་པའི་ཆེད་དུ། བདག་ནི་ཁོ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་མཁན་ཡིན་ཞིང་། ཁོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པ་དེ་དག་གིས་ཤེས་པར་འགྱུར་ལ། བདག་ནི་ཁོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་སེང་ལྡེང་ཤིང་གིས་སྤོས་ཁྲི་ཞིག་འདི་ལྟར་བཟོ་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","དེའི་རིང་ཚད་ལ་ཁྲུ་གཅིག་དང་། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་སྟེ་གྲུ་བཞི་མ་ཞིག་ཡིན་དགོས། ཡང་དེའི་མཐོ་ཚད་ལ་ཁྲུ་གཉིས་དང་། རུ་ཐུར་རྣམས་སྤོས་ཁྲི་དང་དངོས་པོ་གཅིག་ཏུ་སྦྲེལ་བར་བཟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","དེའི་ཐོག་དང་ལོགས་བཞི་དང་རུ་ཐུར་རྣམས་གསེར་བཙོ་མས་གཡོགས་ཤིག དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ཡང་གསེར་གྱི་ཨ་ལོང་གཉིས་བཟོ་དགོས་ཏེ་མུ་ཁྱུད་ཀྱི་འོག་ནས་ཁ་གཏད་ཀྱི་ལོགས་གཉིས་ཀར་སྦྱོར་དང་། དེ་ནི་རྒྱུག་པ་གཉིས་བསྐོན་ས་ཡིན་ལ། དེས་སྤོས་ཁྲི་འཁུར་དགོས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","རྒྱུག་པ་དེ་གཉིས་སེང་ལྡེང་ཤིང་གིས་བཟོས་ལ་གསེར་གྱིས་གཡོགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ཡང་དཔང་མཛད་ཤུར་སྒམ་དང་དེའི་སྟེང་དུ་ཡོད་པའི་ཐུགས་རྗེའི་བཞུགས་ཁྲིའི་མདུན་ས་སྟེ། ང་རང་ཁྱོད་དང་འཕྲད་པའི་གནས་དེའི་ཡོལ་བའི་སྔོན་དུ་སྤོས་ཀྱི་སྒྲོམ་དེ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ཞོགས་པ་རེ་རེ་བཞིན་ཨ་རོན་གྱིས་སྒྲོན་མེ་རྣམས་ལ་བདག་བྱེད་པའི་སྐབས་སུ། སྤོས་ཀྱི་སྒྲོམ་དུ་དྲི་ཞིམ་བདུག་སྤོས་བདུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ཁོས་ས་སྲོས་ཀྱི་དུས་སུ་སྒྲོན་མེ་རྣམས་སྒྲོན་པའི་ཚེ། ཡང་སྤོས་བདུག་དགོས་ལ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཁྱོད་རྣམས་མི་རབས་ནས་མི་རབས་བར་རྒྱུན་ཆད་མེད་པའི་བདུག་སྤོས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","འོན་ཀྱང་སྤོས་ཁྲི་འདིའི་སྟེང་དུ་སྤོས་ཡ་མ་ཟུང་འབུལ་མི་རུང་། ཡང་སྦྱིན་སྲེག་གམ། འབྲུ་རིགས་ཀྱི་མཆོད་པའམ། སྐྱེམས་མཆོད་བཅས་དེ་ལ་འབུལ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ཨ་རོན་གྱིས་ལོ་རེར་ཐེངས་གཅིག་ལ་དེའི་རུ་ཐུར་རྣམས་ཀྱི་སྟེང་དུ་སྡིག་པ་བཤགས་པའི་ཆོ་ག་བྱེད་དགོས་ཏེ། ཁྱོད་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར། ཁོས་སྡིག་བཤགས་མཆོད་པའི་ཁྲག་གིས་དེའི་ཁར་ཆོ་ག་དེ་བྱེད་དགོས་ལ། སྤོས་ཁྲི་དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཀུན་ལས་དམ་པ་ལགས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཚང་རྩིས་བྱེད་པའི་ཚེ། དེ་དག་ལ་ཆག་སྒོ་མི་འབྱུང་བའི་ཕྱིར། སྐབས་དེར་ཁོ་ཚོ་མི་རེ་རེས་རང་གི་ཚེ་སྲོག་གི་ཕྱིར་བླུ་རིན་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","དེ་དག་གི་འབུལ་བ་ནི་འདི་ལྟར། ཚང་རྩིས་བྱས་པའི་མི་རེས་གནས་མཆོག་གི་སྲང་བཞིན་དུ་དངུལ་སྲང་ཕྱེད་ཀ་འབུལ་དགོས། དངུལ་སྲང་ཕྱེད་ཀ་དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་འབུལ་བ་ཡིན་ཏེ། དངུལ་སྲང་གཅིག་ནི་གཱེ་ར་ ཉི་ཤུ་དང་འདྲ། ");
INSERT INTO bodn_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ཚང་རྩིས་བྱས་པའི་མི་ཐམས་ཅད་ལས། ལོ་ཉི་ཤུ་དང་དེ་ལས་བརྒལ་བ་ཚོས་འབུལ་བ་དེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ཁྱོད་ཅག་གིས་ཚེ་སྲོག་བླུ་བའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་འབུལ་བའི་ཚེ། དངུལ་སྲང་ཕྱེད་ཀ་མ་གཏོགས། མི་ཕྱུག་པོ་ཡིན་ཡང་ལྷག་མ་མི་འབུལ་ལ། མི་དབུལ་པོ་ཡིན་ཡང་ཉུང་དུ་མི་འཕྲི་བར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་བླུ་རིན་དེ་བསྡུས་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཞབས་འདེགས་ཕྱིར་ཞོག་ཅིག དེ་ལྟར་ཁྱོད་རྣམས་ཀྱི་ཚེ་སྲོག་བླུ་བ་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་རྗེས་དྲན་ཡོད་པར་བྱའོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","ཁྱོད་རྣམས་བཀྲུ་བའི་ཕྱིར་དུ་ལི་ཡི་གཞོང་པ་ཞིག་དང་དེའི་སྟེགས་བུ་ཞིག་བཟོས་ལ། མཇལ་འཕྲད་གུར་མཆོག་དང་མཆོད་ཁྲིའི་བར་དུ་བཞག་ནས་དེའི་ནང་དུ་ཆུ་བླུགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་གཞོང་པ་འདིར་ལག་པ་དང་རྐང་པ་བཀྲུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","དེ་དག་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འཇུག་པའམ། ཞབས་ཕྱི་བྱེད་དུ་མཆོད་ཁྲི་དང་ཉེ་བར་འོངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་བའི་ཚེ། འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་ཆུ་དེས་བཀྲུ་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","རང་རང་གི་ལག་པ་དང་རྐང་པ་གཉིས་བཀྲུས་ན་ཁོ་ཚོ་འཆི་བར་མི་འགྱུར་ཞིང་། དེ་ནི་ཨ་རོན་དང་ཁོའི་བུ་རྒྱུད་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར་གཏན་དུ་གནས་པའི་སྒྲིག་ཁྲིམས་ཤིག་ཏུ་འགྱུར་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","ཁྱོད་ཀྱིས་བསུང་རྫས་རྣམས་ཀྱི་མཆོག་སྟེ། རང་བཞིན་གྱིས་གཤེར་བའི་གུ་གུལ་སྲང་ལྔ་བརྒྱ་དང་ཤིང་ཚ་སྲང་ཉིས་བརྒྱ་དང་ལྔ་བཅུ་ལེན་དགོས་ལ། ཡང་སྲང་ཉིས་བརྒྱ་དང་ལྔ་བཅུ་ཡོད་པའི་ཤུ་དག་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","གནས་མཆོག་གི་སྲང་བཞིན་དུ་ཁ་ཚི་ཡཱ་སྲང་ལྔ་བརྒྱ་དང་། སྐྱུ་རུ་རའི་འཚིར་སྣུམ་རྫ་བུམ་གང་ལོངས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","རྒྱུ་དེས་འབྱུག་སྣུམ་དམ་པ་བཟོ་དགོས་ཤིང་། དེ་ནི་སྤོས་ཆུ་བཟོ་མཁན་གྱི་ལུགས་བཞིན་དུ་བསྡེབ་པ་སྟེ་འབྱུག་སྣུམ་དམ་པ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","དེ་ཡིས་མཇལ་འཕྲད་གུར་མཆོག་དང་དཔང་མཛད་ཤུར་སྒམ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","སྒྲོག་ཙེ་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་། སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་མཐའ་དག་དང་། དེ་མིན་སྤོས་ཁྲི་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་དང་དེའི་ཡོ་བྱད་ཀུན། ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་ལའང་འབྱུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","དངོས་པོ་དེ་རྣམས་ནི་ཀུན་ལས་དམ་པར་འགྱུར་བའི་ཕྱིར་དེ་ལྟར་དམ་པར་བྱོས་ཤིག སུ་དང་གང་གིས་དེ་དག་ལ་རེག་ན་དམ་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ཁྱོད་ཀྱིས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་འབྱུག་དགོས་ཤིང་། དེ་དག་གིས་ང་རང་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་དམ་པར་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ཡང་ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་སྐད་སྨྲོས་ཤིག འདི་ནི་ཁྱོད་ཅག་གི་མི་རབས་ནས་མི་རབས་བར་བདག་གི་ཕྱིར་འབྱུག་སྣུམ་དམ་པ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","དེ་མི་ཡི་སྟེང་དུ་མི་ལྡུག་པར་གྱིས། ཁྱོད་རྣམས་ཀྱིས་དེ་དང་གཅིག་པའི་སྦྱོར་ལུགས་ཀྱིས་དེ་དང་མཚུངས་པའང་བཟོ་བར་མི་བྱ་སྟེ། ཅི་ཡིན་ཞེ་ན། དེ་ནི་དམ་པ་ཡིན་པས་ཁྱོད་ཅག་གིས་ཀྱང་དེ་དམ་པར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","སུས་ཀྱང་དེ་དང་འདྲ་བའི་འབྱུག་སྣུམ་གྱི་སྦྱོར་ལུགས་བྱེད་པའམ། དེ་ཡིས་མི་གཞན་ཞིག་ལ་བྱུགས་པ་སོགས་གང་བྱས་ཀྱང་། མི་དེ་རང་གི་མི་རྣམས་ལས་འཕུད་དགོས་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་བསུང་རྫས་ཏེ། ཐང་སྨན་ཤིང་ཚྭའི་སྣུམ་དང་། དབང་ལག་དང་། གན་ངྷ་ར་ས་དང་སྤོས་དཀར་སླད་མེད་བཅས་མང་ཉུང་མེད་པར་ལོངས་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","སྤོས་ཆུ་བཟོ་མཁན་གྱི་ལུགས་བཞིན་དུ་བསྡེབ་པ་དང་། དེ་ལ་ཚྭ་བསྲེས་ནས་སླད་མེད་པ་དང་དམ་པར་མཛད་དེ་སྤོས་བཟོ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","དེ་ལས་སྤོས་ཁ་ཤས་ཕྱེ་མར་བཏགས་ནས། མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་དཔང་མཛད་ཤུར་སྒམ་གྱི་མདུན་དུ་ང་རང་ཁྱོད་དང་འཕྲད་སར་ཞོག་ཅིག དེ་ནི་ཁྱོད་ཅག་གི་ཕྱིར་ཀུན་ལས་དམ་པ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ཡང་ཁྱོད་ཀྱིས་སྤོས་དེའི་སྦྱོར་ལུགས་བཞིན་དུ་ཁྱོད་ཅག་གི་ཆེད་དུ་སྤོས་བཟོ་མི་རུང་ལ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་དེ་ནི་ཁྱོད་ཀྱིས་དམ་པར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","སྤོས་དྲིར་བསྣམ་པའི་ཕྱིར་དེ་དང་འདྲ་བ་ཞིག་བཟོ་བའི་མི་སུ་ཡིན་ཡང་རང་གི་མི་རྣམས་ལས་འཕུད་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","ལྟོས་དང་། བདག་གིས་ཡ་ཧུ་དཱ་ཚོ་པ་ནས་ཧུ་རཱའི་བུ་ཨོའུ་རེལ་དེའི་བུ་པི་ཟིད་ཨེལ་གྱི་མིང་ནས་བོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ཡང་ངས་ཁོ་ལ་དཀོན་མཆོག་གི་ཐུགས་ཉིད་ཀྱིས་ཁྱབ་པར་བྱས་ཏེ། ཁོ་ལ་ཤེས་རབ་དང་སྤྱང་གྲུང་ལྡན་ཞིང་། བློ་རིག་མངའ་བ་དང་། ལག་རྩལ་སྣ་ཚོགས་བྱང་ཆུབ་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","དེ་ནི་ལག་རྩལ་ཅན་གྱི་ལས་རྣམས་ཇུས་འགོད་བྱེད་པའི་ཆེད་དུ་ཡིན་ལ། གསེར་དངུལ་ལི་གསུམ་གྱི་མགར་བྱེད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","རིན་པོ་ཆེ་དག་བརྐོ་གཏུབ་བྱེད་པ་དང་ཕྲ་རྒྱག་པ། ཤིང་བརྐོ་བ། ལག་རྩལ་སྣ་ཚོགས་ཀྱི་ལས་བྱེད་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ཡང་ལྟོས་དང་། ངས་ཁོ་དང་ལྷན་དུ་དཱན་གྱི་ཚོ་པ་ནས་ཨ་ཧི་སཱ་མག་གི་བུ་ཨོ་ཧོ་ལི་ཨབ་བྱ་བ་ཁོའི་ལས་གྲོགས་སུ་བདམས་ཤིང་། ཁྱོད་ལ་སྨྲས་པ་མཐའ་དག་བཟོ་བའི་ཕྱིར། བདག་གིས་བཟོ་བོ་མཁས་པ་ཐམས་ཅད་ལའང་ཤེས་རབ་མངའ་བར་བྱས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","མཇལ་འཕྲད་གུར་མཆོག་དང་། དཔང་མཛད་ཤུར་སྒམ་དང་། དེའི་སྟེང་དུ་ཡོད་པའི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་དང་། གུར་མཆོག་གི་དངོས་པོ་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","སྒྲོག་ཙེ་དང་དེའི་ཡོ་བྱད་རྣམས་དང་། གསེར་བཙོ་མའི་སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་རྣམས་དང་། སྤོས་ཁྲི་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་། ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ཐགས་ཞིབ་མོར་བཏགས་པའི་གོས་རྣམས་དང་། མཆོད་དཔོན་ཨ་རོན་གྱི་ན་བཟའ་དམ་པ་རྣམས་དང་ཁོའི་བུ་རྣམས་ཀྱིས་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ན་བཟའ་རྣམས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་གནས་དམ་པའི་ཕྱིར་སྦྱར་བ་བཅས་ནི་ངས་ཁྱོད་ལ་ཅི་དང་ཅི་བསྒོས་པ་བཞིན་དུ་དེ་དག་གིས་བཟོ་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲ་བར་གྱིས། བདག་གི་ངལ་གསོ་བའི་ཉིན་རྣམས་སྲུངས་ཤིག ཅི་ཡིན་ཞེ་ན། བདག་ནི་ཁྱོད་ཅག་དམ་པར་བྱེད་པའི་ཡ་ཝཱེ་ཡིན་པ་ཤེས་ཐུབ་པའི་ཕྱིར། ཉིན་དེ་ནི་ང་དང་ཁྱོད་ཅག་གི་མི་རབས་ནས་མི་རབས་བར་གྱི་རྟགས་ཤིག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ངལ་གསོ་བའི་ཉིན་མོ་ནི་ཁྱོད་ཅག་གི་ཕྱིར་དམ་པ་ཡིན་པས་སྲུངས་ཤིག ཁྲིམས་དེ་མི་རྩི་མཁན་ཐམས་ཅད་སྲོག་དང་འཕྲལ་བར་གྱིས། ཉིན་མོ་དེ་ལ་ལས་ཀ་བྱེད་མཁན་སུ་ཡིན་ཡང་རང་གི་མི་རྣམས་ལས་འཕུད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ཉིན་དྲུག་གི་རིང་ལ་ལས་ཀ་བྱེད་ཅིང་ཉིན་བདུན་པ་ནི་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་ངལ་གསོ་བའི་ཉིན་དམ་པ་ཡིན། ངལ་གསོ་བའི་ཉིན་མོར་ལས་ཀ་བྱེད་མཁན་འཆི་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","དེ་བས་ན་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ངལ་གསོ་བའི་ཉིན་བསྲུང་དགོས་ཤིང་། དེ་དག་གི་བུ་རྒྱུད་རྣམས་ཀྱིས་ཀྱང་དུས་གཏན་གྱི་ཁ་ཆད་འདི་འགྱུར་བ་མེད་པར་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","དེ་ནི་ང་དང་ཡེས་ར་ཨེལ་པའི་བར་གྱི་གཏན་དུ་གནས་པའི་རྟགས་ཤིག་ཡིན། ཅིའི་ཕྱིར་ཞེ་ན། ཉིན་དྲུག་གི་རིང་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ནམ་མཁའ་དང་ས་གཞི་བཀོད་ཅིང་། ཉིན་བདུན་པར་ངལ་གསོ་མཛད་ནས་ཐུགས་དལ་བར་བཞུགས་པ་ཡིན་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ཡང་ཁོང་གིས་སི་ནཱ་རི་བོར་མོ་ཤེ་ལ་གསུང་གླེང་མཛད་ཟིན་ཏེ། དཔང་པོའི་རྡོ་ལེབ་གཉིས་ཏེ་དཀོན་མཆོག་གི་ཕྱག་མཛུབ་ཀྱིས་ཡི་གེར་བཀོད་པ་ཁོ་ལ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ཡང་མོ་ཤེ་ཡིས་རི་ནས་འབབ་པའི་དུས་ཚོད་འགོར་འགྱང་བྱས་པ་མི་རྣམས་ཀྱིས་ཤེས་ཏེ་ཁོ་ཚོ་ཨ་རོན་གྱི་མདུན་དུ་འཛོམས་ནས་འདི་ལྟར། ངེད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་མཁན་མོ་ཤེ་དེ་ལ་ཅི་ཞིག་བྱུང་བ་མི་ཤེས་པས། ད་ལངས་ནས་ངེད་ཅག་ལ་ལམ་སྣ་འདྲེན་པའི་ལྷ་སྐུ་བཟོས་ཤིག་ཅེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ཨ་རོན་ན་རེ། ཁྱོད་ཅག་གིས་རང་གི་ཆུང་མ་དང་བུ་བུ་མོ་དག་གི་གསེར་གྱི་རྣ་ལུང་རྣམས་བླངས་ནས་ངའི་མདུན་དུ་ཁྱེར་ཤོག་ཅིག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","མི་ཐམས་ཅད་ཀྱིས་གསེར་གྱི་རྣ་ལོང་རྣམས་བླངས་ནས་ཨ་རོན་གྱི་མདུན་དུ་ཁྱེར་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ཁོས་དེ་དག་གི་ལག་ནས་བླངས་ཤིང་གཟོང་ཁ་བསྐོར་ཏེ་བ་ཕྲུག་གི་སྐུ་བརྙན་ཞིག་བླུགས་པ་དང་། དེ་དག་གིས། ཀྱེ་ཡེས་ར་ཨེལ་པ་རྣམས། འདི་ནི་ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པའི་ལྷ་ལགས་སོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ཨ་རོན་གྱིས་དེ་མཐོང་བ་དང་། བ་ཕྲུག་གི་སྐུ་བརྙན་མདུན་དུ་མཆོད་ཁྲི་ཞིག་བརྩིགས་ནས། སང་ཉིན་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་ཡིན་ཞེས་བསྒྲགས། ");
INSERT INTO bodn_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","དེའི་ཕྱི་ཉིན་ཐོ་རངས་ཁོ་རྣམས་ཡར་ལངས་ནས་སྦྱིན་སྲེག་དང་ཞི་བདེའི་མཆོད་པ་ཕུལ་ཏེ། མར་བསྡད་ནས་བཟའ་བཏུང་ལ་རོལ་བ་དང་ཡར་ལངས་ནས་རྩེད་མོ་རྩེས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་མྱུར་དུ་རི་ལས་བོབས་ཤིག ཁྱོད་ཀྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་འོངས་པའི་མི་རྣམས་ཀྱིས་སྤྱོད་པ་ཐ་ཤལ་བ་བྱས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","དེ་དག་གིས་མྱུར་བ་མྱུར་དུ་ངས་བསྟན་པའི་ལམ་དེ་ལོགས་སུ་བཞག་ཅིང་། རང་གི་ཆེད་དུ་བ་ཕྲུག་གི་སྐུ་བླུགས་ནས་དེ་ལ་ཕྱག་བཙལ་བ་དང་མཆོད་པ་ཕུལ་ནས་ན་རེ། ཀྱེ་ཡེས་ར་ཨེལ་པ་རྣམས། འདི་ནི་ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པའི་ལྷ་ལགས་སོ་ཞེས་སྨྲ་བཞིན་འདུག་ཅེས་གསུངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ཡང་འདི་སྐད་དུ། བདག་གིས་མི་འདི་རྣམས་ལ་བལྟས་ཤིང་། ཀྱེ་ཧོ། དངོས་གནས་འབངས་གཉའ་རེངས་ཤིག་འདུག ");
INSERT INTO bodn_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","དེ་བས་ན་ངའི་ཁོང་ཁྲོ་དེ་དག་གི་ཕྱོགས་སུ་འབར་ནས་དེ་དག་མེད་པར་གཏོང་བའི་ཕྱིར་དུ། ང་ནི་རང་དགར་བསྐྱུར་ཞོག ངས་ཁྱོད་རང་ཁོ་ནའི་བུ་རྒྱུད་ནི་རྒྱལ་ཁབ་ཆེན་པོ་ཞིག་ཏུ་འགྱུར་བར་བྱ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","དེ་ནས་མོ་ཤེ་ཡིས་རང་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ནན་གྱིས་ཞུས་པ་ནི། ཀྱེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལགས། ཁྱེད་ཀྱིས་ནུས་མཐུ་ཆེ་ཞིང་སྟོབས་དང་ལྡན་པའི་ཕྱག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་འོངས་པའི་རང་གི་འབངས་མི་ལ། ཁྱེད་རང་ཐུགས་རབ་ཏུ་ཁྲོ་བ་ཅི་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ཅིའི་ཕྱིར་མ་འོངས་པར་ཨེ་ཅིབ་པ་རྣམས་ལ། དཀོན་མཆོག་གིས་དམིགས་ཡུལ་ངན་པ་བཅངས་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཕྱི་རུ་ཁྲིད་དེ། རི་བོ་ནས་བསད་དེ་ས་སྟེང་ནས་མེད་པར་མཛད་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲ་རུ་འཇུག་གམ། ཁྱེད་ཀྱི་ཐུགས་ཁྲོ་བའི་མེ་ལྕེ་གཞིལ་བར་མཁྱེན། ཉིད་ཀྱི་འབངས་མི་ལ་གནོད་འཚེ་གཏོང་བར་དགོངས་ཀྱང་ཐུགས་ལ་སྙིང་རྗེ་ཡོད་པར་ཞུ། ");
INSERT INTO bodn_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ཁྱེད་ཀྱི་ཞབས་ཕྱི་རྣམས་ཏེ་ཨབ་ར་ཧམ་དང་། ཨི་སཱག་དང་། ཡེས་ར་ཨེལ་བཅས་ཐུགས་ལ་དྲན་དུ་གསོལ། སྔར་ཁྱེད་ཀྱིས་རང་ཉིད་དཔང་དུ་བཙུགས་ནས་དེ་དག་ལ་འདི་སྐད་དུ། ངས་ཁྱོད་ཅག་གི་བུ་རྒྱུད་ནམ་མཁའི་སྐར་མའི་གྲངས་ཙམ་དུ་སྤེལ་ཏེ། ངས་ཁས་བླངས་པའི་ས་ཐམས་ཅད་ཁྱོད་ཅག་གི་བུ་རྒྱུད་ལ་སྦྱིན་པར་འགྱུར་ཞིང་། ཁོ་རྣམས་ལ་རྟག་ཏུ་གནས་པའི་ནོར་སྐལ་དུ་འཐོབ་པར་ངེས་ཞེས་གསུངས་ཡོད་ཅེས་ཞུས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","དཀོན་མཆོག་ཡ་ཝཱེའི་ཐུགས་འགྱུར་ནས་སྔར་གསུངས་པའི་གནོད་འཚེ་དེ་རང་གི་འབངས་མི་ལ་ཕོག་པར་མ་མཛད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","དེ་ནས་མོ་ཤེ་ཁ་ཕྱིར་འཁོར་ནས་རི་ལས་བབས་ཤིང་། དཔང་པོའི་རྡོ་ལེབ་གཉིས་ལག་ཏུ་ཁྱེར་བ་དང་། དེ་གཉིས་ཀྱི་ངོས་གཉིས་ལ་ཡི་གེ་བྲིས་འདུག་པ་སྟེ་མདུན་རྒྱབ་གཉིས་ལ་ཡི་གེ་བྲིས་ཡོད་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","རྡོ་ལེབ་གཉིས་ནི་དཀོན་མཆོག་གིས་བཟོས་པ་དང་། ཡི་གེ་ནི་དཀོན་མཆོག་གིས་རྡོ་ལེབ་གཉིས་སུ་བརྐོས་ནས་བྲིས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ཡང་ཡོ་ཤུ་ཨ་ཡིས་མི་རྣམས་ཀྱིས་སྐད་རྒྱག་པའི་འུར་ཟིང་ཐོས་ཏེ་མོ་ཤེ་ལ། སྒར་གྱི་ནང་དུ་དམག་འཁྲུག་གི་སྐད་སྒྲ་སྒྲོག་གིན་འདུག་ཅེས་པར། ");
INSERT INTO bodn_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","མོ་ཤེ་ན་རེ། དེ་ནི་གཡུལ་ལས་རྒྱལ་བ་རྣམས་ཀྱི་སྒྲ་མ་ཡིན་ལ་གཡུལ་ལས་ཕམ་པ་རྣམས་ཀྱི་སྒྲ་ཡང་མ་ཡིན་པར། བདག་གིས་ཐོས་པ་མི་རྣམས་ཀྱིས་གླུ་ལེན་གྱིན་པའི་སྒྲ་རེད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","དེ་ནས་མོ་ཤེ་སྒར་དང་ཉེ་བར་སླེབས་ཚེ་བ་ཕྲུག་དེ་དང་ཡང་མི་རྣམས་ཀྱིས་བྲོ་འཁྲབ་པ་མཐོང་ནས། ཁོང་ཁྲོ་རབ་ཏུ་འབར་ཞིང་རྡོ་ལེབ་གཉིས་ལག་ནས་རི་འདབས་སུ་གཡུགས་ཏེ་བཅག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ཡང་དེ་ཚོས་བཟོས་པའི་བ་ཕྲུག་མེར་བསྲེགས་པ་དང་རྡུལ་དུ་བཏགས་ནས་ཆུར་བཏབ་སྟེ། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འཐུང་དུ་བཅུག ");
INSERT INTO bodn_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","དེ་ནས་མོ་ཤེ་ཡིས་ཨ་རོན་ལ། ཁྱོད་ཀྱིས་མི་འདི་རྣམས་ཀྱི་སྟེང་ལ་སྡིག་པ་ཆེན་པོ་དེ་ལྟ་བུ་ཞིག་འདྲེན་པའི་རྒྱུ་མཚན་ཅི། འབངས་ཀྱིས་ཁྱོད་ལ་ཅི་ཞིག་བྱས་སམ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ཨ་རོན་ན་རེ། ང་ཡི་བདག་པོ་ལགས། ཐུགས་རྒྱལ་མི་བཞེངས་པར་ཞུ། འབངས་འདིའི་བློ་ཁ་ངན་པར་ཕྱོགས་ཡོད་པ་ཁྱེད་ཀྱིས་མཁྱེན་གསལ་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","དེ་དག་གིས་ང་ལ་འདི་ལྟར། ངེད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་མཁན་མོ་ཤེ་དེ་ལ་ཅི་ཞིག་བྱུང་བ་མི་ཤེས་པས། ངེད་ཅག་ལ་ལམ་སྣ་འདྲེན་པའི་ལྷ་སྐུ་བཟོས་ཤིག་ཅེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ཡང་ངས་དེ་དག་ལ། སུ་ལ་གསེར་ཡོད་པ་དེ་བླངས་ནས་ཁྱེར་ཤོག་ཅེས་སྨྲས་པ་དང་། ཁོ་ཚོས་ང་རང་ལ་སྤྲད་ཅིང་། ངས་གསེར་རྣམས་མེ་རུ་གཡུགས་ནས་བ་ཕྲུག་འདི་བྱུང་བ་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","མོ་ཤེ་ཡིས་མི་རྣམས་ལང་ཤོར་དུ་སོང་བ་མཐོང་བའི་ཚེ། ཨ་རོན་གྱིས་ཁོ་ཚོ་ལང་ཤོར་དུ་འགྲོ་བར་བཅུག་སྟེ། རང་གི་དགྲ་བོ་དག་གི་གད་མོའི་རྒྱུ་རུ་གྱུར་ཡོད་པས། ");
INSERT INTO bodn_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","མོ་ཤེ་སྒར་གྱི་སྒོ་ཁ་རུ་འགྲེང་སྟེ། སུ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱོགས་བྱེད་པ་དེ་ཚུར་ཤོག་ཅིག་ཅེས་སྨྲས་པ་ན། ལེ་ཝིའི་བུ་རྒྱུད་ཐམས་ཅད་ཁོའི་དྲུང་དུ་འདུས། ");
INSERT INTO bodn_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ཡང་ཁོས་དེ་དག་ལ་འདི་ལྟར། ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། མི་རེ་རེས་རང་གི་རལ་གྲི་རྐེད་ལ་བཏགས་ནས་སྒར་གྱི་སྒོ་འདི་ནས་སྒོ་དེའི་བར་དུ་ཕར་ཚུར་སོང་ལ། མི་རེ་རེས་རང་གི་སྤུན་དང་། རང་གི་གྲོགས་པོ་དང་། རང་གི་ཁྱིམ་མཚེས་སོད་ཅིག་ཅེས་བཀའ་བསྩལ་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ལེ་ཝིའི་བུ་རྒྱུད་རྣམས་ཀྱིས་མོ་ཤེའི་བཀའ་བཞིན་དུ་བྱས་པས། ཉིན་དེར་མི་རྣམས་ལས་མི་སུམ་སྟོང་བསད། ");
INSERT INTO bodn_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ཡང་མོ་ཤེ་ཡིས་དེ་རྣམས་ལ་འདི་ལྟར། མི་རེ་རེས་རང་གི་བུ་དང་སྤུན་ལ་རྒོལ་བས། དེ་རིང་གི་ཉིན་མོ་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་ཁྱོད་ཅག་གིས་རང་ཉིད་དམ་པར་གྱིས། དེ་ནི་ཉིན་འདིར་ཁྱོད་ཅག་ལ་བྱིན་རླབས་གནང་བར་འགྱུར་བའི་ཕྱིར་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","དེའི་ཕྱི་ཉིན་མོ་ཤེ་ཡིས་འབངས་མི་རྣམས་ལ། ཁྱོད་ཅག་གིས་སྡིག་པ་ཚབས་ཆེན་བྱས་པས། ང་རང་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཡར་འགྲོ་བར་བྱ་ཞིང་། ངས་ཁྱོད་ཅག་གི་ཕྱིར་སྡིག་བཤགས་བྱེད་ནུས་ཀྱང་སྲིད་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","མོ་ཤེ་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ལོག་ནས་ན་རེ། ཀྱེ། མི་འདི་རྣམས་ཀྱིས་སྡིག་པ་ཚབས་ཆེན་བྱས་ཏེ། རང་ཉིད་ལ་གསེར་གྱི་ལྷ་སྐུ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ཁྱེད་ཀྱིས་དེ་དག་གི་སྡིག་པ་བསལ་བར་མཛོད། ཅི་སྟེ་མི་བསལ་ན། ཁྱེད་ཀྱིས་ཕྱག་གིས་བྲིས་པའི་གླེགས་བམ་ལས་ངའི་མིང་ཡང་གསུབ་པར་མཛོད་ཅེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ང་ལ་འགལ་བའི་སྡིག་པ་བྱས་པའི་མི་སུ་ཡིན་ཡང་བདག་གིས་དེའི་མིང་ང་ཡི་གླེགས་བམ་ལས་གསུབ་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ད་ལྟ་ལམ་དུ་ཆས་ཏེ་ངས་ཁྱོད་ལ་སྨྲས་པའི་གནས་དེར་མི་རྣམས་འཁྲིད་པར་གྱིས། ལྟོས་དང་། བདག་གི་ཕོ་ཉ་ཁྱོད་ཀྱི་མདུན་དུ་འགྲོ་བར་ངེས། འོན་ཀྱང་ངས་ཉེས་ཆད་གཅོད་པའི་དུས་སུ་དེ་དག་གི་སྡིག་པར་ཉེས་ཆད་བཅད་ཡོང་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","དེ་ནས་མི་རྣམས་ཀྱིས་ཨ་རོན་གྱིས་བཟོས་པའི་བ་ཕྲུག་ལ་བསྙེན་བཀུར་བྱས་པའི་རྐྱེན་གྱིས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་རྣམས་སྲོག་དང་འཕྲལ་བར་མཛད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་རང་དང་ཁྱོད་ཀྱིས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་པའི་མི་རྣམས་ནི་འདི་ནས་ཡར་སོང་དང་། ངས་ཨབ་ར་ཧམ་དང་། ཨི་སཱག་དང་། ཡ་ཀོབ་བཅས་ལ་མནའ་བསྐྱལ་ནས་ཁས་བླངས་མྱོང་བའི་ཡུལ་དུ་འགྲོ་བར་གྱིས། སྔར་ངས་དེ་རྣམས་ལ་འདི་ལྟར། ངས་ཡུལ་དེ་ཁྱོད་ཀྱི་བུ་རྒྱུད་ལ་གནང་བར་བྱ་ཞེས་སྨྲས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ངས་ཁྱོད་ཀྱི་མདུན་དུ་ཕོ་ཉ་ཞིག་གཏོང་བར་ངེས་ཏེ། དེས་ཀ་ན་ཨན་པ་དང་ཨེ་མོར་པ་དང་ཧེད་པ་དང་ཕེ་རེ་ཟི་པ་དང་ཧེ་བི་པ་དང་ཡེ་བུ་སི་པ་རྣམས་སྐྲོད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ཡུལ་གང་ལ་ཞེ་ན། འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་དེ་ལ་འགྲོ་བར་གྱིས། ང་ཁྱོད་རྣམས་དང་མཉམ་དུ་ཡར་འགྲོ་བར་མི་བྱ་སྟེ། ཁྱོད་ཅག་ནི་འབངས་གཉའ་རེངས་ཤིག་ཡིན་པས། ངས་ལམ་བར་དུ་ཁྱོད་ཅག་མེད་པར་བཟོ་ཉེན་ཡོད་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ཡང་མི་རྣམས་ཀྱིས་སེམས་མུག་བྱེད་ཀྱི་གསུང་དེ་ཐོས་པས་མྱ་ངན་བྱས་ཏེ། རྒྱན་ཆ་བཏགས་པ་མི་གཅིག་ཀྱང་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ཅི་ཡིན་ཞེ་ན། སྔར་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་སྐད་སྨྲོས་ཤིག ཁྱོད་ཅག་ནི་འབངས་གཉའ་རེངས་ཡིན་པས་ང་རང་སྐད་ཅིག་ཙམ་ལ་ཁྱོད་ཅག་གི་དཀྱིལ་དུ་ཡོང་ནའང་། བདག་གིས་ཁྱོད་ཅག་མེད་པར་བཟོ་ཉེན་ཡོད། དེའི་ཕྱིར་ཁྱོད་ཅག་གིས་རྒྱན་ཆ་འཕུད་དང་། ངས་ཁྱོད་ཅག་ལ་ཅི་བྱེད་དགོས་པ་ཤེས་པར་འགྱུར་ཞེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ཡེས་ར་ཨེལ་པ་རྣམས་རི་བོ་ཧོ་རེབ་ནས་བུད་པའི་ཚུན་ལ་རྒྱན་ཆ་རྣམས་རྩ་བ་ནས་བླངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ཡང་མོ་ཤེ་ཡིས་རྒྱུན་སྲོལ་བཞིན་སྦྲ་ཞིག་ཁྱེར་ནས་སྒར་གྱི་ཕྱི་རོལ་ཏུ་རྒྱང་ཐག་ཅུང་རིང་བའི་སར་ཕུབ་པ་དང་། དེ་ལ་མཇལ་འཕྲད་གུར་མཆོག་ཅེས་མིང་བཏགས། དཀོན་མཆོག་ཡ་ཝཱེ་དང་མཇལ་བར་དགའ་བའི་མི་རྣམས་རྟག་ཏུ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཡོད་པའི་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","མོ་ཤེ་ནམ་ཡང་གུར་མཆོག་ཏུ་འགྲོ་བའི་ཚེ་མི་ཐམས་ཅད་རང་རང་གུར་གྱི་སྒོ་ཁར་ལངས་ནས་མོ་ཤེ་ནང་དུ་ཕྱིན་པའི་བར་དུ་སྡོད་པར་བྱེད། ");
INSERT INTO bodn_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ཡང་ནམ་ཞིག་མོ་ཤེ་གུར་ནང་དུ་སོང་ཚེ་སྤྲིན་གྱི་ཀ་བ་འབབ་ཅིང་གུར་གྱི་སྒོ་ཁར་འགྲེང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གསུང་གླེང་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","མི་ཀུན་གྱིས་དོན་དེ་མཐོང་བ་ན། མི་ཐམས་ཅད་འགྲེང་ཞིང་རེ་རེས་རང་རང་གུར་གྱི་སྒོ་འགྲམ་ནས་གུས་ཕྱག་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","དེ་ལྟར་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་ཁ་རི་ཁ་ཐུག་ཏུ་གསུང་གླེང་མཛད་ཅིང་། གྲོགས་པོས་གྲོགས་པོ་ལ་གླེང་མོལ་བྱེད་པ་བཞིན་ཡིན། ཡང་ནམ་ཞིག་མོ་ཤེ་སྒར་ལ་ཕྱིར་ལོག་ཚེ། དེའི་གཞོན་ནུ་ཞབས་ཕྱི་སྟེ་ནུན་ཞེས་པའི་བུ་ཡོ་ཤུ་ཨ་གཅིག་པུ་གུར་དང་མ་བྲལ་བར་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ཡང་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ། གཟིགས་པར་ཞུ། ཁྱེད་ཀྱིས་ང་ལ་མི་འདི་རྣམས་ཡར་ཁྲིད་ཅིག་ཅེས་གསུངས་ཀྱང༌། ཁྱེད་ཀྱིས་སུ་ཞིག་ང་དང་མཉམ་དུ་འགྲོ་བར་མངག་རྒྱུ་ཡིན་པ་བདག་ལ་མ་གསུངས་ཤིང་། ཡང་སྔར་ནས་འདི་སྐད་དུ། ངས་ཁྱོད་ཀྱི་མིང་ནས་ཁྱོད་ངོ་ཤེས་ཤིང་བདག་གི་མིག་ལམ་ནས་ཁྱོད་ལ་སྙིང་རྗེ་ཐོབ་པ་ཡིན་ཞེས་གསུངས་མྱོང་བས། ");
INSERT INTO bodn_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","གལ་ཏེ་ཁྱེད་ཀྱི་སྤྱན་སྔར་ང་ལ་ཐུགས་རྗེ་ཐོབ་པ་ཡིན་ན། བདག་ལ་ཁྱེད་ཀྱི་ལམ་སྟོན་པར་མཛོད། དེ་ལྟར་མཛད་ན་ངས་ཁྱེད་རང་ངོ་ཤེས་ཤིང་ཁྱེད་ཀྱི་སྤྱན་སྔར་ཐུགས་རྗེ་འཐོབ་ངེས་ཡིན་ལ། ཡང་མི་རིགས་འདི་ནི་ཁྱེད་ཀྱི་འབངས་མི་ཡིན་པར་གཟིགས་སུ་གསོལ་ཞེས་ཞུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ཁོང་གིས་འདི་སྐད་དུ། ང་རང་དངོས་སུ་ཁྱོད་དང་མཉམ་དུ་འགྲོ་ཞིང་ཁྱོད་ལ་ངལ་གསོ་སྟེར་བར་བྱ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ཡང་མོ་ཤེ་ཡིས་ཁོང་ལ་འདི་ལྟར། གལ་ཏེ་ཁྱེད་ཉིད་དངོས་སུ་ང་ཚོ་དང་ལྷན་དུ་མི་ཕེབས་ན། ངེད་རྣམས་འདི་ནས་ཡར་ལའང་མི་འཁྲིད་རོགས། ");
INSERT INTO bodn_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ཁྱེད་རང་ངེད་རྣམས་དང་ལྷན་དུ་ཕེབས་ན་མ་གཏོགས། བདག་དང་ཁྱེད་ཀྱི་འབངས་མི་དང་བཅས་པ་ལ་ཁྱེད་ཀྱི་སྤྱན་སྔར་ཐུགས་རྗེ་ཐོབ་པ་ནི་མི་གཞན་དག་གིས་ཅི་ལྟར་ཤེས་ཐུབ་བམ། དེ་ལྟར་ལྷན་དུ་ཕེབས་པ་ན། ད་གཟོད་ས་སྟེང་གི་མི་ཐམས་ཅད་དང་ང་རང་ཐེ་བའི་ཁྱེད་ཀྱི་འབངས་མི་ལ་ཁྱད་པར་ཡོད་པ་ཤེས་པར་འགྱུར་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། བདག་གི་མིག་ལམ་ནས་ཁྱོད་ལ་སྙིང་རྗེ་ཐོབ་ཅིང་ངས་ཁྱོད་ཀྱི་མིང་ནས་ཁྱོད་ངོ་ཤེས་པས། ང་རང་ལ་ཞུས་པ་བཞིན་དུ་བདག་གིས་ཀྱང་བྱེད་པར་འགྱུར་ཞེས་གསུངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","མོ་ཤེ་ཡིས། ཁྱེད་ཀྱི་གཟི་བརྗིད་ང་ལ་སྟོན་པར་མཛོད་ཅེས་ཞུས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ཁོང་གིས་འདི་སྐད་དུ། བདག་གིས་རང་གི་དྲིན་ཐམས་ཅད་ཁྱོད་ཀྱི་མདུན་དུ་འགྲོ་བར་འཇུག་ཅིང་དཀོན་མཆོག་ཡ་ཝཱེའི་མིང་ཡང་སྒྲོག་པར་བྱ། ངས་སུ་ཞིག་ལ་བརྩེ་བར་བསམ་ན་དེ་ལ་བརྩེ་བར་བྱ། ཡང་སུ་ཞིག་ལ་སྙིང་རྗེ་བར་འདོད་ན་དེ་ལ་སྙིང་རྗེ་བར༌བྱ་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ཡང་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་བདག་གི་གདོང་ནི་མཐོང་མི་རུང་སྟེ། ཅིའི་ཕྱིར་ཞེ་ན། བདག་གི་གདོང་མཐོང་བའི་མི་སུ་ཡིན་ཡང་གསོན་པོར་འདུག་མི་ཐུབ་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ལྟོས་དང་། ངའི་དྲུང་དུ་གནས་ཤིག་ཡོད་དེ། ཁྱོད་རང་བྲག་དེའི་སྟེང་ལ་འགྲེང་བར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ངའི་གཟི་བརྗིད་ཁྱོད་ཀྱི་མདུན་དུ་ཕར་འགྲོ་བའི་ཚེ། བདག་གིས་ཁྱོད་རང་བྲག་སྲུབས་ཤིག་ཏུ་བཞག་སྟེ། ང་རང་ཕར་བཞུད་པའི་བར་དུ་ངའི་ལག་པས་ཁྱོད་རང་འགེབ་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","དེའི་རྗེས་སུ་ངས་རང་གི་ལག་པ་ཕྱིར་འཐེན་ཚེ་ཁྱོད་ཀྱིས་ངའི་རྒྱབ་མཐོང་བར་འགྱུར་ནའང་། གདོང་ནི་གཏན་ནས་མཐོང་བར་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་རང་ལ་སྔར་གྱི་རྡོ་ལེབ་དང་འདྲ་བ་གཉིས་བརྐོས་དང་། དེ་སྔོན་བཅག་པའི་རྡོ་ལེབ་སྟེང་གི་ཚིག་རྣམས་བདག་གིས་རྡོ་ལེབ་འདི་གཉིས་ལ་བརྐོ་བར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","སང་ཉིན་ཐོ་རངས་ཁྱོད་ཀྱིས་སྟ་གོན་བྱས་ཏེ་རི་བོ་སི་ནཱ་རུ་ཡར་ཡོང་སྟེ་རི་རྩེ་ནས་ངའི་དྲུང་དུ་འགྲེང་བར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ཁྱོད་དང་མཉམ་དུ་མི་སུ་ཡང་ཡོང་མི་རུང་ལ། རི་དེ་ཡོངས་ལ་མི་སུ་ཡང་ཡོད་མི་རུང་ཞིང་། རི་དེའི་འདབས་སུ་ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་གང་ཡང་འཚོ་མི་རུང་ཞེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","མོ་ཤེ་ཡིས་སྔར་གྱི་རྡོ་ལེབ་གཉིས་དང་འདྲ་བ་བཟོས་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་བསྩལ་པ་བཞིན་དུ་ཐོ་རངས་ཡར་ལངས་ཏེ་རི་བོ་སི་ནཱ་རུ་འགོས་ཤིང་། ལག་ཏུ་རྡོ་ལེབ་གཉིས་ཁྱེར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","དེར་དཀོན་མཆོག་ཡ་ཝཱེ་སྤྲིན་གྱི་ནང་ནས་མར་ཕེབས་ཤིང་། མོ་ཤེ་དང་ལྷན་དུ་འགྲེང་ནས་རང་གི་མཚན་ཡ་ཝཱེ་སྒྲོག་པར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","དཀོན་མཆོག་ཡ་ཝཱེ་དེའི་མདུན་ནས་ཕར་ཕེབས་པ་དང་འདི་སྐད་དུ། ཡ་ཝཱེ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེ་ནི་སྙིང་རྗེ་ཆེ་ཞིང་ཐུགས་རྗེ་ཅན་ཡིན་ལ། རང་དགར་ཐུགས་མི་ཁྲོ་ཞིང་བྱམས་བརྩེ་དང་བདེན་པ་ཉིད་རྫོགས་མཐའ་མེད་པ་ལགས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","མི་ཁྲི་ཁྲི་འབུམ་འབུམ་ལ་ཐུགས་བརྩེ་བར་བྱེད་ཅིང་ཉེས་པ་དང་ནོར་འཁྲུལ་དང་སྡིག་པ་རྣམས་བསལ་ཞིང་། ཉེས་ཅན་རྣམས་རྩ་བ་ནས་ཉེས་མེད་དུ་མི་བརྩི་ཞིང་། ཕ་རྣམས་ཀྱི་ནག་ཉེས་ཕྱིར་བུ་དང་བུའི་བུ་རྣམས་ལ་མི་རབས་གསུམ་བཞིའི་བར་དུ་ཉེས་ཆད་གཅོད་པ་ལགས་ཞེས་བསྒྲགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","དེ་ནས་མོ་ཤེ་ཡིས་མྱུར་དུ་ལུས་སར་བཏུད་ནས་ཕྱག་བཙལ་ཏེ་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ཀྱེ་གཙོ་བོ་ལགས། ང་རང་ལ་ཁྱེད་ཀྱི་སྤྱན་སྔར་ཐུགས་རྗེ་ཐོབ་པ་ཡིན་ན། ཁྱེད་རང་ང་ཚོ་དང་ལྷན་དུ་འགྲོགས་ནས་ཕེབས་སུ་གསོལ། མི་དེ་རྣམས་གཉའ་རེངས་ཡིན་ཡང་། ངེད་ཅག་གི་ཉེས་པ་དང་སྡིག་པ་སེལ་བ་དང་། ངེད་རྣམས་ནི་ཁྱེད་ཀྱི་ནོར་སྐལ་དུ་དགོངས་པར་མཛོད་ཅེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ལྟོས་དང་། བདག་གིས་ཞལ་ཆད་ཅིག་འཇོག་སྟེ། ཁྱོད་ཀྱི་མི་ཐམས་ཅད་ཀྱི་མཐོང་ལམ་དུ་ངས་དོན་ངོ་མཚར་དག་བྱེད་པར་འགྱུར་བ་ནི་ས་གཞི་ཀུན་དང་མི་རིགས་གང་ལའང་བྱས་མ་མྱོང་ཞིང་། ཁྱོད་ཀྱི་མཐའ་འཁོར་དུ་ཡོད་པའི་མི་ཐམས་ཅད་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་མཛད་པ་མཐོང་བར་འགྱུར་ལ། བདག་གིས་ཁྱོད་ལ་སྟོན་པར་འགྱུར་བའི་དོན་དེ་དག་དངོས་གནས་འཇིགས་སུ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ངས་དེ་རིང་གི་ཉིན་མོར་ཁྱོད་ཅག་ལ་བསྒོས་དང་སྒོ་བཞིན་པ་འདི་བསྲུང་དགོས་ཏེ། ལྟོས་དང་། བདག་གིས་ཁྱོད་ཅག་གི་མདུན་ནས་ཨེ་མོར་པ་དང་། ཀ་ན་ཨན་པ་དང་། ཧེད་པ་དང་། ཕེ་རེ་ཟི་པ་དང་། ཧེ་བི་པ་དང་། ཡེ་བུ་སི་པ་རྣམས་སྐྲོད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ཁྱོད་ཅག་འགྲོ་བྱའི་ཡུལ་དེའི་མི་རྣམས་ནི་ཁྱོད་ཅག་གི་ཁྲོད་དུ་རྙི་རུ་འགྱུར་ཉེན་ཡོད་པས། དེ་དག་དང་ཁ་ཆད་འཇོག་པ་ལས་གཡོལ་བར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","དེ་ལས་ལྡོག་སྟེ་ཁྱོད་ཅག་གིས་དེ་དག་གི་མཆོད་ཁྲི་རྣམས་བཤིག་པར་བྱའོ། །ཡང་དེ་ཚོའི་རྡོ་སྐུ་རྣམས་ཀྱང་རྩ་མེད་གཏོང་བར་གྱིས། ལྷ་མོ་ཨ་ཤེ་རཱའི་སྐུ་བརྙན་རྣམས་རྩ་བ་ནས་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་གི་མཚན་ནི་ཕྲག་དོག་ཅན་ཡིན་ཏེ། ཐུགས་ཀྱང་ཕྲག་དོག་ཅན་ལགས་པས། ལྷ་རྣམས་ལ་ཕྱག་མ་འཚལ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","དེ་ལྟར་མ་བྱས་ན། ཁྱོད་ཅག་གིས་གནས་དེའི་ཡུལ་མི་དང་ཁ་ཆད་འཇོག་ཉེན་ཡོད་དེ། མི་དེ་དག་གིས་རང་གི་ལྷ་རྣམས་ཀྱི་རྗེས་སུ་ལོག་གཡེམ་བྱེད་པ་དང་། རང་གི་ལྷ་རྣམས་ལ་དམར་མཆོད་འབུལ་བའི་སྐབས་སུ་ཁྱོད་ཅག་མགྲོན་དུ་འབོད་ཅིང་། ཁྱོད་ཅག་གིས་དེ་དག་གི་མཆོད་རྫས་བཟའ་བར་བྱེད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ཁྱོད་ཅག་གི་བུ་རྣམས་ལ་དེ་དག་གི་བུ་མོ་རྣམས་ལས་བག་མ་བླངས་ན། དེ་དག་གི་བུ་མོ་རྣམས་ཀྱིས་རང་གི་ལྷ་རྣམས་ཀྱི་རྗེས་སུ་ལོག་གཡེམ་བྱེད་ཅིང་ཁྱོད་ཅག་གི་བུ་རྣམས་ལའང་དེ་དག་གི་ལྷ་རྣམས་ཀྱི་རྗེས་སུ་ལོག་གཡེམ་བྱེད་དུ་འཇུག་སྲིད་པ་ཡིན་པས་གཟབ་གཟབ་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ཁྱོད་ཅག་གིས་རང་གི་ཕྱིར་བླུགས་སྐུ་བཟོ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","ཡང་སྐྱུར་མེད་བག་ལེབ་ཀྱི་དུས་ཆེན་བསྲུང་དགོས་ཏེ། ཁྱོད་ཅག་ཨ་རྦིབ་ཟླ་བའི་ནང་དུ་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཐོན་པའི་ཕྱིར་ཨ་རྦིབ་ཟླ་བའི་དུས་དེར་སླེབས་ཚེ། ངས་ཁྱོད་ཅག་ལ་བསྒོས་པའི་བཀའ་བཞིན་དུ་ཉིན་བདུན་གྱི་རིང་ལ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ད་དུང་མངལ་ལས་བྱུང་བའི་སྐྱེས་འགོ་ཐམས་ཅད་བདག་གི་ཡིན། ཁྱོད་རྣམས་ཀྱི་ཕྱུགས་ཁྱུ་ཁྲོད་ཀྱི་བ་གླང་དང་ལུག་གང་ཡིན་ཡང་སྐྱེས་འགོ་ཕོ་ཡིན་པ་མཐའ་དག་བདག་གི་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","བོང་བུའི་བོང་ཕྲུག་འགོ་མ་ནི་ལུ་གུ་ཞིག་གིས་བླུ་དགོས། ཅི་སྟེ་བླུ་བར་མ་བྱས་ན་དེའི་སྐེ་ཚིགས་རྫོག་པར་བྱའོ། །ཁྱོད་ཅག་གི་བུ་སྐྱེས་འགོ་ཐམས་ཅད་བླུ་དགོས་ལ། སུ་ཡིན་ཡང་ལག་པ་སྟོང་བར་ངའི་མདུན་དུ་ཡོང་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ཉིན་དྲུག་གི་རིང་དུ་ལས་ཀ་བྱོས་ལ་ཉིན་བདུན་པར་ངལ་གསོ་བར་གྱིས། སྟོན་ལས་དང་རྨོ་འདེབས་ཀྱི་སྐབས་སུའང་ངལ་གསོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","གྲོ་ཡི་ཐོག་ཕུད་བསྡུ་བའི་སྐབས་སུ་བདུན་ཕྲག་རྣམས་ཀྱི་དུས་ཆེན་བསྲུང་དགོས་ལ། ལོ་མཇུག་གི་བསྡུ་ཉར་དུས་ཆེན་ཡང་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ཁྱོད་ཅག་གི་སྐྱེས་པ་ཐམས་ཅད་ཀྱིས་གཙོ་བོ་ཡ་ཝཱེ་སྟེ་ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་ལོ་རེར་ཐེངས་གསུམ་ལ་མཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","བདག་གིས་ཁྱོད་ཅག་གི་མདུན་ནས་མི་རིགས་གཞན་རྣམས་བསྐྲད་ནས་ཁྱོད་ཅག་གི་མཐའ་མཚམས་རྒྱས་པར་བྱེད་པས། ཁྱོད་རྣམས་རང་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ལོ་རེ་བཞིན་ལན་གསུམ་དུ་འོང་བའི་སྐབས་སུ། མི་སུས་ཀྱང་ཁྱོད་ཅག་ལ་གཏོགས་པའི་ཡུལ་དེ་ཧམ་འཕྲོག་བྱེད་པར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","བདག་ལ་དམར་མཆོད་ཀྱི་ཁྲག་དང་སྐྱུར་རྩི་ལྡན་པའི་བག་ལེབ་གཉིས་ལྷན་དུ་འབུལ་མི་རུང་ལ། པེ་སག་དུས་ཆེན་གྱི་མཆོད་པའང་ཕྱི་ཉིན་ཞོགས་པའི་བར་དུ་བསྐྱུར་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ཁྱོད་ཅག་གིས་ས་ཞིང་ལས་ཐོག་མར་སྨིན་པའི་ལོ་ཏོག་གི་ཕུད་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་བཞུགས་གནས་སུ་འབུལ་དགོས་ལ། རེའུ་ཞིག་དེའི་ཨ་མའི་འོ་མ་ནང་དུ་བཙོ་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཚིག་དེ་རྣམས་ཡི་གེར་ཁོད་ཅིག རྒྱུ་མཚན་ནི། བདག་གིས་བཀའ་འདི་ལ་བརྟེན་ནས་ཁྱོད་དང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་བར་ལ་ཞལ་ཆད་བཞག་པ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","མོ་ཤེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཉིན་མཚན་བཞི་བཅུའི་རིང་དུ་གནས་ཤིང་ཟས་ཀྱང་མ་སྤྱད་ལ་སྐོམ་ཡང་མ་འཐུང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཞལ་ཆད་ཀྱི་བཀའ་བཅུ་པོ་རྡོ་ལེབ་གཉིས་ལ་ཡི་གེར་བཀོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ཡང་མོ་ཤེ་རི་བོ་སི་ནཱ་ལས་འབབ་པའི་ཚེ། ཁོའི་ལག་ཏུ་དཔང་པོའི་རྡོ་ལེབ་གཉིས་ཡོད་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་གསུང་གླེང་མཛད་པའི་རྐྱེན་གྱིས་ཁོའི་ངོ་གདོང་ལས་འོད་བཀྱེ་བ་མོ་ཤེ་རང་ཉིད་ཀྱིས་ཀྱང་ཤེས་མེད། ");
INSERT INTO bodn_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ཨ་རོན་དང་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཀྱིས་མོ་ཤེ་ལ་བལྟས་པ་ན། ཀྱེ་ཧོ། ཁོའི་ངོ་གདོང་ལས་འོད་བཀྱེ་བ་མཐོང་བས་དེ་དང་ཉེ་བར་བཅར་མ་ཕོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","དེ་ནས་མོ་ཤེ་ཡིས་དེ་དག་བོས་ཤིང་། ཨ་རོན་དང་ཚོགས་དཔོན་ཐམས་ཅད་ཁོའི་ཕྱོགས་སུ་འོངས་པ་དང་། མོ་ཤེ་ཡིས་དེ་དག་ལ་གཏམ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","དེའི་རྗེས་སུ་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཚུཪ་འོངས་པ་ལ། ཁོས་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱ་ལས་རང་ལ་ཅི་གསུངས་པ་ཐམས་ཅད་དེ་དག་ལ་ཇི་བཞིན་དུ་བསྒོས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ཡང་མོ་ཤེ་ཡིས་གཏམ་སྨྲས་ཚར་བ་དང་རང་གི་ངོ་གདོང་ལག་རས་ཤིག་གིས་བཀབ། ");
INSERT INTO bodn_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","འོན་ཀྱང་ཁོ་རང་ནམ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཞུ་གླེང་བྱེད་དུ་ནང་ལ་སོང་བའི་ཚེ། ཕྱིར་མ་ཐོན་བར་དུ་རང་གི་གདོང་གི་ལག་རས་བླངས་ཤིང་། རྗེས་སུ་ཡང་ཕྱི་རུ་ཐོན་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་བཀའ་གནང་བ་བཞིན་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གཏམ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མོ་ཤེའི་ངོ་གདོང་ལས་འོད་བཀྱེ་བ་མཐོང་ཞིང་། ཁོས་ཡང་ལག་རས་ཀྱིས་རང་གི་ངོ་གདོང་བཀབ་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞུ་གླེང་བྱེད་པའི་ཕྱིར་ནང་དུ་མ་སོང་བར་དུ་དེ་ལྟར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ཡང་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་བསྡུས་ནས་དེ་དག་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་སྟེ་ཁྱོད་ཅག་གིས་བསྒྲུབ་དགོས་པ་རྣམས་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ཉིན་དྲུག་གི་རིང་ལ་ལས་ཀ་བྱེད་ཅིང་ཉིན་བདུན་པ་ནི་ཁྱོད་ཚོར་མཚོན་ན་དམ་པ་ཡིན་དགོས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡང་ཡིན། ཉིན་དེ་ལ་ལས་ཀ་བྱེད་པའི་མི་སུ་ཡིན་ཡང་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ངལ་གསོ་བའི་ཉིན་ལ་ཁྱོད་ཅག་གི་སྡོད་གནས་རྣམས་སུ་མེ་སྦར་མི་རུང་ཞེས་བཀའ་གནང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ཡང་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ལ་འདི་ལྟར། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་གནང་བ་འདི་ཡིན་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ཁྱོད་ཅག་གིས་རང་གི་ཁྲོད་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་རྣམས་ལོངས་ཤིག འབུལ་འདོད་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་འདི་ཕུལ་ཞིག དེ་ནི་གསེར་དང་དངུལ་དང་ལི་བཅས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་དང་། སོ་རས་སྲབ་བུ་དང་། ར་མའི་ཁུལ་རྩིད་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ལུག་ཐུག་གི་པགས་པ་རྒྱ་ཚོས་བརྒྱབ་པ་དང་ཀོ་བ་སྤུས་ལེགས་དང་སེང་ལྡེང་ཤིང་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","སྒྲོན་མེའི་ཕྱིར་འཚིར་སྣུམ་དང་། འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་ཀྱི་ཕྱིར་བསུང་རྫས་རྣམས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","གཟི་དང་རིན་པོ་ཆེ་གཞན་དག་དགོས་པ་སྟེ། མཆོད་དཔོན་གྱི་བེར་ཐུལ་དང་བྲང་རྒྱན་ལ་ཕྲ་རྒྱག་དགོས་པའི་ཕྱིར་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ཁྱོད་ཅག་གི་ཁྲོད་དུ་སེམས་སུ་ཤེས་རབ་ལྡན་པ་ཐམས་ཅད་འོངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཅི་བསྩལ་པ་ཐམས་ཅད་བསྒྲུབ་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","གུར་མཆོག་དང་དེའི་གུར་ཀླད་དང་ཐོག་ཁེབས་དང་ཀྱུ་དང་པང་ལེབ་དང་འཕྲེད་རྒྱུག་དང་ཀ་བ་དང་ཞབས་ར་བཅས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ཤུར་སྒམ་དང་དེའི་རྒྱུག་པ་དང་ཐུགས་རྗེའི་བཞུགས་ཁྲི་དང་དེའི་གཡོག་བྱེད་ཀྱི་ཡོལ་བ་བཅས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","སྒྲོག་ཙེ་དང་དེའི་རྒྱུག་པ་དང་དེ་ལ་གཏོགས་པའི་ཡོ་བྱད་རྣམས་དང་། སྤྱན་བསྟར་བག་ལེབ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","འོད་ཀྱི་ཕྱིར་ཡིན་པའི་སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་རྣམས་དང་སྒྲོན་མེ་རྣམས་དང་ཡང་སྒྲོན་མེའི་ཕྱིར་འཚིར་སྣུམ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","སྤོས་ཁྲི་དང༌། དེའི་རྒྱུག་པ་གཉིས་བཅས་པ་དང་། འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་དང་། གུར་མཆོག་གི་སྒོའི་ཕྱིར་དུ་སྒོ་ཡོལ་དང༌། ");
INSERT INTO bodn_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་དང་དེ་ལ་གཏོགས་པའི་ལི་ཡི་ཐག་མིག་དང་དེའི་རྒྱུག་པ་གཉིས་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་དེའི་ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ཁྱམས་རའི་ཡོལ་བ་དང་དེའི་ཀ་བ་དང་དེའི་ཞབས་ར་རྣམས་དང༌། ཁྱམས་རའི་སྒོ་ཡོལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","གུར་མཆོག་གི་ཕུར་བ་དང་ཁྱམས་ཀྱི་ཕུར་བ་དང་དེའི་ཆོན་ཐག་རྣམས་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","གནས་དམ་པར་ཞབས་ཕྱི་བྱེད་པའི་ཆེད་དུ་ཐགས་ཞིབ་མོར་བཏགས་པའི་གོས་རྣམས་དང་། མཆོད་དཔོན་ཨ་རོན་གྱི་ན་བཟའ་དམ་པ་རྣམས་དང་། ཁོའི་བུ་རྣམས་ཀྱིས་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་ན་བཟའ་རྣམས་བཟོ་དགོས་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་མོ་ཤེའི་དྲུང་ནས་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","སེམས་འགུལ་ཐེབས་ནས་འབུལ་འདོད་ཡོད་པ་ཐམས་ཅད་ཚུར་འོངས་ཏེ། མཇལ་འཕྲད་གུར་མཆོག་གི་ལས་དང་དེ་རུ་ཡོད་པའི་ཞབས་འདེགས་དང་ན་བཟའ་དམ་པ་རྣམས་ཀྱི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་རྣམས་ཁྱེར་འོངས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ཡང་སེམས་ནས་འབུལ་འདོད་ཡོད་པའི་སྐྱེས་པ་དང་བུད་མེད་རྣམས་ཀྱིས་བྲང་རྒྱན་དང་རྣ་ལོང་རྣམས་དང་། སོར་གདུབ་ཐམ་ག་ཅན་དང་ལག་གདུབ་བཅས་གསེར་གྱི་རྫས་སྣ་ཚོགས་ཁྱེར་འོངས་ཤིང་། མི་ཀུན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསེར་གཡོབ་མཆོད་དུ་ཕུལ་བ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་དང་། སོ་རས་སྲབ་བུ་དང་། ར་མའི་ཁུལ་རྩིད་དང་། ལུག་ཐུག་གི་པགས་པ་རྒྱ་ཚོས་བརྒྱབ་པ་དང་ཀོ་བ་སྤུས་ལེགས་བཅས་སུ་ལ་ཡོད་པ་དེས་ཁྱེར་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","སུས་ཀྱང་དངུལ་དང་ལི་ཡི་འབུལ་བ་འབུལ་མཁན་ཐམས་ཅད་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་བཞིན་ཁྱེར་འོངས་པ་དང་། ཞབས་འདེགས་ཀྱི་ལས་སྣ་ཚོགས་ཀྱི་ཕྱིར་སེང་ལྡེང་ཤིང་ཡོད་པ་ཐམས་ཅད་ཀྱིས་ཀྱང་དེ་ཁྱེར་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ཡང་བུད་མེད་ཤེས་རབ་ལྡན་པ་རྣམས་ཀྱིས་རང་གི་ལག་པས་བཀལ་བའི་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་དང་སོ་རས་སྲབ་བུ་བཅས་ཁྱེར་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","སེམས་འགུལ་ཐེབས་ཤིང་སེམས་སུ་ཤེས་རབ་ལྡན་པའི་བུད་མེད་རྣམས་ཀྱིས་སོ་སོའི་ལག་རྩལ་ལ་བརྟེན་ནས་ར་རྩིད་འཁེལ། ");
INSERT INTO bodn_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ཡང་དཔོན་རིགས་རྣམས་ཀྱིས་མཆོད་དཔོན་གྱི་བེར་ཐུལ་དང་བྲང་རྒྱན་གྱི་ཕྱིར་གཟི་དང་རིན་པོ་ཆེ་དག་ཕྲ་རྒྱག་པར་ཁྱེར་འོངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","བསུང་རྫས་དང་འཚིར་སྣུམ་ནི་སྒྲོན་མེ་དང་འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་ཀྱི་ཕྱིར་ཁྱེར་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྒྲུབ་དགོས་པར་བཀའ་གནང་བའི་ལས་ཐམས་ཅད་ཀྱི་ཕྱིར། སེམས་སུ་འབུལ་འདོད་ཡོད་པའི་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་སྐྱེས་པ་དང་བུད་མེད་རེ་རེས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཡིད་མོས་འབུལ་བ་རྣམས་ཁྱེར་འོངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར། ལྟོས་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཡ་ཧུ་དཱ་ཚོ་པ་ནས་ཧུ་རཱའི་བུ་ཨོའུ་རེལ་དེའི་བུ་པི་ཟིད་ཨེལ་གྱི་མིང་ནས་བོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ཡང་ཁོ་ལ་དཀོན་མཆོག་གི་ཐུགས་ཉིད་ཀྱིས་ཁྱབ་པར་མཛད་དེ། ཁོ་ལ་ཤེས་རབ་དང་སྤྱང་གྲུང་ལྡན་ཞིང་། བློ་རིག་མངའ་བ་དང་། ལག་རྩལ་སྣ་ཚོགས་བྱང་ཆུབ་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","དེ་ནི་ལག་རྩལ་གྱི་ལས་རྣམས་ཇུས་འགོད་བྱེད་པར་དམིགས་ཏེ། གསེར་དངུལ་ལི་གསུམ་གྱི་མགར་བྱེད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","རིན་པོ་ཆེ་དག་བརྐོ་གཏུབ་བྱེད་པ་དང་ཕྲ་རྒྱག་པ། ཤིང་བརྐོ་བ། ལག་རྩལ་གྱི་ལས་སྣ་ཚོགས་བྱེད་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ཡང་པི་ཟིད་ཨེལ་དང་དཱན་གྱི་ཚོ་པ་ནས་ཨ་ཧི་སཱ་མག་གི་བུ་ཨོ་ཧོ་ལི་ཨབ་གཉིས་ཀ་ལ་མི་གཞན་པར་སློབ་སྟོན་བྱེད་པའི་སེམས་གནང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ཁོ་གཉིས་ཀྱིས་བརྐོ་བཟོ་དང་ཇུས་འགོད་བྱེད་པ་དང་། ཡང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་དང་། སོ་རས་སྲབ་བུའི་འཚེམ་དྲུབས་བྱེད་པ་དང་། ཐགས་འཐག་པ་དང་། ལས་ཀུན་བྱེད་ཅིང་ཇུས་འགོད་བྱེད་པའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེས་དེ་གཉིས་ཀྱི་སེམས་ལ་རྩལ་གྱིས་ཁྱབ་པར་མཛད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ཡང་མོ་ཤེ་ཡིས་འདི་ལྟར། གནས་མཆོག་བཟོ་བའི་ལས་ཐམས་ཅད་ཇི་ལྟར་བསྒྲུབ་ཤེས་པའི་ཕྱིར། པི་ཟིད་ཨེལ་དང་ཨོ་ཧོ་ལི་ཨབ་དང་མི་ལག་རྩལ་ཅན་ཀུན་ལའང་དཀོན་མཆོག་ཡ་ཝཱེས་ཤེས་རབ་དང་བློ་རིག་གནང་བ་དེ་དག་གིས། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་བསྩལ་པ་མཐའ་དག་བཞིན་དུ་བྱེད་དགོས་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","དེ་ནས་མོ་ཤེ་ཡིས་པི་ཟིད་ཨེལ་དང་ཨོ་ཧོ་ལི་ཨབ་དང་། སེམས་སུ་ཤེས་རབ་ལྡན་པ་སྟེ་དཀོན་མཆོག་ཡ་ཝཱེས་ཤེས་རབ་སེམས་སུ་གནང་བའི་མི་དང་། སེམས་འགུལ་ཐེབས་ནས་ལས་བསྒྲུབ་པར་འོང་འདོད་པ་ཐམས་ཅད་ཚུར་བོས་ནས། ");
INSERT INTO bodn_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","གནས་མཆོག་བཟོ་བར་བྱེད་པའི་ལས་རྣམས་ཀྱི་དོན་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཕུལ་བའི་འབུལ་བ་ཐམས་ཅད་ཁོ་ཚོས་མོ་ཤེ་ནས་བླངས་ཤིང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཞོགས་པ་རེར་ད་དུང་ཡིད་མོས་ཀྱི་འབུལ་བ་ཁྱེར་འོངས་པས། ");
INSERT INTO bodn_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","གནས་མཆོག་གི་ལས་ཐམས་ཅད་བྱེད་པའི་མི་ལག་རྩལ་ཅན་རེ་རེས་རང་རང་གི་ལས་ཀ་བྱེད་མཚམས་བཞག་སྟེ་འོངས་ནས། ");
INSERT INTO bodn_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","མོ་ཤེ་ལ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་བསྒྲུབ་དགོས་གསུངས་པའི་ལས་ཀྱི་ཕྱིར་མི་རྣམས་ཀྱིས་ཁྱེར་འོངས་པའི་དངོས་པོ་ལྷག་མ་མང་པོ་ཡོད་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","དེའི་ཕྱིར་མོ་ཤེ་ཡིས་བཀའ་བསྒོས་ནས་སྒར་ཡོངས་སུ་འདི་ལྟར། ད་ལྟ་སྐྱེས་པ་དང་བུད་མེད་སུ་ཡིན་ཡང་གནས་མཆོག་གི་ཕྱིར་འབུལ་བ་གང་ཡང་འབུལ་བར་མི་བྱའོ་ཞེས་བསྒྲགས་པས། དེ་ལྟར་འབངས་མི་ལ་འབུལ་དུ་མ་བཅུག ");
INSERT INTO bodn_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ལས་ཐམས་ཅད་བསྒྲུབ་དགོས་པའི་རྫས་རྣམས་ཀྱིས་ལོངས་པ་དང་ད་དུང་ལྷག་མ་ཡང་ཡོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","དེ་ནས་ལས་མཁན་གྱི་ཁྲོད་དུ་མི་ལག་རྩལ་ཅན་ཐམས་ཅད་ཀྱིས་ཡོལ་བ་བཅུ་ཡིས་གུར་མཆོག་བཟོས་ཤིང་། དེའི་རྒྱུ་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་དང་། བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་གྱི་མདོག་ཅན་བཅས་ལ་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་དང་ལྡན་པ་དེ་དག་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ཡོལ་བ་རེ་རེའི་རིང་ཚད་ནི་ཁྲུ་ཉི་ཤུ་ཉེར་བརྒྱད་དང་། ཞེང་ནི་ཁྲུ་བཞི་ཡོད་པར་བྱས། ཡོལ་བ་ཐམས་ཅད་ཀྱི་ཚད་ནི་གཅིག་མཚུངས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ཁོས་ཡོལ་བ་ལྔ་ནི་ཕན་ཚུན་སྦྲེལ་བ་དང་། ཡོལ་བ་གཞན་ལྔ་པོ་དེ་ཡང་ཕན་ཚུན་སྦྲེལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ཡང་མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་སྔ་མ་དེའི་སྣེ་མོར་ཁོས་མཐིང་མདོག་གི་སྒྲོག་ལུང་རྣམས་བཟོས་ཤིང་། མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་ཕྱི་མ་དེའི་སྣེ་མོ་ལའང་ཁོས་དེ་བཞིན་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ཁོས་མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་སྔ་མར་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོས་པ་དང་། མུ་གཅིག་ཏུ་འབྲེལ་བའི་ཡོལ་བ་ཕྱི་མར་ཡང་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོས་ཏེ། སྒྲོག་ལུང་རྣམས་ཆ་རེ་ཁ་སྤྲད་ནས་བཞག ");
INSERT INTO bodn_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ཡང་གུར་མཆོག་མུ་གཅིག་ཏུ་བསྒྲིལ་བའི་ཕྱིར་གསེར་ཀྱུ་ལྔ་བཅུ་བཟོས་ཤིང་། ཡོལ་བ་རྣམས་གསེར་ཀྱུས་སྦྲེལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ཡང་གུར་མཆོག་གི་ཁེབས་རས་ཀྱི་ཕྱིར་ཁོས་ར་རྩིད་ཀྱི་ཡོལ་བ་བཅུ་གཅིག་བཟོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ཡོལ་བ་རེ་རེའི་རིང་ཚད་ནི་ཁྲུ་སུམ་ཅུ་དང་། ཞེང་ཚད་ནི་ཁྲུ་བཞི་ཡོད་པ་དང་། ཡོལ་བ་བཅུ་གཅིག་པོའི་ཚད་གཅིག་མཚུངས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ཁོས་ཡོལ་བ་ལྔ་ནི་གཅིག་ཏུ་སྦྲེལ་ཞིང་ཡོལ་བ་གཞན་དྲུག་ཀྱང་གཅིག་ཏུ་སྦྲེལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ཡོལ་བ་སྦྲེལ་མ་ལྔ་ཅན་དེའི་སྣེ་མོར་སྒྲོག་ལུང་ལྔ་བཅུ་དང་། ཡོལ་བ་སྦྲེལ་མ་དྲུག་ཅན་དེའི་སྣེ་མོར་ཡང་སྒྲོག་ལུང་ལྔ་བཅུ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ཡང་ཁེབས་རས་མུ་གཅིག་འཁྱུད་གཅིག་འོང་བའི་ཕྱིར་ཁོས་ལི་ཡི་ཀྱུ་ལྔ་བཅུ་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","རྒྱ་ཚོས་བརྒྱབ་པའི་ལུག་ཐུག་གི་པགས་པས་ཁེབས་རས་གཡོགས་པ་དང་། ཡང་དེའི་སྟེང་དུ་ཀོ་བ་སྤུས་ལེགས་རྣམས་ཀྱིས་ཁེབས་ཤིག་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","དེ་ནས་ཁོས་གུར་མཆོག་གི་ཕྱིར་སེང་ལྡེང་ཤིང་གིས་གྱེན་དུ་འགྲེང་བའི་པང་ལེབ་རྣམས་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","པང་ལེབ་རེའི་རིང་ཚད་ནི་ཁྲུ་བཅུ་དང་། ཞེང་ཚད་ནི་ཁྲུ་གཅིག་དང་ཕྱེད་ཀ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","པང་ལེབ་གཅིག་དང་གཅིག་འབྲེལ་བའི་ཕྱིར་ཁོས་རེ་རེ་ལ་ཁོང་གཟེར་གཉིས་བཟོས་པ་དང་། གུར་མཆོག་གི་པང་ལེབ་ཐམས་ཅད་དེ་ལྟར་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ཁོས་གུར་མཆོག་གི་པང་ལེབ་བཟོས་པ་སྟེ། ལྷོ་ཕྱོགས་སུ་པང་ལེབ་ཉི་ཤུ་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","པང་ལེབ་ཉི་ཤུ་དེའི་ཞབས་ལ་དངུལ་གྱི་ཞབས་ར་བཞི་བཅུ་བཟོས་པ་དང་། པང་ལེབ་རེ་ལ་ཁོང་གཟེར་གཉིས་ཀྱི་ཞབས་ར་ཟུང་རེ་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","གུར་མཆོག་གི་ལོགས་གཞན་ཏེ། བྱང་ཕྱོགས་སུ་ཡང་ཁོས་པང་ལེབ་ཉི་ཤུ་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","དེའི་དངུལ་གྱི་ཞབས་ར་བཞི་བཅུ་དང་། པང་ལེབ་རེའི་འོག་ལ་ཞབས་ར་ཟུང་རེ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","གུར་མཆོག་གི་རྒྱབ་ལོགས་ཏེ་ནུབ་ཕྱོགས་སུ་ཁོས་པང་ལེབ་དྲུག་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","གུར་མཆོག་རྒྱབ་ལོགས་ཀྱི་ཟུར་གཉིས་ལ་པང་ལེབ་གཉིས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","དེ་གཉིས་ཀྱི་འགབ་ལ་པང་ལེབ་ཉིས་གཤིབ་ཡོད་ཅིང་། དེའི་གོང་ལའང་པང་ལེབ་གཅིག་གི་སྣེ་ནས་པང་ལེབ་གཞན་ཞིག་གི་བར་དུ་ཨ་ལོང་གཅིག་གིས་སྦྲེལ་བ་དང་། དེ་བཞིན་དུ་ཁོས་པང་ལེབ་གཉིས་དེ་ལྟར་ཟུར་གཉིས་ལ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","དེ་ལྟར་པང་ལེབ་བརྒྱད་དང་དེ་དག་ལ་དངུལ་གྱི་ཞབས་ར་བཅུ་དྲུག་དང་། པང་ལེབ་རེ་རེ་ལ་ཞབས་ར་གཉིས་བཅས་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","དེ་ནས་ཁོས་སེང་ལྡེང་ཤིང་གིས་འཕྲེད་རྒྱུག་རྣམས་བཟོས་ཏེ། གུར་མཆོག་གི་ལོགས་གཅིག་གི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་འཕྲེད་རྒྱུག་ལྔ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","གུར་མཆོག་གི་ལོགས་གཞན་ལ་ཡོད་པའི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་འཕྲེད་རྒྱུག་ལྔ་དང་། རྒྱབ་ལོགས་ཏེ་ནུབ་ཕྱོགས་ཀྱི་པང་ལེབ་རྣམས་ཀྱི་ཕྱིར་ཡང་འཕྲེད་རྒྱུག་ལྔ་བཅས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ཡང་ཁོས་པང་ལེབ་རྣམས་ཀྱི་དཀྱིལ་དུ་ཡོད་པའི་འཕྲེད་རྒྱུག་དག་སྣེ་གཅིག་ནས་སྣེ་གཞན་དུ་སླེབས་པར་བྱས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","པང་ལེབ་དེ་དག་ཁོས་གསེར་གྱིས་གཡོགས་པ་དང་། དེ་དག་གི་འཕྲེད་རྒྱུག་འཛིན་པའི་ཨ་ལོང་རྣམས་གསེར་དུ་བྱས་ཤིང་། ཡང་འཕྲེད་རྒྱུག་དག་གསེར་གྱིས་གཡོགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ཡང་ཁོས་ཡོལ་བ་ཞིག་བཟོས་ཤིང་། དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་། རྒྱ་སྨུག་དང་། མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཡིན་ཞིང་། ཡང་དེ་ལ་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་དང་ལྡན་པ་རྣམས་བཟོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ཁོས་ཡོལ་བའི་ཕྱིར་སེང་ལྡེང་ཤིང་གི་ཀ་བ་བཞི་བཟོས་ཤིང་གསེར་གྱིས་གཡོགས་པ་དང་། དེ་དག་གི་ཀྱུ་རྣམས་གསེར་ཡིན་པ་དང་། དེ་དག་གི་ཕྱིར་དངུལ་གྱི་ཞབས་ར་བཞི་བླུགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ཁོས་གུར་མཆོག་གི་སྒོ་ལ་སྒོ་ཡོལ་ཞིག་བཟོས་ཏེ། དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་ཡིན་ཏེ། འཐག་མཁན་གྱི་ལས་བཞིན་དུ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ཡང་ཁོས་ཀ་བ་ལྔ་དང་སོ་སོའི་ཀྱུ་དང་བཅས་བཟོས་ཤིང་། ཀ་མགོ་རྣམས་དང་། ཁ་ཐུར་དག་གསེར་གྱིས་གཡོགས་པ་དང་། དེའི་ཞབས་ར་ལྔ་ནི་ལི་ཡིས་བཟོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ཡང་པི་ཟིད་ཨེལ་གྱིས་སེང་ལྡེང་ཤིང་གིས་ཤུར་སྒམ་བཟོས་པ་དང་། དེའི་རིང་ཚད་ལ་ཁྲུ་གཉིས་དང་ཕྱེད། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད། མཐོ་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད་ཀའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ཁོས་དེའི་ཕྱི་ནང་གཉིས་གསེར་བཙོ་མས་གཡོགས་པ་དང་། དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ཡང་ཁོས་གསེར་གྱི་ཨ་ལོང་བཞི་བླུགས་ནས་དེའི་སུག་པ་བཞི་ལ་སྦྱར་བ་དང་། ཨ་ལོང་གཉིས་ལོགས་གཅིག་དང་ཨ་ལོང་གཞན་གཉིས་པོ་ལོགས་ཅིག་ཤོས་ལ་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ཡང་ཁོས་སེང་ལྡེང་ཤིང་གིས་རྒྱུག་པ་གཉིས་བཟོས་ནས་དེ་གསེར་གྱིས་གཡོགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ཤུར་སྒམ་དེ་འཁུར་བའི་ཕྱིར་རྒྱུག་པ་གཉིས་ཤུར་སྒམ་གྱི་ལོགས་གཉིས་ཀའི་ཨ་ལོང་རྣམས་ལ་བརྒྱུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ཡང་ཁོས་གསེར་བཙོ་མས་ཐུགས་རྗེའི་བཞུགས་ཁྲི་བཟོས་ཤིང་དེའི་རིང་ཚད་ནི་ཁྲུ་གཉིས་དང་ཕྱེད། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད་ཀའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ཐུགས་རྗེའི་བཞུགས་ཁྲི་ཡི་སྣེ་མོ་གཉིས་ལ་གསེར་གྱིས་འབུར་རྡུང་བྱས་པའི་ཀེ་རུབ་ཀྱི་གཟུགས་བརྙན་གཉིས་བཟོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ཀེ་རུབ་གཅིག་སྣེ་མོ་གཅིག་ལ་བཞག་པ་དང་། ཀེ་རུབ་ཅིག་ཤོས་སྣེ་མོ་གཞན་དེ་ལ་བཞག་སྟེ། ཀེ་རུབ་གཉིས་ནི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་ཡི་སྣེ་མོ་གཉིས་ལ་དངོས་པོ་གཅིག་ཏུ་སྦྲེལ་བཟོ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","དེ་གཉིས་ཀྱིས་གཤོག་པ་གྱེན་དུ་བརྐྱངས་ནས་ཐུགས་རྗེའི་བཞུགས་ཁྲི་གཡོགས་ཡོད་པ་དང་། ཕན་ཚུན་ལ་གདོང་གཏད་པ་དང་ཡང་དེ་གཉིས་ཀྱི་ཞལ་ངོ་ནི་བཞུགས་ཁྲི་ལ་འཁོར་ནས་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ཡང་ཁོས་སེང་ལྡེང་ཤིང་གིས་སྒྲོག་ཙེ་ཞིག་བཟོས་ཤིང་། དེའི་རིང་ཚད་ལ་ཁྲུ་གཉིས། ཞེང་ཚད་ལ་ཁྲུ་གཅིག མཐོ་ཚད་ལ་ཁྲུ་གཅིག་དང་ཕྱེད་ཀ་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ཁོས་དེ་གསེར་བཙོ་མས་གཡོགས་པ་དང་དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ཁོས་མུ་ཁྱུད་དེའི་འགབ་ཏུ་ཡང་མཐོ་ཚད་ལ་སོར་བཞི་ཅན་གྱི་མཐའ་རྒྱན་ཞིག་བཟོས་པ་དང་། དེའི་སྟེང་དུ་ཡང་གསེར་གྱི་མུ་ཁྱུད་ཅིག་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ཡང་དེ་ལ་གསེར་གྱི་ཨ་ལོང་བཞི་བཟོས་ཏེ། དེའི་གྲུ་བཞིའི་སུག་པ་བཞི་ལ་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ཨ་ལོང་དེ་དག་མཐའ་རྒྱན་གྱི་འཁྲིས་སུ་སྦྱར་ཏེ་སྒྲོག་ཙེ་འཁུར་བའི་ཕྱིར་དེ་དག་ནི་རྒྱུག་པ་རྣམས་ཀྱི་བསྐོན་ས་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","སྒྲོག་ཙེ་འཁུར་བའི་ཕྱིར་ཁོས་རྒྱུག་པ་དེ་རྣམས་སེང་ལྡེང་ཤིང་གིས་བཟོས་ཏེ་གསེར་གྱིས་གཡོགས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","སྒྲོག་ཙེ་སྟེང་གི་ཡོ་བྱད་ཐམས་ཅད་དེ། གཞོང་པ་དང་སྡེར་མ་དང་། སྐྱེམས་མཆོད་འབུལ་བྱེད་ཨུ་ལུ་དང་བུམ་པ་བཅས་གསེར་བཙོ་མས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ཡང་ཁོས་སྒྲོན་སྟེགས་དེ་གསེར་བཙོ་མས་བཟོས་ཤིང་། སྒྲོན་སྟེགས་དང་དེའི་ཞབས་ར་དང་སྟེགས་རྐང་བཅས་འབུར་རྡུང་གིས་བཟོས་པ་དང་། དེའི་སྒྲོན་ཕོར་དང་། གང་བུའི་གཟུགས་དང་མེ་ཏོག་གི་དབྱིབས་ཚུགས་བཅས་སྒྲོན་སྟེགས་དང་དངོས་པོ་གཅིག་ཏུ་སྦྲེལ་བཟོ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","སྒྲོན་སྟེགས་ཀྱི་ལོགས་གཉིས་ནས་གེལ་པ་དྲུག་ཐོན་པར་བྱས་ཤིང་། སྒྲོན་སྟེགས་ཀྱི་ལོགས་གཅིག་ནས་གེལ་པ་གསུམ་དང་ལོགས་ཅིག་ཤོས་སུ་གེལ་པ་གསུམ་ཐོན་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ལོགས་གཉིས་ཀའི་གེལ་པ་རེ་ལ་སྟར་སྡོང་གི་མེ་ཏོག་ལྟར་བྱས་པའི་སྒྲོན་ཕོར་གསུམ་རེ་ཡོད་པ་དང་། སྒྲོན་ཕོར་རེ་རེའི་སྟེགས་རྐང་དུ་གང་བུའི་གཟུགས་ཤིག་དང་། མེ་ཏོག་གཟུགས་ཤིག་བཅས་ཡོད་པར་བྱས། སྒྲོན་སྟེགས་ཀྱི་སྤྱི་སྡོམ་གེལ་པ་དྲུག་པོ་ཕན་ཚུན་ཆ་མཚུངས་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ཡང་སྒྲོན་སྟེགས་རྐང་པའི་སྟར་སྡོང་གི་མེ་ཏོག་ལྟར་བྱས་པའི་སྒྲོན་ཕོར་བཞི་ལ་གང་བུའི་གཟུགས་ཤིག་དང་མེ་ཏོག་གཟུགས་ཤིག་བཅས་ཡོད་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","དེའི་གེལ་པ་ཟུང་གཅིག་གི་འོག་ཏུ་གང་བུའི་གཟུགས་ཤིག དེའི་གེལ་པ་གཞན་ཟུང་གི་འོག་ཏུའང་གང་བུའི་གཟུགས་ཤིག་སྟེ། དེ་ལྟར་སྒྲོན་སྟེགས་ལས་བྱུང་བའི་གེལ་པ་དྲུག་པོ་ལ་ཡོད་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","གང་བུའི་གཟུགས་རྣམས་དང་གེལ་པ་རྣམས་ནི་མུ་འབྲེལ་དུ་འབུར་རྡུང་བྱས་པའི་གསེར་བཙོ་མས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ཡང་ཁོས་དེ་ལ་སྒྲོན་མེ་བདུན་དང་དེའི་སྡོང་རས་གཅོད་བྱེད་སྐམ་ཆུང་དང་ཀ་ཏོ་ར་རྣམས་གསེར་བཙོ་མས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་གསེར་བཙོ་མ་རྡོ་ཚད་གཅིག་གིས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ཡང་ཁོས་སེང་ལྡེང་ཤིང་གིས་སྤོས་ཁྲི་བཟོས་ཏེ། དེའི་རིང་ཚད་ལ་ཁྲུ་གཅིག་དང་། ཞེང་ཚད་ལ་ཁྲུ་གཅིག་སྟེ་གྲུ་བཞི་མ་ཞིག་ཡིན་ལ། ཡང་དེའི་མཐོ་ཚད་ལ་ཁྲུ་གཉིས་ཡིན་པར་བྱས་ཤིང་། རུ་ཐུར་རྣམས་སྤོས་ཁྲི་དང་དངོས་པོ་གཅིག་ཏུ་སྦྲེལ་བཟོ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ཁོས་དེའི་ཐོག་དང་ལོགས་བཞི་དང་རུ་ཐུར་རྣམས་གསེར་བཙོ་མས་གཡོགས་ཏེ། དེའི་མཐའ་འཁོར་ལ་གསེར་གྱི་མུ་ཁྱུད་ཅིག་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ཡང་མུ་ཁྱུད་འོག་ནས་ཁ་གཏད་ཀྱི་ལོགས་གཉིས་ཀར་གསེར་གྱི་ཨ་ལོང་གཉིས་བཟོས་པ་དང་། དེ་ནི་རྒྱུག་པ་གཉིས་བསྐོན་ས་བྱས་ཤིང་། སྤོས་ཁྲི་འཁུར་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","རྒྱུག་པ་དེ་གཉིས་སེང་ལྡེང་ཤིང་གིས་བཟོས་ཏེ་གསེར་གྱིས་གཡོགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ཡང་སྤོས་ཆུ་བཟོ་མཁན་གྱི་ལུགས་བཞིན་དུ། ཁོས་འབྱུག་སྣུམ་དམ་པ་དང་དྲི་ཞིམ་སླད་མེད་ཀྱི་བདུག་སྤོས་ནི་བསུང་རྫས་ནས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ཡང་པི་ཟིད་ཨེལ་གྱིས་སེང་ལྡེང་ཤིང་གིས་སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་བཟོས་ཤིང་། དེའི་རིང་ཚད་ནི་ཁྲུ་ལྔ་དང་ཞེང་ཚད་ནི་ཁྲུ་ལྔ་སྟེ་གྲུ་བཞི་མ་ཞིག་ཡིན་ཞིང་། མཐོ་ཚད་ནི་ཁྲུ་གསུམ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","དེའི་ཟུར་བཞི་ལ་རུ་ཐུར་བཞི་བཟོས་པ་དང་། རུ་ཐུར་བཞི་ནི་མཆོད་ཁྲི་དང་གཅིག་པར་སྦྲེལ་ཞིང་། མཆོད་ཁྲི་ལི་ཡིས་གཡོགས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ཡང་ཁོས་མཆོད་ཁྲིའི་གཞོང་པ་རྣམས་དང་མེ་ཁྱེམ་དང་། མཆོད་སྡེར་དང་ཤ་འཛིན་ཁ་དབྲག་དང་མེ་ཕོར་བཅས་བཟོས་ཤིང་། ཡོ་བྱད་དེ་ཐམས་ཅད་ལི་ཡིས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ཡང་རྒྱུ་ལི་ཡིན་པའི་ཐག་མིག་ཅིག་བཟོས་ཏེ། ཐག་མིག་ནི་མཆོད་ཁྲིའི་མུ་ཁྱུད་ཀྱི་འགབ་ལ་བཅུག་ཅིང་། མཆོད་ཁྲིའི་མཐོ་ཚད་ཀྱི་ཕྱེད་ཙམ་ལ་སླེབས་སུ་བཅུག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ཐག་མིག་དེའི་གྲུ་ག་བཞི་ལ་ལི་ཡི་ཨ་ལོང་རེ་བླུགས་པ་དང་། དེ་དག་ནི་རྒྱུག་པ་གཉིས་བསྐོན་ས་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ཁོས་སེང་ལྡེང་ཤིང་གིས་རྒྱུག་པ་བཟོས་ནས་དེ་གཉིས་ལི་ཡིས་གཡོགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","རྒྱུག་པ་ནི་མཆོད་ཁྲིའི་ལོགས་གཉིས་ཀྱི་ཨ་ལོང་རྣམས་སུ་བརྒྱུས་ཤིང་མཆོད་ཁྲི་འཁུར་བའི་ཕྱིར་ཡིན་ལ། ཡང་པང་ལེབ་ཀྱིས་མཆོད་ཁྲི་བཟོས་ཤིང་། དེའི་ནང་སྟོང་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ཡང་ཁོས་ལི་ཡི་གཞོང་པ་དང་དེའི་སྟེགས་བུ་བཟོས་ཤིང་། དེ་གཉིས་ནི་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་འགྲམ་ནས་ཞབས་ཕྱི་བྱེད་པའི་བུད་མེད་རྣམས་ཀྱི་མེ་ལོང་གིས་བཟོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","དེ་ནས་ཁོས་ཁྱམས་ར་བཟོས་ཏེ། ལྷོ་ཕྱོགས་ཀྱི་ཁྱམས་ཡོལ་རྣམས་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་གྱིས་བྱས་ཤིང་། དེའི་རིང་ཚད་ལ་ཁྲུ་བརྒྱ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","དེའི་ཀ་བ་ཉི་ཤུ་དང་དེ་དག་གི་ཞབས་ར་ཉི་ཤུ་ནི་ལི་ཡིས་བཟོས་པ་དང་། ཀ་བའི་ཀྱུ་རྣམས་དང་དེ་དག་གི་ཁ་ཐུར་རྣམས་དངུལ་གྱིས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ཡང་བྱང་ཕྱོགས་ཀྱི་ཁྱམས་ཡོལ་རྣམས་ལ་ཡང་རིང་ཚད་ཁྲུ་བརྒྱ་ཡོད་ཅིང་། དེའི་ཀ་བ་ཉི་ཤུ་དང་དེ་དག་གི་ཞབས་ར་ཉི་ཤུ་ལི་ཡིས་བཟོས་པ་དང་། ཀ་བའི་ཀྱུ་དང་ཁ་ཐུར་རྣམས་དངུལ་གྱིས་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ཡང་ཁྱམས་རའི་ནུབ་ཕྱོགས་ཀྱི་ཡོལ་བ་རྣམས་ཀྱི་ཞེང་ཚད་ལ་ཁྲུ་ལྔ་བཅུ་ཡོད་ལ། དེར་ཀ་བ་བཅུ་དང་ཞབས་ར་བཅུ་བཟོས་ཤིང་། ཀ་བའི་ཀྱུ་དང་ཁ་ཐུར་རྣམས་དངུལ་གྱིས་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ཤར་ཕྱོགས་ཀྱི་ཁྱམས་ཡོལ་གྱི་ཞེང་ལའང་ཁྲུ་ལྔ་བཅུ་ཡོད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","སྒོའི་ལོགས་གཅིག་གི་ཡོལ་བ་ལ་ཁྲུ་བཅོ་ལྔ་དང་། དེ་ལ་ཀ་བ་གསུམ་དང་ཞབས་ར་གསུམ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","དེ་བཞིན་དུ་སྒོའི་ལོགས་ཅིག་ཤོས་དེ་ལའང་དེ་བཞིན་བྱས། ཁྱམས་རའི་སྒོའི་ལོགས་རེ་ལ་ཡོལ་བ་ཁྲུ་བཅོ་ལྔ་དང་། ཀ་བ་གསུམ་དང་། ཞབས་ར་གསུམ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ཁྱམས་ཡོལ་ཐམས་ཅད་ཀྱི་རྒྱུ་ནི་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ཀ་བ་རྣམས་ཀྱི་ཞབས་ར་རྣམས་ལི་དང་ཀ་བའི་ཀྱུ་རྣམས་དང་ཁ་ཐུར་རྣམས་ནི་དངུལ་དང་། ཀ་མགོ་རྣམས་ཀྱང་དངུལ་གྱིས་གཡོགས་ཤིང་། ཁྱམས་རའི་ཀ་བ་ཐམས་ཅད་ཀྱི་རྒྱུག་པ་རྣམས་ཀྱང་དངུལ་གྱིས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ཁྱམས་རའི་སྒོ་ཡོལ་དེའི་རྒྱུ་ནི་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་གྱིས་འཐག་མཁན་གྱི་ལས་བཞིན་བྱས་ཤིང་། དེའི་རིང་ཚད་ནི་ཁྲུ་ཉི་ཤུ་དང་མཐོ་ཚད་ལ་ཁྲུ་ལྔ་བཟོས་པ་དང་། མཐོ་ཚད་དེ་ནི་ཁྱམས་ཡོལ་རྣམས་དང་མཐུན། ");
INSERT INTO bodn_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","དེའི་ཀ་བ་བཞི་དང་ཞབས་ར་བཞི་ནི་ལི་དང་། ཀ་བའི་ཀྱུ་དང་ཁ་ཐུར་རྣམས་ནི་དངུལ་གྱིས་བཟོས་ཤིང་། ཀ་མགོ་རྣམས་ནི་དངུལ་གྱིས་གཡོགས། ");
INSERT INTO bodn_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","གུར་མཆོག་དང་ཁྱམས་རའི་མཐའ་འཁོར་གྱི་ཕུར་བ་ཐམས་ཅད་ལི་ཡིས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","མོ་ཤེ་ཡིས་བཀའ་གནང་བ་བཞིན་དུ་ལེ་ཝི་པས་ཞབས་འདེགས་སྐོར་ལ་རྩིས་གྲངས་བླངས་ཤིང་། མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨི་ཐ་མཱཪ་གྱིས་རྩིས་ཐོར་བཀོད་པའི་གུར་མཆོག་གམ་དཔང་པོའི་གུར་མཆོག་གི་རྒྱུ་ཆའི་སྡོམ་ནི་འདི་ལྟར་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཅི་གནང་བ་བཞིན་དུ་བཟོ་མཁན་པི་ཟིད་ཨེལ་ཡིན་ལ། ཁོ་ནི་ཨོའུ་རེལ་གྱི་བུ་ཡིན་ཞིང་། ཨོའུ་རེལ་ནི་ཡ་ཧུ་དཱ་ཚོ་པའི་ཧུ་རཱ་ཡི་བུ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","དཱན་ཚོ་པའི་ཨ་ཧི་སཱ་མག་གི་བུ་ཨོ་ཧོ་ལི་ཨབ་ནི་པི་ཟིད་ཨེལ་གྱི་ལས་གྲོགས་ཡིན་ཞིང་། ཁོ་ནི་བརྐོ་བཟོ་དང་ལས་ཀ་བྱེད་པའི་ལག་རྩལ་ཅན་དང༌། བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུའི་འཐག་བཟོ་པའང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","དེ་སྔར་ཕུལ་ཟིན་པའི་གསེར་ཐམས་ཅད་དེ། གནས་མཆོག་བཟོ་བའི་ལས་ཀུན་གྱི་ཕྱིར་གཡོབ་མཆོད་དུ་ཕུལ་བའི་གསེར་ནི་གནས་མཆོག་གི་སྲང་བཞིན་དུ་རྡོ་ཚད་ཉི་ཤུ་ཉེར་དགུ་དང་གསེར་སྲང་བདུན་བརྒྱ་སུམ་ཅུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","མི་ཚོགས་ཀྱི་གྲངས་རྩིས་ལས་བྱུང་བའི་དངུལ་ནི་གནས་མཆོག་གི་སྲང་བཞིན་དུ་རྡོ་ཚད་བརྒྱ་དང་། དངུལ་སྲང་ཆིག་སྟོང་བདུན་བརྒྱ་བདུན་ཅུ་དོན་ལྔ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","མི་ཚོགས་ཀྱི་གྲངས་ཀ་རྩིས་པ་ལ་ལོ་ཉི་ཤུ་ཡན་གྱི་སྐྱེས་པའི་གྲངས་ནི་དྲུག་འབུམ་སུམ་སྟོང་ལྔ་བརྒྱ་ལྔ་བཅུ་ཡིན། དེ་རེ་རེ་ནས་དངུལ་ཁྲལ་པེ་ཁཱ་གཅིག་རེ་ཕུལ། པེ་ཁཱའི་ལྗིད་ཚད་ནི་གནས་མཆོག་གི་སྲང་བཞིན་གྱི་དངུལ་སྲང་ཕྱེད་ཀ་དང་འདྲ། ");
INSERT INTO bodn_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","དངུལ་རྡོ་ཚད་བརྒྱ་ཡོད་པ་དེ་གནས་མཆོག་གི་ཞབས་ར་དང་ཡོལ་བའི་ཞབས་ར་རྣམས་བླུག་པའི་ཕྱིར་ཡིན་ཏེ། ཞབས་ར་བརྒྱ་ལ་རྡོ་ཚད་བརྒྱ། ཞབས་ར་རེ་ལ་རྡོ་ཚད་གཅིག་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","དངུལ་སྲང་ཆིག་སྟོང་བདུན་བརྒྱ་བདུན་ཅུ་དོན་ལྔ་དེ་ཡིས་ཀ་བའི་ཀྱུ་རྣམས་བཟོས་པ་དང་། ཀ་མགོ་རྣམས་གཡོགས་པ་དང་། ད་དུང་ཁ་ཐུར་རྣམས་ཀྱང་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ཡང་དེ་སྔར་གཡོབ་མཆོད་དུ་ཕུལ་ཟིན་པའི་ལི་སྟེ། རྡོ་ཚད་བདུན་ཅུ་དང་སྲང་ཉིས་སྟོང་བཞི་བརྒྱ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","དེ་ལས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོའི་ཞབས་ར་རྣམས་དང་། ལི་ཡིན་པའི་མཆོད་ཁྲི་དང་། དེའི་ལི་ཡིན་པའི་ཐག་མིག་དང་མཆོད་ཁྲིའི་ཡོ་བྱད་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ཕྱོགས་བཞི་ལ་བསྐོར་ཡོད་པའི་ཁྱམས་རའི་ཞབས་ར་རྣམས་དང་། ཁྱམས་སྒོའི་ཞབས་ར་རྣམས་དང་། གུར་མཆོག་གི་ཕུར་བ་ཐམས་ཅད་དང་ཕྱོགས་བཞི་ལ་བསྐོར་ཡོད་པའི་ཁྱམས་རའི་ཕུར་བ་ཐམས་ཅད་བཅས་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","གནས་དམ་པ་ནས་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་པི་ཟིད་ཨེལ་སོགས་ཀྱིས་ཐགས་ཞིབ་མོར་བཏགས་པའི་གོས་རྣམས་བཟོས་པ་ནི། བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་བཅས་ཀྱིས། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་འཕགས་གོས་དམ་པ་རྣམས་ཨ་རོན་གྱི་ཕྱིར་བཟོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ཁོས་བེར་ཐུལ་གྱི་རྒྱུ་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","དེ་དག་གིས་གསེར་ནི་ལེབ་མོ་སྲབ་བུར་བརྡུངས་ནས་སྐུད་པ་དྲས་ཤིང་། བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བཅས་ཀྱིས་འཐག་མཁན་ལག་རྩལ་ཅན་གྱི་ལས་བཞིན་དུ་ཆ་མཚུངས་པར་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","བེར་ཐུལ་ལ་ཡང་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་བཟོས་ཤིང་། བེར་ཐུལ་གྱི་ཕྲག་མགོ་གཉིས་ལ་སྦྲེལ་ཞིང་འཆིང་བར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ཡང་བེར་ཐུལ་དང་འབྲེལ་བའི་སྐེད་ཆིངས་མཆོར་པོ་ཅན་ནི་བེར་ཐུལ་གྱི་བཟོ་ཚུལ་དང་གཅིག་མཚུངས་ཡིན་ཞིང་། དེའི་རྒྱུ་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ཡང་དེ་དག་གིས་གཟི་གཉིས་སྟ་གོན་བྱས་ནས་གསེར་གྱི་འབུར་ཀོང་གིས་བསྐོར་བ་དང་དམ་ཕྲུག་བརྐོ་བ་བཞིན་དུ་གཟི་གཉིས་ཀྱི་སྟེང་དུ་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་བརྐོས། ");
INSERT INTO bodn_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","རྡོ་དེ་གཉིས་བེར་ཐུལ་གྱི་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་ལ་སྦྱར་ཅིང་། ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ལ་རྗེས་དྲན་བྱེད་པའི་ཕྱིར་རོ། །དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ཡང་པི་ཟིད་ཨེལ་གྱིས་བྲང་རྒྱན་དེ་བཟོས་ལ། དེ་ནི་བཟོ་བ་ལག་རྩལ་ཅན་གྱིས་བྱས་པ་དང་བེར་ཐུལ་གྱི་བཟོ་ཚུལ་བཞིན་དུ་བཟོས། དེ་ནི་གསེར་སྐུད་དང་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག་དང་མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་གྱིས་བཟོས་ཟིན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","དེ་ནི་གྲུ་བཞི་མ་ཞིག་ཡིན་ལ། རིང་ཚད་ལ་མཐོ་གང་དང་ཞེང་ལ་ཡང་མཐོ་གང་ཡོད་དེ་ཉིས་ལྟེབ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","དེ་ལ་ཕ་ལམ་ཤུར་ཕྲེང་བཞིའི་ཕྲ་བཏབ་ཡོད་དེ། ཤུར་ཕྲེང་དང་པོ་ནི་པདྨ་རཱ་ག་དང་། སྤྲིན་རྡོ། མ་རྒད་བཅས་གསུམ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ཤུར་ཕྲེང་གཉིས་པ་ནི་གཡུ་དང་ཨིནྡྲ་ནཱི་ལ་དང་རྡོ་རྗེ་ཕ་ལམ་བཅས་གསུམ། ");
INSERT INTO bodn_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ཤུར་ཕྲེང་གསུམ་པ་ནི་རྟ་ཀླད་སྨུག་པོ་དང་། ཤེལ་རྡོ་དང་། མུ་མེན་བཅས་གསུམ། ");
INSERT INTO bodn_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ཤུར་ཕྲེང་བཞི་པ་ནི་བཻཌཱུརྱ་ལྗང་སེར་དང་། གཟི་དང་གཡང་ཊི་སྔོན་པོ་བཅས་གསུམ་སྟེ། དེ་དག་ནི་གསེར་གྱི་འབུར་ཀོང་ལ་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","རིན་པོ་ཆེ་དེ་དག་གིས་ཡེས་ར་ཨེལ་གྱི་བུ་རྣམས་ཀྱི་མིང་གི་མཚོན་རྟགས་བྱེད་ཅིང་མིང་ལྟར་བཅུ་གཉིས་ཡོད་དེ། དམ་ཕྲུག་བཞིན་དུ་རིན་པོ་ཆེ་རེ་རེའི་སྟེང་དུ་ཡེས་ར་ཨེལ་གྱི་ཚོ་པ་བཅུ་གཉིས་པོའི་མིང་རེ་རེ་བཞིན་དུ་བརྐོས་ཟིན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","དེ་དག་གིས་བྲང་རྒྱན་ལ་གསེར་བཙོ་མས་བསླེས་པའི་ཉག་ཐག་བཟོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","གསེར་གྱི་འབུར་ཀོང་གཉིས་དང་ཨ་ལོང་གཉིས་བཟོས་ཏེ་ཨ་ལོང་གཉིས་བྲང་རྒྱན་གྱི་གྲུ་ག་གཉིས་ལ་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ཡང་གསེར་གྱི་ཉག་ཐག་དེ་གཉིས་ནི་བྲང་རྒྱན་གྱི་གྲུ་ག་རུ་ཡོད་པའི་ཨ་ལོང་གཉིས་ལ་བརྒྱུས་ཡོད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","དེ་ནས་ཉག་ཐག་གི་སྣེ་གཉིས་འབུར་ཀོང་གཉིས་ལ་བཅུག་སྟེ། བེར་ཐུལ་གྱི་དཔུང་པའི་ཕྲག་ཁེབས་ཀྱི་མདུན་ལོགས་ལ་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ཡང་ཁོས་གསེར་གྱི་ཨ་ལོང་གཞན་གཉིས་བཟོས་ནས་བྲང་རྒྱན་གྱི་གྲུ་ག་གཉིས་ལ་སྦྱར་ཅིང་། སྦྱོར་ས་དེ་ནི་བྲང་རྒྱན་གྱི་ཟུར་ཁ་ཡིན་ལ་བྲང་རྒྱན་དང་བེར་ཐུལ་གྱི་བར་མཚམས་ཀྱང་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ཡང་ཁོས་གསེར་གྱི་ཨ་ལོང་གཉིས་བཟོས་ནས། བེར་ཐུལ་གྱི་དཔུང་པའི་ཕྲག་ཁེབས་གཉིས་ཀྱི་མདུན་ལོགས་ཀྱི་འོག་དང་སྐེད་ཆིངས་མཆོར་པོ་ཅན་གྱི་འབྲེལ་སའི་ཅུང་ཟད་གོང་དུ་བཅུག་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","བྲང་རྒྱན་དེ་བེར་ཐུལ་གྱི་སྐེད་ཆིངས་མཆོར་པོ་ཅན་དང་དམ་དུ་འབྲེལ་བ་དང་བེར་ཐུལ་ལས་མི་འཆོར་བའི་ཕྱིར། བྲང་རྒྱན་གྱི་ཨ་ལོང་དེ་བེར་ཐུལ་གྱི་ཨ་ལོང་ལ་སྡེམ་ཐག་སྔོན་པོ་ཡིས་བསྡམས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","པི་ཟིད་ཨེལ་གྱིས་ཡང་བེར་ཐུལ་འོག་གི་གོས་རིང་ནི་ཁ་དོག་སྔོན་པོས་འཐག་བཟོའི་ལུགས་ལྟར་བྱས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","དེའི་སྟོད་དཀྱིལ་དུ་མགོའི་ཕྱིར་ཁུང་བུ་ཞིག་བཞག་ཅིང་། དེའི་མཐའ་འཁོར་ལ་འཐག་བཟོ་བྱས་པའི་གོང་བ་ཞིག་ཀྱང་བཟོས་ཏེ། མི་རལ་བའི་ཕྱིར་གོ་ཁྲབ་ཀྱི་གོང་བ་ལྟར་དུ་བཟོས། ");
INSERT INTO bodn_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ཡང་དེའི་གོས་འདབ་ཀྱི་མཐའ་འཁོར་དུ་བལ་སྐུད་མཐིང་ག་དང་རྒྱ་སྨུག མཚལ་དམར་དང་སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ཀྱི་སེ་འབྲུས་བརྒྱན་ཡོད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","གསེར་བཙོ་མས་གཡེར་ཁ་རྣམས་བཟོས་ཤིང་། སེ་འབྲུ་རེ་རེའི་བར་གསེབ་ཏུ་གསེར་གྱི་གཡེར་ཁ་རྣམས་བེར་ཐུལ་གྱི་འདབ་ཟུར་ཐམས་ཅད་ལ་སྦྱར། ");
INSERT INTO bodn_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","གཡེར་ཁ་གཅིག་དང་སེ་འབྲུ་གཅིག ཡང་གཡེར་ཁ་གཅིག་དང་སེ་འབྲུ་གཅིག་བཅས་གོས་རིང་གི་འདབ་ཁ་ཐམས་ཅད་ལ་སྦྱར། དཀོན་མཆོག་ལ་ཞབས་ཕྱི་སྒྲུབ་སྐབས་གྱོན་པའི་ཕྱིར་བཟོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ཡང་དེ་དག་གིས་འཐག་མཁན་གྱི་ལས་བཞིན་དུ་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་སོ་རས་སྲབ་བུ་ཡིས་ནང་གོས་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ཡང་སོ་རས་ཀྱིས་ལ་ཐོད་དང་པྲོག་ཞུ་མཛེས་སྡུག་ལྡན་པ་རྣམས་བཟོས་པ་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་གྱིས་ཨང་ཐུང་བཟོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","སྐེད་ཆིངས་ནི་བལ་སྐུད་མཐིང་ག་དང་། རྒྱ་སྨུག་དང་། མཚལ་དམར་དང་། སོ་རས་སྲབ་བུ་བསྒྲིམས་པ་ཅན་བཅས་ནས་འཐག་མཁན་གྱི་ལས་བཞིན་དུ་བཟོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ཡང་དེ་དག་གིས་གསེར་བཙོ་མས་ཅོད་པན་དམ་པའི་བྱང་བུ་བཟོས་ཤིང་། དེའི་སྟེང་ལ་དམ་ཕྲུག་བརྐོ་བ་བཞིན་དུ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་དུ་དམ་པའོ་ཞེས་བརྐོས། ");
INSERT INTO bodn_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ཡང་དེ་ལ་རས་སྔོན་པོའི་ཉག་ཐག་ཅིག་སྦྱར་ནས་གོང་གི་ལ་ཐོད་དང་སྦྲེལ་བ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","དེ་དག་གིས་དེ་ལྟར་གུར་མཆོག་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱིར་ལས་ཀ་ཐམས་ཅད་རྫོགས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཅི་དང་ཅི་གནང་བ་བཞིན་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་བྱས་ཏེ། དེ་ག་བཞིན་དུ་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","དེ་ནས་དེ་དག་གིས་མོ་ཤེའི་དྲུང་དུ་གུར་མཆོག་ཁྱེར་འོངས་ནས། གུར་དེ་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དེ། དེའི་ཀྱུ་རྣམས་དང་། པང་ལེབ་དང་། འཕྲེད་རྒྱུག་དང་། ཀ་བ་དང་དེའི་ཞབས་ར་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","རྒྱ་ཚོས་བརྒྱབ་པའི་ལུག་ཐུག་གི་པགས་པ་ནས་གུར་མཆོག་གི་ཁེབས་རས་དང་། དེའི་སྟེང་དུ་ཀོ་བ་སྤུས་ལེགས་རྣམས་ལས་བྱས་པའི་ཁེབས་དང་། གཡོག་བྱེད་ཀྱི་ཡོལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","དཔང་མཛད་ཤུར་སྒམ་དང་དེའི་རྒྱུག་པ་རྣམས་དང་། ཐུགས་རྗེའི་བཞུགས་ཁྲི་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","སྒྲོག་ཙེ་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་སྤྱན་བསྟར་བག་ལེབ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","གསེར་བཙོ་མའི་སྒྲོན་སྟེགས་དང་དེ་ལ་གྲལ་བསྒྲིགས་པའི་སྒྲོན་མེ་རྣམས་དང་། དེའི་ཡོ་བྱད་ཐམས་ཅད་དང༌། སྒྲོན་མེའི་ཕྱིར་འཚིར་སྣུམ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","གསེར་གྱི་སྤོས་ཁྲི་དང་། འབྱུག་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས་དང་གུར་མཆོག་གི་སྒོ་ཡོལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ལི་ཡི་མཆོད་ཁྲི་དང་དེའི་སྟེང་གི་ལི་ཡི་ཐག་མིག་དང་དེའི་རྒྱུག་པ་རྣམས་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་། ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ཁྱམས་རའི་ཡོལ་བ་རྣམས་དང་དེའི་ཀ་བ་དང་། ཞབས་ར་དང་། ཁྱམས་རའི་སྒོ་ཡོལ་དང་དེའི་ཆོན་ཐག་དང་ཕུར་བ་དང་། གུར་མཆོག་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱིར་བཀོལ་སྤྱོད་བྱེད་པའི་ཡོ་བྱད་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","གནས་དམ་པར་ཞབས་ཕྱི་བྱེད་པའི་ཆེད་དུ་ཐགས་ཞིབ་མོར་བཏགས་པའི་གོས་རྣམས་དང་། མཆོད་དཔོན་ཨ་རོན་གྱི་ན་བཟའ་དམ་པ་རྣམས་དང་། ཁོའི་བུ་རྣམས་ཀྱིས་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་ན་བཟའ་བཅས་ཁྱེར་ནས་འོངས། ");
INSERT INTO bodn_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཅི་དང་ཅི་གནང་བ་བཞིན་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ལས་ཀ་དེ་ཐམས་ཅད་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","དེ་ནས་མོ་ཤེ་ཡིས་ལས་ཀ་དེ་ཐམས་ཅད་ལ་བལྟས་ནས། ལྟོས་དང་དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་ཁོ་རྣམས་ཀྱིས་དེ་ལྟར་བསྒྲུབས་པས། ཁོས་དེ་དག་ལ་བྱིན་གྱིས་བརླབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་ཅེས་གསུངས་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","ཟླ་དང་པོའི་ཚེས་གཅིག་ཉིན། ཁྱོད་ཀྱིས་གུར་མཆོག་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་བསྒྲེང་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","དེའི་ནང་དུ་དཔང་མཛད་ཤུར་སྒམ་བཞག་ནས། སྒམ་དེའི་མདུན་དུ་ཡོལ་བ་དཔྱང་བར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ཁྱོད་ཀྱིས་གུར་མཆོག་ཏུ་སྒྲོག་ཙེ་བཞག་སྟེ། དེའི་སྟེང་དུ་རྫས་གང་དགོས་པ་རྣམས་བཤམ་པར་བྱའོ། །སྒྲོན་སྟེགས་ཀྱང་ནང་དུ་ཁྱེར་ལ། དེའི་སྟེང་དུ་སྒྲོན་མེ་རྣམས་སྒྲིགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ཁྱོད་ཀྱིས་གསེར་གྱི་སྤོས་ཁྲི་ནི་དཔང་མཛད་ཤུར་སྒམ་གྱི་མདུན་དུ་ཞོག་དང་། གུར་མཆོག་གི་སྒོ་ཡོལ་ཕོབས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ཡང་སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་ནི་གུར་མཆོག་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ཡང་ཁྲུས་གཞོང་ནི་མཇལ་འཕྲད་གུར་མཆོག་དང་མཆོད་ཁྲིའི་བར་ལ་བཞག་ནས། ནང་དུ་ཆུ་བླུགས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ཡང་དེའི་མཐའ་བཞི་ལ་ཁྱམས་རས་བསྐོར་བ་དང་། ཁྱམས་རའི་སྒོ་ཡོལ་ཡང་དཔྱང་བར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","དེ་ནས་གུར་མཆོག་དང་དེའི་ནང་དུ་ཡོད་པའི་ཡོ་བྱད་ཐམས་ཅད་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་དང་། དེ་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་ཀྱང་དམ་པར་བྱོས་ཤིག ཡོངས་སུ་དམ་པར་འགྱུར་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་དང་དེའི་ཡོ་བྱད་རྣམས་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་ནས་མཆོད་ཁྲི་དམ་པར་བྱོས་དང་། མཆོད་ཁྲི་དེ་ཀུན་ལས་དམ་པ་ཡིན་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ཡང་ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་ཏེ་དམ་པར་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ཡང་ཨ་རོན་དང་དེའི་བུ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་མདུན་དུ་ཁྲིད་ནས། ཁོ་རྣམས་ཆུས་བཀྲུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ཁྱོད་ཀྱིས་ཨ་རོན་ལ་ན་བཟའ་དམ་པ་རྣམས་བསྐོན་ནས། ང་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར་འབྱུག་སྣུམ་གྱིས་བྱུགས་པ་དང་། ཁོ་རང་དམ་པར་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ཡང་ཁོའི་བུ་རྣམས་ཀྱང་སྒོ་མདུན་དུ་ཁྲིད་དེ་ནང་གོས་རྣམས་དེ་དག་ལ་སྐོན་ཅིག ");
INSERT INTO bodn_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ཁོ་རང་ཚོས་ཀྱང་ང་ལ་མཆོད་དཔོན་གྱི་ཞབས་ཕྱི་བྱེད་པའི་ཕྱིར། སོ་སོའི་ཕ་ཨ་རོན་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་པ་ལྟར། ཁྱོད་ཀྱིས་ཁོ་ཚོར་འབྱུག་སྣུམ་གྱིས་བྱུག་དགོས་ཤིང༌། དེ་ལྟར་འབྱུག་སྣུམ་བྱུགས་པ་ཡིས་ཁོ་ཚོའི་བུ་རབས་ཚ་རྒྱུད་དུ་མཆོད་དཔོན་གྱི་ལས་ཚན་རྒྱུན་ཆད་མེད་པ་ཞིག་ཏུ་འཇུག་པར་འགྱུར་ངེས་ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","མོ་ཤེ་ཡིས་དེ་བཞིན་དུ་བྱས་ཤིང་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་བསྒྲུབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","དེ་ལྟར་ལོ་གཉིས་པའི་ཟླ་དང་པོའི་ཚེས་གཅིག་ཉིན་གུར་མཆོག་དེ་བསྒྲེངས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","མོ་ཤེ་ཡིས་གུར་མཆོག་བསྒྲེངས་པ་དང་དེའི་ཞབས་ར་རྣམས་བསྒྲིགས། པང་ལེབ་རྣམས་བསླངས། འཕྲེད་རྒྱུག་རྣམས་བཅུག ཀ་བ་རྣམས་བསྒྲེངས། ");
INSERT INTO bodn_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ཁོས་ཁེབས་རས་ཀྱིས་གུར་མཆོག་གཡོགས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་ཁེབས་གཞན་ཡང་དེའི་སྟེང་དུ་བཏིངས་པ་རེད། ");
INSERT INTO bodn_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","དེ་ནས་ཁོས་དཔང་པོའི་རྡོ་ལེབ་གཉིས་བླངས་ནས་ཤུར་སྒམ་གྱི་ནང་དུ་བཞག་སྟེ། རྒྱུག་པ་གཉིས་ཤུར་སྒམ་གྱི་ལོགས་གཉིས་ལ་བརྒྱུས་ནས། ཐུགས་རྗེའི་བཞུགས་ཁྲི་དེ་ཤུར་སྒམ་གྱི་སྟེང་དུ་བཞག ");
INSERT INTO bodn_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ཡང་ཁོས་ཤུར་སྒམ་ནི་གུར་མཆོག་ཏུ་ཁྱེར་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་དཔང་མཛད་ཤུར་སྒམ་མི་མཐོང་བའི་ཕྱིར་དེའི་མདུན་དུ་ཡོལ་བ་དཔྱངས། ");
INSERT INTO bodn_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","དེ་ནས་ཁོས་སྒྲོག་ཙེ་དེ་མཇལ་འཕྲད་གུར་མཆོག་ནང་བྱང་ཕྱོགས་སུ་ཡོལ་བའི་ཕྱི་རོལ་ཏུ་བཞག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་དེའི་སྟེང་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཞལ་ངོར་བག་ལེབ་གྲལ་དུ་བསྒྲིགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","དེ་ནས་ཁོས་སྒྲོན་སྟེགས་ནི་མཇལ་འཕྲད་གུར་མཆོག་གི་ལྷོ་ཕྱོགས་སུ་སྒྲོག་ཙེའི་ཐད་དུ་བཞག ");
INSERT INTO bodn_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་ཁོས་དེའི་སྟེང་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཞལ་ངོར་སྒྲོན་མེ་རྣམས་སྦར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ཡང་ཁོས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཡོལ་བའི་མདུན་དུ་གསེར་གྱི་སྤོས་ཁྲི་དེ་བཞག་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་དེའི་སྟེང་དུ་དྲི་ཞིམ་བདུག་སྤོས་བདུགས། ");
INSERT INTO bodn_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","དེ་ནས་ཁོས་གུར་མཆོག་གི་སྒོ་ཡོལ་དེ་ཡང་དཔྱངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","གུར་མཆོག་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་མདུན་དུ་ཁོས་སྦྱིན་སྲེག་གི་མཆོད་ཁྲི་དེ་བཞག་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ་དེའི་སྟེང་དུ་སྦྱིན་སྲེག་དང་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ཕུལ། ");
INSERT INTO bodn_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ཡང་མཇལ་འཕྲད་གུར་མཆོག་དང་མཆོད་ཁྲིའི་བར་དུ་ཁོས་ཁྲུས་གཞོང་བཞག་ནས་བཀྲུ་བའི་ཕྱིར་དེའི་ནང་དུ་ཆུ་བླུགས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","གཞོང་པ་དེའི་ནང་དུ་མོ་ཤེ་དང་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་རང་གི་རྐང་ལག་བཀྲུས། ");
INSERT INTO bodn_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གནང་བ་བཞིན་དུ། དེ་དག་ནམ་ཞིག་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འགྲོ་བའམ་མཆོད་ཁྲིའི་དྲུང་དུ་ཡོང་བའི་སྐབས་སུ་བཀྲུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","དེ་ནས་ཁོས་གུར་མཆོག་དང་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་ནས་བསྐོར་བའི་ཁྱམས་ར་དེ་བསྒྲེངས་ཤིང་། ཁྱམས་རའི་སྒོ་ཡོལ་དེ་དཔྱངས། དེ་ལྟར་མོ་ཤེ་ཡིས་ལས་ཀ་དེ་བསྒྲུབས་ནས་རྫོགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","དེ་ནས་སྤྲིན་གྱིས་མཇལ་འཕྲད་གུར་མཆོག་གཡོགས་པ་དང་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་ཀྱང་གུར་མཆོག་དེར་ཁྱབ། ");
INSERT INTO bodn_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","མོ་ཤེ་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་འགྲོ་མ་ནུས་ཏེ། གང་ལ་ཟེར་ན། གུར་མཆོག་སྟེང་དུ་སྤྲིན་ཕུང་བཞུགས་ཤིང་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་ཀྱིས་གུར་མཆོག་ཁྱབ་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་བགྲོད་ལམ་ཀུན་ཏུ་འདི་ལྟར་ཡིན་ཏེ། ནམ་ཞིག་སྤྲིན་དེ་གུར་མཆོག་ནས་བཏེགས་པའི་ཚེ། ཁོ་རྣམས་རང་གི་ལམ་དུ་ཆས། ");
INSERT INTO bodn_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","སྤྲིན་ཡར་མ་བཏེགས་ཚེ། ཁོ་ཚོ་དེ་མུར་སྡོད་ཅིང་། ནམ་ཞིག་སྤྲིན་བཏེགས་པའི་ཚེ་ཁོ་ཚོ་ཡང་བསྐྱར་ལམ་དུ་ཆས། ");
INSERT INTO bodn_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ཁོ་ཚོའི་བགྲོད་ལམ་ཀུན་ཏུ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྲིན་ཕུང་ནི་ཉིན་མོར་གུར་མཆོག་སྟེང་དུ་བཞུགས་པ་དང་། མཚན་མོར་ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་ཚང་མའི་མཐོང་ལམ་ལ་སྤྲིན་ནང་དུ་མེ་ཡོད་པ་ཡིན་ནོ།། །། ");
INSERT INTO bodn_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མཇལ་འཕྲད་གུར་མཆོག་ནས་མོ་ཤེ་ཞལ་འབོད་གནང་སྟེ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ཁྱོད་རྣམས་ལས་མི་སུ་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྒོ་ཕྱུགས་ཀྱི་མཆོད་པ་འབུལ་བའི་ཚེ། ཁྱོད་ཀྱི་མཆོད་པ་དེ་བ་ཁྱུ་དང་ར་ལུག་གི་ཁྱུ་ནས་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","གལ་སྲིད་ཁོས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་མཆོད་པ་ནི་བ་གླང་ཡིན་ན། གླང་ཐུག་སྐྱོན་གྱིས་མ་གོས་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཁོང་གི་ཐུགས་ལ་འབབ་ཕྱིར་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་འཁྲིད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","རང་གི་སྡིག་པ་བཤག་པའི་ཕྱིར། ཁོས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་ཕྱུགས་ཟོག་གི་མགོ་ལ་ལག་པ་འཇོག་དགོས། དེ་ལྟར་བྱས་ན་དཀོན་མཆོག་ཡ་ཝཱེའི་ཐུགས་དང་ལྡན་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","དེ་ནས་ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་གླང་ཁ་ཆུང་དེ་བཤའ་དགོས་ཤིང་། ཨ་རོན་གྱི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ཀྱིས་ཁྲག་ཁྱེར་འོངས་ཏེ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ཡོད་པའི་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ཁོས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་ཕྱུགས་ཟོག་གི་པགས་པ་བཤུས་ནས་དེའི་ཤ་ལྷུ་ལྷུ་རུ་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","དེ་ནས་མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་མཆོད་ཁྲིའི་སྟེང་མེ་སྦར་བ་དང་། མེའི་སྟེང་དུ་བུད་ཤིང་བསྒྲིག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ཨ་རོན་གྱི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ཀྱིས། ལྷུ་རྣམས་མགོ་དང་ཚིལ་བཅས་མཆོད་ཁྲིའི་སྟེང་མེ་འབར་བའི་བུད་ཤིང་གི་ཐོག་ཏུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","སྦྱིན་སྲེག་གི་ནང་ཁྲོལ་དང་རྐང་ལག་རྣམས་ཆུས་གཙང་མར་བཀྲུས་ནས། མཆོད་དཔོན་གྱིས་དེ་ཡོངས་སུ་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས། དེ་ནི་སྦྱིན་སྲེག་དང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","གལ་སྲིད་ཁོས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་མཆོད་པ་ནི་ར་ལུག་གི་ཁྱུ་གང་ནས་ཡིན་ན། ཕོ་ཕྱུགས་སྐྱོན་གྱི་དྲི་མས་མ་གོས་པ་ཞིག་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ཁོས་མཆོད་ཁྲིའི་བྱང་ཕྱོགས་སུ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕྱུགས་དེ་བཤས་ནས། ཨ་རོན་གྱི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ཀྱིས་དེའི་ཁྲག་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ཁོས་སྦྱིན་སྲེག་དེའི་ཤ་ལྷུ་ལྷུ་རུ་བཅད་ནས། མཆོད་དཔོན་གྱིས་ལྷུ་རྣམས་མགོ་དང་ཚིལ་བཅས་མཆོད་ཁྲིའི་སྟེང་མེ་འབར་བའི་བུད་ཤིང་གི་ཐོག་ཏུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ནང་ཁྲོལ་དང་རྐང་ལག་རྣམས་ཆུས་གཙང་མར་བཀྲུས་ནས། མཆོད་དཔོན་གྱིས་དེ་ཡོངས་སུ་ཕུལ་ཏེ་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས། དེ་ནི་སྦྱིན་སྲེག་དང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","གལ་སྲིད་ཁོས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་སྦྱིན་སྲེག་གི་མཆོད་པ་ནི་འདབ་ཆགས་ཡིན་ན། བྱ་ཐི་བའམ་ཕུག་རོན་ཆུང་ངུ་མཆོད་པར་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","མཆོད་དཔོན་གྱིས་འདབ་ཆགས་མཆོད་ཁྲིའི་རྩར་ཁྱེར་འོངས་ནས་དེའི་སྐེ་གཅུ་བ་དང་མགོ་ཕྲལ་ཏེ་མཆོད་ཁྲིའི་སྟེང་སྦར་བ་དང་། ཁྲག་ནི་མཆོད་ཁྲིའི་ལོགས་སུ་བཞུར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ཡང་ཕོ་བ་དང་བྱ་སྒྲོ་རྣམས་བཏོན་ཏེ། མཆོད་ཁྲིའི་ཤར་ཕྱོགས་སུ་ཐལ་བ་འཕོ་སར་གཡུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","དེ་ནས་ཁོས་འདབ་ཆགས་ཀྱི་གཤོག་པ་གཉིས་ནས་བཟུང་སྟེ་རྒྱོང་བར་བྱེད་ཀྱང་དུམ་བུར་གཅོད་པར་མི་བྱ་སྟེ། མཆོད་དཔོན་གྱིས་མཆོད་ཁྲིའི་སྟེང་འབར་བའི་བུད་ཤིང་གི་ཐོག་ཏུ་སྦྱིན་སྲེག་གཏོང་དགོས་པ་དང་། དེ་ནི་སྦྱིན་སྲེག་དང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","གལ་སྲིད་མི་ཞིག་གིས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་ཡིན་ན། གྲོ་ཞིབ་མཆོད་པར་འབུལ་དགོས་ཤིང་། དེའི་སྟེང་དུ་སྣུམ་ལྡུག་པ་དང་། སྤོས་དཀར་ཡང་དེའི་སྟེང་དུ་བཞག་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ཨ་རོན་གྱི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ཀྱི་མདུན་དུ་འཁྱེར་དགོས་ལ། མཆོད་དཔོན་གྱིས་གྲོ་ཞིབ་ཁྱོར་བ་གང་ལེན་པ་དང་། ཡང་སྣུམ་ཅུང་ཙམ་དང་སྤོས་དཀར་ཡོངས་རྫོགས་བླངས་ནས། དྲན་རྟེན་དུ་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","འབྲུ་རིགས་ཀྱི་ལྷག་མ་རྣམས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་དབང་ཞིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ཀུན་ལས་དམ་པའི་མཆོག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","གལ་སྲིད་ཐབ་ལ་བསྲེགས་པའི་འབྲུ་རིགས་མཆོད་པར་འབུལ་བ་ཡིན་ན། གྲོ་ཞིབ་ཀྱི་སྐྱུར་མེད་བག་ལེབ་སྣུམ་བསྲེས་མ་དང་། ཡང་ན་སྐྱུར་མེད་གོར་ལེབ་སྲབ་བུ་སྣུམ་བྱུགས་མ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","གལ་སྲིད་ཁྱོད་ཀྱིས་ལྕགས་སླང་སྟེང་གི་འབྲུ་རིགས་མཆོད་པར་འབུལ་བ་ཡིན་ན། སྣུམ་བསྲེས་པའི་སྐྱུར་མེད་གྲོ་ཞིབ་ཡིན་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","དུམ་བུར་བགོས་ནས་དེ་ལ་སྣུམ་ལྡུག་དགོས། དེ་ནི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","གལ་སྲིད་སླ་ངའི་ནང་བསྲེགས་པའི་འབྲུ་རིགས་མཆོད་པར་འབུལ་བ་ཡིན་ན། དེ་ནི་སྣུམ་དང་གྲོ་ཞིབ་ཀྱིས་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","དེ་བཞིན་བཟོས་པའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཁྱེར་ནས་མཆོད་དཔོན་ལ་སྤྲོད་པ་དང་། མཆོད་དཔོན་གྱིས་མཆོད་ཁྲིའི་མདུན་དུ་འཁྱེར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","མཆོད་དཔོན་གྱིས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ལས་དྲན་རྟེན་གྱི་སྐལ་བླངས་ནས་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས་ཤིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","འབྲུ་རིགས་ཀྱི་ལྷག་མ་རྣམས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་དབང་ཞིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ཀུན་ལས་དམ་པའི་མཆོག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་གང་ཡིན་ཡང་སྐྱུར་རྩི་འདྲེས་མི་རུང་སྟེ། ཁྱོད་རྣམས་ཀྱིས་སྐྱུར་རྩི་དང་སྦྲང་རྩི་གང་ཡིན་ཡང་དེ་བསྲེགས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་འབུལ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","དེ་དག་ཐོག་ཕུད་ཀྱི་མཆོད་པ་རུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་ཆོག་མོད། འོན་ཀྱང་མཆོད་ཁྲིའི་སྟེང་དྲི་ཞིམ་གྱི་མཆོད་པར་འབུལ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་གང་ཡིན་ཡང་དེ་ལ་ཚྭ་འདེབས་དགོས་ཏེ། འབྲུ་རིགས་ཀྱི་མཆོད་པའི་སྟེང་དུ་ཁྱོད་དང་དཀོན་མཆོག་བར་ཞལ་ཆད་བཞག་པའི་ཚྭ་ནི་མེད་མི་རུང་། མཆོད་པ་ཐམས་ཅད་ཀྱི་སྟེང་དུ་ཚྭ་བཏབ་ནས་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","གལ་སྲིད་ལོ་ཏོག་གི་ཕུད་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབྲུ་རིགས་ཀྱི་མཆོད་པར་འབུལ་བ་ཡིན་ན། མེ་ལ་བསྲེགས་པའི་སྙེ་མ་གསར་ཐོན་ཏེ། རགས་མོར་བཏགས་པའི་འབྲུ་རིགས་གསར་པ་དེ་ཐོག་ཕུད་ཀྱི་འབྲུ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","སྣུམ་དང་སྤོས་དཀར་ཡང་དེའི་སྟེང་དུ་འཇོག་དགོས་ལ། དེ་ནི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ཡང་མཆོད་དཔོན་གྱིས་མཆོད་པ་ལས་དྲན་རྟེན་གྱི་སྐལ་ཏེ། རགས་མོར་བཏགས་པའི་འབྲུ་རིགས་གསར་པ་དང་སྣུམ་ཉུང་ཙམ་རེ་དང་། སྤོས་དཀར་ཡོངས་རྫོགས་བཅས་སྦྱིན་སྲེག་གཏོང་བ་དང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","གལ་སྲིད་མི་ཞིག་གིས་ཞི་བདེའི་མཆོད་པ་འབུལ་བ་དང་། བ་ཁྱུ་ལས་འབུལ་ན་ཕོ་ཕྱུགས་མོ་ཕྱུགས་གང་ཡིན་ཡང་སྐྱོན་གྱི་དྲི་མས་མ་གོས་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ཁོས་མཆོད་པར་འབུལ་བྱའི་ཕྱུགས་ཟོག་དེའི་མགོ་ལ་ལག་པ་བཞག་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་བཤའ་དགོས་ཤིང་། ཨ་རོན་གྱི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ཀྱིས་དེའི་ཁྲག་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ཞི་བདེའི་མཆོད་པ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་འབུལ་དགོས་པ་འདི་ལྟ་སྟེ། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་ནང་ཁྲོལ་སྟེང་གི་ཚིལ་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","མཁལ་མ་གཉིས་དང་དེའི་སྟེང་གི་ཚིལ་ཏེ་མཁལ་མའི་ལོགས་གཉིས་སུ་ཡོད་པའི་ཚིལ་དང་། མཆིན་པའི་རྩ་རྒྱུས་ནི་མཁལ་མ་དང་བཅས་ལེན་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","དེ་ཡང་ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་དེ་རྣམས་མཆོད་ཁྲིའི་སྟེང་གི་མེ་དང་བུད་ཤིང་དང་། སྦྱིན་སྲེག་བཅས་ཀྱི་སྟེང་ལ་བཞག་ནས་སྦར་དགོས་ལ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ཅི་སྟེ་མི་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པའི་ཕྱིར་ཞི་བདེའི་མཆོད་པ་འབུལ་བ་དང་། ར་ལུག་གི་ཁྱུ་ལས་འབུལ་བ་ཡིན་ན་ཕོ་ཕྱུགས་མོ་ཕྱུགས་གང་ཡིན་ཡང་། དེ་ནི་སྐྱོན་གྱི་དྲི་མས་མ་གོས་པ་ཞིག་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","གལ་སྲིད་ཁོས་ལུ་གུ་ཞིག་མཆོད་པར་འབུལ་ན་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","མཆོད་པར་འབུལ་བྱའི་ཕྱུགས་ཟོག་གི་མགོ་ལ་ལག་པ་བཞག་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་བཤའ་དགོས་ཤིང་། ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་དེའི་ཁྲག་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","དེ་ནས་ཞི་བདེའི་མཆོད་པ་ལས། ཁོས་ཚིལ་བླངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་འབུལ་དགོས་པ་འདི་ལྟ་སྟེ། སྒལ་ཚིགས་ནས་བླངས་པའི་རྔ་མ་ཚོན་པོ་ཧྲིལ་པོ་དང་། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་ནང་ཁྲོལ་སྟེང་གི་ཚིལ་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","མཁལ་མ་གཉིས་དང་དེའི་སྟེང་གི་ཚིལ་ཏེ་མཁལ་མའི་ལོགས་གཉིས་སུ་ཡོད་པའི་ཚིལ་དང་། མཆིན་པའི་རྩ་རྒྱུས་ནི་མཁལ་མ་དང་བཅས་ལེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ཡང་མཆོད་དཔོན་གྱིས་དེ་རྣམས་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས་ལ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞལ་ཟས་སུ་ཕུལ་བའི་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","གལ་སྲིད་སུ་ཞིག་གི་མཆོད་པ་ནི་ར་ཞིག་ཡིན་ན། དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","དེའི་མགོ་ལ་ལག་པ་བཞག་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་བཤའ་དགོས་པ་དང་། ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་དེའི་ཁྲག་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ཡང་མཆོད་པ་དེ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས་པ་འདི་ལྟ་སྟེ། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་ནང་ཁྲོལ་སྟེང་གི་ཚིལ་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","མཁལ་མ་གཉིས་དང་དེའི་སྟེང་གི་ཚིལ་ཏེ་མཁལ་མའི་ལོགས་གཉིས་སུ་ཡོད་པའི་ཚིལ་དང་། མཆིན་པའི་རྩ་རྒྱུས་དེ་མཁལ་མ་དང་བཅས་ལེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","མཆོད་དཔོན་གྱིས་དེ་དག་དྲི་ཞིམ་མེ་མཆོད་ཀྱི་ཞལ་ཟས་སུ་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས་ལ། ཚིལ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེའི་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ཁྱོད་རྣམས་ཀྱི་སྡོད་གནས་ཐམས་ཅད་དུ་ཚིལ་དང་ཁྲག་གང་ཡིན་ཡང་བཟའ་མི་རུང་ལ། དེ་ནི་ཁྱོད་ཅག་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་དགོས་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག གལ་སྲིད་སུ་ཞིག་གིས་མ་ཤེས་པར་སྡིག་པ་སྤྱད་ཅིང་། བྱ་བ་གང་རུང་གི་སྟེང་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་རྣམས་ལས་གཅིག་དང་འགལ་བའམ། ");
INSERT INTO bodn_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ཡང་ན་སྣུམ་གྱིས་བྱུགས་པའི་མཆོད་དཔོན་གྱིས་སྡིག་པ་བྱས་ནས། མི་རྣམས་ཉེས་པའི་ནང་ལྷུང་དུ་བཅུག་ན། རང་གིས་བྱས་པའི་སྡིག་པའི་དོན་དུ་སྒོ་ཕྱུགས་ལས་གླང་ཐུག་སྐྱོན་མེད་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ཁོས་གླང་ཐུག་དེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ཁྲིད་ནས། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་གླང་ཐུག་གི་མགོ་ལ་ལག་པ་བཞག་ནས་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","སྣུམ་གྱིས་བྱུགས་པའི་མཆོད་དཔོན་གྱིས་གླང་ཐུག་གི་ཁྲག་ཉུང་ཙམ་བླངས་ནས་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་འཁྱེར་འོང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","མཆོད་དཔོན་གྱིས་མཛུབ་མོ་ཁྲག་ནང་བསྒྲེས་ནས། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་དམ་པའི་གནས་ཀྱི་ཡོལ་བར་གཏད་ནས་ལན་བདུན་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ཡང་ཁྲག་ཉུང་ཙམ་ཞིག་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འབྱུག་དགོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་སྤོས་སྒྲོམ་གྱི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས་པ་དང་། དེ་ནས་གླང་ཐུག་གི་ཁྲག་ལྷག་མ་ཡོངས་རྫོགས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་ཡོད་པའི་སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་ལྡུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ཡང་སྡིག་བཤགས་མཆོད་པར་འབུལ་བའི་གླང་ཐུག་དེའི་ཚིལ་ཐམས་ཅད་དེ། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་ནང་ཁྲོལ་སྟེང་གི་ཚིལ་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","མཁལ་མ་གཉིས་དང་དེའི་ཚིལ་ཏེ་མཁལ་མའི་ལོགས་གཉིས་ཀྱི་ཚིལ་དང་། མཆིན་པའི་རྩ་རྒྱུས་དེ་མཁལ་མ་དང་བཅས་ལེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","དེ་ནི་ཞི་བདེའི་མཆོད་པར་ཕུལ་བའི་གླང་ཐུག་ནས་བླངས་པ་བཞིན་ཡིན་དགོས་ཤིང་། མཆོད་དཔོན་གྱིས་དེ་རྣམས་སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་སྟེང་སྦར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ཡིན་ནའང་གླང་ཐུག་གི་པགས་པ་དང་ཤ་ཐམས་ཅད་དང་། མགོ་དང་བརླ་རྐང་དང་ནང་ཁྲོལ་དང་ལྕི་བ་བཅས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","གླང་ཐུག་ཧྲིལ་པོ་སྒར་ཁའི་ཕྱི་རོལ་གྱི་གཙང་ས་སྟེ། ཐལ་བ་འཕོ་སའི་གནས་སུ་ཁྱེར་ནས་བུད་ཤིང་སྟེང་དུ་མེར་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","གལ་སྲིད་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ཀྱིས་མ་ཤེས་པར་ཉེས་སྐྱོན་བཟོས་པ་དང་། བྱ་བ་གང་རུང་གི་སྟེང་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་རྣམས་ལས་གཅིག་དང་འགལ་ནས་ཉེས་པ་བསགས་ཡོད་ཅིང་། མི་ཚོགས་ཀྱིས་སྦས་པའི་དོན་དེ་མ་རྟོགས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","དེ་རྣམས་ཀྱིས་སྡིག་པ་བསགས་པ་ཤེས་མ་ཐག་སྒོ་ཕྱུགས་ལས་གླང་ཐུག་ཅིག་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས་པ་དང་། དེ་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་འཁྲིད་འོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","མི་ཚོགས་ཀྱི་རྒན་པོ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གླང་ཐུག་གི་མགོ་ལ་ལག་པ་བཞག་ནས། དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","སྣུམ་གྱིས་བྱུགས་པའི་མཆོད་དཔོན་གྱིས་གླང་ཐུག་གི་ཁྲག་ལས་ཉུང་ཙམ་བླངས་ཏེ་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་འཁྱེར་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","མཆོད་དཔོན་གྱིས་མཛུབ་མོ་ཁྲག་ནང་བསྒྲེས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཡོལ་བར་གཏད་དེ་ལན་བདུན་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ཡང་ཁྲག་ཉུང་ཙམ་ཅིག་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འབྱུག་དགོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་མཆོད་ཁྲིའི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས་པ་དང་། དེ་ནས་ཁྲག་ལྷག་མ་ཡོངས་རྫོགས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་ཡོད་པའི་སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་ལྡུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ཁོས་དེའི་ཚིལ་ཐམས་ཅད་བླངས་ནས་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་གཏོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ཁོས་སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་དེ་ཇི་ལྟར་ཕུལ་བ་བཞིན་དུ་གླང་ཐུག་འདི་ཡང་དེ་ལྟར་འབུལ་དགོས་ལ། མཆོད་དཔོན་གྱིས་དེ་དག་གི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་དེ་ཚོར་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ཡང་ཁོས་གླང་ཐུག་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་ཁྱེར་ནས། གླང་ཐུག་སྔོན་མ་དེ་བཞིན་མེར་བསྲེག་དགོས། དེ་ནི་མི་ཚོགས་ཀྱི་སྡིག་བཤགས་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","གལ་སྲིད་འགོ་དཔོན་ཞིག་གིས་སྡིག་པ་སྤྱད་ཅིང་། བྱ་བ་གང་རུང་གི་སྟེང་མ་ཤེས་པར་ཁོའི་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་རྣམས་ལས་གཅིག་དང་འགལ་ཏེ་ཉེས་པ་བསགས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ཁོས་རང་གིས་སྡིག་པ་བྱས་པ་ཤེས་མ་ཐག ར་ཐུག་སྐྱོན་གྱི་དྲི་མས་མ་གོས་པ་ཞིག་ཁྲིད་འོངས་ནས་མཆོད་པར་འབུལ་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ར་ཐུག་གི་མགོར་ལག་པ་བཞག་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་བཤའ་སའི་གནས་དེར་བཤའ་དགོས་ལ། དེ་ནི་སྡིག་བཤགས་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","མཆོད་དཔོན་གྱིས་མཛུབ་མོ་སྡིག་བཤགས་མཆོད་པར་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་ཁྲག་ནང་བསྒྲེས་ནས། སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས་པ་དང་། དེ་ནས་ཁྲག་ལྷག་མ་སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་ལྡུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","དེ་ཡང་ཞི་བདེའི་མཆོད་པའི་ཚིལ་དང་འདྲ་བར་དེའི་ཚིལ་ཐམས་ཅད་མཆོད་ཁྲིའི་སྟེང་བསྲེག་དགོས་པ་དང་། མཆོད་དཔོན་གྱིས་ཁོའི་ཕྱིར་དུ་སྡིག་པ་བཤགས་ནས་ཁོ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","གལ་སྲིད་མི་རྣམས་ལས་སུ་ཞིག་གིས་མ་ཤེས་པར་སྡིག་པ་བྱས་ཤིང་། བྱ་བ་གང་རུང་གི་སྟེང་དུ་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་རྣམས་ལས་གཅིག་ལ་འགལ་ནས་ཉེས་པ་བསགས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ཁོས་རང་གིས་སྡིག་པ་བྱས་པ་ཤེས་མ་ཐག་རང་བྱས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ་ར་མ་སྐྱོན་མེད་པ་ཞིག་ཁྲིད་ཡོང་སྟེ་མཆོད་པར་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","སྡིག་བཤགས་མཆོད་པར་འབུལ་བའི་ཕྱུགས་ཟོག་གི་མགོ་ལ་ལག་པ་བཞག་ནས་སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་འབུལ་བའི་གནས་སུ་དེ་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","མཆོད་དཔོན་གྱིས་མཛུབ་མོ་ཕྱུགས་ཟོག་གི་ཁྲག་ནང་བསྒྲེས་ཏེ། སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས་པ་དང་། ཁྲག་ལྷག་མ་ཡོངས་རྫོགས་སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་ལྡུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","དེ་ཡང་ཞི་བདེའི་མཆོད་པར་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་ཚིལ་དང་འདྲ་བར་དེའི་ཚིལ་ཐམས་ཅད་ལེན་པ་དང་། མཆོད་དཔོན་གྱིས་ཚིལ་རྣམས་མཆོད་ཁྲིའི་སྟེང་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་མཆོད་པར་འབུལ་དགོས། མཆོད་དཔོན་གྱིས་ཁོའི་ཕྱིར་དུ་སྡིག་པ་བཤགས་ནས་ཁོ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","གལ་སྲིད་མི་ཞིག་གིས་ལུག་ཅིག་ཁྲིད་འོངས་ཏེ་སྡིག་བཤགས་མཆོད་པར་འབུལ་ན། མོ་ལུག་སྐྱོན་མེད་པ་ཞིག་ཁྲིད་ཡོང་ནས་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ཁོས་སྡིག་བཤགས་མཆོད་པར་འབུལ་བའི་ཕྱུགས་ཟོག་གི་མགོ་ལ་ལག་པ་བཞག་ནས། སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་བཤའ་བའི་གནས་སུ་དེ་བཤས་ནས་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","མཆོད་དཔོན་གྱིས་མཛུབ་མོ་སྡིག་བཤགས་མཆོད་པར་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་ཁྲག་ནང་དུ་བསྒྲེས་ཏེ། སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས་པ་དང་། དེ་ནས་ཁྲག་ལྷག་མ་ཡོངས་རྫོགས་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་ལྡུག་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ཡང་ཞི་བདེའི་མཆོད་པར་ཕུལ་བའི་ལུག་གི་ཚིལ་དང་འདྲ་བར་དེའི་ཚིལ་ཐམས་ཅད་ལེན་པ་དང་། མཆོད་དཔོན་གྱིས་ཚིལ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་ཁྲིའི་མེ་མཆོད་ཐོག་ཏུ་སྦྱིན་སྲེག་གཏོང་དགོས། མཆོད་དཔོན་གྱིས་ཁོས་བསགས་པའི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་། ཁོ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","གལ་སྲིད་མི་ཞིག་གིས་སྡིག་པ་བྱས་པ་སྟེ། མནའ་བསྐྱལ་བའི་གཏམ་ཐོས་ཤིང་ཁོ་རང་དཔང་བོ་ཡིན་ནའང་། ཁོས་ཅི་མཐོང་བ་གང་ཤེས་པ་དེ་སྙན་སེང་མ་ཞུས་ན། ངེས་པར་རང་གི་ཆད་པ་འཁུར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ཡང་མི་ཞིག་གིས་མི་གཙང་བའི་རྫས་གང་རུང་སྟེ། གཅན་གཟན་མི་གཙང་བའི་རོའམ། སྒོ་ཕྱུགས་མི་གཙང་བའི་རོའམ། ལྟོ་འགྲོ་སེམས་ཅན་མི་གཙང་བའི་རོ་ལ་རེག་པ་གང་ཡིན་ཡང་། མི་དེས་མ་ཤེས་ནའང་མི་གཙང་བ་ཡིན་པས་ཉེས་པ་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ཡང་ན་ཁོས་མི་ལས་བྱུང་བའི་མི་གཙང་བའི་རྫས་གང་རུང་སྟེ། མི་བཙོག་པར་བྱེད་པའི་མི་གཙང་བའི་རྫས་གང་རུང་ཞིག་ལ་རེག་ན། ཁོས་མ་ཤེས་ནའང་དེ་མི་གཙང་བ་ཡིན་པ་རྟོགས་ན་དེ་ནི་ཉེས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ད་དུང་མི་ཞིག་གིས་ཁ་ནས་ཅི་མི་སྙམ་པར་མནའ་བསྐྱལ་ན། ངན་སེམས་བཟང་སེམས་གང་ཞིག་བཅངས་ནས་བསྐྱལ་ནའང་། དེས་འཛེམ་དོགས་མེད་པར་དོན་གང་ཞིག་གི་སྟེང་ཅི་མི་སྙམ་པར་མནའ་བསྐྱལ་བ་ཡིན་ན། ནམ་ཞིག་ཁོས་ཤེས་མ་ཐག་ཏུ་དེའི་ནང་གི་དོན་ཞིག་གི་སྟེང་ཉེས་པ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ཁོ་ལ་དེའི་ནང་གི་དོན་གང་རུང་ཞིག་གི་སྟེང་ཉེས་པ་ཡོད་ཚེ་སྡིག་པ་མཐོལ་བཤགས་བྱེད་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","རང་བྱས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ། རང་གི་ཉེས་སེལ་མཆོད་པའི་ཕྱུགས་ཏེ། ལུག་ཁྱུ་ལས་མོ་ལུག་གཅིག་གམ་ཡང་ན་ར་མ་གཅིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས་ཤིང་། མཆོད་དཔོན་གྱིས་ཁོ་རང་གི་སྡིག་པ་བཤག་པར་བྱེད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","གལ་སྲིད་མི་དེས་ལུ་གུ་གཅིག་འབུལ་མི་ནུས་ན། རང་བྱས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ། བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཉེས་སེལ་མཆོད་པར་འབུལ་དགོས་ཏེ། གཅིག་ནི་སྡིག་བཤགས་མཆོད་པར་འབུལ་བ་དང་། ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་འབུལ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ཁོས་དེ་རྣམས་མཆོད་དཔོན་གྱི་དྲུང་དུ་འཁྱེར་འོང་བ་དང་། མཆོད་དཔོན་གྱིས་ཐོག་མར་སྡིག་བཤགས་མཆོད་པ་འབུལ་བ་སྟེ། འདབ་ཆགས་ཀྱི་སྐེ་གཅུས་ནའང་དེ་གཅོད་པར་མི་བྱ། ");
INSERT INTO bodn_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","མཆོད་དཔོན་གྱིས་སྡིག་བཤགས་མཆོད་པའི་འདབ་ཆགས་ཀྱི་ཁྲག་ཉུང་ཙམ་ཞིག་མཆོད་ཁྲིའི་ལོགས་སུ་གཏོར་བ་དང་། ཁྲག་ལྷག་མ་རྣམས་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་ལྡུག་དགོས། དེ་ནི་སྡིག་བཤགས་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ཡང་ཁོས་སྲོལ་ཡིག་བཞིན་དུ་འདབ་ཆགས་གཞན་པ་དེ་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས་ཤིང་། མཆོད་དཔོན་གྱིས་མི་དེའི་རང་བྱས་ཀྱི་སྡིག་པ་བཤག་དགོས་ལ། མི་དེར་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","གལ་སྲིད་ཁོས་བྱ་ཐི་བ་གཉིས་སམ་ཡང་ན་ཕུག་རོན་ཆུང་ངུ་གཉིས་འབུལ་མི་ནུས་ན། རང་བྱས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ་གྲོ་ཞིབ་ཨེ་ཕཱ་གཅིག་གི་བཅུ་ཆ་གཅིག་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། དེའི་སྟེང་སྣུམ་དང་སྤོས་དཀར་གང་ཡང་འཇོག་མི་དགོས། ཅི་ལ་ཞེ་ན། དེ་ནི་སྡིག་བཤགས་མཆོད་པ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","དེ་ཡང་ཁོས་གྲོ་ཞིབ་དེ་མཆོད་དཔོན་གྱི་དྲུང་དུ་འཁྱེར་འོང་བ་དང་། མཆོད་དཔོན་གྱིས་དེ་ལས་ཁྱོར་བ་གང་དྲན་རྟེན་དུ་བླངས་ནས། མཆོད་ཁྲིའི་སྟེང་དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་མཆོད་ཀྱི་ཁར་སྦྱིན་སྲེག་གཏོང་དགོས་ལ། དེ་ནི་སྡིག་བཤགས་མཆོད་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ཡང་ཁོས་དོན་དེ་རྣམས་ཀྱི་ཐད་བསགས་པའི་སྡིག་པ་གང་ཡིན་ནའང་། མཆོད་དཔོན་གྱིས་མི་དེའི་སྡིག་པ་དེ་བཤག་པར་བྱ་ཞིང་དེ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར། དེའི་ལྷག་མ་ནི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་འདྲ་བར་ཡོངས་རྫོགས་མཆོད་དཔོན་ལ་དབང་བར་འགྱུར་ཞེས་བཤད་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","གལ་སྲིད་མི་ཞིག་གིས་མ་ཤེས་པར་དཀོན་མཆོག་ཡ་ཝཱེའི་མཆོད་རྫས་དམ་པ་རྣམས་ཀྱི་སྟེང་དུ་སྡིག་པ་བྱས་ནས་ཉེས་པ་བསགས་ན། ལུག་ཁྱུ་ལས་སྐྱོན་མེད་པའི་ལུག་ཐུག་ཅིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཉེས་སེལ་མཆོད་པ་རུ་འབུལ་བའམ། ཡང་ན་གནས་མཆོག་གི་སྲང་ལྟར་དངུལ་སྲང་གི་ཚོད་རྩིས་བྱས་པའི་རིན་འབབ་བཞིན་དུ་ཉེས་སེལ་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ཁོས་མཆོད་རྫས་དམ་པའི་ཐད་ནོར་འཛོལ་གང་ཞིག་བཟོས་པར་སྐྱིན་ཚབ་འཇལ་ཆེད་དང་། དེའི་ཁར་ལྔ་ཆ་གཅིག་བསྣན་ཏེ་མཆོད་དཔོན་ལ་སྤྲོད་པ་དང་། མཆོད་དཔོན་གྱིས་ཉེས་པ་སེལ་བྱེད་ལུག་ཐུག་གིས་ཁོའི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་། ཁོ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","གལ་སྲིད་མི་ཞིག་གིས་དོན་གང་རུང་གི་སྟེང་དུ་སྡིག་པ་བྱས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་རྣམས་ལས་གཅིག་ལ་འགལ་ན། ཁོས་མ་ཤེས་ནའང་ཉེས་པ་རུ་བརྩི་ཞིང་རང་གི་ཆད་པ་འཁུར་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ཁོས་ལུག་ཁྱུ་ལས་ལུག་ཐུག་སྐྱོན་མེད་པ་ཞིག་འཁྲིད་ཡོང་བའམ། ཡང་ན་ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་འབབ་བཞིན། ཉེས་སེལ་མཆོད་པ་རུ་མཆོད་དཔོན་ལ་འབུལ་བ་དང་། མཆོད་དཔོན་གྱིས་ཁོའི་མ་ཤེས་མ་བསམ་ས་ནས་བྱས་པའི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་། དེ་ལ་སྡིག་སེལ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","དེ་ནི་ཉེས་སེལ་མཆོད་པ་ཡིན་ཏེ། ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་དངོས་སུ་ཉེས་པ་བཟོས་པའི་ཕྱིར་རོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","གལ་སྲིད་མི་ཞིག་གིས་སྡིག་པ་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འགལ་ཏེ། ཁྱིམ་མཚེས་ཀྱིས་ཁོ་ལ་བཅོལ་བའི་དངོས་པོའམ་གཏའ་མའི་སྟེང་གཡོ་སྒྱུའི་སྦྱོར་བ་སྤེལ་བའམ། འཕྲོག་པ། ཁྱིམ་མཚེས་ལ་བརྙས་བཅོས་བྱེད་པ། ");
INSERT INTO bodn_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","བོར་དངོས་རྙེད་ཅིང་གཡོ་སྒྱུའི་སྦྱོར་བ་སྤེལ་ནས་མནའ་རྫུན་མ་སྐྱེལ་བ་དང་། མིས་བྱེད་སྲིད་པའི་ལས་གང་ཅིའི་ཐད་ནས་སྡིག་པ་བྱེད་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ཁོས་སྡིག་པ་བྱས་ནས་ཉེས་པ་བསགས་ན། ཕྲོགས་ཏེ་ཁྱེར་བའམ་གཞན་ལ་བརྙས་བཅོས་བྱས་ནས་ཐོབ་པ། ཡང་ན་གཞན་གྱིས་ཁོ་ལ་བཅོལ་བ། ཡང་ན་ཁོས་རྙེད་པའི་བོར་དངོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ཡང་ན་མནའ་རྫུན་མ་བསྐྱལ་ནས་ཐོབ་པའི་དངོས་པོ་བཅས་གང་ཡིན་ཡང་ཕྱིར་སྤྲོད་དགོས་པ་སྟེ། ཁ་ཚང་ཕྱིར་སྤྲོད་དགོས་པར་མ་ཟད་དེའི་ཁར་ལྔ་ཆ་གཅིག་སྣོན་དགོས། ཁོ་ལ་ཉེས་པ་ཡོད་པ་རྩད་ཆོད་པའི་ཉིན་མོར་ལམ་སང་བདག་པོ་ལ་གུན་གསབ་སྤྲོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ཁོས་ལུག་ཁྱུ་ལས་སྐྱོན་མེད་པའི་ལུག་ཐུག་ཅིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཉེས་སེལ་མཆོད་པ་རུ་འབུལ་དགོས་པའམ། ཡང་ན་ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་འབབ་བཞིན་དུ། ཉེས་སེལ་མཆོད་པའི་ཕྱིར་མཆོད་དཔོན་ལ་སྤྲོད་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","མཆོད་དཔོན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཁོའི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་། མི་དེས་དོན་གང་ཞིག་བྱས་ནས་ཉེས་པ་བསགས་ནའང་སྡིག་སེལ་འཐོབ་པར་འགྱུར་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག སྦྱིན་སྲེག་གི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་མཆོད་པ་ནི་མཆོད་ཁྲིའི་སྟེང་ཞོགས་པའི་བར་དུ་མཚན་གང་པོར་འཇོག་དགོས་པ་དང་། མཆོད་ཁྲིའི་སྟེང་གི་མེ་ནི་ཆད་མེད་དུ་སྦར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","མཆོད་དཔོན་གྱིས་སོ་རས་སྲབ་བུའི་སྟོད་གོས་དང་སྨད་གོས་ལུས་ལ་གྱོན་ནས། སྦྱིན་སྲེག་གི་མཆོད་ཁྲིའི་སྟེང་ལྷག་པའི་ཐལ་བ་བླངས་ནས་མཆོད་ཁྲིའི་ལོགས་སུ་འཇོག་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","དེ་ནས་གོས་དེ་རྣམས་ཕུད་ནས་གོས་གཞན་དག་གྱོན་པ་དང་། ཐལ་བ་སྒར་ཁའི་ཕྱི་རོལ་གྱི་གནས་གཙང་སར་འཁྱེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ཡང་མཆོད་ཁྲི་སྟེང་གི་མེ་ནི་ཆད་མེད་དུ་འབར་དགོས་ཤིང་ཞི་མི་རུང་། ཉིན་རེའི་ཞོགས་པར་མཆོད་དཔོན་གྱིས་མཆོད་ཁྲིའི་སྟེང་དུ་བུད་ཤིང་སྦར་བ་དང་། དེའི་སྟེང་ཏུ་སྦྱིན་སྲེག་གི་མཆོད་པ་བཤམས་པར་མ་ཟད། ཞི་བདེའི་མཆོད་པའི་ཕྱུགས་ཟོག་གི་ཚིལ་རྣམས་སྦར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","མཆོད་ཁྲིའི་སྟེང་གི་མེ་ནི་རྒྱུན་ཆད་མེད་པར་འབར་དགོས་ཤིང་ནམ་ཡང་ཞི་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","འབྲུ་རིགས་ཀྱི་མཆོད་པའི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་མཆོད་ཁྲིའི་མདུན་ནས་མཆོད་པ་འདི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","མཆོད་དཔོན་གྱིས་འབྲུ་རིགས་ལས་གྲོ་ཞིབ་ཁྱོར་བ་གང་ཙམ་ལེན་པ་དང་། སྣུམ་ཉུང་ཙམ་དང་འབྲུ་རིགས་མཆོད་པའི་སྟེང་གི་སྤོས་དཀར་ཐམས་ཅད་བླངས་ནས། དེ་རྣམས་དྲན་རྟེན་གྱི་སྐལ་དུ་མཆོད་ཁྲིའི་སྟེང་སྦར་དགོས་ལ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མཆོད་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་འབྲུ་རིགས་ཀྱི་མཆོད་འཕྲོ་བཟའ་ཞིང་། གནས་དམ་པ་རུ་སྐྱུར་མེད་བག་ལེབ་འདི་བཟའ་དགོས་པ་སྟེ། མཇལ་འཕྲད་གུར་མཆོག་གི་ར་སྐོར་ནང་དུ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","བསྲེག་གོར་ནང་དུ་སྐྱུར་རྩི་བསྲེ་མི་རུང་སྟེ། དེ་ནི་བདག་ལ་ཕུལ་བའི་མེ་མཆོད་རྣམས་ལས་བདག་གིས་དེ་དག་ལ་སྤྲད་པའི་སྐལ་ཡིན་པ་དང་། སྡིག་བཤགས་མཆོད་པ་དང་ཉེས་སེལ་མཆོད་པ་རྣམས་དང་འདྲ་བར་སྐལ་དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ཨ་རོན་གྱི་བུ་རྣམས་ལས་སྐྱེས་པ་ཀུན་གྱིས་དེ་བཟའ་བར་འགྱུར་ཞིང་། རྒྱུ་མཚན་དེ་ནི་མི་རབས་ནས་མི་རབས་བར་ཁྱོད་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ལས། ཁོ་རྣམས་ལ་ནམ་ཡང་འཐོབ་འོས་པའི་སྐལ་ཡིན། མཆོད་པ་འདི་ལ་རེག་མཁན་ཐམས་ཅད་དམ་པར་འགྱུར་ཞེས་སྨྲ་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","འདི་ནི་ཨ་རོན་ལ་སྣུམ་གྱིས་བྱུག་པའི་ཉིན་མོ་ཡིན་ལ། ཁོ་དང་ཁོའི་བུ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས་པའི་མཆོད་པ་ནི་འདི་ལྟ་སྟེ། ཨེ་ཕཱ་ཡི་བཅུ་ཆ་གཅིག་གི་གྲོ་ཞིབ་ནི་དུས་རྒྱུན་འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་བཞིན་འབུལ་བ་དང་། དེའི་ཕྱེད་ཀ་ཞོགས་པ་དང་ཕྱེད་ཀ་དགོང་མོ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","དེ་ནི་ལྕགས་སླང་ནང་སྣུམ་བསྲེ་དགོས་ལ། བསྲེ་སྦྱོར་ཡག་པོ་བྱས་རྗེས་བསྲེག་དགོས། འབྲུ་རིགས་ཀྱི་མཆོད་པ་བསྲེགས་ནས་ཚོས་པ་ན་དུམ་བུར་བགོས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་མཆོད་པར་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ཨ་རོན་གྱི་བུ་རྣམས་ལས་མཆོད་དཔོན་དུ་བྱུགས་པ་དེས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་འདི་འབུལ་དགོས་པ་དང་། ཡོངས་རྫོགས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་གཏོང་དགོས་ལ། དེ་ནི་དུས་གཏན་གྱི་བཀའ་ཁྲིམས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","མཆོད་དཔོན་གྱིས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ཡོངས་རྫོགས་ལྷག་ལུས་མེད་པར་བསྲེག་དགོས་པ་ལས་བཟའ་མི་རུང་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག སྡིག་བཤགས་མཆོད་པའི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་བཤའ་སའི་གནས་དེར་སྡིག་བཤགས་མཆོད་པའི་ཕྱུགས་ཟོག་བཤའ་དགོས། དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","སྡིག་བཤགས་མཆོད་པ་འབུལ་མཁན་མཆོད་དཔོན་གྱིས་འབུལ་བ་དེ་བཟའ་རུང་ལ། གནས་དམ་པ་སྟེ་མཇལ་འཕྲད་གུར་མཆོག་གི་ར་སྐོར་ནང་དུ་བཟའ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","མཆོད་པ་དེའི་ཤ་ལ་རེག་མཁན་ཐམས་ཅད་ནི་དམ་པ་ཡིན་དགོས་པ་དང་། དེའི་ཁྲག་སུའི་གོས་ལ་འགོས་པ་ཡིན་ན། ཁྱོད་ཀྱིས་གནས་དམ་པ་རུ་ཁྲག་འགོས་པའི་གོས་དེ་གཙང་མར་བཀྲུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","མཆོད་རྫས་དེ་གདུ་བྱེད་ཀྱི་རྫ་སྣོད་གཅོག་དགོས། གལ་སྲིད་དེ་ནི་ལི་སྣོད་ལས་གདུས་པ་ཡིན་ན། དེ་གཙང་མར་དབྱི་དགོས་པ་དང་ཆུ་ཡིས་བཤལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན་ལ། མཆོད་དཔོན་རྣམས་ལས་སྐྱེས་པ་གང་ཡིན་གྱིས་བཟའ་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","གལ་སྲིད་སྡིག་བཤགས་མཆོད་པ་གང་རུང་གི་ཁྲག་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་ཁྱེར་འོངས་པ་ཡིན་ན། གནས་དམ་པ་རུ་ཉེས་ཆད་བསལ་བའི་ཕྱིར་ཤ་དེ་བཟའ་མི་རུང་། དེ་ནི་མེ་ལ་བསྲེག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ཉེས་སེལ་མཆོད་པའི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། མཆོད་པ་འདི་ནི་ཀུན་ལས་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་གནས་གང་དུ་བཤས་ན་སྡིག་བཤགས་མཆོད་བྱ་ཡང་གནས་དེ་རུ་བཤའ་དགོས་ལ། དེའི་ཁྲག་ནི་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","མཆོད་དཔོན་གྱིས་དེའི་ཚིལ་ཐམས་ཅད་དེ། རྔ་མ་ཚོན་པོ་དང་། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","མཁལ་མ་གཉིས་དང་དེའི་སྟེང་གི་ཚིལ་ཏེ་མཁལ་མའི་ལོགས་གཉིས་སུ་ཡོད་པའི་ཚིལ་དང་། མཆིན་པའི་རྩ་རྒྱུས་ནི་མཁལ་མ་དང་བཅས་ལེན་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","མཆོད་དཔོན་གྱིས་དེ་རྣམས་མཆོད་ཁྲིའི་སྟེང་བསྲེགས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་འབུལ་དགོས། དེ་ནི་ཉེས་སེལ་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","མཆོད་དཔོན་རྣམས་ལས་སྐྱེས་པ་གང་ཡིན་གྱིས་དེ་བཟའ་རུང་ཞིང་། དེ་གནས་དམ་པར་བཟའ་དགོས་ལ། ཀུན་ལས་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","སྡིག་བཤགས་མཆོད་པ་ཅི་ལྟར་ཡིན་ན་ཉེས་སེལ་མཆོད་པའང་དེ་བཞིན་ཡིན་ལ། དེ་གཉིས་ཀྱི་བཀའ་ཁྲིམས་གཅིག་ཡིན། སྡིག་པ་བཤགས་མཁན་མཆོད་དཔོན་ལ་མཆོད་རྫས་དེ་འཐོབ་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","སྦྱིན་སྲེག་འབུལ་བའི་མཆོད་དཔོན་གྱིས་སུ་ཞིག་གི་དོན་དུ་སྦྱིན་སྲེག་བཏང་ནའང་། སྦྱིན་སྲེག་ཏུ་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་པགས་པ་ནི་མཆོད་དཔོན་དེ་ལ་དབང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","མེ་ཐབ་ནང་དུ་བསྲེགས་པའམ། སླ་ང་དང་ལྕགས་སླང་ནང་དུ་བཟོས་པའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་གང་ཡིན་རུང་། ཐམས་ཅད་མཆོད་པ་འབུལ་བའི་མཆོད་དཔོན་ལ་དབང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","འབྲུ་རིགས་ཀྱི་མཆོད་པ་རྣམས་ལས་སྣུམ་གྱིས་བསྲེ་སྦྱོར་བྱས་པའམ། སྐམ་པོ་ཡིན་པ་གང་ཡིན་རུང་ཐམས་ཅད་ཨ་རོན་གྱི་བུ་རྣམས་ལ་ཁྱད་མེད་དུ་བགོ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་ཞི་བདེའི་མཆོད་པ་རྣམས་ཀྱི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","གལ་སྲིད་གཏང་རག་གི་མཆོད་པ་འབུལ་ན། སྐྱུར་མེད་བག་ལེབ་སྣུམ་བསྲེས་མ་དང་། ཡང་ན་སྐྱུར་མེད་གོར་ལེབ་སྲབ་བུ་སྣུམ་བྱུགས་མ། གྲོ་ཞིབ་བག་ལེབ་སྣུམ་གྱིས་བསྲེ་སྦྱོར་ཡག་པོ་བྱས་པ་བཅས་གཏང་རག་གི་མཆོད་པ་དང་མཉམ་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","སྐྱུར་ལྡན་བག་ལེབ་དང་བཅས་གཏང་རག་ཏུ་འབུལ་བའི་ཞི་བདེའི་མཆོད་པ་ནི་མཆོད་པ་དང་མཉམ་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ཕུལ་བའི་མཆོད་པ་རྣམས་ལས་བག་ལེབ་གཅིག་རེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་དུ་འབུལ་བ་སྟེ། ཞི་བདེའི་མཆོད་པའི་ཕྱུགས་ཟོག་གི་ཁྲག་གཏོར་མཁན་མཆོད་དཔོན་ལ་དབང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","གཏང་རག་ཏུ་ཕུལ་བའི་ཞི་བདེའི་མཆོད་པའི་ཤ་ནི། མཆོད་པར་འབུལ་བའི་ཉིན་དེ་རང་དུ་བཟའ་དགོས་ཏེ། ཞོགས་པའི་བར་དུ་ཅི་ཡང་ལྷག་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","གལ་སྲིད་ཁོའི་མཆོད་པ་ནི་དམ་བཅའ་སྒྲུབ་པའི་མཆོད་པའམ། ཡང་ན་ཡིད་མོས་མཆོད་པ་ཡིན་ན། མཆོད་པར་འབུལ་བའི་ཉིན་དེ་རང་དུ་བཟའ་དགོས་ཤིང་། དེའི་ལྷག་མ་ནི་ཕྱི་ཉིན་ཡང་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","མཆོད་ཤ་ལྷག་མ་ནི་ཉིན་གསུམ་པར་མེ་ལ་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","གལ་སྲིད་ཞི་བདེའི་མཆོད་པར་ཕུལ་བའི་ཤ་རྣམས་ཉིན་གསུམ་པར་ཟོས་ན་དེ་ཐུགས་ལ་ལྡན་པར་མི་འགྱུར་ལ། གང་ཞིག་ཕུལ་བ་དེ་ཡང་མཆོད་པར་མི་བརྩི། མཆོད་པ་དེ་ནི་མི་གཙང་བ་ཡིན་པས་དེ་ཟ་མཁན་གྱིས་རང་གི་ཉེས་པ་འཁུར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","དེ་ཡང་མི་གཙང་བའི་རྫས་ལ་རེག་པའི་ཤ་ནི་བཟའ་མི་རུང་སྟེ་མེ་ལ་བསྲེག་དགོས། ཤ་གཞན་ལ་མཚོན་ན་གཙང་མ་ཡིན་པའི་མི་སུས་ཀྱང་ཤ་དེ་བཟའ་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","འོན་ཀྱང་མི་གཙང་བ་སུ་ཞིག་གིས་གལ་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་ཞི་བདེའི་མཆོད་པའི་ཤ་ཟོས་ན། མི་དེ་ནི་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","གལ་ཏེ་མི་ཞིག་གིས་མི་ལུས་ཀྱི་མི་གཙང་བའམ་ཕྱུགས་ཟོག་མི་གཙང་བ། ཡང་ན་ཞེ་མེར་བའི་རྫས་མི་གཙང་བ་གང་རུང་ལ་རེག་ནས། ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་ཞི་བདེའི་མཆོད་པའི་ཤ་ཟོས་ན། མི་དེ་ནི་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱ་ཞེས་བཤད་དགོས་པར་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག གླང་དང་ལུག་དང་ར་བཅས་ཀྱི་ཚིལ་གང་ཡང་ཁྱོད་རྣམས་ཀྱིས་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","རང་བཞིན་གྱིས་ཤི་བའམ་གཅན་གཟན་གྱིས་བསད་པའི་ཕྱུགས་ཟོག་གི་ཚིལ་ནི་གཞན་ཅི་རིགས་སུ་སྤྱད་ཆོག་མོད། འོན་ཀྱང་གཏན་ནས་བཟའ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","སུ་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་ཚིལ་ཟོས་པ་ཡིན་ན། མི་དེ་ནི་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ཁྱོད་རྣམས་ཀྱི་སྡོད་གནས་གང་དུའང་། འདབ་ཆགས་སམ་ཕྱུགས་ཟོག་གི་ཁྲག་གང་ཡིན་ཡང་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","སུ་ཞིག་གིས་ཁྲག་ཟོས་ན། མི་དེ་ནི་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱ་ཞེས་སྨྲ་དགོས་པར་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞི་བདེའི་མཆོད་པ་འབུལ་མཁན་གྱིས་རང་གི་ཞི་བདེའི་མཆོད་པ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","མི་དེས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་མེ་མཆོད་དངོས་སུ་འཁྱེར་འོང་དགོས་ཏེ། ཚིལ་དང་བྲང་ཁྱེར་འོངས་ནས་བྲང་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ཏེ་གཡོབ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","མཆོད་དཔོན་གྱིས་ཚིལ་རྣམས་མཆོད་ཁྲིའི་སྟེང་བསྲེག་དགོས་ཀྱང་། བྲང་ནི་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་དབང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ཁྱོད་རྣམས་ཀྱིས་ཞི་བདེའི་མཆོད་པའི་ཕྱུགས་ཟོག་གི་བརླ་གཡས་པ་འདེགས་མཆོད་བྱས་ནས་མཆོད་དཔོན་ལ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ཨ་རོན་གྱི་བུ་རྣམས་ལས་སུ་ཞིག་གིས་ཞི་བདེའི་མཆོད་པའི་ཕྱུགས་ཟོག་གི་ཁྲག་དང་ཚིལ་ཕུལ་ན། དེ་ལ་འཐོབ་འོས་པའི་སྐལ་དུ་བརླ་གཡས་པ་འཐོབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","གང་ལ་ཞེ་ན། བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་གྱི་ཞི་བདེའི་མཆོད་པ་ལས་གཡོབ་མཆོད་ཀྱི་བྲང་དང་འདེགས་མཆོད་ཀྱི་བརླ་བླངས་ཏེ། མཆོད་དཔོན་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་སྤྲད་པ་ཡིན་ལ། དེ་ནི་ཁོ་རྣམས་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་གཏན་དུ་འཐོབ་འོས་པའི་སྐལ་ཡིན་ཞེས་སྨྲ་དགོས་པར་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་མཆོད་ལས་བླངས་པ་དང་། ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱི་སྐལ་ཡིན་ཏེ། མོ་ཤེ་ཡིས་ཁོ་རྣམས་ཚུར་བོས་ཡོང་ནས། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་དཔོན་གྱི་ལས་འགན་བསྒྲུབས་པའི་ཉིན་དེ་ནས་བཟུང་འགོ་བརྩམས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","དེ་ནི་མོ་ཤེ་ཡིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་སྣུམ་གྱིས་བྱུགས་པའི་ཉིན་མོར། དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གནང་དགོས་པའི་བཀའ་གནང་བ་སྟེ། ཁོ་རྣམས་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་མི་རབས་ནས་མི་རབས་བར་གཏན་དུ་འཐོབ་འོས་པའི་སྐལ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","འདི་ནི་སྦྱིན་སྲེག་དང་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་། སྡིག་བཤགས་མཆོད་པ། ཉེས་སེལ་མཆོད་པ། བསྐོ་བར་བྱེད་པའི་མཛད་སྒོ། ཞི་བདེའི་མཆོད་པ་བཅས་ཀྱི་བཀའ་ཁྲིམས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","དེ་ཐམས་ཅད་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱ་རུ་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་ཡིན་ལ། ཁོང་གིས་སི་ནཱ་དབེན་སྟོང་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་དགོས་པའི་བཀའ་བསྩལ་པའི་ཉིན་མོར་གསུངས་པའི་བཀའ་ཡང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","ཁྱོད་ཀྱིས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཁྲིད་ཤོག་དང་། ཡང་འཕགས་གོས་དང་འབྱུག་སྣུམ། སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་གཅིག་དང་ལུག་ཐུག་གཉིས། སྐྱུར་མེད་བག་ལེབ་གཟེབ་གང་བཅས་འཁྱེར་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ཡང་མི་ཚོགས་ཐམས་ཅད་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་སྡུས་ཤིག་ཅེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེས་བསྩལ་པའི་བཀའ་བཞིན་དུ་བསྒྲུབས་ཏེ། མི་ཚོགས་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་བསྡུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","མོ་ཤེ་ཡིས་མི་ཚོགས་ལ་འདི་ལྟར། འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་བསྒྲུབ་འོས་པར་གསུངས་པའི་དོན་རྣམས་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","མོ་ཤེ་ཡིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཁྲིད་འོངས་ཤིང་། དེ་དག་གི་ལུས་ཆུ་ཡིས་བཀྲུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","དེ་ནས་ཁོ་ལ་ནང་གོས་བསྐོན་ནས་སྐེད་ཆིངས་བཅིངས་པ་དང་གོས་རིང་བསྐོན་ཞིང་། བེར་ཐུལ་ཡང་བསྐོན་ཏེ། སྐ་རགས་སྤུས་དག་གིས་བེར་ཐུལ་དམ་པོར་བསྡམས། ");
INSERT INTO bodn_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ཡང་ཁོས་ཨ་རོན་ལ་བྲང་རྒྱན་ཡང་སྤྲས་པ་དང་། ཨུའུ་རིམ་དང་ཐུའུ་མིམ་ཞེས་པའི་རྟགས་རིལ་གཉིས་བྲང་རྒྱན་གྱི་ནང་དུ་བཅུག ");
INSERT INTO bodn_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་བསྩལ་པ་བཞིན་དུ། ཁོས་ཨ་རོན་གྱི་མགོར་ལ་ཐོད་སྤྲས་ཤིང་། ལ་ཐོད་ཀྱི་མདུན་ངོས་སུ་དམ་པའི་ཅོད་པན་ཡིན་པའི་གསེར་གྱི་བྱང་བུ་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","དེ་ནས་མོ་ཤེ་ཡིས་འབྱུག་སྣུམ་གྱིས་གུར་མཆོག་དང་དེའི་ནང་གི་ཡོ་བྱད་ཐམས་ཅད་ལ་བྱུགས་ནས་དེ་རྣམས་དམ་པར་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ཡང་མཆོད་ཁྲིའི་སྟེང་འབྱུག་སྣུམ་ལན་བདུན་གཏོར་ནས། མཆོད་ཁྲི་དང་མཆོད་ཁྲིའི་ཡོ་བྱད་ཐམས་ཅད། ཁྲུས་གཞོང་དང་དེའི་སྟེགས་བུ་བཅས་སྣུམ་གྱིས་བྱུགས་ནས་དམ་པར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ཨ་རོན་གྱི་མགོ་ལ་འབྱུག་སྣུམ་བླུགས་ནས་ཁོ་དམ་པར་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","མོ་ཤེ་ཡིས་ཨ་རོན་གྱི་བུ་རྣམས་ཚུར་ཁྲིད་ཡོང་སྟེ། ཁོ་རྣམས་ལ་ནང་གོས་བསྐོན་ནས་སྐེད་ཆིངས་བཅིངས་པ་དང་པྲོག་ཞུ་དཀྲིས་ཤིང་། དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","དེ་ནས་ཁོས་སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་ཁྲིད་འོངས་པ་དང་། ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་གླང་ཐུག་དེའི་མགོ་ལ་ལག་པ་བཞག་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","གླང་ཐུག་བཤས་ཤིང་། མཆོད་ཁྲིའི་སྟེང་སྡིག་པ་བཤག་ཕྱིར། མོ་ཤེ་ཡིས་དེའི་ཁྲག་བླངས་ནས་མཛུབ་མོས་མཆོད་ཁྲིའི་མཐའ་འཁོར་གྱི་རུ་ཐུར་རྣམས་ལ་བྱུགས་ཏེ་མཆོད་ཁྲི་འདག་པར་བྱས། དེ་ནས་ཁྲག་ལྷག་མ་རྣམས་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་བླུགས་ནས་མཆོད་ཁྲི་དམ་པར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ཡང་མོ་ཤེ་ཡིས་ནང་ཁྲོལ་གྱི་ཚིལ་ཐམས་ཅད་དང་མཆིན་པའི་རྩ་རྒྱུས་དང་། མཁལ་མ་གཉིས་ཀ་དང་དེའི་སྟེང་གི་ཚིལ་བཅས་བླངས་ནས་མཆོད་ཁྲིའི་ཁར་བསྲེགས། ");
INSERT INTO bodn_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","གླང་ཐུག་གི་པགས་པ་དང་ཤ་དང་ལྕི་བ་བཅས་ནི་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་མེ་ལ་བསྲེགས་པ་དང་། དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ཁོས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་ལུག་ཐུག་ཁྲིད་འོངས་ཤིང་། ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་ལུག་ཐུག་གི་མགོར་ལག་པ་བཞག་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ལུག་ཐུག་བཤས་ཤིང་། མོ་ཤེ་ཡིས་དེའི་ཁྲག་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ལུག་ཐུག་གི་ཤ་ལྷུ་ལྷུ་རུ་བཅད་རྗེས་མགོ་དང་ཤ་དང་ཚིལ་ཐམས་ཅད་བསྲེགས། ");
INSERT INTO bodn_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ཁོས་ནང་ཁྲོལ་དང་རྐང་ལག་རྣམས་ཆུས་བཀྲུས་ཤིང་ལུག་ཐུག་ཧྲིལ་པོ་མཆོད་ཁྲིའི་སྟེང་སྦྱིན་སྲེག་བཏང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་གྱི་མེ་མཆོད་ཡིན་ལ། དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ཡང་ཁོས་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་གཉིས་པ་ཁྲིད་འོངས་ཏེ། ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་ལུག་ཐུག་གི་མགོ་ལ་ལག་པ་བཞག་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ལུག་ཐུག་བཤས་ཤིང་། མོ་ཤེ་ཡིས་དེའི་ཁྲག་ལས་ཉུང་ཙམ་ཞིག་ཨ་རོན་གྱི་རྣ་ཤལ་གཡས་པ་དང་། ལག་གཡས་པའི་མཐེ་བོང་དང་རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་ལ་བྱུགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ཡང་ཨ་རོན་གྱི་བུ་རྣམས་ཚུར་ཁྲིད་འོངས་ནས། ཁྲག་ཉུང་ཙམ་ཞིག་དེ་དག་གི་རྣ་ཤལ་གཡས་པ་དང་ལག་གཡས་པའི་མཐེ་བོང་དང་རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་སུ་བྱུགས་རྗེས། ཁྲག་ལྷག་མ་རྣམས་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ཁོས་ཚིལ་དང་རྔ་མ་ཚོན་པོ་དང་ནང་ཁྲོལ་གྱི་ཚིལ་ཐམས་ཅད་དང་། མཆིན་པའི་རྩ་རྒྱུས་དང་མཁལ་མ་གཉིས་ཀ་དང་དེའི་སྟེང་གི་ཚིལ་དང་། བརླ་གཡས་པ་བཅས་བླངས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་སྐྱུར་མེད་བག་ལེབ་འཇོག་བྱེད་ཀྱི་གཟེབ་ལས་སྐྱུར་མེད་བག་ལེབ་གཅིག་དང་། སྣུམ་གོར་གཅིག་དང་བག་ལེབ་སྲབ་བུ་གཅིག་བཅས་བླངས་ཏེ། དེ་ཐམས་ཅད་ཚིལ་དང་བརླ་གཡས་པའི་སྟེང་དུ་བསྒྲིགས། ");
INSERT INTO bodn_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ཁོས་དེ་ཐམས་ཅད་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱི་ལག་ཏུ་བཞག་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་གཡོས་ཤིང་གཡོབ་མཆོད་དུ་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","དེ་ནས་མོ་ཤེ་ཡིས་མཆོད་རྫས་དེ་དག་ཁོ་ཚོའི་ལག་ནས་བླངས་ཤིང་། མཆོད་ཁྲི་སྟེང་གི་སྦྱིན་སྲེག་དང་ལྷན་དུ་བསྲེགས། དེ་ནི་བསྐོ་བར་བྱེད་པའི་མཛད་སྒོ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","མོ་ཤེ་ཡིས་ལུག་ཐུག་གི་བྲང་ཁོག་དེ་བླངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ནས་གཡོབ་མཆོད་དུ་ཕུལ། དེ་ནི་བསྐོ་བར་བྱེད་པའི་ལུག་ཐུག་ལས་མོ་ཤེ་ལ་ཐོབ་པའི་སྐལ་ཡིན་ལ། དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","མོ་ཤེ་ཡིས་འབྱུག་སྣུམ་དང་མཆོད་ཁྲིའི་སྟེང་གི་ཁྲག་ཉུང་ཙམ་བླངས་ཏེ། ཨ་རོན་དང་ཁོའི་གོས་དང་ཁོའི་བུ་རྣམས་དང་། ཁོའི་བུ་རྣམས་ཀྱི་གོས་ཀྱི་སྟེང་དུ་གཏོར་ནས་ཨ་རོན་དང་ཁོའི་གོས་དང་། ཁོའི་བུ་རྣམས་དང་དེ་རྣམས་ཀྱི་གོས་བཅས་ཐམས་ཅད་དམ་པར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","མོ་ཤེ་ཡིས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་འདི་ལྟར། ཁྱོད་རྣམས་ཀྱིས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་ཤ་བཙོས་ཏེ། ཤ་དེ་དང་བསྐོ་བར་བྱེད་པའི་མཛད་སྒོའི་གཟེབ་ནང་གི་བག་ལེབ་བཟའ་དགོས་ཤིང་། ངས་ཁྱོད་རྣམས་ལ་བསྒོས་པ་བཞིན་དུ། འདི་ནི་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་བཟའ་དགོས་པ་ཡིན་ཞེས་སྨྲ་བར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ཤ་དང་བག་ལེབ་ལྷག་མ་རྣམས་ཁྱོད་ཚོས་མེ་ལ་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ཉིན་བདུན་པོ་དེ་མ་རྫོགས་བར་དུ། ཁྱོད་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཕྱི་རུ་འགྲོ་མི་རུང་། གང་ལ་ཞེ་ན། ཁྱོད་རྣམས་ཀྱི་བསྐོ་བར་བྱེད་པའི་མཛད་སྒོའི་ཉིན་མོ་ཚང་དགོས་ལ། ཁྱོད་རྣམས་བསྐོ་བར་ཉིན་བདུན་དགོས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","དེ་རིང་བྱས་པ་ཐམས་ཅད་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་གི་སྡིག་པ་བཤག་པའི་ཕྱིར་བསྩལ་པའི་བཀའ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ཉིན་བདུན་པོ་དེར་ཁྱོད་རྣམས་ཉིན་མཚན་ཀུན་ཏུ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་འགྲམ་དུ་འདུག་དགོས་ལ། འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེས་བསྩལ་པའི་བཀའ་རྣམས་བསྲུང་དགོས། གང་ལ་ཞེ་ན། དེ་ནི་བདག་ལ་བསྩལ་པའི་བཀའ་ཡིན་པས་སོ་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","དེ་བས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་བསྩལ་པའི་བཀའ་བཞིན་དུ་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ཉིན་བརྒྱད་པ་ལ་མོ་ཤེ་ཡིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་དང་། ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་བོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ཨ་རོན་ལ་འདི་ལྟར། ཁྱོད་ཀྱིས་སྡིག་བཤགས་མཆོད་པར་སྒོ་ཕྱུགས་ལས་བ་ཕྲུག་ཅིག་དང་། སྦྱིན་སྲེག་གི་ཕྱིར་ལུག་ཐུག་ཅིག་ལེན་དགོས་ལ། དེ་གཉིས་ཀ་སྐྱོན་མེད་པ་ཞིག་ཡིན་དགོས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕུལ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར། ཁྱོད་རྣམས་ཀྱིས་སྡིག་བཤགས་མཆོད་པ་ལ་ར་ཐུག་ཅིག་འཁྲིད་ཡོང་དགོས། སྐྱོན་གཏན་ནས་མེད་པའི་བ་ཕྲུག་དང་ལུ་གུ་ལོ་གཅིག་ཅན་གཉིས་ཀྱང་སྦྱིན་སྲེག་གི་མཆོད་པའི་ཕྱིར་དུ་འཁྲིད་ཡོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ཡང་གླང་ཐུག་ཅིག་དང་ལུག་ཐུག་ཅིག་དམར་མཆོད་ཀྱི་ཆེད་དུ་ཁྲིད་འོངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཞི་བདེའི་མཆོད་པ་རུ་བཤམ་པ་དང་། འབྲུ་རིགས་ཀྱི་མཆོད་པ་ལ་སྣུམ་བསྲེས་ནས་འབུལ་དགོས་ཏེ། ཅིའི་ཕྱིར་ཞེ་ན། དེ་རིང་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱོད་རྣམས་ལ་མངོན་པར་འགྱུར་བའི་ཕྱིར་རོ་ཞེས་སྦྲོན་ཅིག་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","དེ་ཚོས་མོ་ཤེ་ཡིས་བསྒོས་པ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་ཁྱེར་འོངས་པ་དང་། མི་ཚོགས་ཐམས་ཅད་ཉེ་སར་བཅར་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་འགྲེང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","དེར་མོ་ཤེ་ན་རེ། འདི་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་རྣམས་ལ་བཀའ་བསྩལ་ཞིང་བསྒྲུབ་འོས་པ་རྣམས་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་ཁྱོད་ཅག་ལ་མངོན་པར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","མོ་ཤེ་ཡིས་ཨ་རོན་ལ། ཁྱོད་རང་མཆོད་ཁྲིའི་མདུན་དུ་བཅར་ནས་ཁྱོད་ཀྱི་སྡིག་བཤགས་མཆོད་པ་དང་སྦྱིན་སྲེག་ཕུལ་ཏེ། རང་ཉིད་དང་མི་རྣམས་ཀྱི་སྡིག་པ་ཤོགས་ཤིག ཡང་མི་རྣམས་ཀྱི་མཆོད་པ་ཕུལ་ཏེ་ཁོ་རྣམས་ཀྱི་སྡིག་པ་ཤོགས་ཤིག ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","དེ་ནས་ཨ་རོན་མཆོད་ཁྲིའི་དྲུང་དུ་འོངས་ནས་རང་གི་སྡིག་བཤགས་མཆོད་པའི་བ་ཕྲུག་དེ་བཤས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ཨ་རོན་གྱི་བུ་རྣམས་ཀྱིས་ཁོ་ལ་ཁྲག་ཁྱེར་འོངས་པ་དང་། ཁོས་མཛུབ་མོ་ཁྲག་ནང་བསྒྲེས་ཤིང་མཆོད་ཁྲིའི་རུ་ཐུར་རྣམས་ལ་བསྐུས་པ་དང་། ཁྲག་ལྷག་མ་རྣམས་མཆོད་ཁྲིའི་ཞབས་རའི་སྟེང་དུ་བླུགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ཁོས་སྡིག་བཤགས་མཆོད་པའི་ཚིལ་དང་མཁལ་མ་དང་། མཆིན་པའི་རྩ་རྒྱུས་བཅས་ནི་མཆོད་ཁྲིའི་སྟེང་དུ་བསྲེགས་པ་དང་། དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ཤ་དང་པགས་པ་རྣམས་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་མེ་ལ་བསྲེགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ཨ་རོན་གྱིས་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་ཕྱུགས་ཟོག་བཤས་རྗེས། ཁོའི་བུ་རྣམས་ཀྱིས་དེའི་ཁྲག་ཁྱེར་འོངས་པ་དང་། ཁོས་ཁྲག་དེ་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར། ");
INSERT INTO bodn_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ཡང་དེ་དག་གིས་སྦྱིན་སྲེག་ཧྲིལ་པོ་ལྷུ་ལྷུ་རུ་བཅད་པ་རྣམས་མགོ་དང་བཅས་ཁྱེར་འོངས་ནས་ཁོ་ལ་སྤྲད་ཅིང་། ཁོས་དེ་མཆོད་ཁྲིའི་སྟེང་བསྲེགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ནང་ཁྲོལ་དང་རྐང་ལག་རྣམས་བཀྲུས་ཏེ་མཆོད་ཁྲིའི་སྟེང་གི་སྦྱིན་སྲེག་དང་ལྷན་དུ་བསྲེགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","དེ་ནས་མི་ཚོགས་ཀྱི་མཆོད་པ་ཕུལ་བ་སྟེ། ཁོས་མི་ཚོགས་ཀྱི་སྡིག་བཤགས་མཆོད་པར་ཁྲིད་འོངས་པའི་ར་ཐུག་བཤས་ཏེ་སྔར་བཞིན་སྡིག་བཤགས་མཆོད་པར་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ཡང་ཁྲིམས་སྲོལ་བཞིན་དུ་བསྒྲུབས་ནས་སྦྱིན་སྲེག་ཀྱང་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ཞོགས་པའི་སྦྱིན་སྲེག་ལས་གཞན་ཁོས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ཡང་ཕུལ་བ་སྟེ། ལག་པས་ཁྱོར་བ་གང་བླངས་ནས་མཆོད་ཁྲིའི་སྟེང་དུ་བསྲེགས། ");
INSERT INTO bodn_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","དེ་ནས་ཨ་རོན་གྱིས་མི་ཚོགས་ཀྱི་ཞི་བདེའི་མཆོད་པ་ཡིན་པའི་གླང་ཐུག་དང་ལུག་ཐུག་བཤས་ཤིང་། ཁོའི་བུ་རྣམས་ཀྱིས་ཁོ་ལ་དེའི་ཁྲག་ཁྱེར་འོངས་པ་དང་། ཁོས་ཁྲག་ནི་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་གཏོར་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","དེ་དག་གིས་གླང་ཐུག་དང་ལུག་ཐུག་གི་ཚིལ་དང་། རྔ་མ་ཚོན་པོ་དང་། ནང་ཁྲོལ་བཏུམས་པའི་ཚིལ་དང་། མཁལ་མ་དང་། མཆིན་པའི་རྩ་རྒྱུས་བཅས་ཡོངས་སུ་རྫོགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ཚིལ་ནི་དམར་མཆོད་དུ་བཤས་པའི་ཕྱུགས་ཟོག་གི་བྲང་རྣམས་ཀྱི་སྟེང་དུ་བཞག་པ་དང་། ཁོས་ཚིལ་རྣམས་མཆོད་ཁྲིའི་སྟེང་དུ་བསྲེགས། ");
INSERT INTO bodn_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ཨ་རོན་གྱིས་དམར་མཆོད་དུ་བཤས་པའི་ཕྱུགས་ཟོག་གི་བྲང་རྣམས་དང་བརླ་གཡས་པ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ནས་གཡོབ་མཆོད་དུ་ཕུལ་བ་དང་། དེ་ནི་མོ་ཤེ་ཡིས་བསྒོས་པ་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","དེ་ནས་ཨ་རོན་གྱིས་ལག་པ་ཡར་བཏེགས་ནས་མི་རྣམས་ལ་བྱིན་གྱིས་བརླབས་པ་དང་། ཁོས་སྡིག་བཤགས་མཆོད་པ་དང་སྦྱིན་སྲེག ཞི་བདེའི་མཆོད་པ་བཅས་ཕུལ་རྗེས་མར་བབས། ");
INSERT INTO bodn_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","མོ་ཤེ་དང་ཨ་རོན་གཉིས་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་སོང་ཞིང་། ཕྱི་རོལ་ཏུ་འོངས་ནས་མི་རྣམས་ལ་བྱིན་རླབས་མཛད་པ་ན། དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་མི་ཐམས་ཅད་ལ་མངོན་པར་གྱུར་པ་དང་ཆབས་ཅིག ");
INSERT INTO bodn_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་མེ་ཞིག་བྱུང་སྟེ། མཆོད་ཁྲིའི་སྟེང་གི་སྦྱིན་སྲེག་དང་ཚིལ་རྣམས་ཡོངས་སུ་བསྲེགས་ཤིང་། མི་ཐམས་ཅད་ཀྱིས་དེ་མཐོང་བ་ན་སྐད་ཆེན་པོ་བརྒྱབ་ནས་ལུས་སར་བཏུད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","དེ་ཡང་ཨ་རོན་གྱི་བུ་ནཱ་དབ་དང་ཨ་བི་ཧུ་གཉིས་ཀྱིས་རང་གི་སྤོས་ཕོར་ཁྱེར་ནས། དེའི་ནང་དུ་མེ་བཞག་པ་དང་བདུག་སྤོས་ཀྱང་བཏབ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ཚོར་བཀའ་འཁྲོལ་མེད་པའི་མེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕུལ། ");
INSERT INTO bodn_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","དེར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་མེ་ཞིག་བྱུང་ཞིང་དེ་གཉིས་བསྲེགས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཤིའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","དེ་ནས་མོ་ཤེ་ཡིས་ཨ་རོན་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ངའི་གམ་དུ་བཅར་བ་རྣམས་ཀྱི་ཁྲོད་དུ་ང་རང་དམ་པར་མངོན་པ་དང་། མི་ཐམས་ཅད་ཀྱི་མཐོང་ངོར་བདག་ལ་གཟི་བརྗིད་ལྡན་པར་འགྱུར་ཞེས་བཀའ་བསྩལ་པའོ་ཞེས་གསུངས་པར། ཨ་རོན་གྱིས་ངག་བཅད་དེ་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","མོ་ཤེ་ཡིས་ཨ་རོན་གྱི་ཞང་པོ་ཨུ་ཟི་ཨེལ་གྱི་བུ་མེ་ཤཱ་ཨེལ་དང་ཨེལ་ཙ་ཕཱན་གཉིས་བོས་ནས་ན་རེ། ཚུར་ཤོག་དང་། ཁྱོད་ཀྱི་སྤུན་མཆེད་རྣམས་ཀྱི་བེམ་པོ་གནས་མཆོག་གི་མདུན་ནས་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་ཁྱེར་ཅིག་ཅེས་གསུངས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","དེ་གཉིས་ཚུར་འོངས་ནས། མོ་ཤེ་ཡིས་གསུངས་པ་བཞིན་དུ་བེམ་པོ་ནི་གོས་རིང་དང་བཅས་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་ཁྱེར། ");
INSERT INTO bodn_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ཡང་མོ་ཤེ་ཡིས་ཨ་རོན་དང་དེའི་བུ་ཨེ་ལི་ཨ་ཟར་དང་ཨི་ཐ་མཱར་བཅས་ལ། ཁྱོད་ཀྱི་མགོ་ཟིང་ནས་སྐྲ་བཤིག་པར་མི་བྱེད་ལ་གོས་རྣམས་ཀྱང་དྲལ་བར་མ་གྱུར་ཅིག ཅི་ལ་ཞེ་ན། ཁྱོད་འཆི་བར་མི་འགྱུར་བ་དང་དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་ཉིད་མི་ཚོགས་ཐམས་ཅད་ལ་ཐུགས་ཁྲོ་བར་མི་འགྱུར་བའི་ཕྱིར་རོ། །འོན་ཀྱང་ཁྱོད་ཀྱི་སྤུན་ཟླ་སྟེ་ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་ཀུན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མཛད་པའི་མེ་འདི་ཡི་ཕྱིར་དུ་སྨྲེ་ངག་འདོན་ངེས། ");
INSERT INTO bodn_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ཁྱོད་ཅག་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་དུ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོའི་ཕྱི་རོལ་ཏུ་མ་འགྲོ་ཞིག དཀོན་མཆོག་ཡ་ཝཱེས་བྱུགས་པའི་སྣུམ་ཁྱོད་ཅག་གི་ལུས་སྟེང་དུ་ཡོད་པའི་ཕྱིར་རོ་ཞེས་གསུངས་པས། དེ་དག་གིས་མོ་ཤེའི་བཀའ་བཞིན་དུ་བསྒྲུབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་རོན་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འོངས་པའི་ཚེ། འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་དུ་རྒུན་ཆང་དང་ཨ་རག་གང་ཡང་བཏུང་བར་མ་བྱེད་ཅིག དེ་ནི་ཁྱོད་ཅག་གི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ཁྱོད་རྣམས་ཀྱིས་དམ་པ་དང་ཐ་ཤལ་གཉིས་དང་། གཙང་དང་མི་གཙང་བའི་དབྱེ་བ་འབྱེད་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གསུངས་པའི་སྒྲིག་ཁྲིམས་ཐམས་ཅད་ཁོ་རྣམས་ལ་སློབ་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ཡང་མོ་ཤེ་ཡིས་ཨ་རོན་དང་ཁོའི་གསོན་པོར་ལུས་པའི་བུ་ཨེ་ལི་ཨ་ཟར་དང་ཨི་ཐ་མཱར་གཉིས་ལ་འདི་ལྟར། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ལས་འབྲུ་རིགས་ཀྱི་ལྷག་མ་རྣམས་བླངས་ཏེ། མཆོད་ཁྲིའི་ལོགས་སུ་སྐྱུར་མེད་བག་ལེབ་དེ་ཟོ་ཞིག དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ཁྱོད་རྣམས་ཀྱིས་གནས་དམ་པ་རུ་དེ་བཟའ་དགོས། ཅིའི་ཕྱིར་ཞེ་ན། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ལས་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་ལ་འཐོབ་འོས་པའི་སྐལ་ཡིན་ལ། ང་ལ་བསྩལ་པའི་བཀའ་ནི་དེ་བཞིན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","གཡོབ་མཆོད་ཀྱི་བྲང་དང་འདེགས་མཆོད་ཀྱི་བརླ་ནི། ཁྱོད་ཀྱིས་རང་གི་བུ་དང་བུ་མོ་རྣམས་དང་མཉམ་དུ་གནས་གཙང་ས་ཞིག་ཏུ་བཟའ་དགོས། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཞི་བདེའི་མཆོད་པ་ལས་ཁྱོད་ལ་དབང་ཞིང་། ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་ལ་འཐོབ་འོས་པའི་སྐལ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ཁོ་རྣམས་ཀྱིས་འདེགས་མཆོད་ཀྱི་བརླ་དང་གཡོབ་མཆོད་ཀྱི་བྲང་། མེ་མཆོད་ཀྱི་ཚིལ་བཅས་ཁྱེར་འོངས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ནས་གཡོབ་མཆོད་དུ་འབུལ་བར་འགྱུར། འདི་ཐམས་ཅད་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་ལ་དབང་ཞིང་། དུས་གཏན་དུ་འཐོབ་འོས་པའི་སྐལ་ཡིན་ལ། ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེས་བསྩལ་པའི་བཀའ་བཞིན་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","དེའི་སྐབས་སུ་མོ་ཤེ་ཡིས་གཟབ་ནན་གྱིས་སྡིག་བཤགས་མཆོད་པའི་ར་ཐུག་བཙལ་བ་ན། ལྟོས་དང་། དེ་ནི་བསྲེགས་ཟིན་པས་ཁོང་ཨ་རོན་གྱི་བུ་གསོན་པོར་ལུས་པ་ཨེ་ལི་ཨ་ཟར་དང་ཨི་ཐ་མཱར་གཉིས་ལ་ཁྲོས་ནས་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","ཁྱོད་ཅག་གིས་སྡིག་བཤགས་མཆོད་པ་དེ་གནས་མཆོག་ཏུ་མ་ཟོས་པ་ཅི་ཡིན་ནམ། དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན་ལ། མི་ཚོགས་ཀྱི་ནག་ཉེས་སེལ་ཞིང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཞབས་དྲུང་དུ་དེ་དག་གི་སྡིག་པ་བཤག་པའི་ཕྱིར་དུ་ཁྱོད་རྣམས་ལ་གནང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ལྟོས་དང་། དམར་མཆོད་དེའི་ཁྲག་ནི་གནས་མཆོག་ཏུ་ཁྱེར་མེད་པས། ཁྱོད་ཅག་གིས་ངའི་བསྒོ་བ་བཞིན་གནས་མཆོག་ཏུ་ཤ་དེ་བཟའ་དགོས་སོ་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ཨ་རོན་གྱིས་མོ་ཤེ་ལ། ལྟོས་དང་། དེ་རིང་དེ་དག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་སྡིག་བཤགས་མཆོད་པ་དང་སྦྱིན་སྲེག་ཕུལ་ནའང་། ང་རང་ཆག་སྒོ་འདི་ལྟ་བུར་ཕྲད་བྱུང་། གལ་སྲིད་དེ་རིང་ངས་སྡིག་བཤགས་མཆོད་པ་འདི་ཟོས་ན། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་འོས་སམ་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","མོ་ཤེ་ཡིས་དེ་ཐོས་པ་དང་ལེགས་པར་དགོངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","ཁྱོད་ཅག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ས་སྟེང་དུ་ཡོད་པའི་དུད་འགྲོ་ཐམས་ཅད་ལས་བཟའ་རུང་བའི་སྲོག་ཆགས་ནི་འདི་དག་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","དུད་འགྲོ་རྨིག་པ་གཉིས་སུ་ཁ་འཕྲལ་བའམ། ཡང་ན་རྨིག་སོར་ཁ་འཕྲལ་ཅན་དང་སྐྱུག་ལྡད་བྱེད་པ་རྣམས་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","འོན་ཀྱང་། སྐྱུག་ལྡད་བྱེད་པ་དང་ཡང་ན་རྨིག་པ་ཁ་འཕྲལ་ཅན་རྣམས་ལས་བཟའ་མི་རུང་བ་ནི། རྔ་མོང་གིས་སྐྱུག་ལྡད་བྱེད་ཀྱང་རྨིག་པ་ཁ་འཕྲལ་མེད་པས་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","འཕྱི་བས་སྐྱུག་ལྡད་བྱེད་ཀྱང་རྨིག་པ་ཁ་འཕྲལ་མེད་པས་དེ་ཡང་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","རི་བོང་གིས་སྐྱུག་ལྡད་བྱེད་ནའང་རྨིག་པ་ཁ་འཕྲལ་མེད་པས་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ཕག་ནི་རྨིག་པ་གཉིས་སུ་ཁ་འཕྲལ་བ་དང་རྨིག་སོར་ཁ་འཕྲལ་ཅན་ཡིན་ནའང་། སྐྱུག་ལྡད་མི་བྱེད་པས་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","དེ་དག་གི་ཤ་ནི་ཁྱོད་ཅག་གིས་མི་བཟའ་བར་གྱིས། དེ་དག་གི་རོ་རྣམས་ལ་ཡང་མི་རེག་པར་གྱིས། དེ་ཐམས་ཅད་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ཆུར་གནས་ཐམས་ཅད་ལས་བཟའ་རུང་བ་ནི་འདི་དག་སྟེ། རྒྱ་མཚོའམ་གཙང་པོ་གང་རུང་སྟེ་ཆུ་ནང་དུ་གནས་པའི་གཤོག་པ་དང་ཉ་སག་དང་ལྡན་པ་ཐམས་ཅད་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","རྒྱ་མཚོ་དང་གཙང་པོ་དང་། ཆུ་ནང་དུ་ནུར་འགྲོས་བྱེད་པའི་སྲོག་ཆགས་ཐམས་ཅད་དེ། ཆུ་ནང་དུ་གནས་པའི་སྲོག་ལྡན་ཐམས་ཅད་ལས་གཤོག་པ་དང་ཉ་སག་མེད་པ་རྣམས་ནི་ཁྱོད་ཅག་གིས་སྐྱུག་བྲོ་བར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","དེ་དག་ནི་ཁྱོད་རྣམས་ལ་མཚོན་ན་སྐྱུག་བྲོ་བ་ཡིན་པས། དེ་དག་གི་ཤ་བཟའ་མི་རུང་ལ་རོ་ཡང་སྐྱུག་བྲོ་བར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","གཤོག་པ་དང་ཉ་སག་དང་མི་ལྡན་པའི་ཆུ་གནས་ཐམས་ཅད་ནི་ཁྱོད་རྣམས་ལ་མཚོན་ན་སྐྱུག་བྲོ་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ཡང་འདབ་ཆགས་ལས་ཁྱོད་ཅག་གིས་སྐྱུག་བྲོ་བར་བརྩི་རུང་བ་དང་། བཟའ་མི་རུང་བར་མ་ཟད་སྐྱུག་བྲོ་བ་རྣམས་ནི་འདི་དག་སྟེ། གླག་དང་བྱ་རྒོད་དང་གོ་བོ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","འོལ་པ་དང་བྱ་ཁྲའི་རིགས་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ཕོ་རོག་གི་རིགས་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","རྔ་བྱ་དང་སྲིན་བྱ་དང་ཆུ་སྐྱར་དང་ཁྲའི་རིགས་ཐམས་ཅད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","འུག་ཆུང་དང་སོ་བྱ་དང་འུག་རྒན་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","འུག་དཀར་དང་འུག་སེར་དང་དུར་བྱ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ཁྲུང་ཁྲུང་དང་སྐྱར་མོ་རྐང་རིང་གི་རིགས་དང་པུ་ཤུད་དང་ཕ་ཝང་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","རྐང་པ་བཞིས་འགྲུལ་བའི་འབུ་སྲིན་གཤོག་པ་ཅན་ཐམས་ཅད་ཁྱོད་རྣམས་ལ་མཚོན་ན་སྐྱུག་བྲོ་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","རྐང་པ་བཞིས་འགྲུལ་བའི་འབུ་སྲིན་གཤོག་པ་ཅན་ཐམས་ཅད་ལས། རྐང་པ་བརླ་ཐོག་ལ་འབྱར་ཡོད་པ་དང་ས་ནས་མཆོང་བ་རྣམས་ཁྱོད་ཅག་གིས་བཟའ་རུང་བ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","དེ་དག་ལས་ཁྱོད་རྣམས་ཀྱིས་བཟའ་རུང་བ་ནི་ཆ་ག་པའི་རིགས་དང་འབུ་ཀོ་ཀོའི་རིགས་དང་། འཐབ་འབུའི་རིགས་དང་ཅོག་ཅོག་པའི་རིགས་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","འོན་ཀྱང་རྐང་པ་བཞི་ཡོད་པའི་འབུ་སྲིན་གཤོག་པ་ཅན་ཐམས་ཅད་ཁྱོད་རྣམས་ལ་མཚོན་ན་སྐྱུག་བྲོ་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","དེ་ཐམས་ཅད་ཀྱིས་ཁྱོད་རྣམས་མི་གཙང་བར་བྱེད་ཅིང་། སུ་ཞིག་གིས་དེ་དག་གི་རོ་ལ་རེག་ན། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ཡང་སུ་ཞིག་གིས་དེ་དག་གི་རོ་ཁྱེར་བ་ཡིན་ན། རང་གི་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ཕྱུགས་ཟོག་རྨིག་པ་གཉིས་སུ་ཁ་འཕྲལ་ཡང་། རྨིག་སོར་འཕྲལ་མེད་པའམ་ཡང་ན་སྐྱུག་ལྡད་མི་བྱེད་པ་ཐམས་ཅད་ཁྱོད་ཅག་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན། སུ་ཞིག་གིས་དེར་རེག་ན་དེ་ནི་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","རྐང་མཐིལ་གྱིས་འགྲུལ་བ་དང་རྐང་པ་བཞིས་འགྲུལ་བའི་སྲོག་ཆགས་ཐམས་ཅད་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན་ལ། སུ་ཞིག་གིས་དེའི་རོ་ལ་རེག་ན་དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","སུ་ཞིག་གིས་དེ་དག་གི་རོ་ཁྱེར་བ་ཡིན་ན། རང་གི་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། དེ་དག་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","ས་སྟེང་གི་ལྟོ་འགྲོ་སྲོག་ཆགས་ཁྱུ་དང་ཁྱུ་རྣམས་ལས། ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ནི་འདི་དག་སྟེ། སྲེ་མོང་དང་བྱི་བ་དང་རྩངས་པའི་རིགས་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","གྱང་རྨིགས་དང་རྨིགས་པ་ཆེན་པོ། རྩངས་པ་ཁ་རལ་དང་རྩངས་པ་བྱེ་རལ་དང་བླ་མ་རྒལ་ཅིག་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ལྟོ་འགྲོ་སྲོག་ཆགས་དེ་ཐམས་ཅད་ནི་ཁྱོད་རྣམས་ལ་མཚོན་ན་མི་གཙང་བ་ཡིན་ལ། སུ་ཞིག་གིས་དེ་དག་ཤི་རྗེས་རོ་ལ་རེག་ན་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","དེ་དག་ལས་ཤི་རོ་གཅིག་དངོས་པོ་གང་རུང་གི་སྟེང་དུ་ལྷུང་ན་དེ་ནི་མི་གཙང་བ་སྟེ། ཤིང་གི་སྣོད་དམ། གོས་སམ། ཀོ་བའམ། རྩྭ་ཕད་དམ། ཡང་ན་ལག་ཆ་གང་ཡིན་ཡང་ཆུ་རུ་སྦང་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་ཞིང་དེའི་རྗེས་སུ་ད་གཟོད་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","དེ་དག་ལས་གཅིག་རྫ་སྣོད་དུ་ལྷུང་ན། དེའི་ནང་ཡོད་པ་ཐམས་ཅད་མི་གཙང་བར་གྱུར་ཅིང་། རྫ་སྣོད་དེ་གཅོག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","དེའི་ནང་གི་ཟས་རིགས་གང་ཡིན་ཡང་ཆུ་དེ་འདྲེས་ན་མི་གཙང་བ་ཡིན་ལ། སྣོད་ཆས་ནང་གི་བཏུང་བྱ་ཡང་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","དེ་དག་གི་རོ་ལས་ཆ་ཤས་ཙམ་དངོས་པོ་གང་རུང་གི་སྟེང་དུ་ལྷུང་ནའང་། དངོས་པོ་དེ་ནི་མི་གཙང་བར་གྱུར་པ་དང་། མེ་ཐབ་བམ་ཚ་ཐབ་གང་ཡིན་ཡང་རྡུལ་དུ་བརླག་དགོས། དེ་དག་མི་གཙང་བ་ཡིན་ལ། ཁྱོད་རྣམས་ལ་མཚོན་ནའང་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","འོན་ཀྱང་ཆུ་མིག་དང་རྫིང་བུ་སྟེ་ཆུ་འཁྱིལ་ས་རྣམས་ནི་སྔར་བཞིན་གཙང་མ་ཡིན་གྱི། དེ་དག་གི་རོ་ལ་རེག་པ་རྣམས་ནི་ད་གཟོད་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","གལ་སྲིད་དེ་དག་གི་རོ་ལས་ཆ་ཤས་ཙམ་རྨོ་འདེབས་ཀྱི་ས་བོན་སྟེང་དུ་ལྷུང་ན། ས་བོན་ནི་སྔར་བཞིན་གཙང་མ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ཅི་སྟེ་ས་བོན་དེ་ལ་ཆུ་བརྒྱབ་པ་དང་། དེ་དག་གི་རོ་ལས་ཆ་ཤས་ཙམ་དེའི་སྟེང་དུ་ལྷུང་ན། ས་བོན་དེ་ཁྱོད་རྣམས་ལ་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","གལ་སྲིད་ཁྱོད་རྣམས་ཀྱི་ཁ་ཟས་སུ་རུང་བའི་ཕྱུགས་ཟོག་ལས་གཅིག་ཤི་བ་དང་། སུ་ཞིག་གིས་དེའི་རོ་ལ་རེག་ན་དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","སུ་ཞིག་གིས་སྲོག་ཆགས་ཀྱི་ཤི་རོ་དེ་ཟོས་ན། རང་གི་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་པ་དང་། སུ་ཞིག་གིས་སྲོག་ཆགས་ཀྱི་ཤི་རོ་དེ་ཁྱེར་བ་ཡིན་ན། རང་གི་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ས་སྟེང་གི་ལྟོ་འགྲོ་སྲོག་ཆགས་ཐམས་ཅད་ནི་སྐྱུག་བྲོ་བ་ཡིན་པས་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ལྟོ་བས་འགྲོ་བའམ་རྐང་ལག་བཞི་པོས་འགྲུལ་བ། ཡང་ན་སུག་མང་གིས་འགྲུལ་བ་བཅས་ས་སྟེང་གི་ལྟོ་འགྲོ་སྲོག་ཆགས་ཐམས་ཅད་ནི་སྐྱུག་བྲོ་བ་ཡིན་པས་བཟའ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ཁྱོད་རྣམས་ཀྱིས་ལྟོ་འགྲོ་སྲོག་ཆགས་གང་རུང་གི་རྐྱེན་གྱིས་རང་ཉིད་སྐྱུག་བྲོ་བར་མ་བྱེད་ཅིག ཡང་དེ་དག་གི་རྐྱེན་གྱིས་མི་གཙང་བ་དང་བཙོག་པར་མ་བྱེད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པས་ཁྱོད་རྣམས་ཀྱིས་རང་ཉིད་དམ་པར་བསྒྱུར་དགོས། བདག་ནི་དམ་པ་ཡིན་པའི༌ཕྱིར། ཁྱོད་ཀྱང་དམ་པ་ཡིན་དགོས་ཏེ། ཁྱོད་རྣམས་ཀྱིས་ས་ལ་ལྟོ་བས་འགྲུལ་བའི་ལྟོ་འགྲོ་སྲོག་ཆགས་གང་གི་རྐྱེན་གྱིས་ཀྱང་རང་ཉིད་མི་གཙང་བར་བྱེད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་བྱེད་པའི་ཆེད་དུ་ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་ཡོང་མཁན་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ལ། བདག་ནི་དམ་པ་ཡིན་པའི་ཕྱིར། ཁྱོད་ཀྱང་དམ་པ་ཡིན་དགོས་སོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","དེ་ནི་ཕྱུགས་ཟོག་སྟེ་འདབ་ཆགས་དང་ཆུ་ནང་རྒྱུ་བའི་སྲོག་ཆགས་དང་། ས་སྟེང་གི་ལྟོ་འགྲོ་སྲོག་ཆགས་ཐམས་ཅད་ཀྱི་བཀའ་ཁྲིམས་ཡིན་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ཁྱོད་རྣམས་ཀྱིས་གཙང་དང་མི་གཙང་བ་དང་། བཟའ་རུང་བ་དང་བཟའ་མི་རུང་བའི་སྲོག་ཆགས་ཀྱི་དབྱེ་བ་རྟོགས་པའི་ཕྱིར་ཡིན་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག བུད་མེད་ཅིག་མངལ་དང་ལྡན་པར་གྱུར་ནས་བུ་བཙས་ན། ཁོ་མོ་ཟླ་མཚན་འབབ་པའི་སྐབས་སུ་མི་གཙང་བ་བཞིན་དུ་ཉིན་བདུན་ལ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ཉིན་བརྒྱད་པ་ལ་བུའི་མཚན་སྐྱི་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","བུད་མེད་ལ་ཕྲུ་གུ་སྐྱེས་རྗེས་ཁྲག་ཤོར་བ་གཙང་མར་འགྱུར་བ་ལ་ཉིན་སུམ་ཅུ་སོ་གསུམ་དགོས་ཤིང་། ཁོ་མོ་གཙང་མར་བཟོ་བའི་ཉིན་མོ་རྣམས་མ་རྫོགས་གོང་རྫས་དམ་པར་རེག་པའམ་གནས་མཆོག་ལ་འགྲོ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","གལ་སྲིད་ཁོ་མོས་བུ་མོ་བཙས་ན། ཁོ་མོ་ཟླ་མཚན་འབབ་པའི་སྐབས་དང་འདྲ་བར་བདུན་ཕྲག་གཉིས་ལ་མི་གཙང་བ་དང་། ཁོ་མོར་ཕྲུ་གུ་སྐྱེས་རྗེས་ཁྲག་ཤོར་བ་གཙང་མར་འགྱུར་བ་ལ་ཉིན་དྲུག་ཅུ་རེ་དྲུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","གཙང་མར་བཟོ་བའི་ཉིན་ལོངས་རྗེས། བུའམ་བུ་མོ་གང་ཞིག་སྐྱེས་ཀྱང་། ཁོ་མོས་སྦྱིན་སྲེག་གི་ཕྱིར་ལུ་གུ་ལོ་གཅིག་ཅན་ཞིག་དང་། སྡིག་བཤགས་མཆོད་པར་ཕུག་རོན་ཆུང་ངུ་གཅིག་གམ་བྱ་ཐི་བ་ཞིག་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ཁྱེར་འོངས་ཏེ་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","མཆོད་དཔོན་གྱིས་མཆོད་རྫས་དེ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕུལ་ནས། བུད་མེད་ཀྱི་སྡིག་པ་བཤག་དགོས། དེ་ལྟར་བྱས་ན་ཁོ་མོ་མངལ་ཁྲག་ལས་གཙང་བར་འགྱུར། དེ་ནི་བུ་དང་བུ་མོ་བཙའ་བའི་བུད་མེད་ཀྱི་བཀའ་ཁྲིམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","གལ་སྲིད་བུད་མེད་ཀྱིས་ལུ་གུ་ཞིག་འབུལ་བར་མི་ནུས་ན། ཁོ་མོས་བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་ཁྱེར་འོངས་ནས་གཅིག་ནི་སྦྱིན་སྲེག་དང་། ཅིག་ཤོས་ནི་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། མཆོད་དཔོན་གྱིས་ཁོ་མོའི་སྡིག་པ་བཤག་དགོས་ལ་ཁོ་མོ་གཙང་མར་འགྱུར་ཞེས་སྨྲ་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","གལ་སྲིད་སུ་ཞིག་གི་ལུས་ཀྱི་སྐྱི་མོ་ལ་སྐྲངས་འབུར་རམ་སིབ་རྒྱས་པ། ཡང་ན་ཁྲ་ཐིག་ལྷུང་བ་བཅས་མཛེ་ནད་དུ་འགྱུར་སྲིད་པའི་ནད་ཡམས་བྱུང་ཚེ། མི་དེ་མཆོད་དཔོན་ཨ་རོན་ནམ། ཡང་ན་དེའི་བུ་མཆོད་དཔོན་ཡིན་པ་རྣམས་ལས་གཅིག་གི་དྲུང་དུ་འཁྲིད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","མཆོད་དཔོན་གྱིས་དེའི་ལུས་ཀྱི་སྐྱི་མོའི་ནད་རྟགས་ལ་བརྟགས་ནས། ནད་ཡོད་སའི་བ་སྤུ་རྣམས་དཀར་པོར་གྱུར་ཅིང་། ནད་ཡམས་དེ་ལུས་ཀྱི་སྐྱི་མོའི་ནང་དུ་འཐིམ་ཡོད་པ་མཐོང་ན། དེ་ནི་མཛེ་ནད་ཀྱི་རྟགས་ཡིན་པས། མཆོད་དཔོན་གྱིས་བརྟག་དཔྱད་བྱས་རྗེས་མི་དེ་མི་གཙང་བ་ཡིན་པར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","གལ་སྲིད་མི་དེའི་ལུས་ཀྱི་སྐྱི་མོ་ལ་ཁྲ་ཐིག་དཀར་པོ་ཡོད་ཀྱང་དེ་ནི་སྐྱི་མོའི་ནང་དུ་འཐིམ་མེད་པ་དང་། དེའི་སྟེང་གི་བ་སྤུ་རྣམས་ཀྱང་དཀར་པོར་གྱུར་མེད་ན། མཆོད་དཔོན་གྱིས་ནད་པ་དེ་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ཉིན་བདུན་པར་མཆོད་དཔོན་གྱིས་དེར་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་མཆོད་དཔོན་གྱིས་ནད་ཡམས་གཟུགས་མ་འགྱུར་བར་གནས་པ་དང་སྐྱི་མོའི་སྟེང་མ་ཁྱབ་པ་མཐོང་ན། མི་དེ་ཡང་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","དེ་ནས་ཉིན་བདུན་པར་མཆོད་དཔོན་གྱིས་དེ་ལ་སླར་ཡང་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་ཏེ་ནད་ཡམས་ཇེ་ཡང་དུ་སོང་བ་དང་སྐྱི་མོའི་སྟེང་མ་ཁྱབ་པ་མཐོང་ན། མཆོད་དཔོན་གྱིས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས། ཅི་ལ་ཟེར་ན། དེ་ནི་རྨ་སྐོགས་ཙམ་ཡིན་པའི་ཕྱིར་རོ། །མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་དགོས་ལ་དེ་ནས་གཙང་མར་འགྱུར་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","མི་དེར་མཆོད་དཔོན་གྱིས་བརྟག་དཔྱད་བྱས་ནས་གཙང་མ་ཡིན་པར་བསྒྲགས་རྗེས། གལ་ཏེ་རྔོ་ནི་སྐྱི་མོའི་སྟེང་རྒྱ་ཆེར་ཁྱབ་ན། ཁོས་ཡང་བསྐྱར་མཆོད་དཔོན་ལ་སྟོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ཡང་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་ཅིང་། ལྟོས་དང་། རྔོ་ནི་སྐྱི་མོའི་སྟེང་ཁྱབ་ཡོད་པ་མཐོང་ན། དེ་ནི་མཛེ་ནད་ཡིན་པས་མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","གལ་སྲིད་མི་ཞིག་ལ་མཛེ་ནད་བྱུང་ན་ཁོ་རང་མཆོད་དཔོན་གྱི་དྲུང་དུ་འཁྲིད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། སྐྱི་མོར་སྐྲངས་འབུར་དཀར་པོ་ཆགས་ནས་བ་སྤུ་དཀར་པོར་གྱུར་པ་དང་། སྐྲངས་འབུར་ནང་དུ་ཤ་གསར་སྐྱེས་པ་མཐོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","དེ་ནི་ཁོའི་ལུས་ཀྱི་སྐྱི་མོར་བྱུང་བའི་གཅོང་ནད་མཛེ་ནད་ཡིན་པས། མཆོད་དཔོན་གྱིས་དེ་ནི་མི་གཙང་བ་ཡིན་པར་ཁྱབ་བསྒྲག་བྱེད་དགོས་པ་དང་། མི་དེ་མི་གཙང་བ་ཡིན་པའི་ཕྱིར་ལོགས་སུ་འགེར་མི་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","གལ་སྲིད་མཛེ་ནད་སྐྱི་མོའི་གང་ས་གང་ལ་ཁྱབ་ཅིང་། མཛེ་ནད་བྱུང་བའི་མི་དེའི་སྐྱི་མོ་ཡོངས་ལ་གང་བ་དང་། མཆོད་དཔོན་གྱིས་བལྟས་ནས་མགོ་ནས་རྐང་པའི་བར་དུ་ཁྱབ་པ་ཡིན་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་ནད་པ་དེའི་ལུས་ཡོངས་ལ་མཛེ་ནད་ཀྱིས་ཁྱབ་ཡོད་ན། མི་དེ་གཙང་མ་ཡིན་པར་ཁྱབ་བསྒྲག་བྱེད་དགོས། ཁོའི་ལུས་ཡོངས་དཀར་པོ་ཆགས་པས་གཙང་མ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","འོན་ཀྱང་ཁོའི་ལུས་སྟེང་དུ་ཤ་གསར་པ་སྐྱེས་ན། མི་དེ་ནི་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","མཆོད་དཔོན་གྱིས་ཤ་གསར་པ་སྐྱེས་ཡོད་པ་མཐོང་ན། མི་དེ་ནི་མི་གཙང་བ་ཡིན་པར་ཁྱབ་བསྒྲག་བྱེད་དགོས། ཤ་གསར་པ་སྐྱེས་པ་ནི་མི་གཙང་ཞིང་དེ་ནི་མཛེ་ནད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ཤ་གསར་པ་དེ་དཀར་པོར་གྱུར་ཡོད་ན། ཁོ་རང་མཆོད་དཔོན་གྱི་དྲུང་དུ་བཅར་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དཔྱད་བྱེད་དགོས། ལྟོས་དང་། ནད་རྟགས་དཀར་པོར་གྱུར་ཡོད་ན། མཆོད་དཔོན་གྱིས་ནད་ཡམས་བྱུང་བའི་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས་ལ། མི་དེ་གཙང་མར་གྱུར་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","གལ་སྲིད་སུ་ཞིག་གི་ལུས་ཀྱི་སྐྱི་མོར་རྨ་བུད་ཀྱང་སོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","རྨ་འབུད་ས་སྐྲངས་ནས་དཀར་པོར་གྱུར་པའམ་ཁྲ་ཐིག་དམར་སྐྱ་ཞིག་བྱུང་ན་མཆོད་དཔོན་ལ་སྟོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། ནད་རྟགས་སྐྱི་མོ་ནང་འཐིམ་པ་དང་། དེའི་སྟེང་གི་བ་སྤུ་དཀར་པོར་གྱུར་ཡོད་ན། དེ་ནི་མཛེ་ནད་ཀྱིས་རྨ་བརྟོལ་བ་ཡིན་པས། མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དཔྱད་བྱས་ནས། ལྟོས་དང་། དེའི་སྟེང་དུ་བ་སྤུ་དཀར་པོ་མེད་ལ། སྐྱི་མོའི་ནང་དུའང་འཐིམ་མེད་པ་དང་། ནད་ཡམས་ཇེ་ཡང་དུ་སོང་ཡོད་ན། མཆོད་དཔོན་གྱིས་མི་དེ་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","གལ་སྲིད་ནད་དེ་སྐྱི་མོའི་སྟེང་རྒྱ་ཆེར་ཁྱབ་ན་དེ་ནི་ནད་ཡམས་ཡིན་པས། མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","འོན་ཀྱང་ཁྲ་ཐིག་དེ་ཁ་མལ་དུ་ཡོད་ཅིང་ཁྱབ་མེད་ན། དེ་ནི་རྨ་ཤུལ་ཡིན་པས་མཆོད་དཔོན་གྱིས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","ཡང་ལུས་ཀྱི་སྐྱི་མོ་མེས་འཚིགས་ཤིང་རྨ་ཤུལ་དུ་ཤ་གསར་པ་སྐྱེས་པ་དང་ཁྲ་ཐིག་ལྷུང་བ་དམར་སྐྱའམ་དཀར་པོ་གང་ཡིན་ཡང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། ཁྲ་ཐིག་སྟེང་གི་བ་སྤུ་དཀར་པོར་གྱུར་པ་དང་ནད་རྟགས་ཀྱང་ཤ་ནང་དུ་འཐིམ་ཡོད་པ་མཐོང་ན་དེ་ནི་མཛེ་ནད་མེས་འཚིག་ཤུལ་དུ་བྱུང་བ་ཡིན་ལ། མཛེ་ནད་ཀྱི་རྟགས་ཡིན་པས་མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","གལ་སྲིད་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་ཅིང་། ལྟོས་དང་། ཁྲ་ཐིག་སྟེང་བ་སྤུ་དཀར་པོ་མེད་པ་དང་ཤ་ནང་དུའང་འཐིམ་མེད་ལ། ནད་ཡམས་ཀྱང་ཇེ་ཡང་དུ་སོང་ཡོད་པ་མཐོང་ན། མཆོད་དཔོན་གྱིས་མི་དེ་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ཉིན་བདུན་པར་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས། གལ་ཏེ་ཁྲ་ཐིག་སྐྱི་མོའི་སྟེང་རྒྱ་ཆེར་ཁྱབ་ཡོད་ན། མཛེ་ནད་ཀྱི་རྟགས་ཡིན་པས་མཆོད་དཔོན་གྱིས་མི་དེ་ནི་མི་གཙང་བར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ཡང་ཁྲ་ཐིག་ཁ་མལ་དུ་ཡོད་ཅིང་སྐྱི་མོའི་སྟེང་མ་ཁྱབ་པར་ཇེ་ཡང་དུ་སོང་ཡོད་ན། དེ་ནི་འཚིག་ཤུལ་གྱི་སྐྲངས་འབུར་ཡིན་པ་དང་། མེས་འཚིགས་པའི་རྨ་ཤུལ་ཙམ་ཡིན་པས་མཆོད་དཔོན་གྱིས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","གལ་སྲིད་སྐྱེས་པའམ་བུད་མེད་སུ་ཞིག་གི་མགོ་ལ་ནད་བྱུང་བའམ། ཡང་ན་སྐྱེས་པའི་ཁ་སྤུའི་ནང་ནད་ཡམས་བྱུང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","མཆོད་དཔོན་གྱིས་ནད་ཡམས་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་ནད་རྟགས་སྐྱི་མོའི་ནང་དུ་འཐིམ་ཡོད་པ་དང་དེའི་སྟེང་གི་བ་སྤུ་ཕྲ་མོ་མདོག་སེར་པོར་མཐོང་ན། དེ་ནི་གཡན་ནད་ཡིན་པ་དང་། མགོའམ་ཁ་སྤུའི་མཛེ་ནད་ཡིན་པས། མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","མཆོད་དཔོན་གྱིས་གཡན་ནད་ལ་བརྟག་དགོས་ཤིང་། ནད་རྟགས་སྐྱི་མོའི་ནང་འཐིམ་མེད་པ་དང་དེའི་སྟེང་དུ་བ་སྤུ་ནག་པོའང་མེད་པ་མཐོང་ན། མཆོད་དཔོན་གྱིས་གཡན་ནད་ཕོག་པའི་མི་དེ་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ཡང་ཉིན་བདུན་པར་མཆོད་དཔོན་གྱིས་ནད་ཡམས་དེ་ལ་བརྟག་དགོས་ཤིང་། གཡན་ནད་ཁྱབ་མེད་པ་དང་དེའི་སྟེང་དུ་བ་སྤུ་སེར་པོ་ཡང་མེད་ལ། གཡན་ནད་ཀྱི་ནད་རྟགས་ཀྱང་སྐྱི་མོའི་ནང་འཐིམ་མེད་པ་མཐོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","མི་དེས་སྐྲ་དང་ཁ་སྤུ་བཞར་དགོས་མོད། འོན་ཀྱང་གཡན་ནད་ཡོད་ས་བཞར་མི་རུང་ལ། མཆོད་དཔོན་གྱིས་གཡན་ནད་ཕོག་པའི་མི་དེ་སླར་ཡང་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ཉིན་བདུན་པར་མཆོད་དཔོན་གྱིས་གཡན་ནད་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གཡན་ནི་སྐྱི་མོའི་སྟེང་ཁྱབ་མེད་པ་དང་ནད་རྟགས་ཀྱང་སྐྱི་མོའི་ནང་དུ་འཐིམ་མེད་པ་མཐོང་ན། མཆོད་དཔོན་གྱིས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས་པ་དང་། མི་དེས་རང་གི་གོས་བཀྲུ་དགོས་ལ་དེ་ནས་གཙང་མར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","འོན་ཀྱང་ཁོ་རང་གཙང་མ་ཡིན་པར་བསྒྲགས་རྗེས། གཡན་ནད་སྐྱི་མོའི་སྟེང་རྒྱ་ཆེར་ཁྱབ་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། གཡན་ནད་སྐྱི་མོའི་སྟེང་ཁྱབ་ཡོད་པ་མཐོང་ན། མི་དེ་ནི་མི་གཙང་བ་ཡིན་པས་མཆོད་དཔོན་གྱིས་བ་སྤུ་སེར་པོ་བཙལ་དགོས་དོན་མེད། ");
INSERT INTO bodn_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","གལ་སྲིད་གཡན་ནད་མཆོད་དཔོན་གྱི་མཐོང་ངོར་འཇགས་ནས་དེའི་སྟེང་དུ་བ་སྤུ་ནག་པོ་སྐྱེས་ཡོད་ན། གཡན་ནད་སོས་པ་དང་མི་དེ་ནི་གཙང་མ་ཡིན་པས། མཆོད་དཔོན་གྱིས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","སྐྱེས་པའམ་བུད་མེད་སུ་ཡིན་ཡང་། གལ་སྲིད་ལུས་སྟེང་གི་སྐྱི་མོར་ཁྲ་ཐིག་དཀར་པོ་བྱུང་ཡོད་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། སྐྱི་མོའི་ཁྲ་ཐིག་དཀར་པོ་དེ་མོག་པོར་མཐོང་ན། དེ་ནི་རྔོ་ནད་ཀྱིས་སྐྱི་མོ་བརྟོལ་བ་ཡིན་པས་ཁོ་ནི་གཙང་མ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","གལ་སྲིད་སུ་ཞིག་གི་སྐྲ་ལྷུང་ནས་སྤྱི་ཐེར་དུ་གྱུར་ན། དེ་ནི་གཙང་མ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","གལ་སྲིད་མི་དེའི་སྐྲ་འདབས་ལྷུང་ཞིང་སྤྱི་ཐེར་དུ་གྱུར་པ་ཡིན་ན། དེ་ནི་གཙང་མ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","འོན་ཀྱང་སྤྱི་གཙུག་སྤྱི་ཐེར་ཡིན་སའམ་ཐོད་སྐྲ་སྤྱི་ཐེར་ཡིན་སར་ནད་རྟགས་དམར་སྐྱ་ཡིན་ན། དེ་ནི་མཛེ་ནད་ཁོའི་སྤྱི་གཙུག་དང་ཐོད་སྐྲ་ལྷུང་སར་ཁྱབ་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ཡང་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་སྤྱི་གཙུག་དང་ཐོད་སྐྲ་སྤྱི་ཐེར་ཡིན་སའི་ནད་ཡམས་ཀྱི་སྐྲངས་འབུར་དེ་དམར་སྐྱ་ཡིན་ཞིང་། ལུས་སྟེང་གི་སྐྱི་མོའི་མཛེ་ནད་ལྟར་མཐོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","མི་དེར་མཛེ་ནད་བྱུང་བ་ཡིན་པས་མི་གཙང་བ་ཡིན། དེའི་མགོ་ལ་ནད་ཡམས་བྱུང་བ་ཡིན་པས། མཆོད་དཔོན་གྱིས་མི་དེ་མི་གཙང་བར་བསྒྲག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","མཛེ་ནད་བྱུང་བའི་མི་ཡི་གོས་རྣམས་དབྲལ་དགོས་པ་དང་། མགོ་ཟིང་ནས་སྐྲ་བཤིག་ཅིང་། ཡ་ཁ་བཀབ་ནས་མི་གཙང་མི་གཙང་ཞེས་སྐད་ཆེན་པོས་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ནད་ཡམས་ད་དུང་ཁོའི་སྟེང་དུ་ཡོད་པའི་ཚེ། ཁོ་ནི་མི་གཙང་བ་ཡིན་ལ། མི་གཙང་བ་ཡིན་པའི་རྐྱེན་གྱིས་ཁོ་གཅིག་པུར་བསྡད་ནས་སྒར་གྱི་ཕྱི་རོལ་ཏུ་གནས་དགོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ཡང་གོས་ཤིག་ལ་མཛེ་ནད་འགོས་ཡོད་ན། བལ་ལྭའམ་སོ་རས་ཀྱི་གོས་སམ། ");
INSERT INTO bodn_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","སོ་རས་སམ་བལ་གྱི་གཞུང་ངམ་འཕྲེད་ཐིག་གམ། ཀོ་བའམ་ཀོ་བཟོས་དངོས་པོ་གང་དང་གང་ཡང་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","གལ་སྲིད་གོས་སམ་ཀོ་བའམ། གཞུང་ངམ། འཕྲེད་དམ། ཡང་ན་ཀོ་བཟོས་དངོས་པོ་གང་དང་གང་ལ་མདོག་ལྗང་གུའམ་དམར་པོ་ཆགས་ཡོད་ན། དེ་ནི་མཛེ་ནད་བྱུང་བ་ཡིན་པས་མཆོད་དཔོན་ལ་སྟོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ཡང་མཆོད་དཔོན་གྱིས་གཡན་སྤུ་དེ་ལ་བརྟག་ཅིང་། གཡན་སྤུ་སྐྱེས་པའི་དངོས་པོ་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ཉིན་བདུན་པར་གཡན་སྤུ་ལ་བརྟག་དགོས་ཤིང་། གལ་སྲིད་གཡན་སྤུ་ནི་གོས་ཀྱི་སྟེང་དུ་ཡོད་ན། དེ་གཞུང་ངམ་འཕྲེད་ཐིག་གང་རུང་ངམ། ཡང་ན་བཀོལ་སྤྱོད་བྱེད་པའི་ཀོ་བཟོས་དངོས་པོ་གང་རུང་གི་སྟེང་ཁྱབ་པ་ཡིན་ན། དེ་ནི་མཛེ་ནད་ཁྱབ་པའི་རྟགས་ཡིན་པས་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","གཡན་སྤུ་སྐྱེས་པའི་གོས་ནི་གཞུང་ངམ་འཕྲེད་ཐིག་གམ། བལ་ལམ་སོ་རས་གང་ནས་ཡིན་པ་དང་། ཡང་ན་ཀོ་བཟོས་དངོས་པོ་གང་ཡིན་རུང་ཐམས་ཅད་མེ་ལ་བསྲེག་དགོས་ཏེ། དེ་ནི་མཛེ་ནད་ཁྱབ་པའི་རྟགས་ཅན་ཡིན་པས་མེ་ལ་བསྲེག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","འོན་ཀྱང་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་ཅིང་། ལྟོས་དང་། གཡན་སྤུ་དེ་གོས་ཀྱི་སྟེང་དུ་ཡོད་ཀྱང་། གཞུང་ངམ་འཕྲེད་གང་རུང་ངམ། ཡང་ན་ཀོ་བཟོས་དངོས་པོའི་སྟེང་དུ་ཁྱབ་མེད་ན། ");
INSERT INTO bodn_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","མཆོད་དཔོན་གྱིས་གཡན་སྤུ་སྐྱེས་པའི་དངོས་པོ་རྣམས་མི་ལ་བཀྲུ་བར་བཅུག་ནས། སླར་ཡང་ཉིན་བདུན་ལ་ལོགས་སུ་འགེར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","བཀྲུས་པའི་རྗེས་སུ་མཆོད་དཔོན་གྱིས་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གཡན་སྤུ་དེ་ཁོའི་མཐོང་ངོར་མདོག་འགྱུར་མེད་ན། གཡན་སྤུ་ཁྱབ་མེད་ནའང་དེ་ནི་མི་གཙང་བ་ཡིན། དེ་ནི་ནད་ཡམས་རུལ་རྟགས་ཅན་ཡིན་པས་མདུན་རྒྱབ་གང་དུ་ཡོད་ནའང་དངོས་པོ་དེ་མེས་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ཅི་སྟེ་མཆོད་དཔོན་གྱིས་དེ་ལ་བརྟག་ཅིང་། ལྟོས་དང་། བཀྲུས་པའི་རྗེས་སུ་གཡན་སྤུ་མདོག་ཡལ་བ་མཐོང་ན། ཁོས་གོས་དང་ཀོ་བ་ནས་གཞུང་ངམ་འཕྲེད་དུ་གཡན་སྤུ་སྐྱེས་པའི་རིམ་པ་དབྲལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","གལ་སྲིད་གཡན་སྤུ་ཡང་བསྐྱར་གོས་ཀྱི་སྟེང་གཞུང་ངམ་འཕྲེད་ཐིག་གང་རུང་ནས་མངོན་པའམ། ཡང་ན་ཀོ་བཟོས་དངོས་པོ་གང་རུང་གི་སྟེང་ཐོན་ན། དེ་ནི་གཡན་སྤུ་རྙིང་བ་དེ་ཡང་བསྐྱར་སྐྱེས་པ་ཡིན་པས། གཡན་སྤུ་སྐྱེས་པའི་དངོས་པོ་དེ་མེས་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","འོན་ཀྱང་བཀྲུས་ཟིན་པའི་གོས་ནི་གཞུང་ངམ་འཕྲེད་ཐིག་གམ། ཡང་ན་ཀོ་བཟོས་དངོས་པོ་གང་རུང་གི་གཡན་སྤུ་ཡལ་བ་ཡིན་ན། ད་དུང་ཡང་བསྐྱར་བཀྲུ་དགོས་ལ། དེ་ནས་གོས་དེ་གཙང་མར་གྱུར་པའོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","དེ་ནི་གོས་ལ་གཡན་སྤུ་སྐྱེས་པའི་བཀའ་ཁྲིམས་ཡིན་ལ། བལ་ལྭའམ་སོ་རས་གྱི་གོས་སམ། གཞུང་ངམ་འཕྲེད་ཐིག་གང་རུང་ངམ། ཡང་ན་ཀོ་བཟོས་དངོས་པོ་གང་ཡིན་རུང་། ཐམས་ཅད་ཁྲིམས་སྲོལ་འདི་བཞིན་གཙང་མི་གཙང་བསྒྲག་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","མཛེ་ནད་ཕོག་པའི་མི་ཞིག་གཙང་མར་གྱུར་སྐབས་ཀྱི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། མི་དེ་མཆོད་དཔོན་གྱི་མདུན་དུ་འཁྲིད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","མཆོད་དཔོན་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་སོང་ནས་མཛེ་ནད་ཅན་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་དེའི་མཛེ་ནད་དྲག་པ་ཡིན་ན། ");
INSERT INTO bodn_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","མཆོད་དཔོན་གྱིས་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་ཕྱིར་དུ། བྱ་གསོན་པོ་གཙང་མ་གཉིས་དང་ཐང་ཤིང་དང་། སེང་སྐུད་མཚལ་དམར་དང་། ཨི་སོབ་རྩྭ་ཤིང་བཅས་འཁྱེར་འོང་དུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","དེ་ནས་མཆོད་དཔོན་གྱིས་རྫ་སྣོད་ནང་གི་ཆུ་དྭངས་མོའི་ཐོག་ཏུ་བྱ་གཅིག་གསོད་དུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","བྱ་གསོན་པོ་དེ་ནི་མཆོད་དཔོན་གྱིས་ཐང་ཤིང་དང་། སེང་སྐུད་མཚལ་དམར་དང་། ཨི་སོབ་རྩྭ་ཤིང་བཅས་དང་མཉམ་དུ་ཆུ་གཙང་མའི་སྟེང་དུ་བསད་པའི་བྱ་དེའི་ཁྲག་ནང་དུ་བསྒྲེས་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ཁོས་མཛེ་ནད་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་ལུས་སྟེང་དུ་ལན་བདུན་ལ་གཏོར་རྗེས་མི་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས། དེ་ནས་བྱ་གསོན་པོ་དེ་ཡང་ཐང་ཆེན་དུ་གཏོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","གཙང་མར་བཟོ་དགོས་པའི་མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། སྐྲ་སྤུ་ཐམས་ཅད་བཞར་ནས་ལུས་པོ་ཆུས་བཀྲུས་རྗེས་ཁོ་རང་གཙང་མར་གྱུར་པ་ཡིན་ལ། དེ་ནས་ཁོ་སྒར་ཁའི་ནང་དུ་འོང་ཆོག་ཀྱང་། ཉིན་བདུན་ལ་རང་གི་གུར་གྱི་ཕྱི་རུ་འདུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ཉིན་བདུན་པ་ལ། མི་དེས་རང་གི་སྐྲ་སྤུ་ཐམས་ཅད་དེ། སྐྲ་དང་ཨག་ཚོམ་དང་སྨིན་མ་བཅས་ལུས་ཡོངས་ཀྱི་སྐྲ་སྤུ་ཐམས་ཅད་གཞར་དགོས། དེ་ནས་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུས་རྗེས་གཙང་མར་གྱུར་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ཡང་ཉིན་བརྒྱད་པ་ལ། མི་དེས་སྐྱོན་མེད་པའི་ལུ་གུ་ཕོ་ཅན་གཉིས་དང་མོ་ལུག་ལོ་གཅིག་ཅན་གཅིག འབྲུ་རིགས་ཀྱི་མཆོད་པའི་གྲོ་ཞིབ་སྣུམ་བསྲེས་མ་ཨེ་ཕཱ་བཅུ་ཆ་གསུམ་དང་སྣུམ་ལོ་རྒི་ གཅིག་བཅས་འཁྱེར་འོང་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","གཙང་མར་བཟོ་མཁན་མཆོད་དཔོན་གྱིས། གཙང་མར་བཟོ་དགོས་པའི་མི་དེ་རྫས་དེ་དག་དང་མཉམ་དུ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","མཆོད་དཔོན་གྱིས་ལུ་གུ་ཕོ་ཞིག་ཉེས་སེལ་མཆོད་པར་འབུལ་དགོས་ཞིང་། ཡང་སྣུམ་ལོ་རྒི་གཅིག་བླངས་ནས་དེ་དག་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ཏེ་གཡོབ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","དེ་ནས་ཉེས་སེལ་མཆོད་པ་ནི་སྡིག་བཤགས་མཆོད་པ་ལྟར་མཆོད་དཔོན་ལ་དབང་བ་ཡིན་པས། ལུ་གུ་ཕོ་དེ་སྡིག་བཤགས་མཆོད་པའི་ཕྱུགས་ཟོག་དང་། སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་བཤའ་སའི་གནས་ཏེ་གནས་མཆོག་ཏུ་གསོད་དགོས་ལ། དེ་ནི་ཀུན་ལས་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","མཆོད་དཔོན་གྱིས་ཉེས་སེལ་མཆོད་པའི་ཁྲག་ཅུང་ཙམ་བླངས་ནས། གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་རྣ་ཤལ་གཡས་པ་དང་། ལག་གཡས་པའི་མཐེ་བོང་དང་རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་སུ་འབྱུག་པར་བྱ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","མཆོད་དཔོན་གྱིས་ལོ་རྒི་གཅིག་གི་སྣུམ་དེ་ལས་ཅུང་ཙམ་བླངས་ནས་རང་གི་ལག་གཡོན་པའི་ལག་མཐིལ་དུ་ལྡུག་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ལག་གཡས་པའི་མཛུབ་མོ་རང་གི་ལག་གཡོན་པའི་ལག་མཐིལ་དུ་ཡོད་པའི་སྣུམ་གྱི་ནང་དུ་བསྒྲེས་ནས། མཛུབ་མོས་སྣུམ་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ལན་བདུན་གཏོར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","དེ་ནས་མཆོད་དཔོན་གྱིས་ལག་མཐིལ་གྱི་སྣུམ་ལྷག་མ་ཅུང་ཙམ་བླངས་ནས་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་རྣ་ཤལ་གཡས་པ་དང་ལག་གཡས་པའི་མཐེ་བོང་དང་། རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་སུ་ཉེས་སེལ་མཆོད་པའི་ཁྲག་བྱུགས་སར་འབྱུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","མཆོད་དཔོན་གྱིས་ལག་མཐིལ་གྱི་སྣུམ་ལྷག་མ་རྣམས་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་མགོར་འབྱུག་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་མི་དེའི་སྡིག་པ་བཤག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ཁོས་སྡིག་བཤགས་མཆོད་པ་ཕུལ་ནས་མི་གཙང་བ་ལས་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་སྡིག་པ་བཤགས་རྗེས། སྦྱིན་སྲེག་གི་ཕྱུགས་ཟོག་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","དེ་ནས་མཆོད་དཔོན་གྱིས་སྦྱིན་སྲེག་དང་འབྲུ་མཆོད་རྣམས་མཆོད་ཁྲིའི་སྟེང་འབུལ་བ་དང་། ཁོས་མི་དེའི་སྡིག་པ་བཤག་པར་བྱ་ཞིང་། དེ་ནས་མི་དེ་གཙང་མར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","གལ་སྲིད་མི་དེ་དབུལ་ཞིང་རྒྱུ་ནོར་དེ་ཙམ་མེད་ན། ལུ་གུ་ཕོ་ཞིག་ཉེས་སེལ་མཆོད་པའི་ཕྱིར་འཁྱེར་འོང་བ་དང་། གཡོབ་མཆོད་དུ་ཕུལ་ནས་ཁོའི་སྡིག་པ་བཤག་དགོས། ཡང་འབྲུ་མཆོད་དུ་འབུལ་བའི་གྲོ་ཞིབ་སྣུམ་བསྲེས་མ་བྲེ་ཡི་བཅུ་ཆ་གཅིག་དང་། སྣུམ་ལོ་རྒི་གཅིག་དེ་དང་མཉམ་དུ་འཁྱེར་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ཡང་ཁོས་རང་གི་རྒྱུ་ནོར་འཛོམ་ཚོད་ལྟར་བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་ཁྱེར་འོངས་ཏེ། གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་། ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ཉིན་བརྒྱད་པར། རང་ཉིད་གཙང་མར་འགྱུར་བའི་ཕྱིར་དུ་ཁོས་དེ་དག་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་ཁྱེར་ནས་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","མཆོད་དཔོན་གྱིས་ཉེས་སེལ་མཆོད་པའི་ལུ་གུ་དང་། སྣུམ་ལོ་རྒི་གཅིག་པོ་དེ་མཉམ་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ནས་གཡོབ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","དེ་ནས་ཡང་ཁོས་ཉེས་སེལ་མཆོད་པའི་ལུ་གུ་བཤས་ནས། ཉེས་སེལ་མཆོད་པ་དེའི་ཁྲག་ལས་ཅུང་ཙམ་བླངས་ཏེ། གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་རྣ་ཤལ་གཡས་པ་དང་ལག་གཡས་པའི་མཐེ་བོང་། རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་ལ་འབྱུག་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","མཆོད་དཔོན་གྱིས་སྣུམ་ཅུང་ཙམ་ཞིག་རང་གི་ལག་གཡོན་པའི་ལག་མཐིལ་དུ་བླུགས་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ལག་གཡས་པའི་མཛུབ་མོས་ལག་གཡོན་པའི་ལག་མཐིལ་དུ་ཡོད་པའི་སྣུམ་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ལན་བདུན་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","དེ་ནས་མཆོད་དཔོན་གྱིས་རང་གི་ལག་མཐིལ་གྱི་སྣུམ་ལས་ཅུང་ཙམ་ཞིག་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་རྣ་ཤལ་གཡས་པ་དང་། ལག་གཡས་པའི་མཐེ་བོང་དང་རྐང་པ་གཡས་པའི་མཐེབ་ཆེན་བཅས་སུ། ཉེས་སེལ་མཆོད་པའི་ཁྲག་བྱུགས་སར་འབྱུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔ་ནས་མི་དེའི་སྡིག་པ་བཤག་ཕྱིར། མཆོད་དཔོན་གྱིས་རང་གི་ལག་མཐིལ་གྱི་སྣུམ་ལྷག་མ་རྣམས་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་མགོ་ལ་འབྱུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ཡང་མི་དེས་རང་གི་རྒྱུ་ནོར་འཛོམ་ཚོད་ལྟར་བྱ་ཐི་བ་གཉིས་ལས་གཅིག་གམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་ལས་གཅིག་མཆོད་པར་འབུལ་བ་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ཁོས་རང་གི་འཛོམ་ཚོད་ལྟར། བྱ་གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་། ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་འབྲུ་མཆོད་དང་ལྷན་ཅིག་འབུལ་དགོས་ལ། དེ་ནས་མཆོད་དཔོན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གཙང་མར་བཟོ་དགོས་པའི་མི་དེའི་སྡིག་པ་བཤག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","དེ་ནི་མཛེ་ནད་བྱུང་ཞིང་རྒྱུ་ནོར་མེད་པ་དག་གཙང་མར་བཟོ་དགོས་པའི་བཀའ་ཁྲིམས་ཡིན་ནོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ཁྱོད་ཅག་བདག་གིས་ཁྱོད་རྣམས་ལ་ས་སྐལ་དུ་སྤྲད་པའི་ཀ་ན་ཨན་ཡུལ་དུ་སླེབས་དུས་སུ། བདག་གིས་ཁྱོད་རྣམས་ལ་ས་སྐལ་དུ་སྤྲད་པའི་ཡུལ་དེའི་ཁང་པར་མཛེ་ནད་བྱུང་དུ་བཅུག་ཡོད་ན། ");
INSERT INTO bodn_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ཁང་བདག་སོང་ནས་མཆོད་དཔོན་ལ། ངས་བལྟས་ན་ཁང་པར་གཡན་སྤུ་སྐྱེས་འདུག་ཅེས་སྨྲ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","མཆོད་དཔོན་ཁང་པའི་ནང་བརྟག་དཔྱད་བྱེད་དུ་མ་ཕྱིན་པའི་སྔོན་ལ། ཁང་པའི་ནང་གི་དངོས་པོ་ཡོད་ཚད་བཙོག་པར་མི་འགྱུར་བའི་ཕྱིར། དེ་དག་ལ་ཁང་པའི་ནང་གི་དངོས་པོ་ཆ་ཚང་སྤོ་རུ་འཇུག་དགོས་ལ། དེའི་རྗེས་སུ་མཆོད་དཔོན་ནང་དུ་སོང་ནས་ཁང་པར་བརྟག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ཁོས་གཡན་སྤུ་དེ་ལ་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། ཁང་པའི་རྩིག་ངོས་ཀྱི་གཡན་སྤུ་དེར་མདོག་ལྗང་གུའམ་དམར་པོའི་ཐིག་རིས་ཀོང་ཀོང་ཡོད་ཅིང་། རྟགས་དེ་རྩིག་པའི་ནང་འཐིམ་པ་མཐོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","མཆོད་དཔོན་ཁང་པའི་སྒོ་ཕྱི་རུ་ཐོན་ཏེ། ཁང་པའི་སྒོ་ཉིན་བདུན་ལ་རྒྱག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ཉིན་བདུན་པར། མཆོད་དཔོན་ཡང་བསྐྱར་སོང་ནས་བརྟག་དགོས་ཤིང་། ལྟོས་དང་། གལ་སྲིད་གཡན་སྤུ་ཁང་པའི་རྩིག་ངོས་སུ་ཁྱབ་པ་མཐོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","མཆོད་དཔོན་གྱིས་གཡན་སྤུ་སྐྱེས་པའི་རྡོ་རྣམས་ཕྱིར་འདོན་པ་དང་། མཁར་ཕྱིའི་གནས་མི་གཙང་བ་ཞིག་ཏུ་གཡུག་པའི་བཀའ་གནང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ཡང་ཁོས་ཁང་པའི་རྩིག་ངོས་བཞི་པོ་འབྲད་དུ་འཇུག་པ་དང་། བྲད་པའི་འཇིམ་པ་རྣམས་མཁར་ཕྱིའི་གནས་མི་གཙང་བ་ཞིག་ལ་ལྡུག་ཏུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","དེ་ནས་ཁོ་རྣམས་ཀྱིས་རྡོ་གཞན་དག་རྡོ་ཕྱིར་བཏོན་པ་རྣམས་ཀྱི་ཚབ་ཏུ་འཇོག་པ་དང་། འཇིམ་པ་གཞན་གྱིས་ཁང་པའི་ནང་འབྱུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ཁོས་རྡོ་རྣམས་བཏོན་ནས་རྩིག་ངོས་བྲད་པ་དང་། བྱུགས་པའི་རྗེས་སུ་གཡན་སྤུ་ཡང་བསྐྱར་སྐྱེས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","མཆོད་དཔོན་ནང་དུ་སོང་ནས་བརྟག་དགོས་པ་དང་། ལྟོས་དང་། གལ་སྲིད་གཡན་སྤུ་ཁང་པའི་ནང་དུ་ཁྱབ་ཡོད་ན། དེ་ནི་ཁང་པ་རུ་གཡན་སྤུ་བསྟུད་མར་སྐྱེས་པ་ཡིན་པས་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ཁོས་ཁང་པ་བཤིགས་ནས་དེའི་རྡོ་དང་ཤིང་ཆ་དང་། འཇིམ་པ་བཅས་ཐམས་ཅད་མཁར་ཕྱིའི་གནས་མི་གཙང་བ་ཞིག་ཏུ་འཁྱེར་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ཁང་པའི་སྒོ་གཏན་པའི་དུས་ཡུན་གང་དང་གང་ལ་དེའི་ནང་དུ་འགྲོ་བའི་མི་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ཁང་པའི་ནང་དུ་ཉལ་བའི་མི་དེས་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས་པ་དང་། ཁང་པའི་ནང་དུ་ཁ་ཟས་ཟ་བའི་མི་དེས་ཀྱང་གོས་རྣམས་གཙང་མར་བཀྲུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ཁང་པར་འཇིམ་པ་བྱུགས་རྗེས་སུ། མཆོད་དཔོན་ནང་དུ་སོང་ནས་བརྟག་ཅིང་། ལྟོས་དང་། གཡན་སྤུ་ཁང་པའི་ནང་དུ་ཁྱབ་མེད་ན། གཡན་སྤུ་ཚར་བཅད་པས་ཁང་པ་དེ་གཙང་མ་ཡིན་པར་བསྒྲག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ཁོས་ཁང་པར་གཙང་སྦྲ་བྱེད་ཆེད། བྱ་གཉིས་དང་ཐང་ཤིང་དང་སེང་སྐུད་མཚལ་དམར་དང་ཨི་སོབ་རྩྭ་ཤིང་བཅས་ཁྱེར་འོངས་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","བྱ་གཅིག་རྫ་སྣོད་ནང་གི་ཆུ་དྭངས་མོའི་ཐོག་ཏུ་གསོད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ཐང་ཤིང་དང་ཨི་སོབ་རྩྭ་ཤིང་དང་། སེང་སྐུད་མཚལ་དམར་དང་། བྱ་གསོན་པོ་བཅས་ཐམས་ཅད་བསད་པའི་བྱ་དེའི་ཁྲག་དང་ཆུ་དྭངས་མོའི་ནང་བསྒྲེས་ནས། ཁང་པ་དེ་ལ་ལན་བདུན་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","དེ་ལྟར་བྱ་ཡི་ཁྲག་དང་ཆུ་དྭངས་མོ་དང་། བྱ་གསོན་པོ་དང་། ཐང་ཤིང་དང་། ཨི་སོབ་རྩྭ་ཤིང་དང་། སེང་སྐུད་མཚལ་དམར་བཅས་ཀྱིས་ཁང་པ་དེར་གཙང་སྦྲ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ཁོས་བྱ་གསོན་པོ་དེ་མཁར་ཕྱིའི་ཐང་ཆེན་དུ་གཏོང་བ་དང་། ཁོས་ཁང་པའི་སྡིག་པ་བཤག་དགོས་ཤིང་དེ་ནས་ཁང་པ་གཙང་མར་གྱུར་པའོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","དེ་ནི་མཛེ་ནད་དང་གཡན་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","གོས་དང་ཁང་པ་རྣམས་ལ་གཡན་སྤུ་སྐྱེས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","སྐྱི་མོར་སྐྲངས་འབུར་དང་སིབ་རྒྱས་པ་དང་། ཁྲ་ཐིག་ལྷུང་བ་བཅས་ཀྱི་ཕྱིར་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","དུས་ནམ་ཞིག་ལ་གཙང་བ་དང་དུས་ནམ་ཞིག་ལ་མི་གཙང་བའི་དབྱེ་བ་འབྱེད་བྱེད་ཡིན་ཞིང་། དེ་ནི་མཛེ་ནད་ཀྱི་བཀའ་ཁྲིམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","ཁྱོད་གཉིས་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག གལ་ཏེ་སྐྱེས་པ་ཞིག་གི་ལུས་སུ་རྣག་ནད་བྱུང་ན། ཁོའི་རྣག་ནད་དེ་ནི་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ཁོ་རང་འཛིར་ནད་ཀྱི་རྐྱེན་གྱིས་མི་གཙང་བར་གྱུར་པ་ནི་འདི་ལྟ་སྟེ། ལུས་ནས་རྣག་བཞུར་བའམ། ཡང་ན་ལུས་ནས་གཤེར་ཁུ་འཛིར་མཚམས་བཞག་པ་གང་ཡིན་ཡང་། ཁོ་རང་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","རྣག་ནད་བྱུང་བའི་མི་དེ་ཉལ་བའི་མལ་ཁྲི་ཐམས་ཅད་མི་གཙང་བ་དང་། མི་དེ་སྡོད་པའི་དངོས་པོ་གང་ཡིན་ཡང་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ཡང་མི་དེའི་མལ་ས་ལ་རེག་མཁན་གྱིས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","སུ་ཞིག་རྣག་ནད་ཅན་དེ་བསྡད་མྱོང་བའི་དངོས་པོའི་སྟེང་དུ་བསྡད་ན། དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","སུ་ཞིག་གིས་མི་རྣག་ནད་ཅན་གྱི་ལུས་ལ་རེག་ན། དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ཡང་རྣག་ནད་ཅན་གྱིས་སུ་ཞིག་ལ་མཆིལ་མ་འཕངས་ན། དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་། དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","རྣག་ནད་ཅན་དེ་ཞོན་པའི་སྒ་གང་དང་གང་ཡིན་རུང་དེ་ནི་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","མི་དེ་བསྡད་མྱོང་བའི་དངོས་པོ་གང་རུང་ལ་རེག་ན། དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་དང་། དངོས་པོ་དེ་དག་ཁྱེར་བ་ཡིན་ན། མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ཡང་རྣག་ནད་ཅན་དེས་རང་གི་ལག་པ་ཆུས་མ་བཀྲུས་པར་མི་སུ་ཞིག་ལ་རེག་ན། མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུའི་ནང་དུ་བཀྲུ་དགོས་ཤིང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","རྣག་ནད་ཅན་དེས་རེག་པའི་རྫ་སྣོད་གཅོག་དགོས་པ་དང་། དེས་རེག་པའི་ཤིང་གི་སྣོད་ཐམས་ཅད་ཆུ་ཡིས་བཤལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","རྣག་ནད་བྱུང་བའི་མི་དེའི་རྣག་ནད་སོས་པ་ཡིན་ན། དེས་རང་ཉིད་གཙང་མར་བཟོ་བར་ཉིན་བདུན་བརྩིས་ཏེ། རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ཆུ་གཙང་མས་ལུས་པོ་བཀྲུས་ན་གཙང་མར་གྱུར་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ཡང་ཉིན་བརྒྱད་པ་ལ་ཁོས་བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་ཁྱེར་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འོངས་ཏེ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་བྱ་རྣམས་མཆོད་དཔོན་ལ་སྤྲོད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","མཆོད་དཔོན་གྱིས་དེ་དག་ལས་བྱ་གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས་ཤིང་། ཡང་མི་དེའི་རྣག་ནད་ཀྱི་རྐྱེན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་དེའི་སྡིག་པ་བཤག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","གལ་སྲིད་སྐྱེས་པ་ཞིག་ནས་ཁུ་བ་ཟགས་ན། དེས་རང་གི་ལུས་ཧྲིལ་པོ་ཆུས་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","གོས་དང་ཀོ་བ་གང་ཡིན་ཡང་ཁུ་བ་འགོས་ན་དེ་ཆུ་ཡིས་བཀྲུ་དགོས་པ་དང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","བུད་མེད་ནི་གལ་སྲིད་སྐྱེས་པ་ཞིག་ལ་ལུས་འབྲེལ་བྱས་ནས་ཁུ་བ་འགོས་ན། དེ་གཉིས་ཀྱིས་རང་གི་ལུས་ཆུ་ཡིས་བཀྲུ་དགོས་ཤིང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","བུད་མེད་ལ་ཟླ་མཚན་འབབ་པའི་སྐབས་སུ་ལུས་ནས་ཁྲག་འཛིར་ན། ཉིན་བདུན་གྱི་བར་དུ་མི་གཙང་བ་ཡིན། མི་སུ་ཞིག་གིས་ཁོ་མོར་རེག་ཚེ་དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ཡང་མི་གཙང་བའི་སྐབས་སུ། བུད་མེད་དེ་ཉལ་བའི་དངོས་པོ་ཐམས་ཅད་མི་གཙང་བ་དང་། གང་གི་སྟེང་དུ་བསྡད་ན་དེ་ཡང་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","སུ་ཞིག་གིས་དེའི་མལ་སར་རེག་ན། དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུ་ནང་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ཡང་སུ་ཞིག་གིས་ཁོ་མོ་བསྡད་པའི་དངོས་པོ་ལ་རེག་ན། རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུ་ནང་བཀྲུ་དགོས་ལ། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","མལ་སའམ་མོ་བསྡད་པའི་དངོས་པོ་གང་རུང་ལ་སུ་ཞིག་གིས་རེག་ཚེ། དེ་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","གལ་སྲིད་སྐྱེས་པ་ཞིག་ཁོ་མོར་ལུས་འབྲེལ་བྱས་ནས་ཁོ་མོའི་མི་གཙང་བ་དེ་ཁོ་ལ་འགོས་ན། དེ་ཡང་ཉིན་བདུན་ལ་མི་གཙང་བ་ཡིན་ཏེ། ཁོ་ཉལ་བའི་མལ་ས་ཡང་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","དེ་ཡང་བུད་མེད་ལ་ཟླ་མཚན་འབབ་དུས་བརྒལ་ནས་ཉིན་མང་པོར་ཁྲག་བཞུར་བའམ། ཡང་ན་ཟླ་མཚན་འབབ་དུས་རིང་དྲགས་ན། ཁྲག་འཛིར་བའི་ཉིན་མོ་ཡོངས་ལ་ཁོ་མོ་མི་གཙང་བ་སྟེ། ཟླ་མཚན་འབབ་དུས་ཀྱི་ཉིན་རྣམས་ལ་ཁོ་མོ་མི་གཙང་བ་དང་གཅིག་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ཁྲག་འཛིར་བའི་ཉིན་མོ་རྣམས་ལ། ཁོ་མོ་ཉལ་བའི་མལ་ས་དང་། སྡོད་སའི་དངོས་པོ་གང་ཡིན་རུང་ཐམས་ཅད་མི་གཙང་བ་ཡིན་ཏེ། ཟླ་མཚན་འབབ་དུས་མི་གཙང་བ་དང་གཅིག་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ཡང་དངོས་པོ་དེ་རྣམས་ལ་རེག་མཁན་ནི་མི་གཙང་བ་ཡིན་པས། དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུས་བཀྲུ་དགོས་ལ་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","གལ་སྲིད་ཁོ་མོའི་ཁྲག་འཛིར་བ་ཆད་པ་ཡིན་ན། ཉིན་བདུན་བརྩིས་པའི་རྗེས་སུ་ད་གཟོད་གཙང་མར་གྱུར་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ཉིན་བརྒྱད་པ་ལ་ཁོ་མོས་བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་ཁྱེར་འོངས་ནས། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","མཆོད་དཔོན་གྱིས་བྱ་དེ་གཉིས་ལས་གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་། ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས་པ་དང་། བུད་མེད་དེའི་ཁྲག་འཛིར་བའི་མི་གཙང་བ་དེའི་རྐྱེན་གྱིས། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཁོ་མོའི་སྡིག་པ་བཤག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","དེ་བས་ཁྱོད་ཅག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཁོ་ཚོའི་མི་གཙང་བ་རྣམས་ལས་ལོགས་སུ་འགེར་དགོས། དེ་ལྟར་མ་བྱས་ཚེ་དེ་དག་གིས་བདག་གི་གུར་མཆོག་ཁོ་ཚོའི་ཁྲོད་དུ་ཡོད་པ་དེ་བཙོག་པར་བྱ་ཞིང་། ཁོ་རང་ཚོའི་མི་གཙང་བ་དེའི་རྐྱེན་གྱིས་འཆི་ཉེན་ཡོད་ཅེས་པའོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","དེ་ནི་འཛིར་ནད་ཕོག་པའི་མིའམ་ཁུ་བ་ཟགས་ནས་མི་གཙང་བར་གྱུར་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","བུད་མེད་ལ་ཟླ་མཚན་འབབ་པའི་དུས་དང་། སྐྱེས་ཕོ་མོར་རྣག་ནད་བྱུང་བ། བུད་མེད་མི་གཙང་བ་དང་ལུས་འབྲེལ་བྱེད་པའི་སྐྱེས་པ་བཅས་ཀྱི་ཕྱིར་དུ་བཙུགས་པའི་བཀའ་ཁྲིམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ཨ་རོན་གྱི་བུ་གཉིས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཉེ་དྲུང་དུ་བཅར་ཏེ་ཤི་བའི་རྗེས་སུ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གསུང་གླེང་མཛད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","འདི་སྐད་དུ། ཁྱོད་ཀྱིས་རང་གི་ཕུ་བོ་ཨ་རོན་ལ། ཁོ་རང་མི་འཆི་བའི་ཕྱིར་དུ། དུས་གང་རུང་དུ་གནས་དམ་པའི་ཡོལ་བ་ནང་གི་ཤུར་སྒམ་གྱི་སྟེང་ལ་ཡོད་པའི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་མདུན་དུ་མི་འགྲོ་བར་སྒོས་ཤིག ཅིའི་ཕྱིར་ཞེ་ན། བདག་ནི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་སྟེང་གི་སྤྲིན་གསེབ་ནས་སྣང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ཨ་རོན་གནས་དམ་པ་རུ་འདི་ལྟར་འཛུལ་དགོས་ཏེ། སྡིག་བཤགས་མཆོད་པར་སྒོ་ཕྱུགས་ལས་གླང་ཐུག་ཅིག་དང་། སྦྱིན་སྲེག་ཏུ་ལུག་ཐུག་ཅིག་བཅས་མཉམ་དུ་འཛུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ཁོས་སོ་རས་སྲབ་བུའི་ཕྱི་གོས་དམ་པ་དང་ནང་གོས་ལུས་ལ་གྱོན་ཏེ། སོ་རས་སྲབ་བུའི་སྐེད་ཆིངས་བཅིང་དགོས་ལ། སོ་རས་སྲབ་བུའི་ལ་ཐོད་ཀྱང་དཀྲི་བར་བྱའོ། །དེ་དག་ནི་ན་བཟའ་དམ་པ་ཡིན་པས། ཁོས་རང་གི་ལུས་ཆུ་ཡིས་བཀྲུས་ནས་དེ་དག་གྱོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ཁོས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ལས་ར་ཕོ་གཉིས་སྡིག་བཤགས་མཆོད་པར་འབུལ་བ་དང་། ལུག་ཐུག་གཅིག་སྦྱིན་སྲེག་ཏུ་འབུལ་བའི་ཕྱིར་ལེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ཨ་རོན་གྱིས་ཁོ་རང་གི་སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་ཕུལ་ནས། ཁོ་རང་ཉིད་དང་ཁྱིམ་མི་རྣམས་ཀྱི་སྡིག་པ་བཤག་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ཡང་ར་ཕོ་གཉིས་པོ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཁྲིད་འོངས་ཏེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ཨ་རོན་གྱིས་ར་ཐུག་དེ་གཉིས་ལ་རྒྱན་འཕངས་ནས། གཅིག་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དབང་བ་དང་། ཅིག་ཤོས་ནི་ཨ་ཟཱ་ཟེལ་ལ་དབང་བར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ཨ་རོན་གྱིས་རྒྱན་བླངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བབས་པའི་ར་ཐུག་དེ་ཁྲིད་འོངས་ཏེ་སྡིག་བཤགས་མཆོད་པར་འབུལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","རྒྱན་བླངས་ནས་ཨ་ཟཱ་ཟེལ་ལ་བབས་པའི་ར་ཐུག་དེ་ནི། སྡིག་པ་བཤག་བྱེད་དུ་གསོན་པོར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འཇོག་དགོས་ལ། དེ་ནས་ཨ་ཟཱ་ཟེལ་གྱི་ཕྱོགས་སུ་ཐང་སྟོང་དུ་གཏོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","ཡང་ཨ་རོན་གྱིས་རང་གི་སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་ཕུལ་ནས། ཁོ་རང་ཉིད་དང་ཁྱིམ་མི་རྣམས་ཀྱི་སྡིག་པ་བཤག་དགོས་པ་དང་། ཁོས་རང་གི་སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་གི་མཆོད་ཁྲི་ལས་སོལ་མེས་གང་བའི་སྤོས་ཕོར་དང་། བདུག་སྤོས་ཞིབ་བཏགས་ཁྱོར་བ་དོ་བླངས་ནས་ཡོལ་བའི་རྒྱབ་ཏུ་འཁྱེར་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","མི་དེ་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་བདུག་སྤོས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་མེ་ལ་སྒྲོན་ནས། བདུག་སྤོས་ཀྱི་དུ་སྤྲིན་གྱིས་དཔང་མཛད་ཤུར་སྒམ་གྱི་སྟེང་དུ་ཡོད་པའི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་གཡོག་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ཁོས་གླང་ཐུག་གི་ཁྲག་ཉུང་ཙམ་བླངས་ནས། མཛུབ་མོས་ཐུགས་རྗེའི་བཞུགས་ཁྲིའི་མདུན་དང་ཤར་ཕྱོགས་སུ་གཏོར་བ་དང་། ཡང་ཐུགས་རྗེའི་བཞུགས་ཁྲིའི་མདུན་དུ་ཁྲག་དེ་མཛུབ་མོས་ལན་བདུན་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ཁོས་མི་རྣམས་ཀྱི་སྡིག་བཤགས་མཆོད་པར་འབུལ་བའི་ར་ཐུག་བཤས་ནས། དེའི་ཁྲག་ཡོལ་བའི་རྒྱབ་ཏུ་འཁྱེར་འོང་ཞིང་། གླང་ཐུག་གི་ཁྲག་གཏོར་བ་བཞིན་དུ་ཁྲག་འདི་ཡང་ཐུགས་རྗེའི་བཞུགས་ཁྲིའི་སྟེང་དང་དེའི་མདུན་དུ་གཏོར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་གཙང་བ་དང་ཉེས་སྐྱོན་ཏེ། ཁོ་རྣམས་ཀྱི་སྡིག་པ་མཐའ་དག་གི་ཕྱིར་དུ། ཁོས་གནས་དམ་པའི་སྡིག་པ་བཤག་དགོས་ལ། ཁོས་དེ་རྣམས་ཀྱི་མི་གཙང་བའི་དབུས་སུ་གནས་པའི་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱིར་དུའང་དེ་བཞིན་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ཁོ་གནས་དམ་པ་རུ་འཛུལ་ནས་སྡིག་པ་བཤགས་པའི་དུས་སུ། ཁོས་རང་ཉིད་དང་ཁྱིམ་མི་རྣམས་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ཀྱི་སྡིག་པ་བཤགས་ནས་ཕྱི་རོལ་ཏུ་ཐོན་པའི་བར་དུ་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་མི་སུ་ཡང་ཡོད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ཁོ་ཕྱི་རོལ་ཏུ་ཐོན་རྗེས་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་གི་མཆོད་ཁྲིའི་རྩར་སོང་སྟེ་དེའི་སྡིག་པ་བཤག་དགོས། ཁོས་གླང་ཐུག་གི་ཁྲག་དང་ར་ཐུག་གི་ཁྲག་ལས་ཉུང་ཙམ་བླངས་ནས་མཆོད་ཁྲིའི་ཕྱོགས་བཞི་རུ་ཡོད་པའི་རུ་ཐུར་བཞི་པོར་འབྱུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ཡང་མཛུབ་མོས་དེའི་ཁྲག་མཆོད་ཁྲིའི་སྟེང་ལན་བདུན་ལ་གཏོར་བ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་མི་གཙང་བ་ལས་གཙང་མ་དང་དམ་པར་བཟོ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ཡང་ཨ་རོན་གྱིས་གནས་དམ་པ་དང་མཇལ་འཕྲད་གུར་མཆོག མཆོད་ཁྲི་བཅས་ཀྱི་སྡིག་པ་བཤགས་ཚར་རྗེས། ར་ཐུག་གསོན་པོ་དེ་འཁྲིས་སུ་འཁྲིད་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ཁོའི་ལག་པ་གཉིས་ཀ་ར་ཐུག་གསོན་པོའི་མགོ་ལ་བཞག་ནས། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ནག་ཉེས་དང་སྐྱོན་ཐམས་ཅད་དེ། ཁོ་རྣམས་ཀྱི་སྡིག་པ་ཐམས་ཅད་མཐོལ་བཤགས་བྱས་ཏེ། སྡིག་པ་ཐམས་ཅད་ར་ཐུག་གི་མགོ་ལ་བཀལ་ནས། ཆེད་བསྐོས་ཀྱི་མི་ཞིག་གིས་དེ་ཐང་སྟོང་དུ་གཏོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ར་ཐུག་གིས་དེ་ཚོའི་ནག་ཉེས་ཐམས་ཅད་འཁུར་ཞིང་གནས་དབེན་པ་ཞིག་ཏུ་འཁྱེར་དགོས་པས། མི་དེས་ར་ཐུག་ནི་ཐང་སྟོང་དུ་གཏོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","དེ་ནས་ཨ་རོན་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་འཛུལ་ཞིང་། སྔར་གནས་དམ་པ་རུ་འགྲོ་དུས་གྱོན་པའི་སོ་རས་སྲབ་བུའི་གོས་རྣམས་ཕུད་ནས་དེར་འཇོག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ཡང་གནས་དམ་པ་རུ་ལུས་པོ་ཆུ་ཡིས་བཀྲུས་རྗེས་རང་གི་གོས་རྣམས་གྱོན་ནས་ཕྱི་རུ་འོངས་ཏེ། རང་གི་སྦྱིན་སྲེག་དང་མི་རྣམས་ཀྱི་སྦྱིན་སྲེག་ཕུལ་ནས་རང་ཉིད་དང་མི་རྣམས་ཀྱི་སྡིག་པ་བཤག་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","སྡིག་བཤགས་མཆོད་པར་ཕུལ་བའི་ཕྱུགས་ཟོག་གི་ཚིལ་རྣམས་མཆོད་ཁྲིའི་སྟེང་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ར་ཐུག་ཨ་ཟཱ་ཟེལ་གྱི་ཕྱོགས་སུ་གཏོང་མཁན་གྱི་མི་དེས། རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་ལུས་པོ་ཆུ་ཡིས་བཀྲུས་རྗེས་ད་གཟོད་སྒར་ནང་དུ་འགྲོ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","སྡིག་བཤགས་མཆོད་པའི་གླང་ཐུག་དང་། སྡིག་བཤགས་མཆོད་པའི་ར་ཐུག་གཉིས་ཀྱི་ཁྲག་གནས་དམ་པ་རུ་ཁྱེར་ཏེ་སྡིག་པ་བཤགས་པའི་རྗེས་སུ། གླང་ཐུག་དང་ར་ཐུག་དེ་གཉིས་སྒར་ཁའི་ཕྱི་རོལ་ཏུ་ཁྱེར་ནས། པགས་པ་དང་ཤ་དང་ལྕི་བ་བཅས་ཐམས་ཅད་མེ་ལ་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","དེ་དག་སྲེག་མཁན་གྱིས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུ་ཡིས་བཀྲུས་རྗེས་ད་གཟོད་སྒར་ནང་དུ་འགྲོ་རུང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","དེ་དག་ཁྱོད་ཅག་གི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་ཏེ། ལོ་རེའི་ཟླ་བ་བདུན་པའི་ཚེས་བཅུ་པར་རང་ཉིད་ཁྱད་གསོད་བྱེད་དགོས་པ་དང་། གཞིས་སུ་སྐྱེས་པའམ་ཁྱོད་ཚོའི་དབུས་སུ་སྡོད་པའི་བྱེས་པ་གང་གིས་ཀྱང་ལས་ཀ་ཅི་ཡང་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ཅིའི་ཕྱིར་ཞེ་ན། ཉིན་དེ་ཉིད་དུ་ཁོས་ཁྱོད་ཅག་གཙང་མར་བཟོ་ཆེད་སྡིག་པ་བཤགས་པ་ཡིན་པས། དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་དུ་ཁྱོད་རྣམས་ཀྱི་སྡིག་པ་ཐམས་ཅད་དག་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ཉིན་དེ་ནི་ཁྱོད་རྣམས་ཀྱིས་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་རུ་བསྲུངས་ནས། རང་ཉིད་ཁྱད་གསོད་བྱེད་དགོས་ལ། དེ་ནི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","སྣུམ་གྱིས་བྱུགས་ཤིང་ཕ་ཡི་ཚབ་ཏུ་ལས་འགན་དམ་པ་འཁུར་མཁན་མཆོད་དཔོན་གྱིས་སོ་རས་ཀྱི་གོས་དམ་པ་རྣམས་གྱོན་ཞིང་སྡིག་པ་བཤགས་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","གནས་དམ་མཆོག་དང་མཇལ་འཕྲད་གུར་མཆོག མཆོད་ཁྲི་བཅས་ཀྱི་ཕྱིར་སྡིག་པ་བཤགས་པར་མ་ཟད། མཆོད་དཔོན་རྣམས་དང་མི་ཚོགས་ཐམས་ཅད་ཀྱི་ཕྱིར་དུ་ཡང་སྡིག་པ་བཤག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྡིག་པ་ཐམས་ཅད་ཀྱི་རྐྱེན་གྱིས། ལོ་རེར་ཐེངས་གཅིག་ལ་དེ་དག་གི་སྡིག་པ་བཤག་དགོས་པས། འདི་ནི་ཁྱོད་རྣམས་ཀྱི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་ནོ་ཞེས་བཀའ་བསྩལ་ཏོ། །དེ་ནས་ཨ་རོན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་ཅི་ལྟར་བཀའ་བསྩལ་པ་བཞིན་དུ་བསྒྲུབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་དང་། ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་འདི་ལྟར་སྒོས་ཤིག དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་གནང་བ་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་ལས་སུ་ཞིག་གིས་བ་གླང་ངམ། ལུག་ཐུག་གམ་ར་ཐུག་བཅས་གང་རུང་བཤའ་བ་ཡིན་ན། སྒར་ནང་ངམ་སྒར་ཕྱི་གང་དུ་བཤས་ཀྱང་། ");
INSERT INTO bodn_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","གལ་སྲིད་ཕྱུགས་ཟོག་དེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ། དཀོན་མཆོག་ཡ་ཝཱེའི་གུར་མཆོག་གི་མདུན་དུ་ཁྲིད་འོངས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པར་འབུལ་བ་མིན་ན། ཁྲག་བཞུར་བ་དེ་ནི་མི་དེའི་ཉེས་པར་བགྲང་དགོས་ཤིང་། ཁོས་ཁྲག་བཞུར་དུ་བཅུག་པས་མི་དེ་ནི་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཐང་རྒོད་དུ་བཤའ་བའི་དམར་མཆོད་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་སྟེ། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ། མཆོད་དཔོན་གྱི་མདུན་དུ་ཁྱེར་འོངས་ནས་དམར་མཆོད་དེ་རྣམས་བཤའ་བ་དང་། དེ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེར་ཞི་བདེའི་མཆོད་པ་རུ་འབུལ་དགོས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","མཆོད་དཔོན་གྱིས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ། ཁྲག་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་མཆོད་ཁྲི་སྟེང་གཏོར་བ་དང་། ཚིལ་ནི་བསྲེགས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་མཆོད་པ་རུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ཁོ་ཚོས་ད་ནི་རྗེས་སུ་འབྲངས་ཏེ་ལོག་གཡེམ་བྱེད་པའི་ར་ཐུག་གི་རྟེན་རྣམས་ལ་དམར་མཆོད་འབུལ་བར་མི་བྱ་ཞིང་། དེ་ནི་ཁོ་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་ནོ་ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ཁྱོད་ཀྱིས་དེ་དག་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཡེས་ར་ཨེལ་ཁྱིམ་རྒྱུད་ཀྱི་མི་དང་དེ་དག་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་སུ་དང་གང་ཞིག་གིས་སྦྱིན་སྲེག་དང་མཆོད་རྫས་འབུལ་བ་ཡིན་ཚེ། ");
INSERT INTO bodn_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","གལ་སྲིད་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ཁྱེར་འོངས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བ་མིན་ན། མི་དེ་ནི་མི་མང་ལས་མེད་པར་གཏོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་དང་དེ་དག་གི་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་སུ་དང་སུ་ཞིག་གིས་ཁྲག་གང་རུང་ཟོས་ན། ཁྲག་ཟ་བའི་མི་དེ་ལ་བདག་གི་གདོང་མདོག་ལོག་ཅིང་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","གང་ལ་ཞེ་ན། སྲོག་ཆགས་ཀྱི་ཚེ་སྲོག་ནི་ཁྲག་གི་ནང་དུ་ཡོད་ཅིང་། ཁྲག་ནི་ཚེ་སྲོག་ཡིན་ལ་སྡིག་པ་བཤག་ནུས་པས། མཆོད་ཁྲིའི་སྟེང་ཁྱོད་རྣམས་ཀྱི་ཚེ་སྲོག་གི་ཕྱིར་སྡིག་པ་བཤག་པའི་ཆེད་དུ། བདག་གིས་ཁྲག་ནི་ཁྱོད་རྣམས་ལ་སྤྲད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","དེ་བས་ན། བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་སྐད་དུ། ཁྱོད་རྣམས་སུ་ཡིན་ཡང་ཁྲག་བཟའ་མི་རུང་ལ། ཁྱོད་ཅག་གི་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་རྣམས་ཀྱིས་ཀྱང་ཁྲག་བཟའ་མི་རུང་ཞེས་སྨྲས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་དང་དེ་དག་གི་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་སུ་དང་སུ་ཡིན་ཡང་། བཟའ་རུང་བའི་འདབ་ཆགས་སམ་རི་དྭགས་བརྔོན་པ་ཡིན་ན། དེའི་ཁྲག་བཞུར་དུ་བཅུག་ནས་ས་ཡིས་འགེབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","གང་ལ་ཞེ་ན། སྲོག་ཆགས་ཐམས་ཅད་ཀྱི་ཚེ་སྲོག་སྟེ། ཁྲག་ནི་དེའི་ཚེ་སྲོག་ཡིན་པས་སོ། །དེའི་ཕྱིར་བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་སྐད་དུ། ཁྱོད་ཅག་གིས་སྲོག་ཆགས་གང་ཡིན་ཡང་དེའི་ཁྲག་བཟའ་མི་རུང་སྟེ། སྲོག་ཆགས་ཐམས་ཅད་ཀྱི་ཚེ་སྲོག་ནི་དེའི་ཁྲག་ཡིན་པས་སོ། །ཁྲག་བཟའ་བའི་མི་ཐམས་ཅད་ནི་མེད་པར་གཏོང་ངེས་ཡིན་ཞེས་སྨྲས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","དེ་ཡང་གཞིས་སྐྱེས་སམ་བྱེས་པ་སུ་ཡིན་ཡང་། རང་བཞིན་གྱིས་ཤི་བའམ་གཅན་གཟན་གྱིས་བསད་པའི་སྲོག་ཆགས་ཟོས་པ་ཡིན་ན། མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། ལུས་པོ་ཆུ་ཡིས་བཀྲུ་དགོས་ཤིང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་དང་། དེའི་རྗེས་སུ་གཙང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","འོན་ཀྱང་ཁོས་གོས་དང་ལུས་པོ་མ་བཀྲུས་ན། རང་གི་ནག་ཉེས་འཁུར་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ཁྱོད་རྣམས་སྔར་འདུག་སའི་ཨེ་ཅིབ་ཡུལ་གྱི་མི་རྣམས་ཀྱི་སྤྱོད་པ་བཞིན་དུ་བྱེད་མི་རུང་བ་དང་། བདག་གིས་ཁྱོད་ཅག་ཁྲིད་ནས་འགྲོ་ས་ཀ་ན་ཨན་ཡུལ་གྱི་མི་རྣམས་ཀྱི་སྤྱོད་པ་བཞིན་དུ་ཡང་བྱེད་མི་རུང་ལ། དེ་དག་གི་སྒྲིག་ཁྲིམས་བཞིན་དུ་ཡང་སྤྱོད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་སྲོལ་ཡིག་ལྟར་བྱེད་པ་དང་། བདག་གི་སྒྲིག་ཁྲིམས་རྣམས་བརྩི་སྲུང་བྱེད་དགོས་ཤིང་། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","བདག་གི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་རྣམས་ནན་བསྲུང་བྱས་ན། མི་དེའང་དེ་ལ་བརྟེན་ནས་སྲོག་འཚོ་བར་འགྱུར། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","སུ་ཡིན་ཡང་རང་གི་གཉེན་ཉེའི་གམ་དུ་བཅར་ནས་དེའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ཁྱོད་ཀྱིས་རང་གི་ཕ་ལ་གཏོགས་པའི་ལུས་པོ་སྟེ་ཁྱོད་ཀྱི་མ་ཡི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། ཁོ་མོ་ནི་ཁྱོད་ཀྱི་མ་ཡིན་པའི་ཕྱིར་དེའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ཁྱོད་ཀྱིས་ཕ་ཡི་ཆུང་མ་གཅེར་བུར་འཕུད་མི་རུང་། མོའི་ལུས་གཅེར་བུ་དེ་ཁྱོད་ཀྱི་ཕ་ལ་གཏོགས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ཁྱོད་ཀྱི་ལྕམ་སྲིང་སྟེ། ཁྱོད་ཀྱི་ཕ་ཡི་བུ་མོ་དང་མ་ཡི་བུ་མོ་ཁྱིམ་ནས་སྐྱེས་པའམ་ཕྱི་ནས་སྐྱེས་པ་གང་ཡིན་ཡང་། དེ་དག་གི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ཁྱོད་ཀྱི་བུ་ཡི་བུ་མོའམ་བུ་མོའི་བུ་མོ་ཡི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། ཅི་ལ་ཞེ་ན། དེ་དག་གི་ཁོག་སྨད་གཅེར་བུར་ཕུད་པ་ནི་ཁྱོད་ཀྱི་ངོ་ཚ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ཕ་ཡི་ཆུང་མས་བཙས་པའི་བུ་མོ་ནི་ཁྱོད་ཀྱི་ལྕམ་སྲིང་ཡིན་པས། ཁྱོད་ཀྱིས་ཁོ་མོའི་ཁོག་སྨད་གཅེར་བུར་མ་ཕུད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ཁྱོད་ཀྱི་ཕ་ཡི་སྲིང་མོའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། དེ་ནི་ཁྱོད་ཀྱི་ཕ་ཡི་ཤ་ཁྲག་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ཁྱོད་ཀྱི་མ་ཡི་ལྕམ་སྲིང་གི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། དེ་ནི་ཁྱོད་ཀྱི་མ་ཡི་ཤ་ཁྲག་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ཁྱོད་ཀྱི་ཁུ་བོར་དབང་བའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པའམ་དེའི་ཆུང་མའི་ཉེ་སར་བཅར་མི་རུང་སྟེ། ཁོ་མོ་ནི་ཁྱོད་ཀྱི་ཨ་ནེ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ཁྱོད་ཀྱི་མནའ་མའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། དེ་ནི་ཁྱོད་ཀྱི་བུ་ཡི་ཆུང་མ་ཡིན་པས་དེའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ཁྱོད་ཀྱི་སྤུན་གྱི་ཆུང་མའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། དེ་ནི་ཁྱོད་ཀྱི་སྤུན་ལ་དབང་བའི་ཁོག་སྨད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","བུད་མེད་ཅིག་དང་དེའི་བུ་མོ་གཉིས་ཀྱི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་ལ། ཡང་དེའི་བུ་ཡི་བུ་མོའམ་བུ་མོའི་བུ་མོ་གཉིས་ཀྱི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་སྟེ། དེ་དག་ནི་ཉེ་འབྲེལ་ཡིན་པ་དང་། དེ་ནི་དོན་ངན་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ཁྱོད་ཀྱི་ཆུང་མ་ད་དུང་གསོན་པའི་དུས་སུ། ཁྱོད་ཀྱིས་ཁོ་མོའི་འགྲན་ཟླ་རུ་དེའི་ལྕམ་སྲིང་གཞན་ཞིག་ཆུང་མར་བླངས་ནས། ཁོ་མོའི་ལྕམ་སྲིང་གི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ཟླ་མཚན་འབབ་དུས་ཀྱི་བུད་མེད་མི་གཙང་བའི་ཉེ་སར་བཅར་ནས་ཁོ་མོའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ཁྱིམ་མཚེས་ཀྱི་ཆུང་མ་དང་འགྲོགས་ནས་རང་ཉིད་བཙོག་པར་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ཁྱོད་ཀྱིས་རང་གི་བུ་དང་བུ་མོ་རྣམས་མོ་ལེག་ལ་མེ་མཆོད་དུ་འབུལ་མི་རུང་ལ། ཁྱོད་ཀྱི་དཀོན་མཆོག་གི་མཚན་ཡང་ཁྱད་དུ་གསོད་མི་རུང་སྟེ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","བུད་མེད་དང་ལུས་འབྲེལ་བྱེད་པའི་ཚུལ་བཞིན་དུ་སྐྱེས་པ་དང་ལུས་འབྲེལ་བྱེད་མི་རུང་སྟེ། དེ་ནི་སྐྱུག་བྲོ་བའི་བྱ་སྤྱོད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","སེམས་ཅན་དུད་འགྲོ་དང་འཁྲིག་པ་སྤྱད་དེ་རང་ཉིད་བཙོག་པར་བྱེད་མི་རུང་ལ། བུད་མེད་ཀྱང་སེམས་ཅན་དུད་འགྲོའི་མདུན་དུ་ལངས་ནས་དེ་དང་འཁྲིག་པ་སྤྱོད་མི་རུང་། དེ་ནི་ཕྱིན་ཅི་ལོག་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","དོན་འདི་ཐམས་ཅད་ཀྱི་ཐད་ནས་ཁྱོད་རྣམས་ཀྱིས་རང་ཉིད་བཙོག་པར་བྱེད་མི་རུང་སྟེ། ཅི་ལ་ཞེ་ན། བདག་གིས་ཁྱོད་ཅག་གི་མདུན་ནས་ཕར་བསྐྲད་པའི་མི་རྣམས་ཀྱིས་དོན་འདི་མཐའ་དག་གི་ཐད་རང་ཉིད་བཙོག་པར་བཟོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ཐ་ན་ཡུལ་དེའང་སྦགས་པ་ཡིན་པས་བདག་གིས་ཡུལ་དེའི་ནག་ཉེས་ལ་ཆད་པ་བཅད་ཅིང་། ཡུལ་དེས་རང་གི་ཡུལ་མི་རྣམས་སྐྱུག་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","འོན་ཀྱང་ཁྱོད་ཅག་གིས་བདག་གི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་རྣམས་བསྲུང་དགོས་ཤིང་། གཞིས་སྐྱེས་སམ་ཁྱོད་ཅག་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་རྣམས་སུ་ཡིན་ཡང་། སྐྱུག་བྲོ་བའི་དོན་དེ་ལྟ་བུ་ཅི་ཡང་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ཁྱོད་ཅག་གི་སྔོན་དུ་ཡུལ་དེར་གནས་པའི་ཡུལ་མི་རྣམས་ཀྱིས་སྐྱུག་བྲོ་བའི་དོན་དེ་ཐམས་ཅད་བྱས་པས་ཡུལ་དེ་སྦགས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ཁྱོད་ཀྱིས་དེ་ལྟར་གནས་དེ་མི་གཙང་བར་བཟོས་ན། ཁྱོད་ཀྱི་སྔོན་དུ་ཡོད་པའི་མི་རྣམས་ཡུལ་གྱིས་སྐྱུག་བྲོ་བར་བཟོས་པ་ལྟར། ཁྱོད་རང་སྐྱུག་བྲོ་བར་མི་འགྱུར་བའི་ཕྱིར་དུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","སུ་ཡིན་ཡང་སྐྱུག་བྲོ་བའི་དོན་དེ་རྣམས་ལས་གཅིག་བྱས་ན། དེ་ནི་མི་མང་ལས་མེད་པར་གཏོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ཁྱོད་རྣམས་ཀྱིས་སྐྱུག་བྲོ་བའི་གོམས་སྲོལ་དེ་དག་ལ་བསྟུན་ནས། ཁྱོད་ཅག་སྔོན་གྱི་མི་རྣམས་ཀྱིས་ཅི་ཞིག་བྱས་པ་བཞིན་སྤྱད་དེ་རང་ཉིད་བཙོག་པར་མི་བྱ་བའི་ཆེད་དུ། བདག་གི་བསྒོ་བ་རྣམས་བསྲུང་དགོས་ཏེ། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་སྨྲ་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་ལ་འདི་ལྟར་ཤོད་དང་། ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་བདག་ནི་དམ་པ་ཡིན་པའི་ཕྱིར། ཁྱོད་རྣམས་ཀྱང་དམ་པ་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ཁྱོད་ཅག་མི་རེ་རེས་རང་རང་གི་ཕ་མ་ལ་བསྙེན་བཀུར་བྱེད་དགོས་པ་དང་། བདག་གི་ངལ་གསོ་བའི་ཉིན་མོའང་བསྲུང་དགོས་ལ། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ལྷ་སྐུ་རྣམས་ཀྱི་ཕྱོགས་སུ་འཁོར་མི་རུང་ལ། རང་ཉིད་ཀྱི་ཕྱིར་དུ་ལྷ་སྐུ་རྣམས་ལྡུག་ཀྱང་མི་རུང་སྟེ། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","དེ་ཡང་ཁྱོད་རྣམས་ཀྱིས་དམར་མཆོད་བཤས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞི་བདེའི་མཆོད་པ་འབུལ་བའི་ཚེ། ཁྱོད་རྣམས་ཁོང་གི་ཐུགས་ལ་ལྡན་པ་ཞིག་ཡིན་པའི་ཕྱིར་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","མཆོད་རྫས་དེ་ནི་མཆོད་པར་ཕུལ་བའི་ཉིན་དེ་རང་དང་དེའི་ཕྱི་ཉིན་བཟའ་དགོས་ལ། ཉིན་གསུམ་པའི་བར་དུ་ལུས་པ་རྣམས་མེ་ཡིས་བསྲེག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","གལ་སྲིད་ཉིན་གསུམ་པར་ཟོས་ན་དེ་ནི་མི་གཙང་དྲི་མས་གོས་པ་ཡིན་པས་ཁོང་གི་ཐུགས་ལ་མི་ལྡན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","སུ་ཞིག་གིས་དེ་ཟོས་ན་དེས་རང་གི་ནག་ཉེས་འཁུར་དགོས་ཏེ། ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་རྫས་དམ་པ་བསླད་པའི་རྐྱེན་གྱིས་ཁོ་ནི་མི་མང་ལས་མེད་པར་གཏོང་ངེས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ཁྱོད་རྣམས་ཀྱིས་རང་གི་ས་ཞིང་ནས་སྟོན་ཐོག་བསྡུ་བའི་ཚེ། ས་ཞིང་གྲུ་ཟུར་གྱི་ལོ་ཏོག་བསྡུ་མི་འོས་ལ། སར་ལྷུང་བའི་སྙེ་མ་རྣམས་ཀྱང་བཏུ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","རྒུན་འབྲུམ་ར་བ་ལས་རྒུན་འབྲུམ་ཡོད་ཚད་བཏོག་མི་རུང་ལ། རྒུན་འབྲུམ་ར་བར་ས་ལ་ལྷུང་བའི་རྒུན་འབྲུམ་རྣམས་ཀྱང་བཏུ་མི་འོས་ཏེ། དེ་ནི་དབུལ་པོ་དང་བྱེས་པ་རྣམས་ཀྱི་ཕྱིར་དུ་བསྐྱུར་དགོས། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","ཁྱོད་རྣམས་ཀྱིས་རྐུ་བྱེད་མི་རུང་བ་དང་། མགོ་སྐོར་གཏོང་མི་རུང་ལ། ཕན་ཚུན་ལ་རྫུན་ཡང་སྨྲ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","བདག་གི་མཚན་དཔང་དུ་བཙུགས་ནས་མནའ་རྫུན་མ་བསྐྱལ་ཏེ་ཁྱོད་ཀྱི་དཀོན་མཆོག་གི་མཚན་ཁྱད་དུ་གསོད་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ཁྱོད་ཀྱི་ཁྱིམ་མཚེས་ལ་བཙན་གནོན་བྱེད་མི་རུང་ལ། འཕྲོག་བཅོམ་ཡང་བྱེད་མི་རུང་། གླ་པའི་གླ་ཆ་ནི་ཞོགས་པའི་བར་དུ་ཁྱོད་ཀྱི་ལག་ནས་ལུས་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","འོན་པ་ལ་དམོད་མོ་འདེབས་མི་རུང་ལ། ལོང་བའི་མདུན་དུ་བཀག་རྡོ་འཇོག་མི་འོས། ཁྱོད་ནི་རང་གི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་དགོས་ཏེ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ཁྲིམས་ལ་གཏུག་སྐབས་དྲང་གཞག་ཡིན་དགོས་ཤིང་། དབུལ་པོར་ཕྱོགས་ལྷུང་བྱེད་མི་རུང་ལ། དབང་ཤུགས་ཅན་གྱི་ཁ་ངོར་ཡང་བལྟ་མི་རུང་སྟེ། ཅི་ནས་ཀྱང་འདྲ་མཉམ་གྱིས་ཁྱོད་ཀྱི་ཁྱིམ་མཚེས་ལ་དྲང་བདེན་བསྐྱང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","མི་མང་གི་ཁྲོད་དུ་གང་སར་དབྱེན་སྦྱོར་རྩོད་སློང་བྱེད་མི་རུང་ལ། ཁྱིམ་མཚེས་ཀྱི་ཚེ་སྲོག་ལ་གནོད་འཚེ་གཏོང་མི་རུང་སྟེ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","ཁྱོད་ཀྱི་སེམས་སུ་རང་གི་སྤུན་ཟླར་སྡང་མི་རུང་། ཁྱོད་ཀྱིས་རང་གི་ཁྱིམ་མཚེས་ཀྱི་རྐྱེན་གྱིས་སྡིག་པ་མི་འབྱུང་བའི་ཕྱིར་དེའི་སྐྱོན་སྟོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","འཁོན་ལན་སློག་མི་རུང་ལ། ཁྱོད་རང་གི་མི་རྣམས་ལ་འཁང་ར་ཡང་བྱེད་མི་རུང་ཞིང་། ཁྱོད་ཀྱིས་ཁྱིམ་མཚེས་ལའང་རང་དང་འདྲ་བར་གཅེས་ཤིག བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","ཁྱོད་ཅག་གིས་བདག་གི་སྒྲིག་ཁྲིམས་བརྩི་སྲུང་བྱེད་དགོས་ཏེ། ཁྱོད་ཀྱི་ཕྱུགས་ཟོག་རྣམས་རིགས་མི་གཅིག་པ་དང་འཁྲིག་ཏུ་འཇུག་མི་རུང་བ་དང་། ཞིང་ལ་རིགས་མི་མཚུངས་པའི་ས་བོན་གཉིས་འདེབས་མི་རུང་ལ། རྒྱུ་གཉིས་ལས་གྲུབ་པའི་གྱོན་པ་ཡང་གོན་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","གལ་སྲིད་སྐྱེས་པ་ཞིག་བུད་མེད་ཅིག་ལ་འགྲོགས་ནས་འཁྲིག་པ་སྤྱད་ཅིང་། ཁོ་མོ་ནི་བྲན་མོ་ཡིན་ཞིང་སྐྱེས་པ་གཞན་ལ་གཉེན་རྟགས་བརྒྱབ་ཡོད་པ་དང་། ད་དུང་བླུས་མེད་པའམ་རང་དབང་ཐོབ་མེད་པ་ཡིན་ན། ཉེས་ཆད་གཅོད་འོས་པ་ལས་དེ་གཉིས་གསོད་པར་མི་རིགས། ཅི་ལ་ཞེ་ན། བྲན་མོར་ད་དུང་རང་དབང་ཐོབ་མེད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","སྐྱེས་པ་དེས་ཉེས་སེལ་མཆོད་པ་སྟེ་ལུག་ཐུག་ཅིག་དཀོན་མཆོག་ཡ་ཝཱེའི་མདུན་དྲུང་དུ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་འཁྲིད་འོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","དེ་ནས་མཆོད་དཔོན་གྱིས་ཉེས་སེལ་མཆོད་པར་ཕུལ་བའི་ལུག་ཐུག་དེས། མི་དེས་བྱས་པའི་སྡིག་པའི་ཆེད་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་སྡིག་པ་བཤག་དགོས་པ་དང་། དེས་བྱས་པའི་སྡིག་པ་སེལ་བར་ངེས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","ཁྱོད་རྣམས་ཀཱ་ན་ཨན་ཡུལ་དུ་སླེབས་ཚེ། སིལ་སྡོང་སྣ་ཚོགས་བཙུགས་ནས་དེ་དག་གི་ཤིང་ཏོག་རྣམས་ཟས་སུ་སྤྱོད་མི་རུང་། ལོ་གསུམ་གྱི་ནང་དུ་ཁྱོད་ཅག་གིས་དེ་བཀོལ་མི་རུང་ལ་བཟའ་ཡང་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","འོན་ཀྱང་ལོ་བཞི་པར་ཐོགས་པའི་ཤིང་ཏོག་ནི་ཐམས་ཅད་དམ་པ་ཡིན་ལ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བསྟོད་པ་འབུལ་བའི་མཆོད་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ལོ་ལྔ་པར་ཁྱོད་ཅག་གི་ཆེད་དུ་སིལ་སྡོང་ལ་ཤིང་ཏོག་མང་པོ་ཐོགས་སུ་བཅུག་ནས། ཁྱོད་རྣམས་ཀྱིས་སྡོང་མགོའི་སིལ་ཏོག་རྣམས་བཟའ་དགོས། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ཁྱོད་ཚོས་ཁྲག་ཡོད་པའི་ཁ་ཟས་ཅི་ཡང་བཟའ་མི་རུང་ཞིང་། ཁྱོད་ཚོས་མོ་འདེབས་མི་རུང་ལ། སྐར་ལྟས་ལའང་བལྟ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ཁྱོད་ཀྱི་སྐྲ་འདབས་བཞར་མི་རུང་བ་དང་། ཨག་ཚོམ་གྱི་མཐའ་ནས་ཀྱང་གཅོད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","གཤིན་པོའི་ཕྱིར་དུ་རང་གི་ཤ་གཅོད་མི་རུང་ལ། ལུས་སྟེང་དུ་རི་མོ་གཙགས་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ཁྱོད་ཀྱི་བུ་མོ་སྨད་འཚོང་མ་རུ་བྱས་ནས་སྐྱོན་གྱིས་གོས་པར་བྱེད་མི་རུང་། དེ་ལྟར་བྱས་ན་ཡུལ་འདིས་གཡེམ་སྦྱོར་སྤེལ་ནས་གནས་འདིར་ངན་པས་འགེང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་ངལ་གསོ་བའི་ཉིན་མོ་རྣམས་བསྲུང་བ་དང་། བདག་གི་གནས་མཆོག་ལ་གུས་ཤིང་འཇིགས་དགོས། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ལྷ་པ་རྣམས་ཀྱི་ཕྱོགས་སུ་འཁོར་མི་རུང་ལ། མོ་པ་རྣམས་ལ་ཞུ་ཡང་མི་རུང་སྟེ། ཁྱོད་རང་དེ་དག་གིས་བཙོག་པར་མི་བྱེད་པའི་ཕྱིར་ཡིན། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","མགོ་སྐྲ་དཀར་པོར་གྱུར་པའི་མདུན་ནས་ཡར་ལངས་པ་དང་། བགྲེས་པོ་ཚོར་གུས་བཀུར་བྱེད་དགོས། ཁྱོད་ཀྱི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པར་གྱིས། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","གལ་སྲིད་ཕྱི་རོལ་གྱི་མི་ཞིག་ཁྱོད་ཅག་གི་ཡུལ་ནས་ཁྱོད་དང་མཉམ་དུ་གནས་བཅས་ན་དེ་ལ་ཐུབ་ཚོད་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ཁྱོད་ཅག་གི་ཡུལ་ནས་བྱེས་སུ་སྡོད་པའི་ཕྱི་མི་ལ། ཁྱོད་རྣམས་ཀྱིས་གཞིས་སྐྱེས་པའི་ལྟ་སྟངས་འཛིན་པར་མ་ཟད། རང་ཉིད་ལ་གཅེས་པ་བཞིན་དེ་ཡང་གཅེས་སུ་འཛིན་དགོས། ཅི་ལ་ཞེ་ན། ཁྱོད་རྣམས་ཀྱང་ཨེ་ཅིབ་ཡུལ་དུ་བྱེས་སུ་བསྡད་མྱོང་བས་སོ། །བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ཁྱོད་རྣམས་ཀྱིས་ཁྲིམས་ཐག་གཅོད་པའི་སྐབས་སུ། རིང་ཐུང་ཚད་པ་དང་ལྕི་ཡང་འཇལ་བ། ཤོང་ཚད་འཇལ་བ་བཅས་ལ་གཡོ་སྒྱུ་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ཁྱོད་རྣམས་ཀྱིས་དྲང་གཞག་གི་རྒྱ་སྲང་དང་དྲང་གཞག་གི་རྒྱ་རྡོ་དང་། དྲང་གཞག་གི་ཨེ་ཕཱ་དང་། དྲང་གཞག་གི་རྫ་བུམ་བཅས་བཀོལ་དགོས། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ལ། སྔར་ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རུ་ཁྲིད་འོངས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་ཐམས་ཅད་བརྩི་སྲུང་བྱས་ནས་དེ་བཞིན་དུ་སྒྲུབས་ཤིག བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ་ཞེས་སྨྲ་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར། ཡེས་ར་ཨེལ་པ་དང་ཡེས་ར་ཨེལ་གྱི་ཁྲོད་དུ་བྱེས་སུ་སྡོད་པའི་ཕྱི་མི་སུ་ཡིན་ཡང་། རང་གི་བུ་རྒྱུད་མོ་ལེག་ལ་མཆོད་པར་བྱེད་ན་དེ་ནི་གསོད་དགོས། ཡུལ་མི་རྣམས་ཀྱིས་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","མི་དེ་ལ་བདག་གི་གདོང་མདོག་ཀྱང་ལོག་སྟེ་ཁོ་རང་མི་མང་ཁྲོད་ནས་མེད་པར་གཏོང་བར་བྱ། གང་ལ་ཞེ་ན། ཁོས་རང་གི་བུ་རྒྱུད་མོ་ལེག་ལ་ཕུལ་ནས། བདག་གི་གནས་མཆོག་སྦགས་པ་དང་བདག་གི་མཚན་དམ་པ་ཁྱད་དུ་བསད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","གལ་སྲིད་མི་དེས་བུ་བུ་མོ་རྣམས་མོ་ལེག་ལ་ཕུལ་བ་དང་། ཡུལ་མི་རྣམས་ཀྱིས་དེ་མ་མཐོང་ཁུལ་བྱས་ཏེ་མི་དེ་མི་གསོད་ན། ");
INSERT INTO bodn_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","མི་དེ་དང་དེའི་ཁྱིམ་མི་ལ་བདག་གི་གདོང་མདོག་ལོག་ཅིང་། མི་དེ་དང་དེའི་རྗེས་སུ་འབྲངས་ནས་མོ་ལེག་དང་ལོག་གཡེམ་བྱེད་པ་ཐམས་ཅད་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","མི་སུ་ཞིག་མོ་པ་དང་ལྷ་པ་རྣམས་ཀྱི་ཕྱོགས་སུ་འཁོར་བ་དང་། དེ་དག་གི་རྗེས་སུ་འབྲངས་ནས་ལོག་གཡེམ་བྱེད་པ་ཡིན་ན། མི་དེ་ལ་བདག་གི་གདོང་མདོག་ལོག་ཅིང་ཁོ་རང་མི་མང་ལས་མེད་པར་གཏོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ཁྱོད་ཅག་གིས་རང་ཉིད་དམ་པར་བྱོས་ལ་དམ་པར་སྒྱུར་ཅིག ཅི་ལ་ཞེ་ན། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ཁྱོད་ཅག་གིས་བདག་གི་སྒྲིག་ཁྲིམས་བརྩི་སྲུང་བྱས་ནས་དེ་བཞིན་དུ་བྱོས་ཤིག བདག་ནི་ཁྱོད་ཅག་དམ་པར་བཟོ་བའི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","གལ་ཏེ་རང་གི་ཕ་མ་ལ་དམོད་མོ་འདེབས་མཁན་ཡོད་ན་དེ་གསོད་དགོས། སུས་ཕ་མ་ལ་དམོད་མོ་གཏོང་ན། དེའི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","གཞན་གྱི་ཆུང་མ་སྟེ་རང་གི་ཁྱིམ་མཚེས་གྱི་ཆུང་མ་དང་ལོག་གཡེམ་བྱེད་མཁན་སུ་ཡིན་ཡང་། འཆལ་པོ་འཆལ་མོ་གཉིས་ཀ་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","སུ་ཞིག་རང་གི་ཕ་ཡི་ཆུང་མ་དང་ལུས་འབྲེལ་བྱེད་པ་སྟེ། རང་གི་ཕ་ཡི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པ་ཡིན་ན། དེ་གཉིས་ཀ་གསོད་དགོས་ལ། དེ་གཉིས་ཀའི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","སུ་ཞིག་རང་གི་མནའ་མ་དང་ལུས་འབྲེལ་བྱེད་ན་དེ་གཉིས་ཀ་གསོད་དགོས། དེ་དག་གིས་གཉེན་ཚན་བར་འཁྲིག་པ་སྤྱད་པ་ཡིན་པས། ཁོ་ཚོའི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","སྐྱེས་པ་ཞིག་བུད་མེད་ལ་ལུས་འབྲེལ་བྱེད་པའི་ཚུལ་བཞིན་དུ་ཕོ་དང་ལུས་འབྲེལ་བྱས་ན། དེ་གཉིས་ཀྱིས་སྐྱུག་བྲོ་བའི་ལས་བྱས་པ་ཡིན་པས་གསོད་དགོས། དེ་དག་གི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","སྐྱེས་པ་ཞིག་གིས་ཆུང་མ་བླངས་པ་དང་། ཆུང་མའི་མ་ཡང་བླངས་ན་དེ་ནི་ལོག་སྤྱོད་ཡིན་པས། མི་དེ་གསུམ་པོ་མེ་ཡིས་བསྲེགས་ནས། ཁྱོད་ཚོའི་ཁྲོད་ནས་ལོག་སྤྱོད་མེད་པར་བཟོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","སུ་ཞིག་གིས་ཕྱུགས་ཟོག་རིགས་དང་འཁྲིག་པ་སྤྱད་ན་མི་དེ་གསོད་དགོས་ལ། ཕྱུགས་ཟོག་དེ་ཡང་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","བུད་མེད་ཅིག་ཕྱུགས་ཟོག་རིགས་ཀྱི་ཉེ་སར་བཅར་ནས་དེ་དང་འཁྲིག་པ་སྤྱད་ན། ཁྱོད་ཀྱིས་བུད་མེད་དང་ཕྱུགས་ཟོག་གཉིས་ཀ་གསོད་དགོས། དེ་དག་ངེས་པར་གསོད་དགོས་ལ། དེ་དག་གི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","སུ་ཞིག་གིས་རང་གི་ལྕམ་སྲིང་སྟེ། ཕ་ཡི་བུ་མོའམ་ཡང་ན་མ་ཡི་བུ་མོ་ཆུང་མར་བླངས་ཏེ། ཕན་ཚུན་གྱི་ཁོག་སྨད་མཐོང་བ་ཡིན་ན་དེ་ནི་ངོ་ཚ་དགོས་པའི་དོན་ཡིན་པས། དེ་གཉིས་ཀ་རང་གི་མི་རྣམས་ཀྱི་མཐོང་ངོར་རྩ་མེད་དུ་གཏོང་དགོས། དེས་རང་གི་ལྕམ་སྲིང་གི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པ་ཡིན་པས་ཉེས་པ་འཁུར་དགོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","གལ་ཏེ་སུ་ཞིག་ཟླ་མཚན་འབབ་དུས་ཀྱི་བུད་མེད་དང་ལུས་འབྲེལ་བྱས་ནས། ཁོ་མོའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པ་དང་། ཁོ་མོའི་ཁྲག་ཁུངས་དམར་རྗེན་དུ་བཏོན་ཏེ། ཁོ་མོས་ཀྱང་རང་གི་ཁྲག་ཁུངས་མངོན་པ་ཡིན་ན། དེ་གཉིས་ཀ་རང་གི་མི་མང་ལས་མེད་པར་གཏོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","མ་ཡི་ལྕམ་སྲིང་དང་ཕ་ཡི་ལྕམ་སྲིང་གི་ཁོག་སྨད་གཅེར་བུར་འཕུད་མི་རུང་། དེ་ནི་རང་གི་གཉེན་ཉེ་གཅེར་བུར་འཕུད་པ་ཡིན་པས། ཁོ་ཚོས་རང་གི་ནག་ཉེས་འཁུར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","གལ་ཏེ་སུ་ཞིག་ཁུ་བོའི་ཆུང་མ་དང་ལུས་འབྲེལ་བྱས་ན། དེ་ནི་རང་གི་ཁུ་བོའི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པ་ཡིན་པས། དེ་ཚོས་རང་གི་སྡིག་པ་འཁུར་དགོས་ལ་བུ་ཕྲུག་མེད་པར་འཆི་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ཡང་སུ་ཞིག་གིས་རང་གི་སྤུན་གྱི་ཆུང་མ་བླངས་ན་དེ་ནི་སྤུན་གྱི་ཁོག་སྨད་གཅེར་བུར་འཕུད་པ་ཡིན་ལ། དེ་ནི་འཆལ་སྤྱོད་ཡིན་པས་ཁོ་ཚོར་བུ་ཕྲུག་མེད་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","ཁྱོད་ཚོས་བདག་གི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་ཐམས་ཅད་སྲུང་བརྩི་བྱས་ནས་དེ་བཞིན་བྱོས་ཤིག དེ་ནས་བདག་གིས་ཁྱོད་རྣམས་ཁྲིད་དེ་གནས་པར་འགྱུར་བའི་ཡུལ་དེས་ཁྱོད་ཅག་སྐྱུག་པར་མི་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ཁྱོད་རྣམས་ནི་བདག་གིས་ཁྱོད་ཅག་གི་མདུན་ནས་བསྐྲད་པའི་མི་རྣམས་ཀྱི་ལུགས་སྲོལ་གྱི་རྗེས་སུ་འབྲང་མི་རུང་སྟེ། ཅི་ལ་ཞེ་ན། དེ་དག་གིས་དོན་མི་ལེགས་པ་དེ་ཐམས་ཅད་བྱས་པས་བདག་ནི་དེ་དག་ལ་ཞེན་པ་གཏིང་ནས་ལོག་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","འོན་ཀྱང་བདག་གིས་ཁྱོད་ཚོ་ལ། དེ་དག་གི་ཡུལ་ནི་ཁྱོད་རྣམས་ཀྱིས་རྒྱུན་འཛིན་བྱེད་པ་དང་། བདག་གིས་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་དེ་ཁྱོད་ཅག་ལ་བགོ་སྐལ་དུ་སྟེར་བར་བྱ་ཞེས་སྨྲས་ཡོད། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་སྟེ། ཁྱོད་རྣམས་མི་ཐམས་ཅད་ལས་སོ་སོར་འགེར་མཁན་དེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ཁྱོད་རྣམས་ཀྱིས་འདབ་ཆགས་དང་སེམས་ཅན་དུད་འགྲོ་གཙང་མི་གཙང་གི་དབྱེ་བ་འབྱེད་དགོས་པ་དང་། བདག་གིས་མི་གཙང་བར་སོ་སོར་ཕྱེས་པའི་འདབ་ཆགས་དང་སེམས་ཅན་དུད་འགྲོའམ། ཡང་ན་ས་སྟེང་གི་ལྟོ་འགྲོ་སྲོག་ཆགས་གང་དང་གང་གི་རྐྱེན་གྱིས་རང་ཉིད་སྐྱུག་བྲོ་བར་བཟོ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ཡ་ཝཱེ་ང་རང་ནི་དམ་པ་ཡིན་པའི་ཕྱིར། ཁྱོད་ཀྱང་བདག་གི་ཆེད་དུ་དམ་པ་ཡིན་དགོས། བདག་གིས་ཁྱོད་ཅག་བདག་གི་ཡིན་པའི་རྐྱེན་གྱིས་མི་ཐམས་ཅད་ལས་སོ་སོར་བཀར་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ཡང་མོ་པ་དང་ལྷ་པ་ནི་སྐྱེས་ཕོ་མོ་སུ་ཡིན་ཡང་གསོད་དགོས་ལ། མི་ཡིས་རྡོ་རུབ་བཏང་སྟེ་གསོད་དགོས་པ་དང་། དེ་དག་གི་སྟེང་ནས་ཁྲག་ལན་འཇལ་དགོས་ཞེས་སྨྲོས་ཤིག་ཅེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཨ་རོན་གྱི་བུ་རྒྱུད་ལས་མཆོད་དཔོན་ཡིན་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག མཆོད་དཔོན་གྱིས་རང་གི་མི་མང་ཁྲོད་ཀྱི་འདས་པོའི་ཕྱིར་དུ་རང་ཉིད་སྦག་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","དེ་ཡང་རང་གི་རྩ་བའི་གཉེན་ཉེ་སྟེ། ཁོའི་ཕ་མ་དང་། བུ་བུ་མོ་དང་། སྤུན་མཆེད་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ཡང་ན་ད་དུང་གནས་ལ་མ་སོང་བའི་ན་ཆུང་བུ་མོ་སྟེ་ལྕམ་སྲིང་ཡིན་པ་བཅས་ནི་འཕུད་དགོས། དེ་ནི་ཁོའི་ལྕམ་སྲིང་ཡིན་པའི་རྐྱེན་གྱིས་རང་ཉིད་མི་གཙང་བར་བྱས་ཆོག ");
INSERT INTO bodn_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","མཆོད་དཔོན་ནི་རང་གི་མི་མང་ཁྲོད་ཀྱི་འགོ་དཔོན་ཡིན་པས། རང་ཉིད་སྦགས་ནས་མི་གཙང་བར་བྱེད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","མགོ་སྤྱི་ཐེར་དུ་གཏོང་བ་དང་ཨག་ཚོམ་གྱི་སྣེ་མོ་གཅོད་མི་རུང་ལ། རང་ལུས་ཀྱི་ཤ་སྐྱི་གང་ཡང་གཅོད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ཁོ་རྣམས་ནི་དཀོན་མཆོག་གི་ཆེད་དུ་དམ་པ་ཡིན་དགོས་ལ། རང་གི་དཀོན་མཆོག་གི་མཚན་ཁྱད་དུ་གསོད་མི་རུང་། དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་མཆོད་དེ་དཀོན་མཆོག་གི་ཞལ་ཟས་ནི་ཁོ་རྣམས་ཀྱིས་འདྲེན་པ་ཡིན་པས། ཁོ་ཚོ་ནི་དམ་པ་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","མཆོད་དཔོན་གྱིས་སྨད་འཚོང་མ་དང་ཡང་ན་གཞན་གྱིས་སྦགས་པའི་བུད་མེད་ནི་ཆུང་མར་ལེན་མི་རུང་ལ། ཁྱོ་གས་ཕྱི་ལ་སྤྱུགས་པའི་བུད་མེད་ཀྱང་ཆུང་མར་ལེན་མི་རུང་། ཅི་ལ་ཞེ་ན། ཁོ་ནི་རང་གི་དཀོན་མཆོག་གི་ཆེད་དུ་དམ་པ་ཡིན་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","མཆོད་དཔོན་གྱིས་ཁྱོད་ཀྱི་དཀོན་མཆོག་ལ་ཞལ་ཟས་འདྲེན་པས་ཁྱོད་ཀྱིས་ཁོ་ནི་དམ་པར་བཟོ་དགོས། ཁྱོད་ཀྱིས་མཆོད་དཔོན་དམ་པར་བརྩི་དགོས་ཏེ། ཅིའི་ཕྱིར་ཞེ་ན། བདག་ནི་ཁྱོད་རྣམས་དམ་པར་བཟོ་བའི་དཀོན་མཆོག་ཡ་ཝཱེ་དང་དམ་པ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","མཆོད་དཔོན་གྱི་བུ་མོ་སྨད་འཚོང་མ་བྱས་ནས་རང་ཉིད་སྦགས་ན། རང་གི་ཕ་བཙོག་པར་བཟོས་པ་ཡིན་པས་ཁོ་མོ་མེས་བསྲེག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","སྤུན་ཟླ་ཚོའི་ཁྲོད་ནས་མཆོད་དཔོན་ཆེན་པོ་བྱེད་པ་སྟེ། མགོ་ལ་འབྱུག་སྣུམ་བླུགས་པ་དང་། ལས་འགན་དམ་པ་རྒྱུན་འཛིན་བྱས་ཤིང་འཕགས་གོས་མནབས་པ་དེས། མགོ་ཟིང་ནས་སྐྲ་བཤིག་པར་མི་བྱེད་པ་དང་གོས་ཀྱང་གཤག་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","བེམ་པོ་གང་ཡིན་ཡང་དེའི་ཉེ་སར་བཅར་མི་རུང་སྟེ། རང་གི་ཕ་མའི་ཆེད་དུ་ཡང་རང་ཉིད་སྦག་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","དཀོན་མཆོག་གི་གནས་མཆོག་འབག་པར་མི་བྱེད་པའི་ཕྱིར་དུ། མཆོད་དཔོན་ཆེན་པོ་གནས་མཆོག་གི་ཕྱི་རུ་འགྲོ་མི་རུང་སྟེ། ཁོའི་ལུས་སྟེང་དུ་དཀོན་མཆོག་གི་འབྱུག་སྣུམ་དམ་པ་ཡོད་པའི་རྐྱེན་གྱིས། དཀོན་མཆོག་གི་གནས་མཆོག་འབག་པར་མི་བྱེད་དེ། གནས་མཆོག་གི་ཕྱི་རུ་འགྲོ་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ཁོས་ན་ཆུང་བུ་མོ་ཆུང་མར་ལེན་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","མཆོད་དཔོན་ཆེན་པོས་ཡུགས་མོ་དང་ཁྱོ་གས་ཕྱི་ལ་སྤྱུགས་པའི་བུད་མེད་དང་། ཡང་ན་གཞན་གྱིས་སྦགས་པའི་སྨད་འཚོང་མ་བཅས་ནི་ཆུང་མར་ལེན་མི་རུང་། ཁོས་རང་གི་མི་མང་ཁྲོད་ཀྱི་ན་ཆུང་བུ་མོ་འབའ་ཞིག་ཆུང་མར་ལེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ཁོས་རང་གི་མི་རིགས་ཀྱི་ཁྲོད་དུ་རང་གི་བུ་རྒྱུད་བཙོག་པར་བཟོ་མི་རུང་། ཅི་ལ་ཞེ་ན། བདག་ནི་ཁོ་རང་དམ་པར་བཟོ་མཁན་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","ཁྱོད་ཀྱིས་ཨ་རོན་ལ་འདི་ལྟར་སྒོས་ཤིག ཁྱོད་ཀྱི་རིགས་རྒྱུད་ལས་མི་རབས་ནས་མི་རབས་བར། དབང་བོ་སྐྱོན་ཅན་སུ་ཡིན་ཡང་ཚུར་འོངས་ནས་སོ་སོའི་དཀོན་མཆོག་ལ་ཞལ་ཟས་འདྲེན་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ཅི་ལ་ཞེ་ན། དབང་བོ་སྐྱོན་དང་ལྡན་པ་ནི། ལོང་བའམ། ཞ་བོའམ། ཁ་ངོ་སྐྱོན་ཅན་ནམ། ཡན་ལག་གཅིག་རིང་དྲགས་པའམ། ");
INSERT INTO bodn_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","རྐང་པའམ་ལག་པར་ཆག་གྲུམ་ཤོར་བའམ། ");
INSERT INTO bodn_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","སྒུར་པོ་དང་། མིའུ་ཐུང་དང་། མིག་མཛེར་ཅན་དང་། རྔོའམ་རྨ་སྐོགས་ཅན་དང་། རླིག་འབྲས་བསྣད་པ་བཅས་ནི་ཚུར་འོང་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","མཆོད་དཔོན་ཨ་རོན་གྱི་རིགས་རྒྱུད་ལས་དབང་བོ་སྐྱོན་ཅན་སུ་ཡིན་ཡང་། ཚུར་འོངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་མཆོད་འབུལ་མི་རུང་། དེའི་དབང་བོར་སྐྱོན་ཡོད་པས་ཚུར་འོངས་ནས་དཀོན་མཆོག་ལ་ཞལ་ཟས་འདྲེན་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","རང་གི་དཀོན་མཆོག་གི་ཞལ་ཟས་ནི་ཀུན་ལས་དམ་པའམ་དམ་པ་གང་ཡིན་ཡང་ཁོས་དེ་ཟོས་ཆོག་མོད། ");
INSERT INTO bodn_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","འོན་ཀྱང་། ཁོ་རང་ཡོལ་བའི་མདུན་དུ་འོང་མི་རུང་ལ། མཆོད་ཁྲིའི་ཉེ་སར་ཡང་བཅར་མི་རུང་སྟེ། ཁོའི་དབང་བོར་སྐྱོན་ཡོད་པ་དང་བདག་གི་གནས་མཆོག་མི་སྦག་པའི་ཕྱིར་རོ། །བདག་ནི་དེ་རྣམས་དམ་པར་བཟོ་བའི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ་ཞེས་པའོ་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","དེ་བས་མོ་ཤེ་ཡིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་དང་། ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་བཀའ་བསྒོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ཁྱོད་ཀྱིས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་འདི་ལྟར་བསྒོ་བར་གྱིས། ཁྱོད་ཅག་གིས་བདག་གི་མཚན་དམ་པ་ཁྱད་དུ་མི་གསོད་པའི་ཕྱིར། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་བདག་གི་ཆེད་དུ་དམ་པར་བསྔོས་པའི་རྫས་རྣམས་གཟབ་གཟབ་བྱས་ནས་བསྲུང་དགོས་ལ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ་ཞེས་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ཡང་དེ་དག་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཁྱོད་ཀྱི་རིགས་རྒྱུད་ཀྱི་མི་རབས་ཀུན་ལས་སུ་ཡིན་ཡང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཆེད་དུ་དམ་པར་བསྔོས་པའི་རྫས་དང་ཉེ་བར་གཅར་མཁན་དེ་མི་གཙང་བ་ཡིན་ན། མི་དེ་ནི་ངའི་སྤྱན་སྔ་ནས་མེད་པར་གཏོང་ངེས་ཡིན། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ཨ་རོན་གྱི་བུ་རྒྱུད་ལས་མཛེ་ནད་ཅན་དང་། ཡང་ན་འཛིར་ནད་ཡོད་པ་སུ་ཡིན་ཡང་གཙང་མར་མ་གྱུར་བར་དུ། རྫས་དམ་པ་དག་ལས་བཟའ་མི་རུང་། སུ་ཞིག་གིས་བེམ་པོའི་རྐྱེན་གྱིས་མི་གཙང་བར་གྱུར་པའི་རྫས་དང་ཁུ་བ་ཟགས་པའི་མི་ལ་རེག་པའམ། ");
INSERT INTO bodn_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ཡང་ན་ཁོ་རང་མི་གཙང་བར་བཟོ་བའི་ལྟོ་འགྲོ་སྲོག་ཆགས་སམ་མི་གང་དང་གང་ལ་རེག་པ་ཡིན་ན། མི་དེར་མི་གཙང་བའི་ཆ་གང་ཞིག་ཡོད་ནའང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","དེ་རྣམས་ལ་རེག་པའི་མི་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་ཏེ། ལུས་པོ་ཆུས་མ་བཀྲུས་ན་རྫས་དམ་པ་ལས་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ཉི་མ་ནུབ་པའི་དུས་སུ་ཁོ་རང་གཙང་མར་འགྱུར་ཞིང་། དེའི་རྗེས་སུ་རྫས་དམ་པ་ལས་བཟའ་རུང་བ་ཡིན། ཅིའི་ཕྱིར་ཞེ་ན། དེ་ནི་ཁོའི་ཁ་ཟས་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ཡང་རང་ཉིད་མི་སྦག་པའི་ཕྱིར་ཁོས་རང་བཞིན་གྱིས་ཤི་བའམ་གཅན་གཟན་གྱིས་བསད་པའི་ཤ་ནི་བཟའ་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","བདག་གི་བཀའ་རྣམས་ཁྱད་དུ་བསད་པའི་རྐྱེན་གྱིས་རང་གི་སྡིག་པ་ཁུར་ནས་འཆི་བར་མི་འགྱུར་བའི་ཆེད་དུ་བསྲུང་དགོས། བདག་ནི་དེ་དག་དམ་པར་བྱེད་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","དེ་ཡང་ཕྱི་མི་སུ་ཡིན་ཡང་རྫས་དམ་པ་རྣམས་བཟའ་མི་རུང་སྟེ། མཆོད་དཔོན་ཚང་གི་མགྲོན་པོའམ་གླ་པ་སུ་ཡིན་ཡང་རྫས་དམ་པ་ལས་བཟའ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","གལ་སྲིད་མཆོད་དཔོན་གྱིས་རང་གི་དངུལ་སྤྲད་ནས་ཉོས་པའི་མི་ཡིན་ན་དེས་རྫས་དམ་པ་བཟའ་རུང་བ་དང་། རང་ཁྱིམ་ནས་སྐྱེས་པ་དག་གིས་ཀྱང་དེའི་ཁ་ཟས་ལས་བཟའ་རུང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","གལ་སྲིད་མཆོད་དཔོན་གྱི་བུ་མོ་ཕྱི་མི་ཞིག་ལ་གཉེན་བསྒྲིགས་ན། དེས་འདེགས་མཆོད་ཀྱི་རྫས་དམ་པ་བཟའ་མི་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ཅི་སྟེ་མཆོད་དཔོན་གྱི་བུ་མོ་ཡུགས་མོ་རུ་ལུས་པའམ་ཁྱོ་གས་བཟའ་འཐོར་བྱས་ནས། ཕྲུ་གུ་མེད་པར་གཞོན་དུས་དང་འདྲ་བར་ཕ་གཞིས་སུ་ཕྱིར་ལོག་ན། རང་གི་ཕ་ཡི་ཁ་ཟས་ལས་བཟའ་རུང་མོད། འོན་ཀྱང་ཕྱི་མི་སུ་ཡིན་ཡང་དེ་ལས་བཟའ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","གལ་སྲིད་མི་ཞིག་གིས་མ་ཤེས་པར་རྫས་དམ་པ་ལས་ཟོས་ན། དེས་རྫས་དམ་པའི་ཁར་ལྔ་ཆ་གཅིག་བསྣན་ཏེ་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་རྫས་དམ་པ་ནི་མཆོད་དཔོན་གྱིས་སྦག་མི་རུང་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","དེ་བཞིན་བྱས་ན་ཁོ་རྣམས་ཀྱིས་རྫས་དམ་པ་ཟོས་ནས་རང་གིས་རང་ལ་ནག་ཉེས་འགེལ་བར་འགྱུར། ཅི་ལ་ཞེ་ན། བདག་ནི་དེ་རྣམས་དམ་པར་བྱེད་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་དང་། ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་འདི་ལྟར་སྒོས་ཤིག ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་དང་ཡེས་ར་ཨེལ་གྱི་ཁྲོད་དུ་གནས་པའི་བྱེས་པ་རྣམས་ལས་སུ་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་གི་མཆོད་པ་འབུལ་ན། དམ་བཅས་པ་བཞིན་དུ་སྒྲུབ་པའམ་ཡིད་མོས་མཆོད་པ་གང་ཡིན་ཡང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","སྐྱོན་གང་ཡང་མེད་པའི་བ་གླང་ཞིག་གམ། ཡང་ན་ཕོ་ལུག་དང་། ཡང་ན་ར་ཕོ་ཞིག་འབུལ་དགོས་ཤིང་། དེ་ལྟར་བྱས་ན་ཁྱོད་རྣམས་ད་གཟོད་ཁོང་གི་ཐུགས་སུ་ལྡན་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","སྐྱོན་དང་ལྡན་པ་གང་ཡིན་ཡང་འབུལ་མི་རུང་སྟེ། དེ་ལྟར་བྱས་ན་ཁོང་གི་ཐུགས་སུ་མི་ལྡན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","གལ་སྲིད་སུ་ཞིག་གིས་དམ་བཅས་པ་བཞིན་དུ་བསྒྲུབ་པའི་ཆེད་དུའམ། ཡིད་མོས་མཆོད་པ་རུ་བ་ཁྱུ་དང་ར་ལུག་གི་ཁྱུ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞི་བདེའི་མཆོད་པ་འབུལ་ན། ཁོང་གི་ཐུགས་སུ་ལྡན་པའི་ཕྱིར་མཆོད་པ་དེ་ནི་ནད་མེད་པ་དང་སྐྱོན་གང་ཡང་མེད་པ་ཞིག་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ལོང་བའམ། ཞ་བོའམ། སུག་རྡུམ་མམ། ཤ་མཛེར་ཅན་དང་རྔོ་ཅན་ནམ། རྨ་ཅན་བཅས་གང་ཡིན་ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་མི་རུང་སྟེ། མཆོད་ཁྲིའི་སྟེང་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་དུ་འབུལ་བར་མི་རིགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","བ་གླང་ངམ་ལུ་གུ་གང་ཡིན་ཡང་། སུག་པ་གཅིག་རིང་དྲགས་པའམ་ཐུང་དྲགས་ན། དེ་ནི་ཡིད་མོས་མཆོད་པ་འབའ་ཞིག་ཏུ་འབུལ་རུང་བ་ཡིན་ལ། དམ་བཅས་པ་བཞིན་དུ་བསྒྲུབ་པའི་ཆེད་དུ་ཡིན་ན་དེ་ནི་ཐུགས་ལ་མི་ལྡན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ཡང་རླིག་འབྲས་བསྣད་པའམ། བརྫིས་པའམ། གཤགས་པའམ། བཅད་པ་སོགས་གང་ཡིན་ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་མི་རུང་ཞིང་། ཁྱོད་ཅག་གི་ཡུལ་དུ་དེ་ལྟ་བུ་བྱེད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ཕྱི་མིའི་ལག་ནས་ཐོབ་པའི་སྲོག་ཆགས་དེའི་རིགས་གང་དང་གང་ཡིན་ཡང་། ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་གི་ཞལ་ཟས་སུ་འབུལ་མི་རུང་། ཅི་ལ་ཞེ་ན། དེ་དག་ལ་ཡན་ལག་མི་ཚང་བ་དང་སྐྱོན་ཡོད་པས། ཁྱོད་རྣམས་ཀྱི་ཕྱིར་དེ་དག་ཐུགས་སུ་ལྡན་པར་མི་འགྱུར་བས་སོ་ཞེས་པའོ་གསུངས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","བཙས་མ་ཐག་གི་བ་ཕྲུག་དང་། ལུ་གུའམ། རེའུ་བཅས་ནི་ཉིན་བདུན་ལ་མ་དང་མཉམ་དུ་འདུག་དགོས་ལ། ཉིན་བརྒྱད་པ་ནས་བཟུང་སྟེ་མེ་མཆོད་ཀྱི་མཆོད་པ་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་རུང་བ་དང་། དེ་ནི་ཁོང་གི་ཐུགས་སུ་ལྡན་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","བ་གླང་དང་ར་ལུག་གང་ཡིན་ཡང་། དེ་དང་དེའི་ཕྲུ་གུ་གཉིས་ཉིན་གཅིག་ལ་བཤའ་མི་རུང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ཁྱོད་རྣམས་ཀྱིས་དམར་མཆོད་བཤས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏང་རག་གི་མཆོད་པ་འབུལ་བའི་ཚེ། ཁྱོད་ཅག་གིས་ཁོང་གི་ཐུགས་སུ་ལྡན་པ་ཞིག་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","དེ་ནི་ཉིན་དེ་རང་དུ་བཟའ་དགོས་པ་དང་། ཞོགས་པའི་བར་དུ་ཅི་ཡང་ལུས་སུ་འཇུག་མི་རུང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་བཀའ་རྣམས་བསྲུངས་ནས་དེ་བཞིན་དུ་བསྒྲུབ་དགོས། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","བདག་གི་མཚན་དམ་པ་ཁྱད་དུ་མ་གསོད་ཅིག བདག་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་དམ་པར་བཀུར་ཞིང་། བདག་ནི་ཁྱོད་ཅག་དམ་པར་བཟོ་མཁན་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡིན་པའི་ཆེད་དུ། ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་འོངས་པ་དང་། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག གཤམ་དུ་བཀོད་པ་ནི་བདག་གི་དུས་ཆེན་རྣམས་ཏེ། ཁྱོད་རྣམས་ཀྱིས་དམ་པའི་འདུ་འཛོམས་སུ་ཁྱབ་བསྒྲགས་བྱེད་དགོས་པའི་བདག་གི་དུས་ཆེན་རྣམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ཉིན་དྲུག་གི་རིང་ལ་ལས་ཀ་བྱེད་ཅིང་ཉིན་བདུན་པ་ནི་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་ལ། འདུ་འཛོམས་དམ་པ་ཡོད་དགོས་ཏེ་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། དེ་ནི་ཁྱོད་རྣམས་ཀྱི་སྡོད་གནས་ཐམས་ཅད་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་བསྲུང་དགོས་པའི་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","གཤམ་དུ་བཀོད་པ་ནི་ཁྱོད་ཅག་གིས་དུས་ལྟར་འདུ་འཛོམས་དམ་པ་རུ་བསྒྲག་དགོས་པའི་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་རྣམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ཟླ་བ་དང་པོའི་ཚེས་བཅུ་བཞི་ཡི་ས་སྲོས་ཀྱི་དུས་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་པེ་སག་གི་དུས་ཆེན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ཟླ་བ་དེའི་ཚེས་བཅོ་ལྔ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་སྲུང་བའི་སྐྱུར་མེད་བག་ལེབ་ཀྱི་དུས་ཆེན་ཡིན་ཏེ། ཁྱོད་ཅག་གིས་ཉིན་བདུན་གྱི་རིང་ལ་སྐྱུར་མེད་བག་ལེབ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ཉིན་དང་པོར་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས་ཤིང་རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཉིན་བདུན་གྱི་རིང་མེ་མཆོད་འབུལ་དགོས། ཉིན་བདུན་པར་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས་ལ། རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ཁྱོད་རྣམས་བདག་གིས་ཁྱོད་ཅག་ལ་གནང་བའི་ཡུལ་དུ་སླེབས་ནས་ལོ་ཏོག་བསྡུ་བའི་ཚེ། ཐོག་ཕུད་ལོ་ཏོག་གི་ཚར་ཕོན་གཅིག་ཁྱེར་འོངས་ཏེ་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ཁྱོད་རྣམས་ཁོང་གི་ཐུགས་སུ་ལྡན་པའི་ཕྱིར་དུ། མཆོད་དཔོན་གྱིས་ཚར་ཕོན་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱེད་ཅིང་། ངལ་གསོ་ཉིན་མོའི་ཕྱི་ཉིན་མཆོད་དཔོན་གྱིས་དེ་གཡོ་བར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ཚར་ཕོན་གཡོ་བའི་ཉིན་མོར་ཁྱོད་རྣམས་ཀྱིས་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་སྐྱོན་མེད་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","དེ་དང་མཉམ་དུ་འབུལ་བའི་འབྲུ་མཆོད་ནི་སྣུམ་བསྲེས་གྲོ་ཞིབ་ཨེ་ཕཱ་ཡི་བཅུ་ཆ་གཉིས་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་དྲི་ཞིམ་མེ་མཆོད་ཡིན་པ་དང་། དེ་དང་མཉམ་དུ་འབུལ་བའི་སྐྱེམས་མཆོད་ནི་རྒུན་ཆང་རྫ་བུམ་གྱི་བཞི་ཆ་གཅིག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","བག་ལེབ་དང་འབྲུ་རྔོས་མའམ། སྙེ་མ་གསར་པ་བཅས་གང་ཡིན་ཡང་། ཁྱོད་རྣམས་ཀྱིས་མཆོད་པ་འདི་རྣམས་ཁྱེར་འོངས་ནས་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ལ་འབུལ་བའི་ཉིན་མོའི་བར་དུ་བཟའ་མི་རུང་སྟེ། ཁྱོད་རྣམས་ཀྱི་སྡོད་གནས་ཐམས་ཅད་དུ། འདི་ནི་ཁྱོད་ཅག་གི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","དེ་ཡང་ཁྱོད་རྣམས་ཀྱིས་རང་ཉིད་ཀྱི་ཕྱིར་ངལ་གསོ་ཉིན་མོའི་ཕྱི་ཉིན་ཏེ། འབྲུ་རིགས་ཀྱི་ཚར་ཕོན་དེ་གཡོབ་མཆོད་དུ་ཕུལ་བའི་ཉིན་མོ་དེ་ནས་བཟུང་། ངལ་གསོ་བའི་ཉིན་མོ་བདུན་ཏག་ཏག་བགྲང་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ངལ་གསོ་བའི་ཉིན་མོ་ཨང་བདུན་པའི་ཕྱི་ཉིན་ཏེ་བསྡོམས་པས་ཉིན་ལྔ་བཅུ་ཡིན་ལ། ཁྱོད་རྣམས་ཀྱིས་འབྲུ་མཆོད་གསར་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ཁྱོད་ཅག་གི་སྡོད་གནས་དག་ལས་གྲོ་ཞིབ་བྲེའི་བཅུ་ཆ་གཉིས་བླངས་ཏེ། གཡོབ་མཆོད་ཀྱི་བག་ལེབ་སྐྱུར་མ་གཉིས་བསྲེགས་ནས། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཐོག་ཕུད་ཀྱི་ལོ་ཏོག་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ཡང་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་སྐྱོན་མེད་པ་བདུན་དང་། སྒོ་ཕྱུགས་ལས་གླང་ཐུག་གཅིག་དང་ལུག་ཐུག་གཉིས་བཅས་བག་ལེབ་དང་མཉམ་དུ་འབུལ་དགོས། དེ་དག་ནི་འབྲུ་མཆོད་དང་སྐྱེམས་མཆོད་མཉམ་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་ཏུ་འབུལ་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་མེ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ཡང་ཁྱོད་རྣམས་ཀྱིས་ར་ཕོ་ཞིག་སྡིག་བཤགས་མཆོད་པ་དང་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་གཉིས་ཞི་བདེའི་མཆོད་པ་རུ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","མཆོད་དཔོན་གྱིས་དེ་རྣམས་དང་ལོ་ཏོག་གི་ཕུད་ཀྱིས་བཟོས་པའི་བག་ལེབ། ལུ་གུ་གཉིས་བཅས་མཉམ་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་ནས་གཡོབ་མཆོད་དུ་འབུལ་དགོས། འདི་རྣམས་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་རྫས་དམ་པ་ཡིན་པས་མཆོད་དཔོན་ལ་དབང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ཉིན་མོ་དེར་ཁྱོད་ཅག་གིས་འདུ་འཛོམས་དམ་པ་ཡིན་པ་བསྒྲག་དགོས་ལ། རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། ཁྱོད་ཅག་གི་སྡོད་གནས་ཐམས་ཅད་དུ། དེ་ནི་ཁྱོད་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ཁྱོད་རྣམས་ཀྱིས་རང་རང་གི་ས་ཞིང་ལས་ལོ་ཏོག་བསྡུ་བའི་ཚེ། ས་ཞིང་གི་གྲུ་ཟུར་བར་དུ་ཡོངས་སུ་བསྡུ་མི་རུང་། ལོ་ཏོག་སར་ལྷུང་བ་རྣམས་ཀྱང་བཏུ་མི་རུང་། དེ་ནི་དབུལ་པོ་དང་བྱེས་པ་དག་གི་ཕྱིར་དུ་འཇོག་དགོས། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ཟླ་བ་བདུན་པའི་ཚེས་དང་པོ་ནི་ཁྱོད་རྣམས་ཀྱིས་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་རུ་བསྲུང་བ་དང་། རྗེས་དྲན་གྱི་དུང་བུས་ནས་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་བར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","ཟླ་བ་བདུན་པའི་ཚེས་བཅུ་ནི་སྡིག་པ་བཤགས་པའི་ཉིན་མོ་ཡིན་པས། ཁྱོད་རྣམས་ཀྱིས་འདུ་འཛོམས་དམ་པ་རོལ་ནས་རང་ཉིད་ཁྱད་དུ་གསོད་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ཉིན་དེ་ལ་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། ཅི་ལ་ཞེ་ན། ཉིན་དེ་ནི་སྡིག་བཤགས་ཉིན་མོ་ཡིན་པས་ཁྱོད་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་སྡིག་པ་བཤག་དགོས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ཉིན་དེ་ལ་རང་ཉིད་ཁྱད་དུ་མི་གསོད་པ་ཐམས་ཅད་མི་མང་ཁྲོད་ནས་རྩ་མེད་དུ་གཏོང་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ཉིན་དེ་ལ་ལས་ཀ་གང་རུང་བྱེད་མཁན་ཐམས་ཅད་ནི་བདག་གིས་རང་གི་མི་མང་ཁྲོད་ནས་འཇོམས་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ཁྱོད་རྣམས་ཀྱིས་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། དེ་ནི་ཁྱོད་ཅག་སྡོད་སའི་ཡུལ་ཐམས་ཅད་དུ། ཁྱོད་རྣམས་ལ་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ཉིན་དེ་ནི་ཁྱོད་རྣམས་ཀྱིས་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་རུ་བསྲུང་བ་དང་། རང་ཉིད་ཁྱད་དུ་གསོད་དགོས། ཟླ་བ་དེའི་ཚེས་དགུ་ཡི་དགོང་མོ་ནས་ཕྱི་ཉིན་དགོང་མོའི་བར་དུ་ངལ་གསོ་བའི་ཉིན་མོ་རུ་བསྲུང་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ཟླ་བ་བདུན་པའི་ཚེས་བཅོ་ལྔ་ནི་སྤྱིལ་བུའི་དུས་ཆེན་ཡིན་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་དུ་ཉིན་བདུན་གྱི་རིང་ལ་དུས་ཆེན་འདིར་རོལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ཉིན་དང་པོར་འདུ་འཛོམས་དམ་པ་ཡོད་དགོས་ལ། རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ཉིན་བདུན་གྱི་རིང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས། ཉིན་བརྒྱད་པར་འདུ་འཛོམས་དམ་པ་བསྲུང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས། དེ་ནི་འདུ་འཛོམས་དམ་ནན་ཡིན་པས་རྒྱུན་ལྡན་གྱི་ལས་ཀ་གང་ཡང་བྱེད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་རྣམས་ཡིན་ཏེ། ཁྱོད་རྣམས་ཀྱིས་འདུ་འཛོམས་དམ་པར་བསྒྲག་དགོས་པའི་དུས་ཆེན་ཡིན་ཞིང་། མེ་མཆོད་དེ་སྦྱིན་སྲེག་གི་མཆོད་པ་དང་འབྲུ་མཆོད། དམར་མཆོད། སྐྱེམས་མཆོད་རྣམས་ཉིན་རེའི་གཏན་འཁེལ་བཞིན་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","གཞན་ཡང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ངལ་གསོ་བའི་ཉིན་མོ་དང་། ཁྱོད་ཚོས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་མཆོད་རྫས་རྣམས་དང་། དམ་བཅའི་མཆོད་པ་ཐམས་ཅད་དང་། ཡིད་མོས་པའི་མཆོད་པ་ཐམས་ཅད་བཅས་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","དེ་ལས་གཞན་ཟླ་བ་བདུན་པའི་ཚེས་བཅོ་ལྔ་ཏག་ཏག་སྟེ། ཁྱོད་རྣམས་ཀྱིས་ས་ཞིང་ནས་ལོ་ཏོག་བསྡུས་པའི་རྗེས་སུ། ཉིན་བདུན་རིང་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་རོལ་དགོས། ཉིན་དང་པོ་དེ་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་པ་དང་། ཉིན་བརྒྱད་པ་དེ་ཡང་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པའི་ཉིན་མོ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ཉིན་དང་པོ་ལ། ཁྱོད་རྣམས་ཀྱིས་ཕུལ་དུ་བྱུང་བའི་ལྗོན་ཤིང་གི་འབྲས་བུ་དང་། ཏ་ལའི་ཤིང་གི་ཡལ་ག་དང་། ལྗོན་ཤིང་ལོ་མ་སྟུག་པོ་ཅན་གྱི་ཡལ་ག་དང་། ཆུ་བོ་འགྲམ་གྱི་ལྕང་མའི་ཡལ་ག་བཅས་ཁྱེར་ནས། ཁྱོད་རྣམས་ཀྱིས་རང་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཉིན་བདུན་གྱི་རིང་ལ་དགའ་མགུ་ཡི་རང་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ལོ་རེ་བཞིན་དུ་ཉིན་བདུན་གྱི་རིང་ལ་ཁྱོད་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་རོལ་ཞིག ཁྱོད་ཅག་གིས་ཟླ་བ་བདུན་པར་རོལ་བའི་དུས་ཆེན་དེ་ནི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ཁྱོད་རྣམས་སྤྱིལ་བུའི་ནང་དུ་ཉིན་བདུན་ལ་འདུག་དགོས་ཤིང་། ཡེས་ར་ཨེལ་གྱི་གཞིས་སྐྱེས་ཐམས་ཅད་ཀྱང་སྤྱིལ་བུའི་ནང་དུ་འདུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","གང་ལ་ཞེ་ན། བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་པའི་དུས་སུ། དེ་དག་སྤྱིལ་བུའི་ནང་འདུག་ཏུ་བཅུག་པ་དེ་ཁྱོད་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར་ཤེས་སུ་འཇུག་པའི་ཕྱིར་རོ། །བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དུས་ཆེན་དག་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གསལ་བསྒྲགས་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག འོད་ཀྱི་ཆེད་དུ་སྐྱུ་རུ་ཤིང་ལས་བརྡུངས་པའི་སྣུམ་དྭངས་མ་དེ་འཁྱེར་ཡོང་དགོས། དེ་ནི་སྒྲོན་མེ་རྟག་ཏུ་འབར་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་དཔང་མཛད་ཤུར་སྒམ་གྱི་ཡོལ་བའི་ཕྱི་ལོགས་སུ། ཨ་རོན་གྱིས་མཚན་མོ་ནས་ཞོགས་པའི་བར་དུ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་སྒྲོན་མེ་དེར་རྒྱུན་དུ་བདག་བྱེད་དགོས། དེ་ནི་ཁྱོད་རྣམས་ཀྱི་མི་རབས་ནས་མི་རབས་བར་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་སུ་ཆགས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་རྟག་ཏུ་གསེར་བཙོ་མའི་སྒྲོན་སྟེགས་སྟེང་གི་སྒྲོན་མེ་ལ་བདག་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","དེ་ནས་ཁྱོད་ཀྱིས་གྲོ་ཞིབ་བླངས་ནས་བག་ལེབ་བཅུ་གཉིས་བསྲེག་དགོས་པ་དང་། བག་ལེབ་རེ་རེ་ཨེ་ཕཱ་ཡི་བཅུ་ཆ་གཉིས་རེས་བསྲེག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","དེ་ནས་བག་ལེབ་དྲུག་རེ་བྱས་ནས་གྲལ་གཉིས་སུ་བསྒྲིགས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གསེར་བཙོ་མའི་སྒྲོག་ཙེ་སྟེང་དུ་བཤམ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","གྲལ་རེའི་བག་ལེབ་སྟེང་དུ་སྤོས་དཀར་སླད་མེད་གཏོར་བ་དང་། དྲན་རྟེན་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞལ་ཟས་ཀྱི་མེ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ངལ་གསོ་བའི་ཉིན་མོ་རེ་རེ་ལ་ཨ་རོན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བག་ལེབ་ཆད་མེད་དུ་བཤམ་དགོས། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་དུས་གཏན་གྱི་ཁ་ཆད་ཅིག་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","བག་ལེབ་དེ་ནི་ཨ་རོན་དང་ཁོའི་བུ་རྣམས་ལ་དབང་བ་དང་། ཁོ་ཚོས་དེ་དག་གནས་དམ་པ་རུ་བཟའ་དགོས། ཅིའི་ཕྱིར་ཞེ་ན། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མེ་མཆོད་ལས་ཀུན་ལས་དམ་པ་ཡིན་པ་དང་། དུས་གཏན་དུ་ཁོང་ལ་དབང་བའི་སྐལ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","དེ་ཡང་ཡེས་ར་ཨེལ་གྱི་བུད་མེད་ཅིག་ལ་བུ་ཞིག་ཡོད་པ་དེའི་ཕ་ནི་ཨེ་ཅིབ་པ་ཡིན་ལ། ཁོ་རང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་སོང་ནས། ཡེས་ར་ཨེལ་གྱི་བུད་མེད་ཀྱི་བུ་དེ་དང་ཡེས་ར་ཨེལ་པ་ཞིག་སྒར་ནང་དུ་རྩོད་པ་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ཡེས་ར་ཨེལ་གྱི་བུད་མེད་ཀྱི་བུ་ཡིས་མཚན་དམ་པར་དམོད་མོ་དང་བཅས་སྐུར་བ་བཏབ་པས། དེ་དག་གིས་མི་དེ་མོ་ཤེའི་དྲུང་དུ་ཁྲིད། ཁོའི་མ་ཡི་མིང་ལ་ཤེ་ལོ་མིད་ཅེས་བྱ་ཞིང་། དཱན་ཚོ་པའི་དི་པཱ་རེ་བྱ་བའི་བུ་མོ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་གསལ་པོར་རྟོགས་ཕྱིར་ཁོ་ཚོས་མི་དེ་བཙོན་དུ་བཀག་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","དམོད་མོ་འདེབས་མཁན་དེ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཁྲིད་ཅིག དེ་ཐོས་པའི་མི་ཐམས་ཅད་ཀྱིས་ལག་པ་ཁོའི་མགོ་ལ་བཞག་ནས་མི་ཚོགས་ཧྲིལ་པོས་ཁོ་རང་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག སུ་ཞིག་གིས་རང་གི་དཀོན་མཆོག་ལ་དམོད་པར་བྱས་ན། དེས་རང་གི་སྡིག་པ་འཁུར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","སུ་ཞིག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་མཚན་ལ་སྐུར་བ་བཏབ་ན། དེ་ནི་ཅིས་ཀྱང་སྲོག་དང་འཕྲལ་དགོས་པ་དང་། མི་ཚོགས་ཧྲིལ་པོས་ཁོ་རང་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས། བྱེས་པའམ་གཞིས་སྐྱེས་གང་ཡིན་ཡང་། ཁོས་དམ་པའི་མཚན་ལ་སྐུར་བ་འདེབས་དུས་སྲོག་དང་འཕྲལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","མི་གསོད་མཁན་ནི་ངེས་པར་སྲོག་དང་འཕྲལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ཕྱུགས་ཟོག་གསོད་མཁན་གྱིས་དེའི་སྐྱིན་ཚབ་ལ་ཕྱུགས་ཟོག་སྤྲད་ནས། སྲོག་ཚབ་སྲོག་གིས་འཇལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","སུ་ཞིག་གིས་ཁྱིམ་མཚེས་ལ་གནོད་བསྐྱལ་ན། མི་དེས་བྱས་པ་བཞིན་དུ་ཁོ་ལའང་དེ་ལྟར་བྱེད་དགོས་པ་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","བཅགས་པའི་ལན་དུ་བཅགས་པ་དང་། མིག་ལ་མིག་ལན་དང་སོ་ལ་སོ་ལན་འཇལ་དགོས། མི་དེས་ཇི་ལྟར་མི་གཞན་ཞིག་དབང་བོ་སྐྱོན་ཅན་དུ་བཟོས་ན། ཁོ་ལའང་དེ་བཞིན་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ཕྱུགས་ཟོག་གསོད་མཁན་གྱིས་དེའི་སྐྱིན་ཚབ་ལ་ཕྱུགས་ཟོག་འཇལ་དགོས་པ་དང་། མི་གསོད་མཁན་ལ་སྲོག་ཆད་གཅོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","བྱེས་པའམ་གཞིས་སྐྱེས་གང་ཡིན་ཡང་ཁྲིམས་སྲོལ་གཅིག་ཡིན་དགོས། ཅི་ལ་ཞེ་ན། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བཀའ་བསྒོས་ཤིང་། ཁོ་རྣམས་ཀྱིས་དམོད་མོ་འདེབས་མཁན་དེ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཁྲིད་དེ་རྡོ་རུབ་བཏང་ནས་བསད་དོ། །ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་བསྒྲུབས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱའི་སྟེང་དུ་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྒོས་ཤིག ཁྱོད་རྣམས་བདག་གིས་ཁྱོད་ཅག་ལ་སྦྱིན་པའི་ཡུལ་དུ་སླེབས་པའི་ཚེ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་དུ་ས་གཞིས་ངལ་གསོ་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ཁྱོད་རྣམས་ཀྱིས་ལོ་དྲུག་གི་རིང་ཞིང་ལ་ས་བོན་འདེབས་པ་དང་། ལོ་དྲུག་གི་རིང་རྒུན་འབྲུམ་ར་བར་འབྲེག་བཅོས་བྱས་ནས་ས་ཞིང་གི་ལོ་ཏོག་བསྡུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ལོ་བདུན་པར་ས་གཞིས་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པ་བྱས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱིར་ངལ་གསོ་བྱེད་དགོས། ཁྱོད་རྣམས་ཀྱིས་ས་ཞིང་འདེབས་མི་རུང་ལ། རྒུན་འབྲུམ་ར་བར་འབྲེག་བཅོས་ཀྱང་བྱེད་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","རང་བཞིན་དུ་སྐྱེས་པའི་ལོ་ཏོག་བསྡུ་མི་རུང་ལ། འབྲེག་བཅོས་མ་བྱས་པའི་རྒུན་འབྲུམ་ཤིང་གི་རྒུན་འབྲུམ་ཡང་བསྡུ་མི་འོས། ལོ་དེར་ས་གཞིས་ངལ་གསོ་ཡོངས་སུ་རྫོགས་པ་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ངལ་གསོའི་ལོར་ས་ཞིང་ལས་སྐྱེས་པ་དེ་ནི་ཁྱོད་དང་ཁྱོད་ཀྱི་གཡོག་པོ་གཡོག་མོ་དང་། གླ་པ་དང་ཁྱོད་དང་མཉམ་དུ་སྡོད་པའི་བྱེས་པ་བཅས་ཀྱི་ཁ་ཟས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ལོ་ཏོག་ཐམས་ཅད་ནི་ཁྱོད་ཀྱི་ཕྱུགས་ཟོག་དང་ཡུལ་དེར་ཡོད་པའི་རི་དྭགས་ཀྱི་ཁ་ཟས་ཀྱང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ཁྱོད་ཀྱིས་ངལ་གསོའི་ལོ་བདུན་བརྩི་དགོས་པ་སྟེ། ལོ་བདུན་ནི་ཐེངས་བདུན་ཡིན་པས། ཁྱོན་བསྡོམས་ལོ་བཞི་བཅུ་ཞེ་དགུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ཟླ་བ་བདུན་པའི་ཚེས་བཅུ་པར་ཁྱོད་ཀྱིས་རྭ་དུང་སྐད་ཆེན་པོ་འབུད་དགོས། དེ་ནི་སྡིག་བཤགས་ཉིན་མོ་ཡིན་ལ་ཁྱོད་ཀྱིས་ཡུལ་ཐམས་ཅད་ནས་རྭ་དུང་འབུད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ཁྱོད་ཅག་གིས་ལོ་ལྔ་བཅུ་པ་ནི་ལོ་དམ་པ་རུ་བརྩི་བ་དང་། ཡུལ་ཐམས་ཅད་དུ་མི་ཀུན་ལ་རང་དབང་ཡིན་པར་སྒྲོགས་ཤིག དེ་ནི་ཁྱོད་ཅག་གི་དོན་དུ་དགའ་སྟོན་གྱི་ལོ་ཡིན་པས། མི་རེ་རེ་ཕྱིར་ཕ་གཞིས་སུ་ལོག་པ་དང་། མི་རེ་རེ་རང་རང་གི་ཁྱིམ་རྒྱུད་དུ་ལོག་པར་རིགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ལོ་ལྔ་བཅུ་པ་ནི་ཁྱོད་རྣམས་ཀྱི་དགའ་སྟོན་གྱི་ལོ་རུ་བརྩི་དགོས་ལ། ས་ཞིང་འདེབས་མི་རུང་བ་དང་རང་བཞིན་གྱིས་སྐྱེས་པའི་ལོ་ཏོག་བསྡུ་མི་འོས་ལ། འབྲེག་བཅོས་མ་བྱས་པའི་རྒུན་འབྲུམ་ཤིང་གི་རྒུན་འབྲུམ་ཡང་བསྡུ་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ཅིའི་ཕྱིར་ཞེ་ན། དེ་ནི་དགའ་སྟོན་གྱི་ལོ་སྟེ་ཁྱོད་རྣམས་ཀྱི་ལོ་དམ་པ་ཡིན་ཞིང་། ས་ཞིང་དུ་སྐྱེས་པའི་ལོ་ཏོག་རྣམས་བཟའ་དགོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","དགའ་སྟོན་གྱི་ལོ་འདིར་ཁྱོད་ཚོ་མི་རེ་རེ་ཕ་གཞིས་སུ་ཕྱིར་ལོག་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ཁྱོད་ཀྱིས་ཁྱིམ་མཚེས་ལ་གང་ཞིག་བཙོང་བའམ། ཡང་ན་ཁྱིམ་མཚེས་ཀྱི་ལག་ནས་ཅི་ཞིག་ཉོས་ན་ཕན་ཚུན་ལ་མགོ་སྐོར་གཏོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ཁྱོད་ཀྱིས་དགའ་སྟོན་གྱི་ལོ་ནས་བཟུང་སྟེ། ལོ་དེ་དག་གི་གྲངས་བཞིན་དུ་ཁྱིམ་མཚེས་ནས་ཉོ་བ་དང་། ཁོས་ནི་ཐོན་འབབ་ཡོད་པའི་ལོ་གྲངས་བཞིན་དུ་ཁྱོད་ལ་བཙོང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ཁོས་ཐོན་འབབ་ཀྱི་གྲངས་ཀ་བཞིན་དུ་ཁྱོད་ལ་བཙོང་བའི་ཕྱིར། ལོ་གྲངས་ཅི་ལྟར་མང་ན་རིན་གོང་དེ་བཞིན་མཐོ་བ་དང་། ལོ་གྲངས་ཅི་ལྟར་ཉུང་ན་རིན་གོང་དེ་བཞིན་དམའ་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ཁྱོད་ཚོས་ཕན་ཚུན་ལ་གྱོང་གུད་བཟོ་མི་རུང་། ཁྱོད་ཀྱི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་དགོས། ཅི་ལ་ཞེ་ན། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་སྒྲིག་ཁྲིམས་བཞིན་དུ་བྱེད་པ་དང་། བདག་གི་སྲོལ་ཡིག་རྣམས་བསྲུངས་ནས་དེ་བཞིན་དུ་བྱེད་དགོས་ལ། དེ་བཞིན་བྱས་ན་ཡུལ་དེ་རུ་བདེ་བར་གནས་ཐུབ་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ས་ཞིང་གིས་འབྲས་བུ་བསྐྱེད་ཅིང་ཁྱོད་རྣམས་ཀྱིས་དེ་ཟོས་ནས་འགྲང་བ་དང་། ཡུལ་དེ་རུ་བདེ་བར་གནས་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","གལ་སྲིད་ཁྱོད་རྣམས་ཀྱིས། གཟིགས་དང་། ལོ་བདུན་པར་ས་ཞིང་མི་རྨོ་ལ་ལོ་ཏོག་ཀྱང་མི་བསྡུ་བས་ང་ཚོས་ཅི་ཞིག་བཟའ་དགོས་སམ་ཞེས་བརྗོད་ན། ");
INSERT INTO bodn_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ལོ་དྲུག་པར་བདག་གིས་བཀའ་བབས་ཏེ་ཁྱོད་ལ་བྱིན་རླབས་གནང་ནས། ས་ཞིང་གིས་ལོ་གསུམ་གྱི་ལོ་ཏོག་བསྐྱེད་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ལོ་བརྒྱད་པར་ཁྱོད་རྣམས་ཀྱིས་ས་ཞིང་རྨོ་དགོས་ལ། འབྲུ་རྙིང་ཡང་བཟའ་དགོས། ལོ་དགུ་པར་ལོ་ཏོག་བསྡུ་བའི་བར་དུ་ཁྱོད་རྣམས་ལ་ད་དུང་འབྲུ་རྙིང་བཟའ་རྒྱུ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","ས་ནི་མཐའ་གཅིག་ཏུ་བཙོང་མི་རུང་། ཅི་ལ་ཞེ་ན། ས་ཞིང་ནི་བདག་གི་ཡིན་པའི་ཕྱིར་རོ། །ཁྱོད་ཅག་ནི་ངའི་མདུན་དུ་མགྲོན་པོ་དང་བྱེས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ཁྱོད་ལ་ས་སྐལ་དུ་ཐོབ་པའི་ཡུལ་ཀུན་ཏུ་མི་ལ་ས་བླུ་བའི་དབང་ཡོད་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ཁྱོད་ཀྱི་སྤུན་ཟླ་དབུལ་པོར་གྱུར་ནས་རང་གི་ནོར་སྐལ་ལས་ཆ་ཤས་བཙོངས་ན། ཁོ་བླུ་མཁན་གྱི་གཉེན་ཉེ་ཡོང་ནས་གང་ཞིག་བཙོངས་པ་དེ་ཕྱིར་བླུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","གལ་སྲིད་ཁོ་ལ་བླུ་མཁན་མེད་ན། ཁོ་རང་ལ་རིམ་བཞིན་རྒྱུ་སྟོབས་འཛོམས་ནས་ཕྱིར་བླུ་ཐུབ་པའི་དུས་སུ། ");
INSERT INTO bodn_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ཕར་བཙོངས་པའི་ལོ་ནས་བཟུང་བརྩིས་ཏེ། དེའི་འཕྲོ་ཡི་ལོ་གྲངས་ཀྱི་རིན་གོང་རྣམས་ཉོ་མཁན་ལ་ཕྱིར་སློག་དགོས་ཤིང་། དེ་ནས་རང་གི་ཕ་གཞིས་ལ་ཕྱིར་ལོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","གལ་སྲིད་མི་དེའི་ལག་ཏུ་ཕྱིར་བླུ་བའི་རྒྱུ་སྟོབས་མེད་ན། ཕར་བཙོངས་པའི་ས་དེ་ནི་ཉོ་མཁན་གྱི་ལག་ནས་དགའ་སྟོན་གྱི་ལོ་ཡི་བར་དུ་ལུས་ཤིང་། དགའ་སྟོན་གྱི་ལོ་དེར་ས་འཚོང་མཁན་ནི་ཕ་གཞིས་སུ་ཕྱིར་ལོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","གལ་སྲིད་མི་ཞིག་གིས་ལྕགས་རིས་བསྐོར་བའི་གྲོང་ཁྱེར་ནང་གི་སྡོད་ཁང་བཙོངས་ན། བཙོངས་པའི་རྗེས་སུ་ལོ་གཅིག་གི་ནང་དུ་ཕྱིར་བླུ་བའི་དབང་ཡོད་ལ། དེ་ནི་ཁོས་ཕྱིར་བླུས་ཆོག་པའི་ལོ་གཅིག་གི་ཚད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","གལ་སྲིད་ཁོས་ལོ་ཧྲིལ་པོའི་ནང་ཕྱིར་མ་བླུས་ན། ལྕགས་རིས་བསྐོར་བའི་གྲོང་ཁྱེར་ནང་གི་ཁང་པ་དེ་ནི་མི་རབས་ནས་མི་རབས་བར་དུ་ཉོ་མཁན་ལ་དབང་བ་ཡིན། དགའ་སྟོན་གྱི་ལོ་ལའང་ཕྱིར་སྤྲོད་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","འོན་ཀྱང་ལྕགས་རིས་བསྐོར་མེད་པའི་གྲོང་ཚོའི་ཁང་པ་རྣམས་ནི་གྲོང་གསེབ་ཀྱི་ཞིང་ས་རུ་བརྩིས་ཏེ་ཕྱིར་བླུ་སྲིད་པ་ཡིན་ལ། དགའ་སྟོན་གྱི་ལོ་ལ་ཕྱིར་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ལེ་ཝི་པ་རྣམས་ལ་ས་སྐལ་དུ་ཐོབ་པའི་གྲོང་ཁྱེར་ལ་མཚོན་ན། ལེ་ཝི་པ་ཚོས་ཁོ་རྣམས་ཀྱི་གྲོང་ཁྱེར་དུ་ཡོད་པའི་ཁང་པ་ནི་དུས་ནམ་ཡིན་ཡང་བླུས་ཆོག་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","གལ་སྲིད་ལེ་ཝི་པ་རྣམས་ཀྱིས་རང་ལ་ས་སྐལ་དུ་ཐོབ་པའི་གྲོང་ཁྱེར་ནས་ཁང་པ་བཙོངས་པ་དང་། ཕྱིར་མ་བླུས་པ་ཡིན་ན། དགའ་སྟོན་གྱི་ལོ་དེར་ཕྱིར་བདག་པོར་སྤྲོད་དགོས། ཅི་ལ་ཞེ་ན། ལེ་ཝི་པ་རྣམས་ཀྱི་གྲོང་ཁྱེར་གྱི་ཁང་པ་རྣམས་ནི། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་ཁོ་ཚོའི་ནོར་སྐལ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ཡིན་ནའང་། དེ་དག་གི་གྲོང་ཁྱེར་སོ་སོའི་ཉེ་འཁོར་གྱི་རྩྭ་ས་ནི་ཁོ་ཚོའི་དུས་གཏན་གྱི་ས་སྐལ་ཡིན་པས་བཙོང་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","གལ་སྲིད་ཁྱོད་ཀྱི་སྤུན་ཟླ་རིམ་བཞིན་དབུལ་པོར་གྱུར་ཏེ་ལག་ནས་ཅི་ཡང་མེད་ན། ཁྱོད་ཀྱིས་ཁོ་ལ་རོགས་སྐྱོར་བྱས་ཏེ་ཕྱི་མི་དང་བྱེས་པ་རྣམས་དང་མཚུངས་པར་ཁོ་རང་ཁྱོད་དང་མཉམ་དུ་འཚོ་བར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","མི་དེ་ལས་སྐྱེད་ཀ་ལེན་མི་རུང་ལ། ཁེ་བཟང་ཡང་ལེན་མི་རུང་། ཁྱོད་ཀྱི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་པའི་སྒོ་ནས། ཁྱོད་ཀྱི་སྤུན་ཟླ་ཁྱོད་དང་མཉམ་དུ་འཚོ་བར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ཁྱོད་ཀྱིས་སྐྱེད་ཀའི་དོན་དུ་ཁོ་ལ་དངུལ་བསྐྱི་མི་རུང་ལ། ཁེ་བཟང་གི་དོན་དུ་ཟས་རིགས་ཀྱང་བསྐྱི་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ལ། ཀ་ན་ཨན་གྱི་ཡུལ་ཁྱོད་ཅག་ལ་སྦྱིན་པ་དང་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡིན་པའི་ཕྱིར་དུ། ཁྱོད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་ཡོང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","གལ་སྲིད། ཁྱོད་ཀྱི་སྤུན་ཟླ་རིམ་བཞིན་དབུལ་པོར་གྱུར་ནས་རང་ཉིད་ཁྱོད་ལ་བཙོངས་ན། ཁྱོད་ཀྱིས་ཁོ་བྲན་གཡོག་ལྟར་བཀོལ་ནས་ཞབས་ཕྱི་སྒྲུབ་ཏུ་འཇུག་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ཁོ་རང་ཁྱོད་ཀྱི་རྩར་གླ་པ་དང་མགྲོན་པོ་ལྟར་ཡིན་ཞིང་། དགའ་སྟོན་གྱི་ལོའི་བར་དུ་ཁྱོད་ལ་ཞབས་ཕྱི་བསྒྲུབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","དེ་ནས་ཁོ་དང་ཁོའི་བུ་ཕྲུག་རྣམས་ཁྱོད་དང་བྲལ་ནས་མཉམ་དུ་རང་གི་ཁྱིམ་རྒྱུད་དུ་ཕྱིར་ལོག་ཅིང་། རང་གི་ཕ་མེས་ཀྱི་བདག་དབང་ཡུལ་དུ་ཕྱིར་འགྲོའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ཅིའི་ཕྱིར་ཞེ་ན། ཁོ་རྣམས་ནི་བདག་གི་ཞབས་ཕྱི་ཡིན་ལ། བདག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་འོངས་པ་ཡིན་པས། དེ་དག་བྲན་གཡོག་ཏུ་བཙོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","དེ་དག་ལ་གདུག་རྩུབ་བཀོལ་ནས་དབང་སྒྱུར་མི་རུང་ལ། ཁྱོད་ཀྱི་དཀོན་མཆོག་ལ་གུས་ཤིང་འཇིགས་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","དེར་བརྟེན། ཁྱོད་ལ་མཁོ་བའི་གཡོག་པོ་གཡོག་མོ་རྣམས་ནི། ཁྱོད་ཀྱི་མཐའ་འཁོར་དུ་ཡོད་པའི་མི་རྣམས་ལས་ཡོང་བར་རིགས། ཁྱོད་ཅག་གིས་ཁོ་རྣམས་ལས་གཡོག་པོ་གཡོག་མོ་ཉོས་ཆོག་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ཁྱོད་ཅག་ཁྲོད་དུ་གནས་པའི་ཕྱི་མི་དང་དེ་དག་གི་ཁྱིམ་མི་སྟེ། ཁྱོད་ཅག་གི་ཡུལ་ནས་སྐྱེས་པ་རྣམས་ཀྱི་ཁྲོད་ནས་མི་ཉོས་ཆོག་པ་ཡིན། དེ་དག་ཁྱོད་རྣམས་ཀྱི་ནོར་སྐལ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ཁྱོད་ཅག་གིས་དེ་དག་ནི་མི་རབས་རྗེས་མའི་བུ་རྒྱུད་རྣམས་ལ་ཤུལ་བཞག་ཏུ་སྤྲད་ནས། དུས་གཏན་དུ་རྒྱུན་འཛིན་བྱས་པའི་ནོར་སྐལ་དུ་བྱས་ཏེ། དེ་དག་བྲན་གཡོག་ཏུ་བཀོལ་བར་རིགས། འོན་ཀྱང་ཁྱོད་ཀྱི་སྤུན་ཟླ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་མཚོན་ན། ཕན་ཚུན་ལ་གདུག་རྩུབ་བཀོལ་ནས་དབང་སྒྱུར་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","གལ་སྲིད་ཁྱོད་དང་མཉམ་དུ་གནས་པའི་ཕྱི་མིའམ་བྱེས་པ་ཞིག་རིམ་བཞིན་ཕྱུག་པོར་གྱུར་པ་དང་། ཁྱོད་ཀྱི་སྤུན་ཟླ་ཞིག་རིམ་བཞིན་དབུལ་པོར་གྱུར་ཏེ། རང་ཉིད་ཕྱི་མིའམ་བྱེས་པ་དང་། ཡང་ན་ཕྱི་མིའི་ཁྱིམ་རྒྱུད་ལས་ཆད་པའི་བུ་ཞིག་ལ་བཙོངས་པ་ཡིན་ན། ");
INSERT INTO bodn_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","བཙོངས་པའི་རྗེས་སུ་རང་ཉིད་ཕྱིར་བླུ་བའི་དབང་ཡོད་དེ། ཁོའི་སྤུན་རྣམས་ལས་གཅིག་གིས་ཁོ་རང་ཕྱིར་བླུ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ཁོའི་ཁུ་བོ་དང་ཁུ་བོའི་བུ་ཡིས་ཁོ་རང་བླུ་རུང་བ་དང་། ཁོའི་ཁྱིམ་རྒྱུད་ཀྱི་ཉེ་འབྲེལ་གྱིས་ཀྱང་ཁོ་རང་བླུ་རུང་བ་ཡིན། གལ་སྲིད་ཁོ་རང་ཉིད་རིམ་བཞིན་ཕྱུག་པོར་གྱུར་ན་རང་གིས་རང་ཉིད་བླུ་ཡང་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","མི་དེས་རང་ཉིད་བཙོངས་པའི་ལོ་ནས་བཟུང་སྟེ། དགའ་སྟོན་གྱི་ལོའི་བར་དུ་ཁོ་རང་ཉོ་མཁན་དང་རྩིས་རྒྱག་དགོས། བཙོངས་པའི་རིན་པ་ནི་ལོ་ཡི་གྲངས་ཀ་སྟེ། གླ་པ་དང་ཉོ་བདག་མཉམ་དུ་ཡོད་པའི་ཉི་མ་ལྟར་བརྩི་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","གལ་སྲིད་ལོ་མང་པོ་ལྷག་ཡོད་ན། ལོ་ཡི་གྲངས་ཀ་བཞིན་དུ་ཉོས་པའི་རིན་ལས་ཁོའི་བླུ་རིན་ཕྱིར་སློག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","དགའ་སྟོན་གྱི་ལོ་བར་དུ་ལོ་འགའ་ཤས་ལས་ལྷག་མེད་ན། ལོའི་གྲངས་ཀ་བཞིན་དུ་ཉོ་བདག་ལ་རྩིས་རྒྱག་པ་དང་། ཁོའི་བླུ་རིན་ཕྱིར་སློག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ཁོ་རང་ཉོ་བདག་དང་མཉམ་དུ་ལོ་རེ་བཞིན་གླ་བའི་གླ་པ་ལྟར་འདུག་དགོས་ལ། ཉོ་བདག་གིས་ཁྱོད་ཀྱི་མིག་ལམ་ནས་མི་དེར་གདུག་རྩུབ་བཀོལ་ནས་དབང་སྒྱུར་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","གལ་སྲིད་ཁོ་རང་དེ་བཞིན་དུ་བླུ་བར་མ་འོངས་ན། དགའ་སྟོན་གྱི་ལོ་ལ་སླེབས་ཚེ་ཁོའི་བུ་ཕྲུག་རྣམས་དང་མཉམ་དུ་ཕྱིར་འགྲོ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ཅི་ལ་ཞེ་ན། ཡེས་ར་ཨེལ་པ་རྣམས་ནི་བདག་གི་ཞབས་ཕྱི་ཡིན་ལ། དེ་རྣམས་ནི་བདག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་པའི་ཞབས་ཕྱི་ཡིན། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","ཁྱོད་རྣམས་ཀྱིས་སྙིང་པོ་མེད་པའི་སྐུ་བརྙན་བཟོ་མི་རུང་ཞིང་། བརྐོས་པའི་སྐུ་འདྲ་དང་ལྷ་རྟེན་བསྒྲེང་མི་རུང་ལ། ཁྱོད་རྣམས་ཀྱི་ཡུལ་དུ་རྡོ་སྐུ་བསྒྲེངས་ནས་དེ་ལ་ཕྱག་ཀྱང་མ་འཚལ། ཅི་ལ་ཞེ་ན། བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","བདག་གི་ངལ་གསོ་བའི་ཉིན་མོ་རྣམས་བསྲུངས་ནས་བདག་གི་གནས་མཆོག་ལ་གུས་ཤིང་འཇིགས་པར་གྱིས་ཤིག བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","གལ་སྲིད་ཁྱོད་རྣམས་ཀྱིས་བདག་གི་སྒྲིག་ཁྲིམས་བཞིན་བསྒྲུབས་པ་དང་། བདག་གི་བཀའ་རྣམས་བསྲུངས་ནས་དེ་བཞིན་དུ་བྱས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","བདག་གིས་ཁྱོད་རྣམས་ལ་དུས་ལྟར་ཆར་པ་གནང་སྟེ་ས་གཞི་ནས་ལོ་ཏོག་སྐྱེ་བ་དང་། ཞིང་ཁའི་སྡོང་པོར་ཤིང་ཏོག་འཐོག་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ཁྱོད་ཚོས་རྒུན་འབྲུམ་བསྡུ་བའི་བར་དུ་གཡུལ་ཁ་གཅོག་པར་འགྱུར་བ་དང་། ས་བོན་འདེབས་པའི་བར་དུ་རྒུན་འབྲུམ་བསྡུ་བར་འགྱུར་ལ། ཟ་མ་ཟོས་ནས་ལྟོ་བ་འགྲང་ཞིང་། ཁྱོད་ཅག་རང་གི་ཡུལ་དུ་བདེ་བར་གནས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","བདག་གིས་ཁྱོད་ཚོའི་ཡུལ་དུ་ཞི་བདེ་གནང་ནས་མལ་དུ་ཉལ་བའི་དུས་སུ་ཁྱོད་ལ་འཇིགས་སྐུལ་མཁན་མེད་པར་བྱ། བདག་གིས་ཁྱོད་ཚོའི་ཡུལ་ནས་གཅན་གཟན་གཏུམ་པོ་རྣམས་མེད་པར་བྱེད་ཅིང་། རལ་གྲི་ཅན་རྣམས་ཡུལ་འདི་བརྒྱུད་ནས་འགྲོ་བར་མི་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ཁྱོད་ཚོས་དགྲ་རྣམས་འདེད་པར་བྱེད་ཅིང་། དེ་དག་ཁྱོད་རྣམས་ཀྱི་རལ་གྲིའི་ཁ་ནས་འགྱེལ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ཁྱོད་ཚོ་མི་ལྔ་ཡིས་མི་བརྒྱ་འདེད་པ་དང་། ཁྱོད་ཚོ་མི་བརྒྱ་ཡིས་མི་ཆིག་ཁྲི་འདེད་ཅིང་། དགྲ་རྣམས་ཁྱོད་ཀྱི་མདུན་དུ་རལ་གྲིའི་ཁ་ནས་འགྱེལ་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","བདག་གིས་ཁྱོད་རྣམས་ལ་བདག་སྐྱོང་བྱས་ཏེ་འབྲས་ལྡན་གྱི་རྒྱུད་མང་པོ་འཕེལ་བར་བྱེད་ཅིང་། བདག་གི་ཁ་ཆད་ཀྱང་ཁྱོད་རྣམས་བར་དུ་བརྟན་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ཁྱོད་ཚོས་གསོག་ཉར་བྱས་པའི་འབྲུ་རྙིང་བཟའ་ཞིང་། ཡང་འབྲུ་གསར་བྱུང་བའི་རྐྱེན་གྱིས་འབྲུ་རྙིང་གཙང་བཤེར་བྱེད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","བདག་གིས་རང་གི་གུར་མཆོག་ཁྱོད་ཚོའི་དཀྱིལ་དུ་འཛུགས་པ་དང་། བདག་གི་སེམས་ནས་ཁྱོད་ཚོར་སྡང་བར་ཡང་མི་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","བདག་ནི་ཁྱོད་ཅག་གི་ཁྲོད་ནས་འགྲོ་འོང་བྱེད་ཅིང་ཁྱོད་ཚོའི་དཀོན་མཆོག་བྱེད་པ་དང་། ཁྱོད་ཅག་ནི་བདག་གི་འབངས་མི་ཡིན་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","བདག་ནི་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པ་དང་། ཁྱོད་རྣམས་ཨེ་ཅིབ་པ་རྣམས་ཀྱི་བྲན་གཡོག་མི་བྱེད་པའི་ཆེད་དུ། བདག་གིས་ཁྱོད་ཚོ་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་པ་ཡིན། བདག་གིས་ཁྱོད་རྣམས་ཀྱིས་འཁུར་བའི་གཉའ་ཤིང་བཅགས་ཏེ་ཁྱོད་ཚོ་མགོ་ཡར་དགྱེ་ནས་མདུན་དུ་སྐྱོད་ཐུབ་པར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","འོན་ཀྱང་། ཁྱོད་ཀྱིས་བདག་གི་ངག་ལ་མི་ཉན་ཞིང་། བདག་གི་བཀའ་རྣམས་བརྩི་བར་མི་བྱེད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","བདག་གི་སྒྲིག་ཁྲིམས་རྣམས་དོར་ནས་སེམས་སུ་བདག་གི་སྲོལ་ཡིག་རྣམས་ལ་སུན་སྣང་སྐྱེས་ཤིང་། བཀའ་རྣམས་མི་བརྩི་བར་བདག་གི་ཁ་ཆད་རྒྱབ་ཏུ་བསྐྱུར་ན། ");
INSERT INTO bodn_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","བདག་གིས་ཁྱོད་ཅག་ལ་འདི་བཞིན་བྱ་སྟེ། ཁྱོད་ལ་འཇིགས་སྣང་དང་གློ་ནད་དང་ཚ་ནད་བཅས་ཕོག་པར་བྱས་ནས། མིག་ཞར་བ་དང་ལུས་ཟུངས་ཟད་པར་འགྱུར། ཁྱོད་རྣམས་ཀྱིས་དོན་མེད་དུ་ས་བོན་འདེབས་པར་འགྱུར་ཏེ། ཅི་ལ་ཞེ་ན། ཁྱོད་ཚོས་བཏབ་པ་རྣམས་དགྲ་ཡིས་ཡོངས་སུ་བཟའ་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ཁྱོད་རྣམས་ལ་བདག་གི་གདོང་མདོག་ལོག་སྟེ། ཁྱོད་རྣམས་དགྲ་བོའི་མདུན་དུ་ཕམ་པར་བྱའོ། །ཁྱོད་ཚོར་སྡང་བའི་མི་རྣམས་ཀྱིས་ཁྱོད་ཅག་དབང་དུ་བསྡུ་བ་དང་། ར་མདར་རྒྱུག་མཁན་མེད་ཀྱང་ཁྱོད་རྣམས་འབྲོ་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","དེ་ལྟར་བྱུང་རྗེས་ཁྱོད་ཅག་གིས་ད་དུང་བདག་གི་ངག་ལ་མི་ཉན་ན། བདག་གིས་ཁྱོད་རྣམས་ཀྱི་སྡིག་པའི་ཕྱིར་ཁྱོད་ཚོར་ཉེས་ཆད་ལྡབ་བདུན་གཅོད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","བདག་གིས་ཁྱོད་རྣམས་ཀྱི་སྟོབས་ཤུགས་ལས་བྱུང་བའི་ང་རྒྱལ་རྡུལ་དུ་བརླག་པར་བྱེད་པ་དང་། ཁྱོད་རྣམས་ཀྱི་ནམ་མཁའ་ལྕགས་ལྟར་མཁྲེགས་ཤིང་། ཁྱོད་ཚོའི་ས་གཞི་ལི་ལྟར་སྲ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ཁྱོད་རྣམས་ཀྱི་རྩོལ་ཤུགས་ངལ་བ་དོན་མེད་དུ་འགྲོ་བ་སྟེ། ཁྱོད་ཅག་གི་ས་ཞིང་གིས་ལོ་ཏོག་མི་བསྐྱེད་ལ། ས་སྟེང་གི་སྡོང་པོས་ཀྱང་ཤིང་ཏོག་མི་བསྐྱེད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","གལ་སྲིད། ཁྱོད་ཅག་གི་སྤྱོད་པ་སྤྱོད་སྟངས་བདག་དང་རྒྱབ་འགལ་དུ་སོང་ནས་བདག་གི་ངག་ལ་མཉན་མི་འདོད་ན། བདག་གིས་ཁྱོད་རྣམས་ཀྱི་སྡིག་པ་བཞིན་དུ། ལྡབ་བདུན་གྱིས་ཁྱོད་རྣམས་ལ་ཆད་མེད་དུ་བརྡུང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","བདག་གིས་ས་སྟེང་གི་གཅན་གཟན་རྣམས་ཁྱོད་ཅག་གི་ཁྲོད་དུ་གཏོང་ཞིང་། ཁྱོད་ཅག་གི་བུ་ཕྲུག་རྣམས་འཕྲོག་པ་དང་། ཁྱོད་ཅག་གི་ཕྱུགས་ཟོག་རྣམས་བསད་ནས། ཁྱོད་ཅག་གི་མི་གྲངས་ཇེ་ཉུང་དུ་འགྲོ་ཞིང་སྲང་ལམ་རྣམས་སྟོང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","དེ་ལྟར་བྱུང་རྗེས་ཁྱོད་རྣམས་ཀྱིས་ད་དུང་ངའི་བསླབ་ཁྲིམས་དང་དུ་བླངས་ནས་བདག་གི་ཕྱོགས་སུ་མི་འཁོར་བར། བདག་དང་རྒྱབ་འགལ་དུ་སོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","བདག་ཀྱང་ཁྱོད་དང་རྒྱབ་འགལ་དུ་འགྲོ་ཞིང་། ཁྱོད་རྣམས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ་ལྡབ་བདུན་གྱིས་ཁྱོད་ཅག་ལ་བརྡུང་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","བདག་གིས་རལ་གྲི་ཁྱོད་རྣམས་ལ་ཕོག་པར་བྱས་ནས་ཁྱོད་ཚོ་ཁ་ཆད་དང་འགལ་བར་ལན་འཇལ་རྒྱུ་ཡིན། ཁྱོད་ཚོ་རང་གི་གྲོང་ཁྱེར་རྣམས་སུ་འདུས་པ་ཡིན་ན། བདག་གིས་ཁྱོད་རྣམས་ཀྱི་དཀྱིལ་དུ་ནད་ཡམས་གཏོང་ཞིང་། ཁྱོད་རྣམས་དགྲ་བོའི་ལག་ཏུ་གཏོད་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","བདག་གིས་ཁྱོད་ཅག་ལ་འབྲུ་རིགས་འཐོབ་མཚམས་ཆད་པར་བྱ་ཞིང་། བུད་མེད་བཅུ་ཡིས་ཐབ་ཀ་གཅིག་ཏུ་ཁྱོད་རྣམས་ལ་བག་ལེབ་བསྲེག་ཅིང་། ལྗིད་ཚད་འཇལ་ནས་ཁྱོད་རྣམས་ལ་སྦྱིན་པ་དང་། ཁྱོད་ཚོས་དེ་ཟོས་ཀྱང་འགྲང་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","དེ་ལྟར་བྱུང་རྗེས་ཁྱོད་ཚོས་ད་དུང་བདག་གི་ངག་ལ་མི་ཉན་པར་བདག་དང་རྒྱབ་འགལ་དུ་སོང་ན། ");
INSERT INTO bodn_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","བདག་ཀྱང་ཁྱོད་ལ་ཁྲོ་ཞིང་རྒྱབ་འགལ་དུ་འགྲོ་བར་བྱ་སྟེ། ཁྱོད་རྣམས་ཀྱི་སྡིག་པའི་ཕྱིར་དུ་ལྡབ་བདུན་གྱིས་ཁྱོད་ཅག་ལ་ཆད་པ་གཅོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ཁྱོད་རྣམས་ཀྱིས་རང་གི་བུ་རྣམས་ཀྱི་ཤ་བཟའ་བ་དང་། རང་གི་བུ་མོ་རྣམས་ཀྱི་ཤ་ཡང་བཟའ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","བདག་གིས་ཁྱོད་རྣམས་ཀྱི་མཐོ་གླིང་རྣམས་བརླག་པ་དང་། སྤོས་ཀྱི་མཆོད་ཁྲི་རྣམས་བཤིགས་ནས། ཁྱོད་ཀྱི་ལྷ་རྟེན་རྣམས་ཀྱི་ཞིག་རོའི་སྟེང་དུ་ཁྱོད་རང་གི་བེམ་པོ་རྣམས་གཡུག་པར་བྱེད་ཅིང་། ངའི་སེམས་སུའང་ཁྱོད་རྣམས་ལ་སྡང་བར་གྱུར་ནས། ");
INSERT INTO bodn_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ཁྱོད་ཅག་གི་གྲོང་ཁྱེར་རྣམས་ཞིག་རལ་དུ་འགྱུར་བ་དང་། ཁྱོད་ཚོའི་གནས་མཆོག་རྣམས་སྟོང་པར་བྱེད་ཅིང་། ཁྱོད་ཚོའི་དྲི་བསུང་ཞིམ་པོ་ལའང་བདག་གིས་སྣོམ་པར་མི་བྱ། ");
INSERT INTO bodn_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","བདག་གིས་ཡུལ་འདི་སྟོང་པར་བྱེད་ཅིང་། ཐ་ན་ཡུལ་འདི་བཙན་འཛིན་བྱེད་མཁན་དགྲ་བོ་རྣམས་ཀྱང་ཧ་ལས་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","བདག་གིས་ཁྱོད་ཅག་ནི་མི་རིགས་སོ་སོའི་ཁྲོད་དུ་གཏོར་བ་དང་། རལ་གྲི་བཏོན་ནས་ཁྱོད་རྣམས་འདེད་པར་འགྱུར་ལ། ཁྱོད་ཅག་གི་ཡུལ་ནི་སྟོང་པར་འགྱུར་བ་དང་། ཁྱོད་ཅག་གི་གྲོང་ཁྱེར་རྣམས་ཞིག་རལ་དུ་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ཁྱོད་རྣམས་དགྲ་བོའི་ཡུལ་དུ་གནས་པའི་དུས་སུ། ཁྱོད་ཅག་གི་ཡུལ་ནི་སྟོང་པར་ལུས་པའི་ཉིན་མོ་ནས་ཡང་བསྐྱར་ངལ་གསོ་འཐོབ་པར་འགྱུར་ཞིང་། དེ་ནས་ཡུལ་དེར་ངལ་གསོ་འཐོབ་ཅིང་ཡང་བསྐྱར་ངལ་གསོ་བའི་ཉིན་མོ་རོལ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","སྟོང་པར་ལུས་པའི་ཉིན་མོ་ཀུན་ལ་ཡུལ་དེས་ངལ་གསོ་བར་འགྱུར་ཞིང་། དེ་ནི་ཁྱོད་རྣམས་དེར་སྡོད་པའི་དུས་སུ་ཁྱོད་ཀྱིས་ངལ་གསོ་བའི་ཉིན་མོར་ངལ་མ་གསོས་པས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ཁྱོད་རྣམས་ལས་ཤུལ་དུ་ལུས་པ་རྣམས་ལ་མཚོན་ན། བདག་གིས་དགྲ་བོ་རྣམས་ཀྱི་ཡུལ་དུ་དེ་དག་གི་སེམས་སུ་འཇིགས་སྣང་བསྐྱེད་ཅིང་། ཐ་ན་རླུང་གིས་དེད་པའི་ལོ་མའི་ཤག་སྒྲ་ཡིས་ཀྱང་དེ་རྣམས་འབྲོ་བར་བྱེད། ཁོ་ཚོ་རལ་གྲིའི་ཁ་ནས་འབྲོ་བ་ལྟར་འབྲོ་ཞིང་། ར་མདར་རྒྱུག་མཁན་མེད་ནའང་འགྱེལ་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ར་མདར་རྒྱུག་མཁན་མེད་ནའང་དེ་དག་གིས་ཕན་ཚུན་བསྒྱེལ་ཞིང་། རལ་གྲིའི་ཁ་ནས་འབྲོ་བ་དང་མཚུངས། ཁྱོད་རྣམས་ནི་དགྲ་བོའི་མདུན་དུ་ཚུགས་མི་ཐུབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ཁྱོད་ཅག་མི་རྣམས་ལས་རྩ་མེད་དུ་འགྲོ་ཞིང་། དགྲ་བོའི་ཡུལ་དེས་ཁྱོད་རྣམས་ཁྱུར་མིད་གཏོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ཁྱོད་ཅག་ལས་ཤུལ་དུ་ལུས་པ་རྣམས་ནི་རང་གི་ནག་ཉེས་ཀྱི་རྐྱེན་གྱིས་དགྲ་བོ་རྣམས་ཀྱི་ཡུལ་དུ་འཕུང་བར་འགྱུར་བ་དང་། མེས་པོ་རྣམས་ཀྱི་ནག་ཉེས་ཀྱི་རྐྱེན་གྱིས་ཀྱང་འཕུང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","དེ་དག་གིས་བདག་ལ་ཡིད་ཆེས་མི་བྱེད་པར་བདག་དང་རྒྱབ་འགལ་བྱས་པས། བདག་ཀྱང་ཁོ་ཚོ་དང་རྒྱབ་འགལ་དུ་འགྲོ་ཞིང་། ཁོ་ཚོ་དགྲ་བོའི་ཡུལ་དུ་འཁྲིད་པ་ཡིན། དེའི་དུས་སུ་ཁོ་རྣམས་ཀྱི་མཚན་སྐྱི་བཅད་མེད་པ་ལྟ་བུའི་སེམས་ཁེངས་སྐྱུང་བྱས་ནས། ཁོ་ཚོས་རང་གི་ནག་ཉེས་ཀྱི་ཆད་པ་ཁུར་ཏེ། རང་རང་གི་ནག་ཉེས་དང་མེས་པོ་རྣམས་ཀྱི་ནག་ཉེས་ཁས་བླངས་ན། ");
INSERT INTO bodn_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","བདག་གིས་ང་དང་ཡ་ཀོབ་བར་གྱི་ཁ་ཆད་དང་། ང་དང་ཨི་སཱག་བར་གྱི་ཁ་ཆད་དང་། ང་དང་ཨབ་ར་ཧམ་བར་གྱི་ཁ་ཆད་བཅས་དྲན་པར་བྱེད་ཅིང་། ཡུལ་འདི་ཡང་དྲན་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","དེ་དག་གིས་ཡུལ་ཁམས་ཡོངས་སུ་དོར་བ་དང་། ཁོ་རྣམས་མེད་པས་སྟོང་པར་ལུས་པའི་དུས་སུ། ཡུལ་དེར་ཡང་བསྐྱར་ངལ་གསོ་འཐོབ་དགོས། ཁོ་ཚོས་ནག་ཉེས་ཀྱི་ཆད་པ་དང་དུ་བླངས་པ་སྟེ། དེ་དག་གིས་བདག་གི་སྲོལ་ཡིག་སྤངས་ཤིང་། སེམས་སུ་བདག་གི་སྒྲིག་ཁྲིམས་རྣམས་ལ་སུན་སྣང་སྐྱེས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","འོན་ཀྱང་དེ་ལྟར་ཡིན་ནའང་། དེ་དག་དགྲ་བོ་རྣམས་ཀྱི་ཡུལ་དུ་ཡོད་པའི་སྐབས་སུ། བདག་གིས་ཁོ་ཚོ་མ་དོར་ཞིང་། ཁོ་རྣམས་ལ་སྡང་ནས་རྩ་མེད་དུའང་མ་བཏང་ལ། བདག་དང་ཁོ་རྣམས་བར་གྱི་ཁ་ཆད་ཀྱང་འདོར་བར་མ་བྱས། ཅི་ལ་ཞེ་ན། བདག་ནི་དེ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","བདག་ནི་དེ་དག་གི་དཀོན་མཆོག་ཡིན་པའི་ཆེད་དུ་བདག་གིས་མི་རིགས་རྣམས་ཀྱི་མཐོང་ལམ་དུ། དེ་དག་གི་མེས་པོ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་འོངས་ནས། ངས་དེ་དག་གི་མེས་པོ་རྣམས་ཀྱི་ཁ་ཆད་དྲན་པར་བྱའོ། །བདག་ནི་ཡ་ཝཱེ་ཡིན་ཞེས་པའོ་གསུངས་སོ།། ");
INSERT INTO bodn_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","དེ་དག་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱ་རུ་མོ་ཤེ་བརྒྱུད་དེ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བཙུགས་པའི་སྒྲིག་ཁྲིམས་དང་། སྲོལ་ཡིག བཀའ་ཁྲིམས་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་སྐད་སྒོས་ཤིག སུ་ཞིག་གིས་མི་ཞིག་གི་རིན་ཐང་ལྟར་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་བཅའ་ཁྱད་པར་བ་ཞིག་འབུལ་ན། ");
INSERT INTO bodn_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ཁྱོད་ཀྱི་ཚོད་རྩིས་ནི། སྐྱེས་པ་ལོ་ཉི་ཤུ་ནས་དྲུག་ཅུའི་བར་དུ་གནས་མཆོག་གི་སྲང་བཞིན་དུ་དངུལ་སྲང་ལྔ་བཅུ་རུ་བརྩི་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","གལ་སྲིད་བུད་མེད་ཡིན་ན། དངུལ་སྲང་སུམ་ཅུ་རུ་རྩིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ལོ་ལྔ་ནས་ཉི་ཤུའི་བར་གྱི་ཕོ་ནི་དངུལ་སྲང་ཉི་ཤུ་དང་། མོ་ནི་དངུལ་སྲང་བཅུ་རུ་བརྩི་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ཟླ་བ་གཅིག་ནས་ལོ་ལྔ་བར་གྱི་བུ་ནི་དངུལ་སྲང་ལྔ་དང་བུ་མོ་ནི་དངུལ་སྲང་གསུམ་དུ་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ལོ་དྲུག་ཅུའི་ཡན་གྱི་སྐྱེས་པ་ཡིན་ན་དངུལ་སྲང་བཅོ་ལྔ་དང་། བུད་མེད་ཡིན་ན་དངུལ་སྲང་བཅུ་རུ་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","གལ་སྲིད་ཁོ་རང་དབུལ་དྲགས་ཏེ་ཁྱོད་ཀྱི་ཚོད་རྩིས་བཞིན་དུ་བསྒྲུབ་མི་ནུས་ན། མཆོད་དཔོན་གྱི་མདུན་དུ་ཁྲིད་དེ། མཆོད་དཔོན་གྱིས་ཁོ་ལ་ཚོད་རྩིས་བྱེད་ཅིང་། དམ་བཅའ་འཇོག་མཁན་ལག་གི་རྒྱུ་སྟོབས་བཞིན་དུ་མཆོད་དཔོན་གྱིས་ཚོད་རྩིས་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བར་དམ་བཅས་པའི་མཆོད་པ་ནི་ཕྱུགས་ཟོག་ཡིན་ན། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གང་ཞིག་ཕུལ་བ་ཐམས་ཅད་དམ་པ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","དེ་ནི་བརྗེ་མི་རུང་ལ། གཞན་ཞིག་གིས་ཚབ་ཀྱང་བྱེད་མི་རུང་ཞིང་། བཟང་པོའི་ཚབ་ཏུ་ངན་པའམ། ངན་པའི་ཚབ་ཏུ་བཟང་པོ་གང་ཡང་བརྗེ་མི་རུང་། གལ་སྲིད་ཅིས་ཀྱང་ཕྱུགས་ཟོག་གིས་ཕྱུགས་ཟོག་གཞན་པའི་ཚབ་བྱེད་དགོས་ན། སྔར་དམ་བཅས་པ་དང་ཚབ་ཏུ་ཕུལ་བ་གཉིས་ཀ་དམ་པ་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","གལ་སྲིད་ཕྱུགས་ཟོག་དེ་ནི་མི་གཙང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པར་འབུལ་མི་རུང་བ་ཞིག་ཡིན་ན། ཕྱུགས་ཟོག་དེ་མཆོད་དཔོན་གྱི་མདུན་དུ་འཁྲིད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","མཆོད་དཔོན་གྱིས་ཕྱུགས་ཟོག་གི་བཟང་ངན་ལ་བལྟས་ནས་རིན་གོང་ཚོད་རྩིས་བྱེད་དགོས་ཤིང་། མཆོད་དཔོན་གྱིས་ཚོད་རྩིས་བྱས་པ་དེ་ཁྱོད་ཀྱི་ཚོད་རྩིས་རིན་གོང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","གལ་སྲིད་དམ་བཅའ་འཇོག་མཁན་གྱིས་ཅིས་ཀྱང་དེ་བླུ་བར་འདོད་ན། ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་གོང་སྟེང་ལྔ་ཆ་གཅིག་སྣོན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","གལ་སྲིད་སུ་ཞིག་གིས་རང་གི་ཁང་པ་དམ་པར་བརྩིས་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པར་འབུལ་ན། མཆོད་དཔོན་གྱིས་རིན་གོང་ཚོད་རྩིས་བྱེད་དགོས་ཤིང་། ཁང་པ་བཟང་ངན་གང་ཡིན་ཡང་མཆོད་དཔོན་གྱིས་ཚོད་རྩིས་བྱས་པ་བཞིན་དུ་རིན་གོང་དེ་ཚད་གཞི་རུ་འཛིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ཁང་པ་དམ་པར་རྩི་མཁན་གྱིས་རང་གི་ཁང་པ་བླུ་ན། ཁྱོད་ཀྱིས་རིན་རྩིས་པའི་སྟེང་ལ་ལྔ་ཆ་གཅིག་བསྣན་ནས་སྤྲད་ན་ཁང་པ་ད་གཟོད་མི་དེ་ལ་དབང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","གལ་སྲིད་མི་ཞིག་གིས་རང་གིས་རྒྱུན་འཛིན་བྱས་པའི་ས་ཞིང་ལས་ཁག་ཅིག་དམ་པར་བརྩིས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པར་ཕུལ་ན། ས་ཞིང་དེའི་ས་བོན་འདེབས་ཚད་བཞིན་དུ་ཚོད་རྩིས་བྱེད་དགོས་པ་འདི་ལྟ་སྟེ། ནས་ཁལ་ གཅིག་གི་ས་བོན་འདེབས་ཐུབ་པའི་ས་ཞིང་ནི་དངུལ་སྲང་ལྔ་བཅུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ཁོས་དགའ་སྟོན་གྱི་ལོ་ནས་བཟུང་སྟེ། རང་གི་ས་ཞིང་ཞིག་དམ་པར་བརྩིས་ན་ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་གོང་ཚད་གཞིར་འཛིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ཅི་སྟེ། ཁོས་དགའ་སྟོན་གྱི་ལོ་ཡི་རྗེས་ནས་ས་ཞིང་དམ་པར་བརྩིས་ན། མཆོད་དཔོན་གྱིས་དུས་དེ་ནས་བཟུང་དགའ་སྟོན་གྱི་ལོ་རྗེས་མའི་བར་གྱི་ལོ་ལྷག་མའི་ལོ་གྲངས་བཞིན་དུ་འདེད་རྩིས་བྱས་ཏེ། ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་གོང་ལས་འཐེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ས་ཞིང་དམ་པར་རྩི་མཁན་གྱིས་དེ་བླུ་བར་འདོད་ན། ཁྱོད་ཀྱིས་རིན་རྩིས་པའི་སྟེང་ལ་ལྔ་ཆ་གཅིག་བསྣན་ཏེ་སྤྲད་ན་ས་ཞིང་ད་གཟོད་ཁོ་ལ་དབང་བར་བྱས་ཆོག ");
INSERT INTO bodn_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","འོན་ཀྱང་མི་དེས་ས་ཞིང་རང་གིས་མ་བླུས་པའམ་མི་གཞན་ཞིག་ལ་བཙོངས་ན། རྗེས་སུ་དེ་བླུ་བར་མི་ནུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","དགའ་སྟོན་གྱི་ལོར་ས་ཞིང་དེ་ཉོ་བདག་གི་ལག་ནས་ཕྱིར་ལེན་དུས། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པ་ཡིན་པས། ཡོངས་སུ་རྫོགས་པར་ཕུལ་བའི་ས་ཞིང་དང་འདྲ་བར་མཆོད་དཔོན་ལ་དབང་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པར་ཕུལ་བའི་ས་ཞིང་ནི་རང་ས་མ་ཡིན་པར་གཞན་ནས་ཉོས་པ་ཡིན་ན། ");
INSERT INTO bodn_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","མཆོད་དཔོན་གྱིས་ཁྱོད་ཀྱི་ཚོད་རྩིས་རིན་གོང་བཞིན་དུ། དགའ་སྟོན་གྱི་ལོ་ཡི་བར་དུ་འདེད་རྩིས་བྱེད་པ་དང་། ཉིན་མོ་དེ་ལ་མི་དེས་ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་འབབ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","དགའ་སྟོན་གྱི་ལོར་ས་ཞིང་དེ་འཚོང་བདག་སྟེ་ས་ཞིང་དེ་རྒྱུན་འཛིན་བྱེད་མཁན་ལ་ཕྱིར་སློག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ཁྱོད་ཀྱིས་ཚོད་རྩིས་བྱས་པའི་རིན་གོང་ཐམས་ཅད་ནི་གནས་མཆོག་གི་སྲང་བཞིན་དུ་ཡིན་དགོས་ཏེ། དངུལ་སྲང་གཅིག་ལ་གཱེ་ར་ཉི་ཤུ་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","སྐྱེས་འགོ་སྟེ་ཕྱུགས་ཟོག་ཁྲོད་ཀྱི་སྐྱེས་འགོ་རྣམས་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཡིན་པས། མི་སུས་ཀྱང་དེ་ཡང་བསྐྱར་དམ་པར་རྩི་མི་རུང་ལ། བ་གླང་ངམ་ལུག་གང་ཡིན་ཡང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ཅི་སྟེ། ཕྱུགས་ཟོག་སྐྱེས་འགོ་ནི་མི་གཙང་བ་ཡིན་ན། ཚོད་རྩིས་བྱས་པའི་རིན་གོང་དང་དེའི་ཁར་ལྔ་ཆ་གཅིག་བསྣན་ནས་དེ་བླུ་དགོས། བླུ་བ་མིན་ན་ཁྱོད་ཀྱི་ཚོད་རྩིས་ཀྱི་རིན་བཞིན་དུ་དེ་བཙོང་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","འོན་ཀྱང་། ཡོངས་སུ་རྫོགས་པར་ཕུལ་བ་རྣམས་ཏེ། མི་ཡིས་རང་ལ་གང་ཡོད་པ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏན་དུ་འབུལ་འོས་པ་ནི། མིའམ་ཕྱུགས་ཟོག་གམ། ཁོ་ལ་དབང་བའི་ས་ཞིང་བཅས་གང་ཡིན་ཡང་བཙོང་བའམ་ཉོ་བར་མི་རུང་སྟེ། གཏན་དུ་འབུལ་འོས་པ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཀུན་ལས་དམ་པ་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","མི་རྣམས་ལས་གཏན་དུ་འབུལ་འོས་པ་ཐམས་ཅད་ནི་བླུ་མི་རུང་བར་སྲོག་གཅོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ས་གཞིའི་སྟེང་གི་ཡོད་ཚད་དེ་ས་བོན་དང་སྡོང་མགོའི་ཤིང་ཏོག་གང་ཡིན་ཡང་། དེའི་བཅུ་ཆ་གཅིག་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཡིན་ལ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","སུ་ཞིག་གིས་བཅུ་ཆ་གཅིག་དེ་བླུ་བར་འདོད་ན། གཞན་པའི་ལྔ་ཆ་གཅིག་སྣོན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","བ་གླང་གི་ཁྱུ་དང་ར་ལུག་གི་ཁྱུ་ཐམས་ཅད་ཀྱི་བཅུ་ཆ་གཅིག་སྟེ། ཕྱུགས་རྫིའི་དབྱུག་པའི་འོག་ནས་འགྲོ་བ་ཐམས་ཅད་ལས་ཕྱུགས་བཅུ་པ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དབང་ཞིང་དམ་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","དེའི་བཟང་ངན་གྱི་དབྱེ་བ་འགེར་མི་རུང་ལ། བརྗེ་ཡང་མི་རུང་སྟེ། གལ་སྲིད་ཅིས་ཀྱང་བརྗེ་དགོས་ན། དེའི་ཚབ་བྱེད་དང་འབུལ་འོས་པའི་ཕྱུགས་ཟོག་གཉིས་ཀ་དམ་པ་ཡིན་པས་བླུ་མི་རུང་ཞེས་པའོ་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","དེ་དག་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱ་རུ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཆེད་དུ་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་རྣམས་ཡིན་ནོ།། །། ");
INSERT INTO bodn_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","དེ་ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་རྗེས་ཀྱི་ལོ་གཉིས་པའི་ཟླ་བ་གཉིས་པའི་ཚེས་དང་པོ་ལ། སི་ནཱ་དབེན་སྟོང་དུ་མཇལ་འཕྲད་གུར་མཆོག་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཐམས་ཅད་ནི་དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་མི་གྲངས་ལེན་དགོས་པ་སྟེ། སྐྱེས་པ་ཐམས་ཅད་མི་གྲངས་བཞིན་ཐོ་བརྒྱག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ཡེས་ར་ཨེལ་མི་རིགས་ཀྱི་ཁྲོད་ནས་སྐྱེས་པ་ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་ཟིན་པ་དང་། དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ནི་ཁྱོད་དང་ཨ་རོན་གཉིས་ཀྱིས་ཁོ་ཚོའི་དམག་ཚོགས་བཞིན་དུ་རྩིས་ལེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ཚོ་པ་རེ་ནས་ཁྱོད་རྣམས་ལ་རོགས་བྱེད་མཁན་མི་གཅིག་རེ་ཡོད་པ་དང་། དེ་དག་རེ་རེ་རང་གི་ཕ་ཁྱིམ་གྱི་འགོ་དཔོན་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ཁྱོད་རྣམས་ལ་རོགས་བྱེད་མཁན་རྣམས་ཀྱི་མིང་ནི་འདི་ལྟ་སྟེ། རུ་བེན་ཚོ་པ་ནས་ཤེ་དེ་ཨུར་གྱི་བུ་ཨེ་ལི་ཚུར་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","སི་མུ་ཨོན་ཚོ་པ་ནས་ཙུ་རེ་ཤད་དཱ་ཨིའི་བུ་ཤེ་ལུ་མེ་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ཡ་ཧུ་དཱ་ཚོ་པ་ནས་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་ནཱ་སོན་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ཡེས་སི་ཀཱར་ཚོ་པ་ནས་ཙུ་ཨར་གྱི་བུ་ནེ་ཐན་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ཟེ་བུ་ལུན་ཚོ་པ་ནས་ཧེ་ལོན་གྱི་བུ་ཨེ་ལི་ཨབ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ཡོ་སེབ་ཀྱི་བུ་རྒྱུད་ཁྲོད་དུ། ཨེ་ཕཱར་ཡིམ་ཚོ་པ་ནས་ཨམ་མེ་ཧུད་ཀྱི་བུ་ཨེ་ལི་ཤ་མཱ་དང་། མཱ་ན་ཤེ་ཚོ་པ་ནས་ཕེ་དཱ་ཚུར་གྱི་བུ་གམ་ལི་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","པེན་ཡཱ་མེན་ཚོ་པ་ནས་གིད་ཨོ་ནཱའི་བུ་ཨ་བི་ཏན་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","དཱན་ཚོ་པ་ནས་ཨམ་མེ་ཤད་ད་ཨི་ཡི་བུ་ཨ་ཧི་ཨེ་ཟེར་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ཨ་ཤེར་ཚོ་པ་ནས་ཨོག་རན་གྱི་བུ་ཕཱ་གེ་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","གཱ་རྡུ་ཚོ་པ་ནས་དི་ཨོ་ཨེལ་གྱི་བུ་ཨེལ་ཡཱ་སབ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ནཱབ་ཐ་ལི་ཚོ་པ་ནས་ཨེ་ནན་གྱི་བུ་ཨ་ཧི་རཱ་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","དེ་དག་ནི་མི་ཚོགས་ལས་བདམས་པ་ཡིན་ཞིང་། མེས་པོའི་ཚོ་པ་རྣམས་ཀྱི་འགོ་དཔོན་དང་། ཡེས་ར་ཨེལ་གྱི་སྟོང་དཔོན་རྣམས་ཡིན་ནོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་མིང་བཏོན་པའི་མི་དེ་དག་ཁྲིད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ཟླ་བ་གཉིས་པའི་ཚེས་དང་པོར་མི་ཚོགས་ཐམས་ཅད་བསྡུས་ཤིང་། དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་ཟིན་པ་རྣམས་མི་གྲངས་ལྟར་ཐོ་བརྒྱབ་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་བསྩལ་པ་བཞིན་དུ། ཁོང་གིས་སི་ནཱ་དབེན་སྟོང་ནས་དེ་དག་གི་རྩིས་བླངས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ཡེས་ར་ཨེལ་གྱི་བུ་སྐྱེས་འགོ་རུ་བེན་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་དང་མི་གྲངས་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","རུ་བེན་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་དྲུག་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","སི་མུ་ཨོན་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་དང་མི་གྲངས་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","སི་མུ་ཨོན་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་དགུ་སྟོང་སུམ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","གཱ་རྡུ་ཡི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","གཱ་རྡུ་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ལྔ་སྟོང་དྲུག་བརྒྱ་ལྔ་བཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ཡ་ཧུ་དཱའི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ཡ་ཧུ་དཱ་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བདུན་ཁྲི་བཞི་སྟོང་དྲུག་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ཡེས་སི་ཀཱར་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ཡེས་སི་ཀཱར་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་བཞི་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ཟེ་བུ་ལུན་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ཟེ་བུ་ལུན་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་བདུན་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ཡོ་སེབ་ཀྱི་བུ་རྣམས་ཏེ། ཨེ་ཕཱར་ཡིམ་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ཨེ་ཕཱར་ཡིམ་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","མཱ་ན་ཤེའི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","མཱ་ན་ཤེ་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་སུམ་ཁྲི་ཉིས་སྟོང་ཉིས་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","པེན་ཡཱ་མེན་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","པེན་ཡཱ་མེན་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་སུམ་ཁྲི་ལྔ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","དཱན་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","དཱན་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་དྲུག་ཁྲི་ཉིས་སྟོང་བདུན་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ཨ་ཤེར་གྱི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ཨ་ཤེར་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ཆིག་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ནཱབ་ཐ་ལི་ཡི་བུ་རྒྱུད་དག་གི་བུ་རབས་ཚ་རྒྱུད་ལས། རུས་རྒྱུད་དང་ཕ་ཁྱིམ། སྐྱེས་པ་རེ་རེའི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ནཱབ་ཐ་ལི་ཚོ་པ་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་སུམ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","དེ་ནི་མོ་ཤེ་དང་ཨ་རོན། ཡེས་ར་ཨེལ་གྱི་འགོ་དཔོན་བཅུ་གཉིས་ཏེ་ཕ་ཁྱིམ་རེའི་མི་རེ་བཅས་ཀྱིས་རྩིས་བླངས་པའི་མི་གྲངས་ཡིན་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ཡེས་ར་ཨེལ་གྱི་ཁྲོད་ཕ་ཁྱིམ་བཞིན་དུ། ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་དམག་འཐབ་ལ་ཞུགས་ནུས་པའི་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཐོ་བརྒྱབ་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་དྲུག་འབུམ་སུམ་སྟོང་ལྔ་བརྒྱ་ལྔ་བཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","འོན་ཀྱང་། ལེ་ཝི་པ་རྣམས་ཁོ་ཚོའི་ཁྱིམ་རྒྱུད་ཀྱི་ཚོ་པ་བཞིན་དེ་དག་གི་ཁྲོད་དུ་མ་བརྩིས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ཅི་ལ་ཟེར་ན། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","ལེ་ཝིའི་ཚོ་པ་འབའ་ཞིག་ཁྱོད་ཀྱིས་རྩིས་ལེན་མི་རུང་ལ། དེ་དག་གི་བསྡོམས་གྲངས་ཀྱང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་བགྲང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","འོན་ཀྱང་། དཔང་པོའི་གུར་མཆོག་དང་། དེའི་ཡོ་བྱད་ཐམས་ཅད་དང་། དེ་ལ་གཏོགས་པ་ཀུན་ལེ་ཝི་པ་རྣམས་ལ་བདག་གཉེར་བྱེད་དུ་ཆུག དེ་ཚོས་གུར་མཆོག་དང་ཡོ་བྱད་ཐམས་ཅད་འཁུར་ཞིང་དེ་ལ་ཞབས་ཏོག་སྒྲུབ་པ་དང་། གུར་མཆོག་གི་མཐའ་འཁོར་དུ་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","གུར་མཆོག་སྤོ་བའི་དུས་སུ་ལེ་ཝི་པ་རྣམས་ཀྱིས་དེ་མར་ཕབ་པ་དང་། གུར་མཆོག་ཕུབ་པའི་དུས་སུ། ལེ་ཝི་པ་རྣམས་ཀྱིས་དེ་ཕུབ་དགོས། གལ་ཏེ་མི་གཞན་སུ་ཞིག་གུར་མཆོག་དང་ཉེ་བར་འོངས་ན་དེ་གསོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་རང་རང་གི་སྒར་ཁ་དང་རང་རང་གི་རུ་དར་བཞིན་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","འོན་ཀྱང་། དཀོན་མཆོག་ཁོང་ཉིད་ཡེས་ར་ཨེལ་གྱི་མི་ཚོགས་ལ་ཐུགས་མི་ཁྲོ་བའི་ཕྱིར་དུ། ལེ་ཝི་པ་རྣམས་ཀྱིས་དཔང་པོའི་གུར་མཆོག་གི་མཐའ་འཁོར་དུ་སྒར་འདེབས་དགོས་པ་དང་། དེ་རྣམས་ཀྱིས་དཔང་པོའི་གུར་མཆོག་སྲུང་བའི་འགན་བསྒྲུབ་དགོས་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་བཞིན་དུ་བསྒྲུབས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཅི་ལྟར་གནང་བ་བཞིན་ཁོ་རྣམས་ཀྱིས་དེ་ལྟར་བསྒྲུབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་རང་རང་གི་རུ་དར་དང་རང་རང་གི་ཕ་ཁྱིམ་གྱི་དར་ཆེན་འོག་ཏུ་སྒར་འདེབས་དགོས། དེ་རྣམས་ཀྱིས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱོགས་བཞི་རུ་རྒྱང་ཐག་ཅུང་རིང་བའི་གནས་སུ་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ཤར་ཕྱོགས་སྐྱ་རེངས་ཤར་བའི་གནས་སུ་དམག་ཚོགས་བཞིན་དུ་སྒར་འདེབས་མཁན་ནི་ཡ་ཧུ་དཱའི་སྒར་ཁའི་དར་ཆེན་ཡིན་ལ། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་ནཱ་སོན་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བདུན་ཁྲི་བཞི་སྟོང་དྲུག་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","དེའི་གཞོགས་སུ་སྒར་འདེབས་མཁན་ནི་ཡེས་སི་ཀཱར་ཚོ་པ་ཡིན་པ་དང་། ཡེས་སི་ཀཱར་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཙུ་ཨར་གྱི་བུ་ནེ་ཐན་ཨེལ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་བཞི་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","དེ་ནས་ཟེ་བུ་ལུན་གྱི་ཚོ་པ་ཡོད་པ་དང་། ཟེ་བུ་ལུན་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཧེ་ལོན་གྱི་བུ་ཨེ་ལི་ཨབ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་བདུན་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ཡ་ཧུ་དཱའི་སྒར་ནས་དམག་ཚོགས་བཞིན་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ཆིག་འབུམ་བརྒྱད་ཁྲི་དྲུག་སྟོང་བཞི་བརྒྱ་ཡིན་ལ། དེ་དག་སྔོན་དུ་ལམ་ལ་ཆས་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ལྷོ་ཕྱོགས་སུ་དམག་ཚོགས་བཞིན་དུ་རུ་བེན་གྱི་སྒར་ཁའི་དར་ཆེན་ཡོད་པ་དང་། རུ་བེན་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཤེ་དེ་ཨུར་གྱི་བུ་ཨེ་ལི་ཚུར་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་དྲུག་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","དེའི་གཞོགས་སུ་སྒར་འདེབས་མཁན་ནི་སི་མུ་ཨོན་ཚོ་པ་ཡིན་ལ། སི་མུ་ཨོན་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཙུ་རེ་ཤད་དཱ་ཨིའི་བུ་ཤེ་ལུ་མེ་ཨེལ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་དགུ་སྟོང་སུམ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","དེ་ནས་གཱ་རྡུ་ཚོ་པ་ཡོད་པ་དང་། གཱ་རྡུ་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་དི་ཨོ་ཨེལ་ གྱི་བུ་ཨེལ་ཡཱ་སབ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ལྔ་སྟོང་དྲུག་བརྒྱ་ལྔ་བཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","རུ་བེན་གྱི་སྒར་ནས་དམག་ཚོགས་བཞིན་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ཆིག་འབུམ་ལྔ་ཁྲི་ཆིག་སྟོང་བཞི་བརྒྱ་ལྔ་བཅུ་ཡིན་ལ། དེ་དག་གྲལ་གཉིས་པ་བྱས་ནས་ལམ་དུ་ཆས་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","དེ་ནས་མཇལ་འཕྲད་གུར་མཆོག་དང་ལེ་ཝི་པ་རྣམས་ཀྱི་སྒར་དེ་སྒར་རྣམས་ཀྱི་དཀྱིལ་ནས་མདུན་དུ་བསྐྱོད་དགོས། དེ་དག་གིས་ཇི་ལྟར་སྒར་བཏབ་ན་དེ་ལྟར་ལམ་ལ་ཆས་ཏེ་མདུན་དུ་བསྐྱོད་པ་དང་། སོ་སོའི་རང་གནས་སུ་རང་རང་གི་དར་ཆེན་འོག་ཏུ་ཡོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ནུབ་ཕྱོགས་སུ་དམག་ཚོགས་བཞིན་དུ་ཨེ་ཕཱར་ཡིམ་གྱི་སྒར་ཁའི་དར་ཆེན་ཡོད་པ་དང་། ཨེ་ཕཱར་ཡིམ་པ་རྣམས་ཀྱི་འགོ་དཔོན་ཨམ་མེ་ཧུད་ཀྱི་བུ་ཨེ་ལི་ཤ་མཱ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","དེའི་གཞོགས་སུ་མཱ་ན་ཤེ་ཚོ་པ་ཡོད་པ་དང་། མཱ་ན་ཤེ་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཕེ་དཱ་ཚུར་གྱི་བུ་གམ་ལི་ཨེལ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་སུམ་ཁྲི་ཉིས་སྟོང་ཉིས་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","དེ་ནས་པེན་ཡཱ་མེན་ཚོ་པ་ཡོད་པ་དང་། པེན་ཡཱ་མེན་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་གིད་ཨོ་ནཱའི་བུ་ཨ་བི་ཏན་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་སུམ་ཁྲི་ལྔ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ཨེ་ཕཱར་ཡིམ་གྱི་སྒར་ནས་དམག་ཚོགས་བཞིན་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ཆིག་འབུམ་བརྒྱད་སྟོང་དང་བརྒྱ་ཡིན་ལ། དེ་དག་གྲལ་གསུམ་པ་བྱས་ནས་ལམ་དུ་ཆས་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","བྱང་ཕྱོགས་སུ་དམག་ཚོགས་བཞིན་དུ་དཱན་གྱི་སྒར་ཁའི་དར་ཆེན་ཡོད་པ་དང་། དཱན་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཨམ་མེ་ཤད་ད་ཨི་ཡི་བུ་ཨ་ཧི་ཨེ་ཟེར་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་དྲུག་ཁྲི་ཉིས་སྟོང་བདུན་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","དེའི་གཞོགས་སུ་སྒར་འདེབས་མཁན་ནི་ཨ་ཤེར་ཚོ་པ་ཡིན་པ་དང་། ཨ་ཤེར་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཨོག་རན་གྱི་བུ་ཕཱ་གེ་ཨེལ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་བཞི་ཁྲི་ཆིག་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","དེ་ནས་ནཱབ་ཐ་ལིའི་ཚོ་པ་ཡོད་པ་དང་། ནཱབ་ཐ་ལི་པ་རྣམས་ཀྱི་འགོ་དཔོན་ནི་ཨེ་ནན་གྱི་བུ་ཨ་ཧི་རཱ་ཡིན་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","དེའི་དམག་ཚོགས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ལྔ་ཁྲི་སུམ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","དཱན་གྱི་སྒར་ནས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་ཆིག་འབུམ་ལྔ་ཁྲི་བདུན་སྟོང་དྲུག་བརྒྱ་ཡིན། དེ་དག་གིས་དར་ཆེན་བསྒྲེངས་ནས་མཇུག་ཏུ་ལམ་ལ་ཆས་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","དེ་དག་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་རང་རང་གི་ཕ་ཁྱིམ་བཞིན་དུ་རྩིས་བླངས་པའི་མི་གྲངས་ཡིན་པ་དང་། སོ་སོའི་དམག་ཚོགས་བཞིན་སྒར་རྣམས་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ནི་བསྡོམས་པས་དྲུག་འབུམ་སུམ་སྟོང་ལྔ་བརྒྱ་ལྔ་བཅུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","འོན་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་བསྩལ་པ་བཞིན་དུ། ལེ་ཝི་པ་རྣམས་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་མ་བརྩིས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྒོས་པའི་བཀའ་བཞིན་དུ་བྱས་ཤིང་། དེ་དག་གིས་རང་རང་གི་དར་ཆེན་འོག་ཏུ་སྒར་བཏབ་པ་དང་། མི་རེ་རེ་རང་རང་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ་ལམ་ལ་ཆས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་རི་བོ་སི་ནཱ་རུ་མོ་ཤེ་ལ་གསུང་གླེང་མཛད་པའི་དུས་སུ། ཨ་རོན་དང་མོ་ཤེ་གཉིས་ཀྱི་བུ་རབས་ཚ་རྒྱུད་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ཨ་རོན་གྱི་བུ་རྣམས་ཀྱི་མིང་ནི་འདི་ལྟར། བུ་སྐྱེས་འགོ་ནཱ་དབ་དང་། ཨ་བི་ཧུ། ཨེ་ལི་ཨ་ཟར། ཨི་ཐ་མཱར་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","དེ་ནི་ཨ་རོན་གྱི་བུ་རྣམས་ཀྱི་མིང་སྟེ། དེ་དག་ནི་སྣུམ་གྱིས་བྱུགས་པའི་མཆོད་དཔོན་རྣམས་ཡིན་ལ། མོ་ཤེ་ཡིས་དེ་རྣམས་ཞབས་ཏོག་སྒྲུབ་པའི་མཆོད་དཔོན་དུ་བསྐོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ནཱ་དབ་དང་ཨ་བི་ཧུ་གཉིས་ཀྱིས་སི་ནཱ་དབེན་སྟོང་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བཀའ་འཁྲོལ་མེད་པའི་མེ་ཕུལ་བས་དེ་གཉིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཤི་བ་དང་བུ་ཡང་མེད་པའོ། །ཨེ་ལི་ཨ་ཟར་དང་ཨི་ཐ་མཱར་གཉིས་ཀྱིས་ཡབ་ཨ་རོན་གྱི་མདུན་དུ་མཆོད་དཔོན་གྱི་འགན་བླངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","ཁྱོད་ཀྱིས་ལེ་ཝི་ཚོ་པ་ཚུར་ཁྲིད་ནས། དེ་དག་མཆོད་དཔོན་ཨ་རོན་གྱི་མདུན་དུ་ལངས་ནས་དེ་ལ་ཞབས་ཕྱི་བསྒྲུབ་ཏུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","དེ་དག་གིས་ཨ་རོན་དང་ཚོགས་ཡོངས་ཀྱི་ཚབ་ཏུ་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་ལས་འགན་བསྲུང་ཞིང་། གུར་མཆོག་གི་ཕྱིར་ཞབས་ཏོག་བསྒྲུབ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","མཇལ་འཕྲད་གུར་མཆོག་གི་ཡོ་བྱད་ཐམས་ཅད་ལ་བདག་གཉེར་བྱེད་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཚབ་ཏུ་ལས་འགན་བསྲུང་ཞིང་། གུར་མཆོག་གི་ཕྱིར་ཞབས་ཏོག་བསྒྲུབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་སྤྲོད་དགོས། དེ་དག་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་བདམས་ཏེ་ཡོངས་སུ་ཁོ་ལ་སྤྲོད་དགོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་མཆོད་དཔོན་གྱི་འགན་བསྲུང་བར་བཅོལ་དགོས། གལ་ཏེ་ཕྱི་མི་སུ་ཞིག་ཉེ་བར་འོངས་ན་དེ་གསོད་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","ལྟོས་དང་། བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་མངལ་དང་པོ་སྟེ་བུ་སྐྱེས་འགོ་རྣམས་ཀྱི་ཚབ་བྱེད་དུ་ལེ་ཝི་པ་རྣམས་བདམས་པ་ཡིན་པས། ལེ་ཝི་པ་རྣམས་བདག་ལ་དབང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ཅིའི་ཕྱིར་ཞེ་ན། སྐྱེས་འགོ་ཐམས་ཅད་ངའི་ཡིན་ཏེ། བདག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་སྐྱེས་འགོ་ཐམས་ཅད་བསད་པའི་ཉིན་དེར། ཡེས་ར་ཨེལ་གྱི་སྐྱེས་འགོ་རྣམས་ནི་མི་ཕྱུགས་གང་ཡིན་ཡང་ངའི་ཕྱིར་དུ་དམ་པར་བྱས་ཡོད། དེ་རྣམས་བདག་ལ་དབང་དགོས། བདག་ནི་ཡ་ཝཱེ་ཡིན་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་སི་ནཱ་དབེན་སྟོང་དུ་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་སོ་སོའི་ཕ་ཁྱིམ་དང་རུས་རྒྱུད་བཞིན་དུ་རྩིས་ལེན་དགོས་ཤིང་། ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་ཐམས་ཅད་རྩིས་ལེན་དགོས་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེས་གནང་བའི་བཀའ་བཞིན་དུ། ལེ་ཝི་པ་རྣམས་རྩིས་བླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ལེ་ཝིའི་བུ་རྣམས་ཀྱི་མིང་ནི། གེར་ཤོན་དང་། ཀོ་ཧད། མཱ་རཱ་རེའེ་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","གེར་ཤོན་གྱི་བུ་རྣམས་ཀྱི་མིང་ནི་རང་རང་གི་རུས་རྒྱུད་བཞིན་དུ། ལིབ་ནིས་དང་ཤིམ་ཨི་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ཀོ་ཧད་ཀྱི་བུ་རྣམས་ནི་རང་རང་གི་རུས་རྒྱུད་བཞིན་དུ། ཨམ་རམ་དང་། ཡེས་ཧར། ཧེབ་རོན། ཨུ་ཟི་ཨེལ་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","མཱ་རཱ་རེའེ་ཡི་བུ་རྣམས་ནི་རང་རང་གི་རུས་རྒྱུད་བཞིན་དུ། མཱ་ལི་དང་མུ་ཤི་ཡིན། འདི་དག་ནི་ཕ་ཁྱིམ་བཞིན་དུ་ཐམས་ཅད་ལེ་ཝི་པའི་རུས་རྒྱུད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","གེར་ཤོན་ལ་གཏོགས་པ་ནི་ལིབ་ནིས་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་ཤིམ་ཨི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཡིན་ལ། དེ་དག་ནི་གེར་ཤོན་པའི་ཁྱིམ་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་ཐམས་ཅད་རྩིས་བླངས་པའི་གྲངས་ཀ་ནི་བསྡོམས་པས་བདུན་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","གེར་ཤོན་པའི་ཁྱིམ་རྒྱུད་ཀྱིས་གུར་མཆོག་གི་རྒྱབ་སྟེ་ནུབ་ཕྱོགས་སུ་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","གེར་ཤོན་པའི་ཁྱིམ་རྒྱུད་ཀྱི་འགོ་དཔོན་ནི་ལཱ་ཨེལ་གྱི་བུ་ཨེལ་ཡཱ་སབ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་ལས་འགན་ནི་འདི་ལྟ་སྟེ། གུར་མཆོག་དང་དེའི་ཁེབས་རས་དང་། དེའི་ཐོག་ཁེབས་དང་། མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཡོལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ཁྱམས་རའི་ཁྱམས་ཡོལ་རྣམས་དང་། གུར་མཆོག་དང་མཆོད་ཁྲི་བསྐོར་ནས་ཡོད་པའི་ཁྱམས་རའི་སྒོ་ཡོལ་དང་། ཁྱམས་རའི་ནང་དུ་བཀོལ་བའི་ཆོན་ཐག་བཅས་པ་དང་འབྲེལ་བའི་ལས་ཀ་ཐམས་ཅད་བསྒྲུབ་དགོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ཀོ་ཧད་ལ་གཏོགས་པ་ནི་ཨམ་རཱམ་གྱི་ཁྱིམ་རྒྱུད་དང་། ཡེས་ཧར་གྱི་ཁྱིམ་རྒྱུད། ཧེབ་རོན་གྱི་ཁྱིམ་རྒྱུད། ཨུ་ཟི་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་བཅས་ཡོད་ལ། དེ་དག་ནི་ཀོ་ཧད་པའི་ཁྱིམ་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་ཐམས་ཅད་ཀྱི་གྲངས་ཀ་བཞིན་བསྡོམས་པས་བརྒྱད་སྟོང་དྲུག་བརྒྱ་ཡོད་པ་དང་། དེ་དག་གིས་གནས་མཆོག་སྲུང་བའི་ལས་འགན་བསྒྲུབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཀྱིས་གུར་མཆོག་གི་ལྷོ་ཕྱོགས་སུ་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ཀོ་ཧད་ཁྱིམ་རྒྱུད་ཀྱི་འགོ་དཔོན་ནི་ཨུ་ཟི་ཨེལ་གྱི་བུ་ཨེ་ལི་ཙ་ཕན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","དེ་དག་གི་ལས་འགན་ནི། ཤུར་སྒམ་དང་། སྒྲོག་ཙེ། སྒྲོན་སྟེགས། མཆོད་ཁྲི་གཉིས། གནས་མཆོག་ནང་དུ་བཀོལ་བའི་ཡོ་བྱད། ཡོལ་བ། གུར་མཆོག་ནང་དུ་བཀོལ་བ་ཐམས་ཅད་ལ་བདག་གཉེར་བྱེད་དགོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨེ་ལི་ཨ་ཟར་ནི་ལེ་ཝི་པའི་འགོ་དཔོན་རྣམས་ཀྱི་འགོ་དཔོན་ཡིན་པ་དང་། གནས་མཆོག་སྲུང་བའི་ལས་འགན་སྒྲུབ་མཁན་རྣམས་ལ་ལྟ་ཞིབ་བྱེད་དགོས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","མཱ་རཱ་རེའེ་ལ་གཏོགས་པ་ནི་མཱ་ལི་ཡི་ཁྱིམ་རྒྱུད་དང་། མུ་ཤི་ཡི་ཁྱིམ་རྒྱུད་བཅས་ཡོད་ལ། དེ་དག་ནི་མཱ་རཱ་རེའེ་ཡི་ཁྱིམ་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་ཐམས་ཅད་རྩིས་བླངས་པའི་གྲངས་ཀ་ནི་བསྡོམས་པས་དྲུག་སྟོང་ཉིས་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","མཱ་རཱ་རེའེ་ཡི་ཁྱིམ་རྒྱུད་གཉིས་ཀྱི་འགོ་དཔོན་ནི་ཨ་བི་ཧ་ཡིལ་གྱི་བུ་ཙུ་རེ་ཨེལ་ཡིན་ལ། དེ་དག་གིས་གུར་མཆོག་གི་བྱང་ཕྱོགས་སུ་སྒར་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱི་ལས་འགན་ནི་གུར་མཆོག་གི་པང་ལེབ་དང་། འཕྲེད་རྒྱུག ཀ་བ། ཞབས་ར། དེའི་ཡོ་བྱད་ཐམས་ཅད་བསྲུང་བ་དང་། དེ་དང་འབྲེལ་བའི་ལས་ཀ་ཐམས་ཅད་བསྒྲུབ་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ཁྱམས་རའི་མཐའ་འཁོར་གྱི་ཀ་བ་དང་ཞབས་ར། ཕུར་བ། ཆོན་ཐག་བཅས་བསྲུང་རྒྱུ་དེའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","གུར་མཆོག་མདུན་གྱི་ཤར་ཕྱོགས་ཏེ། མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་ཤར་ཕྱོགས་སུ་སྒར་འདེབས་མཁན་རྣམས་ནི། མོ་ཤེ་དང་། ཨ་རོན་དང་། ཨ་རོན་གྱི་བུ་རྣམས་ཡིན། དེ་དག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཚབ་བྱས་ནས་གནས་མཆོག་སྲུང་བའི་འགན་འཁུར་དགོས་པ་དང་། ཕྱི་མི་སུ་ཞིག་ཉེ་བར་འོངས་ན་དེ་གསོད་དགོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ། ལེ་ཝི་པ་ཐམས་ཅད་རྩིས་བླངས་པ་དང་། རང་རང་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་རྣམས་རྩིས་བླངས་པའི་གྲངས་ཀ་ནི་བསྡོམས་པས་ཉིས་ཁྲི་ཉིས་སྟོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཡེས་ར་ཨེལ་པ་རྣམས་ལས་སྐྱེས་འགོ་ཐམས་ཅད་དེ། ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་རྣམས་རྩིས་བླངས་ནས་མིང་ཐོ་འབྲི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","བདག་ནི་ཡ་ཝཱེ་ཡིན་ལ། ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྐྱེས་འགོ་དག་གི་ཚབ་བྱེད་དུ་བདག་ལ་དབང་བར་གྱིས། ལེ་ཝི་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་ཀྱང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་གི་སྐྱེས་འགོ་ཐམས་ཅད་ཀྱི་ཚབ་བྱེད་དུ་བདག་ལ་དབང་བར་གྱིས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","དེར་བརྟེན་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ། ཡེས་ར་ཨེལ་པ་རྣམས་ལས་སྐྱེས་འགོ་ཐམས་ཅད་རྩིས་བླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","མིང་གི་གྲངས་ཀ་བཞིན་དུ་ཟླ་བ་གཅིག་ཅན་དང་དེའི་ཡན་གྱི་ཕོ་སྐྱེས་འགོ་ཐམས་ཅད་རྩིས་བླངས་པ་དང་། བསྡོམས་པས་ཉིས་ཁྲི་ཉིས་སྟོང་ཉིས་བརྒྱ་བདུན་ཅུ་དོན་གསུམ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྐྱེས་འགོ་ཐམས་ཅད་ཀྱི་ཚབ་ཏུ་ལེ་ཝི་པ་རྣམས་འདེམས་དགོས་པ་དང་། ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་གི་ཚབ་ཏུ་ལེ་ཝི་པ་རྣམས་ཀྱི་ཕྱུགས་ཟོག་འདེམས་དགོས། ལེ་ཝི་པ་རྣམས་བདག་ལ་དབང་སྟེ། བདག་ནི་ཡ་ཝཱེ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ལེ་ཝི་པའི་བསྡོམས་གྲངས་ལས་བརྒལ་བའི་མི་ཉིས་བརྒྱ་བདུན་ཅུ་དོན་གསུམ་ཏེ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་བུ་སྐྱེས་འགོ་བླུ་དགོས་པ་རྣམས་ནི། ");
INSERT INTO bodn_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ཁྱོད་ཀྱིས་མི་རེ་ལས་དངུལ་སྲང་ལྔ་རེ་ལོངས་ཤིག གནས་མཆོག་གི་སྲང་བཞིན་དུ་དངུལ་སྲང་རེ་ལ་གཱེ་ར་ཉི་ཤུ་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ཁྱོད་ཀྱིས་ཚད་ལས་བརྒལ་བའི་མི་གྲངས་ཀྱི་བླུ་རིན་དེ་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་སྤྲོད་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","དེ་ནས་མོ་ཤེ་ཡིས་ལེ་ཝི་པ་རྣམས་ཀྱིས་བླུས་ནས་ལྷག་པ་རྣམས་ལས་བླུ་རིན་བླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྐྱེས་འགོ་རྣམས་ལས་བསྡུས་པའི་དངུལ་ནི་གནས་མཆོག་གི་སྲང་བཞིན་དུ། བསྡོམས་པས་དངུལ་སྲང་ཆིག་སྟོང་སུམ་བརྒྱ་དྲུག་ཅུ་རེ་ལྔ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ། བླུ་རིན་རྣམས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་སྤྲད་ཅིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་བཞིན་དུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ལས་ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱི་བསྡོམས་གྲངས་ནི། དེ་དག་གི་ཁྱིམ་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཐམས་ཅད་ཐོ་བརྒྱག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","རྫས་དམ་མཆོག་རྣམས་ལ་བདག་གཉེར་བྱ་རྒྱུ་ནི་ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱི་མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་ལས་ཀ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","སྒར་ཆས་པའི་ཚེ་ན། ཨ་རོན་དང་དེའི་བུ་རྣམས་ནང་དུ་སོང་ནས་གནས་དམ་མཆོག་གཡོག་བྱེད་ཀྱི་ཡོལ་བ་མར་བླངས་ཏེ། ཡོལ་བ་དེས་དཔང་མཛད་ཤུར་སྒམ་གཡོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ཡང་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་ཁེབས་ཀྱིས་དེ་གཡོག་པ་དང་། དེའི་སྟེང་དུ་རས་སྔོ་རྐྱང་བཏིངས་རྗེས་རྒྱུག་ཤིང་རྣམས་བརྒྱུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","སྤྱན་བསྟར་བག་ལེབ་ཀྱི་སྒྲོག་ཙེའི་སྟེང་དུ་དེ་དག་གིས་རས་སྔོན་པོ་འདིང་དགོས་པ་དང་། དེའི་སྟེང་དུ་གཞོང་པ་དང་སྡེར་མ། སྐྱེམས་མཆོད་འབུལ་བྱེད་ཨུ་ལུ་དང་བུམ་པ་བཅས་བཤམ་དགོས་ལ། ཆད་མེད་བག་ལེབ་ཀྱང་དེའི་སྟེང་དུ་ངེས་པར་ཡོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","དངོས་པོ་དེ་དག་གི་སྟེང་དུ། རས་མཚལ་མདོག་བཏིངས་ནས་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་ཁེབས་ཀྱིས་གཡོགས་རྗེས་རྒྱུག་ཤིང་རྣམས་བརྒྱུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","དེ་ནས་རས་སྔོན་པོ་བླངས་ཏེ་འོད་ཀྱི་ཕྱིར་ཡིན་པའི་སྒྲོན་སྟེགས་དང་དེའི་སྟེང་གི་སྒྲོན་མེ་དང་། སྡོང་རས་གཅོད་བྱེད་སྐམ་ཆུང་དང་མེ་ཕོར། སྣུམ་ལྡུག་སྤྱད་ཡོ་བྱད་ཐམས་ཅད་རས་ཀྱིས་གཡོག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ཡང་སྒྲོན་སྟེགས་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་པས་བཏུམས་ནས་གདང་གི་སྟེང་དུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","གསེར་གྱི་མཆོད་ཁྲིའི་སྟེང་དུ་རས་སྔོན་པོ་བཏིངས་ནས་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་པས་གཡོགས་རྗེས། རྒྱུག་ཤིང་རྣམས་བརྒྱུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ཡང་གནས་མཆོག་ཏུ་ཞབས་ཕྱི་སྒྲུབ་སྤྱད་ཀྱི་ཡོ་བྱད་ཐམས་ཅད་རས་སྔོན་པོས་བཏུམས་ནས་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་ཁེབས་ཀྱིས་གཡོགས་རྗེས། གདང་གི་སྟེང་དུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","དེ་ནས་མཆོད་ཁྲིའི་སྟེང་གི་ཐལ་བ་ཁྱེར་ནས་དེའི་སྟེང་དུ་རས་རྒྱ་སྨུག་འདིང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ཡང་མཆོད་ཁྲིའི་སྟེང་ཞབས་ཕྱི་སྒྲུབ་སྤྱད་ཀྱི་ཡོ་བྱད་ཐམས་ཅད་དེ། མེ་ཕོར་དང་ཤ་འཛིན་ཁ་དབྲག མེ་ཁྱེམ། མཆོད་སྡེར་བཅས་ནི་དེའི་སྟེང་དུ་བཤམ་དགོས་ཤིང་། དེའི་སྟེང་དུ་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་ཁེབས་ཀྱིས་གཡོགས་རྗེས། རྒྱུག་ཤིང་རྣམས་བརྒྱུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","སྒར་ཡོངས་སུ་ཆས་པའི་ཚེ་ན། ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་གནས་མཆོག་དང་དེའི་ཡོ་བྱད་ཐམས་ཅད་གཡོགས་ཟིན་པའི་རྗེས་སུ། ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་འོངས་ནས་འཁུར་དགོས། འོན་ཀྱང་། ཁོ་རྣམས་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་དུ་རྫས་དམ་པ་དེ་རྣམས་ལ་རེག་མི་རུང་། མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་རྫས་དེ་དག་ནི་ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱིས་འཁུར་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨེ་ལི་ཨ་ཟར་གྱི་ལས་འགན་ནི་འདི་ལྟ་སྟེ། སྒྲོན་མེའི་སྣུམ་དང་དྲི་ཞིམ་བདུག་སྤོས། དུས་རྒྱུན་གྱི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་། འབྱུག་སྣུམ་བཅས་དང་། གུར་མཆོག་ཧྲིལ་པོ་དང་དེའི་ནང་དུ་ཡོད་པ་ཐམས་ཅད་དང་། གནས་མཆོག་དང་དེའི་ཡོ་བྱད་རྣམས་ལ་བདག་གཉེར་བྱ་རྒྱུ་དེའོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","ཁྱོད་ཅག་གིས་ཀོ་ཧད་པའི་ཁྱིམ་རྒྱུད་ཀྱི་ཚོ་པ་ཁག་ནི་ལེ་ཝི་པའི་ཁྲོད་ནས་མེད་པར་གཏོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","དེ་རྣམས་རྫས་དམ་མཆོག་རྣམས་ཀྱི་དྲུང་དུ་ཉེ་བར་འོང་ཚེ། ཨ་རོན་དང་དེའི་བུ་རྣམས་ནང་དུ་སོང་ནས། དེ་དག་རེ་རེའི་བསྒྲུབ་དགོས་པ་དང་འཁུར་དགོས་པའི་ལས་དོན་གཏན་ཁེལ་བྱེད་དགོས། དེ་དག་འཆི་བར་མི་འགྱུར་ཞིང་གསོན་པོར་གནས་པའི་ཆེད་དུ། དེ་དག་ལ་འདི་ལྟར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","འོན་ཀྱང་དེ་དག་ཡུད་ཙམ་ལའང་ནང་དུ་སོང་སྟེ་རྫས་དམ་པར་བལྟ་མི་རུང་། བལྟས་ན་ཁོ་རྣམས་འཆི་བར་འགྱུར་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ཁྱོད་ཀྱིས་གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་བསྡོམས་གྲངས་ཀྱང་ཐོ་བརྒྱག་དགོས་ཏེ། དེ་དག་གི་ཕ་ཁྱིམ་དང་ཁྱིམ་རྒྱུད་བཞིན་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ལོ་སུམ་ཅུ་ནས་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཐམས་ཅད་རྩིས་ལེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","གེར་ཤོན་པའི་ཁྱིམ་རྒྱུད་རྣམས་ཀྱིས་བསྒྲུབ་བྱའི་དོན་དང་འཁུར་བྱའི་དངོས་པོ་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","དེ་དག་གིས་གུར་མཆོག་གི་ཡོལ་བ་དག་དང་། མཇལ་འཕྲད་གུར་མཆོག་དང་དེའི་ཐོག་ཁེབས། ཡང་དེའི་སྟེང་ལ་གཡོགས་པའི་ཀོ་བ་སྤུས་ལེགས་ཀྱི་པགས་ཁེབས་དང་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཡོལ། ");
INSERT INTO bodn_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ཁྱམས་ཡོལ་རྣམས་དང་། གུར་མཆོག་དང་མཆོད་ཁྲི་བསྐོར་བའི་ཁྱམས་རའི་སྒོ་ཡོལ་དང་། ཆོན་ཐག་རྣམས་དང་ཞབས་ཕྱི་སྒྲུབ་སྤྱད་ཡོ་བྱད་ཐམས་ཅད་འཁུར་དགོས་པ་དང་། ཡོ་བྱད་དེ་དག་དང་འབྲེལ་བ་ཐམས་ཅད་ཁོ་རྣམས་ཀྱིས་བསྒྲུབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགན་འཁུར་ཏེ། ཁོ་རྣམས་ཀྱིས་བསྒྲུབ་དགོས་པ་དང་འཁུར་དགོས་པའི་དོན་ཐམས་ཅད་ནི་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱིས་སྨྲས་པ་བཞིན་དུ་བྱེད་དགོས། དེ་དག་གིས་ཅི་འཁུར་དགོས་པའི་ལས་འགན་ཐམས་ཅད་ཁྱོད་ཀྱིས་སྤྲོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","འདི་ནི་གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱིས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་བསྒྲུབ་དགོས་པའི་ཞབས་ཕྱི་ཡིན་ཏེ། དེ་དག་གི་ལས་འགན་ནི་མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨི་ཐ་མཱར་གྱི་དབང་འོག་ཏུ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱང་ཁྱོད་ཀྱིས་དེ་དག་གི་རུས་རྒྱུད་དང་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་ལེན་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཐམས་ཅད་རྩིས་ལེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","དེ་དག་གི་མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་ཞབས་ཕྱི་ཐམས་ཅད་དང་ལས་འགན་ཆ་ཚང་སྟེ། གུར་མཆོག་གི་པང་ལེབ་དང་འཕྲེད་རྒྱུག་དང་། ཀ་བ་དང་། ཞབས་ར་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ཁྱམས་ར་མཐའ་འཁོར་གྱི་ཀ་བ་དང་། ཞབས་ར་དང་། ཕུར་བ་དང་། ཆོན་ཐག་དང་། དེ་ལ་གཏོགས་པའི་ལག་ཆ་དང་སྤྱོད་ཆས་ཐམས་ཅད་འཁུར་དགོས་པ་དང་། དེ་དག་གིས་འཁུར་དགོས་པའི་ཡོ་བྱད་རྣམས་ནི་མིང་གིས་བཟུང་ནས་རེ་རེ་བཞིན་གཏན་ཁེལ་བྱེད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","འདི་ནི་མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཀྱིས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་བསྒྲུབ་དགོས་པའི་ཞབས་ཕྱི་ཐམས་ཅད་ཡིན་ལ། མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨི་ཐ་མཱར་གྱི་དབང་འོག་ཏུ་ཡོད་པའོ་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","མོ་ཤེ་དང་ཨ་རོན་དང་ཚོགས་པའི་འགོ་དཔོན་རྣམས་ཀྱིས་ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱི་གྲངས་ཀ་ནི་དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཐམས་ཅད་རྩིས་བླངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","དེ་དག་རུས་རྒྱུད་བཞིན་རྩིས་བླངས་པའི་བསྡོམས་གྲངས་ནི་ཉིས་སྟོང་བདུན་བརྒྱ་ལྔ་བཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","འདི་ནི་ཀོ་ཧད་པའི་ཁྱིམ་རྒྱུད་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ཡིན་ལ། མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་བྱེད་མཁན་ཐམས་ཅད་ཡིན་པ་དང་། མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ལས་དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ་རྩིས་བླངས་པ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ནི། ");
INSERT INTO bodn_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ་རྩིས་བླངས་པའི་མི་གྲངས་ཉིས་སྟོང་དྲུག་བརྒྱ་སུམ་ཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","དེ་དག་ནི་གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ཡིན་ལ། མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་བྱེད་མཁན་ཐམས་ཅད་ཡིན་པ་དང་། མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ལས་དེ་དག་གི་རུས་རྒྱུད་དང་ཕ་ཁྱིམ་བཞིན་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་ཞབས་ཕྱི་སྒྲུབ་མཁན་ཐམས་ཅད་རྩིས་བླངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","རུས་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་བསྡོམས་པས་སུམ་སྟོང་ཉིས་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","དེ་དག་ནི་མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ལས་རྩིས་བླངས་པའི་མི་གྲངས་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བསྩལ་པའི་བཀའ་བཞིན་དུ། མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་རྩིས་བླངས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","མོ་ཤེ་དང་ཨ་རོན་དང་། ཡེས་ར་ཨེལ་གྱི་འགོ་དཔོན་རྣམས་ཀྱིས་ལེ་ཝི་པ་རྣམས་དེ་དག་གི་རུས་རྒྱུད་དང་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ནི། ");
INSERT INTO bodn_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ལོ་སུམ་ཅུ་ནས་ལོ་ལྔ་བཅུ་བར་གྱི་ལས་འགན་ཁུར་ནས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་འཁྱེར་མཁན་རྣམས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","དེ་དག་གི་གྲངས་ཀ་ནི་བསྡོམས་པས་བརྒྱད་སྟོང་ལྔ་བརྒྱ་བརྒྱད་ཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་བསྩལ་པའི་བཀའ་བཞིན་དུ་དེ་དག་རྩིས་བླངས་པའོ། །མོ་ཤེ་ཡིས་མི་རེ་རེ་བཞིན་རང་རང་གི་བསྒྲུབ་བྱའི་དོན་དང་འཁུར་བྱའི་དངོས་པོ་ལྟར་རྩིས་བླངས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་བཞིན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ། མི་མཛེ་ནད་ཅན་དང་། འཛིར་ནད་ཅན་དང་། བེམ་པོ་ལ་རེག་ནས་མི་གཙང་བར་གྱུར་པ་ཐམས་ཅད་སྒར་གྱི་ཕྱི་རོལ་ཏུ་འདོན་པར་བཀའ་སྒོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","སྐྱེས་པའམ་བུད་མེད་སུ་ཡིན་ཡང་ཕྱི་རུ་འདོན་པ་དང་། དེ་དག་གིས་རང་གི་སྒར་བཙོག་པར་མི་བྱེད་པའི་ཆེད་དུ། དེ་རྣམས་སྒར་གྱི་ཕྱི་རོལ་ཏུ་འདོན་དགོས་ལ། སྒར་དེ་ནི་བདག་གི་སྡོད་གནས་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་ལྟར་བྱས་ཤིང་། དེ་དག་སྒར་གྱི་ཕྱི་རོལ་ཏུ་བཏོན་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་ཇི་ལྟར་གསུངས་པ་བཞིན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་ལྟར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། སྐྱེས་པའམ་བུད་མེད་སུ་ཡིན་ཡང་མི་ཡིས་བྱེད་པའི་སྡིག་པ་སྤྱད་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འགལ་བ་ཡིན་ན། མི་དེ་ལ་ཉེས་པ་ཡོད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","མི་དེས་རང་བྱས་ཀྱི་སྡིག་པ་མཐོལ་བཤགས་བགྱི་བ་དང་། མི་ལ་གྱོང་གུད་བཟོས་པ་ལ་སྐྱིན་ཚབ་འཇལ་བར་མ་ཟད། དེའི་ཁར་ལྔ་ཆ་གཅིག་བསྣན་ཏེ་གྱོང་རག་པའི་མི་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","གལ་སྲིད་མི་དེ་ལ་གྱོང་གུད་ཀྱི་སྐྱིན་ཚབ་འཇལ་སའི་གཉེན་ཉེ་མེད་ན། གྱོང་གུད་ཀྱི་སྐྱིན་ཚབ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འཇལ་དགོས་ཤིང་། དེ་ནི་མཆོད་དཔོན་ལ་དབང་བ་དང་། དེའི་ཁར་ད་དུང་སྡིག་བཤགས་བྱེད་པའི་ལུག་ཐུག་ཀྱང་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་རྫས་དམ་པ་ཐམས་ཅད་ལས་མཆོད་དཔོན་ལ་འདེགས་མཆོད་དུ་ཕུལ་བ་ནི་གང་ཡིན་ཡང་མཆོད་དཔོན་ལ་དབང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","མི་རེ་རེས་ཕུལ་བའི་རྫས་དམ་པ་རྣམས་མཆོད་དཔོན་ལ་དབང་དགོས། མི་ཡིས་རྫས་གང་ཞིག་མཆོད་དཔོན་ལ་ཕུལ་ན། དེ་ནི་མཆོད་དཔོན་ལ་དབང་བ་ཡིན་ཞེས་བཤད་དགོས་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། སུ་དང་སུ་ཡིན་ཡང་གལ་ཏེ་ཁོའི་ཆུང་མས་ཁྱོ་ག་ལ་རྒྱབ་འགལ་བྱས་ནས་རང་གི་ཁྱོ་ག་ལ་བློ་མི་དཀར་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","སྐྱེས་པ་ཞིག་ཁོ་མོ་དང་ལུས་འབྲེལ་བྱས་ཏེ། རང་གི་ཁྱོ་ག་ལ་གསང་ནས་རྩད་མ་ཆོད་པ་དང་། ཁོ་མོས་རང་ཉིད་མི་གཙང་བར་བྱས་པ་ལ་བདེན་དཔང་བྱེད་མཁན་སུ་ཡང་མ་བྱུང་ཞིང་། ཉེས་པ་བྱེད་དུས་ཀྱང་གཞན་གྱིས་མ་ཟིན་ནའང་། ");
INSERT INTO bodn_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","གལ་སྲིད་ཁོ་མོའི་ཁྱོ་གའི་སེམས་སུ་དོགས་པ་ལངས་ནས་རང་གི་ཆུང་མར་ཐེ་ཚོམ་ཟོས་པ་དང་། ཆུང་མ་དངོས་གནས་མི་གཙང་བར་བྱས་པའམ། ཡང་ན་ཁྱོ་ག་སེམས་སུ་དོགས་པ་ལངས་ནས་རང་གི་ཆུང་མར་ཐེ་ཚོམ་ཟོས་ནའང་ཆུང་མ་མི་གཙང་བར་བྱས་མེད་ན། ");
INSERT INTO bodn_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","མི་དེས་རང་གི་ཆུང་མ་མཆོད་དཔོན་གྱི་མདུན་དུ་འཁྲིད་པ་དང་། ཡང་ཁོ་མོའི་ཆེད་དུ་ནས་ཕྱེ་ཨེ་ཕཱ་བཅུ་ཆ་གཅིག་མཆོད་པར་འབུལ་དགོས་ཤིང་། དེའི་སྟེང་དུ་སྣུམ་ལྡུག་མི་རུང་ལ་སྤོས་དཀར་ཡང་སྒྲོན་མི་རིགས་སོ། །ཅིའི་ཕྱིར་ཞེ་ན། དེ་ནི་ཐེ་ཚོམ་གྱི་འབྲུ་མཆོད་དང་། དྲན་པའི་འབྲུ་མཆོད་དེ་ནག་ཉེས་དྲན་པའི་འབྲུ་མཆོད་ཡིན་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","དེ་ནས་མཆོད་དཔོན་གྱིས་བུད་མེད་དེ་འཁྲིས་སུ་ཁྲིད་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བསླང་བར་བྱ་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ཆུ་དམ་པ་རྫ་བུམ་ཞིག་ཏུ་ལྡུག་པ་དང་། ཡང་གུར་མཆོག་གི་ས་ནས་ས་རྡུལ་བླངས་ཏེ་ཆུ་ནང་དུ་འདེབས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","མཆོད་དཔོན་གྱིས་བུད་མེད་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བསླངས་ནས་ཁོ་མོའི་སྐྲ་ལྷོད་པ་དང་། དྲན་པའི་འབྲུ་མཆོད་དེ་ཐེ་ཚོམ་གྱི་འབྲུ་མཆོད་ཡིན་པ་དེ་ནི་ཁོ་མོའི་ལག་ཏུ་འཇོག་དགོས། མཆོད་དཔོན་གྱི་ལག་ཏུ་དམོད་མོ་འགུག་པའི་ཆུ་ཁ་མོ་འཛིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","མཆོད་དཔོན་གྱིས་བུད་མེད་དེ་ལ་མནའ་སྐྱེལ་དུ་འཇུག་ཅིང་། ཁོ་མོར་འདི་ལྟར། གལ་སྲིད་སྐྱེས་པ་སུ་ཡང་ཁྱོད་དང་ལུས་འབྲེལ་མ་བྱས་པ་དང་། རང་གི་ཁྱོ་ག་ལ་དབང་བའི་དུས་སུ་ཁྱོད་ཀྱིས་ཁྱོ་གར་རྒྱབ་འགལ་བྱས་ནས་རང་ཉིད་མི་གཙང་བར་བྱས་མེད་ན། དམོད་མོ་འགུག་པའི་ཆུ་ཁ་མོ་འདི་ལས་ཐར་བར་གྱུར་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","གལ་ཏེ་ཁྱོད་རང་ཁྱོ་ག་ལ་དབང་བའི་དུས་སུ་ཁྱོ་གར་རྒྱབ་འགལ་བྱས་ནས་རང་ཉིད་མི་གཙང་བར་བྱས་པ་དང་། ཁྱོད་ནི་རང་གི་ཁྱོ་ག་མིན་པའི་སྐྱེས་པ་གཞན་དང་ལུས་འབྲེལ་བྱས་པ་ཡིན་ན་ཞེས་སྨྲ་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","མཆོད་དཔོན་གྱིས་བུད་མེད་ལ་མནའ་སྐྱེལ་དུ་བཅུག་ནས་མུ་མཐུད་དུ་ཁོ་མོར་འདི་ལྟར། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཀྱི་བརླ་ནི་རིད་ཅིང་གསུས་པ་སྐྲང་བར་མཛད་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ནི་ཁྱོད་ཀྱི་ཡུལ་མིའི་དཀྱིལ་དུ་དམོད་མོ་དང་མནའ་རུ་འགྱུར་བར་མཛོད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","དམོད་མོ་འགུག་པའི་ཆུ་འདི་ཁྱོད་ཀྱི་གྲོད་ཁོག་ཏུ་ཞུགས་ཏེ། ཁྱོད་ཀྱི་གསུས་པ་སྐྲང་ཞིང་བརླ་རིད་དུ་འཇུག་པར་མཛོད་ཅིག་ཅེས་སྨྲ་དགོས་ལ། དེ་ནས་བུད་མེད་དེས་ཨ་མེན་ ཨ་མེན་ཞེས་ཞུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","དེ་ནས་མཆོད་དཔོན་གྱིས་དམོད་མོ་དེ་དག་ཤོག་དྲིལ་སྟེང་དུ་བྲིས་ནས་དེ་ཆུ་ཁ་མོའི་ནང་བཀྲུ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ཡང་བུད་མེད་དེ་ལ་དམོད་མོ་འགུག་པའི་ཆུ་ཁ་མོ་དེ་འཐུང་དུ་བཅུག་ནས། དམོད་མོ་འགུག་པའི་ཆུ་དེ་ཁོ་མོའི་གྲོད་ཁོག་ཏུ་ཞུགས་ཏེ་ན་ཟུག་སློང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","མཆོད་དཔོན་གྱིས་བུད་མེད་དེའི་ལག་ནས་ཐེ་ཚོམ་གྱི་འབྲུ་མཆོད་བླངས་ནས། དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དེ་ཕར་གཡོ་ཚུར་གཡོ་བྱས་རྗེས་མཆོད་ཁྲིའི་སྟེང་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","མཆོད་དཔོན་གྱིས་འབྲུ་རིགས་ཀྱི་མཆོད་པ་ལས། དྲན་རྟེན་གྱི་མཆོད་པ་ཁྱོར་བ་གང་བླངས་ནས་མཆོད་ཁྲིའི་ཁར་བསྲེག་པ་དང་། དེའི་རྗེས་སུ་ད་གཟོད་བུད་མེད་ལ་ཆུ་དེ་འཐུང་དུ་འཇུག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ཁོ་མོར་ཆུ་དེ་འཐུང་དུ་བཅུག་རྗེས། གལ་སྲིད་ཁོ་མོས་མི་གཙང་བ་སྤྱད་ཅིང་རང་གི་ཁྱོ་གར་བློ་མི་དཀར་ན། དམོད་མོ་འགུག་པའི་ཆུ་དེ་ཁོ་མོའི་གྲོད་ཁོག་ཏུ་ཞུགས་ནས་ན་ཟུག་སློང་བར་འགྱུར་བ་དང་། ཁོ་མོའི་གསུས་པ་སྐྲང་ཞིང་བརླ་ཡང་རིད་པར་འགྱུར་ལ། བུད་མེད་དེ་ནི་རང་གི་ཡུལ་མིའི་དཀྱིལ་དུ་དམོད་མོ་རུ་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","གལ་སྲིད་བུད་མེད་དེ་གཞན་གྱིས་མི་གཙང་བར་བྱས་མེད་པ་དང་གཙང་མ་ཡིན་ན། ཁོ་མོར་གནོད་པ་མི་འཕོག་ལ་མངལ་ཡང་སྦྲུམ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","འདི་ནི་ཐེ་ཚོམ་སྐོར་གྱི་བཀའ་ཁྲིམས་ཡིན་ཏེ། གལ་སྲིད་ཆུང་མ་ཞིག་གིས་རང་ཉིད་ཁྱོ་གར་དབང་བའི་དུས་སུ་ཁྱོ་ག་ལ་རྒྱབ་འགལ་བྱས་ནས་རང་མི་གཙང་བར་བྱས་པའམ། ");
INSERT INTO bodn_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ཡང་ན་སྐྱེས་པ་ཞིག་གི་སེམས་སུ་དོགས་པ་ལངས་ནས་རང་གི་ཆུང་མར་ཐེ་ཚོམ་ཟོས་ན། ཁོས་བུད་མེད་དེ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་བསླང་དགོས་པ་དང་། མཆོད་དཔོན་གྱིས་བུད་མེད་དེ་ལ་བཀའ་ཁྲིམས་ཆ་ཚང་བཞིན་དུ་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ཁྱོ་ག་དེར་ནག་ཉེས་མི་འཕོག་ཅིང་། བུད་མེད་ཀྱིས་རང་གི་ནག་ཉེས་འཁུར་དགོས་ཞེས་བཤད་པར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་དང་། སྐྱེས་པའམ་བུད་མེད་སུ་ཡིན་ཡང་གལ་སྲིད་དམ་བཅའ་ཁྱད་པར་ཅན་ཏེ་ནཱ་ཟར་པའི་དམ་བཅའ་བཞག་ཡོད་ན། སྡོམ་པ་བསྲུངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","རྒུན་ཆང་དང་གར་ཆང་གཅོད་དགོས་ཤིང་། རྒུན་ཆང་གིས་བཟོས་པའི་སྐྱུར་ཆུ་དང་གར་ཆང་གིས་བཟོས་པའི་སྐྱུར་ཆུ་གང་ཡང་སྤྱོད་མི་འོས། རྒུན་འབྲུམ་གྱི་བཅུད་ཁུ་གང་ཡང་འཐུང་མི་རུང་ལ། རྒུན་འབྲུམ་གསར་པའམ་སྐམ་པོ་གང་ཡང་བཟའ་མི་འོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","སྡོམ་པ་སྲུང་བའི་ཉིན་མོ་དག་ལ། རྒུན་ཤིང་ལས་སྨིན་པའི་འབྲུ་གུའམ་ཤུན་པ་གང་ཡང་བཟའ་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","མི་དེས་དམ་བཅས་ནས་སྡོམ་པ་སྲུང་བའི་ཉིན་མོ་དག་ལ། སྤུ་གྲིས་མགོ་ལ་རེག་མི་རུང་ཞིང་དམ་པ་ཡིན་དགོས་ལ། སྡོམ་པ་བསྲུངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་པའི་ཉིན་མོ་དེ་དག་རྫོགས་པའི་བར་དུ་མགོའི་སྐྲ་སྐྱེ་རུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","སྡོམ་པ་བསྲུངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་པའི་ཉིན་མོ་དག་ལ་གཤིན་པོའི་བེམ་པོ་དང་ཉེ་བར་བཅར་མི་རུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ཁོའི་ཕ་མ་དང་ཕུ་ནུ་མིང་སྲིང་ཤི་བའི་ཚེ། དེ་དག་གི་རྐྱེན་གྱིས་རང་ཉིད་བཙོག་པར་བཟོ་མི་རུང་སྟེ། སྡོམ་པ་བསྲུངས་ནས་དཀོན་མཆོག་ལ་གཏོགས་པའི་རྟགས་ནི་ཁོའི་མགོ་ལ་ཡོད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","སྡོམ་པ་སྲུང་བའི་ཉིན་མོ་དག་ལ་ཁོ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་ཤིང་དམ་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","གལ་སྲིད་དེའི་གམ་དུ་མི་ཞིག་གློ་བུར་ཤི་ནས། དེས་ཁོའི་དམ་པར་བསྔོས་པའི་མགོ་མི་གཙང་བར་བཟོས་ན། གཙང་སྦྲ་བྱེད་པའི་ཉིན་མོ་སྟེ། ཉིན་བདུན་པ་ལ་ཁོའི་སྐྲ་གཞར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ཉིན་བརྒྱད་པ་ལ་ཁོས་བྱ་ཐི་བ་གཉིས་སམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ཁྱེར་ནས་མཆོད་དཔོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","མཆོད་དཔོན་གྱིས་གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་། ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་ཕུལ་ནས་གཤིན་པོའི་བེམ་པོའི་རྐྱེན་གྱིས་བཙོག་པར་གྱུར་པའི་སྡིག་པ་བཤག་དགོས་ལ། ཁོས་ཉིན་དེ་ཉིད་དུ་རང་གི་མགོ་དམ་པར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","སྡོམ་པ་བསྲུངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཏོགས་པའི་ཉིན་མོར། ཡང་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་ཁྱེར་ཡོང་ནས་ཉེས་སེལ་མཆོད་པར་འབུལ་དགོས། འོན་ཀྱང་སྡོམ་པ་མི་གཙང་བར་གྱུར་པའི་རྐྱེན་གྱིས། དེའི་སྔར་གྱི་ཉིན་མོ་རྣམས་རྩི་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ནཱ་ཟར་པ་རྣམས་ཀྱི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། སྡོམ་པ་སྲུང་མཁན་གྱི་ཉིན་མོ་རྣམས་རྫོགས་པའི་ཉིན་ལ། མི་དེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་འཁྲིད་དགོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ཁོས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་དགོས་ཏེ། སྐྱོན་ཅི་ཡང་མེད་པའི་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་སྦྱིན་སྲེག་ཏུ་འབུལ་བ་དང་། སྐྱོན་ཅི་ཡང་མེད་པའི་མོ་ལུག་ལོ་གཅིག་ཅན་ཞིག་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། སྐྱོན་ཅི་ཡང་མེད་པའི་ལུག་ཐུག་ཅིག་ཞི་བདེའི་མཆོད་པར་འབུལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ཕྱེ་བཟང་པོས་བཟོས་པའི་སྐྱུར་མེད་སྣུམ་བསྲེས་བག་ལེབ་དང་སྐྱུར་མེད་སྣུམ་བྱུགས་བག་ལེབ་སྲབ་མོ་གཟེབ་གང་དང་། དེ་དག་དང་མཉམ་དུ་འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་སྐྱེམས་མཆོད་བཅས་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","མཆོད་དཔོན་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་དེ་དག་འབུལ་བ་དང་། སྡིག་བཤགས་མཆོད་པ་དང་སྦྱིན་སྲེག་ཀྱང་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ཡང་མཆོད་དཔོན་གྱིས་ལུག་ཐུག་དེ་དང་སྐྱུར་མེད་བག་ལེབ་ཀྱི་གཟེབ་དེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཞི་བདེའི་མཆོད་པར་འབུལ་དགོས་པ་དང་། ཁོས་དེ་དང་མཉམ་དུ་འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་སྐྱེམས་མཆོད་ཀྱང་འབུལ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ནཱ་ཟར་པས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་རང་གི་སྡོམ་པ་སྲུང་བའི་སྐྲ་བཞར་ནས། དེ་ཞི་བདེའི་མཆོད་པ་འོག་ཏུ་ཡོད་པའི་མེ་ཐོག་ཏུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ནཱ་ཟར་པས་རང་གི་སྡོམ་པ་སྲུང་བའི་སྐྲ་བཞར་རྗེས། མཆོད་དཔོན་གྱིས་བཙོས་ཟིན་པའི་ལུག་ཐུག་གི་སོག་པ་གཅིག་དང་། ཡང་གཟེབ་ལས་སྐྱུར་མེད་བག་ལེབ་གཅིག་དང་། སྐྱུར་མེད་བག་ལེབ་སྲབ་མོ་གཅིག་བཅས་བླངས་ཏེ་ནཱ་ཟར་པའི་ལག་ཏུ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","དེ་ནས་མཆོད་དཔོན་གྱིས་དེ་རྣམས་གཡོབ་མཆོད་དུ་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕར་གཡོ་ཚུར་གཡོ་བྱེད་དགོས་པ་དང་། དེ་རྣམས་གཡོབ་མཆོད་དུ་ཕུལ་བའི་བྲང་ཁོག་དང་འདེགས་མཆོད་དུ་ཕུལ་བའི་བརླ་རྐང་དང་བཅས་ཏེ་མཆོད་དཔོན་ལ་དབང་བའི་རྫས་དམ་པ་ཡིན། དེའི་རྗེས་སུ་ནཱ་ཟར་པས་ད་གཟོད་རྒུན་ཆང་འཐུང་ཆོག་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","དམ་བཅའ་འཇོག་མཁན་ནཱ་ཟར་པའི་བཀའ་ཁྲིམས་ནི། ནཱ་ཟར་པས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་མཆོད་པ་ནི་ཁོའི་སྡོམ་པ་སྲུང་བའི་དམ་བཅའ་བཞིན་དང་། ཁོའི་ལག་གི་འཛོམས་ཚོད་བཞིན་ཡིན་ཞིང་། ཁོས་ཇི་ལྟར་དམ་བཅས་པ་ཡིན་ན་དེ་ལྟར་སྡོམ་པ་སྲུང་བའི་སྒྲིག་སྲོལ་བཞིན་བསྒྲུབ་དགོས་ཞེས་པ་དེ་ཡིན་ནོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","ཁྱོད་ཀྱིས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་འདི་ལྟར། ཁྱོད་ཅག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བྱིན་རླབས་གནང་ནས་དེ་དག་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ལ་བྱིན་རླབས་མཛད་ཅིང་ཁྱོད་རང་བསྲུང་བར་ཤོག ");
INSERT INTO bodn_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","དཀོན་མཆོག་ཡ་ཝཱེས་ཉིད་ཀྱི་ཞལ་མདངས་ཁྱོད་ཀྱི་སྟེང་དུ་སྤྲོས་ཏེ། ཁྱོད་ལ་ཐུགས་རྗེ་གནང་བར་ཤོག ");
INSERT INTO bodn_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","དཀོན་མཆོག་ཡ་ཝཱེས་ཉིད་ཀྱི་ཞལ་ངོ་ཁྱོད་ལ་བསྟན་ནས་ཁྱོད་ལ་ཞི་བདེ་གནང་བར་ཤོག ཅེས་སྨྲོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ཁོ་རྣམས་ཀྱིས་དེ་བཞིན་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བདག་གི་མིང་བརྗོད་དགོས་པ་དང་། བདག་གིས་ཀྱང་དེ་དག་ལ་བྱིན་གྱིས་བརླབ་པར་བྱའོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","དེ་ཡང་མོ་ཤེ་ཡིས་གུར་མཆོག་བསྒྲེངས་ཚར་བའི་ཉིན་མོ་དེར། དེ་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་ཤིང་དམ་པར་བྱས་པ་དང་། དེའི་ནང་གི་ཡོ་བྱད་ཐམས་ཅད་དང་མཆོད་ཁྲི་དང་དེའི་ཡོ་བྱད་མཐའ་དག་ལ་འབྱུག་སྣུམ་གྱིས་བྱུགས་ཤིང་དམ་པར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","དེ་ནས་ཡེས་ར་ཨེལ་གྱི་འགོ་དཔོན་རྣམས་ཏེ་ཁོ་ཚོའི་ཕ་ཁྱིམ་གྱི་འགོ་པ་ཐམས་ཅད་ཡོང་ནས་ཞལ་འདེབས་ཕུལ་བ་སྟེ། དེ་དག་ནི་ཚོ་པ་ཁག་གི་འགོ་དཔོན་རྣམས་ཡིན་ལ། རྩིས་བླངས་པའི་མི་རྣམས་ལ་དོ་དམ་བྱེད་མཁན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","དེ་དག་གིས་རང་རང་གི་འབུལ་བ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཕུལ་བ་འདི་ལྟ་སྟེ། ཁེབས་ཡོད་ཤིང་རྟ་དྲུག་དང་གླང་གོག་བཅུ་གཉིས་ཡོད་ལ། འགོ་དཔོན་གཉིས་རེས་ཤིང་རྟ་རེ་དང་འགོ་དཔོན་རེ་རེས་གླང་གོག་རེ་གུར་མཆོག་གི་མདུན་དུ་ཁྱེར་འོངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","མཇལ་འཕྲད་གུར་མཆོག་གི་ལས་དོན་ཐད་བཀོལ་སྤྱོད་བྱེད་པའི་ཕྱིར་དུ། ཁྱོད་ཀྱིས་དེ་དག་བླངས་ནས་ལེ་ཝི་པ་རྣམས་ལ་སྤྲོད་ཅིག མི་རེ་རེའི་ལས་ཚན་བཞིན་དུ་ཁོ་རྣམས་ལ་སྟེར་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","དེ་བས་མོ་ཤེ་ཡིས་ཤིང་རྟ་དང་གླང་གོག་རྣམས་བླངས་ནས་ལེ་ཝི་པ་རྣམས་ལ་སྤྲད། ");
INSERT INTO bodn_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ཁོས་གེར་ཤོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་ཞབས་ཕྱིའི་ལས་ཚན་བཞིན་དུ། ཤིང་རྟ་གཉིས་དང་གླང་གོག་བཞི་ཁོ་རྣམས་ལ་སྤྲད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ཡང་མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱི་ཞབས་ཕྱིའི་ལས་ཚན་བཞིན་དུ། ཤིང་རྟ་བཞི་དང་གླང་གོག་བརྒྱད་དེ་རྣམས་ལ་སྤྲད་ཅིང་། དེ་ཐམས་ཅད་ལ་མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨི་ཐ་མཱར་གྱིས་དོ་དམ་བྱེད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","འོན་ཀྱང་ཀོ་ཧད་ཀྱི་བུ་རྒྱུད་རྣམས་ཀྱིས་གནས་དམ་པ་རུ་ཞབས་ཕྱི་བྱེད་པ་དང་། རྫས་དམ་པ་རྣམས་ཕྲག་ལ་འཁུར་དགོས་པ་ཡིན་པས། དེ་ཚོར་ཅི་ཡང་མ་སྤྲད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","མཆོད་ཁྲིར་འབྱུག་སྣུམ་གྱིས་བྱུགས་པའི་ཉིན་མོར། འགོ་དཔོན་རྣམས་ཀྱིས་མཆོད་ཁྲིར་བསྔོས་པའི་མཆོད་རྫས་རྣམས་ཁྱེར་འོངས་ཏེ། དེ་དག་གིས་རང་གི་མཆོད་པ་རྣམས་མཆོད་ཁྲིའི་མདུན་དུ་མཆོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། འགོ་དཔོན་རྣམས་ཀྱིས་རང་རང་གི་མཆོད་ཁྲིར་བསྔོས་པའི་མཆོད་རྫས་འབུལ་དགོས་ཏེ། ཉིན་རེར་འགོ་དཔོན་གཅིག་གིས་མཆོད་པ་འཁྱེར་འོང་དགོས་ཞེས་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ཉིན་དང་པོར་མཆོད་པ་འབུལ་མཁན་ནི་ཡ་ཧུ་དཱ་ཚོ་པའི་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་ནཱ་སོན་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ། དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་ནཱ་སོན་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ཉིན་གཉིས་པར་མཆོད་པ་འབུལ་མཁན་ནི་ཡེས་སི་ཀཱར་གྱི་འགོ་དཔོན་ཙུ་ཨར་གྱི་བུ་ནེ་ཐན་ཨེལ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ཁོས་ཕུལ་བའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཙུ་ཨར་གྱི་བུ་ནེ་ཐན་ཨེལ་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ཉིན་གསུམ་པར་མཆོད་པ་འབུལ་མཁན་ནི་ཟེ་བུ་ལུན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཧེ་ལོན་གྱི་བུ་ཨེ་ལི་ཨབ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཧེ་ལོན་གྱི་བུ་ཨེ་ལི་ཨབ་ཀྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ཉིན་བཞི་པར་མཆོད་པ་འབུལ་མཁན་ནི་རུ་བེན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཤེ་དེ་ཨུར་གྱི་བུ་ཨེ་ལི་ཚུར་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཤེ་དེ་ཨུར་གྱི་བུ་ཨེ་ལི་ཚུར་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ཉིན་ལྔ་པར་མཆོད་པ་འབུལ་མཁན་ནི་སི་མུ་ཨོན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཙུ་རེ་ཤད་དཱ་ཨིའི་བུ་ཤེ་ལུ་མེ་ཨེལ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཙུ་རེ་ཤད་དཱ་ཨིའི་བུ་ཤེ་ལུ་མེ་ཨེལ་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ཉིན་དྲུག་པར་མཆོད་པ་འབུལ་མཁན་ནི་གཱ་རྡུ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་དི་ཨོ་ཨེལ་གྱི་བུ་ཨེལ་ཡཱ་སབ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་དི་ཨོ་ཨེལ་གྱི་བུ་ཨེལ་ཡཱ་སབ་ཀྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ཉིན་བདུན་པར་མཆོད་པ་འབུལ་མཁན་ནི་ཨེ་ཕཱར་ཡིམ་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཨམ་མེ་ཧུད་ཀྱི་བུ་ཨེ་ལི་ཤ་མཱ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཨམ་མེ་ཧུད་ཀྱི་བུ་ཨེ་ལི་ཤ་མཱའི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ཉིན་བརྒྱད་པར་མཆོད་པ་འབུལ་མཁན་ནི་མཱ་ན་ཤེའི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཕེ་དཱ་ཚུར་གྱི་བུ་གམ་ལི་ཨེལ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཕེ་དཱ་ཚུར་གྱི་བུ་གམ་ལི་ཨེལ་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ཉིན་དགུ་པར་མཆོད་པ་འབུལ་མཁན་ནི་པེན་ཡཱ་མེན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་གིད་ཨོ་ནཱའི་བུ་ཨ་བི་ཏན་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་གིད་ཨོ་ནཱའི་བུ་ཨ་བི་ཏན་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ཉིན་བཅུ་པར་མཆོད་པ་འབུལ་མཁན་ནི་དཱན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཨམ་མེ་ཤད་ད་ཨི་ཡི་བུ་ཨ་ཧི་ཨེ་ཟེར་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཨམ་མེ་ཤད་ད་ཨི་ཡི་བུ་ཨ་ཧི་ཨེ་ཟེར་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ཉིན་བཅུ་གཅིག་པར་མཆོད་པ་འབུལ་མཁན་ནི་ཨ་ཤེར་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཨོག་རན་གྱི་བུ་ཕཱ་གེ་ཨེལ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཨོག་རན་གྱི་བུ་ཕཱ་གེ་ཨེལ་གྱི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ཉིན་བཅུ་གཉིས་པར་མཆོད་པ་འབུལ་མཁན་ནི་ནཱབ་ཐ་ལིའི་བུ་རྒྱུད་རྣམས་ཀྱི་འགོ་དཔོན་ཨེ་ནན་གྱི་བུ་ཨ་ཧི་རཱ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","དེའི་མཆོད་པ་ནི་དངུལ་གྱི་སྡེར་མ་གཅིག་སྟེ་དངུལ་སྲང་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། དངུལ་གྱི་ཕོར་བ་གཅིག་སྟེ་དངུལ་སྲང་བདུན་ཅུ་ཡིན་ལ། ཐམས་ཅད་གནས་མཆོག་གི་སྲང་ལྟར་ཡིན། སྣོད་དེ་གཉིས་ཀ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མས་གང་བར་བྱས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་ཕུལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","སྲང་བཅུ་ལས་བརྡུངས་པའི་གསེར་གྱི་སྡེར་མ་གཅིག་དང་དེའི་ནང་དུ་བདུག་སྤོས་གང་བླུགས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་གླང་ཐུག་གཅིག་དང་། ལུག་ཐུག་གཅིག་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ཞིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","སྡིག་བཤགས་མཆོད་པ་རུ་ར་ཕོ་གཅིག་བཅས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ཞི་བདེའི་མཆོད་པའི་ཕྱིར་དུ་གླང་གོག་གཉིས་དང་། ལུག་ཐུག་ལྔ་དང་། ར་ཕོ་ལྔ་དང་། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་ལྔ་བཅས་ཡོད་ལ། དེ་ནི་ཨེ་ནན་གྱི་བུ་ཨ་ཧི་རཱའི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","དེ་རྣམས་ནི་མཆོད་ཁྲིར་འབྱུག་སྣུམ་གྱིས་བྱུག་པའི་ཉིན་མོར། ཡེས་ར་ཨེལ་གྱི་འགོ་དཔོན་རྣམས་ཀྱིས་མཆོད་ཁྲིར་བསྔོས་པའི་མཆོད་པ་སྟེ། བསྡོམས་པས་དངུལ་གྱི་སྡེར་མ་བཅུ་གཉིས་དང་དངུལ་གྱི་ཕོར་བ་བཅུ་གཉིས། གསེར་གྱི་སྡེར་མ་བཅུ་གཉིས་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","སྡེར་མ་རེའི་སྲང་ནི་བརྒྱ་དང་སུམ་ཅུ་ཡིན་པ་དང་། ཕོར་བ་རེའི་སྲང་ནི་བདུན་ཅུ་ཡིན་ལ། སྣོད་ཆས་རྣམས་ཀྱི་དངུལ་ཐམས་ཅད་གནས་མཆོག་གི་སྲང་བཞིན་དུ་བསྡོམས་པས་དངུལ་སྲང་ཉིས་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","བདུག་སྤོས་ཀྱིས་གང་བའི་གསེར་གྱི་སྡེར་མ་བཅུ་གཉིས་ཏེ། སྡེར་མ་རེའི་སྲང་ནི་གནས་མཆོག་གི་སྲང་བཞིན་དུ་དངུལ་སྲང་བཅུ་ཡིན། སྡེར་མ་རྣམས་ཀྱི་གསེར་ཐམས་ཅད་བསྡོམས་པས་སྲང་བརྒྱ་དང་ཉི་ཤུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","སྦྱིན་སྲེག་གི་ཕྱིར་དུ་ཕུལ་བའི་ཕྱུགས་ནི་བསྡོམས་པས་གླང་ཐུག་བཅུ་གཉིས་དང་། ལུག་ཐུག་བཅུ་གཉིས། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་བཅུ་གཉིས་དང་དེ་དག་དང་མཉམ་དུ་ཕུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ། སྡིག་བཤགས་མཆོད་པ་རུ་ཕུལ་བའི་ར་ཕོ་བཅུ་གཉིས་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ཞི་བདེའི་མཆོད་པར་ཕུལ་བའི་ཕྱུགས་ནི་བསྡོམས་པས་གླང་ཐུག་ཉི་ཤུ་ཉེར་བཞི་དང་། ལུག་ཐུག་དྲུག་ཅུ། ར་ཕོ་དྲུག་ཅུ། ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་དྲུག་ཅུ་བཅས་ཡིན་ལ། དེ་དག་ནི་མཆོད་ཁྲིར་འབྱུག་སྣུམ་གྱིས་བྱུགས་རྗེས་མཆོད་ཁྲིར་བསྔོས་པའི་མཆོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","མོ་ཤེ་དཀོན་མཆོག་ཡ་ཝཱེ་དང་གསུང་གླེང་མཛད་པར་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་སོང་བའི་ཚེ། དཔང་མཛད་ཤུར་སྒམ་གྱི་སྟེང་དུ་ཡོད་པའི་ཐུགས་རྗེའི་བཞུགས་ཁྲི་དང་། ཀེ་རུབ་གཉིས་ཀའི་བར་ནས་རང་ལ་གསུང་གླེང་མཛད་པའི་སྒྲ་ཞིག་ཐོས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","ཁྱོད་ཀྱིས་ཨ་རོན་ལ་འདི་ལྟར། ཁྱོད་ཀྱིས་སྒྲོན་མེ་ཤོམ་དུས་སུ། སྒྲོན་མེ་བདུན་པོའི་འོད་ནི་སྒྲོན་སྟེགས་ཀྱི་མདུན་ཕྱོགས་སུ་སྣང་བར་བྱེད་དགོས་སྨྲོས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ཨ་རོན་གྱིས་དེ་བཞིན་བྱས་ཏེ། སྒྲོན་མེ་རྣམས་སྒྲོན་སྟེགས་ཀྱི་མདུན་དུ་བཤམས་ཤིང་། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་བཞིན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","སྒྲོན་སྟེགས་ཀྱི་བཟོ་ཚུལ་ནི་གསེར་བཙོ་མས་རྡུང་བཟོ་བྱས་པ་ཡིན་ཏེ། དེའི་ཞབས་ར་ནས་མེ་ཏོག་གི་བར་དུ་རྡུང་བཟོ་བྱས་ཡོད། དེ་ནི་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་བསྟན་པའི་མ་དཔེ་བཞིན་དུ་སྒྲོན་སྟེགས་བཟོས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ལེ་ཝི་པ་རྣམས་བདམས་ཏེ་གཙང་མར་བྱོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","དེ་དག་འདི་ལྟར་གཙང་མར་བྱེད་དགོས་ཏེ། སྡིག་པ་སེལ་བའི་ཆུ་ནི་ཁོ་ཚོའི་སྟེང་དུ་གཏོར་ཅིག ཡང་དེ་དག་ལ་སྤུ་གྲིས་རང་གི་ལུས་ཧྲིལ་པོའི་སྤུ་གཞར་དུ་འཇུག་པ་དང་། རང་གི་གོས་རྣམས་བཀྲུས་ནས་རང་ཉིད་གཙང་མར་བྱེད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","དེ་ནས་ཁོ་རྣམས་ལ་གླང་ཐུག་ཅིག་དང་དེ་དང་མཉམ་དུ་འབུལ་བའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་སྟེ་ཕྱེ་བཟང་པོ་སྣུམ་བསྲེས་མ་ལེན་དུ་འཇུག་པ་དང་། ཁྱོད་ཀྱིས་ཀྱང་སྡིག་བཤགས་མཆོད་པ་རུ་གླང་ཐུག་ཅིག་ལེན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་ཚུར་ཁྲིད་ནས། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཐམས་ཅད་བསྡུ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཁྲིད་འོངས་ནས། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཁོ་ཚོའི་སྟེང་ལ་ལག་པ་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","དེ་ནས་ཨ་རོན་གྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ལེ་ཝི་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གཡོབ་མཆོད་དུ་འབུལ་དགོས་ཏེ། དེ་དག་ལ་དཀོན་མཆོག་ཡ་ཝཱེའི་ལས་དོན་བསྒྲུབ་ཏུ་འཇུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ལེ་ཝི་པ་རྣམས་ཀྱིས་གླང་ཐུག་དེ་གཉིས་ཀྱི་མགོ་ལ་ལག་པ་བཞག་སྟེ། གླང་ཐུག་གཅིག་ནི་སྡིག་བཤགས་མཆོད་པ་དང་། གླང་ཐུག་ཅིག་ཤོས་ནི་སྦྱིན་སྲེག་ཏུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་ནས་ལེ་ཝི་པ་རྣམས་ཀྱི་སྡིག་པ་བཤག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ཡང་ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱི་མདུན་དུ་ལངས་སུ་བཅུག་ནས། དེ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གཡོབ་མཆོད་དུ་འབུལ་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","དེ་བཞིན་ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ལོགས་སུ་བཀར་ནས། དེ་དག་ང་རང་ལ་དབང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","དེ་ནས་ལེ་ཝི་པ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཞབས་ཕྱི་བསྒྲུབ་པར་འགྲོ་ཆོག་པ་དང་། ཁྱོད་ཀྱིས་དེ་དག་གཙང་མར་བྱས་ནས་གཡོབ་མཆོད་དུ་འབུལ་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ལེ་ཝི་པ་རྣམས་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ཡོངས་སུ་བདག་ལ་ཕུལ་བ་ཡིན་ཞིང་། ངས་དེ་དག་རང་གི་ཕྱིར་དུ་བདམས་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྐྱེས་འགོ་ཀུན་གྱི་ཚབ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ཡེས་ར་ཨེལ་པའི་ཁྲོད་ཀྱི་མི་ཕྱུགས་གང་ཡིན་ཡང་སྐྱེས་འགོ་ཐམས་ཅད་བདག་ལ་དབང་བ་སྟེ། བདག་གིས་ཨེ་ཅིབ་ཡུལ་ནས་སྐྱེས་འགོ་ཐམས་ཅད་བསད་པའི་ཉིན་དེར། དེ་དག་རང་གི་ཕྱིར་དུ་དམ་པར་བྱས་ཡོད་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","བདག་གིས་ཡེས་ར་ཨེལ་པའི་ཁྲོད་ཀྱི་སྐྱེས་འགོ་ཐམས་ཅད་ཀྱི་ཚབ་ཏུ་ལེ་ཝི་པ་རྣམས་བདམས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ལེ་ཝི་པ་རྣམས་ཨ་རོན་དང་དེའི་བུ་རྣམས་ལ་སྐྱེས་སུ་ཕུལ་བ་ཡིན། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་གནས་མཆོག་གི་ཉེ་སར་བཅར་བའི་དུས་སུ་དེ་རྣམས་ལ་ནད་ཡམས་མི་འབྱུང་བའི་ཆེད་དུ། དེ་དག་གིས་མཇལ་འཕྲད་གུར་མཆོག་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཞབས་ཕྱི་བསྒྲུབ་ཅིང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱིར་དུ་སྡིག་བཤགས་བྱེད་པའི་ཕྱིར་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཡོངས་ཀྱིས་ལེ་ཝི་པ་རྣམས་ལ་དེ་ལྟར་བྱས། དཀོན་མཆོག་ཡ་ཝཱེས་ལེ་ཝི་པ་རྣམས་ལ་དམིགས་ནས་མོ་ཤེ་ལ་བཀའ་ཅི་ལྟར་གནང་བ་ཡིན་ན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་བཞིན་བསྒྲུབས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ལེ་ཝི་པ་རྣམས་ཀྱིས་རང་རང་གཙང་མར་བྱས་ཤིང་གྱོན་གོས་རྣམས་ཀྱང་བཀྲུས། ཨ་རོན་གྱིས་དེ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་གཡོབ་མཆོད་དུ་ཕུལ་བ་དང་། དེ་དག་གཙང་མར་བཟོ་བའི་ཆེད་དུ་སྡིག་བཤགས་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","དེའི་རྗེས་སུ་ལེ་ཝི་པ་རྣམས་ནང་དུ་སོང་སྟེ་ཨ་རོན་དང་དེའི་བུ་རྣམས་ཀྱི་མདུན་དང་། མཇལ་འཕྲད་གུར་མཆོག་ཏུ་ཞབས་ཕྱི་བསྒྲུབས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་ལེ་ཝི་པ་རྣམས་ལ་བཀའ་ཅི་ལྟར་གནང་བ་ཡིན་ན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་དག་ལ་དེ་བཞིན་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","ལེ་ཝི་པ་རྣམས་ཀྱི་སྐོར་ནི་འདི་ལྟ་སྟེ། ལོ་ཉེར་ལྔ་དང་དེའི་ཡན་གྱི་མི་སུ་ཡིན་ཡང་ནང་དུ་ཡོང་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཞབས་ཕྱི་བསྒྲུབ་པའི་ལས་གྲལ་དུ་ཞུགས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","འོན་ཀྱང་། ལོ་ལྔ་བཅུར་སོན་པ་རྣམས་ཀྱིས་ཞབས་ཕྱི་སྒྲུབ་མཚམས་བཞག་ནས་ཞབས་ཕྱི་བསྒྲུབ་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","དེ་ཚོས་མཇལ་འཕྲད་གུར་མཆོག་ནང་དུ་རང་གི་སྤུན་ཟླ་རྣམས་ཀྱིས་རང་འགན་གཙང་སྒྲུབ་བྱེད་པར་མཐུན་རྐྱེན་སྦྱོར་བ་ལས་ཞབས་ཕྱི་བསྒྲུབ་མི་དགོས། ལེ་ཝི་པ་རྣམས་ཀྱི་ལས་འགན་ཐད་ཁྱོད་ཀྱིས་ཁོ་རྣམས་ལ་དེ་བཞིན་བྱེད་འོས་སོ་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","དེ་ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་ཏེ་ལོ་གཉིས་པའི་ཟླ་དང་པོ་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་སི་ནཱ་དབེན་སྟོང་དུ་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་གཏན་ལ་ཁེལ་བའི་དུས་སུ་པེ་སག་དུས་ཆེན་བསྲུང་དགོས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ཟླ་བ་འདིའི་ཚེས་བཅུ་བཞི་པའི་ཉིན་ས་སྲོས་ཀྱི་དུས་སུ། ཁྱོད་ཅག་གིས་གཏན་ལ་ཁེལ་བའི་དུས་སུ་དུས་ཆེན་དེ་བསྲུང་དགོས་ཤིང་། དུས་ཆེན་དེའི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་ཐམས་ཅད་བཞིན་ནོ་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","དེའི་ཕྱིར་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་པེ་སག་གི་དུས་ཆེན་བསྲུང་བར་བསྒོས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","དེ་དག་གིས་ཟླ་དང་པོའི་ཚེས་བཅུ་བཞིའི་ཉིན་ས་སྲོས་ཀྱི་དུས་སུ། སི་ནཱ་དབེན་སྟོང་དུ་པེ་སག་གི་དུས་ཆེན་བསྲུངས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་ཅི་ལྟར་བཀའ་བསྩལ་པ་བཞིན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེ་ལྟར་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ཡིན་ནའང་མི་འགའ་ཞིག་གིས་འདས་པོར་རེག་པའི་རྐྱེན་གྱིས་མི་གཙང་བར་གྱུར་ནས། ཉིན་དེར་པེ་སག་གི་དུས་ཆེན་བསྲུང་མ་ནུས་པས། ཁོ་རྣམས་ཉིན་མོ་དེར་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱི་དྲུང་དུ་ཡོང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","དེ་དག་གིས་མོ་ཤེ་ལ། འདས་པོར་རེག་པའི་རྐྱེན་གྱིས་ངེད་ཅག་མི་གཙང་བར་གྱུར་ནའང་། ཡེས་ར་ཨེལ་པ་རྣམས་དང་མཉམ་དུ་གཏན་ལ་ཁེལ་བའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཆོད་པ་འབུལ་བར་བཀག་པ་ཅི་ཞེས་ཞུས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","མོ་ཤེ་ཡིས་དེ་དག་ལ་འདི་ལྟར། ཁྱོད་ཅག་གིས་སྒུགས་དང་། ང་རང་སོང་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཀྱི་སྐོར་ལ་བཀའ་ཅི་ཞིག་གནང་བར་བལྟའོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཁྱོད་ཅག་དང་ཁྱོད་ཅག་གི་བུ་རབས་ཚ་རྒྱུད་ཁྲོད་དུ། སུ་ཞིག་འདས་པོར་རེག་ནས་མི་གཙང་བར་གྱུར་པའམ། ཡང་ན་རྒྱང་རིང་དུ་གནས་སྐོར་ལ་བསྐྱོད་ཀྱང་། དེས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་པེ་སག་གི་དུས་ཆེན་བསྲུང་དགོས་ན། ");
INSERT INTO bodn_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","དེ་དག་གིས་ཟླ་བ་གཉིས་པའི་ཚེས་བཅུ་བཞིའི་ཉིན་ས་སྲོས་ཀྱི་དུས་སུ་པེ་སག་གི་དུས་ཆེན་བསྲུང་དགོས་ལ། དུས་མཉམ་དུ་སྐྱུར་མེད་བག་ལེབ་དང་སྔོ་ཚོད་ཁ་མོ་བཟའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ཞོགས་པའི་བར་དུ་དེ་ལས་ཅི་ཡང་ལུས་སུ་འཇུག་མི་རུང་། ལུ་གུའི་རུས་པ་རྐང་གཅིག་ཀྱང་གཅོག་མི་རུང་ལ། དེ་དག་གིས་པེ་སག་དུས་ཆེན་གྱི་སྒྲིག་ཁྲིམས་ཐམས་ཅད་བཞིན་དུ་དུས་ཆེན་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","འོན་ཀྱང་མི་སུ་ཞིག་གཙང་མ་ཡིན་ཞིང་། གནས་སྐོར་གྱི་ལམ་དུ་ཡང་མེད་ཀྱང་པེ་སག་གི་དུས་ཆེན་བསྲུང་བ་སྣང་མེད་དུ་བསྐྱུར་ན། མི་དེས་གཏན་ལ་ཁེལ་བའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེའི་མཆོད་པ་མ་ཕུལ་བས། མི་དེས་རང་གི་སྡིག་པ་འཁུར་དགོས་ཤིང་རང་གི་མི་ཚོགས་ལས་འཕུད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","གལ་སྲིད་ཕྱི་མི་ཞིག་ཁྱོད་ཅག་གི་ཁྲོད་དུ་གནས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་པེ་སག་གི་དུས་ཆེན་བསྲུང་འདོད་ན། དེས་པེ་སག་གི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་བཞིན་དུ་བསྲུང་དགོས་པ་སྟེ། བྱེས་པ་དང་གཞིས་སྐྱེས་གང་ཡིན་ཡང་སྒྲིག་ཁྲིམས་ནི་གཅིག་མཚུངས་ཡིན་དགོས་ཞེས་སྨྲ་བར་བཀའ་བསྩལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","གུར་མཆོག་སྒྲེང་བའི་ཉིན་མོ་དེར། སྤྲིན་གྱིས་གུར་མཆོག་སྟེ་དཔང་པོའི་གུར་མཆོག་གཡོགས་པ་དང་། མཚན་མོ་ནས་ཞོགས་པའི་བར་དུ་གུར་མཆོག་སྟེང་གི་སྤྲིན་ནི་མེའི་དབྱིབས་དང་མཚུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","དུས་རྟག་ཏུ་དེ་བཞིན་བྱུང་སྟེ། ཉིན་མོར་གུར་མཆོག་སྤྲིན་གྱིས་གཡོགས་ཤིང་། མཚན་མོར་སྤྲིན་ནི་མེའི་དབྱིབས་དང་མཚུངས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ནམ་ཞིག་སྤྲིན་དེ་གུར་མཆོག་ནས་བཏེགས་པའི་ཚེ། ཡེས་ར་ཨེལ་པ་རྣམས་ལམ་དུ་ཆས་ཤིང་། སྤྲིན་གང་དུ་བཞུགས་པ་ཡིན་ན་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་གནས་དེར་སྒར་བཏབ་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ཡེས་ར་ཨེལ་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་ལམ་དུ་ཆས་པ་དང་། ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་སྒར་བཏབ། སྤྲིན་གུར་མཆོག་གི་སྟེང་དུ་དུས་ཡུན་ཅི་ཙམ་ལ་བཞུགས་པ་ཡིན་ན། ཁོ་རྣམས་ཀྱིས་ཀྱང་དེ་ཙམ་ལ་སྒར་བཏབ་ནས་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","གལ་སྲིད་སྤྲིན་གུར་མཆོག་གི་སྟེང་དུ་ཉིན་མང་པོར་བཞུགས་པའི་ཚེ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བརྩིས་ནས་ལམ་དུ་མི་ཆས་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","སྐབས་འགར་སྤྲིན་ཉིན་ཁ་ཤས་ཙམ་ལ་གུར་མཆོག་གི་སྟེང་དུ་བཞུགས་པ་དང་། དེ་དག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་སྒར་བཏབ་ཅིང་། ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་ལམ་དུ་ཆས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","སྐབས་འགར་སྤྲིན་མཚན་མོ་ནས་ཞོགས་པའི་བར་དུ་གནས་པ་དང་། ཞོགས་པར་སྤྲིན་བཏེགས་པ་ཙམ་དུ་ཁོ་རྣམས་ལམ་དུ་ཆས་ཤིང་། སྐབས་འགར་སྤྲིན་ཉིན་མོ་ནས་མཚན་མོའི་བར་དུ་གནས་པ་དང་། སྤྲིན་ཡར་བཏེགས་པའི་ཚེ་དེ་དག་ལམ་དུ་ཆས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","དེ་ནི་ཉིན་གཉིས་སམ་ཟླ་བ་གཅིག་གམ་ཡང་ན་ལོ་གཅིག་གི་རིང་། སྤྲིན་གུར་མཆོག་གི་སྟེང་དུ་བཞུགས་པའི་ཚེ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་སྒར་བཏབ་ནས་བསྡད་ཅིང་ལམ་དུ་མ་ཆས་པ་དང་། སྤྲིན་ཡར་བཏེགས་པའི་ཚེ་ཁོ་རྣམས་ལམ་དུ་ཆས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","དེ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་སྒར་བཏབ་པ་དང་། ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་ལམ་དུ་ཆས་ཤིང་། དེ་དག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་སྟེ་ཁོང་གིས་མོ་ཤེ་བརྒྱུད་ནས་གསུངས་པའི་བཀའ་བརྩིས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","ཁྱོད་ཀྱིས་དངུལ་གྱི་དུང་གཉིས་ཐོ་བས་བརྡུངས་ནས་བཟོ་དགོས་པ་དང་། དེ་ནི་མི་ཚོགས་ལ་འབོད་བརྡ་གཏོང་བ་དང་སྒར་ཕབ་ནས་ལམ་ལ་ཆས་སུ་འཇུག་པར་སྤྱད་ཆོག ");
INSERT INTO bodn_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","དུང་དེ་གཉིས་ཀ་བུས་ཚེ། མི་ཚོགས་ཡོངས་རྫོགས་ཁྱོད་ཀྱི་གམ་དུ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་འཛོམ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","གལ་སྲིད་དུང་གཅིག་ཁོ་ན་བུས་ཚེ། འགོ་དཔོན་རྣམས་ཏེ་ཡེས་ར་ཨེལ་གྱི་སྟོང་དཔོན་ཐམས་ཅད་ཁྱོད་ཀྱི་དྲུང་དུ་འཛོམ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ཁྱོད་ཅག་གིས་དུང་སྐད་ཆེན་པོར་བུས་ཚེ། ཤར་ཕྱོགས་སུ་ཡོད་པའི་སྒར་ཐམས་ཅད་ལམ་དུ་ཆས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ཁྱོད་ཅག་གིས་དུང་སྐད་ཆེན་པོ་ལན་གཉིས་པར་བུས་པ་ན། ལྷོ་ཕྱོགས་སུ་ཡོད་པའི་སྒར་ཐམས་ཅད་ལམ་དུ་ཆས་དགོས། སྒར་རྣམས་ལམ་ལ་ཆས་པར་དུང་སྐད་ཆེན་པོར་འབུད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","འོན་ཀྱང་མི་ཚོགས་བསྡུ་བའི་དུས་སུ་ཁྱོད་ཅག་གིས་དུང་འབུད་དགོས་ཀྱང་དེ་སྐད་ཆེན་པོར་འབུད་མི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ཨ་རོན་གྱི་བུ་རྒྱུད་དེ་མཆོད་དཔོན་རྣམས་ཀྱིས་དུང་འབུད་དགོས་པ་དང་། དེ་ནི་ཁྱོད་རྣམས་མི་རབས་ནས་མི་རབས་བར་གྱི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ཁྱོད་ཅག་གིས་ཡུལ་དེར་ཁྱོད་རྣམས་ལ་གཉའ་གནོན་བྱེད་པའི་དགྲ་དང་འཐབ་པའི་སྐབས་སུ། དུང་སྐད་ཆེན་པོར་བུས་དང་། ཁྱོད་རྣམས་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་ཐུགས་སུ་དྲན་པ་དང་། ཁྱོད་རྣམས་ཀྱི་དགྲ་དག་ལས་ཀྱང་ཐར་བར་མཛད་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","དེ་མིན་ཁྱོད་རྣམས་སྐྱིད་པའི་ཉིན་མོ་དང་གཏན་ལ་ཁེལ་བའི་དུས་ཆེན་རྣམས་དང་། གནམ་གང་བཅས་ཀྱི་དུས་སུ། ཁྱོད་ཅག་གིས་སྦྱིན་སྲེག་དང་ཞི་བདེའི་མཆོད་པ་རྣམས་འབུལ་དུས་སུ་དུང་འབུད་དགོས། དེ་ཐམས་ཅད་ཁྱོད་རྣམས་ཀྱི་དཀོན་མཆོག་གི་སྤྱན་སྔར་ཁྱོད་ཅག་ལ་དྲན་རྟེན་དུ་འགྱུར་ཞིང་། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ལོ་གཉིས་པའི་ཟླ་གཉིས་པའི་ཚེས་ཉི་ཤུ་ཉིན་ལ། སྤྲིན་དཔང་པོའི་གུར་མཆོག་གི་སྟེང་ནས་ཡར་བཏེགས་པའི་དུས་སུ། ");
INSERT INTO bodn_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ཡེས་ར་ཨེལ་པ་རྣམས་སི་ནཱ་དབེན་སྟོང་ནས་ལམ་དུ་ཆས་པ་ན། སྤྲིན་ཕཱ་རན་དབེན་སྟོང་དུ་བཞུགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་གནང་བའི་བཀའ་བཞིན་དུ་ཁོ་རྣམས་དང་པོར་ལམ་དུ་ཆས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱི་སྒར་ཁའི་དར་ཆེན་ནི་རང་གི་དམག་དཔུང་བཞིན་ཐོག་མར་ལམ་དུ་ཆས་པ་དང་། དམག་དཔུང་དེའི་འགོ་གཙོ་ནི་ཨ་མི་ནཱ་དབ་ཀྱི་བུ་ནཱ་སོན་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ཡེས་སི་ཀཱར་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཙུ་ཨར་གྱི་བུ་ནེ་ཐན་ཨེལ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ཟེ་བུ་ལུན་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཧེ་ལོན་གྱི་བུ་ཨེ་ལི་ཨབ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","གུར་མཆོག་མར་ཕབ་རྗེས། གེར་ཤོན་གྱི་བུ་རྒྱུད་དང་མཱ་རཱ་རེའེ་ཡི་བུ་རྒྱུད་རྣམས་ཀྱིས་གུར་མཆོག་ཁུར་ནས་ལམ་དུ་ཆས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","རུ་བེན་གྱི་སྒར་ཁའི་དར་ཆེན་ནི་རང་གི་དམག་དཔུང་བཞིན་ལམ་དུ་ཆས་པ་དང་། དེའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཤེ་དེ་ཨུར་གྱི་བུ་ཨེ་ལི་ཚུར་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","སི་མུ་ཨོན་ཚོ་པའི་འགོ་གཙོ་ནི་ཙུ་རེ་ཤད་དཱ་ཨིའི་བུ་ཤེ་ལུ་མེ་ཨེལ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","གཱ་རྡུ་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་དི་ཨོ་ཨེལ་གྱི་བུ་ཨེལ་ཡཱ་སབ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","དེ་ནས་ཀོ་ཧད་པ་རྣམས་ཀྱིས་རྫས་དམ་པ་རྣམས་ཁུར་ནས་ལམ་དུ་ཆས་ཤིང་། དེ་དག་མ་འབྱོར་བའི་སྔོན་དུ་སྔར་ཆས་པ་རྣམས་ཀྱིས་གུར་མཆོག་ཕུབ་ཟིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ཨེ་ཕཱར་ཡིམ་པ་རྣམས་ཀྱི་སྒར་ཁའི་དར་ཆེན་ནི་རང་གི་དམག་དཔུང་བཞིན་ལམ་དུ་ཆས་པ་དང་། དེའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཨམ་མེ་ཧུད་ཀྱི་བུ་ཨེ་ལི་ཤ་མཱ་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","མཱ་ན་ཤེ་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཕེ་དཱ་ཚུར་གྱི་བུ་གམ་ལི་ཨེལ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","པེན་ཡཱ་མེན་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་གིད་ཨོ་ནཱའི་བུ་ཨ་བི་ཏན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","མཇུག་མཐར་དཱན་གྱི་བུ་རྒྱུད་རྣམས་ཀྱི་སྒར་ཁའི་དར་ཆེན་ནི་སྒར་ཐམས་ཅད་ཀྱི་རྒྱབ་སྲུང་བྱས་ནས། རང་གི་དམག་དཔུང་བཞིན་ལམ་དུ་ཆས་པ་དང་། དེའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཨམ་མེ་ཤད་ད་ཨི་ཡི་བུ་ཨ་ཧི་ཨེ་ཟེར་ཡིན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ཨ་ཤེར་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཨོག་རན་གྱི་བུ་ཕཱ་གེ་ཨེལ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ནཱབ་ཐ་ལི་ཚོ་པའི་དམག་དཔུང་གི་འགོ་གཙོ་ནི་ཨེ་ནན་གྱི་བུ་ཨ་ཧི་རཱ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལམ་དུ་ཆས་པའི་སྐབས་སུ། རང་རང་གི་དམག་དཔུང་བཞིན་ལམ་དུ་ཆས་པའི་གོ་རིམ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","མོ་ཤེ་ཡིས་རང་གི་སྒྱུག་པོ་སྟེ་མིད༌ཡཱན་པ་རུའུ་ཨེལ་གྱི་བུ་ཧོ་པཱབ་ལ་འདི་ལྟར། རང་ཅག་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེས་ངས་ཁྱོད་རྣམས་ལ་གནང་བར་བྱའོ་ཞེས་གསུངས་པའི་ཡུལ་དེར་འགྲོ་བར་བྱ། ད་ལྟ་ཁྱེད་རང་ང་ཚོ་དང་མཉམ་དུ་འགྲོ་བར་ཞུ། ང་ཚོས་ཁྱེད་ལ་དྲིན་གཟོ་བར་བྱ། གང་ལ་ཞེ་ན། དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བདེ་སྐྱིད་ཀྱི་ཞལ་བཞེས་གནང་ཡོད་པས་སོ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ཧོ་པཱབ་ན་རེ། ང་རང་མི་འགྲོ། ང་ནི་རང་གི་ཡུལ་དང་གཉེན་ཉེའི་གམ་དུ་འགྲོ་བར་བྱ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","དེ་ནས་མོ་ཤེ་ཡིས་འདི་ལྟར། ཁྱེད་རང་ང་ཚོ་དང་མི་འབྲལ་བར་ཞུ། ང་ཚོས་དབེན་སྟོང་དུ་གུར་གང་ནས་ཕུབ་དགོས་པ་ཁྱེད་ཀྱིས་ཤེས་པས། ཁྱེད་ནི་ང་ཚོའི་མིག་ལྟ་བུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","གལ་སྲིད་ཁྱེད་རང་ང་ཚོ་དང་མཉམ་དུ་སོང་ཚེ། ཕྱིས་སུ་དཀོན་མཆོག་ཡ་ཝཱེས་ང་ཚོར་ལེགས་པོ་གང་ཞིག་གནང་བ་ཡིན་ན། ང་ཚོས་ཀྱང་དེ་ཡིས་ཁྱེད་ལ་དྲིན་གཟོ་བར་བྱའོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ཡེས་ར་ཨེལ་པ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་རི་ནས་ཆས་ཏེ། ཉིན་གསུམ་གྱི་ལམ་དུ་སོང་བ་དང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཞལ་ཆད་ཀྱི་ཤུར་སྒམ་ནི་ཉིན་གསུམ་གྱི་ལམ་དུ་བསྐྱོད་ཅིང་ཁོ་རྣམས་ལ་ངལ་གསོ་བའི་གནས་ཤིག་བཙལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ཁོ་རྣམས་ཀྱིས་སྒར་མར་ཕབ་སྟེ་ལམ་དུ་ཆས་པའི་དུས་སུ། ཉིན་མོ་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྲིན་ཕུང་ནི་དེ་དག་གི་སྟེང་དུ་བཞུགས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ཤུར་སྒམ་ཆས་པའི་ཚེ་ན། མོ་ཤེ་ཡིས་འདི་ལྟར། ཀྱེ་ཀྱེ་དཀོན་མཆོག་ཡ་ཝཱེ་བཞེངས་སུ་གསོལ། ། ཁྱེད་ཀྱི་དགྲ་རྣམས་ཕྱོགས་བཞིར་འཐོར་བ་དང་། ། ཁྱེད་ལ་སྡང་མཁན་ཁྱེད་དྲུང་འབྲོ་བར་ཤོག ། ཅེས་ཞུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ཤུར་སྒམ་བཞུགས་པའི་ཚེ། ཁོས་འདི་ལྟར། ཀྱེ་ཀྱེ་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱེད་ཉིད་ཡང་བསྐྱར་ཕེབས་པར་ཤོག ། ཡེས་ར་ཨེལ་པ་སྟོང་ཕྲག་མང་པོའི་དཀྱིལ་དུ་ཕེབས་པར་ཞུ། ། ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","དེ་ཡང་མི་ཚོགས་ཀྱིས་སྡུག་ཡུས་བཏོན་ཞིང་སྐད་ངན་དཀོན་མཆོག་ཡ་ཝཱེའི་སྙན་ལམ་དུ་སླེབས་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་དེ་གསན་ནས་ཐུགས་ཁྲོས་པར་གྱུར། དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་ནི་དེ་དག་གི་ཁྲོད་དུ་འབར་ཏེ་སྒར་གྱི་མཐའ་རྣམས་འགེམས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","མི་ཚོགས་ཀྱིས་མོ་ཤེ་ལ་ཞུ་འབོད་བྱས་པ་དང་། མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་བཏབ་ཅིང་མེ་ཞི་བར་གྱུར་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","དེ་དག་གི་ཁྲོད་དུ་དཀོན་མཆོག་ཡ་ཝཱེའི་མེ་འབར་བ་ཡིན་པས་ཡུལ་དེའི་མིང་ལ་ཐབ་ཨེ་རཱ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","དེ་དག་ཁྲོད་ཀྱི་རིགས་རྒྱུད་འདྲེས་མ་རྣམས་ཀྱིས་འདོད་རྔམ་བསྐྱེད་ཅིང་། ཐ་ན་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཀྱང་ངུ་བཞིན་དུ། སུས་ང་ཚོ་ལ་ཁ་ཟས་སུ་ཤ་སྟེར་བར་འགྱུར་རམ། ");
INSERT INTO bodn_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ང་ཚོས་ཨེ་ཅིབ་ཡུལ་དུ་ཉ་དང་། ཁི་ར་དང་། ག་གོན་དང་། རི་སྒོག་དང་། ཙོང་དང་། སྒོག་པ་བཅས་ནི་རིན་མི་དགོས་པར་ཟ་རྒྱུ་ཡོད་པ་དྲན་བྱུང་། ");
INSERT INTO bodn_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ད་ནི་ངེད་རྣམས་ཡི་ག་ཆད་པ་སྟེ། མན་ནཱ་ལས་གཞན་ཅི་ཡང་མཐོང་རྒྱུ་མི་འདུག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","མན་ནཱ་དེ་ནི་སྔོ་སྨན་འུ་སུའི་འབྲུ་གུ་ལྟར་ཡིན་ཞིང་། པེ་དེལ་ཡོན་ཞེས་པའི་ཐང་ཆུ་དང་མཚུངས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","མི་ཚོགས་མཐའ་འཁོར་དུ་སོང་ནས་མན་ནཱ་བསྡུས་པ་དང་རང་འཐག་གིས་བཏགས་པའམ་གཏུན་ཁུང་དུ་བརྡུངས་ནས། རྫ་ཁོག་ནང་དུ་བཙོས་པའམ་བག་ལེབ་བཟོས་ཤིང་། དེའི་བྲོ་བ་ནི་བག་ལེབ་སྣུམ་བཙོས་དང་འདྲ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","མཚན་མོར་སྒར་གྱི་སྟེང་དུ་ཟིལ་པ་ཆགས་པའི་ཚེ་མན་ནཱ་ཡང་བབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","མོ་ཤེ་ཡིས་མི་རྣམས་ཀྱིས་ཁྱིམ་རྒྱུད་སོ་སོའི་གུར་སྒོ་ནས་ངུ་འབོད་བྱེད་པ་ཐོས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེ་ཐུགས་རབ་ཏུ་ཁྲོས་པ་དང་། མོ་ཤེ་ཡང་མི་དགའ་བར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། ཁྱེད་ཀྱིས་ཉིད་ཀྱི་ཞབས་ཕྱི་སྡུག་ལ་སྦྱར་དོན་ཅི། ཁྱེད་ཀྱི་སྤྱན་སྔར་བདག་ལ་ཐུགས་རྗེ་མ་ཐོབ་པ་ཅི། མི་ཚོགས་ཐམས་ཅད་ལ་བདག་སྐྱོང་བྱེད་པའི་ཁུར་པོ་ང་ལ་བཀལ་བ་ཅི། ");
INSERT INTO bodn_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","མི་ཚོགས་འདི་ནི་ངའི་མངལ་དུ་སྦྲུམས་ནས་ང་ལས་སྐྱེས་པ་ཡིན་ནམ། ཁྱེད་ཀྱིས་ང་ལ་འདི་སྐད་དུ། བུ་སྙོར་མས་གསོས་པའི་ཕྲུ་གུ་ལྟར་དེ་དག་ངའི་པང་ལ་བཟུང་ནས། ཁྱེད་ཀྱིས་ཁོ་རྣམས་ཀྱི་ཕ་མེས་ལ་གནང་བར་མནའ་བཞེས་པའི་ཡུལ་དེར་ཁྱེར་ཅིག་ཅེས་གསུངས་པ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ངས་མི་དེ་ཐམས་ཅད་ཀྱི་ཁ་ཟས་སུ་ཤ་གང་ནས་རྙེད་པར་འགྱུར་རམ། དེ་དག་གིས་ངུ་འབོད་བྱེད་ཀྱིན་ང་ལ་ཁྱོད་ཀྱིས་ང་ཚོར་བཟའ་རྒྱུའི་ཤ་བྱིན་ཅིག་ཅེས་སྨྲའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","མི་ཚོགས་འདིར་བདག་སྐྱོང་བྱེད་པའི་འགན་ཁུར་ནི་ལྗིད་དྲགས་པས། ང་གཅིག་པུས་དེ་འཁུར་མི་ནུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ཁྱེད་ཀྱིས་ང་ལ་འདི་ལྟར་མཛད་པ་ཡིན་པས། གལ་སྲིད་ཁྱེད་ཀྱི་སྤྱན་སྔར་བདག་ལ་ཐུགས་རྗེ་ཐོབ་པ་ཡིན་ན། ངས་རང་གི་སྡུག་བསྔལ་མི་མཐོང་བའི་ཆེད་དུ་ཁྱེད་ཀྱིས་དངོས་སུ་ང་རང་གསོད་པར་མཛོད་ཅེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་ལས་བདག་ལ་མི་བདུན་ཅུ་སྟེ། ཁྱོད་ཀྱིས་ངོ་ཤེས་པའི་མི་ཚོགས་ཁྲོད་ཀྱི་རྒན་པོ་དང་འགོ་དཔོན་རྣམས་ཁྱོད་དང་མཉམ་དུ་འགྲེང་བར་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་ཁྲིད་ཤོག ");
INSERT INTO bodn_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","བདག་ཡུལ་དེར་མར་འོངས་ནས་ཁྱོད་དང་གླེང་མོལ་བྱེད་ཅིང་། ཁྱོད་ཀྱི་སྟེང་དུ་ཡོད་པའི་ཐུགས་ཉིད་ནི་དེ་དག་གི་སྟེང་ལའང་འཇོག་པར་བྱ། མི་ཚོགས་ལ་བདག་སྐྱོང་བྱེད་པའི་འགན་ཁྱོད་གཅིག་པུས་འཁུར་མི་དགོས་པར་དེ་དག་གིས་ཁྱོད་དང་མཉམ་དུ་འཁུར་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ཁྱོད་ཀྱིས་མི་ཚོགས་ལ་འདི་ལྟར། སང་ཉིན་ཤ་བཟའ་བའི་ཕྱིར་དུ་ཁྱོད་ཅག་གིས་རང་ཉིད་དམ་པར་སྲུངས་ཤིག ཅི་ལ་ཞེ་ན། ཁྱོད་ཅག་གིས་ངུ་འབོད་བྱེད་ཀྱིན་དཀོན་མཆོག་ཡ་ཝཱེའི་སྙན་ལམ་དུ། སུ་ཞིག་གིས་ངེད་རྣམས་ལ་ཤ་སྟེར་རམ། ངེད་རྣམས་ཨེ་ཅིབ་ཡུལ་དུ་ཡོད་དུས་ཅི་འདྲ་སྐྱིད་ཨང་ཞེས་ཞུས་པས། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་ཅག་ལ་བཟའ་རྒྱུའི་ཤ་གནང་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","དེ་ནི་ཁྱོད་ཅག་གིས་ཉིན་གཅིག་དང་གཉིས་སམ། ཡང་ན་ཉིན་ལྔ་དང་བཅུའམ། ཡང་ན་ཉིན་ཉི་ཤུ་ཙམ་ལ་བཟའ་བ་མ་ཡིན་པར། ");
INSERT INTO bodn_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ཁྱོད་ཅག་གིས་ཟླ་ཧྲིལ་པོ་གཅིག་ལ་བཟའ་བ་དང་། ཤ་ནི་ཁྱོད་ཚོའི་སྣ་ཁུང་ལས་འཐོན་ཞིང་དེ་ལ་ཞེ་མེར་བའི་བར་དུ་བཟའ་བར་འགྱུར། ཅི་ལ་ཞེ་ན། ཁྱོད་ཅག་གིས་ཁྱོད་ཚོའི་དཀྱིལ་དུ་བཞུགས་པའི་དཀོན་མཆོག་ཡ་ཝཱེ་སྣང་མེད་དུ་བསྐྱུར་ཏེ་ཁོང་གི་དྲུང་དུ་ངུ་འབོད་བྱེད་ཀྱིན། ངེད་ཅག་ཅིའི་ཕྱིར་ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་པ་ཡིན་ནམ་ཞེས་སྨྲས་པའི་ཕྱིར་རོ་ཞེས་སྨྲོས་ཤིག་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","དེ་ནས་མོ་ཤེ་ཡིས་འདི་ལྟར། ང་དང་མཉམ་དུ་གནས་པའི་མི་ཚོགས་འདི་ལས་རྐང་ཐང་ལ་སྐྱོད་མཁན་འབུམ་དྲུག་ཡོད་ཀྱང་། ཁྱེད་ཀྱིས་ད་དུང་བདག་གིས་དེ་དག་ལ་ཟླ་གཅིག་གི་རིང་ལ་བཟའ་རྒྱུའི་ཤ་གནང་བར་བྱ་ཞེས་གསུངས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ར་ལུག་གི་ཁྱུ་དང་བ་ཁྱུ་ཐམས་ཅད་བཤས་ན་དེ་དག་གི་བཟའ་རྒྱུར་འདང་བ་ཡིན་ནམ། ཡང་ན་རྒྱ་མཚོ་ནང་གི་ཉ་ཐམས་ཅད་བསྡུས་ན་དེ་དག་གི་བཟའ་རྒྱུར་འདང་བ་ཡིན་ཞེས་ཞུས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཡ་ཝཱེའི་ལག་ངར་ཇེ་ཐུང་དུ་སོང་བ་ཡིན་ནམ ། ད་ལྟ་ངས་སྨྲས་པ་བཞིན་དུ་འབྱུང་མིན་ཁྱོད་ཀྱིས་མཐོང་བར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","དེ་ནས་མོ་ཤེ་ཕྱི་རོལ་ཏུ་སོང་སྟེ་དཀོན་མཆོག་ཡ་ཝཱེས་གསུངས་པའི་བཀའ་མི་ཚོགས་ལ་སྨྲས་པ་དང་། ཡང་མི་ཚོགས་ཁྲོད་ཀྱི་རྒན་པོ་རྣམས་ལས་མི་བདུན་ཅུ་བསྡུས་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་མཐའ་འཁོར་ལ་འགྲེང་དུ་བཅུག ");
INSERT INTO bodn_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་སྤྲིན་གྱི་ནང་ནས་མར་ཕེབས་ཏེ་མོ་ཤེ་ལ་གསུང་གླེང་མཛད་པ་དང་། ཁོའི་སྟེང་དུ་ཡོད་པའི་ཐུགས་ཉིད་རྒན་པོ་བདུན་ཅུའི་སྟེང་དུ་བཞག་པ་ལ། ཐུགས་ཉིད་དེ་དག་གི་སྟེང་དུ་བཞུགས་པའི་དུས་སུ་དེ་དག་གིས་ལུང་བསྟན་གནང་བ་ཡིན་མོད། འོན་ཀྱང་དེའི་རྗེས་སུ་ཡང་བསྐྱར་ལུང་མ་བསྟན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","སྐབས་དེར་མི་གཉིས་ད་དུང་སྒར་གྱི་ནང་དུ་ལུས་ཡོད་ཅིང་། གཅིག་གི་མིང་ལ་ཨེལ་དཱད་དང་ཅིག་ཤོས་ཀྱི་མིང་ལ་མེ་དཱད་ཟེར་བ་དང་། ཐུགས་ཉིད་ནི་དེ་གཉིས་ཀྱི་སྟེང་དུའང་བཞུགས། དེ་གཉིས་ཀའང་རྒན་པོ་རྣམས་ཀྱི་གྲས་སུ་ཡོད་ན་ཡང་ཁོ་གཉིས་མཇལ་འཕྲད་གུར་མཆོག་ཡོད་སར་མ་སོང་ལ། དེ་ཚོས་སྒར་གྱི་ནང་དུ་ལུང་བསྟན་གནང་། ");
INSERT INTO bodn_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","དེ་ནས་གཞོན་ནུ་ཞིག་རྒྱུགས་འོངས་ནས་མོ་ཤེ་ལ། ཨེལ་དཱད་དང་མེ་དཱད་གཉིས་ཀྱིས་སྒར་གྱི་ནང་དུ་ལུང་སྟོན་བཞིན་འདུག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","མོ་ཤེའི་ཞབས་ཕྱི་དང་ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་སྟེ་མོ་ཤེ་ཡི་ལག་རོགས་དར་མ་དེ་ན་རེ། ང་ཡི་ཇོ་བོ་མོ་ཤེ་ལགས། ཁྱེད་ཀྱིས་དེ་གཉིས་འགོག་པར་མཛོད་ཅེས་ཞུས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","མོ་ཤེ་ཡིས་དེ་ལ། ཁྱོད་ཀྱིས་བདག་གི་ཆེད་དུ་ཕྲག་དོག་བྱེད་དམ། དཀོན་མཆོག་ཡ་ཝཱེའི་མི་ཚོགས་ཐམས་ཅད་ལུང་སྟོན་པ་ཡིན་ན་ཅིས་མི་རུང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོང་གི་ཐུགས་ཉིད་ནི་དེ་དག་གི་སྟེང་དུ་གནང་བར་ཤོག་ཅེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","དེ་ནས་མོ་ཤེ་དང་ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་སྒར་དུ་ཕྱིར་ལོག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་རླུང་ཞིག་བྱུང་སྟེ། རྒྱ་མཚོའི་ངོས་ནས་སྲེག་པ་ཁུར་འོངས་ཤིང་སྒར་གྱི་ས་ལ་བབས་པ་དང་། སྲེག་པས་སྒར་བསྐོར་ཏེ་ཚུར་ལ་ཉིན་གཅིག་གི་ལམ་ཐག་དང་ཕར་ལ་ཉིན་གཅིག་གི་ལམ་ཐག་ཡོད་ཅིང་། ས་ངོས་ནས་མཐོ་ཚད་ཁྲུ་གཉིས་ཙམ་ལ་སླེབས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","མི་ཚོགས་ལངས་ནས་ཉིན་གང་དང་མཚན་གང་། དེའི་ཕྱི་ཉིན་ཉིན་གང་བཅས་ལ་སྲེག་པ་བསྡུས་ཤིང་། ཉུང་མཐའ་ཡང་ཁལ་བཅུ་བསྡུས་ནས་སྒར་གྱི་ཕྱོགས་བཞིར་བཀྲམས། ");
INSERT INTO bodn_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ཤ་ནི་དེ་དག་གི་སོ་བར་དུ་ཡོད་ཅིང་ད་དུང་ལྡད་མ་ཚར་བའི་མཚམས་དེར། དཀོན་མཆོག་ཡ་ཝཱེའི་ཐུགས་ཁྲོ་མི་ཚོགས་ཀྱི་སྟེང་དུ་འབར་ཞིང་། ནད་ཡམས་དྲག་པོས་མི་ཚོགས་ལ་བརྡུངས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","དེའི་ཕྱིར་གནས་དེའི་མིང་ལ་ཀིབ་རོད་ཧད་ཐཱ་ཨ་ཝ་ཞེས་བཏགས། གང་ལ་ཞེ་ན། འདོད་རྔམ་བཅངས་པའི་མི་རྣམས་དེ་རུ་དུར་ལ་སྦས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","དེ་ནས་མི་ཚོགས་ཀིབ་རོད་ཧད་ཐཱ་ཨ་ཝ་ནས་ལམ་དུ་ཆས་ཏེ་ཧ་ཚི་རོད་ཀྱི་ཕྱོགས་སུ་སོང་བ་དང་། ཧ་ཚི་རོད་དུ་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","དེ་ཡང་མོ་ཤེ་ཡིས་གུ་ཤའི་བུད་མེད་ཅིག་ཆུང་མར་བླངས་པས། གུ་ཤའི་བུད་མེད་དེའི་རྐྱེན་གྱིས་མིར་ཡམ་དང་ཨ་རོན་གཉིས་ཀྱིས་ཁོ་ལ་རྒོལ་གཏམ་བཏང་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","དེ་གཉིས་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ཁོ་ན་བརྒྱུད་ནས་གསུང་གླེང་མཛད་པ་ཡིན་ནམ། ཁོང་གིས་ང་ཚོ་བརྒྱུད་ནས་ཀྱང་གསུང་གླེང་མཛད་པ་མ་ཡིན་ནམ་ཞེས་སྨྲས་པ་དཀོན་མཆོག་ཡ་ཝཱེས་གསན་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ད་ལྟའི་ཆར་ཡང་མོ་ཤེ་ནི་ཤིན་ཏུ་ཁེངས་ཆུང་ཡིན་ཏེ། ས་སྟེང་གི་མི་ཐམས་ཅད་ལས་ཁེངས་ཆུང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","གློ་བུར་ཉིད་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་དང་མིར་ཡམ་བཅས་ལ་འདི་སྐད་དུ། ཁྱོད་གསུམ་པོ་ཕྱི་རུ་ཐོན་ཏེ་མཇལ་འཕྲད་གུར་མཆོག་གི་རྩར་སོང་ཞིག་ཅེས་བཀའ་གནང་བས། ཁོ་གསུམ་པོ་ཕྱི་རོལ་ཏུ་ཐོན། ");
INSERT INTO bodn_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","དེའི་ཚེ་དཀོན་མཆོག་ཡ་ཝཱེ་སྤྲིན་གྱི་ཀ་བ་ཞིག་གི་ནང་ནས་མར་ཕེབས་ཏེ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་བཞེངས་བསྡད་པ་དང་། ཨ་རོན་དང་མིར་ཡམ་གཉིས་བོས་པར་མཛད་པས། དེ་གཉིས་ཁོང་གི་ཉེ་སར་ཕྱིན་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ཁོང་གིས་འདི་སྐད་དུ། ད་ཀོ་ཁྱོད་རྣམས་ང་ཡི་གཏམ་ལ་ཉོན། ། ཁྱོད་ཅག་ཁྲོད་དུ་ལུང་སྟོན་ཡོད་གྱུར་ན། ། ཡ་ཝཱེ་བདག་གིས་ཞལ་གཟིགས་བརྒྱུད་དེ་ནི། ། རང་ཉིད་ཁོ་ལ་མངོན་པར་བྱེད་པ་དང་། ། རྨི་ལམ་ཁྲོད་དུ་དེ་ལ་གཏམ་སྨྲ་ངེས། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","འོན་ཀྱང་བདག་གི་ཞབས་ཕྱི་མོ་ཤེ་ནི། ། དེ་ལྟར་མིན་གྱི་དེ་ལྟར་ག་ལ་ཡིན། ། ཁོ་ངའི་ཁྱིམ་མི་ཡོངས་སུ་བློ་སེམས་དཀར། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","བདག་གིས་ཁོ་ལ་དངོས་སུ་གཏམ་སྨྲ་ཞིང་། ། གབ་ཚིག་རྣམ་པས་མ་ཡིན་མངོན་སུམ་སྨྲ། ། ཁོས་ནི་ཡ་ཝཱེའི་གཟུགས་བརྙན་མཇལ་བ་འོ། ། ཁྱོད་ཅག་ང་ཡི་ཞབས་ཕྱི་མོ་ཤེ་ལ། ། རྒོལ་གཏམ་གཏོང་བར་མི་འཇིགས་རྒྱུ་མཚན་ཅི། ། ཞེས་གསུངས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","དཀོན་མཆོག་ཡ་ཝཱེ་ཁོ་གཉིས་ལ་ཐུགས་ཁྲོས་ཏེ་ཕེབས་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","སྤྲིན་མཇལ་འཕྲད་གུར་མཆོག་གི་སྟེང་ནས་ཡར་དྲངས་པའི་མུ་ལ། ལྟོས་དང་། མིར་ཡམ་ལ་མཛེ་ནད་བྱུང་སྟེ་ཁ་བ་ལྟར་དཀར་པོར་གྱུར་ཅིང་། ཨ་རོན་ཁ་ཕྱིར་འཁོར་ནས་མིར་ཡམ་ལ་བལྟས་པ་དང་། ཀྱེ་ཧོ། ཁོ་མོར་མཛེ་ནད་བྱུང་བ་མཐོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","དེ་ནས་ཨ་རོན་གྱིས་མོ་ཤེ་ལ། ཇོ་བོ་ལགས། ང་ཚོ་བླུན་པོར་གྱུར་ནས་སྡིག་པ་བྱས་པའི་རྐྱེན་གྱིས་ང་ཚོར་སྡིག་པ་མི་འགེལ་བར་མཛོད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ཁྱེད་ཀྱིས་ཁོ་མོ་ཨ་མའི་མངལ་ནས་ཤ་ཕྱེད་ཀ་རུལ་ནས་ཐོན་པ་བཞིན་དང་། ཤི་ཚར་བ་ལྟར་མི་གནང་རོགས་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་གསོལ་བ་བཏབ་པ་སྟེ། ཀྱེ་དཀོན་མཆོག་ལགས། ཁྱེད་ཀྱིས་ཁོ་མོ་གསོ་བར་མཛོད་ཅེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། གལ་སྲིད་ཁོ་མོའི་ཕ་ཡིས་དེའི་གདོང་ལ་མཆིལ་མ་གཏོར་ན། ཁོ་མོ་ཉིན་བདུན་གྱི་རིང་ལ་ངོ་ཚར་སྦྱར་བ་མ་ཡིན་ནམ། ད་ནི་ཁོ་མོ་ཉིན་བདུན་གྱི་རིང་ལ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་འགོག་དགོས། དེའི་རྗེས་སུ་ཕྱིར་ཡོང་ཆོག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","དེ་ནས་མིར་ཡམ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཉིན་བདུན་གྱི་རིང་ལ་བཀག་ཅིང་། མིར་ཡམ་ཕྱིར་ཁྲིད་ཡོང་བའི་བར་དུ་མི་ཚོགས་ལམ་དུ་མ་ཆས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","དེའི་རྗེས་སུ་མི་ཚོགས་ཧ་ཚི་རོད་ནས་ལམ་དུ་ཆས་པ་དང་། ཕཱ་རན་ཞེས་པའི་དབེན་སྟོང་ནས་སྒར་བཏབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","ཁྱོད་ཀྱིས་ངས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྦྱིན་པའི་ཀ་ན་ཨན་ཡུལ་དུ་མྱུལ་མ་ཐོངས་ཤིག ཕ་མེས་རྣམས་ཀྱི་ཚོ་པ་བཞིན་དུ་ཚོ་པ་རེ་ནས་མི་རེ་གཏོང་བ་དང་། རེ་རེ་བཞིན་འགོ་དཔོན་ཡིན་དགོས་ཞེས་བཀའ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","དེར་བརྟེན་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ། ཕཱ་རན་དབེན་སྟོང་ནས་ཁོ་རྣམས་བཏང་བ་དང་། དེ་དག་ཐམས་ཅད་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་འགོ་དཔོན་ཡིན་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","དེ་དག་གི་མིང་ནི་འདི་ལྟ་སྟེ། རུ་བེན་ཚོ་པ་ནས་ཟག་ཀུར་གྱི་བུ་ཤཱ་མུ་ཨ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","སི་མུ་ཨོན་ཚོ་པ་ནས་ཧོ་རིའི་བུ་ཤཱ་ཕད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ཡ་ཧུ་དཱ་ཚོ་པ་ནས་ཡེ་ཕུན་ནེའི་བུ་ཀཱ་ལེབ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ཡེས་སི་ཀཱར་ཚོ་པ་ནས་ཡོ་སེབ་ཀྱི་བུ་ཡི་གལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ཨེ་ཕཱར་ཡིམ་ཚོ་པ་ནས་ནུན་གྱི་བུ་ཧོ་ཤེ་ཨ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","པེན་ཡཱ་མེན་ཚོ་པ་ནས་རཱ་ཕུའི་བུ་ཕལ་ཏི་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ཟེ་བུ་ལུན་ཚོ་པ་ནས་སོ་དིའི་བུ་གད་དི་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ཡོ་སེབ་ཚོ་པ་སྟེ་མཱ་ན་ཤེ་ཚོ་པ་ནས་སུ་སེའི་བུ་གད་དི་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","དཱན་ཚོ་པ་ནས་གཱ་མལ་ལིའི་བུ་ཨམ་མེ་ཨེལ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ཨ་ཤེར་ཚོ་པ་ནས་མེའ་ཀཱ་ཨེལ་གྱི་བུ་སེ་ཐུར་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ནཱབ་ཐ་ལི་ཚོ་པ་ནས་ཝོ་ཕེ་སིའི་བུ་ནག་པི་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","གཱ་རྡུ་ཚོ་པ་ནས་མ་ཀིའི་བུ་གཱ་ཨུ་ཨེལ་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","དེ་དག་ནི་མོ་ཤེ་ཡིས་ཡུལ་དེར་མྱུལ་མར་བཏང་བའི་མི་རྣམས་ཀྱི་མིང་ཡིན། མོ་ཤེ་ཡིས་ནུན་གྱི་བུ་ཧོ་ཤེ་ཨའི་མིང་ལ་ཡོ་ཤུ་ཨ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","མོ་ཤེ་ཡིས་དེ་རྣམས་ཀ་ན་ཨན་ཡུལ་གྱི་མྱུལ་མར་གཏོང་བའི་སྐབས་སུ། དེ་དག་ལ་འདི་ལྟར། ཁྱོད་ཅག་འདི་ནས་ཡར་ནེ་གུབ་ཡུལ་དུ་འགྲོ་བ་དང་། དེ་ནས་ཡར་རི་ཁུལ་དུ་སོང་ཞིག ");
INSERT INTO bodn_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ཡུལ་དེ་ཇི་ལྟ་བུ་ཡིན་པ་དང་། དེར་གནས་པའི་མི་རྣམས་ཀྱི་སྟོབས་ཀྱི་ཆེ་ཆུང་། མི་ཡི་མང་ཉུང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","དེ་རྣམས་སྡོད་པའི་ཡུལ་ནི་བཟང་ངན་ཅི་ལྟ་བུ་ཡིན་པ། དེ་དག་གནས་པའི་གྲོང་ཁྱེར་རྣམས་སྒར་རམ་བཙན་རྫོང་ཡིན་པ། ");
INSERT INTO bodn_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ས་ཆ་དེ་ནི་ས་བཅུད་འཛོམས་སམ་ས་རྒྱུ་ཞན་པ། དེར་ཤིང་སྡོང་ཡོད་མེད་བཅས་ལ་ལྟོས་ཤིག སྙིང་སྟོབས་ཆེན་པོ་བསྐྱེད་ནས་ཡུལ་དེའི་ཤིང་འབྲས་འགའ་ཤས་ཁྱེར་ཤོག་ཅེས་སྨྲས་ཤིང་། དེ་ནི་རྒུན་འབྲུམ་ཐོག་མར་སྨིན་པའི་དུས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","དེ་ནས་ཁོ་རྣམས་ཡར་སོང་སྟེ། ཟིན་ཞེས་པའི་དབེན་སྟོང་ནས་ལེ་པོ་ཧ་མཱད་ཡུལ་གྱི་རེ་ཧོབ་འགག་བར་དུ་ཡུལ་དེར་ལྐོག་ལྟ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ཁོ་རྣམས་ཡར་ནེ་གུབ་ཡུལ་དུ་སོང་སྟེ་ཧེབ་རོན་ལ་སླེབས་པ་དང་། ཨ་ནག་གི་བུ་རྒྱུད་དེ་ཨ་ཧི་མན་དང་ཤེ་ཤཱ་ཨི། ཐལ་མ་ཨི་བཅས་ཡུལ་དེར་ཡོད་ཅིང་། ཧེབ་རོན་ནི་ཨེ་ཅིབ་ཡུལ་གྱི་ཚོ་ཨན་ལས་ཀྱང་ལོ་བདུན་གྱི་ཡར་སྔོན་དུ་ཚུགས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","དེ་ནས་ཁོ་རྣམས་ཨེ་ཤཱ་ཀོལ་ལུང་པར་སླེབས་པ་དང་། དེར་རྒུན་ཤིང་གི་ཡལ་གར་རྒུན་འབྲུམ་ཆུན་པོ་གཅིག་རང་ཡོད་པ་དེ་བཅད་ནས། མི་གཉིས་ཀྱིས་དེ་གདང་ལ་ཁུར་ནས་ཐོན་ཞིང་། སེ་འབྲུ་དང་སེ་ཡབ་འགའ་ཤས་ཀྱང་ཁྱེར་ཡོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཡུལ་དེ་ནས་བཅད་འོངས་པའི་རྒུན་འབྲུམ་ཆུན་པོ་དེའི་རྐྱེན་གྱིས་གནས་དེའི་མིང་ལ་ཨེ་ཤཱ་ཀོལ་ལུང་པ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ཉིན་ཞག་བཞི་བཅུ་སོང་བའི་མཐར། ཁོ་རྣམས་ཀྱིས་ཡུལ་དེར་ལྐོག་ལྟ་བྱས་ཚར་ནས་ཕྱིར་ལོག་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ཁོ་རྣམས་ཕཱ་རན་དབེན་སྟོང་གི་ཀཱ་དེའེ་ཤཱ་ཡུལ་དུ་མོ་ཤེ་དང་། ཨ་རོན་དང་། ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཡོངས་ཀྱི་མདུན་དུ་ཡོང་ནས་དེ་དག་ལ་གནས་ཚུལ་བརྗོད་ཅིང་། ཡང་ཡུལ་དེའི་ཤིང་འབྲས་དེ་རྣམས་ལ་བསྟན། ");
INSERT INTO bodn_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","དེ་དག་གིས་མོ་ཤེ་ལ་འདི་ལྟར། ངེད་ཅག་ཁྱེད་ཀྱིས་བཏང་བའི་ཡུལ་དེར་ཕྱིན་པ་དང་། དེ་ནི་དངོས་གནས་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་ཞིག་སྟེ། འདི་ནི་ས་ཆ་དེའི་ཤིང་འབྲས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","འོན་ཀྱང་ཡུལ་དེར་གནས་པའི་མི་རྣམས་ནི་སྟོབས་ཆེ་བ་དང་། གྲོང་ཁྱེར་དག་ནི་སྲ་ཞིང་བརྟན་ལ་ཤིན་ཏུ་ཆེན་པོ་འདུག ངེད་ཅག་གིས་དེར་ཨ་ནག་གི་བུ་རྒྱུད་རྣམས་ཀྱང་མཐོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","དེའི་ནེ་གུབ་ཡུལ་དུ་ཨ་མཱད་ལེག་པ་རྣམས་ཆགས་ཡོད་པ་དང་། ཧེད་པ་དང་ཡེ་བུ་སི་པ་དང་ཨེ་མོར་པ་རྣམས་རི་ཁུལ་དུ་གནས་ཡོད། ཀ་ན་ཨན་པ་རྣམས་རྒྱ་མཚོའི་འགྲམ་དང་ཡོར་དན་གཙང་པོའི་ཕྱོགས་སུ་ཆགས་ཡོད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","དེ་ནས་ཀཱ་ལེབ་ཀྱིས་མོ་ཤེའི་མདུན་དུ་མི་ཚོགས་ལྷོད་འཇགས་སུ་ཕབ་སྟེ་ན་རེ། རང་ཅག་ཡུལ་དེ་ལས་ཏན་ཏན་རྣམ་པར་རྒྱལ་ཐུབ་པས་ཡར་འགྲོ་ལ་ཡུལ་དེ་ལེན་པར་བྱ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","འོན་ཀྱང་ཁོ་དང་མཉམ་དུ་སོང་བའི་མི་རྣམས་ན་རེ། ཡུལ་དེའི་མི་རྣམས་རང་ཅག་ལས་སྟོབས་ཆེ་བས། རང་ཅག་ཡར་དེ་དག་ལ་རྒོལ་བར་འགྲོ་མི་ནུས་སོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","མྱུལ་མ་དེ་དག་གིས་ཁོ་རྣམས་ལྐོག་ལྟ་བྱེད་དུ་ཕྱིན་པའི་ཡུལ་དེའི་སྐོར་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་གཏམ་ངན་བསྒྲགས་ཏེ་ན་རེ། ངེད་ཅག་སོང་ནས་ལྐོག་ལྟ་བྱས་པའི་ཡུལ་དེ་ནི་དེར་གནས་པའི་མི་རྣམས་རྔམ་ཟ་བྱེད་པའི་ཡུལ་ཞིག་ཡིན་པ་དང་། ངེད་ཅག་གིས་དེར་མཐོང་བའི་མི་ཐམས་ཅད་ནི་གཟུགས་རིང་ཞིང་ཆེའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","དེར་ང་ཚོས་ནེ་ཕེ་ལིམ་པ་རྣམས་མཐོང་ཞིང་། ཨ་ནག་གི་བུ་རྒྱུད་ནི་ནེ་ཕེ་ལིམ་པ་རྣམས་ལས་ཆད་པ་ཡིན། ང་ཚོའི་མཐོང་སྣང་ལ་རང་ཉིད་ནི་འབུ་ཆ་ག་པ་ལྟ་བུ་ཡིན་ལ། དེ་དག་གི་མཐོང་སྣང་ལའང་ངེད་རྣམས་དེ་བཞིན་ཡིན་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","དེའི་དུས་སུ་མི་ཚོགས་ཡོངས་ཀྱིས་སྐད་ཆེན་པོས་འུར་བརྒྱབ་པ་དང་། མཚན་མོ་དེར་མི་ཚོགས་ངུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཀྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འཁང་ར་བྱས་ཤིང་། མི་ཚོགས་ཀུན་གྱིས་ཁོ་གཉིས་ལ་འདི་ལྟར། ཀྱེ་མ། ང་ཚོ་སྔ་མོ་ནས་ཨེ་ཅིབ་ཡུལ་ནས་ཤི་བའམ། ཡང་ན་དབེན་སྟོང་འདི་ནས་ཤི་ན་ལེགས། ");
INSERT INTO bodn_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","དཀོན་མཆོག་ཡ་ཝཱེས་ཅིའི་ཕྱིར་ང་ཚོ་ཡུལ་འདིར་ཁྲིད་པ་ཡིན་ནམ། རལ་གྲིའི་ཁ་ནས་འགྱེལ་བའི་ཕྱིར་ཡུལ་འདི་ལ་ཁྲིད་པ་ཡིན་ནམ། ང་ཚོའི་ཆུང་མ་དང་ཕྲུ་གུ་རྣམས་ལ་འཕྲོག་བཅོམ་ཐེབས་པར་འགྱུར། ང་ཚོ་ཕྱིར་ཨེ་ཅིབ་ཡུལ་དུ་སོང་ན་དེ་ལས་བཟང་བ་མིན་ནམ་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","དེ་དག་གིས་ཕན་ཚུན་ལ། རང་ཅག་གིས་འགོ་དཔོན་གཞན་ཞིག་བསྐོས་ནས་ཨེ་ཅིབ་ཡུལ་དུ་ཕྱིར་ལོག་པར་བྱའོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཀུན་གྱི་མདུན་དུ་གདོང་སར་བཏུད་ནས་བསྡད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ཡུལ་དེར་ལྐོག་ལྟ་བྱེད་དུ་ཕྱིན་པ་རྣམས་ཀྱི་གྲས་སུ་ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་དང་ཡེ་ཕུན་ནེའི་བུ་ཀཱ་ལེབ་གཉིས་ཡོད་པ་དང་། དེ་གཉིས་ཀྱིས་རང་གི་གྱོན་གོས་གཤགས་ནས། ");
INSERT INTO bodn_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཐམས་ཅད་ལ་འདི་ལྟར། ངེད་ཅག་ལྐོག་ལྟ་བྱེད་དུ་སོང་བའི་ཡུལ་དེ་ནི་ཤིན་ཏུ་ཡག་པོ་འདུག ");
INSERT INTO bodn_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","དཀོན་མཆོག་ཡ་ཝཱེ་རང་ཅག་ལ་ཐུགས་མཉེས་པ་ཡིན་ན། རང་ཅག་ཡུལ་དེར་ཁྲིད་ནས་ཡུལ་དེ་རང་ཅག་ལ་གནང་ངེས་ཡིན། ཡུལ་དེ་ནི་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་ཞིག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་རྒྱབ་འགལ་མ་བྱེད་ཅིག ཡུལ་དེའི་མི་རྣམས་ལ་འཇིགས་པར་ཡང་མི་བྱའོ། །ཅི་ལ་ཟེར་ན། དེ་དག་ནི་རང་ཅག་གི་ཟ་སྐལ་ཡིན། ཁོ་ཚོའི་སྐྱབས་ནི་ཁོ་ཚོ་ལས་བྲལ་ཟིན་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་ཉིད་རང་ཅག་དང་མཉམ་དུ་བཞུགས་པས་དེ་དག་ལ་མ་འཇིགས་ཤིག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","མི་ཚོགས་ཀུན་གྱིས་དེ་གཉིས་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས་སྨྲས་ཤིང་། དེའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་ནི་མཇལ་འཕྲད་གུར་མཆོག་ཏུ་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཐམས་ཅད་ལ་མངོན་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། མི་འདི་དག་གིས་ནམ་དུས་བར་དུ་བདག་ལ་ཁྱད་གསོད་བྱའམ། བདག་གིས་དེ་དག་གི་ཁྲོད་དུ་གྲུབ་རྟགས་ཐམས་ཅད་བསྟན་ན་ཡང་། དེ་དག་གིས་ནམ་དུས་བར་དུ་བདག་ལ་ཡིད་ཆེས་མི་བྱེད་པ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","བདག་གིས་དེ་དག་ནད་ཡམས་ཀྱིས་བརྡུངས་ནས་མེད་པར་གཏོང་རྒྱུ་ཡིན་པ་དང་། བདག་གིས་ཁྱོད་ནི་མི་རིགས་ཆེན་པོ་དང་དེ་དག་ལས་ཀྱང་སྟོབས་ཤུགས་ལྡན་པ་ཞིག་ཏུ་གཏོང་བར་བྱ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་དེ་ཐོས་པར་འགྱུར། ཁྱེད་ཀྱིས་ནུས་མཐུ་ཆེན་པོས་མི་འདི་རྣམས་ཁོ་ཚོའི་དཀྱིལ་ནས་འདིར་ཁྲིད་འོངས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་ཀྱང་ཡུལ་དེའི་གཞིས་ཆགས་རྣམས་ལ་སྨྲ་བར་འགྱུར། ཡུལ་དེའི་གཞིས་ཆགས་རྣམས་ཀྱིས་ཀྱང་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱེད་ཉིད་མི་ཚོགས་འདིའི་དཀྱིལ་དུ་བཞུགས་ཡོད་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱེད་ཉིད་མི་ཡི་མིག་ལམ་དུ་མངོན་པར་མཛད་པ། ཁྱེད་ཀྱི་སྤྲིན་ནི་ཁོ་ཚོའི་སྟེང་དུ་བཞུགས་པ། ཉིན་མོར་ཁྱེད་ནི་སྤྲིན་གྱི་ཀ་བའི་ཁྲོད་དང་། མཚན་མོར་མེ་ཡི་ཀ་བའི་ཁྲོད་དུ་ཁོ་ཚོའི་སྔོན་ལ་ཕེབས་པ་བཅས་ཐོས་མྱོང་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ད་ལྟ་ཁྱེད་ཀྱིས་མི་འདི་རྣམས་མི་གཅིག་བཞིན་དུ་མེད་པར་མཛད་ན། ཁྱེད་ཀྱི་སྙན་གྲགས་ཐོས་མྱོང་བའི་མི་རིགས་རྣམས་ཀྱིས་གླེང་མོལ་བྱས་ཏེ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","དཀོན་མཆོག་ཡ་ཝཱེས་མི་འདི་རྣམས་ཁོ་ཚོར་མནའ་བཞེས་ཏེ་ཞལ་བཞེས་གནང་བའི་ཡུལ་དུ་ཁྲིད་མ་ནུས་པས་དབེན་སྟོང་དུ་ཁོ་རྣམས་མེད་པར་མཛད་དོ་ཞེས་སྨྲ་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ད་ནི་གཙོ་བོ་ཁྱེད་ཀྱིས་རང་གི་ནུས་མཐུ་ཆེན་པོ་སྟོན་པར་མཛོད། ཁྱེད་ཀྱིས་དེ་སྔར་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","དཀོན་མཆོག་ཡ་ཝཱེ་ནི་རང་དགར་ཐུགས་མི་ཁྲོ་ཞིང་བྱམས་བརྩེ་མཐའ་ཡས་པ་ཡིན། ཁོང་གིས་ཉེས་པ་དང་ནོར་འཁྲུལ་སེལ་བར་མཛད་ནའང་། ཉེས་ཅན་ནི་ཉེས་མེད་དུ་གཏན་ནས་མི་རྩི་བར། ཕ་རྣམས་ཀྱི་ནག་ཉེས་ཕྱིར་བུ་རྒྱུད་རྣམས་ལ་མི་རབས་གསུམ་བཞིའི་བར་དུ་ཉེས་ཆད་གཅོད་པ་ལགས་ཞེས་གསུངས་པ་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ཁྱེད་ཀྱི་བྱམས་བརྩེ་ཆེན་པོ་བཞིན་དུ། ཨེ་ཅིབ་ཡུལ་ནས་དེ་རིང་གི་བར་དུ་མི་འདི་དག་ལ་སྡིག་སེལ་གནང་བ་ལྟར། མི་འདི་དག་གི་ཉེས་པ་སེལ་བར་མཛོད་ཅེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། ཁྱོད་ཀྱི་ཞུ་བ་བཞིན་དུ་བདག་གིས་དེ་དག་ལ་སྡིག་སེལ་གནང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","འོན་ཀྱང་བདག་གི་ཚེ་སྲོག་དཔང་དུ་བཙུགས་ནས་མནའ་བསྐྱལ་བ་ཡིན་ཏེ། དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་བརྗིད་ཀྱིས་ས་གཞི་ཡོངས་སུ་གང་བར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","མི་འདི་ཐམས་ཅད་ཀྱིས་བདག་གི་གཟི་བརྗིད་དང་བདག་གིས་ཨེ་ཅིབ་ཡུལ་དང་དབེན་སྟོང་དུ་བསྟན་པའི་གྲུབ་རྟགས་རྣམས་མཐོང་ན་ཡང་། ལན་བཅུར་བདག་ལ་ཚོད་བགམ་བྱས་ཤིང་བདག་གི་གཏམ་ལ་མ་མཉན། ");
INSERT INTO bodn_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","བདག་གིས་དེ་དག་གི་ཕ་མེས་ལ་མནའ་བསྐྱལ་ཏེ་ཁས་བླངས་པའི་ཡུལ་ནི་དེ་དག་གིས་མཐོང་བར་མི་འགྱུར་ལ། བདག་ཁྱད་དུ་གསོད་མཁན་རྣམས་ལས་སུས་ཀྱང་ཡུལ་དེ་མཐོང་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","འོན་ཀྱང་། ངའི་ཞབས་ཕྱི་ཀཱ་ལེབ་ལ་བསམ་འདུན་གཞན་ཞིག་ཡོད་ཅིང་། སེམས་གཅིག་ལུས་གཅིག་གིས་བདག་གི་རྗེས་སུ་འབྲངས་པ་ཡིན་པས། ངས་ཁོ་རང་ནི་ཁོ་སོང་མྱོང་བའི་ཡུལ་དེར་འཁྲིད་ངེས་ལ། ཁོའི་བུ་རྒྱུད་ལ་ཡུལ་དེ་འཐོབ་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ད་ལྟ་ཨ་མཱད་ལེག་པ་དང་ཀ་ན་ཨན་པ་རྣམས་ལུང་པའི་ནང་དུ་གནས་ཡོད། སང་ཉིན་ཁྱོད་རྣམས་ཕྱིར་འཁོར་ཏེ་རྒྱ་མཚོ་དམར་པོའི་ལམ་བརྒྱུད་ནས་དབེན་སྟོང་དུ་སོང་ཞིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","མི་ཚོགས་ངན་པ་འདིས་བདག་ལ་ནམ་དུས་བར་དུ་འཁང་ར་བྱེད་ཡོང་ངམ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་བདག་ལ་འཁང་ར་བྱེད་པ་དེ་བདག་གིས་ཐོས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ཁྱོད་ཀྱིས་ཁོ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག དཀོན་མཆོག་ཡ་ཝཱེས་འདི་སྐད་དུ། བདག་གིས་རང་གི་ཚེ་སྲོག་དཔང་དུ་བཙུགས་ནས་མནའ་བསྐྱལ་བ་སྟེ། ཁྱོད་ཚོས་བདག་གི་རྣ་བར་ཅི་ལྟར་གཏམ་བྱས་པ་བཞིན་བདག་གིས་དེ་ལྟར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ཁྱོད་ཅག་གི་བེམ་པོ་རྣམས་དབེན་སྟོང་འདི་རུ་འགྱེལ་ངེས་ཤིང་། ཁྱོད་ཅག་གི་ཁྲོད་དུ་རྩིས་བླངས་ཟིན་པ་སྟེ། ཁྱོད་རྣམས་ཀྱི་གྲངས་ཀ་བཞིན་ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་བདག་ལ་འཁང་ར་བྱས་མྱོང་པ་ཐམས་ཅད་ནི། ");
INSERT INTO bodn_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","བདག་གིས་ཁྱོད་རྣམས་འདུག་ཏུ་འཇུག་པར་མནའ་བསྐྱལ་བའི་ཡུལ་དེར་འགྲོ་མི་ཆོག་ལ། ཡེ་ཕུན་ནེ་ཡི་བུ་ཀཱ་ལེབ་དང་ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་གཉིས་འབའ་ཞིག་ཡུལ་དེ་རུ་ཕྱིན་ཆོག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","འོན་ཀྱང་ཁྱོད་ཅག་གི་བྱིས་པ་རྣམས་ཏེ། ཁྱོད་རྣམས་ཀྱིས་འཕྲོག་བཅོམ་ཐེབས་པར་འགྱུར་ཞེས་སྨྲས་པ་དེ་དག་བདག་གིས་ཡུལ་དེར་འཁྲིད་རྒྱུ་ཡིན་པ་དང་། ཁྱོད་རྣམས་ཀྱིས་སྤངས་པའི་ཡུལ་དེ་ཁོ་ཚོར་འཐོབ་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","འོན་ཀྱང་ཁྱོད་ཅག་གི་བེམ་པོ་རྣམས་དབེན་སྟོང་འདི་རུ་འགྱེལ་བར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ཁྱོད་ཅག་གི་བུ་རྣམས་ཀྱིས་ལོ་བཞི་བཅུའི་རིང་ལ་དབེན་སྟོང་དུ་ཕྱུགས་འཚོས་ནས། ཁྱོད་ཅག་གི་བེམ་པོ་རྣམས་དབེན་སྟོང་དུ་རྩ་མེད་དུ་འགྲོ་བའི་བར་ཁོ་ཚོས་ཁྱོད་ཅག་གི་འདོད་ལོག་སྤྱད་པའི་སྡིག་པ་འཁུར་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ཁྱོད་རྣམས་ཀྱིས་ཡུལ་དེར་ལྐོག་ལྟ་བྱས་པའི་ཉིན་བཞི་བཅུའི་གྲངས་ཀ་བཞིན་དུ། ཉིན་རེ་ལོ་གཅིག་ལ་བརྩིས་ནས་ལོ་བཞི་བཅུའི་རིང་དུ་ཉེས་པ་འཁུར་དགོས། ཅི་ལ་ཟེར་ན། དེ་ནས་ཁྱོད་ཅག་གིས་བདག་གིས་ཅིའི་ཕྱིར་ཁྱོད་རྣམས་ལ་རྒོལ་བ་ཤེས་པར་འགྱུར་ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ཡ་ཝཱེ་བདག་གིས་དེ་ལྟར་སྨྲས་ཟིན་པ་སྟེ། བདག་གིས་ལྷན་དུ་འཛོམས་ནས་བདག་ལ་ངོ་རྒོལ་བྱེད་པའི་མི་ཚོགས་ངན་པ་འདིར་དེ་ལྟར་བྱེད་ངེས་ལ། ཁོ་རྣམས་དབེན་སྟོང་འདི་རུ་མེད་པར་འགྲོ་ཞིང་། འདི་རུ་འཆི་བར་འགྱུར་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","མོ་ཤེ་ཡིས་ཡུལ་དེར་ལྐོག་ལྟ་བྱེད་པར་བཏང་བའི་མི་དེ་དག་ཕྱིར་འོངས་པ་དང་། ཡུལ་དེའི་སྐོར་གྱི་སྐད་ངན་ཁྱེར་འོངས་པས་མི་ཚོགས་ཐམས་ཅད་ཀྱིས་མོ་ཤེ་ལ་འཁང་ར་བྱས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ཡུལ་དེའི་སྐོར་གྱི་སྐད་ངན་ཁྱེར་ཡོང་མཁན་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་གཉན་ནད་ཀྱིས་ཤིའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ཡུལ་དེར་ལྐོག་ལྟ་བྱེད་དུ་སོང་བའི་མི་རྣམས་ལས། ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་དང་ཡེ་ཕུན་ནེའི་བུ་ཀཱ་ལེབ་གཉིས་ད་དུང་གསོན་པོར་གནས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","མོ་ཤེ་ཡིས་གཏམ་དེ་རྣམས་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་སྨྲས་པ་ན། མི་རྣམས་ཀྱིས་མྱ་ངན་དྲག་པོ་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","དེའི་ཕྱི་ཉིན་ཞོགས་པར་ཁོ་རྣམས་སྔ་མོ་ནས་ཡར་ལངས་ཏེ་རི་རྩེར་སོང་ནས་འདི་ལྟར། ང་ཚོ་འདི་རུ་ཡོད། ང་ཚོ་དཀོན་མཆོག་ཡ་ཝཱེས་ཞལ་གྱིས་བཞེས་པའི་གནས་དེར་ཡར་འགྲོ་བར་བྱ། ཅི་ལ་ཞེ་ན། ང་ཚོས་སྡིག་པ་བྱས་པས་སོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","དེ་ནས་མོ་ཤེ་ན་རེ། ཁྱོད་རྣམས་ཡང་བསྐྱར་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་དང་འགལ་བ་ཅི། དོན་དེ་འགྲུབ་པའི་དཔེ་མི་སྲིད། ");
INSERT INTO bodn_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱོད་ཚོའི་དཀྱིལ་དུ་མི་བཞུགས་པས། དགྲ་བོའི་ཚོགས་ཀྱིས་ཁྱོད་རྣམས་ཕམ་པར་མི་རྒྱག་པའི་ཕྱིར་དུ་ཡར་མ་འགྲོ་ཞིག ");
INSERT INTO bodn_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","གང་ལ་ཟེར་ན། ཨ་མཱད་ལེག་པ་དང་ཀ་ན་ཨན་པ་རྣམས་ཁྱོད་ཚོའི་མདུན་དུ་ཡོད་པས། ཁྱོད་རྣམས་རལ་གྲིའི་ཁ་ནས་འགྱེལ་བར་འགྱུར། ཁྱོད་ཚོ་དཀོན་མཆོག་ཡ་ཝཱེའི་རྗེས་སུ་མ་འབྲངས་པས་དཀོན་མཆོག་ཡ་ཝཱེ་ཁྱོད་རྣམས་དང་མཉམ་དུ་མི་བཞུགས་སོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","དེ་དག་ཁེངས་དྲེགས་ཆེན་པོས་རི་རྩེར་སོང་ཡང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཞལ་ཆད་ཀྱི་ཤུར་སྒམ་དང་མོ་ཤེ་ནི་སྒར་དང་མ་བྲལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","དེ་ནས་རི་དེར་གནས་པའི་ཨ་མཱད་ལེག་པ་དང་ཀ་ན་ཨན་པ་རྣམས་ཐུར་ལ་བབས་ནས། ཁོ་ཚོར་བརྡུངས་ནས་ཧོར་མཱ་བར་དུ་ཕམ་པར་བརྒྱབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","དེ་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར། ཁྱོད་ཚོ་བདག་གིས་ཁྱོད་རྣམས་གཞིས་ཆགས་པའི་ཕྱིར་གནང་བའི་ཡུལ་དུ་ཕྱིན་པའི་ཚེ། ");
INSERT INTO bodn_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","བ་ཁྱུ་དང་ར་ལུག་གི་ཁྱུ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མེ་མཆོད་འབུལ་དགོས་ཤིང་། དེ་ནི་སྦྱིན་སྲེག་གི་མཆོད་པའམ་དམར་མཆོད་གཞན་འབུལ་བ་དང་། དམ་བཅའི་མཆོད་པའམ་ཡིད་མོས་ཀྱི་མཆོད་པ་འབུལ་བ། ཡང་ན་ཁྱོད་ཅག་གི་དུས་ཆེན་རྣམས་ཀྱི་མཆོད་པ་འབུལ་བ་བཅས་གང་ཡིན་ཡང་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","མཆོད་པ་འབུལ་མཁན་གྱིས་ཨེ་ཕཱ་བཅུ་ཆ་གཅིག་གི་ཕྱེ་བཟང་པོ་རྫ་བུམ་གྱི་བཞི་ཆ་གཅིག་གི་སྣུམ་ལ་བསྲེས་པ་ཞིག་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབྲུ་རིགས་ཀྱི་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","དེ་མིན་སྦྱིན་སྲེག་གམ་དམར་མཆོད་གཞན་གང་ཡིན་ཡང་། ལུ་གུ་རེའི་ཕྱིར་དུ་ཁྱོད་ཀྱིས་སྐྱེམས་མཆོད་དུ་རྒུན་ཆང་རྫ་བུམ་གྱི་བཞི་ཆ་གཅིག་དེ་དང་མཉམ་དུ་འབུལ་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ཡང་ན་ལུག་ཐུག་རེའི་ཕྱིར་དུ་ཁྱོད་ཀྱིས་ཨེ་ཕཱ་བཅུ་ཆ་གཉིས་ཀྱི་ཕྱེ་བཟང་པོ་རྫ་བུམ་གྱི་གསུམ་ཆ་གཅིག་གི་སྣུམ་ལ་བསྲེས་ནས་འབྲུ་རིགས་ཀྱི་མཆོད་པར་འབུལ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ཡང་རྒུན་ཆང་རྫ་བུམ་གྱི་གསུམ་ཆ་གཅིག་སྐྱེམས་མཆོད་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མཆོད་པར་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","གལ་སྲིད་ཁྱོད་ཀྱིས་གླང་ཐུག་ཅིག་གྲ་སྒྲིག་བྱས་ཏེ་དམ་བཅའ་སྒྲུབ་པའམ། ཡང་ན་ཞི་བདེའི་མཆོད་པ་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་གམ་དམར་མཆོད་གཞན་འབུལ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ཨེ་ཕཱ་གསུམ་ཆ་གཅིག་གི་ཕྱེ་བཟང་པོ་རྫ་བུམ་ཕྱེད་ཀའི་སྣུམ་ལ་བསྲེས་ནས་གླང་ཐུག་དང་མཉམ་དུ་འབྲུ་རིགས་ཀྱི་མཆོད་པར་འབུལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ཡང་རྒུན་ཆང་རྫ་བུམ་ཕྱེད་ཀ་སྐྱེམས་མཆོད་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","དེ་ལྟར་གླང་ཐུག་གཅིག་གམ། ཡང་ན་ལུག་ཐུག་གཅིག ཡང་ན་ལུ་གུ་ཕོ་གཅིག ཡང་ན་རེའུ་གཅིག་བཅས་འབུལ་ན་ཐམས་ཅད་དེ་བཞིན་བསྒྲུབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ཁྱོད་ཀྱིས་གྲ་སྒྲིག་བྱས་པའི་གྲངས་ཀ་ལྟར། རེ་རེ་དེ་བཞིན་དུ་བསྒྲུབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","གཞིས་སྐྱེས་ཐམས་ཅད་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་འབུལ་བའི་ཚེ་དེ་བཞིན་དུ་བསྒྲུབ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ཕྱི་མི་ཞིག་ཁྱོད་རྣམས་དང་མཉམ་དུ་སྡོད་པའམ། ཡང་ན་སུ་ཞིག་མི་རབས་ནས་མི་རབས་བར་ཁྱོད་རྣམས་ཀྱི་ཁྲོད་དུ་སྡོད་ཅིང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་འབུལ་ན། དེས་ནི་ཁྱོད་ཅག་གིས་ཅི་ལྟར་སྒྲུབ་པ་བཞིན་དུ་བསྒྲུབ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","མི་ཚོགས་ལ་མཚོན་ན། ཁྱོད་ཅག་དང་ཡང་ན་ཁྱོད་ཅག་མཉམ་དུ་སྡོད་པའི་ཕྱི་མི་རྣམས་ཀྱི་སྒྲིག་ཁྲིམས་ནི་གཅིག་མཚུངས་ཡིན་ལ། ཁྱོད་ཅག་མི་རབས་ཀུན་གྱི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན། དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཁྱོད་ཅག་ཅི་ལྟར་ཡིན་ན་བྱེས་པ་རྣམས་ཀྱང་དེ་ལྟར་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ཁྱོད་ཅག་དང་ཁྱོད་རྣམས་ཀྱི་ཁྲོད་དུ་གནས་པའི་ཕྱི་མི་ལ་བཀའ་ཁྲིམས་དང་སྲོལ་ཡིག་གཅིག་ཡིན་སྨྲོས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་ཤོད་དང་། ཁྱོད་རྣམས་བདག་གིས་ཁྱོད་ཚོ་ཁྲིད་ནས་འགྲོ་བའི་ཡུལ་དེར་སླེབས་ནས། ");
INSERT INTO bodn_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ཡུལ་དེའི་ཟས་ཟ་བའི་དུས་སུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ཁྱོད་ཅག་གིས་འབྲུ་ཕུད་ཀྱི་གྲོ་ཕྱེ་ཡིས་བག་ལེབ་ཅིག་འདེགས་མཆོད་དུ་འབུལ་དགོས། དེ་ནི་གཡུལ་ཁའི་འདེགས་མཆོད་འབུལ་བ་ནང་བཞིན་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ཁྱོད་ཅག་མི་རབས་ཀུན་གྱིས་འབྲུ་ཕུད་ཀྱི་གྲོ་ཕྱེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་དུ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","གལ་སྲིད་ཁྱོད་ཅག་གིས་མ་ཤེས་པར་སྡིག་པ་བྱས་ནས། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་ཐམས་ཅད་དེ། ");
INSERT INTO bodn_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་ཁྱོད་ཅག་ལ་བཀའ་གནང་བའི་དོན་ཐམས་ཅད། དཀོན་མཆོག་ཡ་ཝཱེས་བཀའ་གནང་བའི་ཉིན་དེ་ནས་བཟུང་ཁྱོད་ཅག་གི་མི་རབས་ནས་མི་རབས་བར་དུ་བསྲུང་མ་ཐུབ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","གལ་སྲིད་མ་བསམ་ས་ནས་ནོར་འཛོལ་བྱུང་ཞིང་མི་ཚོགས་ཀྱིས་ཀྱང་མི་ཤེས་ན། མི་ཚོགས་ཡོངས་ཀྱིས་གླང་ཐུག་ཅིག་སྦྱིན་སྲེག་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མཆོད་པར་འབུལ་དགོས་ལ། སྲོལ་ཡིག་ནང་བཞིན་དེའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་སྐྱེམས་མཆོད་ཀྱང་དེ་དང་མཉམ་དུ་འབུལ་བ་དང་། ཡང་ར་ཕོ་གཅིག་སྡིག་བཤགས་མཆོད་པ་རུ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","མཆོད་དཔོན་གྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཡོངས་ཀྱི་ཕྱིར་དུ་སྡིག་བཤགས་བྱེད་དགོས་ཤིང་། དེ་དག་ལ་སྡིག་སེལ་འཐོབ་ངེས་ཡིན། ཅི་ལ་ཟེར་ན། དེ་ནི་མ་བསམ་ས་ནས་བཟོས་པའི་སྡིག་པ་ཞིག་ཡིན་པ་དང་། ཡང་དེ་དག་གིས་རང་གི་མ་བསམ་ས་ནས་བཟོས་པའི་སྡིག་པའི་རྐྱེན་གྱིས། མེ་མཆོད་དང་སྡིག་བཤགས་མཆོད་པ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཕུལ་བས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་དང་དེའི་ཁྲོད་དུ་གནས་པའི་ཕྱི་མི་རྣམས་ལ་སྡིག་སེལ་འཐོབ་ངེས་ཡིན། ཅི་ལ་ཞེ་ན། མི་ཐམས་ཅད་ཀྱིས་མ་བསམ་ས་ནས་སྡིག་པ་བྱས་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","གལ་སྲིད་མི་ཞིག་གིས་མ་ཤེས་པར་སྡིག་པ་བྱས་ན། དེས་ར་མ་ལོ་གཅིག་ཅན་ཞིག་སྡིག་བཤགས་མཆོད་པར་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","མཆོད་དཔོན་གྱིས་མ་ཤེས་པར་སྡིག་པ་བྱེད་མཁན་དེའི་ཕྱིར་དུ་སྡིག་བཤགས་བྱེད་དགོས་ཏེ། མི་དེས་མ་བསམ་ས་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་སྤྱན་སྔར་སྡིག་པ་བྱས་པས་སོ། །མཆོད་དཔོན་གྱིས་མི་དེའི་ཕྱིར་སྡིག་བཤགས་བྱེད་ཅིང་མི་དེར་སྡིག་སེལ་འཐོབ་ངེས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","མ་བསམ་ས་ནས་སྡིག་པ་བྱེད་མཁན་ནི་ཡེས་ར་ཨེལ་པའི་ཁྲོད་ཀྱི་གཞིས་སྐྱེས་སམ་དེ་དག་གི་ཁྲོད་དུ་གནས་པའི་ཕྱི་མི་གང་ཡིན་ཡང་། ཐམས་ཅད་ལ་བཀའ་ཁྲིམས་གཅིག་ཡིན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","འོན་ཀྱང་བསམ་གཟས་ནས་སྡིག་པ་བྱེད་མཁན་ནི་གཞིས་སྐྱེས་སམ་བྱེས་པ་གང་ཡིན་ཡང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྐུར་བ་འདེབས་མཁན་མི་དེ་ནི་རང་གི་མི་མང་ནས་འཕུད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","མི་དེས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ལ་མཐོང་ཆུང་བྱས་ཤིང་། ཁོང་གི་བཀའ་དང་འགལ་བས། མི་དེ་ནི་ངེས་པར་འཕུད་དགོས་ཤིང་། ཁོའི་ཉེས་པ་རང་སྟེང་ལ་སྦྱོར་བར་འགྱུར་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ཡེས་ར་ཨེལ་པ་རྣམས་དབེན་སྟོང་དུ་གནས་པ་ལ། མི་ཞིག་གིས་ངལ་གསོ་བའི་ཉིན་མོར་བུད་ཤིང་བཏུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ཁོས་བུད་ཤིང་འཐུ་བ་མཐོང་མཁན་རྣམས་ཀྱིས་ཁོ་རང་མོ་ཤེ་དང་ཨ་རོན་དང་མི་ཚོགས་ཡོངས་ཀྱི་མདུན་དུ་ཁྲིད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","མི་དེར་ཅི་བྱེད་དགོས་པ་ཐག་གིས་མ་ཆོད་པས་བཀག་ནས་བཞག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། མི་དེ་ངེས་པར་གསོད་དགོས་ཏེ། མི་ཚོགས་ཡོངས་ཀྱིས་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཁོ་རྡོ་རུབ་བཏང་ནས་གསོད་དགོས་ཞེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","མི་ཚོགས་ཡོངས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་བཞིན་དུ། ཁོ་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཁྲིད་དེ་རྡོ་རུབ་བཏང་ནས་བསད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཁོ་ཚོས་མི་རབས་ནས་མི་རབས་བར་དུ་རང་གི་གྱོན་གོས་ཀྱི་སྣེ་མོར་ཙོར་ལོ་འདོགས་དགོས་ལ། ཡང་ཙོར་ལོ་རེའི་སྟེང་དུ་ཐ་གུ་སྔོན་པོ་བཙེམ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ཁྱོད་ཚོས་ཙོར་ལོ་མཐོང་མ་ཐག་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ཐམས་ཅད་དྲན་ཞིང་དེ་བཞིན་དུ་བྱེད་པ་དང་། ཁྱོད་རྣམས་གང་བྱུང་དུ་རྒྱུགས་ནས་ལོག་གཡེམ་སྤྱད་པ་བཞིན་རང་གི་བསམ་ཚུལ་དང་མིག་གི་རྗེས་སུ་མི་འབྲང་བའི་ཕྱིར་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ཁྱོད་རྣམས་ཀྱིས་བདག་གི་བཀའ་ཐམས་ཅད་དྲན་ནས་དེ་བཞིན་བྱེད་པ་དང་། ཡང་ཁྱོད་རྣམས་དཀོན་མཆོག་གི་ཆེད་དུ་དམ་པ་ཡིན་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ལ། ཁྱོད་ཅག་གི་དཀོན་མཆོག་བྱེད་པའི་ཕྱིར་ཁྱོད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཕྱི་རོལ་ཏུ་ཁྲིད་འོངས་པ་ཡིན། བདག་ནི་ཁྱོད་ཅག་གི་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིན་ནོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","དེ་ཡང་ལེ་ཝིའི་ཡང་ཚ་སྟེ། ཀོ་ཧད་ཀྱི་ཚ་བོ་དང་ཡེས་ཧར་གྱི་བུ་ཀོ་རཱག་དང་། རུ་བེན་གྱི་བུ་རྒྱུད་ལས་ཨེ་ལི་ཨབ་ཀྱི་བུ་དཱ་ཐན་དང་ཨ་བི་རཱམ་གཉིས་དང་། ཕེ་ལེད་ཀྱི་བུ་ཨོན་བཅས་ཀྱིས་མི་ཁྲིད་ནས་འོངས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","མོ་ཤེ་ལ་ངོ་རྒོལ་བྱས་པ་དང་། ད་དུང་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་མི་ཉིས་བརྒྱ་ལྔ་བཅུ་སྟེ་མི་ཚོགས་ཀྱི་འགོ་དཔོན་ཡིན་ཞིང་། མི་ཚོགས་ལས་བདམས་པའི་མི་སྙན་གྲགས་ཅན་རྣམས་ཀྱང་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","དེ་དག་མཉམ་དུ་འདུས་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་ངོ་རྒོལ་བྱས་ཤིང་ཁོ་གཉིས་ལ་འདི་ལྟར། ཁྱོད་གཉིས་ཚད་ལས་བརྒལ་དྲགས། མི་ཚོགས་ཡོངས་ཀྱི་མི་རེ་རེ་དམ་པ་ཡིན་ཞིང་དཀོན་མཆོག་ཡ་ཝཱེ་ཡང་དེ་དག་གི་ཁྲོད་དུ་བཞུགས་ཡོད་པས། ཁྱོད་གཉིས་ཀྱིས་རང་ཉིད་དཀོན་མཆོག་ཡ་ཝཱེའི་མི་ཚོགས་ལས་མཐོན་པོར་བཀུར་བ་ཅི་ཡིན་ནམ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","མོ་ཤེ་ཡིས་དེ་ཐོས་ནས་གདོང་ས་རུ་བཏུད་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ཀོ་རཱག་དང་ཁོའི་འགྲོགས་ཡ་རྣམས་ལ་འདི་ལྟར། སང་ཉིན་ཞོགས་པར་དཀོན་མཆོག་ཡ་ཝཱེས་སུ་ཞིག་ཁོང་གི་ཡིན་པ་དང་། སུ་ཞིག་དམ་པ་ཡིན་པ་སྟོན་པར་མཛད་ནས་དེ་ཁོང་གི་འཁྲིས་སུ་འཁྲིད་འོང་ལ། ཡང་སུ་ཞིག་ཁོང་གིས་བདམས་པ་ཡིན་ན་དེ་ཁོང་གི་ཉེ་སར་འདྲེན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ཁྱོད་ཅག་གིས་འདི་ལྟར་བྱེད་དགོས་ཏེ། ཀོ་རཱག་དང་ཁྱོད་ཀྱི་འགྲོགས་ཡ་རྣམས་ཀྱིས་སྤོས་ཕོར་ཁྱེར་འོངས་ནས། ");
INSERT INTO bodn_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","སང་ཉིན་ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་དེ་དག་གི་ནང་དུ་མེ་སྦར་བ་དང་དེའི་སྟེང་དུ་སྤོས་ཞོག་ཅིག དཀོན་མཆོག་ཡ་ཝཱེས་སུ་ཞིག་བདམས་ན་དེ་ནི་དམ་པ་ཡིན་པར་འགྱུར། ལེ་ཝི་པ་ཁྱོད་རྣམས་ཚད་ལས་བརྒལ་དྲགས་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","དེ་ནས་མོ་ཤེ་ཡིས་ཀོ་རཱག་ལ་འདི་ལྟར། ལེ་ཝི་པ་རྣམས་ཀྱིས་ཉོན་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་གིས་ཁྱོད་ཚོ་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ལས་ལོགས་སུ་བཀར་ཏེ། ཁྱོད་ཅག་ཁོང་དང་ཉེ་བར་མཛད་ནས། དཀོན་མཆོག་ཡ་ཝཱེའི་གུར་མཆོག་གི་ཞབས་ཕྱི་བྱེད་པ་དང་། མི་ཚོགས་ཀྱི་མདུན་དུ་ལངས་ནས་ཁོ་ཚོའི་དོན་དུ་ཞབས་ཕྱི་སྒྲུབ་པར་མཛད། ");
INSERT INTO bodn_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱོད་དང་ཁྱོད་ཀྱི་སྤུན་ཟླ་ཐམས་ཅད་དེ། ལེ་ཝིའི་བུ་རྒྱུད་རྣམས་ལྷན་དུ་ཁོང་དང་ཉེ་བར་མཛད་པ་དང་། ཁྱོད་ཅག་གིས་དེ་ནི་དོན་ཆུང་ངུ་ཞིག་ཡིན་པར་འདོད་དམ། ཁྱོད་ཅག་གིས་ད་དུང་མཆོད་དཔོན་གྱི་ལས་འགན་ལ་བསྙེག་གམ། ");
INSERT INTO bodn_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","དེའི་ཕྱིར། ཁྱོད་དང་ཁྱོད་ཀྱི་འགྲོགས་ཡ་རྣམས་མཉམ་དུ་འདུས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་རྒོལ་བའོ། །ཨ་རོན་སུ་ཡིན་ནམ། ཁྱོད་ཅག་གིས་ཁོ་ལ་འཁང་ར་བྱེད་དགོས་དོན་ཅི་ཡོད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","དེ་ནས་མོ་ཤེ་ཡིས་ཨེ་ལི་ཨབ་ཀྱི་བུ་དཱ་ཐན་དང་ཨ་བི་རཱམ་གཉིས་འབོད་པར་མི་མངགས་པ་ལ། དེ་གཉིས་ཀྱིས་ངེད་གཉིས་ཡར་མི་འགྲོ། ");
INSERT INTO bodn_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ཁྱོད་ཀྱིས་ངེད་རྣམས་དབེན་སྟོང་དུ་གསོད་པའི་ཕྱིར་དུ་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་ནས་ཡར་ཁྲིད་འོངས་པ་དང་། དེ་ནི་དོན་ཆུང་ངུ་ཞིག་ཡིན་ནམ། ཁྱོད་ཀྱིས་ད་དུང་རང་ཉིད་རྒྱལ་པོར་བསྐོས་ནས་ངེད་རྣམས་ལ་དབང་བསྒྱུར་དགོས་སམ། ");
INSERT INTO bodn_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","དེར་མ་ཟད་ཁྱོད་ཀྱིས་ངེད་རྣམས་འོ་མ་དང་སྦྲང་རྩི་བཞུར་བའི་ཡུལ་དུ་མ་ཁྲིད་ལ། ས་ཞིང་དང་རྒུན་འབྲུམ་ར་བ་དག་ཀྱང་ངེད་རྣམས་ལ་ས་སྐལ་དུ་མ་བྱིན། ཁྱོད་ཀྱིས་མི་འདི་དག་གི་མིག་འདོན་པར་བྱའམ། ངེད་གཉིས་ཡར་མི་འགྲོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","དེ་ནས་མོ་ཤེ་ཤིན་ཏུ་ཁྲོས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། ཁྱེད་ཀྱིས་དེ་དག་གི་མཆོད་པ་མི་གཟིགས་པར་མཛོད། ངས་དེ་དག་ལས་བོང་བུ་གཅིག་ཀྱང་བླངས་མེད་ལ། ཁོ་རྣམས་ལས་མི་གཅིག་ལ་ཡང་གནོད་པ་བཏང་མེད་ཅེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","མོ་ཤེ་ཡིས་ཀོ་རཱག་ལ་འདི་ལྟར། སང་ཉིན་ཁྱོད་དང་ཁྱོད་ཀྱི་འགྲོགས་ཡ་རྣམས་དང་། དེ་མིན་ཨ་རོན་བཅས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འཛོམ་པར་གྱིས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ཁྱོད་ཅག་མི་རེ་རེས་རང་གི་སྤོས་ཕོར་ཁྱེར་ནས་དེ་དག་གི་ནང་དུ་སྤོས་ཞོག་ཅིག མི་རེ་རེས་རང་རང་གི་སྤོས་ཕོར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་འཁྱེར་འོང་དགོས་ལ། བསྡོམས་པས་སྤོས་ཕོར་ཉིས་བརྒྱ་ལྔ་བཅུ་ཡིན། ཁྱོད་དང་ཨ་རོན་གཉིས་ཀྱིས་ཀྱང་རང་རང་གི་སྤོས་ཕོར་འཁྱེར་འོང་དགོས་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","དེ་ནས་ཁོ་རྣམས་མི་རེ་རེས་རང་རང་གི་སྤོས་ཕོར་ཁྱེར་ནས་དེ་དག་གི་སྟེང་དུ་མེ་དང་མེའི་སྟེང་དུ་སྤོས་བཞག་རྗེས། མོ་ཤེ་དང་ཨ་རོན་མཉམ་དུ་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་འགྲེང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ཀོ་རཱག་གིས་མི་ཚོགས་ཡོངས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་རྒོལ་བར་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་བསྡུས་པ་ན། དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་མི་ཚོགས་ཡོངས་ལ་མངོན་པར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","བདག་གིས་མི་ཚོགས་འདི་སྐད་ཅིག་ཉིད་ལ་རྩ་ནས་འཇོམས་པའི་ཕྱིར། ཁྱོད་གཉིས་དེ་དག་དང་གྱེས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་གདོང་སར་བཏུད་ནས་འདི་ལྟར། ཀྱེ་དཀོན་མཆོག ལུས་ཅན་ཐམས་ཅད་ཀྱི་སེམས་ཉིད་ཀྱི་དཀོན་མཆོག་ལགས། མི་གཅིག་གིས་སྡིག་པ་བྱས་པས་ཁྱེད་ཉིད་མི་ཚོགས་ཡོངས་ལ་ཐུགས་ཁྲོ་བར་མཛད་དམ་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","ཁྱོད་ཀྱིས་མི་ཚོགས་ལ། ཁྱོད་རྣམས་ཀོ་རཱག་དང་། དཱ་ཐན། ཨ་བི་རཱམ་བཅས་ཀྱི་གུར་དང་འབྲལ་བར་གྱིས་སྨྲོས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","དེ་ནས་མོ་ཤེ་ཡར་ལངས་ནས་དཱ་ཐན་དང་ཨ་བི་རཱམ་གཉིས་ཀྱི་རྩར་ཕྱིན་པ་དང་། ཡེས་ར་ཨེལ་གྱི་རྒན་པོ་རྣམས་ཀྱང་ཁོང་གི་རྗེས་སུ་འབྲངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","དེ་ནས་མོ་ཤེ་ཡིས་མི་ཚོགས་ལ་འདི་ལྟར། ཁྱོད་ཅག་མི་ངན་འདི་དག་གི་གུར་རྣམས་དང་རིང་དུ་འབྲལ་བར་གྱིས། ཁྱོད་རྣམས་དེ་དག་གི་སྡིག་པའི་རྐྱེན་གྱིས་རླུང་གིས་འཁུར་བ་ལྟར་མི་འགྱུར་བའི་སླད། དེ་དག་གི་ཡིན་པ་གང་ལ་ཡང་རེག་པར་མི་བྱའོ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","མི་ཚོགས་ཀོ་རཱག་དང་དཱ་ཐན་དང་ཨ་བི་རཱམ་བཅས་ཀྱི་གུར་གྱི་ཕྱོགས་བཞིར་བྲལ་ཞིང་། དཱ་ཐན་དང་ཨ་བི་རཱམ་གཉིས་ཀྱིས་རང་གི་ཆུང་མ་རྣམས་དང་བུ་ཕྲུག་དང་ཕྲུ་གུ་བཅས་ཁྲིད་ནས་ཐོན་ཏེ་རང་གི་གུར་རྣམས་ཀྱི་སྒོ་ཁར་འགྲེང་ནས་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","མོ་ཤེ་ཡིས་འདི་ལྟར། དོན་འདི་ཐམས་ཅད་ནི་ངས་རང་གི་བསམ་ཚུལ་བཞིན་དུ་སྒྲུབ་པ་མ་ཡིན་པར། དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་དོན་འདི་རྣམས་བསྒྲུབ་ཏུ་མངགས་པ་ཁྱོད་ཅག་གིས་འདི་ནས་ཤེས་ཡོང་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","གལ་སྲིད་མི་འདི་རྣམས་འཆི་བ་ནི་མི་ཐམས་ཅད་ཀྱི་ལུགས་ལྟར་ཡིན་པའམ། ཡང་ན་ཁོ་རྣམས་ཀྱིས་མྱོང་བ་ནི་མི་ཐམས་ཅད་ཀྱིས་མྱོང་བ་བཞིན་དུ་ཡིན་ན། དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་མངགས་པ་མ་ཡིན་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","གལ་སྲིད་དཀོན་མཆོག་ཡ་ཝཱེས་དོན་ཞིག་གསར་དུ་བཏོད་ཅིང། ས་གཞིས་རང་གི་ཁ་གདངས་ཏེ་ཁོ་རྣམས་དང་ཁོ་རྣམས་ལ་ཡོད་པ་ཐམས་ཅད་ཁྱུར་མིད་བཏང་ནས་གསོན་པོར་གཤིན་ཡུལ་དུ་ནུབ་ན། དེ་ནས་མི་འདི་དག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྐུར་བ་བཏབ་པ་ཁྱོད་ཅག་གིས་ཤེས་པར་འགྱུར་རོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","མོ་ཤེ་ཡིས་གཏམ་དེ་ཐམས་ཅད་བརྗོད་ཚར་བ་ན། དེ་རྣམས་ཀྱི་རྐང་འོག་གི་ས་གཞི་གས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ས་གཞིས་རང་གི་ཁ་གདངས་ནས་དེ་དག་དང་དེ་དག་གི་ཁྱིམ་ཚང་དང་། ཀོ་རཱག་གི་མི་དང་ནོར་རྫས་ཐམས་ཅད་ཁྱུར་མིད་བཏང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","དེ་བཞིན་ཁོ་རྣམས་དང་ཁོ་རྣམས་ལ་དབང་བ་ཐམས་ཅད་གསོན་པོར་གཤིན་ཡུལ་དུ་ནུབ་ཅིང་། ས་གཞིས་ཁོ་རྣམས་བཀབ་སྟེ་མི་ཚོགས་ལས་མེད་པར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","དེ་དག་གི་མཐའ་འཁོར་དུ་ཡོད་པའི་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ཀྱིས་དེ་རྣམས་ཀྱི་ངུ་འབོད་ཐོས་ནས་བྲོས་ཤིང་། ས་གཞིས་རང་ཅག་ཀྱང་ཁྱུར་མིད་གཏོང་སྲིད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕྱོགས་ནས་མེ་བྱུང་སྟེ་སྤོས་བསྒྲོན་པའི་མི་ཉིས་བརྒྱ་དང་ལྔ་བཅུ་བཅོམ་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","ཁྱོད་ཀྱིས་མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨེ་ལི་ཨ་ཟར་ལ་ཁ་བསྒོ་བཏང་ནས། ཁོ་ལ་སྤོས་ཕོར་དེ་དག་མེ་རོའི་ཁྲོད་ནས་ལེན་པ་དང་མེ་ནི་ས་གཞན་ལ་གཏོར་དུ་འཇུག་དགོས། དེ་ནི་སྤོས་ཕོར་རྣམས་དམ་པ་ཡིན་པས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","སྡིག་པ་བྱས་ནས་རང་སྲོག་བརླག་པ་དེ་རྣམས་ཀྱི་སྤོས་ཕོར་ཁྱོད་ཅག་གིས་ལེབ་མོར་བརྡུངས་ཏེ་མཆོད་ཁྲི་གཡོག་སྤྱད་དུ་བྱེད་དགོས། སྤོས་ཕོར་དེ་དག་ཁོ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་མྱོང་བས་དམ་པ་ཡིན་པར་མ་ཟད། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཕྱི་འདོམས་ཀྱི་རྟགས་ཤིག་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","དེ་ནས་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་གྱིས་མེས་བསྲེགས་པའི་མི་དེ་དག་གིས་ཕུལ་མྱོང་བའི་ལི་ཡི་སྤོས་ཕོར་རྣམས་བླངས་ནས། ལེབ་མོར་བརྡུང་དུ་བཅུག་སྟེ་མཆོད་ཁྲི་གཡོག་སྤྱད་དུ་བྱས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཕྱི་འདོམས་ཀྱི་རྟགས་ཤིག་ཏུ་བཞག་ཅིང་། ཨ་རོན་གྱི་རིགས་རྒྱུད་མ་ཡིན་པའི་ཕྱི་མི་སུ་ཡིན་ཡང་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཡོང་ནས་སྤོས་བསྒྲོན་པར་མི་བྱ་སྟེ། ཁོ་རང་ཀོ་རཱག་དང་ཁོའི་འགྲོགས་ཡ་བཞིན་དུ་མི་འགྱུར་བའི་ཕྱིར་ཡིན་ལ། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་ཨེ་ལི་ཨ་ཟར་ལ་གནང་བའི་བཀའ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","དེའི་ཕྱི་ཉིན་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཡོངས་ཀྱིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འཁང་ར་བྱས་ཏེ་ན་རེ། ཁྱོད་གཉིས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་འབངས་མི་བསད་པ་ཡིན་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","མི་ཚོགས་འདུས་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་རྒོལ་བའི་ཚེ། ཁོ་གཉིས་ཁ་ཕྱིར་འཁོར་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཕྱོགས་སུ་བལྟས་པ་ན། ཀྱེ་མ། མཇལ་འཕྲད་གུར་མཆོག་སྤྲིན་གྱིས་གཡོགས་ཤིང་དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་མངོན་པར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་དུ་སོང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","ཁྱོད་གཉིས་མི་ཚོགས་འདི་དང་འབྲལ་བར་གྱིས་ཤིག བདག་གིས་ཁོ་རྣམས་སྐད་ཅིག་ཉིད་ལ་མེད་པར་བྱའོ་ཞེས་གསུངས་པ་ན། ཁོ་གཉིས་ཀྱིས་གདོང་སར་བཏུད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","མོ་ཤེ་ཡིས་ཨ་རོན་ལ་འདི་ལྟར། ཁྱོད་ཀྱིས་སྤོས་ཕོར་ལོངས་ལ་མཆོད་ཁྲིའི་སྟེང་གི་མེ་དེའི་ནང་དུ་བླུགས་ཤིག དེའི་སྟེང་དུ་སྤོས་བསྒྲོན་རྗེས་མགྱོགས་པོར་མི་ཚོགས་ཡོད་སར་སོང་ལ། ཁོ་རྣམས་ཀྱི་དོན་དུ་སྡིག་བཤགས་བྱོས་ཤིག གང་ལ་ཟེར་ན། དཀོན་མཆོག་ཡ་ཝཱེ་ཐུགས་རབ་ཏུ་ཁྲོས་ཤིང་། གཉན་ནད་འགོ་ཚུགས་ཟིན་པའི་ཕྱིར་རོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","དེ་ནས་ཨ་རོན་གྱིས་མོ་ཤེ་ཡིས་བསྒོས་པ་བཞིན་དུ། སྤོས་ཕོར་ཁྱེར་ནས་མི་ཚོགས་ཀྱི་དཀྱིལ་དུ་རྒྱུགས་པ་ལ། ལྟོས་དང་། མི་རྣམས་ཀྱི་ཁྲོད་དུ་དངོས་གནས་གཉན་ནད་བྱུང་འགོ་ཚུགས། དེ་ནས་ཁོས་སྤོས་བསྒྲོན་ཞིང་མི་ཚོགས་ཀྱི་དོན་དུ་སྡིག་བཤགས་བྱས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ཁོ་ནི་གཤིན་པོ་དང་གསོན་པོ་གཉིས་ཀྱི་བར་ནས་འགྲེང་པ་ན། གཉན་ནད་མཚམས་ཆད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ཀོ་རཱག་གི་དོན་རྐྱེན་དབང་གིས་ཤི་བ་རྣམས་ལས་གཞན་གཉན་ནད་ལས་ཤི་བའི་མི་ནི་ཆིག་ཁྲི་བཞི་སྟོང་བདུན་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","དེ་ནས་ཨ་རོན་ཕྱིར་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁ་རུ་མོ་ཤེའི་རྩར་འབྱོར་བ་ན། གཉན་ནད་མཚམས་ཆད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཁ་བསྒོ་བྱོས་ལ། ཁོ་རྣམས་ལས་འཁར་བ་ལེན་དགོས་ཏེ། ཕ་ཁྱིམ་བཞིན་དུ་ཚོ་པ་རེ་ནས་འཁར་བ་རེ་ལེན་པ་དང་། ཁོ་རྣམས་ཀྱི་འགོ་དཔོན་ཐམས་ཅད་ནས་རང་རང་གི་ཕ་ཁྱིམ་བཞིན་དུ། བསྡོམས་པས་འཁར་བ་བཅུ་གཉིས་བླངས་ནས་སོ་སོའི་སྟེང་དུ་མི་རེ་རེའི་མིང་འགོད་པར་གྱིས། ");
INSERT INTO bodn_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ཡང་ལེ་ཝིའི་འཁར་བའི་སྟེང་ལ་ཨ་རོན་གྱི་མིང་འབྲི་དགོས། ཅི་ལ་ཞེ་ན། ཕ་ཁྱིམ་བཞིན་དུ་ཚོ་དཔོན་རེ་ལ་འཁར་བ་རེ་ཡོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","དེ་ནས་ཁྱོད་ཀྱིས་འཁར་བ་དེ་དག་མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་དཔང་མཛད་ཤུར་སྒམ་གྱི་དྲུང་དུ། བདག་ཁྱོད་དང་ཕྲད་པའི་གནས་དེར་འཇོག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ངས་འདེམས་སྲིད་པའི་མི་དེའི་འཁར་བ་ལས་མྱུ་གུ་འབུ་བར་འགྱུར། དེ་ནས་ངས་རང་ངོས་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཁྱོད་ལ་འཁང་ར་བྱེད་པ་མཚམས་འཇོག་ཏུ་འཇུག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཁ་བསྒོ་བཏང་བ་དང་། དེ་དག་གི་འགོ་དཔོན་ཐམས་ཅད་ཀྱིས་འཁར་བ་ཁོ་ལ་སྤྲད་དེ། དེ་དག་གི་ཕ་ཁྱིམ་བཞིན་དུ་འགོ་དཔོན་རེ་ལ་འཁར་བ་གཅིག་རེ་དང་བསྡོམས་པས་འཁར་བ་བཅུ་གཉིས་ཡོད། ཨ་རོན་གྱི་དབྱུག་པའང་དེ་དག་གི་ཁྲོད་དུ་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","མོ་ཤེ་ཡིས་འཁར་བ་དེ་དག་དཔང་པོའི་གུར་མཆོག་ནང་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་བཞག་གོ ། ");
INSERT INTO bodn_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","དེའི་ཕྱི་ཉིན་མོ་ཤེ་དཔང་པོའི་གུར་མཆོག་གི་ནང་དུ་སོང་བ་ན། ཀྱེ་ཧོ། ལེ་ཝི་ཁྱིམ་རྒྱུད་ཀྱི་ཨ་རོན་གྱི་འཁར་བ་ལས་མྱུ་གུ་འབུས་ཤིང་གང་བུ་ཐོན་ནས་མེ་ཏོག་བཞད་པ་དང་སྟར་ཀའི་འབྲས་བུ་ཐོགས་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","དེ་ནས་མོ་ཤེ་ཡིས་འཁར་བ་དེ་ཐམས་ཅད་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་ནས་ཕྱི་རོལ་ཏུ་ཁྱེར་འོངས་ནས་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་ལ་བསྟན་པ་དང་། ཁོ་རྣམས་ཀྱིས་དེ་མཐོང་ནས་མི་རེ་རེས་རང་རང་གི་འཁར་བ་བླངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཨ་རོན་གྱི་འཁར་བ་དེ་ཕྱིར་དཔང་མཛད་ཤུར་སྒམ་གྱི་དྲུང་དུ་ཞོག་ཅིག དེ་ནི་རྒྱབ་འགལ་བྱེད་མཁན་རྣམས་ལ་རྟགས་ཤིག་ཡིན་ཞིང་། ཡང་ཁོ་རྣམས་འཆི་བར་མི་འགྱུར་བའི་སླད། ཁྱོད་ཀྱིས་དེ་དག་གིས་ང་ལ་འཁང་ར་བྱེད་པ་མཚམས་འཇོག་ཏུ་འཇུག་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","དེ་ནས་མོ་ཤེ་ཡིས་དེ་བཞིན་བྱས་པ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེས་ཁོ་ལ་ཅི་ལྟར་བཀའ་གནང་བ་ཡིན་ན། ཁོས་ཀྱང་དེ་བཞིན་བསྒྲུབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་མོ་ཤེ་ལ། ཀྱེ། ང་ཚོ་འཆི་བར་འགྱུར། ང་ཚོ་མེད་པར་འགྱུར། ང་ཚོ་ཚང་མ་མེད་པར་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","དཀོན་མཆོག་ཡ་ཝཱེའི་གུར་མཆོག་གི་ཉེ་སར་ཡོང་མཁན་ཐམས་ཅད་འཆི་བར་ངེས། ངེད་ཅག་ཐམས་ཅད་འཆི་དགོས་སམ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་རོན་ལ་འདི་སྐད་དུ། ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་དང་ཁྱོད་ཀྱི་ཕ་ཁྱིམ་གྱི་མི་རྣམས་ཀྱིས་ཁྱོད་དང་མཉམ་དུ་གནས་མཆོག་གི་ཉེས་པ་འཁུར་དགོས། ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་ཀྱིས་ཁྱོད་དང་མཉམ་དུ་མཆོད་དཔོན་གྱི་ལས་འགན་དང་འགལ་བའི་ཉེས་པ་འཁུར་བར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ཁྱོད་ཀྱིས་རང་གི་གཉེན་རྒྱུད་ལེ་ཝི་ཚོ་པ་སྟེ་ཁྱོད་ཀྱི་ཕ་མེས་ཀྱི་ཚོ་པ་ཁྱོད་དང་མཉམ་དུ་ཁྲིད་ཡོང་ནས། དེ་རྣམས་ཁྱོད་དང་འབྲེལ་བར་མ་ཟད། ཁྱོད་ལ་ཞབས་ཕྱི་བྱེད་དུ་འཇུག་དགོས། འོན་ཀྱང་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་དཔང་པོའི་གུར་མཆོག་གི་དྲུང་དུ་འདུག་པར་བྱ། ");
INSERT INTO bodn_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","དེ་དག་གིས་ཁྱོད་ལ་ཞབས་ཕྱི་བསྒྲུབ་པ་དང་མཇལ་འཕྲད་གུར་མཆོག་ནང་གི་དོན་ཐམས་ཅད་ལ་འགན་འཁུར་དགོས་ཀྱང་། གནས་མཆོག་གི་ཡོ་བྱད་དང་མཆོད་ཁྲིའི་ཉེ་སར་འགྲོ་མི་འོས། དེ་ནི་ཁོ་རྣམས་དང་ཁྱོད་ཅག་ཀུན་པོ་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ཁོ་རྣམས་ཁྱོད་དང་འབྲེལ་ནས་མཇལ་འཕྲད་གུར་མཆོག་བསྲུང་དགོས་པ་དང་། གུར་མཆོག་གི་ཞབས་ཕྱི་ཐམས་ཅད་བསྒྲུབ་དགོས། ཕྱི་མི་རྣམས་ཁྱོད་ཅག་གི་ཉེ་སར་འོང་མི་རུང་། ");
INSERT INTO bodn_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཁོང་ཁྲོ་མི་ཕོག་པའི་ཕྱིར་དུ། ཁྱོད་ཅག་གིས་གནས་མཆོག་དང་མཆོད་ཁྲི་བསྲུང་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ལྟོས་དང་། བདག་གིས་ཁྱོད་ཀྱི་གཉེན་རྒྱུད་ལེ་ཝི་པ་རྣམས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་དངོས་སུ་བདམས་ཏེ། མཇལ་འཕྲད་གུར་མཆོག་གི་ཞབས་ཕྱི་བསྒྲུབ་པའི་ཕྱིར། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་ཞིང་ཁྱོད་ཅག་ལ་ལེགས་སྐྱེས་སུ་བཏང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྣམས་ཀྱིས་ཁྱོད་དང་མཉམ་དུ་མཆོད་དཔོན་གྱི་འགན་བསྲུང་དགོས་པ་དང་། མཆོད་ཁྲི་དང་ཡོལ་བའི་ནང་རོལ་གྱི་དོན་ཐམས་ཅད་བསྒྲུབས་ནས་ཞབས་ཕྱི་བྱེད་དགོས། བདག་གིས་མཆོད་དཔོན་གྱི་ལས་འགན་ནི་ཁྱོད་རྣམས་ལ་ཞབས་ཕྱི་བསྒྲུབ་པའི་གནང་སྦྱིན་དུ་སྤྲད་པ་ཡིན་ལ། ཕྱི་མི་ཉེ་བར་འོངས་ན་ངེས་པར་གསོད་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་རོན་ལ་འདི་སྐད་དུ། ལྟོས་དང་། བདག་གིས་རང་ལ་དབང་བའི་འདེགས་མཆོད་དེ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དམ་པར་བྱས་པའི་རྫས་ཐམས་ཅད་ནི་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྒྱུད་རྣམས་ལ་དུས་གཏན་དུ་འཐོབ་འོས་པའི་བགོ་སྐལ་དུ་སྤྲད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་བདག་ལ་ཕུལ་བའི་མེ་མ་བརྒྱུད་པའི་མཆོད་པ་ཀུན་ལས་དམ་པ་ཐམས་ཅད་དེ། འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་སྡིག་བཤགས་མཆོད་པ་དང་། ཉེས་སེལ་མཆོད་པ་བཅས་ནི་ཀུན་ལས་དམ་པའི་རྫས་བྱས་ནས་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་རྒྱུད་རྣམས་ལ་དབང་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ཁྱོད་ཀྱིས་ཀུན་ལས་དམ་པ་ཡིན་པའི་གནས་སུ་དེ་བཟའ་དགོས་ལ། སྐྱེས་པ་ཐམས་ཅད་ཀྱིས་དེ་བཟའ་རུང་བ་ཡིན། ཁྱོད་ཀྱིས་རྫས་དེ་དམ་པར་བརྩི་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཕྱག་རྟེན་ལས་འདེགས་མཆོད་དང་གཡོབ་མཆོད་ཐམས་ཅད་ནི་ཁྱོད་ཀྱི་ཡིན་ཏེ། ངས་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་དང་བུ་མོ་རྣམས་ལ་དུས་གཏན་དུ་འཐོབ་འོས་པའི་བགོ་སྐལ་དུ་སྤྲད་པ་དང་། ཁྱོད་ཀྱི་ཁྱིམ་དུ་གཙང་མ་ཡིན་པ་ཐམས་ཅད་ཀྱིས་དེ་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","སྣུམ་ཡག་ཤོས་དང་། རྒུན་ཆང་གསར་པ་ཡག་ཤོས་དང་། འབྲུ་རིགས་བཅས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་སྟོན་ཐོག་རྣམས་ནི་ངས་ཁྱོད་ལ་སྤྲད་པ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ཁོ་རྣམས་ཀྱིས་ཡུལ་ནས་ཁྱེར་འོངས་ཏེ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་སྟོན་ཐོག་ཐམས་ཅད་ཁྱོད་ཅག་གི་ཡིན། ཁྱོད་ཀྱི་ཁྱིམ་དུ་གཙང་མ་ཡིན་པ་ཐམས་ཅད་ཀྱིས་དེ་བཟའ་རུང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ཡེས་ར་ཨེལ་པའི་ཁྲོད་ནས་བསྔོས་པ་ཐམས་ཅད་ཀྱང་ཁྱོད་ཀྱི་ཡིན་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ཤ་ཁྲག་གདོས་བཅས་ཀྱི་སྲོག་ལྡན་སྐྱེས་འགོ་རྣམས་ཏེ། ཁོ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བ་ནི་མི་ཕྱུགས་གང་ཡིན་ཡང་ཐམས་ཅད་ཁྱོད་ཀྱི་ཡིན། འོན་ཀྱང་མིའི་རིགས་ཀྱི་སྐྱེས་འགོ་ནི་ཁྱོད་ཀྱིས་ངེས་པར་བླུ་དགོས་ལ། ཕྱུགས་མི་གཙང་བ་རྣམས་ཀྱི་སྐྱེས་འགོ་ཡང་བླུ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ཡང་དེ་དག་གི་བླུ་རིན་ནི། ཟླ་བ་གཅིག་བརྒལ་རྗེས་ཁྱོད་ཀྱིས་རང་གིས་ཚོད་རྩིས་བྱས་པའི་རིན་དང་། གནས་མཆོག་གི་སྲང་བཞིན་དུ། དངུལ་སྲང་ལྔ་ཡིས་བླུ་དགོས་ཏེ། སྲང་གཅིག་ནི་གཱེ་ར་ཉི་ཤུ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","འོན་ཀྱང་བ་གླང་གི་སྐྱེས་འགོའམ། ལུག་གི་སྐྱེས་འགོའམ། ཡང་ན་ར་ཡི་སྐྱེས་འགོ་རྣམས་ནི་དམ་པ་ཡིན་པས་བླུ་མི་རུང་། ཁྱོད་ཀྱིས་དེ་དག་གི་ཁྲག་ནི་མཆོད་ཁྲིའི་སྟེང་དུ་གཏོར་བ་དང་། ཚིལ་ནི་མེ་རུ་བསྲེགས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་དུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","དེ་དག་གི་ཤ་ཁྱོད་ཀྱི་ཡིན་ཏེ། གཡོབ་མཆོད་ཡིན་པའི་བྲང་ཁོག་དང་བརླ་གཡས་པ་ཁྱོད་ཀྱི་ཡིན་པ་བཞིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་རྫས་དམ་པའི་ཁྲོད་ཀྱི་འདེགས་མཆོད་ཐམས་ཅད། ངས་ཁྱོད་དང་ཁྱོད་ཀྱི་བུ་དང་བུ་མོ་རྣམས་ལ་དུས་གཏན་དུ་འཐོབ་འོས་པའི་བགོ་སྐལ་དུ་སྤྲད་པ་ཡིན། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཁྱོད་དང་ཁྱོད་ཀྱི་རིགས་རྒྱུད་རྣམས་ཀྱི་དུས་གཏན་གྱི་ཚྭའི་ཞལ་ཆད་ཅིག་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","དཀོན་མཆོག་ཡ་ཝཱེས་ཨ་རོན་ལ་འདི་སྐད་དུ། ཁྱོད་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཡུལ་དུ་ས་སྐལ་ཡོད་མི་རུང་ལ། དེ་དག་གི་ཁྲོད་དུ་སྐལ་ཡང་ཡོད་མི་རུང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་བདག་ནི་ཁྱོད་ཀྱི་ཐོབ་སྐལ་དང་ཁྱོད་ཀྱི་བགོ་སྐལ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ཡང་ལེ་ཝིའི་བུ་རྒྱུད་རྣམས་ལ་བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་འབུལ་བའི་བཅུ་ཆ་གཅིག་ཐམས་ཅད་ཁོ་ཚོར་དངོས་སུ་བགོ་སྐལ་གྱི་ཚབ་ཏུ་སྤྲད་པ་སྟེ། དེ་དག་གིས་མཇལ་འཕྲད་གུར་མཆོག་གི་ནང་དུ་ཞབས་ཕྱི་བསྒྲུབས་པའི་ཐོབ་ཆ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","དུས་ད་ནས་བཟུང་ཡེས་ར་ཨེལ་པ་རྣམས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཉེ་སར་འོང་མི་རུང་། དེ་ནི་སྡིག་པ་ཁུར་ནས་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར་དུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ལེ་ཝི་པ་རྣམས་ཀྱིས་མཇལ་འཕྲད་གུར་མཆོག་གི་ཞབས་ཕྱི་བསྒྲུབས་ནས་རང་གི་ཉེས་པ་འཁུར་དགོས། དེ་ནི་ཁྱོད་རྣམས་མི་རབས་ནས་མི་རབས་བར་གྱི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་དེ་དག་ལ་བགོ་སྐལ་ཡོད་མི་རུང་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་འདེགས་མཆོད་ཀྱི་བཅུ་ཆ་གཅིག་ནི་བདག་གིས་ལེ་ཝི་པ་རྣམས་ལ་བགོ་སྐལ་དུ་སྤྲད་ཡོད། དེ་བས་བདག་གིས་དེ་དག་ལ་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་བགོ་སྐལ་ཡོད་མི་རུང་སྨྲས་པ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཁྱོད་ཅག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ངས་ཁྱོད་རྣམས་ལ་ནོར་སྐལ་དུ་སྤྲད་པའི་བཅུ་ཆ་གཅིག་ལེན་པའི་ཚེ། ཁྱོད་ཅག་གིས་དེ་ལས་བཅུ་ཆ་གཅིག་བླངས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་དུ་འབུལ་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","དེ་ནི་ཁྱོད་ཅག་གི་འདེགས་མཆོད་ལ་བརྩི་བ་སྟེ། གཡུལ་ཁའི་ནང་གི་འབྲུ་རིགས་དང་རྒུན་འབྲུམ་འཚིར་གཞོང་ནང་གི་ལྟེམས་ལྟེམས་གང་བའི་རྒུན་ཆང་བཞིན་དུ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","དེ་བཞིན་ཁྱོད་ཅག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་ཐོབ་པའི་བཅུ་ཆ་གཅིག་དེ་ལས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་དུ་འབུལ་དགོས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ཕུལ་བའི་འདེགས་མཆོད་དེ་ཁྱོད་ཅག་གིས་མཆོད་དཔོན་ཨ་རོན་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ཁྱོད་རྣམས་ལ་ཐོབ་པའི་ལེགས་སྐྱེས་ཐམས་ཅད་ལས་ཡག་ཤོས་ནི་དམ་པར་བྱས་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདེགས་མཆོད་དུ་ཕུལ་ཞིག་ཅེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","དེ་བས་ན། ཁྱོད་ཀྱིས་ལེ་ཝི་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག གལ་སྲིད་ཁྱོད་རྣམས་ཀྱིས་ཡག་ཤོས་དེ་ཕུལ་བ་ཡིན་ན། དེ་ནི་ཁྱོད་རྣམས་ཀྱི་གཡུལ་ཁའི་ནང་གི་འབྲུ་རིགས་དང་རྒུན་འབྲུམ་འཚིར་གཞོང་ནང་གི་རྒུན་ཆང་དུ་བརྩི་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ཁྱོད་ཅག་དང་ཁྱོད་ཅག་གི་ནང་མི་རྣམས་ཀྱིས་གནས་གང་དུ་ཡང་ཟོས་ཆོག ཅི་ལ་ཞེ་ན། དེ་ནི་ཁྱོད་ཅག་གི་གླ་ཆ་དང་ཁྱོད་ཅག་གིས་མཇལ་འཕྲད་གུར་མཆོག་ནས་ཞབས་ཕྱི་བསྒྲུབས་པའི་ཐོབ་ཆ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ཁྱོད་ཅག་གིས་ཡག་ཤོས་དེ་ག་དུས་འདེགས་མཆོད་དུ་ཕུལ་བ་ཡིན་ན་སྡིག་པ་འཁུར་མི་དགོས། ཁྱོད་ཅག་འཆི་བར་མི་འགྱུར་བའི་ཕྱིར། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་རྫས་དམ་པ་རྣམས་སྦག་མི་རུང་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","ཡ་ཝཱེས་གནང་བའི་བཀའ་ཁྲིམས་ཀྱི་སྒྲིག་སྲོལ་ནི་འདི་ལྟ་སྟེ། ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་བསྒོ་བར་བྱ། བ་དྲུས་མ་དམར་པོ་ལྷད་མེད་སྐྱོན་མེད་གཉའ་ཤིང་འཁུར་མ་མྱོང་བ་ཞིག་ཁྱོད་ཀྱི་རྩར་འཁྲིད་ཡོང་དགོས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ཁྱོད་ཅག་གིས་བ་གཞོན་དེ་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་ལ་སྤྲོད་དགོས་པ་དང་། ཁོས་བ་གཞོན་སྒར་གྱི་ཕྱི་རོལ་ཏུ་ཁྲིད་ནས་མི་ཞིག་གིས་དེ་ཁོའི་མདུན་དུ་བཤའ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","དེ་ནས་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་གྱིས་རང་གི་མཛུབ་གུ་ཁྲག་ལ་བསྒྲེས་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་མདུན་ཕྱོགས་སུ་ལན་བདུན་ལ་གཏོར་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","དེ་ནས་མི་ཞིག་གིས་བ་དྲུས་མ་དེ་མཆོད་དཔོན་གྱི་མིག་ལམ་དུ་བསྲེག་དགོས། དེའི་པགས་པ་དང་། ཤ་དང་། ཁྲག་དང་། ལྕི་བ་བཅས་ཡོངས་སུ་བསྲེག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","མཆོད་དཔོན་གྱིས་ཐང་ཤིང་དང་། ཨི་སོབ་རྩྭ་ཤིང་དང་། བལ་སྐུད་མཚལ་དམར་བཅས་བླངས་ནས་བ་དྲུས་མ་དེ་འཚིག་བཞིན་པའི་མེའི་ནང་དུ་གཡུག་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","དེ་ནས་མཆོད་དཔོན་གྱིས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། རང་གི་ལུས་པོ་ཆུ་ལ་བཀྲུས་རྗེས་ད་གཟོད་སྒར་དུ་ཡོང་དགོས། འོན་ཀྱང་དགོང་མོའི་བར་དུ་མཆོད་དཔོན་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","བ་གཞོན་མེ་ལ་སྲེག་མཁན་མི་དེས་ཀྱང་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་རང་གི་ལུས་པོ་ཆུ་ནང་དུ་བཀྲུ་དགོས་ལ། ཁོ་ཡང་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","གཙང་མ་ཡིན་པའི་མི་ཞིག་གིས་བ་དྲུས་མ་ཡི་ཐལ་བ་བསྡུས་ཏེ། སྒར་ཁའི་ཕྱི་རོལ་གྱི་གནས་གཙང་ས་ཞིག་ཏུ་འཇོག་པ་དང་། ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཀྱི་ཕྱིར་དུ་སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་བྱས་ནས་འཇོག་དགོས་ཤིང་། དེ་ནི་སྡིག་པ་སེལ་བྱེད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","དེ་ནས་བ་དྲུས་མ་དེའི་ཐལ་བ་བསྡུ་བའི་མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་བ་དང་། དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། དེ་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་དང་ཁོ་ཚོའི་ཁྲོད་དུ་གནས་པའི་ཕྱི་མི་རྣམས་ཀྱི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","འདས་པོ་ཞིག་གི་བེམ་པོར་རེག་པའི་མི་སུ་ཡིན་ཡང་། ཉིན་བདུན་གྱི་རིང་ལ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","མི་དེས་ཉིན་གསུམ་པ་དང་ཉིན་བདུན་པར་སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་དེས་རང་ཉིད་གཙང་མར་བཟོ་དགོས་པ་དང་། དེ་ནས་ཁོ་རང་གཙང་མར་འགྱུར། གལ་སྲིད་ཉིན་གསུམ་པ་དང་ཉིན་བདུན་པ་ལ་རང་ཉིད་གཙང་མར་མ་བཟོས་ན། དེ་ནས་ཁོ་གཙང་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","སུ་ཞིག་གིས་འདས་པོ་ཞིག་གི་བེམ་པོར་རེག་པ་དང་། རང་ཉིད་གཙང་མར་མི་བཟོ་ན། དེས་དཀོན་མཆོག་ཡ་ཝཱེའི་གུར་མཆོག་སྦགས་པ་ཡིན། མི་དེ་ནི་ཡེས་ར་ཨེལ་པའི་ཁྲོད་ནས་འཕུད་དགོས། ཅི་ལ་ཟེར་ན། སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་དེ་རང་སྟེང་ལ་མ་གཏོར་བས་མི་གཙང་བ་ཡིན་ཏེ། དེའི་མི་གཙང་བ་ནི་སྔར་བཞིན་ཁོའི་སྟེང་དུ་གནས་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","གལ་སྲིད་མི་ཞིག་གུར་གྱི་ནང་དུ་ཤི་ཚེ། དེའི་བཀའ་ཁྲིམས་ནི་འདི་ལྟ་སྟེ། གུར་གྱི་ནང་དུ་ཡོང་མཁན་དང་དེའི་ནང་དུ་ཡོད་པ་ཐམས་ཅད་ཉིན་བདུན་གྱི་རིང་ལ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ཁ་ཕྱེས་པའི་སྣོད་ཆས་ཏེ་ཁ་གཅོད་བརྒྱབ་མེད་པའི་སྣོད་ཆས་ཚང་མ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","སུ་ཞིག་གིས་ཞིང་ཁར་རལ་གྲིས་བསད་པའི་མིའམ། རང་བཞིན་གྱིས་ཤི་བའི་བེམ་པོའམ། ཡང་ན་མིའི་རུས་པའམ། ཡང་ན་དུར་ས་བཅས་ལ་རེག་པ་ཡིན་ན་ཉིན་བདུན་གྱི་རིང་ལ་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","གཙང་མ་མིན་པ་དེའི་ཕྱིར་དུ། མེ་རུ་འཚིག་པའི་སྡིག་པ་སེལ་བྱེད་ཀྱི་ཐལ་བ་བླངས་ནས་སྣོད་ཅིག་གི་ནང་དུ་འཇོག་པ་དང་། དེ་ལ་ཆུ་གསར་པ་བླུགས་ནས། ");
INSERT INTO bodn_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","དེ་ནས་གཙང་མ་ཡིན་པའི་མི་ཞིག་གིས་ཨི་སོབ་རྩྭ་ཤིང་བླངས་ནས་ཆུ་ནང་དུ་བསྒྲེས་ཏེ། གུར་གྱི་སྟེང་དང་སྣོད་ཆས་ཐམས་ཅད་ཀྱི་སྟེང་དུ་གཏོར་བ་དང་། ཡང་དེར་ཡོད་པའི་མི་རྣམས་ཀྱི་སྟེང་དང་། རུས་པའམ་རལ་གྲིས་བསད་པའམ། རང་བཞིན་གྱིས་ཤི་བའམ། དུར་ས་བཅས་ལ་རེག་པའི་མི་ཡི་སྟེང་དུ་གཏོར་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ཉིན་གསུམ་པ་དང་ཉིན་བདུན་པར་གཙང་མ་ཡིན་པའི་མི་དེས་གཙང་མ་མིན་པའི་མི་ཡི་སྟེང་དུ་ཆུ་གཏོར་དགོས། དེ་བཞིན་ཉིན་བདུན་པ་ལ་མི་དེ་གཙང་མར་བཟོ་བ་དང་། ཁོས་རང་གི་གོས་རྣམས་བཀྲུ་ཞིང་ལུས་པོ་ཆུ་ནང་བཀྲུ་དགོས་ལ། དགོང་མོའི་དུས་སུ་ཁོ་གཙང་མ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","འོན་ཀྱང་གཙང་མ་མིན་པའི་མི་དེས་རང་ཉིད་གཙང་མར་མི་བཟོ་ན། མི་དེ་ནི་མི་ཚོགས་ཀྱི་ཁྲོད་ནས་འཕུད་དགོས། ཅི་ལ་ཞེ་ན། ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་གནས་མཆོག་སྦགས་པ་དང་། སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་ཁོའི་སྟེང་དུ་མ་གཏོར་བས་ཁོ་ནི་མི་གཙང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","དེ་ནི་ཁྱོད་ཅག་གི་དུས་གཏན་གྱི་སྒྲིག་ཁྲིམས་ཡིན། སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་གཏོར་བའི་མི་དེས་རང་གི་གོས་རྣམས་བཀྲུ་དགོས་པ་དང་། སྦག་བཙོག་སེལ་བྱེད་ཀྱི་ཆུ་ལ་རེག་པའི་མི་ནི་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","གཙང་མ་མིན་པའི་མི་ཡིས་གང་ཞིག་ལ་རེག་པ་ཐམས་ཅད་མི་གཙང་བ་ཡིན་ལ། ཡང་དེ་ལ་རེག་པའི་མི་སུ་ཡིན་ཡང་དགོང་མོའི་བར་དུ་མི་གཙང་བ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ཟླ་བ་དང་པོར་ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཡོངས་རྫོགས་ཟིན་ཞེས་པའི་དབེན་སྟོང་དུ་ཕྱིན་ནས་ཀཱ་དེའེ་ཤཱ་རུ་བསྡད། མིར་ཡམ་དེ་རུ་ཚེ་ལས་འདས་ཤིང་ཡུལ་དེ་རུ་དུར་ལ་སྦས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","དེ་རུ་མི་ཚོགས་ལ་འཐུང་ཆུ་མེད་པས། ཁོ་རྣམས་འདུས་ཏེ་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་རྒོལ་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","མི་ཚོགས་ཀྱིས་མོ་ཤེ་ལ་རྩོད་པ་བྱས་ནས་འདི་ལྟར། ང་ཚོའི་སྤུན་ཟླ་རྣམས་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཤི་བའི་ཚེ་ངེད་ཅག་ཀྱང་ཤི་ན་ལེགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེའི་མི་ཚོགས་དབེན་སྟོང་འདི་རུ་ཁྲིད་འོངས་དོན་ཅི། ངེད་རྣམས་དང་ངེད་ཅག་གི་ཕྱུགས་རྣམས་འདི་རུ་འཆི་བའི་ཕྱིར་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ཁྱོད་ཅག་གིས་ཅིའི་ཕྱིར་ངེད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཡར་ས་ཆ་ངན་པ་འདིར་ཁྲིད་ཡོང་བ་ཡིན་ནམ། འདི་རུ་འབྲུ་རིགས་དང་སེ་ཡབ་ཤིང་། རྒུན་ཤིང་། སེ་འབྲུ་སྡོང་པོ་བཅས་མེད་ལ། འཐུང་ཆུ་ཡང་མེད་དོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་མི་ཚོགས་དང་བྲལ་ནས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་སོང་སྟེ་ཕྱག་བཙལ་བ་ན། དཀོན་མཆོག་ཡ་ཝཱེའི་གཟི་འོད་ཁོ་ཚོ་ལ་སྣང་བར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","ཁྱོད་ཀྱིས་འཁར་བ་ཁྱེར་ནས་ཁྱོད་ཀྱི་ཕུ་བོ་ཨ་རོན་དང་མཉམ་དུ་མི་ཚོགས་བསྡུ་བར་གྱིས། དེ་དག་གི་མིག་ལམ་དུ་བྲག་རྡོ་ལ་ཆུ་བཞུར་བར་སྒོས་ཤིག དེ་ནས་ཁྱོད་ཀྱིས་བྲག་རྡོ་ནས་ཆུ་བཏོན་ཏེ་མི་ཚོགས་དང་དེའི་ཕྱུགས་རྣམས་ལ་ཆུ་ལྡུད་པར་འགྱུར་རོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ། ཁོང་གི་དྲུང་ནས་འཁར་བ་ཁྱེར་ཏེ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","དེ་ནས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ཀྱིས་མི་ཚོགས་བྲག་གི་མདུན་དུ་བསྡུས་ནས་ཁོ་རྣམས་ལ་འདི་ལྟར། ངོ་ལོག་པ་ཁྱོད་ཅག་གིས་ཉོན་ཅིག ངེད་གཉིས་ཀྱིས་བྲག་འདི་ནས་ཁྱོད་རྣམས་ལ་ཆུ་འདོན་པར་བྱའམ་ཞེས་སྨྲས་ཤིང་། ");
INSERT INTO bodn_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","མོ་ཤེ་ཡིས་ལག་པ་ཡར་བཏེགས་ཏེ། འཁར་བས་བྲག་ལ་ལན་གཉིས་བརྡུངས་པ་ན་ཆུ་མང་པོ་ཐོན། དེ་ནས་མི་ཚོགས་དང་དེའི་ཕྱུགས་རྣམས་ཀྱིས་ཆུ་འཐུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེ་ཡིས་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ཁྱོད་གཉིས་ཀྱིས་བདག་ལ་དད་པ་མ་བྱས་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མདུན་དུ་ང་དམ་པར་མ་བཀུར་བའི་རྐྱེན་གྱིས། ཁྱོད་གཉིས་ཀྱིས་མི་ཚོགས་འདི་བདག་གིས་གནང་བར་བྱ་བའི་ཡུལ་དུ་འཁྲིད་པར་མི་འགྱུར་རོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","དེ་ནི་མེ་རི་བཱ་ཡུལ་གྱི་ཆུ་རྣམས་ཡིན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་རྩོད་པ་བྱས་ཤིང་། ཁོང་གིས་དེ་དག་གི་ཁྲོད་དུ་རང་ཉིད་དམ་པ་ཡིན་པ་བསྟན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","མོ་ཤེ་ཡིས་ཀཱ་དེའེ་ཤཱ་ནས་ཨེ་དོམ་གྱི་རྒྱལ་པོ་ལ་བང་ཆེན་རྣམས་བཏང་སྟེ་ན་རེ། ཁྱེད་ཀྱི་སྤུན་ཟླ་ཡེས་ར་ཨེལ་གྱིས་ཁྱེད་ལ་འདི་ལྟར། ངེད་ཅག་ལ་བྱུང་བའི་དཀའ་སྡུག་ཐམས་ཅད་ཁྱེད་ཀྱིས་ཤེས་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ངེད་ཅག་གི་མེས་པོ་རྣམས་མར་ཨེ་ཅིབ་ཡུལ་དུ་སོང་བ་དང་། ངེད་རྣམས་ཨེ་ཅིབ་ཡུལ་ནས་ཡུན་རིང་པོར་བསྡད་ཅིང་། ཨེ་ཅིབ་པ་རྣམས་ཀྱིས་ངེད་ཅག་དང་ངེད་ཅག་གི་མེས་པོ་རྣམས་ལ་དཀའ་ངལ་མང་པོ་སྤྲད། ");
INSERT INTO bodn_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ངེད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འོ་དོད་བོས་པ་དང་། ཁོང་གིས་ངེད་རྣམས་ཀྱི་སྐད་གསན་ནས་ཕོ་ཉ་མངགས་ཏེ་ངེད་ཅག་ཨེ་ཅིབ་ཡུལ་ནས་ཁྲིད་ཐོན་པ་ཡིན། ལྟོས་དང་། ད་ལྟ་ངེད་ཅག་ཁྱེད་ཀྱི་མཐའ་མཚམས་སུ་ཡོད་པའི་གྲོང་ཁྱེར་ཀཱ་དེའེ་ཤཱ་རུ་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ཁྱེད་ཀྱིས་ངེད་རྣམས་ཁྱེད་ཀྱི་ཡུལ་བརྒྱུད་ནས་འགྲོ་རུ་འཇུག་པར་མཛོད། ངེད་ཅག་ཞིང་ཁ་དང་རྒུན་འབྲུམ་ར་བ་བརྒྱུད་ནས་མི་འགྲོ་ལ། ཁྲོན་པ་རྣམས་ཀྱི་ཆུ་ཡང་མི་འཐུང་། ངེད་རྣམས་རྒྱལ་པོའི་ལམ་ཆེན་ནས་འགྲོ་ཞིང་། ཁྱེད་ཀྱི་ས་མཚམས་ནས་བརྒལ་བའི་བར་དུ་ལམ་གྱི་གཡས་གཡོན་གང་དུའང་གཟུར་བར་མི་བྱ་ཞེས་ཟེར་རོ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ཨེ་དོམ་གྱིས་བང་ཆེན་ལ་འདི་ལྟར། ཁྱོད་རྣམས་ངའི་ཡུལ་བརྒྱུད་ནས་འགྲོ་མི་ཆོག གལ་སྲིད་སོང་ན། ངས་རལ་གྲི་ཁྱེར་ནས་ཁྱོད་རྣམས་ལ་འཐབ་པར་སླེབ་ཡོང་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཁོ་ལ། ངེད་ཅག་ལམ་ཆེན་ནས་ཡར་འགྲོ་བ་དང་། ངེད་ཅག་དང་ངེད་ཅག་གི་ཕྱུགས་རྣམས་ཀྱིས་ཁྱེད་ཀྱི་ཆུ་འཐུང་ན་དེ་ལ་རིན་སྤྲོད་ངེས་ཤིང་། ངེད་རྣམས་རྐང་ཐང་ལ་ཡུལ་འདི་བརྒྱུད་ནས་འགྲོ་ཆོག་པར་ཞུ། གཞན་ཅི་ཡང་མི་དགོས་ཞེས་ཞུས་ཀྱང་། ");
INSERT INTO bodn_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ཨེ་དོམ་གྱི་རྒྱལ་པོ་ན་རེ། ཁྱོད་རྣམས་ཡུལ་འདི་བརྒྱུད་ནས་འགྲོ་མི་ཆོག་ཅེས་སྨྲས་ཏེ། མི་མང་པོ་ཁྲིད་ནས་བཙན་ཤུགས་དང་བཅས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་རྒོལ་བར་ཐོན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","དེ་ལྟར་ཨེ་དོམ་གྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་རང་གི་མངའ་ཁོངས་བརྒལ་ནས་འགྲོ་བར་མ་བཅུག་པས། ཡེས་ར་ཨེལ་པ་རྣམས་ཁོ་དང་བྲལ་ནས་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ཡེས་ར་ཨེལ་པའི་མི་ཚོགས་ཡོངས་ཀཱ་དེའེ་ཤཱ་ནས་ལམ་དུ་ཆས་ཏེ་ཧོར་ཞེས་པའི་རི་བོར་སླེབས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","དཀོན་མཆོག་ཡ་ཝཱེས་ཨེ་དོམ་ཡུལ་གྱི་ས་མཚམས་སུ་ཡོད་པའི་རི་བོ་ཧོར་ཞེས་པར་མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","ཨ་རོན་ནི་རང་གི་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཛོམ་པར་ངེས། ཁོ་ནི་བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྦྱིན་པའི་ཡུལ་དུ་འཛུལ་བར་མི་འགྱུར། གང་ལ་ཞེ་ན། ཁྱོད་གཉིས་མེ་རི་བཱའི་ཆུ་ཡི་ཐད་ནས་ངའི་བཀའ་དང་འགལ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","མོ་ཤེ་ཁྱོད་ཀྱིས་ཨ་རོན་དང་ཁོའི་བུ་ཨེ་ལི་ཨ་ཟར་གཉིས་ཁྲིད་ནས་རི་བོ་ཧོར་དུ་ཡར་སོང་ཞིག ");
INSERT INTO bodn_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ཨ་རོན་གྱི་འཕགས་གོས་རྣམས་ཕུད་ནས་ཁོའི་བུ་ཨེ་ལི་ཨ་ཟར་ལ་སྐོན་ཅིག ཨ་རོན་ནི་རང་གི་མེས་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཛོམས་ནས་གནས་དེར་འཆི་བར་འགྱུར་ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ་བསྒྲུབས་ཏེ། མི་ཚོགས་ཡོངས་ཀྱི་མཐོང་ངོར་རི་བོ་ཧོར་དུ་ཡར་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","དེ་ནས་མོ་ཤེ་ཡིས་ཨ་རོན་གྱི་འཕགས་གོས་རྣམས་ཕུད་ནས་ཁོའི་བུ་ཨེ་ལི་ཨ་ཟར་ལ་བསྐོན་པ་དང་། ཨ་རོན་རི་རྩེ་དེར་ཚེ་ལས་འདས་རྗེས་མོ་ཤེ་དང་ཨེ་ལི་ཨ་ཟར་གཉིས་རི་ནས་མར་བབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","དེ་ནས་མི་ཚོགས་ཡོངས་ཀྱིས་ཨ་རོན་ཚེ་ལས་འདས་པ་མཐོང་རྗེས། ཡེས་ར་ཨེལ་གྱི་ཁྱིམ་རྒྱུད་ཐམས་ཅད་ཨ་རོན་གྱི་དོན་དུ་ཉིན་སུམ་ཅུའི་རིང་ལ་བཤུམས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","དེ་ཡང་ནེ་གུབ་ཡུལ་དུ་གནས་པའི་ཨ་རད་ཀྱི་རྒྱལ་པོ་ཀ་ན་ཨན་པ་དེས། ཡེས་ར་ཨེལ་པ་རྣམས་ཨ་ཐཱ་རིམ་གྱི་ལམ་ནས་ཡོང་བ་ཐོས་ཏེ། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འཐབ་ཅིང་མི་འགའ་ཤས་བཟུང་ནས་ཁྲིད། ");
INSERT INTO bodn_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་དམ་བཅས་ཏེ་ན་རེ། གལ་སྲིད་ཁྱེད་ཀྱིས་མི་འདི་རྣམས་ངེད་ཅག་གི་ལག་ཏུ་སྤྲོད་པར་མཛད་ན། ངེད་རྣམས་ཀྱིས་དེ་དག་གི་གྲོང་ཁྱེར་རྣམས་མེད་པར་བྱེད་ངེས་ཡིན་ཞེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","དཀོན་མཆོག་ཡ་ཝཱེས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཞུ་བ་གསན་ནས། ཀ་ན་ཨན་པ་རྣམས་དེ་དག་གི་ལག་ཏུ་གཏད་ཅིང་། དེ་དག་གིས་ཀ་ན་ཨན་པ་རྣམས་དང་དེ་ཚོའི་གྲོང་ཁྱེར་རྣམས་རྩ་ནས་བཤིགས་པས། གནས་དེའི་མིང་ལ་ཧོར་མཱ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ཡེས་ར་ཨེལ་པ་རྣམས་རི་བོ་ཧོར་ནས་རྒྱ་མཚོ་དམར་པོར་འགྲོ་བའི་ལམ་བརྒྱུད་དེ། ཨེ་དོམ་གྱི་ཡུལ་བསྐོར་ནས་སོང་བ་ལ། ལམ་དེའི་རྐྱེན་གྱིས་མི་རྣམས་སེམས་འཚབས་ཏེ། ");
INSERT INTO bodn_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","དཀོན་མཆོག་དང་མོ་ཤེ་གཉིས་ལ་རྒོལ་ཞིང་ན་རེ། ཁྱེད་གཉིས་ཀྱིས་ངེད་རྣམས་ཅིའི་ཕྱིར་ཨེ་ཅིབ་ཡུལ་ནས་ཁྲིད་ཡོང་སྟེ་དབེན་སྟོང་དུ་འཆི་བར་བྱའམ། འདི་རུ་བག་ལེབ་མེད་ལ་ཆུ་ཡང་མེད། ཁ་ཟས་སྐྱོ་བོ་འདི་ལ་ངེད་རྣམས་སྐྱུག་མེར་ལངས་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་དུག་སྦྲུལ་རྣམས་མི་ཚོགས་ཁྲོད་དུ་བཏང་ཞིང་། སྦྲུལ་གྱིས་ཁོ་རྣམས་ལ་རྨུགས་པས་ཡེས་ར་ཨེལ་པ་མང་པོ་ཤི་བར་གྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","དེ་ནས་མི་རྣམས་ཡོང་ནས་མོ་ཤེ་ལ། ངེད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་དང་ཁྱེད་ལ་གཏམ་ངན་གྱིས་རྒོལ་བས་སྡིག་པ་བསགས། དཀོན་མཆོག་ཡ་ཝཱེས་སྦྲུལ་དེ་དག་ངེད་ཅག་དང་འབྲལ་བར་མཛད་པའི་ཕྱིར་ཁྱེད་ཀྱིས་སྨོན་ལམ་འདེབས་རོགས་ཞེས་ཞུས་པ་ན། མོ་ཤེ་ཡིས་མི་རྣམས་ཀྱི་དོན་དུ་སྨོན་ལམ་བཏབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་དུག་སྦྲུལ་ཞིག་བཟོས་ལ་ཀ་བའི་རྩེ་མོར་སྐྱོན་དང་། སྦྲུལ་གྱིས་རྨུགས་པའི་མི་ཀུན་གྱིས་སྦྲུལ་དེར་བལྟས་མ་ཐག་གསོན་པར་འགྱུར་ཞེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","མོ་ཤེ་ཡིས་ལི་ཡི་སྦྲུལ་ཞིག་བཟོས་ནས་ཀ་བའི་རྩེ་མོར་བསྐྱོན། དེ་ནས་སྦྲུལ་གྱིས་རྨུགས་པའི་མི་སུ་ཡིན་ཡང་ལི་ཡི་སྦྲུལ་དེར་བལྟས་པ་ཙམ་གྱིས་གསོན་པར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ལམ་དུ་ཆས་པ་དང་། ཨོ་བོད་བྱ་བའི་ཡུལ་ནས་སྒར་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ཡང་ཨོ་བོད་ནས་ལམ་དུ་ཞུགས་པ་དང་། མོ་ཨབ་ཕ་རོལ་གྱི་དབེན་སྟོང་དུ་ཡོད་ལ་ཤར་ཕྱོགས་སུ་འཁོར་བའི་ཨི་ཡེ་ཨ་བཱ་རིམ་ཡུལ་དུ་སྒར་བཏབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ཡང་ཁོ་རྣམས་དེ་ནས་ལམ་དུ་ཆས་ཏེ་ཟེ་རེད་ལུང་པར་སྒར་བཏབ་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ཡང་དེ་ནས་ལམ་དུ་ཆས་ཏེ་ཨར་ནོན་ཆུ་བོའི་ཕ་རོལ་ཏུ་སྒར་བཏབ། ཨར་ནོན་ཆུ་བོ་ནི་དབེན་སྟོང་དུ་ཡོད་ཅིང་ཨེ་མོར་པ་རྣམས་ཀྱི་ས་མཚམས་ནས་བཞུར་འོངས་པ་ཡིན། མ་གཞི་ཨར་ནོན་ཆུ་བོ་ནི་མོ་ཨབ་ཀྱི་མཐའ་མཚམས་ཡིན་ལ། མོ་ཨེབ་དང་ཨེ་མོར་པའི་བར་མཚམས་སུ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","དེར་བརྟེན་དཀོན་མཆོག་ཡ་ཝཱེའི་དམག་འཁྲུག་གི་ལོ་རྒྱུས་དཔེ་ཆ་རུ། སུབ་ཕཱའི་ཝཱ་ཧེབ་ཨར་ནོན་གྲོག་ཤུར་རྣམས། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","གྲོག་མོའི་ཐུར་གསེག་ཨར་ལ་ཐུག་པ་དང་། ། མོ་ཨབ་ས་མཚམས་དང་ནི་ཉེ་བ་འོ། །ཞེས་བཀོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ཡང་དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་པེར་ཞེས་པའི་ཁྲོན་པ་རུ་སླེབས་ཤིང་། སྔར་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་མི་ཚོགས་གནས་དེར་སྡུས་ཤིག་དང་། བདག་གིས་དེ་དག་ལ་ཆུ་སྦྱིན་པར་བྱ་ཞེས་གསུངས་པ་ནི་ཁྲོན་པ་དེའི་སྐོར་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","དེའི་དུས་སུ་ཡེས་ར་ཨེལ་པས་མགུར་འདི་བླངས་པ་སྟེ། ཀྱེ་ཀྱེ་ཁྲོན་པ་ཆུ་འཕྱུར་ཤོག ། ཁྱོད་ཅག་དེ་ལ་གླུ་ལོངས་ཤིག ། ");
INSERT INTO bodn_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ཁྲོན་པ་འདི་ནི་འགོ་དཔོན་རྣམས་ཀྱིས་བརྐོས། ། དེ་ནི་དམངས་ཁྲོད་སྐུ་དྲག་རྣམས་ཀྱིས་ནི། ། ཕྱག་འཁར་དང་ནི་འཁར་བས་བསྔོགས་པ་ཡིན། ། ཞེས་པའོ། ། དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་དབེན་སྟོང་ནས་མད་ཐ་ནཱ་རུ་སླེབས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","མད་ཐ་ནཱ་ནས་ནཱ་ཧ་ལི་ཨེལ་དང་། ནཱ་ཧ་ལི་ཨེལ་ནས་པཱ་མོད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","པཱ་མོད་ནས་མོ་ཨབ་ཡུལ་གྱི་ལུང་པ་དང་། ཡང་དབེན་སྟོང་ལ་ཁ་ཐུར་ལྟའི་རི་བོ་ཕིས་གའི་རྩེ་མོར་སླེབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ཡེས་ར་ཨེལ་པས་ཨེ་མོར་པའི་རྒྱལ་པོ་སི་ཧོན་ལ་བང་ཆེན་བཏང་སྟེ་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","ཁྱེད་ཀྱིས་ངེད་རྣམས་ཁྱེད་ཀྱི་ཡུལ་བརྒྱུད་དེ་འགྲོ་རུ་འཇུག་པར་མཛོད། ངེད་ཅག་ཞིང་ཁ་དང་རྒུན་འབྲུམ་ར་བར་མི་འགྲོ་ལ། ཁྲོན་པ་དག་གི་ཆུ་ཡང་མི་འཐུང་། ཁྱེད་ཀྱི་ས་མཚམས་ནས་བརྒལ་བའི་བར་དུ་ངེད་རྣམས་རྒྱལ་པོའི་ལམ་ཆེན་ནས་འགྲོ་བར་བྱའོ་ཞེས་སྨྲས་ནའང་། ");
INSERT INTO bodn_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","སི་ཧོན་གྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་རང་གི་ས་མཚམས་བརྒལ་ནས་འགྲོ་རུ་འཇུག་པ་ཕར་ཞོག ཁོས་རང་གི་མི་ཐམས་ཅད་བསྡུས་ཏེ་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འཐབ་ཕྱིར་དབེན་སྟོང་དུ་ཕྱིན་པ་དང་། ཡ་ཧ་ཙཱ་བྱ་བར་སླེབས་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་དམག་བརྒྱབ་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","དེ་ནས་ཡེས་ར་ཨེལ་པས་ཁོ་རལ་གྲིས་བསད་ཅིང་། ཨར་ནོན་ནས་ཡཱབ་པོག་དང་། དེ་ནས་ཨམ་མོན་པ་རྣམས་ཀྱི་བར་དུ་ཁོའི་ས་ཆ་རྣམས་བདག་ཏུ་བཟུང་། ཨམ་མོན་པའི་ས་མཚམས་ནི་བརྟན་འཇགས་ཡིན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ཡེས་ར་ཨེལ་པས་གྲོང་ཁྱེར་དེ་ཐམས་ཅད་ཕྲོགས་ཤིང་། ཨེ་མོར་པའི་གྲོང་ཁྱེར་སོ་སོ་སྟེ་ཧེ་སི་པོན་བྱ་བ་དང་དེར་གཏོགས་པའི་གྲོང་སྡེ་ཐམས་ཅད་ནས་གཞིས་ཕབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ཧེ་སི་པོན་ནི་ཨེ་མོར་པ་རྣམས་ཀྱི་རྒྱལ་པོ་སི་ཧོན་གྱི་རྒྱལ་ས་ཡིན་པ་དང་། ཁོས་སྔར་མོ་ཨབ་ཀྱི་རྒྱལ་པོ་སྔོན་མར་དམག་བརྒྱབ་ཅིང་དེའི་ལག་ནས་ཨར་ནོན་ཆུ་བོའི་བར་དུ་ས་ཆ་ཐམས་ཅད་ཕྲོགས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","དེའི་ཕྱིར་གཏམ་དཔེ་འཆད་མཁན་རྣམས་ཀྱིས་འདི་ལྟར། ཁྱོད་རྣམས་ཧེ་སི་པོན་ལ་ཕེབས། ། སི་ཧོན་རྒྱལ་པོའི་མཁར་སྐྲུན་ཅིག ། མཁར་དེ་བརྟན་པོར་བཟོ་བར་གྱིས། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","དེ་ནི་གང་གི་རྐྱེན་གྱིས་ཡིན་ཞེ་ན། ། ཧེ་སི་པོན་ནས་མེ་ཞིག་བྱུང་བ་དང་། ། སི་ཧོན་རྒྱལ་པོའི་མཁར་ནས་མེ་ལྕེ་འཕྱུར། ། མོ་ཨབ་ཡུལ་གྱི་ཨཱར་དང་ཨར་ནོན་གྱི། ། རི་རྒྱུད་གཙོ་བོ་རྣམས་ཀྱང་རྩ་མེད་བཏང་། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ཀྱེ་ཀྱེ་མོ་ཨབ་ཁྱོད་ལ་ཆག་སྒོ་བྱུང་། ། ཀེ་མོ་སི་ཡི་མི་རྣམས་མེད་པར་གྱུར། ། ལྷ་དེས་རང་གི་བུ་རྣམས་འབྲོ་རུ་བཅུག ། རང་གི་བུ་མོ་རྣམས་ནི་བཙོན་པར་བཏང་། ། ཨེ་མོར་རྒྱལ་པོ་སི་ཧོན་ལག་ཏུ་བརྫངས། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ང་ཚོས་མདའ་ཡིས་དེ་རྣམས་བརྒྱབས་པ་དང་། ། དི་བོན་བར་དུ་ཧེ་སི་པོན་ཚར་བཅད། ། ནོ་ཕཱའི་བར་དུ་ང་ཚོས་སྟོངས་སུ་བཅུག ། དེ་ནི་མེ་དེ་བཱ་ཡི་བར་དུ་བསྲིངས། །ཞེས་སྨྲ་བའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","དེ་ལྟར་ཡེས་ར་ཨེལ་པ་རྣམས་ཨེ་མོར་པ་རྣམས་ཀྱི་ཡུལ་དུ་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","དེ་ཡང་མོ་ཤེ་ཡིས་ཡཱ་ཟེར་བྱ་བའི་ཡུལ་ལ་མྱུལ་མ་བཏང་བ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་དེའི་གྲོང་སྡེ་རྣམས་བདག་ཏུ་བཟུང་ཞིང་། དེར་གནས་པའི་ཨེ་མོར་པ་རྣམས་གཞན་དུ་བསྐྲད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཁ་ཕྱིར་འཁོར་ནས་པཱ་ཤན་དུ་འགྲོ་བའི་ལམ་དུ་ཞུགས་པ་ན། པཱ་ཤན་གྱི་རྒྱལ་པོ་ཨོག་ཅེས་བྱ་བ་དང་དེའི་མི་ཐམས་ཅད་འོངས་ནས་ཨེ་དྲེ་ཨི་ཡུལ་དུ་ཁོ་རྣམས་ལ་དམག་བརྒྱབ་བོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། བདག་གིས་ཁོ་དང་ཁོའི་མི་ཐམས་ཅད་དང་། ཁོའི་ས་ཆ་བཅས་ཁྱོད་ཀྱི་ལག་ཏུ་གཏད་ཡོད་པས། ཁོ་ལ་མ་འཇིགས་ཤིག ཁྱོད་ཀྱིས་སྔར་ཧེ་སི་པོན་དུ་གནས་པའི་ཨེ་མོར་པའི་རྒྱལ་པོ་སི་ཧོན་ལ་ཅི་ལྟར་བྱས་པ་ཡིན་ན། འདི་ལ་ཡང་དེ་ལྟར་གྱིས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","དེ་ནས་ཁོ་ཚོས་ཨོག་དང་དེའི་བུ་རྣམས་དང་། དེའི་མི་ཐམས་ཅད་བསད་དེ་གཅིག་ཀྱང་མི་ལུས་པར་བྱས་ནས་དེའི་ས་ཆ་བདག་གིར་བཟུང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","དེ་ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་ལམ་དུ་ཆས་ནས་མོ་ཨབ་སྤང་ལྗོངས་ཏེ། ཡོར་དན་གཙང་པོའི་ཤར་ཕྱོགས་དང་། ཡེ་རུ་ཀོ་ཡི་ཁ་གཏད་དུ་སྒར་བཏབ། ");
INSERT INTO bodn_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཨེ་མོར་པ་རྣམས་ལ་ཅི་བྱས་པ་ཐམས་ཅད་ཚིབ་ཕོར་གྱི་བུ་པཱ་ལག་གིས་མཐོང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ཁོ་ཚོར་མི་ཚོགས་མང་པོ་ཡོད་པས་མོ་ཨབ་པ་རྣམས་ཤིན་ཏུ་འཇིགས་པ་དང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་རྐྱེན་གྱིས་མོ་ཨབ་པ་རྣམས་དངངས་སྐྲག་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bodn_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","མོ་ཨབ་པ་རྣམས་ཀྱིས་མིད་ཡཱན་པའི་རྒན་པོ་རྣམས་ལ། བ་གླང་གིས་ཞིང་ཁའི་རྩྭ་བཟའ་བ་བཞིན་དུ། ད་ལྟ་མི་ཚོགས་འདིས་རང་ཅག་གི་ཉེ་འཁོར་ཐམས་ཅད་བལྡག་པར་འགྱུར་ཞེས་སྨྲས། དེའི་དུས་སུ་ཚིབ་ཕོར་གྱི་བུ་པཱ་ལག་ནི་མོ་ཨབ་ཀྱི་རྒྱལ་པོ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ཁོས་པེ་ཨོར་གྱི་བུ་པེལ་ཨམ་གྱི་རྩར་བང་ཆེན་བཏང་བ་སྟེ། ཆུ་བོ་ཉེ་འགྲམ་གྱི་ཕེ་ཐོར་ཏེ་ཁོའི་ཡུལ་མི་རྣམས་ཀྱི་ས་ཆར་པེལ་ཨམ་གདན་འདྲེན་བྱེད་དུ་མངགས་ཤིང་ན་རེ། གཟིགས་དང་། མི་རིགས་ཤིག་ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་བྱུང་། ཀྱེ་ཧོ། དེ་དག་ས་གཞི་ཡོངས་སུ་ཁེབས་ཤིང་ད་ལྟ་ངའི་ཁ་གཏད་དུ་བསྡད་ཡོད། ");
INSERT INTO bodn_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","མི་རིགས་འདི་ནི་བདག་ལས་སྟོབས་ཆེ་བས། ད་ལྟ་ཁྱེད་རང་ཕེབས་ནས་ངའི་ཆེད་དུ་ཁོ་རྣམས་ལ་དམོད་མོ་འདེབས་རོགས། དེ་ནས་ངས་ཁོ་རྣམས་ཕམ་པར་བརྒྱབ་སྟེ་ཡུལ་འདི་ནས་སྐྲོད་ནུས་ཀྱང་སྲིད། གང་ལ་ཞེ་ན། ཁྱེད་ཀྱིས་སུ་ལ་བྱིན་གྱིས་བརླབས་ན་དེར་བྱིན་རླབས་འཐོབ་ཅིང་། ཁྱེད་ཀྱིས་སུ་ལ་དམོད་མོ་བཏབ་ན་དེར་དམོད་མོ་ཐེབས་པ་ངས་ཤེས་པ་ཡིན་ཞེས་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","མོ་ཨབ་དང་མིད༌ཡཱན་གྱི་རྒན་པོ་རྣམས་ཀྱིས་མོ་འདེབས་པའི་རྔན་པ་ལག་ལ་ཁྱེར་ནས་ཆས་པ་དང་། པེལ་ཨམ་གྱི་རྩར་སླེབས་ནས་པཱ་ལག་གི་གཏམ་ཁོ་ལ་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","དེ་ནས་པེལ་ཨམ་གྱིས་ཁོ་ཚོར་འདི་ལྟར། དོ་ནུབ་འདི་རུ་ཞག་སྡོད་བྱོས་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་ང་ལ་བཀའ་ཅི་ལྟར་གསུངས་ན་ངས་དེ་བཞིན་དུ་ཁྱོད་ལ་ལན་སྦྱིན་འོང་ཞེས་སྨྲས་པས། མོ་ཨབ་ཀྱི་འགོ་དཔོན་རྣམས་པེལ་ཨམ་དང་མཉམ་དུ་བསྡད། ");
INSERT INTO bodn_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","དཀོན་མཆོག་པེལ་ཨམ་གྱི་རྩར་ཕེབས་ཏེ་འདི་སྐད་དུ། ཁྱོད་དང་མཉམ་དུ་ཡོད་པ་འདི་རྣམས་སུ་ཡིན་ནམ་ཞེས་གསུངས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","པེལ་ཨམ་གྱིས་དཀོན་མཆོག་ལ། མོ་ཨབ་ཀྱི་རྒྱལ་པོ་སྟེ་ཚིབ་ཕོར་གྱི་བུ་པཱ་ལག་གིས་ངའི་རྩར་བཏང་བའི་མི་རྣམས་ཡིན་ཏེ། ཁོ་རྣམས་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ལྟོས་དང་། ཨེ་ཅིབ་ཡུལ་ནས་ཐོན་པའི་མི་རིགས་ཤིག་གིས་ས་གཞི་ཡོངས་སུ་ཁེབས་འདུག ད་ལྟ་ཁྱོད་རང་ཡོང་ནས་ངའི་ཆེད་དུ་ཁོ་རྣམས་ལ་དམོད་མོ་འདེབས་རོགས། དེ་ནས་ངས་ཁོ་རྣམས་ལས་རྒྱལ་ཁ་བླངས་ཏེ་སྐྲོད་ནུས་ཀྱང་སྲིད་ཅེས་སྨྲས་བྱུང་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","དཀོན་མཆོག་གིས་པེལ་ཨམ་ལ་འདི་སྐད་དུ། ཁྱོད་དེ་དག་དང་མཉམ་དུ་འགྲོ་མི་རུང་ལ། ཡང་མི་རིགས་དེ་ནི་བྱིན་རླབས་ཐོབ་པ་ཡིན་པས་དེ་ལ་དམོད་མོ་འདེབས་མི་རུང་ཞེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","དེ་ནས་པེལ་ཨམ་ནངས་སྔ་མོ་ལངས་ནས་པཱ་ལག་གི་འགོ་དཔོན་རྣམས་ལ་ན་རེ། དཀོན་མཆོག་ཡ་ཝཱེས་ང་རང་ཁྱོད་ཅག་དང་མཉམ་དུ་འགྲོ་བར་མི་གནང་བས་ཁྱོད་རྣམས་ཕྱིར་རང་ཡུལ་དུ་སོང་ཞིག་ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","མོ་ཨབ་ཀྱི་འགོ་དཔོན་རྣམས་ཡར་ལངས་ཏེ་ཕྱིར་པཱ་ལག་གི་རྩར་ཕྱིན་ནས་ཁོ་ལ། པེལ་ཨམ་ངེད་ཅག་དང་མཉམ་དུ་མི་ཡོང་ངོ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","དེ་ནས་པཱ་ལག་གིས་ཡང་བསྐྱར་འགོ་དཔོན་སྔར་ལས་མང་པོ་དང་། དེ་ལས་སྙན་གྲགས་ཆེ་བ་རྣམས་བཏང་བ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","དེ་དག་པེལ་ཨམ་གྱི་དྲུང་དུ་ཕྱིན་ནས་ཁོ་ལ་འདི་ལྟར། ཚིབ་ཕོར་གྱི་བུ་པཱ་ལག་གིས་འདི་ལྟར་སྨྲས་ཏེ། ཁྱེད་རང་ངའི་རྩར་ཕེབས་པར་མི་གཡོལ་རོགས། ");
INSERT INTO bodn_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","གང་ལ་ཞེ་ན། ངས་ཁྱེད་ལ་གུས་པ་ཆེན་པོ་འཐོབ་པར་བྱ་ཞིང་། ཁྱེད་ཀྱིས་ཅི་གསུངས་བཞིན་དུ་བསྒྲུབ་པར་བྱ། ཁྱེད་ཀྱིས་ངའི་ཆེད་དུ་མི་རིགས་འདི་ལ་དམོད་མོ་འདེབས་རོགས་ཞེས་ཞུ་བ་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","དེ་ནས་པེལ་ཨམ་གྱིས་པཱ་ལག་གི་འཁོར་གཡོག་རྣམས་ལ་ལན་དུ། པཱ་ལག་གིས་རང་གི་གསེར་དངུལ་ཁང་པ་གང་པོ་དེ་ང་ལ་གནང་ན་ཡང་། ངས་དོན་ཆེ་ཆུང་གང་ཡིན་ཡང་རང་གི་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བརྒལ་ནས་བསྒྲུབ་མི་ནུས། ");
INSERT INTO bodn_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་ང་ལ་ད་དུང་ཅི་ཞིག་གསུང་བ་ཤེས་པའི་ཆེད་དུ། ཁྱོད་ཅག་དོ་ནུབ་ཀྱང་འདི་རུ་སྡོད་ཅིག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","མཚན་མོ་དེར་དཀོན་མཆོག་པེལ་ཨམ་གྱི་རྩར་ཕེབས་ནས་འདི་སྐད་དུ། མི་འདི་རྣམས་ཁྱོད་འབོད་དུ་འོངས་པ་ཡིན་པས་ན། ཁྱོད་རང་ལམ་ལ་ཆས་ནས་དེ་དག་དང་མཉམ་དུ་སོང་ཞིག འོན་ཀྱང་ངས་ཁྱོད་ལ་ཅི་སྨྲས་པ་དེ་ཁོ་ན་སྒྲུབས་ཤིག་ཅེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","པེལ་ཨམ་ནངས་སྔ་མོར་ལངས་ནས་རང་གི་བོང་བུ་ལ་སྒ་བསྟད་དེ། མོ་ཨབ་ཀྱི་འགོ་དཔོན་རྣམས་དང་མཉམ་དུ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ཁོ་རང་སོང་བའི་རྐྱེན་གྱིས་དཀོན་མཆོག་ཐུགས་ཁྲོས་ཤིང་། དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ལམ་ནང་དུ་འགྲེང་ནས་ཁོ་རང་བཀག་པ་དང་། དེའི་དུས་སུ་ཁོ་བོང་བུར་ཞོན་ཏེ་ཞབས་ཕྱི་གཉིས་ཀྱང་ཁོ་དང་མཉམ་དུ་བསྐྱོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","དེ་ནས་བོང་བུས་ཕྱག་ཏུ་རལ་གྲི་ཐོགས་པའི་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ལམ་ནང་དུ་འགྲེང་འདུག་པ་མཐོང་བས། ལམ་ལ་བཟུར་ནས་ཞིང་ནང་དུ་སོང་། པེལ་ཨམ་གྱིས་བོང་བུ་ལམ་ལ་བསྒྱུར་ཕྱིར་བརྡེགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་རྒུན་འབྲུམ་ར་བ་རྣམས་ཀྱི་བར་དུ་ཡོད་པའི་ལམ་དོག་མོའི་ནང་དུ་འགྲེང་པ་དང་། ལམ་གྱི་འགྲམ་གཉིས་ཀ་གྱང་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","བོང་བུས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་མཐོང་བ་དང་གྱང་ལ་གཙུབས་ནས་པེལ་ཨམ་གྱི་རྐང་པ་བཙིར་བས་པེལ་ཨམ་གྱིས་ཡང་བོང་བུ་ལ་བརྡེགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ཡང་སྔོན་ལ་ཅུང་ཙམ་ཕེབས་ནས། འགག་དོག་མོ་གཡས་གཡོན་ལ་འཁོར་ས་མེད་པ་ཞིག་ཏུ་འགྲེང་བསྡད་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","བོང་བུས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་མཐོང་སྟེ་པེལ་ཨམ་གྱི་འོག་ཏུ་ཉལ་བ་དང་། པེལ་ཨམ་རབ་ཏུ་ཁྲོས་ནས་དབྱུག་པས་བོང་བུ་ལ་བརྡེགས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","དཀོན་མཆོག་ཡ་ཝཱེས་བོང་བུ་ལ་ཁ་གྲགས་པར་མཛད་ཅིང་དེས་པེལ་ཨམ་ལ། ངས་ཁྱོད་ལ་ཅི་བྱས་པ་ཡིན་ནམ། ཁྱོད་ཀྱིས་ང་ལ་ལན་གསུམ་བརྡེགས་སོང་ཞེས་སྨྲས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","པེལ་ཨམ་གྱིས་བོང་བུ་ལ་ན་རེ། ཁྱོད་ཀྱིས་ང་རང་རྩེད་སྤྱད་བྱས་པས་ཡིན། ངའི་ལག་ཏུ་རལ་གྲི་ཞིག་ཡོད་པ་ཡིན་ན། ད་ལྟ་ཉིད་ལ་ཁྱོད་གསོད་དོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","དེ་ནས་བོང་བུས་པེལ་ཨམ་ལ། ང་ནི་ཁྱོད་ཆུང་དུས་ནས་དེ་རིང་བར་དུ་ཞོན་པའི་བོང་བུ་དེ་མ་ཡིན་ནམ། ངས་དུས་ནམ་ཞིག་ཁྱོད་ལ་འདི་ལྟར་བྱས་མྱོང་ངམ་ཞེས་སྨྲས་པ་ན། པེལ་ཨམ་གྱིས་བྱས་མ་མྱོང་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","དེ་ནས་དཀོན་མཆོག་ཡ་ཝཱེས་པེལ་ཨམ་གྱི་མིག་ཕྱེས་པ་ན། ཁོས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ལམ་ནང་དུ་འགྲེང་འདུག་པ་དང་། ཕྱག་ཏུ་རལ་གྲི་ཤུབས་ནས་ཐོན་པ་ཞིག་ཡོད་པ་མཐོང་ནས། མགོ་བོ་སྨད་དུ་བསྒུར་ནས་ཕྱག་བཙལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉས་ཁོ་ལ། ཁྱོད་ཀྱིས་ཅིའི་ཕྱིར་རང་གི་བོང་བུ་ལ་ཐེངས་གསུམ་བརྡེགས་པ་ཡིན་ནམ། ལྟོས་དང་། ཁྱོད་ཀྱི་ལམ་ནི་ངའི་མདུན་དུ་ཕྱིན་ཅི་ལོག་པའི་ལམ་ཡིན་པས་ང་རང་ཁྱོད་འགོག་ཏུ་འོངས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","བོང་བུས་ང་མཐོང་ནས་ཐེངས་གསུམ་ལ་བཟུར་བ་དང་། གལ་སྲིད་བོང་བུ་ངའི་མདུན་ནས་ཏན་ཏན་མ་བཟུར་པ་ཡིན་ན། ངས་སྔ་མོ་ནས་ཁྱོད་བསད་ཅིང་། བོང་བུ་སྲོག་ཐར་དུ་བཏང་བ་ཡིན་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","དེ་ནས་པེལ་ཨམ་གྱིས་དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉ་ལ་འདི་ལྟར། ངས་སྡིག་པ་བྱས་ཟིན། ངས་ཁྱེད་རང་ལམ་ནང་དུ་འགྲེང་ནས་ང་འགོག་པ་མ་ཤེས། ད་ལྟ་ང་རང་འགྲོ་བར་ཁྱེད་མི་མཉེས་ན་ང་ཕྱིར་ལོག་འགྲོ་ཞེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","དཀོན་མཆོག་ཡ་ཝཱེའི་ཕོ་ཉས་པེལ་ཨམ་ལ། ཁྱོད་མི་འདི་དག་དང་མཉམ་དུ་སོང་ཞིག འོན་ཀྱང་ངས་ཁྱོད་ལ་སྨྲས་པའི་གཏམ་འབའ་ཞིག་ལས་གཞན་ཅི་ཡང་སྨྲ་བར་མི་བྱའོ་ཞེས་གསུངས་པས། པེལ་ཨམ་ནི་པཱ་ལག་གི་འགོ་དཔོན་རྣམས་དང་མཉམ་དུ་སོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","པཱ་ལག་གིས་པེལ་ཨམ་ཡོང་བཞིན་པ་ཐོས་ནས་མོ་ཨབ་ཀྱི་གྲོང་ཁྱེར་དུ་བསུ་བར་སོང་སྟེ། གྲོང་ཁྱེར་དེ་ནི་ཨར་ནོན་ཆུ་བོའི་འགྲམ་དུ་ས་མཚམས་ཀྱི་མཐའ་རུ་ཡོད་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","པཱ་ལག་གིས་པེལ་ཨམ་ལ། ངས་བྲེལ་མྱུར་ངང་ཁྱེད་ཀྱི་རྩར་མི་བཏང་ནས་ཁྱེད་རང་གདན་དྲངས་པ་མ་ཡིན་ནམ། ཁྱེད་རང་ངའི་རྩར་མ་ཡོང་བ་ཅི་ཡིན་ནམ། ངས་ཁྱེད་ལ་གུས་བརྩི་ཆེན་པོ་འཐོབ་པར་བྱེད་མི་ནུས་སམ་ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ལྟོས་དང་། ང་ཁྱོད་ཀྱི་རྩར་སླེབས་ཡོད་པས་ད་ལྟ་ང་ལ་ཅི་ཞིག་སྨྲ་བའི་དབང་ཡོད་དམ། དཀོན་མཆོག་གིས་ངའི་ཁ་ལ་བཀའ་ཅི་ཞིག་གནང་ན་ངས་བཀའ་དེ་སྨྲ་བར་བྱའོ་ཞེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","དེ་ནས་པེལ་ཨམ་ནི་པཱ་ལག་དང་མཉམ་དུ་སོང་བ་དང་། ཁོ་གཉིས་ཀིར་ཡཱད་ཧུ་ཚོད་བྱ་བར་སླེབས། ");
INSERT INTO bodn_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","པཱ་ལག་གིས་བ་གླང་དང་ལུག་རྣམས་མཆོད་པར་ཕུལ་བ་དང་། པེལ་ཨམ་དང་ཁོ་དང་མཉམ་དུ་ཡོད་པའི་འགོ་དཔོན་རྣམས་ལ་དེའི་ཤ་ཡང་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ཕྱི་ཉིན་ཞོགས་པར་པཱ་ལག་གིས་པེལ་ཨམ་ཁྲིད་ནས་ཡར་པཱ་ཨལ་གྱི་མཐོ་གླིང་དུ་ཕྱིན་ཅིང་། པེལ་ཨམ་གྱིས་དེ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཀྱི་ཟུར་ཞིག་མཐོང་ངོ་། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","དེ་ཡང་པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ཁྱོད་ཀྱིས་འདི་རུ་ང་ལ་མཆོད་ཁྲི་བདུན་བཟོས་ཤིག བ་གླང་བདུན་དང་ལུག་ཐུག་བདུན་ཡང་ང་ལ་གྲ་སྒྲིག་བྱོས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bodn_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","པཱ་ལག་གིས་པེལ་ཨམ་གྱིས་བསྒོས་པ་བཞིན་དུ་བྱས་ཤིང་། པཱ་ལག་དང་པེལ་ཨམ་གཉིས་ཀྱིས་མཆོད་ཁྲི་རེ་རེའི་སྟེང་དུ་བ་གླང་རེ་དང་ལུག་ཐུག་རེ་མཆོད་པར་ཕུལ། ");
INSERT INTO bodn_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ཁྱོད་ནི་རང་གི་སྦྱིན་སྲེག་གི་འགྲམ་དུ་སྡོད་ཅིག ང་མདུན་ལ་འགྲོའོ། །དཀོན་མཆོག་ཡ་ཝཱེ་ང་དང་འཕྲད་དུ་ཕེབས་ཡོང་ཡང་སྲིད། ཁོང་གིས་ང་ལ་གང་ཞིག་སྟོན་པར་མཛད་ན་ངས་དེ་ཁྱོད་ལ་སྨྲ་ངེས་ཡིན་ཞེས་སྨྲས་པ་དང་། ཁོ་མཐོ་སྒང་ཞིག་ལ་ཆས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","དཀོན་མཆོག་པེལ་ཨམ་ལ་ཕྲད་པ་དང་། ཁོས་དཀོན་མཆོག་ལ་འདི་ལྟར། ངས་མཆོད་ཁྲི་བདུན་གྲ་སྒྲིག་བྱས་ཤིང་མཆོད་ཁྲི་རེའི་སྟེང་དུ་བ་གླང་གཅིག་དང་ལུག་ཐུག་གཅིག་རེ་མཆོད་པར་ཕུལ་ཡོད་ཅེས་ཞུས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","དཀོན་མཆོག་ཡ་ཝཱེས་པེལ་ཨམ་གྱི་ཁ་ལ་བཀའ་གནང་ཞིང་ཡང་འདི་སྐད་དུ། ཁྱོད་པཱ་ལག་གི་རྩར་ཕྱིར་ལོག་ལ་འདི་ལྟར་སྨྲོས་ཤིག་ཅེས་གསུངས་པས། ");
INSERT INTO bodn_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ཁོ་པཱ་ལག་གི་རྩར་ལོག་པ་ན། ལྟོས་དང་། པཱ་ལག་དང་མོ་ཨབ་ཀྱི་འགོ་དཔོན་ཐམས་ཅད་སྦྱིན་སྲེག་གི་རྩར་འགྲེང་ནས་བསྡད་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","དེ་ནས་པེལ་ཨམ་གྱིས་ཁོ་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ཏེ་འདི་ལྟར། པཱ་ལག་གིས་ནི་ང་རང་ཨ་རམ་ཡུལ་ནས་ཁྲིད། ། མོ་ཨབ་རྒྱལ་པོས་ང་རང་ཤར་ཕྱོགས་རི་ནས་ཁྲིད། ཤོག་དང་ང་ཡི་ཆེད་དུ་ཡ་ཀོབ་ལ་དམོད་ཅིག ། ཤོག་དང་ཡེས་ར་ཨེལ་ལ་སྐྱོན་རྗོད་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","དཀོན་མཆོག་ཉིད་ཀྱིས་མ་དམད་པ་དེ་ལ། ། ང་ཡིས་དམོད་པ་ཅི་ལྟར་གཏོང་ནུས་སམ། ། ཡ་ཝཱེས་དགག་པ་མ་བརྒྱབ་པ་དེ་ལ། ། ང་ཡིས་དགག་པ་ཅི་ལྟར་རྒྱག་ནུས་སམ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","བདག་གིས་བྲག་གི་རྩེ་མོ་དག་ནས་ཁོ་རྣམས་མཐོང་། ། རི་བོའི་རྩེ་མོ་དག་ནས་ང་ཡིས་ཁོ་ཚོར་བལྟས། ། ཀྱེ་ཧོ་དེ་ནི་མི་རིགས་ཁེར་འདུག་ཅིག་ཡིན་ཞིང་། ། མི་རིགས་གཞན་པའི་ནང་དུ་རང་ཉིད་བགྲང་མི་འདུག ། ");
INSERT INTO bodn_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ཡ་ཀོབ་ཁོང་གི་རྡུལ་ཕྲན་སུ་ཡིས་རྩི་ནུས་སམ། ཡེས་ར་ཨེལ་པའི་བཞི་ཆའི་གཅིག་ཀྱང་སུས་བགྲང་ནུས། ། ང་རང་དྲང་པོའི་འཆི་ལུགས་བཞིན་དུ་འཆི་བ་དང་། ། ང་ཡི་ཚེ་མཇུག་དེ་རྣམས་བཞིན་དུ་འགྱུར་བར་ཤོག །ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","པཱ་ལག་གིས་པེལ་ཨམ་ལ་འདི་ལྟར། ཁྱེད་ཀྱིས་ང་ལ་ཅི་བྱས་སམ། ངའི་དགྲ་བོ་རྣམས་ལ་དམོད་མོ་འདེབས་པའི་ཆེད་དུ་ཁྱེད་ཁྲིད་འོངས་པ་ཡིན། ལྟོས་དང་། ཁྱེད་ཀྱིས་ཁོ་རྣམས་ལ་བྱིན་གྱིས་བརླབས་སོ་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","པེལ་ཨམ་གྱིས་དེའི་ལན་དུ། དཀོན་མཆོག་ཡ་ཝཱེས་ངའི་ཁ་རུ་གནང་བ་དེ་ངས་གཟབ་གཟབ་བྱས་ནས་སྨྲ་མི་དགོས་སམ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","པཱ་ལག་གིས་པེལ་ཨམ་ལ་ན་རེ། ཁྱེད་རང་ང་དང་མཉམ་དུ་གནས་གཞན་ཞིག་ཏུ་ཕེབས་རོགས། དེ་རུ་ཁྱེད་ཀྱིས་ཁོ་རྣམས་མཐོང་བར་འགྱུར། དེ་དག་ཐམས་ཅད་མཐོང་མི་ནུས་ལ། དེ་དག་གི་མཐའ་མཚམས་ཀྱི་ཁག་ཅིག་མཐོང་བར་འགྱུར། དེ་ནས་ངའི་ཆེད་དུ་ཁྱེད་ཀྱིས་ཁོ་རྣམས་ལ་དམོད་མོ་ཐོངས་ཤིག་ཅེས་ཞུས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","པཱ་ལག་གིས་པེལ་ཨམ་ཁྲིད་ནས་ཚི་པེམ་བྱ་བའི་ཞིང་ལ་སླེབས་ཤིང་། ཡར་ཕིས་གའི་རི་རྩེར་ཁྲིད་པ་དང་དེར་མཆོད་ཁྲི་བདུན་བརྩིགས། མཆོད་ཁྲི་རེའི་སྟེང་དུ་བ་གླང་གཅིག་དང་ལུག་ཐུག་གཅིག་རེ་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ང་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་མཇལ་དུ་འགྲོ་སྟེ། ཁྱོད་ནི་འདིར་རང་གི་སྦྱིན་སྲེག་གི་རྩར་འགྲེང་ནས་སྡོད་ཅིག་ཅེས་སྨྲས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","དཀོན་མཆོག་ཡ་ཝཱེ་ཁོང་ཉིད་པེལ་ཨམ་དང་ཕྲད་དེ། ཁོང་གིས་དེའི་ཁ་ལ་བཀའ་གནང་ཞིང་འདི་སྐད་དུ། ཁྱོད་པཱ་ལག་གི་རྩར་ཕྱིར་ལོག་ལ་འདི་ལྟར་སྨྲོས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","དེ་ནས་པེལ་ཨམ་ནི་པཱ་ལག་གི་རྩར་ཕྱིར་ལོག་པ་ན། ལྟོས་དང་། པཱ་ལག་ནི་རང་གི་སྦྱིན་སྲེག་གི་རྩར་འགྲེང་ནས་བསྡད་ཡོད་པ་དང་། མོ་ཨབ་ཀྱི་འགོ་དཔོན་རྣམས་ཀྱང་ཁོ་དང་མཉམ་དུ་ཡོད་པའོ། །པཱ་ལག་གིས་པེལ་ཨམ་ལ་དཀོན་མཆོག་ཡ་ཝཱེས་ཅི་གསུངས་བྱུང་ཞེས་དྲིས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","པེལ་ཨམ་གྱིས་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ཏེ་འདི་ལྟར། ཀྱེ་ཀྱེ་པཱ་ལག་ལོངས་ལ་མཉན་པར་གྱིས། ། ཚིབ་ཕོར་བུ་ཡིས་རྣ་བ་བདག་ལ་གཏོད། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","དཀོན་མཆོག་རྫུན་གཏམ་སྨྲ་བའི་མི་མ་ཡིན། ། མིའི་བུ་ནང་བཞིན་ཁོང་ནི་ཐུགས་མི་འགྱོད། ། ཁོང་གིས་བཀའ་གསུང་གནང་སྟེ་མི་མཛད་དམ། ། ཁོང་གིས་ཞལ་བཞེས་གནང་བ་མི་འགྲུབ་བམ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ལྟོས་དང་བྱིན་རླབས་གནང་བའི་བཀའ་ནི་བདག་ལ་གསུངས། ། ཁོང་གིས་བྱིན་གྱིས་བརླབས་པ་བདག་གིས་བསྒྱུར་མི་ནུས། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ཡ་ཀོབ་ལས་ནི་སྡིག་ཉེས་མཐོང་བ་མེད། ། ཡེས་ར་ཨེལ་ནང་སྤྱོད་ངན་མཐོང་བ་མེད། ། ཡེས་ར་ཨེལ་གྱི་དཀོན་མཆོག་ཡ་ཝཱེ་མཆོག ། ཁོ་རྣམས་མཉམ་དུ་བཞུགས་ཤིང་དེ་དག་ཁྲོད། ། རྒྱལ་པོའི་དགའ་མགུ་རངས་པའི་སྐད་ཅོར་འདུག ། ");
INSERT INTO bodn_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ཨེ་ཅིབ་ཡུལ་ནས་ཁྲིད་མཁན་དཀོན་མཆོག་ནི། ། ཁོ་ཚོར་གླང་རྒོད་ཅིག་གི་རྭ་དང་མཚུངས། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ཡ་ཀོབ་ཕྱོགས་སུ་ངན་སྔགས་འདེབས་པ་མེད། ། ཡེས་ར་ཨེལ་གྱི་ཕྱོགས་སུ་མོ་པ་མེད། ། འོས་ཤིང་འཚམ་པའི་དུས་སུ་སླེབས་པའི་ཚེ། ། ཡ་ཀོབ་དང་ནི་ཡེས་ར་ཨེལ་ལ་ནི། ། དཀོན་མཆོག་ཁོང་གིས་དོན་ཆེན་མཛད་ཅེས་བརྗོད། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ཀྱེ་ཧོ་མི་རིགས་དེ་ནི་མོ་སེང་བཞིན། ། འགྱིང་ཞིང་སེང་གེ་ཇི་བཞིན་འགྲེང་ནས་ཡོང་། ། བརྔོན་བྱའི་རི་དྭགས་ཁྱུར་མིད་གཏོང་བ་དང་། ། བསད་པ་དེའི་ཁྲག་འཐུང་བའི་བར་དུ་ནི། ། མར་ལ་ཉལ་བ་གཏན་ནས་དཔེ་མི་སྲིད། །ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","དེ་ནས་པཱ་ལག་གིས་པེལ་ཨམ་ལ། ཁྱེད་ཀྱིས་ཁོ་རྣམས་ལ་དམོད་མོ་ཅི་ཡང་མ་འདེབས། བྱིན་རླབས་ཀྱང་ཅི་ཡང་མ་གནང་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","པེལ་ཨམ་གྱིས་དེའི་ལན་དུ་པཱ་ལག་ལ། དཀོན་མཆོག་ཡ་ཝཱེས་ང་ལ་ཅི་གསུངས་པ་ཐམས་ཅད་ངས་ངེས་པར་དེ་བཞིན་བསྒྲུབ་དགོས་ཞེས་ཁྱོད་ལ་སྨྲས་པ་མ་ཡིན་ནམ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","དེ་ནས་པཱ་ལག་གིས་པེལ་ཨམ་ལ། ཕེབས་དང་། ངས་ཁྱེད་རང་ས་ཆ་གཞན་ཞིག་ལ་འཁྲིད་པར་བྱ་སྟེ། དཀོན་མཆོག་ཁྱེད་ལ་ཐུགས་མཉེས་ཀྱང་སྲིད་ལ། ཁྱེད་ཀྱིས་ས་དེ་ནས་ངའི་ཆེད་དུ་ཁོ་རྣམས་ལ་དམོད་མོ་བཏབ་ཆོག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","དེ་ནས་པཱ་ལག་གིས་པེལ་ཨམ་དབེན་སྟོང་ལ་ཁ་ཐུར་ལྟའི་ཕེ་ཨོར་རི་རྩེར་ཁྲིད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ཁྱོད་ཀྱིས་འདི་ནས་ང་ལ་མཆོད་ཁྲི་བདུན་རྩིགས་ཤིག བ་གླང་བདུན་དང་ལུག་ཐུག་བདུན་ཡང་ང་ལ་གྲ་སྒྲིག་བྱོས་ཤིག་ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","པཱ་ལག་གིས་པེལ་ཨམ་གྱིས་སྨྲས་པ་བཞིན་དུ་བསྒྲུབས་པ་དང་། མཆོད་ཁྲི་རེའི་སྟེང་དུ་བ་གླང་གཅིག་དང་ལུག་ཐུག་གཅིག་རེ་མཆོད་པར་ཕུལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","དེ་ཡང་པེལ་ཨམ་གྱིས་ཡེས་ར་ཨེལ་ལ་བྱིན་རླབས་གནང་བར་དཀོན་མཆོག་ཡ་ཝཱེ་ཐུགས་དགྱེས་པ་མཐོང་བས། ཁོ་སྔར་བཞིན་སྔ་ལྟས་འཚོལ་དུ་མ་སོང་བར། དབེན་སྟོང་གི་ཕྱོགས་སུ་གདོང་གཏད་ནས་བསྡད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","དེ་ནས་པེལ་ཨམ་གྱིས་མིག་རྒྱང་རིང་མོས་བལྟས་པ་ན། ཡེས་ར་ཨེལ་ནི་ཚོ་པ་རེ་རེ་བཞིན་སྒར་བཏབ་ནས་བསྡད་ཡོད་པ་མཐོང་ཞིང་། དཀོན་མཆོག་གི་ཐུགས་ཉིད་ཁོའི་སྟེང་ལ་བབས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ཁོས་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ནས་འདི་ལྟར། པེ་ཨོར་བུ་སྟེ་པེལ་ཨམ་ཁོ་ན་རེ། ། མིག་རྒྱང་རིང་བའི་མི་ཡིས་འདི་སྐད་སྨྲ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","དཀོན་མཆོག་ཁོང་གི་བཀའ་ནི་ཐོས་པ་དང་། ། ཀུན་དབང་ཉིད་ཀྱི་ཞལ་གཟིགས་མཐོང་བ་འོ། ། ལུས་པོ་ས་རུ་འགྱེལ་ཞིང་མིག་ཟུང་ནི། ། ཕྱེས་པ་དེ་ཡིས་འདི་སྐད་སྨྲ་བར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ཀྱེ་ཀྱེ་ཡ་ཀོབ་ཁྱེད་ཀྱི་གུར་རྣམས་ཇི་འདྲའི་མཛེས་པ་ལ། ། ཀྱེ་ཀྱེ་ཡེས་ར་ཨེལ་གྱི་གུར་རྣམས་ཇི་འདྲའི་ཡིད་དུ་འོང་། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","དེ་ནི་ལུང་པ་རྒྱང་དུ་བསྲིངས་པ་དང་། ། གཙང་པོའི་འགྲམ་གྱི་སྐྱེད་མོས་ཚལ་དང་འདྲ། ། ཡ་ཝཱེས་བཙུགས་པའི་ཨ་ག་རུ་དེ་དང་། ། ཆུ་བོའི་འགྲམ་གྱི་ཐང་ཤིང་ལ་ནི་མཚུངས། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ཁོང་གི་ཟོ་ལས་ཆུ་ནི་འབབ་པ་དང་། ། ཁོང་གི་བུ་རྒྱུད་ཆུ་མོད་ས་ལ་གནས། ། ཁོང་གི་རྒྱལ་པོ་ཨ་གག་ལས་མཆོག་ཅིང་། ། ཁོང་གི་རྒྱལ་ཁམས་མཐོ་རུ་འཕགས་པར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","དཀོན་མཆོག་གིས་ཁོང་ཨེ་ཅིབ་ཡུལ་ནས་ཁྲིད། ། གླང་རྒོད་འདྲ་བའི་སྟོབས་ཤུགས་ཁོང་ལ་ལྡན། ། དགྲ་བོའི་མི་རིགས་རྩ་མེད་གཏོང་བ་དང་། ། དེ་ཚོའི་རུས་པ་རྣམས་ནི་གཅོག་བྱེད་ཅིང་། ། མདའ་མོས་དེ་དག་ཡོངས་སུ་འབིགས་པར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","སེང་གེ་ས་ལ་ཉལ་ཞིང་ཙོག་པུར་སྡོད་པ་དང་། ། མོ་སེང་ཇི་བཞིན་ཉལ་བ་སུ་ཡིས་དཀྲོག་ནུས་སམ། ། ཁྱེད་ལ་བྱིན་རླབས་གནང་མཁན་རྣམས་ལ་བྱིན་རླབས་འཐོབ་པ་དང་། ། ཁྱེད་ལ་དམོད་མོ་འདེབ་མཁན་རྣམས་ལ་དམོད་མོ་ཐེབས་གྱུར་ཅིག ། ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","པཱ་ལག་ནི་པེལ་ཨམ་ལ་ཁྲོས་ནས་ཐལ་མོ་བརྡབས་ཏེ་ན་རེ། ངའི་དགྲ་ཟླ་རྣམས་ལ་དམོད་པ་གཏོང་བའི་ཆེད་དུ་ཁྱེད་བོས་འོངས་པ་ཡིན་མོད། ལྟོས་དང་། ཁྱེད་ཀྱིས་ལན་གསུམ་དུ་དེ་དག་ལ་བྱིན་གྱིས་བརླབས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ད་ནི་ཁྱེད་ཉིད་རང་ཡུལ་དུ་ཕྲོས་ཤིག ངས་ཁྱེད་ལ་གུས་པ་ཆེན་པོ་འཐོབ་པར་བྱ་བསམས་ནའང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཁྱེད་ལ་གུས་པ་འཐོབ་པར་མ་མཛད་ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bodn_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","པེལ་ཨམ་གྱིས་པཱ་ལག་ལ། ངས་ཁྱོད་ཀྱིས་ངའི་རྩར་བཏང་བའི་བང་ཆེན་རྣམས་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","པཱ་ལག་གིས་རང་གི་གསེར་དངུལ་ཁང་པ་གང་པོ་ང་ལ་བྱིན་ན་ཡང་། ངས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་ལས་བརྒལ་ཏེ་རང་འདོད་ལྟར་བཟང་ངན་གྱི་ལས་གང་ཡང་བྱེད་མི་རུང་། དཀོན་མཆོག་ཡ་ཝཱེས་ཅི་ལྟར་གསུངས་པ་ཡིན་ན་ངས་དེ་ལྟར་བརྗོད་དགོས་ཞེས་སྨྲས་པ་མ་ཡིན་ནམ། ");
INSERT INTO bodn_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ད་ལྟ་ང་ནི་རང་གི་མི་མང་གི་རྩར་འགྲོ་བར་བྱ། ཤོག་དང་། ཕྱིས་སུ་མི་འདི་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་མི་མང་ལ་ཅི་བྱེད་ངེས་པ་ངས་ཁྱོད་ལ་བསླབ་པར་བྱ་ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","དེ་ནས་ཁོས་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ནས་འདི་ལྟར། པེ་ཨོར་བུ་སྟེ་པེལ་ཨམ་ཁོ་ན་རེ། ། མིག་རྒྱང་རིང་བའི་མི་ཡིས་འདི་སྐད་སྨྲ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","དཀོན་མཆོག་ཁོང་གི་བཀའ་ནི་ཐོས་འགྱུར་ཞིང་། ། བླ་མེད་ཉིད་ཀྱི་ཤེས་ཡོན་རྟོགས་པ་དང་། ། ཀུན་དབང་ཉིད་ཀྱི་ཞལ་གཟིགས་མཐོང་བ་དང་། ། ལུས་པོ་ས་རུ་འགྱེལ་ཞིང་མིག་ཟུང་ནི། ། ཕྱེས་པ་དེ་ཡིས་འདི་སྐད་སྨྲ་བར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","བདག་གིས་ཁོང་ཉིད་མཐོང་ཡང་ད་ལྟ་མིན། ། ང་ཡིས་ཁོང་ཉིད་མཇལ་ཡང་ཉེ་སར་མིན། ། ཡ་ཀོབ་ཁོང་ནས་སྐར་མ་ཞིག་ཐོན་ཞིང་། ། ཡེས་ར་ཨེལ་ལས་ཕྱག་འཁར་ཞིག་དར་ངེས། ། དེ་ཡིས་མོ་ཨབ་ཀྱི་ནི་དཔྲལ་བ་གཏོར། ། སེད་ཐུ་པ་རྣམས་མགོ་བོ་བརྫི་བར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","དེ་ཡིས་ཨེ་དོམ་རང་གི་དབང་དུ་བསྡུ་བ་དང་། ། དགྲ་བོའི་ཡུལ་ཏེ་སེ་ཨིར་ཡང་ནི་དབང་དུ་བསྡུ། ། ཡེས་ར་ཨེལ་པ་འབའ་ཞིག་སྟོབས་དང་ལྡན་པར་འགྱུར། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","དབང་སྒྱུར་པ་ཞིག་ཡ་ཀོབ་ནས་ཐོན་ཞིང་། ། གྲོང་ཁྱེར་ནང་གི་ལྷག་ལུས་རྣམས་འཇོམས་སོ། ། ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","པེལ་ཨམ་གྱིས་ཨ་མཱད་ལེག་མཐོང་སྟེ་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ནས་འདི་ལྟར། ཨ་མཱད་ལེག་ནི་མི་རིགས་རྣམས་ཀྱི་ཐོག་མ་ཡིན། ། འོན་ཀྱང་མཐའ་མར་དེ་ནི་འཇིག་པར་འགྱུར་བ་འོ། །ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ཡང་པེལ་ཨམ་གྱིས་ཀེ་ནེ་པ་རྣམས་མཐོང་སྟེ་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ནས་འདི་ལྟར། ཁྱོད་ཀྱི་སྡོད་གནས་སྲ་ཞིང་བརྟན་པ་དང་། ། ཁྱོད་ཀྱི་ཚང་ཡང་བྲག་གི་ངོས་སུ་ཡོད། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","འོན་ཀྱང་ཀེ་ནེ་མེ་ལ་འབར་བར་འགྱུར། ། ཨ་སུར་གྱིས་ཁྱོད་བཙོན་དུ་ནམ་ཁྲིད་དམ། །ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","པེལ་ཨམ་གྱིས་ཡང་རང་གི་ལུང་བསྟན་དབྱངས་ལ་གྱེར་ནས་འདི་ལྟར། ཀྱེ་ཧོ་དཀོན་མཆོག་ཉིད་ཀྱིས་འདི་ལྟར་མཛད། ། སུ་ཞིག་གསོན་པོར་ལུས་པར་འགྱུར་བ་ཡིན། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ཀི་ཐིམ་ཕྱོགས་ནས་གྲུ་གཟིངས་རྣམས་འོང་ཞིང་། ཨ་སུར་ཨེ་བེར་གཉིས་ལ་མནར་གཅོད་གཏོང་། ། དེ་ནས་ཁོ་ཡང་འཇིག་པར་འགྱུར་བ་འོ། །ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","དེ་ནས་པེལ་ཨམ་ལངས་ནས་རང་ཡུལ་དུ་ལོག་པ་དང་། པཱ་ལག་ཀྱང་རང་གི་ལམ་དུ་ཞུགས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","དེ་ཡང་ཡེས་ར་ཨེལ་པ་རྣམས་སིད་ཏིམ་ཡུལ་དུ་བསྡད་ཅིང་། མི་ཚོགས་ཀྱིས་མོ་ཨབ་ཀྱི་བུད་མེད་ཚོར་ལོག་གཡེམ་བྱས། ");
INSERT INTO bodn_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","བུད་མེད་དེ་དག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་བོས་ཡོང་ནས་མཉམ་དུ་རང་གི་ལྷ་རྣམས་ལ་མཆོད་པ་འབུལ་དུ་བཅུག་ཅིང་། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་ཀྱང་བཟའ་བཏུང་སྤྱད་པ་དང་ཁོ་ཚོའི་ལྷ་རྣམས་ལ་ཕྱག་བཙལ་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱིས་པཱ་ཨལ་ཕེ་ཨོར་དང་མཉམ་འབྲེལ་བྱས་པས། དཀོན་མཆོག་ཡ་ཝཱེ་ཡེས་ར་ཨེལ་པའི་སྟེང་ཐུགས་ཁྲོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཡ་ཝཱེའི་ཐུགས་ཁྲོ་ཞི་བར་གྱུར་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་ཐུགས་རབ་ཏུ་མི་ཁྲོ་བའི་ཕྱིར་དུ། མི་རྣམས་ཀྱི་འགོ་དཔོན་ཐམས་ཅད་བཟུང་སྟེ་ཡ་ཝཱེའི་མདུན་དུ་ཁ་ཉི་མར་གཏད་ནས་དཔྱོངས་ཤིག་ཅེས་གསུངས། ");
INSERT INTO bodn_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","དེ་ནས་མོ་ཤེ་ཡིས་ཡེས་ར་ཨེལ་གྱི་ཁྲིམས་དཔོན་རྣམས་ལ་འདི་ལྟར། ཁྱོད་རྣམས་རེ་རེས་པཱ་ཨལ་ཕེ་ཨོར་དང་མཉམ་འབྲེལ་བྱས་པའི་མི་དེ་དག་སོད་ཅིག་ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","དེ་ནས་མོ་ཤེ་དང་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཡོངས་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར་ངུ་བའི་སྐབས་སུ། ཀྱེ་ཧོ། ཡེས་ར་ཨེལ་པ་རྣམས་ལས་མི་ཞིག་གིས་ཁོ་རྣམས་ཀྱི་མཐོང་སར་མིད༌ཡཱན་པའི་བུད་མེད་ཅིག་རང་གི་སྤུན་རྣམས་ཀྱི་རྩར་ཁྲིད་ནས་སོང་། ");
INSERT INTO bodn_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","དེ་ནས་མཆོད་དཔོན་ཨ་རོན་གྱི་ཚ་བོ་སྟེ་ཨེ་ལི་ཨ་ཟར་གྱི་བུ་ཕི་ནེ་ཧེ་ཡིས་དེ་མཐོང་མ་ཐག མི་ཚོགས་ཀྱི་དཀྱིལ་ནས་ལངས་ཏེ་ལག་ཏུ་མདུང་ཞིག་ཐོགས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ཡེས་ར་ཨེལ་པ་དེའི་རྗེས་འབྲངས་ནས་གུར་ནང་དུ་འཛུལ་ཏེ་ཁོ་དང་བུད་མེད་དེ་གཉིས་ལ་བསྣུན་ནས་ཕུག་པ་དང་། མདུང་ནི་བུད་མེད་དེའི་གྲོད་ཁོག་ནང་ལ་ཟུག དེ་ནས་ཡེས་ར་ཨེལ་པའི་ཁྲོད་དུ་གཉན་ནད་མེད་པར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","སྐབས་དེར་གཉན་ནད་ལས་ཤི་བའི་མི་གྲངས་བསྡོམས་པས་ཉིས་ཁྲི་བཞི་སྟོང་ཡོད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","མཆོད་དཔོན་ཨ་རོན་གྱི་ཚ་བོ་ཨེ་ལི་ཨ་ཟར་གྱི་བུ་ཕི་ནེ་ཧེ་ཡིས་ཡེས་ར་ཨེལ་པའི་ཁྲོད་དུ་བདག་གི་འཁུར་ཞེན་སེམས་སུ་བཅངས་པས། བདག་གི་ཁོང་ཁྲོ་ཁོ་རྣམས་ཀྱི་སྟེང་ནས་བསྒྱུར། དེས་བདག་ལ་འཁུར་ཞེན་དང་བཅས་ཡེས་ར་ཨེལ་པ་རྣམས་མེད་པར་མི་བཟོ་བར་བྱས། ");
INSERT INTO bodn_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","དེའི་ཕྱིར་ཁྱོད་ཀྱིས་འདི་ལྟར། ལྟོས་དང་ད་ལྟ་བདག་གིས་ཞི་བདེའི་ཞལ་ཆད་ཁོ་ལ་སྦྱིན་པར་བྱ་ཞིང་། ");
INSERT INTO bodn_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ཁོ་དང་ཁོའི་རིགས་རྒྱུད་རྣམས་ཀྱིས་དུས་གཏན་དུ་མཆོད་དཔོན་གྱི་ལས་འགན་འཁུར་བའི་ཞལ་ཆད་དུ་འགྱུར་ཏེ། ཅི་ལ་ཞེ་ན། ཁོ་ལ་རང་གི་དཀོན་མཆོག་གི་ཕྱིར་དུ་འཁུར་ཞེན་དང་ལྡན་ཞིང་། ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྡིག་བཤགས་བྱས་པའི་ཕྱིར་ཡིན་ཞེས་སྨྲོས་ཤིག་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","མིད༌ཡཱན་པའི་བུད་མེད་དེ་དང་མཉམ་དུ་བསད་པའི་ཡེས་ར་ཨེལ་པ་དེའི་མིང་ནི་སཱ་ལུ་བྱ་བའི་བུ་ཟིམ་རེ་ཡིན་པ་དང་། སི་མུ་ཨོན་ཚོ་པའི་ཁྱིམ་རྒྱུད་ཅིག་གི་འགོ་དཔོན་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","བསད་པར་གྱུར་པའི་མིད༌ཡཱན་པའི་བུད་མེད་དེའི་མིང་ལ་ཀོ་ཟི་པེ་ཟེར་ཞིང་ཙུར་བྱ་བའི་བུ་མོ་ཡིན་ལ། ཙུར་ནི་མིད་ཡཱན་པའི་ཁྱིམ་རྒྱུད་ཅིག་གི་འགོ་དཔོན་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","ཁྱོད་ཀྱིས་མིད༌ཡཱན་པ་རྣམས་དགྲ་རུ་བཟུང་ནས་དེ་དག་སོད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ཅི་ལ་ཞེ་ན། དེ་དག་གིས་ཁྱོད་ལ་བརྙས་བཅོས་བྱས་ནས་ཕེ་ཨོར་གྱི་དོན་དུ། མིད་ཡཱན་པའི་འགོ་དཔོན་གྱི་བུ་མོ་ཀོ་ཟི་པེའི་དོན་གྱི་སྟེང་དུ་གཡོ་སྒྱུའི་སྦྱོར་བ་སྤེལ་ནས་ཁྱོད་རྣམས་ལ་སླུ་བྲིད་བཏང་། དེ་བས་ཀོ་ཟི་པེ་ནི་གཉན་ནད་ཀྱི་ཉིན་མོར་ཕེ་ཨོར་གྱི་དོན་དག་གི་རྐྱེན་གྱིས་བསད་པའོ་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","དེ་ཡང་གཉན་ནད་བྱུང་བའི་རྗེས་སུ་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་དང་མཆོད་དཔོན་ཨ་རོན་གྱི་བུ་ཨེ་ལི་ཨ་ཟར་གཉིས་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","ཁྱོད་རྣམས་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ལས་ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་འཐབ་མོར་ཞུགས་ཐུབ་པ་རྣམས་ནི་དེ་དག་གི་ཕ་ཁྱིམ་བཞིན་དུ་རྩིས་ལེན་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","དེ་ནས་མོ་ཤེ་དང་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་གཉིས་ཀྱིས་མོ་ཨབ་སྤང་ལྗོངས་ཏེ། ཡེ་རུ་ཀོའི་ཁ་གཏད་དུ་ཡོར་དན་གཙང་པོའི་འགྲམ་ནས་དེ་དག་ལ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་བཀའ་གནང་བ་བཞིན་དུ་ལོ་ཉི་ཤུ་ཅན་དང་དེའི་ཡན་གྱི་མི་རྣམས་རྩིས་ལེན་དགོས་ཞེས་སྨྲས་སོ། ། ཨེ་ཅིབ་ཡུལ་ནས་འོངས་པའི་ཡེས་ར་ཨེལ་པ་རྣམས་ནི་འདི་ལྟ་སྟེ། ");
INSERT INTO bodn_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ཡེས་ར་ཨེལ་གྱི་བུ་སྐྱེས་འགོ་རུ་བེན་དང་། རུ་བེན་གྱི་བུ་རྒྱུད་རྣམས་ནི་ཧ་ནོག་ལ་གཏོགས་པ་ཧ་ནོག་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཕཱ༌ལུའུ་ལ་གཏོགས་པ་ཕཱ་ལུའུ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད། ");
INSERT INTO bodn_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ཧེས་རོན་ལ་གཏོགས་པ་ཧེས་རོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཀར་མའེ་ལ་གཏོགས་པ་ཀར་མའེ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","འདི་དག་ནི་རུ་བེན་གྱི་ཁྱིམ་རྒྱུད་ཡིན་པ་དང་། དེ་དག་ནས་རྩིས་བླངས་པ་ནི་བསྡོམས་པས་བཞི་ཁྲི་སུམ་སྟོང་བདུན་བརྒྱ་སུམ་ཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ཕཱ༌ལུའུ་ཡི་བུ་ནི་ཨེ་ལི་ཨབ་ཡིན་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ཨེ་ལི་ཨབ་ཀྱི་བུ་རྣམས་ནི་ནེ་མུ་ཨེལ་དང་། དཱ་ཐན་དང་། ཨ་བི་རཱམ་བཅས་ཡིན། དཱ་ཐན་དང་ཨ་བི་རཱམ་ནི་མ་གཞི་མི་ཚོགས་ཁྲོད་ནས་བདམས་པ་དང་། དེ་གཉིས་དང་ཀོ་རཱག་ཕྱོགས་ཁག་གི་མི་རྣམས་ཀྱིས་ཁ་མཐུན་ནས་མཉམ་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་ངོ་རྒོལ་བྱས་ཤིང་། མོ་ཤེ་དང་ཨ་རོན་གཉིས་ལའང་ངོ་རྒོལ་བྱས་པའི་དུས་སུ། ");
INSERT INTO bodn_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ས་གཞིས་ཁ་གདངས་ནས་དེ་དག་དང་ཀོ་རཱག་མཉམ་དུ་ཁྱུར་མིད་བཏང་བ་དང་། ཀོ་རཱག་དང་ཁོའི་ཆོས་ཚོགས་ཀྱི་མི་ཐམས་ཅད་ཤི་བར་གྱུར། མེ་ཡིས་མི་ཉིས་བརྒྱ་དང་ལྔ་བཅུ་འགེམས་པའི་དུས་དེ་ནི་ཕྱི་འདོམས་ཀྱི་མེ་ལོང་དུ་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","འོན་ཀྱང་ཀོ་རཱག་གི་བུ་རྒྱུད་རྣམས་འཆི་བར་མ་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","སི་མུ་ཨོན་གྱི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། ནེ་མུ་ཨེལ་ལ་གཏོགས་པ་ནེ་མུ་ཨེལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཡཱ་མེན་ལ་གཏོགས་པ་ཡཱ་མེན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཡཱ་ཀིན་ལ་གཏོགས་པ་ཡཱ་ཀིན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ཟེ༌རག་ལ་གཏོགས་པ་ཟེ༌རག་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཤཱ་ཨུལ་ལ་གཏོགས་པ་ཤཱ་ཨུལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","འདི་དག་ནི་སི་མུ་ཨོན་གྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ་བསྡོམས་པས་ཉིས་ཁྲི་ཉིས་སྟོང་ཉིས་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","གཱ་རྡུའི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། ཚཱ་ཕོན་ལ་གཏོགས་པ་ཚཱ་ཕོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧ་གིད་ལ་གཏོགས་པ་ཧ་གིད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཤུ་ནེ་ལ་གཏོགས་པ་ཤུ་ནེ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ཨོ་ཟི་ནེ་ལ་གཏོགས་པ་ཨོ་ཟི་ནེ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཨེ་རི་ལ་གཏོགས་པ་ཨེ་རི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ཨ་རོད་ལ་གཏོགས་པ་ཨ་རོད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཨར་ཨེ་ལི་ལ་གཏོགས་པ་ཨར་ཨེ་ལི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","འདི་དག་ནི་གཱ་རྡུ་ཡི་བུ་རྒྱུད་ཀྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་བཞི་ཁྲི་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ཡ་ཧུ་དཱའི་བུ་ནི་ཨེར་དང་ཨོ་ནན་གཉིས་ཡིན། ཨེར་དང་ཨོ་ནན་གཉིས་པོ་ཀ་ན་ཨན་ཡུལ་དུ་ཤི་བར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ཡ་ཧུ་དཱའི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། ཤེ་ལཱ་ལ་གཏོགས་པ་ཤེ་ལཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཕེ་རེལ་ཟི་ལ་གཏོགས་པ་ཕེ་རེལ་ཟི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཟེ་རག་ལ་གཏོགས་པ་ཟེ་རག་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ཕེ་རེལ་ཟི་ཡི་བུ་རྒྱུད་རྣམས་ལས་ཧེས་རོན་ལ་གཏོགས་པ་ཧེས་རོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧ་མུལ་ལ་གཏོགས་པ་ཧ་མུལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","འདི་དག་ནི་ཡ་ཧུ་དཱའི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་བདུན་ཁྲི་དྲུག་སྟོང་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ཡེས་སི་ཀཱར་གྱི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། ཐོ་ལཱ་ལ་གཏོགས་པ་ཐོ་ལཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཕུ་བཱ་ལ་གཏོགས་པ་ཕུ་བཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ཡ་ཤུབ་ལ་གཏོགས་པ་ཡ་ཤུབ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཤིམ་རོན་ལ་གཏོགས་པ་ཤིམ་རོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","འདི་དག་ནི་ཡེས་སི་ཀཱར་གྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་དྲུག་ཁྲི་བཞི་སྟོང་སུམ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ཟེ་བུ་ལུན་གྱི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། སེ་རཱད་ལ་གཏོགས་པ་སེ་རཱད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཨེད་ལོན་ལ་གཏོགས་པ་ཨེད་ལོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཡ་ལཱ་ཨལ་ལ་གཏོགས་པ་ཡ་ལཱ་ཨལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","འདི་དག་ནི་ཟེ་བུ་ལུན་གྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་དྲུག་ཁྲི་ལྔ་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ཡོ་སེབ་ཀྱི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་མཱ་ན་ཤེ་དང་ཨེ་ཕཱར་ཡིམ་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","མཱ་ན་ཤེའི་བུ་རྒྱུད་རྣམས་ནི་མཱ་ཀིར་ལ་གཏོགས་པ་མཱ་ཀིར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། མཱ་ཀིར་ནས་གིལ་ཨད་སྐྱེས་པ་དང་། གིལ་ཨད་ལ་གཏོགས་པ་གིལ་ཨད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","གིལ་ཨད་ཀྱི་བུ་རྒྱུད་རྣམས་ནི་འདི་ལྟ་སྟེ། ཨི་ཨེ་ཟིར་ལ་གཏོགས་པ་ཨི་ཨེ་ཟིར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧེ་ལེག་ལ་གཏོགས་པ་ཧེ་ལེག་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ཨ་སི་རི་ཨེལ་ལ་གཏོགས་པ་ཨ་སི་རི་ཨེལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཤེ་ཀེམ་ལ་གཏོགས་པ་ཤེ་ཀེམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ཤེ་མི་ད་ལ་གཏོགས་པ་ཤེ་མི་ད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧེ་ཕེར་ལ་གཏོགས་པ་ཧེ་ཕེར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ཧེ་ཕེར་གྱི་བུ་ཚེ་ལོ་ཕེ་ཧད་ལ་བུ་མེད་ཅིང་བུ་མོ་འབའ་ཞིག་ཡོད་དེ། ཚེ་ལོ་ཕེ་ཧད་ཀྱི་བུ་མོ་རྣམས་ཀྱི་མིང་ནི། མ་ལཱ་དང་། ནོ་ཨ་དང་། ཧོག་ལཱ་དང་། མིལ་ཀཱ་དང་། ཐིར་ཚ་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","འདི་དག་ནི་མཱ་ན་ཤེའི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་གྲངས་ཀ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་ལྔ་ཁྲི་ཉིས་སྟོང་དང་བདུན་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ཨེ་ཕཱར་ཡིམ་གྱི་བུ་རྒྱུད་རྣམས་ནི་འདི་ལྟ་སྟེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་ཤུ་ཏེ་ལཱ་ལ་གཏོགས་པ་ཤུ་ཏེ་ལཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། པེ་ཀེར་ལ་གཏོགས་པ་པེ་ཀེར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཐ་ཧན་ལ་གཏོགས་པ་ཐ་ཧན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ཤུ་ཏེ་ལཱ་ཡི་བུ་རྒྱུད་དེ་ཨེ་རན་ལ་གཏོགས་པ་ཨེ་རན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","འདི་དག་ནི་ཨེ་ཕཱར་ཡིམ་གྱི་བུ་རྒྱུད་ཀྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་སུམ་ཁྲི་ཉིས་སྟོང་ལྔ་བརྒྱའོ། །རང་རང་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་འདི་དག་ནི་ཡོ་སེབ་ཀྱི་བུ་རྒྱུད་རྣམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","པེན་ཡཱ་མེན་གྱི་བུ་རྒྱུད་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། པེ་ལཱ་ལ་གཏོགས་པ་པེ་ལཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཨ་ཤ༌བེལ་ལ་གཏོགས་པ་ཨ་ཤ༌བེལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཨ་ཧི་རམ་ལ་གཏོགས་པ་ཨ་ཧི་རམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ཤེ་ཕུ་ཕམ་ལ་གཏོགས་པ་ཤེ་ཕུ་ཕམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧུ་ཕམ་ལ་གཏོགས་པ་ཧུ་ཕམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","པེ་ལཱའི་བུ་རྣམས་ནི་ཨར་དཱ་དང་ནཱ་ཨ་མཱན་ཡིན་ལ། ཨར་དཱ་ལ་གཏོགས་པ་ཨར་དཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ནཱ་ཨ་མཱན་ལ་གཏོགས་པ་ནཱ་ཨ་མཱན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","འདི་དག་ནི་པེན་ཡཱ་མེན་གྱི་བུ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་བཞི་ཁྲི་ལྔ་སྟོང་དྲུག་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","དཱན་གྱི་བུ་རྒྱུད་རྣམས་ནི་འདི་ལྟ་སྟེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་ཤུ་ཧམ་ལ་གཏོགས་པ་ཤུ་ཧམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ཡིན། དེ་ནི་དཱན་གྱི་ཁྱིམ་རྒྱུད་དེ་རང་རང་གི་ཁྱིམ་རྒྱུད་བཞིན་དུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ཤུ་ཧམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་ནས་རྩིས་བླངས་པའི་བསྡོམས་གྲངས་ནི་དྲུག་ཁྲི་བཞི་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ཨ་ཤེར་གྱི་བུ་རྒྱུད་རྣམས་ནི་འདི་ལྟ་སྟེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་ཡིམ་ནཱ་ལ་གཏོགས་པ་ཡིམ་ནཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཡེས་བི་ལ་གཏོགས་པ་ཡེས་བི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། པེ་རེ་ཡཱ་ལ་གཏོགས་པ་པེ་རེ་ཡཱ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","པེ་རེ་ཡཱའི་བུ་རྒྱུད་རྣམས་ནི་ཧེ་བེར་ལ་གཏོགས་པ་ཧེ་བེར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། མཱལ་ཀི་ཨེལ་ལ་གཏོགས་པ་མཱལ་ཀི་ཨེལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ཨ་ཤེར་གྱི་བུ་མོའི་མིང་ལ་སེ་རཱ་ཞེས་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","འདི་དག་ནི་ཨ་ཤེར་གྱི་བུ་རྒྱུད་ཀྱི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་ཏེ། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་ཡིན་ལ། བསྡོམས་པས་ལྔ་ཁྲི་སུམ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ནཱབ་ཐ་ལིའི་བུ་རྒྱུད་རྣམས་ནི་དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ། ཡཱ་སི་ཨེལ་ལ་གཏོགས་པ་ཡཱ་སི་ཨེལ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། གུ་ནེ་ལ་གཏོགས་པ་གུ་ནེ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ཡེ༌ཚིར་ལ་གཏོགས་པ་ཡེ་ཚིར་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཤིལ་ལེམ་ལ་གཏོགས་པ་ཤིལ་ལེམ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","འདི་དག་ནི་ནཱབ་ཐ་ལིའི་ཁྱིམ་རྒྱུད་རྣམས་ཡིན་པ་དང་། དེ་དག་གི་ཁྱིམ་རྒྱུད་བཞིན་དུ་རྩིས་བླངས་པ་བསྡོམས་པས་བཞི་ཁྲི་ལྔ་སྟོང་བཞི་བརྒྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","དེ་དག་ནི་ཡེས་ར་ཨེལ་པ་རྣམས་ལས་རྩིས་བླངས་པའི་གྲངས་ཀ་སྟེ། བསྡོམས་པས་དྲུག་འབུམ་ཆིག་སྟོང་བདུན་བརྒྱ་སུམ་ཅུའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","ཁྱོད་ཀྱིས་མི་རྣམས་ཀྱི་མིང་གི་གྲངས་ཀ་བཞིན་དུ། ཡུལ་དེ་ཁོ་རྣམས་ལ་ས་སྐལ་དུ་བགོ་བཤའ་བརྒྱག་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","མི་གྲངས་མང་པོ་ཡོད་པ་ལ་ཁྱོད་ཀྱིས་ས་སྐལ་མང་པོ་བགོ་དགོས་པ་དང་། མི་གྲངས་ཉུང་ཉུང་ཡིན་པ་ལ་ཁྱོད་ཀྱིས་ས་སྐལ་ཉུང་ཉུང་བགོ་དགོས། རྩིས་བླངས་པའི་མི་གྲངས་བཞིན་དུ་ཁྱིམ་རྒྱུད་རེ་རེ་ལ་ས་སྐལ་བགོ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","འོན་ཀྱང་། ཡུལ་ནི་རྒྱན་འཕངས་ནས་བགོ་བཤའ་བརྒྱག་དགོས་ལ། དེ་དག་གིས་རང་རང་གི་ཕ་མེས་རྣམས་ཀྱི་ཚོ་པའི་མིང་བཞིན་དུ་ས་སྐལ་ལེན་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","རྒྱན་བླངས་པ་བཞིན་དུ། མི་གྲངས་མང་ཉུང་ལ་བལྟས་ནས་ས་སྐལ་བགོ་བཤའ་བརྒྱག་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ཁྱིམ་རྒྱུད་བཞིན་རྩིས་གྲངས་བླངས་པའི་ལེ་ཝི་པ་ནི་འདི་ལྟ་སྟེ། གེར་ཤོན་ལ་གཏོགས་པ་གེར་ཤོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཀོ་ཧད་ལ་གཏོགས་པ་ཀོ་ཧད་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། མཱ་རཱ་རེའེ་ལ་གཏོགས་པ་མཱ་རཱ་རེའེ་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","འདི་དག་ནི་ལེ་ཝི་ཡི་ཁྱིམ་རྒྱུད་རྣམས་ཏེ། ལིབ་ནིས་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཧེབ་རོན་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། མཱ་ལི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། མུ་ཤི་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་དང་། ཀོ་རཱག་པ་རྣམས་ཀྱི་ཁྱིམ་རྒྱུད་བཅས་ཡིན་ནོ། །ཀོ་ཧད་ལས་ཨམ་རམ་སྐྱེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ཨམ་རམ་གྱི་ཆུང་མའི་མིང་ལ་ཡོ་ཀེ་བེད་ཟེར་ཞིང་ལེ་ཝིའི་བུ་མོ་ཡིན་ལ་ཨེ་ཅིབ་ཡུལ་དུ་ལེ་ཝི་ལ་སྐྱེས་ཤིང་། ཁོ་མོས་ཨམ་རམ་ལ་ཨ་རོན་དང་མོ་ཤེ། དེ་གཉིས་ཀྱི་ལྕམ་མོ་མིར་ཡམ་བཅས་བཙས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ཡང་ཨ་རོན་ལས་ནཱ་དབ་དང་། ཨ་བི་ཧུ་དང་། ཨེ་ལི་ཨ་ཟར་དང་། ཨི་ཐ་མཱར་བཅས་སྐྱེས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ནཱ་དབ་དང་ཨ་བི་ཧུ་གཉིས་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་བཀའ་འཁྲོལ་མེད་པའི་མེ་ཕུལ་བའི་དུས་སུ་ཤི་བར་གྱུར་ཏོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ལེ་ཝི་པ་རྣམས་ལས་ཟླ་བ་གཅིག་དང་དེའི་ཡན་གྱི་ན་ཚོད་ཟིན་པའི་ཕོ་ཐམས་ཅད་རྩིས་བླངས་པ་བསྡོམས་པས་ཉིས་ཁྲི་སུམ་སྟོང་ཡིན། ཁོ་རྣམས་ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་རྩིས་མེད་དེ། གང་ལ་ཞེ་ན། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་ཁོ་རྣམས་ལ་ས་སྐལ་མ་ཐོབ་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","དེ་དག་ནི་མོ་ཤེ་དང་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་གཉིས་ཀྱིས་རྩིས་བླངས་པ་རྣམས་ཡིན་ཏེ། དེ་གཉིས་ཀྱིས་མོ་ཨབ་སྤང་ལྗོངས་སུ། ཡེ་རུ་ཀོའི་ཁ་གཏད་དུ་ཡོར་དན་གཙང་པོའི་འགྲམ་ནས་ཡེས་ར་ཨེལ་པ་རྣམས་རྩིས་བླངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","དེ་དག་གི་ཁྲོད་དུ་མོ་ཤེ་དང་མཆོད་དཔོན་ཨ་རོན་གཉིས་ཀྱིས་སི་ནཱ་དབེན་སྟོང་དུ་ཡེས་ར་ཨེལ་པ་རྣམས་རྩིས་ལེན་པའི་དུས་སུ་རྩིས་བླངས་པ་ནི་གཅིག་ཀྱང་མེད། ");
INSERT INTO bodn_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ཅི་ལ་ཞེ་ན། དཀོན་མཆོག་ཡ་ཝཱེས་དེ་རྣམས་ཀྱི་སྐོར་ལ་སྔར་འདི་སྐད་དུ། དེ་དག་དབེན་སྟོང་དུ་འཆི་ངེས་ཡིན་ཞེས་གསུངས་མྱོང་བའི་ཕྱིར་རོ། །དེ་རྣམས་ལས་ཡེ་ཕུན་ནེའི་བུ་ཀཱ་ལེབ་དང་ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་གཉིས་ལས་གཞན་གཅིག་ཀྱང་མ་ལུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","དེ་ཡང་ཡོ་སེབ་ཀྱི་བུ་མ་ནཱ་ཤེའི་ཁྱིམ་རྒྱུད་རྣམས་ལས། ཚེ་ལོ་ཕེ་ཧད་ཀྱི་བུ་མོ་རྣམས་དེ་དག་གི་དྲུང་དུ་འོངས་པ་དང་། ཚེ་ལོ་ཕེ་ཧད་ནི་ཧེ་ཕེར་གྱི་བུ་དང་། དེ་ནི་གིལ་ཨད་ཀྱི་བུ། དེ་ནི་མཱ་ཀིར་གྱི་བུ། དེ་ནི་མཱ་ན་ཤེའི་བུའོ། །ཁོའི་བུ་མོ་དེ་རྣམས་ཀྱི་མིང་ནི། མ་ལཱ་དང་། ནོ་ཨ་དང་། ཧོག་ལཱ་དང་། མིལ་ཀཱ་དང་། ཐིར་ཚ་བཅས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","དེ་དག་མཇལ་འཕྲད་གུར་མཆོག་གི་སྒོ་ཁར། མོ་ཤེ་དང་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་དང་འགོ་དཔོན་རྣམས་དང་། མི་ཚོགས་ཡོངས་ཀྱི་མདུན་དུ་འགྲེང་སྟེ་ན་རེ། ");
INSERT INTO bodn_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","ངེད་ཅག་གི་ཕ་ནི་དབེན་སྟོང་དུ་ཤི་བ་དང་། ཁོ་ནི་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་རྒོལ་བར་མཉམ་དུ་འདུས་པའི་མི་རྣམས་ཀྱི་ཁྲོད་དུ་མེད་ལ། ཀོ་རཱག་གི་ཕྱོགས་ཁག་ལའང་མི་གཏོགས། ཁོ་ནི་རང་གི་སྡིག་པའི་དབང་གིས་ཤི་བ་དང་ཁོ་ལ་བུ་ཡང་མེད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ངེད་ཅག་གི་ཕ་ལ་བུ་མེད་པའི་རྐྱེན་གྱིས་ཁོའི་མིང་རང་གི་ཁྱིམ་རྒྱུད་ལས་མེད་པར་བཟོས་པ་ཅི་ཡིན་ནམ། ངེད་ཅག་གི་ཕ་ཡི་སྤུན་ཟླ་ཚོའི་ཁྲོད་དུ་ང་ཚོ་ལ་བགོ་སྐལ་གནང་བར་མཛོད་ཅེས་ཞུས། ");
INSERT INTO bodn_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","དེ་ནས་མོ་ཤེ་ཡིས་ཁོ་རྣམས་ཀྱི་ཞུ་བ་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཞུས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","ཚེ་ལོ་ཕེ་ཧད་ཀྱི་བུ་མོ་རྣམས་ཀྱིས་སྨྲས་པ་ལུགས་དང་མཐུན་པ་ཡིན། ཁྱོད་ཀྱིས་དེ་དག་གི་ཕ་ཡི་སྤུན་ཟླའི་ཁྲོད་ནས་དེ་དག་ལ་བགོ་སྐལ་སྤྲོད་དགོས། དེ་དག་གི་ཕ་ཡི་བགོ་སྐལ་ཁོ་ཚོ་ལ་སྤྲོད་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ཡང་ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག མི་ཞིག་འཆི་བའི་དུས་སུ་བུ་མེད་པ་ཡིན་ན་མི་དེའི་བགོ་སྐལ་ཁོའི་བུ་མོར་སྤྲོད་དགོས་པ་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ཁོ་ལ་བུ་མོ་མེད་ན་ཁོའི་བགོ་སྐལ་དེའི་སྤུན་ཟླ་རྣམས་ལ་སྤྲོད་པར་བྱའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ཁོ་ལ་སྤུན་ཟླ་ཡང་མེད་ན་ཁོའི་བགོ་སྐལ་དེའི་ཕ་ཡི་སྤུན་རྣམས་ལ་སྤྲོད་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ཁོའི་ཕ་ལ་སྤུན་ཟླ་མེད་ན་ཁོའི་བགོ་སྐལ་ནི་དེའི་ཁྱིམ་རྒྱུད་ནང་གི་རྩ་བའི་གཉེན་ཉེ་ལ་སྤྲོད་དགོས་ཤིང་། ཁོའི་བགོ་སྐལ་མི་དེར་དབང་བ་ཡིན། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་གནང་བའི་བཀའ་བཞིན་དུ། ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་སྒྲིག་ཁྲིམས་དང་སྲོལ་ཡིག་ཡིན་ཞེས་སྨྲ་དགོས་པར་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཨ་བཱ་རིམ་གྱི་རི་འདི་ལ་ཡར་འགོས་ནས་བདག་གིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་སྤྲད་པའི་ཡུལ་དེར་ལྟོས་ཤིག ");
INSERT INTO bodn_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","དེར་བལྟས་པའི་རྗེས་སུ་ཁྱོད་ཀྱང་ཁྱོད་ཀྱི་སྤུན་ཨ་རོན་བཞིན་དུ་རང་གི་རིགས་རྒྱུད་ཁྲོད་དུ་འཛོམ་པར་འགྱུར། ");
INSERT INTO bodn_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ཅི་ལ་ཞེ་ན། ཟིན་བྱ་བའི་དབེན་སྟོང་དུ་མི་ཚོགས་ཀྱིས་ངོ་རྒོལ་བྱས་པའི་དུས་སུ། ཁྱོད་རྣམས་ངའི་བཀའ་དང་འགལ་ཞིང་། ཆུ་འགྲམ་ནས་དེ་དག་གི་མདུན་དུ་ང་དམ་པར་མ་བཀུར་བའི་ཕྱིར་ཡིན་ཞེས་གསུངས། ཆུ་དེ་ནི་ཟིན་བྱ་བའི་དབེན་སྟོང་དུ་ཡོད་ལ། དེ་ནི་ཀཱ་དེའེ་ཤཱ་ཡུལ་གྱི་མེ་རི་བཱའི་ཆུ་རྣམས་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འདི་ལྟར། ");
INSERT INTO bodn_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","ལུས་ཅན་ཐམས་ཅད་ཀྱི་སེམས་ཉིད་ཀྱི་དཀོན་མཆོག་ཡ་ཝཱེས་མི་ཚོགས་འདི་ལ་བདག་སྐྱོང་བྱེད་མཁན་ཞིག་བསྐོ་བར་མཛོད། ");
INSERT INTO bodn_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ཁོ་ཚོའི་མདུན་དུ་འགྲོ་འོང་བྱེད་པ་དང་། ཁོ་ཚོ་ཁྲིད་ནས་འགྲོ་འོང་བྱེད་མཁན་ཞིག་དགོས། དེ་ནི་དཀོན་མཆོག་ཡ་ཝཱེའི་མི་ཚོགས་རྫི་བོ་མེད་པའི་ལུག་དང་འདྲ་བར་མི་འགྱུར་བའི་ཕྱིར་དུའོ་ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bodn_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ཁྱོད་ཀྱིས་ནུན་གྱི་བུ་ཡོ་ཤུ་ཨ་འདེམས་དགོས་ཏེ། ཁོའི་ནང་དུ་ཐུགས་ཉིད་བཞུགས་ལ། ཁྱོད་ཀྱིས་ཁོའི་ལུས་ལ་ལག་པ་ཞོག་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ཁོ་ནི་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་དང་མི་ཚོགས་ཐམས་ཅད་ཀྱི་མདུན་ནས་འགྲེང་དུ་ཆུག་ལ། དེ་དག་གི་མཐོང་ངོར་ཁོ་ལ་ལས་འགན་སྤྲོད་ཅིག ");
INSERT INTO bodn_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ཡེས་ར་ཨེལ་པ་རྣམས་ཀྱི་མི་ཚོགས་ཡོངས་ཀྱིས་ཁོའི་བཀའ་ལ་མཉན་པའི་ཕྱིར་དུ། ཁྱོད་ཀྱིས་རང་གི་དབང་ཐང་ཆ་ཤས་ཁོ་ལ་ཐོངས་ཤིག་དང་། ");
INSERT INTO bodn_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ཁོ་རང་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་གྱི་དྲུང་དུ་འགྲེང་ནས་འདུག་པ་དང་། ཨེ་ལི་ཨ་ཟར་གྱིས་ཡོ་ཤུ་ཨའི་ཕྱིར་དཀོན་མཆོག་ཡ་ཝཱེའི་དྲུང་དུ་ཨུའུ་རིམ་ལས་ཐུགས་བརྟག་ཞུ་བར་འགྱུར། ཁོ་དང་ཡེས་ར་ཨེལ་པ་ཐམས་ཅད་དེ། མི་ཚོགས་ཡོངས་ནི་ཨེ་ལི་ཨ་ཟར་གྱི་བཀའ་བཞིན་འགྲོ་འོང་བྱེད་དགོས་ཞེས་གསུངས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","དེ་ནས་མོ་ཤེ་ཡིས་དཀོན་མཆོག་ཡ་ཝཱེའི་བཀའ་བཞིན་དུ་བསྒྲུབས་པ་དང་། ཁོས་ཡོ་ཤུ་ཨ་ཁྲིད་འོངས་ཏེ་མཆོད་དཔོན་ཨེ་ལི་ཨ་ཟར་དང་མི་ཚོགས་ཡོངས་ཀྱི་མདུན་ནས་འགྲེང་དུ་བཅུག་ཅིང་། ");
INSERT INTO bodn_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ཁོའི་ལུས་ལ་ཕྱག་གླན་པ་དང་། དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་བརྒྱུད་ནས་གནང་བའི་བཀའ་བཞིན་དུ་ཁོ་ལ་ལས་འགན་སྤྲད་དོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","དེ་ནས་ཡང་དཀོན་མཆོག་ཡ་ཝཱེས་མོ་ཤེ་ལ་འདི་སྐད་དུ། ");
INSERT INTO bodn_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","ཁྱོད་ཀྱིས་ཡེས་ར་ཨེལ་པ་རྣམས་ལ་བཀའ་འདི་ལྟར་སྒོས་ཤིག ཁྱོད་རྣམས་ཀྱིས་ང་ལ་འབུལ་འོས་པའི་མཆོད་པ་སྟེ། ང་ལ་དྲི་ཞིམ་གྱི་མེ་མཆོད་དུ་འབུལ་བའི་ཞལ་ཟས་ནི་དུས་བཅད་ལྟར་གཟབ་གཟབ་བྱས་ནས་ང་ལ་འབུལ་དགོས་ཞེས་པའོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ཡང་ཁྱོད་ཀྱིས་དེ་རྣམས་ལ་འདི་ལྟར་སྨྲོས་ཤིག ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས་པའི་མེ་མཆོད་ནི་འདི་ལྟ་སྟེ། ཉིན་རེར་སྐྱོན་མེད་པའི་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་གཉིས་རེ་དུས་རྒྱུན་གྱི་སྦྱིན་སྲེག་ཏུ་འབུལ་དགོས་པ་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ལུ་གུ་གཅིག་ནི་ཞོགས་པའི་དུས་སུ་འབུལ་བ་དང་། ཅིག་ཤོས་ནི་ས་སྲོས་ཀྱི་དུས་སུ་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","གཞན་ཡང་འབྲུ་རིགས་ཀྱི་མཆོད་པའི་ཕྱིར་དུ་ཕྱེ་བཟང་པོ་ཨེ་ཕཱ་གང་གི་བཅུ་ཆ་གཅིག་ལ་སྣུམ་བརྡུངས་མ་རྫ་བུམ་གང་གི་བཞི་ཆ་གཅིག་བསྲེས་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","དེ་ནི་དུས་རྒྱུན་གྱི་སྦྱིན་སྲེག་ཡིན་ལ། རི་བོ་སི་ནཱ་ནས་གཏན་ལ་ཕབ་པ་སྟེ། དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་བའི་དྲི་ཞིམ་གྱི་མེ་མཆོད་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ཡང་ལུ་གུ་རེའི་ཕྱིར་དུ་རྒུན་ཆང་རྫ་བུམ་གྱི་བཞི་ཆ་གཅིག་སྐྱེམས་མཆོད་དུ་འབུལ་དགོས། ཁྱོད་ཀྱིས་རྒུན་ཆང་བཙན་པོ་དེ་གནས་དམ་པ་རུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྐྱེམས་མཆོད་དུ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ས་སྲོས་ཀྱི་དུས་སུ་ལུ་གུ་ཅིག་ཤོས་དེ་འབུལ་དགོས། ཞོགས་པའི་འབྲུ་རིགས་ཀྱི་མཆོད་པ་དང་། དེ་དང་མཉམ་དུ་འབུལ་བའི་སྐྱེམས་མཆོད་ནང་ལྟར་དྲི་ཞིམ་གྱི་མེ་མཆོད་དུ་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་འབུལ་དགོས་སོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","དེ་ནས་ངལ་གསོ་བའི་ཉིན་མོར། སྐྱོན་མེད་པའི་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་གཉིས་དང་། འབྲུ་རིགས་ཀྱི་མཆོད་པའི་ཕྱིར་དུ་ཨེ་ཕཱ་བཅུ་ཆ་གཉིས་ཀྱི་ཕྱེ་བཟང་པོར་སྣུམ་བསྲེས་ནས། དེ་དང་མཉམ་དུ་འབུལ་བའི་སྐྱེམས་མཆོད་བཅས་འབུལ་དགོས། ");
INSERT INTO bodn_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","དེ་ནི་དུས་རྒྱུན་གྱི་སྦྱིན་སྲེག་དང་དེ་དང་མཉམ་དུ་འབུལ་བའི་སྐྱེམས་མཆོད་ཀྱི་ཕན་ཆོད་ནས་ངལ་གསོ་བའི་ཉིན་མོ་རེ་རེར་འབུལ་བའི་སྦྱིན་སྲེག་ཡིན་ནོ། ། ");
INSERT INTO bodn_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ཡང་ཟླ་རེའི་ཉིན་དང་པོར་ཁྱོད་ཅག་གིས་དཀོན་མཆོག་ཡ་ཝཱེ་ལ་སྦྱིན་སྲེག་འབུལ་དགོས་ཏེ། གླང་ཐུག་གཉིས་དང་། ལུག་ཐུག་གཅིག་དང་། སྐྱོན་མེད་པའི་ལོ་གཅིག་ཅན་གྱི་ལུ་གུ་ཕོ་བདུན་བཅས་ཡིན། ");
INSERT INTO bodn_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","འབྲུ་རིགས་ཀྱི་མཆོད་པ་ལ་གླང་ཐུག་རེའི་ཕྱིར་དུ་ཨེ་ཕཱ་བཅུ་ཆ་གསུམ་གྱི་ཕྱེ་བཟང་པོར་ས