﻿USE sofia;
DROP TABLE IF EXISTS sofia.bod_vpl;
CREATE TABLE bod_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bod_vpl WRITE;
INSERT INTO bod_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","མེས་པོ་ཨབ་ར་ཧམ་གྱི་སྲས་རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ཡེ་ཤུ་མཱ་ཤི་ཀའི་གདུང་རྒྱུད་ནི། ");
INSERT INTO bod_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ཨབ་ར་ཧམ་ནི་ཨི་སཱག་ཅེས་བྱ་བའི་ཕ་དང༌། ཨི་སཱག་ནི་ཡ་ཀོབ་ཅེས་བྱ་བའི་ཕ། ཡ་ཀོབ་ནི་ཡུ་དཱ་དང་ཁོའི་ཕུ་ནུའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ཡུ་དཱ་དང་ཁོའི་ཟླ་བོ་ཐཱ་མཱར་ནི་པེ་རེ་ཟི་དང་ཟཱ་རཱ་ཞེས་བྱ་བའི་ཕ་མ་དང༌། པེ་རེ་ཟི་ནི་ཧེ་ཟི་རོན་ཞེས་བྱ་བའི་ཕ། ཧེ་ཟི་རོན་ནི་རམ་ཞེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","རམ་ནི་ཨ་མི་ན་དབ་ཅེས་བྱ་བའི་ཕ་དང༌། ཨ་མི་ན་དབ་ནི་ནཱ་སོན་ཞེས་བྱ་བའི་ཕ། ནཱ་སོན་ནི་སལ་མོན་ཞེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","སལ་མོན་དང་ཁོའི་ཟླ་བོ་ར་ཧབ་ནི་པོ་ཨ་ཟི་ཞེས་བྱ་བའི་ཕ་མ་ཡིན། པོ་ཨ་ཟི་དང་ཁོའི་ཟླ་བོ་རུད་ནི་ཨོ་པེད་ཀྱི་ཕ་མ་ཡིན་ཞིང༌། ཨོ་པེད་ནི་ཡེ་སེ་ཞེས་བྱ་བའི་ཕ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ཡེ་སེ་ནི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་ཕ་ཡིན། དཱ་བིད་དང་ཨུ་རི་ཡཱ་ཡི་ཟླ་བོ་ནི་རྒྱལ་པོ་སོ་ལོ་མོན་གྱི་ཕ་མ་ཡིན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","སོ་ལོ་མོན་ནི་རེ་ཧབ་ཨམ་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། རེ་ཧབ་ཨམ་ནི་ཨ་བི་ཡཱ་ཞེས་བྱ་བའི་ཕ་ཡིན། ཨ་བི་ཡཱ་ནི་ཨ་སཱ་ཞེས་བྱ་བའི་ཕ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ཨ་སཱ་ནི་ཡེ་ཧོ་ཤ་ཕད་ཅེས་བྱ་བའི་ཕ། ཡེ་ཧོ་ཤ་ཕད་ནི་ཡོ་རཱམ་ཞེས་བྱ་བའི་ཕ་ཡིན་ཞིང༌། ཡོ་རཱམ་ནི་ཨུ་ཟི་ཡཱ་ཞེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ཨུ་ཟི་ཡཱ་ནི་ཡོ་ཐམ་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ཡོ་ཐམ་ནི་ཨ་ཧ་ཟི་ཞེས་བྱ་བའི་ཕ་ཡིན། ཨ་ཧ་ཟི་ནི་ཧེ་ཟེ་ཀི་ཡཱ་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ཧེ་ཟེ་ཀི་ཡཱ་ནི་མཱ་ན་ཟེ་ཞེས་བྱ་བའི་ཕ་ཡིན། མཱ་ན་ཟེ་ནི་ཨ་མོ་ཟི་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ཨ་མོ་ཟི་ནི་ཡོ་ཟི་ཡཱ་ཞེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ཡ་ཧུ་དཱ་པའི་མི་རིགས་སྦ་བི་ལོན་ཞེས་པའི་ཡུལ་ལ་རྒྱང་འབུད་གཏོང་བའི་སྐབས་སུ་ཡོ་ཟི་ཡཱ་ནི་ཡེ་ཀོ་ནི་ཡཱ་དང་ཁོའི་གཅེན་གཅུང་གི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","དེའི་རྗེས་སུ་ཡེ་ཀོ་ནི་ཡཱ་ནི་ཤེ་ཨལ་ཐི་ཨེལ་ཞེས་བྱ་བའི་ཕ་ཡིན་ཞིང༌། ཤེ་ཨལ་ཐི་ཨེལ་ནི་བཟེ་རུ་པ་པེལ་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","བཟེ་རུ་པ་པེལ་ནི་ཨ་སྦི་ཧུད་ཅེས་བྱ་བའི་ཕ། ཨ་སྦི་ཧུད་ནི་ཨེལ་ཡ་ཀིམ་ཞེས་བྱ་བའི་ཕ་ཡིན། ཨེལ་ཡ་ཀིམ་ནི་ཨ་ཟོར་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ཨ་ཟོར་ནི་ཟཱ་དོག་ཅེས་བྱ་བའི་ཕ་ཡིན། ཟཱ་དོག་ནི་ཨ་ཀིམ་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། ཨ་ཀིམ་ནི་ཨེ་ལི་ཧུད་ཅེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ཨེ་ལི་ཧུད་ནི་ཨེ་ལི་ཨ་ཟར་ཞེས་བྱ་བའི་ཕ་ཡིན་ཞིང༌། ཨེ་ལི་ཨ་ཟར་ནི་མཱ་ཐན་ཞེས་བྱ་བའི་ཕ་ཡིན་པ་དང༌། མཱ་ཐན་ནི་ཡ་ཀོབ་ཅེས་བྱ་བའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ཡ་ཀོབ་ནི་མིར་ཡམ་གྱི་ཟླ་བོ་ཡོ་སེབ་ཀྱི་ཕ་ཡིན་ཞིང༌། མིར་ཡམ་ནི་མཱ་ཤི་ཀ་ཞེས་ཟེར་བའི་ཡེ་ཤུའི་ཡུམ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","དེ་བས་ན་མེས་པོ་ཨབ་ར་ཧམ་ནས་རྒྱལ་པོ་དཱ་བིད་བར་དུ་མི་རབས་བཅུ་བཞི་ཡིན་ཞིང༌། རྒྱལ་པོ་དཱ་བིད་ནས་ཡ་ཧུ་དཱ་པའི་མི་རིགས་སྦ་བི་ལོན་ཡུལ་ལ་རྒྱང་འབུད་བཏང་བའི་བར་དུ་མི་རབས་བཅུ་བཞི་ཡིན། དུས་དེ་ནས་མཱ་ཤི་ཀ་འཁྲུང་བའི་བར་དུ་མི་རབས་བཅུ་བཞི་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ཡེ་ཤུ་མཱ་ཤི་ཀ་འཁྲུངས་པའི་ལོ་རྒྱུས་འདི་ལྟར་ཡིན་ཏེ། ཁོང་གི་ཡུམ་མིར་ཡམ་དང་ཡོ་སེབ་གཉེན་སྒྲིག་བྱེད་རྒྱུའི་ཐག་བཅད་ཟིན་ཡང༌། ཁོ་གཉིས་མཉམ་དུ་མ་འདུས་པའི་གོང་དུ་མིར་ཡམ་གྱིས་རང་ཉིད་ལ་དམ་པའི་ཐུགས་ཉིད་ཀྱི་ནུས་མཐུ་ཡིས་མངལ་དང་ལྡན་པར་གྱུར་བར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","རང་གི་ཁྱོ་བོ་ཡོ་སེབ་ནི་མི་དྲང་ལྡན་ཞིག་ཡིན་པས། ཁོང་གིས་མིར་ཡམ་ལ་མིང་གྲགས་ངན་པ་བཟོ་མ་འདོད་པར་ཁ་ཁུ་སིམ་མེས་ལྐོག་ཏུ་ཁ་འབྲལ་བར་ཐག་གཅོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","དེ་ལྟར་བསམ་བཞིན་པའི་སྐབས། གཙོ་བོའི་ཕོ་ཉ་ཞིག་གིས་ཁོང་གི་རྨི་ལམ་ནང་མངོན་པར་གྱུར་ཏེ་“ཀྱེ་དཱ་བིད་ཀྱི་བུ་ཡོ་སེབ། མིར་ཡམ་རང་གི་ཟླ་བོར་ལེན་རྒྱུར་མ་འཇིགས་ཤིག ཁོ་མོའི་ལྷུམས་སུ་བཞུགས་པ་ནི་དམ་པའི་ཐུགས་ཉིད་ལས་ཆགས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ཁོ་མོ་ལ་སྲས་ཤིག་འཁྲུང་ཡོང༌། ཁྱེད་ཀྱིས་དེ་ལ་ཡེ་ཤུ་ཞེས་པའི་མཚན་གསོལ་དགོས། གང་ཡིན་ཟེར་ན། ཁོང་གིས་རང་གི་མི་རྣམས་ཁོ་ཚོའི་སྡིག་ཉེས་ལས་ཐར་བར་མཛད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","དེ་ཐམས་ཅད་ནི་གཙོ་བོས་ལུང་སྟོན་པ་བརྒྱུད་ནས་གསུངས་པ་དེ་སྒྲུབ་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","འདི་ལྟར་ཏེ། ལྟོས་དང་ན་ཆུང་མངལ་བཅས་སྲས་ཤིག་འོང༌། ། མཚན་ཡང་ཨིམ་མ་ནུ་ཨེལ་ཞེས་སུ་གསོལ། ། ཞེས་འཁོད་ཡོད། ཨིམ་མ་ནུ་ཨེལ་ནི་དཀོན་མཆོག་དང་ང་ཚོ་མཉམ་དུ་གནས་ཞེས་པའི་དོན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ཡོ་སེབ་གཉིད་ལས་སད་རྗེས་གཙོ་བོའི་ཕོ་ཉས་གནང་བའི་བཀའ་བཞིན་དུ་མིར་ཡམ་རང་གི་ཟླ་བོར་བླངས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","སྲས་མ་འཁྲུངས་པའི་བར་དུ་མིར་ཡམ་དང་མཉམ་དུ་མ་འདུས། སྲས་དེའི་མཚན་ལ་ཡེ་ཤུ་ཞེས་བཏགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","རྒྱལ་པོ་ཧེ་རོ་དཱེའི་དུས་སྐབས་སུ་ཡ་ཧུ་དཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་བེད་ལེ་ཧེམ་དུ་ཡེ་ཤུ་འཁྲུངས་པའི་རྗེས། ཤར་ཕྱོགས་ནས་ཡིན་པའི་སྐར་རྩིས་མཁས་ཅན་འགའ་ཤས་རྒྱལ་ས་ཡེ་རུ་ཤ་ལེམ་དུ་ཡོང་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒྱལ་པོ་འཁྲུངས་པ་དེ་གང་དུ་བཞུགས། ཁོང་གི་སྐར་མ་ཤར་དུས་ང་ཚོས་མཐོང་སྟེ་ཁོང་ལ་བཀུར་སྟི་ཞུ་བར་འོངས་པ་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡིས་དེ་ཐོས་ནས་སེམས་འཁྲུགས་པར་གྱུར་བ་དང་ཡེ་རུ་ཤ་ལེམ་གྱི་མི་ཐམས་ཅད་ཀྱང་སེམས་འཁྲུགས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཐམས་ཅད་བསྐོངས་ནས། མཱ་ཤི་ཀ་ནི་གང་དུ་འཁྲུང་བར་འགྱུར་ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ཁོ་ཚོས་“ཡ་ཧུ་དཱ་ཡུལ་གྱི་བེད་ལེ་ཧེམ་དུ་འཁྲུངས་ཡོང༌། རྒྱུ་མཚན་ནི་ལུང་སྟོན་པས་བཀོད་པ་ལྟར། ");
INSERT INTO bod_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ཡ་ཧུ་དཱ་ཡི་བེད་ལེ་ཧེམ་མི་རྣམས། ། ཁྱེད་ཚོ་དཔོན་ལས་ཆུང་བ་མ་ཡིན་ཏེ། ། ཁྱེད་ཚོའི་ནང་ནས་དབང་སྒྱུར་མཁན་ཞིག་འོང༌། ། དབང་སྒྱུར་མཁན་དེས་ང་ཡི་མི་རིགས་ཏེ། ། ཡི་སི་ར་ཨེལ་པ་ཡི་རྫི་བོར་འགྱུར། ། ཞེས་འཁོད་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","དེ་ནས་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡིས་སྐར་རྩིས་མཁས་ཅན་དེ་རྣམས་ལྐོག་ཏུ་བོས་ནས། སྐར་མ་དེ་ཤར་བའི་ནམ་དུས་ཞིབ་ཏུ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ཁོ་ཚོ་བེད་ལེ་ཧེམ་དུ་བཏང་སྟེ་རྒྱལ་པོས་“ད་ཁྱེད་ཚོ་སོང་ལ་ཕྲུ་གུ་ཆུང་ངུ་དེའི་སྐོར་ཞིབ་ཕྲ་རྩད་གཅོད་གྱིས་ཤིག ང་ཡང་ཁོ་ལ་བཀུར་བསྟི་ཞུ་བར་ཡོང་བའི་ཕྱིར་ཁོ་བརྙེད་ན་ང་ལ་འཕྲིན་གཏོང་”ཞེས་བརྗོད། ");
INSERT INTO bod_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","རྒྱལ་པོའི་བཀའ་ཐོས་ནས་ཁོ་རྣམས་སོང་ཞིང༌། ཤར་སྐབས་སུ་མཐོང་བའི་སྐར་མ་དེ་ཁོ་ཚོའི་སྔོན་དུ་རྒྱུ་སྟེ་ཕྲུ་གུ་ཆུང་ངུ་དེ་བཞུགས་སའི་མཚམས་སུ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ཁོ་ཚོས་སྐར་མ་དེ་མཐོང་བས་དགའ་སྤྲོ་རབ་ཏུ་འཕེལ། ");
INSERT INTO bod_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ཁང་པའི་ནང་དུ་འཛུལ་ནས་ཕྲུ་གུ་ཆུང་ངུ་དེ་དང་དེའི་ཡུམ་མིར་ཡམ་མཇལ་ཏེ་པུས་མོ་སར་བཙུགས་ནས་ཡེ་ཤུར་བསྙེན་བཀུར་ཞུས་ཤིང༌། རྟེན་སྒམ་ཁ་ཕྱེ་སྟེ་གསེར་དང༌། སྤོས་དཀར། དྲི་ཞིམ་བྱུགས་རྫས་རྣམས་ཀྱི་ལེགས་སྐྱེས་ཁོང་ལ་ཕུལ་ལོ། ");
INSERT INTO bod_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","དེ་རྣམས་རྨི་ལམ་ནང་ནས་རྒྱལ་པོ་ཧེ་རོ་དཱེའི་དྲུང་དུ་མ་ལོག་པའི་ཉེན་བརྡ་བྱུང་བ་བཞིན་དུ་ལམ་གཞན་ཞིག་བརྒྱུད་ནས་རང་ཡུལ་དུ་ལོག ");
INSERT INTO bod_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ཁོ་རྣམས་སོང་བའི་རྗེས་སུ་གཙོ་བོའི་ཕོ་ཉ་ཞིག་ཡོ་སེབ་ཀྱི་རྨི་ལམ་ནང་ལ་མངོན་པར་གྱུར་ནས་ཁོང་ལ་“རྒྱལ་པོ་ཧེ་རོ་དཱེས་ཕྲུ་གུ་དེ་གསོད་པའི་ཕྱིར་འཚོལ་གྲབས་འདུག་པས། ལོངས་ལ་ཕྲུ་གུ་དེ་དང་ཁོང་གི་མ་འཁྲིད་དེ་ཨེ་ཇེབ་ཡུལ་ལ་འབྲོས་ཏེ། ངས་ཁྱོད་ལ་བཀའ་མ་བཏང་བའི་བར་དུ་ཡུལ་དེར་སྡོད་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","དེའི་ཕྱིར་ཡོ་སེབ་ལངས་ནས་མཚན་མོར་ཕྲུ་གུ་དང་ཁོང་གི་ཡུམ་འཁྲིད་དེ་ཨེ་ཇེབ་ཡུལ་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","གཙོ་བོས་ལུང་སྟོན་པ་བརྒྱུད་ནས་ཨེ་ཇེབ་ཡུལ་ནས་ངའི་སྲས་བོས་པ་ཡིན་ཞེས་གསུངས་པ་དེ་སྒྲུབ་པའི་ཕྱིར། རྒྱལ་པོ་ཧེ་རོ་དཱེ་མ་ཤི་བའི་བར་དུ་ཁོང་རྣམས་ཡུལ་དེར་གནས། ");
INSERT INTO bod_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","དེ་ནས་སྐར་རྩིས་མཁས་ཅན་རྣམས་ཀྱིས་ཁོ་ལ་མགོ་སྐོར་བཏང་བ་ཧེ་རོ་དཱེ་ཡིས་ཤེས་ནས་ཤིན་ཏུ་ཁྲོས། སྐར་རྩིས་པས་ཁོ་ལ་སྨྲས་པའི་ཚེས་གྲངས་ལ་བརྟེན་ནས་དམག་མི་བཏང་ཞིང༌། བེད་ལེ་ཧེམ་དང་མཐའ་སྐོར་གྱི་ས་ཆར་ཡོད་པའི་ལོ་གཉིས་དང་དེ་ལས་ཆུང་བའི་བུ་ཐམས་ཅད་བསད། ");
INSERT INTO bod_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","དེ་ནས་ལུང་སྟོན་པ་ཡེ་རེམ་ཡཱ་ཡིས། ");
INSERT INTO bod_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ར་མཱའི་གྲོང་དུ་མི་རྣམས་ལ། ། སྒྲ་ཞིག་ཐོས་པ་གང་དེ་ནི། ། བུ་ཕྲུག་ཆེད་དུ་རཱ་ཧེལ་གྱིས། ། སྨྲེ་སྔགས་འདོན་པའི་སྒྲ་ཡིན་ནོ། ། གཞན་གྱི་སེམས་གསོ་དགོས་འདོད་མེད། ། ཁོང་གི་ཕྲུ་གུ་འདས་པས་སོ། ། ཞེས་གསུངས་པ་དེ་བསྒྲུབས། ");
INSERT INTO bod_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ཧེ་རོ་དཱེ་ཤི་བའི་རྗེས་སུ་ཨེ་ཇེབ་ཡུལ་ལ་ཡོ་སེབ་ཀྱི་རྨི་ལམ་ནང་གཙོ་བོའི་ཕོ་ཉ་ཞིག་མངོན་པར་གྱུར་ནས། ");
INSERT INTO bod_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ཕྲུ་གུ་དེ་གསོད་འདོད་མཁན་རྣམས་ཤི་བས། ལོངས་ལ་ཁོང་དང་ཁོང་གི་མ་འཁྲིད་དེ་ཡི་སི་ར་ཨེལ་ཡུལ་ལ་སོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","དེའི་ཕྱིར་ཡོ་སེབ་ལངས་ནས་ཕྲུ་གུ་དང་ཁོང་གི་ཡུམ་འཁྲིད་དེ་ཡི་སི་ར་ཨེལ་ཡུལ་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","འོན་ཀྱང་རྒྱལ་པོ་ཧེ་རོ་དཱེའི་ཤུལ་དུ་ཁོའི་བུ་ཨར་ཀེ་ལཱ་ཡིས་ཡ་ཧུ་དཱ་ཡུལ་དུ་དབང་སྒྱུར་བྱེད་པར་ཐོས་པས། ཡོ་སེབ་དེར་འགྲོ་བར་འཇིགས་ཤིང༌། ཡང་བསྐྱར་རྨི་ལམ་དུ་ཉེན་བརྡ་བྱུང་ནས་ག་ལིལ་ཡུལ་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","གྲོང་ཁྱེར་ན་ཙ་རེལ་ཞེས་བྱ་བ་ཞིག་ཏུ་སླེབས་ཏེ་དེར་བཞུགས། དེ་ནི་ལུང་སྟོན་པ་རྣམས་བརྒྱུད་ནས་ཁོང་ལ་ན་ཙ་རེལ་པ་ཞིག་ཞུ་བར་འགྱུར་ཞེས་གསུངས་པ་དེ་སྒྲུབ་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","དེའི་དུས་སུ་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་ཡ་ཧུ་དཱ་ཡུལ་གྱི་དབེན་སྟོང་ལ་ཕེབས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཉེ་བར་འོངས་པས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་སྒྱུར་ཞིག་”ཅེས་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས། དབེན་སྟོང་ཡུལ་ནང་གྲགས་པའི་འབོད་སྒྲ་ཡིས། ། གཙོ་བོའི་ཆེད་དུ་ཕེབས་ལམ་གྲ་སྒྲིག་བྱོས། ། ལམ་བུ་དེ་ནི་བདེ་བར་བཟོས་ཤིག་ཨང༌། ། ཞེས་གསུངས་པ་འདི་ནི་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་སྐོར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ཡོ་ཧ་ནན་གྱིས་རྔ་མོང་གི་སྤུ་ཡི་གོས་གྱོན་པ་དང་རྐེད་པ་ལ་ཀོ་བའི་སྐེ་རགས་བཅིངས་ཤིང༌། ཟས་ལ་འབུ་ཆ་ག་པ་དང་ཤིང་ནགས་ཀྱི་སྦྲང་རྩི་བཟས། ");
INSERT INTO bod_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དང༌། ཡ་ཧུ་དཱ་ཡུལ། ཡོར་དན་གཙང་པོའི་མཐའ་སྐོར་གྱི་ཡུལ་ལ་བཞུགས་མཁན་ཤིན་ཏུ་མང་པོ་ཁོང་གི་དྲུང་དུ་འགྲོ་བཞིན་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ཁོ་ཚོས་རང་གི་སྡིག་ཉེས་ཁས་བླངས་ཏེ་ཁོང་གིས་ཁོ་ཚོར་ཡོར་དན་གཙང་པོར་ཁྲུས་གསོལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ཕཱ་རུ་ཤི་དང་སཱ་ཅུ་སེ་ཞེས་ཟེར་བའི་ཕྱོགས་རིས་ལ་གཏོགས་པའི་མི་མང་པོ་ཁྲུས་གསོལ་ལེན་པའི་ཕྱིར་ཁོང་གི་དྲུང་དུ་འོང་བར་མཐོང་ནས་ཁོང་གིས་ཁོ་ཚོར་“དུག་སྦྲུལ་གྱི་རིགས་ཁྱོད་ཚོ། སྡིག་པའི་ཉེས་ཆད་ཡིན་ཏེ་མ་འོངས་པའི་ཐུགས་ཁྲོ་ལས་འབྲོས་པ་ཁྱོད་ཚོར་སུས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་འབྲས་བུ་ལེགས་པ་སྐྱེད་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ཡང་ཨབ་ར་ཧམ་ང་ཚོའི་མེས་པོ་ཡིན་ཞེས་མ་སོམས། ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། དཀོན་མཆོག་གིས་རྡོ་འདི་ཚོ་ལས་ཀྱང་ཨབ་ར་ཧམ་ལ་བུ་རྒྱུད་འབྱུང་བར་མཛད་ཐུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ད་ལྟ་སྟ་རེ་ཞིག་ཤིང་སྡོང་གི་རྩ་ལ་བཞག་ཡོད་པས་འབྲས་བུ་བཟང་པོ་མི་སྐྱེས་པའི་ཤིང་སྡོང་རེ་རེ་བཞིན་བཅད་ནས་མེ་ལ་གཡུག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ཁྱོད་ཀྱིས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་ཕྱིར་ངས་ནི་ཆུ་ཡིས་ཁྲུས་གསོལ་བྱེད། འོན་ཀྱང་ངའི་རྗེས་ལ་ང་ལས་དབང་ཆེ་བ་ཞིག་ཕེབས་ཡོང་བར་ངེས་ཏེ། ངས་ཁོང་གི་ཞབས་ལྷམ་ཡང་འཁྱེར་བར་མི་འོས། ཁོང་གིས་ཁྱོད་ཚོར་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་དང་མེ་ཡི་ཐོག་ནས་ཁྲུས་གསོལ་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ཁོང་གི་གཡུལ་ཁ་ལེགས་པོར་གཙང་མ་བཟོ་བའི་ཆེད་དང༌། མཛོད་ཁང་ལ་གྲོ་སྡུད་པའི་ཕྱིར་སྦར་མོ་ཕྱག་ལ་ཡོད། འོན་ཀྱང་རྩྭ་རྣམས་ཁོང་གིས་གསོད་མི་སྲིད་པའི་མེ་ཡིས་སྲེག་པར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","དེ་ནས་ཡེ་ཤུ་ཁྲུས་གསོལ་འཐོབ་བའི་ཕྱིར་ག་ལིལ་ཡུལ་ནས་ཡོར་དན་གཙང་པོའི་འགྲམ་ལ་ཡོ་ཧ་ནན་གྱི་དྲུང་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ཡོ་ཧ་ནན་གྱིས་ཁོང་འགོག་པར་འདོད་དེ་“ང་ལ་ཁྱེད་ཀྱིས་ཁྲུས་གསོལ་གནང་བའི་དགོས་པ་ཡོད་ཀྱི། ཁྱེད་ངའི་རྩར་ཕེབས་སམ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ཡེ་ཤུས་ཁོང་ལ་“འདི་ལྟར་ངེད་རྣམས་ཀྱིས་དཀོན་མཆོག་གི་བཀའ་ཐམས་ཅད་སྒྲུབ་དགོས་པས་ད་ལྟ་འདི་ལྟར་བྱེད་དུ་ཆུག་”ཅེས་གསུངས་པ་ན། ཡོ་ཧ་ནན་གྱིས་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ཡེ་ཤུས་ཁྲུས་གསོལ་བཞེས་ཏེ་ཆུ་ནས་ཡར་བཞེངས་མ་ཐག ནམ་མཁའ་ཕྱེ་སྟེ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཕུག་རོན་ལྟར་རང་གི་སྟེང་ལ་བབས་པ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ཡང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་“འདི་ནི་ངའི་གཅེས་པའི་སྲས་ཡིན་ཞིང་ང་རང་ཁོང་ལ་ཤིན་ཏུ་དགའོ་”ཞེས་པའི་གསུང་སྐད་ཅིག་བྱུང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","དེ་ནས་བདུད་སཱ་ཏན་གྱིས་ཁོང་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཡེ་ཤུ་དབེན་སྟོང་ལ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ཉིན་མཚན་བཞི་བཅུའི་རིང་ཁོང་གིས་ཞལ་ཟས་ཅི་ཡང་མ་བཞེས་པས་བཀྲེས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ཉམས་ཚོད་ལེན་མཁན་ཁོང་གི་དྲུང་དུ་ཡོང་ནས་ཁོང་ལ་“ཁྱེད་རང་དཀོན་མཆོག་གི་སྲས་ཡིན་ན་རྡོ་འདི་བག་ལེབ་ཏུ་འགྱུར་བའི་བཀའ་གཏོང་ཞིག་”ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ལན་དུ་ཁོང་གིས་“གསུང་རབ་ནང་མི་ནི་བག་ལེབ་ཁོ་ནས་མ་ཡིན་ཏེ་དཀོན་མཆོག་གི་ཞལ་ནས་འབྱུང་བའི་བཀའ་རེ་རེར་བརྟེན་ནས་འཚོ་བར་འགྱུར་ཞེས་བྲིས་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","དེ་ནས་བདུད་ཀྱིས་གནས་མཆོག་ཡེ་རུ་ཤ་ལེམ་དུ་ཁྲིད་དེ་མཆོད་ཁང་ཆེན་མོའི་རྩེ་མོར་ལང་དུ་བཅུག་ནས་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“གལ་ཏེ་ཁྱེད་རང་དཀོན་མཆོག་གི་སྲས་ཡིན་ན་མར་མཆོངས་ཤིག གང་ལགས་ཟེར་ན། གསུང་རབ་ཀྱི་མདོ་ལས། ཁོང་གིས་ཁྱེད་ཕྱིར་ཕོ་ཉ་རྣམས་ལ་ནི། ། ཁྱེད་ཉིད་སྐྱོབ་པའི་བཀའ་ཡང་གནང་བར་འགྱུར། ། རྡོ་ལ་ཁྱེད་ཀྱི་ཞབས་ནི་མི་ཕོག་ཕྱིར། ། དེ་ཚོའི་ལག་པས་ཁྱེད་ནི་འདེགས་པར་འགྱུར། ། ཅེས་བྲིས་འདུག་”ཅེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ལན་དུ་ཡེ་ཤུས་“གཙོ་བོ་ཁྱེད་ཀྱི་དཀོན་མཆོག་ལ་ཉམས་ཚོད་མ་བྱོས་ཤིག་ཅེས་བྲིས་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","དེ་ནས་བདུད་ཀྱིས་ཁོང་རི་ཤིན་ཏུ་མཐོ་པོ་ཞིག་ལ་ཡར་ཁྲིད་ནས་འཇིག་རྟེན་གྱི་རྒྱལ་ཁམས་ཚང་མ་དང་དེའི་དཔལ་བསྟན་ནས་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ང་ལ་ཕྱག་འཚལ་ན་འདི་ཚོ་ཐམས་ཅད་ཁྱེད་ལ་འབུལ་བར་བྱའོ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ཡེ་ཤུས་ཁོ་ལ་“སཱ་ཏན། ཕར་རྒྱུགས་ཤིག གསུང་རབ་ནང་ཁྱེད་ཀྱིས་རང་གི་གཙོ་བོ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུ་བ་དང་ཁོང་ཁོ་ནར་ཞབས་ཕྱི་བྱེད་དགོས་ཞེས་བྲིས་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","དེ་ནས་བདུད་དེ་ཁོང་དང་བྲལ་ནས་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་ཡོང་ཞིང་ཁོང་ལ་ཞབས་ཕྱི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ཡེ་ཤུས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་འཛིན་བཟུང་བྱས་པའི་གཏམ་གསན་ནས་ག་ལིལ་ཡུལ་དུ་ཕེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ན་ཙ་རེལ་གྲོང་སྡེ་དང་བྲལ་ནས་ཟ་བུ་ལུན་དང་ནབ་ཐ་ལིའི་ཡུལ་གྱི་མཚོ་འགྲམ་དུ་ཡོད་པའི་ཀ་ཕར་ན་ཧུམ་གྲོང་ཁྱེར་དུ་གཞིས་ཆགས། ");
INSERT INTO bod_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","དེ་ལྟར་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས། ");
INSERT INTO bod_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ཟ་བུ་ལུན་དང་ནབ་ཐ་ལི་ཡུལ་གཉིས། ། མཚོ་འགྲམ་དང་ནི་ཡོར་དན་ཕ་རོལ་ན། ། ཕྱི་པ་གནས་པའི་ག་ལིལ་ཡུལ་དེ་ལ། ། ");
INSERT INTO bod_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","མུན་པའི་ཁྲོད་དུ་གོམ་བགྲོད་བྱེད་བཞིན་པའི། ། མི་རྣམས་ཀྱིས་ནི་འོད་ཆེན་ཞིག་མཐོང་ཞིང༌། ། སྨག་རུམ་མུན་པའི་ཁྲོད་དུ་གནས་པ་ཡི། ། མི་རྣམས་ལ་ནི་འོད་ཟེར་འཕྲོས་པར་གྱུར། ། ཞེས་གསུངས་པ་སྒྲུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","དེ་ནས་བཟུང་ཡེ་ཤུས་ཆོས་བསྟན་འགོ་ཚུགས་གནང་སྟེ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འཐོན་ལ་ཉེ་བར་སླེབས་པས། ཁྱེད་ཚོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","དེ་ནས་ཡེ་ཤུ་ག་ལིལ་ཡུལ་གྱི་མཚོ་འགྲམ་བརྒྱུད་ནས་ཕེབས་དུས། སི་མོན་ཞེས་ཟེར་བའི་པེ་ཏྲོ་དང་ཁོང་གི་གཅུང་པོ་ཨན་དྲི་ཡཱ་ཞེས་བྱ་བའི་ཉ་པ་གཉིས་ཀྱིས་མཚོ་ནང་དུ་དྲ་རྒྱ་འཕེན་བཞིན་པ་གཟིགས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ཁོང་གིས་ཁོ་ཚོ་ལ་“ངའི་རྗེས་སུ་ཤོག ཁྱེད་ཀྱིས་ད་ལྟ་ཉ་འཚོལ་བ་ལྟར་རྗེས་མ་ངས་ཁྱེད་ཚོ་མི་རྣམས་འཚོལ་དུ་འཇུག་”ཅེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ཁོ་གཉིས་ཀྱིས་རང་གི་དྲ་རྒྱ་སྤངས་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ཡེ་ཤུ་ཕར་ཙམ་ཕེབས་སྐབས། ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་ཞེས་ཟེར་བའི་སྤུན་གཞན་གཉིས་ཁོ་ཚོའི་ཕ་ཟེ་བད་ཡཱ་དང་མཉམ་དུ་གྲུའི་ནང་ལ་དྲ་རྒྱ་བཟོ་བཅོས་རྒྱག་བཞིན་པ་གཟིགས་ནས། དེ་གཉིས་བོས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","དེ་མ་ཐག་ཏུ་ཁོ་གཉིས་གྲུ་དང་ཕ་བཞག་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ག་ལིལ་ཡུལ་ཡོངས་བརྒྱུད་ནས་ཕེབས་ཏེ་ཡེ་ཤུས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་དུ་ཆོས་གསུངས་ཏེ། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་བསྒྲགས་པ་དང༌། མི་རྣམས་ཀྱི་ནད་རིགས་ཀུན་སེལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ཁོང་གི་སྙན་གྲགས་སི་རི་ཡཱ་ཡུལ་ཀུན་ཏུ་ཁྱབ། མི་རྣམས་ཀྱིས་ནད་དང་ན་ཟུག་སྣ་ཚོགས་ཀྱིས་བཏབ་པ་ཐམས་ཅད་དང༌། གདོན་འདྲེས་བཟུང་བའི་མི་དང༌། གཟའ་ཕོག་པ། གོམ་པ་སྤོ་མི་ཐུབ་པ་ལ་སོགས་པའི་མི་རྣམས་ཁོང་གི་མདུན་དུ་ཁྲིད་པ་དང་ཁོང་གིས་དེ་ཚོ་སེལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ག་ལིལ་ཡུལ་དང༌། དེ་ཁ་པོ་ལེ་ཞེས་བྱ་བའི་ཡུལ། རྒྱལ་ས་ཡེ་རུ་ཤ་ལེམ་དང༌། ཡ་ཧུ་དཱ་ཡུལ། ཡོར་དན་གཙང་པོའི་ཕ་རོལ་ནས་འོངས་པའི་མི་ཚོགས་མང་པོ་ཞིག་ཁོང་གི་རྗེས་སུ་འབྲངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","མི་ཚོགས་གཟིགས་ནས་ཡེ་ཤུ་རི་ཞིག་གི་སྟེང་ལ་ཡར་ཕེབས་ཏེ། དེར་བཞུགས་པ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་སྐུ་མདུན་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ཡང་ཁོང་གིས་ཁོ་རྣམས་ལ་ཆོས་བསྟན་ཏེ་གསུངས་པ། ");
INSERT INTO bod_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“སེམས་རྒྱུད་དབུལ་རྣམས་བདེ་བ་དང་ལྡན་ཏེ། ། དཀོན་མཆོག་རྒྱལ་སྲིད་ཁོང་ཚོའི་ཡིན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","མྱ་ངན་ཅན་རྣམས་བདེ་བ་དང་ལྡན་ཏེ། ། ཁོ་ཚོར་སེམས་གསོ་འཐོབ་ངེས་ཡིན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","སྙེམས་ཆུང་བ་རྣམས་བདེ་བ་དང་ལྡན་ཏེ། ། ཁོ་ཚོ་ས་གཞིའི་བདག་པོར་འགྱུར་བས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","བཀྲེས་སྐོམ་ཅན་གྱི་དྲང་བདེན་མི་དེ་རྣམས། ། བདེ་བ་ཡིན་ཏེ་བློ་ཡིད་ཚིམ་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","སྙིང་རྗེ་ཅན་གྱི་མི་རྣམས་བདེ་བ་སྟེ། ། ཁོ་ཚོར་སྙིང་རྗེ་ངེས་པར་འཐོབ་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ལྷད་མེད་སེམས་བཟང་ཅན་དག་བདེ་བ་སྟེ། ། ཁོ་ཚོས་དཀོན་མཆོག་མཇལ་བར་འགྱུར་བས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","འདུམ་སྒྲིག་མཁན་རྣམས་བདེ་བ་དང་ལྡན་ཏེ། ། ཁོ་ཚོར་དཀོན་མཆོག་སྲས་ཞེས་འབོད་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","དྲང་བདེན་ཉིད་ཕྱིར་འཚེ་བ་ཕོག་པ་རྣམས། ། དཀོན་མཆོག་རྒྱལ་སྲིད་ཁོ་ཚོའི་ཡིན་པས་བདེའོ། ། ");
INSERT INTO bod_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ངའི་དོན་དུ་མི་རྣམས་ཀྱིས་ཁྱེད་ཚོར་དམའ་བེབས་གཏོང་ཞིང༌། གནོད་སྐྱེལ་བ་དང༌། རྫུན་ཤོད་དེ་ཚིག་ངན་སྣ་ཚོགས་སྨྲ་བའི་སྐབས་སུ་ཁྱེད་རྣམས་བདེ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཁྱེད་ལ་བྱ་དགའ་ཆེན་པོ་ཡོད་པས་དགའ་བ་སྐྱེད་པར་གྱུར་ཅིག གང་ཡིན་ཟེར་ན། ཁྱེད་ཚོའི་སྔོན་ལ་ཡོད་པའི་ལུང་སྟོན་པ་ལའང་དེ་ལྟར་གནོད་བསྐྱལ་བ་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ཁྱེད་རྣམས་འཇིག་རྟེན་གྱི་ཚྭ་ཡིན། འོན་ཀྱང་ཚྭའི་བྲོ་བ་ཡལ་ན། དེའི་བྲོ་བ་སླར་གང་གིས་གསོ་བར་བྱེད་དམ། དེ་ཕན་མེད་དུ་གྱུར་བས་ཕྱི་ལ་གཡུགས་ནས་མིའི་རྐང་པས་རྫི་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ཁྱེད་ཚོ་ནི་འཇིག་རྟེན་གྱི་འོད་ཡིན། རི་སྟེང་དུ་ཆགས་པའི་གྲོང་ཁྱེར་བཀབ་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","མི་སུས་ཀྱང་སྒྲོན་མེ་ཞིག་སྤར་ནས་བྲེའི་འོག་ཏུ་མི་འཇོག སྟེགས་བུའི་སྟེང་དུ་བཞག་ནས་ཁང་པའི་ནང་གི་མི་ཐམས་ཅད་ལ་འོད་སྤྲོ། ");
INSERT INTO bod_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","དེ་ལྟར་ཁྱེད་ཚོའི་འོད་ཀྱང་མི་རྣམས་ཀྱི་མདུན་དུ་འོད་སྤྲོ་བར་འཇུག་དགོས། དེ་ནས་ཁྱེད་ཚོས་བྱེད་པའི་བྱ་བ་བཟང་པོ་ཁོ་ཚོས་མཐོང་ནས་ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ལ་བསྟོད་བསྔགས་བྱེད་པར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ང་ཡོང་བ་ནི་ཆོས་ཁྲིམས་སམ་ལུང་སྟོན་པའི་བསྟན་པ་མེད་པར་བྱེད་པར་མ་སོམས་ཤིག ང་མེད་པར་བྱེད་དུ་མིན་ཏེ་དེ་ཚོ་སྒྲུབ་པའི་ཆེད་དུ་ཡོང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། གནམ་ས་གཉིས་མ་འདའ་བའི་བར་དུ་ཆོས་ཁྲིམས་ཀྱི་ཚེག་གམ་ཡིག་འབྲུ་གཅིག་ཀྱང་མེད་པར་མི་འགྱུར་གྱི། ཐམས་ཅད་འགྲུབ་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","དེའི་ཕྱིར་མི་སུ་འདྲ་ཞིག་གིས་བཀའ་ཁྲིམས་འདི་རྣམས་ལས་ཆུང་ཤོས་ཤིག་དང༌། ཡང་འགལ་ནས་མི་གཞན་རྣམས་ལའང་དེ་ལྟར་བྱེད་པར་སློབ་མཁན་ནི་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་དུ་ཆུང་ཤོས་ཟེར་བར་འགྱུར། འོན་ཀྱང་བཀའ་ཁྲིམས་དེ་ཚོ་སྲུང་ཞིང་སློབ་མཁན་ནི་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་དུ་ཆེན་པོ་ཟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། གལ་ཏེ་ཁྱེད་ཚོས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་རྣམས་ལས་དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལེགས་པར་མ་ཉན་ན། ཁྱེད་ཚོ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འཛུལ་བར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","གནའ་བོའི་དུས་ཀྱི་མི་རྣམས་ལ་མིའི་སྲོག་མ་གཅོད་ཅིག་ཅེས་དང༌། མིའི་སྲོག་གཅོད་མཁན་ལ་ཁྲིམས་གཅོད་འཕོག་ཉེན་ཡོད་ཅེས་གསུངས་པ་ཁྱེད་རྣམས་ཀྱིས་ཐོས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། མི་སུས་ཀྱང་རང་གི་སྤུན་ཟླ་ལ་ཁྲོ་མཁན་དེ་རྣམས་ལ་ཡང་ཁྲིམས་གཅོད་འཕོག་ཉེན་ཡོད་ཅིང༌། རང་གི་སྤུན་ཟླ་ལ་ཁ་ངན་ཤོད་མཁན་ལ་རྒྱལ་ཚོགས་ཀྱི་མདུན་དུ་ཁྲིམས་གཅོད་འཕོག་ཉེན་ཡོད། གཞན་ལ་བླུན་པོ་ཁྱོད་ཅེས་ཟེར་མཁན་རྣམས་ལ་མེ་དང་ལྡན་པའི་དམྱལ་ཁམས་ལ་འགྲོ་ཉེན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","དེའི་ཕྱིར་མཆོད་ཁྲིའི་མདུན་དུ་མཆོད་པ་ཞིག་ཕུལ་བའི་སྐབས་སུ་དེར་ཁྱེད་ཀྱི་སྤུན་ཟླ་ཁྱེད་དང་མ་མཐུན་པ་ཞིག་ཡོད་པར་དྲན་ན། ");
INSERT INTO bod_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ཁྱེད་ཀྱི་མཆོད་པ་དེ་མཆོད་ཁྲིའི་མདུན་དུ་བཞག་ནས་སོང་ལ། སྔོན་དུ་ཁྱེད་ཀྱི་སྤུན་ཟླ་དང་སྡུམ་པར་གྱུར་ཅིག དེ་ནས་ཤོག་ལ་ཁྱེད་ཀྱི་མཆོད་པ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ཁྱེད་དང་ཁྱེད་ཀྱི་ཁ་གཏད་གཉིས་ཁྲིམས་རར་འགྲོ་དུས་ལམ་བར་དུ་ཁོ་དང་མགྱོགས་པོར་མཐུན་འགྲིག་བྱོས་ཤིག དེ་མིན་ན་ཁ་གཏད་དེས་ཁྱོད་ཁྲིམས་དཔོན་ལ་གཏོད་པ་དང༌། ཁྲིམས་དཔོན་གྱིས་བཙོན་སྲུང་པར་གཏད་ནས་ཁྱེད་བཙོན་ཁང་དུ་འཇུག་ཉེན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","དེ་ལྟར་ན་ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། མཐའ་མའི་སྒོར་མོ་གཅིག་དེ་ཡང་འཇལ་མ་ཚར་བའི་བར་དུ་ཁྱོད་དེ་ལས་ཐར་མི་སྲིད།” ");
INSERT INTO bod_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ལོག་གཡེམ་མ་བྱོས་ཤིག་ཅེས་གསུངས་པ་ཁྱེད་རྣམས་ཀྱིས་ཐོས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། སུས་ཀྱང་འདོད་ཆགས་ཀྱི་སེམས་ཀྱིས་བུད་མེད་ཅིག་ལ་བལྟས་ན་ཡང་རང་གི་སེམས་ལ་ཁོ་མོ་མཉམ་དུ་ལོག་གཡེམ་བྱས་ཟིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","གལ་ཏེ་ཁྱེད་ཀྱི་མིག་གཡས་པས་ཁྱེད་སླུ་བར་བྱས་ན། མིག་དེ་བཏོན་ནས་དབྱུག་ཅིག ལུས་ཧྲིལ་པོ་དམྱལ་ཁམས་སུ་གཡུག་པ་ལས་ཁྱེད་ཀྱི་ལུས་ཀྱི་ཡན་ལག་གཅིག་བརླག་པ་དེ་ལེགས། ");
INSERT INTO bod_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ཡང་གལ་ཏེ་ཁྱེད་ཀྱི་ལག་གཡས་པ་ཡིས་ཁྱེད་སླུ་བར་བྱས་ན། ལག་པ་དེ་བཅད་ནས་དབྱུག་ཅིག ལུས་ཧྲིལ་པོ་དམྱལ་ཁམས་སུ་འགྲོ་བ་ལས་ཁྱེད་ཀྱི་ལུས་ཀྱི་ཡན་ལག་གཅིག་བརླག་པ་དེ་ལེགས། ");
INSERT INTO bod_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","རང་གི་བཟའ་ཟླ་བཞག་པ་དེས་ཁོ་མོ་ལ་བཟའ་ཚང་ཁ་བྲལ་བའི་ཡི་གེ་སྤྲོད་དགོས་ཞེས་གསུངས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ལོག་གཡེམ་གྱི་རྒྱུ་ཡིས་མ་གཏོགས་པར། རང་གི་བཟའ་ཟླ་བཞག་པ་དེས་ཁོ་མོ་ལ་ལོག་གཡེམ་བྱེད་དུ་འཇུག བཟའ་ཚང་ཁ་བྲལ་མྱོང་བའི་བུད་མེད་གཅིག་བཟའ་ཟླར་ལེན་མཁན་དེས་ལོག་གཡེམ་བྱེད།” ");
INSERT INTO bod_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ཡང་གནའ་བོའི་དུས་ཀྱི་མི་རྣམས་ལ་རྫུན་གྱི་དམ་བཅའ་མ་འཇོག་ཅིག གཙོ་བོ་དཀོན་མཆོག་ལ་དམ་བཅའ་སྒྲུབ་པར་བྱོས་ཤིག་ཅེས་གསུངས་པ་ཁྱེད་རྣམས་ཀྱིས་ཐོས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། མནའ་ནམ་ཡང་མ་སྐྱེལ་ཞིག ཞིང་ཁམས་ནི་དཀོན་མཆོག་གི་བཞུགས་ཁྲི་ཡིན་པས། དཀོན་མཆོག་གི་ཞིང་ཁམས་དཔང་དུ་འཛུགས་ཏེ་མནའ་མ་སྐྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ས་གཞི་ནི་ཁོང་གི་ཞབས་སྟེགས་ཡིན་པས། ས་གཞི་དཔང་དུ་འཛུགས་ཏེ་མནའ་མ་སྐྱེལ། ཡེ་རུ་ཤ་ལེམ་ནི་རྒྱལ་པོ་ཆེན་པོའི་གྲོང་ཁྱེར་ཡིན་པས་དེ་དཔང་དུ་འཛུགས་ཏེ་མནའ་མ་སྐྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ཡང་ཁྱེད་ཀྱིས་རང་གི་མགོའི་སྐྲ་གཅིག་ཀྱང་དཀར་པོའམ་ནག་པོར་བྱེད་མི་ཐུབ་པས་རང་གི་མགོ་དཔང་དུ་འཛུགས་ཏེ་མནའ་མ་སྐྱེལ་བར། ");
INSERT INTO bod_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ཡིན་ན་ཡིན་དང་མིན་ན་མིན་གྱི་གཏམ་དྲང་པོ་ཤོད་ཅིག དེ་ལས་ལྷག་པ་ཇི་ཡོད་ངན་པ་ལས་འབྱུང༌།” ");
INSERT INTO bod_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“མིག་གི་ལན་ལ་མིག་དང་སོ་ཡི་ལན་ལ་སོ་ཞེས་གསུངས་པ་ཁྱེད་རྣམས་ཀྱིས་ཐོས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། མི་ངན་པ་ལ་མ་རྒོལ་ཞིག སུས་ཀྱང་ཁྱེད་ལ་འགྲམ་པ་གཡས་པ་ལ་འགྲམ་ལྕག་བཞུས་ན། དེ་ལ་འགྲམ་པ་གཞན་ཡང་སྟོན། ");
INSERT INTO bod_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","སུ་ཞིག་གིས་ཁྱེད་ཁྲིམས་རར་འཁྲིད་ནས་ནང་གོས་འཁྱེར་འདོད་ན། ཁོ་ལ་ཕྱི་གོས་ཀྱང་འཁྱེར་དུ་ཆུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ཡང་སུ་ཞིག་གིས་ཁྱེད་ལ་སྤྱི་ལེ་གཅིག་དབང་གིས་འགྲོ་རུ་བཅུག་ན། ཁོ་དང་སྤྱི་ལེ་གཉིས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ཁྱེད་ལ་གང་ཞིག་ཞུས་མཁན་ལ་སྦྱིན། གཡར་འདོད་མཁན་ལ་རྒྱབ་སྟོན་མ་བྱེད་ཅིག” ");
INSERT INTO bod_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ཁྱིམ་མཚེས་ལ་བྱམས་ཤིང་དགྲ་བོ་ལ་སྡང་ཞེས་གསུངས་པ་ཁྱེད་རྣམས་ཀྱིས་ཐོས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ཁྱེད་ཀྱི་དགྲ་བོ་རྣམས་ལ་བྱམས་པ་གྱིས་ཤིག ཁྱེད་ལ་གནོད་འཚེ་བྱེད་མཁན་རྣམས་ཀྱི་དོན་དུ་གསོལ་སྨོན་འདེབས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","དེ་ལྟར་བྱས་ན་ཁྱེད་ཚོ་ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱི་སྲས་སུ་འགྱུར། གང་ཡིན་ཟེར་ན། ཁོང་གིས་མི་ངན་པ་དང་བཟང་པོ་གཉིས་ཀར་རང་གི་ཉི་མ་ཤར་དུ་འཇུག་ཅིང༌། རང་གཤིས་དྲང་པོ་དང་དྲང་པོ་མིན་པ་གཉིས་ཀར་ཆར་པ་འབེབས་པར་མཛད་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ཡང་ཁྱེད་ལ་བྱམས་པ་བྱེད་མཁན་ལ་བྱམས་ན་ཁྱེད་ལ་བྱ་དགའ་གང་འཐོབ་ཡོང༌། ཁྲལ་སྡུད་མཁན་གྱིས་ཀྱང་དེ་ལྟར་མི་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ཁྱེད་ཀྱི་སྤུན་ཟླ་ཁོ་ནར་འཚམས་འདྲི་ཞུས་ན། མི་གཞན་ལས་ལྷག་པར་གང་བྱེད། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་ཀྱང་དེ་ལྟར་མི་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","དེའི་ཕྱིར་ཞིང་ཁམས་སུ་བཞུགས་ཏེ་ཁྱེད་ཀྱི་ཡབ་མ་ཚང་བ་མེད་པ་ཡིན་པ་ལྟར། ཁྱེད་ཀྱང་མ་ཚང་བ་མེད་པ་ཡིན་པར་དགོས་སོ། །” ");
INSERT INTO bod_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ཁྱེད་ཚོས་མི་གཞན་གྱིས་མཐོང་བའི་ཕྱིར་ཁོ་ཚོའི་མདུན་དུ་ལས་བཟང་པོ་བྱེད་པར་དོགས་ཟོན་གྱིས་ཤིག དེ་ལྟར་བྱས་ན་ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཁྱེད་ལ་བྱ་དགའ་མི་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","དེའི་ཕྱིར་ཁྱེད་ཚོས་དབུལ་པོ་རྣམས་ལ་སྦྱིན་པ་གཏོང་བའི་སྐབས་སུ་དུང་ཆེན་གཏོང་དུ་མ་འཇུག་ཅིག ཁ་བཤད་དོན་ལ་མི་གནས་པ་རྣམས་ཀྱིས་མི་རྣམས་ཀྱི་བསྟོད་པ་འཐོབ་པའི་ཆེད་དུ་གཞུང་ལམ་དང་འདུ་ཁང་ལ་དེ་ལྟར་བྱེད། ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར་ཁོ་ཚོར་བྱ་དགའ་ཐོབ་ཚར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","འོན་ཀྱང་ཁྱེད་ཀྱིས་དབུལ་པོ་རྣམས་ལ་སྦྱིན་པ་གཏོང་བའི་སྐབས་སུ་ཁྱེད་ཀྱི་ལག་པ་གཡས་པས་གང་བྱེད་པ་དེ་ལག་པ་གཡོན་པས་ཀྱང་ཤེས་པར་མ་འཇུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","དེ་ལྟར་བྱས་ན་ཁྱེད་ཀྱིས་སྦྱིན་པ་ནི་གསང་བའི་ཐོག་ནས་ཡིན་པ་དང༌། ཁྱེད་ཀྱི་ཡབ་གསང་བ་གཟིགས་མཁན་གྱིས་ཁྱེད་ལ་བྱ་དགའ་གནང་ངེས་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ཡང་ཁྱེད་ཚོས་སྨོན་ལམ་འདེབས་པའི་སྐབས་སུ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་རྣམས་ཀྱི་དཔེ་ལྟར་མ་བྱེད་ཅིག མི་རྣམས་ཀྱིས་མཐོང་བའི་ཆེད་དུ་ཁོ་ཚོས་འདུ་ཁང་དང་མདོ་ཁར་སྨོན་ལམ་འདེབས་པར་དགའ། ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར་ཁོ་ཚོར་རང་གི་བྱ་དགའ་ཐོབ་ཚར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","དེ་ལས་ལྡོག་སྟེ་སྨོན་ལམ་འདེབས་པའི་སྐབས་སུ་ཁང་པའི་ཕུག་ནང་དུ་སོང་ལ་སྒོ་བརྒྱབ་ནས་གསང་བར་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ལ་སྨོན་ལམ་འདེབས། དེ་ནས་ཁྱེད་ཀྱི་ཡབ་གསང་བ་གཟིགས་མཁན་གྱིས་ཁྱེད་ལ་བྱ་དགའ་གནང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ཡང་སྨོན་ལམ་འདེབས་པའི་སྐབས་སུ་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་བྱེད་པ་ལྟར་དོན་མེད་པའི་གཏམ་མ་ཤོད་ཅིག ཁོ་ཚོས་ཚིག་མང་བས་སྨོན་ལམ་གསན་པར་འགྱུར་སྙམ། ");
INSERT INTO bod_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","དེའི་ཕྱིར་ཁོ་ཚོར་མིག་དཔེ་མ་བྱེད་ཅིག གང་ཡིན་ཞེ་ན། ཁྱེད་ཚོས་མ་ཞུས་པའི་སྔོན་ལ་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཁྱེད་ལ་གང་དགོས་པ་མཁྱེན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","དེ་བས་ན་ཁྱེད་ཀྱིས་འདི་ལྟར་སྨོན་ལམ་ཞུས་ཤིག ནམ་མཁར་བཞུགས་པའི་ངེད་ཀྱི་ཡབ། ། ཁྱེད་མཚན་དམ་པར་སྲུང་བར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ཁྱེད་ཀྱི་རྒྱལ་སྲིད་འོང་བར་ཤོག ། ཁྱེད་ཀྱི་དགོངས་པ་ནམ་མཁའ་ལ། ། སྒྲུབ་ལྟར་ས་ལའང་སྒྲུབ་པར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ངེད་ཀྱི་ཉིན་ཞག་རེའི་ཁ་ཟས། ། དེ་རིང་ཡང་ནི་གནང་བར་མཛོད། ། ");
INSERT INTO bod_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ངེད་ཚོས་གཞན་གྱི་ཉེས་པ་དག ། གུ་ཡངས་གཏོང་བ་ཇི་བཞིན་དུ། ། ངེད་ཀྱི་སྡིག་བུན་སེལ་བར་མཛོད། ། ");
INSERT INTO bod_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ཉམས་ཚོད་ནང་དུ་མ་འཁྲིད་པར། ། ངན་པ་ལས་ངེད་ཐར་བར་མཛོད། ། ");
INSERT INTO bod_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","གལ་ཏེ་ཁྱེད་ཚོས་མི་གཞན་ལ་གུ་ཡངས་བཏང་ན། ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཀྱང་ཁྱེད་ཀྱི་སྡིག་ཉེས་སེལ་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","འོན་ཀྱང་གཞན་ལ་གུ་ཡངས་མ་བཏང་ན། ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཀྱང་ཁྱེད་ཀྱི་སྡིག་ཉེས་སེལ་བར་མི་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ཁྱེད་ཚོས་སྨྱུང་གནས་སྲུང་བའི་ཚེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་རྣམས་ཀྱིས་བྱེད་པ་ལྟར་རྣམ་འགྱུར་མ་སྟོན་ཅིག མི་གཞན་ལ་སྨྱུང་གནས་སྲུང་བཞིན་པར་སྟོན་པའི་ཕྱིར་ཁོ་ཚོས་རང་གི་ངོ་གདོང་ནག་པོ་བཟོ། ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར་ཁོ་ཚོར་རང་གི་བྱ་དགའ་ཐོབ་ཚར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","འོན་ཀྱང་སྨྱུང་གནས་སྲུང་བའི་ཚེ་རང་གི་མགོ་ལ་སྣུམ་འབྱུག་ཅིང་ངོ་གདོང་ཁྲུས། ");
INSERT INTO bod_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","དེ་ནས་མི་རྣམས་ཀྱིས་ཁྱེད་སྨྱུང་གནས་སྲུང་བཞིན་པར་མི་མཐོང་ཡང༌། གསང་བར་བཞུགས་པའི་ཡབ་ཀྱིས་གཟིགས་ཤིང༌། གསང་བ་གཟིགས་མཁན་ཡབ་ཀྱིས་ཁྱེད་ལ་བྱ་དགའ་གནང་ངེས་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“མུག་པ་དང་བཙའ་ཡིས་ཟ་ཞིང༌། ཁང་པར་འཛུལ་ནས་རྐུན་མས་རྐུ་ས་འཇིག་རྟེན་འདི་ལ་ནོར་མ་གསོག་པར། ");
INSERT INTO bod_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","མུག་པ་དང་བཙའ་ཡིས་མི་ཟ་ཞིང༌། ཁང་པར་འཛུལ་ནས་རྐུན་མས་མི་རྐུ་ས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ནོར་གསོག ");
INSERT INTO bod_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","གང་ལགས་ཟེར་ན། གང་ཁྱེད་ཀྱི་རྒྱུ་ནོར་ཡོད་ས་དེར་ཁྱེད་ཀྱི་སེམས་ཀྱང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","མིག་ནི་ལུས་ཀྱི་སྒྲོན་མེ་ལྟར་ཡིན། མིག་བཟང་པོ་ཡོད་ན་ལུས་ཧྲིལ་པོ་འོད་ཀྱིས་གང༌། ");
INSERT INTO bod_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","འོན་ཀྱང་མིག་བཟང་པོ་མེད་ན་ལུས་ཧྲིལ་པོ་མུན་ནག་གིས་གང༌། གལ་ཏེ་ཁྱེད་ཀྱི་སེམས་ནང་ལ་འོད་དེ་མུན་པ་ཡིན་ན་མུན་པ་དེ་ཅི་ལྟར་ཆེ། ");
INSERT INTO bod_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","སུ་ཞིག་གིས་བདག་པོ་གཉིས་ལ་གཡོག་བྱེད་མི་སྲིད། གང་ལགས་ཤེ་ན། ཁོས་གཅིག་ལ་སྡང་ཞིང་གཅིག་ལ་གཅེས་པའམ། གཅིག་ལ་མོས་ཤིང་གཅིག་ལ་སྨད་པར་བྱེད། ཁྱེད་ཚོས་དཀོན་མཆོག་དང་རྒྱུ་ནོར་གཉིས་ཀའི་གཡོག་བྱེད་མི་སྲིད།” ");
INSERT INTO bod_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“དེའི་ཕྱིར་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཚེ་སྲོག་གི་ཕྱིར་ཟས་གང་ཞིག་ཟ་རྒྱུ་དང་འཐུང་རྒྱུ། ལུས་ཀྱི་ཕྱིར་གོས་གང་ཞིག་གྱོན་པ་སེམས་ཁྲལ་མ་བྱོས་ཤིག གང་ལགས་ཤེ་ན། ཚེ་སྲོག་དང་ལུས་པོ་གཉིས་ཟས་དང་གྱོན་ཆས་ལས་ལྷག་པ་མེད་དམ། ");
INSERT INTO bod_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ནམ་མཁའི་བྱ་བྱིའུ་ལ་ལྟོས་ཤིག དེ་ཚོས་ས་བོན་མི་འདེབས་ལ། ལོ་ཏོག་མི་རྔ༌། མཛོད་ཁང་ལ་མི་གསོག་ཀྱང༌། ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་དེ་ཚོར་ཟས་གནང༌། ཁྱེད་ཚོ་དེ་རྣམས་ལས་གལ་ཆེ་བ་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ཁྱེད་ཚོའི་ནང་ནས་སུ་ཞིག་གིས་སེམས་ཁྲལ་བྱེད་པའི་ངང་ནས་མི་ཚེ་འདི་ཆུ་ཚོད་གཅིག་ཙམ་གྱི་རིང་དུ་གཏོང་ཐུབ་བམ། ");
INSERT INTO bod_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ཡང་གྱོན་ཆས་ཀྱི་ཕྱིར་ཅི་ལ་སེམས་ཁྲལ་བྱེད། རྩྭ་ཐང་སྟེང་གི་སྟག་གཟིག་མེ་ཏོག་ཇི་ལྟར་སྐྱེ་བར་ལྟོས་ཤིག དེ་ཚོས་ལས་ཀ་མི་བྱེད་ལ་བལ་ཡང་མི་འཁལ། ");
INSERT INTO bod_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། རྒྱལ་པོ་སོ་ལོ་མོན་གཟི་བརྗིད་ཆེན་པོ་དང་ལྡན་པ་ཞིག་ཡིན་ཡང༌། ཁོང་གི་རྒྱན་གོས་དེ་ཚོའི་ནང་གི་གཅིག་ལའང་འགྲན་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","གལ་ཏེ་དཀོན་མཆོག་གིས་ཞིང་སྟེང་གི་རྩྭ་དེ་རིང་སྐྱེ་སྟེ་སང་ཉིན་ཐབ་ལ་འཕེན་རྒྱུ་ཡིན་པར་དེ་ལྟར་གཡོག་པར་མཛད་ན། ཁོང་གིས་དེ་བས་ཀྱང་ཁྱོད་དད་ཆུང་བ་རྣམས་ལ་གཡོག་པ་གནང་བར་མི་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","དེའི་ཕྱིར་ང་ཚོས་ཅི་ཟ། ཅི་འཐུང༌། ཅི་གྱོན་ཞེས་ཟེར་ཏེ་སེམས་ཁྲལ་མ་བྱེད་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་དེ་ཚོ་ཚང་མ་འཚོལ། ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཁྱོད་ཚོ་ལ་དེ་ཐམས་ཅད་དགོས་པ་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ཐོག་མར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དང་ཁོང་གི་དྲང་བདེན་ལ་འབད་བརྩོན་བྱོས། དེ་ནས་དེ་ཚོ་ཐམས་ཅད་ཁྱེད་ཚོ་ལ་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","དེའི་ཕྱིར་སང་ཉིན་གྱི་དོན་ལ་སེམས་ཁྲལ་མ་བྱེད། གང་ཡིན་ཞེ་ན། སང་ཉིན་ལ་སང་ཉིན་གྱི་སེམས་ཁྲལ་ཡོད། ཉིན་རེར་རྙོག་དྲ་རེས་ཆོག་གོ །” ");
INSERT INTO bod_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“སྐྱོན་འདོགས་མ་བྱོས་དང༌། ཁྲིམས་གཅོད་འབྱུང་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","གང་ཡིན་ཟེར་ན། ཇི་ལྟར་ཁྱེད་ཀྱིས་མི་གཞན་ལ་སྐྱོན་འདོགས་བྱས་པ། དེ་ལྟར་ཁྱེད་ལ་ཡང་ཁྲིམས་གཅོད་འབྱུང་བར་འགྱུར། སྣོད་གང་གིས་འཇལ་བ་དེ་རང་གིས་ཁྱེད་ལ་ཡང་འཇལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","གཞན་གྱི་མིག་ལ་ཡོད་པའི་ཤིང་རྡུལ་མཐོང་ཡང༌། རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་མི་མཐོང་བ་དེ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ཡང་ན་ཁྱེད་ཀྱིས་རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་མི་མཐོང་བར། མི་གཞན་ལ་ཁྱེད་ཀྱི་མིག་ལ་ཡོད་པའི་ཤིང་རྡུལ་འདོན་པར་བྱ་ཞེས་ཅི་ལྟར་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད། སྔོན་ལ་རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་ཐོན་ཅིག དེ་ནས་གཞན་གྱི་མིག་ནས་ཤིང་རྡུལ་འདོན་པའི་ཆེད་དུ་གསལ་པོར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","གང་ཞིག་དམ་པ་ཡིན་པ་དེ་ཁྱི་ལ་མ་སྟེར། དེས་ཁ་ཚུར་སློག་ནས་ཁྱེད་ལ་རྒོལ། ཁྱེད་ཀྱི་མུ་ཏིག་རྣམས་ཕག་པའི་མདུན་དུ་མ་དབྱུག་ཅིག དེ་མིན་ཕག་པའི་རྐང་པས་བརྫིས་པར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ཞུས་ན་གནང་བར་འགྱུར། བཙལ་ན་རྙེད་པར་འགྱུར། སྒོ་བརྡུངས་ན་འབྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","གང་ལགས་ཟེར་ན། ཞུ་མཁན་ཐམས་ཅད་ལ་འཐོབ་པ་དང༌། འཚོལ་མཁན་ཐམས་ཅད་ལ་རྙེད། སྒོ་རྡུང་མཁན་ཐམས་ཅད་ལ་སྒོ་འབྱེད་པར་འགྱུར་བས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","དཔེར་ན་ཁྱེད་ཚོ་ལས་སུ་ཞིག་གིས་བུ་ལ་བག་ལེབ་དགོས་ཞེས་ཞུས་ན་ཁོ་ལ་རྡོ་སྟེར་བར་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ཡང་ན་ཉ་ཤ་དགོས་ཞེས་ཞུས་ན་ཁོ་ལ་སྦྲུལ་སྟེར་བར་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ཁྱོད་ཚོ་ངན་པ་ཡིན་ཡང་ཁྱོད་ཀྱི་ཕྲུ་གུ་རྣམས་ལ་ལག་རྟགས་བཟང་པོ་སྤྲོད་པར་ཤེས་ན། ཞིང་ཁམས་སུ་བཞུགས་པ་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་ཁོང་ལ་གསོལ་འདེབས་བྱེད་མཁན་རྣམས་ལ་གང་བཟང་པོ་ཡིན་པ་དེ་བས་ཀྱང་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","མི་གཞན་གྱིས་ཇི་ལྟར་ཁྱེད་ཚོར་བྱས་ན་དགའ་བ་བཞིན། དེ་ལྟར་གཞན་ལ་བྱོས་ཤིག དེ་ནི་ཆོས་ཁྲིམས་དང་ལུང་སྟོན་པའི་བསྟན་པའི་དོན་མདོར་བསྡུས་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","སྒོ་དོག་མོ་བརྒྱུད་ནས་འཇུག གང་ཡིན་ཞེ་ན། འཇིག་པར་འཁྲིད་པའི་སྒོ་ནི་ཞེང་ཅན་དང་ལམ་ཡངས་པོ་ཡོད་པས་མི་མང་པོ་དེར་འགྲོ ");
INSERT INTO bod_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","དཔག་ཏུ་མེད་པའི་ཚེ་ལ་འཁྲིད་པའི་སྒོ་ནི་ཞེང་ག་ཆུང་ཞིང་ལམ་ཡང་དོག་མོ་ཡོད་པས་མི་ཉུང་ངུ་ཙམ་ལ་ལམ་དེ་རྙེད།” ");
INSERT INTO bod_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ལུང་སྟོན་པ་རྫུན་མ་རྣམས་ལ་དོགས་ཟོན་གྱིས་ཤིག ལུག་གི་པགས་པ་གྱོན་ཏེ་ཁྱེད་ཚོའི་རྩར་ཡོང་ཡང༌། དངོས་གནས་ཁོ་རྣམས་སྤྱང་ཀི་དྲག་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","དེ་ཚོའི་འབྲས་བུ་ནས་ངོ་ཤེས། ཚེར་ཤིང་ནས་རྒུན་འབྲུམ་དང༌། ཡང་ན་སེ་བའི་མེ་ཏོག་ནས་བསེ་ཡབ་འཐོག་སྲིད་དམ། ");
INSERT INTO bod_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","དེ་བཞིན་དུ་ཤིང་སྡོང་བཟང་པོ་རེ་རེ་ལས་འབྲས་བུ་བཟང་པོ་སྐྱེ་ཞིང༌། ཤིང་སྡོང་ངན་པ་ལས་འབྲས་བུ་ངན་པ་སྐྱེ། ");
INSERT INTO bod_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ཤིང་སྡོང་བཟང་པོ་ལས་འབྲས་བུ་ངན་པ་དང༌། ཤིང་སྡོང་ངན་པ་ལས་འབྲས་བུ་བཟང་པོ་སྐྱེ་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","འབྲས་བུ་བཟང་པོ་མ་སྐྱེ་པའི་ཤིང་སྡོང་རེ་རེ་བཞིན་བཅད་ནས་མེ་ལ་གཡུག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","དེའི་ཕྱིར་ཁོ་ཚོའི་འབྲས་བུ་ལ་བལྟས་ནས་ཁྱེད་ཚོས་ཤེས་འོང༌། ");
INSERT INTO bod_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ང་ལ། གཙོ་བོ་ལགས། གཙོ་བོ་ལགས་ཞེས་ཟེར་མཁན་ཐམས་ཅད་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འཇུག་མི་ཡོང༌། ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱི་ཐུགས་དགོངས་སྒྲུབ་མཁན་ནི་དེའི་ནང་དུ་འཇུག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ཉིན་མོ་དེར་མི་མང་པོས། གཙོ་བོ་ལགས། གཙོ་བོ་ལགས། ང་ཚོས་ཁྱེད་ཀྱི་མཚན་གྱི་སྒོ་ནས་ལུང་བསྟན་མེད་པ་དང༌། ཁྱེད་ཀྱི་མཚན་གྱི་སྒོ་ནས་གདོན་འདྲེ་མ་བསྐྲད་པ། ཁྱེད་ཀྱི་མཚན་གྱི་སྒོ་ནས་ངོ་མཚར་བའི་ལས་མང་པོ་མ་བྱས་སམ་ཞེས་ང་ལ་ཟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","དེ་ནས་ངས་ཁོ་ཚོར། ངས་ཁྱོད་རྣམས་ནམ་ཡང་ངོ་མ་ཤེས་པས། ངན་པ་བྱེད་མཁན་ཁྱོད་ཚོ་ངའི་རྩ་ནས་ཕར་རྒྱུགས་ཞེས་སྨྲ་བར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“དེའི་ཕྱིར་ངས་སྨྲས་པའི་ཚིག་ཐོས་ཏེ་ཉམས་ལེན་བྱེད་མཁན་ཐམས་ཅད་ནི་རང་གི་ཁང་པ་བྲག་ལ་བརྩིགས་པའི་ཤེས་རབ་ཅན་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ཁང་པ་དེ་བྲག་གི་སྟེང་དུ་རྩིགས་པས། ཆར་པ་བབས་ནས་ཆུ་ལོག་བྱུང་ཞིང༌། ལྷགས་པ་དྲག་པོ་བརྒྱབ་ནས་ཁང་པ་དེར་ཕོག་ཀྱང་མ་རྡིབ། ");
INSERT INTO bod_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ངས་སྨྲས་པའི་ཚིག་ཐོས་ཏེ་ཉམས་ལེན་མ་བྱེད་མཁན་ཐམས་ཅད་ནི་རང་གི་ཁང་པ་བྱེ་མའི་སྟེང་དུ་བརྩིགས་པའི་བླུན་པོ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ཆར་པ་བབས་ནས་ཆུ་ལོག་བྱུང་ཞིང༌། ལྷགས་པ་དྲག་པོ་བརྒྱབ་ནས་ཁང་པ་དེར་ཕོག་སྟེ་རྡིབ་ཅིང་ཡོངས་སུ་བཤིག་པར་གྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ཡེ་ཤུས་བཀའ་དེ་གསུངས་ཚར་རྗེས། ཁོང་གིས་གསུངས་པ་དེ་ལ་མི་ཚོགས་རྣམས་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","རྒྱུ་མཚན་ནི་ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་དང་མི་འདྲ་སྟེ། དབང་ལྡན་ཞིག་གིས་གསུངས་པ་དང་འདྲ་བར་ཁོ་ཚོར་ཆོས་བསྟན་གནང་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ཡེ་ཤུ་རི་བོ་ལས་མར་འབབ་པའི་དུས་སུ་མི་ཚོགས་མང་པོ་ཞིག་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","དེའི་ཚེ་མཛེ་ནད་ཅན་ཞིག་ཁོང་གི་དྲུང་དུ་ཡོང་ནས་པུས་མོ་སར་བཙུགས་ཏེ་“གཙོ་བོ་ལགས། གལ་ཏེ་ཁྱེད་ཐུགས་མཉེས་པ་ཡིན་ན་ཁྱེད་ཀྱིས་ང་རང་གི་མཛེ་ནད་དག་པར་མཛད་ཐུབ་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ཡེ་ཤུས་ཕྱག་བརྐྱངས་ནས་ཁོ་ལ་རེག་སྟེ་“ང་དེ་བཞིན་དུ་བྱེད་འདོད་ཡོད། དག་པར་གྱུར་ཅིག་”ཅེས་གསུངས་མ་ཐག་ཁོའི་མཛེ་ནད་དག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ཡེ་ཤུས་མི་དེར་“མི་གཞན་ལ་ཅི་ཡང་སྨྲ་བར་མ་བྱོས། སོང་ལ་རང་གི་ལུས་ཡ་ཧུ་དཱ་པའི་བླ་མར་སྟོན་དང༌། ཁོ་རྣམས་ལ་བདེན་དཔང་བྱེད་པའི་ཕྱིར་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་བཀའ་གནང་བ་ལྟར་ཁྱེད་དག་པར་གྱུར་བ་ཡིན་པའི་ཕྱིར་མཆོད་པ་ཞིག་ཕུལ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ཁོང་ཀ་ཕར་ན་ཧུམ་ལ་ཕེབས་སྐབས་དམག་མི་བརྒྱ་དཔོན་ཅིག་ཡོང་ནས་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“གཙོ་བོ་ལགས། ངའི་གཡོག་པོ་ཞ་རིལ་གྱི་ནད་ཕོག་པས་སྡུག་བསྔལ་ཆེན་པོ་མྱོང་སྟེ་ནང་ལ་ཉལ་ཡོད་”ཅེས་ནན་གྱིས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ཡེ་ཤུས་ཁོ་ལ་“ང་ཡོང་ནས་ཁོའི་ནད་སེལ་བར་བྱ་”ཞེས་གསུངས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ལན་དུ་བརྒྱ་དཔོན་དེས་“གཙོ་བོ་ལགས། ཁྱེད་ངའི་ཁྱིམ་ནང་དུ་ཕེབས་པར་མི་འོས་པས་བཀའ་ཁོ་ན་གསུངས་དང༌། ངའི་གཡོག་པོ་ནད་ལས་ཐར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","གང་ལགས་ཤེ་ན། ང་ཡང་གཞན་གྱི་དབང་འོག་ཏུ་ཡོད་པ་དང༌། ངའི་འོག་ཏུ་ཡང་དམག་མི་ཡོད། ངས་དམག་མི་ཞིག་ལ་སོང་ཞེས་ཟེར་ན་འགྲོ གཞན་ལ་ཚུར་ཤོག་ཅེས་བཤད་ན་ཡོང༌། ངའི་གཡོག་པོར་ལས་ཀ་དེ་བྱོས་ཤིག་ཅེས་བཤད་ན་ཁོས་དེ་ལྟར་བྱེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ཡེ་ཤུས་དེ་གསན་ནས་ཡ་མཚན་སྐྱེས་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲང་བའི་མི་རྣམས་ལ་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། ཡི་སི་ར་ཨེལ་ཡུལ་ལའང་ངས་འདི་འདྲ་བའི་དད་སེམས་ཡོད་པའི་མི་མཐོང་མ་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། མེས་པོ་ཨབ་ར་ཧམ་དང༌། ཨི་སཱག་དང༌། ཡ་ཀོབ་དང་མཉམ་དུ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་ཞལ་ཟས་བཞེས་པའི་ཕྱིར་ཤར་ནུབ་ནས་མི་མང་པོ་ཞིག་ཡོང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","འོན་ཀྱང་རྒྱལ་སྲིད་ཀྱི་འབངས་མི་ནི་ཕྱི་རོལ་གྱི་མུན་པའི་ནང་དུ་དབྱུག ས་ཆ་དེར་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ཡང་ཡེ་ཤུས་བརྒྱ་དཔོན་དེ་ལ་“སོང་ལ་ཁྱེད་ཀྱིས་དད་པ་བཞིན་དུ་སྒྲུབ་པར་འགྱུར་”ཞེས་གསུངས་ནས། དུས་དེ་རང་ལ་གཡོག་པོ་དེ་ནད་ལས་ཐར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ཡེ་ཤུ་ཉེ་གནས་པེ་ཏྲོའི་ཁྱིམ་ནང་དུ་ཕེབས་སྐབས། པེ་ཏྲོའི་བཟའ་ཟླའི་ཨ་མ་ཚ་བ་རྒྱས་ནས་ཉལ་ཁྲིར་ཉལ་བ་ཁོང་གིས་གཟིགས་པས། ");
INSERT INTO bod_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ཁོ་མོའི་ལག་པ་ལ་རེག་པས་ཚ་བ་འཇགས་ཏེ་ཁོ་མོས་ཡར་ལངས་ནས། ཁོང་ལ་ཞབས་ཕྱི་ཞུས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","དགོང་མོ་དེར་ཁོ་ཚོས་གདོན་འདྲེས་བཟུང་བའི་མི་མང་པོ་ཁོང་གི་དྲུང་དུ་ཁྲིད་པ་དང༌། ཁོང་གི་བཀའ་ཡིས་གདོན་འདྲེ་དེ་རྣམས་བསྐྲད་པར་མཛད་ཅིང༌། ནད་པ་ཐམས་ཅད་གསོ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","འདི་ནི་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱའི་ལུང་བསྟན་སྒྲུབ་པའི་ཆེད་དུ་ཡིན་ཏེ། ཁོང་ཉིད། ཁོང་གིས་ང་ཚོའི་ནད་ཀུན་དང༌། ། སྡུག་བསྔལ་ཡོངས་སུ་སེལ་བར་མཛད། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ཡེ་ཤུས་རང་གི་མཐའ་སྐོར་ལ་མི་ཚོགས་གཟིགས་སྐབས། མཚོའི་ཕ་རོལ་ལ་འགྲོ་བའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཞིག་ཁོང་གི་དྲུང་དུ་ཡོང་ནས་ཁོང་ལ་“སྟོན་པ་ལགས། ཁྱེད་གང་དུ་ཕེབས་ན་ཡང་ང་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲང་བར་བྱ་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ཡེ་ཤུས་ཁོ་ལ་“ཝ་ལ་ཝ་ཚང་དང༌། བྱ་ལ་བྱ་ཚང་ཡོད་ཀྱང༌། མིའི་རིགས་ཀྱི་བུ་ཟེར་མཁན་ལ་མགོ་བཞག་ས་ཙམ་ཡང་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ཉེ་གནས་རྣམས་ལས་གཅིག་གིས་ཁོང་ལ་“གཙོ་བོ་ལགས། སྔོན་ལ་ང་སོང་ནས་ངའི་ཕའི་སྐུ་ཕུང་དུར་སར་འཇུག་པའི་ལུགས་སྲོལ་སྲུང་བའི་དགོངས་པ་གནང་རོགས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","འོན་ཀྱང་ཁོང་གིས་ཁོ་ལ་“ངའི་རྗེས་སུ་ཤོག གཤིན་པོ་དང་འདྲ་བ་རྣམས་ཀྱིས་རང་གི་གཤིན་པོ་རྣམས་དུར་དུ་འཇུག་ཆོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ཡེ་ཤུ་གྲུའི་ནང་འཛུལ་ནས་ཁོང་གི་ཉེ་གནས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","གློ་བུར་དུ་མཚོའི་སྒང་ལ་རླུང་འཚུབ་ཆེན་པོ་ལངས་ཏེ་རྦ་རླབས་གྲུའི་ནང་ཡོང་ནས་གྲུ་ཆུས་ཁེངས་གྲབས་བྱེད། འོན་ཀྱང་ཡེ་ཤུ་གཟིམས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ཁོ་ཚོ་ཉེ་བར་ཡོང་ནས་ཁོང་མནལ་སད་དེ་“གཙོ་བོ་ལགས། ང་ཚོ་འཆི་བ་ལ་ཐུག་པས་སྐྱོབ་པར་མཛོད་ཅིག་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོ་དད་ཆུང་བ་རྣམས། ཞེད་དགོས་དོན་གང་ཡིན་”ཞེས་གསུངས་ཏེ་ཡར་བཞེངས་ནས་རླུང་དང་མཚོ་ལ་བཀའ་བཀྱོན་མཛད་ཅིང༌། དེ་ཚོ་ཡོངས་སུ་ཞི་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ཡ་མཚན་ཆེན་པོ་སྐྱེས་ཏེ་ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“སྐྱེས་བུ་འདི་ཅི་ལྟར་ཡིན། རླུང་དང་མཚོ་ཡིས་ཀྱང་ཁོང་གི་བཀའ་ལ་ཉན་པར་བྱེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","མཚོའི་ཕ་རོལ་གད་དེ་རེའི་ཡུལ་དུ་ཕེབས་པ་དང༌། གདོན་འདྲེས་བཟུང་བའི་མི་གཉིས་དུར་ཁང་གི་ཁྲོད་ནས་ཐོན་ཏེ་ཁོང་དང་མཇལ། ཁོ་ཚོ་ཧ་ཅང་དྲག་པོ་ཡིན་པས་སུའང་ལམ་དེར་འགྲོ་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","གློ་བུར་དུ་ཁོ་ཚོས་སྐད་ཆེན་པོས་“ཀྱེ་དཀོན་མཆོག་གི་སྲས། ངེད་རྣམས་ཁྱེད་དང་འབྲེལ་བ་ཅི་ཡོད། དུས་ལ་བབ་པའི་སྔོན་ལ་ང་ཚོར་མནར་གཅོད་གཏོང་བའི་ཕྱིར་ཕེབས་པ་ཡིན་ནམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ཐག་རིང་ཙམ་ལ་ཕག་ཁྱུ་ཆེན་པོ་ཞིག་འཚོ་བཞིན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","གདོན་འདྲེ་དེ་ཚོས་ཁོང་ལ་“ཁྱེད་ཀྱིས་ང་ཚོ་ཕར་བསྐྲད་ན། ཕག་ཁྱུའི་ཁྲོད་ལ་གཏོང་བར་མཛོད་”ཅེས་ཞུ་བ་ཆེན་པོ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ཁོང་གིས་ཁོ་ཚོར་“སོང་ཞིག་”ཅེས་གསུངས་པས་གདོན་འདྲེ་དེ་ཚོ་ཕྱིར་ཐོན་ཏེ་ཕག་པའི་ནང་དུ་ཞུགས་ཤིང༌། ཕག་ཁྱུ་ཧྲིལ་པོ་གཡང་གཟར་ནས་མཆོངས་ཤིང་མཚོའི་ནང་དུ་ནུབ་སྟེ་ཤི ");
INSERT INTO bod_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ཕག་རྫི་རྣམས་གྲོང་ཁྱེར་ལ་བྲོས་ནས་གདོན་འདྲེས་བཟུང་བའི་མི་རྣམས་ལ་གང་བྱུང་བ་ཐམས་ཅད་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","གྲོང་ཁྱེར་གྱི་མི་ཐམས་ཅད་ཡེ་ཤུ་མཇལ་བར་ཡོང་སྟེ། ཁོང་མཐོང་ནས་ས་ཆ་གཞན་ལ་ཕེབས་རྒྱུར་ཞུ་བ་ཡང་ཡང་ཕུལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ཡེ་ཤུ་གྲུའི་ནང་བཞུགས་ནས་མཚོའི་ཕ་རོལ་ཏུ་རང་གི་གྲོང་ཁྱེར་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","དེ་ནས་མི་ཁ་ཤས་ཀྱིས་གོམ་པ་སྤོ་མི་ཐུབ་པའི་ནད་པ་གཅིག་ཉལ་ཁྲི་སྟེང་ལ་ཁུར་ནས་ཁོང་གི་དྲུང་དུ་འོངས། ཁོ་ཚོའི་དད་སེམས་མཁྱེན་ནས་ཁོང་གིས་ནད་པ་དེར་“བུ། བློ་བདེ་བར་བྱོས་ཤིག ཁྱེད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་པ་ཡིན་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","དེར་ཡོད་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁ་ཤས་ཀྱི་བསམ་པ་ལ་མི་འདིས་དཀོན་མཆོག་ལ་སྐུར་བ་འདེབས་སྙམ། ");
INSERT INTO bod_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱོད་ཚོས་བསམ་བློ་ངན་པ་འདི་ལྟར་བཏང་དགོས་པའི་རྒྱུ་མཚན་གང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ཁྱེད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་ཟེར་བ་ལས་སླ་པོ་ཡིན་ནམ། ཡང་ན། ལོངས་ལ་སོང་ཞིག་ཟེར་བ་ལས་སླ་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","འོན་ཀྱང་མིའི་རིགས་ཀྱི་བུ་ཟེར་མཁན་དེ་ལ་འཇིག་རྟེན་འདིར་སྡིག་ཉེས་སེལ་བའི་དབང་ཡོད་པ་ཁྱོད་ཚོས་ཤེས་པའི་ཕྱིར༌༌༌༌”ཞེས་གསུངས་ནས་ཁོང་གིས་ནད་པ་དེ་ལ་“ལོངས་ལ་ཉལ་ཁྲི་ཁྱེར་ནས་ནང་ལ་ལོག་ཅིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","མི་དེ་ཡར་ལངས་ནས་ཁྱིམ་དུ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","མི་ཚོགས་ཀྱིས་དེ་མཐོང་ནས་ཡ་མཚན་གྱིས་ཁེངས་ཤིང༌། དེ་ལྟར་ཆེ་བའི་དབང་མི་རྣམས་ལ་གནང་མཁན་གྱི་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ཡེ་ཤུ་ཕར་ཕེབས་པའི་དུས་སུ་མད་ཐཱ་ཞེས་ཟེར་བའི་མི་ཞིག་ཁྲལ་སྡུད་སར་བསྡད་ཡོད་པ་ཁོང་གིས་གཟིགས་ནས་ཁོ་ལ་“ཁྱེད་རང་ངའི་རྗེས་སུ་ཤོག་”ཅེས་གསུངས་པས། ཁོ་ཡར་ལངས་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ཡེ་ཤུས་ཁྱིམ་ནང་དུ་ཞལ་ལག་བཞེས་པའི་སྐབས་སུ། ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཉེས་ཅན་མང་པོ་ཞིག་ཡོང་ནས་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་མཉམ་དུ་ཟས་ཟ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","དེ་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་མཐོང་ནས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་“ཁྱོད་ཚོའི་སྟོན་པས་ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཉེས་ཅན་རྣམས་དང་མཉམ་དུ་ཞལ་ལག་བཞེས་བཞིན་པ་འདི་ཅི་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ཡེ་ཤུས་གཏམ་དེ་གསན་ནས་“ཁམས་བཟང་པོའི་མི་རྣམས་ལ་སྨན་པ་མི་དགོས་ཀྱི། ནད་པ་ཚོ་ལ་དགོས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","སོང་ལ། ང་ནི་མཆོད་པ་ལ་མི་དགའ་བར་སྙིང་རྗེའི་སེམས་ལ་དགའོ་ཞེས་གསུངས་པའི་དོན་གང་ཡིན་ཤེས་པར་གྱིས་ཤིག ང་རང་ནི་མི་དྲང་ལྡན་རྣམས་འབོད་དུ་ཡོང་བ་མ་ཡིན་གྱི། མི་སྡིག་ཅན་རྣམས་འབོད་དུ་ཡོང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","དེ་ནས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་སློབ་མ་འགའ་ཞིག་ཡོང་ནས་ཡེ་ཤུ་ལ་“ང་ཚོ་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་སྨྱུང་གནས་སྲུང་ཡང༌། ཁྱེད་ཀྱི་སློབ་མ་རྣམས་ཀྱིས་སྨྱུང་གནས་མི་སྲུང་བ་དེ་ཅི་ཡིན་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ཡེ་ཤུས་ཁོ་ཚོར་“ཆང་སའི་སྐབས། མག་པའི་རོགས་པ་རྣམས་ཀྱིས་མག་པ་དང་མཉམ་དུ་ཡོད་དུས་མྱ་ངན་བྱེད་སྲིད་དམ། འོན་ཀྱང་མག་པ་ཁོ་ཚོ་དང་ཁ་འབྲལ་བའི་དུས་ལ་འབབ་ཡོང༌། དུས་དེར་ཁོ་ཚོས་སྨྱུང་གནས་སྲུང་ངེས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","མི་སུས་ཀྱང་རས་མཐུག་པོས་གོས་སྲབ་པོར་ལྷན་པ་མི་རྒྱག ལྷན་པ་བརྒྱབ་ན་རས་མཐུག་པོ་དེས་གོས་སྲབ་པོའི་སྲུབས་ཁ་ཇེ་ཆེར་འགྲོའོ། ");
INSERT INTO bod_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ཡང་མི་སུ་ཞིག་ཡིན་ཡང་རྒུན་འབྲུམ་ཆང་གསར་པ་པགས་པའི་ཁུག་མ་རྙིང་པའི་ནང་བསྙལ་བར་མི་བྱ་སྟེ། གལ་ཏེ་བསྙལ་ཚེ་ཆང་འཕེལ་ནས་ཁུག་མ་རྙིང་པ་གས་ཏེ་ཆང་དང་ཁུག་མ་གཉིས་ཀ་འཕྲོ་བརླག་འགྲོ་བར་འགྱུར། རྒུན་འབྲུམ་ཆང་གསར་པ་དེ་ཁུག་མ་གསར་པའི་ནང་དུ་བླུགས་ནས་གཉིས་ཀ་འཕྲོ་བརླག་མ་འགྲོ་བར་གནས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ཁོང་གིས་ཁོ་ཚོར་དེ་ལྟར་གསུང་སྐབས་དེར་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་གི་དཔོན་པོ་ཞིག་འོངས་ནས་ཁོང་གི་ཞབས་ལ་གཏུག་སྟེ་“ངའི་བུ་མོ་ད་ལྟ་རང་ཤི་སོང༌། འོན་ཏེ་ཁྱེད་ཕེབས་ནས་ཁོ་མོའི་ལུས་སྟེང་ལ་ཕྱག་འཇོག་པར་མཛད་ན་དེ་ནས་ཁོ་མོ་གསོན་པར་འགྱུར་”ཞེས་ཞུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ཡེ་ཤུ་བཞེངས་ནས་ཉེ་གནས་དང་མཉམ་དུ་མི་དེའི་རྗེས་སུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","གློ་བུར་དུ་བུད་མེད་ལོ་བཅུ་གཉིས་ཀྱི་བར་དུ་ལུས་ནས་ཁྲག་འཛིར་བའི་ནད་ཕོག་པ་གཅིག་ཁོང་གི་རྒྱབ་ཏུ་ཡོང་ཞིང༌། ཁོང་གི་སྟོད་གོས་ཀྱི་མཐའ་འཛར་ལ་རེག ");
INSERT INTO bod_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","གང་ཡིན་ཞེ་ན། གལ་སྲིད་ངས་ཁོང་གི་ན་བཟའ་གཅིག་པུ་ལ་རེག་ན་ང་ནད་ལས་ཐར་འོང་བསམས། ");
INSERT INTO bod_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ཡེ་ཤུས་སྐུ་ཕྱིར་འཁོར་ཏེ་ཁོ་མོར་གཟིགས་པ་དང་“བུ་མོ། བློ་བདེ་བར་གྱུར་ཅིག ཁྱོད་ཀྱི་དད་པས་ཁྱོད་རང་ནད་ལས་ཐར་བ་ཡིན་”ཞེས་གསུངས་མ་ཐག་ཁོ་མོ་ནད་ལས་ཐར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ཡེ་ཤུ་དཔོན་པོའི་ཁྱིམ་ལ་ཕེབས་དུས་ཁོང་གིས་གླིང་བུ་གཏོང་མཁན་དང༌། མི་ཚོགས་ཀྱིས་ཅ་ཅོ་འདོན་པ་གཟིགས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ཁོང་གིས་ཁོ་རྣམས་ལ་“བུ་མོ་དེ་ཤི་མེད་པར་གཉིད་ཁུག་འདུག་པས་འདི་ནས་ཕར་སོང་ཞིག་”ཅེས་གསུངས་པས། ཁོ་ཚོས་ཁོང་ལ་ཁྲེལ་དགོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","འོན་ཀྱང་མི་ཚོགས་ཕྱི་རོལ་ཏུ་བཏོན་ནས་ཁོང་ཁྱིམ་ནང་དུ་ཕེབས་ཏེ་བུ་མོའི་ལག་པ་ནས་འཇུས་པས་བུ་མོ་ཡར་ལངས། ");
INSERT INTO bod_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","གནས་ཚུལ་འདི་ས་ཕྱོགས་དེའི་གང་སར་ཁྱབ། ");
INSERT INTO bod_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ཡེ་ཤུ་དེ་ནས་ཕར་ཕེབས་པའི་ཚེ། མི་ལོང་བ་གཉིས་ཁོང་གི་རྗེས་སུ་འབྲངས་ཏེ་སྐད་ཆེན་པོས་“ཀྱེ་རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས། ང་ཚོ་ལ་ཐུགས་རྗེས་གཟིགས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ཁོང་ཁྱིམ་ལ་ཞུགས་དུས་མི་ལོང་བ་དེ་གཉིས་ཁོང་གི་མདུན་དུ་ཡོང༌། ཁོང་གིས་ཁོ་ཚོར་“ངས་དོན་འདི་སྒྲུབ་པར་ཡིད་ཆེས་སམ་”ཞེས་གསུངས་པས་ཁོ་ཚོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཡིད་ཆེས་སོ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","དེ་ནས་ཁོང་གིས་ཁོ་ཚོའི་མིག་ཟུང་ལ་རེག་སྟེ་ཁོ་གཉིས་ལ་“ཁྱེད་ཚོའི་ཡིད་ཆེས་བཞིན་དུ་སྒྲུབ་པར་འགྱུར་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ཁོ་ཚོའི་མིག་ཕྱེ། ཡེ་ཤུས་ཁོ་ཚོར་“དོན་འདི་མི་གཞན་ལ་མ་ཤོད་ཅིག་”ཅེས་ནན་གྱིས་བསྐུལ་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","མི་དེ་གཉིས་ཕྱི་རོལ་ཏུ་ཐོན་པ་དང༌། གཏམ་མང་པོ་བཤད་པས་ཁོང་གི་སྙན་གྲགས་ཡུལ་དེའི་གང་སར་ཁྱབ། ");
INSERT INTO bod_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ལོང་བ་དེ་གཉིས་ཕར་ཕྱིན་རྗེས་མི་གཞན་པས་གདོན་འདྲེས་བཟུང་ནས་སྐད་ཆ་ཤོད་མི་ཐུབ་པའི་མི་ཞིག་ཁོང་གི་མདུན་དུ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ཡེ་ཤུས་གདོན་འདྲེ་དེ་ཕྱིར་བསྐྲད་རྗེས་ལྐུགས་པ་དེས་སྐད་ཆ་བཤད་པས་མི་ཚོགས་ཡ་མཚན་ཆེན་པོ་སྐྱེས་ནས་“ཡི་སི་ར་ཨེལ་ཡུལ་ལ་དེ་བཞིན་དུ་ནམ་ཡང་མ་མཐོང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","འོན་ཀྱང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་“བདུད་ཀྱི་རྒྱལ་པོ་ལ་བརྟེན་ནས་ཁོས་གདོན་འདྲེ་སྐྲོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","དེ་ནས་ཡེ་ཤུ་གྲོང་ཁྱེར་དང་གྲོང་གསེབ་ཐམས་ཅད་བརྒྱུད་ནས་ཕེབས་ཏེ། ཁོ་ཚོའི་འདུ་ཁང་རྣམས་ལ་ཆོས་བསྟན་པ་དང༌། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་བསྒྲགས་པ། ནད་རིགས་ཀུན་སེལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","མི་ཚོགས་མང་པོ་ནི་རྫི་བོ་མེད་པའི་ལུག་དང་འདྲ་བར་རོགས་མེད་པ་དང་སྡུག་ཕོག་ཡོད་པར་གཟིགས་པས། ཁོང་གི་ཐུགས་ལ་སྙིང་རྗེ་འཁྲུངས། ");
INSERT INTO bod_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ཉེ་གནས་རྣམས་ལ་“སྟོན་ཐོག་རྔ་རྒྱུ་མང་པོ་ཡོད་ཀྱང་ལས་ཀ་བྱེད་མཁན་མང་པོ་མེད་པས། ");
INSERT INTO bod_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ལོ་ཏོག་གི་བདག་པོར་སྟོན་ཐོག་སྡུད་མཁན་རྣམས་རང་གི་ས་ཞིང་ལ་གཏོང་བར་ཞུས་ཤིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ཡེ་ཤུས་ཉེ་གནས་བཅུ་གཉིས་པོ་བོས་ནས་ཁོ་ཚོར་གདོན་འདྲེ་མི་གཙང་བ་སྐྲོད་པ་དང༌། ནད་རིགས་ཀུན་སེལ་བའི་དབང་ཆ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","སྐུ་ཚབ་བཅུ་གཉིས་པོའི་མིང་ནི། དང་པོ་སི་མོན་མིང་གཞན་པེ་ཏྲོ་ཡང་ཟེར་བ་དང༌། ཁོའི་གཅུང་པོ་ཨན་དྲི་ཡཱ། ཟེ་བད་ཡཱ་ཞེས་ཟེར་བའི་བུ་ཡ་ཀོབ་དང༌། ཁོའི་གཅུང་པོ་ཡོ་ཧ་ནན། ");
INSERT INTO bod_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ཕི་ལིབ་དང༌། པར་ཐོ་ལོ་མཱ་དང༌། ཐོ་མཱ། ཁྲལ་སྡུད་མཁན་མད་ཐཱ། ཨལ་ཕཱ་ཞེས་པ་དེའི་བུ་ཡ་ཀོབ་དང༌། ཐཱ་ཨད་དེ་ཨ་སི། ");
INSERT INTO bod_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","རྒྱལ་གཅེས་པའི་ཕྱོགས་ཁག་གི་ཁོངས་མི་སི་མོན་དང༌། ཡེ་ཤུ་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ཡེ་ཤུས་བཀའ་འདི་ལྟར་གནང་བའི་རྗེས་སུ་བཅུ་གཉིས་པོ་དེ་ཕྱི་རུ་མངགས་ཏེ་“ཡ་ཧུ་དཱ་པ་མིན་པའི་དཀྱིལ་ལའམ། ས་མར་ཡཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་གང་ཞིག་ལ་མི་འགྲོ་བར། ");
INSERT INTO bod_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ཡི་སི་ར་ཨེལ་གྱི་ཁྱིམ་གྱི་ལུག་བརླག་པ་རྣམས་ཀྱི་རྩ་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ལམ་བར་དུ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འཐོན་ལ་ཉེ་བར་སླེབས་སོ་ཞེས་འཆད་དེ་འཕྲིན་བཟང་ཁྱབ་བསྒྲགས་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ནད་པ་གསོ་བར་བྱེད། གཤིན་པོ་རྣམས་སླར་གསོན་པར་བྱེད། མཛེ་ནད་ཅན་དག་པར་བྱེད། གདོན་འདྲེ་རྣམས་སྐྲོད། ཁྱེད་ཚོར་རིན་མེད་པར་ཐོབ་པས། རིན་མེད་པར་སྟེར། ");
INSERT INTO bod_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ཁྱེད་ཀྱི་སྐེ་རགས་ལ་གསེར་རམ། དངུལ། ཟངས་མ་འཁྱེར་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ཡང་ལམ་གྱི་ཕྱིར་ཁུག་མའམ། ཕྱི་གོས་འཐོལ་པ། ལྷམ། དབྱུག་པ་མ་འཁུར། གང་ཡིན་ཞེ་ན། ལས་བྱེད་མཁན་ལ་ཟས་འཐོབ་པར་འོས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ཁྱེད་ཚོ་གྲོང་ཁྱེར་རམ། གྲོང་གསེབ་གང་དུ་ཞུགས་ནའང༌། དེའི་ནང་ཁྱིམ་ཚང་འོས་པ་ཞིག་བཙལ་ནས། གྲོང་ཚོ་དེ་ནས་ཁ་མ་བྲལ་བར་དུ་དེར་སྡོད། ");
INSERT INTO bod_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ཁྱིམ་ཚང་དེར་འཛུལ་སྐབས་དེའི་ནང་མི་རྣམས་ལ་འཚམས་འདྲི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ཁོ་ཚོ་འོས་པ་ཡིན་ན་ཁྱེད་ཀྱི་ཞི་བདེ་ཁོ་རྣམས་ལ་འབབ་པར་བྱེད། འོས་པ་མིན་ན་ཞི་བདེ་དེ་ཁྱེད་ལ་ཕྱིར་ལོག་ཡོང་དུ་འཇུག ");
INSERT INTO bod_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","སུ་ཞིག་གིས་ཁྱེད་ཚོར་གནས་ཚང་མི་གཏོང་ཞིང་ཁྱོད་ཚོས་ཆོས་བསྒྲགས་པ་ལའང་མི་ཉན་ན། ཁྱེད་ཚོ་ཁྱིམ་ཚང་ངམ་གྲོང་ཁྱེར་དེ་ནས་འཐོན་པའི་སྐབས་སུ། ཁོ་རྣམས་ལ་དོན་དེར་འགན་ཁུར་དགོས་པར་བདེན་དཔང་བྱེད་པའི་ཆེད་དུ་རྐང་པའི་ཐོག་གི་ས་རྡུལ་སྤྲུགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྲིམས་གཅོད་པའི་ཉིན་མོར་གྲོང་ཁྱེར་དེའི་ཉེས་ཆད་སཱ་དོམ་དང་གྷོ་མོ་ར་གྲོང་ཁྱེར་ལས་ལྗིད་བ་འཕོག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ཉོན་ཞིག ངས་སྤྱང་ཀིའི་ཁྲོད་དུ་ལུ་གུ་ལྟར་ཁྱེད་ཚོ་མངག་པས། ཁྱེད་ཚོ་སྦྲུལ་ལྟར་མགོ་གྲུང་པོ་དང༌། ཕུག་རོན་ལྟར་གནོད་མེད་པར་འགྱུར་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","མི་རྣམས་ལ་དོགས་ཟོན་གྱིས་ཤིག ཁོ་ཚོས་ཁྱེད་ཚོ་ཁྲིམས་ར་ལ་གཏོད་ཅིང༌། ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ལ་བརྡུང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ཁོ་ཚོ་དང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་དཔང་པོ་བྱེད་པའི་ཕྱིར། ངའི་དོན་དུ་ཁྱེད་ཚོ་ས་གནས་དཔོན་པོ་དང་རྒྱལ་པོ་རྣམས་ཀྱི་དྲུང་དུ་འཁྲིད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ཁོ་ཚོས་ཁྱེད་རྣམས་གཏོད་པའི་སྐབས་སུ། ཁྱེད་ཚོས་གང་ཟེར་རམ་ཇི་ལྟར་ཟེར་དགོས་པ་དེར་སེམས་ཁྲལ་མ་བྱེད། གང་ལགས་ཤེ་ན། དེའི་དུས་སུ་ཁྱེད་ཚོས་གང་ཟེར་དགོས་པ་ནི་ཁྱེད་རྣམས་ལ་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","རྒྱུ་མཚན་ནི་གསུང་མཁན་ཁྱེད་ཚོ་མ་ཡིན་ཏེ། ཁྱེད་ཀྱི་ཡབ་ཀྱི་དམ་པའི་ཐུགས་ཉིད་ཁྱེད་ཚོའི་ནང་དུ་བཞུགས་པ་དེ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","གཅེན་གཅུང་གིས་གཅེན་གཅུང་དང༌། ཨ་ཕས་རང་གི་བུ་ཡང་གསོད་པའི་ཕྱིར་གཏད་པར་འགྱུར། ཕྲུ་གུ་རྣམས་ཀྱིས་ཀྱང་ཕ་མ་དགྲ་རུ་བཟུང་སྟེ་གསོད་དུ་འཇུག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ཡང་ངའི་མིང་གི་དོན་དུ་མི་ཐམས་ཅད་ཀྱིས་ཁྱེད་ཚོ་ལ་སྡང་བར་བྱ། འོན་ཀྱང་ཚེའི་མཐའ་མཇུག་བར་དུ་བཟོད་པ་སྒོམ་མི་དེ་ལ་ཐར་པ་འཐོབ་ངེས་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ཁོ་ཚོས་ཁྱེད་ཚོར་གྲོང་ཁྱེར་ཞིག་ལ་གནོད་པ་བྱེད་པའི་ཚེ་གྲོང་ཁྱེར་གཞན་ཞིག་ལ་བྲོས། ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཡི་སི་ར་ཨེལ་གྱི་གྲོང་ཁྱེར་ཐམས་ཅད་འཁོར་མ་ཚར་བའི་སྔོན་ལ་མིའི་རིགས་ཀྱི་བུ་འབྱོན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ཉེ་གནས་རང་གི་སློབ་དཔོན་ལས་ཆེ་བ་མ་ཡིན་ཞིང༌། གཡོག་པོ་རང་གི་དཔོན་པོ་ལས་གལ་ཆེ་བ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ཉེ་གནས་རང་གི་སློབ་དཔོན་དང༌། གཡོག་པོ་རང་གི་དཔོན་པོ་དང་འདྲ་བ་ཡིན་ན་ཆོག ཁྱིམ་བདག་ལ་པེ་ཨིལ་བཟི་པད་ཅེས་ཟེར་ན། ནང་མི་རྣམས་ལ་དེ་ལས་ལྷག་པར་སྨད་ར་གཏོང་བར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","དེའི་ཕྱིར་ཁོ་ཚོར་མ་འཇིགས་ཤིག གང་ཡིན་ཟེར་ན། སྦས་པ་ཡིན་པ་ཐམས་ཅད་མངོན་པར་འགྱུར་བ་དང༌། གསང་བ་ཡིན་པ་ཐམས་ཅད་ཀྱང་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ངས་ཁྱེད་རྣམས་ལ་མུན་པར་གང་བཤད་པ་དེ་ཁྱེད་ཚོས་འོད་ཀྱི་ནང་དུ་འཆད་ཅིང༌། གང་ཤུབ་ཤུབ་ཏུ་ཐོས་པ་དེ་ཁྱེད་ཚོས་ཁང་པའི་ཐོག་ཁ་ནས་སྒྲོག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ལུས་གསོད་ཀྱང་སེམས་གསོད་མི་ཐུབ་པ་རྣམས་ལ་མ་འཇིགས་ཤིག ལུས་སེམས་གཉིས་པོ་དམྱལ་ཁམས་སུ་མེད་པར་མཛད་ཐུབ་མཁན་ཁོང་ལ་འཇིགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ཁང་བྱིའུ་གཉིས་ཟངས་ཀྱི་སྒོར་མོ་གཅིག་ལ་མི་འཚོང་ངམ། འོན་ཀྱང་ཁྱེད་ཚོའི་ཡབ་དཀོན་མཆོག་གི་དགོངས་པ་ལྟར་མིན་ན་དེ་རྣམས་ལས་གཅིག་ཀྱང་ས་ལ་མི་ལྷུང༌། ");
INSERT INTO bod_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ཁྱེད་ཀྱི་མགོའི་སྐྲ་ཐམས་ཅད་ཀྱང་གྲངས་ཀ་བཀྱོན་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","མ་འཇིགས་ཤིག ཁང་བྱིའུ་མང་པོ་ལས་ཁྱེད་ཚོ་རིན་ཐང་ཆེའོ། ། ");
INSERT INTO bod_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","དེའི་ཕྱིར་སུས་ཀྱང་མི་གཞན་གྱི་མདུན་དུ་ང་ཁས་ལེན་ན། ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱི་མདུན་དུ་ངས་ཀྱང་མི་དེ་ཁས་ལེན་བྱེད་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","འོན་ཀྱང་སུས་མི་གཞན་གྱི་མདུན་དུ་ང་ཁས་མི་ལེན་ན། ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱི་མདུན་དུ་ངས་ཀྱང་མི་དེ་ཁས་ལེན་བྱེད་པར་མི་བྱ། ");
INSERT INTO bod_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ང་ནི་ས་ལ་ཞི་བདེ་སྐྱེལ་བར་ཡོང་བ་ཡིན་མ་སོམས་ཤིག ཞི་བདེ་སྐྱེལ་བར་མ་ཡོང་གིས། རལ་གྲི་སྐྱེལ་བར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","བུ་དང་ཕ་གཉིས་མ་དང་བུ་མོ་གཉིས། ། མནའ་མ་སྒྱུག་མོ་བཅས་ནི་ཕན་ཚུན་བར། ། ཁ་གཏད་འགྱུར་ཕྱིར་ང་ནི་འདི་གར་འོངས། ། ");
INSERT INTO bod_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","མི་ཞིག་སོ་སོའི་དགྲ་བོ་གང་ཡིན་པ། ། དེ་ནི་སོ་སོའི་ནང་མིའི་ཁྲོད་དུ་ཡོང༌། ། ");
INSERT INTO bod_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ང་ལས་ཕའམ་མ་གཅེས་པར་བཟུང་ན་ང་ལ་མི་འོས་ཤིང༌། ང་ལས་བུའམ་བུ་མོ་གཅེས་པར་བཟུང་ན་ང་ལ་མི་འོས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ཡང་སུ་ཞིག་གིས་རང་གི་རྒྱང་ཤིང་མ་འཁུར་བར་ང་ཡི་རྗེས་སུ་འབྲངས་ན། དེ་ང་ལ་མི་འོས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","སུ་ཡང་རང་གི་སྲོག་ལ་ཆགས་པ་དེ་བརླག་པར་འགྱུར། སུ་ཡང་ངའི་དོན་དུ་རང་གི་སྲོག་བཏང་ན་དེ་སྐྱོབ་པར་འགྱུར་རོ། །” ");
INSERT INTO bod_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“སུས་ཀྱང་ཁྱེད་ཚོ་བསུས་ན་མི་དེས་ངའང་བསུ་ཞིང༌། ང་རང་བསུ་བའི་མི་དེས་ང་མངག་མཁན་ཡང་བསུ། ");
INSERT INTO bod_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","སུས་ཀྱང་ལུང་སྟོན་པ་ཡིན་པས་ལུང་སྟོན་པ་ཞིག་བསུས་ན་མི་དེར་ལུང་སྟོན་པའི་བྱ་དགའ་འཐོབ་ངེས་ཡིན་ཞིང༌། སུས་ཀྱང་དྲང་ལྡན་གྱི་མི་ཞིག་ཡིན་པས་དྲང་ལྡན་གྱི་མི་བསུས་ན་མི་དེར་དྲང་ལྡན་གྱི་མིའི་བྱ་དགའ་འཐོབ་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། སུས་ཀྱང་ཉེ་གནས་ཡིན་པའི་ཆ་ནས་ཆུང་ངུ་འདིའི་ཁྲོད་ནས་མི་ཞིག་ལ་ཆུ་གྲང་མོ་ཕོར་པ་གང་སྟེར་མཁན་དེ་ལ་ཡང་བྱ་དགའ་བརླག་པར་མི་འགྱུར་རོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ཡེ་ཤུས་ཁོང་གི་ཉེ་གནས་བཅུ་གཉིས་པོ་ལ་སློབ་སྟོན་མཛད་ཟིན་རྗེས། ཁོ་ཚོའི་གྲོང་ཁྱེར་རྣམས་ལ་ཆོས་སྟོན་དང་འཕྲིན་སྒྲོག་པའི་ཕྱིར་ས་ཆ་དེ་ནས་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་བཙོན་ཁང་ལ་ཡོད་དུས་མཱ་ཤི་ཀ་ཡིས་མཛད་པའི་བྱ་བའི་སྐོར་ཐོས་པས་ཁོའི་སློབ་མ་རྣམས་བཏང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ཁོང་ལ་“ཁྱེད་འབྱོན་པར་འགྱུར་ཞེས་བྱ་བ་དེ་ཡིན་ནམ། ཡང་ན་ང་ཚོ་གཞན་ཞིག་སྒུག་པར་བྱ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ལན་དུ་ཡེ་ཤུས་“སོང་ལ། ཁྱེད་ཀྱིས་གང་ཐོས་པ་དང་མཐོང་བ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ལོང་བས་མཐོང་བ། ཞ་བོ་འགྲོ་བ། མཛེ་ནད་ཅན་དག་པར་འགྱུར་བ། འོན་པས་ཐོས་པ། གཤིན་པོ་རྣམས་གསོན་པོར་ལངས་པར་འགྱུར་བ། དབུལ་ཕོངས་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་པ་སོགས་ཡོ་ཧ་ནན་ལ་ཤོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ངའི་རྐྱེན་གྱིས་དད་པ་མི་ཉམས་པ་ནི་བདེའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ཁོ་ཚོ་ཕར་སོང་དུས་ཡེ་ཤུས་མི་ཚོགས་ལ་ཡོ་ཧ་ནན་གྱི་སྐོར་འདི་ལྟར་གསུངས་“ཁྱེད་ཚོས་ཅི་ཞིག་ལྟ་རུ་དབེན་སྟོང་ལ་སོང༌། རླུང་གིས་གཡོ་བའི་འདམ་རྩྭ་ཞིག་ལྟ་རུ་སོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","འོ་ན་ཁྱེད་ཚོས་ཅི་ཞིག་ལྟ་རུ་སོང༌། མི་གོས་སྤུས་ལེགས་གྱོན་པ་ཞིག་ལ་ལྟ་རུ་སོང་ངམ། གོས་སྤུས་ལེགས་གྱོན་པ་རྣམས་ནི་རྒྱལ་པོའི་ཕོ་བྲང་ལ་སྡོད་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ཁྱེད་ཚོས་ཅི་ཞིག་ལ་ལྟ་རུ་སོང༌། ལུང་སྟོན་པ་ཞིག་ལ་ལྟ་རུ་སོང་ངམ། དེ་ལགས་ཡིན། ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ལུང་སྟོན་པ་ལས་ལྷག་པ་ཞིག་ལ་ལྟ་རུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ཁོང་གི་སྐོར་ལ་དཀོན་མཆོག་གི་དམ་པའི་གསུང་རབ་ནང་དུ་འདི་ལྟར་གསུངས། ལྟོས་ཤིག ང་ཡི་ཕོ་ཉ་ཁྱེད་ཀྱི་མདུན་དུ་གཏོང༌། ། དེ་ཡིས་ཁྱེད་ཀྱི་ལམ་ནི་བསལ་བར་བྱ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། བུད་མེད་རྣམས་ལས་སྐྱེས་པའི་མི་ཐམས་ཅད་ཀྱི་ནང་ནས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་ལས་ཆེ་བ་གཅིག་ཀྱང་མེད། འོན་ཀྱང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ལ་མི་ཆུང་ཤོས་ཁོང་ལས་ཆེའོ། ");
INSERT INTO bod_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་དུས་ནས་ད་ལྟ་བར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་རྒོལ་བའི་སྡུག་བསྔལ་མྱོང་བ་དང༌། རྒོལ་མཁན་རྣམས་ཀྱིས་བཙན་ཤེད་ཀྱིས་འཛིན། ");
INSERT INTO bod_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","རྒྱུ་མཚན་ནི་ལུང་སྟོན་པ་ཐམས་ཅད་དང༌། ཆོས་ཁྲིམས་ཀྱིས་ཡོ་ཧ་ནན་གྱི་དུས་བར་དུ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་སྐོར་ལུང་བསྟན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ཁྱེད་ཚོས་དང་ལེན་བྱེད་པར་འདོད་ན། ཡོ་ཧ་ནན་ནི་འབྱུང་རྒྱུ་ཡིན་པའི་ཨེ་ལི་ཡཱ་དེ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ངས་གང་ཞིག་གིས་དུས་རབས་འདིའི་མི་རྣམས་ལ་སྡུར་བར་བྱ། དེ་ཚོ་ཁྲོམ་རར་སྡོད་པའི་ཕྲུ་གུ་རྣམས་ཀྱིས་རང་གི་གྲོགས་པོ་རྣམས་ལ་འབོད་དེ། ");
INSERT INTO bod_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ཁྱོད་ཕྱིར་གླིང་བུ་བཏང་ན་ཡང༌། ། ཁྱོད་ཀྱིས་ཞབས་བྲོ་མ་བརྒྱབ་ལ། ། ཁྱོད་ཆེད་མྱ་ངན་གླུ་བླངས་ཀྱང༌། ། ཁྱོད་ཚོས་ངུ་བར་མ་བྱས་སོ། ། ཞེས་པ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","གང་ལགས་ཟེར་ན། ཡོ་ཧ་ནན་ཕེབས་དུས་ཟ་འཐུང་མི་བྱེད་པར་དེ་ཚོས་འདྲེ་ཞུགས་པ་ཞིག་ཡིན་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","མིའི་རིགས་ཀྱི་བུ་ཕེབས་དུས་ཟ་འཐུང་བྱེད་པར་དེ་ཚོས་ལྟོས་ཤིག ཁོ་ནི་ལྟོགས་རྔམ་ཅན་དང༌། ར་བཟི་ཅན། ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཉེས་ཅན་གྱི་གྲོགས་པོ་ཞིག་ཡིན། འོན་ཀྱང་ཤེས་རབ་ནི་དེའི་བྱ་བ་ཡིས་ཡང་དག་པ་ཡིན་པར་ཁུངས་སྐྱེལ་ལོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","དེ་ནས་གྲོང་ཁྱེར་དེ་ཚོར་ཁོང་གིས་ངོ་མཚར་གྱི་མཛད་པ་མང་ཆེ་བ་མཛད་ཀྱང་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་མི་སྒྱུར་བས། གྲོང་ཁྱེར་དེ་ཚོའི་མི་རྣམས་ལ་བཀའ་བཀྱོན་གནང་སྟེ་གསུངས་པ་ ");
INSERT INTO bod_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“གལ་ཏེ་གྲོང་ཁྱེར་ཐཱ་ཨེར་དང་ཚི་དོན་ལ་བྱུང་བའི་ངོ་མཚར་ཅན་གྱི་རྟགས་ཁྱོད་ཚོར་བྱུང་ཡོད་ན། དེ་ཚོ་སྔོན་ནས་སེམས་བསྒྱུར་བའི་རྟགས་སུ་ལུས་ལ་རྩྭ་རས་གྱོན་པ་དང་གོ་ཐལ་ཁྲོད་དུ་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བ་ཡིན་པས། ཀྱེ་ཀོ་ར་ཟིན་དང་པེ་སད་དཱ་པ་རྣམས། ཁྱོད་ཚོར་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། ཁྲིམས་གཅོད་བྱེད་པའི་ཉིན་མོར་ཁྱོད་རྣམས་ལས་ཐཱ་ཨེར་དང་ཚི་དོན་གཉིས་ལ་བཟོད་པར་སླ་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ཀྱེ་ཀ་ཕར་ན་ཧུམ་པ་རྣམས། ཁྱོད་ཞིང་ཁམས་སུ་འཕག་པར་འགྱུར་བ་ཡིན་ནམ། མ་ཡིན། ཁྱོད་དམྱལ་བའི་གཏིང་སར་འབེབས་པར་འགྱུར། རྒྱུ་མཚན་ནི་ཁྱོད་ཚོའི་མདུན་དུ་མཛད་པའི་ངོ་མཚར་བའི་དོན་སཱ་དོམ་གྲོང་ཁྱེར་དུ་བྱུང་ན། དེ་ད་ལྟའི་བར་དུ་གནས་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། ཁྲིམས་གཅོད་བྱེད་པའི་ཉིན་མོར་ཁྱོད་རྣམས་ལས་སཱ་དོམ་ས་ཁུལ་ལ་བཟོད་པར་སླ་བར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","དེའི་དུས་སུ་ཡེ་ཤུས་“ཀྱེ་ཡབ་འཇིག་རྟེན་ཁམས་ཀྱི་བདག་པོ་ལགས། ཁྱེད་ཀྱིས་དོན་འདི་རྣམས་ཤེས་ཡོན་དང་ལྡན་པ་ཡིན་སྙམ་པའི་མི་རྣམས་ལ་སྦས་པ་གནང་ནས་ཕྲུ་གུ་ལྟ་བུའི་རྣམས་ལ་མངོན་པར་མཛད་པས་ཁྱེད་ལ་བསྟོད་པ་འབུལ་ལོ། ");
INSERT INTO bod_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ཡབ་ལགས། དེ་ནི་ཁྱེད་ཀྱི་ཐུགས་རྗེ་དང་ལྡན་པའི་དགོངས་པ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ངའི་ཡབ་ཀྱིས་ང་ལ་ཡོད་དོ་ཅོག་གཏད་བྱུང༌། ཡབ་མ་གཏོགས་པར་སྲས་སུ་ཡིན་པ་སུས་ཀྱང་མི་ཤེས། སྲས་དང༌། སྲས་ཀྱིས་སྟོན་པར་འདོད་པའི་མི་མ་གཏོགས་པར། ཡབ་སུ་ཡིན་པ་སུས་ཀྱང་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ཁྱེད་ཡིད་ཐང་ཆད་པ་དང་ཁུར་ཆེན་གྱིས་གནོན་པ་ཐམས་ཅད་ངའི་རྩར་ཤོག ངས་ཁྱེད་ལ་ངལ་གསོ་སྟེར་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ངའི་གཉའ་ཤིང་འཁུར་ཞིང༌། ང་ལས་ཤེས་པར་གྱིས། ང་ནི་སེམས་དུལ་ཞིང་སྙེམས་ཆུང་ཡིན་པས་ཁྱེད་ཚོའི་སེམས་ལ་ངལ་གསོ་འཐོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","རྒྱུ་མཚན་ནི་ངའི་གཉའ་ཤིང་འཇམ་ཞིང་ངའི་ཁུར་ཡང་ཡང་མོ་ཡིན་པས་སོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","དེའི་དུས་སུ་ངལ་གསོ་བའི་ཉིན་མོ་ཞིག་ལ་ཡེ་ཤུ་ཞིང་ཁ་ཞིག་བརྒྱུད་ནས་ཕེབས་སྐབས། ཁོང་གི་ཉེ་གནས་རྣམས་ལྟོགས་པས་འབྲུ་ཡི་སྙེ་མ་བཏོགས་ཏེ་ཟ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ཕཱ་རུ་ཤི་པས་དེ་མཐོང་ནས་ཁོང་ལ་“ལྟོས་ཤིག ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ཀྱིས་ངལ་གསོ་བའི་ཉིན་མོར་བྱེད་མི་ཆོག་པའི་ལས་བྱེད་བཞིན་ཡོད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ཁོང་གིས་ཁོ་ཚོར་“རྒྱལ་པོ་དཱ་བིད་དང་ཁོང་གི་འཁོར་གཡོག་རྣམས་ཀྱིས་ལྟོགས་པའི་ཚེ་ཅི་ཞིག་བྱས་པ་དེ་ཡང་ཁྱེད་ཚོས་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ཁོང་དཀོན་མཆོག་གི་མཆོད་ཁང་ལ་ཕེབས་ཏེ་དཀོན་མཆོག་གི་སྐུ་མདུན་གྱི་བག་ལེབ་བླངས་ནས་འཁོར་གཡོག་དང་མཉམ་དུ་བཟས། བཀའ་ཁྲིམས་ལྟར་ན་བག་ལེབ་དེ་ཡ་ཧུ་དཱ་པའི་བླ་མ་རྣམས་ལས་གཞན་སུས་ཀྱང་ཟ་མི་ཆོག ");
INSERT INTO bod_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ཡང་ན་ངལ་གསོ་བའི་ཉིན་མོར་མཆོད་ཁང་གི་བླ་མ་རྣམས་ཀྱིས་ངལ་གསོ་བའི་ཁྲིམས་དང་འགལ་ཡང་སྐྱོན་མེད་པ་ཡིན་པར་ཁྱེད་ཚོས་ཆོས་ཁྲིམས་ཀྱི་མདོ་ལ་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། མཆོད་ཁང་ལས་ཆེ་བ་ཞིག་འདིར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ང་ནི་མཆོད་པ་ལ་མི་དགའ་བར་སྙིང་རྗེའི་སེམས་ལ་དགའོ་ཞེས་གསུངས་པའི་དོན་རྟོགས་པ་ཡིན་ན། ཁྱེད་ཚོས་སྐྱོན་མེད་པ་རྣམས་ལ་སྐྱོན་འདོགས་བྱས་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","གང་ཡིན་ཞེ་ན། མིའི་རིགས་ཀྱི་བུ་ནི་ངལ་གསོ་བའི་ཉིན་གྱི་གཙོ་བོ་ཡིན་པས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ཡེ་ཤུ་ས་ཆ་དེ་ནས་ཐོན་ཏེ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ལག་པ་འཁུམས་པ་ཞིག་དེ་རུ་ཡོད་པས་ཁོ་ཚོས་ཡེ་ཤུ་ལ་སྐྱོན་འདོགས་བྱེད་པའི་ཕྱིར་ཁོང་ལ་“ངལ་གསོ་བའི་ཉིན་མོར་ནད་བཅོས་ཆོག་གམ་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོའི་ནང་སུ་ཞིག་ལ་ལུག་གཅིག་ཡོད་པ་དེ་ངལ་གསོ་བའི་ཉིན་མོར་ས་དོང་ལ་ལྷུངས་ན་དེ་བཟུང་ནས་མི་འདོན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ལུག་གཅིག་ལས་མི་ནི་རིན་ཆེ་བས། ངལ་གསོ་བའི་ཉིན་མོར་ལས་བཟང་པོ་བྱེད་ཆོག་གོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","དེ་ནས་ཁོང་གིས་མི་དེར་“ལག་པ་རྐྱོངས་ཤིག་”ཅེས་གསུངས་ཏེ། ཁོས་ལག་པ་བརྐྱངས་ཤིང་ནད་གསོས་པར་གྱུར་བས་ལག་པ་ཡ་གཅིག་དང་འདྲ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","དེ་ནས་ཕཱ་རུ་ཤི་པ་རྣམས་ཕྱི་ལ་སོང་ནས་ཡེ་ཤུ་དགྲོང་རྒྱུའི་ངན་ཇུས་བྱས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ཁོང་གིས་དེའི་སྐོར་མཁྱེན་ནས་ས་ཆ་དེ་དང་ཁ་བྲལ། མི་མང་པོ་ཞིག་ཁོང་གི་རྗེས་སུ་འབྲངས། ཁོང་གིས་ནད་པ་ཐམས་ཅད་གསོས་པར་མཛད་ཅིང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","མི་དེ་ཚོ་ལ་ཁོང་མངོན་པར་མི་བྱེད་པའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","འདི་ནི་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡི་ལུང་བསྟན་སྒྲུབ་པའི་ཆེད་དུ་ཡིན། ཁོང་གིས། ");
INSERT INTO bod_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ལྟོས་དང་ང་ཡིས་བདམས་པའི་ཞབས་ཕྱི་ནི། ། ང་ཡི་གཅེས་པར་འོས་ལ་སེམས་ནས་དགའ། ། ང་ཡིས་ཐུགས་ཉིད་ཁོང་ལ་སྤྲོད་པར་བྱ། ། ཁོང་གིས་ཕྱི་པ་རྣམས་ལ་ཞལ་ལྕེ་བསྒྲག ། ");
INSERT INTO bod_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","རྩོད་པར་མི་བྱེད་ཟང་ཟིང་སྒྲ་ཡང་མེད། ། སྲང་ལམ་ནང་ན་ཁོང་གི་གསུང་མི་ཐོས། ། ");
INSERT INTO bod_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ཆག་ལ་ཁད་ཀྱི་འདམ་སྨྱུག་གཅོག་མི་མཛད། ། ནུབ་ལ་ཁད་ཀྱི་སྒྲོན་མེ་མི་གསོད་དེ། ། དྲང་བདེན་ཁྲིམས་དེ་མཐའ་མཇུག་རྒྱལ་བའི་བར། ། ");
INSERT INTO bod_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ཁོང་གི་མཚན་ལ་ཕྱི་པས་རེ་བ་བྱེད། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","དེའི་ཚེ་གདོན་འདྲེས་བཟུང་བས་སྐད་ཆ་ཤོད་མི་ཐུབ་པའི་ལོང་བ་ཞིག་ཡེ་ཤུའི་མདུན་དུ་འཁྲིད་པ་དང༌། ཁོང་གིས་ནད་བསལ་བར་མཛད་པས་མི་དེ་སྐད་ཆ་བཤད་ཐུབ་པ་དང་མཐོང་ཐུབ་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","མི་ཚོགས་ཡ་མཚན་ཆེན་པོ་སྐྱེས་ནས་“མི་འདི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ཡིན་སྲིད་དམ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་དེ་ཐོས་ནས་“བདུད་ཀྱི་རྒྱལ་པོ་པེ་ཨིལ་བཟི་པད་ལ་བརྟེན་ནས་ཁོས་གདོན་འདྲེ་སྐྲོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“རྒྱལ་ཁམས་ཤིག་གི་ནང་ལ་ནང་འཁྲུག་བྱུང་ན་འཇིག་པར་འགྱུར་ལ། གྲོང་ཁྱེར་རམ་ཁྱིམ་ཚང་ནང་ལའང་ནང་འཁྲུག་བྱུང་ན་མི་གནས། ");
INSERT INTO bod_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","གལ་ཏེ་བདུད་སཱ་ཏན་གྱིས་སཱ་ཏན་བསྐྲད་ན། རང་ལ་ནང་འཁྲུག་བསླངས་པས་ཁོའི་རྒྱལ་ཁམས་ཅི་ལྟར་གནས། ");
INSERT INTO bod_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","གལ་ཏེ་ངས་པེ་ཨིལ་བཟི་པད་ལ་བརྟེན་ནས་གདོན་འདྲེ་བསྐྲད་ན། ཁྱོད་རྣམས་ཀྱི་བུ་ཡིས་སུ་ལ་བརྟེན་ནས་གདོན་འདྲེ་སྐྲོད་དམ། དེའི་ཕྱིར་ཁོ་ཚོས་ཁྱོད་ཚོར་ཁྲིམས་གཏོང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","འོན་ཀྱང་ངས་དཀོན་མཆོག་གི་ཐུགས་ཉིད་ལ་བརྟེན་ནས་གདོན་འདྲེ་བསྐྲད་ན། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱོད་ཚོའི་རྩར་སླེབས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ཡང་ན་མི་སྟོབས་ཤུགས་ཆེན་པོ་ཞིག་སྔོན་ལ་མ་བཅིངས་པར་དེའི་ཁང་པར་འཛུལ་ནས་ཅ་ལག་ཇི་ལྟར་འཕྲོག་ཐུབ། ཁོ་བཅིངས་ནས་ཁོའི་ཁང་པའི་ཅ་ལག་འཕྲོག་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","སུས་ཀྱང་ང་ཡི་ཕྱོགས་མི་བྱེད་པ་དེས་ང་ལ་རྒོལ་ཞིང༌། སུས་ཀྱང་ང་དང་མཉམ་དུ་མི་སྡུད་པ་ནི་གཏོར་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","དེའི་ཕྱིར་ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། སྡིག་པ་དང་དཀོན་མཆོག་ལ་སྐུར་བ་འདེབས་པ་ཐམས་ཅད་སེལ་བར་འགྱུར། འོན་ཀྱང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་སྐུར་བ་འདེབས་མཁན་དེའི་སྡིག་ཉེས་སེལ་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","མིའི་རིགས་ཀྱི་བུ་ལ་ངན་སྨྲས་བྱེད་མཁན་དེའི་སྡིག་ཉེས་སེལ་བར་འགྱུར། འོན་ཀྱང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་ངན་སྨྲས་བྱེད་མཁན་དེའི་སྡིག་ཉེས་ནི་ད་ལྟ་དང་མ་འོངས་པའི་དུས་སུ་སེལ་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","འབྲས་བུ་ལས་ཤིང་སྡོང་གང་ཡིན་ཤེས་པས། ཤིང་སྡོང་དང་འབྲས་བུ་གཉིས་ཀ་བཟང་པོ་རྩིས། ཡང་ན་ཤིང་སྡོང་དང་འབྲས་བུ་གཉིས་ཀ་ངན་པ་རྩིས། ");
INSERT INTO bod_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","དུག་སྦྲུལ་གྱི་རིགས་ཁྱོད་ཚོ། སེམས་ནང་གང་ཁེངས་ཡོད་པ་དེ་ཁ་ཡིས་བརྗོད་པས། ཁྱོད་ཚོ་ངན་པ་ཡིན་ཏེ་བཟང་པོ་ཅི་ལྟར་སྨྲ། ");
INSERT INTO bod_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","མི་བཟང་པོ་ཞིག་གིས་སེམས་ཀྱི་མཛོད་བཟང་པོ་ནས་བཟང་པོ་འདོན་པ་དང༌། མི་ངན་པ་ཞིག་གིས་སེམས་ཀྱི་མཛོད་ངན་པ་ནས་ངན་པ་འདོན། ");
INSERT INTO bod_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། ཁྲིམས་གཅོད་ཀྱི་ཉིན་མོར་མི་ཚོས་ཕན་མེད་པའི་ཚིག་རེ་རེའི་དོན་ལ་དཀོན་མཆོག་ལ་རྩིས་འབུལ་ཞུ་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","གང་ལགས་ཟེར་ན། ཁྱོད་ཀྱིས་སྨྲས་པའི་ཚིག་གིས་ཁྱོད་ཡང་དག་པར་རྩིས་ཤིང༌། ཁྱོད་ཀྱིས་སྨྲས་པའི་ཚིག་གིས་ཁྱོད་ཁྲིམས་གཅོད་གཏོང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","དེ་ནས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་ཁ་ཤས་ཀྱིས་ཡེ་ཤུ་ལ་“སྟོན་པ་ལགས། ཁྱེད་ལས་ངོ་མཚར་བའི་རྟགས་ཤིག་མཐོང་བར་འདོད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ལན་དུ་ཁོང་གིས་“མི་རབས་འདི་ནི་ངན་པ་དང་ལོག་གཡེམ་ཅན་ཞིག་ཡིན་པས་ངོ་མཚར་བའི་རྟགས་ཤིག་མཐོང་བར་འདོད་ཀྱང༌། ལུང་སྟོན་པ་ཡོ་ནཱ་ཡི་རྟགས་མ་གཏོགས་པར་གཞན་ཅི་ཡང་སྟེར་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ལུང་སྟོན་པ་ཡོ་ནཱ་ནི་ཉིན་གསུམ་དང་མཚན་གསུམ་ཉ་ཆེན་པོའི་གྲོད་ཁོག་ནང་ལ་བསྡད་པ་ལྟར། མིའི་རིགས་ཀྱི་བུ་ཡང་ཉིན་གསུམ་དང་མཚན་གསུམ་སའི་གཏིང་ལ་སྡོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ཁྲིམས་གཅོད་པའི་ཉིན་མོར་གྲོང་ཁྱེར་ནུ་ནེ་ཝཱ་ཡི་མི་རྣམས་ལངས་ནས་མི་རབས་འདིའི་མི་རྣམས་ལ་ཉེས་སྐྱོན་འདོན་པར་བྱ། གང་ལགས་ཤེ་ན། ལུང་སྟོན་པ་ཡོ་ནཱའི་གསུང་ཐོས་ནས་ཁོ་ཚོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར། ལྟོས་ཤིག ད་ལྟ་ཡོ་ནཱ་ལས་ཆེ་བ་ཞིག་འདིར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ཁྲིམས་གཅོད་པའི་ཉིན་མོར་ལྷོ་ཡུལ་གྱི་རྒྱལ་མོའང་ལངས་ནས་མི་རབས་འདིའི་མི་རྣམས་ལ་ཉེས་སྐྱོན་འདོན་པར་བྱ། གང་ཡིན་ཞེ་ན། རྒྱལ་པོ་སོ་ལོ་མོན་གྱི་ཤེས་རབ་ཐོས་པའི་ཕྱིར་ཁོ་མོ་ས་གཞིའི་མཐའ་ནས་ཡོང༌། ལྟོས་ཤིག ད་ལྟ་སོ་ལོ་མོན་ལས་ཆེ་བ་ཞིག་འདིར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","མི་ཞིག་ནས་གདོན་འདྲེ་མི་གཙང་བ་འཐོན་སྐབས། ཆུ་མེད་པའི་ས་བརྒྱུད་དེ་ཕྱིན་ནས་ངལ་གསོ་འཚོལ་ཡང་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","དེ་ནས་དེས་ང་ཐོན་པའི་ཁང་པ་དེ་ལ་ཕྱིར་ལོག་ཅེས་ཟེར། དེར་སླེབས་དུས་སྟོང་ཞིང་གད་བརྒྱབ་ནས་གཙང་བ་དང་ལེགས་པར་བསྒྲིགས་ཡོད་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","སོང་ནས་དེ་ལས་ཀྱང་ངན་པ་གདོན་འདྲེ་བདུན་རང་དང་མཉམ་དུ་ཁྲིད་དེ་ཁང་པ་དེར་འཛུལ་ནས་བསྡད། མི་དེའི་གནས་ཚུལ་སྔ་མ་ལས་ཕྱི་མ་སྡུག་གོ དེ་བཞིན་དུ་མི་རབས་ངན་པ་འདི་ལ་ཡང་འབྱུང་བར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ཁོང་གིས་མི་ཚོགས་ལ་གསུང་བཞིན་པའི་ཚེ། ཁོང་གི་ཡུམ་དང་གཅུང་པོ་རྣམས་ཁོང་ལ་གླེང་བར་འདོད་དེ་ཕྱི་ལོགས་ལ་ལངས་ནས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","མི་ཞིག་གིས་ཁོང་ལ་“གཟིགས་དང༌། ཁྱེད་ཀྱི་ཡུམ་དང་སྐུ་མཆེད་ཕྱི་ལོགས་ལ་ལངས་ནས་ཁྱེད་རང་ལ་གླེང་བར་འདོད་དེ་བཞུགས་འདུག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ཁོང་གིས་དེ་སྨྲས་པའི་མི་ལ་ལན་དུ་“ངའི་མ་དང་ངའི་སྤུན་ནི་སུ་ཡིན་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱི་ཕྱོགས་སུ་ཕྱག་བརྐྱངས་ཏེ་“ལྟོས་དང༌། ངའི་མ་དང་ངའི་སྤུན་ཟླ་ནི་མི་འདི་ཚོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","གང་ལགས་ཟེར་ན། དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱི་དགོངས་པ་བཞིན་དུ་བྱེད་མཁན་ནི་ངའི་སྤུན་དང་སྲིང་མོ། མ་ཡིན་ནོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ཉིན་དེར་ཡེ་ཤུ་ཁང་པ་ནས་ཕེབས་ཏེ་མཚོའི་འགྲམ་དུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","མི་ཚོགས་ཆེན་པོ་ཞིག་ཁོང་གི་དྲུང་དུ་འཛོམས་པས་ཁོང་གྲུ་ཞིག་གི་ནང་དུ་བཞུགས་པ་དང༌། མི་ཚོགས་ཆ་ཚང་མཚོ་འགྲམ་ལ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ཁོང་གིས་དཔེའི་སྒོ་ནས་ཆོས་མང་པོ་གསུངས་ཏེ་ཁོ་ཚོར་“ཉོན་དང༌། ས་བོན་འདེབས་མཁན་ཞིག་ས་བོན་འདེབས་པར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ས་བོན་གཏོར་བའི་སྐབས་སུ། ས་བོན་ཁ་ཤས་ལམ་ཁར་འཐོར་བ་དེ་རྣམས་བྱ་འོངས་ནས་བཟས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ཁ་ཤས་ནི་ས་མང་པོ་མེད་པའི་བྲག་གི་སྟེང་ལ་འཐོར་ཞིང་སའི་གཏིང་རིང་པོ་མེད་པས་ཡར་སྐྱེས་པ་མགྱོགས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ཉི་མ་ཤར་ནས་ཚིག་སྟེ་རྩ་བ་གཏིང་རིང་པོ་མེད་པས་བསྐམས། ");
INSERT INTO bod_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ས་བོན་ཁ་ཤས་ཚེར་མའི་ནང་དུ་འཐོར་ཞིང་ཚེར་མ་སྐྱེས་ནས་སྒྲིབ་པས་ས་བོན་ཡར་མ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ཡང་ས་བོན་ཁ་ཤས་ས་རྒྱུ་བཟང་པོའི་ནང་དུ་ཟགས་ནས་ཆེར་སྐྱེས་ཤིང་འབྲས་བུ་སྨིན་ཏེ། འབྲས་བུ་ཁ་ཤས་ལྡབ་བརྒྱ་དང༌། ཁ་ཤས་ལྡབ་དྲུག་ཅུ། ཁ་ཤས་ལྡབ་སུམ་ཅུ་བཅས་སྨིན། ");
INSERT INTO bod_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ཉེ་གནས་རྣམས་ཁོང་གི་དྲུང་དུ་འོངས་ནས་ཁོང་ལ་“ཁྱེད་ཀྱིས་ཁོ་ཚོར་དཔེའི་སྒོ་ནས་ཅིའི་ཕྱིར་གསུངས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ལན་དུ་ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་གསང་བ་ཤེས་པ་དེ་ཁྱེད་ཚོ་ལ་གནང་བ་ཡིན། འོན་ཀྱང་ཁོ་ཚོ་ལ་གནང་བ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","མི་སུ་ཞིག་ཐོས་པ་དང་རྟོགས་པ་འདོད་པ་དེ་ལ་སྟེར་བར་འགྱུར་ཞིང༌། ལྷག་པ་ཡོད་པར་འགྱུར། འོན་ཀྱང་རྟོགས་པ་མི་འདོད་པ་དེ་ལས་རྟོགས་པ་གང་ཡོད་པ་དེ་ཡང་ལེན་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","དེའི་ཕྱིར་ངས་ཁོ་ཚོར་དཔེའི་སྒོ་ནས་སྨྲ། དེ་ནི་ཁོ་ཚོས་མཐོང་ཡང་མི་མཐོང་ཞིང༌། ཐོས་ཡང་མི་ཐོས་ཏེ་ཧ་མི་གོ་བའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡི་ལུང་བསྟན་ཁོ་རྣམས་ལ་སྒྲུབ་སྟེ། ཁྱོད་ཚོས་གོ་ཡང་གསལ་བར་མི་ཤེས་ལ། ། མཐོང་ཡང་དེ་དོན་རྟོགས་པར་མི་འགྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","མི་རིགས་འདིའི་སེམས་གྱོང་པོར་གྱུར་བས་སོ། ། རྣ་བ་ལྗིད་ཅིང་མིག་ཡང་བཙུམས་པས་ན། ། མིག་གིས་མ་མཐོང་རྣ་བས་མི་ཐོས་ཤིང༌། ། བློ་ཡིས་མི་རྟོགས་དེ་མིན་སེམས་བསྒྱུར་ནས། ། ང་ཡིས་དེ་ཚོ་གསོ་ཞིང་སྐྱོབ་པར་བྱེད། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","འོན་ཀྱང་ཁྱེད་ཚོའི་མིག་གིས་མཐོང་བས་བདེ་ཞིང༌། ཁྱེད་ཚོའི་རྣ་བས་ཐོས་པས་བདེའོ། ");
INSERT INTO bod_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཀྱིས་གང་མཐོང་བ་དང་ཐོས་པ་ནི་ལུང་སྟོན་པ་དང་དྲང་ལྡན་པ་མང་པོས་དེ་མཐོང་བ་དང་ཐོས་པ་འདོད་ཀྱང་མ་མྱོང༌།” ");
INSERT INTO bod_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“འོ་ན་ས་བོན་འདེབས་མཁན་གྱི་དཔེ་ལ་ཉོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","མི་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་བསྟན་པ་ཐོས་ནས་ཧ་མི་གོ་ན། བདུད་ཡོང་ནས་ཁོའི་སེམས་ལ་བཏབ་པའི་ས་བོན་ཕྲོགས་ནས་ཕར་འཁྱེར། འདི་ནི་ལམ་ཁར་འཐོར་བ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ས་བོན་བྲག་ཡོད་པའི་ས་ལ་འཐོར་བ་ནི་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་མ་ཐག་སེམས་དགའ་བའི་ངང་ནས་དང་ལེན་བྱེད་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","འོན་ཀྱང་རང་གི་སེམས་ནང་ལ་རྩ་བ་གཏིང་རིང་པོ་ཚུགས་མེད་པས་དུས་ཐུང་ངུ་ལ་གནས་ཀྱང་བཀའ་དེའི་དོན་དུ་སྡུག་བསྔལ་དང་གནོད་འཚེ་འབྱུང་མ་ཐག་ཏུ་ཁོའི་དད་པ་ལོག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ཡང་ས་བོན་ཚེར་མའི་ནང་དུ་འཐོར་བ་ནི་དཀོན་མཆོག་གི་བཀའ་ཐོས་ཀྱང༌། འཚོ་བའི་སྐོར་གྱི་སེམས་ཁྲལ་དང་རྒྱུ་ནོར་གྱི་བསླུ་བྲིད་ཀྱིས་བཀའ་མནན་ནས་འབྲས་བུ་སྐྱེ་མི་ཐུབ་པ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ས་བོན་ས་རྒྱུ་བཟང་པོ་ལ་འཐོར་བ་ནི་དཀོན་མཆོག་གི་བཀའ་ཐོས་ནས་རྟོགས་པའི་མི་དེ་ཡིན། འབྲས་བུ་སྨིན་ཏེ། འབྲས་བུ་ཁ་ཤས་ལྡབ་བརྒྱ་དང༌། ཁ་ཤས་ལྡབ་དྲུག་ཅུ། ཁ་ཤས་ལྡབ་སུམ་ཅུ་བཅས་སྨིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","དཔེ་གཞན་ཞིག་ཁོ་ཚོར་བསྟན་ཏེ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་རང་གི་ཞིང་ཁར་ས་བོན་བཟང་པོ་འདེབས་མཁན་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","འོན་ཀྱང་མི་རྣམས་གཉིད་ཁུག་དུས་ཁོའི་དགྲ་བོ་ཡོང་ནས་གྲོའི་ཁྲོད་དུ་རྩྭ་ངན་བཏབ་ནས་ཕར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","གྲོའི་མྱུ་གུ་ཐོན་ནས་འབྲས་བུ་སྨིན་སྐབས། རྩྭ་ངན་དེ་ཡང་མངོན། ");
INSERT INTO bod_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ཞིང་བདག་གི་གཡོག་པོ་རྣམས་ཡོང་ནས་ཁོང་ལ། སྐུ་ཞབས་ལགས། ཁྱེད་ཀྱི་ཞིང་ཁར་ས་བོན་བཟང་པོ་མ་བཏབ་བམ། རྩྭ་ངན་འདི་ཚོ་གང་ནས་བྱུང་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ལན་དུ་ཁོང་གིས་ཁོ་ཚོར་དགྲ་བོ་ཞིག་གིས་བྱས་པ་ཡིན་ཞེས་ཟེར། གཡོག་པོ་རྣམས་ཀྱིས་ཁོང་ལ། ང་ཚོ་ཕྱིན་ནས་རྩྭ་ངན་དགོག་པར་འདོད་དམ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","བདག་པོས་དེ་ལྟར་མ་བྱེད་ཅིག གང་ཡིན་ཞེ་ན། གྲོ་དང་རྩྭ་ངན་གཉིས་ཀ་དགོག་ཉེན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ལོ་ཏོག་མ་སྨིན་པའི་བར་དུ་དེ་གཉིས་མཉམ་དུ་སྐྱེ་རུ་ཆུག ཞིང་ཁ་རྔ་རན་པའི་དུས་སུ་ངས་རྔ་མཁན་རྣམས་ལ། སྔོན་ལ་རྩྭ་ངན་བསྒྲུགས་ནས་མེས་སྲེག་གཏོང་བའི་ཕྱིར་རྡོག་ཁྲེས་སུ་ཆིངས་ཤིག དེ་ནས་གྲོ་ངའི་བང་མཛོད་དུ་སྡུས་ཤིག་ཅེས་སྨྲ་བར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ཡེ་ཤུས་དཔེ་གཞན་ཞིག་ཁོ་ཚོར་བསྟན་ཏེ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་ཞིང་ཁར་བཏབ་པའི་ཡུངས་འབྲུ་རྡོག་པོ་གཅིག་དང་འདྲ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ས་བོན་ཐམས་ཅད་ལས་ཆུང་ཡང༌། ཆེར་སྐྱེས་དུས་སྡུམ་རའི་སྔོ་ཚོད་གཞན་རྣམས་ལས་ཆེ་བར་ཆགས་ཏེ་རྩི་ཤིང་དུ་གྱུར་ཞིང༌། བྱིའུ་རྣམས་ཡོང་ནས་དེའི་ཡལ་གར་ཚང་བཟོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ཁོང་གིས་དཔེ་གཞན་ཞིག་ཁོ་ཚོར་བསྟན་ཏེ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་སྐྱུར་རྩི་དང་འདྲ་སྟེ། བུད་མེད་ཅིག་གིས་དེ་གྲོ་ཕྱེ་བྲེ་གསུམ་གྱི་ནང་ལ་བསྲེས་པ་དང༌། རྗེས་མ་ཕྱེ་ཐམས་ཅད་ལ་སྐྱུར་ལངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ཡེ་ཤུས་དོན་དེ་ཐམས་ཅད་དཔེའི་སྒོ་ནས་མི་ཚོགས་ལ་གསུངས་ཏེ། དཔེ་མ་བསྟན་པར་ཁོ་ཚོར་ཅིའང་མ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","འདི་ནི་ལུང་སྟོན་པ་བརྒྱུད་ནས་གསུངས་པ་དེ་སྒྲུབ་པའི་ཆེད་དུ་ཡིན། ང་ཡི་ཁ་ནས་དཔེ་སྤྱད་དེ། ། འཇིག་རྟེན་བཀོད་ནས་ད་བར་གྱི། ། སྦས་པའི་དོན་རྣམས་བསྟན་པར་བྱ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","དེ་ནས་མི་ཚོགས་དང་ཁ་བྲལ་ཏེ་ཁོང་ཁང་པའི་ནང་ལ་ཕེབས། ཁོང་གི་ཉེ་གནས་རྣམས་ཁོང་གི་མདུན་དུ་འོངས་ནས་“ཞིང་ཁའི་རྩྭ་ངན་གྱི་དཔེ་ང་ཚོར་གསལ་བཤད་མཛད་རོགས་གནང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ཁོང་གིས་“ས་བོན་འདེབས་མཁན་ནི་མིའི་རིགས་ཀྱི་བུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ཞིང་ཁ་ནི་འཇིག་རྟེན་ཡིན། ས་བོན་བཟང་པོ་ནི་རྒྱལ་སྲིད་ཀྱི་བུ་རྣམས་ཡིན། རྩྭ་ངན་ནི་བདུད་ཀྱི་བུ་རྣམས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","རྩྭ་ངན་འདེབས་མཁན་ནི་བདུད་ཡིན་ཞིང༌། ལོ་ཏོག་གི་རྔ་བ་ནི་དུས་ཀྱི་མཐའ་མ་ཡིན། རྔ་མཁན་རྣམས་ནི་དཀོན་མཆོག་གི་ཕོ་ཉ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","རྩྭ་ངན་བསྒྲུགས་ནས་མེས་སྲེག་གཏོང་བ་བཞིན། དུས་ཀྱི་མཐའ་མ་ལ་ཡང་དེ་ལྟར་འབྱུང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","མིའི་རིགས་ཀྱི་བུ་ཡིས་རང་གི་ཕོ་ཉ་མངགས་ཏེ་རང་གི་རྒྱལ་སྲིད་ཀྱི་ནང་ནས་ཁོ་ཚོས་སྡིག་པའི་རྒྱུ་དང་ངན་པ་བྱེད་མཁན་ཐམས་ཅད་བསྒྲུགས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","མེ་ལྕེ་དང་ལྡན་པའི་ཐབ་ལ་འཕེན་པར་འགྱུར། ས་ཆ་དེར་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་པ་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","དེ་ནས་ཁོ་ཚོའི་ཡབ་ཀྱི་རྒྱལ་སྲིད་ལ་དྲང་ལྡན་པ་རྣམས་ནི་ཉི་མ་ལྟར་འཕྲོ་བར་འགྱུར། རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག” ");
INSERT INTO bod_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་ཞིང་ཁར་སྦས་ཡོད་པའི་གཏེར་ཞིག་དང་འདྲ་བ་ཡིན། མི་ཞིག་གིས་གཏེར་དེ་རྙེད་ནས་ཡང་བསྐྱར་སྦས་པ་དང༌། དགའ་བའི་ངང་ནས་སོང་ཞིང༌། རང་ལ་ཡོད་པ་ཐམས་ཅད་བཙོངས་ནས་ཞིང་ཁ་དེ་ཉོས། ");
INSERT INTO bod_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ཡང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་མུ་ཏིག་སྤུས་ལེགས་འཚོལ་བའི་ཚོང་དཔོན་ཞིག་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","མུ་ཏིག་རིན་ཆེན་ཞིག་མཐོང་ནས་ཕར་ཕྱིན་ཞིང་རང་ལ་ཡོད་པ་ཐམས་ཅད་བཙོངས་ཏེ་ཉོས།” ");
INSERT INTO bod_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ཡང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་མཚོ་ནང་དུ་འཕེན་པའི་དྲ་རྒྱ་ཞིག་དང་འདྲ་བ་ཡིན། དེས་ཉ་རིགས་སྣ་ཚོགས་བསྡུས་ནས་ ");
INSERT INTO bod_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","གང་སྟེ་མི་རྣམས་ཀྱིས་དྲ་རྒྱ་དེ་སྐམ་ས་ལ་དྲུད་ཅིང༌། ཉ་ལེགས་པོ་རྣམས་སྣོད་ལ་བཞག་ཅིང་ཉ་ཕན་མེད་རྣམས་དབྱུགས། ");
INSERT INTO bod_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","དུས་ཀྱི་མཐའ་མར་དེ་ལྟར་འབྱུང་བར་འགྱུར་ངེས་ཡིན། དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་ཀྱིས་ངན་པ་རྣམས་དྲང་ལྡན་རྣམས་ཀྱི་ནང་ནས་དབྱེ་བ་འབྱེད་དེ། ");
INSERT INTO bod_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","མེ་ལྕེ་དང་ལྡན་པའི་ཐབ་ལ་འཕེན་པར་འགྱུར། ས་ཆ་དེར་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་པ་འབྱུང་བར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ད་ཁྱེད་ཚོས་དོན་དེ་ཐམས་ཅད་ཧ་གོ་སོང་ངམ་”ཞེས་གསུངས་པས་ཁོ་ཚོས་ཁོང་ལ་“ཧ་གོ་སོང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ཁོང་གིས་ཁོ་རྣམས་ལ་“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་ཉེ་གནས་སུ་འགྱུར་མཁན་རེ་རེ་ནི་རང་གི་གཏེར་མཛོད་ནས་དངོས་པོ་གསར་པ་དང་རྙིང་པ་གཉིས་འདོན་པའི་ཁྱིམ་བདག་གཅིག་དང་འདྲ་བ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","དཔེ་དེ་རྣམས་བསྟན་ཚར་ནས་ཡེ་ཤུ་ས་ཆ་དེ་ནས་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","རང་གི་ཕ་ཡུལ་དུ་བྱོན་ནས་ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་ལ་ཆོས་གསུངས། ཁོང་ལ་ཉན་མཁན་རྣམས་ཧ་ལས་ཏེ་“མི་འདི་ལ་འདི་ལྟ་བུའི་ཤེས་རབ་དང་ནུས་མཐུ་གང་ནས་བྱུང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ཁོ་ནི་ཤིང་བཟོ་བའི་བུ་མ་ཡིན་ནམ། ཁོའི་མ་མིར་ཡམ་ཟེར་མཁན་མ་ཡིན་ནམ། ཡང་ཁོའི་གཅུང་པོ་ཡ་ཀོབ་དང༌། ཡོ་སེབ། སི་མོན། ཡུ་དཱ་བཅས་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ཁོའི་སྲིང་མོ་རྣམས་ཀྱང་ཡུལ་འདིར་ང་ཚོ་དང་མཉམ་དུ་བསྡད་ཡོད་པ་མ་ཡིན་ནམ། འོ་ན་མི་འདི་ལ་དེ་ཐམས་ཅད་གང་ནས་བྱུང་བ་ཡིན་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ཁོ་ཚོས་ཁོང་རྩིས་མེད་བཏང་ངོ༌། འོན་ཀྱང་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ལུང་སྟོན་པ་ལ་རང་ཡུལ་གྱི་མི་དང་གཉེན་ཉེ་ལ་མ་གཏོགས་པར་རྩིས་མེད་མི་འབྱུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ཁོ་ཚོས་དད་པ་མ་བྱས་པས་ཁོང་གིས་ས་ཆ་དེར་ངོ་མཚར་གྱི་མཛད་པ་མང་པོ་མ་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","དེའི་ཚེ་ས་གནས་དཔོན་པོ་ཧེ་རོ་དཱེ་ཡིས་ཡེ་ཤུའི་སྐོར་གྱི་གཏམ་ཐོས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ཁོའི་གཡོག་པོ་རྣམས་ལ་“མི་དེ་ནི་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གཤིན་པོ་ནས་གསོན་པོར་ལངས་སུ་གྱུར་བ་དེ་ཡིན་པས། ཁོང་ལ་ནུས་མཐུ་འདི་ལྟར་ལྡན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","དེ་སྔོན་ཧེ་རོ་དཱེ་ཡིས་རང་གི་གཅུང་པོ་ཕི་ལིབ་ཀྱི་བཟའ་ཟླ་ཧེ་རོད་ཡཱ་ཟེར་བ་དེ་རང་གི་བཟའ་ཟླར་བླངས་པའི་རྐྱེན་གྱིས། ཡོ་ཧ་ནན་གྱིས་ཧེ་རོ་དཱེ་ལ་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་ཁྱེད་ཀྱིས་རང་གི་གཅུང་པོའི་བཟའ་ཟླ་ལེན་མི་ཆོག་”ཅེས་གསུངས་པས། ཧེ་རོ་དཱེ་ཡིས་ཡོ་ཧ་ནན་བཟུང་སྟེ་བསྡམས་ནས་བཙོན་ཁང་ལ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ཧེ་རོ་དཱེ་ཡིས་ཡོ་ཧ་ནན་གསོད་པར་འདོད་ཀྱང༌། ཡུལ་མི་རྣམས་ཀྱིས་ཡོ་ཧ་ནན་ལུང་སྟོན་པར་རྩིས་པས་ཧེ་རོ་དཱེ་ཡིས་དེ་རྣམས་ལ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","དེ་ནས་ཧེ་རོ་དཱེ་ཡི་སྐྱེ་སྐར་གྱི་ཉིན་མོར་ཧེ་རོད་ཡཱའི་བུ་མོས་ཧེ་རོ་དཱེ་དང་ཁོའི་མགྲོན་པོའི་མདུན་དུ་ཞབས་བྲོ་འཁྲབ་པས་ཧེ་རོ་དཱེ་དགའ་བར་གྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ཁོ་མོས་གང་ཞུས་པའང་སྟེར་བའི་མནའ་བསྐྱལ། ");
INSERT INTO bod_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","རང་གི་མ་ཡིས་བསྐུལ་བས་ཁོ་མོས་“ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་མགོ་བོ་སྡེར་མའི་ནང་དུ་བཞག་ནས་ང་ལ་གནང་བར་མཛོད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ཧེ་རོ་དཱེའི་སེམས་སྐྱོ་ནའང་མགྲོན་པོ་རྣམས་ཀྱི་མདུན་ལ་མནའ་བསྐྱལ་ཡོད་པའི་ཕྱིར་བཀའ་གཏང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","སྲུང་དམག་ཞིག་བཏང་ནས་བཙོན་ཁང་དུ་ཡོ་ཧ་ནན་གྱི་དབུ་བཅད། ");
INSERT INTO bod_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","དབུ་དེ་སྡེར་མའི་ནང་དུ་བཞག་ནས་ཁྱེར་ཡོང་སྟེ་བུ་མོ་ལ་བྱིན་པ་དང༌། ཁོ་མོས་རང་གི་ཨ་མ་ལ་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ཡོ་ཧ་ནན་གྱི་སློབ་མ་རྣམས་ཡོང་སྟེ་ཁོང་གི་སྐུ་ཕུང་ཁུར་ནས་དུར་ཁང་དུ་བཞག་པ་དང༌། ཡེ་ཤུ་ལ་གཏམ་དེ་ཞུ་བའི་ཕྱིར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ཡེ་ཤུས་གཏམ་དེ་གསན་པས་གྲུ་ལ་བཞུགས་ནས་མི་གཞན་མེད་པའི་དབེན་གནས་ཤིག་ལ་ཕེབས། ཡུལ་མི་རྣམས་ཀྱིས་དེའི་སྐོར་ཐོས་པས་གྲོང་ཁྱེར་རྣམས་ནས་གོམ་པ་སྤོས་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ཁོང་གྲུ་ལས་བབས་དུས་མི་ཚོགས་མང་པོ་གཟིགས་པས། ཐུགས་བརྩེ་བའི་ངང་ནས་ཁོ་ཚོའི་ཁྲོད་ཀྱི་ནད་པའི་ནད་རྣམས་སེལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","དགོང་མོ་ཆགས་དུས་ཉེ་གནས་རྣམས་ཁོང་གི་དྲུང་དུ་འོངས་ནས་ཁོང་ལ་“ས་ཆ་འདི་དབེན་སྟོང་ཡིན་ཞིང་ཉི་མ་ཡང་ནུབ་ལ་ཉེ་བས། མི་ཚོགས་ཡུལ་སྡེ་རྣམས་ལ་རང་རང་གི་ཟས་ཉོ་རུ་དགོངས་པ་གནང་རོགས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","འོན་ཀྱང་དེའི་ལན་དུ་ཡེ་ཤུས་“ཕར་འགྲོ་མི་དགོས། ཁྱེད་ཚོས་ཁོ་ཚོར་ཟས་སྟེར་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ཁོ་ཚོས་ཁོང་ལ་“ང་ཚོར་འདིར་བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་ལས་མེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ཁོང་གིས་“དེ་ཚོ་ངའི་རྩར་འཁུར་ཤོག་”ཅེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ཁོང་གིས་མི་ཚོགས་ལ་རྩྭའི་སྟེང་ལ་སྡོད་དགོས་པའི་བཀའ་གནང་ཞིང༌། བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་པོ་དེ་ཕྱག་ཏུ་བསྣམས་ཏེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་ཡར་གཟིགས་ཤིང་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས། བག་ལེབ་དུམ་བུར་བཟོས་ནས་ཉེ་གནས་རྣམས་ལ་གནང་སྟེ་ཁོ་ཚོས་མི་ཚོགས་ལ་སྟེར། ");
INSERT INTO bod_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","མི་ཚང་མས་བཟས་ནས་འགྲངས་ཏེ། ཟས་ལྷག་བསྡུས་པའི་རྗེས་སུ་བག་ལེབ་ཆག་དུམ་གྱིས་སླེ་པོ་བཅུ་གཉིས་ཁེངས། ");
INSERT INTO bod_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ཟས་ཟ་མཁན་བུད་མེད་དང་ཕྲུ་གུ་མ་བརྩིས་པར་སྐྱེས་པ་ལྔ་སྟོང་ཙམ་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","དེ་མ་ཐག་ཡེ་ཤུས་ཉེ་གནས་རྣམས་གྲུ་ལ་སྡོད་དུ་བཅུག་སྟེ། ཁོང་གི་སྔོན་དུ་མཚོའི་ཕ་རོལ་གྱི་ཕྱོགས་སུ་སོང་ཞིག་ཅེས་གསུངས་ནས་མི་ཚོགས་ཕར་བཏང་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","དེ་ལྟར་མཛད་པའི་རྗེས་སུ་སྨོན་ལམ་འདེབས་པའི་ཕྱིར་ཁོང་གཅིག་པུར་རི་ལ་ཡར་ཕེབས། ཉི་མ་ནུབ་པའི་དུས་སུ་དེར་ཁོང་གཅིག་པུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","དེའི་སྐབས་གྲུ་ནི་སྐམ་ས་ནས་ཐག་རིང་ལ་སླེབས་ཡོད། ལྷགས་པ་གྲུའི་མདུན་ཕྱོགས་ནས་བརྒྱབ་པས་རྦ་རླབས་ཀྱིས་དཀྲུགས། ");
INSERT INTO bod_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","མཚན་མོ་ཐུན་བཞི་པ་ཙམ་ལ་ཁོང་མཚོའི་སྟེང་ལ་ཞབས་ཀྱིས་འཆག་སྟེ་ཁོ་ཚོའི་རྩར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","དེ་མཐོང་བས་ཉེ་གནས་རྣམས་འཇིགས་ཤིང་སྐྲག་པར་གྱུར་ནས་“གདོན་འདྲེ་ཞིག་འདུག་”ཅེས་འཇིགས་པས་སྐད་ཤོར་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱེད་ཚོའི་སེམས་བདེ་བར་བྱོས། ང་རང་ཡིན་པས་འཇིགས་མི་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","པེ་ཏྲོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁྱེད་རང་ཡིན་ན། ང་ལ་ཆུའི་སྟེང་དུ་ཁྱེད་ཀྱི་རྩར་ཡོང་དགོས་པའི་བཀའ་གནང་དང་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ཁོང་གིས་“ཚུར་ཤོག་”ཅེས་གསུངས་པས་པེ་ཏྲོ་གྲུ་ནས་བབས་ཤིང༌། ཆུའི་སྟེང་ལ་གོམ་པ་བརྒྱབ་སྟེ་ཁོང་གི་རྩར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","འོན་ཀྱང་ལྷགས་པ་དྲག་པོ་རྒྱག་པ་མཐོང་བས་འཇིགས་ཏེ་ཆུའི་ནང་ལ་ནུབ་འགྲོ་བའི་ཚེ། ཁོས་སྐད་ཆེན་པོས་“གཙོ་བོ་ལགས། ང་སྐྱོབ་རོགས་གནང་”ཞེས་ཞུས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ཡེ་ཤུས་རང་གི་ཕྱག་བརྐྱངས་ཏེ་ཁོ་བཟུང་ཞིང་ཁོ་ལ་“དད་ཆུང་བ་ཁྱོད། ཅིའི་ཕྱིར་ཐེ་ཚོམ་བྱས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ཁོང་རྣམས་གྲུའི་ནང་ལ་ཞུགས་པའི་སྐབས་སུ་རླུང་འཇགས། ");
INSERT INTO bod_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","གྲུའི་ནང་ལ་ཡོད་པ་རྣམས་ཀྱིས་ཁོང་ལ་བསྙེན་བཀུར་ཞུས་ཏེ་“ཁྱེད་རང་ནི་བདེན་པར་དཀོན་མཆོག་གི་སྲས་ཡིན་ནོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ཁོང་རྣམས་མཚོ་བརྒལ་ནས་གན་ནེ་སཱ་རེལ་ཞེས་པའི་ས་ཆར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","དེར་ཡོད་པའི་མི་རྣམས་ཀྱིས་ཁོང་ངོ་ཤེས་རྗེས། མཐའ་སྐོར་གྱི་ཡུལ་ཐམས་ཅད་ལ་མི་བཏང་སྟེ་ནད་པ་ཚང་མ་ཁོང་གི་མདུན་དུ་ཁྲིད་ཅིང༌། ");
INSERT INTO bod_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ཡེ་ཤུ་ལ་ཁོང་གི་ན་བཟའི་ཟུར་ཙམ་ལ་རེག་པར་གནང་དུ་གསོལ་ཞེས་ཞུ་བ་ཆེན་པོ་ཕུལ་བས། ཁོང་གི་ན་བཟའ་ལ་རེག་པའི་ནད་པ་ཐམས་ཅད་ནད་ལས་ཐར་བར་གྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","དེའི་ཚེ་ཕཱ་རུ་ཤི་པ་དང་ཡ་ཧུ་དཱ་པའི་ཆོས་ལ་མཁས་པའི་མི་ཁ་ཤས་རྒྱལ་ས་ཡེ་རུ་ཤ་ལེམ་ནས་འོངས་ཤིང་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ཀྱིས་ཁ་ལག་མ་ཟ་གོང་ལ་ལག་པ་མི་འཁྲུད་པར་རྒན་པོའི་ལུགས་སྲོལ་ལས་ཅིའི་ཕྱིར་རྒལ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ལན་དུ་ཁོང་གིས་“ཁྱོད་ཚོས་རང་གི་ལུགས་སྲོལ་སྲུང་བའི་ཆེད་ཅིའི་ཕྱིར་དཀོན་མཆོག་གི་བཀའ་དང་འགལ་ལམ། ");
INSERT INTO bod_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","དཔེར་ན་དཀོན་མཆོག་གིས་རང་གི་ཕ་མ་གཉིས་ལ་བརྩི་བཀུར་གྱིས་ཞེས་དང༌། ཕ་མ་ལ་ཚིག་ངན་སྨྲ་མཁན་དེ་སྲོག་གཅོད་པར་འགྱུར་དགོས་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","འོན་ཀྱང་ཁྱོད་ཚོས་སུ་ཞིག་གིས་རང་གི་ཕ་མ་ལ་ངས་ཁྱེད་ལ་ཕན་ཐོགས་ཆེད་སྤྲོད་པ་འདི་ནི་དཀོན་མཆོག་ལ་ཕུལ་ཟིན་ནོ་ཞེས་བཤད་ནས། ");
INSERT INTO bod_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","རང་གི་ཕ་ལ་བརྩི་བཀུར་བྱེད་མི་དགོས་པར་བཤད། དེའི་སྒོ་ནས་ཁྱོད་ཚོས་རང་གི་ལུགས་སྲོལ་སྲུང་བའི་ཕྱིར་དཀོན་མཆོག་གི་བཀའ་སྟོང་བར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོའི་སྐོར་ལ་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་ལེགས་པར་ལུང་བསྟན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","མི་རྒྱུད་འདི་ཡིས་ངག་ནས་ང་བཀུར་ཡང༌། ། ཁོ་ཚོའི་སེམས་ནི་ང་དང་ཡོངས་སུ་བྲལ། ། ");
INSERT INTO bod_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","མི་ཡིས་བརྩམས་པའི་བསླབ་བྱ་རང་ལ་སྟོན། ། དེ་འདྲའི་བསྙེན་བཀུར་ང་ལ་བྱེད་དོན་མེད། །” ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","དེ་ནས་ཡེ་ཤུས་མི་ཚོགས་རང་གི་མདུན་དུ་བོས་ནས་ཁོ་ཚོར་“ཉོན་ཞིང་ཤེས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ཕྱི་ནས་ཁའི་ནང་དུ་འགྲོ་བ་དེས་མི་མི་གཙང་བར་མི་བྱེད་དེ། མིའི་ཁ་ནས་ཕྱིར་གང་འཐོན་པ་དེས་མི་མི་གཙང་བར་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ཉེ་གནས་རྣམས་ཁོང་གི་མདུན་དུ་ཡོང་ནས་“ཁྱེད་ཀྱི་གསུང་དེ་ཐོས་ནས་ཕཱ་རུ་ཤི་པ་རྣམས་ལ་ཕོག་ཐུག་བྱུང་བ་མཁྱེན་ནམ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ལན་དུ་ཁོང་གིས་“ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱིས་མ་བཙུགས་པའི་རྩི་ཤིང་རེ་རེ་བཞིན་རྩ་བཀོག་གཏོང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ཁོ་རྣམས་ལ་དོ་སྣང་མ་བྱེད། ཁོ་ཚོ་ནི་ལོང་བས་ལོང་བ་རྣམས་འཁྲིད་མཁན་ཡིན། ལོང་བས་ལོང་བ་ཁྲིད་ན་གཉིས་ཀ་ས་དོང་ལ་ལྷུང་ཡོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","པེ་ཏྲོས་ཁོང་ལ་“དཔེ་དེ་ང་ཚོར་གསལ་བཤད་མཛད་རོགས་གནང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ལན་དུ་ཡེ་ཤུས་“ཁྱོད་ཚོས་ཀྱང་ད་དུང་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ཕྱི་ནས་ཁའི་ནང་དུ་འགྲོ་བ་ཐམས་ཅད་ཕོ་བར་སོང་སྟེ་ལུས་ནས་ཕྱིར་འཐོན་པ་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","འོན་ཀྱང་མིའི་ཁ་ནས་གང་འཐོན་པ་སེམས་ནས་བྱུང་བས། མི་མི་གཙང་བར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","གང་ཡིན་ཟེར་ན། མི་རྣམས་ཀྱི་སེམས་ནང་ནས་བསམ་པ་ངན་པ་དང༌། མི་སྲོག་གཅོད་པ། ལོག་གཡེམ། འདོད་ལོག རྐུ་བ། རྫུན་དཔང༌། དམའ་འབེབས་གཏོང་བ་བཅས་འབྱུང་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","དེ་ཚོས་མི་མི་གཙང་བར་བྱེད། ལག་པ་མ་ཁྲུས་པར་ཟས་ཟ་བ་དེས་མི་མི་གཙང་བར་མི་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ཡེ་ཤུ་ས་ཆ་དེ་ནས་ཁ་བྲལ་ཏེ་ཐཱ་ཨེར་དང་ཚི་དོན་གྲོང་ཁྱེར་གྱི་ས་ཁུལ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ས་ཁུལ་དེའི་བུད་མེད་ཀ་ནཱན་མ་ཞིག་ཡོང་ནས་སྐད་ཆེན་པོས་“ཀྱེ་གཙོ་བོ་ལགས། རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས། ང་ལ་ཐུགས་རྗེས་གཟིགས། ངའི་བུ་མོ་གདོན་འདྲེས་ཟིན་ནས་མནར་གཅོད་གཏོང་བཞིན་འདུག་”ཅེས་སྨྲས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ཁོང་གིས་ཅིའང་མ་གསུངས། ཁོང་གི་ཉེ་གནས་རྣམས་ཡོང་ནས་ཡེ་ཤུ་ལ་“ཁོ་མོས་ང་ཚོ་སྐད་ཆེན་པོས་ཡང་ནས་ཡང་དུ་འབོད་པས་ཁོ་མོ་ཕར་གཏོང་ཞིག་”ཅེས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ལན་དུ་ཁོང་གིས་“ང་ནི་ཡི་སི་ར་ཨེལ་གྱི་ཁྱིམ་གྱི་ལུག་བརླགས་སོང་བ་རྣམས་འབའ་ཞིག་གི་རྩར་མངགས་པ་ཞིག་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","འོན་ཀྱང་ཁོ་མོ་ཡོང་ནས་ཁོང་གི་མདུན་དུ་པུས་མོ་སར་བཙུགས་ཏེ་“གཙོ་བོ་ལགས། ང་ལ་ཕྱག་རོགས་གནང་”ཞེས་ཞུ་བ་ཕུལ་བས། ");
INSERT INTO bod_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ལན་དུ་ཡེ་ཤུས་“ཕྲུ་གུའི་བག་ལེབ་བླངས་ནས་ཁྱི་ལ་དབྱུགས་ན་མི་ལེགས་”ཞེས་གསུངས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ཁོ་མོས་“ལགས་སོ། གཙོ་བོ་ལགས། འོན་ཀྱང་ཁྱི་རྣམས་ཀྱིས་ཀྱང་ཁྱིམ་བདག་གི་ལྕོག་ཙེ་ནས་ཟགས་པ་རྣམས་ལས་ཟའོ་”ཞེས་སྨྲས་པས། ");
INSERT INTO bod_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ཁོང་གིས་ཁོ་མོར་“ཀྱེ་བུད་མེད། ཁྱེད་ཀྱི་དད་པ་ཆེ་བས། ཁྱེད་ཀྱི་འདོད་པ་ལྟར་འབྱུང་བར་འགྱུར་”ཞེས་གསུངས་མ་ཐག ཁོ་མོའི་བུ་མོ་བདེ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ས་ཆ་དེ་ནས་ཁ་བྲལ་ཏེ་ཡེ་ཤུ་ག་ལིལ་མཚོ་འགྲམ་ལ་ཕེབས་ཤིང༌། རི་ལ་ཡར་ཕེབས་ནས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ཞ་བོ་དང༌། རྐང་ཀྱོག ལོང་བ། ལྐུགས་པ་ལ་སོགས་འཁྲིད་དེ་མི་ཚོགས་མང་པོ་ཁོང་གི་མདུན་དུ་ཡོང་ཞིང༌། ཁོ་རྣམས་ཁོང་གི་ཞབས་ཀྱི་རྩར་བཞག་ནས་ཁོང་གིས་གསོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","མི་ཚོགས་ཀྱིས་ལྐུགས་པ་རྣམས་ཀྱིས་གཏམ་བྱེད་པ་དང༌། རྐང་ཀྱོག་རྣམས་གསོས་པ་དང༌། ཞ་བོ་རྣམས་གོམ་པ་སྤོ་བ། ལོང་བས་མཐོང་ནས་ལྟ་བས་ཡ་མཚན་དུ་གྱུར་ཞིང༌། ཡི་སི་ར་ཨེལ་གྱི་དཀོན་མཆོག་ལ་བསྟོད་པར་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","དེ་ནས་ཡེ་ཤུས་ཉེ་གནས་རང་གི་མདུན་དུ་བོས་ཏེ་ཁོ་ཚོར་“མི་ཚོགས་འདི་ང་དང་མཉམ་དུ་བསྡད་ནས་ཉིན་ཞག་གསུམ་སོང་ཞིང༌། ད་ཆ་ཟས་ཅི་ཡང་མེད་པས་ཁོ་ཚོ་སྙིང་རྗེ་བར་འདུག ལམ་བར་དུ་བཀྲེས་ཤིང་ལྟོགས་ཏེ་དྲན་མེད་དུ་བརྒྱལ་བའི་ཉེན་ཡོད་པས་ཁ་སྟོང་པར་ལོག་གཏོང་མི་འདོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་“མི་ཚོགས་མང་པོ་འདི་འགྲང་བར་བྱེད་པའི་བག་ལེབ་མང་པོ་འདི་འདྲ་དབེན་སྟོང་འདི་རུ་ག་ནས་རྙེད་ཐུབ་བམ་”ཞེས་བཤད་པས། ");
INSERT INTO bod_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོར་བག་ལེབ་ཇི་ཙམ་ཡོད་”ཅེས་བཀའ་འདྲི་གནང་བས། ཁོ་ཚོས་“བདུན་དང་ཉ་ཤ་ཆུང་ཆུང་ཁ་ཤས་ཡོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ཁོང་གིས་མི་ཚོགས་རྣམས་ས་རུ་སྡོད་པའི་བཀའ་གནང་ནས། ");
INSERT INTO bod_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","བག་ལེབ་བདུན་པོ་དང་ཉ་ཤ་ཕྱག་ཏུ་བསྣམས་ཏེ་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས། དེ་ཚོ་དུམ་བུར་བཟོས་ནས་ཉེ་གནས་རྣམས་ལ་གནང་ཞིང༌། ཁོ་ཚོས་མི་ཚོགས་ལ་བྱིན། ");
INSERT INTO bod_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","མི་ཚང་མས་བཟས་ནས་འགྲངས་ཤིང་ཁོ་ཚོས་ཟས་ལྷག་གི་དུམ་བུ་བསྡུ་གསོག་བྱས་པས་སླེ་པོ་གང་བ་བདུན་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","བུད་མེད་དང་ཕྲུ་གུ་མ་བརྩིས་པར་ཟས་ཟ་མཁན་མི་སྟོང་ཕྲག་བཞི་ཙམ་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","མི་ཚོགས་ཕར་བཏང་ནས་ཡེ་ཤུ་གྲུ་ལ་བཞུགས་པ་དང༌། མ་ག་དན་ཞེས་བྱ་བའི་ཡུལ་ཕྱོགས་སུ་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པ་རྣམས་ཡོང་ནས་ཡེ་ཤུ་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ངོ་མཚར་བའི་རྟགས་ཁོ་ཚོར་སྟོན་པར་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ལན་དུ་ཁོང་གིས་“ཁྱོད་ཚོས་དགོང་མོ་ཆགས་པའི་དུས་སུ་ནམ་མཁའི་སྤྲིན་པ་དམར་པོ་ཡིན་ཚེ་ནམ་དྭངས་ཡོང་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ཡང་ཞོགས་པར་ནམ་མཁའ་འཐིབས་ཤིང་དམར་པོ་ཡིན་ཚེ་ཁྱོད་ཚོས་དེ་རིང་རླུང་འཚུབ་འབྱུང་བར་འགྱུར་ཞེས་ཟེར། ནམ་མཁའི་གནས་ཚུལ་དཔྱོད་སྟངས་ཤེས་ཀྱང༌། དུས་འདིའི་གནས་ཚུལ་དཔྱོད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","མི་རབས་འདི་ནི་ངན་པ་དང་ལོག་གཡེམ་ཅན་ཞིག་ཡིན་པས་ངོ་མཚར་བའི་རྟགས་ཤིག་མཐོང་བར་འདོད་ཀྱང༌། ལུང་སྟོན་པ་ཡོ་ནཱ་ཡི་རྟགས་མ་གཏོགས་པར་གཞན་ཅི་ཡང་སྟེར་བར་མི་འགྱུར་”ཞེས་གསུངས་ཏེ་ཁོ་ཚོ་དང་ཁ་བྲལ་ནས་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ཉེ་གནས་རྣམས་མཚོའི་ཕ་རོལ་ཏུ་སླེབས་པ་དང༌། བག་ལེབ་འཁྱེར་རྒྱུ་བརྗེད་པ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱེད་ཚོས་བློ་རིག་བསྒྲིམས་ནས་ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པའི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ཉེ་གནས་རྣམས་ཀྱིས་ཕན་ཚུན་ལ་“འདི་ནི་ང་ཚོས་བག་ལེབ་མ་འཁྱེར་བས་ཡིན་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ཡེ་ཤུས་དེ་མཁྱེན་ནས་“ཁྱོད་ཚོ་དད་ཆུང་བ་རྣམས། ཁྱོད་ཚོས་གཅིག་གིས་གཅིག་ལ་ཅིའི་ཕྱིར་བག་ལེབ་མ་འཁྱེར་བའི་གཏམ་གླེང་བ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ཁྱོད་ཚོས་ད་དུང་ཡང་མི་རྟོགས་སམ། མི་ལྔ་སྟོང་ལ་སྟེར་བའི་བག་ལེབ་ལྔ་པོ་དང༌། ཁྱོད་ཚོས་ཟས་ལྷག་མ་སླེ་པོ་ཇི་ཙམ་བསྡུས་པ་མི་དྲན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ཡང་ན་མི་བཞི་སྟོང་ལ་སྟེར་བའི་བག་ལེབ་བདུན་པོ་དང༌། ཁྱོད་ཚོས་ཟས་ལྷག་མ་སླེ་པོ་ཇི་ཙམ་བསྡུས་པ་མི་དྲན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ངས་ཁྱོད་ཚོར་ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པའི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་གྱིས་ཤིག་ཅེས་པ་ལས་བག་ལེབ་ཀྱི་གཏམ་མི་གླེང་བ་ཅིའི་ཕྱིར་མ་རྟོགས། ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པའི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་གྱིས་ཤིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","དེའི་ཚེ་ཁོང་གིས་བག་ལེབ་ཀྱི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་བྱེད་པར་མ་གསུངས་ཏེ། ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པའི་བསྟན་པའི་སྐོར་གསུངས་པར་ཁོ་ཚོས་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ཡེ་ཤུ་གྲོང་ཁྱེར་སེ་སར་རེ་ཡཱ་ཕི་ལིབ་པཱི་ཡུལ་དུ་ཕེབས་ནས་ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་“མི་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་སུ་ཡིན་ཟེར་”ཞེས་བཀའ་འདྲི་གནང་བས། ");
INSERT INTO bod_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ཁོ་ཚོས་“མི་ལ་ལས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན། ལ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ། ལ་ལས་ལུང་སྟོན་པ་ཡེ་རེམ་ཡཱ་དང༌། ཡང་ན་གནའ་རབས་ཀྱི་ལུང་སྟོན་པ་ཞིག་ཡིན་ཟེར་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ཁོང་གིས་ཁོ་རྣམས་ལ་“འོ་ན་ཁྱེད་ཚོས་བྱས་ན་ང་རང་སུ་ཡིན་ཟེར་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","སི་མོན་པེ་ཏྲོས་“ཁྱེད་ནི་མཱ་ཤི་ཀ་ཡིན་ཏེ་གཏན་དུ་གནས་པའི་དཀོན་མཆོག་གི་སྲས་ཡིན་ནོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ཡེ་ཤུས་ཁོང་ལ་“ཡོ་ནཱ་ཡི་བུ་སི་མོན་ཁྱེད་བདེ་བ་ཡིན་ནོ། གང་ཡིན་ཞེ་ན། མི་རྣམས་མིན་ཏེ་ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱིས་དེ་ལྟར་ཁྱེད་ལ་མངོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ཡང་ངས་ཁྱེད་ལ་ཟེར་རྒྱུར། ཁྱེད་པེ་ཏྲོ་ནི་བྲག་ཡིན་ཏེ། བྲག་དེའི་སྟེང་ལ་ངའི་ཆོས་ཚོགས་རྩིག་པར་བྱ། གཤིན་པོའི་ཁམས་ཀྱི་རྒྱལ་སྒོ་རྣམས་ཀྱང་དེ་ལས་མི་རྒྱལ་ལོ། ");
INSERT INTO bod_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ངས་དཀོན་མཆོག་ཞིང་ཁམས་ཀྱི་རྒྱལ་སྲིད་ཀྱི་ལྡེ་མིག་ཁྱེད་ལ་སྟེར་བས། ཁྱེད་ཀྱིས་ས་ལ་གང་འཆིང་བ་དེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལའང་འཆིང་བར་འགྱུར། ཁྱེད་ཀྱིས་ས་ལ་གང་འགྲོལ་བ་དེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལའང་འགྲོལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","དེ་ནས་ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་ཁོང་ནི་མཱ་ཤི་ཀ་ཡིན་པ་དེ་མི་གཞན་ལ་ཟེར་མི་ཆོག་ནན་གྱིས་བསྐུལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","དུས་དེ་ནས་བཟུང་ཡེ་ཤུས་རང་གི་ཉེ་གནས་རྣམས་ལ་ཁོང་ཡེ་རུ་ཤ་ལེམ་དུ་ཕེབས་ནས། ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒན་པོ་དང་བླ་ཆེན་རྣམས། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་བཅས་ཀྱིས་ཁོང་ལ་སྡུག་པོ་མང་པོ་གཏོང་ཞིང༌། ཁོང་གསོད་པར་འགྱུར་ལ། ཉི་མ་གསུམ་པར་འཆི་བ་ནས་ཡར་ལང་བར་འགྱུར་དགོས་པར་གསལ་བཤད་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","པེ་ཏྲོས་ཁོང་ཟུར་དུ་ཁྲིད་ཅིང་ནན་པོས་ཁོང་ལ་“གཙོ་བོ་ལགས། དེ་འདྲ་རྩ་བ་ནས་མི་སྲིད། ཁྱེད་ལ་ནམ་ཡང་དེ་འདྲ་འབྱུང་མི་སྲིད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","འོན་ཀྱང་ཡེ་ཤུས་ཞལ་ཕྱིར་སྐོར་ཏེ་པེ་ཏྲོ་ལ་“བདུད་སཱ་ཏན་ཁྱོད། ངའི་རྒྱབ་ཏུ་སོང་ཞིག ཁྱོད་ཀྱི་བསམ་པ་དཀོན་མཆོག་བཞིན་མ་ཡིན་པར་མི་བཞིན་ཡིན་པས་ངའི་བཀག་རྡོ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","དེ་ནས་ཡེ་ཤུས་རང་གི་ཉེ་གནས་རྣམས་ལ་“གལ་ཏེ་མི་སུ་ཞིག་གིས་ང་ཡི་རྗེས་སུ་འབྲང་འདོད་ན། རང་ཉིད་བློས་བཏང་ནས་རང་གི་རྒྱང་ཤིང་འཁུར་ཏེ་ང་ཡི་རྗེས་སུ་འབྲང་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","གང་ལགས་ཟེར་ན། མི་སུས་ཀྱང་རང་གི་སྲོག་ཐར་བར་བྱེད་འདོད་པ་དེས་བརླག་པར་འགྱུར། མི་སུས་ཀྱང་ང་རང་གི་དོན་དུ་རང་གི་སྲོག་གཏོང་པ་དེས་རྙེད་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","མི་སུ་ལ་འཇིག་རྟེན་ཧྲིལ་པོ་ཐོབ་ཀྱང་རང་སྲོག་བརླགས་ན་ཅི་ཕན། ཡང་ན་མིས་རང་གི་སྲོག་ཅི་དང་བརྗེའམ། ");
INSERT INTO bod_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","མིའི་རིགས་ཀྱི་བུ་ནི་རང་གི་ཡབ་ཀྱི་གཟི་བརྗིད་ཀྱི་སྒོ་ནས་རང་གི་ཕོ་ཉ་དང་མཉམ་དུ་འབྱོན་ཞིང༌། དེའི་དུས་སུ་ཁོང་གིས་མི་རེ་རེ་ལ་དེ་ཚོའི་བྱ་བ་དང་མཐུན་པར་ལན་གནང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། འདི་རུ་ཡོད་པའི་མི་རྣམས་ཀྱི་ནང་ནས་འགའ་ཞིག་གིས་མིའི་རིགས་ཀྱི་བུ་རང་གི་རྒྱལ་སྲིད་དབང་སྒྱུར་བའི་ཕྱིར་འབྱོན་པ་མ་མཐོང་བའི་བར་དུ་ཅི་ནས་ཀྱང་འཆི་བ་མྱོང་བར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ཉི་མ་དྲུག་གི་རྗེས་ལ་ཡེ་ཤུས་པེ་ཏྲོ་དང༌། ཡ་ཀོབ་དང༌། ཁོའི་གཅུང་པོ་ཡོ་ཧ་ནན་གསུམ་འཁྲིད་ནས་དབེན་པའི་གནས་རི་མཐོ་པོ་ཞིག་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ཁོ་ཚོའི་མདུན་དུ་ཁོང་གི་སྐུའི་རྣམ་པ་གྱུར་ཏེ། ཁོང་གི་ཞལ་རས་ཉི་མ་དང་འདྲ་བར་འོད་འཕྲོས་པ་དང༌། ཁོང་གི་ན་བཟའ་འོད་ལྟར་དཀར་པོ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","དེའི་སྐབས་ལ་ཁོང་ཚོའི་མདུན་དུ་ལུང་སྟོན་པ་མོ་ཤེ་དང་ཨེ་ལི་ཡཱ་གཉིས་མངོན་སུམ་དུ་བྱོན་ནས་ཁོང་དང་བཀའ་མོལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","པེ་ཏྲོས་ཡེ་ཤུ་ལ་“གཙོ་བོ་ལགས། ང་ཚོ་འདིར་བསྡད་ན་ལེགས། ཁྱེད་ཐུགས་དགྱེས་ན། ངས་བཞུགས་ས་གསུམ་བཟོ་བར་བྱ། ཁྱེད་ལ་གཅིག་དང་མོ་ཤེ་ལ་གཅིག ཨེ་ལི་ཡཱ་ལ་གཅིག་བཅས་ཡིན་”ཞེས་ཞུས་པའི་དུས་སུ། ");
INSERT INTO bod_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","འོད་དང་ལྡན་པའི་སྤྲིན་པ་ཞིག་ཡོང་ནས་ཁོང་ཚོ་བསྒྲིབས། སྤྲིན་པ་དེ་ནས་གསུང་ཞིག་བྱུང་སྟེ་“འདི་ནི་ངའི་གཅེས་པའི་སྲས་ཡིན་ཞིང༌། དེ་ལ་ང་ཤིན་ཏུ་དགའོ། ཁོང་ལ་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ཉེ་གནས་རྣམས་དེ་ཐོས་རྗེས་འཇིགས་ཤིང་སྐྲག་ནས་ཕྱག་འཚལ། ");
INSERT INTO bod_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ཡེ་ཤུ་ཕེབས་ཏེ་ཁོ་ཚོར་ཕྱག་རེག་ནས་“ད་ལོངས་ལ། མ་འཇིགས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ཁོ་ཚོས་ཡར་ལྟ་དུས་ཡེ་ཤུ་གཅིག་པུ་མ་གཏོགས་གཞན་སུ་ཡང་མ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ཁོང་རྣམས་རི་བོ་ལས་མར་འབབ་པའི་དུས་སུ། ཡེ་ཤུས་“མིའི་རིགས་ཀྱི་བུ་ནི་འཆི་བ་ནས་གསོན་པོར་མ་ལངས་པའི་བར་དུ་ཁྱེད་ཚོས་གང་མཐོང་བ་དེ་མི་གཞན་སུ་ལའང་མ་ཤོད་ཅིག་”ཅེས་བཀའ་བསྒོས། ");
INSERT INTO bod_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་“འོ་ན་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་ཅིའི་ཕྱིར་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་སྐྱབས་མགོན་མཱ་ཤི་ཀའི་སྔོན་ལ་འབྱོན་དགོས་ཟེར་བའི་དོན་ཅི་ཡིན་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ལན་དུ་ཁོང་གིས་“ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་དངོས་སུ་སྔོན་ལ་བྱོན་ཏེ་ཐམས་ཅད་སླར་གསོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","འོན་ཀྱང་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཕེབས་ཟིན་ནོ། ཁོ་རྣམས་ཀྱིས་ཁོང་ངོ་མ་ཤེས་པས་ཁོ་ཚོས་ཁོང་ལ་རང་འདོད་ལྟར་མནར་གཅོད་བཏང༌། དེ་ལྟར་མིའི་རིགས་ཀྱི་བུའང་ཁོ་ཚོའི་ལག་འོག་ནས་སྡུག་བསྔལ་མྱོང་བར་འགྱུར་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","དེ་རྗེས་ཁོང་གིས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་སྐོར་གསུངས་པ་ཉེ་གནས་རྣམས་ཀྱིས་གཞི་ནས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","མི་ཚོགས་ཀྱི་རྩར་ཕེབས་པའི་ཚེ་མི་གཅིག་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་པུས་མོ་སར་བཙུགས་ཏེ་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“གཙོ་བོ་ལགས། ངའི་བུ་ལ་ཐུགས་རྗེས་གཟིགས། ཁོ་ནི་གཟའ་ཕོག་པ་ཡིན་ཏེ། མེ་དང་ཆུའི་ནང་ལ་ཐེངས་མང་ལྷུངས་པས་སྡུག་བསྔལ་མང་པོ་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ངས་ཁོ་ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ཀྱི་རྩར་འཁྲིད་ཀྱང་ཁོ་ཚོས་བཅོས་མ་ཐུབ་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ལན་དུ་ཡེ་ཤུས་“དད་པ་མི་བྱེད་པ་དང་ངན་སེམས་ཅན་གྱི་མི་རབས་ཁྱོད་ཚོ། ང་དུས་ག་ཚོད་བར་དུ་ཁྱོད་ཚོ་མཉམ་དུ་སྡོད་དགོས་སམ། ང་རང་ཁྱོད་ཚོ་དུས་ནམ་ཞིག་གི་བར་བཟོད་པར་བྱེད་དགོས་སམ། བུ་དེ་ངའི་མདུན་དུ་ཁྲིད་ཤོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ཁོང་གིས་གདོན་འདྲེ་དེ་ལ་བཀའ་བཀྱོན་གནང་བས། བུ་དེའི་ནང་ནས་ཐོན་མ་ཐག་གསོས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","དེ་ནས་ཉེ་གནས་རྣམས་ཟུར་དུ་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་ཁོང་ལ་“ང་ཚོས་ཅིའི་ཕྱིར་གདོན་འདྲེ་དེ་བསྐྲད་མ་ཐུབ་བམ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོའི་དད་པ་ཆུང་བས་སོ། ངས་ཁྱོད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། གལ་སྲིད་ཁྱོད་ཚོ་ལ་དད་སེམས་ཡུངས་འབྲུ་རྡོག་པོ་ཆུང་ངུ་གཅིག་ཙམ་ཞིག་ཡོད་ན། ཁྱོད་ཚོས་རི་འདི་ལ། འདི་ནས་སྤོས་ལ་དེར་སོང་ཞིག་ཅེས་ཟེར་བས། དེ་ལྟར་སྤོ་བར་འགྱུར་ལ། ཁྱོད་རྣམས་ལ་ཡང་མི་སྲིད་པ་ཅིའང་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ཁོང་རྣམས་ག་ལིལ་ཡུལ་དུ་འཛོམས་པའི་ཚེ་ཡེ་ཤུས་ཁོ་ཚོར་“མིའི་རིགས་ཀྱི་བུ་ནི་མི་རྣམས་ཀྱི་ལག་ཏུ་གཏོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","དེ་རྣམས་ཀྱིས་ཁོ་རང་གསོད་པར་འགྱུར། ཉིན་ཞག་གསུམ་པར་ཁོ་རང་སླར་གསོན་པར་འགྱུར་ངེས་སོ་”ཞེས་གསུངས་པས། ཁོ་རྣམས་ཤིན་ཏུ་སེམས་འཁྲུགས། ");
INSERT INTO bod_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ཁོང་རྣམས་ཀ་ཕར་ན་ཧུམ་དུ་སླེབས་དུས་མཆོད་ཁང་གི་ཁྲལ་སྡུད་མཁན་རྣམས་པེ་ཏྲོའི་རྩར་ཡོང་ནས་ཁོང་ལ་“ཁྱེད་ཚོའི་སློབ་དཔོན་གྱིས་མཆོད་ཁང་གི་ཁྲལ་མི་འཇལ་ལམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","པེ་ཏྲོས་“འཇལ་ལོ་”ཞེས་ཟེར་བ་དང༌། ཁང་པའི་ནང་ལ་ཡོང་བའི་ཚེ་ཡེ་ཤུས་ཁོ་ལ་སྔོན་དུ་གསུངས་ཏེ་“སི་མོན། ཅི་ལྟར་སེམས། འཇིག་རྟེན་གྱི་རྒྱལ་པོ་རྣམས་ཀྱིས་སུ་ནས་ཁྲལ་སྡུད་དམ། རང་གི་བུའམ། གཞན་རྣམས་ནས་སྡུད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","པེ་ཏྲོས་“གཞན་རྣམས་ནས་སྡུད་”ཅེས་ཞུས། ཡེ་ཤུས་ཁོ་ལ་“འོ་ན་བུ་རྣམས་ཀྱིས་འཇལ་མི་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ང་ཚོས་ཁོ་ཚོར་ཕོག་ཐུག་མ་གཏོང་བའི་ཕྱིར་མཚོ་ལ་སོང་ནས་ལྕགས་ཀྱུ་ཆུའི་ནང་དུ་འཕེན་པ་དང༌། སྔོན་ལ་ཐོན་པའི་ཉ་དེ་བཟུང་ནས་དེའི་ཁ་ཕྱེ་ཏེ་ཊམ་ཀ་གཅིག་རྙེད་ཡོང༌། དེ་འཁྱེར་ནས་ངེད་གཉིས་ཀྱི་ཕྱིར་ཁོ་ཚོར་སྤྲོད་ཅིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","དེའི་དུས་སུ་ཉེ་གནས་རྣམས་ཡེ་ཤུའི་དྲུང་དུ་ཡོང་ནས་ཁོང་ལ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ཆེ་ཤོས་དེ་སུ་ཡིན་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ཡེ་ཤུས་ཕྲུ་གུ་ཞིག་བོས་ཏེ་ཁོ་ཚོའི་དཀྱིལ་ལ་བཞག་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། སེམས་བསྒྱུར་ནས་ཕྲུ་གུ་དང་འདྲ་བར་མ་གྱུར་ན། ཁྱེད་ཚོ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་ཅི་ནས་ཀྱང་འཛུལ་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","སུ་ཞིག་ཕྲུ་གུ་འདི་ལྟར་སྙེམས་ཆུང་དུ་འགྱུར་བ་ཁོ་ནི་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ཆེ་ཤོས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","སུས་ཀྱང་ཕྲུ་གུ་ཆུང་ངུ་འདི་འདྲ་བ་ཞིག་ངའི་མིང་གི་ཐོག་ནས་བསུ་བ་དེས་ང་རང་བསུ། ");
INSERT INTO bod_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","འོན་ཀྱང་མི་སུ་ཞིག་གིས་ང་ལ་དད་པ་བྱེད་པའི་བུ་ཕྲུག་འདི་ཚོ་ལས་གཅིག་ལ་ཡང་སླུ་བར་བྱས་ན། མི་དེའི་སྐེ་ལ་རང་འཐག་གི་རྡོ་ཆེན་པོ་ཞིག་བཏགས་ནས་རྒྱ་མཚོའི་གཏིང་དུ་ནུབ་ན་ལེགས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","བསླུ་བྲིད་ཀྱི་རྐྱེན་གྱིས་འཇིག་རྟེན་ལ་ཡ་རེ་ང༌། གང་ལགས་ཟེར་ན། བསླུ་བྲིད་འབྱུང་དགོས་ཀྱང༌། བསླུ་བྲིད་བྱེད་མཁན་དེ་ལ་ཡ་རེ་ང༌། ");
INSERT INTO bod_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","གལ་ཏེ་ཁྱེད་ཀྱི་ལག་པའམ་རྐང་པས་ཁྱེད་ལ་སྡིག་ཉེས་བྱེད་དུ་བཅུག་ན། དེ་བཅད་ནས་དབྱུགས་ཤིག ལག་པ་གཉིས་སམ། རྐང་པ་གཉིས་དང་ལྡན་པར་གསོད་པར་མི་འགྱུར་བའི་མེ་ལ་དབྱུག་པ་ལས། ཞ་བོར་གྱུར་ཡང་ཚེ་དཔག་ཏུ་མེད་པ་ཐོབ་པ་དེ་ལེགས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","གལ་ཏེ་ཁྱེད་ཀྱི་མིག་གིས་ཁྱེད་ལ་སྡིག་ཉེས་བྱེད་དུ་བཅུག་ན། མིག་དེ་བཏོན་ནས་དོར། ཁྱེད་རང་མིག་ཟུང་དང་ལྡན་པར་དམྱལ་ཁམས་ཀྱི་མེ་ལ་དབྱུག་པ་ལས། མིག་ཡ་གཅིག་མེད་ནའང་ཚེ་དཔག་ཏུ་མེད་པ་ཐོབ་པ་དེ་ལེགས་སོ། །” ");
INSERT INTO bod_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ཕྲུག་གུ་ཆུང་ངུ་འདི་རྣམས་ལས་གཅིག་ལ་ཡང་མཐོང་ཆུང་མ་བྱེད་ཅིག ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུ། ཁོ་ཚོའི་ཕོ་ཉ་རྣམས་ཀྱིས་ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱི་ཞལ་རས་རྒྱུན་དུ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ཁྱེད་ཚོས་ཅི་སེམས། ལུག་བརྒྱ་ཡོད་པ་གཅིག་ལས་བོར་བརླག་སོང་ན། དགུ་བཅུ་གོ་དགུ་དེ་རི་ལ་བཞག་ནས་བརླག་པ་དེ་མི་འཚོལ་ལམ། ");
INSERT INTO bod_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ལུག་དེ་རྙེད་ན་མ་བརླག་པའི་དགུ་བཅུ་གོ་དགུ་ལས་རྙེད་པའི་ལུག་གཅིག་པོ་དེའི་ཕྱིར་དེ་བས་དགའ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","དེ་བཞིན་དུ་ཕྲུ་གུ་ཆུང་ངུ་འདི་རྣམས་ལས་གཅིག་མེད་པར་འགྱུར་བ་ནི་ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་ཀྱི་དགོངས་པ་མ་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ཁྱེད་ཀྱི་སྤུན་ཟླ་ཡིས་སྡིག་ཉེས་བྱས་ན། ཁོ་ཟུར་དུ་འཁྲིད་ནས་ཁོའི་སྐྱོན་བརྗོད་པར་བྱེད། ཁོས་ཁྱེད་ཀྱི་ཁ་ལ་ཉན་ན་ཁྱེད་རང་གི་སྤུན་ཟླ་ཡང་བསྐྱར་རྙེད། ");
INSERT INTO bod_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","གལ་སྲིད་ཁྱེད་ཀྱི་ཁ་ལ་མ་ཉན་ན། དཔང་པོ་གཉིས་གསུམ་གྱི་ཁ་ཡིས་གཏམ་ཚང་མ་ནན་ཏན་བྱེད་པའི་ཕྱིར། རང་དང་མཉམ་དུ་མི་གཅིག་གམ་གཉིས་འཁྲིད་དེ་ཁོའི་རྩར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ཁོས་ཁོ་ཚོའི་ཁ་ལ་མ་ཉན་ན། ཆོས་ཚོགས་ལ་ཤོད། ཆོས་ཚོགས་ལའང་མ་ཉན་ན། ཁོ་དད་ལྡན་མིན་པ་དང་ཁྲལ་སྡུད་མཁན་ལྟར་རྩིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཚོས་ས་ལ་གང་འཆིང་བ་དེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལའང་འཆིང་བར་འགྱུར། ཁྱེད་ཚོས་ས་ལ་གང་འགྲོལ་བ་དེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལའང་འགྲོལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","དེ་མ་ཟད། ཁྱེད་ཚོ་གཉིས་ཀྱིས་གང་ཡང་ཞུ་བའི་སྐོར་ས་སྟེང་ལ་བློ་མཐུན་པར་བྱས་ན། ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱིས་དེ་ལྟར་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","གང་ལགས་ཤེ་ན། གང་དུ་ངའི་མིང་ཐོག་ནས་མི་གཉིས་སམ་གསུམ་འཛོམས་ན། དེར་ངའང་ཁོ་ཚོའི་ཁྲོད་དུ་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","དེ་ནས་པེ་ཏྲོ་ཡོང་ནས་ཁོང་ལ་“གཙོ་བོ་ལགས། ངའི་སྤུན་ཟླ་ཡིས་ང་ལ་སྡིག་ཉེས་བྱས་ན་ངས་ལན་ཇི་ཙམ་གྱི་བར་དུ་གུ་ཡངས་གཏོང་དགོས། ལན་བདུན་གྱིས་ཆོག་གམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ཡེ་ཤུས་ཁོ་ལ་“ལན་བདུན་མི་ཟེར་གྱི། བདུན་ཅུ་ཐེངས་བདུན་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","དེའི་ཕྱིར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་རང་གི་བྲན་གཡོག་རྣམས་དང་རྩིས་དག་ཞུ་འདོད་པའི་རྒྱལ་པོ་ཞིག་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","དེ་རྩིས་པའི་ཚེ་ཁོ་ལ་གསེར་གྱི་སྒོར་མོ་ས་ཡ་གཅིག་གི་བུ་ལོན་ཡོད་པ་ཞིག་རྒྱལ་པོའི་རྩར་ཁྲིད་དེ། ");
INSERT INTO bod_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ཁོ་ལ་བུ་ལོན་འཇལ་རྒྱུ་མེད་པས། རྒྱལ་པོས་ཁོ་དང༌། བཟའ་ཟླ། ཕྲུ་གུ ཁོ་ལ་ཡོད་པ་ཐམས་ཅད་བུ་ལོན་དེ་འཇལ་བའི་ཕྱིར་འཚོང་དགོས་པའི་བཀའ་མངགས། ");
INSERT INTO bod_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","དེ་བས་ན་བྲན་གཡོག་དེ་རྒྱལ་པོའི་དྲུང་དུ་ཕྱག་འཚལ་དེ་ཁོང་ལ། ང་ལ་བཟོད་པར་མཛོད་ཅིག ངས་ཁྱེད་ལ་བུ་ལོན་ཐམས་ཅད་འཇལ་ཡོང་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","དེ་ནས་རྒྱལ་པོ་སྙིང་རྗེ་སྐྱེས་ནས་བྲན་གཡོག་དེ་གློད་གྲོལ་བཏང་སྟེ་བུ་ལོན་དེ་བསལ། ");
INSERT INTO bod_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","འོན་ཀྱང་བྲན་གཡོག་དེ་ཕྱིར་སོང་ནས་རང་དང་མཉམ་པའི་བྲན་གཡོག་རྣམས་ཀྱི་ནང་ནས་ཁོ་ལ་དངུལ་སྒོར་བརྒྱ་ཡི་བུ་ལོན་ཡོད་པ་ཞིག་དང་ཐུག་པས། སྐེ་བཙིར་ཏེ་ཁོ་ལ། བུ་ལོན་འཇོལ་ཞིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","བྲན་གཡོག་དེས་པུས་མོ་སར་བཙུགས་ནས་ཁོ་ལ། ང་ལ་བཟོད་པ་སྒོམ་རོགས། ངས་ཁྱེད་ལ་བུ་ལོན་འཇལ་ཡོང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","འོན་ཀྱང་ཁོས་མ་ཉན་པར་སོང་ནས་བུ་ལོན་འཇལ་མ་ཚར་བའི་བར་དུ་བྲན་གཡོག་དེ་བཙོན་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","བྲན་གཡོག་གཞན་རྣམས་ཀྱིས་དེ་མཐོང་ནས་སེམས་ཤིན་ཏུ་འཁྲུགས་པར་གྱུར་ཏེ། རྒྱལ་པོའི་དྲུང་དུ་སོང་ནས་གནས་ཚུལ་དེ་ཐམས་ཅད་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","རྒྱལ་པོས་བྲན་གཡོག་དེ་བོས་ནས་ཁོ་ལ། གཡོག་པོ་ངན་པ་ཁྱོད། ཁྱོད་ཀྱིས་ང་ལ་ཞུ་བ་ཆེན་པོ་ཕུལ་བས་ངས་ཁྱོད་ཀྱི་བུ་ལོན་ཐམས་ཅད་བསལ། ");
INSERT INTO bod_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ངས་ཁྱོད་ལ་སྙིང་རྗེ་བྱས་པ་ལྟར། ཁྱོད་ཀྱིས་ཀྱང་རང་དང་མཉམ་པའི་བྲན་གཡོག་ལ་སྙིང་རྗེ་བྱེད་དགོས་པ་མ་ཡིན་ནམ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","རྒྱལ་པོ་ཁྲོས་ནས་བུ་ལོན་ཐམས་ཅད་འཇལ་མ་ཚར་བའི་བར་མནར་གཅོད་གཏོང་མཁན་རྣམས་ལ་གཏད། ");
INSERT INTO bod_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","གལ་ཏེ་ཁྱོད་ཚོ་མི་རེ་རེས་སེམས་གཏིང་ནས་རང་གི་སྤུན་ཟླར་གུ་ཡངས་མ་བཏང་ན། ཞིང་ཁམས་སུ་བཞུགས་པའི་ངའི་ཡབ་ཀྱིས་ཀྱང་ཁྱོད་ཚོར་དེ་ལྟར་མཛད་ངེས་ཡིན་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ཡེ་ཤུས་བཀའ་དེ་ཚོ་གསུངས་ཚར་ནས། ག་ལིལ་ཡུལ་དང་ཁ་བྲལ་ཏེ་ཡོར་དན་གཙང་པོའི་ཕར་ཕྱོགས་ཀྱི་ཡ་ཧུ་དཱ་ཡུལ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","མི་ཚོགས་མང་པོ་ཁོང་གི་རྗེས་སུ་འབྲངས་ཤིང་ཁོང་གིས་ས་ཆ་དེར་ཁོ་ཚོའི་ནད་གསོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ཕཱ་རུ་ཤི་པ་འགའ་ཤས་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་ཁོང་ལ་ཉམས་ཚོད་ལེན་ཕྱིར་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་སྐྱེས་པས་རྒྱུ་མཚན་གང་གིས་ཀྱང་རང་གི་བཟའ་ཟླ་བཞག་ཆོག་གམ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ལན་དུ་ཁོང་གིས་“ཁོ་ཚོ་ཐོག་མར་མཛད་མཁན་གྱིས་མི་ཕོ་མོ་གཉིས་མཛད་པ་ཡིན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","རྒྱུ་མཚན་དེའི་རྐྱེན་གྱིས་སྐྱེས་པས་རང་གི་ཕ་མ་བཞག་ནས་རང་གི་བཟའ་ཟླ་དང་མཉམ་དུ་འདུས་ཤིང༌། ཁོ་གཉིས་ཤ་རུས་གཅིག་ཏུ་འགྱུར་ཞེས་ཁྱེད་ཚོས་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","དེ་ལྟར་ན་སོ་སོ་བ་མིན་ཏེ་གཅིག་རང་ཡིན་པས། དཀོན་མཆོག་གིས་གང་སྦྲེལ་བར་མཛད་པ་དེ་མི་སུས་ཀྱང་འཕྲལ་བར་མི་རུང་ངོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ཁོ་ཚོས་ཁོང་ལ་“འོ་ན་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་ཅིའི་ཕྱིར་བཟའ་ཚང་ཁ་བྲལ་བའི་ཡི་གེ་བྲིས་ནས་ཁོ་མོ་ཕར་བཏང་ན་འགྲིག་ཅེས་པའི་བཀའ་གནང་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོ་སེམས་མཁྲེགས་པོ་ཡིན་པས་མོ་ཤེ་ཡིས་བཟའ་ཚང་ཁ་བྲལ་བའི་ཁྲིམས་གནང༌། འོན་ཀྱང་ཐོག་མ་ནས་དེ་ལྟར་མེད། ");
INSERT INTO bod_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། ལོག་གཡེམ་གྱི་རྒྱུ་མཚན་མ་གཏོགས་པར། སུས་ཀྱང་རང་གི་བཟའ་ཟླ་བཞག་ནས་བུད་མེད་གཞན་ཞིག་བཟའ་ཟླར་བླངས་ན་ལོག་གཡེམ་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་“སྐྱེས་པ་དང་བཟའ་ཟླའི་གནས་ཚུལ་དེ་ལྟར་ཡིན་ན་ཆང་ས་མ་བརྒྱབ་ན་ལེགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","འོན་ཀྱང་ཁོང་གིས་ཁོ་ཚོར་“སུ་ལ་གནང་བ་དེས་མ་གཏོགས་པར། མི་ཐམས་ཅད་ཀྱིས་གཏམ་དེ་དང་ལེན་བྱེད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","གང་ཡིན་ཟེར་ན། ཉུག་རུམ་ཁ་ཅིག་ནི་ཨ་མའི་མངལ་ནས་དེ་ལྟར་སྐྱེས་པ་ཡིན་ཞིང༌། ཁ་ཅིག་ནི་མི་རྣམས་ཀྱིས་ཉུག་རུམ་བཟོས། ཁ་ཅིག་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་དོན་ལ་རང་གིས་རང་ཉུག་རུམ་དུ་བྱས། གཏམ་དེ་དང་ལེན་བྱེད་ཐུབ་མཁན་གྱིས་དང་ལེན་བྱེད་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","དེའི་ཚེ་ཁོང་གིས་ཁོ་རྣམས་ལ་ཕྱག་འཇོག་པར་མཛད་ནས་གསོལ་སྨོན་འདེབས་པའི་ཕྱིར་མི་རྣམས་ཀྱིས་ཕྲུ་གུ་འགའ་ཞིག་ཁོང་གི་མདུན་དུ་འཁྲིད། ཉེ་གནས་རྣམས་ཀྱིས་འཁྲིད་མཁན་ལ་གཤེ་གཤེ་བཏང་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ཡེ་ཤུས་“ཕྲུ་གུ་ཆུང་ངུ་མ་འགོག་པར་ངའི་རྩར་ཡོང་བར་ཆོག གང་ཡིན་ཞེ་ན། ཁོ་ཚོ་དང་འདྲ་བ་རྣམས་ལ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཡོད་པའི་ཕྱིར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ཁོ་རྣམས་ལ་ཕྱག་བཞག་རྗེས་ས་ཆ་དེ་ནས་ཁ་བྲལ། ");
INSERT INTO bod_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","དེ་ནས་མི་ཞིག་ཁོང་གི་མདུན་དུ་ཡོང་ནས་ཁོང་ལ་“སློབ་དཔོན་ལགས། དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པའི་ཕྱིར་ངས་ལས་བཟང་པོ་གང་ཞིག་བྱེད་དགོས་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ཁོང་གིས་“བཟང་པོ་གང་ཡིན་པའི་སྐོར་ང་ལ་ཅིའི་ཕྱིར་འདྲིས། བཟང་པོ་ཡིན་པ་གཅིག་རང་ཡིན། དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་འདོད་ན་བཀའ་ཁྲིམས་རྣམས་སྲུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","མི་དེས་ཁོང་ལ་“གང་སྲུང་དགོས་”ཞེས་ཟེར་བས་ཡེ་ཤུས་“མི་སྲོག་མ་གཅོད། ལོག་གཡེམ་མ་བྱེད། མ་རྐུ། རྫུན་གྱི་དཔང་པོ་མ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","རང་གི་ཕ་མ་གཉིས་ལ་བརྩི་བཀུར་བྱེད། ཁྱིམ་མཚེས་ལ་རང་དང་འདྲ་བར་བརྩེ་བར་ཟུངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","གཞོན་ནུ་དེས་ཁོང་ལ་“ངས་དེ་ཚོ་ཐམས་ཅད་བསྲུངས། ད་དུང་ཅི་མ་ཚང་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ཡེ་ཤུས་ཁོ་ལ་“མ་ཚང་བ་མེད་པར་འགྱུར་འདོད་ན། སོང་ལ། ནོར་ཐམས་ཅད་བཙོངས་ཏེ་དབུལ་པོ་རྣམས་ལ་བྱིན་ཞིག ཁྱེད་ལ་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བྱ་དགའ་འཐོབ་པར་འགྱུར། དེ་ནས་ཚུར་ཤོག་ལ་ངའི་རྗེས་སུ་འབྲང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","གསུང་དེ་ཐོས་ནས་གཞོན་ནུ་དེའི་སེམས་སྐྱོ་བར་གྱུར་ནས་ཕར་སོང༌། གང་ཡིན་ཞེ་ན། ཁོ་ལ་ནོར་རྫས་མང་པོ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ཡེ་ཤུས་རང་གི་ཉེ་གནས་རྣམས་ལ་“ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་ཕྱུག་པོ་ཞིག་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་དུ་འགྲོ་བ་དེ་ཤིན་ཏུ་དཀའོ། ");
INSERT INTO bod_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ངས་ཡང་བསྐྱར་ཟེར་རྒྱུར། མི་ཕྱུག་པོ་ཞིག་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ལ་འགྲོ་བ་ལས་རྔ་མོང་ཞིག་ཁབ་མིག་བརྒྱུད་ནས་འགྲོ་བ་སླའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","དེ་ཐོས་ནས་ཉེ་གནས་རྣམས་ཧ་ལས་ཏེ་“འོ་ན་སུ་ལ་ཐར་པ་འཐོབ་སྲིད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ཡེ་ཤུས་ཁོ་རྣམས་ལ་གཟིགས་ཏེ་“དེ་ནི་མི་རྣམས་ལ་མི་སྲིད་ཀྱང་དཀོན་མཆོག་ལ་ཐམས་ཅད་འགྲུབ་པར་སྲིད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","དེ་ནས་པེ་ཏྲོས་ཁོང་ལ་“གཟིགས་དང༌། ང་ཚོས་ཐམས་ཅད་དོར་ནས་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲངས་པ་ཡིན་པས། ང་ཚོར་གང་ཞིག་འཐོབ་ཡོང་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཐམས་ཅད་གསར་དུ་མཛད་པའི་ཚེ། མིའི་རིགས་ཀྱི་བུ་རང་གི་གཟི་བརྗིད་ལྡན་པའི་ཁྲི་ལ་བཞུགས་པའི་སྐབས་སུ། ཁྱེད་ཚོ་ངའི་རྗེས་སུ་འབྲང་བ་རྣམས་ཀྱིས་ཀྱང་ཁྲི་བཅུ་གཉིས་ལ་བསྡད་ནས་ཡི་སི་ར་ཨེལ་གྱི་ཚོ་ཁག་བཅུ་གཉིས་ལ་ཁྲིམས་གཅོད་བྱེད་འོང༌། ");
INSERT INTO bod_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","མི་སུ་ཞིག་གིས་ངའི་མིང་གི་དོན་དུ་རང་གི་ཁང་པའམ། སྤུན་ནམ། སྲིང་མོ་འམ། ཕ་མའམ། བུ་ཕྲུག་གམ། ས་ཞིང་བཅས་བཞག་ན། ཁོ་ལ་ལྡབ་བརྒྱ་འཐོབ་པ་མ་ཟད། དཔག་ཏུ་མེད་པའི་ཚེ་ཡང་འཐོབ་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","འོན་ཀྱང་དང་པོ་ཡིན་པའི་མི་མང་པོ་མཐའ་མར་འགྱུར་ཞིང༌། མཐའ་མ་ཡིན་པ་མང་པོའང་དང་པོར་འགྱུར་འོང་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ཡེ་ཤུས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་སྐྱ་རེངས་ཤར་དུས་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་གླ་པ་འཚོལ་བར་སོང་བའི་ཁྱིམ་བདག་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ཁོང་གིས་གླ་པ་རྣམས་ལ་ཉི་མ་རེར་དངུལ་སྒོར་གཅིག་གི་གླ་ཆ་སྤྲོད་རྒྱུའི་ཁས་ལེན་བྱས་ནས། ཁོའི་རྒུན་འབྲུམ་གྱི་ལྡུམ་རར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ཞོགས་པའི་ཆུ་ཚོད་དགུ་པའི་ཙམ་ལ་ཡང་བསྐྱར་ཕྱིར་འགྲོ་དུས། ཁྲོམ་ལ་ལས་ཀ་མེད་པའི་གླ་པ་གཞན་རྣམས་ཡོད་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ཁོ་ཚོར། རྒུན་འབྲུམ་གྱི་ལྡུམ་རར་སོང་ཞིང༌། གླ་གང་འོས་པ་ཁྱེད་ཚོར་སྤྲོད་རྒྱུ་ཡིན་ཞེས་སྨྲས་པས་ཁོ་རྣམས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ཁོ་ཉིན་གུང་དང་ཆུ་ཚོད་གསུམ་པའི་ཙམ་ལ་ཡང་སོང་ནས་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ཡང་ཆུ་ཚོད་ལྔ་པའི་ཙམ་ལ་ཕྱིར་ཐོན་ནས་ལས་ཀ་མེད་པ་གཞན་རྣམས་མཐོང་ནས་ཁོ་ཚོར། ཁྱེད་ཚོ་ཅིའི་ཕྱིར་ལས་ཀ་མེད་པར་ཉིན་གང་འདིར་སྡོད་ཅེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ཁོ་ཚོས། མི་སུས་ཀྱང་ང་ཚོ་མ་གླས་ཞེས་ཟེར་བས། བདག་པོས། ཁྱེད་ཚོ་ཡང་རྒུན་འབྲུམ་གྱི་ལྡུམ་རར་སོང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","དགོང་དྲོར་སླེབས་དུས་བདག་པོས་དོ་དམ་པར། གླ་པ་རྣམས་བོས་ལ། མཐའ་མ་ནས་དང་པོའི་བར་དུ་གླ་ཆ་སྤྲོད་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ཆུ་ཚོད་ལྔ་པར་གླས་པའི་མི་རྣམས་ཡོང་ནས་རེ་རེ་ལ་དངུལ་སྒོར་གཅིག་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","དང་པོར་གླས་པའི་མི་རྣམས་ཡོང་ནས་དེ་ལས་ལྷག་པར་འཐོབ་རྒྱུ་ཡིན་པ་སྙམ་ཡང༌། ཁོ་ཚོ་རེ་རེ་ལ་ཡང་དངུལ་སྒོར་གཅིག་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","དེ་ཐོབ་དུས་བདག་པོ་ལ་མ་རངས་པའི་གཏམ་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ཁྱེད་ཀྱིས་མཐའ་མར་གླས་པའི་མིས་ཆུ་ཚོད་གཅིག་ལས་ཀ་བྱས་པ་དང༌། ང་ཚོ་ཉིན་གང་ཉི་མ་ཚ་པོའི་འོག་ལ་དཀའ་ལས་རྒྱག་པ་རྣམས་འདྲ་མཉམ་བཟོས་སོ་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ལན་དུ་བདག་པོས་ཁོ་ཚོ་ལས་གཅིག་ལ། གྲོགས་པོ། ངས་ཁྱེད་ལ་དྲང་པོ་མིན་པ་མི་བྱེད། ཁྱེད་ཀྱིས་ཉི་མ་གཅིག་ལ་དངུལ་སྒོར་གཅིག་གི་གླ་ཆ་འཐོབ་རྒྱུའི་ཁས་ལེན་མ་བྱས་སམ། ");
INSERT INTO bod_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","རང་ལ་ཐོབ་པ་དེ་འཁྱེར་ནས་སོང༌། ཁྱེད་དང་འདྲ་བ་མཐའ་མའི་མི་འདི་ལའང་གླ་ཆ་སྤྲོད་པར་འདོད། ");
INSERT INTO bod_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ང་རང་ལ་ཡོད་པ་དེས་ང་རང་གི་འདོད་པ་ལྟར་བྱས་ན་མི་ཆོག་གམ། ཡང་ན་ང་གཏོང་ཕོད་ཆེ་བ་ཡིན་པས་ཁྱེད་རང་ཕྲག་དོག་སྐྱེས་སམ་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","དེ་ལྟར་མཐའ་མ་ཡིན་པ་རྣམས་དང་པོར་འགྱུར་ཞིང༌། དང་པོ་ཡིན་པ་རྣམས་མཐའ་མར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ཡེ་ཤུ་རྒྱལ་ས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་པའི་དུས་སུ་ཉེ་གནས་བཅུ་གཉིས་པོ་ཟུར་དུ་འཁྲིད་དེ་ཁོ་རྣམས་ལ། ");
INSERT INTO bod_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ཉོན་ཞིག ད་ལྟ་ང་ཚོ་ཡེ་རུ་ཤ་ལེམ་དུ་འགྲོ་བཞིན་ཡོད། མིའི་རིགས་ཀྱི་བུ་ནི་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱི་དབང་འོག་ཏུ་བཏང་ནས། ཁོ་ཚོས་ཁོ་རང་གསོད་དགོས་པའི་ཁྲིམས་ཐག་བཅད་ནས། ");
INSERT INTO bod_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ཁོང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་གཏད་དེ། ཁོ་ཚོས་ཁོ་རང་ལ་འཕྱ་དམོད་བྱེད་པ་དང༌། རྟ་ལྕག་གིས་བརྡུངས་ནས་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་པའི་སྒོ་ནས་གསོད་པའི་ཕྱིར། དེ་ནས་ཉིན་གསུམ་པར་ཁོང་སླར་གསོན་པར་འགྱུར་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","དེ་ནས་ཟེ་བད་ཡཱ་ཞེས་པའི་བུ་གཉིས་ཀྱི་ཨ་མས་རང་གི་བུ་ཁྲིད་དེ་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་པུས་མོ་སར་བཙུགས་ཏེ་ཞུ་བ་གཅིག་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ཁོང་གིས་ཁོ་མོར་“ཁྱེད་ཅི་འདོད་”ཅེས་གསུངས་པས་ཁོ་མོས་“ངའི་བུ་འདི་གཉིས་ཁྱེད་ཀྱི་རྒྱལ་སྲིད་ནང་ལ་གཅིག་ཁྱེད་ཀྱི་གཡས་ཕྱོགས་དང་གཅིག་གཡོན་ཕྱོགས་སུ་སྡོད་དུ་འཇུག་པར་བཀའ་གནང་བར་མཛོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ལན་དུ་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོས་གང་ཞུ་བའི་དོན་མི་ཤེས་ཏེ། ངས་འཐུང་དགོས་པའི་ཕོར་པ་དེ་ཁྱེད་ཚོས་འཐུང་ཐུབ་བམ་”ཞེས་གསུངས་པ་ལ། ཁོ་ཚོས་ཁོང་ལ་“ཐུབ་བོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོས་ངའི་ཕོར་པ་དེ་འཐུང་བར་འགྱུར་ཡང༌། ངའི་གཡས་གཡོན་ལ་སྡོད་དུ་འཇུག་པའི་དབང་ཆ་དེ་ང་ལ་མེད། ངའི་ཡབ་ཀྱིས་མི་སུ་ལ་བཤམས་པ་ཡིན་པ་དེ་ལ་འཐོབ་བོ་”ཞེས་གསུངས་སོ། ");
INSERT INTO bod_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ཉེ་གནས་བཅུ་པོས་གཏམ་དེ་ཐོས་དུས་སྤུན་དེ་གཉིས་ལ་ཁོང་ཁྲོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ཡེ་ཤུས་ཁོ་ཚོ་རང་གི་དྲུང་དུ་བོས་ཏེ་“ཁྱེད་ཚོས་ཤེས་པ་ལྟར། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་དཔོན་རིགས་ཀྱིས་ཁོ་ཚོར་དབང་བྱེད་ཅིང༌། ཁོ་ཚོའི་ནང་ནས་མི་ཆེན་པོ་རྣམས་ཀྱིས་ཁོ་ཚོར་དབང་བསྒྱུར། ");
INSERT INTO bod_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","འོན་ཀྱང་ཁྱེད་ཚོའི་ནང་དུ་དེ་ལྟར་མ་ཡིན། ཁྱེད་ཚོ་ལས་སུ་ཞིག་ཆེན་པོར་འགྱུར་འདོད་པ་དེ་ཁྱེད་ཚོའི་གཡོག་པོར་འགྱུར་དགོས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ཁྱེད་ཚོ་ལས་སུ་ཞིག་དང་པོར་འགྱུར་འདོད་པ་དེ་མི་ཀུན་གྱི་བྲན་གཡོག་ཏུ་འགྱུར་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","དེ་བཞིན་དུ་མིའི་རིགས་ཀྱི་བུ་ཡང་གཞན་གྱིས་རང་ལ་གཡོག་བྱེད་པའི་ཕྱིར་ཡོང་བ་མ་ཡིན་པར། གཞན་ལ་གཡོག་བྱེད་པ་དང་རང་སྲོག་ཕུལ་ནས་མི་མང་པོ་བླུ་རིན་དུ་འགྱུར་ཕྱིར་ཡོང་བ་ཡིན་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ཁོང་རྣམས་ཡེ་རུ་ཀོ་ཞེས་བྱ་བའི་གྲོང་ཁྱེར་ནས་ཐོན་པའི་སྐབས་སུ་མི་ཚོགས་མང་པོ་ཞིག་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ལམ་ཁར་བསྡད་ཡོད་པའི་ལོང་བ་གཉིས་ཀྱིས་ཡེ་ཤུ་ཉེ་བར་ཕེབས་པར་ཐོས་ནས་སྐད་ཆེན་པོས་“གཙོ་བོ་ལགས། རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས། ང་ཚོ་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","མི་ཚོགས་ཀྱིས་དེ་གཉིས་ལ་ཁ་ཁུ་སིམ་པོར་སྡོད་དགོས་པར་ནན་གྱིས་བཤད་ཀྱང༌། ཁོ་ཚོས་སྔོན་ལས་ལྷག་པར་སྐད་ཆེན་པོས་“གཙོ་བོ་ལགས། རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས། ང་ཚོ་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ཡེ་ཤུས་ཕེབས་མཚམས་བཞག་སྟེ་ཁོ་ཚོ་བོས་ནས་“ངས་ཁྱེད་ཚོར་གང་བྱེད་དགོས་སམ་”ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ཁོ་ཚོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ང་ཚོའི་མིག་གིས་མཐོང་བར་འདོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ཡེ་ཤུ་ཐུགས་རྗེ་སྐྱེས་ཏེ་ཁོ་ཚོའི་མིག་ཟུང་ལ་ཕྱག་རེག་མ་ཐག མིག་གིས་མཐོང་བར་གྱུར་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་གྱི་ཉེ་འགྲམ་དུ་ཕེབས་སྐབས། སྐྱུར་རུ་ཤིང་གི་རིའི་ངོས་སུ་ཡོད་པའི་གྲོང་སྡེ་པེ་ཕ་གེ་ཞེས་བྱ་བའི་ས་ཆ་དེར་ཡེ་ཤུས་ཉེ་གནས་གཉིས་མངགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ཁོ་ཚོར་“ཁྱེད་ཚོ་མདུན་ལ་ཡོད་པའི་གྲོང་སྡེ་དེ་ལ་སོང་དང༌། དེར་སླེབས་མ་ཐག་ཏུ་བོང་བུ་དང་བོང་ཕྲུག་བཏགས་ཡོད་པ་མཐོང་བར་འགྱུར། དེ་ཚོ་བཀྲོལ་ནས་ངའི་རྩར་འཁྲིད་ཤོག ");
INSERT INTO bod_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","གལ་སྲིད་སུ་ཞིག་གིས་ཁྱེད་ཚོ་ལ་ཇི་ཞིག་ཟེར་ན། གཙོ་བོ་ལ་དགོས་ཞེས་སྨྲོས་དང༌། དེས་མྱུར་དུ་གཏོང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","འདི་ནི་ལུང་སྟོན་པ་བརྒྱུད་ནས་གསུངས་པ་དེ་སྒྲུབ་པའི་ཆེད་དུ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ཙི་ཡོན་ཡུལ་གྱི་བུ་མོར་སྨྲོས། ། ལྟོས་དང་ཁྱེད་ཚོའི་རྒྱལ་པོ་དེ། ། བོང་བུར་བཅིབས་ནས་སྙེམས་ཆུང་ངང༌། ། ཁྱེད་ཚོའི་ས་ལ་ཕེབས་བཞིན་འདུག ། ཅེས་པ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ཉེ་གནས་དེ་རྣམས་སོང་ནས་ཡེ་ཤུས་བཀའ་གནང་བ་ལྟར་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","བོང་བུ་དང་བོང་ཕྲུག་འཁྲིད་ཡོང་ནས། རང་གི་ཕྱི་གོས་དེའི་སྟེང་ལ་བཞག་སྟེ་ཁོང་གིས་དེ་ལ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","མི་ཚོགས་མང་པོས་རང་གི་གྱོན་པ་ལམ་ལ་བཏིང་ཞིང༌། གཞན་རྣམས་ཀྱིས་ཤིང་གི་ཡལ་ག་བཅད་དེ་ལམ་དུ་བཀྲམ། ");
INSERT INTO bod_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ཁོང་གི་སྔོན་ནས་འགྲོ་བ་དང་རྗེས་སུ་འབྲངས་བའི་མི་རྣམས་ཀྱིས་སྐད་ཆེན་པོས། དཱ་བིད་སྲས་ལ་ཧོ་ཟན་ནཱ། ། གཙོ་བོའི་མཚན་གྱི་ཐོག་ནས་ནི། ། ཤིན་ཏུ་མཐོ་ཤིང་བླ་ན་མེད། ། དཀོན་མཆོག་ལ་ནི་ཧོ་ཟན་ནཱ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ཁོང་ཡེ་རུ་ཤ་ལེམ་དུ་བྱོན་དུས་མི་ཚང་མ་ཕར་ཚུར་བརྒྱུགས་ནས་“འདི་སུ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","མི་ཚོགས་ཀྱིས་“འདི་ནི་ག་ལིལ་ཡུལ་གྱི་ན་ཙ་རེལ་གྲོང་སྡེ་ནས་ཡིན་པའི་ལུང་སྟོན་པ་ཡེ་ཤུ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཕེབས་ནས། དེར་ཡོད་པའི་ཉོ་ཚོང་མཁན་རྣམས་ཕྱི་ལ་བཏོན་པར་མཛད། དངུལ་རྗེ་མཁན་གྱི་ཅོག་ཙེ་དང་ཕུག་རོན་ཚོང་མཁན་གྱི་འདུག་སྟེགས་ཀྱང་སར་བསྒྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ཁོང་གིས་མི་དེ་ཚོར་“དཀོན་མཆོག་གི་གསུང་རབ་ལས། ངའི་ཁང་པ་ལ་སྨོན་ལམ་འདེབས་སའི་ཁང་པ་ཟེར་བར་འགྱུར་ཞེས་འཁོད། འོན་ཀྱང་ཁྱོད་ཚོས་ཇག་ཚང་ལྟ་བུ་ཞིག་ཏུ་སྒྱུར་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ལོང་བ་དང་ཞ་བོ་རྣམས་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཁོང་གི་མདུན་དུ་ཡོང་ནས་ཁོང་གིས་མི་དེ་ཚོའི་ནད་གསོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་ཁོང་གིས་བསྒྲུབས་པའི་ངོ་མཚར་ཆེ་བའི་མཛད་པ་མཐོང་བ་དང༌། ཡང་མཆོད་ཁང་གི་ཁྱམས་རའི་ཕྲུ་གུ་རྣམས་ཀྱིས་སྐད་ཆེན་པོས་“རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ལ་ཧོ་ཟན་ནཱ་”ཞེས་སྨྲས་པ་ཐོས་ནས་ཁྲོས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ཁོང་ལ་“ཕྲུ་གུ་དེ་རྣམས་ཀྱིས་གང་བཤད་པ་ཐོས་སམ་”ཞེས་སྨྲས་པས་ཡེ་ཤུས་ཁོ་ཚོར་“ཐོས་སོ། ཕྲུ་གུ་དང་འོ་འཐུང་བའི་བྱིས་པ་རྣམས་ཀྱིས་ཁྱེད་ལ་བསྟོད་བསྔགས་བྱེད་དུ་བཅུག་ཅེས་མདོ་ལས་བཀླགས་མ་མྱོང་ངམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","དེ་ནས་ཡེ་ཤུས་ཁོ་རྣམས་བཞག་སྟེ་གྲོང་ཁྱེར་ཁ་བྲལ་ནས་པེ་ཐན་ཡཱ་གྲོང་སྡེ་ལ་ཕེབས་པ་དང༌། མཚན་མོ་དེར་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","དེའི་སང་ཞོགས་རྒྱལ་སར་ཕྱིར་ཕེབས་པའི་དུས་སུ་ཡེ་ཤུ་བཀྲེས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ལམ་གྱི་ཟུར་ལ་བསེ་ཡབ་ཤིང་སྡོང་ཞིག་གཟིགས་ཏེ། དེའི་རྩར་ཕེབས་དུས་ལོ་མ་ལས་གཞན་ཅི་ཡང་མེད་པ་གཟིགས་པས་དེ་ལ་“ད་ནས་བཟུང་འབྲས་བུ་ནམ་ཡང་མ་སྐྱེད་ཅིག་”ཅེས་གསུངས་མ་ཐག བསེ་ཡབ་ཤིང་དེ་བསྐམས། ");
INSERT INTO bod_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","དེ་མཐོང་ནས་ཉེ་གནས་རྣམས་ཡ་མཚན་དུ་གྱུར་ནས་“བསེ་ཡབ་ཤིང་དེ་ལྟར་མགྱོགས་པོ་ཅི་ལྟར་བསྐམས་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། ཐེ་ཚོམ་མེད་པར་དད་པ་བྱས་ན། བསེ་ཡབ་ཤིང་ལ་གང་བྱས་པ་དེ་ཁྱེད་ཚོས་ཀྱང་དེ་ལྟར་བྱེད་པར་འགྱུར་བ་མ་ཟད། རི་འདི་ལ། འདི་ནས་བཀོག་པར་འགྱུར་ཞིང་རྒྱ་མཚོའི་ནང་ལ་དབྱུགས་པར་འགྱུར་ཞིག་ཅེས་ཟེར་ན། དེ་ལྟར་འགྲུབ་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","དད་པའི་སྒོ་ནས་གང་སྨོན་ལམ་ཞུ་བ་ཐམས་ཅད་འཐོབ་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཕེབས་པ་དང༌། ཁོང་གིས་ཆོས་བསྟན་གནང་བའི་དུས་སུ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཡུལ་མི་རྣམས་ཀྱི་རྒན་པོ་ཚོ་ཁོང་གི་མདུན་དུ་ཡོང་ནས་“ཁྱེད་ཀྱིས་དབང་ཆ་གང་གི་སྒོ་ནས་དོན་འདི་ཚོ་མཛད། ཡང་སུ་ཞིག་གིས་ཁྱེད་ལ་དོན་འདི་རྣམས་མཛད་པའི་དབང་ཆ་སྤྲད་པ་ཡིན་ནམ་”ཞེས་བཤད་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ཡེ་ཤུས་ཁོ་ཚོར་“ངས་ཀྱང་ཁྱེད་རྣམས་ལ་དྲི་བ་གཅིག་འདྲི་རྒྱུ་ཡིན། ཁྱེད་ཚོས་དེའི་ལན་བཏབ་ན། ངས་དོན་འདི་རྣམས་དབང་ཅི་ལྟ་བུས་མཛད་པའང་ཁྱེད་རྣམས་ལ་ཤོད་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་མཛད་པ་དེ་གང་ནས་བྱུང༌། དཀོན་མཆོག་ནས་བྱུང་ངམ། མི་ནས་བྱུང་”ཞེས་གསུངས་པས། ཁོ་ཚོས་ཕན་ཚུན་གཏམ་གླེང་བྱས་ཤིང་“གལ་ཏེ་དཀོན་མཆོག་ནས་བྱུང་ཞེས་བཤད་ན། ཁོང་གིས་ང་ཚོར་འོ་ན་ཁྱེད་རྣམས་ཀྱིས་ཅིའི་ཕྱིར་ཁོང་ལ་དད་པ་མ་བྱས་སམ་ཞེས་གསུང་ངེས་ལ། ");
INSERT INTO bod_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","མི་ལས་བྱུང་ཞེས་བཤད་ན། མི་ཐམས་ཅད་ཀྱིས་ཡོ་ཧ་ནན་ལུང་སྟོན་པར་རྩི་བའི་རྐྱེན་གྱིས་ང་ཚོ་མི་ཚོགས་ལ་འཇིགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","དེར་བརྟེན་ཡེ་ཤུ་ལ་“ང་ཚོས་མི་ཤེས་”ཞེས་ལན་བཏབ་པས་ཁོང་གིས་ཁོ་ཚོར་“དེས་ན་ངས་ཀྱང་དོན་འདི་རྣམས་དབང་ཆ་གང་གིས་བྱེད་པ་མི་ཤོད།” ");
INSERT INTO bod_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ད་ཁྱེད་ཚོས་ཅི་ལྟར་སེམས། མི་ཞིག་ལ་བུ་གཉིས་ཡོད་དེ། ཁོས་བུ་ཆེ་བའི་རྩར་སོང་ནས་ཁོ་ལ་བུ། དེ་རིང་རྒུན་འབྲུམ་གྱི་ལྡུམ་རར་ཕྱིན་ནས་ལས་ཀ་བྱོས་ཤིག་ཅེས་ཟེར་བ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ཁོས་ང་མི་འགྲོ་ཞེས་ཟེར་བའི་རྗེས་སུ་སེམས་བསྒྱུར་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","མི་དེ་བུ་ཆུང་བའི་རྩར་ཕྱིན་ནས་སྔོན་ལྟར་སྨྲས་པ་དང༌། བུ་དེས་ཡབ་ལགས། ང་འགྲོ་ཞེས་ཟེར་ནས་མ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","བུ་དེ་གཉིས་ནས་སུས་ཕའི་འདོད་པ་བཞིན་དུ་བྱས་”ཞེས་གསུངས་པ་ལ། ཁོ་ཚོས་“ཆེ་བ་དེས་བྱས་”ཞེས་ཟེར་བས་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ངས་ཁྱོད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། ཁྲལ་སྡུད་མཁན་དང་སྨད་འཚོང་མ་རྣམས་ཁྱོད་རྣམས་ཀྱི་སྔོན་ལ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་ཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","གང་ཡིན་ཟེར་ན། ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་ཁྱོད་ཚོའི་དྲུང་དུ་དྲང་དང་ལྡན་པའི་ལམ་བསྟན་ཏེ་ཡོང་ནའང༌། ཁྱོད་ཚོས་ཁོང་ལ་ཡིད་མ་ཆེས། ཁྲལ་སྡུད་མཁན་དང་སྨད་འཚོང་མ་རྣམས་ཀྱིས་ཡིད་ཆེས། ཁྱོད་ཚོས་དེ་མཐོང་ནའང་ཁྱོད་ཚོའི་སེམས་མ་སྒྱུར་ཞིང༌། ཁོང་ལ་ཡིད་མ་ཆེས།” ");
INSERT INTO bod_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“དཔེ་གཞན་ཞིག་ཉོན་ཞིག ཁྱིམ་བདག་ཅིག་གིས་རྒུན་འབྲུམ་གྱི་ལྡུམ་ར་ཞིག་བཟོས་ཤིང༌། ཕྱོགས་བཞིར་ར་བས་བསྐོར། རྒུན་ཆང་འཚིར་བྱེད་ཀྱི་ཆང་གཞོང་ཞིག་བཟོས་པ་དང་ཐོག་ཁང་ཞིག་ཀྱང་བཟོས་རྗེས། ལྡུམ་རའི་ལས་མཁན་རྣམས་ལ་བོགས་མར་བཏང་ནས་ཡུལ་གཞན་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","འབྲས་བུའི་སྡུད་པའི་དུས་ལ་བབས་པའི་ཚེ། ཁོས་ལྡུམ་རའི་ལས་མཁན་རྣམས་ནས་ཁོང་གི་རྒུན་འབྲུམ་གྱི་སྐལ་བ་ལེན་པའི་ཕྱིར་ཁོའི་གཡོག་པོ་རྣམས་བཏང་བས། ");
INSERT INTO bod_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ལྡུམ་རའི་ལས་མཁན་རྣམས་ཀྱིས་གཡོག་པོ་བཟུང་སྟེ། གཅིག་བརྡུངས། གཅིག་བསད། གཅིག་ལ་རྡོ་རུབ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","དེ་ནས་ཁོས་སྔོན་ལས་མང་བའི་གཡོག་ཚོགས་བཏང་ཡང༌། ལྡུམ་རའི་ལས་མཁན་རྣམས་ཀྱིས་དེ་ཚོ་ལའང་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ཁོ་ཚོས་ངའི་བུ་ལ་བརྩི་བཀུར་བྱེད་ཡོང་ཞེས་ཟེར་ནས་མཐའ་མར་རང་གི་བུ་ཁོ་ཚོའི་རྩར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","འོན་ཀྱང་ལྡུམ་རའི་ལས་མཁན་རྣམས་ཀྱིས་བུ་དེ་མཐོང་ནས་གཅིག་གིས་གཅིག་ལ། མི་འདི་ནི་ཕ་ཤུལ་འཛིན་མཁན་ཡིན་པས། ཤོག་ལ། ཁོ་བསད་ནས་ནོར་སྐལ་འཕྲོག་པར་བྱ་ཞེས་སྨྲས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","བུ་དེ་བཟུང་ནས་ལྡུམ་རའི་ཕྱི་ལ་བསྐྲད་དེ་བསད། ");
INSERT INTO bod_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ད་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་བདག་པོ་ཡོང་ནས་ལྡུམ་རའི་ལས་མཁན་རྣམས་ལ་གང་འདྲ་བྱེད་ཡོང་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","བླ་ཆེན་དང་རྒན་པོ་ཚོས་ཁོང་ལ་“མི་ངན་པ་དེ་རྣམས་སྡུག་པོ་བཏང་ནས་མེད་པར་བྱེད་ཅིང༌། ལྡུམ་ར་འདི་འབྲས་བུའི་སྡུད་པའི་དུས་ལ་བབས་པའི་ཚེ་ཁོང་ལ་རྒུན་འབྲུམ་གྱི་སྐལ་བ་སྤྲོད་པའི་གླ་མཁན་གཞན་རྣམས་ལ་གཏོད་པར་བྱེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ཡེ་ཤུས་ཁོ་ཚོར། “བཟོ་བ་རྣམས་ཀྱིས་སྤངས་པའི་རྡོ། ། ཁང་པའི་རྨང་རྡོར་གྱུར་བ་འདི། ། གཙོ་བོ་ཉིད་ཀྱིས་མཛད་པ་ཡིན། ། ང་ཚོའི་མིག་ལ་ངོ་མཚར་ཆེ། ། ཞེས་ཁྱེད་ཚོས་མདོ་ལས་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","དེའི་ཕྱིར་ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱོད་རྣམས་ནས་འཕྲོག་སྟེ། དེའི་འབྲས་བུ་སྐྱེད་པའི་མི་རྒྱུད་ལ་གནང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","རྡོ་དེའི་སྟེང་དུ་འགྱེལ་བའི་མི་དེ་དུམ་བུར་ཆག་པར་འགྱུར། རྡོ་དེ་མི་སུ་ཞིག་གི་སྟེང་ལ་ལྷུངས་ན་དེས་ཁོ་མནན་པར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཕཱ་རུ་ཤི་པ་ཚོས་ཁོང་གི་དཔེ་རྣམས་ཐོས་ནས་ཁོང་གིས་ཁོ་ཚོའི་སྐོར་ལ་གསུངས་པར་ཤེས་པས། ");
INSERT INTO bod_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ཡེ་ཤུ་འཛིན་བཟུང་བྱེད་པར་བསམས་ཀྱང༌། ཁོང་ལུང་སྟོན་པར་བརྩིས་པའི་མི་ཚོགས་ལ་འཇིགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ཡེ་ཤུས་ཡང་བསྐྱར་དཔེ་བསྟན་པའི་སྒོ་ནས་ཁོ་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་རང་གི་བུ་ལ་བག་སྟོན་བྱས་པའི་རྒྱལ་པོ་ཞིག་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","བག་སྟོན་དེ་ལ་མགྲོན་ལ་བོས་པ་རྣམས་འདྲེན་པའི་ཕྱིར་གཡོག་པོ་རྣམས་བཏང་ན་ཡང༌། མགྲོན་པོ་རྣམས་ཡོང་བར་མི་འདོད། ");
INSERT INTO bod_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","རྒྱལ་པོས་གཡོག་པོ་གཞན་རྣམས་བཏང་སྟེ་ཁོ་ཚོར། མགྲོན་པོ་རྣམས་ལ། ཉོན་དང༌། ངའི་བག་སྟོན་གྲ་སྒྲིག་ཟིན་པ་ཡིན་ལ། ངའི་བ་གླང་དང་ཕྱུགས་རྒྱགས་པ་བཤས། ཐམས་ཅད་བཤམས་ཚར་བས། བག་སྟོན་ལ་ཤོག་ཅིག་ཅེས་ཟེར་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","འོན་ཀྱང་མགྲོན་པོ་རྣམས་ཀྱིས་དེ་ལ་དོ་སྣང་མ་བྱས་པར་ཕར་སོང་སྟེ། གཅིག་རང་གི་ཞིང་ཁར་སོང༌། གཞན་གཅིག་རང་གི་ཚོང་ཁང་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","གཞན་རྣམས་ཀྱིས་རྒྱལ་པོའི་གཡོག་པོ་རྣམས་བཟུང་ནས་སྡུག་པོ་བཏང་སྟེ་བསད། ");
INSERT INTO bod_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","རྒྱལ་པོ་ཤིན་ཏུ་ཁྲོས་ནས་དམག་དཔུང་བཏང་སྟེ་མི་སྲོག་གཅོད་མཁན་དེ་རྣམས་མེད་པར་བྱས་ནས་ཁོ་ཚོའི་གྲོང་ཁྱེར་མེས་བསྲེགས། ");
INSERT INTO bod_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","དེ་ནས་རང་གི་གཡོག་པོ་རྣམས་ལ། བག་སྟོན་གྲ་སྒྲིག་ཟིན་ཡོད་ཀྱང༌། མགྲོན་པོ་རྣམས་ལ་འོས་པ་མིན་པས། ");
INSERT INTO bod_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","གཞུང་ལམ་ལ་སོང་ནས་དེར་ཡོད་པ་ཐམས་ཅད་བག་སྟོན་ལ་བོས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","གཡོག་པོ་རྣམས་ལམ་ལ་སོང་ནས། མི་བཟང་ངན་སུ་ཐུག་ཀྱང་ཐམས་ཅད་ཁྲིད་ཡོང་བས་བག་སྟོན་ཁང་མགྲོན་པོས་ཁེངས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","རྒྱལ་པོ་དེ་མགྲོན་པོ་རྣམས་ལ་ལྟ་བར་ནང་དུ་ཡོང་བའི་ཚེ། བག་སྟོན་གྱི་གོས་མ་གྱོན་པ་ཞིག་མཐོང་བས། ");
INSERT INTO bod_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ཁོ་ལ། གྲོགས་པོ། བག་སྟོན་གྱི་གོས་མེད་པར་ཁྱོད་ཅི་ལྟར་འདིར་ཡོང་ཞེས་བཤད་པས། མགྲོན་པོ་དེས་ཇི་ལྟར་ཞུ་དགོས་མིན་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","དེ་ནས་རྒྱལ་པོས་གཡོག་པོ་རྣམས་ལ། ཁོ་རྐང་ལག་བསྡམས་ནས། ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་འབྱུང་ས་ཕྱི་རོལ་གྱི་མུན་པའི་ནང་དུ་དབྱུགས་ཤིག་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","བོས་པ་མང་ཡང་འདམ་པ་ཉུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","དེ་ནས་ཡེ་ཤུ་ལ་ཁྲིམས་དང་འགལ་བའི་གཏམ་ཤོད་གནང་དུ་འཇུག་པའི་ཕྱིར་ཕཱ་རུ་ཤི་པ་རྣམས་སོང་ནས་ངན་ཇུས་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ཁོ་ཚོའི་ཉེ་གནས་དང༌། ཧེ་རོ་དཱེའི་ཕྱོགས་ཁག་གི་མི་འགའ་ཞིག་ཁོང་གི་མདུན་དུ་བཏང་ནས་ཁོང་ལ་“སློབ་དཔོན་ལགས། ཁྱེད་ནི་རང་གཤིས་དྲང་པོ་ཡིན་ཞིང༌། དཀོན་མཆོག་གི་ལམ་ཡང་དག་པར་བདེན་པར་སྟོན་དེ། མི་གཞན་གྱི་བསམ་པའི་དབང་དུ་མི་འགྲོ་བ་དང་ཕྱོགས་རིས་མེད་པ་ཞིག་ཡིན་པ་ངེད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ཁྱེད་ཀྱིས་ཅི་ལྟར་དགོངས་པ་ང་ཚོར་གསུངས་རོགས། དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་ང་ཚོས་རྒྱལ་པོར་ཁྲལ་འཇལ་རུང་ངམ་མི་རུང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ཡེ་ཤུས་ཁོ་ཚོའི་ངན་སེམས་མཁྱེན་ཏེ་ཁོ་ཚོར་“ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ། ང་ལ་ཉམས་ཚོད་ལེན་པའི་རྒྱུ་མཚན་ཅི། ");
INSERT INTO bod_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ཁྲལ་གྱི་དངུལ་སྒོར་ཞིག་ང་ལ་སྟོན་དང་”ཞེས་གསུངས་པས་ཁོ་ཚོས་དངུལ་སྒོར་གཅིག་ཁྱེར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ཁོང་གིས་མི་དེ་ཚོར་“རི་མོ་དང་ཡི་གེ་འདི་སུའི་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ཁོ་ཚོས་ཁོང་ལ་“རྒྱལ་པོའི་ཡིན་ནོ་”ཞེས་སྨྲས་པས་ཁོང་གིས་ཁོ་རྣམས་ལ་“འོ་ན། གང་ཞིག་རྒྱལ་པོའི་ཡིན་པ་དེ་རྒྱལ་པོར་ཕུལ་ཞིག གང་ཞིག་དཀོན་མཆོག་གི་ཡིན་པ་དེ་དཀོན་མཆོག་ལ་ཕུལ་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","དེ་ཐོས་ནས་དེ་རྣམས་ངོ་མཚར་ཆེ་བར་གྱུར་དེ། ཁོང་དང་ཁ་བྲལ་ནས་ཕར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ཉིན་དེ་རང་ལ་གཤིན་པོ་རྣམས་ལ་སླར་གསོན་པ་མེད་ཅེས་ཟེར་མཁན་སཱ་ཅུ་སེ་པ་ནང་ནས་འགའ་ཤས་ཡེ་ཤུའི་མདུན་དུ་ཡོང་སྟེ་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“སློབ་དཔོན་ལགས། ལུང་སྟོན་པ་མོ་ཤེ་ཡིས། གལ་སྲིད་སྐྱེས་པ་ཞིག་བུ་ཕྲུག་མེད་པར་ཤི་ན། ཁོའི་སྤུན་གྱིས་སྐྱེས་པ་དེའི་ཡུགས་མོ་བཟའ་ཟླ་བླངས་ནས་རང་གི་སྤུན་གྱི་དོན་ལ་རིགས་རྒྱུད་སྤེལ་དགོས་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ང་ཚོའི་དཀྱིལ་ལ་སྤུན་བདུན་ཡོད་དེ། དང་པོ་དེ་བཟའ་ཟླར་བླངས་ནས་བུ་ཕྲུག་མེད་པར་ཤི ཁོའི་སྤུན་གྱིས་སྐྱེས་པ་དེའི་ཡུགས་མོ་བཟའ་ཟླར་བླངས། ");
INSERT INTO bod_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","སྤུན་གཉིས་པ་དང༌། གསུམ་པ་ལ་སོགས་པ་བདུན་པའི་བར་དུ་དེ་ལྟར་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","མཐར་བུད་མེད་དེའང་ཤི ");
INSERT INTO bod_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","འོ་ན་ཁོ་ཚོ་ཚང་མས་ཁོ་མོ་བཟའ་ཟླར་བླངས་པས། གཤིན་པོ་རྣམས་འཆི་བ་ནས་སླར་གསོན་པའི་དུས་སུ་ཁོ་མོ་ནི་སུའི་བཟའ་ཟླར་འགྱུར་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ལན་དུ་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོས་གསུང་རབ་ཀྱང་མི་རྟོགས། དཀོན་མཆོག་གི་ནུས་མཐུ་ཡང་མི་རྟོགས་པས་ནོར། ");
INSERT INTO bod_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","གཤིན་པོ་རྣམས་སླར་གསོན་པའི་དུས་སུ་དེ་ཚོས་བག་མ་ཡང་མི་ལེན། བག་མར་ཡང་མི་གཏོང༌། དེ་ཚོ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ཀྱི་ཕོ་ཉ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","འོན་ཀྱང་གཤིན་པོ་གསོན་པོར་ལང་དུ་གྱུར་ངེས་པའི་སྐོར་ལ། དཀོན་མཆོག་གིས་ཁྱེད་ཚོར་གསུངས་པ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ང་ནི་ཁྱེད་ཀྱི་མེས་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང༌། ཨི་སཱག་གི་དཀོན་མཆོག ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ཡིན་ཞེས་མ་བཀླགས་སམ། ཁོང་ནི་གཤིན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་མ་ཡིན་ཏེ། གསོན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","མི་ཚོགས་ཀྱིས་དེ་ཐོས་ནས་ཁོང་གི་ཆོས་གསུངས་པ་ལ་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ཡེ་ཤུས་སཱ་ཅུ་སེ་པ་རྣམས་ལ་སྨྲ་རྒྱུ་མེད་པར་མཛད་པ་ཐོས་ནས་ཕཱ་རུ་ཤི་པ་རྣམས་འདུས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ཁོ་ཚོའི་ནང་ནས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཞིག་གིས་ཁོང་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“སློབ་དཔོན་ལགས། ཆོས་ཁྲིམས་ཀྱི་བཀའི་ནང་ནས་གལ་ཆེ་ཤོས་གང་ཡིན་”ཞེས་བཀའ་འདྲི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ཁོང་གིས་མི་དེར་“རང་གིས་གཙོ་བོ་དཀོན་མཆོག་ལ་བློ་གཅིག་སེམས་གཅིག་དང་ཡིད་གཅིག་གིས་བརྩེ་བར་ཟུངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","འདི་ནི་བཀའ་རྒྱ་གལ་ཆེ་ཤོས་དང་དང་པོ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","གཉིས་པ་དེ་དང་འདྲ་བ་ཡིན། དེ་ནི་ཁྱིམ་མཚེས་ལ་རང་དང་འདྲ་བར་བརྩེ་བར་ཟུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","བཀའ་དེ་གཉིས་ལ་ཆོས་ཁྲིམས་ཆ་ཚང་དང༌། ལུང་སྟོན་པའི་བསྟན་པ་རྟེན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ཕཱ་རུ་ཤི་པ་རྣམས་འདུས་པའི་ཚེ་ཡེ་ཤུས་ཁོ་རྣམས་ལ་བཀའ་དྲི་གནང་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ཁྱེད་ཚོས་སྐྱབས་མགོན་མཱ་ཤི་ཀའི་སྐོར་ཅི་ལྟར་སེམས། ཁོང་ནི་སུའི་སྲས་ཡིན་”ཞེས་གསུངས་པས་ཁོ་ཚོས་ཁོང་ལ་“རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ཁོང་གིས་ཁོ་ཚོར་“འོ་ན་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་བསྐུལ་ཏེ་དཱ་བིད་ཀྱིས་ཁོང་ལ་གཙོ་བོ་ཞེས་ཟེར་བ་དེ་ཅི་ཡིན། ཁོང་གིས། ");
INSERT INTO bod_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","དཀོན་མཆོག་གིས་ནི་ང་ཡི་གཙོ་བོ་ལ། ། ཁྱེད་ཀྱི་དགྲ་རྣམས་ཁྱེད་ཀྱི་ཞབས་འོག་ཏུ། ། ང་ཡིས་མ་བཅུག་བར་དུ་ཁྱེད་རང་ཉིད། ། ང་ཡི་གཡས་སུ་དེ་བར་བཞུགས་སུ་གསོལ། ། ");
INSERT INTO bod_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","རྒྱལ་པོ་དཱ་བིད་ཀྱིས་མཱ་ཤི་ཀ་ལ་གཙོ་བོ་ཞེས་ཟེར་ན། མཱ་ཤི་ཀ་ཁོང་གི་སྲས་ཅི་ལྟར་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","མི་སུས་ཀྱང་ཁོང་ལ་ལན་ཞུ་མ་ཐུབ་པས། དེའི་རྗེས་སུ་སུས་ཀྱང་ཁོང་ལ་དྲི་བ་ཅི་ཡང་ཞུ་མ་ཕོད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","དེ་ནས་ཡེ་ཤུས་མི་ཚོགས་དང་རང་གི་ཉེ་གནས་རྣམས་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ལུང་སྟོན་པ་མོ་ཤེའི་བཞུགས་ཁྲི་ལ་སྡོད་པས། ");
INSERT INTO bod_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ཁོ་ཚོས་ཁྱེད་རྣམས་ལ་སློབ་པ་གང་ཐམས་ཅད་སྲུང་ཞིག འོན་ཀྱང་ཁོ་ཚོའི་སྤྱོད་པ་བཞིན་དུ་མ་བྱེད་ཅིག གང་ཡིན་ཞེ་ན། ཁོ་ཚོས་སྨྲ་བ་ལྟར་མི་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","དེ་ཚོས་འཁུར་དཀའ་བའི་རྡོག་ཁྲེས་ལྗིད་པོ་བསྡམས་ནས་མི་གཞན་གྱི་རྒྱབ་ལ་འགེལ་ཡང༌། རང་གི་མཛུབ་མོ་གཅིག་ཙམ་གྱིས་ཀྱང་དེ་ལ་རེག་པར་མི་འདོད། ");
INSERT INTO bod_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ཁོ་ཚོས་རང་གི་ལས་བྱས་པ་ཐམས་ཅད་མི་གཞན་གྱིས་མཐོང་བའི་ཆེད་དུ་ཡིན་ཏེ། རང་གི་སྲུང་བ་ཞེང་ཆེ་བ་དང༌། གོས་ཀྱི་མཐའ་འཛར་རིང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","མི་དེ་ཚོས་གསོལ་སྟོན་ལ་གྲལ་མགོའི་གལ་ཆེ་ས་དང༌། འདུ་ཁང་ནང་ཁྲི་མཐོ་སར་སྡོད་པ། ");
INSERT INTO bod_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ཁྲོམ་ལ་མི་རྣམས་ཀྱིས་ཁོ་ཚོར་ཕྱག་བྱེད་པ་དང༌། མི་རྣམས་ཀྱིས་ཁོ་ལ་རབ་བི་ཞེས་ཟེར་བར་དགའ། ");
INSERT INTO bod_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","འོན་ཀྱང་ཁྱེད་ཚོ་ཚང་མ་ཕན་ཚུན་སྤུན་ཟླ་ཡིན་ཞིང་སློབ་དཔོན་གཅིག་རང་ལས་མེད་པས་ཁྱེད་ཚོར་རབ་བི་ཟེར་བར་མ་འཇུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ཡང་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཞུགས་པ་ཁོང་གཅིག་པོ་ནི་ཁྱེད་ཀྱི་ཡབ་ཡིན་པས་འཇིག་རྟེན་སྟེང་གི་མི་སུ་ལ་ཡང་ཡབ་མ་ཟེར་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","སྐྱབས་མགོན་མཱ་ཤི་ཀ་གཅིག་པོ་ནི་ཁྱེད་ཚོའི་སློབ་དཔོན་ཡིན་པས་ཁྱེད་ཚོར་སློབ་དཔོན་ཟེར་བར་མ་འཇུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ཁྱེད་ཚོའི་ནང་ནས་སུ་ཆེ་ཤོས་ཡིན་པ་དེ་ཁྱེད་ཚོའི་གཡོག་པོར་འགྱུར་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","རང་གིས་རང་ལ་བཀུར་སྟི་བྱེད་མཁན་དམའ་བར་འགྱུར་ཞིང༌། རང་གིས་རང་དམའ་ས་ཟིན་མཁན་ལ་བཀུར་སྟི་འཐོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། ཁྱོད་ཚོས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་སྒོ་བརྒྱབ་ནས། ཁྱོད་ཚོ་རང་ནང་དུ་མ་ཞུགས་པ་དང༌། ནང་ལ་འགྲོ་བཞིན་པ་རྣམས་ཀྱང་བཀག ");
INSERT INTO bod_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། མི་གཅིག་ཡ་ཧུ་དཱ་པའི་ཆོས་སུ་འཇུག་པའི་ཕྱིར་ཁྱོད་ཚོས་སྐམ་ས་དང་རྒྱ་མཚོ་གཉིས་སྐོར་ཞིང༌། མི་དེ་ཡ་ཧུ་དཱ་པར་གྱུར་ནས་ཁྱོད་ཚོ་ལས་ལྡབ་གཉིས་ཀྱིས་ལྷག་པའི་དམྱལ་ཁམས་ཀྱི་བུར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ལམ་སྟོན་པ་ལོང་བ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཁྱོད་ཚོས། གལ་ཏེ་མི་ཞིག་གིས་མཆོད་ཁང་ཆེན་མོ་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན་ཅིའང་མེད། འོན་ཀྱང་མཆོད་ཁང་ཆེན་མོའི་གསེར་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན་དེ་ཡིན་གཅིག་སྲུང་དགོས་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","བླུན་པོ་ལོང་བ་ཁྱོད་རྣམས། གསེར་གལ་ཆེ་བ་ཡིན་ནམ། ཡང་ན་གསེར་དེ་རྩ་ཆེན་དུ་སྒྱུར་བའི་མཆོད་ཁང་ཆེན་མོ་གལ་ཆེ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ཡང་ཁྱོད་ཚོས། གལ་ཏེ་མི་ཞིག་གིས་མཆོད་ཁྲི་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན་ཅིའང་མེད། འོན་ཀྱང་མཆོད་ཁྲིའི་སྟེང་གི་མཆོད་པ་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན་དེ་ཡིན་གཅིག་སྲུང་དགོས་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ལོང་བ་ཁྱོད་ཚོ། མཆོད་པ་ཆེ་བ་ཡིན་ནམ། ཡང་ན་མཆོད་པ་རྩ་ཆེན་དུ་སྒྱུར་བའི་མཆོད་ཁྲི་གལ་ཆེ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","དེ་བས་ན། མི་སུ་ཞིག་གིས་མཆོད་ཁྲི་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན། མཆོད་ཁྲི་དང་དེའི་སྟེང་གི་ཐམས་ཅད་དཔང་དུ་བཙུགས་ཏེ་མནའ་སྐྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ཡང་སུ་ཞིག་གིས་མཆོད་ཁང་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན། མཆོད་ཁང་དང་དེའི་ནང་ལ་བཞུགས་མཁན་ཁོང་དཔང་དུ་བཙུགས་ཏེ་མནའ་སྐྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ཡང་སུ་ཞིག་གིས་དཀོན་མཆོག་གི་ཞིང་ཁམས་དཔང་དུ་བཙུགས་ཏེ་མནའ་བསྐྱལ་ན། དཀོན་མཆོག་གི་བཞུགས་ཁྲི་དང་དེའི་སྟེང་ལ་བཞུགས་མཁན་ཡང་དཔང་དུ་བཙུགས་ཏེ་མནའ་སྐྱེལ། ");
INSERT INTO bod_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། ལྡུམ་རའི་རྩྭ་དྲི་ཞིམ་དང་གོ་སྙོད་ལ་སོགས་སྔོ་ཚོད་ཆུང་ཆུང་སྣ་ཚོགས་ཀྱི་བཅུ་ཆ་གཅིག་དཀོན་མཆོག་ལ་ཕུལ་ན་ཡང༌། ཁྱོད་ཚོས་ཁྲིམས་གཅོད་བདེན་པར་བྱེད་པ་དང༌། སྙིང་རྗེ་དང༌། དད་པ་ལ་སོགས་པའི་ཆོས་ཁྲིམས་ཀྱི་གལ་ཆེ་བའི་དོན་རྣམས་སྣང་མེད་དུ་བརྩིས། འདི་ཚོ་སྲུང་སྟེ་གཞན་རྣམས་དོར་བར་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ལམ་སྟོན་པ་ལོང་བ་ཁྱོད་ཚོ། ཁྱོད་ཚོས་འབུ་ཆུང་ཆུང་བཙགས་ནས་རྔ་མོང་མིད། ");
INSERT INTO bod_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། ཁྱོད་ཚོས་ཕོར་པ་དང་སྡེར་མའི་ཕྱི་ཕྱོགས་གཙང་བར་བྱེད་ནའང༌། ནང་ཕྱོགས་སུ་དེ་ཚོ་སེར་སྣ་དང་རང་འདོད་ཚ་བའི་བཙོག་པ་ཡིས་ཁེངས། ");
INSERT INTO bod_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ཕཱ་རུ་ཤི་པ་ལོང་བ་ཁྱོད། སྔོན་ལ་ཕོར་པ་དང་སྡེར་མའི་ནང་ཕྱོགས་གཙང་བར་བྱོས་ཤིག དེ་ནས་ཕྱི་ཕྱོགས་ཀྱང་གཙང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། ཁྱོད་ཚོ་ནི་དཀར་པོར་བཟོས་པའི་དུར་ཁང་དང་འདྲ་བ་ཡིན་ཏེ་ཕྱི་ཕྱོགས་ལ་བལྟས་ན་མཛེས་ཀྱང༌། ནང་ཕྱོགས་སུ་གཤིན་པོའི་རུས་དང༌། མི་གཙང་བ་རིགས་ཀུན་གྱིས་ཁེངས། ");
INSERT INTO bod_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","དེ་ལྟར་ཁྱོད་ཚོའང་ཕྱི་ཕྱོགས་སུ་མི་རྣམས་ཀྱིས་བལྟས་ན་ཆོས་དྲང་པོ་ཡིན་པར་མཐོང་ཡང༌། ནང་ཕྱོགས་སུ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་དང་ཁྲིམས་མེད་པ་ཡིས་ཁེངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། ཕཱ་རུ་ཤི་པ་སྟེ་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང༌། ཅིའི་ཕྱིར་ཞེ་ན། ཁྱོད་ཚོས་ལུང་སྟོན་པའི་དུར་ཁང་རྩིག་པ་དང༌། དྲང་ལྡན་པ་རྣམས་ཀྱི་དུར་ཁང་ལ་བརྒྱན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ང་ཚོ་མེས་པོའི་དུས་སུ་ཡོད་པ་ཡིན་ན། ཁོ་ཚོ་དང་མཉམ་དུ་ལུང་སྟོན་པ་རྣམས་མི་གསོད་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","དེ་ལྟར་སྨྲས་ནས་ཁྱོད་ཚོས་སོ་སོ་ལུང་སྟོན་པ་གསོད་མཁན་གྱི་རྒྱུད་པ་ཡིན་པར་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","བྱས་ན། ཁྱོད་ཚོའི་ཕ་མེས་ཀྱིས་འགོ་བཙུགས་པ་དེ་ཁྱོད་ཚོས་ཚར་བར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ཁྱོད་ཚོ་སྦྲུལ་གྱི་རིགས། དུག་སྦྲུལ་གྱི་རྒྱུད་རྣམས། དམྱལ་ཁམས་ཀྱི་ཆད་པ་ལས་ཅི་ལྟར་ཐར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","དེའི་ཕྱིར་ཉོན་ཞིག ངས་ལུང་སྟོན་པ་དང༌། ཤེས་རབ་ཅན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁྱོད་ཚོའི་རྩར་གཏོང༌། དེ་ཚོའི་ནང་ནས་ཁྱོད་ཚོས་ཁ་ཤས་གསོད། ཁ་ཤས་རྒྱང་ཤིང་ལ་རྒྱོང༌། ཁ་ཤས་འདུ་ཁང་ནང་ལ་རྟ་ལྕག་གིས་རྡུང༌། ཁ་ཤས་ལ་གྲོང་ཁྱེར་གཅིག་ནས་གཞན་ལ་རྗེས་སུ་སྙེག་སྟེ་གནོད་འཚེ་བྱེད་པས། ");
INSERT INTO bod_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","དྲང་ལྡན་གྱི་མེས་པོ་ཧ་བེལ་ནས་མཆོད་ཁང་དང་མཆོད་ཁྲི་གཉིས་བར་དུ་ཁྱོད་ཚོས་བསད་པའི་པེ་རེ་ཀི་ཡཱ་ཡི་བུ་ཟེ་ཀ་རི་ཡཱ་བར་གྱི་ས་ལ་གཟགས་པའི་ཁྲག་དེ་ཐམས་ཅད་ལ་ཁྱོད་ཚོས་འགན་ལེན་བྱེད་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ངས་ཁྱོད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། དེ་ཐམས་ཅད་ཀྱི་ཆད་པ་མི་རབས་འདི་ཡི་མགོ་སྟེང་དུ་འབབ་ངེས་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ཀྱེ་ཡེ་རུ་ཤ་ལེམ། ཡེ་རུ་ཤ་ལེམ། ཁྱོད་ཀྱིས་ལུང་སྟོན་པ་རྣམས་གསོད་ཅིང་ཁྱོད་རྩར་མངག་པ་རྣམས་རྡོ་རུབ་གཏོང༌། བྱ་མོས་རང་གི་བྱ་ཕྲུག་གཤོག་པའི་འོག་ཏུ་སྡུད་པ་ལྟར་ངས་ཐེངས་མང་པོར་ཁྱོད་ཀྱི་ཕྲུ་གུ་སྡུད་པར་འདོད་ཀྱང༌། ཁྱོད་རྣམས་མ་མོས། ");
INSERT INTO bod_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ལྟོས་ཤིག ཁྱོད་ཀྱི་གནས་ཁང་ཁྱོད་ཕྱིར་སྟོང་བར་ལུས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ངས་ཁྱོད་རྣམས་ལ་ཟེར་རྒྱུར། ད་ནས་བཟུང་ཁྱོད་ཚོས་གཙོ་བོའི་མཚན་ཐོག་ནས་ཕེབས་མཁན་ལ་བྱིན་རླབས་གནང་བར་ཤོག་ཅེས་ཟེར་བའི་བར་དུ་ཁྱོད་ཀྱིས་ང་མཐོང་བར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ཡེ་ཤུ་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་ར་ནས་ཕྱིར་ཕེབས་སྐབས། དེའི་ཁང་པ་རྣམས་ཁོང་ལ་སྟོན་པའི་ཕྱིར་ཉེ་གནས་རྣམས་ཡོང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ཁོང་གིས་ཁོ་རྣམས་ལ་“ཁང་པ་ཆེན་པོ་འདི་རྣམས་མཐོང་བ་ཡིན་ནམ། ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མ་འོངས་པའི་དུས་སུ་འདི་རུ་རྡོ་ཕ་བོང་གཅིག་སྟེང་གཅིག་ཀྱང་མི་ལུས་པར་ཐམས་ཅད་གཞིག་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ཡེ་ཤུ་སྐྱུར་རུ་ཤིང་གི་རི་སྟེང་དུ་བཞུགས་པའི་ཚེ། ཉེ་གནས་རྣམས་ཟུར་དུ་ཁོང་གི་མདུན་ལ་ཡོང་ནས་ཁོང་ལ་“དོན་འདི་རྣམས་དུས་ནམ་ཞིག་ལ་འབྱུང་ཞིང༌། ཁྱེད་ཀྱིས་འབྱོན་པ་དང་དུས་ཀྱི་མཐའ་མའི་རྟགས་གང་ཡིན་པ་ང་ཚོར་གསུང་རོགས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ལན་དུ་ཡེ་ཤུས་དེ་རྣམས་ལ་“མི་སུས་ཀྱང་ཁྱེད་ཚོ་མི་སླུ་བའི་ཕྱིར་དོགས་ཟོན་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","མི་མང་པོས་ངའི་མིང་ཐོག་ནས་ཡོང་སྟེ་ང་རང་མཱ་ཤི་ཀ་ཡིན་ཞེས་ཟེར་ནས་མི་མང་པོར་མགོ་སྐོར་གཏོང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ཁྱེད་ཚོས་དམག་འཁྲུག་དང་དམག་འཁྲུག་སྐོར་གྱི་གཏམ་ཐོས་པའི་སྐབས་སུ་མ་འཇིགས་ཤིག དོན་འདི་ཚོ་འབྱུང་ངེས་ཀྱང་དེ་ནི་དུས་རབས་ཀྱི་མཐའ་མ་ད་དུང་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","རྒྱུ་མཚན་ནི་མི་རིགས་དང་མི་རིགས་འཁྲུག་ཅིང་རྒྱལ་ཁམས་དང་རྒྱལ་ཁམས་འཁྲུག་པ། ས་ཆ་ཁ་ཤས་ལ་མུ་གེ་དང་ས་ཡོམ་ཡང་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","འདི་ཚོ་ཐམས་ཅད་ནི་སྐྱེ་ཟུག་ཐོག་མ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","དེ་ནས་ཁོ་ཚོས་ཁྱེད་རྣམས་ལ་གནོད་འཚེ་བྱེད་པར་གཏད་ནས་གསོད་པར་འགྱུར། ངའི་མིང་གི་རྐྱེན་གྱིས་མི་རིགས་ཚང་མས་ཁྱེད་རྣམས་ལ་སྡང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","དེའི་ཚེ་མི་མང་པོ་དད་པ་ལོག་པར་གྱུར་ནས་གཅིག་གིས་གཅིག་ལ་རྒྱབ་གཏོད་བྱེད་ཅིང་སྡང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ལུང་སྟོན་པ་རྫུན་མ་མང་པོ་ཞིག་འབྱུང་ཞིང་མི་མང་པོར་བསླུ་བྲིད་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","བཀའ་ཁྲིམས་དང་འགལ་བ་འཕེལ་བས་མི་མང་ཆེ་བའི་བརྩེ་སེམས་ཉམས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","འོན་ཀྱང་ཚེའི་མཐའ་མཇུག་བར་དུ་བཟོད་པ་སྒོམ་པའི་མི་དེ་ལ་ཐར་པ་འཐོབ་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ཡང་མི་རིགས་ཐམས་ཅད་ལ་དཔང་པོ་བྱེད་པའི་ཕྱིར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་འདི་འཇིག་རྟེན་ཧྲིལ་པོར་སྒྲོག་པར་འགྱུར་ཞིང༌། དེ་ནས་དུས་ཀྱི་མཐའ་མ་འབྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ལུང་སྟོན་པ་དཱ་ནི་ཨེལ་གྱིས་གསུངས་པའི་སྟོང་བར་བྱེད་མཁན་གདུག་པ་ཅན་གནས་མཆོག་ལ་ལངས་བསྡད་པར་མཐོང་བའི་ཚེ། (འདི་ཀློག་མཁན་གྱིས་ཧ་གོ་བར་གྱིས་ཤིག) ");
INSERT INTO bod_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ཡ་ཧུ་དཱ་ཡུལ་དུ་ཡོད་པའི་མི་རྣམས་རི་ལ་བྲོས་དགོས་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ཁང་པའི་ཐོག་ལ་ཡོད་པ་མར་འབབ་ནས་རང་གི་ཁང་པའི་ནང་ནས་ཅ་ལག་མ་ལེན་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ཞིང་ཁར་ཡོད་པའི་མི་རང་གི་ཕྱི་གོས་ལེན་དུའང་ངེས་པར་དུ་ཕྱིར་མི་ལོག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ཉིན་དེ་ཚོའི་རིང་ལ་བུད་མེད་ཕྲུ་གུ་འཁོར་བ་དང་བུ་ཕྲུག་ལ་འོ་མ་སྟེར་མཁན་རྣམས་ལ་སྙིང་རེ་རྗེ། ");
INSERT INTO bod_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ཁྱེད་ཚོ་འབྲོས་པ་དེ་དགུན་ཁར་དང༌། ཡང་ན་ངལ་གསོ་བའི་ཉིན་མོར་མི་འབྱུང་བའི་ཕྱིར་ཁྱེད་ཚོས་སྨོན་ལམ་ཐོབས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","དེའི་དུས་སུ་སྡུག་བསྔལ་ཤིན་ཏུ་ཆེན་པོ་འབྱུང་ཡོང༌། དེ་ལྟ་བུའི་སྡུག་བསྔལ་ཆེན་པོ་དེ་ཐོག་མར་འཇིག་རྟེན་བཀོད་པ་ནས་ད་ལྟའི་བར་དུ་བྱུང་མ་མྱོང་ལ་རྗེས་སུའང་རྩ་བ་ནས་འབྱུང་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ཡང་སྡུག་བསྔལ་གྱི་ཉིན་དེ་རྣམས་ཉུང་བར་མ་མཛད་ན། མི་སུ་ཡང་ཐར་མི་ཐུབ། འོན་ཀྱང་ཁོང་གིས་བདམས་པའི་མི་རྣམས་ཀྱི་དོན་དུ་ཉིན་དེ་རྣམས་ཇེ་ཉུང་དུ་མཛད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","དེའི་དུས་སུ་མི་སུ་ཞིག་གིས་ཁྱེད་རྣམས་ལ་ལྟོས་ཤིག སྐྱབས་མགོན་མཱ་ཤི་ཀ་འདི་རུ་ཡོད། ཡང་ན་ལྟོས་ཤིག མཱ་ཤི་ཀ་དེ་རུ་ཡོད་ཟེར་ན། དེར་ཡིད་མ་ཆེས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","གང་ལགས་ཟེར་ན། མཱ་ཤི་ཀ་རྫུན་མ་དང་ལུང་སྟོན་པ་རྫུན་མ་མང་པོ་འབྱུང་སྟེ། ངོ་མཚར་ཆེ་བའི་ལས་དང་རྟགས་མཚན་བསྟན་ནས་མགོ་སྐོར་བཏང་སྲིད་ན། བདམས་པའི་མི་རྣམས་ཀྱང་མགོ་འཁོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ཉོན་ཞིག ངས་ཁྱེད་ཚོར་སྔོན་ལ་བཤད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","དེའི་ཕྱིར་ཁོ་ཚོས་ཁྱེད་རྣམས་ལ། ལྟོས་ཤིག ཁོང་དབེན་གནས་སུ་འདུག་ཅེས་ཟེར་ན་མ་འཐོན་ཞིག ཡང་ན། ལྟོས་ཤིག ཁོང་ཁང་པའི་ཕུག་ནང་འདུག་ཅེས་ཟེར་ན་ཡིད་མ་ཆེས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","རྒྱུ་མཚན་ནི་གློག་ཤར་ཕྱོགས་ནས་ནུབ་ཕྱོགས་སུ་འཁྱུག་པ་ལྟར། མིའི་རིགས་ཀྱི་བུའི་འབྱོན་པ་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ཕུང་པོ་ཡོད་སར་བྱ་རྒོད་འཛོམ་པར་འགྱུར་རོ། །” ");
INSERT INTO bod_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“དུས་དེར་སྡུག་བསྔལ་ཆེན་པོ་དེའི་རྗེས་སུ། ཉི་མ་སྒྲིབ་ཅིང་ཟླ་བའི་འོད་མི་སྤྲོ། ། རྒྱུ་སྐར་ཚོགས་རྣམས་ས་སྟེང་དུ་ལྷུང་ཞིང༌། ། བར་སྣང་ཁམས་ཀྱི་དབང་ལྡན་གཡོ་བར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","དེ་ནས་མིའི་རིགས་ཀྱི་བུའི་རྟགས་ནམ་མཁར་འབྱུང་ཞིང༌། དེའི་ཚེ་འཇིག་རྟེན་གྱི་མི་སྡེ་ཚང་མས་མྱ་ངན་བྱེད། ཁོ་ཚོས་མིའི་རིགས་ཀྱི་བུ་ནི་དབང་ཆེན་པོ་དང་གཟི་བརྗིད་ངང་ནས་ནམ་མཁའི་སྤྲིན་གྱི་ནང་ནས་འབྱོན་པར་མཐོང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ཡང་དམག་དུང་གི་སྒྲ་ཆེན་པོ་དང་བཅས་པར་ཁོང་གིས་རང་གི་ཕོ་ཉ་རྣམས་མངགས་ཏེ། དེ་ཚོས་ས་གཞི་ཆེན་པོའི་མཐའ་ནས་ནམ་མཁའི་མཐའ་བར་བདམས་པའི་མི་ཐམས་ཅད་ཕྱོགས་བཞི་མཚམས་བརྒྱད་ནས་སྡུད་ཡོང༌།” ");
INSERT INTO bod_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ཁྱེད་ཚོས་བསེ་ཡབ་ཤིང་ནས་དཔེ་ཞིག་ལོངས་དང༌། དེའི་ཡལ་གར་ལོ་མ་འབུས་ནས་མཉེན་པའི་དུས་སུ། དབྱར་ཁའི་དུས་ཉེ་བར་ཡོད་པ་ཁྱེད་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","དེ་བཞིན་དུ་ཁྱེད་ཚོས་རྟགས་མཚན་དེ་ཐམས་ཅད་འབྱུང་བ་མཐོང་ཚེ། མིའི་རིགས་ཀྱི་བུ་ཁོང་ཡང་སྒོ་འགྲམ་དུ་ཉེ་བར་སླེབས་ཡོད་པའང་རྟོགས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་རབས་འདི་འདའ་བར་འགྱུར་བའི་སྔོན་ལ་དོན་འདི་ཐམས་ཅད་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","གནམ་ས་གཉིས་ནི་འདའ་བར་འགྱུར་ཡང་ངའི་བཀའ་འདའ་བར་མི་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ཉིན་མོ་དེ་དང་དུས་ཚོད་དེའི་སྐོར་ཡབ་དཀོན་མཆོག་གིས་མ་གཏོགས། སུས་ཀྱང་མི་ཤེས། དཀོན་མཆོག་གི་བཞུགས་གནས་ཀྱི་ཕོ་ཉ་རྣམས་ཀྱིས་ཀྱང་མི་ཤེས་ལ་སྲས་ཀྱིས་ཀྱང་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","མིའི་རིགས་ཀྱི་བུའི་འབྱོན་པ་ནི་ནོ་ཨའི་དུས་ལྟར་ཡིན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","གང་ལགས་ཤེ་ན། དུས་དེར་ཆུ་ལོག་མ་འབྱུང་བའི་སྔོན་ལ། ནོ་ཨ་ཁོང་གྲུ་ཆེན་གྱི་ནང་དུ་མ་ཞུགས་པའི་བར་དུ་དེ་ཚོས་བཟའ་འཐུང་བྱེད་ཅིང༌། བག་མ་གཏོང་ལེན་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ཆུ་ལོག་གིས་དེ་ཚོ་ཐམས་ཅད་ཕར་འཁྱེར་བའི་བར་དེ་ཚོས་མ་རྟོགས། མིའི་རིགས་ཀྱི་བུའི་འབྱོན་པ་དེ་ཡང་དེ་ལྟར་ཡིན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","དེའི་དུས་སུ་ཞིང་ཁར་མི་གཉིས་ཡོད་པ་ལས་གཅིག་ལེན་ཅིང་གཅིག་འབོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","བུད་མེད་འབྲུ་འཐག་མཁན་གཉིས་ཡོད་པ་ལས། གཅིག་ལེན་ཅིང་གཅིག་འབོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","དེ་བས་ན་ཁྱེད་ཀྱི་གཙོ་བོ་འབྱོན་པའི་ཉིན་མོ་མི་ཤེས་པས་བྱ་ར་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ཁྱིམ་བདག་གིས་རྐུན་མ་སླེབས་པའི་དུས་དེ་ཤེས་པ་ཡིན་ན། གཉིད་མ་ལོག་པར་སྒུག་ནས་ཁང་པར་འཛུལ་དུ་མི་འཇུག་པ་དེ་རྟོགས་པར་གྱིས། ");
INSERT INTO bod_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","དེའི་ཕྱིར་ཁྱེད་ཚོའང་གྲ་སྒྲིག་བྱས་ནས་སྡོད་དགོས། གང་ལགས་ཟེར་ན། མིའི་རིགས་ཀྱི་བུ་ཁྱེད་ཀྱིས་མི་སེམས་པའི་དུས་ལ་ཕེབས་ངེས་ཡིན་ནོ། །” ");
INSERT INTO bod_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“བློ་གཏད་ཆོག་པ་དང་ཤེས་རབ་དང་ལྡན་པའི་གཡོག་པོ་དེ་སུ་ཡིན། ཁྱིམ་བདག་གིས་མི་དེ་ལ་དབང་ཆ་སྤྲད་ནས་ཁོས་དུས་ལ་འབབ་སྐབས་གཡོག་པོ་གཞན་རྣམས་ལ་ཟས་སྐལ་སྟེར་བར་བྱེད་མཁན་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ཁྱིམ་བདག་ཡོང་ནས་ལྟ་སྐབས་དེ་ལྟར་བྱེད་བཞིན་པའི་གཡོག་པོ་ནི་བདེའོ། ");
INSERT INTO bod_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ངས་ཁྱོད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ཁྱིམ་བདག་དེས་ཁོ་ལ་གང་ཡོད་པ་ཐམས་ཅད་གཡོག་པོ་དེའི་དབང་འོག་ཏུ་འཇུག་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","འོན་ཀྱང་གཡོག་པོ་ངན་པ་དེས་ཁྱིམ་བདག་འགྱང་བར་ཡོང་བསམས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","གཡོག་པོ་གཞན་རྣམས་བརྡུངས་ཏེ་ར་བཟི་མཁན་དང་མཉམ་དུ་ཟ་འཐུང་བྱས་ན། ");
INSERT INTO bod_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","གཡོག་པོས་མི་སེམས་པའི་ཉིན་དང༌། མི་ཤེས་པའི་དུས་ཚོད་ལ་ཁྱིམ་བདག་ཡོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ཁོ་དུམ་བུར་བཅད་ནས་ཁ་བཤད་དོན་ལ་མི་གནས་པ་རྣམས་དང་ལྷན་དུ་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་པའི་གནས་སུ་འཇུག་ངེས་ཡིན་ནོ། །” ");
INSERT INTO bod_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“དེའི་དུས་སུ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་སྣུམ་བཞུ་འཁུར་ཏེ་མག་པ་ཐུག་པར་སོང་བའི་བག་གཡོག་གཞོན་ནུ་མ་བཅུ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","དེ་ཚོའི་ནང་ནས་གཞོན་ནུ་མ་ལྔ་ནི་བླུན་པོ་དང༌། ལྔ་ནི་ཤེས་རབ་ཅན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","བླུན་པོ་རྣམས་ཀྱིས་སྣུམ་བཞུ་འཁྱེར་ཡང་བཞུ་སྣུམ་མ་འཁྱེར། ");
INSERT INTO bod_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ཤེས་རབ་ལྡན་པ་རྣམས་ཀྱིས་ཁོ་ཚོའི་སྣུམ་བཞུ་དང་བཅས་པར་བཞུ་སྣུམ་ཡང་སྣོད་ནང་འཁྱེར། ");
INSERT INTO bod_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","མག་པ་འགྱང་བར་གྱུར་བས་དེ་ཚོ་ཐམས་ཅད་གཉིད་བྲོ་སྟེ་གཉིད་ལོག ");
INSERT INTO bod_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ནམ་ཕྱེད་ལ་མི་རྣམས་ཀྱིས་སྐད་ཆེན་པོས། ལྟོས་ཤིག མག་པ་སླེབས་བྱུང༌། ཁོང་མཇལ་བར་ཤོག་ཅེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","གཞོན་ནུ་མ་ཐམས་ཅད་བླངས་ནས་སྣུམ་བཞུ་གྲ་སྒྲིག་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","བླུན་པོ་རྣམས་ཀྱིས་ཤེས་རབ་ལྡན་པ་རྣམས་ལ་ང་ཚོའི་སྣུམ་བཞུ་ཤི་གྲབས་འདུག་པས་ཁྱེད་ཚོའི་སྣུམ་ལས་ང་ཚོ་ལ་གནང་རོགས་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ལན་དུ་ཤེས་རབ་ལྡན་པས། དེ་ལྟར་བྱས་ན་ང་ཚོ་ཚང་མ་མི་འདང་བར་འགྱུར་བས་སྣུམ་འཚོང་སར་སོང་ལ་རང་གི་དོན་དུ་སྣུམ་ཉོས་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","བླུན་པོ་རྣམས་སྣུམ་ཉོ་བར་འགྲོ་དུས་མག་པ་སླེབས། གྲ་སྒྲིག་ཡོད་པ་རྣམས་ཁོ་དང་མཉམ་དུ་བག་སྟོན་ཁང་ལ་སོང་ནས་སྒོ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","དེའི་རྗེས་སུ་གཞོན་ནུ་མ་གཞན་རྣམས་ཀྱང་སླེབས་ནས། གཙོ་བོ་ལགས། གཙོ་བོ་ལགས། སྒོ་འབྱེད་དང་ཞེས་ཞུས་ནའང༌། ");
INSERT INTO bod_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","མག་པས། ངས་ཁྱོད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། ངས་ཁྱོད་རྣམས་ངོ་མི་ཤེས་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","དེའི་ཕྱིར་ཁྱེད་ཚོས་ཉིན་མོའམ་ཆུ་ཚོད་མི་ཤེས་པས་བྱ་ར་བྱོས་ཤིག” ");
INSERT INTO bod_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“དེ་ནི་མི་ཞིག་ཡུལ་གཞན་ལ་འགྲོ་བའི་སྔོན་ལ་རང་གི་གཡོག་པོ་རྣམས་བོས་ཏེ་ཁོ་ཚོར་ཁོའི་ནོར་རྫས་གཏད་པ་ཞིག་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","རེ་རེའི་ནུས་ཚད་ལྟར་ཁོས་གཅིག་ལ་གསེར་ཊམ་ཀ་ལྔ་སྟོང་དང༌། གཅིག་ལ་ཉིས་སྟོང་དང༌། གཞན་ཞིག་ལ་ཆིག་སྟོང་སྟེར་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","འཕྲལ་དུ་གསེར་ཊམ་ཀ་ལྔ་སྟོང་འཐོབ་མཁན་སོང་ནས་ཉོ་ཚོང་བྱེད་པའི་སྒོ་ནས་གསེར་ཊམ་ཀ་ལྔ་སྟོང་ཁེ་བཟང་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","དེ་ལྟར་གསེར་ཊམ་ཀ་ཉིས་སྟོང་འཐོབ་མཁན་ལའང་གསེར་ཊམ་ཀ་ཉིས་སྟོང་ཁེ་བཟང་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","འོན་ཀྱང་གསེར་ཊམ་ཀ་ཆིག་སྟོང་འཐོབ་མཁན་ཕར་སོང་ནས་ས་ལ་ཁུང་ཞིག་དྲུས་པ་དང༌། རང་གི་བདག་པོའི་གསེར་ཊམ་ཀ་སྦས་ཏེ་བཞག ");
INSERT INTO bod_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","དུས་ཡུན་རིང་པོའི་རྗེས་སུ་གཡོག་པོ་དེ་རྣམས་ཀྱི་བདག་པོ་དེ་ལོག་ཡོང་ནས་རྩིས་དག་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","གསེར་ཊམ་ཀ་ལྔ་སྟོང་འཐོབ་མཁན་ཡོང་ནས་གཞན་གསེར་ཊམ་ཀ་ལྔ་སྟོང་འཁྱེར་ཏེ། དཔོན་པོ་ལགས། གཟིགས་དང༌། ང་ལ་གསེར་ཊམ་ཀ་ལྔ་སྟོང་ཁེ་བཟང་བྱུང་ཞེས་སྨྲས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","དཔོན་པོས་ཁོ་ལ། གཡོག་པོ་བཟང་ཞིང་བློ་གཏད་ཆོག་པ་ཁྱོད། དངོས་པོ་ཉུང་ངུའི་ནང་ལ་དྲང་པོ་བྱས་པས་ངས་ཁྱོད་ལ་དངོས་པོ་མང་པོའི་དོ་དམ་པར་སྐོ་བར་བྱ། ད་ང་དང་མཉམ་དུ་དགའ་སྤྲོ་བྱེད་པར་ཤོག་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ཡང་གསེར་ཊམ་ཀ་ཉིས་སྟོང་འཐོབ་མཁན་ཡོང་ནས་ཁོ་ལ། དཔོན་པོ་ལགས། ཁྱེད་ཀྱིས་ང་ལ་གསེར་ཊམ་ཀ་ཉིས་སྟོང་གཏད་བྱུང༌། གཟིགས་དང༌། ང་ལ་གསེར་ཊམ་ཀ་ཉིས་སྟོང་ཁེ་བཟང་བྱུང་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","དཔོན་པོས་ཁོ་ལ། གཡོག་པོ་བཟང་ཞིང་བློ་གཏད་ཆོག་པ་ཁྱོད། དངོས་པོ་ཉུང་ངུའི་ནང་ལ་དྲང་པོ་བྱས་པས་ངས་ཁྱོད་ལ་དངོས་པོ་མང་པོའི་དོ་དམ་པར་སྐོ་བར་བྱ། ད་ང་དང་མཉམ་དུ་དགའ་སྤྲོ་བྱེད་པར་ཤོག་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","དེ་ནས་གསེར་ཊམ་ཀ་ཆིག་སྟོང་འཐོབ་མཁན་ཡོང་ནས། དཔོན་པོ་ལགས། ཁྱེད་ནི་མ་བཏབ་ས་ནས་རྔ་བ་དང༌། སོན་མ་གཏོར་ས་ནས་སྡུད་མཁན་དྲག་པོ་ཞིག་ཡིན་པ་ངས་ཤེས་པས། ");
INSERT INTO bod_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ང་འཇིགས་ཏེ་ཕར་སོང་ཞིང་གསེར་ཊམ་ཀ་དེ་ས་ལ་སྦས་ཏེ་བཞག གཟིགས་དང༌། ཁྱེད་རང་གི་ཡིན་པ་འདིར་འདུག་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","འོན་ཀྱང་དཔོན་པོས་ཁོ་ལ། གཡོག་པོ་ངན་པ་ལེ་ལོ་ཅན་ཁྱོད། ང་ནི་མ་བཏབ་ས་ནས་རྔ་བ་དང༌། སོན་མ་གཏོར་ས་ནས་སྡུད་མཁན་ཞིག་ཡིན་པ་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","འོ་ན་ཁྱོད་ཀྱིས་ངའི་དངུལ་ནི་དངུལ་ཁང་ལ་བཞག་དགོས་པ་ཡིན། དེ་ནས་ངའི་དངུལ་དེ་སྐྱེད་ཀ་དང་བཅས་པར་འཐོབ་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","དེ་བས་ན། གཡོག་པོ་འདི་ནས་གསེར་ཊམ་ཀ་ཆིག་སྟོང་བླངས་ནས་གསེར་ཊམ་ཀ་ཁྲི་གཅིག་ཡོད་མཁན་ལ་སྟེར་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","གང་ཡིན་ཟེར་ན། སུ་ལ་ཡོད་པ་དེ་ལ་སྟེར་བར་འགྱུར་ཏེ་ལྷག་པ་ཡོད་པར་འགྱུར། འོན་ཀྱང་སུ་ལ་མེད་པ་དེ་ནས་གང་ཡོད་པའང་ལེན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ཕན་མེད་ཀྱི་གཡོག་པོ་འདི་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་ས་དེ་ཕྱི་རོལ་གྱི་མུན་པའི་ནང་དུ་དབྱུགས་ཤིག” ");
INSERT INTO bod_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“མིའི་རིགས་ཀྱི་བུ་ནི་ཕོ་ཉ་དང་བཅས་གཟི་བརྗིད་དང་ལྡན་པར་འབྱོན་པའི་སྐབས་སུ། རང་གི་གཟི་བརྗིད་ལྡན་པའི་བཞུགས་ཁྲི་ལ་བཞུགས་པར་འགྱུར་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","མི་རིགས་ཐམས་ཅད་ཁོང་གི་མདུན་དུ་བསྡུད་ནས། ལུག་རྫི་ཡིས་ར་རྣམས་ལས་ལུག་སོ་སོར་འབྱེད་པ་ལྟར། ཁོང་གིས་དེ་ཚོའང་འབྱེད་པར་གྱུར་ནས། ");
INSERT INTO bod_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ལུག་རྣམས་ཁོང་གི་གཡས་ཕྱོགས་དང༌། ར་རྣམས་ཁོང་གི་གཡོན་ཕྱོགས་སུ་འཇུག ");
INSERT INTO bod_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","དེ་ནས་རྒྱལ་པོས་གཡས་ཕྱོགས་སུ་ཡོད་པ་རྣམས་ལ། ངའི་ཡབ་ཀྱིས་བྱིན་གྱིས་རླབས་པ་ཁྱོད་རྣམས། ཤོག་ལ། འཇིག་རྟེན་བཀོད་པ་ནས་ཁྱོད་ཚོའི་ཕྱིར་བཤམས་པའི་རྒྱལ་སྲིད་འཛིན་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","རྒྱུ་མཚན་ནི་ཁྱོད་ཀྱིས་ང་ལྟོགས་པ་ལ་ཟས་སྟེར། སྐོམ་པ་ལ་བཏུང་བ་སྟེར། ངོ་མི་ཤེས་པ་ཡིན་པ་ལ་གནས་ཚང་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","གོས་མེད་པ་ལ་གོས་སྟེར། ན་བ་ལ་བདག་སྐྱོང་བྱས། བཙོན་ཁང་ལ་ཡོད་པ་ལ་ང་མཇལ་བར་ཡོང་ཞེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","དེ་ནས་དྲང་ལྡན་རྣམས་ཀྱིས། གཙོ་བོ་ལགས། ངེད་རྣམས་ཀྱིས་ཁྱེད་བཀྲེས་པའམ། སྐྱེམས་པ། ");
INSERT INTO bod_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ཞལ་མི་ཤེས་པའམ། གོས་མེད་པར་མཐོང་སྟེ། ཞལ་ཟས་སམ། སྐྱེམས། གནས་ཚང་ངམ། ན་བཟའ་ག་དུས་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ཡང་སྙུང་བའམ། བཙོན་ཁང་ལ་མཐོང་སྟེ་ག་དུས་མཇལ་བར་ཡོང་ཞེས་ལན་འདེབས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","རྒྱལ་པོས་ཁོ་རྣམས་ལ། ངས་ཁྱོད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྱོད་ཚོས་ངའི་སྤུན་ཟླ་ཆུང་ཤོས་འདི་རྣམས་ཀྱི་ནང་ནས་གཅིག་ལ་ཡང་དེ་ལྟར་བྱས་པ་ཙམ་གྱིས། ང་ལའང་བྱས་ཞེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","དེ་ནས་ཁོང་གིས་གཡོན་ཕྱོགས་སུ་ཡོད་པ་རྣམས་ལ། དམོད་པ་ཕོག་པ་ཁྱོད་ཚོ། ངའི་མདུན་ནས་བདུད་རྒྱལ་དང་ཁོའི་ཕོ་ཉ་རྣམས་ཀྱི་ཆེད་དུ་བཤམས་ཏེ་གསོད་པར་མི་ཐུབ་པའི་མེ་ལ་ཕར་རྒྱུགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","རྒྱུ་མཚན་ནི་ཁྱོད་ཀྱིས་ང་ལྟོགས་པ་ལ་ཟས་མ་སྟེར། སྐོམ་པ་ལ་བཏུང་བ་མ་སྟེར། ");
INSERT INTO bod_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ངོ་མི་ཤེས་པ་ལ་གནས་ཚང་མ་བཏང༌། གོས་མེད་པ་ལ་གོས་མ་སྟེར། ན་བ་ལ་བདག་སྐྱོང་མ་བྱས། བཙོན་ཁང་དུ་ཡོད་པ་ལ་ང་མཇལ་བར་མ་འོངས་ཞེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","དེ་ནས་ཁོ་ཚོས་ཀྱང༌། གཙོ་བོ་ལགས། ངེད་ཀྱིས་ཁྱེད་བཀྲེས་པའམ། སྐོམ་པ། ངོ་མི་ཤེས་པའམ། གོས་མེད་པ། ན་བའམ། བཙོན་ལ་ཡོད་པར་མཐོང་ནས་ག་དུས་བདག་སྐྱོང་མ་བྱས་ཞེས་ཟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ལན་དུ་ཁོང་གིས། ངས་ཁྱོད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྱོད་ཚོས་ཆུང་ཤོས་འདི་རྣམས་ཀྱི་ནང་ནས་གཅིག་ལ་ཡང་དེ་ལྟར་མ་བྱས་པ་ཙམ་གྱིས། ང་ལའང་མ་བྱས་ཞེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","དེ་ནས་འདི་རྣམས་མཐའ་མེད་པའི་ཆད་པར་འགྲོ་བར་འགྱུར་ལ། དྲང་ལྡན་རྣམས་དཔག་ཏུ་མེད་པའི་ཚེ་ལ་འགྲོའོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ཡེ་ཤུས་བཀའ་དེ་གསུངས་ཚར་ནས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་ ");
INSERT INTO bod_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ཉིན་གཉིས་ཀྱི་རྗེས་སུ་པེ་སག་དུས་ཆེན་འབབ་པར་འགྱུར་ཁྱེད་རྣམས་ཀྱིས་ཤེས། མིའི་རིགས་ཀྱི་བུ་ནི་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་པའི་སྒོ་ནས་གསོད་པར་གཏད་རྒྱུ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","དེ་ནས་བླ་ཆེན་དང་ཡུལ་མིའི་རྒན་པོ་རྣམས་ཀ་ཡ་ཕཱ་ཞེས་ཟེར་བའི་བླ་ཆེན་གཙོ་བོའི་ཕོ་བྲང་ནང་འཛོམས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ཁོ་ཚོས་ཡེ་ཤུ་ལྐོག་ཏུ་བཟུང་ནས་ཁོང་གསོད་པའི་ཇུས་ངན་བྱས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“ཡུལ་མི་རྣམས་ཟིང་ཆ་ལངས་ཉེན་ཡོད་པས་དུས་ཆེན་ལ་མི་གཟུང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ཡེ་ཤུ་པེ་ཐན་ཡཱ་ཞེས་བྱ་བའི་གྲོང་སྡེའི་ནང་མཛེ་ནད་ཅན་གྱི་སྐྱེས་པ་སི་མོན་གྱི་ཁང་པ་ལ་བཞུགས་པའི་ཚེ། ");
INSERT INTO bod_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ཁོང་གསོལ་བ་བཞེས་པའི་དུས་སུ་བུད་མེད་ཅིག་གིས་རིན་གོང་ཆེ་བའི་སྤོས་ཆུ་ཡིས་གང་བའི་རྡོ་ཀ་མ་རུའི་བུམ་པ་ཞིག་ཁྱེར་ཡོང་སྟེ། སྤོས་ཆུ་དེ་ཁོང་གི་དབུའི་སྟེང་ལ་བླུགས། ");
INSERT INTO bod_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","དེ་མཐོང་བས་ཉེ་གནས་རྣམས་ཁྲོས་ནས་“སྤོས་ཆུ་འདི་གང་གི་དོན་ལ་འདི་ལྟར་འཕྲོ་བརླག་བཏང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","དེ་རིན་ཆེན་པོར་བཙོངས་ཏེ་དབུལ་པོ་རྣམས་ལ་བྱིན་ན་ལེགས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ཡེ་ཤུས་དེ་མཁྱེན་ནས་ཁོ་རྣམས་ལ་“ཅིའི་ཕྱིར་ཁོ་མོ་ལ་སྡུག་པོ་གཏོང༌། ཁོ་མོས་ང་ལ་ལས་བཟང་པོ་ཞིག་བྱས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","དབུལ་པོ་རྣམས་དུས་རྟག་ཏུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཡོད་ཀྱང༌། ང་རང་ནི་དུས་རྟག་ཏུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་མི་གནས། ");
INSERT INTO bod_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ངའི་ལུས་ལ་སྤོས་ཆུ་དེ་བླུག་པའི་སྒོ་ནས་ཁོ་མོས་ང་དུར་ཁང་དུ་འཇུག་པར་གྲ་སྒྲིག་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། འཇིག་རྟེན་ཡོངས་སུ་ངའི་འཕྲིན་བཟང་འདི་གང་དུ་བསྒྲགས་ནའང་བུད་མེད་འདིས་གང་བྱས་པ་དེ་དྲན་པའི་ཕྱིར་གཏམ་དེ་ཡང་བརྗོད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","དེ་ནས་ཉེ་གནས་བཅུ་གཉིས་པོའི་ནང་ནས་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་ཟེར་བའི་མི་ཞིག་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱི་རྩར་སོང་ནས། ");
INSERT INTO bod_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ཁོ་ཚོར་“གལ་ཏེ་ངས་ཁོང་ཁྱེད་ཀྱི་དབང་དུ་གཏད་ན་ཁྱེད་ཀྱིས་ང་ལ་ག་རེ་སྟེར་རམ་”ཞེས་བཤད་པས། ཁོ་ཚོས་ཁོ་ལ་དངུལ་སྒོར་སུམ་ཅུ་སྟེར། ");
INSERT INTO bod_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","དེ་ནས་བཟུང་ཁོས་ཡེ་ཤུ་ཁོ་ཚོའི་ལག་ཏུ་སྤྲོད་རྒྱུའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་གྱི་ཉིན་དང་པོར་ཉེ་གནས་རྣམས་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་ཁོང་ལ་“ཁྱེད་ཀྱིས་པེ་སག་གི་ཞལ་ཟས་བཞེས་པའི་ཕྱིར་ང་ཚོས་གང་དུ་གྲ་སྒྲིག་བྱེད་”ཅེས་སྨྲས་པས། ");
INSERT INTO bod_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ཁོང་གིས་“གྲོང་ཁྱེར་དུ་མི་ཞིག་གི་རྩར་སོང་ནས་ཁོ་ལ། སློབ་དཔོན་གྱིས་ངའི་དུས་ལ་འབབ་འདུག ངའི་ཉེ་གནས་དང་བཅས་པར་ཁྱེད་ཀྱི་ཁང་པར་པེ་སག་གི་དུས་ཆེན་སྲུང་རྒྱུ་ཡིན་ཞེས་ཟེར་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ཉེ་གནས་རྣམས་ཀྱིས་ཡེ་ཤུའི་བཀའ་བཞིན་དུ་བྱས་ཏེ་པེ་སག་གི་གསོལ་སྟོན་བཤམས། ");
INSERT INTO bod_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","མཚན་མོའི་དུས་སུ་ཁོང་དང་ཉེ་གནས་བཅུ་གཉིས་པོ་འཁོར་དང་བཅས་པ་གསོལ་སྟོན་དུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ཁོང་རྣམས་ཀྱིས་ཞལ་ཟས་བཞེས་པའི་དུས་སུ་ཁོང་གིས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་རྣམས་ལས་མི་གཅིག་གིས་ང་ལ་རྒྱབ་གཏོད་བྱེད་ངེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ཁོ་ཚོའི་སེམས་ཤིན་ཏུ་སྐྱོ་བར་གྱུར་ཏེ། རེ་རེ་བཞིན་གྱིས་ཁོང་ལ་“གཙོ་བོ། ང་རང་ཡིན་མི་སྲིད་”ཅེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ལན་དུ་ཁོང་གིས་“ང་དང་མཉམ་དུ་ཕོར་པ་གཅིག་གི་ནང་ནས་ཟས་ཟ་མཁན་དེ་ནི་ང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","དཀོན་མཆོག་གི་གསུང་རབ་ལས་མིའི་རིགས་ཀྱི་བུ་རང་ཉིད་ཀྱི་སྐོར་ལ་ཇི་ལྟར་ལུང་བསྟན་ཡོད་པ་བཞིན་འཆི་དགོས་ཀྱང༌། མིའི་རིགས་ཀྱི་བུ་དགྲའི་ལག་ཏུ་སྤྲོད་མཁན་དེར་ཆད་པ་ཕོག་ངེས་ཡིན་ནོ། མི་དེ་འཇིག་རྟེན་འདི་རུ་སྐྱེས་པ་ལས་མ་སྐྱེས་ན་ལེགས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ཁོང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་ཡུ་དཱ་ཡིས་“རབ་བི། ང་རང་ཡིན་ནམ་”ཞེས་བཤད་པས་ཡེ་ཤུས་ཁོ་ལ་“ཁྱོད་ཀྱིས་སྨྲས་པ་བཞིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ཁོང་རྣམས་ཀྱིས་ཞལ་ཟས་བཞེས་པའི་དུས་སུ་ཡེ་ཤུས་བག་ལེབ་ཕྱག་ཏུ་བསྣམས་ཤིང༌། དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་རྗེས་དུམ་བུར་བགོས་ནས་ཉེ་གནས་རྣམས་ལ་གནང་སྟེ་“འདི་ནི་ངའི་ལུས་ཡིན་པས་ཁྱེད་ཚོས་ལོངས་ནས་ཟོ་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","དེ་ནས་ཁོང་གིས་ཕོར་པ་ཞིག་ཕྱག་ཏུ་བསྣམས་ཤིང་བཀའ་དྲིན་ཆེ་ཞུས་ནས་ཁོ་ཚོར་གནང་སྟེ་“འདི་ལས་ཁྱེད་ཐམས་ཅད་འཐུང་ཞིག ");
INSERT INTO bod_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","འདི་ནི་ངའི་ཁྲག་ཡིན་ཏེ། ཞལ་ཆད་ཀྱི་ཁྲག་འདི་མི་མང་པོའི་སྡིག་ཉེས་སེལ་བའི་ཆེད་དུ་འཐོན་ནོ། ");
INSERT INTO bod_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ངའི་ཡབ་ཀྱི་རྒྱལ་སྲིད་ནང་རྒུན་ཆང་གསར་པ་ཁྱེད་ཚོ་དང་མཉམ་དུ་མ་འཐུང་བའི་ཉིན་མོའི་བར་དུ། ངས་རྒུན་ཆང་འདི་རྩ་བ་ནས་མི་འཐུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ཁོང་རྣམས་ཀྱིས་གསུང་མགུར་བླངས་ནས་སྐྱུར་རུ་ཤིང་གི་རི་བོར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","དེ་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“དཀོན་མཆོག་གི་གསུང་རབ་ཀྱི་མདོ་ལ་བཀོད་པ་ལྟར། ང་ཡིས་ལུག་རྫི་རྡུང་ནས་བསད། ། དེ་རྗེས་ལུག་ཁྱུ་འཐོར་བར་འགྱུར། ། ངའི་རྐྱེན་གྱིས་མཚན་འདིར་ཁྱོད་ཚོ་ཐམས་ཅད་ང་དང་བྲལ་ནས་འབྲོས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","འོན་ཀྱང་ང་འཆི་བ་ནས་སླར་གསོན་པར་འཇུག་རྗེས་ཁྱེད་ཚོའི་སྔོན་ལ་ག་ལིལ་ཡུལ་དུ་འགྲོ་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","པེ་ཏྲོས་ཁོང་ལ་“ཁྱེད་རང་ལ་གང་འབྱུང་རྒྱུའི་རྐྱེན་གྱིས་ཐམས་ཅད་ཁྱེད་དང་བྲལ་ནའང་ང་ནི་མི་འབྲལ་ལོ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ཡེ་ཤུས་ཁོ་ལ་“ངས་ཁྱེད་ལ་བདེན་པར་ཟེར་རྒྱུར། དེ་རིང་གི་མཚན་མོ་འདི་རང་ལ་བྱ་ཕོས་སྐད་མ་གྲགས་པའི་སྔོན་ལ་ཁྱེད་ཀྱིས་ང་རང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་ཟེར་བར་ངེས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","པེ་ཏྲོས་ཁོང་ལ་“ང་ནི་ཁྱེད་དང་མཉམ་དུ་ཤི་དགོས་ཀྱང་ཁྱེད་སུ་ཡིན་མི་ཤེས་ཞེས་ཟེར་མི་སྲིད་”ཅེས་ནན་གྱིས་ཞུས། ཉེ་གནས་ཐམས་ཅད་ཀྱིས་ཀྱང་དེ་ལྟར་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","དེ་ནས་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་གེད་སེམ་མཱ་ནེ་ཞེས་བྱ་བའི་གནས་སུ་ཕེབས་པ་དང༌། ཁོང་གིས་ཁོ་རྣམས་ལ་“ང་དེར་སོང་སྟེ་གསོལ་བ་འདེབས་དུས་ཁྱེད་ཚོ་གནས་འདིར་སྡོད་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","པེ་ཏྲོ་དང་ཟེ་བད་ཡཱ་ཟེར་མཁན་གྱི་བུ་གཉིས་འཁྲིད་པ་དང༌། ཁོང་ཐུགས་ཤིན་ཏུ་སྐྱོ་ཞིང་འཁྲུགས་པར་གྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ཁོ་ཚོར་“ངའི་ཡིད་ཤིན་ཏུ་སྐྱོ་ཞིང་འཆི་ལ་ཉེ་བས། ང་དང་མཉམ་དུ་འདི་རུ་གཉིད་མ་ལོག་པར་བྱ་ར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","དེ་ནས་ཁོང་ཅུང་ཟད་ཕར་ཕེབས་ནས་ཕྱག་འཚལ་ཏེ་“ངའི་ཡབ་ལགས། སྲིད་ན་སྡུག་བསྔལ་གྱི་ཕོར་པ་འདི་ང་ལས་ཕར་ལེན་མཛོད། འོན་ཀྱང་ངའི་བསམ་པ་བཞིན་དུ་མིན་པར་ཁྱེད་ཀྱི་དགོངས་པ་བཞིན་དུ་གྱུར་ཅིག་”ཅེས་གསོལ་བ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ཁོང་ཚུར་ཕེབས་སྐབས་དེ་རྣམས་གཉིད་ལོག་གི་ཡོད་པར་གཟིགས་ནས་པེ་ཏྲོ་ལ་“འོ་ན། ཁྱོད་ཚོས་ཆུ་ཚོད་གཅིག་ཙམ་ལའང་ང་དང་མཉམ་དུ་བྱ་ར་བྱེད་མ་ཐུབ་བམ། ");
INSERT INTO bod_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ཁྱེད་སླུ་བར་མི་འགྱུར་བའི་ཕྱིར་བྱ་ར་བྱོས་ལ་སྨོན་ལམ་ཐོབས་ཤིག ཁྱེད་ཀྱི་སེམས་ནས་དེ་ལྟར་བྱེད་བསམ་ཡང་ལུས་པོའི་ནུས་ཤུགས་ཞན་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ཡང་ཐེངས་གཉིས་པར་ཕར་ཕེབས་ཏེ་ཁོང་གིས་“ངའི་ཡབ་ལགས། སྡུག་བསྔལ་གྱི་ཕོར་པ་འདི་ངས་མ་འཐུང་བར་ང་ལས་ཕར་ལེན་མི་སྲིད་ན། ཁྱེད་ཀྱི་དགོངས་པ་བཞིན་དུ་གྱུར་ཅིག་”ཅེས་གསོལ་བ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ཁོང་ཚུར་ཕེབས་ནས་ཁོ་རྣམས་མིག་ལྗིད་པོ་ཆགས་པས་གཉིད་ཁུག་ཡོད་པར་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ཁོ་ཚོ་དང་ཁ་བྲལ་ནས་ཕར་ཕེབས་ཏེ། སྔོན་གྱི་ཚིག་དེ་རང་གསུངས་ཏེ་ཁོང་གིས་ཐེངས་གསུམ་པར་གསོལ་སྨོན་བཏབ། ");
INSERT INTO bod_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","དེ་ནས་ཁོང་ཉེ་གནས་ཀྱི་རྩར་ཕེབས་ཏེ་ཁོ་ཚོར་“ཁྱེད་ཚོ་ད་དུང་གཉིད་ལོག་ནས་ངལ་གསོའམ། ལྟོས་ཤིག མིའི་རིགས་ཀྱི་བུ་སྡིག་ཅན་རྣམས་ཀྱི་དབང་དུ་སྤྲོད་པར་བྱེད་པའི་དུས་ལ་འབབ་འདུག ");
INSERT INTO bod_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ལོངས་ལ་འགྲོ ལྟོས་ཤིག ང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་དེ་ཉེ་བར་སླེབས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ཁོང་གིས་དེ་ལྟར་གསུངས་དུས་ཉེ་གནས་བཅུ་གཉིས་པོ་ལས་ཡུ་དཱ་དང་མཉམ་དུ། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཡུལ་མི་རྣམས་ཀྱི་རྒན་པོས་བཏང་བའི་མི་ཚོགས་མང་པོ་ཞིག་ལག་ཏུ་རལ་གྲི་དང་དབྱུག་པ་འཁྱེར་ཏེ་ས་ཆ་དེར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ཁོང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་དེས་སྔོན་ནས་ཁོ་ཚོར་གསང་བརྡ་གྲ་སྒྲིག་བྱས་ཏེ་“ངས་སུ་ལ་འོ་བྱས་པ་དེ་ཁོང་རང་ཡིན་པས་ཟུངས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","འཕྲལ་དུ་ཡེ་ཤུའི་མདུན་དུ་ཡོང་ནས་ཡུ་དཱ་ཡིས་“རབ་བི། ཁྱེད་ལ་ཞི་བདེ་ལྡན་པར་གྱུར་ཅིག་”ཅེས་ཟེར་ནས་འགྲམ་པར་འོ་ཡིས་འཚམས་འདྲི་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ཡེ་ཤུས་ཁོ་ལ་“གྲོགས་པོ། ཁྱོད་ཀྱིས་གང་བྱེད་པར་ཡོང་བ་དེ་བྱོས་”ཞེས་གསུངས། དེ་རྗེས་ཁོ་ཚོ་ཡོང་ནས་ཁོང་འཛིན་བཟུང་བྱས་པས། ");
INSERT INTO bod_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ཡེ་ཤུ་དང་མཉམ་དུ་ཡོད་པ་ཞིག་གིས་རལ་གྲི་བཟུང་ནས་བཏོན་ཏེ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོའི་གཡོག་པོའི་རྣ་བ་ཡ་གཅིག་བཅད། ");
INSERT INTO bod_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","དེ་ནས་ཡེ་ཤུས་ཁོ་ལ་“རལ་གྲི་དེ་ཤུབས་སུ་ཆུག་ཅིག གང་ཡིན་ཞེ་ན། རལ་གྲི་འདོན་ཚད་རལ་གྲི་ཡིས་གསོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ངའི་ཡབ་ཀྱིས་ཞིང་ཁམས་ཀྱི་ཕོ་ཉའི་དམག་དཔུང་བཅུ་གཉིས་ལས་མང་བ་ང་ལ་འཕྲལ་དུ་མངགས་པའི་ཕྱིར་ངས་ཁོང་ལ་ཞུ་མི་ཐུབ་པ་དེ་སེམས་སམ། ");
INSERT INTO bod_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","འོན་ཀྱང་དེ་ལྟར་བྱས་ན། འདི་ལྟར་འབྱུང་དགོས་པའི་མདོ་དེ་ཅི་ལྟར་འགྲུབ་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","དེའི་ཚེ་ཡེ་ཤུས་མི་ཚོགས་ལ་“རལ་གྲི་དང་དབྱུག་པ་ཁྱེར་ནས་ང་ཇག་པ་ལྟར་འཛིན་དུ་ཡོང་ངམ། ང་ནི་ཉིན་རེ་བཞིན་མཆོད་ཁང་ཆེན་མོར་བསྡད་དེ་ཆོས་བསྟན་ཡང་ཁྱེད་ཚོས་ང་མ་བཟུང༌། ");
INSERT INTO bod_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","འོན་ཀྱང་ལུང་སྟོན་པའི་མདོ་འགྲུབ་པའི་ཕྱིར་བྱ་བ་འདི་ཐམས་ཅད་བྱུང་ངོ་”ཞེས་གསུངས་རྗེས་ཉེ་གནས་ཐམས་ཅད་ཁོང་བཞག་སྟེ་བྲོས། ");
INSERT INTO bod_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ཁོང་འཛིན་མཁན་རྣམས་ཀྱིས་བླ་ཆེན་གཙོ་བོ་ཀ་ཡ་ཕཱ་ཡི་མདུན་དུ་ཁྲིད། དེར་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་རྒན་པོ་རྣམས་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","པེ་ཏྲོ་རྒྱང་རིང་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་ཏེ། བླ་ཆེན་གཙོ་བོའི་སྒོ་རའི་བར་སོང་ནས་ནང་དུ་ཞུགས་པ་དང༌། དེའི་རྗེས་སུ་གང་འབྱུང་བ་ལྟ་བའི་ཕྱིར་སྲུང་དམག་རྣམས་དང་མཉམ་དུ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང་ཡ་ཧུ་དཱ་པའི་རྒྱལ་ཚོགས་ཀྱི་མི་ཐམས་ཅད་ཀྱིས་ཁོང་སྲོག་གཅོད་གཏོང་བའི་ཕྱིར་སྙད་འདོགས་བཙལ་ནས། ");
INSERT INTO bod_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","རྫུན་གྱི་དཔང་པོ་བྱེད་མཁན་མང་པོ་ཡོང་ནའང་སྐྱོན་མ་རྙེད། མཇུག་ཏུ་མི་གཉིས་ཡོང་ནས། ");
INSERT INTO bod_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ཁོ་ཚོས་“མི་འདི་ཡིས་ངས་དཀོན་མཆོག་གི་མཆོད་ཁང་ཆེན་མོ་བཤིག་ནས་ཉིན་གསུམ་ལ་རྩིག་ཐུབ་ཅེས་ཟེར་བ་ང་ཚོས་ཐོས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","བླ་ཆེན་གཙོ་བོ་ཡར་ལངས་ཏེ་ཡེ་ཤུ་ལ་“མི་འདི་རྣམས་ཀྱིས་ཁྱོད་ལ་དཔང་པོ་བྱེད་པ་དེ་ཅི་ཡིན། ཁྱོད་ཀྱིས་ལན་ཅི་ཡང་མི་འདེབས་སམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ཁོང་གིས་ཅི་ཡང་མ་གསུངས་པས་བླ་ཆེན་གཙོ་བོས་ཁོང་ལ་“ངས་ཁྱོད་ལ་གཏན་དུ་གནས་པའི་དཀོན་མཆོག་གི་སྒོ་ནས་ཁྱོད་ཀྱིས་མནའ་སྐྱེལ་ཏེ། ཁྱོད་ནི་དཀོན་མཆོག་གི་སྲས་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ནམ་མ་ཡིན་ང་ཚོ་ལ་ཤོད་ཅིག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ཡེ་ཤུས་ཁོ་ལ་“ཁྱེད་ཀྱིས་གསུངས་པ་དེ་ལྟར་ཡིན། ཡང་ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། རྗེས་མ་ཁྱེད་ཚོས་མིའི་རིགས་ཀྱི་བུ་ཁོང་ཉིད་དབང་ཀུན་དང་ལྡན་པའི་དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་བཞུགས་ཏེ་ནམ་མཁའི་སྤྲིན་དང་བཅས་འབྱོན་པ་མཐོང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","དེ་ཐོས་ནས་བླ་ཆེན་གཙོ་བོས་རང་གི་ཕྱི་གོས་དབྲལ་ཏེ་“ཁོས་དཀོན་མཆོག་ལ་སྐུར་བ་བཏབ། ད་དུང་ང་ཚོར་དཔང་པོ་ཅི་ལ་དགོས། ཉོན་ཞིག ཁོས་དཀོན་མཆོག་ལ་སྐུར་བ་བཏབ་པར་ཁྱེད་ཚོས་ད་ལྟ་ཐོས། ");
INSERT INTO bod_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ཁྱེད་ཚོར་བསམ་འཆར་ཅི་ཡོད་”ཅེས་སྨྲས་པ་ན། ཁོ་ཚོས་“ཁོ་སྲོག་གཅོད་གཏོང་འོས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","དེ་ནས་ཁོ་ཚོས་ཁོང་གི་ཞལ་ལ་མཆིལ་མ་གཏོར་ཞིང་བརྡུངས་ཏེ་གཞན་རྣམས་ཀྱིས་འགྲམ་ལྕག་བཞུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ཁོང་ལ་“མཱ་ཤི་ཀ་ཁྱོད། ང་ཚོ་ལ་མངོན་ཤེས་ཤོད་ཅིག ཁྱོད་ལ་གཞུ་མཁན་སུ་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","པེ་ཏྲོ་ཕྱི་རོལ་ཏུ་སྒོ་རར་བསྡད་དུས་གཡོག་མོ་ཞིག་དེའི་རྩར་ཡོང་ནས་“ཁྱེད་ཀྱང་ག་ལིལ་ཡུལ་གྱི་མི་ཡེ་ཤུ་དང་མཉམ་དུ་ཡོད་པ་གཅིག་ཡིན་”ཅེས་སྨྲས་པས། ");
INSERT INTO bod_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","པེ་ཏྲོས་ཁོ་ཚོ་ཚང་མའི་མདུན་དུ་ཁས་མ་བླངས་པར་“ཁྱོད་ཀྱིས་གང་ལབ་པ་ངས་མི་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","དེ་ནས་རྒྱལ་སྒོའི་རྩར་ཕྱིར་སོང་ནས་གཡོག་མོ་གཞན་ཞིག་གིས་ཁོ་མཐོང་སྟེ་དེར་ཡོད་པ་རྣམས་ལ་“མི་འདི་ན་ཙ་རེལ་པ་ཡེ་ཤུ་དང་མཉམ་དུ་ཡོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","པེ་ཏྲོས་ཡང་བསྐྱར་མནའ་སྐྱེལ་ཏེ་“ངས་མི་དེ་ངོ་མི་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ཡུན་རིང་པོ་མ་ལོན་པར་དེར་ཡོད་པའི་མི་རྣམས་ཡོང་ནས་པེ་ཏྲོ་ལ་“ཁྱོད་ཀྱང་ཁོ་ཚོའི་ནང་ནས་ངེས་པར་དུ་གཅིག་ཡིན། ཁྱོད་ཀྱི་སྐད་ལུགས་ནས་ཤེས་”ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","པེ་ཏྲོས་སྡིགས་དམོད་བྱེད་བཞིན་མནའ་སྐྱེལ་ཏེ་“ངས་མི་དེ་ངོ་མི་ཤེས་”ཞེས་བཤད་མ་ཐག་ཏུ་བྱ་ཕོས་སྐད་གྲགས། ");
INSERT INTO bod_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","པེ་ཏྲོས་དེ་སྔ་ཡེ་ཤུས་ཁོ་རང་ལ་“བྱ་ཕོས་སྐད་མ་གྲགས་པའི་སྔོན་དུ་ཁྱེད་ཀྱིས་ང་རང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་སྨྲ་བར་ངེས་”ཞེས་གསུངས་པ་དེ་དྲན་ཏེ་ཕྱིར་སོང་ནས་མང་པོ་ངུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ཞོགས་པར་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོ་དང་ཡུལ་མི་རྣམས་ཀྱི་རྒན་པོ་ཚང་མས་ཡེ་ཤུ་གསོད་པའི་ཕྱིར་མཉམ་དུ་གྲོས་བསྡུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ཁོ་ཚོས་ཡེ་ཤུ་བཀྱིགས་ནས་འཁྲིད་དེ་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ལ་བཏད། ");
INSERT INTO bod_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ཡེ་ཤུ་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་ཡུ་དཱ་ཡིས་ཁོང་གསོད་དགོས་པའི་ཁྲིམས་ཐག་བཅད་པ་མཐོང་བས་འགྱོད་པ་སྐྱེས་ནས་དངུལ་སྒོར་སུམ་ཅུ་འཁྱེར་ཏེ་བླ་ཆེན་གཙོ་བོ་དང་རྒན་མི་རྣམས་ཀྱི་རྩར་ལོག་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ཁོ་ཚོར་“ངས་སྐྱོན་མེད་པའི་མི་ཞིག་ལ་རྒྱབ་གཏོད་བྱས་ནས་སྡིག་ཉེས་བྱས་”ཞེས་ཟེར་བས། དེ་ཚོས་“ང་ཚོ་ལ་འབྲེལ་བ་ཅི་ཡོད། ཁྱོད་ཀྱིས་འགན་ཁུར་དགོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","དངུལ་སྒོར་དེ་རྣམས་མཆོད་ཁང་ཆེན་མོའི་ནང་ལ་དབྱུགས་ཤིང་ཕར་སོང་སྟེ་རང་གི་སྐེ་ཐག་པས་བསྡམས་ནས་ཤི ");
INSERT INTO bod_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","བླ་ཆེན་གཙོ་བོ་རྣམས་ཀྱིས་དངུལ་སྒོར་སུམ་ཅུ་བསྡུས་ནས་“དངུལ་འདི་ནི་མི་གཅིག་གསོད་པའི་རིན་གོང་སྟེ་ཁྲག་རིན་ཡིན་པས། དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་མཆོད་ཁང་ཆེན་མོའི་མཛོད་ཁང་ལ་འཇོག་པར་མི་ཆོག་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ཁོ་རྣམས་གྲོས་བསྡུར་བྱས་ནས། ཕྱི་མི་རྣམས་དུར་དུ་འཇུག་པའི་ཕྱིར་དངུལ་དེ་ཡིས་རྫ་མཁན་གྱི་ཞིང་ཞེས་པ་དེ་ཉོས། ");
INSERT INTO bod_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","དེའི་ཕྱིར་དེ་རིང་གི་བར་དུ་ཞིང་དེར་ཁྲག་རིན་གྱི་ཞིང་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","དེ་ནས་ལུང་སྟོན་པ་ཡེ་རེམ་ཡཱ་ཡིས། ཡི་སི་ར་ཨེལ་གྱི་བུ་རྒྱུད་འགའ་ཤས་ཀྱིས་ཐག་གཅོད་བྱས་པའི་རིན་པ་སྟེ་དངུལ་སྒོར་སུམ་ཅུ་བླངས་ནས་ ");
INSERT INTO bod_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ཁོ་ཚོས་རྫ་མཁན་གྱི་ཞིང་ཞེས་ཟེར་བ་དེ་ཉོས། གཙོ་བོས་ང་ལ་དེ་ལྟར་བྱེད་པའི་བཀའ་གནང་བྱུང་ཞེས་པའི་གསུངས་དེ་བསྒྲུབས། ");
INSERT INTO bod_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ཡེ་ཤུ་སྤྱི་ཁྱབ་ཀྱི་དྲུང་དུ་བཞེངས་པའི་ཚེ་སྤྱི་ཁྱབ་ཀྱིས་ཁོང་ལ་“ཁྱོད་ནི་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ཡེ་ཤུས་ཁོ་ལ་“ཁྱེད་ཀྱིས་གསུངས་པ་ལྟར་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","བླ་ཆེན་གཙོ་བོ་དང་རྒན་པོ་རྣམས་ཀྱིས་ཁོང་ལ་ནག་ཉེས་བཙུགས་པའི་དུས་སུ་ཁོང་གིས་ལན་ཅིའང་མ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","དེ་ནས་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ཡིས་ཡེ་ཤུ་ལ་“ཁོ་ཚོས་ཁྱོད་ལ་ནག་ཉེས་ཅི་ཙམ་མང་བ་བཙུགས་པ་དེ་མི་ཐོས་སམ་”ཞེས་སྨྲས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ཁོང་གིས་ཁོ་ལ་ནག་ཉེས་གཅིག་ཙམ་ལའང་ལན་མ་གསུངས་པས་སྤྱི་ཁྱབ་ཡ་མཚན་ཆེན་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","དུས་ཆེན་དེར་སྤྱི་ཁྱབ་ཀྱིས་མི་ཚོགས་ཀྱི་འདོད་པ་ལྟར་བཙོན་པ་རེ་གློད་གྲོལ་གཏོང་བའི་ལུགས་སྲོལ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","དེའི་དུས་སུ་མིང་ངན་ཀུན་ཏུ་གྲགས་པའི་བཙོན་པ་ཞིག་པར་ཨབ་པཱ་ཞེས་ཟེར་མཁན་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ཁོ་ཚོ་འཛོམས་ནས་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ཡིས་ཁོ་རྣམས་ལ་“ཁྱོད་ཚོའི་ཕྱིར་ངས་སུ་གློད་ན་དགའ། པར་ཨབ་པཱ་དང༌། ཡང་ན་མཱ་ཤི་ཀ་ཞེས་ཟེར་བའི་ཡེ་ཤུ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","རྒྱུ་མཚན་ནི་ཡེ་ཤུ་རྩིས་སྤྲོད་མཁན་ཚོས་ཕྲག་དོག་གིས་ཁོང་བཏད་པ་ཡིན་པར་ཁོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","པི་ལ་ཏུ་ཁྲིམས་དཔོན་གྱི་ཁྲི་ལ་བསྡད་པའི་དུས་སུ་ཁོའི་བཟའ་ཟླ་ཡིས་ཁོ་ལ་“མདང་ནུབ་རྨི་ལམ་ལ་ཁོའི་དོན་དུ་སེམས་འཁྲུགས་ཆེན་པོ་མྱོང་བས། སྐྱོན་མེད་པའི་མི་དེ་ལ་འབྲེལ་བ་མ་བྱེད་”ཅེས་པའི་འཕྲིན་ཞིག་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","འོན་ཀྱང་བླ་ཆེན་གཙོ་བོ་དང་རྒན་མི་རྣམས་ཀྱིས་མི་ཚོགས་ལ་པར་ཨབ་པཱ་གློད་པ་དང་ཡེ་ཤུ་གསོད་རྒྱུར་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","སྤྱི་ཁྱབ་པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“མི་འདི་གཉིས་ལས་ཁྱོད་ཚོའི་ཕྱིར་ངས་སུ་གློད་པ་དགའ་”ཞེས་དྲིས་པས་ཁོ་རྣམས་ཀྱིས་“པར་ཨབ་པཱ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“བྱས་ན། མཱ་ཤི་ཀ་ཞེས་ཟེར་མཁན་ཡེ་ཤུ་དེ་ལ་ངས་གང་འདྲ་བྱེད་དགོས་”ཞེས་དྲིས་པས། ཁོ་ཚོ་ཚང་མས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","པི་ལ་ཏུས་“རྒྱུ་མཚན་གང་ཡིན། ཁོས་ལས་ངན་ག་རེ་བྱས་ཡོད་”ཅེས་དྲིས། འོན་ཀྱང་མི་ཚོགས་ཀྱིས་སྐད་ཤུགས་དེ་བས་ཆེན་པོས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","པི་ལ་ཏུས་གང་ཡང་མི་སྒྲུབ་པ་མ་ཟད་དེར་ཟིང་ཆ་ལང་གྲབས་ཡོད་པ་མཐོང་བས། མི་ཚོགས་ཀྱི་དྲུང་དུ་ཆུ་ཡིས་ལག་པ་བཀྲུས་ཏེ་ཁོ་ཚོར་“ང་ལ་མི་འདི་གསོད་པའི་འགན་མེད་པ་ཡིན་པས་ཁྱོད་ཚོས་དེའི་འགན་འཁུར་དགོས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","མི་ཐམས་ཅད་ཀྱིས་“ངེད་རྣམས་དང༌། ང་ཚོའི་བུ་རྒྱུད་ཀྱིས་དེའི་འགན་འཁུར་ཡོང་”ཞེས་བཤད་པས། ");
INSERT INTO bod_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","པི་ལ་ཏུས་ཁོ་ཚོའི་ཆེད་དུ་པར་ཨབ་པཱ་གློད་དེ། ཡེ་ཤུ་རྟ་ལྕག་གིས་རྡུང་དུ་བཅུག་ནས་རྒྱང་ཤིང་སྒང་ལ་གསོད་པའི་ཕྱིར་དམག་མི་ཚོར་རྩིས་སྤྲད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","དེ་ནས་སྤྱི་ཁྱབ་ཀྱི་དམག་མི་ཚོས་ཡེ་ཤུ་སྤྱི་ཁྱབ་ཀྱི་ཕོ་བྲང་གི་ནང་ལ་ཁྲིད་དེ་དམག་ཁག་ཐམས་ཅད་ཁོང་གི་མདུན་དུ་བསྡུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ཁོང་གི་ན་བཟའ་ཕུད་དེ་ཕྱི་གོས་དམར་པོ་ཞིག་བསྐོན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ཚེར་མས་སླས་པའི་ཅོད་པན་ཞིག་ཁོང་གི་དབུ་ལ་བསྐོན་པ་དང༌། ཕྱག་གཡས་པ་ལ་དབྱུག་པ་ཞིག་བཞག་ནས་ཁོང་གི་མདུན་དུ་པུས་མོ་སར་བཙུགས་ནས་“ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ལ་ཕྱག་འཚལ་ལོ་”ཞེས་སྨྲས་ཏེ་ཁོང་ལ་བརྙས་བཅོས་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ཁོ་ཚོས་ཁོང་ལ་མཆིལ་མ་གཏོར་ཞིང༌། དབུ་དབྱུག་པས་ཡང་ཡང་བརྡུངས། ");
INSERT INTO bod_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ཁོང་ལ་བརྙས་བཅོས་བྱས་ཚར་བའི་རྗེས་སུ་ཕྱི་གོས་དམར་པོ་དེ་ཕུད་ཅིང༌། ཁོང་ལ་རང་གི་ན་བཟའ་གྱོན་དུ་བཅུག དེ་ནས་རྒྱང་ཤིང་སྟེང་ལ་གཟེར་བརྒྱབ་སྟེ་གསོད་པའི་ཕྱིར་ཕར་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ཁོང་རྣམས་ཕྱི་ལ་ཕེབས་སྐབས། སི་མོན་ཞེས་བྱ་བ་ནི་སེ་རེ་ནཱ་ཞེས་པའི་གྲོང་ཁྱེར་གྱི་མི་ཞིག་དང་ཕྲད་ནས། ཁོང་གི་རྒྱང་ཤིང་འཁུར་དུ་འཇུག་ཕྱིར་བཙན་གྱིས་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ཡང་གོལ་གོ་ཐ་ཞེས་པ་སྟེ་མགོ་རུས་ཀྱི་ས་ཆ་ཟེར་བའི་ས་དེར་སླེབས་པའི་ཚེ། ");
INSERT INTO bod_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","དམག་མི་ཚོས་ཁོང་ལ་སྨན་རྩྭ་ཁ་ཏིག་འདྲེས་པའི་རྒུན་ཆང་དྲངས། དེ་མྱངས་ནས་བཞེས་པར་མ་དགྱེས། ");
INSERT INTO bod_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","རྒྱང་ཤིང་སྟེང་དུ་ཁོང་གི་ཕྱག་ཞབས་གཉིས་ལ་གཟེར་བརྒྱབ་རྗེས། དམག་མིས་རྒྱན་བརྒྱབ་ནས་ཁོང་གི་ན་བཟའ་བགོ་བཤའ་བྱས། ");
INSERT INTO bod_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","དེ་ནས་ས་ཆ་དེར་བསྡད་ནས་ཁོང་བསྲུངས། ");
INSERT INTO bod_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ཁོང་གི་ཉེས་ཚིག་ལ་འདི་ནི་ཡེ་ཤུ་སྟེ་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཡིན་ཞེས་བྲིས་ནས་ཁོང་གི་དབུའི་སྟེང་ལ་སྦྱར། ");
INSERT INTO bod_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ཁོང་དང་མཉམ་དུ་ཇག་པ་གཉིས་ནས་གཅིག་ཁོང་གི་གཡས་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་དང༌། གཅིག་ཁོང་གི་གཡོན་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་སྟེང་ལ་གཟེར་བརྒྱབ་ནས་བཀལ། ");
INSERT INTO bod_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","གནས་དེ་བརྒྱུད་ནས་འགྲོ་བའི་མི་རྣམས་ཀྱིས་ཁོང་ལ་དམའ་འབེབས་བྱས་ནས་མགོ་གཡུག་བཞིན་དུ་ ");
INSERT INTO bod_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ཀྱེ། མཆོད་ཁང་ཆེན་མོ་བཤིག་ནས་ཉིན་གསུམ་གྱི་ནང་སླར་རྩིག་མཁན་ཁྱོད། རང་ཉིད་སྐྱོབས་ཤིག དཀོན་མཆོག་གི་སྲས་ཡིན་ན་རྒྱང་ཤིང་སྟེང་ནས་མར་བོབས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","དེ་ལྟར་བླ་ཆེན་གཙོ་བོ་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང༌། རྒན་པོ་རྣམས་ཀྱིས་ཀྱང་ཁོང་ལ་འཕྱ་དམོད་བྱེད་དེ་ ");
INSERT INTO bod_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ཁོས་གཞན་རྣམས་བསྐྱབས་ཀྱང༌། རང་ཉིད་སྐྱོབ་མི་ཐུབ། ཁོ་ནི་ཡི་སི་ར་ཨེལ་ཡུལ་གྱི་རྒྱལ་པོ་ཡིན། ད་ལྟ་ཁོ་རྒྱང་ཤིང་སྟེང་ནས་མར་འབབ་ན། ང་ཚོས་ཁོ་ལ་དད་པ་བྱེད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ཁོས་དཀོན་མཆོག་ལ་བློ་གཏོད་བྱེད་དེ། ང་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་ཞེས་ཟེར་བས། དཀོན་མཆོག་གིས་ཁོ་ལ་ཐུགས་མཉེས་ན། ད་ལྟ་ཁོ་ཐར་བར་མཛོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ཁོང་དང་མཉམ་དུ་རྒྱང་ཤིང་ལ་གཟེར་བརྒྱབ་པའི་ཇག་པ་རྣམས་ཀྱིས་ཀྱང་ཁོང་ལ་དེ་བཞིན་དུ་སྨད་ར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ཉི་མ་བསྒྲིབས་ཏེ་ཉིན་གུང་ནས་ཆུ་ཚོད་གསུམ་པའི་བར་དུ་ལུང་པ་དེ་ཡོངས་སུ་མུན་པས་ཁེངས། ");
INSERT INTO bod_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ཆུ་ཚོད་གསུམ་པ་ཙམ་ལ་ཡེ་ཤུས་གསུང་ཆེན་པོས་“ཨེ་ལི། ཨེ་ལི། ལ་མ་ཤ་བག་ཐ་ནི་”ཞེས་གསུངས་པའི་དོན་ནི་ངའི་དཀོན་མཆོག ངའི་དཀོན་མཆོག ཁྱེད་ཀྱིས་ང་དོར་དགོས་དོན་ཅི་ཡིན་ཞེས་པའོ། ");
INSERT INTO bod_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ཉེ་འགྲམ་ལ་ཡོད་པའི་མི་ཁ་ཤས་ཀྱིས་དེ་ཐོས་ནས་“མི་འདིས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་འབོད་ཀྱི་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","འཕྲལ་དུ་ཁོ་ཚོའི་ནང་ནས་མི་ཞིག་གིས་ཕར་བརྒྱུགས་ཏེ་རྒུན་ཆང་སྐྱུར་མོའི་ནང་སྲིང་བལ་སྦངས་ནས་དབྱུག་པའི་རྩེར་བཀོན་ཏེ་ཡེ་ཤུས་བཞེས་ཕྱིར་དྲངས། ");
INSERT INTO bod_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","གཞན་རྣམས་ཀྱིས་“སྒུག་ཅིག ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཁོ་སྐྱོབ་པའི་ཕྱིར་ཕེབས་མ་ཕེབས་བལྟའོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ཡེ་ཤུས་ཡང་བསྐྱར་གསུངས་ཆེན་པོ་ཞིག་བཀྱོན་ནས་སྐུ་སྲོག་བློས་བཏང་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","དེའི་སྐབས་མཆོད་ཁང་ཆེན་མོའི་ནང་གི་ཡོལ་བ་དེ་སྟེང་ནས་འོག་བར་དུམ་བུ་གཉིས་སུ་རལ། ས་གཡོས་པ་དང་བྲག་གས། ");
INSERT INTO bod_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","དུར་ཁང་གི་སྒོ་ཕྱེ་ནས་དཀོན་མཆོག་གི་མི་འཆི་བ་རྣམས་ལས་མང་པོ་གསོན་པོར་ལང་བར་གྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ཡེ་ཤུ་སྐུ་གསོན་པོར་བཞེངས་པའི་རྗེས་སུ་ཁོ་ཚོ་དུར་ཁང་ནས་ཐོན་ཞིང༌། གནས་མཆོག་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིན་ནས་མི་མང་པོས་མཐོང་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","དམག་མིའི་བརྒྱ་དཔོན་དང༌། ཁོ་དང་མཉམ་དུ་ཡེ་ཤུ་སྲུང་མཁན་རྣམས་ཀྱིས་ས་ཡོམ་དང་གང་བྱུང་བ་ཐམས་ཅད་མཐོང་ནས་ཤིན་ཏུ་འཇིགས་ཏེ་“མི་འདི་དངོས་གནས་དཀོན་མཆོག་གི་སྲས་ཡིན་ནོ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ཡེ་ཤུ་ལ་ཞབས་ཕྱི་ཞུས་ཤིང་ག་ལིལ་ཡུལ་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་པའི་བུད་མེད་མང་པོ་ཞིག་དེར་ཡོད་དེ། རྒྱང་རིང་ནས་བལྟས། ");
INSERT INTO bod_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ཁོ་ཚོའི་ནང་ནས་མག་དལ་གྲོང་གསེབ་ནས་ཡིན་པའི་མིར་ཡམ་དང༌། ཡ་ཀོབ་དང་ཡོ་སེབ་ཀྱི་ཨ་མ་མིར་ཡམ་དང༌། ཟེ་བད་ཡཱ་ཞེས་པའི་བུའི་ཨ་མ་ཡང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","དེ་ནས་དགོང་མོ་ཟིན་པའི་ཚེ་ཡེ་ཤུའི་སློབ་མར་གྱུར་བ་གྲོང་ཁྱེར་ཨ་རི་མ་ཐཱའི་ཕྱུག་པོ་ཡོ་སེབ་ཟེར་མཁན་ཞིག་དེར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","མི་འདི་པི་ལ་ཏུའི་སར་ཕྱིན་ཏེ་ཡེ་ཤུའི་སྐུ་ཕུང་གནང་རོགས་ཞུས་པ་དང༌། པི་ལ་ཏུ་ཡིས་ཡོ་སེབ་ལ་སྤྲོད་རྒྱུའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ཡོ་སེབ་ཀྱིས་ཡེ་ཤུའི་སྐུ་ཕུང་ལེན་པ་དང༌། རས་སྤུས་ལེགས་གཙང་མ་ཤིག་གིས་སྒྲིལ་ནས། ");
INSERT INTO bod_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","བྲག་ལ་བཟོས་པའི་རང་གི་དུར་ཁང་གསར་པར་བཞག་ནས། རྡོ་ཆེན་པོ་ཞིག་བསྒྲིལ་ཏེ་དུར་ཁང་གི་ཁ་བཀག་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ཡང་མིར་ཡམ་མག་དལ་མ་དང༌། མིར་ཡམ་གཞན་ཞིག་དུར་ཁང་ལ་ཁ་གཏད་ནས་དེར་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","དེའི་སང་ཉིན་གྲ་སྒྲིག་གི་ཉིན་མོའི་རྗེས་ཀྱི་ཉིན་མོར། བླ་ཆེན་གཙོ་བོ་དང་ཕཱ་རུ་ཤི་པ་རྣམས་པི་ལ་ཏུའི་དྲུང་དུ་འདུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ཁོ་ལ་“སྐུ་ཞབས་ལགས། ཁོ་གསོན་པའི་དུས་སུ་མགོ་སྐོར་གཏོང་མཁན་དེས་ཉི་མ་གསུམ་གྱི་རྗེས་སུ་ང་ནི་འཆི་བ་ནས་གསོན་པོར་ལང་བར་འགྱུར་ཞེས་ཟེར་བ་དེ་ང་ཚོས་དྲན་པས། ");
INSERT INTO bod_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ཉིན་གསུམ་པའི་བར་དུ་དུར་ཁང་སྲུང་དགོས་པའི་བཀའ་གཏོང་རོགས། དེ་མིན་ཁོའི་ཉེ་གནས་རྣམས་ཡོང་ནས་ཁོའི་རོ་ཕར་འཁྱེར་ནས་མི་རྣམས་ལ། ཁོང་འཆི་བ་ནས་སླར་གསོན་པོར་གྱུར་ཞེས་ཟེར་ཡོང་ཞེས་སྨྲས་པས། གཡོ་རྒྱུ་སྔོན་མ་ལས་མཐའ་མ་ངན་པར་འགྱུར་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“སྲུང་དམག་རྣམས་ཁྱོད་རྣམས་ལ་ཡོད། སོང་ལ་གང་ཐུབ་པ་དམ་པོར་སྲུང་ཞིག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","སྲུང་དམག་འཁྲིད་དེ་ཁོ་ཚོས་དུར་ཁང་གི་ཁ་རྡོ་རྒྱ་ཡིས་བཏབ་ནས་སྲུང་དམག་རྣམས་སྲུང་དུ་བཅུག་གོ ། ");
INSERT INTO bod_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ངལ་གསོ་བའི་ཉིན་གྱི་རྗེས་སུ་བདུན་ཕྲག་གི་ཉིན་དང་པོའི་ཉི་མ་ཤར་ཙམ་ལ། མིར་ཡམ་མག་དལ་མ་དང༌། མིར་ཡམ་གཞན་དེ་དུར་ཁང་ལ་ལྟ་བར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","གློ་བུར་དུ་ས་ཡོམ་ཆེན་པོ་བྱུང་སྟེ། དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་ཞིང་ཁམས་ནས་བབས་པ་དང༌། དུར་ཁང་གི་ཁ་རྡོ་ཕར་བསྒྲིལ་ནས་དེའི་སྟེང་ལ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ཁོང་གི་གཟུགས་ནི་གློག་འོད་ལྟར་འཕྲོས་ཤིང༌། ན་བཟའ་གངས་ལྟར་དཀར། ");
INSERT INTO bod_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","སྲུང་དམག་རྣམས་ཁོང་ལ་འཇིགས་ནས་འདར་ཏེ་ཤི་བ་ལྟར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ཕོ་ཉ་དེས་བུད་མེད་རྣམས་ལ་“མ་འཇིགས་ཤིག ཁྱོད་ཚོས་རྒྱང་ཤིང་སྟེང་བཀྲོངས་པའི་ཡེ་ཤུ་འཚོལ་བཞིན་པ་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ཁོང་གིས་སྔར་གསུངས་པ་ལྟར། ཁོང་སྐུ་གསོན་པོར་བཞེངས་སུ་གྱུར་བས་འདིར་མེད། ཁོང་བཞག་སར་ལྟ་རུ་ཤོག ");
INSERT INTO bod_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","མགྱོགས་པོ་སོང་ལ་ཁོང་གི་ཉེ་གནས་རྣམས་ལ། ཁོང་འཆི་བ་ནས་གསོན་པོར་བཞེངས་སུ་གྱུར་ཞིང༌། ཁྱེད་ཚོའི་སྔོན་ལ་ག་ལིལ་ཡུལ་དུ་ཕེབས་ཏེ་དེར་ཁོང་མཇལ་ཡོང་ཞེས་སྨྲོས་ཤིག ད་ངས་ཁྱོད་ཚོར་བཤད་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","བུད་མེད་དེ་རྣམས་འཇིགས་ཀྱང་དགའ་སྤྲོ་ཆེན་པོའི་ངང་ནས་མགྱོགས་པོར་དུར་ཁང་ནས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་འཕྲིན་སྐྱེལ་བར་བརྒྱུགས། ");
INSERT INTO bod_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","འཕྲལ་དུ་ཡེ་ཤུས་ཁོ་རྣམས་ཐུག་སྟེ་“བདེ་བར་གྱུར་ཅིག་”ཅེས་གསུངས། ཁོ་རྣམས་ཁོང་གི་མདུན་དུ་ཡོང་ནས་ཞབས་ལ་བཟུང་སྟེ་ཕྱག་བཙལ། ");
INSERT INTO bod_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","དེ་ནས་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“མ་འཇིགས་ཤིག ད་སོང་ལ། ངའི་སྤུན་ཟླ་རྣམས་ལ། ག་ལིལ་ཡུལ་དུ་སོང་ཞིང༌། དེར་ང་མཐོང་བར་འགྱུར་ཞེས་འཕྲིན་སྐྱེལ་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","བུད་མེད་རྣམས་ཕར་འགྲོ་དུས་སྲུང་དམག་རྣམས་ནང་ནས་ཁ་ཤས་གྲོང་ཁྱེར་དུ་ཡོང་སྟེ་གང་བྱུང་བ་ཐམས་ཅད་བླ་ཆེན་གཙོ་བོ་རྣམས་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","རྒན་པོ་རྣམས་དང་འཛོམས་ནས་གྲོས་བསྡུར་བྱས་ཏེ། དམག་མི་རྣམས་ལ་ལྐོག་རྔན་ཆེན་པོ་ཞིག་སྟེར་ནས་ཁོ་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ཁྱོད་ཚོས་མི་ཚོར། ཁོའི་ཉེ་གནས་མཚན་མོར་ཡོང་ཞིང་ང་ཚོ་གཉིད་ཁུག་པའི་ཚེ་ཁོའི་རོ་བརྐུས་ཞེས་ཟེར་དགོས། ");
INSERT INTO bod_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","སྤྱི་ཁྱབ་ཀྱིས་གཏམ་དེ་ཐོས་ན། ང་ཚོས་ཁོ་ལ་སྐད་ཆ་བཤད་ནས་ཁྱེད་ཚོའི་རྙོག་དྲ་སེལ་ཡོང་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","དམག་མི་རྣམས་ཀྱིས་དངུལ་དེ་བླངས་ནས་གང་བཤད་པ་ལྟར་བྱས། གཏམ་འདི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་དེ་རིང་གི་བར་དུ་དར་ནས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ཉེ་གནས་བཅུ་གཅིག་པོ་ཡེ་ཤུས་གསུངས་པའི་ག་ལིལ་ཡུལ་གྱི་རི་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ཁོ་ཚོས་ཁོང་མཐོང་བའི་ཚེ་ཁོང་ལ་བསྙེན་བཀུར་བྱས། འོན་ཀྱང་ཁ་ཤས་ཐེ་ཚོམ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ཡེ་ཤུ་ཁོ་ཚོའི་རྩར་ཕེབས་ནས་“དཀོན་མཆོག་གི་ཞིང་ཁམས་དང་འཇིག་རྟེན་གྱི་དབང་ཆ་ཀུན་ང་ལ་གཏད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","དེའི་ཕྱིར། སོང་ལ། མི་རིགས་ཐམས་ཅད་སློབ་མར་འཇུག ཡབ་དང་སྲས། དམ་པའི་ཐུགས་ཉིད་ཀྱི་མཚན་གྱི་ཐོག་ནས་ཁོ་ཚོར་ཁྲུས་གསོལ་བྱོས་ལ། ");
INSERT INTO bod_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ངས་ཁྱེད་ཚོར་བཀའ་བསྒོས་པ་ཐམས་ཅད་སྲུང་དགོས་པར་སློབས་ཤིག ཉོན་དང༌། ང་ནི་ནམ་ཡང་ཁྱེད་ཚོ་དང་མཉམ་དུ་གནས། དུས་ཀྱི་མཐའ་མའི་བར་དུའང་ཡོད་དོ་”ཞེས་གསུངས་སོ། །");
INSERT INTO bod_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","དཀོན་མཆོག་གི་སྲས་ཡེ་ཤུ་མཱ་ཤི་ཀའི་འཕྲིན་བཟང་གི་ཐོག་མ་ནི། ");
INSERT INTO bod_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་བྲིས་པའི་མདོའི་ནང་དཀོན་མཆོག་གིས་འདི་ལྟར་གསུངས། ལྟོས་ཤིག ང་ཡི་ཕོ་ཉ་ཁྱེད་ཀྱི་མདུན་དུ་གཏོང༌། ། དེ་ཡིས་ཁྱེད་ཀྱི་ལམ་ནི་བསལ་བར་བྱ། ། ");
INSERT INTO bod_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","དབེན་སྟོང་ཡུལ་ནང་གྲགས་པའི་འབོད་སྒྲ་ཡིས། ། གཙོ་བོའི་ཆེད་དུ་ཕེབས་ལམ་གྲ་སྒྲིག་བྱོས། ། ལམ་བུ་དེ་ནི་བདེ་བར་བཟོས་ཤིག་ཨང༌། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","དེའི་ཕྱིར་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་དབེན་སྟོང་ལ་བཞུགས་ཏེ། མི་རྣམས་ལ་ཁྲུས་གསོལ་གནང་ནས། སྡིག་ཉེས་སེལ་བའི་ཆེད་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་རྟགས་སུ་ཁྲུས་གསོལ་ལེན་དགོས་པར་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ཡ་ཧུ་དཱ་ཡུལ་དང་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་གྱི་མི་ཤིན་ཏུ་མང་པོ་ཡོ་ཧ་ནན་གྱི་དྲུང་དུ་འགྲོ་བཞིན་ཡོད་པས། ཁོ་ཚོས་རང་གི་ལས་ངན་ཁས་བླངས་པ་དང་ཡོར་དན་གཙང་པོ་ལ་ཁོང་གིས་ཁོ་ཚོར་ཁྲུས་གསོལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ཡོ་ཧ་ནན་གྱིས་རྔ་མོང་གི་སྤུ་ཡི་གོས་གྱོན་པ་དང་རྐེད་པ་ལ་ཀོ་བའི་སྐེ་རགས་བཅིངས། ཟས་ལ་འབུ་ཆ་ག་པ་དང་ཤིང་ནགས་ཀྱི་སྦྲང་རྩི་བཟས། ");
INSERT INTO bod_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ཡོ་ཧ་ནན་གྱིས་“ངའི་རྗེས་ལ་ང་ལས་དབང་ཆེ་བ་ཞིག་ཕེབས་ཡོང་བར་ངེས་ཏེ། ང་བསྒུར་ནས་ཁོང་གི་ལྷམ་སྒྲོག་ཀྱང་འགྲོལ་བར་མི་འོས། ");
INSERT INTO bod_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ངས་ཁྱེད་ཚོར་ཆུ་ཡིས་ཁྲུས་གསོལ་བྱས་པ་ཡིན། འོན་ཀྱང་ཁོང་གིས་ཁྱེད་ཚོར་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྲུས་གསོལ་གནང་བར་འགྱུར་རོ་”ཞེས་ཆོས་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","དེའི་དུས་སུ་ཡེ་ཤུ་ག་ལིལ་ཡུལ་གྱི་ན་ཙ་རེལ་གྲོང་ཚོ་ནས་ཕེབས་ཤིང༌། ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱིས་ཡེ་ཤུ་ཡོར་དན་གཙང་པོའི་ནང་ཁྲུས་གསོལ་གནང་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ཡེ་ཤུ་ཆུ་ནས་ཡར་ཕེབས་སྐབས་ནམ་མཁའ་རལ་ཏེ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཕུག་རོན་ལྟར་རང་གི་སྟེང་ལ་བབས་པ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ཡང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་“ཁྱེད་ནི་ངའི་གཅེས་པའི་བུ་ཡིན། ང་རང་ཁྱེད་ལ་ཤིན་ཏུ་དགའོ་” ཞེས་པའི་གསུང་སྐད་གཅིག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","དེ་ལྟར་གསུངས་མ་ཐག་ཏུ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་བསྐུལ་ཏེ་ཡེ་ཤུ་དབེན་སྟོང་ལ་མངགས། ");
INSERT INTO bod_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ཉིན་ཞག་བཞི་བཅུའི་རིང་བདུད་སཱ་ཏན་གྱིས་དབེན་སྟོང་དུ་ཁོང་ལ་ཉམས་ཚོད་བླངས། ཁོང་གཅན་གཟན་ཁྲོད་དུ་བཞུགས་ཤིང༌། དཀོན་མཆོག་གི་ཕོ་ཉས་ཁོང་ལ་ཞབས་ཕྱི་ཞུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་བཙོན་དུ་བཅུག་པའི་རྗེས་སུ་ཡེ་ཤུ་ག་ལིལ་ཡུལ་དུ་ཕེབས་ནས། དཀོན་མཆོག་གི་འཕྲིན་བཟང་ཁྱབ་བསྒྲགས་མཛད། ");
INSERT INTO bod_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ཁོང་གིས་“ད་དུས་ལ་བབས་འདུག དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འཐོན་ལ་ཉེ་བར་སླེབས་པས། ཁྱེད་ཚོས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་ཏེ་འཕྲིན་བཟང་ལ་དད་པ་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","དེ་ནས་ཡེ་ཤུ་ག་ལིལ་ཡུལ་གྱི་མཚོ་འགྲམ་བརྒྱུད་ནས་ཕེབས་དུས། སི་མོན་དང་ཁོང་གི་གཅུང་པོ་ཨན་དྲི་ཡཱ་ཞེས་བྱ་བའི་ཉ་པ་གཉིས་ཀྱིས་མཚོ་ནང་དུ་དྲ་རྒྱ་འཕེན་བཞིན་པ་གཟིགས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ཡེ་ཤུས་ཁོ་ཚོ་ལ་“ངའི་རྗེས་སུ་ཤོག ཁྱེད་ཀྱིས་ད་ལྟ་ཉ་འཚོལ་བ་ལྟར་རྗེས་མ་ངས་ཁྱེད་ཚོ་མི་རྣམས་འཚོལ་དུ་འཇུག་”ཅེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ཁོང་གཉིས་ཀྱིས་རང་གི་དྲ་རྒྱ་བཞག་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ཡེ་ཤུ་ཕར་ཙམ་ཕེབས་སྐབས་ཁོང་གིས་ཟེ་བད་ཡཱ་ཟེར་མཁན་དེའི་བུ་ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་གཉིས་ཀྱིས་གྲུའི་ནང་ལ་དྲ་རྒྱ་བཟོ་བཅོས་རྒྱག་བཞིན་པ་གཟིགས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ཡེ་ཤུས་ལམ་སེང་ཁོ་ཚོར་“ཚུར་ཤོག་”ཅེས་གསུངས་པས། ཁོ་གཉིས་ཀྱིས་རང་གི་ཕ་ཟེ་བད་ཡཱ་དང་གླ་པ་རྣམས་གྲུ་ལ་བཞག་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","དེ་ནས་ཁོང་ཚོ་གྲོང་ཁྱེར་ཀ་ཕར་ན་ཧུམ་དུ་བྱོན་ནས་ངལ་གསོའི་ཉིན་མོ་སླེབས་མ་ཐག་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དུ་ཕེབས་ཏེ། ཆོས་བསྟན་གནང་བ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ཁོང་གིས་ཁོ་ཚོར་ཆོས་སྟོན་སྟངས་ནི་ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་དང་མི་འདྲ་སྟེ། དབང་ལྡན་ཞིག་གིས་གསུངས་པ་དང་འདྲ་བར་འདུག་པས། དེ་ཐོས་པ་ཐམས་ཅད་ཡ་མཚན་ཆེན་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","དེའི་སྐབས་གདོན་འདྲེ་མི་གཙང་བ་ཡིས་ཟིན་པའི་མི་ཞིག་འདུ་ཁང་ནང་ལ་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","དེས་སྐད་ཆེན་པོས་“ཀྱེ། ན་ཙ་རེལ་པ་ཡེ་ཤུ། ང་ཚོ་ཁྱེད་དང་འབྲེལ་བ་གང་ཡོད། ཁྱེད་ཀྱིས་ང་ཚོ་མེད་པ་བཟོ་བར་ཕེབས་སམ། ཁྱེད་སུ་ཡིན་པ་ངས་ཤེས་ཀྱི་ཡོད། ཁྱེད་ནི་དཀོན་མཆོག་གི་སྐྱེས་བུ་དམ་པ་དེ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","འོན་ཀྱང་ཡེ་ཤུས་གདོན་འདྲེ་དེར་བཀའ་གནང་ནས་“ཁ་རོག་སྡོད། མི་དེའི་ལུས་ནས་ཐོན་ཅིག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","མི་དེ་གཟའ་ཕོག་པ་ལྟར་ས་ལ་འགྱེལ་ནས་ཁོས་སྐད་ངན་ཆེན་པོ་བཏོན་ཞིང་གདོན་འདྲེ་མི་གཙང་བ་དེ་མི་དེའི་ལུས་ནས་ཕྱིར་ཐོན། ");
INSERT INTO bod_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","མི་ཐམས་ཅད་ཧ་ལས་ཏེ་ཕན་ཚུན་གཅིག་གིས་གཅིག་ལ་སྐད་ཆ་དྲིས་པར་“འདི་ཅི་ཡིན། འདི་བསྟན་པ་གསར་པ་ཡིན་ནམ། ཁོང་གིས་དབང་ཆ་ཆེན་པོས་གདོན་འདྲེ་མི་གཙང་བ་ལ་ཡང་བཀའ་གནང་སྟེ། གདོན་འདྲེས་ཀྱང་ཁོང་གི་བཀའ་ལ་ཉན་པར་བྱེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","དེ་མ་ཐག་ཏུ་ཁོང་གི་སྙན་གྲགས་ག་ལིལ་གྱི་ས་ཕྱོགས་གང་སར་ཁྱབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ཁོང་ཚོ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནས་ཐོན་མ་ཐག་ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་གཉིས་མཉམ་དུ་སི་མོན་དང་ཨན་དྲི་ཡཱ་ཡི་ཁྱིམ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","དེའི་དུས་སུ་སི་མོན་གྱི་བཟའ་ཟླའི་ཨ་མ་ཚ་བ་རྒྱས་ཏེ་ཉལ་ཁྲིའི་སྟེང་དུ་ཉལ་ཡོད། ཡེ་ཤུ་ཕེབས་སྐབས་ཁྱིམ་མི་རྣམས་ཀྱིས་ཁོ་མོའི་གནས་ཚུལ་ཁོང་ལ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ཡེ་ཤུ་ཁོ་མོའི་མདུན་དུ་ཕེབས་ཏེ་ལག་པ་ནས་འཇུས་ཤིང་ཡར་བསྐྱོར་ཏེ་ལངས་སུ་བཅུག་པ་དང༌། ཚ་བ་འཇགས་ཏེ་ཁོ་མོས་ཁོང་རྣམས་ལ་ཞབས་ཕྱི་ཞུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","དེ་ནས་ཉི་མ་བཞུད་དེ་ས་མ་རུབ་ཙམ་ལ། མི་ཚོས་ནད་པ་དང་གདོན་འདྲེས་ཟིན་པའི་མི་རྣམས་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","གྲོང་ཁྱེར་གྱི་མི་ཐམས་ཅད་སྒོའི་འགྲམ་དུ་འཛོམས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ཡེ་ཤུས་དཀོན་མཆོག་གི་དབང་གི་སྒོ་ནས་ནད་རིགས་མི་འདྲ་བ་མང་པོ་སེལ་གནང་བ་མ་ཟད། གདོན་འདྲེ་མང་པོ་བསྐྲད་དེ། གདོན་དེ་ཚོ་སྐད་ཆ་ལབ་ཏུ་མ་བཅུག གང་ཡིན་ཟེར་ན། གདོན་འདྲེས་ཁོང་ངོ་ཤེས་ཀྱི་ཡོད་པས་རེད། ");
INSERT INTO bod_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","དེའི་སང་ཉིན་ནམ་མ་ལངས་པའི་སྔོན་དུ་ཡེ་ཤུ་ཡར་བཞེངས་ཏེ་དབེན་གནས་ཤིག་ཏུ་ཕེབས་ནས་དེར་སྨོན་ལམ་བསྐྱོན། ");
INSERT INTO bod_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","སི་མོན་དང་ཁོང་གི་རོགས་པ་རྣམས་ཀྱིས་ཡེ་ཤུ་བཙལ་ནས། ");
INSERT INTO bod_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ཁོང་དང་མཇལ་རྗེས་“མི་ཚང་མས་ཁྱེད་རང་འཚོལ་བཞིན་འདུག་”ཅེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ཁོང་གིས་“ང་ཚོ་ཉེ་འཁོར་གྱི་གྲོང་སྡེ་ལ་འགྲོ་དགོས། ངས་དེ་ཚོ་ལ་ཡང་ཆོས་བཤད་པར་བྱ། ང་དོན་འདིའི་ཆེད་དུ་ཡོང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","དེའི་ཕྱིར་ཁོང་ག་ལིལ་ཡུལ་ཡོངས་ཀྱི་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དུ་ཕེབས་ནས་ཆོས་གསུངས་ཤིང༌། གདོན་འདྲེ་རྣམས་ཕར་བསྐྲད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","དེའི་ཚེ་མཛེ་ནད་ཅན་ཅིག་ཁོང་གི་དྲུང་དུ་ཡོང་ནས་པུས་མོ་སར་བཙུགས་ཏེ་“གལ་ཏེ་ཁྱེད་ཐུགས་མཉེས་པ་ཡིན་ན་ཁྱེད་ཀྱིས་ང་རང་གི་མཛེ་ནད་དག་པར་མཛད་ཐུབ་བོ་”ཞེས་ཞུ་བ་ཆེན་པོ་ཕུལ་བས། ");
INSERT INTO bod_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","ཡེ་ཤུ་སྙིང་རྗེ་སྐྱེས་ཏེ་ཕྱག་བརྐྱངས་ཤིང་མི་དེར་རེག་ནས་“ང་དེ་བཞིན་དུ་བྱེད་འདོད་ཡོད། དག་པར་གྱུར་ཅིག་”ཅེས་གསུངས་མ་ཐག་མི་དེའི་མཛེ་ནད་དག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ཁོང་གིས་ནན་ཏན་གྱིས་མི་དེར་“ལྟོས་དང༌། ཁྱོད་ཀྱིས་མི་གཞན་ལ་ཅི་ཡང་ལབ་པར་མ་བྱོས་ཤིག སོང་ལ་རང་གི་ལུས་ཡ་ཧུ་དཱ་པའི་བླ་མར་སྟོན་དང༌། ཁོ་རྣམས་ལ་བདེན་དཔང་བྱེད་པའི་ཕྱིར་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་བཀའ་གནང་ཡོད་པ་བཞིན་མཆོད་པ་ཕུལ་ཅིག་”ཅེས་བཀའ་གནང་སྟེ་མི་དེ་ལམ་སེང་ཕྱིར་བཏོན། ");
INSERT INTO bod_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","འོན་ཀྱང་མི་དེ་ཕྱི་ལ་སོང་ནས་གཏམ་མང་པོ་བཤད་ཅིང་གནས་ཚུལ་འདི་ཁྱབ་བསྒྲགས་བྱས་པས། དེའི་རྗེས་སུ་ཡེ་ཤུ་གྲོང་ཁྱེར་གང་ལ་ཡང་མངོན་སུམ་དུ་ཕེབས་མ་ཐུབ་པར་ཕྱི་རོལ་གྱི་དབེན་གནས་རྣམས་སུ་བཞུགས། ཡིན་ན་ཡང་མི་རྣམས་ཕྱོགས་བཞི་མཚམས་བརྒྱད་ནས་ཡོང་སྟེ་ཁོང་གི་དྲུང་དུ་འདུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","དེ་ནས་ཉི་མ་འགའ་ཤས་ཕྱིན་པའི་རྗེས་ལ་ཡེ་ཤུ་ཡང་བསྐྱར་གྲོང་ཁྱེར་ཀ་ཕར་ན་ཧུམ་ལ་ཕེབས་ནས་ཁོང་ཁང་པའི་ནང་དུ་བཞུགས་ཡོད་པའི་གཏམ་གྲགས་པ་ཙམ་གྱིས། ");
INSERT INTO bod_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","མི་མང་པོ་སྒོའི་འགྲམ་དུ་འཛོམས་ཏེ་ས་ཆ་སྟོང་པའང་མེད། ཁོང་གིས་དཀོན་མཆོག་གི་བཀའ་བསྒྲགས་གནང་སྐབས་མི་འགའ་ཤས་ཡོང་ཞིང༌། དེའི་ནང་ནས་མི་བཞི་ཡིས་གོམ་པ་སྤོ་མི་ཐུབ་པའི་ནད་པ་གཅིག་ཁུར་ནས་ཁོང་གི་དྲུང་དུ་འོངས། ");
INSERT INTO bod_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","འོན་ཀྱང་མི་ཚོགས་མང་བས་ཁོ་ཚོ་ཁོང་གི་དྲུང་དུ་མ་ཐར་སྟབས། ཁང་པའི་ཐོག་ཁ་བཤུས་ཏེ་ཡེ་ཤུ་བཞུགས་སའི་སྒང་ལ་ཨི་ཁུང་ཆེན་པོ་ཞིག་ཕུག་ནས་ནད་པ་དང་ཉལ་ཁྲི་མཉམ་དུ་མར་ཕབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ཡེ་ཤུས་ཁོ་ཚོའི་དད་སེམས་མཁྱེན་ནས་ནད་པ་དེ་ལ་“བུ། ཁྱོད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","དེར་ཡོད་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་འགའ་ཞིག་གི་བསམ་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","མི་འདིས་འདི་ལྟར་བཤད་པ་གང་ཡིན་ནམ། དེས་དཀོན་མཆོག་ལ་སྐུར་བ་འདེབས་པ་རང་རེད། དཀོན་མཆོག་གཅིག་པོས་མ་གཏོགས་གཞན་སུས་སྡིག་ཉེས་སེལ་ཐུབ་བསམས། ");
INSERT INTO bod_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","དེ་མ་ཐག་ཏུ་ཡེ་ཤུའི་ཐུགས་ལ་ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་འདི་ལྟར་གསུངས་“ཁྱོད་ཚོས་བསམ་བློ་འདི་ལྟར་གཏོང་དགོས་པའི་རྒྱུ་མཚན་གང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ནད་པ་དེར་ཁྱོད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་ཟེར་བ་ལས་སླ་པོ་ཡིན་ནམ། ཡང་ན་ལོངས་ལ་ཉལ་ཁྲི་ཁྱེར་ནས་སོང་ཞིག་ཟེར་བ་ལས་སླ་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","འོན་ཀྱང་མིའི་རིགས་ཀྱི་བུ་ལ་འཇིག་རྟེན་འདིའི་སྟེང་སྡིག་ཉེས་སེལ་བའི་དབང་ཡོད་པ་ཁྱོད་ཚོས་ཤེས་པའི་ཕྱིར༌༌༌༌” ཡེ་ཤུས་ནད་པ་དེ་ལ་ ");
INSERT INTO bod_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ངས་ཁྱོད་ལ་ཟེར་རྒྱུར། ལོངས་ལ་ཉལ་ཁྲི་ཁྱེར་ནས་ནང་ལ་ལོག་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","མི་དེས་ལམ་སེང་ཡར་ལངས་ནས་ཉལ་ཁྲི་ཁྱེར་ཏེ་མི་ཚང་མའི་མདུན་ནས་ལོག་ཕྱིན་པས། ཐམས་ཅད་ཡ་མཚན་ཆེན་པོ་སྐྱེས་ནས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཏེ་“འདི་ལྟ་བུའི་མཛད་པ་ང་ཚོས་གཏན་ནས་མཐོང་མ་མྱོང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","དེ་ནས་ཡང་ཡེ་ཤུ་ག་ལིལ་ཡུལ་གྱི་མཚོའི་འགྲམ་དུ་ཕེབས་པ་དང༌། མི་ཚང་མ་ཁོང་གི་དྲུང་དུ་འཛོམས་ནས་ཁོང་གིས་དེ་ཚོ་ལ་ཆོས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ཡེ་ཤུ་ཕེབས་བཞིན་པའི་སྐབས་སུ་ཁོང་གིས་ཨལ་ཕཱ་ཡི་བུ་ལེ་ཝི་ཟེར་བ་དེ་ཁྲལ་ལེན་སར་བསྡད་ཡོད་པ་གཟིགས་ནས། དེ་ལ་“ཁྱེད་རང་ངའི་རྗེས་སུ་ཤོག་”ཅེས་གསུངས་པས་ཁོ་ཡར་ལངས་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ཡེ་ཤུས་ལེ་ཝིའི་ཁྱིམ་ལ་ཞལ་ལག་བཞེས་པའི་སྐབས་སུ། ཁྲལ་ལེན་མཁན་དང་སྡིག་ཉེས་ཅན་མང་པོ་ཞིག་ཀྱང་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་མཉམ་དུ་ཟས་ཟ་བཞིན་ཡོད། དེ་ནི་མི་མང་པོ་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་གི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཚོས་ཡེ་ཤུས་ཁྲལ་ལེན་མཁན་དང་སྡིག་ཉེས་ཅན་ཚོ་མཉམ་དུ་ཞལ་ལག་བཞེས་བཞིན་པ་མཐོང་སྟེ། ཁོ་ཚོས་ཁོང་གི་ཉེ་གནས་ཚོར་“ཁོང་གིས་ཁྲལ་ལེན་མཁན་དང་སྡིག་ཉེས་ཅན་རྣམས་དང་མཉམ་དུ་བཟའ་བཏུང་བྱེད་པ་འདི་ཅི་ཡིན་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ཡེ་ཤུས་གཏམ་དེ་གསན་ནས་“ཁམས་བཟང་པོའི་མི་ལ་སྨན་པ་མི་དགོས་ཀྱི། ནད་པ་ཚོ་ལ་དགོས་སོ། ང་རང་ནི་ཆོས་དྲང་པོའི་མི་རྣམས་འབོད་དུ་ཡོང་བ་མ་ཡིན་གྱི། མི་སྡིག་ཉེས་ཅན་རྣམས་འབོད་དུ་ཡོང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","དེ་ཡང་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་སློབ་མ་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་སྨྱུང་གནས་སྲུང་བཞིན་ཡོད་དེ། མི་འགའ་ཞིག་ཡོང་ནས་ཡེ་ཤུ་ལ་“ཡོ་ཧ་ནན་གྱི་སློབ་མ་དང་ཕཱ་རུ་ཤི་པའི་སློབ་མ་རྣམས་ཀྱིས་སྨྱུང་གནས་སྲུང་བཞིན་ཡོད་ནའང༌། ཁྱེད་ཀྱི་སློབ་མ་རྣམས་ཀྱིས་སྨྱུང་གནས་མི་སྲུང་བ་ཅི་ཡིན་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ཡེ་ཤུས་“ཆང་སའི་སྐབས། མག་པའི་རོགས་རྣམས་མག་པ་དང་མཉམ་དུ་ཡོད་དུས་སྨྱུང་གནས་སྲུང་སྲིད་དམ། མག་པ་ཁོ་ཚོ་དང་མཉམ་དུ་ཡོད་དུས་ཁོ་ཚོས་སྨྱུང་གནས་སྲུང་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","འོན་ཀྱང་མག་པ་ཁོ་ཚོ་དང་ཁ་འབྲལ་བའི་དུས་ལ་འབབ་ཡོང༌། དུས་དེར་ཁོ་ཚོས་སྨྱུང་གནས་སྲུང་ངེས། ");
INSERT INTO bod_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","དཔེར་ན། མི་སུས་ཀྱང་རས་མཐུག་པོས་གོས་སྲབ་པོར་ལྷན་པ་མི་རྒྱག དེ་ལྟར་བྱས་ན་རས་མཐུག་པོ་དེས་གོས་སྲབ་པོའི་སྲུབས་ཁ་ཇེ་ཆེར་གཏོང༌། ");
INSERT INTO bod_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ཡང་དེ་ལྟར་མི་སུ་ཞིག་ཡིན་ཡང་རྒུན་འབྲུམ་ཆང་གསར་པ་པགས་པའི་ཁུག་མ་རྙིང་པའི་ནང་བསྙལ་བར་མི་བྱ། གལ་ཏེ་བསྙལ་ཚེ་ཆང་འཕེལ་ནས་ཁུག་མ་རྙིང་པ་གས་ཏེ་ཆང་དང་ཁུག་མ་གཉིས་ཀ་འཕྲོ་བརླག་འགྲོ་བར་འགྱུར་ངེས་པས། རྒུན་འབྲུམ་ཆང་གསར་པ་དེ་ཁུག་མ་གསར་པའི་ནང་དུ་བླུག་གོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","དེ་ནས་ངལ་གསོ་བའི་ཉིན་མོར་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་ཞིང་ཁ་ཞིག་བརྒྱུད་ནས་ཕེབས་སྐབས། ཉེ་གནས་རྣམས་ཀྱིས་འབྲུ་ཡི་སྙེ་མ་འཐོག་བཞིན་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ཕཱ་རུ་ཤི་པ་ཡིས་“གཟིགས་དང༌། ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ཀྱིས་ཅིའི་ཕྱིར་ངལ་གསོ་བའི་ཉིན་མོར་དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་བྱེད་མི་ཆོག་པའི་ལས་བྱེད་བཞིན་ཡོད་དམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ཡེ་ཤུས་“རྒྱལ་པོ་དཱ་བིད་དང་ཁོང་གི་འཁོར་གཡོག་རྣམས་ལྟོགས་ནས་ཟས་མེད་ཐབས་མེད་པར་གྱུར་ཏེ། ཅི་ཞིག་བྱས་པ་ཁྱོད་ཚོས་དཀོན་མཆོག་གི་གསུང་རབ་ལས་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","བླ་ཆེན་གཙོ་བོ་ཨབ་ཡཱ་ཐར་ཟེར་བའི་དུས་སུ། དཱ་བིད་ཉིད་དཀོན་མཆོག་གི་གུར་མཆོག་ཏུ་སོང་ནས་དཀོན་མཆོག་གི་སྐུ་མདུན་གྱི་བག་ལེབ་བཟས་ཤིང་འཁོར་གཡོག་རྣམས་ལའང་བྱིན། བག་ལེབ་དེ་བཀའ་ཁྲིམས་ལྟར་ན་ཡ་ཧུ་དཱ་པའི་བླ་མ་རྣམས་ལས་གཞན་སུས་ཀྱང་ཟ་མི་ཆོག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","དེ་ནས་ཁོང་གིས་“མི་ནི་ངལ་གསོའི་ཉིན་གྱི་དོན་དུ་མཛད་པ་མ་ཡིན་གྱི། ངལ་གསོའི་ཉིན་མོ་ནི་མིའི་དོན་དུ་མཛད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","དེ་བས་མིའི་རིགས་ཀྱི་བུ་ནི་ངལ་གསོ་བའི་ཉིན་གྱི་གཙོ་བོ་ཡིན་ནོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","དེ་ནས་ཡང་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དུ་ཕེབས། དེར་ལག་པ་འཁུམས་པའི་མི་ཞིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ཡེ་ཤུ་ལ་ནག་ཉེས་བཙུགས་པར་འདོད་པའི་མི་རྣམས་ཀྱིས་ངལ་གསོ་བའི་ཉིན་ལ་ཁོང་གིས་མི་དེའི་ནད་སེལ་དང་མི་སེལ་བའི་ཆེད་ནན་ཏན་གྱིས་བལྟས་ཏེ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ཡེ་ཤུས་ལག་པ་གཅིག་འཁུམས་པའི་མི་དེ་ལ་“ཡར་ལངས་ནས་ཚུར་ཤོག་”ཅེས་གསུངས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ཡང་མི་དེ་རྣམས་ལ་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་མི་རྣམས་ལ་ངལ་གསོ་བའི་ཉིན་མོར་ལས་བཟང་པོ་བྱེད་ཆོག་གམ་ཡང་ན་ལས་ངན་པ་བྱེད་ཆོག སྲོག་སྐྱོབ་ཆོག་གམ་ཡང་ན་སྲོག་གཅོད་ཆོག་”ཅེས་དྲིས། འོན་ཀྱང་དེ་ཚོས་ཁ་རོག་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ཡེ་ཤུ་ཐུགས་ཁྲོས་ནས་མི་དེ་རྣམས་ལ་རིམ་གྱིས་གཟིགས་ཤིང་དེ་ཚོའི་སེམས་མཁྲེགས་པོ་ཡིན་པར་ཐུགས་སྐྱོ་སྟེ། མི་དེར་“ལག་པ་རྐྱོངས་ཤིག་”ཅེས་གསུངས་པས་ཁོས་ལག་པ་བརྐྱངས་ཤིང་ནད་སེལ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","དེ་ནས་ཕཱ་རུ་ཤི་པ་རྣམས་ཕྱི་ལ་སོང་མ་ཐག་ཏུ་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཞེས་བྱ་བའི་ཕྱོགས་ཁག་གི་མི་དང་མཉམ་དུ་ཡེ་ཤུ་དགྲོང་རྒྱུའི་ངན་ཇུས་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","དེ་ནས་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་ཕྱིར་མཚོ་འགྲམ་དུ་ཕེབས་པ་ལ། མི་ཚོགས་མང་པོ་ཞིག་ག་ལིལ་ཡུལ་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་པ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ཁོང་གིས་མཛད་པའི་དོན་རྣམས་ཐོས་པས་གཞན་མི་མང་པོས་ཀྱང་ཡ་ཧུ་དཱ་ཡུལ་དང་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར། ཨི་དུམ་ཡཱ་ཡུལ། ཡོར་དན་གཙང་པོའི་ཕ་རོལ་གྱི་ས་ཆ་དང༌། གྲོང་ཁྱེར་ཐཱ་ཨེར་དང་ཚི་དོན་སོགས་ས་ཆ་སོ་སོ་ནས་ཁོང་གི་དྲུང་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","དེར་ཡོད་པའི་མི་ཚོགས་མང་པོས་ཁོང་མ་བཙིར་བའི་ཕྱིར། ཁོང་གིས་ཉེ་གནས་ཚོར་གྲུ་ཆུང་ཞིག་གྲ་སྒྲིག་བྱེད་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ཁོང་གིས་མི་མང་པོའི་ནད་སེལ་བར་མཛད་པས། ནད་ཡོད་པ་ཐམས་ཅད་ཀྱིས་ཁོང་ལ་རེག་པའི་ཆེད་དུ་འཚང་ཁ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","གདོན་འདྲེ་མི་གཙང་བ་དེ་ཚོས་ག་དུས་ཡིན་ཡང་ཁོང་མཐོང་བ་ཙམ་གྱིས་ཁོང་གི་དྲུང་དུ་ཕྱག་འཚལ་ཏེ་སྐད་ཆེན་པོས་“ཁྱེད་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་ནོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ཡེ་ཤུས་དེ་ཚོ་ལ་ཁོང་མངོན་པར་མི་བྱེད་ཕྱིར་ནན་ཏན་གྱིས་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","དེ་ནས་ཡེ་ཤུ་རིའི་སྟེང་ལ་ཕེབས་ཏེ་རང་གི་དགོངས་པ་ལྟར་ཚུར་ཤོག་ཅེས་བཀའ་གནང་ནས་ཁོ་རྣམས་ཁོང་གི་དྲུང་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","ཁོ་ཚོ་ཁོང་དང་ཉེ་བར་གནས་པ་དང༌། ཁོང་གིས་ཁོ་ཚོ་ལ་ཆོས་ཤོད་པར་གཏོང་བ་དང་གདོན་འདྲེ་སྐྲོད་པའི་ཕྱིར་དབང་བསྐུར་ནས་དེ་རྣམས་ཉེ་གནས་བཅུ་གཉིས་ལ་བསྐོས་ཏེ་མིང་གཞན་སྐུ་ཚབ་ཅེས་ཀྱང་བཏགས། ");
INSERT INTO bod_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ཁོང་གིས་བསྐོས་པའི་ཉེ་གནས་བཅུ་གཉིས་པོ་ནི་སི་མོན། ཁོང་གིས་མི་དེར་མིང་པེ་ཏྲོ་ཞེས་བཏགས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ཟེ་བད་ཡཱ་ཞེས་པའི་བུ་ཡ་ཀོབ་དང༌། ཡ་ཀོབ་ཀྱི་གཅུང་པོ་ཡོ་ཧ་ནན། དེ་གཉིས་ཀྱི་མིང་ལ་བོ་ཨ་ནེར་གེ་ཞེས་བཏགས་ཏེ་འབྲུག་གི་བུ་ཞེས་པའི་དོན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","གཞན་ཡང་ཨན་དྲི་ཡཱ་དང༌། ཕི་ལིབ། པར་ཐོ་ལོ་མཱ། མད་ཐཱ། ཐོ་མཱ་དང༌། ཨལ་ཕཱ་ཞེས་པ་དེའི་བུ་ཡ་ཀོབ། ཐཱ་ཨད་དེ་ཨ་སི། རྒྱལ་གཅེས་པའི་ཕྱོགས་ཁག་གི་ཁོངས་མི་སི་མོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","རྗེས་སུ་ཡེ་ཤུ་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","དེ་ནས་ཡེ་ཤུ་དང་ཉེ་གནས་རྣམས་ཁང་པ་ཞིག་གི་ནང་དུ་ཕེབས་པ་ན། མི་ཚོགས་ཡང་བསྐྱར་འཛོམས་པས། ཁོང་རྣམས་ལ་ཐ་ན་ཞལ་ཟས་བཞེས་ལོང་ཡང་མ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ཁོང་གི་གཉེན་ཉེ་རྣམས་ཀྱིས་གཏམ་དེ་ཐོས་ནས་ཁོང་སྨྱོས་སོ་ཞེས་བཤད་དེ་ཁོང་བཀག་པར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ཡེ་རུ་ཤ་ལེམ་ནས་མར་ཡོང་བའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཚོས་“ཁོང་ལ་པེ་ཨིལ་བཟི་པད་བདུད་ཞུགས་ཤིང་ཁོང་གིས་བདུད་ཀྱི་རྒྱལ་པོ་དེར་བརྟེན་ནས་གདོན་འདྲེ་སྐྲོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ཡེ་ཤུས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དེ་ཚོ་རང་གི་དྲུང་དུ་བོས་ཏེ་དཔེའི་སྒོ་ནས་དེ་རྣམས་ལ་“བདུད་སཱ་ཏན་གྱིས་བདུད་རང་ཉིད་ཇི་ལྟར་སྐྲོད་སྲིད་དམ། ");
INSERT INTO bod_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","གལ་ཏེ་རྒྱལ་ཁབ་གཅིག་ལ་ནང་འཁྲུག་བྱུང་ན་རྒྱལ་ཁབ་དེ་བརྟན་པོར་གནས་མི་ཐུབ་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ཁྱིམ་ཚང་གཅིག་ལ་ནང་འཁྲུག་བྱུང་ན་ཁྱིམ་ཚང་དེའང་བརྟན་པོར་གནས་མི་ཐུབ་པ་ལྟར། ");
INSERT INTO bod_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","དེ་བཞིན་བདུད་སཱ་ཏན་གྱིས་རང་གིས་རང་ལ་རྒོལ་ན་བདུད་དེ་བརྟན་པོར་གནས་མི་ཐུབ་ཅིང་ཁོའི་དབང་མེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ཡང་སུས་ཀྱང་མི་སྟོབས་ཤུགས་ཆེན་པོ་ཞིག་གི་ཁང་པ་ལ་འཛུལ་ནས་དེའི་ཅ་ལག་འཕྲོག་མི་ཐུབ་སྟེ། སྔོན་ལ་མི་དེ་བཅིངས་ནས་ཁོ་ལ་ཅི་ཡོད་པ་དེ་འཕྲོག་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ངས་ཁྱོད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། དཀོན་མཆོག་གིས་མིའི་སྡིག་ཉེས་ཐམས་ཅད་དང་སྐུར་བ་འདེབས་པའི་སྡིག་པ་སེལ་ཐུབ་ནའང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་སྐུར་བ་འདེབས་མཁན་དེར་དུས་ནམ་ཡང་སྡིག་སེལ་མི་ཐོབ་པར་གཏན་དུ་སྡིག་པའི་ཆད་པ་འཁུར་དགོས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ཁོང་གིས་འདི་ལྟར་གསུངས་དོན་ནི་མི་དེ་རྣམས་ཀྱིས་ཁོང་ཉིད་གདོན་འདྲེ་མི་གཙང་བ་ཡིས་བཟུང་འདུག་ཅེས་བཤད་པའི་རྐྱེན་གྱིས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","དེ་ནས་ཡེ་ཤུའི་མ་ཡུམ་དང་གཅུང་པོ་ཚོ་ཕེབས་ཏེ། ཕྱི་ལོགས་ལ་བཞེངས་ནས་མི་ཞིག་ཁོང་ཉིད་འབོད་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","མི་ཚོགས་མང་པོ་ཁོང་གི་མཐའ་བསྐོར་ལ་བསྡད་ཡོད་ཅིང༌། དེ་ཚོས་“གཟིགས་དང༌། ཁྱེད་ཀྱི་མ་ཡུམ་དང་སྐུ་མཆེད་ཚོས་ཕྱི་རོལ་ནས་ཁྱེད་རང་འཚོལ་བཞིན་འདུག་”ཅེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ཁོང་གིས་མི་དེ་ཚོར་“ངའི་མ་དང་ངའི་སྤུན་ནི་སུ་ཡིན་ནམ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","རང་གི་མཐའ་སྐོར་ལ་བསྡད་ཡོད་པའི་མིར་རིམ་གྱིས་གཟིགས་ནས་“ལྟོས་དང༌། ངའི་མ་དང་ངའི་སྤུན་ནི་མི་འདི་ཚོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","གང་ལགས་ཟེར་ན། དཀོན་མཆོག་གི་དགོངས་པ་བཞིན་དུ་བྱེད་མཁན་ཐམས་ཅད་ནི་ངའི་སྤུན་དང་སྲིང་མོ། མ་ཡུམ་ཡིན་ནོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","དེ་ནས་ཡང་ཡེ་ཤུས་ག་ལིལ་མཚོའི་འགྲམ་དུ་མི་དེ་ཚོ་ལ་ཆོས་བསྟན་ཏེ། མི་མང་པོ་གནས་དེར་འཛོམས་པས་ཁོང་གྲུ་ཞིག་གི་ནང་དུ་བཞུགས་པ་དང༌། མི་ཚོགས་ཚང་མ་མཚོ་འགྲམ་ལ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ཁོང་གིས་དཔེའི་སྒོ་ནས་ཆོས་མང་པོ་གསུངས་པ་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ད་ཉོན་ཅིག སྔོན་ས་བོན་འདེབས་མཁན་ཞིག་ས་བོན་འདེབས་པར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ས་བོན་གཏོར་བའི་སྐབས་སུ། ས་བོན་ཁ་ཤས་ལམ་ཁར་འཐོར་བ་བྱ་ཚོ་འོངས་ནས་བཟས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ཁ་ཤས་ནི་ས་མང་པོ་མེད་པའི་བྲག་གི་སྟེང་ལ་འཐོར་ཞིང་སའི་གཏིང་རིང་པོ་མེད་པས་ཡར་སྐྱེས་པ་མགྱོགས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ཉི་མ་ཤར་ནས་ཚིག་སྟེ་རྩ་བ་གཏིང་རིང་པོ་མེད་པས་བསྐམས། ");
INSERT INTO bod_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ས་བོན་ཁ་ཤས་ཚེར་མའི་ནང་དུ་འཐོར་ཞིང་ཚེར་མ་སྐྱེས་ཏེ་སྒྲིབ་ནས་འབྲས་བུ་མ་སྨིན། ");
INSERT INTO bod_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ཡང་ས་བོན་ཁ་ཤས་ས་རྒྱུ་བཟང་པོའི་ནང་དུ་ཟགས་ནས་ཆེར་སྐྱེས་ཤིང་འབྲས་བུ་སྨིན་ཏེ། འབྲས་བུ་ཁ་ཤས་ལྡབ་སུམ་ཅུ་དང་ཁ་ཤས་ལྡབ་དྲུག་ཅུ། ཁ་ཤས་ལྡབ་བརྒྱ་བཅས་སྨིན་ནོ་”ཞེས་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","མཇུག་ཏུ་ཁོང་གིས་“རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ཡེ་ཤུ་གཅིག་པུར་བཞུགས་དུས་ཁོང་གི་ཉེ་གནས་བཅུ་གཉིས་པོ་དང་རྗེས་འབྲང་བ་རྣམས་ཀྱིས་ཁོང་ལ་དཔེའི་ནང་དོན་ཅི་ཡིན་པ་དྲིས་པའི་སྐབས། ");
INSERT INTO bod_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་གསང་བ་དེ་ཁྱེད་ཚོ་ལ་བསྟན་པ་ཡིན། འོན་ཀྱང་ཕྱི་ཕྱོགས་ཀྱི་མི་རྣམས་ལ་ཐམས་ཅད་དཔེའི་སྒོ་ནས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","མདོ་ལས། དེ་ཚོས་སེམས་མི་འགྱུར་ཞིང༌། ། སྡིག་ཉེས་མི་སེལ་བའི་ཕྱིར། ། ལྟ་བར་བྱེད་ཀྱང་མི་མཐོང༌། ། ཐོས་པར་བྱེད་ཀྱང་མི་རྟོགས། །” ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ཡང་ཁོང་གིས་“ཁྱེད་ཚོས་དཔེ་འདིའི་དོན་ཧ་མི་གོའམ། འོ་ན་དཔེ་ཐམས་ཅད་ཀྱི་དོན་ཇི་ལྟར་ཤེས་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","དེ་ནི་ཞིང་འདེབས་མཁན་གྱིས་ས་བོན་བཏབ་པ་ནི་དཀོན་མཆོག་གི་བཀའ་དང་འདྲ་བ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ལམ་ཁར་འཐོར་བ་ནི་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་མ་ཐག་བདུད་སཱ་ཏན་ཡོང་ནས་དེའི་སེམས་ནང་གི་བཀའ་ཕྲོགས་ནས་ཁྱེར་སོང་བ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","དེ་བཞིན་དུ་བྲག་ཡོད་པའི་ས་ལ་འཐོར་བ་ནི་ཡང་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་མ་ཐག་སེམས་དགའ་བའི་ངང་ནས་བླངས་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","རང་གི་སེམས་ནང་ལ་རྩ་བ་གཏིང་རིང་པོ་ཚུགས་མེད་པས། དུས་ཐུང་ངུ་ལ་གནས་ཀྱང་བཀའ་དེའི་དོན་དུ་སྡུག་བསྔལ་དང་གནོད་འཚེ་འབྱུང་སྐབས་དད་པ་ཉམས་པར་གྱུར་བ་དང་འདྲ། ");
INSERT INTO bod_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ཡང་ཚེར་མའི་ནང་དུ་འཐོར་བ་ནི་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་རྗེས། ");
INSERT INTO bod_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","འཚོ་བའི་སེམས་ཁྲལ་དང་རྒྱུ་ནོར་གྱི་བསླུ་བྲིད། འདོད་པ་སྣ་ཚོགས་ཀྱིས་བཀའ་མནན་ནས་འབྲས་བུ་སྨིན་མ་ཐུབ་པ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ས་རྒྱུ་བཟང་པོ་ལ་འཐོར་བ་ནི་ཡང་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་ནས་དད་པའི་ངང་ཉམས་སུ་བླངས་ཏེ་འབྲས་བུ་སྨིན་ཐུབ་པ་རྣམས་ཡིན་ཏེ། འབྲས་བུ་ཁ་ཤས་ལྡབ་སུམ་ཅུ་དང༌། ཁ་ཤས་ལྡབ་དྲུག་ཅུ། ཁ་ཤས་ལྡབ་བརྒྱ་བཅས་སྨིན་པ་ལྟར་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ཡང་ཡེ་ཤུས་“མིས་མར་མེ་ཞིག་བྲེ་ཡང་ན་ཉལ་ཁྲིའི་འོག་ཏུ་འཇོག་པ་ཡིན་ནམ། དེ་ནི་སྟེགས་བུའི་སྟེང་དུ་འཇོག་པའི་ཕྱིར་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","གང་ལགས་ཟེར་ན། སྦས་པའི་དོན་རྣམས་མི་མངོན་པ་ཅི་ཡང་མེད་ལ། གསང་བའི་དོན་ཐམས་ཅད་ཀྱང་མི་མངོན་པ་ཅི་ཡང་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ཡང་ཁོང་གིས་“ཁྱེད་ཚོས་གང་ཐོས་པ་དེ་ལ་གཟབ་ནན་གྱིས་ཤིག ཁྱེད་ཚོས་སྣོད་ཚད་ཅི་ལྟ་བུ་ལས་མི་གཞན་ལ་བཅལ་ན། ཁྱེད་ཚོར་ཡང་དེ་འདྲ་ཞིག་སྟེར་བར་མ་ཟད་དེ་ལས་ལྷག་པ་ཞིག་ཀྱང་སྟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","མི་སུ་ཞིག་ལ་ཡོད་པ་དེ་ལ་དེ་བས་མང་བ་སྟེར་བར་འགྱུར། མེད་པ་དེ་ལ་གང་ཡོད་པ་དེ་ཡང་ལེན་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ཡང་ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འདི་ནི། མི་ཞིག་གིས་ཞིང་ལ་ས་བོན་གཏོར་བ་དང་འདྲ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","མི་འདི་མཚན་མོར་གཉིད་ཉལ་ཞིང་ཉིན་མོར་ཡར་ལངས། ཁོས་གང་ཡིན་མི་ཤེས་པར་ས་བོན་རིམ་བཞིན་སྐྱེས་ནས་མྱུ་གུ་འབུས། ");
INSERT INTO bod_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ས་གཞི་ཡིས་རང་བཞིན་གྱིས་འབྲས་བུ་སྐྱེད་དེ། ཐོག་མར་མྱུ་གུ་འབུས་པ་དང་དེ་ནས་སྙེ་མ་ཐོགས་པ། མཇུག་མཐར་སྙེ་མ་ལས་འབྲུ་རྡོག་སྨིན། ");
INSERT INTO bod_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","འབྲུ་རིགས་སྨིན་ནས་ཞིང་བརྔ་རན་པས་ས་བོན་འདེབས་མཁན་གྱིས་ཟོར་བས་འབྲེག་པའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ཡང་ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་གང་ཞིག་གིས་བསྡུར་ཐུབ་བམ། དཔེ་གང་ཞིག་གིས་མཚོན་ཐུབ་བམ་ཞེ་ན། ");
INSERT INTO bod_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","དེ་ནི་ཡུངས་འབྲུ་རྡོག་པོ་གཅིག་དང་འདྲ་སྟེ། ས་ལ་འདེབས་པའི་ས་བོན་གཞན་ཐམས་ཅད་ལས་ཆུང་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","བཏབ་པའི་རྗེས་སུ་ཆེར་སྐྱེས་ནས་སྔོ་ཚོད་གཞན་རྣམས་ལས་ཆེ་བར་འགྱུར་ཞིང་དེར་ཡལ་ག་ཆེན་པོ་ཆགས་ཏེ་བྱའང་དེའི་གྲིབ་མའི་འོག་ཏུ་གནས་ཐུབ་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ཡེ་ཤུས་འདི་ལྟ་བུའི་དཔེ་མང་པོ་བཀོད་དེ། མི་རྣམས་ཀྱིས་དོན་དེ་ཇི་ཙམ་ཧ་གོ་ཐུབ་པ་དེ་བཞིན་དུ་དཀོན་མཆོག་གི་བཀའ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ཁོང་གིས་དཔེ་མ་བཀོད་པར་དེ་རྣམས་ལ་ཅི་ཡང་མ་གསུངས་ཤིང༌། མི་གཞན་མེད་པའི་དུས་སུ་དཔེ་ཐམས་ཅད་ཀྱི་གོ་དོན་ཉེ་གནས་ཚོར་གསལ་བཤད་གནང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","དེ་ནས་ཉིན་དེའི་དགོང་མོར་ཡེ་ཤུས་ཉེ་གནས་ཚོར་“ང་ཚོ་མཚོའི་ཕ་རོལ་ལ་འགྲོའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ཉེ་གནས་ཚོ་མི་ཚོགས་དང་ཁ་བྲལ་ཏེ་ཡེ་ཤུ་བཞུགས་སའི་གྲུའི་ནང་འཛུལ་ནས་ཁོང་དང་མཉམ་དུ་ཕྱིན་པ་རེད། ཁོང་ཚོ་དང་མཉམ་དུ་གྲུ་གཞན་ཡང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","དེའི་སྐབས་རླུང་འཚུབ་ཆེན་པོ་ལངས་ཏེ་རྦ་རླབས་གྲུའི་ནང་འཛུལ་ནས་གྲུ་ཆུས་ཁེངས་གྲབས་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","དེ་དུས་ཡེ་ཤུ་གྲུའི་མཇུག་ཏུ་སྔས་འབོལ་གྱི་སྟེང་ལ་གཟིམས་ཡོད་པས་ཉེ་གནས་ཚོས་ཁོང་མནལ་སད་དེ་“སྟོན་པ་ལགས། ང་ཚོ་འཆི་བ་ལ་ཐུག་པར་ཁྱེད་ཀྱིས་ཐུགས་སྣང་མི་མཛད་དམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ཁོང་མནལ་སད་དེ་ཡར་བཞེངས་ནས། རླུང་ལ་བཀའ་བཀྱོན་མཛད་ཅིང་རྦ་རླབས་ལ་“ཞི་བར་གྱུར་ལ་ཁ་རོག་སྡོད་ཅིག་”ཅེས་བཀའ་གནང་བས། རླུང་འཇགས་ནས་མཚོ་ཡོངས་སུ་ཞི་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","དེ་ནས་ཁོང་གིས་ཉེ་གནས་ཚོར་“ཁྱོད་ཚོ་ཞེད་དགོས་དོན་གང་ཡིན། ཁྱོད་རང་ཚོ་ད་དུང་ཡིད་ཆེས་མེད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ཁོ་ཚོ་ཤིན་ཏུ་འཇིགས་ནས་གཅིག་གིས་གཅིག་ལ་“འདི་སུ་ཡིན་ནམ། རླུང་དང་རྦ་རླབས་ཀྱིས་ཀྱང་ཁོང་གི་བཀའ་ལ་ཉན་པར་བྱེད་”ཅེས་ཟེར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","དེ་ནས་ཁོང་རྣམས་ག་ལིལ་མཚོའི་ཕ་རོལ་གྱི་གེ་ར་སཱ་བྱ་བའི་ཡུལ་དུ་ཕེབས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ཡེ་ཤུ་གྲུ་ལས་བབས་མ་ཐག་དུར་ཁང་གི་ཁྲོད་ནས་གདོན་འདྲེ་མི་གཙང་བ་ཡིས་བཟུང་བའི་མི་ཞིག་ཁོང་དང་མཇལ་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","མི་དེ་རྒྱུན་དུ་དུར་ཁང་གི་ཁྲོད་དུ་སྡོད་ཅིང་མི་སུས་ཀྱང་ཁོ་བཟུང་ནས་ལྕགས་ཐག་གིས་ཀྱང་འཆིང་བར་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","མི་རྣམས་ཀྱིས་ཐེངས་མང་པོར་ལྕགས་ཐག་དང་རྐང་སྒྲོག་གིས་ཁོ་རང་བཅིངས་མྱོང་ནའང༌། ཁོས་ལྕགས་ཐག་དང་རྐང་སྒྲོག་དེ་ཚོ་དུམ་བུར་བཅད་པས་མི་སུས་ཀྱང་ཁོ་འདུལ་བར་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ཁོས་ཉིན་མཚན་མེད་པར་དུར་ཁང་རྣམས་དང་རིའི་ཁྲོད་ལ་སྐད་ངན་བརྒྱབ་ཅིང་རྡོ་ཡིས་རང་ལུས་རྨས་པར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ཁོས་རྒྱང་རིང་ནས་ཡེ་ཤུ་མཐོང་སྟེ་རྒྱུགས་འོངས་ནས་ཁོང་ལ་ཕྱག་འཚལ་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","ཡེ་ཤུས་ཁོ་ལ་“གདོན་འདྲེ་མི་གཙང་བ་ཁྱོད་མི་འདི་ལས་ཕྱིར་བུད་ཅིག་”ཅེས་བཀའ་གནང་བས། ཁོས་སྐད་ཆེན་པོས་“ཀྱེ། བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་སྲས་ཡེ་ཤུ་ལགས། ང་ཁྱེད་དང་འབྲེལ་བ་ཅི་ཡོད། ངས་དཀོན་མཆོག་གི་མདུན་དུ་ཁྱེད་ལ་ཞུ། ང་ལ་མནར་གཅོད་གཏོང་བ་མ་གནང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ཁོང་གིས་མི་དེར་“ཁྱོད་ཀྱི་མིང་ལ་ཅི་ཟེར་”ཞེས་དྲིས་ཤིང༌། མི་དེས་“ང་ཚོ་གྲངས་ཀ་མང་བའི་རྐྱེན་གྱིས་མིང་ལ་དཔུང་ཚོགས་ཟེར་”ཞེས་ཞུས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“ང་ཚོ་གནས་འདི་ནས་ཡུལ་གཞན་ལ་མ་སྐྲོད་རོགས་”ཞེས་ཁོང་ལ་ཞུ་བ་ཡང་ཡང་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","དེའི་ཚེ་རིའི་ལོགས་སུ་ཕག་ཁྱུ་ཆེན་པོ་ཞིག་འཚོ་བཞིན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","གདོན་འདྲེ་མི་གཙང་བ་དེ་ཚོས་ཡེ་ཤུ་ལ་“ང་ཚོ་ཕག་པ་ལ་འཛུལ་བའི་ཕྱིར་ཕག་ཁྱུའི་ཁྲོད་ལ་གཏོང་བར་མཛོད་”ཅེས་ཞུ་བ་ཕུལ་བ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ཁོང་གིས་དེ་ཚོ་ལ་དགོངས་པ་གནང་སྟེ། གདོན་འདྲེ་མི་གཙང་བ་དེ་ཚོ་མི་དེ་ནས་ཕྱིར་ཐོན་ཏེ་ཕག་པའི་ནང་དུ་ཞུགས་ཤིང༌། ཕག་པ་ཉིས་སྟོང་ཙམ་ཡོད་པ་ཚོ་གཡང་གཟར་དུ་མཆོངས་ཤིང་མཚོའི་ནང་དུ་ནུབ་ནས་ཤིའོ། ");
INSERT INTO bod_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","དེ་ནས་ཕག་རྫི་བྲོས་ཏེ་གྲོང་ཁྱེར་དང་སྡེ་པའི་མི་རྣམས་ལ་གནས་ཚུལ་དེ་བཤད་པས། མི་རྣམས་ཅི་བྱུང་བར་ལྟ་རུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ཁོ་ཚོ་ཡེ་ཤུའི་དྲུང་དུ་སླེབས་དུས། དེ་སྔོན་དཔུང་ཚོགས་ཞེས་པའི་གདོན་འདྲེས་བཟུང་བའི་མི་དེ་དྲན་པ་གསོས་ཤིང་གོས་གྱོན་ནས་བསྡད་ཡོད་པ་མཐོང་སྟེ་འཇིགས་སྣང་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ཡང་གནས་ཚུལ་འདི་མཐོང་བའི་མི་རྣམས་ཀྱིས་གདོན་འདྲེས་བཟུང་བའི་མི་དང་ཕག་ཁྱུ་ལ་བྱུང་བའི་ལོ་རྒྱུས་དེ་མི་ཚོགས་གཞན་ལ་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","མི་དེ་ཚོས་ཡེ་ཤུར་ས་ཆ་གཞན་ལ་ཕེབས་པར་ཞུ་ཞེས་ཞུ་བ་ཡང་ཡང་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","དེ་ནས་ཡེ་ཤུ་གྲུའི་ནང་དུ་བཞུགས་པའི་དུས་སུ། དེ་སྔོན་གདོན་འདྲེས་བཟུང་བའི་མི་དེས་ཁོང་ལ་“ང་ཡང་ཁྱེད་དང་མཉམ་དུ་ཡོང་གི་ཡིན་”ཞེས་ཞུ་བ་ཞུས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ཁོང་གིས་ཁས་མ་བླངས་པར་མི་དེ་ལ་“ཁྱེད་རང་གི་ནང་ལ་སོང་དང༌། ཁྱེད་ཀྱི་དོན་དུ་དཀོན་མཆོག་གིས་ཅི་ལྟར་ལས་ཆེན་པོ་ཞིག་བསྒྲུབས་པ་དང་ཇི་ལྟར་སྙིང་རྗེ་གནང་བ་དེ་ཚོ་གཉེན་ཉེ་རྣམས་ལ་ཤོད་ཅིག་”ཅེས་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","དེ་ནས་མི་དེ་དེ་ཁ་པོ་ལེ་ཞེས་བྱ་བའི་ཡུལ་ལ་སོང་ནས་ཡེ་ཤུས་ཁོ་རང་གི་དོན་དུ་ཅི་མཛད་པ་རྣམས་མི་ཀུན་ལ་བསྒྲགས་ཤིང༌། མི་ཐམས་ཅད་ངོ་མཚར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","དེ་ནས་ཡེ་ཤུ་གྲུའི་ནང་ལ་བཞུགས་ཏེ་ཡང་བསྐྱར་མཚོའི་ཕར་ཕྱོགས་སུ་ཕེབས་པ་དང་མི་ཚོགས་མང་པོ་ཁོང་གི་དྲུང་དུ་འདུས། ཁོང་མཚོའི་འགྲམ་དུ་བཞུགས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","སྐབས་དེར་ས་ཆ་དེ་ལ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ཞིག་ཡོད་པ་དེའི་དཔོན་པོའི་མིང་ལ་ཡ་ཨིར་ཟེར་བ་ཞིག་འོངས་ནས། ཡེ་ཤུ་མཇལ་བ་དང་ཁོང་གི་ཞབས་ལ་གཏུག་སྟེ། ཞུ་བ་ཆེན་པོ་ཕུལ་ནས་ ");
INSERT INTO bod_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ངའི་བུ་མོ་ཆུང་ཆུང་དེ་ཤི་གྲབས་འདུག ཁྱེད་རང་ངའི་ནང་ལ་ཕེབས་ནས་ཁོ་མོ་ནད་ལས་ཐར་ཏེ་གསོན་པའི་ཕྱིར། ཁྱེད་ཀྱིས་ཁོ་མོའི་ལུས་སྟེང་ལ་ཕྱག་འཇོག་པར་མཛོད་དང་”ཞེས་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ཡེ་ཤུ་ཁོང་དང་མཉམ་དུ་ཕེབས་པ་དང༌། མི་མང་པོ་ཁོང་གི་རྗེས་སུ་འབྲངས་ནས་འཚང་ཁ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","དེའི་ཚེ་བུད་མེད་གཅིག་ལོ་བཅུ་གཉིས་ཀྱི་བར་དུ་ལུས་ནས་ཁྲག་འཛིར་བའི་ནད་ཕོག་པ་ཞིག་ཡོད་དེ། ");
INSERT INTO bod_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","སྨན་པ་མང་པོས་སྨན་བཅོས་བྱས་ནས་སྡུག་བསྔལ་མང་པོ་མྱོང་ཡོད། ཁོ་མོ་ལ་ཡོད་པའི་རྒྱུ་ནོར་ཐམས་ཅད་ཟད་ཀྱང་ཕན་འབྲས་ཅི་ཡང་མེད་པ་མ་ཟད་ནད་དེ་སྡུག་རུ་སོང་བས། ");
INSERT INTO bod_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","ཁོ་མོས་ཡེ་ཤུའི་སྐོར་ཐོས་ཏེ། གལ་སྲིད་ངས་ཁོང་གི་ན་བཟའ་གཅིག་པུ་ལ་རེག་ན་ང་ནད་ལས་ཐར་འོང་བསམས་ནས་མི་ཚོགས་ཀྱི་དཀྱིལ་ནས་ཁོང་གི་རྒྱབ་ཏུ་ཡོང་ཞིང་ཁོང་གི་ན་བཟའ་ལ་རེག་པས། ");
INSERT INTO bod_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","དེ་མ་ཐག་ཏུ་ཁོ་མོའི་ཁྲག་འཛིར་བ་ཆད་དེ་རང་གི་ལུས་ནད་དེ་ལས་ཐར་བར་གྱུར་བ་ཤེས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ཡེ་ཤུས་དེ་མ་ཐག་རང་གི་སྐུ་གཟུགས་ནས་ནུས་མཐུ་ཞིག་ཕྱིར་ཐོན་པ་ཐུགས་ལ་མཁྱེན་ཏེ། མི་ཚོགས་ཀྱི་དཀྱིལ་ནས་སྐུ་ཕྱིར་འཁོར་ཏེ་“སུས་ངའི་གོས་ལ་རེག་པ་ཡིན་ནམ་”ཞེས་གསུངས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ཁོང་གི་ཉེ་གནས་ཚོས་ཁོང་ལ་“མི་ཚོགས་ཀྱིས་ཁྱེད་བཙིར་ཞིང་མཐའ་བསྐོར་བ་གཟིགས་བཞིན་དུ། ད་དུང་ང་ལ་སུས་རེག་པ་ཡིན་ཞེས་གསུངས་སམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","འོན་ཀྱང་ཁོང་གིས་སུས་དེ་ལྟར་བྱས་པ་གཟིགས་པའི་ཕྱིར་ཕྱོགས་ཀུན་ཏུ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","དེ་ནས་བུད་མེད་དེས་རང་གི་ལུས་ལ་ཅི་ལྟར་བྱུང་བ་ཤེས་པས། འཇིགས་ནས་འདར་ཞིང་ཁོང་གི་སྐུ་དྲུང་དུ་པུས་མོ་སར་བཙུགས་ནས་གནས་ཚུལ་ཐམས་ཅད་དྲང་པོར་ཁོང་ལ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ཡེ་ཤུས་ཁོ་མོ་ལ་“བུ་མོ། ཁྱོད་ཀྱི་དད་པས་ཁྱོད་རང་ནད་ལས་ཐར་བ་ཡིན་པས། བདེ་བའི་ངང་ནས་སོང་དང་ཁྱོད་རང་ནད་འདི་དང་བྲལ་ཏེ་གནས་པར་གྱུར་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ཁོང་གིས་དེ་ལྟར་གསུང་བཞིན་པའི་སྐབས་སུ། ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་གི་དཔོན་པོའི་ཁྱིམ་ནས་མི་འགའ་ཤས་ཡོང་སྟེ། དེར་“ཁྱེད་རང་གི་བུ་མོ་ཤི་ཚར་སོང་བས་སྟོན་པ་ལ་འོ་བརྒྱལ་ཞུས་བྱས་ག་རེ་བྱེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ཡེ་ཤུས་ཁོ་ཚོའི་སྐད་ཆར་ཁ་ཡ་མ་གནང་བར་དཔོན་པོ་ལ་“ཞེད་སྣང་མ་བྱེད། དད་པ་རང་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","དེ་ནས་ཁོང་གིས་པེ་ཏྲོ་དང་ཡ་ཀོབ། ཡ་ཀོབ་ཀྱི་སྤུན་ཡོ་ཧ་ནན་མ་གཏོགས་གཞན་སུ་ཡང་ཁོང་དང་མཉམ་དུ་ཡོང་མ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ཁོང་ཚོ་དཔོན་པོའི་ནང་ལ་ཕེབས་སྐབས། མི་མང་པོ་ཅ་ཅོ་དང་ངུ་ཞིང་སྨྲེ་སྔགས་འདོན་པ་གཟིགས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ཡེ་ཤུ་ནང་དུ་འཛུལ་ཏེ་ཁོ་ཚོར་གསུངས་པར་“ཁྱོད་ཚོ་ཅ་ཅོ་དང་ངུ་བའི་དོན་གང་ཡིན། བུ་མོ་འདི་ཤི་མེད་པར་གཉིད་ཁུག་འདུག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","མི་དེ་ཚོས་ཁོང་ལ་ཁྲེལ་དགོད་བྱས། ཡེ་ཤུས་ཁོ་ཚོ་ཕྱིར་བཏོན་ནས་བུ་མོའི་ཕ་མ་གཉིས་དང་ཉེ་གནས་རྣམས་མཉམ་དུ་བུ་མོའི་སར་ཕེབས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","བུ་མོའི་ལག་པ་ནས་འཇུས་ཏེ་“ཏ་ལི་ཐཱ་ཀུ་མི་”ཞེས་པའི་དོན་ནི་བུ་མོ་ཆུང་ཆུང་ལོངས་ཤིག་ཅེས་བཀའ་གནང་བས། ");
INSERT INTO bod_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","བུ་མོ་དེ་ལམ་སེང་ཡར་ལངས་ནས་གོམ་པ་བརྒྱབ། (བུ་མོ་དེ་ལོ་བཅུ་གཉིས་ཡིན་) འདིས་མི་ཚང་མ་ཡ་མཚན་ཆེན་པོ་སྐྱེས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ཡེ་ཤུས་མི་རྣམས་ལ་བཀའ་ནན་པོས་འདི་མི་གཞན་སུ་ལ་ཡང་མ་ཤོད་ཅེས་བསྐུལ་བ་དང་བུ་མོ་ལ་ཟས་སྟེར་དགོས་ཞེས་བཀའ་གནང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ཡེ་ཤུ་ས་ཆ་དེ་ནས་ཐོན་ཏེ་ཕ་ཡུལ་དུ་ཕེབས་པ་དང་ཉེ་གནས་རྣམས་ཀྱང་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ངལ་གསོ་བའི་ཉིན་ལ་ཡེ་ཤུས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་ལ་ཆོས་གསུངས་ཤིང༌། ཉན་མཁན་རྣམས་ཀྱིས་གཏམ་དེ་ཐོས་ནས་ཧ་ལས་ཏེ་“མི་འདི་ལ་འདི་ལྟ་བུའི་དོན་རྣམས་གང་ནས་བྱུང་བ་ཡིན། ཁོ་ལ་གནང་བའི་ཤེས་རབ་དང་ཁོས་ཅི་བྱེད་པ་དེ་ནི་ངོ་མཚར་ཅན་འདི་འདྲ་གང་ཞིག་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","མི་འདི་ནི་ཤིང་བཟོ་བ་དེ་མ་རེད་དམ། ཁོ་རང་ནི་མིར་ཡམ་གྱི་བུ་ཡིན་ཏེ། ཡ་ཀོབ་དང༌། ཡོ་སེ། ཡུ་དཱ། སི་མོན་བཅས་ཀྱི་གཅེན་པོ་མ་ཡིན་ནམ། ཁོའི་སྲིང་མོ་རྣམས་ཀྱང་ཡུལ་འདིར་ང་ཚོ་དང་མཉམ་དུ་བསྡད་ཡོད་པ་མ་ཡིན་ནམ་”ཞེས་ཟེར་ཞིང་མི་དེ་རྣམས་ཕོག་ཐུག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ཡེ་ཤུས་མི་དེ་རྣམས་ལ་“ལུང་སྟོན་པ་ལ་རང་ཡུལ་གྱི་མི་དང་གཉེན་ཉེ། རང་ཁྱིམ་ལ་མ་གཏོགས་མི་གཞན་གྱིས་གུས་པར་བྱེད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ཁོང་གིས་ས་ཆ་དེར་ནད་པ་ཁ་ཤས་ལ་ཕྱག་བཞག་ནས་ནད་སེལ་བར་མཛད་པ་མ་གཏོགས། ངོ་མཚར་གྱི་མཛད་པ་གཞན་མཛད་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","མི་དེ་རྣམས་ལ་དད་པ་མེད་པས་ཁོང་ཡང་ཡ་མཚན་སྐྱེས་ཤིང་མཐའ་འཁོར་གྱི་ཡུལ་སྡེ་ལ་ཆོས་གསུང་བར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ཡེ་ཤུས་ཉེ་གནས་བཅུ་གཉིས་པོ་རང་གི་དྲུང་དུ་བོས་ཏེ། ཁོ་ཚོར་གདོན་འདྲེ་མི་གཙང་བ་འདུལ་བའི་དབང་གནང་བ་དང་མི་གཉིས་གཉིས་ཕྱི་རུ་མངགས་ནས་ ");
INSERT INTO bod_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“ཁྱེད་ཚོ་ལམ་ལ་དབྱུག་པ་གཅིག་པུ་མ་གཏོགས་པར་གཞན་ཅི་ཡང་མ་ཁྱེར། ལམ་རྒྱགས་དང༌། ཁུག་མ། ད་དུང་སྐེ་རགས་ནང་ལའང་དངུལ་ཅི་ཡང་མ་ཁྱེར་ཞིག ");
INSERT INTO bod_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","རྐང་པ་ལ་ལྷམ་གྱོན། གོས་གཉིས་བརྩེགས་མ་གྱོན་”ཅེས་བཀའ་གནང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོ་གྲོང་ཚོ་གང་དུ་སླེབས་ནའང་མི་ཁྱིམ་ཞིག་ལ་བསྡད་ནས་ས་ཆ་དེ་ནས་ཁ་མ་བྲལ་བར་དུ་དེ་རུ་སྡོད་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ཡུལ་གང་གི་མིས་ཁྱེད་ཚོར་གནས་ཚང་མི་གཏོང་ཞིང་ཁྱོད་ཚོས་ཆོས་བསྒྲགས་པ་ལའང་མི་ཉན་ན། ཁྱེད་ཚོ་ས་ཆ་དེ་ནས་ཐོན་པའི་སྐབས་སུ། ཁོ་རྣམས་ལ་དོན་དེར་འགན་ཁུར་དགོས་པར་བདེན་དཔང་བྱེད་པའི་ཆེད་དུ་རྐང་པའི་ཐོག་གི་ས་རྡུལ་སྤྲུགས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ཉེ་གནས་ཚོས་ཕྱི་རོལ་ཏུ་སོང་ནས་མི་ཚོར་སྤྱོད་པ་ངན་པ་སྤངས་ཏེ་སེམས་བསྒྱུར་བའི་ཆོས་བསྒྲགས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","གདོན་འདྲེ་མང་པོའང་ཕྱིར་བསྐྲད་པ་དང་ནད་པ་མང་པོར་སྣུམ་བྱུགས་ཏེ་ནད་ལས་ཐར་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","དེའི་ཚེ་ཡེ་ཤུའི་མཚན་སྙན་ཡུལ་ཐམས་ཅད་ལ་ཁྱབ་པས། རྒྱལ་པོ་ཧེ་རོ་དཱེས་ཀྱང་གཏམ་དེ་ཐོས། མི་གཞན་གྱིས་“ཁོང་ནི་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གཤིན་པོ་ནས་གསོན་པོར་ལངས་སུ་གྱུར་བས། ཁོང་ལ་ནུས་མཐུ་འདི་ལྟར་ལྡན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","འོན་ཀྱང་མི་ལ་ལས་“དེ་ནི་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་རེད་”ཅེས་ཟེར་བ་དང༌། ཡང་མི་ཁ་ཤས་ཀྱིས་“ཁོང་གནའ་རབས་ཀྱི་ལུང་སྟོན་པ་རྣམས་ཀྱི་ནང་ནས་གཅིག་དང་འདྲ་བའི་ལུང་སྟོན་པ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","འོན་ཀྱང་ཧེ་རོ་དཱེས་གཏམ་དེ་ཐོས་ནས་ཁོས་“དེ་ནི་ངས་བཀའ་བསྒོས་ཏེ་མགོ་བོ་བཅད་ནས་བསད་ཟིན་པའི་ཡོ་ཧ་ནན་སླར་གསོན་པ་རེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","དེ་སྔོན་ཧེ་རོ་དཱེ་ཡིས་རང་གི་གཅུང་པོ་ཕི་ལིབ་ཀྱི་བཟའ་ཟླ་ཧེ་རོད་ཡཱ་ཟེར་བ་དེ་རང་གི་བཟའ་ཟླར་བླངས་པའི་རྐྱེན་གྱིས། ཡོ་ཧ་ནན་གྱིས་ཧེ་རོ་དཱེ་ལ་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་ཁྱེད་ཀྱིས་རང་གི་གཅུང་པོའི་བཟའ་ཟླ་ལེན་མི་ཆོག་”ཅེས་གསུངས་པ་དང༌། ཧེ་རོ་དཱེ་ཡིས་ཧེ་རོད་ཡཱའི་དོན་ལ་མི་བཏང་ནས་ཡོ་ཧ་ནན་བཟུང་སྟེ་བཙོན་ཁང་ལ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ཧེ་རོད་ཡཱ་ཡིས་འཁོན་འཛིན་བཅངས་ཏེ་ཡོ་ཧ་ནན་གསོད་པར་འདོད་ཀྱང་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","གང་ལགས་ཟེར་ན། ཧེ་རོ་དཱེས་ཡོ་ཧ་ནན་ནི་སྐྱེས་བུ་དྲང་ལྡན་དང་དམ་པ་ཞིག་ཡིན་པར་ཤེས་པས་ཁོང་ལ་བརྩི་བཀུར་བྱས་པ་དང་ཁོང་གནོད་པ་ལས་བསྲུངས། ཁོས་ཡོ་ཧ་ནན་གྱི་བསླབ་བྱ་ཉན་དུས་དོན་གསལ་པོར་མི་ཤེས་ཀྱང་ཉན་པར་དགའ། ");
INSERT INTO bod_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","མཐའ་མར་ཧེ་རོད་ཡཱ་ལ་གོ་སྐབས་རྙེད་དེ། ཧེ་རོ་དཱེའི་སྐྱེས་སྐར་གྱི་ཉིན་མོར་རང་གི་བློན་པོ་དང་དམག་དཔོན། ག་ལིལ་ཡུལ་གྱི་མི་ཆེན་ཚོར་གསོལ་སྟོན་བཤམས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ཧེ་རོད་ཡཱའི་བུ་མོའང་ནང་དུ་འོངས་ཏེ་ཞབས་བྲོ་འཁྲབ་ནས་ཧེ་རོ་དཱེ་དང་མགྲོན་པོ་རྣམས་དགའ་བར་བྱས་པས། རྒྱལ་པོས་བུ་མོ་དེ་ལ་“ཁྱོད་ལ་ཅི་འདོད་ཀྱང་ངར་ཤོད་ཅིག ངས་ཁྱོད་ལ་སྟེར་རྒྱུ་ཡིན་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ཡང་ཁོ་མོར་མནའ་བསྐྱལ་ཏེ་“ཁྱོད་ཀྱིས་ང་རང་ལ་ཇི་དང་ཇི་སློང་བ་རྒྱལ་ཁམས་ཀྱི་ཕྱེད་ཀ་ཡིན་ཡང་ཁྱོད་ལ་སྟེར་ངེས་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","དེ་ནས་བུ་མོ་དེ་ཕྱི་ལ་སོང་ནས་རང་གི་ཨ་མ་ལ་“ངས་ཅི་ཞིག་སློང་དགོས་སམ་”ཞེས་དྲིས་པ་ལ། ཁོ་མོའི་ཨ་མས་“ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་མགོ་སློངས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","དེ་མ་ཐག་བུ་མོ་དེ་ལམ་སེང་རྒྱལ་པོའི་དྲུང་དུ་ཡོང་ནས་“ངའི་རེ་བ་ལ་ད་ལྟ་མྱུར་དུ་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་མགོ་སྡེར་མའི་ནང་དུ་བཞག་ནས་ང་ལ་གནང་བར་མཛོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","དེའི་ཚེ་རྒྱལ་པོ་ཧེ་རོ་དཱེའི་སེམས་ཤིན་ཏུ་སྐྱོ་ནའང་མགྲོན་པོ་རྣམས་ཀྱི་མདུན་ལ་མནའ་བསྐྱལ་ཡོད་པས་མི་སྟེར་ཞེས་ཟེར་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","དེ་མ་ཐག་ཏུ་རྒྱལ་པོས་སྲུང་དམག་ཞིག་བཏང་ནས་“ཡོ་ཧ་ནན་གྱི་མགོ་ཁྱེར་ཤོག་”ཅེས་བཀའ་བསྒོས་ཤིང༌། སྲུང་དམག་བཙོན་ཁང་དུ་ཕྱིན་ནས་ཡོ་ཧ་ནན་གྱི་མགོ་བཅད་དེ། ");
INSERT INTO bod_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","མགོ་སྡེར་མའི་ནང་དུ་བཞག་ནས་ཁྱེར་ཡོང་སྟེ་ཁོ་མོ་ལ་སྤྲད་པ་དང༌། བུ་མོ་དེས་ཀྱང་རང་གི་ཨ་མར་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ཡོ་ཧ་ནན་གྱི་སློབ་མ་རྣམས་ཀྱིས་གཏམ་དེ་ཐོས་པས་ཚུར་ཡོང་སྟེ་ཁོང་གི་སྐུ་ཕུང་ཁུར་ནས་དུར་ཁང་དུ་བཞག ");
INSERT INTO bod_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","དེ་ནས་སྐུ་ཚབ་ཚོ་ཡེ་ཤུའི་དྲུང་དུ་འཛོམས་ཏེ། ཇི་བྱས་པ་དང་ཆོས་ཇི་བསྟན་པའི་ལོ་རྒྱུས་ཐམས་ཅད་ཁོང་ལ་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","དེ་རུ་ཕར་འགྲོ་ཚུར་འོང་གི་མི་མང་པོ་ཡོད་དེ། ཁོང་རྣམས་ལ་ཞལ་ཟས་བཞེས་ལོང་ཡང་མ་བྱུང༌། ཡེ་ཤུས་ཁོ་ཚོར་“ད་ཁྱེད་ཚོ་ཚུར་ཤོག་ལ་ངེད་དང་ལྷན་དུ་དབེན་གནས་ཤིག་ཏུ་སོང་ནས་ངལ་ཅུང་ཙམ་གསོ་བར་བྱའོ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ཁོང་རྣམས་མི་གཞན་མེད་པར་གྲུ་ལ་བཞུགས་ནས་དབེན་གནས་ཀྱི་ཕྱོགས་སུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","མི་མང་པོས་ཁོང་རྣམས་ཕེབས་བཞིན་པ་མཐོང་སྟེ། ཁོང་རྣམས་སུ་ཡིན་ཤེས་པས་གྲོང་སྡེ་ཐམས་ཅད་ནས་རྒྱུགས་ཡོང་སྟེ་ཁོང་ཚོའི་སྔོན་ལ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ཡེ་ཤུ་གྲུ་ལས་བབས་དུས་མི་ཚོགས་མང་པོ་ནི་རྫི་བོ་མེད་པའི་ལུག་དང་འདྲ་བར་འདུག་པ་གཟིགས་པས། ཐུགས་བརྩེ་བའི་ངང་ནས་དེ་ཚོར་ཆོས་མང་པོ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ཉི་མ་ནུབ་ལ་ཉེ་བའི་དུས་སུ། ཉེ་གནས་ཚོ་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་“ས་ཆ་འདི་དབེན་སྟོང་ཡིན་ཞིང་ཉི་མ་ཡང་ནུབ་ལ་ཉེ་བས། ");
INSERT INTO bod_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ཁོ་ཚོ་མཐའ་འཁོར་གྱི་ཡུལ་སྡེ་རྣམས་ལ་རང་རང་གི་ཟས་ཉོ་རུ་གཏོང་བར་མཛོད་”ཅེས་ཁོང་ལ་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོས་ཁོ་ཚོར་ཟས་སྟེར་ཅིག་”ཅེས་གསུངས། ཁོ་ཚོས་“ང་ཚོ་སོང་ནས་དེ་ཎ་རིའི་དངུལ་སྒོར་ཉིས་བརྒྱ་བཏང་སྟེ་བག་ལེབ་ཉོས་ནས་ཁོ་རྣམས་ལ་སྟེར་བར་བྱའམ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ཁོང་གིས་“ཁྱེད་རྣམས་སོང་ནས་བག་ལེབ་ཇི་ཙམ་ཡོད་པ་ལྟོས་དང་”ཞེས་གསུངས་པ་དང༌། ཉེ་གནས་ཚོས་ཤེས་རྗེས་ཁོང་ལ་“བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་འདུག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","དེ་ནས་ཡེ་ཤུས་ཉེ་གནས་ཚོ་ལ་མི་ཚོ་ཚོགས་པ་ཚོགས་པ་བྱས་ཏེ་སྤང་གི་སྟེང་ལ་སྡོད་འཇུག་པའི་བཀའ་གནང་ནས། ");
INSERT INTO bod_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","མི་ཚོགས་བརྒྱ་རེའམ་ལྔ་བཅུ་རེ་བྱས་ནས་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ཡེ་ཤུས་བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་པོ་ཕྱག་ཏུ་བསྣམས་ཏེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་ཡར་གཟིགས་ཤིང་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས། བག་ལེབ་དུམ་བུར་མཛད་ནས་ཉེ་གནས་ཚོ་ལ་གནང་སྟེ་མི་ཚོགས་ལ་བགོ་རུ་བཅུག ཉ་ཤ་གཉིས་པོའང་ཁོང་གིས་བག་ལེབ་བགོས་པ་བཞིན་དུ་མཛད་ནས་ཉེ་གནས་ཚོས་ཀྱང་མི་ཚོགས་ཐམས་ཅད་ལ་བྱིན་པས། ");
INSERT INTO bod_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","མི་ཚང་མས་བཟས་ནས་ཚིམས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","དེ་ནས་ཉེ་གནས་ཚོས་བག་ལེབ་དང་ཉ་ཤའི་ཟས་ལྷག་བསྡུས་ནས་སླེ་པོ་བཅུ་གཉིས་བཀང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","བག་ལེབ་ཟ་མཁན་ནང་ལ་སྐྱེས་པ་ཁོ་ན་ལྔ་སྟོང་ཙམ་ཡོད་པ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","དེ་མ་ཐག་ཡེ་ཤུས་ཉེ་གནས་རྣམས་གྲུ་ལ་སྡོད་དུ་བཅུག་སྟེ། ཁོང་གི་སྔོན་དུ་ཆུའི་ཕ་རོལ་གྱི་གྲོང་སྡེ་པེ་སད་དཱ་ཞེས་བྱ་བར་སོང་ཞིག་ཅེས་གསུངས་ནས་མི་ཚོགས་ཕར་བཏང་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","དེ་ནས་ཡེ་ཤུ་ཁོ་ཚོ་དང་ཁ་བྲལ་རྗེས་ཁོང་གསོལ་བ་སྨོན་ལམ་འདེབས་པའི་ཕྱིར་རི་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","དགོང་མོ་ཟིན་དུས། གྲུ་དེ་མཚོའི་དཀྱིལ་དུ་སླེབས་ཤིང༌། ཡེ་ཤུ་གཅིག་པུ་སྐམ་སར་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","གྲུའི་མདུན་ཕྱོགས་ནས་ལྷགས་པ་བརྒྱབ་པས་ཉེ་གནས་ཚོས་གྲུའི་སྐྱ་བ་རྒྱག་པ་ལ་དཀའ་ལས་བྱུང་བ་ཁོང་གིས་གཟིགས་ནས། མཚན་མོ་ཐུན་བཞི་པ་ཙམ་ལ་མཚོའི་སྟེང་ལ་ཁོ་ཚོའི་རྩར་ཞབས་འཆག་ཅིང་ཁོ་ཚོའི་འཁྲིས་ནས་འགྲོ་བར་དགོངས་བཞིན་པའི་སྐབས་སུ། ");
INSERT INTO bod_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ཉེ་གནས་ཀྱིས་ཚུལ་དེ་མཐོང་ནས་གདོན་འདྲེ་ཡིན་པར་བསམས་ཏེ་སྐད་ངན་ཤོར། ");
INSERT INTO bod_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","གང་ཡིན་ཟེར་ན། ཉེ་གནས་ཚང་མས་ཁོང་མཐོང་བ་ཙམ་གྱིས་འཇིགས་ཤིང་སྐྲག་པར་གྱུར། ཡེ་ཤུས་ལམ་སེང་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོའི་སེམས་བདེ་བར་བྱོས། ང་རང་ཡིན་པས་འཇིགས་མི་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ཁོང་གྲུའི་ནང་དུ་ཕེབས་པ་དང་ལྷགས་པ་འཇགས་པས། ཉེ་གནས་རྣམས་ཀྱི་སེམས་སུ་ངོ་མཚར་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ཅི་ལགས་ཟེར་ན། ཁོ་ཚོས་བག་ལེབ་ཀྱི་དོན་ཧ་མ་གོ་སྟེ། ཁོ་ཚོའི་སེམས་མཁྲེགས་པོ་ཡིན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ཁོང་རྣམས་མཚོ་ག་ལིལ་བརྒལ་ནས་གན་ནེ་སཱ་རེལ་ཞེས་པའི་ས་ཆར་སླེབས་ཏེ་གྲུ་མཚོའི་འགྲམ་དུ་ཐག་པས་བཏགས་ནས་བཞག ");
INSERT INTO bod_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","གྲུ་ནས་བབས་མ་ཐག་མི་རྣམས་ཀྱིས་ཡེ་ཤུ་ངོ་ཤེས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ཁོང་གང་དུ་བཞུགས་པ་ཐོས་རྗེས། མཐའ་སྐོར་གྱི་ཡུལ་ཐམས་ཅད་བརྒྱུད་ནས་རྒྱུགས་ཏེ་ནད་པ་རྣམས་ཉལ་ཁྲིའི་སྟེང་ལ་ཁུར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","གྲོང་སྡེའམ་ཡང་ན་གྲོང་ཁྱེར། གྲོང་གསེབ་བཅས་ས་ཆ་གང་དུ་ཕེབས་ནའང༌། མི་ཚོས་ནད་པ་རྣམས་ཁྲོམ་ལ་བཞག་སྟེ། ཡེ་ཤུ་ལ་ཁོང་གི་ན་བཟའི་ཟུར་ཁོ་ནར་རེག་ཏུ་གནང་ཞེས་ཞུ་བ་ཕུལ་བས། ཁོང་གི་ན་བཟའ་ལ་རེག་པའི་ནད་པ་ཐམས་ཅད་ནད་ལས་ཐར་བར་གྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","དེའི་ཚེ་ཕཱ་རུ་ཤི་པ་རྣམས་དང་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ནས་འོངས་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁག་ཅིག་ཡེ་ཤུའི་དྲུང་དུ་འདུས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ཁོ་ཚོས་ཉེ་གནས་ཚོའི་ནང་ནས་འགའ་ཞིག་གིས་ཆོས་ཀྱི་ལུགས་སྲོལ་དང་མི་མཐུན་པར་ལག་པ་མི་གཙང་བའམ་མ་བཀྲུས་པར་ཟས་ཟ་བཞིན་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(ཕཱ་རུ་ཤི་པ་དང་བཅས་པའི་ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཐམས་ཅད་ཀྱིས་གནའ་མིའི་ལུགས་སྲོལ་སྲུང་ཞིང་རང་གི་ལག་པ་མ་ཁྲུས་པར་ཟས་མི་ཟ། ");
INSERT INTO bod_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ཁྲོམ་ནས་ཕྱིར་ལོག་རྗེས་ཁྲུས་མ་བྱས་པར་ཅི་ཡང་མི་ཟ། ད་དུང་ལུགས་སྲོལ་གཞན་ཡང་མང་པོ་ཡོད་དེ། ཁོ་ཚོས་མི་རབས་ནས་མི་རབས་བར་དུ། ཕོར་པ་དང་བུམ་པ། ཟངས་སྣོད་འཁྲུད་པ་ལ་སོགས་པའི་ལུགས་སྲོལ་མང་པོ་སྲུང་དགོས་པ་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","དེ་ནས་ཕཱ་རུ་ཤི་པ་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་ཡེ་ཤུ་ལ་“ཁྱེད་ཀྱི་ཉེ་གནས་ཀྱིས་ཅིའི་ཕྱིར་གནའ་མིའི་ལུགས་སྲོལ་མི་སྲུང་བར་ལག་པ་མི་གཙང་ནའང་ཟའམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ཡེ་ཤུས་དེ་རྣམས་ལ་“ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད་ཚོའི་སྐོར་ལ་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་ལེགས་པར་གསུངས་ཏེ། མི་རྒྱུད་འདི་ཡིས་ངག་ནས་ང་བཀུར་ཡང༌། ། ཁོ་ཡི་སེམས་ནི་ང་དང་ཡོངས་སུ་བྲལ། ། ");
INSERT INTO bod_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","མི་ཡིས་བརྩམས་པའི་བསླབ་བྱ་རང་ལ་སྟོན། ། དེ་འདྲའི་བསྙེན་བཀུར་ང་ལ་བྱེད་དོན་མེད། ། ཅེས་ལུང་བསྟན་པ་ལྟར། ");
INSERT INTO bod_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ཁྱོད་ཚོས་དཀོན་མཆོག་གི་བཀའ་སྤངས་ནས་མིའི་ལུགས་སྲོལ་སྲུང་བཞིན་འདུག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“ཁྱོད་ཚོས་རང་གི་གཏམ་རྒྱུད་སྲུང་བའི་ཕྱིར་དཀོན་མཆོག་གི་བཀའ་རྣམས་སྤང་བ་ལ་མཁས། ");
INSERT INTO bod_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","དེ་ཡང་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་གསུངས་པ་ལྟར་རང་གི་ཕ་མ་གཉིས་ལ་བརྩི་བཀུར་གྱིས་ཞེས་དང༌། ཡང་ཕ་མ་ལ་ཚིག་ངན་སྨྲ་མཁན་དེ་སྲོག་གཅོད་པར་འགྱུར་དགོས་ཞེས། ");
INSERT INTO bod_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ཡིན་ནའང་ཁྱོད་ཚོས་གལ་ཏེ་མི་ཞིག་གིས་རང་གི་ཕ་མ་ལ། ངས་ཁྱེད་ལ་ཕན་ཐོགས་འབྱུང་རྒྱུ་ཡིན་པ་འདི་ནི་ཁཱོར་པན་ཡིན་བཤད་ན། (ཁཱོར་པན་ཟེར་ན་དཀོན་མཆོག་ལ་མཆོད་པ་ཕུལ་ཆེད་དུ་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ཁྱོད་ཚོས་མི་དེ་རང་གི་ཕ་མ་ལ་དེ་ཕྱིན་ཆད་གཉེར་སྐྱོང་བྱེད་དུ་མི་འཇུག ");
INSERT INTO bod_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ཁྱོད་ཚོས་གཏད་པའི་གཏམ་རྒྱུད་ཀྱི་ཐོག་ནས་དཀོན་མཆོག་གི་བཀའ་རྩིས་མེད་བཏང༌། དེ་དང་འདྲ་བའི་བྱ་བ་གཞན་ཡང་མང་པོ་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","དེ་ནས་ཡང་ཡེ་ཤུས་མི་ཚོགས་རང་གི་དྲུང་དུ་བོས་ནས་“ཁྱེད་ཚོ་ཚང་མ་ང་ལ་ཉན་ནས་ཧ་གོ་བར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ཕྱི་ནས་ཁོག་པའི་ནང་ཞུགས་པ་དེས་མི་མི་གཙང་བར་བྱེད་མི་ཐུབ། ཡིན་ན་ཡང་མིའི་ཡིད་ནང་ནས་ཕྱིར་གང་འཐོན་པ་དེས་མི་མི་གཙང་བར་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","དེ་ནས་ཁོང་མི་ཚོགས་དང་ཁ་བྲལ་ནས་ཁང་པའི་ནང་དུ་འཛུལ། དེ་དུས་ཉེ་གནས་རྣམས་ཀྱིས་དཔེ་དེའི་དོན་བཀའ་འདྲི་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ཁོང་གིས་“ཁྱོད་ཚོས་དེའི་སྐོར་ཡང་ཤེས་ཀྱི་མེད་དམ། ཕྱི་རོལ་ནས་ནང་དུ་འཛུལ་བའི་ཟས་དེས་མི་མི་གཙང་བར་བྱེད་མི་ཐུབ་པ་དེ་ཁྱོད་ཚོས་ཧ་མི་གོའམ། ");
INSERT INTO bod_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","གང་ཡིན་ཟེར་ན། དེ་ནི་མིའི་སེམས་ཀྱི་ནང་དུ་མི་འགྲོ་བར་གྲོད་པའི་ནང་དུ་འགྲོ དེ་ནས་ཕྱིར་འཐོན་”ཞེས་གསུངས། (ཡེ་ཤུས་གསུངས་པའི་དོན་དེ་ནི་ཟས་ཐམས་ཅད་གཙང་མ་ཡིན་པར་བསྟན་) ");
INSERT INTO bod_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ཁོང་གིས་ད་དུང་གསུངས་པར་“མིའི་ཡིད་ནང་ནས་ག་རེ་འཐོན་པ་དེས་མི་མི་གཙང་བར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","རྒྱུ་མཚན་ནི། མིའི་ཡིད་ནང་ནས་བསམ་པ་ངན་པ་དང༌། འདོད་ལོག་སྤྱོད་པ། རྐུ་བ། མི་སྲོག་གཅོད་པ། ");
INSERT INTO bod_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ལོག་གཡེམ། སེར་སྣ། གནོད་སེམས། མགོ་སྐོར། འདོད་ཆགས། ཕྲག་དོག དམའ་འབེབས་གཏོང་བ། ང་རྒྱལ། དཀོན་མཆོག་གི་བཀའ་དོར་བ་སོགས། ");
INSERT INTO bod_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ངན་པ་དེ་ཚོ་ཐམས་ཅད་མིའི་ནང་ནས་ཕྱིར་འཐོན་ཏེ་མི་མི་གཙང་བར་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","དེ་ནས་ཡེ་ཤུ་ཡར་བཞེངས་ནས་ཡུལ་ཐཱ་ཨེར་དང་ཚི་དོན་ཞེས་པའི་གྲོང་ཁྱེར་ལ་ཕེབས་ཤིང༌། ཁོང་ཁྱིམ་ཚང་ཞིག་གི་ནང་ལ་ཕེབས་ནས་མི་གཞན་སུ་ལའང་ཤེས་སུ་མི་འཇུག་དགོངས་ཀྱང་གསང་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","དེའི་དུས་སུ་བུད་མེད་ཅིག་ཡོད་པ་དེའི་བུ་མོ་ཆུང་ངུ་གདོན་འདྲེ་མི་གཙང་བ་ཡིས་བཟུང་ཡོད་པས། བུད་མེད་དེས་ཡེ་ཤུའི་གནས་ཚུལ་ཐོས་ནས་ཁོང་གི་མདུན་དུ་ཡོང་སྟེ་པུས་མོ་ས་ལ་བཙུགས་ནས་ཕྱག་འཚལ། ");
INSERT INTO bod_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ཁོ་མོ་ནི་སི་རུ་ཕེ་ནི་ཀེ་ཡུལ་ནས་ཡིན་པའི་གྷི་རིག་མི་རིགས་ཀྱི་བུད་མེད་ཅིག་ཡིན་ཞིང༌། ཁོ་མོས་ཡེ་ཤུ་ལ་གདོན་འདྲེ་དེ་བུ་མོ་ལས་ཕར་སྐྲོད་པར་མཛོད་ཅེས་ཞུ་བ་ཡང་ཡང་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ཡེ་ཤུས་“སྔོན་ལ་ཕྲུ་གུ་རྣམས་ཀྱི་གྲོད་ཁོག་འགྲང་དུ་ཆུག ཕྲུ་གུའི་ཟས་སྐལ་ཁྱི་ལ་སྟེར་བར་མི་རུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ཡང་ཁོ་མོས་“ལགས་སོ། སྟོན་པ་ལགས། ཡིན་ནའང་ཅོག་ཙེའི་འོག་ལ་ཡོད་པའི་ཁྱིས་ཀྱང་ཕྲུ་གུའི་ཟས་སར་ཟགས་པ་རྣམས་ཟའོ་”ཞེས་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ཡང་ཡེ་ཤུས་“ཁྱོད་ཀྱིས་སྐད་ཆ་འདི་སྐད་སྨྲས་པའི་རྐྱེན་གྱིས་ཁྱོད་ཕྱིར་སོང་དང༌། གདོན་འདྲེ་དེ་ཁྱོད་ཀྱི་བུ་མོའི་གཟུགས་ནས་ཐོན་ཚར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","བུད་མེད་དེ་རང་གི་ཁང་པ་ལ་ལོག་སོང་བ་དང༌། གདོན་ཐོན་ཚར་ནས་བུ་མོ་དེ་ཉལ་ཁྲིའི་སྟེང་ལ་ཉལ་འདུག་པ་མཐོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","དེ་ནས་ཡེ་ཤུ་ཐཱ་ཨེར་གྱི་ཡུལ་ནས་ཚི་དོན་ཡུལ་སྡེ་བརྒྱུད་ནས། མཚོ་ག་ལིལ་གྱི་ཕྱོགས་སུ་དེ་ཁ་པོ་ལེ་ཡུལ་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","མི་འགའ་ཞིག་གིས་རྣ་བ་འོན་ཞིང་སྐད་ཆ་ཡག་པོ་ཤོད་མི་ཐུབ་པའི་མི་ཞིག་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་ཡོང་སྟེ། ཁོང་ལ་མི་དེའི་ལུས་སྟེང་ལ་ཕྱག་འཇོག་པར་ཞུ་བ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ཡེ་ཤུས་མི་དེ་མི་ཚོགས་ཀྱི་ཁྲོད་ནས་ཟུར་དུ་ཁྲིད་དེ། ཁོང་གིས་ཕྱག་མཛུབ་ཁོའི་རྣ་བ་གཉིས་ལ་བཅུག་ཅིང་ལྗགས་ཆུ་གཏོར་ནས་ཁོའི་ལྕེ་ལ་རེག་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ཡང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་ཡར་གཟིགས་ཤིང་དབུགས་རིང་ཕྱུང་སྟེ་མི་དེ་ལ་“ཨེ་ཕ་ཐ་”ཞེས་གསུངས། དེའི་དོན་ནི་ཕྱེ་བར་གྱུར་ཞིག་ཅེས་པའོ། ");
INSERT INTO bod_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","དེ་མ་ཐག་མི་དེའི་རྣ་བ་ཕྱེ་ཞིང་ལྕེའི་འཆིང་བ་ཡང་གྲོལ་ཏེ་སྐད་ཆ་གསལ་པོར་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","དེ་ནས་ཡེ་ཤུས་ཁོ་ཚོར་དོན་འདི་མི་གཞན་སུ་ལའང་མ་ཤོད་ཅིག་ཅེས་བཀའ་གནང༌། འོན་ཀྱང་ཁོང་གིས་ཇི་ལྟར་བཀའ་གནང་ཡང་མི་དེ་ཚོས་དེ་བས་ཀྱང་མི་ཀུན་ལ་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","མི་ཚོགས་རྣམས་ཤིན་ཏུ་ངོ་མཚར་བར་གྱུར་ནས་“ཁོང་གིས་ཐམས་ཅད་ལེགས་པར་མཛད་དེ། ཐ་ན་འོན་པ་རྣམས་ལ་ཐོས་པར་མཛད་ཅིང་སྐད་ཆ་ཤོད་མི་ཐུབ་པ་རྣམས་ཀྱང་བཤད་ཐུབ་པར་མཛད་”ཅེས་སྨྲས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","དེའི་དུས་སུ། ཡང་བསྐྱར་མི་མང་པོ་ཞིག་དེར་འདུས་ཏེ། ཁོ་ཚོར་ཟ་རྒྱུ་ཅི་ཡང་མེད་པས་ཡེ་ཤུས་ཁོང་གི་ཉེ་གནས་ཚོ་བོས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“མི་ཚོགས་འདི་ང་དང་མཉམ་དུ་བསྡད་ནས་ཉིན་ཞག་གསུམ་སོང་ཞིང༌། ད་ཆ་ཟས་ཅི་ཡང་མེད་པས་ཁོ་ཚོ་སྙིང་རྗེ་བར་འདུག ");
INSERT INTO bod_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ཁོ་ཚོའི་ནང་ནས་མི་ཁ་ཤས་རྒྱང་རིང་ནས་ཡོང་བས། གལ་ཏེ་ངས་ཁོ་ཚོ་གྲོད་པ་སྟོང་བར་ལོག་ཏུ་བཅུག་ན། ལམ་བར་དུ་བཀྲེས་ཤིང་ལྟོགས་ཏེ་དྲན་མེད་དུ་བརྒྱལ་བར་ངེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ཉེ་གནས་ཚོས་ཁོང་ལ་“མི་འདི་རྣམས་འགྲང་བར་བྱེད་པའི་བག་ལེབ་ནི་དབེན་སྟོང་འདི་རུ་ག་ནས་རྙེད་ཐུབ་བམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ཡེ་ཤུས་“ཁྱེད་ཚོར་བག་ལེབ་ཅི་ཙམ་ཡོད་”ཅེས་བཀའ་འདྲི་གནང་བས། ཁོ་ཚོས་“བདུན་ཡོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","དེ་ནས་ཁོང་གིས་མི་ཚོགས་ལ་བཀའ་གནང་ནས་ས་ལ་སྡོད་དུ་བཅུག བག་ལེབ་བདུན་པོ་ཕྱག་ཏུ་བསྣམས་ཏེ་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས། བག་ལེབ་དུམ་བུར་བྱས་ནས་ཉེ་གནས་རྣམས་ལ་སྤྲད་ཅིང་ཁོ་ཚོས་མི་ཚོགས་ལ་བྱིན། ");
INSERT INTO bod_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ཡང་ཉ་ཤ་ཆུང་ངུ་ཁ་ཤས་ཡོད་པ་ཡེ་ཤུས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་པའི་རྗེས་ལ་དེ་ཡང་བག་ལེབ་བགོས་པ་བཞིན་དུ་མཛད་ནས་མི་ཚོགས་ལ་སྟེར་བའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","དེ་ནས་མི་ཚོགས་ཚང་མས་བཟས་ནས་འགྲངས་ཤིང་ཁོ་ཚོས་ཟས་ལྷག་བསྡུ་གསོག་བྱས་པ་སླེ་པོ་བཀང་བ་བདུན་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","དེར་མི་སྟོང་ཕྲག་བཞི་ཙམ་ཡོད་པ་ཡིན། ཡང་ཁོང་གིས་མི་དེ་ཚོ་འགྲོ་རུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","དེ་མ་ཐག་ཁོང་ཉེ་གནས་རྣམས་དང་མཉམ་དུ་གྲུ་ལ་བཞུགས་ནས་དཱལ་མ་ནུ་ཐ་ཞེས་བྱ་བའི་ཡུལ་ཕྱོགས་སུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","དེའི་ཚེ་ཕཱ་རུ་ཤི་པ་རྣམས་འོངས་ནས་ཡེ་ཤུ་ལ་རྩོད་གླེང་བྱས་ཤིང༌། ཁོང་ལ་དཀོན་མཆོག་ནས་མངགས་པ་ཡིན་པའི་རྟགས་ཤིག་བསྟན་དུ་གསོལ་ཞུས་ནས་ཉམས་ཚོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ཡེ་ཤུས་རང་གི་ཐུགས་ནས་དབུགས་རིང་ཕྱུང་སྟེ་“མི་རབས་འདིས་ངོ་མཚར་བའི་རྟགས་ཤིག་ཅིའི་ཕྱིར་འཚོལ། ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། མི་རབས་འདི་ལ་རྟགས་སྟོན་པར་མི་འགྱུར་རོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ཡེ་ཤུ་ཁོ་ཚོ་བཞག་ནས་ཡང་བསྐྱར་གྲུ་ལ་བཞུགས་ཏེ་མཚོ་ག་ལིལ་གྱི་ཕ་རོལ་ཏུ་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ཉེ་གནས་རྣམས་ཀྱིས་ལམ་རྒྱགས་འཁྱེར་རྒྱུ་བརྗེད་སོང་བས། གྲུའི་ནང་དུ་བག་ལེབ་གཅིག་ལས་གཞན་ཟས་ཅི་ཡང་མེད། ");
INSERT INTO bod_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","དེ་ནས་ཡེ་ཤུས་“ཁྱེད་ཚོས་བློ་རིག་བསྒྲིམས་ནས་ཕཱ་རུ་ཤི་པ་དང་ཧེ་རོ་དཱེ་ཡི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་གྱིས་ཤིག་”ཅེས་བཀའ་གནང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ཉེ་གནས་རྣམས་ཀྱིས་ཕན་ཚུན་ལ་“འདི་ནི་ང་ཚོར་བག་ལེབ་མེད་པའི་ཕྱིར་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ཡེ་ཤུས་དེ་མཁྱེན་ནས་ཁོ་ཚོར་“ཁྱོད་ཚོས་ཅིའི་ཕྱིར་བག་ལེབ་མེད་པའི་གཏམ་གླེང་བ་ཡིན་ནམ། ཁྱོད་ཚོས་ད་དུང་ཡང་མི་ཤེས་ལ་ཧ་མི་གོའམ། ཁྱོད་ཚོའི་སེམས་མཁྲེགས་པོར་གྱུར་བ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ཁྱོད་ཚོར་མིག་ཡོད་ཀྱང་མི་མཐོང་ངམ། རྣ་བ་ཡོད་ཀྱང་མི་ཐོས་སམ། ཁྱོད་ཚོས་ཅི་ཡང་མི་དྲན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ངས་བག་ལེབ་ལྔ་མི་ལྔ་སྟོང་ལ་བགོས་པའི་སྐབས་ཁྱོད་ཚོས་ཟས་ལྷག་སླེ་པོ་ཅི་ཙམ་བསྡུ་གསོག་བྱས་སམ་”ཞེས་དྲིས་པ་ལ། ཁོ་ཚོས་“བཅུ་གཉིས་སོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ཡང་བག་ལེབ་བདུན་མི་བཞི་སྟོང་ལ་བགོས་པའི་དུས་ཁྱོད་ཚོས་ཟས་ལྷག་སླེ་པོ་ཅི་ཙམ་བསྡུ་གསོག་བྱས་སམ་”ཞེས་དྲིས་ཤིང༌། ཁོ་ཚོས་“བདུན་ནོ་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ཡེ་ཤུས་“ཁྱོད་ཚོས་ད་དུང་མི་ཤེས་སམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","དེ་ནས་ཁོང་རྣམས་པེ་སད་དཱ་ཞེས་བྱ་བའི་གྲོང་སྡེ་ལ་ཕེབས་པ་དང༌། མི་འགའ་ཞིག་གིས་ལོང་བ་ཞིག་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་ཡོང་སྟེ། ཁོང་ལ་ཕྱག་གིས་རེག་པའི་ཞུ་བ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ཁོང་གིས་ལོང་བ་དེའི་ལག་པ་ནས་འཇུས་ཏེ་གྲོང་ཚོའི་ཕྱི་རོལ་ཏུ་ཁྲིད་ཅིང༌། དེའི་མིག་གཉིས་ལ་ལྗགས་ཆུ་གཏོར་བ་དང༌། ཁོང་གིས་ཕྱག་ཟུང་མི་དེ་ལ་བཞག་སྟེ་“ཁྱེད་ཀྱི་མིག་གིས་མཐོང་གི་འདུག་གམ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","མི་ལོང་བ་དེས་ཡར་བལྟས་ཏེ་“ངས་མི་རྣམས་མཐོང༌། འོན་ཀྱང་ཁོ་ཚོ་ཤིང་འགྲོ་བཞིན་པ་ལྟར་མཐོང་གི་འདུག་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","དེ་ནས་ཡེ་ཤུས་ཡང་བསྐྱར་མི་དེའི་མིག་ལ་བཞག་པ་དང༌། ཁོས་མིག་ནན་གྱིས་བལྟས་ནས་མིག་ཟུང་གསོས་ཏེ་དངོས་པོ་ཐམས་ཅད་གསལ་པོར་མཐོང་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ཡང་ཡེ་ཤུས་མི་དེ་རང་ཁྱིམ་དུ་འགྲོ་རུ་བཅུག་སྟེ་“གྲོང་སྡེ་འདིའི་ནང་དུ་ཡང་བསྐྱར་མ་འགྲོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ཡང་ཡེ་ཤུ་རང་གི་ཉེ་གནས་རྣམས་དང་མཉམ་དུ་སེ་སར་རེ་ཡཱ་ཕི་ལིབ་པཱི་ཞེས་པའི་ཡུལ་གྱི་གྲོང་སྡེ་རྣམས་ལ་ཕེབས་ཏེ་ལམ་བར་དུ་ཉེ་གནས་ཚོར་“མི་རྣམས་ཀྱིས་ང་རང་སུ་རེད་ཅེས་བཤད་བཞིན་ཡོད་དམ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ཁོ་རྣམས་ཀྱིས་“མི་ལ་ལས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་དང༌། ལ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ། ཡང་མི་ལ་ལས་ལུང་སྟོན་པའི་ནང་གི་གཅིག་རེད་ཅེས་ཟེར་”ཞེས་ཞུས་ ");
INSERT INTO bod_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“འོ་ན་ཁྱེད་ཚོས་བྱས་ན་ང་རང་སུ་ཡིན་ཟེར་”ཞེས་གསུངས་པས་ལན་དུ། པེ་ཏྲོས་“ཁྱེད་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ནོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“དོན་འདི་མི་གཞན་ལ་མ་ཤོད་”ཅེས་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","དེ་ནས་ཁོང་གིས་ཉེ་གནས་ཚོར་མིའི་རིགས་ཀྱི་བུ་ནི་ངེས་པར་དུ་སྡུག་བསྔལ་མང་པོ་མྱོང་ཞིང༌། ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒན་པོ་དང་བླ་ཆེན་རྣམས། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མིས་ཁོ་རང་དོར་ནས་གསོད་པར་འགྱུར་ལ། ཡང་ཉིན་གསུམ་གྱི་རྗེས་འཆི་བ་ནས་སླར་གསོན་པར་ལང་ངོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ཁོང་གིས་བཀའ་དེ་གསལ་པོར་གསུངས་ཤིང༌། པེ་ཏྲོས་ཁོང་ཟུར་དུ་ཁྲིད་ནས་གཤེ་གཤེ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","འོན་ཀྱང་ཡེ་ཤུས་ཞལ་ཕྱིར་སྐོར་ཏེ་ཉེ་གནས་ཚོར་གཟིགས་ནས་པེ་ཏྲོ་ལ་བཀའ་བཀྱོན་གནང་སྟེ་“བདུད་སཱ་ཏན་ཁྱོད། ངའི་རྒྱབ་ཏུ་སོང་ཞིག ཁྱོད་ཀྱི་བསམ་པ་དཀོན་མཆོག་བཞིན་མ་ཡིན་པར་མི་བཞིན་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ཁོང་གིས་མི་ཚོགས་དང་ཉེ་གནས་རྣམས་རང་གི་དྲུང་དུ་བོས་ནས་“གལ་ཏེ་མི་སུ་ཞིག་ང་ཡི་རྗེས་སུ་འབྲང་འདོད་ན། རང་ཉིད་དོར་ནས་རང་གི་རྒྱང་ཤིང་འཁུར་ཏེ་ང་ཡི་རྗེས་སུ་འབྲང་དགོས། ");
INSERT INTO bod_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","མི་སུས་ཀྱང་རང་གི་སྲོག་ཐར་བར་བྱེད་འདོད་པ་དེས་བརླག་པར་འགྱུར། མི་སུས་ཀྱང་ང་རང་དང་འཕྲིན་བཟང་གི་དོན་དུ་རང་གི་སྲོག་གཏོང་པ་དེས་ཐར་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","མི་སུ་ལ་འཇིག་རྟེན་ཧྲིལ་པོ་ཐོབ་ཀྱང་རང་སྲོག་བརླགས་ན་ཅི་ཕན། ");
INSERT INTO bod_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ཡང་ན་མིས་རང་གི་སྲོག་ཅི་དང་བརྗེའམ། ");
INSERT INTO bod_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ལོག་གཡེམ་ཅན་དང་སྡིག་སྤྱོད་ཀྱི་མི་རབས་འདི་ལས་མི་སུ་ཞིག་གིས་ང་དང་ངའི་བཀའ་ངོ་ཚ་བའི་རྒྱུར་བརྩིས་ན། མིའི་རིགས་ཀྱི་བུ་ཡང་ཡབ་དཀོན་མཆོག་གི་གཟི་བརྗིད་ལས་དམ་པའི་ཕོ་ཉ་འཁོར་དང་བཅས་པ་འཇིག་རྟེན་དུ་ཕེབས་དུས། མི་དེ་ཡང་ངོ་ཚ་བའི་རྒྱུར་བརྩི་བར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ཡང་ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། འདི་རུ་ལངས་ནས་སྡོད་པའི་མི་རྣམས་ཀྱི་ནང་ནས་འགའ་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དབང་ཆ་ཆེན་པོའི་སྒོ་ནས་འོང་ཚར་བ་མ་མཐོང་བའི་བར་དུ་ཅི་ནས་ཀྱང་འཆི་བ་མྱོང་བར་མི་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ཉི་མ་དྲུག་གི་རྗེས་ལ་ཡེ་ཤུས་པེ་ཏྲོ་དང་ཡ་ཀོབ། ཡོ་ཧ་ནན་གསུམ་ཁྲིད་ནས་དབེན་པའི་ཡུལ་གྱི་རི་མཐོ་པོ་ཞིག་ལ་ཕེབས། དེ་ནས་ཁོང་ཚོའི་མདུན་དུ་ཁོང་གི་སྐུའི་རྣམ་པ་གྱུར་ཅིང༌། ");
INSERT INTO bod_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ཁོང་གི་ན་བཟའ་འོད་འཕྲོ་བའི་ཚོན་མདོག་ཧ་ཅང་དཀར་བ། འཇིག་རྟེན་འདིའི་སྟེང་སུས་ཀྱང་དེ་ལྟར་བཟོ་མི་ཐུབ་པའི་དཀར་པོ་ཞིག་ཏུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","དེའི་སྐབས་ལ་ཁོང་ཚོའི་མདུན་དུ་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་དང་མོ་ཤེ་གཉིས་མངོན་སུམ་དུ་བྱོན་ནས་ཡེ་ཤུ་དང་བཀའ་མོལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","པེ་ཏྲོས་ཡེ་ཤུ་ལ་“རབ་བི། ང་ཚོ་འདིར་བསྡད་ན་ལེགས། ང་ཚོས་བཞུགས་ས་གསུམ་བཟོ་བར་བྱ། ཁྱེད་ལ་གཅིག་དང་མོ་ཤེ་ལ་གཅིག ཨེ་ལི་ཡཱ་ལ་གཅིག་བཅས་ཡིན་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","པེ་ཏྲོས་ཇི་ལྟར་ཞུ་དགོས་མིན་མ་ཤེས། གང་ཡིན་ཟེར་ན། ཁོ་ཚོ་ཧ་ཅང་སྐྲག་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","དེ་ནས་སྤྲིན་པ་ཞིག་ཡོང་ནས་ཁོང་ཚོ་བསྒྲིབས་པ་དང༌། སྤྲིན་པ་ནས་གསུང་ཞིག་བྱུང་སྟེ་“འདི་ནི་ངའི་གཅེས་པའི་སྲས་ཡིན། ཁོང་ལ་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ཁོ་ཚོས་དུས་དེ་ཉིད་དུ་ཕར་ཚུར་བལྟས་པས་ཡེ་ཤུ་གཅིག་པུ་མ་གཏོགས་གཞན་སུ་ཡང་མ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","དེ་ནས་ཁོང་རྣམས་རི་བོ་ལས་མར་འབབ་པའི་དུས་སུ། ཡེ་ཤུས་“མིའི་རིགས་ཀྱི་བུ་གཤིན་པོའི་ཁྲོད་ནས་མ་ལང་བའི་བར་དུ་ཁྱེད་ཚོས་གང་མཐོང་བ་དེ་མི་གཞན་སུ་ལའང་མ་ཤོད་ཅིག་”ཅེས་བཀའ་བསྒོས། ");
INSERT INTO bod_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་གི་བཀའ་སེམས་ལ་བཞག་ནས། ཁོང་གཤིན་པོའི་ཁྲོད་ནས་ལང་བ་ཞེས་པའི་དོན་ཅི་ཡིན་པ་གཅིག་གིས་གཅིག་ལ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ཁོ་ཚོས་“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་སྐྱབས་མགོན་མཱ་ཤི་ཀའི་སྔོན་ལ་འབྱོན་ངེས་ཡིན་ཟེར་དོན་ཅི་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ཁོང་གིས་“ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་དངོས་སུ་སྔོན་ལ་བྱོན་ཏེ་ཐམས་ཅད་སྒྲིག་པར་བྱེད། འོ་ན་དཀོན་མཆོག་གི་གསུང་རབ་ལས་མིའི་རིགས་ཀྱི་བུ་ནི་སྡུག་བསྔལ་མང་པོ་མྱོང་བར་འགྱུར་ཞིང་མི་རྣམས་ཀྱིས་མཐོང་ཆུང་བྱེད་རྒྱུ་ཡིན་ཞེས་བྲིས་པ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། གསུང་རབ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཡི་སྐོར་བསྟན་ཡོད་པ་ལྟར་ཁོང་ཕེབས་ཡོད་པས། ཁོ་ཚོས་ཁོང་ལ་རང་འདོད་པ་ལྟར་བྱས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","དེ་ནས་ཁོང་རྣམས་ཉེ་གནས་གཞན་གྱི་སར་ཕེབས་པ་དང༌། མི་མང་པོས་དེ་རྣམས་ཀྱི་མཐའ་ནས་བསྐོར་ཞིང་ཡང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་འགའ་ཞིག་གིས་ཁོ་ཚོ་དང་རྩོད་གླེང་བྱེད་བཞིན་པ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","དེ་ནས་མི་ཚོགས་ཐམས་ཅད་ཀྱིས་ཡེ་ཤུ་མཐོང་མ་ཐག་ཚང་མ་ངོ་མཚར་སྐྱེས་ནས་ཁོང་གི་དྲུང་དུ་རྒྱུགས་ཏེ་ཁོང་མཇལ། ");
INSERT INTO bod_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ཡེ་ཤུས་མི་དེ་རྣམས་ལ་“ཁྱེད་ཚོས་གང་གི་སྐོར་ལ་རྩོད་བཞིན་ཡོད་དམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","མི་ཚོགས་ཀྱི་ཁྲོད་ནས་མི་ཞིག་གིས་“སྟོན་པ་ལགས། ངས་ཁྱེད་ཀྱི་དྲུང་དུ་ངའི་བུ་ཁྲིད་ཡོང་བ་ཡིན། བུ་གདོན་འདྲེ་ཞིག་གིས་བཟུང་སྟེ་སྐད་ཆ་ལབ་མི་ཐུབ་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","གདོན་འདྲེས་ག་དུས་ཁོ་འཛིན་ནའང༌། ཁོ་ས་ལ་འགྱེལ་ཞིང་ཁ་ནས་ལྦུ་བ་འཐོན་ཏེ་སོ་ཁྲིག་ཁྲིག་བྱེད་ཅིང༌། ལུས་པོའང་རེངས་པོར་འགྱུར་བས། ངས་ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ལ་གདོན་འདྲེ་དེ་ཕྱིར་སྐྲོད་པར་ཞུས་ཀྱང་ཁོང་ཚོས་བསྐྲད་མ་ཐུབ་བོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","དེ་ནས་ཡེ་ཤུས་“དད་པ་མི་བྱེད་པའི་མི་རབས་ཁྱོད་ཚོ། ང་རང་ཁྱོད་ཚོ་དང་མཉམ་དུ་དུས་ནམ་ཞིག་གི་བར་དུ་སྡོད་དགོས་སམ། ངས་ཁྱོད་ཚོར་དུས་ནམ་ཞིག་གི་བར་དུ་བཟོད་པར་བྱེད་དགོས་སམ། བུ་དེ་ངའི་མདུན་དུ་ཁྲིད་ཤོག་”ཅེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","མི་རྣམས་ཀྱིས་བུ་དེ་ཁོང་གི་དྲུང་དུ་ཁྲིད་ཡོང༌། གདོན་འདྲེ་དེས་ཡེ་ཤུ་མཐོང་མ་ཐག་བུ་དྲག་པོར་སྤྲུགས་པས་བུ་ས་ལ་འགྱེལ་ནས་འགྲེ་ལྡོག་བརྒྱབ་སྟེ་ཁ་ནས་ལྦུ་བ་ཐོན། ");
INSERT INTO bod_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","དེ་ནས་ཡེ་ཤུས་བུ་དེའི་ཕ་ལ་“དུས་ནམ་ཞིག་ལ་འདི་ལྟར་གྱུར་བ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ལ་“ཁོ་ཆུང་དུས་ནས་བཟུང་འདི་ལྟར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","གདོན་འདྲེ་དེས་ངའི་བུ་གསོད་པའི་ཕྱིར་ཐེངས་མང་པོར་མེ་དང་ཆུའི་ནང་དུ་དབྱུགས་མྱོང༌། ཁྱེད་ཀྱིས་ང་ཚོར་རོགས་པ་ཅི་མཛད་ཐུབ་ན་དེ་གནང་བར་མཛོད། ཐུགས་རྗེ་གཟིགས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ཡེ་ཤུས་“མཛད་ཐུབ་ན་ཞེས་ཅི་ཟེར། དད་པ་བྱེད་མཁན་དེས་དོན་ཐམས་ཅད་སྒྲུབ་པར་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","བུའི་ཕ་ཡིས་དེ་མ་ཐག་སྐད་ཆེན་པོས་“ངས་དད་པ་བྱེད། འོན་ཀྱང་ངའི་དད་པ་མི་འདང་བས་སྐྱབས་པར་མཛོད་”ཅེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ཡེ་ཤུས་མི་ཚོགས་རྒྱུགས་འོངས་བ་གཟིགས་པ་དང༌། གདོན་འདྲེ་མི་གཙང་བ་དེ་ལ་“འོན་ཞིང་ལྐུགས་པའི་གདོན་འདྲེ་ཁྱོད། ཁོའི་ལུས་ནས་ཐོན་ཅིག ད་ཕྱིན་ཆད་དེའི་ལུས་ལ་ཕྱིར་ལོག་མི་ཆོག་”ཅེས་བཀའ་བཀྱོན་གནང་ནས། ");
INSERT INTO bod_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","གདོན་འདྲེ་དེ་སྐད་ངན་ཤོར་ནས་བུ་དེ་དྲག་ཏུ་སྤྲུགས་ཏེ་ཕྱིར་ཐོན་པ་དང༌། བུ་དེ་རོ་ལྟར་གྱུར་བས་མི་མང་ཆེ་བས་“ཁོ་ཤི་སོང་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","འོན་ཀྱང་ཡེ་ཤུས་བུ་དེའི་ལག་པ་ནས་འཇུས་ཏེ་བསྐྱོར་བ་དང་ཁོ་ཡར་ལངས། ");
INSERT INTO bod_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","དེ་ནས་ཡེ་ཤུ་ཁང་པའི་ནང་དུ་འཛུལ་ཞིང་མི་གཞན་སུའང་མེད་པའི་དུས་ལ་ཉེ་གནས་རྣམས་ཀྱིས་“ང་ཚོས་ཅིའི་ཕྱིར་གདོན་འདྲེ་བསྐྲད་མ་ཐུབ་བམ་”ཞེས་ཞུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ཁོང་གིས་“གདོན་འདྲེ་འདིའི་རིགས་དཀོན་མཆོག་ལ་སྨོན་ལམ་མ་གཏོགས་པར་གཞན་ཐབས་གང་གིས་ཀྱང་འཐོན་པར་མི་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","དེ་ནས་ཁོང་རྣམས་ཕྱིར་ཐོན་ཏེ། ག་ལིལ་ཡུལ་བརྒྱུད་ནས་ཕེབས་ཤིང༌། ཡེ་ཤུས་ཉེ་གནས་ཚོར་ཆོས་བསྟན་པས་ཁོང་ཚོ་གང་དུ་ཡོད་པ་མི་གཞན་གྱིས་མི་ཤེས་པར་དགོངས། ");
INSERT INTO bod_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ཉེ་གནས་རྣམས་ལ་“མིའི་རིགས་ཀྱི་བུ་ནི་མི་རྣམས་ཀྱི་ལག་ཏུ་གཏད་ནས་དེ་རྣམས་ཀྱིས་ཁོ་རང་གསོད་པར་འགྱུར། བསད་ནས་ཉིན་ཞག་གསུམ་པ་ལ་ཁོ་རང་ལང་བར་འགྱུར་ངེས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ཉེ་གནས་རྣམས་ཀྱིས་གསུང་དེའི་དོན་ཧ་མ་གོ་ཡང་ཁོང་ལ་བཀའ་དྲི་ཞུ་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","དེ་ནས་ཁོང་རྣམས་གྲོང་ཁྱེར་ཀ་ཕར་ན་ཧུམ་དུ་སླེབས་ནས། ཡེ་ཤུས་ཁང་པའི་ནང་དུ་བཞུགས་པའི་ཚེ་ཉེ་གནས་ཚོར་“ཁྱེད་ཚོས་ལམ་ཁར་ཅི་ཞིག་གླེང་བ་ཡིན་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ཁོ་ཚོས་ལམ་ལ་ཕན་ཚུན་གཅིག་གིས་གཅིག་ལ་ཁོ་ཚོ་ནང་ནས་སུ་མཆོག་ཏུ་ཡིན་པའི་གཏམ་གླེང་བས་ཁོ་ཚོ་ཁ་རོག་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ཁོང་བཞུགས་ནས་ཉེ་གནས་བཅུ་གཉིས་པོ་བོས་ཏེ་“མི་སུ་ཡང་མཆོག་ཏུ་འགྱུར་འདོད་ན། ཐམས་ཅད་ཀྱི་ནང་ནས་རྟིང་མར་གྱུར་ལ་ཀུན་གྱི་གཡོག་པོ་བྱེད་དགོས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","དེ་ནས་ཡེ་ཤུས་ཕྲུ་གུ་ཆུང་ངུ་ཞིག་ཁྲིད་ཡོང་སྟེ་ཁོང་ཚོའི་དཀྱིལ་དུ་བཞག་པ་དང༌། ཡང་ཕྲུ་གུ་དེ་ཁོང་གི་སྐུ་པང་དུ་བསྣམས་ནས་ ");
INSERT INTO bod_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“སུས་ཀྱང་ཕྲུ་གུ་ཆུང་ངུ་འདི་འདྲ་བ་རྣམས་ཀྱི་ནང་ནས་གཅིག་ངའི་མིང་གི་ཐོག་ནས་གདན་འདྲེན་པ་དེས་ང་རང་འདྲེན། སུས་ཀྱང་ང་འདྲེན་པ་དེས་ང་རང་གདན་མི་འདྲེན་གྱིས། ང་གཏོང་མཁན་དེ་སྤྱན་འདྲེན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","དེ་ནས་ཉེ་གནས་ཡོ་ཧ་ནན་གྱིས་ཁོང་ལ་“སྟོན་པ་ལགས། ང་ཚོས་མི་གཞན་ཞིག་གིས་ཁྱེད་ཀྱི་མཚན་བརྗོད་ཅིང་གདོན་འདྲེ་བསྐྲད་པ་མཐོང་བྱུང༌། མི་དེ་ང་ཚོའི་ཁོངས་གཏོགས་མིན་པས་དོན་དེ་ལྟར་སྒྲུབ་པ་བཀག་པ་ཡིན་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ཡེ་ཤུས་“མི་གཞན་གྱིས་ངའི་མིང་བརྗོད་ཅིང་ངོ་མཚར་ཅན་གྱི་དོན་བྱས་རྗེས་མྱུར་དུ་ང་ལ་ཚིག་ངན་སྨྲ་བར་མི་ཐུབ་པས་འགོག་པར་མ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","སུས་ཀྱང་ང་ཚོ་ལ་དགྲ་མི་བྱེད་པ་དེས་ངེད་ཀྱི་ཕྱོགས་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། མི་སུ་ཞིག་གིས་ཁྱེད་ཚོ་སྐྱབས་མགོན་མཱ་ཤི་ཀའི་ཡིན་པའི་ཕྱིར་ཁྱེད་ཚོ་ལ་ཆུ་ཕོར་པ་གང་སྟེར་ན། མི་དེའི་བྱ་དགའ་ཅི་ནས་ཀྱང་བརླག་པར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","དེ་ནས་ཡེ་ཤུས་“མི་སུ་ཞིག་གིས་ང་ལ་དད་པ་བྱེད་པའི་བུ་ཕྲུག་འདི་ཚོ་ལས་གཅིག་སླུ་བར་བྱས་ན། མི་དེའི་སྐེ་ལ་རང་འཐག་གི་རྡོ་ཆེན་པོ་ཞིག་བཏགས་ནས་རྒྱ་མཚོའི་ནང་དུ་དབྱུགས་ན་ལེགས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","དཔེར་ན། གལ་ཏེ་ཁྱེད་ཀྱི་ལག་པས་ཁྱེད་སླུ་བར་བྱས་ན། ལག་པ་དེ་ཆོད་ཅིག ཁྱེད་རང་ལག་པ་གཉིས་དང་ལྡན་ཏེ་དམྱལ་བར་ཞི་བ་མེད་པའི་མེ་རུ་འཇུག་པ་ལས། ལག་རྡུམ་དུ་གྱུར་ཡང་ཚེ་དཔག་ཏུ་མེད་པར་འཇུག་པ་དེ་ལེགས། ");
INSERT INTO bod_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","གལ་ཏེ་ཁྱེད་ཀྱི་རྐང་པས་ཁྱེད་ལ་སྡིག་ཉེས་བྱེད་དུ་བཅུག་ན། རྐང་པ་དེ་ཆོད་ཅིག རྐང་པ་གཉིས་དང་ལྡན་པར་དམྱལ་བའི་གནས་སུ་འཇུག་པ་ལས། ཞ་བོར་གྱུར་ཡང་ཚེ་དཔག་ཏུ་མེད་པ་ཐོབ་པ་དེ་ལེགས། ");
INSERT INTO bod_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","གལ་ཏེ་ཁྱེད་ཀྱི་མིག་གིས་ཁྱེད་སླུ་བར་བྱས་ན། མིག་དེ་བཏོན་ནས་དོར་ཅིག ཁྱེད་རང་མིག་ཟུང་དང་ལྡན་པར་དམྱལ་བའི་གནས་སུ་འཇུག་པ་ལས། མིག་ཡ་གཅིག་མེད་ནའང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འགྲོ་བ་དེ་ལེགས། ");
INSERT INTO bod_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","དམྱལ་བའི་གནས་སུ་འབུ་ཡང་མི་འཆི་ལ་མེ་ཡང་མི་ཤིའོ། ");
INSERT INTO bod_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","གང་ལགས་ཟེར་ན། མི་སུ་ཡིན་ཡང་མེ་ཡིས་ཚྭ་རྒྱག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ཚྭ་ནི་ཡག་པོ་ཡིན་ཡང་ཚྭའི་བྲོ་བ་ཡལ་ན། དེའི་བྲོ་བ་གང་གིས་གསོ་བར་བྱེད་དམ། ཁྱེད་ཚོར་ཚྭའི་ཁྱད་ཆོས་ལྡན་ཏེ་ཕན་ཚུན་མཐུན་ནས་སྡོད་ཅིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","དེ་ནས་ཡེ་ཤུ་ཡར་བཞེངས་ཏེ་ཡོར་དན་གཙང་པོའི་ཕར་ཕྱོགས་ཀྱི་ཡ་ཧུ་དཱ་ཡུལ་དུ་ཕེབས་པ་དང༌། མི་ཚོགས་མང་པོ་ཡང་བསྐྱར་ཁོང་གི་དྲུང་དུ་འཛོམས་ཤིང༌། ཁོང་རང་གི་ལུགས་སྲོལ་ལྟར་དེ་རྣམས་ལ་ཆོས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ཁོང་ལ་ཉམས་ཚོད་བྱེད་ཕྱིར་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་སྐྱེས་པས་རང་གི་བཟའ་ཟླ་བཞག་ཆོག་གམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ཁོང་གིས་“ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་ཁྱེད་རྣམས་ལ་བཀའ་གང་གནང་ཡོད་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ཁོ་ཚོས་“མོ་ཤེ་ཡིས་བཟའ་ཚང་ཁ་བྲལ་བའི་ཡི་གེ་བྲིས་ནས་བཞག་ཆོག་ཅེས་བཀའ་གནང་ངོ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ཡེ་ཤུས་“ཁྱོད་ཚོའི་སེམས་མཁྲེགས་པོ་ཡིན་པས་མོ་ཤེ་ཡིས་བཀའ་འདི་ལྟར་གནང་བ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","འོན་ཀྱང་ཐོག་མ་འཇིག་རྟེན་འདི་བཀོད་དུས་ནས་དཀོན་མཆོག་གིས་མི་ཕོ་མོ་གཉིས་མཛད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","དེའི་རྐྱེན་གྱིས་སྐྱེས་པས་རང་གི་ཕ་མ་བཞག་ནས་རང་གི་བཟའ་ཟླ་དང་མཉམ་དུ་འདུས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ཁོ་གཉིས་ཤ་རུས་གཅིག་ཏུ་གྱུར་ནས་སོ་སོ་བ་མིན་ཏེ་གཅིག་རང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","དེའི་ཕྱིར་དཀོན་མཆོག་གིས་གང་སྦྲེལ་བར་མཛད་པ་དེ་མི་སུས་ཀྱང་ཕྲལ་བར་མི་རུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ཁང་པའི་ནང་དུ་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་སླར་ཡང་གསུང་དེའི་དོན་དྲིས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ཁོང་གིས་“སྐྱེས་པ་སུ་ཞིག་གིས་རང་གི་བཟའ་ཟླ་བཞག་ནས་བཟའ་ཟླ་གཞན་ཞིག་བླངས་ན་དེ་ནི་ལོག་གཡེམ་བྱས་པ་ཡིན་ལ་བཟའ་ཟླ་དང་པོར་ཉེས་པ་བསགས་པ་ཡང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ཡང་བུད་མེད་ཅིག་གིས་རང་གི་སྐྱེས་པ་བཞག་ནས་སྐྱེས་པ་གཞན་དང་འགྲོགས་ན་དེའང་ལོག་གཡེམ་བྱས་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","དེ་ནས་མི་འགའ་ཞིག་གིས་བྱིས་པ་རྣམས་ཁོང་གི་དྲུང་དུ་ཕྱག་གིས་རེག་པའི་ཕྱིར་ཁྲིད་ཡོང་སྟེ། ཉེ་གནས་རྣམས་ཀྱིས་ཁོ་ཚོ་ལ་བཀའ་བཀྱོན་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ཡེ་ཤུས་དེ་གཟིགས་ཏེ་ཐུགས་མ་མཉེས་པར་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་འདི་ལྟ་བུ་རྣམས་ལ་གཏོགས་པ་ཡིན་པས། བྱིས་པ་རྣམས་མ་འགོག་པར་ངའི་དྲུང་དུ་འོང་དུ་ཆུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། སུ་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་བྱིས་པའི་ཚུལ་དུ་མི་བླངས་ན། དེའི་ནང་དུ་ཅི་ནས་ཀྱང་འགྲོ་མི་ཐུབ་བོ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ཁོང་གིས་བྱིས་པ་དེ་རྣམས་སྐུ་པང་དུ་བསྣམས་ཤིང་ཕྱག་བཞག་སྟེ་བྱིན་གྱིས་བརླབས། ");
INSERT INTO bod_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","དེ་ནས་ཡེ་ཤུ་ལམ་དུ་ཕེབས་པའི་སྐབས་སུ། མི་ཞིག་རྒྱུགས་ཡོང་ནས་ཁོང་གི་དྲུང་དུ་པུས་མོ་སར་བཙུགས་ཏེ་“སྟོན་པ་བཟང་པོ་ལགས། དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་ཕྱིར་ངས་གང་ཞིག་བྱ་དགོས་སམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","འོན་ཀྱང་ཁོང་གིས་“ཁྱེད་ཀྱིས་ང་ལ་ཅིའི་ཕྱིར་བཟང་པོ་ཟེར། དཀོན་མཆོག་གཅིག་པུ་ལས་གཞན་བཟང་པོ་གཅིག་ཀྱང་མེད། ");
INSERT INTO bod_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","མིའི་སྲོག་མ་གཅོད། ལོག་གཡེམ་མ་བྱེད། རྐུ་མ་མ་རྐུས། རྫུན་གྱི་དཔང་པོ་མ་བྱེད། མགོ་སྐོར་མ་གཏོང༌། རང་གི་ཕ་མར་བརྩི་བཀུར་བྱོས་ཤིག་ཅེས་གསུངས་པའི་བཀའ་ཁྲིམས་འདི་ཚོ་ཁྱེད་ཀྱིས་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ཡང་མི་དེས་“སྟོན་པ་ལགས། ངས་ཆུང་དུས་ནས་བཀའ་འདི་ཐམས་ཅད་བསྲུངས་པ་ཡིན་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ཡེ་ཤུས་ཁོ་ལ་གཟིགས་ནས་བྱམས་པར་མཛད་ཅིང་“ཁྱོད་ལ་ད་དུང་དོན་གཅིག་མི་ཚང་བས། ཁྱོད་སོང་ནས་རང་ལ་ཡོད་པ་ཐམས་ཅད་བཙོང་སྟེ་དབུལ་པོ་རྣམས་ལ་བྱིན་ཅིག དེ་ནས་ཁྱོད་ལ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ནོར་ཐོབ་པར་འགྱུར་བ་དང༌། ཤོག ངའི་རྗེས་སུ་འབྲོངས་”ཞེས་གསུངས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","མི་དེར་རྒྱུ་ནོར་མང་པོ་ཡོད་པས་གསུང་དེ་ཐོས་ནས་ངོ་མདོག་འགྱུར་ཞིང་སེམས་པ་སྐྱོ་པོར་གྱུར་ཏེ་ཕྱིར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","དེ་ནས་ཡེ་ཤུས་འཁོར་ལ་གཟིགས་ཤིང་ཉེ་གནས་རྣམས་ལ་“ཕྱུག་པོ་རྣམས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་དུ་འགྲོ་བ་ཤིན་ཏུ་དཀའོ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ཁོང་གི་གསུང་དེར་ཉེ་གནས་ཧ་ལས་སོ། འོན་ཀྱང་ཡེ་ཤུས་སླར་ཡང་དེ་རྣམས་ལ་“བུ་ཚོ། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འགྲོ་བ་ནི་ཤིན་ཏུ་དཀའོ། ");
INSERT INTO bod_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","མི་ཕྱུག་པོ་ཞིག་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ལ་འགྲོ་བ་ལས་རྔ་མོང་ཞིག་ཁབ་མིག་བརྒྱུད་ནས་འགྲོ་བ་སླའོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ཉེ་གནས་རྣམས་དེ་བས་ཧང་སང་ཞིང་ཁོང་ལ་“འོ་ན་སུ་ཞིག་ལ་ཐར་བ་ཐོབ་ཐུབ་བམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ཡེ་ཤུས་ཁོ་རྣམས་ལ་གཟིགས་ཏེ་“དེ་ནི་མི་ལ་མི་སྲིད་ཀྱང་དཀོན་མཆོག་ལ་སྲིད་དོ། དཀོན་མཆོག་ལ་ཐམས་ཅད་འགྲུབ་པར་སྲིད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","དེ་ནས་པེ་ཏྲོས་“གཟིགས་དང༌། ང་ཚོས་ཐམས་ཅད་དོར་ནས་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲངས་པ་ཡིན་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ཡེ་ཤུས་“ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་སུ་ཞིག་གིས་ང་དང་འཕྲིན་བཟང་གི་དོན་དུ་རང་གི་ཁྱིམ་ཚང་ངམ། སྤུན་ནམ། སྲིང་མོ་འམ། ཕ་མའམ། བུ་ཕྲུག་གམ། ས་ཞིང་བཅས་བཞག་ན། ");
INSERT INTO bod_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","མི་དེ་ལ་ཚེ་འདིར་ཁྱིམ་ཚང་དང༌། སྤུན། སྲིང་མོ། མ། བུ་ཕྲུག ས་ཞིང་སོགས་ལྡབ་བརྒྱ་འགྱུར་ཐོབ་པར་མ་ཟད་འཚེ་བ་ཡང་ཡོང་ཞིང༌། མ་འོངས་པར་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པར་ངེས། ");
INSERT INTO bod_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","འོན་ཀྱང་དང་པོ་ཡིན་པའི་མི་མང་པོ་མཐའ་མར་འགྱུར་ཞིང་མཐའ་མ་ཡིན་པ་མང་པོའང་དང་པོར་འགྱུར་འོང་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","དེ་ནས་ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་པའི་ལམ་དུ། ཡེ་ཤུ་ཁོ་རྣམས་ཀྱི་སྔོན་ལ་ཕེབས་ཤིང་ཉེ་གནས་རྣམས་ཡ་མཚན་སྐྱེས་པ་དང་རྗེས་སུ་འབྲང་མཁན་རྣམས་འཇིགས། ཁོང་གིས་ཡང་བསྐྱར་ཉེ་གནས་བཅུ་གཉིས་པོ་ཟུར་ལ་ཁྲིད་དེ། རང་ལ་གང་འབྱུང་རྒྱུ་ཡིན་པའི་གནས་ཚུལ་རྣམས་གསུངས་པ་འདི་ལྟར་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ལྟོས་དང༌། ང་ཚོ་ད་ལྟ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དུ་འགྲོ་བཞིན་ཡོད། མིའི་རིགས་ཀྱི་བུ་ནི་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱི་དབང་དུ་བཏང་ནས། ཁོ་ཚོས་ཁོ་རང་གསོད་དགོས་པའི་ཁྲིམས་ཐག་བཅད་ནས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་གཏད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ཁོ་ཚོས་ཁོ་རང་ལ་འཕྱ་དམོད་བྱེད་པ་དང༌། མཆིལ་མ་གཏོར་བ་དང་རྟ་ལྕག་གིས་བརྡུངས་ནས་གསོད་པར་འགྱུར། དེ་ནས་ཉིན་ཞག་གསུམ་སོང་ནས་སླར་ཡང་གསོན་པོར་ལང་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","དེ་ནས་ཟེ་བད་ཡཱ་ཞེས་པ་དེའི་བུ་ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་གཉིས་ཡེ་ཤུའི་དྲུང་དུ་ཡོང་སྟེ་“སྟོན་པ་ལགས། ངེད་གཉིས་ཀྱིས་ཁྱེད་ལ་གང་ཞུས་པ་དེ་གནང་བར་ཞུ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ཁོང་གིས་“ངས་ཁྱོད་ཚོའི་དོན་དུ་ཅི་བྱེད་དགོས་སམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ཡང་དེ་གཉིས་ཀྱིས་“ཁྱེད་ཀྱི་གཟི་བརྗིད་ཀྱི་ཁྲོད་དུ་ངེད་གཉིས་ལས་གཅིག་ཁྱེད་ཀྱི་གཡས་ཕྱོགས་དང་གཅིག་གཡོན་ཕྱོགས་སུ་སྡོད་དུ་འཇུག་པར་མཛོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ཡེ་ཤུས་“ཁྱེད་གཉིས་ཀྱིས་གང་ཞུ་བའི་དོན་མི་ཤེས་ཏེ། ངས་འཐུང་དགོས་པའི་སྡུག་བསྔལ་གྱི་ཕོར་པ་དེ་ལས་འཐུང་ཐུབ་བམ། ངས་ལེན་དགོས་པའི་ཁྲུས་གསོལ་ལེན་ཐུབ་བམ་”ཞེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","དེ་གཉིས་ཀྱིས་ཁོང་ལ་“ཐུབ་བོ་”ཞེས་ཞུས། ཡེ་ཤུས་“ངས་འཐུང་བའི་ཕོར་པ་དེ་ཁྱེད་གཉིས་ཀྱིས་འཐུང་ཡོང༌། ངས་ལེན་པའི་ཁྲུས་གསོལ་ཡང་ལེན་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","འོན་ཀྱང་ངའི་གཡས་གཡོན་ལ་སྡོད་དུ་འཇུག་པའི་དབང་ཆ་དེ་ང་ལ་མེད། མི་སུ་ལ་བཤམས་པ་ཡིན་པ་དེ་ལ་འཐོབ་བོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ཉེ་གནས་བཅུ་པོས་གཏམ་དེ་ཐོས་དུས་ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་གཉིས་ལ་ཁོང་ཁྲོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ཡེ་ཤུས་ཁོ་ཚོ་རང་གི་དྲུང་དུ་བོས་ཏེ་“ཁྱེད་ཚོས་ཤེས་པ་ལྟར། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་ནང་ནས་དཔོན་པོའི་རིགས་སུ་གྱུར་བ་རྣམས་ཀྱིས་ཁོ་ཚོར་དབང་བྱེད་ཅིང༌། མི་ཆེན་པོ་རྣམས་ཀྱིས་ཁོ་ཚོར་དབང་བསྒྱུར། ");
INSERT INTO bod_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","འོན་ཀྱང་ཁྱེད་ཚོའི་ནང་དུ་དེ་ལྟར་མ་ཡིན། ཁྱེད་ཚོ་ལས་སུ་ཞིག་ཆེན་པོར་འགྱུར་འདོད་པ་དེ་ཁྱེད་ཚོའི་གཡོག་པོར་འགྱུར་དགོས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ཁྱེད་ཚོ་ལས་སུ་ཞིག་དང་པོར་འགྱུར་འདོད་པ་དེ་མི་ཀུན་གྱི་བྲན་གཡོག་ཏུ་འགྱུར་དགོས། ");
INSERT INTO bod_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","གང་ལགས་ཟེར་ན། མིའི་རིགས་ཀྱི་བུ་ཡང་གཞན་གྱིས་རང་ལ་གཡོག་བྱེད་པའི་ཕྱིར་ཡོང་བ་མ་ཡིན་པར། གཞན་ལ་གཡོག་བྱེད་པ་དང་རང་སྲོག་ཕུལ་ནས་མི་མང་པོ་ལ་ཐར་པ་ཐོབ་པའི་ཕྱིར་ཡོང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","དེ་ནས་ཡེ་རུ་ཀོ་གྲོང་ཁྱེར་དུ་ཕེབས་ཤིང༌། ཁོང་ཉེ་གནས་དང་མི་ཚོགས་མང་པོ་མཉམ་དུ་ཡེ་རུ་ཀོ་ནས་ཐོན་པའི་སྐབས་སུ། ཐི་མེ་ཟིའི་བུ་མིང་ལ་པར་ཐི་མེ་ཟི་ཞེས་པའི་སྤྲང་པོ་ལོང་བ་ཞིག་ལམ་ཁར་བསྡད་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","སྤྲང་པོ་དེས་ན་ཙ་རེལ་པ་ཡེ་ཤུ་ཕེབས་པའི་གཏམ་ཐོས་ནས་སྐད་ཆེན་པོས་“ཀྱེ། ཡེ་ཤུ་དཱ་བིད་ཀྱི་སྲས། ང་ལ་ཐུགས་རྗེས་གཟིགས་དང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","མི་མང་པོས་ཁོ་ལ་ཁ་རོག་སྡོད་ཅེས་ནན་གྱིས་བསྐུལ་ནའང༌། ཁོས་དེ་བས་སྐད་ཆེན་པོས་“ཀྱེ། དཱ་བིད་ཀྱི་སྲས་ཁྱེད་ཀྱིས་ང་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","དེ་ནས་ཡེ་ཤུས་ཕེབས་མཚམས་བཞག་སྟེ་“ལོང་བ་དེ་ཚུར་ལ་བོས་ཤིག་”ཅེས་གསུངས་པ་དང༌། ཁོ་ཚོས་ལོང་བ་དེ་སྐད་བཏང་ཞིང་དེ་ལ་“བློ་བདེ་བར་གྱིས། ཁོང་གིས་ཁྱོད་ལ་ཚུར་ཤོག་ཅེས་གསུངས། ཡར་ལོངས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ཁོས་རང་གི་སྟོད་གོས་བསྐྱུར་ནས་མགྱོགས་པོར་ཡར་ལངས་ཏེ་ཁོང་གི་སྐུ་མདུན་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ཡེ་ཤུས་“ངས་ཁྱེད་ལ་གང་བྱེད་དགོས་སམ་”ཞེས་གསུངས་པ་དང༌། མི་ལོང་བ་དེས་“སློབ་དཔོན་ལགས། ངའི་མིག་གིས་མཐོང་ནུས་པར་མཛོད་”ཅེས་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ཡེ་ཤུས་“ད་ལྟ་ཁྱེད་རང་སོང་དང༌། ཁྱེད་ཀྱི་དད་པས་གསོས་ཟིན་ནོ་”ཞེས་གསུངས་མ་ཐག་ཁོའི་མིག་གིས་མཐོང་བར་གྱུར་བས། ཁོ་རང་ལམ་བར་ནས་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་གྱི་ཉེ་འགྲམ་དུ་ཕེབས་སྐབས། སྐྱུར་རུ་ཤིང་གི་རིའི་ངོས་སུ་ཡོད་པའི་གྲོང་སྡེ་པེ་ཕ་གེ་དང་པེ་ཐན་ཡཱ་ས་ཆ་དེར་ཡེ་ཤུས་ཉེ་གནས་གཉིས་མངགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ཁོ་ཚོར་“ཁྱེད་ཚོ་མདུན་ལ་ཡོད་པའི་གྲོང་སྡེ་དེ་ལ་སོང་དང༌། དེར་སླེབས་མ་ཐག་ཏུ་མི་སུས་ཀྱང་བཞོན་མ་མྱོང་བའི་བོང་གསར་ཞིག་བཏགས་ཡོད་པ་མཐོང་བར་འགྱུར། དེ་བཀྲོལ་ནས་འདིར་ཁྲིད་ཤོག ");
INSERT INTO bod_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","གལ་སྲིད་མི་གཞན་གྱིས་ཁྱེད་གཉིས་ལ་ཅིའི་ཕྱིར་དེ་ལྟར་བྱེད་པ་ཡིན་ནམ་ཞེས་དྲིས་ན། ཁྱེད་ཀྱིས་འདི་ང་ཚོའི་གཙོ་བོ་ལ་མཁོ་བ་ཡིན་ཞེས་སྨྲོས་དང༌། ཁོང་གིས་འཁྱུག་ཙམ་ནས་ལོག་གཏོང་ངོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ཁོ་ཚོ་སོང་ནས་སྒོའི་ཕྱི་རོལ་གྱི་སྲང་ལམ་དུ་བོང་གསར་ཞིག་བཏགས་འདུག་པ་མཐོང་སྟེ་བཀྲོལ་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","དེར་ཡོད་པའི་མི་རྣམས་ལས་འགའ་ཞིག་གིས་ཁོ་ཚོ་ལ་“ཅིའི་ཕྱིར་བོང་གསར་དེ་བཀྲོལ་བ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ཁོ་ཚོས་ཡེ་ཤུའི་བཀའ་ལྟར་ལན་བཏབ་པས། མི་དེ་རྣམས་ཀྱིས་ཁོ་གཉིས་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","བོང་གསར་ཁྲིད་ནས་ཡེ་ཤུའི་དྲུང་དུ་སླེབས་རྗེས་ཁོ་གཉིས་ཀྱིས་རང་གི་གོས་བོང་གསར་གྱི་རྒྱབ་ཏུ་བཏིང་བ་དང་ཁོང་དེ་ལ་བཅིབས། ");
INSERT INTO bod_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","མི་མང་པོས་རང་གི་གྱོན་པ་ལམ་ལ་བཏིང་ཞིང༌། གཞན་རྣམས་ཀྱིས་ཞིང་ནང་དུ་ཡོད་པའི་སྡོང་པོའི་སྟེང་ནས་ལོ་མ་མང་བའི་ཡལ་ག་བཅད་དེ་ལམ་དུ་བཀྲམ། ");
INSERT INTO bod_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ཁོང་གི་སྔོན་ནས་འགྲོ་བ་དང་རྗེས་སུ་འབྲངས་པའི་མི་རྣམས་ཀྱིས་སྐད་ཆེན་པོས་“ཧོ་ཟན་ནཱ། གཙོ་བོའི་མཚན་གྱི་ཐོག་ནས་བྱོན་པ་འདི་ལ་བྱིན་རླབས་ཡོང་བར་ཤོག ");
INSERT INTO bod_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ང་ཚོའི་མེས་པོ་དཱ་བིད་ཀྱི་རྒྱལ་སྲིད་བྱོན་པ་འདི་ལ་བྱིན་རླབས་ཡོང་བར་ཤོག ཤིན་ཏུ་མཐོ་ཞིང་བླ་ན་མེད་པའི་གནས་སུ་བཞུགས་པའི་དཀོན་མཆོག་ལ་ཧོ་ཟན་ནཱ་”ཞེས་འབོད་སྒྲ་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","དེ་ནས་ཁོང་ཡེ་རུ་ཤ་ལེམ་ནང་ཕེབས་ཏེ། ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོར་བྱོན་ནས་རིམ་གྱིས་མཐའ་འཁོར་ལ་གཟིགས་ཤིང༌། མཚན་མོའི་དུས་སུ་སླེབས་པས་ཉེ་གནས་བཅུ་གཉིས་པོ་དང་མཉམ་དུ་པེ་ཐན་ཡཱ་ཞེས་པའི་གྲོང་སྡེར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","དེའི་ཕྱི་ཉིན་ཁོང་རྣམས་པེ་ཐན་ཡཱ་གྲོང་སྡེ་ནས་ཕར་ཕེབས་ཏེ་ཡེ་ཤུ་བཀྲེས་པར་གྱུར་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","རྒྱང་རིང་ནས་ལོ་མ་དང་ལྡན་པའི་བསེ་ཡབ་ཤིང་སྡོང་ཞིག་ཡོད་པ་གཟིགས་ཏེ། ཤིང་འབྲས་ཡོད་སྲིད་དགོངས་ནས་དེའི་རྩ་ལ་ཕེབས་པ་དང༌། བསེ་ཡབ་ཤིང་ལ་འབྲས་བུ་སྨིན་མ་རན་པས་ལོ་མ་ལས་གཞན་ཅི་ཡང་མེད་པ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ཡེ་ཤུས་ཤིང་ལ་གཟིགས་ཏེ་“དུས་ད་ལྟ་ནས་བཟུང་ཁྱོད་ཀྱི་འབྲས་བུ་མི་སུས་ཀྱང་ཟ་རྒྱུ་མེད་པར་གྱུར་ཅིག་”ཅེས་གསུངས་པ་ཉེ་གནས་རྣམས་ཀྱིས་ཐོས། ");
INSERT INTO bod_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","དེ་ནས་ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དུ་ཕེབས་པ་དང་ཁོང་ཉིད་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་བྱོན་ཏེ། དེར་ཡོད་པའི་ཉོ་ཚོང་མཁན་ཐམས་ཅད་ཕྱི་ལ་བཏོན་པ་དང༌། དངུལ་རྗེ་མཁན་གྱི་ཅོག་ཙེ་དང་ཕུག་རོན་ཚོང་མཁན་གྱི་འདུག་སྟེགས་ཀྱང་སར་བསྒྱེལ། ");
INSERT INTO bod_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","མི་སུ་ལའང་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་ར་བརྒྱུད་ནས་ཚོང་ཟོག་ཅིག་ཀྱང་འཁྱེར་དུ་མ་བཅུག ");
INSERT INTO bod_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","སྐབས་དེར་ཁོང་གིས་མི་རྣམས་ལ་“དཀོན་མཆོག་གི་གསུང་རབ་ལས། ངའི་གནས་ཁང་ལ་མི་རིགས་ཐམས་ཅད་ཀྱི་ཆེད་དུ་སྨོན་ལམ་འདེབས་པའི་གནས་ཁང་ཟེར་བར་འགྱུར་ཞེས་གསུངས་ཡོད་པ་མིན་ནམ། འོན་ཀྱང་ཁྱོད་ཚོས་ཇག་ཚང་ལྟ་བུ་ཞིག་ཏུ་བསྒྱུར་འདུག་”ཅེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","དེར་ཡོད་པའི་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང་ཆོས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་གཏམ་དེ་ཐོས་ནས་ཡེ་ཤུ་ཁོང་ཇི་ལྟར་བྱས་ནས་གསོད་པའི་ཐབས་བཙལ། གང་ལགས་ཟེར་ན། ཁོང་ལ་འཇིགས་ཏེ། མི་ཚོགས་ཐམས་ཅད་ཁོང་གི་ཆོས་གསུངས་པ་ལ་ངོ་མཚར་སྐྱེས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","དེ་ནས་མཚན་མོ་ཟིན་དུས་ཡེ་ཤུ་ཉེ་གནས་དང་མཉམ་དུ་གྲོང་ཁྱེར་གྱི་ཕྱི་རོལ་ཏུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","དེ་ཡང་ཞོགས་པའི་དུས་སུ་ཁོང་རྣམས་ཕར་བྱོན་སྐབས་བསེ་ཡབ་ཤིང་དེ་རྩ་བ་ནས་བསྐམས་ཟིན་པ་མཐོང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","པེ་ཏྲོ་ཡིས་ཡེ་ཤུའི་གསུང་དེ་དྲན་ནས་“རབ་བི་གཟིགས་དང༌། ཁྱེད་ཀྱིས་དམོད་པ་གནང་བའི་བསེ་ཡབ་ཤིང་བསྐམས་འདུག་”ཅེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ཡེ་ཤུས་ཁོ་ཚོ་ལ་“དཀོན་མཆོག་ལ་དད་པ་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ངས་ཁྱོད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། མི་སུ་ཞིག་གིས་རི་འདི་ལ་ད་ཁྱོད་ཕར་སོང་ལ་རྒྱ་མཚོར་ལྷུང་བར་གྱུར་ཅིག་ཞེས་སྨྲས་ན། སྨྲས་པ་བཞིན་དུ་འགྲུབ་པར་འགྱུར་ཞེས་སེམས་སུ་ཐེ་ཚོམ་མེད་པར་དད་པ་བྱས་ན། མི་དེའི་དོན་འགྲུབ་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","དེ་བས་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཁྱེད་ཚོས་སྨོན་ལམ་གང་ཡང་འདེབས་པ་དེ་འཐོབ་ཟིན་པར་དད་པ་བྱོས་དང་འཐོབ་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ཞིང་ཁམས་སུ་བཞུགས་པའི་ཁྱེད་ཀྱི་ཡབ་དཀོན་མཆོག་གིས་ཁྱེད་ཀྱི་སྡིག་ཉེས་རྣམས་སེལ་བར་འགྱུར་བའི་ཕྱིར། ཁྱེད་ཚོ་ལངས་ནས་སྨོན་ལམ་འདེབས་སྐབས། མི་གཞན་དང་འཁོན་འཛིན་ཡོད་ན་འཁོན་དུ་བཟུང་བར་མི་བྱའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","དེ་ནས་ཡང་བསྐྱར་ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དུ་སླེབས་ནས་ཡེ་ཤུ་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཕེབས་པ་ན། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི། རྒན་པོ་རྣམས་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ཁྱེད་ཀྱིས་དབང་ཆ་གང་གི་སྒོ་ནས་དོན་འདི་ཚོ་མཛད། ཡང་ན་སུ་ཞིག་གིས་ཁྱེད་ལ་དོན་འདི་རྣམས་མཛད་པའི་དབང་ཆ་སྤྲད་པ་ཡིན་ནམ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ཡེ་ཤུས་“ངས་ཀྱང་ཁྱེད་རྣམས་ལ་དྲི་བ་གཅིག་འདྲི་རྒྱུ་ཡིན། དེའི་ལན་ཐོབ་ཅིག དེ་ནས་ངས་དོན་འདི་རྣམས་དབང་ཅི་ལྟ་བུས་མཛད་པའང་ཁྱེད་རྣམས་ལ་ཤོད་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་མཛད་པ་དེ་དཀོན་མཆོག་ནས་བྱུང་ངམ། མི་ནས་བྱུང༌། ང་ལ་ལན་ཐོབ་ཅིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","མི་དེ་ཚོས་ཕན་ཚུན་གཏམ་གླེང་བྱས་ཤིང་“གལ་ཏེ་དཀོན་མཆོག་ནས་བྱུང་ཞེས་བཤད་ན། ཁོང་གིས་འོ་ན་ཁྱེད་རྣམས་ཀྱིས་ཅིའི་ཕྱིར་ཁོང་ལ་དད་པ་མ་བྱས་སམ་ཞེས་གསུང་ངེས་ལ། ");
INSERT INTO bod_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ཡང་མི་ལས་བྱུང་ཞེས་བཤད་ན༌༌༌༌” མི་ཐམས་ཅད་ཀྱིས་ཡོ་ཧ་ནན་ལུང་སྟོན་མཁན་བདེན་པར་བརྩིས་པའི་རྐྱེན་གྱིས་མི་རྣམས་ལ་འཇིགས་པས། ");
INSERT INTO bod_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ཁོ་རྣམས་ཀྱིས་“ང་ཚོས་མི་ཤེས་”ཞེས་ལན་བཏབ་པས། ཡེ་ཤུས་“དེས་ན་ངས་ཀྱང་དོན་འདི་རྣམས་དབང་ཆ་གང་གིས་འདི་རྣམས་བྱེད་པ་མི་ཤོད་དོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","དེ་ནས་ཡེ་ཤུས་དཔེའི་སྒོ་ནས་ཁོ་ཚོར་ཆོས་བསྟན་ཏེ་“མི་ཞིག་གིས་རྒུན་འབྲུམ་གྱི་ལྡུམ་ར་ཞིག་བཟོས་ཤིང༌། ཕྱོགས་བཞིར་ར་བས་བསྐོར་བ་དང༌། རྒུན་ཆང་འཚིར་བྱེད་ཀྱི་ཆང་གཞོང་ཞིག་བརྐོས་ནས་ཐོག་ཁང་ཞིག་ཀྱང་བཟོས་རྗེས། ལྡུམ་རའི་ལས་མཁན་རྣམས་ལ་བོགས་མར་བཏང་ནས་ཡུལ་གཞན་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","དེ་ནས་དུས་རན་པས་ཁོང་གིས་ལྡུམ་རའི་ལས་མཁན་རྣམས་ནས་ལྡུམ་རའི་འབྲས་བུ་ནས་ཁོང་གི་རྒུན་འབྲུམ་གྱི་སྐལ་བ་ལེན་པའི་ཕྱིར་གཡོག་པོ་ཞིག་བཏང་བས། ");
INSERT INTO bod_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","དེ་རྣམས་ཀྱིས་གཡོག་པོ་དེ་བཟུང་ནས་བརྡུངས་རྗེས་ལག་ཟུང་སྟོང་བར་ཕྱིར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ཡང་ཁོང་གིས་གཡོག་པོ་གཞན་ཞིག་བཏང་བས། དེ་ཚོས་གཡོག་པོ་དེའི་མགོར་རྨ་བཟོས་ནས་དམའ་འབེབས་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ཡང་ཁོང་གིས་གཡོག་པོ་གཞན་ཞིག་མངགས་པའང་དེ་རྣམས་ཀྱིས་བསད། དེ་ནས་ཁོང་གིས་གཡོག་པོ་གཞན་མང་པོ་ཞིག་བཏང་བ་ན། དེ་རྣམས་ཀྱིས་གཡོག་པོ་ལ་ལ་བརྡུངས་ཤིང་ལ་ལ་བསད། ");
INSERT INTO bod_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ཁོང་ལ་ད་དུང་གཅེས་པའི་བུ་ཞིག་ཡོད་དེ། མཇུག་མཐར་ཁོང་གིས་བུ་ཡང་དེ་རྣམས་ཀྱི་རྩ་ལ་བཏང་ཞིང༌། ཁོ་ཚོས་ངའི་བུ་ལ་བརྩི་བཀུར་བྱེད་པར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","འོན་ཀྱང་ལྡུམ་རའི་ལས་མཁན་དེ་ཚོས་ཕན་ཚུན་ལ་མི་འདི་ནི་ཕ་ཤུལ་འཛིན་མཁན་ཡིན་པས། ད་ཁོ་རང་བསད་ན་རྒྱུ་ནོར་དེ་ང་ཚོ་ལ་ཐོབ་ཡོང་ཞེས་སྨྲས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ཁོ་རང་བཟུང་ཞིང་བསད་ནས་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་ཕྱི་རོལ་ཏུ་འཕངས། ");
INSERT INTO bod_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ད་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་བདག་པོས་གང་བྱེད་ཡོང༌། ཁོང་ཕེབས་ནས་ལྡུམ་རའི་ལས་མཁན་རྣམས་མེད་པར་བཟོས་ཏེ་རྒུན་འབྲུམ་གྱི་ལྡུམ་ར་མི་གཞན་ལ་སྤྲོད་པར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","དེ་ཡང་དཀོན་མཆོག་གི་གསུང་རབ་ལས། བཟོ་བོ་རྣམས་ཀྱིས་དོར་བའི་རྡོ། ། ཁང་པའི་རྨང་རྡོར་གྱུར་བ་འདི། ། ");
INSERT INTO bod_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","གཙོ་བོ་ཉིད་ཀྱིས་མཛད་པ་ཡིན། ། ངེད་ཅག་མིག་ལ་ངོ་མཚར་ཆེ། ། ཞེས་གསུངས་ཡོད་པ་ཁྱེད་རྣམས་ཀྱིས་བཀླགས་མ་མྱོང་ངམ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ཁོ་ཚོས་དཔེ་དེ་ཁོ་ཚོའི་སྐོར་ལ་གསུངས་པ་ཤེས་ཏེ་ཡེ་ཤུ་འཛིན་པར་བསམས་ཀྱང༌། མི་ཚོགས་ལ་འཇིགས་ཏེ་ཁོང་དང་ཁ་བྲལ་ནས་སོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ཡང་མི་དེ་ཚོས་ཡེ་ཤུ་ལ་ཁྲིམས་དང་འགལ་བའི་གཏམ་བཤད་གནང་དུ་འཇུག་ཆེད་ཕཱ་རུ་ཤི་པ་དང༌། ཧེ་རོ་དཱེའི་ཕྱོགས་ཁག་གི་མི་འགའ་ཞིག་ཁོང་གི་དྲུང་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ཁོ་ཚོ་ཡོང་ནས་ཁོང་ལ་“སྟོན་པ་ལགས། ཁྱེད་ནི་རང་གཤིས་དྲང་ཞིང་ཁྱེད་ཀྱིས་མིའི་ཕྱིའི་རྣམ་པར་མི་གཟིགས་ཤིང་མི་ཀུན་ལ་ཕྱོགས་རིས་མེད་པར་དཀོན་མཆོག་གི་ལམ་ཡང་དག་པར་བདེན་པར་སྟོན་པ་ངེད་ཀྱིས་ཤེས། དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་ད་ལྟ་ང་ཚོས་རྒྱལ་པོར་ཁྲལ་འཇལ་རུང་ངམ་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","འཇལ་ལམ་མི་འཇལ་”ཞེས་དྲིས། ཁོང་གིས་དེ་རྣམས་ཀྱི་གཡོ་སྒྱུ་མཁྱེན་ཏེ་“ཁྱོད་ཚོས་ང་ལ་ཉམས་ཚོད་ལེན་པའི་རྒྱུ་མཚན་ཅིའམ། དེ་ཎ་རིའི་དངུལ་ཊམ་ཀ་གཅིག་འདི་རུ་ཁྱེར་ཤོག་དང་བལྟའོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ཁོ་ཚོས་གཅིག་ཁྱེར་ཡོང་ཞིང༌། ཁོང་གིས་དེ་རྣམས་ལ་“རི་མོ་དང་ཡི་གེ་འདི་སུའི་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ཁོ་ཚོས་“སེ་སར་རྒྱལ་པོའི་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ཡང་ཡེ་ཤུས་“གང་ཞིག་སེ་སར་རྒྱལ་པོའི་ཡིན་པ་དེ་རྒྱལ་པོ་ལ་འཇལ་ཞིང༌། གང་ཞིག་དཀོན་མཆོག་གི་ཡིན་པ་དེ་དཀོན་མཆོག་ལ་ཕུལ་”ཞེས་གསུངས་པས་ཁོ་ཚོ་ཁོང་ལ་ངོ་མཚར་ཆེ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","དེ་ནས་ཡང་གཤིན་པོ་རྣམས་ལ་སླར་གསོན་པ་མེད་ཅེས་ཟེར་མཁན་སཱ་ཅུ་སེ་པ་རྣམས་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“སྟོན་པ་ལགས། ལུང་སྟོན་པ་མོ་ཤེའི་མདོ་ལས། གལ་སྲིད་སྐྱེས་པ་ཞིག་གི་གཅེན་པོ་ཤི་ནས་བུ་ཕྲུག་མེད་པར་བཟའ་ཟླ་གཅིག་པུ་ལུས་ན། སྐྱེས་པ་དེས་ཁོའི་བཟའ་ཟླ་བླངས་ནས་སྤུན་གྱི་དོན་དུ་རིགས་རྒྱུད་སྤེལ་དགོས་པ་ཡིན་ནོ་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ད་སྤུན་བདུན་ཡོད་དེ། སྤུན་ཆེ་བས་བཟའ་ཟླ་ཞིག་བླངས་ནས་བུ་ཕྲུག་མེད་པར་ཤི་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ཡང་སྤུན་འབྲིང་བས་བུད་མེད་དེ་བླངས་ནས་བུ་ཕྲུག་མེད་པར་ཤི སྤུན་ཆུང་བས་ཀྱང་དེ་ལྟར་བྱས་ནས་བུ་མ་བྱུང་བར་ཤི་ལ། ");
INSERT INTO bod_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","དེ་བཞིན་སྤུན་བདུན་པོར་བུ་ཕྲུག་མ་བྱུང་ལ་ཐམས་ཅད་ཀྱི་གཞུག་ལ་བུད་མེད་དེའང་ཤིའོ། ");
INSERT INTO bod_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","གཤིན་པོ་རྣམས་སླར་གསོན་པར་འགྱུར་བའི་དུས་སུ། སྤུན་བདུན་པོས་བུད་མེད་དེར་གཉེན་སྒྲིག་བྱས་མྱོང་བས་ཁོ་མོ་ནི་སྤུན་བདུན་ཡོད་པ་ལས་སུའི་བཟའ་ཟླ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ཡེ་ཤུས་དེ་རྣམས་ལ་“ཁྱོད་ཚོས་དཀོན་མཆོག་གི་གསུང་རབ་མི་རྟོགས་ཤིང་ཁོང་ཉིད་ཀྱི་མཐུ་སྟོབས་ཀྱང་མི་ཤེས་པས་ནོར་བ་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","གང་ལགས་ཟེར་ན། གཤིན་པོ་སླར་གསོན་པའི་སྐབས་སུ། མི་རྣམས་ཀྱིས་ཚུར་མནའ་མ་མི་ལེན་ཞིང་ཕར་བག་མ་ཡང་མི་བསྐྱལ་བས་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་དང་འདྲའོ། ");
INSERT INTO bod_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","འོན་ཀྱང་གཤིན་པོ་གསོན་པོར་ལང་དུ་གྱུར་ངེས་པའི་སྐོར་ལ། ཁྱོད་ཚོས་གསུང་རབ་ཀྱི་ལུང་སྟོན་པ་མོ་ཤེའི་མདོ་ལས་ཚེར་མའི་སྐོར་བྲིས་ཡོད་པ་དེ་ལས་དཀོན་མཆོག་གིས་མོ་ཤེ་ལ་འདི་ལྟར་གསུངས། ང་ནི་ཁྱེད་ཀྱི་མེས་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང༌། ཨི་སཱག་གི་དཀོན་མཆོག ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ཡིན་ཞེས་གསུངས་ཡོད་པ་དེ་མ་བཀླགས་སམ། ");
INSERT INTO bod_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ཁོང་ནི་གཤིན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་མ་ཡིན་ཏེ། གསོན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡིན་པས་ཁྱོད་ཚོས་ཤིན་ཏུ་ནོར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཞིག་འོངས་ནས་ཁོང་ཚོའི་རྩོད་པ་ཐོས་ཏེ། ཡེ་ཤུས་ལན་ཡག་པོ་མཛད་པ་མཐོང་བས། ཁོང་ལ་“བཀའ་ཁྲིམས་ཀྱི་ནང་ནས་གལ་ཆེ་ཤོས་གང་ཡིན་”ཞེས་བཀའ་འདྲི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","དེའི་ལན་དུ་ཡེ་ཤུས་“གལ་ཆེ་ཤོས་དང་པོ་ནི། ཀྱེ། ངའི་མི་རིགས་ཡི་སི་ར་ཨེལ་ཉོན་ཅིག གཙོ་བོ་དཀོན་མཆོག་ནི་ང་ཚོའི་གཙོ་བོ་གཅིག་རང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","རང་གིས་གཙོ་བོ་དཀོན་མཆོག་ལ་བློ་གཅིག་སེམས་གཅིག་དང་ནུས་པ་ཅི་ཡོད་ཀྱིས་བརྩེ་བར་ཟུངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","གཉིས་པ་ནི། ཁྱེད་རང་གིས་ཁྱིམ་མཚེས་ལ་རང་དང་འདྲ་བར་བརྩེ་བར་ཟུངས་ཤིག འདི་གཉིས་ལས་གལ་ཆེ་བའི་བཀའ་ཁྲིམས་གཞན་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ཡང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དེས་“སྟོན་པ་ལགས། ཁྱེད་ཀྱིས་བདེན་ཅིང་ལེགས་པར་གསུངས། དཀོན་མཆོག་ནི་གཅིག་ཡིན། ཁོང་ལས་གཞན་པའི་དཀོན་མཆོག་ཡོད་པ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ཁོང་ལ་བློ་གཅིག་སེམས་གཅིག་དང་ནུས་པ་ཅི་ཡོད་ཀྱིས་བརྩེ་བ་དང༌། རང་གི་ཁྱིམ་མཚེས་ལ་རང་དང་འདྲ་བར་བརྩེ་བར་བྱེད་པ་དེ་ནི་སྦྱིན་སྲེག་དང་མཆོད་པ་ཐམས་ཅད་ལས་གཙོ་ཆེའོ་”ཞེས་བརྗོད། ");
INSERT INTO bod_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ཡེ་ཤུས་མི་དེས་བློ་གྲོས་ཀྱི་སྒོ་ནས་ལན་བཏབ་པ་གཟིགས་ནས་མི་དེ་ལ་“ཁྱེད་རང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དང་ཐག་རིང་པོ་མེད་”ཅེས་གསུངས་པ་དང༌། དེའི་རྗེས་སུ་མི་སུས་ཀྱང་ཁོང་ལ་དྲི་བ་ཅི་ཡང་འདོན་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ཡེ་ཤུས་མཆོད་ཁང་ཆེན་མོར་ཆོས་གསུང་བའི་སྐབས་སུ་“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ནི་ཇི་ལྟར་གནའ་རབས་ཀྱི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ཡིན་ཟེར་བ་ཅི་ཟེར་ཞེ་ན། ");
INSERT INTO bod_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","རྒྱལ་པོ་དཱ་བིད་རང་གིས་དམ་པའི་ཐུགས་ཉིད་ཀྱི་སྒོ་ནས་གསུངས་ཏེ། དཀོན་མཆོག་གིས་ནི་ང་ཡི་གཙོ་བོ་ལ། ། ཁྱེད་ཀྱི་དགྲ་རྣམས་ཁྱེད་ཀྱི་ཞབས་འོག་ཏུ། ། ང་ཡིས་མ་བཅུག་བར་དུ་ཁྱེད་རང་ཉིད། ། ང་ཡི་གཡས་སུ་དེ་བར་བཞུགས་སུ་གསོལ། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","དཱ་བིད་རང་ཉིད་ཀྱིས་ཁོང་ལ་གཙོ་བོ་ཞེས་ཞུས་པས་མཱ་ཤི་ཀ་ནི་དཱ་བིད་ཀྱི་སྲས་སུ་ཇི་ལྟར་འགྱུར་བ་ཡིན་ནམ་”ཞེས་གསུངས། མི་ཚོགས་མང་པོས་ཀྱང་སེམས་དགའ་བའི་ངང་ནས་ཁོང་གི་གསུང་ལ་ཉན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ཡེ་ཤུས་ཆོས་གསུང་བཞིན་“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ལ་དོགས་ཟོན་གྱིས་ཤིག ཁོ་རྣམས་ཀྱིས་གོས་རིང་པོ་གྱོན་ཏེ་ཕར་འགྲོ་ཚུར་འོང་བྱེད་པ་དང༌། ཁྲོམ་ལ་མི་རྣམས་ཀྱིས་ཕྱག་བྱེད་པར་མོས། ");
INSERT INTO bod_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","མི་དེ་ཚོས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་ཁྲི་མཐོ་ས་དང་མགྲོན་ལ་གྲལ་མགོ་ལ་སྡོད་པར་དགའ་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","མི་དེ་རྣམས་ཀྱིས་ཡུགས་མོ་རྣམས་ཀྱི་རྒྱུ་ནོར་ཧམ་འཕྲོག་བྱེད་ཅིང་ཕྱི་ཚུལ་བཅོས་མའི་ཚུལ་གྱིས་སྨོན་ལམ་རྒྱུན་རིང་འདེབས་ཁུལ་བྱེད་པས། མི་དེ་ཚོར་ལྷག་པར་དུ་ཆད་པ་ལྗིད་པོ་ཕོག་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","དེ་ནས་ཡེ་ཤུས་མཆོད་ཁང་ཆེན་མོའི་དངུལ་འབུལ་སྒམ་ལ་ཁ་གཏད་ནས་བཞུགས་ཤིང་མང་ཚོགས་ཀྱིས་དངུལ་འབུལ་བར་གཟིགས་པ་ན། མི་ཕྱུག་པོ་རྣམས་ཀྱིས་དངུལ་མང་པོ་ཕུལ་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","དབུལ་པོ་ཡུགས་མོ་ཞིག་ཡོང་ནས་ཟངས་ཀྱི་སྒོར་མོ་ཆུང་ཆུང་གཉིས་ཕུལ་བ་གཟིགས། དེ་ནི་སྒོར་མོ་གཅིག་གི་རིན་ཐང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ཁོང་གིས་ཉེ་གནས་རྣམས་རང་གི་དྲུང་དུ་བོས་ཏེ་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། དངུལ་འབུལ་མཁན་ཐམས་ཅད་ལས་དབུལ་པོ་ཡུགས་མོ་འདིས་ཕུལ་བ་མང་ཤོས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","གང་ལགས་ཟེར་ན། དེ་ཚོ་ཐམས་ཅད་ཀྱིས་ལོངས་སྤྱོད་ལྷག་མ་མང་པོ་ནས་ཕུལ་བ་ཡིན། འོན་ཀྱང་ཁོ་མོ་ནི་རང་ལ་མེད་ཀྱང་ཅི་ཡོད་པ་ཐམས་ཅད་ཕུལ་བ་ཡིན་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ཡེ་ཤུ་མཆོད་ཁང་ཆེན་མོ་ནས་ཕྱིར་ཕེབས་སྐབས། ཉེ་གནས་ལས་གཅིག་གིས་ཁོང་ལ་“སྟོན་པ་ལགས་གཟིགས་དང༌། འདི་ནི་ཅི་ལྟ་བུའི་རྡོ་ཆེན་པོ་དང་ཅི་ལྟ་བུའི་ཁང་པའི་བཟོ་བཀོད་ངོ་མཚར་ཆེ་བ་ཞིག་རེད་ཨང་”ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ཡེ་ཤུས་“ཁྱེད་ཀྱིས་ཁང་པ་ཆེན་པོ་འདི་རྣམས་མཐོང་བ་ཡིན་ནམ། མ་འོངས་པའི་དུས་སུ་འདི་རུ་རྡོ་ཕ་བོང་གཅིག་ཀྱང་མི་ལུས་པར་ཐམས་ཅད་གཞིག་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","དེ་ནས་ཡེ་ཤུ་སྐྱུར་རུ་ཤིང་གི་རི་སྟེང་དུ་ཕེབས་ཏེ་མཆོད་ཁང་ཆེན་མོ་ལ་ཁ་གཏད་ནས་བཞུགས་པའི་སྐབས་སུ། ཁོང་གི་ཉེ་གནས་པེ་ཏྲོ་དང་ཡ་ཀོབ། ཡོ་ཧ་ནན། ཨན་དྲི་ཡཱ་བཅས་ཀྱིས་མི་གཞན་མེད་པའི་དུས་སུ་ཁོང་ལ་འདི་ལྟར་དྲིས་ ");
INSERT INTO bod_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“དོན་འདི་རྣམས་དུས་ནམ་ཞིག་ལ་འབྱུང་ཞིང༌། དོན་འདི་ཐམས་ཅད་འགྲུབ་པའི་ཚེ་རྟགས་གང་འབྱུང་ཡོང་གསུང་རོགས་”ཞེས་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ཡེ་ཤུས་ཁོ་ཚོར་“མི་སུས་ཀྱང་ཁྱེད་ཚོ་མི་སླུ་བའི་ཕྱིར་དོགས་ཟོན་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","མི་མང་པོས་ངའི་མིང་ཐོག་ནས་ཡོང་སྟེ་ང་རང་ཡིན་ཟེར་ཞིང་མི་མང་པོར་མགོ་སྐོར་གཏོང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ཁྱེད་ཚོས་དམག་འཁྲུག་དང་དམག་འཁྲུག་སྐོར་གྱི་གཏམ་ཐོས་པའི་སྐབས་སུ་མ་འཇིགས་ཤིག དོན་འདི་ཚོ་འབྱུང་ངེས་ཀྱང་དེ་ནི་དུས་རབས་ཀྱི་མཐའ་མ་ད་དུང་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","རྒྱུ་མཚན་ནི་མི་རིགས་དང་མི་རིགས་འཁྲུག་ཅིང་རྒྱལ་ཁམས་དང་རྒྱལ་ཁམས་འཁྲུག་པ། ས་ཆ་ཁ་ཤས་ལ་ས་ཡོམ་དང་མུ་གེ་ཡང་འབྱུང་བར་འགྱུར། འདི་ཚོ་ནི་སྐྱེ་ཟུག་ཐོག་མ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","འོན་ཀྱང་ཁྱེད་ཚོས་དོགས་ཟོན་བྱོས་ཤིག ངའི་དོན་དུ་ཁྱེད་ཚོ་ཁྲིམས་ར་ལ་སྤྲོད་ཅིང༌། ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དུ་བརྡུང་ངེས་ཡིན་ལ། ས་གནས་དཔོན་པོ་དང་རྒྱལ་པོ་རྣམས་ལ་དཔང་པོ་བྱེད་པའི་ཕྱིར་ཁྱེད་རྣམས་ཀྱང་དེ་ཚོའི་དྲུང་དུ་འཁྲིད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","དེ་བས་སྔོན་ལ་མི་རིགས་ཀུན་ལ་ངེས་པར་དུ་འཕྲིན་བཟང་སྒྲོག་དགོས། ");
INSERT INTO bod_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","དེ་ཚོས་ཁྱེད་རྣམས་ཁྲིམས་གཅོད་པར་གཏོད་པའི་སྐབས་སུ། ཁྱེད་ཚོས་སྔོན་ལ་གང་ཟེར་དགོས་པ་སེམས་ཁྲལ་མ་བྱེད་ཅིག དེའི་དུས་སུ་ཁྱེད་ཚོ་ལ་གང་གནང་བ་དེ་ཤོད་ཅིག རྒྱུ་མཚན་ནི་གཏམ་ཤོད་མཁན་དེ་ནི་ཁྱེད་རང་ཉིད་མ་ཡིན་པར་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","དེའི་དུས་སུ་གཅེན་གཅུང་གིས་གཅེན་གཅུང་དང༌། ཨ་ཕས་རང་གི་བུ་ཡང་གསོད་པའི་ཕྱིར་གཏད་པར་འགྱུར། ཕྲུ་གུ་རྣམས་ཀྱིས་ཀྱང་ཕ་མ་དགྲ་རུ་བཟུང་སྟེ་གསོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ཡང་ངའི་མིང་གི་དོན་དུ་མི་ཐམས་ཅད་ཀྱིས་ཁྱེད་ཚོ་ལ་སྡང་བར་བྱ། འོན་ཀྱང་ཚེའི་མཐའ་མཇུག་བར་དུ་བཟོད་པ་སྒོམ་མཁན་དེ་ལ་ཐར་པ་འཐོབ་ངེས་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“འདི་ཀློག་མཁན་གྱིས་ཧ་གོ་བར་གྱིས་ཤིག སྟོང་བར་བྱེད་མཁན་གདུག་པ་ཅན་ཁོ་མི་འོས་པའི་གནས་ལ་ལངས་བསྡད་པར་མཐོང་བའི་ཚེ། ཡ་ཧུ་དཱ་ཡུལ་དུ་ཡོད་པའི་མི་རྣམས་རི་ལ་བྲོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ཁང་པའི་ཐོག་ལ་ཡོད་པ་མར་མ་འབབ། རང་གི་ཁང་པའི་ནང་ནས་ཅ་ལག་ལེན་དུ་མི་འགྲོ ");
INSERT INTO bod_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ཞིང་ཁར་ཡོད་པའི་མི་རང་གི་གོས་ལེན་དུའང་ཕྱིར་མ་ལོག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ཉིན་དེ་ཚོའི་རིང་ལ་བུད་མེད་ཕྲུ་གུ་འཁོར་བ་དང་བུ་ཕྲུག་ལ་འོ་མ་སྟེར་བ་རྣམས་ལ་སྙིང་རེ་རྗེ། ");
INSERT INTO bod_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","དོན་དེ་དགུན་ཁར་མི་འབྱུང་བའི་ཕྱིར་ཁྱེད་ཚོས་སྨོན་ལམ་ཐོབས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","དེའི་དུས་སུ་སྡུག་བསྔལ་ཤིན་ཏུ་ཆེན་པོ་འབྱུང་ཡོང༌། དེ་ལྟ་བུའི་སྡུག་བསྔལ་ཆེན་པོ་དེ་དཀོན་མཆོག་གིས་ཐོག་མར་འཇིག་རྟེན་བཀོད་པ་ནས་ད་ལྟའི་བར་དུ་བྱུང་མ་མྱོང་ལ་རྗེས་སུའང་རྩ་བ་ནས་འབྱུང་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ཡང་གཙོ་བོ་དཀོན་མཆོག་ཁོང་གིས་ཉིན་དེ་རྣམས་ཉུང་བར་མ་མཛད་ན། མི་སུ་ཡང་ཐར་མི་ཐུབ། འོན་ཀྱང་ཁོང་གིས་བདམས་པའི་མི་རྣམས་ཀྱི་དོན་དུ་ཉིན་དེ་རྣམས་ཇེ་ཉུང་དུ་མཛད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","དེའི་དུས་སུ་མི་སུ་ཞིག་གིས་ཁྱེད་རྣམས་ལ་ལྟོས་དང༌། སྐྱབས་མགོན་མཱ་ཤི་ཀ་འདི་རུ་ཡོད། ཡང་ན་ལྟོས་དང༌། མཱ་ཤི་ཀ་དེ་རུ་ཡོད་ཟེར་ན། དེར་ཡིད་མ་ཆེས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","གང་ལགས་ཟེར་ན། མཱ་ཤི་ཀ་དང་ལུང་སྟོན་པ་རྫུན་མ་མང་པོ་འབྱུང་སྟེ། ངོ་མཚར་ཆེ་བའི་ལས་དང་ལྟས་བསྟན་ནས་མགོ་སྐོར་བཏང་སྲིད་ན། བདམས་པའི་མི་རྣམས་ཀྱང་མགོ་འཁོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","འོན་ཀྱང་ཁྱེད་རྣམས་དོགས་ཟོན་བྱོས་ཤིག ངས་གཏམ་དེ་ཐམས་ཅད་ཁྱེད་རྣམས་ལ་སྔོན་ལ་བཤད་པ་ཡིན།” ");
INSERT INTO bod_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“དུས་དེར་སྡུག་བསྔལ་ཆེན་པོ་དེའི་རྗེས་སུ། ཉི་མ་སྒྲིབ་པ་དང་ཟླ་བས་འོད་མི་སྤྲོ། ");
INSERT INTO bod_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","སྐར་མ་ནམ་མཁའ་ནས་སར་ལྷུང་ཞིང་བར་སྣང་ཁམས་ཀྱི་དབང་ལྡན་རྣམས་གཡོ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","དེའི་དུས་སུ་མི་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་ཁོང་དབང་ཆེན་པོ་དང་གཟི་བརྗིད་ངང་ནས་སྤྲིན་གྱི་ནང་ནས་འབྱོན་པར་མཐོང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","དེ་ནས་ཁོང་གིས་ཕོ་ཉ་རྣམས་བཏང་སྟེ་ས་གཞི་ཆེན་པོའི་མཐའ་ནས་ནམ་མཁའི་མཐའ་བར་གྱི་བདམས་པའི་མི་ཐམས་ཅད་ཕྱོགས་བཞི་མཚམས་བརྒྱད་ནས་བསྡུ་བར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ཁྱེད་ཚོས་བསེ་ཡབ་ཤིང་ནས་དཔེ་ཞིག་ལོངས་དང༌། དེའི་ཡལ་གར་ལོ་མ་འབུས་ནས་མཉེན་པའི་དུས་སུ། དབྱར་ཁའི་དུས་ཉེ་བར་སླེབས་པ་ཁྱེད་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","དེ་བཞིན་དུ་ཁྱེད་ཚོས་དོན་དེ་རྣམས་བྱུང་བ་མཐོང་ཚེ། ཁོང་ཡང་སྒོ་འགྲམ་དུ་ཉེ་བར་སླེབས་ཡོད་པའང་རྟོགས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་རབས་འདི་མེད་པར་མ་གྱུར་བའི་སྔོན་ལ་དོན་འདི་ཐམས་ཅད་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","གནམ་ས་གཉིས་ནི་འདའ་བར་འགྱུར་ཡང་ངའི་བཀའ་འདའ་བར་མི་འགྱུར་རོ། །” ");
INSERT INTO bod_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ཉིན་མོ་དེ་དང་དུས་ཚོད་དེའི་སྐོར་ཡབ་དཀོན་མཆོག་གིས་མ་གཏོགས། སུས་ཀྱང་མི་ཤེས། དཀོན་མཆོག་གི་བཞུགས་གནས་ཀྱི་ཕོ་ཉ་རྣམས་ཀྱིས་ཀྱང་མི་ཤེས་ལ་སྲས་ཀྱིས་ཀྱང་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ནམ་དུས་ལ་བབ་པ་ཁྱེད་ཚོས་མི་ཤེས་པས་དོགས་ཟོན་བྱོས་ཤིག གཉིད་མ་ལོག་ཅིག ");
INSERT INTO bod_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","འདི་ནི་མི་ཞིག་གིས་རང་ཁྱིམ་བཞག་ནས་ཡུལ་གཞན་དུ་འགྲོ་བའི་སྐབས་སུ། རང་གི་གཡོག་པོ་རྣམས་ལ་དབང་ཆ་སྤྲད་པ་དང་སོ་སོར་ལས་ཀ་བགོས་པ། སྒོ་སྲུང་མཁན་ལའང་བྱ་ར་བྱེད་པའི་བཀའ་གནང་བ་དང་འདྲའོ། ");
INSERT INTO bod_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","དེ་བས་ཁྱིམ་བདག་དེ་ནི་མཚན་མོའམ་ནམ་ཕྱེད་དམ། བྱ་ཕོས་སྐད་རྒྱག་དུས་སམ། སྐྱ་རེངས་ཤར་དུས་ནམ་ཞིག་ལ་ཡོང་བ་ཁྱེད་ཚོས་མི་ཤེས་པས་བྱ་ར་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","དེ་ལྟར་མ་བྱས་ན་ཁོང་གློ་བུར་དུ་ལོག་ཡོང་ནས་ཁྱེད་ཚོ་གཉིད་ལོག་པ་མཐོང་ཉེན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ངས་ཁྱེད་ཚོ་ལ་གང་སྨྲས་པ་འདི་ངས་མི་ཐམས་ཅད་ལ་ཟེར། བྱ་ར་གྱིས་ཤིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","པེ་སག་དུས་ཆེན་དང་སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་ཉིན་གཉིས་ཀྱི་སྔོན་ལ། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མིས་གཡོ་ཐབས་ཀྱིས་ཡེ་ཤུ་འཛིན་བཟུང་དང་གསོད་པའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","གང་ལགས་ཟེར་ན། མི་དེ་ཚོས་“ཡུལ་མི་རྣམས་ཟིང་ཆ་ལངས་ཉེན་ཡོད་པས། དུས་ཆེན་ལ་མི་གཟུང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","དེ་ནས་ཡེ་ཤུ་པེ་ཐན་ཡཱ་གྲོང་སྡེའི་ནང་མཛེ་ནད་ཅན་གྱི་སྐྱེས་པ་སི་མོན་གྱི་ཁང་པ་ལ་བཞུགས་ཏེ། གསོལ་བ་བཞེས་པའི་དུས་སུ་བུད་མེད་ཅིག་གིས་རིན་གོང་ཆེ་བའི་སྤོས་ཆུ་ལྷད་མེད་པ་ནཱར་དཱི་ཡིས་གང་བའི་རྡོ་ཀ་མ་རུའི་བུམ་པ་ཞིག་ཁྱེར་ཡོང་སྟེ། བུམ་པ་དེའི་ཁ་བཅག་ནས་སྤོས་ཆུ་ཁོང་གི་དབུ་སྟེང་ལ་བླུགས་པས། ");
INSERT INTO bod_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","དེ་རུ་ཡོད་པའི་མི་འགའ་ཞིག་ཁྲོས་ནས་ཕན་ཚུན་“སྤོས་ཆུ་འདི་གང་གི་དོན་ལ་འདི་ལྟར་ཆུད་ཟོས་ལ་བཏང་བ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","སྤོས་ཆུ་འདི་དེ་ཎ་རིའི་དངུལ་སྒོར་སུམ་བརྒྱ་ལས་ལྷག་པའི་རིན་དུ་བཙོངས་ཏེ་དབུལ་པོ་རྣམས་ལ་བྱིན་ན་མི་ལེགས་སམ་”ཞེས་སྨྲས་ཤིང་བུད་མེད་དེར་གཤེ་གཤེ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","འོན་ཀྱང་ཡེ་ཤུས་“ཁོ་མོ་ལ་སྡུག་པོ་མ་གཏོང༌། ཁོ་མོའི་སེམས་ཅི་ལ་དཀྲུག ཁོ་མོས་ང་ལ་ལས་བཟང་པོ་ཞིག་བྱས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","དབུལ་པོ་རྣམས་ནི་དུས་རྟག་ཏུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཡོད་པས། ག་དུས་ཡིན་རུང་ཁོ་ཚོར་རོགས་པ་བྱ་འདོད་ན་བྱེད་ཐུབ། འོན་ཀྱང་ང་རང་ནི་དུས་རྟག་ཏུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་མི་གནས། ");
INSERT INTO bod_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ཁོ་མོས་གང་ཐུབ་པ་དེ་བྱས་པ་ཡིན། ཁོ་མོས་ང་རང་དུར་ཁང་དུ་འཇུག་པར་སྔ་མོ་ནས་ངའི་ལུས་སྟེང་ལ་སྤོས་ཆུ་བླུགས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། འཇིག་རྟེན་ཡོངས་སུ་ངའི་འཕྲིན་བཟང་འདི་གང་དུ་བསྒྲགས་ན་བུད་མེད་འདིས་གང་བྱས་པ་དེ་དྲན་པའི་ཕྱིར་གཏམ་དེ་ཡང་བརྗོད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ཡེ་ཤུའི་ཉེ་གནས་བཅུ་གཉིས་ཀྱི་ནང་ནས་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་ཞེས་པ་དེས། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱི་རྩར་སོང་ནས་ཡེ་ཤུ་ཁོ་ཚོའི་ལག་ཏུ་སྤྲོད་རྒྱུ་བྱས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ཁོ་ཚོས་ཡུ་དཱ་དབྱི་སི་ཀར་རེའི་སྐད་ཆ་འདི་ཐོས་ནས་ཧ་ཅང་དགའ་པོ་བྱུང་སྟེ་ཁོ་ལ་དངུལ་སྤྲོད་རྒྱུའི་ཁས་ལེན་བྱས། དེ་ནས་བཟུང་ཡུ་དཱས་ཡེ་ཤུ་ཁོ་ཚོའི་ལག་ཏུ་སྤྲོད་རྒྱུའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་གྱི་ཉིན་དང་པོར། པེ་སག་དུས་ཆེན་གྱི་ལུགས་སྲོལ་ལྟར་སྦྱིན་སྲེག་གི་ལུ་གུ་མཆོད་པ་ཕུལ་བའི་ཚེ། ཉེ་གནས་རྣམས་ཀྱིས་ཡེ་ཤུ་ལ་“ཁྱེད་ཀྱིས་པེ་སག་གི་ཞལ་ཟས་བཞེས་པའི་ཕྱིར་ང་ཚོ་གང་དུ་གྲ་སྒྲིག་བྱེད་པར་འགྲོ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ཁོང་གིས་ཉེ་གནས་གཉིས་བཏང་སྟེ་གསུངས་པ་“གྲོང་ཁྱེར་དུ་སོང་དང༌། དེར་ཆུ་བུམ་འཁྱེར་མཁན་སྐྱེས་པ་ཞིག་ཁྱེད་གཉིས་དང་འཕྲད་ཅིང༌། དེའི་རྗེས་སུ་འབྲང་ནས་སོང་ཞིག ");
INSERT INTO bod_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ཁོ་རང་ཁྱིམ་གང་དུ་སོང་ན་ཁྱེད་ཚོས་ཁྱིམ་དེའི་བདག་པོ་ལ་སྟོན་པས། ང་རང་དང་ཉེ་གནས་རྣམས་ཀྱིས་མཉམ་དུ་པེ་སག་གི་ཟས་ཟ་བའི་ཁང་མིག་གང་དུ་ཡོད་ཅེས་ཤོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","མི་དེས་ཁྱེད་ཚོ་ལ་ནང་ཆས་སོགས་གྲ་སྒྲིག་བྱས་ཡོད་པའི་ཐོག་ཁང་ཆེན་པོ་ཞིག་བསྟན་ཡོང༌། གནས་དེ་རུ་གྲ་སྒྲིག་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ཉེ་གནས་དེ་གཉིས་གྲོང་ཁྱེར་དུ་སོང་སྟེ་ཁོང་གིས་གསུངས་པ་ལྟར་མཐོང་ནས་པེ་སག་གི་གསོལ་སྟོན་བཤམས། ");
INSERT INTO bod_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","མཚན་མོ་དེའི་དུས་སུ། ཁོང་དང་ཉེ་གནས་བཅུ་གཉིས་པོ་འཁོར་དང་བཅས་པ་མཉམ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ཁོང་རྣམས་བཞུགས་ནས་ཞལ་ཟས་བཞེས་པའི་དུས་སུ་ཡེ་ཤུས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ང་དང་མཉམ་དུ་ཟས་ཟ་མཁན་ཁྱེད་རྣམས་ལས་མི་གཅིག་གིས་ང་ལ་རྒྱབ་གཏོད་བྱེད་ངེས་སོ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ཁོ་ཚོའི་སེམས་སྐྱོ་བར་གྱུར་ཏེ། རེ་རེ་བཞིན་གྱིས་ཁོང་ལ་“ང་རང་ཡིན་མི་སྲིད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ཡང་ཁོང་གིས་“དེ་ནི་ཁྱེད་ཉེ་གནས་བཅུ་གཉིས་པོ་ལས་ང་དང་མཉམ་དུ་ཕོར་པའི་ནང་དུ་བག་ལེབ་སྦངས་ནས་ཟ་མཁན་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","རྒྱུ་མཚན་ནི་དཀོན་མཆོག་གི་གསུང་རབ་ལས་མིའི་རིགས་ཀྱི་བུ་རང་ཉིད་ཀྱི་སྐོར་ལ་ཇི་ལྟར་ལུང་བསྟན་ཡོད་པ་བཞིན་འཆི་དགོས་ཀྱང༌། མིའི་རིགས་ཀྱི་བུ་དགྲའི་ལག་ཏུ་སྤྲོད་མཁན་དེར་ཆད་པ་ཕོག་ངེས་ཡིན་ནོ། མི་དེ་འཇིག་རྟེན་འདི་རུ་སྐྱེས་པ་ལས་མ་སྐྱེས་ན་ལེགས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ཁོང་རྣམས་ཀྱིས་ཞལ་ཟས་བཞེས་པའི་སྐབས་སུ། ཡེ་ཤུས་བག་ལེབ་ཕྱག་ཏུ་བསྣམས་ཤིང་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་རྗེས་དུམ་བུར་བགོས་ནས་ཁོང་རྣམས་ལ་གནང་སྟེ་གསུངས་པ་“འདི་ནི་ངའི་ལུས་ཡིན། ཁྱེད་ཚོས་ལེན་ཅིག་”ཅེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ཁོང་གིས་ཕོར་པ་ཞིག་ཕྱག་ཏུ་བསྣམས་ཤིང་བཀའ་དྲིན་ཆེ་ཞུས་ནས་ཁོང་རྣམས་ལ་གནང་བ་དང་ཚང་མས་བཏུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ཁོང་གིས་“འདི་ནི་ངའི་ཁྲག་ཡིན་ཏེ། ཞལ་ཆད་ཀྱི་ཁྲག་འདི་མི་མང་པོའི་ཆེད་དུ་ཐོན། ");
INSERT INTO bod_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ངས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་ནང་རྒུན་ཆང་གསར་པ་མ་འཐུང་བའི་ཉིན་མོའི་བར་དུ། རྒུན་ཆང་འདི་རྩ་བ་ནས་མི་འཐུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","དེ་ནས་ཁོང་རྣམས་ཀྱིས་གསུང་མགུར་བླངས་ནས་སྐྱུར་རུ་ཤིང་གི་རི་བོར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","དེ་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“དཀོན་མཆོག་གི་གསུང་རབ་ལས། ང་ཡིས་ལུག་རྫི་རྡུང་ནས་བསད། ། དེ་རྗེས་ལུག་རྣམས་འཐོར་བར་འགྱུར། ། ཞེས་བྲིས་པ་བཞིན། ཁྱོད་ཚོ་ཐམས་ཅད་ང་དང་བྲལ་ནས་འབྲོས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","འོན་ཀྱང་ང་འཆི་བ་ནས་གསོན་པོར་ལང་དུ་འགྱུར་རྗེས་ཁྱེད་ཚོའི་སྔོན་ལ་ག་ལིལ་ཡུལ་དུ་འགྲོ་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","པེ་ཏྲོས་ཁོང་ལ་“ཐམས་ཅད་ཁྱེད་དང་བྲལ་ནའང་ང་ནི་མི་འབྲལ་”ཞེས་ཞུས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ཡེ་ཤུས་ཁོ་ལ་“ངས་ཁྱེད་ལ་བདེན་པར་ཟེར་རྒྱུར། དེ་རིང་གི་མཚན་མོ་འདི་རང་ལ་བྱ་ཕོས་སྐད་ཐེངས་གཉིས་མ་གྲགས་པའི་སྔོན་ལ་ཁྱེད་ཀྱིས་ང་རང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་ཟེར་བར་ངེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","འོན་ཀྱང་པེ་ཏྲོས་ཁོང་ལ་“ང་ནི་ཁྱེད་དང་མཉམ་དུ་ཤི་དགོས་ཀྱང་ཁྱེད་སུ་ཡིན་མི་ཤེས་ཞེས་ཟེར་མི་སྲིད་”ཅེས་ནན་གྱིས་ཞུས་ཤིང་ཉེ་གནས་གཞན་རྣམས་ཀྱིས་ཀྱང་དེ་ལྟར་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","དེ་ནས་ཁོང་རྣམས་གེད་སེམ་མཱ་ནེ་ཞེས་བྱ་བའི་གནས་སུ་ཕེབས་པ་དང༌། ཁོང་གིས་རང་གི་ཉེ་གནས་རྣམས་ལ་“ངས་གསོལ་བ་འདེབས་དུས་ཁྱེད་ཚོ་གནས་འདིར་སྡོད་ཅིག་”ཅེས་གསུངས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ཉེ་གནས་རྣམས་ལས་པེ་ཏྲོ་དང༌། ཡ་ཀོབ། ཡོ་ཧ་ནན་གསུམ་ཁྲིད་པ་དང༌། དེའི་ཚེ་ཁོང་ཉིད་ཀྱི་ཐུགས་ཤིན་ཏུ་འཁྲུགས་པར་གྱུར་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“ངའི་ཡིད་ཤིན་ཏུ་སྐྱོ་ཞིང་འཆི་ལ་ཉེ་བས། ཁྱེད་ཚོ་འདི་རུ་གཉིད་མ་ལོག་པར་དོགས་ཟོན་བྱོས་ཤིག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","དེ་ནས་ཁོང་ཅུང་ཟད་ཕར་ཕེབས་ནས་ཕྱག་འཚལ་ཏེ་“གལ་སྲིད་སྒྲུབ་འོས་པ་ཡིན་ན་ང་ནི་དུས་འདི་ལས་ཐར་བར་མཛོད་ཅིག ངའི་ཡབ་ལགས། ཁྱེད་ཀྱིས་དོན་ཐམས་ཅད་སྒྲུབ་སྲིད་པས་སྡུག་བསྔལ་གྱི་ཕོར་པ་འདི་ང་ལས་ཕར་ལེན་མཛོད། འོན་ཀྱང་ངའི་བསམ་པ་བཞིན་དུ་མི་འགྱུར་བར་ཁྱེད་ཀྱི་དགོངས་པ་བཞིན་དུ་གྱུར་ཅིག་”ཅེས་གསོལ་བ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ཁོང་ཚུར་ཕེབས་སྐབས་ཁོ་རྣམས་གཉིད་ལོག་གི་ཡོད་པར་གཟིགས་ནས་པེ་ཏྲོ་ལ་“སི་མོན། ཁྱེད་གཉིད་ལོག་གི་ཡོད་དམ། ཆུ་ཚོད་གཅིག་ཙམ་ལའང་དོགས་ཟོན་བྱ་མི་ནུས་སམ། ");
INSERT INTO bod_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ཁྱེད་བསླུ་བར་མི་འགྱུར་བའི་ཕྱིར་དོགས་ཟོན་བྱོས་ལ་སྨོན་ལམ་ཐོབས་ཤིག སེམས་ནས་དེ་ལྟར་བྱེད་བསམས་ཀྱང་ལུས་པོའི་ནུས་ཤུགས་ཞན་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","དེ་ནས་ཡང་ཁོང་ཕར་ཕེབས་ནས་སྔ་མ་བཞིན་དུ་གསོལ་བ་བཏབ་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ཁོང་ཚུར་ཕེབས་ནས་ཁོ་རྣམས་སླར་ཡང་གཉིད་ལོག་གི་ཡོད་པར་གཟིགས། ཁོ་ཚོའི་གཉིད་ཤིན་ཏུ་ལྕི་བས་ཁོང་ལ་ལན་ཅི་ཞུས་པའང་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ཁོང་ཐེངས་གསུམ་པར་ཚུར་ཕེབས་ནས་“ཁྱེད་ཚོ་ད་དུང་ཉལ་ནས་ངལ་གསོའམ། ད་འགྲིག་སོང༌། ད་ལྟ་དུས་ལ་བབས་སོ། ལྟོས་དང༌། མིའི་རིགས་ཀྱི་བུ་ནི་ད་ལྟ་སྡིག་ཉེས་ཅན་གྱི་དབང་དུ་སྤྲོད་པར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ལྟོས་ཤིག ང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་དེ་ཉེ་བར་སླེབས་པས། ཡར་ལོངས་དང་ཁོ་རང་འཕྲད་དུ་འགྲོའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","དེ་ནས་ཁོང་གིས་དེ་ལྟར་གསུངས་མ་ཐག་ཉེ་གནས་བཅུ་གཉིས་པོ་ལས་ཡུ་དཱ་ཞེས་བྱ་བ་དེ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི། རྒན་པོ་རྣམས་ཀྱི་ས་ནས་ལག་ཏུ་རལ་གྲི་དང་དབྱུག་པ་འཁྱེར་བའི་མི་ཚོགས་དང་བཅས་པ་དེར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ཡེ་ཤུ་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་དེས་སྔོན་ནས་ཁོ་ཚོར་གསང་བརྡ་གྲ་སྒྲིག་བྱས་ཏེ་“ངས་སུ་ལ་འོ་བྱས་པ་དེ་ཁོང་རང་རེད། ཁྱོད་ཚོས་ཁོང་དམ་པོར་ཟིན་ནས་ཁྲིད་ཅིག་”ཅེས་བཤད་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ཡུ་དཱ་སླེབས་མ་ཐག་ཏུ་ཡེ་ཤུའི་དྲུང་དུ་ཡོང་ནས་“རབ་བི་”ཞེས་འགྲམ་པར་འོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","དེ་ནས་ཁོ་ཚོས་ཡེ་ཤུ་འཛིན་བཟུང་བྱས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ཉེ་འགྲམ་དུ་ལངས་ནས་བསྡད་ཡོད་པ་རྣམས་ལས་མི་ཞིག་གིས་རལ་གྲི་བཏོན་ཏེ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོའི་གཡོག་པོར་བརྒྱབ་ནས་རྣ་བ་ཡ་གཅིག་བཅད། ");
INSERT INTO bod_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","དེ་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱེད་ཚོས་རལ་གྲི་དང་དབྱུག་པ་ཁྱེར་ནས་ཇག་པ་འཛིན་པ་ལྟར་ང་རང་འཛིན་དུ་ཡོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ང་ནི་ཉིན་རེ་བཞིན་མཆོད་ཁང་ཆེན་མོར་ཆོས་བསྟན་ཏེ། ཁྱེད་ཚོ་དང་མཉམ་དུ་སྡོད་སྐབས་ཁྱེད་ཚོས་ང་བཟུང་མེད། འོན་ཀྱང་དོན་འདི་སྒྲུབ་པ་ནི་དཀོན་མཆོག་གི་གསུང་རབ་ཀྱི་ལུང་བསྟན་འགྲུབ་པའི་ཕྱིར་ཡིན་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ཉེ་གནས་ཐམས་ཅད་ཀྱིས་ཀྱང་ཡེ་ཤུ་དོར་ནས་བྲོས། ");
INSERT INTO bod_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","སྐབས་དེར་ལུས་ལ་རས་རྐྱང་གྱོན་པའི་གཞོན་ནུ་ཞིག་ཁོང་གི་རྗེས་སུ་འབྲངས་པ་ལ་མི་དེ་ཚོས་ཁོ་ཡང་འཛིན་གྲབས་བྱས་པས། ");
INSERT INTO bod_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ཁོས་རས་རྐྱང་གཡུགས་ཏེ་ལུས་གཅེར་བུར་བྲོས། ");
INSERT INTO bod_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","དེ་ནས་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོའི་དྲུང་དུ་ཁྲིད་ཅིང༌། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་རྒན་པོ། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱང་དེར་འཛོམས་བཞིན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","པེ་ཏྲོའང་རྒྱང་རིང་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་ཏེ་བླ་ཆེན་གཙོ་བོའི་སྒོ་རར་ཐད་ཀར་སོང་ནས་འཁོར་གཡོག་དང་མཉམ་དུ་མེར་བསྲོ་བཞིན་བསྡད། ");
INSERT INTO bod_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","དེ་ནས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང་ཡ་ཧུ་དཱ་པའི་རྒྱལ་ཚོགས་ཀྱི་མི་ཐམས་ཅད་ཀྱིས་ཁོང་སྲོག་གཅོད་པའི་ཕྱིར་དཔང་པོ་བྱེད་མཁན་བཙལ་ཡང་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","མི་མང་པོས་རྫུན་གྱི་དཔང་པོ་བྱས་ཀྱང་དཔང་པོ་བྱས་པ་ནང་མཐུན་མ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ཡང་མི་འགའ་ཞིག་ལངས་ནས་ཁོང་ལ་རྫུན་གྱི་དཔང་པོ་བྱས་ཏེ་སྨྲས་པ་ ");
INSERT INTO bod_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ཁོས་ངས་མི་ཡི་ལག་པས་བཟོས་པའི་དཀོན་མཆོག་གི་ཕོ་བྲང་འདི་བཤིག་ནས། ཉིན་གསུམ་ལ་མི་ཡི་ལག་པས་མ་བརྩིགས་པའི་ཕོ་བྲང་གཞན་ཞིག་རྩིག་པར་བྱའོ་ཞེས་ཟེར་བ་ང་ཚོས་ཐོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","འོན་ཀྱང་དཔང་པོ་བྱས་པ་དེ་ཡང་མ་མཐུན། ");
INSERT INTO bod_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","དེ་ནས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོ་དེ་དཀྱིལ་ནས་ཡར་ལངས་ཏེ་ཡེ་ཤུ་ལ་“མི་འདི་རྣམས་ཀྱིས་ཁྱོད་ལ་དཔང་པོ་བྱེད་པ་འདི་ཅི་ཡིན་ནམ། ཁྱོད་ཀྱིས་ལན་ཅི་ཡང་མི་འདེབས་སམ་”ཞེས་དྲིས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ཁོང་གིས་ཅི་ཡང་མ་གསུངས་ཤིང་བཀའ་ལན་མ་གནང༌། ཡང་བླ་ཆེན་གཙོ་བོས་“ཁྱོད་ནི་བསྟོད་པར་འོས་པའི་དཀོན་མཆོག་གི་སྲས་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ནམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ཡེ་ཤུས་“ང་རང་ལགས་སོ། ཡང་ཁྱེད་ཚོས་མིའི་རིགས་ཀྱི་བུ་ཁོང་ཉིད་དབང་ཀུན་དང་ལྡན་པའི་དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་བཞུགས་ཏེ་ནམ་མཁའི་སྤྲིན་དང་བཅས་འབྱོན་པ་མཐོང་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","བླ་ཆེན་གཙོ་བོས་རང་གི་གོས་དབྲལ་ནས་“ད་ལྟ་ང་ཚོར་དཔང་པོ་གཞན་ཅི་ལ་དགོས། ");
INSERT INTO bod_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ཁོས་དཀོན་མཆོག་ལ་སྐུར་བ་བཏབ་པ་ཁྱེད་ཚོས་ཀྱང་ཐོས་པས་ཁྱེད་ཚོར་བསམ་འཆར་ཅི་ཡོད་”ཅེས་སྨྲས། དེ་ཚོ་ཚང་མས་ཁོང་གསོད་དགོས་པའི་ཁྲིམས་ཐག་བཅད། ");
INSERT INTO bod_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","དེ་ནས་མི་འགའ་ཞིག་གིས་ཁོང་ལ་མཆིལ་མ་གཏོར་ཞིང་སྤྱན་ཟུང་རས་ཀྱིས་བཏུམས་ཏེ་འགྲམ་ལྕག་བཞུས་ཤིང་རྫོག་བརྒྱབ་ནས་ཁོང་ལ་“ད་མངོན་ཤེས་ཤོད་ཅིག་”ཅེས་བརྗོད་པ་དང་དམག་མི་ཚོས་ཀྱང་ཁོང་ཚུར་དྲུད་ནས་བཞུས། ");
INSERT INTO bod_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","དེ་ནས་ཉེ་གནས་པེ་ཏྲོ་ཞོལ་གྱི་སྒོ་ར་ལ་བསྡད་ཡོད་པའི་སྐབས་སུ་བླ་ཆེན་གཙོ་བོའི་གཡོག་མོ་ཞིག་ཡོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ཁོ་མོས་པེ་ཏྲོ་མེར་བསྲོ་བཞིན་པ་མཐོང་ཞིང་ཁོ་ལ་ཞིབ་པར་བལྟས་ནས་“ཁྱོད་ཀྱང་ན་ཙ་རེལ་གྱི་མི་ཡེ་ཤུ་དང་མཉམ་དུ་ཡོད་པ་གཅིག་རེད་”ཅེས་སྨྲས་པས། ");
INSERT INTO bod_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","པེ་ཏྲོས་ཁས་མ་བླངས་པར་“ཁྱོད་ཀྱིས་གང་བཤད་པ་ངས་མི་ཤེས་ལ་ཧ་ཡང་མི་གོ་”ཞེས་བཤད་དེ་སྒོའི་ཕྱི་རོལ་ཏུ་སོང་བ་དང་བྱ་ཕོས་སྐད་གྲགས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ཡང་གཡོག་མོ་དེས་པེ་ཏྲོ་མཐོང་ནས་སླར་ཡང་དེ་རུ་ཡོད་པའི་མི་རྣམས་ལ་“མི་འདི་དེ་ཚོའི་ནང་ནས་གཅིག་རེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","འོན་ཀྱང་ཁོང་གིས་ཡང་བསྐྱར་ཁས་མ་བླངས། དེ་ནས་ཅུང་མ་འགོར་བར་དེར་ཡོད་པའི་མི་རྣམས་ཀྱིས་ཀྱང་པེ་ཏྲོ་ལ་“ཁྱོད་ནི་ག་ལིལ་ཡུལ་གྱི་མི་ཞིག་ཡིན་པས་དངོས་གནས་དེ་ཚོའི་ནང་ནས་གཅིག་རེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","པེ་ཏྲོས་སྡིགས་དམོད་བྱེད་བཞིན་མནའ་བསྐྱལ་ཏེ་“ཁྱོད་ཚོས་ཟེར་བའི་མི་དེ་ངས་ངོ་མི་ཤེས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","དེ་མ་ཐག་ཏུ་བྱ་ཕོས་སྐད་ཐེངས་གཉིས་པ་གྲགས་པས། པེ་ཏྲོས་དེ་སྔ་ཡེ་ཤུས་ཁོ་རང་ལ། བྱ་ཕོས་སྐད་ཐེངས་གཉིས་མ་གྲགས་པའི་སྔོན་དུ་ཁྱེད་ཀྱིས་ང་རང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་སྨྲ་བར་ངེས་ཞེས་གསུངས་པ་དེ་དྲན་ནས་སེམས་ཤིན་ཏུ་སྐྱོ་སྟེ་ངུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ནམ་ལངས་མ་ཐག་ཏུ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང་རྒན་པོ། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས། རྒྱལ་ཚོགས་ཀྱི་མི་ཐམས་ཅད་མཉམ་དུ་གྲོས་བྱས་ཏེ། ཡེ་ཤུ་བཀྱིགས་ནས་ཁྲིད་དེ་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ལ་བཏད། ");
INSERT INTO bod_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","པི་ལ་ཏུས་“ཁྱོད་ནི་ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒྱལ་པོ་ཡིན་ནམ་”ཞེས་ཁོང་ལ་དྲིས་ནས། ཁོང་གིས་“ཁྱེད་ཀྱིས་སྨྲས་པ་བཞིན་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ཡང་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱིས་ཁོང་ལ་ཉེས་སྐྱོན་མང་པོ་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","སླར་ཡང་པི་ལ་ཏུ་ཡིས་“མི་དེ་རྣམས་ཀྱིས་ཁྱོད་ལ་ཉེས་སྐྱོན་ཇི་འདྲ་མང་པོ་འདོགས་ཀྱི་འདུག་ཨང༌། ཁྱོད་ཀྱིས་ལན་ཅིའང་མི་འདེབས་སམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ཡེ་ཤུས་བཀའ་ལན་ཅི་ཡང་མ་གསུངས་པས་པི་ལ་ཏུ་ཡང་ངོ་མཚར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","དུས་ཆེན་དེར་སྤྱི་ཁྱབ་པི་ལ་ཏུས་མི་ཚོགས་ཀྱི་འདོད་པ་ལྟར་བཙོན་པ་རེ་གློད་གྲོལ་གཏོང་བའི་ལུགས་སྲོལ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","མིང་ལ་པར་ཨབ་པཱ་ཟེར་བའི་མི་ཞིག་ཡོད་པ་དེ་ཟིང་འཁྲུག་སྐབས་མི་བསད་མྱོང་བའི་བཙོན་པ་གཞན་དང་མཉམ་དུ་བཙོན་ཁང་ནང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","མི་ཚོགས་ཀྱིས་པི་ལ་ཏུའི་རྩར་འཛོམས་ནས་སྔོན་མའི་ལུགས་སྲོལ་ལྟར་གནང་རོགས་ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","པི་ལ་ཏུས་“ཁྱོད་ཚོ་ལ་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་གློད་དགོས་ཀྱི་ཡོད་དམ་”ཞེས་སྐད་ཆ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","དེ་ནི་པི་ལ་ཏུས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱིས་ཡེ་ཤུ་ལ་ཕྲག་དོག་བྱས་ནས་ཁོང་ལ་རྩིས་སྤྲད་པ་ཤེས་ཀྱི་ཡོད་པས་རེད། ");
INSERT INTO bod_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","འོན་ཀྱང་བླ་ཆེན་རྣམས་ཀྱིས་པར་ཨབ་པཱ་གློད་པའི་ཆེད་དུ་མི་ཚོགས་ལ་ངན་བསྐུལ་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","པི་ལ་ཏུས་ཡང་བསྐྱར་ཁོ་ཚོར་“བྱས་ན་ཁྱོད་ཚོས་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཟེར་བ་དེར་ངས་གང་འདྲ་བྱེད་དགོས་སམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ཁོ་ཚོས་སྐད་ཆེན་པོས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","པི་ལ་ཏུས་“རྒྱུ་མཚན་གང་ཡིན། ཁོང་གིས་ལས་ངན་ག་རེ་བྱས་ཡོད་”ཅེས་དྲིས། འོན་ཀྱང་མི་ཚོགས་ཀྱིས་སྐད་ཤུགས་དེ་བས་ཆེན་པོས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","པི་ལ་ཏུས་མི་ཚོགས་ཀྱི་འདོད་པ་བསྐོང་ཕྱིར་པར་ཨབ་པཱ་གློད་པ་དང༌། ཡེ་ཤུ་རྟ་ལྕག་གིས་བརྡུང་དུ་བཅུག་ནས་རྒྱང་ཤིང་སྒང་ལ་གསོད་པའི་ཕྱིར་དམག་མི་ཚོར་རྩིས་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","དེ་ནས་དམག་མི་ཚོས་ཁོང་ཉིད་སྤྱི་ཁྱབ་ཀྱི་ཕོ་བྲང་གི་སྒོ་ར་ལ་ཁྲིད་དེ་དམག་ཁག་ཐམས་ཅད་བསྡུས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","དེ་ཚོས་ཁོང་གི་ལུས་ལ་མདོག་རྒྱ་སྨུག་ཅན་གྱི་ན་བཟའ་བསྐོན་པ་དང་ཚེར་མས་སླས་པའི་ཅོད་པན་ཞིག་ཀྱང་ཁོང་གི་དབུ་ལ་བསྐོན། ");
INSERT INTO bod_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ཡང་དེ་ཚོས་ཁོང་ལ་ཕྱག་ཕུལ་ཞུ་ཁུལ་བྱས་ནས་“ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ལ་ཕྱག་འཚལ་ལོ་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ཁོང་གི་དབུ་ལ་དབྱུག་པ་ཞིག་གིས་ཡང་ཡང་བརྡེག་ཅིང་གདོང་ལ་མཆིལ་མ་གཏོར། ཡང་པུས་མོ་སར་བཙུགས་ཏེ་ཁོང་ལ་ཕྱག་འཚལ་ཁུལ་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","དེ་ལྟར་ཁོང་ལ་བརྙས་བཅོས་བྱས་ཚར་རྗེས་མདོག་རྒྱ་སྨུག་ཅན་གྱི་ན་བཟའ་ཕུད་ཅིང༌། ཁོང་ལ་རང་གི་ན་བཟའ་གྱོན་དུ་བཅུག་སྟེ་རྒྱང་ཤིང་ཐོག་ལ་གཟེར་རྒྱག་པའི་ཕྱིར་ཕར་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ཁོང་ཚོ་ཕྱི་ལ་ཕེབས་སྐབས། ཨ་ལིག་ཟན་ཌེར་དང་རུ་ཕུ་སུ་ཞེས་པའི་སྤུན་གཉིས་ཀྱི་ཕ་སི་མོན་ནི་སེ་རེ་ནཱ་གྲོང་ཁྱེར་གྱི་མི་ཡིན་ལ། ཁོ་རང་གྲོང་གསེབ་ནས་འོངས། ས་ཆ་འདི་བརྒྱུད་ནས་འགྲོ་དུས། ཁོ་ཚོས་རྒྱང་ཤིང་འཁུར་དུ་འཇུག་ཕྱིར་མི་དེའང་བཙན་གྱིས་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ཡང་ཡེ་ཤུ་ཁྲིད་ནས་གོལ་གོ་ཐ་ཞེས་པ་ནི་མགོ་རུས་དང་འདྲ་བའི་ས་ཆ་ཟེར་བའི་ས་དེར་སླེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ཁོ་ཚོས་ཁོང་ལ་གུ་གུལ་ཞེས་པའི་སྨན་འདྲེས་པའི་རྒུན་ཆང་དྲངས་ཀྱང་ཁོང་གིས་མ་བཞེས། ");
INSERT INTO bod_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","དེའི་ཚེ་དམག་མི་དེ་ཚོས་ཁོང་རྒྱང་ཤིང་སྟེང་དུ་གཟེར་བརྒྱབ་ནས་བཀལ། མི་རེ་རེར་གང་ཐོབ་རྒྱན་བརྒྱབ་ནས་ཁོང་གི་ན་བཟའ་བགོ་བཤའ་བྱས། ");
INSERT INTO bod_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ཁོ་ཚོས་ཡེ་ཤུ་རྒྱང་ཤིང་སྒང་ལ་གཟེར་བརྒྱབ་ནས་བཀལ་བའི་དུས་ཚོད་ནི་ཞོགས་པའི་ཆུ་ཚོད་དགུ་པར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ཁོང་གི་ཉེས་ཚིག་ལ་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཞེས་བྲིས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ཁོང་མཉམ་དུ་ཇག་པ་གཉིས་ནས་གཅིག་ཁོང་གི་གཡས་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་དང་གཅིག་ཁོང་གི་གཡོན་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་ལ་གཟེར་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","གནས་དེར་བརྒྱུད་ནས་འགྲོ་བའི་མི་རྣམས་ཀྱིས་ཁོང་ལ་དམའ་འབེབས་བཏང་ནས་མགོ་གཡུག་བཞིན་“ཀྱེ། མཆོད་ཁང་ཆེན་མོ་བཤིག་ནས་ཉིན་གསུམ་གྱི་ནང་སླར་རྩིག་མཁན་ཁྱོད། ");
INSERT INTO bod_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ད་ལྟ་རང་ཉིད་སྐྱོབས་དང༌། རྒྱང་ཤིང་སྟེང་ནས་མར་བོབས་ཤིག་”ཅེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","དེ་བཞིན་དུ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་ཀྱང་མཉམ་དུ་ཁོང་ལ་འཕྱ་དམོད་བྱེད་དེ་“ཁོས་གཞན་རྣམས་སྐྱོབ་ཐུབ་པ་ལས་རང་ཉིད་སྐྱོབ་མི་ཐུབ་”ཅེས་ཕན་ཚུན་གླེང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“ཀྱེ། ཡི་སི་ར་ཨེལ་གྱི་རྒྱལ་པོ་སྐྱབས་མགོན་མཱ་ཤི་ཀ ང་ཚོས་མཐོང་ནས་དད་པ་བྱེད་པའི་ཕྱིར་ད་ལྟ་ཁྱོད་རང་རྒྱང་ཤིང་སྟེང་ནས་མར་བོབ་”ཅེས་སྨྲས། ཁོང་དང་མཉམ་དུ་རྒྱང་ཤིང་གཞན་ལ་གཟེར་བརྒྱབ་པའི་ཇག་པ་གཉིས་ཀྱིས་ཀྱང་ཁོང་ལ་དེ་ལྟར་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ཉིན་གུང་ལ་སླེབས་དུས་མུན་པས་ལུང་པ་དེ་ཡོངས་སུ་འཐིབས་ཏེ་ཆུ་ཚོད་གསུམ་པའི་བར་དུ་ལུས། ");
INSERT INTO bod_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ཆུ་ཚོད་གསུམ་པར་ཡེ་ཤུས་གསུང་ཆེན་པོས་“ཨེ་ལོ་ཨི། ཨེ་ལོ་ཨི། ལ་མ་ཤ་བག་ཐ་ནི་”ཞེས་པའི་དོན་དག་ནི་“ངའི་དཀོན་མཆོག ངའི་དཀོན་མཆོག ཁྱེད་ཀྱིས་ང་དོར་དགོས་དོན་ཅི་ཡིན་”ཞེས་པའོ། ");
INSERT INTO bod_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ཉེ་འགྲམ་ལ་ཡོད་པའི་མི་ཁ་ཤས་ཀྱིས་དེ་ཐོས་ནས་“ཉོན་ཅིག ཁོང་གིས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་འབོད་ཀྱི་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","མི་ཞིག་གིས་ཕར་ཕྱིན་ཏེ་རྒུན་ཆང་སྐྱུར་མོའི་ནང་སྲིང་བལ་སྦངས་ནས་དབྱུག་པའི་རྩེར་བཀོན་ཏེ་ཡེ་ཤུ་ལ་འཐུང་དུ་བཅུག་ནས་“སྒུག་ཅིག ཨེ་ལི་ཡཱས་ཁོང་མར་ཕབ་ཆེད་ཕེབས་མ་ཕེབས་བལྟའོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ཡེ་ཤུས་གསུངས་ཆེན་པོ་ཞིག་བསྐྱོན་ནས་སྐུ་ཚེ་ལས་འདས་སོ། ");
INSERT INTO bod_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","དེའི་སྐབས་མཆོད་ཁང་ཆེན་མོའི་ནང་གི་ཡོལ་བ་དེ་སྟེང་ནས་འོག་བར་དུམ་བུ་གཉིས་སུ་རལ། ");
INSERT INTO bod_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","རྒྱང་ཤིང་མདུན་དུ་ཡེ་ཤུ་དང་ཁ་ཐུག་ལངས་བསྡད་ཡོད་པའི་བརྒྱ་དཔོན་ཞིག་གིས་ཡེ་ཤུ་དེ་ལྟར་གྲོངས་པ་མཐོང་ནས་“ཁོང་དཀོན་མཆོག་གི་སྲས་ཡིན་པ་དེ་བདེན་པ་རང་རེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","རྒྱང་རིང་ནས་བལྟ་བའི་བུད་མེད་རྣམས་ཀྱི་ནང་ནས་མག་དལ་གྲོང་གསེབ་ནས་ཡིན་པའི་མིར་ཡམ་དང༌། ཡ་ཀོབ་ཆུང་བ་དང་ཡོ་སེ་གཉིས་ཀྱི་ཨ་མ་མིར་ཡམ། བུད་མེད་ས་ལོ་མེ་ཡང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","དེ་རྣམས་ནི་ཡེ་ཤུ་ག་ལིལ་ཡུལ་དུ་བཞུགས་པའི་དུས་སུ་ཁོང་གི་རྗེས་སུ་འབྲངས་ནས་ཁོང་ལ་ཞབས་ཕྱི་ཞུས་མྱོང་ཞིང༌། ཁོང་དང་མཉམ་དུ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ལ་སོང་བའི་བུད་མེད་གཞན་མང་པོ་ཡང་གནས་འདིར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ས་མ་རུབ་ཙམ་ལ་གྲོང་ཁྱེར་ཨ་རི་མ་ཐཱའི་མི་མིང་ལ་ཡོ་སེབ་ཟེར་བ་ཞིག་སླེབས། ཁོང་ནི་མིས་གུས་བཀུར་བྱེད་པའི་ཡ་ཧུ་དཱ་པའི་རྒྱལ་ཚོགས་ཀྱི་ཁོངས་མི་ཞིག་རེད་ལ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་སྒུག་མཁན་ཞིག་ཀྱང་རེད། ཉིན་དེ་ནི་གྲ་སྒྲིག་གི་ཉིན་མོ་ཡིན་ཞིང་ངལ་གསོའི་ཉིན་མོའི་ཉིན་སྔོན་མ་དེ་སོང་བས། ཡོ་སེབ་ཀྱིས་བློ་ཁོག་ཆེན་པོའི་ངང་ནས་པི་ལ་ཏུའི་སར་ཕྱིན་ཏེ་ཡེ་ཤུའི་སྐུ་ཕུང་གནང་རོགས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","པི་ལ་ཏུས་ཡེ་ཤུ་གྲོངས་ཚར་བ་ཐོས་རྗེས་ཡ་མཚན་སྐྱེས་ནས་བརྒྱ་དཔོན་སྐད་བཏང་སྟེ་ཁོང་གྲོངས་ནས་དུས་ཚོད་རིང་པོ་ཕྱིན་ཡོད་མེད་སྐད་ཆ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","བརྒྱ་དཔོན་ནས་ཡེ་ཤུ་གྲོངས་པའི་གནས་ཚུལ་ངོ་མ་ཤེས་རྗེས་པི་ལ་ཏུས་ཡེ་ཤུའི་སྐུ་ཕུང་ཡོ་སེབ་ལ་སྤྲོད་རྒྱུའི་ཆོག་མཆན་གནང༌། ");
INSERT INTO bod_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ཡོ་སེབ་ཀྱིས་རས་སྤུས་ལེགས་ཤིག་ཉོས་ཏེ་ཡེ་ཤུའི་སྐུ་ཕུང་མར་ཕབ་པ་དང་དེར་རས་ཀྱིས་བསྒྲིལ་ནས་བྲག་ལ་བརྐོས་པའི་དུར་ཁང་ཞིག་གི་ནང་ལ་བཞག དེ་ནས་རྡོ་ཆེན་པོ་ཞིག་བསྒྲིལ་ཏེ་དུར་ཁང་གི་ཁ་བཀག ");
INSERT INTO bod_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","མག་དལ་མ་མིར་ཡམ་དང་ཡོ་སེ་ཞེས་བྱ་བའི་ཨ་མ་མིར་ཡམ་གཉིས་ཀྱིས་སྐུ་གདུང་གང་དུ་བཞག་པའི་གནས་མཐོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ངལ་གསོའི་ཉིན་མོ་རྫོགས་རྗེས་གྲོང་ཁྱེར་མག་དལ་ནས་ཡིན་པའི་མིར་ཡམ་དང་ཡ་ཀོབ་ཀྱི་ཨ་མ་མིར་ཡམ། ས་ལོ་མེ་བཅས་ཀྱིས་ཡེ་ཤུའི་སྐུ་ཕུང་ལ་འབྱུག་ཆེད་ཀྱི་དྲི་ཞིམ་འབྱུག་རྫས་ཉོས་ནས། ");
INSERT INTO bod_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","བདུན་ཕྲག་གཅིག་གི་ཉིན་དང་པོའི་ཞོགས་པ་ཉི་མ་ཤར་ཙམ་ལ་ཁོང་ཚོ་དུར་ཁང་ལ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ཁོང་ཚོས་ཕན་ཚུན་“སུས་ང་ཚོར་དུར་ཁང་གི་ཁའི་རྡོ་དེ་བསྒྲིལ་ནས་ཕར་ཕྱེ་ཡོང་”ཞེས་སྐད་ཆ་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ཁོང་ཚོས་ཡར་ལྟ་དུས་རྡོ་ཧ་ཅང་ཆེན་པོ་དེ་བསྒྲིལ་ཚར་ཡོད་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","དུར་ཁང་གི་ནང་ལ་འཛུལ་སྐབས་གཞོན་ནུ་གོས་དཀར་པོ་གྱོན་པ་ཞིག་གཡས་ཕྱོགས་སུ་བསྡད་ཡོད་པ་མཐོང་བས་ཁོང་ཚོ་འཇིགས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","གཞོན་ནུ་དེས་ཁོང་ཚོར་“ཞེད་མི་དགོས། ཁྱེད་ཚོས་འཚོལ་བའི་ན་ཙ་རེལ་པ་ཡེ་ཤུ་རྒྱང་ཤིང་སྟེང་བཀལ་བ་ཁོང་སྐུ་གསོན་པོར་བཞེངས་སུ་འགྱུར་ཏེ་འདིར་མེད། ལྟོས་དང༌། སྐུ་ཕུང་བཞག་ས་འདི་རེད། ");
INSERT INTO bod_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ཁྱེད་ཚོ་ཕྱིན་ནས་ཁོང་གི་ཉེ་གནས་པེ་ཏྲོ་དང་བཅས་པ་ལ་འདི་ལྟར་ཤོད། ཡེ་ཤུས་ཁྱེད་ཚོའི་སྔོན་ལ་ག་ལིལ་ཡུལ་དུ་ཕེབས་ནས་སྔར་གསུངས་པ་བཞིན་དེར་ཁོང་མཇལ་ཡོང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ཁོང་ཚོ་འདར་ཞིང་དངངས་འཚབ་ཆེན་པོ་སྐྱེས་ནས་དུར་ཁང་ནས་ཕྱིར་བྲོས་ཏེ་སུ་ལའང་མ་བཤད། གང་ལགས་ཟེར་ན། ཁོང་ཚོ་ཧ་ཅང་འཇིགས་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","དེ་ཡང་བདུན་ཕྲག་གཅིག་གི་ཉིན་དང་པོའི་ཞོགས་པ་སྔ་པོར་ཡེ་ཤུ་སྐུ་གསོན་པོར་བཞེངས་ནས། ཐོག་མར་དེ་སྔ་ཁོང་གིས་གདོན་འདྲེ་བདུན་བསྐྲད་མྱོང་བའི་མག་དལ་མ་མིར་ཡམ་ལ་སྐུ་གཟུགས་མངོན་སུམ་དུ་བསྟན་པས། ");
INSERT INTO bod_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","དེས་ཕྱི་རུ་སོང་ནས་ཡེ་ཤུའི་རྗེས་སུ་འབྲང་མཁན་རྣམས་ཀྱི་དྲུང་དུ་ཕྱིན་ཏེ་དེ་རྣམས་ངུ་ཞིང་མྱ་ངན་བྱེད་བཞིན་ཡོད་པ་ལ་གཏམ་དེ་སྨྲས་ནའང༌། ");
INSERT INTO bod_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ཁོང་ཚོས་ཡེ་ཤུ་འཆི་བ་ལས་སླར་གསོན་པ་དང་མིར་ཡམ་གྱིས་ཁོང་མཐོང་བ་ཡིན་ཞེས་པ་དེ་ལ་ཡིད་མ་ཆེས། ");
INSERT INTO bod_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","དེའི་རྗེས་སུ་འབྲང་བ་རྣམས་ལས་མི་གཉིས་གྲོང་སྡེ་གཞན་ཞིག་ཏུ་འགྲོ་བའི་ལམ་བར་དུ། ཁོང་གིས་རང་གི་སྐུ་གཟུགས་རྣམ་པ་གཞན་དུ་བསྒྱུར་ཏེ་ཁོ་ཚོ་ལ་མངོན་སུམ་དུ་བསྟན། ");
INSERT INTO bod_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ཁོ་ཚོ་ལོག་ནས་རྗེས་སུ་འབྲང་བ་གཞན་རྣམས་ལ་གནས་ཚུལ་དེ་བཤད་ནའང་སུས་ཀྱང་ཁོ་ཚོ་ལ་ཡིད་མ་ཆེས། ");
INSERT INTO bod_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","དེའི་རྗེས་ཉེ་གནས་བཅུ་གཅིག་པོས་ཟས་བཞེས་བཞིན་པའི་སྐབས་སུ། ཁོང་གིས་དེ་རྣམས་ལ་རང་གི་སྐུ་གཟུགས་མངོན་སུམ་དུ་བསྟན་སྟེ། རང་ཉིད་འཆི་བ་ལས་སླར་གསོན་རྗེས་དེ་རྣམས་རང་ཉིད་མཐོང་མཁན་རྣམས་ཀྱིས་སྨྲས་པའི་གཏམ་ལ་ཡིད་མ་ཆེས་པས། ཁོང་གིས་དེ་རྣམས་ལ་དད་པ་མེད་པ་དང་སེམས་མཁྲེགས་པོ་ཡིན་པར་བཀའ་བཀྱོན་མཛད། ");
INSERT INTO bod_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ཡེ་ཤུས་ཉེ་གནས་རྣམས་ལ་“ཁྱེད་ཚོས་འཇིག་རྟེན་ཀུན་ཏུ་ཕྱིན་ནས་མི་ཐམས་ཅད་ལ་འཕྲིན་བཟང་ཁྱབ་བསྒྲགས་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","སུ་ཡང་དད་པ་བྱས་ནས་ཁྲུས་གསོལ་ཐོབ་པ་དེ་ཐར་བར་འགྱུར། སུ་ཡང་དད་པ་མི་བྱེད་པ་དེ་ལ་ཆད་པ་གཅོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","དད་པ་བྱེད་པ་རྣམས་ལ་ངོ་མཚར་ཆེ་བའི་ནུས་པ་འདི་ལྟར་ཡོད། ཁོང་ཚོས་ངའི་མིང་ཐོག་ནས་གདོན་འདྲེ་སྐྲོད་ཐུབ་ཅིང་སྐད་རིགས་གཞན་ཤོད་པ། ");
INSERT INTO bod_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","དུག་སྦྲུལ་རྣམས་ལག་པས་ལེན་པ། སྲོག་གཅོད་པའི་དུག་འཐུང་ཡང་གནོད་པ་མི་འབྱུང་བ། ལག་པས་ནད་པར་རེག་ན་ནད་འཇོམས་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","དེ་ལྟར་གཙོ་བོ་ཡེ་ཤུས་ཁོང་ཚོར་བཀའ་མོལ་གནང་ཚར་རྗེས། དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཞེངས་པར་གྱུར་ཏེ་དཀོན་མཆོག་གི་ཕྱག་གཡས་ངོས་སུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ཉེ་གནས་རྣམས་གང་སར་ཕྱིན་ནས་དཀོན་མཆོག་གི་བཀའ་ཁྱབ་བསྒྲགས་བྱས། གཙོ་བོས་ཁོང་ཚོ་དང་མཉམ་དུ་འཕྲིན་ལས་མཛད་ཅིང་ངོ་མཚར་བའི་རྟགས་མཚན་བསྟན་པའི་སྒོ་ནས་འཕྲིན་བཟང་དེ་བདེན་པ་ཡིན་པར་ར་སྤྲོད་གནང་ངོ༌། །");
INSERT INTO bod_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","མི་མང་པོ་ཞིག་གིས་ང་ཚོའི་ཁྲོད་དུ་གང་གྲུབ་པའི་སྐོར་གྱི་ལོ་རྒྱུས་བརྩམས་པས། ");
INSERT INTO bod_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","བཀའི་ཞབས་ཏོག་པ་ཐོག་མ་ནས་མིག་གིས་མཐོང་མཁན་རྣམས་ཀྱིས་ང་ཚོར་གང་གཏད་པ་བཞིན་དུ། ");
INSERT INTO bod_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ངས་ཀྱང་ཐོག་མ་ནས་གང་ཞིག་བྱུང་བ་ཞིབ་ཕྲ་རྩད་གཅོད་བྱས་ནས་མི་རྗེ་ཐེ་ཨོ་ཕི་ལུ་ཁྱེད་ཀྱི་ཆེད་དུ་གོ་རིམ་ལྡན་པའི་ལོ་རྒྱུས་ཤིག་འབྲི་རྒྱུར་ཐག་གཅོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","དེ་ནི་ཁྱེད་ལ་བསྟན་པའི་གསུང་བདེན་པ་ཡིན་པར་མཁྱེན་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ཡ་ཧུ་དཱ་ཡུལ་གྱི་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡི་དུས་སུ་ཟེ་ཀ་རི་ཡཱ་ཞེས་བྱ་བའི་ཡ་ཧུ་དཱ་པའི་བླ་མ་ཞིག་ཡོད། ཁོ་ནི་ཨ་བི་ཡཱ་ཡི་བླ་མའི་སྡེ་ཚན་ཁོངས་ཀྱི་མི་ཞིག་ཡིན་པ་དང༌། ཁོ་ལ་ཡ་ཧུ་དཱ་པའི་མེས་པོ་ཨ་རོན་གྱི་རྒྱུད་པ་ཨེ་ལི་ས་བེད་ཅེས་ཟེར་བའི་བཟའ་ཟླ་ཞིག་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","དེ་གཉིས་ཀྱིས་སྐྱོན་མེད་པར་དཀོན་མཆོག་གི་བཀའ་དང་ཆོས་ཁྲིམས་ཐམས་ཅད་བསྲུངས་ཏེ་ཁོང་གི་སྤྱན་སྔར་སེམས་དྲང་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","འོན་ཀྱང་ཨེ་ལི་ས་བེད་ཕྲུ་གུ་སྐྱེ་མི་ཐུབ་པས་ཁོང་ཚོ་གཉིས་བུ་ཕྲུག་མེད་པར་རྒས། ");
INSERT INTO bod_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ཡང་ཟེ་ཀ་རི་ཡཱ་ཡི་སྡེ་ཚན་གྱི་རེ་མོས་བབས་ནས་ཁོང་གིས་དཀོན་མཆོག་གི་མདུན་དུ་མཆོད་གཡོག་བྱེད་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","གཙོ་བོའི་མཆོད་ཁང་ཆེན་མོར་འཛུལ་ནས་སྤོས་འབུལ་བའི་ཆེད་དུ་བླ་མའི་ལུགས་སྲོལ་ལྟར་ཁོང་རྒྱན་བརྒྱབ་ནས་བདམས། ");
INSERT INTO bod_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","སྤོས་འབུལ་བའི་སྐབས་མི་ཚོགས་མང་པོས་ཕྱི་ལོགས་སུ་སྨོན་ལམ་འདེབས་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","དེའི་དུས་སུ་གཙོ་བོའི་ཕོ་ཉ་ཞིག་སྤོས་འབུལ་བའི་མཆོད་ཁྲིའི་གཡས་ཕྱོགས་སུ་ཟེ་ཀ་རི་ཡཱ་ལ་མངོན་པར་གྱུར་བས། ");
INSERT INTO bod_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ཁོང་ཕོ་ཉ་དེ་མཐོང་ནས་འདྲོགས་ཏེ་ཤིན་ཏུ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","འོན་ཀྱང་ཕོ་ཉས་ཁོ་ལ་“ཟེ་ཀ་རི་ཡཱ། མ་འཇིགས་ཤིག གང་ལགས་ཤེ་ན། ཁྱོད་ཀྱི་ཞུ་བ་གསན་པས་ཁྱོད་ཀྱི་བཟའ་ཟླ་ཨེ་ལི་ས་བེད་ལ་བུ་ཞིག་བཙའ་བར་འགྱུར། ཁྱོད་ཀྱིས་བུ་དེའི་མིང་ལ་ཡོ་ཧ་ནན་ཞེས་ཐོགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ཁྱོད་དགའ་ཞིང་སྤྲོ་བར་འགྱུར་ལ་བུ་དེ་སྐྱེ་བས་མི་མང་པོ་ཞིག་གིས་ཀྱང་དགའ་སྐྱིད་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","གང་ལགས་ཤེ་ན། གཙོ་བོའི་སྤྱན་སྔར་ཁོ་མི་ཆེན་པོར་འགྱུར། ཁོ་རྒུན་ཆང་ལ་སོགས་འཐུང་མི་རུང་ལ། ཨ་མའི་མངལ་དུ་ཡོད་པའི་དུས་ནས་ཁོ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ཡང་ཁོས་ཡི་སི་ར་ཨེལ་པ་མང་པོ་ཞིག་དེ་ཚོའི་གཙོ་བོ་དཀོན་མཆོག་གི་ཕྱོགས་སུ་འགུགས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ཡང་ཕ་ཡི་སེམས་ཕྲུ་གུའི་ཕྱོགས་སུ་འགུགས་པའི་ཆེད་དང༌། བཀའ་ལ་མི་ཉན་པའི་སེམས་ནི་དྲང་པོའི་ཤེས་རབ་ཏུ་སྒྱུར་ཞིང༌། གཙོ་བོའི་ཞབས་ཕྱི་བྱེད་དུ་འོས་པའི་མི་རྣམས་གྲ་སྒྲིག་བྱེད་པའི་ཕྱིར། ཁོ་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ལྟར་དཀོན་མཆོག་གི་དབང་དང་དམ་པའི་ཐུགས་ཉིད་ཐོག་ནས་གཙོ་བོའི་སྔོན་དུ་འགྲོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ཟེ་ཀ་རི་ཡཱ་ཡིས་ཕོ་ཉ་ལ་“ང་དང་ངའི་ཟླ་བོ་ཡང་རྒས་པས་དེ་བདེན་པ་ཡིན་པར་ངས་ཅི་ལྟར་ཤེས་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ཕོ་ཉས་“ང་དཀོན་མཆོག་གི་མདུན་དུ་བཞུགས་པའི་ཕོ་ཉ་གེབ་རི་ཨེལ་ཡིན་ཏེ། ཁྱོད་ལ་སྨྲ་བ་དང༌། གཏམ་བཟང་པོ་འདི་འཆད་པའི་ཕྱིར་མངག་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ལྟོས་ཤིག དོན་འདི་རྣམས་མ་འགྲུབ་པའི་བར་དུ་ཁྱོད་ཀྱིས་ཅི་ཡང་མི་སྨྲ་སྟེ་སྐད་ཆ་ཤོད་མི་ཐུབ་པ་གནས་པར་འགྱུར། གང་ལགས་ཤེ་ན། ཁྱོད་ཀྱིས་ངས་བཤད་པའི་བཀའ་ལ་ཡིད་མ་ཆེས་པས། དུས་ལ་འབབ་དུས་བཀའ་དེ་འགྲུབ་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","དེའི་རིང་ལ་མི་རྣམས་ཟེ་ཀ་རི་ཡཱ་སྒུག་ནས་བསྡད་ལ་ཁོ་མཆོད་ཁང་ཆེན་མོར་ཡུན་རིང་འགོར་བས་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ཁོ་ཕྱིར་ཐོན་སྐབས་མི་དེ་ཚོར་སྐད་ཆ་ཤོད་མི་ཐུབ་པས་ཁོས་མཆོད་ཁང་ནང་ལ་ཞལ་གཟིགས་མཐོང་བར་མི་རྣམས་ཀྱིས་ཤེས། ཁོས་ཁོ་ཚོར་ལག་བརྡ་བྱེད་དེ་ཁ་གྲགས་མི་ཐུབ་པར་གནས། ");
INSERT INTO bod_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ཞབས་ཏོག་གི་དུས་རིམ་ཚར་ནས་ཟེ་ཀ་རི་ཡཱ་ནང་ལ་ལོག ");
INSERT INTO bod_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","དེ་ནས་ཁོང་གི་བཟའ་ཟླ་ཨེ་ལི་ས་བེད་མངལ་དང་ལྡན་པར་གྱུར་བས་ཟླ་བ་ལྔའི་རིང་ཕྱི་རུ་མ་ཐོན་པར་ནང་ལ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ཁོ་མོས་“གཙོ་བོས་ང་ལ་གཟིགས་སྐྱོང་མཛད་ནས་ངའི་མི་རིགས་ཀྱི་མདུན་དུ་ང་ཡི་ངོ་ཚ་བསལ་ཏེ་ང་ལ་འདི་ལྟར་མཛད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ཨེ་ལི་ས་བེད་མངལ་དང་ལྡན་པའི་ཟླ་བ་དྲུག་པར་དཀོན་མཆོག་གིས་ཕོ་ཉ་གེབ་རི་ཨེལ་ག་ལིལ་ཡུལ་གྱི་ན་ཙ་རེལ་ཟེར་བའི་གྲོང་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","མིར་ཡམ་ཞེས་ཟེར་བའི་གཞོན་ནུ་མའི་སར་མངགས། མིར་ཡམ་ནི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་རྒྱུད་པ་ཡོ་སེབ་ཀྱི་བཟའ་ཟླར་འགྱུར་བ་ཐག་གཅོད་བྱས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ནང་ལ་ཕེབས་སྐབས་གེབ་རི་ཨེལ་གྱིས་ཁོ་མོར་“ཐུགས་རྗེ་ཐོབ་པ་ཁྱོད་ལ་བདེ་བ་དང་ལྡན་པར་གྱུར་ཅིག གཙོ་བོ་ཁྱོད་དང་མཉམ་དུ་བཞུགས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","དེ་ཐོས་ནས་མིར་ཡམ་སེམས་ཤིན་ཏུ་འཁྲུགས་ཤིང་འཚམས་འདྲི་དེ་ཅི་ལྟར་ཡིན་བསམ་ཞིབ་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","དཀོན་མཆོག་གི་ཕོ་ཉས་ཁོ་མོར་“མིར་ཡམ། མ་འཇིགས་ཤིག དཀོན་མཆོག་ནས་ཁྱོད་ལ་ཐུགས་རྗེ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ལྟོས་ཤིག ཁྱོད་མངལ་དང་ལྡན་པར་འགྱུར་ཏེ་སྲས་ཤིག་སྐྱེས་ནས་ཁྱོད་ཀྱིས་ཁོང་གི་མཚན་ལ་ཡེ་ཤུ་ཞེས་ཐོགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ཁོང་སྐྱེས་བུ་ཆེན་པོར་འགྱུར་ལ་བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་སྲས་ཞེས་ཀྱང་གསོལ་བར་འགྱུར། གཙོ་བོ་དཀོན་མཆོག་གིས་ཁོང་ལ་རང་གི་མེས་པོ་དཱ་བིད་ཀྱི་བཞུགས་ཁྲི་གནང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ཁོང་གིས་ཡ་ཀོབ་ཀྱི་རྒྱུད་པར་དུས་རྒྱུན་དུ་དབང་སྒྱུར་ལ། ཁོང་གི་རྒྱལ་སྲིད་ནི་མཐའ་མེད་པའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","མིར་ཡམ་གྱིས་ཕོ་ཉ་ལ་“ང་སྐྱེས་པ་དང་འདུས་མ་མྱོང་བས་འདི་ཅི་ལྟར་སྲིད་”ཅེས་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ཕོ་ཉས་“དམ་པའི་ཐུགས་ཉིད་ཁྱོད་ལ་འབབ་ཅིང་བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་ནུས་མཐུ་ཁྱོད་ལ་ཁྱབ་པར་འགྱུར། དེའི་ཕྱིར་ཕྲུ་གུ་དམ་པ་དེ་ལ་དཀོན་མཆོག་གི་སྲས་ཞེས་གསོལ། ");
INSERT INTO bod_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ལྟོས་ཤིག ཁྱོད་ཀྱི་སྤུན་མཆེད་རྒན་མོ་ཨེ་ལི་ས་བེད་རབས་ཆད་མ་ཞེས་བྱ་བ་ཡིན་ཀྱང༌། ད་ལྟ་མངལ་དུ་བུ་ཞིག་འཁོར་ནས་ཟླ་བ་དྲུག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","གང་ཡིན་ཟེར་ན། དཀོན་མཆོག་གིས་མཛད་མི་སྲིད་པ་གང་ཡང་མེད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","དེ་ནས་མིར་ཡམ་གྱིས་“ང་གཙོ་བོའི་གཡོག་མོ་ཞིག་ཡིན་ཏེ་ཁྱེད་ཀྱི་བཀའ་ལྟར་ང་ལ་འབྱུང་བར་ཤོག་”ཅེས་སྨྲས་རྗེས་ཕོ་ཉ་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","དེའི་དུས་སུ་མིར་ཡམ་གྲ་སྒྲིག་བྱས་ནས་ཡ་ཧུ་དཱ་ཡུལ་གྱི་རི་ཁུལ་གྲོང་གསེབ་ཅིག་ལ་མགྱོགས་པོར་ཕྱིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ཟེ་ཀ་རི་ཡཱ་ཡི་ཁང་པར་འཛུལ་ནས་ཨེ་ལི་ས་བེད་ལ་འཚམས་འདྲི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ཨེ་ལི་ས་བེད་ཀྱིས་མིར་ཡམ་གྱི་འཚམས་འདྲི་ཐོས་སྐབས་མངལ་དུ་ཡོད་པའི་བུ་གློ་བུར་དུ་འགུལ། ཨེ་ལི་ས་བེད་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","སྐད་ཆེན་པོས་“བུད་མེད་རྣམས་ལས་ཁྱེད་ནི་བྱིན་རླབས་ཆེ། ཁྱེད་ཀྱི་ལྷུམས་སུ་ཡོད་པའི་བུའང་བྱིན་གྱིས་བརླབས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ངའི་གཙོ་བོའི་ཡུམ་ངའི་རྩར་ཕེབས་པའི་བཀའ་དྲིན་འདི་ཅི་ལགས། ");
INSERT INTO bod_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","གཟིགས་དང༌། ཁྱེད་ཀྱི་འཚམས་འདྲིའི་སྐད་ཐོས་མ་ཐག་ངའི་མངལ་དུ་ཡོད་པའི་བུ་དགའ་བས་འགུལ། ");
INSERT INTO bod_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","གཙོ་བོས་ཁོ་མོ་ལ་གང་གསུངས་པ་དེ་འགྲུབ་པར་འགྱུར་བར་ཡིད་ཆེས་པ་བྱིན་རླབས་ཆེ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ཡང་མིར་ཡམ་གྱིས། ང་ཡི་སེམས་ནས་གཙོ་བོར་བསྟོད། ། ");
INSERT INTO bod_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","དཀོན་མཆོག་སྐྱབས་མགོན་ལ་ཡི་རང༌། ། ");
INSERT INTO bod_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ཁོང་གིས་དམའ་བའི་གཡོག་མོར་གཟིགས། ། ད་ནས་མི་རབས་ཀུན་གྱིས་ནི། ། ང་ལ་བདེ་ལེགས་བརྗོད་པར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","དབང་ཀུན་ལྡན་པས་ང་ལ་ནི། ། ངོ་མཚར་ལས་རྣམས་མཛད་པ་དང༌། ། ཁོང་གི་མཚན་ནི་དམ་པ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ཁོང་ལ་གུས་པའི་མི་རབས་ཀུན། ། ཁོང་གི་ཐུགས་རྗེས་ཁྱབ་པར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ཁོང་གི་ཕྱག་གིས་མཛད་ཆེན་བསྒྲུབས། ། ང་རྒྱལ་ཅན་རྣམས་གཏོར་བར་མཛད། ། ");
INSERT INTO bod_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","དབང་ཅན་ཁྲི་ལས་ཕབ་པར་མཛད། ། དམའ་བ་མཐོ་སར་བཏེགས་པར་མཛད། ། ");
INSERT INTO bod_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ལྟོགས་པར་བཟང་པོས་ཚིམས་པར་མཛད། ། ཕྱུག་པོ་སྟོང་བར་བཏོན་པར་མཛད། ། ");
INSERT INTO bod_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ཁོང་གིས་མེས་པོར་གསུངས་པ་ལྟར། ། ཡི་སི་ར་ཨེལ་གཡོག་པོ་ལ། ། ཁོང་གིས་རོགས་པ་གནང་བར་མཛད། ། ཨབ་ར་ཧམ་དང་དེའི་རྒྱུད་པ། ། དགོངས་ནས་ནམ་ཡང་ཐུགས་རྗེས་གཟིགས། ། ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","དེ་ནས་མིར་ཡམ་ཟླ་བ་གསུམ་ཙམ་ཁོ་མོ་དང་མཉམ་དུ་བསྡད་ནས་རང་གི་ནང་ལ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","བུ་བཙའ་བའི་དུས་ལ་བབས་ཏེ་ཨེ་ལི་ས་བེད་ལ་བུ་ཞིག་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ཁྱིམ་མཚེས་དང་གཉེན་ཚན་རྣམས་ཀྱིས་གཙོ་བོས་ཁོ་མོར་ཐུགས་རྗེ་ཆེན་པོ་གཟིགས་པ་ཐོས་ནས་མི་དེ་ཚོ་ཁོ་མོ་དང་མཉམ་དུ་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ཉི་མ་བརྒྱད་པར་ཁོ་ཚོ་བུ་དེར་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་རྒྱག་པའི་ཆེད་དུ་འཛོམས་ནས་ཕ་ལྟར་ཟེ་ཀ་རི་ཡཱ་ཞེས་བུའི་མིང་བཏགས་སྙམ། ");
INSERT INTO bod_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","འོན་ཀྱང་བུའི་ཨ་མས་“ལགས་མ་ཡིན། ཡོ་ཧ་ནན་ཞེས་མིང་འདོགས་པར་འགྱུར་”ཞེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ཁོ་ཚོས་“ཁྱེད་ཀྱི་གཉེན་ཚན་གྱི་ཁྲོད་དུ་མིང་དེ་འདྲ་སུ་ལ་ཡང་མེད་”ཅེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","བུའི་མིང་གང་འདོགས་འདོད་པ་ཤེས་པའི་ཕྱིར་ཁོ་ཚོས་ཕ་ལ་ལག་བརྡ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ཁོང་གིས་ཡི་གེ་འབྲི་པང་ཞིག་བསླངས་ནས་ཁོའི་མིང་ཡོ་ཧ་ནན་ཡིན་ཞེས་བྲིས་པས་ཁོ་ཚོ་ཐམས་ཅད་ངོ་མཚར་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","འཕྲལ་དུ་ཁོའི་ཁ་ཕྱེ་སྟེ་ལྕེ་གྲོལ་ནས་སྐད་ཆ་བཤད་དེ་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ཉེ་འཁོར་གྱི་མི་ཐམས་ཅད་ཡ་མཚན་གྱིས་ཁེངས་ཏེ། ཡ་ཧུ་དཱ་ཡུལ་གྱི་རི་ཁུལ་ལ་སྡོད་མཁན་ཐམས་ཅད་ཀྱིས་དོན་དེའི་སྐོར་སྐད་ཆ་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","དོན་དེ་ཚོ་ཐོས་མཁན་ཐམས་ཅད་ཀྱིས་ཡིད་ལ་འཆང་སྟེ་“ཕྲུ་གུ་དེ་ཅི་ལྟ་བུ་ཞིག་འབྱུང་ཡོང་”ཞེས་སྨྲས། གང་ལགས་ཤེ་ན། གཙོ་བོའི་ནུས་མཐུ་ཁོང་དང་མཉམ་དུ་ཡོད་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ཁོའི་ཕ་ཟེ་ཀ་རི་ཡཱ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་ནས་འདི་ལྟར་ལུང་བསྟན། ");
INSERT INTO bod_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ཡི་སི་ར་ཨེལ་གཙོ་བོ་དཀོན་མཆོག་ཉིད། ། རང་གི་མི་རིགས་གཟིགས་ནས་བསྐྱབས་པར་མཛད། ། དེ་ཡི་ཕྱིར་དུ་ཁོང་ལ་བསྟོད་པར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ཞབས་ཕྱི་དཱ་བིད་དེ་ཡི་བུ་རྒྱུད་ལས། ། ངེད་ཕྱིར་ཐར་པའི་རྭ་ཅོ་མཐོན་པོར་བཏེགས། ། ");
INSERT INTO bod_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","གནའ་བོའི་དུས་ནས་དམ་པའི་ལུང་སྟོན་པའི། ། བཀའ་ཡི་སྒོ་ནས་ཁོང་གིས་གསུངས་པ་ལྟར། ། ");
INSERT INTO bod_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","དགྲ་དང་སྡང་མཁན་ལག་ནས་ངེད་སྐྱོབ་སྟེ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","ངེད་ཀྱི་མེས་པོར་སྙིང་རྗེ་མཛད་པ་དང༌། ། མེས་པོ་ཨབ་ར་ཧམ་ལ་མནའ་བཞེས་པའི། ། ཉིད་ཀྱི་དམ་པའི་ཞལ་ཆད་དྲན་པའི་ཕྱིར། ། ");
INSERT INTO bod_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","ངེད་ཀྱི་དགྲ་ཡི་ལག་ལས་བསྐྱབས་མཛད་དེ། ། ངེད་ཀྱི་ཚེ་གང་དམ་པ་དྲང་པོའི་ངང༌། ། འཇིགས་པ་མེད་པར་ཁོང་ལ་བསྙེན་བཀུར་ཞུ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ང་ཡི་བུ་ཁྱོད་བླ་ན་མེད་པ་ཡི། ། དཀོན་མཆོག་གི་ནི་ལུང་སྟོན་པ་ཞེས་ཟེར། ། གཙོ་བོའི་ཕེབས་ལམ་སེལ་བར་བྱེད་པའི་ཕྱིར། ། ཁོང་གི་སྔོན་དུ་ལམ་ལ་འགྲོ་བར་བྱ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","དེ་ཚོའི་སྡིག་ཉེས་སེལ་བའི་ཤེས་རབ་ཀྱིས། ། ཁོང་གི་མི་རྣམས་ཐར་ལམ་ངོ་སྤྲོད་ཕྱིར། ། ");
INSERT INTO bod_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","དཀོན་མཆོག་ཉིད་ཀྱི་བཀའ་དྲིན་ཆེན་པོ་ཡིས། ། གནམ་ནས་ཐུགས་རྗེའི་ཉི་མ་འཆར་བའི་ཚེ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","མུན་གྲིབ་འཆི་གྲིབ་སེལ་ཕྱིར་འོད་འཕྲོས་ཏེ། ། ཞི་བདེའི་ལམ་དུ་རྐང་པ་འདྲེན་པའི་ཕྱིར། ། ཞེས་ལུང་བསྟན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","བུ་དེ་འཚར་ལོངས་བྱུང་ནས་སེམས་སུ་སྟོབས་དང་ལྡན་པར་གྱུར། ཡི་སི་ར་ཨེལ་པ་རྣམས་ལ་མངོན་སུམ་དུ་མ་འགྱུར་བའི་བར་དུ་ཁོང་དབེན་སྟོང་ལ་བཞུགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","དེའི་དུས་སུ་རྒྱལ་པོ་སེ་སར་ཨུ་རྒ་ཟི་ཏུ་ཡིས་རོ་མཱ་གོང་མའི་རྒྱལ་ཁབ་ཀྱི་འབངས་མི་ཐམས་ཅད་ལ་མིང་ཐོ་འགོད་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","དེ་ནི་ཐོ་འགོད་བྱེད་པ་དང་པོ་ཡིན་ཏེ་སི་རི་ཡཱ་ཡུལ་གྱི་ས་གནས་དཔོན་པོ་ཀུ་རེ་ནུ་ཡི་དུས་སུ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","མི་ཐམས་ཅད་མིང་ཐོ་འགོད་པའི་ཕྱིར་སོ་སོའི་ཕ་ཡུལ་ལ་ཕྱིན་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ཡོ་སེབ་ནི་དཱ་བིད་ཀྱི་བུ་རྒྱུད་ཡིན་པས་ཁོང་ཡང་ག་ལིལ་ཡུལ་གྱི་ན་ཙ་རེལ་གྲོང་ཚོ་ནས་ཡ་ཧུ་དཱ་ཡུལ་གྱི་བེད་ལེ་ཧེམ་ཞེས་བྱ་བའི་དཱ་བིད་ཀྱི་གྲོང་ཁྱེར་ལ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ཁོང་གི་བཟའ་ཟླར་འགྱུར་བ་ཐག་གཅོད་བྱས་པ་དང༌། མངལ་དང་ལྡན་པའི་མིར་ཡམ་ཁོང་མཉམ་དུ་ཐོ་རྒྱག་པའི་ཆེད་དུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ཁོང་ཚོ་དེར་བཞུགས་དུས་མིར་ཡམ་གྱི་བུ་བཙའ་བའི་དུས་ལ་བབས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","སྲས་དང་པོ་འཁྲུངས། མགྲོན་ཁང་ལ་སྡོད་ས་མེད་པས་རས་ཀྱིས་བཏུམས་ནས་བྲེས་ཤིག་གི་ནང་ལ་བཞག ");
INSERT INTO bod_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ཡུལ་དེར་རྩྭ་ཐང་སྟེང་ལ་བསྡད་པའི་ལུག་རྫི་ཡིས་མཚན་མོར་ལུག་ཁྱུ་བསྲུངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","དཀོན་མཆོག་གི་ཕོ་ཉ་མྱུར་དུ་ཁོ་ཚོའི་མདུན་དུ་མངོན་པར་གྱུར་ནས་དཀོན་མཆོག་གི་གཟི་བརྗིད་ཁོ་ཚོའི་སྐོར་ལ་འཕྲོས་པས་འཇིགས་སྐྲག་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","འོན་ཀྱང་ཕོ་ཉ་དེས་“མ་འཇིགས་ཤིག གཟིགས་དང༌། མི་ཚང་མའི་ཕྱིར་ངས་ཤིན་ཏུ་དགའ་བའི་འཕྲིན་བཟང་ཁྱབ་བསྒྲགས་བྱེད་དེ། ");
INSERT INTO bod_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","དེ་རིང་ཁྱེད་རྣམས་ལ་དཱ་བིད་ཀྱི་གྲོང་ཁྱེར་དུ་སྐྱབས་མགོན་ཞིག་འཁྲུངས་ཡོད། ཁོང་ནི་གཙོ་བོ་མཱ་ཤི་ཀ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","དེ་ནི་ཁྱེད་ལ་ཁོང་གི་རྟགས་འདི་ཡིན། བྲེས་ཤིག་ནང་ལ་རས་ཀྱིས་བཏུམས་པའི་མ་འབྱར་ཉལ་བ་ཞིག་མཇལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","གློ་བུར་དུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཞུགས་མཁན་ཧ་ཅང་མང་པོ་ཞིག་ཕོ་ཉ་དང་མཉམ་དུ་མངོན་པར་གྱུར་ནས་དཀོན་མཆོག་ལ་བསྟོད་དེ། ");
INSERT INTO bod_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","བླ་ན་མེད་པའི་གནས་སུ་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཞིང༌། ། ས་ལ་ཁོང་གི་ཐུགས་མཉེས་པའི་མིར་ཞི་བདེ་འབབ་པར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","དེ་ནས་ཕོ་ཉ་ཞིང་ཁམས་སུ་ཕྱིར་ལོག་ནས་ལུག་རྫི་རྣམས་ཀྱིས་གཅིག་གིས་གཅིག་ལ་“གཙོ་བོས་ང་ཚོར་གསུངས་པའི་དོན་དེ་ལྟ་བའི་ཕྱིར་ད་བེད་ལེ་ཧེམ་དུ་ཐད་ཀར་འགྲོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ཁོ་ཚོས་མགྱོགས་པོར་ཕྱིན་ནས་མིར་ཡམ་དང་ཡོ་སེབ་བཙལ་ཏེ་བྲེས་ཀྱི་ནང་ལ་ཉལ་བའི་མ་འབྱར་མཇལ། ");
INSERT INTO bod_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","དོན་དེ་མཐོང་ནས་ཕྲུ་གུ་དེའི་སྐོར་ཁོ་ཚོར་གང་གསུངས་པའི་གཏམ་གང་སར་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ཡང་ལུག་རྫིའི་གཏམ་ཐོས་པ་ཐམས་ཅད་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","འོན་ཀྱང་མིར་ཡམ་གྱིས་དོན་དེ་ཚོ་ཐམས་ཅད་སེམས་གཏིང་ལ་བཞག་ནས་བསམ་ཞིབ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ལུག་རྫི་རྣམས་ཀྱིས་གང་ཐོས་པ་དང་མཐོང་བའི་དོན་ཐམས་ཅད་ཕོ་ཉས་གསུངས་པ་ལྟར་གྲུབ་པས་དཀོན་མཆོག་ལ་བསྟོད་ཅིང་བསྔགས་ནས་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ཉིན་བརྒྱད་ཀྱི་རྗེས་སུ་ཡ་ཧུ་དཱ་པའི་རྟགས་རྒྱག་སྐབས་ཁོང་གི་མཚན་ལ་ཡེ་ཤུ་ཞེས་བཏགས། དེ་ནི་ཁོང་གི་ཡུམ་མངལ་དང་ལྡན་པར་གྱུར་བའི་སྔོན་ལ་དཀོན་མཆོག་གི་ཕོ་ཉས་གནང་བའི་མཚན་ཡིན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ལུང་སྟོན་པ་མོ་ཤེའི་ཆོས་ཁྲིམས་ལྟར་ཁོང་ཚོའི་གཙང་སྦྲ་བྱེད་པའི་དུས་ཚར་ནས་གཙོ་བོ་དཀོན་མཆོག་ལ་ཡེ་ཤུ་འབུལ་བའི་ཆེད་དུ་ཁོང་རྣམས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(གཙོ་བོའི་ཆོས་ཁྲིམས་ལ་བཀོད་པ་ལྟར་སྔོན་ལ་སྐྱེས་པའི་ཕོ་རེ་རེ་གཙོ་བོ་ལ་དམ་པར་བརྩི་བར་བྱ་ཞེས་གསུངས་) ");
INSERT INTO bod_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ཡང་གཙོ་བོའི་ཆོས་ཁྲིམས་ལ་བཀོད་པ་ལྟར་ཐི་བ་ཟུང་གཅིག་གམ་ཕུག་རོན་ཆུང་ངུ་གཉིས་མཆོད་པར་འབུལ་དགོས་ཞེས་པའི་བཀའ་བཞིན་དུ་ཁོང་ཚོས་མཆོད་པ་ཞིག་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ཡེ་རུ་ཤ་ལེམ་ལ་སི་མེ་ཡོན་ཞེས་བྱ་བའི་སེམས་དྲང་པོ་དང་ཆོས་སེམས་དང་ལྡན་པའི་མི་ཞིག་ཡོད། ཁོང་ནི་ཡི་སི་ར་ཨེལ་སྐྱོབ་པའི་དུས་སུ་སྒུག་མཁན་ཡིན་པ་དང༌། དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཁོང་དང་མཉམ་དུ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ཁོང་འཆི་བ་མ་མྱོང་བའི་སྔོན་ལ་གཙོ་བོའི་མཱ་ཤི་ཀ་ལ་མཇལ་རྒྱུ་ཡིན་པར་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོང་ལ་མངོན་པར་མཛད་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","དམ་པའི་ཐུགས་ཉིད་ཀྱིས་བསྐུལ་ཏེ་ཁོང་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རའི་རྩར་ཕྱིན་པ་དང༌། ཆོས་ཁྲིམས་གང་དགོས་པ་བྱེད་པའི་ཕྱིར་ཕ་མས་ཕྲུ་གུ་ཡེ་ཤུ་ཁྱེར་ནས་སླེབས་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","སི་མེ་ཡོན་གྱིས་ཕྲུ་གུ་པང་དུ་བླངས་ནས་དཀོན་མཆོག་ལ་བསྟོད་བསྔགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","གཙོ་བོ་ད་ལྟ་ཁྱེད་ཀྱི་བཀའ་བཞིན་དུ། ། ཁྱེད་ཀྱི་ཞབས་ཕྱི་ཞི་བདེར་འགྲོ་རུ་འཇུག ། ");
INSERT INTO bod_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","ང་ཡི་མིག་གིས་མི་རིགས་ཀུན་གྱི་ཆེད། ། ཁྱེད་ཀྱིས་བཀོད་པ་གནང་བའི་ཐར་པ་མཐོང༌། ། ");
INSERT INTO bod_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ཡི་སི་ར་ཨེལ་ཁྱེད་ཀྱི་མི་རིགས་ལ། ། གཟི་བརྗིད་དང་ནི་ཕྱི་པར་འཕྲོ་བའི་འོད། ། ཞེས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ཕྲུ་གུའི་ཡབ་དང་ཡུམ་ཁོང་གི་སྐོར་ལ་བཤད་པའི་གཏམ་དེ་ལ་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","སི་མེ་ཡོན་ཁོང་ཚོར་བྱིན་གྱིས་བརླབས་ནས་ཁོང་གི་ཡུམ་མིར་ཡམ་ལ་“གཟིགས་དང༌། ཕྲུ་གུ་འདི་ནི་ཡི་སི་ར་ཨེལ་པ་མང་པོ་འགྱེལ་བའི་རྒྱུ་རྐྱེན་དང༌། ལང་བའི་རྒྱུ་རྐྱེན་དང༌། རྒོལ་རྒྱུ་ཡིན་པའི་རྟགས་སུ་བསྐོས། ");
INSERT INTO bod_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","དེ་ནི་མི་མང་པོའི་གསང་བའི་བསམ་པ་མངོན་སུམ་དུ་འགྱུར་བའི་ཆེད་དུ་ཡིན། རལ་གྲི་ཞིག་གིས་ཁྱེད་ཀྱི་སེམས་ལ་ཡང་འཛུགས་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ཡང་ཡི་སི་ར་ཨེལ་གྱི་ཚོ་ཁག་ཨ་ཤེར་ནས་ཕཱ་ནུ་ཨེལ་གྱི་བུ་མོ་ཨན་ནཱ་ནི་ལོ་ན་ཤིན་ཏུ་རྒས་པའི་ལུང་སྟོན་པ་དེར་ཡོད་དེ། ཁོ་མོ་གཉེན་སྒྲིག་བྱས་ནས་ལོ་བདུན་ཁྱོ་བོ་དང་མཉམ་དུ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","དེ་ནས་ཡུགས་མོའི་འཚོ་བ་བསྐྱལ་ནས་ལོ་བརྒྱད་ཅུ་གྱ་བཞི་བར་གསོན། ཁོ་མོས་མཆོད་ཁང་དང་མི་འབྲལ་བར་ཉིན་མཚན་མེད་པར་སྨྱུང་གནས་སྲུང་བ་དང་སྨོན་ལམ་བཏབ་སྟེ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","དུས་དེ་རང་ལ་ཁོ་མོ་ཡོང་ནས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་པ་དང༌། ཡེ་རུ་ཤ་ལེམ་གྱི་ཐར་བའི་ཉིན་མོ་སྒུག་མཁན་ཐམས་ཅད་ལ་ཕྲུ་གུ་དེའི་སྐོར་ལ་གཏམ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","གཙོ་བོའི་ཆོས་ཁྲིམས་ལྟར་དོན་ཐམས་ཅད་བསྒྲུབས་ཚར་ནས་ཁོང་ཚོ་ག་ལིལ་ཡུལ་དུ་རང་གི་གྲོང་ཁྱེར་ན་ཙ་རེལ་ལ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","བུ་དེ་འཚར་ལོངས་བྱུང་སྟེ་སེམས་སུ་སྟོབས་དང་བློ་ལ་ཤེས་རབ་རྒྱས་པ་དང༌། དཀོན་མཆོག་གི་ཐུགས་རྗེ་ཁོང་གི་ཐོག་ལ་གནས། ");
INSERT INTO bod_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ལོ་ལྟར་པེ་སག་ཟེར་བའི་དུས་ཆེན་གྱི་སྐབས་སུ་ཁོང་གི་ཡབ་ཡུམ་གཉིས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ཁོང་དགུང་ལོ་བཅུ་གཉིས་ལོན་སྐབས་ཁོང་ཚོ་ནམ་རྒྱུན་ལྟར་དུས་ཆེན་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","དུས་ཆེན་ཚར་ནས་ཁོང་ཚོ་ཕྱིར་ལོག་སྐབས་ཡབ་ཡུམ་གྱིས་མ་ཤེས་པར་ཕྲུ་གུ་ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ཁོང་ལམ་གྲོགས་ཀྱི་དཀྱིལ་ལ་ཡོད་བསམས་ནས་ཉིན་གཅིག་གི་ལམ་ལ་ཕྱིན་ཏེ། ཡབ་ཡུམ་གྱིས་གཉེན་ཚན་དང་ངོ་ཤེས་པའི་ནང་ཁོང་བཙལ། ");
INSERT INTO bod_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","མ་རྙེད་པར་ཁོང་འཚོལ་བའི་ཆེད་དུ་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ཉིན་གསུམ་གྱི་རྗེས་སུ་ཁོང་མཆོད་ཁང་གི་ཁྱམས་རར་སློབ་དཔོན་ཁྲོད་དུ་བཞུགས་ཏེ་ཁོ་ཚོའི་ཆོས་གསན་པ་དང་ཁོ་ཚོར་བཀའ་འདྲི་གནང་སྟེ་ཕ་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ཁོང་གི་མཁས་པའི་སེམས་དང་ལན་འདེབས་པ་ཐོས་མཁན་ཚང་མ་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ཡབ་ཡུམ་གྱིས་ཁོང་མཐོང་སྐབས་ཡ་མཚན་སྐྱེས་ཏེ་ཡུམ་གྱིས་“བུ། ཁྱོད་ཀྱིས་ཅི་ལ་ང་ཚོར་འདི་ལྟར་བྱས། ལྟོས་ཤིག ཁྱོད་ཀྱི་ཡབ་དང་ང་སེམས་ཤིན་ཏུ་འཚབས་ནས་ཁྱོད་བཙལ་”ཞེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ཁོང་གིས་“ཅིའི་ཕྱིར་ང་བཙལ་བ་ཡིན། ངའི་ཡབ་ཀྱི་ཕོ་བྲང་ལ་སྡོད་དགོས་པར་ཁྱེད་ཀྱིས་མི་མཁྱེན་ནམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","འོན་ཀྱང་ཁོང་གིས་གང་གསུངས་པ་ཁོང་ཚོས་མ་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","དེ་ནས་ཁོང་ཚོ་ན་ཙ་རེལ་ལ་མར་ཕེབས་པ་དང་ཁོང་གིས་ཡབ་ཡུམ་གྱི་བཀའ་ལ་ཉན་ནས་བཞུགས། ཁོང་གི་ཡུམ་གྱིས་དོན་དེ་ཚོ་ཚང་མ་སེམས་ལ་བཞག ");
INSERT INTO bod_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ཡང་ཡེ་ཤུ་ཤེས་རབ་དང༌། སྐུ་གཟུགས། དཀོན་མཆོག་གི་ཐུགས་དགྱེས་པ། མི་རྣམས་ཀྱི་བརྩི་མཐོང་ལ་འཕེལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","རྒྱལ་པོ་ཏི་པེར་ཡུ་སེ་སར་སྲིད་སྐྱོང་བྱེད་པའི་ལོ་བཅོ་ལྔའི་རིང་ལ་ཕོན་ཏི་ཡུ་པི་ལ་ཏུ་ཡ་ཧུ་དཱ་ཡུལ་གྱི་སྤྱི་ཁྱབ་ཡིན་པ་དང༌། ཧེ་རོ་དཱེ་ག་ལིལ་ཡུལ་གྱི་ས་གནས་དཔོན་པོ་ཡིན་ཏེ། ཁོའི་གཅེན་པོ་ཕི་ལིབ་ཨེ་ཏུ་རི་ཡཱ་དང་ཏྲ་ཀོ་ནི་ཏི་ཡུལ་གྱི་ས་གནས་དཔོན་པོ་དང༌། ལི་སན་ཡུ་ཨ་བི་ལེ་ནེ་ཡུལ་གྱི་ས་གནས་དཔོན་པོ་ཡིན་ལ། ");
INSERT INTO bod_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ཨ་ན་སི་དང་ཀ་ཡ་ཕཱ་བླ་ཆེན་གཙོ་བོ་བྱེད་པའི་དུས་སུ་དབེན་སྟོང་ཡུལ་ལ་ཟེ་ཀ་རི་ཡཱ་ཡི་བུ་ཡོ་ཧ་ནན་ལ་དཀོན་མཆོག་གི་བཀའ་བབས། ");
INSERT INTO bod_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ཡོར་དན་གཙང་པོའི་མཐའ་འཁོར་གྱི་ཡུལ་ཀུན་ཏུ་ཁོང་གིས་སྡིག་ཉེས་སེལ་བའི་ཆེད་དུ་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་རྟགས་སུ་ཁྲུས་གསོལ་ལེན་དགོས་པར་བསྒྲགས་ཏེ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ཡེ་ཤ་ཡཱ་ཞེས་ཟེར་བའི་ལུང་སྟོན་པས་བྲིས་པའི་མདོ་ལ་བཀོད་པ་ལྟར། དབེན་སྟོང་ཡུལ་ནང་གྲགས་པའི་འབོད་སྒྲ་ཡིས། ། གཙོ་བོའི་ཆེད་དུ་ཕེབས་ལམ་གྲ་སྒྲིག་བྱོས། ། ལམ་བུ་དེ་ནི་བདེ་བར་བཟོས་ཤིག་ཨང༌། ། ");
INSERT INTO bod_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","རོང་རྣམས་སྙོམས་ཤིང་རི་དག་དམའ་བར་འགྱུར། ། འཁྱོག་པ་དྲང་ལ་རྩུབ་པོ་བདེ་བར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ཀུན་གྱིས་དཀོན་མཆོག་ཐར་པ་མཐོང་བར་འགྱུར། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ཡང་ཡོ་ཧ་ནན་ནས་ཁྲུས་གསོལ་ལེན་པའི་ཆེད་དུ་ཡོང་བའི་མི་ཚོགས་མང་པོར་ཁོང་གིས་“དུག་སྦྲུལ་གྱི་རིགས་ཁྱོད་ཚོ། སྡིག་པའི་ཉེས་ཆད་ཡིན་ཏེ་མ་འོངས་པའི་ཐུགས་ཁྲོ་ལས་འབྲོས་པ་ཁྱོད་ཚོར་སུས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བའི་འབྲས་བུ་སྨིན་ཞིག ཡང་ཨབ་ར་ཧམ་ང་ཚོའི་མེས་པོ་ཡིན་ཞེས་མ་སོམས། ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། དཀོན་མཆོག་གིས་རྡོ་འདི་ཚོ་ལས་ཨབ་ར་ཧམ་ལ་བུ་རྒྱུད་འབྱུང་བར་མཛད་ཐུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ད་ལྟ་སྟ་རེ་ཞིག་ཤིང་སྡོང་གི་རྩ་ལ་བཞག་ཡོད་པས་འབྲས་བུ་བཟང་པོ་མ་སྨིན་པའི་ཤིང་སྡོང་རེ་རེ་བཞིན་བཅད་ནས་མེ་ལ་གཡུག་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","མི་ཚོགས་ཀྱིས་ཁོང་ལ་“བྱས་ན་ང་ཚོས་ཅི་བྱེད་དགོས་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ལན་དུ་ཁོང་གིས་ཁོ་ཚོར་“གོས་གཉིས་ཡོད་པ་གོས་མེད་པ་ལ་བགོད་པ་དང༌། ཟས་ཡོད་མཁན་གྱིས་ཀྱང་དེ་ལྟར་བྱེད་དགོས་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ཁྲལ་སྡུད་མཁན་ཁྲུས་གསོལ་ལེན་ཕྱིར་ཡོང་ནས་ཁོང་ལ་“སློབ་དཔོན་ལགས། ང་ཚོས་ཅི་བྱེད་དགོས་”ཅེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ཁོང་གིས་ཁོ་ཚོར་“ཁ་མངག་པ་ལས་ལྷག་པར་མ་ལེན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","དམག་མི་ཁ་ཤས་ཀྱིས་ཁོང་ལ་“ང་ཚོས་ཅི་བྱེད་དགོས་”ཅེས་དྲིས་པ་ན། ཁོང་གིས་“བཙན་ཐབས་ཀྱིས་དངུལ་མ་ལེན། མི་སུ་ཡང་ལ་སྙད་མ་འདོགས། ཁྱོད་ཀྱི་གླ་ཆ་ཡིས་ཚིམ་པར་འགྱུར་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","མི་རྣམས་རེ་སྒུག་བྱེད་བཞིན་པས་ཚང་མའི་སེམས་ལ་ཡོ་ཧ་ནན་ནི་མཱ་ཤི་ཀ་ཡིན་མིན་སྙམ་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ཡོ་ཧ་ནན་གྱིས་མི་དེ་ཚོ་ཚང་མར་“ངས་ནི་ཆུ་ཡིས་ཁྱོད་ཚོར་ཁྲུས་གསོལ་བྱེད། འོན་ཀྱང་ངའི་རྗེས་ལ་ང་ལས་དབང་ཆེ་བ་ཞིག་ཕེབས་ཡོང་བར་ངེས་ཏེ། ང་ཁོང་གི་ལྷམ་སྒྲོག་ཀྱང་འགྲོལ་བར་མི་འོས། ཁོང་གིས་ཁྱོད་ཚོར་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་དང་མེ་ཡིས་ཁྲུས་གསོལ་གནང་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ཁོང་གི་གཡུལ་ཁ་ལེགས་པོར་གཙང་མ་བཟོ་བའི་ཆེད་དང༌། མཛོད་ཁང་ལ་གྲོ་སྡུད་པའི་ཕྱིར་སྦར་མོ་ཕྱག་ལ་ཡོད། འོན་ཀྱང་རྩྭ་རྣམས་ཁོང་གིས་གསོད་མི་སྲིད་པའི་མེ་ཡིས་སྲེག་པར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ད་དུང་སྐད་ཆ་གཞན་དག་མང་པོས་སྐུལ་མ་བཏང་སྟེ་ཁོང་གིས་མི་རྣམས་ལ་འཕྲིན་བཟང་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","འོན་ཀྱང་ཡོ་ཧ་ནན་གྱིས་ས་གནས་དཔོན་པོ་ཧེ་རོ་དཱེ་ལ་ཁོའི་གཅེན་པོའི་བཟའ་ཟླ་ཧེ་རོད་ཡཱ་ཡི་རྒྱུ་རྐྱེན་དང༌། ཁོས་བྱས་པའི་ལས་ངན་ཚང་མའི་རྐྱེན་གྱིས་བཀའ་བཀྱོན་བྱེད་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ཉེས་པ་གཞན་ཐམས་ཅད་བྱས་པའི་སྟེང་དུ་ཁོས་ཡོ་ཧ་ནན་བཙོན་ཁང་ལ་བཅུག ");
INSERT INTO bod_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","དེར་ཡོད་པའི་མི་རྣམས་ཁྲུས་གསོལ་ལེན་སྐབས་གཙོ་བོ་ཡེ་ཤུའང་ཁྲུས་གསོལ་བཞེས། ཁོང་གིས་གསོལ་སྨོན་འདེབས་དུས་ནམ་མཁའ་ཕྱེ་ནས། ");
INSERT INTO bod_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","དམ་པའི་ཐུགས་ཉིད་གཟུགས་དང་ལྡན་ཞིང་ཕུག་རོན་ལྟར་ཁོང་གི་སྟེང་ལ་བབས་ཏེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་“ཁྱེད་ནི་ངའི་གཅེས་པའི་བུ་ཡིན། ང་རང་ཁྱེད་ལ་ཤིན་ཏུ་དགའོ་”ཞེས་པའི་གསུང་སྐད་ཅིག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ཡེ་ཤུའི་ཕྱག་ལས་འགོ་འཛུགས་དུས་ཁོང་དགུང་ལོ་སུམ་ཅུ་ཙམ་ལོན་ཅིང༌། མི་རྣམས་ཀྱིས་ཁོང་ཡོ་སེབ་ཀྱི་བུ་ཡིན་པར་བསམས། ཡོ་སེབ་ནི་ཨེ་ལི་ཞེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ཨེ་ལི་ནི་མད་ཐད་ཅེས་བྱ་བའི་བུ། མད་ཐད་ནི་ལེ་ཝི་ཞེས་བྱ་བའི་བུ་དང༌། ལེ་ཝི་ནི་མེལ་ཀི་ཞེས་བྱ་བའི་བུ། མེལ་ཀི་ནི་ཡན་ནཱ་ཞེས་བྱ་བའི་བུ་དང༌། ཡན་ནཱ་ནི་ཡོ་སེབ་ཅེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ཡོ་སེབ་ནི་མད་ཐི་ཐི་ཞེས་བྱ་བའི་བུ་དང༌། མད་ཐི་ཐི་ནི་ཨ་མོ་ཟི་ཞེས་བྱ་བའི་བུ། ཨ་མོ་ཟི་ནི་ནཱ་ཧུམ་ཞེས་བྱ་བའི་བུ་དང༌། ནཱ་ཧུམ་ནི་ཧེ་ཟི་ལེ་ཞེས་བྱ་བའི་བུ། ཧེ་ཟི་ལེ་ནི་ནཱ་གེ་ཞེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ནཱ་གེ་ནི་མ་ཧ་ཐུ་ཞེས་བྱ་བའི་བུ། མ་ཧ་ཐུ་ནི་མད་ཐི་ཐི་ཞེས་བྱ་བའི་བུ་དང༌། མད་ཐི་ཐི་ནི་སེ་མེ་ཞེས་བྱ་བའི་བུ། སེ་མེ་ནི་ཡོ་སེག་ཅེས་བྱ་བའི་བུ་དང༌། ཡོ་སེག་ནི་ཡོ་དཱ་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ཡོ་དཱ་ནི་ཡོ་ཧན་ནཱ་ཞེས་བྱ་བའི་བུ་དང༌། ཡོ་ཧན་ནཱ་ནི་རེ་སཱ་ཞེས་བྱ་བའི་བུ། རེ་སཱ་ནི་བཟེ་རུ་པ་པེལ་ཞེས་བྱ་བའི་བུ་དང༌། བཟེ་རུ་པ་པེལ་ནི་ཤེ་ཨལ་ཐི་ཨེལ་ཞེས་བྱ་བའི་བུ། ཤེ་ཨལ་ཐི་ཨེལ་ནི་ནེ་རི་ཞེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ནེ་རི་ནི་མེལ་ཀི་ཞེས་བྱ་བའི་བུ། མེལ་ཀི་ནི་ཨ་དཱ་ཞེས་བྱ་བའི་བུ་དང༌། ཨ་དཱ་ནི་ཁོ་སམ་ཞེས་བྱ་བའི་བུ། ཁོ་སམ་ནི་ཨེལ་མོ་དཱམ་ཞེས་བྱ་བའི་བུ་དང༌། ཨེལ་མོ་དཱམ་ནི་ཨེར་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ཨེར་ནི་ཡོ་ཤུ་ཨ་ཞེས་བྱ་བའི་བུ་དང༌། ཡོ་ཤུ་ཨ་ནི་ཨེ་ལི་ཨེ་ཟེ་ཞེས་བྱ་བའི་བུ། ཨེ་ལི་ཨེ་ཟེ་ནི་ཡོ་རིམ་ཞེས་བྱ་བའི་བུ་དང༌། ཡོ་རིམ་ནི་མད་ཐད་ཅེས་བྱ་བའི་བུ། མད་ཐད་ནི་ལེ་ཝི་ཞེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ལེ་ཝི་ནི་སི་མེ་ཡོན་ཞེས་བྱ་བའི་བུ། སི་མེ་ཡོན་ནི་ཡུ་དཱ་ཞེས་བྱ་བའི་བུ་དང༌། ཡུ་དཱ་ནི་ཡོ་སེབ་ཅེས་བྱ་བའི་བུ། ཡོ་སེབ་ནི་ཡོ་ནཱམ་ཞེས་བྱ་བའི་བུ་དང༌། ཡོ་ནཱམ་ནི་ཨེལ་ཡ་ཀིམ་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ཨེལ་ཡ་ཀིམ་ནི་མེ་ལེ་ཡཱ་ཞེས་བྱ་བའི་བུ་དང༌། མེ་ལེ་ཡཱ་ནི་མེན་ནཱ་ཞེས་བྱ་བའི་བུ། མེན་ནཱ་ནི་མད་ཐ་ཐི་ཞེས་བྱ་བའི་བུ་དང༌། མད་ཐ་ཐི་ནི་ནཱ་ཐན་ཞེས་བྱ་བའི་བུ། ནཱ་ཐན་ནི་དཱ་བིད་ཅེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","དཱ་བིད་ནི་ཡེ་སེ་ཞེས་བྱ་བའི་བུ། ཡེ་སེ་ནི་ཨོ་པེད་ཅེས་བྱ་བའི་བུ་དང༌། ཨོ་པེད་ནི་པོ་ཨ་ཟི་ཞེས་བྱ་བའི་བུ། པོ་ཨ་ཟི་ནི་སལ་མོན་ཞེས་བྱ་བའི་བུ་དང༌། སལ་མོན་ནི་ནཱ་སོན་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ནཱ་སོན་ནི་ཨ་མི་ན་དབ་ཅེས་བྱ་བའི་བུ་དང༌། ཨ་མི་ན་དབ་ནི་ཨད་མན་ཞེས་བྱ་བའི་བུ། ཨད་མན་ནི་རམ་ཞེས་བྱ་བའི་བུ་དང༌། རམ་ནི་ཧེ་ཟི་རོན་ཞེས་བྱ་བའི་བུ། ཧེ་ཟི་རོན་ནི་པེ་རེ་ཟི་ཞེས་བྱ་བའི་བུ་དང༌། པེ་རེ་ཟི་ནི་ཡུ་དཱ་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ཡུ་དཱ་ནི་ཡ་ཀོབ་ཅེས་བྱ་བའི་བུ་དང༌། ཡ་ཀོབ་ནི་ཨི་སཱག་ཅེས་བྱ་བའི་བུ། ཨི་སཱག་ནི་ཨབ་ར་ཧམ་ཞེས་བྱ་བའི་བུ་དང༌། ཨབ་ར་ཧམ་ནི་ཐེ་རཱ་ཞེས་བྱ་བའི་བུ། ཐེ་རཱ་ནི་ནཱ་ཧོར་ཞེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ནཱ་ཧོར་ནི་སེ་རུག་ཅེས་བྱ་བའི་བུ། སེ་རུག་ནི་རེའུ་ཞེས་བྱ་བའི་བུ་དང༌། རེའུ་ནི་ཕེ་ལེག་ཅེས་བྱ་བའི་བུ། ཕེ་ལེག་ནི་ཨེ་པེར་ཞེས་བྱ་བའི་བུ་དང༌། ཨེ་པེར་ནི་ས་ལཱ་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ས་ལཱ་ནི་ཁེ་ནཱན་ཞེས་བྱ་བའི་བུ་དང༌། ཁེ་ནཱན་ནི་ཨར་པག་སད་ཅེས་བྱ་བའི་བུ། ཨར་པག་སད་ནི་ཤེམ་ཞེས་བྱ་བའི་བུ་དང༌། ཤེམ་ནི་ནོ་ཨ་ཞེས་བྱ་བའི་བུ། ནོ་ཨ་ནི་ལ་མེག་ཅེས་བྱ་བའི་བུ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ལ་མེག་ནི་མེ་ཐུ་ཟི་ལཱ་ཞེས་བྱ་བའི་བུ། མེ་ཐུ་ཟི་ལཱ་ནི་ཧེ་ནོག་ཅེས་བྱ་བའི་བུ་དང༌། ཧེ་ནོག་ནི་ཡཱ་རིད་ཅེས་བྱ་བའི་བུ། ཡཱ་རིད་ནི་མཱ་ཧ་ལཱ་ཨེལ་ཞེས་བྱ་བའི་བུ་དང༌། མཱ་ཧ་ལཱ་ཨེལ་ནི་ཁེ་ནཱན་ཞེས་བྱ་བའི་བུ། ");
INSERT INTO bod_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ཁེ་ནཱན་ནི་ཨེ་ནོ་ཟི་ཞེས་བྱ་བའི་བུ་དང༌། ཨེ་ནོ་ཟི་ནི་སེད་ཅེས་བྱ་བའི་བུ། སེད་ནི་ཨ་དམ་ཞེས་བྱ་བའི་བུ་ཡིན་པ་དང༌། ཨ་དམ་ནི་དཀོན་མཆོག་ནས་བྱུང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོང་ཡོངས་སུ་གང་སྟེ་ཡེ་ཤུ་ཡོར་དན་གཙང་པོ་ནས་ཕྱིར་ལོག་ཕེབས་པ་དང༌། དམ་པའི་ཐུགས་ཉིད་ཀྱིས་སྐུལ་ཏེ་ཁོང་དབེན་སྟོང་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ཉིན་ཞག་བཞི་བཅུའི་རིང་བདུད་སཱ་ཏན་གྱིས་ཁོང་ལ་ཉམས་ཚོད་བླངས། དེའི་དུས་སུ་ཁོང་གིས་ཞལ་ཟས་ཅི་ཡང་མ་བཞེས་པས་དུས་སྐབས་དེའི་མཐའ་མར་བཀྲེས། ");
INSERT INTO bod_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","བདུད་ཀྱིས་ཁོང་ལ་“ཁྱེད་རང་དཀོན་མཆོག་གི་སྲས་ཡིན་ན་རྡོ་འདི་བག་ལེབ་ཏུ་འགྱུར་བའི་བཀའ་གཏོང་ཞིག་”ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ལན་དུ་ཡེ་ཤུས་“གསུང་རབ་ནང་མི་ནི་བག་ལེབ་ཁོ་ནར་བརྟེན་ནས་འཚོ་བ་མ་ཡིན་ཞེས་བྲིས་འདུག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","བདུད་ཀྱིས་ཁོང་ཡར་ཁྲིད་ནས་ཡུད་ཙམ་ཞིག་ལ་འཇིག་རྟེན་གྱི་རྒྱལ་ཁམས་ཚང་མ་བསྟན་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ཁོང་ལ་“རྒྱལ་ཁམས་འདི་རྣམས་ཀྱི་སྲིད་དབང་དང་དཔལ་ང་ལ་གཏད་ཡོད་དེ་ངས་སུ་ལ་དགའ་བར་སྟེར་བས་ཁྱེད་ལ་འབུལ་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","དེའི་ཕྱིར་ང་ལ་ཕྱག་འཚལ་ན་དེ་ཐམས་ཅད་ཁྱེད་ཀྱི་ཡིན་པར་འགྱུར་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ལན་དུ་ཡེ་ཤུས་“གསུང་རབ་ནང་ཁྱེད་ཀྱིས་རང་གི་གཙོ་བོ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུ་བ་དང་ཁོང་ཁོ་ནར་ཞབས་ཕྱི་བྱེད་དགོས་ཞེས་བྲིས་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","བདུད་ཀྱིས་ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་ལ་ཁྲིད་ནས་མཆོད་ཁང་ཆེན་མོའི་རྩེ་རུ་ལང་དུ་བཅུག་ནས་ཁོང་ལ་“ཁྱེད་རང་དཀོན་མཆོག་གི་སྲས་ཡིན་ན་འདི་ནས་མར་མཆོངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","གང་ལགས་ཟེར་ན། གསུང་རབ་ཀྱི་མདོ་ལས། ཁོང་གི་སྲུང་དགོས་ཕོ་ཉ་རྣམས་སུ་ནི། ། ཁྱེད་སྐྱོབ་དགོས་པའི་བཀའ་ཡང་གནང་བར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","རྡོ་ལ་ཁྱེད་ཀྱི་ཞབས་ནི་མི་ཕོག་ཕྱིར། ། དེ་ཚོའི་ལག་པར་ཁྱེད་ནི་འདེགས་པར་འགྱུར། ། ཅེས་བྲིས་འདུག་”ཅེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ལན་དུ་ཡེ་ཤུས་“གཙོ་བོ་ཁྱེད་ཀྱི་དཀོན་མཆོག་ལ་ཉམས་ཚོད་མ་བྱོས་ཤིག་ཅེས་བྲིས་འདུག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","བདུད་ཀྱིས་ཉམས་ཚོད་ཀུན་བླངས་ཚར་བའི་རྗེས་སུ་གོ་སྐབས་མ་འཐོབ་པར་ཁོང་དང་བྲལ། ");
INSERT INTO bod_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ཡེ་ཤུ་དམ་པའི་ཐུགས་ཉིད་ཀྱི་དབང་ཐོག་ནས་ག་ལིལ་ཡུལ་དུ་ཕྱིར་ལོག་ཕེབས་ནས་ཁོང་གི་སྙན་གྲགས་ག་ལིལ་གྱི་མཐའ་འཁོར་ཡུལ་ཀུན་ཏུ་ཁྱབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","དེར་ཡོད་པའི་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་རྣམས་ཀྱི་ནང་ལ་ཁོང་གིས་ཆོས་བསྟན་གནང་བ་དང་མི་ཚང་མས་ཁོང་ལ་བསྟོད། ");
INSERT INTO bod_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ཡང་ཁོང་གི་འཚར་ལོངས་བྱུང་ས་ན་ཙ་རེལ་ལ་བྱོན་ཏེ་ནམ་རྒྱུན་ལྟར་ངལ་གསོ་བའི་ཉིན་མོར་ཁོང་འདུ་ཁང་ལ་ཕེབས། ཁོང་གསུང་རབ་ཀྱི་མདོ་ཀློག་པའི་ཆེད་དུ་བཞེངས་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་བྲིས་པའི་མདོ་ཁོང་ལ་ཕུལ་ནས་ཁ་ཕྱེ་སྟེ་འདི་ལྟར་བྲིས་པའི་གནས་རྙེད། ");
INSERT INTO bod_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","དབུལ་ཕོངས་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་པའི་ཆེད། ། གཙོ་བོའི་ཐུགས་ཉིད་ང་ཡི་སྟེང་དུ་གནས། ། བཙོན་པ་ཐར་ཞིང་ལོང་བ་གསོ་བ་དང༌། ། བཙན་གནོན་རྣམས་ལ་བཅིངས་འགྲོལ་བྱེད་པ་དང༌། ། ཁོང་གི་ལོ་བཟང་སླེབས་པ་སྒྲོག་པའི་ཆེད། ། གཙོ་བོ་དཀོན་མཆོག་ང་ལ་བསྐོས་ཤིང་མངགས། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ཁོང་གིས་ཤོག་སྒྲིལ་དེ་བསྒྲིལ་ཏེ་གཡོག་པོ་ལ་གནང་ནས་བཞུགས་པ་དང༌། འདུ་ཁང་ལ་ཡོད་པའི་མི་ཚང་མས་ཁོང་ལ་མིག་ནན་གྱིས་བལྟས། ");
INSERT INTO bod_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ཡང་ཁོང་གིས་མི་དེ་ཚོར་“དེ་རིང་ཁྱེད་ཚོས་ཐོས་པའི་རིང་ལ་ལུང་བསྟན་འདི་གྲུབ་བོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","མི་ཚང་མས་ཁོང་ལ་བསྟོད་དེ་ཁོང་གི་ཐུགས་རྗེ་དང་ལྡན་པའི་གསུང་ལ་ཡ་མཚན་སྐྱེས་ཏེ། ཁོ་ཚོས་“འདི་ནི་ཡོ་སེབ་ཀྱི་བུ་མ་ཡིན་ནམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོས་སྨན་པ་རང་གིས་རང་གསོ་བར་བྱོས་ཞེས་པའི་གཏམ་དཔེ་ང་ལ་ཟེར་ངེས་ཡིན་པ་དང༌། ང་ཚོས་ཐོས་པའི་ཀ་ཕར་ན་ཧུམ་ལ་གང་མཛད་པ་དེ་ཁྱེད་ཀྱི་ཕ་ཡུལ་འདི་རུའང་མཛོད་ཅེས་སྨྲ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ཡང་ཁོང་གིས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། རང་གི་ཕ་ཡུལ་ལ་ལུང་སྟོན་པ་སུ་ཞིག་ཀྱང་བསུ་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","དངོས་གནས་བྱས་ན་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཡི་དུས་སུ་ལོ་གསུམ་དང་ཟླ་བ་དྲུག་རིང་ལ་ཆར་པ་ཆད་པས་ཡུལ་ཆ་ཚང་ལ་མུ་གེ་ཆེན་པོ་བྱུང་སྐབས། ཡི་སི་ར་ཨེལ་ལ་ཡུགས་མོ་མང་པོ་ཡོད་ནའང༌། ");
INSERT INTO bod_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ཚི་དོན་ཡུལ་གྱི་ས་རེབ་ཏཱ་ཞེས་པའི་གྲོང་སྡེ་ཡི་ཡུགས་མོ་ཞིག་མ་གཏོགས་པར་ཨེ་ལི་ཡཱ་དེ་ཚོར་མ་མངགས། ");
INSERT INTO bod_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ཡང་ལུང་སྟོན་པ་ཨེ་ལི་ཤཱ་ཡི་དུས་སུ་ཡི་སི་ར་ཨེལ་ལ་མཛེ་ནད་ཅན་མང་པོ་ཡོད་ནའང་སི་རི་ཡཱ་པ་ནེ་མན་མ་གཏོགས་པར་དེ་ཚོའི་ནང་ནས་སུ་ཡང་ནད་གསོས་ནས་གཙང་བར་མ་གྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","དོན་དེ་ཐོས་པའི་རྗེས་སུ་འདུ་ཁང་ལ་ཡོད་པ་ཐམས་ཅད་ཁོང་ཁྲོ་འབར་པས། ");
INSERT INTO bod_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ལངས་ཏེ་ཁོང་གྲོང་སྡེ་ནས་ཕྱིར་བསྐྲད། ཁོ་ཚོའི་གྲོང་སྡེ་བྲག་རིའི་ལྡེབས་ལ་ཆགས་ཏེ་ཁོང་གཡང་ས་ནས་འཕེན་པའི་ཕྱིར་རིའི་ཟུར་ལ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","འོན་ཀྱང་ཁོང་མི་ཚོགས་ཀྱི་ཁྲོད་ནས་ཐོན་ཏེ་ཕར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ག་ལིལ་ཡུལ་གྱི་གྲོང་སྡེ་ཀ་ཕར་ན་ཧུམ་ལ་མར་ཕེབས་ནས་ངལ་གསོ་བའི་ཉིན་མོར་ཁོང་གིས་ཁོ་ཚོར་ཆོས་བསྟན་གནང་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ཁོང་གི་གསུང་དབང་དང་ལྡན་པས་མི་དེ་ཚོ་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","འདུ་ཁང་ལ་གདོན་འདྲེ་མི་གཙང་བས་ཟིན་པའི་མི་ཞིག་ཡོད་དེ་ཁོས་སྐད་ཆེན་པོས་ ");
INSERT INTO bod_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ཧ། ན་ཙ་རེལ་པ་ཡེ་ཤུ། ང་ཚོ་དང་ཁྱེད་འབྲེལ་བ་གང་ཡོད། ཁྱེད་ཀྱིས་ང་ཚོ་མེད་པ་བཟོ་བར་ཕེབས་སམ། ཁྱེད་སུ་ཡིན་པ་ངས་ཤེས་ཀྱི་ཡོད། ཁྱེད་ནི་དཀོན་མཆོག་གི་སྐྱེས་བུ་དམ་པ་དེ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","འོན་ཀྱང་གཙོ་བོ་ཡེ་ཤུས་དེ་ལ་བཀའ་བཀྱོན་གནང་སྟེ་“ཁ་རོག་སྡོད། མི་དེའི་ལུས་ནས་ཐོན་ཅིག་”ཅེས་གསུངས་པ་ན། གདོན་འདྲེ་དེས་མི་རྣམས་ཀྱི་དཀྱིལ་དུ་ཁོ་ས་ལ་བསྒྱེལ་ནས་གནོད་འཚེ་མ་བྱུང་བར་ཁོའི་ལུས་ནས་ཕྱིར་ཐོན། ");
INSERT INTO bod_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","མི་ཐམས་ཅད་ཧ་ལས་ཏེ་ཕན་ཚུན་གཅིག་གིས་གཅིག་ལ་“བསྟན་པ་འདི་ཅི་ཡིན། དབང་ཆ་དང་ནུས་མཐུའི་སྒོ་ནས་ཁོང་གིས་གདོན་འདྲེ་མི་གཙང་བར་བཀའ་གནང་ནས་ཕྱིར་ཐོན་”ཞེས་བཤད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ཁོང་གི་སྙན་གྲགས་མཐའ་འཁོར་གྱི་ཡུལ་ཀུན་ཏུ་ཁྱབ་པའོ། ། ");
INSERT INTO bod_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ཁོང་བཞེངས་ཏེ་འདུ་ཁང་ནས་ཐོན་ཏེ་སི་མོན་གྱི་ཁྱིམ་དུ་ཕེབས། སི་མོན་གྱི་བཟའ་ཟླའི་ཨ་མ་ཚ་བ་ཤིན་ཏུ་རྒྱས་པས་ཁོ་རྣམས་ཀྱིས་ཁོང་ལ་དེའི་སྐོར་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ཁོ་མོའི་མདུན་དུ་བཞེངས་ཏེ་ཁོང་གིས་ཚ་བ་ལ་བཀའ་བཀྱོན་གནང་བས་འཇགས་པ་དང༌། འཕྲལ་དུ་ཁོ་མོ་ལངས་ནས་ཁོང་རྣམས་ལ་ཞབས་ཕྱི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ཉི་མ་བཞུད་པའི་དུས་སུ་ཁོ་ཚོས་ནད་སྣ་ཚོགས་ཕོག་པའི་མི་ཐམས་ཅད་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་པ་དང༌། ཁོང་གིས་མི་དེ་ཚོ་རེ་རེར་ཕྱག་བཞག་སྟེ་གསོ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","མ་ཟད་གདོན་འདྲེ་མི་མང་པོའི་ནང་ནས་ཕྱིར་ཐོན་ཏེ་སྐད་ཆེན་པོས་“ཁྱེད་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་”ཞེས་སྨྲས། འོན་ཀྱང་དེ་ཚོར་བཀའ་བཀྱོན་གནང་ནས་ཁོང་གིས་གདོན་དེ་ཚོར་སྐད་ཆ་ལབ་ཏུ་མ་བཅུག གང་ཡིན་ཟེར་ན། གདོན་འདྲེས་ཁོང་མཱ་ཤི་ཀ་ཡིན་པར་ཤེས་ཀྱི་ཡོད་པས་རེད། ");
INSERT INTO bod_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","དེའི་སང་ཞོགས་སུ་ཡེ་ཤུ་དབེན་གནས་ཤིག་ཏུ་ཕེབས། མི་ཚོགས་ཀྱིས་བཙལ་ནས་ཁོང་གི་མདུན་དུ་ཡོང་བ་དང༌། ཕར་མི་ཕེབས་པའི་ཕྱིར་ཁོང་འགོག་པར་འདོད། ");
INSERT INTO bod_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","འོན་ཀྱང་ཁོང་གིས་ཁོ་ཚོར་“ངས་གྲོང་ཁྱེར་གཞན་རྣམས་ལ་ཡང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་སྒྲོག་དགོས། ང་དོན་འདིའི་ཆེད་དུ་མངགས་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","དེའི་ཕྱིར་ཁོང་གིས་ཡ་ཧུ་དཱ་ཡུལ་གྱི་འདུ་ཁང་ནང་ལ་ཆོས་ཡང་ཡང་གསུང་བཞིན་ཡོད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ཡེ་ཤུ་གན་ནེ་སཱ་རེལ་ཞེས་པའི་མཚོའི་འགྲམ་དུ་བཞུགས་པ་དང༌། དཀོན་མཆོག་གི་བཀའ་ལ་ཉན་པའི་ཆེད་དུ་མི་ཚོགས་འཚང་ཁ་བརྒྱབ་སྟེ་ཁོང་གི་མཐའ་ནས་བསྐོར་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ཁོང་གིས་མཚོའི་འགྲམ་ལ་གྲུ་གཉིས་ཡོད་པ་གཟིགས། ཉ་པ་རྣམས་གྲུ་བཞག་ནས་དྲ་རྒྱ་འཁྲུད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ཁོང་སི་མོན་གྱི་གྲུ་ལ་ཞུགས་ནས་སི་མོན་ལ་སྐམ་ས་ནས་ཕྱིར་བསྐྱོད་ཏོག་ཙམ་བྱོས་ཞེས་གསུངས་པས། ཁོང་གྲུ་ལ་བཞུགས་ཏེ་མི་ཚོགས་ལ་ཆོས་བསྟན་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ཆོས་གསུངས་ཚར་ནས་ཁོང་གིས་སི་མོན་ལ་“ཉ་ཟིན་པའི་ཕྱིར་ཆུ་གཏིང་རིང་པོའི་སར་སོང་ལ་དྲ་རྒྱ་མར་ཐོང་”ཞེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ལན་དུ་སི་མོན་གྱིས་“རྒན་ལགས། ང་ཚོས་མཚན་གང་དཀའ་ལས་བརྒྱབ་ནས་ཉ་གཅིག་ཀྱང་ཟིན་མ་ཐུབ། འོན་ཀྱང་ཁྱེད་ཀྱིས་དེ་ལྟར་གསུངས་པས་ངས་དྲ་རྒྱ་མར་འབེབས་པར་བྱ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","དེ་ལྟར་བྱས་ནས་ཉ་ཤིན་ཏུ་མང་པོ་བཟུང་བས་དྲ་རྒྱ་རལ་གྲབས་འདུག ");
INSERT INTO bod_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","རོགས་རམ་ཐོབ་པའི་ཕྱིར་ཁོ་ཚོས་གྲུ་གཞན་ལ་ཡོད་པའི་ལས་རོགས་རྣམས་ལ་ལག་བརྡ་བྱས་པ་དང༌། ཁོ་ཚོ་ཡོང་ནས་ཆུར་ནུབ་གྲབས་ཙམ་ལ་གྲུ་གཉིས་ཀ་ཉ་ཡིས་བཀང༌། ");
INSERT INTO bod_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","དེ་མཐོང་ནས་སི་མོན་པེ་ཏྲོ་ཡིས་གཙོ་བོ་ཡེ་ཤུའི་མདུན་དུ་པུས་མོ་སར་བཙུགས་ནས་ཁོང་ལ་“གཙོ་བོ། ང་མི་སྡིག་ཉེས་ཅན་ཡིན་པས་ངའི་རྩ་ནས་ཕར་ཕེབས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ཉ་དེ་ཙམ་མང་པོ་བཟུང་བའི་རྐྱེན་གྱིས་ཁོ་དང་ཁོའི་ལས་རོགས་ཚང་མ་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","སི་མོན་གྱི་ལས་རོགས་ཡིན་པ་ཟེ་བད་ཡཱ་ཟེར་བའི་བུ་ཡ་ཀོབ་དང་ཡོ་ཧ་ནན་ཡང་དེ་ལྟར་ཧ་ལས་པ་དང༌། ཡེ་ཤུས་སི་མོན་ལ་“མ་འཇིགས་ཤིག ཁྱེད་ཚོས་ཉ་བཙལ་བ་ལྟར་ད་ནས་བཟུང་མི་རྣམས་འཚོལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","གྲུ་གཉིས་སྐམ་སར་སླེབས་ནས་ཐམས་ཅད་སྤངས་ཏེ་ཁོ་ཚོ་ཁོང་གི་རྗེས་སུ་འབྲངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","གྲོང་ཁྱེར་ཞིག་ལ་བཞུགས་སྐབས་མཛེ་ནད་ལྗིད་པོ་ཕོག་པ་ཞིག་གིས་ཡེ་ཤུ་མཐོང་ནས་ཕྱག་འཚལ་ཏེ་ཁོང་ལ་“གཙོ་བོ་ལགས། གལ་ཏེ་ཁྱེད་ཐུགས་མཉེས་པ་ཡིན་ན་ཁྱེད་ཀྱིས་ང་རང་གི་མཛེ་ནད་དག་པར་མཛད་ཐུབ་”ཅེས་ཞུ་བ་ཆེན་པོ་ཕུལ་བས། ");
INSERT INTO bod_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ཡེ་ཤུས་ཕྱག་བརྐྱངས་ནས་ཁོ་ལ་རེག་སྟེ་“ང་དེ་བཞིན་དུ་བྱེད་འདོད་ཡོད། དག་པར་གྱུར་ཅིག་”ཅེས་གསུངས་པ་དང༌། འཕྲལ་དུ་ཁོ་མཛེ་ནད་དེ་དག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","མི་དེར་གཞན་ལ་ཅི་ཡང་སྨྲ་བར་མི་བྱེད་པའི་བཀའ་གནང་སྟེ་“སོང་ལ་རང་གི་ལུས་ཡ་ཧུ་དཱ་པའི་བླ་མར་སྟོན་དང༌། ཁོང་རྣམས་ལ་བདེན་དཔང་བྱེད་པའི་ཕྱིར་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་བཀའ་གནང་བ་ལྟར་ཁྱེད་དག་པར་གྱུར་བའི་ཕྱིར་མཆོད་པ་ཞིག་ཕུལ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ཁོང་གི་སྙན་གྲགས་སྔོན་ལས་རྒྱ་ཆེ་བར་ཁྱབ་བཞིན་ཡོད་པས་ཁོང་གི་གསུང་ལ་ཉན་པ་དང༌། ཁོ་ཚོ་ནད་ལས་ཐར་བའི་ཆེད་དུ་མི་ཚོགས་མང་པོ་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","འོན་ཀྱང་ཡེ་ཤུ་སྨོན་ལམ་འདེབས་པའི་ཆེད་དུ་ནམ་རྒྱུན་ལྟར་དབེན་སྟོང་ལ་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ཉིན་ཞིག་ཁོང་གིས་ཆོས་བསྟན་གནང་བའི་སྐབས། ག་ལིལ་ཡུལ་གྱི་གྲོང་གསེབ་རེ་རེ་དང༌། ཡ་ཧུ་དཱ་ཡུལ། ཡེ་རུ་ཤ་ལེམ་ནས་ཡོང་བའི་ཕཱ་རུ་ཤི་པ་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁ་ཤས་དེ་རུ་བསྡད་དེ། ནད་གསོ་བར་མཛད་པའི་ཆེད་དུ་དཀོན་མཆོག་གི་ནུས་མཐུ་ཁོང་དང་ལྷན་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","མི་འགའ་ཤས་ཀྱིས་ཉལ་ཁྲི་སྟེང་ལ་གོམ་པ་སྤོ་མི་ཐུབ་པའི་ནད་པ་གཅིག་ཁུར་ཏེ་ནང་ལ་ཡོང་ནས་ཡེ་ཤུའི་མདུན་དུ་འཇོག་པའི་ཐབས་བཙལ་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","མི་ཚོགས་མང་བས་ཁོ་ཚོ་ཁོང་གི་དྲུང་དུ་མ་ཐར་སྟབས། ཁང་པའི་ཐོག་ཁར་འཛེགས་ནས་ཐོག་ས་བཀོག་སྟེ་ཁོ་ཚོས་ནད་པ་དང་ཉལ་ཁྲི་མཉམ་དུ་མི་ཚོགས་ཀྱི་དཀྱིལ་ལ་ཡེ་ཤུ་བཞུགས་སའི་མདུན་དུ་མར་ཕབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ཁོ་ཚོའི་དད་སེམས་མཁྱེན་ནས་ཁོང་གིས་“བུ། ཁྱེད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པའི་བསམ་པ་ལ་དཀོན་མཆོག་ལ་སྐུར་བ་འདེབས་མཁན་འདི་སུ་ཡིན། དཀོན་མཆོག་གཅིག་པོས་མ་གཏོགས་གཞན་སུས་སྡིག་ཉེས་སེལ་ཐུབ་སྙམ། ");
INSERT INTO bod_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱོད་ཚོས་བསམ་བློ་འདི་ལྟར་བཏང་དགོས་པའི་རྒྱུ་མཚན་གང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ནད་པ་དེར་ཁྱེད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་ཟེར་བ་ལས་སླ་པོ་ཡིན་ནམ། ཡང་ན་ལོངས་ལ་སོང་ཞིག་ཟེར་བ་ལས་སླ་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","འོན་ཀྱང་མིའི་རིགས་ཀྱི་བུ་ཟེར་མཁན་དེ་ལ་འཇིག་རྟེན་འདིར་སྡིག་ཉེས་སེལ་བའི་དབང་ཡོད་པ་ཁྱོད་ཚོས་ཤེས་པའི་ཕྱིར༌༌༌༌”ཞེས་གསུངས་ནས་ཁོང་གིས་ནད་པ་དེ་ལ་“ངས་ཁྱེད་ལ་ཟེར་རྒྱུར། ལོངས་ལ་ཉལ་ཁྲི་ཁྱེར་ནས་ནང་ལ་ལོག་ཅིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","མི་དེས་ཁོ་ཚོའི་མདུན་དུ་ལམ་སེང་ཡར་ལངས་ནས་ཉལ་ཁྲི་ཁྱེར་བ་དང་དཀོན་མཆོག་ལ་བསྟོད་དེ་ཁྱིམ་དུ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ཁོ་ཚོ་ཐམས་ཅད་ཡ་མཚན་ཆེན་པོ་སྐྱེས་ནས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ། འཇིགས་སྐྲག་སྐྱེས་ཏེ་“དེ་རིང་ང་ཚོས་ངོ་མཚར་ཅན་གྱི་མཛད་པ་མཐོང་བྱུང་”ཞེས་བཤད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","དེའི་རྗེས་སུ་ཁོང་ཕྱི་རུ་ཕེབས་ནས་ལེ་ཝི་ཞེས་བྱ་བའི་མི་ཞིག་ཁྲལ་ལེན་སར་བསྡད་ཡོད་པ་གཟིགས་ནས་དེ་ལ་“ཁྱེད་རང་ངའི་རྗེས་སུ་ཤོག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ཐམས་ཅད་སྤངས་ནས་ཡར་ལངས་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ལེ་ཝི་ཡིས་རང་གི་ཁྱིམ་དུ་ཡེ་ཤུ་ལ་གསོལ་སྟོན་ཆེན་པོ་བཤམས་ཏེ། ཁྲལ་སྡུད་མཁན་ལ་སོགས་པའི་མི་ཚོགས་མང་པོ་ཞིག་ཁོང་ཚོ་དང་མཉམ་དུ་ཟ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ཕཱ་རུ་ཤི་པ་དང་ཁོ་ཚོའི་ཕྱོགས་ཁག་ཏུ་གཏོགས་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཚོས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་“ཁྱེད་ཚོས་ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཉེས་ཅན་མཉམ་དུ་བཟའ་བཏུང་བྱེད་པ་འདི་ཅི་ཡིན་”ཞེས་མ་རངས་པའི་གཏམ་ཤོད་བཞིན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ཡེ་ཤུས་“ཁམས་བཟང་པོའི་མི་ལ་སྨན་པ་མི་དགོས་ཀྱི། ནད་པ་ཚོ་ལ་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ང་རང་ནི་ཆོས་དྲང་པོའི་མི་རྣམས་འབོད་དུ་ཡོང་བ་མ་ཡིན་གྱི། མི་སྡིག་ཅན་རྣམས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བར་འབོད་དུ་ཡོང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ཁོ་ཚོས་ཁོང་ལ་“ཡོ་ཧ་ནན་གྱི་སློབ་མར་སྨྱུང་གནས་སྲུང་ཞིང་སྨོན་ལམ་འདེབས་པའི་ལུགས་སྲོལ་ཡོད། ཕཱ་རུ་ཤི་པའི་སློབ་མའང་དེ་ལྟར་བྱེད། འོན་ཀྱང་ཁྱེད་ཀྱི་སློབ་མས་བཟའ་བཏུང་བྱེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ཡེ་ཤུས་“ཆང་སའི་སྐབས། མག་པ་དང་ཁོའི་རོགས་པ་རྣམས་མཉམ་དུ་ཡོད་དུས་ཁྱེད་ཀྱིས་དེ་ཚོར་སྨྱུང་གནས་སྲུང་དུ་འཇུག་ཐུབ་བམ། ");
INSERT INTO bod_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","འོན་ཀྱང་མག་པ་ཁོ་ཚོ་དང་ཁ་འབྲལ་བའི་དུས་ལ་འབབ་ཡོང༌། དུས་དེར་ཁོ་ཚོས་སྨྱུང་གནས་སྲུང་ངེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","དཔེའི་སྒོ་ནས་ཁོང་གིས་ཁོ་ཚོར་“མི་སུ་ཡིན་ཡང་རས་མཐུག་པོས་གོས་སྲབ་པོར་ལྷན་པ་མི་རྒྱག ལྷན་པ་བརྒྱབ་ན་རས་མཐུག་པོ་དེས་གོས་སྲབ་པོའི་སྲུབས་ཁ་ཇེ་ཆེར་འགྲོ ");
INSERT INTO bod_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ཡང་དེ་ལྟར་མི་སུ་ཞིག་ཡིན་ཡང་རྒུན་འབྲུམ་ཆང་གསར་པ་པགས་པའི་ཁུག་མ་རྙིང་པའི་ནང་བསྙལ་བར་མི་བྱ་སྟེ། གལ་ཏེ་བསྙལ་ཚེ་ཆང་འཕེལ་ནས་ཁུག་མ་རྙིང་པ་གས་ཏེ་ཆང་དང་ཁུག་མ་གཉིས་ཀ་འཕྲོ་བརླག་འགྲོ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","རྒུན་འབྲུམ་ཆང་གསར་པ་དེ་ཁུག་མ་གསར་པའི་ནང་དུ་བླུག་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ཡང་རྒུན་འབྲུམ་ཆང་རྙིང་མ་བཏུངས་ནས་མི་སུས་ཀྱང་གསར་པ་འཐུང་མི་འདོད། གང་ལགས་ཤེ་ན། ཁོས་རྒུན་ཆང་རྙིང་པ་དེ་ལེགས་སོ་ཞེས་ཟེར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ངལ་གསོ་བའི་ཉིན་མོ་ཞིག་ལ་ཡེ་ཤུ་ཞིང་ཁ་ཞིག་བརྒྱུད་ནས་ཕེབས་སྐབས། ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་འབྲུ་ཡི་སྙེ་མ་བཏོགས་ཏེ་ལག་པར་འཕུར་འཕུར་བྱས་ནས་བཟས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ཕཱ་རུ་ཤི་པ་ཁ་ཤས་ཀྱིས་“ཁྱེད་ཚོས་ཅིའི་ཕྱིར་ངལ་གསོ་བའི་ཉིན་མོར་བྱེད་མི་ཆོག་པའི་ལས་བྱེད་བཞིན་ཡོད་དམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ཡེ་ཤུས་“རྒྱལ་པོ་དཱ་བིད་དང་ཁོང་གི་འཁོར་གཡོག་རྣམས་ཀྱིས་ལྟོགས་པའི་ཚེ་ཅི་ཞིག་བྱས་པ་དེ་ཡང་ཁྱོད་ཚོས་བཀླགས་མ་མྱོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ཁོང་ཚོ་དཀོན་མཆོག་གི་མཆོད་ཁང་ལ་ཕེབས་ཏེ་དཀོན་མཆོག་གི་སྐུ་མདུན་གྱི་བག་ལེབ་བླངས་ནས་བཟས་ཤིང་འཁོར་གཡོག་རྣམས་ལའང་བྱིན་ནོ། བག་ལེབ་དེ་བཀའ་ཁྲིམས་ལྟར་ན་ཡ་ཧུ་དཱ་པའི་བླ་མ་རྣམས་ལས་གཞན་སུས་ཀྱང་ཟ་མི་ཆོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","དེ་ནས་ཁོང་གིས་“མིའི་རིགས་ཀྱི་བུ་ནི་ངལ་གསོ་བའི་ཉིན་གྱི་གཙོ་བོ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ངལ་གསོ་བའི་ཉིན་མོ་གཞན་ཞིག་ལ་ཁོང་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་དུ་ཕེབས་ནས་ཆོས་བསྟན་གནང་སྟེ། ལག་གཡས་པ་འཁུམས་པ་ཞིག་དེ་རུ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ཡེ་ཤུ་ལ་ནག་ཉེས་བཙུགས་པའི་ཕྱིར་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ངལ་གསོ་བའི་ཉིན་མོར་ཁོང་གིས་ནད་བཅོས་མི་བཅོས་ལ་ནན་ཏན་གྱིས་བལྟས་ཏེ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","འོན་ཀྱང་མི་དེ་ཚོའི་བསམ་པ་མཁྱེན་ཏེ་ཁོང་གིས་ལག་པ་འཁུམས་པའི་མི་དེར་“ཡར་ལངས་ནས་ཚུར་ཤོག་ཅིག་”ཅེས་གསུངས་པས་ཁོས་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ཡེ་ཤུས་ཁོ་ཚོར་“དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་མི་རྣམས་ལ་ངལ་གསོ་བའི་ཉིན་མོར་ལས་བཟང་པོ་བྱེད་ཆོག་གམ་ཡང་ན་ལས་ངན་པ་བྱེད་ཆོག སྲོག་སྐྱོབ་ཆོག་གམ་ཡང་ན་སྲོག་གཅོད་ཆོག་”ཅེས་དྲིས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","དེ་ཐམས་ཅད་ལ་རིམ་གྱིས་གཟིགས་ནས་ཁོང་གིས་མི་དེར་“ལག་པ་རྐྱོངས་ཤིག་”ཅེས་གསུངས་པས་ཁོས་ལག་པ་བརྐྱངས་ཤིང་ནད་གསོས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","འོན་ཀྱང་ཁོ་ཚོ་ཁོང་ཁྲོ་འབར་ནས་ཡེ་ཤུ་ལ་ཅི་ཞིག་བྱེད་པར་གྲོས་བསྡུར་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","དེའི་དུས་སུ་སྨོན་ལམ་འདེབས་པའི་ཕྱིར་ཁོང་རི་ཞིག་ལ་ཕེབས་ནས་མཚན་གང་དཀོན་མཆོག་ལ་གསོལ་བ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ནམ་ལངས་པའི་ཚེ་ཁོང་གི་ཉེ་གནས་རྣམས་བོས་ནས་བཅུ་གཉིས་པོ་བདམས་ཏེ་ཁོང་གིས་ཁོ་ཚོར་སྐུ་ཚབ་ཅེས་བཏགས། ");
INSERT INTO bod_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ཁོ་ཚོ་ནི་ཁོང་གིས་པེ་ཏྲོ་ཞེས་བཏགས་པའི་སི་མོན་དང༌། ཁོའི་གཅུང་པོ་ཨན་དྲི་ཡཱ། ཡ་ཀོབ། ཡོ་ཧ་ནན། ཕི་ལིབ། པར་ཐོ་ལོ་མཱ། ");
INSERT INTO bod_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","མད་ཐཱ། ཐོ་མཱ། ཨལ་ཕཱ་ཞེས་པ་དེའི་བུ་ཡ་ཀོབ། རྒྱལ་གཅེས་པའི་ཕྱོགས་ཁག་གི་ཁོངས་མི་སི་མོན། ");
INSERT INTO bod_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ཡ་ཀོབ་ཀྱི་བུ་ཡུ་དཱ། ཁོང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་དུ་འགྱུར་བ་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་བཅས་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ཡེ་ཤུ་ཁོ་ཚོ་དང་མཉམ་དུ་རི་ནས་མར་ཕེབས་ནས་ཐང་ཞིག་ལ་བཞུགས། དེར་ཡ་ཧུ་དཱའི་ཡུལ་ཐམས་ཅད་དང༌། ཡེ་རུ་ཤ་ལེམ། ས་དབུས་རྒྱ་མཚོའི་འགྲམ་ལ་ཆགས་པའི་གྲོང་ཁྱེར་ཐཱ་ཨེར་དང་ཚི་དོན་ནི། ");
INSERT INTO bod_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ཁོང་གི་གསུང་ལ་ཉན་པ་དང༌། ཁོ་ཚོ་ནད་ལས་ཐར་བའི་ཆེད་དུ་མི་ཚོགས་ཧ་ཅང་མང་པོ་འཛོམས་ཏེ། གདོན་འདྲེ་མི་གཙང་བས་བཟུང་བའི་མི་རྣམས་གསོས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ནུས་མཐུ་ཞིག་ཁོང་ནས་ཕྱིར་ཐོན་ཏེ་ཁོ་ཚོའི་ནད་ཀུན་གསོས་པར་མཛད་པས་ཚང་མས་ཁོང་ལ་རེག་ཐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ཉེ་གནས་རྣམས་ལ་གཟིགས་ཏེ་ཁོང་གིས། “དཀོན་མཆོག་རྒྱལ་སྲིད་ཁྱེད་ལ་གནང་བས་ནི། ། དབུལ་ཕོངས་ཡིན་པ་ཁྱེད་རྣམས་བདེ་བ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ཁྱེད་ཚོ་ཚིམ་པར་འགྱུར་ངེས་ཡིན་པའི་ཕྱིར། ། ད་ལྟ་བཀྲེས་པ་རྣམས་ནི་བདེ་བ་ཡིན། ། རྗེས་མ་ཁྱེད་ཚོ་དགའ་བར་འགྱུར་བའི་ཆེད། ། ཁྱེད་རྣམས་ད་ལྟ་བཤུམ་མཁན་བདེ་བ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","མི་ཡི་རིགས་ཀྱི་བུ་ཡི་དོན་དུ་ནི། ། ཁྱེད་ལ་སྡང་དང་ཟུར་ལ་ཕུད་བྱེད་དེ། ། དམའ་འབེབས་གཏོང་དང་མཐོང་ཆུང་བྱེད་པའི་སྐབས། ། ཁྱེད་རྣམས་ཤིན་ཏུ་བདེ་བ་ཡིན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ལྟོས་དང༌། དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཁྱེད་ལ་བྱ་དགའ་ཆེན་པོ་ཡོད་པས་ཉིན་མོ་དེར་དགའ་བའི་ངང་ནས་མཆོངས་ཤིག གང་ལགས་ཟེར་ན། མི་དེ་ཚོའི་མེས་པོས་ཀྱང་ལུང་སྟོན་པ་རྣམས་ལ་དེ་ལྟར་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","འོན་ཀྱང༌། ཕྱུག་པོ་ཡོངས་སུ་སེམས་གསོ་ཐོབ་ཟིན་པས། ། ཁྱོད་རྣམས་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ཁྱོད་རྣམས་བཟས་ནས་ཚིམ་པར་འགྱུར་བ་ལ། ། ལྟོགས་པར་འགྱུར་བའི་ཆད་པ་ཕོག་པར་འགྱུར། ། གད་མོ་དགོད་པར་ཆད་པ་ཕོག་འགྱུར་ཏེ། ། ཁྱོད་རྣམས་མྱ་ངན་བྱེད་ཅིང་ངུ་བར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ལུང་སྟོན་རྫུན་མར་མེས་པོས་བྱས་པ་ལྟར། ། ཐམས་ཅད་ཁྱོད་ལ་བསྟོད་བསྔགས་བྱས་འགྱུར་ན། ། ཁྱོད་རྣམས་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། །” ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ཡང་ཁོང་གིས་“ངས་ཁྱེད་ཉན་མཁན་རྣམས་ལ་ཟེར་རྒྱུར། དགྲ་བོ་རྣམས་ལ་བྱམས་པ་གྱིས་ཤིག ཁྱེད་ལ་སྡང་མཁན་རྣམས་ལ་ལས་བཟང་པོ་བྱོས། ");
INSERT INTO bod_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ཁྱེད་ཚོར་དམོད་མོ་འདེབས་མཁན་ལ་བྱིན་གྱིས་རློབས་ཤིང༌། ཁྱེད་ཚོར་སྨད་ར་གཏོང་མཁན་གྱི་དོན་དུ་སྨོན་ལམ་འདེབས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","སུས་ཁྱེད་ལ་འགྲམ་པ་ཡ་གཅིག་ལ་འགྲམ་ལྕག་བཞུས་ན། དེ་ལ་འགྲམ་པ་གཞན་ཡང་སྟོན། སུས་ཁྱེད་ཀྱི་ཕྱི་གོས་ཕྲོགས་ན། དེ་ལ་ནང་གོས་ཀྱང་འཁྱེར་དུ་ཆུག ");
INSERT INTO bod_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","སུས་ཁྱེད་ལ་གང་ཞིག་ཞུས་ན་དེ་ལ་སྦྱིན། སུས་ཁྱེད་ཀྱི་དངོས་པོ་ཕྲོགས་ན། དེ་ལ་ཚུར་ཁྱེར་ཤོག་ཅེས་མི་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","མི་གཞན་གྱིས་ཇི་ལྟར་ཁྱེད་ཚོར་བྱས་ན་དགའ་བ་བཞིན། དེ་ལྟར་གཞན་ལ་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ཁྱེད་ལ་བྱམས་པ་བྱེད་མཁན་ལ་བྱམས་ན་ཅི་ཕན། སྡིག་ཉེས་ཅན་ཡང་སོ་སོར་བྱམས་པ་བྱེད་མཁན་ལ་བྱམས། ");
INSERT INTO bod_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ཁྱེད་ལ་བཟང་པོ་བྱེད་མཁན་ལ་བཟང་པོ་བྱས་ན་ཅི་ཕན། སྡིག་ཉེས་ཅན་གྱིས་ཀྱང་དེ་ལྟར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","སྐྱིན་པ་ལེན་པའི་ཆེད་དུ་མི་གཞན་ལ་གཡར་ན་ཅི་ཕན། སྐྱིན་པ་ལེན་པའི་ཕྱིར་ཐ་ན་སྡིག་ཅན་གྱིས་སྡིག་ཅན་ལ་གཡར། ");
INSERT INTO bod_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","གལ་ཏེ་ཁྱེད་ཀྱིས་དགྲ་བོ་རྣམས་ལ་བྱམས་ཤིང༌། བཟང་པོ་བྱེད། སྐྱིན་པ་ལེན་པའི་རེ་བ་མེད་པར་མི་གཞན་ལ་གཡར་ན། ཁྱེད་ཀྱི་བྱ་དགའ་ཆེན་པོ་ཡིན་པ་མ་ཟད། ཁྱེད་ཚོ་བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་སྲས་ཡིན་པར་འགྱུར། གང་ལགས་ཟེར་ན། ཁོང་གིས་དྲིན་ལན་ལོག་འཇལ་བ་དང་ངན་པ་རྣམས་ལ་དྲིན་སྐྱོང་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ཁྱེད་ཀྱི་ཡབ་ཐུགས་རྗེ་ཅན་ཡིན་པ་ལྟར་ཁྱེད་ཀྱང་སྙིང་རྗེ་ཅན་དུ་འགྱུར་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ཡང་ཁོང་གིས་“སྐྱོན་འདོགས་མ་བྱོས་དང་ཁྲིམས་གཅོད་འབྱུང་བར་མི་འགྱུར། ཁ་རྡུང་མ་གཏོང་དང་ཆད་པ་ཕོག་པར་མི་འགྱུར། གཞན་ལ་གུ་ཡངས་གཏོང་དང་རང་གི་སྡིག་ཉེས་སེལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","མི་གཞན་ལ་སྦྱིན་དང་ཁྱེད་ལ་གནང་བར་འགྱུར་ཏེ། བྲེ་གང་ལས་མང༌། མནན་ནས་སྤྲུགས་པར་ཁྱེད་ཀྱི་ཐུ་བ་ལ་གཏོང་ཕོད་ཀྱིས་བླུག་པར་འགྱུར། སྣོད་གང་གིས་འཇལ་བ་དེ་རང་གིས་ཁྱེད་ལ་ཡང་འཇལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","དེ་ཡང་དཔེའི་སྒོ་ནས་ཁོང་གིས་ཁོ་རྣམས་ལ་“ལོང་བ་ཞིག་གིས་ལོང་བ་གཞན་ཞིག་ཁྲིད་ན་དེ་ཚོ་གཉིས་ས་སྡོང་ལ་འགྱེལ་བར་མི་འགྱུར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ཉེ་གནས་སློབ་དཔོན་ལས་ཆེ་བ་མ་ཡིན། འོན་ཀྱང་ཡོན་ཏན་མཐར་ཕྱིན་པ་རྣམས་སློབ་དཔོན་དང་འདྲ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","གཞན་གྱི་མིག་ལ་ཡོད་པའི་ཤིང་རྡུལ་མཐོང་ཡང༌། རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་མི་མཐོང་བ་དེ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་མི་མཐོང་བར་གཞན་ལ་ཁྱེད་ཀྱི་མིག་ལ་ཡོད་པའི་ཤིང་རྡུལ་འདོན་པར་བྱ་ཞེས་ཅི་ལྟར་ཟེར། ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད། རང་གི་མིག་ལ་ཡོད་པའི་གདུང་མ་ཐོན་ཅིག དེ་ནས་གཞན་གྱི་མིག་ལ་ཤིང་རྡུལ་འདོན་པའི་ཆེད་དུ་གསལ་པོར་མཐོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ཁོང་གིས་“ཤིང་སྡོང་བཟང་པོ་ལས་འབྲས་བུ་ངན་པ་མི་སྐྱེ་ལ། ཤིང་སྡོང་ངན་པ་ལས་འབྲས་བུ་ལེགས་པོ་མི་སྐྱེ། ");
INSERT INTO bod_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","དེའི་ཕྱིར་ཤིང་སྡོང་རེ་རེ་འབྲས་བུ་ནས་ངོ་ཤེས། སུས་ཀྱང་ཚེར་ཤིང་ནས་བསེ་ཡབ་ཀྱི་འབྲས་བུ་མི་ལེན་ལ། ཡང་ན་སེ་བའི་མེ་ཏོག་ནས་རྒུན་འབྲུམ་འཐོག་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","མི་བཟང་པོ་ཞིག་གིས་སེམས་ཀྱི་མཛོད་བཟང་པོ་ནས་བཟང་པོ་འདོན་པ་དང༌། མི་ངན་པ་ཞིག་གིས་སེམས་ཀྱི་མཛོད་ངན་པ་ནས་ངན་པ་འདོན། གང་ལགས་ཟེར་ན། སེམས་ཀྱི་མཛོད་ནས་ཁ་ཡིས་བརྗོད། ");
INSERT INTO bod_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ང་ལ་གཙོ་བོ་ལགས། གཙོ་བོ་ལགས་ཞེས་ཟེར་ནས་ངའི་ཁ་ལ་མི་ཉན་པ་དེ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ངའི་རྩར་ཡོང་ནས་ངས་སྨྲ་བའི་ཚིག་ཐོས་ཏེ་ཉམས་ལེན་བྱེད་མཁན་འདི་ལྟར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ཁོ་ནི་གཏིང་རིང་པོ་བརྐོས་ནས་བྲག་ལ་རྨང་གཞི་བརྟན་པོ་བཟོས་པའི་ཁང་པ་བཟོ་མཁན་ལྟར་ཡིན། ཁང་པ་དེ་ལེགས་པོར་བརྩིགས་པས་ཆུ་ལོག་བྱུང་སྐབས་དྲག་ཏུ་རྒྱུག་པའི་ཆུ་ཡིས་ཁང་པ་དེར་ཕོག་ནས་གཡོས་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","འོན་ཀྱང་ངས་སྨྲ་བའི་ཚིག་ཐོས་ནས་ཉམས་ལེན་མི་བྱེད་མཁན་ནི་རྨང་གཞི་མེད་པའི་ཁང་པ་བཟོ་མཁན་ལྟར་ཡིན། ཆུ་ལོག་བྱུང་སྐབས་དྲག་ཏུ་རྒྱུག་པའི་ཆུ་ཡིས་ཁང་པ་དེར་ཕོག་ནས་འཕྲལ་དུ་རྡིབ་སྟེ། ཁང་པ་དེ་ཡོངས་སུ་འཇིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ཡེ་ཤུས་མི་ཚོགས་ཀྱི་ཐོས་སར་བཀའ་དེ་ཐམས་ཅད་གསུངས་ཚར་རྗེས་ཀ་ཕར་ན་ཧུམ་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","དེར་དམག་མི་བརྒྱ་དཔོན་ཅིག་གིས་གུས་པར་བྱེད་པའི་གཡོག་པོ་ཞིག་ན་ནས་ཤི་གྲབས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","བརྒྱ་དཔོན་དེས་ཡེ་ཤུའི་སྐོར་ཐོས་པ་དང༌། གཡོག་པོ་ནད་ལས་ཐར་བའི་ཕྱིར་ཁོས་ཡེ་ཤུ་གདན་འདྲེན་ཞུ་བར་ཡ་ཧུ་དཱ་པའི་འགན་འཁུར་བའི་རྒན་པོ་རྣམས་ཁོང་གི་རྩར་བཏང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ཡེ་ཤུའི་མདུན་དུ་སླེབས་ནས་ཁོ་ཚོས་“ཁྱེད་ཀྱིས་དམག་མི་འདི་ལ་དེ་ལྟར་མཛད་འོས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","གང་ལགས་ཤེ་ན། ང་ཚོའི་མི་རིགས་ལ་བྱམས་ཤིང༌། ཁོང་གིས་ང་ཚོའི་འདུ་ཁང་བརྩིགས་”ཞེས་ཞུ་བ་ནན་གྱིས་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ཡེ་ཤུ་ཁོ་ཚོ་དང་མཉམ་དུ་ཕེབས་ནས་ཁང་པ་དང་ཉེ་བར་བྱོན་སྐབས། བརྒྱ་དཔོན་གྱིས་གྲོགས་པོ་ཁ་ཤས་བཏང་སྟེ་ཁོང་ལ་“གཙོ་བོ། ཁྱེད་འོ་བརྒྱལ་ཏེ་ངའི་ཁྱིམ་ནང་དུ་ཕེབས་པར་མི་འོས་པ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ང་ཁྱེད་ཀྱི་སྐུ་མདུན་དུ་བཅར་བ་ཡང་མི་འོས་བསམས་པས། ཁྱེད་ཀྱིས་བཀའ་གནང་བར་མཛོད་དང༌། ངའི་གཡོག་པོ་ནད་ལས་ཐར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","གང་ལགས་ཤེ་ན། ང་ཡང་གཞན་གྱི་དབང་འོག་ཏུ་ཡོད་དང༌། ངའི་འོག་ཏུ་ཡང་དམག་མི་ཡོད། ངས་མི་ཞིག་ལ་སོང་ཞེས་ཟེར་ན་འགྲོ གཞན་ལ་ཚུར་ཤོག་ཅེས་བཤད་ན་ཡོང༌། ངའི་གཡོག་པོར་ལས་ཀ་དེ་བྱོས་ཤིག་ཅེས་བཤད་ན་ཁོས་དེ་ལྟར་བྱེད་”ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ཡེ་ཤུས་དེ་གསན་ནས་ཡ་མཚན་སྐྱེས་པ་དང༌། ཞལ་ཕྱིར་བསྐོར་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲང་བའི་མི་ཚོགས་ལ་“ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཡི་སི་ར་ཨེལ་ལ་ཡང་ངས་འདི་འདྲ་བའི་དད་སེམས་ཡོད་པའི་མི་མ་མཐོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ཡེ་ཤུའི་མདུན་དུ་བཏང་ཡོད་པའི་མི་རྣམས་བརྒྱ་དཔོན་གྱི་ཁང་པར་ཕྱིར་ལོག་སྐབས་གཡོག་པོ་ཁམས་བཟང་པོར་བསྡད་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","རིང་པོར་མ་ལོན་པར་ཁོང་ཉེ་གནས་དང་མི་ཚོགས་མང་པོ་ཞིག་དང་བཅས་པ་ནཱ་ཨིན་ཞེས་པའི་གྲོང་ཁྱེར་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","གྲོང་ཁྱེར་གྱི་རྒྱལ་སྒོ་དང་ཉེ་བར་བྱོན་སྐབས། ཁོང་གིས་མི་ཚོགས་མང་པོ་ཡོང་བཞིན་པ་གཟིགས། ཁོ་ཚོས་ཡུགས་མོ་ཞིག་གི་བུ་གཅིག་པོའི་ཕུང་པོ་ཕྱི་ལོགས་སུ་ཁུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","གཙོ་བོས་ཁོ་མོ་ལ་གཟིགས་ནས་ཐུགས་རྗེ་སྐྱེས་ཏེ་ཁོ་མོར་“མ་ཤུམས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ཏོག་ཙམ་ཚུར་ཕེབས་པ་དང་ཕུང་པོ་ཡོད་པའི་འཁྱོགས་ཤིང་ལ་ཕྱག་གིས་རེག་ནས་ཁུར་མཁན་བསྡད། ཁོང་གིས་“གཞོན་ནུ། ངས་ཁྱེད་ལ་ཟེར་རྒྱུར། ཡར་ལོངས་ཤིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","གཤིན་པོ་དེ་གསོན་པོར་ལངས་ནས་སྐད་ཆ་བཤད། ཡེ་ཤུས་བུ་དེ་རང་གི་ཨ་མ་ལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","འཇིགས་པ་སྐྱེས་ནས་ཚང་མས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཏེ་“ང་ཚོའི་ཁྲོད་དུ་ལུང་སྟོན་པ་ཆེན་པོ་ཞིག་འདུག་”ཅེས་པ་དང་“དཀོན་མཆོག་གིས་ཁོང་གི་མི་རིགས་ལ་ཐུགས་རྗེས་གཟིགས་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","གཏམ་འདི་ཡ་ཧུ་དཱ་ཡུལ་ཡོངས་དང༌། མཐའ་འཁོར་གྱི་ས་ཆ་ཀུན་ཏུ་ཁྱབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་སློབ་མ་རྣམས་ཀྱིས་ཁོང་ལ་དོན་དེ་ཚོ་ཐམས་ཅད་བཤད་པས། ཡོ་ཧ་ནན་གྱིས་སློབ་མ་གཉིས་བོས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","གཙོ་བོའི་མདུན་དུ་བཏང་སྟེ་ཁོང་ལ་“ཁྱེད་འབྱོན་པར་འགྱུར་ཞེས་བྱ་བ་དེ་ཡིན་ནམ། ཡང་ན་ང་ཚོ་གཞན་ཞིག་སྒུག་པར་བྱ་”ཞེས་འདྲི་བའི་ཆེད་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","སློབ་མ་དེ་གཉིས་ཡེ་ཤུའི་དྲུང་དུ་སླེབས་ནས་ཁོང་ལ་“ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱིས་འདི་ཞུ་བར་ང་ཚོ་མངགས་ཏེ། ཁྱེད་འབྱོན་པར་འགྱུར་བ་དེ་ཡིན་ནམ། ཡང་ན་ང་ཚོ་གཞན་ཞིག་སྒུག་པར་བྱ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","དེའི་སྐབས་སུ་ཡེ་ཤུས་ནད་རིགས་སྣ་ཚོགས་གསོས་པར་མཛད་པ་དང༌། གདོན་འདྲེ་མང་པོ་ཕྱིར་བསྐྲད་པ་མ་ཟད། ལོང་བ་མང་པོ་མཐོང་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ལན་དུ་ཁོང་གིས་ཁོ་ཚོར་“སོང་ལ་ཁྱེད་ཀྱིས་གང་མཐོང་བ་དང་ཐོས་པ། ལོང་བས་མཐོང་བ། ཞ་བོ་འགྲོ་བ། མཛེ་ནད་ཅན་དག་པར་འགྱུར་བ། འོན་པས་ཐོས་པ། གཤིན་པོ་རྣམས་གསོན་པོར་ལངས་པར་འགྱུར་བ། དབུལ་ཕོངས་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་པ་སོགས་ཡོ་ཧ་ནན་ལ་ཤོད། ");
INSERT INTO bod_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ངའི་རྐྱེན་གྱིས་དད་པ་མི་ཉམས་པ་ནི་བདེའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ཡོ་ཧ་ནན་གྱི་བང་ཆེན་སོང་ནས་ཡེ་ཤུས་མི་ཚོགས་ལ་ཡོ་ཧ་ནན་གྱི་སྐོར་འདི་ལྟར་གསུངས་“ཁྱེད་ཚོས་ཅི་ཞིག་ལྟ་རུ་དབེན་སྟོང་ལ་སོང༌། རླུང་གིས་གཡོ་བའི་འདམ་རྩྭ་ཞིག་ལྟ་རུ་སོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","འོ་ན་ཁྱེད་ཚོས་ཅི་ཞིག་ལྟ་རུ་སོང༌། མི་གོས་སྤུས་ལེགས་གྱོན་པ་ཞིག་ལ་ལྟ་རུ་སོང་ངམ། གོས་སྤུས་ལེགས་གྱོན་པ་དང་རྒྱས་སྤྲོས་བྱེད་པ་རྣམས་ནི་རྒྱལ་པོའི་ཕོ་བྲང་ལ་སྡོད་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ཁྱེད་ཚོས་ཅི་ཞིག་ལ་ལྟ་རུ་སོང༌། ལུང་སྟོན་པ་ཞིག་ལ་ལྟ་རུ་སོང་ངམ། ལགས་ཡིན། ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ལུང་སྟོན་པ་ལས་ལྷག་པ་ཞིག་ལྟ་རུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ཁོང་གི་སྐོར་ལ་དཀོན་མཆོག་གི་དམ་པའི་གསུང་རབ་ནང་དུ་འདི་ལྟར་གསུངས། ལྟོས་ཤིག ང་ཡི་ཕོ་ཉ་ཁྱེད་ཀྱི་མདུན་དུ་གཏོང༌། ། དེ་ཡིས་ཁྱེད་ཀྱི་ལམ་ནི་བསལ་བར་བྱ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། བུད་མེད་ལས་སྐྱེས་པ་ཐམས་ཅད་ཀྱི་ནང་ནས་ཡོ་ཧ་ནན་ལས་ཆེ་བ་གཅིག་ཀྱང་མེད། འོན་ཀྱང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ལ་མི་ཆུང་ཤོས་ཁོང་ལས་ཆེའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ཁྲལ་སྡུད་མཁན་ཚུད་པའི་མི་ཐམས་ཅད་ཀྱིས་དེ་ཐོས་ནས་དཀོན་མཆོག་གི་དྲང་བ་ཉིད་ངོས་ལེན་བྱས། གང་ལགས་ཟེར་ན། ཁོ་ཚོས་ཡོ་ཧ་ནན་གྱི་ཁྲུས་གསོལ་བླངས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","འོན་ཀྱང་ཕཱ་རུ་ཤི་པ་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ནི་ཡོ་ཧ་ནན་གྱི་ཁྲུས་གསོལ་མ་བླངས་པའི་སྒོ་ནས་དཀོན་མཆོག་གི་ཐུགས་དགོངས་རང་གི་དོན་དུ་དོར་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","དུས་རབས་འདིའི་མི་རྣམས་གང་ཞིག་ལ་སྡུར་བར་བྱ། ཁོ་ཚོ་སུ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ཁོ་ཚོ་ཚོང་རར་སྡོད་པའི་ཕྲུ་གུ་གཅིག་གིས་གཅིག་ལ་འབོད་དེ། ཁྱོད་ཕྱིར་གླིང་བུ་བཏང་ན་ཡང༌། ། ཁྱོད་ཀྱིས་ཞབས་བྲོ་མ་བརྒྱབ་ལ། ། ཁྱོད་ཆེད་མྱ་ངན་གླུ་བླངས་ཀྱང༌། ། ཁྱོད་ཚོས་ངུ་བར་མ་བྱས་སོ། ། ཞེས་པ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","གང་ལགས་ཟེར་ན། ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་བག་ལེབ་ཀྱང་མི་ཟ་ལ་རྒུན་ཆང་ཡང་མི་འཐུང་བར་ཕེབས་དུས་ཁྱོད་ཚོས་“འདྲེ་ཞུགས་པ་ཞིག་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","མིའི་རིགས་ཀྱི་བུ་ཟ་འཐུང་བྱེད་པར་ཡོང་ནས་ཁྱོད་ཚོས་“ལྟོས་ཤིག ཁོ་ནི་ལྟོགས་རྔམ་ཅན་དང༌། ར་བཟི་ཅན། ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཉེས་ཅན་གྱི་གྲོགས་པོ་ཞིག་ཡིན་”ཞེས་སྨྲ། ");
INSERT INTO bod_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","འོན་ཀྱང་ཤེས་རབ་དེའི་ཕྲུ་གུ་ཀུན་གྱིས་ཡང་དག་པ་ཡིན་པར་ཁུངས་སྐྱེལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","དེ་ཡང་ཕཱ་རུ་ཤི་པ་ཞིག་གིས་ཡེ་ཤུ་དྲངས་ཏེ་ཁོང་དེའི་ཁྱིམ་ལ་ཕེབས་ནས་ཉལ་ཁྲིར་བསྙེས་ཏེ་གསོལ་བ་བཞེས་སུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","བུད་མེད་སྡིག་ཉེས་ཅན་ཞིག་གྲོང་ཁྱེར་དེར་ཡོད་དེ། ཁོ་མོས་ཡེ་ཤུ་ཕཱ་རུ་ཤི་པའི་ཁྱིམ་ལ་ཞལ་ལག་བཞེས་བཞིན་པར་ཤེས་ནས། སྤོས་ཆུ་གང་བའི་རྡོ་ཀ་མ་རུའི་བུམ་པ་ཞིག་ཁྱེར་ཡོང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ཁོང་གི་རྒྱབ་ཏུ་ཡེ་ཤུའི་ཞབས་དང་ཉེ་བར་ལངས་ནས་ངུ་བཞིན་བསྡད་པ་དང༌། ཁོ་མོའི་མིག་ཆུས་ཁོང་གི་ཞབས་རློན་པར་འགྱུར་ཏེ་རང་གི་སྐྲ་ཡིས་འཕྱིས་པ་དང༌། ཞབས་ལ་འོ་བྱས་ནས་སྤོས་ཆུ་བླུགས། ");
INSERT INTO bod_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ད་ཁོང་གདན་འདྲེན་ཞུ་བའི་ཕཱ་རུ་ཤི་པས་དེ་མཐོང་ནས་མི་འདི་ལུང་སྟོན་པ་ཡིན་ན་ཁོང་ལ་རེག་པའི་བུད་མེད་འདི་སུ་དང་གང་འདྲ་ཞིག་ཡིན་པ་དང༌། སྡིག་ཉེས་ཅན་ཡིན་པར་མཁྱེན་གྱི་རེད་བསམས། ");
INSERT INTO bod_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ལན་དུ་ཡེ་ཤུས་“སི་མོན། ངས་ཁྱེད་ལ་སྐད་ཆ་ཤོད་རྒྱུ་ཡོད་”ཅེས་གསུངས་པས་ཁོས་“སློབ་དཔོན་ལགས། གསུང་རོགས་གནང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ཡེ་ཤུས་“དངུལ་བུན་གཏོང་མཁན་ཅིག་ལ་བུ་ལོན་པ་གཉིས་ཡོད་དེ། གཅིག་ལ་དེ་ཎ་རིའི་དངུལ་སྒོར་ལྔ་བརྒྱ་དང༌། གཞན་ལ་དེ་ཎ་རིའི་དངུལ་སྒོར་ལྔ་བཅུའི་བུ་ལོན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","བུ་ལོན་འཇལ་མ་ཐུབ་པས་བུན་བདག་གིས་ཁོ་ཚོ་གཉིས་ཀའི་བུ་ལོན་བསལ། ད་ཁོང་ལ་ལྷག་པར་གཅེས་པའི་བུ་ལོན་པ་སུ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ལན་དུ་སི་མོན་གྱིས་“མང་པོ་བསལ་བ་དེས་ལྷག་པར་གཅེས་པར་བྱ་སྙམ་བྱུང་”ཞེས་སྨྲས་པ་དང༌། ཁོང་གིས་ཁོ་ལ་“ཁྱེད་ཀྱིས་ལེགས་པར་བཤད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","བུད་མེད་དེར་ཞལ་ཕྱིར་བསྐོར་ཏེ་ཁོང་གིས་སི་མོན་ལ་“ཁྱོད་ཀྱིས་བུད་མེད་འདི་མཐོང་ངམ། ང་ཁྱོད་ཀྱི་ཁྱིམ་དུ་ཡོང་བ་དང༌། ཁྱོད་ཀྱིས་ང་ལ་རྐང་པ་འཁྲུད་པའི་ཆུ་མ་སྟེར། འོན་ཀྱང་ཁོ་མོས་རང་གི་མིག་ཆུ་ཡིས་ངའི་རྐང་པ་བཀྲུས་ནས་སྐྲ་ཡིས་འཕྱིས། ");
INSERT INTO bod_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ཁྱོད་ཀྱིས་ང་ལ་འོ་མ་བྱས། ང་སླེབས་ནས་ཁོ་མོས་ངའི་རྐང་པར་མུ་མཐུད་ནས་འོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ཁྱོད་ཀྱིས་ངའི་མགོར་སྣུམ་མ་བྱུགས། ཁོ་མོས་ངའི་རྐང་པར་སྤོས་ཆུ་བླུགས། ");
INSERT INTO bod_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","དེའི་ཕྱིར་ངས་ཁྱོད་ལ་ཟེར་རྒྱུར། ཁོ་མོའི་སྡིག་ཉེས་མང་པོ་བསལ་ཟིན་པའི་རྐྱེན་གྱིས་མང་དུ་གཅེས། སྡིག་ཉེས་ཉུང་ངུ་བསལ་བ་དེས་ཉུང་ངུ་གཅེས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","དེ་ནས་ཁོང་གིས་ཁོ་མོར་“ཁྱེད་ཀྱི་སྡིག་ཉེས་བསལ་ཟིན་པ་ཡིན་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ཁོང་དང་གསོལ་བ་བཞེས་པའི་མི་རྣམས་གཅིག་གིས་གཅིག་ལ་“སྡིག་ཉེས་ཀྱང་སེལ་མཁན་འདི་སུ་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ཡང་ཁོང་གིས་བུད་མེད་དེར་“ཁྱེད་ཀྱི་དད་པས་ཁྱེད་ཐར་ཟིན་པས་ཞི་བདེར་སོང་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","རིང་པོར་མ་ལོན་པར་ཁོང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་སྒྲོག་སྟེ་གྲོང་ཁྱེར་དང༌། གྲོང་གསེབ་བརྒྱུད་ནས་ཕེབས། ཉེ་གནས་བཅུ་གཉིས་པོ་ཁོང་དང་མཉམ་དུ་ཡོད་པ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ནད་དང་གདོན་འདྲེ་ལས་ཐར་བའི་བུད་མེད་ནི། གདོན་འདྲེ་བདུན་ཕྱིར་ཐོན་པའི་མག་རྡལ་ནས་ཡིན་པའི་མིར་ཡམ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡི་ཁྱིམ་ཚང་གི་གཉེར་པ་ཀུ་སཱ་ཡི་བཟའ་ཟླ་ཡོ་ཨ་ནཱ། སུ་སན་ནཱ་སོགས་པའི་བུད་མེད་མང་པོ་ཡང་ཡོད། ཁོ་ཚོས་རང་གི་རྒྱུ་ནོར་གྱིས་ཁོང་ཚོར་རྒྱབ་སྐྱོར་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","གྲོང་ཁྱེར་སོ་སོ་ནས་ཡོང་བའི་མི་རྣམས་ཁོང་གི་མདུན་དུ་ཡོང་བ་དང་མི་ཚོགས་མང་པོ་ཞིག་འཛོམས་ཏེ་ཁོང་གིས་དཔེའི་སྒོ་ནས་དེ་རྣམས་ལ་ ");
INSERT INTO bod_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ས་བོན་འདེབས་མཁན་ཞིག་ས་བོན་འདེབས་པར་ཕྱིན། ས་བོན་གཏོར་བའི་དུས་སུ། ས་བོན་ཁ་ཤས་ལམ་ཁར་འཐོར་ནས་རྐང་པས་བརྫིས་པ་དང་བྱ་རྣམས་ཡོང་ནས་བཟས། ");
INSERT INTO bod_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ཁ་ཤས་ནི་ས་མང་པོ་མེད་པའི་བྲག་གི་སྟེང་ལ་འཐོར་བ་དང་ཡར་སྐྱེས་ནས་བཞའ་ཚན་མེད་པས་བསྐམས། ");
INSERT INTO bod_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ས་བོན་ཁ་ཤས་ཚེར་མའི་ནང་དུ་འཐོར་ཞིང་ཚེར་མ་དང་མཉམ་དུ་ཡར་སྐྱེས་ཏེ་བསྒྲིབས་ནས་འབྲས་བུ་མ་སྨིན། ");
INSERT INTO bod_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ཡང་ས་བོན་ཁ་ཤས་ས་རྒྱུ་བཟང་པོར་འཐོར་བས་ཡར་སྐྱེས་ཤིང་འབྲས་བུ་ལྡབ་བརྒྱ་སྨིན་”ཞེས་གསུངས་དུས་ཁོང་གིས་“རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་དཔེའི་ནང་དོན་ཅི་ཡིན་པ་དྲིས་པའི་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་གསང་བའི་དོན་དེ་ཁྱེད་ཚོ་ལ་བསྟན་པ་ཡིན། འོན་ཀྱང་གཞན་དག་རྣམས་ལ་དཔེའི་སྒོ་ནས་བསྟན། དེ་ནི། ལྟ་བར་བྱེད་ཀྱང་མི་མཐོང༌། ། ཐོས་པར་བྱེད་ཀྱང་མི་རྟོགས། ། ཞེས་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","དཔེ་དེ་འདི་ལྟར་ཡིན། ས་བོན་ནི་དཀོན་མཆོག་གི་བཀའ་དང་འདྲ་བ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ལམ་ཁར་འཐོར་བ་ནི་བཀའ་ཐོས་པ་རྣམས་ཡིན། དད་པ་མི་སྐྱེ་པའི་ཆེད་དང༌། ཐར་བར་མི་འགྱུར་བའི་ཕྱིར་བདུད་སཱ་ཏན་ཡོང་ཞིང་དེ་རྣམས་ཀྱི་སེམས་ནང་གི་བཀའ་ཕྲོགས་ནས་ཕར་འཁྱེར། ");
INSERT INTO bod_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","བྲག་ཡོད་པའི་ས་ལ་འཐོར་བ་ནི་ཡང་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་ནས་སེམས་དགའ་བའི་ངང་ནས་བླངས་ཀྱང༌། རང་གི་སེམས་ནང་ལ་རྩ་བ་གཏིང་རིང་པོ་ཚུགས་མེད་པས་དུས་ཐུང་ངུ་ལ་གནས་ཀྱང༌། སླུ་བྲིད་འབྱུང་སྐབས་དད་ལོག་བྱེད་པ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ཡང་ཚེར་མའི་ནང་དུ་འཐོར་བ་ནི་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་ནས་རྗེས་མ་འཚོ་བའི་སྐོར་གྱི་སེམས་ཁྲལ་དང༌། རྒྱུ་ནོར། འདོད་པ་སྣ་ཚོགས་ཀྱིས་བཀའ་མནན་ནས་འབྲས་བུ་སྨིན་མ་ཐུབ་པ་དང་འདྲ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ས་རྒྱུ་བཟང་པོ་ལ་འཐོར་བ་ནི་ཡང་མི་ལ་ལས་དཀོན་མཆོག་གི་བཀའ་དེ་ཐོས་ཏེ་སེམས་དྲང་ཞིང་བཟང་པོ་ཞིག་ལ་དམ་པོར་བཟུང་ནས་མཐར་སྐྱེལ་བཏང་བའི་ངང་ནས་འབྲས་བུ་སྨིན་ཐུབ་པ་རྣམས་དང་འདྲ་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ཡང་ཡེ་ཤུས་“མི་སུ་ཡིན་ཡང་མར་མེ་སྤར་ནས་བྲེ་ཡང་ན་ཉལ་ཁྲིའི་འོག་ཏུ་མི་འཇོག་སྟེ་ནང་ལ་ཡོང་མཁན་རྣམས་ཀྱིས་འོད་མཐོང་བའི་ཕྱིར་སྟེགས་བུའི་སྟེང་དུ་འཇོག ");
INSERT INTO bod_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","གང་ལགས་ཟེར་ན། སྦས་པའི་དོན་རྣམས་མི་མངོན་པ་ཅི་ཡང་མེད་ལ། གསང་བའི་དོན་ཐམས་ཅད་ཀྱང་མི་མངོན་པའམ་མི་ཤེས་པ་ཅི་ཡང་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ཁྱེད་ཚོས་གང་ཐོས་པ་དེ་ལ་གཟབ་ཉན་གྱིས་ཤིག གང་ལགས་ཟེར་ན། མི་སུ་ཞིག་ཐོས་པ་དང་རྟོགས་པ་འདོད་པ་དེ་ལ་སྟེར་བར་འགྱུར། རྟོགས་པ་མི་འདོད་པ་དེ་ལས་གང་ཡོད་པ་དེ་ཡང་ལེན་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","དེ་ནས་ཡེ་ཤུའི་ཡུམ་དང་གཅུང་པོ་ཚོ་ཕེབས་ཏེ། མི་ཚོགས་མང་བས་ཁོང་ཚོ་ཁོང་གི་དྲུང་དུ་མ་ཐར་སྟབས། ");
INSERT INTO bod_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","མི་ཞིག་གིས་ཁོང་ལ་“ཁྱེད་ཀྱི་ཡུམ་དང་སྐུ་མཆེད་ཚོས་ཕྱི་རོལ་ནས་ཁྱེད་རང་འཚོལ་བཞིན་འདུག་”ཅེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ལན་དུ་ཁོང་གིས་ཁོ་ཚོར་“དཀོན་མཆོག་གི་བཀའ་ཐོས་ནས་སྒྲུབ་མཁན་ནི་ངའི་མ་དང་ངའི་སྤུན་རྣམས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ཉིན་ཞིག་ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་གྲུའི་ནང་འཛུལ་ནས་ཁོང་གིས་ཁོ་ཚོར་“ང་ཚོ་མཚོའི་ཕ་རོལ་ལ་འགྲོ་”ཞེས་གསུངས་པས། ཁོང་ཚོ་མཉམ་དུ་ཕེབས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","དེའི་རྗེས་སུ་ཡེ་ཤུ་མནལ་ལ་གཟིམས་ནས་མཚོའི་སྟེང་དུ་རླུང་འཚུབ་ཆེན་པོ་ལངས་ཏེ་རྦ་རླབས་གྲུའི་ནང་ཡོང༌། གྲུ་ཆུས་ཁེངས་གྲབས་བྱས་ཏེ་ནུབ་ཉེན་ཆེན་པོ་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ཁོ་ཚོ་ཁོང་གི་མདུན་དུ་ཡོང་ནས་མནལ་སད་པ་དང་“སློབ་དཔོན་ལགས། སློབ་དཔོན་ལགས། ང་ཚོ་ཤི་གྲབས་བྱེད་ཀྱི་འདུག་”ཅེས་ཟེར། ཁོང་ཡར་བཞེངས་ཏེ་རླུང་དང་རྦ་རླབས་དྲག་པོ་ལ་བཀའ་བཀྱོན་མཛད་པ་དང་རླུང་འཇགས་ནས་མཚོ་ཡོངས་སུ་ཞི་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","དེ་ནས་ཁོང་གིས་ཉེ་གནས་ཚོར་“ཁྱོད་ཚོའི་དད་སེམས་གང་དུ་ཡོད་”ཅེས་གསུངས། ཡ་མཚན་སྐྱེས་ཏེ་ཤིན་ཏུ་འཇིགས་ནས་ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“འདི་སུ་ཡིན་ནམ། རླུང་དང་རྦ་རླབས་ཀྱིས་ཀྱང་ཁོང་གི་བཀའ་ལ་ཉན་པར་བྱེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","དེ་ནས་ཁོང་རྣམས་ག་ལིལ་ཡུལ་ནས་མཚོའི་ཕ་རོལ་གྱི་གེ་ར་སཱ་ཞེས་བྱ་བའི་ཡུལ་དུ་ཕེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ཡེ་ཤུ་གྲུ་ལས་བབས་ཏེ་གྲོང་ཁྱེར་ནས་གདོན་འདྲེ་རྣམས་ཀྱིས་བཟུང་བའི་མི་ཞིག་ཁོང་དང་མཇལ། ཁོ་ནི་ཡུན་རིང་པོར་གྱོན་ཆས་མ་གྱོན་ཞིང་ཁང་པར་མི་སྡོད་པར་དུར་ཁང་གི་ཁྲོད་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ཁོས་ཡེ་ཤུ་མཐོང་སྟེ་ཁོང་ལ་ཕྱག་འཚལ་བ་དང་སྐད་ཆེན་པོས་“བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་སྲས་ཡེ་ཤུ་ལགས། ང་ཁྱེད་དང་འབྲེལ་བ་ཅི་ཡོད། ང་ལ་མནར་གཅོད་གཏོང་བ་མ་གནང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","གང་ལགས་ཤེ་ན། ཡེ་ཤུས་གདོན་འདྲེ་མི་གཙང་བ་མི་དེ་ནས་ཕྱིར་འཐོན་པའི་བཀའ་གནང༌། ཐེངས་མང་པོར་གདོན་འདྲེ་དེས་མི་དེ་བཟུང་སྐབས། མི་རྣམས་ཀྱིས་ཁོ་བསྲུངས་ཤིང་ལྕགས་ཐག་དང་རྐང་སྒྲོག་གིས་བཅིངས་ན་ཡང༌། ཁོས་དེ་ཚོ་བཅད་པ་དང་གདོན་འདྲེས་ཁོ་དབེན་སྟོང་ལ་བསྐྲད། ");
INSERT INTO bod_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ཡང་ཡེ་ཤུས་ཁོ་ལ་“ཁྱོད་ཀྱི་མིང་ལ་ཅི་ཟེར་”ཞེས་དྲིས་ཤིང༌། མི་དེས་“དཔུང་ཚོགས་ཟེར་”ཞེས་སྨྲས། དེ་ནི་གདོན་འདྲེ་མང་པོ་ཁོའི་ནང་ལ་འཛུལ་ཡོད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","དེ་ཚོས་ཁོང་ལ་དམྱལ་བར་འགྲོ་དགོས་པའི་བཀའ་མ་གནང་བའི་ཞུ་བ་ནན་གྱིས་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","དེའི་ཚེ་རིའི་ལོགས་སུ་ཕག་ཁྱུ་ཆེན་པོ་ཞིག་འཚོ་བཞིན་ཡོད་པ་དང༌། གདོན་འདྲེ་དེ་ཚོས་ཡེ་ཤུ་ལ་ཕག་པ་ལ་འཛུལ་བའི་ཆོག་མཆན་ཞུས་ནས་ཁོང་གིས་དེ་ཚོ་ལ་དགོངས་པ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","གདོན་འདྲེ་དེ་ཚོ་མི་དེ་ནས་ཕྱིར་ཐོན་ཏེ་ཕག་པའི་ནང་དུ་འཛུལ་ཤིང༌། ཕག་པ་གཡང་གཟར་དུ་མཆོངས་ཤིང་མཚོའི་ནང་དུ་ནུབ་ནས་ཤིའོ། ");
INSERT INTO bod_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ཕག་རྫི་རྣམས་ཀྱིས་དེ་མཐོང་ནས་བྲོས་ཏེ་གྲོང་ཁྱེར་དང་སྡེ་པའི་མི་རྣམས་ལ་གནས་ཚུལ་དེ་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","མི་རྣམས་ཅི་བྱུང་བར་ལྟ་རུ་ཡོང༌། ཁོ་ཚོ་ཡེ་ཤུའི་དྲུང་དུ་སླེབས་དུས། དེ་སྔོན་གདོན་འདྲེས་བཟུང་བའི་མི་དེ་དྲན་པ་གསོས་ཤིང་གོས་གྱོན་ནས་ཡེ་ཤུའི་ཞབས་ཀྱི་མདུན་ལ་བསྡད་ཡོད་པ་མཐོང་སྟེ་འཇིགས་སྣང་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ཡང་གནས་ཚུལ་འདི་མཐོང་བའི་མི་རྣམས་ཀྱིས་གདོན་འདྲེས་བཟུང་བའི་མི་ཅི་ལྟར་གསོས་པའི་ལོ་རྒྱུས་དེ་དེར་ཡོང་མཁན་རྣམས་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","འཇིགས་སྐྲག་སྐྱེས་པས་གེ་ར་སཱ་དང་དེའི་མཐའ་འཁོར་ལ་ཡོད་པའི་ཡུལ་མི་ཐམས་ཅད་ཀྱིས་ཡེ་ཤུར་ཕར་ཕེབས་པའི་ཞུ་བ་ཕུལ་བས། ཁོང་གྲུའི་ནང་དུ་བཞུགས་ནས་ཕྱིར་ལོག་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","དེ་སྔོན་གདོན་འདྲེས་བཟུང་བའི་མི་དེས་ཁོང་དང་མཉམ་དུ་འགྲོ་བའི་ཞུ་བ་ཕུལ་ཡང༌། ཁོང་གིས་མི་དེ་ཕར་ལ་བཏང་སྟེ་ཁོ་ལ་ ");
INSERT INTO bod_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ཁྱེད་རང་གི་ནང་ལ་སོང་དང༌། ཁྱེད་ཀྱི་དོན་དུ་དཀོན་མཆོག་གིས་གང་མཛད་པ་དེ་ཤོད་ཅིག་”ཅེས་བཀའ་གནང་ནས་ཁོ་ཕར་སོང་བ་དང༌། དོན་དེ་རྣམས་གྲོང་ཁྱེར་ཡོངས་སུ་བསྒྲགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","མི་ཐམས་ཅད་ཀྱིས་ཁོང་བསྒུགས་ཡོད་པས་ཡེ་ཤུ་ལོག་ཕེབས་སྐབས་ཁོང་ལ་དགའ་བསུ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","སྐབས་དེར་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་གི་དཔོན་པོའི་མིང་ལ་ཡ་ཨིར་ཟེར་བ་ཞིག་ཡོང་ནས། ཡེ་ཤུའི་ཞབས་ལ་གཏུག་སྟེ་ཁོའི་ཁང་པར་ཕེབས་པའི་ཞུ་བ་ནན་གྱིས་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","གང་ཡིན་ཞེ་ན། ཁོང་ལ་ལོ་བཅུ་གཉིས་ཙམ་ལོན་པའི་བུ་མོ་གཅིག་པུ་དེ་ཤི་གྲབས་འདུག་པའི་ཕྱིར་ཡིན། ཁོང་ཕེབས་པའི་དུས་སུ་མི་ཚོགས་ཀྱིས་ཁོང་ལ་འཚང་ཁ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","དེའི་ཚེ་བུད་མེད་གཅིག་ལོ་བཅུ་གཉིས་ཀྱི་བར་དུ་ལུས་ནས་ཁྲག་འཛིར་བའི་ནད་ཕོག་སྟེ། སུས་ཀྱང་ཁོ་མོ་ནད་ལས་ཐར་ཐུབ་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ཁོ་མོ་ཡེ་ཤུའི་རྒྱབ་ཏུ་ཡོང་ཞིང་ཁོང་གི་སྟོད་གོས་ཀྱི་མཐའ་འཛར་ལ་རེག་མ་ཐག་ཏུ་ཁྲག་འཛིར་བ་ཆད། ");
INSERT INTO bod_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ཡེ་ཤུས་“སུས་ང་ལ་རེག་པ་ཡིན་ནམ་”ཞེས་གསུངས་པས་ཁོ་ཚོ་ཚང་མས་ཁས་མ་བླངས་པའི་ཚེ་པེ་ཏྲོས་ཁོང་ལ་“སློབ་དཔོན་ལགས། མི་ཚོགས་ཀྱིས་ཁྱེད་མཐའ་བསྐོར་ཞིང་འཚང་ཁ་རྒྱག་བཞིན་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","འོན་ཀྱང་ཡེ་ཤུས་“ང་ནས་ནུས་མཐུ་ཞིག་ཕྱིར་ཐོན་པས་མི་ཞིག་གིས་ང་ལ་རེག་པར་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","བུད་མེད་དེས་དོན་དེ་གསང་མི་ཐུབ་པ་ཤེས་པའི་ཚེ་འཇིགས་ནས་འདར་ཏེ་ཁོང་གི་སྐུ་དྲུང་དུ་པུས་མོ་སར་བཙུགས། ཁོ་མོས་ཁོང་གི་སྟོད་གོས་ལ་རེག་པའི་རྒྱུ་མཚན་དང་འཕྲལ་དུ་དྲག་པའི་ལོ་རྒྱུས་ཁོང་ཚོ་ཚང་མར་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ཁོང་གིས་ཁོ་མོར་“བུ་མོ། ཁྱོད་ཀྱི་དད་པས་ཁྱོད་རང་ནད་ལས་ཐར་བ་ཡིན་པས། བདེ་བའི་ངང་ནས་སོང་དང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ཁོང་གིས་དེ་ལྟར་གསུང་བཞིན་པའི་སྐབས་སུ། ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་གི་དཔོན་པོའི་ཁྱིམ་ནས་མི་འགའ་ཤས་ཡོང་སྟེ། ཁོ་ལ་“ཁྱེད་རང་གི་བུ་མོ་ཤི་ཚར་འདུག་པས་སྟོན་པ་ལ་འོ་བརྒྱལ་ཞུས་ནས་ག་རེ་བྱེད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ཁོ་ཚོའི་སྐད་ཆ་གསན་ནས་ཡེ་ཤུས་མི་དེར་“ཞེད་སྣང་མ་བྱེད། དད་པ་རང་གྱིས་ཤིག ཁོ་མོ་ཐར་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ཁྱིམ་དུ་སླེབས་ནས་ཁོང་གིས་པེ་ཏྲོ་དང༌། ཡ་ཀོབ། ཡོ་ཧ་ནན། བུ་མོའི་ཕ་མ་གཉིས་མ་གཏོགས་གཞན་སུ་ཡང་ཁོང་དང་མཉམ་དུ་འཛུལ་མ་བཅུག ");
INSERT INTO bod_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","བུ་མོ་དེའི་དོན་ལ་མི་ཐམས་ཅད་ངུ་ཞིང་སྨྲེ་སྔགས་འདོན་པས་ཁོང་གིས་“བུ་མོ་འདི་ཤི་མེད་པར་གཉིད་ཁུག་འདུག་པས་མ་ངུ་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","བུ་མོ་ཤི་ཚར་བ་ཤེས་ཏེ་ཁོ་ཚོས་ཁོང་ལ་ཁྲེལ་དགོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","འོན་ཀྱང་ཁོང་གིས་བུ་མོའི་ལག་པ་ནས་འཇུས་ཏེ་“བུ་མོ་ལོངས་ཤིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","དབུགས་ཕྱིར་ལོག་ཅིང་བུ་མོ་དེ་ལམ་སེང་ཡར་ལངས། དེ་ནས་ཁོང་གིས་བུ་མོ་ལ་ཟས་སྟེར་དགོས་ཞེས་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","བུ་མོའི་ཕ་མ་གཉིས་ཡ་མཚན་སྐྱེས། ཡེ་ཤུས་ཁོ་ཚོར་གང་བྱུང་བ་དེ་མི་གཞན་སུ་ལ་ཡང་མི་ཤོད་པའི་བཀའ་གནང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ཉེ་གནས་བཅུ་གཉིས་པོ་རང་གི་དྲུང་དུ་བོས་ནས་ཡེ་ཤུས་གདོན་འདྲེ་ཐམས་ཅད་འདུལ་བ་དང་ནད་ལས་ཐར་བའི་ནུས་མཐུ་དང་དབང་ཁོ་ཚོར་གནང་ནས། ");
INSERT INTO bod_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","དཀོན་མཆོག་གི་རྒྱལ་སྲིད་སྒྲོག་པའི་ཆེད་དང༌། ནད་ལས་ཐར་བའི་ཕྱིར་ཁོ་ཚོ་ཕྱི་རུ་མངགས། ");
INSERT INTO bod_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོ་ལམ་ལ་ཅི་ཡང་མ་ཁྱེར་ཅིག དབྱུག་པ་དང༌། ཁུག་མ། བག་ལེབ། དངུལ། ད་དུང་སྟོད་གོས་ལྷག་མའང་མ་ཁྱེར། ");
INSERT INTO bod_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ཁྱེད་ཚོ་མི་ཁྱིམ་ཞིག་ལ་བསྡད་ནའང་གྲོང་ཚོ་དེ་ནས་ཁ་མ་བྲལ་བར་དུ་དེ་རུ་སྡོད། ");
INSERT INTO bod_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ཡུལ་གང་གི་མིས་ཁྱེད་ཚོར་གནས་ཚང་མི་བཏང་ན། དོན་དེར་འགན་ཁུར་ལེན་དགོས་པར་ཁོ་རྣམས་ལ་བདེན་དཔང་བྱེད་པའི་ཆེད་དུ། ཁྱེད་ཚོ་ས་ཆ་དེ་ནས་ཐོན་པའི་སྐབས་སུ་རྐང་པའི་ཐོག་གི་ས་རྡུལ་སྤྲུགས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ཁོ་ཚོ་སོང་ནས་ཡུལ་ཀུན་གྱི་གྲོང་གསེབ་བརྒྱུད་ནས་ཕྱིན་ཏེ་འཕྲིན་བཟང་བསྒྲགས་པ་དང་ནད་པ་རྣམས་ནད་ལས་ཐར་བར་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","དེའི་དུས་སུ་ས་གནས་དཔོན་པོ་ཧེ་རོ་དཱེ་ཡིས་གང་བྱུང་བ་ཐམས་ཅད་ཐོས་པ་དང༌། མི་ལ་ལས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གཤིན་པོ་ནས་གསོན་པོར་ལང་བ་དང༌། མི་ལ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་མངོན་སུམ་དུ་གྱུར་བ་དང༌། ཡང་མི་གཞན་གྱིས་གནའ་རབས་ཀྱི་ལུང་སྟོན་པའི་ནང་ནས་གཅིག་གསོན་པོར་ལང་བ་ཞེས་ཟེར་བའི་རྐྱེན་གྱིས་ག་བྱེད་འདི་བྱེད་མེད་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ཧེ་རོ་དཱེས་“ངས་བཀའ་བསྒོས་ཏེ་ཡོ་ཧ་ནན་གྱི་མགོ་བོ་བཅད་ནས་བསད། འོན་ཀྱང་དོན་དེ་འདྲ་ཐོས་པའི་མི་དེ་སུ་ཡིན་”ཞེས་ཟེར་བས་ཁོང་དང་མཇལ་ཐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ཡེ་ཤུའི་དྲུང་དུ་འཛོམས་ནས་སྐུ་ཚབ་རྣམས་ཀྱིས་ཇི་བྱས་པ་ཐམས་ཅད་ཁོང་ལ་ཞུས། ཁོ་ཚོ་ཁོ་ན་ཁྲིད་ནས་ཡེ་ཤུ་པེ་སད་དཱ་ཞེས་བྱ་བའི་གྲོང་སྡེ་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","གཏམ་དེ་ཐོས་ནས་མི་ཚོགས་ཁོང་གི་རྗེས་སུ་འབྲངས། ཡེ་ཤུས་ཁོ་ཚོར་དགའ་བསུ་མཛད་ནས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་སྐོར་ལ་གསུངས་པ་དང༌། ནད་ལས་ཐར་དགོས་པ་རྣམས་ནད་ལས་ཐར་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ཉི་མ་ནུབ་ལ་ཉེ་བའི་དུས་སུ། ཉེ་གནས་བཅུ་གཉིས་པོ་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་“ས་ཆ་འདི་དབེན་སྟོང་ཡིན་པས་ཁོ་ཚོ་མཐའ་འཁོར་གྱི་ཡུལ་སྡེ་རྣམས་ལ་རང་རང་གི་ཟས་ཉོ་བ་དང༌། བསྡད་ས་འཚོལ་བའི་ཆེད་དུ་གཏོང་བར་མཛོད་”ཅེས་ཁོང་ལ་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“ཁྱེད་ཚོས་ཁོ་ཚོར་ཟས་སྟེར་ཞིག་”ཅེས་གསུངས། ཁོ་ཚོས་“བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་ལས་མེད་པས་མི་ཚོགས་མང་པོ་འདིར་ཟས་ཉོ་རུ་འགྲོ་བར་བྱའམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","དེ་རུ་སྐྱེས་པ་ལྔ་སྟོང་ཙམ་ཡོད། ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་“མི་ཚོགས་ལྔ་བཅུ་ཙམ་རེ་བྱས་ནས་སྡོད་དུ་འཇུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","དེ་ལྟར་བྱས་ནས་ཐམས་ཅད་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","དེ་ནས་ཡེ་ཤུས་བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་པོ་ཕྱག་ཏུ་བསྣམས་ཏེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་ཡར་གཟིགས་ཤིང་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས། བག་ལེབ་དུམ་བུར་བཅག་ནས་མི་ཚོགས་ལ་བགོ་བའི་ཆེད་དུ་ཉེ་གནས་རྣམས་ལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","མི་ཚང་མས་བཟས་ནས་འགྲངས་ཏེ་ཟས་ལྷག་བསྡུས་པའི་རྗེས་སུ་བག་ལེབ་ཆག་དུམ་གྱིས་སླེ་པོ་བཅུ་གཉིས་ཁེངས། ");
INSERT INTO bod_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","དེ་ནས་ཁོང་གཅིག་པོ་གསོལ་བ་འདེབས་པའི་སྐབས། ཉེ་གནས་ཀྱང་ཁོང་དང་ཉེ་བར་ཡོད་དེ་ཁོང་གིས་“མི་རྣམས་ཀྱིས་ང་རང་སུ་རེད་ཅེས་བཤད་བཞིན་ཡོད་དམ་”ཞེས་གསུངས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ལན་དུ་ཁོ་རྣམས་ཀྱིས་“མི་ལ་ལས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་རེད་ཅེས་དང༌། ལ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་རེད་ཅེས། ཡང་མི་ལ་ལས་གནའ་རབས་ཀྱི་ལུང་སྟོན་པའི་ནང་ནས་གཅིག་སླར་གསོན་པར་གྱུར་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ཁོང་གིས་“འོ་ན་ཁྱེད་ཚོས་བྱས་ན་ང་རང་སུ་ཡིན་ཟེར་”ཞེས་གསུངས་པས་ལན་དུ་པེ་ཏྲོས་“ཁྱེད་ནི་དཀོན་མཆོག་གི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ནོ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ཡེ་ཤུས་ཁོ་རྣམས་ལ་“དོན་འདི་མི་གཞན་ལ་མ་ཤོད་”ཅེས་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ཁོང་གིས་ཉེ་གནས་ཚོར་“མིའི་རིགས་ཀྱི་བུ་ངེས་པར་དུ་སྡུག་བསྔལ་མང་པོ་མྱོང་ཞིང༌། ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒན་པོ་དང་བླ་ཆེན་རྣམས། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མིས་ཁོ་རང་དོར་ནས་གསོད་པར་འགྱུར་ལ། ཡང་ཉི་མ་གསུམ་པར་འཆི་བ་ནས་ཡར་ལང་བར་འགྱུར་དགོས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","དེ་ནས་ཁོང་གིས་ཁོ་ཚོ་ཚང་མར་“གལ་ཏེ་མི་སུ་ཞིག་ང་ཡི་རྗེས་སུ་འབྲང་འདོད་ན། རང་ཉིད་དོར་ནས་རང་གི་རྒྱང་ཤིང་ཉིན་ལྟར་འཁུར་ཏེ་ང་ཡི་རྗེས་སུ་འབྲང་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","གང་ལགས་ཟེར་ན། མི་སུས་ཀྱང་རང་གི་སྲོག་ཐར་བར་བྱེད་འདོད་པ་དེས་བརླག་པར་འགྱུར། མི་སུས་ཀྱང་ང་རང་གི་དོན་དུ་རང་གི་སྲོག་གཏོང་པ་དེས་ཐར་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","སུ་ལ་འཇིག་རྟེན་ཧྲིལ་པོ་ཐོབ་ཀྱང་རང་སྲོག་ཤོར་བའམ་བརླགས་ན་ཅི་ཕན། ");
INSERT INTO bod_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","མི་སུ་ཞིག་གིས་ང་དང་ངའི་བཀའ་ངོ་ཚ་བའི་རྒྱུར་བརྩིས་ན། མིའི་རིགས་ཀྱི་བུས་ཀྱང་རང་ཉིད་དང༌། ཡབ་དཀོན་མཆོག་དང་དམ་པའི་ཕོ་ཉ་རྣམས་ཀྱི་གཟི་བརྗིད་དང་བཅས་འཇིག་རྟེན་དུ་ཕེབས་སྐབས། མི་དེ་ཡང་ངོ་ཚ་བའི་རྒྱུར་བརྩི་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། འདི་རུ་ཡོད་པའི་མི་རྣམས་ཀྱི་ནང་ནས་འགའ་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་མ་མཐོང་བའི་བར་དུ་ཅི་ནས་ཀྱང་འཆི་བ་མྱོང་བར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","གསུང་འདི་ཚོ་བརྗོད་ནས་ཉི་མ་བརྒྱད་ཙམ་གྱི་རྗེས་ལ་ཡེ་ཤུས་པེ་ཏྲོ་དང་ཡ་ཀོབ་ཡོ་ཧ་ནན་གསུམ་ཁྲིད་ནས་རི་ཞིག་ལ་གསོལ་བ་འདེབས་པའི་ཆེད་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","གསོལ་བ་འདེབས་དུས་ཁོང་གི་ཞལ་གྱི་རྣམ་པ་གྱུར་ཞིང༌། ཁོང་གི་ན་བཟའ་འོད་འཕྲོ་བའི་ཚོན་མདོག་ཧ་ཅང་དཀར་པོ་ཞིག་ཏུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","གློ་བུར་དུ་ལུང་སྟོན་པ་མོ་ཤེ་དང་ཨེ་ལི་ཡཱ་གཉིས་མངོན་སུམ་དུ་གཟི་བརྗིད་དང་ལྡན་པར་གྱུར་ནས་ཡེ་ཤུ་དང་བཀའ་མོལ་གནང༌། ཁོང་ཚོས་ཡེ་ཤུ་སྐུ་ཚེ་ལས་འདའ་བའི་དོན་དེ་ནི་ཡེ་རུ་ཤ་ལེམ་ལ་བསྒྲུབ་རྒྱུ་ཡིན་པའི་སྐོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","པེ་ཏྲོ་དང་ཁོའི་གྲོགས་པོ་གཉིས་གཉིད་ལྗིད་པོ་ཞིག་ཁུག་ནས་གཉིད་སད་སྐབས་ཁོང་གི་གཟི་བརྗིད་དང༌། ཁོང་དང་མཉམ་དུ་བཞེངས་པའི་མི་གཉིས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་དང་མོ་ཤེ་གཉིས་ཁོང་དང་བྲལ་སྐབས། ཇི་ལྟར་ཞུ་དགོས་མིན་མ་ཤེས་ཏེ་པེ་ཏྲོས་ཡེ་ཤུ་ལ་“སློབ་དཔོན་ལགས། ང་ཚོ་འདིར་བསྡད་ན་ལེགས། ང་ཚོས་བཞུགས་ས་གསུམ་བཟོ་བར་བྱ། ཁྱེད་ལ་གཅིག་དང་མོ་ཤེ་ལ་གཅིག ཨེ་ལི་ཡཱ་ལ་གཅིག་བཅས་ཡིན་”ཞེས་ཞུས་པའི་དུས་སུ། ");
INSERT INTO bod_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","སྤྲིན་པ་ཞིག་ཡོང་ནས་ཁོང་ཚོ་བསྒྲིབས། དེའི་ནང་དུ་སོང་སྐབས་ཁོ་ཚོ་འཇིགས་ཤིང་སྐྲག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","སྤྲིན་པ་ནས་གསུང་ཞིག་བྱུང་སྟེ་“འདི་ནི་ངའི་སྲས་དང་ངས་བདམས་པ་ཡིན་ནོ། ཁོང་ལ་ཉོན་ཅིག་”ཅེས་གསུངས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ཡེ་ཤུ་གཅིག་པོར་གནས། ཡང་དེའི་དུས་སྐབས་སུ་ཉེ་གནས་རྣམས་ཀྱིས་གང་མཐོང་བའི་གཏམ་མི་གླེང་ལ་མི་གཞན་ལ་ཡང་ཅི་ཡང་མ་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","དེའི་སང་ཉིན་ཁོང་ཚོ་རི་ནས་བབས་པའི་རྗེས་སུ་མི་ཚོགས་མང་པོ་ཞིག་ཁོང་དང་མཇལ། ");
INSERT INTO bod_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","མི་ཚོགས་ལས་གཅིག་གིས་“སློབ་དཔོན་ལགས། ངའི་ཕྲུ་གུ་གཅིག་པོ་ཡིན་པའི་བུ་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","གདོན་འདྲེས་ག་དུས་འཛིན་ནའང༌། ཁོ་གློ་བུར་དུ་སྐད་ངན་ཆེན་པོ་ཤོར་ནས་ས་ལ་འགྱེལ་ཞིང་ཁ་ནས་ལྦུ་བ་འཐོན་ཅིང༌། སོ་ཁྲིག་ཁྲིག་བྱེད། ལུས་པོའང་རེངས་པོར་འགྱུར། གདོན་འདྲེ་འཐོན་པར་དཀའ་ཞིང་དེས་ཁོ་ལ་གནོད་འཚེ་ཆེན་པོ་གཏོང་བཞིན་འདུག ");
INSERT INTO bod_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ངས་ཁྱེད་ཀྱི་ཉེ་གནས་རྣམས་ལ་གདོན་འདྲེ་དེ་ཕྱིར་སྐྲོད་པར་ཞུས་ཀྱང་ཁོང་ཚོས་བསྐྲད་མ་ཐུབ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","དེ་ནས་ཡེ་ཤུས་“ངན་སེམས་ཅན་དང་དད་པ་མི་བྱེད་པའི་མི་རབས་ཁྱོད་ཚོ། ང་རང་ཁྱོད་ཚོ་དང་མཉམ་དུ་དུས་ནམ་ཞིག་གི་བར་དུ་བསྡད་ནས་བཟོད་པར་བྱེད་དགོས་སམ། བུ་དེ་ངའི་མདུན་དུ་ཁྲིད་ཤོག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","བུ་དེ་ཁོང་གི་མདུན་ལ་ཡོང་དུས་གདོན་འདྲེ་མི་གཙང་བ་དེས་ཁོ་ས་ལ་བརྡབས་ནས་དྲག་པོར་སྤྲུགས། འོན་ཀྱང་ཡེ་ཤུས་གདོན་འདྲེ་དེར་བཀའ་བཀྱོན་གནང་སྟེ་བུ་གསོས་པར་མཛད་ནས་ཁོའི་ཕ་ལ་གནང་བས། ");
INSERT INTO bod_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","མི་ཐམས་ཅད་དཀོན་མཆོག་གི་གཟི་བརྗིད་ལ་ཡ་མཚན་སྐྱེས། ཁོང་གིས་མཛད་པའི་དོན་ལ་མི་ཚང་མ་ངོ་མཚར་སྐྱེ་བའི་དུས་སུ་ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་ ");
INSERT INTO bod_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“གཏམ་འདི་སེམས་ལ་ཟུངས་ཤིག མིའི་རིགས་ཀྱི་བུ་ནི་མི་རྣམས་ཀྱི་ལག་ཏུ་གཏོད་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ཉེ་གནས་རྣམས་ཀྱིས་གསུང་དེའི་དོན་ཧ་མ་གོ ཁོ་ཚོ་མི་རྟོགས་པའི་ཕྱིར་དེའི་དོན་ཁོ་རྣམས་ལ་སྦས་པར་གྱུར་ཞིང་འཇིགས་ནས་ཁོང་ལ་དེའི་སྐོར་བཀའ་འདྲི་ཞུ་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ཁོ་ཚོའི་ནང་ནས་སུ་མཆོག་ཏུ་ཡིན་པའི་རྩོད་གླེང་ཞིག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་ཡེ་ཤུས་ཕྲུ་གུ་ཆུང་ངུ་ཞིག་ཁྲིད་ཡོང་སྟེ་རང་གི་རྩར་ལང་དུ་བཅུག་ནས་ ");
INSERT INTO bod_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ཁོ་ཚོར་“སུས་ཀྱང་ཕྲུ་གུ་འདི་ངའི་མིང་གི་ཐོག་ནས་དྲངས་ན་དེས་ང་རང་འདྲེན། སུས་ཀྱང་ང་འདྲེན་པ་དེས་ང་མངགས་མཁན་དེ་སྤྱན་འདྲེན། རྒྱུ་མཚན་ནི་ཁྱོད་ཚོའི་ནང་ནས་དམའ་ཤོས་ཡིན་པ་དེ་མཆོག་ཏུ་འགྱུར་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ལན་དུ་ཡོ་ཧ་ནན་གྱིས་ཁོང་ལ་“སྟོན་པ་ལགས། ང་ཚོས་མི་གཞན་ཞིག་གིས་ཁྱེད་ཀྱི་མཚན་ཐོག་ནས་གདོན་འདྲེ་སྐྲོད་པ་མཐོང་བྱུང༌། མི་དེ་ང་ཚོའི་ཁོངས་གཏོགས་མིན་པས་དོན་དེ་ལྟར་སྒྲུབ་པ་བཀག་ཐབས་བཙལ་བ་ཡིན་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ཡེ་ཤུས་“སུས་ཀྱང་ཁྱེད་ལ་དགྲ་མི་བྱེད་པ་དེས་ཁྱེད་ཀྱི་ཕྱོགས་བྱེད་པས་ཁོ་འགོག་པར་མ་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་འཕག་པའི་དུས་ཉེ་བར་སླེབས་པས་ཁོང་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་རྒྱུའི་འདུན་པ་བརྟན་པོར་བཅངས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ཁོང་གི་སྔོན་དུ་བང་ཆེན་མངགས་པ་དང༌། ཁོ་ཚོ་ཁོང་གི་དོན་ལ་གྲ་སྒྲིག་བྱེད་པའི་ཕྱིར་ས་མར་ཡཱ་ཡུལ་གྱི་གྲོང་གསེབ་ཅིག་ཏུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ཁོང་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་པར་ཤེས་ཏེ་ས་མར་ཡཱ་པས་ཁོང་ལ་བསུ་བ་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","དོན་དེ་མཐོང་ནས་ཉེ་གནས་ཡོ་ཧ་ནན་དང་ཡ་ཀོབ་ཀྱིས་“གཙོ་བོ། མི་དེ་ཚོ་མེད་པར་བྱེད་པའི་ཕྱིར་ང་ཚོས་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་མེ་འབབ་པའི་བཀོད་པ་གཏོང་བར་ཁྱེད་ཐུགས་མཉེས་སམ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","འོན་ཀྱང་ཁོང་ཞལ་ཕྱིར་བསྐོར་ཏེ་ཁོ་ཚོར་བཀའ་བཀྱོན་མཛད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ཁོང་ཚོ་གྲོང་གསེབ་གཞན་ཞིག་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ལམ་བར་དུ་མི་ཞིག་གིས་ཁོང་ལ་“ཁྱེད་གང་དུ་ཕེབས་ན་ཡང་ང་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲང་བར་བྱ་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ཁོང་གིས་ཁོ་ལ་“ཝ་ལ་ཝ་ཚང་དང༌། བྱ་ལ་བྱ་ཚང་ཡོད་ཀྱང༌། མིའི་རིགས་ཀྱི་བུ་ལ་མགོ་བཞག་ས་ཙམ་ཡང་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ཡང་ཁོང་གིས་མི་གཞན་ལ་“ངའི་རྗེས་སུ་འབྲོངས་ཤིག་”ཅེས་གསུངས་པས་ལན་དུ་ཁོས་“གཙོ་བོ། སྔོན་ལ་ང་སོང་ནས་ཕ་དུར་དུ་འཇུག་པའི་དགོངས་པ་གནང་རོགས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","འོན་ཀྱང་ཁོང་གིས་མི་དེར་“གཤིན་པོ་དང་འདྲ་བ་རྣམས་ཀྱིས་རང་གི་གཤིན་པོ་རྣམས་དུར་དུ་འཇུག་ཆོག ཁྱོད་སོང་ནས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱབ་བསྒྲགས་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ད་དུང་མི་གཞན་གྱིས་“གཙོ་བོ། ཁྱེད་ཀྱི་རྗེས་སུ་འབྲང་བར་བྱ། འོན་ཀྱང་དེའི་སྔོན་དུ་ནང་མི་རྣམས་ལ་གྱེས་མཚམས་ཞུ་བའི་དགོངས་པ་གནང་རོགས་”ཞེས་ཟེར་བ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ཡེ་ཤུས་མི་དེར་“སུས་ཀྱང་ཐོང་གཤོལ་བཟུང་སྟེ་ཕྱི་བལྟས་སློག་ན་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་མི་འོས་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","དེ་ནས་གཙོ་བོས་མི་གཞན་བདུན་ཅུ་བསྐོས་ཏེ་ཁོང་ཕེབས་རྒྱུ་ཡིན་པའི་གྲོང་ཁྱེར་དང་ས་ཆ་རེ་རེར་མི་གཉིས་རེ་མངགས། ");
INSERT INTO bod_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ཡང་ཁོང་གིས་ཁོ་ཚོར་“སྟོན་ཐོག་རྔ་རྒྱུ་མང་པོ་ཡོད་ཀྱང་ལས་ཀ་བྱེད་མཁན་ཉུང་ངུ་ཡོད། དེའི་ཕྱིར་ལོ་ཏོག་གི་བདག་པོར་སྟོན་ཐོག་སྡུད་མཁན་རྣམས་རང་གི་ས་ཞིང་ལ་མངག་པར་ཞུས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","སོང་ལ། ངས་སྤྱང་ཀིའི་ཁྲོད་དུ་ལུ་གུ་ལྟར་ཁྱེད་ཚོ་མངག ");
INSERT INTO bod_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ཁྱེད་ཚོ་ཁུག་མ་དང༌། ལྷམ་གྱོན། སྐེ་རགས་ནང་ལའང་དངུལ་ཅི་ཡང་མ་ཁྱེར་ཞིང༌། ལམ་བར་དུ་མི་སུ་ལ་ཡང་འཚམས་འདྲི་མ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ཁྱིམ་ཚང་གང་ཞིག་ལ་འཛུལ་ནའང་ཐོག་མར་ཁྱིམ་ཚང་འདི་ལ་ཞི་བདེ་འབབ་པར་ཤོག་ཅེས་ཤོད། ");
INSERT INTO bod_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","གལ་སྲིད་ཞི་བདེ་དང་ལྡན་པའི་སྐྱེས་པ་ཞིག་ཁྱིམ་ཚང་དེར་བཞུགས་ན་ཁྱེད་ཀྱི་ཞི་བདེ་ཁོང་ལ་གནས་པར་འགྱུར། འོན་ཀྱང་མེད་ན་ཞི་བདེ་ཁྱེད་ལ་ཕྱིར་ལོག་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ཁོ་ཚོས་ཁྱེད་ལ་གང་སྟེར་བ་དེ་བཟའ་བཏུང་བྱེད་པར་ཁྱིམ་ཚང་དེ་རང་ལ་སྡོད། གང་ཡིན་ཞེ་ན། ལས་བྱེད་མཁན་ལ་གླ་ཆ་ཐོབ་པར་འོས་སོ། ཁང་པ་གཅིག་ནས་གཞན་པར་མ་སྤོས། ");
INSERT INTO bod_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ཁྱེད་ཚོ་གྲོང་ཁྱེར་གང་ཞིག་ལ་ཞུགས་ནས་གནས་ཚང་བཏང་ན་ཁྱེད་ཚོར་གང་བཤམས་པ་དེ་ཟོ་ཞིག ");
INSERT INTO bod_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","དེར་ཡོད་པའི་ནད་པ་རྣམས་ནད་ལས་ཐར་བར་བྱེད་དེ་ཁོ་ཚོར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱེད་དང་ཉེ་བར་སླེབས་ཞེས་ཤོད། ");
INSERT INTO bod_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ཁྱེད་ཚོ་གྲོང་ཁྱེར་གང་ཞིག་ལ་ཞུགས་ནས་གནས་ཚང་མི་བཏང་ན་ལམ་ལ་སོང་ནས། ");
INSERT INTO bod_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ཁྱོད་ཚོ་དོན་འདི་ལ་འགན་ཁུར་དགོས་པར་སྟོན་པའི་ཕྱིར་ངེད་ཀྱི་རྐང་པ་ལ་ཁྱོད་ཚོའི་གྲོང་ཁྱེར་གྱི་ས་རྡུལ་འབྱར་བ་ཡང་ང་ཚོས་འཕྱི། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱེད་དང་ཉེ་བར་སླེབ་པ་ཤེས་པར་གྱིས་ཤིག་ཅེས་སྨྲོས། ");
INSERT INTO bod_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ཁྲིམས་གཅོད་པའི་ཉིན་མོ་དེར་གྲོང་ཁྱེར་འདིའི་ཉེས་ཆད་སཱ་དོམ་གྲོང་ཁྱེར་ལས་ལྗིད་བ་འཕོག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","གལ་ཏེ་གྲོང་ཁྱེར་ཐཱ་ཨེར་དང་ཚི་དོན་ལ་བྱུང་བའི་ངོ་མཚར་ཅན་གྱི་རྟགས་ཁྱོད་ཚོར་བྱུང་ཡོད་ན། མི་དེ་ཚོ་སེམས་བསྒྱུར་བའི་རྟགས་སུ་རྩྭ་རས་གྱོན་པ་དང་གོ་ཐལ་ཁྲོད་ལ་བསྡད་དེ་ཡུན་རིང་ནས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བ་ཡིན་པས། ཀྱེ་ཀོ་ར་ཟིན་དང་པེ་སད་དཱ་པ་རྣམས། ཁྱོད་ཚོར་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","འོན་ཀྱང་ཁྲིམས་གཅོད་བྱེད་པའི་ཉིན་མོར་ཁྱོད་རྣམས་ལས་ཐཱ་ཨེར་དང་ཚི་དོན་གཉིས་ལ་བཟོད་པར་སླ་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ཀྱེ་ཀ་ཕར་ན་ཧུམ་པ་རྣམས། ཁྱོད་ཞིང་ཁམས་སུ་འཕག་པར་འགྱུར་བ་ཡིན་ནམ། མ་ཡིན། ཁྱོད་དམྱལ་བའི་གཏིང་སར་འཕེན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ཁྱོད་རྣམས་ལ་ཉན་པ་དེས་ང་ལའང་ཉན། ཁྱོད་རྣམས་འདོར་བ་དེས་ང་ཡང་འདོར། ང་འདོར་མཁན་གྱིས་ང་མངག་མཁན་ཡང་འདོར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","བདུན་ཅུ་དེ་རྣམས་ཀྱིས་“གཙོ་བོ། ཁྱེད་ཀྱི་མཚན་ཐོག་ནས་གདོན་འདྲེས་ཀྱང་ང་ཚོའི་ཁ་ལ་ཉན་”ཞེས་སྨྲས་ཏེ་དགའ་བའི་ངང་ནས་ཕྱིར་ལོག་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ཁོང་གིས་ཁོ་ཚོར་“ངས་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བདུད་སཱ་ཏན་གློག་འཁྱུག་པ་ལྟར་བབས་པར་བལྟས། ");
INSERT INTO bod_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ལྟོས་ཤིག ངས་ཁྱེད་ཚོར་སྦྲུལ་དང་སྡིག་པ་རྭ་ཉག་བརྫི་རྒྱུ་དང༌། དགྲའི་མཐུ་ཐམས་ཅད་འཇོམས་པའི་དབང་ཆ་སྟེར་བ་ཡིན་པས། ཁྱེད་རྣམས་ལ་གནོད་འཚེ་ཅིའང་བྱེད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","འོན་ཀྱང་གདོན་འདྲེས་ཁྱེད་ཚོའི་བཀའ་ལ་ཉན་པར་མ་དགའ། ཁྱེད་ཚོའི་མིང་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཀོད་པ་ཡིན་པས་དགའ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","དུས་དེར་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཐོག་ནས་ཤིན་ཏུ་དགྱེས་པས་ཁོང་གིས་“ཀྱེ། ཡབ་འཇིག་རྟེན་ཁམས་ཀྱི་བདག་པོ་ལགས། ཁྱེད་ཀྱིས་དོན་འདི་རྣམས་ཤེས་ཡོན་དང་ལྡན་པ་རྣམས་ལ་སྦས་པ་གནང་ནས་ཕྲུ་གུ་རྣམས་ལ་མངོན་པར་མཛད་པས་ཁྱེད་ལ་བསྟོད་པ་འབུལ་ལོ། ཡབ་ལགས། དེ་ནི་ཁྱེད་ཀྱི་ཐུགས་རྗེ་དང་ལྡན་པའི་དགོངས་པ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ངའི་ཡབ་ཀྱིས་ང་ལ་ཡོད་དོ་ཅོག་གཏད་བྱུང༌། ཡབ་མ་གཏོགས་པར་སྲས་སུ་ཡིན་པ་སུས་ཀྱང་མི་ཤེས། སྲས་དང༌། སྲས་ཀྱིས་སྟོན་པར་འདོད་པའི་མི་མ་གཏོགས་པར། ཡབ་སུ་ཡིན་པ་སུས་ཀྱང་མི་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ཉེ་གནས་རྣམས་ལ་ཞལ་ཕྱིར་བསྐོར་ཏེ་ཟུར་དུ་ཁོང་གིས་“ཁྱེད་ཀྱིས་གང་མཐོང་བའི་དོན་དེ་མཐོང་མཁན་རྣམས་བདེའོ། ");
INSERT INTO bod_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཁྱེད་ཀྱིས་གང་མཐོང་བ་དང་ཐོས་པ་ནི་ལུང་སྟོན་པ་དང་རྒྱལ་པོ་མང་པོས་དེ་མཐོང་བ་དང་ཐོས་པ་འདོད་ཀྱང་མ་མྱོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","དེ་ནས་ཁོང་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཞིག་ཡར་ལངས་ཏེ་ཁོང་ལ་“སློབ་དཔོན་ལགས། དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་ཕྱིར་ངས་གང་ཞིག་བྱ་དགོས་སམ་”ཞེས་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ཁོང་གིས་མི་དེ་ལ་“ཆོས་ཁྲིམས་ནང་ལ་ཅི་ཞིག་འཁོད་འདུག ཁྱེད་ཀྱིས་ཇི་ལྟར་ཀློག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ལན་དུ་ཁོས་“ཆོས་ཁྲིམས་ནང་ལ་རང་གིས་གཙོ་བོ་དཀོན་མཆོག་ལ་བློ་གཅིག་སེམས་གཅིག་དང་ནུས་པ་ཅི་ཡོད་ཀྱིས་བརྩེ་བར་ཟུངས་ཤིག ཁྱེད་རང་གིས་ཁྱིམ་མཚེས་ལ་རང་དང་འདྲ་བར་བརྩེ་བར་ཟུངས་ཤིག་ཅེས་འཁོད་འདུག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ཡེ་ཤུས་“ཁྱེད་ཀྱིས་བཤད་པ་དེ་བདེན། དེ་ལྟར་བྱས་ན་འཚོ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","འོན་ཀྱང་རང་ལ་རྒྱུ་མཚན་ཡོད་པ་གསལ་པོར་སྟོན་ཕྱིར་མི་དེས་ཡེ་ཤུ་ལ་“འོ་ན་ངའི་ཁྱིམ་མཚེས་སུ་ཡིན་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ལན་དུ་ཡེ་ཤུས་“མི་ཞིག་ཡེ་རུ་ཤ་ལེམ་ནས་ཡེ་རུ་ཀོ་གྲོང་ཁྱེར་དུ་མར་འགྲོ་དུས་ཇག་པས་བཟུང་ནས་གོས་ཕྲོགས་པ་དང༌། ཁོ་མ་ཤི་ཙམ་དུ་བརྡུངས་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","དེ་དུས་ཡ་ཧུ་དཱ་པའི་བླ་མ་ཞིག་ལམ་དེ་བརྒྱུད་ནས་ཡོང་བ་དང་སྐབས་འཁེལ་བས་མི་དེ་མཐོང་སྟེ་ཕར་ཕྱོགས་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","དེ་བཞིན་དུ་ལེ་ཝི་པ་ཟེར་བའི་མཆོད་གཡོག་ཅིག་ཡོང་ནས་མི་དེ་མཐོང་སྟེ་ཡང་ཕར་ཕྱོགས་ནས་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","འོན་ཀྱང་ས་མར་ཡཱ་པའི་འགྲུལ་པ་ཞིག་ཡོང་ནས་མི་དེ་མཐོང་སྟེ་སྙིང་རྗེ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ཁོའི་ཕྱོགས་སུ་སོང་ནས་རྨ་ལ་སྣུམ་དང་རྒུན་ཆང་བླུགས་ཏེ་རས་ཀྱིས་བཏུམས་པ་དང༌། རང་གི་ཁལ་མར་བསྐྱོན་ཏེ་མགྲོན་ཁང་ཞིག་ལ་བསྐྱལ་ནས་བྱམས་སྐྱོང་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","དེའི་སང་ཉིན་ཁོས་དེ་ཎ་རིའི་དངུལ་ཊམ་ཀ་གཉིས་མགྲོན་ཁང་གི་བདག་པོ་ལ་སྟེར་ནས་ཁོ་ལ་བདག་སྐྱོང་བྱེད་དང༌། དེ་ལས་ལྷག་པ་བཏང་ན་ལོག་སྐབས་སུ་ངས་ཁྱེད་ལ་སྐྱིན་པ་འཇལ་རྒྱུ་ཡིན་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ཁྱེད་ཀྱི་བསམ་པར་འདི་ཚོ་གསུམ་གྱི་ནང་ནས་ཇག་པས་བཟུང་བའི་མི་ཁོའི་ཁྱིམ་མཚེས་སུ་ཡིན་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དེས་“ཁོ་ལ་སྙིང་རྗེ་བྱེད་མཁན་དེ་ཡིན་”ཞེས་ཟེར་བས། ཡེ་ཤུས་“སོང་ལ་དེ་ལྟར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ལམ་ལ་ཕེབས་དུས་ཡེ་ཤུ་དང་ཉེ་གནས་གྲོང་གསེབ་ཅིག་ལ་ཞུགས་ནས་མར་ཐཱ་ཞེས་བྱ་བའི་བུད་མེད་ཀྱིས་ཁོ་མོའི་ནང་ལ་ཁོང་ཚོར་སྣེ་ལེན་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ཁོ་མོའི་ནུ་མོ་མིར་ཡམ་ནི་གཙོ་བོའི་ཞབས་ཀྱི་མདུན་དུ་བསྡད་དེ་ཁོང་གི་གསུང་ལ་ཉན། ");
INSERT INTO bod_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","སྣེ་ལེན་གྱི་ལས་མང་བས་མར་ཐཱ་ཡིས་སེམས་འཚབ་སྟེ་ཁོང་གི་མདུན་དུ་ཡོང་བ་དང་“གཙོ་བོ། ངའི་ནུ་མོས་ང་གཅིག་པོ་སྣེ་ལེན་བྱེད་དུ་འཇུག་པ་ཁྱེད་ཀྱིས་ཐུགས་སྣང་མི་མཛད་དམ། ང་ལ་རོགས་རམ་བྱེད་དགོས་པའི་བཀའ་ཁོ་མོར་གནང་དང་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","འོན་ཀྱང་ལན་དུ་གཙོ་བོས་“མར་ཐཱ། མར་ཐཱ། ཁྱེད་ཀྱིས་དོན་མང་པོའི་ཆེད་དུ་སེམས་ཁྲལ་དང་སེམས་འཁྲུག་པར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","འོན་ཀྱང་དོན་གལ་ཆེ་བ་ནི་གཅིག་རང་ཡིན། མིར་ཡམ་གྱིས་སྐལ་བ་བཟང་པོ་བདམས་པས་ཁོ་མོའི་ས་ནས་ལེན་པར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ཡེ་ཤུས་ས་ཆ་ཞིག་ལ་གསོལ་བ་བཏབ་པ་དང༌། དེ་ཚར་རྗེས་ཉེ་གནས་ཤིག་གིས་ཁོང་ལ་“གཙོ་བོ། ཡོ་ཧ་ནན་གྱིས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་སྨོན་ལམ་འདེབས་པར་བསླབས་པ་ལྟར། ང་ཚོ་ལའང་སྨོན་ལམ་འདེབས་པར་སློབས་དང་”ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོས་སྨོན་ལམ་འདེབས་སྐབས་འདི་ལྟར་ཤོད། ཡབ་ལགས། ཁྱེད་མཚན་དམ་པར་སྲུང་བར་ཤོག ། ཁྱེད་ཀྱི་རྒྱལ་སྲིད་འོང་བར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ངེད་ཀྱི་ཉིན་རེའི་ཁ་ཟས་དེ། ། ཁྱེད་ཀྱིས་ང་ཚོར་གནང་བར་མཛོད། ། ");
INSERT INTO bod_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ངེད་ཚོས་གཞན་གྱི་སྡིག་ཉེས་རྣམས། ། གུ་ཡངས་གཏོང་བ་ཇི་བཞིན་དུ། ། ངེད་ཀྱི་སྡིག་བུན་སེལ་བར་མཛོད། ། ཉམས་ཚོད་ནང་དུ་འཇུག་མ་མཛོད། །” ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ཁོང་གིས་ཁོ་ཚོར་“དཔེར་ན་ཁྱེད་ཚོའི་ནང་ནས་གཅིག་ལ་གྲོགས་པོ་ཡོད་ན། ནམ་ཕྱེད་ལ་ཁོའི་རྩར་ཕྱིན་ནས་ཁོ་ལ་གྲོགས་པོ། བག་ལེབ་གསུམ་ང་ལ་གཡར་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","གང་ལགས་ཟེར་ན། ཐག་རིང་ནས་ངའི་གྲོགས་པོ་ཞིག་སླེབས་པ་དང༌། ཁོ་ལ་སྟེར་བའི་ཟས་གང་ཡང་མེད་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ལན་དུ་ནང་ལ་ཡོད་པའི་མི་དེས་ང་ལ་སུན་པོ་མ་བཟོས། སྒོ་བརྒྱབ་ཚར་ཏེ་ངའི་ཕྲུ་གུ་ང་དང་མཉམ་དུ་ཉལ་ཡོད་པས་ཁྱོད་ལ་གང་ཞིག་སྟེར་བའི་ཕྱིར་ཡར་ལང་མི་ཐུབ་ཅེས་ཟེར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ཡེ་ཤུས་“ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ནང་ལ་ཡོད་པའི་མི་དེ་གྲོགས་པོ་ཡིན་པས་ལངས་ནས་མི་སྟེར་ན་ཡང༌། ཕྱི་ལོགས་ཀྱི་མིས་ཡང་ཡང་ཞུ་བའི་རྐྱེན་གྱིས་ཡར་ལངས་ནས་གང་ཙམ་དགོས་པ་ཁོ་ལ་སྟེར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","དེའི་ཕྱིར་ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར་ཞུས་ན་གནང་བར་འགྱུར། བཙལ་ན་རྙེད་པར་འགྱུར། སྒོ་བརྡུངས་ན་འབྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","གང་ལགས་ཟེར་ན། ཞུ་མཁན་ཐམས་ཅད་ལ་འཐོབ་པ་དང༌། འཚོལ་མཁན་ཐམས་ཅད་ལ་རྙེད། སྒོ་རྡུང་མཁན་ཐམས་ཅད་ལ་སྒོ་འབྱེད་པར་འགྱུར་བས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","དཔེར་ན་ཁྱེད་ཚོ་ལས་སུ་ཞིག་ཕ་ཡིན་པ་དེས་བུ་ཉ་ཤ་དགོས་ཞེས་ཞུས་ན་སྦྲུལ་སྟེར་བར་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ཡང་ན་བུ་ཡིས་སྒོ་ང་དགོས་ཞེས་ཞུས་ན་སྡིག་པ་རྭ་ཉག་ཅིག་སྟེར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ཁྱོད་ཚོ་ངན་པ་ཡིན་ཡང་ཁྱོད་ཀྱི་ཕྲུ་གུ་རྣམས་ལ་ལག་རྟགས་བཟང་པོ་སྤྲོད་པར་ཤེས་ན། ཁྱེད་ཀྱི་ཡབ་ཞིང་ཁམས་སུ་བཞུགས་པ་ཡིས་ཁོང་ལ་གསོལ་འདེབས་བྱེད་མཁན་རྣམས་ལ་དམ་པའི་ཐུགས་ཉིད་དེ་བས་ཀྱང་གནང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","དེའི་རྗེས་སུ་ཁོང་གིས་གདོན་འདྲེ་ཁ་མི་གྲགས་པ་ཞིག་བསྐྲད། དེ་ཐོན་ཚར་ནས་ཁ་ལྐུགས་པས་སྐད་ཆ་བཤད་པ་དང༌། མི་ཚོགས་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","འོན་ཀྱང་མི་དེ་ཚོའི་ནང་ནས་ལ་ལས་“བདུད་ཀྱི་རྒྱལ་པོ་པེ་ཨིལ་བཟི་པད་ལ་བརྟེན་ནས་ཁོས་གདོན་འདྲེ་སྐྲོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ཁོང་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་གཞན་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ངོ་མཚར་བའི་རྟགས་སྟོན་ཞུ་བ་ཡང་ཡང་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ཁོ་ཚོའི་བསམ་པ་མཁྱེན་ནས་ཁོང་གིས་ཁོ་ཚོར་“རྒྱལ་ཁམས་ཤིག་གི་ནང་ལ་ནང་འཁྲུག་བྱུང་ན་འཇིག་པར་འགྱུར་ལ། ཁྱིམ་ཚང་ནང་ལའང་ནང་འཁྲུག་བྱུང་ན་ཉམས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","དེ་བཞིན་དུ་བདུད་སཱ་ཏན་གྱིས་རང་ལ་ནང་འཁྲུག་བསླངས་ན། ཁོའི་རྒྱལ་ཁམས་ཅི་ལྟར་གནས། དེ་ནི་ཁྱོད་ཚོས་ངས་བདུད་ཀྱི་རྒྱལ་པོ་པེ་ཨིལ་བཟི་པད་ལ་བརྟེན་ནས་གདོན་འདྲེ་སྐྲོད་ཅེས་སྨྲ་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","གལ་ཏེ་པེ་ཨིལ་བཟི་པད་ལ་བརྟེན་ནས་ངས་གདོན་འདྲེ་བསྐྲད་ན། ཁྱོད་རྣམས་ཀྱི་བུ་ཡིས་སུ་ལ་བརྟེན་ནས་གདོན་འདྲེ་སྐྲོད་དམ། དེའི་ཕྱིར་ཁོ་ཚོ་ནི་ཁྱོད་ཚོའི་ཁྲིམས་དཔོན་དུ་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","འོན་ཀྱང་ངས་དཀོན་མཆོག་གི་ཕྱག་མཛུབ་ལ་བརྟེན་ནས་གདོན་འདྲེ་བསྐྲད་ན། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱོད་ཚོའི་རྩར་སླེབས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","མཚོན་ཆ་འཁྱེར་བའི་མི་སྟོབས་ཤུགས་ཆེན་པོ་ཞིག་གིས་རང་གི་ཁང་པ་བསྲུངས་ན། ཁོའི་ཅ་ལག་འཕྲོག་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","འོན་ཀྱང་ཁོ་ལས་སྟོབས་ཤུགས་ཆེ་བ་ཞིག་ཡོང་ནས་མི་སྟོབས་ཤུགས་ཅན་བཅོམ་ན། ཁོས་བརྟེན་པར་བྱས་པའི་མཚོན་ཆ་ཕྲོགས་ནས་སྟོབས་ཤུགས་ཆེ་བ་དེས་འཕྲོག་ནོར་བགོ་བཤའ་རྒྱག ");
INSERT INTO bod_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","སུས་ཀྱང་ང་ཡི་ཕྱོགས་མི་བྱེད་པ་དེས་ང་ལ་རྒོལ་ཞིང༌། སུས་ཀྱང་ང་དང་མཉམ་དུ་མི་སྡུད་བ་དེས་གཏོར།” ");
INSERT INTO bod_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“མི་ཞིག་ནས་གདོན་འདྲེ་མི་གཙང་བ་འཐོན་སྐབས། ངལ་གསོ་འཚོལ་བའི་ཕྱིར་ཆུ་མེད་པའི་ས་བརྒྱུད་དེ་ཕྱིན་ནས། མ་རྙེད་པས་ང་ཐོན་པའི་ཁང་པ་དེ་ལ་ཕྱིར་ལོག་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","དེར་སླེབས་དུས་གད་བརྒྱབ་ནས་གཙང་བ་དང་ལེགས་པར་བསྒྲིགས་ཡོད་པ་མཐོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","སོང་ནས་དེ་ལས་ཀྱང་ངན་པ་གདོན་འདྲེ་བདུན་ཁྲིད་དེ་ཁང་པ་དེར་འཛུལ་ནས་བསྡད། མི་དེའི་གནས་ཚུལ་སྔ་མ་ལས་ཕྱི་མ་སྡུག་གོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ཡེ་ཤུས་དེ་ལྟར་གསུང་དུས་མི་ཚོགས་ནང་ནས་བུད་མེད་གཅིག་གིས་སྐད་ཆེན་པོས་ཁོང་ལ་“ཁྱེད་བཞུགས་པའི་ལྷུམས་དང་ཁྱེད་ལ་ཆབ་ཞོ་སྟེར་བའི་ནུ་མ་བདེའོ་”ཞེས་ཟེར་བ་ན། ");
INSERT INTO bod_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ཁོང་གིས་“དེ་བས་དཀོན་མཆོག་གི་བཀའ་ཐོས་ནས་ཁ་ལ་ཉན་པ་རྣམས་ལས་བདེ་བ་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","མི་ཚོགས་མང་པོ་ཁོང་གི་དྲུང་དུ་འཛོམས་སྐབས་ཁོང་གིས་“མི་རབས་འདི་ནི་མི་རབས་ངན་པ་ཞིག་ཡིན། མི་རབས་འདིས་རྟགས་ཤིག་ཞུས་ན་ཡང༌། ལུང་སྟོན་པ་ཡོ་ནཱ་ཡི་རྟགས་མ་གཏོགས་པར་གཞན་ཅི་ཡང་སྟེར་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","རྒྱུ་མཚན་ནི་ལུང་སྟོན་པ་ཡོ་ནཱ་ནི་གནའ་བོའི་གྲོང་ཁྱེར་ནུ་ནེ་ཝཱ་ཡི་མི་རྣམས་ལ་རྟགས་ཤིག་ཏུ་གྱུར་བ་ལྟར། མིའི་རིགས་ཀྱི་བུ་ཡང་མི་རབས་འདི་ལ་རྟགས་སུ་འགྱུར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ཁྲིམས་གཅོད་པའི་ཉིན་མོར་ལྷོ་ཡུལ་གྱི་རྒྱལ་མོ་ལངས་ནས་མི་རབས་འདིའི་མི་རྣམས་ལ་ཉེས་སྐྱོན་འདོན་པར་བྱ། གང་ཡིན་ཞེ་ན། རྒྱལ་པོ་སོ་ལོ་མོན་གྱི་ཤེས་རབ་ཐོས་པའི་ཕྱིར་ཁོ་མོ་ས་གཞིའི་མཐའ་ནས་ཡོང༌། ལྟོས་ཤིག ད་ལྟ་སོ་ལོ་མོན་ལས་ཆེ་བ་ཞིག་འདིར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ཁྲིམས་གཅོད་པའི་ཉིན་མོར་གྲོང་ཁྱེར་ནུ་ནེ་ཝཱ་ཡི་མི་རྣམས་ལངས་ནས་མི་རབས་འདིའི་མི་རྣམས་ལ་ཉེས་སྐྱོན་འདོན་པར་བྱ། གང་ལགས་ཤེ་ན། ལུང་སྟོན་པ་ཡོ་ནཱའི་གསུང་ཐོས་ནས་དེ་ཚོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར། ལྟོས་ཤིག ད་ལྟ་ཡོ་ནཱ་ལས་ཆེ་བ་ཞིག་འདིར་ཡོད།” ");
INSERT INTO bod_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“མི་སུས་ཀྱང་མར་མེ་སྤར་ནས་ས་འོག་ཁང་མིག་ཡང་ན། བྲེ་འོག་ཏུ་མི་འཇོག་སྟེ་ནང་ལ་ཡོང་མཁན་རྣམས་ཀྱིས་འོད་མཐོང་བའི་ཕྱིར་སྟེགས་བུའི་སྟེང་དུ་འཇོག ");
INSERT INTO bod_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","མིག་ནི་ལུས་ཀྱི་སྒྲོན་མེ་ལྟར་ཡིན། མིག་བཟང་པོ་ཡིན་ན་ལུས་ཧྲིལ་པོ་འོད་ཀྱིས་གང༌། མིག་བཟང་པོ་མིན་ན་ལུས་ཧྲིལ་པོ་མུན་ནག་གིས་གང༌། ");
INSERT INTO bod_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","དེའི་ཕྱིར་ཁྱེད་ཀྱི་ནང་ན་ཡོད་པའི་འོད་ནི་མུན་ནག་ཡིན་མིན་བསམ་བློ་ཞིབ་ཕྲ་གཏོང༌། ");
INSERT INTO bod_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ཁྱེད་ཀྱི་ལུས་ཧྲིལ་པོ་འོད་ཀྱིས་གང་ནས་མུན་ནག་ཅི་ཡང་མེད་ན། སྒྲོན་མེས་ཁྱེད་ལ་འོད་འཕྲོ་བ་ལྟར་ཁྱེད་ཡོངས་སུ་འོད་ཅན་དུ་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","དེ་ལྟར་གསུངས་ནས་ཕཱ་རུ་ཤི་པ་ཞིག་གིས་དྲངས་ཏེ་ཁོང་དེའི་ཁྱིམ་ལ་ཕེབས་ནས་གསོལ་བ་བཞེས་སུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ཕཱ་རུ་ཤི་པ་དེས་ཁོང་ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་དང་མི་མཐུན་པར་གསོལ་བ་མ་བཞེས་པའི་སྔོན་ལ་ཕྱག་མ་བཀྲུས་པ་མཐོང་ནས་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","འོན་ཀྱང་གཙོ་བོས་“ཕཱ་རུ་ཤི་པ་ཁྱོད་རྣམས་ཕོར་པ་དང་སྡེར་མའི་ཕྱི་ཕྱོགས་གཙང་བར་བྱེད་ནའང༌། ནང་ཕྱོགས་སུ་ཁྱོད་ཚོ་སེར་སྣ་དང་ངན་སེམས་ཀྱིས་ཁེང་འདུག ");
INSERT INTO bod_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","བླུན་པོ་ཁྱོད། ཕྱི་ཕྱོགས་འགོད་པ་གནང་མཁན་གྱིས་ནང་ཕྱོགས་ཀྱང་མ་བཀོད་དམ། ");
INSERT INTO bod_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","འོན་ཀྱང་ནང་ན་ཡོད་པ་དེ་སྦྱིན་པ་བཏང་ན། ཁྱོད་རྣམས་ལ་ཐམས་ཅད་གཙང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ཕཱ་རུ་ཤི་པ་ཁྱོད་ཚོ་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། གང་ལགས་ཟེར་ན། ལྡུམ་རའི་རྩྭ་དྲི་ཞིམ་དང་སྔོ་ཚོད་ཆུང་ཆུང་སྣ་ཚོགས་ཀྱི་བཅུ་ཆ་གཅིག་དཀོན་མཆོག་ལ་ཕུལ་ན་ཡང༌། ཁྱོད་ཚོས་དྲང་བ་ཉིད་དང་དཀོན་མཆོག་གི་བྱམས་པ་སྣང་མེད་དུ་རྩི་པས་སོ། འདི་ནི་བསྲུངས་ཏེ་གཞན་རྣམས་དོར་བར་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ཕཱ་རུ་ཤི་པ་ཁྱོད་ཚོ་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། གང་ལགས་ཟེར་ན། འདུ་ཁང་ལ་གྲལ་མགོའི་གལ་ཆེ་སར་སྡོད་པ་དང༌། ཁྲོམ་ལ་མི་རྣམས་ཀྱིས་བརྩི་བཀུར་ལྡན་པའི་འཚམས་འདྲི་ལ་དགའ་བས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ཁྱོད་ཚོ་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། གང་ལགས་ཟེར་ན། ཁྱོད་ཚོ་རྟགས་མེད་པའི་དུར་ཁང་ལྟར་ཡིན། མི་རྣམས་ཀྱིས་མི་ཤེས་པར་དེའི་སྟེང་ལ་འགྲོ་བས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ལན་དུ་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཞིག་གིས་“སློབ་དཔོན་ལགས། དེ་ལྟར་གསུངས་ནས་ཁྱེད་ཀྱིས་ང་ཚོ་ལའང་སྨོད་བཞིན་འདུག་”ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ཡེ་ཤུས་“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁྱོད་ཚོ་ལའང་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང་ངེས་ཡིན། རྒྱུ་མཚན་ནི་ཁྱོད་ཚོས་མི་གཞན་ལ་ཁུར་ཆེན་པོ་འགེལ། འོན་ཀྱང་རང་གི་མཛུབ་མོ་གཅིག་ཙམ་གྱིས་དེ་ལ་མི་རེག ");
INSERT INTO bod_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ཁྱོད་ཚོར་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང་ངེས་ཡིན། ཁྱོད་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་མེས་པོས་བསད་པའི་ལུང་སྟོན་པའི་དུར་ཁང་རྩིག ");
INSERT INTO bod_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","དེའི་ཕྱིར་ཁྱོད་ཀྱི་མེས་པོས་བྱས་པའི་ལས་ལ་མོས་མཐུན་བྱེད་ཅིང་དཔང་པོ་བྱེད། མེས་པོས་དེ་རྣམས་བསད་ཅིང་ཁྱོད་ཚོས་དུར་ཁང་རྩིག ");
INSERT INTO bod_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","དེའི་ཕྱིར་དཀོན་མཆོག་གི་ཤེས་རབ་ཀྱིས་ངས་ལུང་སྟོན་པ་དང་སྐུ་ཚབ་མངག་པར་བྱ། ཁོ་ཚོས་ཁ་ཤས་གསོད་དང་ཁ་ཤས་གནོད་སྐྱེལ་བར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","དེ་བས་འཇིག་རྟེན་བཀོད་པ་ནས་བཟུང་བསད་པའི་ལུང་སྟོན་པ་ཐམས་ཅད་ཀྱི་ཁྲག་ནི་མི་རབས་འདིས་འགན་ཁུར་ལེན་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། ཧ་བེལ་ནས་མཆོད་ཁྲི་དང་དཀོན་མཆོག་གི་ཕོ་བྲང་གཉིས་བར་དུ་བསད་པའི་ཟེ་ཀ་རི་ཡཱ་ཙམ་གྱི་ཁྲག་དེ་ཐམས་ཅད་མི་རབས་འདིས་འགན་ཁུར་ལེན་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁྱོད་ཚོ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང་ངེས་ཡིན། ཁྱོད་ཚོས་ཤེས་རབ་ཕོ་བྲང་གི་ལྡེ་མིག་ཕར་ཁྱེར་ཏེ་ཁྱོད་ཚོ་རང་ནང་དུ་མ་ཞུགས་པ་དང༌། ནང་ལ་འགྲོ་བཞིན་པ་རྣམས་ཀྱང་བཀག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","ས་ཆ་དེ་དང་ཁ་བྲལ་ནས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ཁོང་དགྲར་འཛིན་ཏེ་རྩོད་པའི་དྲི་བ་སྣ་ཚོགས་དྲིས་པ་དང༌། ཡེ་ཤུ་ཁྲིམས་དང་འགལ་བའི་གཏམ་བཤད་ནང་དུ་འཇུག་ཆེད་ཇུས་ངན་བཏིང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","དེའི་དུས་སུ་མི་ཚོགས་སྟོང་ཕྲག་མང་པོ་འཛོམས་པས་གཅིག་གིས་གཅིག་བརྫིས། སྐབས་དེར་ཁོང་གིས་ཐོག་མར་ཉེ་གནས་རྣམས་ལ་“ཕཱ་རུ་ཤི་པའི་སྐྱུར་རྩི་ལ་དོགས་ཟོན་གྱིས་ཤིག སྐྱུར་རྩི་དེ་ནི་ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","སྦས་པ་ཡིན་པ་ཐམས་ཅད་མངོན་པར་འགྱུར་བ་དང༌། གསང་བ་ཡིན་པ་ཐམས་ཅད་ཀྱང་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","དེའི་ཕྱིར་ཁྱེད་ཀྱིས་མུན་པར་གང་བཤད་པ་དེ་འོད་ནང་ཐོས་པར་འགྱུར། ཁང་པའི་ཕུག་ནང་གང་ཤུབ་ཤུབ་ཏུ་སྨྲས་པ་དེ་ཁང་པའི་ཐོག་ཁ་ནས་སྒྲོག་པར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“གྲོགས་པོ་ཚོ། ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། གཟུགས་པོ་གསོད་པ་ལས་ཅི་ཡང་བྱེད་མི་ཐུབ་པ་རྣམས་ལ་མ་འཇིགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","འོན་ཀྱང་ངས་ཁྱེད་ཚོར་སུ་ཞིག་ལ་འཇིགས་དགོས་པ་སྟོན་པར་བྱ། བསད་ནས་དམྱལ་ཁམས་སུ་འཕེན་པའི་དབང་ཆ་ཡོད་མཁན་དེ་ལ་འཇིགས་དགོས། སླར་ཡང་ངས་ཁྱེད་ཚོར་ཁོང་ལ་འཇིགས་ཤིག་ཅེས་སྐུལ། ");
INSERT INTO bod_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ཁང་བྱིའུ་ལྔ་ཟངས་ཀྱི་སྒོར་མོ་གཉིས་ལ་མི་འཚོང་ངམ། འོན་ཀྱང་དཀོན་མཆོག་གི་སྤྱན་སྔར་དེ་རྣམས་ལས་གཅིག་ཀྱང་མི་བརྗེད། ");
INSERT INTO bod_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","དེ་བས་ཀྱང་ཁྱེད་ཀྱི་མགོའི་སྐྲ་ཐམས་ཅད་ཀྱང་གྲངས་ཀ་བརྒྱབ་ཡོད་པས་མ་འཇིགས་ཤིག ཁང་བྱིའུ་མང་པོ་ལས་ཁྱེད་ཚོ་རིན་ཐང་ཆེའོ། །” ");
INSERT INTO bod_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ཡང་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། སུས་ཀྱང་མི་གཞན་གྱི་མདུན་དུ་ང་ཁས་ལེན་ན། དཀོན་མཆོག་གི་ཕོ་ཉའི་མདུན་དུ་མིའི་རིགས་ཀྱི་བུས་མི་དེ་ཡང་ཁས་ལེན་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","འོན་ཀྱང་སུས་མི་གཞན་གྱི་མདུན་དུ་ང་ཁས་མི་ལེན་ན། དཀོན་མཆོག་གི་ཕོ་ཉའི་མདུན་དུ་མི་དེ་ཡང་ཁས་ལེན་བྱེད་པར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","མིའི་རིགས་ཀྱི་བུ་ལ་ངན་སྨྲས་བྱེད་མཁན་དེའི་སྡིག་ཉེས་སེལ་བར་འགྱུར། འོན་ཀྱང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་སྐུར་བ་འདེབས་མཁན་དེའི་སྡིག་ཉེས་སེལ་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ཁོ་ཚོས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་གི་ཚོགས་འདུ་དང༌། དཔོན་པོ། ཁྲིམས་དཔོན་ལ་སོགས་པའི་མདུན་དུ་ཁྱེད་ཚོ་ཁྲིམས་གཅོད་བྱེད་དུ་འཁྲིད་སྐབས། ལན་ཅི་ལྟར་བྱེད་པ་དང༌། ཡང་ན་ཅི་སྨྲ་བ་སེམས་ཁྲལ་མ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","གང་ལགས་ཟེར་ན། དུས་དེ་རང་ལ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྱེད་ཚོར་ཅི་ཞིག་སྨྲ་དགོས་པ་གསུང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","མི་ཚོགས་ནང་ནས་མི་ཞིག་གིས་“སློབ་དཔོན་ལགས། ངའི་གཅེན་པོ་ལ་ཕ་ཤུལ་ང་དང་བགོ་བཤའ་རྒྱག་དགོས་པའི་བཀའ་གནང་རོགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ཁོང་གིས་མི་དེར་“གྲོགས་པོ། སུས་ང་ཁྱོད་ཀྱི་ཁྲིམས་དཔོན་ནམ། བར་འདུམ་གཏོང་མཁན་ལ་བསྐོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","དེ་ནས་ཁོང་གིས་ཁོ་ཚོར་“སེར་སྣ་ཐམས་ཅད་ལ་དོགས་ཟོན་གྱིས་ཤིག རྒྱུ་མཚན་ནི་མི་ཞིག་གི་ཚེ་ནོར་མང་པོ་ཡོད་མེད་ལ་རག་མི་ལས་པའི་ཕྱིར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ཡང་དཔེའི་སྒོ་ནས་གསུངས་ཏེ་ཁོང་གིས་“ཕྱུག་པོ་ཞིག་གི་ས་ཞིང་ལས་ལོ་ཏོག་ལེགས་པོ་བྱུང་བས། ");
INSERT INTO bod_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ང་ལ་ལོ་ཏོག་བཞག་ས་མེད་པས་ངས་ཅི་བྱ་ཞེས་སྙམ་ནས། ");
INSERT INTO bod_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ཁོས་ངས་མཛོད་ཁང་རྣམས་བཤིག་ནས་དེ་ལས་ཆེ་བ་རྩིག་པར་བྱ། དེར་ངའི་འབྲུ་རིགས་དང་ཅ་ལག་ཐམས་ཅད་ཉར་ཚགས་བྱེད་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ཡང་ངས་ང་རང་གིས་རང་ལ། ལོ་མང་པོའི་ཆེད་དུ་རྒྱུ་ནོར་ཉར་ཚགས་བྱས་ཡོད་པས་ངལ་གསོ་དང༌། ལོངས་སྤྱོད། སྐྱིད་པོ་བྱས་ཏེ། བཟའ་བཏུང་བྱེད་པར་བྱ་ཞེས་ཟེར་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","འོན་ཀྱང་དཀོན་མཆོག་གིས་དེ་ལ། བླུན་པོ་ཁྱོད། མཚན་མོ་འདི་རང་ལ་ཁྱོད་ཀྱི་ཚེ་སྲོག་ལེན་པར་འགྱུར། ཁྱོད་ཀྱིས་གྲ་སྒྲིག་བྱས་པའི་ཅ་ལག་དེ་ཚོ་སུ་ལ་འཐོབ་ཡོང་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","དཀོན་མཆོག་གི་སྤྱན་སྔར་ཕྱུག་པོ་མ་ཡིན་པ་རྣམས་ནི་རང་ལ་རྒྱུ་ནོར་གསོག་པས་དེ་ལྟར་འབྱུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ཡེ་ཤུས་ཁོང་གི་ཉེ་གནས་རྣམས་ལ་“དེའི་ཕྱིར་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། མི་ཚེའི་ཕྱིར་ཟས་གང་ཞིག་ཟ་རྒྱུ་དང༌། ལུས་ཀྱི་ཕྱིར་གོས་གང་ཞིག་གྱོན་པ་སེམས་ཁྲལ་མ་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","གང་ལགས་ཟེར་ན། མི་ཚེ་ནི་ཟས་དང༌། ལུས་པོ་གྱོན་ཆས་དེ་གཉིས་ལས་ལྷག་པ་ཡོད་དོ། ");
INSERT INTO bod_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ཕོ་རོག་ལ་ལྟོས་ཤིག དེ་ཚོས་ས་བོན་མི་འདེབས་ལ། ལོ་ཏོག་ཡང་མི་རྔ༌། དེ་ཚོར་མཛོད་ཁང་ངམ་བང་མཛོད་མེད་ཀྱང༌། དཀོན་མཆོག་གིས་དེ་ཚོར་ཟས་གནང༌། ཁྱེད་ཚོ་བྱ་རྣམས་ལས་ཇི་ཙམ་གྱི་གལ་ཆེའོ། ");
INSERT INTO bod_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ཁྱེད་ཚོ་ལས་སུ་ཞིག་གིས་སེམས་ཁྲལ་བྱེད་པའི་ངང་ནས་མི་ཚེ་འདི་ལ་ཆུ་ཚོད་གཅིག་ཙམ་གྱི་རིང་དུ་གཏོང་ཐུབ་བམ། ");
INSERT INTO bod_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","དེ་ལྟར་དོན་ཆུང་འདི་ཡང་བྱེད་མི་ཐུབ་ན། དོན་གཞན་ལ་ཅིའི་ཕྱིར་སེམས་ཁྲལ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","སྟག་གཟིག་མེ་ཏོག་ཇི་ལྟར་སྐྱེ་བར་ལྟོས་ཤིག དེ་ཚོས་ལས་ཀ་མི་བྱེད་ཅིང་བལ་ཡང་མི་འཁལ། ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། རྒྱལ་པོ་སོ་ལོ་མོན་གཟི་བརྗིད་དང་ལྡན་པ་ཡིན་ཡང༌། ཁོང་གི་རྒྱན་གོས་དེ་ཚོ་ལས་གཅིག་ལའང་འགྲན་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","གལ་ཏེ་དཀོན་མཆོག་གིས་ཞིང་གི་རྩྭ་ནི་དེ་རིང་སྐྱེ་སྟེ་སང་ཉིན་ཐབ་ལ་འཕེན་རྒྱུ་ཡིན་པ་དེ་ལྟར་གཡོག་པར་མཛད་ན། ཁོང་གིས་དེ་བས་ཀྱང་ཁྱོད་དད་ཆུང་བ་རྣམས་ལ་གཡོག་པ་གནང་བར་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ཅི་ཟ་དང་ཅི་འཐུང་མ་འཚོལ་ཞིང་སེམས་ཁྲལ་མ་བྱོས། ");
INSERT INTO bod_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","རྒྱུ་མཚན་ནི་ཕྱི་པ་རྣམས་ཀྱིས་དེ་ཚོ་ཚང་མ་འཚོལ། ཁྱོད་ཀྱི་ཡབ་ཀྱིས་ཁྱོད་ཚོ་ལ་དེ་རྣམས་དགོས་པ་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ཁོང་གི་རྒྱལ་སྲིད་ལ་འབད་བརྩོན་བྱོས། དེ་ནས་དེ་རྣམས་ཁྱེད་ཚོ་ལ་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ཀྱེ། ཁྱུ་ཆུང་དང་འདྲ་བ་རྣམས། མ་འཇིགས་ཤིག གང་ཡིན་ཞེ་ན། རྒྱལ་སྲིད་ཁྱོད་རྣམས་ལ་གནང་བ་དེ་ཁྱོད་ཀྱི་ཡབ་ལ་ཐུགས་མཉེས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","སོ་སོའི་དངོས་པོ་བཙོངས་ནས་དབུལ་ཕོངས་ལ་སྦྱིན་པ་ཐོང༌། བསྐུལ་ཟད་མི་འཐེབས་པའི་དངུལ་ཁུག་དང༌། རྐུན་མ་མི་ཡོང་བ་དང་མུག་པས་མི་འཇིག་པའི་ཞིང་ཁམས་སུ་ཡོད་པའི་རྒྱུ་ནོར་རྒྱུན་དུ་གནས་པ་ཞིག་འཐོབ་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","གང་ཡིན་ཞེ་ན། ཁྱེད་ཀྱི་རྒྱུ་ནོར་གང་དུ་ཡོད་པ་དེར་ཁྱེད་ཀྱི་སེམས་ཀྱང་ཡོད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","ཡང་ཡེ་ཤུས་“བག་སྟོན་ནས་ཕྱིར་ལོག་པའི་ཁྱིམ་བདག་གིས་སྒོ་བརྡུངས་ནས་འཕྲལ་དུ་སྒོ་འབྱེད་པའི་ཕྱིར་སྒུག་མཁན་རྣམས་ལྟར་ཞབས་ཕྱི་བྱེད་པར་སྐེད་རགས་ཆིངས་ཤིང༌། སྒྲོན་མེ་འབར་ཏེ་གནས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ཁྱིམ་བདག་སླེབས་སྐབས་ཁོང་གིས་བྱ་ར་བྱེད་བཞིན་པའི་གཡོག་པོ་རྣམས་མཐོང་ན་དེ་རྣམས་བདེའོ། ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། ཁྱིམ་བདག་དེ་སྐེད་རགས་བཅིངས་ཏེ་ཁོ་ཚོ་ཟས་ཟ་བར་སྡོད་དུ་འཇུག་པ་དང༌། ཁོ་ཚོའི་རྩར་ཕེབས་ནས་གཡོག་བྱེད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ཁོང་ནམ་ཕྱེད་དང༌། ཡང་ན་སྐྱ་རེངས་ཤར་དུས་ཕེབས་ཀྱང་དེ་ལྟར་མཐོང་ན། གཡོག་པོ་དེ་རྣམས་བདེའོ། ");
INSERT INTO bod_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ཁྱིམ་བདག་གིས་རྐུན་མ་སླེབས་པའི་དུས་དེ་ཤེས་པ་ཡིན་ན། ཁང་པར་འཛུལ་དུ་མི་འཇུག་པ་དེ་རྟོགས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","དེའི་ཕྱིར་ཁྱེད་ཚོའང་གྲ་སྒྲིག་བྱས་ནས་སྡོད་དགོས། གང་ལགས་ཟེར་ན། མིའི་རིགས་ཀྱི་བུ་ཁྱེད་ཀྱིས་མི་སེམས་པའི་དུས་ལ་ཕེབས་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","པེ་ཏྲོས་“གཙོ་བོ་ལགས། དཔེ་དེ་ང་ཚོ་ལ་གསུངས་པ་ཡིན་ནམ། ཡང་ན་མི་ཚང་མར་གསུངས་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ཡང་གཙོ་བོས་“བློ་གཏད་ཆོག་པ་དང་ཤེས་རབ་དང་ལྡན་པའི་གཉེར་པ་སུ་ཡིན། ཁྱིམ་བདག་གིས་མི་དེ་ལ་དབང་ཆ་སྤྲད་ནས་ཁོས་དུས་ལ་འབབ་སྐབས་སུ་གཡོག་པོ་གཞན་པ་རྣམས་ལ་ཟས་སྐལ་སྟེར། ");
INSERT INTO bod_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","དེ་ལྟར་བྱེད་བཞིན་པའི་གཡོག་པོ་ནི་ཁྱིམ་བདག་ཡོང་ནས་བལྟས་ན་བདེའོ། ");
INSERT INTO bod_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ངས་ཁྱོད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ཁྱིམ་བདག་དེས་ཁོ་ལ་གང་ཡོད་པ་ཐམས་ཅད་གཉེར་པ་དེའི་དབང་འོག་ཏུ་འཇུག་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","འོན་ཀྱང་གཡོག་པོ་དེས་ཁྱིམ་བདག་འགྱང་བར་བསམས་ཏེ་གཡོག་པོ་དང་གཡོག་མོ་བརྡུངས་ཏེ་ཟ་འཐུང་བྱས་ནས་ར་བཟི་བར་གྱུར་ན། ");
INSERT INTO bod_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","གཡོག་པོས་མི་བསམ་པའི་ཉིན་དང༌། མི་ཤེས་པའི་དུས་ཚོད་ལ་ཁྱིམ་བདག་ཡོང་སྟེ་ཁོ་དུམ་བུར་བཅད་ནས་དད་པ་མེད་པའི་མི་དང་ལྷན་དུ་གནས་སུ་འཇུག་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","གཡོག་པོས་ཁྱིམ་བདག་གི་དགོངས་པ་ཤེས་ན་ཡང༌། གྲ་སྒྲིག་མ་བྱས་པ་དང་ཁྱིམ་བདག་གི་དགོངས་པ་ལྟར་མ་བྱས་པ་དེ་ལ་ཉེས་རྡུང་དྲག་པོ་གཟེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","གཡོག་པོས་ཁྱིམ་བདག་གི་དགོངས་པ་མི་ཤེས་པའི་སྒོ་ནས་ཉེས་རྡུང་འོས་པའི་ལས་བྱས་པ་དེར་ཉེས་རྡུང་ཏོག་ཙམ་གཟེད་པར་འགྱུར། སུ་ཞིག་ལ་མང་པོ་སྟེར་ཡོད་པ་དེས་མང་པོ་སྟེར་དགོས་དང༌། སུ་ཞིག་ལ་མང་པོ་གཏད་ཡོད་པ་དེས་ལྷག་པར་སྟེར་དགོས།” ");
INSERT INTO bod_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ང་འཇིག་རྟེན་ལ་མེ་འཕེན་པའི་ཕྱིར་ཡོང་བས་དེ་འབར་ཟིན་པ་ཅི་མ་རུང༌། ");
INSERT INTO bod_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ང་ལ་མྱོང་དགོས་པའི་ཁྲུས་གསོལ་ཡོད། དེ་མ་ཚར་བའི་བར་དུ་ང་སེམས་ཤིན་ཏུ་འཁྲུགས། ");
INSERT INTO bod_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ང་ཞི་བདེ་གཏོང་བར་འཇིག་རྟེན་ལ་ཡོང་བ་ཡིན་པར་སེམས་སམ། ངས་ཟེར་རྒྱུར་དེ་ལྟར་མ་ཡིན། མི་མཐུན་པ་སྦྱིན་པར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ད་ནས་བཟུང་ཁྱིམ་ཚང་གཅིག་གི་མི་ལྔ་མི་མཐུན་པར་སྡོད་དེ། གསུམ་གྱིས་གཉིས་དང་གཉིས་ཀྱིས་གསུམ་ལ་རྒོལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","དེ་ཚོ་མི་མཐུན་པར་སྡོད་དེ། ཕ་ཡིས་བུ་དང༌། བུ་ཡིས་ཕ། མ་ཡིས་བུ་མོ་དང༌། བུ་མོས་མ། སྒྱུག་མོས་མནའ་མ་དང༌། མནའ་མས་སྒྱུག་མོར་རྒོལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ཡང་ཁོང་གིས་མི་ཚོགས་ལ་“ནུབ་ཕྱོགས་ནས་སྤྲིན་པ་བྱུང་སྐབས་འཕྲལ་དུ་ཁྱོད་ཚོས་ཆར་པ་འབབ་གྲབས་འདུག་ཅེས་སྨྲས་ནས་དེ་ལྟར་འབྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ཡང་ལྷོ་ཕྱོགས་ནས་རླུང་ཞིག་རྒྱུག་བཞིན་པ་མཐོང་སྐབས་ཁྱོད་ཚོས་གནམ་གཤིས་ཚ་པོར་འགྱུར་ཞེས་ཟེར་ནས་དེ་ལྟར་འབྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ཁ་ཆོས་པ་ཁྱོད་ཚོ། གནམ་ས་གཉིས་ཀྱི་གནས་ཚུལ་དཔྱོད་སྟངས་ཤེས་ན། དུས་འདིའི་གནས་ཚུལ་ཅིའི་ཕྱིར་མི་དཔྱོད།” ");
INSERT INTO bod_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ཡང་ཁྱོད་ཚོ་རང་གིས་གང་ཞིག་འོས་པ་ཡིན་པར་ཅིའི་ཕྱིར་ཐག་གཅོད་མི་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","དཔེར་ན་ཁྱོད་དང་ཁྱོད་ཀྱི་ཁ་གཏད་གཉིས་དཔོན་པོའི་རྩར་འགྲོ་དུས་ལམ་བར་དུ་ཁོ་དང་མཐུན་འགྲིག་བྱེད་པར་བརྩོན་ལེན་བྱོས་ཤིག དེ་མིན་ན་ཁ་གཏད་དེས་ཁྱོད་ཁྲིམས་དཔོན་གྱི་མདུན་དུ་འཁྲིད་དུ་བཅུག་པ་དང༌། ཁྲིམས་དཔོན་གྱིས་ཁྱོད་བཙོན་སྲུང་པར་གཏད་ནས་བཙོན་ཁང་དུ་འཇུག ");
INSERT INTO bod_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ངས་ཁྱོད་ཚོ་ལ་ཟེར་རྒྱུར། མཐའ་མའི་ཟངས་ཀྱི་སྒོར་མོ་ཆུང་ཆུང་གཅིག་མ་འཇལ་བའི་བར་དུ་ཁྱོད་དེ་ལས་ཐར་མི་སྲིད་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","དེའི་དུས་སུ་དེར་ཡོད་པའི་མི་ཁ་ཤས་ཀྱིས་ཁོང་ལ་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ཡིས་ག་ལིལ་པ་བསད་ནས་དེ་ཚོའི་ཁྲག་མཆོད་པར་ཕུལ་བའི་སེམས་ཅན་གྱི་ཁྲག་དང་བསྲེས་པའི་གཏམ་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ཡེ་ཤུས་ཁོ་ཚོར་“སྡུག་བསྔལ་དེ་ལྟར་མྱངས་པས་ག་ལིལ་པ་ཐམས་ཅད་ལས་འདི་ཚོ་སྡིག་ཉེས་ཅན་ཡིན་པར་སེམས་སམ། ");
INSERT INTO bod_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","དེ་ལྟར་མ་ཡིན་ཞེས་ཟེར། ཁྱོད་ཚོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་མ་བསྒྱུར་ན་ཁྱོད་ཚོ་ཐམས་ཅད་དེ་ལྟར་འཇིག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ཡང་སི་ལོམ་གྱི་མཁར་རྡིབ་ནས་མི་བཅོ་བརྒྱད་ཤི་བ་རྣམས་ཡེ་རུ་ཤ་ལེམ་ལ་སྡོད་མཁན་ཐམས་ཅད་ལས་ཉེས་ཅན་ཡིན་པར་སེམས་སམ། ");
INSERT INTO bod_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","དེ་ལྟར་མ་ཡིན་ཞེས་ཟེར། ཁྱོད་ཚོས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་མ་བསྒྱུར་ན་ཁྱོད་ཚོ་ཐམས་ཅད་དེ་ལྟར་དུ་འཇིག་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ཡང་དཔེའི་སྒོ་ནས་ཁོང་གིས་“མི་ཞིག་གི་རྒུན་འབྲུམ་གྱི་ལྡུམ་རར་བསེ་ཡབ་ཤིང་སྡོང་ཞིག་བཙུགས་ཡོད་པ་དང༌། ཁོས་འབྲས་བུ་བཙལ་བར་ཡོང་སྟེ་ཅི་ཡང་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ཡང་ཁོས་ཚལ་སྲུང་མཁན་ལ། ལྟོས་ཤིག ལོ་གསུམ་རིང་ངས་བསེ་ཡབ་ཤིང་འདིར་འབྲས་བུ་བཙལ་ནས་ཅི་ཡང་མ་རྙེད། དེ་ཆོད་ཅིག དེས་ས་རྒྱུ་ཆུད་ཟོས་གཏོང་བའི་དོན་གང་ཡིན་ཞེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ལན་དུ་ཁོས། སྐུ་ཞབས་ལགས། ད་དུང་ལོ་གཅིག་རིང་ལ་དེ་མི་གཅོད་པར་ཞོག ངས་མཐའ་འཁོར་གྱི་ས་རྒྱུ་བརྐོས་ནས་ལུད་རྒྱག་གི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ལོ་རྗེས་མར་འབྲས་བུ་སྐྱེས་ན་ལེགས་སོ། མ་སྐྱེས་ན་གཅད་ཆོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","དེ་ནས་ངལ་གསོ་བའི་ཉིན་མོར་ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ཞིག་ལ་ཆོས་གསུང་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","གདོན་འདྲེས་བཟུང་ནས་ལོ་བཅོ་བརྒྱད་རིང་དགུར་པོར་འགྲོ་དགོས་པ་དང༌། འདྲོང་པོར་ལང་མི་ཐུབ་པའི་བུད་མེད་ནད་པ་ཞིག་དེར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ཡེ་ཤུས་བུད་མེད་དེ་གཟིགས་ནས་ཁོ་མོ་ལ་ཚུར་ཤོག་ཅེས་པའི་བཀའ་གནང་སྟེ་“ཨ་ཅག་ལགས། ཁྱེད་ནད་ལས་ཐར་རོ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ཁོང་གིས་ཁོ་མོར་ཕྱག་བཞག་སྟེ་འཕྲལ་དུ་འདྲོང་པོར་ལངས་ནས་ཁོ་མོས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","འོན་ཀྱང་ཡེ་ཤུས་ངལ་གསོ་བའི་ཉིན་མོར་ནད་གསོས་པར་མཛད་པའི་རྐྱེན་གྱིས་འདུ་ཁང་གི་དཔོན་པོས་ཁྲོས་ཏེ་མི་ཚོགས་ལ་“ལས་ཀ་བྱེད་ཆོག་པའི་ཉི་མ་དྲུག་ཡོད། ངལ་གསོ་བའི་ཉིན་མོ་མ་ཡིན་པ་དེ་ཚོ་ལ་ནད་གསོ་བའི་ཕྱིར་ཤོག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ལན་དུ་གཙོ་བོས་“ཁ་ཆོས་པ་ཁྱོད་ཚོ། ཁྱོད་རྣམས་ཀྱི་ནང་ནས་རེ་རེས་ངལ་གསོ་བའི་ཉིན་མོར་གླང་གོག་དང༌། ཡང་ན་བོང་བུ་བྲེས་ནས་བཀྲོལ་ཏེ་ཆུ་འཐུང་བར་མི་འཁྲིད་དམ། ");
INSERT INTO bod_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ཡང་ཨབ་ར་ཧམ་གྱི་བུ་མོ་ཡིན་པའི་བུད་མེད་འདི་ནི་བདུད་སཱ་ཏན་གྱིས་ལོ་བཅོ་བརྒྱད་རིང་བཅིངས་ནས་ངལ་གསོ་བའི་ཉིན་མོར་ནད་ལས་ཐར་བར་འགྱུར་མི་འོས་སམ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ཁོང་གི་ཁ་གཏད་ཐམས་ཅད་ངོ་ཚ་བར་གྱུར། ཁོང་གིས་ངོ་མཚར་བའི་ལས་མང་པོ་མཛད་པས་མི་ཚོགས་ཚང་མ་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","དེའི་ཕྱིར་ཁོང་གིས་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཅི་དང་འདྲ་བ་ཡིན་ལ། ངས་གང་ཞིག་དང་སྡུར་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","དེ་ནི་ཡུངས་འབྲུ་ས་བོན་ཅིག་དང་འདྲ་སྟེ། མི་ཞིག་དེ་བླངས་ནས་རང་གི་ལྡུམ་རར་ས་ལ་བཏབ་ནས་ཆེར་སྐྱེས་ཏེ་རྩི་ཤིང་དུ་གྱུར་ཞིང༌། བྱིའུ་རྣམས་ཀྱིས་དེའི་ཡལ་གར་ཚང་བཟོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ཡང་ཁོང་གིས་“ངས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་གང་ཞིག་དང་སྡུར་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","དེ་ནི་སྐྱུར་རྩི་དང་འདྲ་སྟེ། བུད་མེད་ཞིག་གིས་དེ་གྲོ་ཕྱེ་བྲེ་གསུམ་གྱི་ནང་ལ་བསྲེས་པ་དང༌། རྗེས་མ་ཕྱེ་ཐམས་ཅད་ལ་སྐྱུར་ལངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་པའི་ལམ་བར་དུ་ཡེ་ཤུས་ཆོས་གསུངས་ཏེ་གྲོང་ཁྱེར་དང༌། གྲོང་གསེབ་མང་པོ་བརྒྱུད། ");
INSERT INTO bod_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","མི་ཞིག་གིས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཐར་དུ་འགྱུར་བ་རྣམས་ཉུང་ངུ་ཡིན་ནམ་”ཞེས་དྲིས་པས་ཁོང་གིས་ཁོ་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“སྒོ་དོག་མོའི་བརྒྱུད་ནས་འཇུག་པར་འབད་བརྩོན་གྱིས་ཤིག ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། མི་མང་པོ་འཇུག་པའི་ཐབས་བཙལ་ཡང་མི་ཐུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ཁྱིམ་བདག་ཡར་ལངས་ནས་སྒོ་བརྒྱབ་པའི་རྗེས་སུ་ཁྱོད་ཚོས་ཕྱི་རུ་ལངས་ཤིང་སྒོ་བརྡུངས་ཏེ། གཙོ་བོ་ལགས། ང་ཚོ་ལ་སྒོ་འབྱེད་པར་མཛོད་ཅེས་ཟེར། ལན་དུ་ཁོང་གིས་ཁྱོད་ཚོ་གང་ནས་ཡོང་མིན་ངས་མི་ཤེས་ཞེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","དེ་ནས་ཁྱོད་ཚོས། ཁྱེད་ཀྱི་མདུན་དུ་ང་ཚོས་བཟས་ཤིང་བཏུངས། ང་ཚོའི་ལམ་ལ་ཁྱེད་ཀྱིས་ཆོས་གསུངས་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ཁོང་གིས། ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། ཁྱོད་གང་ནས་ཡོང་མིན་ངས་མི་ཤེས། ཁྱོད་ལས་ངན་བྱེད་མཁན་ཐམས་ཅད། ངའི་རྩ་ནས་ཕར་སོང་ཞིག་ཅེས་གསུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ཨབ་ར་ཧམ་དང༌། ཨི་སཱག ཡ་ཀོབ། ལུང་སྟོན་པ་ཐམས་ཅད་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་གནས་ཏེ་ཁྱོད་རང་ཕྱིར་འདོན་པར་མཐོང་ནས་ཁྱོད་ཚོས་ངུ་ཞིང་སོ་ཁྲིག་ཁྲིག་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ཡང་དེ་རྣམས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་ཞལ་ཟས་བཞེས་པའི་ཕྱིར་ཤར་ནུབ་དང༌། ལྷོ་བྱང་ཕྱོགས་ནས་ཡོང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ཡང་ལྟོས་ཤིག མཐའ་མ་ཡིན་པ་ཁ་ཤས་དང་པོར་འགྱུར་ལ། དང་པོ་ཡིན་པ་ཁ་ཤས་མཐའ་མར་འགྱུར་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","དུས་དེ་རང་ལ་ཕཱ་རུ་ཤི་པ་ཁ་ཤས་ཡོང་ནས་ཁོང་ལ་“རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡིས་ཁྱེད་གསོད་པར་འདོད་པས་ཕར་ཕེབས་ཤིག་”ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ཁོང་གིས་ཁོ་ཚོར་“སོང་ལ་གཡོ་ཅན་ཝ་དང་འདྲ་བ་དེར། ཉོན་ཅིག ངས་དེ་རིང་དང་སང་ཉིན་གདོན་འདྲེ་སྐྲོད་པ་དང་ནད་སེལ་ཏེ། ཉིན་མོ་གསུམ་པར་ངའི་དམིགས་ཡུལ་སྒྲུབ་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","འོན་ཀྱང་དེ་རིང་དང༌། སང་ཉིན། གནངས་ཉིན་བཅས་ང་ལམ་ལ་འགྲོ་དགོས། གང་ཡིན་ཞེ་ན། ལུང་སྟོན་པ་ཞིག་ཡེ་རུ་ཤ་ལེམ་གྱི་ཕྱི་རོལ་ཏུ་ཤི་མི་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ཁོང་གིས་“ཀྱེ་ཡེ་རུ་ཤ་ལེམ། ཡེ་རུ་ཤ་ལེམ། ཁྱོད་ཀྱིས་ལུང་སྟོན་པ་རྣམས་གསོད་ཅིང་ཁྱོད་ལ་མངག་མཁན་རྣམས་རྡོ་རུབ་གཏོང༌། བྱ་མོས་རང་གི་བྱ་ཕྲུག་གཤོག་པའི་འོག་ཏུ་སྡུད་པ་ལྟར་ངས་ཐེངས་མང་པོར་ཁྱོད་ཀྱི་ཕྲུ་གུ་སྡུད་པར་འདོད་ཀྱང༌། ཁྱོད་རྣམས་མ་མོས། ");
INSERT INTO bod_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ལྟོས་ཤིག ཁྱོད་ཀྱི་གནས་ཁང་སྟོང་པར་འགྱུར། ངས་ཁྱོད་རྣམས་ལ་ཟེར་རྒྱུར། གཙོ་བོའི་མཚན་ཐོག་ནས་ཕེབས་མཁན་ལ་བྱིན་རླབས་གནང་བར་ཤོག་ཅེས་ཟེར་བའི་བར་དུ་ཁྱོད་ཀྱིས་ང་མཐོང་བར་མི་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ངལ་གསོ་བའི་ཉིན་མོར་ཁོང་ཞལ་ཟས་བཞེས་པའི་ཕྱིར་ཕཱ་རུ་ཤི་པའི་དཔོན་པོ་ཞིག་གི་ཁང་པར་ཕེབས་ནས་ཁོ་ཚོས་ཁོང་ལ་ནན་ཏན་གྱིས་བལྟས་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","དེའི་དུས་སུ་ཁོང་གི་མདུན་དུ་གཟུགས་པོ་སྐྲང་ནད་ཕོག་པའི་མི་ཞིག་ཡོད་དེ། ");
INSERT INTO bod_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ཡེ་ཤུས་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ལ་“ཆོས་ཁྲིམས་ལྟར་ངལ་གསོ་བའི་ཉིན་མོར་ནད་གསོ་བར་བྱེད་ཆོག་གམ། མི་ཆོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","འོན་ཀྱང་ཁོ་ཚོ་ཁ་རོག་བསྡད། ཡེ་ཤུས་མི་དེ་ལ་རེག་སྟེ་ནད་གསོ་བར་མཛད་ནས་འགྲོ་རུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོའི་ནང་སུ་ཞིག་གིས་བུ་ཕྲུག་གམ་བ་གླང་ངལ་གསོ་བའི་ཉིན་མོར་རྫིང་བུར་ལྷུངས་ན་འཕྲལ་དུ་མི་འདོན་ནམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ཁོ་ཚོས་ལན་ཅི་ཡང་བརྗོད་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","མགྲོན་པོ་རྣམས་གྲལ་མགོའི་གལ་ཆེ་སར་བདམས་པར་གཟིགས་ནས་ཁོང་གིས་ཁོ་ཚོར་དཔེའི་སྒོ་ནས་ ");
INSERT INTO bod_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“སུ་ཞིག་གིས་ཁྱོད་བག་སྟོན་དུ་མགྲོན་ལ་བོས་སྐབས་གྲལ་མགོའི་གལ་ཆེ་སར་མ་སྡོད། གང་ལགས་ཟེར་ན། སྦྱིན་བདག་གིས་ཁྱོད་ལས་གལ་ཆེ་བ་ཞིག་བོས་ཡོད་ན། ");
INSERT INTO bod_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ཁྱོད་གཉིས་བག་སྟོན་ལ་འབོད་མཁན་ཡོང་ནས་ཁྱོད་ལ། ཁྱེད་ཀྱི་བཞུགས་ས་མི་འདི་ལ་གནང་རོགས་ཞེས་བཤད་དེ་ངོ་ཚ་བའི་ངང་ནས་ཁྱོད་གྲལ་མཇུག་ཏུ་འགྲོ་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","འོན་ཀྱང་སྟོན་ལ་བོས་སྐབས་སུ་གྲལ་མཇུག་ཏུ་སོང༌། དེ་ནས་ཁྱོད་བག་སྟོན་ལ་འབོད་མཁན་ཡོང་ནས། གྲོགས་པོ། གྲལ་མགོའི་གལ་ཆེ་སར་བཞུགས་རོགས་གནང་ཞེས་སྨྲས་ནས་ཚང་མའི་མདུན་དུ་ཁྱོད་བཀུར་སྟི་འཐོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","དེ་བས་རང་གིས་རང་ལ་བཀུར་སྟི་བྱེད་མཁན་ཐམས་ཅད་དམའ་བར་འགྱུར་ཞིང༌། རང་གིས་རང་ལ་དམའ་བར་གཏོང་མཁན་ཐམས་ཅད་བཀུར་སྟི་འཐོབ་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","དེ་ནས་ཁོང་སྟོན་དུ་འབོད་མཁན་ལ་ཁོང་གིས་“ཁྱེད་ཀྱིས་དགུང་ཟས་དང༌། ཡང་ན་དགོང་ཟས་གཏོང་སྐབས་གྲོགས་པོའམ། སྤུན་ནམ། ཁྱིམ་མཚེས་ཕྱུག་པོ་རྣམས་མགྲོན་ལ་མ་འབོད། དེ་ལྟར་བྱས་ན་དེ་ཚོས་ཀྱང་ཁྱེད་སྟོན་ལ་བོས་ནས་དྲིན་ལན་འཇལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","གསོལ་སྟོན་གཏོང་སྐབས་སུ་དབུལ་པོ་དང༌། དབང་པོ་སྐྱོན་ཅན། ཞ་བོ། ལོང་བ་ལ་སོགས་པའི་མི་རྣམས་བོས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ཁྱེད་བདེ་བར་འགྱུར། རྒྱུ་མཚན་ནི་ཁོ་ཚོར་དྲིན་ལན་བྱེད་རྒྱུ་མེད་པས་རྣམ་དག་པ་རྣམས་འཆི་བ་ནས་སླར་གསོན་པའི་དུས་སུ་ཁྱེད་ཀྱི་དྲིན་ལན་འཇལ་བར་འགྱུར་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ཁོང་དང་ཞལ་ཟས་བཞེས་པའི་མི་རྣམས་ཀྱི་ནང་ནས་མགྲོན་པོ་ཞིག་གིས་དེ་ཐོས་ནས་ཁོང་ལ་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་ཞལ་ཟས་བཞེས་མཁན་ཐམས་ཅད་བདེའོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ཁོང་གིས་མི་དེར་“མི་ཞིག་གིས་གསོལ་སྟོན་ཆེན་པོ་གཏོང་བའི་སྔོན་ལ་མི་མང་པོ་བོས། ");
INSERT INTO bod_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","དགོངས་ཟས་དུས་ལ་འབབ་ཚེ། མགྲོན་པོ་རྣམས་ལ་ད་ལྟ་ཐམས་ཅད་བཤམས་པས་ཕེབས་ཤོག་ཅེས་ཟེར་རྒྱུར་ཁོས་གཡོག་པོ་ཞིག་མངགས། ");
INSERT INTO bod_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","འོན་ཀྱང་དེ་ཚོ་ཚང་མས་ཁ་མཐུན་ནས་སྙད་བཏགས། དང་པོས་ཁོ་ལ། ངས་ས་ཞིང་ཉོས་ནས་དེ་ལྟ་རུ་འགྲོ་དགོས་པས་དགོངས་དག་ཞུ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","གཞན་ཞིག་གིས་ངས་བ་གླང་དོར་ལྔ་ཉོས་ནས་དེ་ཚོ་ཚོད་ལྟ་བྱེད་པའི་ཆེད་དུ་འགྲོ་དགོས་པས་དགོངས་དག་ཞུ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ཡང་གཞན་ཞིག་གིས་ངས་ད་ལྟ་བག་མ་བླངས་པས་ཡོང་མི་ཐུབ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","གཡོག་པོ་དེ་ཕྱིར་ལོག་པ་དང་ཁྱིམ་བདག་ལ་གཏམ་དེ་བཤད། ཁྱིམ་བདག་ཁྲོས་ཏེ་གཡོག་པོར། གྲོང་ཁྱེར་གྱི་སྲང་ལམ་ལ་མགྱོགས་པོར་སོང་ལ། དབུལ་པོ་དང༌། དབང་པོ་སྐྱོན་ཅན། ཞ་བོ། ལོང་བ་ལ་སོགས་པའི་མི་རྣམས་འདི་རུ་ཁྲིད་དེ་ཤོག་ཅིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","དེའི་རྗེས་སུ་གཡོག་པོས་སྐུ་ཞབས་ལགས། ཁྱེད་ཀྱིས་བཀའ་མངག་མཛད་པ་དེ་གྲུབ་ནས་ད་དུང་སྡོད་ས་སྟོང་པ་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ཁྱིམ་བདག་གིས་གཡོག་པོར་“ངའི་ཁང་པ་སྟོང་པ་མེད་པར་བྱེད་པའི་ཕྱིར་གཞུང་ལམ་དང་གྲོང་གསེབ་ལ་སོང་ནས་དེ་ཚོ་འདིར་ཡོང་དུ་འཇུག ");
INSERT INTO bod_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ངས་ཁྱོད་ཚོར་ཟེར་རྒྱུར། སྔར་སྟོན་ལ་བོས་པ་རྣམས་ཀྱི་ནང་ནས་མི་སུ་ཞིག་ཀྱང་དགོངས་ཟས་བྲོ་བ་མྱོང་བར་མི་འགྱུར་ཞེས་སྨྲས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","མི་ཚོགས་ཤིན་ཏུ་མང་པོ་ཞིག་ཁོང་དང་མཉམ་དུ་སོང་བ་དང༌། ཁོ་ཚོར་ཞལ་ཕྱིར་བསྐོར་ཏེ་ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“སུ་ཡང་ངའི་རྩར་ཡོང་བ་དང༌། ང་ལས་ཕའམ། མ། བཟའ་ཟླ། ཕྲུ་གུ མིང་སྲིང་དང༌། ཐ་ན་རང་ཉིད་ཀྱི་སྲོག་ལས་ཀྱང་གཅེས་པར་བཟུང་ན། དེ་ངའི་ཉེ་གནས་ཡིན་པར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","སུས་ཀྱང་རང་གི་རྒྱང་ཤིང་མ་འཁུར་བར་ང་ཡི་རྗེས་སུ་འབྲང་མཁན་དེ་ངའི་ཉེ་གནས་ཡིན་པར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","དཔེར་ན། ཁྱེད་རྣམས་ལས་མི་སུ་ཞིག་གིས་ཐོག་བརྩེགས་ཁང་རྩིག་པར་འདོད་ན། སྔོན་ལ་བསྡད་ནས་དེ་སྒྲུབ་པའི་ཕྱིར་འགྲོ་གྲོན་མི་རྩི་བའམ། ");
INSERT INTO bod_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","དེ་མིན་ན་རྨང་གཞི་ཚར་ནས་སྒྲུབ་མི་ཐུབ་པས་དེ་མཐོང་མཁན་ཐམས་ཅད་ཀྱིས་ཁོ་ལ་འཕྱ་དམོད་བྱེད་དེ། ");
INSERT INTO bod_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","མི་དེས་ལས་ཀ་འགོ་འཛུགས་ནའང་སྒྲུབ་པར་མི་ཐུབ་ཅེས་ཟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ཡང་ན་རྒྱལ་པོ་ཞིག་ལ་དམག་མི་ཁྲི་གཅིག་ཡོད་དེ་དམག་མི་ཁྲི་གཉིས་ཡོད་པའི་རྒྱལ་པོ་གཞན་པར་དམག་འདྲེན་ན། ཕར་རྒོལ་བྱེད་མཁན་ལས་རྒྱལ་བ་འཐོབ་མི་ཐུབ་པ་ཁོས་ཐོག་མར་བསྡད་ནས་རྩིའམ། ");
INSERT INTO bod_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","དེ་ལྟར་མིན་ན། ཕར་རྒོལ་བྱེད་མཁན་ད་དུང་ཐག་རིང་པོ་ཡོད་པའི་ཚེ་ཞི་མཐུན་ཞུ་བའི་ཕྱིར་ཁོས་ཕོ་ཉ་འགའ་གཏོང༌། ");
INSERT INTO bod_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","དེའི་ཕྱིར་ཁྱེད་ཚོའི་ནང་ནས་མི་སུ་ཞིག་གིས་ཅི་ཡོད་པ་ཐམས་ཅད་མི་སྤངས་ན་ངའི་ཉེ་གནས་ཡིན་པར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ཚྭ་ནི་ཡག་པོ་ཡིན་ཀྱང་ཚྭའི་བྲོ་བ་ཡལ་ན། དེའི་བྲོ་བ་གང་གིས་གསོ་བར་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ས་རྒྱུར་རམ་ལུད་ཕུང་ལ་ཡང་མི་ཕན་པས་དེ་ཚོས་ཕྱི་རུ་དབྱུག རྣ་བ་ཡོད་པ་རྣམས་ཀྱིས་ཉོན་ཅིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ཁོང་གི་གསུང་ལ་ཉན་པའི་ཕྱིར་ཁྲལ་སྡུད་མཁན་དང་སྡིག་ཅན་མང་པོ་ཞིག་ཁོང་གི་མདུན་དུ་ཡོང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ཡིད་མ་རངས་པའི་གཏམ་བྱེད་བཞིན་ཡོད་དེ་“མི་འདིས་སྡིག་ཅན་རྣམས་བསུས་ནས་ཁོ་ཚོ་དང་མཉམ་དུ་ཟ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","དེའི་ཕྱིར་དཔེའི་སྒོ་ནས་ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ཁྱེད་ཚོའི་ནང་ནས་སུ་ཞིག་ལ་ལུག་བརྒྱ་ཡོད་པ་ལས་ལུག་གཅིག་བརླགས་ན། དགུ་བཅུ་གོ་དགུ་པོ་རྩྭ་ཐང་ལ་བཞག་ནས་བརླག་པ་དེ་མ་རྙེད་པའི་བར་དུ་མི་འཚོལ་ལམ། ");
INSERT INTO bod_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ལུག་བརླག་པ་དེ་རྙེད་རྗེས་དགའ་བའི་ངང་ནས་རང་གི་དཔུང་པར་འཁུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ནང་ལ་སླེབས་རྗེས་གྲོགས་པོ་དང་ཁྱིམ་མཚེས་བོས་ནས་ཁོ་ཚོར་ང་དང་མཉམ་དུ་དགའ་སྤྲོ་གྱིས་དང༌། གང་ལགས་ཟེར་ན། ངའི་ལུག་བརླག་པ་དེ་རྙེད་པའི་ཕྱིར་རོ་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། དེ་ལྟར་སེམས་བསྒྱུར་བར་མི་དགོས་པའི་མི་སེམས་དྲང་པོ་དགུ་བཅུ་གོ་དགུ་པོ་ལས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་སྡིག་ཅན་གཅིག་གི་དོན་དུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ལྷག་པར་དགའ་བར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ཡང་ན་བུད་མེད་སུ་ཞིག་ལ་དངུལ་ཊམ་ཀ་བཅུ་ཡོད་པ་ལས་གཅིག་བརླགས་ན། བརླག་པ་དེ་མ་རྙེད་པའི་བར་དུ་མར་མེ་སྤར་ནས་ཁང་པ་གད་བརྒྱབ་སྟེ་གཟབ་ནན་ཆེན་པོས་མི་འཚོལ་ལམ། ");
INSERT INTO bod_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","བརླག་པ་དེ་རྙེད་ནས་གྲོགས་མོ་དང་ཁྱིམ་མཚེས་བོས་ནས་ཁོ་ཚོར་ང་དང་མཉམ་དུ་དགའ་སྤྲོ་གྱིས་དང༌། གང་ལགས་ཟེར་ན། ངའི་དངུལ་ཊམ་ཀ་བརླག་པ་དེ་རྙེད་པའི་ཕྱིར་རོ་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། དེ་ལྟར་སྡིག་ཅན་གཅིག་གིས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བས་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་ཀྱི་མདུན་དུ་དགའ་སྤྲོ་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ཡང་ཁོང་གིས་“མི་ཞིག་ལ་བུ་གཉིས་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ཆུང་བ་ཡིས་ཁོའི་ཕ་ལ། ཡབ་ལགས། ང་ལ་འཐོབ་རྒྱུ་ཡིན་པའི་ནོར་སྐལ་གནང་རོགས་ཞེས་ཟེར་བས་ཕ་ཡིས་བུ་གཉིས་ལ་རང་གི་ནོར་བགོ་བཤའ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ཉིན་མང་པོ་མ་ལོན་པར་བུ་ཆུང་བ་ཡིས་ཅི་ཡོད་པ་ཐམས་ཅད་བསྡུས་ནས་ཡུལ་ཐག་རིང་པོ་ཞིག་ལ་སོང༌། དེར་ཁོས་བྱ་སྤྱོད་ངན་པ་སྣ་ཚོགས་ཀྱི་ཐོག་ནས་ནོར་སྐལ་འཕྲོག་བརླག་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","རྒྱུ་ནོར་ཚང་མ་རྫོགས་ནས་ཡུལ་དེར་མུ་གེ་ཚབས་ཆེན་བྱུང་བས། ཁོ་བཀྲེས་སྐོམ་གྱིས་མནར་ཏེ་དབུལ་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","དེའི་ཕྱིར་ཁོ་ཕྱིན་ནས་ཡུལ་དེའི་ཁྱིམ་བདག་གཅིག་ལ་བརྟེན་པས། དེས་ཕག་པ་འཚོ་བའི་ཕྱིར་ཁོ་ཞིང་ཐང་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","སུས་ཀྱང་ཁོ་ལ་ཟ་རྒྱུ་ཅི་ཡང་མ་སྟེར་བས་ཁོ་ལྟོགས་ཏེ་ཕག་པས་ཟ་བའི་གང་བུ་ཡང་ཟ་འདོད་ཆེན་པོ་ལངས། ");
INSERT INTO bod_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","དེ་ནས་བློ་ཁུག་སྟེ་ཁོས་ངའི་ཕ་ཡི་གཡོག་པོ་རྣམས་ལ་བག་ལེབ་ཟ་རྒྱུ་ཡོད་པ་མ་ཟད་བསག་རྒྱུ་ཡང་ཡོད། འོན་ཀྱང་ཡུལ་འདིར་ང་ལྟོགས་ནས་ཤི་གྲབས་འདུག ");
INSERT INTO bod_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ང་ཡར་ལངས་ཏེ་ཕའི་རྩར་ཕྱིན་ནས་ཁོང་ལ། ཕ་ལགས། ངས་དཀོན་མཆོག་གི་ཞིང་ཁམས་དང་ཁྱེད་ལ་སྡིག་ཉེས་བྱས་པས། ");
INSERT INTO bod_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ང་ནི་ཁྱེད་ཀྱི་སྲས་ཞེས་ཟེར་བ་མི་འོས་ཏེ་ང་ཁྱེད་ཀྱི་གླ་པ་ཞིག་དང་འདྲ་བར་མཛོད་ཅེས་ཟེར་བར་བྱ་སྙམ། ");
INSERT INTO bod_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ཁོ་ལངས་ནས་ཕའི་རྩར་སོང༌། འོན་ཀྱང་ཕ་ཡིས་རྒྱང་རིང་ནས་ཁོ་མཐོང་བ་དང༌། སྙིང་རྗེ་སྐྱེས་ནས་བུའི་མདུན་དུ་བརྒྱུགས་པ་དང༌། ཁོ་ལ་འཐམ་སྟེ་འོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","བུ་ཡིས་ཁོང་ལ། ཕ་ལགས། ངས་དཀོན་མཆོག་གི་ཞིང་ཁམས་དང་ཁྱེད་ལ་སྡིག་ཉེས་བྱས་པས་ང་ནི་ཁྱེད་ཀྱི་བུ་ཞེས་འབོད་པར་མི་འོས་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","འོན་ཀྱང་ཕ་ཡིས་ཁོའི་གཡོག་པོ་ཚོར། ཕྱུ་པ་ཡག་ཤོས་མགྱོགས་པོར་འཁྱེར་ནས་གཡོགས་ལ། ཁོའི་མཛུབ་མོར་སོར་གདུབ་དང༌། རྐང་པར་ལྷམ་གཡོགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","བེའུ་རྒྱགས་པ་དེ་འདིར་ཁྲིད་ནས་སོད། ང་ཚོས་ཟ་ཞིང་དགའ་སྟོན་བྱེད་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","གང་ལགས་ཤེ་ན། ངའི་བུ་འདི་ཤི་ནས་སླར་གསོན་པོར་གྱུར་ཞིང༌། བརླགས་ནས་རྙེད་པར་གྱུར་བས་སོ་ཞེས་བཤད་རྗེས་ཁོ་ཚོས་སྐྱིད་པོ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","དེའི་རིང་ལ་ཁོའི་བུ་རྒན་པ་ཞིང་ཁར་ཡོད་པ་དང༌། ཁོ་ཕྱིར་ལོག་སྟེ་ཁང་པར་སླེབས་པའི་ཚེ་རོལ་མོ་དང་ཞབས་བྲོའི་སྒྲ་ཐོས་པས། ");
INSERT INTO bod_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","གཡོག་པོ་ཞིག་བོས་ནས་དེ་ཅི་ཡིན་ཞེས་སྐད་ཆ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","གཡོག་པོ་དེས་ཁྱེད་ཀྱི་གཅུང་པོ་སྐུ་ཁམས་བཟང་པོར་སླེབས་པས་ཁྱེད་ཀྱི་ཡབ་ཀྱིས་བེའུ་རྒྱགས་པ་བསད་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","དེ་ཐོས་ནས་ཁྲོས་ཏེ་ཁོ་འཛུལ་བར་མ་དགའ། ཁོའི་ཕ་ཕྱི་རོལ་ཏུ་ཡོང་ནས་ཁོ་ནང་དུ་འཛུལ་བར་རེ་འབོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ཁོས་ཁོའི་ཕ་ལ། གཟིགས་དང༌། ཁྱེད་ཀྱི་བཀའ་ལས་ནམ་ཡང་མ་འགལ་ཏེ་ལོ་འདི་འདྲ་མང་པོའི་རིང་ལ་ངས་གཡོག་པོ་ལྟར་ལས་ཀ་བྱས་ཀྱང༌། ངའི་གྲོགས་པོ་དང་མཉམ་དུ་དགའ་སྟོན་བྱེད་པའི་ཕྱིར་ཁྱེད་ཀྱིས་ར་ཕྲུག་ཙམ་ཡང་ང་ལ་གནང་མ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","འོན་ཀྱང་ཁྱེད་ཀྱི་བུ་ཟེར་བ་དེ་སྨད་འཚོང་མ་རྣམས་དང་མཉམ་དུ་ཁྱེད་ཀྱི་རྒྱུ་ནོར་ཆུད་ཟོས་གཏོང་མཁན་ཡོང་སྐབས་ཁྱེད་ཀྱིས་ཁོའི་དོན་ལ་བེའུ་རྒྱགས་པ་བསད་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ཕ་ཡིས་ཁོ་ལ། ངའི་བུ། ཁྱོད་དུས་རྒྱུན་དུ་ང་དང་མཉམ་དུ་ཡོད་པས། ང་ལ་ཅི་ཡོད་པ་ཐམས་ཅད་ཁྱོད་ཀྱི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","འོན་ཀྱང་ང་ཚོས་སྤྲོ་སེམས་ཀྱིས་དགའ་སྟོན་བྱེད་དགོས། གང་ལགས་ཟེར་ན། ཁྱོད་ཀྱི་ནུ་བོ་འདི་ཤི་ནས་སླར་གསོན་པོར་གྱུར་ཞིང༌། བརླགས་ནས་རྙེད་པར་གྱུར་ཟེར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","དེ་ནས་ཡེ་ཤུས་ཉེ་གནས་རྣམས་ལ་“མི་ཕྱུག་པོ་ཞིག་ལ་གཉེར་པ་ཞིག་ཡོད་དེ། ཁོའི་རྒྱུ་ནོར་གཉེར་པས་འཕྲོ་བརླག་གཏོང་ཞེས་པའི་གཏམ་ཐོས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","གཉེར་པ་བོས་ནས་མི་ཕྱུག་པོས་ཁོ་ལ། ཁྱོད་ཀྱི་སྐོར་གཏམ་འདི་ཅི་ཡིན། ད་ནས་བཟུང་ཁྱོད་གཉེར་པའི་ལས་བྱེད་མི་ཆོག་པས་རྩིས་དག་ཞུ་ཞིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","གཉེར་པས། བདག་པོས་ང་ཕྱིར་འབུད་པས་ཅི་བྱེད་པར་བྱ། ས་རྐོ་བའི་སྟོབས་ཤུགས་ནི་མེད། སློང་བར་ནི་ངོ་ཚ། ");
INSERT INTO bod_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ང་ཕྱིར་འབུད་པའི་རྗེས་སུ་མི་རྣམས་ཀྱིས་ཁོ་ཚོའི་ཁྱིམ་ཚང་ལ་ང་བསུ་བའི་ཆེད་དུ་ཅི་བྱེད་པར་ངས་ཤེས་སོ་སྙམ། ");
INSERT INTO bod_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ཁོའི་བདག་པོའི་བུ་ལོན་ལེན་མཁན་རེ་རེ་བཞིན་བོས་ནས་ཁོས་བུ་ལོན་ལེན་མཁན་དང་པོ་ལ། ཁྱེད་ཀྱིས་ངའི་བདག་པོར་འཇལ་དགོས་པའི་བུ་ལོན་ཇི་ཙམ་ཡོད་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ལན་དུ་ཁོས་སྣུམ་རྫ་སྣོད་བརྒྱ་ཐམ་པའི་བུ་ལོན་ཡོད་ཅེས་སྨྲས་པ་དང༌། གཉེར་པས་རྩིས་ཁྲ་ལོངས་ལ་མགྱོགས་པོ་མར་བསྡད་ནས་ལྔ་བཅུ་བྲིས་ཤིག་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ཡང་མི་གཞན་པར་ཁྱེད་ལ་བུ་ལོན་ཇི་ཙམ་ཡོད་ཅེས་དྲིས་པ་དང་མི་དེས་གྲོ་བྲེ་བརྒྱ་ཡོད་ཅེས་བཤད། གཉེར་པས་རྩིས་ཁྲ་ལོངས་ལ་བརྒྱད་བཅུ་བྲིས་ཤིག་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","བདག་པོས་དྲང་པོ་མེད་པའི་གཉེར་པས་མགོ་གྲུང་པོའི་ངང་ནས་ལས་བསྒྲུབས་པར་བསྟོད་ར་བྱས། གང་ལགས་ཤེ་ན། འོད་ཀྱི་བུ་རྣམས་ལས་རང་དང་འདྲ་བ་རྣམས་ཀྱི་ཁྲོད་དུ་འཇིག་རྟེན་འདིའི་བུ་ཚོས་སོ་སོའི་དོན་སྒྲུབ་པར་མཁས་པར་ཆེ། ");
INSERT INTO bod_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། འཇིག་རྟེན་འདིའི་ལོག་པའི་ནོར་གྱིས་གྲོགས་པོ་སྒྲིགས། དེ་རྫོགས་སྐབས་རྟག་པའི་གནས་སར་མི་དེ་ཚོས་ཁྱེད་བསུ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","སུ་ཡང་དོན་ཆུང་བ་ལ་བློ་གཏད་ཆོག་ཡིན་པ་དེ་དོན་ཆེན་པོ་ལའང་བློ་གཏད་ཆོག་པ་ཡིན། སུ་ཡང་དོན་ཆུང་བ་ལ་དྲང་པོ་མིན་པ་དེ་དོན་ཆེན་པོ་ལའང་དྲང་པོ་མིན། ");
INSERT INTO bod_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","དེའི་ཕྱིར་ཁྱེད་ནི་འཇིག་རྟེན་འདིའི་ལོག་པའི་ནོར་ལ་བློ་གཏད་ཆོག་པ་མ་ཡིན་ན། སུས་ཁྱེད་ལ་བདེན་པའི་རྒྱུ་ནོར་འཆོལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","གང་ཞིག་གཞན་ལ་ཡོད་པར་ཁྱེད་བློ་གཏད་ཆོག་པ་མ་ཡིན་ན། རང་ལ་བདག་འོས་པའི་ནོར་དེ་སུས་སྟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","གཡོག་པོ་ཞིག་གིས་བདག་པོ་གཉིས་ལ་གཡོག་བྱེད་མི་སྲིད། གང་ལགས་ཤེ་ན། ཁོས་གཅིག་ལ་སྡང་ཞིང་གཅིག་ལ་གཅེས་པའམ། ཁོས་གཅིག་ལ་ཆགས་ཤིང་གཅིག་ལ་སྨད་པར་བྱེད། ཁྱེད་ཚོས་དཀོན་མཆོག་དང་རྒྱུ་ནོར་གཉིས་ཀའི་གཡོག་བྱེད་མི་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","རྒྱུ་ནོར་ལ་ཆགས་པའི་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་དོན་དེ་ཚོ་ཐམས་ཅད་ཐོས་ནས་ཁོང་ལ་འཕྱ་དམོད་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ཁོང་གིས་ཁོ་ཚོར་“མི་རྣམས་ཀྱི་མདུན་དུ་ཁྱོད་ཚོ་དྲང་པོ་ཡིན་ཚུལ་སྟོན། འོན་ཀྱང་དཀོན་མཆོག་གིས་ཁྱོད་ཀྱི་སེམས་མཁྱེན། མི་རྣམས་ཀྱིས་གང་བརྩི་བཀུར་བྱེད་པ་དེ་དཀོན་མཆོག་གི་སྤྱན་སྔར་སྐྱུག་བྲོ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","བཀའ་ཁྲིམས་དང་ལུང་སྟོན་པའི་བཀའ་གཉིས་ནི་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་བར་དུ་བསྒྲགས་མྱོང༌། དུས་དེ་ནས་བཟུང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་སྒྲོག་བཞིན་ཡོད་པ་དང༌། མི་ཐམས་ཅད་དེའི་ནང་དུ་འཛུལ་བར་ནན་གྱིས་བརྩོན། ");
INSERT INTO bod_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","འོན་ཀྱང་བཀའ་ཁྲིམས་ཀྱི་ཚེག་གཅིག་འཇིག་པ་ལས་ནམ་མཁའ་དང་ས་གཉིས་འཇིག་པ་སླའོ། ");
INSERT INTO bod_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","སུས་ཀྱང་རང་གི་བཟའ་ཟླ་བཞག་ནས་བུད་མེད་གཞན་ཞིག་བཟའ་ཟླར་བླངས་ན་ལོག་གཡེམ་བྱེད་པ་དང༌། བཟའ་ཚང་ཁ་བྲལ་མྱོང་བའི་བུད་མེད་གཅིག་བཟའ་ཟླར་ལེན་མཁན་དེ་ནི་ལོག་པར་གཡེམ་པའོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ཡང་ཡེ་ཤུས་“རས་སྤུས་ལེགས་མདོག་རྒྱ་སྨུག་ཅན་གྱི་གྱོན་ཆས་གྱོན་པའི་མི་ཕྱུག་པོ་ཞིག་ཡོད་པ་དང༌། ཁོས་ཉིན་ལྟར་རྒྱས་སྤྲོས་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ཡང་ལཱ་ཟར་ཞེས་པ་ནི་ལུས་ཡོངས་སུ་པགས་ནད་ཀྱི་རྨ་ཡིས་ཁྱབ་པའི་དབུལ་པོ་ཞིག་ཡིན་ཏེ། ཁོ་མི་ཕྱུག་པོའི་གནས་ཁང་གི་རྒྱལ་སྒོར་བཞག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","མི་ཕྱུག་པོའི་ཅོག་ཙེ་ནས་ས་ལ་ལྷུང་བའི་ཟས་སྙིགས་ཆུང་ཆུང་ཟ་བར་འདོད་ཅིང༌། ཁྱིས་ཀྱང་ཡོང་ནས་ཁོའི་རྨ་བལྡགས། ");
INSERT INTO bod_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","དབུལ་པོ་དེ་ཤི་ནས་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་ཀྱིས་མེས་པོ་ཨབ་ར་ཧམ་གྱི་དྲུང་དུ་བསྐྱལ་བ་དང༌། མི་ཕྱུག་པོའང་ཤི་ནས་དུར་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","དམྱལ་ཁམས་སུ་སྡུག་བསྔལ་ཆེན་པོ་མྱོང་སྟེ་ཕྱུག་པོས་ཡར་བལྟས་ནས་ཨབ་ར་ཧམ་དང་ཁོང་གི་དྲུང་དུ་སྡོད་མཁན་ལཱ་ཟར་ཐག་རིང་ནས་མཐོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","སྐད་ཆེན་པོས། ཡབ་ཨབ་ར་ཧམ་ལགས། ང་ལ་ཐུགས་རྗེས་གཟིགས། མེ་འདིའི་ནང་སྡུག་བསྔལ་ཆེན་པོ་མྱོང་བས་ངའི་ལྕེ་བསིལ་བར་བྱེད་པའི་ཕྱིར་ལཱ་ཟར་གྱི་མཛུབ་མོའི་རྩེ་ཆུར་བཅུག་ནས་མངག་པར་མཛོད་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ཨབ་ར་ཧམ་གྱིས། ངའི་བུ། གསོན་པའི་དུས་སུ་ཁྱོད་ནི་བཟང་པོ་དང་ལཱ་ཟར་སྡུག་པོ་ཐོབ་པ་དེ་དྲན་པར་གྱིས་ཤིག ད་འདི་རུ་ཁོ་སེམས་གསོ་བར་འགྱུར་བ་དང༌། ཁྱོད་སྡུག་བསྔལ་མྱོང་བཞིན་ཡོད་པ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","འདི་ནས་ཁྱོད་ཀྱི་རྩར་འགྲོ་འདོད་པ་དང༌། དེ་ནས་ང་ཚོའི་མདུན་དུ་ཡོང་འདོད་ཀྱང་བརྒལ་མི་སྲིད་པའི་ཕྱིར་ང་ཚོ་དང་ཁྱོད་ཀྱི་བར་ལ་གཡང་ས་ཆེན་པོ་ཞིག་འདུག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ཕྱུག་པོས་ཞུ་བ་ཞུས་ཏེ། ཡབ་ལགས། ལཱ་ཟར་ངའི་ཕའི་ཁང་པར་མངག་པར་མཛོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","གང་ལགས་ཤེ་ན། ང་ལ་སྤུན་ལྔ་ཡོད། ལཱ་ཟར་གྱིས་ཁོ་ཚོར་ཐ་ཚིག་བསྒྲགས་ན་ཁོ་ཚོའང་སྡུག་བསྔལ་ཆེན་པོའི་གནས་འདིར་མི་ཡོང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","འོན་ཀྱང་ཨབ་ར་ཧམ་གྱིས། ཁོ་ཚོར་མོ་ཤེ་དང་ལུང་སྟོན་པའི་བཀའ་ཡོད་པས་ཁོ་ཚོས་དེ་ལ་ཉན་དགོས་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ཕྱུག་པོས། ཡབ་ཨབ་ར་ཧམ་ལགས། གལ་ཏེ་གཤིན་པོ་རྣམས་ལས་སུ་ཞིག་ཁོ་ཚོའི་རྩར་སོང་ན་ཁོ་ཚོས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་རོ་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ཨབ་ར་ཧམ་གྱིས་ཁོ་ལ་མོ་ཤེ་དང་ལུང་སྟོན་པའི་བཀའ་ལ་མ་ཉན་ན་གཤིན་པོ་རྣམས་ལས་སུ་ཞིག་ལངས་ན་ཡང་ཡིད་མི་ཆེས་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ཡེ་ཤུས་ཉེ་གནས་རྣམས་ལ་“སླུ་བའི་རྒྱུ་མི་འབྱུང་བར་མི་སྲིད། འོན་ཀྱང་སླུ་བར་བྱེད་མཁན་ལ་ཆད་པ་ཕོག་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ཆུང་ངུ་འདི་རྣམས་ལས་གཅིག་སླུ་བར་བྱེད་པ་ལས་མི་དེ་ཉིད་ཀྱི་སྐེ་ལ་རང་འཐག་གི་རྡོ་ཆེན་པོ་ཞིག་བཏགས་ནས་རྒྱ་མཚོའི་ནང་དུ་དབྱུགས་ན་ཁོ་ལ་ལེགས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","དོགས་ཟོན་གྱིས་ཤིག ཁྱེད་ཀྱི་སྤུན་གྱིས་ཉེས་པ་བྱས་ན་ཁོ་ལ་བཀའ་བཀྱོན་གཏོང་ཞིག གལ་ཏེ་ཁོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་ན་གུ་ཡངས་གཏོང་ཞིག ");
INSERT INTO bod_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ཡང་ཉིན་གཅིག་ལ་ཁོས་ཁྱེད་ལ་ཉེས་པ་ལན་བདུན་བྱས་ནས་ངས་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་ཞེས་ལན་བདུན་བཤད་དེ་ཁྱེད་རྩར་ཕྱིར་ལོག་ན་གུ་ཡངས་གཏོང་དགོས་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","སྐུ་ཚབ་རྣམས་ཀྱིས་གཙོ་བོ་ལ་“ང་ཚོའི་དད་སེམས་འཕེལ་བར་མཛོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","གཙོ་བོས་“གལ་སྲིད་ཁྱེད་ཀྱི་དད་སེམས་ཡུངས་འབྲུ་རྡོག་པོ་ཆུང་ངུ་གཅིག་ཙམ་ཡོད་ན་ཁྱེད་ཀྱིས་ཤིང་སྡོང་ཆེན་པོ་འདི་ལ། རང་གིས་རང་རྩ་བཀོག་བཏང་ནས་རྒྱ་མཚོར་འཚུགས་པར་འགྱུར་ཞིག་ཅེས་སྨྲས་ན་དེས་ཁྱེད་ཀྱི་བཀའ་ལ་ཉན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","སུ་ཞིག་ལ་ཞིང་རྨོ་བའམ། ལུག་འཚོ་བཞིན་པའི་གཡོག་པོ་ཞིག་ཡོད་ན་དེ་ཁྱིམ་ཚང་ལ་སླེབས་པའི་རྗེས་སུ་ཁོ་ལ། ལམ་སེང་ཚུར་ཤོག་ལ་ཟས་ཟ་རུ་སྡོད་ཅིག་ཅེས་ཟེར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ཡང་ན་ཁོ་ལ་ངའི་དགོང་ཟས་གྲ་སྒྲིག་གྱིས་ལ་སྐེད་རགས་ཆིངས་ནས་ངས་བཟའ་བཏུང་བྱེད་དུས་ང་ལ་གཡོག་བྱོས་ཤིག དེ་ནས་ཁྱོད་ཟ་འཐུང་བྱེད་ཆོག་ཅེས་མི་ཟེར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","གཡོག་པོས་བཀའ་ལྟར་བསྒྲུབ་པས་ཁྱིམ་བདག་གིས་ཁོ་ལ་ཐུགས་རྗེ་ཆེ་ཞེས་ཟེར་བར་འགྱུར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","དེ་བཞིན་དུ་བཀོད་པ་བཏང་བའི་ལས་ཚང་མ་ཁྱོད་ཀྱིས་ཀྱང་བསྒྲུབས་ཚེ། ང་ཚོ་ཕན་མེད་ཀྱི་གཡོག་པོ་ཡིན་ཏེ། ང་ཚོས་བྱེད་འོས་པའི་ལས་ཁོ་ན་བྱས་པ་ཡིན་ཞེས་ཟེར་དགོས་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ཡེ་རུ་ཤ་ལེམ་གྱི་ལམ་བར་དུ་ཁོང་ས་མར་ཡཱ་ཡུལ་དང་ག་ལིལ་ཡུལ་གྱི་ས་མཚམས་བརྒྱུད་ནས་ཕེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","གྲོང་གསེབ་གཅིག་དང་ཉེ་བར་ཕེབས་ཚེ་མཛེ་ནད་ཅན་གྱི་མི་བཅུ་ཐག་རིང་ན་ལངས་བསྡད་དེ་ཁོང་དང་མཇལ། ");
INSERT INTO bod_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ཁོ་ཚོས་སྐད་ཆེན་པོས་“སྟོན་པ་ཡེ་ཤུ་ལགས། ང་ཚོ་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ཁོ་ཚོ་གཟིགས་ནས་ཁོང་གིས་ཁོ་ཚོར་“སོང་ལ་རང་གི་ལུས་ཡ་ཧུ་དཱ་པའི་བླ་མར་སྟོན་”ཞེས་གསུངས་ནས་ལམ་བར་དུ་གསོས་ཏེ་ཐམས་ཅད་དག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ནད་དག་པ་མཐོང་སྟེ་ཁོ་ཚོ་ལས་མི་གཅིག་ཕྱིར་ལོག་ནས་སྐད་ཆེན་པོས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ཡེ་ཤུའི་མདུན་དུ་ཕྱག་འཚལ་བ་དང༌། ཁོང་ལ་བཀའ་དྲིན་ཆེ་ཞེས་ཞུས། ཁོ་ནི་ས་མར་ཡཱ་པ་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","དེ་ནས་ཡེ་ཤུས་“མི་བཅུ་པོ་མཛེ་ནད་ལས་དག་པར་མ་གྱུར་རམ། གཞན་དགུ་པོ་དེ་ཚོ་གང་དུ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ཕྱི་པ་འདི་ལས་དཀོན་མཆོག་ལ་བསྟོད་པ་འབུལ་མཁན་གཞན་སུ་ཡང་མེད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ཡང་ཁོང་གིས་ཁོ་ལ་“ཡར་ལངས་ནས་སོང་དང༌། ཁྱོད་ཀྱི་དད་པས་ཁྱོད་རང་ཐར་བར་བྱས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ཁོང་ལ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འབྱུང་བའི་དུས་ཀྱི་སྐོར་ལ་སྐད་ཆ་དྲིས་པ་ན། ཁོང་གིས་མི་དེ་ཚོར་“དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནི་མིག་གིས་མཐོང་ཐུབ་པའི་ལུགས་སུ་མི་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","མི་རྣམས་ཀྱིས། ལྟོས་ཤིག་འདི་རུ་ཡོད་པའམ། ཡང་ན་དེར་ཡོད་ཅེས་མི་ཟེར། གང་ཡིན་ཞེ་ན། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཁྱེད་ཚོའི་ཁྲོད་དུ་ཡོད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","དེ་ནས་ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་“མིའི་རིགས་ཀྱི་བུ་ཡི་ཉིན་མོ་ལས་གཅིག་མཐོང་བར་འདོད་པའི་དུས་ལ་འབབ་ཡོང་ན་ཡང༌། ཁྱེད་ཚོས་དེ་མཐོང་བར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","མི་དེ་ཚོས། འདིར་ལྟོས་ཤིག་གམ། ཡང་ན་དེར་ལྟོས་ཤིག་ཅེས་ཟེར་རྒྱུ་ཡིན། དེར་མ་སོང་ལ་དེ་ཚོའི་རྗེས་སུ་མ་འབྲོངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","རྒྱུ་མཚན་ནི་གློག་འཁྱུག་ནམ་མཁའི་ཕྱོགས་གཅིག་ནས་གཞན་པར་འོད་འཕྲོ་བ་ལྟར། དེ་ལྟར་མིའི་རིགས་ཀྱི་བུའང་ཁོང་གི་ཉིན་མོར་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","འོན་ཀྱང་དེའི་སྔོན་ལ་ཁོང་སྡུག་བསྔལ་མང་པོ་མྱོང་དགོས་པ་དང༌། མི་རབས་འདིས་ཁོང་འདོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ཡང་མེས་པོ་ནོ་ཨ་ཡི་དུས་ལ་བྱུང་བ་ལྟར། མིའི་རིགས་ཀྱི་བུ་ཡི་དུས་ལ་ཡང་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ནོ་ཨ་གྲུ་ཆེན་གྱི་ནང་དུ་མ་ཞུགས་པའི་བར་དུ་ཁོ་ཚོས་བཟའ་བ་དང་བཏུང་ཞིང༌། བག་མ་གཏོང་ལེན་བྱེད་བཞིན་ཡོད། དེ་ནས་ཆུ་ལོག་ཆེན་པོ་བྱུང་ནས་ཁོ་ཚོ་ཚང་མ་འཇིག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","དེ་བཞིན་དུ་མེས་པོ་ལོཌ་ད་ཞེས་ཟེར་མཁན་གྱི་དུས་སུ་ཡང་བྱུང༌། མི་རྣམས་ཀྱིས་བཟའ་བ་དང་བཏུང་ཞིང༌། ཉོ་འཚོང༌། ས་བོན་འདེབས་ལས། ཁང་པ་རྩིག་པ་ལ་སོགས་པའི་ལས་ཀ་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","འོན་ཀྱང་ལོཌ་ད་སཱ་དོམ་གྲོང་ཁྱེར་ནས་ཕྱིར་ཐོན་པའི་ཉིན་མོར་མེ་དང་མུ་ཟི་ནམ་མཁའ་ནས་བབས་པས་དེ་ཚོ་ཚང་མ་འཇིག་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","མིའི་རིགས་ཀྱི་བུ་མངོན་པར་འགྱུར་བའི་ཉིན་མོར་ཡང་དེ་ལྟར་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ཉིན་མོ་དེར་ཁང་པའི་ཐོག་ཁར་ཡོད་མཁན་རང་གི་ཅ་ལག་ཕར་འཁྱེར་བའི་ཕྱིར་མར་མ་འགྲོ དེ་བཞིན་དུ་ཞིང་ཁར་ཡོད་པ་ཕྱིར་མ་ལོག ");
INSERT INTO bod_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ལོཌ་ད་ཡི་བཟའ་ཟླ་དྲན་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","སུ་ཡང་རང་གི་སྲོག་ལ་ཆགས་པ་དེ་བརླག་པར་འགྱུར། སུ་ཡང་རང་གི་སྲོག་བཏང་ན་དེ་སྐྱོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཉིན་དེའི་མཚན་མོར་ཉལ་ཁྲི་ཞིག་ལ་མི་གཉིས་ཡོད་པ་ལས། གཅིག་ལེན་གཅིག་འབོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ས་ཆ་གཅིག་ལ་བུད་མེད་འབྲུ་འཐག་མཁན་གཉིས་ཡོད་པ་ལས། གཅིག་ལེན་གཅིག་འབོར་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ལན་དུ་ཁོ་ཚོས་“གཙོ་བོ། གང་དུ་འབྱུང་བར་འགྱུར་”ཞེས་ཞུས། ཁོང་གིས་ཁོ་ཚོར་“ཕུང་པོ་ཡོད་སར་བྱ་རྒོད་འཛོམ་པར་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","དེའི་རྗེས་སུ་དེ་རྣམས་ཡིད་མི་ཞུམ་པར་སྨོན་ལམ་ཡང་ཡང་འདེབས་དགོས་པ་སྟོན་པའི་ཕྱིར་དཔེའི་སྒོ་ནས་འདི་ལྟར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“གྲོང་ཁྱེར་ཞིག་ལ་དཀོན་མཆོག་གམ། ཡང་ན་མི་རྣམས་ལ་མི་བཀུར་བའི་ཁྲིམས་དཔོན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","གྲོང་ཁྱེར་དེ་ལ་ཁོའི་མདུན་དུ་ཡང་ཡང་ཡོང་བའི་ཡུགས་མོ་ཞིག་ཡོད་དེ། ཁོ་མོས་དེ་ལ་ངའི་ཁ་གཏད་ལས་སྲུང་བར་མཛོད་ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","རེ་ཞིག་དེ་ལྟར་བྱེད་མ་འདོད་ཀྱང༌། རྗེས་སུ་ཁོས་ངས་དཀོན་མཆོག་གམ། ཡང་ན་མི་རྣམས་ལ་མི་བཀུར་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ཡུགས་མོ་འདིས་ང་ལ་སུན་པོ་བྱེད་པས་ངས་མོའི་ཁ་གཏད་ལས་སྲུང་བར་བྱ། དེ་མིན་ན་ཁོ་མོ་ཡང་ཡང་ཡོང་བས་ང་ངལ་བས་དུབ་བོ་སྙམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ཡང་གཙོ་བོས་“དྲང་པོ་མིན་པའི་ཁྲིམས་དཔོན་གྱིས་གང་བཤད་པ་དེ་ལ་ཉོན་ཞིག ");
INSERT INTO bod_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","དཀོན་མཆོག་གིས་ཁོང་ལ་ཉིན་མཚན་མེད་པར་སྨོན་ལམ་འདེབས་མཁན་ཉིད་ཀྱིས་བདམས་པ་ལ་སྲུང་བར་མི་མཛོད་དམ། མི་དེ་ཚོར་རོགས་པ་གནང་བར་ཡུན་རིང་པོར་འགོར་རམ། ");
INSERT INTO bod_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཁོང་གིས་མྱུར་དུ་ཁོ་ཚོ་སྲུང་བར་འགྱུར། འོན་ཀྱང་མིའི་རིགས་ཀྱི་བུ་ཕེབས་པའི་དུས་སུ་འཇིག་རྟེན་འདིར་དད་ལྡན་རྣམས་རྙེད་པར་འགྱུར་རམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ཡང་རང་ཉིད་དྲང་པོ་ཡིན་པར་བསམ་ཞིང་མི་གཞན་ལ་མཐོང་ཆུང་བྱེད་པའི་མི་ཁ་ཤས་ལ་དཔེ་འགྲེ་བྱས་ནས་ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ཕཱ་རུ་ཤི་པ་ཞིག་དང་ཁྲལ་སྡུད་མཁན་ཞིག་སྨོན་ལམ་འདེབས་པའི་ཆེད་དུ་མཆོད་ཁང་ཆེན་མོར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ཕཱ་རུ་ཤི་པ་གཅིག་པོར་ལངས་ཏེ། ཀྱེ་དཀོན་མཆོག ང་ཁ་བསླུས་རྒྱག་མཁན་ནམ། དྲང་པོ་མིན་པའམ། ལོག་གཡེམ་བྱེད་མཁན་མི་གཞན་པ་དང་མི་འདྲ་ཞིང༌། ཁྲལ་སྡུད་མཁན་འདི་དང་ཡང་མི་འདྲ་བས་ཁྱེད་ལ་ཐུགས་རྗེ་ཆེ་ཞུ། ");
INSERT INTO bod_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ངས་གཟའ་འཁོར་ཞིག་ལ་སྨྱུང་གནས་ཐེངས་གཉིས་སྲུང་ཞིང༌། ཡོང་འབབ་ཐམས་ཅད་ལས་བཅུ་ཆ་གཅིག་དཀོན་མཆོག་ལ་འབུལ་ཞེས་སྨོན་ལམ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","འོན་ཀྱང་ཁྲལ་སྡུད་མཁན་དེ་ཐག་རིང་པོར་ལངས་ཏེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཡར་ལྟ་བར་མི་ཕོད་ཅིང༌། བྲང་ཁོག་བརྡུངས་ཏེ། ཀྱེ་དཀོན་མཆོག ང་སྡིག་ཅན་ལ་ཐུགས་རྗེས་གཟིགས་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། གཞན་དེ་ལས་མི་འདི་ཡང་དག་པར་གྱུར་ནས་ཁྱིམ་དུ་སོང༌། གང་ལགས་ཤེ་ན། རང་གིས་རང་ལ་བཀུར་སྟི་བྱེད་མཁན་ཐམས་ཅད་དམའ་བར་འགྱུར་ཞིང༌། རང་གིས་རང་ལ་དམའ་བར་རྩི་མཁན་ཐམས་ཅད་བཀུར་སྟི་འཐོབ་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","མི་རྣམས་ཀྱིས་བྱིས་པ་ཡང་ཁོང་གི་དྲུང་དུ་ཕྱག་གིས་རེག་པའི་ཕྱིར་ཁུར་ཡོང་ཞིང༌། ཉེ་གནས་རྣམས་ཀྱིས་དེ་མཐོང་ནས་ཁོ་ཚོར་གཤེ་གཤེ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","འོན་ཀྱང་ཡེ་ཤུས་ཕྲུ་གུ་རྣམས་ཁོང་གི་མདུན་དུ་ཡོང་བའི་བཀའ་གནང་སྟེ་“ཁོ་ཚོ་དང་འདྲ་བ་རྣམས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་ཁོངས་གཏོགས་ཡིན་པས། ཕྲུ་གུ་ཆུང་ངུ་མ་འགོག་པར་ངའི་དྲུང་དུ་ཡོང་དུ་ཆུག་ཅིག ");
INSERT INTO bod_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ངས་ཁྱེད་རྣམས་ལ་བདེན་པར་ཟེར་རྒྱུར། སུ་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཕྲུ་གུ་ཆུང་ངུའི་ཚུལ་དུ་མི་བླངས་ན། དེའི་ནང་དུ་ཅི་ནས་ཀྱང་འགྲོ་མི་ཐུབ་བོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","དེ་ནས་དཔོན་པོ་ཞིག་གིས་ཁོང་ལ་“སྟོན་པ་བཟང་པོ་ལགས། དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་ཕྱིར་ངས་གང་ཞིག་བྱ་དགོས་སམ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ཡེ་ཤུས་མི་དེར་“ཁྱེད་ཀྱིས་ང་ལ་ཅིའི་ཕྱིར་བཟང་པོ་ཟེར། དཀོན་མཆོག་གཅིག་པུ་ལས་གཞན་བཟང་པོ་གཅིག་ཀྱང་མེད། ");
INSERT INTO bod_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ལོག་གཡེམ་མ་བྱེད། མིའི་སྲོག་མ་གཅོད། རྐུ་མ་མ་རྐུས། རྫུན་གྱི་དཔང་པོ་མ་བྱེད། རང་གི་ཕ་མར་བརྩི་བཀུར་བྱོས་ཤིག་ཅེས་གསུངས་པའི་བཀའ་ཁྲིམས་འདི་ཚོ་ཁྱེད་ཀྱིས་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ཡང་མི་དེས་“ངས་ཆུང་དུས་ནས་བཀའ་འདི་ཐམས་ཅད་བསྲུངས་པ་ཡིན་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","དེ་གསན་ནས་ཡེ་ཤུས་ཁོ་ལ་“ཁྱོད་ལ་ད་དུང་དོན་གཅིག་མི་ཚང་བས། རང་ལ་ཡོད་པ་ཐམས་ཅད་བཙོངས་ཏེ་དབུལ་པོ་རྣམས་ལ་སྦྱིན་ཅིག དེ་ནས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཁྱོད་ལ་རྒྱུ་ནོར་ཐོབ་པར་འགྱུར་བ་དང༌། ཤོག ངའི་རྗེས་སུ་འབྲོངས་ཤིག་”ཅེས་གསུངས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","མི་དེ་ཤིན་ཏུ་ཕྱུག་པོ་ཡིན་པས་དེ་ཐོས་ནས་སེམས་སྐྱོ་པོར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","མི་དེར་གཟིགས་ནས་ཡེ་ཤུས་“ཕྱུག་པོ་རྣམས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་དུ་འགྲོ་བ་ཤིན་ཏུ་དཀའོ། ");
INSERT INTO bod_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","མི་ཕྱུག་པོ་ཞིག་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ནང་ལ་འགྲོ་བ་ལས་རྔ་མོང་ཞིག་ཁབ་མིག་བརྒྱུད་ནས་འགྲོ་བ་སླའོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","དེ་ཐོས་པ་རྣམས་ཀྱིས་“འོ་ན་སུ་ཞིག་ལ་ཐར་བ་ཐོབ་ཐུབ་བམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ཡེ་ཤུས་“དེ་ནི་མི་རྣམས་ལ་མི་སྲིད་ཀྱང་དཀོན་མཆོག་ལ་སྲིད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","དེ་ནས་པེ་ཏྲོས་“ཁྱེད་ཀྱིས་གཟིགས་དང༌། ང་ཚོས་ཐམས་ཅད་དོར་ནས་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲངས་པ་ཡིན་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ཡེ་ཤུས་ཁོ་ཚོར་“ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་སུ་ཞིག་གིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་དོན་དུ་རང་གི་ཁྱིམ་ཚང་ངམ། བཟའ་ཟླའམ། སྤུན་ནམ། ཕ་མའམ། བུ་ཕྲུག་བཅས་བཞག་ན། ");
INSERT INTO bod_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","མི་དེ་ལ་ཚེ་འདིར་ལྡབ་འགྱུར་གྱིས་མང་པོ་འཐོབ་པར་འགྱུར་ལ། མ་འོངས་པར་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པར་ངེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","དེ་ནས་ཁོང་གིས་བཅུ་གཉིས་པོ་རྣམས་ཟུར་དུ་ཁྲིད་དེ་ཁོ་ཚོར་“ལྟོས་དང༌། ད་ང་ཚོ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དུ་འགྲོ་ལ། ལུང་སྟོན་པས་མིའི་རིགས་ཀྱི་བུའི་སྐོར་བྲིས་ཡོད་པ་ཐམས་ཅད་འགྲུབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","མིའི་རིགས་ཀྱི་བུ་ཕྱི་པ་རྣམས་ལ་གཏད་ནས་ཁོ་ཚོས་ཁོང་ལ་འཕྱ་དམོད་བྱེད་དེ་ཁ་ངན་བཤད་ནས་མཆིལ་མ་གཏོར་བར་འགྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","རྟ་ལྕག་གིས་བརྡུངས་ནས་གསོད་པར་འགྱུར། དེ་ནས་ཉིན་གསུམ་པར་ཁོང་སླར་གསོན་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ཉེ་གནས་རྣམས་ཀྱིས་གསུང་དེའི་དོན་ཧ་མ་གོ དོན་དེ་ཁོ་ཚོ་ལ་སྦས་ཡོད་པས་མ་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","དེ་ནས་ཡེ་ཤུ་ཡེ་རུ་ཀོ་ཞེས་བྱ་བའི་གྲོང་ཁྱེར་དང་ཉེ་བར་བྱོན་སྐབས། སྤྲང་པོ་ལོང་བ་ཞིག་ལམ་ཁར་བསྡད་ནས་སློང་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","སྤྲང་པོ་དེས་མི་ཚོགས་ཕར་འགྲོ་བཞིན་པའི་སྒྲ་ཐོས་ནས་མི་གཞན་ལ་གང་འབྱུང་བའི་སྐོར་སྐད་ཆ་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","མི་དེ་ཚོས་“ན་ཙ་རེལ་པ་ཡེ་ཤུ་ཕར་ཕེབས་བཞིན་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","སྤྲང་པོ་དེས་སྐད་ཆེན་པོས་“ཀྱེ། ཡེ་ཤུ་དཱ་བིད་ཀྱི་སྲས། ང་ལ་ཐུགས་རྗེས་གཟིགས་དང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","སྔོན་ལ་འགྲོ་མཁན་རྣམས་ཀྱིས་ཁོ་ལ་ཁ་རོག་སྡོད་ཅེས་ནན་གྱིས་བསྐུལ་ནའང༌། ཁོས་དེ་བས་སྐད་ཆེན་པོས་“ཀྱེ། དཱ་བིད་ཀྱི་སྲས། ཁྱེད་ཀྱིས་ང་ལ་ཐུགས་རྗེས་གཟིགས་རོགས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","དེ་ནས་ཡེ་ཤུས་ཕེབས་མཚམས་བཞག་སྟེ་“ལོང་བ་དེ་ཚུར་ཁྲིད་ཅིག་”ཅེས་བཀའ་གནང༌། མི་དེ་ཡེ་ཤུའི་མདུན་དུ་སླེབས་ནས་ཁོང་གིས་ཁོ་ལ་ ");
INSERT INTO bod_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ངས་ཁྱེད་ལ་གང་བྱེད་དགོས་སམ་”ཞེས་གསུངས་པ་དང༌། མི་ལོང་བ་དེས་“སློབ་དཔོན་ལགས། ངའི་མིག་གིས་ཡང་བསྐྱར་མཐོང་ནུས་པར་མཛོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ཡེ་ཤུས་ཁོ་ལ་“ཁྱེད་ཀྱི་མིག་གིས་མཐོང་བར་གྱུར་ཅིག ཁྱེད་ཀྱི་དད་པས་གསོས་ཟིན་ནོ་”ཞེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ཁོའི་མིག་གིས་མཐོང་བར་གྱུར་བས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཏེ་ཁོང་གི་རྗེས་སུ་འབྲངས། མི་ཐམས་ཅད་ཀྱིས་དེ་མཐོང་ནས་ཁོ་ཚོའང་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","དེ་ནས་ཁོང་ཡེ་རུ་ཀོ་གྲོང་ཁྱེར་བརྒྱུད་ནས་ཕེབས་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","མི་ཕྱུག་པོ་སཱ་ཀཱ་ཟེར་བའི་ཁྲལ་སྡུད་མཁན་དཔོན་པོ་དེར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ཁོས་ཡེ་ཤུ་སུ་ཡིན་པ་མཐོང་བར་འདོད་ཀྱང་མ་ཐུབ། གང་ལགས་ཟེར་ན། མི་ཚོགས་མང་པོ་ཞིག་ཡོད་པ་དང༌། ཁོ་གཟུགས་པོ་ཆུང་ངུ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","དེའི་ཕྱིར་ཁོ་ཡེ་ཤུའི་ཕེབས་ལམ་གྱི་མདུན་དུ་བརྒྱུགས་ནས་ཁོང་ལ་ལྟ་བར་སུ་ཀོ་མོར་ཞེས་ཟེར་བའི་ཤིང་སྡོང་ཆེན་པོ་ཞིག་འཛེགས། ");
INSERT INTO bod_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ཡེ་ཤུ་ས་ཆ་དེར་ཕེབས་ནས་ཡར་གཟིགས་ཏེ་ཁོ་ལ་“སཱ་ཀཱ མགྱོགས་པོར་མར་འབབ་ཅིག དེ་རིང་ཁྱེད་ཀྱི་ཁྱིམ་ཚང་ལ་སྡོད་དགོས་”ཞེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ཁོ་མྱུར་དུ་མར་བབས་ནས་དགའ་བའི་ངང་ནས་ཁོང་ལ་སྣེ་ལེན་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","དེ་མཐོང་བ་ཐམས་ཅད་ཀྱིས་ཡིད་མ་རངས་པའི་གཏམ་བཤད་དེ་“མི་སྡིག་ཉེས་ཅན་གྱི་ཁྱིམ་ལ་མགྲོན་དུ་སོང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","སཱ་ཀཱ་དེར་བསྡད་དེ་གཙོ་བོ་ཡེ་ཤུ་ལ་“གཙོ་བོ། གཟིགས་དང༌། ང་ལ་ཡོད་པའི་རྒྱུ་ནོར་ཕྱེད་ཀ་དབུལ་པོ་རྣམས་ལ་སྦྱིན་པ་དང༌། གལ་ཏེ་ངས་སུ་ཞིག་ལ་མགོ་སྐོར་བཏང་ནས་དངུལ་ཐོབ་ན་ངས་ཕྱིར་ལྡབ་བཞི་འཇལ་བར་བྱ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ཡེ་ཤུས་ཁོ་ལ་“དེ་རིང་ཁྱིམ་ཚང་འདིར་ཐར་པ་བབས་ཡོད་དོ། གང་ཡིན་ཞེ་ན། མི་འདི་ཡང་ཨབ་ར་ཧམ་གྱི་བུ་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","མིའི་རིགས་ཀྱི་བུ་ནི་བརླག་པ་རྣམས་འཚོལ་བ་དང་སྐྱོབ་པའི་ཆེད་དུ་ཡོང་ངོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ཁོ་ཚོས་དོན་དེ་རྣམས་ཉན་པའི་རིང་ལ། ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་དང་ཉེ་བར་ཡོད་པས། མི་དེ་ཚོ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་འཕྲལ་དུ་མངོན་པར་འགྱུར་སྙམ་པས་ཁོང་གིས་ཁོ་ཚོར་དཔེའི་སྒོ་ནས་འདི་ལྟར་གསུངས་ ");
INSERT INTO bod_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“སྐུ་དྲག་གཅིག་རྒྱལ་བའི་དབང་ཐོབ་པའི་ཆེད་དུ་ཡུལ་ཐག་རིང་ལ་སོང་ནས་ཕྱིར་ལོག་པར་བསམས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","རང་གི་གཡོག་པོ་བཅུ་བོས་ནས་ཁོ་ཚོར་མི་ནཱ་ཞེས་པའི་གསེར་ཊམ་ཀ་བཅུ་སྤྲད་ཅིང༌། ང་མ་སླེབས་པའི་བར་དུ་དངུལ་འདི་ཡིས་ཉོ་ཚོང་བྱོས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","འོན་ཀྱང་ཁོའི་འབངས་མི་རྣམས་ཀྱིས་ཁོ་ལ་སྡང་བས། མི་འདི་ང་ཚོའི་རྒྱལ་པོར་འགྱུར་བར་མི་འདོད་ཅེས་ཟེར་བའི་ཕྱིར་ཕོ་ཉ་འགའ་ཁོའི་རྗེས་སུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","རྒྱལ་སྲིད་ཐོབ་ནས་ཕྱིར་ལོག་སྐབས་སུ་དངུལ་སྤྲོད་པའི་གཡོག་པོས་ཚོང་ལས་བྱས་ནས་དངུལ་ཅི་ཙམ་ཐོབ་པ་ཤེས་པའི་ཆེད་དུ་ཁོས་དེ་རྣམས་མདུན་དུ་བོས་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","གཡོག་པོ་དང་པོ་དེ་ཁོའི་མདུན་དུ་ཡོང་ནས། མི་དབང་ཆེན་པོ་ལགས། ཁྱེད་ཀྱི་མི་ནཱ་གཅིག་གིས་མི་ནཱ་བཅུའི་ཁེ་བཟང་ཐོབ་འབྱུང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","རྒྱལ་པོས་ཁོ་ལ་ལེགས་སོ། གཡོག་པོ་བཟང་པོ་ཁྱོད་དོན་ཆུང་ངུ་ལ་བློ་གཏད་ཆོག་པ་ཡིན་པས་ངས་ཁྱོད་ལ་གྲོང་ཁྱེར་བཅུའི་དབང་སྟེར་བར་བྱ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","གཉིས་པ་དེ་ཡོང་ནས་ཁོས། མི་དབང་ཆེན་པོ་ལགས། ཁྱེད་ཀྱི་མི་ནཱ་གཅིག་གིས་མི་ནཱ་ལྔ་ཡི་ཁེ་བཟང་ཐོབ་འབྱུང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","རྒྱལ་པོས་མི་དེ་ལ། ངས་ཁྱོད་ལའང་གྲོང་ཁྱེར་ལྔ་ཡི་དབང་སྟེར་བར་བྱ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","གཡོག་པོ་གཞན་ཞིག་ཡོང་ནས་ཁོས། མི་དབང་ཆེན་པོ་ལགས། ཁྱེད་ཀྱི་མི་ནཱ་འདི་རུ་ཡོད། ངས་དེ་རས་ཀྱིས་བཏུམས་ཏེ་ཉར་ཚགས་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","གང་ལགས་ཟེར་ན། ཁྱེད་ནི་དོ་ནན་པོ་ཞིག་ཡིན་པས་ང་ཁྱེད་ལ་འཇིགས། ཁྱེད་ཀྱིས་རྒྱུ་ནོར་མ་བསགས་པ་དེ་ལེན་པ་དང༌། ས་བོན་མ་བཏབ་པ་དེ་རྔ༌། ");
INSERT INTO bod_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","རྒྱལ་པོས་ཁོ་ལ། གཡོག་པོ་ངན་པ་ཁྱོད་ཀྱིས་སྨྲས་པའི་ཚིག་གིས་ངས་ཁྱོད་ལ་ཁྲིམས་གཅོད་གཏོང་རྒྱུ་ཡིན། ང་ནི་དོ་ནན་པོ་ཞིག་ཡིན་པས། ངས་རྒྱུ་ནོར་མ་བསགས་པ་དེ་ལེན་པ་དང༌། ས་བོན་མ་བཏབ་པ་དེ་རྔ་བ་ཁྱོད་ཀྱིས་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ངས་ཁྱོད་ལ་སྤྲད་པ་དེ་ཁྱོད་ཀྱིས་ཅིའི་ཕྱིར་དངུལ་བུན་གཏོང་མཁན་ལ་མ་བཅོལ། དེ་ལྟར་བྱས་ན་ང་འདིར་སླེབས་ནས་སྐྱེད་ཁ་དང་བཅས་པའི་དངུལ་ལེན་རྒྱུ་ཡོད་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","དེ་ནས་རྒྱལ་པོས་ཉེ་འཁོར་དུ་ཡོད་པའི་མི་རྣམས་ལ་ཁོ་ནས་མི་ནཱ་དེ་ལེན་ཞིང༌། མི་ནཱ་བཅུ་ཡོད་པ་དེ་ལ་སྟེར་ཞིག་ཅེས་བཤད་ནས། ");
INSERT INTO bod_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ཁོ་ཚོས་མི་དབང་ཆེན་པོ་ལགས། ཁོ་ལ་མི་ནཱ་བཅུ་ཡོད་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ངས་ཁྱོད་ཚོ་ལ་ཟེར་རྒྱུར། སུ་ལ་ཡོད་པ་དེ་ལ་སྟེར་བར་འགྱུར། འོན་ཀྱང་སུ་ལ་མེད་པ་དེ་ལ་ཉུང་ངུ་ཙམ་ཡོད་པ་དེ་ཡང་ལེན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","འོན་ཀྱང་ང་རྒྱལ་པོར་འགྱུར་བར་མི་འདོད་མཁན་དགྲ་བོ་རྣམས་ནི་འདིར་ཁྲིད་ནས་ངའི་མདུན་དུ་སོད་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ཡེ་ཤུས་དེ་ལྟར་གསུངས་པའི་རྗེས་སུ་ཡེ་རུ་ཤ་ལེམ་ལ་སྔོན་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ཁོང་སྐྱུར་རུ་ཤིང་གི་རི་དང་ཉེ་བའི་གྲོང་སྡེ་པེ་ཕ་གེ་དང་པེ་ཐན་ཡཱ་ལ་བྱོན་པའི་ཚེ་ཡེ་ཤུས་ཉེ་གནས་གཉིས་མངགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ཁོ་ཚོར་“ཁྱེད་ཚོ་མདུན་དུ་ཡོད་པའི་གྲོང་སྡེ་དེ་ལ་སོང་དང༌། དེར་སླེབས་མ་ཐག་ཏུ་མི་སུས་ཀྱང་བཞོན་མ་མྱོང་བའི་བོང་བུ་ཞིག་བཏགས་ཡོད་པ་མཐོང་བར་འགྱུར། དེ་བཀྲོལ་ནས་འདིར་ཁྲིད་ཤོག ");
INSERT INTO bod_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","གལ་ཏེ་སུ་ཞིག་གིས་ཁྱེད་ཚོར་ཅིའི་ཕྱིར་དེ་ལྟར་བྱས་པ་ཡིན་ནམ་ཞེས་དྲིས་ན། ཁྱེད་གཉིས་ཀྱིས་འདི་གཙོ་བོ་ལ་མཁོ་བ་ཡིན་ཞེས་སྨྲོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ཁོང་གིས་ཇི་ལྟར་གསུངས་པ་བཞིན་དུ་ཕར་བཏང་བ་རྣམས་ཀྱིས་དེ་ལྟར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ཁོ་ཚོས་བོང་བུ་འགྲོལ་བཞིན་པའི་དུས་སུ་བོང་བུ་དེའི་བདག་པོ་རྣམས་ཀྱིས་དེ་གཉིས་ལ་“ཅིའི་ཕྱིར་བོང་བུ་དེ་བཀྲོལ་བ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ཁོ་ཚོས་“འདི་གཙོ་བོ་ལ་མཁོ་བ་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","བོང་བུ་དེ་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་ནས་ཁོ་གཉིས་ཀྱིས་རང་གི་གྱོན་གོས་བོང་བུའི་རྒྱབ་ལ་བཏིང་བ་དང་ཁོང་དེ་ལ་བཅིབས། ");
INSERT INTO bod_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ཁོང་ཕར་ཕེབས་སྐབས་མི་རྣམས་ཀྱིས་རང་གི་གྱོན་ཆས་ལམ་ལ་བཏིང༌། ");
INSERT INTO bod_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ཁོང་སྐྱུར་རུ་ཤིང་གི་རི་ནས་ལམ་ལ་མར་བབས་པའི་གནས་དང་ཉེ་བར་ཕེབས་དུས་ཁོ་ཚོས་ངོ་མཚར་བའི་མཛད་པ་མང་པོ་མཐོང་མྱོང་བས། ཉེ་གནས་ཀྱི་ཚོགས་ཐམས་ཅད་དགའ་ཞིང་སྐད་ཆེན་པོས་དཀོན་མཆོག་ལ་བསྟོད་བསྔགས་ཕུལ་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“གཙོ་བོའི་མཚན་གྱི་ཐོག་ནས་བྱོན་པའི་རྒྱལ་པོར་བྱིན་རླབས་ཡོང་བར་ཤོག དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཞི་བདེ་ཡོད་པར་འགྱུར་ལ། བླ་ན་མེད་པའི་གནས་སུ་བཞུགས་པའི་དཀོན་མཆོག་ལ་བསྟོད་པར་བྱའོ་”ཞེས་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","མི་ཚོགས་ནང་ནས་ཕཱ་རུ་ཤི་པ་ཁ་ཤས་ཀྱིས་ཁོང་ལ་“རྒན་ལགས། ཁྱེད་ཀྱིས་ཉེ་གནས་རྣམས་ལ་བཀའ་བཀྱོན་མཛོད་ཅིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། གལ་སྲིད་འདི་ཚོ་ཁ་རོག་བསྡད་ན། རྡོ་རྣམས་ཀྱིས་ཀྱང་སྐད་སྒྲོག་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ཡེ་རུ་ཤ་ལེམ་དང་ཉེ་བར་བྱོན་སྐབས་ཁོང་གིས་གྲོང་ཁྱེར་གཟིགས་ནས་བཤུམས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“གལ་ཏེ་ཁྱོད་ཀྱིས་ཀྱང་ཉིན་མོ་འདིར་ཞི་བདེའི་ཐབས་རྟོགས་པ་ཡིན་ན༌༌༌༌། ད་དོན་དེ་རྣམས་སྦས་ཡོད་པས་ཁྱོད་ཀྱིས་མི་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ཁྱོད་ཀྱི་དགྲ་བོ་རྣམས་ཀྱིས་ཁྱོད་ཀྱི་མཐའ་སྐོར་ལ་ལྕགས་རི་རྒྱག་པར་འགྱུར་ཞིང༌། ཕྱོགས་བཞི་ནས་སྐོར་ཞིང་ཕྱོགས་ཚང་མ་ལ་དགག་པའི་དུས་ལ་འབབ་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ཁྱོད་ལ་ཐུགས་རྗེས་གཟིགས་པའི་དུས་དེ་མ་ཤེས་པས། ཁྱོད་ཀྱི་དགྲ་བོ་རྣམས་ཀྱིས་ཁྱོད་དང་ཁྱོད་ཀྱི་ར་བའི་ནང་གི་ཕྲུ་གུ་རྣམས་ས་ལ་བརྡབས་ནས། ཁྱོད་ཀྱི་ནང་ལ་རྡོ་གཅིག་གི་སྟེང་དུ་རྡོ་གཅིག་ཀྱང་ལུས་མི་ཡོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","དེ་ནས་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཞུགས་ནས། དེར་ཡོད་པའི་ཉོ་ཚོང་མཁན་རྣམས་ཕྱི་ལ་བཏོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ཁོང་གིས་མི་དེ་ཚོར་“དཀོན་མཆོག་གི་གསུང་རབ་ལས། ངའི་ཁང་པ་ལ་སྨོན་ལམ་འདེབས་སའི་ཁང་པ་ཟེར་བར་འགྱུར་ཞེས་འཁོད། འོན་ཀྱང་ཁྱོད་ཚོས་ཇག་ཚང་ལྟ་བུ་ཞིག་ཏུ་བསྒྱུར་འདུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ཡེ་ཤུས་ཉིན་ལྟར་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཆོས་གསུངས། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི། ཡུལ་མིའི་དཔོན་པོ་བཅས་ཀྱིས་ཁོང་གསོད་པའི་གོ་སྐབས་བཙལ་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ཐབས་གང་ཡང་མ་རྙེད། གང་ཡིན་ཟེར་ན། མི་ཐམས་ཅད་ཀྱིས་ཁོང་གི་གསུང་ལ་ཞིབ་ཏུ་ཉན་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","དེ་ནས་ཉིན་གཅིག་ལ་ཡེ་ཤུས་མཆོད་ཁང་ཆེན་མོར་མི་རྣམས་ལ་ཆོས་གསུངས་པ་དང༌། མི་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་པའི་དུས་སུ། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི། རྒན་པོ་རྣམས་དང་མཉམ་དུ་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","མི་དེ་ཚོས་“ཁྱེད་ཀྱིས་དབང་ཆ་གང་གི་སྒོ་ནས་དོན་འདི་ཚོ་མཛད། ཡང་ན་སུ་ཞིག་གིས་ཁྱེད་ལ་དོན་འདི་རྣམས་མཛད་པའི་དབང་ཆ་སྤྲད་པ་ཡིན་ནམ། ང་ཚོར་ལན་ཐོབ་ཅིག་”ཅེས་སྨྲས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ཡེ་ཤུས་“ངས་ཀྱང་ཁྱེད་རྣམས་ལ་དྲི་བ་གཅིག་འདྲི་རྒྱུ་ཡིན། དེའི་ལན་ཐོབ་ཅིག ");
INSERT INTO bod_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ཡོ་ཧ་ནན་གྱི་ཁྲུས་གསོལ་མཛད་པའི་དབང་དེ་དཀོན་མཆོག་ནས་བྱུང་ངམ། མི་ནས་བྱུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ཁོ་ཚོས་ཕན་ཚུན་གཏམ་གླེང་བྱས་ཤིང་“གལ་ཏེ་དཀོན་མཆོག་ནས་བྱུང་ཞེས་བཤད་ན། ཁོང་གིས་འོ་ན་ཁྱེད་རྣམས་ཀྱིས་ཅིའི་ཕྱིར་ཁོང་ལ་དད་པ་མ་བྱས་སམ་ཞེས་གསུང་ངེས་ལ། ");
INSERT INTO bod_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ཡང་མི་ལས་བྱུང་ཞེས་བཤད་ན། མི་ཐམས་ཅད་ཀྱིས་ཡོ་ཧ་ནན་ལུང་སྟོན་པར་བརྩིས་པའི་རྐྱེན་གྱིས་ང་ཚོ་རྡོ་རུབ་བཏང་སྟེ་གསད་རྒྱུ་རེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","དེའི་ཕྱིར་ཁོ་ཚོས་“གང་ནས་བྱུང་ང་ཚོས་མི་ཤེས་”ཞེས་ལན་བཏབ། ");
INSERT INTO bod_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ཡེ་ཤུས་“དེས་ན་ངས་ཀྱང་དབང་ཆ་གང་གིས་དོན་འདི་རྣམས་བྱེད་པ་མི་ཤོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","དེ་ནས་དཔེའི་སྒོ་ནས་ཡེ་ཤུས་མི་རྣམས་ལ་“མི་ཞིག་གིས་རྒུན་འབྲུམ་གྱི་ལྡུམ་ར་ཞིག་བཟོས་ཤིང༌། ལྡུམ་རའི་ལས་མཁན་རྣམས་ལ་བོགས་མར་བཏང་ནས་ཡུལ་གཞན་དུ་སོང་སྟེ་ཡུན་རིང་པོར་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","དེ་ནས་དུས་རན་པས་ཁོང་གིས་ལྡུམ་རའི་ལས་མཁན་རྣམས་ནས་ལྡུམ་རའི་རྒུན་འབྲུམ་གྱི་འབྲས་བུའི་སྐལ་བ་ལེན་པའི་ཕྱིར་གཡོག་པོ་ཞིག་བཏང༌། འོན་ཀྱང་མི་དེ་ཚོས་གཡོག་པོ་དེ་བརྡུངས་རྗེས་ལག་ཟུང་སྟོང་པར་ཕྱིར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ཡང་ཁོང་གིས་གཡོག་པོ་གཞན་ཞིག་བཏང་བས། ལྡུམ་རའི་ལས་མཁན་རྣམས་ཀྱིས་གཡོག་པོ་དེའང་བརྡུངས་ཤིང༌། ཁ་ངན་བཤད་ནས་ལག་ཟུང་སྟོང་པར་ཕྱིར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ཡང་ཁོང་གིས་གཡོག་པོ་གསུམ་པ་དེ་མངགས་པའང་དེ་རྣམས་ཀྱིས་རྨས་སྐྱོན་བཏང་ནས་ཕྱིར་བཏོན། ");
INSERT INTO bod_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","དེ་ནས་ལྡུམ་རའི་བདག་པོས་ངས་ཅི་བྱེད་པར་བྱ། ངའི་གཅེས་པའི་བུ་གཏོང་རྒྱུ་ཡིན། ཁོ་ཚོས་ངའི་བུ་ལ་བརྩི་བཀུར་བྱེད་པར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","འོན་ཀྱང་ལྡུམ་རའི་ལས་མཁན་རྣམས་ཀྱིས་བུ་མཐོང་ནས་ཕན་ཚུན་ལ། མི་འདི་ནི་ཕ་ཤུལ་འཛིན་མཁན་ཡིན་པས། ཤུལ་འཛིན་དེ་འཐོབ་པའི་ཆེད་དུ་ཁོ་རང་གསོད་པར་བྱ་ཞེས་སྨྲས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ཁོ་རང་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་ཕྱི་རོལ་ཏུ་བསྐྲད་ནས་བསད། དེས་ན་རྒུན་འབྲུམ་གྱི་ལྡུམ་རའི་བདག་པོས་ཁོ་ཚོར་གང་བྱེད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ཁོང་ཕེབས་ནས་ལྡུམ་རའི་ལས་མཁན་རྣམས་མེད་པར་བཟོས་ཏེ་རྒུན་འབྲུམ་གྱི་ལྡུམ་ར་མི་གཞན་ལ་སྤྲོད་པར་བྱེད་དོ་”ཞེས་གསུངས། དེ་ཐོས་ནས་ཁོ་ཚོས་“དེ་ལྟར་མི་སྲིད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","འོན་ཀྱང་ཡེ་ཤུས་ཁོ་ཚོར་ནན་གྱིས་བལྟས་ནས་“དཀོན་མཆོག་གི་གསུང་རབ་ལས། བཟོ་བོ་རྣམས་ཀྱིས་དོར་བའི་རྡོ། ། ཁང་པའི་རྨང་རྡོར་གྱུར་བ་ཡིན། ། ཞེས་པའི་དོན་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","སུ་ཞིག་རྡོ་དེའི་སྟེང་དུ་འགྱེལ་ན་དུམ་བུར་ཆག་པར་འགྱུར། རྡོ་དེ་མི་སུ་ཞིག་ལ་ལྷུངས་ན་དེས་ཁོ་མནན་པར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་བླ་ཆེན་རྣམས་ཀྱིས་དཔེ་དེ་ཁོ་རང་ཚོའི་སྐོར་ལ་གསུངས་པ་ཤེས་ཏེ་དུས་དེ་རང་ལ་ཡེ་ཤུ་འཛིན་པའི་ཐབས་བཙལ་ཡང༌། མི་ཚོགས་ལ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","དེར་བརྟེན་ཁོ་ཚོས་ཁོང་ལ་ལྐོག་ལྟ་བྱས་ཏེ། ཡེ་ཤུ་ལ་ཁྲིམས་དང་འགལ་བའི་གཏམ་བཤད་གནང་དུ་འཇུག་ཆེད་མི་དྲང་པོ་ཡིན་ཚུལ་སྟོན་པའི་ལྟ་མྱུལ་པ་ཁོང་གི་དྲུང་དུ་བཏང༌། དེ་ནི་ཁོང་སྤྱི་ཁྱབ་དབང་ཅན་གྱི་ལག་ཏུ་གཏོང་བའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ཁོ་ཚོས་ཁོང་ལ་“སྟོན་པ་ལགས། ཁྱེད་ཀྱིས་སྐྱོན་མེད་པར་ཆོས་བསྟན་གནང་བ་དང༌། ཕྱོགས་རིས་མེད་པར་དཀོན་མཆོག་གི་ལམ་ཡང་དག་པར་བདེན་པར་སྟོན་པ་དེ་ང་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་ལྟར་ན་ང་ཚོས་རྒྱལ་པོ་ཆེན་པོ་སེ་སར་ལ་ཁྲལ་འཇལ་རུང་ངམ་མི་རུང་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ཁོང་གིས་དེ་རྣམས་ཀྱི་གཡོ་སྒྱུ་མཁྱེན་ཏེ་ཁོ་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“དེ་ཎ་རིའི་དངུལ་ཊམ་ཀ་གཅིག་ང་ལ་སྟོན་ཅིག རི་མོ་དང་ཡི་གེ་འདི་སུའི་རེད་དམ་”ཞེས་བཀའ་འདྲི་གནང་ནས་ཁོ་ཚོས་“སེ་སར་རྒྱལ་པོའི་རེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ཁོང་གིས་ཁོ་ཚོར་“དེས་ན་གང་ཞིག་སེ་སར་རྒྱལ་པོའི་ཡིན་པ་དེ་སེ་སར་ལ་ཕུལ་ཞིག གང་ཞིག་དཀོན་མཆོག་གི་ཡིན་པ་དེ་དཀོན་མཆོག་ལ་ཕུལ་ཞིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ཁོ་ཚོས་མི་ཚོགས་ཀྱི་མདུན་དུ་ཡེ་ཤུ་ལ་ཁྲིམས་དང་འགལ་བའི་གཏམ་བཤད་གནང་དུ་མ་བཅུག་སྟེ། ཁོང་གི་ལན་ལ་ངོ་མཚར་བར་གྱུར་བས་ཁ་རོག་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","དེ་ནས་ཡང་འཆི་བ་ནས་སླར་གསོན་པ་མེད་ཅེས་ཟེར་མཁན་སཱ་ཅུ་སེ་པ་རྣམས་ཁོང་གི་དྲུང་དུ་ཡོང་སྟེ་ ");
INSERT INTO bod_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“སློབ་དཔོན་ལགས། ལུང་སྟོན་པ་མོ་ཤེའི་མདོ་ལས། གལ་སྲིད་སྐྱེས་པ་ཞིག་གི་སྤུན་ཤི་ནས་བུ་ཕྲུག་མེད་པར་བཟའ་ཟླ་གཅིག་པུ་ལུས་ན། སྐྱེས་པ་དེས་ཁོའི་བཟའ་ཟླ་བླངས་ནས་སྤུན་གྱི་དོན་དུ་རིགས་རྒྱུད་སྤེལ་དགོས་པ་ཡིན་ནོ་ཞེས་བྲིས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ད་སྤུན་བདུན་ཡོད་དེ། སྤུན་ཆེ་བས་བཟའ་ཟླ་ཞིག་བླངས་ནས་བུ་ཕྲུག་མེད་པར་ཤི་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","32","ཡང་སྤུན་འབྲིང་བས་བུད་མེད་དེ་བླངས་ནས་བུ་ཕྲུག་མེད་པར་ཤི སྤུན་ཆུང་བས་ཀྱང་དེ་ལྟར་བྱས་ནས་བུ་ཕྲུག་མ་བྱུང་བར་ཤི དེ་བཞིན་སྤུན་བདུན་པོར་བུ་ཕྲུག་མ་བྱུང་བར་ཤི་ལ། ཐམས་ཅད་ཀྱི་གཞུག་ལ་བུད་མེད་དེའང་ཤིའོ། ");
INSERT INTO bod_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","འཆི་བ་ནས་སླར་གསོན་པོར་འགྱུར་བའི་དུས་སུ། སྤུན་བདུན་པོས་བུད་མེད་དེར་ཆང་ས་བརྒྱབ་མྱོང་བས་ཁོ་མོ་ནི་སྤུན་བདུན་ཡོད་པ་ལས་སུའི་བཟའ་ཟླ་ཡིན་ནམ་”ཞེས་དྲིས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ཡེ་ཤུས་ཁོ་ཚོར་“དུས་འདི་དང་གཏོགས་པའི་མི་རྣམས་ཀྱིས་བག་མ་གཏོང་ལེན་བྱེད། ");
INSERT INTO bod_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","འོན་ཀྱང་མ་འོངས་པའི་དུས་ཀྱི་གཤིན་པོ་སླར་གསོན་པར་འོས་པ་རྣམས་ཀྱིས་ཚུར་མནའ་མ་མི་ལེན་ཞིང་ཕར་མག་པ་ཡང་མི་བསྐྱལ། ");
INSERT INTO bod_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ཁོ་ཚོ་ནམ་ཡང་ཤི་མི་སྲིད། གང་ལགས་ཟེར་ན། ཁོ་ཚོ་འཆི་བ་ནས་སླར་གསོན་པ་རྣམས་ཡིན་ཏེ། དཀོན་མཆོག་གི་སྲས་ཡིན་པ་དང༌། དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་དང་འདྲའོ། ");
INSERT INTO bod_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ལུང་སྟོན་པ་མོ་ཤེའི་མདོ་ལས་ཚེར་མའི་སྒྲུང་ལྟར་དཀོན་མཆོག་གིས་མོ་ཤེ་ལ་འདི་ལྟར་གསུངས། ང་ནི་ཁྱེད་ཀྱི་མེས་པོ་ཨབ་ར་ཧམ་གྱི་དཀོན་མཆོག་དང༌། ཨི་སཱག་གི་དཀོན་མཆོག ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ཡིན་ཞེས་གསུངས་པའི་སྒོ་ནས་མོ་ཤེ་རང་གིས་འཆི་བ་རྣམས་གསོན་པོར་ལང་དུ་གྱུར་ངེས་པར་བསྟན་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ཁོང་ནི་གཤིན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་མ་ཡིན་ཏེ། གསོན་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་ཡིན། གང་ཡིན་ཞེ་ན། ཁོང་གི་སྤྱན་སྔར་ཁོ་ཚོ་ཐམས་ཅད་གསོན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ཆོས་ཁྲིམས་ལ་མཁས་པའི་མིའི་ནང་ནས་ཁ་ཤས་ཀྱིས་“སློབ་དཔོན་ལགས། ཁྱེད་ཀྱིས་ལེགས་པོ་གསུངས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","དེའི་རྗེས་སུ་ཁོ་ཚོས་ཁོང་ལ་བཀའ་དྲི་གང་ཡང་ཞུ་མ་ནུས། ");
INSERT INTO bod_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","དེ་ནས་ཁོང་གིས་ཁོ་ཚོར་“སྐྱབས་མགོན་མཱ་ཤི་ཀ་ནི་ཇི་ལྟར་གནའ་རབས་ཀྱི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་སྲས་ཡིན་ཟེར་བ་དེ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","རྒྱལ་པོ་དཱ་བིད་རང་གིས་གསུང་རབ་ཀྱི་གསུང་མགུར་ཞེས་པའི་མདོ་ལས་འདི་ལྟར་གསུངས། དཀོན་མཆོག་གིས་ནི་ང་ཡི་གཙོ་བོ་ལ། ། ཁྱེད་ཀྱི་དགྲ་རྣམས་ཁྱེད་ཀྱི་ཞབས་འོག་ཏུ། ། ང་ཡིས་མ་བཅུག་བར་དུ་ཁྱེད་རང་ཉིད། ། ང་ཡི་གཡས་སུ་དེ་བར་བཞུགས་སུ་གསོལ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","དཱ་བིད་རང་ཉིད་ཀྱིས་ཁོང་ལ་གཙོ་བོ་ཞེས་ཞུས་པས་མཱ་ཤི་ཀ་ནི་དཱ་བིད་ཀྱི་སྲས་སུ་ཇི་ལྟར་འགྱུར་བ་ཡིན་ནམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","མི་ཐམས་ཅད་ཀྱིས་ཐོས་པའི་དུས་སུ་ཁོང་གིས་ཉེ་གནས་ཚོར་འདི་ལྟར་གསུངས་ ");
INSERT INTO bod_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ལ་དོགས་ཟོན་གྱིས་ཤིག ཁོ་རྣམས་ཀྱིས་གོས་རིང་པོ་གྱོན་ཏེ་ཕར་འགྲོ་ཚུར་འོང་བྱེད་པ་དང༌། ཁྲོམ་ལ་མི་རྣམས་ཀྱིས་ཕྱག་བྱེད་པར་མོས། ཁོ་ཚོས་འདུ་ཁང་ནང་ཁྲི་མཐོ་ས་དང་གསོལ་སྟོན་གྱི་གྲལ་མགོའི་གལ་ཆེ་སར་སྡོད་པར་དགའ། ");
INSERT INTO bod_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","མི་དེ་རྣམས་ཀྱིས་ཡུགས་མོ་རྣམས་ཀྱི་རྒྱུ་ནོར་ཧམ་འཕྲོག་བྱེད་ཅིང༌། ཕྱི་ཚུལ་བཅོས་མའི་ཚུལ་གྱིས་སྨོན་ལམ་རྒྱུན་རིང་འདེབས་ཁུལ་བྱེད་པས། མི་དེ་ཚོར་ལྷག་པར་དུ་ཆད་པ་ལྗིད་པོ་ཕོག་པར་འགྱུར་རོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","དེ་ནས་ཡེ་ཤུས་དབུ་ཡར་བཏེགས་ནས་མི་ཕྱུག་པོ་རྣམས་ཀྱིས་དངུལ་འབུལ་སྒམ་ལ་འབུལ་བ་འཇོག་པར་གཟིགས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","དབུལ་པོ་ཡུགས་མོ་ཞིག་གིས་ཟངས་ཀྱི་སྒོར་མོ་ཆུང་ཆུང་གཉིས་དེའི་ནང་དུ་བླུགས་པར་གཟིགས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ཁོང་གིས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། དངུལ་འབུལ་མཁན་ཐམས་ཅད་ལས་དབུལ་པོ་ཡུགས་མོ་འདིས་ཕུལ་བ་མང་ཤོས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","གང་ལགས་ཟེར་ན། ཁོ་ཚོ་ཐམས་ཅད་ཀྱིས་ལོངས་སྤྱོད་ལྷག་མ་མང་པོ་ནས་ཕུལ་བ་ཡིན། འོན་ཀྱང་ཁོ་མོ་ནི་རང་ལ་མེད་ཀྱང་ཅི་ཡོད་པ་ཐམས་ཅད་ཕུལ་བ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","དེ་ནས་མི་ལ་ལས་མཆོད་ཁང་ཆེན་མོ་ནི་ཅི་ལྟ་བུའི་རྡོ་མཛེས་པ་དང་དཀོན་མཆོག་ལ་ཕུལ་བའི་མཆོད་པ་རྣམས་ཀྱིས་རྒྱན་པའི་གཏམ་བཤད་དུས་ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ཁྱེད་ཚོས་མཐོང་བའི་ཁང་པ་ཆེན་པོ་འདི་ནི༌༌༌༌། མ་འོངས་པའི་དུས་སུ་རྡོ་ཕ་བོང་གཅིག་གི་སྟེང་དུ་རྡོ་གཅིག་ཀྱང་མི་ལུས་པར་ཐམས་ཅད་གཞིག་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ཁོ་ཚོས་ཁོང་ལ་“སྟོན་པ་ལགས། དོན་འདི་རྣམས་དུས་ནམ་ཞིག་ལ་འབྱུང་ཞིང༌། དོན་འདི་ཚོ་འགྲུབ་པའི་ཚེ་རྟགས་གང་འཐོན་ཡོང་”ཞེས་ཞུས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ཁོང་གིས་“མི་སུས་ཀྱང་ཁྱེད་ཚོ་མི་སླུ་བའི་ཕྱིར་དོགས་ཟོན་བྱོས་ཤིག གང་ཡིན་ཞེ་ན། མི་མང་པོས་ངའི་མིང་ཐོག་ནས་ཡོང་སྟེ། ང་རང་ཡིན་ཟེར་ཞིང༌། ད་དུས་ལ་བབས་འདུག་ཅེས་ཟེར། ཁོ་ཚོའི་རྗེས་སུ་མ་འབྲོངས། ");
INSERT INTO bod_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ཁྱེད་ཚོས་དམག་འཁྲུག་དང༌། ཟིང་འཁྲུག་སྐོར་གྱི་གཏམ་ཐོས་པའི་སྐབས་སུ་མ་འཇིགས་ཤིག དོན་འདི་ཚོ་འབྱུང་ངེས་ཀྱང་དེ་ནི་དུས་རབས་ཀྱི་མཐའ་མ་ད་དུང་མ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","དེ་ནས་ཁོང་གིས་ཁོ་ཚོར་“མི་རིགས་དང་མི་རིགས་འཁྲུག་ཅིང༌། རྒྱལ་ཁམས་དང་རྒྱལ་ཁམས་འཁྲུག་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ས་ཡོམ་ཆེན་པོ་དང༌། ས་ཆ་མི་གཅིག་པར་ནད་ཡམས་དང་མུ་གེ་ཡང་འབྱུང་བར་འགྱུར། ནམ་མཁའ་ནས་འཇིགས་སྐྲག་སློང་བའི་སྔ་ལྟས་འབྱུང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","དོན་དེ་ཚོ་ཐམས་ཅད་མ་འབྱུང་བའི་སྔོན་དུ་ཁོ་ཚོས་ཁྱེད་རྣམས་བཟུང་ནས་གནོད་འཚེ་བྱེད་པ་དང༌། ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དང་བཙོན་ཁང་ལ་གཏད་ཅིང༌། ངའི་མིང་གི་དོན་དུ་ས་གནས་དཔོན་པོ་དང་རྒྱལ་པོ་རྣམས་ཀྱི་མདུན་དུ་འཁྲིད་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","དེས་ན་ཁྱེད་རྣམས་ལ་དཔང་པོ་བྱེད་པའི་གོ་སྐབས་འབྱུང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","དེའི་ཕྱིར་ཁྱེད་ཚོས་ལན་ཇི་ལྟར་འདེབས་པ་སྔོན་ལ་གྲ་སྒྲིག་མ་བྱེད་པར་ཐག་གཅོད་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","རྒྱུ་མཚན་ནི་ངས་ཁྱེད་རྣམས་ལ་ཤེས་རབ་དང་ལྡན་པའི་གཏམ་སྤྲོད་པར་བྱ། ཁྱེད་ཀྱི་ཁ་གཏད་རྣམས་ཀྱི་ནང་ནས་སུ་ཞིག་གིས་དེ་ལ་ཁས་མི་ལེན་པའམ་དགག་པ་རྒྱག་པར་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ཕ་མ་དང༌། སྤུན། གྲོགས་པོ་སོགས་ཀྱིས་ཀྱང་ཁྱེད་ཚོར་རྒྱབ་གཏོད་བྱེད་ལ། ཁ་གཏད་རྣམས་ཀྱིས་ཁྱེད་ཚོ་ལས་ཁ་ཤས་གསོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ཡང་ངའི་མིང་གི་དོན་དུ་མི་ཐམས་ཅད་ཀྱིས་ཁྱེད་ཚོ་ལ་སྡང་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","འོན་ཀྱང་ཁྱེད་ཀྱི་མགོའི་སྐྲ་རྐང་གཅིག་ཀྱང་འཇིག་པར་མི་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","བཟོད་པ་སྒོམ་པའི་སྒོ་ནས་ཁྱེད་ཚོའི་སྲོག་སྐྱོབ་ངེས་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ཁྱེད་རྣམས་ཀྱིས་ཡེ་རུ་ཤ་ལེམ་གྱི་ཕྱོགས་བཞི་ལ་དམག་དཔུང་གིས་སྐོར་བ་མཐོང་སྐབས། གྲོང་ཁྱེར་དེ་གཏོར་བའི་དུས་ལ་སླེབས་ཉེ་བ་ཤེས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","དེའི་སྐབས་སུ་ཡ་ཧུ་དཱ་ཡུལ་དུ་ཡོད་པའི་མི་རྣམས་རི་ལ་འབྲོས་དགོས། གྲོང་ཁྱེར་ལ་ཡོད་པ་རྣམས་ཕྱིར་ཐོན་ཅིང༌། གྲོང་གསེབ་ཀྱི་མི་རྣམས་གྲོང་ཁྱེར་ནང་དུ་མ་འགྲོ་ཞིག ");
INSERT INTO bod_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","གང་ལགས་ཟེར་ན། གསུང་རབ་ལ་གང་བྲིས་པ་ཐམས་ཅད་འགྲུབ་སྟེ་དུས་དེ་ནི་ཆད་པ་གཅོད་པའི་ཉིན་མོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ཉིན་དེ་ཚོའི་རིང་ལ་བུད་མེད་ཕྲུ་གུ་འཁོར་བ་དང་བུ་ཕྲུག་ལ་འོ་མ་སྟེར་མཁན་རྣམས་ལ་སྙིང་རེ་རྗེ། ཡུལ་ལ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང་བ་དང༌། སྡིག་ཉེས་བྱས་པའི་རྐྱེན་གྱིས་མི་རིགས་འདི་ལ་དཀོན་མཆོག་གི་ཐུགས་ཁྲོ་འབབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ཁ་ཤས་རལ་གྲིའི་ཁ་ཡིས་གསད་པ་དང༌། ཁ་ཤས་བཙོན་པར་འགྱུར་ནས་མི་རིགས་ཐམས་ཅད་ཀྱི་ཁྲོད་དུ་འཁྲིད། ཡ་ཧུ་དཱ་པ་མིན་པའི་མི་རིགས་ཀྱི་དུས་མ་ཚར་བའི་བར་དུ་ཡེ་རུ་ཤ་ལེམ་མི་དེ་ཚོའི་རྐང་འོག་ཏུ་རྫི་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ཡང་ཉི་མ་དང༌། ཟླ་བ། སྐར་མའི་རྟགས་འབྱུང་བར་འགྱུར་ལ། རྒྱ་མཚོ་དང་རྦ་རླབས་ཀྱི་འུར་སྒྲ་ཐོས་ནས་ས་གཞིའི་སྟེང་གི་མི་རིགས་སེམས་འཁྲུགས་ཏེ་སྡུག་བསྔལ་ཆེན་པོ་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","བར་སྣང་ཁམས་ཀྱི་དབང་ལྡན་རྣམས་གཡོ་བར་འགྱུར་བས་ས་གཞི་ལ་གང་འབྱུང་བར་འགྱུར་བ་ལ་འཇིགས་ནས་མི་རྣམས་དྲན་པ་འཐོར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","དེའི་དུས་སུ་མི་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་ཁོང་དབང་དང་གཟི་བརྗིད་ཆེན་པོ་དང་བཅས་སྤྲིན་པ་ཞིག་གི་ནང་དུ་འབྱོན་པར་མཐོང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","དོན་འདི་ཚོ་འབྱུང་སྐབས་ཁྱེད་ཚོ་ལངས་ནས་ཡར་ལྟོས་ཤིག གང་ཡིན་ཞེ་ན། ཁྱེད་ཀྱི་ཐར་བའི་དུས་ཐོན་ལ་ཉེ་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","དེ་ནས་ཁོང་གིས་“བསེ་ཡབ་ལ་སོགས་པའི་ཤིང་ནས་དཔེ་ཞིག་ལོངས། ");
INSERT INTO bod_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","དེའི་ལོ་མ་འབུས་མ་ཐག་ཁྱེད་ཚོས་དེ་མཐོང་བ་དང༌། དབྱར་ཁའི་དུས་ཉེ་བར་ཡོད་པ་རང་ཤུགས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","དེ་བཞིན་དུ་ཁྱེད་ཚོས་དོན་དེ་རྣམས་བྱུང་བ་མཐོང་ཚེ། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཉེ་བར་སླེབས་ཡོད་པ་རྟོགས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ངས་ཁྱེད་ཚོར་བདེན་པར་ཟེར་རྒྱུར། མི་རབས་འདི་མེད་པར་མ་གྱུར་བའི་སྔོན་ལ་དོན་འདི་ཐམས་ཅད་འབྱུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","གནམ་ས་གཉིས་ནི་འདའ་བར་འགྱུར་ཡང་ངའི་བཀའ་འདའ་བར་མི་འགྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","སྤྱོད་པ་ངན་པ་དང༌། ར་བཟི་བ། འཚོ་བའི་སྐོར་གྱི་སེམས་ཁྲལ་སོགས་ཀྱིས་ཁྱེད་མི་གནོན་པའི་ཕྱིར་དང༌། ཉིན་མོ་དེས་རྙི་ལྟར་ཁྱེད་ཚོ་འཛིན་པར་མི་འགྱུར་བའི་ཆེད་དུ་དོགས་ཟོན་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","གང་ལགས་ཟེར་ན། ཉིན་མོ་དེ་ནི་ས་གཞིའི་སྟེང་གི་མི་ཀུན་ལ་འབབ་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","འབྱུང་བར་འགྱུར་བའི་དོན་དེ་ཐམས་ཅད་ལས་ཐར་ཐུབ་པའི་སྟོབས་ཡིན་པ་དང༌། མིའི་རིགས་ཀྱི་བུའི་སྐུ་མདུན་དུ་ལངས་ནས་སྡོད་ཐུབ་པའི་སྨོན་ལམ་འདེབས་ཏེ། དུས་རྟག་ཏུ་དོགས་ཟོན་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ཉིན་ལྟར་ཁོང་གིས་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་ཆོས་བསྟན་གནང་བ་དང༌། མཚན་མོར་ཁོང་ཕྱི་རོལ་ཏུ་ཕེབས་ནས་སྐྱུར་རུ་ཟེར་བའི་ཤིང་གི་རི་ལ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ཡང་ཁོང་གི་གསུང་ལ་ཉན་པའི་ཕྱིར་མི་ཐམས་ཅད་སྔ་པོ་ལངས་ནས་མཆོད་ཁང་ཆེན་མོར་འགྲོ་མྱོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","དེ་ཡང་སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་ནམ་པེ་སག་ཅེས་བྱ་བའི་དུས་ཆེན་ཉེ་བར་སླེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","མི་ཚོགས་ལ་འཇིགས་པས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཡིས་ཡེ་ཤུ་གཡོ་ཐབས་ཀྱི་ངང་ནས་གསོད་པའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ཡང་ཡེ་ཤུའི་ཉེ་གནས་བཅུ་གཉིས་པོ་ལས་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་ཞེས་ཟེར་བའི་མི་ཞིག་གི་སེམས་ནང་དུ་བདུད་སཱ་ཏན་ཞུགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་དང༌། མཆོད་ཁང་ཆེན་མོའི་སྲུང་དམག་གི་དཔོན་པོའི་རྩར་སོང་ནས་ཡེ་ཤུ་ཁོ་ཚོའི་ལག་ཏུ་སྤྲོད་རྒྱུའི་གྲོས་སྡུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ཁོ་ཚོས་སྐད་ཆ་འདི་ཐོས་ནས་ཧ་ཅང་དགའ་པོ་བྱུང་སྟེ་ཁོ་ལ་དངུལ་སྤྲོད་རྒྱུའི་ཁས་ལེན་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ཁོས་དེ་ལ་མོས་མཐུན་བྱས་པ་དང༌། མི་ཚོགས་མེད་པའི་སྐབས་དང་བསྟུན་ནས་ཡེ་ཤུ་ཁོ་ཚོའི་ལག་ཏུ་སྤྲོད་རྒྱུའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","དེ་ནས་སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་གྱི་ཉིན་དང་པོར་སླེབས་དུས། པེ་སག་གི་ལུ་གུ་གསོད་དགོས་པའི་ཉིན་མོ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ཡེ་ཤུས་“སོང་ལ་ང་ཚོས་ཟ་བའི་ཕྱིར་པེ་སག་གི་གསོལ་སྟོན་གྲ་སྒྲིག་བྱོས་”ཞེས་གསུངས་ནས་ཁོང་གིས་ཉེ་གནས་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་མངགས། ");
INSERT INTO bod_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ཁོ་ཚོས་ཁོང་ལ་“ང་ཚོ་གང་དུ་གྲ་སྒྲིག་བྱེད་པར་འགྲོ་”ཞེས་ཞུས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ཁོང་གིས་ཁོ་ཚོར་“གྲོང་ཁྱེར་དུ་སླེབས་ནས་དེར་ཆུ་བུམ་འཁྱེར་བའི་སྐྱེས་པ་ཞིག་ཁྱེད་གཉིས་དང་འཕྲད་ཅིང༌། དེའི་རྗེས་སུ་འབྲངས་ནས་ཁོ་འཛུལ་སའི་ཁང་པ་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ཁྱེད་གཉིས་ཀྱིས་ཁྱིམ་དེའི་བདག་པོ་ལ་སྟོན་པས་ང་དང་ངའི་ཉེ་གནས་རྣམས་ཀྱིས་མཉམ་དུ་པེ་སག་གི་ཟས་ཟ་བའི་ཁང་མིག་གང་དུ་ཡོད་ཅེས་ཤོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","མི་དེས་ཁྱེད་གཉིས་ལ་ནང་ཆས་སོགས་གྲ་སྒྲིག་བྱས་ཡོད་པའི་ཐོག་ཁང་ཆེན་པོ་ཞིག་བསྟན་ཡོང༌། ཁྱེད་ཀྱིས་གནས་དེ་རུ་གྲ་སྒྲིག་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ཉེ་གནས་དེ་གཉིས་གྲོང་ཁྱེར་དུ་སོང་སྟེ་ཁོང་གིས་གསུངས་པ་ལྟར་མཐོང་ཞིང་གནས་དེར་པེ་སག་གི་གསོལ་སྟོན་བཤམས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","དུས་ལ་འབབ་པའི་ཚེ་ཁོང་དང་སྐུ་ཚབ་རྣམས་འཁོར་དང་བཅས་པ་གསོལ་སྟོན་དུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ཁོང་གིས་ཁོ་ཚོར་“ང་སྡུག་བསྔལ་མྱོང་བའི་སྔོན་དུ་པེ་སག་གི་གསོལ་སྟོན་འདི་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཤིན་ཏུ་ཟ་བར་འདོད། ");
INSERT INTO bod_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","གང་ཡིན་ཞེ་ན། ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་དེའི་ནང་དོན་མ་འགྲུབ་པའི་བར་དུ་ངས་ཡང་བསྐྱར་མི་ཟའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ཡང་ཁོང་གིས་ཕོར་པ་ཞིག་ཕྱག་ཏུ་བསྣམས་ཤིང༌། དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་ནས་ཁོང་གིས་“འདི་བླངས་ནས་ཁྱེད་ཀྱི་ནང་བགོ་བཤའ་བྱོས། ");
INSERT INTO bod_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ངས་ཁྱེད་ཚོ་ལ་ཟེར་རྒྱུར། ད་ནས་བཟུང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་མ་སླེབས་པའི་བར་དུ་ངས་རྒུན་འབྲུམ་ཤིང་གི་འབྲས་བུ་ལས་མི་འཐུང་ངོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ཡེ་ཤུས་བག་ལེབ་ཕྱག་ཏུ་བསྣམས་ཤིང༌། དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་ནས་དུམ་བུར་བགོས་ནས་ཁོ་རྣམས་ལ་གནང་སྟེ་“འདི་ནི་ངའི་ལུས་ཡིན་ཏེ་ཁྱེད་རྣམས་ཀྱི་དོན་དུ་སྦྱིན་པ་ཡིན། ང་དྲན་པའི་ཕྱིར་འདི་ལྟར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ཡང་དེ་བཞིན་དུ་ཁོང་རྣམས་ཞལ་ཟས་བཞེས་པའི་རྗེས་སུ། ཁོང་གིས་ཕོར་པ་ཕྱག་ཏུ་བསྣམས་ཏེ་“ཕོར་པ་འདི་ནི་ངའི་ཁྲག་གིས་བཀོད་པའི་ཞལ་ཆད་གསར་པ་ཡིན་ཏེ་ཁྱེད་ཀྱི་དོན་དུ་འཐོན་ནོ། ");
INSERT INTO bod_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ལྟོས་ཤིག ང་ལ་རྒྱབ་གཏོད་བྱེད་མཁན་གྱི་ལག་པ་དེའང་ང་དང་མཉམ་དུ་ཅོག་ཙེའི་སྒང་ལ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","དཀོན་མཆོག་གི་དགོངས་པ་བཞིན་དུ་མིའི་རིགས་ཀྱི་བུ་འཆི་དགོས་ཀྱང༌། དགྲའི་ལག་ཏུ་སྤྲོད་མཁན་དེར་ཆད་པ་ཕོག་ངེས་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","དེ་ནས་ཁོ་ཚོས་ཕན་ཚུན་དེ་ལྟར་བྱེད་མཁན་སུ་ཡིན་པའི་སྐོར་གྲོས་བསྡུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","དེ་ནས་ཁོ་ཚོའི་ནང་སུ་མཆོག་ཏུ་རྩི་བའི་རྩོད་གླེང་བྱུང་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ཁོང་གིས་ཁོ་ཚོར་“ཕྱི་པ་རྣམས་ཀྱི་རྒྱལ་པོས་ཁོ་ཚོར་དབང་སྒྱུར་བྱེད་ཅིང༌། ཁོ་ཚོའི་དཔོན་རིགས་ལ་སྦྱིན་བདག་ཞེས་ཟེར་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ཁྱེད་ཚོས་དེ་ལྟར་བྱེད་མི་རུང༌། ཁྱེད་ཚོ་ལས་སུ་ཞིག་མཆོག་ཏུ་གྱུར་བ་དེ་ཆུང་ཤོས་འདྲ་བ་དང༌། འགོ་ཁྲིད་པ་གཡོག་བྱེད་མཁན་འདྲ་བར་འགྱུར་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ཅོག་ཙེར་གསོལ་བ་བཞེས་མཁན་དང་གཡོག་པོ་བྱེད་མཁན་གཉིས་ལས་སུ་ཞིག་ཆེ། གསོལ་བ་བཞེས་མཁན་མ་ཡིན་ནམ། འོན་ཀྱང་ང་ནི་ཁྱེད་ཚོའི་ཁྲོད་དུ་གཡོག་བྱེད་མཁན་དང་འདྲའོ། ");
INSERT INTO bod_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ང་ཉམས་ཚོད་ལེན་དུས་ཁྱེད་རྣམས་ང་དང་མཉམ་དུ་གནས་པས། ");
INSERT INTO bod_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","ངའི་ཡབ་ཀྱིས་ཇི་ལྟར་ང་ལ་རྒྱལ་ཁམས་གནང་བ་བཞིན། དེ་ལྟར་ངས་ཀྱང་རྒྱལ་ཁམས་ཤིག་ཁྱེད་རྣམས་ལ་སྤྲོད། དེ་ནི་ངའི་རྒྱལ་ཁམས་སུ་ངའི་ཅོག་ཙེར་ཁྱེད་ཚོས་ཟ་ཞིང་འཐུང་བ་དང༌། ཁྲི་ལ་བཞུགས་ནས་ཡི་སི་ར་ཨེལ་གྱི་ཚོ་ཁག་བཅུ་གཉིས་ལ་ཁྲིམས་ཐག་གཅོད་བྱེད་པའི་ཕྱིར་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ཡང་ཁོང་གིས་“སི་མོན། སི་མོན། ཉོན་ཅིག སཱ་ཏན་གྱིས་ཁྱོད་རྣམས་ལ་གྲོ་ཞིབ་ཁྲོལ་ཚག་རྒྱག་པ་དང་འདྲ་བའི་ཉམས་ཚོད་བྱེད་པའི་ཕྱིར་ཆོག་མཆན་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","འོན་ཀྱང་ཁྱོད་རང་གི་དད་པ་མི་ཉམས་པའི་ཕྱིར་ངས་སྨོན་ལམ་བཏབ་པ་ཡིན། ཁྱོད་ཕྱིར་ལོག་བྱས་ནས་ཉེ་གནས་གཞན་རྣམས་ལ་བརྟན་པར་བྱོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","པེ་ཏྲོས་ཁོང་ལ་“གཙོ་བོ། ཁྱེད་དང་མཉམ་དུ་བཙོན་ཁང་ལ་འགྲོ་བ་དང༌། འཆི་བ་ལ་ཐུག་པའི་སེམས་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ཡེ་ཤུས་ཁོ་ལ་“པེ་ཏྲོ། ངས་ཁྱོད་ལ་ཟེར་རྒྱུར། དེ་རིང་གི་མཚན་མོ་འདི་རང་ལ་བྱ་ཕོས་སྐད་མ་གྲགས་པའི་སྔོན་ལ་ཁྱོད་ཀྱིས་ང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་སྨྲ་བར་ངེས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ངས་ཁྱེད་རྣམས་དངུལ་ཁུག་གམ། ཁུག་མ། ལྷམ་བཅས་མེད་པར་གཏོང་སྐབས། ཁྱོད་རྣམས་ལ་ཅི་ཡང་མ་ཚང་ངམ་”ཞེས་གསུངས་པས་ཁོ་ཚོས་“ང་ཚོར་ཅི་ཡང་མ་ཚང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ད་སུ་ལ་དངུལ་ཁུག་གམ། ཁུག་མ་ཡོད་ན་དེ་རྣམས་ཁུར་ཞིག སུ་ལ་རལ་གྲི་མེད་པ་དེས་ཕྱི་གོས་བཙོངས་ནས་རལ་གྲི་ཞིག་ཉོ་དགོས། ");
INSERT INTO bod_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ངས་ཁྱེད་ཚོར་ཟེར་རྒྱུར། གསུང་རབ་ནང་གང་བྲིས་པ་བཞིན། ཁོང་ནི་ཉེས་ཅན་གྱི་གྲས་སུ་བརྩིས་ཞེས་འགྲུབ་པར་འགྱུར་དགོས། གང་ཡིན་ཞེ་ན། ངའི་སྐོར་ལ་གང་བྲིས་ཡོད་པ་དེ་ང་རང་བརྒྱུད་ནས་འགྲུབ་བཞིན་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ཁོ་ཚོས་“གཙོ་བོ། གཟིགས་དང༌། རལ་གྲི་གཉིས་འདུག་”ཅེས་ཟེར་བས་ལན་དུ་ཁོང་གིས་“དོན་དེ་ཚར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","གྲོང་ཁྱེར་ནས་ཕྱི་རོལ་ཏུ་བྱོན་ཏེ་ཁོང་རང་གི་ལུགས་སྲོལ་ལྟར་སྐྱུར་རུ་ཟེར་བའི་ཤིང་གི་རི་ལ་ཕེབས་པ་དང༌། ཉེ་གནས་རྣམས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","དེར་སླེབས་ནས་ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་རྣམས་ཉམས་ཚོད་ནང་དུ་མི་ལྷུང་བའི་ཕྱིར་གསོལ་བ་ཐོབ་ཅིག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ཁོ་ཚོ་དང་ཁ་བྲལ་ཏེ་ཡེ་ཤུ་རྡོ་རྒྱང་གཅིག་ཙམ་ཕར་ཕེབས། ཞབས་པུས་སར་བཙུགས་ནས་ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ཀྱེ་ཡབ་ལགས། ཁྱེད་ཐུགས་མཉེས་པ་ཡིན་ན་ཕོར་པ་འདི་ང་ལས་ཕར་ལེན་མཛོད། འོན་ཀྱང་ངའི་བསམ་པ་བཞིན་དུ་མི་འགྱུར་བར་ཁྱེད་ཀྱི་དགོངས་པ་བཞིན་དུ་གྱུར་ཅིག་”ཅེས་གསོལ་བ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","དེའི་དུས་སུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ཕོ་ཉ་ཞིག་མངོན་སུམ་དུ་བྱོན་ནས། ཁོང་གི་ཐུགས་བརྟན་པོར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","སྡུག་བསྔལ་ཚད་མེད་མྱོང་སྟེ་ཁོང་གིས་དེ་བས་ཀྱང་གསོལ་སྨོན་ནན་གྱིས་ཞུས་པ་དང༌། ཁོང་གི་རྔུལ་ཆུ་ནི་ཁྲག་གི་ཐིགས་པ་ལྟར་ས་ལ་ལྷུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ཁོང་གསོལ་སྨོན་བཏབ་ནས་བཞེངས་ཏེ་ཉེ་གནས་རྣམས་ཀྱི་རྩར་ཕེབས་པ་དང༌། ཁོ་རྣམས་སེམས་སྐྱོ་ནས་གཉིད་ཁུག་པར་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ཁོ་ཚོར་“ཅིའི་ཕྱིར་གཉིད་ཉལ། ལོངས་ལ་ཁྱོད་ཚོ་ཉམས་ཚོད་ནང་དུ་མི་ལྷུང་བའི་ཕྱིར་གསོལ་བ་ཐོབ་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ཁོང་གིས་དེ་ལྟར་གསུང་སྐབས་ཉེ་གནས་བཅུ་གཉིས་པོ་ལས་ཡུ་དཱ་ཞེས་བྱ་བ་དེས་མི་ཚོགས་ཁྲིད་དེ་ཡོང་བ་དང༌། ཁོས་ཡེ་ཤུ་ལ་འོ་བྱེད་པའི་ཕྱིར་ཁོང་གི་མདུན་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","འོན་ཀྱང་ཡེ་ཤུས་ཁོ་ལ་“ཡུ་དཱ། ཁྱོད་ཀྱིས་འོ་ཡིས་མིའི་རིགས་ཀྱི་བུ་ལ་རྒྱབ་གཏོད་བྱེད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ཉེ་འགྲམ་དུ་ཡོད་པའི་མི་རྣམས་ཀྱིས་གང་ཞིག་འབྱུང་རྒྱུ་ཡིན་པ་མཐོང་ནས་ཁོ་ཚོས་“གཙོ་བོ། ང་ཚོས་རལ་གྲི་རྒྱག་གམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ཁོ་ཚོའི་ནང་ནས་མི་ཞིག་གིས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོའི་གཡོག་པོར་རལ་གྲི་བརྒྱབ་ནས་རྣ་བ་གཡས་པ་བཅད། ");
INSERT INTO bod_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","འོན་ཀྱང་ཡེ་ཤུས་“དེ་ལྟར་མ་བྱོས་ཤིག་”ཅེས་གསུངས་ནས་མི་དེའི་རྣ་བར་རེག་ནས་གསོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ཡང་ཡེ་ཤུས་ཁོང་འཛིན་བཟུང་བྱེད་དུ་ཡོང་བ་རྣམས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། མཆོད་ཁང་ཆེན་མོའི་སྲུང་དམག་གི་དཔོན་པོ་དང༌། རྒན་པོ་བཅས་ལ་“ཁྱེད་ཚོས་རལ་གྲི་དང་དབྱུག་པ་ཁྱེར་ནས་ཇག་པ་འཛིན་པ་ལྟར་ང་འཛིན་དུ་ཡོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ང་ཉིན་རེ་བཞིན་མཆོད་ཁང་ཆེན་མོར་ཁྱེད་ཚོའི་མདུན་དུ་ཡོད་ནའང༌། ཁྱེད་ཚོས་ང་བཟུང་མེད། འོན་ཀྱང་འདི་ནི་ཁྱེད་རྣམས་ཀྱི་དུས་དང་མུན་ནག་གི་དབང་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ཡེ་ཤུ་འཛིན་བཟུང་བྱས་ནས་ཁོ་ཚོས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོའི་ཁང་ཆེན་ལ་ཁྲིད་པ་དང༌། པེ་ཏྲོའང་རྒྱང་རིང་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","སྒོ་རའི་དཀྱིལ་ལ་མེ་ཞིག་བཏང་ནས་མི་དེ་ཚོ་ལྷན་དུ་བསྡད་པ་དང༌། པེ་ཏྲོ་ཡང་དེ་ཚོའི་ཁྲོད་ལ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","པེ་ཏྲོ་མེའི་འོད་ཀྱི་འོག་ཏུ་བསྡད་ནས་ཁོ་ལ་ནན་གྱིས་བལྟས་པས་གཡོག་མོ་ཞིག་གིས་“མི་འདི་ཡང་ཁོ་དང་མཉམ་དུ་ཡོད་པ་གཅིག་རེད་”ཅེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","པེ་ཏྲོས་ཁས་མ་བླངས་ཏེ་“བུ་མོ། ངས་ཁོ་ངོ་མི་ཤེས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","དེ་ནས་ཅུང་མ་འགོར་བར་མི་གཞན་ཞིག་གིས་ཁོ་མཐོང་ནས་“ཁྱེད་ཀྱང་ཁོ་ཚོའི་ནང་ནས་གཅིག་རེད་”ཅེས་བཤད། འོན་ཀྱང་པེ་ཏྲོས་“ང་གཏན་ནས་མ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ཆུ་ཚོད་གཅིག་ཙམ་འགོར་བའི་རྗེས་སུ་མི་གཞན་ཞིག་གིས་“སྐྱེས་པ་འདི་ག་ལིལ་ཡུལ་གྱི་མི་ཞིག་ཡིན་པས་དངོས་གནས་དེ་ཚོའི་ནང་ནས་གཅིག་ཡིན་པར་ངེས་”ཞེས་ཨུ་ཚུགས་བྱས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","པེ་ཏྲོས་“ཁྱེད་ཀྱིས་གང་བཤད་པ་ངས་མི་ཤེས་”ཞེས་སྨྲས་མ་ཐག་ཏུ་བྱ་ཕོས་སྐད་གྲགས། ");
INSERT INTO bod_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","གཙོ་བོས་ཞལ་ཕྱིར་སྐོར་ཏེ་པེ་ཏྲོ་ལ་གཟིགས་པ་དང༌། པེ་ཏྲོ་ཡེ་ཤུས་ཁོ་རང་ལ། དེ་རིང་གི་མཚན་མོ་འདི་རང་ལ་བྱ་ཕོས་སྐད་མ་གྲགས་པའི་སྔོན་ལ་ཁྱེད་ཀྱིས་ང་སུ་ཡིན་མི་ཤེས་ཞེས་ཐེངས་གསུམ་ཟེར་བར་ངེས་ཞེས་གསུངས་པ་དེ་དྲན་པས། ");
INSERT INTO bod_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ཁོ་ཕྱིར་སོང་ནས་སེམས་ཤིན་ཏུ་སྐྱོ་བས་ངུས། ");
INSERT INTO bod_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","སྲུང་མཁན་རྣམས་ཀྱིས་ཡེ་ཤུ་ལ་འཕྱ་སྨོད་བྱས་ནས་བརྡུངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","སྤྱན་ཟུང་རས་ཀྱིས་བཏུམས་ཏེ་ཁོང་ལ་“ད་མངོན་ཤེས་ཤོད་ཅིག ཁྱོད་རྡུང་མཁན་དེ་སུ་ཡིན་”ཅེས་བརྗོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ཁ་ངན་བཤད་དེ་ཁོང་ལ་དམའ་འབེབས་མང་པོ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ནམ་ལངས་པའི་ཚེ་ཡུལ་མི་རྣམས་ཀྱི་རྒན་པོ་དང༌། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་བཅས་འཛོམས་ནས་ཁོང་རྒྱལ་ཚོགས་ཀྱི་མདུན་དུ་འཁྲིད་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","མི་དེ་ཚོས་“ཁྱོད་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ན་ང་ཚོ་ལ་ཤོད་ཅིག་”ཅེས་སྨྲས་པས་ཁོང་གིས་“གལ་ཏེ་ངས་ཁྱེད་ཚོར་བཤད་ན། ཁྱེད་ཚོས་ཡིད་མི་ཆེས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","གལ་ཏེ་ངས་ཁྱེད་ཚོར་དྲི་བ་ཞིག་དྲིས་ན་ལན་མི་རྒྱག ");
INSERT INTO bod_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","འོན་ཀྱང་ད་ནས་བཟུང་མིའི་རིགས་ཀྱི་བུ་དབང་ཀུན་དང་ལྡན་པའི་དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་བཞུགས་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ཡང་ཁོ་ཚོ་ཚང་མས་“བྱས་ན་ཁྱོད་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་ནམ་”ཞེས་དྲིས་པས་ལན་དུ་ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཀྱིས་སྨྲས་པ་ལྟར་ང་དེ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","དེ་ནས་ཁོ་ཚོས་“ད་དུང་དཔང་པོ་ཅི་དགོས། ང་ཚོ་རང་གིས་ཁོའི་ཁ་ནས་ཐོས་”ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","དེ་ནས་རྒྱལ་ཚོགས་ཀྱི་མི་ཐམས་ཅད་ཡར་ལངས་ནས་ཡེ་ཤུ་སྤྱི་ཁྱབ་པི་ལ་ཏུའི་མདུན་དུ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ཁོ་ཚོས་ཁོང་ལ་ཉེས་སྐྱོན་བཙུགས་ཏེ་“མི་འདིས་ང་ཚོའི་མི་རིགས་ལ་མགོ་སྐོར་བཏང་སྟེ། ང་ཚོས་རྒྱལ་པོ་སེ་སར་ལ་ཁྲལ་འཇལ་མི་ཆོག་པ་དང༌། ཁོ་རང་རྒྱལ་པོ་མཱ་ཤི་ཀ་ཡིན་ཞེས་བཤད་པ་ང་ཚོས་ཐོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","དེའི་ཕྱིར་པི་ལ་ཏུས་ཁོང་ལ་“ཁྱོད་ནི་ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་རྒྱལ་པོ་ཡིན་ནམ་”ཞེས་ཁོང་ལ་དྲིས་པ་ན། ཁོང་གིས་“ཁྱེད་ཀྱིས་སྨྲས་པ་བཞིན་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","དེ་ནས་པི་ལ་ཏུ་ཡིས་བླ་ཆེན་དང་མི་ཚོགས་ལ་“ངས་མི་འདི་ལ་ཉེས་སྐྱོན་ཅིའང་མ་རྙེད་”ཅེས་བཤད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ཁོ་ཚོས་“ག་ལིལ་ཡུལ་ནས་ས་ཆ་འདིའི་བར་དུ་ཡ་ཧུ་དཱ་ཡུལ་ཡོངས་སུ་ཆོས་བསྟན་པའི་སྒོ་ནས་ཁོས་མི་རྣམས་ལ་ངན་བསྐུལ་བྱེད་ཀྱི་འདུག་”ཅེས་ཨུ་ཚུགས་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","པི་ལ་ཏུ་ཡིས་གཏམ་དེ་ཐོས་ནས་ཁོང་ག་ལིལ་ཡུལ་གྱི་མི་ཡིན་ནམ་ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ཡེ་ཤུ་ནི་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡི་འབངས་མི་ཡིན་པ་ཐོས་རྗེས་དེའི་དུས་སུ་ཧེ་རོ་དཱེ་ཡེ་རུ་ཤ་ལེམ་ལ་ཡོད་པས་པི་ལ་ཏུས་ཁོང་ཧེ་རོ་དཱེ་ཡི་རྩར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ཧེ་རོ་དཱེ་དུས་ཡུན་རིང་པོའི་སྔོན་ནས་ཡེ་ཤུ་དང་མཇལ་བར་འདོད་པས་ཁོང་མཐོང་ནས་ཤིན་ཏུ་དགའ། ཡེ་ཤུའི་སྐོར་ཐོས་ནས་ཁོང་གིས་ངོ་མཚར་བའི་རྟགས་ཤིག་མཛད་པར་མཐོང་བའི་རེ་བ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ཧེ་རོ་དཱེ་ཡིས་ཁོང་ལ་དྲི་བ་མང་པོ་དྲིས་ཀྱང༌། ཁོང་གིས་ལན་ཅིའང་མ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ཡང་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང༌། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ཀྱིས་དེར་ལངས་ཏེ་ཁོང་ལ་ཉེས་སྐྱོན་ནན་གྱིས་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ཧེ་རོ་དཱེ་དང་ཁོའི་དམག་མི་རྣམས་ཀྱིས་ཁོང་ལ་མཐོང་ཆུང་དང་འཕྱ་སྨོད་བྱས་ཏེ་ན་བཟའ་མཛེས་པོ་ཁོང་ལ་གཡོགས་ནས་པི་ལ་ཏུའི་རྩར་ཕྱིར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","དེའི་སྔོན་ལ་ཧེ་རོ་དཱེ་དང་པི་ལ་ཏུ་ཕན་ཚུན་དགྲ་ཁ་གཏད་ཡིན་ཡང༌། ཉིན་དེ་རང་ལ་གྲོགས་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","པི་ལ་ཏུ་ཡིས་བླ་ཆེན་དང༌། དཔོན་རིགས། ཡུལ་མི་བཅས་ཁོའི་དྲུང་དུ་བོས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ཁོ་ཚོར་“ཁྱོད་རྣམས་ཀྱིས་མི་འདི་ཟིང་ཆ་སློང་དུ་ངན་བསྐུལ་བྱེད་མཁན་ལྟར་ངའི་རྩར་ཁྲིད། ཁྱོད་ཚོའི་མདུན་དུ་ངས་ཁོ་ལ་འདྲི་གཅོད་བྱས་ཀྱང༌། ཁྱོད་ཀྱིས་སྨྲས་པའི་ཉེས་སྐྱོན་ཅིའང་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ཧེ་རོ་དཱེ་ཡིས་ཁོང་ང་ཚོར་ཕྱིར་ལོག་མངགས་པས་ཁོང་ལ་ཡང་ཉེས་སྐྱོན་མ་རྙེད། མི་འདིས་སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་ཉེས་པ་ཅི་ཡང་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","དེའི་ཕྱིར་ངས་ཁོ་ལ་ཉེས་ཆད་བཅད་ནས་གློད་གྲོལ་གཏོང་རྒྱུ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","འོན་ཀྱང་མི་ཚོགས་ཐམས་ཅད་ཀྱིས་ལྷན་གཅིག་ཏུ་“ཁོ་ཕར་ཁྲིད། པར་ཨབ་པཱ་ཟེར་མཁན་དེ་གློད་གྲོལ་གཏོང་ཞིག་”ཅེས་འབོད་སྒྲ་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(པར་ཨབ་པཱ་ཟེར་བ་དེ་གྲོང་ཁྱེར་ལ་ཟིང་འཁྲུག་བསླངས་པ་དང༌། མི་བསད་པའི་རྐྱེན་གྱིས་བཙོན་ཁང་ལ་བཅུག་) ");
INSERT INTO bod_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ཡེ་ཤུ་གློད་གྲོལ་གཏོང་འདོད་པས་པི་ལ་ཏུས་ཡང་བསྐྱར་མི་ཚོགས་ལ་གཏམ་བཤད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ཁོ་ཚོས་སྐད་ཆེན་པོས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་ཡང་ཡང་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ཐེངས་གསུམ་པར་ཡང་ཁོས་མི་དེ་ཚོར་“རྒྱུ་མཚན་གང་ཡིན། ཁོས་ལས་ངན་ག་རེ་བྱས་ཡོད། མི་འདིས་སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་ཉེས་པ་ཅི་ཡང་མ་བྱས་པས་ངས་ཁོ་ལ་ཉེས་ཆད་བཅད་ནས་གློད་གྲོལ་གཏོང་རྒྱུ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","འོན་ཀྱང་ཁོ་ཚོས་འབོད་སྒྲ་སྒྲོག་སྟེ་ཁོང་རྒྱང་ཤིང་སྒང་ལ་གསོད་དགོས་པར་ཨུ་ཚུགས་བྱས་པས་མཐར་ཁོ་ཚོའི་འདོད་པ་བཞིན་དུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","དེ་ནས་པི་ལ་ཏུས་ཁོ་ཚོའི་རེ་བ་བཞིན་དུ་བྱེད་དགོས་པའི་བཀའ་བསྩལ། ");
INSERT INTO bod_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","པི་ལ་ཏུས་ཟིང་འཁྲུག་བསླངས་པ་དང༌། མི་བསད་པའི་རྐྱེན་གྱིས་བཙོན་ཁང་ལ་བཅུག་པའི་མི་དེ་གློད་གྲོལ་བཏང་ནས་མི་ཚོགས་ཀྱི་འདོད་པ་ལྟར་ཡེ་ཤུ་རྩིས་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ཁོང་ཕར་འཁྲིད་དུས་སེ་རེ་ནཱ་པ་སི་མོན་གྲོང་གསེབ་ནས་ཡོང་བ་དང༌། ཁོ་ཚོས་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས་ཏེ་རྒྱང་ཤིང་འཁུར་དུ་འཇུག་ཕྱིར་ཁོ་བཟུང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","མི་ཚོགས་མང་པོ་ཞིག་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས། ཁོ་ཚོའི་ནང་ཁོང་གི་ཕྱིར་ངུ་ཞིང་སྨྲེ་སྔགས་འདོན་པའི་བུད་མེད་རྣམས་ཀྱང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","འོན་ཀྱང་ཡེ་ཤུས་ཞལ་ཕྱིར་སྐོར་ཏེ་ཁོ་ཚོར་“ཡེ་རུ་ཤ་ལེམ་གྱི་བུ་མོ། ངའི་དོན་ལ་མ་ངུ༌། ཁྱེད་དང་ཁྱེད་ཀྱི་བུ་ཕྲུག་གི་དོན་དུ་ངུས་ཤིག ");
INSERT INTO bod_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","གང་ལགས་ཟེར་ན། རབས་ཆད་མ་རྣམས་དང༌། ཕྲུ་གུ་མ་བཙའ་བ། འོ་མ་མ་སྟེར་མཁན་རྣམས་བདེའོ་ཞེས་ཟེར་བའི་དུས་ལ་འབབ་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","དེའི་དུས་སུ་ཁོ་ཚོས་རི་ཆེན་ལ་ང་ཚོར་ས་རུད་རྒྱོབ་དང༌། རི་ཆུང་ལ་ང་ཚོར་སར་སྦོས་རྒྱོབ་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ཤིང་སྡོང་རློན་པའི་སྐབས་སུ་འདི་ལྟར་བྱས་ན། བསྐམས་ནས་ཅི་ལྟར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ཁོང་དང་མཉམ་དུ་ཉེས་ཅན་གཉིས་སྲོག་གཅོད་གཏོང་ཕྱིར་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","མགོ་རུས་ཞེས་ཟེར་བའི་ས་ཆར་སླེབས་ནས་ཁོང་མཉམ་དུ་ཉེས་ཅན་གཉིས་ནས་གཅིག་ཁོང་གི་གཡས་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་དང་གཅིག་ཁོང་གི་གཡོན་ཕྱོགས་སུ་ཡོད་པའི་རྒྱང་ཤིང་ལ་གཟེར་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","དེ་ནས་ཡེ་ཤུས་“ཀྱེ་ཡབ་ལགས། ཁོ་ཚོས་གང་བྱེད་པ་མི་རྟོགས་པས་ཁོ་ཚོའི་སྡིག་ཉེས་སེལ་བར་མཛོད་”ཅེས་གསུངས་པ་དང༌། དམག་མིས་རྒྱན་བརྒྱབ་ནས་ཁོང་གི་ན་བཟའ་བགོ་བཤའ་བྱས། ");
INSERT INTO bod_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","མི་ཚོགས་ཀྱིས་ས་ཆ་དེར་བལྟས་ནས་བསྡད། དཔོན་རིགས་ཀྱིས་ཀྱང་ཁོང་ལ་འཕྱ་དམོད་བྱེད་དེ་“ཁོས་གཞན་རྣམས་བསྐྱབས་ཏེ་ཁོ་ནི་དཀོན་མཆོག་གིས་བདམས་པའི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ན། རང་ཉིད་སྐྱོབ་པར་བྱོས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","དམག་མིས་ཀྱང་ཁོང་ལ་འཕྱ་སྨོད་བྱེད་དེ་ཁོང་གི་མདུན་དུ་ཡོང་ནས་ཁོང་ལ་རྒུན་ཆང་སྐྱུར་མོ་ཕུལ་ཏེ། ");
INSERT INTO bod_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ཁྱོད་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཡིན་ན་རང་ཉིད་སྐྱོབ་པར་བྱོས་ཤིག་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ཁོང་གི་སྟེང་ལ་ཡོད་པའི་ཉེས་ཚིག་ལ་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཞེས་བྲིས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","དེར་རྒྱང་ཤིང་ལ་ཡོད་པའི་ཉེས་ཅན་གཉིས་ལས་གཅིག་གིས་ཁོང་ལ་ཁ་ངན་བཤད་དེ་“ཁྱོད་སྐྱབས་མགོན་མཱ་ཤི་ཀ་མ་ཡིན་ནམ། ཁྱོད་ཀྱིས་རང་ཉིད་དང་ང་ཚོ་སྐྱོབས་ཤིག་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","འོན་ཀྱང་མི་དེ་ལ་བཀའ་བཀྱོན་བྱས་ནས་ཉེས་ཅན་གཞན་གྱིས་“ཁྱོད་ལ་ཡང་ཁོང་གི་ཉེས་ཆད་དང་འདྲ་བ་ཕོག་པས་ཁྱོད་རང་དཀོན་མཆོག་ལའང་མི་འཇིགས་སམ། ");
INSERT INTO bod_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ང་ཚོ་གཉིས་ཀྱིས་བྱས་པའི་ལས་ངན་དང་མཐུན་པའི་ཆད་པ་བྱུང་བས་ང་ཚོར་དྲང་པོའི་ཁྲིམས་གཅོད་ཕོག འོན་ཀྱང་མི་འདིས་ཉེས་སྐྱོན་ཅི་ཡང་མ་བྱས་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ཁོས་“ཡེ་ཤུ་ལགས། ཁྱེད་ཀྱི་རྒྱལ་སྲིད་ཐོབ་དུས་ང་དྲན་དུ་གསོལ་”ཞེས་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ཁོང་གིས་ཁོ་ལ་“ངས་ཁྱོད་ལ་བདེན་པར་ཟེར་རྒྱུར། ཉིན་མོ་འདི་རང་ལ་ཁྱོད་ང་དང་མཉམ་དུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཡོད་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","ཉི་མ་བསྒྲིབས་ཏེ་ཉིན་གུང་ནས་ཆུ་ཚོད་གསུམ་པའི་བར་དུ་ལུང་པ་དེ་ཡོངས་སུ་མུན་པས་ཁེངས། དེའི་སྐབས་མཆོད་ཁང་ཆེན་མོའི་ནང་གི་ཡོལ་བ་དེ་དུམ་བུ་གཉིས་སུ་རལ། ");
INSERT INTO bod_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","དེ་ནས་ཡེ་ཤུས་གསུང་སྐད་ཆེན་པོས་“ཀྱེ་ཡབ་ལགས། ང་ཡི་སེམས་ཁྱེད་ཀྱི་ཕྱག་ལ་བཅོལ་ལོ་”ཞེས་གསུངས་ནས་ཁོང་སྐུ་ཚེ་ལས་འདས་སོ། ");
INSERT INTO bod_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","དེར་ལངས་བསྡད་ཡོད་པའི་དམག་མི་བརྒྱ་དཔོན་ཞིག་གིས་གང་བྱུང་བ་དེ་མཐོང་ནས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཏེ་“མི་འདི་ངེས་པར་སྐྱོན་མེད་པ་ཞིག་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","བྱ་བ་འདི་རྣམས་ལ་ལྟ་བའི་ཆེད་དུ་དེར་འཛོམས་པའི་མི་ཚང་མས་གང་བྱུང་བ་མཐོང་ནས་བྲང་ཁོག་བརྡུངས་ཏེ་སོ་སོའི་ནང་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","འོན་ཀྱང་ཁོང་གི་ངོ་མཁྱེན་པ་ཐམས་ཅད་དང༌། ག་ལིལ་ཡུལ་ནས་ཁོང་གི་རྗེས་སུ་འབྲངས་པའི་བུད་མེད་རྣམས་རྒྱང་རིང་དུ་བསྡད་དེ་བྱ་བ་འདི་ཚོར་བལྟས། ");
INSERT INTO bod_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","དེ་ནས་ཡོ་སེབ་ཟེར་མཁན་མི་སེམས་བཟང་ཞིང་དྲང་པོ་ཡིན་པ་དང༌། ཡ་ཧུ་དཱ་པའི་རྒྱལ་ཚོགས་ཀྱི་ཁོངས་མི་ཡིན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","མི་དེ་ཚོའི་འཆར་གཞི་དང་བྱ་བ་དེ་དག་ལ་མི་མཐུན་ཏེ། ཁོང་ནི་ཡ་ཧུ་དཱ་པའི་གྲོང་ཁྱེར་ཨ་རི་མ་ཐཱ་ནས་ཡིན་ལ། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་སྒུག་མཁན་ཞིག་ཀྱང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","མི་འདི་པི་ལ་ཏུའི་རྩར་ཕྱིན་ཏེ་ཡེ་ཤུའི་སྐུ་ཕུང་གནང་རོགས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ཡོ་སེབ་ཀྱིས་ཡེ་ཤུའི་སྐུ་ཕུང་མར་ཕབ་པ་དང༌། རས་སྤུས་ལེགས་ཤིག་གིས་སྒྲིལ་ནས་བྲག་ལ་བརྐོས་པའི་དུར་ཁང་སྤུར་བཞག་མ་མྱོང་བ་ཞིག་གི་ནང་དུ་བཞག་གོ ");
INSERT INTO bod_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ཉིན་དེ་ནི་གྲ་སྒྲིག་གི་ཉིན་མོ་ཡིན་ཞིང་ངལ་གསོའི་ཉིན་མོ་སླེབས་ལ་ཉེ། ");
INSERT INTO bod_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ག་ལིལ་ཡུལ་ནས་ཡེ་ཤུ་དང་མཉམ་དུ་ཕེབས་པའི་བུད་མེད་རྣམས་ཡོ་སེབ་ཀྱི་རྗེས་སུ་འབྲངས་པ་དང༌། དེ་རྣམས་ཀྱིས་དུར་ཁང་དང༌། ཁོང་གི་སྐུ་ཕུང་ཅི་ལྟར་བཞག་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","དེ་ནས་ཁོ་ཚོ་ཕྱིར་ལོག་ནས་དྲི་ཞིམ་འབྱུག་རྫས་གྲ་སྒྲིག་བྱས། ཡང་ངལ་གསོའི་ཉིན་མོར་དཀོན་མཆོག་གི་བཀའ་ལྟར་ངལ་གསོ་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","བདུན་ཕྲག་གཅིག་གི་ཉིན་དང་པོའི་ཞོགས་པ་ཉི་མ་ཤར་ཙམ་ལ་བུད་མེད་ཚོས་གྲ་སྒྲིག་བྱས་པའི་དྲི་ཞིམ་འབྱུག་རྫས་འཁུར་ཏེ་ཁོ་ཚོ་དུར་ཁང་ལ་ཕྱིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ཁ་རྡོ་དེ་བསྒྲིལ་ཚར་ཡོད་པ་མཐོང་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","དུར་ཁང་གི་ནང་ལ་འཛུལ་སྐབས་གཙོ་བོ་ཡེ་ཤུའི་སྐུ་ཕུང་མ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","དེ་བས་ཐེ་ཚོམ་བྱུང་སྐབས་མི་གཉིས་འོད་འཕྲོ་བའི་གོས་གྱོན་པ་གློ་བུར་དུ་ཁོ་ཚོའི་འགྲམ་ལ་མངོན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","འཇིགས་སྐྲག་སྐྱེས་ཏེ་བུད་མེད་རྣམས་མགོ་བཏུད་པ་དང༌། མི་དེ་གཉིས་ཀྱིས་ཁོ་མོ་ཚོར་“གསོན་པོ་ནི་གཤིན་པོའི་ནང་ཅིའི་ཕྱིར་འཚོལ། ");
INSERT INTO bod_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ཁོང་འདིར་མེད་དེ་སྐུ་གསོན་པོར་བཞེངས་སོ། ཁོང་ག་ལིལ་ཡུལ་ལ་བཞུགས་པའི་ཚེ་ཁྱོད་རྣམས་ལ། ");
INSERT INTO bod_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","མིའི་རིགས་ཀྱི་བུ་སྡིག་ཉེས་ཅན་གྱི་ལག་ཏུ་གཏད་པ་དང༌། རྒྱང་ཤིང་ལ་བཀྲོངས་ནས་ཉིན་ཞག་གསུམ་པ་ལ་ཁོ་རང་ལང་བར་འགྱུར་ངེས་ཞེས་པའི་གསུང་དེ་དྲན་ཅིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ཁོ་མོ་ཚོས་ཁོང་གི་གསུང་དྲན། ");
INSERT INTO bod_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","དུར་ཁང་ནས་ཕྱིར་ལོག་སྟེ། ཉེ་གནས་བཅུ་གཅིག་པོ་དང་གཞན་རྣམས་ལ་དོན་དེ་ཐམས་ཅད་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","དོན་འདི་ཚོ་སྐུ་ཚབ་ལ་རྗོད་མཁན་རྣམས་ནི་མག་རྡལ་ནས་ཡིན་པའི་མིར་ཡམ་དང༌། ཡོ་ཨ་ནཱ། ཡ་ཀོབ་ཀྱི་ཡུམ་མིར་ཡམ་ལ་སོགས་པའི་བུད་མེད་རྣམས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","འོན་ཀྱང་སྐུ་ཚབ་རྣམས་ཀྱི་བསམ་པར་གཏམ་འདི་དོན་མེད་པ་ཡིན་པས་བུད་མེད་རྣམས་ལ་ཡིད་མ་ཆེས། ");
INSERT INTO bod_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","འོན་ཀྱང་པེ་ཏྲོ་ལངས་ནས་དུར་ཁང་ལ་བརྒྱུགས་པ་དང༌། བསྒུར་ནས་ནང་ལ་བལྟས་ཏེ་རས་སྤུས་ལེགས་གཅིག་པུ་མཐོང་ནས། ངོ་མཚར་སྐྱེས་ཏེ་རང་གི་ནང་ལ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ཉིན་དེ་རང་ལ་ཁོ་ཚོ་ནས་མི་གཉིས་ཡེ་རུ་ཤ་ལེམ་ནས་རྒྱང་ཐག་སྤྱི་ལེ་བཅུ་གཅིག་ཙམ་ཡོད་པའི་ཨེ་མ་ཨུ་ཞེས་པའི་གྲོང་གསེབ་ལ་འགྲོ་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ཁོ་ཚོས་གང་བྱུང་བ་ཐམས་ཅད་ཀྱི་སྐོར་ལ་གཏམ་གླེང་བྱེད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","དེའི་དུས་སུ་ཡེ་ཤུ་རང་ཉིད་ཉེ་བར་བྱོན་ཏེ་ཁོ་ཚོ་དང་མཉམ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ཁོ་ཚོ་མིག་བསྒྲིབས་པ་ལྟར་གྱུར་བས་ཁོང་མཐོང་ན་ཡང་སུ་ཡིན་པ་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོ་ལམ་ལ་འགྲོ་དུས་གཏམ་གླེང་ཅི་བྱེད་”ཅེས་གསུངས་པས་ཁོ་ཚོའི་གདོང་ལ་སྐྱོ་བའི་ཉམས་ཤིག་ཤར་ནས་བསྡད། ");
INSERT INTO bod_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ལན་དུ་ཁོ་གཉིས་ལས་ཀཱ་ལི་ཨོ་ཕཱ་ཟེར་མཁན་གཅིག་གིས་ཁོང་ལ་“ཡེ་རུ་ཤ་ལེམ་གྱི་མཇལ་མཁན་རྣམས་ལས་ཁྱེད་གཅིག་པུས་དེང་སང་གང་བྱུང་བ་མི་ཤེས་པ་ཡིན་ནམ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ཡང་ཡེ་ཤུས་“གང་བྱུང་”ཞེས་གསུངས་པས་ཁོ་ཚོས་ཁོང་ལ་“ན་ཙ་རེལ་པ་ཡེ་ཤུ་ལ་གང་བྱུང་བའི་སྐོར་ནི། ཁོང་དཀོན་མཆོག་དང་མི་ཐམས་ཅད་ཀྱི་མདུན་དུ་འཕྲིན་ལས་དང་བཀའ་ལ་ནུས་མཐུ་དང་ལྡན་པའི་ལུང་སྟོན་པ་ཞིག་ཡིན་ལ། ");
INSERT INTO bod_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","བླ་ཆེན་དང་ང་ཚོའི་དཔོན་རིགས་ཀྱིས་ཁོང་ལ་སྲོག་ཁྲིམས་གཏོང་བའི་ཕྱིར་པི་ལ་ཏུ་ལ་གཏད་ནས་རྒྱང་ཤིང་སྒང་ལ་བསད། ");
INSERT INTO bod_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ཡི་སི་ར་ཨེལ་གྱི་སྐྱབས་མཛད་མཁན་ཁོང་ཡིན་པ་དེ་ང་ཚོས་རེ་བ་བྱས། མ་ཟད་བྱ་བ་དེ་ཐམས་ཅད་བྱུང་ནས་ཉི་མ་གསུམ་སོང་བ་ལ། ");
INSERT INTO bod_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ཡང་ང་ཚོའི་ནང་ནས་བུད་མེད་ཁ་ཤས་ཀྱིས་ང་ཚོར་ཡ་མཚན་སྐྱེད་དུ་བཅུག གང་ལགས་ཟེར་ན། དེ་རིང་ཞོགས་པ་ཉི་མ་ཤར་ཙམ་ལ་ཁོ་ཚོ་དུར་ཁང་ལ་འགྲོ་སྐབས། ");
INSERT INTO bod_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ཁོང་གི་སྐུ་ཕུང་མ་རྙེད། དེ་ནས་ཁོ་ཚོ་ཡོང་ནས་ང་ཚོ་ལ་དཀོན་མཆོག་གི་ཕོ་ཉ་ཡིས་ང་ཚོར་ཁོང་གསོན་པོ་ཡིན་ཞེས་གསུངས་པའི་ཞལ་གཟིགས་མཐོང་བྱུང་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ང་ཚོ་དང་མཉམ་དུ་ཡོད་པ་ཁ་ཅིག་གིས་དུར་ཁང་ལ་ཕྱིན་ནས་བུད་མེད་ཀྱིས་བཤད་པ་ལྟར་མཐོང༌། འོན་ཀྱང་ཁོང་མཐོང་མ་བྱུང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ལུང་སྟོན་པ་རྣམས་ཀྱིས་གང་གསུངས་པ་ཐམས་ཅད་ལ་ཡིད་ཆེས་དཀའ་བ་བླུན་པོ་ཁྱོད་རྣམས། ");
INSERT INTO bod_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","སྐྱབས་མགོན་མཱ་ཤི་ཀ་སྡུག་བསྔལ་དེ་ལྟར་མྱོང་ནས་ཁོང་གི་གཟི་བརྗིད་ལ་ཞུགས་མི་དགོས་སམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","དེ་ནས་ལུང་སྟོན་པ་མོ་ཤེ་ཡི་མདོ་ནས་བཟུང་དང་ལུང་སྟོན་པ་གཞན་རྣམས་ཀྱི་མདོ་རེ་རེ་བཞིན་ཁོང་གི་སྐོར་ལ་གང་བྲིས་པ་ཁོ་ཚོར་གསལ་སྟོན་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ཁོ་ཚོ་འགྲོ་སའི་གྲོང་གསེབ་དང་ཉེ་བར་སླེབས་སྐབས་ཁོང་ད་དུང་ཕར་ལ་ཕེབས་པའི་ཚུལ་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","འོན་ཀྱང་མི་དེ་ཚོས་“ཕྱི་དྲོ་ཡིན་ཏེ་ཉི་མ་ནུབ་ལ་ཉེ་བས་ང་ཚོ་དང་མཉམ་དུ་བཞུགས་རོགས་”ཞེས་ནན་གྱིས་ཞུས། ཁོང་ཁོ་ཚོ་དང་མཉམ་དུ་བཞུགས་པའི་ཕྱིར་གནས་ཁང་ནང་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ཁོ་ཚོ་དང་མཉམ་དུ་ཅོག་ཙེར་བཞུགས་ཚེ་ཡེ་ཤུས་བག་ལེབ་ཕྱག་ཏུ་བསྣམས་ཤིང༌། དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་རྗེས་དུམ་བུར་བགོས་ནས་ཁོ་རྣམས་ལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","དེ་ནས་ཁོ་ཚོའི་མིག་ཕྱེ་ནས་ཁོང་སུ་ཡིན་པ་ཤེས་རྗེས་ཁོང་དེ་ཚོའི་མིག་ལམ་ནས་མི་སྣང་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“ལམ་ལ་ཁོང་གིས་ང་ཚོར་གསུང་གླེང་དང་གསུང་རབ་གསལ་སྟོན་མཛད་སྐབས་ང་ཚོ་སེམས་འགུལ་མི་ཐེབས་སམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ཆུ་ཚོད་དེ་རང་ལ་ཁོ་ཚོ་ལངས་ནས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག ཉེ་གནས་བཅུ་གཅིག་པོ་སོགས་འཛོམས་པ་དང་ཐུག་ནས། ");
INSERT INTO bod_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ཁོ་རྣམས་ཀྱིས་“གཙོ་བོ་དངོས་སུ་སྐུ་གསོན་པོར་བཞེངས་པ་དང་སི་མོན་ལ་མངོན་སུམ་དུ་གྱུར་རོ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ཁོ་གཉིས་ཀྱིས་ལམ་ལ་གང་བྱུང་བའི་གཏམ་དང༌། ཅི་ལྟར་བག་ལེབ་བགོས་པའི་སྒོ་ནས་ཁོ་ཚོས་ཁོང་སུ་ཡིན་ངོ་ཤེས་པར་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","དེ་ལྟར་བཤད་པའི་དུས་སུ་ཁོང་ཉིད་ཁོ་ཚོའི་དཀྱིལ་ལ་བཞེངས་ཏེ་ཁོ་ཚོར་“ཞི་བདེ་ཁྱེད་རྣམས་ལ་འབབ་པར་ཤོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ཁོ་ཚོས་དེ་མཐོང་ནས་གདོན་འདྲེ་ཡིན་པར་བསམས་ཏེ་འཇིགས་སྐྲག་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོ་ཅི་ལ་ཞེད་སྣང་སྐྱེས་ཤིང༌། ཁྱོད་ཀྱི་སེམས་སུ་ཅིའི་ཕྱིར་ཐེ་ཚོམ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ངའི་རྐང་པ་དང་ལག་པ་ལ་ལྟོས་དང༌། ངའི་ལུས་ལ་རེག་ནས་ང་རང་ཡིན་པ་རྟོགས་པར་གྱིས་ཤིག གང་ཡིན་ཞེ་ན། ང་ལྟར་གདོན་འདྲེ་ལ་ཤ་དང་རུས་པ་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ཁོང་གིས་དེ་ལྟར་གསུངས་ནས་རང་གི་ཞབས་དང་ཕྱག་ཁོ་ཚོ་ལ་སྟོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","སེམས་དགའ་བའི་རྐྱེན་གྱིས་ཁོ་ཚོས་ད་དུང་ཡིད་མ་ཆེས་ཏེ་ཡ་མཚན་ཆེན་པོར་གྱུར་བའི་དུས་སུ་ཁོང་གིས་ཁོ་ཚོར་“ཟས་ཅི་ཞིག་ཡོད་དམ་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ཁོ་ཚོས་ཁོང་ལ་མེ་སྲེག་ཐེབས་པའི་ཉ་ཤ་དུམ་བུ་ཞིག་སྟེར་ནས། ");
INSERT INTO bod_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","དེ་ཕྱག་ཏུ་བསྣམས་ཏེ་ཁོ་ཚོའི་མདུན་དུ་བཞེས། ");
INSERT INTO bod_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","དེ་ནས་ཁོང་གིས་ཁོ་ཚོར་“ཁྱོད་ཚོ་དང་མཉམ་དུ་ཡོད་པའི་ཚེ་ངས་འདི་ལྟར་སྨྲས། མོ་ཤེ་ཡི་བཀའ་ཁྲིམས་དང༌། ལུང་སྟོན་པ་རྣམས་དང་གསུང་མགུར་ཞེས་པའི་མདོ་ལས་ངའི་སྐོར་བྲིས་པ་ཐམས་ཅད་འགྲུབ་པར་འགྱུར་ངེས་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","དེ་ནས་མདོ་རྣམས་རྟོགས་པའི་ཕྱིར་ཁོང་གིས་ཁོ་ཚོའི་བློ་སྒོ་འབྱེད་པར་མཛད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ཁོ་ཚོར་“སྐྱབས་མགོན་མཱ་ཤི་ཀ་སྡུག་བསྔལ་མྱོང་ནས་ཉི་མ་གསུམ་པར་འཆི་བ་ལས་གསོན་པོར་བཞེངས་པར་འགྱུར་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ཡེ་རུ་ཤ་ལེམ་ནས་བཟུང་སྟེ་མི་རིགས་ཀུན་ལ་ཁོང་གི་མཚན་གྱི་ཐོག་ནས་སྡིག་ཉེས་སེལ་བའི་ཆེད་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བ་དེ་སྒྲོག་དགོས་པ་བྲིས་འདུག ");
INSERT INTO bod_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","དོན་འདི་ཚོ་ལ་དཔང་པོ་བྱེད་མཁན་ཁྱེད་རྣམས་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ཡང་ལྟོས་ཤིག ངའི་ཡབ་ཀྱིས་ཞལ་གྱིས་བཞེས་པའི་དམ་པའི་ཐུགས་ཉིད་ངས་ཁྱེད་ཚོར་འབབ་ཏུ་འཇུག ཁྱེད་ཚོར་སྟེང་ནས་ནུས་མཐུ་ཡིས་ཡོངས་སུ་མ་ཁྱབ་པའི་བར་དུ་གྲོང་ཁྱེར་ལ་སྡོད་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","དེའི་རྗེས་སུ་ཁོང་གིས་ཁོ་ཚོ་ཕྱི་རོལ་ཏུ་པེ་ཐན་ཡཱ་ཞེས་བྱ་བའི་གྲོང་གསེབ་ཀྱི་བར་དུ་ཁྲིད་པ་དང༌། ཕྱག་ཟུང་ཡར་བཏེག་སྟེ་ཁོ་ཚོར་བྱིན་རླབས་གནང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","དེ་ལྟར་མཛད་པའི་རིང་ལ་ཁོ་རྣམས་དང་ཁ་བྲལ་ཏེ་ཁོང་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་འཕགས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ཁོང་ལ་བསྙེན་བཀུར་ཞུས་པའི་རྗེས་སུ་དེ་རྣམས་དགའ་སྤྲོ་ཆེན་པོས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ཁོ་ཚོ་མཆོད་ཁང་ཆེན་མོར་དུས་རྒྱུན་དུ་གནས་ཏེ་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ལོ། །");
INSERT INTO bod_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ཐོག་མར་བཀའ་ཡོད་ལགས་པ་དང༌། བཀའ་ནི་དཀོན་མཆོག་དང་མཉམ་དུ་བཞུགས། བཀའ་དེ་དཀོན་མཆོག་ལགས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ཁོང་ནི་ཐོག་མར་དཀོན་མཆོག་དང་མཉམ་དུ་བཞུགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ཁོང་བརྒྱུད་ནས་ཅི་ཡོད་པ་ཐམས་ཅད་བྱུང་བ་དང༌། ཁོང་མེད་པར་ཅི་ཡང་མ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ཁོང་གི་ནང་ན་དཔག་ཏུ་མེད་པའི་ཚེ་ཡོད་པ་དང༌། ཚེ་དེ་ནི་མི་ཐམས་ཅད་ཀྱི་འོད་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","འོད་དེ་མུན་པའི་ནང་དུ་འཕྲོ། མུན་པས་དེ་མནན་པར་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","དཀོན་མཆོག་གིས་མི་ཞིག་མངགས་ཏེ། ཁོང་གི་མིང་ལ་ཡོ་ཧ་ནན་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","མི་ཐམས་ཅད་ཁོང་བརྒྱུད་ནས་དད་པ་བྱེད་པའི་ཕྱིར་ཁོང་ནི་འོད་དེ་ལ་དཔང་པོ་བྱེད་པའི་ཆེད་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ཁོང་རང་ནི་འོད་དེ་མ་ཡིན་མོད། འོད་དེ་ལ་དཔང་པོ་བྱེད་པའི་ཕྱིར་འོངས། ");
INSERT INTO bod_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","བདེན་པའི་འོད་མི་ཐམས་ཅད་ལ་འོད་གནང་བའི་ཕྱིར་འཇིག་རྟེན་ལ་བྱོན། ");
INSERT INTO bod_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ཁོང་ནི་འཇིག་རྟེན་འདིར་བཞུགས་ཏེ། ཁོང་ཉིད་བརྒྱུད་ནས་འཇིག་རྟེན་བཀོད་ན་ཡང༌། འཇིག་རྟེན་གྱི་མི་རྣམས་ཀྱིས་ཁོང་ངོ་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ཁོང་ནི་རང་གི་ཡུལ་ལ་ཕེབས་ན་ཡང༌། རང་གི་ཡུལ་མི་རྣམས་ཀྱིས་ཁོང་མ་བསུས། ");
INSERT INTO bod_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","འོན་ཀྱང་ཁོང་བསུས་ནས་ཁོང་གི་མཚན་ལ་དད་པ་བྱེད་མཁན་ཐམས་ཅད་ལ་ཁོང་གིས་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོར་འགྱུར་བའི་དབང་ཆ་གནང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","དེ་རྣམས་ནི་མ་ཡི་མངལ་ལས་སྐྱེས་པ་མ་ཡིན་ལ། མི་ཡི་འདོད་པའི་དབང་གིས་མ་སྐྱེས་ཤིང་ཁྱོ་གའི་བསམ་འདུན་བཞིན་དུའང་སྐྱེས་པ་མིན། དཀོན་མཆོག་ལས་སྐྱེས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","བཀའ་ཞེས་པ་དེ་མི་རུ་གྱུར་བ་དང༌། ཐུགས་རྗེ་དང་བདེན་པ་ཉིད་ཀྱིས་གང་བ་ཡིན་ཏེ་ང་ཚོའི་ཁྲོད་དུ་གནས། ཁོང་གི་གཟི་བརྗིད་ཡབ་ནས་བྱུང་བའི་སྲས་གཅིག་པོའི་གཟི་བརྗིད་དེ་ང་ཚོས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ཡོ་ཧ་ནན་གྱིས་“ང་ཡི་རྗེས་སུ་ཕེབས་མཁན་ནི། ང་ལས་སྔོན་དུ་ཡོད་པས་ང་ལས་ཆེ་བ་ཡིན་ཞིང༌། ངས་སྔོན་སྨྲས་པའི་སྐྱེས་བུ་ནི་ཁོང་ཉིད་ཡིན་”ཞེས་ཁོང་གི་སྐོར་གསུངས་ནས་དཔང་པོ་བྱས་ཤིང་འབོད་སྒྲ་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ཁོང་གི་ཕུན་སུམ་ཚོགས་པ་ལས་ང་ཚོ་ཚང་མར་ཐུགས་རྗེ་ཡང་ཡང་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","དཀོན་མཆོག་གིས་ལུང་སྟོན་པ་མོ་ཤེ་བརྒྱུད་ནས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་གནང་མོད། ཐུགས་རྗེ་དང་བདེན་པ་ཉིད་ནི་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","མི་སུས་ཀྱང་དཀོན་མཆོག་གཏན་ནས་མ་མཐོང༌། ཡབ་དཀོན་མཆོག་གི་སྐུ་པང་ལ་བཞུགས་པའི་སྲས་གཅིག་པོས་འཇིག་རྟེན་ཀུན་ལ་ཁོང་གི་སྐོར་གསལ་སྟོན་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ལ་ཡོད་པའི་ཡ་ཧུ་དཱ་པའི་ཆོས་དཔོན་རིགས་ཀྱིས་ཡ་ཧུ་དཱ་པའི་བླ་མ་རྣམས་དང་ལེ་ཝི་པ་ཟེར་བའི་མཆོད་གཡོག་པོ་རྣམས་ཡོ་ཧ་ནན་གྱི་དྲུང་དུ་བཏང་ནས། ཁོང་ལ་ཁྱེད་སུ་ཡིན་ཞེས་འདྲི་བའི་ཕྱིར། ");
INSERT INTO bod_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ཡོ་ཧ་ནན་གྱིས་སྦ་གསང་ཅི་ཡང་མེད་པར་དྲང་པོར་གསུངས་ཏེ་“ང་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་མིན་”ཞེས་དཔང་པོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","མི་དེ་ཚོས་“བྱས་ན་ཁྱེད་སུ་ཡིན། ཁྱེད་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཡིན་ནམ་”ཞེས་ཟེར་བ་དང་ཁོང་གིས་“མ་ཡིན་”ཞེས་གསུངས། ཁོ་ཚོས་“ཁྱེད་ལུང་སྟོན་པ་ཞེས་པ་དེ་ཡིན་ནམ་”ཞེས་དྲིས་པ་དང་ཁོང་གིས་“མ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","མི་དེ་རྣམས་ཀྱིས་“ང་ཚོ་གཏོང་མཁན་རྣམས་ལ་ལན་འདེབས་དགོས་པས། ཁྱེད་རང་གིས་ཁྱེད་སུ་ཡིན་པ་ཤོད་རོགས་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ཁོང་གིས་“ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡི་མདོ་ལས་གསུངས་པ་ལྟར། དབེན་སྟོང་ནང་ལ་གྲགས་པའི་འབོད་སྒྲ་ཡིས། ། གཙོ་བོའི་ཕེབས་ལམ་བདེ་མོ་བཟོ་བར་གྱིས། ། ཞེས་གསུང་བའི་སྒྲ་དེ་ནི་ང་ཡིན་”ཞེས་ལན་བཏབ། ");
INSERT INTO bod_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་གིས་བཏང་ཡོད་པའི་མི་འདི་རྣམས་ཀྱིས་ཡོ་ཧ་ནན་ལ་ ");
INSERT INTO bod_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ད་ཁྱེད་སྐྱབས་མགོན་མཱ་ཤི་ཀ་མ་ཡིན་ན། ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཡང་མ་ཡིན་ན། ལུང་སྟོན་པ་ཟེར་མཁན་དེ་ཡང་མ་ཡིན་པས། ཅིའི་ཕྱིར་མི་ལ་ཁྲུས་གསོལ་གནང་ངམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","དེའི་ལན་དུ་ཡོ་ཧ་ནན་གྱིས་“ངས་མི་རྣམས་ལ་ཆུ་ཡིས་ཁྲུས་གསོལ་བྱེད་བཞིན་ཡོད། འོན་ཀྱང་ཁྱེད་རྣམས་ཀྱིས་ངོ་མི་ཤེས་པའི་སྐྱེས་བུ་དེ་ནི་ཁྱེད་ཚོའི་ཁྲོད་དུ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ཁོང་ངའི་རྗེས་སུ་འབྱོན་ཀྱང་ང་ནི་ཁོང་གི་ལྷམ་སྒྲོག་འགྲོལ་བར་ཡང་མི་འོས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","དོན་འདི་རྣམས་ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་གནང་བའི་གནས་པེ་ཐན་ཡཱ་ཞེས་བྱ་བ་ཡོར་དན་གཙང་པོའི་ཕར་ཕྱོགས་སུ་བྱུང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","དེའི་ཕྱི་ཉིན་ཡོ་ཧ་ནན་གྱིས་ཡེ་ཤུ་རང་གི་མདུན་དུ་ཕེབས་པར་མཐོང་སྟེ་“ལྟོས་དང༌། འདི་ནི་དཀོན་མཆོག་གི་ལུ་གུ་ཡིན་ཏེ་འཇིག་རྟེན་གྱི་སྡིག་ཉེས་སེལ་མཁན་ནི་ཁོང་ཉིད་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","སྔར་ངས་ང་ཡི་རྗེས་སུ་ཕེབས་མཁན་ནི། ང་ལས་སྔོན་དུ་ཡོད་པས་ང་ལས་ཆེ་བ་ཡིན་ཞིང༌། ངས་སྔོན་སྨྲས་པའི་སྐྱེས་བུ་ནི་ཁོང་ཉིད་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ང་རང་གིས་ཁོང་ངོ་མ་ཤེས། འོན་ཀྱང་ཁོང་ཡི་སི་ར་ཨེལ་ལ་ངོ་སྤྲོད་བྱེད་པའི་ཕྱིར་ཆུ་ཡིས་ཁྲུས་གསོལ་བྱེད་དུ་ང་འོངས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","ཡང་ཡོ་ཧ་ནན་གྱིས་དཔང་པོ་བྱས་ཏེ་“དམ་པའི་ཐུགས་ཉིད་ཕུག་རོན་ལྟར་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་སྟེ་ཁོང་གི་སྟེང་དུ་གནས་པར་ངས་མཐོང་མྱོང༌། ངས་ཁོང་ངོ་མ་ཤེས་ཡོད་ཀྱང་ང་ཆུ་ཡིས་ཁྲུས་གསོལ་དུ་མངགས་མཁན་གྱིས་ངར་འདི་སྐད་གསུངས། ཁྱོད་ཀྱིས་སུའི་ཐོག་ཏུ་དམ་པའི་ཐུགས་ཉིད་བབ་ནས་བཞུགས་པར་མཐོང་བ་དེ་ནི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྲུས་གསོལ་མཁན་དེ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ཁོང་གིས་“ང་རང་གིས་དེ་བཞིན་དུ་མཐོང་མྱོང་བས། མི་འདི་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་པར་དཔང་པོ་བྱས་ཡོད་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","དེའི་ཕྱི་ཉིན་ཡང་ཡོ་ཧ་ནན་ཁོང་གི་ཉེ་གནས་གཉིས་དང་མཉམ་དུ་དེར་ཡོད་དེ། ");
INSERT INTO bod_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ཡེ་ཤུ་ཕེབས་པ་མཐོང་སྟེ་ཡོ་ཧ་ནན་གྱིས་“ལྟོས་དང༌། འདི་ནི་དཀོན་མཆོག་གི་ལུ་གུ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ཉེ་གནས་དེ་གཉིས་ཀྱིས་ཁོང་གིས་གསུངས་པ་དེ་ཐོས་ནས་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ཡེ་ཤུས་ཞལ་ཕྱིར་བསྐོར་ཏེ་རྗེས་སུ་འབྲང་མཁན་དེ་གཉིས་གཟིགས་ཏེ་“ཁྱེད་ཚོས་ཅི་འཚོལ་བ་ཡིན་ནམ་”ཞེས་གསུངས་པས་དེ་གཉིས་ཀྱིས་“རབ་བི། (རབ་བི་ཟེར་ན་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་སློབ་དཔོན་ཡིན་) ཁྱེད་རང་ག་པར་བཞུགས་ཀྱི་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ཁོང་གིས་“ཤོག་ལ་ལྟོས་དང་”ཞེས་གསུངས། ཁོ་གཉིས་འོངས་པ་དང་ཁོང་གི་བཞུགས་ས་མཐོང་ནས་ཕྱི་དྲོའི་ཆུ་ཚོད་བཞི་ཙམ་ཡོད་པས་ཉིན་མོ་དེ་ཁོང་དང་མཉམ་དུ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ཡོ་ཧ་ནན་གྱིས་གསུངས་པ་དེ་ཐོས་ནས་ཡེ་ཤུའི་རྗེས་སུ་འབྲང་མཁན་དེ་གཉིས་ཀྱི་ནང་ནས་གཅིག་ནི་སི་མོན་པེ་ཏྲོ་ཡི་སྤུན་ཨན་དྲི་ཡཱ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ཨན་དྲི་ཡཱས་ཐོག་མར་རང་གི་སྤུན་སི་མོན་ཐུག་ནས་དེ་ལ་“ང་ཚོས་སྐྱབས་མགོན་མཱ་ཤི་ཀ་མཇལ་བྱུང་”ཞེས་ཟེར། (མཱ་ཤི་ཀ་ཟེར་ན་བྱུགས་པའི་མི་ཡི་དོན་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","དེ་ནས་ཨན་དྲི་ཡཱ་ཡིས་སི་མོན་ཡེ་ཤུའི་སྐུ་དྲུང་དུ་ཁྲིད། ཡེ་ཤུས་ཁོ་ལ་གཟིགས་ནས་“ཁྱེད་ནི་ཡོ་ཧ་ནན་ཞེས་བྱ་བའི་བུ་སི་མོན་ཡིན་ཏེ། ཁྱེད་ཀྱི་མིང་ལ་ཀེ་ཕཱ་ཞེས་གདགས་རྒྱུ་ཡིན་”ཞེས་གསུངས། (ཀེ་ཕཱ་ཡི་དོན་ནི་པེ་ཏྲོ་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","དེའི་སང་ཉིན་ཡེ་ཤུ་ག་ལིལ་ཡུལ་དུ་ཕེབས་པར་དགོངས་ཏེ། ཕི་ལིབ་དང་ཐུག་ནས་ཁོ་ལ་“ངའི་རྗེས་སུ་འབྲོངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ཕི་ལིབ་ནི་པེ་སད་དཱ་པ་ཡིན་པས། ཨན་དྲི་ཡཱ་དང་པེ་ཏྲོ་གཉིས་དང་ཕ་ཡུལ་གཅིག་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ཕི་ལིབ་ན་ཐན་ཨེལ་དང་ཐུག་ནས་ཁོ་ལ་“ལུང་སྟོན་པ་མོ་ཤེས་བཀའ་ཁྲིམས་ཀྱི་མདོའི་ནང་བྲིས་ཡོད་པ་དང༌། ལུང་སྟོན་པ་རྣམས་ཀྱིས་ཀྱང་ལུང་བསྟན་ལས་སྐྱེས་བུ་དེའི་སྐོར་བྲིས་ཡོད་པའི་ན་ཙ་རེལ་གྲོང་སྡེ་ནས་ཡིན་པ་ཡོ་སེབ་ཀྱི་བུ་ཡེ་ཤུ་ང་ཚོས་མཇལ་བྱུང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ན་ཐན་ཨེལ་གྱིས་“ན་ཙ་རེལ་ནས་དོན་ལེགས་པོ་ཞིག་འབྱུང་བར་སྲིད་དམ་”ཞེས་ཟེར་བས་ལན་དུ་ཕི་ལིབ་ཀྱིས་“ཤོག་ལ་ལྟོས་དང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ཡེ་ཤུས་ན་ཐན་ཨེལ་དྲུང་དུ་འོང་བར་གཟིགས་ནས་“ལྟོས་དང༌། འདི་ནི་བདེན་པའི་ཡི་སི་ར་ཨེལ་པ་ཡིན་ཏེ། སེམས་ལ་གཡོ་སྒྱུ་མེད་པ་ཞིག་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ན་ཐན་ཨེལ་གྱིས་ཁོང་ལ་“ཁྱེད་ཀྱིས་ང་ཇི་ལྟར་མཁྱེན་”ཞེས་ཞུས་པས་ཡེ་ཤུས་“ཁྱེད་བསེ་ཡབ་ཤིང་གི་འོག་ལ་བསྡད་ཡོད་པའི་ཚེ། ཕི་ལིབ་ཀྱིས་ཁྱེད་མ་བོས་པའི་སྔོན་ལ་ངས་ཁྱེད་མཐོང་བྱུང་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ན་ཐན་ཨེལ་གྱིས་“རབ་བི། ཁྱེད་རང་ནི་དཀོན་མཆོག་གི་སྲས་དང་ཡི་སི་ར་ཨེལ་གྱི་རྒྱལ་པོ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","དེའི་ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱེད་བསེ་ཡབ་ཤིང་གི་འོག་ལ་མཐོང་བྱུང་ཞེས་ཁྱེད་ལ་བཤད་པས་ཁྱེད་ཀྱིས་དད་པ་བྱེད་དམ། ཁྱེད་ཀྱིས་དོན་དེ་ལས་ཆེ་བ་མཐོང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ཡང་ཁོང་གིས་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུ་ཡིན་ཏེ། དཀོན་མཆོག་གི་ཞིང་ཁམས་བྱེ་ནས། དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་མིའི་རིགས་ཀྱི་བུ་ཟེར་མཁན་གྱི་ཐོག་ཏུ་འབབ་པ་དང་འཛེག་པར་ཁྱེད་རྣམས་ཀྱིས་མཐོང་གི་རེད་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","དེ་ནས་ཉི་མ་གསུམ་པ་ལ་ག་ལིལ་ཡུལ་གྱི་ཀ་ནཱ་ཟེར་བའི་གྲོང་ཁྱེར་ལ་བག་སྟོན་ཅིག་ཡོད་དེ། ཡེ་ཤུའི་ཡུམ་དེ་རུ་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ཡེ་ཤུ་དང་ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱང་བག་སྟོན་དུ་མགྲོན་ལ་བོས། ");
INSERT INTO bod_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","རྒུན་ཆང་རྫོགས་སྐབས། ཡེ་ཤུའི་ཡུམ་གྱིས་ཁོང་ལ་“ཁོ་ཚོར་རྒུན་ཆང་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ཡེ་ཤུས་ཁོང་ལ་“ཨ་མ་ལགས། ཁྱེད་ཀྱིས་ཅིའི་ཕྱིར་ང་རང་དོན་དེ་དང་འབྲེལ་བ་ཡོད་པར་བྱ་འདོད་དམ། ངའི་དུས་ཚོད་ད་དུང་མ་སླེབས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ཁོང་གི་ཡུམ་གྱིས་དེར་ཡོད་པའི་གཡོག་པོ་རྣམས་ལ་“ཁོང་གིས་ཁྱེད་ཚོ་ལ་གང་གསུང་པ་བཞིན་དུ་བྱོས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ད་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱི་གཙང་བར་བྱེད་པའི་ཆོས་ཁྲིམས་བཞིན་དུ་རྡོའི་ཆུ་བན་རེ་རེ་ལ་ཧ་ལམ་ཧྲེང་བརྒྱ་གཤོང་བ་དྲུག་དེར་བཞག་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ཡེ་ཤུས་གཡོག་པོ་ཚོར་“བན་འདི་ཚོ་ཆུ་ཡིས་རྒྱོངས་”ཞེས་བཀའ་གནང་བས་ཁོ་ཚོས་བན་ཡོངས་སུ་ཁེངས་པར་ཆུས་བཀང༌། ");
INSERT INTO bod_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ཁོང་གིས་“ད་བཅུས་ནས་གསོལ་དཔོན་ལ་སྐྱོལ་དང་”ཞེས་གསུངས་པ་དང་གཡོག་པོས་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","གསོལ་དཔོན་དེས་ཆུ་རྒུན་ཆང་དུ་གྱུར་བའི་བྲོ་བ་མྱངས་ནས། དེ་ག་ནས་བྱུང་མིན་མ་ཤེས་ཀྱང༌། གཡོག་པོ་ཆུ་འཆུ་མཁན་གྱིས་ཤེས། གསོལ་དཔོན་གྱིས་མག་པ་བོས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“མི་གཞན་དག་ཚང་མས་སྔོན་ལ་རྒུན་ཆང་སྤུས་ལེགས་སྟེར་ནས་མགྲོན་པོ་རྣམས་ཀྱིས་མང་པོ་བཏུངས་པའི་རྗེས་སུ་རྒུན་ཆང་ཞན་པ་ཞིག་སྟེར། འོན་ཀྱང་ཁྱེད་ཀྱིས་རྒུན་ཆང་ལེགས་པོ་ད་ལྟ་བར་ཉར་ཚགས་བྱས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","དེ་ལྟར་ཡེ་ཤུས་ག་ལིལ་ཡུལ་གྱི་གྲོང་ཁྱེར་ཀ་ནཱ་ལ་ངོ་མཚར་བའི་རྟགས་དང་པོ་བསྟན་ཏེ། རང་གི་གཟི་བརྗིད་མངོན་པར་མཛད་པས་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་དད་པ་བྱས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","དེའི་རྗེས་སུ་ཡེ་ཤུ་རང་གི་ཡུམ་དང་སྐུ་མཆེད་དང༌། ཉེ་གནས་རྣམས་དང་མཉམ་དུ་ཀ་ཕར་ན་ཧུམ་ཞེས་པའི་གྲོང་ཁྱེར་ལ་མར་ཕེབས་ནས། དེར་ཉིན་ཤས་བཞུགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ཡང་པེ་སག་ཟེར་བའི་ཡ་ཧུ་དཱ་པའི་དུས་ཆེན་ཉེ་བས། ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་ལ་ཡར་ཕེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","དེར་ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་ཆེན་མོའི་སྒོ་ར་ལ་བ་གླང་དང༌། ལུག ཕུག་རོན་བཅས་ཚོང་མཁན་དང༌། དངུལ་རྗེ་མཁན་རྣམས་བསྡད་ཡོད་པར་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ཁོང་གིས་ཐག་པའི་རྟ་ལྕག་ཅིག་མཛད་ནས། སྒོ་རའི་ནང་ནས་ལུག་དང་བ་གླང་ཐམས་ཅད་ཕྱིར་བཏོན་པ་དང༌། དངུལ་རྗེ་མཁན་གྱི་ལྕོག་ཙེ་མགོ་རྟིང་བསློགས་ནས་དངུལ་སྒོར་གཏོར། ");
INSERT INTO bod_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ཕུག་རོན་ཚོང་མཁན་རྣམས་ལ་“འདི་ཐམས་ཅད་འདི་ནས་ཕྱིར་ཁྱེར་ཞིག ངའི་ཡབ་ཀྱི་གནས་མཆོག་ནི་ཚོང་རར་མ་བྱོས་”ཞེས་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ཁྱེད་ཀྱི་ཕོ་བྲང་གི་ཆེད་དུ་བརྩོན་སེམས་ཀྱིས་ང་མེད་པ་བཟོ་བར་བྱ་ཞེས་མདོ་ལས་བྲིས་འདུག་པ་དེ་ཉེ་གནས་རྣམས་ཀྱིས་དྲན། ");
INSERT INTO bod_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","དེ་ནས་ཡ་ཧུ་དཱ་པའི་ཆོས་དཔོན་རྣམས་ཀྱིས་“ཁྱེད་ཀྱིས་ལས་འདི་འདྲ་མཛད་པའི་དབང་ཆ་ཡོད་པ་སྟོན་པའི་ཕྱིར་ང་ཚོ་ལ་ངོ་མཚར་བའི་དོན་གང་སྟོན་པར་མཛད་དམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ལན་དུ་ཡེ་ཤུས་“མཆོད་ཁང་འདི་བཤིག་ན་ངས་ཉིན་ཞག་གསུམ་ལ་སླར་ཡང་རྩིག་པར་བྱའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ཡ་ཧུ་དཱ་པའི་ཆོས་དཔོན་རྣམས་ཀྱིས་“མཆོད་ཁང་ཆེན་མོ་འདི་ནི་ལོ་བཞི་བཅུ་ཞེ་དྲུག་རིང་ལ་བརྩིགས་པ་ཡིན། ཁྱེད་ཀྱིས་ཞག་གསུམ་ལ་སླར་ཡང་བརྩིག་རྒྱུ་ཡིན་ནམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","འོན་ཀྱང་ཡེ་ཤུས་རང་གི་སྐུ་ལུས་ཡིན་པའི་མཆོད་ཁང་ལ་དཔེ་མཛད་དེ་གསུངས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","དེས་ཁོང་འཆི་བ་ནས་སྐུ་གསོན་པོར་བཞེངས་སྐབས་ཉེ་གནས་རྣམས་ཀྱིས་གསུངས་དེ་དྲན་པ་དང༌། མདོ་དང་ཡེ་ཤུས་གསུངས་པའི་བཀའ་དེ་གཉིས་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ཡང་ཡེ་ཤུ་པེ་སག་གི་དུས་ཆེན་ལ་ཡེ་རུ་ཤ་ལེམ་ལ་བཞུགས་པའི་ཚེ། མི་མང་པོས་ཁོང་གིས་མཛད་པའི་ངོ་མཚར་བའི་རྟགས་མཐོང་བས་ཁོང་གི་མཚན་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","འོན་ཀྱང་ཡེ་ཤུས་མི་ཐམས་ཅད་མཁྱེན་པས་སུས་ཀྱང་གཞན་གྱི་སྐོར་ཁོང་ལ་ཞུ་མ་དགོས་པར། མི་རྣམས་ཀྱི་སེམས་ནང་ཅི་ཡོད་པ་མཁྱེན་པས་དེ་ཚོར་བློ་གཏད་མ་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","དེའི་ཚེ་ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་ནང་ནས་མི་ནཱི་ཀོ་དེམ་བྱ་བ་ཡ་ཧུ་དཱ་པའི་དབུ་ཁྲིད་པ་ཞིག་ཡོད་དེ། ");
INSERT INTO bod_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","མཚན་མོར་ཡེ་ཤུ་མཇལ་དུ་འོངས་ནས་“རབ་བི། ཁྱེད་ནི་དཀོན་མཆོག་གི་མདུན་ནས་ཕེབས་པའི་སྟོན་པ་ཞིག་ཡིན་པ་ང་ཚོས་ཤེས། ཅི་ལགས་ཟེར་ན། ཁྱེད་ཀྱིས་སྟོན་པར་མཛད་པའི་རྟགས་འདི་ཚོ་དཀོན་མཆོག་དང་འབྲལ་ཏེ་སུས་ཀྱང་སྟོན་པར་མི་སྲིད་”ཅེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱེད་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། གལ་ཏེ་མི་ཞིག་ཡང་བསྐྱར་མ་སྐྱེས་ན། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་མཐོང་བར་མི་སྲིད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ནཱི་ཀོ་དེམ་གྱིས་ཁོང་ལ་“མི་ཞིག་རྒས་ནས་ཡང་བསྐྱར་ཇི་ལྟར་སྐྱེ་སྲིད། ཁོའི་ཨ་མའི་མངལ་དུ་འཛུལ་ནས་ཐེངས་གཉིས་པར་སྐྱེ་སྲིད་དམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱེད་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། གལ་ཏེ་མི་ཞིག་ཆུ་དང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་བརྒྱུད་ནས་མ་སྐྱེས་ན། དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འཛུལ་བར་མི་སྲིད་དོ། ");
INSERT INTO bod_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ལུས་ནས་སྐྱེས་པ་ནི་ལུས་ཡིན་པ་ལྟར། དམ་པའི་ཐུགས་ཉིད་ལས་སྐྱེས་པ་དེ་ནི་སེམས་ཉིད་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ངས་ཁྱེད་རང་ལ་ཁྱེད་ཚོ་ཡང་བསྐྱར་སྐྱེ་དགོས་ཞེས་བཤད་པས་ཡ་མཚན་མ་སྐྱེད། ");
INSERT INTO bod_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ལྷགས་པ་ནི་རང་འདོད་པ་བཞིན་དུ་རྒྱག་པ་དང་དེའི་སྒྲ་ཁྱེད་ཀྱིས་ཐོས་ཀྱང༌། དེ་ག་ནས་བྱུང་དང་གང་དུ་འགྲོ་མི་ཤེས། དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ནས་སྐྱེས་པ་ཐམས་ཅད་ནི་དེ་བཞིན་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ཡང་ནཱི་ཀོ་དེམ་གྱིས་“དེ་ཇི་ལྟར་སྲིད་”ཅེས་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ལན་དུ་ཡེ་ཤུས་“ཁྱེད་ཡི་སི་ར་ཨེལ་གྱི་སློབ་དཔོན་ཡིན་ཞིང་དོན་དེ་ཡང་མི་རྟོགས་སམ། ");
INSERT INTO bod_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ངས་ཁྱེད་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ང་ཚོས་གང་ཤེས་པ་དེ་བཤད། གང་མཐོང་ཡོད་པ་དེའི་དཔང་པོ་བྱེད་ཀྱང༌། དཔང་པོ་དེ་ལ་ཁྱེད་རྣམས་ཀྱིས་དང་ལེན་མི་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ངས་ཁྱེད་རྣམས་ལ་ས་སྟེང་དུ་བྱུང་བའི་དོན་བཤད་ནས་ཁྱེད་རྣམས་ཡིད་མ་ཆེས་ན། དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་བྱུང་བའི་དོན་བཤད་ན་ཁྱེད་རྣམས་ཇི་ལྟར་ཡིད་ཆེས་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་པའི་མིའི་རིགས་ཀྱི་བུ་མ་གཏོགས་པར། སུའང་ཞིང་ཁམས་ལ་ཡར་ཕེབས་མ་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་འབྲོག་སྟོང་དུ་སྦྲུལ་གྱི་གཟུགས་བརྙན་ཡར་བཀྱགས་པ་ལྟར། མིའི་རིགས་ཀྱི་བུ་ཡང་འཕགས་པར་འགྱུར་དགོས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","མིའི་རིགས་ཀྱི་བུ་ལ་དད་པ་བྱེད་མཁན་ཐམས་ཅད་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་པར་འགྱུར་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","དཀོན་མཆོག་གིས་རང་གི་སྲས་གཅིག་པོ་གནང་བ་ཙམ་གྱིས་འཇིག་རྟེན་གྱི་མི་རྣམས་ལ་བྱམས་པར་མཛད་པས། སྲས་ལ་དད་པ་བྱེད་མཁན་ཚང་མར་འཇིག་པར་མི་འགྱུར་བར་དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་ངེས་པའོ། ");
INSERT INTO bod_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ཡང་དཀོན་མཆོག་གིས་རང་གི་སྲས་འཇིག་རྟེན་གྱི་མིར་ཁྲིམས་གཅོད་མཛད་རྒྱུར་མ་མངགས་ཀྱིས། འཇིག་རྟེན་གྱི་མི་ཁོང་བརྒྱུད་ནས་སྐྱབས་མཛད་རྒྱུར་མངགས། ");
INSERT INTO bod_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","སྲས་ལ་དད་པ་བྱེད་མཁན་ཚོ་ལ་ཁྲིམས་བཅད་མེད་དེ། སྲས་ལ་དད་པ་མི་བྱེད་མཁན་ཚོ་ལ་ཁྲིམས་བཅད་ཟིན། དེ་ནི་དཀོན་མཆོག་གི་སྲས་གཅིག་པོའི་མཚན་ལ་དད་པ་མ་བྱས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ཡང་ཁྲིམས་གཅོད་དེ་འདི་ལྟར་ཡིན། འོད་དེ་འཇིག་རྟེན་དུ་ཕེབས་ཡོད་ཀྱང༌། མི་རྣམས་ཀྱི་སྤྱོད་པ་ངན་པས་དེ་ཚོ་འོད་དེ་ལས་སྡིག་ཉེས་ཀྱི་མུན་ནག་ལ་དགའོ། ");
INSERT INTO bod_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ཅི་ལགས་ཟེར་ན། ལས་ངན་བྱེད་པ་ཐམས་ཅད་རང་གི་སྤྱོད་ངན་རྣམས་མི་མངོན་པའི་ཕྱིར་འོད་དེ་ལ་སྡང་ཞིང་འོད་ཀྱི་རྩར་མི་འོང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","འོན་ཀྱང་བདེན་པའི་དོན་ལག་ལེན་བྱེད་མཁན་རྣམས་ཀྱི་བྱ་བ་དཀོན་མཆོག་ལས་བྱུང་བ་གསལ་བར་མཐོང་བའི་ཕྱིར་མི་དེ་རྣམས་འོད་ལ་འོང་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","དེའི་རྗེས་སུ་ཡེ་ཤུ་དང་ཉེ་གནས་ཚོ་ཡ་ཧུ་དཱ་ཡུལ་དུ་ཕེབས་ནས། དེར་ཁོང་ཚོ་དང་མཉམ་དུ་བཞུགས་ཤིང་མི་ཚོར་ཁྲུས་གསོལ་གནང་བཞིན་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","དེའི་ཚེ་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་ཡང་ས་ལིམ་དང་ཐག་ཉེ་བའི་གནས་ཨེ་ནོན་ཞེས་པ་ལ་ཆུ་མང་པོ་ཡོད་པས་ཁྲུས་གསོལ་གནང་བཞིན་ཡོད། མི་རྣམས་དེར་ཕྱིན་ཏེ་ཁྲུས་གསོལ་ཐོབ་བཞིན་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(དེའི་དུས་སུ་ཡོ་ཧ་ནན་ནི་ད་དུང་བཙོན་དུ་བཅུག་མེད་) ");
INSERT INTO bod_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","དེའི་ཚེ་ཡོ་ཧ་ནན་གྱི་ཉེ་གནས་རྣམས་ཆོས་ཀྱི་གཙང་ཁྲུས་བྱེད་པའི་སྐོར་ལ་ཡ་ཧུ་དཱ་པ་ཞིག་དང་རྩོད་གླེང་ཞིག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","མི་དེ་ཚོ་ཡོ་ཧ་ནན་གྱི་དྲུང་དུ་ཡོང་ནས་“རབ་བི་གཟིགས་དང༌། ཁྱེད་ཀྱིས་དཔང་པོ་མཛད་པའི་མི་ཡོར་དན་གཙང་པོའི་ཕ་རོལ་ལ་ཁྱེད་དང་མཉམ་དུ་ཡོད་པ་དེས་ཁྲུས་གསོལ་གནང་བཞིན་ཡོད་དེ། མི་མང་པོ་ཁོང་གི་དྲུང་དུ་འགྲོ་བཞིན་ཡོད་”ཅེས་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ལན་དུ་ཡོ་ཧ་ནན་གྱིས་“དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་མ་གནང་ན་མི་ཞིག་ལ་ཅིའང་ཐོབ་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ངས་ང་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་མ་ཡིན་ཏེ། ཁོང་གི་སྔོན་དུ་བཏང་བ་དེ་ཡིན་ཞེས་བཤད་པ་ཡིན་པ་ལ་ཁྱེད་ཚོ་རང་ངའི་དཔང་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","སུ་ལ་བག་མ་ཡོད་པ་དེ་ནི་མག་པ་ཡིན། མག་པའི་གྲོགས་པོ་ལངས་ནས་བསྡད་ཅིང་མག་པའི་སྐད་ཐོས་པས་སེམས་ཤིན་ཏུ་དགའ། དེའི་ཕྱིར་ངའི་དགའ་བས་ཁེངས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ཁོང་ནི་འཕེལ་བར་དགོས་ཤིང་ང་ནི་འགྲིབ་པར་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བྱོན་པ་དེ་མི་ཐམས་ཅད་ལས་མཆོག་ཉིད། ས་གཞི་ལ་གཏོགས་པ་ནི་ས་ནས་ཡིན་ཞིང་སའི་དོན་གླེང་བ་བྱེད། དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བྱོན་པ་དེ་བླ་ན་མེད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ཁོང་གིས་གང་མཐོང་བ་དང་ཐོས་པ་དེ་ལ་དཔང་པོ་མཛད་མོད། མི་སུས་ཀྱང་དཔང་པོ་དེ་ཁས་མི་ལེན། ");
INSERT INTO bod_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ཁོང་གིས་དཔང་པོ་མཛད་པ་ལ་དང་ལེན་བྱེད་མཁན་གྱིས་དཀོན་མཆོག་བདེན་པ་ཡིན་པ་ར་སྤྲོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","དཀོན་མཆོག་གིས་དམ་པའི་ཐུགས་ཉིད་ཚད་མེད་དུ་གནང་བས། དཀོན་མཆོག་གིས་མངགས་པ་དེས་དཀོན་མཆོག་གི་བཀའ་གསུང༌། ");
INSERT INTO bod_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ཡབ་ཀྱིས་སྲས་ལ་བྱམས་པར་མཛད་པ་དང༌། ཡོད་དོ་ཅོག་ཁོང་གི་ཕྱག་ཏུ་གནང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","སྲས་ལ་དད་པ་བྱེད་མཁན་དེ་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཡོད། སྲས་ལ་དད་པ་མི་བྱེད་པ་དེས་དཔག་ཏུ་མེད་པའི་ཚེ་མི་མྱོང་བར། དཀོན་མཆོག་གི་ཉེས་ཆད་དེ་ལ་གནས་པར་འགྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","དེའི་ཚེ་ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་གིས་ཡེ་ཤུས་སློབ་མ་བསྡུས་ཤིང་ཁྲུས་གསོལ་ལེན་པ་རྣམས་ཡོ་ཧ་ནན་ལས་མང་བའི་གཏམ་ཐོས་པ་ཡེ་ཤུས་མཁྱེན་ནས། ");
INSERT INTO bod_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(དོན་དམ་དུ་ཡེ་ཤུ་རང་ཉིད་ཀྱིས་ཁྲུས་གསོལ་མ་གནང༌། ཁོང་གི་ཉེ་གནས་ཁོ་ནས་ཁྲུས་གསོལ་གནང་བ་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ཁོང་ཡ་ཧུ་དཱ་ཡུལ་དང་བྲལ་ནས་ག་ལིལ་ཡུལ་དུ་ཕྱིར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","དེའི་དུས་སུ་ཁོང་ས་མར་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཕེབས་དགོས་པས། ");
INSERT INTO bod_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ཁོང་ས་མར་ཡཱ་ཡུལ་གྱི་གྲོང་ཚོ་སི་གར་ལ་ཕེབས། གྲོང་དེ་སྔར་ཡ་ཧུ་དཱ་པའི་མེས་པོ་ཡ་ཀོབ་ཀྱིས་ཁོང་གི་བུ་ཡོ་སེབ་ལ་གནང་བའི་ཞིང་དང་ཐག་ཉེ་པོ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ཡ་ཀོབ་ཀྱི་ཁྲོན་པ་དེར་ཡོད་ཅིང༌། ཡེ་ཤུ་འགྲུལ་ནས་སྐུ་ཐང་ཆད་དེ་ཁྲོན་པའི་རྩར་བཞུགས་སྐབས་ཉིན་གུང་ཙམ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","ཉེ་གནས་རྣམས་གྲོང་ཚོ་ལ་ཟས་ཉོ་བར་སོང་བའི་རྗེས་སུ། ས་མར་ཡཱ་ཡུལ་གྱི་བུད་མེད་ཅིག་ཆུ་ལེན་དུ་ཡོང་བ་དང༌། ཡེ་ཤུས་ཁོ་མོར་“ང་ལ་འཐུང་ཆུ་ཏོག་ཙམ་སྟེར་དང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","བུད་མེད་དེས་ཁོང་ལ་“ཁྱེད་ཡ་ཧུ་དཱ་པ་རེད། ང་ས་མར་ཡཱ་མ་ལྟ་བུ་ལས་འཐུང་ཆུ་སློང་བ་དེ་ཅི་ལ་སྲིད་”ཅེས་བཤད། (གང་ལགས་ཟེར་ན། ཡ་ཧུ་དཱ་པའི་མི་རིགས་ས་མར་ཡཱ་ཡི་མི་རིགས་དང་མི་འགྲོགས་) ");
INSERT INTO bod_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ལན་དུ་ཡེ་ཤུས་ཁོ་མོར་“གལ་ཏེ་ཁྱོད་ཀྱིས་དཀོན་མཆོག་གི་གནང་སྦྱིན་དང༌། ཁྱོད་ལ་ཆུ་སྟེར་རོགས་ཟེར་མཁན་དེ་སུ་ཡིན་པ་ཤེས་ན། ཁྱོད་ཀྱིས་ཁོང་ལ་ཞུས་ནས་ཁོས་ཁྱོད་ལ་གསོན་པའི་ཆུ་སྟེར་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ལན་དུ་བུད་མེད་དེས་“སྐུ་ཞབས་ལགས། ཁྲོན་པ་འདི་གཏིང་རིང་པོ་ཡིན་ཞིང་ཁྱེད་ལ་ཆུ་འཆུ་བའི་སྣོད་ཀྱང་མི་འདུག་པས་གསོན་པའི་ཆུ་དེ་གང་ནས་ལེན། ");
INSERT INTO bod_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ང་ཚོའི་མེས་པོ་ཡ་ཀོབ་ཀྱིས་ང་ཚོ་ལ་ཁྲོན་པ་འདི་གནང་སྟེ། ཁོང་རང་དང་ཁོང་གི་བུ་རྣམས་དང་ཕྱུགས་དེ་ཚོས་དེ་ནས་བཏུངས་པས། ཁྱེད་ཁོང་ལས་ཆེ་བ་ཡིན་ནམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ལན་དུ་ཡེ་ཤུས་“སུས་ཀྱང་ཆུ་འདི་ལས་བཏུངས་ན་ཡང་བསྐྱར་སྐོམ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","འོན་ཏེ་སུས་ཀྱང་ངས་སྟེར་བའི་ཆུ་དེ་ལས་བཏུངས་ན་ནམ་ཡང་མི་སྐོམ་སྟེ། ངས་སྟེར་བའི་ཆུ་དེ་ཁོའི་ནང་ན་དཔག་ཏུ་མེད་པའི་ཚེ་ལ་ཆུ་འཕྱུར་བའི་ཆུ་མིག་ཅིག་ལྟ་བུ་ཡིན་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","བུད་མེད་དེས་“སྐུ་ཞབས་ལགས། ཆུ་དེ་ང་ལ་གནང་རོགས། དེས་ང་སྐོམ་པར་མི་འགྱུར་ཏེ་ཆུ་ལེན་དུ་འདི་རུ་ཡང་ཡང་ཡོང་མི་དགོས་”ཞེས་ཟེར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ཡེ་ཤུས་“སོང་ལ་ཁྱོད་ཀྱི་ཁྱོ་ག་བོས་ནས་འདིར་ཤོག་”ཅེས་གསུངས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","བུད་མེད་དེས་“ང་ལ་ཁྱོ་ག་མེད་”ཅེས་བཤད་པ་དང་ཡེ་ཤུས་“ཁྱོད་ཀྱིས་ང་ལ་ཁྱོ་ག་མེད་ཅེས་ཟེར་བ་དེ་བདེན་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","སྔོན་ཆད་ཁྱོད་ལ་ཁྱོ་ག་ལྔ་ཡོད་མྱོང༌། ད་ལྟ་ཡོད་པ་དེ་ནི་ཁྱོད་ཀྱི་ཁྱོ་ག་མ་ཡིན། ཁྱོད་ཀྱིས་གཏམ་བདེན་པར་བཤད་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","བུད་མེད་དེས་“སྐུ་ཞབས་ལགས། ངས་ཁྱེད་རང་ནི་ལུང་སྟོན་པ་ཞིག་ཡིན་པར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ང་ཚོའི་མེས་པོས་རི་བོ་འདིའི་སྟེང་དུ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱས་པ་ཡིན། འོན་ཀྱང་ཡ་ཧུ་དཱ་པ་ཁྱེད་ཚོས་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་དགོས་པའི་གནས་ནི་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ཡིན་ཟེར་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ཡེ་ཤུས་“ཨ་ཅག་ལགས། ང་ལ་ཡིད་ཆེས་བྱོས་དང༌། རི་བོ་འདི་དང་ཡེ་རུ་ཤ་ལེམ་དུ་ཁྱེད་ཚོས་ཡབ་ལ་བསྙེན་བཀུར་མི་ཞུ་བའི་དུས་ཤིག་ཡོང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ཁྱེད་ཚོས་གང་མི་ཤེས་པ་དེ་ལ་བསྙེན་བཀུར་བྱེད་ཅིང༌། ང་ཚོས་གང་ཤེས་པ་དེ་ལ་བསྙེན་བཀུར་བྱེད། ཅི་ལགས་ཤེ་ན། ཐར་པ་ནི་ཡ་ཧུ་དཱ་པ་རྣམས་ནས་འབྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","འོན་ཀྱང་བཅོས་མིན་གྱི་བསྙེན་བཀུར་བྱེད་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་དང་བདེན་པ་ཉིད་ཀྱི་སྒོ་ནས་ཡབ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུ་བའི་དུས་ཤིག་འོང་བར་འགྱུར་ལ། འོང་བཞིན་པ་ཡང་ཡིན། ཡབ་དཀོན་མཆོག་ནི་དེ་ལྟ་བུའི་མི་རྣམས་ལ་དགྱེས་ཤིང་གཟིགས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","དཀོན་མཆོག་ནི་ཐུགས་ཉིད་ཡིན་པས། ཁོང་ལ་བསྙེན་བཀུར་བྱེད་མཁན་རྣམས་ཀྱིས་དམ་པའི་ཐུགས་ཉིད་དང་བདེན་པ་ཉིད་ཀྱི་སྒོ་ནས་བསྙེན་བཀུར་བྱེད་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","བུད་མེད་དེས་ཁོང་ལ་“སྐྱབས་མགོན་མཱ་ཤི་ཀ་(ཁོང་ནི་ཁི་རིའི་སི་ཐོ་ཡང་ཟེར་) ཕེབས་ཡོད་པར་ངས་ཤེས། ཁོང་ཕེབས་སྐབས་ང་ཚོར་དོན་ཐམས་ཅད་སྒྲོག་པར་འགྱུར་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ཡེ་ཤུས་ཁོ་མོར་“ང་ནི་ཁྱེད་དང་གླེང་མོལ་བྱེད་མཁན་སྐྱབས་མགོན་མཱ་ཤི་ཀ་དེ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","དེའི་ཚེ་ཉེ་གནས་ཚོ་ལོག་ཡོང་ནས། ཡེ་ཤུས་བུད་མེད་ཅིག་དང་གཏམ་བྱེད་ཀྱི་ཡོད་པ་མཐོང་ནས་ཡ་མཚན་སྐྱེས་མོད། སུས་ཀྱང་ཁྱེད་རང་ཅི་དགོངས་སམ། བུད་མེད་འདི་དང་ཅི་ལ་གསུང་གླེང་མཛད་ཅེས་བཀའ་འདྲི་མ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","བུད་མེད་དེས་རང་གི་ཆུ་སྣོད་དེར་བཞག་སྟེ། གྲོང་ཁྱེར་དུ་སོང་ནས་མི་ཚོ་ལ་ ");
INSERT INTO bod_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ཤོག་ལ་ལྟོས་དང༌། འདི་ལ་མི་ཞིག་ཡོད་དེ་ངས་བྱས་པའི་ལས་ཀ་ཐམས་ཅད་ང་ལ་གསུངས་བྱུང་བས། སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་སྲིད་དམ་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","མི་དེ་ཚོ་གྲོང་ཁྱེར་གྱི་ཕྱི་རོལ་ཏུ་སོང་ནས་ཡེ་ཤུའི་དྲུང་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","དེའི་དུས་སུ་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་“རབ་བི། ཞལ་ཟས་བཞེས་”ཞེས་ཞུས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ཁོང་གིས་ཁོ་ཚོར་“ཁྱེད་ཚོ་ལ་རྒྱུས་མེད་པའི་ཟས་ཤིག་ང་ལ་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","དེའི་ཕྱིར་ཉེ་གནས་རྣམས་ཀྱིས་གཅིག་གིས་གཅིག་ལ་“མི་ཞིག་གིས་ཁོང་ལ་ཟས་ཤིག་བསྐྱལ་ལམ་”ཞེས་འདྲི་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ཡེ་ཤུས་ཁོ་ཚོར་“ང་མངགས་མཁན་དཀོན་མཆོག་གི་ཐུགས་དགོངས་བཞིན་དུ་བྱེད་པ་དང་ཁོང་གི་འཕྲིན་ལས་སྒྲུབ་པ་ནི་ངའི་ཟས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ཁྱེད་ཚོའི་གཏམ་དཔེ་ལྟར་ད་དུང་ཟླ་བ་བཞི་ཡོད་དེ་དེ་ནས་ཞིང་རྔ་རན་ཡོང་བཤད་པ་མ་ཡིན་ནམ། འོན་ཀྱང་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། ཞིང་ལ་ལྟོས་དང༌། ད་ལྟ་ལོ་ཏོག་གསེར་གྱི་མདོག་ཏུ་གྱུར་བས་རྔ་རན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","རྔ་མཁན་ལ་གླ་ཐོབ་ཅིང་དཔག་ཏུ་མེད་པའི་ཚེའི་ཕྱིར་འབྲས་བུ་སྡུད་བཞིན་ཡོད། དེར་བརྟེན་ས་བོན་འདེབས་མཁན་དང་ཞིང་རྔ་མཁན་གཉིས་ཀ་མཉམ་དུ་དགའ་བར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","གཅིག་གིས་འདེབས། གཅིག་གིས་རྔ་ཞེས་པའི་གཏམ་དཔེ་དེ་བཞིན་བདེན་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ཁྱེད་ཚོས་ལས་མ་བྱས་པའི་ཞིང་ལ་ངས་ཁྱེད་རྣམས་རྔ་བའི་ཕྱིར་བཏང༌། གཞན་རྣམས་ཀྱིས་དེར་ལས་ཀ་བྱས་ནས། ཁྱེད་ཚོར་ནི་ལས་དེའི་ཁེ་བཟང་ཐོབ་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","བུད་མེད་དེས་ཁོང་གིས་ངས་བྱས་པའི་ལས་ཐམས་ཅད་ང་ལ་གསུངས་པ་ཡིན་ཞེས་དཔང་པོ་བྱས་པས་གྲོང་ཁྱེར་དེའི་ས་མར་ཡཱ་པ་མང་པོས་ཡེ་ཤུ་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","དེའི་ཕྱིར་ས་མར་ཡཱ་པ་རྣམས་ཁོང་གི་དྲུང་དུ་ཡོང་སྐབས་ཁོ་ཚོ་དང་མཉམ་དུ་བཞུགས་སུ་གསོལ་ཞེས་ཞུས་པས་ཁོང་ཉིན་གཉིས་དེར་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ཁོང་གིས་བཀའ་གསུངས་པས་མི་སྔར་ལས་ཇེ་མང་བས་དད་པ་སྐྱེས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","མི་དེ་ཚོས་བུད་མེད་དེར་“ད་ང་ཚོས་ཁྱོད་ཀྱི་གཏམ་ཁོ་ན་ཐོས་པས་དད་པ་མི་བྱེད་དེ། ང་ཚོ་རང་གིས་ཐོས་པའི་རྐྱེན་གྱིས་ཁོང་ནི་དངོས་གནས་འཇིག་རྟེན་གྱི་སྐྱབས་མགོན་ཡིན་པར་ཤེས་སོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ཉིན་གཉིས་དེའི་རྗེས་སུ་ཁོང་ཡུལ་དེ་ནས་ག་ལིལ་ཡུལ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ཅི་ལགས་ཟེར་ན། ཡེ་ཤུ་ཉིད་ཀྱིས་ཕ་ཡུལ་ན་ལུང་སྟོན་པ་ལ་བཀུར་སྟི་མེད་དོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ག་ལིལ་པ་ཚོ་པེ་སག་གི་དུས་ཆེན་སྐབས་སུ་ཡེ་རུ་ཤ་ལེམ་ལ་སོང་ནས་ཁོང་གིས་མཛད་པའི་ངོ་མཚར་བའི་དོན་ཐམས་ཅད་མཐོང་བས། ཡེ་ཤུ་ག་ལིལ་ཡུལ་དུ་བྱོན་སྐབས་ཁོ་ཚོས་ཁོང་ལ་དགའ་བསུ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ཡེ་ཤུ་ཡང་བསྐྱར་ག་ལིལ་ཡུལ་གྱི་ཀ་ནཱ་ཟེར་བའི་གྲོང་ཚོར་ཕེབས། སྔར་ཁོང་གིས་གནས་དེར་ཆུ་རྒུན་ཆང་དུ་འགྱུར་བར་མཛད། ག་ལིལ་ཡུལ་དུ་རྒྱལ་པོའི་དཔོན་རིགས་ཤིག་གི་བུ་ཀ་ཕར་ན་ཧུམ་གྲོང་ཁྱེར་དུ་ན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","དཔོན་རིགས་དེས་ཡེ་ཤུ་ནི་ཡ་ཧུ་དཱ་ཡུལ་ནས་ག་ལིལ་དུ་ཕེབས་པའི་གཏམ་ཐོས་པས་ཁོང་གི་དྲུང་དུ་ཕྱིན། ཁོའི་བུ་འཆི་བ་ལ་ཐུག་པས་ཡེ་ཤུ་ཀ་ཕར་ན་ཧུམ་དུ་མར་ཕེབས་ནས་བུའི་ནད་གསོ་བར་མཛད་པའི་ཕྱིར་ཞུ་བ་ཕུལ། ");
INSERT INTO bod_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ཡེ་ཤུས་མི་དེར་“གལ་ཏེ་ཁྱེད་རྣམས་ཀྱིས་རྟགས་དང་ངོ་མཚར་བའི་དོན་རྣམས་མ་མཐོང་ན་དད་པ་མི་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ལན་དུ་རྒྱལ་པོའི་དཔོན་རིགས་དེས་“སྐུ་ཞབས་ལགས། ངའི་བུ་མ་འཆི་གོང་ལ་ཕེབས་རོགས་གནང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ཡེ་ཤུས་“སོང་ལ་ཁྱེད་ཀྱི་བུ་གསོན་ནོ་”ཞེས་གསུངས། དཔོན་པོ་དེས་ཡེ་ཤུས་གསུངས་པའི་བཀའ་ལ་ཡིད་ཆེས་ཏེ་ཕྱིར་ལོག་སོང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ཁོང་ཕྱིར་ལོག་དུས་དེའི་གཡོག་པོ་རྣམས་ཚུར་ཡོང་བ་དང་ཁོང་ཐུག་ནས་བུ་གསོན་པའི་གཏམ་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","དེ་ནས་ཁོང་གིས་ནད་གསོ་བའི་ཆུ་ཚོད་དྲིས་པ་ན་ཁོ་ཚོས་“ཁ་སང་ཕྱི་དྲོའི་ཆུ་ཚོད་དང་པོར་ཙམ་ལ་ཚ་བ་འཇགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","དེ་ནས་ཡེ་ཤུས་ཁྱེད་ཀྱི་བུ་གསོན་ནོ་ཞེས་གསུངས་པའི་ཆུ་ཚོད་དེ་རང་ལ་བུ་གསོས་པར་གྱུར་བ་ཕ་ཡིས་ཤེས་ཏེ། ཕ་རང་ཉིད་དང་ཁྱིམ་མི་ཐམས་ཅད་ཀྱིས་ཡེ་ཤུ་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","འདི་ནི་ཡེ་ཤུ་ཡ་ཧུ་དཱ་ཡུལ་ནས་ག་ལིལ་དུ་ཕེབས་ནས་བསྟན་པའི་ངོ་མཚར་བའི་རྟགས་གཉིས་པ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","དེའི་རྗེས་སུ་ཡ་ཧུ་དཱ་པའི་དུས་ཆེན་ཞིག་ཡོད་པ་དང༌། ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ལ་ཡར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ཡེ་རུ་ཤ་ལེམ་གྱི་ལུག་སྒོའི་རྩར་རྫིང་བུ་ཞིག་ཡོད་པ་ཡ་ཧུ་དཱ་པའི་སྐད་དུ་པེ་ཐེས་དཱ་ཞེས་བྱ་བ་གཡབ་ལྔ་ཡོད་པ་ཞིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","དེ་ཚོའི་ནང་ལ་ནད་པ་དང༌། ལོང་བ་དང༌། ཞ་བོ་དང༌། ཡན་ལག་བསྐམས་པ་སོགས་མང་པོ་ཉལ་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","མི་ཞིག་ཞ་བོ་ཆགས་ནས་ལོ་སུམ་ཅུ་སོ་བརྒྱད་སོང་བ་ཞིག་དེར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ཡེ་ཤུས་ཞ་བོ་དེ་ཉལ་ཡོད་པ་གཟིགས་ཏེ་ཡུན་རིང་པོ་དེ་ལྟར་གནས་པ་མཁྱེན་ནས་མི་དེར་“ཁྱེད་དྲག་པར་འགྱུར་འདོད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ཞ་བོ་དེས་ཁོང་ལ་“སྐུ་ཞབས་ལགས། ཆུ་སྐྱོམ་སྐབས་ང་རྫིང་བུར་འཇུག་པའི་མི་ང་ལ་མེད་པས། ང་ཡོང་དུས་ངའི་སྔོན་ལ་གཞན་ཞིག་ཆུའི་ནང་དུ་འཛུལ་ཟིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ཡེ་ཤུས་“ཡར་ལོངས་ལ་ཉལ་ཁྲི་ཁུར་ཏེ་གོམ་པར་རྒྱོབ་དང་”ཞེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","མི་དེ་དྲག་པར་གྱུར་ནས། རང་གི་ཉལ་ཁྲི་ཁུར་ཏེ་ཕྱིར་སོང༌། ཉིན་དེ་ནི་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན་པས། ");
INSERT INTO bod_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཚོས་ནད་གསོས་པར་གྱུར་བའི་མི་དེར་“དེ་རིང་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན་པས་ཁྲིམས་ལྟར་ཁྱོད་ཀྱིས་ཉལ་ཁྲི་འཁུར་མི་ཆོག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","མི་དེས་“ངའི་ནད་སེལ་མཁན་དེས་ང་ལ་ཉལ་ཁྲི་ཁུར་ཏེ་སོང་དང་ཞེས་གསུངས་པ་ཡིན་”ཞེས་བཤད་པས། ");
INSERT INTO bod_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ཁོ་ཚོས་“ཉལ་ཁྲི་ཁུར་ཏེ་སོང་དང་ཞེས་ཟེར་བའི་མི་སུ་ཡིན་”ཞེས་དྲིས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ནད་ལས་ཐར་བའི་མི་དེས་ཁོང་སུ་ཡིན་པ་ངོ་མ་ཤེས། གནས་དེར་མི་ཚོགས་མང་བས་ཡེ་ཤུ་ཕེབས་ཟིན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","དེའི་རྗེས་སུ་ཡེ་ཤུས་མཆོད་ཁང་ཆེན་མོའི་ནང་ལ་མི་དེ་གཟིགས་ནས་ཁོ་ལ་“ལྟོས་དང༌། ཁྱེད་རང་དྲག་པར་གྱུར་བས། ད་ནས་བཟུང་སྡིག་ཉེས་མ་བྱོས་ཤིག གལ་ཏེ་བྱས་ན་ཁྱེད་ལ་སྡུག་བསྔལ་དེ་ལས་ཆེ་བ་ཞིག་འཕོག་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","མི་དེ་ཕར་ཕྱིན་ནས་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཚོར་རང་གི་ནད་སེལ་མཁན་དེ་ནི་ཡེ་ཤུ་རེད་ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ཡེ་ཤུས་ངལ་གསོ་བའི་ཉིན་མོར་དེ་ལྟར་མཛད་པས་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཚོས་ཁོང་ལ་གནོད་སྐྱེལ་བར་འགོ་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","འོན་ཀྱང་ཡེ་ཤུས་ཁོ་ཚོར་“ངའི་ཡབ་ཀྱིས་ད་ལྟའི་བར་དུ་ཡང་འཕྲིན་ལས་མཛད་དེ། ངས་ཀྱང་འཕྲིན་ལས་སྒྲུབ་བཞིན་ཡོད་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཀྱིས་དེ་བས་ཀྱང་ཁོང་གསོད་ཐབས་བཙལ། ཅི་ལགས་ཟེར་ན། ཡེ་ཤུས་ངལ་གསོ་བའི་ཉིན་མོའི་ཁྲིམས་ལས་འགལ་བ་མ་ཟད། དཀོན་མཆོག་ང་རང་གི་ཡབ་ཡིན་ཞེས་ཟེར་བས་ཁོང་རང་དཀོན་མཆོག་དང་གཅིག་ནང་བཞིན་མཛད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ཡང་ཡེ་ཤུས་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། སྲས་ཀྱིས་ཡབ་ལ་མ་བརྟེན་པར་ཅིའང་བྱེད་ཐུབ་མི་སྲིད། ཡབ་ཀྱིས་གང་མཛད་པ་བཞིན་དུ་སྲས་ཀྱིས་ཀྱང་མཛད། ཡབ་ཀྱིས་ཅི་མཛད་པ་དེ་མ་གཟིགས་པར་སྲས་ཀྱིས་ཅིའང་བྱེད་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","གང་ལགས་ཟེར་ན། ཡབ་ཀྱིས་སྲས་ལ་བྱམས་པས་ཁོང་རང་གིས་གང་མཛད་པ་ཐམས་ཅད་སྲས་ལ་སྟོན་པ་མ་ཟད། དེ་ལས་ཀྱང་ངོ་མཚར་ཆེ་བའི་འཕྲིན་ལས་ཁོང་ལ་སྟོན་པར་མཛད་དེ་ཁྱེད་ཚོ་ཡ་མཚན་སྐྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ཡབ་ཀྱིས་ཇི་ལྟར་གཤིན་པོ་རྣམས་སློང་ཞིང་དེ་ཚོར་དཔག་ཏུ་མེད་པའི་ཚེ་གནང་བ་བཞིན། དེ་ལྟར་སྲས་ཀྱིས་ཀྱང་སུ་ལ་དགྱེས་པ་དེར་དཔག་ཏུ་མེད་པའི་ཚེ་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ཡབ་ཉིད་ཀྱིས་སུ་ལའང་ཁྲིམས་གཅོད་མི་མཛད། དེ་ཡོངས་སུ་སྲས་ལ་གནང་བ་ཡིན་པས། ");
INSERT INTO bod_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","མི་ཐམས་ཅད་ཡབ་ལ་བཀུར་སྟི་ཞུ་བ་ལྟར། སྲས་ལ་ཡང་ཐམས་ཅད་ཀྱིས་བཀུར་སྟི་ཞུ་བར་འགྱུར། སྲས་ལ་བཀུར་སྟི་མི་ཞུ་མཁན་དེས་སྲས་མངགས་མཁན་ཡབ་ལའང་བཀུར་སྟི་མི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ངས་ཁྱེད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ངའི་བཀའ་ལ་ཉན་ཅིང་ང་མངགས་མཁན་ཡབ་དཀོན་མཆོག་ལ་དད་པ་བྱེད་མཁན་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཡོད་པ་དང༌། མི་དེ་རྣམས་ཁྲིམས་གཅོད་མི་མྱོང་བར་འཆི་བ་ནས་གསོན་པོར་གྱུར་ཡོད་དོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ཡང་ཡེ་ཤུས་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཚེ་མེད་པ་ནང་བཞིན་གྱི་མི་རྣམས་ཀྱིས་དཀོན་མཆོག་གི་སྲས་ཀྱི་གསུང་སྐད་ཐོས་པའི་དུས་ལ་འབབ་པར་འགྱུར་བ་མ་ཟད། དུས་དེ་ད་ལྟ་ཡིན། ཡང་སྐད་དེ་ཐོས་པ་རྣམས་གསོན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ཡབ་ཉིད་ཚེ་དཔག་ཏུ་མེད་པའི་འབྱུང་ཁུངས་ཡིན་པ་ལྟར། དེ་བཞིན་ཁོང་གིས་སྲས་ལའང་མི་རྣམས་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་གནང་རྒྱུའི་དབང་ཆ་བྱིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ཡང་ཁོང་མིའི་རིགས་ཀྱི་བུ་ཡིན་པས། ཡབ་ཀྱིས་སྲས་ལ་ལེགས་ཉེས་ཀྱི་ཁྲིམས་གཅོད་བྱེད་པའི་དབང་ཆ་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","དུར་ཁང་ལ་ཡོད་པ་ཐམས་ཅད་སྲས་ཀྱི་གསུང་སྐད་ཐོས་ནས་འཐོན་པའི་དུས་ལ་འབབ་ཡོང་བ་ལ་ཁྱེད་ཚོ་ཡ་མཚན་མ་སྐྱེད། ");
INSERT INTO bod_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ལས་བཟང་པོ་བྱས་པ་ཚོར་དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་པའི་ཕྱིར་སླར་གསོན་པར་འགྱུར་བ་དང༌། ལས་ངན་བྱས་པ་ཚོ་ཁྲིམས་གཅད་མྱོང་བའི་ཕྱིར་སླར་གསོན་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ཡེ་ཤུས་“ཡབ་ལ་མ་བརྟེན་པར་ངས་ཅིའང་བྱེད་མི་སྲིད་དེ། ཡབ་ཀྱི་བཀའ་ཇི་ལྟར་ཐོས་པ་བཞིན་དུ་ཁྲིམས་གཅོད་བྱེད། དེའི་ཕྱིར་ངའི་ཁྲིམས་ཆད་དེ་དྲང་པོ་ཡིན། གང་ལགས་ཟེར་ན། ངས་རང་གི་བསམ་ཚུལ་བཞིན་དུ་མི་བྱེད་དེ། ང་མངགས་མཁན་གྱི་དགོངས་པ་བཞིན་དུ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","གལ་ཏེ་ངས་རང་གིས་རང་ལ་དཔང་པོ་བྱས་ན། ངའི་དཔང་པོ་དེ་བདེན་པ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","འོན་ཀྱང་ང་ལ་དཔང་པོ་བྱེད་མཁན་གཞན་ཞིག་ཡོད། ཡང་ཁོང་གིས་ང་ལ་དཔང་པོ་མཛད་པ་ངས་དེ་བདེན་པ་ཡིན་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ཁྱེད་རྣམས་ཀྱིས་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱི་དྲུང་དུ་བང་ཆེན་བཏང་བ་དང༌། ཡོ་ཧ་ནན་གྱིས་བདེན་པ་ལ་དཔང་པོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","འོན་ཀྱང་ངས་ནི་མི་ཡིས་དཔང་པོ་བྱེད་པ་ལ་མི་རྟེན། ཁྱེད་ཚོར་ཐར་པ་ཐོབ་པའི་ཕྱིར་ངས་དོན་འདི་ཚོ་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ཡོ་ཧ་ནན་ནི་མར་མེ་འབར་ཞིང་འོད་འཕྲོ་བ་ལྟ་བུ་ཞིག་ཡོད་པ་ཡིན་ཏེ། ཁྱེད་ཚོ་ནི་འོད་དེའི་ནང་རེ་ཞིག་དགའ་ཞིང་མོས། ");
INSERT INTO bod_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","འོན་ཀྱང་ང་ཡོ་ཧ་ནན་གྱི་དཔང་པོ་ལས་ཆེ་བར་རྟེན། ཡབ་ཀྱིས་ང་ལ་འཕྲིན་ལས་སྒྲུབ་ཏུ་གནང་བ་དང་ངས་བྱེད་བཞིན་པའི་འཕྲིན་ལས་དེ་ཉིད་ཀྱིས་ང་མངགས་མཁན་ཡབ་དཀོན་མཆོག་ཡིན་པར་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ཡང་ང་མངགས་མཁན་ཡབ་དཀོན་མཆོག་ཉིད་ཀྱིས་ཀྱང་ང་ལ་དཔང་པོ་མཛད། ཁྱོད་ཚོས་ཁོང་གི་གསུང་སྐད་ཀྱང་གཏན་ནས་མ་ཐོས། ཁོང་གི་སྐུ་དབྱིབས་ཀྱང་གཏན་ནས་མ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ཁྱོད་ཚོས་ཁོང་གིས་མངགས་པ་དེ་ལ་ཡིད་མ་ཆེས་པས། ཁོང་གི་བཀའ་ཁྱོད་ཀྱི་སེམས་སུ་མི་གནས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ཡེ་ཤུས་“ཁྱོད་ཚོས་གསུང་རབ་ནང་ལ་དཔག་ཏུ་མེད་པའི་ཚེའི་ལམ་ཡོད་བསམས་ནས་དེ་འཚོལ་ཞིབ་བྱེད། དེ་ཉིད་ཀྱིས་ང་ལ་དཔང་པོ་བྱེད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ཁྱོད་ཚོ་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་པའི་ཕྱིར་ངའི་སར་ཡོང་བ་མི་མོས། ");
INSERT INTO bod_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ངས་མིའི་བཀུར་སྟི་མི་འཚོལ། ");
INSERT INTO bod_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","འོན་ཀྱང་ངས་ཁྱོད་ཚོ་རྟོགས་པ་དང༌། ཁྱོད་ཀྱིས་དཀོན་མཆོག་ལ་མི་བརྩེ་བ་དེ་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ང་ནི་ཡབ་ཀྱི་མཚན་ཐོག་ནས་ཡོང་བ་ཡིན་ཏེ་ཁྱོད་ཚོས་ང་རང་དང་ལེན་མི་བྱེད། གཞན་ཞིག་རང་གི་མིང་ཐོག་ནས་ཡོང་ན་ཁྱོད་ཀྱིས་མི་དེ་དང་ལེན་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ཁྱོད་ཚོ་གཅིག་གིས་གཅིག་ལ་བསྟོད་ར་བྱེད་པ་ལ་དགའ་སྟེ། དཀོན་མཆོག་གཅིག་པོ་དང་ཁོ་ན་ཡིན་པ་ལས་འབྱུང་བའི་བསྟོད་ར་མ་བཙལ་ན། ཁྱོད་ཚོས་ཡིད་ཆེས་ཇི་ལྟར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ངས་ཡབ་ཀྱི་དྲུང་དུ་ཁྱོད་ཚོ་ལ་སྐྱོན་འཛུགས་བྱེད་པར་འགྱུར་རོ་ཞེས་མ་སོམས་ཤིག ཁྱོད་ཚོར་སྐྱོན་འཛུགས་བྱེད་མཁན་ནི་ཁྱོད་ཚོས་རེ་ལྟོས་བྱས་སའི་ལུང་སྟོན་པ་མོ་ཤེ་རང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","གལ་ཏེ་ཁྱོད་ཚོ་མོ་ཤེ་ལ་ཡིད་ཆེས་བྱས་པ་ཡིན་ན། ང་ལའང་ཡིད་ཆེས་བྱེད་པར་འགྱུར། ཅི་ལགས་ཟེར་ན། ཁོང་གིས་ངའི་སྐོར་བྲིས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","འོན་ཀྱང་ཁོང་གིས་གང་བྲིས་པར་ཡིད་ཆེས་མ་བྱས་ན། ངས་བཤད་པའི་གཏམ་ལ་ཡིད་ཆེས་བྱེད་པ་ཅི་ལ་སྲིད་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","དེའི་རྗེས་སུ་ཡེ་ཤུ་ག་ལིལ་མཚོའི་ཕར་ཕྱོགས་སུ་ཕེབས། (ག་ལིལ་མཚོ་ནི་ཏི་པེར་ཡཱ་མཚོ་ཡང་ཟེར་) ");
INSERT INTO bod_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","མི་ཚོགས་མང་པོས་ཁོང་གིས་ནད་པ་ཚོ་ལ་མཛད་པའི་ངོ་མཚར་བའི་དོན་མཐོང་བས་ཁོང་གི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ཡེ་ཤུ་རི་ཞིག་ལ་ཕེབས་ནས་རང་གི་ཉེ་གནས་དང་མཉམ་དུ་དེར་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","དེའི་ཚེ་པེ་སག་ཟེར་བའི་ཡ་ཧུ་དཱ་པའི་དུས་ཆེན་སླེབས་པར་ཉེ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ཡེ་ཤུས་མི་ཚོགས་མང་པོ་ཁོང་གི་དྲུང་དུ་ཡོང་བཞིན་པ་གཟིགས་ནས་ཁོང་གིས་ཉེ་གནས་ཕི་ལིབ་ལ་“ང་ཚོས་མི་འདི་ཚོས་ཟ་རྒྱུའི་བག་ལེབ་ག་ནས་ཉོ་བར་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ཁོང་གིས་ཅི་ལྟར་མཛད་རྒྱུ་ཡིན་པ་མཁྱེན་ནས། ཕི་ལིབ་ལ་ཉམས་ཚོད་ལེན་པའི་ཕྱིར་དེ་ལྟར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ལན་དུ་ཕི་ལིབ་ཀྱིས་ཁོང་ལ་“དེ་ཎ་རིའི་དངུལ་སྒོར་ཉིས་བརྒྱའི་བག་ལེབ་མི་རེ་རེ་ལ་ཅུང་ཟད་ཅིག་ཐོབ་ཀྱང་མི་འདང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱི་ནང་ནས་གཞན་གཅིག་སི་མོན་པེ་ཏྲོ་ཡི་སྤུན་ཨན་དྲི་ཡཱས་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“འདིར་ཡོད་པའི་བུ་ཞིག་ལ་ནས་ཕྱེའི་བག་ལེབ་ལྔ་དང་ཉ་ཤ་གཉིས་ཡོད་ཀྱང༌། མི་འདི་ཙམ་མང་པོ་ལ་ཅི་ཕན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ཡེ་ཤུས་“མི་དེ་ཚོ་སྡོད་དུ་ཆུག་དང་”ཞེས་གསུངས། ས་ཆ་དེར་རྩྭ་མང་པོ་ཡོད་དེ་མི་ཚོ་དེར་བསྡད། མི་ཚོགས་དེར་སྐྱེས་པ་ལྔ་སྟོང་ཙམ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","དེ་ནས་ཡེ་ཤུས་བག་ལེབ་ཕྱག་ཏུ་བསྣམས་ནས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་པའི་རྗེས་ལ་ས་ལ་བསྡད་ཡོད་པའི་མི་རྣམས་ལ་བག་ལེབ་དེ་བགོད་དུ་བཅུག ཉ་ཤ་དེ་ཚོ་ལས་ཀྱང་ཁོ་ཚོས་འདོད་པ་ཙམ་ལ་བགོད་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","མི་ཚང་མས་བཟས་ནས་འགྲངས་པར་གྱུར་ཏེ་ཡེ་ཤུས་ཁོང་གིས་ཉེ་གནས་རྣམས་ལ་“ད་ཅིའང་ཆུད་ཟོས་མི་འགྲོ་བའི་ཕྱིར་ཟས་ལྷག་སྡུས་དང་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ཁོ་ཚོས་བསྡུས་ཏེ་མི་ཚོས་བཟས་པའི་ནས་ཕྱེའི་བག་ལེབ་ལྔ་པོ་ལས་ལུས་པའི་ཆག་དུམ་གྱིས་སླེ་པོ་བཅུ་གཉིས་བཀང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","མི་ཚོགས་ཀྱིས་ཡེ་ཤུས་མཛད་པའི་ངོ་མཚར་བའི་རྟགས་དེ་མཐོང་བས་“འདི་ནི་དངོས་གནས་འཇིག་རྟེན་ལ་ཕེབས་རྒྱུ་ཡོད་པའི་ལུང་སྟོན་པ་དེ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ཡེ་ཤུས་ཁོ་ཚོས་ཁོང་རང་བཟུང་ནས་བཙན་ཡོད་ཀྱིས་རྒྱལ་པོར་བསྐོ་རྩིས་ཡོད་པ་མཁྱེན་ནས་གཅིག་པུར་རི་ལ་སླར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","དགོང་དྲོ་སླེབས་དུས་ཡེ་ཤུའི་ཉེ་གནས་རྣམས་མཚོའི་འགྲམ་ལ་མར་སོང་དུས། ");
INSERT INTO bod_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","གྲུ་ཞིག་ལ་ཞུགས་ནས་མཚོའི་ཕར་ཕྱོགས་སུ་ཀ་ཕར་ན་ཧུམ་དུ་འགྲོ་བར་བརྩམས། མུན་རུབ་ཀྱང་ཡེ་ཤུ་ཁོ་ཚོའི་རྩར་ད་དུང་མ་བྱོན། ");
INSERT INTO bod_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","རླུང་ཆེན་པོ་ཞིག་ལངས་བས་མཚོའི་རྦ་རླབས་དྲག་ཏུ་འཕྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ཉེ་གནས་ཚོས་སྐྱ་བ་བརྒྱབ་ནས་གྲུ་དེ་སྤྱི་ལེ་ལྔ་དྲུག་ཙམ་སླེབས་སྐབས་ཁོ་ཚོས་ཡེ་ཤུ་མཚོའི་སྟེང་ལ་ཞབས་བཅགས་ཏེ་གྲུ་དང་ཉེ་བར་ཕེབས་པ་མཐོང་བས་ཁོ་ཚོ་ཤིན་ཏུ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","འོན་ཀྱང་ཡེ་ཤུས་“ང་རང་ཡིན་པས་མ་ཞེད་ཅིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ཁོ་ཚོ་འགྲུའི་ནང་དུ་ཁོང་བསུས་འདོད་དེ། དེ་མ་ཐག་ཏུ་གང་དུ་འགྲོ་བའི་གནས་སུ་གྲུ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","དེའི་ཕྱི་ཉིན་ག་ལིལ་མཚོའི་ཕ་རོལ་ཏུ་བསྡད་ཡོད་པའི་མི་ཚོགས་ཀྱིས་གྲུ་གཅིག་མ་གཏོགས་པར་གཞན་མེད་པ་དང༌། གྲུ་དེ་ལ་ཡེ་ཤུ་མ་ཕེབས་པར་ཉེ་གནས་ཚོ་གཅིག་པོར་སོང་ཟིན་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ཏི་པེར་ཡཱ་ཞེས་པའི་གྲོང་ཁྱེར་ནས་གྲུ་གཞན་དག་རྣམས་ཡེ་ཤུས་བཀའ་དྲིན་ཆེ་ཞུས་ནས་ཁོ་ཚོས་བག་ལེབ་བཟས་སའི་གནས་དང་ཉེ་བར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","མི་ཚོགས་ཀྱིས་ཡེ་ཤུ་ཡང་མ་མཐོང༌། ཉེ་གནས་རྣམས་ཀྱང་མ་མཐོང་བས། གྲུ་དེ་ཚོར་ཞོན་པ་དང༌། ཡེ་ཤུ་འཚོལ་བའི་ཕྱིར་ཀ་ཕར་ན་ཧུམ་ལ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","མཚོའི་ཕར་ཕྱོགས་སུ་ཁོང་མཇལ་སྐབས་ཁོ་ཚོས་“རབ་བི། ཁྱེད་འདིར་ནམ་ཕེབས་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ལན་དུ་ཡེ་ཤུས་“ངས་ཁྱོད་ཚོར་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱོད་རྣམས་ང་འཚོལ་དོན་ནི་རྟགས་རྣམས་མཐོང་བས་མ་ཡིན་པར་བག་ལེབ་བཟས་ནས་འགྲངས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ཟས་མི་རྟག་པ་དེ་ལ་འབད་རྩོལ་མ་བྱེད་ཀྱིས། དཔག་ཏུ་མེད་པའི་ཚེ་གནང་བའི་ཟས་དེ་ལ་འབད་རྩོལ་གྱིས་ཤིག ང་མིའི་རིགས་ཀྱི་བུ་ཡིས་ཁྱེད་ཚོ་ལ་ཟས་དེ་སྟེར་བར་བྱ། གང་ཡིན་ཟེར་ན། ཡབ་དཀོན་མཆོག་གིས་མིའི་རིགས་ཀྱི་བུ་ལ་ཁོང་གི་ཕྱག་ཐེལ་བསྐྱོན་ཡོད་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ཁོ་ཚོས་ཁོང་ལ་“དཀོན་མཆོག་གིས་ང་ཚོར་སྒྲུབ་དགོས་པའི་ལས་རྣམས་སྒྲུབ་པའི་ཕྱིར་ང་ཚོས་ཅི་བྱེད་དགོས་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ཡེ་ཤུས་ཁོ་ཚོར་“དཀོན་མཆོག་གིས་བཏང་གནང་བ་དེ་ལ་དད་པ་བྱེད་པ་ནི་དཀོན་མཆོག་གི་སྒྲུབ་དགོས་པའི་ལས་དེ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ཁོ་ཚོས་“འོ་ན་ང་ཚོས་དེ་མཐོང་ནས་ཁྱེད་ལ་ཡིད་ཆེས་པའི་ཕྱིར་ཁྱེད་ཀྱིས་ངོ་མཚར་བའི་རྟགས་གང་ཞིག་མཛད་པར་བྱ། ཁྱེད་ཀྱིས་ལས་ཅི་ཞིག་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ང་ཚོའི་ཕ་མེས་ཀྱིས་འབྲོག་སྟོང་ལ་མན་ནཱ་ཟེར་བའི་ཁ་ཟས་བཟས། མདོ་ལས་བྲིས་ཡོད་པ་ལྟར་ཁོང་གིས་ཁོ་ཚོར་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བག་ལེབ་ཟས་སུ་གནང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ཡེ་ཤུས་ཁོ་ཚོར་“ངས་ཁྱེད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་ཁྱེད་རྣམས་ལ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བག་ལེབ་གནང་མཁན་མ་ཡིན། ངའི་ཡབ་ཀྱིས་ཁྱེད་ཚོར་ཞིང་ཁམས་ནས་བདེན་པའི་བག་ལེབ་གནང་མཁན་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","དཀོན་མཆོག་གི་བག་ལེབ་དེ་ནི་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་སྟེ་འཇིག་རྟེན་ལ་ཚེ་གནང་མཁན་དེ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ཁོ་ཚོས་“སྐུ་ཞབས་ལགས། དུས་རྒྱུན་དུ་དེ་ལྟ་བུའི་བག་ལེབ་ང་ཚོ་ལ་གནང་རོགས་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ཡེ་ཤུས་“ང་ནི་ཚེའི་བག་ལེབ་དེ་ཡིན་ནོ། ངའི་རྩར་ཡོང་མཁན་དེ་མི་ལྟོགས། ང་ལ་དད་པ་བྱེད་མཁན་དེ་ནམ་ཡང་མི་སྐོམ། ");
INSERT INTO bod_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","འོན་ཀྱང་ངས་སྔར་བཤད་པ་བཞིན་དུ་ཁྱོད་རྣམས་ཀྱིས་ང་མཐོང་ཡང་ང་ལ་ད་དུང་དད་པ་མི་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ཡབ་ཀྱིས་ང་ལ་གནང་བ་ཐམས་ཅད་ངའི་རྩར་ཡོང་ངེས་ཡིན། སུ་ངའི་རྩར་ཡོང་ན་ཡང་དེ་ངས་ནམ་ཡང་བསྐྲད་པར་མི་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་དོན་ནི་ང་རང་གི་བསམ་པ་སྒྲུབ་ཏུ་མ་ཡིན་ཏེ། ང་མངགས་མཁན་དཀོན་མཆོག་གི་དགོངས་པ་བཞིན་དུ་སྒྲུབ་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ང་མངགས་མཁན་དཀོན་མཆོག་གི་དགོངས་པ་ཅི་ཡིན་ཞེ་ན། ཁོང་གིས་ང་ལ་གནང་ཡོད་པ་ཐམས་ཅད་ལས་གཅིག་ཀྱང་མ་བརླག་པར། དེ་ཚོ་ཐམས་ཅད་དུས་ཀྱི་ཐ་མའི་ཉིན་མོར་སློང་དགོས་པ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","སུས་ཀྱང་སྲས་མཇལ་ནས་ཁོང་ལ་དད་པ་བྱས་ན་དཔག་ཏུ་མེད་པའི་ཚེ་ཐོབ་སྟེ་དུས་ཀྱི་ཐ་མའི་ཉིན་ལ་ངས་དེ་ཚོ་ཐམས་ཅད་གཤིན་པོའི་ཁྲོད་ནས་སློང་བར་བྱ། དེ་ནི་ངའི་ཡབ་ཀྱི་དགོངས་པ་ཡིན་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ཡེ་ཤུས་ང་ནི་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་པའི་བག་ལེབ་ཡིན་ཞེས་གསུངས་པས་ཡ་ཧུ་དཱ་པས་མ་རངས་པའི་གཏམ་བྱེད་བཞིན་ཡོད་དེ། ");
INSERT INTO bod_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“ཡེ་ཤུ་ཁོ་ཡོ་སེབ་ཀྱི་བུ་མ་ཡིན་ནམ། ཁོའི་ཕ་མ་ང་ཚོས་ངོ་མི་ཤེས་སམ། ད་ལྟ་ཁོས་ང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་པ་ཡིན་ཞེས་ཟེར་བ་ཇི་ལྟར་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","དེའི་ལན་དུ་ཡེ་ཤུས་“ཁྱོད་ཚོའི་ཁྲོད་དུ་མ་རངས་པའི་གཏམ་མ་ཤོད། ");
INSERT INTO bod_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ང་མངགས་མཁན་ཡབ་ཀྱིས་མི་འདྲེན་པར་སུ་ཡང་ངའི་རྩར་ཡོང་མི་སྲིད། ཡང་ངས་དུས་ཀྱི་ཐ་མའི་ཉིན་ལ་མི་དེ་གཤིན་པོའི་ཁྲོད་ནས་སློང་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ལུང་སྟོན་པའི་མདོ་ལས། དཀོན་མཆོག་གིས་ཁོ་ཚོ་ཐམས་ཅད་ལ་སློབ་པར་མཛད་པར་འགྱུར་ཞེས་བྲིས་ཡོད། ཡབ་ཀྱི་བཀའ་ལ་ཉན་ཅིང་ཁོང་ལས་སྤྱངས་པའི་མི་ཐམས་ཅད་ངའི་རྩར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","མི་སུས་ཀྱང་ཡབ་མཐོང་མྱོང་བ་ཡིན་ཞེས་བཤད་པ་མ་ཡིན་ཏེ། དཀོན་མཆོག་གི་དྲུང་ནས་ཡོང་བ་དེས་མ་གཏོགས་སུས་ཀྱང་ཡབ་མཐོང་མ་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ངས་ཁྱོད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ང་ལ་དད་པ་བྱེད་མཁན་དེ་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཡོད་དོ། ");
INSERT INTO bod_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ང་ནི་ཚེའི་བག་ལེབ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ཁྱོད་ཚོའི་མེས་པོས་འབྲོག་སྟོང་ལ་མན་ནཱ་ཟེར་བའི་ཁ་ཟས་བཟས་ཀྱང་ཤི ");
INSERT INTO bod_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","འོན་ཀྱང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་པའི་བག་ལེབ་དེ་འདི་ལྟ་བུ་ཡིན། མི་ཞིག་གིས་དེ་ལས་བཟས་ན་འཆི་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ང་ནི་ཞིང་ཁམས་ནས་བབ་པའི་ཚེ་དཔག་ཏུ་མེད་པའི་བག་ལེབ་ཡིན། མི་སུས་ཀྱང་བག་ལེབ་འདི་ལས་བཟས་ན་དུས་གཏན་དུ་གསོན་པར་འགྱུར། ཡང་འཇིག་རྟེན་གསོན་པར་བྱ་བའི་ཕྱིར་ངས་སྦྱིན་པར་བྱ་བའི་བག་ལེབ་དེ་ནི་ངའི་ཤ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པས་གཅིག་གིས་གཅིག་ལ་རྩོད་གླེང་བྱས་ཏེ་“མི་འདིས་ཁོའི་ཤ་ང་ཚོར་ཟས་སུ་སྟེར་བ་དེ་ཅི་ལ་སྲིད་”ཅེས་བཤད་པས། ");
INSERT INTO bod_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ཡེ་ཤུས་“ངས་ཁྱོད་རྣམས་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། གལ་ཏེ་ཁྱོད་ཚོས་མིའི་རིགས་ཀྱི་བུའི་ཤ་དེ་མ་བཟས་ཤིང༌། ཁྲག་ཡང་མ་བཏུངས་ན། ཁྱོད་ཚོར་དཔག་ཏུ་མེད་པའི་ཚེ་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ངའི་ཤ་ཟ་ཞིང་ངའི་ཁྲག་འཐུང་མཁན་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་ཡོད་དེ། དུས་ཀྱི་ཐ་མའི་ཉིན་ལ་ངས་ཁོ་ཚོ་གཤིན་པོའི་ཁྲོད་ནས་སློང་བར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ངའི་ཤ་ནི་བདེན་པའི་ཟས་ཡིན་ཞིང༌། ངའི་ཁྲག་བདེན་པའི་བཏུང་བ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ངའི་ཤ་ཟ་ཞིང་ངའི་ཁྲག་འཐུང་མཁན་རྣམས་ང་དང་འགྲོགས་ཏེ་གནས་ཡོད། ང་ཡང་ཁོ་རྣམས་དང་འགྲོགས་ཏེ་གནས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","གཏན་ནས་གསོན་པའི་ཡབ་ཀྱིས་ང་མངགས་པ་ཡིན་ཏེ། ང་ཡབ་ལ་བརྟེན་ཏེ་གསོན་པ་བཞིན། དེ་ལྟར་ང་ཟ་མཁན་ནི་ང་ལ་བརྟེན་ཏེ་གསོན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","འདི་ནི་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བབ་པའི་བག་ལེབ་ཡིན། བཟས་པ་དང་ཐ་མར་ཤི་བའི་ཁྱོད་ཀྱི་མེས་པོའི་བག་ལེབ་དང་མི་འདྲ། བག་ལེབ་འདི་ཟ་མཁན་གཏན་དུ་གསོན་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ཁོང་གིས་དོན་འདི་ཚོ་ཀ་ཕར་ན་ཧུམ་ལ་ཡོད་པའི་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནང་དུ་ཆོས་སྟོན་དུས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ཁོང་གི་རྗེས་སུ་འབྲང་མཁན་གྱི་ནང་ནས་མང་པོས་དེ་ཐོས་ནས་“གསུང་འདི་ཁག་པོ་ཡིན་པས་སུས་ཁས་ལེན་ཐུབ་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","འོན་ཀྱང་ཡེ་ཤུས་རྗེས་སུ་འབྲང་མཁན་རྣམས་མ་རངས་པའི་གཏམ་ཤོད་བཞིན་པ་མཁྱེན་ནས་ཁོ་ཚོར་“ངས་བཤད་པ་དེས་ཁྱོད་ཀྱི་དད་པ་ཉམས་སུ་འཇུག་གམ། ");
INSERT INTO bod_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ཁྱོད་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་སྔར་ཡོད་པའི་གནས་སུ་ལོག་འགྲོ་བར་མཐོང་ན་ཅི་བསམ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","མི་རྣམས་ལ་ཚེ་གནང་མཁན་ནི་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཡིན་ཏེ་མི་རྣམས་ཀྱི་འབད་རྩོལ་ཕན་མེད་དོ། ངས་ཁྱེད་ཚོར་བཤད་པའི་གཏམ་དེ་ནི་ཚེ་དང་ཐུགས་ཉིད་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","འོན་ཀྱང་ཁྱོད་ཚོའི་ནང་ནས་ཁ་ཅིག་གིས་དད་པ་མི་བྱེད་”ཅེས་གསུངས། གང་ལགས་ཟེར་ན། ཡེ་ཤུས་ཐོག་མ་ནས་དད་པ་མི་བྱེད་པ་རྣམས་དང༌། ཁོང་རང་དགྲའི་དབང་དུ་གཏོང་མཁན་སུ་ཡིན་པ་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ཡང་ཁོང་གིས་“དེའི་ཕྱིར་ངས་ཁྱོད་རྣམས་ལ་ངའི་ཡབ་ཀྱིས་མི་གནང་བར་སུ་ཡང་ངའི་རྩར་ཡོང་མི་སྲིད་ཅེས་བཤད་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","དེའི་ཕྱིར་ཁོང་གི་རྗེས་སུ་འབྲང་མཁན་རྣམས་ལས་མི་མང་པོ་ཕྱིར་ལོག་ནས་ཁོང་དང་མ་འགྲོགས། ");
INSERT INTO bod_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","དེའི་རྐྱེན་གྱིས་ཡེ་ཤུས་ཉེ་གནས་བཅུ་གཉིས་པོ་ལ་“ད་ཁྱེད་ཚོ་ཡང་ཕར་འགྲོ་འདོད་དམ་”ཞེས་བཀའ་འདྲི་གནང༌། ");
INSERT INTO bod_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","སི་མོན་པེ་ཏྲོས་“གཙོ་བོ་ལགས། ང་ཚོ་སུའི་དྲུང་དུ་འགྲོ་བར་བྱ། ཁྱེད་ལ་དཔག་ཏུ་མེད་པའི་ཚེའི་གསུང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ང་ཚོས་དད་པ་བྱས་ཤིང་ཁྱེད་ཉིད་དཀོན་མཆོག་གི་དྲུང་ནས་ཕེབས་པའི་སྐྱེས་བུ་དམ་པ་དེ་ཡིན་པར་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ཡེ་ཤུས་“ངས་ཁྱོད་བཅུ་གཉིས་པོ་བདམས་པ་མ་ཡིན་ནམ། འོན་ཀྱང་ཁྱོད་ཚོའི་ནང་ནས་གཅིག་ནི་བདུད་ཅིག་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ཁོང་གིས་གསུངས་པའི་དོན་ནི་སི་མོན་དབྱི་སི་ཀར་རེའི་བུ་ཡུ་དཱ་ཡིན། མི་འདི་ནི་བཅུ་གཉིས་པོའི་ནང་ནས་གཅིག་ཡིན་ཀྱང་རྗེས་མ་ཡེ་ཤུ་དགྲའི་དབང་དུ་གཏོང་མཁན་དེ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","དེའི་རྗེས་ལ་ཡེ་ཤུ་ག་ལིལ་ཡུལ་གྱི་གནས་སོ་སོར་ཕེབས། ཁོང་ཡ་ཧུ་དཱ་ཡུལ་དུ་དེ་ལྟར་ཕེབས་མི་མཉེས། གང་ལགས་ཟེར་ན། ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་རྣམས་ཀྱིས་ཁོང་དགྲོང་བའི་གོ་སྐབས་བཙལ་གྱི་ཡོད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","དེའི་ཚེ་ཡ་ཧུ་དཱ་པའི་སྤྱིལ་བུའི་དུས་ཆེན་ཉེ་བར་སླེབས་པས། ");
INSERT INTO bod_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ཁོང་གི་ནུ་བོ་རྣམས་ཀྱིས་ཁོང་ལ་“ད་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲང་མཁན་རྣམས་ཀྱིས་ཁྱེད་ཀྱིས་བྱེད་པའི་ལས་རྣམས་མཐོང་བའི་ཕྱིར། ས་ཆ་འདི་དང་འབྲལ་ནས་ཡ་ཧུ་དཱ་ཡུལ་དུ་སོང་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","མི་སུས་ཀྱང་སྙན་གྲགས་ཅན་དུ་འགྱུར་འདོད་ན་དོན་གང་ཡང་ལྐོག་ཏུ་མི་བྱེད། གལ་ཏེ་ཁྱེད་ཀྱིས་ལས་འདི་རྣམས་མཛད་ན། འཇིག་རྟེན་ལ་མངོན་པར་མཛོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ཁོང་གི་ནུ་བོ་རྣམས་ཀྱིས་ཀྱང་ཁོང་ལ་དད་པ་མ་བྱས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","དེའི་ཕྱིར་ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱོད་ལ་རྒྱུན་དུ་གོ་སྐབས་ཡོད་ཀྱང༌། ངའི་དུས་ལ་ད་དུང་མ་བབ། ");
INSERT INTO bod_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","འཇིག་རྟེན་གྱི་མི་ཚོས་ཁྱོད་ཚོར་སྡང་བའི་རྒྱུ་མཚན་ཅི་ཡང་མེད། འོན་ཀྱང་ངས་ཁོ་ཚོས་བྱེད་པའི་ལས་ངན་པ་ཡིན་པར་དཔང་པོ་བྱེད་པས་ང་ལ་སྡང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ཁྱོད་ཚོ་དུས་ཆེན་ལ་སོང་ཞིག ངའི་དུས་ལ་ད་དུང་མ་བབ་པས། ང་ནི་དུས་ཆེན་འདི་ལ་ད་ལྟ་མི་འགྲོ་”ཞེས་གསུངས་ནས་ ");
INSERT INTO bod_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ག་ལིལ་ཡུལ་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","འོན་ཀྱང་ཁོང་གི་ནུ་བོ་རྣམས་དུས་ཆེན་དེ་ལ་སོང་བའི་རྗེས་སུ་ཁོང་ཡང་མངོན་སུམ་དུ་མ་ཕེབས་པར་གསང་སྟབས་ཀྱིས་དེར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཚོས་དུས་ཆེན་གཏོང་སར་ཁོང་བཙལ་ཏེ་“ཁོ་གང་དུ་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","མི་ཚོགས་ཀྱི་ནང་ཁོང་གི་སྐོར་ལ་ཤུབ་ཤུབ་ཏུ་སྨྲ་བའི་གཏམ་མང་པོ་བྱུང་སྟེ། ཁ་ཅིག་གིས་“ཁོང་མི་བཟང་པོ་ཡིན་”ཞེས་བཤད་པ་དང༌། ཁ་ཅིག་གིས་“དེ་ལྟར་མ་ཡིན། མི་མང་པོར་མགོ་སྐོར་གཏོང་མཁན་ཞིག་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","འོན་ཀྱང་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ལ་འཇིགས་པས་སུས་ཀྱང་མངོན་སུམ་གྱི་སྒོ་ནས་ཁོང་གི་སྐོར་གཏམ་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","དེ་ནས་དུས་ཆེན་གྱི་ཕྱེད་ཙམ་ལ་ཡེ་ཤུ་མཆོད་ཁང་ཆེན་མོའི་སྒོ་རར་ཕེབས་ནས་ཆོས་བསྟན་འགོ་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","དེར་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཡ་མཚན་སྐྱེས་ནས་“མི་འདིས་ཆོས་ནམ་ཡང་མ་བསླབས་ཀྱང༌། ཅི་ལྟར་ཆོས་ལ་མཁས་པར་གྱུར་བ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ལན་དུ་ཡེ་ཤུས་“ངའི་བསྟན་པ་འདི་ནི་ང་རང་གི་བསྟན་པ་མ་ཡིན་ཏེ། ང་མངགས་མཁན་དཀོན་མཆོག་ནས་བྱུང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","སུ་ཡང་དཀོན་མཆོག་གི་ཐུགས་དགོངས་བཞིན་དུ་སྒྲུབ་པར་ཆོད་སེམས་བཙུགས་ན། བསྟན་པ་འདི་ནི་དཀོན་མཆོག་ནས་བྱུང་ངམ། ཡང་ན་ངས་རང་ཐོག་ནས་བཤད་པ་ཡིན་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","རང་ལ་བརྟེན་ནས་གཏམ་བཤད་པ་ནི་རང་གི་གྲགས་པ་གཉེར། འོན་ཀྱང་རང་གཏོང་མཁན་གྱི་གྲགས་པ་གཉེར་བ་དེ་ནི་བདེན་པ་ཡིན་ཏེ། དེའི་ནང་ལ་བཅོས་མ་ཅི་ཡང་མེད། ");
INSERT INTO bod_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་ཁྱོད་རྣམས་ལ་བཀའ་ཁྲིམས་གནང་བ་མ་ཡིན་ནམ། ཁྱོད་ཚོའི་ནང་ནས་མི་གཅིག་ཀྱང་བཀའ་ཁྲིམས་མི་སྲུང༌། ཁྱོད་རྣམས་ཀྱིས་ང་གསོད་པའི་གོ་སྐབས་འཚོལ་བ་ཅིའི་ཕྱིར་ཡིན་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ལན་དུ་མི་ཚོགས་ཀྱིས་“ཁྱོད་ལ་འདྲེ་ཞིག་ཞུགས་འདུག སུས་ཁྱོད་གསོད་པར་འབད་བཞིན་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ཡེ་ཤུས་“ངས་ངོ་མཚར་བའི་ལས་ཤིག་བྱས་པས་ཁྱོད་ཚོ་ཐམས་ཅད་ཡ་མཚན་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་ཁྱོད་ཚོར་དཀོན་མཆོག་གིས་གནང་བའི་ཞལ་ཆད་དེ་སྲུང་བའི་རྟགས་རྒྱག་པའི་བཀའ་ཁྲིམས་གནང་ཡོད་པས། ངལ་གསོ་བའི་ཉིན་ལའང་ཁྱོད་ཚོས་རང་གི་བུ་ལ་རྟགས་དེ་རྒྱག་པའི་ལུགས་སྲོལ་སྲུང༌། (འོན་ཀྱང་དོན་དམ་དུ་ལུགས་སྲོལ་དེ་ནི་མོ་ཤེ་རང་ནས་མ་བྱུང༌། མེས་པོའི་དུས་ནས་བྱུང་) ");
INSERT INTO bod_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ད་མོ་ཤེའི་བཀའ་ཁྲིམས་དང་མི་འགལ་བའི་ཕྱིར་ངལ་གསོ་བའི་ཉིན་ལ་མི་ཞིག་ལ་དཀོན་མཆོག་གིས་གནང་བའི་ཞལ་ཆད་དེ་སྲུང་བའི་རྟགས་ལེན་ན། ངས་ངལ་གསོ་བའི་ཉིན་ལ་མི་ཞིག་གི་ལུས་ཡོངས་སུ་གསོ་བར་བྱས་པས་ཁྱོད་ཚོ་ང་ལ་ཁྲོས་སམ། ");
INSERT INTO bod_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ངོ་ལ་བལྟས་ཏེ་ཁྲིམས་གཅོད་མ་བྱོས། ཡང་དག་པའི་སྒོ་ནས་ཁྲིམས་གཅོད་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","དེའི་ཕྱིར་ཡེ་རུ་ཤ་ལེམ་པ་ཁ་ཅིག་གིས་“དཔོན་རིགས་ཚོས་གསོད་ཐབས་བྱེད་པའི་མི་འདི་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ད་ལྟོས་དང༌། ཁོང་གིས་མངོན་སུམ་དུ་གཏམ་གསུངས་བཞིན་པ་ལ་ཁོ་ཚོས་ཅི་ཡང་མི་ཟེར། དཔོན་རིགས་ཚོས་མི་འདི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་པ་དངོས་གནས་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ང་ཚོར་མི་འདི་གང་ནས་བྱུང་བ་རྒྱུས་ཡོད། འོན་ཀྱང་སྐྱབས་མགོན་མཱ་ཤི་ཀ་འབྱོན་པའི་ཚེ་ཁོང་གང་ནས་འབྱུང་སུས་ཀྱང་མི་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","མཆོད་ཁང་ཆེན་མོའི་སྒོ་རར་ཆོས་བསྟན་པའི་སྐབས་ཡེ་ཤུས་གསུང་སྐད་ཆེན་པོས་“ཁྱེད་ཚོས་ང་རང་སུ་ཡིན་པ་དང་གང་ནས་བྱུང་བའང་ཤེས། ངས་རང་ཉིད་ལ་བརྟེན་ནས་མ་ཡོང༌། ང་མངགས་མཁན་དཀོན་མཆོག་ཉིད་བདེན་པ་ཡིན་ཏེ། ཁྱེད་ཚོས་ཁོང་ངོ་མི་ཤེས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ངས་ཁོང་ངོ་ཤེས་སོ། གང་ལགས་ཟེར་ན། ང་ཁོང་ནས་བྱུང་སྟེ། ཁོང་གིས་ང་མངགས་པ་ཡིན་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ཁོ་ཚོས་ཡེ་ཤུ་འཛིན་བཟུང་བར་བཙལ་ཡང༌། ཁོང་གི་དུས་ལ་ད་དུང་མ་སླེབས་པས་མི་སུས་ཀྱང་ཁོང་ལ་ལག་པ་མ་རེག ");
INSERT INTO bod_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","འོན་ཀྱང་མི་ཚོགས་ཀྱི་ནང་ནས་མི་མང་པོས་ཡེ་ཤུ་ལ་དད་པ་བྱས་ནས་“སྐྱབས་མགོན་མཱ་ཤི་ཀ་འབྱོན་པའི་ཚེ་མི་འདིས་བསྟན་པའི་རྟགས་ལས་མང་པོ་སྟོན་པར་འགྱུར་རམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་མི་ཚོགས་ཀྱིས་ཁོང་གི་སྐོར་ལ་ཤུབ་ཤུབ་ཏུ་སྨྲ་བ་ཐོས་ནས། ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཕཱ་རུ་ཤི་པ་ཚོས་ཁོང་འཛིན་པའི་ཆེད་དུ་མཆོད་ཁང་གི་སྲུང་དམག་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ཡེ་ཤུས་“ང་ད་དུང་ཁྱོད་ཚོ་དང་མཉམ་དུ་དུས་ཐུང་ངུ་ཞིག་སྡོད་པར་འགྱུར། དེ་ནས་ང་མངགས་མཁན་གྱི་དྲུང་དུ་འགྲོ ");
INSERT INTO bod_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","དུས་དེར་ཁྱོད་ཚོས་ང་བཙལ་ཡང་མི་རྙེད། ང་གང་དུ་ཡོད་པའི་སར་ཁྱོད་ཚོ་ཡོང་མི་ཐུབ་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཀྱིས་ཕན་ཚུན་བར་“མི་འདི་ང་ཚོས་མི་རྙེད་པའི་ས་ཆ་གང་དུ་འགྲོ་རྩི་ཡོད། ཁོ་རང་ཕྱི་རྒྱལ་ལ་ཕྱིན་ནས་ཕྱི་པ་ཚོར་ཆོས་སྟོན་ནམ། ");
INSERT INTO bod_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ཁྱོད་ཚོས་ང་བཙལ་ཡང་མི་རྙེད་ཅིང༌། ང་གང་དུ་ཡོད་པའི་སར་ཁྱོད་ཚོ་ཡོང་མི་ཐུབ་ཅེས་བཤད་པའི་དོན་ཅི་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","དེ་ནས་དུས་ཆེན་གྱི་མཐའ་མ་ཡིན་ཏེ་གལ་ཆེ་ཤོས་ཡིན་པའི་ཉིན་ལ་ཡེ་ཤུ་བཞེངས་ནས་གསུང་སྐད་ཆེན་པོས་“མི་སུ་སྐོམ་ཡང་དེ་ངའི་མདུན་དུ་ཤོག་ལ་འཐུང་ཞིག ");
INSERT INTO bod_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","སུས་ང་ལ་དད་པ་བྱེད་ཀྱང༌། གསུང་རབ་ཀྱིས་མི་དེའི་སྐོར་གསུངས་པ་ལྟར། མི་དེ་ལས་ཚེ་སྲོག་གི་ཆུ་དང་ལྡན་པའི་གཙང་པོ་རྣམས་འབབ་ཡོང་”ཞེས་གསུངས་པའི་དོན་ནི། ");
INSERT INTO bod_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ཡེ་ཤུ་ལ་དད་པ་བྱེད་མཁན་ཚོ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་འཐོབ་རྒྱུ་ཡིན་པ་དེ་ཡིན། ཡེ་ཤུ་ད་དུང་གཟི་བརྗིད་མ་འཕག་པས་དམ་པའི་ཐུགས་ཉིད་ད་དུང་མ་གནང་བའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ཁོང་གིས་གསུངས་པ་དེ་ཐོས་ནས་མི་ཚོགས་ཀྱི་ནང་ནས་ལ་ལས་“མི་འདི་ལུང་སྟོན་པ་ཞེས་པ་དེ་དངོས་གནས་ཡིན་”ཞེས་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ལ་ལས་“ཁོང་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་”ཞེས་བཤད། འོན་ཀྱང་ཁ་ཅིག་གིས་“ག་ལིལ་ཡུལ་ནས་མཱ་ཤི་ཀ་འབྱུང་ངམ། ");
INSERT INTO bod_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","གསུང་རབ་ཀྱི་ནང་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ནི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་གདུང་རྒྱུད་དང༌། དཱ་བིད་ཀྱི་ཕ་ཡུལ་བེད་ལེ་ཧེམ་ནས་འབྱུང་བར་འགྱུར་ཞེས་གསུངས་ཡོད་པ་མ་ཡིན་ནམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","དེ་ལྟར་མི་ཚོགས་ཀྱི་ནང་ན་ཁོང་གི་སྐོར་ལ་ལྟ་ཚུལ་མི་མཐུན་པ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ཁོ་ཚོའི་ནང་ནས་ཁ་ཅིག་གིས་ཁོང་འཛིན་གཟུང་བྱེད་པར་འདོད་ནའང༌། སུས་ཀྱང་ཁོང་ལ་ལག་པ་མ་རེག ");
INSERT INTO bod_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","དེར་མཆོད་ཁང་གི་སྲུང་དམག་ཚོ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཕཱ་རུ་ཤི་པ་ཚོའི་དྲུང་དུ་ཕྱིར་ཡོང་བ་དང༌། ཁོ་ཚོས་“ཁྱོད་ཚོ་ཅིའི་ཕྱིར་མི་དེ་ཁྲིད་མ་ཡོང་ངམ་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","མཆོད་ཁང་གི་སྲུང་དམག་ཚོས་“མི་སུས་ཀྱང་དེ་ལྟར་ཆོས་གསུངས་མ་མྱོང་”ཞེས་ལན་བཏབ། ");
INSERT INTO bod_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ཕཱ་རུ་ཤི་པ་ཚོས་“ཁོས་ཁྱོད་ཚོར་ཡང་མགོ་སྐོར་བཏང་ངམ། ");
INSERT INTO bod_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","དབུ་ཁྲིད་པ་ཚོའམ་ཕཱ་རུ་ཤི་པ་ལས་སུ་ཞིག་གིས་དེ་ལ་དད་པ་བྱས་སམ། ");
INSERT INTO bod_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","འོན་ཀྱང་ཆོས་ཁྲིམས་མི་ཤེས་པའི་མི་ཚོགས་འདི་དཀོན་མཆོག་དང་བྲལ་བའོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ཕཱ་རུ་ཤི་ཕྱོགས་ཁག་ནང་ནས་ནཱི་ཀོ་དེམ་བྱ་བའི་མི་ཞིག་སྔར་ཡེ་ཤུ་མཇལ་དུ་ཕྱིན་པ་དེས་ཁོ་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ང་ཚོས་ཁྲིམས་གཞུང་ལྟར་མིས་ཅི་ཞིག་བྱས་པ་མ་གོ་བར་དང་མ་ཤེས་གོང་མི་ལ་ཁྲིམས་གཏོང་ཆོག་གམ་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ཁོ་ཚོས་“ཁྱོད་ཀྱང་ག་ལིལ་པ་ཡིན་ནམ། གསུང་རབ་ལ་འཚོལ་ཞིབ་བྱོས་ཤིག ག་ལིལ་ཡུལ་ནས་ལུང་སྟོན་པ་སུ་ཡང་མི་འབྱུང་”ཞེས་ལན་བཏབ་བོ། ། ");
INSERT INTO bod_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","མི་རེ་རེ་བཞིན་ཁྱིམ་དུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","དེ་ནས་ཡེ་ཤུ་སྐྱུར་རུ་ཤིང་གི་རི་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ཐོ་རེངས་སྐབས་སུ་ཁོང་ཡང་བསྐྱར་མཆོད་ཁང་ཆེན་མོའི་རྩར་ཕེབས་པ་དང༌། མི་ཐམས་ཅད་ཁོང་གི་དྲུང་དུ་འཛོམས་ནས་ཁོང་བཞུགས་ཏེ་ཁོ་ཚོར་ཆོས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་དང་ཕཱ་རུ་ཤི་པས་ལོག་གཡེམ་བྱེད་བཞིན་པའི་བུད་མེད་ཅིག་བཟུང་སྟེ་ཡེ་ཤུའི་དྲུང་དུ་ཁྲིད་ཡོང་ནས། མི་ཚོགས་ཀྱི་མདུན་ལ་ཁོ་མོ་ལང་དུ་བཅུག་ནས་ཁོང་ལ་ ");
INSERT INTO bod_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“སྟོན་པ་ལགས། བུད་མེད་འདིས་ལོག་གཡེམ་བྱེད་བཞིན་པའི་སྐབས་བཟུང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ད་ཆོས་ཁྲིམས་ལྟར་མོ་ཤེ་ཡིས་བུད་མེད་འདི་འདྲ་བ་རྣམས་རྡོ་རུབ་གཏོང་བའི་སྒོ་ནས་གསོད་དགོས་པའི་བཀའ་གནང་བས། ཁྱེད་ཀྱིས་ཅི་ལྟར་གསུང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ཁོང་ལ་སྐྱོན་གདོགས་པ་དང་བསྙོན་འཛུགས་པའི་ཆེད་དུ་དེ་ལྟར་ཞུས། འོན་ཀྱང་ཡེ་ཤུས་སྐུ་གཟུགས་སྒུར་ནས་ཕྱག་མཛུབ་ཀྱིས་ས་ལ་བྲིས། ");
INSERT INTO bod_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ཁོ་ཚོས་ཁོང་ལ་ཡང་ཡང་བཀའ་འདྲི་ཞུས་པ་དང༌། ཁོང་ཡར་བཞེངས་ཏེ་ཁོ་ཚོར་“ཁྱོད་ཚོའི་ནང་ནས་སྡིག་ཅན་མ་ཡིན་པ་ཞིག་གིས་ཁོ་མོ་ལ་རྡོ་དང་པོ་གཞུ་བར་ཆོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","དེ་ནས་ཡེ་ཤུས་ཡང་བསྐྱར་སྐུ་གཟུགས་སྒུར་ནས་ས་ལ་བྲིས། ");
INSERT INTO bod_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ཁོང་གིས་གང་གསུངས་པ་ཐོས་ནས་ཁོ་ཚོ་རྒན་ཤོས་ནས་གཞོན་པའི་བར་དུ་རིམ་བཞིན་ཕྱི་རུ་སོང་ཞིང༌། ཡེ་ཤུའི་དྲུང་དུ་བུད་མེད་དེ་གཅིག་པོ་ལངས་ཏེ་ལུས། ");
INSERT INTO bod_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ཡེ་ཤུས་ཡར་བཞེངས་ནས་ཁོ་མོར་“བུ་མོ། ཁོ་ཚོ་གང་དུ་ཡོད། སུས་ཀྱང་ཁྱོད་ལ་ཁྲིམས་མ་བཅད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ཁོ་མོས་“སྐུ་ཞབས་ལགས། སུས་ཀྱང་ང་ལ་ཁྲིམས་མ་བཅད་”ཅེས་བཤད་པ་དང་ཡེ་ཤུས་“འོ་ན་ངའང་ཁྱོད་ལ་ཁྲིམས་མི་གཅོད། སོང་ལ་ད་ཕྱིན་ཆད་སྡིག་ཉེས་མ་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","དེ་ནས་ཡེ་ཤུས་ཡང་བསྐྱར་ཁོ་ཚོར་“ང་ནི་འཇིག་རྟེན་གྱི་འོད་ཡིན། སུ་ངའི་རྗེས་སུ་འབྲངས་ཀྱང་དེ་མུན་པའི་ནང་ལ་མི་འགྲུལ་བར་ཚེ་ཡི་འོད་དང་ལྡན་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ཕཱ་རུ་ཤི་པས་ཁོང་ལ་“ཁྱོད་ཀྱིས་རང་ལ་དཔང་པོ་བྱེད་པས། ཁྱོད་ཀྱི་དཔང་པོ་དེ་མི་བདེན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ཡེ་ཤུས་“ངས་རང་ལ་དཔང་པོ་བྱས་ཀྱང་ངའི་དཔང་པོ་བདེན་པ་ཡིན། གང་ལགས་ཟེར་ན། ང་རང་གང་ནས་བྱུང་བ་དང་གང་དུ་འགྲོ་བ་ཤེས་ཀྱི་ཡོད། འོན་ཀྱང་ཁྱོད་ཚོས་ང་གང་ནས་བྱུང་བ་དང་གང་དུ་འགྲོ་བ་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ཁྱོད་རྣམས་ཀྱིས་ངོ་ལ་བལྟས་ཏེ་ཁྲིམས་གཅོད་བྱེད། ངས་སུ་ལ་ཡང་ཁྲིམས་གཅོད་མི་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","གལ་སྲིད་ངས་ཁྲིམས་གཅོད་བྱས་པ་ཡིན་ན། དེ་ནི་བདེན་པ་ཡིན། གང་ཡིན་ཟེར་ན། ང་གཅིག་པོ་མ་ཡིན་ཏེ། ང་མངགས་མཁན་ཡབ་ང་དང་མཉམ་དུ་ཡོད་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ཁྱོད་ཚོའི་བཀའ་ཁྲིམས་ལྟར་མི་གཉིས་ཀྱིས་དཔང་པོ་བྱེད་པ་ནི་བདེན་ནོ་ཞེས་བྲིས་འདུག ");
INSERT INTO bod_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ངས་ང་རང་ལ་དཔང་པོ་བྱེད། ང་མངགས་མཁན་ཡབ་ཀྱིས་ཀྱང་ང་ལ་དཔང་པོ་མཛད་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ཁོ་ཚོས་ཁོང་ལ་“ཁྱོད་ཀྱི་ཡབ་གང་དུ་ཡོད་”ཅེས་ཞུས། ཡེ་ཤུས་“ཁྱོད་རྣམས་ཀྱིས་ང་ཡང་ངོ་མི་ཤེས། ངའི་ཡབ་ཀྱང་ངོ་མི་ཤེས། ཁྱོད་རྣམས་ཀྱིས་ང་ངོ་ཤེས་ན། ངའི་ཡབ་ཀྱང་ངོ་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","གསུང་དེ་ནི་ཡེ་ཤུས་མཆོད་ཁང་ཆེན་མོའི་དངུལ་འབུལ་ས་དང་ཉེ་བར་ཆོས་སྟོན་དུས་གསུངས་པ་ཡིན་ཀྱང༌། ཁོང་གི་དུས་ལ་ད་དུང་མ་བབ་པས་མི་སུས་ཀྱང་ཁོང་འཛིན་བཟུང་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","དེ་ནས་ཁོང་གིས་ཡང་ཁོ་ཚོར་“ང་ཕར་འགྲོ་སྟེ། ཁྱོད་ཚོས་ང་བཙལ་ཡང༌། ཁྱོད་ཚོ་རང་གི་སྡིག་ཉེས་ནང་དུ་འཆི་བར་འགྱུར་རོ། ང་གང་དུ་འགྲོ་བའི་གནས་སུ་ཁྱོད་ཚོ་ཡོང་མི་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པ་ཚོས་“ང་གང་དུ་འགྲོ་བའི་གནས་སུ་ཁྱོད་ཚོ་ཡོང་མི་ཐུབ་ཅེས་ཟེར་ནི་རང་གི་སྲོག་རང་གིས་གཅོད་དམ་ཞེས་པའི་དོན་ཡིན་ནམ་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱོད་རྣམས་འོག་ནས་ཡིན། ང་ནི་སྟེང་ནས་ཡིན། ཁྱོད་རྣམས་འཇིག་རྟེན་འདི་ལ་གཏོགས་ཏེ། ང་ནི་འཇིག་རྟེན་འདི་ལ་མི་གཏོགས། ");
INSERT INTO bod_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","དེའི་ཕྱིར་ངས་ཁྱོད་ཚོར་ཁྱོད་ཚོ་རང་གི་སྡིག་ཉེས་ནང་དུ་འཆི་བར་འགྱུར་ཞེས་བཤད། གལ་སྲིད་ཁྱོད་ཚོས་ང་ཁོང་ཡིན་པར་དད་པ་མ་བྱས་ན། ཁྱོད་ཚོ་རང་གི་སྡིག་ཉེས་ནང་དུ་འཆི་བར་འགྱུར་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ཁོ་ཚོས་“ཁྱེད་སུ་ཡིན་”ཞེས་ཞུས་པས། ཡེ་ཤུས་“ངས་ཐོག་མ་ནས་ཁྱོད་ཚོར་གང་བཤད་དམ། ");
INSERT INTO bod_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ངར་ཁྱོད་ཚོའི་སྐོར་གྱི་གཏམ་དང་ཁྲིམས་གཅོད་བྱ་རྒྱུ་མང་པོ་ཡོད། འོན་ཀྱང་ང་མངགས་མཁན་དེ་བདེན་པ་ཡིན་པས། ངས་ཁོང་ནས་གང་ཐོས་པ་ཁོ་ན་དེ་ཚོ་ནི་འཇིག་རྟེན་ལ་སྒྲོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ཁོང་གིས་ཡབ་དཀོན་མཆོག་གི་སྐོར་གསུངས་པ་ཁོ་ཚོས་ཧ་མ་གོ་བས། ");
INSERT INTO bod_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ཡེ་ཤུས་“ཁྱོད་རྣམས་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་འཕགས་པའི་ཚེ། ང་ནི་ཁོང་ཡིན་པར་ཤེས་ཤིང༌། ངས་ཡབ་ལ་མ་བརྟེན་པར་ཅི་ཡང་མི་བྱེད་དེ། ཡབ་ཀྱིས་ང་ལ་གསུངས་གནང་བ་ཁོ་ནར་ངས་དེ་སྨྲའོ། ");
INSERT INTO bod_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ཡང་ང་མངགས་མཁན་དེ་ང་དང་མཉམ་དུ་ཡོད། ངས་རྟག་ཏུ་ཡབ་ཀྱི་ཐུགས་མཉེས་པར་བྱེད་པས། ཁོང་གིས་ང་གཅིག་པུར་མ་ལུས་པར་མཛད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ཁོང་གིས་དེ་ལྟར་གསུངས་དུས་མི་མང་པོས་ཁོང་ལ་དད་པ་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","དེ་ནས་ཡེ་ཤུས་ཁོང་ལ་དད་པ་ཡོད་པའི་ཡ་ཧུ་དཱ་པ་ཚོར་“གལ་སྲིད་ཁྱེད་རྣམས་ཀྱིས་ངའི་བཀའ་ལ་མུ་མཐུད་ནས་ཉན་ན། ཁྱེད་ཚོ་ངའི་སློབ་མ་དངོས་གནས་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","བདེན་པ་ཉིད་ཅི་ཡིན་ཤེས་པའི་སྒོ་ནས་ཁྱེད་ཚོ་སྒྲོལ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ལན་དུ་ཁོ་ཚོས་“ང་ཚོ་མེས་པོ་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་ཡིན་ཞིང་མི་གཞན་གྱི་བྲན་གཡོག་གཏན་ནས་བྱེད་མ་མྱོང་བས། ཁྱེད་ཀྱིས་ཁྱེད་ཚོ་སྒྲོལ་བར་འགྱུར་ཞེས་གསུངས་པའི་དོན་ཅི་ཡིན་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ཡེ་ཤུས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། སུས་ཀྱང་སྡིག་ཉེས་བྱེད་པ་དེ་སྡིག་པའི་བྲན་གཡོག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","བྲན་གཡོག་དེ་བདག་པོའི་ཁྱིམ་ལ་རྟག་ཏུ་མི་གནས། འོན་ཀྱང་སྲས་ནི་རྟག་ཏུ་གནས། ");
INSERT INTO bod_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","དེའི་ཕྱིར་སྲས་ཀྱིས་ཁྱེད་ཚོ་བསྒྲལ་ན་ཁྱེད་ཚོ་དངོས་སུ་གྲོལ་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ངས་ཁྱོད་ཚོ་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་ཡིན་པར་ཤེས་ཀྱང༌། ངའི་བཀའ་ཁྱོད་ཚོའི་སེམས་ཀྱི་ནང་ལ་གནས་ས་མེད་པས་ཁྱོད་ཚོས་ང་གསོད་པའི་གོ་སྐབས་འཚོལ། ");
INSERT INTO bod_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ངས་ང་རང་གི་ཡབ་ཀྱི་དྲུང་ནས་གང་མཐོང་ཡོད་པ་དེའི་སྐོར་ཤོད་པར་བྱེད། འོན་ཀྱང་ཁྱོད་ཚོས་རང་གི་ཕ་ནས་གང་ཐོས་པ་བཞིན་དུ་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ཁོ་ཚོས་“ང་ཚོའི་ཕ་ནི་མེས་པོ་ཨབ་ར་ཧམ་ཡིན་”ཞེས་བཤད་པ་དང་ཡེ་ཤུས་“ཁྱོད་ཚོ་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་ཡིན་ན། ཁྱོད་ཚོས་ཁོང་གི་སྤྱོད་ལམ་བཞིན་དུ་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ད་ངས་དཀོན་མཆོག་ནས་ཐོས་པའི་བདེན་པ་དེ་ཁྱོད་ཚོ་ལ་བཤད་ཡོད་པས་ཁྱོད་ཚོས་ང་གསོད་རྒྱུ་འབད། ཨབ་ར་ཧམ་གྱིས་དེ་ལྟར་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ཁྱོད་ཚོས་རང་གི་ཕའི་ལས་བཞིན་དུ་བྱེད་”ཅེས་གསུངས། ཁོ་ཚོས་ཁོང་ལ་“ང་ཚོ་ནི་བྱི་ཕྲུག་མ་ཡིན། དཀོན་མཆོག་ཉིད་ང་ཚོའི་ཡབ་གཅིག་པོ་ཡིན་”ཞེས་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ཡེ་ཤུས་ཁོ་ཚོར་“གལ་ཏེ་དཀོན་མཆོག་ཁྱོད་ཚོའི་ཡབ་ཡིན་ན། ཁྱོད་ཚོས་ང་ལ་གཅེས་པར་འགྱུར། གང་ལགས་ཟེར་ན། ང་དཀོན་མཆོག་ནས་ཡོང་སྟེ་ད་ལྟ་འདིར་ཡོད། ང་ནི་རང་ལ་བརྟེན་ནས་མ་ཡོང་སྟེ། དཀོན་མཆོག་གིས་ང་མངགས་པ་ཡིན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ཁྱོད་ཚོས་ཅིའི་ཕྱིར་ངའི་གཏམ་ཧ་མི་གོ དེ་ནི་ངའི་བཀའ་དེ་ཁས་མི་ལེན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ཁྱོད་ཚོའི་ཕ་བདུད་ཡིན་པས། ཁྱོད་རང་གི་ཕའི་འདོད་པ་བཞིན་དུ་བྱེད་པར་དགའ། བདུད་ནི་ཐོག་མ་ནས་སྲོག་གཅོད་མཁན་ཡིན་ཏེ། བདེན་པ་ཉིད་དང་འབྲལ་བས་ཁོའི་ནང་བདེན་པ་ཅི་ཡང་མེད། ཁོས་རྫུན་ཤོད་པའི་སྐབས་སུ་ཁོའི་རང་བཞིན་ལྟར་རྗོད། ཅི་ལགས་ཟེར་ན། ཁོ་རྫུན་གཏམ་ཤོད་མཁན་ཡིན་ཏེ། རྫུན་གྱི་ཕ་ཡང་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","འོན་ཀྱང་ངས་བདེན་གཏམ་ཤོད་ཀྱི་ཡོད་པས། ཁྱོད་ཚོ་ང་ལ་ཡིད་མི་ཆེས། ");
INSERT INTO bod_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ཁྱོད་ཚོའི་ནང་ནས་སུས་ང་སྡིག་ཅན་ཡིན་པར་ར་སྤྲོད་བྱེད་ཐུབ། ངས་ཁྱོད་ཚོར་བདེན་པ་བཤད་ན་ཁྱོད་ཅིའི་ཕྱིར་ང་ལ་ཡིད་མི་ཆེས། ");
INSERT INTO bod_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","དཀོན་མཆོག་ལ་གཏོགས་པའི་མི་ཚོས་ཁོང་གི་བཀའ་ལ་ཉན། ཁྱོད་ཚོ་དཀོན་མཆོག་ལ་མི་གཏོགས་པས་ཁོང་གི་བཀའ་ལ་མི་ཉན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ལན་དུ་ཡ་ཧུ་དཱ་པས་ཁོང་ལ་“ང་ཚོས་ཁྱོད་ནི་ས་མར་ཡཱ་པ་ཡིན་ཏེ་འདྲེ་ཡིས་ཟིན་པ་ཡིན་བཤད་པ་དེ་མི་བདེན་ནམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ཡེ་ཤུས་“ང་ནི་འདྲེ་ཡིས་མ་ཟིན། ངས་ཡབ་ལ་བཀུར་སྟི་བྱེད། འོན་ཀྱང་ཁྱོད་ཚོས་ང་ལ་སྨོད་བཞིན་འདུག ");
INSERT INTO bod_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ངས་རང་གི་བཀུར་སྟི་མི་འཚོལ། འོན་ཀྱང་དེ་འཚོལ་མཁན་ཞིག་ཡོད་ཅིང་ཁོང་ནི་ཁྲིམས་དཔོན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ངས་ཁྱོད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། མི་ཞིག་གིས་ངའི་བཀའ་སྲུང་མཁན་འཆི་བ་ནམ་ཡང་མི་མྱོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ཡ་ཧུ་དཱ་པས་ཁོང་ལ་“ད་ཁྱོད་འདྲེ་ཡིས་ཟིན་ཡོད་པ་ང་ཚོས་ངེས་པར་དུ་ཤེས། མེས་པོ་ཨབ་ར་ཧམ་དང་ལུང་སྟོན་པ་ཚོ་འདས་ཟིན་མོད། འོན་ཀྱང་ཁྱོད་ཀྱིས་ངའི་བཀའ་སྲུང་མཁན་འཆི་བ་ནམ་ཡང་མི་མྱོང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ཁྱོད་ནི་ང་ཚོའི་མེས་པོ་ཨབ་ར་ཧམ་གྲོངས་པ་དེ་ལས་ཆེ་བ་ཡིན་ནམ། ལུང་སྟོན་པ་ཚོ་ཡང་གྲོངས། ཁྱོད་ཀྱིས་རང་སུ་ཡིན་པར་སེམས་”ཞེས་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ཡེ་ཤུས་“ངས་ང་རང་ལ་བཀུར་སྟི་བྱས་ན་བཀུར་སྟི་དེ་ནི་དོན་མེད་དོ། ངའི་ཡབ་ཀྱིས་ང་ལ་བཀུར་སྟི་མཛད། ཁྱོད་ཚོས་དེ་ནི་ང་ཚོའི་དཀོན་མཆོག་ཡིན་ཞེས་ཟེར་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ཁྱོད་ཚོས་ཁོང་ངོ་མི་ཤེས། ངས་ཁོང་ངོ་ཤེས་སོ། གལ་སྲིད་ངས་དཀོན་མཆོག་ངོ་མི་ཤེས་ཞེས་བཤད་ན་ཁྱོད་དང་འདྲ་བར་རྫུན་ཤོད་མཁན་ཡིན། འོན་ཀྱང་ངས་ཁོང་ངོ་ཤེས་ཏེ་ཁོང་གི་བཀའ་སྲུང༌། ");
INSERT INTO bod_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ཁྱོད་ཚོའི་ཕ་མེས་ཨབ་ར་ཧམ་གྱིས་ངའི་འཇིག་རྟེན་དུ་ཡོང་བའི་དུས་སྐབས་མཐོང་བས་དགའ་མགུ་ཡི་རངས་ཏེ། དེ་མཐོང་ནས་དགའ་བར་གྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ཡ་ཧུ་དཱ་པས་ཁོང་ལ་“ཁྱོད་ནི་ལོ་ལྔ་བཅུ་མ་ལོན་ཀྱང་ཨབ་ར་ཧམ་མཐོང་མྱོང་ངམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ཡེ་ཤུས་“ངས་ཁྱོད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཨབ་ར་ཧམ་མ་སྐྱེས་པའི་སྔོན་ལ་ངའོ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ཁོ་ཚོས་ཁོང་ལ་རྡོ་རུབ་གཏོང་བའི་ཕྱིར་རྡོ་བསྒྲུགས། འོན་ཀྱང་ཡེ་ཤུ་གསང་བའི་ངང་མཆོད་ཁང་ཆེན་མོ་ནས་ཕར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ཡེ་ཤུ་ལམ་ལ་ཕེབས་སྐབས་སྐྱེས་དུས་ནས་ལོང་བ་ཡིན་པའི་མི་ཞིག་གཟིགས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ལ་“རབ་བི། མི་དེ་ལོང་བར་སྐྱེས་པའི་རྒྱུ་རྐྱེན་ཅི་ཡིན། ཁོ་རང་ངམ་ཁོའི་ཕ་མ་སུས་སྡིག་ཉེས་བསགས་སམ་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ཡེ་ཤུས་“མི་འདིས་སྡིག་ཉེས་བསགས་པས་མ་ཡིན་ལ། ཕ་མས་བསགས་པས་ཀྱང་མ་ཡིན། དཀོན་མཆོག་གི་མཛད་པ་ཁོའི་ཚེ་ལ་མངོན་པར་འགྱུར་བའི་ཕྱིར་ཁོ་ནི་ལོང་བར་སྐྱེས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ང་ཚོས་ང་མངགས་མཁན་གྱི་མཛད་པ་དེ་ཉིན་མོའི་དུས་སུ་བྱེད་དགོས། མཚན་མོ་ཤར་བའི་དུས་སུ་མི་སུས་ཀྱང་ལས་ཀ་བྱེད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ང་འཇིག་རྟེན་དུ་ཡོད་པའི་དུས་སུ་ང་ནི་འཇིག་རྟེན་གྱི་འོད་ཡིན་ནོ་”ཞེས་གསུངས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ཡེ་ཤུས་ས་ལ་ལྗགས་ཆབ་དོར་ནས་འདམ་བག་ཅིག་མཛད་དེ་འདམ་བག་དེ་ལོང་བ་དེའི་མིག་ཟུང་ལ་བསྐུས་ནས་དེ་ལ་ ");
INSERT INTO bod_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“སི་ལོམ་རྫིང་བུ་ལ་སོང་ནས་ངོ་ཁྲུས་དང་”ཞེས་གསུངས། (སི་ལོམ་ཞེས་པ་མངགས་པའི་དོན་ཡིན་) དེའི་ཕྱིར་ཁོ་སོང་ནས་བཀྲུས་པས་མིག་གིས་མཐོང་བར་གྱུར་ཏེ་ཚུར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","དེར་ཁྱིམ་མཚེས་དང་སྔར་ཁོ་སློང་མཁན་ཡིན་པར་མཐོང་ཡོད་པ་ཚོས་“འདི་ནི་བསྡད་ནས་སློང་མཁན་དེ་མ་ཡིན་ནམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ལ་ལས་“ཁོ་རང་ཡིན་”ཞེས་ཟེར་བ་དང༌། ལ་ལས་“ཁོ་མ་ཡིན། ཁོ་དང་འདྲ་བ་ཞིག་ཡིན་”ཞེས་བཤད། ཁོ་རང་ཉིད་ཀྱིས་“ང་དེ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","མི་དེ་ཚོས་“འོ་ན་ཁྱེད་ཀྱི་མིག་དབང་ཇི་ལྟར་གསོས་སམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","མི་དེས་“མི་ཡེ་ཤུ་ཟེར་མཁན་གྱིས་འདམ་བག་མཛད་ནས་ངའི་མིག་ཟུང་ལ་བསྐུས་ཏེ། སི་ལོམ་རྫིང་བུར་སོང་ནས་ཁྲུས་དང་ཞེས་གསུངས་པ་དང༌། ང་སོང་ནས་བཀྲུས་པས་ངའི་མིག་གིས་མཐོང་བྱུང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ཁོ་ཚོས་“མི་དེ་གང་དུ་ཡོད་”ཅེས་དྲིས་པས་ཁོས་“ངས་མི་ཤེས་”ཞེས་ལན་བཏབ། ");
INSERT INTO bod_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ཁོ་ཚོས་སྔར་ལོང་བ་ཡིན་པ་དེ་ཕཱ་རུ་ཤི་པ་ཚོའི་མདུན་དུ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ཡེ་ཤུས་འདམ་བག་མཛད་ཅིང་མི་དེའི་མིག་ཟུང་གསོས་པར་མཛད་པའི་ཉིན་ནི་ངལ་གསོ་བའི་ཉིན་མོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ཕཱ་རུ་ཤི་པ་ཚོས་ཀྱང་ཡེ་ཤུས་མིག་ཇི་ལྟར་གསོས་པར་མཛད་པའི་སྐོར་ཁོ་ལ་དྲིས་པ་དང་ལན་དུ་ཁོས་“ཁོང་གིས་ངའི་མིག་ཟུང་ལ་འདམ་བག་བསྐུས་ཏེ་ངས་བཀྲུས་ནས་མིག་གིས་མཐོང་ཐུབ་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ཕཱ་རུ་ཤི་པ་ཚོའི་ནང་ནས་ཁ་ཅིག་གིས་“མི་དེས་ངལ་གསོ་བའི་ཉིན་མོའི་བཀའ་ཁྲིམས་མི་སྲུང་བས། དཀོན་མཆོག་ནས་བྱུང་བ་མི་སྲིད་”ཅེས་བཤད། འོན་ཀྱང་ཁ་ཅིག་གིས་“མི་སྡིག་ཅན་ཅིག་གིས་དེ་ལྟ་བུའི་རྟགས་སྟོན་པ་ཅི་ལ་སྲིད་”ཅེས་བཤད་པས་དེ་ཚོར་ལྟ་བ་མི་མཐུན་པ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","དེ་ནས་ཡང་ཕཱ་རུ་ཤི་པ་ཚོས་སྔོན་མ་ལོང་བ་ཡིན་པ་དེར་“མི་དེས་ཁྱོད་རང་གི་མིག་གསོས་པར་མཛད་པས་ཁྱོད་ཀྱིས་ཅི་ལྟར་སེམས་”ཞེས་དྲིས་པ་དང་མི་དེས་“ཁོང་ལུང་སྟོན་པ་ཞིག་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ཡ་ཧུ་དཱ་པ་ཚོས་མི་དེ་སྔར་ལོང་བ་ཡིན་ཏེ་ད་མཐོང་བ་ལ་ཡིད་མ་ཆེས་པས་དེའི་ཕ་མ་བོས་ནས། ");
INSERT INTO bod_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","དེ་གཉིས་ལ་“འདི་ནི་ཁྱོད་ཚོའི་ཟེར་བའི་སྐྱེས་དུས་ནས་བུ་ལོང་བ་དེ་ཡིན་ནམ། ད་ཅི་ལྟར་མཐོང་བར་གྱུར་རམ་”ཞེས་དྲིས་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ཕ་མ་གཉིས་ཀྱིས་“འདི་ནི་ང་ཚོའི་བུ་ཡིན་ཞིང་སྐྱེས་པའི་དུས་ནས་ལོང་བ་ཡིན་པར་ང་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","འོན་ཀྱང་ད་ལྟ་ཅི་ལྟར་མཐོང༌། ཡང་ན་མིག་སུས་གསོས་པར་མཛད་པ་མི་ཤེས། ཁོ་ན་ཚོད་ལོན་པས་ཁོ་རང་ལ་དྲིས་དང༌། ཁོ་རང་གིས་གཏམ་བཤད་ཡོང་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ཁོའི་ཕ་མས་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ལ་འཇིགས་པའི་རྐྱེན་གྱིས་དེ་ལྟར་བཤད། ཅི་ལགས་ཟེར་ན། སུས་ཀྱང་ཡེ་ཤུ་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་བཤད་པ་དེ་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནས་འབུད་རྒྱུ་ཡིན་པ་ཁོ་ཚོས་སྔོན་ནས་ཐག་བཅད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","དེའི་ཕྱིར་ཁོའི་ཕ་མས་ཁོ་ན་ཚོད་ལོན་པས་ཁོ་རང་ལ་དྲིས་དང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","དེའི་ཕྱིར་ཕཱ་རུ་ཤི་པ་ཚོས་མི་སྔར་ལོང་བ་ཡིན་པ་དེ་ཡང་བསྐྱར་བོས་ནས་ཁོ་ལ་“ཁྱོད་ཀྱིས་དཀོན་མཆོག་གི་མདུན་དུ་བདེན་པ་ཤོད་ཅིག ང་ཚོས་མི་དེ་ནི་སྡིག་ཅན་ཞིག་ཡིན་པར་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ཁོས་“ཁོང་སྡིག་ཅན་ཡིན་མིན་ངས་མི་ཤེས། ང་ནི་སྔར་ལོང་བ་ཡིན་ཡང་ད་ལྟ་མིག་གིས་མཐོང་བ་འདི་ངས་ཤེས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","དེར་ཕཱ་རུ་ཤི་པ་ཚོས་ཡང་བསྐྱར་ཁོ་ལ་“ཁོས་ཁྱོད་ལ་གང་བྱས། ཁྱོད་ཀྱི་མིག་ཅི་ལྟར་གསོས་པར་བྱས་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","མི་དེས་“ངས་སྔར་བཤད་ཀྱང་ཁྱེད་ཚོས་མ་ཉན། ཅིའི་ཕྱིར་ཡང་བསྐྱར་ཐོས་པར་དགའ། ཁྱེད་རང་ཚོའང་ཁོང་གི་ཉེ་གནས་སུ་འགྱུར་བར་འདོད་དམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ཁོ་ཚོ་ཁྲོས་ནས་ཁ་ངན་བཤད་དེ་“ཁྱོད་ནི་མི་དེའི་ཉེ་གནས་ཡིན། འོན་ཀྱང་ང་ཚོ་ནི་ལུང་སྟོན་པ་མོ་ཤེའི་ཉེ་གནས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","དཀོན་མཆོག་གིས་མོ་ཤེ་ལ་གསུང་གནང་ཡོད་པ་དེ་ནི་ང་ཚོས་ཤེས། འོན་ཀྱང་མི་འདི་གང་ནས་བྱུང་བ་མི་ཤེས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ཡང་མི་དེས་“ཁྱད་མཚར། ཁྱེད་ཚོས་ཁོང་གང་ནས་བྱུང་མི་ཤེས་ཀྱང༌། ཁོང་གིས་ངའི་མིག་གསོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","དཀོན་མཆོག་གིས་མི་སྡིག་ཅན་ལ་མི་གསན། འོན་ཀྱང་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་ཅིང་ཁོང་གི་དགོངས་པ་བཞིན་དུ་བྱེད་མཁན་དེའི་སྨོན་ལམ་ལ་གསན་པར་ང་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","འཇིག་རྟེན་གྱི་ཐོག་མ་ནས་བཟུང་སུ་ཞིག་གིས་སྐྱེས་དུས་ནས་ལོང་བ་ཞིག་གསོས་པར་མཛད་པའི་ལོ་རྒྱུས་གཏན་ནས་ཐོས་མ་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","མི་འདི་དཀོན་མཆོག་ནས་མ་བྱུང་ན། ཅི་ཡང་མཛད་པར་མི་སྲིད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ལན་དུ་ཁོ་ཚོས་“ཁྱོད་སྐྱེས་དུས་ནས་སྡིག་ཅན་རང་ཡིན་ཡང༌། ང་ཚོར་བསླབ་བྱ་བྱེད་ཀྱི་ཡོད་དམ་”ཞེས་ཟེར་ནས་ཁོ་ཕྱི་རོལ་ཏུ་བསྐྲད། ");
INSERT INTO bod_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ཡེ་ཤུས་མི་དེ་ཚོས་ཁོ་བསྐྲད་པའི་སྐོར་གསན་ནས། ཁོ་བཙལ་ནས་རྙེད་དེ་ཁོ་ལ་“ཁྱེད་མིའི་རིགས་ཀྱི་བུ་ལ་དད་པ་ཡོད་དམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","མི་དེས་“སྐུ་ཞབས་ལགས། ངས་ཁོང་ལ་དད་པ་བྱེད་པའི་ཕྱིར་ཁོང་སུ་ཡིན་པ་ང་ལ་གསུང་དང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ཡེ་ཤུས་མི་དེར་“ཁྱེད་ཀྱིས་ཁོང་མཐོང་མྱོང་ཞིང༌། ཁྱེད་ལ་གཏམ་བྱེད་མཁན་འདི་ཉིད་ཡིན་ནོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","མི་དེས་“གཙོ་བོ་ལགས། ང་དད་དོ་”ཞེས་ཞུས་ནས་ཁོང་ལ་བསྙེན་བཀུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ཡེ་ཤུས་“ང་ནི་ཁྲིམས་གཅོད་བྱེད་པའི་ཆེད་དུ་འཇིག་རྟེན་འདི་རུ་ཡོང་སྟེ། ལོང་བ་ཚོས་མཐོང་བར་བྱེད་ཅིང༌། མཐོང་བ་ཚོ་ལོང་བར་འགྱུར་བའི་ཕྱིར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ཡེ་ཤུ་དང་མཉམ་དུ་ཡོད་པའི་ཕཱ་རུ་ཤི་པ་འགའ་ཞིག་གིས་གསུང་དེ་ཐོས་ནས་ཁོང་ལ་“ང་ཚོ་ཡང་ལོང་བ་ཡིན་ནམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ལན་དུ་ཡེ་ཤུས་“གལ་ཏེ་ཁྱོད་ཚོ་ལོང་བ་ཡིན་ན་སྡིག་ཉེས་ཀྱང་མེད། འོན་ཀྱང་ཁྱོད་ཀྱིས་ང་ཚོས་མཐོང་ཞེས་ཟེར་བས། ཁྱོད་ཚོའི་སྡིག་ཉེས་ནི་ལུས་སོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ཡེ་ཤུས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། སུ་ཡང་ལུག་རའི་སྒོ་ནས་ལུག་རའི་ནང་དུ་མ་འཛུལ་བར། ཕྱོགས་གཞན་ནས་འཛེག་པ་དེ་ནི་རྐུན་མ་དང་ཇག་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","འོན་ཀྱང་སྒོ་ནས་ལུག་རའི་ནང་དུ་འཛུལ་བ་དེ་ནི་ལུག་རྫི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","སྒོ་སྲུང་མཁན་གྱིས་ལུག་རྫི་ལ་སྒོ་ཕྱེ། ལུག་ཚོས་ལུག་རྫིའི་སྐད་ལ་ཉན། ལུག་རྫིས་རང་གི་ལུག་ཚོའི་མིང་ནས་འབོད་དེ་ཕྱི་རོལ་ཏུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","དེ་ནས་རང་གི་ལུག་ཚང་མ་བཏོན་ཚར་རྗེས། དེ་ཚོའི་མདུན་དུ་འགྲོ་བ་དང༌། ལུག་ཚོས་ཁོའི་སྐད་ངོ་ཤེས་པས་ཁོའི་རྗེས་སུ་འབྲང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","འོན་ཀྱང་མི་རྒྱུས་མེད་ཀྱི་སྐད་ངོ་མི་ཤེས་པས། ལུག་ཚོས་ཁོའི་རྗེས་སུ་མི་འབྲང་སྟེ་འབྲོས་ཡོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","དཔེ་འདི་ཡེ་ཤུས་གསུངས་ཀྱང༌། ཕཱ་རུ་ཤི་པ་ཚོས་དེའི་དོན་ཧ་མ་གོ ། ");
INSERT INTO bod_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","དེའི་ཕྱིར་ཡེ་ཤུས་ཁོ་ཚོར་ཡང་བསྐྱར་“ངས་ཁྱེད་ཚོར་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ལུག་རའི་སྒོ་དེ་ནི་ང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ངའི་སྔོན་དུ་ཡོང་བ་ཐམས་ཅད་རྐུན་མ་དང་ཇག་པ་ཡིན་ཏེ། ལུག་རྣམས་དེ་ཚོར་མ་ཉན། ");
INSERT INTO bod_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ང་ནི་སྒོ་དེ་ཡིན། སུ་ཡང་ང་བརྒྱུད་ནས་འཛུལ་ན་ཐར་བར་འགྱུར། ཡང་ཕྱི་འགྲོ་ནང་འཛུལ་བྱེད་ཅིང་རྩྭ་ཁ་རྙེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","རྐུན་མས་རྐུ་བ་དང་གསོད་པ་དང་མེད་པར་བྱེད་པ་ཁོ་ནའི་ཕྱིར་ཡོང༌། འོན་ཀྱང་ང་ནི་དེ་ཚོར་དཔག་ཏུ་མེད་པའི་ཚེ་ཕུན་སུམ་ཚོགས་པ་ཐོབ་པའི་ཕྱིར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ང་ནི་ལུག་རྫི་བཟང་པོ་ཡིན། ལུག་རྫི་བཟང་པོས་ལུག་གི་དོན་དུ་རང་གི་སྲོག་གཏོང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","གླ་པ་ནི་ལུག་རྫི་མ་ཡིན། ལུག་གི་བདག་པོ་ཡང་མ་ཡིན་པས། སྤྱང་ཀི་ཡོང་བ་མཐོང་སྐབས་ཁོས་ལུག་རྣམས་དོར་ནས་འབྲོས་པ་དང༌། སྤྱང་ཀིས་ལུག་འཁྱེར་ཞིང་ལུག་ཁྱུ་གཏོར། ");
INSERT INTO bod_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ཁོ་ནི་གླ་པ་ཡིན་པས་ལུག་ཁྱུ་ལ་སེམས་ཁུར་མི་བྱེད་པར་འབྲོས། ");
INSERT INTO bod_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ང་ནི་ལུག་རྫི་བཟང་པོ་ཡིན། ཇི་ལྟར་ངས་རང་གི་ལུག་རྣམས་ངོ་ཤེས་པ་དང༌། ངའི་ལུག་རྣམས་ཀྱིས་ཀྱང་ང་ངོ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","དེ་ལྟར་ཡབ་ཀྱིས་ང་ངོ་མཁྱེན་པ་དང༌། ངས་ཀྱང་ཡབ་ཀྱི་ཞལ་ངོ་ཤེས། ཡང་ངས་ལུག་གི་དོན་དུ་ང་རང་གི་སྲོག་བློས་གཏོང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ལུག་ར་འདི་ལ་མི་གཏོགས་པའི་ལུག་གཞན་པ་ཡང་ཡོད། ངས་དེ་ཚོའང་འཁྲིད་དགོས། དེ་ཚོས་ཀྱང་ངའི་སྐད་ཉན་ཏེ་ལུག་ཁྱུ་གཅིག་ལ་རྫི་བོ་གཅིག་ཡོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ངས་རང་གི་སྲོག་བློས་གཏོང་བས་ཡབ་ཀྱིས་ང་ལ་བྱམས། ངས་རང་སྲོག་གཏོང་བའི་རྒྱུ་རྐྱེན་ནི་དེ་སླར་ལེན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","སུས་ཀྱང་ངའི་སྲོག་མི་འཕྲོག ང་ནི་རང་སྲོག་རང་གིས་གཏོང༌། ང་ལ་སྲོག་བློས་གཏོང་བའི་དབང་ཆ་ཡོད་ཅིང་སླར་གསོན་པའི་དབང་ཆ་ཡང་ཡོད། དེ་ལྟར་ངའི་ཡབ་ཀྱིས་ང་ལ་བཀའ་གནང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ཡེ་ཤུས་དེ་ལྟར་གསུངས་པས་ཡ་ཧུ་དཱ་པའི་ནང་ན་ཡང་བསྐྱར་ལྟ་བ་མི་མཐུན་པ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","དེ་ཚོའི་ནང་ནས་མི་མང་པོས་“མི་འདི་འདྲེ་ཞུགས་ཏེ་སྨྱོས་པས་ཁྱོད་ཚོས་ཅིའི་ཕྱིར་ཉན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","འོན་ཀྱང་གཞན་རྣམས་ཀྱིས་“གཏམ་འདི་ནི་འདྲེ་ཞུགས་པ་ཞིག་གི་གཏམ་མ་ཡིན། འདྲེ་ཡིས་མི་ལོང་བའི་མིག་གསོ་བར་བྱེད་པ་དེ་ཅི་ལ་སྲིད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","དེ་ནས་དགུན་དུས་སུ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ལ་མཆོད་ཁང་ཆེན་མོའི་བསྔོ་བའི་དུས་ཆེན་གྱི་སྐབས་ལ། ");
INSERT INTO bod_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ཡེ་ཤུ་མཆོད་ཁང་ཆེན་མོའི་རྩར་སོ་ལོ་མོན་གྱི་གཡབ་རིང་པོའི་ནང་ལ་ཞབས་བཅགས་བཞིན་པའི་དུས་སུ། ");
INSERT INTO bod_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ཡ་ཧུ་དཱ་པ་ཡིས་ཁོང་བསྐོར་ཏེ་“ཁྱེད་ཀྱིས་ཇི་ཙམ་བར་དུ་ང་ཚོར་ཐེ་ཚོམ་སྐྱེ་རུ་འཇུག ཁྱེད་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ཡིན་ན་གསལ་པོར་ཤོད་ཅིག་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ཡེ་ཤུས་“ངས་ཁྱོད་ཚོར་བཤད་ཟིན་ཡང་ཁྱོད་ཚོས་ཡིད་མི་ཆེས། ངས་ངའི་ཡབ་ཀྱི་མཚན་ཐོག་ནས་བྱས་པའི་ལས་ཀྱིས་ང་ལ་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","འོན་ཀྱང་ཁྱོད་ཚོ་ནི་ངའི་ལུག་མ་ཡིན་པས་ང་ལ་ཡིད་མི་ཆེས། ");
INSERT INTO bod_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ངའི་ལུག་ངའི་སྐད་ལ་ཉན། ངས་དེ་ཚོ་ངོ་ཤེས་ཤིང་དེ་ཚོ་ངའི་རྗེས་སུ་འབྲང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ཡང་ངས་དེ་ཚོར་དཔག་ཏུ་མེད་པའི་ཚེ་སྦྱིན་ཞིང་དེ་ཚོ་ནམ་ཡང་འཇིག་པར་མི་འགྱུར། སུས་ཀྱང་ངའི་ལག་ནས་འཕྲོག་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ངའི་ཡབ་ཀྱིས་དེ་ཚོ་ང་ལ་གནང་བ་དང༌། ཁོང་ནི་ཐམས་ཅད་ལས་མཆོག་ཡིན། སུས་ཀྱང་དེ་ཚོ་ངའི་ཡབ་ཀྱི་ཕྱག་ནས་འཕྲོག་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ང་དང་ཡབ་གཅིག་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ཡ་ཧུ་དཱ་པ་ཚོས་ཡང་བསྐྱར་ཁོང་ལ་རྡོ་རུབ་གཏོང་བའི་ཆེད་དུ་རྡོ་བསྒྲུགས། ");
INSERT INTO bod_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ཡེ་ཤུས་མི་དེ་ཚོར་“ངས་ཡབ་ནས་བྱུང་བའི་འཕྲིན་ལས་མང་པོ་ཁྱེད་ཚོར་བསྟན། ལས་དེ་ཚོའི་ནང་ནས་གང་གི་ཆེད་དུ་ཁྱེད་ཚོས་ང་ལ་རྡོ་རུབ་གཏོང་ངམ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","མི་དེ་ཚོས་“ལས་བཟང་པོ་ཞིག་གི་ཕྱིར་ང་ཚོས་ཁྱོད་ལ་རྡོ་རུབ་གཏོང་རྒྱུ་མ་ཡིན། ཁྱོད་ནི་མི་མ་གཏོགས་ཡིན་ཏེ། དཀོན་མཆོག་ཡིན་ཟེར་ནས་དཀོན་མཆོག་ལ་སྐུར་བ་བཏབ་པའི་ཕྱིར་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ཡེ་ཤུས་“ཁྱེད་རྣམས་ཀྱི་ཆོས་ཁྲིམས་ལ་ང་ཡིས་ཁྱོད་ཚོ་ནི་ལྷ་ཡིན་ཟེར་བ་ཡིན་ཞེས་བྲིས་པ་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","གསུང་རབ་ནི་དུས་གཏན་དུ་བདེན་པ་ཡིན་ཏེ། ཡང་དཀོན་མཆོག་གི་བཀའ་ཐོབ་པའི་མི་ལ་ལྷ་རྣམས་ཞེས་ཟེར་ཡོད་པ་ཡིན་ན། ");
INSERT INTO bod_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ངས་ང་དཀོན་མཆོག་གི་སྲས་ཡིན་ཞེས་བཤད་པས་ཁྱོད་ཚོས་དེ་དཀོན་མཆོག་ལ་སྐུར་བ་འདེབས་པ་ཡིན་ཞེས་ཟེར་བའི་དོན་ཅི་ཡིན། དཀོན་མཆོག་གིས་དམ་པར་མཛད་ནས་འཇིག་རྟེན་དུ་མངགས་པ་དེ་ང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ངས་ཡབ་ཀྱི་འཕྲིན་ལས་མ་བྱས་ན། ང་ལ་ཡིད་མ་ཆེས་ཤིག ");
INSERT INTO bod_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","འོན་ཀྱང་ངས་འཕྲིན་ལས་དེ་ཚོ་བྱས་ན། ཁྱོད་ཚོས་ང་ལ་ཡིད་མི་ཆེས་ཀྱང༌། འཕྲིན་ལས་དེ་ཚོར་ཡིད་ཆེས་ཤིག དེ་ནས་ཡབ་ངའི་ནང་ན་ཡོད་པ་དང༌། ང་ཡབ་ཀྱི་ནང་ན་ཡོད་པར་ཤེས་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","དེ་རྗེས་ཡ་ཧུ་དཱ་པས་ཡང་བསྐྱར་ཡེ་ཤུ་འཛིན་རྒྱུ་འབད་ཀྱང༌། ཁོང་ཁོ་ཚོའི་ལག་ནས་ཐར་ཏེ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ཁོང་ཡང་བསྐྱར་ཡོར་དན་གཙང་པོའི་ཕར་ཕྱོགས་སུ་སྔར་ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་གནང་བའི་གནས་སུ་ཕེབས་ནས་དེར་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","མི་མང་པོ་ཁོང་གི་དྲུང་དུ་འཛོམས་པ་དང༌། ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱིས་རྟགས་གང་ཡང་བསྟན་མེད་ཀྱང༌། ཁོང་གིས་མི་འདིའི་སྐོར་གང་གསུངས་པ་ཐམས་ཅད་བདེན་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ཡང་ས་ཆ་དེར་མི་མང་པོས་ཡེ་ཤུ་ལ་དད་པ་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","དེ་ཡང་མི་ལཱ་ཟར་ཟེར་མཁན་པེ་ཐན་ཡཱ་གྲོང་གསེབ་ལ་ན་ནས་བསྡད་ཡོད། པེ་ཐན་ཡཱ་ནི་མར་ཐཱ་དང་ཁོ་མོའི་ནུ་མོ་མིར་ཡམ་གྱི་གྲོང་ཚོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","མིར་ཡམ་ནི་གཙོ་བོའི་སྐུ་གཟུགས་ལ་སྤོས་ཆུ་བླུགས་ནས་ཁོང་གི་ཞབས་རང་གི་སྐྲ་ཡིས་འཕྱིས་མཁན་དེ་ཡིན། དེའི་ནུ་བོ་ལཱ་ཟར་ནད་ཀྱིས་བཏབ་པས། ");
INSERT INTO bod_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","མར་ཐཱ་དང་མིར་ཡམ་གཉིས་ཀྱིས་ཡེ་ཤུ་ལ་“གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་བྱམས་པའི་གྲོགས་པོ་ནི་ནད་ཀྱིས་བཏབ་”ཅེས་ལན་ཅིག་བསྐུར། ");
INSERT INTO bod_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ཡེ་ཤུས་དེ་གསན་ནས་ཁོང་གིས་“ནད་དེ་ནི་འཆི་བའི་རྒྱུ་མ་ཡིན། དཀོན་མཆོག་གི་གཟི་བརྗིད་མངོན་པར་འགྱུར་བའི་ཕྱིར་ཡིན་ཏེ། དཀོན་མཆོག་གི་སྲས་ལ་མིས་བཀུར་སྟི་བྱ་བའི་ཆེད་དུ་བྱུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ཡེ་ཤུས་མར་ཐཱ་དང༌། དེའི་ནུ་མོ་དང༌། ལཱ་ཟར་སྤུན་གསུམ་ལ་བྱམས་པར་མཛད་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ཁོང་གིས་ལཱ་ཟར་ནད་ཀྱིས་བཏབ་པའི་ལན་དེ་གསན་ནས་ཁོང་གང་དུ་བཞུགས་པའི་གནས་སུ་ད་དུང་ཉིན་གཉིས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","དེ་ནས་ཁོང་གིས་ཉེ་གནས་ཚོར་“ད་ང་ཚོ་སླར་ཡ་ཧུ་དཱ་ཡུལ་དུ་ཕྱིར་འགྲོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ཉེ་གནས་རྣམས་ཀྱིས་“རབ་བི། ཁ་སང་ཡ་ཧུ་དཱ་པས་ཁྱེད་ལ་རྡོ་རུབ་བཏང་སྟེ་གསོད་པར་འབད་ཀྱང༌། ད་ཡང་དེར་ཕེབས་རྒྱུ་ཡིན་ནམ་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ཡེ་ཤུས་“ཉིན་མོ་གཅིག་ལ་ཆུ་ཚོད་བཅུ་གཉིས་མེད་དམ། སུ་ཡང་ཉིན་མོར་ལམ་དུ་ཕྱིན་ན། འཇིག་རྟེན་འདིའི་འོད་མཐོང་བས་རྐང་པ་ཐོགས་ནས་སར་མི་འགྱེལ། ");
INSERT INTO bod_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","འོན་ཀྱང་སུ་ཡང་མཚན་མོ་ལམ་ལ་ཕྱིན་ན། དེ་ཚོར་འོད་མེད་པས་སར་འགྱེལ་བར་འགྱུར་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ཁོང་གིས་ཁོ་ཚོར་“ང་ཚོའི་གྲོགས་པོ་ལཱ་ཟར་གཉིད་ཁུག་སྟེ། ངས་ཁོང་གཉིད་གསོད་པར་ཆེད་དུ་འགྲོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ཉེ་གནས་ཚོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁོང་གཉིད་ཁུག་ན་དྲག་ཡོང་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ཡེ་ཤུས་ལཱ་ཟར་ཤི་བའི་སྐོར་གསུངས་ཀྱང༌། ཁོ་ཚོས་ཁོང་གཉིད་ཁུག་པའི་སྐོར་གསུངས་པ་བསམས། ");
INSERT INTO bod_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","དེའི་ཕྱིར་ཡེ་ཤུས་ཁོ་ཚོར་“ལཱ་ཟར་ཤི་ཚར་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ཁྱེད་ཚོས་དད་པ་བྱེད་པའི་ཕྱིར་ང་ཁོང་མཉམ་དུ་དེར་མེད་པ་ལ་དགའ། ད་ང་ཚོ་ཁོའི་རྩ་ལ་འགྲོ་”ཞེས་གསལ་པོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","དེར་ཐོ་མཱ་མིང་གཞན་ལ་མཚེ་མར་ཡང་ཞེས་པ་དེས་ཉེ་གནས་གཞན་ཚོར་“ཁོང་དང་མཉམ་དུ་འཆི་བའི་ཕྱིར་ང་ཚོའང་འགྲོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","དེ་ནས་ཡེ་ཤུ་དེར་བྱོན་ནས་ལཱ་ཟར་གྱི་ཕུང་པོ་དུར་ཁང་དུ་བཅུག་ནས་ཞག་བཞི་སོང་བ་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","པེ་ཐན་ཡཱ་དེ་ཡེ་རུ་ཤ་ལེམ་དང་ཐག་ཉེ་ཞིང་སྤྱི་ལེ་གསུམ་ཙམ་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ཡ་ཧུ་དཱ་པ་མང་པོ་མར་ཐཱ་དང་མིར་ཡམ་གྱི་ནུ་བོ་ཤི་བར་སེམས་གསོ་བའི་ཕྱིར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","མར་ཐཱ་ཡིས་ཡེ་ཤུ་ཕེབས་ཀྱི་ཡོད་པ་ཐོས་ནས་ཁོང་བསུ་བར་ཕྱིན། འོན་ཀྱང་མིར་ཡམ་ཁང་པར་བསྡད། ");
INSERT INTO bod_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","དེ་ནས་མར་ཐཱ་ཡིས་ཡེ་ཤུ་ལ་“གཙོ་བོ་ལགས། ཁྱེད་རང་འདིར་བཞུགས་པ་ཡིན་ན་ངའི་ནུ་བོ་ཤི་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","འོན་ཀྱང་ད་ལྟའང་ཁྱེད་རང་གིས་དཀོན་མཆོག་ལ་གང་ཞུ་བ་དེ་གནང་བར་འགྱུར་བར་ངས་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ཡེ་ཤུས་“ཁྱེད་ཀྱི་ནུ་བོ་གསོན་པོར་ལང་བར་འགྱུར་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","མར་ཐཱ་ཡིས་“དུས་ཀྱི་མཐའ་མའི་ཉིན་མོར་གཤིན་པོ་ཐམས་ཅད་གསོན་པོར་ལང་དུས་ཁོ་ཡང་སླར་གསོན་པར་འགྱུར་བ་ངས་ཤེས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ཡེ་ཤུས་“སླར་གསོན་པ་དང་དཔག་ཏུ་མེད་པའི་ཚེ་ནི་ངའོ། སུ་ཡང་ང་ལ་དད་པ་བྱེད་མཁན་དེ་ཤི་ཡང་གསོན་པར་འགྱུར་ལ། ");
INSERT INTO bod_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","སུ་ཡང་ང་ལ་བརྟེན་ནས་གསོན་ཞིང་ང་ལ་དད་པ་བྱེད་མཁན་དེ་འཆི་མི་སྲིད། དོན་དེ་ལ་ཁྱེད་ཀྱིས་ཡིད་ཆེས་སམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","མར་ཐཱས་ཁོང་ལ་“ལགས་སོ། གཙོ་བོ་ལགས། ཁྱེད་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་དཀོན་མཆོག་གི་སྲས་འཇིག་རྟེན་དུ་འབྱོན་པ་དེ་ཡིན་པར་ངས་དད་པ་བྱེད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","མར་ཐཱ་སོང་ནས་མིར་ཡམ་ཟུར་དུ་བོས་ཏེ་“སྟོན་པ་འདིར་ཡོད་ཅིང་ཁྱོད་འབོད་ཀྱི་འདུག་”ཅེས་བཤད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","མིར་ཡམ་གྱིས་དེ་ཐོས་ནས་མགྱོགས་པོར་ལངས་ཏེ་ཁོང་གི་དྲུང་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ཡེ་ཤུ་ནི་ད་དུང་གྲོང་གསེབ་ལ་མ་ཕེབས་ཏེ་མར་ཐཱ་ཡིས་ཁོང་མཇལ་བའི་གནས་སུ་བཞུགས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","མིར་ཡམ་དང་མཉམ་དུ་ཁང་པར་བསྡད་ཅིང་སྐྱོ་རོགས་བྱེད་པའི་ཡ་ཧུ་དཱ་པ་དེ་ཚོས་ཁོ་མོ་མགྱོགས་པོར་ལངས་ནས་ཕྱི་རོལ་ཏུ་སོང་བར་མཐོང་ནས། དུར་ཁང་དུ་ངུ་བར་སོང་བསམས་ཏེ་དེའི་རྗེས་སུ་འབྲངས། ");
INSERT INTO bod_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","མིར་ཡམ་ཡེ་ཤུ་ཡོད་སར་སླེབས་པའི་ཚེ་ཁོང་མཇལ་ནས་པུས་མོ་སར་བཙུགས་ཏེ་“གཙོ་བོ་ལགས། ཁྱེད་རང་འདིར་བཞུགས་པ་ཡིན་ན་ངའི་ནུ་བོ་ཤི་མི་སྲིད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ཡེ་ཤུས་མིར་ཡམ་དང་ཡ་ཧུ་དཱ་པ་གཞན་ཚོའང་ངུ་བར་གཟིགས་ཏེ། ཐུགས་ཤིན་ཏུ་འཁྲུགས་ནས། ");
INSERT INTO bod_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ཁོང་གིས་“ཁོའི་ཕུང་པོ་གང་དུ་བཞག་ཡོད་”ཅེས་གསུངས་པས་ལན་དུ་ཁོ་ཚོས་“གཙོ་བོ་ལགས། འདིར་ཕེབས་ནས་གཟིགས་དང་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","དེར་ཡེ་ཤུ་བཤུམས། ");
INSERT INTO bod_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པས་གཅིག་གིས་གཅིག་ལ་“ལྟོས་དང༌། ཁོང་གིས་ཁོ་ལ་ཤིན་ཏུ་བྱམས་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","འོན་ཀྱང་ཁོ་ཚོ་ལས་ཁ་ཅིག་གིས་“མི་འདིས་ལོང་བའི་མིག་གསོས་ཐུབ་པ་ཡིན་ན། ལཱ་ཟར་ཡང་འཆི་བ་ལས་སྐྱོབ་པར་མཛད་མི་ཐུབ་བམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","དེར་ཡང་ཡེ་ཤུ་རང་གི་ཐུགས་འཁྲུགས་ཏེ་དུར་ཁང་གི་རྩར་ཕེབས། དུར་ཁང་དེ་བྲག་ཕུག་ཅིག་ཡིན་ཞིང་དེའི་ཁ་ལ་རྡོ་ཆེན་པོ་ཞིག་བཞག་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ཡེ་ཤུས་“ད་རྡོ་ཕར་འཐེན་ཅིག་”ཅེས་གསུངས་ནས། གཤིན་པོའི་ཨ་ཅག་མར་ཐཱས་“གཙོ་བོ་ལགས། ཁོ་ཤི་ནས་ཉིན་བཞི་སོང་བས་ད་དྲི་མ་ངན་པ་ཁ་ཡོང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ཡེ་ཤུས་“སྔར་ངས་ཁྱེད་ལ་གལ་ཏེ་དད་པ་བྱས་ན་དཀོན་མཆོག་གི་གཟི་བརྗིད་མཐོང་ངེས་ཡིན་ཞེས་བཤད་པ་མ་ཡིན་ནམ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ཁོ་ཚོས་རྡོ་ཕར་འཐེན། དེར་ཡེ་ཤུས་ཡར་གཟིགས་ཏེ་“ངའི་ཡབ། ཁྱེད་ཀྱིས་ང་ལ་གསན་པས་ཐུགས་རྗེ་ཆེ། ");
INSERT INTO bod_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ཁྱེད་ཀྱིས་རྟག་ཏུ་ངས་ཞུས་པ་ལ་གསན་པ་ཤེས་ཀྱང༌། འདིར་ཡོད་པའི་མི་ཚོས་ཁྱེད་ཀྱིས་ང་མངགས་པ་ཡིན་པར་དད་པ་བྱེད་པའི་ཕྱིར་ངས་དེ་ལྟར་ཞུས་”ཞེས་གསུངས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ཁོང་གིས་གསུང་སྐད་ཆེན་པོས་“ལཱ་ཟར། ཕྱིར་ཐོན་ཤོག་”ཅེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","གཤིན་པོ་རྐང་ལག་རས་ཀྱིས་བསྡམས་པ་དང༌། གདོང་པ་ཡང་རས་ཀྱིས་བཏུམས་པ་དེ་ཕྱི་རོལ་ཏུ་ཐོན། ཡེ་ཤུས་ཁོ་ཚོར་“རས་བཀྲོལ་ལ་ཁོང་འགྲོ་རུ་ཆུག་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","དེའི་ཕྱིར་མིར་ཡམ་དང་མཉམ་དུ་ཡོང་བའི་ཡ་ཧུ་དཱ་པ་མང་པོས་ཡེ་ཤུས་མཛད་པའི་དོན་དེ་མཐོང་ནས་ཁོང་ལ་དད་པ་སྐྱེས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","འོན་ཀྱང་ཁོ་ཚོ་ལས་འགའ་ཞིག་ཕཱ་རུ་ཤི་པ་ཚོའི་རྩར་ཕྱིན་ནས་ཡེ་ཤུས་གང་མཛད་པའི་སྐོར་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཕཱ་རུ་ཤི་པ་ཚོས་གྲོས་ཚོགས་བསྐོངས་ནས་“མི་འདིས་རྟགས་མང་པོ་སྟོན་པས། ང་ཚོས་ཅི་ལྟར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","གལ་སྲིད་ཁོ་ལ་དེ་ལྟར་བྱེད་བཅུག་ན་མི་ཐམས་ཅད་ཀྱིས་ཁོ་ལ་དད་པར་འགྱུར་ཞིང༌། རོ་མཱ་པ་ཚོ་ཡོང་ནས་ང་ཚོའི་གནས་མཆོག་དང་མི་རིགས་གཉིས་འཕྲོག་ཡོང་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","འོན་ཀྱང་ཁོ་ཚོའི་ནང་ནས་ཀ་ཡ་ཕཱ་ཞེས་པའི་མི་གཅིག་ལོ་དེར་ཡ་ཧུ་དཱ་པའི་དབུ་ཁྲིད་བླ་ཆེན་ཡིན་ཏེ། མི་དེ་ཚོར་“ཁྱོད་ཚོས་ཅིའང་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","མི་དམངས་ཧྲིལ་པོ་མེད་པར་འགྱུར་བ་ལས། མི་གཅིག་མི་དམངས་ཀྱི་དོན་དུ་འཆི་བ་དེ་ཁྱོད་ཚོ་ལ་ལེགས་པ་ཡིན་པ་དེ་མི་རྟོགས་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","འོན་ཀྱང་ཁོང་གིས་གཏམ་དེ་རང་ཐོག་ནས་མ་བཤད་དེ། ལོ་དེར་དབུ་ཁྲིད་བླ་ཆེན་ཡིན་པས་ཡེ་ཤུ་ནི་ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཀྱི་དོན་དུ་འགྲོངས་རྒྱུ་ཡིན་པ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","གང་སར་འཐོར་བའི་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོ་རྣམས་གཅིག་ཏུ་སྡུད་པའི་ཕྱིར་ཡང་འགྲོངས་རྒྱུ་ཡིན་པ་ལུང་བསྟན། ");
INSERT INTO bod_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","དེའི་ཕྱིར་ཉིན་དེ་ནས་བཟུང་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ཀྱིས་ཡེ་ཤུ་དགྲོང་བའི་ཇུས་ངན་བཏིང༌། ");
INSERT INTO bod_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","དེར་བརྟེན་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་ནང་མངོན་སུམ་དུ་མ་ཕེབས་པར། དབེན་གནས་ས་ཁུལ་དང་ཉེ་བའི་ཨེབ་ར་ཡིམ་ཟེར་བའི་གྲོང་ཁྱེར་ལ་ཉེ་གནས་དང་བཅས་ཕེབས་ནས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","དེའི་ཚེ་ཡ་ཧུ་དཱ་པའི་པེ་སག་གི་དུས་ཆེན་ཉེ་བར་སླེབས་པས། དུས་ཆེན་གྱི་སྔོན་ལ་མི་མང་པོ་གྲོང་གསེབ་ནས་ཡེ་རུ་ཤ་ལེམ་དུ་གཙང་སྦྲའི་ཆོ་ག་བྱེད་དུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ཁོ་ཚོས་ཡེ་ཤུ་བཙལ་བ་དང༌། མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རའི་ནང་ལངས་བསྡད་ཡོད་དུས་ཕན་ཚུན་དུ་“ཁྱེད་ཅི་ལྟར་སེམས། ཁོང་དུས་ཆེན་འདི་ལ་ཕེབས་ཡོང་ངམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་ཡེ་ཤུ་འཛིན་བཟུང་བྱེད་པའི་ཆེད་དུ། སུས་ཡེ་ཤུ་གང་དུ་བཞུགས་པའི་རྒྱུས་ཡོད་ཀྱང་དེས་ཁོ་ཚོར་ཤོད་དགོས་པའི་བཀའ་བཏང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","པེ་སག་གི་དུས་ཆེན་སྔོན་གྱི་ཉི་མ་དྲུག་པ་ལ་ཡེ་ཤུ་པེ་ཐན་ཡཱ་གྲོང་གསེབ་ལ་བྱོན་པ་དང༌། དེ་ནི་ཁོང་གིས་སྔར་འཆི་བ་ལས་བསླངས་པའི་མི་ལཱ་ཟར་གྱི་ཕ་ཡུལ་ཡིན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","དེར་ཁོ་ཚོས་ཁོང་ལ་དགོང་ཟས་ཤིག་བཤམས་ནས། མར་ཐཱས་གསོལ་གཡོག་བྱས་ཏེ། ལཱ་ཟར་ཡང་ཁོང་ཚོ་དང་མཉམ་དུ་བཟས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","མིར་ཡམ་གྱིས་ནཱར་དཱི་ཟེར་བའི་རིན་གོང་ཆེ་བའི་སྤོས་ཆུ་ལྷད་མེད་པ་རྒྱ་མ་གང་ཙམ་བླངས་ནས། ཡེ་ཤུའི་ཞབས་ལ་བླུགས་ཏེ། རང་གི་སྐྲ་ཡིས་འཕྱིས། ཁང་པ་སྤོས་ཆུའི་དྲི་བཟང་གིས་གང་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","འོན་ཀྱང་རྗེས་མ་ཡེ་ཤུ་དགྲའི་དབང་དུ་གཏོང་མཁན་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་ཁོང་གི་ཉེ་གནས་རྣམས་ལས་གཅིག་ཡིན་ཏེ་དེས་ ");
INSERT INTO bod_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“སྤོས་ཆུ་འདི་དེ་ཎ་རིའི་དངུལ་སྒོར་སུམ་བརྒྱར་བཙོངས་ནས་དབུལ་ཕོངས་ཚོ་ལ་སྦྱིན་པ་བཏང་ན་ལེགས་པ་མ་ཡིན་ནམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ཁོས་དབུལ་ཕོངས་ཚོར་སྙིང་རྗེ་སྐྱེས་ནས་དེ་ལྟར་ཟེར་བ་མ་ཡིན་ཏེ། ཁོ་ནི་རྐུན་མ་ཡིན་ཞིང་ཁོས་ཐུན་མོང་གི་དངུལ་ཁུག་ཁྱེར་ཏེ་དེའི་ནང་བཅུག་ཡོད་པའི་དངུལ་ལྐོག་ལེན་བྱེད་པའི་གོམས་གཤིས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","དེ་ནས་ཡེ་ཤུས་“ཁོ་མོར་སྡུག་པོ་མ་གཏོང་ཞིག དེ་ནི་ང་དུར་དུ་འཇུག་པའི་ཉིན་མོའི་དོན་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","དབུལ་ཕོངས་ཚོ་ནི་རྟག་ཏུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཡོད་ཀྱང༌། ང་ནི་དུས་རྒྱུན་དུ་ཁྱེད་ཚོའི་རྩར་མེད་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","དེའི་ཚེ་ཡ་ཧུ་དཱ་པའི་མི་ཚོགས་མང་པོས་ཡེ་ཤུ་དེར་བཞུགས་པ་ཐོས་ནས། ཡེ་ཤུ་མཇལ་བའི་ཆེད་དུ་མ་ཟད། ལཱ་ཟར་ཁོང་གིས་འཆི་བ་ལས་བསླངས་པ་དེར་ཡང་ལྟ་བར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་ཚོས་ལཱ་ཟར་ཡང་གསོད་པའི་ཇུས་ངན་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ཅི་ལགས་ཟེར་ན། ལཱ་ཟར་གྱི་རྐྱེན་གྱིས་ཡ་ཧུ་དཱ་པ་མང་པོ་ཆོས་དཔོན་དང་ཁ་བྲལ་ནས་ཡེ་ཤུ་ལ་དད་པ་བྱེད་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","དེའི་སང་ཉིན་པེ་སག་དུས་ཆེན་ལ་ཡོང་བའི་མི་ཚོགས་མང་པོས་ཡེ་ཤུ་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་བཞིན་ཡོད་པའི་གཏམ་ཐོས་ནས། ");
INSERT INTO bod_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ཁོ་ཚོས་ཏ་ལའི་ཤིང་གི་ཡལ་ག་བླངས་ནས་ཁོང་བསུ་བར་ཕྱིན་པ་དང་སྐད་ཆེན་པོས་“ཧོ་ཟན་ནཱ། དཀོན་མཆོག་གི་མཚན་ཐོག་ནས་ཕེབས་མཁན་ཡིན་ཏེ་ཡི་སི་ར་ཨེལ་གྱི་རྒྱལ་པོར་བྱིན་རླབས་གནང་བར་ཤོག་”ཅེས་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ཡེ་ཤུས་བོང་གསར་ཞིག་ཐོབ་ནས་དེ་ལ་བཅིབས། བྱ་བ་འདི་ཚོ་གསུང་རབ་ཀྱི་མདོ་ལྟར་བྱུང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ཀྱེ། ཙི་ཡོན་སྲས་མོ་འཇིགས་པར་མ་འགྱུར་ཞིག ། ཁྱེད་ཀྱི་རྒྱལ་པོ་བོང་གསར་བཅིབས་ནས་ནི། ། ད་ལྟ་འབྱོན་བཞིན་འདུག་པར་ལྟོས་ཤིག་ཨང༌། ། ཞེས་མདོ་ལ་བྲིས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","དེའི་སྐབས་སུ་ཁོང་གི་ཉེ་གནས་ཚོས་དོན་འདི་ཚོ་མ་རྟོགས། འོན་ཀྱང་ཡེ་ཤུ་འཕགས་པའི་གཟི་བརྗིད་མངོན་པའི་རྗེས་སུ་དོན་དེ་རྣམས་ཁོང་གི་སྐོར་ལ་བྲིས་ཡོད་པ་དང་མི་གཞན་གྱིས་ཁོང་ལ་གང་བྱས་པ་དྲན། ");
INSERT INTO bod_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ཡེ་ཤུས་ལཱ་ཟར་དུར་ཁང་ནས་བོས་ཤིང་འཆི་བ་ལས་བསླངས་པ་མཐོང་བའི་མི་ཚོགས་ཀྱིས་མི་གཞན་ལ་ཡེ་ཤུའི་སྐོར་དཔང་པོ་བྱེད་བཞིན་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","མི་མང་པོས་ཁོང་གིས་རྟགས་དེ་བསྟན་པ་ཡིན་པ་ཐོས་ཏེ་ཁོང་མཇལ་བར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ཕཱ་རུ་ཤི་པ་ཚོས་ཕན་ཚུན་དུ་“ལྟོས་ཤིག འཇིག་རྟེན་ཀུན་ཁོའི་རྗེས་སུ་འབྲང་བས། ང་ཚོས་ང་ཚོའི་དོན་མི་སྒྲུབ་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","དེའི་ཚེ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཕྱིར་པེ་སག་གི་དུས་ཆེན་ལ་ཡོང་བའི་མི་ཚོའི་ནང་ནས་གྷི་རིག་མི་འགའ་ཞིག་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","མི་དེ་ཚོ་ག་ལིལ་ཡུལ་གྱི་གྲོང་ཚོ་པེ་སད་དཱ་ནས་ཡིན་པ་ཕི་ལིབ་ཀྱི་མདུན་དུ་སོང་ནས་“སྐུ་ཞབས་ལགས། ང་ཚོ་ཡེ་ཤུ་མཇལ་བར་འདོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ཕི་ལིབ་སོང་ནས་ཨན་དྲི་ཡཱ་ལ་དོན་དེ་བཤད་དེ། ཨན་དྲི་ཡཱ་དང་ཕི་ལིབ་གཉིས་སོང་ནས་ཡེ་ཤུ་ལ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ལན་དུ་ཡེ་ཤུས་དེ་གཉིས་ལ་“ད་མིའི་རིགས་ཀྱི་བུ་ཡི་གཟི་བརྗིད་མངོན་པར་འགྱུར་བའི་དུས་ལ་འབབ། ");
INSERT INTO bod_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ངས་ཁྱེད་ཚོར་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། གྲོའི་འབྲུ་རྡོག་སའི་ནང་ལྷུངས་ནས་མ་ཤི་ན་འབྲུ་རྡོག་ཁོ་ནར་ལུས། འོན་ཀྱང་ཤི་ན་འབྲུ་རྡོག་དེ་འབྲས་བུ་མང་པོ་སྐྱེ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","སུ་ཡང་རང་གི་སྲོག་ལ་ཆགས་པ་དེ་བརླག་པར་འགྱུར། སུས་འཇིག་རྟེན་འདིར་རང་གི་སྲོག་ལ་མ་ཆགས་པ་དེ་དཔག་ཏུ་མེད་པའི་ཚེའི་ཕྱིར་སྐྱོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","སུས་ང་ལ་གཡོག་བྱས་ཀྱང་དེ་ངའི་རྗེས་སུ་འབྲང་དགོས་ཤིང༌། ང་གང་དུ་ཡོད་པའི་གནས་དེར་ངའི་གཡོག་པོའང་ཡོད་པར་འགྱུར། སུས་ང་ལ་གཡོག་བྱས་ན། ཡབ་ཀྱིས་མི་དེར་བཀུར་སྟི་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ད་ངའི་སེམས་འཁྲུགས་ཏེ་ཅི་བཤད་པར་བྱ། ཀྱེ། ཡབ་ཁྱེད་ཀྱིས་ང་སྡུག་བསྔལ་གྱི་དུས་སྐབས་འདི་ལས་སྐྱོབ་པར་མཛོད་ཅིག་ཅེས་ཟེར་རམ། དེ་མི་སྲིད། གང་ཡིན་ཟེར་ན། ང་དོན་འདིའི་ཕྱིར་འཇིག་རྟེན་དུ་ཡོང་བ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ཡབ་ལགས། ཁྱེད་ཀྱི་མཚན་གཟི་བརྗིད་དང་ལྡན་པར་མཛོད་ཅིག་”ཅེས་གསུངས་པ་དང་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་གསུང་ཞིག་བྱུང་བ་སྟེ་“ངས་གཟི་བརྗིད་དང་ལྡན་པར་བྱས་ལ་སླར་ཡང་དེ་ལྟར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","དེར་ལངས་པའི་མི་ཚོགས་ཀྱིས་དེ་ཐོས་པ་དང༌། ལ་ལས་འབྲུག་སྒྲ་ལྡིར་བ་ཡིན་ཞེས་ཟེར་བ་དང༌། ལ་ལས་“དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་གིས་ཁོང་ལ་གསུངས་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ཡེ་ཤུས་“གསུང་འདི་ངའི་ཕྱིར་མ་བྱུང་གི ཁྱེད་ཚོའི་ཆེད་དུ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ད་འཇིག་རྟེན་འདིའི་ཁྲིམས་གཅོད་ཀྱི་དུས་ལ་འབབ་འདུག ད་འཇིག་རྟེན་འདིའི་དབང་སྒྱུར་མཁན་སྐྲོད་ཀྱི་དུས་ལ་ཡང་འབབ་འདུག ");
INSERT INTO bod_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ཡང་ང་ས་ལས་འཕག་པའི་ཚེ་ངས་མི་ཐམས་ཅད་ང་རང་གི་དྲུང་དུ་འདྲེན་པར་བྱ་”ཞེས་གསུངས་པའི་དོན་ནི། ");
INSERT INTO bod_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ཁོང་རང་གི་འགྲོངས་ལུགས་གང་འབྱུང་བར་འགྱུར་བ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","དེའི་ཕྱིར་མི་ཚོགས་ཀྱིས་ཁོང་ལ་“ང་ཚོས་དཀོན་མཆོག་གི་གསུང་རབ་ལས་སྐྱབས་མགོན་མཱ་ཤི་ཀ་ནི་རྒྱུན་དུ་གནས་སོ་ཞེས་བྲིས་ཡོད་པ་ཐོས་པས། ཁྱེད་ཀྱིས་མིའི་རིགས་ཀྱི་བུ་འཕག་དགོས་གསུང་བ་དེ་ཅི་ཡིན། མིའི་རིགས་ཀྱི་བུ་དེ་སུ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ཡེ་ཤུས་“ད་དུང་དུས་ཐུང་ངུ་ཞིག་གི་རིང་འོད་ནི་ཁྱོད་ཚོ་དང་མཉམ་དུ་ཡོད། འོད་ཡོད་པའི་བར་དུ་འགྲུལ་ཞིག ཁྱེད་ཚོར་མུན་ནག་མི་རུབ་པའི་ཕྱིར་རོ། སུ་ཡང་མུན་པ་ལ་འགྲུལ་བ་དེ་གང་དུ་འགྲོ་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","འོད་ཡོད་པའི་བར་དུ་འོད་ལ་དད་པ་གྱིས་ཤིག དེ་ནི་ཁྱེད་ཚོ་འོད་ཀྱི་སྲས་སུ་འགྱུར་བའི་ཕྱིར་རོ་”ཞེས་གསུངས་པ་དང་ཡེ་ཤུས་ཕར་ཕེབས་ཏེ། ཁོང་ཁོ་ཚོ་ལ་ཡིབས་ནས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ཁོང་གིས་ཁོ་ཚོའི་མདུན་དུ་དེ་ལྟར་རྟགས་མང་པོ་བསྟན་ཀྱང་ཁོ་ཚོས་ཁོང་ལ་དད་པ་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","འདི་ནི་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱའི་ལུང་བསྟན་སྒྲུབ་པའི་ཆེད་དུ་ཡིན། ཁོང་གིས། གཙོ་བོ། ང་ཚོས་བསྒྲགས་པའི་འཕྲིན་ལ་སུས་ཡིད་ཆེས། ། གཙོ་བོའི་ནུས་མཐུ་སུ་ལ་མངོན་པར་གྱུར། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","དེའི་ཕྱིར་ཁོ་ཚོས་དད་པ་བྱས་མ་ཐུབ། ཡང་ཡེ་ཤ་ཡཱས། ");
INSERT INTO bod_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","གཙོ་བོ་ཉིད་ཀྱིས་མི་རྣམས་དེ་ཡི་མིག ། ལོང་བར་མཛད་ཅིང་སེམས་ཀྱང་མཁྲེགས་པོར་མཛད། ། དེ་ལྟར་མིན་ན་མིག་གིས་མཐོང་བ་དང༌། ། བློ་ཡིས་རྟོགས་ཤིང་སེམས་ཀྱང་བསྒྱུར་ནས་ནི། ། ང་ཡིས་ཁོ་ཚོ་གསོ་ཞིང་དྲག་པར་འགྱུར། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱས་ཡེ་ཤུའི་གཟི་བརྗིད་མཐོང་བས་ཁོང་གི་སྐོར་དེ་ལྟར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","དེ་ཡང་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་ནང་ནས་མི་མང་པོས་ཡེ་ཤུ་ལ་དད་པ་བྱས་ཀྱང༌། ཕཱ་རུ་ཤི་པ་ཚོས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནས་འབུད་པར་འཇིགས་ཏེ་མངོན་སུམ་དུ་དེའི་སྐོར་གཏམ་མ་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","རྒྱུ་མཚན་ནི་ཁོ་ཚོ་དཀོན་མཆོག་གིས་བཀུར་སྟི་ལས་མིས་བཀུར་སྟི་ལ་ལྷག་པར་ཆགས། ");
INSERT INTO bod_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","དེ་ནས་ཡེ་ཤུས་སྐད་ཆེན་པོས་“སུས་ང་ལ་དད་པ་བྱས་ཀྱང་དེས་ང་དང་ང་མངགས་མཁན་ཏེ་དཀོན་མཆོག་ལའང་དད་པ་བྱེད་པས། ");
INSERT INTO bod_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","སུས་ང་མཐོང་ཡང་དེས་ང་མངགས་མཁན་དེའང་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ང་ལ་དད་པ་བྱེད་མཁན་ཐམས་ཅད་མུན་པའི་ནང་དུ་མི་ལུས་པའི་ཕྱིར་ང་ནི་འོད་ལྟར་འཇིག་རྟེན་དུ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","མི་སུ་ཞིག་ངའི་བཤད་པའི་བཀའ་ཐོས་ནས་མ་ཉན་ན་ངས་མི་དེ་ལ་ཁྲིམས་གཅོད་མི་བྱེད། ང་ནི་འཇིག་རྟེན་ལ་ཁྲིམས་གཅོད་བྱེད་དུ་མ་ཡོང་བར། འཇིག་རྟེན་སྐྱོབ་པའི་ཆེད་དུ་ཡོང་བ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","མི་སུ་ཞིག་གིས་ང་དོར་ནས་ངའི་བཀའ་ལ་མི་ཉན་མཁན་ལ་ཁྲིམས་གཅོད་པ་ཞིག་ཡོད། ངས་བཤད་པའི་བཀའ་དེ་ཉིད་ཀྱིས་དུས་ཀྱི་མཐའ་མའི་ཉིན་མོར་དེར་ཁྲིམས་གཅོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","རྒྱུ་མཚན་ནི་ངས་ང་རང་ཐོག་ནས་གཏམ་མ་བཤད་དེ། ང་མངགས་མཁན་ཡབ་དཀོན་མཆོག་ཉིད་ཀྱིས་ང་ལ་གང་ཞིག་ཟེར་དགོས་པ་གནད་འཁེལ་པོར་བཀའ་གནང་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ངས་ཁོང་གིས་གནང་བའི་བཀའ་དེ་དཔག་ཏུ་མེད་པའི་ཚེ་ཡིན་པ་ཤེས་པས། དེའི་ཕྱིར་ངས་གང་ཤོད་པ་དེ་ཡབ་དཀོན་མཆོག་གིས་ང་ལ་ཅི་གསུངས་པ་དེ་རང་ཡིན་ནོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","པེ་སག་གི་དུས་ཆེན་གྱི་སྔོན་ལ་ཡེ་ཤུ་འཇིག་རྟེན་འདི་ནས་ཡབ་དཀོན་མཆོག་གི་དྲུང་དུ་ཕེབས་དགོས་པའི་དུས་ལ་བབ་པར་མཁྱེན་ཏེ། རང་གི་རྗེས་འབྲང་བ་འཇིག་རྟེན་འདིར་ཡོད་པ་ཚོར་སྔར་ཡང་བྱམས་ཤིང་མཐའ་མའི་བར་དུ་ཡང་བྱམས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","བདུད་ཀྱིས་ཡེ་ཤུ་དགྲའི་དབང་དུ་གཏོང་བའི་བསམ་པ་དེ་སི་མོན་གྱི་བུ་ཡུ་དཱ་དབྱི་སི་ཀར་རེའི་སེམས་སུ་བཞག་ཚར་ནས། དགོང་ཟས་བཞེས་པའི་ཚེ་ ");
INSERT INTO bod_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ཡེ་ཤུས་ཡབ་དཀོན་མཆོག་གིས་ཁོང་ལ་དོན་ཐམས་ཅད་ཁོང་གི་ལག་ཏུ་གནང་ཡོད་པ་མཁྱེན་པ་དང༌། རང་ཉིད་དཀོན་མཆོག་ནས་ཡོང་བ་ཡིན་ཏེ་དཀོན་མཆོག་གི་དྲུང་དུ་ལོག་རྒྱུ་ཡིན་པར་མཁྱེན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","དགོང་ཟས་ཀྱི་གྲལ་ནས་བཞེངས་ཏེ་ཕྱིའི་ན་བཟའ་ཕུད་དེ་ཕྱག་རས་རྐེད་པར་དཀྲིས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","གཞོང་པའི་ནང་ཆུ་བླུགས་ནས་ཉེ་གནས་རེ་རེ་བཞིན་གྱི་རྐང་པ་བཀྲུས་པ་དང༌། རང་གི་སྐུ་ལ་དཀྲིས་པའི་ཕྱག་རས་ཀྱིས་འཕྱིས། ");
INSERT INTO bod_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ཁོང་སི་མོན་པེ་ཏྲོའི་རྩར་ཕེབས་པ་དང༌། ཁོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་ངའི་རྐང་པ་བཀྲུ་རྒྱུ་ཡིན་ནམ་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ལན་དུ་ཡེ་ཤུས་“ངས་བྱེད་བཞིན་པའི་ལས་ཀྱི་དོན་ཁྱེད་ཀྱིས་ད་ལྟ་མི་རྟོགས་ཀྱང༌། རྗེས་མ་རྟོགས་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","པེ་ཏྲོས་ཁོང་ལ་“ཁྱེད་ཀྱིས་ངའི་རྐང་པ་ཅི་ནས་ཀྱང་མི་བཀྲུ་”ཞེས་ཞུས་པ་དང་ལན་དུ་ཡེ་ཤུས་“གལ་ཏེ་ངས་ཁྱོད་མ་བཀྲུས་ན། ཁྱོད་ང་དང་འབྲེལ་བ་མེད་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","སི་མོན་པེ་ཏྲོས་“གཙོ་བོ་ལགས། ངའི་རྐང་པ་ཙམ་མ་ཟད། ལག་པ་དང་མགོ་ཡང་ཁྲུས་རོགས་མཛོད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ཡེ་ཤུས་“ཁྲུས་བྱས་ཟིན་པ་ཞིག་ལུས་ཧྲིལ་པོ་གཙང་མར་གྱུར་བ་ཡིན་པས་རྐང་པ་མ་གཏོགས་འཁྲུད་དགོས་མེད། ཁྱེད་ཚོ་ནི་གཙང་མ་ཡིན། འོན་ཀྱང་ཐམས་ཅད་གཙང་མ་མིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ཡེ་ཤུས་ཁོང་རང་དགྲའི་དབང་དུ་གཏོང་མཁན་དེ་སུ་ཡིན་པ་མཁྱེན་པས། ཁོང་གིས་“ཁྱེད་ཚོ་ཐམས་ཅད་གཙང་མ་མིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","དེ་ནས་ཡེ་ཤུས་ཉེ་གནས་རྣམས་ཀྱི་རྐང་པ་བཀྲུས་ཚར་ནས་ཕྱིའི་ན་བཟའ་བཞེས་ཏེ་སླར་བཞུགས་པ་དང་ཁོ་ཚོར་“ངས་ཁྱེད་ཚོ་ལ་བྱས་པ་དེའི་དོན་ནི་ཅི་ཡིན་རྟོགས་སམ་”ཞེས་བཀའ་འདྲི་གནང༌། ");
INSERT INTO bod_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“ཁྱོད་ཚོས་ང་ལ་སྟོན་པ་དང་གཙོ་བོ་ཞེས་ཟེར་བ་བདེན་པ་ཡིན་ཏེ། ང་ནི་དེ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","དེའི་ཕྱིར་ང་ཁྱེད་ཀྱི་གཙོ་བོ་དང་སྟོན་པ་ཡིན་ཏེ་ཁྱེད་ཚོའི་རྐང་པ་བཀྲུས་པ་ཡིན་ན། ཁྱེད་ཚོས་ཀྱང་གཅིག་གིས་གཅིག་ལ་རྐང་པ་འཁྲུད་དགོས། ");
INSERT INTO bod_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ངས་ཁྱེད་ཚོ་ལ་མིག་དཔེ་ཞིག་བསྟན་ཅིང༌། ཁྱེད་ཚོས་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་བྱས་པ་བཞིན་དུ་བྱེད་དགོས། ");
INSERT INTO bod_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། གཡོག་པོ་ནི་དཔོན་པོ་ལས་གལ་ཆེ་བ་མ་ཡིན་ཞིང་བང་ཆེན་དེའང་མངགས་མཁན་ལས་ཆེ་བ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","གལ་ཏེ་ཁྱེད་ཚོས་དོན་དེ་རྣམས་ཤེས་ཏེ་དེ་ལྟར་བྱས་ན་བདེ་བ་དང་ལྡན་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ངའི་གཏམ་འདི་ཁྱེད་ཚོ་ཚང་མའི་སྐོར་བཤད་པ་མིན། ངས་བདམས་པའི་མི་རྣམས་ངས་ཤེས། འོན་ཀྱང་འདི་ནི་དཀོན་མཆོག་གི་གསུང་རབ་ཀྱི་མདོ་ལས། ངའི་བག་ལེབ་ཟ་མཁན་དེས་རྐང་པའི་རྟིང་པས་ང་བརྫིས་པ་ཡིན། ཞེས་གསུངས་པ་བཞིན་དུ་སྒྲུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ད་དེ་བཞིན་དུ་མ་འགྲུབ་པའི་སྔོན་ལ་ངས་ཁྱེད་ཚོར་སྨྲ། དེའི་ཕྱིར་དེ་བཞིན་དུ་འགྲུབ་པའི་ཚེ་ཁྱེད་ཚོས་ང་ཁོང་ཉིད་ཡིན་པར་དད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། སུས་ཀྱང་ངས་མངགས་པའི་མི་ཞིག་བསུས་ན་མི་དེ་ངའང་བསུ། ང་རང་བསུ་བའི་མི་དེས་ང་མངག་མཁན་ཡང་བསུ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ཡེ་ཤུས་དེ་གསུངས་ཏེ་ཐུགས་འཁྲུགས་པར་གྱུར་ནས་“ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཚོའི་ནང་ནས་གཅིག་གིས་ང་རྒྱབ་གཏོད་བྱེད་ཡོང་”ཞེས་གསལ་བསྒྲགས་མཛད་པས། ");
INSERT INTO bod_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་གིས་གསུངས་པའི་མི་སུ་ཡིན་མི་ཤེས་པར་གཅིག་གིས་གཅིག་ལ་བལྟས། ");
INSERT INTO bod_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","དེར་ཡེ་ཤུས་བྱམས་པར་འཛིན་པའི་ཉེ་གནས་གཅིག་ཁོང་གི་སྐུ་འགྲམ་ལ་ཡོད་པས། ");
INSERT INTO bod_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","སི་མོན་པེ་ཏྲོས་མི་དེར་མགོ་བོ་གཡུག་བཞིན་བརྡ་བཏང་སྟེ་“ཁོང་གིས་སུའི་སྐོར་ལ་གསུངས་པ་བཀའ་དྲིས་ཞུས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ཉེ་གནས་དེས་ཡེ་ཤུའི་རྩར་གཟུགས་པོ་ཡོ་ནས་ཁོང་ལ་“གཙོ་བོ་ལགས། མི་དེ་སུ་ཡིན་”ཞེས་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ཡེ་ཤུས་“ངས་བག་ལེབ་དུམ་བུ་འདི་ཁུ་བ་ལ་སྦངས་ནས་སྟེར་བའི་མི་དེ་རང་ཡིན་”ཞེས་གསུངས་ནས་ཁོང་གིས་བག་ལེབ་དུམ་བུ་དེ་ཁུ་བར་སྦངས་རྗེས། སི་མོན་དབྱི་སི་ཀར་རེའི་བུ་ཡུ་དཱ་ལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","བག་ལེབ་དུམ་བུ་དེ་བླངས་ནས་བདུད་སཱ་ཏན་ཁོའི་སེམས་ནང་དུ་ཞུགས། ཡེ་ཤུས་ཡུ་དཱ་ལ་“ཁྱོད་ཀྱིས་བྱེད་རྒྱུ་ཡིན་པ་དེ་མགྱོགས་པོར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","དེར་ཡོད་པ་རྣམས་ཀྱི་ནང་ནས་སུས་ཀྱང་ཅིའི་ཕྱིར་དེ་ལྟར་གསུངས་པའི་དོན་ཧ་མ་གོ ");
INSERT INTO bod_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ཡུ་དཱ་ལ་སྤྱི་ཐོག་གི་དངུལ་ཁུག་ཡོད་པས་ཉེ་གནས་རྣམས་ཀྱི་ནང་ནས་ལ་ལས་ཡེ་ཤུས་ཁོ་ལ་དུས་ཆེན་ལ་གང་དགོས་པ་ཉོ་རྒྱུ་འམ་ཡང་ན་དབུལ་པོ་རྣམས་ལ་གང་ཞིག་སྦྱིན་པར་བཀའ་གནང་ངོ་ཞེས་བསམས། ");
INSERT INTO bod_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ཡུ་དཱས་བག་ལེབ་དེ་བླངས་མ་ཐག་ཕྱི་རོལ་ཏུ་སོང༌། དུས་དེ་ནི་མཚན་མོ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ཡུ་དཱ་སོང་བའི་རྗེས་སུ་ཡེ་ཤུས་“ད་མིའི་རིགས་ཀྱི་བུ་ཡི་གཟི་བརྗིད་མངོན་པར་འགྱུར་ཞིང་དཀོན་མཆོག་ཀྱང་ཁོང་བརྒྱུད་ནས་གཟི་བརྗིད་དང་ལྡན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","དཀོན་མཆོག་གི་གཟི་བརྗིད་ཁོང་བརྒྱུད་ནས་མངོན་པར་གྱུར་ན། དཀོན་མཆོག་གིས་རང་བརྒྱུད་ནས་མིའི་རིགས་ཀྱི་བུའི་གཟི་བརྗིད་མྱུར་དུ་མངོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ཕྲུ་གུ་རྣམས། ང་ད་དུང་ཁྱོད་ཚོ་དང་མཉམ་དུ་དུས་ཐུང་ངུ་ཞིག་ཡོད། ཁྱོད་ཚོས་ང་བཙལ་ཡང༌། སྔར་ངས་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་བཤད་པ་བཞིན་དུ་ད་ཁྱོད་ཚོར་ཡང་ཟེར་རྒྱུར། ང་གང་དུ་འགྲོ་བའི་གནས་སུ་ཁྱོད་ཚོ་ཡོང་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ངས་ཁྱོད་རྣམས་ལ་བཀའ་གསར་པ་ཞིག་སྦྱིན། དེ་ནི་ཁྱོད་ཚོས་ཕན་ཚུན་བྱམས་པོ་བྱོས་ཤིག ངས་ཁྱོད་རྣམས་ལ་བྱམས་པ་ལྟར་ཁྱོད་རྣམས་ཀྱང་གཅིག་གིས་གཅིག་ལ་བྱམས་པར་ཟུངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ཁྱོད་རྣམས་གཅིག་གིས་གཅིག་ལ་བྱམས་པར་བཟུང་ན་མི་ཐམས་ཅད་ཀྱིས་ཁྱོད་ངའི་ཉེ་གནས་ཡིན་པ་ཤེས་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","སི་མོན་པེ་ཏྲོས་“གཙོ་བོ་ལགས། ཁྱེད་གང་དུ་ཕེབས་ཀྱི་ཡིན་”ཞེས་ཟེར་བ་དང་ལན་དུ་ཡེ་ཤུས་“ང་གང་དུ་འགྲོ་བའི་གནས་སུ་ཁྱོད་ད་ལྟ་ངའི་རྗེས་སུ་འབྲང་མི་ཐུབ་ཀྱང༌། རྗེས་མ་འབྲང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","པེ་ཏྲོས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཅིའི་ཕྱིར་ང་ད་ལྟ་ཁྱེད་ཀྱི་རྗེས་སུ་འབྲང་བར་མི་ཐུབ། ཁྱེད་ཀྱི་དོན་དུ་ངའི་རང་སྲོག་བློས་གཏོང་བའི་སེམས་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ཡེ་ཤུས་“ཁྱོད་ཀྱིས་ངའི་དོན་དུ་སྲོག་བློས་གཏོང་བའི་སེམས་དངོས་གནས་ཡོད་དམ། ངས་ཁྱོད་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱོད་ཀྱིས་བྱ་ཕོས་སྐད་མ་རྒྱག་པའི་སྔོན་ལ་ང་རང་སུ་ཡིན་མི་ཤེས་ཞེས་ལན་གསུམ་བཤད་པར་འགྱུར་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ཡེ་ཤུས་ཉེ་གནས་རྣམས་ལ་“ཁྱེད་ཚོའི་སེམས་འཁྲུག་པར་མ་འགྱུར། དཀོན་མཆོག་ལ་དད་པ་བྱོས་ལ་ང་ལ་ཡང་དད་པ་བྱོས། ");
INSERT INTO bod_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ངའི་ཡབ་ཀྱི་ཕོ་བྲང་ལ་གནས་ཁང་མང་པོ་ཡོད། དེ་ལྟར་མ་ཡིན་ན་ངས་ཁྱེད་རྣམས་ལ་སྔ་མ་ནས་བཤད་ཡོད། ང་ཁྱེད་ཚོའི་དོན་དུ་གནས་གྲ་སྒྲིག་བྱེད་དུ་འགྲོ ");
INSERT INTO bod_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ང་སོང་ནས་ཁྱེད་ཚོའི་དོན་དུ་གནས་གྲ་སྒྲིག་བྱས་རྗེས། ང་ཕྱིར་ལོག་སྟེ་ཁྱེད་ཚོ་ངའི་རྩར་འདྲེན་པར་བྱ། དེ་ནས་ང་རང་གང་དུ་ཡོད་པ་དེར་ཁྱེད་ཚོའང་ཡོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ང་རང་འགྲོ་རྒྱུ་ཡིན་པའི་ལམ་དེ་ཁྱེད་ཚོས་ཤེས་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ཐོ་མཱས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁྱེད་རང་གང་དུ་ཕེབས་པ་ང་ཚོས་མི་ཤེས་ཏེ་ལམ་དེ་ཇི་ལྟར་ཤེས་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ལན་དུ་ཡེ་ཤུས་“ང་ནི་ལམ་དང༌། བདེན་པ་ཉིད། དཔག་ཏུ་མེད་པའི་ཚེའང་ཡིན། ང་མ་བརྒྱུད་པར་སུ་ཡང་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་བའི་ལམ་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ཁྱེད་ཚོས་ང་ངོ་ཤེས་ཡོད་ན། ངའི་ཡབ་ཀྱང་ངོ་ཤེས་ཡོད། ད་ནས་བཟུང་ཁྱེད་ཚོས་ཁོང་ངོ་ཤེས་པ་དང་མཐོང་མྱོང་ཡོད་དོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ཕི་ལིབ་ཀྱིས་“གཙོ་བོ་ལགས། ཡབ་དེ་ང་ཚོ་ལ་སྟོན་པར་མཛོད་དང༌། ཚིམ་པར་འགྱུར་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ཡེ་ཤུས་“ཕི་ལིབ། ང་རང་ཁྱོད་ཚོ་དང་མཉམ་དུ་ཡུན་རིང་པོར་བསྡད་ཀྱང༌། ཁྱོད་ཀྱིས་ད་དུང་ང་སུ་ཡིན་པ་མི་ཤེས་སམ། ང་མཐོང་མཁན་དེས་ཡབ་མཐོང་བས། ཁྱོད་ཀྱིས་ཅིའི་ཕྱིར་ཡབ་དེ་ང་ཚོ་ལ་སྟོན་པར་མཛོད་ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ཁྱོད་ཀྱིས་ང་ཡབ་ཀྱི་ནང་ན་ཡོད་པ་དང་ཡབ་ངའི་ནང་ན་ཡོད་པར་དད་པ་མི་བྱེད་དམ། ངས་ཁྱོད་ཚོར་བཤད་པའི་གཏམ་དེ་རྣམས་ང་རང་རང་ཐོག་ནས་མ་བཤད་དེ། ཡབ་ངའི་ནང་དུ་གནས་པ་དེས་རང་གི་ལས་རྣམས་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ང་ཡབ་ཀྱི་ནང་ན་ཡོད་པ་དང་ཡབ་ངའི་ནང་ན་ཡོད་པར་ཡིད་ཆེས་ཤིག དེ་མ་བྱས་ནའང་ངས་བྱས་པའི་འཕྲིན་ལས་ཉིད་ཀྱི་ཕྱིར་ཡིད་ཆེས་བྱོས། ");
INSERT INTO bod_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ང་ལ་དད་པ་བྱེད་མཁན་དེས་ངས་གང་བྱས་པ་བཞིན་དུ་བྱེད་པ་མ་ཟད། དེ་ལས་ཆེ་བའི་འཕྲིན་ལས་ཀྱང་བྱེད་པར་འགྱུར། ཅི་ལགས་ཟེར་ན། ང་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ཡང་ཡབ་ཀྱི་གཟི་བརྗིད་ནི་སྲས་བརྒྱུད་ནས་མངོན་པར་འགྱུར་བའི་ཕྱིར། ཁྱེད་ཚོས་ངའི་མིང་ལ་བརྟེན་ནས་གང་ཞིག་ཞུས་ཀྱང་ངས་དེ་བཞིན་དུ་སྒྲུབ་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ཁྱེད་ཚོས་ངའི་མིང་ཐོག་ནས་དོན་གང་ཞིག་ཞུས་ནའང་ངས་དེ་ལྟར་བྱ།” ");
INSERT INTO bod_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“གལ་ཏེ་ཁྱེད་ཚོས་ང་ལ་བྱམས་པར་བཟུང་ན་ངའི་བཀའ་རྣམས་སྲུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ངས་ཡབ་ལ་ཞུས་པ་དང་ཁོང་གིས་ཁྱེད་ཚོར་རོགས་པ་གནང་མཁན་གཞན་པ་ཞིག་གནང་བར་འགྱུར། ཁོང་ནི་དུས་རྒྱུན་དུ་ཁྱེད་ཚོ་དང་མཉམ་དུ་གནས་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ཁོང་ནི་དཀོན་མཆོག་གི་བདེན་པ་མངོན་པར་མཛད་མཁན་ཡིན་པའི་ཐུགས་ཉིད་ཡིན། དད་པ་མེད་པ་རྣམས་ཀྱི་སེམས་ནང་ཁོང་བསུ་བར་མི་སྲིད། ཅི་ལགས་ཟེར་ན། ཁོ་ཚོས་ཁོང་མི་མཐོང་ཞིང་ངོ་མི་ཤེས། འོན་ཀྱང་ཁོང་ནི་ཁྱེད་ཚོའི་སེམས་ནང་ཡོད་པ་དང་དེར་གནས་རྒྱུ་ཡིན་པས་ཁྱེད་ཚོས་ཁོང་ངོ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ངས་ཁྱེད་ཚོ་དྭ་ཕྲུག་ལྟར་མི་འཇོག་པར་ཁྱེད་ཚོའི་རྩར་ཕྱིར་ལོག་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ད་དུང་ཅུང་ཟད་ཅིག་སོང་ནས་འཇིག་རྟེན་གྱི་མི་ཚོས་ང་མི་མཐོང༌། འོན་ཀྱང་ཁྱོད་ཚོས་ང་མཐོང་བར་འགྱུར། གང་ལགས་ཟེར་ན། ང་ཤི་ནས་ཡང་བསྐྱར་འཚོ་བས་ཁྱེད་ཚོའང་འཚོ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","དེའི་ཉིན་མོར་ཁྱེད་ཚོས་ང་ཡབ་ཀྱི་ནང་ན་ཡོད་པ་དང༌། ཁྱེད་ཚོ་ངའི་ནང་ན་ཡོད་པ་དང༌། ང་ཁྱེད་རྣམས་ཀྱི་ནང་དུ་ཡོད་པར་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ངའི་བཀའ་རྣམས་ཤེས་ཏེ་སྲུང་བ་དེ་ནི་ང་ལ་བྱམས་པར་འཛིན་མཁན་ཡིན། ཡང་ང་ལ་བྱམས་པར་འཛིན་མཁན་དེ་ནི་ངའི་ཡབ་ཀྱིས་ཀྱང་བྱམས་པར་འཛིན་པར་འགྱུར། ངས་ཀྱང་མི་དེར་བྱམས་པར་འཛིན་ཏེ། ང་རང་ཁོ་ལ་མངོན་པར་བྱའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","དེར་ཡུ་དཱ་དབྱི་སི་ཀར་རེ་མ་ཡིན་པའི་ཡུ་དཱ་ཡིས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་ཁྱེད་རང་འཇིག་རྟེན་གྱི་མི་ཚོར་མངོན་དུ་མི་མཛད་པར་ང་ཚོར་མངོན་དུ་མཛད་པ་དེ་ཅི་ལ་སྲིད་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ལན་དུ་ཡེ་ཤུས་“ང་ལ་བྱམས་པར་འཛིན་མཁན་གྱིས་ངའི་བཀའ་ལ་སྲུང་སྟེ། ངའི་ཡབ་ཀྱིས་མི་དེར་བྱམས་པར་མཛད་རྒྱུ་ཡིན་པས། ང་དང་ངའི་ཡབ་ཁོའི་རྩར་ཕེབས་ནས་ཁོ་དང་མཉམ་དུ་གནས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ཡང་ང་ལ་བྱམས་པར་མི་འཛིན་མཁན་གྱིས་ངའི་བཀའ་ལ་མི་ཉན། ཁྱེད་ཚོས་ཐོས་པའི་བཀའ་དེ་ང་རང་ནས་མ་ཡིན་པར། ང་མངགས་མཁན་ཏེ་ཡབ་དཀོན་མཆོག་ནས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ང་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཡོད་དུས་གཏམ་དེ་བཤད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ངའི་ཡབ་ཀྱིས་ངའི་མིང་ཐོག་ནས་མངག་རྒྱུ་ཡིན་ཞིང་རོགས་པ་གནང་མཁན་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྱེད་ཚོར་དོན་ཐམས་ཅད་བསླབ་ཅིང་ངས་བཤད་པ་ཐམས་ཅད་དྲན་སྐུལ་གནང་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ངས་ཁྱེད་ཚོ་ཞི་བདེ་གནས་པར་བྱེད། ངའི་ཞི་བདེ་ཁྱེད་ཚོར་སྦྱིན། ངས་ཞི་བདེ་སྦྱིན་ཚུལ་ནི་འཇིག་རྟེན་གྱིས་ཞི་བདེ་སྟེར་ཚུལ་དང་མི་འདྲ་བས། ཁྱེད་ཚོའི་སེམས་མ་འཁྲུགས་ཤིང་མ་འཇིགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ངས་ཁྱེད་ཚོར་ང་འགྲོ་ན་ཡང་ཁྱེད་ཚོའི་རྩར་ཕྱིར་ལོག་ངེས་ཡིན་ཞེས་བཤད་པ་ཁྱེད་ཀྱིས་ཐོས། ཁྱེད་ཚོས་ང་ལ་བརྩེ་དུང་ཡོད་ན། ང་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་བར་སེམས་དགའ་བར་འགྱུར་བ་ཡིན། ཅི་ལགས་ཟེར་ན། ང་ལས་ཡབ་རླབས་ཆེ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ད་དེ་བཞིན་དུ་མ་བྱུང་བའི་སྔོན་ལ་ཁྱེད་ཚོར་བཤད་པ་ཡིན། དེའི་ཕྱིར་དེ་བཞིན་དུ་འབྱུང་བའི་ཚེ་ཁྱེད་ཚོས་དད་པ་བྱེད་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ད་ཕྱིན་ཆད་ངས་ཁྱེད་ཚོ་ལ་གཏམ་མང་པོ་མི་བྱེད། འཇིག་རྟེན་འདིའི་དབང་སྒྱུར་མཁན་ཡོང་བཞིན་པ་དང་ངའི་ཐོག་ཁོ་ལ་དབང་ཅི་ཡང་མེད། ");
INSERT INTO bod_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","འོན་ཀྱང་འཇིག་རྟེན་གྱིས་ངས་ཡབ་ལ་བྱམས་པ་ཤེས་པའི་ཕྱིར། ངས་ཡབ་ཀྱིས་ང་ལ་བཀའ་གནང་བ་ཇི་བཞིན་སྒྲུབ། ད་ལོངས་ལ་ང་ཚོ་འདི་ནས་ཕར་འགྲོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","དེ་ནས་ཡེ་ཤུས་ཉེ་གནས་ཚོར་“ང་ནི་བདེན་པའི་རྒུན་འབྲུམ་ཤིང་ཡིན་ཞིང༌། ངའི་ཡབ་ནི་རྒུན་ཤིང་ལྡུམ་ར་གསོ་སྐྱོང་གནང་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ཁོང་གིས་ངའི་ནང་ན་འབྲས་བུ་མ་སྐྱེས་པའི་ཡལ་ག་རེ་བཅད་ནས་དབྱུག་ཅིང༌། ངའི་ནང་ན་འབྲས་བུ་སྐྱེས་པའི་ཡལ་ག་རེ་རེར་འབྲས་བུ་འཕེལ་བའི་ཕྱིར་དེ་ཤིང་བཅོས་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ངས་ཁྱེད་ཚོར་བཤད་པའི་བཀའ་དེས་ཁྱེད་ཚོ་དག་པར་བྱས་ཟིན། ");
INSERT INTO bod_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ང་ཁྱེད་རྣམས་ཀྱི་ནང་ན་གནས་པ་ལྟར་ཁྱེད་རྣམས་ངའི་ནང་ན་གནས་ཤིག ཡལ་ག་ནི་རྒུན་འབྲུམ་ཤིང་ལ་མི་གནས་ན་རང་བཞིན་གྱིས་འབྲས་བུ་མི་སྐྱེ་བ་ལྟར། ཁྱེད་ཚོའང་ངའི་ནང་དུ་མི་གནས་ན་འབྲས་བུ་ཆགས་པར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ང་ནི་རྒུན་འབྲུམ་ཤིང་ཡིན་ཏེ་ཁྱེད་ཚོ་ཡལ་ག་ཡིན། སུ་ཡང་ངའི་ནང་དུ་གནས་ཏེ་ང་ཡང་ཁོའི་ནང་དུ་གནས་ན། དེ་ལ་འབྲས་བུ་མང་པོ་སྐྱེ། ང་དང་བྲལ་ན་ཁྱེད་ཚོས་ཅི་ཡང་བྱེད་མི་ཐུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ངའི་ནང་ན་མི་གནས་པ་དེ་ནི་ཕྱི་རུ་འཕངས་པའི་ཡལ་ག་ལྟར་སྐམ་པོར་འགྱུར། ཡལ་ག་དེ་ཚོ་བསྡུས་ནས་མེ་ལ་བཏབ་སྟེ་འཚིག ");
INSERT INTO bod_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","གལ་ཏེ་ཁྱེད་ཚོ་ངའི་ནང་ན་གནས་པ་དང༌། ངས་བཤད་པའི་བཀའ་ཡང་ཁྱེད་ཀྱི་ནང་དུ་གནས་ན། ཁྱེད་ཀྱིས་གང་འདོད་པ་དེ་ཞུས་ནས་འགྲུབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ཁྱེད་ཚོར་འབྲས་བུ་མང་པོ་སྐྱེས་ན་ཁྱེད་ནི་ངའི་ཉེ་གནས་དངོས་ཡིན་པ་དང༌། དེའི་སྒོ་ནས་ངའི་ཡབ་ཀྱི་གཟི་བརྗིད་མངོན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ཡབ་ཀྱིས་ང་ལ་བྱམས་པར་མཛད་པ་ལྟར་ངས་ཀྱང་ཁྱེད་ཚོ་ལ་བྱམས་པར་བྱས། ཁྱེད་ཚོ་ངའི་བྱམས་པའི་ནང་གནས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ངས་ཡབ་ཀྱི་བཀའ་རྣམས་བསྲུངས་ཡོད་པ་དང༌། ཁོང་གི་བྱམས་པའི་ནང་གནས་པ་ལྟར། ཁྱེད་ཀྱིས་ཀྱང་ངའི་བཀའ་རྣམས་བསྲུངས་ན་ངའི་བྱམས་པའི་ནང་གནས་པར་འགྱུར།” ");
INSERT INTO bod_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ངས་ཁྱེད་ཚོ་ལ་བཤད་པ་འདི་རྣམས་ནི་ངའི་དགའ་སྤྲོ་ཁྱེད་ཚོའི་སེམས་ལ་གནས་པ་དང་ཁྱེད་ཀྱི་དགའ་སྤྲོ་ཁེངས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ངས་ཁྱེད་ཚོ་ལ་བྱམས་པ་བྱས་པ་ལྟར། ཁྱེད་ཚོས་ཀྱང་ཕན་ཚུན་བྱམས་པར་གྱིས་ཤིག་ཅེས་པ་དེ་ནི་ངའི་བཀའ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","མི་ཞིག་གིས་རང་གི་གྲོགས་པོའི་དོན་དུ་རང་སྲོག་བཏང་ན་དེ་ནི་བྱམས་པ་རབ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ཡང་ཁྱེད་ཚོས་ངའི་བཀའ་བཞིན་དུ་བསྒྲུབས་ན་ངའི་གྲོགས་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ད་ནས་བཟུང་ངས་ཁྱེད་ཚོ་ལ་གཡོག་པོ་ཞེས་མི་ཟེར། རྒྱུ་མཚན་ནི་དཔོན་པོས་ཅི་བྱེད་པ་གཡོག་པོས་མི་ཤེས། ངས་ཡབ་ལས་གང་ཐོས་པ་ཐམས་ཅད་ཁྱེད་ཚོ་ལ་བཤད་པས་ཁྱེད་ཚོ་ལ་གྲོགས་པོ་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ཁྱེད་ཚོས་ང་མ་བདམས། ངས་ཁྱེད་ཚོ་བདམས་ཏེ་བསྐོས་པ་ཡིན་པས། ཁྱེད་ཚོ་སོང་ནས་འབྲས་བུ་སྐྱེ་བ་སྟེ། འབྲས་བུ་དེ་རྟག་ཏུ་གནས་པའི་ཕྱིར་རོ། དེ་ནས་ངའི་མིང་ཐོག་ནས་ཡབ་ལ་གང་ཞུས་པ་དེ་ཁྱེད་ཚོ་ལ་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ཁྱེད་ཚོས་ཕན་ཚུན་བྱམས་པར་གྱིས་ཤིག འདི་ནི་ངའི་བཀའ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ཡང་ཡེ་ཤུས་“གལ་ཏེ་འཇིག་རྟེན་གྱི་མི་ཚོས་ཁྱེད་ཚོ་ལ་སྡང་ན། ཁྱེད་ཚོའི་སྔོན་དུ་ང་ལ་སྡང་བ་ཡིན་པ་ཤེས་དགོས། ");
INSERT INTO bod_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","གལ་ཏེ་ཁྱེད་ཚོ་འཇིག་རྟེན་ལ་གཏོགས་ན། འཇིག་རྟེན་གྱིས་རང་གི་ཡིན་པ་དེ་ལ་གཅེས། འོན་ཀྱང་ངས་ཁྱེད་ཚོ་འཇིག་རྟེན་གྱི་ནང་ནས་བདམས་པས། ཁྱེད་ཚོ་འཇིག་རྟེན་འདིར་མ་གཏོགས། དེའི་ཕྱིར་འཇིག་རྟེན་གྱིས་ཁྱེད་ཚོ་ལ་སྡང༌། ");
INSERT INTO bod_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","སྔར་ངས་ཁྱེད་ཚོར་གཡོག་པོ་ནི་དཔོན་པོ་ལས་གལ་ཆེ་བ་མ་ཡིན་ཞེས་བཤད་པ་དེ་དྲན་པར་གྱིས་ཤིག གལ་སྲིད་ཁོ་ཚོས་ང་ལ་གནོད་འཚེ་བྱས་ན། ཁྱེད་ཚོ་ལ་ཡང་གནོད་འཚེ་བྱེད་པར་འགྱུར། ངས་བཤད་པའི་བཀའ་བསྲུངས་པ་ཡིན་ན། ཁྱེད་ཚོའི་གཏམ་ཡང་བསྲུང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ཁོ་ཚོས་ང་མངགས་མཁན་དེ་ངོ་མི་ཤེས་པས། ཁྱེད་ཚོ་ང་ལ་གཏོགས་པའི་རྐྱེན་གྱིས་ཁྱེད་ཚོ་ལ་དེ་ཐམས་ཅད་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","གལ་ཏེ་ང་ཡོང་ནས་ཁོ་ཚོ་ལ་མ་བཤད་པ་ཡིན་ན་ཁོ་ཚོར་སྡིག་ཉེས་མེད་པ་ཡིན། འོན་ཀྱང་ད་ལྟ་ཁོ་ཚོས་ང་ཚོས་སྡིག་ཉེས་མ་བྱས་ཞེས་ཟེར་བའི་རྒྱུ་མཚན་མེད། ");
INSERT INTO bod_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","སུས་ཀྱང་ང་ལ་སྡང་ན་དེས་ངའི་ཡབ་ལ་ཡང་སྡང༌། ");
INSERT INTO bod_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","གལ་ཏེ་ངས་གཞན་སུ་ཞིག་ཀྱང་གཏན་ནས་མ་བྱས་པའི་འཕྲིན་ལས་ཁོ་ཚོའི་མདུན་དུ་མ་བྱས་པ་ཡིན་ན། ཁོ་ཚོ་ལ་སྡིག་ཉེས་མེད། འོན་ཀྱང་ད་ལྟ་ཁོ་ཚོ་ངས་གང་བྱས་པ་དེ་མཐོང་མྱོང་ཡང་ཁོ་ཚོས་ང་དང་ངའི་ཡབ་གཉིས་ལ་སྡང༌། ");
INSERT INTO bod_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","འོན་ཀྱང་དེ་ནི་གསུང་རབ་ནང་ཁོ་ཚོས་དོན་མེད་དུ་ང་རང་ལ་སྡང་ཞེས་པའི་བཀའ་དེ་འགྲུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ངས་ཁྱེད་ཚོ་ལ་ཡབ་ཀྱི་དྲུང་ནས་རོགས་པ་གནང་མཁན་ཟེར་བ་གཏོང་བར་བྱ། ཁོང་ནི་ཡབ་ནས་འབྱུང་བའི་དཀོན་མཆོག་གི་བདེན་པ་མངོན་པར་མཛད་མཁན་ཏེ་དམ་པའི་ཐུགས་ཉིད་ཡིན། ཁོང་གིས་ངའི་སྐོར་ལ་དཔང་པོ་མཛད་པར་འགྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ཁྱེད་ཚོའང་ཐོག་མ་ནས་ང་དང་མཉམ་དུ་ཡོད་པ་ཡིན་པས། ངའི་སྐོར་ལ་དཔང་པོ་བྱེད་པར་འགྱུར་རོ་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ཡང་ཡེ་ཤུས་“དོན་དེ་ཐམས་ཅད་ངས་ཁྱེད་ཚོའི་དད་པ་མི་ཉམས་པའི་ཕྱིར་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ཁོ་ཚོས་ཁྱེད་རྣམས་འདུ་ཁང་ནས་འབུད་པ་མ་ཟད། སུས་ཁྱེད་ཚོ་གསོད་པ་དེ་ཚོས་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་གྱི་ལས་བྱེད་པར་བསམ་པའི་དུས་ལ་འབབ་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ཁོ་ཚོས་ངའི་ཡབ་ཀྱང་ངོ་མ་ཤེས། ང་ཡང་ངོ་མ་ཤེས་པས། ཁྱེད་ཚོ་ལ་དོན་དེ་བཞིན་དུ་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","དུས་ལ་འབབ་པའི་ཚེ་ཁྱེད་ཚོས་དོན་དེ་ཚོ་དྲན་པའི་ཕྱིར་ངས་ཁྱེད་ཚོ་ལ་བཤད་པ་ཡིན། ཐོག་མ་ནས་ངས་ཁྱེད་ཚོ་ལ་གཏམ་དེ་མ་བཤད་པ་དེ་ནི་ང་ཁྱེད་ཚོ་དང་མཉམ་དུ་ཡོད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ད་ང་ནི་ང་མངགས་མཁན་གྱི་དྲུང་དུ་འགྲོ་ན་ཡང༌། ཁྱེད་ཚོ་སུས་ཀྱང་ང་ལ་གང་དུ་འགྲོ་ཞེས་མི་འདྲི། ");
INSERT INTO bod_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ངས་དོན་འདི་ཚོ་བཤད་པས་ཁྱེད་ཚོའི་སེམས་མྱ་ངན་གྱིས་གདུངས། ");
INSERT INTO bod_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","འོན་ཀྱང་ངས་ཁྱེད་ཚོ་ལ་བདེན་པར་ཟེར་རྒྱུར། ང་ཕར་འགྲོ་བ་དེ་ཁྱེད་ཚོ་ལ་ཕན་པའི་ཕྱིར་ཡིན། གང་ཡིན་ཞེ་ན། གལ་ཏེ་ང་ཕར་མ་སོང་ན། རོགས་པ་གནང་མཁན་ཞེས་པ་དེ་ཁྱེད་ཚོའི་རྩར་མི་ཕེབས། འོན་ཀྱང་ང་སོང་ན་ཁོང་ངས་ཁྱེད་ཚོའི་རྩར་གཏོང་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ཡང་ཁོང་ཕེབས་སྐབས་སྡིག་པ་དང༌། དྲང་བདེན་དང༌། ཁྲིམས་གཅོད་པ་གསུམ་གྱི་སྐོར་ལ་འཇིག་རྟེན་གྱི་མི་ཚོའི་འཛིན་པའི་སྐྱོན་རྣམས་གསལ་སྟོན་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","སྡིག་པ་ནི། མི་དེ་ཚོས་ང་ལ་དད་པ་མི་བྱེད་པའི་དོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","དྲང་བདེན་ནི། ང་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་བས་ད་ཕྱིན་ཆད་ཁྱེད་ཚོས་ང་མི་མཐོང་བའི་དོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ཁྲིམས་གཅོད་པ་ནི། འཇིག་རྟེན་འདིའི་དབང་སྒྱུར་མཁན་ལ་ཁྲིམས་གཅོད་ཚར་བས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ང་ལ་ད་དུང་གཏམ་བཤད་རྒྱུ་མང་པོ་ཡོད་ཀྱང༌། ད་ཁྱེད་ཚོ་བཟོད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","འོན་ཀྱང་དཀོན་མཆོག་གི་བདེན་པ་མངོན་པར་མཛད་མཁན་ཏེ་དམ་པའི་ཐུགས་ཉིད་འབྱོན་པའི་ཚེ། ཁོང་གིས་ཁྱེད་ཚོ་དཀོན་མཆོག་གི་བདེན་པ་ཚང་མའི་ནང་དུ་འཁྲིད་པར་འགྱུར། ཁོང་གིས་རང་ཐོག་ནས་མི་གསུང་སྟེ། ཁོང་གིས་གང་གསན་པ་དེ་གསུང་བར་འགྱུར། ཡང་མ་འོངས་པའི་དོན་རྣམས་ཁྱེད་ཚོ་ལ་གསུང་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ཁོང་གིས་ངའི་གཟི་བརྗིད་མངོན་པར་མཛད་པར་འགྱུར་ཏེ། ངའི་གང་ཡིན་པ་རྣམས་བླངས་ནས་ཁྱེད་ཚོར་སྟོན་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ཡབ་ལ་ཡོད་པ་ཐམས་ཅད་ང་རང་གི་ཡིན། དེའི་ཕྱིར་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ང་རང་གང་ཡིན་པ་ནས་བཞེས་ཏེ་ཁྱེད་ཚོ་ལ་སྟོན་པར་འགྱུར་ཞེས་ངས་བཤད་དོ། ");
INSERT INTO bod_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ད་དུང་ཅུང་ཟད་ཅིག་ནས་ཁྱེད་ཚོས་ང་མི་མཐོང་བར་འགྱུར། དེ་ནས་ཡང་རིང་པོར་མ་ལོན་པར་ང་མཐོང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ཉེ་གནས་ཚོའི་ནང་ནས་ཁ་ཤས་གཅིག་གིས་གཅིག་ལ་“ཁོང་གིས་ད་དུང་ཅུང་ཟད་ཅིག་ནས་ཁྱེད་ཚོས་ང་མི་མཐོང་བར་འགྱུར། དེ་ནས་ཡང་རིང་པོར་མ་ལོན་པར་ང་མཐོང་བར་འགྱུར་ཞེས་དང༌། ང་ནི་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་བའི་ཕྱིར་རོ་ཞེས་གསུངས་པའི་དོན་དེ་ཅི་ཡིན་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ཡང་ཁོ་ཚོས་“ཁོང་གིས་ད་དུང་ཅུང་ཟད་ཅིག་ཅེས་གསུང་བ་དེ་ཅི་ཡིན། ཁོང་གིས་གང་གསུངས་པ་དེའི་དོན་ཧ་མི་གོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ཡེ་ཤུས་ཉེ་གནས་ཚོས་ཁོང་རང་ལ་བཀའ་འདྲི་ཞུ་འདོད་པ་མཁྱེན་ཏེ་“ངས་ཁྱེད་ཚོ་ལ་ད་དུང་ཅུང་ཟད་ཅིག་ནས་ཁྱེད་ཚོས་ང་མི་མཐོང་བར་འགྱུར། དེ་ནས་ཡང་རིང་པོར་མ་ལོན་པར་ང་མཐོང་བར་འགྱུར་ཞེས་པའི་དོན་ཁྱེད་ཚོས་ཕན་ཚུན་ལ་གྲོས་སམ། ");
INSERT INTO bod_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ངས་ཁྱེད་ཚོ་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཚོ་ངུ་ཞིང་མྱ་ངན་བྱེད་ཀྱང་འཇིག་རྟེན་གྱི་མི་ཚོ་དགའ་བར་འགྱུར། ཁྱེད་ཚོར་སྡུག་བསྔལ་འབྱུང་ཡང༌། ཁྱེད་ཀྱི་སྡུག་བསྔལ་དགའ་སྤྲོ་ལ་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","བུད་མེད་ཅིག་ནི་བུ་བཙའ་བའི་དུས་སུ་སྐྱེ་ཟུག་གིས་སྡུག་བསྔལ་འབྱུང༌། མོ་རང་གི་དུས་ཚོད་ལ་བབ་པའི་ཕྱིར་རོ། འོན་ཀྱང་དམར་འབྱར་ཞིག་སྐྱེས་ཚར་ནས། ཕྲུ་གུ་ཞིག་འཇིག་རྟེན་དུ་སྐྱེས་པ་ཡིན་པས་དགའ་སྟེ། སྡུག་བསྔལ་དེ་མི་དྲན། ");
INSERT INTO bod_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","དེ་བཞིན་དུ་ད་ལྟ་ཁྱེད་ཚོར་སྡུག་བསྔལ་ཡོད་ནའང༌། ང་ཁྱེད་ཚོ་དང་ཡང་བསྐྱར་ཐུག་པའི་ཚེ། ཁྱེད་ཀྱི་སེམས་དགའ་བར་འགྱུར་ཏེ། ཁྱེད་ཀྱི་དགའ་སྤྲོ་སུས་ཀྱང་འཕྲོག་པར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","དེའི་ཉིན་མོར་ཁྱེད་ཚོས་ང་ལ་དོན་ཅི་ཡང་འདྲི་མི་ཡོང༌། ངས་ཁྱེད་ཚོར་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱེད་ཚོས་ངའི་མིང་ཐོག་ནས་དཀོན་མཆོག་ལ་གང་ཞིག་ཞུས་ཀྱང་ཁོང་གིས་ཁྱེད་ཚོར་གནང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ད་བར་ཁྱེད་ཚོས་ངའི་མིང་ཐོག་ནས་ཅི་ཡང་ཞུས་མ་མྱོང་ལ། ད་ཁྱེད་ཚོའི་དགའ་སྤྲོ་འགྲུབ་པའི་ཕྱིར་གསོལ་བ་ཐོབ་དང་འཐོབ་པར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ངས་དོན་དེ་རྣམས་ཁྱེད་ཚོ་ལ་དཔེའི་སྒོ་ནས་བཤད་ཀྱང༌། དཔེའི་སྒོ་ནས་མ་ཡིན་པར་ཡབ་ཀྱི་སྐོར་གསལ་པོར་ཤོད་པར་བྱ་བའི་དུས་ལ་འབབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","དེའི་ཉིན་མོར་ཁྱེད་ཚོས་ངའི་མིང་ཐོག་ནས་ཁོང་ལ་གསོལ་བ་འདེབས་རྒྱུ་ཡིན། ངས་ཁྱེད་ཚོའི་དོན་དུ་ཡབ་ལ་གསོལ་བ་འདེབས་པར་བྱ་མི་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ཅི་ལགས་ཟེར་ན། ཁྱེད་ཚོས་ང་ལ་བརྩེ་བར་བཟུང་ཞིང༌། ང་དཀོན་མཆོག་ནས་བྱུང་བ་ལ་དད་པ་བྱས་མྱོང་བས་ཡབ་ཉིད་ཀྱིས་ཀྱང་ཁྱེད་ཚོ་ལ་བྱམས། ");
INSERT INTO bod_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ང་ཡབ་ནས་བྱུང་སྟེ་འཇིག་རྟེན་ལ་ཡོང་བ་ལྟར། ད་འཇིག་རྟེན་དང་ཁ་བྲལ་ནས་ཡབ་ཀྱི་དྲུང་དུ་འགྲོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་“ད་ནི་ཁྱེད་ཀྱིས་དཔེའི་སྒོ་ནས་མི་གསུང་བར་གསལ་པོར་གསུང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ད་ང་ཚོས་ཁྱེད་ཀྱིས་དོན་ཚང་མ་མཁྱེན་པ་ཤེས་པས་སུས་ཀྱང་ཁྱེད་ལ་བཀའ་དྲི་ཞུ་མི་དགོས་པར་ང་ཚོས་ཤེས། དེའི་ཕྱིར་ང་ཚོས་ཁྱེད་ནི་དཀོན་མཆོག་ནས་བྱུང་བ་ཡིན་པར་ཡིད་ཆེས་བྱེད་”ཅེས་ཟེར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ལན་དུ་ཡེ་ཤུས་“ད་ཁྱེད་ཚོས་ཡིད་ཆེས་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ཁྱེད་ཚོ་རང་རང་གི་གནས་སུ་སོ་སོར་འགྱེས་ཤིང་ང་གཅིག་པུར་འཇོག་པའི་དུས་ལ་འབབ་པར་འགྱུར་བ་དང༌། ད་ལྟའང་འབབ་བོ། འོན་ཀྱང་ཡབ་ནི་ང་དང་མཉམ་དུ་བཞུགས་པས་ང་ནི་གཅིག་པུར་མི་གནས། ");
INSERT INTO bod_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ང་དང་འགྲོགས་པའི་སྒོ་ནས་ཁྱེད་ཚོ་ཞི་བདེར་གནས་པའི་ཕྱིར་ངས་ཁྱེད་ཚོ་ལ་དེ་ལྟར་བཤད། འཇིག་རྟེན་ནང་ལ་ཁྱེད་ཚོར་སྡུག་བསྔལ་ཡོད་ཀྱང༌། ང་འཇིག་རྟེན་ལས་རྒྱལ་བས་མ་འཇིགས་ཤིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ཡེ་ཤུས་དེ་ལྟར་གསུངས་ནས། དཀོན་མཆོག་གི་ཞིང་ཁམས་ཀྱི་ཕྱོགས་སུ་ཡར་གཟིགས་ཏེ་“ཀྱེ་ཡབ། ད་དུས་ལ་འབབ་སྟེ་སྲས་ཀྱིས་ཁྱེད་ཀྱི་གཟི་བརྗིད་མངོན་པར་བྱེད་པའི་ཕྱིར་ཁྱེད་ཀྱི་སྲས་ཀྱི་གཟི་བརྗིད་མངོན་པར་མཛོད། ");
INSERT INTO bod_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","རྒྱུ་མཚན་ནི་ཁྱེད་ཀྱིས་སྲས་ལ་གནང་ཡོད་པ་ཐམས་ཅད་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་གནང་བའི་ཕྱིར་ཁྱེད་ཀྱིས་མི་ཐམས་ཅད་སྲས་ཀྱི་དབང་འོག་ཏུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ཁྱེད་རང་བདེན་པའི་དཀོན་མཆོག་ཁོ་ན་དང༌། ཁྱེད་ཀྱི་མངགས་པ་ཡེ་ཤུ་མཱ་ཤི་ཀ་ཁོ་ཚོས་ངོ་ཤེས་པ་ནི་དཔག་ཏུ་མེད་པའི་ཚེ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་འཕྲིན་ལས་དེ་སྒྲུབ་པའི་སྒོ་ནས་ངས་སའི་སྟེང་ལ་ཁྱེད་ཀྱི་གཟི་བརྗིད་མངོན་པར་བྱས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ཀྱེ་ཡབ། འཇིག་རྟེན་མ་བཀོད་པའི་སྔོན་ལ་ང་རང་ཁྱེད་དང་མཉམ་དུ་བཞུགས་པའི་དུས་ཀྱི་གཟི་བརྗིད་དེ་ཉིད་ད་ལྟའང་ཁྱེད་ཀྱི་མདུན་དུ་ང་ལ་མངོན་པར་མཛོད། ");
INSERT INTO bod_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ཁྱེད་ཀྱིས་འཇིག་རྟེན་གྱི་ནང་ནས་ང་ལ་གནང་བའི་མི་རྣམས་ལ་ངས་ཁྱེད་ཀྱི་མཚན་མངོན་པར་བྱས། དེ་ཚོ་སྔར་ནས་ཁྱེད་ཀྱི་ཡིན་ཏེ། ཁྱེད་ཀྱིས་དེ་ཚོ་ང་ལ་གནང་ནས། ཁོ་ཚོས་ཁྱེད་ཀྱི་བཀའ་བསྲུངས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ད་ལྟ་ཁྱེད་ཀྱིས་ང་ལ་གང་གནང་ཡོད་པ་དེ་ཐམས་ཅད་ཁྱེད་རང་ནས་ཡིན་པ་ཁོ་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","གང་ལགས་ཟེར་ན། ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་བཀའ་རྣམས་ངས་ཁོ་ཚོ་ལ་གཏད་ནས་དེ་ཚོས་དང་དུ་བླངས། ང་ནི་ཁྱེད་ནས་དངོས་སུ་བྱུང་བ་དེ་ཚོས་བདེན་པར་ཤེས་ཤིང༌། ང་ཁྱེད་ཀྱིས་མངགས་པར་ཡང་ཡིད་ཆེས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ངས་འཇིག་རྟེན་གྱི་མིའི་དོན་དུ་གསོལ་བ་མི་འདེབས་པར་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་མི་འདི་ཚོའི་དོན་ལ་གསོལ་བ་འདེབས། གང་ལགས་ཟེར་ན། ཁོ་ཚོ་ཁྱེད་ལ་གཏོགས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ངའི་ཡིན་པ་ཐམས་ཅད་ཁྱེད་ཀྱི་ཡིན་པ་དང༌། ཁྱེད་ཀྱི་ཡིན་པ་ཐམས་ཅད་ངའི་ཡིན། དེ་ཚོའི་ངང་ནས་ངའི་གཟི་བརྗིད་མངོན་དུ་གྱུར་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ད་ཕྱིན་ཆད་ང་ནི་འཇིག་རྟེན་གྱི་ནང་ལ་མེད། འོན་ཀྱང་ཁོ་ཚོ་འཇིག་རྟེན་ནང་ལ་ཡོད། ང་ནི་ཁྱེད་ཀྱི་དྲུང་དུ་ཡོང༌། ཀྱེ་ཡབ་དམ་པ་ལགས། ཁོ་ཚོ་ནི་ང་གཉིས་གཅིག་ཡིན་པ་ལྟར་ཁོ་ཚོའང་གཅིག་ཏུ་འགྱུར་བའི་ཕྱིར་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་མཚན་གྱི་དབང་ཐོག་ནས་ཁོ་ཚོ་སྲུང་བར་མཛོད། ");
INSERT INTO bod_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ང་ཁོ་ཚོ་དང་མཉམ་དུ་ཡོད་དུས་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་མཚན་གྱི་དབང་ཐོག་ནས་ངས་ཁོ་ཚོ་བསྲུངས་ཤིང་བསྐྱངས་པ་ཡིན། གསུང་རབ་ལས་གསུངས་པ་ལྟར་འགྲུབ་པའི་ཕྱིར་སྟོར་རྒྱུ་ཡིན་པའི་མི་མ་གཏོགས་པར་དེ་ཚོའི་ནང་ནས་གཅིག་ཀྱང་མ་སྟོར། ");
INSERT INTO bod_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","འོན་ཀྱང་ད་ལྟ་ང་ཁྱེད་རང་གི་དྲུང་དུ་ཡོང་ཞིང་ངས་འཇིག་རྟེན་ལ་དེ་ལྟར་བཤད་པ་ནི། ཁོ་ཚོའི་སེམས་ནང་ལ་ངའི་དགའ་སྤྲོ་ཚང་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ངས་ཁོ་ཚོ་ལ་ཁྱེད་ཀྱི་བཀའ་གཏད་ཡོད། ཇི་ལྟར་ང་རང་འཇིག་རྟེན་ནས་མ་ཡིན་པ་དེ་ལྟར་ཁོ་ཚོའང་འཇིག་རྟེན་ནས་མ་ཡིན་པས། འཇིག་རྟེན་གྱིས་ཁོ་ཚོ་ལ་སྡང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ངས་ཁྱེད་ཀྱིས་ཁོ་ཚོ་འཇིག་རྟེན་གྱི་ནང་ནས་འཁྱེར་བར་གསོལ་བ་མི་འདེབས་པར། ཁྱེད་ཀྱིས་སྡིག་སྤྱོད་མཁན་ཞེས་བྱ་བ་ལས་སྲུང་བར་གསོལ་བ་འདེབས་སོ། ");
INSERT INTO bod_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ང་རང་འཇིག་རྟེན་ནས་མ་ཡིན་པ་ལྟར་ཁོ་ཚོའང་འཇིག་རྟེན་ནས་མ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","བདེན་པ་ཉིད་ཀྱི་ངང་ནས་ཁོ་ཚོ་དམ་པར་མཛོད། ཁྱེད་ཀྱི་བཀའ་ནི་བདེན་པ་ཉིད་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ཇི་ལྟར་ཁྱེད་ཀྱིས་ང་རང་འཇིག་རྟེན་དུ་མངགས་པ་ལྟར་ངས་ཁོ་ཚོ་འཇིག་རྟེན་དུ་བཏང་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ཡང་ཁོ་ཚོ་བདེན་པའི་ངང་ནས་དམ་པར་འགྱུར་བའི་ཕྱིར་ངས་རང་ཉིད་དམ་པ་ཆགས་པར་བྱེད། ");
INSERT INTO bod_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ངས་ཁོ་ཚོ་ཁོ་ནའི་དོན་དུ་མ་ཟད། ཁོ་ཚོས་ཆོས་བསྟན་པའི་སྒོ་ནས་ང་ལ་དད་པར་འགྱུར་བ་རྣམས་ཀྱི་དོན་དུ་ཡང་གསོལ་བ་འདེབས། ");
INSERT INTO bod_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","དེ་ནི་ཁོ་ཚོ་ཐམས་ཅད་གཅིག་ཏུ་འགྱུར་བའི་ཕྱིར་རོ། ཇི་ལྟར་ཡབ་ཁྱེད་ནི་ངའི་ནང་ན་བཞུགས་ཏེ། ང་ཡང་ཁྱེད་ཀྱི་ནང་ལ་ཡོད་པ་དེ་ལྟར་དེ་ཚོའང་ངེད་གཉིས་ཀྱི་ནང་ན་གཅིག་ཏུ་འགྱུར་བར་ཞུ། དེ་ནས་འཇིག་རྟེན་གྱི་མི་རྣམས་ཀྱིས་ང་ནི་ཁྱེད་ཀྱིས་མངགས་པ་ཡིན་པར་དད་པ་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ཡང་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་གཟི་བརྗིད་དེ་ནི་ཁོ་ཚོ་ལ་ཡང་སྟེར་ཟིན། ངེད་གཉིས་གཅིག་ཡིན་པ་ལྟར་དེ་ཚོའང་གཅིག་ཏུ་འགྱུར་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","དེའི་དོན་ནི་ང་ཁོ་ཚོའི་ནང་ན་ཡོད། ཁྱེད་ངའི་ནང་ན་ཡོད། དེ་ནི་ཁོ་ཚོ་ཡང་དག་པར་གཅིག་ཏུ་འགྱུར་བའི་ཕྱིར་རོ། དེ་ནས་འཇིག་རྟེན་གྱིས་ཁྱེད་ཀྱིས་ང་མངགས་པ་དང༌། ཁྱེད་ཀྱིས་ང་ལ་བྱམས་པ་མཛད་པ་བཞིན་དུ་ཁོ་ཚོ་ལ་ཡང་བྱམས་པར་མཛད་པ་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ཀྱེ་ཡབ། ཁྱེད་ཀྱིས་ང་ལ་གནང་བ་རྣམས་ང་གང་དུ་ཡོད་པ་དེར་ང་དང་མཉམ་དུ་ཡོད་པར་འདོད། དེ་ནི་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་གཟི་བརྗིད་ཁོ་ཚོས་མཐོང་བར་འགྱུར་བའི་ཕྱིར་རོ། འཇིག་རྟེན་མ་བཀོད་པའི་སྔོན་ལ་ཁྱེད་ཀྱིས་ང་ལ་བྱམས་པར་མཛད་པ་ཡིན་པས་གཟི་བརྗིད་དེ་ང་ལ་གནང་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ཀྱེ། དྲང་བདེན་གྱི་ཡབ་ལགས། འཇིག་རྟེན་གྱི་མི་ཚོས་ཁྱེད་རང་ངོ་མི་ཤེས་མོད། ངས་ཁྱེད་རང་ངོ་ཤེས། མི་འདི་ཚོས་ཀྱང་ཁྱེད་ཀྱིས་ང་མངགས་པ་ཡིན་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ཁྱེད་ཀྱིས་ང་ལ་བྱམས་པར་མཛད་པའི་བྱམས་པ་དེ་ཁོ་ཚོའི་སེམས་ལ་བཞུགས་པའི་ཆེད་དང༌། ང་རང་ཡང་ཁོ་ཚོའི་སེམས་ལ་བཞུགས་པའི་ཕྱིར། ངས་ཁྱེད་རང་གི་མཚན་ཁོ་ཚོ་ལ་མངོན་པར་བྱས་ལ། ད་དུང་ཡང་མངོན་པར་བྱ་”ཞེས་གསོལ་བ་བཏབ་བོ། ། ");
INSERT INTO bod_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ཡེ་ཤུས་དེ་ལྟར་གསུངས་པའི་རྗེས་སུ། ཉེ་གནས་དང་མཉམ་དུ་ཕྱི་རོལ་ལ་ཕེབས་པ་དང་ཀི་ཌ་རོན་ཟེར་བའི་གཤོང་ས་བརྒལ་ནས་གནས་དེར་ཡོད་པའི་སྐྱེད་ཚལ་ཞིག་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ས་ཆ་དེར་ཡེ་ཤུ་ལན་མང་པོ་ཉེ་གནས་དང་མཉམ་དུ་འཛོམས་མྱོང་བས། ཁོང་དགྲའི་དབང་དུ་གཏོང་མཁན་ཡུ་དཱ་ལ་གནས་དེ་རྒྱུས་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","དེ་ནས་ཡུ་དཱ་ཡིས་དཔུང་ཚོགས་དང༌། ཕཱ་རུ་ཤི་པ་དང་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱིས་བཏང་བའི་མཆོད་ཁང་གི་སྲུང་དམག་མཉམ་དུ་ཁྲིད་ནས་ལག་ཏུ་ལྒང་ཞུ་དང༌། དཔལ་འབར། མཚོན་ཆ་བཅས་ཁྱེར་ནས་དེར་སླེབས་པས། ");
INSERT INTO bod_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ཡེ་ཤུས་རང་ལ་གང་འབྱུང་རྒྱུ་ཡིན་པ་ཐམས་ཅད་མཁྱེན་ཏེ། མདུན་ལ་ཕེབས་ནས་མི་དེ་ཚོར་“ཁྱེད་ཚོས་སུ་ཞིག་འཚོལ་བཞིན་ཡོད་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ལན་དུ་མི་དེ་ཚོས་“ན་ཙ་རེལ་པ་ཡེ་ཤུ་འཚོལ་”ཞེས་ཟེར་བས་ཡེ་ཤུས་“དེ་ནི་ང་ཡིན་”ཞེས་གསུངས། ཁོང་དགྲའི་དབང་དུ་གཏོང་མཁན་ཡུ་དཱ་ཡང་ཁོ་ཚོ་དང་མཉམ་དུ་དེར་ལངས་བསྡད་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ཡེ་ཤུས་ང་དེ་ཡིན་ཞེས་གསུངས་པ་ཙམ་གྱིས་ཁོ་ཚོ་ཕྱི་ནུད་བརྒྱབ་ནས་ས་ལ་འགྱེལ། ");
INSERT INTO bod_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ཡེ་ཤུས་ཡང་བསྐྱར་ཁོ་ཚོར་“ཁྱེད་ཚོས་སུ་ཞིག་འཚོལ་”ཞེས་གསུངས་པས་ཁོ་ཚོས་“ན་ཙ་རེལ་པ་ཡེ་ཤུ་འཚོལ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ཡེ་ཤུས་“ངས་དེ་ཡིན་ཞེས་བཤད་པ་ཡིན། ཁྱེད་ཚོས་ང་རང་བཙལ་ན་མི་འདི་ཚོ་འགྲོ་རུ་ཆུག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","དེ་ནི་ཡེ་ཤུས་ཁྱེད་ཀྱིས་ང་ལ་གནང་བའི་མི་དེ་ཚོའི་ནང་ནས་གཅིག་ཀྱང་མ་བརླགས་ཤེས་སྔར་གསུངས་པ་དེ་སྒྲུབ་པའི་ཕྱིར་བྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","སི་མོན་པེ་ཏྲོ་ལ་རལ་གྲི་ཞིག་ཡོད་པ་དེ་བཏོན་ནས། བླ་ཆེན་གཙོ་བོའི་གཡོག་པོ་ལ་བརྒྱབ་ནས་རྣ་བ་གཡས་པ་བཅད། གཡོག་པོ་དེའི་མིང་ནི་མལ་ཀུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ཡེ་ཤུས་པེ་ཏྲོ་ལ་“རལ་གྲི་དེ་ཤུབས་སུ་ཆུག་ཅིག ཡབ་ཀྱིས་ང་ལ་གནང་བའི་ཕོར་པ་གང་པོ་དེ་ངས་མི་འཐུང་ངམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","དེ་ནས་དཔུང་ཚོགས་དང༌། དེ་ཚོའི་དམག་དཔོན་ཡ་ཧུ་དཱ་པའི་མཆོད་ཁང་གི་སྲུང་དམག་བཅས་ཀྱིས་ཡེ་ཤུ་འཛིན་བཟུང་བྱས་ནས་བཅིངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","སྔོན་ལ་ཨ་ན་སི་ཟེར་མཁན་གྱི་དྲུང་དུ་ཁྲིད། ཁོ་ནི་ལོ་དེའི་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོ་ཀ་ཡ་ཕཱ་ཡི་ཟླ་བོའི་ཕ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ཀ་ཡ་ཕཱ་ཞེས་པ་དེ་ནི་སྔར་ཡ་ཧུ་དཱ་པའི་དཔོན་རིགས་རྣམས་ལ་མི་གཅིག་མི་དམངས་ཀྱི་དོན་དུ་ཤི་ན་ལེགས་ཞེས་བསླབ་བྱ་བྱེད་མཁན་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","དེ་ནས་སི་མོན་པེ་ཏྲོ་དང་ཉེ་གནས་གཞན་པ་ཞིག་ཡེ་ཤུའི་རྗེས་སུ་འབྲངས། ཉེ་གནས་གཞན་པ་དེ་ནི་བླ་ཆེན་གཙོ་བོའི་ངོ་ཤེས་པ་ཡིན་པས། ཡེ་ཤུ་དང་མཉམ་དུ་བླ་ཆེན་གཙོ་བོའི་སྒོ་རའི་ནང་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","འོན་ཀྱང་པེ་ཏྲོ་ནི་སྒོའི་འགྲམ་གྱི་ཕྱི་རོལ་ཏུ་ལངས་ཏེ་བསྡད། དེ་ནས་བླ་ཆེན་གཙོ་བོས་ངོ་ཤེས་པའི་ཉེ་གནས་གཞན་པ་དེ་ཕྱི་ལ་སོང་ནས་སྒོ་སྲུང་མཁན་གཡོག་མོ་ལ་གཏམ་བྱས་ནས་པེ་ཏྲོ་ཡང་ནང་དུ་ཁྲིད། ");
INSERT INTO bod_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","དེ་ནས་གཡོག་མོ་དེས་པེ་ཏྲོ་ལ་“ཁྱེད་ཀྱང་མི་དེའི་ཉེ་གནས་རྣམས་ཀྱི་ནང་ནས་གཅིག་མ་ཡིན་ནམ་”ཞེས་བཤད་པས་ལན་དུ་ཁོས་“ང་མ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","གནམ་གྲང་མོ་ཡིན་པས་གཡོག་པོ་རྣམས་དང་མཆོད་ཁང་གི་སྲུང་དམག་ཚོས་སོལ་བའི་མེ་བཏང་ནས་ལངས་ཏེ་མེ་ལ་བསྲོས། པེ་ཏྲོ་ཡང་དེ་ཚོ་དང་མཉམ་དུ་བསྡད་ནས་མེ་ལ་བསྲོས། ");
INSERT INTO bod_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","དེ་ནས་བླ་ཆེན་གཙོ་བོས་ཡེ་ཤུ་ལ་ཁོང་གི་ཉེ་གནས་དང་བསྟན་པའི་སྐོར་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ཡེ་ཤུས་“ངས་མངོན་སུམ་དུ་འཇིག་རྟེན་ལ་བཤད་པ་ཡིན། ངས་རྟག་པར་འདུ་ཁང་དང༌། ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་འཛོམས་པའི་མཆོད་ཁང་ཆེན་མོའི་སྒོ་ར་གཉིས་ལ་ཆོས་བསྟན་པ་ཡིན། ཅི་ཡང་གསང་བའི་ངང་ནས་མ་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ང་ལ་ཅིའི་ཕྱིར་འདྲི། ངས་བཤད་པའི་གཏམ་ཐོས་པ་རྣམས་ལ་དྲིས་ཤིག ངས་གང་བཤད་པ་དེ་ཚོས་ཤེས་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","དེ་རུ་ལངས་བསྡད་པའི་སྲུང་དམག་རྣམས་ཀྱི་ནང་ནས་གཅིག་གིས་ཡེ་ཤུའི་ཞལ་ལ་བཞུས་ཏེ་“ཁྱོད་ཀྱིས་བླ་ཆེན་གཙོ་བོ་ལ་ལན་འདི་ལྟར་འདེབས་སམ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ལན་དུ་ཡེ་ཤུས་“ངའི་བཤད་པའི་གཏམ་དེ་འོས་པ་མ་ཡིན་ན་དེ་ལ་དཔང་པོ་བྱོས་ཤིག འོས་པ་ཡིན་ན་ཁྱེད་ཀྱིས་ང་ཅིའི་ཕྱིར་བརྡུངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ཡེ་ཤུ་སྔར་ནས་བཅིངས་ཡོད་དེ་ཨ་ན་སི་ཡིས་ཡེ་ཤུ་བླ་ཆེན་གཙོ་བོ་ཀ་ཡ་ཕཱའི་དྲུང་དུ་ཁྲིད་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","སི་མོན་པེ་ཏྲོ་ད་དུང་ལངས་ནས་བསྡད་དེ་མེ་ལ་སྲོ་བཞིན་ཡོད། དེའི་ཕྱིར་ཁོ་ཚོས་ཁོ་ལ་“ཁྱོད་ཀྱང་མི་དེའི་ཉེ་གནས་ལས་གཅིག་མ་ཡིན་ནམ་”ཞེས་དྲིས་པས་ཁོས་ཁས་མ་བླངས་ཏེ་“ང་རང་མིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","བླ་ཆེན་གཙོ་བོའི་གཡོག་པོ་རྣམས་ཀྱི་ནང་ནས་གཅིག་པེ་ཏྲོས་རྣ་བ་བཅད་པ་དེའི་གཉེན་ཚན་ཡིན་པ་དེས་“ངས་ཁྱོད་སྐྱེད་ཚལ་གྱི་ནང་ལ་ཁོང་དང་མཉམ་དུ་མ་མཐོང་ངམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","པེ་ཏྲོས་ཡང་བསྐྱར་ཁས་མ་བླངས་མ་ཐག་ཏུ་བྱ་ཕོས་སྐད་བརྒྱབ་བོ། ། ");
INSERT INTO bod_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","དེ་ནས་ཞོགས་སྔ་པོར་ཁོ་ཚོས་ཡེ་ཤུ་ཀ་ཡ་ཕཱ་ཡི་རྩ་ནས་སྤྱི་ཁྱབ་ཀྱི་ཕོ་བྲང་དུ་ཁྲིད་དེ། མི་དེ་ཚོ་རང་ཉིད་མི་གཙང་བར་མི་འགྱུར་བའི་ཕྱིར་དང་པེ་སག་གི་ཞལ་ལག་ཟ་ཐུབ་པའི་ཆེད་དུ་ཆོས་ཀྱི་ལུགས་སྲོལ་བཞིན་ཕོ་བྲང་གི་ནང་དུ་མ་ཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","དེའི་ཕྱིར་སྤྱི་ཁྱབ་པི་ལ་ཏུ་ཕྱི་རོལ་ཏུ་སོང་ནས་“ཁྱོད་ཚོས་མི་འདི་ལ་ཉེས་སྐྱོན་ཅི་འཛུགས་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ལན་དུ་ཁོ་ཚོས་“གལ་ཏེ་མི་འདི་ཉེས་ཅན་མ་ཡིན་ན་ངེད་ཀྱིས་ཁོ་ཁྱེད་རང་ལ་གཏད་པ་མེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","པི་ལ་ཏུ་ཡིས་“ཁྱོད་ཚོ་རང་ཉིད་ཀྱིས་ཁོ་ཁྲིད་ནས་ཁྱོད་རང་གི་ཁྲིམས་བཞིན་དུ་ཁྲིམས་གཅོད་བྱོས་ཤིག་”ཅེས་བཤད་པ་དང༌། ཡ་ཧུ་དཱ་པའི་ཆོས་དཔོན་རྣམས་ཀྱིས་“ང་ཚོས་མི་སུ་ཡང་སྲོག་ཐོག་གཏོང་མི་ཆོག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","དེ་ནི་སྔར་ཡེ་ཤུས་འགྲོངས་ཚུལ་གང་འབྱུང་རྒྱུ་ཡོད་པའི་སྐོར་ལ་གསུངས་པའི་བཀའ་དེ་སྒྲུབ་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","དེ་ནས་པི་ལ་ཏུ་ཡང་བསྐྱར་ཕོ་བྲང་གི་ནང་དུ་སོང་ནས་ཡེ་ཤུ་བོས་ནས་“ཁྱོད་ནི་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཡིན་ནམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ཡེ་ཤུས་“འདི་ཁྱེད་རང་ངོ་ཐོག་ནས་འདྲི་འམ། ཡང་ན་ཁྱེད་ལ་མི་གཞན་གྱིས་ངའི་སྐོར་གཏམ་བྱས་སམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ལན་དུ་པི་ལ་ཏུ་ཡིས་“ང་ཡ་ཧུ་དཱ་པ་ཡིན་ནམ། ཁྱོད་རང་གི་ཡུལ་མི་དང་བླ་ཆེན་རྣམས་ཀྱིས་ཁྱོད་ངའི་དབང་དུ་བཏང༌། ཁྱོད་ཀྱིས་ཅི་བྱས་”ཞེས་བརྗོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ཡེ་ཤུས་“ངའི་རྒྱལ་ཁམས་ནི་འཇིག་རྟེན་འདིའི་རྒྱལ་ཁམས་མ་ཡིན། གལ་ཏེ་ཡིན་ན། ངའི་གཡོག་པོ་རྣམས་ཀྱིས་ང་རང་ཡ་ཧུ་དཱ་པའི་ལག་ཏུ་མི་སྤྲོད་པའི་ཕྱིར་འཐབ་འཛིང་བྱེད་པ་ཡིན། འོན་ཀྱང་ད་ངའི་རྒྱལ་ཁམས་ནི་འཇིག་རྟེན་འདི་ནས་མ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","དེའི་ཕྱིར་པི་ལ་ཏུ་ཡིས་“འོ་ན་ཁྱོད་རྒྱལ་པོ་ཞིག་ཡིན་ནམ་”ཞེས་བརྗོད་པ་དང༌། ཡེ་ཤུས་“ཁྱེད་ཀྱིས་གསུངས་པ་ལྟར་ང་རྒྱལ་པོ་ཞིག་ཡིན། ང་ནི་བདེན་པ་ཉིད་ལ་དཔང་པོ་བྱེད་པའི་ཕྱིར་སྐྱེས། དེའི་དོན་དུ་ང་འཇིག་རྟེན་དུ་ཡོང༌། སུ་ཡང་བདེན་པ་ཉིད་ནས་ཡིན་པ་དེས་ངའི་བཀའ་ལ་ཉན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","པི་ལ་ཏུ་ཡིས་ཁོང་ལ་“བདེན་པ་ནི་ཅི་ཡིན་”ཞེས་བཤད་ནས་ཡང་ཕྱི་རོལ་ཏུ་ཡ་ཧུ་དཱ་པའི་རྩར་སོང་སྟེ་ཁོ་ཚོ་ལ་“ངས་མི་འདི་ལ་ཉེས་སྐྱོན་ཅིའང་མི་རྙེད། ");
INSERT INTO bod_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","འོན་ཀྱང་ཁྱོད་རྣམས་ལ་པེ་སག་གི་དུས་ཆེན་ལ་མི་གཅིག་གློད་བཀྲོལ་གཏོང་བའི་ལུགས་སྲོལ་ཞིག་ཡོད། ད་ངས་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་འདི་གཏོང་བ་ཁྱེད་ཚོ་འདོད་དམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","དེའི་ཕྱིར་ཁོ་ཚོས་སྐད་ཆེན་པོས་“མི་འདི་མ་གཏོང༌། པར་ཨབ་པཱ་གཏོང་”ཞེས་ཞུས། པར་ཨབ་པཱ་དེ་ནི་ཇག་པ་ཞིག་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","དེ་ནས་པི་ལ་ཏུ་ཡིས་ཡེ་ཤུ་རྟ་ལྕག་གིས་རྡུང་དུ་བཅུག་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","དམག་མི་རྣམས་ཀྱིས་ཚེར་མའི་ཅོད་པན་ཅིག་བསླས་ནས་ཁོང་གི་དབུ་ལ་བསྐོན་ཅིང༌། མདོག་རྒྱ་སྨུག་ཅན་གྱི་ན་བཟའ་ཞིག་ཁོང་ལ་བསྐོན། ");
INSERT INTO bod_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ཁོ་ཚོ་ཁོང་གི་དྲུང་དུ་ཡོང་ནས་“ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ལ་ཕྱག་འཚལ་ལོ་”ཞེས་ཡང་ཡང་ཟེར་ཞིང་འགྲམ་ལྕག་བཞུས། ");
INSERT INTO bod_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","པི་ལ་ཏུ་ཡང་བསྐྱར་ཕྱི་རོལ་ཏུ་སོང་ནས་ཁོ་ཚོར་“ལྟོས་ཤིག ངས་ཁོ་ལ་ཉེས་སྐྱོན་ཅིའང་མ་རྙེད་པ་ཁྱོད་ཚོས་ཤེས་པའི་ཕྱིར་ངས་ཁོ་ཁྱོད་ཚོའི་མདུན་དུ་ཕྱི་ལ་འཁྲིད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","དེ་ནས་ཡེ་ཤུ་ཚེར་མའི་ཅོད་པན་དང་མདོག་རྒྱ་སྨུག་ཅན་གྱི་ན་བཟའ་བཞེས་ནས་ཕྱི་རོལ་ཏུ་ཕེབས་པ་དང༌། པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“ལྟོས་ཤིག མི་དེ་འདིར་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","བླ་ཆེན་དང་མཆོད་ཁང་གི་སྲུང་དམག་ཚོས་ཁོང་མཐོང་སྐབས་སྐད་ཆེན་པོས་“རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་ཟེར། པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“ངས་ཁོ་ལ་ཉེས་སྐྱོན་ཅིའང་མ་རྙེད། ཁྱོད་ཚོས་ཁོང་བཟུང་ནས་རྒྱང་ཤིང་སྒང་ལ་སོད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ལན་དུ་ཡ་ཧུ་དཱ་པས་“ང་ཚོ་ལ་ཆོས་ཁྲིམས་ཤིག་ཡོད་པ་དེ་ནང་བཞིན་དུ་ཁོ་ལ་གསོད་པའི་ཉེས་ཆད་གཅོད་འོས་སོ། ཅི་ལགས་ཟེར་ན། ཁོས་ང་རང་དཀོན་མཆོག་གི་སྲས་ཡིན་ཞེས་བཤད་པའི་ཕྱིར་”ཞེས་བརྗོད། ");
INSERT INTO bod_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","པི་ལ་ཏུ་ཡིས་གཏམ་དེ་ཐོས་ནས་ལྷག་པར་ཡང་འཇིགས་པར་གྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ཡང་བསྐྱར་ཕོ་བྲང་ནང་དུ་སོང་ནས་ཡེ་ཤུ་ལ་“ཁྱོད་ག་ནས་ཡིན་”ཞེས་ཟེར། འོན་ཀྱང་ཡེ་ཤུས་ལན་ཅིའང་མ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","དེའི་ཕྱིར་པི་ལ་ཏུ་ཡིས་“ཁྱོད་ཀྱིས་ང་ལ་གཏམ་མི་བྱེད་དམ། ང་ལ་ཁྱོད་གློད་བཀྲོལ་གཏོང་བའི་དབང་ཆ་དང༌། ཁྱོད་རྒྱང་ཤིང་སྒང་ལ་གསོད་པའི་དབང་ཆ་ཡང་ཡོད་པ་མི་ཤེས་སམ་”ཞེས་དྲིས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ཡེ་ཤུས་“ཁྱེད་ལ་སྟེང་ནས་ང་ལ་དབང་བྱེད་པར་གནང་བ་མ་ཡིན་ན་ཁྱེད་ལ་དབང་མེད། དེའི་ཕྱིར་ང་ཁྱེད་ལ་གཏད་མཁན་གྱི་སྡིག་ཉེས་ཁྱེད་ཀྱི་སྡིག་པ་ལས་ཆེ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","དེ་ནས་པི་ལ་ཏུ་ཡིས་ཁོང་གློད་པའི་ཐབས་བཙལ་ཡང༌། ཡ་ཧུ་དཱ་པས་སྐད་ཆེན་པོས་“སུ་ཞིག་གིས་ང་རང་རྒྱལ་པོ་ཡིན་ཟེར་བ་དེས་རྒྱལ་པོ་ཆེན་པོ་སེ་སར་ལ་ངོ་རྒོལ་བྱེད་པས། ཁྱེད་ཀྱིས་མི་འདི་གློད་བཏང་ན་རྒྱལ་པོ་ཆེན་པོ་སེ་སར་གྱི་མཛའ་གྲོགས་མ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","པི་ལ་ཏུ་ཡིས་གཏམ་དེ་ཐོས་ནས་ཡེ་ཤུ་ཕྱི་རོལ་ཏུ་ཁྲིད་ཡོང་ནས། རྡོ་གཅལ་ལ་ཡ་ཧུ་དཱ་པའི་སྐད་དུ་གབ་བ་ཐཱ་ཟེར་བའི་ས་ཆར་ཁྲིམས་དཔོན་གྱི་ཁྲི་ལ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","དེ་ནི་པེ་སག་དུས་ཆེན་གྱི་གྲ་སྒྲིག་གི་ཉིན་མོའི་ཉིན་གུང་ཙམ་ཡིན། པི་ལ་ཏུ་ཡིས་ཡ་ཧུ་དཱ་པ་ཚོར་“ད་ཁྱོད་ཚོའི་རྒྱལ་པོ་ལ་ལྟོས་ཤིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ཁོ་ཚོས་སྐད་ཆེན་པོས་“ཁོ་ཕར་ཁྲིད། ཕར་ཁྲིད། རྒྱང་ཤིང་སྒང་ལ་སོད་ཅིག་”ཅེས་ཟེར། པི་ལ་ཏུ་ཡིས་ཁོ་ཚོར་“ངས་ཁྱོད་ཚོའི་རྒྱལ་པོ་རྒྱང་ཤིང་སྒང་ལ་གསོད་པར་བྱ་འམ་”ཞེས་དྲིས་པའི་ལན་དུ་བླ་ཆེན་ཚོས་“རྒྱལ་པོ་ཆེན་པོ་སེ་སར་མ་གཏོགས་ང་ཚོར་རྒྱལ་པོ་མེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","དེ་ནས་པི་ལ་ཏུ་ཡིས་ཁོང་རྒྱང་ཤིང་སྒང་ལ་གསོད་པའི་ཕྱིར་ཁོ་ཚོ་ལ་གཏད་ནས་ཁོ་ཚོས་ཁོང་ཕར་ཁྲིད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ཡེ་ཤུ་ཕྱི་རོལ་ཏུ་ཕེབས་ནས་རང་གི་རྒྱང་ཤིང་འཁུར་ཏེ་ཀ་ལི་ཞེས་པའི་གནས་ཡ་ཧུ་དཱ་པའི་སྐད་དུ་གོལ་གོ་ཐ་ཞེས་བྱ་བ་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","དེར་ཁོང་དང་གཞན་མི་གཉིས་གཡས་སུ་གཅིག་དང་གཡོན་དུ་གཅིག་ཡེ་ཤུ་དཀྱིལ་དུ་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས། ");
INSERT INTO bod_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","པི་ལ་ཏུ་ཡིས་ན་ཙ་རེལ་པ་ཡེ་ཤུ་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཞེས་པའི་བརྡ་ཁྱབ་བྲིས་ནས་རྒྱང་ཤིང་གི་ཁར་བཏགས་སུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ཡི་གེ་དེ་ཡ་ཧུ་དཱ་དང་གྷི་རིག་དང་ལཱ་ཏིན་གྱི་སྐད་གསུམ་དུ་བྲིས་པ་དང༌། ཡེ་ཤུ་རྒྱང་ཤིང་ལ་བརྒྱངས་པའི་གནས་དེ་གྲོང་ཁྱེར་དང་ཐག་ཉེ་བས། ཡ་ཧུ་དཱ་པ་མང་པོས་ཡི་གེ་དེ་བཀླགས། ");
INSERT INTO bod_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་རྣམས་ཀྱིས་པི་ལ་ཏུ་ལ་“ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཞེས་མི་འབྲི་བར། མི་འདི་ཡིས་ང་ཡ་ཧུ་དཱ་པའི་རྒྱལ་པོ་ཡིན་ཞེས་ཟེར་བཞིན་འབྲི་བར་མཛོད་ཅིག་”ཅེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ལན་དུ་པི་ལ་ཏུ་ཡིས་“ངས་གང་བྲིས་ཡོད་པ་དེ་ཚར་རོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","དམག་མི་རྣམས་ཀྱིས་ཡེ་ཤུ་རྒྱང་ཤིང་སྟེང་ལ་བརྒྱངས་ནས། ཁོང་གི་ན་བཟའ་སྐལ་བ་བཞི་རུ་བགོས་ནས་དམག་མི་རེ་རེར་ཐོབ་པ་དང༌། ཡང་ནང་གོས་ཤིག་འཚེམ་མེད་རས་ཡུག་ཅིག་ལས་གྲུབ་པ་ཡིན་པའི་ཕྱིར། ");
INSERT INTO bod_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“འདི་མི་རལ་བར་སུ་ལ་ཐོབ་པའི་རྒྱན་འཛུགས་པར་བྱ་”ཞེས་ཟེར་བ་དེ་ནི་གསུང་རབ་ཀྱི་མདོ་ལས། ང་ཡི་གོས་རྣམས་བགོས་བྱས་ཤིང༌། ། ང་ཡི་གོས་ལ་རྒྱན་བརྒྱབ་བོ། ། ཞེས་གསུངས་པ་བཞིན་དུ་འགྲུབ་པའི་ཕྱིར་དེ་ལྟར་བྱུང་བ་དང་དམག་མི་རྣམས་ཀྱིས་དེ་ལྟར་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","སྐབས་དེར་ཡེ་ཤུའི་རྒྱང་ཤིང་གི་རྩར་ཡེ་ཤུའི་ཡུམ་དང༌། ཁོ་མོའི་སྤུན་མིར་ཡམ་ཀ་ལོ་ཕཱ་ཡི་ཟླ་བོ་དང་མག་རྡལ་ནས་ཡིན་པའི་མིར་ཡམ་བཅས་དེར་ལངས་ཏེ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ཡེ་ཤུས་རང་གི་ཡུམ་དང་ཁོང་གིས་དམིགས་བསལ་གྱིས་བྱམས་པར་འཛིན་པའི་ཉེ་གནས་དེར་ལངས་ཏེ་བསྡད་པར་གཟིགས་ནས་ཡུམ་ལ་“ཨ་མ་ལགས། ལྟོས་དང༌། འདི་ནི་ཁྱེད་ཀྱི་བུ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ཁོང་གིས་ཉེ་གནས་ལ་“ལྟོས་དང༌། འདི་ནི་ཁྱོད་ཀྱི་ཨ་མ་ལགས་ཡིན་ནོ་”ཞེས་གསུངས་པ་དང༌། དུས་དེ་རང་ནས་ཉེ་གནས་དེས་ཡེ་ཤུའི་ཡུམ་རང་གི་ཁྱིམ་ཚང་དུ་བསུས། ");
INSERT INTO bod_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","དེའི་རྗེས་སུ་ཡེ་ཤུས་དོན་ཚང་མ་ཟིན་པར་མཁྱེན་ཏེ་གསུང་རབ་ཀྱི་མདོ་ལས་བྲིས་པ་བཞིན་དུ་འགྲུབ་པའི་ཕྱིར་“ང་སྐོམ་མོ་”ཞེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","རྒུན་ཆང་སྐྱུར་མོས་གང་བའི་སྣོད་ཅིག་དེར་ཡོད་པས་ཁོ་ཚོས་དེའི་ནང་སྲིང་བལ་སྦངས་ནས་ཧི་སོབ་ཟེར་བའི་རྩི་ཤིང་གི་རྐང་ཡུའི་རྩེ་ལ་བསྐོན་ཏེ་ཁོང་གི་ཞལ་ལ་བཞག ");
INSERT INTO bod_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ཡེ་ཤུས་རྒུན་ཆང་སྐྱུར་མོ་དེ་བཞེས་ནས་“ད་གྲུབ་བོ་”ཞེས་གསུངས་པ་དང༌། དབུ་བཏུད་དེ་སྐུ་སྲོག་བཏང་གནང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","དེའི་ཉིན་གྲ་སྒྲིག་གི་ཉིན་མོ་ཡིན་ཏེ། ངལ་གསོ་བའི་ཉིན་མོ་ཡང་ཡིན་པས་དེ་ནི་དུས་གལ་ཆེན་ཅིག་ཡིན་པའི་ཕྱིར། སྤུར་རྣམས་ངལ་གསོ་བའི་ཉིན་མོར་རྒྱང་ཤིང་ལ་མ་ལུས་པའི་ཆེད་དུ་ཡ་ཧུ་དཱ་པས་པི་ལ་ཏུ་ལ་དེ་ཚོའི་རྐང་པ་བཅག་ནས་སྤུར་དེ་རྣམས་འཁྱེར་བའི་ཕྱིར་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","དེའི་ཕྱིར་དམག་མི་རྣམས་ཡོང་ནས་ཁོང་དང་མཉམ་དུ་རྒྱང་ཤིང་ལ་བརྒྱངས་པའི་མི་དང་པོའི་རྐང་པ་བཅག་ནས་མི་གཞན་པ་དེའི་རྐང་པའང་བཅག ");
INSERT INTO bod_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","འོན་ཀྱང་ཁོ་ཚོ་ཡེ་ཤུའི་དྲུང་དུ་སླེབས་ནས་ཁོང་གྲོངས་ཚར་བ་མཐོང་སྟེ་ཁོང་གི་ཞབས་མ་བཅག ");
INSERT INTO bod_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","དམག་མི་རྣམས་ལས་གཅིག་གིས་ཁོང་གི་གཞོགས་ལ་མདུང་བཙུགས་མ་ཐག་ཏུ་ཁྲག་དང་ཆུ་ཐོན་ནོ། ");
INSERT INTO bod_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","བྱ་བ་དེ་རྣམས་མཐོང་བའི་མིས་དེའི་དཔང་པོ་བྱས། ཡང་དཔང་པོ་དེ་ནི་བདེན་པ་ཡིན། མི་དེས་རང་གིས་བཤད་པ་དེ་བདེན་པ་ཡིན་པར་ཤེས་སྟེ། ཁྱེད་ཚོས་ཀྱང་དད་པ་བྱེད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","བྱ་བ་དེ་རྣམས་ནི་གསུང་རབ་ཀྱི་མདོ་ལས་ཁོང་གི་རུས་པ་ལས་གཅིག་ཀྱང་གཅོག་པར་མི་འགྱུར་ཞེས་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ཡང་མདོ་གཞན་ཞིག་ལ་དེ་རྣམས་ཀྱིས་སུ་ལ་བཙུགས་པ་དེ་ལ་ལྟ་བར་འགྱུར་རོ་ཞེས་གསུངས་པ་དེ་འགྲུབ་པའི་ཕྱིར་བྱུང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","དོན་དེ་རྣམས་ཀྱི་རྗེས་སུ། ཨ་རི་མ་ཐཱ་ཟེར་བའི་གྲོང་ཚོ་ནས་ཡིན་པ་ཡོ་སེབ་ནི་ཡ་ཧུ་དཱ་པ་ལ་འཇིགས་པས་ཡེ་ཤུའི་ཉེ་གནས་གསང་བ་ཞིག་ཡིན་པ་དེས་པི་ལ་ཏུ་ལ་ཡེ་ཤུའི་སྐུ་སྤུར་ཕར་འཁྱེར་དུ་གནང་བར་ཞུས་པ་དང༌། པི་ལ་ཏུ་ཡིས་དེ་བཞིན་དུ་ཆོག་མཆན་གནང་བས་ཡོ་སེབ་ཀྱིས་ཡེ་ཤུའི་སྐུ་སྤུར་ཕར་ཁྱེར། ");
INSERT INTO bod_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ནཱི་ཀོ་དེམ་ཟེར་མཁན་ཡང་སྔར་མཚན་མོར་ཡེ་ཤུ་མཇལ་མཁན་དེས་དྲི་ཞིམ་བྱུགས་རྫས་བསྲེས་མ་སྤྱི་རྒྱ་སུམ་ཅུ་སོ་བཞི་ཙམ་ཁུར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","དེ་གཉིས་ཀྱིས་ཡེ་ཤུའི་སྐུ་སྤུར་བླངས་ཏེ། ཡ་ཧུ་དཱ་མི་རིགས་ཀྱི་རོ་དུར་དུ་འཇུག་པའི་ལུགས་སྲོལ་བཞིན་དུ་དེ་ལ་སྤོས་རྫས་དེ་བཏབ་ནས་རས་སྤུས་ལེགས་ཀྱིས་བཏུམས། ");
INSERT INTO bod_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ཡེ་ཤུ་རྒྱང་ཤིང་ལ་བརྒྱངས་པའི་གནས་དེར་སྐྱེད་ཚལ་ཞིག་ཡོད་དེ། ཚལ་དེའི་ནང་ན་རོ་གཏན་ནས་བཞག་མ་མྱོང་བའི་དུར་ཁང་གསར་པ་ཞིག་ཡོད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ཉིན་དེ་ནི་ཡ་ཧུ་དཱ་པའི་གྲ་སྒྲིག་གི་ཉིན་མོ་ཡིན་པ་དང་དུར་ཁང་དེ་ཐག་ཉེ་བར་ཡོད་པས་ཁོ་ཚོས་ཡེ་ཤུའི་སྐུ་ཕུང་དེར་བཞག་གོ ། ");
INSERT INTO bod_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","དེ་ནས་གཟའ་འཁོར་གྱི་ཉིན་དང་པོར་ནམ་ཤིན་ཏུ་སྔ་བ་ད་དུང་མུན་པ་ཡོད་དུས་མག་རྡལ་ནས་ཡིན་པའི་མིར་ཡམ་དུར་ཁང་གི་མདུན་དུ་ཡོང་སྟེ། ཁ་རྡོ་དེ་དུར་ཁང་ནས་ཕར་བསྒྲིལ་ཚར་ཡོད་པ་མཐོང་བས། ");
INSERT INTO bod_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","བརྒྱུགས་ཏེ་སི་མོན་པེ་ཏྲོ་དང༌། ཡེ་ཤུས་དམིགས་བསལ་གྱིས་བྱམས་པ་གནང་བའི་ཉེ་གནས་གཞན་དེའི་རྩར་སོང་ནས་“ཁོ་ཚོས་གཙོ་བོ་དུར་ཁང་ནས་ཁྱེར་བ་དང༌། ཁོང་གང་དུ་བཞག་ཡོད་པ་ང་ཚོས་མི་ཤེས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","དེའི་ཕྱིར་པེ་ཏྲོ་དང་ཉེ་གནས་གཞན་པ་དེ་ཕྱི་རོལ་ཏུ་ཐོན་ནས་དུར་གྱི་ཕྱོགས་སུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ཡང་དེ་གཉིས་མཉམ་དུ་བརྒྱུགས་པ་དང༌། པེ་ཏྲོ་ལས་ཉེ་གནས་གཞན་དེ་མགྱོགས་པོར་བརྒྱུགས་པས་སྔོན་ལ་དུར་དུ་སླེབས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","བསྒུར་ནས་ནང་དུ་བལྟས་ཏེ་རས་སྤུས་ལེགས་དེར་ཡོད་པ་མཐོང་ཡང་ནང་དུ་མ་ཞུགས། ");
INSERT INTO bod_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","སི་མོན་པེ་ཏྲོ་ཡང་ཁོའི་རྗེས་སུ་དེར་སླེབས་པ་དང༌། དུར་ཁང་གི་ནང་དུ་ཞུགས་ནས་ཁོང་གིས་རས་སྤུས་ལེགས་དེར་ཡོད་པ་མཐོང་བ་མ་ཟད། ");
INSERT INTO bod_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ཡེ་ཤུའི་དབུ་ལ་གཡོགས་པའི་ཞལ་ཕྱིས་རས་དེ་གཞན་པ་རྣམས་དང་མཉམ་དུ་མེད་པར་གཅིག་པུ་གནས་གཞན་ཞིག་ན་བསྒྲིལ་ཏེ་ཡོད་པ་ཡང་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","དེ་ནས་ཉེ་གནས་གཞན་པ་དུར་དུ་སྔོན་ལ་སླེབས་པ་དེ་ཡང་ནང་དུ་ཞུགས་ནས་མཐོང་བས་ཡིད་ཆེས་བྱས། ");
INSERT INTO bod_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","འོན་ཀྱང་དེ་གཉིས་ཀྱིས་དཀོན་མཆོག་གི་གསུང་རབ་ཀྱི་མདོ་ལས་ཁོང་གཤིན་པོའི་ནང་ནས་གསོན་པོར་བཞེངས་དགོས་པ་དེ་ད་དུང་མ་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","དེ་ནས་ཉེ་གནས་དེ་གཉིས་རང་གི་ཁྱིམ་ལ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","མིར་ཡམ་ནི་དུར་ཁང་གི་ཕྱི་ལ་ལངས་ནས་བསྡད་དེ་ངུ་བཞིན། བསྒུར་ནས་དུར་ཁང་གི་ནང་དུ་བལྟས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ཡེ་ཤུའི་སྐུ་སྤུར་བཞག་ཡོད་པའི་གནས་ལ་དཀོན་མཆོག་གི་ཕོ་ཉ་གོས་དཀར་པོ་གྱོན་པ་གཉིས་དབུའི་ཕྱོགས་སུ་གཅིག་དང་ཞབས་ཀྱི་ཕྱོགས་སུ་གཅིག་བཞུགས་པར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ཁོང་ཚོས་མིར་ཡམ་ལ་“བུ་མོ། ཁྱོད་རང་ཅི་ལ་ངུ་”ཞེས་དྲིས་པས་ལན་དུ་ཁོ་མོས་“ཁོ་ཚོས་ངའི་གཙོ་བོ་ཕར་ཁྱེར་ནས་གང་དུ་བཞག་པ་མི་ཤེས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","མིར་ཡམ་ཁ་ཕྱིར་ལོག་སྟེ་ཡེ་ཤུ་དེར་བཞེངས་ནས་བཞུགས་ཡོད་པ་མཐོང་ཡང༌། ཡེ་ཤུ་ཡིན་པ་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ཡེ་ཤུས་ཁོ་མོར་“བུ་མོ། ཁྱོད་ཅི་ལ་ངུ༌། ཁྱོད་སུ་འཚོལ་”ཞེས་གསུངས་པ་དང༌། མིར་ཡམ་གྱིས་ཁོང་ནི་ཚལ་སྲུང་མཁན་ཡིན་པར་བསམས་ཏེ་“སྐུ་ཞབས་ལགས། གལ་ཏེ་ཁྱེད་ཀྱིས་ཁོང་འདི་ནས་ཕར་ཁྱེར་བ་ཡིན་ན། གང་དུ་བཞག་པ་ཤོད་དང༌། ངས་ཕར་འཁྱེར་བར་བྱ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ཡེ་ཤུས་ཁོ་མོར་“མིར་ཡམ་”ཞེས་གསུངས་པ་དང༌། ཁོ་མོས་ཁོང་གི་ཕྱོགས་སུ་བསྒྱུར་ཏེ་ཡ་ཧུ་དཱ་པའི་སྐད་དུ་“རབ་བུ་ནི་”ཞེས་བརྗོད། (དེ་ནི་སྟོན་པ་ལགས་ཞེས་པའི་དོན་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ཡེ་ཤུས་“ང་ད་དུང་ཡབ་ཀྱི་དྲུང་དུ་ཡར་མ་ཕྱིན་པས། ཁྱོད་ཀྱིས་ང་ལ་མ་ཟུངས་ཤིག ངའི་སྤུན་རྣམས་ཀྱི་དྲུང་དུ་སོང་སྟེ་ཁོ་ཚོར་ང་ནི་ང་རང་གི་ཡབ་དང་ཁྱེད་ཚོའི་ཡབ། ངའི་དཀོན་མཆོག་དང་ཁྱེད་ཚོའི་དཀོན་མཆོག་གི་དྲུང་དུ་ཡར་འགྲོའོ་ཞེས་གཏམ་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","མག་རྡལ་ནས་ཡིན་པའི་མིར་ཡམ་ཡོང་སྟེ་ཉེ་གནས་རྣམས་ལ་“ངས་གཙོ་བོ་མཇལ་བྱུང་”ཞེས་ཟེར་ཞིང༌། ཁོང་གིས་ཁོ་མོར་གང་གསུངས་པ་རྣམས་ཀྱང་ཁོ་ཚོ་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","བདུན་ཕྲག་གི་ཞག་དང་པོའི་དགོང་མོ་ཉེ་གནས་རྣམས་ཡ་ཧུ་དཱ་པ་ལ་འཇིགས་པས་གནས་དེའི་སྒོ་རྣམས་ཨ་ཤིང་བརྒྱབ་ཡོད་དུས། ཡེ་ཤུ་དེར་བྱོན་ཏེ་ཁོ་ཚོའི་དཀྱིལ་དུ་བཞེངས་ནས་“ཁྱེད་ཚོ་ཞི་བདེ་དང་ལྡན་པར་གྱུར་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ཁོང་གིས་དེ་ལྟར་གསུངས་ནས་རང་གི་ཕྱག་དང་གཞོགས་ཁོ་ཚོ་ལ་བསྟན་ཅིང༌། ཉེ་གནས་རྣམས་ཀྱིས་གཙོ་བོ་མཇལ་བས་སེམས་དགའ་བར་གྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","དེ་ནས་ཡེ་ཤུས་ཡང་བསྐྱར་“ཁྱེད་ཚོ་ཞི་བདེ་དང་ལྡན་པར་གྱུར་ཅིག ཡབ་ཀྱིས་ང་མངགས་པ་ལྟར་ངས་ཀྱང་ཁྱེད་ཚོ་མངག་”ཅེས་གསུངས་རྗེས། ");
INSERT INTO bod_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ཁོ་ཚོ་ལ་ཕུ་བསྐྱོན་ཏེ་“ཁྱེད་རྣམས་ལ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་འཐོབ་པར་གྱུར་ཅིག ");
INSERT INTO bod_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ཁྱེད་ཀྱིས་སུའི་སྡིག་ཉེས་བསལ་ན། དེ་ཚོའི་སྡིག་ཉེས་བསལ་ཟིན་ནོ། སུའི་སྡིག་ཉེས་མི་བསལ་ན། དེ་ལུས་པར་འགྱུར་རོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","འོན་ཀྱང་ཉེ་གནས་བཅུ་གཉིས་པོའི་ནང་ནས་མཚེ་མ་ཟེར་བའི་ཐོ་མཱ་ནི་ཡེ་ཤུ་ཕེབས་པའི་ཚེ་ཁོ་རྣམས་དང་མཉམ་དུ་མེད་པས། ");
INSERT INTO bod_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ཉེ་གནས་གཞན་པ་རྣམས་ཀྱིས་ཁོ་ལ་“ང་ཚོས་གཙོ་བོ་མཇལ་བྱུང་”ཞེས་ཟེར། འོན་ཀྱང་ཁོས་ཁོ་ཚོར་“གལ་ཏེ་ངས་ཁོང་གི་ཕྱག་ལ་གཟེར་གྱི་ཤུལ་མཐོང་བ་དང༌། ངའི་མཛུག་གུ་གཟེར་གྱི་ཤུལ་ལ་འཇུག་པ། ལག་པ་ཡང་ཁོང་གི་གཞོགས་ཀྱི་མདུང་ཤུལ་ནང་དུ་བཅུག་ན་མ་གཏོགས། ངས་རྩ་བ་ནས་ཡིད་ཆེས་མི་བྱེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","དེ་ནས་ཉིན་བརྒྱད་སོང་བ་དང༌། ཁོང་གི་ཉེ་གནས་རྣམས་ཡང་བསྐྱར་ནང་ལ་ཡོད་ཅིང༌། ཐོ་མཱ་ཡང་ཁོ་ཚོ་དང་མཉམ་དུ་ཡོད་པ་ཡིན། སྒོ་རྣམས་ལ་ཨ་ཤིང་བརྒྱབ་ཡོད་ཀྱང་ཡེ་ཤུ་དེར་བྱོན་ནས་ཁོ་ཚོའི་དཀྱིལ་དུ་བཞེངས་ཏེ་“ཁྱེད་ཚོ་ཞི་བདེ་དང་ལྡན་པར་གྱུར་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","དེ་ནས་ཁོང་གིས་ཐོ་མཱ་ལ་“ད་ཁྱོད་ཀྱི་མཛུག་གུ་འདིར་ཞོག་ཅིག ངའི་ལག་པ་ལ་ལྟོས། ཁྱོད་ཀྱིས་ལག་པ་བརྐྱངས་ཏེ་ངའི་གཞོགས་ཀྱི་ནང་དུ་ཆུག་ཅིག དད་མེད་ཀྱི་སེམས་སྤོངས་ལ་དད་པ་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ལན་དུ་ཐོ་མཱས་“ངའི་གཙོ་བོ་དང་ངའི་དཀོན་མཆོག་ལགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ཡེ་ཤུས་ཁོང་ལ་“ཁྱོད་ཀྱིས་ང་མཐོང་བས་དད་པ་བྱེད་པ་ཡིན་ནམ། ང་མི་མཐོང་ཡང་དད་པ་རྣམས་བདེའོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ཡང་མདོ་འདི་ལ་མ་བྲིས་པའི་རྟགས་གཞན་མང་པོ་ཡེ་ཤུས་ཉེ་གནས་རྣམས་ཀྱི་མདུན་དུ་མཛད། ");
INSERT INTO bod_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","འོན་ཀྱང་ཁྱེད་ཚོས་ཡེ་ཤུ་ནི་སྐྱབས་མགོན་མཱ་ཤི་ཀ་དང་དཀོན་མཆོག་གི་སྲས་དེ་ཡིན་པར་དད་པ་བྱེད་པའི་ཕྱིར་དོན་འདི་ཚོ་བྲིས་ཡོད་ཅིང༌། ཁོང་ལ་དད་པ་བྱེད་པའི་སྒོ་ནས་ཁྱེད་ཚོ་ཁོང་གི་མཚན་གྱི་ཐོག་ནས་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པའི་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","དེའི་རྗེས་སུ་ཡེ་ཤུས་ཡང་བསྐྱར་ཏི་པེར་ཡཱ་མཚོའི་འགྲམ་དུ་ཉེ་གནས་རྣམས་ལ་ཁོང་རང་མངོན་པར་མཛད། མངོན་པར་མཛད་ཚུལ་འདི་ལྟར་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","སི་མོན་པེ་ཏྲོ་དང༌། མཚེ་མ་ཟེར་བའི་ཐོ་མཱ། ག་ལིལ་ཡུལ་གྱི་ཀ་ནཱ་པ་ན་ཐན་ཨེལ། ཟེ་བད་ཡཱ་ཡི་བུ་གཉིས། ཁོང་གི་ཉེ་གནས་གཞན་གཉིས་བཅས་མཉམ་དུ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","སི་མོན་པེ་ཏྲོས་ཁོ་ཚོར་“ང་ཉ་འཛིན་དུ་འགྲོ་”ཞེས་ཟེར་བ་དང་ཁོ་ཚོས་“ང་ཚོ་ཡང་ཁྱོད་དང་མཉམ་དུ་འགྲོ་”ཞེས་བཤད། ཁོ་ཚོ་ཕྱི་རོལ་ཏུ་སོང་སྟེ་གྲུ་ལ་བསྡད་ཡང་མཚན་དེ་ལ་ཉ་ཅིའང་མ་བཟུང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ནམ་ལངས་པའི་ཚེ་ཡེ་ཤུ་མཚོའི་འགྲམ་དུ་བཞེངས་ཡོད་པ་ཡིན། འོན་ཀྱང་ཉེ་གནས་ཚོས་ཁོང་ཡིན་པར་ངོ་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ཡེ་ཤུས་ཁོ་ཚོར་“བུ་ཚོ། ཁྱོད་ཚོས་ཉ་ཟིན་མེད་དམ་”ཞེས་གསུངས་པ་དང་ཁོ་ཚོས་“ལགས་མེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ཁོང་གིས་ཁོ་ཚོར་“གྲུའི་གཡས་ཕྱོགས་སུ་དྲ་རྒྱ་ཕོངས་དང་རྙེད་པར་འགྱུར་”ཞེས་གསུངས་པ་ལ་ཁོ་ཚོས་དྲ་རྒྱ་འཕངས་ནས་ཉ་ཤིན་ཏུ་མང་པོ་བཟུང་བས་དྲ་རྒྱ་ཆུ་ནས་འཐེན་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","དེ་ནས་ཡེ་ཤུས་དམིགས་བསལ་གྱིས་བྱམས་པ་གནང་བའི་ཉེ་གནས་དེས་པེ་ཏྲོ་ལ་“གཙོ་བོ་ཡིན་”ཞེས་བཤད། སི་མོན་པེ་ཏྲོས་གཙོ་བོ་ཡིན་ཞེས་པ་ཐོས་ཏེ་ནང་གོས་ལས་མེད་པས། ཕྱི་གོས་གྱོན་པ་དང་མཚོའི་ནང་དུ་མཆོངས། ");
INSERT INTO bod_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ཉེ་གནས་གཞན་རྣམས་སྐམ་ས་ནས་སྨི་བརྒྱ་ཙམ་མ་གཏོགས་མེད་པས། ཉས་གང་བའི་དྲ་རྒྱ་དྲུད་དེ་ཡོང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ཡང་ཁོ་ཚོ་སྐམ་ས་ལ་སླེབས་ནས་སོལ་བའི་མེ་འབར་བའི་སྟེང་དུ་ཉ་ཤ་བཞག་ཡོད་པ་དང་བག་ལེབ་ཀྱང་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ཡེ་ཤུས་ཁོ་ཚོར་“ཁྱེད་ཚོས་ད་ལྟ་བཟུང་བའི་ཉ་ཁ་ཤས་འདིར་འཁྱེར་ཤོག་”ཅེས་གསུངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","སི་མོན་པེ་ཏྲོ་གྲུའི་ནང་ལ་སོང་ནས་ཉ་ཆེན་པོ་བརྒྱ་དང་ལྔ་བཅུ་ང་གསུམ་གྱིས་གང་བའི་དྲ་རྒྱ་དེ་སྐམ་ས་ལ་དྲུད། ཡང་ཉ་དེ་ཙམ་མང་པོ་ཡོད་ཀྱང་དྲ་རྒྱ་མ་རལ། ");
INSERT INTO bod_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ཡེ་ཤུས་ཁོ་ཚོར་“ཚུར་ཤོག་ལ་ཞོགས་ཟས་ཟོ་དང་”ཞེས་གསུངས། ཉེ་གནས་རྣམས་ཀྱིས་གཙོ་བོ་ཡིན་པར་ངོ་ཤེས་མོད་སུས་ཀྱང་ཁྱོད་སུ་ཡིན་ཞེས་བཀའ་འདྲི་ཞུ་བར་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ཡེ་ཤུ་ཕེབས་ནས་བག་ལེབ་བསྣམས་ཏེ་ཁོ་ཚོ་ལ་གནང་ཞིང་དེ་བཞིན་དུ་ཉ་ཤ་ཡང་གནང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ཡེ་ཤུ་གཤིན་པོ་ནས་སྐུ་གསོན་པོར་བཞེངས་སུ་གྱུར་བའི་རྗེས་སུ་ཉེ་གནས་རྣམས་ལ་ཁོང་མངོན་པར་མཛད་པའི་ལན་གསུམ་པ་དེ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ཁོ་ཚོས་ཞོགས་ཟས་བཞེས་ཚར་རྗེས་ཡེ་ཤུས་སི་མོན་པེ་ཏྲོ་ལ་“སི་མོན་ཡོ་ཧ་ནན་གྱི་བུ། ཁྱོད་ཀྱིས་འདི་ཚོ་ལས་ང་ལ་ལྷག་པར་བརྩེ་འམ་”ཞེས་གསུངས་པས་ལན་དུ་ཁོས་“གཙོ་བོ་ལགས། ངས་ཁྱེད་ལ་བརྩེ་བ་ཁྱེད་ཀྱིས་མཁྱེན་ནོ་”ཞེས་ཟེར་བ་དང༌། ཁོང་གིས་ཁོ་ལ་“ངའི་ལུ་གུ་རྣམས་འཚོ་བར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ཡང་ལན་གཉིས་པར་ཡེ་ཤུས་“སི་མོན་ཡོ་ཧ་ནན་གྱི་བུ། ཁྱོད་ཀྱིས་ང་ལ་བརྩེ་འམ་”ཞེས་གསུངས་པས་ཁོས་“གཙོ་བོ་ལགས། ངས་ཁྱེད་ལ་བརྩེ་བ་ཁྱེད་ཀྱིས་མཁྱེན་ནོ་”ཞེས་བཤད་པས་ཁོང་གིས་“ངའི་ལུག་རྣམས་འཚོ་བར་བྱོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ཡང་ལན་གསུམ་པར་ཡེ་ཤུས་“སི་མོན་ཡོ་ཧ་ནན་གྱི་བུ། ཁྱོད་ཀྱིས་ང་ལ་བརྩེ་འམ་”ཞེས་གསུངས་པ་དང༌། ཁྱོད་ཀྱིས་ང་ལ་བརྩེ་འམ་ཞེས་ལན་གསུམ་གསུངས་པས་པེ་ཏྲོ་སེམས་སྐྱོ་བར་གྱུར་ནས་ཁོང་ལ་“གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་དོན་ཚང་མ་མཁྱེན་ཏེ། ངས་ཁྱེད་ལ་བརྩེ་བ་མཁྱེན་ནོ་”ཞེས་བཤད་པ་དང་ཡེ་ཤུས་“ངའི་ལུག་རྣམས་འཚོ་བར་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ངས་ཁྱོད་ལ་བདེན་པ་བདེན་པར་ཟེར་རྒྱུར། ཁྱོད་གཞོན་པའི་དུས་སུ་རང་གི་སྐེད་རགས་རང་གིས་བཅིངས་ཏེ་གང་དུ་དགའ་བར་སོང་ཡང༌། རྒས་དུས་སུ་ཁྱོད་རང་གི་ལག་པ་བརྐྱངས་ནས་མི་གཞན་གྱིས་ཁྱོད་ཀྱི་སྐེད་རགས་འཆིང་སྟེ་ཁྱོད་མི་དགའ་བའི་གནས་སུ་འཁྲིད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ཡེ་ཤུས་པེ་ཏྲོ་ཤི་ལུགས་ནི་གང་གིས་དཀོན་མཆོག་གི་གཟི་བརྗིད་སྟོན་པའི་ཕྱིར་དེ་ལྟར་གསུངས་པའི་རྗེས་སུ་ཁོང་གིས་པེ་ཏྲོ་ལ་“ངའི་རྗེས་སུ་འབྲོངས་ཤིག་”ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","པེ་ཏྲོ་ཁ་ཕྱིར་སློག་པ་དང་ཡེ་ཤུས་དམིགས་བསལ་གྱིས་བྱམས་པ་གནང་བའི་ཉེ་གནས་དེས་སྔར་དགོང་ཟས་བཞེས་པའི་དུས་སུ་ཡེ་ཤུའི་རྩར་གཟུགས་པོ་ཡོ་ནས་གཙོ་བོ་ཁྱེད་དགྲའི་དབང་དུ་གཏོང་མཁན་སུ་ཡིན་ཞེས་དྲི་མཁན་དེ་ཡང་ཁོང་གི་རྗེས་སུ་འབྲངས་པར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","པེ་ཏྲོས་ཁོ་མཐོང་སྐབས་ཡེ་ཤུ་ལ་“གཙོ་བོ་ལགས། མི་འདི་ལ་ཅི་འབྱུང་ཡོང་”ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ཡེ་ཤུས་“གལ་ཏེ་ང་མ་ཡོང་བའི་བར་དུ་ཁོ་ལུས་པར་དགའ་ན། ཁྱོད་ལ་དོན་ཅི་ཡོད། ཁྱོད་རང་ངའི་རྗེས་སུ་འབྲོངས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","དེའི་ཕྱིར་ཉེ་གནས་དེ་འཆི་བར་མི་གྱུར་བའི་གཏམ་སྤུན་ཟླ་རྣམས་ཀྱི་ནང་ལ་ཁྱབ། འོན་ཀྱང་ཡེ་ཤུས་ཉེ་གནས་དེ་མི་ཤི་ཞེས་མ་གསུངས་ཀྱི། གལ་ཏེ་ང་མ་ཡོང་བའི་བར་དུ་ཁོ་གསོན་པོར་གནས་པར་དགའ་ན་ཁྱོད་ལ་དོན་ཅི་ཡོད་ཅེས་གསུངས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","འདི་ནི་དོན་འདི་ཚོ་ལ་དཔང་པོ་བྱེད་པ་དང་ཡི་གེ་འབྲི་མཁན་གྱི་ཉེ་གནས་ཡིན། ཡང་ཁོས་དཔང་པོ་བྱས་པ་དེ་བདེན་པ་ཡིན་པར་ངེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ཡེ་ཤུས་མཛད་པའི་འཕྲིན་ལས་གཞན་རྣམས་མང་བས། ངའི་བསམ་ཚུལ་ལ་དེ་ཐམས་ཅད་རེ་རེ་ནས་བྲིས་པ་ཡིན་ན། བྲིས་པའི་མདོ་རྣམས་ཐ་ན་འཇིག་རྟེན་ཡོངས་སུ་མི་ཤོང་ངོ༌། །");
INSERT INTO bod_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","ཀྱེ་མི་རྗེ་ཐེ་ཨོ་ཕི་ལུ། གཙོ་བོ་ཡེ་ཤུས་གང་མཛད་པ་དང་ཆོས་གང་གསུངས་པ་ཐམས་ཅད་འགོ་བརྩམས་པ་ནས་བཟུང༌། ཁོང་གིས་བདམས་པའི་སྐུ་ཚབ་རྣམས་ལ་དམ་པའི་ཐུགས་ཉིད་ཐོག་ནས་བཀའ་གནང་བའི་རྗེས་སུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་མ་འཕགས་པའི་ཉིན་མོའི་བར་དུ། ངས་མདོ་དང་པོར་བཀོད། ");
INSERT INTO bod_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","སྡུག་བསྔལ་མྱོང་བའི་རྗེས་སུ་ཁོང་འཆི་བ་ནས་སླར་གསོན་དུ་གྱུར་བའི་ར་སྤྲོད་མང་པོ་སྐུ་ཚབ་རྣམས་ལ་གསལ་པོར་བསྟན་ཞིང༌། ཉིན་བཞི་བཅུའི་རིང་ཁོང་གིས་ཁོ་ཚོར་མངོན་པར་མཛད་དེ་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་སྐོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ཡང་ཁོ་ཚོ་དང་མཉམ་དུ་བཞུགས་པའི་དུས་ཤིག་ལ་ཁོང་གིས་“ངས་ཁྱེད་ཚོར་སྔར་བཤད་པ་ལྟར་ངའི་ཡབ་ཀྱིས་ཞལ་ཆད་གནང་བ་དེ་མ་འགྲུབ་པའི་བར་དུ་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་ནས་མ་བྲལ་བར་སྒུག་སྟེ་སྡོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ཡོ་ཧ་ནན་གྱིས་ཆུ་ཡིས་ཁྲུས་གསོལ་གནང་བ་རེད། འོན་ཀྱང་ཉིན་མང་པོ་མ་འགོར་བར་ཁྱེད་རྣམས་ལ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྲུས་གསོལ་གནང་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ཡང་ལྷན་དུ་འཛོམས་ནས་ཁོ་ཚོས་ཡེ་ཤུ་ལ་“གཙོ་བོ། ད་ཁྱེད་ཀྱིས་ཡ་ཧུ་དཱ་པའི་རྒྱལ་སྲིད་སླར་གསོ་མཛད་དམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ལན་དུ་ཁོང་གིས་“ཡབ་ཀྱིས་རང་གི་དབང་ཆ་ལ་བརྟེན་ནས་བཀོད་པའི་དུས་དང་ནམ་དུས་ནི་ཁྱེད་ཀྱིས་ཤེས་པར་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ཡང་དམ་པའི་ཐུགས་ཉིད་ཁྱེད་རྣམས་ལ་འབབ་པའི་ཚེ་ཁྱེད་ཚོར་ནུས་མཐུ་འཐོབ་པས། ཡེ་རུ་ཤ་ལེམ་དང༌། ཡ་ཧུ་དཱ་ཡུལ་ཡོངས། ས་མར་ཡཱ་ཡུལ། ས་གཞི་མཐའ་མའི་བར་དུ་ངའི་དཔང་པོ་ཡིན་པར་འགྱུར་”ཞེས་གསུངས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ཁོ་ཚོའི་མཐོང་སར་ཁོང་ཡར་འཕགས་ནས་སྤྲིན་པ་ཞིག་གིས་ཁོང་བསུས་ཏེ་མི་མཐོང་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ཁོ་ཚོས་ནམ་མཁའི་ཕྱོགས་སུ་ནན་གྱིས་བལྟས་ཏེ་ཁོང་ཡར་ཕེབས་དུས་གློ་བུར་དུ་གོས་དཀར་པོ་གྱོན་པའི་མི་གཉིས་དེ་ཚོའི་འགྲམ་དུ་ཐོན། ");
INSERT INTO bod_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ཁོང་ཚོས་“ཀྱེ་ག་ལིལ་པ་རྣམས། ཅིའི་ཕྱིར་བསྡད་དེ་ནམ་མཁའི་ཕྱོགས་སུ་ལྟ། ཁྱེད་ཚོའི་མདུན་ནས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཡར་འཕགས་པ་གཙོ་བོ་ཡེ་ཤུ་ཉིད། ཇི་ལྟར་ཞིང་ཁམས་སུ་འཕགས་པ་མཐོང་བ་བཞིན། དེ་ལྟར་ཕྱིར་ལོག་ཕེབས་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","དེ་ནས་སྐུ་ཚབ་རྣམས་ཡེ་རུ་ཤ་ལེམ་དང་ཐག་ཉེ་བ་སྟེ་སྤྱི་ལེ་གཅིག་ཙམ་གྱི་ས་ལ་ཆགས་པའི་སྐྱུར་རུ་ཤིང་ཟེར་བའི་རི་ནས་ཡེ་རུ་ཤ་ལེམ་དུ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","གྲོང་ཁྱེར་ལ་སླེབས་ནས་ཁོང་ཚོའི་བཞུགས་སའི་ཐོག་ཁང་ནང་དུ་འཛུལ། ཁོང་རྣམས་ནི་པེ་ཏྲོ་དང༌། ཡོ་ཧ་ནན། ཡ་ཀོབ། ཨན་དྲི་ཡཱ། ཕི་ལིབ། ཐོ་མཱ། པར་ཐོ་ལོ་མཱ། མད་ཐཱ། ཨལ་ཕཱ་ཞེས་པ་དེའི་བུ་ཡ་ཀོབ། རྒྱལ་གཅེས་པའི་ཕྱོགས་ཁག་གི་ཁོངས་མི་སི་མོན་ཞེས་པ། ཡ་ཀོབ་ཀྱི་བུ་ཡུ་དཱ་བཅས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ཁོང་ཚོ་ཚང་མ་དང༌། གཙོ་བོ་ཡེ་ཤུའི་ཡུམ་མིར་ཡམ་ཚུད་པའི་བུད་མེད་དང༌། ཁོང་གི་གཅུང་པོ་རྣམས་དུས་རྒྱུན་དུ་འཛོམས་ནས་བློ་སེམས་གཅིག་མཐུན་གྱི་སྒོ་ནས་སྨོན་ལམ་འདེབས་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","དེའི་དུས་སུ་དད་ལྡན་བརྒྱ་དང་ཉི་ཤུ་ཙམ་ཚོགས་པའི་ཁྲོད་དུ་ཡར་ལངས་ནས་པེ་ཏྲོས་ ");
INSERT INTO bod_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“སྤུན་ཟླ་རྣམས། རྒྱལ་པོ་དཱ་བིད་ཀྱི་ཐོག་ནས་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་སྔར་མདོའི་ནང་ཡུ་དཱ་ཡི་སྐོར་གསུངས་པའི་བཀའ་འགྲུབ་དགོས། ཁོ་ནི་ང་ཚོའི་གྲལ་དུ་བརྩིས་ཏེ་ཞབས་ཏོག་འདིའི་སྐལ་བ་ཐོབ་མཁན་དང༌། གཙོ་བོ་ཡེ་ཤུ་འཛིན་མཁན་རྣམས་ཀྱི་ལམ་སྟོན་བྱེད་མཁན་དུ་གྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(ཁོས་བྱས་པའི་ལས་ངན་གྱི་གླ་ཐོབ་ནས་ཞིང་ཁ་ཞིག་ཉོས་པ་དང༌། དེར་ཁ་སྦུབ་ཏུ་ལྷུངས་ནས་གྲོད་ཁོག་གས་ཏེ་ནང་ཁྲོལ་ཐམས་ཅད་ཕྱིར་ཐོན། ");
INSERT INTO bod_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ཡེ་རུ་ཤ་ལེམ་ལ་སྡོད་མཁན་ཐམས་ཅད་ཀྱིས་དོན་དེའི་སྐོར་ཐོས་པས། ཞིང་དེའི་མིང་ནི་དེ་ཚོའི་སྐད་དུ་ཨ་ཀེལ་ད་མཱ་ཞེས་བཏགས། དེའི་དོན་ནི་ཁྲག་གི་ཞིང་ཁའོ་) ");
INSERT INTO bod_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","པེ་ཏྲོས་“གསུང་མགུར་གྱི་མདོ་ལས། ཁོ་ཡི་སྡོད་ས་སྟོང་བར་འགྱུར། ། སུ་ཡང་དེ་རུ་གནས་མ་ཆོག ། ཅེས་དང༌། ཡང༌། ཁོའི་ལས་འགན་གཞན་གྱིས་ལེན་པར་བྱོས་ཤིག ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","དེའི་ཕྱིར་ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་གནང་བ་ནས་བཟུང་སྟེ། ང་ཚོའི་མདུན་ནས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ཡར་འཕགས་པའི་ཉིན་མོའི་བར་དུ། དུས་ཚང་མར་གཙོ་བོ་ཡེ་ཤུ་དང་མཉམ་དུ་འགྲོགས་པའི་ངེད་རྣམས་ཀྱི་ནང་ནས་མི་ཞིག་བདམས་ཏེ་ཁོང་སླར་གསོན་པའི་དཔང་པོར་འགྱུར་དགོས་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ཁོང་ཚོ་ཚང་མས་པར་ས་པཱ་ཟེར་བའི་ཡོ་སེབ་(ཡུ་སི་ཏཱུ་ཡང་ཟེར་) དང༌། མ་ཐི་ཡཱ་ཟེར་མཁན་གཉིས་འོས་ཁོངས་སུ་ངོ་སྤྲོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","དེ་ནས་ཁོང་ཚོས་“ཀྱེ་གཙོ་བོ་ལགས། ཁྱེད་ཀྱིས་མི་ཚང་མའི་སེམས་མཁྱེན་པས། ཡུ་དཱ་ནི་འོས་པའི་གནས་སུ་འགྲོ་བའི་ཆེད་དུ་ལས་ཚན་དོར་བས། སྐུ་ཚབ་ཀྱི་ལས་འགན་བྱེད་པའི་ཕྱིར་མི་འདི་ཚོ་གཉིས་ལས་ཁྱེད་ཀྱིས་བདམས་པར་མཛད་ཟིན་པ་དེ་ང་ཚོར་སྟོན་པར་མཛོད་”ཅེས་སྨོན་ལམ་བཏབ་ནས། ");
INSERT INTO bod_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ཁོང་ཚོས་རྒྱན་བརྒྱབ་སྟེ་མ་ཐི་ཡཱ་ཡི་མིང་ཐོན་པས། ཁོང་སྐུ་ཚབ་བཅུ་གཅིག་པོའི་གྲལ་དུ་བརྩིས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ཉི་མ་ལྔ་བཅུ་པའི་དུས་ཆེན་ལ་སླེབས་སྐབས་ཁོ་ཚོ་ཚང་མ་ས་ཆ་གཅིག་ཏུ་འཛོམས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","གློ་བུར་དུ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ཧུར་ཧུར་དུ་རྒྱག་པའི་རླུང་དང་འདྲ་བའི་སྒྲ་ཞིག་བྱུང་བ་དང༌། དེས་ནི་ཁོ་ཚོ་སྡོད་སའི་ཁང་པ་ཆ་ཚང་ཁྱབ། ");
INSERT INTO bod_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","མེ་ལྟར་གྱི་ལྕེ་རྣམས་ཁོ་ཚོའི་མདུན་དུ་མངོན་སུམ་དུ་གྱུར་ནས་བྲལ་ཏེ་སོ་སོའི་སྟེང་ལ་གནས། ");
INSERT INTO bod_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོ་ཚོ་ཚང་མ་གང་བར་གྱུར་ཞིང༌། དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ནུས་མཐུ་གནང་བ་བཞིན་དུ་ཁོ་ཚོས་སྐད་རིགས་གཞན་རྣམས་སྤྱད་ནས་སྐད་ཆ་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ཡང་ནམ་མཁའི་འོག་ཏུ་མི་རིགས་ཀུན་ནས་སེམས་དྲང་པོ་དང་ཆོས་སེམས་དང་ལྡན་པའི་ཡ་ཧུ་དཱ་པ་རྣམས་ཡེ་རུ་ཤ་ལེམ་ལ་གནས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","སྒྲ་དེ་བྱུང་བས་མི་ཚོགས་མང་པོ་ཞིག་འཛོམས་ཤིང༌། དེ་རྣམས་ཀྱིས་རང་རང་གི་སྐད་དད་ལྡན་པ་རྣམས་ཀྱིས་བཤད་པར་ཐོས་ནས་ཐེ་ཚོམ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ཧ་ལས་ཏེ་ཡ་མཚན་ཆེན་པོར་གྱུར་བས་ཁོ་ཚོས་“གཏམ་ཤོད་མཁན་འདི་ཚོ་ཚང་མ་ག་ལིལ་པ་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ཡང་ཁོ་ཚོས་རང་རེའི་ཕ་སྐད་སྤྱད་ནས་གཏམ་བྱེད་པར་ང་ཚོས་ཐོས་པ་དེ་ཅི་ལ་སྲིད། ");
INSERT INTO bod_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ང་ཚོ་པར་ཐ་དང༌། མེཌ་ཡཱ། ཨེ་ལཱམ། མེ་སུའོ་པི་ཏ་མེ་ཡཱ། ཡ་ཧུ་དཱ། ཀ་པ་དོག་ཡཱ། པོན་ཏུ། ཨེ་ཞེ་ཡཱ། ");
INSERT INTO bod_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ཕ་རུག་ཡཱ། ཕམ་ཕིལ་ཡཱ། ཨེ་ཇེབ། སེ་རེ་ནཱ་གྲོང་ཁྱེར་དང་ཉེ་བའི་ལིབ་ཡཱ་ཡུལ་པ། རོ་མཱ་གྲོང་ཁྱེར་ནས་ཡོང་བའི་ཡ་ཧུ་དཱ་དང་ཡ་ཧུ་དཱ་པའི་ཆོས་ལུགས་ལ་ཞུགས་པའི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས། ");
INSERT INTO bod_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ཀེ་རེ་ཊེ་དང༌། ཨ་རབ་པ་རྣམས་བཅས་མི་དེ་ཚོས་ང་ཚོ་རང་རང་གི་སྐད་ལ་དཀོན་མཆོག་གི་ངོ་མཚར་ཆེ་བའི་མཛད་པ་སྒྲོག་པར་ཐོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ཡང་ཁོ་ཚོ་ཚང་མ་ཧ་ལས་ཏེ་ཐེ་ཚོམ་སྐྱེས་པས་གཅིག་གིས་གཅིག་ལ་“འདིའི་དོན་ཅི་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","འོན་ཀྱང་གཞན་པ་རྣམས་ཀྱིས་ཁྲེལ་དགོད་བྱས་ཏེ་“ཁོ་ཚོ་རྒུན་ཆང་མངར་མོས་བཟི་བ་ཡིན་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","དེ་ནས་པེ་ཏྲོས་སྐུ་ཚབ་བཅུ་གཅིག་པོ་དང་མཉམ་དུ་ལངས་ཏེ་སྐད་ཆེན་པོས་མི་ཚོགས་ལ་“ཡ་ཧུ་དཱ་ཡུལ་པ་དང་ཡེ་རུ་ཤ་ལེམ་ལ་གནས་པ་ཐམས་ཅད། ངས་དོན་འདི་གསལ་བཤད་བྱེད་རྒྱུ་ཡིན་པས་ང་ལ་ནན་གྱིས་ཉོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ད་ལྟ་ཞོགས་པའི་ཆུ་ཚོད་དགུ་པ་ལས་མ་ཡིན་པས་ཁྱེད་ཚོའི་སེམས་ལ་མི་འདི་ཚོ་ཆང་གིས་ར་བཟི་བར་སྙམ་ན་ཡང་དེ་ལྟར་མིན། ");
INSERT INTO bod_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","དེ་ལས་ལྡོག་སྟེ་ཁྱེད་ཀྱིས་གང་ཐོས་པ་དེ་ལུང་སྟོན་པ་ཡོ་ཨེལ་གྱིས་ལུང་བསྟན་དང་མཐུན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","དཀོན་མཆོག་གིས་ནམ་དུས་མཐའ་མའི་སྐབས་སུ། ། ཁོང་གི་བཀའ་བསྩལ་ང་ཡི་ཐུགས་ཉིད་དེ། ། མི་ཡི་རིགས་ཅན་ཀུན་ལ་གནང་འགྱུར་ཏེ། ། ཁྱེད་ཀྱི་བུ་དང་བུ་མོས་ལུང་བསྟན་ཞིང༌། ། སྐྱེས་པ་གཞོན་ནུ་རྣམས་ལ་ཞལ་གཟིགས་འོང༌། ། ཁྱེད་ཀྱི་རྒན་རྒོན་རྣམས་ལ་རྨི་ལམ་འབྱུང༌། ། ");
INSERT INTO bod_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","དུས་དེར་ང་ཡི་གཡོག་པོ་གཡོག་མོ་ལའང༌། ། ང་ཡི་ཐུགས་ཉིད་བསྩལ་གནང་འགྱུར་ནས་ནི། ། དེ་དག་གིས་ཀྱང་ལུང་བསྟན་འཆད་ངེས་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ང་ཡིས་ནམ་མཁར་ངོ་མཚར་བྱ་བ་དང༌། ། ས་སྟེང་འདི་རུ་གྲུབ་རྟགས་སྟོན་པར་འགྱུར། ། ཁྲག་དང་མེ་དང་དུད་རླངས་འབྱུང་བར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","གཙོ་བོའི་ཁྱད་འཕགས་ཉིན་མོ་མ་ཟིན་བར། ། ཉི་མ་མུན་དང་ཟླ་བ་ཁྲག་ཏུ་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","དེ་དུས་གཙོ་བོའི་མཚན་ནས་བརྗོད་མཁན་རྣམས། ། སྐྱབས་ནས་ཐར་པ་ཐོབ་པར་ཐེ་ཚོམ་མེད། ། ཅེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ཀྱེ་ཡི་སི་ར་ཨེལ་པ་རྣམས། ངའི་གཏམ་ལ་ཉོན་ཅིག ཁྱེད་ཀྱིས་ཤེས་གསལ་ལྟར་ཁྱེད་ཚོའི་དཀྱིལ་ལ་ན་ཙ་རེལ་པ་ཡེ་ཤུས་ནུས་མཐུ་ལྡན་པའི་མཛད་པ་དང༌། ངོ་མཚར་ཅན་གྱི་དོན། གྲུབ་རྟགས་བཅས་མཛད། དཀོན་མཆོག་གིས་དེའི་སྒོ་ནས་གཙོ་བོ་ཡེ་ཤུ་ནི་ཁོང་གིས་མངགས་པ་ཡིན་པ་གསལ་པོར་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","དེ་ཡང་ཁོང་ནི་དཀོན་མཆོག་གི་དགོངས་པ་དང་སྔོན་དུ་མཁྱེན་པ་ལྟར་ཁྱོད་རྣམས་ལ་གཏད་དེ། ཁྱོད་ཀྱིས་ཆོས་ཁྲིམས་མེད་པ་རྣམས་ཀྱི་ལག་པའི་སྒོ་ནས་རྒྱང་ཤིང་སྒང་ལ་གཟེར་བརྒྱབ་སྟེ་བཀྲོངས་སུ་བཅུག་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","འཆི་བའི་སྡུག་བསྔལ་ལས་སྒྲོལ་བར་མཛད་ནས་དཀོན་མཆོག་གིས་ཁོང་བསླངས། གང་ལགས་ཤེ་ན། འཆི་བའི་དབང་གིས་ཁོང་འཛིན་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","དེའི་ཕྱིར་རྒྱལ་པོ་དཱ་བིད་ཀྱིས་ཁོང་གི་སྐོར་ལ། རྟག་ཏུ་གཙོ་བོ་ང་ཡི་མདུན་དུ་མཐོང༌། ། ཁོང་ནི་ང་ཡི་གཡས་སུ་བཞུགས་འགྱུར་བས། ། ང་ནི་གཡོ་མེད་བརྟན་པོར་གནས་པར་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","དེར་བརྟེན་ངའི་སེམས་དགའ་ཞིང་ངག་ནས་བསྟོད། ། ང་ཡི་ལུས་ཀྱང་རེ་བའི་ནང་དུ་གནས། ། ");
INSERT INTO bod_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ཁྱེད་ཀྱི་སྐྱེས་བུ་དམ་པ་མི་འཇིག་ལ། ། ངའི་སེམས་གཤིན་པོའི་གནས་སུ་དོར་མི་འགྱུར། ། ");
INSERT INTO bod_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ཁྱེད་ཀྱིས་ཚེ་ཡི་ལམ་ཁ་ང་ལ་བསྟན། ། མཉམ་དུ་འགྲོགས་པས་དགའ་སྤྲོ་ཁྱབ་པར་འགྱུར། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ཀྱེ་སྤུན་ཟླ་རྣམས། ང་ཚོའི་མེས་པོ་དཱ་བིད་གྲོངས་ནས་ཁོང་གི་སྐུ་སྤུར་ད་ལྟའི་བར་དུ་གནས་པའི་དུར་ཁང་ནང་དུ་བཅུག་པར་ངས་ཁྱེད་ཚོར་ཡིད་རྟོན་བྱས་ནས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","དཱ་བིད་ནི་ལུང་སྟོན་པ་ཞིག་ཡིན་པས་དཀོན་མཆོག་གིས་ཁོང་ལ་རང་གི་བུ་རྒྱུད་ལས་གཅིག་བཞུགས་ཁྲིར་སྐོ་བའི་མནའ་བཞེས་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","མཱ་ཤི་ཀ་སླར་གསོན་དུ་འགྱུར་བའི་སྐོར་སྔོན་དུ་མཁྱེན་པས་རྒྱལ་པོ་དཱ་བིད་ཀྱིས་ཁོང་ནི་གཤིན་པོའི་ཁམས་ལ་མ་བོར་ཞིང༌། ཁོང་གི་ཤ་ལུས་ཀྱང་རུལ་བར་མ་གནང་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","དཀོན་མཆོག་གིས་གཙོ་བོ་ཡེ་ཤུ་དེ་ཉིད་གསོན་པོར་བསླངས་པ་ལ་ང་ཚོ་ཚང་མས་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་འཕགས་ཏེ་ཡབ་ནས་དམ་པའི་ཐུགས་ཉིད་གནང་རྒྱུ་ཡིན་པའི་ཞལ་ཆད་ཐོབ་ནས་ཁྱེད་ཀྱིས་མཐོང་བ་དང་ཐོས་པ་འདི་ཁོང་གིས་འབྱུང་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","རྒྱུ་མཚན་ནི་རྒྱལ་པོ་དཱ་བིད་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་འཕགས་མ་མྱོང་ཡང༌། ཁོང་ཉིད་ཀྱིས། དཀོན་མཆོག་གིས་ནི་ང་ཡི་གཙོ་བོ་ལ། ། ང་ཡིས་ཁྱེད་ཀྱི་དགྲ་ཚོགས་བཅོམ་ནས་ནི། ། ཁྱེད་ཀྱི་ཞབས་སྟེགས་འོག་ཏུ་མ་བཅུག་བར། ། ཁྱེད་ངའི་གཡས་སུ་བཞུགས་པར་འགྱུར་ཞིག་ཨང༌། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","དེའི་ཕྱིར་ཁྱེད་རྣམས་ཀྱིས་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་པའི་ཡེ་ཤུ་འདི་ནི་དཀོན་མཆོག་གིས་གཙོ་བོ་དང་སྐྱབས་མགོན་མཱ་ཤི་ཀར་བསྐོས་པ་ཡིན་པར་ཡི་སི་ར་ཨེལ་ཡོངས་ཀྱིས་ནན་ཏན་གྱིས་ཤེས་པར་གྱིས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","དེ་ཐོས་ནས་ཁོ་ཚོ་སེམས་ཤིན་ཏུ་འཁྲུགས་པས་པེ་ཏྲོ་དང་སྐུ་ཚབ་གཞན་རྣམས་ལ་“སྤུན་ཟླ་རྣམས། ང་ཚོས་ཅི་བྱ་”ཞེས་སྨྲས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","པེ་ཏྲོས་ཁོ་ཚོར་“སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་སྒྱུར་ལ་ཁྱེད་ཀྱི་སྡིག་ཉེས་སེལ་བའི་ཕྱིར་རེ་རེས་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་གྱི་ཐོག་ནས་ཁྲུས་གསོལ་ལོངས་ཤིག་དང༌། ཁྱེད་རྣམས་ལ་དཀོན་མཆོག་གི་གནང་སྦྱིན་ཏེ་དམ་པའི་ཐུགས་ཉིད་འཐོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","གང་ཡིན་ཞེ་ན། ཞལ་ཆད་འདི་ནི་ཁྱེད་དང༌། ཁྱེད་ཀྱི་བུ་རྒྱུད། ཐག་རིང་དུ་སྡོད་པའི་མི་ཐམས་ཅད་དེ། ང་ཚོའི་གཙོ་བོ་དཀོན་མཆོག་གིས་རང་ལ་འབོད་གནང་བའི་མི་སུ་ལ་ཡང་གནང་བ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ཡང་ཁོང་གིས་གཏམ་གཞན་མང་པོས་དཔང་པོ་བྱས་ཏེ་ཁོ་ཚོར་“མི་རབས་ངན་པ་འདི་ལས་ཐར་བར་འགྱུར་ཞིག་”ཅེས་ཡང་ཡང་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","དེ་ནས་ཁོང་གིས་གསུངས་པའི་བཀའ་དང་ལེན་བྱེད་མཁན་རྣམས་ཀྱིས་ཁྲུས་གསོལ་བླངས་ཤིང༌། ཉིན་མོ་དེར་མི་གསུམ་སྟོང་ཙམ་ཁོ་ཚོའི་གྲལ་དུ་ཞུགས། ");
INSERT INTO bod_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ཡང་ཁོ་རྣམས་ལ་སྐུ་ཚབ་ཀྱི་ཆོས་བསྟན་པ་དང༌། དད་ལྡན་དང་འགྲོགས་པ། བག་ལེབ་བགོས་པ། སྨོན་ལམ་འདེབས་པར་བརྩོན་སེམས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","དཀོན་མཆོག་གིས་སྐུ་ཚབ་རྣམས་བརྒྱུད་ནས་རྟགས་དང་ངོ་མཚར་བའི་དོན་མང་པོ་བསྟན་པས། མི་ཐམས་ཅད་འཇིགས་ཏེ་དཀོན་མཆོག་ལ་བཀུར་སྟི་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ཡང་དད་ལྡན་ཐམས་ཅད་འགྲོགས་ཏེ་ནོར་རྫས་ཡོད་ཚད་ཐུན་མོང་དུ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ནོར་རྫས་དང་ས་ཞིང་བཙོངས་ནས་མི་ཐམས་ཅད་ཀྱི་ནང་ལ་དགོས་པ་བཞིན་དུ་བགོ་བཤའ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","ཉིན་རེར་ཁོ་རྣམས་མཆོད་ཁང་གི་ཁྱམས་རར་འཛོམས། ཁྱིམ་ཚང་ནང་བག་ལེབ་བགོས་པ་དང༌། སེམས་དགའ་ཞིང་དྲིན་གཟོའི་སེམས་ཀྱིས་མཉམ་དུ་ཟ་སྟེ། དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་ཞིང༌། མི་ཐམས་ཅད་ཀྱིས་ཁོ་རྣམས་ལ་མོས་མཐུན་བྱས། གཙོ་བོས་ཉིན་རེ་བཞིན་ཐར་བར་གྱུར་བ་རྣམས་ཁོ་ཚོའི་གྲལ་དུ་ཞུགས་པར་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ཉིན་ཞིག་སྐུ་ཚབ་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གཉིས་ཕྱི་དྲོའི་ཆུ་ཚོད་གསུམ་པའི་སྨོན་ལམ་འདེབས་པའི་དུས་སུ་མཆོད་ཁང་ལ་ཡར་ཕེབས་པའི་ཚེ། ");
INSERT INTO bod_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","མི་རྣམས་ཀྱིས་སྐྱེས་དུས་ནས་ཞ་བོ་ཡིན་པ་ཞིག་ཁུར་ཏེ་ཡོང༌། ཞ་བོ་དེས་མཆོད་ཁང་ལ་འགྲོ་མཁན་རྣམས་ལ་སློང་བའི་ཆེད་དུ་ཁོ་ཚོས་མཛེས་པ་ཞེས་ཟེར་བའི་རྒྱལ་སྒོར་ཉིན་ལྟར་བཞག ");
INSERT INTO bod_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ཞ་བོ་དེས་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་མཆོད་ཁང་གི་ཁྱམས་རའི་ནང་དུ་ཕེབས་གྲབས་ཡོད་པ་མཐོང་ནས་སྦྱིན་པ་སློང༌། ");
INSERT INTO bod_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","འོན་ཀྱང་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གཉིས་ཀྱིས་ཁོ་ལ་ནན་གྱིས་བལྟས་ཏེ་པེ་ཏྲོས་“ང་ཚོར་ལྟོས་དང་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","སྦྱིན་པ་འཐོབ་པར་རེ་བ་བྱས་ཏེ། མི་དེས་ཁོང་ཚོར་དོ་སྣང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","པེ་ཏྲོས་“དངུལ་ཡང་ན་གསེར་ང་ལ་མེད་ཀྱང༌། ང་ལ་ཡོད་པ་དེ་ཁྱེད་ལ་སྟེར་རྒྱུ་ཡིན། ན་ཙ་རེལ་པ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་གྱི་ཐོག་ནས་ཡར་ལོངས་ལ་སོང་ཞིག་”ཅེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ཁོང་གིས་ཁོའི་ལག་པ་གཡས་པ་ནས་བཟུང་སྟེ་ཡར་བསྐྱོར་བ་དང་ལངས་སུ་བཅུག འཕྲལ་དུ་ཁོའི་རྐང་པ་བརྟན་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ཡར་མཆོངས་ཤིང་ལངས་ནས་འགྲོ་ཐུབ་པར་གྱུར། དེ་ནས་གོམ་པ་སྤོས་པ་དང་མཆོངས་ནས་དཀོན་མཆོག་ལ་བསྟོད་དེ་མཆོད་ཁང་གི་ཁྱམས་རའི་ནང་དུ་ཁོང་ཚོ་དང་མཉམ་དུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","མི་ཐམས་ཅད་ཀྱིས་མི་དེ་འགྲོ་བ་དང་དཀོན་མཆོག་ལ་བསྟོད་པར་མཐོང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","སྔར་མི་རྣམས་ལ་སློང་བའི་ཆེད་དུ་མཛེས་པའི་རྒྱལ་སྒོར་སྡོད་མཁན་སྤྲང་པོ་ཡིན་པར་ངོ་ཤེས་པས། ཁོ་ལ་ཅི་བྱུང་བར་ཧ་ལས་ཤིང་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","མི་དེས་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་བཟུང་བཞིན་ཡོད་དུས་མི་ཐམས་ཅད་ཡོངས་སུ་ཧ་ལས་ཤིང༌། ཁོང་ཚོའི་རྩར་སོ་ལོ་མོན་གྱི་གཡབ་རིང་ཞེས་བྱ་བར་རྒྱུག་ནས་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","པེ་ཏྲོས་དེ་མཐོང་ནས་མི་རྣམས་ལ་“ཀྱེ་ཡི་སི་ར་ཨེལ་པ་རྣམས། དོན་འདི་ལ་ཅིའི་ཕྱིར་ཡ་མཚན་སྐྱེས་ལ་ང་ཚོར་ནན་གྱིས་ལྟ། ངེད་གཉིས་ཀྱི་ནུས་མཐུའམ་ཆོས་སེམས་ཀྱི་སྒོ་ནས་མི་འདི་འགྲོ་ཐུབ་པར་གྱུར་སྙམ་མམ། ");
INSERT INTO bod_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ང་ཚོའི་མེས་པོ་ཨབ་ར་ཧམ་དང༌། ཨི་སཱག་དང༌། ཡ་ཀོབ་བཅས་ཀྱི་དཀོན་མཆོག་གིས་ཁོང་གི་ཞབས་ཕྱི་ཡེ་ཤུ་འཕགས་པར་མཛད་པ་ཡིན། སྔར་པི་ལ་ཏུ་ཡིས་ཡེ་ཤུ་གློད་པར་ཐག་གཅོད་བྱས་ཟིན་ཡང༌། པི་ལ་ཏུའི་མདུན་དུ་ཁྱོད་རྣམས་ཀྱིས་ཁོང་དགྲ་བོར་གཏད་ནས་དོར། ");
INSERT INTO bod_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ཁྱོད་རྣམས་ཀྱིས་སྐྱེས་བུ་དམ་པ་དང་རྣམ་པར་དག་པ་དེ་དོར་ནས་མི་གསོད་མཁན་ཅིག་གློད་པར་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ཚེ་སྲོག་གི་འགོད་པ་པོ་དེ་བསད། དཀོན་མཆོག་གིས་ཁོང་འཆི་བ་ནས་སླར་གསོན་པོར་མཛད་པ་ལ་ང་ཚོས་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ཁྱེད་ཀྱིས་མཐོང་བ་དང༌། ངོ་ཤེས་པའི་མི་འདི་གཙོ་བོ་ཡེ་ཤུའི་མཚན་ལ་དད་པའི་སྒོ་ནས་གསོས་པར་འགྱུར། ཁོང་གི་མཚན་དང༌། ཁོང་བརྒྱུད་ནས་བྱུང་བའི་དད་པ་ཡིས་ཁྱེད་ཚོའི་མདུན་དུ་མི་འདི་ཁམས་བཟང་པོར་མཛད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ད་སྤུན་ཟླ་རྣམས། ཁྱེད་དང་ཁྱེད་ཀྱི་དཔོན་པོ་རྣམས་ཀྱིས་དོན་ལ་རྨོངས་པའི་སྒོ་ནས་དེ་བཞིན་དུ་བྱས་པར་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","དཀོན་མཆོག་གིས་སྔར་ལུང་སྟོན་པ་ཐམས་ཅད་ཀྱི་བཀའ་བརྒྱུད་ནས་རང་གིས་མངགས་པའི་མཱ་ཤི་ཀ་སྡུག་བསྔལ་མྱོང་དགོས་ཞེས་གསུངས་པ་ནི། དེ་བཞིན་དུ་དཀོན་མཆོག་གིས་བསྒྲུབས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","དེ་བས་ན་ཁྱེད་ཚོས་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་སྒྱུར་ཞིང་དཀོན་མཆོག་ལ་བློ་སེམས་གཏོད་དང༌། དེ་ནི་ཁྱེད་ཀྱི་སྡིག་ཉེས་སེལ་བར་འགྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","དཀོན་མཆོག་གི་མདུན་ནས་ལྷོད་པའི་དུས་ལ་འབབ་ཞིང༌། ཁོང་གིས་ཁྱེད་རྣམས་ཀྱི་དོན་དུ་བསྐོས་པའི་མཱ་ཤི་ཀ་སྟེ་ཡེ་ཤུ་མངག་རྒྱུ་ཡིན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ཁོང་ནི་དམ་པའི་ལུང་སྟོན་པའི་བཀའ་ཡི་སྒོ་ནས་དཀོན་མཆོག་གིས་གནའ་བོ་ནས་གསུངས་པའི་དོན་ཐམས་ཅད་སླར་གསོ་བའི་དུས་མ་འབབ་པའི་བར་དུ། དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་བཞུགས་དགོས། ");
INSERT INTO bod_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་གཙོ་བོ་ཁྱེད་ཀྱི་དཀོན་མཆོག་གིས་ཁྱེད་ཚོའི་དོན་ལ་ང་བཞིན་དུ་ལུང་སྟོན་པ་ཞིག་ཁྱེད་ཚོའི་ནང་ནས་བསྐོ་བར་འགྱུར་ཞིང༌། ཁོང་གིས་གསུང་བའི་བཀའ་ཐམས་ཅད་ལ་ཁྱོད་ཀྱིས་ཉན་དགོས། ");
INSERT INTO bod_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ལུང་སྟོན་པ་དེའི་བཀའ་ལ་མི་ཉན་མཁན་ནི་དཀོན་མཆོག་གི་མི་རྣམས་དང་བྲལ་ནས་ཡོངས་སུ་འཇིག་པར་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ཡང་ཤ་མུ་ཨེལ་དང་ཁོང་གི་རྒྱུན་འཛིན་པ་རྣམས་ཀྱི་དུས་ནས་བཟུང་ལུང་སྟོན་པ་ཡོད་ཚད་ཀྱིས་དུས་འདིའི་སྐོར་ལུང་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","དཀོན་མཆོག་གིས་མེས་པོ་ཨབ་ར་ཧམ་ལ་ཁྱེད་ཀྱི་བུ་རྒྱུད་ནས་ས་སྟེང་གི་མི་རིགས་ཐམས་ཅད་ལ་བྱིན་རླབས་འབྱུང་བར་འགྱུར་ཞེས་གསུངས་པས། ཁྱེད་ཚོ་ནི་ལུང་སྟོན་པ་རྣམས་ཀྱི་བུ་རྒྱུད་དང༌། དཀོན་མཆོག་གིས་ཁྱེད་ཀྱི་མེས་པོ་ལ་གནང་བའི་ཞལ་ཆད་ཀྱི་འཐོབ་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","དཀོན་མཆོག་གིས་ཁོང་གི་ཞབས་ཕྱི་ཡེ་ཤུ་མངག་སྐབས་སུ་ཁྱེད་ཚོར་ཐོག་མར་བཏང་བར་མཛད། དེ་ནི་མི་རེ་རེ་ངན་སེམས་ལས་སྒྱུར་དུ་བཅུག་ནས་ཁྱེད་རྣམས་ལ་བྱིན་གྱིས་རླབས་པའི་ཆེད་དུ་ཡིན་”ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གྱིས་མི་ཚོགས་ལ་གཏམ་བྱེད་པའི་དུས་སུ་ཡ་ཧུ་དཱ་པའི་བླ་མ་རྣམས་དང༌། སཱ་ཅུ་སེ་པའི་ཕྱོགས་ཁག་ནང་ནས་ཁ་ཅིག་དང༌། མཆོད་ཁང་གི་སྲུང་དམག་གི་དཔོན་པོ་ཁོ་ཚོའི་འཁྲིས་སུ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ཁོང་གཉིས་ཀྱིས་གཙོ་བོ་ཡེ་ཤུའི་ཐོག་ནས་འཆི་བ་ལས་སླར་གསོན་པ་ཡོད་པར་བསྒྲགས་ཏེ་མི་རྣམས་ལ་ཆོས་བསྟན་གནང་བས་ཁོ་ཚོ་སེམས་ཤིན་ཏུ་འཁྲུགས་པས། ");
INSERT INTO bod_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ཁོང་ཚོ་འཛིན་བཟུང་བྱས་པ་དང༌། དགོང་དྲོ་ཟིན་ཚར་བས་དེའི་སང་ཉིན་གྱི་བར་བཙོན་ཁང་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","འོན་ཀྱང་བཀའ་དེ་ཐོས་མཁན་གྱི་ནང་ནས་མི་མང་པོ་ཞིག་གིས་དད་པ་བྱས་ཏེ། དད་ལྡན་རྣམས་ཀྱི་གྲལ་དུ་སྐྱེས་པ་རྣམས་ཀྱི་གྲངས་ལྔ་སྟོང་ཙམ་དུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","དེའི་ཕྱི་ཉིན་ཁོ་ཚོའི་དཔོན་པོ་དང༌། རྒན་པོ། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས། ");
INSERT INTO bod_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་གཙོ་བོ་ཨ་ན་སི། ཀ་ཡ་ཕཱ། ཡོ་ཧ་ནན། ཨ་ལིག་ཟན་ཌེར། བླ་ཆེན་གཙོ་བོའི་ནང་མི་ཐམས་ཅད་ཡེ་རུ་ཤ་ལེམ་དུ་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","བཙོན་པ་དེ་གཉིས་ཁོ་ཚོའི་དཀྱིལ་ལ་བཞག་ནས་ཁོ་ཚོས་“ནུས་མཐུ་གང་ངམ། སུའི་མིང་ལ་བརྟེན་ནས་ཁྱོད་ཚོས་དོན་འདི་བསྒྲུབས་པ་ཡིན་ནམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","སྐུ་ཚབ་པེ་ཏྲོ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་གྱུར་ནས་ཁོ་ཚོར་“ཀྱེ་དཔོན་རིགས་དང་རྒན་པོ་རྣམས། ");
INSERT INTO bod_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","གལ་ཏེ་ནད་པ་ཞིག་ལ་འཕྲིན་ལས་བྱས་པ་དང༌། ཅི་ལྟར་བྱས་ཏེ་ཁོ་གསོས་པར་གྱུར་བའི་སྐོར་ལ་ཁྱེད་རྣམས་ཀྱིས་ང་ཚོར་དེ་རིང་འདྲི་གཅོད་བྱས་ན། ");
INSERT INTO bod_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ཁྱོད་རྣམས་ཀྱིས་རྒྱང་ཤིང་སྒང་ལ་བསད་ནས་དཀོན་མཆོག་གིས་འཆི་བ་ནས་གསོན་པོར་ལང་དུ་མཛད་པ་ན་ཙ་རེལ་པ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་གྱི་ཐོག་ནས་མི་འདི་ཁྱེད་ཀྱི་མདུན་དུ་ཁམས་བཟང་པོར་བཞུགས་པ་ཁྱེད་ཚོ་དང༌། ཡི་སི་ར་ཨེལ་གྱི་མི་ཚང་མས་ཤེས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ཡེ་ཤུ་ནི་གསུང་རབ་ལྟར་ཁྱོད་ཚོ་བཟོ་པ་རྣམས་ཀྱིས་དོར་བའི་རྡོ་སྟེ་རྨང་རྡོར་གྱུར་བ་དེ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ཐར་པ་ནི་གཞན་སུ་ཡང་ལས་འབྱུང་མི་སྲིད། གང་ཡིན་ཞེ་ན། ང་ཚོ་ཐར་བར་འགྱུར་བའི་ཆེད་དུ་མི་རྣམས་ཀྱི་ནང་ནས་མཚན་འདི་མ་གཏོགས་པར་གཞན་ཞིག་གནམ་འོག་ཏུ་གནང་བ་མ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ཁོ་རྣམས་ཀྱིས་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གྱིས་བློ་སྟོབས་ཆེན་པོས་གསུངས་པར་མཐོང་བ་དང༌། ཁོང་ཚོ་སློབ་གསོ་མྱོང་མེད་པའི་མི་སེར་ཡིན་པར་རྟོགས་ཏེ། ཡ་མཚན་ཆེན་པོ་སྐྱེས་ནས་དེ་གཉིས་གཙོ་བོ་ཡེ་ཤུ་དང་འགྲོགས་མྱོང་བ་ཡིན་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ཡང་ཞ་བོ་ནད་ལས་གསོས་པར་གྱུར་བ་དེ་ཁོ་ཚོའི་དཀྱིལ་ལ་ལངས་ཏེ་སྡོད་པ་མཐོང་བས་ཁོ་ཚོས་ལན་ཅི་ཡང་བརྗོད་མ་ཐུབ་རྐྱེན། ");
INSERT INTO bod_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ཁོང་ཚོས་ཁོ་གཉིས་གྲོས་ཚོགས་ཁང་ནས་ཕྱི་རུ་འདོན་པའི་བཀའ་བཏང་ནས། གཅིག་གིས་གཅིག་ལ་གཏམ་གླེང་བྱས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ངེད་རྣམས་ཀྱིས་མི་འདི་གཉིས་ལ་ཅི་བྱེད་པར་བྱ། ཡེ་རུ་ཤ་ལེམ་ལ་སྡོད་མཁན་ཀུན་གྱིས་ངོ་མཚར་བའི་རྟགས་བསྒྲུབས་པ་ཡིན་པར་ཤེས་པས་ང་ཚོས་དེ་མ་བྱུང་ཞེས་ཟེར་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","འོན་ཀྱང་དོན་འདི་མི་རྣམས་ཀྱི་ཁྲོད་དུ་སྔར་ལས་ལྷག་པ་མི་ཁྱབ་པའི་ཆེད་དུ་ང་ཚོས་ཁོ་རྣམས་ལ་ད་ནས་བཟུང་མཚན་འདིའི་ཐོག་ནས་སུ་ལ་ཡང་མི་འཆད་པའི་ཐ་ཚིག་བྱེད་རྒྱུ་ཡིན་”ཞེས་བཤད་པས། ");
INSERT INTO bod_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ཁོ་ཚོ་གཉིས་བོས་པ་དང༌། གཙོ་བོ་ཡེ་ཤུའི་མཚན་ཐོག་ནས་ནམ་ཡང་གཏམ་བརྗོད་པ་དང་ཆོས་སྟོན་མི་ཆོག་པར་བཀའ་བཏང་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གྱིས་ཁོ་ཚོར་“ཁྱེད་ཀྱི་གསུང་ངམ། དཀོན་མཆོག་གི་བཀའ་ལ་ཉན་པ་ནི་དཀོན་མཆོག་གི་སྤྱན་སྔར་ཇི་ཞིག་འོས་པ་ཡིན་པར་ཁྱེད་ཀྱིས་ཐག་གཅོད་བྱེད་དགོས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ང་ཚོས་གང་མཐོང་བ་དང་ཐོས་པའི་སྐོར་ལ་འཆད་རྒྱུ་ལས་ཐབས་གཞན་མེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","ངོ་མཚར་བའི་རྟགས་ཀྱིས་གསོས་པར་འགྱུར་བའི་མི་དེ་ལོ་བཞི་བཅུ་ལྷག་ཙམ་ལོན་པ་ཞིག་ཡིན་ཏེ། རྟགས་དེ་བྱུང་བས་མི་ཐམས་ཅད་ཀྱིས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་བའི་རྐྱེན་གྱིས་ཁོང་གཉིས་ལ་ཉེས་ཆད་གཏོང་མ་ནུས། དེའི་ཕྱིར་གྲོས་ཚོགས་ཀྱིས་སྔོན་ལས་ལྷག་པའི་རྫིག་རྫིག་བཏང་ནས་ཁོང་རྣམས་གློད། ");
INSERT INTO bod_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","དེའི་རྗེས་སུ་སྐུ་ཚབ་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་རང་གི་འགྲོགས་མིའི་རྩར་ཕྱིར་ལོག་ནས་བླ་ཆེན་དང་རྒན་པོ་རྣམས་ཀྱིས་གང་བཤད་པ་ཐམས་ཅད་ཁོ་ཚོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ཁོ་ཚོས་གཏམ་དེ་ཐོས་ནས་བློ་སེམས་གཅིག་མཐུན་གྱིས་དཀོན་མཆོག་ལ་སྨོན་ལམ་བཏབ་སྟེ་“ཀྱེ་གཙོ་བོ་དཀོན་མཆོག ཁྱེད་ཀྱིས་གནམ་ས་གཉིས་དང༌། རྒྱ་མཚོ། དེར་ཡོད་པ་ཐམས་ཅད་བཀོད་པ་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ཁྱེད་ཀྱིས་དམ་པའི་ཐུགས་ཉིད་ཀྱི་ཐོག་ནས་ཁྱེད་ཀྱི་ཞབས་ཕྱི་ང་ཚོའི་མེས་པོ་དཱ་བིད་བརྒྱུད་ནས། ཕྱི་པ་རབ་ཏུ་ཁྲོས་པ་ཅི་ཡི་ཕྱིར། ། མི་རྒྱུད་རྣམས་ཀྱིས་དོན་མེད་བྱེད་པ་ཅི། ། ");
INSERT INTO bod_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","དེ་ཡང་གཙོ་བོ་དཀོན་མཆོག་ཁོང་ཉིད་ཀྱིས། ། མངགས་པའི་སྐྱབས་མགོན་དེ་ལ་རྒོལ་ཆེད་དུ། ། ས་སྟེང་རྒྱལ་དཔོན་ཐམས་ཅད་མཉམ་དུ་འདུས། ། ཞེས་གསུངས་པའི་ལུང་བསྟན་ནི། ");
INSERT INTO bod_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","དོན་དངོས་སུ་གྲོང་ཁྱེར་འདིར་བསྒྲུབས་སོ། གང་ལགས་ཟེར་ན། རྒྱལ་པོ་ཧེ་རོ་དཱེ་དང་སྤྱི་ཁྱབ་ཕོན་ཏི་ཡུ་པི་ལ་ཏུ་གཉིས་ནི་ཕྱི་པ་རྣམས་དང་ཡི་སི་ར་ཨེལ་གྱི་མི་སྡེ་དང་བཅས་པ་ཁྱེད་ཀྱིས་སྣུམ་གྱིས་བྱུགས་སུ་བཅུག་པའི་ཞབས་ཕྱི་དམ་པ་ཡེ་ཤུ་ལ་ངོ་རྒོལ་བྱེད་པར་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","དེ་ནི་སྔར་ནས་ཁྱེད་ཀྱི་དབང་དང་ཐུགས་དགོངས་ཀྱིས་གང་ཐག་བཅད་ཟིན་པ་དེ་སྒྲུབ་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ཀྱེ་གཙོ་བོ་དཀོན་མཆོག ད་ཁོ་ཚོའི་འཇིགས་སྐུལ་གཟིགས་ཤིང༌། ཁྱེད་ཀྱི་གཡོག་པོ་རྣམས་ཀྱིས་བློ་སྟོབས་ཆེན་པོས་ཁྱེད་ཀྱི་བཀའ་སྒྲོག་གནང་བར་ཤོག ");
INSERT INTO bod_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ཡང་ནད་གསོ་བར་མཛད་པའི་ཆེད་དུ་ཁྱེད་ཀྱི་ཕྱག་རྐྱོངས་ཤིང༌། ཁྱེད་ཀྱི་ཞབས་ཕྱི་དམ་པ་ཡེ་ཤུའི་མཚན་གྱི་ཐོག་ནས་རྟགས་དང་ངོ་མཚར་བའི་དོན་སྒྲུབ་པར་ཤོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ཁོང་ཚོས་སྨོན་ལམ་བཏབ་པའི་རྗེས་སུ་འཛོམས་ས་གཡོ་བར་གྱུར་བ་དང༌། ཁོང་ཚོ་ཚང་མ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་གྱུར་བས་འཇིགས་སྣང་ཅི་ཡང་མེད་པར་དཀོན་མཆོག་གི་བཀའ་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ཡང་དད་ལྡན་གྱི་མི་ཚོགས་བློ་སེམས་གཅིག་མཐུན་པར་བཞུགས་ཏེ། ཁོ་ཚོའི་ནང་ནས་རང་ནོར་རང་གི་ཡིན་ཟེར་མཁན་གཅིག་ཀྱང་མེད་པས། ནོར་རྫས་ཐམས་ཅད་ཐུན་མོང་དུ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ནུས་མཐུ་ཆེན་པོས་སྐུ་ཚབ་རྣམས་ཀྱིས་གཙོ་བོ་ཡེ་ཤུ་འཆི་བ་ནས་སླར་གསོན་པར་དཔང་པོ་མཛད། དཀོན་མཆོག་གི་ཐུགས་རྗེ་ཆེན་པོ་ཁོང་ཚོ་ཚང་མར་བབས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","དད་ལྡན་རྣམས་ཀྱི་ནང་ནས་དབུལ་པོ་གཅིག་ཀྱང་མེད། རྒྱུ་མཚན་ནི་ས་ཞིང་ངམ་ཁང་པ་ཡོད་པའི་མི་ཐམས་ཅད་ཀྱིས་དེ་ཚོ་བཙོངས་ནས་དངུལ་ཐོབ་པ་དང༌། དད་ལྡན་གཞན་ལ་ཕན་པའི་ཕྱིར་སྐུ་ཚབ་རྣམས་ཀྱི་ཞབས་ཀྱི་དྲུང་དུ་བཞག དེ་ནས་ཁོང་ཚོས་མི་རེ་རེ་ལ་དགོས་པ་བཞིན་དུ་བགོ་བཤའ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ཡང་ཀིབ་རུ་གླིང་ཕྲན་ནས་ཡིན་པའི་སྐྱེས་པ་ཡོ་སེབ་ཟེར་མཁན་ཞིག་ཡོད་དེ། ཁོང་ནི་ལེ་ཝི་པ་ཞིག་ཡིན། སྐུ་ཚབ་རྣམས་ཀྱིས་ཁོང་ལ་མིང་པར་ན་པཱ་ཞེས་བཏགས་པ་སྟེ། བློ་སྟོབས་སྤེལ་མཁན་ཞེས་པའི་དོན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ཁོང་ལ་ཡོད་པའི་ཞིང་ཁ་ཞིག་བཙོངས་ནས་དེའི་རིན་གོང་འཁྱེར་ཡོང་བ་དང༌། སྐུ་ཚབ་རྣམས་ཀྱི་ཞབས་ཀྱི་དྲུང་དུ་བཞག་གོ ། ");
INSERT INTO bod_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","འོན་ཀྱང་ཨ་ནན་ཡཱ་ཟེར་བའི་སྐྱེས་པ་ཞིག་དང་ཁོའི་བཟའ་ཟླ་སབ་ཕི་རཱ་གཉིས་ཀྱིས་ཞིང་ཁ་ཞིག་བཙོངས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ཨ་ནན་ཡཱ་ཡིས་སའི་རིན་གོང་ཆ་ཤས་ཤིག་རང་གི་དོན་ལ་བཞག་ནས་ས་རིན་ལྷག་མ་སྐུ་ཚབ་རྣམས་ཀྱི་ཞབས་ལ་བཞག་པ་དེ་སབ་ཕི་རཱ་ཡིས་ཀྱང་ཤེས་ཀྱི་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ཡང་སྐུ་ཚབ་པེ་ཏྲོས་“ཨ་ནན་ཡཱ། བདུད་སཱ་ཏན་གྱིས་ཁྱོད་ཀྱི་སེམས་ལ་ཁྱབ་ནས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་རྫུན་བཤད་དེ། སའི་རིན་གོང་ཆ་ཤས་རང་ལ་བཞག་པ་དེ་ཅི་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ཞིང་ཁ་དེ་མ་བཙོངས་པའི་སྔོན་དུ་ཁྱོད་རང་གི་མ་ཡིན་ནམ། ཡང་བཙོངས་པའི་རྗེས་སུ་སའི་རིན་གོང་ཁྱོད་ལ་དབང་བ་མ་ཡིན་ནམ། བསམ་པ་འདི་ཁྱོད་ཀྱི་སེམས་ལ་སྐྱེས་པ་དེ་ཅི་ལྟར་སྲིད། ཁྱོད་ཀྱིས་མི་རྣམས་ལ་མ་བཤད་ཀྱི། དཀོན་མཆོག་ལ་རྫུན་བཤད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","གཏམ་དེ་གོ་མ་ཐག་ཨ་ནན་ཡཱ་ས་ལ་འགྱེལ་ནས་ཤིའོ། དེའི་སྐོར་ཐོས་པ་ཐམས་ཅད་ཤིན་ཏུ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","གཞོན་ནུ་རྣམས་ཀྱིས་ཁོའི་ཕུང་པོ་རས་ཀྱིས་བཏུམས་ནས་ཕྱི་རོལ་ཏུ་འཁུར་ཏེ་དུར་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","དེ་ནས་ཆུ་ཚོད་གསུམ་ཙམ་གྱི་རྗེས་སུ་ཁོ་ལ་ཅི་བྱུང་བ་མི་ཤེས་པར་ཁོའི་བཟའ་ཟླ་ཡོང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","སྐུ་ཚབ་པེ་ཏྲོས་ཁོ་མོར་“ང་ལ་ཤོད་དང༌། ཁྱོད་གཉིས་ཀྱིས་ས་ཞིང་བཙོངས་ནས་རིན་གོང་འདི་ཙམ་ཐོབ་བམ་”ཞེས་གསུངས་པས་ཁོ་མོས་“ལགས་ཡིན། རིན་གོང་དེ་ཙམ་ཡིན་”ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","སྐུ་ཚབ་པེ་ཏྲོས་ཁོ་མོར་“དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་ཉམས་ཚོད་བྱེད་པའི་ཕྱིར་ཁྱོད་གཉིས་ཀྱིས་མོས་མཐུན་བྱས་པ་དེ་ཅི་ཡིན། ལྟོས་ཤིག ཁྱོད་ཀྱི་ཁྱོ་བོའི་ཕུང་པོ་དུར་དུ་འཇུག་མཁན་སྒོ་ལ་འདུག ཁོ་ཚོས་ཁྱོད་ཀྱི་ཕུང་པོ་ཕྱི་རོལ་ཏུ་འཁུར་ངེས་ཡིན་”ཞེས་གསུངས་མ་ཐག ");
INSERT INTO bod_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ཁོང་གི་ཞབས་ཀྱི་དྲུང་དུ་འགྱེལ་ནས་ཁོ་མོ་ཤིའོ། གཞོན་ནུ་རྣམས་ནང་ལ་ཡོང་ནས་ཁོ་མོ་ཤི་བར་མཐོང་བས། ཁོ་མོའི་ཕུང་པོ་ཕྱིར་འཁུར་བ་དང༌། ཁྱོ་བོའི་དུར་སའི་ཉེ་འགྲམ་ལ་དུར་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ཡང་དོན་དེའི་སྐོར་ཐོས་མཁན་དང༌། ཆོས་ཚོགས་ཀྱི་མི་ཚང་མ་འཇིགས་སྐྲག་སྐྱེས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ཡང་མི་རྣམས་ཀྱི་ཁྲོད་དུ་སྐུ་ཚབ་རྣམས་ཀྱི་ཐོག་ནས་རྟགས་དང་ངོ་མཚར་བའི་དོན་མང་པོ་བྱུང༌། དད་ལྡན་ཐམས་ཅད་མཆོད་ཁང་དུ་སོ་ལོ་མོན་གྱི་གཡབ་རིང་ལ་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","གཞན་རྣམས་ཀྱིས་ཁོང་ཚོ་དང་འགྲོགས་མི་ནུས་ཀྱང༌། ཡུལ་མི་རྣམས་ཀྱིས་ཁོང་ཚོར་བརྩི་བཀུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ཡང་སྔོན་ལས་ལྷག་པར་སྐྱེས་པ་དང་བུད་མེད་དད་ལྡན་ཤིན་ཏུ་མང་པོ་ཁོང་ཚོའི་གྲལ་དུ་ཞུགས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","སྐུ་ཚབ་རྣམས་ཀྱིས་གང་མཛད་པའི་རྐྱེན་གྱིས་མི་རྣམས་ཀྱིས་ནད་པ་ཚོ་ལམ་ལ་འཁུར་ནས་ཉལ་ཁྲི་དང་མལ་སྟན་སྒང་ལ་བཞག དེ་ནི་སྐུ་ཚབ་པེ་ཏྲོ་ཕེབས་པའི་དུས་སུ་ཁོང་གི་གྲིབ་མ་ཙམ་ཡང་ཁོ་ཚོ་ཁ་ཤས་ཀྱི་ལུས་ལ་ཕོག་པའི་ཆེད་དུ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ཡེ་རུ་ཤ་ལེམ་དང་ཉེ་འཁོར་གྱི་གྲོང་སྡེའི་མི་མང་པོ་ནད་པ་དང༌། གདོན་འདྲེ་མི་གཙང་བ་ཕོག་པ་རྣམས་འཁྲིད་དེ་འཛོམས་ཤིང༌། ཁོ་ཚོ་ཐམས་ཅད་གསོས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","དེ་ནས་བླ་ཆེན་གཙོ་བོ་དང༌། ཁོ་དང་འགྲོགས་པའི་སཱ་ཅུ་སེ་པའི་ཕྱོགས་ཁག་གི་ཁོངས་གཏོགས་པ་ཐམས་ཅད་ཕྲག་དོག་སྐྱེས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","སྐུ་ཚབ་རྣམས་འཛིན་བཟུང་བྱས་ནས་སྤྱི་པའི་བཙོན་ཁང་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","འོན་ཀྱང་མཚན་མོའི་དུས་སུ་གཙོ་བོའི་ཕོ་ཉ་ཞིག་གིས་བཙོན་ཁང་གི་སྒོ་ཕྱེ་ནས་ཁོང་རྣམས་ཕྱི་རོལ་ཏུ་འཁྲིད་དེ། ");
INSERT INTO bod_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ཁོང་ཚོར་“སོང་ལ་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་མི་རྣམས་ལ་ཚེ་གསར་པ་འདིའི་འཕྲིན་ཡོངས་སུ་སྒྲོགས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","དེ་ཐོས་ནས་ནམ་ལངས་པའི་ཚེ་ཁོང་རྣམས་མཆོད་ཁང་ཆེན་མོའི་ཁྱམས་རར་སོང་ནས་ཆོས་བསྟན། བླ་ཆེན་འཁོར་དང་བཅས་པ་ཡོང་སྐབས། ཁོ་ཚོས་ཡི་སི་ར་ཨེལ་གྱི་རྒན་པོ་ཐམས་ཅད་ཀྱི་གྲོས་ཚོགས་བསྐོངས་ནས་བཙོན་པ་དེ་གཉིས་ཁོ་ཚོའི་རྩར་འཁྲིད་ཡོང་དགོས་པས་བཙོན་ཁང་ལ་བཀའ་མངགས་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","མཆོད་ཁང་གི་སྲུང་དམག་དེར་སོང་ནས་སྐུ་ཚབ་རྣམས་བཙོན་ཁང་དུ་མ་རྙེད་པས། གྲོས་ཚོགས་ལ་ཕྱིར་ལོག་པ་དང་ཁོ་རྣམས་ལ་ ");
INSERT INTO bod_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“བཙོན་ཁང་གི་སྒོ་དམ་པོར་བརྒྱབ་སྟེ་སྲུང་མཁན་རྣམས་སྒོ་འགྲམ་ལ་ལངས་ཏེ་བསྡད་པ་ང་ཚོས་མཐོང་ཡང༌། སྒོ་ཕྱེ་ནས་ནང་ལ་མི་སུ་ཡང་མ་མཐོང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","དེ་ཐོས་ནས་མཆོད་ཁང་གི་སྲུང་དམག་གི་དཔོན་པོ་དང༌། བླ་ཆེན་རྣམས་ག་བྱེད་འདི་བྱེད་མེད་པར་གྱུར་ཏེ། བྱ་བ་འདི་ནས་ཅི་འབྱུང་བར་འགྱུར་སྙམ། ");
INSERT INTO bod_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","མི་ཞིག་དེར་སླེབས་ནས་ཁོ་ཚོར་“ཉོན་དང༌། ཁྱེད་ཚོས་བཙོན་ཁང་དུ་བཅུག་པའི་མི་དེ་རྣམས་མཆོད་ཁང་གི་ཁྱམས་རར་མི་ཚོགས་ལ་ཆོས་སྟོན་གྱི་འདུག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","དེ་ནས་དཔོན་པོ་དེ་སྲུང་དམག་དང་མཉམ་དུ་མཆོད་ཁང་ལ་ཕྱིན་ནས། མི་རྣམས་ཀྱིས་ཁོ་ཚོར་རྡོ་རུབ་གཏོང་བའི་འཇིགས་པ་སྐྱེས་པས་བཙན་ཤེད་མི་བྱེད་པར་ཁོང་རྣམས་གྲོས་ཚོགས་ལ་འཁྲིད་ཡོང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","གྲོས་ཚོགས་ཀྱི་མདུན་དུ་བཞག་ནས། བླ་ཆེན་གྱིས་ཁོང་ཚོར་ ");
INSERT INTO bod_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ངེད་རྣམས་ཀྱིས་ཁྱོད་ཚོར་མིང་འདིའི་ཐོག་ནས་མི་བསྟན་པ་ནན་གྱིས་བསྐུལ་ཡང༌། ཁྱོད་ཀྱིས་ཡེ་རུ་ཤ་ལེམ་ལ་ཆོས་འདི་གང་སར་ཁྱབ་བསྒྲགས་བྱས་ཏེ། མི་དེའི་ཁྲག་ལན་ང་ཚོ་ལ་འགེལ་བར་འདོད་”ཅེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","འོན་ཀྱང་པེ་ཏྲོ་དང་སྐུ་ཚབ་གཞན་རྣམས་ཀྱིས་“མིའི་ངག་ལ་མི་ཉན་གྱི། དཀོན་མཆོག་གི་བཀའ་ལ་ཉན་དགོས། ");
INSERT INTO bod_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ཁྱེད་ཀྱིས་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་ནས་བསད་པའི་གཙོ་བོ་ཡེ་ཤུ་ནི་ངེད་རྣམས་ཀྱི་མེས་པོའི་དཀོན་མཆོག་གིས་འཆི་བ་ནས་སླར་གསོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ཡི་སི་ར་ཨེལ་གྱི་མི་རིགས་ལ་སེམས་བསྒྱུར་བ་དང༌། སྡིག་ཉེས་སེལ་རྒྱུའི་གོ་སྐབས་གནང་བའི་ཕྱིར་དཀོན་མཆོག་གིས་གཙོ་བོ་དང་སྐྱབས་མགོན་ལྟར་ཉིད་ཀྱི་ཕྱག་གཡས་སུ་ཁོང་འཕགས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ང་ཚོས་དོན་དེ་རྣམས་ལ་དཔང་པོ་བྱེད་ཅིང༌། ཁོང་གི་བཀའ་ལ་ཉན་མཁན་ལ་གནང་བ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཀྱང་དོན་དེ་རྣམས་ལ་དཔང་པོ་མཛད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","དེ་ཐོས་ནས་གྲོས་ཚོགས་ཀྱི་མི་རྣམས་ཁོང་ཁྲོ་ལངས་ཏེ་ཁོང་རྣམས་གསོད་པར་འདོད། ");
INSERT INTO bod_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","འོན་ཀྱང་ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་ལ་གཏོགས་པའི་མི་སྟེ་ཆོས་ཁྲིམས་ལ་མཁས་ཤིང༌། མི་ཚང་མས་བཀུར་བ་གཱ་མ་ལི་ཨེལ་ཟེར་མཁན་ནི་གྲོས་ཚོགས་སུ་ལངས་ནས་སྐུ་ཚབ་རྣམས་དུས་ཐུང་ངུ་ཕྱི་རོལ་ཏུ་འཁྲིད་དགོས་པའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ཁོང་གིས་གྲོས་ཚོགས་ལ་“ཡི་སི་ར་ཨེལ་གྱི་སྐྱེས་པ་རྣམས། ཁྱེད་ཀྱིས་མི་འདི་རྣམས་ལ་ཅི་བྱེད་ཞིབ་པར་དགོངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","སྔོན་ཆད་ཐེའུ་དཱ་ཟེར་མཁན་གྱིས་རང་བསྟོད་བྱས་ཏེ་སྲིད་གཞུང་ལ་ངོ་རྒོལ་བྱས་པ་དང༌། མི་བཞི་བརྒྱ་ཙམ་ཁོའི་རྗེས་སུ་འབྲངས། གཞན་གྱིས་ཁོ་བསད་ནས་ཁོའི་རྗེས་འབྲངས་པ་རྣམས་འཐོར་ཏེ་དོན་དེ་མེད་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","དེའི་རྗེས་སུ་ཡ་ཧུ་དཱ་ཡུལ་གྱི་འབངས་མི་མིང་ཐོ་འགོད་པའི་དུས་སུ་ག་ལིལ་ཡུལ་ནས་ཡིན་པ་ཡུ་དཱ་ཡིས་རྗེས་འབྲངས་པ་རྣམས་མཉམ་དུ་བསྡུས་ནས་སྲིད་གཞུང་ལ་ངོ་རྒོལ་བྱས་པ་དང༌། ཁོ་ཡང་བསད་ནས། རྗེས་འབྲངས་པ་ཐམས་ཅད་འཐོར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","དེའི་ཕྱིར་གནས་ཚུལ་འདིའི་སྐོར་ངས་ཁྱེད་རྣམས་ལ་ཟེར་རྒྱུར། མི་འདི་ཚོར་ཅི་ཡང་མི་བྱེད་ཅིང་གློད་བཀྲོལ་གཏོང་ཞིག གང་ལགས་ཤེ་ན། གལ་ཏེ་འཆར་གཞིའམ་བྱ་བ་འདི་ནི་མི་རྣམས་ལས་བྱུང་བ་ཡིན་ན་འཇིག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","འོན་ཀྱང་དཀོན་མཆོག་ལས་བྱུང་ན་ཁྱེད་ཀྱིས་ཁོ་ཚོ་འགོག་མི་ཐུབ་པ་མ་ཟད། དཀོན་མཆོག་ལ་ངོ་རྒོལ་བྱེད་མཁན་དུ་འགྱུར་བའི་ཉེན་ཁ་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ཁོང་གི་བཀའ་ལ་ཉན་ཏེ་གྲོས་ཚོགས་ཀྱིས་སྐུ་ཚབ་རྣམས་བོས་ནས་ཁོང་ཚོ་རྟ་ལྕག་གིས་རྡུང་དུ་བཅུག དེ་ནས་ཁོ་ཚོས་སྐུ་ཚབ་རྣམས་ལ་གཙོ་བོ་ཡེ་ཤུའི་མཚན་གྱི་ཐོག་ནས་མི་འཆད་པར་བཀའ་བཏང་ནས་གློད། ");
INSERT INTO bod_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","གྲོས་ཚོགས་ནས་འཐོན་དུས་ཡེ་ཤུའི་མཚན་གྱི་དོན་ལ་སྡུག་བསྔལ་དེ་ལྟར་མྱོང་འོས་པར་བརྩིས་པས་ཁོང་རྣམས་ཧ་ཅང་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ཡང་ཉིན་ལྟར་མཆོད་ཁང་གི་ཁྱམས་ར་དང་ཁྱིམ་ཚང་གང་དུའང་ཁོང་ཚོས་གཙོ་བོ་ཡེ་ཤུ་ནི་མཱ་ཤི་ཀ་ཡིན་ཞེས་རྒྱུན་མི་ཆད་པར་བསྟན་ཏེ་བསྒྲགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ཡེ་ཤུ་ལ་དད་ལྡན་རྣམས་ཀྱི་གྲངས་མང་དུ་འཕེལ་བའི་དུས་སུ། ཉིན་རེའི་ཟས་ཀྱི་བགོ་སྐལ་གནང་སྐབས་ཡ་ཧུ་དཱ་པའི་སྐད་ཆ་ཤོད་པའི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་གྷི་རིག་སྐད་སྨྲ་བའི་ཡུགས་མོ་རྣམས་ལ་སྣང་མེད་དུ་བཏང་བས་ཁོ་ཚོའི་བར་མི་མཐུན་པ་ཞིག་བྱུང་བས། ");
INSERT INTO bod_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","བཅུ་གཉིས་པོས་དད་ལྡན་ཐམས་ཅད་ཀྱི་ཚོགས་བོས་ནས་ཁོ་ཚོར་“ཉིན་རེའི་བགོ་སྐལ་གནང་བའི་ཆེད་དུ་དཀོན་མཆོག་གི་བཀའ་སྣང་མེད་དུ་འཇོག་མི་རུང་བས། ");
INSERT INTO bod_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","སྤུན་ཟླ་རྣམས། ཁྱེད་ཚོ་ལས་ཡོན་ཏན་ཅན་ཡིན་ཏེ། དམ་པའི་ཐུགས་ཉིད་དང་ཤེས་རབ་ཀྱིས་གང་བའི་སྐྱེས་པ་བདུན་འདོམས་ཤིག ང་ཚོས་ཁོང་རྣམས་ལ་ལས་ཀ་འདི་བསྐོས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","སྨོན་ལམ་འདེབས་པ་དང་དཀོན་མཆོག་གི་བཀའ་སྒྲོག་པའི་ལས་ལ་བརྩོན་པར་བྱ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","དེ་ཐོས་ནས་ཆོས་ཚོགས་ཀྱི་དད་ལྡན་ཐམས་ཅད་བློ་སེམས་བདེ་བར་གྱུར། ཁོ་ཚོས་དད་པ་དང་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བ་སེ་ཏེ་ཕཱན་དང༌། ཕི་ལིབ། པོ་རོ་ཀོ་རུ། ནི་ཀ་ནོར། ཏི་མོན། པར་མེ་ནཱ། སྔར་ཡ་ཧུ་དཱ་པའི་ཆོས་ལུགས་ལ་ཞུགས་ཏེ་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་ནས་ཡིན་པ་ནི་ཀོ་ལཱ་བཅས་བདམས། ");
INSERT INTO bod_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ཁོ་ཚོས་མི་འདི་ཚོ་སྐུ་ཚབ་རྣམས་ཀྱི་མདུན་དུ་འཁྲིད་ནས་ཁོང་རྣམས་ཀྱིས་སྨོན་ལམ་བཏབ་སྟེ་མི་དེ་ཚོར་ཕྱག་འཇོག་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","དཀོན་མཆོག་གི་བཀའ་ཕྱོགས་ཀུན་ཏུ་ཁྱབ། ཡེ་རུ་ཤ་ལེམ་ལ་དད་ལྡན་རྣམས་ཀྱི་གྲངས་ཤིན་ཏུ་མང་པོར་འཕེལ། ཡ་ཧུ་དཱ་པའི་བླ་མའི་ནང་ནས་མང་པོ་ཞིག་གིས་འཕྲིན་བཟང་ལ་དད་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ཡང་ཐུགས་རྗེ་དང་ནུས་མཐུ་ཡིས་གང་སྟེ་སེ་ཏེ་ཕཱན་གྱིས་ཡུལ་མིའི་ནང་ནས་རྟགས་དང་ངོ་མཚར་ཆེ་བའི་དོན་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","འོན་ཀྱང་རང་དབང་ཅན་ཞེས་བྱ་བའི་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ནས་སེ་རེ་ནཱ་དང་ཨ་ལིག་ཟན་དྲི་ཡཱ་གྲོང་ཁྱེར་ནས་ཡིན་པ་དང༌། གཞན་ཡང་ཀི་ལིག་ཡཱ་དང་ཨེ་ཞེ་ཡཱ་ཡུལ་པ་ཁ་ཤས་ཀྱིས་སེ་ཏེ་ཕཱན་དང་རྩོད་གླེང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","འོན་ཀྱང་སེ་ཏེ་ཕཱན་གྱིས་ཤེས་རབ་དང་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གསུངས་པ་དེར་ཁོ་ཚོས་རྒོལ་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","དེ་ནས་ཁོ་ཚོས་མི་ཁ་ཤས་ལ་ལྐོག་ཏུ་བློ་འགུགས་བྱས་པས་མི་དེ་ཚོས་“ཁོས་དཀོན་མཆོག་དང༌། ལུང་སྟོན་པ་མོ་ཤེ་ལ་སྐུར་བ་འདེབས་པ་ང་ཚོས་ཐོས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ཁོ་ཚོས་ཡུལ་མི་དང༌། རྒན་པོ། ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་རྣམས་ལ་ངན་བསྐུལ་བྱས་ནས་ཡོང་སྟེ་སེ་ཏེ་ཕཱན་བཟུང་ཞིང༌། གྲོས་ཚོགས་ཀྱི་མདུན་དུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","དེ་ནས་ཁོ་ཚོས་རྫུན་གྱི་དཔང་པོ་གྲ་སྒྲིག་བྱས་ཤིང༌། ཁོ་ཚོས་“མི་འདིས་གནས་མཆོག་དང་ཆོས་ཁྲིམས་ལ་རྒྱུན་ཆད་མེད་པར་སྐུར་བ་འདེབས། ");
INSERT INTO bod_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","གང་ལགས་ཤེ་ན། ཁོས་ཡེ་ཤུ་ཟེར་བའི་ན་ཙ་རེལ་པ་དེས་གནས་མཆོག་བཤིག་ནས་མོ་ཤེ་ཡིས་ང་ཚོར་གནང་བའི་ཁྲིམས་སྲོལ་སྒྱུར་བར་བྱ་ཞེས་ཟེར་བ་ཐོས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","གྲོས་ཚོགས་ལ་སྡོད་མཁན་ཐམས་ཅད་ཀྱིས་སེ་ཏེ་ཕཱན་ལ་ནན་གྱིས་བལྟས་ཏེ། ཁོང་གི་ངོ་གདོང་ནི་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་གི་ཞལ་དང་འདྲ་བར་ཡོད་པ་མཐོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","བླ་ཆེན་གྱིས་“དོན་འདི་ཚོ་བདེན་ནམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","སེ་ཏེ་ཕཱན་གྱིས་“ཀྱེ་སྤུན་ཟླ་དང་ཕ་རྒན་རྣམས་ང་ལ་ཉོན་དང༌། ཧ་རན་གྲོང་ཁྱེར་ལ་བཞུགས་པའི་སྔོན་ལ་མེ་སུའོ་པི་ཏ་མེ་ཡཱ་ཡུལ་ལ་གནས་པའི་དུས་སུ་གཟི་བརྗིད་དང་ལྡན་པའི་དཀོན་མཆོག་གིས་ངེད་རྣམས་ཀྱི་མེས་པོ་ཨབ་ར་ཧམ་ལ་མངོན་པར་མཛད་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ཁོང་ལ་ཁྱོད་རང་གི་ཕ་ཡུལ་དང་གཉེན་ཚན་དང་ཁ་བྲལ་ཏེ་ངས་ཁྱོད་ལ་བསྟན་པའི་ཡུལ་དུ་སོང་ཞིག་ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ཁོང་ཀལ་དཱ་པ་རྣམས་ཀྱི་ཡུལ་བཞག་ནས་ཧ་རན་གྲོང་ཁྱེར་ལ་གཞིས་ཆགས་བྱས། ཁོང་གི་ཕ་སྐུ་ཚེ་ལས་འདས་པའི་རྗེས་སུ་དཀོན་མཆོག་གིས་ཧ་རན་ནས་ཁྱེད་རྣམས་ད་ལྟ་བཞུགས་པའི་ཡུལ་འདིར་ཁོང་མངགས། ");
INSERT INTO bod_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","འོན་ཀྱང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་ཡུལ་ཡི་རྐང་མཐིལ་ལས་ཆེ་ཙམ་ཞིག་ཀྱང་སྐལ་བ་མ་གནང༌། ཨབ་ར་ཧམ་ལ་ད་དུང་བུ་ཕྲུག་མེད་ཀྱང༌། དཀོན་མཆོག་གིས་ཁོང་དང་ཁོང་གི་བུ་རྒྱུད་རྣམས་ལ་ཡུལ་འདི་བདག་འཛིན་བྱེད་རྒྱུའི་ཞལ་ཆད་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","འོན་ཀྱང་རྗེས་མ་དཀོན་མཆོག་གི་གསུངས་པ་ལྟར། ཁྱོད་ཀྱི་བུ་རྒྱུད་ནི་མི་རིགས་གཞན་གྱི་ཡུལ་ལ་ཕྱི་པ་ལྟར་ལོ་བཞི་བརྒྱའི་རིང་ལ་བྲན་གཡོག་བྱེད་དེ་སྡུག་བསྔལ་མྱོང་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ཁོ་ཚོ་བྲན་གཡོག་ཏུ་འཇུག་མཁན་གྱི་མི་རིགས་ལ་ངས་ཁྲིམས་གཅོད་གཏོང་བར་བྱ། དེའི་རྗེས་སུ་ཁོ་རྣམས་ཐོན་ཏེ་གནས་འདིར་ང་ལ་བསྙེན་བཀུར་བྱེད་པར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ཡང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་ཞལ་ཆད་སྲུང་བའི་རྟགས་ཤིག་གནང་བས། ཨབ་ར་ཧམ་ནི་ཨི་སཱག་གི་ཕ་རུ་གྱུར་ཏེ་སྐྱེས་པ་ནས་ཉིན་བརྒྱད་པར་ཁོང་གིས་ཨི་སཱག་ལ་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དེ་བརྒྱབ། ཨི་སཱག་ནི་ཡ་ཀོབ་ཀྱི་ཕ་རུ་གྱུར་ཞིང༌། ཡ་ཀོབ་དེ་མེས་པོ་བཅུ་གཉིས་པོའི་ཕ་རུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","མེས་པོ་གཞན་རྣམས་ཀྱིས་མེས་པོ་ཡོ་སེབ་ལ་ཕྲག་དོག་སྐྱེས་ཏེ་བྲན་གཡོག་ལྟར་ཨེ་ཇེབ་ཡུལ་ལ་བཙོངས་ཀྱང༌། དཀོན་མཆོག་ཁོང་དང་མཉམ་དུ་བཞུགས་པས། ");
INSERT INTO bod_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ཁོང་གི་སྡུག་བསྔལ་ཐམས་ཅད་ལས་ཐར་བར་མཛད་ནས་དཀོན་མཆོག་གིས་ཁོང་ཨེ་ཇེབ་ཡུལ་གྱི་རྒྱལ་པོ་ཕར་ཨོ་ཞེས་བྱ་བའི་སྤྱན་སྔར་དྲིན་ཐོབ་པ་དང་ཤེས་རབ་ལྡན་པར་བསྒྱུར་བས། རྒྱལ་པོ་དེས་ཉིད་ཀྱི་ཕོ་བྲང་གི་གཉེར་པ་དང༌། ཨེ་ཇེབ་ཡུལ་གྱི་སྤྱི་ཁྱབ་ལ་བསྐོས། ");
INSERT INTO bod_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","དེ་ནས་ཨེ་ཇེབ་དང་ཀ་ནཱན་ཟེར་བའི་ཡུལ་ཡོངས་སུ་མུ་གེ་བྱུང་བས་མི་རྣམས་སྡུག་བསྔལ་ཆེན་པོ་མྱོང་སྟེ། ངེད་རྣམས་ཀྱི་མེས་པོ་ལ་ཟ་རྒྱུ་མ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","འོན་ཀྱང་ཡ་ཀོབ་ཀྱིས་ཨེ་ཇེབ་ཡུལ་ལ་འབྲུ་རིགས་ཡོད་པ་ཐོས་ནས་དེར་ཁོང་གིས་ང་ཚོའི་མེས་པོ་ཐེངས་དང་པོར་མངགས། ");
INSERT INTO bod_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","འགྲུལ་སྐྱོད་ཐེངས་གཉིས་པར་ཡོ་སེབ་ཀྱིས་རང་གི་གཅེན་པོ་རྣམས་ལ་ཁོང་སུ་ཡིན་པར་བཤད་ཅིང༌། ཁོང་གི་ཁྱིམ་མི་རྣམས་རྒྱལ་པོ་ཕར་ཨོ་ལ་ངོ་སྤྲོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","དེ་ནས་ཡོ་སེབ་ཀྱིས་ཉིད་ཀྱི་ཕ་རྒན་ཡ་ཀོབ་དང་གཉེན་ཉེ་མི་གྲངས་བདུན་ཅུ་དོན་ལྔ་གདན་འདྲེན་ཞུས་པས། ");
INSERT INTO bod_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ཡ་ཀོབ་ཨེ་ཇེབ་ཡུལ་ལ་ཕེབས་རྗེས་དེར་ཁོང་དང་ང་ཚོའི་མེས་པོ་གཞན་རྣམས་སྐུ་ཚེ་ལས་འདས། ");
INSERT INTO bod_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ཁོ་ཚོའི་ཕུང་པོ་ས་ཆ་དེ་ནས་ཤེ་ཀེམ་ལ་སྤོས་པ་དང༌། ཨབ་ར་ཧམ་གྱིས་ཤེ་ཀེམ་ལ་ཧེ་མོར་གྱི་བུ་རྣམས་ནས་སྔར་དངུལ་སྲང་གིས་ཉོས་པའི་དུར་ཁང་ལ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ཡང་དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་ལ་མཛད་པའི་ཞལ་ཆད་སྒྲུབ་ལ་ཉེ་བའི་དུས་སུ་ཨེ་ཇེབ་ཡུལ་ལ་ང་ཚོའི་མི་རིགས་ཤིན་ཏུ་མང་པོར་འཕེལ། ");
INSERT INTO bod_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","དེ་ནས་ཡོ་སེབ་ཀྱི་སྐོར་མི་ཤེས་པའི་རྒྱལ་པོ་ཞིག་ཨེ་ཇེབ་ཡུལ་དབང་བསྒྱུར། ");
INSERT INTO bod_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ཁོས་ང་ཚོའི་མི་རྒྱུད་ལ་མགོ་སྐོར་བཏང་སྟེ་དྲག་གནོན་བྱས་པ་དང༌། ང་ཚོའི་མེས་པོའི་དམར་འབྱར་གསོད་པའི་ཆེད་ཕྱི་རོལ་ཏུ་དོར་བར་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","དེའི་དུས་སུ་ལུང་སྟོན་པ་མོ་ཤེ་སྐྱེས་ཏེ་ཁོང་ནི་དཀོན་མཆོག་གི་སྤྱན་སྔར་མཛེས་པོ་ཡིན། ཕའི་ཁང་པར་ཟླ་བ་གསུམ་གྱི་བར་དུ་གསོ་སྐྱོང་བྱས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ཁོང་ཕྱི་རོལ་ཏུ་བཞག་ནས་རྒྱལ་པོ་ཕར་ཨོ་ཡི་སྲས་མོས་ཚུར་བླངས་ཏེ་ཁོ་མོའི་བུ་ལྟར་གསོས། ");
INSERT INTO bod_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ཨེ་ཇེབ་པའི་ཤེས་བྱ་ཐམས་ཅད་བསླབས་ནས་མོ་ཤེ་གསུང་དང་མཛད་པ་གཉིས་ལ་དབང་དང་ལྡན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ཁོང་ལོ་བཞི་བཅུ་ཙམ་ལོན་པའི་སྐབས་སུ་རང་གི་སྤུན་ཟླ་ཡི་སི་ར་ཨེལ་པ་རྣམས་ལ་གཟིགས་པ་ཕེབས་པར་བསམས། ");
INSERT INTO bod_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ཨེ་ཇེབ་པ་ཞིག་གིས་ཡི་སི་ར་ཨེལ་པ་ཞིག་ལ་སྡུག་པོ་གཏོང་བར་གཟིགས་པའི་སྐབས་སུ། མི་དེར་སྲུང་སྐྱོབ་བྱས་ཏེ་མོ་ཤེ་ཡིས་དགྲ་ཤ་ལེན་པའི་ཆེད་དུ་ཨེ་ཇེབ་པ་དེ་བརྡུངས་ནས་བསད། ");
INSERT INTO bod_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","མོ་ཤེ་ཡིས་རང་ཉིད་བརྒྱུད་ནས་དཀོན་མཆོག་གིས་ཁོའི་མི་རིགས་ལ་ཐར་བར་མཛད་པ་ཁོང་གི་སྤུན་ཟླ་རྣམས་ཀྱིས་ཤེས་པར་སྙམ་ཡང་མི་དེ་ཚོས་ཧ་མ་གོ ");
INSERT INTO bod_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","དེའི་ཕྱི་ཉིན་མོ་ཤེས་ཁོ་ཚོའི་ནང་ནས་གཉིས་ཀྱིས་འཁྲུག་རྩོད་བྱེད་བཞིན་ཡོད་པ་མཐོང་ནས་བར་འདུམ་གཏོང་ཐབས་བྱས་ཏེ་ཁོ་ཚོར་ཁྱོད་གཉིས་སྤུན་ཡིན་ཏེ་ཅིའི་ཕྱིར་གཅིག་གིས་གཅིག་ལ་གནོད་པ་བྱེད་ཅེས་བཤད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","གཞན་ལ་སྡུག་པོ་གཏོང་མཁན་དེས་མོ་ཤེ་ཕར་བུད་ནས་ཁོང་ལ་ཁྱོད་ང་ཚོའི་དབང་སྒྱུར་བའམ་ཁྲིམས་དཔོན་ལྟར་སུས་བསྐོས། ");
INSERT INTO bod_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ཁ་སང་ཁྱོད་ཀྱིས་ཨེ་ཇེབ་པ་དེ་བསད་པ་ལྟར་ངའང་གསོད་པར་འདོད་དམ་ཞེས་སྨྲས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","དེ་ཐོས་ནས་མོ་ཤེ་བྲོས་ཏེ་ཕྱི་པ་ལྟར་མཱ་རྡེ་ཡན་ཡུལ་ལ་བཞུགས། དེར་ཁོང་ལ་བུ་གཉིས་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ལོ་བཞི་བཅུའི་རྗེས་སུ་སི་ནཱ་རིའི་འབྲོག་སྟོང་ལ་ཚེར་མ་མེ་ལྕེ་འབར་བ་ཞིག་གི་ནང་ལ་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་ཁོང་ལ་མངོན་སུམ་དུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","དེ་མཐོང་ནས་ཡ་མཚན་དུ་གྱུར་ཞིང༌། དེ་ལ་ནན་གྱིས་ལྟ་བའི་ཆེད་དུ་ཉེ་བར་ཕེབས་སྐབས་གཙོ་བོ་དཀོན་མཆོག་གི་གསུང་སྐད་བྱུང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ང་ནི་ཁྱོད་ཀྱི་མེས་པོ་རྣམས་ཀྱི་དཀོན་མཆོག་སྟེ། ཨབ་ར་ཧམ་དང༌། ཨི་སཱག ཡ་ཀོབ་བཅས་ཀྱི་དཀོན་མཆོག་ཡིན་ནོ་ཞེས་གསུངས་པས་མོ་ཤེ་འཇིགས་ནས་འདར་ཏེ་ལྟ་བར་མ་ཕོད། ");
INSERT INTO bod_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","དེ་ནས་དཀོན་མཆོག་གིས་ཁོང་ལ་ཁྱོད་ལངས་ནས་སྡོད་ས་ནི་གནས་མཆོག་ཡིན་པས་ལྷམ་ཕུད་ཅིག ");
INSERT INTO bod_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ངས་ངའི་མི་རིགས་ཀྱི་སྡུག་བསྔལ་ངེས་པར་དུ་མཐོང་སྟེ་ཁོ་ཚོའི་སྨྲེ་སྔགས་ཐོས་པ་དང༌། ཁོ་ཚོ་སྐྱོབ་པའི་ཆེད་དུ་མར་བབས་པ་ཡིན། ད་ཤོག་ལ་ངས་ཁྱོད་ཨེ་ཇེབ་ཡུལ་དུ་གཏོང་བར་བྱ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ཁོ་ཚོས་ཁྱོད་ང་ཚོའི་དབང་སྒྱུར་བའམ་ཁྲིམས་དཔོན་ལྟར་སུས་བསྐོས་ཞེས་ཟེར་ཏེ་མོ་ཤེ་འདི་རང་སྤངས་ཏེ། ཚེར་མའི་ནང་ཁོང་ལ་མངོན་སུམ་དུ་གྱུར་བའི་ཕོ་ཉ་བརྒྱུད་ནས་དཀོན་མཆོག་ཉིད་ཀྱིས་ཁོ་ཚོའི་དབང་སྒྱུར་བ་དང་སྐྱོབ་མཁན་དུ་འགྱུར་བར་མངགས། ");
INSERT INTO bod_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ཨེ་ཇེབ་ཡུལ་དང༌། རྒྱ་མཚོ་དམར་པོ་དང༌། ལོ་བཞི་བཅུའི་རིང་འབྲོག་སྟོང་ལ་རྟགས་དང་ངོ་མཚར་བའི་དོན་བསྒྲུབས་ཏེ་ཁོང་གིས་ཁོ་ཚོ་ཕྱི་རོལ་ཏུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","མོ་ཤེ་འདི་ཉིད་ཀྱིས་ཡི་སི་ར་ཨེལ་གྱི་མི་རིགས་ལ་དཀོན་མཆོག་གིས་ཁྱེད་ཚོའི་དོན་ལ་ང་བཞིན་དུ་ལུང་སྟོན་པ་ཞིག་ཁྱེད་ཚོའི་སྤུན་གྱི་ནང་ནས་སྐོ་བར་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ལུང་སྟོན་པ་མོ་ཤེ་ནི་འབྲོག་སྟོང་ལ་ཡི་སི་ར་ཨེལ་གྱི་མི་ཚོགས་དང་ང་ཚོའི་མེས་པོ་བཅས་ཏེ། སི་ནཱ་ཞེས་ཟེར་བའི་རི་བོར་ཁོང་ལ་གསུངས་པའི་ཕོ་ཉ་དང་མཉམ་དུ་ཡོད། ང་ཚོར་སྒྲོག་པའི་ཕྱིར་འཚོ་བའི་སྤྱོད་ལམ་སྟོན་པའི་བཀའ་མོ་ཤེས་དང་ལེན་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","འོན་ཀྱང་ང་ཚོའི་མེས་པོས་ཁོང་གི་བཀའ་ལ་ཉན་པར་མི་འདོད་པས་ཁོང་དོར་ཞིང༌། ཁོ་ཚོའི་སེམས་ལ་ཨེ་ཇེབ་ཡུལ་ལ་ཕྱིར་ལོག་པའི་འདོད་པ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","དེའི་ཕྱིར་ཁོ་ཚོས་ཨ་རོན་ལ་ངེད་རྣམས་ཀྱི་ཆེད་དུ་ལམ་འཁྲིད་མཁན་འདྲ་སྐུ་བཟོས་ཤིག གང་ཡིན་ཞེ་ན། ང་ཚོ་ཨེ་ཇེབ་ཡུལ་ནས་འཁྲིད་པ་མོ་ཤེ་ཟེར་མཁན་དེ་ལ་ཅི་བྱུང་བ་མི་ཤེས་ཞེས་སྨྲས་པའི་སྐབས་སུ། ");
INSERT INTO bod_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","བེའུ་ཡི་འདྲ་སྐུ་ཞིག་བཟོས་ནས་དེ་ལ་མཆོད་པ་ཞིག་སྟེར་ཞིང༌། རང་གི་ལག་པས་ཇི་བཟོས་པའི་རྐྱེན་གྱིས་དགའ་སྟོན་རྟེན་འབྲེལ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","འོན་ཀྱང་དཀོན་མཆོག་གིས་དེ་རྣམས་འདོར་བར་མཛད་དེ་སྟེང་གི་ཉི་ཟླ་སྐར་གསུམ་ལ་བསྙེན་བཀུར་བྱེད་པར་སྤངས་སོ། ལུང་སྟོན་པ་རྣམས་ཀྱི་མདོ་ལས་འདི་ལྟར་གསུངས་པར། ཡི་སི་ར་ཨེལ་ཁྱིམ་གཞིས་མི་རྒྱུད་ཚོ། ། འབྲོག་སྟོང་ལ་གནས་མི་ལོ་བཞི་བཅུའི་རིང༌། ། ཤ་ཁྲག་དམར་མཆོད་ང་ལ་འཕུལ་ཡོད་དམ། ། ");
INSERT INTO bod_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ལྷ་སྐུ་མའོ་ལོག་གུར་ཁང་དེ་དང་ནི། ། གཟའ་སྐར་རེམ་ཕན་ཞེས་པའི་སྐུ་རྟེན་སོགས། ། རང་བཟོས་འདྲ་སྐུར་བསྙེན་བཀུར་བྱེད་འགྱུར་བས། ། ཁྱེད་རྣམས་སྦ་བི་ལོན་གྱི་མཐའ་ལ་འབུད། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","དཔང་པོའི་གུར་མཆོག་དཀོན་མཆོག་གིས་ལུང་སྟོན་པ་མོ་ཤེ་ལ་བསྟན་པའི་དཔེ་བཞིན་དུ་བཟོས་པ་དེ་འབྲོག་སྟོང་ནང་ང་ཚོའི་མེས་པོར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ཁོ་ཚོའི་རྒྱུད་པ་རྣམས་ལ་ཡང་གུར་མཆོག་དེ་ཐོབ་པ་དང༌། དཀོན་མཆོག་གིས་ང་ཚོའི་མེས་པོའི་སྔོན་དུ་ཀ་ནཱན་ཡུལ་གྱི་མི་རིགས་རྣམས་བསྐྲད་སྐབས་ལུང་སྟོན་པ་ཡོ་ཤུ་ཨ་ཡིས་གཙོ་འཁྲིད་བྱས་ཏེ་ཕ་རྣམས་ཀྱིས་གུར་མཆོག་འདིར་འཁུར་ཡོང་ཞིང༌། རྒྱལ་པོ་དཱ་བིད་ཀྱི་དུས་ཀྱི་བར་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","དཀོན་མཆོག་གི་སྤྱན་སྔར་དཱ་བིད་ལ་ཐུགས་རྗེ་ཐོབ་ནས་ང་ཚོའི་མེས་པོ་ཡ་ཀོབ་ཀྱི་དཀོན་མཆོག་ལ་བཞུགས་གནས་ཤིག་བཞེངས་པའི་ཞུ་བ་ཕུལ་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","དཱ་བིད་ཀྱི་སྲས་སོ་ལོ་མོན་གྱིས་དཀོན་མཆོག་ལ་བཞུགས་གནས་དེ་བཞེངས། ");
INSERT INTO bod_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","འོན་ཀྱང་བླ་ན་མེད་པའི་དཀོན་མཆོག་ནི་མི་ཡི་ལག་པས་བརྩིགས་པའི་ཁང་པ་ལ་མི་བཞུགས་ཏེ། ལུང་སྟོན་པས་གསུངས་པ་ལྟར། ");
INSERT INTO bod_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ནམ་མཁའི་དབྱིངས་ནི་ང་ཡི་བཞུགས་ཁྲི་དང༌། ། ས་གཞི་འདི་ནི་ང་ཡི་རྐང་སྟེགས་ཡིན། ། ཁང་པ་ཅི་ཞིག་ང་ལ་བརྩིག་འགྱུར་ལ། ། ཡང་ན་ངལ་གསོའི་གནས་མཆོག་གང་དུ་ཡོད། ། གཙོ་བོ་དཀོན་མཆོག་ཉིད་ཀྱིས་དེ་ལྟར་གསུངས། ། ");
INSERT INTO bod_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ཐམས་ཅད་ང་ཡིས་བཀོད་པ་མ་ཡིན་ནམ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","དཀོན་མཆོག་གི་བཀའ་ལ་མི་ཉན་ཞིང་སེམས་མཁྲེགས་པོ་ཁྱོད་ཚོ། ཁྱོད་ཀྱི་མེས་པོ་ལྟར་ཁྱོད་ཚོས་ཀྱང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ལ་རྟག་པར་རྒོལ། ");
INSERT INTO bod_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ཁྱོད་ཀྱི་མེས་པོས་ལུང་སྟོན་པ་ལས་སུ་ཞིག་ལའང་གནོད་འཚེ་མ་བྱས། སྔར་སྐྱེས་བུ་རྣམ་དག་གི་འབྱོན་པ་སྒྲོག་མཁན་རྣམས་ཁོ་ཚོས་བསད། ད་ཁྱོད་ཚོ་ཁོང་གི་རྒྱབ་གཏོད་བྱེད་མཁན་དང་གསོད་པ་པོར་གྱུར་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ཁྱོད་ཚོར་དཀོན་མཆོག་གི་ཕོ་ཉ་རྣམས་བརྒྱུད་ནས་གནང་བའི་ཆོས་ཁྲིམས་ཐོབ་ཀྱང་མ་བསྲུངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","གཏམ་དེ་ཐོས་པས་ཁོ་ཚོ་ཁོང་ཁྲོ་ལངས་ཏེ་སེ་ཏེ་ཕཱན་ལ་སོ་ཁྲིག་ཁྲིག་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","འོན་ཀྱང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་སྟེ་སེ་ཏེ་ཕཱན་གྱིས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སུ་ནན་གྱིས་བལྟས་ནས་དཀོན་མཆོག་གི་གཟི་བརྗིད་དང༌། དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་གཙོ་བོ་ཡེ་ཤུ་བཞེངས་པར་མཐོང་བས། ");
INSERT INTO bod_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ཁོང་གིས་“ལྟོས་ཤིག ངས་དཀོན་མཆོག་གི་ཞིང་ཁམས་སྒོ་ཕྱེ་སྟེ་དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་མིའི་རིགས་ཀྱི་བུ་བཞེངས་པར་མཐོང་ངོ་”ཞེས་གསུངས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ཁོ་ཚོས་སྐད་ཆེན་པོ་བརྒྱབ་ནས་རྣ་བ་ལག་པས་བཀག་པ་དང༌། ཁོང་གི་རྩར་ལྷན་གཅིག་ཏུ་རྒྱུག་ནས་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","གྲོང་ཁྱེར་ཕྱི་རོལ་ཏུ་བསྐྲད་ནས་ཁོང་ལ་རྡོ་རུབ་གཏོང་སྐབས། དཔང་པོ་རྣམས་ཀྱིས་ཁོ་ཚོའི་ཕྱི་གོས་ཤ་ཨུལ་ཞེས་ཟེར་བའི་གཞོན་ནུ་ཞིག་གི་མདུན་དུ་བཞག ");
INSERT INTO bod_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ཡང་རྡོ་རུབ་གཏོང་དུས་སེ་ཏེ་ཕཱན་གྱིས་“ཀྱེ་གཙོ་བོ་ཡེ་ཤུ། ངའི་སེམས་ཉིད་བཞེས་པར་མཛོད་”ཅེས་སྨོན་ལམ་ཞུས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","པུས་མོ་སར་བཙུགས་ཏེ་སྐད་ཆེན་པོས་“གཙོ་བོ་ལགས། ཁོ་ཚོའི་སྡིག་ཉེས་འདི་སེལ་བར་མཛོད་”ཅེས་གསུངས་ནས་ཁོང་སྐུ་ཚེ་ལས་འདས། ");
INSERT INTO bod_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","སེ་ཏེ་ཕཱན་གསོད་པའི་ལས་ལ་ཤ་ཨུལ་ཡིས་མོས་མཐུན་བྱས་སོ། ། ཉིན་དེར་ཡེ་རུ་ཤ་ལེམ་ལ་སྡོད་པའི་དད་ལྡན་རྣམས་ལ་གནོད་འཚེ་དྲག་པོ་ཞིག་བྱུང་བས། སྐུ་ཚབ་རྣམས་མ་གཏོགས་པར་ཁོ་ཚོ་ཚང་མ་ཡ་ཧུ་དཱ་དང་ས་མར་ཡཱ་ཡུལ་ལ་ཁ་འཐོར། ");
INSERT INTO bod_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ཆོས་སེམས་དང་ལྡན་པའི་མི་འགའ་ཤས་ཀྱིས་སེ་ཏེ་ཕཱན་གྱི་ཕུང་པོ་དུར་དུ་བཅུག་ནས་སྐད་ཆེན་པོས་སྨྲེ་སྔག་བཏོན། ");
INSERT INTO bod_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","འོན་ཀྱང་ཤ་ཨུལ་ཡིས་ཁང་པ་རེ་རེའི་ནང་དུ་ཕྱིན་པ་དང༌། ཕོ་མོ་གཉིས་ཀ་བཙན་གྱིས་འཁྲིད་ནས་བཙོན་དུ་བཅུག་སྟེ་ཆོས་ཚོགས་ལ་གནོད་འཚེ་ཆེན་པོ་བཏང་བས། ");
INSERT INTO bod_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ཁ་འཐོར་བ་རྣམས་འཕྲིན་བཟང་སྒྲོག་སྟེ་ཡུལ་སོ་སོར་ཕྱིན་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ཕི་ལིབ་ས་མར་ཡཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་ཞིག་ལ་ཕྱིན་ནས་དེར་ཡོད་པའི་མི་རྣམས་ལ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་འཕྲིན་བཟང་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","མི་ཚོགས་ཀྱིས་ཕི་ལིབ་ཀྱིས་གསུངས་པའི་བསྟན་པ་ཐོས་ཤིང༌། ཁོང་གིས་སྒྲུབ་པའི་རྟགས་མཐོང་ནས་ཡིད་མཐུན་ཏེ་ཁོང་གི་གསུང་ལ་ཉན། ");
INSERT INTO bod_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","གང་ཡིན་ཞེ་ན། གདོན་འདྲེ་མི་གཙང་བ་རྣམས་སྐད་ངན་ཆེན་པོ་ཤོར་ཏེ་མི་མང་པོའི་ལུས་ནས་ཕྱིར་ཐོན་ཞིང༌། ཞ་བོ་དང་ཡན་ལག་བསྐམས་པ་མང་པོ་ནད་ལས་ཐར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","དེའི་ཕྱིར་གྲོང་ཁྱེར་དེའི་མི་རྣམས་ཧ་ཅང་དགའ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ཡང་སི་མོན་ཟེར་མཁན་ཞིག་གིས་སྔར་ནས་ད་བར་གྲོང་ཁྱེར་དེར་མཐུ་བརྒྱབ་ནས་ས་མར་ཡཱ་ཡུལ་གྱི་མི་རྣམས་ཡ་མཚན་སྐྱེས་སུ་བཅུག ཁོས་རང་བསྟོད་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","མི་མཐོ་དམན་ཚང་མས་ཁོ་ལ་ཉན་ཞིང་“མི་འདི་ནི་དཀོན་མཆོག་གི་ནུས་མཐུ་ཆེན་པོ་ཟེར་བ་དེ་ཡིན་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ཁོས་ཡུན་རིང་པོ་ཞིག་ནས་མཐུ་ཡིས་ཁོ་ཚོར་ཡ་མཚན་སྐྱེས་སུ་བཅུག་པས་ཡུལ་མི་རྣམས་ཀྱིས་ཁོའི་གཏམ་ལ་ནན་གྱིས་ཉན། ");
INSERT INTO bod_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","འོན་ཀྱང་ཕི་ལིབ་ནི་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དང་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་གྱི་སྐོར་འཕྲིན་བཟང་སྒྲོག་མཁན་ཡིན་པ་ལ་མི་རྣམས་ཀྱིས་ཡིད་ཆེས་བྱས་ནས། སྐྱེས་པ་དང་བུད་མེད་གཉིས་ཀས་ཁྲུས་གསོལ་བླངས། ");
INSERT INTO bod_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ཐ་ན་སི་མོན་གྱིས་ཀྱང་ཡིད་ཆེས་བྱས་ཏེ་ཁྲུས་གསོལ་བླངས་ནས་ཕི་ལིབ་དང་འགྲོགས། སི་མོན་གྱིས་ཕི་ལིབ་ཀྱི་གྲུབ་རྟགས་དང་ངོ་མཚར་ཅན་གྱི་དོན་མཐོང་བས་ཧ་ལས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ཡེ་རུ་ཤ་ལེམ་ལ་ཡོད་པའི་སྐུ་ཚབ་རྣམས་ཀྱིས་ས་མར་ཡཱ་པས་དཀོན་མཆོག་གི་བཀའ་ལ་དད་པ་བྱེད་པ་ཐོས་སྐབས། ཁོང་ཚོས་སྐུ་ཚབ་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་ཕི་ལིབ་དང་བཅས་པའི་རྩར་མངགས། ");
INSERT INTO bod_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ཁོང་ཚོ་གཉིས་མར་ཕེབས་ནས་ས་མར་ཡཱ་པ་རྣམས་ལ་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་འཐོབ་པའི་ཆེད་དུ་སྨོན་ལམ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","གང་ཡིན་ཞེ་ན། ཁོ་རྣམས་ཀྱིས་གཙོ་བོ་ཡེ་ཤུའི་མཚན་གྱི་ཐོག་ནས་ཁྲུས་གསོལ་བླངས་ཀྱང༌། དམ་པའི་ཐུགས་ཉིད་ཁོ་ཚོར་ད་དུང་མར་མ་བབས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","དེ་ནས་པེ་ཏྲོ་དང་ཡོ་ཧ་ནན་གཉིས་ཀྱིས་ས་མར་ཡཱ་པ་རྣམས་ཀྱི་ལུས་ལ་ཕྱག་འཇོག་པར་མཛད་པས་ཁོ་ཚོར་དམ་པའི་ཐུགས་ཉིད་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","སྐུ་ཚབ་རྣམས་ཀྱི་ཕྱག་འཇོག་པར་མཛད་པའི་སྒོ་ནས་དམ་པའི་ཐུགས་ཉིད་གནང་བར་མཐོང་ནས་སི་མོན་གྱིས་ཁོང་རྣམས་ལ་དངུལ་སྟེར་གྲབས་བྱས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ངས་མི་སུ་ཞིག་ལ་ལག་པ་བཞག་པ་དེས་དམ་པའི་ཐུགས་ཉིད་འཐོབ་ཕྱིར་དབང་དེ་ང་ལའང་གནང་བར་མཛོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","འོན་ཀྱང་པེ་ཏྲོས་ཁོ་ལ་“དཀོན་མཆོག་གི་གནང་སྦྱིན་ནི་དངུལ་གྱིས་འཐོབ་པར་བསམས་པས་ཁྱོད་དང་ཁྱོད་ཀྱི་དངུལ་གཉིས་མེད་པར་འགྱུར་བར་ཤོག ");
INSERT INTO bod_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","དཀོན་མཆོག་གི་སྤྱན་སྔར་ཁྱོད་ཀྱི་སེམས་དྲང་པོ་མེད་པས་ཁྱོད་ལ་དོན་འདིའི་སྐལ་བའམ་འབྲེལ་བ་ཅིའང་མེད། ");
INSERT INTO bod_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","དེའི་ཕྱིར་ངན་སེམས་འདི་སྤངས་ནས་སེམས་བསྒྱུར་བ་དང༌། གཙོ་བོ་དཀོན་མཆོག་ལ་གསོལ་བ་ཐོབ་ཅིག ཁོང་གི་ཐུགས་དགོངས་དང་མཐུན་ན་ཁྱོད་ཀྱི་ངན་སེམས་ཀྱི་སྡིག་ཉེས་སེལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","གང་ལགས་ཤེ་ན། ཁྱོད་ནི་ཆེས་ཕྲག་དོག་བྱེད་མཁན་དང༌། སྡིག་ཉེས་ཀྱིས་བཅིངས་པ་ཡིན་པ་ངས་མཐོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ལན་དུ་སི་མོན་གྱིས་“ཁྱེད་ཀྱིས་གསུངས་པའི་དོན་ང་ལ་ཅིའང་མི་འབབ་པའི་ཆེད་དུ་ཁྱེད་རྣམས་ཀྱིས་ངའི་དོན་དུ་གཙོ་བོ་ལ་སྨོན་ལམ་འདེབས་པར་མཛོད་ཅིག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","དེ་ནས་ཁོང་ཚོས་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་བསྒྲགས་པ་དང་དཔང་པོ་བྱས་པའི་རྗེས་སུ་ས་མར་ཡཱ་ཡུལ་གྱི་གྲོང་གསེབ་མང་པོར་འཕྲིན་བཟང་སྒྲོག་སྟེ་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ཡང་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་གིས་ཕི་ལིབ་ལ་“ཡར་ལོངས་ལ་ལྷོ་ཕྱོགས་ལ་ཕྱིན་ཏེ་ཡེ་རུ་ཤ་ལེམ་ནས་ག་ཟཱ་གྲོང་ཁྱེར་དུ་འབབ་པའི་ལམ་ལ་སོང་ཞིག་”ཅེས་གསུངས། (ལམ་དེ་ནི་འབྲོག་སྟོང་གི་ལམ་ཞིག་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ཕི་ལིབ་ལངས་ནས་སོང་ཞིང༌། ལམ་བར་དུ་ཨེ་ཐི་ཨོ་ཕི་ཡཱ་ཡུལ་གྱི་དབང་ཆ་ཆེ་བའི་ཉུག་རུམ་ཞིག་ཡོད་པ་དེ་ནི་ཡུལ་དེའི་རྒྱལ་མོ་ཀན་ད་སཱེ་ཟེར་བའི་བང་མཛོད་ཡོངས་ཀྱི་གཉེར་དཔོན་ཡིན། ཁོང་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུ་བའི་ཆེད་དུ་ཡེ་རུ་ཤ་ལེམ་ལ་ཕེབས་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ཤིང་རྟར་བཞུགས་ནས་རང་ཡུལ་ལ་ཕྱིར་ལོག་དུས། ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་བྲིས་པའི་མདོ་ཀློག་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཕི་ལིབ་ལ་“ཤིང་རྟ་དེའི་རྩར་ཕྱིན་ནས་མཉམ་དུ་སོང་ཞིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ཕི་ལིབ་དེའི་རྩར་བརྒྱུགས་ཤིང༌། གཉེར་དཔོན་དེས་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡི་མདོ་ཀློག་གི་ཡོད་པ་ཐོས་ནས་ཁོང་ལ་“ཁྱེད་ཀྱིས་ཀློག་པ་དེའི་དོན་རྟོགས་སམ་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","གཉེར་དཔོན་གྱིས་“སུ་ཞིག་གིས་ང་ལ་གསལ་བཤད་མ་བྱས་ན་ངས་ཇི་ལྟར་ཤེས་”ཅེས་སྨྲས་ནས་ཁོང་གིས་ཕི་ལིབ་ལ་ཤིང་རྟའི་ནང་མཉམ་དུ་སྡོད་པར་གདན་དྲངས། ");
INSERT INTO bod_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ཁོང་གིས་ཀློག་བཞིན་པའི་མདོ་ནི། ཁོང་ནི་ལུག་ལྟར་བཤས་རར་ཁྲིད་པ་ཡིན། ། བལ་འབྲེག་མཁན་སར་གནས་པའི་ལུ་གུ་བཞིན། ། སྐད་སྒྲ་མེད་པ་ལྟར་དུ་ཞལ་མི་འབྱེད། ། ");
INSERT INTO bod_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","དམའ་བའི་སྐབས་སུ་གཞུང་དྲང་ཁྲིམས་མ་བཅད། ། ཁོང་གི་གདུང་རྒྱུད་སུ་ཡིས་འཆད་པར་ནུས། ། ཁོང་གི་ཚེ་སྲོག་ས་ནས་འཕྲོག་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","གཉེར་དཔོན་གྱིས་ཕི་ལིབ་ལ་“ལུང་བསྟན་དེ་ནི་ལུང་སྟོན་པས་ཁོ་རང་ངམ་ཡང་ན་མི་གཞན་སུ་ཡི་སྐོར་གསུངས་པ་དེ་ང་ལ་གསུངས་དང་”ཞེས་སྨྲས་པ་ན། ");
INSERT INTO bod_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ཕི་ལིབ་ཀྱིས་ལུང་བསྟན་དེ་ནས་འགོ་བཙུགས་ཏེ་ཁོང་ལ་གཙོ་བོ་ཡེ་ཤུའི་འཕྲིན་བཟང་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ཁོ་ཚོ་ལམ་ལ་འགྲོ་དུས་ཆུ་ཡོད་སར་སླེབས་པས་གཉེར་དཔོན་གྱིས་“ལྟོས་དང༌། འདིར་ཆུ་འདུག ངས་ཁྲུས་གསོལ་ལེན་ན་ཅི་མ་རུང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ཤིང་རྟ་འགོག་དགོས་པའི་བཀའ་བཏང་ནས་ཕི་ལིབ་དང་གཉེར་དཔོན་གཉིས་ཆུར་ཞུགས་པ་དང༌། ཕི་ལིབ་ཀྱིས་གཉེར་དཔོན་ལ་ཁྲུས་གསོལ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ཁོང་གཉིས་ཆུ་ནས་ཕྱིར་འཐོན་སྐབས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཕི་ལིབ་མྱུར་དུ་ཁྲིད་པས་གཉེར་དཔོན་གྱིས་ཁོང་མ་མཐོང་ཡང་སེམས་དགའ་བའི་ངང་ནས་ལམ་ལ་ཕེབས་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ཡང་ཕི་ལིབ་ཨ་ཟོ་ཊོ་གྲོང་ཁྱེར་དུ་མངོན་པར་འགྱུར་ཏེ། སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་མ་སླེབས་པའི་བར་དུ་ཁོང་གིས་ཡུལ་དེ་བརྒྱུད་ནས་འགྲོ་དུས་གྲོང་ཁྱེར་ཚང་མར་འཕྲིན་བཟང་བསྒྲགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","དེའི་དུས་སུ་ཤ་ཨུལ་གྱིས་དམར་གསོད་གཏོང་བའི་གཏམ་བཤད་དེ་གཙོ་བོའི་ཉེ་གནས་རྣམས་ལ་མུ་མཐུད་ནས་འཇིགས་སྐུལ་བྱས་ཤིང༌། བླ་ཆེན་གཙོ་བོའི་དྲུང་དུ་སོང་ནས། ");
INSERT INTO bod_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ཁོས་གཙོ་བོ་ཡེ་ཤུའི་ཐར་ལམ་ལ་འཛིན་མཁན་ཏེ་སྐྱེས་པའམ་བུད་མེད་རྙེད་ན་ཡེ་རུ་ཤ་ལེམ་ལ་བཅིངས་ནས་འཁྲིད་པའི་ཕྱིར། དཱ་མེ་སེག་གྲོང་ཁྱེར་དུ་ཡོད་པའི་འདུ་ཁང་གི་འགོ་ཁྲིད་རྣམས་ལ་ངོ་སྤྲོད་ཡི་གེ་གནང་རོགས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ལམ་བར་དུ་ཤ་ཨུལ་དཱ་མེ་སེག་གི་ཉེ་འགྲམ་དུ་སླེབས་པའི་སྐབས་སུ། དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་འོད་ཅིག་ཁོའི་ཕྱོགས་བཞིར་གློ་བུར་དུ་འཁྱུགས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ཤ་ཨུལ་ས་ལ་འགྱེལ། ཁོས་“ཤ་ཨུལ། ཤ་ཨུལ། ཁྱོད་ཀྱིས་ང་ལ་ཅིའི་ཕྱིར་གནོད་སྐྱེལ་”ཞེས་གསུངས་པའི་སྒྲ་ཞིག་ཐོས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ཁོས་“གཙོ་བོ་ལགས། ཁྱེད་སུ་ཡིན་”ཞེས་བཤད་པས་ཁོང་གིས་“ང་ནི་ཁྱོད་ཀྱིས་གནོད་སྐྱེལ་བཞིན་པའི་ཡེ་ཤུ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ད་ཡར་ལོངས་ལ་གྲོང་ཁྱེར་དུ་སོང་ཞིག ཁྱོད་ཀྱིས་གང་བྱེད་དགོས་པ་དེ་ཁྱོད་ལ་སྨྲ་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","སྒྲ་དེ་ཐོས་ཀྱང་སུ་ཞིག་ཡིན་པ་མ་མཐོང་བས་ཤ་ཨུལ་གྱི་ལམ་གྲོགས་རྣམས་ཁ་རོག་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ཤ་ཨུལ་ས་ནས་ལངས་ཏེ་མིག་གདངས་ཀྱང་ཅི་ཡང་མཐོང་མ་ཐུབ། ལམ་གྲོགས་ཀྱིས་ཁོའི་ལག་པ་ནས་འཇུས་ཏེ་དཱ་མེ་སེག་ལ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ཡང་ཉིན་གསུམ་གྱི་རིང་ལ་མིག་གིས་མི་མཐོང་བ་དང་ཁོས་ཟ་འཐུང་ཅི་ཡང་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","དེའི་དུས་སུ་དཱ་མེ་སེག་ལ་ཨ་ནན་ཡཱ་ཞེས་ཟེར་བའི་ཉེ་གནས་ཤིག་ཡོད་ཅིང༌། གཙོ་བོས་ཁོ་ལ་ཞལ་གཟིགས་གནང་ནས་“ཨ་ནན་ཡཱ་”ཞེས་གསུངས་པས་ཁོས་“གཙོ་བོ་ལགས། ང་འདིར་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","གཙོ་བོས་ཁོ་ལ་“ལོངས་ལ་དྲང་པོ་ཟེར་བའི་སྲང་ལམ་ལ་སོང་ནས་ཡུ་དཱ་ཞེས་བྱ་བའི་ཁང་པར་ཊར་སཱུ་གྲོང་ཁྱེར་ནས་ཡིན་པའི་ཤ་ཨུལ་ཚོལ་ཞིག ད་ལྟ་ཁོས་སྨོན་ལམ་འདེབས་བཞིན་ཡོད་ཅིང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ཁོས་ཨ་ནན་ཡཱ་ཟེར་མཁན་ཞིག་ནང་ལ་ཡོང་ནས་མིག་གིས་སླར་ཡང་མཐོང་ཐུབ་པའི་ཆེད་དུ་ཁོ་ལ་ཕྱག་འཇོག་པ་ཞལ་གཟིགས་ཀྱི་ནང་ནས་མཐོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","འོན་ཀྱང་ཨ་ནན་ཡཱས་“གཙོ་བོ་ལགས། ཡེ་རུ་ཤ་ལེམ་ལ་མི་འདིས་ཁྱེད་ཀྱི་དད་ལྡན་རྣམས་ལ་གནོད་པ་ཅི་ལྟར་ཆེ་བ་བཏང་བ་མི་མང་པོས་ང་ལ་བཤད་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ཡང་འདིར་ཁོ་ལ་བླ་ཆེན་རྣམས་ནས་ཁྱེད་ཀྱི་མཚན་ནས་བརྗོད་མཁན་ཐམས་ཅད་འཛིན་བཟུང་བྱེད་པའི་དབང་ཡོད་”ཅེས་སྨྲས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","གཙོ་བོས་ཁོ་ལ་“ད་སོང་ཞིག མི་འདི་ནི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་དང༌། རྒྱལ་པོ། ཡི་སི་ར་ཨེལ་གྱི་མི་རྣམས་ལ་ངའི་མིང་སྒྲོག་ཕྱིར་ངས་བདམས་པའི་སྣོད་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ངའི་མིང་གི་དོན་དུ་སྡུག་བསྔལ་ཅི་ལྟར་ཆེ་བ་མྱོང་དགོས་པ་ང་རང་གིས་ཁོ་ལ་སྟོན་པར་བྱ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ཨ་ནན་ཡཱ་སོང་ནས་ཁང་པ་དེའི་ནང་ལ་འཛུལ་བ་དང་ཤ་ཨུལ་ལ་ཕྱག་བཞག་ནས་ཁོ་ལ་“སྤུན་ཟླ་ཤ་ཨུལ། ལམ་བར་དུ་ཁྱེད་ལ་མངོན་པར་མཛད་མཁན་གཙོ་བོ་ཡེ་ཤུ་ཡིས་ཁྱེད་ཀྱི་མིག་གིས་སླར་ཡང་མཐོང་ཐུབ་པའི་ཆེད་དང༌། ཁྱེད་ནི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་འགྱུར་བའི་ཕྱིར་ང་འདིར་མངགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","དེ་ལྟར་གསུངས་མ་ཐག་ཉ་ཁྲབ་འདྲ་བ་རེ་ཁོའི་མིག་ནས་ཟགས་ཏེ་མིག་གིས་སླར་ཡང་མཐོང་བར་གྱུར། ཡར་ལངས་ནས་ཁྲུས་གསོལ་ལེན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ཟས་བཟས་པས་ལུས་སྟོབས་གསོས་པར་གྱུར། ཉིན་ཤས་རིང་ཁོ་དཱ་མེ་སེག་ལ་ཡོད་པའི་ཉེ་གནས་དང་མཉམ་དུ་བསྡད་དེ། ");
INSERT INTO bod_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ཁོང་གིས་འཕྲལ་དུ་འདུ་ཁང་རྣམས་ལ་ཡེ་ཤུའི་འཕྲིན་བཟང་བསྒྲགས་ཏེ་“ཁོང་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ཁོང་གི་གཏམ་ཐོས་པ་ཐམས་ཅད་ཡ་མཚན་སྐྱེས་ནས་“ཡེ་རུ་ཤ་ལེམ་ལ་གཙོ་བོའི་མཚན་ནས་བརྗོད་མཁན་རྣམས་མེད་པར་བཟོ་མཁན་ཁོ་རང་མ་ཡིན་ནམ། ཡང་དད་ལྡན་རྣམས་བཙོན་པ་ལྟར་བླ་ཆེན་རྣམས་ཀྱི་རྩར་འཁྲིད་པའི་ཕྱིར་ཁོ་འདིར་མ་ཡོང་ངམ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ཤ་ཨུལ་གྱི་ཆོས་སྟོན་པའི་ནུས་པ་ཇེ་ཆེར་གྱུར་ཞིང༌། ཡེ་ཤུ་ནི་མཱ་ཤི་ཀ་ཡིན་པ་ར་སྤྲོད་བྱས་པས་དཱ་མེ་སེག་ལ་སྡོད་པའི་ཡ་ཧུ་དཱ་པ་ཚོས་ཁོང་གིས་ཆོས་བསྟན་པར་ལན་འདེབས་མ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ཉིན་མང་སོང་རྗེས། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཤ་ཨུལ་གསོད་རྒྱུའི་ངན་ཇུས་བྱས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ཤ་ཨུལ་གྱིས་ཁོ་ཚོའི་ཇུས་ངན་ཤེས་པར་གྱུར། ཁོང་གསོད་པའི་ཆེད་དུ་ཁོ་ཚོས་ཉིན་མཚན་མེད་པར་གྲོང་ཁྱེར་གྱི་སྒོ་རྣམས་བསྲུངས། ");
INSERT INTO bod_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","འོན་ཀྱང་ཁོང་གི་ཉེ་གནས་རྣམས་ཀྱིས་མཚན་མོར་ཤ་ཨུལ་སླེ་པོ་ཆེན་པོ་ཞིག་གི་ནང་དུ་བླུགས་ནས་ལྕགས་རིའི་ཨི་ཁུང་བརྒྱུད་ནས་མར་ཕབ་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ནས་ཁོང་ཉེ་གནས་རྣམས་དང་འགྲོགས་འདོད་ཀྱང༌། ཁོང་ཉེ་གནས་དངོས་ཡིན་པར་ཡིད་མ་ཆེས་པས་ཁོ་ཚོ་ཚང་མས་ཁོང་ལ་འཇིགས། ");
INSERT INTO bod_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","འོན་ཀྱང་པར་ན་པཱས་ཁོང་ལ་རོགས་པ་བྱས་ཏེ་སྐུ་ཚབ་རྣམས་ཀྱི་མདུན་དུ་འཁྲིད་ཅིང༌། ལམ་བར་དུ་གཙོ་བོ་ཡེ་ཤུ་ཇི་ལྟར་མཐོང་ནས་གཙོ་བོས་ཁོང་ལ་ཅི་གསུངས་པ་དང༌། དཱ་མེ་སེག་ལ་ཡང་ཡེ་ཤུའི་མཚན་གྱི་ཐོག་ནས་ཤ་ཨུལ་གྱིས་འཇིགས་པ་མེད་པར་འཕྲིན་བཟང་བསྒྲགས་པའི་སྐོར་སྐུ་ཚབ་རྣམས་ལ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ཡེ་རུ་ཤ་ལེམ་ལ་ཁོང་མངོན་སུམ་དུ་ཁོ་ཚོ་དང་འགྲོགས་ཏེ་གཙོ་བོའི་མཚན་གྱི་ཐོག་ནས་འཇིགས་པ་མེད་པར་ཆོས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ཁོང་གིས་གྷི་རིག་སྐད་སྨྲ་བའི་ཡ་ཧུ་དཱ་པ་རྣམས་དང་གཏམ་བཤད་ཅིང་རྩོད་གླེང་བྱས། འོན་ཀྱང་མི་དེ་ཚོས་ཁོང་གསོད་ཐབས་བཙལ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","དོན་དེའི་སྐོར་ཤེས་ནས་སྤུན་ཟླ་རྣམས་ཀྱིས་ཤ་ཨུལ་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་མར་འཁྲིད་པ་དང༌། ཁོང་ཊར་སཱུ་གྲོང་ཁྱེར་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","དེའི་དུས་སུ་ཡ་ཧུ་དཱ་དང༌། ག་ལིལ། ས་མར་ཡཱ་ཡུལ་ཀུན་ལ་ཆོས་ཚོགས་ཞི་བདེའི་ངང་ནས་བློ་སྒོ་ཕྱེ་བར་གྱུར་ཞིང༌། གཙོ་བོ་ལ་བཀུར་སྟི་བྱེད་པ་དང་དམ་པའི་ཐུགས་ཉིད་ཀྱི་སེམས་གསོ་བའི་ངང་ནས་གནས་ཏེ་འཕེལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","པེ་ཏྲོ་ཡུལ་དེ་ཚོ་བརྒྱུད་ནས་ཕེབས་པའི་དུས་སུ་ཁོང་ལུ་དཱ་གྲོང་ཁྱེར་ལ་སྡོད་པའི་དད་ལྡན་རྣམས་ཀྱི་རྩར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","དེར་ལོ་བརྒྱད་ཀྱི་བར་དུ་གོམ་པ་སྤོ་མི་ཐུབ་པར་ཉལ་ཁྲིའི་སྟེང་སྡོད་དགོས་པའི་ཨ་ནི་ཡཱ་ཟེར་མཁན་ཞིག་དང་ཕྲད། ");
INSERT INTO bod_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","པེ་ཏྲོས་ཁོ་ལ་“ཨ་ནི་ཡཱ། ཡེ་ཤུ་མཱ་ཤི་ཀ་ཡིས་ཁྱོད་གསོ་བར་མཛད། ལོངས་ལ་ཉལ་ཁྲི་སྡུས་ཤིག་”ཅེས་གསུངས་པས་ནད་པ་དེ་འཕྲལ་དུ་ཡར་ལངས། ");
INSERT INTO bod_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ཡང་ལུ་དཱ་གྲོང་ཁྱེར་དང་ཞ་རོན་ཞེས་པའི་ཡུལ་ལ་སྡོད་མཁན་ཚང་མས་ཁོ་མཐོང་བས་སེམས་བསྒྱུར་ནས་གཙོ་བོར་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ཡོ་ཕཱ་གྲོང་ཁྱེར་དུ་ཐཱ་པི་ཐཱ་ཞེས་བྱ་བའི་ཉེ་གནས་ཤིག་ཡོད། (གྷི་རིག་སྐད་དུ་ཐཱ་པི་ཐཱ་ཞེས་པའི་དོན་ནི་དོར་ཀེ་ཡིན་) ཁོ་མོས་སྦྱིན་པ་མང་པོ་བཏང་ཞིང་ལས་བཟང་མུ་མཐུད་ནས་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","དེའི་དུས་སུ་ཁོ་མོ་ནད་ཀྱིས་བཏབ་ནས་ཤི་བས། ཁོ་རྣམས་ཀྱིས་སྤུར་བཀྲུས་ནས་ཐོག་ཁང་གཅིག་ལ་བཞག ");
INSERT INTO bod_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ཡོ་ཕཱ་གྲོང་ཁྱེར་ནི་ལུ་དཱ་གྲོང་དང་ཉེ་བར་ཆགས་པས། པེ་ཏྲོ་དེར་ཡོད་པའི་གཏམ་ཐོས་པའི་ཚེ་ཉེ་གནས་རྣམས་ཀྱིས་མི་གཉིས་ཁོང་གི་དྲུང་དུ་བཏང་སྟེ་ང་ཚོའི་རྩར་མགྱོགས་པོར་ཕེབས་རོགས་ཞེས་ནན་གྱིས་བསྐུལ་བའི་རྐྱེན་གྱིས། ");
INSERT INTO bod_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","པེ་ཏྲོ་ལངས་ནས་ཁོ་ཚོ་དང་མཉམ་དུ་ཕེབས་པ་དང༌། དེར་སླེབས་ནས་ཁོ་ཚོས་ཐོག་ཁང་ནང་ལ་འཁྲིད། ཡུགས་མོ་ཚང་མས་ཁོང་གི་འཁྲིས་ལ་ལངས་ཏེ་ངུས་ཤིང༌། དོར་ཀེ་ཡིས་ཁོ་ཚོ་དང་མཉམ་དུ་ཡོད་དུས་བཟོས་པའི་ཕྱི་གོས་དང་གྱོན་ཆས་ཁོང་ལ་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","པེ་ཏྲོས་ཁོ་ཚོ་ཚང་མ་ཕྱིར་བཏོན་པ་དང༌། པུས་མོ་སར་བཙུགས་ནས་སྨོན་ལམ་བཏབ། སྤུར་གྱི་ཕྱོགས་སུ་ཁ་ཚུར་གཅུས་ཏེ་ཁོང་གིས་“ཐཱ་པི་ཐཱ། ཡར་ལོངས་ཤིག་”ཅེས་སྨྲས་པས་ཁོ་མོས་མིག་གདངས་ཏེ་པེ་ཏྲོ་མཐོང་ནས་ཡར་བླངས། ");
INSERT INTO bod_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","པེ་ཏྲོས་བུད་མེད་དེའི་ལག་པ་ནས་འཇུས་ཤིང་ཡར་བསྐྱོར་ཏེ་ལངས་སུ་བཅུག་པ་དང༌། ཡུགས་མོ་ཚུད་པའི་དད་ལྡན་རྣམས་འབོད་དེ་ཁོ་མོ་གསོན་པོར་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","དོན་དེ་ཡོ་ཕཱ་གྲོང་ཁྱེར་གྱི་ས་ཕྱོགས་གང་སར་ཁྱབ་པས་མི་མང་པོས་གཙོ་བོ་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","དེའི་དུས་སུ་པེ་ཏྲོ་ཡོ་ཕཱ་ལ་ཀོ་བ་མཉེད་མཁན་སི་མོན་ཞེས་བྱ་བའི་ཁྱིམ་དུ་ཉིན་མང་པོ་བཞུགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་ཀོར་ནེ་ལི་ཡཱུ་ཞེས་ཟེར་བའི་མི་ཞིག་ཡོད་དེ། ཁོ་ནི་དབྱི་ཏ་ལི་པ་ཞེས་པའི་དམག་དཔུང་གི་བརྒྱ་དཔོན་ཡིན་ལ། ");
INSERT INTO bod_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ཆོས་སེམས་དང་ལྡན་པའི་མི་ཞིག་ཀྱང་ཡིན་ཏེ་ཁོ་རང་དང་ནང་མི་ཚང་མས་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད། དབུལ་པོ་རྣམས་ལ་སྦྱིན་པ་མང་པོ་བཏང་ཞིང་དཀོན་མཆོག་ལ་རྒྱུན་དུ་སྨོན་ལམ་འདེབས། ");
INSERT INTO bod_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ཕྱི་དྲོའི་ཆུ་ཚོད་གསུམ་པ་ཙམ་ལ་ཞལ་གཟིགས་གནང་ནས་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་རང་གི་སར་ཕེབས་པ་གསལ་པོར་མཐོང་ནས་ཁོ་ལ་“ཀོར་ནེ་ལི་ཡཱུ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ཁོ་འཇིགས་སྐྲག་སྐྱེས་ནས་ཁོང་ལ་མིག་ནན་གྱིས་བལྟས་ཏེ་ཁོས་“སྐུ་ཞབས། ཅི་ལགས་”ཞེས་ཟེར་བས་ཕོ་ཉས་ཁོ་ལ་“ཁྱོད་ཀྱི་སྨོན་ལམ་དང་སྦྱིན་པ་རྣམས་དྲན་རྟེན་ལྟར་དཀོན་མཆོག་གི་མདུན་དུ་བྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ད་སི་མོན་ཏེ་པེ་ཏྲོ་ཡང་ཟེར་བ་དེ་ཚུར་འཁྲིད་པའི་ཕྱིར་ཡོ་ཕཱ་ལ་མི་འགའ་ཤས་གཏོང་ཞིག ");
INSERT INTO bod_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ཁོ་ནི་རྒྱ་མཚོའི་འགྲམ་ལ་གནས་པའི་ཀོ་བ་མཉེད་མཁན་སི་མོན་གྱི་ཁང་པར་བཞུགས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","བརྒྱ་དཔོན་ལ་གསུང་མཁན་ཕོ་ཉ་དེ་ཕེབས་པ་དང༌། ཁོས་རང་གི་གཡོག་པོ་གཉིས་དང་ཁོ་ལ་གཡོག་བྱེད་མཁན་དམག་མིའི་ནང་ནས་ཆོས་སེམས་དང་ལྡན་པ་ཞིག་བོས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","དོན་དེ་ཐམས་ཅད་ཁོ་ཚོར་གསལ་བཤད་བྱས་ཏེ་ཁོས་ཁོ་རྣམས་ཡོ་ཕཱ་གྲོང་ཁྱེར་དུ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","དེའི་སང་ཉིན་ཁོ་ཚོ་ལམ་ལ་འགྲོ་དུས་གྲོང་ཁྱེར་དང་ཉེ་བར་སླེབས་པ་དང༌། ཉིན་གུང་ཙམ་ལ་སྨོན་ལམ་འདེབས་པའི་ཆེད་དུ་པེ་ཏྲོ་ཁང་པའི་ཐོག་ཁར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ཁོང་ལྟོགས་ཏེ་ཟས་ཟ་བར་འདོད་ཅིང་ཁ་ལག་གྲ་སྒྲིག་བྱེད་བཞིན་པའི་དུས་སུ་ཁོང་གིས་ཞལ་གཟིགས་མཐོང་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","དཀོན་མཆོག་གི་ཞིང་ཁམས་བྱེ་ནས་རས་ཆེན་པོ་དང་འདྲ་བ་ཞིག་གྲུ་བཞི་ནས་བཟུང་སྟེ་ས་ལ་མར་འབེབས་བཞིན་པ་ཁོང་གིས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","དེའི་ནང་ལ་རྐང་པ་བཞི་ལྡན་གྱི་སེམས་ཅན་དང༌། ས་ལ་འགྲོ་བའི་འབུ་སྲིན། ནམ་མཁའི་བྱ་བྱིའུ་སྣ་ཚོགས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","དེ་ནས་“པེ་ཏྲོ། ལོངས་ལ་འདི་རྣམས་ལས་གང་རུང་ཞིག་བསད་ནས་ཟོ་ཞིག་”ཅེས་གསུངས་པའི་སྐད་ཅིག་བྱུང་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","པེ་ཏྲོས་“གཙོ་བོ་ལགས། ངས་མི་བྱ། གང་ཡིན་ཞེ་ན། ཆོས་ཁྲིམས་ལྟར་ཟས་མི་རུང་བའམ། མི་གཙང་བ་ངས་གཏན་ནས་ཟ་མ་མྱོང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ཡང་ཐེངས་གཉིས་པར་སྐད་དེས་“དཀོན་མཆོག་གིས་གང་གཙང་མར་མཛད་པ་དེ་ཁྱོད་ཀྱིས་མི་གཙང་བར་རྩི་མི་རུང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","དོན་དེ་ཐེངས་གསུམ་བྱུང་བའི་རྗེས་སུ་འཕྲལ་དུ་རས་ཆེན་དེ་ཞིང་ཁམས་སུ་ཡར་འཐེན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","པེ་ཏྲོས་ཞལ་གཟིགས་དེའི་དོན་མ་རྟོགས་པས་ག་བྱེད་འདི་བྱེད་མེད་པར་གྱུར་བའི་དུས་དེར། གློ་བུར་དུ་བརྒྱ་དཔོན་ཀོར་ནེ་ལི་ཡཱུ་ཡིས་བཏང་བའི་མི་རྣམས་ཀྱིས་སི་མོན་གྱི་ཁང་པར་འགྲོ་བའི་ལམ་གང་ཡིན་དྲིས་ནས་སྒོའི་འགྲམ་ལ་སླེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","སི་མོན་ནམ་པེ་ཏྲོ་ཡང་བྱ་བ་ཞིག་དེར་བཞུགས་ཀྱི་ཡོད་མེད་དྲིས་ཏེ་བོས། ");
INSERT INTO bod_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","པེ་ཏྲོས་ཞལ་གཟིགས་ཀྱི་དོན་དེའི་སྐོར་བསམ་བློ་ཞིབ་ཕྲ་གཏོང་དུས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོ་ལ་“ལྟོས་ཤིག མི་གསུམ་གྱིས་ཁྱོད་འཚོལ་བཞིན་འདུག ");
INSERT INTO bod_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ད་ལོངས་ལ་མར་འབབ། ང་རང་གིས་དེ་རྣམས་བཏང་བས་ཁྱོད་ཐེ་ཚོམ་མེད་པར་ཁོ་ཚོ་དང་མཉམ་དུ་སོང་ཞིག་”ཅེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","པེ་ཏྲོ་ཁོ་ཚོའི་རྩར་མར་བབས་ནས་“ཁྱེད་རྣམས་ཀྱིས་འཚོལ་བཞིན་པ་དེ་ང་ཡིན། ཁྱེད་རྣམས་ཅིའི་ཕྱིར་ཕེབས་པ་ཡིན་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ལན་དུ་ཁོ་ཚོས་“ང་ཚོ་བརྒྱ་དཔོན་ཀོར་ནེ་ལི་ཡཱུའི་ས་ནས་ཡོང་བ་ཡིན། ཁོང་ནི་རང་གཤིས་དྲང་བ་དང་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་ཅིག་ཡིན་ཏེ་ཡ་ཧུ་དཱ་པའི་མི་རིགས་ཡོངས་ཀྱིས་ཁོང་ལ་བཀུར་སྟི་བྱེད། དཀོན་མཆོག་གི་ཕོ་ཉ་དམ་པ་ཞིག་གིས་ཁོང་ལ་ཁྱེད་ཀྱི་གསུང་ཉན་པའི་ཆེད་དུ་ཁྱེད་གདན་འདྲེན་ཞུས་དགོས་པའི་བཀའ་གནང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","དེ་ནས་པེ་ཏྲོས་ཁོ་རྣམས་བསུས་ནས་ཁང་པ་དེར་བཞུགས། དེའི་སང་ཉིན་པེ་ཏྲོ་ལངས་ཤིང༌། ཡོ་ཕཱ་གྲོང་ཁྱེར་ནས་དད་ལྡན་པ་ཁ་ཤས་དང་འགྲོགས་ཏེ་ཁོ་ཚོ་དང་མཉམ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","དེའི་ཕྱི་ཉིན་ཁོ་རྣམས་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་སླེབས། ཀོར་ནེ་ལི་ཡཱུ་ཡིས་རང་གི་གཉེན་ཉེ་དང་སྙིང་གྲོགས་བོས་ནས་བསྒུགས། ");
INSERT INTO bod_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","པེ་ཏྲོ་ནང་ལ་ཞུགས་པས་ཀོར་ནེ་ལི་ཡཱུ་ཡིས་ཁོང་གདན་འདྲེན་ཞུས་པ་དང༌། ཁོང་གི་ཞབས་ཀྱི་དྲུང་དུ་ཕྱག་འཚལ། ");
INSERT INTO bod_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","འོན་ཀྱང་པེ་ཏྲོས་ཁོ་ཡར་སྐྱོར་ཏེ་“ལོངས་དང༌། ངའང་མི་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ཁོ་དང་གཏམ་གླེང་བྱེད་བཞིན་ནང་ལ་ཕྱིན་པ་དང༌། ཁོང་གིས་མི་ཚོགས་འཛོམས་ཡོད་པ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ཡང་ཁོང་གིས་ཁོ་ཚོར་“ཡ་ཧུ་དཱ་ཡིན་པའི་མི་ཞིག་གིས་ཡ་ཧུ་དཱ་པ་མིན་པའི་མི་དང་འགྲོགས་སམ། ཐུག་འཕྲད་བྱེད་པ་དེ་ཆོས་ཁྲིམས་དང་འགལ་བ་ཡིན་པར་ཁྱེད་རང་གིས་ཤེས། འོན་ཀྱང་དཀོན་མཆོག་གིས་ངས་སུ་ལའང་ལྷད་ཡོད་པ་དང་ཡང་ན། མི་གཙང་བར་རྩི་མི་རུང་བ་དེ་ང་ལ་བསྟན་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","དེའི་ཕྱིར་ང་འདིར་འབོད་སྐབས་ངས་ངོ་རྒོལ་མ་བྱས་པར་ཡོང༌། ཁྱེད་ཀྱིས་ང་འདིར་འདྲེན་པའི་དོན་ཅི་ཡིན་”ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ཀོར་ནེ་ལི་ཡཱུ་ཡིས་“ཉིན་བཞིའི་སྔོན་གྱི་དུས་འདི་རང་སྟེ་ཕྱི་དྲོའི་ཆུ་ཚོད་གསུམ་པར་ངའི་ཁང་པའི་ནང་ལ་སྨོན་ལམ་བཏབ་པའི་ཚེ། གློ་བུར་དུ་འོད་འཕྲོ་བའི་ན་བཟའ་གྱོན་པ་ཞིག་ངའི་མདུན་ལ་བཞེངས་ནས་བཞུགས་ཡོད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ཁོང་གིས་ང་ལ་ཀོར་ནེ་ལི་ཡཱུ། དཀོན་མཆོག་གིས་ཁྱོད་ཀྱི་སྨོན་ལམ་གསན་ཞིང་སྦྱིན་པ་བཏང་བའང་གཟིགས། ");
INSERT INTO bod_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","དེའི་ཕྱིར་མི་རྣམས་ཡོ་ཕཱ་ལ་བཏང་ནས་སི་མོན་ནམ་པེ་ཏྲོ་ཡང་བྱ་བ་འདིར་འདྲེན་ཞིག ཁོ་ནི་རྒྱ་མཚོའི་འགྲམ་ལ་གནས་པའི་ཀོ་བ་མཉེད་མཁན་སི་མོན་གྱི་ཁང་པར་བཞུགས་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","དེའི་ཕྱིར་ངས་ལམ་སེང་ཁྱེད་གདན་འདྲེན་ཞུས་ཏེ། ཁྱེད་རང་འདིར་ཕེབས་ན་ལེགས། ད་གཙོ་བོས་ཁྱེད་ལ་གནང་བའི་བཀའ་ཐམས་ཅད་ལ་ཉན་པའི་ཆེད་དུ་ང་ཚོ་ཚང་མ་དཀོན་མཆོག་གི་སྤྱན་སྔར་འདིར་འཛོམས་ཡོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","དེ་ནས་པེ་ཏྲོས་“དཀོན་མཆོག་གིས་ཕྱོགས་རིས་མི་མཛད་པ་དེ་ངས་ད་ལྟ་ཐེ་ཚོམ་མེད་པར་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","མི་རིགས་ཐམས་ཅད་ཀྱི་ཁྲོད་དུ་སུ་ཡང་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་ཞུ་བ་དང་དྲང་བའི་ལས་སྒྲུབ་མཁན་དེ་ལ་ཁོང་ཐུགས་མཉེས། ");
INSERT INTO bod_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","དཀོན་མཆོག་གིས་ཡི་སི་ར་ཨེལ་མི་རིགས་ལ་གནང་བའི་འཕྲིན་བཟང་ཁྱེད་ཀྱིས་ཤེས། དེ་ནི་ཐམས་ཅད་ཀྱི་གཙོ་བོ་ཡིན་ཏེ་ཡེ་ཤུ་མཱ་ཤི་ཀ་ལ་དད་པའི་སྒོ་ནས་ཞི་བདེ་འཐོབ་པའི་འཕྲིན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ཡོ་ཧ་ནན་གྱིས་ཁྲུས་གསོལ་ལེན་དགོས་པའི་འཕྲིན་སྒྲོག་པའི་རྗེས་སུ་ག་ལིལ་ཡུལ་ནས་ཡ་ཧུ་དཱ་ཡུལ་ཡོངས་སུ་ཅི་བྱུང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ཅི་ལྟར་དཀོན་མཆོག་གིས་ན་ཙ་རེལ་པ་ཡེ་ཤུ་ལ་དམ་པའི་ཐུགས་ཉིད་དང་ནུས་མཐུ་གནང་ཞིང༌། དཀོན་མཆོག་ཁོང་དང་མཉམ་དུ་བཞུགས་པས་ཁོང་གིས་ལས་བཟང་པོ་སྒྲུབ་ཅིང༌། བདུད་ཀྱིས་མནན་པ་ཐམས་ཅད་གསོ་བར་མཛད་པ་དེ་ཁྱེད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ཁོང་གིས་ཡ་ཧུ་དཱ་ཡུལ་དང་ཡེ་རུ་ཤ་ལེམ་གྲོང་ཁྱེར་དུ་གང་མཛད་པ་ཐམས་ཅད་ཀྱི་དཔང་པོ་ང་ཚོ་ཡིན། རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་པའི་སྒོ་ནས་ཁོ་ཚོས་ཁོང་བསད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ཉི་མ་གསུམ་པར་དཀོན་མཆོག་གིས་ཁོང་འཆི་བ་ནས་སླར་གསོན་པོར་མཛད་ནས་ཁོང་མངོན་དུ་བཅུག་གོ ");
INSERT INTO bod_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","མི་ཐམས་ཅད་ལ་ཁོང་མངོན་སུམ་དུ་མ་བསྟན་པར། འཆི་བ་ནས་སྐུ་གསོན་པོར་བཞེངས་ནས་ཁོང་དང་མཉམ་དུ་ཟ་ཞིང་འཐུང་མཁན་ཏེ་དཀོན་མཆོག་གིས་སྔར་འདེམས་པར་མཛད་པའི་དཔང་པོ་ཡིན་པ་ང་ཚོས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ཡང་ཁོང་གིས་ང་ཚོར་མི་རྣམས་ལ་ཆོས་སྟོན་པ་དང༌། ཁོང་ཉིད་དཀོན་མཆོག་གིས་བསྐོས་པར་མཛད་དེ་ཤི་གསོན་གཉིས་ཀྱི་ཁྲིམས་དཔོན་ཡིན་པ་བདེན་དཔང་བྱེད་དགོས་པའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ཡང་ཁོང་གི་སྐོར་ལུང་སྟོན་པ་ཚང་མས། ཁོང་ལ་དད་པ་བྱེད་མཁན་ཐམས་ཅད་ཁོང་གི་མཚན་གྱི་ཐོག་ནས་སྡིག་སེལ་འཐོབ་པར་འགྱུར་ཞེས་པའི་དཔང་པོ་མཛད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","པེ་ཏྲོས་མུ་མཐུད་གསུངས་པའི་སྐབས་སུ་དམ་པའི་ཐུགས་ཉིད་བཀའ་ཐོས་མཁན་ཐམས་ཅད་ལ་བབས། ");
INSERT INTO bod_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལའང་དཀོན་མཆོག་གི་གནང་སྦྱིན་ཏེ་དམ་པའི་ཐུགས་ཉིད་ཐོབ་པའི་རྐྱེན་གྱིས། ཡ་ཧུ་དཱ་པའི་དད་ལྡན་པ་ཆོས་ཀྱི་རྟགས་དང་ལྡན་པ་རྣམས་པེ་ཏྲོ་དང་མཉམ་དུ་ཡོང་མཁན་ཚང་མ་ཡ་མཚན་ཆེན་པོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","དེ་ནི་དམ་པའི་ཐུགས་ཉིད་འཐོབ་པ་རྣམས་ཀྱིས་སྐད་རིགས་གཞན་རྣམས་སྤྱད་ནས་སྐད་ཆ་བཤད་པ་དང༌། དཀོན་མཆོག་ལ་བསྟོད་བསྔགས་བྱེད་པ་ཐོས་པས་སོ། དེ་ནས་པེ་ཏྲོས་ ");
INSERT INTO bod_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“མི་འདི་རྣམས་ཆུ་ཡིས་ཁྲུས་གསོལ་བྱེད་པར་སུས་སྔོན་འགོག་བྱེད་དམ། ང་ཚོ་ལྟར་ཁོ་ཚོ་ལའང་དམ་པའི་ཐུགས་ཉིད་ཐོབ་བོ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་ཐོག་ནས་ཁོ་རྣམས་ལ་ཁྲུས་གསོལ་བྱེད་པའི་བཀའ་གནང་ནས། ཁོ་ཚོས་ཁོང་ཉིན་ཤས་བཞུགས་པར་གདན་འདྲེན་ཞུས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","དེ་ཡང་ཡ་ཧུ་དཱ་ཡུལ་གང་སར་ཡོད་པའི་སྐུ་ཚབ་དང་དད་ལྡན་པའི་སྤུན་ཟླ་རྣམས་ཀྱིས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་ཀྱང་དཀོན་མཆོག་གི་བཀའ་དང་ལེན་བྱས་པའི་གཏམ་ཐོས། ");
INSERT INTO bod_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","པེ་ཏྲོ་ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ནས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དང་ལྡན་པའི་དད་ལྡན་པ་ཁ་ཅིག་གིས་ཁོང་ལ་སྐྱོན་བརྗོད་བྱས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ཆོས་ཀྱི་རྟགས་མེད་པ་རྣམས་ཀྱི་ཁང་པར་ཞུགས་ནས་ཁྱོད་ཀྱིས་མི་དེ་ཚོ་དང་མཉམ་དུ་ཁ་ལག་ཀྱང་བཟས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","དེ་ནས་པེ་ཏྲོས་ཁོ་རྣམས་ལ་རིམ་གྱིས་གསལ་བཤད་བྱས་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ཡོ་ཕཱ་གྲོང་ཁྱེར་དུ་སྨོན་ལམ་འདེབས་པའི་སྐབས་ཞལ་གཟིགས་ཀྱི་ནང་ནས་རས་ཆེན་པོ་དང་འདྲ་བ་ཞིག་གྲུ་བཞི་ནས་བཟུང་སྟེ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་ངའི་མདུན་དུ་ཕབ་པ་ངས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","དེ་ལ་ནན་གྱིས་བལྟས་པས་ངས་རྐང་པ་བཞི་ལྡན་གྱི་སེམས་ཅན་དང༌། གཅན་གཟན། ས་ལ་འགྲོ་བའི་འབུ་སྲིན། ནམ་མཁའི་བྱ་བྱིའུ་བཅས་མཐོང་ནས། ");
INSERT INTO bod_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ང་ལ་པེ་ཏྲོ། ལོངས་ལ་འདི་རྣམས་ལས་གང་རུང་ཞིག་བསད་ནས་ཟོ་ཞིག་ཅེས་གསུངས་པའི་སྐད་ཅིག་ངས་ཐོས། ");
INSERT INTO bod_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","འོན་ཀྱང་ངས་གཙོ་བོ་ལགས། ངས་མི་བྱ། གང་ཡིན་ཞེ་ན། ཆོས་ཁྲིམས་ལྟར་ན་ཟས་མི་རུང་བའམ། མི་གཙང་བ་ངས་གཏན་ནས་ཟ་མ་མྱོང་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ཡང་ཐེངས་གཉིས་པར་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་སྐད་དེས་དཀོན་མཆོག་གིས་གང་གཙང་མར་མཛད་པ་དེ་ཁྱོད་ཀྱིས་མི་གཙང་བ་རྩི་མི་རུང་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","དེ་ལྟར་ཐེངས་གསུམ་བྱུང་བའི་རྗེས་སུ་ཐམས་ཅད་ཞིང་ཁམས་ལ་དྲངས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","དུས་དེ་རང་ལ་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ནས་ངའི་རྩར་བཏང་བའི་མི་གསུམ་ང་ཚོ་སྡོད་སའི་ཁང་པར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ང་ལ་ཁོ་ཚོ་དང་ང་ཚོའི་བར་དུ་དབྱེ་བ་མ་འབྱེད་པར་འགྲོ་དགོས་པའི་བཀའ་གནང༌། ཡང་སྤུན་ཟླ་དྲུག་པོ་འདི་ཡང་ང་དང་མཉམ་དུ་ཕེབས་ཏེ། ངེད་རྣམས་མི་དེའི་ཁྱིམ་ཚང་ལ་ཞུགས། ");
INSERT INTO bod_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ཡང་ཁོས་དཀོན་མཆོག་གི་ཕོ་ཉ་ཁོའི་ཁང་པའི་ནང་ལ་བཞུགས་ཡོད་པ་མཐོང་སྟེ་ཕོ་ཉས་སི་མོན་ནམ་པེ་ཏྲོ་ཡང་ཟེར་བ་ཚུར་འཁྲིད་པའི་ཕྱིར་ཡོ་ཕཱ་ལ་མི་རྣམས་གཏོང་ཞིག ");
INSERT INTO bod_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ཁོང་གིས་སྒྲོག་པའི་འཕྲིན་གྱི་སྒོ་ནས་ཁྱོད་དང་ཁྱོད་ཀྱི་ནང་མི་ཐམས་ཅད་ཐར་བར་འགྱུར་ཞེས་གསུངས་པའི་གཏམ་ངེད་རྣམས་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ངས་ཁོ་རྣམས་ལ་བཤད་པར་བརྩམས་པའི་ཚེ་དམ་པའི་ཐུགས་ཉིད་ནི་ཐོག་མར་ང་ཚོར་བབས་པ་ལྟར་ཁོ་ཚོ་ལའང་བབས། ");
INSERT INTO bod_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ཡང་གཙོ་བོས་གསུངས་པའི་བཀའ་སྟེ་ཡོ་ཧ་ནན་གྱིས་ཆུ་ཡིས་ཁྲུས་གསོལ་གནང་ན་ཡང་ཁྱེད་རྣམས་ལ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྲུས་གསོལ་གནང་བར་འགྱུར་ཞེས་གསུངས་པ་དེ་ངས་དྲན། ");
INSERT INTO bod_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","དེ་བས་ན་ངེད་རྣམས་ཀྱིས་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་ལ་དད་པ་བྱས་པའི་རྗེས་སུ་ང་ཚོར་གནང་བའི་སྦྱིན་པ་དེ་རང་ནི་དཀོན་མཆོག་གིས་ཁོ་ཚོ་ལའང་གནང་བ་ཡིན་ན། ང་དཀོན་མཆོག་ལ་ངོ་རྒོལ་བྱེད་མཁན་དུ་འགྱུར་བ་དེ་ཅི་ལྟར་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","དེ་ཐོས་པས་རྩོད་པ་སྤངས་ནས་དཀོན་མཆོག་ལ་བསྟོད་ར་བྱས་ཏེ་“བྱས་ན། དཀོན་མཆོག་གིས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལའང་སེམས་བསྒྱུར་ནས་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པར་གནང་བ་ཡིན་ནོ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","དེ་ནས་སེ་ཏེ་ཕཱན་གྲོངས་པའི་རྗེས་སུ་གནོད་པ་བྱུང་བས་ཁ་འཐོར་ཡོད་པ་རྣམས་ཀྱིས་ཡ་ཧུ་དཱ་པ་ཁོ་ན་ལས་གཞན་སུ་ལའང་བཀའ་མི་སྒྲོགས་པར་ཕེ་ནི་ཀེ་ཡུལ་དང༌། ཀིབ་རུ་གླིང་ཕྲན། སི་རི་ཡཱ་ཡུལ་གྱི་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་ལ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","འོན་ཀྱང་དེ་ཚོའི་ཁྲོད་དུ་ཀིབ་རུ་དང༌། སེ་རེ་ནཱ་ཞེས་པའི་གྲོང་ཁྱེར་ནས་ཡིན་པའི་མི་ཁ་ཅིག་གིས་ཨན་ཏི་ཡོག་ཡཱ་ལ་སླེབས་ནས་གྷི་རིག་སྐད་སྨྲ་བའི་ཡ་ཧུ་དཱ་པ་རྣམས་ལའང་གཙོ་བོ་ཡེ་ཤུའི་འཕྲིན་བཟང་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","དཀོན་མཆོག་གི་ནུས་མཐུ་ཁོ་ཚོ་དང་མཉམ་དུ་བཞུགས་པའི་རྐྱེན་གྱིས། མི་ཧ་ཅང་མང་པོས་སེམས་བསྒྱུར་ནས་གཙོ་བོ་ལ་དད་པ་བྱས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","དོན་དེའི་སྐོར་ཡེ་རུ་ཤ་ལེམ་གྱི་ཆོས་ཚོགས་ཀྱི་མིའི་རྣ་ལམ་དུ་ཐོས་པས་པར་ན་པཱ་ཟེར་བ་དེ་ཨན་ཏི་ཡོག་ཡཱ་ལ་མངགས། ");
INSERT INTO bod_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ཁོང་དེར་སླེབས་ནས་དཀོན་མཆོག་གི་ཐུགས་རྗེ་མཐོང་བས་ཁོང་སེམས་དགའ་བར་གྱུར། ཁོང་གིས་ཁོ་རྣམས་ལ་བློ་སེམས་གཅིག་གིས་གཙོ་བོ་ལ་རྟེན་དགོས་པར་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","གང་ལགས་ཟེར་ན། ཁོང་ནི་མི་བཟང་པོ་ཞིག་ཡིན་ཏེ། དད་པ་དང་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བ་ཞིག་ཡིན། ཡང་མི་ཤིན་ཏུ་མང་པོས་གཙོ་བོ་ལ་དད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","དེ་ནས་པར་ན་པཱ་ཤ་ཨུལ་འཚོལ་བའི་ཆེད་དུ་ཊར་སཱུ་གྲོང་ཁྱེར་ལ་ཕེབས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ཁོང་རྙེད་ནས་ཨན་ཏི་ཡོག་ཡཱ་ལ་འཁྲིད། ལོ་གཅིག་གི་བར་དུ་ཁོང་རྣམས་ཆོས་ཚོགས་དང་འགྲོགས་ཏེ་མི་མང་པོར་ཆོས་བསྟན། ཨན་ཏི་ཡོག་ཡཱར་ཉེ་གནས་རྣམས་ཀྱི་སྤྱི་མིང་ལ་མཱ་ཤི་ཀ་པ་ཞེས་ཐོག་མར་བཏགས། ");
INSERT INTO bod_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","དེའི་དུས་སུ་ལུང་སྟོན་པ་ཁ་ཤས་ཡེ་རུ་ཤ་ལེམ་ནས་ཨན་ཏི་ཡོག་ཡཱར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ཁོ་ཚོའི་ནང་ནས་ཨ་ག་བཱུ་ཟེར་མཁན་ཞིག་གིས་ཚོགས་པའི་ཁྲོད་དུ་ཡར་ལངས་ཏེ་དམ་པའི་ཐུགས་ཉིད་ལ་བརྟེན་ནས་རོ་མཱ་གོང་མའི་རྒྱལ་ཁབ་ཡོངས་སུ་མུ་གེ་ཆེན་པོ་ཞིག་འབྱུང་བར་འགྱུར་ངེས་ཡིན་ཞེས་པའི་ལུང་བསྟན། དེ་ནི་གོང་མའི་རྒྱལ་པོ་ཀ་ལོ་དཱི་ཡིས་རྒྱལ་པོ་བྱེད་པའི་དུས་སུ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ཁོ་ཚོས་སོ་སོའི་ནུས་པ་བཞིན་དུ་ཡ་ཧུ་དཱ་ཡུལ་གྱི་སྤུན་ཟླ་རྣམས་ལ་སྦྱིན་པ་ཕུལ་རྒྱུའི་ཐག་གཅོད་བྱས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","དེ་རྣམས་བསྡུས་ཏེ་པར་ན་པཱ་དང་ཤ་ཨུལ་གཉིས་ཡེ་རུ་ཤ་ལེམ་ཆོས་ཚོགས་ཀྱི་འགན་འཁུར་བ་རྣམས་ལ་སྤྲོད་པར་བཏང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","དེའི་དུས་སུ་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡིས་ཆོས་ཚོགས་ཀྱི་མིའི་ནང་ནས་ཁ་ཤས་ལ་གནོད་སྐྱེལ་བའི་ཕྱིར་ཁོ་རྣམས་འཛིན་བཟུང་བྱེད་དུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ཁོས་ཡོ་ཧ་ནན་གྱི་གཅེན་པོ་སྐུ་ཚབ་ཡ་ཀོབ་རལ་གྲིའི་ཁ་ཡིས་བསད་དུ་བཅུག་པས། ");
INSERT INTO bod_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ཡ་ཧུ་དཱ་པ་རྣམས་དགའ་བར་གྱུར་བ་མཐོང་ནས་ཁོས་པེ་ཏྲོ་ཡང་འཛིན་བཟུང་བྱས། (དེ་ནི་སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་གྱི་དུས་སུ་བྱུང་) ");
INSERT INTO bod_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ཧེ་རོ་དཱེ་ཡིས་པེ་ཏྲོ་བཟུང་ནས་བཙོན་ཁང་དུ་བཅུག་ཅིང༌། ཁོ་སྲུང་བའི་ཕྱིར་དམག་མི་བཞི་རེ་ཅན་གྱི་དམག་ཁག་བཞི་ལ་གཏད། པེ་སག་དུས་ཆེན་དེའི་རྗེས་སུ་ཁོས་པེ་ཏྲོ་ཡུལ་མི་རྣམས་ཀྱི་མདུན་དུ་འཁྲིད་ནས་ཁྲིམས་གཅོད་པར་འདོད། ");
INSERT INTO bod_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","པེ་ཏྲོ་བཙོན་ཁང་ལ་བཅུག་དུས་ཆོས་ཚོགས་ཀྱིས་ཁོང་གི་ཆེད་དུ་དཀོན་མཆོག་ལ་སྙིང་ཐག་པ་ནས་གསོལ་འདེབས་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ཧེ་རོ་དཱེ་ཡིས་པེ་ཏྲོ་ཡུལ་མི་རྣམས་ཀྱི་མདུན་དུ་ཁྲིད་ནས་ཁྲིམས་གཅོད་བྱེད་པའི་སྔོན་གྱི་མཚན་མོར་པེ་ཏྲོ་ལྕགས་ཐག་གཉིས་ཀྱིས་བཅིངས་ཏེ་དམག་མི་གཉིས་ཀྱི་བར་དུ་གཉིད་ཁུག་ནས་བསྡད། སྒོའི་ཕྱི་རོལ་ཏུ་སྲུང་དམག་རྣམས་ཀྱིས་བཙོན་ཁང་བསྲུངས། ");
INSERT INTO bod_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","གློ་བུར་དུ་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་མངོན་སུམ་དུ་བྱུང་ཞིང་ཁང་མིག་ལ་འོད་ཅིག་འཕྲོས། ཕོ་ཉས་གཉིད་གསོད་པའི་ཕྱིར་པེ་ཏྲོའི་གཞོགས་ལ་འཆང་སྟེ་ཁོང་ལ་“མགྱོགས་པོ་ལོངས་ཤིག་”ཅེས་གསུངས་པས་ལྕགས་ཐག་གཉིས་ཁོང་གི་ལག་པ་ནས་སར་ལྷུངས། ");
INSERT INTO bod_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ཡང་ཕོ་ཉས་ཁོང་ལ་“སྐེ་རགས་བཅིངས་ནས་ལྷམ་གྱོན་ཞིག་”ཅེས་གསུངས་པས་པེ་ཏྲོས་དེ་ལྟར་བྱས་པ་དང༌། ཕོ་ཉས་“ཕྱི་གོས་གྱོན་ནས་ངའི་རྗེས་སུ་ཤོག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","པེ་ཏྲོ་ཕྱིར་ཐོན་ནས་ཕོ་ཉའི་རྗེས་སུ་འབྲངས། ཕོ་ཉས་གང་མཛད་པ་དེ་དངོས་གནས་ཡིན་པ་པེ་ཏྲོས་མི་ཤེས་ཏེ། ཞལ་གཟིགས་ཤིག་མཐོང་བར་སྙམ། ");
INSERT INTO bod_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","དེ་རྗེས་སྲུང་དམག་དང་པོ་དང་གཉིས་པ་བརྒལ་ནས་གྲོང་ཁྱེར་ལ་འགྲོ་བའི་ལྕགས་སྒོར་སླེབས་པ་དང༌། དེ་རང་ཤུགས་ཀྱིས་ཕྱེ་ནས་ཁོང་ཚོ་ཕྱིར་ཐོན་ཏེ་སྲང་ལམ་ཞིག་བརྒྱུད་ནས་ཕེབས་དུས་གློ་བུར་དུ་ཕོ་ཉ་ཁོང་དང་ཁ་བྲལ། ");
INSERT INTO bod_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","པེ་ཏྲོས་གང་བྱུང་བ་དེ་དངོས་གནས་ཡིན་པ་ཤེས་ནས་“ད་གཙོ་བོས་རང་གི་ཕོ་ཉ་མངགས་ཏེ་རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡི་དབང་ཤེད་དང༌། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་རེ་སྒུག་བྱེད་པའི་དོན་ཐམས་ཅད་ལས་ང་སྐྱོབ་པར་མཛད་པ་ངས་ཐེ་ཚོམ་མེད་པར་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","དེ་ལྟར་བསམས་མ་ཐག་ཁོང་ཡོ་ཧ་ནན་ཏེ་མར་ཀུ་ཡང་བྱ་བའི་ཨ་མ་མིར་ཡམ་གྱི་ཁང་པར་ཕེབས། དེར་མི་མང་པོ་འཛོམས་ནས་སྨོན་ལམ་འདེབས་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","པེ་ཏྲོས་ཕྱི་སྒོ་བརྡུངས་པས་རོལ་དཱ་ཞེས་ཟེར་བའི་གཡོག་མོ་ཞིག་སྒོ་ཕྱེ་བར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","པེ་ཏྲོའི་སྐད་ཡིན་པར་ཤེས་ཏེ་ཧ་ཅང་དགའ་བའི་ངང་ནས་སྒོ་མ་ཕྱེ་བར་ནང་ལ་བརྒྱུགས་ཤིང་“པེ་ཏྲོ་ལགས་སྒོའི་ཕྱི་ལ་འདུག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ཁོ་ཚོས་ཁོ་མོ་ལ་“ཁྱོད་སྨྱོའོ་”ཞེས་ཟེར་ན་ཡང༌། ཁོ་མོས་བདེན་པ་ཡིན་པར་ཨུ་ཚུགས་བྱས་པས། ཁོ་ཚོས་“ཁོང་གི་ཕོ་ཉ་ཡིན་པར་ངེས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","དེའི་རིང་ལ་པེ་ཏྲོས་མུ་མཐུད་སྒོ་བརྡུངས། སྒོ་ཕྱེ་ནས་ཁོང་མཐོང་བས་ཁོ་རྣམས་ངོ་མཚར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","པེ་ཏྲོས་ཁ་ཁུ་སིམ་པོར་སྡོད་དགོས་པའི་ལག་བརྡ་བྱས་ཏེ། གཙོ་བོས་ཁོང་ཇི་ལྟར་བཙོན་ཁང་ནས་འཁྲིད་པའི་གཏམ་ཁོ་ཚོར་བཤད། ཁོང་གིས་“དོན་དེ་ཡ་ཀོབ་དང་སྤུན་ཟླ་གཞན་རྣམས་ལ་ཤོད་ཅིག་”ཅེས་གསུངས་ནས་ཁོ་ཚོ་དང་ཁ་བྲལ་ཏེ་ས་ཆ་གཞན་ཞིག་ལ་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","དེའི་སང་ཞོགས་པེ་ཏྲོ་གང་དུ་སོང་མིན་མ་ཤེས་པས་དམག་མི་རྣམས་ཤིན་ཏུ་འཁྲུགས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ཧེ་རོ་དཱེ་ཡིས་ཁོང་བཙལ་ནས་མ་རྙེད་པས་ཁོས་སྲུང་དམག་རྣམས་ལ་འདྲི་གཅོད་བྱས་པ་དང༌། ཁོ་ཚོ་ལ་སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་བཀའ་བསྒོས། དེའི་རྗེས་སུ་ཁོ་ཡ་ཧུ་དཱ་ཡུལ་ནས་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་ཕྱིན་ནས་དེར་གནས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ཧེ་རོ་དཱེ་ཐཱ་ཨེར་དང་ཚི་དོན་གྲོང་ཁྱེར་གྱི་འབངས་མི་རྣམས་ལ་ཤིན་ཏུ་ཁྲོས་པར་འགྱུར། ཁོ་ཚོའི་ཡུལ་དེ་ནི་རྒྱལ་པོའི་ཧེ་རོ་དཱེ་ཡི་ཡུལ་ལ་བརྟེན་ནས་འཚོ་ཆས་འཐོབ་པར་བྱེད་དགོས་པས། ཡུལ་མི་རྣམས་ཀྱིས་སྐུ་ཚབ་ཚོགས་པ་ཞིག་བཏང་སྟེ་རྒྱལ་པོའི་གཟིམ་དཔོན་པཱ་ལ་སི་ཐོ་བློ་འགུགས་ནས་བར་འདུམ་གཏོང་བའི་རེ་བ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","གཏན་འཁེལ་བའི་ཉིན་མོ་ཞིག་ལ་ཧེ་རོ་དཱེ་ཡིས་རྒྱལ་པོའི་གོས་གྱོན་ནས་ཁྲིམས་དཔོན་གྱི་ཁྲིར་བསྡད་པ་དང༌། མི་རྣམས་ལ་གཏམ་སྨྲ་བར་བརྩམས། ");
INSERT INTO bod_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","མི་རྣམས་ཀྱིས་“འདི་ནི་མི་ཞིག་གི་སྐད་མ་ཡིན་ཏེ། ལྷ་ཡི་གསུང་སྐད་ཡིན་”ཞེས་སྐད་ཆེན་པོས་ཡང་ཡང་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ཧེ་རོ་དཱེ་ཡིས་བསྟོད་པ་འདི་དཀོན་མཆོག་ལ་མ་ཕུལ་བས། འཕྲལ་དུ་གཙོ་བོའི་ཕོ་ཉ་ཞིག་གིས་ཁོ་ལ་ནད་ཀྱིས་བཏབ་ནས་རྒྱུ་སྲིན་གྱིས་བཟས་ནས་ཤིའོ། ། ");
INSERT INTO bod_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ཡང་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་ཁྱབ་པས། དད་ལྡན་རྣམས་ཀྱི་གྲངས་མང་དུ་འཕེལ། ");
INSERT INTO bod_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","དེ་ནས་པར་ན་པཱ་དང་ཤ་ཨུལ་གཉིས་ཀྱིས་ཡེ་རུ་ཤ་ལེམ་ལ་ལས་ཀ་སྒྲུབས་ཚར་བས། ཡོ་ཧ་ནན་ཏེ་མར་ཀུ་ཡང་བྱ་བ་འཁྲིད་དེ་ཕྱིར་ལོག་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་གྱི་ཆོས་ཚོགས་ལ་པར་ན་པཱ་དང༌། ནེ་གེར་ཞེས་བྱ་བའི་སི་མེ་ཡོན་དང༌། ད་དུང་སེ་རེ་ནཱ་གྲོང་ཁྱེར་ནས་ཡིན་པའི་ལུ་ཀི་ཡཱུ་དང༌། ས་གནས་དཔོན་པོ་ཧེ་རོ་དཱེ་ཡི་ཕོ་བྲང་ལ་འཚར་ལོངས་བྱུང་བའི་མཱ་ནཱ་ཧེན་དང༌། ཤ་ཨུལ་ཞེས་པའི་ལུང་སྟོན་པ་དང་ཆོས་སྟོན་མཁན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ཁོང་ཚོས་གཙོ་བོ་ལ་བསྙེན་བཀུར་བྱེད་ཅིང་སྨྱུང་གནས་སྲུང་བའི་དུས་སུ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོ་ཚོར་“ངའི་ཆེད་དུ་ཁྱོད་རྣམས་ཀྱིས་པར་ན་པཱ་དང་ཤ་ཨུལ་གཉིས་ང་ཡིས་འདེམས་པའི་ལས་སྒྲུབ་པའི་ཕྱིར་སྐོས་ཤིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","དེ་ནས་ཁོ་ཚོས་སྨྱུང་གནས་བསྲུངས་ཏེ་སྨོན་ལམ་བཏབ་པ་དང༌། ཁོང་ཚོ་གཉིས་ཀྱི་ལུས་ལ་ལག་པ་བཞག་ནས་བཏང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ཁོང་གཉིས་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་མངགས་ཏེ་གྲུ་ཁའི་གྲོང་ཁྱེར་སེ་ལུ་ཀི་ཡཱ་ལ་ཕེབས་པ་དང༌། གྲུ་གཟིངས་ལ་བསྡད་ནས་ཀིབ་རུ་གླིང་ཕྲན་དུ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","སཱ་ལ་མཱི་གྲོང་ཁྱེར་ལ་སླེབས་ནས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་རྣམས་ལ་དཀོན་མཆོག་གི་བཀའ་བསྒྲགས། ཡང་ཡོ་ཧ་ནན་གྱིས་ཁོང་ཚོ་ལ་ལས་གྲོགས་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","གླིང་ཕྲན་ཡོངས་སུ་བརྒྱུད་ནས་པཱ་ཕོ་གྲོང་ཁྱེར་ཙམ་ལ་ཕེབས་སྐབས། ཁོང་རྣམས་ལ་པཱར་ཡེ་ཤུ་ཞེས་ཟེར་བའི་སྔགས་པ་སྟེ་ཡ་ཧུ་དཱ་པའི་ལུང་སྟོན་པ་རྫུན་མ་ཞིག་དང་ཕྲད། ");
INSERT INTO bod_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","མི་འདི་ནི་སྤྱི་ཁྱབ་སྟེ་བློ་གྲོས་ཅན་སེར་གིའུ་པའུ་ལུ་དང་མཉམ་དུ་འགྲོགས་པ་ཞིག་ཡིན། དཀོན་མཆོག་གི་བཀའ་ཐོས་པར་སྤྱི་ཁྱབ་དེས་པར་ན་པཱ་དང་ཤ་ཨུལ་གཉིས་བོས་ན་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","སྔགས་པ་དེས་(གྷི་རིག་སྐད་དུ་ཨེ་ལི་མཱ་ཡང་ཟེར་) ཁོང་ཚོར་ངོ་རྒོལ་བྱས་པ་དང༌། སྤྱི་ཁྱབ་དད་པ་ལས་ཟློག་པའི་ཐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","འོན་ཀྱང་ཤ་ཨུལ་(པའུ་ལུ་ཡང་ཟེར་) དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་གྱུར་ཏེ་ཁོ་ལ་ནན་གྱིས་བལྟས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ཁོ་ལ་“ཁྱོད་ནི་བདུད་ཀྱི་བུ་ཡིན་ཏེ་དྲང་བ་ཐམས་ཅད་ཀྱི་དགྲ་བོ་ཡིན། གཡོ་སྒྱུ་དང་ངན་སེམས་ཀུན་གྱིས་གང་སྟེ་ཁྱོད་ཀྱིས་གཙོ་བོ་ཡེ་ཤུའི་ལམ་དྲང་པོ་འཁྱོག་པར་བྱེད་པ་མི་སྤོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ད་ལྟོས་ཤིག དཀོན་མཆོག་གི་ནུས་མཐུ་ཁྱོད་ལ་བཏབ་ནས་ལོང་བར་འགྱུར་བས་རེ་ཞིག་ཁྱོད་ཀྱིས་ཉི་མའི་འོད་མཐོང་མི་ཐུབ་”ཅེས་གསུངས་པ་དང༌། འཕྲལ་དུ་ཁོའི་མིག་ལ་སྨུག་པ་དང་མུན་པ་ཡིས་འཐིབས་པས་ཁོས་ལག་པ་ནས་འཇུས་ཏེ་འཁྲིད་མཁན་བཙལ། ");
INSERT INTO bod_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","སྤྱི་ཁྱབ་ཀྱིས་གང་བྱུང་བ་མཐོང་ནས་དད་པ་སྐྱེས། གཙོ་བོ་ཡེ་ཤུའི་བསྟན་པ་ཐོས་ནས་ངོ་མཚར་བར་གྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","དེ་ནས་པའུ་ལུ་དང་ཁོང་གི་རོགས་པ་རྣམས་གྲུ་གཟིངས་ལ་བསྡད་དེ་པཱ་ཕོ་ནས་ཕམ་ཕིལ་ཡཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་པེར་གཱ་ལ་ཕེབས་པ་དང༌། དེར་སླེབས་ནས་ཡོ་ཧ་ནན་ཁོང་རྣམས་དང་ཁ་བྲལ་ཏེ་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ཁོང་ཚོ་པེར་གཱ་ནས་ཕར་སོང་སྟེ་པི་སི་དི་ཡཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་ཨན་ཏི་ཡོག་ཡཱ་ལ་ཕེབས་པ་དང༌། དེར་ངལ་གསོའི་ཉིན་མོར་ཁོང་རྣམས་འདུ་ཁང་ལ་ཕེབས་ནས་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","བཀའ་ཁྲིམས་དང་ལུང་སྟོན་པའི་མདོ་ལས་བཀླགས་རྗེས་འདུ་ཁང་གི་དཔོན་པོས་“སྤུན་ཟླ་རྣམས། གལ་ཏེ་མི་རྣམས་ཀྱི་ཆེད་དུ་ཁྱེད་ལ་སྐུལ་བའི་གཏམ་ཞིག་ཡོད་ན་གསུངས་ཤིག་”ཅེས་པའི་ལན་ཁོང་རྣམས་ལ་བསྐུར། ");
INSERT INTO bod_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","པའུ་ལུ་ཡར་ལངས་ཏེ་ལག་བརྡ་བྱས་ནས་འདི་ལྟར་གསུངས་“ཡི་སི་ར་ཨེལ་པ་དང་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་རྣམས། ང་ལ་ཉོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ཡི་སི་ར་ཨེལ་མི་རིགས་འདིའི་དཀོན་མཆོག་གིས་ང་ཚོའི་མེས་པོ་བདམས་ཤིང༌། ཨེ་ཇེབ་ཡུལ་ལ་སྡོད་པའི་དུས་སུ་ཁོ་རྣམས་ཤིན་ཏུ་མང་པོར་འཕེལ་བར་མཛད། ནུས་མཐུ་དང་ལྡན་པའི་ཕྱག་གིས་ཁོ་ཚོ་ཡུལ་དེ་ནས་ཕྱི་རོལ་ཏུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ལོ་བཞི་བཅུ་ཙམ་གྱི་བར་དུ་འབྲོག་སྟོང་ལ་ཁོང་གིས་ཁོ་ཚོའི་སྤྱོད་པ་བཟོད་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ཀ་ནཱན་ཡུལ་གྱི་མི་རིགས་བདུན་མེད་པར་མཛད་ནས་དཀོན་མཆོག་གིས་མེས་པོ་རྣམས་ལ་ཁོ་ཚོའི་ཡུལ་བགོས་སྐལ་དུ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","དོན་དེ་རྣམས་ལོ་བཞི་བརྒྱ་ལྔ་བཅུ་ཙམ་འགོར་བ་ཡིན། དེའི་རྗེས་སུ་ལུང་སྟོན་པ་ཤ་མུ་ཨེལ་གྱི་བར་དུ་ཁོང་གིས་ཁོ་ཚོར་ཁྲིམས་དཔོན་གྱི་ལམ་ལུགས་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","དེ་ནས་ཁོ་ཚོས་རྒྱལ་པོ་སྐོ་བའི་ཞུ་བ་ཞུས་པས་དཀོན་མཆོག་གིས་ཡི་སི་ར་ཨེལ་གྱི་ཚོ་ཁག་པེན་ཡ་མཱིན་གྱི་ཚོ་ཁག་ནས་ཀི་སི་ཡི་བུ་ཤ་ཨུལ་རྒྱལ་པོར་བསྐོས་པར་མཛད། ཁོས་ལོ་བཞི་བཅུའི་རིང་རྒྱལ་པོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","དེ་ནས་དཀོན་མཆོག་གིས་ཁོ་གོ་གནས་ལས་འབེབས་པར་མཛད་པ་དང༌། དཱ་བིད་ཁོ་ཚོའི་རྒྱལ་པོར་བསྐོས། དཀོན་མཆོག་གིས་དཱ་བིད་ཀྱི་སྐོར་དཔང་པོ་མཛད་དེ་ཡེ་སེ་ཞེས་བྱ་བའི་བུ་དཱ་བིད་ནི་ངའི་སེམས་དང་མཐུན་པ་ཞིག་ཡིན་ཞིང༌། ཁོས་ངའི་བསམ་པ་ཐམས་ཅད་སྒྲུབ་པར་འགྱུར་རོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","དཀོན་མཆོག་གིས་ཞལ་ཆད་གནང་བ་ལྟར། དཱ་བིད་ཀྱི་རྒྱུད་པ་རྣམས་ལས་ཁོང་གིས་ཡི་སི་ར་ཨེལ་ལ་སྐྱབས་མགོན་ཡེ་ཤུ་གནང་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ཁོང་མ་འབྱོན་པའི་སྔོན་ལ་ཁྲུས་གསོལ་མཁན་ཡོ་ཧ་ནན་གྱིས་ཡི་སི་ར་ཨེལ་གྱི་མི་ཐམས་ཅད་ལ་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བའི་རྟགས་སུ་ཁྲུས་གསོལ་ལེན་དགོས་པའི་འཕྲིན་བསྒྲགས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ཡོ་ཧ་ནན་གྱིས་ལས་ཚར་བའི་སྐབས་ལ་ཁོང་གིས་ཁྱེད་ཀྱིས་ང་རང་སུ་རེད་སྙམ། ང་ཁོང་མ་ཡིན། ལྟོས་ཤིག ངའི་རྗེས་ལ་ཕེབས་མཁན་ནི་ཁོང་གི་ལྷམ་སྒྲོག་ཀྱང་འགྲོལ་བར་མི་འོས་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ཨབ་ར་ཧམ་གྱི་རྒྱུད་པ་སྟེ་ངའི་སྤུན་ཡིན་ཞིང༌། ཁྱེད་ཚོའི་ནང་ནས་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་རྣམས། ཐར་པ་འདིའི་འཕྲིན་ངེད་རྣམས་ལ་མངགས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ཡེ་རུ་ཤ་ལེམ་པ་དང་ཁོ་ཚོའི་དཔོན་པོ་རྣམས་ཀྱིས་གཙོ་བོ་ཡེ་ཤུ་སྐྱབས་མགོན་ཡིན་པ་ངོ་མི་ཤེས་པ་དང༌། ངལ་གསོ་བའི་ཉིན་རེ་རེར་ལུང་སྟོན་པའི་བཀའ་གང་ཀློག་པའང་མི་ཤེས་པས། ཁོང་ལ་ཁྲིམས་གཅོད་གཏོང་བའི་སྒོ་ནས་བཀའ་དེ་རྣམས་བསྒྲུབས། ");
INSERT INTO bod_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་རྒྱུ་རྐྱེན་ཅི་ཡང་མ་རྙེད་ཀྱང༌། ཁོ་ཚོས་པི་ལ་ཏུ་ལ་ཁོང་སྲོག་གཅོད་གཏོང་བའི་ཞུ་བ་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ཁོ་ཚོས་ཁོང་གི་སྐོར་གང་བྲིས་ཡོད་པ་ཐམས་ཅད་བསྒྲུབས་ནས། མི་རྣམས་ཀྱིས་ཁོང་གི་སྐུ་ཕུང་རྒྱང་ཤིང་སྟེང་ནས་མར་ཕབ་སྟེ་དུར་ཁང་ལ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","འོན་ཀྱང་དཀོན་མཆོག་གིས་ཁོང་འཆི་བ་ནས་སླར་གསོན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","སྔར་ཁོང་དང་མཉམ་དུ་ག་ལིལ་ཡུལ་ནས་ཡེ་རུ་ཤ་ལེམ་ལ་ཡོང་བ་རྣམས་ཀྱིས་ཉིན་མང་པོའི་རིང་ཁོང་མཐོང་ཞིང༌། ད་ལྟ་ཁོ་རྣམས་ནི་མི་རྣམས་ལ་ཁོང་གི་དཔང་པོ་བྱེད་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ང་ཚོས་ཁྱེད་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་སྟེ། དཀོན་མཆོག་གིས་ང་ཚོའི་མེས་པོ་རྣམས་ལ་གང་ཞལ་གྱིས་བཞེས་པ་དེ། ");
INSERT INTO bod_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","གཙོ་བོ་ཡེ་ཤུ་ཡར་སློང་བར་མཛད་པའི་སྒོ་ནས་ཁོ་ཚོའི་རྒྱུད་པ་སྟེ་ངེད་རྣམས་ཀྱི་ཕྱིར་སྒྲུབ་པར་མཛད། གསུང་མགུར་གཉིས་པ་ལ་འཁོད་པ་བཞིན། ཁྱེད་ནི་ང་ཡི་བུ་ཉིད་ཡིན་པས་ན། ། དེ་རིང་ང་ནི་ཁྱེད་ཀྱི་ཕ་རུ་གྱུར། ། ");
INSERT INTO bod_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ཡང་དཀོན་མཆོག་གིས་ཁོང་འཆི་བ་ནས་སླར་གསོན་པར་མཛད་དེ་ཡང་བསྐྱར་འགྲོངས་མི་སྲིད་པའི་སྐོར་འདི་ལྟར་གསུངས། ང་ཡིས་དཱ་བིད་ཉིད་ལ་སྤྲད་པ་བཞིན། ། ཡང་དག་བདེན་པའི་བྱིན་རླབས་ཁྱེད་ལ་སྦྱིན། ། ");
INSERT INTO bod_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","དེའི་ཕྱིར་ཁོང་གིས་གསུང་མགུར་གྱི་མདོ་གཞན་པ་ལས། ཁྱེད་ཀྱིས་རང་གི་སྐྱེས་བུ་དམ་པ་ཉིད། ། དུར་དུ་རུལ་བར་འཇུག་པ་ག་ལ་སྲིད། ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","རྒྱལ་པོ་དཱ་བིད་ནི་རང་གི་མི་རབས་ཀྱི་དུས་སུ་དཀོན་མཆོག་གི་དགོངས་པ་བསྒྲུབས་པའི་རྗེས་སུ་སྐུ་ཚེ་ལས་འདས་ཤིང༌། ཁོའི་མེས་པོའི་དུར་ཁང་གི་ཁྲོད་དུ་བཞག་ནས་སྐུ་སྤུར་རུལ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","འོན་ཀྱང་དཀོན་མཆོག་གིས་བསླངས་པ་ནི་རུལ་བར་མ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ངའི་སྤུན་ཟླ་རྣམས། དེའི་ཕྱིར་ཁོང་གི་ཐོག་ནས་སྡིག་ཉེས་སེལ་བ་ཁྱེད་རྣམས་ལ་སྒྲོག་པ་དེ་ཤེས་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ཁོང་ལ་དད་པ་བྱེད་མཁན་ཐམས་ཅད་ནི་མོ་ཤེའི་བཀའ་ཁྲིམས་ཀྱི་སྒོ་ནས་སེལ་མི་སྲིད་པའི་སྡིག་ཉེས་ཐམས་ཅད་ལས་ཐར་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ལུང་སྟོན་པས་གང་གསུངས་པ་ཁྱེད་རྣམས་ལ་མི་ཕོག་པའི་ཕྱིར་དོགས་ཟོན་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ང་ཡིས་ཁྱོད་ཀྱི་དུས་སུ་ལས་ཤིག་བྱེད། ། གཞན་གྱིས་དེ་དག་ཁྱོད་ལ་འཆད་གྱུར་ཀྱང༌། ། ཁྱོད་ཀྱིས་དེ་ལ་ནམ་ཡང་ཡིད་མི་ཆེས། ། ཁྱོད་ཚོ་འཕྱ་བར་བྱེད་མཁན་ལྟོས་ཤིག་ཨང༌། ། ངོ་མཚར་འགྱུར་ཞིང་འཇིག་པར་ཡང་འགྱུར་འོང༌། །” ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","པའུ་ལུ་དང་པར་ན་པཱ་འདུ་ཁང་ནས་ཕྱིར་ཐོན་སྐབས། མི་རྣམས་ཀྱིས་ཁོང་གཉིས་ལ་ངལ་གསོ་བའི་ཉིན་རྗེས་མར་དོན་དེའི་སྐོར་ཡང་བསྐྱར་གསུང་དགོས་པར་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","འདུ་ཁང་གི་ཚོགས་འདུ་གྲོལ་བའི་རྗེས་སུ་ཡ་ཧུ་དཱ་པ་དང༌། ཡ་ཧུ་དཱ་པའི་ཆོས་ལུགས་ལ་ཞུགས་པའི་ཡ་ཧུ་དཱ་པ་མིན་པ་སྟེ་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་རྣམས་ལས་མང་པོ་ཞིག་གིས་པའུ་ལུ་དང་པར་ན་པཱ་ཡི་རྗེས་སུ་འབྲངས། ཁོང་གཉིས་ཀྱིས་ཁོ་ཚོར་དཀོན་མཆོག་གི་ཐུགས་རྗེ་ལ་གནས་པར་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ངལ་གསོ་བའི་ཉིན་རྗེས་མར་གྲོང་ཁྱེར་གྱི་མི་མང་ཆེ་བ་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་ཉན་པར་འདུས། ");
INSERT INTO bod_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","འོན་ཀྱང་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་མི་ཚོགས་མཐོང་བས་ཕྲག་དོག་སྐྱེས་ཤིང༌། འཕྱ་དམོད་བྱས་ཏེ་པའུ་ལུས་གསུངས་པ་ལ་རྒོལ་བར་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","པའུ་ལུ་དང་པར་ན་པཱ་གཉིས་ཀྱིས་བློ་སྟོབས་ཆེན་པོས་“ང་ཚོས་དཀོན་མཆོག་གི་བཀའ་ཁྱེད་རྣམས་ལ་དང་པོར་བཤད་འོས་པ་ཡིན། འོན་ཀྱང་ཁྱེད་ཀྱིས་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པ་མི་འོས་པ་ཡིན་པར་བསམས་ཏེ་དང་ལེན་མི་བྱེད་པས། ལྟོས་ཤིག ང་ཚོས་ད་ལྟ་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་ཆོས་བཤད་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","གང་ཡིན་ཞེ་ན། གཙོ་བོས་ང་ཚོར་འདི་ལྟར་བཀའ་གནང་སྟེ། ང་ཡིས་ཁྱོད་ཉིད་ཕྱི་པ་རྣམས་ཀྱི་ཆེད། ། འཕྲོ་བར་བྱེད་པའི་འོད་དུ་བསྐོས་པ་ཡིན། ། དེ་ནི་ཁྱོད་ཀྱིས་ས་མཐའི་བར་དུ་ནི། ། ཆོས་དག་བསྒྲགས་ཅིང་ཐར་པ་འཐོབ་པའི་ཕྱིར། །” ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","དེ་ཐོས་ནས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་དགའ་བར་གྱུར་ཞིང་དཀོན་མཆོག་གི་བཀའ་ལ་བསྟོད་པ་ཕུལ། དཀོན་མཆོག་གིས་སྔར་ནས་དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ་པར་བསྐོས་པའི་མི་ཐམས་ཅད་དད་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","དེ་ལྟར་དཀོན་མཆོག་གི་བཀའ་ཡུལ་དེའི་ས་ཕྱོགས་གང་སར་ཁྱབ། ");
INSERT INTO bod_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","འོན་ཀྱང་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཆོས་ལ་དགའ་བའི་རིགས་མཐོ་བའི་བུད་མེད་དང་གྲོང་ཁྱེར་གྱི་འགོ་ཁྲིད་བྱེད་པའི་སྐྱེས་པ་རྣམས་ལ་ངན་བསྐུལ་བྱས་ནས། པའུ་ལུ་དང་པར་ན་པཱ་གཉིས་ལ་གནོད་བསྐྱལ་ཏེ་ཁོ་ཚོའི་ཡུལ་ནས་ཕར་བསྐྲད། ");
INSERT INTO bod_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ཁོ་རྣམས་ལ་དོན་དེར་འགན་ཁུར་དགོས་པར་སྟོན་པའི་ཕྱིར་ཁོང་རྣམས་ཀྱིས་རྐང་པའི་སྟེང་གི་ས་རྡུལ་ཁོ་ཚོའི་ཕྱོགས་སུ་སྤྲུགས་ནས་ཨི་ཀོན་ཡཱུ་ཞེས་པའི་གྲོང་ཁྱེར་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ཡང་ཉེ་གནས་རྣམས་ནི་དགའ་སྤྲོ་དང༌། དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་གང་བར་འགྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ཨི་ཀོན་ཡཱུ་གྲོང་ཁྱེར་ལ་པའུ་ལུ་དང་པར་ན་པཱ་གཉིས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ལ་ཕེབས་པ་དང༌། ཁོང་ཚོའི་ཆོས་སྟོན་སྟངས་ཀྱི་རྐྱེན་གྱིས་ཡ་ཧུ་དཱ་དང་གྷི་རིག་མི་མང་པོ་དད་ལྡན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","འོན་ཀྱང་དད་པ་མི་བྱེད་པའི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་སེམས་དཀྲུགས་པས་ཁོ་རྣམས་ནི་སྤུན་ཟླ་རྣམས་ལ་ཁོང་ཁྲོ་སྐྱེས། ");
INSERT INTO bod_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","དེའི་ཕྱིར་པའུ་ལུ་དང་པར་ན་པཱ་གྲོང་ཁྱེར་དེ་ལ་ཡུན་རིང་པོར་བཞུགས་ཏེ་གཙོ་བོ་ལ་བརྟེན་ནས་བློ་སྟོབས་ཆེན་པོས་ཆོས་བསྟན། ཁོང་ཚོའི་ཕྱག་གིས་རྟགས་དང་ངོ་མཚར་བའི་དོན་སྒྲུབ་པར་གནང་བའི་སྒོ་ནས་གཙོ་བོས་ཁོང་གི་ཐུགས་རྗེ་དང་ལྡན་པའི་བཀའ་ལ་བདེན་དཔང་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","གྲོང་ཁྱེར་གྱི་འབངས་མིའི་ནང་ལྟ་བ་མི་མཐུན་པ་བྱུང༌། ལ་ལས་ཡ་ཧུ་དཱ་པའི་ཕྱོགས་བྱས་ཤིང༌། ལ་ལས་སྐུ་ཚབ་རྣམས་ཀྱི་ཕྱོགས་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ཡ་ཧུ་དཱ་པ་དང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་དཔོན་རིགས་དང་མཉམ་དུ་ཁོང་ཚོར་དམའ་འབེབས་བྱེད་ཅིང་རྡོ་རུབ་གཏོང་བའི་གོ་སྐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","སྐུ་ཚབ་རྣམས་ཀྱིས་དེའི་སྐོར་ཤེས་ཏེ་ལི་ཀ་ཨོན་ཡཱ་ཡུལ་གྱི་ལིས་ཏྲཱ་དང་ཌེར་པེ་གྲོང་ཁྱེར་དེ་བཞིན་དེའི་ཉེ་འཁོར་གྱི་ཡུལ་ལ་བྲོས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","དེར་ཁོང་ཚོས་མུ་མཐུད་འཕྲིན་བཟང་བསྒྲགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ལིས་ཏྲཱ་གྲོང་ཁྱེར་ལ་སྐྱེས་དུས་ནས་ཞ་བོ་ཡིན་ཞིང་རྐང་པ་འཁུམས་པའི་མི་གོམ་པ་སྤོ་མ་མྱོང་བ་ཞིག་བསྡད་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","མི་དེས་པའུ་ལུའི་གསུང་ལ་ཉན། པའུ་ལུ་ཡིས་ཁོ་ལ་ནན་གྱིས་བལྟས་ཏེ་ནད་ལས་ཐར་བའི་ཆེད་དུ་དད་པ་ཡོད་པར་མཐོང་བས། ");
INSERT INTO bod_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","སྐད་ཆེན་པོས་ཁོ་ལ་“རྐང་པ་སར་བཙུགས་ཏེ་ཡར་ལོངས་”ཞེས་གསུངས་པས་མི་དེ་ཡར་མཆོངས་ཏེ་འགྲོ་ཐུབ་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","པའུ་ལུས་གང་བྱས་པ་མཐོང་ནས་མི་ཚོགས་ཀྱིས་ལི་ཀ་ཨོན་ཡཱ་སྐད་སྤྱད་ནས་སྐད་ཆེན་པོས་“ལྷ་རྣམས་མི་རུ་སྤྲུལ་ནས་ང་ཚོའི་ཁྲོད་དུ་བབས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","མི་དེ་ཚོས་པར་ན་པཱ་ཡི་མིང་ལ་ཟུ་སཱི་དང༌། པའུ་ལུ་གསུང་མཁན་གཙོ་བོ་ཡིན་པས་ཁོང་གི་མིང་ལ་ཧེར་མཱེ་ཞེས་བཏགས། ");
INSERT INTO bod_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ཟུ་སཱི་ཡི་ལྷ་ཁང་གྲོང་ཁྱེར་གྱི་ཕྱི་རོལ་ཏུ་ཡོད་ཅིང༌། དེའི་མཆོད་དཔོན་གྱིས་གླང་འཁྲིད་དེ་མེ་ཏོག་གི་ཕྲེང་བ་ཁྱེར་ནས་སྒོ་ཁར་སླེབས་པ་དང༌། མི་ཚོགས་དང་བཅས་ཀྱིས་དམར་མཆོད་བྱེད་པར་འདོད། ");
INSERT INTO bod_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","སྐུ་ཚབ་པར་ན་པཱ་དང་པའུ་ལུས་དེའི་སྐོར་ཤེས་ནས་ཕྱི་གོས་དབྲལ་བ་དང༌། མི་ཚོགས་ཀྱི་ནང་དུ་བརྒྱུགས་ཏེ་སྐད་ཆེན་པོས་ ");
INSERT INTO bod_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“མི་རྣམས། ཁྱེད་ཚོས་ཅིའི་ཕྱིར་འདི་ལྟར་བྱེད། ང་ཚོ་གཉིས་ལ་ཁྱེད་ཚོ་དང་འདྲ་བར་མིའི་རང་བཞིན་ཡོད། ཁྱེད་ཚོས་དོན་མེད་པའི་བྱ་བ་འདི་རྣམས་སྤངས་ནས། ནམ་མཁའ་དང༌། ས་གཞི། རྒྱ་མཚོ། དེར་ཡོད་པ་ཐམས་ཅད་བཀོད་པ་དང་གཏན་དུ་གནས་པའི་དཀོན་མཆོག་ལ་དད་པ་བྱེད་པའི་ཆེད་དུ་ང་ཚོས་ཁྱེད་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག ");
INSERT INTO bod_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","འདས་པའི་དུས་སུ་ཁོང་གིས་མི་རིགས་ཐམས་ཅད་རང་གི་འདོད་པ་ལྟར་བྱེད་དུ་བཅུག་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ཁྱེད་རྣམས་ལ་ཕྱག་ལས་བཟང་པོ་མཛད་པའི་སྒོ་ནས་ཁོང་ནི་བཟང་པོ་ཡིན་པར་བདེན་དཔང་མཛད། དཔེར་ན་རྒྱུན་དུ་སྦྱིན་པ་གནང་སྟེ་ཁོང་གིས་ནམ་མཁའ་ལས་ཆར་པ་དང༌། ས་ལས་ལོ་ཏོག་དེ་བཞིན་ཁྱེད་རྣམས་ལ་ཟས་དང་སེམས་སུ་དགའ་སྤྲོ་ཁེངས་པར་གནང་ངོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","དེ་ལྟར་གསུངས་ཀྱང༌། མི་ཚོགས་ཀྱིས་ཁོང་ཚོར་དམར་མཆོད་བྱེད་པ་འགོག་རྒྱུར་དཀའ་ལས་ཁག་པོ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ཨན་ཏི་ཡོག་ཡཱ་དང་ཨི་ཀོན་ཡཱུ་གྲོང་ཁྱེར་ནས་ཡོང་བའི་ཡ་ཧུ་དཱ་པ་ཁ་ཅིག་གིས་མི་ཚོགས་ཁོ་ཚོའི་ཕྱོགས་ལ་བློ་འགུགས་བྱས་པས། ཁོ་ཚོས་པའུ་ལུ་ལ་རྡོ་རུབ་བཏང་ནས་ཁོང་ཤི་ཟིན་པར་བསམས་ཏེ་གྲོང་ཁྱེར་ནས་ཕྱི་རོལ་ཏུ་དྲུད། ");
INSERT INTO bod_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ཉེ་གནས་རྣམས་ཁོང་གི་མཐའ་བསྐོར་དུ་འཛོམས་དུས་ཁོང་ཡར་ལངས་ནས་གྲོང་ཁྱེར་ལ་ཕྱིར་ལོག དེའི་སང་ཉིན་པར་ན་པཱ་དང་མཉམ་དུ་ཌེར་པེ་ལ་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","དེར་ཁོང་རྣམས་ཀྱིས་འཕྲིན་བཟང་བསྒྲགས་པས་མི་མང་པོ་ཞིག་གཙོ་བོ་ཡེ་ཤུའི་ཉེ་གནས་སུ་གྱུར། དེ་ནས་ཁོང་གཉིས་ལིས་ཏྲཱ་དང༌། ཨི་ཀོན་ཡཱུ། ཨན་ཏི་ཡོག་ཡཱ་བཅས་སུ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","དེར་ཁོང་གཉིས་ཀྱིས་ཉེ་གནས་ཀྱི་སེམས་བརྟན་པོ་བྱས་ཏེ་དད་པ་མུ་མཐུད་ནས་བྱེད་པར་བསྐུལ་ནས་“ངེད་རྣམས་སྡུག་བསྔལ་མང་པོ་མྱོང་བའི་སྒོ་ནས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་དུ་འཇུག་པར་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ཁོང་གཉིས་ཀྱིས་ཆོས་ཚོགས་རེ་རེར་འགན་འཁུར་བ་རེ་རེ་བསྐོས་ཤིང༌། སྨྱུང་གནས་བསྲུངས་པ་དང་སྨོན་ལམ་བཏབ་ནས་ཁོ་ཚོས་དད་པ་བྱས་པའི་གཙོ་བོར་བཅོལ། ");
INSERT INTO bod_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ཁོང་གཉིས་པི་སི་དི་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཕམ་ཕིལ་ཡཱ་ཡུལ་ལ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","དཀོན་མཆོག་གི་བཀའ་པེར་གཱ་གྲོང་ཁྱེར་དུ་བསྒྲགས་ནས་ཨ་ཐལ་ཡཱ་ཞེས་པའི་གྲུ་ཁར་ཕེབས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","གྲུ་གཟིངས་ལ་བསྡད་ནས་སི་རི་ཡཱ་ཡུལ་གྱི་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་ལ་ཕྱིར་ལོག་ཕེབས། ས་ཆ་འདི་ནི་སྔར་ཆོས་ཚོགས་ཀྱིས་ཁོང་གཉིས་དཀོན་མཆོག་གི་ཐུགས་རྗེ་ལ་བཅོལ་བའི་གནས་དེ་ཡིན་ཞིང༌། དེ་ནི་ད་ལྟ་བསྒྲུབས་ཟིན་པའི་ལས་འདིའི་ཆེད་དུའོ། ");
INSERT INTO bod_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","དེར་སླེབས་ནས་ཁོང་ཚོས་ཆོས་ཚོགས་བསྡུས་ཤིང༌། དཀོན་མཆོག་གིས་ཁོང་ཚོ་བརྒྱུད་ནས་གང་མཛད་པ་དང༌། ཡ་ཧུ་དཱ་པ་མིན་པའི་དོན་ལ་དད་པའི་སྒོ་ཇི་ལྟར་ཕྱེ་བར་མཛད་པའི་ཚུལ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ཡང་ཁོང་གཉིས་ཉེ་གནས་རྣམས་དང་མཉམ་དུ་ཡུན་རིང་པོ་ཞིག་དེར་གནས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ཡ་ཧུ་དཱ་ཡུལ་ནས་ཡོང་བའི་མི་ཁ་ཅིག་གིས་སྤུན་ཟླ་རྣམས་ལ་“གལ་ཏེ་ལུང་སྟོན་པ་མོ་ཤེ་ཡི་ཆོས་ཁྲིམས་ལྟར་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མ་ལེན་ན། ཐར་བར་འགྱུར་མི་སྲིད་”ཅེས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","པའུ་ལུ་དང་པར་ན་པཱ་ཁོ་ཚོ་དང་མི་མཐུན་ཏེ་རྩོད་གླེང་དྲག་པོ་བྱུང་བས། སྤུན་ཟླ་རྣམས་ཀྱིས་ཁོང་གཉིས་དང་དད་ལྡན་པ་ལས་གཞན་ཁ་ཅིག་དོན་དེའི་སྐོར་ལ་སྐུ་ཚབ་དང་འགན་འཁུར་བ་རྣམས་མཇལ་བར་ཡེ་རུ་ཤ་ལེམ་ལ་འགྲོ་དགོས་པའི་ཐག་གཅོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","དེའི་ཕྱིར་ཆོས་ཚོགས་ཀྱིས་ཁོང་ཚོ་མངགས་ཏེ་ཕེ་ནི་ཀེ་དང་ས་མར་ཡཱ་ཡུལ་གཉིས་བརྒྱུད་ནས་ཕེབས་པ་དང༌། ཁོང་ཚོས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཇི་ལྟར་དད་ལྡན་པར་གྱུར་བར་གསུངས་པས་སྤུན་ཟླ་ཐམས་ཅད་ཧ་ཅང་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","པའུ་ལུ་དང་པར་ན་པཱ་ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ནས་ཆོས་ཚོགས་དང༌། སྐུ་ཚབ། འགན་འཁུར་བ་བཅས་ཀྱིས་ཁོང་ཚོ་བསུས། དཀོན་མཆོག་གིས་ཁོང་གཉིས་བརྒྱུད་ནས་ཇི་མཛད་པ་ཐམས་ཅད་ཁོང་ཚོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","དེ་ནས་ཕཱ་རུ་ཤི་ཟེར་བའི་ཕྱོགས་ཁག་ལས་དད་ལྡན་དུ་གྱུར་བའི་མི་ཁ་ཅིག་ཡར་ལངས་ནས་“ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་ལེན་དགོས་པ་དང་མོ་ཤེ་ཡི་ཆོས་ཁྲིམས་སྲུང་དགོས་པ་དེ་ངེས་པར་དུ་སྐུལ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","དོན་དེ་ཞིབ་དཔྱད་བྱེད་པའི་ཕྱིར་སྐུ་ཚབ་དང་འགན་འཁུར་བ་རྣམས་འཛོམས། ");
INSERT INTO bod_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","གཏམ་གླེང་མང་པོ་བྱས་ནས་སྐུ་ཚབ་པེ་ཏྲོ་ལངས་ཏེ་ཁོ་ཚོར་“སྤུན་ཟླ་རྣམས། སྔོན་དཀོན་མཆོག་གིས་ཁྱེད་ཚོའི་ཁྲོད་ནས་འདམ་ཀ་མཛད་དེ། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་ངའི་ཁ་ནས་འཕྲིན་བཟང་ཐོས་ཤིང་དད་པ་དང་ལྡན་པར་འགྱུར་བ་ཁྱེད་རྣམས་ཀྱིས་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","མི་རྣམས་ཀྱི་སེམས་མཁྱེན་པའི་དཀོན་མཆོག་གིས་ང་ཚོ་ལ་དམ་པའི་ཐུགས་ཉིད་གནང་བ་ལྟར། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལའང་དམ་པའི་ཐུགས་ཉིད་གནང་སྟེ་ཁོ་ཚོར་དཔང་པོ་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ཡང་ང་ཚོ་དང་ཁོ་ཚོའི་བར་དུ་ཁྱད་པར་མི་མཛད་དེ་ཁོང་གིས་དད་པའི་སྒོ་ནས་ཁོ་ཚོའི་སེམས་དག་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ད་ལྟ་ཁྱེད་ཚོས་ཅིའི་ཕྱིར་ང་ཚོའམ་མེས་པོས་ཀྱང་འཁུར་མ་ཐུབ་པའི་གཉའ་ཤིང་དེ་ཉེ་གནས་རྣམས་ཀྱི་གཉའ་ལ་འགེལ་བའི་སྒོ་ནས་དཀོན་མཆོག་ལ་ཉམས་ཚོད་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","དེ་ལས་ལྡོག་སྟེ་ཁོ་ཚོ་དང་འདྲ་བར་ང་ཚོའང་གཙོ་བོ་ཡེ་ཤུའི་ཐུགས་རྗེའི་སྒོ་ནས་ཐར་བར་འགྱུར་བར་ཡིད་ཆེས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","དེ་ནས་དེར་ཚོགས་པའི་མི་ཀུན་ཁ་ཁུ་སིམ་པོར་བསྡད་དེ་པར་ན་པཱ་དང་པའུ་ལུའི་གཏམ་ལ་ཉན། དཀོན་མཆོག་གིས་ཁོང་གཉིས་བརྒྱུད་ནས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་ཁྲོད་དུ་རྟགས་དང་ངོ་མཚར་བའི་དོན་ཅི་ལྟར་མཛད་པའི་སྐོར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ཁོང་ཚོས་གསུངས་པའི་རྗེས་སུ་ཡ་ཀོབ་ཀྱིས་ལན་དུ་“སྤུན་ཟླ་རྣམས། ང་ལ་ཉོན་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ད་ལྟ་སི་མེ་ཡོན་གྱིས་གསུངས་པ་ལྟར་ཐོག་མར་དཀོན་མཆོག་གིས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་ཐུགས་རྗེས་གཟིགས་ཏེ་ཁོ་རྣམས་ལས་རང་གི་དོན་དུ་འབངས་མི་བཞེས། ");
INSERT INTO bod_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","དེ་ནི་ལུང་སྟོན་པས་གང་གསུངས་པའི་བཀའ་དང་མཐུན་ཏེ་ཁོང་ཚོས་བྲིས་པའི་མདོ་ལ་བཀོད་པ་ལྟར། ");
INSERT INTO bod_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","དེ་ཡི་རྗེས་སུ་ང་ནི་ཕྱིར་ལོག་ནས། ། དཱ་བིད་གནས་ས་བཞིག་རལ་སོང་བ་དག ། གཞི་གསོ་བྱེད་ཅིང་གནས་ས་རྡིབས་པ་དག ། ང་ཡིས་སླར་ཡང་འཛུགས་ཤིང་བསྐྲུན་པར་བྱ། ། ");
INSERT INTO bod_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","དེ་ནི་མི་རིགས་གཞན་གང་ཐམས་ཅད་དང༌། ། ང་ཡི་མིང་ཐོགས་ཕྱི་པ་རྣམས་ཀྱིས་ནི། ། ཡང་དག་གཙོ་བོ་དཀོན་མཆོག་འཚོལ་ཕྱིར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","གདོད་ནས་མངོན་པར་མཛད་དེ་གཙོ་བོས་གསུངས། ། ");
INSERT INTO bod_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","དེའི་ཕྱིར་ངའི་བསམ་ཚུལ་ལ་དཀོན་མཆོག་གི་ཕྱོགས་སུ་སེམས་བསྒྱུར་བའི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་དཀའ་ངལ་མི་བཟོ་བར། ");
INSERT INTO bod_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ལྷ་སྐུ་དང་འབྲེལ་བའི་མི་གཙང་བ་དང༌། ལོག་གཡེམ། སྐེ་བཙིར་ནས་གསོད་པའི་དུད་འགྲོའི་ཤ ཁྲག་བཅས་ལ་འཛེམ་དགོས་ཞེས་པའི་ཡི་གེ་ཞིག་བྲིས་ན་ལེགས། ");
INSERT INTO bod_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","གང་ལགས་ཤེ་ན། གནའ་བོ་ནས་བཟུང་ངལ་གསོ་བའི་ཉིན་རེར་ལུང་སྟོན་པ་མོ་ཤེའི་ཆོས་ཁྲིམས་ནི་གྲོང་ཁྱེར་རེའི་འདུ་ཁང་ལ་བཀླགས་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","དེ་ནས་སྐུ་ཚབ་དང་འགན་འཁུར་བ་རྣམས་དང༌། ཆོས་ཚོགས་ཡོངས་ཀྱིས་རང་གི་མི་རྣམས་ལས་ཁ་ཤས་བདམས་ནས་པའུ་ལུ་དང་པར་ན་པཱ་གཉིས་དང་མཉམ་དུ་སི་རི་ཡཱ་ཡུལ་གྱི་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་ལ་མངག་པར་ཐག་གཅོད་བྱས་པས། སྤུན་ཟླ་རྣམས་ཀྱི་ནང་ནས་འགོ་ཁྲིད་ཡིན་པའི་ཡུ་དཱའམ་པར་ས་པཱ་ཡང་ཟེར་བ་ཞིག་དང༌། སི་ལཱ་བདམས། ");
INSERT INTO bod_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","དེ་རྗེས་ཁོང་གཉིས་བརྒྱུད་ཁོ་ཚོ་ལ་གཤམ་གྱི་ཡི་གེ་དེ་བསྐུར། ཁྱེད་རྣམས་ཀྱི་སྤུན་ཟླ་ཡིན་པའི་སྐུ་ཚབ་དང་འགན་འཁུར་བ་རྣམས་ཀྱིས། ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་དང༌། སི་རི་ཡཱ་ཡུལ། ཀི་ལིག་ཡཱ་ཡུལ་བཅས་སུ་གནས་པའི་ཡ་ཧུ་དཱ་པ་མིན་པའི་མི་རིགས་ལས་བྱུང་བའི་དད་ལྡན་རྣམས་ལ་འཚམས་འདྲི་ཞུ། ");
INSERT INTO bod_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ང་ཚོས་མ་མངགས་པར་ང་ཚོའི་ཁྲོད་ནས་ཁ་ཅིག་ཐོན་ཏེ་ཁྱེད་རྣམས་ལ་སྡུག་པོ་བཏང་ཞིང༌། ཁོ་ཚོའི་གཏམ་གྱིས་ཁྱེད་ཚོའི་སེམས་དཀྲུགས་པར་བྱས་པའི་གཏམ་ཐོས་པས། ");
INSERT INTO bod_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ང་ཚོ་གཅིག་མཐུན་གྱིས་མི་གཉིས་བདམས་ཏེ་ངེད་ཀྱི་གཅེས་པའི་པར་ན་པཱ་དང་པའུ་ལུ་མཉམ་དུ་ཁྱེད་རྣམས་ཀྱི་མདུན་དུ་གཏོང་བར་ཐག་གཅོད་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ཁོང་གཉིས་ནི་ང་ཚོའི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་དོན་ལ་རང་གི་སྲོག་ཉེན་ལའང་འཛེམ་མེད། ");
INSERT INTO bod_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","དེའི་ཕྱིར་ང་ཚོས་ཡུ་དཱ་དང་སི་ལཱ་གཉིས་ཁྱེད་རྣམས་ཀྱི་དྲུང་དུ་མངགས་ཏེ། དོན་འདི་ཚོ་ཁོང་ཚོས་རང་གི་ཞལ་ནས་ཁྱེད་རྣམས་ལ་བཤད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","གང་ཡིན་ཟེར་ན། དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱི་དགོངས་པ་དང་མཚུངས་པར་དོན་གལ་ཆེ་བ་འདི་ཚོ་ལས་ལྷག་པའི་ཁུར་པོ་ཁྱེད་རྣམས་ཀྱི་ཕྲག་པར་འགེལ་བར་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ཁྱེད་ཚོས་ལྷ་སྐུའི་མདུན་དུ་ཕུལ་བའི་མཆོད་རྫས་མི་གཙང་བ་དང༌། ཁྲག སྐེ་བཙིར་ནས་གསོད་པའི་དུད་འགྲོའི་ཤ ལོག་གཡེམ་བཅས་ལ་འཛེམ་དགོས། དེ་ཚོ་དང་འབྲེལ་བ་ཅི་ཡང་མེད་ན་ལེགས། ཁྱེད་རྣམས་བདེ་བར་ཤོག ཅེས་པའོ། ། ");
INSERT INTO bod_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ཁོང་རྣམས་ཕར་མངགས་ཏེ་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་དུ་སླེབས་པ་དང༌། དད་ལྡན་རྣམས་བསྡུས་ནས་འཕྲིན་ཡིག་དེ་ཁོ་ཚོར་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","དེ་བཀླགས་པས་སེམས་གསོ་བའི་གཏམ་གྱིས་ཁོ་ཚོ་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ལུང་སྟོན་པ་ཡང་ཡིན་པའི་ཡུ་དཱ་དང་སི་ལཱ་གཉིས་ཀྱིས་གཏམ་མང་པོ་བཤད་དེ་སྤུན་ཟླ་རྣམས་ལ་སེམས་གསོ་བཏང་ཞིང༌། ཁོ་ཚོའི་དད་པ་བརྟན་པོར་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","དེར་བཞུགས་པའི་རྗེས་སུ་སྤུན་ཟླ་རྣམས་ཀྱིས་ཁོ་ཚོ་མངག་མཁན་གྱི་དྲུང་དུ་ཞི་བདེའི་ངང་ནས་ཕྱིར་ལོག་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ཡང་པའུ་ལུ་དང་པར་ན་པཱ་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་ལ་གནས་ཤིང༌། མི་གཞན་མང་པོ་དང་བཅས་པར་ཁོང་རྣམས་ཀྱིས་ཆོས་བསྟན་པ་དང༌། གཙོ་བོ་དཀོན་མཆོག་གི་འཕྲིན་བཟང་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","དེའི་རྗེས་སུ་པའུ་ལུ་ཡིས་པར་ན་པཱ་ལ་“སྤུན་ཟླ་རྣམས་ཀྱི་དད་པ་ཇི་ལྟར་ཡིན་མིན་ཤེས་པའི་ཕྱིར་ང་ཚོས་སྔར་དཀོན་མཆོག་གི་བཀའ་བསྒྲགས་པའི་གྲོང་ཁྱེར་རེ་རེར་ཕྱིར་ལོག་བྱེད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","པར་ན་པཱ་ཡིས་ཡོ་ཧ་ནན་ཏེ་མར་ཀུ་ཡང་ཟེར་བ་མཉམ་དུ་འཁྲིད་པར་འདོད་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","མར་ཀུ་སྔར་ཕམ་ཕིལ་ཡཱ་ཡུལ་ལ་ཁོང་དང་ཁ་བྲལ་ནས་ཕྱིན་ཞིང༌། ལས་མ་སྒྲུབ་པའི་བར་དུ་མ་འགྲོགས་པས་པའུ་ལུས་ཁོ་མཉམ་དུ་འཁྲིད་ན་མི་འོས་པར་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","བསམ་འཆར་མི་མཐུན་པ་དྲག་པོ་བྱུང་བས་ཁོང་གཉིས་སོ་སོར་གྱེས་པ་དང༌། པར་ན་པཱས་མར་ཀུ་འཁྲིད་དེ་གྲུ་གཟིངས་ལ་བསྡད་ནས་ཀིབ་རུ་གླིང་ཕྲན་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","འོན་ཀྱང་པའུ་ལུས་སི་ལཱ་བདམས་ནས་ཕར་ཕེབས་ཏེ། དད་ལྡན་རྣམས་ཀྱིས་ཁོང་གཉིས་གཙོ་བོའི་ཐུགས་རྗེ་ལ་བཅོལ། ");
INSERT INTO bod_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","པའུ་ལུས་སི་རི་ཡཱ་ཡུལ་དང་ཀི་ལིག་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཕེབས་ཏེ་ཆོས་ཚོགས་རྣམས་ལ་བརྟན་པོར་བྱས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ཡང་དེ་ནས་པའུ་ལུ་ཌེར་པེ་དང་ལིས་ཏྲཱ་གྲོང་ཁྱེར་དུ་སླེབས། དེར་ཐི་མོ་ཐེ་ཞེས་བྱ་བའི་ཉེ་གནས་ཤིག་ཡོད་དེ། ཁོའི་ཨ་མ་ནི་དད་ལྡན་པའི་ཡ་ཧུ་དཱ་པ་ཞིག་ཡིན་ཡང༌། ཕ་གྷི་རིག་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ལིས་ཏྲཱ་དང་ཨི་ཀོན་ཡཱུ་གྲོང་ཁྱེར་ལ་སྡོད་པའི་སྤུན་ཟླ་རྣམས་ཀྱིས་ཁོ་ལ་བསྟོད་པར་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","པའུ་ལུས་ཐི་མོ་ཐེ་ཁོང་དང་མཉམ་དུ་འགྲོ་བར་འདོད་པས་ཁོང་གིས་ཁོ་ལ་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་རྒྱག་ཏུ་བཅུག གང་ལགས་ཤེ་ན། ཡུལ་དེར་ཡ་ཧུ་དཱ་པ་མང་པོ་ཡོད་ཅིང༌། ཁོ་ཚོ་ཚང་མས་ཐི་མོ་ཐེའི་ཕ་ནི་གྷི་རིག་པ་ཡིན་པར་ཤེས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","གྲོང་ཁྱེར་རྣམས་བརྒྱུད་ནས་འགྲོ་དུས་ཡེ་རུ་ཤ་ལེམ་གྱི་སྐུ་ཚབ་དང་འགན་འཁུར་བ་རྣམས་ཀྱིས་ཐག་བཅད་པའི་བཀའ་སྲུང་བའི་ཕྱིར་དད་ལྡན་རྣམས་ལ་བསྒྲགས་པས། ");
INSERT INTO bod_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ཆོས་ཚོགས་རྣམས་ཀྱི་དད་སེམས་བརྟན་པོར་གྱུར་ཞིང༌། དད་ལྡན་རྣམས་ཀྱི་གྲངས་ཉིན་རེ་བཞིན་མང་དུ་འཕེལ། ");
INSERT INTO bod_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁོང་ཚོ་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ལ་བཀའ་སྒྲོག་ཏུ་མ་བཅུག་པས། ཁོང་རྣམས་ཕ་རུག་ཡཱ་དང་ག་ལད་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཕེབས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","མོ་སི་ཡཱ་ཡུལ་དུ་སླེབས་དུས་པི་ཐིན་ཡཱ་ཞིང་ཆེན་ལ་ཞུགས་པར་བསམས་ཀྱང༌། ཡེ་ཤུའི་ཐུགས་ཉིད་ཀྱིས་འགྲོ་མ་བཅུག་པའི་རྐྱེན་གྱིས། ");
INSERT INTO bod_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","མོ་སི་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཏྲོ་ཡཱ་གྲུ་ཁར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","མཚན་མོར་པའུ་ལུ་ལ་ཞལ་གཟིགས་གནང་སྟེ་མ་ཀེ་དོན་ཡཱ་ཞིང་ཆེན་གྱི་མི་ཞིག་ཁོང་གི་དྲུང་དུ་ལངས་ནས་ཁོང་ལ་“མ་ཀེ་དོན་ཡཱ་ལ་ཕེབས་ནས་ང་ཚོར་རོགས་པ་གནང་རོགས་”ཞེས་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ཞལ་གཟིགས་དེ་མཐོང་བའི་རྗེས་དཀོན་མཆོག་གིས་ང་ཚོ་དངོས་སུ་མ་ཀེ་དོན་ཡཱ་པ་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་ཏུ་བོས་པར་ཤེས་ནས། ང་ཚོས་འཕྲལ་དུ་ཁོ་ཚོའི་རྩར་འགྲོ་བའི་གྲ་སྒྲིག་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","དེ་ནས་ཏྲོ་ཡཱ་ནས་གྲུ་གཟིངས་ལ་བསྡད་དེ་སཱ་མོ་ཏྲེ་ཀེ་ཞེས་པའི་གླིང་ཕྲན་ལ་ཐད་ཀར་ཕྱིན་ཞིང༌། དེའི་ཕྱི་ཉིན་ནེ་ཨ་པོ་ལི་ཞེས་པའི་གྲུ་ཁར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","དེ་ནས་མ་ཀེ་དོན་ཡཱ་ཡུལ་གྱི་གལ་ཆེན་གྲོང་ཁྱེར་ཕི་ལིབ་པཱི་ལ་སླེབས། གྲོང་ཁྱེར་དེ་ནི་རོ་མཱའི་རྒྱལ་ཁབ་ཀྱི་ཁོངས་གཏོགས་ཡིན་ཞིང་དེར་ང་ཚོ་ཉིན་ཤས་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ངལ་གསོ་བའི་ཉིན་མོར་ང་ཚོ་གྲོང་ཁྱེར་གྱི་སྒོའི་ཕྱི་ཕྱོགས་གཙང་པོའི་འགྲམ་དུ་སྨོན་ལམ་འདེབས་ས་ཡིན་པར་བསམས་ནས། དེ་ལ་ཕྱིན་ཏེ་བསྡད་པ་དང༌། དེར་འཛོམས་ཡོད་པའི་བུད་མེད་རྣམས་ལ་ཆོས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","དེའི་ནང་ནས་གྲོང་ཁྱེར་ཐི་ཡ་ཏི་རཱ་ནས་ཡིན་པའི་མདོག་རྒྱ་སྨུག་ཅན་གྱི་རས་འཚོང་མཁན་ལི་དི་ཡཱ་ཞེས་བྱ་བའི་བུད་མེད་ཅིག་གིས་ང་ཚོའི་གཏམ་ལ་ཉན། ཁོ་མོ་ནི་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་ཡིན་ལ། པའུ་ལུས་གསུངས་པའི་བཀའ་ལ་ཉན་པའི་ཕྱིར་གཙོ་བོས་ཁོ་མོའི་བློ་སྒོ་ཕྱེ། ");
INSERT INTO bod_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ཁོ་མོས་རང་གི་ནང་མི་དང་བཅས་པར་ཁྲུས་གསོལ་ལེན་པའི་རྗེས་སུ་“གལ་ཏེ་ཁྱེད་ཀྱིས་ང་གཙོ་བོ་ལ་དད་པ་བྱེད་མཁན་ཞིག་ཡིན་པར་བརྩིས་ན། ངའི་ཁང་པར་ཕེབས་ནས་བཞུགས་དང་”ཞེས་ནན་གྱིས་བསྐུལ་ནས་ང་ཚོ་དེར་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","དེ་ནས་ཉིན་ཞིག་ལ་སྨོན་ལམ་འདེབས་སར་འགྲོ་དུས་སྔོན་ཤེས་དང་ལྡན་པའི་གདོན་འདྲེ་ཡིས་ཟིན་པའི་བྲན་མོ་ཞིག་ང་ཚོ་དང་ཕྲད། ཁོ་མོས་སྔོན་ཤེས་བཤད་པའི་སྒོ་ནས་རང་གི་བདག་པོ་རྣམས་ལ་དངུལ་མང་པོ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ཁོ་མོ་པའུ་ལུ་དང་ང་ཚོའི་རྗེས་སུ་འབྲང་དུས་སྐད་ཆེན་པོས་“མི་འདི་རྣམས་བླ་ན་མེད་པའི་དཀོན་མཆོག་གི་ཞབས་ཕྱི་དང༌། ཁྱེད་རྣམས་ལ་ཐར་བའི་ལམ་སྟོན་མཁན་ཡིན་”ཞེས་ཡང་ཡང་བརྗོད། ");
INSERT INTO bod_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ཉིན་མང་པོའི་རིང་ལ་དེ་ལྟར་བྱས་པས་པའུ་ལུ་སུན་སྣང་ཆེན་པོ་སྐྱེས་ནས་ཁ་ཚུར་གཅུས་ཏེ་གདོན་འདྲེ་དེ་ལ་“ངས་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་མཚན་ཐོག་ནས་ཁྱོད་ལ་མོ་ནས་ཕྱིར་ཐོན་པའི་བཀའ་གཏོང་”ཞེས་གསུངས་མ་ཐག་གདོན་འདྲེ་དེ་ཕྱིར་ཐོན། ");
INSERT INTO bod_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","བྲན་མོ་དེའི་བདག་པོ་རྣམས་ཀྱིས་དངུལ་འཐོབ་པའི་རེ་བ་མེད་པར་གྱུར་བ་ཤེས་ནས། ཁོ་ཚོས་པའུ་ལུ་དང་སི་ལཱ་གཉིས་བཟུང་ནས་ཁྲོམ་ལ་ཡོད་པའི་དཔོན་པོ་རྣམས་ཀྱི་དྲུང་དུ་དྲུད། ");
INSERT INTO bod_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ཡང་ཁྲིམས་དཔོན་རྣམས་ཀྱི་དྲུང་དུ་འཁྲིད་ནས་ཁོ་ཚོས་“མི་འདི་གཉིས་ཡ་ཧུ་དཱ་པ་ཡིན་ཞིང་ང་ཚོའི་གྲོང་ཁྱེར་དཀྲུག་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ངེད་རོ་མཱ་པ་རྣམས་ལ་ཁྲིམས་ལྟར་དང་ལེན་མི་བྱེད་པ་དང༌། སྲུང་མི་ཆོག་པའི་ལུགས་སྲོལ་སྒྲོག་བཞིན་འདུག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","མི་ཚོགས་ཀྱིས་ཀྱང་ཁོང་གཉིས་ལ་ངོ་རྒོལ་བྱས་པས་ཁྲིམས་དཔོན་རྣམས་ཀྱིས་པའུ་ལུ་དང་སི་ལཱ་ཡི་ཕྱི་གོས་འབུད་དུ་བཅུག་ནས་དབྱུག་པ་ཡིས་རྡུང་བའི་བཀའ་བསྒོས། ");
INSERT INTO bod_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ཁོང་ཚོ་དྲག་པོ་བརྡུངས་ནས་བཙོན་ཁང་དུ་བཅུག་པ་དང༌། བཙོན་སྲུང་དཔོན་ལ་དམ་པོར་སྲུང་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","བཀའ་དེ་བཞིན་དུ་བཙོན་སྲུང་དཔོན་གྱིས་ཁོང་ཚོ་བཙོན་ཁང་གི་ཕུགས་ལ་བཅུག་ནས་ཁོ་ཚོའི་རྐང་པར་ཤིང་སྒྲོག་བརྒྱབ་ནས་བཞག ");
INSERT INTO bod_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ནམ་ཕྱེད་ཙམ་ལ་པའུ་ལུ་དང་སི་ལཱ་གཉིས་ཀྱིས་སྨོན་ལམ་འདེབས་ཤིང་དཀོན་མཆོག་ལ་མགུར་གླུ་ལེན་སྐབས་བཙོན་པ་གཞན་རྣམས་ཀྱིས་ཉན། ");
INSERT INTO bod_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","གློ་བུར་དུ་ས་ཡོམ་ཆེན་པོ་བྱུང་བས་བཙོན་ཁང་གི་རྩིག་རྨང་གཡོ་བར་གྱུར། འཕྲལ་དུ་བཙོན་ཁང་གི་སྒོ་ཐམས་ཅད་བྱེ་ནས་བཙོན་པ་རྣམས་ཀྱི་ལྕགས་ཐག་གྲོལ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","གཉིད་ལས་སད་སྐབས་བཙོན་སྲུང་དཔོན་གྱིས་བཙོན་ཁང་གི་སྒོ་བྱེ་ཡོད་པ་མཐོང་བས། བཙོན་པ་བྲོས་པར་སྙམ་སྟེ་རལ་གྲི་ཞིག་བཏོན་ནས་རང་སྲོག་གཅོད་པར་བསམས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","པའུ་ལུས་སྐད་ཆེན་པོས་“ཁྱེད་ཀྱིས་རང་ལ་གནོད་པ་མ་བྱོས་ཤིག ང་ཚོ་ཐམས་ཅད་འདིར་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","བཙོན་སྲུང་དཔོན་གྱིས་བཞུ་མར་འཁྱེར་དགོས་པའི་བཀའ་བཏང་ནས་བཙོན་ཁང་ནང་དུ་བརྒྱུགས། འཇིགས་ནས་འདར་བཞིན་པའུ་ལུ་དང་སི་ལཱ་ཡི་དྲུང་དུ་ཕྱག་འཚལ། ");
INSERT INTO bod_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ཁོང་རྣམས་ཕྱི་རོལ་ཏུ་འཁྲིད་ནས་བཙོན་སྲུང་དཔོན་གྱིས་“སྐུ་ཞབས། ཐར་བར་འགྱུར་བའི་ཕྱིར་ངས་གང་ཞིག་བྱེད་དགོས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ཁོང་ཚོས་“གཙོ་བོ་ཡེ་ཤུ་ལ་དད་པ་བྱོས་ཤིང༌། ཁྱེད་རང་དང་ཁྱེད་ཀྱི་ནང་མི་ཚང་མ་ཐར་བར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ཁོང་ཚོས་ཁོ་དང་ཁོའི་ནང་མི་ཚང་མར་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","མཚན་མོའི་ཆུ་ཚོད་དེ་རང་ལ་བཙོན་སྲུང་དཔོན་གྱིས་ཁོང་ཚོ་འཁྲིད་དེ་རྨ་བཀྲུས་པ་དང༌། ཁོ་དང་ཁོའི་ནང་མི་ཚང་མས་མྱུར་དུ་ཁྲུས་གསོལ་ལེན། ");
INSERT INTO bod_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","བཙོན་སྲུང་དཔོན་གྱིས་ཁོང་རྣམས་རང་གི་ཁྱིམ་དུ་འཁྲིད་ནས་ཟས་སྟེར་ཞིང༌། དཀོན་མཆོག་ལ་དད་པ་དང་ལྡན་པར་གྱུར་བས་ཁོ་རང་དང་ནང་མི་ཐམས་ཅད་ཧ་ཅང་དགའ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","དེའི་སང་ཞོགས་ཁྲིམས་དཔོན་རྣམས་ཀྱིས་སྲུང་དམག་བཏང་སྟེ་“མི་དེ་གཉིས་གློད་གྲོལ་གཏོང་ཞིག་”ཅེས་པའི་བཀའ་བསྩལ། ");
INSERT INTO bod_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","བཙོན་སྲུང་དཔོན་གྱིས་པའུ་ལུ་ལ་གཏམ་དེ་བཤད་དེ་“ཁྲིམས་དཔོན་རྣམས་ཀྱིས་ཁྱེད་ཚོ་གློད་གྲོལ་གཏོང་བའི་བཀའ་བཙལ་བས། ཕྱི་རོལ་ཏུ་ཕེབས་ཤིང༌། ཞི་བདེའི་ངང་ནས་སོང་དང་”ཞེས་སྨྲས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","པའུ་ལུས་སྲུང་དམག་རྣམས་ལ་“ང་ཚོ་རོ་མཱ་གོང་མའི་རྒྱལ་ཁབ་ཀྱི་མངའ་འབངས་ཡིན་ཡང༌། ཁྲིམས་རར་འདྲི་གཅོད་མི་བྱས་པར་དམངས་ཀྱི་མདུན་དུ་བརྡུངས་ནས་ང་ཚོ་བཙོན་ཁང་དུ་བཅུག ད་ལྟ་ཁོ་ཚོས་གསང་བའི་ངང་ནས་ང་ཚོ་འདོན་ནམ། དེ་ལྟར་མི་བྱ། འདིར་ཡོང་ནས་ཁོ་ཚོ་རང་གིས་ང་ཚོ་ཕྱི་རོལ་ཏུ་འཁྲིད་དགོས་”ཞེས་གསུངས་པའི་གཏམ་དེ། ");
INSERT INTO bod_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","སྲུང་དམག་ཚོས་ཁྲིམས་དཔོན་རྣམས་ལ་བཤད། ཁོང་ཚོ་གཉིས་རོ་མཱ་གོང་མའི་རྒྱལ་ཁབ་ཀྱི་མངའ་འབངས་ཡིན་པ་ཐོས་ནས་ཁྲིམས་དཔོན་རྣམས་འཇིགས་པར་གྱུར་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","དེར་ཡོང་ནས་ཁོང་ཚོར་དགོངས་དག་ཞུས་པ་དང༌། ཕྱི་རོལ་ཏུ་འཁྲིད་དེ་གྲོང་ཁྱེར་ནས་ཕར་ཕེབས་པར་ཡང་ཡང་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ཁོང་གཉིས་བཙོན་ཁང་ནས་ཐོན་པ་དང༌། ལི་དི་ཡཱ་ཡི་ཁང་པར་ཕེབས། སྤུན་ཟླ་རྣམས་དང་ལྷན་དུ་འདུས་ཏེ་ཁོ་ཚོར་བློ་སྟོབས་སྤེལ་ནས་ཕར་ཕེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","པའུ་ལུ་དང་སི་ལཱ་ཨམ་ཕི་པོ་ལཱི་དང་ཨ་པོ་ལོན་ཡཱ་གྲོང་ཁྱེར་བརྒྱུད་ནས་ཕེབས་རྗེས་ཐེ་ས་ལོ་ནི་ཀེ་གྲོང་ཁྱེར་དུ་སླེབས། དེར་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ཞིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","པའུ་ལུ་ཡིས་གོམས་གཤིས་ལྟར་དེར་ཕེབས་པ་དང༌། ངལ་གསོ་བའི་ཉིན་མོ་གསུམ་གྱི་བར་དུ་གསུང་རབ་ལ་བརྟེན་ནས་ཁོ་ཚོར་རྩོད་གླེང་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","མཱ་ཤི་ཀ་སྡུག་བསྔལ་མྱོང་ནས་སླར་གསོན་པོར་འགྱུར་དགོས་པར་གསལ་བཤད་དང་ར་སྤྲོད་བྱས། པའུ་ལུས་“ངས་ཁྱེད་རྣམས་ལ་སྒྲོག་བཞིན་པའི་ཡེ་ཤུ་ནི་མཱ་ཤི་ཀ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","དེ་རྣམས་ཀྱི་ནང་ནས་ཁ་ཤས་དང༌། ཆོས་སེམས་དང་ལྡན་པའི་གྷི་རིག་པ་མང་པོ། རིགས་མཐོ་བའི་བུད་མེད་བཅས་དད་པ་སྐྱེས་ནས་པའུ་ལུ་དང་སི་ལཱ་གཉིས་དང་འགྲོགས། ");
INSERT INTO bod_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","འོན་ཀྱང་ཡ་ཧུ་དཱ་པ་རྣམས་ཕྲག་དོག་སྐྱེས་ཏེ་ཁྲོམ་ནས་མི་ངན་ཁ་ཤས་འཁྲིད་དེ་འཛོམས་བྱས་པ་དང༌། གྲོང་ཁྱེར་གྱི་མི་རྣམས་ལ་ངན་བསྐུལ་བྱས། པའུ་ལུ་དང་སི་ལཱ་གཉིས་མི་ཚོགས་ཀྱི་རྩར་བཙན་འཁྲིད་བྱེད་པའི་ཕྱིར་ཡཱ་སོན་གྱི་ཁང་པར་བཙན་གྱིས་འཛུལ་ཡང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ཁོང་གཉིས་མ་རྙེད་པས་ཁོ་ཚོས་ཡཱ་སོན་ལ་སོགས་པའི་སྤུན་ཟླ་ཁ་ཅིག་གྲོང་ཁྱེར་དཔོན་རིགས་ཀྱི་རྩར་བཙན་གྱིས་འཁྲིད་ནས་སྐད་ཆེན་པོས་“ས་གཞི་ཐམས་ཅད་དཀྲུག་མཁན་འདི་གཉིས་ས་ཆ་འདིར་ཡང་སླེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ཡཱ་སོན་གྱིས་ཁོ་ཚོ་བསུས། ཁོ་ཚོ་ཚང་མས་གོང་མའི་རྒྱལ་པོ་སེ་སར་གྱི་བཀའ་ལས་འགལ་ཏེ་ཡེ་ཤུ་ཞེས་ཟེར་བའི་རྒྱལ་པོ་གཞན་ཞིག་ཡོད་པར་སྨྲས་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","དེ་ཐོས་ནས་མི་ཚོགས་དང་གྲོང་ཁྱེར་གྱི་དཔོན་པོ་རྣམས་སེམས་འཁྲུགས། ");
INSERT INTO bod_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ཡཱ་སོན་དང་སྤུན་ཟླ་གཞན་རྣམས་ནས་གཏའ་མ་བླངས་ནས་དཔོན་རིགས་རྣམས་ཀྱིས་ཁོ་ཚོ་གློད་གྲོལ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","མཚན་མོ་དེ་རང་ལ་སྤུན་ཟླ་རྣམས་ཀྱིས་པའུ་ལུ་དང་སི་ལཱ་གཉིས་པུ་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་བཏང་ཞིང༌། དེར་སླེབས་ནས་ཁོང་རྣམས་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ལ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","གནས་འདིའི་མི་རྣམས་ཐེ་ས་ལོ་ནི་ཀེ་གྲོང་ཁྱེར་གྱི་ཡ་ཧུ་དཱ་པ་རྣམས་ལས་བློ་རྒྱ་ཆེ་ལ། འཕྲིན་བཟང་ཉན་རྒྱུར་དགའ་བ་མ་ཟད། བཀའ་ཐོས་ནས་དོན་དེ་རྣམས་བདེན་པ་ཡིན་མིན་ཤེས་པའི་ཕྱིར་ཁོ་ཚོས་ཉིན་ལྟར་གསུང་རབ་འཚོལ་ཞིབ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","དེའི་ཕྱིར་དེ་རྣམས་ལས་མི་མང་པོ་ཞིག་དང༌། གྷི་རིག་གི་རིགས་མཐོ་བའི་ཕོ་མོ་མང་པོའང་དད་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","འོན་ཀྱང་ཐེ་ས་ལོ་ནི་ཀེ་གྲོང་ཁྱེར་གྱི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་པའུ་ལུས་པུ་རེ་ཡཱ་གྲོང་ཁྱེར་ལའང་དཀོན་མཆོག་གི་བཀའ་སྒྲོག་པའི་གཏམ་ཐོས་པས། དེར་སོང་ནས་མི་ཚོགས་དཀྲུགས་ཤིང་ངན་བསྐུལ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","དེ་ནས་སྤུན་ཟླ་རྣམས་ཀྱིས་འཕྲལ་དུ་པའུ་ལུ་རྒྱ་མཚོའི་འགྲམ་དུ་བསྐྱལ་ཞིང༌། སི་ལཱ་དང་ཐི་མོ་ཐེ་པུ་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","པའུ་ལུ་སྐྱེལ་མཁན་རྣམས་ཀྱིས་ཁོང་ཨ་ཐེ་ནེ་གྲོང་ཁྱེར་ལ་འཁྲིད་ཅིང༌། པའུ་ལུས་སི་ལཱ་དང་ཐི་མོ་ཐེ་གཉིས་གང་མགྱོགས་ཡོང་དགོས་པའི་བཀའ་གནང་ནས་སྐྱེལ་མ་རྣམས་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","པའུ་ལུ་ཁོ་ཚོ་གཉིས་ཨ་ཐེ་ནེ་གྲོང་ཁྱེར་དུ་སྒུག་ནས་བསྡད་དུས། ས་ཆ་དེར་སྐུ་འདྲས་གང་ཡོད་པ་གཟིགས་ཏེ་སེམས་ཧ་ཅང་འཁྲུགས་པར་གྱུར་བས། ");
INSERT INTO bod_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","པའུ་ལུས་འདུ་ཁང་ལ་ཡ་ཧུ་དཱ་པ་དང༌། དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་པའི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་དེ་བཞིན་ཚོང་རར་ཡོང་བ་རྣམས་ལ་ཉིན་རེ་བཞིན་རྩོད་གླེང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ཡང་ཨེ་པི་ཀུར་ཞེས་པ་དང་སི་ཏོ་ཀེ་ཞེས་པའི་མཚན་ཉིད་རིག་པའི་ལྟ་བ་འཛིན་མཁན་ཁ་ཅིག་གིས་ཁོང་དང་རྩོད་གླེང་བྱས། ལ་ལས་“གང་བྱུང་མང་བྱུང་ཤོད་མཁན་འདིས་གང་སྨྲ་བར་འདོད་”ཅེས་ཟེར་ཞིང༌། ལ་ལས་“ཕྱི་པའི་ལྷ་སྒྲོག་མཁན་དང་འདྲ་བ་ཡིན་”ཞེས་སྨྲས། དེ་ནི་ཡེ་ཤུ་དང་ཁོང་འཆི་བ་ནས་སླར་གསོན་པོར་འགྱུར་བའི་སྐོར་གསུངས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","དེ་ནས་ཁོ་ཚོས་པའུ་ལུ་ཨ་རེ་ཨོ་པ་གུ་ཞེས་པའི་རྒྱལ་ཚོགས་ལ་འཁྲིད་དེ་ཁོང་ལ་“ཁྱེད་ཀྱིས་སྒྲོག་པའི་བསྟན་པ་གསར་པ་འདི་གང་ཡིན་ངེད་རྣམས་ལ་གསུང་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","གང་ལགས་ཤེ་ན། བསྟན་པ་འགའ་ཤས་ཁྱད་མཚར་བས་ངེད་རྣམས་དོན་འདི་ཚོ་རྟོགས་པར་འདོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(ཨ་ཐེ་ནེ་གྲོང་ཁྱེར་གྱི་མི་དང༌། ས་ཆ་དེར་ཡུལ་གཞན་ནས་ཡོང་བའི་མི་རྣམས་ཀྱིས་དོན་གསར་པའི་སྐོར་གཏམ་གླེང་བྱེད་པ་ལས་གཞན་གང་ཡང་མ་བྱས་) ");
INSERT INTO bod_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","དེ་ནས་པའུ་ལུས་ཨ་རེ་ཨོ་པ་གུ་ཚོགས་པའི་དཀྱིལ་ལ་བཞེངས་ཏེ་“ཨ་ཐེ་ནེ་པ་རྣམས། ཁྱེད་ཚོ་རྣམ་པ་ཀུན་ནས་ཆོས་ལ་ཤིན་ཏུ་དགའ་བའི་མི་ཡིན་པར་ངས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","གང་ཡིན་ཟེར་ན། ངས་གྲོང་ཁྱེར་བརྒྱུད་ནས་འགྲོ་དུས་ཁྱེད་རྣམས་ཀྱིས་བསྙེན་བཀུར་བྱེད་པའི་རྟེན་རྣམས་ལ་ཞིབ་ལྟ་བྱས་པ་དང༌། རྒྱུས་མེད་པའི་ལྷ་ཡི་ཕྱིར་ཞེས་བྲིས་པའི་མཆོད་ཁྲི་ཞིག་མཐོང་བས། ཁྱེད་རྣམས་ཀྱིས་མི་ཤེས་པར་བསྙེན་བཀུར་བྱེད་པ་དེ་ངས་ཁྱེད་ཚོར་སྒྲོག་པར་བྱ། ");
INSERT INTO bod_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","འཇིག་རྟེན་ཁམས་དང་དེར་ཡོད་པ་ཐམས་ཅད་འགོད་པ་གནང་མཁན་དཀོན་མཆོག་སྟེ་གནམ་ས་གཉིས་ཀྱི་བདག་པོ་ཡིན་པས་མི་ཡིས་བཟོས་པའི་ལྷ་ཁང་ལ་མི་བཞུགས་ལ། ");
INSERT INTO bod_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ཁོང་ལ་ཅི་ཡང་མི་དགོས་པའི་རྐྱེན་གྱིས་མིའི་ལག་པས་ཁོང་ལ་གཡོག་ཀྱང་བྱེད་མི་དགོས། གང་ལགས་ཟེར་ན། ཁོང་རང་གིས་མི་ཚང་མར་སྲོག་དང༌། དབུགས། ཅི་དགོས་པ་ཐམས་ཅད་གནང་བས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","དཀོན་མཆོག་གིས་མི་གཅིག་ནས་མི་རིགས་ཐམས་ཅད་བཀོད་པ་དང༌། ས་གཞི་ཡོངས་སུ་གནས་ཏུ་བཅུག དེ་ཚོ་སོ་སོའི་དུས་དང་གནས་པའི་ས་མཚམས་སྔོན་ནས་བསྐོས་པ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","དེ་ནི་དཀོན་མཆོག་བཙལ་ནས་རྙེད་པའི་རེ་བ་དང་ལྡན་པར་འགྱུར་བའི་ཕྱིར་ཡིན་ཏེ། དོན་དངོས་སུ་ཁོང་ང་ཚོ་རེ་རེ་དང་ཐག་རིང་པོ་མེད། ");
INSERT INTO bod_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","མི་ཞིག་གིས་བྲིས་པ་ལྟར། ངེད་རྣམས་གསོན་ཞིང་བགྲོད་པ་དང་ཁོང་ལ་བརྟེན་ནས་བྱུང་ཞེས་བྲིས་པ་དང༌། ཁྱེད་ཚོའི་སྙན་ངག་མཁན་འགའ་ཤས་ཀྱིས་ཀྱང༌། ང་ཚོའང་ཁོང་གི་བུ་རྒྱུད་ཡིན་ནོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ངེད་རྣམས་དཀོན་མཆོག་གི་བུ་རྒྱུད་ཡིན་པས་ཁོང་གི་ངོ་བོ་ནི་མི་རྣམས་ཀྱི་ལག་རྩལ་དང་བློ་གྲོས་ཀྱིས་བཟོས་པའི་གསེར་རམ། དངུལ་ལམ། རྡོའི་ལྷ་རྟེན་དང་འདྲ་བ་ཞིག་ཡིན་པར་བསམ་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","སྔོན་མི་རྣམས་ཀྱིས་དོན་དེ་ཚོ་མ་ཤེས་པར་དཀོན་མཆོག་གིས་མ་བརྩིས་ཡང༌། ད་ལྟ་ཁོང་གིས་གནས་ཀུན་གྱི་མི་ཐམས་ཅད་ལ་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་དགོས་པའི་བཀའ་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","གང་ཡིན་ཞེ་ན། ཁོང་གིས་ཁྲིམས་གཅོད་པའི་ཉིན་མོ་ཞིག་བསྐོས་པར་མཛད་ཅིང༌། ཉིན་དེར་ཁོང་གིས་བསྐོས་པའི་མི་ཞིག་གིས་འཇིག་རྟེན་གྱི་མི་རྣམས་ལ་དྲང་བདེན་གྱི་སྒོ་ནས་ཁྲིམས་གཅོད་མཛད་པར་འགྱུར། མི་དེ་འཆི་བ་ནས་སླར་གསོན་པར་མཛད་པའི་ངང་ནས་ཁོང་གིས་དེ་ལྟར་འབྱུང་བར་འགྱུར་བའི་ར་སྤྲོད་མི་ཐམས་ཅད་ལ་གསལ་པོར་བྱས་སོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","འཆི་བ་ནས་སླར་གསོན་པར་འགྱུར་བའི་སྐོར་ཐོས་ནས་མི་ལ་ལས་ཁོང་ལ་ཁྲེལ་དགོད་བྱས་ཀྱང༌། ལ་ལས་“དོན་དེའི་སྐོར་རྗེས་སུ་ཉན་པར་བྱ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","པའུ་ལུ་མི་དེ་ཚོའི་དཀྱིལ་ནས་ཕྱིར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","འོན་ཀྱང་དཱ་ཨོ་ནེ་སི་ཡཱུ་ཟེར་མཁན་ནི་ཨ་རེ་ཨོ་པ་གུ་ཚོགས་པའི་ཁོངས་མི་ཞིག་དང༌། དཱ་མ་རཱི་ཞེས་ཟེར་བའི་བུད་མེད་ཅིག་ལ་སོགས་པའི་མི་དད་པ་དང་ལྡན་པར་གྱུར་ནས་པའུ་ལུ་དང་འགྲོགས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","དེའི་རྗེས་སུ་པའུ་ལུ་ཨ་ཐེ་ནེ་གྲོང་ཁྱེར་ནས་ཀོ་རིན་ཐུ་གྲོང་ཁྱེར་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","དེར་ཁོང་དང་པོན་ཏུ་ཡུལ་དུ་སྐྱེས་པའི་ཡ་ཧུ་དཱ་པ་ཨ་ཀུ་ལཱ་དང་ཕྲད། གོང་མའི་རྒྱལ་པོ་ཀ་ལོ་དཱི་ཡིས་ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་རོ་མཱ་གྲོང་ཁྱེར་ནས་འཐོན་དགོས་པའི་བཀའ་ཞིག་བསྒོས་པས། ཨ་ཀུ་ལཱ་དང་ཁོའི་བཟའ་ཟླ་ཕུར་སི་ལཱ་དབྱི་ཏ་ལི་ཡུལ་ནས་ས་ཆ་འདིར་སླེབས་མ་ཐག་ཡིན། པའུ་ལུ་ཁོ་ཚོའི་རྩར་ཕེབས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ཁོ་རྣམས་དང་འགྲོགས་ཏེ་ལས་ཀ་བྱས། གང་ཡིན་ཟེར་ན། ཁོང་ཡང་ཁོ་ཚོ་དང་མཚུངས་པར་གུར་བཟོ་མཁན་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ངལ་གསོ་བའི་ཉིན་རེ་རེ་བཞིན་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་དུ་ཁོང་གིས་ཡ་ཧུ་དཱ་པ་དང་གྷི་རིག་པ་རྣམས་དང་རྩོད་གླེང་བྱས་ཏེ་ཁོ་ཚོའི་བློ་འགུགས་པར་བརྩོན། ");
INSERT INTO bod_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","སི་ལཱ་དང་ཐི་མོ་ཐེ་གཉིས་མ་ཀེ་དོན་ཡཱ་ཡུལ་ནས་དེར་སླེབས་སྐབས། པའུ་ལུས་ཡེ་ཤུ་ནི་མཱ་ཤི་ཀ་ཡིན་པ་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་བདེན་དཔང་མཐའ་གཅིག་ཏུ་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་པའུ་ལུ་ལ་ངོ་རྒོལ་དང་དམའ་འབེབས་བྱེད་སྐབས། ཁོང་གིས་ཕྱི་གོས་ཐོག་གི་ས་རྡུལ་ཁོ་ཚོའི་ཕྱོགས་སུ་སྤྲུགས་ཏེ་“ཁྱོད་ཚོའི་སྡིག་ཉེས་ཀྱི་ཆད་པ་ཁྱོད་ཚོའི་མགོ་ལ་ཕོག་པར་འགྱུར། ང་ལ་འགན་ཅི་ཡང་མེད། ད་ནས་བཟུང་ང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་འཕྲིན་བཟང་སྒྲོག་ཏུ་འགྲོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","དེ་ནས་ཐོན་ཞིང་འདུ་ཁང་གི་འགྲམ་དུ་ཡོད་པའི་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་མཁན་ཐི་ཏི་ཡཱུ་ཡུ་སི་ཏཱུ་ཟེར་མཁན་ཞིག་གི་ཁྱིམ་ལ་བཞུགས་པར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ཡང་འདུ་ཁང་གི་འགོ་ཁྲིད་ཀ་རི་སི་པཱུ་དང་ཁོང་གི་ནང་མི་ཐམས་ཅད་གཙོ་བོ་ལ་དད་པར་གྱུར། དེའི་སྐོར་ཐོས་ནས་ཀོ་རིན་ཐུ་པ་མང་པོ་ཞིག་གིས་དད་པ་བྱས་ཏེ་ཁྲུས་གསོལ་ལེན། ");
INSERT INTO bod_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","མཚན་མོ་ཞིག་ལ་གཙོ་བོས་ཞལ་གཟིགས་གནང་ནས་པའུ་ལུ་ལ་“འཇིགས་པ་མེད་པར་ཆོས་སྟོན་ལ་མ་ལབ་པར་མ་སྡོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","གང་ཡིན་ཟེར་ན། ང་ཁྱོད་དང་མཉམ་དུ་གནས་ཤིང༌། གྲོང་ཁྱེར་འདི་ལ་ང་དང་འགྲོགས་པའི་མི་མང་པོ་ཡོད་པས་གནོད་འཚེ་བྱེད་མཁན་སུས་ཀྱང་ཁྱོད་ལ་རྒོལ་བར་མི་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","པའུ་ལུ་ལོ་གཅིག་དང་ཟླ་བ་དྲུག་དེར་བཞུགས་ཏེ་ཁོ་ཚོའི་ཁྲོད་དུ་དཀོན་མཆོག་གི་བཀའ་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ཡང་ག་ལི་ཡཱོ་ཞེས་བྱ་བ་ཨ་ཀ་ཡཱ་ཡུལ་གྱི་སྤྱི་ཁྱབ་ཡིན་པའི་དུས་སུ་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་གཅིག་མཐུན་གྱིས་པའུ་ལུ་ལ་ངོ་རྒོལ་བྱས་ནས་ཁྲིམས་རར་འཁྲིད་དེ་ ");
INSERT INTO bod_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“མི་འདིས་མི་རྣམས་ལ་དཀོན་མཆོག་ལ་ཁྲིམས་དང་འགལ་བའི་བསྙེན་བཀུར་གྱི་བྱ་ཐབས་སྐྱོང་དགོས་པའི་ངན་བསྐུལ་བྱེད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","པའུ་ལུས་གསུང་གྲབས་ཡོད་དུས་ག་ལི་ཡཱོ་ཡིས་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་“ཡ་ཧུ་དཱ་པ་ཁྱོད་རྣམས། གལ་ཏེ་དོན་དེ་ཉེས་པའམ་ནག་ཉེས་ཆེན་པོ་ཤིག་ཡིན་ན་ངས་ཁྱོད་ཚོར་བཟོད་པ་དེ་རིགས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","འོན་ཀྱང་ཁྱོད་ཚོའི་རྩོད་གཞི་ཆོས་ཁྲིམས་ཀྱི་སྐོར་དང་མིང༌། ཚིག་བཅས་ཡིན་པས་ཁྱོད་རང་ཚོས་ཐག་གཅོད་བྱོས་ཤིག ང་ནི་དོན་དེའི་ཁྲིམས་དཔོན་དུ་འགྱུར་མི་འདོད་”ཅེས་ཟེར་ནས། ");
INSERT INTO bod_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ཁོས་ཁོ་ཚོ་ཁྲིམས་ར་ནས་ཕར་བསྐྲད། ");
INSERT INTO bod_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","དེ་ནས་ཁོ་ཚོ་ཚང་མས་འདུ་ཁང་གི་འགོ་ཁྲིད་སོ་ཐེ་ནཱེ་བཙན་བཟུང་བྱས་ནས་ཁྲིམས་རའི་མདུན་དུ་བརྡུངས་ན་ཡང༌། ག་ལི་ཡཱོ་ཡིས་བྱ་བ་དེ་ལ་ཁ་ཡ་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ས་ཆ་དེར་པའུ་ལུ་ཉིན་མང་པོ་གནས་པའི་རྗེས་སུ་སྤུན་ཟླ་རྣམས་དང་ཁ་བྲལ་ཏེ་ཕུར་སི་ལཱ་དང་ཨ་ཀུ་ལཱ་མཉམ་དུ་གྲུ་གཟིངས་ལ་བཞུགས་ནས་སི་རི་ཡཱ་ཡུལ་དུ་ཕེབས། པའུ་ལུ་ཀེན་གྲེ་གྲུ་ཁར་ཕེབས་ནས་དེར་སྔར་བཞག་པའི་དམ་བཅའ་བཞིན་ཁོང་གི་དབུ་སྐྲ་བྲེགས། ");
INSERT INTO bod_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་དུ་སླེབས་ནས་པའུ་ལུ་ཁོ་གཉིས་དེར་བཞག ཁོང་ཉིད་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ལ་འཛུལ་ཏེ་ཡ་ཧུ་དཱ་པ་རྣམས་དང་རྩོད་གླེང་བྱས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ཁོ་ཚོས་ཡུན་རིང་པོ་ཞིག་དེར་སྡོད་པར་ཞུས་ཀྱང་ཁོང་གིས་ཞལ་མ་བཞེས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ཁོ་ཚོ་དང་ཁ་བྲལ་ནས་ཁོང་གིས་“དཀོན་མཆོག་གི་དགོངས་པ་ཡིན་ན་ང་ཕྱིར་ལོག་པར་བྱ་”ཞེས་གསུངས་པའི་རྗེས་སུ་གྲུ་གཟིངས་ལ་བཞུགས་ནས་ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་ནས་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་སླེབས་པའི་རྗེས་སུ་ཡེ་རུ་ཤ་ལེམ་གྱི་ཆོས་ཚོགས་ལ་འཚམས་འདྲི་ཞུ་བར་ཡར་སོང༌། དེ་ནས་ཁོང་ཨན་ཏི་ཡོག་ཡཱ་གྲོང་ཁྱེར་དུ་མར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","དེར་རེ་ཞིག་བཞུགས་པའི་རྗེས་སུ་ཁོང་ས་ཆ་དེ་དང་ཁ་བྲལ་བ་དང༌། རིམ་བཞིན་ག་ལད་ཡཱ་དང་ཕ་རུག་ཡཱ་ཡུལ་གཉིས་བརྒྱུད་ནས་ཕེབས་ཏེ་ཉེ་གནས་ཐམས་ཅད་ཀྱི་དད་པ་བརྟན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","དེའི་དུས་སུ་ཨ་ལིག་ཟན་དྲི་ཡཱ་གྲོང་ཁྱེར་དུ་སྐྱེས་པའི་ཡ་ཧུ་དཱ་པ་ཨ་པོ་ལོ་སི་ཞེས་བྱ་བ་སྨྲ་མཁས་ཅན་དང་གསུང་རབ་ལ་མཁས་པ་ཞིག་ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་དུ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ཁོས་གཙོ་བོ་ཡེ་ཤུའི་ལམ་ལ་བསླབས་ཤིང༌། བརྩོན་སེམས་ཀྱིས་ཡེ་ཤུའི་སྐོར་ཡང་དག་པར་གསུངས་ཏེ་ཆོས་བསྟན་ཡང༌། ཡོ་ཧ་ནན་གྱི་ཁྲུས་གསོལ་འབའ་ཞིག་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་ལ་ཁོས་བློ་སྟོབས་ཆེན་པོས་ཆོས་བསྟན་པར་བརྩམས། འོན་ཀྱང་ཕུར་སི་ལཱ་དང་ཨ་ཀུ་ལཱ་གཉིས་ཀྱིས་ཁོའི་བསྟན་པ་ཐོས་སྐབས་ཟུར་དུ་འཁྲིད་ནས་ཁོ་ལ་དཀོན་མཆོག་གི་ལམ་ནི་དེ་ལས་ཡང་དག་པར་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ཨ་པོ་ལོ་སི་ཨ་ཀ་ཡཱ་ཡུལ་ལ་འགྲོ་བར་འདོད་སྐབས་སྤུན་ཟླ་རྣམས་ཀྱིས་ཁོ་བསྐུལ་ནས་ཡུལ་དེའི་ཉེ་གནས་རྣམས་ལ་ཁོ་བསུ་དགོས་ཞེས་པའི་འཕྲིན་ཡིག་བྲིས། དེར་སླེབས་ནས་ཐུགས་རྗེའི་སྒོ་ནས་དད་པར་གྱུར་བ་རྣམས་ལ་ཁོས་རོགས་རམ་མང་པོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","གང་ཡིན་ཞེ་ན། ཁོས་མི་དམངས་ཀྱི་མདུན་དུ་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་ནན་གྱིས་རྩོད་པར་བྱས་ཏེ་དེ་རྣམས་བཀག་ནས། གསུང་རབ་ལས་ཡེ་ཤུ་ནི་མཱ་ཤི་ཀ་ཡིན་པར་གསལ་པོར་བསྟན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ཡང་ཨ་པོ་ལོ་སི་ཀོ་རིན་ཐུ་གྲོང་ཁྱེར་ལ་ཡོད་དུས་པའུ་ལུ་ག་ལད་ཡཱ་དང་ཕ་རུག་ཡཱ་ཡུལ་གཉིས་བརྒྱུད་ནས་ཕེབས་པ་དང༌། ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་དུ་སླེབས་ནས་ཉེ་གནས་ཁ་ཅིག་དང་ཕྲད། ");
INSERT INTO bod_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ཁོང་གིས་ཁོ་ཚོར་“དད་པར་འགྱུར་སྐབས་ཁྱེད་ཚོས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་དང་ལེན་བྱས་སམ་”ཞེས་གསུངས་པས་ལན་དུ་ཁོ་ཚོས་“བྱེད་མ་མྱོང༌། དམ་པའི་ཐུགས་ཉིད་ཡོད་པའང་ཐོས་མ་མྱོང་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ཡང་པའུ་ལུས་“བྱས་ན། ཁྲུས་གསོལ་ཅི་ལེན་”ཞེས་གསུངས་པས་ཁོ་ཚོས་“ཡོ་ཧ་ནན་གྱི་ཁྲུས་གསོལ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","པའུ་ལུས་“ཡོ་ཧ་ནན་གྱིས་མི་རྣམས་ལ་ཁོང་གི་རྗེས་སུ་ཕེབས་མཁན་ཏེ། ཡེ་ཤུ་ལ་དད་པ་བྱེད་དགོས་པར་གསུངས་ནས་སྡིག་ཉེས་སེལ་བའི་ཆེད་སྤྱོད་པ་ངན་པ་སྤངས་ནས་སེམས་བསྒྱུར་བའི་རྟགས་སུ་ཁྲུས་གསོལ་གནང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","དེ་ཐོས་ནས་ཁོ་ཚོས་གཙོ་བོ་ཡེ་ཤུའི་མཚན་གྱི་ཐོག་ནས་ཁྲུས་གསོལ་ལེན། ");
INSERT INTO bod_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","པའུ་ལུས་ཁོ་རྣམས་ཀྱི་ལུས་སྟེང་དུ་ཕྱག་བཞག་ནས་དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཁོ་ཚོར་བབས་ཤིང༌། སྐད་རིགས་གཞན་རྣམས་སྤྱད་ནས་སྐད་ཆ་བཤད་དེ་ལུང་ཡང་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","དེ་དུས་བསྡོམས་པས་ཁོ་ཚོ་མི་བཅུ་གཉིས་ཙམ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ཟླ་བ་གསུམ་གྱི་རིང་ལ་པའུ་ལུ་འདུ་ཁང་ལ་ཡང་ཡང་ཕེབས་ནས་འཇིགས་པ་མེད་པར་རྩོད་གླེང་མཛད་ཅིང་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་སྐོར་ཆོས་བསྟན་ཞིང་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ཁ་ཅིག་སེམས་མཁྲེགས་ཤིང་ཁ་ལ་མི་ཉན་པར་གྱུར་ནས་ཚོགས་པའི་མདུན་དུ་ཡེ་ཤུའི་ཐར་ལམ་ལ་ངན་སྨྲས་བྱས་པས། ཁོ་ཚོ་དང་ཁ་བྲལ་ནས་པའུ་ལུས་ཉེ་གནས་རྣམས་ཕར་འཁྲིད་དེ་ཉིན་ལྟར་ཏི་རན་ནུ་ཞེས་བྱ་བའི་སློབ་ཁང་དུ་ཆོས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ཁོང་གིས་ལོ་གཉིས་རིང་དེ་ལྟར་གནང་བས་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ལ་སྡོད་མཁན་ཏེ་ཡ་ཧུ་དཱ་པ་དང་གྷི་རིག་མི་རིགས་ཚང་མས་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་ཐོས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","དཀོན་མཆོག་གིས་པའུ་ལུའི་ཕྱག་བརྒྱུད་ནས་ཤིན་ཏུ་ངོ་མཚར་ཆེ་བའི་དོན་མཛད་པ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","དཔེར་ན་ཁོང་གིས་གཏུགས་པའི་ལག་ཕྱིས་སམ་པང་ཁེབས་ནད་པ་རྣམས་ཀྱི་རྩར་འཁྱེར་ནས་ནད་སེལ་བར་གྱུར་ཞིང༌། གདོན་འདྲེ་རྣམས་ཕྱིར་ཐོན། ");
INSERT INTO bod_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ཡ་ཧུ་དཱ་པའི་འགྲུལ་པ་གདོན་འདྲེ་སྐྲོད་མཁན་ཁ་ཅིག་གིས་གཙོ་བོ་ཡེ་ཤུའི་མཚན་བརྗོད་ནས་གདོན་འདྲེས་ཟིན་པའི་མི་རྣམས་ལ་“པའུ་ལུས་སྒྲོག་པའི་ཡེ་ཤུའི་ཐོག་ནས་ངས་ཁྱོད་ལ་བཀོད་པ་གཏོང་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","དེ་ལྟར་བྱེད་མཁན་གྱི་ནང་དུ་སི་རྐེ་བཱ་ཞེས་བྱ་བ་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་ཅིག་གི་བུ་བདུན་པོ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","གདོན་འདྲེ་དེས་“ངས་ཡེ་ཤུ་ངོ་ཤེས་ཤིང༌། པའུ་ལུའི་སྐོར་ཡང་ཤེས། འོན་ཀྱང་ཁྱོད་རྣམས་སུ་ཡིན་”ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","གདོན་འདྲེས་ཟིན་པའི་མི་དེས་ཁོ་ཚོའི་སྟེང་ལ་མཆོངས་ནས་བཅོམས་པས་ཁོ་ཚོ་རྒྱལ་ཞིང་ཁོ་ཚོ་རྨས་ནས་གཅེར་བུར་ཁང་པ་ནས་བྲོས། ");
INSERT INTO bod_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་ལ་སྡོད་མཁན་ཡ་ཧུ་དཱ་པ་དང་གྷི་རིག་པ་ཐམས་ཅད་ཀྱིས་དེའི་སྐོར་ཤེས་ནས་འཇིགས་པས་གཙོ་བོ་ཡེ་ཤུའི་མཚན་ལ་བསྟོད་པ་རེད། ");
INSERT INTO bod_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ཡང་དད་པར་གྱུར་བ་རྣམས་ལས་མང་པོ་དེར་ཡོང་སྟེ་རང་གི་ལས་ངན་བཤད་ནས་ཁས་བླངས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","སྔགས་རྒྱག་མཁན་རྣམས་ལས་མང་པོ་ཞིག་གིས་རང་གི་དཔེ་ཆ་རྣམས་གཅིག་ཏུ་བསྡུས་ནས་མི་ཚང་མའི་མདུན་དུ་བསྲེགས། དཔེ་ཆ་དེ་རྣམས་ཀྱི་རིན་ཐང་རྩི་དུས་དངུལ་གྱི་ཊམ་ཀ་ཁྲི་ལྔ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","དེ་ལྟར་གཙོ་བོ་དཀོན་མཆོག་གི་བཀའ་དར་ཞིང་རྒྱས་པར་གྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","དོན་དེ་རྣམས་བྱུང་བའི་རྗེས་སུ་པའུ་ལུས་མ་ཀེ་དོན་ཡཱ་དང་ཨ་ཀ་ཡཱ་ཡུལ་བརྒྱུད་དེ་ཡེ་རུ་ཤ་ལེམ་ལ་འགྲོ་བར་དགོངས། ཁོང་གིས་“དེར་ཕྱིན་ནས་ང་རོ་མཱ་གྲོང་ཁྱེར་དུ་ལྟ་བར་འགྲོ་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","རོགས་པ་བྱེད་མཁན་ལས་ཐི་མོ་ཐེ་དང་ཨེ་ར་སི་ཏུ་གཉིས་མ་ཀེ་དོན་ཡཱ་ཡུལ་ལ་མངགས་ནས་ཁོང་ཉིད་དུས་རེ་ཞིག་གི་བར་དུ་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་དུ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","དུས་དེ་ཙམ་ལ་ཡེ་ཤུའི་ཐར་ལམ་གྱི་སྐོར་ལ་འཁྲུག་རྩོད་ཆེན་པོ་ཞིག་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","དེ་མེ་ཏྲི་ཡུ་ཞེས་ཟེར་བའི་དངུལ་བཟོ་བ་ཞིག་གིས་ལྷ་མོ་ཨར་ཏེ་མཱི་ཡི་ལྷ་ཁང་དཔེར་བྱས་ནས་དངུལ་སྒམ་བཟོས་པས་བཟོ་པ་རྣམས་ལ་ཁེ་ཕན་ཆེན་པོ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ཁོ་ཚོ་དང་ལག་རྩལ་བཟོ་པ་གཞན་རྣམས་བསྡུས་ནས་ཁོས་“ལས་གྲོགས་རྣམས། ཉོ་ཚོང་འདིས་ངེད་རྣམས་ལ་ནོར་ཐོབ་པ་ཁྱེད་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་ཙམ་མ་ཟད་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ཕལ་ཆེར་དུ་པའུ་ལུ་ཟེར་མཁན་འདིས་མིའི་ལག་པས་བཟོས་པ་དེ་ལྷ་མ་ཡིན་ཟེར་ནས། མི་མང་པོ་སེམས་བསྒྱུར་ཞིང་བསླུ་བྲིད་བྱས་པ་ཁྱེད་ཚོས་མཐོང་ཞིང་ཐོས། ");
INSERT INTO bod_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ང་ཚོའི་ཉོ་ཚོང་གི་སྙན་གྲགས་ཉམས་ཉེས་སུ་འགྲོ་བའི་ཉེན་ཁ་ཡོད་པ་མ་ཟད། ལྷ་མོ་ཆེན་མོ་ཨར་ཏེ་མཱི་ཡི་ལྷ་ཁང་བརྩི་མེད་དུ་འགྱུར་ཞིང༌། ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་དང་འཇིག་རྟེན་གྱི་མི་ཐམས་ཅད་ཀྱིས་བསྙེན་བཀུར་བྱེད་པའི་ལྷ་མོ་ཉིད་ཀྱི་གཟི་བརྗིད་ཉམས་པར་འགྱུར་བའི་ཉེན་ཁའང་ཡོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","མི་རྣམས་ཀྱིས་དེ་ཐོས་ཏེ་ཁོང་ཁྲོ་འབར་ནས་སྐད་ཆེན་པོས་“ཨེ་ཕེ་སུ་པའི་ལྷ་མོ་ཨར་ཏེ་མཱི་ཆེའོ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","གྲོང་ཁྱེར་ཡོངས་སུ་ཟིང་ཆ་ལངས་ཤིང༌། མི་ཚོགས་ཀྱིས་པའུ་ལུའི་ལམ་གྲོགས་ཡིན་པའི་མ་ཀེ་དོན་ཡཱ་ཡུལ་གྱི་ག་ཡུ་དང་ཨ་རིས་ཐར་ཀུ་གཉིས་བཙན་ཁྲིད་བྱས་ཏེ་ཁོ་ཚོ་ལྷན་ཅིག་ཏུ་འཁྲབ་སར་བརྒྱུགས། ");
INSERT INTO bod_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","པའུ་ལུ་མི་ཚོགས་ཀྱི་མདུན་དུ་ཕེབས་པར་འདོད་ཀྱང༌། ཉེ་གནས་རྣམས་ཀྱིས་ཁོང་ཕེབས་སུ་མ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ཡང་པའུ་ལུའི་གྲོགས་པོ་ཡིན་པའི་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་གྱི་དཔོན་རིགས་ཁ་ཅིག་གིས་ཁོང་ལ་འཁྲབ་སར་མ་ཕེབས་ཞེས་པའི་ལན་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","དེའི་དུས་སུ་ཚོགས་པ་ཟང་ཟིང་དུ་གྱུར་བས། ལ་ལས་སྐད་ཆེན་པོས་གཅིག་སྨྲས། ལ་ལས་གཞན་སྨྲས། མི་མང་ཆེ་བས་དེར་འདུས་པའི་རྒྱུ་མཚན་ཡང་མ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཨ་ལིག་ཟན་ཌེར་མི་ཚོགས་ཀྱི་མདུན་དུ་བཞག་ནས། མི་ཚོགས་ལས་ཁ་ཅིག་གིས་ཁོ་ལ་གཏམ་བཤད་པས། ཁོས་ལག་བརྡ་བྱས་ནས་མི་ཚོགས་ལ་དོན་དེའི་སྐོར་གསལ་བཤད་བྱེད་པར་བསམས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ཁོ་ཡ་ཧུ་དཱ་པ་ཡིན་པར་ཤེས་ནས་ཁོ་ཚོས་ཆུ་ཚོད་གཉིས་ཙམ་ལྷན་ཅིག་ཏུ་སྐད་ཆེན་པོས་“ཨེ་ཕེ་སུ་པའི་ཨར་ཏེ་མཱི་ཆེའོ་”ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","གྲོང་ཁྱེར་གྱི་དྲུང་ཡིག་གིས་མི་ཚོགས་ཁ་ཁུ་སིམ་པོར་སྡོད་དུ་བཅུག་ནས་“ཁྱེད་ཨེ་ཕེ་སུ་པ་རྣམས། ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་གྱི་མི་རྣམས་ནི་ལྷ་མོ་ཆེན་མོ་ཨར་ཏེ་མཱི་ཡི་ལྷ་ཁང་དང༌། ནམ་མཁའ་ནས་བབས་པའི་དེ་ཡི་སྐུ་རྟེན་སྲུང་མཁན་ཡིན་པར་སུས་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","དོན་དེར་རྩོད་རྒྱུ་མེད་པས་ཁྱེད་ཚོ་ཞི་བར་སྡོད་ཅིང༌། རྗེས་འབྲས་ལ་མི་ལྟ་བའི་ལས་མ་བྱོས། ");
INSERT INTO bod_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","གང་ཡིན་ཞེ་ན། ཁྱེད་རྣམས་ཀྱིས་འདིར་བཙན་འཁྲིད་བྱས་པའི་མི་རྣམས་ཀྱིས་ལྷ་ཁང་ནས་ཅི་ཡང་མ་ཕྲོགས། ང་ཚོའི་ལྷ་མོ་ལ་དམའ་འབེབས་ཡང་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","གལ་ཏེ་དེ་མེ་ཏྲི་ཡུ་ལ་སོགས་པའི་ལག་རྩལ་བཟོ་པ་རྣམས་ཀྱིས་མི་སུ་ཞིག་ལ་ནག་ཉེས་འཛུགས་པར་འདོད་ན། ཁྲིམས་ཁང་སྒོ་ཕྱེ་ཡོད་དེ་སྤྱི་ཁྱབ་ཀྱང་ཡོད་པས། དེར་གཅིག་གིས་གཅིག་ལ་གཏུག་རེས་བྱས་ན་འགྲིག ");
INSERT INTO bod_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","དེ་ལས་ལྷག་པར་འདོད་ན་ཁྲིམས་བཞིན་དུ་འདུས་པའི་ཚོགས་པར་ཐག་གཅོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","གང་ལགས་ཤེ་ན། དེ་རིང་འཁྲུག་པའི་རྒྱུ་མཚན་གང་ཡིན་པ་གསལ་བཤད་བྱེད་མི་ཐུབ་པས། ང་ཚོར་ཟིང་ཆ་སློང་བའི་ནག་ཉེས་འཛུགས་ཉེན་ཡོད་”ཅེས་སྨྲས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ཁོས་མི་ཚོགས་ཕར་བཏང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","འཁྲུག་པ་དེ་ཞི་བར་གྱུར་བའི་རྗེས་སུ་པའུ་ལུས་ཉེ་གནས་རྣམས་བོས་ཏེ་བསྐུལ་བར་མཛད་ཅིང༌། གྱེས་མཚམས་ཞུས་ནས་མ་ཀེ་དོན་ཡཱ་ཡུལ་དུ་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","དད་ལྡན་རྣམས་ལ་སྐུལ་མ་མང་པོ་གནང་སྟེ་ཡུལ་དེ་རྣམས་བརྒྱུད་ནས་ཕེབས་ཤིང༌། དེའི་རྗེས་སུ་ཁོང་གྷི་རིག་ཡུལ་དུ་སླེབས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ཟླ་བ་གསུམ་དེར་བཞུགས། ཁོང་གྲུ་གཟིངས་ལ་བསྡད་ནས་སི་རི་ཡཱ་ཡུལ་ལ་ཕེབས་གྲབས་ཡོད་པའི་སྐབས་སུ། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཁོང་གསོད་པའི་ཇུས་ངན་བརྩམས་པས་ཁོང་གིས་མ་ཀེ་དོན་ཡཱ་ཡུལ་བརྒྱུད་ནས་ཕྱིར་ཕེབས་རྒྱུར་ཐག་བཅད་དོ། ");
INSERT INTO bod_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ཁོང་དང་མཉམ་དུ་འགྲོ་མཁན་ནི་པིར་རུ་ཡི་བུ་པུ་རེ་ཡཱ་ནས་ཡིན་པའི་སཱོ་པ་ཏེར་དང༌། ཐེ་ས་ལོ་ནི་ཀེ་ནས་ཡིན་པའི་ཨ་རིས་ཐར་ཀུ་དང་སེ་ཀུན་ཊུ་གཉིས། ཌེར་པེ་ནས་ཡིན་པའི་ག་ཡུ། ཐི་མོ་ཐེ། ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ནས་ཡིན་པ་ཏི་ཀི་ཀུ་དང་ཏྲོ་ཕེ་མུ་བཅས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ཁོ་ཚོ་ཚང་མ་སྔོན་དུ་ཕྱིན་ནས་ང་ཚོ་མ་སླེབས་པའི་བར་དུ་ཏྲོ་ཡཱ་གྲོང་ཁྱེར་དུ་བསྒུགས། ");
INSERT INTO bod_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","སྐྱུར་རྩི་མེད་པའི་བག་ལེབ་དུས་ཆེན་གྱི་རྗེས་སུ་ང་ཚོ་ཕི་ལིབ་པཱི་གྲོང་ཁྱེར་ནས་གྲུ་གཟིངས་ལ་ཉི་མ་ལྔ་བསྡད་རྗེས་ཏྲོ་ཡཱ་ལ་ཁོ་ཚོ་དང་ཐུག་ཅིང༌། ཉི་མ་བདུན་དེར་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","བདུན་ཕྲག་གི་ཉིན་དང་པོར་ང་ཚོ་བག་ལེབ་བགོ་བཤའ་རྒྱག་པར་འཛོམས་པའི་ཚེ། པའུ་ལུས་དེའི་སང་ཉིན་ཕར་ཕེབས་པར་དགོངས་པས་ནམ་ཕྱེད་བར་དུ་ཆོས་བསྟན་ཏེ་བཞུགས། ");
INSERT INTO bod_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ང་ཚོ་ལྷན་དུ་འཛོམས་པའི་ཐོག་ཁང་ལ་མར་མེ་མང་པོ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ཡང་སྒེའུ་ཁུང་གི་འཁྲིས་སུ་བསྡད་པའི་ཡུ་ཏི་ཀུ་ཞེས་ཟེར་བའི་གཞོན་ནུ་ཞིག་ཡོད་དེ། པའུ་ལུས་ཡུན་རིང་པོར་ཆོས་བསྟན་དུས་ཁོ་གཉིད་ལྗིད་པོ་ཁུགས་པས་ཐོག་ས་གསུམ་པ་ནས་སར་ལྷུངས་པ་དང༌། མི་གཞན་གྱིས་འཁྱེར་དུས་ཤི་ཟིན་ཡོད་དོ། ");
INSERT INTO bod_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","པའུ་ལུ་མར་ཕེབས་ནས་རོའི་སྟེང་ལ་བཀབ་ནས་འཐམས། ཁོང་གིས་“གསོན་པོར་འདུག་པས་དངངས་སྐྲག་མ་བྱེད་ཅིག་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ཐོག་ཁང་དུ་ཕྱིར་ཕེབས་ནས་ཁོང་གིས་གཙོ་བོའི་དྲན་རྟེན་གྱི་ཞལ་ཟས་སྤྱོད་པ་དང་ཁ་ལག་བཟས་ཤིང༌། ནམ་ལངས་པའི་བར་དུ་ཁོ་ཚོ་དང་གསུང་གླེང་མང་པོ་མཛད་ནས་ཕར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","གསོན་པོའི་གཞོན་ནུ་དེ་ནང་ལ་འཁྲིད་པས་ཁོ་ཚོ་སེམས་ཤིན་ཏུ་གསོ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","པའུ་ལུའི་བཀོད་སྒྲིག་ལྟར་ང་ཚོ་སྔོན་དུ་ཕྱིན་ནས་ཨ་སཱོ་ཞེས་པའི་གྲོང་ཁྱེར་བར་དུ་གྲུ་གཟིངས་ལ་བསྡད་དེ་དེར་པའུ་ལུ་དང་ཕྲད་ནས་ང་ཚོ་ཚང་མ་གྲུ་གཟིངས་ལ་བཞུགས་ནས་ཕར་འགྲོ་བར་བསམས། པའུ་ལུ་ཉིད་ཞབས་ཐང་ལ་ཕེབས་རྩིས་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ཨ་སཱོ་ལ་ཁོང་ང་ཚོ་དང་མཇལ་ནས་གྲུ་གཟིངས་ལ་བསུས་ཏེ་མཉམ་དུ་མི་ཏི་ལེ་ནེ་གྲོང་ཁྱེར་དུ་སླེབས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ས་ཆ་དེ་ནས་ཡང་བསྐྱར་གྲུ་གཟིངས་ལ་བསྡད་དེ་ཕྱི་ཉིན་ལ་ཀི་ཨོ་སི་ཞེས་པའི་གླིང་ཕྲན་གྱི་ཕྱོགས་སུ་སླེབས། དེའི་སང་ཉིན་སཱ་མོ་སི་ཞེས་པའི་གླིང་ཕྲན་དུ་ཡོང་བ་དང༌། དེའི་ཕྱི་ཉིན་མི་ལེ་ཏུ་ཞེས་ཟེར་བའི་གྲུ་ཁར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","གང་ཡིན་ཞེ་ན། པའུ་ལུས་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ལ་དུས་འགྱངས་མ་བྱེད་པའི་ཆེད་དུ་ཨེ་ཕེ་སུ་གྲོང་ཁྱེར་ལ་མི་འགྲོ་བར་ཐག་གཅོད་བྱས། དེ་ནི་མྱུར་བར་བསྐྱོད་ནས་ཉི་མ་ལྔ་བཅུ་པའི་དུས་ཆེན་གྱི་ཉིན་མོར་ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ན་སྙམ་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","མི་ལེ་ཏུ་ནས་པའུ་ལུས་ཨེ་ཕེ་སུའི་ཆོས་ཚོགས་ཀྱི་འགན་འཁུར་བ་རྣམས་རང་གི་མདུན་དུ་བོས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ཁོང་གི་མདུན་དུ་སླེབས་ནས་ཁོང་གིས་ཁོ་རྣམས་ལ་“ང་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་དུ་སླེབས་པའི་ཉིན་དང་པོ་ནས་བཟུང་ཁྱེད་ཚོའི་ཁྲོད་དུ་ངའི་སྤྱོད་ལམ་ཇི་ལྟར་ཡིན་པ་ཁྱེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ཆེས་ཉམ་ཆུང་དང་མིག་ནས་མཆི་མ་ལྷུངས་ཤིང་ངས་གཙོ་བོ་ལ་ཞབས་ཏོག་བསྒྲུབས། ཡ་ཧུ་དཱ་པའི་ཇུས་ངན་ལས་བྱུང་བའི་ཉམས་ཚོད་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ཁྱེད་རྣམས་ལ་ཕན་པའི་དོན་གང་ཡོད་སྒྲོག་པར་མ་འཛེམ་པར་ངས་མི་ཚོགས་ཀྱི་མདུན་དང་ཁང་པ་རེ་རེར་ཆོས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ངས་ཡ་ཧུ་དཱ་པ་དང་གྷི་རིག་པ་གཉིས་ལ་སྤྱོད་པ་ངན་པ་སྤངས་ནས་དཀོན་མཆོག་གི་ཕྱོགས་སུ་སེམས་བསྒྱུར་ཏེ་ང་ཚོའི་གཙོ་བོ་ཡེ་ཤུ་ལ་དད་པ་བྱེད་དགོས་པར་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ད་ལྟ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་བསྐུལ་ནས་ཡེ་རུ་ཤ་ལེམ་ལ་འགྲོ་བཞིན་ཡོད། དེར་ང་ལ་གང་འབྱུང་བ་མི་ཤེས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","གྲོང་ཁྱེར་རེར་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ང་ལ་བཙོན་དང་སྡུག་བསྔལ་མྱོང་བར་འགྱུར་ཞེས་བདེན་དཔང་མཛད་པ་དེ་འབའ་ཞིག་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","འོན་ཀྱང་ངས་རང་གི་བགྲོད་ལམ་མཇུག་རྫོགས་དགོས་ཏེ་གཙོ་བོ་ཡེ་ཤུ་ལས་ཐོབ་པའི་དཀོན་མཆོག་གི་ཐུགས་རྗེའི་འཕྲིན་བཟང་ལ་བདེན་དཔང་བྱེད་པའི་ཞབས་ཏོག་དང་ལས་དོན་བསྒྲུབས་ན། ངས་རང་སྲོག་གཅེས་པར་མི་རྩི། ");
INSERT INTO bod_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ཁྱེད་ཚོའི་ཁྲོད་དུ་ཕར་འགྲོ་ཚུར་འོངས་ཀྱིས་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་འཕྲིན་བཟང་སྒྲོག་སྟེ། ད་ནས་བཟུང་ཁྱེད་ཚོ་ཚང་མས་ངའི་གདོང་མཐོང་བར་མི་འགྱུར་བ་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","དེའི་ཕྱིར་ཁྱེད་ཚོའི་ནང་ནས་སུ་ཞིག་གཙོ་བོ་ཡེ་ཤུ་ལ་དད་པ་མི་བྱེད་པར་ཤི་ན། ང་ལ་འགན་མེད་པ་ཡིན་པར་དེ་རིང་ཁྱེད་ཚོར་དཔང་པོ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","གང་ལགས་ཤེ་ན། ངས་ཁྱེད་རྣམས་ལ་དཀོན་མཆོག་གི་དགོངས་པ་ཆ་ཚང་སྒྲོག་པར་མ་འཛེམས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཁྱེད་ཚོ་ཆོས་ཚོགས་ཀྱི་དོ་དམ་པར་བསྒྱུར་བས་ཁྱེད་ཚོ་རང་ཉིད་དང་ཆོས་ཚོགས་ཀྱི་མི་ཐམས་ཅད་སྲུངས། དེ་ནི་དཀོན་མཆོག་གིས་སྲས་ཀྱི་སྐུ་ཁྲག་བླུ་རིན་གྱིས་ཐོབ་པའི་ཆོས་ཚོགས་ལ་ཁྱེད་ཚོས་ལུག་རྫི་ལྟར་བདག་སྐྱོང་བྱེད་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ང་ཕར་ཕྱིན་པའི་རྗེས་སུ་སྤྱང་ཀི་གདུག་པ་དང་འདྲ་བའི་མི་རྣམས་ལུག་ཁྱུ་དང་འདྲ་བའི་ཁྱེད་ཚོའི་དཀྱིལ་ལ་ཡོང་ནས་དད་ལྡན་རྣམས་ལ་གནོད་པ་བྱེད་པ་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ཁྱེད་ཚོའི་ཚོགས་པའི་ནང་ནས་ཀྱང་ཁ་ཅིག་གིས་དད་ལྡན་རྣམས་རང་གི་ཉེ་གནས་སུ་འཇུག་པའི་ཕྱིར་ལོག་ལྟ་སྟོན་པར་ངེས། ");
INSERT INTO bod_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","དེར་བརྟེན་དོགས་ཟོན་གྱིས་ཤིག ལོ་གསུམ་རིང་ངས་ཉིན་མཚན་མེད་པར་མིག་ཆུ་དང་བཅས་པར་མི་རེ་རེར་ཁ་ཏ་བྱས་པ་དེ་ཡིད་ལ་འཇོག་ཅིག ");
INSERT INTO bod_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ད་ངས་དཀོན་མཆོག་དང་ཁོང་གི་ཐུགས་རྗེའི་བཀའ་ལ་ཁྱེད་རྣམས་འཆོལ། བཀའ་དེས་ཁྱེད་ཚོར་བློ་སྒོ་འབྱེད་ཅིང་དམ་པ་རུ་འགྱུར་བ་ཐམས་ཅད་དང་མཉམ་དུ་དཀོན་མཆོག་གིས་ཞལ་ཆད་གནང་བའི་བྱིན་རླབས་ཀྱི་བགོ་སྐལ་གནང་ཐུབ་བོ། ");
INSERT INTO bod_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ངས་མི་སུ་གང་གི་དངུལ་ལམ། གསེར་རམ། གྱོན་གོས་བཅས་ལ་ཧམ་སེམས་བཅངས་མེད། ");
INSERT INTO bod_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ངས་རང་གི་ལག་པ་གཉིས་ལ་བརྟེན་ནས་ང་དང་ངའི་ལས་རོགས་ཀྱི་དགོས་མཁོ་བསྒྲུབས་པ་ཁྱེད་ཉིད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","གཙོ་བོ་ཡེ་ཤུ་ཉིད་ཀྱིས་ཐོབ་པ་ལས་སྦྱིན་པ་བདེ་བ་ཆེའོ་ཞེས་གསུངས་པར་དྲན་ཏེ། དེ་བཞིན་དུ་ངལ་རྩོལ་བྱེད་པའི་སྒོ་ནས་ངས་ཐབས་ཀུན་གྱིས་ཁྱེད་ཚོར་སྐྱོ་པོ་རྣམས་ལ་རོགས་པ་བྱེད་དགོས་པའི་མིག་དཔེ་ཞིག་བསྟན་ཡོད་”ཅེས་གསུངས་པའི་རྗེས་སུ། ");
INSERT INTO bod_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","པུས་མོ་སར་བཙུགས་ཏེ་ཁོང་གིས་ཁོ་ཚོ་ཐམས་ཅད་དང་མཉམ་དུ་སྨོན་ལམ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ཤུགས་ཆེན་པོར་ངུས་ཏེ་ཁོ་ཚོ་ཐམས་ཅད་ཀྱིས་པའུ་ལུ་ལ་འཐམས་ནས་འགྲམ་པར་འོ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ཁོང་གིས་ད་ནས་བཟུང་ངའི་གདོང་རྩ་བ་ནས་མཐོང་བར་མི་འགྱུར་ཞེས་གསུངས་པས་ཁོ་ཚོའི་སེམས་ཧ་ཅང་སྐྱོ་བར་གྱུར། དེ་ནས་ཁོ་ཚོས་པའུ་ལུ་གྲུ་གཟིངས་ལ་བསྐྱལ་ལོ། ། ");
INSERT INTO bod_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ཁོ་རྣམས་དང་ཁ་བྲལ་ཏེ་གྲུ་གཟིངས་ལ་བསྡད་ནས་ང་ཚོ་ཀོ་ཟི་ཞེས་པའི་གླིང་ཕྲན་དུ་ཐད་ཀར་ཕྱིན་ཞིང༌། དེའི་སང་ཉིན་རོའོ་ཏི་ཞེས་ཟེར་བའི་གླིང་ཕྲན་དང༌། ས་ཆ་དེ་ནས་པ་ཏ་རཱ་གྲུ་ཁར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","དེར་ཕེ་ནི་ཀེ་ཡུལ་ལ་འགྲོ་བའི་གྲུ་གཟིངས་ཤིག་དང་ཕྲད་ནས་དེ་ལ་འཛུལ་ནས་ང་ཚོ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ཀིབ་རུ་གླིང་ཕྲན་མཐོང་ནས་དེ་གཡོན་ཕྱོགས་སུ་བཞག་སྟེ་སི་རི་ཡཱ་ཡུལ་ལ་གྲུ་གཟིངས་ཀྱི་དོས་པོ་འདོན་སའི་གྲུ་ཁ་ཐཱ་ཨེར་དུ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","དད་ལྡན་རྣམས་བཙལ་ནས་རྙེད་ཅིང་ང་ཚོ་དེར་ཉི་མ་བདུན་གྱི་བར་དུ་བསྡད། ཁོ་རྣམས་ཀྱིས་དམ་པའི་ཐུགས་ཉིད་ཀྱི་ངང་ནས་པའུ་ལུ་ལ་ཡེ་རུ་ཤ་ལེམ་ལ་མ་ཕེབས་ཞེས་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","དེར་ང་ཚོ་བསྡད་ཐུབ་པའི་དུས་ཚོད་རྫོགས་ནས་ང་ཚོ་ལམ་ལ་ཆས་པ་ལ། དད་ལྡན་ཐམས་ཅད་ཀྱིས་བཟའ་ཟླ་དང་ཕྲུ་གུ་དང་བཅས་པར་ང་ཚོ་གྲོང་ཁྱེར་གྱི་ཕྱི་ཕྱོགས་སུ་བསྐྱལ། ངེད་རྣམས་ཀྱིས་རྒྱ་མཚོའི་འགྲམ་ལ་པུས་མོ་སར་བཙུགས་ཏེ་སྨོན་ལམ་བཏབ། ");
INSERT INTO bod_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ཕན་ཚུན་གྱེས་མཚམས་ཞུས་ནས་ངེད་རྣམས་གྲུ་གཟིངས་ལ་བསྡད་པ་དང༌། ཁོ་རྣམས་སོ་སོའི་ཁྱིམ་དུ་ཕྱིར་ལོག ");
INSERT INTO bod_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ཐཱ་ཨེར་ནས་མཚོ་ལམ་བརྒྱུད་དེ་ཕེ་ཏོ་ལེ་མཱ་ཞེས་པའི་གྲུ་ཁར་སླེབས། སྤུན་ཟླ་རྣམས་ལ་འཚམས་འདྲི་ཞུས་ནས་ཉི་མ་གཅིག་ཁོ་ཚོ་དང་མཉམ་དུ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","དེའི་ཕྱི་ཉིན་ལ་ཕར་ཕྱིན་ཏེ་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་སླེབས་པ་དང༌། འཕྲིན་བཟང་སྒྲོག་མཁན་ཕི་ལིབ་ཀྱི་ཁྱིམ་དུ་སོང་ནས་ཁོ་དང་མཉམ་དུ་བསྡད། ཕི་ལིབ་ནི་བདུན་པོའི་ནང་ནས་གཅིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ཁོ་ལ་ཆང་ས་རྒྱག་མ་མྱོང་བའི་བུ་མོ་བཞི་ཡོད་པ་ཚང་མ་ལུང་སྟོན་མཁན་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","དེར་ཉིན་ཁ་ཤས་སྡོད་དུས་ཨ་ག་བཱུ་ཞེས་ཟེར་བའི་ལུང་སྟོན་པ་ཞིག་ཡ་ཧུ་དཱ་ཡུལ་ནས་སླེབས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ངེད་རྣམས་ཀྱི་རྩར་ཡོང་སྟེ། པའུ་ལུའི་སྐེ་རགས་བླངས་ནས་རང་གི་རྐང་ལག་བཅིངས་ཏེ་ཁོང་གིས་“དམ་པའི་ཐུགས་ཉིད་ཀྱིས་འདི་སྐད་དུ། ཡེ་རུ་ཤ་ལེམ་གྱི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་སྐེ་རགས་འདིའི་བདག་པོ་འདི་ལྟར་བཅིངས་ནས་ཡ་ཧུ་དཱ་པ་མིན་པའི་ལག་ཏུ་གཏད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","དེ་ཐོས་ནས་ང་ཚོ་དང་ཡུལ་དེའི་མི་རྣམས་ཀྱིས་པའུ་ལུ་ལ་ཡེ་རུ་ཤ་ལེམ་ལ་མ་ཕེབས་པར་ནན་གྱིས་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ལན་དུ་པའུ་ལུས་“ཁྱོད་རྣམས་ངུ་ནས་ངའི་སྙིང་གས་པར་བྱེད་པ་འདི་ཅི་ཡིན། ང་ནི་གཙོ་བོ་ཡེ་ཤུའི་མཚན་གྱི་ཕྱིར་འཆིང་བར་འགྱུར་བ་མ་ཟད། ཡེ་རུ་ཤ་ལེམ་ལ་ཤི་རྒྱུར་ཡང་གྲ་སྒྲིག་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ཁོང་གི་ཐུགས་བསྒྱུར་མི་ཐུབ་པས་ང་ཚོས་“གཙོ་བོ་དཀོན་མཆོག་གི་དགོངས་པ་འགྲུབ་པར་ཤོག་”ཅེས་སྨྲས་པ་དང་ཁ་རོག་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","དེའི་རྗེས་སུ་ལམ་ཆས་གྲ་སྒྲིག་བྱས་ནས་ང་ཚོ་ཡེ་རུ་ཤ་ལེམ་དུ་སོང༌། ");
INSERT INTO bod_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་གྱི་ཉེ་གནས་ལས་ཁ་ཅིག་ངེད་རྣམས་དང་མཉམ་དུ་ཕྱིན་ཏེ། ཁོ་ཚོས་ཀིབ་རུ་གླིང་ཕྲན་གྱི་མི་སྔ་མོ་ནས་ཉེ་གནས་ཡིན་པ་ནཱ་ཟོན་གྱི་ཁྱིམ་དུ་སྡོད་པའི་ཕྱིར་ངེད་རྣམས་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ནས་དེར་ཡོད་པའི་སྤུན་ཟླ་རྣམས་ཀྱིས་ང་ཚོ་དགའ་བའི་ངང་ནས་བསུས། ");
INSERT INTO bod_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","དེའི་སང་ཉིན་ཡ་ཀོབ་མཇལ་བར་པའུ་ལུ་ང་ཚོ་དང་མཉམ་དུ་ཕེབས་ཤིང༌། འགན་འཁུར་བ་ཐམས་ཅད་ཀྱང་དེར་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","པའུ་ལུས་ཁོ་ཚོར་འཚམས་འདྲི་ཞུས་ནས། དཀོན་མཆོག་གིས་ཁོང་གི་ལས་ཀ་བརྒྱུད་དེ་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་ནང་ལ་གང་མཛད་པ་རེ་རེ་བཞིན་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","དེ་ཐོས་ནས་ཁོ་ཚོས་དཀོན་མཆོག་ལ་བསྟོད་པ་ཕུལ་བ་དང༌། པའུ་ལུ་ལ་“སྤུན་ཟླ་ལགས། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱི་ཁྲོད་དུ་མི་སྟོང་ཕྲག་མང་པོ་དད་ལྡན་པར་གྱུར་བ་ཁྱེད་ཀྱིས་གཟིགས། ཁོ་ཚོ་ཐམས་ཅད་ཀྱིས་བརྩོན་སེམས་ཆེན་པོས་ཆོས་ཁྲིམས་སྲུང་གི་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ཡང་ཡ་ཧུ་དཱ་པ་མིན་པའི་ཁྲོད་དུ་སྡོད་པའི་ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་ལ་ཁྱེད་ཀྱིས་མོ་ཤེའི་ཆོས་ཁྲིམས་སྤོང་བར་བསྐུལ་ཏེ་ཁོ་ཚོའི་བུ་རྣམས་ལ་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མི་རྒྱག་ཅིང༌། ཆོས་ཀྱི་ལུགས་སྲོལ་མི་སྲུང་བར་སྟོན་ཞེས་པའི་གཏམ་འཆལ་ཁོ་ཚོས་ཐོས། ");
INSERT INTO bod_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","བྱས་ན། ཁྱེད་འདིར་ཕེབས་པ་ཁོ་ཚོས་ཐོས་པར་འགྱུར་ངེས་ཡིན། ང་ཚོས་ཅི་བྱ། ");
INSERT INTO bod_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ང་ཚོས་སྨྲ་བ་ལྟར་མཛོད་ཅིག ང་ཚོའི་ནང་ན་དམ་བཅའ་པ་བཞི་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ཁོ་ཚོ་དང་མཉམ་དུ་ཆོས་ཀྱི་གཙང་སྦྲ་བྱེད་པའི་ཆོ་ག་བྱོས་དང༌། ཁོ་ཚོའི་སྐྲ་འབྲེག་པའི་ཕྱིར་ཁོ་ཚོར་འགྲོ་སོང་ཕུལ་ཅིག དེ་ནས་མི་རྣམས་ཀྱིས་ཁྱེད་ཀྱི་སྐོར་ལ་ཐོས་པའི་གཏམ་མི་བདེན་པ་ཡིན་ཞིང༌། ཁྱེད་ཉིད་ཀྱིས་ཆོས་ཁྲིམས་སྲུང་བ་མི་ཐམས་ཅད་ཀྱིས་ཤེས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ཡང་དད་པར་གྱུར་བའི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་སྐོར་ང་ཚོས་ཐག་གཅོད་བྱས་ཏེ། ཁོ་ཚོས་ལྷ་སྐུ་ལ་ཕུལ་བའི་ཤ ཁྲག སྐེ་བཙིར་ནས་གསོད་པའི་དུད་འགྲོའི་ཤ ལོག་གཡེམ་བཅས་ལ་འཛེམ་དགོས་ཞེས་པའི་ཡི་གེ་ཞིག་བཏང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","དེའི་སང་ཉིན་མི་དེ་ཚོ་བཞི་འཁྲིད་དེ་པའུ་ལུས་ཁོ་ཚོ་དང་བཅས་པར་གཙང་སྦྲ་བྱེད་པའི་ཆོ་ག་མཛད། དེ་ནས་ཁོང་ཚོ་རེ་རེའི་ཆེད་དུ་མཆོད་པ་ཕུལ་བའི་ཉི་མ་དང༌། གཙང་སྦྲ་འགྲུབ་པའི་དུས་ཡ་ཧུ་དཱ་པའི་བླ་མར་སྨྲ་བའི་ཕྱིར་མཆོད་ཁང་ཆེན་མོར་ཕེབས། ");
INSERT INTO bod_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","གཙང་སྦྲ་བྱེད་པའི་ཉིན་བདུན་པོ་རྫོགས་ལ་ཉེ་བའི་སྐབས་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ནས་ཡིན་པའི་ཡ་ཧུ་དཱ་པ་ཁ་ཅིག་གིས་མཆོད་ཁང་ལ་པའུ་ལུ་མཐོང་ནས། མི་ཚོགས་ཀུན་ལ་ངན་བསྐུལ་བྱས་ཏེ་ཁོང་འཛིན་བཟུང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ཁོ་ཚོས་སྐད་ཆེན་པོས་“ཡི་སི་ར་ཨེལ་པ་རྣམས་ང་ཚོར་རོགས་རམ་བྱོས་ཤིག མི་འདི་ནི་ཡུལ་ཀུན་ཏུ་མི་ཐམས་ཅད་ལ་ངེད་རྣམས་ཀྱི་མི་རིགས་དང༌། ཆོས་ཁྲིམས། གནས་འདི་བཅས་ལ་ངོ་རྒོལ་བྱེད་མཁན་ཡིན། དེས་མ་ཚད་གྷི་རིག་པ་རྣམས་ཀྱང་མཆོད་ཁང་གི་ནང་དུ་འཁྲིད་པས་ཁོས་གནས་མཆོག་འདི་མི་གཙང་བར་བྱས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(གང་ཡིན་ཞེ་ན། སྔར་ཁོ་ཚོས་གྲོང་ཁྱེར་ལ་ཡུལ་ཨེ་ཕེ་སུ་ནས་ཡིན་པའི་ཏྲོ་ཕེ་མུ་ཁོང་དང་འགྲོགས་པར་མཐོང་ཡོད་པས། པའུ་ལུས་ཁོ་མཆོད་ཁང་ཆེན་མོའི་ནང་དུ་འཁྲིད་པ་ཡིན་པར་སྙམ་) ");
INSERT INTO bod_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","གྲོང་ཁྱེར་གྱི་མི་ཚང་མ་འཁྲུགས་པར་གྱུར་ནས། ཁོ་རྣམས་དེར་ལྷན་ཅིག་ཏུ་བརྒྱུགས་ཏེ་པའུ་ལུ་བཟུང༌། ཁོང་མཆོད་ཁང་གི་ར་བ་ནས་ཕྱི་རོལ་ཏུ་བཙན་ཁྲིད་བྱས་མ་ཐག་ལམ་སེང་རྒྱལ་སྒོ་བརྒྱབ། ");
INSERT INTO bod_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ཁོང་གསོད་ཐབས་བྱེད་དུས་རོ་མཱ་དམག་མིའི་སྟོང་དཔོན་གྱིས་ཡེ་རུ་ཤ་ལེམ་ཡོངས་སུ་ཟིང་ཆ་ལངས་ཞེས་ཟེར་བའི་གཏམ་ཐོས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","མྱུར་དུ་བརྒྱ་དཔོན་དང་དམག་མི་འཁྲིད་དེ་ཁོ་ཚོའི་རྩར་བརྒྱུགས། མི་ཚོགས་ཀྱིས་སྟོང་དཔོན་དང་དམག་མི་རྣམས་མཐོང་ནས་པའུ་ལུ་ལ་རྡུང་བ་མཚམས་བཞག ");
INSERT INTO bod_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","སྟོང་དཔོན་ཡོང་སྟེ་པའུ་ལུ་འཛིན་བཟུང་བྱས་པ་དང༌། ལྕགས་ཐག་གཉིས་ཀྱིས་འཆིང་བའི་བཀའ་བསྒོས་ནས་ཁོང་སུ་ཡིན་དང་ཅི་ཞིག་བྱས་པའི་སྐད་ཆ་དྲིས། ");
INSERT INTO bod_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","མི་ཚོགས་ཀྱི་ཁྲོད་དུ་ལ་ལས་སྐད་ཆེན་པོས་གཅིག་སྨྲས། ལ་ལས་གཞན་སྨྲས་པས། སྐད་ཅོར་གྱི་རྐྱེན་པས་གནས་ཚུལ་ངེས་པར་ཤེས་མ་ཐུབ་པས་ཁོས་པའུ་ལུ་མཁར་རྫོང་ལ་འཁྲིད་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","མཁར་རྫོང་གི་རྡོ་སྐས་ཀྱི་བར་དུ་སླེབས་ནས་མི་ངན་འཛོམས་ཏེ་དྲག་སྤྱོད་ཆེན་པོར་གྱུར་བས་དམག་མི་རྣམས་ཀྱིས་ཁོང་ཡར་བཏེགས་ནས་འཁུར་དགོས་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","གང་ཡིན་ཟེར་ན། མི་ཚོགས་མང་པོ་ཞིག་ཁོང་ཚོའི་རྗེས་སུ་འབྲངས་ཏེ་སྐད་ཆེན་པོས་“ཁོ་སོད་ཅིག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","མཁར་རྫོང་གི་ནང་དུ་འཁྲིད་པའི་སྐབས་སུ་པའུ་ལུས་སྟོང་དཔོན་ལ་“ཁྱེད་ལ་གཅིག་ཞུས་ན་ཆོག་གམ་”ཞེས་གསུངས་པས་སྟོང་དཔོན་གྱིས་“ཁྱོད་ཀྱིས་གྷི་རིག་སྐད་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","དེས་ན་ཁྱོད་ནི་ཉེ་ཆར་ཟིང་འཁྲུག་བསླངས་ནས་ལྐོག་གསོད་གཏོང་མཁན་ཟེར་བའི་ངོ་ལོག་པ་བཞི་སྟོང་དབེན་གནས་ལ་འཁྲིད་མཁན་ཨེ་ཇེབ་པ་མ་ཡིན་ནམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ལན་དུ་པའུ་ལུས་“ང་ནི་ཡ་ཧུ་དཱ་པ་དང༌། ཀི་ལིག་ཡཱ་ཡུལ་གྱི་གྲོང་ཁྱེར་གལ་ཆེན་ཊར་སཱུ་ཡི་མངའ་འབངས་ཤིག་ཡིན། མི་ཚོགས་ལ་གཏམ་བརྗོད་པའི་ཆོག་མཆན་གནང་རོགས་གནང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","སྟོང་དཔོན་གྱིས་དེ་ལྟར་ཁས་ལེན་པ་ལ། པའུ་ལུས་རྡོ་སྐས་སུ་ལངས་ནས་མི་ཚོགས་ལ་ལག་བརྡ་བྱས་ཤིང༌། ཁོ་ཚོ་ཁ་ཁུ་སིམ་པོར་གྱུར་ནས་ཡ་ཧུ་དཱ་པའི་སྐད་དུ་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","པའུ་ལུས་“རྒན་པོ་དང་སྤུན་ཟླ་རྣམས། ད་ལྟ་ངས་ཁྱེད་ཚོ་ལ་འདིར་གང་བྱུང་བའི་སྐོར་གསལ་བཤད་ཞུ་རྒྱུ་ཡིན་པས་གསན་རོགས་གནང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ཁོང་གིས་ཁོ་ཚོར་ཡ་ཧུ་དཱ་པའི་སྐད་ནས་གསུངས་པ་ཐོས་ནས་མི་ཚོགས་དེ་བས་ཁ་ཁུ་སིམ་པོར་གྱུར། ཁོང་གིས་ ");
INSERT INTO bod_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ང་ནི་ཀི་ལིག་ཡཱ་ཡུལ་གྱི་ཊར་སཱུ་གྲོང་ཁྱེར་ལ་སྐྱེས་པའི་ཡ་ཧུ་དཱ་པ་ཞིག་ཡིན་ཞིང༌། གྲོང་ཁྱེར་འདིར་འཚར་ལོངས་བྱུང༌། ངེད་རྣམས་ཀྱི་མེས་པོའི་ཆོས་ཁྲིམས་ལྟར་སློབ་དཔོན་གཱ་མ་ལི་ཨེལ་དྲུང་དུ་ནན་ཏན་གྱིས་སྦྱངས་པ་བྱས་ཏེ། ཁྱེད་ཚོ་ཐམས་ཅད་ཀྱིས་དེ་རིང་བརྩོན་སེམས་ཆེན་པོས་དཀོན་མཆོག་ལ་བཀུར་སྟི་ཞུ་བ་ལྟར། ངས་ཀྱང་དཀོན་མཆོག་ལ་བཀུར་སྟི་ཞུས། ");
INSERT INTO bod_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ངས་ལམ་འདིར་ཞུགས་པའི་མི་རྣམས་ལ་སྲོག་གཅོད་ཀྱི་གནོད་པ་སྐྱེལ་བ་ཙམ་མ་ཟད། སྐྱེས་ཕོ་མོ་གཉིས་ཀ་བཅིངས་ནས་བཙོན་ཁང་དུའང་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","དོན་འདིར་བླ་ཆེན་གཙོ་བོ་དང་རྒན་པོའི་གྲོས་ཚོགས་ཡོངས་ཀྱིས་དཔང་པོ་མཛད་ཐུབ། ཁོང་ཚོས་དཱ་མེ་སེག་གྲོང་ཁྱེར་གྱི་སྤུན་ཟླ་རྣམས་ལ་བྲིས་པའི་ཡི་གེ་ང་ལ་ཐོབ་ནས། ལམ་འདིར་འཛིན་མཁན་རྣམས་བཅིངས་ནས་ཆད་པ་གཏོང་བར་ཡེ་རུ་ཤ་ལེམ་ལ་འཁྲིད་པའི་ཕྱིར་ང་དཱ་མེ་སེག་གྲོང་ཁྱེར་ལ་འགྲོ་དུས། ");
INSERT INTO bod_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","དཱ་མེ་སེག་དང་ཉེ་བར་སླེབས་པའི་སྐབས་ཀྱི་ཉིན་གུང་ཙམ་ལ་ནམ་མཁའ་ནས་འོད་ཆེན་པོ་ཞིག་ངའི་ཕྱོགས་བཞིར་གློ་བུར་དུ་འཁྱུགས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ང་ས་ལ་འགྱེལ་བ་དང༌། ཤ་ཨུལ། ཤ་ཨུལ། ཁྱོད་ཀྱིས་ང་ལ་ཅིའི་ཕྱིར་གནོད་སྐྱེལ་ཞེས་གསུངས་པའི་སྐད་ཅིག་ཐོས། ");
INSERT INTO bod_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ངས་ལན་དུ། གཙོ་བོ་ལགས། ཁྱེད་སུ་ཡིན་ཞེས་དྲིས་པས་ཁོང་གིས་ང་ནི་ཁྱོད་ཀྱིས་གནོད་སྐྱེལ་བཞིན་པའི་ན་ཙ་རེལ་པ་ཡེ་ཤུ་ཡིན་ནོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ངའི་ལམ་གྲོགས་རྣམས་ཀྱིས་འོད་དེ་མཐོང་ཡང༌། ང་ལ་གསུངས་པའི་སྒྲ་དེའི་དོན་མ་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ཡང་ངས། གཙོ་བོ་ལགས། ངས་ཅི་བྱ་ཞེས་བཤད་ནས་གཙོ་བོས་ང་ལ། ཡར་ལོངས་ལ་དཱ་མེ་སེག་གྲོང་ཁྱེར་དུ་སོང་ཞིག དེར་ངའི་དགོངས་པ་ལྟར་ཁྱོད་ཀྱིས་གང་བྱེད་དགོས་པ་ཐམས་ཅད་ཁྱོད་ལ་སྨྲ་བར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","འོད་ཆེན་པོ་དེའི་རྐྱེན་གྱིས་ངའི་མིག་མི་མཐོང་བར་གྱུར་བས་ལམ་གྲོགས་རྣམས་ཀྱིས་ངའི་ལག་པ་ནས་འཇུས་ཏེ་དཱ་མེ་སེག་ཏུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","དེར་མིང་ལ་ཨ་ནན་ཡཱ་ཟེར་བའི་མི་ཞིག་ཡོད་པ་དེ་ལ་དེར་གནས་པའི་ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་ཀྱིས་གུས་བཀུར་བྱེད་པ་དང༌། ཆོས་ཁྲིམས་བཞིན་དུ་ཆོས་སེམས་དང་ལྡན་པ་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ཁོང་ཕེབས་ཏེ་ངའི་འཁྲིས་སུ་བཞེངས་ནས། སྤུན་ཟླ་ཤ་ཨུལ། ཁྱེད་ཀྱི་མིག་གིས་མཐོང་བར་འགྱུར་ཞིག་ཅེས་གསུངས་མ་ཐག ངའི་མིག་གིས་མཐོང་བར་གྱུར་བ་དང༌། ངས་ཁོང་མཐོང་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","དེ་ནས་ཁོང་གིས་ང་ལ། ངེད་ཀྱི་མེས་པོའི་དཀོན་མཆོག་གིས་ཁྱེད་བདམས་པར་མཛད་དེ། ཁོང་གི་དགོངས་པ་ཤེས་སུ་བཅུག་པ་མ་ཟད། སྐྱེས་བུ་རྣམ་པར་དག་པ་དེ་མཐོང་ནས་དེ་ཡི་གསུང་སྐད་ཐོས་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","གང་ལགས་ཟེར་ན། ཁྱེད་ཀྱིས་གང་མཐོང་བ་དང་ཐོས་པ་དེ་མི་ཐམས་ཅད་ལ་བདེན་དཔང་བྱེད་མཁན་དུ་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ད་ཅིའི་ཕྱིར་འགྱངས་པར་བྱེད། ལོངས་ལ་ཁྲུས་གསོལ་ལེན་ཞིང༌། ཡེ་ཤུའི་མཚན་ལ་བརྟེན་ནས་ཁྱེད་ཀྱི་སྡིག་ཉེས་དག་པར་བྱོས་ཤིག་ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིར་ལོག་པའི་རྗེས་སུ་མཆོད་ཁང་ཆེན་མོར་སྨོན་ལམ་འདེབས་དུས་ང་ལ་ཞལ་གཟིགས་གནང་སྟེ། ");
INSERT INTO bod_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","གཙོ་བོས། ཁྱོད་ཀྱིས་ང་ལ་དཔང་པོ་བྱེད་པ་དེ་ཁོ་ཚོས་ཁས་མི་ལེན་པས་ཡེ་རུ་ཤ་ལེམ་ནས་མགྱོགས་པོར་ཐོན་ཏེ་སོང་ཞིག་ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ངས། གཙོ་བོ་ལགས། སྔར་ངས་འདུ་ཁང་རེ་རེར་ཁྱེད་ལ་དད་པ་བྱེད་མཁན་རྣམས་བརྡུངས་ནས་བཙོན་དུ་བཅུག་པ་ཁོ་ཚོ་ཉིད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ཡང་མི་རྣམས་ཀྱིས་ཁྱེད་ཀྱི་དཔང་པོ་སེ་ཏེ་ཕཱན་ལ་རྡོ་རུབ་བཏང་ནས་གསོད་པའི་སྐབས། ངས་ཀྱང་མོས་མཐུན་བྱས་ཏེ་དེར་བསྡད་ནས་ཁོ་ཚོའི་ཕྱི་གོས་སྲུང་ཉར་བྱས་ཞེས་ཟེར་བས། ");
INSERT INTO bod_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ཁོང་གིས་ང་ལ། སོང་ཞིག ངས་ཁྱོད་ས་ཆ་འདི་ནས་ཐག་རིང་དུ་ཡ་ཧུ་དཱ་པ་མིན་པའི་རྩར་གཏོང་བར་བྱ་ཞེས་གསུངས་སོ་”ཞེས་པའོ། ། ");
INSERT INTO bod_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","པའུ་ལུས་དེ་ལྟར་གསུངས་པའི་བར་དུ་མི་ཚོགས་ཀྱིས་ཉན་ནས་ཁོ་ཚོས་སྐད་ཆེན་པོས་“ཁོ་གསོད་ཅིག མི་འདི་འདྲ་ཞིག་ས་གཞི་འདིར་གསོན་པར་མི་འོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ཁོ་ཚོས་སྐད་ཅོར་རྒྱག་བཞིན་ཕྱི་གོས་ཕུད་ནས་ས་རྡུལ་ཡང་ནམ་མཁའ་ལ་གཏོར་བའི་དུས་སུ། ");
INSERT INTO bod_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","མི་ཚོགས་ཀྱིས་དེ་ལྟར་སྐད་ཅོར་རྒྱག་པའི་རྒྱུ་མཚན་གང་ཡིན་ཤེས་པའི་ཕྱིར། སྟོང་དཔོན་གྱིས་དམག་མི་རྣམས་ལ་པའུ་ལུ་མཁར་རྫོང་ནང་དུ་འཁྲིད་དགོས་པ་དང༌། རྟ་ལྕག་གིས་བརྡུངས་ནས་ཁོང་ལ་འདྲི་གཅོད་བྱེད་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","རྟ་ལྕག་གིས་རྡུང་བའི་ཆེད་དུ་ཐག་པས་བཅིངས་སྐབས་ཁོང་གིས་དེར་ཡོད་པའི་དམག་མི་བརྒྱ་དཔོན་ལ་“ཁྲིམས་ཐག་བཅད་མེད་པའི་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ལ་རྟ་ལྕག་གཞུ་བ་དེ་ཁྲིམས་བཞིན་དུ་ཆོག་གམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","དེ་ཐོས་པས་བརྒྱ་དཔོན་དེ་སྟོང་དཔོན་གྱི་དྲུང་དུ་སོང་ནས་ཁོ་ལ་“ཁྱེད་ཀྱིས་མཛད་པ་དེ་ཅི་ཡིན། མི་འདི་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ཡིན་ནོ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","སྟོང་དཔོན་ཡོང་ནས་པའུ་ལུ་ལ་“ང་ལ་ཤོད་ཅིག ཁྱོད་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ཡིན་ནམ་”ཞེས་ཟེར་བས་ཁོང་གིས་“ལགས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ལན་དུ་སྟོང་དཔོན་གྱིས་“ངས་དངུལ་མང་པོ་ཞིག་བཏང་ནས་རོ་མཱ་པའི་མངའ་འབངས་དེ་ཐོབ་”ཅེས་སྨྲས་པ་དང༌། པའུ་ལུས་“ང་སྐྱེས་དུས་ནས་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","དེ་མ་ཐག་ཁོང་ལ་འདྲི་གཅོད་བྱེད་མཁན་རྣམས་ཕྱིར་བཤོལ་བརྒྱབ། སྟོང་དཔོན་གྱིས་ཀྱང་པའུ་ལུ་ནི་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ཡིན་པར་ཤེས་པ་དང༌། ཁོང་ལྕགས་ཐག་གིས་བཅིངས་པས་ཁོ་རང་འཇིགས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་པའུ་ལུ་ལ་ནག་ཉེས་བཙུགས་པའི་རྒྱུ་རྐྱེན་ཅི་ཡིན་པ་ངེས་པར་དུ་ཤེས་པར་འདོད་པས་སྟོང་དཔོན་གྱིས་དེའི་སང་ཉིན་པའུ་ལུ་གློད་བཀྲོལ་བཏང་ཞིང༌། བླ་ཆེན་དང་གྲོས་ཚོགས་ཡོངས་སྐོང་དགོས་པའི་བཀའ་བཏང་ནས་ཁོས་པའུ་ལུ་ཁོ་ཚོའི་དྲུང་དུ་འཁྲིད་དུ་བཅུག་གོ ། ");
INSERT INTO bod_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","པའུ་ལུས་གྲོས་ཚོགས་ལ་ནན་གྱིས་བལྟས་ནས་“སྤུན་ཟླ་རྣམས། དེ་རིང་གི་བར་དུ་ངས་དཀོན་མཆོག་གི་སྤྱན་སྔར་རྒྱུ་དག་ཡོད་པའི་སྒོ་ནས་སྤྱོད་པ་བཟང་པོ་བྱས་པ་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","བླ་ཆེན་གཙོ་བོ་ཨ་ནན་ཡཱ་ཡིས་པའུ་ལུའི་ཉེ་འཁོར་དུ་ལངས་ནས་བསྡད་ཡོད་པའི་མི་རྣམས་ལ་ཁོང་གི་ཞལ་ལ་གཞུ་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ཡང་པའུ་ལུས་ཁོ་ལ་“ཁ་བཤད་དོན་ལ་མི་གནས་པ་ཁྱོད། དཀོན་མཆོག་གིས་ཁྱོད་རྡུང་བར་མཛད་ངེས་ཡིན། ཁྱོད་ཀྱིས་ཁྲིམས་བཞིན་དུ་ང་ཁྲིམས་གཅོད་བྱེད་པའི་ཆེད་དུ་དེར་བསྡད་ཡོད་ཀྱང༌། ཁྲིམས་དང་འགལ་ཏེ་ང་རྡུང་བའི་བཀའ་གཏོང་ངམ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","པའུ་ལུ་ཡི་གཡས་གཡོན་དུ་ཡོད་པའི་མི་རྣམས་ཀྱིས་“ཁྱོད་ཀྱིས་དཀོན་མཆོག་གི་བླ་ཆེན་གཙོ་བོ་ལ་དམའ་འབེབས་གཏོང་བར་ཕོད་དམ་”ཞེས་སྨྲས་པས། ");
INSERT INTO bod_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","པའུ་ལུས་“སྤུན་ཟླ་རྣམས། ངས་ཁོང་བླ་ཆེན་གཙོ་བོ་ཡིན་པ་མ་ཤེས། གསུང་རབ་ཀྱི་ནང་ལ་ཁྱོད་ཀྱི་མི་རིགས་ཀྱི་དཔོན་པོ་ལ་དམའ་འབེབས་མ་གཏོང་ཞིག་ཅེས་འཁོད་ཡོད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","མི་དེ་ཚོའི་ནང་ནས་ཕྱོགས་ཁག་ཅིག་སཱ་ཅུ་སེ་པ་དང༌། ཕྱོགས་ཁག་གཞན་ཕཱ་རུ་ཤི་པ་ཡིན་པ་མཁྱེན་པས་པའུ་ལུས་གྲོས་ཚོགས་ལ་སྐད་ཆེན་པོས་“སྤུན་ཟླ་རྣམས། ང་ནི་ཕཱ་རུ་ཤི་པ་ཡིན་ལ། ཕཱ་རུ་ཤི་པའི་བུ་རྒྱུད་ཀྱང་ཡིན་ནོ། ངས་གཤིན་པོ་རྣམས་འཆི་བ་ནས་སླར་གསོན་པར་འགྱུར་བ་ལ་ཡིད་རྟོན་པར་དད་པ་བྱེད་པས་ད་ལྟ་ཁྲིམས་གཅོད་མྱོང་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","དེ་ལྟར་གསུངས་པས་ཕཱ་རུ་ཤི་པ་དང་སཱ་ཅུ་སེ་པ་གཉིས་ཀྱི་བར་དུ་རྩོད་གླེང་ཞིག་བྱུང་བས་གྲོས་ཚོགས་མི་མཐུན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(གང་ཡིན་ཞེ་ན། སཱ་ཅུ་སེ་པ་རྣམས་ཀྱིས་འཆི་བ་ནས་སླར་གསོན་པར་འགྱུར་བ་དང༌། དཀོན་མཆོག་གི་ཕོ་ཉ། སེམས་ཉིད་ཀྱང་མེད་ཅེས་ཟེར། ཕཱ་རུ་ཤི་པ་རྣམས་ཀྱིས་དེ་ཚོ་གསུམ་ཡོད་པར་ཟེར་) ");
INSERT INTO bod_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","འུར་སྒྲ་ཆེན་པོ་བྱུང་བ་དང༌། ཕཱ་རུ་ཤི་པའི་ཕྱོགས་ཁག་གི་ཆོས་ཁྲིམས་ལ་མཁས་པའི་མི་ཁ་ཤས་ལངས་ནས་རྩོད་གླེང་བྱེད་དེ་“ང་ཚོས་མི་འདིར་ཉེས་སྐྱོན་ཅིའང་མི་རྙེད། གལ་ཏེ་སེམས་ཉིད་ཡང་ན་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་གིས་ཁོ་ལ་གཏམ་གསུངས་ན་ཅི་འདྲ་ལགས་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","རྩོད་པ་དེ་ཤུགས་ཆེར་སོང་བས། ཁོ་ཚོས་པའུ་ལུ་དུམ་བུར་བཅད་པའི་ཉེན་ཁ་ཡོད་པར་འཇིགས་ནས། སྟོང་དཔོན་གྱིས་དམག་མི་རྣམས་ལ་པའུ་ལུ་ཁོ་ཚོའི་དཀྱིལ་ནས་མཁར་རྫོང་ལ་དབང་ཤུགས་ཀྱིས་འཁྲིད་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","མཚན་མོ་དེར་གཙོ་བོ་ཡེ་ཤུ་པའུ་ལུའི་འགྲམ་དུ་བཞེངས་ཏེ་“མ་འཇིགས་ཤིག ཡེ་རུ་ཤ་ལེམ་ལ་ཁྱོད་ཀྱིས་ང་ལ་བདེན་དཔང་བྱས་པ་ལྟར། རོ་མཱ་གྲོང་ཁྱེར་ལའང་དེ་ལྟར་བདེན་དཔང་བྱེད་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","དེའི་སང་ཞོགས་ཡ་ཧུ་དཱ་པ་ཁ་ཅིག་གིས་ཇུས་ངན་བཏིང་བས་པའུ་ལུ་མ་བསད་པའི་བར་དུ་བཟའ་བཏུང་ཅི་ཡང་མི་སྤྱོད་པའི་དམ་བཅའ་བཞག ");
INSERT INTO bod_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ཇུས་ངན་འདི་འདིང་མཁན་ནི་མི་བཞི་བཅུ་ལས་མང་བ་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ཁོ་ཚོས་བླ་ཆེན་དང་རྒན་པོ་རྣམས་ཀྱི་དྲུང་དུ་ཕྱིན་ནས་“ང་ཚོས་པའུ་ལུ་མ་བསད་པའི་བར་དུ་བཟས་ཅི་ཡང་མི་སྤྱོད་པའི་དམ་བཅའ་ནན་གྱིས་བཞག་པས། ");
INSERT INTO bod_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ད་གྲོས་ཚོགས་ཀྱི་མི་དང་བཅས་པས་སྔོན་ལས་ཞིབ་པར་འདྲི་གཅོད་བྱེད་ཁུལ་ཏེ། སྟོང་དཔོན་ལ་པའུ་ལུ་ཁྱེད་ཚོའི་མདུན་དུ་འཁྲིད་དགོས་པའི་ཞུ་བ་མངག་ཅིག ང་ཚོས་གྲ་སྒྲིག་བྱས་ཟིན་པས་པའུ་ལུ་ཉེ་བར་མ་སླེབས་པའི་སྔོན་ལ་ཁོ་གསོད་པར་བྱ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ཡང་པའུ་ལུའི་སྲིང་མོའི་བུས་དེའི་སྐོར་ཐོས་ནས་མཁར་རྫོང་ལ་ཕྱིན་ཏེ་པའུ་ལུ་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","བརྒྱ་དཔོན་ཁྲོད་ནས་གཅིག་བོས་ཏེ་པའུ་ལུས་ཁོ་ལ་“གཞོན་ནུ་འདི་སྟོང་དཔོན་གྱི་རྩར་འཁྲིད་དང༌། ཁོང་ལ་གཏམ་ཞུ་རྒྱུ་ཞིག་ཡོད་པས་སོ་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","བརྒྱ་དཔོན་གྱིས་གཞོན་ནུ་དེ་སྟོང་དཔོན་གྱི་རྩར་འཁྲིད་ནས་ཁོ་ལ་“བཙོན་པ་པའུ་ལུས་ང་བོས་ནས་གཞོན་ནུ་འདི་ཁྱེད་ཀྱི་རྩར་འཁྲིད་པར་ཞུས། གང་ཡིན་ཞེ་ན། ཁྱེད་ལ་གཏམ་ཞིག་ཞུ་རྒྱུ་ཡོད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","སྟོང་དཔོན་གྱིས་བུ་དེའི་ལག་པ་ནས་འཇུས་ཏེ་ཟུར་དུ་འཁྲིད་ནས་ཁོ་ལ་“ང་ལ་གཏམ་ཅི་ཞིག་ཤོད་རྒྱུ་ཡོད་”ཅེས་བཤད་པ་ལ། ");
INSERT INTO bod_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","གཞོན་ནུ་དེས་“ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་པའུ་ལུ་ལ་སྔོན་ལས་ཞིབ་པར་འདྲི་གཅོད་བྱེད་ཁུལ་ཏེ། ཁྱེད་ཀྱིས་སང་ཉིན་ཁོང་གྲོས་ཚོགས་ཀྱི་དྲུང་དུ་འཁྲིད་པའི་ཞུ་བར་གཏན་འཁེལ། ");
INSERT INTO bod_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","འོན་ཏེ་ཁོ་ཚོས་བཤད་པ་ལྟར་མ་གནང་ཞིག གང་ཡིན་ཞེ་ན། ཁོ་ཚོ་མི་བཞི་བཅུ་ལྷག་ཙམ་གྱིས་ཁོང་གསོད་པར་ལྐོག་ཏུ་སྒུག་ནས་སྡོད་དེ། ཁོང་མ་བསད་པའི་བར་དུ་བཟའ་བཏུང་ཅི་ཡང་མི་སྤྱོད་པའི་དམ་བཅའ་བཞག ད་ལྟ་གྲ་སྒྲིག་ཟིན་ཏེ་ཁྱེད་ཀྱིས་ཆོག་མཆན་གནང་རྒྱུ་ཁོ་ན་སྒུག་བསྡད་ཡོད་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","སྟོང་དཔོན་གྱིས་“ཁྱོད་ཀྱིས་ང་ལ་སྨྲས་པའི་དོན་འདི་མི་གཞན་སུ་ལའང་མ་ཤོད་ཅིག་”ཅེས་པའི་བཀའ་བཏང་ནས་གཞོན་ནུ་དེ་ཕར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","སྟོང་དཔོན་གྱིས་བརྒྱ་དཔོན་གཉིས་བོས་ཏེ་ཁོ་རྣམས་ལ་“རྐང་དམག་མི་ཉིས་བརྒྱ་དང༌། རྟ་དམག་བདུན་ཅུ། མདུང་དམག་ཉིས་བརྒྱ་བཅས་མཚན་མོའི་ཆུ་ཚོད་དགུ་པར་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་འགྲོ་བའི་གྲ་སྒྲིག་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","པའུ་ལུའི་ཕྱིར་བཞོན་པ་གྲ་སྒྲིག་བྱས་ནས་སྤྱི་ཁྱབ་ཕེ་ལིག་གི་རྩར་ཉེན་ཁ་མེད་པར་སྐྱོལ་ཞིག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ཡང་ཁོས་གཤམ་དུ་ཡོད་པའི་ཡི་གེ་འདི་བྲིས། ");
INSERT INTO bod_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ཀ་ལོ་དཱི་ལི་སི་ཡཱ་ཡིས་གུས་པར་འོས་པའི་སྤྱི་ཁྱབ་ཕེ་ལིག་ཁྱེད་ལ་འཚམས་འདྲི་ཞུའོ། ");
INSERT INTO bod_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་མི་འདི་འཛིན་བཟུང་བྱས་ནས་གསོད་གྲབས་བྱེད་དུས། ངས་ཁོ་རོ་མཱ་པའི་མངའ་འབངས་ཤིག་ཡིན་པ་ཤེས་ཏེ་དམག་མི་དང་བཅས་པར་ས་ཆ་དེར་སོང་ཞིང་ཁོ་ཚོའི་ལག་པ་ནས་བསྐྱབས། ");
INSERT INTO bod_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ཉེས་སྐྱོན་བཙུགས་པའི་དོན་གང་ཡིན་ཤེས་པར་འདོད་པས་ངས་མི་དེ་ཁོ་ཚོའི་གྲོས་ཚོགས་ཀྱི་དྲུང་དུ་འཁྲིད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","སྐྱོན་འཛུགས་བྱས་པ་དེ་ཡང་ཁོ་ཚོའི་ཆོས་ཁྲིམས་ཀྱི་དོན་ཡིན་པ་ལས་སྲོག་ཁྲིམས་གཏོང་བའམ་བཙོན་དུ་བཅུག་དགོས་པའི་ཉེས་པ་ཅིའང་མེད་པ་དེ་ངས་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","དེ་རྗེས་ཁོ་གསོད་པའི་ཇུས་ངན་གྱི་གཏམ་ཐོས་སྐབས། མི་དེ་ཁྱེད་ལ་འཕྲལ་དུ་བསྐྱལ་བ་ཡིན། ཡང་ཉེས་སྐྱོན་འཛུགས་མཁན་རྣམས་ལའང་ཉེས་སྐྱོན་གང་ཡོད་པ་འཆད་པའི་ཕྱིར་ཁྱེད་ཀྱི་མདུན་དུ་འགྲོ་དགོས་པའི་བཀའ་བཏང༌། ཞེས་པའོ། ། ");
INSERT INTO bod_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","བཀའ་དེ་དང་བསྟུན་ཏེ་མཚན་མོའི་དུས་སུ་དམག་མི་རྣམས་ཀྱིས་པའུ་ལུ་ཨན་ཏི་པ་ཏྲི་གྲོང་ཁྱེར་དུ་བསྐྱལ། ");
INSERT INTO bod_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","དེའི་སང་ཉིན་རྐང་དམག་རྣམས་མཁར་རྫོང་ལ་ཕྱིར་ལོག་པ་དང༌། རྟ་དམག་རྣམས་པའུ་ལུ་འཁྲིད་དེ་ཕར་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ཁོང་རྣམས་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་སླེབས་སྐབས། ཡི་གེ་དེ་སྤྱི་ཁྱབ་ལ་སྤྲད་ཅིང་པའུ་ལུ་ཡང་ཁོའི་ལག་ཏུ་བརྩིས་སྤྲད། ");
INSERT INTO bod_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","སྤྱི་ཁྱབ་ཀྱིས་ཡི་གེ་དེ་བཀླགས་ནས་པའུ་ལུ་ཡུལ་གང་ནས་ཡིན་དྲིས་པ་ལ། ཁོང་ཀི་ལིག་ཡཱ་ཞིང་ཆེན་ནས་ཡིན་པར་ཤེས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ཁོས་“ཁྱོད་ལ་ཉེས་འཛུགས་མཁན་འདིར་སླེབས་པའི་ཚེ་ཁྱོད་ཀྱི་དོན་ཉན་པར་བྱ་”ཞེས་བཤད་ནས། རྒྱལ་པོ་ཧེ་རོ་དཱེ་ཡིས་བརྩིགས་པའི་ཕོ་བྲང་གི་བཙོན་ཁང་དུ་པའུ་ལུ་སྲུང་དགོས་པའི་བཀའ་བཏང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ཉི་མ་ལྔ་ཡི་རྗེས་སུ་བླ་ཆེན་གཙོ་བོ་ཨ་ནན་ཡཱ་དང༌། རྒན་པོ་ཁ་ཅིག ཏེར་ཏུལ་ལུ་ཞེས་པའི་ཁྲིམས་རྩོད་པ་དང་བཅས་ཏེ་དེར་སླེབས་པ་དང་སྤྱི་ཁྱབ་ཀྱི་མདུན་དུ་པའུ་ལུ་ལ་ནག་ཉེས་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","པའུ་ལུ་བོས་པ་དང་ཏེར་ཏུལ་ལུ་ཡིས་ཁོང་ལ་ཉེས་སྐྱོན་འཛུགས་ཏེ་སྤྱི་ཁྱབ་ལ་“སྤྱི་ཁྱབ་ཕེ་ལིག་དཔོན་ཆེན་ལགས། ཁྱེད་ཀྱི་བཀའ་དྲིན་གྱིས་ང་ཚོ་ཡུན་རིང་ཞི་བདེ་ལ་ལོངས་སྤྱོད་ཅིང༌། ཁྱེད་ཀྱིས་སྔོན་གཟིགས་ལྟར་མི་རིགས་འདི་ལ་ཕན་པའི་བཅོས་བསྒྱུར་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ང་ཚོས་ཁྱེད་ཀྱི་བཀའ་དྲིན་འདིར་དུས་དང་རྣམ་པ་ཀུན་ཏུ་ཐུགས་རྗེ་ཆེ་ཞུའོ། ");
INSERT INTO bod_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","འོན་ཀྱང་ཁྱེད་ལ་དེ་བས་སྙན་སུན་མི་ཞུ་བའི་ཕྱིར་ཐུགས་རྗེས་ཆེན་པོས་ང་ཚོས་ཚིག་འགའ་ཞུས་པར་གསན་རོགས་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","མི་འདི་ནི་ཡུལ་ཀུན་ཏུ་ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་ཀྱི་ནང་ནས་རྙོག་དྲ་དང༌། ཟིང་ཆ་སློང་མཁན་གཙོ་བོ་ཞིག་དང༌། ན་ཙ་རེལ་པ་ཞེས་པའི་ཆོས་ལུགས་ཀྱི་འགོ་ཁྲིད་པ་བཅས་ཡིན་པ་ངེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","མ་ཟད་ཁོས་མཆོད་ཁང་ཆེན་མོ་ལའང་མི་གཙང་བ་བྱེད་པར་བསམས་པས་ང་ཚོས་ཁོ་འཛིན་བཟུང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ཁྱེད་ཀྱིས་དོན་དེ་ཐམས་ཅད་ཀྱི་སྐོར་ཁོ་ལ་འདྲི་གཅོད་གནང་ན་ང་ཚོས་ཁོ་ལ་ཉེས་སྐྱོན་བཙུགས་པའི་རྒྱུ་མཚན་མཁྱེན་པར་འགྱུར་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཀྱང་ནག་ཉེས་བཙུགས་པའི་དོན་དེ་རྣམས་བདེན་པ་ཡིན་པར་ཁས་ལེན་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","དེ་ནས་སྤྱི་ཁྱབ་ཀྱིས་པའུ་ལུ་ལ་སྐད་ཆ་ཤོད་དགོས་པའི་བརྡ་བྱས་པས་པའུ་ལུས་“ཁྱེད་ནི་ལོ་མང་པོའི་རིང་མི་རིགས་འདིའི་ཁྲིམས་དཔོན་ཡིན་པར་ངས་ཤེས། དེར་བརྟེན་ངས་དགའ་བའི་ངང་ནས་ང་ཉེས་མེད་པ་ཡིན་པའི་རྒྱུ་མཚན་ཁྱེད་ལ་གསལ་བཤད་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ང་བསྙེན་བཀུར་བྱེད་པའི་ཆེད་དུ་ཡེ་རུ་ཤ་ལེམ་ལ་སླེབས་ནས་ཉི་མ་བཅུ་གཉིས་ལས་མ་འགོར་བར་དེ་ཁྱེད་ཀྱིས་ལས་སླ་པོར་མཁྱེན་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ངས་མཆོད་ཁང་ཆེན་མོ་དང༌། ཡང་ན་ཡ་ཧུ་དཱ་པའི་འདུ་ཁང༌། དེ་བཞིན་གྲོང་ཁྱེར་ནང་དུ་མི་སུ་དང་ཡང་རྩོད་གླེང་བྱེད་པའམ། ཟིང་ཆ་སློང་བ་ཁོ་ཚོས་མ་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ཁོ་ཚོས་ད་ལྟ་ང་ལ་ནག་ཉེས་འཛུགས་པ་དེར་ཁོ་ཚོས་ཀྱང་ར་སྤྲོད་བྱེད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","འོན་ཀྱང་ངས་ཁྱེད་ལ་དོན་གཅིག་ཁས་ལེན་བྱེད་དེ། ཁོ་ཚོས་ལོག་པའི་ཆོས་ཞེས་ཟེར་བའི་ལམ་བཞིན་དུ་ངས་མེས་པོའི་དཀོན་མཆོག་ལ་བསྙེན་བཀུར་བྱེད་ཅིང༌། ཆོས་ཁྲིམས་དང་མཐུན་ཞིང་ལུང་སྟོན་པའི་མདོ་ན་གང་བྲིས་པ་ཐམས་ཅད་ལའང་དད་པ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ཁོ་ཚོ་དང་འདྲ་བར་ངས་ཀྱང་དཀོན་མཆོག་ལ་ཡིད་རྟོན་བྱེད་དེ། དྲང་པོ་དང་ངན་པ་རིགས་གཉིས་ཀ་འཆི་བ་ནས་སླར་གསོན་པོར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","དེའི་ཕྱིར་ངས་དཀོན་མཆོག་དང་མི་རྣམས་ཀྱི་མདུན་དུ་རྒྱུ་དག་ཡོད་པར་རྟག་ཏུ་བརྩོན། ");
INSERT INTO bod_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ལོ་ཁ་ཤས་འགོར་བའི་རྗེས་སུ་ངའི་མི་རིགས་ལ་སྦྱིན་པ་གཏོང་ཞིང༌། མཆོད་པ་འབུལ་བའི་ཆེད་དུ་ས་དེར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","དེ་ལྟར་བྱེད་པའི་སྐབས་སུ་ངས་གཙང་སྦྲ་བྱེད་པའི་ཆོ་ག་སྒྲུབ་ཚར་ནས་ང་མཆོད་ཁང་ཆེན་མོར་ཡོད་པ་མི་ཚོགས་སམ། འཁྲུག་པ་ཅི་ཡང་མེད་པར་ཁོ་ཚོས་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","འོན་ཀྱང་ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་ནས་ཡིན་པའི་ཡ་ཧུ་དཱ་པ་ཁ་ཅིག་གིས་ང་ལ་སྐྱོན་བརྗོད་བྱེད་རྒྱུ་ཡོད་ན། འདིར་ཁྱེད་ཀྱི་མདུན་དུ་ཡོང་ནས་བརྗོད་འོས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ཡང་ན། ང་གྲོས་ཚོགས་ཀྱི་མདུན་དུ་ཡོད་སྐབས་ངས་ཉེས་པ་གང་ཞིག་བྱས་པ་དེ་མི་འདི་ཚོས་འཆད་དགོས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","གྲོས་ཚོགས་ཀྱི་དཀྱིལ་ལ་ལངས་དུས་ངས་སྐད་ཆེན་པོས་གཤིན་པོ་རྣམས་འཆི་བ་ནས་སླར་གསོན་པར་འགྱུར་བའི་སྐོར་ལ་དེ་རིང་ཁྱེད་རྣམས་ཀྱི་མདུན་དུ་ཁྲིམས་གཅོད་མྱོང་ཞེས་སྨྲས་པ་ལས་སྐྱོན་གཞན་ཡོད་ན་ཁོ་ཚོས་ཁྱེད་ལ་སྨྲ་དགོས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ཡེ་ཤུའི་ཐར་ལམ་ཞིབ་པར་ཤེས་པའི་སྤྱི་ཁྱབ་ཕེ་ལིག་གིས་ཚོགས་འདུ་འཚོག་མཚམས་འཇོག་སྟེ་“སྟོང་དཔོན་ལི་སི་ཡཱ་འདིར་སླེབས་ནས་ངས་ཁྱོད་ཀྱི་ཁྲིམས་ཐག་གཅོད་པར་བྱ་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","དེ་ནས་ཁོས་བརྒྱ་དཔོན་ལ་པའུ་ལུ་ནན་པོར་སྲུང་མི་དགོས་ཏེ་ལྟ་སྐྱོང་བྱེད་མཁན་གྲོགས་པོ་རྣམས་ཀྱང་མི་འགོག་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ཉིན་ཤས་ཀྱི་རྗེས་སུ་ཕེ་ལིག་དང་ཁོང་གི་སྐུ་ཟླ་ཡ་ཧུ་དཱ་པ་ཡིན་པའི་དྲུ་སིལ་ལཱ་བཅས་པ་ཡོང་ནས་པའུ་ལུ་བོས་པ་དང༌། པའུ་ལུས་མཱ་ཤི་ཀ་ཡེ་ཤུ་ལ་དད་པའི་སྐོར་གྱི་ཆོས་གསུངས་པ་ལ་ཉན། ");
INSERT INTO bod_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","པའུ་ལུས་དྲང་བདེན་ཉིད་དང༌། རང་ཚོད་ཟིན་པ། མ་འོངས་པའི་ཁྲིམས་གཅོད་བཅས་གསུངས་པས་ཕེ་ལིག་འཇིགས་ནས་“ད་ཕར་སོང་ལ་དུས་ཚོད་བྱུང་ན་ངས་ཁྱོད་འབོད་པར་བྱ་”ཞེས་སྨྲས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ཕེ་ལིག་གིས་པའུ་ལུས་རང་ཉིད་ལ་དངུལ་སྤྲོད་པའི་རེ་བས་ཁོས་ཐེངས་མང་པོར་བོས་ནས་ཁོང་དང་གཏམ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ལོ་གཉིས་འགོར་བའི་རྗེས་སུ་པོར་ཀི་ཡུ་ཕེ་སི་ཏུ་ཞེས་བྱ་བ་ཕེ་ལིག་གི་ཚབ་ལ་སྤྱི་ཁྱབ་ཏུ་བསྐོས། སྤྱི་ཁྱབ་ཕེ་ལིག་གིས་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་དགའ་བའི་ཕྱིར་པའུ་ལུ་མུ་མཐུད་བཙོན་ཁང་ལ་བཞག་གོ ། ");
INSERT INTO bod_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ཞིང་ཆེན་དེར་སླེབས་ནས་ཉི་མ་གསུམ་གྱི་རྗེས་སུ་སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ནས་ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","དེར་བླ་ཆེན་དང་ཡ་ཧུ་དཱ་པའི་འགོ་ཁྲིད་པ་རྣམས་ཀྱིས་ཁོང་གི་མདུན་དུ་པའུ་ལུ་ལ་ནག་ཉེས་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ཁོ་ཚོས་པའུ་ལུ་ཡེ་རུ་ཤ་ལེམ་ལ་གཏོང་བའི་ཁོ་རང་ཚོའི་རེ་བ་བསྐོང་ཕྱིར་ཕེ་སི་ཏུ་ལ་ཞུ་བ་ཕུལ། དེ་ནི་ཁོ་ཚོས་ལམ་བར་དུ་ཁོང་གསོད་པའི་ཇུས་ངན་བཤམས་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ལན་དུ་ཕེ་སི་ཏུ་ཡིས་“པའུ་ལུ་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་ལྟ་སྲུང་བྱེད་བཞིན་པས་ང་རང་ཡང་ཅུང་མ་འགོར་བར་དེར་འགྲོ་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ཁྱོད་ཚོའི་ནང་ནས་དབང་ཡོད་པ་རྣམས་ང་དང་མཉམ་དུ་དེར་འགྲོ་དགོས། གལ་ཏེ་མི་དེ་ལ་ཉེས་སྐྱོན་ཡོད་ན་ཁོ་ལ་ཁྲིམས་གཅོད་བྱེད་ཆོག་”ཅེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ཕེ་སི་ཏུ་ཁོ་ཚོའི་ཁྲོད་དུ་ཉི་མ་བརྒྱད་ནས་བཅུ་ཙམ་བར་ལས་ལྷག་པ་མ་བསྡད་པར་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་ལ་ཕྱིན་པ་དང༌། དེའི་སང་ཉིན་ཁྲིམས་དཔོན་གྱི་ཁྲི་ལ་བསྡད་ནས་པའུ་ལུ་ཁོའི་མདུན་དུ་འཁྲིད་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ཁོང་དེར་སླེབས་རྗེས་ཡེ་རུ་ཤ་ལེམ་ནས་ཡོང་བའི་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ཁོང་གི་མཐའ་སྐོར་དུ་ལངས་ནས་བསྡད་དེ་ར་སྤྲོད་བྱེད་མ་ཐུབ་པའི་ནག་ཉེས་ཚབས་ཆེན་མང་པོ་བཙུགས། ");
INSERT INTO bod_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","པའུ་ལུས་“ངས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཁྲིམས་སམ། མཆོད་ཁང་ཆེན་མོའམ། ཡང་ན་གོང་མའི་རྒྱལ་པོ་སེ་སར་ལ་བལྟས་ནས་ཉེས་པ་ཅིའང་མ་བྱས་”ཞེས་སྐྱོན་མེད་པ་ཡིན་པར་གསལ་བཤད་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","འོན་ཀྱང་སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ཡིས་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་དགའ་པོ་ཡོང་བའི་ཕྱིར་པའུ་ལུ་ལ་“ཡེ་རུ་ཤ་ལེམ་ལ་ཕྱིན་ནས་ངའི་མདུན་དུ་དོན་འདི་ཁྲིམས་གཅོད་མྱོང་བར་འདོད་དམ་”ཞེས་དྲིས་པས། ");
INSERT INTO bod_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","པའུ་ལུས་“ད་ལྟ་ང་རྒྱལ་པོ་སེ་སར་གྱི་ཁྲིམས་རར་ཡོད། འདི་ནི་ང་ལ་ཁྲིམས་གཅོད་བྱེད་འོས་པའི་ས་ཆ་ཡིན། ཁྱེད་རང་གིས་མཁྱེན་གསལ་ལྟར་ངས་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་ཉེས་པ་གང་ཡང་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","གལ་ཏེ་ང་ཉེས་ཅན་པ་ཡིན་ཞིང༌། སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་ཉེས་པའི་ལས་གང་ཞིག་བྱས་ཡོད་པ་ཡིན་ན་འཆི་བ་ལས་ཐར་བར་འགྱུར་བའི་ཐབས་མི་འཚོལ། གལ་ཏེ་དེ་ཚོས་བཙུགས་པའི་ཉེས་སྐྱོན་རྣམས་བདེན་པ་གང་ཡང་མིན་ན། སུས་ཀྱང་ང་ཁོ་ཚོའི་ལག་ཏུ་གཏོད་པར་མི་རུང༌། ངས་རྒྱལ་པོ་སེ་སར་ལ་སྙན་སེང་ཞུ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","སྤྱི་ཁྱབ་ཕེ་སི་ཏུས་རང་གི་གྲོས་ཚོགས་ཀྱི་མི་དང་གྲོས་བསྡུར་བྱས་ནས་“རྒྱལ་པོ་སེ་སར་གྱིས་ཁྱོད་ལ་ཁྲིམས་གཅོད་བྱེད་པར་ཞུས་པས། ཁྱོད་རང་སེ་སར་གྱི་ཁྲིམས་རར་འགྲོ་དགོས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ཉི་མ་ཁ་ཤས་འགོར་བའི་རྗེས་སུ་རྒྱལ་པོ་ཨག་རི་པཱ་དང་བཙུན་མོ་པུར་ནི་ཀཱེ་གཉིས་སེ་སར་རེ་ཡཱ་གྲོང་ཁྱེར་དུ་ཕེ་སི་ཏུ་ལ་འཚམས་འདྲི་བྱེད་པར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ཁོ་ཚོ་དེར་ཉིན་མང་པོ་བསྡད་པས་ཕེ་སི་ཏུ་ཡིས་པའུ་ལུའི་གནས་ཚུལ་རྒྱལ་པོ་དང་གཏམ་གླེང་བྱས་པ་སྟེ་“ཕེ་ལིག་གིས་བཙོན་དུ་བཅུག་པའི་མི་ཞིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ང་ཡེ་རུ་ཤ་ལེམ་ལ་ཡོད་དུས་ཡ་ཧུ་དཱ་པའི་བླ་ཆེན་དང་རྒན་པོ་རྣམས་ཀྱིས་ཁོ་ལ་ནག་ཉེས་བཙུགས་ཏེ་ཁྲིམས་གཅོད་གཏོང་དགོས་པར་བསྐུལ། ");
INSERT INTO bod_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ངས་ཁོ་ཚོར་ཉེས་སྐྱོན་འཛུགས་མཁན་གྱི་མདུན་དུ་རང་སྐྱོབ་ཀྱི་གཏམ་མ་བཤད་པའི་བར་དུ་མི་སུ་ཞིག་ཁ་གཏད་པ་རྣམས་ལ་གཏོད་པ་ནི་རོ་མཱ་པའི་ཁྲིམས་ལུགས་མིན་པར་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","དེའི་ཕྱིར་ཁོ་ཚོ་འདིར་འདུས་པས་ངས་དུས་ཚོད་མ་འགྱངས་པར་དེའི་སང་ཉིན་ཁྲིམས་དཔོན་གྱི་ཁྲི་ལ་བསྡད་ནས་མི་དེ་འཁྲིད་ཡོང་དགོས་པའི་བཀའ་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ནག་ཉེས་འཛུགས་མཁན་རྣམས་ཡར་ལངས་ནས་ངའི་བསམ་པ་བཞིན་དུ་ཁོ་ལ་ཉེས་པ་ཅིའང་མ་བཙུགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","རང་ཆོས་ཀྱི་རྣམ་པ་དང༌། ཡེ་ཤུ་ཞེས་བྱ་བ་ཞིག་ཤི་ནས་པའུ་ལུས་དེ་ནི་གསོན་པོར་འདུག་ཅེས་སྨྲས་པའི་སྐོར་ལ་རྩོད་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","དོན་དེ་འདྲི་གཅོད་བྱེད་སྟངས་མ་ཤེས་པས་ངས་ཁོ་ལ། ཡེ་རུ་ཤ་ལེམ་ལ་སོང་ནས་ངའི་མདུན་དུ་དོན་འདི་ཁྲིམས་གཅོད་མྱོང་བར་འདོད་དམ་ཞེས་དྲིས། ");
INSERT INTO bod_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","འོན་ཀྱང་པའུ་ལུས་གོང་མའི་རྒྱལ་པོས་ཁྲིམས་ཐག་མ་བཅད་པའི་བར་དུ་འདིར་བཞག་པའི་ཞུ་བ་ཞུས་པའི་ཚེ། ངས་ཁོ་གོང་མའི་རྒྱལ་པོ་སེ་སར་ལ་མ་བཏང་བའི་བར་དུ་བཙོན་དུ་སྲུང་དགོས་པའི་བཀའ་བཏང་”ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","དེ་ནས་རྒྱལ་པོ་ཨག་རི་པཱ་ཡིས་སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ལ་“ང་ཡང་མི་དེའི་གཏམ་ལ་ཉན་པར་དགའ་”ཞེས་ཟེར་བས་ཕེ་སི་ཏུ་ཡིས་“སང་ཉིན་གསན་པར་འགྱུར་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","དེའི་སང་ཉིན་རྔམ་བརྗིད་དང་ལྡན་པའི་སྒོ་ནས་རྒྱལ་པོ་ཨག་རི་པཱ་དང་བཙུན་མོ་པུར་ནི་ཀཱེ་དམག་མིའི་སྟོང་དཔོན་དང༌། གྲོང་ཁྱེར་གྱི་དཔོན་རིགས་དང་བཅས་པར་ཚོགས་ཁང་ལ་འཛུལ། སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ཡིས་བཀའ་བཏང་བས་པའུ་ལུ་ཁོ་ཚོའི་མདུན་དུ་འཁྲིད། ");
INSERT INTO bod_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ཡིས་“རྒྱལ་པོ་ཨག་རི་པཱ་དང་འདིར་ངེད་རྣམས་དང་མཉམ་དུ་བཞུགས་པའི་སྐུ་ཞབས་ཐམས་ཅད། ཁྱེད་རྣམས་ཀྱིས་གཟིགས་པའི་མི་འདིའི་ཕྱིར་ཡ་ཧུ་དཱ་པའི་མི་ཚོགས་ཀུན་གྱིས་ཡེ་རུ་ཤ་ལེམ་དང་གནས་འདིར་ང་ལ་ཁྲིམས་ཞུ་བ་ཞུས་ཏེ། སྐད་ཆེན་པོས་ཁོ་གསོན་པོར་གནས་པར་མི་རུང་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","འོན་ཀྱང་ངས་མི་འདིར་སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་ཉེས་པ་ཅིའང་མ་རྙེད། ཁོ་ཉིད་ཀྱིས་གོང་མའི་རྒྱལ་པོར་ཁྲིམས་ཞུས་པས་ངས་ཁོ་དེར་གཏོང་བར་ཐག་གཅོད་བྱས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","མི་འདིའི་སྐོར་གྱི་དོན་ངེས་གཏན་ཞིག་གོང་མའི་རྒྱལ་པོ་ལ་འབྲི་རྒྱུ་མེད། དེའི་ཕྱིར་ཁྱེད་རྣམས་དང༌། ལྷག་པར་དུ་རྒྱལ་པོ་ཨག་རི་པཱ་ཁྱེད་རང་གི་མདུན་དུ་ཁོ་འཁྲིད་ཡོད། དེ་ནི་འདྲི་གཅོད་འདི་ཚར་བའི་རྗེས་སུ་གོང་མའི་རྒྱལ་པོར་དོན་ཞིག་འབྲི་རྒྱུ་ཡོད་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","གང་ལགས་ཟེར་ན། ཉེས་སྐྱོན་གང་ཡིན་མ་བྲིས་པར་བཙོན་པ་ཞིག་གཏོང་བ་དེ་ངའི་བསམ་པར་མི་རིགས་པས་སོ་”ཞེས་བཤད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","རྒྱལ་པོ་ཨག་རི་པཱ་ཡིས་པའུ་ལུ་ལ་“གཏམ་བྱེད་ཆོག་”ཅེས་སྨྲས་ནས་པའུ་ལུས་ཕྱག་བརྐྱངས་ཏེ་ཉེས་སྐྱོན་མེད་པའི་སྐོར་ཁོ་རྣམས་ལ་གསལ་བཤད་བྱེད་དེ་ ");
INSERT INTO bod_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ཀྱེ་རྒྱལ་པོ་ཨག་རི་པཱ་ལགས། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ང་ལ་ཉེས་འགེལ་བྱས་པའི་དོན་ཐམས་ཅད་ལ་བལྟས་ནས་དེ་རིང་ཁྱེད་ཀྱི་མདུན་དུ་ངས་ང་ལ་སྐྱོན་མེད་པའི་སྐོར་ཤོད་པར་ཤིན་ཏུ་དགའོ། ");
INSERT INTO bod_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","གང་ཡིན་ཟེར་ན། སྐུ་ཉིད་ཀྱིས་ཡ་ཧུ་དཱ་པའི་ལུགས་སྲོལ་དང་རྩོད་གླེང་ཐམས་ཅད་ལེགས་པར་མཁྱེན་པས་སོ། ཁྱེད་ཀྱིས་ཐུགས་རྒྱུད་རིང་པོས་ང་ལ་གསན་རོགས་གནང༌། ");
INSERT INTO bod_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ང་ཆུང་དུས་ནས་ངའི་མི་རིགས་ཀྱི་ཁྲོད་དང༌། ཡེ་རུ་ཤ་ལེམ་དུ་བསྡད་པ་ནས་བཟུང་ངའི་སྤྱོད་ལམ་ཅི་ལྟར་ཡིན་པ་དེ་ཡ་ཧུ་དཱ་པ་ཐམས་ཅད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ང་ངོ་ཤེས་ནས་ཡུན་རིང་ཕྱིན་པས། ངེད་རྣམས་ཀྱི་ཆོས་ལུགས་ཀུན་ལས་ཀྱང་ནན་པའི་རུ་ཚོགས་ཤིག་སྟེ་ཕཱ་རུ་ཤི་པ་ལྟར་ངས་མི་ཚེ་བསྐྱལ་བར་གལ་སྲིད་ཁོ་ཚོས་བདེན་དཔང་བྱེད་འདོད་ན་བྱེད་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","དཀོན་མཆོག་གིས་ངེད་རྣམས་ཀྱི་མེས་པོ་རྣམས་ལ་ཞལ་གྱིས་བཞེས་པའི་མནའ་ལ་ངས་ཡིད་རྟོན་བྱས་པའི་རྐྱེན་གྱིས་ད་ལྟ་ཁྲིམས་གཅོད་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ངེད་རྣམས་ཀྱི་ཚོ་ཁག་བཅུ་གཉིས་ཀྱིས་ཉིན་མཚན་མེད་པར་དཀོན་མཆོག་ལ་བརྩོན་སེམས་ཀྱིས་བསྙེན་བཀུར་ཞུ་བཞིན་ཞལ་ཆད་དེ་འགྲུབ་པའི་རེ་བ་བྱེད། མི་རྗེ་ཨག་རི་པཱ་ལགས། དོན་དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ང་ལ་ནག་ཉེས་འཛུགས། ");
INSERT INTO bod_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ཁྱེད་ཚོའི་ནང་ནས་སུ་ཞིག་གིས་དཀོན་མཆོག་གིས་གཤིན་པོ་རྣམས་སླར་གསོན་པར་མཛད་པར་ཡིད་ཆེས་བྱེད་མི་སྲིད་སྙམ་པ་དེ་ཅིའི་ཕྱིར། ");
INSERT INTO bod_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ངས་ཀྱང་ན་ཙ་རེལ་པ་ཡེ་ཤུའི་མཚན་ལ་རྒོལ་ཅི་ཐུབ་བྱེད་དགོས་པར་བསམས་པས། ");
INSERT INTO bod_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ཡེ་རུ་ཤ་ལེམ་ལ་དེ་ལྟར་བྱས། བླ་ཆེན་གྱི་དབང་ཐོབ་ནས་ངས་དད་ལྡན་མང་པོ་བཙོན་དུ་བཅུག་པ་མ་ཟད། ཁོ་ཚོ་སྲོག་ཁྲིམས་གཏོང་བར་ངས་ཀྱང་མོས་པ་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ཡ་ཧུ་དཱ་པའི་འདུ་ཁང་རེ་རེའི་ནང་ངས་ཁོ་ཚོར་ཉེས་ཆད་ཐེངས་མང་བཅད་དེ་ཁོ་ཚོས་སྐུར་བ་འདེབས་སུ་བཅུག་པའི་ཐབས་བཙལ། ཁོང་ཁྲོ་ཚད་མེད་ལངས་ནས་ངས་ཕྱི་པའི་གྲོང་ཁྱེར་ལའང་གནོད་འཚེ་བྱེད་ཆེད་ཁོ་ཚོ་རྗེས་སུ་བསྙེགས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","དེ་ལྟར་བྱེད་པའི་དུས་སུ། ང་ལ་བླ་ཆེན་གྱི་དབང་དང་ཆོག་མཆན་ཐོབ་སྟེ་དཱ་མེ་སེག་གྲོང་ཁྱེར་དུ་འགྲོ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","རྒྱལ་པོ་ཨག་རི་པཱ་ལགས། ལམ་བར་དུ་ཉིན་གུང་ཞིག་ལ་ངས་ནམ་མཁའ་ནས་ཉི་མའི་འོད་ལས་ཆེ་བ་ཞིག་ང་དང་ངའི་ལམ་གྲོགས་ཀྱི་ཕྱོགས་བཞིར་འཕྲོས་པར་མཐོང༌། ");
INSERT INTO bod_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ང་ཚོ་ཚང་མ་ས་ལ་འགྱེལ་དུས། ཡ་ཧུ་དཱ་པའི་སྐད་ནས་ང་ལ། ཤ་ཨུལ། ཤ་ཨུལ། ཁྱོད་ཀྱིས་ང་ལ་ཅིའི་ཕྱིར་གནོད་སྐྱེལ། ཕྱུགས་རྫིའི་ལྕག་ཚན་ལ་རྡོག་རྒྱག་བཞུས་ན་ཁྱོད་ལ་གནོད་པ་ཡོང་ཞེས་གསུངས་པའི་སྒྲ་ཞིག་ཐོས་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ངས་གཙོ་བོ་ལགས། ཁྱེད་སུ་ཡིན་ཞེས་བཤད་པས་ཁོང་གིས་ང་ནི་ཁྱོད་ཀྱིས་གནོད་སྐྱེལ་བཞིན་པ་ཡེ་ཤུ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ད་ཡར་ལོངས་ཤིག ཁྱོད་ཀྱིས་གང་མཐོང་བ་འདི་དང༌། ངས་ཁྱོད་ལ་སྟོན་པར་འགྱུར་བའི་དོན་ལ་དཔང་པོ་བྱེད་ཅིང༌། ཁྱོད་ནི་ངའི་གཡོག་པོར་སྐོ་བའི་ཆེད་དུ་མངོན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","18","ངས་ཁྱོད་ཁྱོད་ཀྱི་མི་རིགས་དང༌། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་དབང་ལས་སྒྲོལ་བར་བྱ། ཁོ་ཚོའི་མིག་འབྱེད་པ་དང༌། མུན་པ་ལས་འོད་སྣང་ཕྱོགས་སུ་སྤོ་ཞིང༌། བདུད་སཱ་ཏན་གྱི་དབང་ལས་དཀོན་མཆོག་གི་ཕྱོགས་སུ་སེམས་བསྒྱུར་བའི་ཆེད་དུ་ངས་ཁྱོད་ཁོ་ཚོའི་རྩར་མངགས་པར་བྱ། དེ་ནི་ཁོ་ཚོའི་སྡིག་པ་སེལ་བ་དང༌། ང་ལ་དད་པ་བྱེད་པའི་སྒོ་ནས་དམ་པ་རུ་འགྱུར་བ་རྣམས་ཀྱི་ཁྲོད་ལ་གནས་ཤིག་ཐོབ་པའི་ཕྱིར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ཀྱེ་རྒྱལ་པོ་ཨག་རི་པཱ་ལགས། དེ་ནས་ངས་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་བྱུང་བའི་ཞལ་གཟིགས་བཞིན་དུ་སྒྲུབས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ཐོག་མར་དཱ་མེ་སེག་གྲོང་ཁྱེར་དང༌། གཉིས་པར་ཡེ་རུ་ཤ་ལེམ། ཡ་ཧུ་དཱ་ཡུལ་ཀུན། མཐའ་མར་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལའང་དེ་ཚོས་སྤྱོད་པ་ངན་པ་སྤངས་ཏེ་སེམས་དཀོན་མཆོག་གི་ཕྱོགས་སུ་བསྒྱུར་ནས། དེ་དང་མཐུན་པའི་བྱ་བ་བྱེད་དགོས་པར་བསྒྲགས། ");
INSERT INTO bod_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པ་ཁ་ཅིག་གིས་མཆོད་ཁང་གི་ཁྱམས་རར་ང་འཛིན་བཟུང་བྱས་ནས་གསོད་པའི་ཐབས་བཙལ། ");
INSERT INTO bod_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","དེ་རིང་གི་བར་དུ་དཀོན་མཆོག་གིས་བསྲུངས་པར་མཛད་པས་ངས་མི་མཐོ་དམན་གཉིས་ཀ་ལ་བདེན་དཔང་བྱེད་བཞིན་འདིར་ལངས་ནས་སྡོད། མོ་ཤེ་ཚུད་པའི་ལུང་སྟོན་པ་རྣམས་ཀྱིས་གསུངས་པ་ལྟར་གང་འབྱུང་བར་འགྱུར་བའི་དོན་ཁོ་ནར་སྨྲ་སྟེ། ");
INSERT INTO bod_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","མཱ་ཤི་ཀ་ཁོང་ནི་སྡུག་བསྔལ་མྱོང་དགོས་པ་དང༌། འཆི་བ་ནས་སླར་གསོན་པོར་འགྱུར་བའི་ཐོག་མ་དེ་ཡིན་པའི་སྒོ་ནས་ཡ་ཧུ་དཱ་པ་དང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལའང་འོད་སྣང་ལྡན་པའི་འཕྲིན་བཟང་སྒྲོག་མཁན་དུ་འགྱུར་བ་དེ་ཡིན་ནོ་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","པའུ་ལུས་དེ་ལྟར་གསུངས་པའི་དུས་སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ཡིས་སྐད་ཆེན་པོས་“པའུ་ལུ། ཁྱོད་སྦྱངས་པ་བྱེད་རྒྱུ་མང་དྲགས་པས་སྨྱོས་སོ་”ཞེས་བཤད་ནས། ");
INSERT INTO bod_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","པའུ་ལུས་“མི་རྗེ་ཕེ་སི་ཏུ་ལགས། ང་སྨྱོ་བ་མིན་ཏེ་བདེན་པ་དང་ཁ་གསལ་བའི་གཏམ་སྨྲ། ");
INSERT INTO bod_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","གང་ལགས་ཤེ་ན། དོན་དེ་རྣམས་ལྐོག་ཏུ་མ་བསྒྲུབས་པས་རྒྱལ་པོས་དེ་ལ་ངེས་པར་དོ་སྣང་བྱས་ཏེ་མཁྱེན་པས་ངས་འཇིགས་པ་མེད་པའི་སྒོ་ནས་ཁོང་ལ་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","རྒྱལ་པོ་ཨག་རི་པཱ་ལགས། ཁྱེད་ཀྱིས་ལུང་སྟོན་པ་རྣམས་ལ་ཐུགས་ཆེས་སམ། ཁྱེད་ཀྱིས་ཐུགས་ཆེས་པ་ངས་ཤེས་”ཞེས་གསུངས་པས། ");
INSERT INTO bod_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ལན་དུ་ཨག་རི་པཱ་ཡིས་པའུ་ལུ་ལ་“ཁྱོད་ཀྱིས་ང་ལ་དུས་ཅུང་ཟད་བསྐུལ་བ་ཙམ་གྱིས་ང་མཱ་ཤི་ཀ་པ་ཞིག་ཏུ་འགྱུར་བར་འདོད་དམ་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","པའུ་ལུས་“དུས་ཅུང་ཟད་དམ་རིང་པོ་ཅི་ཡིན་རུང༌། ཁྱེད་རང་མ་ཟད་ངའི་གཏམ་ལ་དེ་རིང་གསན་མཁན་ཐམས་ཅད་ལྕགས་ཐག་འདི་མ་གཏོགས་པར་ང་དང་འདྲ་བར་འགྱུར་བ་དེ་ངས་དཀོན་མཆོག་ལ་སྨོན་ལམ་འདེབས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","རྒྱལ་པོ་དང༌། སྤྱི་ཁྱབ། པུར་ནི་ཀཱེ་ལ་སོགས་པའི་དེར་སྡོད་ཡོད་པ་རྣམས་ཡར་ལངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ཕྱིར་ཐོན་དུས་ཁོ་ཚོས་གཅིག་གིས་གཅིག་ལ་“མི་འདིས་སྲོག་ཁྲིམས་གཏོང་བའམ་བཙོན་དུ་བཅུག་དགོས་པའི་བྱ་བ་ཅིའང་བྱས་མེད་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","རྒྱལ་པོ་ཨག་རི་པཱ་ཡིས་སྤྱི་ཁྱབ་ཕེ་སི་ཏུ་ལ་“མི་འདིས་གོང་མའི་རྒྱལ་པོ་སེ་སར་ལ་སྙན་ཞུ་ཕུལ་མེད་ན། གྲོལ་བར་འགྱུར་རོ་”ཞེས་སྨྲས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ངེད་རྣམས་གྲུ་གཟིངས་ལ་བསྡད་ནས་དབྱི་ཏ་ལི་ཡུལ་ལ་འགྲོ་བར་ཐག་གཅོད་བྱས་པའི་ཚེ། ཁོ་ཚོས་པའུ་ལུ་བཙོན་པ་གཞན་ཁ་ཅིག་དང་བཅས་པར་ཨུ་རྒ་ཟི་ཏུ་ཞེས་པའི་དམག་ཁག་གི་བརྒྱ་དཔོན་ཡུ་ལི་ཡུ་ཟེར་བ་ཞིག་གི་དབང་དུ་གཏད། ");
INSERT INTO bod_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","མ་ཀེ་དོན་ཡཱ་ཡུལ་གྱི་ཐེ་ས་ལོ་ནི་ཀེ་གྲོང་ཁྱེར་ནས་ཡིན་པའི་ཨ་རིས་ཐར་ཀུ་ང་ཚོ་དང་བཅས་པར། ཨེ་ཞེ་ཡཱ་ཞིང་ཆེན་གྱི་མཚོ་འགྲམ་བརྒྱུད་དེ་འགྲོ་བའི་ཨད་ར་མི་ཏི་གྲུ་ཁའི་གྲུ་གཟིངས་ལ་བསྡད་ནས་ཐོན། ");
INSERT INTO bod_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","དེའི་ཕྱི་ཉིན་ཚི་དོན་གྲུ་ཁར་སླེབས་ནས་བརྒྱ་དཔོན་ཡུ་ལི་ཡུ་ཡིས་པའུ་ལུ་ལ་གཟིགས་སྐྱོང་གནང་སྟེ་གྲོགས་པོ་རྣམས་ཀྱིས་ཁོང་ལ་སྣེ་ལེན་བྱེད་པའི་ཆེད་དུ་ཁོ་ཚོའི་རྩར་ཕེབས་སུ་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","དེ་ནས་ངེད་རྣམས་གྲུ་གཟིངས་ལ་བསྡད་པ་དང༌། གྲུ་གཟིངས་ཀྱི་མདུན་ཕྱོགས་ནས་ལྷགས་པ་བརྒྱབ་པས་ཀིབ་རུ་གླིང་ཕྲན་གྱི་ལྷགས་པ་མེད་པའི་ཕྱོགས་སུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ཀི་ལིག་ཡཱ་དང་ཕམ་ཕིལ་ཡཱ་ཡུལ་གཉིས་ཀྱི་མཚོ་བརྒལ་ནས་ངེད་རྣམས་ལིག་ཡཱ་ཞིང་ཆེན་གྱི་གྲུ་ཁར་མུ་རཱ་ལ་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","དེར་བརྒྱ་དཔོན་ལ་དབྱི་ཏ་ལི་ཡུལ་ལ་འགྲོ་བའི་ཨ་ལིག་ཟན་དྲི་ཡཱ་གྲོང་ཁྱེར་ནས་ཡོང་བའི་གྲུ་གཟིངས་ཤིག་རྙེད་པ་དང༌། ངེད་རྣམས་དེའི་ནང་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ངེད་རྣམས་གྲུ་གཟིངས་ལ་ཉི་མ་མང་པོ་འགོར་ཞིང་དཀའ་ངལ་ཆེན་པོ་བྱུང་སྟེ་གཞི་ནས་ནི་དུ་ཞེས་པའི་གྲོང་ཁྱེར་གྱི་ཉེ་འཁོར་དུ་སླེབས། རླུང་གིས་བཀག་རྒྱ་ཐེབས་ཏེ་མདུན་དུ་འགྲོ་མ་ཐུབ་པས། ཀེ་རེ་ཊེ་གླིང་ཕྲན་གྱི་སྣེ་མོ་སལ་མོ་ནཱེ་བར་དུ་ལྷགས་པ་མེད་པའི་ཕྱོགས་སུ་ཕྱིན། ");
INSERT INTO bod_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ང་ཚོ་དཀའ་ཚེགས་ཆེན་པོའི་སྒོ་ནས་མཚོ་འགྲམ་བརྒྱུད་དེ་ལ་སེ་ཡཱ་གྲོང་ཁྱེར་དང་ཉེ་བའི་གྲུ་ཁ་བདེ་ཅན་ཞེས་བྱ་བའི་ས་ཆར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ལམ་བར་དུ་དུས་ཚོད་མང་པོ་འགོར་བ་དང༌། གྲུ་གཟིངས་ལ་བསྡད་དེ་བསྐྱོད་པའི་ཉེན་ཁ་ཆེ་བ། དེ་བཞིན་སྨྱུང་གནས་སྲུང་བའི་དུས་ཆེན་ཚར་ཟིན་པས་པའུ་ལུས་ཁོ་ཚོར་བསྐུལ་ཏེ་ ");
INSERT INTO bod_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“སྐུ་ཞབས་རྣམས། ཆུ་ཐོག་གི་འགྲུལ་བཞུད་འདི་ནི་གྲུ་གཟིངས་དང་དོས་པོ་ལ་གཏོར་བཤིག་ཐེབས་པ་དང༌། ངེད་རྣམས་ཀྱི་སྲོག་ལའང་ཉེན་ཁ་ཆེན་པོ་ཡོད་པར་ངས་ཤེས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","འོན་ཀྱང་བརྒྱ་དཔོན་དེས་པའུ་ལུས་གང་གསུངས་པ་ལས་གྲུ་དཔོན་དང་གྲུ་གཟིངས་ཀྱི་བདག་པོ་གཉིས་ཀྱིས་གང་བཤད་པ་ལ་དོ་སྣང་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","དགུན་ཁར་གྲུ་ཁ་དེ་སྡོད་པར་མི་བདེ་བས་མི་མང་ཆེ་བས་ཕར་འགྲོ་བར་ཐག་གཅོད་བྱས། ཁོ་ཚོས་ཕེ་ནི་ཀཱེ་ལ་སླེབས་ནས་དེ་ལ་དགུན་ཁ་སྡོད་པར་རེ་བ་བྱས། ས་ཆ་དེ་ནི་ཀེ་རེ་ཊེ་གླིང་ཕྲན་གྱི་མཚོ་ཁ་ཞིག་ཡིན་ཏེ་ལྷོ་ནུབ་དང་ནུབ་བྱང་ལ་ཁ་ཕྱོགས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ལྷོ་ཕྱོགས་ནས་རླུང་འཇམ་པོ་ཞིག་བྱུང་བའི་ཚེ་ཁོ་ཚོའི་དོན་སྒྲུབ་པར་སྙམ་པས། གྲུ་གཟིངས་ཀྱི་གཏིང་རྡོ་ཡར་དྲངས་ནས་ཀེ་རེ་ཊེ་གླིང་ཕྲན་གྱི་མཚོ་འགྲམ་དང་ཉེ་བར་སོང༌། ");
INSERT INTO bod_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","དེ་ནས་ཅུང་མ་འགོར་བར་བྱང་ཤར་བ་ཞེས་བྱ་བའི་ལྷགས་པ་དྲག་པོ་ཞིག་ཀེ་རེ་ཊེ་གླིང་ཕྲན་ནས་རྒྱག་པར་བརྩམས། ");
INSERT INTO bod_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","རླུང་དེས་གྲུ་གཟིངས་བཟུང་ནས་དེའི་ཕྱོགས་སུ་ཁ་ལོ་སྒྱུར་མ་ཐུབ་པས་རླུང་གིས་གང་སར་འདེད། ");
INSERT INTO bod_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ཀའུ་དཱ་ཞེས་པའི་གླིང་ཕྲན་ཆུང་བ་ཞིག་གི་ལྷགས་པ་མེད་པའི་ཕྱོགས་སུ་ཕྱིན་ཏེ་གྲུ་གཟིངས་ཀྱི་གྲུ་ཆུང་བ་དེ་དམ་པོར་བཟུང་ནས། ");
INSERT INTO bod_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","དཀའ་ལས་ཆེན་པོ་དང་བཅས་ཏེ་ཡར་དྲངས་ནས་གྲུ་གཟིངས་ལ་བཞག དེ་ནས་གྲུ་གཟིངས་མི་འཇིག་པའི་ཕྱིར་དེར་ཐག་པ་ཡིས་བསྡམས། སིར་ཏི་ཞེས་བྱ་བའི་ཆུ་གཏིང་ཐུང་སར་གྲུ་གཟིངས་ཆག་པའི་འཇིགས་པ་སྐྱེས་ཏེ་ཁོ་ཚོས་གྲུ་གཟིངས་ཀྱི་དར་པོ་ཆེ་རྣམས་ཕབ་ནས་གྲུ་གཟིངས་རླུང་གིས་འཁྱེར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","དེའི་སང་ཉིན་ལྷགས་པ་དྲག་པོས་གྲུ་གཟིངས་ཤིན་ཏུ་གཡོ་བས་ཁོ་ཚོས་དོས་པོ་མཚོ་ནང་དུ་གཡུག་པར་བརྩམས། ");
INSERT INTO bod_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ཉི་མ་གསུམ་པར་ཁོ་ཚོ་རང་གིས་གྲུ་གཟིངས་སྟེང་གི་ཡོ་ཆས་མཚོ་ནང་དུ་གཡུགས། ");
INSERT INTO bod_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ཉིན་མང་པོའི་རིང་ཉི་མ་དང་སྐར་མ་མི་མཐོང་ཞིང་རླུང་འཚུབ་དྲག་པོ་མུ་མཐུད་བརྒྱབ་པས། མཇུག་ཏུ་ང་ཚོ་ལས་སྲོག་ཐར་བའི་རེ་བ་ཟད་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ཡང་ཁོ་ཚོས་དུས་ཚོད་རིང་པོ་ཁ་ལག་མ་བཟས་པས་པའུ་ལུ་དེ་རྣམས་ཀྱི་དཀྱིལ་ལ་བཞེངས་ནས་“སྐུ་ཞབས་རྣམས། ངས་སྔར་སྨྲས་པའི་གཏམ་ལ་ཉན་ཏེ། ཀེ་རེ་ཊེ་ནས་མ་ཐོན་ན་གནོད་འཚེ་དང་གཏོར་བཤིག་འདི་འདྲ་མྱོང་མེད། ");
INSERT INTO bod_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ད་ངས་ཁྱེད་ཚོར་སེམས་མ་འཇིགས་པར་སྐུལ། གང་ཡིན་ཞེ་ན། གྲུ་གཟིངས་བཤིག་པར་འགྱུར་ན་ཡང༌། ཁྱེད་ཚོ་ཚང་མ་ཐར་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","རྒྱུ་མཚན་ནི་མདང་དགོང་ངས་བསྙེན་བཀུར་ཞུས་པའི་བདག་པོ་དཀོན་མཆོག་གི་ཕོ་ཉ་ཞིག་གིས་ངའི་མདུན་དུ་བཞེངས་ཏེ་འདི་ལྟར་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","པའུ་ལུ། མ་འཇིགས་ཤིག ཁྱོད་ནི་རྒྱལ་པོ་སེ་སར་གྱི་དྲུང་དུ་འགྲོ་དགོས་ཏེ། ལྟོས་ཤིག གྲུ་གཟིངས་ནང་ཁྱོད་དང་མཉམ་དུ་འགྲོ་བ་ཐམས་ཅད་ལ་དཀོན་མཆོག་གིས་བདེ་འཇགས་གནང་བ་ཡིན་ནོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","དཀོན་མཆོག་གིས་གང་གསུངས་པ་བཞིན་དུ་མཛད་པར་ངས་ཡིད་ཆེས་བྱེད་པས། མ་འཇིགས་ཤིག ");
INSERT INTO bod_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","འོན་ཀྱང་རླུང་གིས་གྲུ་གཟིངས་གླིང་ཕྲན་ཞིག་གི་མཚོ་འགྲམ་ལ་འདེད་པར་འགྱུར་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ཨ་དྲི་ཡཱ་ཞེས་པའི་རྒྱ་མཚོར་རླུང་གིས་གྲུ་གཟིངས་འདེད་དེ་མཚན་མོ་བཅུ་བཞི་པའི་ནམ་ཕྱེད་ཙམ་ལ་གྲུ་པས་སྐམ་ས་དང་ཉེ་བ་ཞིག་ལ་སླེབས་པར་སྙམ། ");
INSERT INTO bod_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","གཏིང་ཚད་འཇལ་བས་སྨི་གསུམ་ཅུ་སོ་བདུན་ཙམ་ཡོད། ཏོག་ཙམ་སོང་ནས་ཡང་སྐྱར་འཇལ་བས་གཏིང་ཚད་སྨི་ཉི་ཤུ་རྩ་བདུན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","གྲུ་གཟིངས་བྲག་ལ་ཐོགས་པའི་འཇིགས་པ་སྐྱེས་ཏེ་ཁོ་ཚོས་གྲུ་གཟིངས་ཀྱི་མཇུག་ནས་གཏིང་རྡོ་བཞི་ཕབ་སྟེ་ནམ་ལངས་པར་རེ་སྒུག་བྱེད། ");
INSERT INTO bod_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","གྲུ་མགོ་ནས་གཏིང་རྡོ་འབེབས་པའི་ཁུལ་བྱས་ཏེ་གྲུ་གཟིངས་ལས་ཐར་བའི་ཕྱིར་གྲུ་པས་གྲུ་ཆུང་རྒྱ་མཚོར་ཕབ། ");
INSERT INTO bod_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","པའུ་ལུས་བརྒྱ་དཔོན་དང་དམག་མི་རྣམས་ལ་“མི་དེ་ཚོ་གྲུ་གཟིངས་ནང་ལ་མ་བསྡད་ན། ཁྱེད་ཚོ་སྲོག་ཐར་བར་འགྱུར་མི་སྲིད་”ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","དམག་མིས་གྲུ་ཆུང་གི་ཐག་པ་བཅད་ནས་རྒྱ་མཚོར་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ནམ་ལངས་པའི་ཙམ་ལ་པའུ་ལུས་མི་ཚང་མར་ཟས་ཟ་བར་བསྐུལ་ཏེ་“ཁྱེད་ཚོས་སེམས་ཁྲལ་བྱས་ཏེ་དེ་རིང་ཟས་མ་བཟས་པའི་ཉིན་བཅུ་བཞི་པ་ཡིན་པས། ");
INSERT INTO bod_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ངས་ཁྱེད་རྣམས་ལ་ཁ་ལག་ཟ་བར་སྐུལ། དེ་ནི་ཁྱེད་རྣམས་གསོན་པོར་གནས་པའི་ཆེད་དུ་ཡིན། གང་ཡིན་ཟེར་ན། ཁྱེད་ཚོའི་སྐྲའི་ཉག་མ་གཅིག་ཀྱང་འཇིག་པར་མི་འགྱུར་”ཞེས་གསུངས་ནས། ");
INSERT INTO bod_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","བག་ལེབ་བླངས་ནས་ཁོ་ཚོ་ཚང་མའི་མདུན་དུ་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་པ་དང༌། དུམ་བུར་བཟོས་ནས་བཞེས་པར་བརྩམས། ");
INSERT INTO bod_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ཁོང་ཚོ་ཚང་མ་སེམས་བདེ་བར་གྱུར་ཏེ་ཁ་ལག་བཟས། ");
INSERT INTO bod_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(གྲུ་གཟིངས་ནང་ལ་ང་ཚོ་ཁྱོན་བསྡོམས་མི་གྲངས་ཉིས་བརྒྱ་བདུན་ཅུ་དོན་དྲུག་ཡོད་) ");
INSERT INTO bod_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ཁོ་ཚོས་བཟས་ནས་ལྟོ་བ་ཁེངས་རྗེས། གྲུ་གཟིངས་ཡང་པོ་ཡོང་བའི་ཕྱིར་གྲོ་རྣམས་རྒྱ་མཚོར་འཕངས། ");
INSERT INTO bod_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ནམ་ལངས་པའི་ཚེ་ས་ཆ་དེ་གང་ཡིན་མ་ཤེས་ཀྱང༌། ཁོ་ཚོས་བྱེ་མ་ཡོད་པའི་མཚོ་ཁུག་མཐོང་བས། དེར་བཏང་ཐུབ་ན་གྲུ་གཟིངས་གཏོང་བར་བསམས། ");
INSERT INTO bod_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","གཏིང་རྡོ་རྣམས་ཀྱི་ཐག་པ་བཅད་དེ་རྒྱ་མཚོར་བཞག་པ་དང་ཆབས་ཅིག་ཁོ་ཚོས་མཇུག་གི་སྐྱ་བོའི་ཐག་པ་བཀྲོལ། མདུན་གྱི་གྲུ་གཟིངས་ཀྱི་དར་པོ་ཆེ་རླུང་དང་བསྟུན་ནས་ཡར་བཀྱགས་པ་དང་སྐམ་སའི་ཕྱོགས་སུ་གྲུ་གཟིངས་བཏང༌། ");
INSERT INTO bod_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ཆུ་གཏིང་ཐུང་སར་བྲག་ལ་ཐོགས་ནས་གྲུ་གཟིངས་འགུལ་རྒྱུ་མེད་པར་གྱུར་ཞིང༌། གྲུ་མགོ་བརྟན་པོར་ལུས་ཏེ་རྦ་རླབས་ཤུགས་ཀྱིས་གྲུ་མཇུག་ལ་གཏོར་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","བཙོན་པ་སུ་ཞིག་ཀྱང་རྐྱལ་བརྒྱབ་ནས་མི་འབྲོས་པའི་ཆེད་དུ་དམག་མི་ཚོས་ཁོ་རྣམས་གསོད་པར་བསམས་ཀྱང༌། ");
INSERT INTO bod_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","བརྒྱ་དཔོན་གྱིས་པའུ་ལུ་ཐར་བར་བྱེད་འདོད་པས་འཆར་གཞི་དེ་བཀག་པ་དང༌། ཐོག་མར་རྐྱལ་རྒྱག་ཐུབ་མཁན་ཚང་མ་རྒྱ་མཚོར་མཆོངས་ནས་སྐམ་སར་རྐྱལ་རྒྱག་དགོས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","གཞན་རྣམས་པང་ལེབ་དང་གྲུ་གཟིངས་ཀྱི་ཆག་དུམ་བཟུང་ནས་ཁོ་ཚོའི་རྗེས་སུ་འབྲངས་དགོས་པའི་བཀའ་བཏང༌། དེ་ལྟར་མི་ཚང་མ་ཉེན་ཁ་ལས་ཐར་ཏེ་སྐམ་སར་སླེབས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ང་ཚོ་ཐར་བར་གྱུར་ནས་ངེད་རྣམས་ཀྱིས་གླིང་ཕྲན་དེའི་མིང་ལ་མེ་ལི་ཊེ་ཞེས་ཟེར་གྱི་ཡོད་པ་ཤེས། ");
INSERT INTO bod_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","གླིང་ཕྲན་སྟེང་གནས་པའི་མི་རྣམས་ཀྱིས་ངེད་རྣམས་ལ་དྲིན་ཆེན་པོ་བྱས། ཆར་པ་བབས་ནས་གནམ་གཤིས་གྲང་མོ་ཆགས་པས་ཁོ་ཚོས་མེ་ཞིག་བཏང་ནས་ང་ཚོ་ཚང་མར་སྣེ་ལེན་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","པའུ་ལུས་མེ་ཤིང་ཧྲུག་པོ་བསྒྲུགས་ཏེ་མེར་བུད་པ་དང༌། མེ་ཡིས་བསྐྲད་པའི་དུག་སྦྲུལ་ཞིག་པའུ་ལུའི་ཕྱག་ལ་འབྱར། ");
INSERT INTO bod_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ཡུལ་དེའི་མི་རྣམས་ཀྱིས་སྦྲུལ་དེ་ཁོང་གི་ཕྱག་ནས་འཕྱངས་པར་མཐོང་ནས་གཅིག་གིས་གཅིག་ལ་“མི་འདི་ནི་ལག་དམར་བ་ཞིག་ཡིན་པར་ཐེ་ཚོམ་མེད། རྒྱ་མཚོ་ལས་ཐར་ཡང༌། གཞུང་དྲང་ཟེར་བའི་ལྷ་མོས་ཁོ་གསོན་པོར་མི་འཇོག་”ཅེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ཁོང་གིས་སྦྲུལ་དེ་མེའི་ནང་དུ་སྤྲུགས་ནས་ཁོང་ལ་གནོད་པ་ཅི་ཡང་མ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","མི་དེ་ཚོས་ཁོང་གི་སྐུ་གཟུགས་སྐྲང་བའམ་གློ་བུར་དུ་ས་ལ་འགྱེལ་ནས་ཤི་བར་འགྱུར་སྙམ་ཡང༌། ཡུན་རིང་བསྒུགས་ནས་གནོད་པ་ཅིའང་མ་བྱུང་བ་མཐོང་བས་སེམས་བསྒྱུར་ཏེ་ཁོ་ཚོས་ཁོང་ལྷ་ཞིག་ཡིན་པར་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","གླིང་ཕྲན་དེའི་ས་གནས་དཔོན་པོ་པུབ་ལི་ཡུ་ཞེས་ཟེར་མཁན་ཞིག་གི་གཞིས་ཀ་ཉེ་འཁོར་དུ་ཡོད་དེ། ཁོས་ངེད་རྣམས་བསུས་ནས་ཉིན་གསུམ་རིང་སྣེ་ལེན་བྱས། ");
INSERT INTO bod_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","སྐབས་དེ་དུས་པུབ་ལི་ཡུ་ཡི་ཕ་ནི་ཚ་བ་རྒྱས་པ་དང་བཤལ་ནད་ཕོག་སྟེ་ཉལ་ཁྲིའི་སྒང་ལ་ལུས་ཡོད། པའུ་ལུ་ཁོའི་རྩར་ཕེབས་ཏེ། སྨོན་ལམ་བཏབ་ནས་ཕྱག་ཁོའི་སྟེང་ལ་བཞག་སྟེ་ནད་ལས་ཐར་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","དེ་ལྟར་བྱུང་བའི་རྗེས་སུ་གླིང་ཕྲན་སྟེང་གི་ནད་པ་གཞན་རྣམས་ཀྱང་ཁོང་གི་མདུན་དུ་ཡོང་ནས་ནད་ལས་ཐར་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ཁོ་རྣམས་ཀྱིས་ང་ཚོར་བཀུར་སྟི་མང་པོ་བྱས་པ་དང༌། གྲུ་གཟིངས་ལ་འགྲོ་བའི་སྐབས་ངེད་རྣམས་ལ་མཁོ་བ་ཚང་མ་གྲུ་གཟིངས་ནང་བཞག ");
INSERT INTO bod_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ཟླ་བ་གསུམ་འགོར་རྗེས། ང་ཚོ་ཨ་ལིག་ཟན་དྲི་ཡཱ་གྲོང་ཁྱེར་ནས་ཡོང་བའི་གྲུ་གཟིངས་ཤིག་ལ་བསྡད་ནས་ཕྱིན། གྲུ་གཟིངས་དེ་དགུན་ཁ་གླིང་ཕྲན་དེར་བསྡད་ཅིང་དེའི་གྲུ་མགོར་མཚེ་མ་ཞེས་ཟེར་བའི་ལྷ་ཡི་རྟགས་ཤིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","སི་ར་ཀུ་སེ་ཞེས་པའི་གྲོང་ཁྱེར་ལ་སླེབས་ནས་དེར་ཉི་མ་གསུམ་བསྡད། ");
INSERT INTO bod_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","དེ་ནས་གྲུ་གཟིངས་ལ་བསྡད་དེ་རེ་གི་ཡོན་གྲོང་ཁྱེར་དུ་སླེབས། དེའི་སང་ཉིན་ལྷོ་རླུང་ལྡངས་ཤིང༌། ཉི་མ་གཉིས་པར་ངེད་རྣམས་པུ་ཏེའོ་ལི་ཞེས་པའི་གྲུ་ཁར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","དེར་ཡོད་པའི་སྤུན་ཟླ་རྣམས་དང་ཕྲད་དེ་ཁོ་ཚོས་གདན་འདྲེན་ཞུས་ནས་ངེད་རྣམས་ཉི་མ་བདུན་དེར་བསྡད། དེ་འདྲའི་ངང་ནས་ངེད་རྣམས་རོ་མཱ་རྒྱལ་སར་སླེབས། ");
INSERT INTO bod_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","དེར་ཡོད་པའི་སྤུན་ཟླ་རྣམས་ཀྱིས་ངེད་རྣམས་ཀྱི་སྐོར་ཐོས་པས་ཨ་པི་ཡུ་ཞེས་པའི་ཚོང་ར་དང༌། མགྲོན་ཁང་གསུམ་ཞེས་པའི་གནས་ཀྱི་བར་དུ་ང་ཚོ་བསུ་བར་ཡོང༌། པའུ་ལུས་ཁོ་རྣམས་གཟིགས་པས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུས་པ་དང༌། སྙིང་སྟོབས་དང་ལྡན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","རྒྱལ་ས་རོ་མཱ་ལ་སླེབས་ནས་པའུ་ལུ་དང་དམག་མི་སྲུང་མཁན་གཅིག་མཉམ་དུ་སྒེར་གྱི་ཁང་པ་ཞིག་ལ་བཞུགས་པར་བཅུག ");
INSERT INTO bod_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ཉི་མ་གསུམ་གྱི་རྗེས་སུ་པའུ་ལུས་ཡ་ཧུ་དཱ་པའི་འགོ་ཁྲིད་པ་རྣམས་བོས་པ་དང༌། འཛོམས་ནས་ཁོང་གིས་ཁོ་ཚོར་“སྤུན་ཟླ་རྣམས། ངས་ངེད་རྣམས་ཀྱི་མི་རིགས་སམ། མེས་པོའི་ལུགས་སྲོལ་དང་འགལ་བའི་ལས་ཅིའང་མ་བྱས་ཀྱང༌། ང་ཡེ་རུ་ཤ་ལེམ་ལ་འཛིན་བཟུང་བྱས་ཏེ་རོ་མཱ་པའི་ལག་ཏུ་གཏད། ");
INSERT INTO bod_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ཁོ་ཚོས་འདྲི་གཅོད་བྱས་པའི་རྗེས་སུ་ང་གློད་གྲོལ་གཏོང་བར་འདོད། གང་ཡིན་ཞེ་ན། སྲོག་ཁྲིམས་གཏོང་དགོས་པའི་རྒྱུ་རྐྱེན་ཅིའང་མ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","འོན་ཀྱང་ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་ང་གློད་གྲོལ་གཏོང་བར་ངོ་རྒོལ་བྱས་པས། གོང་མའི་རྒྱལ་པོ་སེ་སར་ལ་སྙན་སེང་མི་ཞུ་ཐབས་མེད་བྱུང༌། འོན་ཏེ་ངའི་མི་རིགས་ལ་ཉེས་འཛུགས་བྱེད་རྒྱུ་ཅིའང་མེད། ");
INSERT INTO bod_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","དེའི་ཕྱིར་ངས་ཁྱེད་རྣམས་དང་གཏམ་གླེང་བྱེད་པར་བོས། ཡི་སི་ར་ཨེལ་གྱི་མིའི་རེ་བའི་ཆེད་ང་ལྕགས་ཐག་འདི་ཡིས་བཅིངས་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ལན་དུ་ཁོ་ཚོས་“ཡ་ཧུ་དཱ་ཡུལ་ནས་ཁྱེད་ཀྱི་སྐོར་ལ་ཡི་གེ་ཡང་མ་འབྱོར། ཡ་ཧུ་དཱ་པའི་སྤུན་ཟླ་སུ་ཞིག་གིས་འདིར་ཡོང་ནས་ཁྱེད་ཀྱི་ངན་གཏམ་ཡང་མ་བཤད། ");
INSERT INTO bod_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","འོན་ཀྱང་ང་ཚོས་ཁྱེད་ཀྱི་བསམ་འཆར་གང་ཡིན་པ་ཉན་པར་འདོད། གང་ཡིན་ཟེར་ན། ཡུལ་ཀུན་ཏུ་མི་རྣམས་ཀྱིས་ཆོས་ལུགས་འདིའི་སྐོར་ལ་ངན་གཏམ་བཤད་པ་ངེད་རྣམས་ཀྱིས་ཤེས་”ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ཁོ་ཚོས་པའུ་ལུ་དང་མཇལ་བའི་ཉིན་ཞིག་གཏན་འཁེལ་བཟོས་ནས་མི་མང་པོ་ཞིག་ཁོང་གི་བཞུགས་སར་ཡོང༌། ཞོགས་པ་ནས་མཚན་མོའི་བར་དུ་ཁོང་གིས་ཁོ་ཚོར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ལ་བདེན་དཔང་མཛད་ཅིང༌། མོ་ཤེའི་བཀའ་ཁྲིམས་དང་ལུང་སྟོན་པའི་མདོ་གཉིས་ལ་བརྟེན་ནས་ཡེ་ཤུའི་སྐོར་སྐུལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ཁོང་གིས་གསུངས་པའི་བཀའ་ལ་ཁ་ཅིག་གིས་དད་པ་བྱས་ཀྱང༌། ཁ་ཅིག་གིས་དད་པ་མ་བྱས་པས། ");
INSERT INTO bod_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","མི་མཐུན་པ་བྱུང་ཞིང༌། ཁོ་རྣམས་ཕྱིར་ཐོན་པའི་ཚེ་པའུ་ལུས་“དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་བརྒྱུད་ནས་ཁྱེད་ཀྱི་མེས་པོ་རྣམས་ལ་ལེགས་པར་གསུངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ཁྱེད་ཀྱིས་མི་རྣམས་ཕྱོགས་ལ་འདི་ལྟར་ཤོད། ། གང་ཞིག་རྣ་བས་ཐོས་པར་འགྱུར་ན་ཡང༌། ། དེ་དོན་གང་ཡིན་གསལ་བར་ཤེས་མི་འགྱུར། ། མཐོང་ཡང་གང་ཡིན་རྟོགས་པར་མི་འགྱུར་བ། ། ");
INSERT INTO bod_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","མི་རྣམས་སེམས་ནི་གྱོང་པོར་གྱུར་བ་དང༌། ། རྣ་བ་ལྗིད་ཅིང་མིག་ཡང་བཙུམ་པས་ན། ། མིག་གིས་མ་མཐོང་རྣ་བས་མི་ཐོས་ཤིང༌། ། བློ་ཡིས་མི་རྟོགས་དེ་ཕྱིར་སེམས་བསྒྱུར་ན། ། ང་ཡིས་དེ་དག་གསོ་ཞིང་སྐྱོབ་པར་བྱེད། ། ");
INSERT INTO bod_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ཞེས་འཁོད་པས་དཀོན་མཆོག་གི་ཐར་ལམ་འདི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་གནང་བ་ཡིན་དེ་ཤེས་པར་གྱིས་ཤིག ཁོ་ཚོས་ཉན་པར་འགྱུར་ངེས་ཡིན་”ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","པའུ་ལུས་ཁང་པ་ཞིག་ནང་ཁང་གླ་སྤྲད་དེ་ལོ་གཉིས་རིང་བཞུགས་ནས་ཁོང་དང་མཇལ་བར་ཡོང་བའི་མི་ཐམས་ཅད་ལ་བསུ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","པའུ་ལུས་འཇིགས་པ་མེད་པར་དཀོན་མཆོག་གི་རྒྱལ་སྲིད་ཀྱི་གསུང་བསྒྲགས་ཤིང༌། སུས་ཀྱང་མ་བཀག་པར་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་སྐོར་ཆོས་བསྟན་པར་མཛད་དོ། །");
INSERT INTO bod_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","འཕྲིན་ཡིག་འདི་འབྲི་མཁན་མཱ་ཤི་ཀ་ཡེ་ཤུའི་ཞབས་ཕྱི་པའུ་ལུ་ང་ནི། དཀོན་མཆོག་གིས་སྐུ་ཚབ་ཏུ་བོས་པ་དང༌། དཀོན་མཆོག་གི་འཕྲིན་བཟང་སྒྲོག་པར་བསྐོས་པ་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","3","སྔོན་ནས་དཀོན་མཆོག་གིས་ཉིད་ཀྱི་ལུང་སྟོན་པ་རྣམས་བརྒྱུད་ནས་དམ་པའི་མདོའི་ནང་ཁོང་གི་སྲས་ཀྱི་སྐོར་གྱི་འཕྲིན་བཟང་ཞལ་གྱིས་བཞེས། མིའི་རིགས་ཀྱི་ཆ་ནས་སྲས་དེ་ནི་རྒྱལ་པོ་དཱ་བིད་ཀྱི་བུ་རྒྱུད་ཡིན་ཞིང༌། ");
INSERT INTO bod_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་བརྒྱུད་དེ་འཆི་བ་ནས་སླར་གསོན་དུ་གྱུར་བས་དཀོན་མཆོག་གི་སྲས་དབང་དང་ལྡན་པ་ཡིན་པར་བསྟན། ཁོང་ནི་ངེད་རྣམས་ཀྱི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ཁོང་བརྒྱུད་ནས་དཀོན་མཆོག་གི་ཐུགས་རྗེ་དང་སྐུ་ཚབ་ཀྱི་ལས་འགན་ང་ཚོར་ཐོབ། དེ་ནི་ཁོང་གི་མཚན་གྱི་དོན་དུ་མི་རིགས་ཐམས་ཅད་ཀྱི་ཁྲོད་དུ་མི་རྣམས་ཀྱིས་དད་པ་བྱེད་དེ་ཁོང་གི་བཀའ་ལ་ཉན་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ཁྱེད་རྣམས་ཀྱང་ཡེ་ཤུ་མཱ་ཤི་ཀའི་ཁོངས་སུ་གཏོགས་པར་བོས་པའི་མི་རྣམས་ཤིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","རོ་མཱ་གྲོང་ཁྱེར་དུ་བཞུགས་ཏེ་དཀོན་མཆོག་གིས་བྱམས་ཤིང༌། དམ་པར་འགྱུར་བར་བདམས་པ་ཐམས་ཅད་ལ་འཕྲིན་ཡིག་འདི་ཕུལ་ལོ། ང་ཚོའི་ཡབ་དཀོན་མཆོག་དང་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་ནས་ཐུགས་རྗེ་དང་ཞི་བདེ་ཁྱེད་རྣམས་ལ་འཐོབ་པར་གྱུར་ཅིག ");
INSERT INTO bod_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","དང་པོ་ནི། ཁྱེད་ཀྱིས་དད་པ་བྱེད་པའི་ལོ་རྒྱུས་ཕྱོགས་ཀུན་ཏུ་གྲགས་པས། ངས་ཁྱེད་ཐམས་ཅད་ཀྱི་དོན་དུ་ཡེ་ཤུ་མཱ་ཤི་ཀའི་སྒོ་ནས་ངའི་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུ། ");
INSERT INTO bod_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","དཀོན་མཆོག་གི་སྲས་ཡེ་ཤུའི་འཕྲིན་བཟང་སྒྲོག་པའི་སྒོ་ནས་ངས་སེམས་གཅིག་གིས་བསྙེན་བཀུར་ཞུ་བའི་དཀོན་མཆོག་ནི་ངས་ཁྱེད་ཀྱི་དོན་དུ་རྒྱུན་ཆད་མེད་པར་སྨོན་ལམ་འདེབས་པར་དཔང་པོ་མཛད་མཁན་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ངས་དཀོན་མཆོག་གི་དགོངས་པ་བརྒྱུད་མཐར་ཁྱེད་ཚོའི་སར་ཡོང་བའི་ལམ་ཞིག་འབྱུང་བའི་གསོལ་བ་ཞུ་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ང་ཁྱེད་ཚོ་དང་མཇལ་བར་འདོད། གང་ལགས་ཟེར་ན། ཁྱེད་ཚོའི་དད་པ་བརྟན་པོར་བྱེད་པའི་ཆེད་དུ་དམ་པའི་ཐུགས་ཉིད་ནས་ང་ལ་ཐོབ་པའི་ཆོས་ཀྱི་གནང་སྦྱིན་དེ་ཁྱེད་ཚོར་འབུལ་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","དེ་ནི་ང་དང་ཁྱེད་རྣམས་མཉམ་དུ་ཡོད་དུས་ཕན་ཚུན་དད་སེམས་འཕེལ་བའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","སྤུན་ཟླ་རྣམས། ང་ལ་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་ཁྲོད་ནས་འབྲས་བུ་ཐོབ་པ་ལྟར། ཁྱེད་རྣམས་ལས་ཀྱང་འཐོབ་པའི་ཆེད་དུ་ངས་ཐེངས་མང་པོར་ཁྱེད་ཚོའི་རྩར་འགྲོ་བར་བསམས་ཀྱང༌། ད་ལྟའི་བར་དུ་འགོག་པར་གྱུར་བ་དེ་ངེས་པར་དུ་ཤེས་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ངར་རིག་གནས་ཡོད་མེད་གཉིས་ཀ་དང༌། མཁས་བླུན་གཉིས་ཀར་འཕྲིན་བཟང་སྒྲོག་པའི་ལས་འགན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","དེའི་ཕྱིར་ངས་རོ་མཱ་གྲོང་ཁྱེར་ལ་བཞུགས་མཁན་ཁྱེད་ཚོ་ལའང་འཕྲིན་བཟང་སྒྲོག་པའི་བརྩོན་སེམས་ཡོད། ");
INSERT INTO bod_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ང་འཕྲིན་བཟང་གི་དོན་དུ་ངོ་མི་གནོང༌། གང་ལགས་ཟེར་ན། འཕྲིན་བཟང་དེ་ནི་དད་པ་བྱེད་མཁན་ཐམས་ཅད་དེ། དང་པོར་ཡ་ཧུ་དཱ་པ། དེ་ནས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་དཀོན་མཆོག་གིས་ཐར་བར་བྱེད་པའི་ནུས་མཐུ་དང་ལྡན་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","འཕྲིན་བཟང་དེ་བཞིན་དུ་དཀོན་མཆོག་གིས་ང་ཚོ་ཁོང་དང་འབྲེལ་བ་ཡང་དག་པ་ཡིན་པར་མཛད། དེ་ནི་ཐོག་མ་ནས་མཐའ་མར་དད་པའི་སྒོ་ནས་སྒྲུབ། མདོ་ལས་བཀོད་པ་ལྟར་ན། དྲང་པོ་དང་ལྡན་པ་ནི་དད་པའི་སྒོ་ནས་གསོན་པོར་གནས་པར་འགྱུར་ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","དེའི་ཕྱིར་དཀོན་མཆོག་གི་ཐུགས་ཁྲོ་ནི་ངན་པའི་སྒོ་ནས་བདེན་པར་གནོན་མཁན་ཏེ། སྡིག་པ་དང་ངན་པ་ཐམས་ཅད་ལ་དཀོན་མཆོག་གི་ཞིང་ཁམས་ནས་མངོན་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","དཀོན་མཆོག་གི་སྐོར་གང་ཤེས་ཐུབ་པ་དེ་ཁོ་ཚོས་ལེགས་པར་ཤེས། གང་ཡིན་ཞེ་ན། དཀོན་མཆོག་གིས་ཁོ་ཚོར་གསལ་པོར་སྟོན་པར་མཛད་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ཁོང་ནི་མི་སྣང་བའི་རང་བཞིན་ཏེ། དཔག་ཏུ་མེད་པའི་ནུས་མཐུ་དང༌། བླ་ན་མེད་པའི་ངོ་བོ་འཇིག་རྟེན་ཁམས་བཀོད་པ་ནས་བཟུང་གསལ་པོར་མཐོང༌། དེ་ཚོ་ནི་ཁོང་གིས་གང་བཀོད་པའི་སྒོ་ནས་རྟོགས་པས་མི་རྣམས་ཀྱིས་དཀོན་མཆོག་ངོ་མ་ཤེས་ཞེས་ཟེར་བའི་རྒྱུ་མཚན་མེད། ");
INSERT INTO bod_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ཁོ་ཚོས་དཀོན་མཆོག་ཤེས་ཀྱང་དཀོན་མཆོག་ཡིན་པ་ལ་འབུལ་འོས་པའི་བཀུར་སྟི་དང་བཀའ་དྲིན་མ་ཞུས། ཁོ་ཚོའི་བསམ་བློ་དོན་མེད་པ་དང༌། བླུན་ཞིང་རྨོངས་པའི་སེམས་མུན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ང་ཚོ་མཁས་པ་ཡིན་ཞེས་ཟེར་ཡང་ཁོ་ཚོ་བླུན་པོར་གྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","འཆི་བ་མེད་པའི་དཀོན་མཆོག་གི་གཟི་བརྗིད་དོར་ནས་ཁོ་ཚོས་འཆི་བ་མྱོང་བའི་མིའམ། བྱ་བྱིའུ། དུད་འགྲོ ལྟོ་བགྲོད་བཅས་ཀྱི་འདྲ་སྐུ་རྣམས་ལ་བསྙེན་བཀུར་བྱས། ");
INSERT INTO bod_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","དེའི་ཕྱིར་དཀོན་མཆོག་གིས་ཁོ་ཚོའི་སེམས་ཀྱི་འདོད་ཆགས་ལྟར་གཏད་པར་མཛད་པས། ཁོ་ཚོས་རང་གི་ལུས་ཀྱིས་ཕན་ཚུན་མི་གཙང་བའི་སྤྱོད་པ་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","དཀོན་མཆོག་གི་བདེན་པ་དོར་ནས་ཁོ་ཚོས་རྫུན་ཞིག་དང་ལེན་བྱས་པ་སྟེ། འགོད་པ་གནང་མཁན་ལས་གང་བཀོད་པ་ལ་གཡོག་བྱེད་ཅིང་བསྙེན་བཀུར་བྱས། འགོད་པ་གནང་མཁན་དཀོན་མཆོག་རྟག་ཏུ་བསྟོད་དོ། ཨ་མེན། ");
INSERT INTO bod_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","དེའི་ཕྱིར་དཀོན་མཆོག་གིས་ཁོ་རྣམས་ངོ་ཚ་བའི་འདོད་ཆགས་ལྟར་གཏད་ནས་ཁོ་ཚོའི་བུད་མེད་རྣམས་ཀྱིས་ཀྱང་རང་བཞིན་གྱི་སྤྱོད་པ་སྤངས་ནས་བུད་མེད་དང་ལོག་གཡེམ་བྱས་ཤིང༌། ");
INSERT INTO bod_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","དེ་བཞིན་དུ་སྐྱེས་པའང་བུད་མེད་དོར་ཏེ་འདོད་ཆགས་ཀྱིས་གཅིག་གིས་གཅིག་ལ་ལོག་གཡེམ་བྱས། སྐྱེས་པ་གཞན་དང་ངོ་ཚ་བའི་སྤྱོད་པ་བྱས་པས་རང་གི་ལུས་ལ་ལོག་པའི་སྤྱོད་པ་དང་མཐུན་པའི་ཉེས་ཆད་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ཁོ་ཚོས་དཀོན་མཆོག་རྩིས་མེད་དུ་བཏང་བས་དཀོན་མཆོག་གིས་ཁོ་རྣམས་ལ་ལོག་ལྟ་འཛིན་པའི་སེམས་དང༌། མི་རུང་བའི་སྤྱོད་པ་བྱེད་དུ་འཇུག་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ཁོ་ཚོ་ནི་ངན་པ་ཀུན་དང༌། ངན་སེམས། སེར་སྣ། ངན་སྤྱོད། ཕྲག་དོག མི་སྲོག་གཅོད་པ། འཁྲུག་རྩོད། མགོ་སྐོར། གནོད་སེམས་སོགས་ཀྱིས་གང༌། ཁོ་ཚོ་ནི་རྒྱབ་བཤད་རྒྱག་མཁན་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","སྨད་ར་གཏོང་མཁན། དཀོན་མཆོག་ལ་སྡང་མཁན། རང་མཐོང་ཅན། ང་རྒྱལ་ཅན། རང་བསྟོད་བྱེད་མཁན། ངན་ཐབས་འཚོལ་མཁན། ཕ་མའི་བཀའ་ལ་མི་ཉན་མཁན། ");
INSERT INTO bod_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","བླུན་པོ། ཁ་དན་ཚིག་ལ་མི་གནས་པ། བྱམས་སེམས་མེད་པ། སྙིང་རྗེ་མེད་པ་བཅས་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","དེ་ལྟར་བྱེད་མཁན་ལ་སྲོག་ཁྲིམས་ཀྱི་ཉེས་ཆད་འོས་པའི་དཀོན་མཆོག་གི་བཀའ་ཤེས་ཀྱང༌། ཁོ་ཚོས་དེ་བཞིན་དུ་བྱེད་པ་མ་ཟད། དེ་ལྟར་བྱེད་མཁན་གཞན་རྣམས་ལའང་མོས་མཐུན་བྱེད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","དེ་བས་ན་གཞན་ལ་སྐྱོན་འདོགས་བྱེད་མཁན་ཐམས་ཅད་ལ་ཁ་གཡར་ས་མེད། གང་ཡིན་ཟེར་ན། གཞན་ལ་སྐྱོན་འདོགས་གང་རུང་བྱེད་དུས་དེས་རང་ཉིད་ལ་ཁྲིམས་གཅོད་གཏོང༌། དེ་ནི་སྐྱོན་འདོགས་བྱེད་མཁན་གྱིས་སྤྱོད་པ་དེ་རང་བྱེད་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","དེ་ལྟར་སྤྱོད་མཁན་རྣམས་ལ་དཀོན་མཆོག་གི་ཁྲིམས་གཅོད་ཕོག་པ་ནི་བདེན་པ་དང་མཐུན་པ་ཡིན་པ་ངེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ཀྱེ། མི་ཁྱོད་ཀྱིས་སྤྱོད་པ་དེ་ལྟར་བྱེད་མཁན་གཞན་ལ་སྐྱོན་འདོགས་བྱེད་ཀྱང་རང་ཉིད་ཀྱི་སྤྱོད་པའང་དེ་དང་མཚུངས་པས། དཀོན་མཆོག་གི་ཁྲིམས་གཅོད་ལས་ཐར་ཐུབ་སྙམ་མམ། ");
INSERT INTO bod_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ཡང་ན། ཁྱོད་ཀྱིས་དཀོན་མཆོག་གི་བླ་ན་མེད་པའི་བཀའ་དྲིན་དང༌། ཐུགས་བསྲན། ཐུགས་བཟོད་བཅས་ལ་རྩིས་མེད་གཏོང་ངམ། དཀོན་མཆོག་གི་བཀའ་དྲིན་ནི་ཁྱོད་སྤྱོད་པ་ངན་པ་རྣམས་སྤངས་ནས་སེམས་བསྒྱུར་བའི་ཕྱོགས་སུ་འཁྲིད་པའི་ཆེད་དུ་ཡིན་པ་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ཁྱོད་ནི་སེམས་མཁྲེགས་ཤིང་ངན་སྤྱོད་ཀྱི་བསམ་པ་མི་བསྒྱུར་བས་རང་གི་ཆེད་དུ་ཆད་པ་དྲག་པོ་གསོག གང་ལགས་ཟེར་ན། དཀོན་མཆོག་གི་ཐུགས་ཁྲོའི་ཉིན་མོ་ཡོང་བས་ཁོང་གི་དྲང་བདེན་གྱི་ཁྲིམས་གཅོད་མངོན་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ཁོང་གིས་མི་རེ་རེའི་བྱ་བ་བཞིན་དེ་དང་མཐུན་པར་གནང་བར་འགྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","བྱ་བ་བཟང་པོ་སྒྲུབ་པར་བཟོད་པའི་སྒོ་ནས་གཟི་བརྗིད་དང༌། བཀུར་སྟི། འཆི་མེད་བཅས་འཚོལ་མཁན་རྣམས་ལ་དཔག་ཏུ་མེད་པའི་ཚེ་གནང་བ་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ངན་པ་ལ་དགའ་ཞིང་བདེན་པ་ལ་མི་གནས་པར་རང་འདོད་ཚ་བ་རྣམས་ལ་དཀོན་མཆོག་གིས་ཐུགས་ཁྲོ་དྲག་པོ་གནང་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ངན་པ་བྱེད་མཁན་སུ་ཡིན་ཡང་སྡུག་བསྔལ་དྲག་པོ་འབབ་པར་འགྱུར་ཏེ། དང་པོར་ཡ་ཧུ་དཱ་པ། དེ་ནས་ཡ་ཧུ་དཱ་པ་མིན་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","འོན་ཀྱང་བཟང་པོ་བྱེད་མཁན་སུ་ཡིན་ཡང་གཟི་བརྗིད་དང༌། བཀུར་སྟི། ཞི་བདེ་བཅས་ཐོབ་པར་འགྱུར་ཏེ། དང་པོར་ཡ་ཧུ་དཱ་པ། དེ་ནས་ཡ་ཧུ་དཱ་པ་མིན་པའོ། ");
INSERT INTO bod_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","གང་ཡིན་ཞེ་ན། དཀོན་མཆོག་ལ་ཕྱོགས་རིས་ཅི་ཡང་མེད། ");
INSERT INTO bod_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ཆོས་ཁྲིམས་མི་ལྡན་པར་སྡིག་ཉེས་བྱས་པ་ཐམས་ཅད་ཆོས་ཁྲིམས་མི་ལྡན་པར་འཇིག་པར་འགྱུར། ཆོས་ཁྲིམས་ལྡན་བཞིན་དུ་སྡིག་ཉེས་བྱས་པ་ཐམས་ཅད་ནི་ཆོས་ཁྲིམས་དེ་ཉིད་ཀྱིས་གཅོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","དཀོན་མཆོག་གི་སྤྱན་སྔར་ཆོས་ཁྲིམས་ཐོས་མཁན་རྣམས་ཡང་དག་པ་མིན་པར། ཆོས་ཁྲིམས་སྒྲུབ་མཁན་རྣམས་ཡང་དག་པར་བརྩིའོ། ");
INSERT INTO bod_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","དོན་དམ་དུ་ཆོས་ཁྲིམས་མེད་པའི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་རང་བཞིན་གྱིས་ཆོས་ཁྲིམས་ཀྱི་ལས་སྒྲུབ་པའི་ཚེ། ཆོས་ཁྲིམས་མེད་ཀྱང་རང་བཞིན་གྱི་ཁྲིམས་ཁོ་ཚོའི་སེམས་ལ་ཡོད་པར་སྟོན། ");
INSERT INTO bod_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ཁོ་ཚོས་རང་གིས་རང་ལ་སྐྱོན་འདོགས་སམ་དྲང་པོའི་སེམས་ཀྱི་སྒོ་ནས་ཀྱང་དཔང་པོ་བྱེད་དེ། ཆོས་ཁྲིམས་ཀྱི་བཀའ་ཁོ་ཚོའི་སེམས་ལ་བྲིས་ཡོད་པར་སྟོན། ");
INSERT INTO bod_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ངས་སྒྲོག་པའི་འཕྲིན་བཟང་ལྟར་དེ་ནི་དཀོན་མཆོག་གིས་མཱ་ཤི་ཀ་ཡེ་ཤུ་བརྒྱུད་ནས་མི་ཐམས་ཅད་ཀྱི་གསང་བ་ལ་ཁྲིམས་གཅོད་མཛད་པའི་ཉིན་མོར་འབྱུང་བར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","འོན་ཀྱང་ཁྱོད་ནི་ཡ་ཧུ་དཱ་པ་ཡིན་ཞེས་བཤད་པ་དང༌། ཆོས་ཁྲིམས་ལ་བརྟེན་པ་དང༌། དཀོན་མཆོག་དང་འབྲེལ་བ་ཡོད་པའི་སྐོར་འུད་ཤོབ་བྱེད་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ཁོང་གི་དགོངས་པ་ཤེས་པ་དང༌། ཆོས་ཁྲིམས་ཀྱི་བསླབ་བྱ་ཐོབ་པས་གང་མཆོག་ཡིན་པའི་བླང་དོར་ཤེས་པ་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ཁྱོད་ཉིད་ལོང་བའི་ལམ་སྟོན་པ་དང༌། མུན་པར་སྡོད་པ་རྣམས་ཀྱི་སྒྲོན་མེ་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","བླུན་པོ་རྣམས་ཀྱི་སློབ་དཔོན་དང༌། ཕྲུ་གུ་རྣམས་ཀྱི་དགེ་རྒན། ཆོས་ཁྲིམས་ལ་ཤེས་རབ་དང་བདེན་པ་བཅས་ཡོད་མཁན་ཡིན་པར་བསམས་ན། ");
INSERT INTO bod_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","གཞན་ལ་སློབ་སྟོན་བྱེད་མཁན་ཁྱོད་ཀྱིས་རང་ཉིད་ལ་མི་སློབ་བམ། གཞན་ལ་མ་རྐུ་ཞེས་ཆོས་བསྟན་པ་ཁྱོད་ཉིད་ཀྱིས་རྐུའམ། ");
INSERT INTO bod_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ལོག་གཡེམ་མ་བྱོས་ཞེས་ཟེར་མཁན་ཁྱོད་ཉིད་ཀྱིས་ལོག་གཡེམ་བྱེད་དམ། འདྲ་སྐུ་ལ་སྡང་མཁན་ཁྱོད་ཉིད་ཀྱིས་ལྷ་ཁང་གི་རྒྱུ་ནོར་ཧམ་འཕྲོག་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ཆོས་ཁྲིམས་ཀྱི་སྐོར་འུད་ཤོབ་བྱེད་མཁན་ཁྱོད་ཉིད་ཀྱིས་ཆོས་ཁྲིམས་དང་འགལ་བའི་སྒོ་ནས་དཀོན་མཆོག་ལ་སྨོད་དམ། ");
INSERT INTO bod_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","མདོ་ལས་བཀོད་པ་ལྟར། ཁྱོད་ཀྱི་རྐྱེན་གྱིས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་གི་མཚན་ལ་སྐུར་བ་འདེབས་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","གལ་སྲིད་ཁྱོད་ཀྱིས་ཆོས་ཁྲིམས་ཀྱི་བཀའ་ལ་ཉན་ན་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དེ་ཕན་པ་དང་ལྡན། འོན་ཀྱང་ཆོས་ཁྲིམས་དང་འགལ་ན་ཆོས་ཀྱི་རྟགས་མེད་པ་རྣམས་དང་མཚུངས། ");
INSERT INTO bod_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","དེའི་ཕྱིར་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མེད་པ་ཞིག་གིས་ཆོས་ཁྲིམས་ཀྱི་བཀའ་རྣམས་བསྲུངས་ན། ཁོ་ལ་རྟགས་དེ་མེད་ཀྱང་རྟགས་ཡོད་པ་དང་འདྲ་བར་མི་རྩིའམ། ");
INSERT INTO bod_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མེད་པ་དེས་ཆོས་ཁྲིམས་བསྲུངས་ན། ཁྱོད་ཆོས་ཁྲིམས་དང་རྟགས་ཡོད་ཀྱང་ཁྲིམས་དང་འགལ་མཁན་ཡིན་པ་རྣམས་ལ་ཁྲིམས་གཅོད་མི་གཏོང་ངམ། ");
INSERT INTO bod_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","གང་ལགས་ཤེ་ན། ཕྱི་ཚུལ་ཙམ་དང་ཆོས་ཀྱི་རྟགས་ཁོ་ན་ཡོད་མཁན་ནི་ཡ་ཧུ་དཱ་པ་མིན། ཆོས་ཀྱི་རྟགས་དེ་མིའི་ལུས་དང་ཕྱི་ལ་བྱེད་པ་ཙམ་གྱིས་ཀྱང་མིན། ");
INSERT INTO bod_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ཡ་ཧུ་དཱ་པ་དངོས་ཡིན་པ་ནི་ཕྱི་ཚུལ་གྱི་དོན་མིན་ཏེ་ནང་སེམས་ཀྱི་དོན་ཡིན་ཞིང༌། ཆོས་ཀྱི་རྟགས་དངོས་ནི་ཆོས་ཁྲིམས་ཀྱི་ལས་སྒྲུབ་པའི་དོན་མིན་ཏེ། དམ་པའི་ཐུགས་ཉིད་ཀྱིས་མི་རྣམས་ཀྱི་སེམས་ལ་གང་མཛད་པའི་དོན་ཡིན། མི་དེའི་བསྟོད་པ་གཞན་ནས་མི་འབྱུང་སྟེ་དཀོན་མཆོག་ནས་འབྱུང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","འོ་ན། ཡ་ཧུ་དཱ་པ་ཡིན་པའམ། ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་ལེན་པ་དེས་ཅི་ཕན། ");
INSERT INTO bod_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ཕན་ཐོགས་ཆེ་སྟེ། དང་པོ་ནི་དཀོན་མཆོག་གི་བཀའ་ཡ་ཧུ་དཱ་པ་རྣམས་ལ་བཅོལ་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","གལ་ཏེ་ཁ་ཅིག་གིས་བཀའ་དེར་མ་ཉན་ན། དེས་དཀོན་མཆོག་གི་ཞལ་བཞེས་པ་དེ་མེད་པར་བྱེད་དམ། ");
INSERT INTO bod_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","དེ་མི་སྲིད། མི་ཐམས་ཅད་ཀྱིས་རྫུན་བཤད་ཀྱང་དཀོན་མཆོག་བདེན་པ་ཡིན་ནོ། མདོ་ལས་བཀོད་པ་ལྟར་ན། ཁྱེད་ཀྱི་བཀའ་ཡིས་ཁྱེད་ཉིད་བདེན་པར་གསལ། ། ཞལ་ལྕེའི་ཚེ་ན་ཁྱེད་ཉིད་རྒྱལ་བར་འགྱུར། ། ཞེས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","འོ་ན་གལ་ཏེ་ང་ཚོའི་དྲང་བདེན་མ་ཡིན་པའི་བྱ་བ་བརྒྱུད་དཀོན་མཆོག་གི་དྲང་བདེན་ཉིད་གསལ་པོར་བསྟན་ན། ང་ཚོས་ཅི་ཟེར། དཀོན་མཆོག་གིས་ང་ཚོར་ཁྲིམས་གཅོད་པ་དེ་དྲང་བདེན་མ་ཡིན་ཞེས་ཟེར་རམ། (ངས་མིའི་རིགས་ཀྱི་ཆ་ནས་གཏམ་བྱེད་) ");
INSERT INTO bod_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","དེ་མི་སྲིད། དེ་ལྟར་ཡིན་ན་དཀོན་མཆོག་གིས་འཇིག་རྟེན་གྱི་མི་རྣམས་ལ་ཁྲིམས་གཅོད་མཛད་པ་ཅི་ལ་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","འོན་ཀྱང་མི་ཞིག་གིས་ངའི་རྫུན་གྱིས་དཀོན་མཆོག་གི་བདེན་པ་སྟོན་ཏེ་ཁོང་གི་གཟི་བརྗིད་འཕེལ་བར་བྱས་ན། ང་ལ་ཅིའི་ཕྱིར་སྡིག་ཅན་ལྟར་ད་དུང་ཁྲིམས་གཅོད་གཏོང་ཞེས་ཟེར། ");
INSERT INTO bod_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ཡང་བཟང་པོ་འབྱུང་བའི་ཕྱིར་ལས་ངན་བྱེད་དགོས་ཞེས་སྨྲས་པ་དེ་ཅིའི་ཕྱིར་ཟེར་མི་རུང༌། ང་ཚོར་སྨད་ར་གཏོང་མཁན་ཁ་ཅིག་གིས་ང་ཚོས་དེ་ལྟར་སྨྲས་ཟེར་བའི་སྐྱོན་འདོགས་བྱེད། ཁོ་ཚོ་ཆད་པ་ཕོག་འོས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","འོ་ན་ང་ཚོས་ཅི་ལྟར་སྨྲ། ང་ཚོ་ཡ་ཧུ་དཱ་པ་རྣམས་གཞན་རྣམས་ལས་ཡག་པ་ཡོད་དམ། དེ་ལྟར་ཁྱོན་ནས་མེད། མི་ཐམས་ཅད་དེ་ཡ་ཧུ་དཱ་པ་མིན་པ་དང་ཡ་ཧུ་དཱ་པ་གཉིས་ཀ་སྡིག་ཉེས་ཀྱི་དབང་འོག་ཏུ་ཡོད་པར་ང་ཚོས་བསྟན། ");
INSERT INTO bod_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","མདོ་ལས་བཀོད་པ་ལྟར། དྲང་བའི་མི་ཞེས་གཅིག་ཀྱང་ནི། ། རྩ་བ་ཉིད་ནས་ཡོད་མ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","རྟོགས་པ་གཅིག་ཀྱང་ཡོད་མིན་ཏེ། ། དཀོན་མཆོག་འཚོལ་བའང་ཡོད་མ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ཐམས་ཅད་ཁོང་ལ་རྒྱབ་ཀྱིས་ཕྱོགས། ། ཐམས་ཅད་ལྷན་ཅིག་དོན་མེད་གྱུར། ། ལས་བཟང་བྱེད་མཁན་གཅིག་མེད་དེ། ། རྩ་བ་ཉིད་ནས་ཡོད་མ་ཡིན། ། ");
INSERT INTO bod_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","མིད་པ་གདངས་པའི་དུར་ཁུང་སྟེ། ། ལྕེ་ནི་གཡོ་སྒྱུའི་བཤད་པ་སྐྱོང༌། ། མཆུ་ལ་སྦྲུལ་གྱི་དུག་ལྡན་ཏེ། ། ");
INSERT INTO bod_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ཁ་ནི་དམོད་འཁོན་ཚིག་གིས་ཁེངས། ། ");
INSERT INTO bod_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","མི་སྲོག་གཅོད་ལ་རྐང་པ་མགྱོགས། ། ");
INSERT INTO bod_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","འགྲོ་ལམ་གཏོར་བཤིག་སྐྱོ་བས་གདུང༌། ། ");
INSERT INTO bod_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ཞི་བདེའི་ལམ་ཡང་མི་ཤེས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","དཀོན་མཆོག་ཅི་ཡང་མི་བཀུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ཡང་གསུང་རབ་ཀྱི་བཀའ་ཐམས་ཅད་ཆོས་ཁྲིམས་ཀྱི་དབང་འོག་ཏུ་ཡོད་པ་རྣམས་ལ་གསུངས་པར་ངེད་ཀྱིས་ཤེས། དེ་ནི་ཁོང་ཚོ་དང་དེ་མིན་འཇིག་རྟེན་གྱི་མི་ཐམས་ཅད་ཁ་མི་གཡར་ཞིང༌། དཀོན་མཆོག་གི་མདུན་དུ་མཇུག་རྩི་རྒྱག་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","དེའི་ཕྱིར་ཆོས་ཁྲིམས་ཀྱི་བྱ་བ་བཟང་པོའི་སྒོ་ནས་སུའང་དཀོན་མཆོག་གི་སྤྱན་སྔར་ཡང་དག་པ་ཡིན་པར་མི་རྩི། གང་ཡིན་ཟེར་ན། ཆོས་ཁྲིམས་ཀྱིས་ང་ཚོ་སྡིག་ཉེས་ཀྱི་དབང་འོག་ཏུ་ཡོད་པ་ཤེས་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","འོན་ཀྱང་ད་ལྟ་ཆོས་ཁྲིམས་དང་བྲལ་ཏེ་དཀོན་མཆོག་དང་འབྲེལ་བ་ཡང་དག་པ་འཐོབ་པའི་ལམ་མངོན་སུམ་དུ་བསྟན་ཡོད། བཀའ་ཁྲིམས་དང་ལུང་སྟོན་པ་རྣམས་ཀྱིས་དེ་ལ་བདེན་དཔང་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","དཀོན་མཆོག་ནས་བྱུང་བའི་ལམ་དེ་ནི་ཡེ་ཤུ་མཱ་ཤི་ཀ་ལ་དད་པ་བྱེད་པའི་ངང་ནས་དད་ལྡན་ཐམས་ཅད་ཀྱི་ཕྱིར་རོ། དབྱེ་བ་ཅིའང་མེད། ");
INSERT INTO bod_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","གང་ཡིན་ཞེ་ན། མི་ཐམས་ཅད་ཀྱིས་སྡིག་ཉེས་ཀྱི་ལས་བྱས་པས་དཀོན་མཆོག་གི་གཟི་བརྗིད་དང་རྒྱང་རིང་དུ་གནས། ");
INSERT INTO bod_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","དེ་ཡང་ད་ལྟ་མཱ་ཤི་ཀ་ཡེ་ཤུ་ཡིས་མི་རྣམས་ཀྱིས་ཆོས་ཁྲིམས་དང་འགལ་བའི་ཆད་པ་མྱོང་བའི་བླུ་རིན་གྱིས་ཁོ་རྣམས་ཐར་དུ་འཇུག་པས། དཀོན་མཆོག་གི་ཐུགས་རྗེའི་གནང་སྦྱིན་གྱི་སྒོ་ནས་དཀོན་མཆོག་གིས་མི་རྣམས་ཡང་དག་པ་ཡིན་པར་རྩི་གནང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ཐུགས་ཁྲོ་སེལ་བའི་ཕྱིར་དཀོན་མཆོག་གིས་ཡེ་ཤུའི་སྐུ་ཁྲག་བླུ་རིན་དུ་མཛད་པ་དང༌། དད་པ་བྱེད་པའི་སྒོ་ནས་དེ་དང་ལེན་བྱེད། དེ་ནི་དཀོན་མཆོག་གི་དྲང་བདེན་ཉིད་མངོན་པར་མཛད་པའི་ཆེད་དུ་ཡིན། གང་ལགས་ཤེ་ན། དཀོན་མཆོག་གི་བཟོད་པའི་ཐུགས་ཀྱིས་མི་རྣམས་ཀྱི་སྔོན་བྱས་པའི་སྡིག་ལས་ལ་ཆད་པ་མ་མཛད་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","དེ་ནི་དཀོན་མཆོག་ཉིད་དྲང་བདེན་ཡིན་པ་དང༌། ཁོང་ཉིད་ཡེ་ཤུ་ལ་དད་མཁན་རྣམས་ཡང་དག་པར་མཛད་མཁན་ཡིན་པ་དུས་འདིར་སྟོན་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","འོ་ན། རང་བསྟོད་བྱེད་རྒྱུ་ག་རེ་ཡོད། མེད་དོ། རྐྱེན་གང་གིས་མེད་དམ། དགེ་བའི་ལས་ཀྱི་རྐྱེན་གྱིས། དེ་མིན། དད་པའི་རྐྱེན་གྱིས་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","གང་ལགས་ཤེ་ན། ང་ཚོས་ཡེ་ཤུ་མཱ་ཤི་ཀ་ལ་དད་པའི་སྒོ་ནས་མི་ཞིག་ཡང་དག་པར་འགྱུར་བ་འཛིན་གྱི། ཆོས་ཁྲིམས་ཀྱི་དགེ་བའི་ལས་ཀྱིས་མ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","དཀོན་མཆོག་ནི་ཡ་ཧུ་དཱ་པ་གཅིག་པོའི་དཀོན་མཆོག་ཡིན་ནམ། ཡང་ན་ཡ་ཧུ་དཱ་པ་མིན་པའི་དཀོན་མཆོག་ཀྱང་མ་ཡིན་ནམ། ལགས་ཡིན། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ཀྱི་དཀོན་མཆོག་ཀྱང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","གང་ཡིན་ཟེར་ན། དཀོན་མཆོག་གཅིག་རང་ཡིན། ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དང་ལྡན་པ་དང༌། ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མེད་པ་གཉིས་ཀ་དད་པའི་སྒོ་ནས་ཡང་དག་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","འོ་ན་དད་པ་འདིས་ཆོས་ཁྲིམས་དོན་མེད་པར་བྱེད་དམ། དེ་མི་སྲིད། དེ་ལས་ལྡོག་སྟེ་དད་པའི་སྒོ་ནས་ང་ཚོས་ཆོས་ཁྲིམས་སྒྲུབ་པར་བྱེད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","བྱས་ན། མིའི་རིགས་ཀྱི་ཆ་ནས་ང་ཚོའི་མེས་པོ་ཨབ་ར་ཧམ་གྱི་སྐོར་ལ་ཅི་སྨྲ། ཁོང་གིས་དོན་འདིའི་སྐོར་ལ་ཅི་མཁྱེན། ");
INSERT INTO bod_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","གལ་སྲིད་ཨབ་ར་ཧམ་དགེ་བའི་ལས་ལ་བརྟེན་ནས་དཀོན་མཆོག་གི་སྤྱན་སྔར་རྣམ་པར་དག་པར་གྱུར་ན། ཁོང་ལ་རང་བསྟོད་བྱེད་རྒྱུ་ཡོད་ཀྱང༌། དེ་དཀོན་མཆོག་གི་དྲུང་དུ་མེད། ");
INSERT INTO bod_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","གསུང་རབ་ལས་ཅི་གསུང༌། ཨབ་ར་ཧམ་གྱིས་དཀོན་མཆོག་ལ་དད་པ་བྱས་པས། དཀོན་མཆོག་གིས་ཁོང་རྣམ་པར་དག་པའི་མི་ཞིག་ལ་བརྩིས་གནང་ངོ་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","འོ་ན། ལས་ཀ་བྱེད་མཁན་གྱི་གླ་ཆ་ནི་སྦྱིན་པ་མིན་ཏེ་ཐོབ་འོས་པར་རྩི། ");
INSERT INTO bod_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","འོན་ཀྱང་མི་ཞིག་གིས་དགེ་བའི་ལས་ལ་མ་བརྟེན་པར་ངན་པ་བྱེད་པ་རྣམས་ལ་རྣམ་པར་དག་པར་མཛད་མཁན་ལ་དད་པ་བྱས་ན། ཁོའི་དད་པ་ནི་རྣམ་པར་དག་པར་རྩིའོ། ");
INSERT INTO bod_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","དེ་ལྟར་དགེ་བའི་ལས་དང་བྲལ་བར་དཀོན་མཆོག་གིས་རྣམ་པར་དག་པ་དང་ལྡན་པ་ལྟར་རྩི་གནང་བའི་མི་ཡི་བདེ་བའི་སྐོར་རྒྱལ་པོ་དཱ་བིད་ཀྱིས་ཀྱང་གསུངས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","སུ་ཡི་སྡིག་ཉེས་བསལ་བར་གྱུར། ། སྡིག་ཉེས་སེལ་བའི་མི་རྣམས་བདེ། ། ");
INSERT INTO bod_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","སུ་ཡི་སྡིག་ཉེས་གཙོ་བོ་ཡིས། ། བརྩི་བར་མི་འགྱུར་མི་དེ་བདེ། ། ");
INSERT INTO bod_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","བདེ་བ་དེ་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དང་ལྡན་པ་ཁོ་ནའམ། ཡང་ན་མེད་པ་རྣམས་ཀྱི་ཆེད་དུ་ཡིན། ང་ཚོས་ཨབ་ར་ཧམ་གྱིས་དད་པ་བྱས་པས་དཀོན་མཆོག་གིས་ཁོང་རྣམ་པར་དག་པའི་མི་ཞིག་ལ་བརྩིས་གནང་ངོ་ཞེས་སྨྲས། ");
INSERT INTO bod_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","དེ་ནི་ཇི་ལྟར་བྱུང༌། ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་ལེན་པའི་སྔོན་དུ་རྣམ་པར་དག་པའི་མི་ལ་བརྩིས་སམ། ཡང་ན་རྗེས་སུ་བརྩིས། རྗེས་སུ་མིན་ཏེ་སྔོན་དུ་བྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་ནི་ཨབ་ར་ཧམ་ལ་དད་པ་ཡོད་ཅིང༌། དཀོན་མཆོག་གིས་ཁོང་དང་ལེན་མཛད་དེ་རྣམ་པར་དག་པ་དང་ལྡན་པར་བརྩིས་གནང་བའི་རྟགས་ཤིག་ཡིན། དེ་ནི་ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མ་ལེན་པའི་སྔོན་དུ་ཡིན། དེའི་ཕྱིར་ཨབ་ར་ཧམ་ནི་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མི་ལྡན་པ་རྣམས་ལ་དད་པ་བྱེད་མཁན་གྱི་མེས་པོ་ཡིན། དད་པ་བྱས་པའི་རྐྱེན་གྱིས་ཁོ་ཚོ་རྣམ་པར་དག་པའི་མི་ལ་རྩི་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","དེ་བཞིན་དུ་ཁོ་ཚོར་ཁོང་གིས་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་མ་ལེན་པའི་སྔོན་གྱི་དད་པ་ཡོད་ན་ཨབ་ར་ཧམ་ནི་ཡ་ཧུ་དཱ་པའི་ཆོས་ཀྱི་རྟགས་དང་ལྡན་པ་རྣམས་ཀྱི་མེས་པོ་ཡང་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","དཀོན་མཆོག་གིས་ཨབ་ར་ཧམ་དང་ཁོང་གི་བུ་རྒྱུད་རྣམས་ལ་ཨབ་ར་ཧམ་འཇིག་རྟེན་གྱི་འཛིན་མཁན་དུ་འགྱུར་བའི་ཞལ་ཆད་གནང་བ་དེ་ཆོས་ཁྲིམས་སྲུང་བའི་སྒོ་ནས་མིན་ཏེ། དད་པ་ལས་འབྱུང་བའི་རྣམ་པར་དག་པ་ནས་བྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","གང་ཡིན་ཞེ་ན། ཆོས་ཁྲིམས་སྲུང་མཁན་རྣམས་འཇིག་རྟེན་གྱི་འཛིན་མཁན་ཡིན་ན། དད་པ་ནི་སྟོང་པ་དང༌། ཞལ་ཆད་ནི་དོན་མེད་པའོ། ");
INSERT INTO bod_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","རྒྱུ་མཚན་ནི་ཆོས་ཁྲིམས་དང་འགལ་བ་ལས་དཀོན་མཆོག་གི་ཐུགས་ཁྲོ་འབྱུང༌། འོན་ཀྱང་ཁྲིམས་མེད་ན་ཁྲིམས་དང་འགལ་བའང་མེད། ");
INSERT INTO bod_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","དེའི་ཕྱིར་དཀོན་མཆོག་གི་ཞལ་ཆད་ནི་དད་པའི་སྒོ་ནས་དང་ལེན་བྱེད་དེ། དཀོན་མཆོག་གི་ཐུགས་རྗེ་ལས་འབྱུང་བའི་གནང་སྦྱིན་ཡིན། གལ་ཏེ་ང་ཚོས་ཨབ་ར་ཧམ་དང་འདྲ་བར་དད་པ་བྱས་ན། ཆོས་ཁྲིམས་སྲུང་མཁན་ཡིན་མིན་ལ་མ་བརྟེན་པར་ངེད་རྣམས་ཀྱིས་ཞལ་ཆད་དེ་འཐོབ་ངེས་ཡིན། གང་ལགས་ཤེ་ན། ཨབ་ར་ཧམ་ནི་དད་པ་བྱེད་མཁན་ངེད་རྣམས་ཀུན་གྱི་མེས་པོ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","མདོ་ལས་བཀོད་པ་ལྟར་ན། ངས་ཁྱོད་ནི་མི་རིགས་མང་པོའི་མེས་པོར་བསྒྱུར་ཞེས་གསུངས། དཀོན་མཆོག་གི་སྤྱན་སྔར་ཁོང་ནི་ངེད་རྣམས་ཀྱི་མེས་པོ་ཡིན། ཨབ་ར་ཧམ་གྱིས་འཆི་བ་རྣམས་སླར་གསོན་དུ་མཛད་ཅིང་མེད་པ་ལས་གསར་དུ་འགོད་པ་གནང་མཁན་དཀོན་མཆོག་ལ་དད་པ་བྱས་པས་དེ་ལྟར་བྱུང་ངོ༌། ");
INSERT INTO bod_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","རེ་བ་བྱེད་པའི་རྒྱུ་རྐྱེན་མེད་པའི་སྐབས་སུ། ཨབ་ར་ཧམ་གྱིས་མི་རིགས་མང་པོའི་མེས་པོར་འགྱུར་བ་རེ་བ་བྱས། གང་ལགས་ཟེར་ན། དཀོན་མཆོག་གིས་ཁོང་ལ་ཁྱེད་ཀྱི་བུ་རྒྱུད་དེ་ལྟར་མང་པོར་འགྱུར་ངེས་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ཡང་དགུང་ལོ་བརྒྱ་ཙམ་ལོན་པས་རང་གི་གཟུགས་པོ་དང་ཁོང་གི་བཟའ་ཟླ་ས་རཱ་ཡི་མངལ་གཉིས་ནི་ཤི་བར་ལྟར་བསམས་ཀྱང་ཁོང་གི་དད་པ་མ་ཉམས། ");
INSERT INTO bod_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ཨབ་ར་ཧམ་གྱིས་ཐེ་ཚོམ་མེད་པར་དཀོན་མཆོག་གི་ཞལ་ཆད་ལ་ཡིད་ཆེས་པས། ཁོང་གི་དད་པ་འཕེལ་ཞིང་དཀོན་མཆོག་ལ་བཀུར་སྟི་བྱས་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","དཀོན་མཆོག་གིས་གང་ཞལ་གྱིས་བཞེས་པ་དེ་མཛད་ཐུབ་པའི་ཡིད་ཆེས་ཀྱི་ངེས་པ་རྙེད། ");
INSERT INTO bod_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","དེའི་ཕྱིར་ཁོང་གི་དད་པ་ནི་རྣམ་པར་དག་པར་བརྩིས་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","བརྩིས་པར་གྱུར་ཞེས་པའི་ཚིག་འདི་ཁོང་ཁོ་ནའི་དོན་ལ་བྲིས་པ་མ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ངེད་རྣམས་ཀྱི་དོན་དུ་ཡང་བྲིས་སོ། ངེད་རྣམས་ཀྱི་གཙོ་བོ་ཡེ་ཤུ་འཆི་བ་ལས་སླར་གསོན་པར་མཛད་མཁན་དཀོན་མཆོག་ལ་དད་པ་བྱེད་མཁན་རྣམས་ཀྱང་རྣམ་པར་དག་པའི་མི་ལ་རྩི་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ངེད་རྣམས་ཀྱི་སྡིག་ཉེས་ཀྱི་རྐྱེན་གྱིས་ཡེ་ཤུ་འཆི་བ་ལ་སྦྱོར་བའི་ཕྱིར་ཡ་ཧུ་དཱ་པར་གཏད་པར་གྱུར་ཞིང༌། ངེད་རྣམས་རྣམ་པར་དག་པར་འགྱུར་བའི་ཕྱིར་ཁོང་འཆི་བ་ནས་སྐུ་གསོན་པོར་བཞེངས་པར་གྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","དེའི་ཕྱིར་དཀོན་མཆོག་གི་སྤྱན་སྔར་དད་པའི་སྒོ་ནས་རྣམ་པར་དག་པར་བརྩིས་པར་གྱུར་བས། ངེད་རྣམས་ཀྱི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་དཀོན་མཆོག་དང་བསྡུམས་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","དད་པའི་སྒོ་ནས་ཁོང་གིས་ངེད་རྣམས་ཐུགས་རྗེའི་ནང་ཚུད་ཅིང་གནས་པར་མཛད་པས། ང་ཚོས་དགའ་མགུའི་སེམས་ཀྱིས་དཀོན་མཆོག་གི་གཟི་བརྗིད་ཀྱི་གནང་སྦྱིན་འཐོབ་པའི་རེ་སྒུག་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","དེ་མ་ཟད་སྡུག་བསྔལ་མྱོང་དུས་ང་ཚོས་དགའ་བར་བྱེད། གང་ལགས་ཟེར་ན། སྡུག་བསྔལ་ལས་བཟོད་པའི་སེམས་དང༌། ");
INSERT INTO bod_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","བཟོད་པའི་སེམས་ལས་རང་གཤིས་བཟང་པོ། རང་གཤིས་བཟང་པོ་ལས་རེ་བ་སྐྱེ་བ་ང་ཚོས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","རེ་བ་དེས་བློ་མི་འཕམ་མོ། གང་ཡིན་ཟེར་ན། ངེད་རྣམས་ལ་གནང་བའི་དམ་པའི་ཐུགས་ཉིད་ཀྱི་སྒོ་ནས་དཀོན་མཆོག་གི་བྱམས་པ་ང་ཚོའི་སེམས་ལ་ལྷག་པར་གནང་བ་ཡིན་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","གང་ལགས་ཤེ་ན། ངེད་རྣམས་ལ་ཐར་ཐབས་མེད་པའི་ཚེ། དུས་ལ་འབབ་སྐབས་མཱ་ཤི་ཀ་སྡིག་ཅན་རྣམས་ཀྱི་ཆེད་དུ་གྲོངས། ");
INSERT INTO bod_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","རང་གཤིས་བཟང་པོ་ཞིག་གི་དོན་ལ་སྲོག་གཏོང་བ་དེ་དཀོན་པོ་ཡིན་ཡང༌། མི་ཧ་ཅང་བཟང་པོ་ཞིག་གི་དོན་ལ་སྲོག་གཏོང་བར་ནུས་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","འོན་ཀྱང་ངེད་རྣམས་ད་དུང་སྡིག་ཉེས་ཅན་ཡིན་པའི་དུས་སུ། མཱ་ཤི་ཀ་ང་ཚོའི་དོན་དུ་སྐུ་སྲོག་བཏང་གནང་བའི་སྒོ་ནས་དཀོན་མཆོག་ཉིད་ཀྱི་བྱམས་པ་ཇི་ཙམ་ཡོད་པ་ངེད་རྣམས་ལ་བསྟན་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ད་ཁོང་གི་སྐུ་ཁྲག་གི་སྒོ་ནས་ངེད་རྣམས་རྣམ་པར་དག་པར་བརྩིས་པར་གྱུར་བས། ཁོང་བརྒྱུད་ནས་ང་ཚོ་དེ་བས་ཀྱང་དཀོན་མཆོག་གི་ཐུགས་ཁྲོ་ལས་ཐར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","གང་ཡིན་ཞེ་ན། ང་ཚོ་དཀོན་མཆོག་གི་དགྲ་བོ་ཡིན་པའི་དུས་སུ། ཁོང་གིས་ཉིད་ཀྱི་སྲས་སྐུ་སྲོག་བཏང་གནང་བའི་སྒོ་ནས་ང་ཚོ་དང་བསྡུམས་པར་མཛད་ན། ད་བསྡུམས་ཚར་བས་དེ་བས་ཀྱང་ཁོང་གི་སྐུ་ཚེ་ཡིས་ངེད་རྣམས་ཐར་བར་མཛད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","དེས་མ་ཟད་ང་ཚོའི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་ངེད་རྣམས་དཀོན་མཆོག་དང་བསྡུམས་པས་ང་ཚོས་དཀོན་མཆོག་ལ་ཡི་རང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","མི་གཅིག་གི་རྐྱེན་གྱིས་སྡིག་ཉེས་འཛམ་གླིང་དུ་བྱུང་ཞིང༌། སྡིག་ཉེས་ལས་འཆི་བ་བྱུང་བས། ཐམས་ཅད་ཀྱིས་སྡིག་པའི་ལས་བྱས་པའི་རྐྱེན་གྱིས་འཆི་བ་ནི་མིའི་རིགས་ཀུན་ལ་བྱུང༌། ");
INSERT INTO bod_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ཆོས་ཁྲིམས་མ་གནང་བའི་སྔོན་ལ་སྡིག་ཉེས་འཛམ་གླིང་དུ་ཡོད་ཀྱང༌། ཁྲིམས་མེད་པས་སྡིག་ཉེས་དེ་སྡིག་ཉེས་སུ་མ་བརྩིས། ");
INSERT INTO bod_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","འོན་ཀྱང་ཨ་དམ་ནས་ལུང་སྟོན་པ་མོ་ཤེའི་དུས་ཀྱི་བར་དུ་མི་ཚང་མ་འཆི་བའི་དབང་འོག་ཏུ་ཡོད། ཐ་ན་སྡིག་པའི་ལས་བྱེད་མཁན་རྣམས་ཨ་དམ་གྱིས་དཀོན་མཆོག་གི་བཀའ་དང་འགལ་བ་ལྟར་བྱས་པ་མ་ཡིན་ཀྱང་ཁོ་ཚོ་ཡང་འཆི་བའི་དབང་འོག་ཏུ་ཡོད། ཨ་དམ་ནི་འབྱོན་པར་འགྱུར་བའི་མཱ་ཤི་ཀ་ཡི་དཔེ་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","འོན་ཀྱང་དཀོན་མཆོག་གི་རིན་ཐང་བྲལ་བའི་ཐུགས་རྗེའི་གནང་སྦྱིན་ནི་ཁྲིམས་འགལ་དང་མི་འདྲ་བ་ཡིན། གང་ཡིན་ཞེ་ན། མི་གཅིག་གིས་བཀའ་ཁྲིམས་དང་འགལ་བའི་རྐྱེན་གྱིས་མི་མང་པོ་ཤི་ན་ཡང༌། ཡེ་ཤུ་མཱ་ཤི་ཀ་མི་གཅིག་གི་ཐུགས་རྗེ་བརྒྱུད་ནས་བྱུང་བའི་དཀོན་མཆོག་གི་ཐུགས་རྗེའི་གནང་སྦྱིན་དེ་བས་ཀྱང་མི་མང་པོར་འཕེལ་བར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ཡང་དཀོན་མཆོག་གི་རིན་ཐང་བྲལ་བའི་ཐུགས་རྗེའི་གནང་སྦྱིན་ནི་མི་གཅིག་གིས་བྱས་པའི་སྡིག་ཉེས་ཀྱི་འབྲས་བུ་དང་མི་འདྲ་བ་ཡིན། གང་ཡིན་ཟེར་ན། ཨ་དམ་གྱིས་བཀའ་ཁྲིམས་དང་འགལ་བ་ལས་ཁྲིམས་གཅོད་བྱུང༌། འོན་ཀྱང་དཀོན་མཆོག་གི་ཐུགས་རྗེའི་གནང་སྦྱིན་དེ་བཀའ་ཁྲིམས་དང་འགལ་བ་མང་པོའི་རྗེས་སུ་བྱུང་བ་དང༌། དེའི་འབྲས་བུ་མི་མང་པོ་རྣམ་པར་དག་པར་གྱུར་བ་དེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","གལ་ཏེ་མི་གཅིག་གིས་བཀའ་ཁྲིམས་དང་འགལ་བའི་རྐྱེན་གྱིས་མི་མང་པོ་འཆི་བའི་དབང་འོག་ཏུ་གྱུར་ན། དེ་བས་ཀྱང་དཀོན་མཆོག་གི་ཡོངས་སུ་རྫོགས་པའི་ཐུགས་རྗེ་དང་རྣམ་པར་དག་པ་དེ་དཀོན་མཆོག་གི་གནང་སྦྱིན་འཐོབ་མཁན་རྣམས། མི་གཅིག་སྟེ་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་གསོན་པར་འགྱུར་ཏེ་རྒྱལ་སྲིད་སྐྱོང་ངོ༌། ། ");
INSERT INTO bod_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","དེ་བས་ན་མི་གཅིག་གིས་བཀའ་ཁྲིམས་དང་འགལ་བས་ཐམས་ཅད་ཁྲིམས་གཅོད་མྱོང་དགོས་པ་བཞིན། དེ་ལྟར་མི་གཅིག་གིས་དྲང་བདེན་ཉིད་ཀྱི་བྱ་བ་མཛད་པས་ཐམས་ཅད་རྣམ་པར་དག་པར་འགྱུར་ཞིང༌། དཔག་ཏུ་མེད་པའི་ཚེ་འཐོབ། ");
INSERT INTO bod_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","གང་ལགས་ཟེར་ན། མི་གཅིག་གིས་བཀའ་ལ་མ་ཉན་པས་མི་མང་པོ་སྡིག་ཉེས་ཅན་དུ་གྱུར་བ་ལྟར། དེ་བཞིན་མི་གཅིག་གིས་བཀའ་ལ་ཉན་པས་མི་མང་པོ་རྣམ་པར་དག་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ཁྲིམས་དང་འགལ་བ་གང་ཡིན་པ་ཤེས་པའི་ཕྱིར་ཆོས་ཁྲིམས་བྱུང༌། འོན་ཀྱང་སྡིག་ཉེས་འཕེལ་བས་ཐུགས་རྗེ་དེ་བས་ཀྱང་འཕེལ། ");
INSERT INTO bod_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","དེ་བས་ན་སྔོན་མ་སྡིག་ཉེས་ཀྱིས་འཆི་བའི་སྒོ་ནས་དབང་དུ་བསྒྱུར་མོད། ད་ལྟ་དཀོན་མཆོག་གི་ཐུགས་རྗེ་ཡིས་དབང་དུ་སྒྱུར། དེའི་འབྲས་བུ་ནི་ངེད་རྣམས་ཀྱི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་ང་ཚོར་དཀོན་མཆོག་དང་ཡང་དག་པའི་འབྲེལ་བ་ཡོད་ཅིང༌། དཔག་ཏུ་མེད་པའི་ཚེའང་འཐོབ་བོ། ། ");
INSERT INTO bod_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","འོ་ན། ང་ཚོས་ཅི་ཟེར་བར་བྱ། ཐུགས་རྗེ་འཕེལ་བའི་ཆེད་དུ་ངེད་རྣམས་སྡིག་ཉེས་ལ་གནས་པར་བྱའམ། ");
INSERT INTO bod_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","དེ་མི་སྲིད། ངེད་རྣམས་སྡིག་ཉེས་ལས་འདས་ཟིན་པས་ད་དུང་དེའི་ནང་འཚོ་བར་ཅི་ལྟར་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","མཱ་ཤི་ཀ་ཡེ་ཤུའི་ཐོག་ནས་ཁྲུས་གསོལ་ལེན་མཁན་ངེད་ཐམས་ཅད་ཀྱིས་ཁོང་གྲོངས་པའི་ཐོག་ནས་ཁྲུས་གསོལ་བླངས་པ་དེ་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","དེའི་ཕྱིར་ཁྲུས་གསོལ་ལེན་པའི་སྒོ་ནས་ངེད་རྣམས་ཁོང་དང་མཉམ་དུ་ཤི་ནས་དུར་དུ་བཅུག་པ་ལྟར་ཡིན་པས། དེ་ནི་ཡབ་ཀྱི་གཟི་བརྗིད་དང་ལྡན་པའི་ནུས་མཐུ་ཡིས་མཱ་ཤི་ཀ་སླར་གསོན་དུ་མཛད་པ་བཞིན། ང་ཚོའང་ཚེ་གསར་ཞིག་གི་ནང་འཚོ་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","གང་ཡིན་ཞེ་ན། གལ་སྲིད་དེ་ལྟར་ཁོང་གྲོངས་པའི་ཐོག་ནས་ངེད་རྣམས་ཁོང་དང་གཅིག་ཏུ་གྱུར་ན། ཁོང་དང་གཅིག་ཏུ་སླར་གསོན་པོར་ཡང་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ད་ཕྱིན་ཆད་ངེད་རྣམས་སྡིག་ཉེས་ཀྱི་བྲན་གཡོག་མ་ཡིན་པའི་ཆེད་དུ་དང༌། སྡིག་ཉེས་ཀྱི་དབང་འོག་ཏུ་མི་གནས་པའི་ཕྱིར། ང་ཚོ་སྡིག་ཉེས་ཅན་གྱི་གང་ཟག་རྙིང་པ་དེ་མེད་པར་འགྱུར་བའི་ཕྱིར་མཱ་ཤི་ཀ་དང་མཉམ་དུ་རྒྱང་ཤིང་སྒང་ལ་བརྒྱངས་པ་ཡིན་པ་ངེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","གང་ལགས་ཟེར་ན། ཤི་ཟིན་པ་དེ་སྡིག་ཉེས་ཀྱི་དབང་ལས་ཐར་བར་གྱུར་བ་ཡིན་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ངེད་རྣམས་མཱ་ཤི་ཀ་དང་མཉམ་དུ་ཤི་བ་ཡིན་ན། ཁོང་དང་མཉམ་དུ་འཚོ་བར་ཡང་ཡིད་ཆེས། ");
INSERT INTO bod_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","མཱ་ཤི་ཀ་འཆི་བ་ནས་སླར་གསོན་པོར་གྱུར་བ་ཡིན་ཏེ་ཡང་བསྐྱར་འགྲོངས་མི་སྲིད་པས། ད་ཕྱིན་ཆད་ཁོང་འཆི་བའི་དབང་འོག་ཏུ་མིན་པ་ངེད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ཁོང་གྲོངས་པ་དེ་སྡིག་ཉེས་ཀྱི་དབང་ལས་རྒྱལ་བའི་ཕྱིར་ཐེངས་གཅིག་གྲོངས། ཁོང་འཚོ་བ་དེ་དཀོན་མཆོག་ཐུགས་མཉེས་ཕྱིར་འཚོ། ");
INSERT INTO bod_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","དེ་བས་ན་ཁྱེད་ཚོའང་སྡིག་ཉེས་ཀྱི་དབང་འོག་ཏུ་མི་གནས་པ་དང༌། མཱ་ཤི་ཀ་ཡེ་ཤུ་བརྒྱུད་ནས་དཀོན་མཆོག་ཐུགས་མཉེས་ཕྱིར་གསོན་པ་ཡིན་པར་རྩིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","དེའི་ཕྱིར་འདོད་ཆགས་ཀྱི་དབང་དུ་མི་འགྲོ་བའི་ཆེད་དུ་སྡིག་ཉེས་ཀྱིས་ཁྱེད་ཚོའི་མི་རྟག་པའི་ལུས་ལ་དབང་བསྒྱུར་དུ་མ་འཇུག ");
INSERT INTO bod_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ལུས་ཀྱི་ཡན་ལག་དེ་ངན་པ་ལ་གཡོག་བྱེད་པའི་ལག་ཆ་ལྟར་སྡིག་ཉེས་ལ་མ་གཏོད། དེ་ལས་ལྡོག་སྟེ་ཤི་ནས་གསོན་པོར་གྱུར་བ་ལྟར་ཁྱོད་ཚོས་རང་ཉིད་དཀོན་མཆོག་ལ་ཕུལ་ཞིང༌། ལུས་ཀྱི་ཡན་ལག་ཀྱང་ཡང་དག་པ་ཉིད་ཀྱི་ལག་ཆ་ལྟར་ཁོང་ལ་མཆོད་པ་ཕུལ་ཞིག ");
INSERT INTO bod_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","སྡིག་ཉེས་ཀྱིས་ཁྱེད་ཚོར་དབང་མི་བསྒྱུར། གང་ཡིན་ཞེ་ན། ཁྱེད་ཚོ་ཆོས་ཁྲིམས་ཀྱི་དབང་འོག་ཏུ་མ་ཡིན་པར་ཐུགས་རྗེའི་དབང་འོག་ཏུ་ཡོད་པས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","བྱས་ན། ཆོས་ཁྲིམས་ཀྱི་དབང་འོག་ཏུ་མིན་ཏེ་ཐུགས་རྗེའི་དབང་འོག་ཏུ་ཡོད་པས་སྡིག་ཉེས་བྱེད་དམ། དེ་རྩ་བ་ནས་མི་རུང༌། ");
INSERT INTO bod_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","གང་གི་བཀའ་ལ་ཉན་པ་དེའི་བྲན་གཡོག་ཏུ་འགྱུར་བ་ཁྱེད་ཚོས་མི་ཤེས་སམ། སྡིག་ཉེས་ཀྱི་བྲན་གཡོག་ཏུ་གྱུར་བའི་འབྲས་བུ་ནི་འཆི་བ་དང༌། བཀའ་ལ་ཉན་པའི་བྲན་གཡོག་ཏུ་གྱུར་བའི་འབྲས་བུ་ནི་དཀོན་མཆོག་ཐུགས་མཉེས་པའི་སྤྱོད་ལམ་བཟང་པོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","སྔོན་མ་སྡིག་ཉེས་ཀྱི་བྲན་གཡོག་བྱས་ཀྱང༌། ད་ཁྱེད་ཚོར་གཏད་པར་གྱུར་བའི་བསྟན་པ་ལ་སྙིང་ཐག་པ་ནས་ཉན་པས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུའོ། ");
INSERT INTO bod_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","སྡིག་ཉེས་ལས་བསྒྲལ་ཏེ་ཁྱེད་ཚོ་དྲང་བདེན་གྱི་སྤྱོད་པའི་བྲན་གཡོག་ཏུ་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ཁྱེད་ཚོའི་རྟོགས་པའི་ནུས་པ་ཞན་པས་ངས་མིའི་ལུགས་སྲོལ་ལྟར་བརྗོད་དེ། སྔར་ཁྱེད་རྣམས་ཀྱིས་ལུས་ཀྱི་ཡན་ལག་མི་གཙང་བ་དང་ངན་པའི་གཡོག་བྱེད་དུ་གཏད་དེ་དེ་བས་ངན་པ་མང་དུ་འཕེལ་བཞིན། ད་ལྟ་དམ་པར་འཕེལ་བའི་ཕྱིར་ཁྱེད་ཀྱི་ཡན་ལག་སྤྱོད་པ་བཟང་པོ་ལ་གཡོག་བྱེད་པར་གཏོད་ཅིག ");
INSERT INTO bod_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","སྡིག་ཉེས་ཀྱི་གཡོག་བྱེད་དུས་ཁྱེད་ཚོ་དྲང་བདེན་ཉིད་ཀྱི་དབང་བསྒྱུར་ལས་བྲལ་ལོ། ");
INSERT INTO bod_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","དེ་བས་ན། ད་ལྟ་ངོ་ཚ་བར་རྩི་བའི་དོན་དེ་རྣམས་ལས་ཕན་ཐོགས་ཅི་ཐོབ། དེ་ཚོའི་འབྲས་བུ་ནི་འཆི་བ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ད་ལྟ་ཁྱེད་རྣམས་སྡིག་ཉེས་ལས་ཐར་བར་གྱུར་ནས་དཀོན་མཆོག་གི་བྲན་གཡོག་བྱེད་པས། དམ་པར་འགྱུར་བའི་ཕན་ཐོགས་འཐོབ། དེའི་འབྲས་བུ་ནི་དཔག་ཏུ་མེད་པའི་ཚེ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","དེས་ན་སྡིག་ཉེས་ཀྱི་གླ་ཆ་ནི་འཆི་བ་ཡིན། འོན་ཀྱང་དཀོན་མཆོག་གི་རིན་ཐང་བྲལ་བའི་ཐུགས་རྗེའི་གནང་སྦྱིན་ནི་མཱ་ཤི་ཀ་ཡེ་ཤུ་ངེད་རྣམས་ཀྱི་གཙོ་བོ་བརྒྱུད་ནས་ཐོབ་པའི་དཔག་ཏུ་མེད་པའི་ཚེ་དེ་ཡིན་ནོ། ། ");
INSERT INTO bod_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","སྤུན་ཟླ་རྣམས། ངས་ཆོས་ཁྲིམས་རྒྱུས་ཡོད་པ་རྣམས་ལ་སྨྲ་སྟེ། མི་ཞིག་གསོན་པའི་དུས་ཁོ་ནར་ཆོས་ཁྲིམས་ཀྱིས་ཁོ་ལ་ཁྲིམས་འཛིན་གྱི་དབང་ཆ་ཡོད་པར་ཁྱེད་ཚོས་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","དཔེར་ན། ཁྱོ་བོ་གསོན་པའི་རིང་ལ་ཁོའི་བཟའ་ཟླ་གཉེན་སྒྲིག་གི་བཀའ་ཁྲིམས་ཀྱི་དབང་འོག་ཏུ་ཡོད་ཀྱང༌། ཁྱོ་བོ་ཤི་ན་བུད་མེད་དེ་གཉེན་སྒྲིག་གི་བཀའ་ཁྲིམས་དང་བྲལ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","དེའི་ཕྱིར་ཁྱོ་བོ་གསོན་པའི་རིང་ལ་བུད་མེད་དེས་སྐྱེས་པ་གཞན་དང་འགྲོགས་ན་ལོག་གཡེམ་བྱེད་མཁན་ཞེས་ཟེར་བར་འགྱུར། འོན་ཀྱང་བུད་མེད་དེའི་ཁྱོ་བོ་ཤི་ན། གཉེན་སྒྲིག་གི་བཀའ་ཁྲིམས་དང་བྲལ་བར་འགྱུར་བས་སྐྱེས་པ་གཞན་དང་གཉེན་སྒྲིག་བྱས་ནའང་ལོག་གཡེམ་པ་མ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ངའི་སྤུན་ཟླ་རྣམས། དེ་བཞིན་དུ་ཁྱེད་ཚོའང་མཱ་ཤི་ཀ་དང་མཉམ་དུ་རྒྱང་ཤིང་ཐོག་ཆོས་ཁྲིམས་ཀྱི་ངོས་ནས་འཆི་བའོ། དེ་ནི་མི་གཞན་ཏེ་འཆི་བ་ནས་སླར་གསོན་དུ་མཛད་པ་ཁོང་དང་འགྲོགས་པའི་ཆེད་ཅིང༌། ངེད་རྣམས་དཀོན་མཆོག་གི་དོན་ལ་འབྲས་བུ་དང་ལྡན་པར་འགྱུར་བའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","སྡིག་པའི་རང་གཤིས་ཀྱི་དབང་འོག་ཏུ་ཡོད་པའི་དུས་སུ། ཆོས་ཁྲིམས་ཀྱི་རྐྱེན་གྱིས་འདོད་ཆགས་སྐྱེས་ཏེ་ང་ཚོའི་ལུས་ཀྱི་ཡན་ལག་རྣམས་ངན་པར་བསྐུལ། དེའི་རྐྱེན་གྱིས་ང་ཚོར་འཆི་བའི་འབྲས་བུ་བསྐྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","འོན་ཀྱང་ད་ལྟ་ཆོས་ཁྲིམས་ལས་ཐར་ཏེ་བཅིངས་པར་བྱེད་པའི་ཆོས་ཁྲིམས་ཀྱི་ཆ་ནས་ངེད་རྣམས་ཤི་བས། ང་ཚོས་ཆོས་ཁྲིམས་ཀྱི་ཚིག་འབྲུའི་ལུགས་རྙིང་པ་ལྟར་མིན་ཏེ་དམ་པའི་ཐུགས་ཉིད་ཀྱི་ལུགས་གསར་པ་བཞིན་དུ་ཞབས་ཞུ་སྒྲུབ། ");
INSERT INTO bod_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","དེ་བས་ན་ང་ཚོས་ཅི་ཟེར། ཆོས་ཁྲིམས་ནི་སྡིག་པ་ཡིན་ནམ། དེ་མི་སྲིད། དེ་ལས་ལྡོག་སྟེ་ཆོས་ཁྲིམས་མེད་པ་ཡིན་ན་ངས་སྡིག་ཉེས་གང་ཡིན་པ་མི་ཤེས། དཔེར་ན། ཆོས་ཁྲིམས་ཀྱིས་ཧམ་འདོད་མ་བྱོས་ཤིག་ཅེས་མ་གསུངས་ན་ངས་ཧམ་འདོད་བྱེད་ཅེས་པ་དེ་གང་ཡིན་པར་མི་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","སྡིག་ཉེས་ཀྱིས་བཀའ་ཁྲིམས་ཀྱི་སྒོ་ནས་ངའི་སེམས་ལ་ཧམ་འདོད་ཀྱི་རིགས་ཀུན་སྐྱེད་དུ་བཅུག གང་ཡིན་ཞེ་ན། ཆོས་ཁྲིམས་མེད་ན་སྡིག་ཉེས་ལ་དབང་མེད་དོ། ");
INSERT INTO bod_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","སྔོན་གྱི་དུས་ན་ང་ཆོས་ཁྲིམས་དང་བྲལ་ནས་འཚོ་ཡང༌། བཀའ་ཁྲིམས་བྱུང་བའི་རྗེས་སུ་སྡིག་ཉེས་གསོན་པོར་གྱུར་ཞིང་ང་ཤི་སྟེ། ");
INSERT INTO bod_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ཚེ་ཡོང་བའི་ཆེད་དུ་གནང་བའི་བཀའ་ཁྲིམས་འདི་ཉིད་ང་ཤི་བའི་རྒྱུ་རྐྱེན་དུ་གྱུར་བར་ངས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","གང་ཡིན་ཟེར་ན། སྡིག་ཉེས་ཀྱིས་བཀའ་ཁྲིམས་ཀྱི་ཐབས་བྱས་ཏེ་ང་ལ་མགོ་སྐོར་བཏང་ནས་བཀའ་ཁྲིམས་ཀྱིས་ང་བསད། ");
INSERT INTO bod_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","དེའི་ཕྱིར་ཆོས་ཁྲིམས་ནི་དམ་པ་ཡིན་ཏེ། དེའི་ནང་གི་བཀའ་ཁྲིམས་ཀྱང་དམ་པ་དང༌། དྲང་བདེན་ཉིད་དང་ལྡན་པ། བཟང་པོ་བཅས་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","འོ་ན་གང་བཟང་པོ་ཡིན་པ་དེ་ང་འཆི་བའི་རྒྱུ་རྐྱེན་དུ་གྱུར་བ་ཡིན་ནམ། དེ་རྩ་བ་ནས་མིན། སྡིག་ཉེས་ངན་པ་ཡིན་པར་སྟོན་པའི་ཕྱིར་དེས་གང་བཟང་པོ་ཡིན་པའི་སྒོ་ནས་ང་ལ་འཆི་བ་བསྐྱེད་དུ་བཅུག དེ་ནི་བཀའ་ཁྲིམས་ཀྱི་ངང་ནས་སྡིག་ཉེས་དེ་དཔེ་མི་སྲིད་པའི་ངན་པར་མངོན་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ཆོས་ཁྲིམས་དཀོན་མཆོག་ལས་བྱུང་བ་ངེད་རྣམས་ཀྱིས་ཤེས། འོན་ཀྱང་ང་ལ་མིའི་རིགས་ཀྱི་སྡིག་པའི་རང་གཤིས་ཡོད་པས། སྡིག་ཉེས་ལ་བྲན་གཡོག་ལྟར་བཙོངས། ");
INSERT INTO bod_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ངའི་སྤྱོད་ལམ་མི་རྟོགས། གང་ཡིན་ཞེ་ན། ངས་གང་འདོད་པ་དེ་མི་བྱེད་དེ། གང་སྡང་བ་དེ་རང་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ངས་མི་འདོད་པ་ལྟར་བྱས་ན། ངས་ཆོས་ཁྲིམས་བཟང་པོ་ཡིན་པ་ཁས་ལེན་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","དོན་དམ་དུ་ང་རང་གིས་དེ་ལྟར་བྱེད་པ་མ་ཡིན་ཏེ། ངའི་ནང་དུ་གནས་པའི་སྡིག་ཉེས་ཀྱིས་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ངའི་སྡིག་པའི་རང་གཤིས་ལ་བཟང་པོ་ཅིའང་མེད་པར་ངས་ཤེས། གང་ལགས་ཤེ་ན། བཟང་པོ་བྱེད་པར་འདོད་ནའང༌། ངས་སྒྲུབ་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ངས་འདོད་པའི་བཟང་པོ་དེ་མི་བྱེད། འོན་ཀྱང་ངས་མི་འདོད་པའི་ངན་པ་དེ་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","གལ་སྲིད་ངས་མི་འདོད་པའི་བྱ་བ་བྱས་ན། ང་རང་གིས་བྱེད་པ་མ་ཡིན་ཏེ། ངའི་ནང་དུ་གནས་པའི་སྡིག་ཉེས་ཀྱིས་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","དེ་བས་ན་ངས་བཟང་པོ་བྱེད་འདོད་པའི་ཚེ་ངན་པ་ངའི་འཁྲིས་སུ་ཡོད་པའི་གནས་ལུགས་རྟོགས། ");
INSERT INTO bod_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ངའི་སེམས་ཀྱི་གཏིང་ནས་དཀོན་མཆོག་གི་ཁྲིམས་ལ་དགའ་བར་བྱེད་མོད། ");
INSERT INTO bod_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ངའི་ལུས་ཀྱི་ནང་ན་ཁྲིམས་གཞན་ཞིག་ཡོད་པར་ཤེས། དེས་སེམས་ཀྱི་ཁྲིམས་ལ་རྒོལ་ཞིང༌། ང་ནི་ངའི་ལུས་ལ་གནས་པའི་ཁྲིམས་ཀྱི་བཙོན་པར་སྒྱུར། ");
INSERT INTO bod_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ང་ཉམ་ཐག་པ་ཡིན་ཏེ། འཆི་བས་དབང་དུ་སྒྱུར་བའི་ལུས་འདི་ལས་ང་ཐར་བར་བྱེད་མཁན་སུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ངེད་རྣམས་ཀྱི་གཙོ་བོ་ཡེ་ཤུ་མཱ་ཤི་ཀ་བརྒྱུད་ནས་དཀོན་མཆོག་ལ་བཀའ་དྲིན་ཆེ་ཞུའོ། མདོར་བསྡུས་ན་ངའི་སེམས་ཀྱིས་དཀོན་མཆོག་གི་ཁྲིམས་ལ་གཡོག་བྱེད་ཀྱང༌། ངའི་སྡིག་པའི་རང་གཤིས་ཀྱིས་སྡིག་ཉེས་ཀྱི་ཁྲིམས་ལ་གཡོག་བྱེད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","དེའི་ཕྱིར་ད་ནས་མཱ་ཤི་ཀ་ཡེ་ཤུའི་ནང་ན་གནས་པ་རྣམས་ལ་ཆད་པ་ཅིའང་མེད། ");
INSERT INTO bod_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","གང་ལགས་ཟེར་ན། ཚེ་གསར་པ་གནང་བའི་དམ་པའི་ཐུགས་ཉིད་ཀྱི་བཀའ་ཁྲིམས་ཀྱིས་མཱ་ཤི་ཀ་ཡེ་ཤུ་བརྒྱུད་ནས་ཁྱེད་རྣམས་སྡིག་ཉེས་དང་འཆི་བའི་དབང་ལས་བསྒྲལ་བར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","མིའི་རིགས་ཀྱི་སྡིག་པའི་རང་གཤིས་ཀྱི་དབང་གིས་སྟོབས་ཉམས་པར་གྱུར་བའི་ཆོས་ཁྲིམས་ཀྱིས་བྱེད་མ་ཐུབ་པ་དེ་དཀོན་མཆོག་གིས་བསྒྲུབས་པར་མཛད། ཁོང་གིས་རང་ཉིད་ཀྱི་སྲས་སྡིག་ཅན་གྱི་ལུས་དང་འདྲ་བའི་སྐུ་གཟུགས་དང་ལྡན་པར་ངེད་རྣམས་ཀྱི་སྡིག་ཉེས་སེལ་བའི་དོན་དུ་མཆོད་པར་འགྱུར་བའི་ཕྱིར་མངགས་ཏེ། མིའི་རིགས་ཀྱི་རང་གཤིས་ལ་གནས་པའི་སྡིག་ཉེས་ཁྲིམས་ཐག་གཅོད་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","དེ་ནི་སྡིག་པའི་རང་གཤིས་ལྟར་འཚོ་བ་མིན་པར་དམ་པའི་ཐུགས་ཉིད་བཞིན་དུ་འཚོ་བ་ངེད་རྣམས་ཀྱི་ནང་ན་ཆོས་ཁྲིམས་ཀྱི་དྲང་བདེན་གྱི་དགོས་པ་སྒྲུབ་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","སྡིག་པའི་རང་གཤིས་དང་བསྟུན་པའི་སྤྱོད་པ་བྱེད་མཁན་རྣམས་ཀྱིས་སྡིག་ཉེས་ཀྱི་སྐོར་བློ་གཅིག་ཏུ་སེམས། འོན་ཀྱང་དམ་པའི་ཐུགས་ཉིད་དང་བསྟུན་པའི་སྤྱོད་པ་བྱེད་མཁན་རྣམས་ཀྱིས་ཐུགས་ཉིད་གང་མཉེས་པའི་སྐོར་བློ་གཅིག་ཏུ་སེམས། ");
INSERT INTO bod_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","སྡིག་པའི་རང་གཤིས་ལ་བློ་གཅིག་ཏུ་སེམས་པའི་འབྲས་བུ་ནི་འཆི་བ་ཡིན། འོན་ཀྱང་དམ་པའི་ཐུགས་ཉིད་ལ་བློ་གཅིག་ཏུ་བསམས་ན་དཔག་ཏུ་མེད་པའི་ཚེ་དང་ཞི་བདེ་ཡིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","དེའི་ཕྱིར་སྡིག་པའི་རང་གཤིས་ལ་བློ་གཅིག་ཏུ་སེམས་པ་འདིས་དཀོན་མཆོག་ལ་རྒོལ། དེས་དཀོན་མཆོག་གི་བཀའ་ཁྲིམས་མི་སྲུང་ཞིང་སྲུང་ཡང་མི་སྲིད་པས། ");
INSERT INTO bod_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","སྡིག་པའི་རང་གཤིས་ལྟར་མི་ཚེ་སྐྱེལ་བ་རྣམས་ཀྱིས་དཀོན་མཆོག་ཐུགས་མཉེས་པ་བྱེད་མི་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","གལ་ཏེ་དཀོན་མཆོག་གི་ཐུགས་ཉིད་ཁྱེད་རྣམས་ལ་དངོས་སུ་བཞུགས་ན། ཁྱེད་ཚོ་སྡིག་ཅན་གྱི་རང་གཤིས་མིན་ཏེ་དམ་པའི་ཐུགས་ཉིད་ཀྱི་དབང་འོག་ཏུ་ཡོད། གལ་ཏེ་སུ་ཞིག་ལ་མཱ་ཤི་ཀའི་ཐུགས་ཉིད་མེད་ན། མཱ་ཤི་ཀའི་ཁོངས་གཏོགས་མིན། ");
INSERT INTO bod_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","གལ་ཏེ་མཱ་ཤི་ཀ་ཁྱེད་ཚོའི་ནང་བཞུགས་ན། སྡིག་ཉེས་ཀྱི་རྐྱེན་གྱིས་ལུས་ཤི་བ་ཡིན་ཡང༌། དཀོན་མཆོག་གི་སྤྱན་སྔར་ཁྱེད་ཚོ་རྣམ་པར་དག་པ་ཡིན་པས་སེམས་གསོན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ཡེ་ཤུ་འཆི་བ་ནས་སླར་གསོན་དུ་མཛད་མཁན་གྱི་དམ་པའི་ཐུགས་ཉིད་ཁྱེད་རྣམས་ཀྱི་ནང་ལ་བཞུགས་ན། དེ་ལྟར་མཛད་མཁན་གྱིས་ཁྱེད་རྣམས་ཀྱི་ནང་ལ་བཞུགས་ཏེ་ཁོང་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱི་སྒོ་ནས་ཁྱེད་ཀྱི་མི་རྟག་པའི་ལུས་ཀྱང་གསོན་པོར་མཛད་པར་འགྱུར་ངེས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","སྤུན་ཟླ་རྣམས། དེའི་ཕྱིར་སྡིག་པའི་རང་གཤིས་དང་བསྟུན་པའི་སྤྱོད་པ་བྱེད་མི་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","གང་ཡིན་ཞེ་ན། སྡིག་པའི་རང་གཤིས་དང་བསྟུན་པའི་སྤྱོད་པ་བྱས་ན་འཆི་བར་ངེས། འོན་ཀྱང་དམ་པའི་ཐུགས་ཉིད་ཀྱི་སྒོ་ནས་སྡིག་པའི་སྤྱོད་པ་མེད་པར་བྱས་ན་གསོན་པོར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","གང་ཡིན་ཟེར་ན། དཀོན་མཆོག་གི་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་འཁྲིད་པ་ཐམས་ཅད་ནི་དཀོན་མཆོག་གི་སྲས་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ཡང་དཀོན་མཆོག་གིས་ཁྱེད་རྣམས་ལ་གནང་བའི་ཐུགས་ཉིད་ཀྱིས་ཁྱེད་ཚོ་ཞེད་སྣང་དང་ལྡན་པའི་བྲན་གཡོག་མིན་ཏེ། ཁོང་གི་སྲས་སུ་འགྱུར་བར་མཛད། ཁོང་གི་སྒོ་ནས་ངེད་རྣམས་ཀྱིས་ཨབ་པཱ་ཡབ་ཅེས་འབོད། ");
INSERT INTO bod_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ཐུགས་ཉིད་ཀྱིས་ང་ཚོའི་སེམས་དང་འགྲོགས་ཏེ་ངེད་རྣམས་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོ་ཡིན་པར་བདེན་དཔང་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","དེས་ན་ངེད་རྣམས་ནི་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོ་ཡིན་ན། མཱ་ཤི་ཀ་དང་མཉམ་དུ་དཀོན་མཆོག་གི་ཞལ་ཆད་འཛིན་མཁན་ཡང་ཡིན། གལ་ཏེ་ངེད་རྣམས་མཱ་ཤི་ཀ་དང་མཉམ་དུ་སྡུག་བསྔལ་མྱོང་ན་ཁོང་དང་ལྷན་དུ་འགྲོགས་ཏེ་གཟི་བརྗིད་དང་ལྡན་པར་འགྱུར་རོ། ། ");
INSERT INTO bod_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ངའི་བསམ་པར། དེང་དུས་ཀྱི་སྡུག་བསྔལ་ནི་མ་འོངས་པའི་དུས་སུ་ངེད་རྣམས་ལ་མངོན་པར་འགྱུར་བའི་གཟི་བརྗིད་དང་བསྡུར་ན་ཅི་ཡང་མིན། ");
INSERT INTO bod_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","དཀོན་མཆོག་གིས་གང་བཀོད་པ་ཐམས་ཅད་ཀྱིས་དཀོན་མཆོག་གི་སྲས་རྣམས་མངོན་སུམ་དུ་འགྱུར་བར་གདུང་ཞིང་སྒུག ");
INSERT INTO bod_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","21","གང་ལགས་ཟེར་ན། དཀོན་མཆོག་གིས་གང་བཀོད་པ་རྣམས་རང་གི་འདོད་པ་ལྟར་མེད་དེ། ཁོང་གི་དགོངས་པ་ལྟར་དོན་མེད་པའི་དབང་དུ་བཅུག དེ་ནི་རེ་བ་བྱེད་དེ་གང་བཀོད་པ་འཇིག་པ་ལས་བསྒྲལ་ནས་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོ་རྣམས་ཀྱི་གཟི་བརྗིད་དང་ལྡན་པའི་རང་དབང་འཐོབ་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ད་ལྟའི་བར་དུ་དཀོན་མཆོག་གིས་གང་བཀོད་པ་ཐམས་ཅད་སྦྲུམ་མར་སྐྱེ་ཟུག་ལང་བ་ལྟར་འཁུན་སྒྲ་འབྱིན་པ་ངེད་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","དེ་མ་ཟད་དམ་པའི་ཐུགས་ཉིད་ལོ་ཏོག་གི་ཕུད་དང་ལྡན་པ་ངེད་རྣམས་ཀྱང་དཀོན་མཆོག་གི་སྲས་སུ་གྱུར་བ་དང༌། ང་ཚོའི་ལུས་པོ་སྡིག་ཉེས་དང་སྡུག་བསྔལ་ལས་སྒྲོལ་ཏེ་མི་འཇིག་པའི་ལུས་གསར་པ་འཐོབ་པར་རེ་སྒུག་བྱེད་དུས་ཁོག་ན་འཁུན་སྒྲ་འབྱིན། ");
INSERT INTO bod_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","གང་ཡིན་ཞེ་ན། རེ་བའི་ནང་དུ་ངེད་རྣམས་ཐར་བར་གྱུར། འོན་ཀྱང་མིག་གིས་གང་མཐོང་ཟིན་པ་དེར་རེ་བ་བྱེད་རྒྱུ་མེད་དེ། མིག་གིས་མཐོང་ཟིན་པ་ལ་སུས་རེ་སྒུག་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","འོན་ཏེ་གང་རེ་བ་བྱེད་པ་དེ་མི་མཐོང་ན། ངེད་རྣམས་ཀྱིས་བཟོད་པའི་སྒོ་ནས་རེ་སྒུག་བྱེད། ");
INSERT INTO bod_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","དེ་བཞིན་དུ་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ང་ཚོ་སྟོབས་མེད་པར་རོགས་པ་གནང༌། ངེད་རྣམས་ཀྱིས་སྨོན་ལམ་ཇི་ལྟར་འདེབས་དགོས་པ་མི་ཤེས་ཀྱང༌། དམ་པའི་ཐུགས་ཉིད་ཀྱིས་ཚིག་གིས་སྨྲ་བར་མི་ཐུབ་པའི་འཁུན་སྒྲས་ང་ཚོའི་དོན་ལ་ཞུ་ངོ་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ཡང་ངེད་རྣམས་ཀྱི་སེམས་ལ་གཟིགས་མཁན་གྱིས་དམ་པའི་ཐུགས་ཉིད་ཀྱི་དགོངས་པ་མཁྱེན། གང་ལགས་ཤེ་ན། དཀོན་མཆོག་གི་དགོངས་པ་ལྟར་དམ་པའི་ཐུགས་ཉིད་ཀྱིས་དད་ལྡན་པ་རྣམས་ཀྱི་དོན་ལ་ཞུ་ངོ་མཛད་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","དཀོན་མཆོག་གིས་དོན་ཐམས་ཅད་མཉམ་དུ་མཛད་དེ་ཁོང་ལ་བརྩེ་ཞིང་ཁོང་གི་དགོངས་པ་ལྟར་བོས་པ་རྣམས་ལ་ཕན་པའི་ཆེད་དུ་ཡིན་པ་ངེད་རྣམས་ཀྱིས་ཤེས། ");
INSERT INTO bod_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","གང་ཡིན་ཞེ་ན། ཁོང་གི་སྲས་ནི་སྤུན་ཟླ་མང་པོའི་ནང་ནས་སྔོན་སྐྱེས་སུ་འགྱུར་བའི་ཆེད་དུ་དཀོན་མཆོག་གིས་སྔར་བདམས་པ་རྣམས་ཁོང་གི་སྲས་དང་འདྲ་བར་འགྱུར་བའི་ཕྱིར་བསྐོས་པར་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ཡང་ཁོང་གིས་སྔར་བསྐོས་པ་རྣམས་བོས་པར་ཡང་མཛད། བོས་པ་རྣམས་རྣམ་པར་དག་པར་ཡང་མཛད། རྣམ་པར་དག་པར་གྱུར་བ་རྣམས་གཟི་བརྗིད་དང་ལྡན་པར་ཡང་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","འོ་ན་དོན་དེ་རྣམས་ཀྱི་སྐོར་ལ་ཅི་སྨྲ། གལ་སྲིད་དཀོན་མཆོག་གིས་ངེད་ཀྱི་ཕྱོགས་མཛད་ན་ངེད་རྣམས་ལ་སུས་རྒོལ་ཐུབ། ");
INSERT INTO bod_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","རང་གི་སྲས་ཀྱང་ཕངས་སེམས་མི་མཛད་པར་ངེད་ཐམས་ཅད་ཀྱི་དོན་དུ་གཏོད་པར་མཛད་མཁན་གྱིས་སྲས་དང་མཉམ་དུ་ཐུགས་རྗེའི་སྒོ་ནས་ངེད་རྣམས་ལ་དོན་ཐམས་ཅད་ཀྱང་མ་གནང་བ་དེ་ཅི་ལ་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","དཀོན་མཆོག་གིས་བདམས་པར་མཛད་པ་རྣམས་ལ་ཉེས་སྐྱོན་འཛུགས་མཁན་སུ་ཡིན། དཀོན་མཆོག་ནི་རྣམ་པར་དག་པར་མཛད་མཁན་ཡིན་པས། ");
INSERT INTO bod_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ཁྲིམས་གཅོད་གཏོང་མཁན་སུ་ཡིན་ནམ། མཱ་ཤི་ཀ་ཡེ་ཤུ་ཡིན་ནམ། མིན་ཏེ་ཁོང་ནི་གྲོངས་ཤིང༌། དེ་བས་ཀྱང་སྐུ་གསོན་པོར་བཞེངས་སུ་གྱུར་ནས་དཀོན་མཆོག་གི་ཕྱག་གཡས་སུ་བཞུགས་མཁན་དེ་ཡིན་པ་མ་ཟད། ཁོང་གིས་ངེད་རྣམས་ཀྱི་དོན་དུ་ཞུ་ངོ་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","མཱ་ཤི་ཀའི་བྱམས་པ་ལས་ངེད་རྣམས་སུས་ཕྲལ། སྡུག་བསྔལ་ལམ། དཀའ་ངལ་ལམ། མནར་གཅོད་དམ། མུ་གེའམ། གོས་མེད་པའམ། ཉེན་ཁའམ། རལ་གྲི་ལ་སོགས་པས་ངེད་རྣམས་ཁོང་གི་བྱམས་པ་ལས་ཕྲལ་ཐུབ་པ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","མདོ་ལས། ཁྱེད་ཀྱི་ཆེད་དུ་ང་ཚོ་ཉིན་ལྟར་གསོད། ། གཞན་གྱིས་ངེད་རྣམས་བཤས་རྒྱུའི་ལུག་བཞིན་རྩི། ། ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","གནས་ཚུལ་དེ་ལྟར་ཡིན་ཡང་ངེད་རྣམས་ལ་བྱམས་པར་མཛད་མཁན་བརྒྱུད་ནས་ང་ཚོ་རབ་ཏུ་རྒྱལ་ལོ། ");
INSERT INTO bod_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","གང་ལགས་ཟེར་ན། འཆི་ཚེའམ། ཕོ་ཉའམ། གདོན་འདྲེའམ། ད་ལྟའམ། མ་འོངས་པའི་གནས་ཚུལ་ལམ། མཐུ་ལྡན་པའམ། ");
INSERT INTO bod_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","མཐོ་གཏིང་ངམ། དཀོན་མཆོག་གིས་གང་བཀོད་པ་ཐམས་ཅད་ལས་གང་ཞིག་གིས་ཀྱང་མཱ་ཤི་ཀ་ཡེ་ཤུ་ངེད་རྣམས་ཀྱི་གཙོ་བོ་བརྒྱུད་ནས་མངོན་པའི་དཀོན་མཆོག་གི་བྱམས་པ་ལས་ང་ཚོ་ཕྲལ་མི་ཐུབ་པར་ངས་ཡིད་ཆེས་ངེས་པ་རྙེད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","མཱ་ཤི་ཀའི་ཐོག་ནས་རྫུན་གཏམ་མིན་ཏེ་བདེན་པ་ཤོད། དམ་པའི་ཐུགས་ཉིད་ཀྱི་ཐོག་ནས་ངའི་སེམས་ཀྱིས་བདེན་དཔང་བྱེད་དེ། ");
INSERT INTO bod_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ངའི་སེམས་ལ་སྡུག་བསྔལ་ཆེན་པོ་དང་མྱ་ངན་རྒྱུན་ཆད་མེད་པར་མྱོང༌། ");
INSERT INTO bod_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ངའི་མི་རིགས་དང་ཤ་རུས་གཅིག་པའི་སྤུན་གྱི་དོན་དུ་དཀོན་མཆོག་གི་ཆད་པ་རྟག་ཏུ་ཕོག་ཤིང༌། མཱ་ཤི་ཀ་དང་ཁ་བྲལ་བར་འགྱུར་བ་ལྟར་ཡིན་ཡང་ང་དེ་ལྟར་མོས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ཁོ་ཚོ་ཡི་སི་ར་ཨེལ་པ་ཡིན་ཞིང༌། དཀོན་མཆོག་གིས་ཁོ་རྣམས་སྲས་སུ་བསྒྱུར་བར་མཛད་ནས་ཁོ་ཚོར་གཟི་བརྗིད་དང༌། ཞལ་ཆད་རྣམས་དང༌། ཆོས་ཁྲིམས། མཆོད་ཁང་ཆེན་མོར་ཞབས་ཏོག་བྱེད་པ། ཞལ་གྱིས་བཞེས་པ་རྣམས་གནང་བས། ");
INSERT INTO bod_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ཁོ་རྣམས་ལ་ཨབ་ར་ཧམ་ལ་སོགས་པའི་མེས་པོ་རྣམས་ཡོད་ཅིང༌། ཁོ་ཚོའི་བུ་རྒྱུད་ལས་མཱ་ཤི་ཀ་བྱུང་སྟེ། ཁོང་ནི་བླ་ན་མེད་པ་དང༌། དུས་རྟག་ཏུ་བཀུར་སྟི་དང་ལྡན་པའི་དཀོན་མཆོག་ཡིན་ནོ། ། ཨ་མེན། ");
INSERT INTO bod_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","དཀོན་མཆོག་གིས་གང་ཞལ་གྱིས་བཞེས་པ་དེ་སྟོང་བར་མ་གྱུར། གང་ཡིན་ཞེ་ན། ཡི་སི་ར་ཨེལ་གྱི་བུ་རྒྱུད་ཐམས་ཅད་དཀོན་མཆོག་ལ་གཏོགས་པའི་མི་དངོས་མིན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་ཡིན་ཚད་སྲས་དང་སྲས་མོ་དངོས་མིན། དེ་ལས་ལྡོག་སྟེ་མདོ་ལས། ཨི་སཱག་བརྒྱུད་ནས་ཁྱོད་ཀྱི་བུ་རྒྱུད་རྩི་བར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","དེའི་དོན་ནི་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་ཐམས་ཅད་དཀོན་མཆོག་གི་སྲས་དང་སྲས་མོ་རྣམས་མིན་ཏེ། དཀོན་མཆོག་གི་ཞལ་ཆད་ཀྱི་བུ་རྒྱུད་ཚོ་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་དུ་རྩི། ");
INSERT INTO bod_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ཞལ་གྱིས་བཞེས་པའི་བཀའ་འདི་ལྟར་ཡིན། དུས་འདི་ཙམ་ལ་ང་ཡོང་ཞིང་ས་རཱ་ལ་བུ་ཞིག་སྐྱེ་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","དེ་མ་ཟད། རེ་པེ་ཀཱ་ཡི་མཚེ་མ་ལ་ཕ་གཅིག་རང་ཡོད་དེ་ང་ཚོའི་མེས་པོ་ཨི་སཱག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","མཚེ་མ་དེ་གཉིས་མ་སྐྱེས་པ་དང༌། བཟང་ངན་ཅིའང་མ་བྱས་པའི་གོང༌། མིའི་བྱ་བར་མ་བརྟེན་པར་དཀོན་མཆོག་གི་ཐུགས་དགོངས་བཞིན་འདམ་པར་མཛད་པ་སྒྲུབ་ཕྱིར། ");
INSERT INTO bod_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ཁོ་མོ་ལ། བུ་རྒན་པས་བུ་གཞོན་པར་གཡོག་བྱེད་པར་འགྱུར་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","དེ་ལྟར་གསུང་རབ་ཀྱི་མདོ་ལས་ངས་ཡ་ཀོབ་ལ་བྱམས་ཤིང་ཨེ་སའུ་ལ་སྡང་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","འོ་ན་ང་ཚོས་ཅི་ཟེར། དཀོན་མཆོག་དྲང་བདེན་མིན་པ་ལགས་སམ། དེ་མི་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","གང་ལགས་ཤེ་ན། ཁོང་གིས་ལུང་སྟོན་པ་མོ་ཤེ་ལ། ང་ཡིས་སུ་ལ་བྱམས་པར་སེམས་པ་དེ་ལ་བྱམས། ། ང་ནི་སུ་ལ་སྙིང་རྗེར་སེམས་པ་དེ་ལ་བརྩེ། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","དེའི་ཕྱིར་མིའི་བསམ་འདུན་ནམ་འབད་རྩོལ་མ་ཡིན་པར་བཀའ་དྲིན་ཅན་གྱི་དཀོན་མཆོག་ལ་རྟེན་ནོ། ");
INSERT INTO bod_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ཡང་གསུང་རབ་ལས་ཨེ་ཇེབ་ཡུལ་གྱི་རྒྱལ་པོ་ཕར་ཨོ་ལ། ཁྱོད་བརྒྱུད་ནས་ངའི་ནུས་མཐུ་སྟོན་ཞིང༌། ངའི་མིང་འཛམ་གླིང་ཀུན་ལ་སྒྲོག་པའི་དོན་འདི་རང་གི་ཕྱིར་ངས་ཁྱོད་བསྐོས་པ་ཡིན་ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","དེ་བས་ན་དཀོན་མཆོག་གི་དགོངས་པ་ལྟར་སུ་ལ་ཐུགས་རྗེ་གནང་ཞིང༌། སུ་ལ་སེམས་མཁྲེགས་པོར་འདོད་ཀྱང་དེ་ལ་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","དེའི་ཕྱིར་ཁྱེད་ཀྱིས་ང་ལ། ཁོང་གིས་ཅིའི་ཕྱིར་ངེད་རྣམས་ལ་ད་དུང་སྐྱོན་འདོགས་པར་མཛད། ཁོང་གི་དགོངས་པར་རྒོལ་ཐུབ་མཁན་སུ་ཡིན་ཞེས་ཟེར་བར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","འོན་ཀྱང་དཀོན་མཆོག་ལ་ཁ་ལན་སློག་མཁན་མི་ཁྱོད་སུ་ཡིན། གང་བཟོས་པ་དེས་བཟོ་མཁན་ལ། ཁྱེད་ཀྱིས་ཅིའི་ཕྱིར་ང་འདི་ལྟར་བཟོས་པ་ཡིན་ཞེས་ཟེར་རམ། ");
INSERT INTO bod_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","རྫ་མཁན་ལ་འཇིམ་པའི་གོང་པོ་གཅིག་ལས་སྣོད་ཆས་མཆོག་དམན་གཉིས་སུ་སྤྱོད་པ་བཟོ་བའི་དབང་ཆ་མེད་དམ། ");
INSERT INTO bod_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","དེ་ལྟར་དཀོན་མཆོག་ལ་ཐུགས་ཁྲོ་དང་ནུས་མཐུ་སྟོན་པར་མཛད་པའི་དབང་ཆ་ཡོད་ནའང༌། ཁོང་གི་ཐུགས་ཁྲོ་བབ་སའི་གཏོར་བཤིག་ཏུ་འགྲོ་བའི་མི་རྣམས་ལ་ཤིན་ཏུ་ཐུགས་བཟོད་པར་སྒོམ། ");
INSERT INTO bod_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","དེ་ནི་གཟི་བརྗིད་དང་ལྡན་པར་འགྱུར་བར་སྔར་གྲ་སྒྲིག་མཛད་དེ། ཁོང་གིས་ཐུགས་རྗེ་གནང་བ་རྣམས་ལ་བླ་ན་མེད་པའི་གཟི་བརྗིད་སྟོན་པར་མཛད་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ཡང་ཁོང་གིས་ཡ་ཧུ་དཱ་པ་མ་ཟད་ཡ་ཧུ་དཱ་པ་མིན་པ་ལས་ཀྱང་བདམས་པར་མཛད་པ་རྣམས་ནི་ང་ཚོ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ཁོང་གིས་ལུང་སྟོན་པ་ཧོ་ཤེ་ཨ་བརྒྱུད་ནས། ང་ཡི་མ་ཡིན་མི་རྣམས་ལ། ། ང་ཡི་མི་རྣམས་ཞེས་སུ་འབོད། ། ཐུགས་བརྩེའི་ཡུལ་མིན་མི་རྣམས་ལ། ། ང་ཡི་ཐུགས་བརྩེའི་མི་ཞེས་འབོད། ། ");
INSERT INTO bod_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ཡང༌། ཁྱོད་ནི་ང་ཡི་མི་མ་ཡིན་ཞེས་བརྗོད་པའི་སར། ། གཏན་དུ་གནས་པའི་དཀོན་མཆོག་སྲས་རྣམས་ཞེས་སུ་འབོད། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ཡང་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་ཡི་སི་ར་ཨེལ་གྱི་སྐོར་ལ་འདི་ལྟར་བོས། ཡི་སི་ར་ཨེལ་ཡུལ་གྱི་བུ་རྒྱུད་རྣམས། ། མཚོ་འགྲམ་བྱེ་མ་བཞིན་དུ་མང་ན་ཡང༌། ། ཐར་བར་མཛད་པ་ཉུང་ཤས་ཙམ་ཞིག་གོ ། ");
INSERT INTO bod_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","འཇིག་རྟེན་འདི་ལ་གཙོ་བོ་དཀོན་མཆོག་གིས། ། ཁྲིམས་གཅོད་མ་འགྱངས་ཡོངས་སུ་མཛད་ཕྱིར་ཡིན། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ཡང་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་ལུང་བསྟན་པ་ལྟར། ནུས་མཐུ་ཀུན་དང་ལྡན་པའི་དཀོན་མཆོག་གིས། ། ང་ཚོའི་བུ་རྒྱུད་འཇོག་པར་མ་མཛད་ན། ། སཱ་དོམ་དང་ནི་གྷོ་མོ་ར་བཞིན་གྱུར། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","འོ་ན་ང་ཚོས་ཅི་ཟེར། ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་རྣམ་པར་དག་པར་འབད་བརྩོན་མ་བྱས་ཀྱང༌། དད་པ་ལས་འབྱུང་བའི་རྣམ་པར་དག་པ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","འོན་ཀྱང་ཡི་སི་ར་ཨེལ་གྱིས་ཆོས་ཁྲིམས་སྒྲུབ་པ་ལས་འབྱུང་བའི་དྲང་བདེན་ཉིད་ལ་འབད་བརྩོན་བྱས་ཀྱང་ཆོས་ཁྲིམས་དེ་མ་བསྒྲུབས། ");
INSERT INTO bod_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","དེ་ཅིའི་ཕྱིར་ཞེ་ན། ཁོ་ཚོས་དད་པ་ལ་མ་བརྟེན་ཏེ་དགེ་བའི་ལས་ལ་བརྟེན་པའི་ཚུལ་དུ་དེ་ལ་འབད་བརྩོན་བྱས་པའི་ཕྱིར་རོ། ཁོ་ཚོའི་ཕྱིར་ཆོས་ཁྲིམས་དེ་ནི་འགག་རྡོ་ལྟ་བུར་གྱུར་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","མདོ་ལས་བཀོད་པ་ལྟར་ན། ལྟོས་ཤིག་ང་ཡིས་ཙི་ཡོན་ཡུལ་ལ་ནི། ། རྐང་པ་ཐོགས་ཤིང་འགྱེལ་བར་བྱེད་པ་ཡི། ། རྡོ་ཞིག་བཞག་པས་མི་ནི་སུ་ཞིག་གིས། ། ཁོང་ལ་དད་ན་སྐྱེངས་པར་མི་འགྱུར་རོ། ། ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","སྤུན་ཟླ་རྣམས། ཡ་ཧུ་དཱ་པ་རྣམས་ཐར་བར་འགྱུར་བའི་ཆེད་དུ་ངས་སེམས་གཏིང་ནས་དཀོན་མཆོག་ལ་སྨོན་ལམ་འདེབས། ");
INSERT INTO bod_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ཁོ་ཚོར་དཀོན་མཆོག་གི་དོན་ལ་བརྩོན་སེམས་ཡོད་པ་ངས་བདེན་དཔང་བྱེད། འོན་ཀྱང་དེ་ནི་རྟོགས་པ་ལ་མི་བརྟེན། ");
INSERT INTO bod_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","དཀོན་མཆོག་ལས་འབྱུང་བའི་རྣམ་པར་དག་པར་མཛད་ཐབས་མ་རྟོགས་པས། ཁོ་ཚོས་ཆོས་ཁྲིམས་སྲུང་བའི་སྒོ་ནས་དྲང་བདེན་དུ་འགྱུར་བར་བརྩོན་ནས་དཀོན་མཆོག་གི་དྲང་བདེན་གྱི་ཐབས་ལམ་དང་ལེན་མ་བྱས། ");
INSERT INTO bod_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","དད་པ་བྱེད་མཁན་ཐམས་ཅད་དཀོན་མཆོག་དང་འབྲེལ་བ་ཡང་དག་པ་འཐོབ་པའི་ཕྱིར་མཱ་ཤི་ཀ་ནི་ཆོས་ཁྲིམས་ཀྱི་དོན་སྒྲུབ་པར་མཛད་དོ། ། ");
INSERT INTO bod_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ཆོས་ཁྲིམས་ཀྱི་བཀའ་སྒྲུབ་པར་བརྟེན་པའི་དྲང་བདེན་ཉིད་ཀྱི་སྐོར་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས། ཆོས་ཁྲིམས་ཀྱི་བཀའ་སྒྲུབ་མཁན་དེ་གསོན་པར་འགྱུར་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","འོན་ཀྱང་དཀོན་མཆོག་དང་འབྲེལ་བ་ཡང་དག་པ་འཐོབ་པའི་ལམ་དད་པར་བརྟེན་པ་དེས་དཀོན་མཆོག་གི་ཞིང་ཁམས་ལ་སུ་འགྲོ་བར་བྱ། (དེ་ནི་མཱ་ཤི་ཀ་མར་འཁྲིད་པའི་ཕྱིར་ཡིན་) ");
INSERT INTO bod_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ཡང་ན། གཤིན་པོའི་ཡུལ་ལ་སུ་འགྲོ་བར་བྱ། (དེ་ནི་མཱ་ཤི་ཀ་ཡར་འཁྲིད་པའི་ཕྱིར་ཡིན་) ཞེས་མ་སེམས་ཞིག་ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","དོན་དམ་དུ་དེས་འདི་ལྟར་གསུངས་ཏེ། བཀའ་དེ་ནི་ཁྱོད་དང་ཉེ་སྟེ། ཁྱོད་ཀྱི་ཁ་དང་སེམས་ལ་བཞུགས་སོ་ཞེས་གསུངས། བཀའ་དེ་ཅི་ཡིན་ཞེ་ན། ངེད་རྣམས་ཀྱིས་སྒྲོག་པའི་དད་པའི་བཀའ་ཡིན་ཏེ། ");
INSERT INTO bod_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","གལ་ཏེ་ཁྱེད་ཀྱིས་ཁ་ཡིས་ཡེ་ཤུ་གཙོ་བོ་ཡིན་པ་ཁས་ལེན་བྱས་ཤིང༌། སེམས་ཀྱིས་ཀྱང་དཀོན་མཆོག་གིས་ཁོང་འཆི་བ་ནས་སླར་གསོན་པར་མཛད་པ་དེ་ལ་དད་པ་བྱས་ན། ཁྱེད་ངེས་པར་ཐར་བར་འགྱུར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","གང་ལགས་ཟེར་ན། སེམས་ནས་དད་པ་བྱེད་པ་ལ་དཀོན་མཆོག་དང་ཡང་དག་པའི་འབྲེལ་བ་འཐོབ་ཅིང༌། ཁ་ནས་ཁས་ལེན་བྱེད་པ་ལ་ཐར་པ་འཐོབ། ");
INSERT INTO bod_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","གསུང་རབ་ཀྱི་མདོ་ལས་སུས་ཀྱང་ཁོང་ལ་དད་པ་བྱེད་པ་དེ་སྐྱེངས་པར་མི་འགྱུར་ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","གང་ཡིན་ཟེར་ན། དོན་འདིར་ཡ་ཧུ་དཱ་པ་དང་ཡ་ཧུ་དཱ་པ་མིན་པ་གཉིས་ཀྱི་བར་དུ་དབྱེ་བ་མེད་དེ། ཐམས་ཅད་ཀྱི་གཙོ་བོ་གཅིག་རང་ཡིན་ཞིང༌། ཁོང་གི་མཚན་བརྗོད་མཁན་ཐམས་ཅད་ལ་ལྷག་པར་བྱིན་གྱིས་རླབས། ");
INSERT INTO bod_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","གང་ཡིན་ཞེ་ན། གཙོ་བོའི་མཚན་བརྗོད་མཁན་ཐམས་ཅད་ཐར་བར་འགྱུར་ངེས་ཡིན་ཞེས་བྲིས་པའི་ཕྱིར་རོ། ");
INSERT INTO bod_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","འོ་ན། ཁོང་ལ་དད་པ་མ་བྱས་ན་ཇི་ལྟར་བརྗོད། ཡང་ཅི་ཡང་མ་ཐོས་ན་ཇི་ལྟར་དད། སྒྲོག་མཁན་མེད་ན་ཁོ་ཚོས་ཇི་ལྟར་ཐོས། ");
INSERT INTO bod_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","མ་མངགས་ན་ཇི་ལྟར་སྒྲོག མདོ་ལས་འདི་ལྟར་ཏེ། འཕྲིན་བཟང་སྒྲོག་མཁན་གྱི་ཞབས་ནི་ཇི་ལྟ་བུ་མཛེས་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","འོན་ཀྱང་མི་མང་ཆེ་བས་འཕྲིན་བཟང་ལ་མ་ཉན་ཏེ། ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས། ཀྱེ་གཙོ་བོ་ལགས། ང་ཚོའི་འཕྲིན་ལ་སུས་ཡིད་ཆེས་བྱས་པ་ཡིན་ཞེས་བྲིས། ");
INSERT INTO bod_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","དེའི་ཕྱིར་དད་པ་ནི་གང་ཐོས་པ་ལས་འབྱུང་ཞིང༌། གང་ཐོས་པ་དེ་མཱ་ཤི་ཀའི་བཀའ་ལས་འབྱུང༌། ");
INSERT INTO bod_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ཡ་ཧུ་དཱ་པས་ཐོས་མ་མྱོང་ངམ། ཐོས་སོ། གང་ཡིན་ཞེ་ན། དེ་ཚོའི་གསུང་སྐད་ས་གཞི་ཡོངས་སུ་ཁྱབ། ། དེ་ཚོའི་བཀའ་ཚིག་འཛམ་གླིང་ཐ་གྲུར་ཁྱབ། ། ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ཡང་ཡི་སི་ར་ཨེལ་གྱིས་མ་རྟོགས་སམ་ཞེས་དྲིས་ན། དང་པོར་ལུང་སྟོན་པ་མོ་ཤེ་ཡིས་མདོ་ལས། ང་ཡིས་མི་རིགས་མ་ཡིན་པར་བརྟེན་ཁྱོད་ཚོར་ཕྲག་དོག་སློང༌། ། ང་ཡིས་རྨོངས་པའི་མི་རིགས་ལ་བརྟེན་ཁྱོད་ཚོར་ཁོང་ཁྲོ་སློང༌། ། ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ཡང་ལུང་སྟོན་པ་ཡེ་ཤ་ཡཱ་ཡིས་བློ་ཁོག་ཆེན་པོས། འཚོལ་མི་མ་ཡིན་པ་ལ་ང་རང་རྙེད། ། མཇལ་འདོད་མེད་པ་རྣམས་ལ་ང་ཡིས་མངོན། ། ཞེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","འོན་ཀྱང་ཡི་སི་ར་ཨེལ་གྱི་སྐོར་ལ་ཁོང་གིས། བཀའ་ལ་མི་ཉན་རྒོལ་བའི་མི་རྣམས་ལ། ། བསུ་ཕྱིར་ང་ཡིས་ཉིན་གང་ལག་གཉིས་བརྐྱངས། ། ཞེས་གསུངས་སོ། ། ");
INSERT INTO bod_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","འོ་ན་ངས་འདྲི་བར་བྱ་སྟེ། དཀོན་མཆོག་གིས་རང་ཉིད་ཀྱི་མི་རིགས་སྤངས་པར་མཛད་པ་ཡིན་ནམ། དེ་མི་སྲིད། གང་ལགས་ཤེ་ན། ང་རང་ནི་ཡི་སི་ར་ཨེལ་པ་སྟེ་མེས་པོ་ཨབ་ར་ཧམ་གྱི་བུ་རྒྱུད་དང༌། པེན་ཡ་མཱིན་ཚོ་ཁག་གི་མི་ཞིག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","དཀོན་མཆོག་གིས་སྔར་བདམས་ཏེ་རང་ཉིད་ཀྱི་མི་རིགས་སྤངས་པར་མ་མཛད། མདོ་ལས་ལུང་སྟོན་པ་ཨེ་ལི་ཡཱ་ཡིས་དཀོན་མཆོག་གི་མདུན་དུ་ཡི་སི་ར་ཨེལ་ལ་སྐྱོན་བརྗོད་པའི་སྒྲུང་དེ་མི་ཤེས་སམ། ");
INSERT INTO bod_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ཨེ་ལི་ཡཱ་ཡིས་གཙོ་བོ་དཀོན་མཆོག་ལགས། ཁོ་ཚོས་ཁྱེད་ཀྱི་ལུང་སྟོན་པ་རྣམས་བསད། མཆོད་ཁྲི་རྣམས་བཤིག ང་གཅིག་པུར་ལུས་པ་དང་ཁོ་ཚོས་ང་ཡང་གསོད་ཐབས་འཚོལ་ཞེས་བཤད། ");
INSERT INTO bod_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","འོན་ཀྱང་དཀོན་མཆོག་གིས་དེའི་ལན་དུ་གང་གསུངས་ཞེ་ན། ངས་ངའི་དོན་དུ་ལྷ་སྦ་ཨལ་ལ་ཕྱག་མ་འཚལ་མཁན་བདུན་སྟོང་ཉར་ཡོད་ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","དེ་ལྟར་ད་ལྟའང་དཀོན་མཆོག་གི་ཐུགས་རྗེ་ཡིས་བདམས་པའི་ལྷག་མ་ཞིག་ཡོད། ");
INSERT INTO bod_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","དེ་ནི་ཐུགས་རྗེ་ལ་བརྟེན་ན་བྱ་བ་བཟང་པོ་ལ་མི་རྟེན། དེ་ལྟར་མ་ཡིན་ན། ཐུགས་རྗེ་དེ་ཐུགས་རྗེ་དངོས་གནས་མིན། ");
INSERT INTO bod_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","མདོར་བསྡུས་ན་ཡི་སི་ར་ཨེལ་གྱིས་འབད་པས་གང་བཙལ་བ་དེ་མ་ཐོབ། འོན་ཀྱང་བདམས་པའི་མི་རྣམས་ལ་ཐོབ་སྟེ། ལྷག་མ་རྣམས་ཀྱི་སེམས་མཁྲེགས་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","དེ་ལྟར་གསུང་རབ་ཀྱི་མདོ་ལས། དཀོན་མཆོག་ཉིད་ཀྱིས་ཁོ་ཚོ་ལ། ། གོ་ཚོར་མེད་པའི་སེམས་པ་དང༌། ། མ་མཐོང་བ་ཡི་མིག་ཟུང་དང༌། ། ཉན་ཤེས་ཉམས་པའི་རྣ་ཅོག་བཅས། ། གནང་སྟེ་དེ་རིང་བར་དུ་གནས། ། ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ཡང་རྒྱལ་པོ་དཱ་བིད་ཀྱིས། ཁོ་ཚོའི་གསོལ་སྟོན་རྒྱ་རྙི་དོང་རྙི་དང༌། ། འགག་རྡོ་འཁོན་ལན་ཉིད་དུ་གྱུར་བར་ཤོག ། ");
INSERT INTO bod_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ཁོ་ཚོས་མ་མཐོང་ཆེད་དུ་མིག་གཉིས་པོ། ། སྒྲིབ་ཅིང་རྐེད་པ་ནམ་ཡང་གུག་གྱུར་ཅིག ། ཅེས་གསུངས། ");
INSERT INTO bod_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ཡ་ཧུ་དཱ་པ་རྣམས་ས་སྟེང་དུ་འགྱེལ་བ་དེ་ནམ་ཡང་ལངས་རྒྱུ་མེད་དམ། དེ་མི་སྲིད། ཡ་ཧུ་དཱ་པ་རྣམས་ཀྱིས་དཀོན་མཆོག་གིས་གནང་བའི་ཐར་ལམ་དང་ལེན་མ་བྱས་པས་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་ཐར་པ་ཐོབ། དེ་ནི་ཡ་ཧུ་དཱ་པ་རྣམས་ཐར་པ་འདོད་དུ་འཇུག་པའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","འོ་ན། ཡ་ཧུ་དཱ་པས་དཀོན་མཆོག་གི་ཐར་ལམ་དང་ལེན་མ་བྱས་པ་དང་ཁོ་ཚོ་ཕམ་པ་དེས་འཇིག་རྟེན་དང་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་བྱིན་རླབས་ཐོབ། མ་འོངས་པར་ཁོ་ཚོ་དཀོན་མཆོག་གི་ཐར་པར་ཚུད་པའི་ཚད་ལོན་ན་དེ་ཅི་ལས་ཀྱང་ལྷག་པའི་བྱིན་རླབས་ཐོབ་རྒྱུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ད་ངས་ཁྱེད་ཚོ་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་སྨྲ་བར་བྱ་སྟེ། ང་ནི་ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་ལ་མངགས་པའི་སྐུ་ཚབ་ཡིན་པས་ངའི་ཞབས་ཕྱི་བྱེད་པར་མཐོང་ཆེན་པོ་བྱེད་བཞིན་ཡོད། ");
INSERT INTO bod_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","དེ་ནི་ཐབས་གང་གིས་ངའི་མི་རིགས་ཐར་པ་འདོད་དུ་འཇུག་ནས་མ་མཐར་ཡང་ཁོ་རྣམས་ལས་ཁ་གཅིག་ཐར་བར་འགྱུར་བའི་ཆེད་དུ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","དཀོན་མཆོག་གིས་ཁོ་ཚོ་སྤོང་བ་ནི་འཇིག་རྟེན་པ་རྣམས་དང་འདུམ་པའི་དོན་ཡིན་ན། ཁོ་ཚོའི་དང་ལེན་མཛད་པ་ནི་དེ་བས་ཀྱང་འཆི་བ་ནས་སླར་གསོན་པའི་དོན་མ་ཡིན་ནམ། ");
INSERT INTO bod_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","བག་ཟན་གྱི་ཕུད་དེ་ལྷད་མེད་པ་ཡིན་ན། ཆ་ཚང་ལྷད་མེད་པ་ཡིན། ལྗོན་ཤིང་གི་རྩ་བ་ལྷད་མེད་པ་ཡིན་ན་དེའི་ཡལ་གའང་ལྷད་མེད་པ་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","དཀོན་མཆོག་གིས་ལྗོན་ཤིང་གི་ཡལ་ག་དེ་བཅད་ནས་ཁྱེད་ཚོ་ནགས་ཚལ་གྱི་སྐྱུར་རུ་ཤིང་གི་ཡལ་ག་ལྗོན་ཤིང་དང་སྦྱོར་འདེབས་བྱས་ཏེ་ཤིང་བཟང་པོའི་རྩ་བའི་བཅུད་དང་ལྡན་པར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","དེའི་ཕྱིར་ཡལ་ག་གཞན་རྣམས་ཀྱི་དྲུང་དུ་རང་བསྟོད་མ་བྱོས་ཤིག གལ་ཏེ་དེ་ལྟར་བྱས་ན། རྩ་བ་ཁྱོད་ལ་བརྟེན་པ་མ་ཡིན་ཏེ། ཁྱོད་རྩ་བ་ལ་བརྟེན་པ་དྲན་པར་གྱིས་ཤིག ");
INSERT INTO bod_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ཁྱོད་ཀྱིས་ང་ལྗོན་ཤིང་ལ་སྦྱོར་འདེབས་པའི་ཆེད་དུ་ཡལ་ག་གཞན་རྣམས་བཅད་པ་ཡིན་ཞེས་ཟེར་ཡོང༌། ");
INSERT INTO bod_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","དེ་བདེན་པ་ཡིན། འོན་ཀྱང་ཁོ་ཚོ་དད་པ་མ་བྱས་པའི་རྐྱེན་གྱིས་བཅད་པ་ཡིན་ཞིང༌། ཁྱོད་ནི་དད་པ་བྱེད་པའི་རྐྱེན་གྱིས་གནས་སོ། དེའི་ཕྱིར་ང་རྒྱལ་མི་བྱེད་དེ་ཞེད་སྣང་བྱེད་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","གང་ཡིན་ཞེ་ན། དཀོན་མཆོག་གིས་རང་བྱུང་གི་ཡལ་ག་བཅད་པར་མཛད་ན། ཁྱོད་ཀྱང་གཅོད་པར་འགྱུར་སྲིད། ");
INSERT INTO bod_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","དཀོན་མཆོག་གི་བཀའ་དྲིན་དང་ནན་པོ་གཉིས་ལ་ལྟོས་ཤིག བཀའ་ལ་མ་ཉན་པ་རྣམས་ལ་ནན་པོ་མཛད། ཁོང་གི་བཀའ་དྲིན་ལ་མུ་མཐུད་ནས་བརྟེན་ན་ཁྱོད་རྣམས་ལ་བཀའ་དྲིན་མཛད། འོན་ཀྱང་དེ་ལྟར་མ་བྱས་ན། ཁྱོད་ཚོའང་གཅོད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ཡི་སི་ར་ཨེལ་པ་དེ་དག་ཀྱང་དད་པ་མེད་པའི་གནས་ལ་མི་གནས་ན་ལྗོན་ཤིང་ལ་སྦྱོར་འདེབས་གནང་བར་འགྱུར། གང་ལགས་ཤེ་ན། དཀོན་མཆོག་གིས་ཁོ་རྣམས་སྦྱོར་འདེབས་མཛད་ཐུབ་པས་སོ། ");
INSERT INTO bod_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ཁྱོད་རྣམས་ནགས་ཚལ་གྱི་སྐྱུར་རུ་ཤིང་ལས་བཅད་ནས། རང་བྱུང་ཁམས་དང་མི་མཐུན་པར་སྐྱུར་རུ་ཤིང་བཟང་པོ་ལ་སྦྱོར་འདེབས་བྱས་པ་ཡིན་ན། རང་བཞིན་གྱི་ཡལ་ག་ནི་རང་གི་སྐྱུར་རུ་ཤིང་ལ་དེ་ལས་ལྷག་པར་སྦྱོར་འདེབས་བྱེད་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","སྤུན་ཟླ་རྣམས། ཁྱེད་ཚོས་རང་མཁས་པར་མི་རྩི་བའི་ཕྱིར་དཀོན་མཆོག་གིས་སྔར་མངོན་པར་མ་མཛད་པའི་བདེན་པ་འདི་ཤེས་པར་གྱིས་ཤིག ཡ་ཧུ་དཱ་པ་མིན་པ་རྣམས་དཀོན་མཆོག་གི་ཐར་པར་ཚུད་པའི་ཚད་མ་ལོན་པའི་བར་དུ་ཡི་སི་ར་ཨེལ་གྱི་ཆ་ཤས་ཞིག་སེམས་མཁྲེགས་པོར་གྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","དེ་ལྟར་ཡི་སི་ར་ཨེལ་ཆ་ཚང་ཐར་བར་འགྱུར། གསུང་རབ་ཀྱི་མདོར། ཙི་ཡོན་ཡུལ་ནས་སྐྱབས་མགོན་ཞིག ། ཕེབས་ཏེ་ཡི་སི་ར་ཨེལ་གྱི། ། དད་མེད་སེམས་དེ་བསྒྱུར་བར་མཛད། ། ");
INSERT INTO bod_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ང་ཡིས་ཁོ་ཚོར་བཞག་པའི་དམ་བཅའ་ནི། ། ཁོ་ཚོའི་སྡིག་ཉེས་སེལ་བ་དེ་ཡིན་ནོ། ། ཞེས་འཁོད། ");
INSERT INTO bod_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","འཕྲིན་བཟང་གི་ཆ་ནས་ཁོ་ཚོ་ཁྱེད་རྣམས་ཀྱི་ཕྱིར་དཀོན་མཆོག་གི་དགྲ་བོར་རྩི། འོན་ཀྱང་མེས་པོ་རྣམས་ལ་གནང་བའི་ཞལ་ཆད་སྒྲུབ་པའི་ཕྱིར་དཀོན་མཆོག་གིས་བདམས་པར་མཛད་པའི་ཆ་ནས་ཁོ་རྣམས་གཅེས་པར་རྩི། ");
INSERT INTO bod_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","གང་ཡིན་ཞེ་ན། དཀོན་མཆོག་གི་གནང་སྦྱིན་དང་འབོད་གནང་བ་དེ་འགྱུར་མི་སྲིད་དོ། ");
INSERT INTO bod_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","སྔར་ཡ་ཧུ་དཱ་པ་མིན་པ་ཁྱེད་ཚོས་དཀོན་མཆོག་གི་བཀའ་ལ་མ་ཉན་ཀྱང༌། ཡ་ཧུ་དཱ་པས་བཀའ་ལ་མ་ཉན་པའི་རྐྱེན་གྱིས་ད་ལྟ་ཁྱེད་རྣམས་ལ་ཐུགས་རྗེ་ཐོབ། ");
INSERT INTO bod_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","དེ་ལྟར་ཡ་ཧུ་དཱ་པ་ཚོས་ད་ལྟ་བཀའ་ལ་མི་ཉན་ཀྱང༌། ཁྱེད་ལ་གནང་བའི་ཐུགས་རྗེའི་རྐྱེན་གྱིས་ཁོ་ཚོ་ལ་ཡང་ད་ལྟ་ཐུགས་རྗེ་འཐོབ་པར་འགྱུར། ");
INSERT INTO bod_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","གང་ཡིན་ཟེར་ན། མི་ཐམས་ཅད་ལ་ཐུགས་རྗེ་གཟིགས་པའི་ཆེད་དུ་དཀོན་མཆོག་གིས་ཁོ་ཚོ་ཚང་མ་བཀའ་ལ་མ་ཉན་པའི་ཁོངས་སུ་མཛད། ");
INSERT INTO bod_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ཨེ་མ། དཀོན་མཆོག་གི་ནི་ཤེས་རབ་དང༌། ། མཁྱེན་རྒྱ་ཟབ་ཅིང་ཡངས་པ་ལ། ། ཁོང་གི་རྟོག་དཔྱོད་དཔོག་པར་དཀའ། ། ཁོང་གི་ཐབས་ལམ་རྟོགས་མི་ནུས། ། ");
INSERT INTO bod_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","སུ་ཡིས་ཁོང་གི་དགོངས་པ་ཤེས། ། ཁོང་གི་གྲོས་འདེབས་མཁན་དེ་སུ། ། ");
INSERT INTO bod_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","སུ་ཡིས་ཁོང་ལ་ཅི་ཕུལ་ནས། ། ཁོང་གིས་དེའི་ལན་འཇལ་དགོས་སམ། ། ");
INSERT INTO bod_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ཐམས་ཅད་ཁོང་ལས་འབྱུང་བ་དང༌། ། ཁོང་ལ་བརྟེན་ཅིང་ཁོང་གི་ཕྱིར། ། སྙན་དང་གྲགས་པའི་གཟི་བརྗིད་དག ། ཁོང་ལ་ནམ་ཡང་ཐོབ་པར་ཤོག ། ཨ་མེན། ། ");
INSERT INTO bod_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","དེའི་ཕྱིར་སྤུན་ཟླ་རྣམས། དཀོན་མཆོག་གིས་ཁྱེད་ཚོར་ཐུགས་རྗེ་གནང་བས་ཁྱེད་ཀྱི་ལུས་ནི་གསོན་པོ་དང་དམ་པ། དཀོན་མཆོག་ཐུགས་མཉེས་པའི་མཆོད་པ་ལྟར་འབུལ་བར་སྐུལ། དེ་ནི་ཁྱེད་ཚོའི་བདེན་པའི་བསྙེན་བཀུར་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","འཇིག་རྟེན་འདིའི་བྱེད་ལུགས་ལ་མ་བལྟས་པར་དཀོན་མཆོག་གི་དགོངས་པ་བཟང་པོ་དང༌། ཁོང་ཐུགས་མཉེས་པ་དང༌། ཕུན་སུམ་ཚོགས་པ་གང་ཡིན་ཤེས་པའི་ཕྱིར་ཁྱེད་ཀྱི་སེམས་གསར་དུ་སྒྱུར་བའི་ཐོག་ནས་མི་གསར་པར་གྱུར་ཅིག ");
INSERT INTO bod_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ང་ལ་གནང་བའི་ཐུགས་རྗེའི་སྒོ་ནས་ངས་ཁྱེད་ཚོ་རེ་རེར་རང་མཐོང་ཆེན་པོ་མི་བྱེད་པར་དཀོན་མཆོག་གིས་ཁྱེད་ལ་གནང་བའི་དད་པའི་ཚད་དང་བསྟུན་ཏེ། རང་ཉིད་ལ་གདེང་འཇོག་འཚམ་པོར་བྱས་ནས་སོམས་ཞེས་བསྒོའོ། ");
INSERT INTO bod_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ལུས་གཅིག་ལ་ཡན་ལག་མང་པོ་ཡོད་ཅིང༌། ཡན་ལག་རེ་རེར་ནུས་པ་མི་གཅིག་པ་ཡོད་པ་བཞིན། ");
INSERT INTO bod_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","དེ་ལྟར་ངེད་རྣམས་མི་མང་པོ་ཡོད་ཀྱང་མཱ་ཤི་ཀའི་ནང་དུ་ལུས་གཅིག་ཏུ་གྱུར་ཞིང༌། སོ་སོ་ཕན་ཚུན་གྱི་ཡན་ལག་ཡིན། ");
INSERT INTO bod_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ངེད་རྣམས་ལ་གནང་བའི་ཐུགས་རྗེ་དང་བསྟུན་ཏེ་ང་ཚོ་རེ་རེར་གནང་སྦྱིན་མི་འདྲ་བ་ཡོད། གལ་སྲིད་མི་ཞིག་གི་གནང་སྦྱིན་དཀོན་མཆོག་གི་བཀའ་གསུང་པ་ཡིན་ན། དད་པའི་ཚད་བཞིན་དུ་དེ་སྒྲོགས་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ཞབས་ཏོག་པ་ཡིན་ན་ཞབས་ཏོག་སྒྲུབ་དགོས་པ་དང༌། སློབ་མཁན་ཡིན་ན་སློབ་སྟོན་བྱེད་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","སྐུལ་འདེད་མཁན་ཡིན་ན་སྐུལ་བར་བྱེད་དགོས། སྦྱིན་པ་གཏོང་མཁན་ཡིན་ན་གཏོང་ཕོད་ཆེ་བའི་ངང་ནས་གཏོང་དགོས། འགོ་ཁྲིད་ཡིན་ན་འབད་བརྩོན་བྱེད་དགོས། གཞན་ལ་སྙིང་རྗེ་བྱེད་མཁན་ཡིན་ན་དགའ་བའི་ངང་ནས་དེ་ལྟར་བྱེད་དགོས། ");
INSERT INTO bod_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","བྱམས་པ་ནི་བཅོས་མིན་ཞིག་དགོས། ངན་པར་སྡང་ཞིང་བཟང་པོ་ཟུངས་ཤིག ");
INSERT INTO bod_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","སྤུན་ལྟར་ཕན་ཚུན་ལ་སྙིང་ནས་བྱམས་པ་བྱོས། གཅིག་གིས་གཅིག་ལ་བརྩོན་སེམས་ཀྱིས་བཀུར་སྟི་བྱོས་ཤིག ");
INSERT INTO bod_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","བརྩོན་འགྲུས་ཉམས་སུ་མ་འཇུག བརྩོན་སེམས་དང་ལྡན་པ་གྱིས་ཤིག གཙོ་བོ་ལ་ཞབས་ཕྱི་བྱོས། ");
INSERT INTO bod_vpl VALUES ("RM1