﻿USE sofia;
DROP TABLE IF EXISTS sofia.boaNT_vpl;
CREATE TABLE boaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES boaNT_vpl WRITE;
INSERT INTO boaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dabíii, Aavaráaa, íjcyámútsiúvúj tsɨɨménémúhaabéhjáa Jetsocríjtó íjcyáábé ɨhdé múnáaúvú ílluúme: ");
INSERT INTO boaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Diibyéhjáa Aavaráá tsɨ́ɨ́mavá Itsáake. Aabéhjáa Itsáá tsɨ́ɨ́mavá Jacóóboke. Aabéhjáa Jacóóbó tsɨ́ɨ́mavá Jodáake tsíjtyehjɨ íñahbémuma. ");
INSERT INTO boaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Aabéhjáa Jodáá tsɨ́ɨ́mavá Tamáadívú Pááreé, Tsááraá, íjcyámútsikye. Aabéhjáa Pááre tsɨ́ɨ́mavá Ejróoke. Aabéhjáa Ejróó tsɨ́ɨ́mavá Aráake. ");
INSERT INTO boaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aabéhjáa Aráá tsɨ́ɨ́mavá Aminadáake. Aabéhjáa Aminadáá tsɨ́ɨ́mavá Naatsóoke. Aabéhjáa Naatsóó tsɨ́ɨ́mavá Tsamóoke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Aabéhjáa Tsamóó tsɨ́ɨ́mavá Bóóke Raáadívu. Aabéhjáa Bóo tsɨ́ɨ́mavá Obéeke Róótídivu. Aabéhjáa Obéé tsɨ́ɨ́mavá Itsaíikye. ");
INSERT INTO boaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aabéhjáa Itsaíí tsɨ́ɨ́mavá ávyéjuube Dabíikye. Aabéhjáa Dabíí tsɨ́ɨ́mavá Tsaromóoke Oríá táábadívu. ");
INSERT INTO boaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Aabéhjáa Tsaromóó tsɨ́ɨ́mavá Roboáake. Aabéhjáa Roboáá tsɨ́ɨ́mavá Abíake. Aabéhjáa Abíá tsɨ́ɨ́mavá Áátsákeé. ");
INSERT INTO boaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aabéhjáa Áátsa tsɨ́ɨ́mavá Jotsapáake. Aabéhjáa Jotsapáá tsɨ́ɨ́mavá Joráake. Aabéhjáa Joráá tsɨ́ɨ́mavá Otsíake. ");
INSERT INTO boaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aabéhjáa Otsíá tsɨ́ɨ́mavá Joatáake. Aabéhjáa Joatáá tsɨ́ɨ́mavá Acáake. Aabéhjáa Acáá tsɨ́ɨ́mavá Etsekíake. ");
INSERT INTO boaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aabéhjáa Etsekíá tsɨ́ɨ́mavá Manatséeke. Aabéhjáa Manatséé tsɨ́ɨ́mavá Amóoke. Aabéhjáa Amóó tsɨ́ɨ́mavá Jotsíake. ");
INSERT INTO boaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Aabéhjáa Jotsíá tsɨ́ɨ́mavá Jeconíake tsíjtyehjɨ íñahbémuma. Téijyúhjáa Babiróónía múnáá hójtsɨri méɨhdéejte ijraéému. ");
INSERT INTO boaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aaméhjáa diityé hójtsɨ́ pañétú íjchívyéné boone Jeconíá tsɨ́ɨ́mavá Tsaratiéeke. Aabéhjáa Tsaratiéé tsɨ́ɨ́mavá Tsorobabéeke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aabéhjáa Tsorobabéé tsɨ́ɨ́mavá Abióoke. Aabéhjáa Abióó tsɨ́ɨ́mavá Eriakíikye. Aabéhjáa Eriakíí tsɨ́ɨ́mavá Atsóoke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aabéhjáa Atsóó tsɨ́ɨ́mavá Tsadóoke. Aabéhjáa Tsadóó tsɨ́ɨ́mavá Akíikye. Aabéhjáa Akíí tsɨ́ɨ́mavá Erióoke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aabéhjáa Erióó tsɨ́ɨ́mavá Ereatsáake. Aabéhjáa Ereatsáá tsɨ́ɨ́mavá Matáake. Aabéhjáa Matáá tsɨ́ɨ́mavá Jacóóboke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aabéhjáa Jacóóbó tsɨ́ɨ́mavá Jotséeke Maaríá tajɨ́ɨ íjcyáábeke. Aanéhjáa diille Maaríá tsɨ́ɨ́mavá Jetsóoke, ‘Pájtyetétsoóbe’ nééiyóné ‘Críjtoó’ némeííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Éhduméhjáa Jetsóó ɨhdé múnáaúvu. Diibyéhjáa muurá Aavaráaúvú tsɨ́ɨ́mavá tsáápiíkye. Aabéhjáa dsɨ́jɨ́vénetu dííbyé hajchíyéjuco cámaavéné éhnííñevu. Aabéhjáa idyé dsɨ́jɨ́vénetu dííbyé hajchíyéjuco cámaavéne. Ehdúhjáa icyóhbodu ‘camácámá’ llíyaatéhijcyámé 14-ihjyúvá Dabíiúvuke ditye tsɨ́ɨ́mávanévújuco. Áábeúvudítyúhjáa idyé llíyaatéhijcyámé téhdunéré 14-ijyúva. Áijyúhjáa diityéké Babiróónía múnaa méénujcátsítyu ityáhjámeke tsajtyé íiiñújɨvu. Téijyútúhjáa idyé ditye llíyaatéhijcyáné téhdunéré 14-ijyúvá úújeténáa Críjtoréjuco tsɨ́ɨ́mávámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Íllúhjáa muurá teene Jetsocríjtoke tsáápille tsɨ́ɨ́maváne: Dííbyéj tsɨɨjúhjáa íjcyáille Maaríake Jotséé áábajáá ityáábávaki. Árónáacáhjáa dityétsíi úcújcatsítyúné ɨhdéré tsúúca Maaríá eevá Píívyééberéhjáa ihdyu Íapííchoj tééveri pícyoóne. ");
INSERT INTO boaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aabéhjáa diibye Jotséé ɨ́mɨáábé iíjcyánéllii tsá ímílléturó ehdu nééllema iíjcyane. Áánélliihyéhjáa ɨ́jtsámeííbyé ílluréjuco díílleke ɨɨ́hvéjtsóiyóné múha wáájácútúnáaáca. Aabéhjáa tsá ímílletú mɨ́amúnáake iwáájácutsóné muhdú dille íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ááneríhjyáa dibye ɨ́tsámeíhíjcyánáa níjkyéjɨ múnáajpi ityúwá pañe dííbyedívú bóhówááveebe nééhií: —Jótsej, Dabíiúvú tsɨɨménémúhaabe u íjcyaábej, tsá muhdú u ɨ́jtsámeíityú dítyáába íjcyáille Maaríadítyu. Tsá muurá dille éévane ímityúné íjcyatúne. Muurá ihdyu Píívyéébere Íapííchoj tééveri pícyoone éévalle. Ahdícyane ihdyu wa duucu dííllekej. ");
INSERT INTO boaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Muurá tsɨ́ɨ́máváille wájpiíkye. Áábe mémei Jetsóó dibye ihyájkímuke íimítyuháñetu pájtyetétsóíñélliíhye. Ehdúhjáa níjkyéjɨ múnáajpi néé Jotséeke ityúwá pañe. ");
INSERT INTO boaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Ahdújucóhjáa dibye ipyééne díílleke újcujéné ihjyávu. Áállekéhjáa tsá dibye dómájcotú dille tsɨ́ɨ́mávátúné hajchóta. Aanéhjáa tsúúca dille tsɨ́ɨ́máváábeke meménuube Jetsóodívu. Ehdúhjáa pajtyéné Píívyéébe íhjyú uubálle múnáájpij tééveri íllu néhdújuco: Wájpiikye úújétúné badsɨ́jcaja éévaáhi. Aane tsɨ́ɨ́máváille wájpiíkye. Áábe mémei Emanoée, ‘íjcyaabe Píívyéébe méémaá’ nééiyóne. Ehdúhjáa Píívyéébe íhjyú uubálle múnáájpij tééveri néhdújuco tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aanéhjáa Jodéá iiñújɨvu dííbyeke tsɨ́ɨ́mavámé Beréé coomívú Heróódé tééné iiñújɨ́ avyéjuube íjcyánáaáca. Áijyúhjáa nuhba tsáhícyánéjcutu tsaate mɨ́ɨ́cúrú waajácu múnaa tsááme wajtsɨ́ Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Aaméhjáa técoomí múnáake nééhií: —¿Kiá diibye éhneva jodíómú avyéjuube íjcyáííbyeke tsáápille tsɨ́ɨ́mávaábe? Muurá íñe nuhba tsáhícyánéjcuri muha meíjcyame máájtyumɨ́ tsúúca dibye íjcyane úúbálléné mɨɨcúrúwake. Áánéllii muha metsáá dííbyeke medúúruváváme. ");
INSERT INTO boaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aanéhjáa idyé téhdure Heróódé tsúúca waajácúhi. Aanéhjáa dííbyeke tsíwárejcáró pámeere teene Jerotsarée múnáamájuco. ");
INSERT INTO boaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Áánélliihyéhjáa pihjyúcuube pámeekéré llúúvájté avyéjujtémá taúhbájú uwáábojtéke. Áámekéhjáa dílloobe kiávú diibye Pájtyetétsoobe íjcyáííbyeke ditye tsɨ́ɨ́mávaíñé némeíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Áánélliihyéhjáa néémeé: —Beréevu Jodéá iiñújɨri íjcyácoomívu. Íllúhjáa muurá Píívyéébé ihjyú uubálle múnáajpi caatúnúhi: ");
INSERT INTO boaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jodéá iiñújɨri ɨ́htsútú coomíjɨ́ íjcyánetu tsá íatéréecóómí Beréé íjcyatúne. Muurá ámuha teene Berée múnaa tahñéjté meíjcyámedítyú tsaapi íjcyaá ámúhá avyéjuube ámúhakye téhméiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ehdúhjáa ditye úúbállénéllii Heróódé pɨ́uvá wáájácúratúné diitye mɨ́ɨ́cúrú waajácu múnáake. Áámekéhjáa dílloobe ímíñeúvú múijyútújucóhjáa ímichi mɨ́ɨ́cúruwa bóhówaavéne. ");
INSERT INTO boaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Átsihdyúhjáa teene Beréevu iwállóómeke neébe: —Cána mepééne ímíñeúvú méwaajácute diibye tsɨ́ɨ́méneke. Aane ámuha dííbyeke maájtyúmɨ́cooca oke méúúbálleco téhdure o dúúrúvaté dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ehdúhjáa ávyéjuube Heróódé diityémá íhjyúvátsihdyu idyé pehíjcyámé diibye mɨ́ɨ́cúrúwá tujkévetu. Aaméhjáa tsúúca tétsihvu úújeténáa díbyéwu ijcyátsíí hallúvú mɨ́ɨ́cúruwa táchúúreevéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ááneríhjyáa mítyane ímíjyuuvéme. ");
INSERT INTO boaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aaméhjáa tééjá pañévú úcaavémé úújeté tsɨɨju Maaríama íjcyáábéwúudívu. Áábéwúukéhjáa duurúvámé ɨmɨ́hmóúbánema. Átsihdyúhjáa bohbánúmé dííbyéwúuke óóroó, ijtsiéétsoo, mííraá, éhdunévu. ");
INSERT INTO boaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ááné boonéhjáa Píívyéébe diityéké ityúwá pañe néé Heróódé ijcyáhullétú ditye ióómíjyúcóótuki. Ahdújucóhjáa ditye óómiñe íiiñújɨvu tsiélletúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aaméhjáa tsúúca íiiñújɨvu óómíñe déjuvu idyé tsiiñe níjkyéjɨ múnáajpi Jotséedívú ityúwá pañe íbóhówáávéne néé dííbyeke: —Maájkyéne méumɨ́vá dítyáábá nííhyoma Ejíhtó iiñújɨvu. Aame ámuha méíjcyaá téhulle ámúhakye o nééné hajchóta. Muurá Heróódé néhcoó aadi tsɨ́ɨ́ménéwúuke ɨdsɨ́jɨ́vétsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ahdújucóhjáa ditye iájkyéne pééne tépejcójuco teene Ejíhtó iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Áhulléhjáa ícyahíjcyámé diibye Heróódé dsɨ́jɨ́vétúné hajchóta. Ehdúhjáa pajtyéné Píívyéébe íhjyú uubálle múnáájpij tééveri íllu néhdújuco: Ejíhtori íjcyáábeke ó pɨ́uvá Hájchíwúuke. ");
INSERT INTO boaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aanéhjáa Heróódé ávyétá ɨhnáhó cayóbáávaté diitye waajácu múnaa tsiélletúréjuco óómíñeri. Áánemáhjáa íjcyaabe lliihyánutsó wapímúj tsɨ́ɨ́medívú míñéécú pijcyábatu llííñevu íjcyáméhjɨdípɨ́vu, diityéhjáa waajácu múnaa míñéécú pijcyábájuco ípyée mɨ́ɨ́cúrúwake iájtyúmɨ́netu íjcyáne ééveri íjcyáméhjɨdívu. Teenéhjáa Berée múnááj tsɨ́ɨ́medívú lliihyánútsoobe técoomí úníuri íjcyáméj tsɨ́ɨ́memájuco. ");
INSERT INTO boaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ehdúhjáa pajtyéné Píívyéébé ihjyú uubálle múnáajpi Jeremíá íllu néhdújuco: ");
INSERT INTO boaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramáá ijcyátsihyi dsɨjɨ́vé maatyóbá mélleebóhi. Rakyéé muurá tahíjcyá íááchimúhá ijraéémuj tsɨ́ɨ́mé dsɨ́jɨ́véneri. Aalle tsá ímílletú díílleke mebóhɨjtsóne. ");
INSERT INTO boaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Aanéhjáa diibye Heróódé tsúúca dsɨ́jɨ́vénéllii níjkyéjɨ múnáajpi tsiiñe Ejíhtovu Jotséedívú ityúwá pañe ibóhówáávéne nééhií: —Maájkyéne wa meóómí ámuha ijraéémú iiñújɨvu. Tsúúca dsɨ́jɨvémé tsɨ́ɨ́ménéwúukée dsɨ́jɨ́vétsóllehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ahdújucóhjáa ditye óómiñe íiiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Árónáacáhjáa diibye Heróódé cápayóóvé íllíyéjuco Akyeráó teene Jodéá iiñújɨ́ avyéjuube íjcyane Jotséé iwáájácúne íllityé téhullévú ipyééíyóneri. Áánélliihyéhjáa Gariréá iiñújɨvúréi pééme Píívyéébe diityéké ityúwá pañe téhullévúi ditye pééityúné néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aaméhjáa úújeté Natsaréevu diibyéhjáa Jetsóó Natsarée múnáajpi íjcyaíñé tsúúcajátújuco Píívyéébé ihjyú uubálle múnaa néhijcyádújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Téijyúhjáa Jóáa tsojtsó múnáajpi úwáábohíjcyá mɨ́amúnáake Jodéá iiñújɨri ɨ́ɨ́néubárá píívyétútsihyi. ");
INSERT INTO boaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Íllúhjáa úwáábohíjcyaábe: —Méɨhvéjtsó ímítyú ámuha meícyahíjcyáne. Ááne ámúhá ɨ́jtsaméí mécápayóóvé ɨ́mɨánejcúvuréjuco. Muurá níjkyéjɨri íjcyaabe Píívyéébe íavyéjúejte meíjcya meke újcuíñé tsúúca méhdivu pɨɨhɨ́jucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diibyéhjáa Jóáádityu Píívyéébé ihjyú uubálle múnáajpi Itsaíá nééhií: Méllééboó ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyaabe keeváwu íllu úwaabóne: “Méímibáávyé ímítyú ámuha meícyahíjcyánetu tsaímíyéjuco ámuha meíjcyámeke Ávyéjuube iájtyumɨ́vaki.” ");
INSERT INTO boaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aanéhjáa diibye Jóáa camééllómú ɨhjɨ́netu méénúmeíñé wajyámúúnema íjcyáábéj pɨɨnétú ócájɨmɨ́ɨ́hé chiúcunúhi. Aabéhjáa tséréémuke dohíjcyáhi. Téhduréhjáa íímúhojpácyó ádohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Áábé uwáábóhjáa illéébúcunú tsáácunúhijcyámé pahúllevátú Jerotsarée múnaaa, pámeere teene Jodéá iiñújɨ múnaa, Joodááj pɨɨhɨ́rí íjcyáné iiñújɨ múnaa, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Áámedítyúhjáa muhdú iícyahíjcyanéhjɨ́ úúbállémeímyekéjuco dibye tsótsohíjcyáné teene Joodáatu. ");
INSERT INTO boaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Áijyúhjáa tétsihyi mítyame paritséó imyémé íjcyáha múnáama, tsadotséó imyémé íjcyáha múnaa íjcyame idyé imíllerá téhdure itsójtsótsámeíñé peecútére. Árómekéhjáa íllure tsɨjpájuúbe. Neebéhjápeé: —Ávyeta ámuha ííñimyémúeméjté meíjcyámeke ¿múha ámúhakye néé peecútéré ámuha teene meméénúneri mepájtyetéiyóné Píívyéébe meke méimítyuháñé hallútú ɨ́cúbáhraíñé méúmɨ́wari íjcyánetu? ");
INSERT INTO boaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ɨ́mɨááné ámuha metsójtsótsámeíñé meímílléhajchíí ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne ɨ́mɨáámeréjuco meíjcyá tééneréjuco ámúhadítyú ibóhówaúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tsá múu néétune: “Muha muurá Aavaráaúvúj tsɨɨménémúhaabe meíjcyámeke tsá ɨɨná múúhakye pajtyéityúne.” Tsá múu ehdu íhjyúvatúne. Muurá íñe néwayúúné íjcyárónetu Píívyéébe ípívyéjtsóiyá tsíjtyeke Aavaráaúvúj tsɨɨménémúháábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aabe muurá téhmehíjcyá ímítyúmeke iwáágóoíñé éhne múúne tsaapi ibájtsoháñetu ímiñe néévátuhéhjɨ́ iíllóne cóvajtsódu. ");
INSERT INTO boaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Muurá ihdyu ɨ́mɨááné ámúhakye ó tsótsohíjcyá nújpácyori ámúhá imítyú ámuha meɨ́hvéjtsómé ɨ́jtsaméí tsíhdyuréjuco cápáyóóvémeke. Áánetu ihdyu íjcyaabe táhboone úwáábóiibye ávyeta táehnííñevu ɨ́htsútuube íjcyáábeke íjtyúhápáájɨ́ubáré o tácórɨúcu dííbyedívú o pɨ́ɨ́hɨ́véítyúroóbe. Diibye ihdyu ɨ́mɨááné cáhcújtsómé pañévú pícyoó Píívyéébé Apíícho. Áánetu cáhcújtsótúmeke cúújúwá pañévú waagóóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aabe muurá mɨ́amúnáake iímíbájchómeke dówajcároó ímítyúmedítyu. Ááne tsaímíyé pícyóóiibye diitye ɨ́mɨáámeke. Áánetu ímítyúmeke waagóóiibye cúújúwá pañévú éhne múúne tríígotu íimíúhjɨ́ meújcúne íatéréene téjuuhójɨma mecóvajtsódu. Ehdúhjáa paritséómuke neebe Jóáaá. ");
INSERT INTO boaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Téijyúhjáa Gariréá iiñújɨtu Jetsóó péé Joodáavu Jóáa téhulle íjcyáábe éllevu dííbyedívú itsójtsótsámeíki. ");
INSERT INTO boaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Árónáacáhjáa Jóáa néé dííbyeke: —¿Aca muhdú cáábyerá uke ó tsójtsoó oke u tsójtsóíyóóbeke? ");
INSERT INTO boaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Árónáacáhjáa neebe dííbyeke: —Árónáa ihdyu ú méénuú tehdu Píívyéébé ímillédújuco. Ehdúhjáa dibye néénéllii Jóáa tsojtsó dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aabéhjáa itsójtsótsámeítsihdyu íjchívyeebe ɨ́ɨ́ténáa cáámetu Píívyéébé Apííchó ɨ́juuúdú bóhówaavéné niityé dííbyedívu. ");
INSERT INTO boaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Áánáacáhjáa idyé téhullétúré cáámetu Píívyéébe nééhií: —Áánu Hájchíwúuke o wájyúúbedi mítyane ó imíjyúúhií. ");
INSERT INTO boaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aanéhjáa Jetsóó tsójtsótsámeíñé boone Píívyéébé Apííchó dííbyeke tsajtyé ɨ́ɨ́néubá píívyétúné iiñújɨvu téhullévú Naavéné dííbyeke imáváríjchoki. ");
INSERT INTO boaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aabéhjáa téhulle 40 coojɨ́vájuco májchótuube íjcyaabe ajyábáávatéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Áábekéhjáa Naavéné imújtátsóro nééhií: —Bo ɨ́mɨááné Píívyéébé Hajchi u íjcyáhajchíí íu nééwáyutu pááaho dípívyéjtsóne majchoj. ");
INSERT INTO boaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Árónáacáhjáa neebe dííbyeke: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Tsá apááñéré májchó tájpí meíjcyatúne. Muurá téhdure Píívyéébe meke néhdu meíjcyame tééne tájpí méijcyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ehdúhjáa Jetsóó áñújcúnéllii tsajtyéébé dííbyeke Jerotsaréevúréjuco. Áábemáhjáa néríívyemútsí cáámevu duurúvájá hallúvu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Átsihvúhjáa idyé neebe dííbyeke: —Áyu cána ɨ́mɨááné Píívyéébé Hajchi u íjcyáhajchíí íchihdyu cátsiñíívyé baavújuco. Muurá dííbyé waajácúháámɨtu nééneé: Píívyéébe wálloó níjkyéjɨ múnáake uke ditye ityéhme ɨɨná uke ipájtyétuki. Aabe tsá ɨ́ɨ́néúbatú u wápújúúvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ehdúhjáa Naavéné néérónáa idyé Jetsóó néé dííbyeke: —Téhdure muurá nééne dííbyé waajácúháámɨtu: “Tsá Máavyéjuube Píívyéébeke memáváríjchóityúne.” ");
INSERT INTO boaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ehdúhjáa Jetsóó néérónáa ɨ́hvéjtsótuube tsiiñe tsajtyé dííbyeke cáméhbaú nɨ́jcaúvu. Áhbaú nɨ́jcáutúhjáa úújétsoobe páneere ííñújɨ́ avyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Áánemáhjáa neébe: —Páneevúré íñeevu uke ó ájcuú u mɨ́móúúvéne oke u dúúrúváhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Áánélliihyéhjáa Jetsóó dííbyeke nééhií: —Dɨ́hne óhdityu, Náve Naavénej. Muurá Píívyéébé waajácúháámɨtu nééneé: “Máavyéjuube Mépiivyéébekéré medúúrúváábeke méɨ́ɨ́cúvéiyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ehdúhjáa Jetsóó néénetu ílluréjuco dibye ɨ́hvéjtsoíñúné dííbyeke. Ááné boonéhjáa níjkyéjɨ múnaáréjuco dííbyeke ɨ́ɨ́cuvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aanéhjáa téijyu tsojtsó múnáajpi Jóáake ditye cúvéhoojánúné uubállé Jetsóó iwáájácúne péé Gariréá iiñújɨvu íhcyóómi Natsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ácoomíyíhjyáa wahájchotáré iíjcyáne ɨ́ɨ́neebe Capenaóovu, teene Gariréá iiñújɨri íjcyáné unéúcóbá úníuri Tsaboróoo, Netaríii, íjcyáné dohjɨ́ba múnáá iñújɨ́ɨ́cú úníuri íjcyácoomívu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ehdúhjáa pajtyéné Píívyéébé ihjyú uubálle múnáajpi Itsaíá íllu néhdújuco: ");
INSERT INTO boaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jodíómú íjcyátúné mɨ́amúnaa ijcyá Gariréá unéú ijcyátsihyi Joodáá úníuri, Tsaboróoo, Netaríii, íjcyáné dohjɨ́ba múnáá iñújɨ́ɨ́curi. ");
INSERT INTO boaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aame ícyahíjcyá ɨdáátsówu éhne múúne cúúvétsihyi meíjcyadu ɨ́mɨáájú wáájácutúmé wágóóóvéiyóme. Árómema tsúúca ijcyájúcooróné ditye pájtyetéíyóné uwááboju. Ehdúhjáa Itsaíá nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aanéhjáa Jetsóó úwáábótujkénuube nééhií: —Méɨhvéjtso ímítyú ámuha meícyahíjcyáne. Ááne ámúhá ɨ́jtsaméí mécápayóóvé ɨ́mɨánejcúvuréjuco. Muurá tsúúca níjkyéjɨri íjcyaabe Píívyéébe íavyéjúejte íjcyáímyeke újcúíñe éévé úújetéhi. Ehdúhjáa Jetsóó úwáábótujkénuube nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aabéhjáa Gariréá unéú úníuri péhíjcyaabe úújeté tsaatétsí íñáhbema amómeke tsɨ́nuhíjcyámútsidívu. Tsáápi méméhjáa Tsimóo Péédoro. Áánetúhjáa tsíjpi mémé Aderée. ");
INSERT INTO boaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Áámútsikyéhjáa neébe: —Ookéréjuco meúráávye. Muurá íñe amómé lliiñája múnáajtétsí ámuhtsi meíjcyámútsikye ó pícyoó mɨ́amúnáakéréjuco Píívyéébedívú ámuhtsi meɨ́búwáávétsóíñé wákimyéivu. ");
INSERT INTO boaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ehdúhjáa Jetsóó néénéllii teenémáyé ɨjtsɨ́nuuháñé ɨɨ́hvéjtsóne peemútsí dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Átsihdyúhjáa éhnííñéwúuri ájtyúmɨɨbe tsíjtyetsi íñáhbema Jacóóboo, Jóáaá, íjcyamútsí cááni Tsebedéoma ɨhmɨ́ɨ́né pañe ɨjtsɨ́nú pájáábohíjcyamútsikye. Áámútsikyéhjáa idyé pɨ́úvaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aamútsíhjyáa téhdure ɨhmɨ́ɨ́nema cááníkye ɨɨ́hvéjtsóne péé dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Páneerée Gariréá iiñújɨri muuha ímamyémuma Jetsóó úwááboobéré pehíjcyá mɨ́amúnáake diityé pihcyáávejááné pañévu. Úwáábohíjcyaabée ɨ́mɨáájú Píívyéébé avyéjutu íjcyáné uwááboju diityéke. Aabée bóhɨ́ɨ́tsohíjcyá páhduváré nééne chémeháñeri chéméméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ehdúu dibye méénuhíjcyánéhjáa páneere Tsííriá iiñújɨ múnaa iwáájácúne tsívahíjcyá dííbye éllevu páhduváré nééne chémeháñeri chéméméhjɨke: Avyéháñeri íjcyámeke, naavémú ípañe íjcyámeke, méívatéméhjɨke, íjpi vááúmeítyúneri chéméméhjɨke. Áámekée bóhɨ́ɨ́tsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ávyetáa pahúlleváré múúhama dibye péhíjcyáhulle mítyame mɨ́amúnaa dííbyeke úráávyehíjcyá Gariréaa, Decááporii, Jerotsaréee, Jodéá iiñújɨɨ, Joodáá tsiñéjcuu, íjcyátsɨ́hjɨ múnaa. ");
INSERT INTO boaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aamée dííbyedívú píhcyáávénéllii cáméhbáú hallúvú ácúúveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Áábedívúu muha mepíhcyáávémeke pámeekéré úwááboobe nééhií: ");
INSERT INTO boaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Maímijyu ditye íjcyane ɨ́dátsó Píívyéébé icyánéjcú pɨáábójuri tsúúrámeíhijcyáme. Muurá tehdu néémé wáábyuta dííbyé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Maímijyu ditye íjcyane ɨ́dátsó kímóhcó nénehjɨ pátyehíjcyáme. Muurá Píívyéébe tehdu nénehjɨ pájtyémeke ímíjyúúvetsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Maímijyu ditye íjcyane ‘mityáhmítyá’ néétume ímí tsaɨ́ɨ́buwáré ícyahíjcyáme. Píívyéébée diityéké iájcuíñé nééné iiñújɨ́ muurá diityé wáábyuta. ");
INSERT INTO boaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Maímijyu ditye íjcyane Píívyéébe ímillédú iíjcyáíyóneri tsúúrámeíhijcyáme. Muurá tehdu néémeke pɨ́ááboobe dibye ímillédú éhnííñevu ímí ditye iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maímijyu ditye íjcyane pamévakéré ɨɨ́daatsólléne pɨ́áábohíjcyáme. Muurá tehdu néémedi téhdure Píívyéébe ɨɨ́dáátsóvéne pɨ́aabóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Maímijyu ditye íjcyane panévatúré ɨ́mɨááméré iíjcyáíyóneri tsúúrámeíhijcyáme. Muurá tehdu nééme tsaímíyé dííbyema ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Maímijyu ditye íjcyane tsaímíyé pamévamáyé iíjcyáíyóneri tsúúrámeíhijcyáme. Muurá tehdu néémeke ɨ́mɨááné Píívyéébe dilló ɨ́ɨ́tsɨ́ɨ́medi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maímijyu ditye íjcyane ɨ́mɨáájú Píívyéébe néhdújuco ímí iúráávyéné déjúcotu ɨ́cúbáhrámeíhijcyáme. Muurá ehdu néémé wáábyuta dííbyé avyéjú ijcyá níjkyéjɨri. ");
INSERT INTO boaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Maímijyu ámuha meíjcyane tahñéjté ámuha meíjcyáné déjúcotu mɨ́amúnaa ámúhadi ɨɨ́cúbáhrámedi iúúhɨ́vaténe nehníwu állíuháñé íhjyúvahíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muuráhjáa ehdu nénehjɨ éíjyuúvú téhdure Píívyéébé ihjyú uubálle múnáake patyéhijcyáhi. Ahdícyane tehdu nénehjɨ ámúhakye pájtyérónáa íllure méimíjyuhíjcyaco. Muurá tehdu ámuha meɨ́cúbáhrámeíhíjcyáne áhdó ávyeta ɨ́ɨ́né imíjyaú ámuha méíjcyaá níjkyéjɨri. ");
INSERT INTO boaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aame ííñújɨri ámuha méijcyá cánáámadu. Muurá teene cánááma iíímúnéllii meke pɨ́aabóhi. ¿Aca iíímútuca meke pɨ́áábóiyóne? Tsáhaá. Muurá tehdu tene nééca mewáágoóné mɨ́amúnaa ɨ́ɨ́teíñuhíjcyáiyáhi. Ahdu ámuha oke meúráávyénetu meɨ́hvetéhajchíí waagóojtéréjuco ámuha meíjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Muurá peetédú ámuha méijcyá ííñújɨri ɨ́mɨáájú ámúhadítyú bóhówaúcunúhijcyáme. Muurá tsácoomi cáméhbáú nɨ́jcáuri íjcyacóómí tsá téévetúne. ");
INSERT INTO boaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Áhdure peete tsá múijyú tsíeménevu maávohjácóítyuróne. Muurá ihdyu cáámevu íboohówátsihvu mépicyóó tene iájchúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ahdu ámuha menééme ihdyu óvíi ɨ́mɨáánéré ámuha meméénúnetu mébóhówaúcunú teene iájtyúmɨ́ne tsijtye iávyéjújtso dúúrúvaméré níjkyéjɨri íjcyaabe Méécáánikye. ");
INSERT INTO boaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Álliúúmé ihdyu méɨjtsúcunúdí Píívyéébé taúhbajuu, dííbyé ihjyú uubálle múnaápe úwáábohíjcyanéhjɨɨ, íjcyane o tútávajtsóvaabe o tsááneé. Muuráhjáa ihdyu o tsáá muhdú teene taúhbaju néhijcyáné ímíñeúvú mɨ́amúnáadívú o bóhówájtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aane ɨ́mɨáánetúré ámúhakye o néé muurá Píívyéébé taúhbaju tsá múijyú wágóóóvéityú páneere níjkyéjɨma ííñujɨ wágóóóvérónáaáca. Muurá páneere dííbyé waajácúháámɨtu néhíjcyanéhjɨ́ pájtyeé muhdú tene néhijcyádújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Muurá tsaate dííbyé taúhbajúúnetu ɨ́ɨhtsúnéwu íjcyaróné cáhcújtsotúmé múhdurá dárɨ́ɨ́vehíjcyámé tsá ávyejúúllémeíityú dííbyé avyéjuvu. Áánetu panéváré dííbyé taúhbajúúné ímí cáhcujtsómé téjɨjtójuco mɨ́amúnáake úwáábohíjcyámé dííbyé avyéjú níjkyéjɨri íjcyanévú avyéjúúlléméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Muurá ɨ́mɨááné ámúhakye o néé eene taúhbajúúné uwáábojtémá paritséómú múhdurá ícyahíjcyádú ámuha meíjcyáhajchíí tsá múijyu ámuha meíjcyáityú Píívyéébé avyéjúejte. ");
INSERT INTO boaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Muurá ámuha méwaajácú éíjyuúvúu ámúhá ɨhdé múnáaúvuke íllu némeíñe: “Tsá múu mɨ́amúnáake dsɨ́jɨ́vétsotúne. Muurá tehdu néémema ɨhnáhooíñé tene ímíbájchómeíñe.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Áhdure ámúhakye o néé tsaate íñahbéjtedívú cáyobáávatéróné muurá téhdure ápíchó diityé hallúri. Áhdure idyé tsaaté ehdɨ́ɨ́vá tsijtye néhajchíí diityémá ímítyúné ímibájchojte teene ímíbájchoóhi. Áhdure tsíjtyeke ávyéta néhní úhbámé hallúrí ápíchó teene cúújúwá pañévú ditye wágóóóvéiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Áánéllii múu díñahbéébema ímityúné ámuhtsi medárɨ́ɨ́véjcatsíhajchíí ímíbáchójcatsíhi. Áijyu ihdyu Píívyéébeke dúúrúvámeíhíjcyátsihvu tsíeméné u tsájtyéneri u dúúruváné ímí ɨjtsúcunúúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Téhdure múu tsaatémá ámuha ímítyunéhjɨ́ ditye ímíbájchóhullévú metsátyéjcatsíhajchíí téhullévú iúújetétúné ɨhde ímíñeúvú cánáájánújcatsí ávyéjujtédívú ámuha mecúvéhoojánútsójcatsítyuki. ");
INSERT INTO boaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ɨ́mɨáánetúré ámúhakye o néé tsá muurá cúvéhóójatu ámuha meíjchívyéítyuró páneere ámuha maáhdótúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tsúúca muurá ámuha méwaajácú éhnéhjáa éíjyuúvú méɨhdé múnáaúvuke Píívyéébe íllu úwaabóne: “Tsá múu ihdícyámema dómácójcatsítyúne.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Áhdure idyé ámúhakye o néé muurá tsaapi pevénéré tsáápílledi úmúúpívyérónáa tsúúca dííllema múu dómácójcatsídyú ímityúné méénuube ɨ́ɨ́jtsaméí pañe. ");
INSERT INTO boaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ahdícyane díhyállúuri u ɨ́ɨ́téneri ímityúné u méénúíyóneri u úmúúpivyéhajchíí múu waagóó teéu. Óvíjyuco ihdyu tsau díhyálluu u wájyúrou wágóoovéné u ímíjpyeté tsáijyu múúne páneere díjpi ímí nééroobe cúújúwá pañévú u wágóóóvénáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Áhdure díhyójtsɨri ímityúné u méénune uke tútávátsóhajchíí múu waagóó téhojtsɨ. Óvíjyuco ihdyu téhojtsɨ u wájyúrohójtsɨ́ wágóoovéné u ímíjpyeté tsáijyu múúne páneere díjpi ímí nééroobe cúújúwá pañévú u wágóóóvénáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Áhdure muurá tsúúca ámuha méwaajácú ámúhá ɨhdé múnáaúvukée Píívyéébe Moitséeúvuj tééveri íllu úwaabóne: “Tsaapi múu méwakye ɨɨ́hvéjtsócooca díílleke ajcú teene úúbálléné waajácúhaamɨ́vu.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Árónáa ámúhakye o néé muurá tsaapi méwakye ímítyunévú méénutsó tsíjpiima ícyahíjcyátúrólleke dibye ɨ́hvéjtsolle tsíjpiikye tájɨ́váneri. Áhdure diibye díílleke táábávaabe ímityúné meenú méwamájɨ́ɨ́ tsíjpí táábama iíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Áhdure idyé muurá ámuha méwaajácú éíjyuúvúu ámúhá ɨhdé múnáaúvuke Píívyéébe Moitséeúvuj tééveri íllu úwaabóne: “Tsane múu ɨ́mɨáánetúré imyéénuíñé Píívyéébe lléébónáa dííbye mémé idyómajcóné meenú muhdú iñéhdújuco.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Árónáa ámúhakye o néé téeméné ámuha meméénútuki. Tsá múu néétune: “Bo óvíi níjkyejɨ muhdú ijcyá o állíhajchííjyu.” Muurá Píívyéébé avyéjúré teéne. ");
INSERT INTO boaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Áhdure tsá múu néétune: “Bo óvíi ííñujɨ muhdú ijcyá o állíhajchííjyu.” Muurá Píívyéébe éhnéré idyé teene ííñujɨ. Áhdure idyé tsá múu néétune: “Bo óvíi Jerotsaréé muhdú ijcyá o állíhajchííjyu.” Muurá Píívyéébe ɨ́htsútuube ávyéjuube íjcyáábe cóómíyé técoómi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Áhdure idyé díhñíwau íjcyáróutu tsá múu néétune: “Bo óvíi muhdú táhníwau ijcyá o állíhajchííjyu.” Muurá u nééjuri tsá tsájɨ́ubáré llíjcyáítyuró díhñíwácotu. Áhdure tsá tsájɨ́ubáré cúúvenúítyuró u nééjuri. ");
INSERT INTO boaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Áánéllii múu ɨ́mɨáánéjuco íjcyane ápáhajchíí nééhií: “Éée ɨ́mɨááné tehdújuco teéne.” Áánetu ɨ́mɨááné íjcyatúné múu ápáhajchíí nééhií: “Tsáhaá tehdu néénejɨ́ɨ́vari.” Ehdu iíhjyuváné tsá múu éjkétsotú Píívyéébedítyu. Muurá tehdu meíhjyuváné Naavénedítyúré tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Áhdure muurá ámuha méwaajácú éíjyuúvúu ámúhá ɨhdé múnáaúvuke tsiiñe Píívyéébe Moitséeúvuj tééveri íllu úwaabóne: “Tsáápiikye íhyálluu tsijpi bóhdúcúúbé hálluu téhdure bóhdúcúúveéhi. Áhdure tsáápí ihwájɨ́ wápíyuúcúúbeéhjɨ́ wápíyúúveéhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Árónáa ihdyu ámúhakye o nééhií: Tsá múu ámúhakye ímityúné tsaate dárɨ́ɨ́véhajchíí pɨ́ámeítyúne. Áhdure tsaate ámúhakye méénúhajchíí tsá múu pɨ́ámeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Áhdure idyé tsaate ámúhama tsane iímíbájcho ɨpɨ́úvámedítyú ámúhá caaméeja dójtúcúhajchíí múu ɨɨná néétuméré ɨ́hvejtsó téhdure hállúeja ámúhá tsuucójá dibye itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Téhdure tsaate ámúhakye ‘múúhá pííchutátú múúhakye mépɨáábó wahájchotáwu’ néhajchíí múu tsajtyé diityémá ehnííñevújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Áhdure tsaate ámúhakye tsííñé pɨáábó táúmeíhajchíí múu pɨ́aabóhi. Áhdure tsaate ámúhakye tsíeméné bóónétu ióómíchoíñé táúmeíhajchíí múu ajcúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Muurá ámuha méwaajácú mɨ́amúnaa íllu úwáábócatsíhijcyáne: “Uke wájyúmemáyé múu wajyújcatsíhi. Áánetu uke múnáátsohíjcyámeke tsá múu wájyutúne.” ");
INSERT INTO boaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Árónáa ámúhakye o nééhií: Ámúhakye múnáájtsórómeke múu wajyúhi. Áhdure ámúhakye múhdurá dárɨ́ɨ́vérómé hallúvú múu pɨááboju táúmeí Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Áijyu ihdyu ámuha méíjcyaá ɨ́mɨááné ámúháj Caani níjkyéjɨri íjcyáábej tsɨ́ɨ́me. Diibye muurá núhbake ájchutsó pámeere ímítyúróméhjɨma ɨ́mɨáámélliíhye. Áhdure nííjyaba állétsohíjcyaabe ɨ́mɨájɨ́jtó úráávyehíjcyámema téjɨjto úráávyehíjcyátúrómélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Muurá ámúhakye wájyúmekéré ámuha mewájyúhajchíí tsá ɨ́mɨá wájyú tene íjcyatúne. Ehdu ámuha mewájyújcatsíñé tsá Píívyéébe ímí ámúhadívú ɨ́jtsúcunútúne. Muurá ímityúmé íjcyarómé téhdure diityéké wájyúmeke wajyúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Áhdure ámúhakye ímí náhbévahíjcyámemáyé ímí ámuha meíhjyúváhajchíí tsá ámuha ɨ́mɨáámé meíjcyatúne. Muurá téhdure Píívyéébeke wáájácúturómé ímí iíjcyámema ímí ihjyúvájcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ahdícyane ɨ́mɨááméré múu ijcyá ámúháj Caani níjkyéjɨri íjcyaabe ɨ́mɨáábé íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tsá múu mɨ́amúnaa ámúhadi iúllévenúkíyé méénutú ɨ́mɨájɨ́jtó ámuha meúraavyéne. Muurá tehdu ámuha meméénúhajchíí níjkyéjɨri íjcyaabe ámúháj Caani tsá ímí ámúhakye ɨ́jtsúcunúityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Áánéllii múu ɨ́dáátsómeke ɨpɨ́aabóné tsá úbálléjcatsítyú eene ímityúmé bañú múnaa íjcyame méénuhíjcyádu. Diitye muurá teene méénuhíjcyá pihcyáávejááné pañévú, ulléjɨjtónéj pɨɨnévú, mɨ́amúnaa ɨ́mɨáámé ditye íjcyane ɨɨ́jtsúcunúkíye. Aane téénetu ámúhakye ɨ́mɨáánetúré o néé ápááñéré tééne áhdójuco íjcyane mɨ́amúnaa diityéké dúúrúvahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Áánéllii múu tsaatéké pɨ́aabó téévéneúvúre. ");
INSERT INTO boaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Áijyu ihdyu ámúháj Caani pane wáájácuube ímí ámuha meméénuhíjcyáné ɨɨ́ɨ́téne tééne áhdó ámúhakye pɨ́ááboóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Áhdure tsá múu Píívyéébema ámuha meíhjyúvácooca eene diitye ɨ́mɨáámeúvúdú bañú múnaa íjcyame méénuhíjcyádú méénutúne. Muurá eene pihcyáávejááné pañévú ulléjɨjtóné úniúvú Píívyéébema ihjyúvahíjcyámé mɨ́amúnaa ɨɨ́ɨ́térokíye. Aane ɨ́mɨáánetúré diityédítyú ámúhakye o néé ápááñéré tééné áhdójuco íjcyane mɨ́amúnaa diityéké dúúrúvahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Áánéllii ihdyu múu dííbyema iíhjyúvácooca ɨ́mɨjcóhó pañévú iwátáháávéne ihjyúvá múha wáájácútúnáaáca. Áijyu ihdyu ámúhakye pɨ́áábóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Áhdure idyé tsá múu ihdícyanéhjɨ́ré íhjyúvatú dííbyema iíhjyúvácoóca. Pane tsá múu bɨwáánéré wápɨhtsúcuhíjcyatú dííbyeke wáájácutúmé méénuhíjcyádu. Muurá ɨtsúcunúhijcyámé ditye bɨwáánéré wápɨ́htsánuhíjcyánetu dibye diityéké illéébóne áñújcúiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ahdícyane tsá múu diityédú néétune. Muurá ihdyu Méécááni tsúúca waajácú ɨɨná méhdityu pɨ́htone dííbyekéi metáúmeítyúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Áánéllii múu íllu ihjyúvá dííbyema: Múúháj Caáni níjkyéjɨri u íjcyaábej, uke muha máávyéjujtsó dúúrúvamére. ");
INSERT INTO boaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aabe ihdyu díavyéjuvu múúhakye dúúcúne u ímillédú múúhakye túkevéjtso ííñújɨri muha meíjcyámeke muhdú níjkyéjɨri u méénuhíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aabe ihdyu óvíi múúhakye majchóvú ú ácuhíjcyá paíjyuváré tééne tájpí muha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Áhdure muha ímityúné meméénuhíjcyáné múúhadi dɨ́dáátsóvéne dábajɨ́ɨ́vé múúhakye ímityúné méénuhíjcyámedi muha meɨ́dáátsóvéne teene maábájɨ́ɨ́vehíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Áhdure múúhakye ɨ́hvéjtsótuubéré pɨ́áábohíjcyá mávaríjchojúúnevu muha metáhjátsámeítyuki. Muurá ɨ́htsútuube múijyú muhdú u íjcyáítyuube páné avyéjuubéré ú ijcyáhi. Áyu tehdújuco. Ehdu múu Píívyéébema ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ahdícyane muurá ámúháj Caani níjkyéjɨri íjcyaabe ámúhadi ɨɨ́dáátsóvéne ábájɨ́ɨ́veé ámuha ímityúné meméénuhíjcyáné tsijtye ámúhama ímityúné méénuhíjcyáné diityédí ámuha meɨ́dáátsóvéne maábájɨ́ɨ́véhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Áánetu ámuha diityédí meɨ́dáátsóvétúhajchíí téhdure tsá dibye ámúhadi ɨ́dáátsóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Áhdure múu ámuha tsáijyu dííbyema meíhjyúva majcho maáwácooca tsá kehdóvéméhjɨúvú íjcyatú eene bañú múnaa íjcyame mɨ́amúnaa iúllévenúkíyé ícyahíjcyádu. Muurá ɨ́mɨáánetúré o néé apááñéré tééne áhdójuco íjcyane mɨ́amúnaa diityédí úllévenúhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ahdícyane dííbyema ámuha meíhjyúva majcho maáwácooca tsá múu boohówáneúvú méénutúne. Óvíi ihdyu dííbyere ámúháj Caani waajácú tehdújuco ámuha meméénuhíjcyáne. Áijyu muurá ámúhakye pɨ́áábóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tsá múu ííñújɨri iéhnéváíyóneri tsúúrámeítyú múhajchótá tééne tájpí ámuha meíjcyáíyóneríjɨ́ɨ́vari. Muurá ámuha tééne tájpí meíjcyáronéhjɨ́ ámúhadívú tútávááveéhi. Áhdure naní múnaa ámúhadívú ɨ́cúbáhraáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Áánéllii múu tsúúrámeí níjkyejɨ́vú Píívyéébe ámúhakye ávyéjuutétsóíñeri. Teene ihdyu tsá múijyú muhdú ámúhadívú íjcyáityúne. Áhdure tsá téhulle naní múnaa íjcyáityú ámúhá avyéjú ámúhadívú tútávájtsóiyóme. ");
INSERT INTO boaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Muurá kénejcú éhnííñevu ímí ámúhakye pájtyénéjcuríyéjuco ámuha meɨ́ɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Muurá ámúhá hálluúúné peetédú nééneri ámuha ɨ́mɨáánéré meɨ́ɨ́téneri metsúúrámeíhajchíí teene ámúhadítyú bóhówaúcúnuúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Áánetu ímityúnéré ámuha meɨ́ɨ́téneri metsúúrámeíhajchíí téénetúré ámuha mébóhówaúcúnuúhi. Áijyu muurá Píívyéébé icyánéjcúejte ámuha meíjcyaróné tsáhájuco wáájácúmeíityú ílluréjuco ámuha metútáváávénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tsá muurá tene ímíítyuró míítyétsikye ámuha maávyéjuubéváne. Muurá tsáápiikyéré ímí ámuha méɨ́ɨ́cúvéiyá cáábyeké éhnííñevu ámuha mewájyúúbeke. Áánetu tsijpíiyo ɨ́ɨ́cúvérátuube imíchi ámuha mewájyútuúbe. Ehdu néénéllii tsá tene ímityú Píívyéébeke meúraavyémé metsúúrámeíñé mítyane meéhnéváíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ahdícyane ámúhakye o néé tééne tájpí ámuha meíjcyáneríyé meíjyácunútu majchoo, adoo, wájyamuu, íjcyáneri. ¿Aca páneere ɨɨná ámúhadi íjcyáne tájpí tsaímíyé ámuha méíjcyáiyáhi? Tsáhaá, muurá ijcyáné tsane tééne tájpí éhnííñevu ímí meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cáhawáá méɨjtsúcunu wahpéjteke bajtsóubáré múijyú méénútúrómeke diibye ámúháj Caani níjkyéjɨri íjcyaabe máchótsohíjcyáne. Aanéjɨ́ɨ́ muurá diityé ehnííñevu ámuha mɨ́amúnaa méwajyúmeíhi. Áámeke ámúhakye Píívyéébe tsá ɨ́ɨ́netú pɨ́htótsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Aca íjcyaabe tsaapi ámúhadítyú iiye éhnííñevu cáámenútsámeííyoóbe? Íjcyáábejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aanéjɨ́ɨ́ óvíjyacóóné ámuha meɨ́jtsámeíhijcyáné ámuha mewájyamúúváíyóneri. Cáhawáá méɨjtsúcunu wajcóháñé múhdutú píívyehíjcyáné pevétáré íjcyaróne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Muuráhjáa ávyéjuube Tsaromóó tsijtye ávyéjujté ehnííñevu íjcyáróóbé avyéjú wajyámu ímí tsá úújetétú teene wajcóháñe ímivu. ");
INSERT INTO boaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ehdu muurá Píívyéébe tsaímíyé téhmehíjcyá wajcóháñé wahájchotáré ímiñe íllúhwuúré tsúúca chémene. Aabéjɨ́ɨ́ awáá muurá ámúhakye éhnííñevu tsaímíyé téhmeéhi. Ehdu teéne, ámuúha cáhcujtsópítyúné mɨ́amúnaaj. ");
INSERT INTO boaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ehdu muurá páneere Píívyéébe tájpíyé ijcyáhi. Áánéllii tsá múu néétune: ¿Aca ɨɨná íñe mémájchoóhi? ¿Aca ɨ́ɨ́nemá íñe méwajyámú méújcuúhi? Tsá múu ehdu ɨ́jtsámeítyú Píívyéébe íjcyátúcoocájɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Muurá ihdyu Píívyéébeke cáhcújtsotúmé ehdu ɨ́jtsámeíhi. Áánetu tsá ámuha tehdu menéjúcootúne. Muurá ámúháj Caani níjkyéjɨri íjcyaabe waajácú ɨɨná ámúhadítyú pɨ́htone. Aabe ihdyu ámúhakye pɨ́ááboóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Áánéllii múu tsane ámúhadítyú pɨ́htóróneri ɨ́ɨ́cúvetúmé tsúúrámeíhijcyá múhdutú tsaímíyé Píívyéébeke iúráávyéne dííbyé avyéjuvu iúcáávéíyóneri. Áijyu muurá tsá ámúhakye dibye ɨ́ɨ́netú pɨ́htótsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Áánéllii tsá múu ɨ́jtsámeítyú muhdú ámúhá úmɨwa íjcyáneri. Múu iíjcyájcóójɨri muhdú iíjcyáneríyé ɨ́jtsámeíhi. Muurá Píívyéébe ámúhakye pɨ́áábohíjcyaá panévatúré pajcóójɨváre. ");
INSERT INTO boaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ahdícyane tsá múu tsijtye múhdurá íjcyáneri íhjyúvatú Píívyéébe ámúhakye iñéétu téhdure ímityúmé ámuha meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Muurá tsíjtyeke ámuha ímityúné medárɨ́ɨ́véhajchíí téhdure ámúhakye Píívyéébe méénuú muhdú ámuha diityéké meméénuhíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Aca ɨ́veekí ámuha méijyácunúhijcyá ámúhá nahbémú hálluúúné pañe wááhyéwuúné íjcyáneri ámúhá hálluúúné pañe úménebááné íjcyane wáájácúmeítyúme? ");
INSERT INTO boaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Muura úménebááné ámúhá hálluúúné pañe íjcyame tsá ámúhá nahbémuke ámuha menééítyuróne: “Cána muha ámúhakye mebóhdo eene wááhyene ámúhá hálluúúné pañe íjcyane.” ");
INSERT INTO boaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ávyeta bañú múnaa ámuha meíjcyame pánehjɨ́dú ɨ́mɨáámeúvúdú ámuúha! Tujkénú méwaagóoméí eene úménebááné ámúhá hálluúúné pañe íjcyane botsíi ímí ámuha máájtyumɨ́mé mebóhdo teene wááhyene ámúhá nahbémú hálluúúné pañe íjcyane. Ehdu nééne tsá múu tsaate wahdɨ́ɨ́váné imítyúwu méénúneri íjyácunútú tsáijyu múu éhnííñevu ímityúné ámuha meméénuhíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tsá muurá ámuha ɨ́mɨáánevu oohímyeke maájcúítyuró bóónétu íllure ámúhakye dɨ́gújcúíyómeke. Áhdure muurá tsá ícyááve méénímudívú ámuha mepóvɨhjúcúítyuró íllure téuhjɨ tádɨ́rɨ́hcóíyómedívu. Ehdu nééne tsá múu ɨ́mɨáájú Píívyéébé uwááboju bañúháñé úwáábotúne. ");
INSERT INTO boaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Múu táúmeí Píívyéébeke tééne tájpí ámuha meícyahíjcyáné ámúhakye dibye iájcuki. Métsúúraméí ímí ámuha meíjcyáíyóneri ámúhakye dibye ɨpɨ́ááboki. Áhdure métáuméí ámúhakye dibye ityúkévéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Muurá tééne tájpí iíjcyáne táúmeímyeke ájcuúbe. Ímí iíjcyáíyóneri tsúúrámeímyeke pɨ́ááboóbe. Dííbyeke túkevéjtsoju táúmeímyeke túkévéjtsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Aca ijcyámé tsaate ámúhadítyú ɨ́jtsɨɨméné majcho táúmeícyooca nééwayúvúré ájcúiyóme? ");
INSERT INTO boaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Áhdure ¿aca amóóbeke tetsɨ táúmeíñáa ííñimyédívúré ájcúiyóme? ");
INSERT INTO boaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Muurá ímityúmé ámuha mɨ́amúnaa meíjcyarómé méimíllé ɨ́mɨáánevúré ámúháj tsɨ́ɨ́meke maájcune. Aanéjɨ́ɨ́ awáá muurá ámúháj Caani níjkyéjɨri íjcyaabe imíllé dííbyeke ámuha metáúmeímyeke ɨ́mɨáánevúré iájcune. ");
INSERT INTO boaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Muurá ámuha méimíllé mɨ́amúnaa ímí ámúhama íjcyane. Áánéllii múu iéhnéjcutu diityémá ɨ́mɨááméré ijcyá ditye téhdure ámúhama ɨ́mɨáámé iíjcyaki. Ehdu muurá Píívyéébe meke úwaabó Moitséeúvú waajácúháámɨtu, téhdure tsijtye dííbyé ihjyú uubálle múnáá waajácúhaamɨ́netu meke úwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Múu ɨ́hnáhó íuráávyé néérojɨ́jtó úraavyé níjkyejɨ́vú meúújetéjɨ́jto. Muurá íjcyajɨ́jtó tsɨ́jɨjto tsaímíyé meíjcyajɨ́jto. Árónáa téjɨjto meúráávyerómé nihñéétsihvúré méɨ́cúbáhrámeíhi. Árojɨ́jtó muurá mítyame úraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Áánetu ɨ́hnáhó íuráávyé néérojɨ́jtó meúraavyémé méúújeté múijyú muhdú meíjcyáítyúhullévu. Ájɨjto uhjéméré úraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tsáma téɨɨbúwá meíjcyá állíu múnaa Píívyéébé ihjyú uubálle múnáadi díllómeíhíjcyámeke. Muurá pánehjɨ́dú éhne imíwu obééjámú íjcyadu ɨ́mɨáámeúvúdú ámúhakye nahbévahíjcyá ávyeta bájú oohímyédú néémeé. ");
INSERT INTO boaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muurá téévetúné téeméjté íjcyánetu méwaajácú állíu múnaáré ditye íjcyane. Cáhawáá méɨjtsúcunuj, tsá muurá múijyú wacyónejke baaco nééváítyuróne. Tsá átéréehe múijyú ɨ́mɨááné nééváítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Áhdure ɨ́mɨááhé tsá múijyú átéréene nééváítyuróne. Áánetúré méwaajácú keehé ɨ́mɨááhé íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muurá oove íjcyane nééváné uméhé tsá nééváítyuró átéréene oove íjcyatúne. Áhdure oove íjcyatúné néévahíjcyahe tsá ɨ́mɨááné nééváítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Áánéllii múúne átéréehe meíllóne mécóvajtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aane muurá úmehééné méwaajácú keehé ɨ́mɨááhé íjcyane iñéévatúre. Ahdu ɨ́ɨ́vane cáhawáá óvíi ámuha méwaajácú állíu múnáake muhdú ditye íjcyánetúre. ");
INSERT INTO boaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Muurá oke ávyéjuubévahíjcyárómeke tsá pámeekéré níjkyéjɨri íjcyaabe Méécááni Píívyéébe íavyéjuvu újcúityúne. Muurá ihdyu dibye ímillédú íjcyámekéré újcúiibye íavyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Muurá muhdú mɨ́amúnaa ícyahíjcyáné ímíbájchómeícyooca mítyame oke avyéjuubévaá iíllityénemáye. Aame oke neéhi: “Ávyéjuúbej, muurá muha díuwááboju méúwáábohíjcyáhi. Aame dimyémeri muha méwáámíuhíjcyá naavémuke tsaaté pañétu. Ehdu muha dimyémeri méméénuhíjcyá méénúráítyúronéhjɨ.” ");
INSERT INTO boaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ehdu oke ditye néérónáa ó neé diityéke: “Íllure ámuha máallíhi. Keenéiyó ámúhakye o wáájacúne. Muurá ímityúné ámuha méícyahíjcyáhi. Aame meɨ́ɨ́né óhdityu.” Éhdure ó neé diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ahdícyane íñe caabyé o úwaabóné illéébóne tehdújuco íjcyaabe muurá éhne múúne wájácúnéjcuube cóhpétsihvu ihjya méénuubédu. ");
INSERT INTO boaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Muurá ávyéta cóhpé ihjya dibye méénúnáa kííjyébama nííjyaba mítyane álléneri téhiñe ɨ́hnáhó cáájávéróneri tsá muhdú teja íjcyatú ávyéta cóhpé nétsihvu dibye méénúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Áánetu íñe o úwaabóné lléébójúcóóroobe ímí íjcyátuube muurá éhne múúne wájácúnéjcútuube cóhpétútsihvu néwáyúúhá hallúvúré ihjya méénuubédu. ");
INSERT INTO boaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Muurá ihdícyátsihvúré dibye ihjya méénúnáa nííjyaba ávyétá ɨhnáhó kííjyébama íjcyáneri téhiñe cáájavéné teeja wááoja cáhvyabáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ehdúu Jetsóó úwáábóneri ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ávyétá ímíi úwáábohíjcyaabe diityéké tujkévéwu ávyéjuube múúne íhjyúvajɨ́jtójuco. Tsáháa dibye úwáábohíjcyatú taúhbájú uwáábojte úwáábohíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aabée Jetsóó teene cáméhbáutu níítyéébeke mítyame mɨ́amúnaa úraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Áánáacáa tsaapi íjpi chájááveebe dííbye éllevu itsááne dííbyé lliiñévú ɨmɨ́móúúvéne néé dííbyeke: —Ávyéjuúbej, ¿aca muhdúiyó teene oke u bóhɨɨtsóne? ");
INSERT INTO boaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Áánélliihyée neébe: —Mu ihdyu tehdújucoj. Ehdúu néébere dííbyeke dócárájcóneri tsúúca bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Áábekée neébe: —Tsáma tsaatéké dúúbálledí íñe muhdú u bóhɨɨ́ne. Tsapéhdúré llúúváábe éllevu pééne dííbyedívú dúhjétsámeítyeco. Ááne Moitséeúvúu néhdu Píívyéébeke tsíeméneri ú ɨ́ɨ́cúveé téénetu mɨ́amúnaa iwáájácu u bóhɨ́jucóóne. Ehdúu Jetsóó néé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Átsihdyúu muha Jetsóoma Capenaóovu meúújeténáa romáánómú tsodáhómú avyéjuube dííbye éllevu itsááne pɨáábó táúmeíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Neebépeé: —Ávyéjuúbej, táúníu múnáajpi chémeebe ávyétá ɨhnáhó ɨ́cúbáhrámeíhi. Aabe tsáhájuco íjpi vááúmeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Áánélliihyée Jetsóó nééhií: —Cána bo o péé o bóhɨ́ɨ́tso dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Áánélliihyée neébe: —Avyéjuúbej, muurá íñe tsíjtye múnáajpíyé o íjcyaabe ɨ́dátsó o néébe jávú tsá u ááhɨ́véítyuróne. Áánéllii ihdyu uke o néé íchihdyúré u íhjyúváné tujkéveri dibye ibóhɨɨ́ki. Muurá ó cáhcujtsó dibye bóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Muurá táavyéjujte oke táuhbáné ó méénuhíjcyáhi. Áhdure tsodáhómuke o táuhbáné méénuhíjcyáme. Muurá tsáápiikye diityédítyú tsiéllevu o wállóócooca peebe téhullévu. Áhdure tsáápiikye o pɨ́úvácooca tsaábe. Áhdure táúníu múnáájpikye tsíeménevu o táuhbáné méénuúbe. Ahdícyane ó waajácú u néécooca táúníu múnáajpi bóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ehdúu diibye tsodáhómú avyéjuube nééneri iúllévenútsihdyu neebe tétsihyi íjcyámeke: —Ɨ́mɨáánetúré o néé tsá muurá tsáápíubáré tamúnaa ijraéémudítyú cáhcújtsotú íñe áánu cáhcujtsódu. ");
INSERT INTO boaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ehdu muurá pahúllevátú tsaaímyé mítyame ijraéémú íjcyáturómé íñe áánu romáánómuube cáhcujtsódú ímí Píívyéébeke cáhcújtsoímye. Aame dííbyé avyéjuvu úcaavémé nahbévájcátsií majchóháñeri Aavaráaa, Itsáaa, Jacóóboo, íjcyámema. ");
INSERT INTO boaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Áánetu ijraéémudítyú mítyame wágóóóveé ícyuuvétsíí pañévú Píívyéébé avyéjutu ímichi diityé wáábyuta íjcyárónetu. Aame tétsihyi ɨ́cúbáhrámeímyé tahíjcyaá íhwáñeene ɨɨ́hdónema. ");
INSERT INTO boaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ehdúu iñééné boonétú tsiiñe neebe diibye tsodáhómú avyéjúúbeke: —Áyu wa dipye dihjyávuj. Óvíi ihdyu u cáhcujtsódú íjcyane úúma díúníu múnáajpi bohɨ́ɨ́hií. Ehdúu Jetsóó nééné tujkéveríhjyáa tsúúca bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Áhdurée dííbyema muha Péédoró javu mepéénáa diibye Péédoró baabe áíívyeri chémelle ícyuwájá pañe. ");
INSERT INTO boaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Áállekée Jetsóó íhyójtsɨtu ékéévéneri tsúúca bóhɨɨlle múúhakye májchotsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tépejcóo Jetsóo éllevu tsivámé naavémú ípañe íjcyáneri chéméméhjɨke. Áámé pañétúu ijchívyétsoobe diityéke. Áhdurée tsííñe chémeri íjcyámeke bóhɨ́ɨ́tsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ehdúu Jetsóó méénuhíjcyá téijyu Píívyéébé ihjyú uubálle múnáajpíhjyáa Itsaíá íllu néhdújuco: “Dííbyere méhdityu páhduváré nééne chémeháñé waagóóhi.” Ehdúhjáa Itsaíá néhdújuco dibye méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Áábedívúu téijyu mítyanéjuco mɨ́amúnaa píhcyáávénéllii múúhakye neebe muha únéúcóbá tsiñéjcuvu mepájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Áánáacáa tsaapi taúhbájú uwááboobe dííbye éllevu itsááne nééhií: —Uwááboóbej, ó imíllé úúmaye o péhijcyáné kiávú u péhullévújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Áánélliihyée Jetsóó néé dííbyeke: —Muurá iyámé óówamu íjcyarómé íhyéjúnema téhejújɨ́ pañe icyúwaki. Áhdure wahpéjté ijcyá icyúwáítsɨ́hjɨma. Áánetu muurá íñe Mɨ́amúnáájpidívúu o ípívyééveebe tsá tahjyáúbamáyé o íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Áijyúrée idyé tsaapi dííbye déjuri péhíjcyámedítyú néé dííbyeke: —Ávyéjuúbej, ói o péé llihíyo éllevu. Óvíi ihdyu múijyú óhdivu dsɨ́jɨ́veebe úúmayéjuco o úllehíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Áárónáacáa Jetsóó néé dííbyeke: —Óvi ihdyu tsamééré ɨ́mɨájɨ́jtó úráávyetúmé cúúújcatsí ɨdsɨ́jɨ́vécoóca. Wa ihdyu ookéréjuco duráávyej. ");
INSERT INTO boaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Átsihdyúu muha mɨ́ɨ́neri mepéé únéú tsiñéjcuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Áánáacáa ávyéta tsɨ́jpá nééné kiijyébari mítyane nohjɨ íjcyane múúhakye pámaúcúiyáhi. Áijyúu Jetsóó cuwáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Áábekée muha ɨ́ɨ́cúi maákyéjtsóne menééhií: —¡Ávyéjuúbej, meke pájtyetétso! ¡Tsúúca mémájcánuúhi! ");
INSERT INTO boaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Áánélliihyée neebe múúhakye: —¿Ɨ́ɨ́neríami ámuha méíllityé ayájú ɨhnáhóhajaj? ¡Tsáháikyéha ímí ámuha mecáhcújtsotú Píívyéébeke! Ehdúu múúhakye iñétsihdyu kííjyébama nohjɨ íjcyane úhbaabe tene ɨɨ́hvetéki. Ahdújucóo tene ɨ́hveténé dáíhañéréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ehdúu téijyu Jetsóó méénúneri muha meúllévenúne ménéjcatsíhi: —¿Muubáami aabye íjcyáábeke muhdú kííjyébama nújpacyo lleéboj? ");
INSERT INTO boaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aanée tsúúca muha tsíñejcúeúvú méúújeté Gadáárá iiñújɨvu. Áánáacáa dííbyeke míítyétsi cáhdahɨ́ró naavémú ípañe íjcyamútsí níjkyénéj pɨɨnéréhjáa ícyahíjcyamútsi. Aamútsíhjyáa apííchówu néémutsi tétsii ícyahíjcyánéllii tsá múha tétsii úllehíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aamútsíi Jetsóoke kévádijcyó ílluú: —¡Múhtsikye ihdyu pátsáríjcyodí Píívyéébé Hajchi u íjcyaábe! ¡Tsáhái muurá ɨ́cúbáhraméi éévé íjcyatúne! ");
INSERT INTO boaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Áijyúu tétsííj pɨɨhɨ́rí mítyame jéémú meenímú majchóri. ");
INSERT INTO boaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Áánélliihyée naavémú diityétsí pañe íjcyame Jetsóoke nééhií: —Múúhakye íjtyétsí pañétú u wáágóóhajchíí aatye méénímú pañévuréjuco muha meújcámeíiñe. ");
INSERT INTO boaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Áánélliihyée neebe diityéke: —Wa ihdyu méújcaméí diityé pañévuj. Ahdújucóo ditye iíjchívyéne újcámeíñé diityé pañévuréjuco. Aamée únéú pañévú cáhtsíñibámé májcanúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ehdúu méénímuke tene pájtyéneri diityé tehméjté ávyétá ɨhnáhó íllityéhi. Áánemáa ɨ́ɨ́cúi tétsííj pɨɨhɨ́rí íjcyáméhjɨ éllevu ɨdsɨ́ɨ́néne úúballémé muhdú tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Áánélliihyée pámeere tsáácunú Jetsóo éllevu. Aamée dííbyeke néé tétsihdyu muha mepéékií. ");
INSERT INTO boaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ahdújucóo muha meóómiñe bɨwáhullévúré múúhá coomívu. ");
INSERT INTO boaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Átsihyíi muha meíjcyánáa Jetsóo éllevu tsaate tsivá íjpi vááúmeítyúúbeke ɨ́ɨ́botári. Aamée dííbyeke cáhcujtsóné iwáájácúne dííbyeke ɨɨ́ɨ́téne neébe: —Llíhij, wa ílluréjuco dímijyúúvej. Muurá tsúúca úhdi o ɨ́dáátsóvéne díimítyú ó ábájɨɨvéjucóóhií. Ahdícyane tsáhájuco ɨɨná díhyallúrí íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ehdúu Jetsóó nééne tsaate taúhbájú uwáábojte illéébóne ɨ́ɨ́buwááné pañe nééhií: —¿Aca ɨ́veekí eene aabye ímityúné ihjyúvá Píívyéébe ímí dííbyedívú ɨjtsúcunúnejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ehdúu ditye ɨ́jtsámeíñé Jetsóó iwáájácúne néé diityéke: —¿Aca ɨ́veekí ámuha ímityúné óhdityu méɨ́jtsámeíhi? ");
INSERT INTO boaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Aca muhdú ámuha oke méɨjtsúcunúhi? Áánerá ó piivyété mɨ́amúnáadi o ɨ́dáátsóvéne diityé imítyuháñé diityémá o ímíbajchóne. Áánéllii ó piivyété áánúke o nééneé: “Úhdi o ɨ́dáátsóvéne díimítyú úúma ó ímíbajchóhi.” Áhdure ó piivyété o nééneé: “Dímíjpyeténe dipye.” ");
INSERT INTO boaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ahdícyane cáhawáá óvíi ámuha máájtyumɨ́ Mɨ́amúnáájpidívúu o ípivyééveebe muhdú o méénune. Ehdúu diityéké iñétsihdyu tsiiñe neebe dííbyeke: —Dímíjpyeténe eene dɨ́ɨ́hbotámá dipye dihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ahdújucóo dibye pééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ehdúu Jetsóó méénúneri mɨ́amúnaa iíllityéne Píívyéébeke ávyéjujtsó dúúrúvaméré dííbyé ɨhtsúturi dibye ehdu méénúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsáijyúu Jetsóó oke Matéoke ájtyumɨ́ múúhá iiñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke o áhdótsohíjcyátsihyi o íjcyáábeke. Aabée oke nééhií: —Ookéréjuco duráávyej. Ahdújucóo o pééne dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Áábemáa téijyu tahjyávú muha mémajchóhi. Áhdurée tsijtye téénere dsɨ́ɨ́dsɨ́ ahdótso múnaa múúhama majchóhi. Áhdurée tsijtye ímityúmé ijcyá múúhama. ");
INSERT INTO boaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Áámekée ɨɨ́ɨ́téne paritséómú néé múúhakye: —¿Aca ɨ́veekí eene ámúhá uwááboobe majchó aatye ímítyúmema? ");
INSERT INTO boaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aanée Jetsóó illéébóne néé diityéke: —Tsá muurá taabóóbé bóhɨɨme tsaímíyé íjcyámeke táábotúne. Muurá ihdyu chéméméhjɨkéré tááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cáhawáá ímíñeúvú meéévé ámuha mewáájácu Píívyéébé waajácúháámɨtu tsátsii nééneé: “Muurá tsá apááñéré o ímílletú ámuha oke Píívyéébeke iyámedi meɨ́ɨ́cúvehíjcyáne. Téhdure ó imíllé ámuha pamévamáyé meɨ́daatsólléjcatsíñe.” Ahdícyane tsáháa ɨ́mɨáámé wáábyú o tsáátune. Muuráhjáa ihdyu ímítyúme wáábyú o tsáá diityéké téénetu o ímíbáávyétso Píívyéébé icyánejcúvuréjuco ditye ɨɨ́búwááveki. Ehdúu Jetsóó néé paritséómuke. ");
INSERT INTO boaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Áhdurée tsáijyu tsojtsó múnáajpi Jóáá mamyémú Jetsóo éllevu itsááne dííbyeke dilló tsáijyu Píívyéébema iíhjyúvácooca majcho iáwahíjcyánetu. Néémépeé: —¿Aca ɨ́veekí tsáijyu muha paritséómuma Píívyéébema meíhjyúvácooca majcho mááwahíjcyánáa tsá dímamyémú áwahíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Áánélliihyée neebe diityéke: —¿Aca tsaapi ityáábávácooca wáñehjɨ́vaténevu dííbyé miñútso múnaa tsááme kímóóvéiyá dííbyedívú iwájtsɨ́coóca? Ehdu nééne támamyémú tsá kímóóvéítyuró diityémá o íjcyáné hajchóta. Árónáa ihdyu ɨ́mɨááné íjcyaíñé diityédítyú o pééiñe. Áijyu ihdyu óvíi muhdú iñéhajchíí awámye. ");
INSERT INTO boaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tsá muurá tene ímityú wájyamu tsúúcáaja béhbátu mepájaabóne. Muurá íllure teeja meníjtyúcooca éhnííñevu táváajcároba. ");
INSERT INTO boaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Áhdure idyé tsá tene ímityú béjpácyo bíínojpácyó mepícyoone tsúúcáau mɨ́ɨ́héneu cahpáyú pañévu. Muurá béjpácyo iúhtsáráúúvéhulle táváajcó tsúúcáau. Áijyu muurá wágóoovéné tsanéécújuco bíínójpácyoma cahpáyu. Áánéllii ihdyu béjpácyo mépicyóó bééú pañévúré muhdú tsanéécú iíjcyátuki. Ehdu nééne tsá tene ímityú ɨ́hdééné uwááboju béhné uwáábójú pañévú meúacóne. ");
INSERT INTO boaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ehdúu Jóáá mamyémuma Jetsóó íhjyúvánáa tsaapi avyéjuube wajtsɨ́ múúhadívu. Aabée dííbyé lliiñévú ɨmɨ́móúúvéne néé dííbyeke: —Ájyúwa íhyajchíí óhdivu dsɨ́jɨvéhi. Árónáa ó waajácú dille óóma tsiiñe bóhɨɨíñé u péébe díílleke u dócárájcóneri. ");
INSERT INTO boaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Áánélliihyée téhullévú péébema muha mepééhií. ");
INSERT INTO boaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aamée muha téhullévú mepéénáacáhjáa tsáápille 12 pijcyábájuco díílleke ichémé tujpácyó ɨ́hvetépityúneri ɨ́cúbáhrámeíhíjcyalle pɨɨhɨ́vé Jetsóodívú idyéju éhnéjcutu. ");
INSERT INTO boaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aalléhjáa dómajcó dííbyé wajyámú ‘muurá éhne íwajyámú íjcyaróné o dómájcóhajchíí ó bóhɨɨ́hi’ iñéénema. Éhdúhjáa ɨɨ́jtsámeíñe dómájcolle dííbyé wajyámu. ");
INSERT INTO boaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aanéhjáa iwáájácúne díílledívú iyévóóvéne neébe: —Ɨ́ɨ́nerí kímóóvedíñe, Wáhaj. Muurá Píívyéébeke ímí u cáhcujtsódújuco íjcyalle íñe tsúúca u bóhɨɨ́ne. Éhdúu Jetsóó néénemáyé ɨ́mɨááné tsúúca bóhɨɨ́lle. ");
INSERT INTO boaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aamée muha tsúúca méúújeté diibye avyéjuube Jáiró javu. Áánáacáa mítyane tééjá pañe mɨ́amúnaa kímóóveri íjcyame máátyóba májtsí méénuhíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Áámekée Jetsóó nééhií: —Cána méijchívyéi áachívuj. Muurá tsá dille dsɨ́jɨ́vetúne. Íllure cúwalle. Éhdúu Jetsóó nééneri íllure goocómé dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Áámekée tééjá pañétú iíjchívyétsóné boone iiyéjuco dibye iúcáávéne díílléwúuúvú hójtsɨtu ékééveténeri tsúúca bóhɨɨ́lle. ");
INSERT INTO boaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ehdúu Jetsóó méénúné uubállé páneere tééné iiñújɨ múnaa waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aanée tétsihdyu muha tsúúca meóómíñáa míítyétsi hállúvátumútsí múúha déjutu dsɨɨnéríyé tsáámutsi dííbyedi wáníjcyámeíhi. Íllúu neemútsi: —¡Múhtsidi bo dɨ́daatsóvé Dabíiúvúj tsɨɨménémúhaabe u íjcyaábej! ");
INSERT INTO boaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aanée muha meícyahíjcyajávú mewájtsɨ́tsihvu Jetsóó dilló diityétsikye: —¿A ámuhtsi mécáhcujtsó ámúhtsikye o ímíjpyetétsóiyóné ámúhtsí hálluúúne? Áánélliihyée neemútsi: —Éée Ávyéjuúbej, muhtsi mécáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ehdúu dityétsí néénéllii diityétsikye íhyálluúúné idyócárájcóne neébe: —Ámuhtsi mecáhcujtsódújuco íjcyane tsúúca ámúhtsí hálluúúné ímíjpyetéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ahdújucóo ɨ́mɨááné tsúúca íhyálluúúné ímíjpyetémútsí tsaímiyéjuco ɨ́ɨ́tene. Áámútsikyée bóíjcyuube muucá teene dityétsí iúúbállétuki. ");
INSERT INTO boaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Árónáacáhjáa tétsihdyu óómimútsí péé úbálléjcatsímútsíyé pámeekéré tétsɨ́hjɨ múnáake. ");
INSERT INTO boaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Áámútsi déjuvúu idyé tsaate tsivá íhjyúvátúúbeke Jetsóo éllevu naavéné ípañe íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Áábé pañétúu diibye naavéneke dibye íjchívyétsóné boone tsúúca ihjyúvájúcoóbe. Ááneríi mɨ́amúnaa iúllévenúne nééhií: —Ávyeta tsá múijyú ehdu nééne múha méhdityu méénune maájtyúmɨtúne. ");
INSERT INTO boaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Árónáacáa paritséómú nééhií: —Aadi muurá eene naavémuke ichívyétsohíjcyá páñétúejpi naavémú avyéjuube pɨ́áábóneríye. ");
INSERT INTO boaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ehdúu Jetsóó cómíñeri úwááboobéré pehíjcyá mɨ́amúnáake Píívyéébé avyéjutu íjcyáné uwááboju diityé pihcyáávejááné pañévu. Aabée bóhɨ́ɨ́tsohíjcyá panéva chémeháñeri íjcyáméhjɨke. Téhdurée ihjyáhañévúré tsaatéké úwááboobéré pehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aabée ɨ́dáátsóvehíjcyá mɨ́amúnáadi éhne múúne obééjámú ítyehméébema íjcyatúmé ɨdáátsówu íjcyadu nééme dííbye éllevu tsáámedi. ");
INSERT INTO boaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Áámedítyúu neebe múúhakye: —Ɨ́mɨááné mítyame mɨ́amúnaa ijcyá Píívyéébé avyéjuvu ditye úcáávéíyóné uwááboju úwáábómeíiyóme. Árónáa tééné uwáábojte tsá pahdu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Áánéllii múu táúmeí páné aabájaabéré íjcyaabe Píívyéébeke dibye éhnííñevu uwáábojtéké ipícyo ditye iúwáábo tsíjtyeke dííbyé avyéjuvu ditye iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aanée téijyu Jetsóó muuha ímamyémuke pihjyúcú 12-meva muha meíjcyámeke. Áámekée múúhakye ájcuube ɨ́ɨhnáhootu dííbye mémeri tsaaté pañétú naavémuke muha meíjchívyétsohíjcyaki, panéva chémeháñeri íjcyámeke muha mebóhɨ́ɨ́tsohíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Aamée muuha ílluúme: Tsimóo Péédoroo, íñahbe Áderéee, Tsebedéó hájchimútsí Jacóóboma Jóáámutsii, Perípee, Batoroméee, Tomáaa, ííñújɨ́ avyéjúúbé wáábyutáa dsɨ́ɨ́dsɨke o áhdótsohíjcyaabe oo Matéoo, Apéó hajchi Tadéó dííbyere ‘Rebéo’ némeííbyee, cananíjtámúejpi Tsimóoo, diibyée Jetsóodívú bóónétu méénútsóiibye Jóóda Ijcaríóótee, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Éhdúmekée múúhakye Jetsóó uwáábovu iwállóómeke íllu pítyajcóhi: —Tsáma ihdyu mépehdí jodíómú íjcyátúmé iñújɨɨnévu. Áhdure Tsamááriá iiñújɨ́ méúújedíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ijraéémú pañévúré métsajtyécó íñe uwááboju éhne múúne obééjámú mújtame ɨdáátsówu íjcyadu néémé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aame méúwáábohíjcyaco níjkyéjɨri íjcyaabe Píívyéébe mɨ́amúnáake íavyéjuvu újcúíñe éévé tsúúca úújeténe. ");
INSERT INTO boaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Áhdure mébóhɨ́ɨ́tsohíjcyaco dsɨ́jɨ́véméhjɨke, íjpi chájáávéneri chéméméhjɨke, páhduváré nééne chémeri íjcyáméhjɨke. Áhdure tsaaté pañe naavémú íjcyámeke méwaagóohíjcyaco. Ehdu tamyémeri táɨhnáhori ámuha meméénúiñévú ámúhakye ó ajcú pevénére. Áánéllii tsá ámuha maáhdótsóityú ámuha diityéké mepɨ́áábonéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aame ihdyu métsajtyédí dsɨ́ɨ́dsɨke. ");
INSERT INTO boaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Áhdure métsajtyédí tsíjyahjɨ ámúhá wajyámúúnee, ámúha májchoo, ámúháj túhápaajɨ́nee, éhdune. Ámúhá cuujúí íjcyaróné métsajtyédíñe. Ámuha mepɨ́aabóméré ámúhakye pɨ́áábohíjcyaá panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aame múu tsácoomívú iúújetécooca nehcó tsaatéké ámuha tétsii meíjcyáné hajchótá ímí ámúhakye pícyóóímyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aane tsaaté javu ámuha meúújetécooca múu ímíñeúvú ihjyúvá diityéma. ");
INSERT INTO boaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aame ímílléhajchíí múu diityémá ijcyá ámúhaj tééveri diityéké Píívyéébe ɨpɨ́ááboki. Áánetu ditye ímíllétúhajchíí tsáhájuco múu ɨ́ɨ́cúvetú diityédi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Téhdure tsácoomí múnaa ámuha diityéké meúwáábóíyónéhjɨmáyé ímíllétúhajchíí méɨ́ɨ́cuvéjúcohdí diityédi. Ílluréjuco ámúháj tuhááñe ííñú mépíchóújcámeícyó ‘tsá múúhá hallúrí tene íjcyatú ámúhakye muha meúwáábóiyóné ámuha meímílletúne’ nééiyóne. Ááne tsiéllevúréjuco mépeeco tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Muurá ɨ́mɨáánetúré o néé tehdu nééme ɨ́cúbáhrámeíiñe éhnée Tsodóómaa, Gomóóraa, íjcyácoomícyu múnaa ɨ́cúbáhrámeíñé ehnííñevu muhdú mɨ́amúnaa ícyahíjcyáné diityémá ímíbájchómeícyoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ahdícyane íñe ámúhakye ó wallóó obééjámuke bájú oohímyé pañévú mewállóóiyódu. Aane ihdyu wajácútsi méíjcyaco éhne múúne ííñimye ɨ́ɨ́cúi meke pállójcoíñúdu. Árónáa ihdyu tsá múu muucá tútávájtsotúne. Ɨ́mɨááméré múu ijcyá ɨ́juumu íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aame ihdyu tsáma imíchi méíjcyaco. Muurá tsaate ámúhakye túkevéjtsojté éllevu itsájtyémeke pihcyáávejááné pañévú wápáájcoóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Áhdure ámúhakye tsajtyéimye ávyéjujté éllevu óhdityu íjcyáné uwááboju ámuha meúwáábohíjcyáné hallútu. Áijyu téhdure tétsihvu ámuha diityéké meúwááboó jodíómú íjcyátúrómeke. ");
INSERT INTO boaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aane ámúhakye ditye ékéévécooca tsá múu áábímyeítyú muhdú iíhjyúváíñeri. Muurá ihdyu Píívyéébere ámúhakye túkévéjtsoó ámuha meíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tsá ámúhá ɨ́jtsaméityu tsááne ámuha meíhjyúváityúne. Muurá ihdyu ámúháj Caani Píívyéébé Apííchó ámúhá pañe íjcyanéré ámúhakye túkévéjtsóneri ámuha méihjyúvaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aane muurá mɨ́amúnaa ávyétá imítyú dárɨ́ɨ́véjcátsiíhi. Muurá tsané nahbémú íjcyarómé lliihyánújcátsiíhi. Áhdure cáánimu íjcyárómema lliihyánújcatsíimye. ");
INSERT INTO boaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Áhdure mítyame ámúhakye múnáájtsoó oke ámuha meúráávyéné déjúcotu. Aane ehdu nééronéhjɨ́ tsaímíyé nihñéétsihvúré áábucúmé ihdyu pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Áhdure tsácoomí múnaa ámúhakye ímityúné dárɨ́ɨ́véhajchíí múu técoomítyú péé tsícyoomívuréjuco. Muurá íñe Mɨ́amúnáájpidívúu o ípívyééveebe ɨ́mɨáánetúré ámúhakye o néé tsiiñe ó tsááiñe ámuhái pámeekéré ijraéémuke íñe óhdityu íjcyáné uwáábojúvú mewáájácútsótúnáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Muurá tsaapi mamye tsá íuwáábóóbé ehnííñevu íjcyatúne. Áhdure tsáné avyéjúúbé úníu múnáajpi tsá dííbyé ehnííñevu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aane muurá íñe ámúhá avyéjuube o íjcyároobe o ávyejúúllémeítyúhajchíí téhdure tsá ámuha maávyejúúllémeíityúne. Muurá oke Betsebóodívú imyéménúúbeke állíu múnáájpidi díllohíjcyáme. Aaméjɨ́ɨ́va muurá ámúhakye iávyejúúllétúne téhdure dílloóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Árónáa ihdyu mááábímyeídí mɨ́amúnaa ámúhakye méénúíyóneri. Muurá tehdu nénehjɨ ámúhakye pátyehíjcyáné tsá tétsihvúré nɨ́jkéváityúne. Muurá páneere ɨɨná meméénuhíjcyáné bóhówááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Áánéllii íñe ámúhakye o néhijcyáné múu tsíjtyeke úúballéhi. Tsá idyé úúbálletúmé ámuha meíjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ahdícyane tsá múu áábímyeítyú mɨ́amúnaa ámúhakye dsɨ́jɨ́vétsóíyóneri. Muurá tsá ditye píívyetétú ámúhakye iwáágóóiyóné Píívyéébedítyu. Apáábyéré ihdyu diibye piivyété ámúhakye iwáágoóné ávyeta múijyú ámuha meíjchívyéityúmé meɨ́cúbáhrámeííyóné cuujúwá pañévu. Áánéllii múu apáábyedíyé Píívyéébedi áábímyeíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Muurá coomɨ́comútsí míítyétsíwuúcú tsájɨ́hwuúré áhdómeíhi. Ehdu áyá áhdómeíyómedítyú muurá tsá tsaapi ámúháj Caani Píívyéébe wáájácútúnáa dsɨ́jɨ́véítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aabe muurá páneere ámúhá níwáujɨ́ɨ́né íjcyaróné waajácú múhdújɨvá íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Áánéllii tsá ɨ́ɨ́nerí ámuha maáábímyeíityúne. Muurá diitye coomɨ́mú wájyúmeíñé ehnííñevu ámuha méwajyúmeí Píívyéébedívu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Muurá oke iúraavyéné tóónúmeítyúmeke ó bóhówájtsoó níjkyéjɨri íjcyaabe Llihíyodívu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Áánetu íllure tóónúmeíhíjcyámé hallúvú ó úúbálleé Llihíyoke tahñéjté ditye íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aane méɨjtsúcunúdí ííñújɨvúu o tsááne mɨ́amúnaa tsaímíyé iíjcyaki. Muuráhjáa ihdyu o tsáá táhallútú ditye itsárílléjcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Muurá tsaapi tsarílleé cááníkye oke dibye cáhcújtsóné hallútu. Áhdure tsáápille tsarílleé tsɨ́ɨ́juke tééné hallútu. Áhdure íbáábeke íaaja tééné hallútúré tsarílleéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ehdu muurá tsamééré múnáátsójcátsií oke tsaate imúnáadítyú cáhcújtsóné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Muurá oke iwájyúné ehnííñevu tsamééré cáánímuma ɨ́ɨ́tsɨɨme wájyújcatsíhajchíí tsá ɨ́mɨááné tahñéjté ditye íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Áhdure oke iúráávyéné déjúcotu ɨɨ́cúbáhrámeíiyóné ímílletúmé tsá tahñéjté íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Muurá ííñújɨri iímillédúré iíjcyáneri tsúúrámeímyé wágóóóveéhi. Áánetu ookéréjuco ímí iúráávyéneri tsúúrámeímyé pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Muurá ámuha táwákimyéí meméénúmeke ɨ́ɨ́cuvémé okée wálloobe Llihíyomájuco múhtsikye ɨ́ɨ́cuvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aame tsaímíyé Píívyéébé wákimyéí méénúmeke ɨ́ɨ́cuvémé tééne áhdo újcuú tsahdúré diityéma. Áhdure idyé tsijtye Píívyéébeke úráávyehíjcyámeke tsaímíyé ɨ́ɨ́cuvémé tééne áhdó újcuú tsahdúré diityéma. ");
INSERT INTO boaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aane diitye táuráávye múnáake nújpácyo dɨ́ɨ́vanévú ájcume téhdure újcuú tééne áhdo. ");
INSERT INTO boaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ehdúu Jetsóo muuha 12-meváké iúwáábótsihdyu péé tsiéllevu tééné iiñújɨ́ comíñevu téhulle iúwááboki. ");
INSERT INTO boaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Áánáacáhjáa cúvéhóójari tsojtsó múnáajpi Jóáa íjcyaabe tsúúca waajácú ehdu Jetsóó méénuhíjcyáne. Áánélliihyéhjáa wálloobe míítyétsikye ímamyémudítyú dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Aamútsíi neevá dííbyeke: —¿Ava diibyéjuco uu Pájtyetétsoobe éhneváa ííñujɨ́vú u bóhówáávéííbyeke muha meɨ́tsohíjcyaábej? ¿Mityá tsáhái diibye u íjcyatúnej? ");
INSERT INTO boaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ehdúu dityétsí Jetsóoke néérónáa neebe diityétsikye: —Meóómíñe méuubállé Jóááke íñe muhdú o úwááboobe méénúráítyúronéhjɨ́ o méénune ámuhtsi maájtyumɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Méúúbálleco hállúvátuméhjɨ́ hálluvájucóóne, úllétuméhjɨ́ úlléjucóóne, íjpi chájáávéneri chémeméhjɨ́ bóhɨɨ́ne, lléébótuméhjɨ́ tsúúca lléébone, dsɨ́jɨvémé tsiiñe bóhɨɨ́ne. Áhdure méúúbálleco ɨ́dáátsóméhjɨke pajtyéteju tsúúca úwáábómeíñe. Énehjɨ páneere méúúbálleco dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Maímijyu ihdyu oke cáhcujtsómé íjcyanej. ");
INSERT INTO boaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ehdúu iñééné boone diityétsi déjuvu neebe múúhakye diibye Jóáádityu: —¿Acáa Jóáá ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyáábedívú ámuha mepíhcyáávehíjcyácooca muhdú ámuha méɨjtsúcunú dííbyeke? ¿A ámuháa méɨjtsúcunú éhne múúne úmehe kííjyébari vááúmeídyú páhduváré dííbyé ɨ́jtsaméí nééneé? ");
INSERT INTO boaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿A tsané ímíyée úcámeíhíjcyaábe? Muuráhjáa tehdu iújcámeícyá tsá ihdícyátsihyi dibye íjcyáítyuróne. Muuráhjáa ávyéjujté jaaháñé pañéiyo diíbye. ¿Aanée muubá ɨ́mɨááné diíbye? ");
INSERT INTO boaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Mityá Píívyéébé ihjyú uubálle múnáajpíi diíbyej? Ɨ́mɨáánée diibyéjuco. Árónáacáa tsíjtyé ehnííñevu diíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dííbyedítyú muurá Píívyéébé waajácúháámɨtu nééneé: Ó pícyoó dɨ́ɨhde tsáápiikye dibye iúúbálle mɨ́amúnáake ditye iímíbáávyéne ímí uke iwáátsúcúpéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aane ɨ́mɨááné tsá dííbyedu tsijtye néétune. Árónáa níjkyéjɨri íjcyaabe Píívyéébé avyéjúejtédítyú ɨ́ɨdáátsoobe íjcyároobe avyéjúúlléméií diibye Jóáá ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diibyée muurá Jóáa úwáábótsihdyu íñe ícyoocávú teene Píívyéébé avyéjuvu iúcaavéné ímíllémema ténejcu ímílletúmé múhdurá ícyahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Muuráhjáa pámeere Píívyéébé ihjyú uubálle múnaa éíjyuúvú íjcyame téijyútújuco íhjyúvahíjcyáné dííbyé avyéjuri. Áhdurée Moitséeúvú ihjyúvahíjcyá téénetu. Áámé nihñéejpíyée muurá diibye Jóáa bóhówaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aane ámuha mecáhcújtsóhajchíí mécahcújtsó Jóáa Eríá íjcyane éhnée Píívyéébé ihjyú uubálle múnaa tsiiñe dibye bóhówááveíñé néhíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aane ihdyu óvíi ɨ́mɨááné lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ahdícyane ¿aca muutédívú íñe ámuuha íícyoocá múnáake ó meménúiyáhi? Íhya tsɨɨmedivuj. Muurá múúne lláhájtsɨri ɨ́ɨ́cume úhbácatsíhijcyádú ámuha páhduváré médárɨ́ɨ́vémeíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Muurá múúne íllu úhbácatsíhijcyáme: “Chiiyóró mellíjchúrónáa tsá ámuha meímílletú mewáhtsɨne tééneri. Áhdure máátyóba májtsí memájtsívárónáa tsá ámuha meímílletú mekímoovéne.” Ehdu múúne tsɨɨme úhbácatsíhijcyámé íjcyadu muurá ámuúha. ");
INSERT INTO boaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Muuráhjáa Jóáa tsá mítyane máchohíjcyatúne. Áhdurée tsá dibye ádohíjcyatú bíínojpácyo. Áánetúu dííbyedítyú ámuha ménehíjcyá mééííbye íjcyáábé pañe naavéné íjcyánéllii ehdu dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Áábé boonétúu ó bóhówaavé Mɨ́amúnáájpidívú o ípívyééveébe. Aabe panéváré o májchoobe téhdure ó adó bíínojpácyo. Áánetu idyé ílluréjuco óhdityu ámuha menéhijcyáné oova majchópíwu adópíwu o nééneé. Áhdure ámuha óhdityu ménehíjcyá oova ávyéjúúbé wáábyuta íjcyáne dsɨ́ɨ́dsɨ́ ahdótso múnaa ímityúmé íjcyámedívú o náhbévahíjcyáne. Árónáa tene pánéévénetúi méwaajácuú keená ɨ́mɨááné íjcyane. Ehdúu neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aabée tsáijyu ihjyúvá mítyane méénúráítyúronéhjɨ́ imyéénuhíjcyá coomíjɨ múnáadítyú ditye íimítyú ɨ́hvejtsópítyúnetu. ");
INSERT INTO boaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Neebépeé: —¡Máɨdáátsoju tsáma tene pájtyeíñé Coratsíii, Betsáidaa, íjcyácoomícyu múnáake! Muurá íñe méénúráítyúronéhjɨ́ o méénuhíjcyánée Tííroó, Tsidóoo, íjcyácoomícyuvu o méénuca tsúúca téijyúré técoomícyu múnaa íimítyú ɨɨ́hvéjtsóne ɨ́mɨánejcúvuréjuco ɨ́búwáávéiyóne. Aamée muurá íatérééjahjɨ́vú iújcámeíñe bállííjyuri ávúhcúiyá teene ɨɨ́hvéjtsóné uubálle. ");
INSERT INTO boaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Áánéllii muurá ditye ɨ́cúbáhrámeíñé ehnííñevu ɨ́cúbáhrámeíimye diitye Coratsíii, Betsáidaa, íjcyácoomícyú múnaa muhdú mɨ́amúnaa ícyahíjcyáné Píívyéébe nihñéétsihvúré diityémá ímíbájchócoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ahdu muurá téhdure Capenaóo múnáake pajtyéiñe eene múhdumé ‘mityáhmítyá’ tsíñáávehíjcyámeke. Ɨjtsúcunúméubá ɨɨ́htsútúúvéiyóne. Áánerá íllure wágóóóveímyé cúújúwá panévu. Muurá íñe méénúráítyuróné o méénuhíjcyánée Tsodóóma múnáama éíjyuúvú o méénuca íimítyú ɨɨ́hvéjtsóne ímíjpyetéiyóme. Aacáa muurá ícyoocápíi íjcyáíyocóómi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aane muurá diitye Capenaóo múnaa ávyétá ɨhnáhó ɨ́cúbáhráméií técoomí múnaápe ɨ́cúbáhrámeíñé ehnííñevu Píívyéébe muhdú mɨ́amúnaa ícyahíjcyáné ímibájchócoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Téijyúu Cááníma íllu íhjyúvaábe: —Ayúju Táácááni Píívyéébeéj, níjkyejɨɨ, ííñujɨɨ, íjcyane páné aabájaabéré u íjcyaábej, uke téhdújtsoobéré ó duurúvá ɨ́mɨáájú ɨdáátsojtédívúré u bóhówátsohíjcyáné hallúvu. Áánetu tehdújuco tsá waajácu múnaa iíjcyane ɨ́tsúcunúmeíhíjcyámedívú u bóhówájtsotú teéne. ");
INSERT INTO boaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ahdícyane ihdyu, Lli, óvíi ehdu teene muhdú u ímillédu. ");
INSERT INTO boaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ehdúu Cááníma iíhjyúvátsihdyu neébe: —Muuráhjáa ihdyu Llihíyó oke picyóó tajtyééveri mɨ́amúnáake iwáájácútso muhdú diityédítyú ɨɨ́jtsámeíñe. Tsá muurá múha wáájácutú dííbyé Hajchi o íjcyáábé ɨ́jtsaméi. Apáábyéré diibye Llihíyó waajácú muhdú o íjcyane. Áhdure idyé apáábyéré ó waajácú muhdú dibye íjcyane. Áhdure teene tsaatédívú o bóhówajtsóméré waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ahdícyane cáhawáá ookéréjuco méuráávyé ɨ́dátsó múhdurá ámuha meícyahíjcyánetu ámúhakye o állíjchútsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muurá íñe ɨ́dátsó tsaɨ́ɨ́buwáré o íjcyaabe ámúhakye o úwaabóné tsáma mewáájáne tehdu méíjcyaco. Áijyu ihdyu ɨ́ɨ́né imíjyaú ámuha méíjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tsáháturo tene ɨ́hnáhootú ehdu ámúhakye o nééne ámuha meúráávyéiyóne. Ehdúu neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Áábemáa muha wáyeéévejcóójɨ úmɨhéj pɨɨnétú mepájtyeme maájyabáávaténéllii bajtsóháñetu meújcúne mémajchóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aanée paritséómú ɨɨ́ɨ́téne néé dííbyeke: —¿Aca ɨ́veekí eene aatye dímamyémú meenú íjcyoojɨ wáyeéévejcóójɨ́ meméénúítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Árónáacáa Jetsóó néé diityéke: —¿Aca tsá ámuha meéévehíjcyatú tsáijyúu iájyabáávaténéllii íñahbéjtema téhdure Dabíiúvú méénune Píívyéébé waajácúháámɨtu cáátuváne? ");
INSERT INTO boaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Muuráhjáa duurúvájá pañévú iúcáávéne imájchóítyuróné Píívyéébé ɨɨcúvé pááa tééjá pañévú pícyámeíhijcyáné apáámyéré llúúvájte máchohíjcyánetu majchóme. ");
INSERT INTO boaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Áhdure ¿aca tsá ámuha meéévehíjcyatú Moitséeúvúu téhaamɨ́túré cáátunúné duurúvájá pañé wákimyéi múnaa llúúvájte wáyeéévéjcoojɨ́jɨ́ íjcyaróné wáyééévéítyuróne? Aane muurá ditye téjcoojɨ wáyééévetúné tsá ímityúné íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aanéjɨ́ɨ́ awáá muurá teene duurúvaja ávyejúúllémeíñé ehnííñevu táavyéju. ");
INSERT INTO boaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Muurá Píívyéébé waajácúháámɨtu nééneé: “Ó imíllé ámuha pamévamáyé meɨ́daatsólléjcatsíñe. Tsá o ímílletú apááñéré oke ámuha iyámeke mecóvájtsóneri meɨ́ɨ́cúvehíjcyáne.” Aane muurá ámuha ímí mewáájácuca tsá menéétsóítyuró ímityúné méénútúrómedívu. ");
INSERT INTO boaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Muurá íñe Mɨ́amúnáájpidívúu o ípívyéévéébéllii téhdure téjcoojɨ wáyeéévejcóójɨ. Ehdúu Jetsóó néé paritséómuke. ");
INSERT INTO boaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Átsihdyúu dííbyema muha méúcaavé téjcoojɨ pihcyáávéjá pañévu. ");
INSERT INTO boaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Áájá pañée tsaapi tsánejcúehójtsɨ́ íhyójtsɨ múhdurá néébeé. Áánáacáa tsaate tétsihyi íjcyame Jetsóodívú iñéétsóro néé dííbyeke: —¿A ímí tehdújuco teene íjcyoojɨ wáyeéévejcóójɨ́ tsaate chémémeke mebóhɨ́ɨ́tsóiyóne? ");
INSERT INTO boaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Áánélliihyée neebe diityéke: —¿Aca wáyeéévejcóójɨ́ ámúha jééú obééjá wáhyéjú pañévú áákityéébeke tsá ámuha meíjchívyétsóítyuróne? Muurá ámuha méijchívyétsóiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Aanéjɨ́ɨ́ awáá muurá diibye obééjá wájyúmeíñé ehnííñevu mɨ́amúnaa wajyúmeíhi! Aane muurá tsá muhdú tene néétu wáyeéévejcóójɨ́ ɨ́mɨááné íjcyane meméénune. ");
INSERT INTO boaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ehdúu diityéké iñétsihdyu neebe dííbyeke: —Muúbej, cána ííllevu cujúúvé díhyótsɨɨ́j. Ahdújucóo dibye cújúúvénemáyé téhojtsɨ ímíjpyeténe. ");
INSERT INTO boaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Átsihdyúu paritséómú ipyéénemáhjáa pítyácójcatsí muhdú Jetsóoke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aanée iwáájácúne péjúcoóbe. Áábekée mítyane mɨ́amúnaa úráávyémedítyú chéméméhjɨke bóhɨ́ɨ́tsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Áánemáa diityéké bóíjcyuube ditye muucá iúúbállétuki. ");
INSERT INTO boaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ehdúu diityéké bóíjcyuube Píívyéébé ihjyú uubálle múnáajpíhjyáa Itsaíá dííbyedítyú íllu néhdújuco: ");
INSERT INTO boaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Áánu ímí táwákimyéí méénuhíjcyaá téénevu o pícyoóbe. Áábeke o wájyúnéllii ó imíjyúú dííbyedi. Áánéllii Táapííchó dííbyé pañévú ó pícyoó tééné pɨáábori dibye pámeekéré mɨ́amúnáake iúúbálle muhdú táɨ́jtsaméí íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aabe tsá ‘mityáhmítyá’ íhjyúváityú mɨ́amúnáama. ");
INSERT INTO boaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Áhdure tsá ɨ́dáátsóméhjɨke dibye éhdɨɨválléityúne. Áhdure ɨ́htsútúnetu cahcújtsótú pañe cáhcújtsórómedítyú tsá dibye ‘óvíjyacóóme’ nééityúne. Ehdu páneere ímíjpyetétsóiibye iávyéjuutéijyu. ");
INSERT INTO boaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Áábedívú pamévá mɨ́amúnaáré cátsɨ́pááveéhi. Ehdúhjáa Píívyéébé ihjyú uubálle múnáajpi Itsaíá Jetsóodítyú nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Áábe éllevúu tsáápiikye tsivámé naavéné ípañe íjcyáábeke. Aabée íhjyúvátuube íjcyaabe idyé tsá hállúvatúne. Áábekée Jetsóó ímíjpyetétsoobe tsúúca ihjyúváhi. Áhdurée hállúvájúcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ááneríi tétsihyi íjcyame iúllévenúne néjcatsíhi: —¿Aca tsá diibyéjuco áánu Dabíiúvúj tsɨɨménémúhaabe Críjto íjcyatú éhneváa tsááiíbye? ");
INSERT INTO boaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ehdúu tsaate nééne paritséómú illéébóne néjcatsíhi: —Aadi muurá naavémuke waagóohíjcyá mɨ́amúnáá pañétú diitye naavémú avyéjuube Betsebóó pɨ́áábóneríye. ");
INSERT INTO boaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aanéhjáa Jetsóó iwáájácúne nééhií: —Muurá tsáné avyéjujte tsajɨ́jtóré ɨ́jtsámeítyúmé ímityúné idyárɨ́ɨ́véjcatsíñe ílluréjuco ɨ́hvejtsóné íavyéju. Áhdure tsája múnaa ímityúné idyárɨ́ɨ́véjcatsíñe ílluréjuco wáchájánújcatsíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ahdu nééne ¿aca muhdú ɨ́ɨ́vane Naavéné ihyájkíyé íjcyáábeke tsíjpiikye waagóóiyáhi? Muurá tehdu imyéénuca ílluréjuco dibye íavyéjú újóvéjtsóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aane muurá ámuha menéé Betsebóó pɨááboríyé dííbyeéjté naavémuke o wáágóohíjcyáne. Áánetúhaca ¿múúbé pɨááborí ámúhá mamyémú waagóohíjcyá diitye naavémuke? Áyu cána oke menej. Tsá muurá ámuha menééítyuró Betsebóó pɨáábori ditye wáágóohíjcyáne. Íllure ámuha mémujtá ehdu óhdityu meíhjyúváneri. ");
INSERT INTO boaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Muurá ihdyu Píívyéébé Apííchó oke pɨ́áábóneri ó waagóohíjcyá naavémuke tsaaté pañétú téénetu ámuha mewáájácúro tsúúca dííbyé avyéjú ííñújɨri ámúhama íjcyájucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tsá muurá tsáápi éhné dííbyé já pañétú múha tsájtyéítyuró dííbyeke tétsihdyu bóáyotúmére. Muurá ihdyu dííbyeke tujkénú ibóáyoca botsíi tsajtyéiyómé dííbye éhne. Árónáa tsáháubá muurá dibye ihñe múhdivú ɨ́hvéjtsóítyuróne. Ahdu ɨ́ɨ́vane tsá Naavéné oke pɨ́áábóítyuró dííbye hájkímuke o wáámíuki. ");
INSERT INTO boaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Muurá oke ɨpɨ́aabóné ímílletúmé táwákimyéí íllure imíllé óhdivu ityútávajtsóne. Aame tahñéjté íjcyáíyómeke íllure óhdityu mútátsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Muurá panéváré ímityúné mɨ́amúnaa méénuhíjcyáronéhjɨ́ Píívyéébe ábájɨ́ɨ́veé diityédí ɨɨ́dáátsóvénema. Áhdure íñe Mɨ́amúnáájpidívúu o ípívyéévéébedítyú ímityúné íhjyúvárómedi ɨ́dáátsóvéiíbye. Áánetu ihdyu dííbyé Apííchotu ímityúné íhjyúvahíjcyámedi tsá dibye múijyú ɨ́dáátsóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Muurá bajtsóháñetu ɨ́mɨááhé ímí neeváhi. Áánetu átéréehe tsá ímí néévatúne. Áánetúré méwaajácú keehé ɨ́mɨááhé íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ahdu ɨ́ɨ́vane ¿ɨ́mɨáámejɨ́ɨ́va ámuha ímí méihjyúváiyá ííñimyémúeméjtéré ámuha meíjcyame? Muurá ímityúné ɨ́ɨ́ɨ́búwá pañe íjcyámedítyú téénere ijchívyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muurá ɨ́mɨáábé ɨ́mɨáánéré ihjyúvá ɨ́mɨá ɨ́jtsaméí ípañe íjcyanéjuco. Áánetu ímítyuube ímityúnéré ihjyúvá ímítyúné ɨ́jtsaméí ípañe íjcyanéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aane muurá pámeere mɨ́amúnaa úúbálleé Píívyéébeke muhdú iíhjyúvahíjcyanéhjɨ́ dibye páneere muhdú ditye ícyahíjcyáné diityémá ímíbájchócoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Muurá tsáápiitsámá ímíbájchóiibye muhdú ditye íhjyúvahíjcyádújuco. Ɨ́mɨáánéré íhjyúvahíjcyámé hallúrí tsá ɨɨná íjcyáityúne. Áánetu ímityúné íhjyúvahíjcyámé ɨ́cúbáhráméiíhi. Ehdúu Jetsóó néé paritséómuke. ");
INSERT INTO boaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aamée tsiiñe taúhbájú uwáábojtémá Jetsóo éllevu itsááne néé dííbyeke: —Uwááboóbej, cána bo méénúráítyuróné meenu muha maájtyúmɨ́ne menéé ɨ́mɨááné diibyéjuco Críjto Pájtyetétsoobe u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Áánélliihyée neébe: —¿Ɨ́veekí ámuha méimíllé teene o méénune ámuha mecáhcújtsokíjɨ́ɨ́vari? Óvíi ihdyu Píívyéébé ihjyú uubálle múnáajpíi Jonáake pájtyedu nééne oke pájtyénetu ámuha méwaajácú diibyéjuco mɨ́amúnáake o pájtyetétsoobe o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Muuráhjáa amóóbé pañe téhí déjúcori ijcyaabe 3 coojɨ́va. Ahdu muurá íñe Mɨ́amúnáájpidívúu o ípívyéévéébeke ditye cúúuube ííñújɨ́ pañe 3 coojɨ́vá o íjcyátsihdyu tsiiñe ó bóhɨɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aane muurá Níínibé cóómi múnaa ámúhadívú néétsoó íñe ícyooca íjcyáné mɨ́amúnaa ámuha mecáhcútsohíjcyátúmedívú Píívyéébe mɨ́amúnaa muhdú ícyahíjcyáné ímíbájchócoóca. Muuráhjáa técoomí múnaa diibye Jonáaúvú úwaabóné icyáhcújtsóne ímíbaavyé ímityúné iícyahíjcyánetu. Áánáa dííbyeúvú ehnííñevu o íjcyaabe ámúhakye o úwááboróné ¿ɨ́veekí tsá ámuha oke mecáhcútsohíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Áhdure tsáápille tsííñé iiñújɨ múnáalle ámúhadívú néétsoóhi. Muuráhjáa tsíhyullétú tsaalle Tsaromóó úwaabóné illééboki. Aallée muurá ímí cáhcujtsóhi. Áánáa dííbyeúvú ehnííñevu o íjcyaabe o úwaabóné ¿ɨ́veekí tsá ámuha mecáhcútsohíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Muurá naavéné tsaaté pañétú íjchívyeebe pehíjcyá iíjcyáitsíí néhcoobére. Aabe iíjcyáíyotsíí iájtyúmɨ́túnéllii íllu ɨ́jtsámeíhi: “Tsiiñe éhne bɨwáábé pañévúré ó óómií ópée o íjchívyéébé pañévu.” ");
INSERT INTO boaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ahdújuco muurá óómiibye ájtyumɨ́váné diibye ípyée iíjchívyéébeke imíwu pevéébé éhne múu jaa llíjyahdu néébeke. ");
INSERT INTO boaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Áánéllii múúne nahbévaabe tsijtye 7-meváké éhnííñevu ímítyúmeke diityémá tsiiñe iúcááve dííbyé pañévu. Áábeke muurá ɨ́hdée ɨɨ́cúbáhráné ehnííñevu ɨ́cúbáhraábe. Ehdu muurá ímityúmé íjcyame ɨ́dátsó ɨ́cúbáhráméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ehdúu Jetsóó íhjyúvánáa íñahbémú tsɨ́ɨ́juma dííbye éllevu tsááme wajtsɨ́ tétsihvu áachívu. Aamée imíllé iíhjyuváné dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aanée tsaate úúballé dííbyeke. Néémépeé: —Áátye éhtsíhyi áachi díñahbémú dɨ́ɨ́tsɨ́ɨ́juma íjcyamévá imíllé úúma iíhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Árónáacáa neebe diityéke: —¿Aca caatyé táátsɨ́ɨ́juú, táñahbémuu, táñaallémuu, íjcyame? ");
INSERT INTO boaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ehdúu iñétsihdyu múúhakye úúbácyunúúbéré nééhií: —Áánerá téhdure ámuha pámeere wahárómú, táñahbémú, táñaallémú, méijcyá íñe múhdumé tahñéjté ámuha meíjcyame. ");
INSERT INTO boaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muurá Llihíyó níjkyéjɨri íjcyáábeke cáhcujtsómé dibye ímillédú íjcyame ɨ́mɨááné tahñéjté táñahbémú, táñaallémú, wahárómu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ehdúu Jetsóó diityéké nétsihdyu muha dííbyema meíjcyájatu mepéé únéú úniúvu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Átsihyíi muha meíjcyánáa idyé mítyane mɨ́amúnaa píhcyaavéjucóó dííbyedívu. Aamée téhíwájú hallúrí íjcyánáa mɨ́ɨ́né pañévú úcááveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aabée téémɨ́ pañétú diityéké mítyane panévatu iúwaabóné úúbállehíjcyá tsíeménéhjɨtu. Téijyúu tsaapi bájtsónetu úwááboobe íllu úúballéhi: —Tsaapíhjyáa íwajcyóhá tríígoúúhá bájtsoobe íllure wávárajcóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aanéhjáa dibye wávárájcónetu tsáuhjɨ juuváj pɨɨnévú dójcone coomɨ́mú méhdojéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ááné tsiúhjɨ́hjáa néwayúúné raahóvú dójcoúhjɨ́ ɨ́ɨ́cúíwuúré iiñé tétsii iiñu imíchi íjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Áróhiibájɨ́hjáa chemé núhbá allóócori hállúháñeríyé tébajkyéjɨ́ íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ááné tsiúhjɨ́hjáa tsuhjɨ íjcyátsihvu dójcóné hallúvú tene wááménéneri ííñeróné duhcúvatéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Áánetúhjáa ihdyu tsáuhjɨ dojcó imíwu ííñujɨ nétsihvu. Aanéhjáa imíwu píívyénetu tsáhiibájɨ́ neevá mítyane. Ááné tsihííbájɨ́hjáa llííñevúré neeváhi. Ááné lliiñévuréjucóhjáa tsíhiibájɨ́ néévane. ");
INSERT INTO boaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aane ihdyu óvíi lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ehdúu dibye néénéllii muha dííbyeke menééhií: —¿Aca ɨ́veekí tsíeménetu ú úúbállehíjcyá u úwaabóne? ");
INSERT INTO boaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Áánélliihyée múúhakye neébe: —Muurá ihdyu ehdu ó úwáábohíjcyá Píívyéébe ámúhakye iwáájácútso muhdú íavyéjú íjcyanévu. Áánetu oke cáhcújtsótúmeke tsá dibye wáájácútsotú téénevu eene ámúhakye iwáájácutsódu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Muurá ɨ́mɨáájú imíllémedívú bóhówájtsóiibye éhnííñevu ditye iwáájácuki. Áánetu teene ímíllétúmedívú tsá dibye bóhówájcaáyóityúne. Tsáijyu múu áyánéwu ditye wáájácuróné muurá íllure dojtúcúiibye diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ehdu néénéllii muurá o úwaabóné tsíeménéhjɨtu ó úúbállehíjcyáhi. Muurá o úwaabóné lléébójúcoorómé ícyahíjcyá lléébótúmeúvúdu. Áhdure teene ájtyúmɨ́júcoorómé ícyahíjcyá ájtyúmɨ́túmeúvúdu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ehdu ícyahíjcyámé Píívyéébé ihjyú uubálle múnáajpíi Itsaíá íllu néhdújuco: Uwáábó lléébójúcoorómé tsá cáhcújtsóityúne. Áhdure iájtyumɨ́júcooróné tsá ditye wáájácúityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dityé ɨ́jtsaméí ímí néétúnéllii tsá ditye ímíñeúvú lléébohíjcyatúne. Aame ícyahíjcyá wáájácúmeítyúmé éhne múúne hállúvatúmé íjcyadu. Aaméjɨ́ɨ́va tehdu óhdi íjyácunúmekéjɨ́ɨ́ ó ímíjpyetétsóiyáhi. Ehdúu neebe Itsaía. ");
INSERT INTO boaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Áánetu ihdyu ímí ámuha melléébónéllii tsúúca méwaajácú ɨɨná tene nééiyóne. Áhdure muurá ámuha maájtyumɨ́né tsúúca méwaajácú ɨɨná íjcyane. Áánéllii ihdyu méimíjyúú tééneri. ");
INSERT INTO boaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Muuráhjáa éíjyuúvú íjcyame Píívyéébé ihjyú uubálle múnáama tsijtye Píívyéébeke úráávyehíjcyámé imíllehíjcyará iájtyumɨ́né íñe ícyooca tsúúca ámuha maájtyumɨ́ne. Árónáacáa tsá téijyu diityédívú tene ajtyúmɨ́dú néétune. Áhdurée imíllehíjcyarómé illéébone íñe ícyooca ámúhakye o úwáábohíjcyáné uwááboju. Árónáacáa tsáhái téijyu tene bóhówáávetúne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Cáhawáá ímíñeúvú meɨ́jtsó bajtsó múnáájpidítyú íjcyáné uwááboju ɨɨná nééiyóné o bóhówajtsóne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Muurá níjkyéjɨri íjcyaabe Píívyéébé avyéjutu íjcyáné uwááboju tsaate lléébójúcooróné Naavéné diityédívú mútátsohíjcyáhi. Aane nééiyóné eene juuváj pɨɨnévúhjáa dójcoúhjɨ́ coomɨ́mú méhdojéne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Áánetu teene illéébone tsúúca ímí úraavyéjúcoorómé páhduváré nééné mávaríjchojúúné íjcyanéhjɨ́ iáábucújúcóótúnetu ílluréjuco teene ɨ́hvejtsóne. Aane nééiyóné eene néwayúúnéhjáa íjcyátsihvu dójcoúhjɨ́ imíwu ííñeróné núhbá allóócori chémene. Ehdu muurá patyéhijcyáné ímí cáhcújtsótúmema. ");
INSERT INTO boaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Áánetu tsaate tsúúca ímí tééné uwááboju llééborómé mítyane ɨ́jɨ́ avyéjuríyé itsúúrámeíñéllii ténejcu ábájɨ́ɨ́vehíjcyáhi. Aane nééiyóné eene tsuhjɨ́ pañévúhjáa dójcoúhjɨ́ ííñeróné íllure dúhcúvaténe. ");
INSERT INTO boaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Áánetu ihdyu ijcyámé tsaate teene illéébone cáhcujtsómé ímí tehdújuco úráávyehíjcyáme. Aame muurá eene imíwuúhjáa ííñujɨ nétsihvu dójcoúhjɨ́ ííñedu. Áámedítyú ijcyámé tsaate éhnííñevu ímí Píívyéébeke úráávyehíjcyámé eenéhjáa teene tríígóhiibáné imíwu píívyene mítyane néévadu néémeé. Áánetu ijcyámé tsaate ɨhtsútáwu ímí Píívyéébeke úráávyehíjcyámé eenéhjáa llííñevúré nééváhiibájɨ́dú néémeé. Áámedítyúi muurá ijcyámé tsaate diityé llííñevúréjuco úraavyémé eenéhjáa máɨhtsúnéré nééváhiibájɨ́dú néémeé. Ehdúu Jetsóó bóhówajtsó bajtsó múnáájpidítyú íjcyáné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Téhdurée tsiiñe úwááboobe tsaapi íúmɨhe bájtsónetu. Neebépeé: —Muurá Píívyéébé avyéjú tsaapíhjyáa íúmɨhe bájtsojédu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dibyéhjáa ibájtsójéne óómíñe déjuvu tsaapi dííbyeke múnáátsohíjcyaabe bájtsojé bɨɨva tríígo dibye bájtsóné raahóri. ");
INSERT INTO boaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aanéhjáa keemévé teene ɨ́mɨááné ikyéémévéne nééváné tujkéveríye. ");
INSERT INTO boaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aanéhjáa diibye tépallí aabájáábé úníu múnaa iúújéjéne néé dííbyeke: —Ávyéjuúbej, ááneráhjáa ɨ́mɨáánéré méúmɨhe mebájtsónáa ¿kiátú íjcyane bɨɨva iiñé tééné raahóri? ");
INSERT INTO boaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Áánélliihyéhjáa neébe: —Tsaapíubá oke múnáátsohíjcyaabe ehdu meenúhi. Áánélliihyéhjáa nééme dííbyeke: —Cána muha mewáámíuki. ¿Mityá óvíi ijcyánej? ");
INSERT INTO boaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ehdúhjáa ditye néénéllii neébe: —Tsáhaá. Muurá ámuha teene metábáhcyóhajchíí bajtsóháñé ámuha métútávájtsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Áánéllii ihdyu óvíjyucói meɨ́hvéjtsoíñé tsanéécú ikyééméveki. Tsanééréi teene ɨ́mɨááne néévá maááhɨ́vétsócooca ámúhakye ó neé ámuha metábahcyóné pájtsuuhójɨ́ mechíjchu mecóvájtsoki. Áánetu ihdyu ɨ́mɨááné maááhɨ́vétsóne ímíñeúvú mépícyoóhi. Ehdúu Jetsóó úwaabó tsaapi íúmɨhe bájtsónetu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Áhdurée tsiiñe úwááboobe ‘mojtáátsa’ némeíñé uméhetu. Neebépeé: —Téhdure idyé muurá Píívyéébé avyéjú éhne múúne ‘mojtáátsa’ némeíñé neeváúwu tsaapi bájtsone ɨ́ɨ́né imíjyaú ávyétá mityáhé kéémevédu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Muurá panévá neváúúné lliiñévúré íjcyáróúwúutu ííñehe keemévé panévá bajtsóhééné ehnííñevu bájú uméhedúhe. Ááhé pañévú muurá wahpéjté ijcyóváhi. Ehdúu Jetsóó úwaabó mojtáátsáhetu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Téhdurée pááá ooríchotu úwááboobe nééhií: —Muurá tsáápille haríínállíjyutu pááa imyéénúcooca áyánéwu tééné ooríchotu pícyooróné páneeréjuco óórichódú idyé teene Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ehdúu Jetsóó tsíeménéhjɨtu iúúbállénej tééveri úwáábohíjcyá mɨ́amúnáake ímíñeúvú iwáájácútso ɨɨná íuwááboju nééiyóne. Tsáháa dibye pevénéré úwáábohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ehdúu úwáábohíjcyaabe Píívyéébé ihjyú uubálle múnáajpíhjyáa íllu néhdújuco: Muurá tsíeménéhjɨtu o úúbállénej tééveri ó waajácútsoó táuwááboju ɨɨná nééiyóne. Muurá ó bóhówájtsoó íñée ííñújɨma páneere Píívyéébe ípívyéjtsóijyújuco íjcyáronéhjɨ́ múha wáájácútunéhjɨ. Ehdúhjáa Píívyéébé ihjyú uubálle múnáajpi néhdújuco Jetsóó úwáábohíjcyáné tsíeménéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Átsihdyúu ílluréjuco mɨ́amúnáake ipítyájcóne dibye ááhɨvu pééneé. Áhullévúu muha dííbyeke menééhií: —Áyu cána múúhadívú bóhowájtsó úmɨhé pañe bɨɨva íjcyánetu íjcyáné uwááboju ɨɨná nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Áánélliihyée múúhakye neébe: —Eene ɨ́mɨá bájtsó bájtsoobe muurá oo Mɨ́amúnáájpidívúu o ípívyééveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Áánetu teene úmɨhe ‘páneere ííñújɨri mɨ́amúnaa íjcyane’ nééiyóne. Muurá eene ɨ́mɨá bájtsó Píívyéébé avyéjúejte íjcyane nééiyóne. Áánetu bɨɨva ‘Naavéné icyánéjcuríyé íjcyáné mɨ́amúnaa íjcyane’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Áánetu eene tépallí múnáájpikye imúnáájtsóne bɨɨva bájtsoobe muurá páñetu diibye Naavéne. Áánetu ‘íñe ííñújɨma páneere ílluréjuco nɨ́jkévaíñé’ nééiyóné eene bajtsóháñé ááhɨ́vétsómeíñe. Áánetu diitye eene bajtsóháñé ááhɨ́vetsómé ‘níjkyéjɨ múnaa íjcyane’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Muurá éhne múúne úmɨhé pañe bɨɨva mepíhñune mecóvajtsódú pajtyéiñe diitye Naavéné icyánéjcúejtéma. Aame wágóóóveé cúújúwá pañévú íñe ííñújɨri múhdurá mɨ́amúnaa ícyahíjcyáné diityémá nɨ́jkévácoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Muurá Mɨ́amúnáájpidívúu o ípívyééveebe ó táúhbaá tahñéjté níjkyéjɨ múnáake ditye íhdyúétsihvu ipíhjyúcu diitye ímítyúmeke táavyéjúejtéké ímítyúnejcúvú ɨ́búwátsohíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Áameke cúújúwá pañévú ditye wájojcómé tééwá pañe íjcyame íhwáñeene ɨɨ́hdóne taá ɨɨ́cúbáhrámeíñeri. ");
INSERT INTO boaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Áánetu ihdyu Píívyéébe ímillédú ícyahíjcyámé dííbyé avyéjú pañe íjcyame cádiúcúnuú éhne múúne nuhba cóójɨ́ejpi ájchúcunúdu. Aane ihdyu óvíi ámúhadítyú lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Téhdure idyé Píívyéébé avyéjú ílluú: —Tsaapíi tsátsii ííñújɨ́ pañe ávyétá mityáné wájyúmeíñé tsíeméné iájtyumɨ́né tétsihvúré ɨ́hvéjtsoíñúhi. Ááneríi iímíjyúúvéne páneere ítsíeméné iñáhjɨ́hénúne dsɨ́ɨ́dsɨma tétsii ííñujɨ áhdoobe iiyéjuco téénema iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Téhdure muurá Píívyéébé avyéjú éhne múúne tsaapi náhjɨ́he múnáajpi imíwu nééné newáyúúné mítyane áhdótsámeíúhjɨ́ néhcohíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aabe muurá tsau iájtyúmɨ́cooca páneere ítsíeméné iñáhjɨ́hénúne dsɨ́ɨ́dsɨma teeu ahdóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Téhdure Píívyéébé avyéjú éhne múúne tsɨ́ɨ́núúri amómeke meújcudu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Muurá múúne tsɨ́nú múnaa ɨtsɨ́núúmeke técoohóríyé téhí úniúvú itsájtyéne pihcyú ɨ́mɨá amómeke. Áánetu doorátujtéké ílluréjuco ditye wámiúúne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ehdu muurá pajtyéiñe mɨ́amúnáama Píívyéébe páneere ííñujɨ nɨ́jkévátsócoóca. Muurá níjkyéjɨ múnaa dówajcároó ɨ́mɨáámedítyú ímítyúmeke. ");
INSERT INTO boaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Áámeke cúújúwá pañévú ditye wájojcómé tééwá pañe íjcyame íhwáñeene ɨɨ́hdóne taá ɨɨ́cúbáhrámeíñeri. ");
INSERT INTO boaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ehdúu Jetsóó iúwáábóné nɨ́jcáutu néé múúhakye: —¿A ícyooca ámuha mélleebójucóó ɨɨná nééiyóné o úwáábohíjcyáne? Áánélliihyée muha menéé: —Éée Ávyéjuúbej, ímí muha mélleebó ícyooca ɨɨná tene nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Áánélliihyée neebe múúhakye: —Muuráhjáa tujkénúene Píívyéébé taúhbaju úwáábohíjcyámema ícyooca tsúúca ijcyáné míñéécu uwáábó ɨ́hdéénema béhne Píívyéébé avyéjutu íjcyane. Aane muurá teene ɨ́hdéene Píívyéébé waajácúháámɨ́ pañe ijcyáhi. Áánetu íñe béhne ámúhadívú ó bóhówátsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ehdúu Jetsóó tsíeménéhjɨtu iúúbállénej tééveri iúwaabóné nɨ́jkevádú muha mepéé tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aamée muha méúújeté Natsaréevu dibyée píívyécoomívu. Áijyúu idyé úwaabójúcoobe tétsíi múnáake pihcyáávéjá pañévu. Áábedíi iúllévenúne néjcatsímye: —¿Aca kiátú aabye iújcúné waajácuri panéváré méénúráítyúronéhjɨ́ méénuhíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Aca tsá éhne aabye úméhewááné wákimyéi múnáájpí hajchi íjcyatúne? ¿Aca tsá éhne tsɨɨju Maaríá íjcyatúne? Muurá dííbyé nahbémú Jacóóboo, Jotséee, Tsimóoo, Jóódaá, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Áhdure muurá íñaallémú íchihyi. Aabéjɨ́ɨ́ muhdú ¿kiátú waajácú ehdu nénehjɨ múu méénune? ");
INSERT INTO boaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ehdúhjáa dííbyedítyú iñééne tsá ditye cáhcútsohíjcyatú dibye diityéké úwáábohíjcyaróne. Áámekée neébe: —Tsijtye muurá ihdyu avyéjuullé Píívyéébé ihjyú uubálle múnáájpiíkye. Áánetu ihyájkímú íjcyarómé tsá ávyejúúlletú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ehdúu dííbyeke ditye cáhcútsohíjcyátúnéllii tsá éhnííñevu dibye méénújúcootú méénúráítyúronéhjɨ́ tétsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aanéhjáa dííbyedítyú tsaate úúballé Gariréá iiñújɨ́ avyéjuube Heróódeke. ");
INSERT INTO boaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Áánélliihyéhjáa neebe íúníu múnáake: —Tsáijyu múúne tsojtsó múnáajpi Jóáa tsiiñe bohɨ́ɨ́hií. Téénéllii muurá eene piivyéteebe méénúráítyúronéhjɨ́ imyéénune. ");
INSERT INTO boaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Diibyée muurá Heróódé nééjuri dsɨ́jɨ́vetsómé Jóáákeé. Muuráhjáa dííbyedívú iékéévétsóne úwááñéhiyi ichíjchútsóóbedívú cuvéhoojánútsoóbe. Ehdúhjáa méénuube íñahbe Perípé taaba Herodíá dííbyemáyéjuco íjcyalle nééjuri. ");
INSERT INTO boaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Diibyéhjáa Heróódeke íllu nehíjcyaabe Jóáa íñáhbé táábama dibye íjcyánetu: —Tsá muurá tene ímityú díñáhbé táábake u táábaváne. ");
INSERT INTO boaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ehdúhjáa dibye néhíjcyáné hallútú imílléroobe téijyúréjuco ɨdsɨ́jɨ́vetsóné dííbyeke. Árónáacáhjáa nuhnéveebe Píívyéébé ihjyú uubálle múnáajpi dibye íjcyane iwáájácúne mɨ́amúnaa dííbyeke ávyejúúllehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Áijyúhjáa ɨ́tsɨɨmávajcóójɨ́ úújeténéllii diibye Heróódé wáñehjɨ́vatéhi. Ááné pañéhjáa ɨ́dsɨ́dúelle Herodíá ajyúwá wahtsɨ́ pámeere úúbámyé úmɨwávu. Aanéhjáa dííbyeke ávyéta ímí pájtyéneri ímíjyúúveebe mítyane. ");
INSERT INTO boaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Áánélliihyéhjáa díílleke neebe ɨɨná dille dííbyeke táúmeíñevu iájcuíñé ɨ́mɨááné állítyuubére. ");
INSERT INTO boaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Áánélliihyéhjáa tsɨɨju úwaabódújuco dille nééne dííbyeke: —Ó imíllé oke u ájcune tsojtsó múnáajpi Jóáá níívaúvú bohtájɨri. ");
INSERT INTO boaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ehdúhjáa dille nééne kímóhcó dííbyeke pajtyéráhi. Árónáacáhjáa iállíityúné dibye nééne pámeere dííbyé uubámyé lléébójúcóónéllii tehdu méénuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aabéhjáa tsúúca tsaatéké wallóó diibye Jóáa cúvéhóójari íjcyáábeke ditye ikípíyuúcuté íhñíwau. ");
INSERT INTO boaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ahdújucóhjáa pééme ikípíyuúcújeu tsívane bohtájɨri. Ááuvúhjáa ajcúmé diille bádsɨ́jcájake. Ááuvúhjáa ájculle tsɨ́ɨ́juke. ");
INSERT INTO boaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Áánélliihyéhjáa dííbyeúvú mamyémú tsááme dííbyeúvú ɨɨtémeho iújcújéne cuuúhi. Átsihdyúhjáa Jetsóo éllevu ipyééne úúballémé ehdu Jóááke tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Átsihdyúu muha mepéé mɨ́ɨ́neri tsíhyullévú múha íjcyátúhullévú múúhaye meíjcyároki. Árónáacáhjáa tsúúca mɨ́amúnaa waajácújucóó kiávú muha mepééneé. Áhullévújucóhjáa ditye péécunúné íjchityu pacóómivá múnaáre. ");
INSERT INTO boaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aanée téhullévú muha meúújeténáa mɨ́ɨ́né pañétú Jetsóó íjchívyeebe ɨɨtécunú tétsihyíjyuco mɨ́amúnáácóbaúvú íjcyane. Áámedíi ɨɨ́dáátsóvéne bóhɨ́ɨ́tsoobe chéméméhjɨkéhjáa ditye tsájtyémeke. ");
INSERT INTO boaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Áijyúu tsúúca cúvéhréjuco tene néénéllii muha menéé dííbyeke: —Tsúúca cúvéhréjuco teene múubárá íjcyátútsihyi meíjcyánáaáca. Ílluréjuco wallo íjtyéke íchííj pɨɨhɨ́rí íjcyájáhjɨ múnáadítyú tsíeméné iújcune ditye imájchoki. Muurá tsá imájchoma ditye íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Áánélliihyée neebe múúhakye: —Ɨ́véémekéami ó wálloóij. Ámuháyé bo mémajchótsoj. ");
INSERT INTO boaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Áánélliihyée muha menéé dííbyeke: —Árónáa méhdi tsáhojtsɨ́hováré páahóónema míítyétsiye amóóbemútsi. ");
INSERT INTO boaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Áánélliihyée neebe múúhakye: —Áyu cána metsívaj. ");
INSERT INTO boaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ehdúu múúhakye iñééne diityéké neebe ditye iáhcúbaki. Átsihdyúu teene páahóóné amóóbemútsima iékéévéne téhdújtsoobe Píívyéébeke cáámevu icyárúúvénema. Áánemáa teene idyóhdáhɨ́nunévú múúhakye dibye ájcune muha méwajtú pámeekére. ");
INSERT INTO boaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aanée muha memájchónetu pámeere méoovéhi. Áánetúu coéváné 12-rujtsívá úvérujtsíñe wáhpe. ");
INSERT INTO boaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aamée eene diityémá muha memájchome wajpíímúré 5,000-meváubáhjáa walléémuháñema tsɨɨme éévémeítyúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ááné boonétúu Jetsóó múúhakye néé muha dííbyé ɨhde mɨ́ɨ́neri mepájtye tsíñejcúeúvú dibyéi mɨ́amúnáake pítyájcóné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aabéhjáa diityéké ipítyájcótsihdyu péé iiye múha íjcyátúhullévú cáméhbaúvú Píívyéébema iíhjyúvaki. Aabéhjáa ííjyunú téhullévu. ");
INSERT INTO boaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Áánáacáa muha tsúúca pɨ́ɨ́nééuríjyuco meíjcyánáa ávyétá ɨhnáhó kííjyébama nohjɨ múúhakye wájojcóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aaméikyée muha mepéépíñáa cóójɨ́ pañévú diibyéhjáa Jetsóó tsájucóó múúhá tujkévetu nújpácyó hallúrí úlleebére. ");
INSERT INTO boaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Áábekée muha maájtyúmɨ́ne meíllityéne menéjcatsíhi: —¡Áyúúj, naavénécobáubá bo eene aabye tsáá métujkévetuj! ");
INSERT INTO boaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Árónáacáa neebe múúhakye: —¡Méíllityédíñe, oóre! ");
INSERT INTO boaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Áánélliihyée Péédoro néé dííbyeke: —Ávyéjuúbej, áyu cána ɨ́mɨááné diibyéjuco u íjcyáhajchíí o péé diéllevu ehdu nújpácyó hallúri. ");
INSERT INTO boaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Áánélliihyée neébe: —Cáhawáá dichaj. Ahdújucóo Péédoro mɨ́ɨ́netu níítyeíñúné nújpácyó hallúrí úlleebéré dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Árónáacáa kííjyeba ávyétá ɨhnáhó nééneri iíllityéne ílluréjuco dibye búuuvéne. Aabée dííbyedi wáníjcyámeííbyé nééhií: —¡Ávyéjuúbej, oke ihdyu pájtyetétso! ");
INSERT INTO boaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Áánélliihyée íhyójtsɨtu iékéévéébeke neébe: —¿Aca ɨ́veekí tsá oke ímí u cáhcújtsotúne? ");
INSERT INTO boaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aamútsíi mɨ́ɨ́né pañévú úcáávénáa tsúúca kííjyeba ɨ́hvetéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Áijyúu pámeere téémɨ́ pañe muha meíjcyame Jetsóó lliiñévú memɨ́hmóúbáne menééhií: —Ɨ́mɨáánéjucóha ihdyu Píívyéébé Hajchi uú. ");
INSERT INTO boaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ehdúu muha úneu mepájtyeme méúújeté Genetsaréé iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aanée tétsíi múnaa Jetsóoke iwáájácúne úúballé pahúlleváré tééné iiñújɨ múnáake. Aamée tsívahíjcyá chéméméhjɨke dibye ibóhɨ́ɨ́tsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aamée dííbyeke néé íwajyámúubávúré dibye idyómájcótso ibóhɨɨ́ki. Ahdújucóo ɨ́mɨááné dííbyeke íwajyámutu dómajcóméjuco bóhɨhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Áhdurée tsáijyu Jerotsaréetu paritséómuma taúhbájú uwáábojte Jetsóo éllevu itsááne néé dííbyeke: —¿Aca ɨ́veekí dímamyémú tsá méénuhíjcyatú méɨhdé múnáaúvúu úwáábohíjcyádu? ");
INSERT INTO boaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Tsá muurá ditye nítyámeíhíjcyatú imájchóíñé ɨhde Píívyéébé úmɨwávú múúne meímíbájchómeíñé meméénune. ");
INSERT INTO boaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Áánélliihyée neebe diityéke: —Árónáa muurá téhdure Píívyéébé taúhbaju nééne tsá ámuha melléébohíjcyatú ámuháyé meípívyéjtsóné uwááboju ámuha meúráávyehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Muurá dííbyé taúhbaju nééhií: “Ámúháj caanímuke múu iwájyúne avyéjuulléhi. Áánetu íllure cáánímuke tútávátsohíjcyámé ihdyu óvi dsɨ́jɨvéhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ehdu muurá tene néérónáa ámuha tsíñejcúvúré méúwáábohíjcyáhi. Muurá ámuha ménehíjcyá tsaapívá cáánímútsikye ɨpɨ́aabóné iímíllétúhajchíí nééiyóne: “Tsá o píívyetétú ámúhtsikye o pɨ́aabóne. Muurá ámúhtsikye o pɨ́áábóiyódú ɨ́ɨ́vane Píívyéébekéréjuco o ɨ́ɨ́cuvéne.” ");
INSERT INTO boaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aanévá ehdu íhjyúváróóbé hallúrí tsá ɨɨná íjcyatú diityétsikye dibye pɨ́áábótúrónáaáca. Ehdu muurá ámuha méúwáábohíjcyáhi. Aame muurá ámuha Píívyéébé taúhbaju íllure méwaagóohíjcyá ámuháyé meípívyéjtsóné uwááboju ámuha meúráávyehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɨ́mɨáámeúvúdú ámuha méícyahíjcyá bañú múnaa ámuha meíjcyame. Muuráhjáa ɨ́mɨáánéjuco Píívyéébé ihjyú uubálle múnáajpi Itsaíá ámúhadítyú nééneé: ");
INSERT INTO boaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Íjtye oke ávyéjútsohíjcyará hállúéjuríye. Tsá ávyeta ɨ́ɨ́ɨ́búuri oke ditye ávyéjútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Íllure iállíñe oke duurúvahíjcyáme. Aame iiye iípívyéjtsóné uwáábojúúné úráávyehíjcyá pánehjɨ́dú tátyaúhbajúúné iúráávyeúvúdu. ");
INSERT INTO boaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ehdúu iñétsihdyu Jetsóó tsiiñe pámeere tétsii íjcyámeke nééhií: —Ímíñeúvú mélleebúcunúcó ɨɨná nééiyóné ámúhakye o nééiñe ámuha mewáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Muurá panéváré mɨ́amúnaa óóvene tsá diityéké tútávájtsotúne. Muurá ihdyu diityé ɨ́ɨ́búwá déjúcotúré ímítyúné ɨ́jtsaméí tsááne diityéké tútávajtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ehdúu dibye néénéllii muha dííbyeke menééhií: —¿Aca ú waajácurá eene ehdu u nééne aatye paritséómuke ávyéta tsáríyé pájtyene? ");
INSERT INTO boaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Áánélliihyée neebe múúhakye: —Muurá múúne úmɨhé pañétú mépée mebájtsótúné uméhé ííñehe metábahjyúcúne méwaagóóhi. Ehdu muurá níjkyéjɨri íjcyaabe Llihíyó avyéjúejte íjcyatúmé ímítyú ícyahíjcyámé wágóóóveéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Áeméjté íjcyámedi tsá meɨ́ɨ́cúvéítyuróne. Muurá éhne múúne hállúvatúmé íjcyadu tsá ditye wáájácúmeítyúne. Muurá tsahdúré hállúvatúmé íjcyame tsátyéjcatsíyómé tsaméhjɨ́juco áákityéiyóné wáhyéju dɨ́ɨ́váné pañévu. Ahdu muurá diítye. Ehdúu Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Átsihdyúu Péédoro néé dííbyeke: —Áyu cána bo múúhadívú bóhowájtsó peíyené u nééné uwááboju ɨɨná nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Áánélliihyée neébe: —¿Aca ihdyu eene ámuha meíjcyarómé tsá mewáájácutú ɨɨná tene nééiyóne? ");
INSERT INTO boaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Muurá panéváré meóóvehíjcyanéhjɨ́ pevénéré méjpíítyu pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Áánetu ihdyu mɨ́amúnáá ɨ́ɨ́ɨ́búwá déjúcotúré ímítyúné ɨ́jtsaméí tsááne diityéké tútávajtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Muurá diityé ɨ́ɨ́búwá déjúcotu ichívyehíjcyáné panéváré ímítyúné ɨ́jtsaméí ílluúne: Ditye dsɨ́jɨ́vétsócatsíhíjcyanéhjɨ, ditye ihdícyámema dómácócatsíhíjcyanéhjɨ, ditye nánícyatsíhíjcyanéhjɨ, ditye állícyatsíhíjcyanéhjɨ, ditye tsíjtyedi néhní íhjyúvahíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Énehjɨ ihdyu diityéké tútávajtsóhi. Tsá eene Píívyéébé úmɨwávú iímíbájchómeíiyóné íhyójtsɨne níjtyámeítyúmé májchone diityéké tútávájtsotúne. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Átsihdyúu muha mepéé Tííroó, Tsidóoo, íjcyácoomícyú íjcyáné iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Átsihyíhjyáa íjcyalle Canáa múnáalle Jetsóo éllevu tsáá íllu wáníjcyámeíllére: —Ávyéjuúbej, Dabíiúvúj tsɨɨménémúhaabe u íjcyaábej, óhdi ihdyu dɨ́daatsóve. Ájyúwa naavéné ípañe íjcyalle ávyétá ɨhnáhó ɨ́cúbáhrámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ehdúu dille néérónáa tsá dibye ɨɨná néétu díílleke. Áánélliihyée muha dííbyeke menééhií: —Áálleke pɨáábó dille ióómiki. Íjyévé medéjutu wáníjcyámeílléré tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Áánélliihyée neébe: —Tsáháa tsíjtye múnaa jodíómú íjcyátúmeke o pɨ́áábo o tsáátune. Muuráhjáa ihdyu Píívyéébe oke wallóó ijraéémuke o pɨ́áábo éhne múúne obééjámú mújtadu néémeke. ");
INSERT INTO boaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ehdúu Jetsóó néérónáa ɨ́dátsójkímyeílléré dííbyé lliiñévú ɨmɨ́móúúvéne nééhií: —¡Ávyéjuúbej, árónáa óvíjyuco ihdyu oke pɨáábo! ");
INSERT INTO boaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Árónáacáa neébe: —Tsá muurá tsaapi ɨ́ɨ́tsɨ́ɨ́medítyú majcho idyójtúcúne oohímyekéréjuco téénevu ájcúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Árónáacáa neélle: —Ihdyúhde tehdújúcoóro, Avyéjuúbej. Árónáa muurá múúne oohímyé íjcyarómé majchó íaabájajte májchónetu dójcónéwuújɨ. ");
INSERT INTO boaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Áánélliihyée neebe díílleke: —Ɨ́mɨáánéha oke, muulle, u cáhcujtsóhi. Ahdícyane ihdyu óvíi uke ó pɨ́aabóhi. Ehdúu Jetsóó díílleke nééné tujkéveríhjyáa tsúúca dííllé ajyúwá bohɨ́jucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Átsihdyúu muha tsiiñe Gariréá unéuvu mepééme tétsihvu meúújeténáa páhbaú hallúvú ácúúveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Áábedívúu idyé mítyane mɨ́amúnaa píhcyaavémé tsivácunú páhduváré nééneri chéméméhjɨke: Úllétúméhjɨke, hállúvátúméhjɨke, íhjyúvátúméhjɨke, pevéviiújɨ́ néméhjɨke, tsijtye tsííñéeméneri chéméméhjɨke. Áámécóbaúvukée bóhɨ́ɨ́tsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ááneríi mɨ́amúnaa ullévenúhijcyá eenée íhjyúvahíjcyatúmé tsúúca íhjyuvájúcóóneri, páviiújɨ́ɨ némehjɨ ímíjpyeténeri, úllehíjcyatúmée tsúúca úlléjúcóóneri, hállúvatúmé hálluvájúcóóneri. Áánemáa duurúvámé muha mecáánívahíjcyaabe Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ááné boonétúu Jetsóó múúhakye nééhií: —Mítyane ó ɨ́dáátsové íjtye tsúúca pápihchúúj coojɨ́vájuco mééma íjcyámedívú imájchó óúúvéneri. Aane tsá o ímílletú májchótúmeke o wállóóiyóne. Tsáijyu múu juuvávyúré chéméiyómé ájyáháñeri. ");
INSERT INTO boaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Áánélliihyée muha menéé dííbyeke: —Árónáa ¿kiátú meújcúnetu mémájchótsóiyá áyámekéjɨ́ɨ́va múubárá íjcyátútsihyi meíjcyame? ");
INSERT INTO boaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Áánélliihyée múúhakye neébe: —¿Aca múhduná méhdi majcho? Áánélliihyée muha menééhií: —Ijcyáné 7-hova páahóónema áyánéwu amóme. ");
INSERT INTO boaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Áánélliihyée neebe ditye iáhcúbaki. ");
INSERT INTO boaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Áánemáa teene páahóónema amómeke iékéévéne téhdújtsoobe Píívyéébeke. Átsihdyúu idyóhdáhɨ́nunévú múúhakye ájcuube muha mewájtu diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Áánée imájchóne pámeere tsaímíyé óóvénetu coéváné 7-rujtsíva. ");
INSERT INTO boaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Áánée diitye májchome wajpíímúré 4,000-meváubáhjáa walléémuháñema tsɨɨme éévémeítyúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ehdúu imájchótsóné boonétú botsíi wálloobe diityéke. Átsihdyúu muha mɨ́ɨ́neri mepéé Máádará cóómí ijcyáhullévu. ");
INSERT INTO boaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Áijyúu paritséómuma tsadotséómú tsáá Jetsóo éllevu. Áamée dííbyeke imújtátsóro néé íévéhoowávú méénúráítyuróné dibye imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Árónáacáa neebe diityéke: —Muurá cuuvé pañe níjkyejɨ tújpañúnetu ámuha méwaajácú tsíjcyoojɨ ímí nééiñe. ");
INSERT INTO boaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Áánetu cúúvénetu tejɨ tújpañúcooca ámuha méwaajácú téjcoojɨ ímítyuj cóójɨ́ íjcyaíñe. Ehdu muurá ámuha ɨ́mɨáámeúvúdú méwaajácú muhdú néijyu muhdɨ́ɨ́vané cóójɨ íjcyaíñe. Árome ¿ɨ́veekí tsá ámuha mewáájácutú okée iwálloone tsúúca ámúhakye Píívyéébe páhduváré nénehjɨ imyéénúneri úúballéjúcohíjcyaróne? ");
INSERT INTO boaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aame ámuha ɨ́mɨáámejɨ́ɨ́ ¿ɨ́veekí méimíllé méénúráítyuróné o méénune téénetu oke ámuha mecáhcújtsokíjɨ́ɨ́vari? Óvíi ihdyu Píívyéébé ihjyú uubálle múnáajpíi Jonáake pájtyedu nééne oke pájtyénetu ámuha méwaajácú ɨ́mɨááné diibyéjuco o íjcyane. Ehdúu Jetsóó diityéké nééné boone muha diityédítyú mepéé tsiéllevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aamée únéú tsiñéjcuvu muha meúújetétsihvu méɨ́tsaavé múúha májchóhjáa muha maábájɨɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Áánáacáa Jetsóó múúhakye nééhií: —Téɨɨbúwá méíjcyaco. Méɨ́ɨ́cúvedí paritséómuma tsadotséómu éhné pááá ooríchori. ");
INSERT INTO boaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ehdúu múúhakye dibye néénéllii muha ménéjcatsíhi: —Méubáhjané médóviyíjcyó páááhóubáré metsívátúnéllii ehdu meke neébe. ");
INSERT INTO boaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ehdúu muha meɨ́jtsámeíñé iwáájácúne neebe múúhakye: —¿Ɨ́veekí ámuha apááñeríyé méɨ́jtsámeí memájchó mééma íjcyátúneri? Áánélliihyéha ihdyu tsá ímí ámuha oke mecáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Muhdú wáájacúpityúmé ámuúha? ¿A tsá ámuha mewáájácutú éhnée 5-hovátúré páahóónetu 5,000-meváké o májchótsónetu pívárujtsívá pátyeevéne? ");
INSERT INTO boaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Áhdure ¿aca tsá ámuha meɨ́tsáávetú éhnée 4,000-meváké 7-hovátúré o májchotsónetu múhdúrujtsívá cóeene meújcune? ");
INSERT INTO boaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aane ¿muhdú ɨ́ɨ́vane tsá ámuha mewáájácutú tsííñeríyé ámúhama o íhjyúvaróné ámúhakye o nééneé: “Méɨ́ɨ́cúvedí paritséómuma tsadotséómu éhné pááá ooríchori?” ");
INSERT INTO boaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ehdúu dibye néénetu botsíi muha méwájácuuvé ɨ́mɨááné téénetu dibye múúhakye néétune. Ihdyúhacáa paritséómuma tsadotséómú uwáábó múhdurá nééne múúhakye mújtátsóíyónetu muha metéhmémeí dibye múúhakye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Átsihdyúu muha ‘Tsetsaréa Pirípo’ némeí cóómí íjcyáné iiñújɨvu meúújetétsihvu múúhakye neébe: —¿Aca muubá o íjcyane mɨ́amúnaa óhdityu nehíjcyá íñe Mɨ́amúnáájpidívúu o ípívyéévéébedítyu? ");
INSERT INTO boaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Áánélliihyée muha menééhií: —Tsaate nehíjcyá tsojtsó múnáajpi Jóáava tsiiñe bóhɨɨbe u íjcyane. Áánetu tsijtye nehíjcyá éíjyuúvúu ícyahíjcyámé Píívyéébé ihjyú uubálle múnáadítyú Eríaa, Jeremíaa, íjcyámútsidítyú tsaapi u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ehdúu muha menéénéllii múúhakye neébe: —¿Ácooca ámuha muubá o íjcyane menééhií? ");
INSERT INTO boaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Áánélliihyée Péédoro nééhií: —Muurá uu Críjto mɨ́amúnáake u pájtyetétsoobe ɨ́mɨáábé Piivyéébé Hajchi. ");
INSERT INTO boaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Áánélliihyée neébe: —Tehdújuco, maímijyúhde tsáma uu Tsimóó Jonáá hajchi u íjcyaábe. Óvíi Píívyéébe uke pɨ́aabóhi. Tsá muurá mɨ́amúnaa uke túkévéjtsóneri ehdu u íhjyúvatúne. Muurá ihdyu níjkyéjɨri íjcyaabe Llihíyóré uke túkévéjtsóneri ehdu ú ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Áábeke téhdure uke o néé Péédoro dimyémé íjcyane ‘nééwayu’ nééiyóne. Muurá nééwayu ɨɨná wááótuúdú u néébe ú íjcyaá múhdumé oke cáhcújtsómedítyú ímichi ídyéjúcóejpi. Áánéllii muurá tahñéjté íjcyámeke tsá ɨɨná muhdú méénúítyuróne. Muurá dsɨ́jɨvéjúcoorómé tsiiñe bóhɨɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Áhdure uke ó picyóó dijtyééveri mɨ́amúnaa iwáájácu muhdú níjkyéjɨri íjcyaabe Píívyéébé avyéjúejte iíjcyaíñe. Aane íñe ííñújɨri múhdurá ícyahíjcyáné mɨ́amúnaa díuwááboju cáhcújtsotúmé tsá téénéejte íjcyatú níjkyéjɨri íjcyaabe Píívyéébe néhdújuco. Áánetu teene cáhcujtsómé ímí ícyahíjcyámé téénéejte ijcyá dííbyere néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ehdúu iñééné boone múúhakye neebe muha muucá meúúbállétu ɨ́mɨááné diibyéjuco Críjto mépájtyetétsoobe dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Átsihdyúu múúhakye úúbálleebe muhdú Jerotsaréevu péébeke túkevéjtsojtémá llúúvájté avyéjujtee, taúhbájú uwáábojtee, íjcyame ɨɨ́cúbáhráné nɨ́jcáutu dííbyeke dsɨ́jɨ́vétsoíñe. Ároobe 3 coojɨ́vatu tsiiñe ibóhɨɨíñée úúbálleébe. ");
INSERT INTO boaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Áánélliihyée Péédoro múúhadítyú idyówajcáróóbeke nééhií: —Tsáha Ávyéjuúbej, kiá Píívyéébe íjcyánáa ɨɨná uke pájtyeéhi. Tsá ɨɨná uke pájtyéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ehdúu Péédoro néérónáa Jetsóó íllure dííbyeke uhbáhi. Neebépeé: —¡Dɨ́hne óhdityu Náve Naavénej! ¡Iijyévéne oke u túhútsohíjcyáne! Muurá mɨ́amúnáá ɨ́jtsaméíyé dípañe íjcyánéllii tsá u wáájácutú muhdú Píívyéébe óhdityu ɨ́jtsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Átsihdyúu neebe múúhakye: —Tsaate oke iúraavyéné ímillémé óvíi iímillédú iícyahíjcyánetu ɨɨ́hveténe úraavyé wájyúmeítyúméré ɨɨ́cúbáhrámeíyóné pañe. ");
INSERT INTO boaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Muurá iímillédú ííñújɨri iíjcyáíyóneríyé tsúúrámeíhijcyámé tsá pájtyetéityúne. Áánetu teene ɨɨ́hvéjtsóne ookéréjuco ímí iúráávyéíñeri tsúúrámeíhijcyámé pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Aca ɨ́ɨ́netú meke pɨ́áábóiyóné tsáijyu múu mewágóóóvénáa mítyane meéhneváne? ¿Mityá ijcyáné tsane mepájtyetéíyóné ehnííñevu tsaímíyé meíjcyáiyónej? ");
INSERT INTO boaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Muurá oo Mɨ́amúnáájpidívúu o ípívyééveebe Llihíyó avyéjuma ó tsaá dííbyeéjté níjkyéjɨ múnáama. Áijyu muurá pámeere újcuú muhdú iícyahíjcyáne áhdo. ");
INSERT INTO boaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Muurá ɨ́mɨááné ámúhadítyú tsáhái tsaate dsɨ́jɨ́véityú táavyéjú bóhówaavéné ájtyúmɨtúme. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Átsihdyúu 6 coojɨ́vatu tsajtyéébé Péédoroo, Jacóóboo, íñahbe Jóáaá, éhdúmeke cáméhbaúvú múha íjcyátúhullévu. ");
INSERT INTO boaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Áhullévúhjáa diityédívú tsíhdyúrééveébe. Íhyúmɨ́hjáa ajchúcunú cóójɨ́ejpi nuhba ájchúcunúdu. Áhduréhjáa íwajyámú ávyeta cádiúcunú peetédu. ");
INSERT INTO boaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Áánáacáhjáa Moitséee, Eríaa, íjcyamútsí dííbyedívú bóhówáávémútsima ihjyúvaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Áánélliihyéhjáa Péédoro nééhií: —Ávyéjuúbej, ¡Maímijyu ihdyu mee íchihyij! Ahdícyane u ímílléhajchíí metsu meméénu 3-wava nújuwááné dihñéwaa, Moitsée éhwaa, Ería éhwaa, éhdune. ");
INSERT INTO boaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ehdúhjáa Péédoro íhjyúvánáa ojtso ávyeta ájchúcunúné diityédívú niityéhi. Ááné pañétúhjáa Píívyéébe nééhií: —Áánu muurá Hájchíwúuke o wájyúúbedi mítyane ó imíjyúúhií. Áábeke ihdyu tsáma méllééboco. ");
INSERT INTO boaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ááneríhjyáa mítyane iíllityéne ɨ́hvóhobáme. ");
INSERT INTO boaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Áánélliihyéhjáa Jetsóó diityéké dócárájcoobéré nééhií: —Méíllityédíñe. Méíjyocúúve. ");
INSERT INTO boaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ahdújucóhjáa iíjyócúúvéne tsiiñe ditye ɨ́ɨ́térónáa tsáhájuco múha íjcyatúne. Iiyéjucóhjáa Jetsóó tétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ehdúhjáa diityédívú itsíhdyúréévéne oomívú diityéké neébe: —Tsáma méúúbálledíñéi muucá íñe ámuha maájtyumɨ́né Mɨ́amúnáájpidívúu o ípívyééveebe o dsɨ́jɨ́veebe tsiiñe o bóhɨ́ɨ́túné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Áánélliihyéhjáa nééme dííbyeke: —¿Ácooca muhdú ɨ́ɨ́vane taúhbájú uwáábojte nehíjcyá Eríava tsiiñe bóhówááveíñé mɨ́amúnáake pájtyetétsóiibye bóhówáávéíñé ɨhdéwu? ");
INSERT INTO boaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Áánélliihyéhjáa neébe: —Éée, ɨ́mɨáánéjucóhdée tene némeíñé Eríá bóhówááveíñé mɨ́amúnáake pájtyetétsóííbyé úmɨ́wari dibye diityéké ɨɨ́hdénu dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ahdújucóo muurá dibye bóhówaavéné tsojtsó múnáajpi Jóáa eenée Eríá dibye íjcyane némeííbye. Áróóbekée muurá mɨ́amúnaa ávyejúúlletúmé múhdurá dárɨ́ɨ́vehíjcyá múijyú ookéréjuco Mɨ́amúnáájpidívúu o ípívyéévéébeke idyárɨ́ɨ́veídyu. ");
INSERT INTO boaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ehdúhjáa Jetsóó néénetu botsíi diitye 3-meva waajácú tsojtsó múnáajpi Jóááúvudítyú dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aamée tsúúca tsiiñe wajtsɨ́ múúhadívu. ");
INSERT INTO boaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Áánáacáa tétsihyi mítyane mɨ́amúnaa íjcyámedítyú tsaapi Jetsóó lliiñévú ɨmɨ́móúúvéne néé dííbyeke: —Ávyéjuúbej, cána ihdyu óvíjyuco hájchíwúudi dɨ́daatsóvej. Mítyane ɨ́cúbáhrámeíhíjcyaabe imyéívaténeri. Aabe ápíchó áákityéhijcyá cúújúwá pañévu. Tsáijyu áákityéhíjcyaabe téhí pañévu. ");
INSERT INTO boaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aane íñe íjtye dímamyému éllevu diityévá óóma ibóhɨ́ɨ́tso o tsíváróóbeke tsá ditye bóhɨ́ɨ́tsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Áánélliihyée neébe: —¡Juhúúj, múhdúré mɨ́amúnaáhana ihdyu ɨ́mɨááné ámuuha Píívyéébeke cáhcujtsópityúme! Aane íñe ¿múhajchótá ámúhá muhdúré o áábúcúne ámúhakye ó úwáábohíjcyaá ímíñeúvú ámuha mecáhcújtsoki? Ehdúu múúhakye iñétsihdyu neébe: —Áyu cána bo ííllevu metsívaj. ");
INSERT INTO boaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ahdújucóo ditye tsájtyéébé pañe naavéné íjcyáábeke dibye úhbánetu dibye íjchivyéne. Ááné boonée tsúúca ímíjpyetéébe. ");
INSERT INTO boaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ááné boonétúu muha tsamééré meíjcyátsihvu dííbyeke menééhií: —¿Aca ɨ́veekí tsá muha mepíívyetétú meíjchívyetsóné naavéneke eene u méénuhíjcyádu? ");
INSERT INTO boaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Áánélliihyée neebe múúhakye: —Ámuha Píívyéébeke ímí mecáhcújtsótúnéllii tsá ámuha mepíívyetétú tehdɨ́ɨ́vane meméénúiyóne. Muurá ɨ́mɨáánetúré ámúhakye o néé mojtáátsá neeváúwu áyá néérou muhdú kéémevédú ímí ámuha Píívyéébeke mecáhcújtsoca muurá cámehbáú ɨ́ɨ́néiyá tsíhtsihvu ámuha menééjuri. Ehdu ímí Píívyéébeke ámuha mecáhcújtsoca tsá ɨɨná ámúhadívú túhúúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Muurá ihdyu téeméjpiikye mewáágóo májchotúmé Píívyéébeke pɨáábó métáúmeíhi. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Áhdurée Gariréá iiñújɨri muha meíjcyánáa tsiiñe múúhakye neébe: —Mɨ́amúnáájpidívúu ípívyéévéébedívú muurá tsaapi ékéévétsoó ímítyúmeke. ");
INSERT INTO boaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Áábeke ditye dsɨ́jɨ́vétsoobe muurá 3 coojɨ́vatu tsiiñe bóhɨɨ́hi. Ehdúu dibye íhjyuváné ɨ́dátsó múúhakye pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aamée Capenaóovu muha meúújeténáa duurúvájá wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyámé tsáá múúha éllevu múúhakye iáhdótsoki. Aamée Péédoróké néé Jetsóodítyu: —¿Aca tsá ámúhá avyéjuube áhdóityú duurúvájá wáábyuta paméváré áhdohíjcyáne? ");
INSERT INTO boaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Áánélliihyée Péédoro néé diityéke: —Ihdyúi áhdóiíbye. Ehdúu ditye nééne Jetsóoke iúúbálle Péédoro dííbye éllevu tsájá pañévú úcáávérónáa ɨ́hdére népéjtsoobe dííbyeke: —¿Aca muhdú ú ɨjtsúcunúhi, Tsímoj? ¿Muucá múúne áhdótsohíjcyámé ávyéjujte? ¿A íiiñújɨ múnáakére? ¿Mityá tsííñé iiñújɨ múnáakej? ");
INSERT INTO boaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Áánélliihyée neebe Péédoro: —Muurá múúne tsííñé iiñújɨ múnáakéré áhdótsohíjcyáme. Áánélliihyée Jetsóó nééhií: —Aanéjɨ́ɨ́ ¿muhdú tsííñé iiñújɨ múnáájpíubájɨ́ɨ́ ó áhdoóhi? ");
INSERT INTO boaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Árónáa ihdyu o áhdotúné múhdurá ditye ɨɨ́jtsúcunútu cáhawáá pijcyúté úneuj. Aane u píjyúcúúbé ihjyú pañe tsajɨ dsɨ́ɨ́dsɨjɨ u ájtyúmɨjɨ́vú ú áhdóteé mééma tsamútsimájuco. Ehdúu Jetsóó néé Péédoróke. ");
INSERT INTO boaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Áijyúu muha Jetsóoke menééhií: —¿Aca caabyé múúhadítyú ɨ́ɨhtsútuube íjcyaá níjkyéjɨri íjcyaabe Píívyéébé avyéjuri muha meíjcyácoóca? ");
INSERT INTO boaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Áánélliihyée tsɨ́ɨ́ménéwúuke ɨpɨ́úváábeke múúháj pɨɨnévú ipícyóóne neébe: —Ɨ́mɨááné ámúhakye o néé íjtye tsɨɨme ɨɨnéikyé wáájácutúmé íjcyadu ámúhá ɨ́jtsaméí cápáyóóvétúhajchíí tsá ámuha meíjcyáityú Píívyéébé avyéjúejte. ");
INSERT INTO boaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Muurá Píívyéébé avyéjúejte ɨdáátsóméhjɨúvú tsɨɨméwuúmú íjcyadu nééme ijcyá ɨ́ɨhtsútujte. ");
INSERT INTO boaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Muurá íñe áánu ɨ́dátsó tsɨ́ɨ́mene íjcyadu táuráávye múnaa ɨdáátsóméhjɨúvú néémeke ɨ́ɨ́cúvehíjcyámé ookéjuco ɨ́ɨ́cuvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Áánetu botsíi oke cáhcujtsómé ɨ́dátsó tsɨɨméwuúmúdúréi néémedítyú tsaatéké ímítyunévú ɨ́búwátsohíjcyámekéubá múu apáhajchíí íjkyééháñetu néwáyúcobáné ióhbáñúmeke wájojcó móóá pañévú apíchó diityé úmɨwa nééné ɨhdétu. ");
INSERT INTO boaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ɨ́veekíami íñe ííñújɨri ímityúmé íjcyame ténejcúvú tsíjtyeke ɨ́búwátsohíjcyaj! Árómeke ihdyu máɨdáátsoju tene pájtyéiñe. ");
INSERT INTO boaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ahdícyane ámúhá hojtsɨ́neri ímityúné ámuha meméénuhíjcyáhajchíí múu kípíyújcúmeí téhojtsɨ́jɨ. Áhdure ámúháj tuhááñeri ímítyúne éllevu ámuha mepéhíjcyáhajchíí múu kípíyújcúmeí téjtuhájɨ. Muurá ihdyu ímí ámuha méíjcyaá ámúháj piityu tsátsɨhjɨ́tsá íjcyájúcóóturómé ámuha mepájtyetéhajchííjyu. Áánetu muurá ɨ́dátsó ámuha méíjcyaá ímí ámúháj piiháñé néérome múijyú áábatéítyúnéj cuujúwá pañévú ámuha mewágóóóvéhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Áhdure ámúhá hálluúúneri ámuha maájtyumɨ́né ímityúné meméénuhíjcyáhajchíí méwaagóó téuhjɨ. Muurá ímí ámuha méíjcyaá tsánejcúeúhjɨ́ íjcyájúcóóturómé ámuha mepájtyetéhajchííjyu. Áánetu ɨ́dátsó ámuha méíjcyaá tsaúúcuma ámuha meíjcyarómé cúújúwá pañévú mewágóóóvéhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ahdícyane tsá múu tsɨɨméwuúmú íjcyadu ɨdáátsóméhjɨúvú nééné cahcújtso múnáake éhdɨɨválletúne. Muurá ijcyámé diityé tehméjté níjkyéjɨ múnaa Llihíyoma dííbyeke diityé hallúvú pɨááboju táúmeíhijcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Muuráhjáa Mɨ́amúnáájpidívú o ípívyééveebe o tsáá íimítyuháñé mújtátsómeke o pájtyetétsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Aca tsáápí obééjámú 100-meva íjcyámedítyú tsaapi mújtaca tsá dibye ímunáajte 99-meváréjuco íjcyámeke tsátsihvu ipícyóóne néhcóítyuró dííbyeke? Muurá néhcóíyoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aane muurá dííbyeke iájtyúmɨ́ne mítyane ímíjyúúvéíyoobe pámeerée íjcyácooca iímíjyúúné ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ahdu muurá níjkyéjɨri íjcyaabe Méécááni tsá ímílletú dííbyé uráávye múnaa ɨ́dátsó tsɨɨméwuúmú íjcyadu néémedítyú tsáápíubáré wágóoovéne. ");
INSERT INTO boaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ahdícyane ámuha cahcújtso múnáadítyú ímityúné tsaapi ámúhama méénúhajchíí múu iiye dibye íjcyátsihvu bóijcyú téénetu dibye illéébóhajchíí iímíbáávyeki. ");
INSERT INTO boaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aane dibye lléébótúhajchíí múu pívámevájuco ímíñeúvú íhjyuváné dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aame néérone dibye táhjálléhajchíí múu pámeeréjuco cahcújtso múnaa idyóbéévéne íhjyuváné dííbyema. Áámeke idyé dibye táhjálléhajchíí múu ílluréjuco ɨ́hvejtsóné ihdícyaabéduréjuco dibye iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Muurá ɨ́mɨááné ámúhakye o néé muhdú níjkyéjɨri íjcyaabe Píívyéébe néhdújuco íñe ííñújɨri mɨ́amúnáake ámuha metúkévétsohíjcyádú ámuha meíjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Áhdure idyé ámúhakye o néé míítyétsi tsane ɨɨ́jtsámeíñé hallúvú Llihíyó Píívyéébe níjkyéjɨri íjcyáábeke pɨáábó táúmeíhajchíí muurá pɨ́áábóiibye diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Muurá Píívyéébeke cáhcujtsómé pívááturómé tamyémeri píhcyáávéméj pɨɨne oo diityéké o pɨ́ááboki. ");
INSERT INTO boaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ehdúu Jetsóó néénéllii Péédoro néé dííbyeke: —Ávyéjuúbej, ¿aanéhaca íñe múhdúijyúvá ó ɨ́dáátsóvéiyá óóma ímityúné méénúmedi? ¿A 7-ijyúva? ");
INSERT INTO boaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Áánélliihyée neébe: —Tsáhaá, paíjyuváré múu ɨ́dáátsové uke ímityúné méénúrómedi. ");
INSERT INTO boaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Muurá níjkyéjɨri íjcyaabe Píívyéébe pámeemáyé íavyéjú ímíbájchoó tsáné avyéjuubéhjáa ihyájkímú pevénéré dííbyedítyú náhjɨ́hénuhíjcyáné diityémá ímíbajchódu. ");
INSERT INTO boaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tujkénúhjáa ímíbájchóroobe mítyane pevénéré dííbyedítyú náhjɨ́hénuhíjcyáábema. ");
INSERT INTO boaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Árónáacáhjáa tsá dibye píívyetétú teene ɨ́ɨ́netú iáhdóiyóne. Áánélliihyéhjáa diibye íavyéjuube néé tsaatéké dííbyedívú iñáhjɨ́hénuíñé páneere ihñénéhjɨma ɨ́ɨ́tsɨ́ɨ́memájuco teene múhdutú dibye áhdóítyúrónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Áánélliihyéhjáa diibye íúníu múnáajpi dííbyé lliiñévú ɨmɨ́móúúvéne dííbyedívú ɨɨ́dátsójkímyeíñe nééhií: “Ávyéjuúbej, cána ehdícyáróné pañéi daabúcú íñe úhdityu o náhjɨ́hénuhíjcyáné uke o áhdohíjcyatúne. Ukéi chooco ó áhdoó páneére.” ");
INSERT INTO boaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ehdúhjáa dibye néénéllii dííbyedi ɨɨ́dáátsóvéne tsáhájuco dibye áhdótsotúne. Áábé hallúríhjyáa tsá ɨɨná íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ehdúhjáa íavyéjuube dííbyema ímíbájchótsihdyu péébe cábuuvé tsaapi íñahbéébedívú téhduréhjáa dííbyedítyú áyánéwu iñáhjɨ́henúné áhdohíjcyátúúbedívu. Áábekéhjáa íjkyéétu iéékévéne neébe: —Ó imíllé ícyoocáré oke u áhdone óhdityúu u náhjɨ́henúne. ");
INSERT INTO boaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Áánélliihyéhjáa téhdure dííbyé lliiñévú ɨmɨ́móúúvéne ɨɨ́dátsójkímyeíñe nééroobe dííbyeke: “Muúbej, cána ihdyu óvíjyucói daabúcú tsáríyóné pañe teénej. Ukéi ihdyu chooco ó áhdoóhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Árónáacáhjáa tsá dibye ímílletú ɨɨ́dáátsovéné dííbyedi. Ílluréjucóhjáa dibye cúvéhoojánúné dííbyeke. Aabéhjáa cúvéhóójá pañe ijcyá dííbyeke iáhdótúné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ehdúhjáa íñahbéébeke dibye dárɨɨvéné tsijtye íñahbéjteke ɨ́dátsó pájtyénéllii íavyéjúúbeke úúballémé muhdú dííbyeke tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Áánélliihyéhjáa íavyéjuube pɨ́uvá dííbyeke. Áábekéhjáa népéjtsoóbe: “Uu táúníu múnáajpi, ¿ɨ́veekí ávyétá imítyuube uú? Úhdíi muurá o ɨ́dáátsóvéne ó ɨ́hvejtsó páneere ávyétá mityáné óhdityu u náhjɨ́henúné u áhdohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ahdu muurá díñahbéébedi u ɨ́dáátsóvéne ú ɨ́hvéjtsóiyá páneere úhdíi o ɨ́dáátsóvéne o ɨ́hvejtsódu.” ");
INSERT INTO boaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ehdúhjáa íavyéjuube dííbyeke iñééne ílluréjuco icyáyobáávaténe icyúvéhoojánúúbedívú ɨ́cúbáhratsóné teene dibye áhdótúné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ehdu muurá ámúhakye méénúiibye Llihíyó níjkyéjɨri íjcyaabe ámuha ɨ́mɨáánéjuco ámúhá ɨ́ɨ́búuri ámúhá náhbedi meɨ́dáátsóvétúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ehdúu Jetsóó nétsihdyu muha mepéjucóó Gariréatu Jodéá iiñújɨvu Joodáá tsiñéjcuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Áhullée mítyane mɨ́amúnaa úráávyehíjcyá dííbyeke. Áámedítyúu chéméméhjɨke bóhɨ́ɨ́tsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Áijyúu tsaate paritséómú dííbyeke imújtátsóro dííbye éllevu itsááne nééhií: —¿A tehdújuco tsaapi méwakye ɨ́hvéjtsóiyóné ihdícyáné hallútúre? ");
INSERT INTO boaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Áánélliihyée neébe: —¿Aca tsá ámuha meéévehíjcyatú Píívyéébé waajácuháámɨ? Muurá téhaamɨ́tú caatúváné dibyée páné ɨhdéene iípívyéjtsóné nɨ́jcaúvú téhdure ípívyejtsóné wajpii, wallee, íjcyane muhdú tene íjcyaídyújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Áánemáa muurá téijyújuco dibye nééne wajpi wálleeke ityáábávállema ɨ́ɨ́neíñé cáánímútsidítyú dííllemáyéjuco iíjcya tsahéécoréjuco tsáápiiye íjcyáiyódu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aamútsí muurá míítyétsi íjcyáromútsí tsahéécoréjuco íjcyaíñé Píívyéébée ípívyejtsódújuco. Áánéllii tsá tsaate ityáábávájcatsícyooca dówáávéítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ehdúu Jetsóó néénéllii nééme dííbyeke: —Áánáacáráhjáa ¿ɨ́veekí Moitsééúvú úwáábohíjcyá metáábávárólleke meɨ́hvéjtsóiyóné tééné waajácuháámɨ́ mecáátúnúhaamɨ́vú maájcúnema? ");
INSERT INTO boaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Áánélliihyée neébe: —Muuráhjáa ihdyu eene ámuha meíjcyadu ditye cáhcujtsópítyúnéllii ehdu nehíjcyaabe tehdu tene néétúrónáaáca. Tsáháa Píívyéébe tehdu teene ípívyéjtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Áánéllii ámúhakye o néé tsaapi mewa ímityúné tsíjtyéhjɨma méénútúrólleke ɨɨ́hvéjtsóne tsíjpíllekéréjuco táábáváhajchíí muurá ímityúné méénuube ɨ́veekí méwamájɨ́ɨ́ tsíjpíllema iíjcyáneri. Áhdure idyé tsaapi ɨ́hvéjtsólleke táábávaabe ímityúné meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ehdúu Jetsóó néénéllii muha menééhií: —Ímí tehdújúcooro teene táábávajcátsí néérónáa tsíñejcútú múhdurá teéne. Áánélliihyéubá óvíjyácóóiyóné teéne. ");
INSERT INTO boaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Áánélliihyée neebe múúhakye: —Árónáa tsá paméváré píívyetétú tehdu iíjcyane. Apáámyéré ihdyu Píívyéébe pícyohdújuco íjcyame piivyété tehdu iíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Muurá ijcyámé tsaate ípyée iípívyeevédújuco wálleema iíjcyáiyóné píívyetétúme. Áhdure ijcyámé tsaate mɨ́amúnaáré méénúnetu wálleema iíjcyane píívyetétúme. Áánetu ihdyu tsaate imíllé ííyéejtéré iíjcyane ɨɨná túhújtsotúmé níjkyéjɨri íjcyaabe Píívyéébé avyéjúejte iíjcyáneríyé ɨɨ́ɨ́jɨ́veki. Ahdícyane ihdyu óvíi caatyé ííyéejtéré iíjcyane ímillémé tehdu ijcyáhi. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Áijyúu tsaate ɨ́ɨ́tsɨ́ɨ́meke tsivá dííbye éllevu dibye diityé hallúvú pɨááboju ityáúmeí Píívyéébeke. Áánélliihyée muha menéé ɨ́ɨ́nevú ditye tsɨɨméké tsívane íllure dííbyeke ityúhújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Árónáacáa neebe múúhakye: —Óvi ihdyu tsiváme. ¿Ɨ́veekí ámuha mécátuhtsóhi? Muurá diitye tsɨɨme íjcyadu néémé wáábyuta Píívyéébé avyéjú ijcyá níjkyéjɨri. ");
INSERT INTO boaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ehdúu iñééne diityéké dócárájcoobéré Píívyéébeke pɨáábó táúmeí diityé hallúvu. Ááné boonétúu tétsihdyu muha mepéé tsiéllevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tsáijyúu téhdure tsaapi ováhtsá ehnéva múnáajpi íjcyaabe Jetsóo éllevu itsááne nééhií: —Uwááboóbej, ɨ́mɨáábé u íjcyaabe cána oke diñe muhdú o íjcyáiyóné múijyú o dsɨ́jɨvéjúcóóítyúne bóhɨ́ o újcuki. ");
INSERT INTO boaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Áánélliihyée neébe: —¿Aca ɨ́veekí eene oke ú dilló ɨ́mɨáábedi? Muurá ihdyu apáábyéré Píívyéébe ɨ́mɨáábe. Ahdícyane cáhawáá dííbyé taúhbajúúné néhdu diicya múijyú u dsɨ́jɨvéjúcóóítyúne bóhɨ́ u újcune u ímílléhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Áánélliihyée neébe: —¿Aca keená teene dííbyé taúhbajúúne? Áánélliihyée úúbálleebe teene taúhbaju íllu nééneé: —Tsá múu mɨ́amúnáake dsɨ́jɨ́vétsotúne. Tsá múu ihdícyámema dómácójcatsítyúne. Tsá múu nánívatúne. Tsá múu állíuutúne. ");
INSERT INTO boaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Múu avyéjuullé díícyáánimútsikye. Pamévakéré múu wajyú muhdú u wájyúmeídyu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ehdúu Jetsóó néénéllii neébe: —Muuráhjáa ihdyu táayáábedítyúré tehdújuco o ícyahíjcyáne. ¿Mityá ijcyánéi tsiiñe ɨɨná o méénúiyónej? ");
INSERT INTO boaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Áánélliihyée neébe: —Ihdyu panévatúré ɨ́mɨáábé u íjcyane u ímílléhajchíí dítsíeméné náhjɨ́hénúne ɨ́dáátsóméhjɨke pɨáábo. Áijyu ihdyu ɨ́mɨááné ú ávyéjúúteé níjkyéjɨri íjcyaabe Píívyéébé avyéjuvu. Aane cáhawáá ehdu méénúne ookéréjuco duráávyej. ");
INSERT INTO boaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ehdúu Jetsóó nééne kímóhcó pajtyé dííbyeke mítyane dibye éhnévánélliíhye. Aabée ílluréjuco pééne kímóóveebére. ");
INSERT INTO boaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Áánélliihyée Jetsóó néé múúhakye: —Ɨ́mɨáánetúré ámúhakye o néé ehnéva múnaa ɨ́htsútúnetu úcáávéiyóné Píívyéébé avyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","¿Aca muhdú caméélló ánéétóhéjutu pajtyéiyáhi? Áhdure ¿aca muhdú diitye ehnéva múnaa Píívyéébé avyéjuvu úcáávéiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ehdúu dibye nééneri muha meúllévenúne menééhií: —¿Aca ihdyu múhdutúrá pájtyetéiyóme? ");
INSERT INTO boaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Áánélliihyée múúhakye ɨɨ́ɨ́téne neébe: —Tsá muurá mɨ́amúnaa píívyetétú iiye ipájtyetétsámeíñe. Árónáa Píívyéébe piivyété diityéké ipájtyetétsóné ɨɨná dííbyedívú túhúútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Áánélliihyée Péédoro nééhií: —Ávyéjuúbej, muuráhjáa páneere muha meɨ́hvéjtsóne uukéréjuco meúraavyéne. ¿Aane muhdúí íñe teéne? ¿Ɨɨná muha méújcuú tééné hallúvu? ");
INSERT INTO boaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Áánélliihyée múúhakye neébe: —Ɨ́mɨáánetúré ámúhakye o néé páneere tsíhdyuréjuco ímíbáávyécooca Mɨ́amúnáájpidívúu o ípívyééveebe o ávyéjuutéiñe. Áijyu idyé ámuha téhdure méíjcyaá 12-hava ámúha múnaa ijraéémú íjcyámé avyéjujte. ");
INSERT INTO boaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Muurá páneere íijcyátsɨ́hjɨma imúnáake íñahbémuu, íñaallémuu, cáánimuu, méwamyuu, ɨ́ɨ́tsɨɨ́mee, íjcyárómeke ipícyoíñúne ookéréjuco iúráávyéné wákimyéí méénume éhnííñevu tsaímíyé íjcyaá múijyú muhdú íjcyáityúmeréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Árónáa ihdyu téɨɨbúwá méíjcyaco. Muurá íñe ícyooca ɨ́htsutúmé íjcyame ɨ́dátsó téijyu waagóojte íjcyaáhi. Ááné lliiñévú íñe ícyooca ɨ́daatsómé ávyéjúúteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Muurá Píívyéébe níjkyéjɨri íjcyaabe pámeemáyé íavyéjú ímíbájchoó éhne múúne tsaapi íúmɨhé wákimyéi múnáama diityé wákimyéí ímíbajchódu. Tsaapíhjyáa muurá íúmɨhé pañétú óóva ditye iááhɨ́vétso cúúvénetúré nehcó wákimyéi múnáake. ");
INSERT INTO boaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aanéhjáa tsúúca iújcúmeke neebe 10-haamɨ́vá tsájcoojɨ iáhdoíñe. Áánemáhjáa wallójúcoobe ditye iwákímyeíki. ");
INSERT INTO boaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ááné boonétúhjáa idyé cójɨ́hréjuco néénáa tsiiñe tsíjtyeke néhcotéébé úújeté tsaate tsátsii pevétáré íjcyámedívu. ");
INSERT INTO boaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Áámekéhjáa neébe: “Ámuúhaj, óóma méwákímyeítyé táúmɨhé pañe. Ámúhakye ímí ó áhdoóhi.” Ahdújucóhjáa ditye wákímyeítyéne. ");
INSERT INTO boaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ááné boonétúhjáa idyé tsiiñe cójɨ́jpɨɨne péébe újcujé tsíjtyeke. Átsihdyúhjáa tsiiñe péébe újcujé tsíjtyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ááné boonétúhjáa ávyétá cuuvé pañéjuco péébe úújeté tsaate pevétáré íjcyámedívu. Áámekéhjáa neébe: “¿Ɨ́veekí wákímyeítyúmé ámuha pevétáre?” ");
INSERT INTO boaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Áánélliihyéhjáa néémeé: “Muhdú múha múúhakye táúhbánejɨ́ɨ́ ɨɨná muha méwákímyéiyáhi.” Áánélliihyéhjáa neébe: “Ané óóma mepééne méwákímyeítyé táúmɨhe. Ámúhakye ímí ó áhdoóhi.” Ahdújucóhjáa ditye pééne dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ááné iijyúnuvúhjáa diitye wákimyéi múnáá tehméébeke neébe: “Áyu ílluréjuco wákimyéi múnáake dááhɨ́vétsómeke dahdo. Nihñérené úcáávémedítyú ú áhdótujkénuúhi. Ááné boonétúi ú áhdoó tujkénuné úcáávémeke.” ");
INSERT INTO boaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ahdújucóhjáa dibye eenée ávyétá nihñéejtéré cuuvé pañe úcáávémedítyú áhdótujkénúné tsáápiitsáké 10-haamɨ́vá diibye tépallí múnáajpi néhdunéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aanéhjáa diitye eenée tujkénú cúúvénetúré úcaavémé ɨɨ́ɨ́téne ɨ́jtsámeí dibye áhdoíñé éhnííñevu pájcoojɨ́ré ditye wákímyeíñélliíhye. Árónáacáhjáa diityéké téhdunéré 10-haamɨ́vá áhdoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aanéhjáa múhdurá diityéké pájtyénéllii tépallí múnáájpidítyú llíhcyámeímye. ");
INSERT INTO boaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Áámedítyúhjáa tsaapi néé dííbyeke: “Aca muhdú ɨ́ɨ́vane aatye ícyoocárené cuuvé pañe úcáávémeke ú ahdó íñe muha cójɨ́hajchótá állócohɨ́váneri mewákímyeímyeke u áhdodúnére.” ");
INSERT INTO boaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Áánélliihyéhjáa neebe dííbyeke: “Muúbej, ¿acáne tsá o néétu téhdune 10-haamɨ́vá ámúhakye o áhdoíñé tsájcoojɨ́ wákiméi? Áánerá tsáháturo ímityúné ámúhakye o dárɨ́ɨ́vetúne. ");
INSERT INTO boaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ahdícyane wa eene uke o áhdone dékéévéne dipyej. Muurá ihdyu ó imíllé áyánéwu wákímyeíyómema tsahdúnéhjɨ́ré o áhdone pámeekére. ");
INSERT INTO boaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Aca tsá u wáájácutú o ímillédú o áhdóiyóné tadsɨ́ɨ́dsɨdívu? Anéjɨ́ɨ́va oke ú nééiyá múhdurá o dárɨɨvéne. Áhdure tsá u nómíutááváítyuró pámeemáyé ɨ́mɨáábé o íjcyáneri.” Ehdúhjáa neebe tépallí múnáajpi dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ahdícyane íñe ícyooca iiye ɨ́htsutúmé iíjcyane ɨ́tsúcunúmeíhijcyámé nihñéétsihvu ɨ́dátsó waagóojte íjcyaáhi. Ááné lliiñévú íñe ícyooca ɨ́daatsómé ávyéjúúteéhi. Muurá mítyámeke táavyéjú wákimyéivu o újcúrómedítyú uhjéméré ímí teene úraavyémé ávyéjúúteéhi. Ehdúu Jetsóó úwaabó tsaapi íwákimyéi múnáama diityé wákimyéí ímíbájchónetu. ");
INSERT INTO boaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Átsihdyúu múúhaye 12-meva Jerotsaréevu dííbyema mepéénáa juuvávyú múúhakye neébe: —Mepéé íñe Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ácoomívú muurá Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi llúúvájté avyéjujtémá taúhbájú uwáábojtéké óhdivu ékéévétsoóhi. Aame neé oke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Áábeke muurá oke ɨ́hvéjtsoímyé jodíómú íjcyátúmé hójtsɨ́ pañévu. Aame óhdi iúúhɨ́vaténe oke imyéénúúbeke ílluréjuco wátyétyéhcuíñé páwachékevu o dsɨ́jɨ́veki. Ároobe tsiiñe ó bóhɨɨ́ 3 coojɨ́vatu. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Téijyúu Tsebedéó taaba Jetsóo éllevu itsááne íllímutsi Jacóóboo, Jóáaá, íjcyamútsí múúhama íjcyámútsikye ɨpɨ́úváne dííbyé lliiñévú mɨ́móuuvé pɨáábó ityáúmeíki. ");
INSERT INTO boaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Áállekée neébe: —¿Ɨ́ɨ́netú uke o pɨ́aabóné ú imílléhi? Áánélliihyée neélle: —Ó imíllé íjtyetsi hájchíwúumútsí úúma páñétúétsihyi íjcyane díavyéjuri u íjcyácoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Árónáacáa neebe díílleke: —Ávyeta tsá u wáájácutú ɨɨná u táúmeíñe. Ehdúu díílleke iñétsihdyu diityétsikye neébe: —¿Aca ámuhtsi ávyétá ɨhnáhó méɨ́cúbáhrámeíiyá muhdú o ɨ́cúbáhrámeídyu? Áánélliihyée neemútsi: —Éée, muhtsi méɨ́cúbáhrámeíiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Áánélliihyée neebe diityétsikye: —Ɨ́mɨáánéhde ámuhtsi méɨ́cúbáhráméiíhi. Árónáa ihdyu páñétúétsihyi táavyéjuri o íjcyácooca tsá oore ámúhtsikye táúniúvú o pícyóóítyuróne. Muurá ihdyu Llihíyóré pícyoó caatyéké iwábyújtsómeke. ");
INSERT INTO boaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ehdúu Jetsóoma dityétsí íhjyuváné múúhakye diityétsí nahbéjté 10-meva muha meíjcyámeke tsárí pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Árónáacáa múúhakye ɨpɨ́úváne neébe: —Ámuha muurá méwaajácú íñe ííñújɨri íjcyáné avyéjujte paméváré ɨ́htsutúmé iíjcyane ímilléne. ");
INSERT INTO boaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Áánetu ihdyu íñe ámuha tsúúca tahñéjté meíjcyame tsá múu tehdu néétune. Ámúhadítyú tsaapi íboohówaabe iíjcyane ímílleebe múu íñahbéjteke ɨ́ɨ́cuvé íñée muhdú Mɨ́amúnáájpidívú o ípívyééveebe o méénuhíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsáháa muurá o tsáátu ɨ́htsútuube ávyéjuube o íjcyáábeke mɨ́amúnaa oke ɨɨ́ɨ́cúveki. Muuráhjáa ihdyu o tsáá diityéké o pɨ́aabódú íjcyaabe diityé wájyuri o dsɨ́jɨ́ve teene cáhcujtsómé ipájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aamée Jericóotu muha mepéémeke mítyane mɨ́amúnaa úraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Áijyúu hállúvátumútsí juuvá úníuri ácuúcunúhíjcyamútsí tétsihdyu Jetsóoma muha mepájtyene iwáájácúne kéévánécoba néé dííbyeke: —¡Ávyéjuúbej, Dabíiúvúj tsɨɨménémúhaabe u íjcyaábej, múhtsidi ihdyu óvíjyuco dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ehdúu dityétsí néénéllii tétsii íjcyame uhbá cúúvéhulléré dityétsí iíjcyaki. Áróneríi ɨ́ɨ́cúvétumútsí éhnííñevúré tsiiñe nééhií: —¡Ávyéjuúbej, Dabíiúvúj tsɨɨménémúhaabe u íjcyaábej, múhtsidi ihdyu óvíjyuco dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Áánélliihyée Jetsóó iíjyócúúvéne néé diityétsikye: —¿Ɨɨná ámuhtsi méimílléhi? ");
INSERT INTO boaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Áánélliihyée neemútsi: —Ávyéjuúbej, muhtsi méimíllé mahálluváne. ");
INSERT INTO boaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ehdúu dityétsí néénéllii mítyane ɨ́dáátsóveebe diityétsidi. Áánemáa diityétsikye íhyálluúúné dibye dócárájcónetu tsaímíyé ɨɨtéjúcoomútsi. Aamútsíi dííbyekéréjuco úraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aamée muha méwajtsɨ́ Jerotsaréé pɨɨhɨ́riyéjuco Bepajéé cóómí úníuri Oríívo bájú íjcyátsihvu. Átsihdyúu Jetsóó wallóó míítyétsikye múúhadítyú técoomívu. ");
INSERT INTO boaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Áámútsikyée neébe: —Écoomi ɨ́pɨɨhɨ́ré cóómityu óóma méujcúté íayáne ɨ́ɨ́jú íllíma íjcyaabe dóhjɨ́númeííbyeke. Áábeke metsíñaáyóne métsívaco. ");
INSERT INTO boaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aane tsaate ámúhtsikye ‘ɨ́véémútsikyé ámuhtsi métsíñaáyó’ néhajchíí méneéco: “Ávyéjuubéne múhtsikye néénélliíhye. Ɨ́ɨ́cúiyévané ihdyu óómíchóiíbye.” Ehdúu neebe diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ehdúu pajtyéné Píívyéébé ihjyú uubálle múnáajpíhjyáa íllu néhdújuco: ");
INSERT INTO boaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tsióó cóómi múnáake mene: “Ámúha éllevu ámúhá avyéjuube tsaá ɨ́daatsóné íayáne ɨ́ɨ́jú hájchí hallúri.” Ehdúhjáa neebe Píívyéébé ihjyú uubálle múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aamútsíi tsúúca újcujé diibye íayáne ɨ́ɨ́juke íllíma Jetsóó néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Áábé hallúu wájyamúúnetu muha meɨ́hbóné hallúvú iñéríívyéne péjúcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Áijyúu mítyane mɨ́amúnaa íjcyame ɨhbó íwajyámuunévú juúva. Tsaatée wájyaúúnevu ɨhbóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aamée dííbyema péé tsuullérí íjcyamee, idyéjuri íjcyamee, ehdu. Aamée wáñécohíjcyá: —¡Ñóóooj, máávyejújtsó áánu Dabíiúvúj tsɨɨménémúháábeke! ¡Maímijyu dibye Píívyéébe mémeri tsááneéj! ¡Ñóóooj, máávyejújtsó caame íjcyaabe Píívyéébeke! Ehdúu iwáñéjcóne nehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aabée Jerotsaréevu úcáávéneri pámeere técoomí múnaa íbórɨ́baavémé nééhií: —¿Múamí tsáma aátyej? ");
INSERT INTO boaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Áánélliihyée tsaate nééhií: —Áánerá aabye Jetsóó Píívyéébé ihjyú uubálle múnáajpi Gariréá iiñújɨri íjcyacóómí Natsarée múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ááné boonétúu duurúvájá pañévú náhjɨ́hénújcatsímyeke téjá pañétú boáyoóbe. Wájójcoobée dsɨ́ɨ́dsɨke cápáyócohíjcyámé metsáwááne. Áhdurée ɨ́júúmuke náhjɨ́hénuhíjcyámé acúúvéihcyúné wájójcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Áánemáa neebe diityéke: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Íjya tahjya tééjá lliiñévú mɨ́amúnaa óóma íhjyúvahíjcyáijya.” Aaja ¿ɨ́veekí ámuha naní múnáá jaríyéjuco medíllone? ");
INSERT INTO boaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Áijyúu tééjá pañe hállúvátúméhjɨma ímí úllehíjcyátuméhjɨ́ íjcyame dííbyeke pɨáábó táúmeímyeke ímíjpyetétsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ehdúu téijyu méénuube méénúráítyúronéhjɨ. Áijyúu tsɨɨme wáñécohíjcyá: “¡Ñóóooj! Átsihdyúu nehíjcyáme: ¡Máávyejújtsó aadi Dabíiúvúj tsɨɨménémúháábeke!” Aanée llúúvájté avyéjujtémá taúhbájú uwáábojte tsárí ɨɨ́jtsúcunúne Jetsóoke nééhií: —¿A ú lleebo eene aatye néhijcyánej? ");
INSERT INTO boaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Áánélliihyée Jetsóó néé diityéke: —Éée. ¿Aca tsá múijyú ámuha meéévetú Píívyéébé waajácúháámɨ́ téénetu íhjyuváne? Íllu muurá nééneé: Pámeere dííbyeke duurúvahíjcyá tsɨɨme ñohñóríyéi íjcyárótsɨ́wuújɨmájuco. ");
INSERT INTO boaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ehdúu Jetsóó diityéké nééné boonétú muha mepéé Jerotsaréetu Betáániávuréjuco. Áhullée tépejco muha mécuwáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ááné tsɨtsɨ́ɨ́vevúu cúúvénetúré muha tsiiñe Jerotsaréevu meóómíñáa Jetsóó ajyábáávatéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aabée juuvá úníutu íjcyahe higyéérahe úújéjerá ‘néévahéubáhaja’ iñéénema. Árónáacáa tsá tehe néévatúne. Áánélliihyée ílluréjuco dibye teehe pítyúútsoobe nééneé: —Níhñécunu ílluréjuco u chéméihye ¿ɨ́veekí tsá u néévatúne? Ehdúu dibye néénemáyé tsúúca ɨ́jtoíñuhe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Áánéríi muha meúllévenúne menéé dííbyeke: —¿Aca muhdú eene eehe higyéérahe peecútéré tsúúca cheméhi? ");
INSERT INTO boaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Áánélliihyée neebe múúhakye: —Muurá ɨ́mɨááné ímíñeúvú ámuha mecáhcújtsoca tsá apááñéré íñe higyéérahe o chémétsónéeméné ámuha meméénúítyuróne. Téhdure muurá ámuha menééjuri tsane cámehbáú ɨ́ɨ́néiyá móááj pɨɨnévu. ");
INSERT INTO boaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ahdícyane muurá páneere ɨɨná Píívyéébeke ámuha metáúmeíñé ámúhakye ájcúiibye ɨ́mɨáánetúré ámuha ímí mecáhcújtsóhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Átsihdyúu idyé tsiiñe duurúvájá pañévú dibye úwáábónáa páñétúejte llúúvájté avyéjujtémá túkevéjtsojte dííbye éllevu itsááne nééhií: —¿Aca múúbé ɨhtsúturí u íjcyaabe eene ehdu nénehjɨ ú méénuhíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Áánélliihyéhjáa neebe diityéke: Áhdure ¿acáa múha nééjuri Jóáa tsótsohíjcyá cáhcújtsómeke? ¿A Píívyéébeé, mityá mɨ́amúnaárée nééjuri tééné wákimyéí méénuhíjcyaábej? Áyu cána oke máañújcuj. Ámuha oke maáñújcúhajchíí botsíi ámúhakye ó neé múúbé ɨhtsúturí ténehjɨ o méénuhíjcyáne. Áánélliihyée tsamééré néjcatsíhi: —Muurá ‘Píívyéébée nééjuri tsótsohíjcyaábe’ menéhajchíí meke nééíyoóbe: “¿Áábekéráhjáa ɨ́veekí tsá ámuha mecáhcújtsotúne?” ");
INSERT INTO boaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Áánetu ‘mɨ́amúnaárée nééjuri’ menéhajchíí meke diitye mɨ́amúnaa tééné hallútú méénúiyáhi. Muurá paméváré cáhcujtsó ɨ́mɨáánéjucóo Píívyéébé ihjyú uubálle múnáajpi diibye Jóááuvu íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ehdúu iñéjcatsíñeri iñúhnévéne íllure nééme dííbyeke: —Maáhuú, tsá muha mewáájácutúne. Áánélliihyée neebe diityéke: —Aanéjɨ́ɨ́va idyé ámúhakye ó neé múúbé ɨhtsúturí o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Átsihdyúu tsiiñe Jetsóó diityéké nééhií: —¿Muhdú ámuha méɨjtsúcunú tsiiñe ámúhakye o úúbálleíñe? Tsaapíhjyáa íllímútsidítyú ámíáábeke nééhií: “Llíhij, cána íhyajchíí méúmɨhe wákímyeítyej.” ");
INSERT INTO boaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Árónáacáhjáa neébe: “Tsá o ímílletúne.” Árónemáhjáa bóónétu wákímyeítyeébe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Átsihdyúhjáa bónéébeke neebe téhdure. Áánélliihyéhjáa neébe: “Juújuj Llíhij, tehdújuco. Óvíi ó wákímyeítyéhi.” Árónáacáhjáa tsá dibye wákímyeítyetúne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aanée ¿caabyé diityétsidítyú cáhcujtsó cááníkyeé? Áánélliihyée nééme dííbyeke: —Tujkénúejpíhjyáa cáhcujtsóhi. Átsihvúu neebe diityéke: —Ɨ́mɨáánetúré ámúhakye o néé muurá múhdurá ícyahíjcyáné walléémuma méiiñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyámé ímityúmé íjcyarómé ímíjpyéteé ámúhájtane Píívyéébé avyéjúejtéréjuco iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Muuráhjáa tsojtsó múnáajpi Jóáa ámúhakye úwáábohíjcyará ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne Píívyéébé icyánejcúvuréjuco ámuha meɨ́búwáávéroki. Árónáacáa tsá ámuha mecáhcútsohíjcyatú dííbyeke. Áánetúu ihdyu muurá diitye ɨ́mɨááné ímityúmé íjcyarómé dííbyé uwáábó icyáhcújtsóne ímíjpyetéhi. Áánáacáa ¿muhdú ɨ́veekí tsá ámuha teene melléébójúcoorómé meímíjpyetétúne? ");
INSERT INTO boaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cáhawáá mélleebúcunu tsiiñe ámúhakye o úúballéne: Tsaapíhjyáa íúmɨhe óóva ibájtsone mɨjcónúhi. Áánemáhjáa tsátsii ímíbájchoobe tééne néévá dótsúhcúmeíitsíi. Áhduréhjáa jáhwu méénuube cáámé cóhnaúvú tééjá pañétú tépalli téhmémeíijya. Ápallívúhjáa tsaatéké ityéhmétsóne aahɨ́vetéébé tsííñé iiñújɨ. ");
INSERT INTO boaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aabéhjáa tsúúca tene néévane iwáájácútsihvu wallóó íúníu múnáake diityémá ditye iwállóóro téénetu dííbye éhné íjcyadúne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Árónáacáhjáa íllure méénúpejtsómé diityéke. Tsáápiikyéhjáa néwayúúnevu aamúme. Áánetúhjáa tsíjpiikye dsɨ́jɨ́vetsóme. ");
INSERT INTO boaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ááné boonétúhjáa idyé tsiiñe wálloobe pívámevákéjuco. Árómekéhjáa idyé méénúpejtsóme. ");
INSERT INTO boaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ááné nihñévúréhjáa wálloobe íllíkyeréjuco ‘íhya hájchíwu íjcyánéllii dííbyeke avyéjúúlléiyóme’ iñéénema. ");
INSERT INTO boaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Árónáacáhjáa dííbyeke iájtyúmɨ́ne néjcatsímye: “Aabye muurá íllíyéjuco íñe cááníñúiyóne. Áánéllii metsu dííbyeke medsɨ́jɨ́vétso mehnéréjuco tene iíjcyaki.” ");
INSERT INTO boaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ahdújucóhjáa iékéévéébeke ditye tépallítyú ɨ́ɨ́wávu itsájtyéne dsɨ́jɨ́vetsóne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ehdúu iúúbállétsihdyu neebe diityéke: —¿Aane íñe diibye úmɨhé aabájaabe itsáácooca muhdú méénuú diityéké eenée tépallívú dibye téhmétsoíñúmé ímityúné dárɨ́ɨ́vémeímyeke? ");
INSERT INTO boaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Áánélliihyée néémeé: —Íhya ihdyu diityéké ɨ́dáátsóvétuubéré ɨdsɨ́jɨ́vétsóne tsíjtyekéréjuco téhmétsoíñé tépallívú botsíi teene bajtso kéémévécooca tsáneevu dííbyeke ájcúímyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ehdúu ditye néérónáa neebe diityéke: —¿Aca tsá ámuha múijyú meéévetú Píívyéébé waajácúháámɨ? Muurá tsátsihdyu nééneé: Tsaúpe nééwayu jááháñé wákimyéi múnaa iñéhnílléne wáágóórou pícyámeí ímichi tééutu jaa éjkéiu. Muurá ihdyu Píívyéébere ehdu meenú tehdújuco. Ehdu muurá Píívyéébé waajácúháámɨtu nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aane ámúhakye o néé Píívyéébé avyéjú ámúhá wáábyuta íjcyájúcootúne. Muurá ihdyu tsijtye ímí óóma íjcyámé wáábyutáréjuco teéne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Muurá teeu nééwayúdú o néébedítyú íjcyáné uwááboju cáhcújtsotúmé mújtaáhi. Áámedívú muurá o cáyobáávatécooca ílluréjuco ditye wágóóóveíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ehdúu Jetsóó tsíeménéhjɨtu úwaabóné llúúvájté avyéjujtémá paritséómú waajácújucóó diityéké dibye lléboobóne. ");
INSERT INTO boaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Áánélliihyée imíllerómé dííbyeke iwáágoóné tétsihdyu. Árónáacáa nuhnévémé Píívyéébé ihjyú uubálle múnáajpi dibye íjcyane mɨ́amúnaa néhíjcyáneri iíllityénema. ");
INSERT INTO boaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Áhdurée tsiiñe Jetsóó úúballé muhdú Píívyéébe íavyéjú pámeemáyé ímíbájchoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Neebépeé: —Tsáné avyéjuubéhjáa ílli táábáváné wañéhjɨvu míñutsó mítyane mɨ́amúnáake. ");
INSERT INTO boaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ááme éllevúhjáa wálloobe íúníu múnáake ditye iñééte ditye itsájúcoóki. Aaméhjáa úúbálletérónáa tsá ditye ímílletú itsááneé. ");
INSERT INTO boaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Áánélliihyéhjáa tsíjtyeke tsiiñe iwállóómeke neébe: “Méneete táuubámyeke ditye itsááne íñe ocájímú tutácóóné idyóóvaki.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ahdújucóhjáa ipyééne ditye úúbállerónáa idyé tsá ditye ímílletú itsááneé. Ɨ́ɨ́cúvetúméhjáa íwákimyéiháñevúré péécunúhi. Tsaatéhjáa péé íúmɨhénevu. Tsijtyéhjáa péé náhjɨhévu. ");
INSERT INTO boaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Áánetúhjáa tsijtye íllure diityédí ɨɨ́cúbáhrámeke dsɨ́jɨ́vetsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aanéhjáa ílluréjuco diibye ávyéjúúbeke mítyane cáyobáávatétsóne. Áánélliihyéhjáa ítsodáhómuke táúhbaabe ditye diityéké ɨdsɨ́jɨ́vétsóne diityé cóómí icyátsuhjácoki. ");
INSERT INTO boaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ááné boonéhjáa idyé tsijtye íúníu múnáake neébe: “Tsúúca íñe hájchíwu táábáváné wañéhjɨ májchoháñé méénúmeíjyúcoorá téénevu tsáámeke memájchótsóiyóne. Ávyeta ímílléítyúmekéhjáa o míñutsójúcoorómé íñe tsá tsáátu meéllevu. Árone ihdyu óvi tehdújuco tsá ditye tsáátune, ɨ́mɨáámejɨ́ɨ́ tsááiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ahdícyane cána étsɨhjɨ́vú mepééne ámuha maájtyúmɨdúmeke méuubállé ditye itsáákií.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ahdújucóhjáa ditye pahúllevávú ipyééne pámeekéré iájtyúmɨdúmeke míñutsóné ímítyúróméhjɨmáye. Aaméhjáa tsúúca tsááme teeja wahpéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ááme éllevúhjáa diibye ávyéjuube ipyééne ájtyumɨ́ tsaapi ihdícyájamáyé íwajyámuma diityéj pɨɨne íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Áábekéhjáa neébe: “Muúbej, ¿acáne ɨ́veekí íñe átérééjamáyé u tsáá béhjávu úcáávéne tsáátuúbe?” Ehdúhjáa ávyéjuube dííbyeke néénéllii tsá dibye ɨɨná néétune. ");
INSERT INTO boaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Áábedítyúhjáa íúníu múnáake neébe: “Áánúke íjtyúháácyuma íhyójtsɨcu mechíjchúne áachívú peete íjcyátúhullévú mépicyóhjé téhulle dibye ityáá íhwáñe ɨɨ́hdónema.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ehdu nééne muurá íñe ɨ́mɨááné pámé wáábyutáréjúcooro Píívyéébé avyéjú íjcyáronévú uhjéméré úcááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ehdúu Jetsóó úwaabóné paritséómú itsárílléne pítyácójcatsí muhdú dííbyedívú iñéétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Áánemáhjáa Heróódé icyánéjcúejtémá tsaatéké íhdityu wallóómé dííbye éllevu ditye iñééte muhdúhjáa dííbyedítyú ipítyácójcatsíñe. Aamée itsááne dííbyeke nééhií: —Ávyéjuúbej, muha méwaajácú ɨ́mɨáábé u íjcyane állíútuúbe. Aabe muurá ú úwáábohíjcyá ɨ́mɨááné keená Píívyéébe mɨ́amúnáadívú tújkevééllejɨ́jtó tsijtye múhdurá úhdivu ɨ́jtsúcunúróneri ɨ́ɨ́cúvétuubére. Árómeke muurá pámeekéré tsahdúré ú ɨjtsúcunú muhdú ditye íjcyane u túhúúllétúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aabe ihdyu cána múúhakye diñe díicyánéjcutuj: ¿A tehdújuco ávyéjuube romáánómuube íjcyáábé wáábyuta dsɨ́ɨ́dsɨke ditye áhdótsohíjcyáné maáhdóiyónej, mityá tsáhaáj? ");
INSERT INTO boaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ehdúu íllure dííbyeke imújtátsóro ditye díllone iwáájácúne neebe diityéke: —Ávyeta mɨ́a bañú múnaa ámuha pánehjɨ́dú ɨ́mɨáámeúvúdú meíjcyame ¿ɨ́veekí íllure oke ámuha memújtátsóro mémávárijchóhi? ");
INSERT INTO boaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Áyu cána oke méuujétsó dsɨ́ɨ́dsɨjɨ́vuj. Ahdújucóo ditye tsájɨɨvu úújetsóné dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Áájɨtúu húmɨ náávee, memee, íjcyane ɨɨ́ɨ́téne neebe diityéke: —¿Aca múhúmɨ náávé eéne? Áhdure ¿mumémé eene tééjɨtu? ");
INSERT INTO boaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Áánélliihyée nééme dííbyeke: —Tséétsá húmɨ nááve. Áábe méméré íñe tééjɨtu. Áánélliihyée neebe diityéke: —Ané wa ihdyu diibye Tséétsáke mááhdohíjcyá dííbye éhnéjuco íjcyanévu. Áánetu ihdyu Píívyéébeke máácuhíjcyá dííbyé wáábyuta íjcyanévu. ");
INSERT INTO boaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ehdúu Jetsóó diityéké nééneri iúllévenúne ílluréjuco ditye pééne tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ááné boonée téjcoojɨ́ré tsadotséómú tsáá dííbye éllevu medsɨ́jɨvémé tsiiñe mebóhɨɨne cáhcújtsotúme. ");
INSERT INTO boaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aamée néé dííbyeke: —Ávyéjuúbej, Moitséeúvúhjáa muurá néé tsaapi méwadívú tsɨ́ɨ́mávátuube dsɨ́jɨ́véhajchíí íñahbéréjuco díílleke táábávaíñé dííbyeréjuco ɨtsɨ́ɨ́máva díílledívú íñáhbeúvúu tsɨ́ɨ́máváiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aanée ijcyámé múúhadítyú 7-meva tsané nahbému. Áámé amíaabée ityáábávárólléjtane dsɨ́jɨvé tehdu tsɨ́ɨ́mávátuubére. Áállekée bóneebéréjuco táábaváne. ");
INSERT INTO boaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ároobée idyé dsɨ́jɨvé téhdure tsɨ́ɨ́mávátuube díílléjtane. Aanée ehdu pámeere 7-meva tsaapíllekéré táábávarómé dsɨ́jɨvé díílléjtane. ");
INSERT INTO boaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aanée nihñévúré díílleréjuco dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aane cána múúhakye diñe ¿cáábyé taabá ímichi dille íjcyaíñé tsiiñe ditye bóhɨ́ɨ́coóca? ");
INSERT INTO boaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Áánélliihyée neebe diityéke: —Íllure ámuha mémujtá Píívyéébe ɨ́htsútuube íjcyáábé waajácúháámɨtu tene úwaabóné ámuha mewáájácútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Muurá dsɨ́jɨvémé tsiiñe bóhɨ́ijyu páneere cápáyóóveé tsíhdyuréjuco. Tsáhájuco muurá mɨ́amúnaa táábávácatsíityúne. Muurá pámeere téijyu íjcyaá níjkyéjɨ múnaáduréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Aca tsá ámuha meéévehíjcyatú Píívyéébé waajácuháámɨ? Muurá téhaamɨ́tú nééneé: ");
INSERT INTO boaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Aavaráaa, Itsáaa, Jacóóboo, íjcyámé Piivyéébé ó ijcyáhi.” Ehdu muurá Píívyéébe néénetu méwaajácú ditye íjcyane. Muurá ditye íjcyátuca tsá dibye nééítyuró diityé Piivyéébé iíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ehdúu Jetsóó diityéké nééneri ullévenúmé muhdú dííbyé tujkéveeju íjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aanée paritséómú iwáájácúne iiyéjuco píhcyaavéné dííbyedívu. ");
INSERT INTO boaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Áámedítyúu tsaapi taúhbájú uwááboobe Jetsóoke imújtátsóro nééhií: —Ávyéjuúbej, ¿aca teene Píívyéébé taúhbajúúnetu keená ímichi páñétúene? ");
INSERT INTO boaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Áánélliihyée neébe: —“Múu wajyú Dípiivyéébé Díavyéjuube íjcyáábeke ávyeta dɨ́ɨ́ɨ́búutúré páneere muhdú u íjcyáneri dɨ́ɨ́jtsaméiyi.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eene muurá ímichi páñétúene Píívyéébé taúhbajúúnetu. ");
INSERT INTO boaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Áánetu tsiiñe nééhií: “Pamévakéré múu wajyú muhdú u wájyúmeídyu.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Éneecu ímichi páñétúenéécú Píívyéébée Moitséeúvuj tééveri pícyóóné taúhbajúúnetu. Áneecu néhdu meíjcyáhajchíí tsúúca méijcyá dííbyé ihjyú uubálle múnaápe úwáábohíjcyádu. Ehdúu Jetsóó néé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Aamée diitye paritséómúi péétúmeke tsiiñe neébe: —¿Aca mújtsɨɨménémúhaabé Críjto íjcyáiyóné ámuha méɨjtsúcunúhi? Áánélliihyée néémeé: —Dabíiúvúj tsɨɨménémúhaabéiyo muurá diíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Áánélliihyée neébe: —¿Aanée idyé muhdú ɨ́ɨ́vane diibye Dabíiúvú ɨ́jtsɨɨménémúhaabe íjcyáííbyeke dilló íavyéjúúbedi? Muuráhjáa ihdyu Píívyéébé Apííchóré dííbyeke túkévéjtsóneri neebe dííbyedítyu: ");
INSERT INTO boaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ávyéjuubée néé Táavyéjúúbeke: “Cána táúniúvúi diicya dímunáake o táhjáné hajchóta.” ");
INSERT INTO boaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ehdúu muurá Dabíiúvú néé Críjtodítyú Íavyéjuube dibye íjcyane. Aane muhdú íjcyáíyoobe dííbyeúvúj tsɨɨménémúhaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ehdúu Jetsóó diityéké nééne iáñújcútúnéllii tsáhájuco tsiiñe ditye díllójúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Áijyúu idyé pámeere tétsii muha meíjcyámeke Jetsóó nééhií: ");
INSERT INTO boaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Muurá taúhbájú uwáábojtémá paritséómú ɨjtsúcunúmeí Píívyéébée Moitséeúvuj tééveri méénúné taúhbájú uwáábojte iíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɨ́mɨáánéhde tehdújuco ditye úwáábohíjcyáne. Aane melléébóne mécahcújtso. Árónáa ihdyu eene múhduhjɨ́rá ditye ícyahíjcyánetu tsá múu ɨ́ɨ́vatúne. Muurá ímí úwaabójúcoorómé tsá tehdu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aame mɨ́amúnáama tsíñéhjɨ́ taúhbajúúné ípívyétsohíjcyá diitye páñetu íjcyarómé teene úráávyénejɨ́ɨ́va awáá muhdú ditye iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Muurá páneere ɨɨná imyéénune méénuhíjcyámé mɨ́amúnaa diityéké imítyájtsokíye. Aame muurá eene Píívyéébé ihjyu icyáátúnúné waajácúhaamɨ́nevu pícyámeíhijcyá íñéjuwáánetu íúmɨcóónetu. Áhdure eene tsíjtyé wajyámúúné ehnííñevu íwajyámúúné icyáméjtsójácobájɨvu úcámeíhijcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aame muurá wañéhjɨ́né pañe imíllé íboohówátsɨhjɨ́vúré imájchone. Áhdure pihcyáávejááné pañe iíjcyácooca imíllémé íimítsɨjɨ́vúré iácuuvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Téhdure imíllémé mɨ́amúnaa diityéké iávyejúúlléne patsɨ́hjɨvávúré uwáábojtédí díllone. ");
INSERT INTO boaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Áánetu ámuha tahñéjté meíjcyame tsá múu tehdu néétune. Tsá múu íjyácunútú mɨ́amúnaa ámúhakye uwáábojtédí díllóíyóneri. Muurá ámuha tsahdúré tsané nahbémú meíjcyamé uwááboobe apáábyéré oo Críjtoó. ");
INSERT INTO boaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ahdícyane tsá ámuha múúbaké mecááníváityú ííñújɨri. Muurá níjkyéjɨri íjcyaabe apáábyéré ámúháj Caáni. ");
INSERT INTO boaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Áhdure tsá múu díllótsámeítyú ávyéjujtédi. Muurá oo apáábyéré ámúhá avyéjuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Muurá ihdyu tsíjtyeke ɨ́ɨ́cuvémé ɨ́mɨááné ijcyá ɨ́htsutúmé íboohówajte. ");
INSERT INTO boaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aame ɨdáátsóméhjɨúvú tsaɨ́ɨ́buwáré íjcyame ávyéjúúteéhi. Áánetu iiye ɨ́htsutúmé ávyéjujte iíjcyane némeíhijcyámé íllure núcójpɨ́vétsáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aane máɨdáátsoju ámúhakye tene pájtyeíñé bañú múnaa pánehjɨ́dú ɨ́mɨáámeúvúdú ámuha taúhbájú uwáábojtémá paritséómú meíjcyámeke. Muurá níjkyéjɨri íjcyaabe Píívyéébé avyéjúejte íjcyáíyómeke íllure ámuha mémáváríchohíjcyá múhdurá ténejcu ámuha meúráávyénélliíhye. Áánéllii tsá ámuha dííbyé avyéjúejte meíjcyáitúne. ");
INSERT INTO boaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ááneréi íjcyáíyónáa ¿ɨ́veekí ámuha pííbájyujte walléémudítyú médótuhíjcyá ihjyáháñe? Ááne ehdu ámuha meméénuhíjcyánéhjɨ́ nucójpɨ́ ulléjɨjtóné úniúúnevu ámuha meíjcyáne Píívyéébema cááménécobájɨúvú méihjyúvahíjcyá wáájácúratúne. Ehdu ámuha medárɨ́ɨ́vémeíhíjcyáné déjúcotu muurá ávyétá ɨhnáhó ámuha méɨ́cúbáhráméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Téhdure ɨ́veekí ámuha pahúllevá múnáake úwááboméré mépehíjcyá ámúhá uwááboju múhdurá nééne ditye iúráávyeki. Muurá ímítyúmeke éhnííñevúré ámuha métútávátsohíjcyá múhdurá meúwáábóneri. Áánéllii diityé hallúrí ápíchó cúújúwá pañévú ditye wágóóóveíñé ímichi ámúha llííñé íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Máɨdáátsoju ámuuha éhne múúne hállúvatúmé tsiéllevu tsátyéjcatsíiyódú menééme tsá mewáájácúmeítyú muhdú Píívyéébeke meúráávyéiyóne. Aame ámuha ménehíjcyá duurúvája mémerívá tsane ámuha meméénuíñé menéérone ámuha meméénúturóné muhdú néétune. Áánetúvá ihdyu tééjá pañéene óórótu méénúmeíñe mémeri tsane ámuha meméénuíñé menéérone ámuha meméénútúhajchíí ímityúné ámúhá hallúrí íjcyane ámuha ménehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aame ɨ́mɨááné ámuha méijcyá éhne múúne hállúvatúmé íjcyadu wáájácúmeítyúme. ¿Aca keená ímichi máavyéjúúlléiyáhi? ¿A teene tééjá pañéene óórótu méénúmeíñéhjɨj, mityá teeja duurúvaja ímichi tééja tájpí páñéenéhjɨ́ íjcyajaj? ");
INSERT INTO boaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Áhdure ámuha ménehíjcyá Píívyéébé ɨɨcúvé cóvájtsómeíñé waɨ́jɨ mémerívá tsane ámuha meméénuíñé menéérone ámuha meméénúturóné muhdú néétune. Áánetúvá ihdyu dííbyé ɨɨcúve mémeri ámuha tsane meméénuíñé menéérone ámuha meméénútúhajchíí ímityúné ámúhá hallúrí íjcyane ámuha ménehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aame ɨ́mɨááné ámuha méijcyá éhne múúne hállúvatúmé íjcyadu wáájácúmeítyúme. ¿Aca keená ímichi máavyéjúúlléiyáhi? ¿A teene Píívyéébé ɨɨcúve, mityá teene wáɨjɨ ímichi téɨjɨ́ hallúvú tene cóvátsómeíhíjcyaɨ́jɨj? ");
INSERT INTO boaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Muurá téɨjɨ́ mémeri tsane imyéénuíñé tsaate nééne dómajcó páneeréjuco múhduná téɨjɨ́ene íjcyánéhjɨmájuco. ");
INSERT INTO boaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Áhdure idyé duurúvája mémeri tsane imyéénuíñé ditye nééne dómajcó páneeréjuco tééjáene íjcyanéhjɨ́ Píívyéébe mémemájuco ímichi dííbyé wáábyuta tene íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Áhdure níjkyéjɨ mémeri tsane imyéénuíñé ditye nééne dómajcó Píívyéébekéjuco dííbyé avyéjú tene íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ahdícyane máɨdáátsoju ámúhakye tene pájtyeíñej! Muurá tehdújuco ámuha Píívyéébeke meɨ́ɨ́cúveróné ámúha bájtsori. Árónáa ámuha mécoévahíjcyá teenéjuco awáá taúhbájutu páñétúetsíí íjcyane Píívyéébeke ámuha meúráávyéne tsaímíyé meíjcyame tsíjtyeke mepɨ́áábóiyóne. Ehdu ámuha tsanéhjɨ́juco meméénúiyóné tsá meméénuhíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aame muurá ámuha éhne múúne hállúvatúmé tsiéllevu tsátyéjcatsíiyódú wáájácúmeítyúme. Muurá éétébáwu íjcyáróóbeke ámúha ádó pañétú ámuha mewáágoómé ¿ɨ́veekí caméélloke wáágóotúmé dííbyemáyé ámuha máádohíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Máɨdáátsoju ámúhakye tene pájtyeíñej! Muurá ámúhá lliyíhllóné, ámúhá bohtámú, ámuha ménítyuhíjcyará imíwu. Árónáa ténéhjɨ́ pañévú ámuha mépícyohíjcyá ímityúné naníyí ámuha meúcuhíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Aame ámuha ɨ́mɨááné hállúvatúmé íjcyadu menééme tujkénú méímibáávyé ámúhá ɨ́buwááné ɨ́jtsaméí ɨ́mɨáámeréjuco ámuha meíjcyane ámúhadítyú ibóhówaúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Árónáa ihdyu máɨdáátsoju ámúhakye tene pájtyeíñej! Muurá ámuha pánehjɨ́dú ɨ́mɨáámédú éhne múúne níjkyéné pañe nehníwu néérone pánehjɨ́dú hállu imíwu meɨ́ɨ́tedu. ");
INSERT INTO boaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ehdu ámuha meícyahíjcyá mɨ́amúnáama pánehjɨ́dú ɨ́mɨáámeúvúdú tsanééré ímítyúné ɨ́jtsaméí ámúhá pañe íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Áámeke ámúhakye máɨdáátsoju tene pájtyeíñej! Ɨ́veekí ámuha éíjyuúvúu ditye dsɨ́jɨ́vétsohíjcyámé Píívyéébé ihjyú uubálle múnáaúvú nijkyéné méícyáávétsohíjcyá ɨ́mɨáámeváa diityéúvú íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ááne ámuha ménehíjcyáhi: “Éíjyuúvúu méɨhdé múnáaúvú íjcyáijyu meíjcyaca muurá tsá medsɨ́jɨ́vétsóítyuró Píívyéébé ihjyú uubálle múnáake.” ");
INSERT INTO boaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ehdu ámuha menééneri muurá ámuháyé méúúbállémeí diityéúvukée dsɨ́jɨ́vétsohíjcyámeúvúj tsɨɨménémúhaabe ámuha meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ahdícyane wa ihdyu oke meméénú ámuha meímillédú ámúhá ɨhdé múnáaúvúu méénuhíjcyádú diityédúré ámuha menéémeé. ");
INSERT INTO boaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ávyeta muurá ámuha ííñimyémúeméjte. ¿Aca ámuha méɨjtsúcunú cúújúwatu ámuha mepállójcóiyóne? ");
INSERT INTO boaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Áánéllii ícyooca ó pícyóóroó ámúhama tsíjtyeke Píívyéébé ihjyú uwáábojte pane wáájacúmeke ámúhá uwáábojte íjcyáímyeke. Árómeke muurá ámuha méúráávyehíjcyaá pátsáríjcyoméré pacóómiváríye. Áámedítyú muurá tsaatéké ámuha méwátsíhcyuú pihcyáávejááné pañévu. Ááne tsááteke ámuha médsɨ́jɨ́vétsoó páwachékevu mewátyétyéhcúneri. ");
INSERT INTO boaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ehdu ámuha menéénéllii ámuha pámé hallúríyé teene éíjyuúvúu ɨ́mɨá uwáábojtéké ditye dsɨ́jɨ́vétsohíjcyanéhjɨ. Muuráhjáa Abéé ɨ́mɨáábé íjcyáábeke íñahbéré dsɨ́jɨ́vetsóhi. Ááné boonée tsijtye Píívyéébé ihjyú uubálle múnáake ámúhá ɨhdéejte dsɨ́jɨ́vetsóhi. Átsihdyúu nihñéré dsɨ́jɨ́vetsómé Berekíá hajchi Tsacaríake duurúvájama Píívyéébé ɨɨcúvé cóvátsómeíhíjcyáné waɨ́jɨ́ ráhoúcunútsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aane ɨ́mɨááné ámúhakye o néé ehdúu éíjyu múnáaúvú dárɨ́ɨ́vémeíhijcyáné muurá ámúhá hallúrí íñe ícyooca ámuha meíjcyámé hallúri. ");
INSERT INTO boaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ahdícyane ámuúha Jerotsarée múnaaj, ¿ɨ́veekí ámuha mélliihyánúpétsohíjcyá Píívyéébé ihjyú uwáábojtéke? ¿Ɨ́veekí ámuha diityéké néwayúúnevu mááámuhíjcyáhi? Muurá imílléroobe ámúhakye iújcune éhne múúne cáraca ɨ́ɨ́tsɨ́ɨ́meke íhñúwáácyú lliiñévú újcudu. Árónáa ¿ɨ́veekí tsá ámuha meímíllehíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ááné déjúcotu muurá ámúha cóómí ápajyúréjuco íjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ahdícyane ámúhakye o néé téhdure oke ámuha maájtyumɨ́júcóóityúné tsiiñe o tsááiñévújuco. Téijyu muurá ámuha oke maájtyúmɨ́ne méneéhi: “Maímijyu áánu Píívyéébe mémeri tsááneéj.” ");
INSERT INTO boaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aabée Jetsóó duurúvájá pañétú muha meíjchívyénáa múúha tsúúlleríjyuco péébeke muha mépɨ́uvá téjahjɨ imíwu méénúmeíñé muha meɨ́ɨ́teki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aamée muha meɨ́ɨ́témeke neébe: —¿A ámuha méɨɨté imíwu duurúvaja méénúmeíñe? Muurá ɨ́mɨáánetúré ámúhakye o néé ehdu nééroja wácávyáhcámeíiñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Átsihdyúu muha oríívó bajúvú mepétsihvu ácúúvéébeke áábánéwu muha menééhií: —Cána múúhakye duubállé múijyú tene pájtyeíñé eene múúhakye u néhíjcyanéhjɨ. ¿Aca ɨ́ɨ́netú muha méwaajácuú ííñujɨ nɨ́jkévaíñeréjuco u tsááiñe pɨ́ɨ́hɨ́jucóóne? ");
INSERT INTO boaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Áánélliihyée neebe múúhakye: —Éhdu nééme tsáma wajácútsi méíjcyaco ámuha maállítsámeítyu állíu múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muurá o tsááiñe tsúúca pɨ́ɨ́hɨ́cooca íjcyaímyé mítyame óhdi díllómeímye. Aame nehíjcyaá diibyéjuco Críjto iíjcyane. Aane mítyame cáhcújtsoó bañúháñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Áhdure íjcyaíñé méénujcátsí pahúlleváre. Árónáa méíllityédíñe. Muurá tsáhái téijyu o bóhówáávéityúne. Árónáa ihdyu ehdu nénehjɨ tujkénú pájtyeéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Muurá tsáné iiñújɨ múnaa méénújcátsií tsííñé iiñújɨ múnáama. Áijyu íjcyaíñé ájyabáánema cheméháñe. Áhdure pahúlleváré ííñujɨ vááúméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ehdu déjúcóóveíñé ɨ́cúbáhraméí ííñújɨri. ");
INSERT INTO boaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Áijyu muurá ámuha tahñéjté meíjcyáné hallútú cáhcújtsotúmé ámúhakye itsárílléne ámúhadi ɨ́cúbáhraáhi. Aame ámúhadítyú tsaatéké dsɨ́jɨ́vétsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Áijyu muurá mítyame amúhadítyú oke cáhcújtsorómé tsáhájuco oke cáhcújtsóityúne. Aame ámúhakye itsárílléne ámúhadívú méénútsoó tsíjtyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Áhdure idyé téijyu mítyame állíu múnaa díllóméií Píívyéébé ihjyú uubálle múnáadi. Áámedívú mítyame állítsáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ehdu páhduváré ímityúné íjcyánetu mítyame tsáhájuco wájyúcatsíityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Áánetu ehdu néérónéhjɨ́ pañe Píívyéébeke ɨ́hvéjtsotúmé tsaímíyé íjcyame ihdyu pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Muurá teene dííbyé avyéjutu íjcyáné uwááboju ɨ́mɨáájú pámeekéréi ííñújɨri íjcyáné mɨ́amúanáake waajácútsáméiíhi. Áijyu ihdyu botsíi ó tsaá páneere ílluréjuco ɨnɨ́jkévaki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Muurá duurúvájatu tsátsii ɨ́ɨ́né imítyúné úújéítyútsihvu tsane ímityúné úújeténé Píívyéébeke ávyéta tsáríyé pájtyeéhi. Ahdícyane teene ámuha maájtyúmɨ́cooca méwáácunúcó cáméhbaúnevu Jodéá iiñújɨ múnaa ámuha meíjcyame. Ehdúu ɨ́mɨááné tene pájtyeíñé muurá Daniéré tsúúcajátújuco nééne Píívyéébé ihjyú uubálle múnáajpi íjcyaábe. Aane éévehíjcyámé íhya waajácújucóó ɨɨná íjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ahdícyane téijyu áachi íjcyame íúcaavéjúcohdí ɨ́mɨjcóhó pañévú tsíeméné iújcuki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Áhdure íúmɨhé pañe íjcyame íoomíjyúcohdí ihjyávú íwajyámu éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Máɨdáátsoju tsáma tene pájtyeíñé téijyu walléémú éévájtema tsijtye ñohñóríyéi ɨ́ɨ́tsɨ́ɨ́méwuúmú íjcyámeke! ");
INSERT INTO boaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Áánéllii ihdyu Píívyéébema méihjyúvaco wáyeéévejcóójɨ́ ehdu tene ámúhama ipájtyétuki, áhdure tsúcohɨ́váneri úúníjyáijyu nííjyáháñé lliine ámuha mewáácunútuki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Muurá téijyu íjcyaíñé ávyétá ɨhnáhó ɨ́cúbáhraméí íñée ííñujɨ ípívyéévétsihdyu múijyú ícyahíjcyatúne. Ááné boonétú ihdyu tsáhájuco múijyú tehdu nééné ɨ́cúbáhraméí íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aane muurá Píívyéébe oke wállóótuca pámeere dsɨ́jɨ́véiyáhi. Áánéllii ɨ́ɨ́cúi tsiiñe oke wállóóiibye ihñéjte wájyuri. ");
INSERT INTO boaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aane tsúúca tene pɨ́ɨ́hɨ́cooca íjcyaímyé tsaate íllure iállíñe ‘tsúúca Críjto tsájucóóhií’ nééimye. Áámeke tsáma wajácútsi meíjcyáne mécáhcújtsodíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Muurá íjcyaímyé állíu múnaa iiye Críjtodi díllómeímye. Áhdure muurá díllómeíimye Píívyéébé ihjyú uubálle múnáadi. Aame piivyéteé méénúráítyúronéhjɨ́ imyéénune. Ááneri muurá mújtátsoímyé mɨ́amúnáake Píívyéébedítyu. Tsáijyu múúne téhdure mújtátsóiyómé ɨ́mɨááné dííbyeéjtéjuco íjcyárómeke. ");
INSERT INTO boaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aane íñe ámúhakye ó úúballé ɨ́hdéjuco ehdu tene pájtyeíñé ámuha metéɨ́búwááveki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ahdícyane tsaate ámúhakye ‘éje, áádi éhlle Críjtoó’ néhajchíí mépehdí téhullévu. Áhdure ditye ámúhakye ‘áádi éhjá pañe Críjtoó’ néhajchíí mécáhcújtsodí éhduhjɨ ditye ámúhakye néérone. ");
INSERT INTO boaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Muurá ihdyu éhne múúne chijchi ááméjutu nɨ́jkéniiñévújuco rórihjyácódú ámúhakye ábájɨ́néjcuíñé Mɨ́amúnáájpidívúu o ípívyééveebe tsiiñe o bóhówááveíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Áábedívú muurá óhdivu táuráávye múnaa píhcyááveé éhne múúne tsíeméjpí dsɨ́jɨ́véébedívú áñumu píhcyaavédu. ");
INSERT INTO boaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ehdu ɨ́cúbáhraméí pájtyéné boone cóójɨ́ejpi nuhba ílluréjuco áábatéiñe. Áhdure péjcóejpi tsáhájuco ájchúityúne. Áijyu mɨ́ɨ́curu dójcoó cáámetu. Ehdu páneere íévéhóówari ɨ́htsútunéhjɨ́ íjcyane mujtáraba íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Áijyu tsúúca Mɨ́amúnáájpidívúu o ípívyééveebe páneere táɨhtsútú táavyéjuma ojtsó pañétú ó bóhówááveéhi. Ááneri muurá oke cáhcújtsotúmé ííñújɨri íjcyame iíllityéne taáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aabe téijyu níjkyéjɨ múnáake ó táúhbaá ditye kéévánécoba illíjchu írojrócó pámeere múhdumé ííñújɨri íjcyáné mɨ́amúnaa tahñéjté óhdivu ipíhcyááveki. ");
INSERT INTO boaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cáhawáá méɨjtsúcunu higyéérahej. Muurá itsóúúvéne tsiiñe tehe béhjɨ́vánetu méwaajácú píjcyaba pɨ́ɨ́hɨ́jucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ahdu nééne íñe ámúhakye o nénehjɨ pájtyénetu ámuha méwaajácuú tsiiñe o tsááíñe éévé tsúúca úújeténe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Muurá ɨ́mɨáánetúré ámúhakye o néé ehdu nénehjɨ pájtyeíñé íñéi ííñújɨri mɨ́amúnaa íjcyápíñáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Muurá íñe ííñújɨma páneere íévéhóówari íjcyanéhjɨ́ wágóóóveéhi. Áánetu íñe ámúhakye o néhijcyáné tsá múijyu wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Árónáa ihdyu o tsááíñe éévé tsá múha wáájácutúne. Níjkyéjɨ múnaa íjcyarómé tsá wáájácutúne. Téhdure páñetu Píívyéébé Hajchi o íjcyároobe tsá o wáájácutúne. Apáábyéré ihdyu Llihíyó waajácú múijyú tsiiñe oke iwállooíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Muuráhjáa Noéé íjcyáijyu íjcyáné mɨ́amúnáake tene pájtyedúré pajtyéiñe Mɨ́amúnáájpidívúu o ípívyééveebe tsiiñe o tsááiñe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muuráhjáa téijyu íjcyame ííñujɨ cáájávéíñé ɨhde ‘ɨɨnéjuú’ iñééne ícyahíjcyá iímillédú wañéhjɨ́neri táábávajcátsiyi. Ehdúu ícyahíjcyámé tsúúca Píívyéébe ííñujɨ cáájávétsóíñéllii Noéé ɨhmɨ́ɨ́né pañévú úcáávétsihvújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aamée ehdu iícyahíjcyáneríyé túhuuvémé wáájácúmeítyúnáa tsúúca páneere ííñujɨ cáájávénetu tsáhájuco ditye píívyetétú muhdú ipájtyeténe. Áhdure ɨ́ɨ́vane muurá mɨ́amúnaa iímíllénéhjɨríyé íjcyánáa Mɨ́amúnáájpidívúu o ípívyééveebe tsiiñe o tsááne ábájɨ́néjcuú diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Téijyu muurá míítyétsi wákímyeíhíjcyámútsidítyú tsáápiikye wáájácúratúné o újcúnetu tsijpi tétsihvúré coévaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Áhdure tsaatépɨ́ cáátsohíjcyámúpɨdítyú tsáápílleke o újcúnetu tsíjpille coévaá tétsihvúre. ");
INSERT INTO boaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Áánéllii tsáma téɨɨbúwá méíjcyaco tééné ɨjtsúcunúre. Muurá tsá mewáájácutú múijyú o tsááiñe ámúhá avyéjuube o íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Muurá tsaapi ihjya cúwátuube téhmé péjcóvéiyá naní múnaa tépejco dííbye éhnénéhjɨ́ nániíñé iwáájácuca. Aabe muurá tsá náníchóítyuró ihñénehjɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ahdu tsáma téɨɨbúwá méíjcyaco naní múnáake tsaapi téhméiyódu. Muurá ámuha meɨ́jtsótúnáa ó tsaá Mɨ́amúnáájpidívúu o ípívyééveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Muurá tsaapi tsaímíyé íavyéjúúbema wákímyeííbyeke pícyoobe ihyájkímú tehméébedívu. Aabe diityéké ímí ɨ́ɨ́cuvé tééne tájpí ditye íjcyáíñéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ahdícyane maímijyu dibye íjcyane íwákimyéiyi íjcyáábeke íavyéjuube ájtyumɨ́vaábe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aane ɨ́mɨááné ámúhakye o néé ɨ́mɨáábé íjcyáábeke íavyéjuube ihñévú téhmetsóne. ");
INSERT INTO boaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Áánetu íjcyaabe tsaapi ímítyuube íavyéjuube ‘ɨ́ɨ́cúi óómíityúné’ iñééne íwákimyéí ɨɨbúwá íjcyátuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ehdu néébe muurá íllure ihyájkímuke imyéénúne iímillédú wañéhjɨ́neríyé pehíjcyá tsíjtyéhjɨma llíyíícyáveebére. ");
INSERT INTO boaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aabe ehdu ícyahíjcyánáa muurá íavyéjuube óómiibye tuvááová dííbyeke dibye ɨ́jtsótúnáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Áábeke muurá ílluréjuco dibye ɨ́hnáhó ɨ́cúbahráné ímityúmé bañú múnaa pánehjɨ́dú ɨ́mɨáámeúvúdú íjcyámeke imyéénudu dibye ityáá íhwáñe ɨɨ́hdónema. Ahdu muurá pajtyéiñe mɨ́amúnáama tsiiñe o tsáácoóca. ");
INSERT INTO boaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Muurá idyé níjkyéjɨri íjcyaabe Píívyéébé avyéjú tsaatéhjáa 10-meva bádsɨjca tsáápíllé tajɨ íjcyáííbyeke peetémá téhmehíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Diityédítyúhjáa 5-meva ímuhdúrejte. Áánetúhjáa téhduméré 5-meva ɨ́ɨmɨ́ajte. ");
INSERT INTO boaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aaméhjáa diitye ímuhdúrejte tsá tsájtyetú ícyuujúwájpacyóné ipyéété ipáñénuíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Áánetúhjáa ihdyu ɨ́ɨmɨ́ajte tsajtyé ícyuujúwájpacyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aaméhjáa wájtsɨ́pítyúúbeke tépejco ityéhmehíjcyáróne icyúwávénéllii ílluréjuco cúwane. ");
INSERT INTO boaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Árónáacáhjáa tsúúca pécójpɨɨne tsaate kéévánécoba nééhií: “¡Tsúúca tsaabe ámuha metéhmehíjcyaábe! ¡Wa mécáhdahɨ́roj!” ");
INSERT INTO boaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ahdújucóhjáa ditye iájkyéne ɨ́ɨ́cúi íjcyátsíiivyéjucóóné ipyééteháñema. ");
INSERT INTO boaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Áánáacáhjáa diitye ímuhdúrejté cuujúwajpácyó tsúúca óuuvéhi. Áánélliihyéhjáa diitye ɨ́ɨmɨ́ajtéké neeróme: “Cána óvíjyuco múúhakye ámúhá cuujúwájpácyotu tsánéhwuúvú maájcuj. Tsúúca múúhadívú múúhá cuujúwajpácyó óuuvéhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Árónáacáhjáa nééme diityéke: “Tsáhaá. Muurá ehdu meméénúhajchíí méhdivu óúúveíñé tsaméhjɨdívújuco. Wa ihdyu tsiiñe máahdótej.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ahdújucóhjáa ditye ahdóvúi pééné hallúrí tsúúca wájtsɨ́ɨ́bema ditye úcaavéné teeja dibye wáñehjɨ́vatéíjyá pañévu. Áámé hallúvúhjáa ílluréjuco dibye tééjá lleehówá wátajcóné múha iúcaavéjúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ááné boonéréjucóhjáa diitye ímuhdúrejte iwájtsɨ́ne llééhowa dibye ipááyúcúro wátótóhcoméré nééneé: “¡Ávyéjuúbej, Ávyéjuúbej, múúhakye paayúcu!” ");
INSERT INTO boaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Árónáacáhjáa neebe diityéke: “Tsá o wáájácutú ámúhakye.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ehdúu iúúbálléne múúhakye Jetsóó nééhií: —Téhdu ámúhakye tene ipájtyétu tsáma ímíñeúvú meíjcyátsííívyéne oke méɨ́tsohíjcyaco. Tsá muurá mewáájácutú múijyú tsiiñe o tsááiñe Mɨ́amúnáájpidívúu o ípívyééveébe. ");
INSERT INTO boaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Téhdure níjkyéjɨri íjcyaabe Píívyéébé avyéjú wákimyéí tsáné avyéjuube tsííñé iiñújɨ́ iááhɨ́veté íwákimyéi múnáadívú ɨdsɨ́ɨ́dsɨke téhmétsoíñúdu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tsáápihdívúhjáa pícyoíñuube 5,000-jɨva, tsíjpihdívúhjáa 2,000-jɨva, tsíjpihdívúhjáa 1,000-jɨva. Ehdúhjáa diityéké ɨɨ́jtsúcunúdunéhjɨ́ iwájtúne peebe diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ááné hallúríhjyáa diibye 5,000-jɨvámá íjcyaabe náhjɨhe meenú téénema. Ááneríhjyáa llíyaatétsoobe dííbyema tsiiñe éhnííñevu 5,000-jɨva. ");
INSERT INTO boaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Áhduréhjáa idyé tsijpi 2,000-jɨvámá íjcyaabe náhjɨhe imyéénúneri llíyaatétsó tsiiñe éhnííñevu téhdunéré 2,000-jɨva. ");
INSERT INTO boaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Áánetúhjáa tsijpi 1,000-jɨváré dibye ájcuíñuube íllure cuuú teene dsɨɨdsɨ wákímyeíchótuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Áánáacáhjáa diityé avyéjuube tsúúca wajtsɨ́ diityédívu. Aabéhjáa ímíbajchóvá diityémá teene diityékée ityéhmétsoíñúne dsɨ́ɨ́dsɨ́ muhdú ditye téhmene. ");
INSERT INTO boaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tujkénúhjáa ímíbájchoobe 5,000-jɨvávúu iájcúúbema. Aabéhjáa néé dííbyeke: “Ávyéjuúbej, okée éhne 5,000-jɨvávú u ájcune muurá íñeé. Áánetújuco íñe tsiiñe éhnííñevu téhdunéré 5,000-jɨva o llíyaatétsóne.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Áánélliihyéhjáa neebe íavyéjuube dííbyeke: “Tehdújuco, ávyeta ɨ́mɨáábé uu ímí tehdújuco u wákímyeííbye. Muurá múhdurá néérone ímí ú tehméhi. Áánéllii ícyooca éhnííñevu íjcyane díhyójtsɨ́ pañévú ó ɨ́hvéjtsoó u téhmeki. Ahdícyane óvíi ílluréjuco u ávyéjuuténe. ");
INSERT INTO boaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Áábé boonétúhjáa tsijpi 2,000-jɨvávúu ityéhmétsóóbema idyé ímíbájchoóbe. Aabéhjáa idyé néé dííbyeke: “Ávyéjuúbej, okée éhne 2,000-jɨvávú u téhmétsoíñúné muurá íñeé. Áánetújuco íñe tsiiñe éhnííñevu téhdunéré 2,000-jɨva o llíyaatétsóne.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Áánélliihyéhjáa idyé neebe íavyéjuube dííbyeke: “Tehdújuco, ávyeta ɨ́mɨáábé uu ímí tehdújuco u wákímyeííbye. Muurá múhdurá néérone ímí ú tehméhi. Áánéllii ícyooca éhnííñevu íjcyane díhyójtsɨ́ pañévú ó ɨ́hvéjtsoó u téhmeki. Ahdícyane óvíi ílluréjuco u ávyéjuuténe.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ehdúhjáa tsaatétsima iímíbájchótsihdyu ɨ́ɨ́neebe ípyée 1,000-jɨvávúré iájcúúbedívu. Aabéhjáa íllure néé dííbyeke: “Ávyéjuúbej, ópée ó waajácú múhdurá u néébe uure u wákímyeíñé hallúvú dsɨ́ɨ́dsɨ́jɨke u ékéévehíjcyatúne. Muuráhjáa ɨ́htsútúnetu o llíyaatétsóné dsɨɨdsɨ́jɨ́ ɨ́mɨátsíí páneere úhdivúré ú újcúiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Áánélliihyée íllure ó cuuú dɨdsɨ́ɨ́dsɨke. Aane íñe dɨdsɨ́ɨ́dsɨ.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Áánélliihyéhjáa íavyéjuube néé dííbyeke: “¡Ávyeta ímítyuube uu óvéhe múnáajpi táwákimyéi múnáadítyu! ¿A éhdurée ú meenú teene tadsɨ́ɨ́dsɨke ‘o wákímyeítyúroobe dsɨ́ɨ́dsɨ́jɨke o ékéévehíjcyáné’ u néénema? ");
INSERT INTO boaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aanéhdée ihdyu ditye dsɨ́ɨ́dsɨke téhmehíjcyájáúbá pañévúré ú pícyóóiyá tene óóma illíyaatéki. Aacáa muurá ícyooca ó wajtsɨ́iyá éhnííñéwuúvújuco tene llíyaaténáaáca.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ehdúhjáa dííbyeke iñétsihdyu neebe tsaatéké tétsihyi íjcyámeke: “Áábyedítyú eene 1,000-jɨva íjcyane dsɨɨdsɨ medójtúcúne maájcú áádíkye eene 10,000-jɨva ɨdsɨ́ɨ́dsɨ́ íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Muurá múúne ihñe llíyaatétsómeke éhnííñevu tsiiñe máajcú ditye illíyaatétsoki. Áánetu ihñe pevénéré pícyohíjcyámedítyú ílluréjuco medójtucúné páneere diityédí íjcyaróne. ");
INSERT INTO boaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ahdícyane áádikye ɨ́ɨ́néubárá óóma wákímyeítyúúbeke méwaagóote peete íjcyátúhullévú dibye ityáá íhwáñe ɨɨ́hdónema.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Muurá Mɨ́amúnáájpidívúu o ípívyééveebe múijyú tsiiñe o tsáácooca ó tsaá ɨ́htsútuubéréjuco avyéjuube o íjcyaabe tahñéjté níjkyéjɨ múnáama. Áijyu táavyéjú ijyáwá hallúrí ó ácuúcúnuúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Áábedívú óhdivu páneere ííñújɨri íjcyáné mɨ́amúnaa pícyáávémedítyú ó dówajcároó tsaatéké íhdyúétsihvúré éhne múúne obééjámudítyú cáávarámuke ítyehméébé dówajcáródu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aame diitye obééjámudi o díllome óóma íjcyaáhi. Áánetu cáávarámudi o díllome tsiélléré íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Áijyu eene óóma íjcyámé avyéjuube o íjcyaabe diityéké ó neéhi: “Muuráhjáa Llihíyó ámúhakye ííñujɨ iípívyéjtsótúné ɨhdéjuco ityújkevééllémeke wábyujtsódújuco íñe ámuha óóma táavyéjuri. ");
INSERT INTO boaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Muuráhjáa o ájyabáávatéébeke ámuha oke mémáchótsohíjcyáhi. O ádóíyóneríi o íjcyáábeke ámuha oke méíchohíjcyáhi. Wáájácúrátuubée úlleebéré o péhíjcyáábeke ámuha oke mécúwátsohíjcyá ámúhá jaaháñevu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","O wájyamúúvátúúbekée ámuha oke máajcú wájyamúvu. O chéméébekée ámuha oke méúújehíjcyáhi. Cúvéhóójaríi o íjcyáábeke ámuha oke méúújehíjcyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ehdu o néénéllii muurá diitye ɨ́mɨájté óóma íjcyame oke neéhi: “Ávyéjuúbej, ¿acáa múijyú u ájyabáávatéébeke uke muha mémájchotsóhi? ¿Múijyúhjáa ádópiyi u íjcyáábeke uke muha méijchóhi? ");
INSERT INTO boaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Áhdurée múijyú múha uke wáájácútuube u úlléébeke uke muha mécúwátsohíjcyá múúhá jaaháñevu? ¿Múijyúhjáa u wájyamúúvátúúbeke uke muha máajcú wájyamúvu? ");
INSERT INTO boaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Acáa múijyú u chéméébeke uke muha méúújehíjcyáhi? Áhdure ¿acáa múijyú cúvéhóójari u íjcyáábeke uke muha méúújehíjcyáhi?” ");
INSERT INTO boaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ehdu muurá oke ditye néénéllii ó neé diityéke: “Muuráhjáa ihdyu ehdu ámuha tahñéjteke ɨ́ɨ́técunútúméré panévatúré mepɨ́áábohíjcyáneri ookéjuco ámuha meɨ́ɨ́cúvehíjcyáne.” Ehdu ó neé óóma íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Áánetu óhdityu tsiélléré íjcyámeke ó neéhi: “Méɨɨne óhdityu ámúhá imítyú nɨ́jcaúvú ámuha méwágóóóveímye. Muurá ámuha méwágóóóveé ihyájkímuma Naavéné wágóóóvéíñé cuujúwá pañévú múijyú ámuha meíjchívyéítyúhullévu. ");
INSERT INTO boaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Muuráhjáa tsá ámuha oke memáchótsohíjcyatú o ájyabáávatéébeke. Tsáháa ámuha oke meíchohíjcyatú ádópiyi o íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Áhdurée wáájácúrátuube o úlléébeke tsá ámuha oke mecúwátsohíjcyatú ámúhá jaaháñevu. O wájyamúúvátúúbekée tsá ámuha oke maájcutú wájyamúvu. Tsáháa ámuha oke meúújehíjcyatú o chéméébeke. Tsáháa ámuha oke meúújehíjcyatú cúvéhóójari o íjcyáábeke.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ehdu o néénéllii muurá oke neeímye: “Ávyéjuúbej, árónáacáa tsá múijyú uke muha maájtyúmɨtú u ájyabáávatéébé ádópiyi u íjcyáábeke. Tsáháa múijyú úlleebéré u péhíjcyáábeke uke muha maájtyúmɨtúne. Áhdurée tsá múijyú muha maájtyúmɨtú wájyamúúvátuube u íjcyáábeke. Áhdurée tsá muha mewáájácutú u chémene. Áhdurée tsá muha mewáájácutú cúvéhóójari u íjcyane. Aanéjɨ́ɨ́varíi muhdú uke muha mépɨ́áábóiyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ehdu oke ditye néénéllii ó neéhi: “Muuráhjáa tahñéjteke ámuha mepɨ́áábohíjcyátúneri téhdure ookéjuco ámuha meéhdɨɨvállehíjcyáne.” Ehdu ó neé óhdityu tsiélléré íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aame ílluréjuco wágóóóveíñé múijyú nɨ́jkéváityúné ɨɨ́cúbáhrámeííhullévu. Áánetu ihdyu ɨ́mɨáámé pájtyéteé muhdú íjcyáityúmeréjuco ɨ́ɨ́né imíjyaú iíjcyáki. ");
INSERT INTO boaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ehdúu Jetsóó iñééné boone tsiiñe múúhakye nééhií: —Muurá míjcyoojɨ́cutúréjuco pajtyété wañéhjɨ́ lléévaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ááné pañe muurá Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi ékéévétsoó tsaatéke. Aame oke dsɨ́jɨ́vétsoó páwachékevu iwátyétyéhcúneri. ");
INSERT INTO boaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aanéhjáa ɨ́mɨááné téijyu teene wañéhjɨ́ tujkéveri páñétúejpi llúúvájté avyéjuube Caipáa jávú píhcyaavémé tsijtye llúúvájté avyéjujtee, túkevéjtsojtee, taúhbájú uwáábojtee, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aaméhjáa pítyácójcatsí muhdú dííbyé hallúvú iállíñe dííbyeke iékééveíñé ɨdsɨ́jɨ́vétsoki. ");
INSERT INTO boaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aaméhjáa néjcatsíhi: —Tsáhái íñe wañéhjɨ́ pañe tehdu meméénúityú mɨ́amúnáake meííbórɨ́núíyónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Áijyúu muha Betáániárí Tsimóó dííbyere ‘Ahllárɨho’ némeííbyé jari. ");
INSERT INTO boaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Áánáacáa tsáápille tsáá Jetsóo éllevu pácúúcujpácyó mítyane áhdómeíjpácyoma. Ájpacyóríi múríjcholle íhñíwau majchórí íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aanée múúhakye tsaríwu pájtyénéllii muha menééhií: —¿Ɨ́veekíami aalle ɨ́cúbahra pácúúcújpácyorij? ");
INSERT INTO boaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Muurá téjpacyo menáhjɨ́hénúne dsɨ́ɨ́dsɨri mépɨ́áábóiyá ɨ́dáátsóméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ehdúu muha menéjcatsíñé illéébóne múúhakye neébe: —¿Ɨ́veekí ámuha méihjyúvá áámyédityu? Muurá ihdyu tehdújuco dille méénune. ");
INSERT INTO boaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Muurá diitye ɨ́dáátsojte tsá kiávú ámúhadítyú pééityúne. Áánetu tsá múhajchótá ámúhama o íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Áánéllii oke téjpacyórí múríjcholle oke ditye cúúúíñé ɨhde tájpi iímíbajchóne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aane ɨ́mɨáánetúré ámúhakye o néé íñe tajtyééveri mɨ́amúnaa pájtyetéíñé uwááboju úwáábohíjcyámé muurá idyé teene úúballéné pámeere ííñújɨri íjcyáné mɨ́amúnaa waajácuúhi. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Aanéhjáa téijyu Jóóda Ijcaríóóté tsaapi muuha 12-meva meíjcyáméejpi íjcyároobe múijyúrá llúúvájté avyéjujté éllevu ipyééne neeté diityéke: —¿Aca múhduná íñe oke ámuha mááhdóiyá ámúhakye Jetsóodívú o wáájácutsóne? Ehdúhjáa dibye néénéllii ahdómé 30-jɨva. ");
INSERT INTO boaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aanéhjáa diityémá ipítyácójcatsíñé tsúúca iímíbáchójcatsíñéllii ɨ́tsámeíhíjcyaabe muhdú dííbyedívú iékéévétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aanée teene pajtyété wañéhjɨ́ óórítyúne pááá májchómeíhíjcyáné wanéhjɨ́ tújkévajcóójɨ́ muha Jetsóoke menééhií: —¿Kiávú ú imíllé wañéhjɨ májchó muha meméénune? ");
INSERT INTO boaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Áánélliihyée neebe múúhakye: —Cáhawáá mepe Jerotsaréevu éhne tsúúca wájácú ámuha menéébe jávu. Áábeke méneeco tsúúca muhdú o íjcyáíñe éévé pɨ́ɨ́hɨ́júcóónéllii dííbye jávú ámúhama íñe wañéhjɨ́ o pájtyeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ahdújucóo tsaate múúhadítyú ipyééne teene majcho dííbye jávú méénune. ");
INSERT INTO boaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ááné iijyúnuvúu tsúúca muha mémajchó dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Átsihvúu neebe múúhakye: —Ɨ́mɨáánetúré ámúhakye o néé íjcyaabe tsaapi ámúhadítyú óhdivu méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ehdúu dibye múúhakye nééne ávyétá kimóhcó múúhakye pajtyéhi. Áánélliihyée muha pámeere menéé dííbyeke: —Avyéjuúbej, ¿aca caabyé íñe ehdu uke muha méméénuúhi, a oó? ");
INSERT INTO boaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Áánélliihyée múúhakye neébe: —Íñe tsajɨ́ pañévúré muhtsi dííbyema memájchoobe ehdu oke méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ehdu ɨ́mɨááné oke pajtyéiñe Mɨ́amúnáájpidívúu o ípívyéévéébeke tsúúcajátújucóo Píívyéébe íwaajácúháámɨtu néhdújuco. Árónáa ihdyu máɨdáátsoju tene pájtyeíñé ehdu oke méénúúbeke. Tsáháa ihdyu dibye íjcyáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ehdúu dibye néénéllii diibye Jóóda eenéhjáa dííbyedívú méénútsóiibye néé dííbyeke: —Ávyéjuúbej, ¿a oo tehdu uke ó méénuúij? Áánélliihyée neebe dííbyeke: —Éée, uu muurá ehdu oke ú méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ehdúu iñétsihdyu pááaho iékéévéne téhdújtsoobe Píívyéébeke. Áánemáa idyóhdáhɨ́nunévú múúhakye iwájtúne neébe: —Íñe tájpi náávé íjcyane memájcho. ");
INSERT INTO boaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Áhdurée idyé ado iékéévéne téhdújtsoóbe. Áánevúu múúhakye iájcúne neébe: —Íñe tátyujpácyo náávé íjcyane maádo. ");
INSERT INTO boaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aane úúballé íñe muhdú ámuha meícyahíjcyáné pityájcoju o dsɨ́jɨ́véneri tsíhdyuréjuco cápáyóóveíñe. Ahdícyane tátyujpácyó wágóóóveé páme wájyuríyé múhdumé teene cáhcujtsómé imítyú iábájɨ́ɨ́vémeíki. ");
INSERT INTO boaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aane ámúhakye o néé ícyoocátú tsiiñe ámúhama o ádójúcóóityúné óóvajpácyó múijyú Llihíyó avyéjuríyéjuco meíjcyácooca tsiiñe maádóiñévújuco. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aamée teene pajtyété wañéhjɨ́ majtsíjyú muha memájtsívátsihdyu mepéé oríívó bajúvu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Átsihvúu múúhakye neébe: —Ípyejco muurá ámuha pámeere ílluréjuco óhdityu metsújááveíñé pahúllevávu. Muurá Píívyéébé waajácúháámɨtu nééneé: “Obééjámú tehméébeke o dsɨ́jɨ́vétsóné boone ílluréjuco ditye mújtaíñé pahúllevávu.” Ehdu muurá nééne Píívyéébé waajácúháámɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Árónáa ihdyu o dsɨ́jɨ́veebe tsiiñe o bóhɨ́ɨ́ne ó peé ámúhá ɨhde Gariréavu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Áánélliihyée Péédoro nééhií: —Íhya ihdyu íjtye uke ɨ́hvéjtsoóhi. Áánetu ihdyu tsá uke o ɨ́hvéjtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Áánélliihyée neebe dííbyeke: —Árónáa ɨ́mɨáánetúré uke o néé ípyejcójuco oke u úráávyeróné u tóónuíñé cáracái májtsívátúné ɨhde 3-ijyúva. ");
INSERT INTO boaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Áánélliihyée Péédoro nééhií: —Muurá tsá o tóónúmeíityúne. Óvíjyuco ihdyu néhi oke ditye dsɨ́jɨ́vetsóné tééné hallútu. Ehdúu pámeere muha méneerá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aamée tétsihdyu muha mepééme méúújeté ‘Getsemaníi’ némeítsihvu. Átsihvúu Jetsóó néé múúhakye: —Íchiíyéi meíjcyá Píívyéébema o íhjyúvatéki. ");
INSERT INTO boaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aabée múúhadítyú tsajtyé Péédorómá Tsebedéó hájchimútsikye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Áámedívúhjáa ávyétá ɨhnáhóré kímóóvémeííbyé néé diityéke: —Muhdú íhya o dsɨ́jɨ́véiúvúduréjuco oke táɨ́ɨ́buwa. Ahdícyane cána íchihdyúréi oke metéhmej. Árónáa ihdyu mécúwadíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ehdúhjáa iñééne peebe diityédítyú éhnííñéwuúvu. Átsihvúhjáa ɨmɨ́móúúvéne Píívyéébema íhjyúvaabe nééhií: —Ayúju Táácáániíj, muhdú u néhajchíí óvíjyacóóné o ɨ́cúbáhrámeíñe. Árónáa idyé tsá o ímillédú u méénúityúne. Wa ihdyu muhdú u ímillédú óóma meénuj. ");
INSERT INTO boaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ehdúhjáa iíhjyúvátsihdyu óómiibye wajtsɨ́ cuwárí íjcyámedívu. Aabéhjáa néé Péédoróke: —¿Aca tsá eene ámuha cuwa maáábúcutú oke metéhmeki? ");
INSERT INTO boaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Imíchi bo meíjcyáne cúwávetúmé Píívyéébema méihjyúvahíjcyá ámúhakye dibye ɨpɨ́áábo ímítyunévú ámuha metáhjátsámeítyuki. Muurá ɨ́mɨááné ámuha meímíllerá tsaímíyé meíjcyane. Árónáa tsá ámuha meɨ́hnáhootú tehdu meíjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ehdúhjáa diityéké iñééne tsiiñe óómiibye bɨwáhullévúre. Áánemáhjáa idyé tsiiñe Píívyéébema íhjyúvaabe nééhií: —Ayúju Táácáániíj, muhdú u néhajchíí óvíjyacóóné o ɨ́cúbáhrámeíñe. Árónáa ihdyu óvíi muhdú u ímillédú óóma ú meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Átsihdyúhjáa idyé tsiiñe tsáábe wajtsɨ́ bɨwáhdúré cuwárí íjcyámedívu. Ávyetáhjáa tsá cuwa ditye áábúcutúne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Áámedíhjyáa ɨ́ɨ́cúvétuube tsiiñe oomí bɨwáhullévúre. Áánemáhjáa idyé tsiiñe Píívyéébema ihjyúvaabe piéhdúré tujkénúu iíhjyuvádu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Átsihdyúhjáa tsiiñe diityé éllevu itsááne neebe diityéke: —Áyu ícyooca ihdyu ílluréjuco mecúwáiyóne. Árónáa Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi ímítyúmeke ékéévétsóíñe éévé tsúúca úújetéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ahdícyane ílluréjuco metsu. Muurá tsúúca tsaabe óhdivu méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ehdúhjáa Jetsóó néénáa tsúúca tsaatémá Jóóda wajtsɨ́ tétsihvu llúúvájté avyéjujtémá túkevéjtsojte wállóónéllii tsáámeé. Aamée tsáá ímyéénujcátsiháñé nɨɨtsúmuma cávaájcoháñema. ");
INSERT INTO boaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ácoocáhjáa ɨ́hdéjuco Jóóda nééne diityéke: —Cáábyeké o chóhchócuube diibyéjúcoói. Áábeke meékéévéne métsajtyéco. ");
INSERT INTO boaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ehdúhjáa diityéké ipítyajcódújuco dibye Jetsóo éllevu itsááne dííbyeke nééneé: —Ávyéjuúbej, ¿a áánu uúj? Ehdúu néébere chohchócú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Áánélliihyée Jetsóó néé dííbyeke: —Muúbej, ¿aca ɨ́veekí ehdu oke ú meenúhi? Árónáacáa tsúúca dííbyeke iékéévéébe tsajtyéme. ");
INSERT INTO boaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ááneréjucóo tsaapi múúhadítyú ɨ́nɨɨtsúwari wállórɨhjúcúné llúúvájté avyéjúúbé úníu múnáájpí núúmɨho. ");
INSERT INTO boaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Áánélliihyée dííbyeke Jetsóó nééhií: —Pícyo téhbabyá pañévú dɨ́nɨɨtsúwa. Muurá nɨɨtsúmuri méénújcatsímyé téwáhjɨríyé dsɨ́jɨ́veéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Aca tsá u wáájácutú o ímílleca ícyoocáré Llihíyoke o táúmeíiyóné níjkyéjɨ múnaa oke ipájtyetétsoki? ");
INSERT INTO boaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Muurá íllu oke ditye méénútúhajchíí ¿muhdúikyé pajtyéiyóné tsúúcajátújucóo Píívyéébe néhijcyáné dííbyé waajácúháámɨtu cáátuváne? ");
INSERT INTO boaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ehdúu dííbyeke iñétsihdyu neebe dííbyeke ékéévémeke: —¿Aca muhdú éhne múúne ímityúné méénuhíjcyáábe éllevu ditye tsáhdu ámuha metsáá taéllevu nɨɨtsúmuma cávaájcoháñema? Áánerá íhyajchótá ámúháj pɨɨne o íjcyaabe duurúvájá pañévú ámúhakye ó úwáábohíjcyáhi. Áróóbeke keená ámuha oke meékéévehíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Árónáa ihdyu tehdújuco ámuha meméénune Píívyéébé ihjyú uubálle múnaápe tsúúcajátújuco néhijcyáné dííbyé waajácúháámɨtu néhdújuco tene ipájtyeki. Ehdúu Jetsóó néénáa ílluréjuco muha mewááne tétsihdyu dííbyéjtane. ");
INSERT INTO boaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aamée awáá tsajtyéjucóó dííbyeke llúúvájté avyéjuube Caipáa jávú tééjari páñétúejte avyéjujte íjcyáme éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Áánáacáhjáa Péédoro dííbyeke úráávyeebe pehíjcyá diityé kemúellére. Aabéhjáa úújeté páñétúejpi llúúvájté avyéjúúbé já llahájtsɨvújuco. Aabéhjáa tétsihyi tééjá tehmé múnááj pɨɨnévú úújeté tétsihdyu ɨɨ́ɨ́te muhdú ditye Jetsóoke méénuíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Áánáacáhjáa diitye avyéjujte ɨ́jtsámeí muhdú dííbyé hallúvú iállíñe dííbyeke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Árónáacáhjáa tsá ditye píívyetétú muhdú dííbyé hallúvú iállíiyóne. Mítyaméróhjáa diitye dííbyé hallúvú állihíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Áánéj pɨɨnévúhjáa tsaatétsí úúballé dííbyé hallúvú íllúu dibye nééneé: “Muurá Píívyéébé duurúvaja o wácávyáhcoja ó piivyété tsiiñe 3 coojɨ́vatúré o pánéévetsóne.” ");
INSERT INTO boaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ehdúhjáa dityétsí úúbállénéllii llúúvájté avyéjuube néé Jetsóoke: —¿Aca ɨ́veekí tsá ɨɨná u néétu aatyétsí díhyallúvú úúballénetu? ");
INSERT INTO boaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Árónáacáhjáa cúúvéhulléré diíbye. Áánélliihyéhjáa tsiiñe neebe dííbyeke: —Ɨ́mɨá Piivyéébe mémeri uke o néé ɨ́mɨáánetúré múúhakye u úúbálleki: ¿A ɨ́mɨááné diibyéjuco uu Críjto Píívyéébé Hajchij? ");
INSERT INTO boaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. Aane cáhawáá óvíi ámuha méwaajácú Mɨ́amúnáájpidívúu o ípívyééveebe ɨ́htsútuube Píívyéébé úníuri o íjcyane. Aabe muurá tsiiñe o tsáácooca ó bóhówááveé ojtsó pañétu. ");
INSERT INTO boaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ehdúhjáa Jetsóó néénéllii diibye llúúvájté avyéjuube íwajyámú dóváríjcyámeííbyéré nééhií: —Áánu ¿ɨ́veekí Píívyéébedi uuhɨ́vatéhi? Ahdícyane ɨ́ɨ́nélliihyécó tsijtye éhnííñevu dííbyé hallúvú úúbálléiyáhi. Muurá íñe ámuha melléébóneríyé uuhɨ́vatéébé Píívyéébedi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Áábeke muhdú ámuha méɨjtsúcunúhi? Áánélliihyéhjáa néémeé: —Muurá ɨ́mɨááné ímityúné ihjyúvaábe. Áánéllii ílluréjuco dibye dsɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ehdúhjáa iñééne dííbyeke méénuméré íhyúmɨ úníchihcyúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aanéhjáa tsaate dííbyeke imyéénúne nééhií: —Ehdu idyé Críjto u íjcyaabe cána waajácú caabyé uke méénune. ");
INSERT INTO boaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Áánáacáhjáa Péédoro lláhájtsɨri ácuúcunúhíjcyáábe éllevu tsáápille tééja múnáá úníu múnáalle ipyééne néé dííbyeke: —Úpée idyé éhne Jetsóoma ú ícyahíjcyá Gariréa múnáájpiíma. ");
INSERT INTO boaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Árónáacáhjáa pámeere tétsihyi íjcyame lléébónáa íllure ityóónúne neébe: —Tehdu o wáájácúúbedíjɨ́ɨ́ óóma ú ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ehdúhjáa ityóónútsihdyu lláhájtsɨ́ lleehówá ijcyáhullévú péébeke idyé tsíjpille iájtyúmɨ́ne tétsihyi íjcyámeke nééhií: —Áánúu muurá idyé ícyahíjcyá Natsarée múnáajpi Jetsóoma. ");
INSERT INTO boaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Áánélliihyéhjáa idyé tsiiñe tóónuube nééhií: —Éje, tsá o wáájácutú dííbyeke. Muurá Píívyéébe waajácú o állityúne. ");
INSERT INTO boaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ááné illúhwuúréhjáa tsijtye dííbyeke nééhií: —Áánerá ɨ́mɨááné diibyéjuco uu Jetsóó mamyémúejpi. Muurá díhjyúture muha méwaajácú diibyéjuco u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ehdúhjáa ditye nénéllii tsiiñe ityóónúne llíhcyámeííbyéré nééhií: —¡Ɨ́mɨáánetúré tsá o wáájácutú muubá Jetsóó íjcyáábeke! ¡Muurá Píívyéébe waajácú o állityúne! Ehdúhjáa dibye néérónáa tsúúca cáraca májtsiváhi. ");
INSERT INTO boaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Áánetúhjáa botsíi ɨ́tsááveebe Jetsóópe dííbyeke nééne ɨ́mɨááné dííbyé uráávye múnáajpi iíjcyaróné dibye tóónuíñé cáracámúi májtsívatúné ɨhde 3-ijyúva. Aabéhjáa áachívú icyájtúcuíñúne ílluréjuco tááne ávyétá ɨhnáhó ɨ́mɨááné ityóónune ɨɨ́tsáávéneri. ");
INSERT INTO boaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ááné tsɨtsɨ́ɨ́vevúhjáa pámeere llúúvájté avyéjujtémá túkevéjtsojte pítyácójcatsí ímíñeúvú muhdú Jetsóoke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Áábekéhjáa idyóhjɨ́núúbeke tsajtyémé tééné iiñújɨ́ ávyéjuube Pirááto éllevu dibye muhdú iñéé dííbyedítyu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Áánetúhjáa diibye Jóóda tsúúca dííbyedívú imyéénutsójúcóónéllii botsíi ɨ́tsaavé ɨ́veekí ímityúné imyéénune. Áánemáhjaa diitye llúúvájté avyéjujtémá túkevéjtsojte íjcyáme éllevu peebe dityée áhdone dsɨɨdsɨ 30-jɨva íjcyane ióómíchoki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aabéhjáa neeté diityéke: —Ɨ́veekí ímityúné ó meenú ɨ́ɨ́né imítyúné méénútúúbedívú o llííhyánútsóíñeri. Árónáacáhjáa nééme dííbyeke: —Máhdúníhyaáj, muhdú idyé muha méméénuú ihdyu díhyallúrí íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ehdúhjáa dííbyeke ditye néénéllii teene dsɨɨdsɨ ílluréjuco dibye duurúvájáj pɨɨnévú wácháacáróne. Átsihdyúhjáa tsátsihvu ipyééne ílluréjuco dibye íkyéjtúhityu ióhbáyúmeíñeri dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aanéhjáa teene dsɨɨdsɨ llúúvájté avyéjujte iújcúne nééhií: —Tsá íñe dsɨɨdsɨ Píívyéébé wáábyuta mepícyohíjcyáné pañévú mepícyóóityú dsɨ́jɨvétso áhdó tene íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Áánemáhjáa bóónétu ɨ́jtsámeímyé téénema iáhdoíñé tsátsii ííñujɨ ‘Llíyihllóné nijcyó múnáájpí iiñújɨ’ némeítsíí tétsihdyu tsííñé iiñújɨ múnaa dsɨ́jɨ́vémeke icyúúuhíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Téénéllii muurá ícyoocápí tétsíi mémé ‘Tújpácyo hájtsɨ’. ");
INSERT INTO boaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ehdúu pajtyéné Píívyéébé ihjyú uubálle múnáajpíhjyáa Jeremíá íllu néhdújuco: “Ujcúmé ijraéémú dsɨɨdsɨ dííbyeke ɨdsɨ́jɨ́vétsóne áhdó 30-jɨva. Áánema ahdómé tsátsii ííñujɨ ‘Llíyihllóné nijcyó múnáájpí iiñújɨ’ némeítsíi.” Ehdúhjáa muurá ɨ́hdétújuco Jeremía téénetu nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aanéhjáa tsúúca Jetsóoke tsajtyéjucóómé tééné iiñújɨ́ ávyéjuube Pirááto éllevu. Aabéhjáa népejtsó dííbyeke: —¿A uu jodíómú avyéjuúbe? Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. ");
INSERT INTO boaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aanéhjáa tétsihvu idyé diitye llúúvájté avyéjujtémá túkevéjtsojte tsiiñe állíjyucóó dííbyé hallúvu. Árónáacáhjáa tsá dibye ɨ́ɨ́néubá néétu diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Áánélliihyéhjáa Piráátó néé dííbyeke: —¿A ú lléébora aatye ímityúné úhdityu íhjyuváne? ");
INSERT INTO boaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Árónáacáhjáa tsá dibye áñújcutúne. Áijyúhjáa diibye ávyéjuube Piráátó dííbyeke ɨɨná néétuube ílluréjuco úllévenúne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aabéhjáa diibye Piráátó paíjyuva teene pajtyété wañéhjɨ́ pañe ichívyétsohíjcyá cúvéhóójari íjcyámedítyú tsáápí hallúvú ditye íhjyúváábekéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aanéhjáa téijyu ‘Barabáa’ némeííbyé cúvéhóójari ávyeta ímítyuube íjcyáábeke pámeere wáájácuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aanéhjáa tétsihvu dóbéévémeke diibye Piráátó nééhií: —¿Cáábyeké o ácádsɨ́jcaáyóné ámuha méimílléhi? ¿A Barabáake, mityá Jetsóoke dííbyere ‘Críjtoó’ némeííbyekej? ");
INSERT INTO boaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ehdúhjáa diityéké dílloobe íllure Jetsóodi iñómíutááváne ditye ehdu dííbyeke dárɨɨvéné iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aabéhjáa íavyéjú ijyáwá hallúrí íjcyáábeke tsaate úúballé mewa íllu nééneé: “Állíuube ihdyu tsáma Jetsóoke ímityúné méénudí ɨ́ɨ́né imítyú méénúúbekéjɨ́ɨ́va dííbyé hallúrí tene iíjcyátuki. Ípyejcóne ávyétá apííchó ó tuwá dííbyé ɨhdéhacáneécu.” Ehdúhjáa mewa nééne úúballémé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Árónáacáhjáa llúúvájté avyéjujtémá túkevéjtsojte pámeere tétsihvu píhcyáávémeke néé ditye Barabáá hallúvúré iíhjyúva dibye iíjchívyeki. Áánetúhjáa nééme Jetsóó hallúvú ditye iñéé dibye dsɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Áámekéhjáa tsiiñe neebe Pirááto: —¿Aanéhaca ɨ́mɨááné cáábyeké o ácádsɨ́jcaáyóné ámuha méimílléhi? Áánélliihyéhjáa néémeé: —Muha méimíllé Barabáakéré u íjchívyetsóne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Áánélliihyéhjáa neébe: —¿Ácooca muhdú ó méénuú Jetsóoke Críjto íjcyáábeke? Áánélliihyéhjáa pámeere nééhií: —¡Dííbyedívú ihdyu wátyétyehcútsó páwachékevu! ");
INSERT INTO boaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Áánélliihyéhjáa neébe: —¿Aca ɨɨná ímityúné méénuúbe? Árónáacáhjáa tsiiñe éhnííñevúré kéévánécoba néémeé: —¡Muúbe wátyétyehcútsó dííbyedívu! ");
INSERT INTO boaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ehdúhjáa ditye néénéllii tsáhájuco dibye ímíbájchotú Jetsóó icyánéjcu. Aabéhjáa apííchówuúréjuco ditye íbórɨ́báávénéllii nújpacyo ityáúmeíjpácyori pámeere ɨ́ɨ́ténáa íhyótsɨcu níjtyámeííbyéré nééhií: —Árone néhi tsá táhallúrí tene íjcyáityú eene ɨ́ɨ́né imítyú méénútúúbeke ámuha medsɨ́jɨ́vétsoíñe. Ámúhá hallúríyei teéne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Áánélliihyéhjáa nééme dííbyeke: —¡Óvi néhi ihdyu pámeere múúháj tsɨɨménémúháábemájuco múúhá hallúrí teene dííbyeke muha medsɨ́jɨ́vetsóne! ");
INSERT INTO boaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ehdúhjáa ditye néénéllii tsúúca ijchívyétsoobe Piráátó Barabáakére. Áánemáhjáa Jetsóodívú iwátsíhcyútsóne diityédívuréjuco dibye ɨ́hvejtsóné diityéréjuco iwátyétyéhcu páwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Áábekéhjáa dííbyé já pañévú tsodáhómú iááhɨ́vétsóóbedívú píhcyaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aaméhjáa dííbyé wajyámúúné ityácórɨ́jcóne uácó tújpájácoba nééné wajyámuvu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Áhduréhjáa tsuhjɨ́uuhónetu imyéénúné cháhííwavu iávohjácóóbeke éjejcállómé úméheívu. Áánemáhjáa dííbyé lliiñévú ɨmɨ́hmóúbáne iúúhɨ́vaténemáyé wáñejcóme: —¡Ñóóooj! Átsihdyúhjáa nehíjcyáme: Áánu muurá jodíómú avyéjuúbe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Áhduréhjáa dííbyé hallúvú iúnítyójcóne dííbyedi íjcyai úméhéiyi íllaáyohíjcyámé íhñíwáutu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ehdúhjáa dííbyedi iúúhɨ́vaténé nɨ́jcáutu teeja wájyámúcoba dííbyedítyú ityácórɨúcúne páñétúeja íwajyámuvúréjuco ditye úacóne. Áánemáhjáa tsajtyémé páwachékevu iwátyétyéhcúíhullévuréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aaméhjáa pééme cábuuvé Tsirééne múnáajpi Tsimóodívu. Áábekéhjáa íhbutsómé Jetsóoke iwátyétyéhcúíwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aaméhjáa úújeté tsátsihvu heeberéómú ihjyúrí ‘Niwáupáájɨ’ nééiyóné ‘Góógota’ némeítsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Átsihvúhjáa Jetsóoke íjchorómé bíínojpácyó paapáwu néénetu iúménújpácyotu. Aanéhjáa ɨpɨ́hjácúróne tsá dibye ádotúne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Áábekéhjáa tsúúca wátyétyehcúmé téwachékevu. Áánemáhjáa tsodáhómú néhcójcatsí caatyé éhjáhjɨ́ dííbyé wajyámúúné íjcyaíñé iwátújcatsíki. Ehdúu pajtyéné tsaapíhjyáa Píívyéébé ihjyú uubálle múnáajpi íllu néhdújuco: “Táwajyámúúné caatyé éhjáhjɨ́ íjcyaíñé iñéhcójcatsíñe wátújcatsíimye.” Ehdúhjáa muurá neebe Píívyéébé ihjyú uubálle múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aaméhjáa tétsihvúré diitye tsodáhómú iáhcúbáne téhmehíjcyá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Áábé nííwáú caamééhullétúhjáa téwachéketu picyóómé tsíeménetu icyáátunúné íllu nééneé: “Áánu Jetsóó jodíómú avyéjuúbe.” ");
INSERT INTO boaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Téhduréhjáa téijyu tsaatétsí ímítyúmútsikye wátyétyehcúmé dííbyé úníutu panéjcuvátú íjcyáwachékéécutu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aanéhjáa dííbyeke úújejémé dííbyedi iúúhɨ́vaténe ‘wamɨwamɨ’ nehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Áábekéhjáa néémeé: —Ehdɨ́ɨ́vaabée eene ú nehíjcyá duurúvaja u wácávyáhcoja 3 coojɨ́vatúré tsiiñe u pájáávétsoíñe. Áyu cána bo pájtyetétsaméí eene éwachékevu uke ditye wátyétyéhcúnetu ɨ́mɨááné diibyéjuco Píívyéébé Hajchi u íjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Téhduréhjáa idyé llúúvájté avyéjujtee, taúhbájú uwáábojtee, túkevéjtsojtee, íjcyame iúúhɨ́vaténemáyé néjcatsíhi: —Tsíjtyekée ɨ́mɨááné pátyetétsohíjcyaábe. Árónáa tsáháhaca dibye píívyetétú iiye ipájtyetétsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Aabe cána bo óvíi ɨ́mɨááné mee ijraéémú avyéjuube iíjcyáhajchíí éwachéketu ditye wátyétyehcúné ityábáhcyúmeíñe pájtyeté botsíi dííbyeke mecáhcújtsóne dííbyeéjteréjuco meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Muurá Píívyéébedívú cátsɨ́páávehíjcyaábe. Aabe cána bo óvíi dííbyeke pájtyetétsó ɨ́mɨááné dibye némeíhijcyádú dííbyé Hajchi dibye íjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Áhduréhjáa dííbyé úníutu ditye wátyétyéhcumútsí uuhɨ́vaté dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Téijyúhjáa cójɨ́jpɨɨnétú ííjyunúné cuuvé tujkévevújuco. ");
INSERT INTO boaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Áijyúhjáa Jetsóó ávyétá ɨhnáhó wáníjcyámeííbyé nééhií: —Eríij, Eríij, ¿rama tsabatááni? —Tápiivyéébej, Tápiivyéébej, ¿ɨ́veekíami oke ú ɨ́hvejtsoj? Ehdúhjáa nééiyóné ehdu neébe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aanéhjáa tsaate tétsihyi íjcyame ehdu dibye wáníjcyámeíñé illéébóne nééhií: —Éje, aadi Eríadi wáníjcyámeí Píívyéébé ihjyú uubálle múnáájpiúvudi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Áánélliihyéhjáa tsaapi ɨ́ɨ́cúi ɨdsɨ́ɨ́neíñúne wájyámubádú nééne bíínójpácyó kiwátyetu iééníyojéné úméhéí nɨ́jcáutu ipícyoonévú cújuuvé dibye ɨɨ́ɨ́hároki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Árónáacáhjáa tsijtye néé dííbyeke: —Óvíjyacóóne, dáácudíñe. Bo óvíi Eríá pájtyetétsová dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Áánáacáhjáa tsiiñe ávyétá ɨhnáhó iwáníjcyámeítsihdyu ílluréjuco dibye dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ááné tujkéveríhjyáa duurúvájá pañétú páñétúétsíí watájcó wájyámúwácoba dóchéreevé cáámetu baavújuco panéjcuvávú wajɨ́tahnécu. Áhduréhjáa téijyu ííñujɨ vááúmeíñeri néwáyúcobáné wáhcabáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Áhduréhjáa níjkyene wáhcábánetu cahcújtso múnaápe dsɨ́jɨ́vehíjcyámé tsiiñe bóhɨɨme ijchívyécunúhi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aaméhjáa Jetsóó bóhɨ́ɨ́né boone Píívyéébe cóómí Jerotsaréevu péémeke mítyame ájtyumɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Áánetúhjáa eene dííbyeke téhmehíjcyáné tsodáhómú íavyéjúúbemáyé ávyétá mityáné íllityé téijyu ííñujɨ vááúmeíñema tsíñehjɨ pájtyene iájtyúmɨ́neri. Áánemáhjáa néémeé: —¡A ihdyúha ɨ́mɨááné Píívyéébé Hajchi áánuú! ");
INSERT INTO boaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Áijyúhjáa tsaate walléémú kémuélletúré ɨ́ɨ́tehíjcyá dííbyeke ditye dsɨ́jɨ́vetsóné dííbyemáa Gariréá iiñújɨtu tsááme dííbyeke ɨ́ɨ́cúvehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Áámemáhjáa ijcyámé Maaría Madarénaa, Jacóóboma Jotséemútsí tsɨɨju Maaríaa, Tsebedéó hájchimútsíj tsɨɨ́juu, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ááné iijyúnuvúhjáa Jotséé Arimatéá cóómi múnáajpi ɨ́htsútuube íjcyaabe Jetsóoke úráávyehíjcyaabe péé Pirááto éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aabéhjáa táúmeí dííbyeke dííbyeúvú ɨɨtémeho icyúúuki. Áánélliihyéhjáa neebe ítsodáhómuke ditye iájcuki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Aabéhjáa tééhoúvuke ɨbɨ́ɨ́jɨ́núne cuuú béhéjuréhjáa íhllii nééwájɨtu ibóhdótsóhéjú pañévu. Áánemáhjáa nééwáyúcobávú téheju iwátájcoíñúne péjúcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ááné boonéhjáa tétsiíyé téhejú úníuri Maaría Madarénamúpɨ́ tsíjpille Maaríama ácuúcunúhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ááné tsijcyóójɨ́hjáa teene pajtyété wañéhjɨ́ lléévá tujkénujcóójɨ́ diitye llúúvájté avyéjujtémá paritséómú péé Pirááto éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aaméhjáa néé dííbyeke: —Ávyéjuúbej, muha méɨ́tsaavé téallíújaúpe 3 coojɨ́vatu tsiiñe ibóhɨɨíñé nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Áánéllii cána cóhpejtsótsó ímíñeúvú dííbyé nijkyévuj. Ááne ímíñeúvú tehmétsó téhajchótá 3 coojɨ́vá dííbyé mamyémú pejco íllure iñáníjyéne mɨ́amúnáake ‘tsúúca muurá Jetsóó éhnée ditye dsɨ́jɨ́vétsoobe tsiiñe bohɨ́ɨ́hií’ iñééneri éhnííñevu meke iálliúúnútuki. ");
INSERT INTO boaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Áánélliihyéhjáa Piráátó néé diityéke: —Aané wa ihdyu aatye tsodáhómuma mepééne mécohpéjtsó ámuha meímillédu. ");
INSERT INTO boaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ahdújucóhjáa ditye tsaatémá ipyééne teeu nééwayu icyóhpéjtsóutu cáátunúné múha teene idyómájcótuki. Áánemáhjáa diitye tsodáhómuke téhmétsoíñúme. ");
INSERT INTO boaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aanéhjáa wáyeéévéjcóójɨ́ tsiíjyú tsííñé tsemáánaréjuco déjúcóóvejcóójɨ́ cúúvénetúré Maaría Madarénamúpɨ́ tsíjpille Maaríama úújeté teene níjkyeé. ");
INSERT INTO boaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Áánáacáhjáa ííñujɨ ɨ́hnáhó vááúmeí níjkyéjɨ múnáajpi níítyéné tujkéveri. Aabéhjáa teene níjkyé watájcó nééwáyúcoba icyávihyícyúne tééú hallúvú ácuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Áábé wajyámúhjáa ávyeta tsɨtsɨ́wu néébé ámɨ́tsaráhcó éhne múúne chijchi rórihcyódu. ");
INSERT INTO boaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Áábedíhjyáa diitye tsodáhómú ténijkye téhmehíjcyarómé ávyétá ɨhnáhó iíllityéne íjcyaíñú múu dsɨ́jɨvédu. ");
INSERT INTO boaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aabéhjáa néé diityépɨ́ Maaríamúpɨke: —Méíllityédíñe. Muurá ó waajácú ámuhpɨ meúújévaróné Jetsóoke éhnée páwachékevu ditye wátyétyéhcúneri dsɨ́jɨ́véébeke. ");
INSERT INTO boaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Árónáa tsáhájuco dibye níkyéhéjú pañe íjcyájúcootúne. Tsúúca tsiiñe bohɨ́júcoobe ípyée iñéhijcyádújuco. Cáhawáá idyé méuujévá íñe dityée dííbyeke pícyohéjú íévehéjuréjuco íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ahdícyane ɨ́ɨ́cúi mepééne méuubállé dííbyé mamyémuke tsúúca dibye tsiiñe ibóhɨ́ɨ́ne diityé ɨhde péjucóóné Gariréavu téhullévú diityémá iájtyúmɨ́jcatsíki. Ééneréne ihdyu ó imíllé ámúhpɨke o úúballéne. ");
INSERT INTO boaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ahdújucóhjáa ɨ́ɨ́cúi dityépɨ́ dsɨɨnéríyé pééne múúha éllevu múúhakye iúúbálleki. Aamúpɨ́hjáa iíllityéróne mítyane ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Áámúpɨdívúhjáa Jetsóó ibóhówáávéne diityépɨke dillóhi. Áánélliihyéhjáa ɨ́ɨ́cúi dííbyéj tuháácyuvu waamúpɨ́ dííbyeke idyúúruváne. ");
INSERT INTO boaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Áámúpɨkéhjáa neébe: —Méíllityédíñe. Wa ihdyu ɨ́ɨ́cúi mepééne méúúballété tsijtye tahñéjteke ditye ipyéé Gariréavu téhullévú muha maájtyúmɨ́jcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aamúpɨ́hjáa pééné tujkéveri tsodáhómú dííbyé nijkye téhmehíjcyámedítyú tsaate péé ímunáá coomívu. Aaméhjáa úúbálleté llúúvájté avyéjujtéké muhdú tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ááné lliiñétúhjáa túkevéjtsojtémá iúcújcatsíñe pítyácójcatsímyé muhdú iñééiñe Jetsóópe bóhɨ́júcóóityúné iñéhíjcyáneri iñéétsámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aaméhjáa mítyane diitye tsodáhómuke iáhdóne nééhií: —Tsáma ménehíjcyaco “pejcóhjané muha mecúwaíñúné hallúrí ímamyémúré újcujé Jetsóó ɨɨtémeho.” ");
INSERT INTO boaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aane néhi méiiñújɨ́ ávyéjuube iwáájácúne ámúhadívú cáyobáávatéhajchíí muha ámúhá hallúvú méihjyúvaá dibye muhdú ámúhakye imyéénútuki. ");
INSERT INTO boaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ahdújucóhjáa diitye tsodáhómú ditye áhdónéllii íllure iállíñe néhijcyáné ímamyémúré Jetsóó ɨɨtémeho újcujéne. Aane muurá ícyoocápíi ehdu tsaate tamúnaa jodíómú úúbállehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aanée muha 11-meváréjuco dííbyé mamyémú meíjcyame mepéé Gariréá iiñújɨ́ caméhbaúvú múúhakyée dibye néhbaúvu. ");
INSERT INTO boaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aamée muha tétsihvu dííbyedívú meúújetémé méduurúvá dííbyeke tsaate múúhadítyú dibye bóhɨɨne cáhcújtsótúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Árónáacáa múúhakye neébe: —Muurá Píívyéébe oke picyóó páneere ííñujɨɨ, níjkyejɨɨ, íjcyáné avyéjuube o íjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ahdícyane óvíi ámuha pahúllevá iñújɨ́ɨ́ne múnáadívú métsújaúcú táuwááboju. Aane cáhcujtsómeke tééné uubállé métsótsohíjcyaco Méécááni mémerii, Íapíícho mémerii, tamyémeri, íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Áámeke ihdyu ímíñeúvú méúwááboco tátyaúhbaju néhdu ditye iíjcyaki. Aabe muurá ámúhamáyé ó íjcyaá paíjyuváré ííñujɨ nɨ́jkévanévújuco. Áyu tehdújuco.");
INSERT INTO boaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Íllúu tujkéváné Píívyéébé Hajchi Jetsocríjtó mepájtyetéiñe méénúné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Píívyéébé ihjyú uubálle múnáajpíhjyáa Itsaíaúvú caatúnú íwaajácúháámɨtu tsúúcajátújuco tsojtsó múnáajpi Jóáádityu ílluú: Ó pícyoó dɨ́ɨhde tsáápiikye dibye iúúbálle mɨ́amúnáake ditye iímíbáávyéne ímí uke iwáátsúcúpéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aane méllééboó ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyaabe keeváwu íllu úwaabóne: “Méímibáávyé ímítyú ámuha meícyahíjcyánetu tsaímiyéjuco ámuha meíjcyámeke Ávyéjuube iájtyumɨ́vaki.” Ehdúhjáa Itsaíá íwaajácúháámɨtu caatúnú Jóáádityu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ahdújucóhjáa dibye ɨ́ɨ́néubárá píívyétúné iiñújɨri úwáábohíjcyáné mɨ́amúnáake ditye ímityúné iícyahíjcyáné ɨɨ́hvéjtsóne ɨ́mɨánejcúveréjuco ɨɨ́búwááve diityé imítyú iábájɨ́ɨ́vémeíki, ááné uubállé ditye itsójtsótsámeíki. ");
INSERT INTO boaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pahúllevátúhjáa Jodéá iiñújɨ múnáadítyú píhcyáávehíjcyámé dííbyedívú dííbyé uwáábó illéébúcunúki. Téhduréhjáa Jerotsarée múnáadítyú mítyame píhcyáávehíjcyáhi. Áámedítyúhjáa ímityúné imyéénuhíjcyáné úúbállémeke tsótsohíjcyaabe Joodáatu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aanéhjáa diibye Jóáa camééllómú ɨhjɨ́netu méénúmeíñé wajyámúúnema íjcyáábéj pɨɨnétú ócájɨmɨ́ɨ́hé chiúcunúhi. Aabéhjáa tséréémuke dohíjcyáhi. Téhduréhjáa íímúhojpácyó ádohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aabéhjáa úwááboobe nehíjcyáhi: —Muurá íjcyaabe tsijpi táhboone úwáábóiibye táehnííñevu ɨ́htsútuube íjcyáábeke íjtyúhápáájɨ́ubáré o tácórɨúcu dííbyedívú o pɨ́ɨ́hɨ́véítyúroóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Muurá ámúhakye nújpácyori ó tsótsohíjcyáhi. Áánetu ihdyu diibye ámúhá pañévú pícyoó Píívyéébé Apíícho. ");
INSERT INTO boaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Téijyúhjáa Jetsóó péé Gariréá iiñújɨri íjcyacóómí Natsaréetu diibye Jóáa éllevu Joodáatu dííbyeke dibye itsójtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aabéhjáa tsúúca dibye tsójtsótsihdyu íjchívyeebe ɨ́ɨ́ténáa cáámetu Píívyéébé Apííchó niityé dííbyedívú ɨ́juuúdú nééneé. ");
INSERT INTO boaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Áánáacáhjáa idyé cáámetu Píívyéébe nééhií: —Uu Hájchíwúuke o wájyúúbedi mítyane ó imíjyúúhií. ");
INSERT INTO boaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ehdúhjáa dibye tsójtsómeíñé boonétú Píívyéébé Apííchó dííbyeke tsajtyé ɨ́ɨ́néubá píívyétúné iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Áhulléhjáa íjcyaabe 40 coojɨ́vá apáámyéré iyámé íjcyáhulle. Áábekéhjáa téhullévú Naavéné máváríjchóóbeke níjkyéjɨ múnaa pɨ́áábohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Aanéhjáa téijyu tsojtsó múnáajpi Jóááke ditye cúvéhoojánúné boonétú Jetsóó péé Gariréavu. Áhullé múnáakéhjáa Píívyéébé avyéjuvu muhdú meúcáávéíñé úwááboobe nééhií: —Tsúúca Píívyéébe íavyéjúejte íjcyáímyeke újcúíñe éévé úújetéhi. Ahdícyane ílluréjuco méɨhvéjtsó ímityúné ámuha meícyahíjcyáne. Ááne ámúhá ɨ́jtsaméí ɨ́mɨánejcúvuréjuco mecápáyóóvéne mécahcújtsó íñe mepájtyetéíñé uwááboju. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aabéhjáa Gariréá unéú úníuri péébe úújeté Tsimóomútsí íñahbe Aderéema amómeke tsɨ́nuhíjcyámútsidívu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Áámútsikyéhjáa neébe: —Ámuhtsij, ookéréjuco méuráávye. Muurá íñe amómé lliiñája múnáajtétsí ámuhtsi meíjcyámútsikye ó pícyoó mɨ́amúnáakéréjuco Píívyéébedívú ámuhtsi meɨ́búwáávétsóíñé wákimyéivu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ehdúhjáa Jetsóó néénéllii teenémáyé ɨjtsɨ́nuuháñé ɨɨ́hvéjtsóne peemútsí dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Áámútsimáhjáa péébe éhnííñéwuúvú úújeté Tsebedéó hájchimútsí Jacóóboo, Jóáaá, íjcyamútsí ɨhmɨ́ɨ́né pañe ɨjtsɨ́nuuháñé pájáábohíjcyamútsidívu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Áámútsikyéhjáa idyé dibye pɨ́úvánéllii ɨhmɨ́ɨ́né pañe cááni Tsebedéoma ɨ́pɨáábojte íjcyámedítyú peemútsí dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Éhdúmekéhjáa iújcúmema Jetsóó úújeté Capenaóovu. Aabéhjáa téhulle wáyeéévejcóójɨ́ pihcyáávéjá pañévú úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ááneríhjyáa mítyane ullévenúmé ávyétá tujkévé ávyéjuube múúne íhjyúvajɨ́jtó dibye íhjyúváneri. Tsáháhjáa dibye íhjyúvatú taúhbájú uwáábojte íhjyúvahíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Áijyúhjáa tééjá pañe tsaapi naavéné ípañe íjcyaabe kévádijcyó íllu dííbyeke: —¡Jetso Jetsóoj, Natsarée múnáajpi u íjcyaábej! ¿Ɨ́veekí múúhakye ú pátsárijcyóváhi? ¿Mityá múúhakye ú waagóovaj? Muurá uke ó waajácú ɨ́mɨáábé Píívyéébé Hajchi u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Áánélliihyéhjáa neebe dííbyeke: —¡Cúúvéhulléré diícya! ¡Díjchivye áádí pañétu! ");
INSERT INTO boaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ááneréjucóhjáa naavéné wáníjcyámeííbyéré íjchivyéné dííbyé pañétú ávyétá ɨhnáhó dííbyeke iáméjcatsíchónema. ");
INSERT INTO boaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ehdúhjáa Jetsóó méénúneri pámeere iíllityéne nééhií: —¿Múhdutúami aabye ehdu meénuj? Ávyetáha ɨ́mɨááné tsíhdyure dííbyé uwááboju. Muhdú naavémú íjcyarómé ijchívyé dibye néénetu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ehdúhjáa dibye méénúné uubállé tsújaavé páneere Gariréá iiñújɨri. ");
INSERT INTO boaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Átsihdyúhjáa pihcyáávéjá pañétú pééme tsaméhjɨ́ Jacóóboo, Jóáaá, íjcyame Tsimóoma Aderéemútsi jávu. ");
INSERT INTO boaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Áijyúhjáa Tsimóó baabe áíívyeri chémene úúballémé Jetsóoke. ");
INSERT INTO boaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Áánélliihyéhjáa díílle éllevu ipyééne íhyójtsɨtu dibye íjyócujcárolle tsúúca ibóhɨ́ɨ́ne diityéké májchotsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aanéhjáa tsúúca meííjyunúrónáa tsívahíjcyámé dííbye éllevu naavémú ípañe íjcyáméhjɨma tsíñéhjɨri chéméméhjɨke dibye ibóhɨ́ɨ́tsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","34","Mítyaméhjáa técoomí múnaa tééjavu tsáámedítyú páhduváré nénéhjɨ chémeri íjcyámeke bóhɨ́ɨ́tsohíjcyaábe. Áhduréhjáa tsaaté pañe naavémú íjcyámeke waagóohíjcyaábe. Aaméhjáa diitye naavémú muubá dibye íjcyane nééíyónáa tsá dibye diityéké ɨ́hvéjtsotú ditye iíhjyúvaki. Waajácúméhjáa dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ááné tsɨtsɨ́ɨ́vevúhjáa pejcójuco técoomítyú dibye pééne tsátsihvu Píívyéébema iíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Áábekéhjáa Tsimóó íñahbéjtema néhcotéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aaméhjáa iájtyúmɨ́ɨ́beke nééhií: —Mɨ́amúnaa uke néhcohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Áánélliihyéhjáa neebe diityéke: —Árónáa metsu éhcóómijɨ́vú mepéé técoomíjɨ múnáake idyé o úwááboki. Muuráhjáa ímichi téénéllii o tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aabéhjáa pihcyáávejááné pañévú pahúllevá múnaa Gariréá iiñújɨri íjcyámeke úwáábohíjcyá tsaaté pañe naavémú íjcyámeke wáágóoobére. ");
INSERT INTO boaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Áábé lliiñévúhjáa íjpi chájááveebe ɨmɨ́móúúveténe néé dííbyeke: —¿Aca muhdúiyó teene oke u bóhɨɨtsóne? ");
INSERT INTO boaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Áánélliihyéhjáa dííbyeke idyócáraúcunúne dííbyedi ɨɨ́dáátsóvéne neébe: —Mu ihdyu tehdújucoj. ");
INSERT INTO boaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ehdúhjáa dibye néénemáyé tsúúca bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Áábekéhjáa neébe: —Dúúbálledí tsaate juuváyí uke pájtyémeke íñe muhdú u bóhɨɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Tsapéhdúré llúúváábe éllevu pééne dííbyedívú dúhjétsámeítyeco. Ááne Moitséeúvúu néhdu íñe u ímíjpyeténé hallúvú Píívyéébeke tsíeméneri ú ɨ́ɨ́cúveé téénetu mɨ́amúnaa iwáájácu tsúúca u bóhɨ́jucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ehdúhjáa dibye bóíjcyúrónáa pámeekéré juuváyí ipájtyedúmeke úúbálleebe muhdú ibóhɨɨ́ne. Aaméhjáa mítyane Jetsóodívú píhcyáávehíjcyánéllii tsáhájuco dibye píívyetétú múhdutú cóómí pañévú iúcáávéiyóne. Áánélliihyéhjáa pehíjcyaabe imíchi ditye íjcyátútsɨhjɨ́ríye. Áróné pañéhjáa pahúllevátú dííbyedívú píhcyáávehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ehdúhjáa tsúcájá tsiéllé iíjcyátsihdyu tsiiñe óómiibye Capenaóovu. Ááné uubálléhjáa idyé ɨ́ɨ́cúíwuúré tsúúca waajácúmé técoomí múnaa. ");
INSERT INTO boaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aaméhjáa dííbyedívú píhcyaavémé dibye íjcyaja wáhpécunúmeke úwááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Áánáacáhjáa 4-meva tsivá íjpi vááúmeítyúúbeke dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Árónáacáhjáa tsá ditye píívyetétú iúújetétsóné mítyane mɨ́amúnaa íjcyánélliíhye. Aánélliihyéhjáa cáámetu dibye íjcyátsíí tujkévetu idyóhejúróne botsíi dííbyeke niityétsóme. ");
INSERT INTO boaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aaméhjáa ímí cáhcujtsóné iwáájácúne neebe Jetsóó dííbyeke: —Llíhij, tsúúca úhdi o ɨ́dáátsóvéne díimítyú ó ábájɨɨvéjucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Ehdúhjáa dibye néénetu tétsihyi íjcyame taúhbájú uwáábojte néjcatsíhi: —¿Aca ɨ́veekí aabye ehdu ihjyúvá Píívyéébe ímí dííbyedívú ɨ́jtsúcunúnejɨ́ɨ́vari? Muurá ihdyu apáábyéré Píívyéébe piivyété mɨ́amúnáadítyú íimítyú iwáágoóné diityédí ɨɨ́dáátsóvénema. ");
INSERT INTO boaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ehdúhjáa Jetsóodítyú ditye néjcatsíñé iwáájácúne neebe diityéke: —¿Ɨ́veekí ímityúné óhdityu ámuha méɨ́jtsámeíhi? ");
INSERT INTO boaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Aca muhdú ámuha oke méɨjtsúcunúhi? Áánerá ó piivyété mɨ́amúnáadi o ɨ́dáátsóvéne diityé imítyuháñé diityémá o ímíbajchóne. Áánéllii ó piivyété áánúke o nééneé: “Úhdi o ɨ́dáátsóvéne díimítyú úúma o ímíbajchóhi.” Áhdure ó piivyété o nééneé: “Dímíjpyeténe dɨ́ɨ́hbotámá dipye dihjyávu.” ");
INSERT INTO boaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ahdícyane cáhawáá óvíi ámuha máájtyumɨ́ Mɨ́amúnáájpidívúu o ípívyééveebe muhdú o méénune. ");
INSERT INTO boaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ehdúhjáa iñétsihdyu neebe dííbyeke: Llíhij, dímíjpyeténe eene dɨ́ɨ́hbotámá dipye dihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ehdúhjáa dííbyeke Jetsóó néénemáyé tsúúca iímíjpyeténe ɨ́ɨ́hbotámá péjúcoobe pámeere ɨ́ɨ́ténáaáca. Ááneríhjyáa mítyane iúllévenúne Píívyéébeke idyúúrúváne néémeé: —Ávyeta tsá múijyú ehdɨ́ɨ́vane maájtyúmɨtúne. ");
INSERT INTO boaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ááné boonétúhjáa tsiiñe Jetsóó péé únéú úniúvú ímamyémuma. Áhullévúhjáa idyé dííbyedívú píhcyáávémeke úwááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Átsihdyúhjáa péébe úújeté Apéó hajchi Revíí ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke iáhdótsohíjcyátsihyi ácuúcunúúbedívu. Áábekéhjáa neébe: —Muúbej, ookéréjuco duráávyej. Ahdújucóhjáa dibye pééne dííbyemáyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Áábe jávúhjáa Jetsóó téijyu majchó ímamyémuma. Áámemáhjáa téhdure tsijtye majchó téénere ávyéjúúbé wáábyuta íjcyáne dsɨ́ɨ́dsɨ́ ahdótso múnaa. Áhduréhjáa íjcyámé tsijtye ímityúmé diityéma. Mítyaméhjáa dííbyema pehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ehdúhjáa dibye diityémá májchone ɨɨ́ɨ́téne taúhbájú uwáábojtémá paritséómú néé dííbyé mamyémuke: —¿Aca ɨ́veekí eene ámúhá uwááboobe majchó aatye ímítyúméhjɨma? ");
INSERT INTO boaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aanéhjáa Jetsóó illéébóne néé diityéke: —Tsá muurá taabóóbé bóhɨɨme tsaímíyé íjcyámeke táábotúne. Muurá ihdyu chéméméhjɨkéré tááboóbe. Ahdícyane tsáháa ɨ́mɨáámé wáábyú o tsáátune. Muuráhjáa ihdyu ímítyúme wáábyú o tsáá diityéké o ímíbáávyétso Píívyéébé icyánejcúvuréjuco ditye ɨɨ́búwááveki. Ehdúhjáa Jetsóó néé paritséómuke. ");
INSERT INTO boaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tsáijyúhjáa tsojtsó múnáajpi Jóáá mamyémuma diitye paritséómú mamyémú Píívyéébema iíhjyúva majcho áwahíjcyáhi. Aanéhjáa Jetsóo éllevu ipyééne tsaate dííbyeke nééhií: —¿Aca ɨ́veekí dímamyémú majcho áwátúnáa Jóáá mamyémuma paritséómú mamyémú tsáijyu áwahíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Áánélliihyéhjáa diityéké neébe: —¿Aca tsaapi táábáváné wañéhjɨvu tsááme ikímóóvéne majcho áwáiyáhi? Muurá teene wañéhjɨ́ aabájaabe diityémá íjcyánáa tsá ditye áwáítyuró majcho. Ehdu nééne támamyémú tsá majcho áwáítyuró diityémá o íjcyáné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Muurá ihdyu íjcyaíñé diityédítyú o pééiñe. Áijyu ihdyu óvíi muhdú iñéhajchíí tsáijyu awámye. ");
INSERT INTO boaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsá muurá tene ímityú tsúúcáaja wájyamu béhbátu mepájaabóne. Muurá teeja meníjtyúcooca éhnííñevu íllure táváajcároba. ");
INSERT INTO boaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Áhdure idyé tsá tene ímityú béjpácyo bíínojpácyó mepícyoone tsúúcáau mɨ́ɨ́héneu cahpáyú pañévu. Muurá béjpácyo iúhtsáráúúvéhulle táváajcó tsúúcáau. Áijyu wágóoovéné tsanéécújuco bíínójpácyoma cahpáyu. Áánéllii béjpácyo mépañénú bééú pañévúré muhdú tsanéécú iíjcyátuki. Ehdu nééne tsá tene ímityú ɨhdééné uwááboju béhné uwáábójú pañévú meúacóne. Ehdúhjáa Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aabéhjáa tsáijyu ímamyémuma pajtyé úmɨhéj pɨɨnétú wáyeéévejcóójɨ. Áijyúhjáa ímamyémú bajtsóháñetu ujcú imájchoki. ");
INSERT INTO boaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Áánélliihyéhjáa paritséómú néé dííbyeke: —¿Aca ɨ́veekí aatye dímamyémú meenú íjcyoojɨ wáyeéévejcóójɨ́ meméénúítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Árónáacáhjáa neébe: —¿Aca tsá ámuha meéévehíjcyatú tsáijyúu iájyabáávaténéllii íñahbéjtema Dabíiúvú téeméné méénune Píívyéébé waajácuháámɨtu cáátuváne? ");
INSERT INTO boaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Muuráhjáa Abiatáá llúúvájté avyéjuube íjcyáijyu duurúvájá pañévú iúcáávéne imájchóítyuróné Píívyéébé ɨɨcúvé pááa tééjá pañévú pícyámeíhijcyáné majchómé apáámyérée llúúvájte máchohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Áhduréhjáa neébe: —Muurá wáyeéévejcóójɨ́ ijcyá mɨ́amúnaa ímí téjcoojɨ iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Áánéllii Mɨ́amúnáájpidívúu o ípívyéévéébé wáábyuta téhdure téjcoójɨ. ");
INSERT INTO boaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Átsihdyúhjáa Jetsóó ímamyémuma tsiiñe úcaavé pihcyáávéjá pañévu. Áájá pañéhjáa tsaapi múhdurá íhyójtsɨ néébeé. ");
INSERT INTO boaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aanéhjáa téijyu wáyeéévejcóójɨ́ íjcyánéllii tsaate dííbyedívúré ɨ́ɨ́tehíjcyá ‘áádíkye éhne ímíjpyetétsóiíbye’ iñééne téénej tééveri dííbyedívú iñéétsóroki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Áánáacáhjáa dííbyeke neébe: —Muúbej, cána dichaj. ");
INSERT INTO boaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ahdújucóhjáa dibye pééneé. Áábedítyúhjáa neebe pámeere tétsii íjcyámeke: —Ámuúhaj, ¿a tehdújuco tsaatéké mepɨ́áábóiyóné íjcyoojɨ wáyeéévejcóójɨj, mityá tsáhaáj? ¿A mépájtyetétsóiyá tsaate dsɨjɨ́veri íjcyámeke téjcoojɨ íjcyaróne, mityá méɨ́hvéjtsóiyá ditye ɨdsɨ́jɨ́ve wáyeéévejcóójɨ́ íjcyánélliíhyej? Ehdúhjáa Jetsóó díllone tsá ditye áñújcutúne. ");
INSERT INTO boaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aanéhjáa dííbyeke tsaríwu pajtyéráhi. Árónáacáhjáa idyé ɨ́dátsó ɨjtsúcunúúbé ditye dííbyeke cáhcújtsotúne. Átsihdyúhjáa neebe diibye múhdurá íhyójtsɨ néébeke: —Muúbej, cána ííllevu cujúúvé díhyójtsɨɨ́. Ahdújucóhjáa dibye cújúúvénemáyé téhojtsɨ ímíjpyeténe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ehdúhjáa Jetsóó méénune paritséomú ɨɨ́ɨ́téne tétsihdyu pééme Heróóde hájkímuma pítyácójcatsí muhdú dííbyeke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Árónáacáhjáa tétsihdyu ímamyémuma peebe únéú úniúvu. Áábekéhjáa mítyane mɨ́amúnaa úraavyé Gariréá iiñújɨ múnaa. ");
INSERT INTO boaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aabéhjáa méénúráítyúronéhjɨ́ mítyane méénúné uubállé tsújaavé pahúllevávu. Áánélliihyéhjáa mítyame tsáácunú pahúllevátú Jodéá iiñújɨtuu, tééné iiñújɨri íjcyacóómí Jerotsaréetuu, Idoméá iiñújɨtuu, Joodáá tsiñéjcutuu, Tííroó, Tsidóoo, íjcyáné iñújɨ́ɨ́cutuu, íjcyane dííbyeke iájtyúmɨki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ehdúhjáa mítyane mɨ́amúnaa Jetsóodívú píhcyaavéjúcóónéllii neebe ímamyémuke ditye mɨɨne iímíbájcho témɨ́ pañévú iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mítyanéhjáa dibye chéméméhjɨke bóhɨ́ɨ́tsohíjcyánéllii ávyetáréjuco ditye dííbyedívú píhcyáávehíjcyáne. Aaméhjáa imíllehíjcyá dííbyeke idyómajcóné ibóhɨɨ́ki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Áijyúhjáa tsaaté pañe naavémú íjcyame dííbyé lliiñévú mɨ́móúúvémé pañétú kéévánécoba néémeé: —¡Uu muurá Píívyéébé Hajchi! ");
INSERT INTO boaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Áánélliihyéhjáa diityéké neebe ditye tsiiñe tehdu iíhjyúvátuki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Átsihdyúhjáa peebe cáméhbaúvú ɨɨ́jtsúcunúdúmema. ");
INSERT INTO boaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Áámedítyúhjáa meménuube 12-meváké dííbyé uwááboju úwááboméré péhíjcyáímyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Áámekéhjáa ájcuube ɨ́ɨhnáhootu ditye chéméméhjɨke ibóhɨ́ɨ́tsohíjcyaki, naavémú tsaaté pañe íjcyámeke ditye iwáágóohíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Aaméhjáa ílluúme: diibyéhjáa Jetsóó Tsimóoke Péédoródívú méménuúbee, Tsebedéó hájchimútsí Jacóóboma Jóáámútsikyéhjáa dííbyere chíjchí hájchimútsidívú méménumútsii, Aderéee, Perípee, Batoroméee, Matéoo, Tomáaa, Apéó hajchi Jacóóboo, Tadéoo, cananíjtámúejpi Tsimóoo, diibyéhjáa Jetsóodívú méénútsóiibye Jóóda Ijcyarióótee, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Áámemáhjáa Jetsóó tsúúca oomí ípyée iícyahíjcyajávu. Áánáacáhjáa tsúúca mítyane mɨ́amúnaa píhcyaavé tétsihvu. Áámedíyéjucóhjáa túhuuvémé tsá imájchóíyónéhjɨ éllevu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aanéhjáa iwáájácúne dííbye hájkímú tsáá dííbyeke tétsihdyu itsájtyéroki. Ɨjtsúcunúméhjáa dibye méívaténe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Téhduréhjáa mítyame tétsihyi taúhbájú uwáábojte Jerotsaréetu tsááme néé dííbyedítyu: —Áádí pañe mɨ́a naavémú avyéjuube Betsebóo. Téénéllii muurá eene dibye pɨ́áábóneri tsaaté pañétú naavémuke waagóohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Áánélliihyéhjáa Jetsóó diityéké nééhií: —¿Aca múhdutú diibye Naavéné iiye waagóómeíiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Muurá tsáné avyéjujte tsajɨ́jtóré ɨ́jtsámeítyúmé páhduváré idyárɨ́ɨ́véjcatsíhajchíí íllure wáchájánújcatsí íavyéjutu. ");
INSERT INTO boaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Áhdure tsája múnaa tsajɨ́jtóré ɨ́jtsámeítyúmé páhduváré idyárɨ́ɨ́véjcatsíhajchíí ílluréjuco ihjyátú wáchájánújcatsíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ahdu ɨ́ɨ́vane muurá Naavéné ihyájkímukéré iwáágóoca íllure pɨ́rújtsóiyá diityéjúcooíyó íavyéjúejte íjcyáíyómeke. Tehdu imyéénuca íllure íavyéjú újóvéjtsóíyoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tsá muurá tsaapi ɨ́htsútúúbé tsíeméné dííbyé já pañétú múha tsájtyéítyuró dííbyeke tétsihdyu bóáyotúmére. Muurá ihdyu dííbyeke tujkénú ibóáyoca botsíi tsajtyéiyómé dííbyé tsíeméne. Árónáa tsáháubá muurá dibye ihñe múhdivú ɨ́hvéjtsóítyuróne. Ahdu ɨ́ɨ́vane tsá Naavéné oke pɨ́áábóítyuró dííbye hájkímuke o wáámíuki. ");
INSERT INTO boaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɨ́mɨáánetúré ámúhakye o néé panéváré ímityúné mɨ́amúnaa méénuhíjcyáronéhjɨ́ Píívyéébe abájɨ́ɨ́veíñé diityédí ɨɨ́dáátsóvénema. Áhdure ímityúné óhdityu ditye ihjyúvahíjcyáronéhjɨ́ ábájɨ́ɨ́véiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Áánetu ihdyu dííbyé Apííchotu ímityúné íhjyúvahíjcyámedi tsá dibye múijyú ɨ́dáátsóvéityúne. Aane tsá múijyú diityémá ímíbáávyéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ehdúhjáa diityéké neebe dííbyé pañe naavéné íjcyane ditye néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Áánáacáhjáa tétsihvu tsɨɨju dííbyé nahbémuma wajtsɨ́ áachí éhnejcúvu. Aaméhjáa tsaatéké néé ditye dííbyeke iñéé dibye iúújéva diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ahdújucohjáa tsaate dííbyé úníuri íjcyame nééne dííbyeke: —Dɨ́ɨ́tsɨ́ɨ́ju díñahbémuma ukévá néhcome éhtsíhyi áachi. ");
INSERT INTO boaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Árónáacáahjáa neebe diityéke: —¿Aca caatyé tátsɨ́ɨ́juú, táñahbémuu, táñaallémuu, íjcyame? ");
INSERT INTO boaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ehdúhjáa iñééne íúníuri ácújcatyémeke ɨɨ́ɨ́téne neébe: —Áánerá téhdure ámuha wahárómú táñahbémú táñaallémú méijcyá íñe múhdumé tahñéjté ámuha meíjcyame. ");
INSERT INTO boaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Muurá Píívyéébeke cáhcujtsómé dibye ímillédú íjcyame ɨ́mɨááné tahñéjté táñahbémú, táñaallémú, wahárómu. Ehdúhjáa Jetsóó diityéké nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aabéhjáa tsiiñe únéú úniúvú úwáábóóbedívú idyé mítyane mɨ́amúnaa píhcyáávénéllii mɨ́ɨ́né pañévú iúcáávéne téémɨ́ pañéturéjuco dibye úwaabóné diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Átsihvúhjáa mítyane tsíeménéhjɨtu úwááboobe nééhií: —Ámuúhaj, cáhawáá mélleebúcunuj: Tsaapíhjyáa íwajcyóhá tríígoúúhá bájtsoobe íllure wávárajcóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aanéhjáa dibye wávárájcónetu tsáuhjɨ juuváj pɨɨnévú dójcone coomɨ́mú méhdojéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ááné tsiúhjɨ́hjáa dojcó néwayúúné raahóvú iiñu imíchi íjcyátútsihvu. Áuhjɨ́hjáa ɨ́ɨ́cúíwuúré iiñé tétsii iiñu mítyane íjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Áróhiibájɨ́hjáa chemé núhbá allóócori hállúháñeríyé tébajkyéjɨ́ íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ááné tsiúhjɨ́hjáa dojcó tsuhjɨ́ pañévu. Ááné hallúvúhjáa teene tsuhjɨ wááménéneri ííñeróné dúhcúvaténé tsáhájuco néévatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Áánetúhjáa ihdyu tsáuhjɨ dojcó tsátsii imíwu ííñujɨ nétsihvu. Aanéhjáa tsaímíyé píívyene imíwu neeváhi. Tsáhiibájɨ́hjáa uhjénéré neeváhi. Áánetúhjáa tsíhiibájɨ́ kémú neeváhi. Ááné tsihííbájɨ́hjáa éhnííñevu mítyane neeváhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ehdúhjáa tsaapi bájtsone iúúbállétsihdyu neebe diityéke: —Ehdu teéne. Aane ihdyu óvíi lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aanéhjáa bóónétu iiye iíjcyátsihvu ímamyémuma tsijtye tétsii íjcyame dilló muhdú nééiyóné teene tsaapi bájtsónetu dibye úwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Áánélliihyéhjáa neebe diityéke: —Muurá ihdyu ámúhadívú Píívyéébe bóhówátsohíjcyá ámuha mewáájácu muhdú dííbyé avyéjú íjcyane. Áánetu eene tsíeménéhjɨtu ó úwáábohíjcyá oke cáhcújtsotúmedívú tene ibóhówáávétuki. ");
INSERT INTO boaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Muurá o úwaabóné lléébójúcoorómé ícyahíjcyá lléébótúmeúvúdu. Áhdure teene ájtyumɨ́júcoorómé ícyahíjcyá ájtyúmɨ́túmeúvúdu. Áámé imítyuháñé muurá tsá ímíbáávyéityúne. Ehdu néénéllii ó úwáábohíjcyá tsíeménéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Átsihdyúhjáa neebe diityéke: —¿Aca ihdyu tsá ámuha mewáájácutú tsaapi bájtsónetu o úwaabóné ɨɨná nééiyóne? ¿Aca múhdutúrá ámuha méwaajácuú tsiiñe téhdure nénéhjɨtu ámúhakye o úwaabóne? ");
INSERT INTO boaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muurá eene tsaapíhjyáa tríígoúúhá wávárajcódú nééne íñe tsaapi ɨ́mɨáájú úwááboobéré pehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aane tsaate ímí lléébójúcóórómeke Naavéné téénetu mútátsohíjcyáhi. Aane muurá nééiyóné eene juuváj pɨɨnévúhjáa dójcoúhjɨ́ coomɨ́mú méhdojéne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Áánetu teene illéébone tsúúca ímí úraavyéjúcoorómé páhduváré nééné mávaríjchojúúné íjcyanéhjɨ́ iáábucújúcóótúnetu ílluréjuco teene ɨ́hvejtsóne. Aane nééiyóné eene néwayúúnéhjáa íjcyátsihvu dójcoúhjɨ́ imíwu ííñeróné núhbá allóócori chémene. Ehdu muurá patyéhijcyáné ímí cáhcújtsótúmema. ");
INSERT INTO boaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Áánetu ɨ́mɨá uwááboju tsúúca ímí llééborómé mítyane ɨ́jɨ́ avyéjuríyé itsúúrámeíñéllii ílluréjuco ténejcu ábájɨ́ɨ́vehíjcyáne. Aane nééiyóné muurá eene tsuhjɨ́ pañévúhjáa dójcoúhjɨ́ ííñeróné íllure dúhcúvaténé néévájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Áánetu ihdyu ijcyámé tsaate tééné uwááboju illéébóne cáhcujtsómé ímí tehdújuco úráávyehíjcyáme. Aame muurá eene imíwuúhjáa ííñujɨ nétsihvu dójcoúhjɨ́ ííñedu. Áámedítyú muurá ijcyámé tsaate eenéhjáa uhjénéré nééváhiibájɨ́dú néémeé. Áánetu ijcyámé tsijtye eenéhjáa kéémú nééváhiibájɨ́dú néémeé. Áánetu ijcyámé tsaate eenéhjáa ávyétá mityáné nééváhiibájɨ́dú nééme ɨ́mɨáánéjuco ɨ́mɨáájú icyáhcujtsóné ímí úráávyehíjcyáme. Ehdúhjáa Jetsóó néé diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Áhduréhjáa neebe diityéke: —¿A múúne peete mepéététsóne mépicyóó tsíeméné lliiñévu? Tsáhaá. Muurá ihdyu mepéététsóne cáámevu mépicyóó tene iájchúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ehdu nééne muurá Píívyéébé uwááboju bóhówajtsó páneere muhdú meícyahíjcyáne. Muurá íñe teevétari meméénuhíjcyaróné tsá wáájácúratúné íjcyáityúne. Muurá páneere waajácúméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aane ihdyu óvíi lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Téhduréhjáa tsiiñe neébe: —Ímíñeúvú tsáma méɨ́jtsoco íñe ɨ́mɨá uwááboju tsúúca ámuha mewáájacújucóóne. Muurá teene ámuha mewáájacújúcoorómé múhdurá medárɨ́ɨ́vémeíhajchíí Píívyéébe tsáhájuco ámúhadi ɨ́ɨ́cúvéityúne. Áánetu tsúúca iwáájacúné ímí úráávyémeke éhnííñevu waajácútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Muurá ɨ́mɨáájú ímíllémedívú bóhówájtsóiibye éhnííñevu ditye ímíñeúvú iwáájácuki. Áánetu teene ímíllétúmedívú tsá dibye bóhówájtsóityúne. Ááne tsáijyu múu áyánéwu ditye wáájácuróné dojtúcúiibye diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Téhduréhjáa neebe diityéke: —Muurá tsaapi bajtsó tríígoúúhá íwajcyóha. ");
INSERT INTO boaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aane ɨ́búwajɨ́ɨ́ dibye íjcyánáa keemévehíjcyá pajcóójɨváré dibye wáájácútúné hallúri. ");
INSERT INTO boaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ehdu muurá ííñújɨri ímí bajtsóháñé píívyene ikyéémévéne tsúúca wajcó iñéévá ípívyééveíñéjuco. Aane tsúúca neeváhi. ");
INSERT INTO boaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aane kéémécooca ílluréjuco áábájaabe újcune. Ehdu muurá pajtyéiñe Píívyéébé avyéjúejtéma. Muurá diityéké dibye újcúíñe éévé úújetécooca újcúiibye diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Téhduréhjáa tsiiñe neebe Jetsóó diityéke: —¿Aca ɨ́ɨ́netú íñe tsiiñe ámúhakye ó úwááboó Píívyéébé avyéju? ");
INSERT INTO boaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Muurá dííbyé avyéjú éhne múúne ‘mojtáátsa’ némeíñé uméhé neeváú kémúútúróúwu mebájtsou mítyáhécoba kéémevédu. Muurá pahévá neváúúné lliiñévúré tééhé neeváú ávyétá ayáúwu. ");
INSERT INTO boaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Áróúwu muurá mebájtsou ííñene keemévé mítyáhécoba pahéváré bajtsóhééné ehnííñevu. Ááhé wájcáváné hallúvú muurá wahpéjté pɨ́htobáhi. Ahdu muurá teene Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ehdúhjáa Jetsóó mɨ́amúnáake iúwaabóné tsíeménéhjɨtu úúbállehíjcyá muhdú ditye lléébóiyódu. ");
INSERT INTO boaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tsáháhjáa dibye pevénéré úwáábohíjcyatúne. Árónáacáhjáa ihdyu ímamyémuke ímíñeúvú waajácútsohíjcyaabe ɨɨná tene nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ááné iijyúnuvúhjáa neebe ímamyémuke: —Métsu éhnéjcúeúvú mepéékií. ");
INSERT INTO boaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ahdújucóhjáa tétsihíyé tsijtye íjcyánáa ditye pééne tsíñejcúeúvú mɨ́ɨ́neri. Áámemájucóhjáa idyé tsaate ɨhmɨ́néneri pééneé. ");
INSERT INTO boaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Aaméhjáa pɨ́ɨ́nééuri íjcyánáa ávyétá ɨhnáhó kííjyébari mítyane nújpacyo nóhjɨne úcaavé diityé mɨ́ɨ́né pañévu. Aanéhjáa ipámáávéíyóneri iíllityéne diitye ímamyémú idyéjuri cúwahíjcyáábeke iákyéjtsóne nééhií: —¡Ávyéjuúbej, tsúúca mémájcánuúhi! ¿A tsá íñe meke u pájtyetétsóityúne? ");
INSERT INTO boaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Áánélliihyéhjáa iájkyéne úhbaabe kííjyébama nohjɨ íjcyane. Neebéhjápeé: —¡Iijyévéne, dɨhvéte! Ahdújucóhjáa tene ɨ́hveténé dáíhañéréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Átsihdyúhjáa neebe diityéke: —¿Ɨ́veekí ayájú ɨhnáhórá ámuha meíllityéne? Tsáháhaca bo ámuha Píívyéébeke ímí mecáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ehdúhjáa diityéké dibye néérónáa íllure íllityémé néjcatsíhi: —¿Muubáami aabye íjcyáábeke muhdú kííjyébama nújpacyo lleéboj? ");
INSERT INTO boaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aaméhjáa tsúúca úújeté tsíñejcúeúvú Gadáárá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aanéhjáa ditye cátsúúvénemáyé Jetsóó ijchívyéhi. Áábe éllevúhjáa tsaapi níjkyénéj pɨɨne ícyahíjcyaabe tsáá ípañe naavéné íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aabéhjáa ávyéta tsɨ́jpá néébeke tsá múha píívyetétú iékeevéne. Úwááñehíhjyáa íjcyáróneri tsá múha dííbyeke chíjchúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tsáijyúhjáa tsúúca dííbyeke chijchújúcohíjcyarómé íjtyúháácyuma íhyójtsɨcu. Áronéhjáa távúdócohíjcyaábe. Tsáháhjáa múha dííbyeke muhdú méénúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aabéhjáa cójɨ́hajchótá pécóhajchótá íhjyúcunúúbéré pehíjcyá níjkyénéj pɨɨ́ne. Ááné tsaíjyúhjáa cáméwajúneri pehíjcyaabe néwayúúnetu wápújúhcámeííbyére. ");
INSERT INTO boaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aabéhjáa tsíhyullétúré Jetsóoke iájtyúmɨ́ɨ́be éllevu dsɨɨnéríyé ipyééne mɨ́móúúveté dííbyé lliiñévu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Áánemáhjáa kéévánécoba neebe dííbyeke: —¿Ɨɨná óhdityu ú imíllé ɨ́htsútuube Píívyéébé Hajchi Jetsóó u íjcyaábe? Uke Píívyéébe mémeri o néé óhdi u ɨ́cúbáhrátuki. ");
INSERT INTO boaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ehdúhjáa naavéné dííbyé pañétú néé Jetsóoke dibyéhjáa dííbyeke ‘díjchivye áádí pañétu’ néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Áábekéhjáa Jetsóó nééhií: —¿Aca muubá dimyéme? Áánélliihyéhjáa neébe: Tamyémé Píváánéejpi mítyame muha meíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aanéhjáa diitye naavémú néé Jetsóoke dibye diityéké iwáágóótu tsíhyullévú tééné iiñújɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Áihjyúhjáa tétsihyi jéémú meenímú majchóri. ");
INSERT INTO boaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Áánélliihyéhjáa dííbyeke néémeé: —Múúhakye ihdyu wallo aatye méénímú pañévuréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ahdújucóhjáa dibye wállóónéllii dííbyé pañétú iíjchívyéne méénímú pañévuréjuco ditye újcámeíñe. Aaméhjáa ditye méívatétsómé 2,000-meváubáhjáa íjcyame cáméwájutu únéú pañévú cáhtsíñibámé májcanúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ááneríhjyáa diityé tehméjté iíllityéne ɨ́ɨ́cúi tétsíi múnáake úúballéhi. Áánélliihyéhjáa téhullévú péécunúmé iájtyúmɨ muhdú tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aaméhjáa úújeté diibye eenée ípañe naavémú ícyahíjcyaabe tsúúca íwajyámúúnema íjcyaabe pevétsɨhjɨ́duréjuco ácuúcunúúbedívu. Ááneríhjyáa íllityéme. ");
INSERT INTO boaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aanéhjáa tétsihyi íjcyame úúballé diityéké muhdú tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aanéhjáa múhdurá ɨɨ́jtsúcunúnéllii nééme Jetsóoke dibye tééné iiñújɨtu ipyéé tsiéllevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Áánélliihyéhjáa Jetsóó ipyéé mɨ́ɨ́né pañévú úcáávéébeke diibye eenée ípañe naavémú ícyahíjcyaabe néé dííbyemáyéjuco ipyéékií. ");
INSERT INTO boaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Árónáacáhjáa neebe dííbyeke: —Tsá u pééityú óómaá. Dihyájkímú pañévúré pééne duubállé diityéké muhdú Píívyéébe úhdi ɨɨ́dáátsóvéne uke ímíjpyetétsóne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ahdújucóhjáa dibye ihyájkímú pañévú ipyééne úúballéné páneere muhdú Jetsóó dííbyeke bóhɨɨtsóné Decááporí iiñújɨri íjcyácoomíjɨ múnáake. Ááneríhjyáa ávyetáré ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aanéhjáa Jetsóó ímamyémuma bɨwánejcúvúré úújeténáa idyé tsúúca mɨ́amúnaa píhcyaavé dííbyedívú únéú úniúvu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Átsihvúhjáa ‘Jáiro’ némeííbyé wajtsɨ́ pihcyáávéjá avyéjuube íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aabéhjáa dííbyé lliiñévú ícyánoovéváne nééhií: —Ájyúwa ávyeta dsɨjɨ́veríjyuco íjcyánéllii uke o néé u dócárájcoté dille óóma ibóhɨɨ́ki. ");
INSERT INTO boaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ahdújucóhjáa Jetsóó dííbyema péébeke mítyane mɨ́amúnaa úraavyé ávyeta rááutúne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Áámé pañéhjáa tsáápille 12 pijcyábájuco díílleke ichémé tujpácyó ɨ́hvetépítyúneri ɨ́cúbáhrámeíhíjcyalle. ");
INSERT INTO boaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aalléhjáa bañúháñé taabójtedívú ityáábótsámeíñé áhdohíjcyá ihñénehjɨ́vú ‘pɨrúhpɨ́rújuco’. Áróné pañéhjáa íllure ávyetélle. ");
INSERT INTO boaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aalléhjáa muubá Jetsóó íjcyane iwáájácúne mɨ́amúnáá raahótú dííbye éllevu ipyééne dííbyé wajyámú dómajcó ‘muurá dííbyé wajyámú íjcyaróné o dómájcóhajchíí ó bóhɨɨ́hi’ iñéénema. ");
INSERT INTO boaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ehdúhjáa ɨɨ́jtsámeíñe dómájcolle dííbyé wajyámu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Áánetúhjáa ɨ́mɨááné tsúúca bóhɨɨlle tsaímiyéjuco llíñémuúcunúmeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aanéhjáa Jetsóó waajácú tsaate bóhɨɨne dííbyé wajyámú idyómájcóneri. Áánélliihyéhjáa iyévóóvéne néébe diityéke: —¿Caatyé ámuha táwajyámutu oke médómajcóhi? ");
INSERT INTO boaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Áánélliihyéhjáa ímamyémú nééhií: —¿Aca muhdú mɨ́amúnaa wahdyúré néétúnáa ú dilló múha uke dómajcóne? ");
INSERT INTO boaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ehdúhjáa ditye néérónáa pahúlleva ɨ́ɨ́teebe iájtyúmɨ caatyé dííbyeke dómajcóne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Áánélliihyéhjáa eenée dííbyeke dómájcolle iíllityéneri úúvécunúlléré dííbyé lliiñévú ɨmɨ́móúúveténe úúballé dííbyé wajyámú idyómajcóne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Áánélliihyéhjáa neebe díílleke: —Wáhaj, ímí Píívyéébeke u cáhcujtsódú íjcyalle tsúúca ú bohɨ́ɨ́hií. Ahdícyane wa dipye tsaímiyéjucoj. ");
INSERT INTO boaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ehdúhjáa Jetsóó díílleke néénáa tsaate pihcyáávéjá avyéjuube Jáiró jatu tsááme úúballévá dííbyeke ɨ́dsɨ́wu dsɨ́jɨvéjucóóne. Nééméhjáa dííbyeke: —Tsúúca dáájyuwa dsɨ́jɨvéhi. Aane ɨ́ɨ́nélliihyécó ú tsájtyeé aabye uwáábóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ehdúhjáa ditye nééneri ɨ́ɨ́cúvétuube Jetsóó néé Jáiróke: —Kímóóvedíñe. Píívyéébekéré cahcújtso. ");
INSERT INTO boaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ehdúhjáa iñééne tsá dibye ímílletú pámeere dííbyema pééneé. Apáámyéréhjáa péé dííbyema Péédoroo, Jacóóboo, dííbyé nahbe Jóáaá, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aaméhjáa pééme úújeté mítyane mɨ́amúnaa tééjá pañe táhíjcyámedívu. ");
INSERT INTO boaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Áámekéhjáa Jetsóó neetéhi: —¿Ɨ́ɨ́neríami ámuha metaj? Áánerá tsá dille dsɨ́jɨ́vetúne. Muurá íllure cúwalle. ");
INSERT INTO boaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ehdúhjáa dibye nééneri íllure goocóme. Áámekéhjáa tééjá pañétú iíjchívyétsóne iiyéjuco dibye úcaavéné díílléwúuúvúj caanímútsii, diitye 3-meva ímamyémuu, íjcyámema. ");
INSERT INTO boaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aanéhjáa díílléwúuúvuke íhyójtsɨtu iékéévéne neébe: —Taríta cómi, ‘Wáhaj, dájkyeé’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ehdúhjáa dibye néénemáyé éhne múu cuwátú maájkyevádú ibóhɨ́ɨ́ne tsúúca úllelle 12 pijcyábáhjáa íjcyalle. Ááneríhjyáa mɨ́amúnaa ávyetáré ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Áámekéhjáa Jetsóó bóijcyú muucá ditye teene iúúbállétuki. Átsihdyúhjáa neebe ditye imájchótso díílleke. ");
INSERT INTO boaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Átsihdyúhjáa ímamyémuma óómiibye ípyée ipíívyéné iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aabéhjáa wáyeéévejcóójɨ́ pihcyáávéjá pañévú úwaabóné mítyame illéébóneri dííbyedi iúllévenúne nééhií: —¿Kiátúami aabye ehdɨ́ɨ́vaíñé panéváré wáájacúnej? ¿Aca múhdutú piivyéteebe méénúráítyúronéhjɨ́ imyéénune? ");
INSERT INTO boaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Áánerá úméhewááné wákimyéi múnáajpi diibye Maaríá hajchi. Áábé nahbémújuco muurá Jacóóboo, Jotséee, Jóódaá, Tsimóoo, éhdume. Téhdure muurá íñaallémú ijcyá íchihyi méjpɨɨ́ne. Ehdúhjáa dííbyedítyú iñééne tsá ditye ávyejúúlletú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Áánélliihyéhjáa neebe diityéke: —Ihdyújuco tsáma Píívyéébé ihjyú uubálle múnáajpi íjcyáróóbeke dííbyé iiñújɨ múnaa ihyájkímú íjcyarómé tsá ávyejúúlletú tsíjtye múnaa íjcyarómé ávyejúúlléébeke. ");
INSERT INTO boaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ehdúhjáa tétsíi múnaa dííbyeke cáhcújtsótúnéllii tsá dibye tétsihvu mítyane méénúráítyúronéhjɨ́ méénutúne. Apááñéréhjáa chéméméhjɨke idyócárájcóneri bóhɨ́ɨ́tsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ílluréhjáa ullévenúúbé ditye dííbyeke cáhcújtsótúneri. Áánélliihyéhjáa técoomí úníuri íjcyájáhjɨ múnáakéréjuco dibye úwááboobéré péhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aabéhjáa tsáijyu ímamyémú 12-meva íjcyámeke uwáábovu wallóó míítyétsícyutsáké pahúllevávu. Áámé pañévúhjáa pícyoobe ɨtsɨ́jpá dííbye mémeri tsaaté pañe naavémú íjcyámeke ditye iwáágóohíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Áámekéhjáa neebe ditye itsájtyétu ícyahpáyuu, imájchoo, ɨdsɨ́ɨ́dsɨɨ, íjcyane. Apááñéréhjáa neebe ditye ipyéé íhyallúejáhjɨ́ íwajyámúnee, íjtyúhápaajɨ́nee, ícyuujúii, íjcyánema. ");
INSERT INTO boaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Áámekéhjáa neébe: —Tsátsihvu ámuha tsaaté javu meúújetéjaríyé méíjcyaco tsiéllevu ámuha mepéétúné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aane tsátsíi múnaa ámúhá uwáábó cátúhtsóhajchíí múu ámúháj tuhááñeri íjcyáne ííñú píchóújcámeí diityédívu, ‘tsá múúhá hallúrí tene íjcyatú ámúhakye muha meúwáábóiyóné ámuha mecátuhtsóne’ nééiyóne. Ááne múu péé tsiéllevúréjuco. Muurá múhdumé ámúhá uwáábó cátuhtsómé ávyétá ɨhnáhó ɨ́cúbáhráméií muhdú mɨ́amúnaa ícyahíjcyáne ímíbájchómeícyooca éhnée Tsodóómaa, Gomóóraa, íjcyácoomícyu múnaa ɨ́cúbáhrámeíñé ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ehdúhjáa ímamyémuke téɨ́búwájtsoobe uwáábovu iwállóómeke. Aaméhjáa úwáábohíjcyá mɨ́amúnáake ditye ímityúné iícyahíjcyáné ɨɨ́hvéjtsóne ɨ́ɨ́jtsaméí icyápáyóóve ɨ́mɨánejcúvuréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Téhduréhjáa tsaaté pañe naavémú íjcyámeke waagóohíjcyáme. Chéméméhjɨkéhjáa dúúrúbájpácyori íhñíwaúúné ditye pɨ́pájchóneri bóhɨhíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ehdúhjáa Jetsóó méénuhíjcyáné uubállé ávyéjuube Heróódé iwáájácúne nééhií: —Tsojtsó múnáajpi Jóáa éhnée dsɨ́jɨ́veebéubá tsiiñe bohɨ́ɨ́hií. Muurá téénéllii piivyéteebe méénúráítyúronéhjɨ́ imyéénune. ");
INSERT INTO boaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Áánetúhjáa tsijtye nééhií: —Tsáhaá, muurá ihdyu Eríá diibye Píívyéébé ihjyú uubálle múnáajpíi éíjyuúvú ícyahíjcyaábe. Áánetúhjáa tsijtye nééhií: —Áánerá ihdyu béébére diibye Píívyéébé ihjyú uubálle múnáajpi éíjyuúvúu ícyahíjcyáméejpi. ");
INSERT INTO boaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ehdúhjáa ditye néénéllii tsiiñe Heróódé nééhií: —Tsáha bóhoj, muurá ihdyu diibyéjuco tsojtsó múnáajpi Jóáa éhnée íhñíwaúvú o kípíyuúcútsoobéha tsiiñe bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Diibyéhjáa muurá Heróódé táábavá ítyónúllekéré íñahbe Perípé taaba Herodíake. Aanéhjáa ímityúné íjcyane Jóááuvu dííbyeke néhíjcyáné hallútú cuvéhoojánútsoobe úwáñehííñeri ichíjchútsóóbedívu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Téhduréhjáa diille Herodíá dííbyeúvuke tééné hallútú iñéhnílléne imíllé ɨdsɨ́jɨ́vetsóne. ");
INSERT INTO boaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Árónáacáhjáa tsá dille píívyetétú muhdú dííbyeke ɨdsɨ́jɨ́vétsóiyóné diibyéhjáa Heróódé Píívyéébeéjpí dibye íjcyáneri iíllityéne díílleke téhmehíjcyánélliíhye. Áánélliihyéhjáa díbyeúvú íhjyúvanéhjɨ́ tsáríyóné pañe lleebúcunúhíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Árónáacáhjáa diille Herodíá tsúúca dííbyedívú lliihyánútsoóhi. Diibyéhjáa Heróódé ɨ́tsɨɨmávajcóójɨ́ úújeténé wáñehjɨ́núhi. Ááne éllevúhjáa pihjyúcuube ɨ́pɨáábojtee, ítsodáhómú avyéjujtee, Gariréá iiñújɨ́ ɨhtsútujtee, éhdúmeke. ");
INSERT INTO boaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ááméj pɨɨnévúhjáa dííllé ajyúwá bádsɨ́jcaja wáhtsɨne imíwu ɨjtsúcunúúbé diibye Heróóde. Áhduréhjáa dííbyeke náhbénúné avyéjujte ímí ɨjtsúcunúhi. Áánélliihyéhjáa díílleke neébe: —Ɨɨná u ímilléné oke táuméí ávyeta ɨ́mɨááné állítyuube uke o ájcuki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ehdúhjáa Heróódé néé díílleke ɨ́mɨáánetúré ɨɨná dille táúmeíñevu iájcuíñe. Neebéhjáa ávyeta íavyéjú íjcyárónetu tsahdúnéécú díílleke iájcuíñé teene dille táúmeíhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Áánélliihyéhjáa tsɨ́ɨ́ju éllevu ipyééne neetélle: —¿Aca Wa ɨɨná íñe ó táúmeíiyáhi? Áánélliihyéhjáa neelle díílleke: —Táuméí tsojtsó múnáajpi Jóáá nííwau ikípíyuúcuúvú uke dibye iájcuki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ahdújucóhjáa dille dííbye éllevu ipyééne néétene: —Ó imíllé bohtájɨri oke u ájcune tsojtsó múnáajpi Jóáá nííwaúvu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ehdúhjáa dille nééne dííbyeke kímóhcó pajtyéráhi. Árónáacáhjáa eene dííbyeke náhbénúné avyéjujte lléébónáa díílleke iállíityúné iñéénéllii tsá dibye ‘tsáhaá’ néétune. ");
INSERT INTO boaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Áánélliihyéhjáa ɨ́ɨ́cúi ítsodáhómudítyú tsáápiikye wálloobe cúvéhóójá pañe íjcyáábeke íhñíwau ikípíyuúcúne dibye itsívaki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ahdújucóhjáa dibye ipyééne ikípíyuúcúne bohtájɨri itsívaúvú ájcuváné díílleke. Aaúhjáa tsajtyéllé tsɨ́ɨ́ju éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ehdúhjáa tsojtsó múnáajpi Jóááuvu dsɨ́jɨvéhi. Ááné uubálléhjáa ímamyémú illéébóne újcujé dííbyeúvuke icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Áánáacáhjáa Jetsóó mamyémú úwááboméré ipyéhíjcyátsihdyu tsúúca óómimye tsiiñe píhcyaavé dííbyedívu. Aaméhjáa úúballé dííbyeke páneere muhdú téhulle imyéénuhíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Áámekéhjáa neébe: —Cána metsu múha íjcyátúhullévú mepéé mewáyéééveki. Ehdúhjáa neebe ímamyémuke ‘rááho néétune’ mɨ́amúnaa tsaate péénetu tsíjtyeréjuco dííbyedívú píhcyáávehíjcyánélliíhye. Áámedíyéhjáa íjcyame tsá imájchóíyónéhjɨ éllevu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Áánélliihyéhjáa pééme mɨ́ɨ́neri múha íjcyátútsíí tujkévetu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Árómekéhjáa mítyame ájtyumɨ́ kiávú ditye pééneé. Áhullévújucóhjáa ɨ́ɨ́cúi ditye pacóómivátúré péécunúné íjchityu. Aaméhjáa diityé ɨhdéré úújeté kiávú ditye pétsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aaméhjáa tétsihyíjyuco íjcyámedívú Jetsóó úújeténe. Áámedíhjyáa ɨ́dáátsóveebe éhne múúne ítyehméébema íjcyatúmé obééjámú íjcyadu ɨ́dátsó diityéké ɨɨ́ɨ́ténélliíhye. Áámekéhjáa imyéénuhíjcyádú úwaabójúcoobe mítyane panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aanéhjáa cúvéhréjuco néénéllii ímamyémú néé dííbyeke: —Muhdú cúvéhréjuco teene íchii múubárá íjcyátútsihyi meíjcyánáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ílluréjuco wallo aatyéké íchííj pɨɨhɨ́rí íjcyájáhjɨ múnáadítyú tsíeménéuba iújcune ditye imájchoki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Áánélliihyéhjáa neébe: —Ámuháyé bo mémajchótsó diityékej. Árónáacáhjáa néémeé: —¿Aca íhya tsiiñe maáhdone pámehdívúré úújetéiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Áánélliihyéhjáa neébe: —¿Aca múhduná majcho méhdií? Cána méuvánuj. Áánélliihyéhjáa néémeé: —Ijcyánéha 5-hova páahóónema míítyétsi amóóbemútsi. ");
INSERT INTO boaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Áánélliihyéhjáa neebe mɨ́amúnáake ditye iáhcúba páhadsɨ́jɨ. ");
INSERT INTO boaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ahdújucóhjáa ditye áhcubáne. Tsáhadsɨ́jɨ múnaáhjáa 100-mevátsa. Áánetúhjáa tsíhyadsɨ́jɨ múnaa 50-mevátsa. ");
INSERT INTO boaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aanéhjáa páahóónema amóóbemútsikye iékéévéne téhdújtsoobe Píívyéébeke cáámevu icyárúúvénema. Ááné boonétúhjáa idyóhdáhɨ́núne neebe ímamyémuke ditye iwájtu pámeekére. ");
INSERT INTO boaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aanéhjáa imájchónetu pámeere oové tsaímíye. ");
INSERT INTO boaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Áánetúhjáa cóeváné 12-rujtsívá úvérujtsíñe wáhpe. ");
INSERT INTO boaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aaméhjáa diitye eenée tétsihvu májchome 5,000-meva. ");
INSERT INTO boaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Átsihdyúhjáa Jetsóó néé ímamyémuke ditye dííbyé ɨhde únéú tsiñéjcuvu mɨ́ɨ́neri ipyééne iúújeté Betsáidávú dibye mɨ́amúnáake pityájcóné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aanéhjáa diityéké ipítyájcóne peebe cáméhbaúvú Píívyéébema iíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Áánáacáhjáa diitye ímamyémú pééme pɨ́ɨ́néeúvújuco ííjyunúne. ");
INSERT INTO boaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Áámekéhjáa dibye ɨ́ɨ́ténáa kííjyéba nóhjɨ́ wájojcómé ɨ́htsútúnetu bóhdámeíhijcyáhi. Ááme déjutúhjáa pejcójuco dibye pééne nújpácyó hallúrí úlleebéré diityéké pájtyeíñúiibyédu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Áábekéhjáa iájtyúmɨ́ne íllityémé wáníjcyámeí naavénekéré iwáábyúnema. ");
INSERT INTO boaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Árónáacáhjáa neebe diityéke: —¡Méíllityédíñe, oóre! ");
INSERT INTO boaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aabéhjáa diityé pañévú úcáávénemáyé kííjyeba ɨ́hveténeri ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tsáháikyéhjáa ditye ímí dííbyeke cáhcújtsotú dibyée ɨ́hde majcho mítyámedívú úújetétsórónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Aaméhjáa tsíñejcúeúvú Genetsaréé iiñújɨvu úújetémeke tétsíi múnaa iájtyúmɨ́ne waajácú diityémá Jetsóó íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Áánemáhjáa úbálléjcatsímyé tsúúca dibye tééné iiñújɨvu wájtsɨne. Áánélliihyéhjáa pahúllevátú chéméméhjɨke tsivámé dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aabéhjáa patsɨ́hjɨváríyé íjcyámeke úwááboobéré pehíjcyá cómíñeri íjcyámeke, ííyéétsɨhjɨ́rí íjcyajáhjɨ múnáake, íúmɨhéneri íjcyámeke. Átsɨ́hjɨ múnaáhjáa idyé chéméméhjɨke pícyohíjcyá dibye pájtyéítsɨhjɨ́vu. Áánemáhjáa nehíjcyámé dííbyeke dibye diityéké íwajyámúubávúré idyómájcótso ditye ibóhɨɨ́ki. Ahdújucóhjáa dííbyeke íwajyámú dómajcóméjuco bóhɨhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aanéhjáa Jetsóodívú tsáijyu paritséómuma taúhbájú uwáábojte Jerotsaréetu tsááme píhcyaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aaméhjáa ɨɨténáa dííbyé mamyémudítyú tsaate íhyójtsɨne níjtyámeítyúmé majchóhi. Aanéhjáa múhdurá ɨjtsúcunúmé ɨ́hdé múnáaúvúu méénuhíjcyádú ditye méénutúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Diityéhjáa Píívyéébedívú iímíbájchómeíñéjuco imájchóíñé ɨhde íhyójtsɨne nítyámeíhijcyáne. Tsáháhjáa ditye májchóítyuró níjtyámeítyúmé tééné uwááboju iúráávyénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tsíeménéhjáa iñáhjɨ́hénújétsihdyu wájtsɨme iñíjtyámeítyúhajchíí tsá máchohíjcyatúne. Imájchoháñé imyéénuhíjcyanéhjɨ́hjáa nítyuhíjcyáme. Áhduréhjáa icyúwaháñé nítyuhíjcyáme. Áánetúhjáa ijcyáné mítyane tsíñehjɨ ditye méénuhíjcyáné ityútávájtsámeíñé iímíjpyetéki. ");
INSERT INTO boaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aanéhjáa iúraavyépíñéllii diitye paritséómuma taúhbájú uwáábojte néé Jetsóoke: —¿Aca ɨ́veekí dímamyémú tsá nítyámeíhíjcyatú imájchóíñé ɨhde ɨ́hdé múnáaúvú uwááboju néhduú? ");
INSERT INTO boaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Áánélliihyéhjáa neebe diityéke: —Ámuha pánehjɨ́dú ɨ́mɨáámeúvúdú bañú múnaa ámuha meíjcyame. Ɨ́mɨáánéhacáa Itsaíaúvú Píívyéébé ihjyú uubálle múnáajpi ámúhadítyú nééhií: Íjtye oke ávyéjútsohíjcyará hállúéjuríye. Tsá ávyeta ɨ́ɨ́ɨ́búuri oke ditye ávyéjútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Íllure iállíñe oke duurúvahíjcyáme. Aame iiye iípívyéjtsóné uwáábojúúné úráávyehíjcyá pánehjɨ́dú tátyaúhbajúúné iúráávyeúvúdu. Ehdúu muurá Itsaíaúvú caatúnú ámúhadítyu. ");
INSERT INTO boaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aame ámuha tsá meɨ́ɨ́cúvehíjcyatú ímichi keená Píívyéébé taúhbaju íjcyáneri eene íhdityúré iújcúné ɨ́jtsaméí mɨ́amúnaa úwáábohíjcyáneríyé ámuha meɨ́ɨ́cúvehíjcyánélliíhye. Muurá eene llíyihllóne níjtyú álliúré íjcyane ditye úwaabóné ámuha méúráávyehíjcyáhi. Téhdure tsíñehjɨ álliúré ditye méénune ámuha meúráávyehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Téhduréhjáa tsiiñe neebe Jetsóó diityéke: —Ámuha mɨ́amúnáadítyúré tsááné uwáábó meúráávyéne ¿ɨ́veekí tsá Píívyéébé taúhbájuri meɨ́ɨ́cúvehíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Íllúu muurá Píívyéébe néé Moitséeúvuj tééveri: “Ámúháj caanímuke múu iwájyúne avyéjuulléhi. Áánetu cáánímuke tútávátsohíjcyámé ihdyu óvi dsɨ́jɨvéhi.” ");
INSERT INTO boaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ehdu dííbyé taúhbaju néérónáa muurá ámuha méúwáábócatsíhijcyá tsaatévá cáánímútsikye nééiyóne: “Tsá o píívyetétú ámúhtsikye o pɨ́aabóne. Ámúhtsikye o pɨ́áábóiyódú ɨ́ɨ́vane Píívyéébekéréjuco o ɨ́ɨ́cúvehíjcyáne.” ");
INSERT INTO boaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aanévá ehdu íhjyúváróóbé hallúrí tsá ɨɨná íjcyatú diityétsikye dibye pɨ́áábótúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ehdu muurá ámúhá ɨ́jtsaméityúré tsááné uwáábó ámuha meúráávyéne tsá Píívyéébé taúhbájuri meɨ́ɨ́cúvehíjcyatúne. Áánetu ijcyáné mítyane tsiiñe állíunéhjɨ́ ámuha meméénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ehdúhjáa iñétsihdyu tsiiñe neebe diityéke: —Ímíñeúvú mélleebúcunu ámúhakye ɨɨná o nééne ámuha mewáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Muurá panéváré mɨ́amúnaa májchoróné tsá diityé ɨ́ɨ́búwá ɨ́jtsaméí tútávájtsotúne. Áánetu ihdyu diityé ɨ́buwááné déjúcotúré néhnijyu tsááne diityéké tútávajtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aane ihdyu óvíi lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ehdúhjáa diityéké iñééne peebe ímamyémuma tsájaávu. Átsihvúhjáa dííbyeke dillómé ɨɨná nééiyóné ehdu dibye úwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Áánélliihyéhjáa neebe diityéke: —¿Aca ihdyu ámuha meíjcyarómé tsá mewáájácutú ɨɨná tene nééiyóne? Muurá panéváré memáchohíjcyanéhjɨ́ tsá meke tútávájtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tehdu teene majchótú ímítyúné ɨ́jtsaméí tsáánejɨ́ɨ́vari. Muurá pevénéré méjpíítyu pajtyéne. Ehdúhjáa Jetsóó úwaabó panéváré majchóháñé dooháñema ímí nééne maáwáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Átsihdyúhjáa idyé tsiiñe neébe: —Muurá ihdyu mɨ́amúnáá ɨ́ɨ́búwá déjúcotu ílluune ímítyúné ɨ́jtsaméí tsááne diityéké tútávajtsóhi: ihdícyáméhjɨmáyé ditye dómácócatsíhijcyáne, ditye dsɨ́jɨ́vétsócatsíhijcyáne, ditye nánihíjcyáne, tsíjtye éhneri ditye úmúúpívyehíjcyane, ditye állícyatsíhijcyáne, panévá oove íjcyatúné ditye óóvehíjcyáne, ditye nómíutáávahíjcyáne, ditye tsíjtyedi íhjyúvahíjcyáne, ditye mítyákímyeíhijcyáne, ditye múhdurá ɨ́tsámeíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Énehjɨ ihdyu mɨ́amúnáá ɨ́ɨ́búwá déjúcotu tsááne diityéké tútávajtsóhi. Ehdúhjáa neebe Jetsóó ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Átsihdyúhjáa idyé peebe diityémá Tííroó, Tsidóoo, íjcyácoomícyú íjcyáné iiñújɨvu. Aaméhjáa tsájaavu úújeténáa tsá dibye ímílléturó múha wáájacúné kiá dibye íjcyane. Árónáacáhjáa tsá dibye téévehíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Áánélliihyéhjáa ɨ́ɨ́cúiye waajácúmé tétsihvu dibye wájtsɨne. Aanéhjáa tsúúca tsáápille tsáá dííbye éllevu ɨ́dsɨ́ pañe naavéné íjcyalle. ");
INSERT INTO boaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aalléhjáa mɨ́móuuvévá dííbyé lliiñévú Tsiropeníítsiá iiñújɨ múnáalle tsíjtye múnáalléré íjcyárolle. Áánemáhjáa Jetsóoke neelle dibye iwáágóo naavéneke ɨ́dsɨ́ pañétu. ");
INSERT INTO boaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Árónáacáhjáa neebe díílleke: —Tujkénúi tahájkímuke ó pɨ́ááboóhi. Tsá muurá tsaapi ɨ́ɨ́tsɨ́ɨ́medítyú majcho idyójtúcúne oohímyeke ájcúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Áánélliihyéhjáa neelle dííbyeke: —Ihdyúhde tehdújúcoóro, Ávyéjuúbej. Árónáa muurá múúne oohímyé íjcyarómé majchó tsɨɨme imájchotu dójcótsówaahyéjɨ. ");
INSERT INTO boaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Áánélliihyéhjáa neebe díílleke: —Tehdújuco, muúllej. Ahdícyane wa dipye dihjyávuj. Tsúúca muurá ícyooca dáájyuwa bohɨ́jucóó. Tsáhájuco dííllé pañe naavéné íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ahdújucóhjáa péélle úújeténé ɨ́dsɨ́divu pevétsɨhjɨ́duréjuco icyúwá pañe tódsɨúcunúlledívu. Tsáhájucóhjáa naavéné dííllé pañe íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aanéhjáa tétsihdyu Tíírótu Jetsóó ímamyémuma péé Tsidóovu. Átsihdyúhjáa Gariréá unéuvúréjuco pééme pajtyé Decááporí iiñújɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aaméhjáa tsúúca tétsihyíjyuco íjcyánáa tsaate tsivá dííbye éllevu lléébótuube ihjyúvátúúbeke dibye iímíbájchoki. ");
INSERT INTO boaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Áábekéhjáa diityédítyú tsátsihvu itsájtyéébeke íhyójtsɨ́wari íñúhejúúcú ibóríjcyóne iúúniyi dííbyé nɨ́ɨ́jɨwa pɨ́pájchoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Áánemáhjáa cáámevu icyárúúvéne tsɨ́jpánécoba iállíjchúne dííbyeke neébe: —¡Epááta! ‘Díñúhejúúcú dímíbáávyéne lleébo’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahdújucóhjáa dibye tsúúca llééboobe tsaímiyéjuco íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aanéhjáa ájtyúmɨ́meke bóíjcyuube ditye tsíjtyeke iúúbállétuki. Árónáacáhjáa úúballéme. ");
INSERT INTO boaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ááneríhjyáa ávyétá ɨhnáhó iúllévenúne néémeé: —Panéváréhaca ihdyu ɨ́mɨááné piivyéteébe. Íñúhejúúné lléébótúmekéha piivyéteebe illéébotsóne. Áhduréha íhjyúvátúmeke piivyéteebe iíhjyúvatsóne. ");
INSERT INTO boaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aanéhjáa idyé mítyane mɨ́amúnaa Jetsóodívú píhcyáávémedi tsá ɨɨná íjcyatú ditye májchóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Áánélliihyéhjáa neebe ímamyémuke: —Mítyane ó ɨ́dáátsové íjtye mɨ́amúnaa tsúúca 3 coojɨ́vájuco mééma íjcyame imájchoma íjcyájúcóótúneri. ");
INSERT INTO boaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Muurá májchótúmeke ihjyáhañévú o wállóhajchíí juuvávyúré chéméiyómé ájyáháñeri. Muurá tsaatétsáhjɨ́ tsíhyullé múnaa. ");
INSERT INTO boaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ehdúhjáa dibye néénéllii ímamyémú néé dííbyeke: —Árónáa ¿kiátú meújcúnetu diityéké mémájchótsóiyá múubárá íjcyátútsihyi meíjcyame? ");
INSERT INTO boaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Áánélliihyéhjáa neebe diityéke: —¿Aca múhduná méhdi majcho? Áánélliihyéhjáa néémeé: —Ijcyáné 7-hova páahóóne. ");
INSERT INTO boaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Áánélliihyéhjáa neebe mɨ́amúnaa iáhcúbaki. Áánemáhjáa teene páahóóné iékéévéne téhdújtsoobe Píívyéébeke. Átsihdyúhjáa idyóhdáhɨ́nunévú ájcuube ímamyémuke ditye iwájtu diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Téhduréhjáa amómé ijcyá áyánéwu diityédi. Ááné hallúvúhjáa téhdure ityéhdújtsóne neebe ditye iwájtuki. ");
INSERT INTO boaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Áánetúhjáa pámeere óóvénetu coéváné 7-rujtsívá úvérujtsíñe wáhpe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Aanéhjáa diitye 4,000-meváubáhjáa íjcyámeke imájchótsóné boone diityéké ipítyájcoíñúne péjucóómé mɨ́ɨ́neri ímamyémuma Damanóótá iiñújɨvúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Áijyúhjáa idyé paritséómú péé Jetsóo éllevu dííbyema ityáhjájcatsíki. Aaméhjáa dííbyeke imújtátsóro néé íévéhoowávú méénúráítyuróné dibye imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aanéhjáa múhdurá dííbyeke pájtyénéllii neébe: —¿Ɨ́veekí ámuha méimíllé méénúráítyuróné o méénune? Tehdu oke ámuha menéénéllii o méénúíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ehdúhjáa diityéké iñééne tsiiñe ímamyémuma péjúcoobe únéú tsiñéjcuvu. ");
INSERT INTO boaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Téijyúhjáa ímamyémú ábájɨɨvé majcho itsájtyéiyóne. Áámedíhjyáa tsáhoore ípaaáho. ");
INSERT INTO boaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Áánáacáhjáa Jetsóó diityéké nééhií: —Téɨɨbúwá tsáma méíjcyaco. Méɨ́ɨ́cúvedí eene pááá ooríchó Heróódema paritséómu éhné íjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ehdúhjáa dibye néénéllii ímamyémú néjcatsíhi: —Majchóne metsívátúnélliihyéubá ehdu meke neébe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ehdúhjáa majchóré ditye ɨ́jtsúcunúné iwáájácúne neébe: —¿Aca muhdú ɨ́ɨ́vane majcho mééma íjcyatúné ámuha ménéjcatsíhi? Ihdyúubá ávyétá muhdúrá ámúhá ɨ́buúúné nééme íhyajchótá tsá ámuha mewáájacúpityú táuwáábo. ");
INSERT INTO boaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Áánerá ámúhá hálluúúnema ámúhá núhejúúnema ámuha meíjcyaróméubá tsá maátyúmɨhíjcyatú ɨ́nehjɨ́ o méénuhíjcyáne. ¿Ɨ́veekí tsá ámuha melléébohíjcyatú o úwaabóne? ¿Mityá tsá ámuha meɨ́tsaavéjúcootú majchóo muhdú o méénune? ");
INSERT INTO boaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Muuráhjáa 5-hováré páahóóné íjcyaróné ó úújetétsó 5,000-meva íjcyárómedívu. Áánetúu cóeváné ¿múhdúrujtsíva wáhpé éhne mépihjyúcúhi? Áánélliihyéhjáa néémeé: —12-rujtsíva wáhpée muurá mépihjyúcúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Áhduréhjáa neébe: —Ácooca éhnée 7-hova páahóóné íjcyaróné 4,000-mevádívú o úújetétsóijyu ¿múhdúrujtsívá tééne pájtyé mépihjyúcúhi? Áánélliihyéhjáa idyé néémeé: —Téhdunérée 7-rujtsíva wáhpé mépihjyúcúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ehdúhjáa diityéké iñétsihdyu neébe: —¿A ícyooca tsúúca ámuha méwaajácú ɨɨná nééiyóne pááá ooríchotu o íhjyuváne? ");
INSERT INTO boaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Átsihdyúhjáa úújetémé Betsáidávu. Áánáacáhjáa dííbye éllevu tsaate hállúvátúúbeke itsíváne néé dibye iímíbájcho dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Áánélliihyéhjáa dííbyeke íhyójtsɨtu iékéévéne técoomítyú tsátsihvu itsájtyéébeke íhyálluúúcú iúúniyi pɨ́pájchoóbe. Áánemáhjáa idyócárájcóne dílloobe dííbyeke muhdújucó dibye ɨ́ɨ́tene. ");
INSERT INTO boaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Áánélliihyéhjáa neébe: —Muhdú ó ɨɨté mɨ́amúnaa úllécunúné úmehéénédu. ");
INSERT INTO boaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Áánélliihyéhjáa tsiiñe Jetsóó dííbyé hálluúúcú dócárájcónetu botsíi tsaímiyéjuco dibye ɨ́ɨ́tene. ");
INSERT INTO boaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Áábekéhjáa ihjyávú iwállóóne neebe técoomí múnáake dibye iúúbállétuki. ");
INSERT INTO boaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Áhduréhjáa tsáijyu Jetsóó ímamyémuma péé ‘Tsetsaréa Pirípo’ némeí cóómí úniúúcuri íjcyáme wáábyu. Áijyúhjáa juuvávyú diityéké dílloobe muubá dibye íjcyane dííbyedítyú mɨ́amúnaa néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Áánélliihyéhjáa néémeé: —Tsaate nehíjcyá tsojtsó múnáajpi Jóáa tsiiñe bóhɨɨbe u íjcyane. Áánetu tsijtye nehíjcyá éíjyuúvúu ícyahíjcyámé Píívyéébé ihjyú uubálle múnáadítyú Eríá tsiiñe bóhɨɨbe u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ehdúhjáa ditye néénéllii diityékeréjuco dibye díllone: —¿Ácooca ámuha muubá o íjcyane menééhií? Áánélliihyéhjáa Péédoro nééhií: —Muurá uu Críjto mɨ́amúnáake u pájtyetétsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ehdúhjáa Péédoro dííbyeke néénetu bóíjcyuube ditye muucá iúúbállétuki. ");
INSERT INTO boaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Téijyúhjáa ímamyémuke úúbálleebe Jetsóó Mɨ́amúnáájpidívúu ípívyééveebe muhdú ɨɨ́cúbáhrámeíiñe. Úúbálleebéhjáa muhdú túkevéjtsojtee, llúúvájté avyéjujtee, taúhbájú uwáábojtee, íjcyame dííbyeke iávyejúúllétúne dsɨ́jɨ́vétsoobe 3 coojɨ́vatu tsiiñe ibóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ehdúhjáa dibye néénéllii Péédoro dííbyeke íhdyúétsihvu idyówajcáróóbeke néé ehdu dibye iíhjyúvátuki. ");
INSERT INTO boaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Áánélliihyéhjáa dííbyedítyú iyévóóvéne tsijtye ímamyémuke ɨ́ɨ́teebéré dííbyeke uhbáhi. Neebéhjápeé: —¡Dɨ́hne óhdityu Náve Naavénej! Muurá tsá u wáájácutú muhdú óhdityu Píívyéébe ɨ́jtsámeíñe. Mɨ́amúnáá ɨ́jtsaméíyé dípañe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ehdúhjáa dííbyeke iñééné boonétú pámeere tétsihyi íjcyámeke neébe: —Tsaate oke iúraavyéné ímillémé múu iímillédú iícyahíjcyánetu ɨɨ́hveténe oke úraavyé wájyúmeítyúmé tééné déjúcotu ɨɨ́cúbáhrámeíyóné pañe. ");
INSERT INTO boaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Muurá iímillédúré ícyahíjcyámé tsá pájtyetéityúne. Áánetu ihdyu iímillédú iícyahíjcyáné ɨɨ́hvéjtsóne ookeréjuco úraavyémé pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Aca ɨ́ɨ́netú meke pɨ́áábóiyóné tsáijyu múu mewágóóóvénáa mítyane meéhneváne? ");
INSERT INTO boaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mityá ijcyáné tsane mepájtyetéíyóné ehnííñevu tsaímíyé meíjcyáiyóne? ");
INSERT INTO boaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Muurá oke iúraavyéné núcojpɨ́llémeke téhdure ó nucójpɨ́lleé Mɨ́amúnáájpidívúu o ípívyééveébe. Áhdure táuwááboju tsíjtyeke iúúballéiyóné núcojpɨ́llémeke téhdure ó núcojpɨ́lleé níjkyéjɨ múnáama tahñéjté ujcúvavu o tsáácoóca. ");
INSERT INTO boaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Téhduréhjáa tsiiñe neebe diityéke: Muurá ɨ́mɨááné ámúhadítyú tsáhái tsaate dsɨ́jɨ́véityú Píívyéébé avyéjú ɨhtsútú ájtyúmɨtúme. ");
INSERT INTO boaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Átsihdyúhjáa 6 coojɨ́vatu peebe cáméhbaúvú apáámyemáyé Péédoroo, Jacóóboo, Jóáaá, éhdúmema. Áámedívúhjáa tsíhdyúrééveébe. ");
INSERT INTO boaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Íwajyámúhjáa ávyeta tsɨ́tsɨ́j íjcyaja ajchúcunúhi. Tsáháubá múha téhdu ímí níjtyúítyuró wájyamu. ");
INSERT INTO boaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Áánáacáhjáa Eríama Moitséemútsí tétsihvu diityédívú bóhówáávémútsima Jetsóó ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ááneríhjyáa Péédoro iúllévenúne néé dííbyeke: —¡Ávyéjuúbej, maímijyu ihdyu mee íchihyij! Ahdícyane métsu méméénu 3-wava nújuwááné ámúhá ahpa dihñéwaa, Moitsée éhwaa, Ería éhwaa, éhdune. ");
INSERT INTO boaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ehdúhjáa iíllityéné pañe iñééne tsá Péédoro wáájácutúne. Áhduréhjáa íñahbéjtétsí íllityéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Áánáacáhjáa ojtso diityédívú níítyéné pañétú Píívyéébe nééhií: —Áánu Hájchíwu mítyane o wájyúúbeke tsáma méllééboco. ");
INSERT INTO boaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Áánélliihyéhjáa ɨ́ɨ́terómé ɨ́ɨ́néubárá íjcyatúne. Téhduréhjáa Moitséemútsí Eríama tsáhájuco íjcyatúne. Apáábyeréjucóhjáa Jetsóó tétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Átsihdyúhjáa ditye óómíñáa Jetsóó bóijcyú ditye muucá teene iúúbállétu Mɨ́amúnáajpidívúu ípívyééveebe ɨdsɨ́jɨ́vétsihdyu tsiiñe bóhɨ́ɨ́túné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ahdújucóhjáa tsá ditye muucá úúbálletú teéne. Aaméhjáa ihdyu tsamééré díllócatsíhijcyá muhdú dsɨ́jɨ́veebe tsiiñe bóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Átsihdyúhjáa nééme dííbyeke: —¿Ácooca muhdú ɨ́ɨ́vane taúhbájú uwáábojte nehíjcyá Eríá tsiiñe íjcyaíñé mɨ́amúnáake pájtyetétsóiibye bóhówáávéíñé ɨhdéwu? ");
INSERT INTO boaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Áánélliihyéhjáa neébe: —Éée, ɨ́mɨáánéjucóhdée tene némeíñé Eríá bóhówááveíñé mɨ́amúnáake pájtyetétsóííbyé úmɨ́wari dibye diityéké ɨɨ́hdénu dííbyema. ¿Muhdútá nééne óhdityu Mɨ́amúnáájpidívúu o ípívyéévéébedítyú Píívyéébé waajácúháámɨtuj? Muurá nééne mɨ́amúnaa oke iávyejúúllétúne óhdi ɨ́cúbáhraíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aanée muurá ɨ́mɨááné ijcyájúcóóroobe tsojtsó múnáajpi Jóáa eenée Eríá dibye íjcyane ditye néhíjcyaábe. Áróóbekée mɨ́amúnaa iéhdɨɨválléne íllure ɨ́cúbáhrahíjcyáhi. Áánemáa dibye néérone tsá ditye cáhcútsohíjcyatúne. Ehdúu Píívyéébé waajácúháámɨtu tene néhdújuco dííbyeke tene pájtyene. Ehdúhjáa neebe Jetsóó 3-meva ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aaméhjáa tsúúca ímunáajtémá tsijtye mítyame íjcyámedívú wajtsɨ́hi. Áánáacáhjáa taúhbájú uwáábojtémá diitye ímamyémú táhjácatsíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aaméhjáa dííbyeke iájtyúmɨ́ne ɨ́ɨ́cúi dííbye éllevu ipyééne dííbyeke duurúváhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Áámekéhjáa neébe: —¿Ɨ́ɨ́nerí ámuha métáhjácatsíhijcyá támamyémuma? ");
INSERT INTO boaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ehdúhjáa dibye neerónáa tsaapi néé diityéj pɨɨnétú dííbyeke: —Ávyéjuúbej, áánu hájchíwúú pañe naavéné íjcyaabe íhjyúvátúúbeke ó tsivá diéllevu óóma u ímíbájchoki. ");
INSERT INTO boaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Muhdú íhya dííbyeke dibye méénúcooca baavu áákityéébé ihjyútú uráhtsaba íjchívyécooca íhwáñe ɨɨ́hdóne cópenúhíjcyaábe. Áánéllii íñe íjtye dímamyémuke ó neerá dityévá óóma dííbyé pañétú iwáágóóroki. Árónáa tsá ditye píívyetétúne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Áánélliihyéhjáa Jetsóó néé ímamyémuke: —¡Juhúú, múhdúré mɨ́amúnaáami ámuuha Píívyéébeke cáhcujtsópityúme! Aane íñe ¿múhajchótá ámúhá muhdúré o áábúcúne ámúhakye ó úwáábohíjcyaá ámuha mecáhcújtsoki? Ehdúhjáa diityéké iñééróne neébe: —Áyu cána bo ííllevu metsívá dííbyekej. ");
INSERT INTO boaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ahdújucóhjáa dííbyéwúuke ditye tsájtyene dííbye éllevu. Áánáacáhjáa naavéné Jetsóoke iájtyúmɨ́ne dííbyeke ávyeta wáɨ́rohjácoobe áákityé baavújuco. Aabéhjáa baari cávíhyíñúmeííbyeke íhjyútu uráhtsaba ijchívyéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aanéhjáa Jetsóó néé cááníkyeé: —¿Aca múhajchótájuco íllu dibye íjcyane? Áánélliihyéhjáa neébe: —Tsɨ́ɨ́ménedítyúré ehdu diíbye. ");
INSERT INTO boaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tsáijyu muurá cúújúwá pañévú dibye ɨ́jcaáyoobe tsúúca dsɨ́jɨ́vehíjcyáiyáhi. Ááné tsaíjyú téhí pañévú dííbyeke wááohíjcyaábe. Aane cána ihdyu u píívyetéhajchíí múúhadi dɨ́dáátsóvéne múúhakye pɨááboj. ");
INSERT INTO boaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Áánélliihyéhjáa Jetsóó néé dííbyeke: —¿A o píívyetéhajchííjyu? Ú eene ihdyu ɨ́mɨááné oke u cáhcújtsóhajchíí tehdújuco uke o pɨ́ááboíñe. Tehdu ɨɨná óhdivu túhúúnejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Áánélliihyéhjáa neébe: —Uke muurá ó cáhcujtsóhi. Áánéllii oke pɨáábó éhnííñevu uke o cáhcújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aanéhjáa mítyane mɨ́amúnaa píhcyáávénáa Jetsóó naavéneke úhbaabe nééhií: —¡Nave Naavénej, eene muhdú áádíwúuke u dárɨ́ɨ́veebe íhjyúvátuube lléébótúúbé pañétú uke o néé u íjchívyeki! ¡Aabe dohmíjyúcohdí dííbyé pañévu! ");
INSERT INTO boaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Áánélliihyéhjáa naavéné wáníjcyámeííbyéré dííbyeke tsiiñe ávyétá ɨhnáhó iwáɨ́róhcóne ijchívyéhi. Ááné boonéhjáa coévaabe dsɨ́jɨ́veebédu. Aanéhjáa mítyame ɨjtsúcunú tsúúca dibye dsɨ́jɨvéjucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Árónáacáhjáa Jetsóó íhyójtsɨtu íjyócujcároobe tsaímiyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ááné boonéhjáa tsájaavu aahɨ́veebe ímamyémuma. Átsihvúhjáa tsamééré iíjcyátsihvu néé dííbyeke: —¿Aca ɨ́veekí muhdú nétsihdyu tsá muha mepíívyetétú meíjchívyetsóné naavéneke eene u íjchívyetsódu? ");
INSERT INTO boaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Áánélliihyéhjáa neébe: —Muurá ihdyu téeméjpiikye mewáágóo májchotúmé Píívyéébeke pɨáábó métáúmeíhi. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Átsihdyúhjáa pééme pajtyé Gariréá iiñújɨtu. Áijyúhjáa tsá Jetsóó ímílletú múha wáájacúné ditye tééneri pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Imílleebéhjáa apáámyekéréi ímamyémuke iúwaabóne. Téijyúhjáa úúbálleebe Mɨ́amúnáájpidívúu ípívyéévéébedívú tsaapi ímítyúmeke ékéévétsóóbeke ditye dsɨ́jɨ́vétsoobe 3 coojɨ́vatu tsiiñe ibóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ehdúhjáa dibye diityéké úúballéné tsá ditye wáájácutú muhdú nééiñe ehdu dibye nééneé. Aanéhjáa dííbyeke ímíñeúvú idíllóiyóné nuhnévehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Átsihdyúhjáa Capenaóovu pééme úújeté tsájaávu. Átsihvúhjáa Jetsóó diityéké nééhií: —¿Ɨ́ɨ́nerí éhne ámuha táhjájcatsímyéré métsahíjcyá juuváyi? ");
INSERT INTO boaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Árónáacáhjáa tsá ditye áñújcutú caabyé diityédítyú ɨ́ɨhtsútuube íjcyáíyóneríhjyáa ityáhjájcatsíñélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Áánélliihyéhjáa iácúúvéne neebe diityéke: —Ámúhadítyú ɨ́ɨhtsútuube iíjcyane ímílleebe óvíi tsíjtyeke ɨ́ɨ́cuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ehdúhjáa diityéké iñééne tsɨ́ɨ́ménéwúuke icyájaabúcúne neébe: —Éje, áánu muurá tsɨ́ɨ́mene ɨ́dátsóhreé. ");
INSERT INTO boaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ahdu muurá táuráávye múnaa ɨ́dátsó néémeke ɨ́ɨ́cúvehíjcyámé ookéjuco ɨ́ɨ́cuvéne. Aane tsá idyé ookére. Téhdure okée wállóóbekéjuco ditye ɨ́ɨ́cuvéne. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Áhduréhjáa tsáijyu Jóáa néé dííbyeke: —Ávyéjuúbej, tsáápiikye muha máájtyumɨ́ tsaaté pañe naavémú íjcyámeke dimyémeri wáágóohíjcyáábeke. Áábeke muha mébóíjcyuíñú tsíjpiiye íjcyaabe ɨ́veekí tehdu méénúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Árónáacáhjáa Jetsóó nééhií: —¿Ɨ́veekí ámuha mébóijcyúhi? Muurá eene tamyémeri méénúráítyúronéhjɨ́ méénuhíjcyáméubá tsá óhdityu ímityúné íhjyúváítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Muurá meke pɨ́aabómé tsá meke tútávájtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ahdícyane tsaate ámuha tahñéjté meíjcyámeke nújpácyo dɨ́ɨ́vanévú tamyémeri íjchome muurá tééne áhdó ɨ́ɨ́né imíjyaú íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Áánetu botsíi oke cáhcujtsómé ɨ́dátsó tsɨɨméwuúmúdúréi néémedítyú tsaatéké ímítyunévú ɨ́búwátsohíjcyámekéubá múu apáhajchíí íjkyééháñetu néwayúcobáné ióhbáñúmeke wájojcó móóá pañévú ditye ɨ́cúbáhrámeííyóné ɨhdétu. ");
INSERT INTO boaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ahdícyane ámúhá hojtsɨ́neri ímityúné ámuha meméénuhíjcyáhajchíí múu kípíyújcúmeí téhojtsɨ́jɨ. Muurá ímí ámuha méíjcyaá tsánejcúéhójtsɨma íjcyájúcóóturómé ámuha mepájtyetéhajchííjyu. Áánetu ɨ́dátsó ámuha méíjcyaá tsahójtsɨ́cuma ámuha meíjcyarómé múijyú áábatéítyúnéj cuujúwá pañévú mewágóóóvéhajchííjyu. Árónáa ihdyu tééwá pañe íjcyame tsá muhdú íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Téhdure ámúháj tuhááñeri ímítyúne éllevu ámuha mepéhíjcyáhajchíí múu kípíyújcúmeí téjtuhájɨ. Muurá ímí ámuha meíjcyaá tsajtúháácyuma íjcyájúcóóturómé ámuha mepájtyetéhajchííjyu. Áánetu ɨ́dátsó ámuha meíjcyaá tsajtúháácyuma ámuha meíjcyarómé múijyú áábatéítyúnéj cuujúwá pañévú mewágóóóvéhajchííjyu. Árónáa ihdyu tééwá pañe íjcyame tsá muhdú íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Áhdure idyé ámúhá hálluúúneri ámuha maájtyumɨ́né ímityúné meméénuhíjcyáhajchíí méwaagóoméí téuhjɨ. Muurá ímí ámuha méíjcyaá tsánejcúéuma íjcyájúcóóturómé Píívyéébé avyéjuri ámuha meíjcyáhajchííjyu. Áánetu ɨ́dátsó ámuha méíjcyaá tsaúúcuma ámuha meíjcyarómé múijyú áábatéítyúnéj cuujúwá pañévú mewágóóóvéhajchííjyu. Árónáa ihdyu tééwá pañe íjcyame tsá muhdú íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Muurá pámeere tééwá pañe íjcyámedi tééwaj cúvá búúúveéhi. Áánetu Píívyéébeke ɨ́ɨ́cúvehíjcyámeke ímíjpyetétsóiibye éhne múúne cánááma heeco ímíjpyetétsódu. ");
INSERT INTO boaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Muurá cánááma iíímúnéllii meke pɨ́aabóhi. Áánetu iíímútuca tsá ɨ́ɨ́netú tene pɨ́áábóítyuróne. Ahdu teene Píívyéébé uwááboju cánáámadu. Aane ihdyu óvíi ámúhá pañévú ámuha méujcú tsaímíyé ámuha menáhbévájcatsíki. Ehdúhjáa Jetsóó úwaabó ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aabéhjáa Jetsóó Capenaóotu péé diitye ímamyémuma Jodéá iiñújɨvu Joodáá tsiñéjcuvu. Áhullévúhjáa idyé mɨ́amúnaa dííbyedívú píhcyáávémeke imyéénuhíjcyádú úwááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Áijyúhjáa paritséómú dííbye éllevu itsááne dííbyeke imújtátsóro dilló tsáápílleke ihdícyáné hallútúré ájyu wáágoóné tehdújuco néhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Áánélliihyéhjáa neébe: —¿Muhdútáhjáa Moitséeúvú nehíjcyá téénetuj? ");
INSERT INTO boaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Áánélliihyéhjáa néémeé: —Muuráhjáa nehíjcyáábeúvú dííllekévá tééné waajácúhaamɨ́vú maájcúne meɨ́hvéjtsóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Áánélliihyéhjáa neébe: —Muuráhjáa ihdyu eene ámuha meíjcyadu ditye cáhcujtsópítyúnéllii ehdu nehíjcyaabe tehdu tene néétúrónáaca. ");
INSERT INTO boaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Muuráhjáa Píívyéébe páné ɨhdéene iípívyéjtsóné nɨ́jcaúvú téhdure ípívyejtsó wajpii, wallee, íjcyane muhdú tene íjcyaídyújuco. ");
INSERT INTO boaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Áánélliihyée muurá neebe wajpi ityáábávácooca ɨ́ɨ́neíñé cáánímútsidítyú dííllemáyéjuco iíjcya tsahéécoréjuco tsáápiiye íjcyáiyódu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aamútsí míítyétsi íjcyáromútsí tsahéécoréjuco íjcyaíñé Píívyéébée ípívyejtsódújuco. Áánéllii tsá tsaate ityáábávájcatsícyooca dówáávéítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ehdúhjáa iñééné boonétú tsájaavu ímamyémuma úújetéébeke tsiiñe dillómé teéne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Áánélliihyéhjáa neébe: —Muurá tsaapi méwakye ɨɨ́hvéjtsóne tsíjpíllekéréjuco ityáábáváhajchíí ímityúné meenú mewa ímíubááné íjcyánáa tsíjpíllemáyéjuco iíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Áhdure idyé walle ájyúke ɨɨ́hvéjtsóne tsíjpiikyéréjuco ityájɨ́váhajchíí ímityúné meenú ájyu ímíubááné íjcyánáa tsíjpiimáyéjuco iíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Téijyúhjáa tsaate ɨ́ɨ́tsɨ́ɨ́meke tsivá dííbye éllevu dibye diityé hallúvú pɨááboju Píívyéébeke ityáúmeíki. Árónáacáhjáa ímamyémú néé ɨ́ɨ́nevú ditye ɨ́ɨ́tsɨ́ɨ́meke tsívane. ");
INSERT INTO boaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ehdúhjáa ímamyémú nééne tsárí ɨɨ́jtsúcunúne neebe diityéke: —Óvi ihdyu tsiváme. ¿Ɨ́veekí ámuha mécátuhtsóhi? Muurá diitye tsɨɨme íjcyadu néémé wáábyuta Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aane ɨ́mɨáánetúré ámúhakye o néé éhne múúne teetsɨ tsɨ́ɨ́mene ímí meke cáhcujtsódú Píívyéébeke cáhcújtsotúmé tsá dííbyé avyéjúejte íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ehdúhjáa iñééne tsɨɨméké cájáábíñuubéré pɨáábó táúmeí diityé hallúvu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Átsihdyúhjáa dibye pééíyónáa tsaapi dííbye éllevu dsɨɨnéríyé itsááne dííbyé lliiñévú ɨmɨ́móúúvéne néé dííbyeke: —Uwááboóbej, ɨ́mɨáábé u íjcyaabe cána oke diñe muhdú ó íjcyáiyóné múijyú o dsɨ́jɨvéjúcóóítyúne bóhɨ́ o újcuki. ");
INSERT INTO boaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Áánélliihyéhjáa neébe: —¿Aca ɨ́veekí ɨ́mɨáábedi oke ú dillóhi? Muurá ihdyu apáábyéré Píívyéébe ɨ́mɨáábe. ");
INSERT INTO boaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aane muurá tsúúca ú waajácú dííbyé taúhbajúúné íllu nééneé: Tsá múu ihdícyámema dómácójcatsítyúne. Tsá múu mɨ́amúnáake dsɨ́jɨ́vétsotúne. Tsá múu nánívatúne. Tsá múu állíuutúne. Múu avyéjuullé díícyáánimútsikye. ");
INSERT INTO boaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ehdúhjáa Jetsóó néénéllii neébe: —Uwááboóbej, tehdújuco muurá ihdyu o ícyahíjcyáné táayáábedítyúre. ");
INSERT INTO boaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ehdúhjáa dibye nééne Jetsóó ímí ɨɨ́jtsúcunúne néé dííbyeke: —Árónáa ijcyánéi tsane. Dítsíeméné náhjɨ́hénúne pɨáábó ɨ́dáátsóméhjɨke. Áijyu ihdyu ú ávyéjúúteé níjkyéjɨri íjcyaabe Píívyéébé avyéjuvu. Aane cáhawáá ehdu méénúne ookéréjuco duráávyej. ");
INSERT INTO boaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ehdúhjáa Jetsóó nééne kimóhcó pajtyé dííbyeke mítyane dibye éhnévánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aabéhjáa kímóóveebéré pééneri Jetsóó iúllévenúne néé ímamyémuke: —Muurá mítyane éhnevámé ɨ́htsútúnetu Píívyéébé avyéjuvu úcáávéiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ehdúhjáa dibye nééneri ímamyémú úllévenúnéllii tsiiñe neébe: —Ámuúha Llihíúmuj, ɨhnáhóóné ɨ́mɨááné ehnéva múnaa Píívyéébé avyéjuvu úcáávéiyóné ditye tééneríyé tsúúrámeíhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Aca muhdú caméélló ánéétóhéjutu pajtyéiyáhi? Áhdure ¿aca muhdú diitye ehnéva múnaa Píívyéébé avyéjuvu úcáávéiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ehdúhjáa dibye nééneri iúllévenúne tsamééré néjcatsíhi: —¿Aca ihdyu múhdutúrá pájtyetéiyóme? ");
INSERT INTO boaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Áánélliihyéhjáa neébe: —Ɨ́mɨáánéjucóhde mɨ́amúnaa tsá píívyetétú iiye ipájtyetétsámeíñe. Árónáa Píívyéébe piivyété diityéké ipájtyetétsóné ɨɨná dííbyedívú túhúútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Áánélliihyéhjáa Péédoro néé dííbyeke: —Ávyéjuúbej, muuráhjáa páneere muha meɨ́hvéjtsóne uukéréjuco meúraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Áánélliihyéhjáa neébe: —Tehdújuco. Muurá ɨ́mɨáánetúré ámúhakye o néé tsaate íijcyátsɨ́hjɨɨ, íñahbémuu, íñaallémuu, cáánímutsii, méwamyuu, ɨ́ɨ́tsɨɨ́mee, íjcyámeke tsánejcúvú ɨɨ́hvéjtsóne Píívyéébé wákiméí méénume ɨ́ɨ́né imíjyaú íjcyaíñé íñé iiñújɨri. Aame muurá ájtyúmɨɨ́ tsíjtyeke diityémá iñáhbéváímyeke íñahbémúdú íñaallémúdú cáánímutsídyú ɨ́ɨ́tsɨɨmédú nééme téhdure ookéréjuco úráávyémeke. Aame tééné déjúcotu ɨ́cúbáhrámeíhíjcyaáhi. Árónáa ihdyu nihñévúré újcuímyé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ tsɨ́ɨ́jɨréjuco ííñujɨ Píívyéébe ípívyéjtsójɨ́ hallúrí iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Muurá íñe ícyooca ɨ́htsutúmé íjcyame ɨ́dátsó téijyu waagóojte íjcyaáhi. Ááné lliiñévú íñe ícyooca ɨ́daatsómé ávyéjúúteéhi. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aaméhjáa Jerotsaréevu pééme dííbye déjuri pehíjcyá íllityécunúmére. Áámekéhjáa tsátsihvu imíjyojcáróne tsiiñe úúbálleebe muhdú técoomívú dííbyeke tene pájtyeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Neebéhjáa diityéke: —Mepéé íñe Jerotsaréevu. Ácoomívú muurá Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi llúúvájté avyéjujtémá taúhbájú uwáábojtéké óhdivu ékéévétsoóhi. Aame oke iékéévéébeke jodíómú íjcyátúmé hójtsɨ́ pañévú ɨ́hvéjtsoó oke ditye ɨdsɨ́jɨ́vétsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aame óhdi iúúhɨ́vaténe oke úníchíhcyuméré iwápáájcóóbeke dsɨ́jɨ́vétsoóhi. Ároobe tsiiñe ó bóhɨɨ́ 3 coojɨ́vatu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Áábekéhjáa tsáijyu Tsebedéó hájchimútsí Jacóóboma Jóáámutsi nééhií: —Uwááboóbej, muhtsi méimíllé tsane uke metáúmeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Áánélliihyéhjáa neébe: —¿Ɨɨná ámuhtsi méimílléhi? ");
INSERT INTO boaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Áánélliihyéhjáa neemútsi: —Muhtsi méimíllé u ávyéjuutécooca díúniúvú múhtsikye u ácujcáróné úúma muhtsi maávyéjuutéki. ");
INSERT INTO boaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Áánélliihyéhjáa neébe: —Ávyeta tsá ámuhtsi mewáájácutú ɨɨná metáúmeíñe. ¿Aca ámuhtsi méɨ́cúbáhrámeíiyá muhdú o ɨ́cúbáhrámeídyu? ");
INSERT INTO boaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Áánélliihyéhjáa neemútsi: —Éée, muhtsi méɨ́cúbáhrámeíiyáhi. Áánélliihyéhjáa neébe: —Ɨ́mɨáánéhde ámuhtsi méɨ́cúbáhráméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Árónáa tsá ámúhtsikye táúniúvú oore o pícyóóítyuróne. Muurá ihdyu Llihíyóré táúniúvú pícyoó caatyéké iwábyújtsómeke. Éhduréhjáa áñújcuube Jetsóó diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aanéhjáa íñahbéjté 10-meva íjcyame illéébóne cayóbáávaté diityétsidívu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Árónáacáhjáa Jetsóó diityéké nééhií: Ámuha muurá méwaajácú ííñújɨri íjcyáné avyéjujte ɨ́hnáhó ityáúhbájcatsíñe táhjácatsíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Áánetu ihdyu ámuha tahñéjté meíjcyame tsá múu tehdu néétune. Ámúhadítyú ɨ́htsútuube iíjcyane ímílleebe múu pamévakéré pɨ́aabóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Muuráhjáa íñe Mɨ́amúnáájpidívú o ípívyéveebe tsá o tsáátu ɨ́htsútuube ávyéjuube o íjcyáábeke mɨ́amúnaa oke ɨɨ́ɨ́cúveki. Ópée o tsáá diityéké o pɨ́aabóné diityé wájyuri o dsɨ́jɨ́ve múhdumé teene cáhcujtsómé ipájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aabéhjáa Jericóori iíjcyátsihdyu diitye ímamyémuma tsiéllevúréjuco péémema mítyame pééhií. Áánáacáhjáa ditye pééjú úníuri Timéó hajchi Batiméó hállúvátuube ácuúcunúúbé táúmeíhijcyá pɨáábo. ");
INSERT INTO boaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aabéhjáa tétsihvu diibye Natsarée múnáajpi Jetsóó pɨ́ɨ́hɨne iwáájácúne kéévánécoba nééhií: —¡Jetsóó Dabíiúvúj tsɨɨménémúhaabe u íjcyaabe óvíjyuco ihdyu óhdi dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ehdúhjáa dibye néénéllii tsaate néé cúúvéhulléré dibye iíjcyaki. Árónáacáhjáa éhnííñevúré tsiiñe neébe: —¡Dabíiúvúj tsɨɨménémúhaabe u íjcyaabe óvíjyuco ihdyu óhdi dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Áánélliihyéhjáa Jetsóó tétsihvu iíjyócúúvéne nééhií: —Méne dibye itsáá taéllevu. Ahdújucóhjáa dííbyeke ditye nééneé: —Uke pɨ́úvaábe. Wa dichaj. ");
INSERT INTO boaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ahdújucóhjáa ɨ́ɨ́cúi íwajyámú hállúeja ityácórɨ́ɨ́véne dibye cátsíñiivyéné dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Áábekéhjáa neébe: ¿Ɨɨná ú imílléhi? Áánélliihyéhjáa neébe: —Ávyéjuúbej, ó imíllé o hálluváne. ");
INSERT INTO boaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Tehdújuco. Oke u cáhcujtsódú íjcyaabe tsúúca ú hallúváhi. Ahdícyane wa ílluréjuco dipyej. Ehdúhjáa Jetsóó dííbyeke néénemáyé ɨɨtéjúcoóbe. Aabéhjáa dííbyemájuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aaméhjáa úújeté Jerotsarééj pɨɨhɨ́rí Bepajéema Betáániá coomícyú úníuri oríívo bájú íjcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Átsihdyúhjáa Jetsóó míítyétsikye ímamyémudítyú ɨ́pɨɨhɨ́ré coomívú iwállóómútsikye nééhií: —Écoomi ɨ́pɨɨhɨ́ré cóómityu óóma méujcúté íayáne ɨ́ɨ́júwuúke. Múikyé dííbyedi úllétuube dóhjɨ́váábeke metsíñaáyóne métsívaco. ");
INSERT INTO boaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aane tsaate ámúhtsikye ‘ɨ́véébeké ámuhtsi métsíñaáyó’ néhajchíí méneéco: “Ávyéjuubéne néénéllii muhtsi méujcúváhi. Ɨ́ɨ́cúiyévané ihdyu óómíchóiíbye.” ");
INSERT INTO boaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ahdújucóhjáa péémutsi úújeténé dííbyedívú juuvá úníutu tsaaté já llahájtsɨ́ mɨ́jcó lleehówá úmɨ́watu dóhjɨ́váábedívu. ");
INSERT INTO boaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Áábekéhjáa dityétsí tsíñaáyórónáa tsaate néjucóó: —¿Aca ɨ́véébeké ámuhtsi métsíñaáyó kiávú metsájtyeki? ");
INSERT INTO boaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Áánélliihyéhjáa neemútsí dibyée úwaabódu. Áánélliihyéhjáa ɨ́hvejtsómé dityétsí itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Áábekéhjáa dityétsí úújetétsóóbé hallu wájyamúúnevu ditye ɨ́hbóné hallúvú Jetsóó iñéríívyéne pééhií. ");
INSERT INTO boaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Áábé úmɨwáhjáa mítyame mɨ́amúnaa juuva ɨhbó wájyamúúnema wájyuhóónevu. ");
INSERT INTO boaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aaméhjáa dííbyema pééme tsuullérii, idyéjurii, íjcyame wáñécohíjcyá: —¡Ñóóooj, maímijyu áánu Píívyéébe mémeri tsááneéj! ");
INSERT INTO boaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ñóóooj, máávyejújtsó áánúke Dabíiúvúj tsɨɨménémúhaabe ɨ́mɨá ávyéjuube íjcyáábeke! ¡Maímijyu Píívyéébe mééma íjcyanej! Ehdúhjáa iwáñéjcóne nehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aanéhjáa Jetsóó Jerotsaréevu úcááveebe duurúvajávú iááhɨ́véne tééjá pañe panéváré ɨɨ́ɨ́téiñúne péjucóó Betáániávú cúvéhréjuco tene néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ááné tsiíjyúhjáa Betáániátú ditye óómíñáa Jetsóó ajyábáávatéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aabéhjáa tsíhyullétúré ájtyumɨ́ higyéérahe juuvá úníutu íjcyahe imíwu háámɨ́vahe. Ááhe éllevúhjáa míjyóóveebe ‘néévahéubáhaja’ iñéénema. Árónáacáhjáa tsá téijyu tehe néévatú iñééváíyó rááhori iíjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ááné hallútúhjáa ílluréjuco dibye teehe pítyúútsoobe nééneé: —Óvíárohe tsáma tsiiñe u néévahíjcyádú ú neevá níhñécunu ílluréjuco u chéméihye. Ehdúhjáa dibye nééne ímamyémú lleebóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Átsihdyúhjáa úújetémé Jerotsaréevu. Áijyúhjáa Jetsóó duurúvájá pañétú boáyó tééjá pañévú náhjɨ́hénújcatsímyeke. Dsɨ́ɨ́dsɨkéhjáa cápáyócohíjcyámé metsáwááné wájójcoóbe. Áhduréhjáa ɨ́júúmuke náhjɨ́hénuhíjcyámé acúvewááné wájójcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Áánemáhjáa neebe múha tééjá pañévú iñáhjɨ́henújúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Átsihdyúhjáa neebe diityéke: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Íjya tahjya tééjá lliiñévú mɨ́amúnaa óóma íhjyúvahíjcyáijya.” Aaja ¿ɨ́veekí ámuha naní múnáá jaríyéjuco medíllone? ");
INSERT INTO boaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ehdúhjáa Jetsóó méénúné uubállé llúúvájté avyéjujtémá taúhbájú uwáábójte iwáájácúne imíllerá dííbyeke ɨdsɨ́jɨ́vetsóne. Árónáacáhjáa nuhnévémé mɨ́amúnáadi ditye ímí dííbyé uwáábó ɨ́jtsúcunúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ááné iijyúnuvúhjáa tépejcójuco Jetsóó pééne técoomítyú ímamyémuma tsiéllevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aaméhjáa tsíijyu cúúvénetúré dibyée pítyúútsohe higyéérahe íjcyátsihdyu pájtyénáa ímamyémú ájtyumɨ́ tehe tsucájaaháñé tébajkyéjɨmájuco chémene. ");
INSERT INTO boaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Átsihvúhjáa Péédoro ɨ́tsaavé tétsihdyúu ditye pájtyénáa Jetsóó teehe úhbane. Áánemáhjáa neébe: —Éje Uwááboóbej, éhnée u pítyúútsohéha íhye tsúúca cheméhi. ");
INSERT INTO boaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Áánélliihyéhjáa neebe dííbyeke: —Ehdu ámuha meméénuhíjcya ímíñeúvú mécahcújtsó Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Muurá ámúhadítyú tsaate ɨ́mɨááné ímí cáhcujtsómé éhbau cámehbáú nééiyá téhbau ɨɨ́ɨ́ne móóáj pɨɨnévu. Ahdújuco muurá téhbau ɨ́ɨ́néiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ahdícyane muurá páneere Píívyéébeke ámuha metáúmeíñé pɨáábojúvú ámúhakye ájcúiibye ɨ́mɨááné ámuha mecáhcújtsóhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Árónáa ihdyu múu tujkénú ímíbáchójcatsí tsaatémá ímítyú ámuha medárɨ́ɨ́vécatsíhajchííjyu. Áijyu ihdyu ámúháj Caani níjkyéjɨri íjcyaabe ámúhadi ɨɨ́dáátsóvéne ílluréjuco ábájɨ́ɨ́veíñé ámuha ímityúné meméénune. ");
INSERT INTO boaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Áánetu ímityúné ámúhakye méénúmedi ámuha meɨ́dáátsóvétúhajchíí téhdure tsá dibye ámúhadi ɨ́dáátsóvéityúne. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aaméhjáa Jerotsaréeri íjcyánáa duurúvájá pañe íjcyáábedívú llúúvájté avyéjujtee, taúhbájú uwáábojtee, túkevéjtsojtee, íjcyame píhcyaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aaméhjáa néé dííbyeke: —¿Aca múúbé ɨhtsúturí u íjcyaabe eene ehdu nénehjɨ ú méénuhíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Áánélliihyéhjáa neebe diityéke: —Áhdure ¿acáa múha nééjuri Jóáa tsótsohíjcyá cáhcújtsómeke? ¿A Píívyéébeé, mityá mɨ́amúnaárée nééjuri tééné wákimyéí méénuhíjcyaábe? Áyu cána oke máañújcuj. Ámuha oke mááñújcúhajchíí botsíi ámúhakye ó neé múúbé ɨhtsúturí o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Áánélliihyéhjáa tsamééré néjcatsíhi: —Muurá ‘Píívyéébée nééjuri tsótsohíjcyaábe’ menéhajchíí meke nééíyoóbe: “Áábekéráhjáa ¿ɨ́veekí tsá ámuha mecáhcújtsotúne?” ");
INSERT INTO boaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Áánetu ‘mɨ́amúnaárée nééjuri’ menéhajchíí meke mɨ́amúnaa tééné hallútú méénúiyáhi. Muurá paméváré cáhcujtsó ɨ́mɨáánéjucóo Píívyéébé ihjyú uubálle múnáajpi Jóáa íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ehdúhjáa nééneri iñúhnévéne néémeé: —Maáhuúj, tsá muha mewáájácutúne. Áánélliihyéhjáa Jetsóó nééhií: —Aanéjɨ́ɨ́va idyé ámúhakye ó neé múúbé ɨhtsúturí o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Áijyúhjáa Jetsóó tsíeménéhjɨ́tu úwááboobe nééhií: —Tsaapíhjyáa íúmɨhe tsanééré óóva ibájtsone mɨjcónúhi. Áánemáhjáa tsátsii ímíbájchoobe tééne néévá dótsúhcúmeíitsíi. Áhduréhjáa tépallíj pɨɨnévú méénuube jáhwu cáámé cóhnaúvú tééjá pañétú tépalli téhmémeíijya. Ehdúhjáa imyéénúne tsaatéké tépallívú ityéhmétsoíñúne aahɨ́vetéébé tsííñé iiñújɨ. ");
INSERT INTO boaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aanéhjáa tsúúca tépalli néévane iwáájácútsihvu wálloobe íúníu múnáájpiikye dííbyema ditye iwállóóro dííbye éhné íjcyadúne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ahdújucóhjáa pééróóbeke ditye íllure méénúpéjtsónetu dibye óómiñe íéveébe. ");
INSERT INTO boaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Áánélliihyéhjáa tsíjpiikyéréjuco dibye wállóróóbeke téhdure néwayúúneri íhñíwáutu ityúúvátsóóbedi íllure uuhɨ́vatéme. ");
INSERT INTO boaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Áróné pañéhjáa tsíjpiikye dibye wállóóbeke ílluréjuco ditye dsɨ́jɨ́vétsópejtsóne. Árónáacáhjáa tsiiñe wálloobe pívámevákéjuco. Áámekéhjáa idyé imyéénúpéjtsóne tsaatéké dsɨ́jɨ́vetsóme. ");
INSERT INTO boaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ááné boonéhjáa ílli apáábyeréjuco cóeváné mítyane dibye wájyuúbe. Áábekéréjucóhjáa dibye wálloone ‘íhya hájchíwu íjcyánéllii dííbyeke avyéjúúlléiyóme’ iñéénema. ");
INSERT INTO boaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Aabéhjáa bóhdɨtéébeke iájtyúmɨ́ne néjcatsímye: “Aabye muurá íllíyéjuco íñe cááníñúiyóne. Áánéllii metsu dííbyeke medsɨ́jɨ́vétso mehnéréjuco tene iíjcyaki.” ");
INSERT INTO boaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ehdúhjáa iñéjcatsíñe ɨdsɨ́jɨ́vétsóóbeke waagóómé ííhyóvé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ehdúhjáa Jetsóó diityéké iúúbállétsihdyu nééhií: —¿Aane íñe diibye úmɨhé aabájaabe itsáácooca muhdú méénuú eenée tépallívú dibye téhmétsoíñúmé ímítyú dárɨ́ɨ́vémeímyeke? Muurá diityéké dsɨ́jɨ́vétsóiibye tééné hallútu. Ááne tsíjtyekéréjuco dibye téhmétsoíñé tépallívu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","¿A tsá ámuha múijyú meéévetú Píívyéébé waajácúháámɨ? Muurá téhaamɨ́tú nééneé: Tsaúu nééwayu jááháñé wákimyéi múnaa iñéhnílléne wáágóórou pícyámeí ímichi tééutu jaa éjkéiu. Muurá ihdyu Píívyéébere ehdu meenú tehdújuco. ");
INSERT INTO boaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ehdújáa diitye llúúvájté avyéjujtee, taúhbájú uwáábojtee, túkevéjtsojtee, íjcyámeke Jetsóó llébóóbóné hallútú imíllerómé dííbyeke tétsihdyu iwáágoóne. Árónáacáhjáa nuhnévémé Píívyéébé ihjyú uubálle múnáajpi dibye íjcyane mɨ́amúnaa néhíjcyámedi iíllityénema. Aaméhjáa ílluréjuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ááné boonétúhjáa paritséómú wallójcatsí Heróódé icyánéjcúejtémá dííbye éllevu ditye iñééte muhdú dííbyedítyú ipítyácócatsíhijcyáne. Ehdúhjáa ɨ́jtsámeímyé dibye muhdú áñújcúnetu dííbyedívú iñéétsóroki. ");
INSERT INTO boaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aaméhjáa neeté dííbyeke: —Uwááboóbej, muha muurá méwaajácú ɨ́mɨáábé u íjcyane állíútuúbe. Aabe ú úwáábohíjcyá kéjɨjtó Píívyéébe mɨ́amúnáadívú ímí ɨ́jtsúcunújɨ́jtó tsijtye múhdurá úhdivu ɨ́jtsúcunúróneri ɨ́ɨ́cúvétuubére. Árómeke muurá pámeekéré tsahdúré ú ɨjtsúcunú muhdú ditye íjcyane u túhúúllétúnélliíhye. Aabe cána múúhakye diñe díicyánéjcutuj. ¿A tehdújuco ávyéjuube romáánómuube íjcyáábé wáábyuta dsɨ́ɨ́dsɨke ditye áhdótsohíjcyáné maáhdóiyóne, mityá tsáhaáj? ");
INSERT INTO boaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ehdúhjáa dííbyeke dillómé íllure imújtátsóroki. Aanéhjáa iwáájácúne neebe diityéke: —¿Ɨ́veekí íllure oke ámuha memújtátsóro mémávárijchóhi? Áyu cána oke méuujétsó dsɨ́ɨ́dsɨjɨ́vuj. ");
INSERT INTO boaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ahdújucóhjáa ditye tsájɨ́hcobávú ájcune dííbyeke. Áájɨtúhjáa húmɨ náávee, memee, íjcyane ɨɨ́ɨ́téne neebe diityéke: —¿Aca múhúmɨ náávé íñeé? Áhdure ¿mumémé íñe tééjɨtu? Áánélliihyéhjáa néémeé: —Ávyéjuube Tséétsá húmɨ nááve. Áábe méméré eene tééjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Áánélliihyéhjáa neebe diityéke: —Ané wa ihdyu diibye Tséétsáke mááhdohíjcyá dííbye éhnéjuco íjcyanévu. Áánetu ihdyu Píívyéébeke máácuhíjcyá dííbyé wáábyuta íjcyanévu. Ehdúhjáa Jetsóó diityéké nééneri íllure ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Téijyúréhjáa idyé tsadotséómú péé dííbye éllevu medsɨ́jɨvémé tsiiñe mebóhɨɨne cáhcújtsotúme. ");
INSERT INTO boaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Aaméhjáa néé dííbyeke: —Ávyéjuúbej, Moitséeúvúhjáa muurá néé tsaapi méwadívú tsɨ́ɨ́mávátuube dsɨ́jɨ́véhajchíí íñahbéréjuco díílleke táábávaíñé dííbyeréjuco ɨtsɨ́ɨ́máva díílledívú íñáhbeúvúu tsɨ́ɨ́máváiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aanée ijcyámé 7-meva tsané nahbému. Áámé amíaabée ityáábávárólléjtane dsɨ́jɨvé tsɨ́ɨ́mávátuubére. ");
INSERT INTO boaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ááné boonée bóneebe díílleke táábávároobe idyé dsɨ́jɨvé díílledívú téhdure tsɨ́ɨ́mávátuubére. Áábé bonéébekée idyé téhdure pajtyéne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ehdúu pámeere tsané nahbémú 7-meva íjcyame díílleke ityáábáválledívú tsɨ́ɨ́mávatúmé dsɨ́jɨ́vehíjcyáhi. Aanée nihñévúré díílleréjuco dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aane cána múúhakye diñe ímichi ¿cáábyé taaba dille íjcyaíñé tsiiñe ditye bóhɨ́ɨ́coóca? ");
INSERT INTO boaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ehdúhjáa ditye néénéllii Jetsóó nééhií: —Íllure ámuha mémujtá Píívyéébe ɨ́htsútuube íjcyáábé waajácúháámɨtu muhdú tene úwaabóné ámuha mewáájácútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Muurá dsɨ́jɨvémé tsiiñe bóhɨ́ɨ́cooca páneere tsíhdyuréjuco cápáyóóveíñe. Tsáhájuco téijyu mɨ́amúnaa táábávácatsíhijcyáné íjcyáityúne. Muurá téijyu pámeere íjcyaá níjkyéjɨ múnaáduréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Aca tsá múijyú ámuha meéévetú Píívyéébé waajácuháámɨ? Íllúu muurá Píívyéébe Moitséeke néé úméhéwu péétécunúné pañétú dííbyema iíhjyúvácoóca: “Aavaráaa, Itsáaa, Jacóóboo, íjcyámé Piivyéébé ó ijcyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ehdúu Píívyéébe néénetu muurá méwaajácú ditye íjcyane. Muurá ditye íjcyátuca tsá dibye nééítyuró diityé Piivyéébé iíjcyane. Aanéjɨ́ɨ́va íllure ámuha mémujtáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ehdúhjáa Jetsóó tsadotséómuma táhjájcatsíñé tsaapi taúhbájú uwááboobe lleebúcunúhi. Aabéhjáa ímí diityéké Jetsóó áñúcuhíjcyánéllii néé dííbyeke: —¿Aca teene Píívyéébé taúhbajúúnetu keená ímichi páñétúene? ");
INSERT INTO boaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Áánélliihyéhjáa neébe: —Ímichi muurá páñétúene taúhbajúúnetu nééhií: “Ámuúha ijraéémuj, muurá Máavyéjuube Mépiivyéébé apáábyéré ɨ́htsútuube ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Áánéllii múu dííbyeke Dípiivyéébé Díavyéjuube íjcyáábeke wajyú ávyeta dɨ́ɨ́ɨ́búutúré páneere muhdú u íjcyáneri dɨ́ɨ́jtsaméiyi.” Ehdu nééne ímichi páñétúene teene taúhbajúúnetu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Áánetu tsiiñe nééhií: “Pamévakéré múu wajyú muhdú u wájyúmeídyu.” Íñeecu muurá ímichi páñétúenéécú taúhbajúúnetu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ehdúhjáa Jetsóó néénéllii diibye taúhbájú uwááboobe néé dííbyeke: —Ávyéjuúbej, tehdújuco u nééne ɨ́mɨááné tsáápiiye Píívyéébe íjcyane apáábyéré ɨ́htsútuube íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Áábeke ɨ́mɨááné méwájyúiyá ávyeta méɨ́ɨ́búutúre páneere muhdú meíjcyáneri méɨ́jtsaméiyi. Áhdure tsíjtyeke méwájyúiyá muhdú mewájyúmeídyu. Ehdu muurá meíjcyane ímí ɨjtsúcunúúbé íñe dííbyeke meɨ́ɨ́cuvéné panéváré dííbyé úmɨwávú mecóvátsohíjcyáné ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ehdúhjáa dibye tsaímíyé áñújcúnéllii Jetsóó néé dííbyeke: —Tsúúca muurá Píívyéébé avyéjúejpíjyúcooíyó uú. Ehdúhjáa dííbyeke Jetsóó nééné boone tsáhájuco múha dííbyeke tsiiñe díllotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Téijyúhjáa duurúvájá pañe íjcyámeke úwááboobe íhdityúré nééhií: —¿Aca ɨ́veekí taúhbájú uwáábojte nehíjcyá Dabíiúvúj tsɨɨménémúhaabe Críjto íjcyaíñe? ");
INSERT INTO boaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ááneráhjáa Píívyéébé Apííchóré dííbyeúvuke túkévéjtsóneri neébe: Ávyéjuube néé Táavyéjúúbeke: “Cána táúniúvúi diicya dímunáake o táhjáné hajchóta.” ");
INSERT INTO boaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ehdúhjáa muurá neebe Dabíiúvú Críjtodítyú Íavyéjuube dibye íjcyane. Aanéjɨ́ɨ́ ¿muhdú ɨ́ɨ́vane Dabíiúvúj tsɨɨménémúhaabe íjcyáíyoobe Críjtoó? Ehdúhjáa Jetsóó úwaabóné ímí diityéké pájtyénéllii lleebúcunúme. ");
INSERT INTO boaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Téhduréhjáa tsiiñe úwááboobe nééhií: —Ámuúhaj, téɨɨbúwá tsáma méíjcyaco. Tsá múu ɨ́ɨ́vatú eene aatye taúhbájú uwáábojte mɨ́amúnaa diityéké iávyejúúllekíyé cááméjácobájɨ́ úcámeíhíjcyánetu. ");
INSERT INTO boaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Muurá pihcyáávejááné pañévú iúcáávécooca imíllémé íboohówátsɨhjɨ́vúré iácuuvéne. Áhdure teene pihcyááveháñe májchó májchómeícyooca imíllémé ímítsɨhjɨ́vúré imájchone. ");
INSERT INTO boaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aame pííbájyujte walléémudítyú dótuhíjcyá diityé jaaháñe. Ehdu muurá imyéénúné nucójpɨ́ cááménécóbaúvú ihjyúvahíjcyarómé Píívyéébema. Árome muurá tééné déjúcotu ɨ́cúbáhráméiíhi. Ehdúhjáa Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Téijyúhjáa duurúvájá pañe Píívyéébé wáábyuta dsɨ́ɨ́dsɨke ditye pícyohíjcyábá úníuri dibye ácuúcunúnáa téhbá pañévú picyóómé teene dsɨɨ́dsɨ. Dsɨ́ɨ́dsɨváméhjáa mítyanéhjɨ́ picyóóhií. ");
INSERT INTO boaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Áánáacáhjáa pííbájyulle ɨ́dátsó picyóó mɨ́jɨ́hwuúcúre. ");
INSERT INTO boaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aanéhjáa ɨɨ́ɨ́téne ímamyémuke neébe: —Áámye muurá pííbájyulle ɨ́dátsó néérolle picyóó pámé ehnííñevúre. ");
INSERT INTO boaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Muurá aatye picyóó mítyane ɨdsɨ́ɨ́dsɨ́vánetu áyánéwuújɨ. Áánetu pícyoolle páneere tééne tájpí iíjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Aaméhjáa duurúvájá pañétú íjchívyénáa Jetsóoke ímamyémudítyú tsaapi nééhií: —Uwááboóbej, aca ɨ́ɨ́né imíjyaú eene duurúvaja néwayúúnetu méénúmeíhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Áánélliihyéhjáa neébe: —¿A imíwu ú ɨɨtéhi? Ároja muurá wácávyáhcáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Átsihdyúhjáa pééme tééjáj pɨɨhɨ́rí oríívo bájú íjcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Átsihvúhjáa Jetsóó ácuúcunúúbeke Péédoroo, Jacóóboo, Jóáaá, Aderéee, íjcyame nééhií: —Cána múúhakye duubállé múijyú tene pájtyeíñé eene múúhakye u néhíjcyanéhjɨ. ¿Aca ɨ́ɨ́netú muha méwaajácuú tsúúca tehdu tene pájtyeíñe? ");
INSERT INTO boaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Áánélliihyéhjáa neebe diityéke: —Ehdu nééme tsáma wajácútsi méíjcyaco ámuha állíu múnáadívú maállítsámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muurá o tsááiñe tsúúca pɨ́ɨ́hɨ́cooca íjcyaímyé mítyame óhdi díllómeímye. Aame neé diibyéjuco Críjto iíjcyane. Aane mítyame cáhcújtsoó bañúháñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Áhdure téijyu íjcyaíñé méénujcátsí pahúlleváre. Ááneri méíllityédíñe. Ehdu pajtyéiñe páneere ílluréjuco nɨ́jkéváíñé ɨhde. ");
INSERT INTO boaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Muurá tsáné iiñújɨ múnaa méénújcátsií tsííñé iiñújɨ múnáama. Áijyu ííñujɨ vááúméií pahúlleváre. Áhdure ájyaba íjcyaáhi. Ehdu déjúcóóveíñé ɨ́cúbáhraméí ííñújɨri. ");
INSERT INTO boaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Áánéllii téɨɨbúwá méíjcyaco. Muurá oke ámuha mecáhcújtsóné hallútú pihcyáávejááné pañévú ámúhakye imyéénúmeke tsajtyéimye ávyéjujté éllevu. Aame muurá ámuha méúwááboó diityéke. ");
INSERT INTO boaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Muurá íñe pajtyéteju pámeekéréi ííñújɨri íjcyáné mɨ́amúnáake úwáábóméiíhi. Áijyu ihdyu ó tsaá páneere ílluréjuco ɨnɨ́jkévaki. ");
INSERT INTO boaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ahdícyane ávyéjujté éllevu ditye ámúhakye icyúvéhoojánu tsájtyécooca tsá múu ɨ́jtsámeítyú muhdú iíhjyúváíñeri. Muurá ihdyu Píívyéébere Íapííchoj tééveri ámúhakye túkévéjtsóneri ámuha méihjyúvaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Áhdure téijyu tsané nahbémú íjcyarómé ímityúné dárɨ́ɨ́véjcátsiíhi. Aame tsamééré tsíjtyedívú táúhbájcátsiíhi. Muurá ɨ́ɨ́tsɨɨme íjcyárómedívú cáánimu táúhbaá tsijtye dityéké ɨdsɨ́jɨ́vétsoki. Áhdure idyé ɨ́ɨ́tsɨɨme íjcyarómé cáánímudívú táúhbaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Áhdure cáhcújtsotúmé ámúhakye tsarílleé tahñéjté ámuha meíjcyámeke. Aane ehdu néérónéhjɨ́ pañe Píívyéébeke ɨ́hvéjtsotúmé tsaímíyé nihñéétsihvúré íjcyame ihdyu pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Áhdure muurá duurúvájatu tsátsii ɨ́ɨ́né imítyúné úújéítyútsihvu ímityúné úújeténé Píívyéébeke ávyéta tsárí pájtyeéhi. Aane ihdyu ámuha maájtyúmɨ́cooca méwáácunúcó cáméhbaúnevu Jodéá iiñújɨ múnaa ámuha meíjcyame. Ehdúu muurá tene pájtyeíñé tsúúcajátújuco Píívyéébé ihjyú uubálle múnáajpi Daniéré nééneé. Aane éévehíjcyámé íhya ihdyu waajácújucóó ɨɨná íjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ahdícyane téijyu áachi íjcyame íúcaavéjúcohdí ɨ́mɨjcóhó pañévú tsíeméné iújcuki. ");
INSERT INTO boaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Áhdure íúmɨhé pañe íjcyame íoomíjyúcohdí ihjyávú íwajyámu éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Máɨdáátsoju tsáma tene pájtyeíñé téijyu walléémú éévájtema tsijtye ñohñójtéréi ɨ́ɨ́tsɨ́ɨ́méwuúmú íjcyámeke! ");
INSERT INTO boaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Áánéllii Píívyéébema méihjyúvaco tsúcohɨ́váneri úúníjyáijyu tene ipájtyétu nííjyáháñé lliiñe ámuha mewáácunútuki. ");
INSERT INTO boaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Muurá téijyu íjcyaíñé ávyétá ɨhnáhó ɨ́cúbáhraméí íñée ííñujɨ ípívyéévétsihdyu múijyú ícyahíjcyatúne. Ááné boonétú ihdyu tsáhájuco múijyú téhdu nééné ɨ́cúbáhraméí íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aane muurá Píívyéébe oke wállóótuca pámeere dsɨ́jɨ́véiyáhi. Áánéllii ɨ́ɨ́cúi tsiiñe oke wállóóiibye ihñéjte wájyuri. ");
INSERT INTO boaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aane tsúúca tene pɨ́ɨ́hɨ́cooca íjcyaímyé tsaate íllure iállíñe ‘tsúúca Críjto tsájucóóhií’ nééimye. Áámeke wajácútsi meíjcyáne mécáhcújtsodíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Muurá íjcyaímyé állíu múnaa iiye Críjtodi díllómeíimye. Áhdure díllómeíimye Píívyéébé ihjyú uubálle múnáadi. Aame piivyéteé méénúráítyúronéhjɨ́ imyéénune. Ááneri muurá mɨ́amúnáake mújtátsoímyé Píívyéébedítyu. Tsáijyu múúne téhdure mújtátsóiyómé ɨ́mɨááné dííbyeéjtéjuco íjcyárómeke. ");
INSERT INTO boaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aane íñe tsúúca ámúhakye ó úúballé ɨ́hdétújuco ámuha metéɨ́búwááveki. ");
INSERT INTO boaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ehdu ɨ́cúbáhraméí pájtyéné boone cóójɨ́ejpi nuhba ílluréjuco áábatéiñe. Áhdure péjcóejpi tsáhájuco ájchúityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Áijyu mɨ́ɨ́curu dójcoó cáámetu. Ehdu páneere íévéhóówari ɨ́htsútunéhjɨ́ íjcyane mujtáraba íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Áijyu tsúúca Mɨ́amúnáájpidívúu o ípívyééveebe páneere táɨhtsútú táavyéjuma ojtsó pañétú ó bóhówááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aabe ó táúhbaá níjkyéjɨ múnáake ditye ipíhjyúcu óhdivu tahñéjteke pahúlleváré ííñújɨri, níjkyéjɨri, íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Cáhawáá méɨjtsúcunu higyéérahej. Muurá itsóúúvéne tsiiñe tehe béhjɨ́vánetu méwaajácú píjcyaba pɨ́ɨ́hɨ́jucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ahdu nééne íñe ícyooca ámúhakye o nénehjɨ pájtyénetu tsúúca ámuha méwaajácuú tsiiñe o tsááíñe éévé úújetéjucóóne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aane ɨ́mɨááné ámúhakye o néé ehdu nénehjɨ pájtyeíñé ííñújɨríi mɨ́amúnaa íjcyápíñáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Muurá iñe ííñújɨma páneere íévéhóówari íjcyanéhjɨ́ wágóóóveéhi. Áánetu íñe ámúhakye o néhijcyáné tsá múijyú wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Árónáa ihdyu tsiiñe o tsááíñe éévé tsá múha wáájácutúne. Níjkyéjɨ múnaa íjcyarómé tsá wáájácutúne. Téhdure páñetu Píívyéébé Hajchi o íjcyároobe tsá o wáájácutúne. Apáábyéré ihdyu Llihíyó waajácú múijyú tsiiñe oke iwállooíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ahdícyane tsáma téɨɨbúwá tééné ɨjtsúcunúré meíjcyáne méihjyúvahíjcyaco Píívyéébema. Muurá tsá mewáájácutú múijyú tsiiñe o tsááiñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Muurá tsaapi tsííñé iiñújɨ́ iááhɨ́veté íúníu múnáake pícyoíñú ihjyávú tsáné wákimyéivu ditye tééneri iíjcya dibye téhulle íjcyáné hajchóta. Áámedívú muurá tsáápiikye ityéhmétsoíñúróóbeke tsá dibye néétu múijyú itsááiñe. Ahdu tsá ámúhakye o néétu múijyú tsiiñe o tsááiñe. ");
INSERT INTO boaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ahdícyane téɨɨbúwá meíjcyáne tééne ɨ́jtsóré méíjcyaco. Muurá ávyeta tsá mewáájácutú múijyú ámúhá avyéjuube o íjcyaabe o tsááiñe. Tsáijyu múúne tsájcoojɨ o tsáá cuuvé pañe, mityá cúúvénetúrej, mityá pécójpɨɨ́nej, mityá cóójɨ́ pañévuj. Ávyeta tsá mewáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Áánéllii múu téɨɨbúwá tééne ɨ́jtsóré ijcyá ámúhakye o túvaaóvátu pevétáré ɨɨná méénutúmé cuwáríyé ámuha meíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ehdu íñe ámúhakye o néé pámeere tahñéjté ámuha íjcyámeke. Ahdícyane tsáma tééne ɨ́jtsóré méíjcyaco. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Áijyúhjáa pajtyété wañéhjɨ́ óórítyúne pááá máchómeíhíjcyáné wañéhjɨ́ míjcyoojɨ́cutúréjuco llééváíñáa llúúvájté avyéjujtémá taúhbájú uwáábojte ɨ́jtsámeí muhdú iállíñe Jetsóoke iékééveíñé ɨdsɨ́jɨ́vétsoki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Árónemáhjáa néjcatsímyé teene wañéhjɨ́ pañéi tehdu imyéénútu mɨ́amúnáake iííbórɨ́núíyónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Áijyúhjáa Jetsóó ímamyémuma Betáániárí Tsimóó dííbyere ‘Ahllárɨho’ némeííbyé jari. Aaméhjáa tééjari majchórí íjcyánáa tsáápille tsáá mítyane áhdómeíñé pacúúcújpácyoma. Aalléhjáa téjpacyórí dííbyé nííwau múrijchóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aanéhjáa ímamyémuke tsaríwu pájtyénéllii néjcatsímye: —¿Ɨ́veekíami aalle ɨ́cúbahra pácúúcújpácyori tsáné pijcyábá mewákímyeíñe áhdodúné áhdómeíjpácyorij? ");
INSERT INTO boaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Muurá téjpacyo menáhjɨ́hénúne dsɨ́ɨ́dsɨri mépɨ́aabóiyá ɨ́dáátsóméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ehdúhjáa díílledítyú ditye néérónáa Jetsóó néé diityéke: —Óvi íjcyalle. ¿Ɨ́veekí ehdu ámuha méihjyúváhi? Muurá tehdújuco dille méénune. ");
INSERT INTO boaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Muurá diitye ɨ́dáátsojte tsá kiávú ámúhadítyú pééityúne. Áánetu tsá múhajchótá ámúhama o íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Áánéllii muurá oke téjpacyórí múríjcholle oke ditye cúúúíñé ɨhde tájpi iímíbajchóne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aane ɨ́mɨááné ámúhakye o néé íñe tajtyééveri mɨ́amúnaa pájtyetéíñé uwááboju úwáábohíjcyámé muurá idyé teene úúballéné pámeere ííñújɨri íjcyáné mɨ́amúnaa waajácuúhi. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Áijyúhjáa Jóóda Ijcaríóóté dííbyé mamyémú 12-meva íjcyáméejpi íjcyároobe múijyúrá llúúvájté avyéjujté éllevu ipyééne diityéké neeté dííbyedívú iékéévétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ááneríhjyáa mítyane iímíjyúúvéne imíllémé dííbyeke iáhdone. Ehdúhjáa tsúúca diityémá ipítyácójcatsíñe ílluréjuco dibye ɨ́jtsámeíñé muhdú dííbyedívú iékéévétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aanéhjáa teene pajtyété wañéhjɨ́ óórítyúne pááá ditye máchohíjcyáné wañéhjɨ́ obééjáwuúmuke tsájaatsá múnaa dsɨ́jɨ́vétsohíjcyáné wañéhjɨ́ tújkévajcóójɨ́ Jetsóoke ímamyémú nééhií: —¿Aca kiávú ú imíllé wañéhjɨ májchó muha meméénune? ");
INSERT INTO boaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Áánélliihyéhjáa tsaatétsikye neébe: —Cáhawáá Jerotsaréevu mepej. Ácoomíyí ámuhtsi tsaapi llíyííhyori nújpáñújéébeke maájtyúmɨ́ɨ́bema mépeéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aabe tsájá pañévú úcáávéébe déjutu meúcáávéne tééja múnáájpikye méneéco: “Uwááboobéne múhtsikye néé kiáváhjané íchii mɨ́jcoho íjcyane tééhó pañévú dibye múúhama pajtyété wañéhjɨ májchó májchóihyo.” ");
INSERT INTO boaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Áijyu ámúhtsikye úújétsóiibye tsaho imíwu córɨ́ɨ́hócoba néého cáámééɨ́jɨri íjcyahóvu. Ááhó pañévú méméénuco mééma majcho. Ehdúhjáa neebe diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ahdújucóhjáa dityétsí pééne técoomívu. Aamútsíhjyáa ɨ́mɨááné muhdú dibye néhdújuco iúújeténe tééhó pañévú méénune teene majcho. ");
INSERT INTO boaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ááné iijyúnuvúhjáa Jetsóó tétsihyíjyuco pámeemáyé ímamyémuma. ");
INSERT INTO boaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aanéhjáa tsúúca imájchótsihvu neebe diityéke: —Ɨ́mɨáánetúré ámúhakye o néé íjcyaabe tsaapi ámúhadítyú óhdivu méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aanéhjáa kímóhcó diityéké pájtyénéllii pámeere néé dííbyeke: —¿Aca caabyé ehdu uke muha méméénuúhi, a oó? ");
INSERT INTO boaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Áánélliihyéhjáa neébe: —Íñe tsajɨ́ pañévúré muhtsi dííbyema memájchoobe ehdu oke méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ehdu ɨ́mɨááné oke pajtyéiñe Mɨ́amúnáájpidívúu o ípívyéévéébeke tsúúcajátújucóo Píívyéébé waajácúháámɨtu tene néhdújuco. Árónáa ihdyu máɨdáátsoju tene pájtyeíñé ehdu oke méénúúbeke. Tsáháa ihdyu dibye íjcyáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ehdúhjáa diityéké iñétsihdyu pááaho iékéévéne téhdújtsoobe Píívyéébeke. Áánemáhjáa idyóhdáhɨ́nunévú diityéké iwájtúne neébe: —Íñe tájpi náávé íjcyane memájcho. ");
INSERT INTO boaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Áhduréhjáa ado iékéévéne téhdújtsoobe Píívyéébeke. Áánevúhjáa dibye ájcune adóme. ");
INSERT INTO boaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Áámekéhjáa neébe: —Íñe tátyujpácyo náávé íjcyane úúballé muhdú mɨ́amúnaa ícyahíjcyáné pityájcoju o dsɨ́jɨ́véneri tsíhdyuréjuco cápáyóóveíñé múhdumé oke cáhcujtsómé ipájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aane ɨ́mɨáánetúré ámúhakye o néé ícyoocátú tsiiñe ámúhama bíínojpácyó o ádójúcóóityúné Píívyéébé avyéjuri meíjcyácooca tsiiñe maádóiñévújuco. ");
INSERT INTO boaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aaméhjáa teene pajtyété wañéhjɨ́ majtsíjyú imájtsívátsihdyu péé oríívó bajúvu. ");
INSERT INTO boaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Átsihvúhjáa Jetsóó néé diitye ímamyémuke: —Ípyejco muurá ámuha pámeere ílluréjuco óhdityu metsújááveíñé pahúllevávu. Muurá Píívyéébé waajácúháámɨtu nééneé: “Obééjámú tehméébeke o dsɨ́jɨ́vétsóné boone ílluréjuco ditye mújtaíñé pahúllevávu.” Ehdu muurá nééne Píívyéébé waajácúháámɨtu. ");
INSERT INTO boaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Árónáa ihdyu o dsɨ́jɨ́veebe tsiiñe o bóhɨ́ɨ́ne ó peé ámúhá ɨhde Gariréavu. ");
INSERT INTO boaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ehdúhjáa Jetsóó ímamyémuke néénéllii Péédoro nééhií: —Íhya ihdyu íjtye uke ɨ́hvéjtsoóhi. Áánetu ihdyu tsá uke o ɨ́hvéjtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Áánélliihyéhjáa neebe dííbyeke: —Ɨ́mɨáánetúré uke o néé muurá ípyejcójuco tahñéébé u íjcyaróné u tóónuíñé 3-ijyúvá cáracái míijyúcú májtsívátúné ɨhde. ");
INSERT INTO boaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Árónáacáhjáa Péédoro nééhií: —Muurá tsá o tóónúmeíityúne. Óvíjyuco néhi ihdyu oke ditye dsɨ́jɨ́vetsóné tééné hallútu. Ehdúhjáa pámeere neerá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aaméhjáa úújeté ‘Getsemaníi’ némeítsihvu. Átsihvúhjáa Jetsóó néé diityéke: —Íchiíyéi meíjcyá Píívyéébema o íhjyúvatéki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Áánemáhjáa tsajtyéébé Péédoroo, Jacóóboo, Jóáaá, éhdúmekére. Áámedívúhjáa ávyétá ɨhnáhó kímóóvémeííbye. ");
INSERT INTO boaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Áánemáhjáa neébe: —Muhdú íhya o dsɨ́jɨ́véiúvúduréjuco oke táɨ́ɨ́buwa. Ahdícyane cána íchihdyúréi oke metéhmej. Árónáa ihdyu mécúwadíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ehdúhjáa iñééne peebe éhnííñéwuúvu. Átsihvúhjáa ɨmɨ́móúúvéne Píívyéébema ihjyúvaabe muhdú tene néhajchíí ɨɨ́cúbáhrámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Íllúhjáa ihjyúvaábe: —Ayúju Táácáániíj, tsá muurá ɨɨná u túhúúlletúne. Ahdícyane muhdú u néhajchíí óvíjyacóóné o ɨ́cúbáhrámeíñe. Árónáa idyé tsá o ímillédú u méénúityúne. Óvíi ihdyu muhdú u ímillédú óóma ú meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ehdúhjáa Píívyéébema iíhjyúvátsihdyu óómiibye cuwárí íjcyámedívú iwájtsɨ́ne néé Péédoróke: —¿Aca eene ú cuwáhi, Tsímoj? ¿Ɨ́veekí tsá cuwa u áábúcutú oke u téhmeki? ");
INSERT INTO boaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Imíchi bo meíjcyáne cúwávetúmé Píívyéébema méihjyúvahíjcyá ímítyunévú ámuha metáhjátsámeítyuki. Muurá ɨ́mɨááné ámuha méimíllerá tsaímíyé meíjcyane. Árónáa tsá ámuha meɨ́hnáhootú tehdu meíjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ehdúhjáa diityéké iñééne bɨwáhullévúré ipyééne tsiiñe Píívyéébema ihjyúvaabe piéhdúré tujkénúu iíhjyuvádúre. ");
INSERT INTO boaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Átsihdyúhjáa tsiiñe péébe úújeté téhdure cuwárí íjcyámedívu. Ávyetáhjáa mítyane cuwa diityéké íjcyame tsá dííbyema iíhjyúváíyónéhjɨ éllevu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aabéhjáa diityédí iúlléjéróne tsiiñe Píívyéébema ihjyúvatéhi. Átsihdyúhjáa ihdyu óómiibye diityéké nééhií: —Áyu, ícyooca ihdyu ílluréjuco mecúwáiyóne. Árónáa Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi ímítyúmeke ékéévétsóíñe éévé tsúúca úújetéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ahdícyane ílluréjuco metsu mepéékií. Muurá tsúúca tsaabe óhdivu méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ehdúhjáa Jetsóó néénáa tsúúca tsaatémá Jóóda wajtsɨ́ tétsihvu llúúvájté avyéjujtee, taúhbájú uwáábojtee, túkevéjtsojtee, íjcyame wállóónéllii tsáámeé. Aaméhjáa tsáá ímyéénujcátsiháñé nɨɨtsúmuma, cávaájcoháñema. ");
INSERT INTO boaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ácoocáhjáa ɨ́hdéjuco diityéké Jóóda nééneé: —Cáábyeké o chóhchócuube diibyéjúcoói. Áábeke meékéévéne métsajtyéco. ");
INSERT INTO boaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ehdúhjáa diityéké ipítyajcódújuco Jetsóo éllevu ipyééne dibye néétene: —‘Uwááboóbej, ¿a áánu uúj?’ nééberéhjáa chohchócú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ááneréjucóhjáa ditye iékéévéébeke tsájtyene. ");
INSERT INTO boaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Árónáacáhjáa tsaapi dííbyé mamyémudítyú ɨ́nɨɨtsúwari wállórɨhjúcú llúúvájté avyéjujté úníu múnáájpí núúmɨho. ");
INSERT INTO boaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Áámekéhjáa Jetsóó nééhií: —¿Aca muhdú ɨ́ɨ́vane éhne múúne ímityúné méénuhíjcyáábe éllevu ditye tsáhdu ámuha metsáá taéllevu nɨɨtsúmuma cávaájcoháñéma? ");
INSERT INTO boaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Áánerá íhyajchótá ámúháj pɨɨne o íjcyaabe duurúvájá pañe o úwáábohíjcyáábeke keená ámuha oke meékéévehíjcyáne. Árónáa ihdyu tehdújuco ámuha meméénune Píívyéébé ihjyú uubálle múnaápe tsúúcajátújuco néhijcyáné dííbyé waajácúháámɨtu néhdújuco tene ipájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ehdúhjáa Jetsóó néénáa ímamyémú ílluréjuco wurúvájá pañe o úwáábohíjcyáábeke keená ámuha oke meékéévehíjcyáne. Árónáa ihdyu tehdújuco ámuha meméénune Píívyééááne dííbyéjtane. ");
INSERT INTO boaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Áánáacáhjáa tsaapi ováhtsá íéveho íjcyaabe wájyámubávú idyóvíyíívyéne pehíjcyá diityé déjutu. ");
INSERT INTO boaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Áábekéhjáa ditye ékévérónáa tehba diityé hójtsɨ́ pañévú iwááoíñúne waabe pevéhoréjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aanéhjáa tsúúca Jetsóoke tsajtyémé llúúvájté avyéjúúbe éllevu. Áánáacáhjáa tsijtye llúúvájté avyéjujtee, túkevéjtsojtee, taúhbájú uwáábojtee, íjcyame píhcyaavéjucóó tétsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Áijyúhjáa Péédoro dííbyeke úráávyeebe pehíjcyá diityé kemúellére. Aabéhjáa úújeté lláhajtsɨ́vúré tétsihyi tééjá tehméjté íjcyuujúwatu pɨ́hmɨhíjcyáme élletu ɨpɨ́hmɨki. ");
INSERT INTO boaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Áánáacáhjáa ávyéjujte ɨ́tsámeíhijcyá muhdú Jetsóó hallúvú iállíñe dííbyeke ɨdsɨ́jɨ́vétsoíñe. Árónáacáhjáa tsá ditye píívyetétú muhdú dííbyé hallúvú iállíiyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ávyetáhjáa mítyame dííbyé hallúvú páhduváré álliyómé báñúmeíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Árónáacáhjáa tsaate téhdure dííbyé hallúvú iállíñe nééhií: —Áánu muurá nehíjcyá mɨ́amúnaáváa méénuja duurúvaja iwácávyáhcóne tsííjyaréjuco imyéénuíñé mɨ́amúnaa méénútuja. Aajává pánéévétsóiibye 3 coojɨ́vatúre. Ehdu ihjyúvahíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ehdúhjáa ditye néérone tsá cáhcújtsómeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Árónáacáhjáa llúúvájté avyéjuube diityéj pɨɨnétú iíjyócúúvéne néé Jetsóoke: —¿Ɨ́veekí tsá u áñújcutú aatye díhyallúvú ímítyunéhjɨ́ úúballéne? ");
INSERT INTO boaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Árónáacáhjáa tsá ɨɨná diibye néétune. Áánélliihyéhjáa tsiiñe neebe dííbyeke: —¿A ɨ́mɨááné diibyéjuco uu Críjto ɨ́mɨáábé Píívyéébé Hajchi? ");
INSERT INTO boaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. Aane méwaajácú íñe Mɨ́amúnáájpidívúu o ípívyééveebe ɨ́htsútuube Píívyéébé úníuri o íjcyane. Aabe muurá tsiiñe o tsáácooca ó bóhówááveé ojtsó pañe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ehdúhjáa Jetsóó nééne ávyéta tsárí pajtyé diibye llúúvájté avyéjúúbeke. Áánélliihyéhjáa íwajyámúúné dóváríjcyámeííbyéré nééhií: —Ávyeta tsáhájuco meímílletú tsijtye éhnííñevu dííbyé hallúvú tsiiñe úúballéne. ");
INSERT INTO boaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muurá íñe ámuha melléébóneríyé ¿ɨ́veekí uuhɨ́vatéébé Píívyéébedi? Aane ¿muhdú ámuha méɨjtsúcunúhi? Áánélliihyéhjáa pámeere néé ílluréjuco dibye dsɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ehdúhjáa ditye néénéllii tsaate dííbyé hallúvú úníchíhcyuméré íhyúmɨ ɨbɨ́ɨ́jɨ́núúbeke imyéénúne nééhií: —Áyu cána waajácú caabyé uke méénune. Téhduréhjáa duurúvájá tehméjté dííbyeke wábáajcóhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aanéhjáa Péédoro lláhájtsɨri íjcyánáa llúúvájté avyéjúúbé úníu múnáadítyú tsáápille tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aalléhjáa dííbyeke pɨhmɨ́rí íjcyáábeke ɨɨ́ɨ́tehíjcyáróne nééhií: —Úpée idyé éhne ú ícyahíjcyá Jetsóoma Natsarée múnáájpiíma. ");
INSERT INTO boaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Árónáacáhjáa íllure ityóónúne neébe: —Tehdu o wáájácúúbedíjɨ́ɨ́ óóma ú ihjyúváhi. Ehdúhjáa iñééne lláhájtsɨ́ mɨjcó lleehówavu íjyócúúvetéébe. Áánáacáhjáa tsúúca cáraca májtsiváhi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aabéhjáa tétsihvu úújetéébeke tsiiñe ɨɨ́ɨ́téne tétsihyi íjcyámeke neélle: —Áánu muurá idyé tsaapi Jetsóó mamyémúejpi. ");
INSERT INTO boaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Árónáacáhjáa idyé tsiiñe tóónuúbe. Ááné illúhwuúréhjáa idyé tsíjtyeréjuco nééne dííbyeke: —Áánerá ɨ́mɨááné diibyéjuco uu Jetsóó mamyémúejpi. Muurá eene Gariréa múnaa íhjyuvádú u íhjyúvánetúré méwaajácú diibyéjuco u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ehdúhjáa ditye néénéllii tsiiñe ityóónúne llíhcyámeííbyéré nééhií: —Éje, ɨ́mɨáánetúré tsá o wáájácutú dííbyeke eene ámuha óóma dííbyedi meíhjyúváábeke. ");
INSERT INTO boaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ehdúhjáa dibye néénáa tsiiñe cáraca májtsivá míijyúcújuco. Áánetúhjáa ɨ́tsááveebe Jetsóópe dííbyeke íllu nééneé: “Muurá 3-ijyúvá ú tóónúméií tahñéébé u íjcyaróné cáracái míijyúcú májtsívátúné ɨhde.” Ehdúhjáa Jetsóó nééne ɨɨ́tsáávéne ílluréjuco dibye tááne ávyétá ɨhnáho. ");
INSERT INTO boaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ááné tsɨtsɨ́ɨ́vevúhjáa llúúvájté avyéjujtee, túkevéjtsojtee, taúhbájú uwáábojtee, íjcyame tsiiñe dóbeevéhi. Aaméhjáa Jetsóoke dóhjɨ́uri tsajtyé ávyéjuube Pírááto éllevu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aabéhjáa díllópejtsó dííbyeke: —¿A ɨ́mɨááné uu jodíómú avyéjuúbe? Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. ");
INSERT INTO boaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Áánáacáhjáa llúúvájté avyéjujte dííbyé hallúvú mítyane ímityúné úúballéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Áánélliihyéhjáa Piráátó tsiiñe dííbyeke nééhií: —¿Aca ɨ́veekí eene tsá u áñújcutú aatye díhyallúvú ímítyunéhjɨ́ úúballéne? ");
INSERT INTO boaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ehdúhjáa dibye Jetsóoke néérónáa tsá dibye áñújcutúne. Ááneríhjyáa iúllévenúne tsáhájuco dibye ɨɨná néétune. ");
INSERT INTO boaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Teenéhjáa pajtyété wañéhjɨ́ pañe paíjyuváré ávyéjuube Piráátó tsáápiikye ichívyétsohíjcyá cúvéhóójari íjcyámedítyú dííbyé hallúvú mɨ́amúnaa íhjyúváábekéjuco. ");
INSERT INTO boaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aanéhjáa téijyu íjcyaabe dsɨ́jɨvétso múnáajpi ‘Barabáa’ némeííbyé cúvéhóójá pañe tsijtye dsɨ́jɨvétso múnáama. ");
INSERT INTO boaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Áánáacáhjáa tsúúca tétsihvu mɨ́amúnaa píhcyaavémé imyéénuhíjcyádú táúmeíjyucóó Piráátoke dibye iíjchívyétso tsáápiikye diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Áánélliihyéhjáa neebe diityéke: —Íhya ámuha méimíllé ámuha jodíómú avyéjúúbeke o ácádsɨ́jcaáyóne. ");
INSERT INTO boaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ehdúhjáa neebe diityéké íllure iñómíutááváne llúúvájté avyéjujte ehdu dííbyeke dárɨɨvéné iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Árónáacáhjáa diitye llúúvájté avyéjujte néé tétsihyi íjcyámeke ditye Barabáá hallúvúré iíhjyúva dííbyekéré dibye iíjchívyétso cúvéhóójatu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Áánélliihyéhjáa diibye Piráátó néé diityéke: —¿Ácooca eene jodíómú avyéjuube dibye íjcyane ámuha menéhíjcyáábeke muhdú méméénuúhi? ");
INSERT INTO boaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Áánélliihyéhjáa néémeé: —Dííbyedívú ihdyu páwachékevu wátyétyehcútso. ");
INSERT INTO boaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Áánélliihyéhjáa neébe: —¿Aca ɨɨná ímityúné méénuúbe? Árónáacáhjáa tsiiñe kéévánécoba néémeé: —¡Muúbe, wátyétyehcútsó dííbyedívu! ");
INSERT INTO boaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Áánélliihyéhjáa awáá ijchívyétsoobe cúvéhóójatu Barabáakéré diityémá ímí iíjcyane iímíllénema. Áánemáhjáa Jetsóodívú iwápáájcótsóne ɨ́hvéjtsoobe diityédívú diityéréjuco iwátyétyéhcu páwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Áábekéhjáa tsodáhómú dííbyé já llahájtsɨvu itsájtyéébedívú píhcyaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aaméhjáa dííbyeke uácó wájyamu duujɨ́nuúdú nééjavu. Áhduréhjáa tsuhjɨ́uuhónetu imyéénúné chahííwavu ávohjácómé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Áánemáhjáa wáñejcóme: —¡Ñóóooj, áánu jodíómú avyéjuúbe! ");
INSERT INTO boaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ehdúhjáa iñééne dííbyeke úníchíhcyuméré íllaáyohíjcyá úméhéiyi íhñíwáutu. Áánemáhjáa dííbyé lliiñévú ɨmɨ́hmóúbáne ávyéjútsohíjcyámé íllure dííbyedi iúúhɨ́vaténema. ");
INSERT INTO boaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ehdúhjáa dííbyedi iúúhɨ́vaténé boone tácórɨúcúmé teeja duujɨ́nuúdú nééjaá. Áánemáhjáa uácómé páñétúeja dííbyé wajyámuvúréjuco. Átsihdyúhjáa tsajtyémé dííbyeke páwachékevu iwátyétyéhcúíhullévu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aanéhjáa téhullévú pééme cábuuvé tsirééne múnáajpi Arejáádorómá Róópómútsíj caani Tsimóó íúmɨhétú tsáábedívu. Áábekéhjáa íhbutsómé Jetsóoke iwátyétyéhcúíwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aaméhjáa úújeté tsátsii ‘Niwáupáájɨ’ nééiyóné ‘Góógota’ némeítsihvu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Átsihvúhjáa Jetsóoke íjchorómé ‘mííraá’ némeíñé duurúbájpácyoma bíínojpácyó iúménúnetu. Áronéhjáa tsá dibye ádotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Áábekéhjáa tsúúca wátyétyehcúmé páwachékevu ááméjutúréi nuhba íjcyánáaáca. Ááné boonéhjáa tsodáhómú nehcójcatsí caatyé dííbyé wajyámúúné újcuíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aanéhjáa dííbyé nííwáú caamééhullétú téwachéketu picyóómé tsíeménetu icyáátunúné íllu nééneé: “Áánu jodíómú avyéjuúbe.” ");
INSERT INTO boaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Téhduréhjáa téijyu tsaatétsí ímítyúmútsikye wátyétyehcúmé dííbyé úníutu panéjcuvátú íjcyáwachékéécutu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ehdúhjáa ímítyúmútsima dííbyeke wátyétyehcúmé Píívyéébe íwaajácúháámɨtu íllu néhdújuco: “Ímítyúmé raahórí dsɨ́jɨ́véiibye ímítyúúbedi ditye dílloóbe.” ");
INSERT INTO boaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aanéhjáa dííbyeke úújejémé dííbyedi iúúhɨ́vaténemáyé ‘wamɨwamɨ’ nehíjcyáhi. Áánemáhjáa néémeé: —Ehdɨ́ɨ́vaabéváa eene duurúvaja u wácávyáhcoja 3 coojɨ́vatúré tsiiñe ú pájáávétsóiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Áyu cána bo pájtyetétsaméij. ");
INSERT INTO boaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Téhduréhjáa llúúvájté avyéjujtémá taúhbájú uwáábojte dííbyedi iúúhɨ́vaténe néjcatsíhi: —Tsíjtyekée muurá ɨ́mɨááné pátyetétsohíjcyaábe. Árónáacáha tsá dibye píívyetétú iiye ipájtyetétsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aabe cána óvíi ɨ́mɨááné diibyéjuco Críjto mee ijraéémú avyéjuube iíjcyáhajchíí eene éwachékevúne ditye wátyétyehcúné ityábáhcyúmeíñe pájtyeté botsíi dííbyeke mecáhcújtsoki. Téhduréhjáa dííbyé úníutu ditye wátyétyéhcumútsí uuhɨ́vaté dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Téijyúhjáa cójɨ́jpɨɨnétú ííjyunúné cuuvé tujkévevújuco. ");
INSERT INTO boaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Áánáacáhjáa Jetsóó ávyétá ɨhnáhó íllu wáníjcyámeíhi: —Eróij, Eróij, ¿rama tsabatááni? Tápiivyéébej, Tápiivyéébej, ¿ɨ́veekíami oke ú ɨ́hvejtsoj? Ehdúhjáa nééiyóné ehdu neébe. ");
INSERT INTO boaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aanéhjáa tétsihyi íjcyámedítyú tsaate illéébóne nééhií: —Éje, aadi Eríadi wáníjcyámeí Píívyéébé ihjyú uubálle múnáájpiúvudi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Áánélliihyéhjáa tsaapi ɨ́ɨ́cúi wájyámubádú nééne bíínójpácyó kiwátyetu iééníyojéné úméhéí nɨ́jcáutu ipícyoonévú cújuuvé dibye ɨɨ́ɨ́hároki. Áánemáhjáa neébe: —Bo óvíi Eríá niityétsová dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Áánáacáhjáa tsiiñe ávyétá ɨhnáhó iwáníjcyámeítsihdyu ílluréjuco dibye dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ááné tujkéveríhjyáa duurúvájá pañétú páñétúétsíí watájcó wájyámúwácoba dóchéreevé cáámetu baavu panéjcuvávú wajɨ́tahnécu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aanéhjáa tsodáhómú avyéjuube tétsihyi íjcyaabe ájtyumɨ́ muhdú dibye iwáníjcyámeíñe dsɨ́jɨvéne. Áánetúhjáa neébe: —Á ihdyúha ɨ́mɨááné áánu Píívyéébé Hajchi. ");
INSERT INTO boaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aanéhjáa tsaate walléémú dííbyeke ditye dsɨ́jɨ́vetsóné tsíhyullétúré ɨ́ɨ́tehíjcyáhi. Áámemáhjáa ijcyámé Maaría Madarénaa, tsííñé Maaríá Jacóóboma Jotséemútsíj tsɨɨ́juu, Tsaroméee, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Diityéhjáa muurá Gariréari dibye íjcyácooca dííbyeke pɨ́áábohíjcyámé téhullétú dííbyema tsáá Jerotsaréevu. Áámemáhjáa téhdure ijcyámé tsijtye walléémú dííbyemáa tsáámeé. ");
INSERT INTO boaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aanéhjáa wáyeéévéjcóójɨ́llii ditye ímíbájkímyeíhíjcyajcóójɨ́ pejco ɨ́htsútuube Jotséé Arimatéá cóómi múnáajpi péé Pirááto éllevu, téhdure Jetsóoke cáhcújtsoobe Píívyéébé avyéjú ɨ́tsohíjcyaábe. Aabéhjáa diibye Piráátoke táúmeí dííbyeúvú ɨɨtémeho icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ááneríhjyáa íllure Piráátó ullévenú ‘a ɨ́mɨááné íhya dsɨ́jɨvéjúcoóbe’ iñéénema. Áánemáhjáa tsodáhómú avyéjúúbeke ɨpɨ́úváne dílloobe ɨ́mɨááné dibye dsɨ́jɨvéjúcóhajchíí iwáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aabéhjáa úúballé ɨ́mɨááné tsúúca dibye dsɨ́jɨvéne. Áánélliihyéhjáa Piráátó néé diibye Jotséeke dibye iújcúne icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ahdújucóhjáa dibye téwachéketu tééhoúvuke iñíítyétsóne bɨ́ɨ́jɨnúné imíwu nééné wajyámuba iáhdóbari. Áánemáhjáa nééwájɨtu bóhdómeíñé nikyéhéjú pañévú icyúúúne wátájcoobe nééwayúvu. ");
INSERT INTO boaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aanéhjáa Maaría Madarénamúpɨ́ tsíjpille Maaríá Jotséemútsíj tsɨɨjúmá ájtyumɨ́ dibye cúúune. ");
INSERT INTO boaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Aaméhjáa wáyeéévejcóójɨ́ pejco diille Maaría Madarénaa, Jacóóbój tsɨɨju Maaríaa, Tsaroméee, éhdume ahdó pácúúcújpacyóné Jetsóó ɨɨtémeho itsójtsotéki. ");
INSERT INTO boaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Áánemáhjáa tsíijyu tsííñé tsemáánaréjuco tújkévajcóójɨ́ pejcójuco dííbyé nijkyévú pééme úújeté tétsihvu tsúúca nuhba ájchúnáaáca. ");
INSERT INTO boaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aaméhjáa néjcatsíhi: —¿Aca múha íñe mééma téhejú watájcó nééwayu ɨ́ɨ́nétsoóhi? ");
INSERT INTO boaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Árónáacáhjáa ɨɨtécunúmé téhejú úmɨ́wari teu íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aaméhjáa téhejú pañévú úcaavémé ájtyumɨ́ tsaapi ováhtsá ɨ́mɨánéjcuri ácuúcunúúbeke. Áábé wajyámúhjáa cááméjácoba nééja ávyéta tsɨ́tsɨ. Áábedíhjyáa íllityéme. ");
INSERT INTO boaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Árónáacáhjáa neebe diityéke: —Méíllityédíñe. Muurá ó waajácú ámuha menéhcone Natsarée múnáajpi Jetsóoke éhnée páwachékevu ditye wátyétyéhcúúbeke. Árónáa tsá dibye íchii íjcyájúcootúne. Tsúúca bohɨ́júcoóbe. Cáhawáá méuujévá íchii dibyée íjcyatsíí pevétsíiyéjuco íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ahdícyane méúúballété Péédorómá tsijtye dííbyé mamyémuke tsúúca tsiiñe dibye bóhɨ́jucóóne. Méneeco dibye péjucóóné Gariréavu diityé ɨhde téhullévú diityémá iátyúmɨ́jcatsí diityékée iñéhijcyádújuco. ");
INSERT INTO boaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ehdúhjáa dibye néénemáyé wájucóómé iíllityéneri úúvécunúmére. Aaméhjáa tsá muucá úúbálletu mítyane iíllítyénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aanéhjáa ibóhɨjcóójɨ́ cúúvénetúré Jetsóó bóhówaavé Maaría Madarénadívú dííllé pañétúu 7-meváké naavémuke iwáágóólledívu. ");
INSERT INTO boaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aalléhjáa úúbálleté dííbyé mamyémú dííbyeke kímóóvehíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Árónáacáhjáa tsá díílleke ditye cáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aanéhjáa díílledívú ibóhówáávéné boonétú tsiiñe bóhówááveebe tsíhdyuréjuco míítyétsi ímamyémudítyú juuváyí péhíjcyámútsidívu. ");
INSERT INTO boaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aamútsíhjyáa idyé tsijtye íñahbéjteke úúbálleróné tsá ditye cáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Átsihdyúhjáa bóhówááveebe pámehdívuréjuco ímamyémudívú 11-meváréjuco íjcyame majchórí íjcyámedívu. Áámekéhjáa uhbáíchoobe ɨ́mɨááné bóhɨ́ɨ́beke iájtyumɨ́né tsijtye úúbálleróné ditye cáhcútsohíjcyátúné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Átsihdyúhjáa neebe diityéke: —Ahdícyane óvíi ámuha pámeekéré ííñújɨri íjcyáné mɨ́amúnáake méúwaabó ditye pájtyetéíñé uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aane lléébome ɨ́mɨááné icyáhcújtsóné uubállé tsójtsótsámeímyé ihdyu pájtyéteéhi. Áánetu cáhcújtsotúmé wágóóóveéhi. ");
INSERT INTO boaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aane oke cáhcujtsómé tamyémeri waagóoó tsaaté pañe naavémú íjcyámeke. Téhdure tsíjtyé ihjyu illéébótúrójuri ihjyúvaímye. ");
INSERT INTO boaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Téhdure ííñimyémuke ditye ékééverómé tsá ɨɨná méénúityú diityéke. Téhdure námijtya ádorómé tsá dsɨ́jɨ́véityúne. Aame chéméméhjɨke bóhɨ́ɨ́tsohíjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ehdúhjáa Jetsóó ímamyémuke nééné boonétú tsúúca Píívyéébe dííbyeke ujcú níjkyejɨ́vú dibye iávyéjuuté dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Áábe déjuvúhjáa ímamyémú úwáábohíjcyá pahúlleváré teene dííbyé uwááboju. Aaméhjáa dííbyere pɨ́áábóneri méénúráítyúronéhjɨ́ méénuhíjcyá dííbyé uwááboju iwáájácúmeíki. Áyu tehdújuco");
INSERT INTO boaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Tsúúca muurá tsaate uwáábojte muhdúhjáa Jetsóó méjpɨɨne úllejéné páñetu ájtyumɨ́mé tééné uubállé caatúnuhíjcyá ímí tehdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aane ícyooca ó imíllé ooréjuco tééné uubállé o cáátunúné uke o wájyuube Téóópiró éllevu, diityékée o díllohíjcyánéj pɨɨnévú téhdure páneere ímí ídyéjúcotu tsúúca o wáájácúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aane ó imíllé tééné uubállée ditye méénune u lléébohíjcyáné ímíñeúvú u wáájacúne. ");
INSERT INTO boaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jodéá iiñújɨ́ avyéjuubéhjáa Heróódé íjcyáijyu íjcyaabe tsaapi llúúváábe Tsacaríá Abíámuúbe. Áábé táába méméhjáa Eritsabéé Aróój tsɨɨménémúháábéelle íjcyalle. ");
INSERT INTO boaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Áámútsikyéhjáa Píívyéébe ímí ɨjtsúcunú dííbyé taúhbaju néhdújuco dityétsí íjcyánélliíhye. Aamútsíhjyáa tsá ɨ́ɨ́netú néétsámeítyú mɨ́amúnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Árónáacáhjáa ihdyu tsá dityétsí tsɨ́ɨ́mávatú mewa Eritsabéé ajchíbá íjcyánélliíhye. Ááné pañévúhjáa idyé tsúúca kéémemútsíjyuco diityétsi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aanéhjáa tsáijyu diibye Tsacaríá íjcyáha múnáake dómajcóné llúúvájte Píívyéébé úmɨwávú pácúúcu péététsohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aanéhjáa imyéénuhíjcyádú nehcómé caabyé diitye llúúvájtedítyú páñétúétsihvu úcááveíñe. Aanéhjáa diibye Tsacaríake dómajcóné dibye úcááveíñé páñétúétsihvu duurúvájá pañévú teene imyéwu cúvaane dibye ipyéététsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aanéhjáa dibye péététsóné tujkéveri tsaate áachi íjcyame Píívyéébema ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Áánáacáhjáa dííbyedívú níjkyéjɨ múnáajpi bóhówaavé teene ditye péététsohíjcyáné waɨ́jɨ́ ijcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Áábekéhjáa iájtyúmɨ́ne mítyane íllityéébe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Árónáacáhjáa neebe diibye Tsacaríake: —Díhllityédíñe. Tsúúca muurá Píívyéébe uke lleebó dííbyema u íhjyúvahíjcyáne. Ahdícyane muurá dítyáába Eritsabéé tsɨ́ɨ́mávaá wájpiíkye. Áábeke ú meménuú Jóáádivu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ááneri muurá mítyane ú ímíjyúúveéhi. Áhdure tsijtye ímíjyúúveéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aabe daachi Píívyéébedívú ɨ́htsútuube íjcyaabe tsá bíínojpácyó ádóityúne. Áhdure tsííñé avyéjpacyóné tsá dibye ádóityúne. Muurá tsɨ́ɨ́jú ɨ́ɨ́búwá pañéréi íjcyáróóbé pañe tsúúca Píívyéébé Apííchó íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aabe mítyámeke ijraéémudítyú Ávyéjuube Píívyéébé icyánejcúvú ɨ́búwáávétsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Muurá tsaatéké ɨ́ɨ́tsɨ́ɨ́memáyé cáánímuke dibye ímíbáávyetsómé tsaímiyéjuco íjcyaíñe. Áhdure lléébohíjcyátúrómeke ímíbáávyétsóiíbye. Ehdu muurá Ávyéjuube Jetsóó ɨhde mɨ́amúnáake ímíbájchóiibye ditye ímí dííbyeke iwáátsúcúpéjtso Eríaúvumáa ícyahíjcyáné Píívyéébé Apííchóré dííbyeke túkévéjtsóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ehdúhjáa níjkyéjɨ múnáajpi néénéllii diibye Tsacaríá néé dííbyeke: —¿Aca múhdutú tehdu óóma íjcyaíñe? Muurá tsúúca kéémemútsíjyuco muhtsi átyáábama. ");
INSERT INTO boaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Áánélliihyéhjáa neebe dííbyeke: —Muurá Píívyéébe oke wallóó íúníu múnáajpi Gaabriéé o íjcyáábeke díéllevu uke ɨ́mɨá uubállé o méénuki. ");
INSERT INTO boaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ahdícyane ícyoocátú tsáhájuco u píívyetéityú u íhjyuváné dááchikye tsɨɨju tsɨ́ɨ́mávanévújuco ɨ́veekí uke o úúballéné u cáhcújtsótúnélliíhye. Ehdu úúma pajtyéiñe iéévé úújetéijyu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ehdúhjáa nééneri Tsacaríá duurúvájá pañe íjcyáábeke mɨ́amúnaa áachítyú ityéhméróne múhduréjucó ɨ́jtsámeíñé ɨ́ɨ́cúi dibye tsáátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aabéhjáa iíjchivyédú ɨ́mɨááné tsáhájuco píívyetétú iíhjyuváne. Íhyótsɨríyéjucóhjáa dibye úbáhcyohíjcyáné diityémá iíhjyúvaróne. Aanéhjáa ɨjtsúcunúmé tsíeméné dííbyedívú bóhówaavéné tééjá pañévu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aabéhjáa dííbyeke tene dómájcodújcoojɨ́vá tééjá pañe iwákímyeíñe péjucóó ihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ááné boonétúhjáa ɨ́mɨááné tsúúca mewa Eritsabéé eeváhi. Aalléhjáa ihjyátú tsá úlléjúcootú tsáhojtsɨ́ nuhbáva. ");
INSERT INTO boaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aalléhjáa nehíjcyáhi: —Íhya óhdi mɨ́amúnaa iíhjyúvahíjcyánetu ɨɨ́hveté íñe íllu óóma Píívyéébe meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aanéhjáa tsúúca 6 nuhbávájuco dille íjcyánáa idyé Píívyéébe tsiiñe wallóó níjkyéjɨ múnáajpi Gaabriéeke Gariréari íjcyacóómí Natsaréevu dibye iúújeté wájpiikyéi úújétulle Maaríake. ");
INSERT INTO boaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dííllekéhjáa Jotséé áábajáá ityáábáva Dabíiúvúj tsɨɨménémúhaabe íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aabéhjáa níjkyéjɨ múnáajpi díílle éllevu ipyééne néé díílleke: —Maímijyu ihdyu u íjcyanej. Muurá Píívyéébe uke tujkéveellé tsijtye walléémú ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ehdúhjáa dibye nééneri íllure iúllévenúne ɨ́jtsámeíllé ɨɨná nééiyóné ehdu dibye nééneri. ");
INSERT INTO boaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Árónáacáhjáa neebe díílleke: —Díhllityédíñe. Muurá Píívyéébe uke tujkéveelléhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ahdícyane ú éévaáhi. Aane u tsɨ́ɨ́máváábeke ú meménuú Jetsóodívu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aabe ɨ́htsútuube íjcyaá Páñétúejpi Píívyéébé Hajchi íjcyaábe. Áábeke Píívyéébe ávyéjújtsoó dííbyé ɨhdé múnáajpíi Dabíiúvuke iávyéjujtsódu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aabe ijraéémú avyéjuube íjcyaá múijyú cápáyóóvéítyuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ehdúhjáa dibye néénéllii diille Maaríá néé dííbyeke: —¿Aca muhdú ó éévaá wájpiima o íjcyállejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Áánélliihyéhjáa neébe: —Muurá ihdyu ɨ́htsútuube Píívyéébere Íapííchoj tééveri ehdu úúma méénuúhi. Áánéllii diibye u tsɨ́ɨ́mávaabe dííbyé Hajchíyé íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Téhdure muurá dííelle Eritsabéé tsɨ́ɨ́mávaá tsáápiikye tsúúca kéémelléjuco íjcyárolle. Tsúúca muurá 6 nuhbávájuco dille éévane ajchíbá íjcyárolle. ");
INSERT INTO boaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsá muurá ɨɨná Píívyéébedívú túhuutúne. Páneere piivyéteébe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Áánélliihyéhjáa Maaríá nééhií: —Muurá dííbyeke ó ɨ́ɨ́cúvehíjcyáhi. Aabe ihdyu óvíi eene oke u néhdu óóma meenúhi. Ehdúhjáa dille nétsihdyu ílluréjuco níjkyéjɨ múnáájpi pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Átsihdyúhjáa ɨ́ɨ́cúiye múhdúj coojɨ́vatúrá diille Maaríá péé Jodéá iiñújɨri íjcyáné caméhbáuri íjcyácoomívu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aalléhjáa Tsacaríake iááhɨ́véne dííbyé taaba Eritsabéeke duurúváhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ááné tujkéveríhjyáa diille Eritsabéeke ɨ́jtsɨɨméné vááúmeí íhbáú pañe. Áánáacáhjáa Píívyéébé Apííchó tsúúca dííllé pañe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aalléhjáa kéévánécoba néé Maaríake: —Muurá tsijtye walléémú ehnííñevu uke Píívyéébe tujkéveelléhi. Aabe u tsɨ́ɨ́máváábeke ímí pícyoó panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aalle ¿muhdú ɨ́dátsohɨ́válleke oke ú aahɨ́vevá Táavyéjuube Tápájtyetéébé íjcyáííbyéj tsɨɨju u íjcyalle? ");
INSERT INTO boaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Muurá oke u dúúruváváné tujkéveri tápañe tsɨ́ɨ́mene vááúmeí iímíjyúúvénej pééve. ");
INSERT INTO boaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ahdícyane ihdyu maímijyu u íjcyane eene uke Píívyéébe tújkevéélléné u cáhcujtsódú íjcyalle. Muurá ɨ́mɨááné méénúiibye úúma muhdú uke iñéhduú. ");
INSERT INTO boaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ehdúhjáa Eritsabéé néénéllii Maaríá nééhií: Ávyetáré táɨ́ɨ́búuri ó duurúvá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aabe Tápájtyetétsoobe mítyane oke ímíjyúúvetsó táɨ́ɨ́buu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Muurá íñe dííbyé ɨɨcúve múnáalle ɨ́dátsó o néérólleke oke ɨ́tsááveébe. Ahdícyane ícyoocátú pámeere mɨ́amúnaa óhdi ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Muurá Píívyéébe ɨ́mɨáábé ɨ́htsútuube íjcyaabe tajtyééveri meenú ímí tehdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aabe pámeere mɨ́amúnáadítyú múhdumé dííbyeke ávyejúúllémeke pɨ́aabó diityédí ɨɨ́dáátsóvénema. ");
INSERT INTO boaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Muurá ávyétá ɨhtsútú nénehjɨ imyéénúneri mítyájkímyeímyeke núcójpɨ́vétsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Áhdure ɨ́htsútujte ávyéjujtédítyú íavyéjú idyójtúne ávyéjuutétsoobe ɨ́dáátsóméhjɨkéréjuco. ");
INSERT INTO boaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Muurá ɨ́mɨááneríyé tsúúrámeíhíjcyámedívú éhnííñevu bóhówájtsoobe teéne. Áánetu ɨ́htsutúmé ehnéva múnaa tééneríyé tsúúrámeíhijcyámeke tsá dibye ɨ́mɨáánevu ájcutúne. ");
INSERT INTO boaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Muurá ihñéjté ijraéémú meíjcyámeke ɨɨ́daatsólléne ɨ́hvéjtsótuubéré meke pɨ́áábohíjcyá múijyú nɨ́jkéváityúné éhnéhjáa méɨdé múnáajpi Aavaráaúvuke pámeere ɨ́jtsɨɨménémúháábema iñéhdújuco. Ehdúhjáa neelle Maaría. ");
INSERT INTO boaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aalléhjáa pápihchúú nuhbává Eritsabéema iíjcyátsihdyu oomí ihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aanéhjáa Eritsabéé tsúúca ɨtsɨ́ɨ́máváíñe éévé úújetédú tsɨ́ɨ́mavá wájpiíkye. ");
INSERT INTO boaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Áijyúhjáa díílle hájkímuma tsijtye tééneri iímíjyúúvéne duurúvá dille tsɨ́ɨ́maváné Píívyéébere díílleke pɨ́aabóné iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aaméhjáa tsúúca íhyojtsɨ́tú pápihchúúj coojɨ́vájuco íjcyáábéwúuke íñaméhó nɨ́jcáúemɨ́ɨ́hé kíhdyahɨ́róhi. Áánemáhjáa imíllerómé dííbyéwúuke imyémenúné cááni Tsacaría déjuri. ");
INSERT INTO boaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Árónáacáhjáa tsɨɨju nééhií: —Tsáhaá, Jóáa dííbye méme. ");
INSERT INTO boaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Áánélliihyéhjáa nééme díílleke: —Árónáa tsá teene dídyohjɨ́ba múnáa mémé íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ehdúhjáa iñééne cááníkye úbahcyómé dibye imyéménu keená iímíllenévu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Áánélliihyéhjáa cááni Tsacaríá tsíeméné ityáúmeíñetu caatúnú ‘Jóáa dííbye mémé íjcyaáhi’ iñééneé. Ááneríhjyáa pámeere ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Áijyúhjáa tsúúca íhjyúvaabe Píívyéébeke duurúváhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ááneríhjyáa teene Jodéá iiñújɨ́ caméhbaúne múnaa iúllévenúne úbálléjcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Áánemáhjáa Jóáádityu néémeé: —¿Aca íhya ɨ́ɨ́né ɨhtsútuubéí dííbyéwu? Muurá Píívyéébe ímí dííbyeke ɨjtsúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aanéhjáa téijyu diibye cááni Tsacaríá Píívyéébé Apííchó ípañe íjcyaabe dííbyeke dúúrúvaabe nééhií: ");
INSERT INTO boaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Maímijyu ihdyu mee ijraéémú ávyéjuube Píívyéébe íjcyanej. Muurá meke pɨ́ááboobe mepájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Muurá ɨ́ɨɨcúve múnáajpi Dabíiúvúj tsɨɨménémúháábedítyú pícyóiibye tsaapi ɨ́htsútuube meke pájtyetétsóííbyeke tsúúcajátújucóo íhjyú uubálle múnáaj tééveri iñéhduú. ");
INSERT INTO boaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aabe meke pájtyetétsoó mémunáadítyu. ");
INSERT INTO boaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Muuráhjáa méɨhdé múnáaúvudi ɨɨ́dáátsóvéne diityéké ɨ́hvéjtsótuube pɨ́aabó muhdú diityéké iñéhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Muuráhjáa téhdure méɨhdé múnáajpi Aavaráaúvuke ɨ́mɨáánetúré neebe meke mémunáadítyú ipájtyetétsoíñé ɨ́ɨ́nerí íllityétúmé dííbyekéréjuco meɨ́ɨ́cúve múijyú nɨ́jkéváityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Ehdúhjáa iíhjyúvátsihdyu diibye íllíwúuke neébe: Ahdícyane uu hájchíwu ú íjcyaá ɨ́htsútuube Píívyéébé ihjyú uubálle múnáajpi. Aabe dííbyeéjteke ú ímíbáávyétsoó Ávyéjúúbé ɨhde ditye iwáájácu tsúúca diityé imítyuháñé Píívyéébe diityédí ɨɨ́dáátsóvéne ábájɨ́ɨ́veíñé ditye ipájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Muurá meke ɨɨ́daatsólléne cáámetu wállóóiibye tsáápiikye meéllevu mepájtyetéiñe mééma méénúííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aabe muurá waajácútsoó ɨ́mɨájɨjtóvú eene iwágóóóvéíyojɨ́jtóré úráávyehíjcyámé ɨ́dátsó cúúvétsii múu íjcyadu wáájácúratúmé ícyahíjcyámeke. Ehdu muurá ɨ́mɨájɨjtóvú meke waajácútsóiibye tsaímíyé meíjcyaki. Ehdúhjáa neebe Tsacaría. ");
INSERT INTO boaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aanéhjáa diibye tsɨ́ɨ́mene tsaímíyé píívyeebe ijcyá Píívyéébe ímillédu. Aabéhjáa ícyahíjcyá ɨ́ɨ́néubárá píívyétúné iiñújɨri imúnaa ijraéémú dííbyeke ímíñeúvú wáájácútsihvújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Áánetúhjáa Maaríá tsúúca tsɨ́ɨ́mávaíñé pɨ́ɨ́hɨ́náa páñétúejpi ávyéjuube Tséétsa Aogójtó táuhbá pámeere imyémeháñé icyáátúnútsámeíki. ");
INSERT INTO boaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Téijyúhjáa Tsííriá iiñújɨ́ avyéjuube Tsiréénio íjcyánáa méénútujkénúmé teene páme méméré cáátúnúmeíiñe. ");
INSERT INTO boaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Áánélliihyéhjáa pámeere pehíjcyá ímichi íiiñújɨ́ comíñevu imyémeháñé icyáátúnútsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Aanéhjáa Jotséé diille mewa Maaríá éévállema péé Gariréá iiñújɨ́ Natsaréetu Jodéá iiñújɨri íjcyacóómí Beréevu Dabíiúvúu tsɨ́ɨ́mávámeítsihvu imyémé icyáátúnútso dííbyeúvúj tsɨɨménémúhaabe iíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aanéhjáa tétsii dityétsí íjcyánáa tsúúca Maaríá tsɨ́ɨ́máváíñe éévé úújetéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aalléhjáa tujkénúejpi íjcyáábeke ɨtsɨ́ɨ́máváne wájyámubááneri ɨbɨ́ɨ́jɨ́núúbeke tódsɨjcáró jéémú éébutáwá pañévú kiá dityétsí íjcyáíyotsíí íjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Áánáacáhjáa técoomí úníuri tsaate obééjámuke téhmehíjcyámedívú tépejco níjkyéjɨ múnáajpi bóhówáávéébedítyú Píívyéébé ámɨ́tsaráhcó diityéké ájchúcunúneri mítyane íllityéme. ");
INSERT INTO boaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Árónáacáhjáa neebe diityéke: —Méíllityédíñe. Muurá ɨ́mɨá uubállema o tsáá ámúha éllevu pámeere mítyane ímíjyúúvéíñé uubállema. ");
INSERT INTO boaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Muurá tsúúca ámúhá avyéjuube ámúhakye pájtyetétsóííbyeke tsáápille tsɨ́ɨ́mavá Dabíiúvú coomívu. ");
INSERT INTO boaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aabe wájyámubááneri bɨ́ɨ́jɨ́númeííbyé jéémú éébutáwá pañe íjcyáábeke ámuha maájtyúmɨ́netúré méwaajácuú diibyéjuco íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Áánáacáhjáa diibye níjkyéjɨ múnáájpí úniúvú tsijtye mítyame dííbyé nahbéjté bóhówaavéhi. Aaméhjáa Píívyéébeke dúúruvámé nééhií: ");
INSERT INTO boaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Maímijyu Píívyéébe níjkyéjɨri íjcyaábej. Muurá ííñújɨri íjcyáné mɨ́amúnaa dibye ímillédú íjcyame tsaímiyéjuco íjcyaíñé ɨɨná diityé hallúrí íjcyájúcootúme. ");
INSERT INTO boaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aaméhjáa níjkyéjɨ múnaa tsúúca pééné boone diitye jéémú tehméjté néjcatsíhi: —Cána bo metsu mepéé Beréevu Píívyéébe meke úúballéné maájtyúmɨki. ");
INSERT INTO boaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ehdúhjáa iñééne ɨ́ɨ́cúi téhullévú pééme ɨ́mɨááné ájtyúmɨté diille Maaríaa, Jotséee, diibye tsɨ́ɨ́ménéwu jéémú éébutáwá pañe íjcyaábee, íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aaméhjáa dííbyeke iájtyúmɨ́ne úúballé níjkyéjɨ múnáajpíi dííbyéwúudítyú nééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ááneríhjyáa ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aanéhjáa Maaríake ɨ́ɨ́né imíjyaú pájtyelle tééneri ɨ́tsámeíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Átsihdyúhjáa diitye jéémú tehméjté oomí Píívyéébeke ávyéjújtsoméré diityékée tene némeídyújuco tene íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aanéhjáa 8 coojɨ́vá íjcyáábéwúuke íñaméhó nɨ́jcáúemɨ́ɨ́hé kíhdyahɨ́róme. Átsihvúhjáa dííbyeke meménúmé Jetsóodívú níjkyéjɨ múnáájpíhjyáa Maaríake dilléi éévátúné ɨhdéjuco néhduú. ");
INSERT INTO boaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Téijyúhjáa diille Maaríá ímíbájchómeííñe éévé úújeténéllii pééme Jerotsaréevu Moitséeúvuj tééveríhjyáa Píívyéébe nééné taúhbaju néhdu imyéénuki. Áhduréhjáa téijyu Jetsóoke Píívyéébé hójtsɨ́ pañévú pícyoomútsi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ehdúhjáa meenúmé Píívyéébé taúhbaju íllu néhdújuco: “Tujkénú paméváré wájpiikye tsɨ́ɨ́mávaabe Píívyéébé wáábyutáábé íjcyaáhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aamútsíhjyáa tsajtyé Maaríá ímíbájchómeííñé hallúvú Píívyéébeke ɨɨ́ɨ́cúveíñé míítyétsi wahpéjtétsikye dííbyé taúhbaju íllu néhdújuco: “Múu tóómehémútsíúbake ɨ́júúumútsíúbake tsivá iímíbájchómeíñé ɨɨcúve.” ");
INSERT INTO boaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Téijyúhjáa Jerotsaréeri ɨ́mɨáábé íjcyaabe Tsimeóó tsaímíyé Píívyéébe ímillédú ícyahíjcyaabe ɨ́tsohíjcyá ijraéémuke ímíbáávyétsóiibye tsááiñe. ");
INSERT INTO boaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Áábé pañéhjáa Píívyéébé Apííchó íjcyane úúballé dííbyeke dibyéi dsɨ́jɨ́vétúnáa Píívyéébe wállooíñé meke pájtyetétsóííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aabéhjáa Píívyéébé Apííchóré túkévéjtsóneri péé duurúvajávu. Áánáacáhjáa Jetsóówúuma tsɨ́ɨ́jumútsí úcaavé tééjá pañévú Píívyéébé taúhbaju néhdújuco dííbyéwúuke imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Áhullévúhjáa diibye Tsimeóó dííbyéwúuke iíhbúcúne Píívyéébeke dúúrúvaabe nééhií: ");
INSERT INTO boaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ayúju Píívyéébeéj, tsúúca íñe oke ú ájtyúmɨtsó okée u néénevu dɨ́ɨɨcúve múnáajpi o íjcyáábeke. Ahdícyane óvíi ílluréjuco o dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Tsúúca ó ájtyumɨ́ múúhakye pájtyetétsóííbyeke pámeere mɨ́amúnáadívú u bóhówáávétsóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aabe peetédú néébe téhdure ijraéémú íjcyátúróné mɨ́amúnáake ɨ́mɨájɨjtóvú waajácútsoóhi. Áhdure ihñéjté ijraéémuke ávyéjújtsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ehdúhjáa Tsimeóó íhjyúváneri tsɨ́ɨ́jumútsí ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Téhduréhjáa diityétsí hallúvú pɨáábó táúmeííbyé ímí dityétsí iíjcyaki. Átsihdyúhjáa neebe Maaríake: —Áánúdityu íjcyane muurá mítyame memúnaa ijraéémudítyú éhnííñevu tútávááveéhi. Aame íllure dííbyeke ehdɨ́ɨ́válleé ávyejúúlletúme. Árónáa íjcyaímyé tsaate dííbyeke cáhcujtsóme. ");
INSERT INTO boaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ehdu dííbyeke tene pájtyécooca waajácúmeíiñe muhdú mɨ́amúnaa tsáápiitsá ɨ́jtsaméí íjcyane. Áijyu teene páneere u ɨ́ɨ́tene uke tsɨ́ɨ́juke ávyétá kimóhcó pájtyeé dɨ́ɨ́ɨ́búutu. Ehdúhjáa neebe Tsimeóó Maaríake. ");
INSERT INTO boaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Áhduréhjáa íjcyalle tsáápille kéémelle Atséé dohjɨ́ba múnáajpi Panoéeúvú ajyúwá Áánaá. Aalléhjáa bádsɨ́jcaja iíjcyácooca ityájɨ́váábema ijcyá 7 pijcyábáre. Aanéhjáa tsúúca 84 pijcyábájuco ipííbajyúúvatétsihdyu íjcyalle tsá ɨ́ɨ́nehíjcyatú duurúvájatu. Paíjyuváréhjáa Píívyéébeke dúúrúvalléré ihjyúvahíjcyá dííbyema. Tsáijyúhjáa áwahíjcyalle majcho dííbyema iíhjyúvácoóca. Aalléhjáa Píívyéébere túkévéjtsóneri ɨ́hdéjuco ɨɨná pájtyeíñé úúbállehíjcyalle tétsihvu itsááne duurúvá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ááné boonéhjáa úúbállelle Jetsóó Mépájtyetétsoobe íjcyájucóóné pámeere Jerotsarée múnaa ipájtyetéiñe ɨ́tsohíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ehdúhjáa Píívyéébé taúhbaju néhdu Jetsóój tsɨɨjúmútsí imyéénúné boone oomí Gariréá iiñújɨvu íhcyóómi Natsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aanéhjáa Jetsóó Píívyéébé pɨáábójú pañe tsaímíyé píívyeebe panéváré waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Aabéhjáa tsúúca 12 pijcyábá íjcyáábema tsɨ́ɨ́jumútsí péé Jerotsaréevu pajtyété wañéhjɨvu ténevá pijcyábádú ipyéhijcyádújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aanéhjáa tééné pajtyétavu diityétsidítyú coévaabe Jerotsaréevu dityétsí wáájácútúné hallúri. ");
INSERT INTO boaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɨjtsúcunúmútsíhjyáa dibye péjucóóné tsaatéma. Áánemáhjáa tsájcoojɨ́juco ipyééróne néhcóromútsí dííbyeke imúnáá pañe. Téhduréhjáa tsijtye iwáájácúmé pañe néhcóromútsi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Árónemáhjáa tsiiñe óómimútsí Jerotsaréevu dííbye néhcovu. ");
INSERT INTO boaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aamútsíhjyáa ájtyumɨ́ 3 coojɨ́vatu duurúvájá pañe taúhbájú uwáábojtéj pɨɨne ácuúcunúúbé ditye íhjyúvájcatsíñé lléébúcunúhíjcyáábeke. Aabéhjáa téhdure díllohíjcyá íicyánéjcutu diityéke. ");
INSERT INTO boaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ááneríhjyáa ávyeta ullévenúmé muhdú kémúúbejɨ́ɨ́va wáájácúneri. Téhduréhjáa dííbyeke ditye díllone dibye áñúcuhíjcyáneri ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Áhduréhjáa tsɨ́ɨ́jumútsí dííbyeke iájtyúmɨ́ne ullévenúhi. Áábekéhjáa tsɨɨju nééhií: —Llíhij, ¿aca ɨ́veekí ehdu múhtsikye ú dárɨɨvéhi? Muurá muhtsi díícyáánidyu néébema uke ménéhcohíjcyá tsíñehjɨ́réjuco ɨ́jtsámeímútsíye. ");
INSERT INTO boaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Áánélliihyéhjáa neebe diityétsikye: —¿Aca muhdú ɨ́ɨ́vane oke ámuhtsi ménéhcohíjcyáhi? ¿Aca tsá ámuhtsi mewáájácutú Llihíyó wákimyéiyi o íjcyaídyújuco o íjcyane? ");
INSERT INTO boaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ehdúhjáa diityétsikye dibye nééne tsá dityétsí wáájácutú ɨɨná iñééiyóné ehdu dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aabéhjáa botsíi diityétsima oomí Natsaréevu. Aabéhjáa ícyahíjcyá tsaímíyé diityétsima muhdú dityétsí ímillédu. Aanéhjáa imíwu tsɨɨju ɨɨ́jtsúcunúneri ɨ́tsámeíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aabéhjáa tsúúca kééméveebe mítyanéjuco wáájacúúbeke ímí Píívyéébe ɨ́jtsúcunúúbeke téhdure mɨ́amúnaa ímí ɨjtsúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Téijyúhjáa 15 pijcyábájuco Tibéério páñétúejpi ávyéjuube íjcyánáa Póótsio Piráátó Jodéá iiñújɨ́ avyéjuúbe. Áánetúhjáa Heróódé Gariréá iiñújɨ́ avyéjuúbe. Áánetúhjáa íñahbe Perípé Itoréaa, Taraconíítee, íjcyáné iñújɨ́ɨ́cú avyéjuúbe. Áánetúhjáa Ritsaníá Abirííniá iiñújɨ́ avyéjuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Áánetúhjáa Anáama Caipáamútsí páñétúejtétsí llúúvájté avyéjujtétsi. Téijyúhjáa Tsacaríá hajchi Jóáa ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyáábeke Píívyéébe néé dibye iúwááboki. ");
INSERT INTO boaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ahdújucóhjáa dibye úwááboobéré péhijcyáné patsɨ́hjɨvá múnáakéré Joodáá úníuri íjcyáné iñújɨ́ɨ́ne múnáake. Nehíjcyaabéhjáa ditye íimítyuháñé ɨɨ́hvéjtsóne Píívyéébé icyánejcúvuréjuco ɨɨ́búwáávéne itsójtsótsámeí Píívyéébe diityédí ɨɨ́dáátsóvéne diityé imítyú ílluréjuco iábájɨ́ɨ́veki. ");
INSERT INTO boaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ehdúhjáa Jóáa úwáábohíjcyá Píívyéébé ihjyú uubálle múnáajpi Itsaíaúvú íllu néhdújuco: Méllééboó ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyaabe keeváwu íllu úwaabóne: “Méímibáávyé ímítyú ámuha meícyahíjcyánetu tsaímiyéjuco ámuha meíjcyámeke Ávyéjuube iájtyumɨ́vaki. ");
INSERT INTO boaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Méímibáávyé ámúhá ɨ́jtsaméí éhne múúne juuva nehníwu nénéhjɨri pééroju meímíbájchoju ímí tsatújkevéréjuco íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Muurá Píívyéébe wálloó meke pájtyetétsóííbyeke pámeere mɨ́amúnaa iájtyúmɨki.” ");
INSERT INTO boaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ehdúhjáa Jóáa úwáábohíjcyánéllii tsaate peecútéré dííbyedívú itsójtsótsámeí tsáámeke neébe: —¡Ávyeta mɨ́a ííñimyémúeméjté ámuúha! ¿Múha ámúhakye néé peecútéré ámuha metsójtsótsámeíñeri mepállójcóiyóné Píívyéébe meke méimítyuháñé hallútú ɨ́cúbáhraíñé méúmɨ́wari íjcyánetu? ");
INSERT INTO boaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tujkénúi méuujétsó ɨ́mɨááné Píívyéébé icyánejcúvuréjuco ámuha meɨ́búwaavéné mewáájácu ɨ́mɨááné tehdújuco ámuha meíjcyane. Tsá ámuha menémeíítyuró Aavaráaúvúj tsɨɨménémúhaabe ámuha meíjcyánéllii ɨɨná ámúhakye pájtyéityúne. Muurá íñe néwayúúné íjcyárónetu Píívyéébe ípívyéjtsóiyá tsijtye Aavaráaúvúj tsɨɨménémúháábeke. ");
INSERT INTO boaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aabe muurá téhmehíjcyá ímítyúmeke iwáágóoíñé éhne múúne tsaapi ibájtsotu ímiñe néévátuhéhjɨ́ úwáájɨri iíllóne cóvajtsódu. ");
INSERT INTO boaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ehdúhjáa dibye néénéllii tsaate néé dííbyeke: —¿Aanéhaca muhdú muha méíjcyáiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Áánélliihyéhjáa neébe: —Wájyamúúvámé ájcúiyá tsájaavu tsaate wájyamúúvátúmeke. Áhdure majchómá íjcyame ájcúiyá imájchoma íjcyátúmeke. Ehdúhjáa neebe diityéke. ");
INSERT INTO boaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Téhduréhjáa tsaate ávyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyámé itsójtsótsámeí dííbye éllevu ipyééne néé dííbyeke: —Uwááboóbej, ¿aca muhdú muha méíjcyáiyá ímí Píívyéébema meíjcyaki? ");
INSERT INTO boaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Áánélliihyéhjáa neébe: —Tsá ííñújɨ́ avyéjúúbé taúhbaju nééné ehnííñevu ámuha maáhdótsohíjcyáítyuró mɨ́amúnáake. ");
INSERT INTO boaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Áhduréhjáa tsaate tsodáhómú néé dííbyeke: —¿Ácooca muha muhdú méíjcyáiyáhi? Áánélliihyéhjáa idyé neébe: —Tsá tsaaté éhné peecútéré ámuha medótúcuhíjcyáítyuróne. Áhdure tsá tsaaté hallúvú ámuha maállíítyuróne. Áhdure ámúhakye múhduná ditye ámúhá wákimyéí áhdone múu ímí ɨjtsúcunú tehdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ehdúhjáa diityéké Jóáa nénéllii dííbyedítyú mɨ́amúnaa ɨ́jtsámeí tsáijyu múu diibyéjuco mɨ́amúnáake pájtyetétsóiibye dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Árónáacáhjáa neebe diityéke: —Muurá ihdyu ámúhakye ó tsótsohíjcyá nújpácyori. Áánetu íjcyaabe tsijpi táhboone úwáábóiibye táehnííñevu ɨ́htsútuube íjcyáábeke íjtyúhápáájɨ́ubáré o tácórɨúcu dííbyedívú o pɨ́ɨ́hɨ́véítyúroóbe. Diibye ihdyu ɨ́mɨááné cáhcújtsómé pañévú pícyoó Píívyéébé Apíícho. Áánetu cáhcújtsótúmeke cúújúwá pañévú waagóóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Muurá dówajcáróváiibye ímítyúmedítyú ɨ́mɨáámeke éhne múúne bɨɨvá pañétú tríígo meújcune maááhɨ́vetsódu. Muurá ɨ́mɨáámeke iújcúne ímítyúmeke waagóóiibye cúújuwa múijyú áábatéítyúwá pañévú éhne múúne tríígo néévá meújcúné boone téhiibájɨ́ bɨɨvámá mecóvajtsódu. ");
INSERT INTO boaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ehdúhjáa Jóáa ɨ́mɨáájú úwáábohíjcyá mɨ́amúnáake. ");
INSERT INTO boaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aabéhjáa ávyéjuube Heróódeke néé ɨ́veekí ímíñejɨ́ɨ́ íñahbe Perípé táábake dibye táábaváne. Téhduréhjáa neebe dibye tsíñehjɨ ímityúné méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ehdúhjáa Jóáa úwaabóné illéébóíyótsihvu íllure dííbyedívú tééné hallútú cuvéhoojánútsoóbe. Ááneríhjyáa éhnííñevúré ímityúné méénuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aanéhjáa Jóáa mɨ́amúnáake tsótsohíjcyáábedívú téhdure Jetsóó tsójtsótsámeíhi. Aabéhjáa Jetsóó Píívyéébema íhjyúvánáa cáámetu dííbyé Apííchó ɨ́juuúdú bóhówaavéné niityé dííbyedívu. ");
INSERT INTO boaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Áánáacáhjáa Píívyéébe néé cáámetu: —Uu Hájchíwúuke o wájyúúbedi mítyane ó imíjyúúhií. ");
INSERT INTO boaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aanéhjáa Jetsóó 30 pijcyábá íjcyaabe botsíi tujkénú íwákimyéi. Aabéhjáa tene némeíhijcyádú Jotséé hajchi. Áánetúhjáa Jotséé Eríí hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Áánetúhjáa Eríí Matáá hajchi. Áánetúhjáa Matáá Revíí hajchi. Áánetúhjáa Revíí Méékí hajchi. Áánetúhjáa Mééki Jááná hajchi. Áánetúhjáa Jáána tsijpi Jotséé hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Áánetúhjáa Jotséé Matatíá hajchi. Áánetúhjáa Matatíá Amóó hajchi. Áánetúhjáa Amóó Naóó hajchi. Áánetúhjáa Naóó Éérí hajchi. Áánetúhjáa Ééri Nagáí hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Áánetúhjáa Nagáí Máá hajchi. Áánetúhjáa Máa tsijpi Matatíá hajchi. Áánetúhjáa Matatíá Tsemeíí hajchi. Áánetúhjáa Tsemeíí Jotséé hajchi. Áánetúhjáa Jotséé Jodáá hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Áánetúhjáa Jodáá Joanáá hajchi. Áánetúhjáa Joanáá Réétsá hajchi. Áánetúhjáa Réétsa Tsorobabéé hajchi. Áánetúhjáa Tsorobabéé Tsaratiéé hajchi. Áánetúhjáa Tsaratiéé Néérí hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Áánetúhjáa Nééri Méékí hajchi. Áánetúhjáa Mééki Áádí hajchi. Áánetúhjáa Áádi Cotsáá hajchi. Áánetúhjáa Cotsáá Emodáá hajchi. Áánetúhjáa Emodáá Ééré hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Áánetúhjáa Éére Jotsoéé hajchi. Áánetúhjáa Jotsoéé Erietséé hajchi. Áánetúhjáa Erietséé Joríí hajchi. Áánetúhjáa Joríí Matáá hajchi. Áánetúhjáa Matáá Revíí hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Áánetúhjáa Revíí Tsimeóó hajchi. Áánetúhjáa Tsimeóó Jodáá hajchi. Áánetúhjáa Jodáá Jotséé hajchi. Áánetúhjáa Jotséé Jonáá hajchi. Áánetúhjáa Jonáá Eriakíí hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Áánetúhjáa Eriakíí Meréá hajchi. Áánetúhjáa Meréá Maináá hajchi. Áánetúhjáa Maináá Matátá hajchi. Áánetúhjáa Matátá Natáá hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Áánetúhjáa Natáá Dabíí hajchi. Áánetúhjáa Dabíí Itsaíí hajchi. Áánetúhjáa Itsaíí Obéé hajchi. Áánetúhjáa Obéé Bóó hajchi. Áánetúhjáa Bóo Tsamóó hajchi. Áánetúhjáa Tsamóó Naatsóó hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Áánetúhjáa Naatsóó Aminadáá hajchi. Áánetúhjáa Aminadáá Aráá hajchi. Áánetúhjáa Aráá Ejróó hajchi. Áánetúhjáa Ejróó Pááré hajchi. Áánetúhjáa Pááre Jodáá hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Áánetúhjáa Jodáá Jacóóbó hajchi. Áánetúhjáa Jacóóbó Itsáá hajchi. Áánetúhjáa Itsáá Aavaráá hajchi. Áánetúhjáa Aavaráá Taréé hajchi. Áánetúhjáa Taréé Nacóó hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Áánetúhjáa Nacóó Tseróó hajchi. Áánetúhjáa Tseróó Ragáó hajchi. Áánetúhjáa Ragáó Perééké hajchi. Áánetúhjáa Perééké Hebéé hajchi. Áánetúhjáa Hebéé Tsáárá hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Áánetúhjáa Tsáára Caináá hajchi. Áánetúhjáa Caináá Apatsáá hajchi. Áánetúhjáa Apatsáá Tséé hajchi. Áánetúhjáa Tsée Noéé hajchi. Áánetúhjáa Noéé Raméé hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Áánetúhjáa Raméé Matotsaréé hajchi. Áánetúhjáa Matotsaréé Enóó hajchi. Áánetúhjáa Enóó Jaréé hajchi. Áánetúhjáa Jaréé Mararéé hajchi. Áánetúhjáa Mararéé Caináá hajchi. ");
INSERT INTO boaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Áánetúhjáa Caináá Enóó hajchi. Áánetúhjáa Enóó Tséété hajchi. Áánetúhjáa Tsééte Adáá hajchi. Aabéhjáa diibye Adáake Píívyéébe ípívyéjtsó tujkénú ííñúbatúre. ");
INSERT INTO boaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aanéhjáa Jetsóó pañe Píívyéébé Apííchó íjcyaabe Joodáatu óómííbyeke téénere tsajtyé ɨ́ɨ́néubá píívyétúné iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Áhullévúhjáa Naavéné mávárijchó dííbyeke. Áijyúhjáa 40 coojɨ́vájuco májchótuube téhulle íjcyaabe ajyábáávatéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Áábekéhjáa diibye Naavéné nééhií: —Bo ɨ́mɨááné Píívyéébé Hajchi u íjcyáhajchíí íu nééwáyutu pááaho dípívyéjtsóne majchoj. ");
INSERT INTO boaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Tsá apááñéré majchó tájpí meíjcyatúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ehdúhjáa Jetsóó nééné boonétú dííbyeke tsajtyéébé cáméhbaúvu. Átsihdyúhjáa úújétsoobe páneere ííñújɨ́ avyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Áánemáhjáa neebe dííbyeke: —Íñe páneevúré uke ó ájcuú u mɨ́móúúvéne oke u dúúrúváhajchííjyu. Muurá tahñe páneere íñe imíwu nééne ɨ́htsútunéhjɨ́ íjcyane. Áánevu muurá o ímíllémeke ó ájcúiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Áánélliihyéhjáa idyé neebe Jetsóó dííbyeke: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Máavyéjuube Mépiivyéébekéré medúúrúváábeke méɨ́ɨ́cúvéiyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ááné boonétúhjáa idyé dííbyeke tsajtyéébé Jerotsaréevu. Áánemáhjáa duurúvájá hallúvú cáámevu itsájtyéébeke neébe: —Áyu cána ɨ́mɨááné Píívyéébé Hajchi u íjcyáhajchíí íchihdyu cátsiñíívyé baavújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Muurá dííbyé waajácúháámɨtu nééneé: Píívyéébe wálloó níjkyéjɨ múnáake uke ditye ityéhme ɨɨná uke ipájtyétuki. Aabe tsá ɨ́ɨ́néúbatú u wápújúúvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ehdúhjáa Naavéné Jetsóoke néénéllii neébe: —Téhdure muurá Píívyéébé waajácúháámɨtu nééneé: “Tsá Máavyéjuube Píívyéébeke memáváríjchóityúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aanéhjáa tsiiñe imáváríjchóiyóné ipíívyetéjúcóótúnéllii ílluréjuco dibye ɨ́hvéjtsoíñúné dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Átsihdyúhjáa óómiibye Jetsóó Gariréá iiñújɨvu Píívyéébé Apííchó dííbyé pañe íjcyaábe. Áijyúhjáa dibye méénúné uubállé tsújaavé páneere tééné iiñújɨri. ");
INSERT INTO boaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aabéhjáa tééné iiñújɨri íjcyáné pihcyáávejááneri úwááboobéré péhíjcyáábeke duurúvahíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Átsihdyúhjáa peebe Natsaréevu ípyée ipíívyécoomívu. Aabéhjáa imyéénuhíjcyádú wáyeéévejcóójɨ́ pihcyáávéjá pañévú eevé Píívyéébé ihjyú uubálle múnáajpi Itsaíaúvú waajácúhaamɨ́vú ditye ájcuháámɨ. Íllúhjáa dibye éévetsíí nééhií: ");
INSERT INTO boaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Píívyéébé Apííchó óóma ijcyáhi. Aabe oke picyóó ɨ́mɨájɨ́jtó wáájácútúmeke o úúbálleki. Muurá ɨ́dátsó ícyahíjcyámé ímítyúnéhjɨ́ pañe éhne múúne hállúvatúmé íjcyadu ɨ́cubáhrajte. Áánetu diityéké ó ijchívyétsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Áámeke ó úúbálleé Píívyéébe diityémá ditye pájtyetéiñe méénune. ");
INSERT INTO boaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ehdúhjáa nétsii iéévéné boone téhaamɨ́vú tééjá wákimyéi múnáájpikye iájcúne ácúúveébe. Áábedívúhjáa pámeere tééjá pañe íjcyame ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Átsihdyúhjáa neebe diityéke: —Ehdúu Píívyéébe íwaajácúháámɨtu nééne éévé tsúúca úújetéhi. Aane muurá tsúúca ámuha mélleebó o éévene. ");
INSERT INTO boaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ehdúhjáa Jetsóó diityéké nééne pámeere ímí ɨjtsúcunúhi. Aaméhjáa iúllévenúne néjcatsíhi: —¿Aca tsá éhne áánu Jotséé hajchi íjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Átsihdyúhjáa neebe diityéke: —Behtyu ámuha oke méneéhi: “Taabóóbé u íjcyaabe bo uure tááboméij.” Ehdu muurá ámuha méneé íllu ámuha oke menééiyóne: “Capenaóó cóómiyíi méénúráítyúronéhjɨ́ u méénuhíjcyádú cána meenu ícyoomíyí awáá úpée u píívyécóómiyi.” ");
INSERT INTO boaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Átsihdyúhjáa tsiiñe neébe: —Cáhawáá ɨ́mɨáánetúré ámúhakye o néékií: Tsá muurá cáábyekéikyé Píívyéébé ihjyú uubálle múnáadítyú íiiñújɨ múnaa ávyejúúlléítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Muuráhjáa ijraéémú pañe mítyame pííbájyujte walléémú íjcyará Eríaúvú Píívyéébé ihjyú uubálle múnáajpi íjcyácoóca. Téijyúu ájyaba tééné iiñújɨri 3 pijcyábáj pɨɨnévú daarɨ íjcyánáaáca. ");
INSERT INTO boaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Árónáacáa tsá Píívyéébe wállootú Eríaúvuke diityé éllevu dibyée diityéké nééne ditye lléébóítyuróné iwáájácúnema. Áánemáa wálloobe Tsidóó iiñújɨri íjcyacóómí Tsaréétari íjcyáné piibájyúlle éllevúré dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Téhdurée ijcyámé mítyame íjpí chajááveri chémeme Eritséoúvú Píívyéébé ihjyú uubálle múnáajpi íjcyáijyu. Árómedítyúu tsá tsáápíuba bóhɨ́ɨ́tsámeítyúne. Apáábyérée Tsííriá iiñújɨ múnáajpi Naamáá bóhɨ́ɨ́tsámeí Eritséodívú ípyée icyáhcujtsódújuco íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ehdúhjáa Jetsóó néénetu cayóbáávatémé pámeere pihcyáávéjá pañe íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Áánemáhjáa dííbyeke ijchívyetsómé técoomi íjcyáné caméhbáutu dííbyeke iwááóroki. ");
INSERT INTO boaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Árónáacáhjáa múijyúrá péjúcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aabéhjáa péé Gariréá iiñújɨri íjcyacóómí Capenaóovu. Átsíi múnáakéhjáa úwááboobe wáyeéévejcóójɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aaméhjáa ullévenúhijcyá muhdícyánéjcurí tujkévéwu dibye úwáábóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Áijyúhjáa íjcyaabe tsaapi tétsihyi pihcyáávéjá pañe naavéné ípañe íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Aabéhjáa kéévánécoba nééhií: —¡Jetso Jetsóoj, Natsarée múnáajpi u íjcyaábej! ¿Ɨ́veekí múúhakye ú pátsárijcyóváhi? ¿Mityá múúhakye ú waagóovaj? Muurá uke ó waajácú ɨ́mɨáábé Píívyéébé Hajchi u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ehdúhjáa naavéné dííbyé pañétú íhjyúvánéllii Jetsóó néé dííbyeke: —¡Cúúvéhulléré diícya! ¡Díjchivye áádí pañétu! Ahdújucóhjáa dibye íjchivyéné diityéj pɨɨnévú ɨɨ́jcaáyóóbedítyú dííbyeke tútávájtsótuubére. ");
INSERT INTO boaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ááneríhjyáa pámeere iúllévénúne néjcatsíhi: —¿Aca múhdutú dibye néhdújuco naavémú íchívyehíjcyáné tsaaté pañétu? ");
INSERT INTO boaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ehdúhjáa dibye méénuhíjcyáné uubállé tsújaavé pámeere tééné iiñújɨ múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aanéhjáa pihcyáávéjá pañétú iíjchivyédú Jetsóó péé ímamyémuma Tsimóo jávu. Áánáacáhjáa dííbyé baabe áíívyeri chéménéllii dííbyeke nééme dibye ibóhɨ́ɨ́tsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ahdújucóhjáa dibye teene cheme úhbánetu díílleke tene pájtyene. Aalléhjáa ibóhɨ́ɨ́ne diityéké májchotsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Áijyúhjáa meííjyunúrónáa tsívahíjcyámé páhduváré nééne chémeri chéméméhjɨke dííbye éllevu. Áámekéhjáa idyócárájcóneri bóhɨ́ɨ́tsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aanéhjáa tsaaté pañétú dibye naavémuke íjchívyetsómé nehíjcyáhi: —Uu muurá Píívyéébé Hajchi. Waajácúméhjáa ɨ́mɨááné diibyéjuco Pájtyetétsoobe dibye íjcyane. Áámekéhjáa neebe tsiiñe ditye tehdu iíhjyuvájúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aanéhjáa tsɨtsɨ́ɨ́vevu Jetsóó péé técoomítyú tsiéllevu múubárá íjcyátúhullévu. Árónáacáhjáa mɨ́amúnaa néhcoméré pééme úújeté dííbyedívu. Aaméhjáa wájyurá dííbyeke dibyéi ipyéétu diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Árónáacáhjáa neebe diityéke: —Árónáa ó imíllé téhdure tsícyoomíjɨ múnáake o úúballéné Píívyéébé avyéjutu íjcyáné uwááboju. Muuráhjáa téénéllii Píívyéébe oke wallóóhií. ");
INSERT INTO boaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ahdújucóhjáa dibye úwááboobéré péhijcyáné Gariréá iiñújɨri pihcyáávejááné pañe. ");
INSERT INTO boaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tsáijyúhjáa Jetsóó Genetsaréé unéú úníuri íjcyánáa mítyane mɨ́amúnaa dííbyedívú píhcyaavé Píívyéébé uwááboju illéébúcunúné iímíllénema. ");
INSERT INTO boaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Áánáacáhjáa ájtyúmɨɨbe mɨ́neecu íévemɨ́ɨ́cú tééú úníuri cátsuhjúcunúmɨ́ɨ́cú témɨ́ɨ́cú aabájajtéhjáa ɨ́tsɨnúcoohóné iñíjtyu íjchívyéné boonéemɨ́ɨ́cu. ");
INSERT INTO boaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","4","Aanéhjáa Tsimóo éhmɨ́ pañévú iúcáávéne neebe ditye áyánéwu dííbyeke pɨ́ɨ́néehívú icyátújcaáyoki. Aabéhjáa téémɨ́ pañétú diityéké iúwáábótsihdyu néé Tsimóoke: —Áyu cána ílluréjuco ípañétsíí métsɨnúútej. ");
INSERT INTO boaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Áánélliihyéhjáa Tsimóó néé dííbyeke: —Ávyéjuúbej, ávyetáne pécóhajchótá muha metsɨ́nuurómé tsá meújcutú tsáápíúbake. Árónáa ihdyu u néénéllii tsiiñe muha métsɨ́nuúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ahdújucóhjáa tsɨ́nuume mítyane újcune amómeke. Ávyetáhjáa tsɨ́nucóóhó ílluréjuco móhtobáné diityé padúúcuri. ");
INSERT INTO boaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Áánélliihyéhjáa íhyójtsɨ́neri bómɨhcómé íñahbéjté íhdyúémɨri íjcyámeke ditye ɨpɨ́áábotéki. Ahdújucóhjáa péémema ditye íjchívyetsóne. Aanéhjáa ávyeta ɨhmɨ́néécú buúúvetu. ");
INSERT INTO boaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ááneríhjyáa diibye Tsimóo Péédoro iúllévenúne Jetsóó lliiñévú ɨmɨ́móúúvéne nééhií: —Ávyéjuúbej, ímítyuube o íjcyaabe tsá díúníuri o íjcyáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ehdúhjáa neebe ávyétá mityáné amómeke iújcúneri iúllévenúnema. ");
INSERT INTO boaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Téhduréhjáa íñahbéjtétsí Tsebedéó hájchimútsí Jacóóboma Jóáámutsi ullévenú tééneri. Árónáacáhjáa Jetsóó néé Tsimóoke: —Tsájúréévedíñe. Muurá íñe amómé lliiñája múnáajpi u ícyahíjcyaabe ícyoocátú mɨ́amúnáakéréjuco Píívyéébé icyánejcúvú u ɨ́búwáávétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Áánélliihyéhjáa icyátsúúvétsihvúré páneere ɨɨ́hvéjtsóne Jetsóomáyéjuco ditye pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aabéhjáa Jetsóó tsácoomíyí íjcyánáa tsaapi íjpi chájááveebe tsáábe dííbyeke iájtyúmɨ́ɨ́bé lliiñévú ɨmɨ́móúúvéne nééhií: —Ávyéjuúbej, ¿aca muhdúiyó teene oke u bóhɨɨtsóne? ");
INSERT INTO boaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Áánélliihyéhjáa Jetsóó dííbyeke dócárájcoobéré nééhií: —Mu ihdyu tehdújucoj. Ehdúhjáa dibye néénemáyé tsúúca bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Áábekéhjáa boíjcyuube dibye muucá iúúbállétu muhdú ibóhɨɨ́ne. Neebéhjáa dííbyeke: Tsapéhdúré llúúváábe éllevu pééne dííbyedívú dúhjétsámeítyeco. Ááne Moitséeúvúu néhdu Píívyéébeke tsíeméneri ú ɨ́ɨ́cúveé téénetu mɨ́amúnaa iwáájácu u bóhɨ́jucóóne. ");
INSERT INTO boaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ehdúhjáa dibye néérónáa tsúúca pámeere tééné uubállé waajácúhi. Áánélliihyéhjáa mítyane mɨ́amúnaa píhcyáávehíjcyá dííbyé uwáábovu dibye diityéké ibóhɨ́ɨ́tso ditye chéménéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Árónáacáhjáa diityédítyú múha íjcyátúhullévú péhíjcyaabe Píívyéébema iíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aabéhjáa Jetsóó tsáijyu úwáábohíjcyánáa ijcyámé tétsihyi paritséómuma taúhbájú uwáábojte Gariréaa, Jodéaa, íjcyáné iñújɨ́ɨ́cutu pahúllevátú tsáámeé. Áhduréhjáa ijcyámé tsaate Jerotsaréetu tsáámeé. Aaméhjáa ɨ́ɨ́ténáa Jetsóó Píívyéébé ɨhnáhoori bóhɨ́ɨ́tsohíjcyá chéméméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Áánáacáhjáa tsaate tsivá ɨ́ɨ́botárí íjpi vááúmeítyúúbeke. Áábekéhjáa imíllerómé Jetsóó tsájá pañe íjcyáábe éllevu itsájtyene. ");
INSERT INTO boaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Árónáacáhjáa tsá ditye píívyetétú múhdutú iúcáávéiyóné mítyane mɨ́amúnaa íjcyánélliíhye. Áánélliihyéhjáa cáámevu iñéríívyéne dííbyé tujkévetu idyóhejúróhéjutu niityétsómé dííbyeke mɨ́amúnááj pɨɨnévu. ");
INSERT INTO boaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aaméhjáa ímí cáhcujtsóné iwáájácúne neebe Jetsóó dííbyeke: —Muúbej, tsúúca úhdi o ɨ́dáátsóvéne díimítyú ó ábájɨɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ehdúhjáa Jetsóó nééne taúhbájú uwáábojtémá paritséómú illéébóne néjcatsíhi: —¿Muubáami aabye ɨ́veekí ímityúné ihjyúvá Píívyéébe ímí ɨ́jtsúcunúnejɨ́ɨ́vari? Tsá muurá mɨ́amúnáá imítyuháñé mewáágóóítyuróne. Apáábyéré ihdyu Píívyéébe piivyété teene iwáágoóne. ");
INSERT INTO boaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ehdúhjáa ditye néjcatsíñé Jetsóó iwáájácúne néé diityéke. —¿Aca ɨ́veekí ehdu ámuha méɨ́jtsámeíhi? ");
INSERT INTO boaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Áánerá ó piivyété mɨ́amúnáadi o ɨ́dáátsóvéne diityé imítyuháñé diityémá o ímíbajchóne. Áánéllii ó piivyété áánúke o nééneé: “Úhdi o ɨ́dáátsóvéne díimítyú úúma ó ímíbajchóhi.” Áhdure ó piivyété o nééneé: “Dímíjpyeténe dipye.” ");
INSERT INTO boaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ahdícyane cáhawáá óvíi ámuha máájtyumɨ́ Mɨ́amúnáájpidívúu o ípívyééveebe muhdú o méénune. Ehdúhjáa iñééne diibye íjpi vááúmeítyúúbeke neébe: —Dímíjpyeténe eene dɨ́ɨ́hbotámá dipye dihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ehdúhjáa Jetsóó néénemáyé diityéj pɨɨnétú iíjyócúúvéne péjúcoobe ihjyávú Píívyéébeke dúúrúvaabére. ");
INSERT INTO boaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ááneríhjyáa pámeere tétsihyi íjcyame iúllévenúne téhdure duurúvá Píívyéébeke. Aaméhjáa itsájúréévéne nééhií: —¿Aca muhdú aabye meke ullévenútsóhi? ");
INSERT INTO boaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Átsihdyúhjáa péébe Jetsóó ájtyúmɨté Revíikye ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke iáhdótsohíjcyátsihyi ácuúcunúúbeke. Áábekéhjáa neébe: —Muúbej, ookéréjuco duráávye. ");
INSERT INTO boaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ahdújucóhjáa dibye páneere imyéénuhíjcyáné ɨɨ́hvéjtsóne dííbyemáyéjuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aabéhjáa Jetsóoma wáñehjɨ́vaté ihjyávu. Áánevúhjáa dibye míñutsómé mítyame tsáá tsijtye ííñújɨ́ ávyéjúúbé wáábyuta íjcyáne dsɨ́ɨ́dsɨ́ ahdótso múnaa. Áhduréhjáa tsíjtyehjɨ ijcyá tétsihyi diityéma. ");
INSERT INTO boaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Áánélliihyéhjáa paritséómú taúhbájú uwáábojtémá néé dííbyé mamyémuke: —¿Aca ɨ́veekí ámuha ménahbévá aatye ɨ́mɨáámemájɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Áánélliihyéhjáa Jetsóó nééhií: —Tsá muurá taabóóbé bóhɨɨme tsaímíyé néémeke táábotúne. Muurá ihdyu chémémekéré tááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ahdícyane tsáháa ɨ́mɨááme wáábyú o tsáátune. Muuráhjáa ímítyúme wáábyú o tsáá diityéké o ímíbáávyétso Píívyéébé icyánejcúvuréjuco ditye ɨɨ́búwááveki. ");
INSERT INTO boaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ehdúhjáa Jetsóó néénéllii nééme dííbyeke: —¿Aca ɨ́veekí Jóáá mamyémuu, paritséómú mamyémuu, íjcyame tsáijyu majcho áwahíjcyá Píívyéébema iíhjyúvácoóca? Árónáa muurá dímamyémú tsá tehdu méénuhíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Áánélliihyéhjáa neebe diityéke: —¿Aca tsaatétsí táábávájcatsíñé wañéhjɨvu tsáámeke ámuha majchótú mááwáchóiyáhi? Ehdu nééne támamyémú tsá majcho áwáítyuró diityémá o íjcyáné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Muurá ihdyu íjcyaíñé diityédítyú o pééiñe. Áijyu ihdyu óvíi muhdú iñéhajchíí awámye. ");
INSERT INTO boaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ehdúhjáa iñééné boone diityéké úwááboobe nééhií: —Tsá muurá tene ímityú béhbátu tsúúcáaja wájyamu mepájaabóne. Muurá íllure éhnííñevu táváajcároba. ");
INSERT INTO boaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Áhdure tsá tene ímityú béjpácyo bíínojpácyó mepícyoone tsúúcáau mɨ́ɨ́héneu cahpáyú pañévu. Muurá béjpácyo iúhtsáráúúvéneri táváajcó tsúúcáau. Áijyu muurá wágóoovéné tsanéécújuco bíínojpácyoo, cahpáyuu, íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Áánéllii béjpácyo mépañénú bééú pañévúre. ");
INSERT INTO boaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Muurá tsúúcáajpácyóré iádone ímillémé tsá ádóítyuró béjpácyo bíínojpácyo tsúúcáajpácyóré ímí diityédívú néénélliíhye. Ehdúhjáa neebe Jetsóó dityéke. ");
INSERT INTO boaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aabéhjáa tsáijyu wáyeéévejcóójɨ́ ímamyémuma úmɨhéj pɨɨnétú pájtyénáa bajtsóháñetu ujcúmé imájchoki. ");
INSERT INTO boaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aanéhjáa paritséómú ɨɨ́ɨ́téne néé diityéke: —¿Aca ɨ́veekí ehdu ámuha mémeenú íjcyoojɨ wáyeéévejcóójɨ́ meméénúítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Áánélliihyéhjáa Jetsóó néé diityéke: —¿Aca tsá ámuha meéévehíjcyatú tsáijyúu iájyabáávaténéllii íñahbéjtema Dabíiúvú téeméné méénune Píívyéébé waajácúháámɨtu cáátuváne? ");
INSERT INTO boaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Muuráhjáa duurúvájá pañévú iúcáávéne imájchóítyuróné Píívyéébé ɨɨcúvé pááa majchómé apáámyéré llúúvájte máchohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Áhduréhjáa neebe diityéke: —Muurá íñe Mɨ́amúnáájpidívúu o ípívyéévéébé wáábyuta téhdure téjcoojɨ wáyeéévejcóójɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tsáijyúhjáa téénere wáyeéévejcóójɨ́ pihcyáávéjá pañévú Jetsóó úwaabóhi. Áánáacáhjáa tsaapi tsánejcúehójtsɨ́ íhyójtsɨ múhdurá néébe tétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Áánélliihyéhjáa taúhbájú uwáábojtémá paritséómú Jetsóodívúré ɨ́ɨ́tehíjcyá dííbyeke téjcoojɨ dibye bóhɨ́ɨ́tsóhajchíí téénej tééveri ímítyuube dibye íjcyane iñééroki. ");
INSERT INTO boaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ehdúhjáa ditye ɨ́jtsámeíñé iwáájácúne Jetsóó néé diibye múhdurá íhyójtsɨ néébeke: —Muúbej, cána dichaj. Ahdújucóhjáa dibye pééne dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Áábedítyúhjáa neebe diityéke: —Ámúhakye ó dílloó tsane: ¿Aca tsá íjcyoojɨ wáyeéévejcóójɨ́ mepɨ́áábóítyuró tsaatéké tsíeméné pájtyémeke, mityá méɨ́hvéjtsóiyá ditye ɨdsɨ́jɨ́vekij? ");
INSERT INTO boaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ehdúhjáa iñééne diityéké ɨ́ɨ́teebéré néé dííbyeke: —Muúbej, cána ííllevu cujúúvé díhyótsɨɨ́j. Ahdújucóhjáa dibye cújúúvénemáyé téhojtsɨ́ ímíjpyeténe. ");
INSERT INTO boaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ehdúhjáa Jetsóó méénune dííbyeke múnáátsohíjcyámé ɨɨ́ɨ́téne ávyétá ɨhnáhó cayóbáávatéhi. Áánemáhjáa pítyácójcatsímyé muhdú dííbyeke imyéénuíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Téijyúhjáa Jetsóó cáméhbaúvú péébe Píívyéébema ihjyúvápéjcovéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ááné tsɨtsɨ́ɨ́vevúhjáa pihjyúcuube dííbyema péhíjcyámeke. Áámedítyúhjáa újcuube 12-meváké páñétúejte ímamyémú íjcyame úwááboméré péhíjcyáímyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Aaméhjáa ílluúme: Tsimóóhjáa íjcyáábeke téhdure Péédoródívú dibye méménuúbee, íñahbe Aderéee, Jacóóboo, Jóáaá, Perípee, Batoroméee, Matéoo, Tomáaa, tsijpi Jacóóbó Apéó hajchii, cananíjtámúejpi Tsimóoo, Jacóóbó nahbe Jóódaá, tsijpi Jóóda Ijcarióóté bóónétúhjáa dííbyedívú méénútsóiíbyee, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aaméhjáa teene cáméhbáutu tsááme wajtsɨ́ ítyujkévétsihvu. Áijyúhjáa mítyane mɨ́amúnaa Jetsóó uwáábó illéébúcunú tsáácunú pahúllevátú teene Jodéá iiñújɨtu Jerotsaréetuu, Tíírótuú, Tsidóotuu, íjcyane. Aaméhjáa tsivá chéméméhjɨke dibye ibóhɨ́ɨ́tsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Áámedítyúhjáa tsaaté pañe naavémú íjcyámeke dibye wáágóóné boone tsaímiyéjuco ditye ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Paméváréhjáa chémeméhjɨ́ imíllehíjcyará dííbyeke idyómajcóné tsaatéhjáa dííbyeke idyómájcóneríyé bóhɨhíjcyáné iájtyúmɨ́nélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aanéhjáa Jetsóó ímamyémuke ɨɨ́ɨ́téne nééhií: —Maímijyu ihdyu ámuha ɨdáátsóméhjɨúvú menééme meíjcyanej. Muurá tehdu néémé wáábyuta Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Maímijyu ámuha meíjcyane dibye ímillédú ámuha meíjcyáíyóneri metsúúrámeíhijcyáme. Muurá ámúhakye pɨ́ááboobe tehdu ámuha meíjcyaki. Maímijyu ámuha meíjcyane kímóhcó nénehjɨ ámúhakye pátyehíjcyáme. Píívyéébe muurá ámúhakye ímíjyúúvetsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Muurá íñe Mɨ́amúnáájpidívúu o ípívyéévéébeéjté ámuha meíjcyáné déjúcotu oke cáhcújtsotúmé ámúhakye tsarílleéhi. Aame tsá ámúhakye lléébóityúne. Ámúhakye átéréejtédí idíllóne nehníwu ihjyúvahíjcyaímyé ámúhadítyu. Árome ihdyu maímijyu ámuha meíjcyanej. ");
INSERT INTO boaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muuráhjáa téhdure éíjyuúvú diityé ɨhdé múnáaúvú Píívyéébé ihjyú uubálle múnáadi ɨ́cúbáhrahíjcyáhi. Ahdu ámúhakye ditye dárɨ́ɨ́véróné pañe óvíi ámuha íllure méimíjyúúhií. Muurá ámuha meɨ́cúbáhrámeíñe áhdó ɨ́ɨ́né imíjyaú Píívyéébe ámúhakye pícyoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Áánetu ihdyu ɨ́htsutúmé ehnéva múnaa tééneríyé tsúúrámeíhíjcyámeke máɨdáátsoju tene pájtyeíñej. Muurá tééneri ditye ímíjyúúveróné nɨjkévaá diityéma. ");
INSERT INTO boaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ehdu ɨ́ɨ́né imíjyaú panévatúré ícyahíjcyámeke máɨdáátsoju tene pájtyeíñej. Muurá ɨ́dátsó diityémá nɨjkévaíñé ɨ́ɨ́né imíjyaú ditye ícyahíjcyaróne. Muurá ímíjyuuri íjcyárómema nɨjkévaíñé kímóóvevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Áhdure ditye ávyejúúllehíjcyámeke máɨdáátsoju tene pájtyeíñej. Ehdúu muurá diityé ɨhdé múnáaúvú iiye Píívyéébé ihjyú uubálle múnáadi díllómeímyeke tsaate ávyéjútsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ahdícyane ámuha oke melléébúcunúmeke o néé ámuha mewájyu ámúhakye múnáájtsórómeke. Áhdure ámúhakye tsáríllérómeke múu pɨ́aabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Téhdure múu ámúhadítyú ímityúné íhjyúvárómema tsaímíyé íhjyúváhi. Téhdure ámúhakye áábohíjcyárómé hallúvú múu táúmeí pɨáábó Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Áhdure tsaate ámúhakye méénúhajchíí tsá múu pɨ́ámeítyúne. Téhdure ámúhá wajyámú dɨ́ɨ́vane ditye ámúhadítyú újcúhajchíí múu ɨ́hvejtsó tsiijya ditye itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Áhdure ámúhakye tsíeméné táúmeímyeke múu ajcúhi. Áhdure tsaate ámúha éhné náníhajchíí tsá múu díllotúne. ");
INSERT INTO boaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Áhdure pamévamáyé ámuha ímí meíjcyane meímílléhajchíí múu íicyánéjcutu ɨ́mɨááméré ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Muurá ámúhakye wájyúmekéré ámuha mewájyúhajchíí tsá ɨ́mɨá wájyú tene íjcyatúne. Muurá ímítyúné mɨ́amúnaa íjcyarómé téhdure diityéké wájyúmemáyé wajyújcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Téhdure ámúhama ɨ́mɨáámé íjcyámemáyé ámuha ɨ́mɨáámé meíjcyáhajchíí tsá tene ímityúne. Muurá ímityúmé íjcyarómé tehdu meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Áhdure ámúhakye tsíeménevu ájcúmekéré tééné cápayóóvéré ámuha maájcúhajchíí tsá tene ímityúne. Muurá ímityúmé íjcyarómé tsaatéké tsíeménevu ajcú ditye ɨpɨ́ámeíkíye. Ahdu tsá múu néétune. ");
INSERT INTO boaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ámúhakye múu néhníllérómeke iwájyúne panévatúré ditye pɨ́htónéhjɨtu pɨ́aabó ditye ámúhakye pɨ́ámeíítyúrónáaáca. Ehdu ámuha mepɨ́áábóhajchíí ɨ́htsútuube Píívyéébej tsɨ́ɨ́mé ámuha meíjcyame ɨ́ɨ́né imíjyaú méíjcyaáhi. Muurá Píívyéébe ímityúmé íjcyárómeke ɨɨ́daatsólléne pɨ́áábohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ahdícyane óvíi ámuha pamévakéré meɨ́daatsólléne mépɨ́áábohíjcyá Méécááni Píívyéébe méénuhíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tsá múu íhjyúvatú tsijtye múhdurá néémedi Píívyéébe ámúhakye iñéétu téhdure ímityúmé ámuha meíjcyane. Tsá múu tsíjtyedi ɨ́cúbáhratú Píívyéébe ámúhadi ɨɨ́cúbáhrátuki. Téhdure ámúhakye ímityúné tsaate méénuróné múu ɨ́hvejtsó ɨɨná diityéké méénutúméré téhdure Píívyéébe ámúhakye ɨɨná imyéénútuki. ");
INSERT INTO boaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Múu pɨ́aabó múhdurá néérómeke téhdure Píívyéébe ámúhakye ɨpɨ́ááboki. Muurá ɨ́mɨáámeke pɨ́ááboóbe. Aabe muurá ámuha muhdú tsíjtyeke mepɨ́áábohíjcyádúré ámúhakye pɨ́ááboóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Téhduréhjáa tsiiñe Jetsóó úwááboobe nééhií: —¿Aca tsaapi hállúvátuube tsijpi téhdure néébeke tsajtyéiyá tsiéllevu? ¿Aca tsá tsamútsíyé áákityéítyuró wáhyéju dɨ́ɨ́váné pañévu? ");
INSERT INTO boaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tsá muurá tsaapi mamye dííbyeke úwáábohíjcyáábé ehnííñevu wáájácutúne. Muurá ihdyu páneeréi ɨnɨ́jkévácooca botsíi dibye wáájacúdú wáájácuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Aca ɨ́veekí ámuha méijyácunúhijcyá ámúhá nahbémú hálluúúné pañe wááhyéwuúné íjcyáneri ámúhá hálluúúné pañe úménebááné íjcyane wáájácúmeítyúme? ");
INSERT INTO boaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Muurá úménebááné ámúhá hálluúúné pañe íjcyame tsá ámúhá nahbémuke ámuha menééítyuróne: “Cána muha ámúhakye mebóhdo eene wááhyene ámúhá hálluúúné pañe íjcyane.” ¡Ávyeta bañú múnaa ámuha meíjcyame pánehjɨ́dú ɨ́mɨáámeúvúdú ámuúha! Tujkénú méwaagóoméí eene úménebááné ámúhá hálluúúné pañe íjcyane botsíi ímí ámuha maájtyumɨ́mé mebóhdo teene wááhyene ámúhá nahbémú hálluúúné pañe íjcyane. Ehdu nééne tsá múu tsaate wahdɨ́ɨ́váné imítyúwu méénúneri íjyácunútú tsáijyu múu éhnííñevu ímityúné ámuha meméénuhíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tsá muurá oove néévahíjcyáné uméhé nééváítyuró átéréene oove íjcyatúne. Áhdure oove íjcyatúné néévahíjcyáné uméhé tsá múijyú nééváítyuró oove íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Muurá iñéévatúré méwaajácú uméhééné kéeméhéhjɨ́ íjcyane. Tsá muurá múijyú tsúhjɨ́vahe nééváítyuró híígoó. Áhdure tsá múijyú wacyónejke nééváítyuró baáco. ");
INSERT INTO boaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ahdu ɨ́ɨ́vane muurá ɨ́mɨáámé ɨ́ɨ́búwá pañe ɨ́mɨá ɨ́jtsaméí íjcyanéjuco ditye íhjyuváne. Áánetu ímityúmé ihjyúvá ɨ́ɨ́ɨ́búwá pañe ímítyúné ɨ́jtsaméí íjcyanéjuco. Muurá muhdú ɨ́ɨ́buúúné ɨ́ɨ́jtsaméí íjcyadújuco ditye íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Ɨ́veekí ámuha oke Ávyéjúúbedi médíllohíjcyá ámúhakye o nééne ámuha melléébóne tehdu meíjcyámejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cáhawáá ámúhakye o úúbálle muhdú tahñéjté oke lléébome íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Muurá tsaapi ánúmeííbyé cóhpéj nétsihdyu ávyéta páñé itséhdíhyejújɨri íapɨ́hajcúné wáduhcúhi. Aaja tsá nújpabya wááóítyuró ávyéta cóhpé teja méénúmeíñélliíhye. Ehdu muurá tahñéjté oke lléébome ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Áánetu o nééne cáhcújtsotúmé ijcyá éhne múúne tsaapi ímíñeúvú ihjyá apɨ́hajcúné wádúhcútuja dííbyedívú nújpabya wááóné boone dibye ɨ́dátsó íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ehdúhjáa mɨ́amúnáama Jetsóó iíhjyúvátsihdyu péé ímamyémuma Capenaóovu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ácoomíyíhjyáa romáánómú tsodáhómú avyéjúúbé úníu múnáajpi dibye wájyú néébe ávyeta chémeebe dsɨjɨ́veríjyuco. ");
INSERT INTO boaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Áánáacáhjáa diibye íavyéjuube tsúúca waajácú Jetsóó técoomíyí íjcyane. Áánélliihyéhjáa tsaatéké túkevéjtsojtédítyú wálloobe dííbye éllevu dibye ibóhɨ́ɨ́tso íúníu múnáájpiíkye. ");
INSERT INTO boaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ahdújucóhjáa ditye ipyééne néétene: Ɨ́mɨáábé diibye tsodáhómú avyéjuúbe. Áábeke íhya ihdyu tehdújuco u pɨ́ááboíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Muurá ímí meke wájyuube ijraéémú meíjcyámeke. Muuráhjáa dibye nééjuri mépihcyááveja méénúmeíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ehdúhjáa ditye néénéllii Jetsóó péé diityémá téhullévu. Aaméhjáa pɨ́ɨ́hɨ́júcóónáa tsiiñe tsodáhómú avyéjuube wallóó tsíjtyekéréjuco íñahbévajtédítyú ditye iñééte dííbyeke: —Ávyéjuúbej, tsáhaváne ávyeta dííbye jávú u úújetéityú ɨ́dátsó dibye néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Téénélliihyévané tsá dibye páñetu úúma íhjyúvatétúne. Áánélliihyévané ihdyu íchihdyúré ú neé dííbyé úníu múnáajpi ibóhɨɨ́ki. ");
INSERT INTO boaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Muurévá téhdure tsijtye íavyéjujte dííbyeke nééne méénuhíjcyaábe. Áhdurévá ítsodáhómuke dibye táuhbánéjuco ditye méénuhíjcyáne. Téhdurévá íúníu múnáajpi dibye néhdújuco méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ehdúhjáa diibye tsodáhómú avyéjuube nééne ditye úúbálléneri Jetsóó ullévenúhi. Áánemáhjáa pámeekéré tétsihyi íjcyámeke ɨɨ́ɨ́téne neébe: —Muurá tamúnaa ijraéémú íjcyárómedítyú tsá tsáápíuba ehdu oke cáhcújtsotú eene romáánómuube íjcyároobe cáhcujtsódu. Ehdúhjáa neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aanéhjáa diibye tsodáhómú avyéjuube wálloome téhullétú wájtsɨme ájtyumɨ́vá tsúúca diibye íúníu múnáajpi bóhɨ́ɨ́beke. ");
INSERT INTO boaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Átsihdyúhjáa Jetsóó ímamyémuma Naíivu péébema tsijtye mítyame pééhií. ");
INSERT INTO boaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aaméhjáa técoomívú úújetémé ájtyumɨ́ tsáápille pííbájyúllé hajchi apáábyéré íjcyaabe dsɨ́jɨ́véébeke cúúutémeke. ");
INSERT INTO boaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Áámedíhjyáa Jetsóó ɨɨ́dáátsóvéne díílleke nééhií: —Kímóóvedíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ehdúhjáa iñééne teene ɨ́ɨ́témeho dibye ékééveténéllii teeho íhbume íjyócuuvéhi. Aabéhjáa néé tééhoúvuke: —Llíhi, dácuúve. ");
INSERT INTO boaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ehdúhjáa dibye néénemáyé tsúúca iácúúvéne ihjyúvaabe diityéma. Aanéhjáa Jetsóó tsɨ́ɨ́juke néé dille itsájtye dííbyeke ihjyávu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ááneríhjyáa pámeere tétsihyi íjcyame itsájúréévéne Píívyéébeke dúúruvámé nééhií: —Ícyooca ihdyu Píívyéébé ihjyú uubálle múnáajpi ɨ́htsútuube mééma ijcyáhi. Téhduréhjáa néémeé: —Muurá íñe Píívyéébe pɨ́aabó ihñéjteke. ");
INSERT INTO boaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ááné uubálléhjáa páneere Jodéa iiñújɨ múnáadi tsújaavéhi. Aanéhjáa téhdure tsííñé iñújɨ́ɨ́ne múnaa waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ehdúhjáa dibye méénuhíjcyáné tsojtsó múnáajpi Jóáake ímamyémú úúballéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Áánélliihyéhjáa diityédítyú míítyétsikye wálloobe dityétsí idílloté dííbyeke diibyéjuco éhneváa mɨ́amúnáake pájtyetétsóiibye tsááiibye íjcyáhajchíí iwáájácuki, áánetu diibyéjuco íjcyátúhajchíí tsíjpiikyéi ityéhmeki. ");
INSERT INTO boaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Aamútsíhjyáa Jetsóodívú úújeténáa bóhɨ́ɨ́tsohíjcyaabe mítyámeke páhduváré nééne chémeháñeri chéméméhjɨke. Naavémúhjáa tsaaté pañe íjcyámeke waagóohíjcyaábe. Áhduréhjáa hállúvátúméhjɨke ímípyetétsohíjcyaábe. Áábekéhjáa neemútsi: —Tsojtsó múnáajpi Jóáa múhtsikye wallóó diéllevu uke muhtsi medíllo ¿ava diibyéjuco uu Pájtyetétsoobe éhneváa ííñujɨ́vú tsááiíbye? ¿Mityá tsáhái diibye u íjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Áánélliihyéhjáa Jetsóó néé diityétsikye: —Wa meóómíñe méuubállé dííbyeke muhdú o úwááboobe méénúráítyúronéhjɨ́ o méénune ámuhtsi maájtyumɨ́ne. Páneere méúúbálleco hállúvátuméhjɨ́ hálluvájucóóne, úllétuméhjɨ́ úlléjucóóne, íjpi chájááveméhjɨ́ bóhɨɨ́ne, lléébótuméhjɨ́ tsúúca lléébone, dsɨ́jɨvémé tsiiñe bóhɨɨ́ne. Áhdure méúúbálleco ɨ́dáátsóméhjɨke pajtyéteju tsúúca úwáábómeíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Maímijyu ihdyu oke cáhcujtsómé íjcyanej. ");
INSERT INTO boaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ehdúhjáa Jetsóó néé Jóáa wállóómútsikye. Aamútsíhjyáa óómíñé boone diibye Jóáádityu neébe: —¿Acáa Jóáa ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyáábedívú ámuha mepíhcyáávehíjcyácooca muhdú ámuha méɨjtsúcunú dííbyeke? ¿A ámuháa méɨjtsúcunú éhne múúne úmehe kííjyébari vááúmeídyú páhduváré dííbyé ɨ́jtsaméí nééneé? ");
INSERT INTO boaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿A tsaímíyée úcámeíhíjcyaábe? Muuráhjáa tehdu iújcámeícyá tsá ihdícyátsihyi dibye íjcyáítyuróne. Muuráhjáa ávyéjujté jaaháñé pañéiyo diíbye. ¿Aanée muubá ɨ́mɨááné diíbye? ");
INSERT INTO boaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Mityá Píívyéébé ihjyú uubálle múnáajpíi diíbyej? Ɨ́mɨáánée diibyéjuco. Árónáacáa tsíjtyé ehnííñevu diíbye. ");
INSERT INTO boaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dííbyedítyú muurá Píívyéébé waajácúháámɨtu nééneé: Ó pícyoó dɨ́ɨhde tsáápiikye dibye iúúbálle mɨ́amúnáake ditye iímíbáávyéne ímí uke iwáátsúcúpéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aane ɨ́mɨáánetúré tsá dííbyedu tsijtye néétune. Árónáa níjkyéjɨri íjcyaabe Píívyéébé avyéjúejtédítyú ɨ́ɨdáátsoobe íjcyároobe avyéjúúlléméií diibye Jóáá ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ehdúhjáa Jetsóó néénetu ávyéjúúbé wáábyuta íjcyáne dsɨ́ɨ́dsɨ́ ahdótso múnáama tsijtye múhdumé Jóáádivu tsójtsótsámeímyé waajácú ɨ́mɨáábé Píívyéébe íjcyaabe tehdújuco méénune. ");
INSERT INTO boaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Áánetúhjáa paritséomuma taúhbájú uwáábojte Jóáádivu tsótsójtsámeítyúmé íllure ehdɨ́ɨ́vállehíjcyá téhdure Píívyéébe diityémá méénúiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Áámekéhjáa Jetsóó nééhií: —¿Aca muutédívú íñe ícyoocá múnáake ó meménúiyáhi? Íhya tsɨɨmedivuj. ");
INSERT INTO boaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Muurá múúne lláhájtsɨri ɨ́ɨ́cume úhbácatsíhijcyádú ámuha páhduváré médárɨ́ɨ́vémeíhijcyáhi. Muurá múúne íllu úhbácatsíhijcyáme: “Chiiyóró mellíjchúrónáa tsá ámuha meímílletú mewáhtsɨne tééneri. Áhdure máátyóba májtsí memájtsivárónáa tsá ámuha meímílletú mekímoovéne.” Ehdu múúne tsɨɨme úhbácatsíhijcyámé íjcyadu muurá ámuúha. ");
INSERT INTO boaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Muuráhjáa tsojtsó múnáajpi Jóáa tsá májchópityúne. Áhdurée tsá dibye bíínojpácyó ádohíjcyatúne. Áábedítyúu ámuha ménehíjcyá mééííbye íjcyáábé pañe naavéné íjcyánéllii ehdu dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Áábé boonétúu ó bóhówaavé Mɨ́amúnáájpidívú o ípívyééveébe. Aabe panéváré o májchoobe téhdure ó adó bíínojpácyo. Áánetu idyé ílluréjuco óhdityu ámuha menéhijcyáné oova majchópíwu adópíwu o nééneé. Áhdure ámuha óhdityu ménehíjcyá oova ávyéjúúbé wáábyuta íjcyáne dsɨ́ɨ́dsɨ́ ahdótso múnaa ímityúmé íjcyámedívú o náhbévahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Árónáa muurá Píívyéébeéjté íjcyámedítyú bóhówaavéné dibye diityémá méénuhíjcyáne. Ehdúhjáa Jetsóó néé paritséómuma taúhbájú uwáábojtéke. ");
INSERT INTO boaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aanéhjáa tsaapi paritséómúejpi Tsimóó Jetsóoke míñutsó dibye ihjyávú dííbyema imájchoki. Ahdújucóhjáa péébema dityétsí májchone. ");
INSERT INTO boaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Áánáacáhjáa tsáápille técoomíyí ímítyulle íjcyalle Jetsóó tééjari íjcyane iwáájácúne péé tééjavu imyéwu cúvááné pacúúcújpácyoma. ");
INSERT INTO boaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aalléhjáa dííbyé lliiñévú icyánoovéváne tááhií. Aanéhjáa imáátyori dííbyéj tuháácyú ɨpɨ́pajchóné íhñíwácoríyé ipáácyúné boone téjtuhácyú ichóhchóne teene pácúúcújpácyoríyéjuco dille múrijchóne. ");
INSERT INTO boaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ehdúhjáa dille Jetsóoke méénune diibye eenée dííbyeke ihjyávú tsájtyeebe ɨɨ́ɨ́téne íllu ɨ́jtsámeíhi: “Muurá ɨ́mɨááné Píívyéébé ihjyú uubálle múnáajpi áánu iíjcyaca waajácúiyá aalle muhdɨ́ɨ́vallé íjcyalle dííbyeke ehdu méénune. Muurá ávyeta múhdurá diílle.” ");
INSERT INTO boaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ehdúhjáa dibye ɨ́jtsámeíñé iwáájácúne Jetsóó néé dííbyeke: —Tsímo uke ó neé tsane. Áánélliihyéhjáa neébe: —Bo ihdyu oke diñe, Ávyéjuúbej. ");
INSERT INTO boaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Áánélliihyéhjáa neébe: —Tsaatétsíhjyáa dsɨɨdsɨ táúmeí tsáápiíkye. Áámútsidítyúhjáa tsaapi ujcú 500-jɨva. Áánetúhjáa tsijpi ujcú 50-jɨváre. ");
INSERT INTO boaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aanéhjáa iáhdóiyóné dityétsí píívyetétúnéllii ílluréjuco dibye ɨ́hvejtsóné teene diityétsidi ɨɨ́dáátsóvénema. ¿Aane caabyé diityétsidítyú éhnííñevu dííbyeke wájyune ú ɨjtsúcunúhi? ");
INSERT INTO boaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Áánélliihyéhjáa neebe Tsimóo: —Íhya diibye eenéhjáa éhnííñevu dsɨ́ɨ́dsɨke táúmeiibyej. Áánélliihyéhjáa Jetsóó nééhií: —Tehdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ehdúhjáa néébere díílleke ɨɨ́ɨ́téne néé Tsimóoke: —Éje, muurá íñe uke o ááhɨvéváróóbema tsá nújpácyóubáré u pícyootú tájtyúhaacyu o níjtyámeíki. Áánáa muurá íñe áámye oke tájtyúhaacyu imáátyori ɨpɨ́pajchóné paacyú íhñíwácori. ");
INSERT INTO boaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Áhdure keená oke u dúúruváné u chóhchone. Áánáa muurá áámye oke idyúúruváné chóhchohíjcyá tájtyúhaácyu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Áhdure tsá oke táhníwau dúúrúbájpácyóúbari u múríjchotúne. Aánáa muurá oke múríjcholle pácúúcújpácyori tájtyúhaácyu. ");
INSERT INTO boaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aane uke o néé mítyane dííllé imítyú íjcyaróné dííllé hallúrí íjcyájúcootúné mítyane oke iwájyune dille úújétsónélliíhye. Muurá wahdɨ́ɨ́váné imítyú tsaaté hallúrí íjcyane diityédí meɨ́dáátsóvéne meɨ́hvéjtsóneri tsá mítyane ditye ímíjyúúvéítyuróne. Áánetu ávyétá ɨhtsútú nééné imítyú diityé hallúrí íjcyaróné diityédí meɨ́dáátsóvéne meɨ́hvéjtsóneri muurá mítyane ímíjyuuvéme. Aame meke wajyú mítyane. ");
INSERT INTO boaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ehdúhjáa iñétsihdyu neebe díílleke: —Ímityúné u méénuhíjcyanéhjɨ́ tsáhájuco díhyallúrí íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ehdúhjáa Jetsóó néénéllii tétsihyi tsijtye diibye Tsimóó miñútso múnaa íjcyame nééhií: —¿Aca muubá aabye íjcyaabe piivyété mɨ́amúnáadítyú íimítyuháñé iwáágoóne? ");
INSERT INTO boaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Árónáacáhjáa tsiiñe neebe díílleke: —Oke u cáhcujtsódú íjcyalle tsúúca u pájtyetéllé hallúrí tsáhájuco ɨɨná íjcyatúne. Ahdícyane wa dipye tsaímiyéjucoj. ");
INSERT INTO boaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ehdúhjáa imyéénúné boonétú idyé pehíjcyaabe Jetsóó ímamyémuma tsícyoomíjɨri patsɨ́hjɨvárí íjcyájáhjɨ múnáake iúwáábo muhdú Píívyéébé avyéjú íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Áábekéhjáa téhdure tsaate walléémú nahbénú panévari chémehíjcyámeke dibye bóhɨɨtsóme. Áámemáhjáa Maaría Madaréná dííllé pañétúu 7-meváké naavémuke dibye wáágóolle. ");
INSERT INTO boaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Téhduréhjáa diityé pañe Heróódé pɨááboobe Chóótsá taaba Jóáánaá, Tsotsáánaa, íjcyamúpɨ. Téhduréhjáa ijcyámé tsíjtyehjɨ panévatu majchó dɨ́ɨ́vánetu dííbyeke pɨ́áábohíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Áhduréhjáa mítyane mɨ́amúnaa tétsihyi íjcyácoomíjɨtu Jetsóodívú píhcyáávémeke tsaapi bájtsónetu úwááboobe íllu úúballéhi: ");
INSERT INTO boaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tsaapíhjyáa íwajcyóhá tríígoúúhá bájtsoobe íllure wávárajcóhi. Aanéhjáa dibye wávárájcónetu tsáuhjɨ dojcó juuváj pɨɨnévu. Áuhjɨ́hjáa mɨ́amúnaa tádɨ́rɨ́hcoíñuhíjcyaúhjɨ́ coomɨ́mú méhdojéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ááné tsiúhjɨ́hjáa néwayúúné raahóvú dójcoúhjɨ́ ííñeróné chemé tétsii pɨ́ɨ́pátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ááné tsiúhjɨ́hjáa tsuhjɨ íjcyátsihvu dójcóúhjɨ́ hallúvú tene wááménéneri ííñeróné duhcúvatéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Áánetúhjáa ihdyu tsáuhjɨ dojcó imíwu ííñujɨ nétsihvu. Aanéhjáa imíwu píívyene neevá mítyane. Ehdúhjáa iúúbállétsihdyu kéévánécoba neebe diityéke: —Aane ihdyu óvíi lléébome icyáhcújtsóne tehdu ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aanéhjáa ímamyémú dilló dííbyeke muhdú nééiyóné ehdu dibye úúballéne. ");
INSERT INTO boaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Áánélliihyéhjáa neebe diityéke: —Ehdu ó úúbállehíjcyá Píívyéébe ámúhakye iwáájácútso muhdú íavyéjú íjcyanévu. Aane oke cáhcújtsótúmedívú tsá bóhówáávetúne. Muurá o úwaabóné lléébójúcoorómé ícyahíjcyá teene lléébótúmeúvúdu. Áhdure teene ájtyumɨ́júcoorómé ícyahíjcyá ájtyúmɨ́túmeúvúdu. ");
INSERT INTO boaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","Aane íllu nééiyóné ehdu ó úwáábohíjcyáhi: Muurá tríígóuuhádú nééne Píívyéébé uwááboju tsaate ímí lléébone diityé ɨ́buúúné pañévú úcáávéiyóné Naavéné ditye ipájtyetétu diityédívú mútátsohíjcyáhi. Aane nééiyóné eene juuváj pɨɨnévúhjáa dójcoúhjɨ́ coomɨ́mú méhdone. ");
INSERT INTO boaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Áánetu tsijtye teene uwááboju illéébone ímí ɨ́jtsúcunújúcoorómé páhduváré nééné mávaríjchojúúné iáábucújúcóótúne ílluréjuco téénetu ɨ́hveténé ímí icyáhcújtsótúnélliíhye. Aane nééiyóné eene néwayúúnéj pɨɨnévúhjáa dójcoúhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Áánetu tsijtye uwáábó lléébójúcoorómé muhdú iíjcyáneríyé itsúúrámeíhíjcyánéllii teene ábájɨ́ɨ́vehíjcyáhi. Aame mítyane iéhnéváíyóneríyé íjcyame tsá úraavyéjúcootú tééné uwááboju illéébójúcooróne. Aane nééiyóné eene tsuhjɨ íjcyátsihvúhjáa dójcoúhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Áánetu ijcyámé tsijtye teene uwáábó illéébone ímí tehdújuco ɨ́ɨ́ɨ́búuri ɨɨ́jtsúcunúné tsaímíyé úraavyéme. Aane nééiyóné eene imíwuúhjáa ííñujɨ nétsihvu dójcoúhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Átsihdyúhjáa tsiiñe neebe diityéke: —Tsá muurá peete mepéétetsóné tsíeménevu maávohjácóítyuróne. Tsá cuwáíhcyú lliiñévú mepícyóóítyuróne. Muurá ihdyu cáámevu mépicyóó tene iájchúcunú já pañe téénej tééveri meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ahdu muurá Píívyéébé uwááboju bóhówajtsó páneere muhdú meíjcyane. Muurá páneere téévéneúvú méénúmeíhíjcyaróné tsá wáájácúratúné íjcyáityúne. Muurá páneere waajácúméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ahdícyane ímíñeúvú méɨ́jtsoco íñe ɨ́mɨá uwááboju ámuha tsúúca mewáájacúne. Muurá teene ímíllémedívú éhnííñevu bóhówájtsóiibye ditye ímíñeúvú iwáájácuki. Áánetu teene ímíllétúmedívú tsá dibye bóhówájtsóityúne. Muurá áyánéwu ditye wáájácuróné íllure dojtúcúiibye diityédítyu. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Téijyúhjáa dííbyé nahbémuma tsɨɨju wajtsɨ́ tétsihvu. Aaméhjáa tsá píívyetétú dííbyedívú iúújeténé mítyane mɨ́amúnaa íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aanéhjáa tsaate dííbyeke nééhií: —Éhtsíhyi áachi dɨ́ɨ́tsɨ́ɨ́juma díñahbémú íjcyame imíllé uke iájtyumɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Áánélliihyéhjáa neebe diityéke: —Muurá téhdure íñe Píívyéébé uwááboju illéébone ímí tehdújuco úraavyémé wahárómú, táñahbémú, táñaallému. ");
INSERT INTO boaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tsáijyúhjáa Jetsóó néé ímamyémuke: —Métsu mepájtye éhnéjcúeúvu. Ahdújucóhjáa ditye mɨ́ɨ́neri pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aaméhjáa péhíjcyánáa cúwaábe. Áánáacáhjáa kííjyébari mítyane nújpacyo nóhjɨne úcaavé diityé mɨ́ɨ́né pañévú ápííchówu diityéké pámaúcúiñédu. ");
INSERT INTO boaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Áánélliihyéhjáa dííbyeke iákyéjtsóne néémeé: —¡Ávyéjuúbej, Ávyéjuúbej! Éje, tsúúca mémájcánuúhi. Áánélliihyéhjáa iácúúvéne teene kííjyébama nohjɨ íjcyane úhbaabe tene ɨɨ́hvetéki. Ahdújucóhjáa tene ɨ́hveténé dáíhañéréjuco. ");
INSERT INTO boaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Átsihdyúhjáa neebe diityéke: —¿Aca ihdyu tsáhái eene ámuha Píívyéébeke ímí mecáhcújtsotúne? Ehdúhjáa dibye nééneri iúllévenúne néémeé: —¿Muubáami áánu íjcyáábeke kííjyébama nohjɨ lleéboj? ");
INSERT INTO boaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aaméhjáa Gariréá iiñújɨtu pééme úújeté Gadáárá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Átsihvúhjáa Jetsóó íjchívyénáa tsaapi dííbye éllevu tsáá técoomí múnáajpi naavémú ípañe íjcyaábe. Diibyéhjáa íéveebe wájyamúúvátuube ícyahíjcyá níjkyénéj pɨɨnére. ");
INSERT INTO boaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aabéhjáa Jetsóó lliiñévú ɨmɨ́móúúvéne dííbyeke néé kéévánécoba: —Jétso Jetsóoj, ¿aca ɨɨná ú imíllé óhdityu ɨ́htsútuube Píívyéébé Hajchi u íjcyaábe? Uke o néé óhdi u ɨ́cúbáhrátuki. ");
INSERT INTO boaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ehdúhjáa naavéné néé mɨ́amúnáájpí pañétú Jetsóoke dibyéhjáa dííbyeke ‘díjchivye áádí pañétu’ néénélliíhye. Ávyetáhjáa tsáijyu meívatétsohíjcyaabe naavéné dííbyeke. Áábekéhjáa tsaate íhyójtsɨ́cuma íjtyúhaacyu úwáñehííñeri chíjchuróné távárícyohíjcyaábe. Áábekéhjáa diibye naavéné úúpíyíñuube pehíjcyá ɨ́ɨ́néubárá píívyétúné iiñújɨri. ");
INSERT INTO boaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aanéhjáa Jetsóó néé naavéneke: —¿Aca muubá dimyéme? Áánélliihyéhjáa neébe: —Tamyémé Píváánéejpi. Ehdúhjáa neebe mítyame dííbyé pañe iíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aaméhjáa diitye naavémú néé Jetsóoke dibye iwáágóótu ditye ɨ́cúbáhrámeííyóhullévu. ");
INSERT INTO boaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","33","Áijyúhjáa tétsihyi jéémú meenímú majchóri. Áánélliihyéhjáa naavémú néé Jetsóó iwállo diityéké diityé pañévuréjuco. Ahdújucóhjáa dibye wálloome diibye mɨ́amúnáájpí pañétú iíjchívyéne újcámeíñé méénímú pañévuréjuco. Ááneríhjyáa úúpíyivyémé téwajútú únéú pañévú cáhpíyubámé májcanúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ááneríhjyáa diityé tehméjté iíllityéne wááme úúbálleté técoomí múnáake. Áhduréhjáa técoomítyú kémuéllé íjcyájáhjɨ múnáake úúballéme. ");
INSERT INTO boaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Áánélliihyéhjáa mɨ́amúnaa téhullévú péécunú iájtyúmɨ muhdú tene pájtyene. Aaméhjáa úújetémé ájtyumɨ́ dííbyeke eenée naavémú dííbyé pañétú íjchívyéébeke íwajyámúúnemájuco íjcyaabe tsaímiyéjuco Jetsóó lliiñe ácuúcunúúbeke. Ááneríhjyáa íllityéme. ");
INSERT INTO boaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Áámekéhjáa tsaate tétsihyi íjcyame úúbállépejtsó muhdú tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ááneríhjyáa iíllityéne nééme Jetsóoke dibye ipyéé tétsihdyu diityé iiñújɨtu. Ahdújucóhjáa dibye ímamyémuma óómiñe bɨwánejcúvúre. ");
INSERT INTO boaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Áábekéhjáa diibye eenée dííbyé pañétú naavémú íjchívyeebe néé dííbyema ipyéékií. ");
INSERT INTO boaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Árónáacáhjáa neebe dííbyeke: —Tsáhaá, dihjyávúré pééne duubállé páneere muhdú Píívyéébe uke bóhɨɨtsóne. Ahdújucóhjáa péébe úúballéné íhcyóómi múnáake páneere muhdú Jetsóó dííbyeke bóhɨɨtsóne. ");
INSERT INTO boaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aanéhjáa Jetsóó tsíñejcúéuri ímamyémuma iúlléjétsihdyu wájtsɨ́ɨ́beke tsaímíyé mɨ́amúnaa waatsúcúpejtsó dííbyeke témehíjcyadúme. ");
INSERT INTO boaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Áánáacáhjáa ‘Jáiro’ némeííbyé tsáá tétsihvu pihcyáávéjá avyéjuube íjcyaábe. Aabéhjáa ɨmɨ́móúúvéne néé Jetsóoke dibye ipyéé dííbye jávú apáálléré ɨ́dsɨ 12 pijcyábá íjcyalle dsɨjɨ́veríjyuco íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aanéhjáa téhullévú péébeke mítyane mɨ́amúnaa úraavyé ávyeta rááutúne. ");
INSERT INTO boaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Áámécóbá pañéhjáa tsáápille péé 12 pijcyábájuco ichémé tujpácyó ɨ́hvetépítyúneri ɨ́cúbáhrámeíhíjcyalle. Aalléhjáa ihñénéhjɨ́ pɨ́rujtsójucóó bañúháñé taabójteke iáhdohíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aalléhjáa idyéju éhnéjcutu Jetsóodívú ɨpɨ́ɨ́hɨ́véne dííbyé wajyámú dómajcóhi. Ááné tujkéveríhjyáa tsúúca ichémé díílleke ɨ́hvetéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aanéhjáa Jetsóó iwáájácúne nééhií: —¿Múha ámuha oke médómajcóhi? Árónáacáhjáa nééme dííbyeke idyómájcotúne. Aanéhjáa Péédorómá tsijtye íñahbéjté néé dííbyeke: —Uwááboóbej, ¿aca muhdú wahdyúré mɨ́amúnaa néétúnáa ú dilló múha uke dómajcóne? ");
INSERT INTO boaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Áánélliihyéhjáa neebe diityéke: —Muurá ó waajácú tsaate bóhɨɨne íllure oke idyómájcóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aanéhjáa Jetsóó wáájacújúcóónéllii íllityécunúlléré dííbyé lliiñévú mɨ́móúúvetéllé pámeere lléébónáa úúballé muhdú néénéllii dííbyé wajyámú idyómájcóne tsúúca ibóhɨɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Áánélliihyéhjáa neebe díílleke: —Árone Wa ímí Píívyéébeke u cáhcujtsódújuco íjcyalle íñe tsúúca u bóhɨɨ́ne. Ahdícyane wa dipye tsaímiyéjucoj. ");
INSERT INTO boaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ehdúhjáa dibye díílleke néénáa tsaate diibye pihcyáávéjá avyéjuube Jáiró jatu tsááme dííbyeke neeváhi: —Tsúúca dáájyuwa dsɨ́jɨvéhi. Aane ɨ́ɨ́nélliihyécó báñú ú tsájtyeé aabye uwáábóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aanéhjáa Jetsóó illéébóne néé Jáiróke: —Kímóóvedíñe. Cáhawáá ihdyu Píívyéébeke cahcújtsó dáájyuwa úúma ibóhɨɨ́ki. ");
INSERT INTO boaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aanéhjáa tsúúca dííbye jávú ditye úújeténáa Jetsóó tsá ímílletú mítyame úcaavéné dííbyema tééjá pañévu. Apáámyéréhjáa Péédoroo, Jóáaá, Jacóóboo, diityétsí díílléwúuúvúj caanímútsii, éhdume úcaavéné imílleébe. ");
INSERT INTO boaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Áánáacáhjáa pámeere tétsihyi íjcyame tahíjcyá díílleúvuke. Áámekéhjáa neébe: —Métahdí dsɨ́jɨ́véllekéjɨ́ɨ́vari. Muurá ihdyu íllure cúwalle. ");
INSERT INTO boaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ehdúhjáa Jetsóó nééneri uuhɨ́vatémé dííbyedi tsúúca ɨ́mɨááné dille dsɨ́jɨ́vénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Árónáacáhjáa díílleúvú hójtsɨtu iékéévéne kéévánécoba neébe: —Wáhaj, dájkyeé. ");
INSERT INTO boaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ahdújucóhjáa ibóhɨ́ɨ́ne dille ácuuvéne. Átsihdyúhjáa neebe ditye imájchótso díílleke. ");
INSERT INTO boaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ááneríhjyáa diityétsí cáánímutsi mítyane úllévenúmútsikye neebe dityétsí muucá iúúbállétu teéne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Áhduréhjáa tsáijyu Jetsóó pihjyúcú ímamyémú 12-meva íjcyámeke. Áámé pañévúhjáa pícyoobe ɨtsɨ́jpá dííbye mémeri tsaaté pañétú páhduváré nééme naavémuke ditye iwáágóohíjcyaki, chéméméhjɨke ditye ibóhɨ́ɨ́tsohíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Áánemáhjáa wallójúcoobe muhdú Píívyéébé avyéjú íjcyane úwáábotémé téhdure chéméméhjɨke ibóhɨ́ɨ́tsohíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Áámekéhjáa neébe: —Métsajtyédí ámúhá cuujúii, ámúhá cahpáyuu, ámúha májchoo, ámúha dsɨ́ɨ́dsɨɨ, éhdune. Tsájaare ámúhá hallúéjamáyé mépeéco. ");
INSERT INTO boaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aame tsaaté javu meúújetéjaríyé méíjcyaco tétsihyi ámuha meíjcyáné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aane tsátsíi múnaa ámúhadi ɨ́ɨ́cúvétúhajchíí diityédí ɨ́ɨ́cúvetúmé ámúháj tuhááñeri íjcyáne ííñú mépíchóújcámeícyó ‘tsá múúhá hallúrí tene íjcyatú ámúhakye muha meúwáábóiyóné ámuha meéhdɨɨvállehíjcyáne’ nééiyóne. Ááne ílluréjuco mépeeco tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ehdúhjáa úwááboobe ímamyémuke. Ahdújucóhjáa ipyééne ditye ɨ́mɨáájú úwaabóné patsɨ́hjɨvá múnáake. Aaméhjáa bóhɨ́ɨ́tsohíjcyá chéméméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ehdúhjáa Jetsóó méénuhíjcyáné ávyéjuube Heróódé iwáájácúne páhduváré ɨ́jtsámeí dííbyedítyú ‘tsojtsó múnáajpi Jóáa tsiiñe bóhɨɨ́be’ tsaate néhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Áánetúhjáa tsijtye nehíjcyá éíjyuúvúu íjcyame Píívyéébé ihjyú uubálle múnaa dsɨ́jɨ́vémedítyú tsaapi bóhɨɨbe dibye íjcyane. Tsaatéhjáa ɨjtsúcunú Eríá dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Áánetúhjáa Heróódé nééhií: —Ááneráhjáa Jóáádivu ó táuhbá ditye íhñíwau ikípíyuúcuki. Aanéjɨ́ɨ́ ¿muubáami tsáma diibye eene ehdu méénuhíjcyaábej? Ehdúhjáa iñééne Heróódé imíllé Jetsóoke iájtyúmɨ́iyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aanéhjáa ímamyémú Jetsóodívú iwájtsɨ́ne úúballé páneere muhdú téhulle imyéénuhíjcyanéhjɨ. Átsihdyúhjáa Jetsóó péé diityémá múha íjcyátútsihvu Betsáidáj pɨɨhɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aanéhjáa kiávú ditye pééne iwáájácúne tsijtye úraavyé diityéke. Áámekéhjáa úwááboobe Píívyéébé avyéjutu. Áámedítyúhjáa bóhɨ́ɨ́tsoobe chéméméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aanéhjáa tsúúca meííjyunúnéllii ímamyémú néé dííbyeke: —Ílluréjuco wallo íjtyéke íchííj pɨɨhɨ́rí íjcyájáhjɨ múnáadítyú tsíeménéuba ditye iñéhcone imájchóne iwáyéééveki. Muurá íñe ɨ́ɨ́néubárá íjcyátútsihyi meé. ");
INSERT INTO boaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Árónáacáhjáa Jetsóó néé diityéke: —Ámuháyé bo mémajchótsó diityékej. Áánélliihyéhjáa nééme dííbyeke: —Árónáa méhdi 5-hováré páahóónema míítyétsiye amóóbemútsi. Íhya ihdyu tsiiñe kémúúneúvú maáhdoca úújetéiyóné pámehdívúre. ");
INSERT INTO boaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ehdúhjáa ditye néérónáa neébe: —Méne ditye páhadsɨ́jɨ́ iáhcúba 50-mevátsa. Áijyúhjáa diitye 5,000-meváubáhjáa wajpíímúré íjcyaróme. ");
INSERT INTO boaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Áámekéhjáa ditye néhdújuco ditye áhcubáné páhadsɨ́jɨ. ");
INSERT INTO boaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Áánáacáhjáa Jetsóó teene páahóónema amóóbemútsikye iékéévéne téhdujtsó Píívyéébeke cáámevu icyárúúvénema. Átsihdyúhjáa idyóhdáhɨ́nunévú ájcuube ímamyémuke ditye iwájtu pámeekére. ");
INSERT INTO boaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aanéhjáa pámeere imájchónetu oovéhi. Áánetúhjáa cóeváné ujcúmé 12-rujtsívá úvérujtsíñe wáhpe. ");
INSERT INTO boaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Áhduréhjáa tsáijyu Jetsóó ímamyémudítyú tsátsihvu ipyééne Píívyéébema ihjyúváhi. Áijyúhjáa neebe diityéke: —¿Aca muubá o íjcyane mɨ́amúnaa óhdityu nehíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Áánélliihyéhjáa nééme dííbyeke: —Tsaate nehíjcyá tsojtsó múnáajpi Jóáa u íjcyane. Áánetu tsijtye nehíjcyá éíjyuúvúu íjcyame Píívyéébé ihjyú uubálle múnáaúvudítyú Eríá tsiiñe bóhɨɨbe u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Átsihdyúhjáa diityékeréjuco dibye nééneé: —¿Ácooca ámuha muubá o íjcyane menééhií? Áánélliihyéhjáa Péédoro nééhií: —Muurá, uu, Críjto Píívyéébe uke wálloobe mɨ́amúnáake u pájtyetétsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ehdúhjáa Péédoro néénetu bóíjcyuube ditye muucá iúúbállétuki. ");
INSERT INTO boaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Átsihdyúhjáa ɨdsɨ́jɨ́veíñé úúbálleebe nééhií: —Mɨ́amúnáájpidívúu o ípívyééveebe muurá ó ɨ́cúbáhráméií mítyane. Muurá túkevéjtsojtee, llúúvájté avyéjujtee, taúhbájú uwáábojtee, íjcyame oke ehdɨ́ɨ́válleéhi. Aame muurá oke dsɨ́jɨ́vétsóroobe 3 coojɨ́vatu tsiiñe ó bóhɨɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ehdúhjáa ímamyémuke iñééné boonétú neebe pámeekére: —Ahdícyane tsaate oke iúraavyéné ímillémé óvíi iímillédú iícyahíjcyánetu ɨɨ́hveténe oke úraavyé wájyúmeítyúmé tééné déjúcotu ɨɨ́cúbáhrámeíyóné pañe. ");
INSERT INTO boaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Muurá ííñújɨri iímillédú iíjcyáneríyé tsúúrámeímyé tsá pájtyetéityúne. Áánetu ihdyu teene ɨɨ́hvéjtsóne oke iúráávyéíñeríyéjuco tsúúrámeímyé pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Aca ɨ́ɨ́netú meke pɨ́áábóiyóné tsáijyu múu mewágóóóvénáa mítyane meéhneváne? ");
INSERT INTO boaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Muurá oke iúraavyéné núcojpɨ́llémeke téhdure ó núcojpɨ́lleé Mɨ́amúnáájpidívúu o ípívyééveébe. Áhdure táuwááboju tsíjtyeke iúwáábóiyóné núcojpɨ́llémeke téhdure ó núcojpɨ́lleé Llihíyó avyéjuri níjkyéjɨ múnáama tahñéjte éllevu o tsáácoóca. ");
INSERT INTO boaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Muurá ɨ́mɨááné ámúhadítyú tsáhái tsaate dsɨ́jɨ́véityú Píívyéébé avyéjú bóhówaavéné ájtyúmɨtúme. ");
INSERT INTO boaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Átsihdyúhjáa 8 coojɨ́vatu Jetsóó péé cáméhbaúvú Píívyéébema iíhjyúvaki. Aabéhjáa nahbévá Péédoroo, Jacóóboo, Jóáaá, éhdúmedívu. ");
INSERT INTO boaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aabéhjáa Píívyéébema íhjyúvánáa dííbye húmɨ́ tsíhdyúreevéhi. Áhduréhjáa íwajyámú tsɨ́tsɨɨnújá ajchúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Áánáacáhjáa Moitséemútsí Eríama bóhówáávemútsí ihjyúvá dííbyema. ");
INSERT INTO boaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aamútsíhjyáa téhdure cádiúcunúmútsí ihjyúvá dííbyema muhdú Jerotsaréevu ɨɨ́cúbáhrámeíñe dibye dsɨ́jɨ́véíñeri. ");
INSERT INTO boaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aanéhjáa Péédoro íñahbéjtétsima ɨ́htsútúnetu cuwáháñema íjcyame ájtyumɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aanéhjáa tsúúca Jetsóodítyú kiávú diityétsí Moitséemútsí Eríama péíñúné boone Péédoro néé dííbyeke: —Ávyéjuúbej, maímijyu ihdyu mee íchiij. Ahdícyane métsu meméénu 3-wava nújuwááné dihñéwaa, Moitsée éhwaa, Ería éhwaa, éhdune. Ehdúhjáa Péédoro iñééne tsá wáájácutú ɨ́veekí ehdu iñééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Áánáacáhjáa ojtso diityédívú níítyéné pañe iíjcyáneri íllityéme. ");
INSERT INTO boaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aaméhjáa tééné pañe íjcyánáa Píívyéébe nééhií: —Áánu muurá Hájchíwu mítyane o wájyuúbe. Áábeke ihdyu tsáma méllééboco. ");
INSERT INTO boaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ehdúhjáa Píívyéébe íhjyúvánáa ɨɨtécunúmé Jetsóó iiyéjuco íjcyáábeke. Aaméhjáa tsá muucá úúbálletú teéne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ááné boonéhjáa tsíjcyoojɨ téhbaútú ditye óómíñáa téhbaú déjúcotu mítyane mɨ́amúnaa Jetsóoke téhmehíjcyámé dííbyeke waatsúcúpejtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Áámedítyúhjáa tsaapi néé kéévánécoba dííbyeke: —Ávyéjuúbej, cána ihdyu óvíjyuco áánu hájchíwu apáábyéré íjcyáábeke duhjévaj. ");
INSERT INTO boaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Muhdú íhya naavéné dííbyé pañe íjcyaabe dííbyedi ɨ́cúbáhrahíjcyáhi. Ɨdáátsówu tsáijyu dibye wákyééhcoobe íhjyúcunúcooca íhjyútu uráhtsaba ichívyehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Áánéllii dímamyémuke ó neerá ditye óóma dííbyé pañétú iwáágóo dííbyeke. Árónáa tsá ditye píívyetétú iwáágoóne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Áánélliihyéhjáa Jetsóó néé diitye ímamyémuke: —¡Juhúú, muutéráhana ihdyu ámuuha Píívyéébeke cáhcujtsópityúme! Aane íñe ¿múhajchótá ámúhá muhdúrá o áábúcúne ámúhakye ó úwááboóhi? Ehdúhjáa diityéké iñééróne neebe dííbyeke: —Áyu cána ííllevu tsiva dááchikyej. ");
INSERT INTO boaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ahdújucóhjáa dííbye éllevu dibye tsájtyéébeke tsiiñe naavéné wákyéehcóne. Áánélliihyéhjáa Jetsóó néé dibye iíjchívye dííbyé pañétu. Ahdújucóhjáa dibye íjchívyéné boone tsúúca ímíjpyetéébé cááníma péé pevétsɨhjɨ́duréjuco. ");
INSERT INTO boaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Áijyúhjáa pámeere tétsihyi íjcyame ullévenú Píívyéébé ɨhtsútú iájtyúmɨ́neri. ");
INSERT INTO boaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Áánáacáhjáa Jetsóó tsiiñe néé ímamyémuke: —Ímíñeúvú mélleebúcunúcó ámúhakye o nééneé. Muurá Mɨ́amúnáájpidívúu o ípívyéévéébedívú tsaapi óhdivu ékéévétsoó ímítyúmeke. ");
INSERT INTO boaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ehdúhjáa dibye nééne ímamyémú tsá wáájácutú ɨɨná nééiyóné ehdu dibye nééneé. Tsáháhjáa tene ímíllémeítyú ditye wáájácúiyóne. Aaméhjáa nuhnévehíjcyá teene dííbyeke idíllóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Téijyúhjáa táhjájcatsímyé caabyé diityédítyú ɨ́ɨhtsútuube íjcyáíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Aanéhjáa iwáájácúne Jetsóó tsɨ́ɨ́ménéwúuke iújcúne diityéké nééhií: —Muurá íjtye tsɨɨméwuúmú ɨ́dátsó néémeke ɨ́ɨ́cuvémé ookéjuco ɨ́ɨ́cuvéne. Téhdure okée wállóóbekéjuco ditye ɨ́ɨ́cuvéne. Ahdícyane caabyé ámúhadítyú ɨdáátsóóbeúvú néébe muurá ɨ́ɨhtsútuúbe. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Áhduréhjáa tsáijyu Jóáa néé dííbyeke: —Ávyéjuúbej, muha máájtyumɨ́ tsaapi dimyémeri naavémuke wáágóohíjcyáné tsaaté pañétu. Áábeke muha menéé dibye tehdu imyéénújúcóótu ɨ́veekí tsíjpiiye íjcyaabe tehdu méénúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Árónáacáhjáa Jetsóó nééhií: —¿Ɨ́veekí ámuha mébóijcyúhi? Muurá meke pɨ́aabómé tsá meke tútávájtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aanéhjáa tsúúca níjkyejɨ́vú dibye pééíñe éévé pɨ́ɨ́hɨ́júcóónáa peebe ímamyémuma Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Áijyúhjáa tsaatéké wálloobe íúmɨ́wari ditye iñéhco tsátsii ditye cúwatéitsíi. Ahdújucóhjáa pééme Tsamááriá iiñújɨri íjcyáné jaaháñé néhcoróne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Árónáacáhjáa tétsíi múnaa tsá ímílletú ditye tétsii cúwane Jerotsaréevu ditye péénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Áánélliihyéhjáa Jacóóbomútsí Jóááma Jetsóoke nééhií: —Ávyéjuúbej, éhnéhjáa Píívyéébé ihjyú uubálle múnáajpi Eríaúvú cúújuwa táúmeídyú metsu metáúmeí Píívyéébeke dibye cúújuwa diityé hallúvú ɨɨ́jcaáyo cáámetu ditye iáíívyeki. ");
INSERT INTO boaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Áánélliihyéhjáa diityétsidívú ɨɨ́ɨ́téne neébe: —¿Aca ɨ́veekí eene ámuhtsi múhdurá méɨ́jtsámeíhi? ");
INSERT INTO boaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsáháa Mɨ́amúnáájpidívú o ípívyééveebe o tsáátu mɨ́amúnáake o tútávájtsoki. Ópée o tsáá diityéké o pájtyetétsoki. Ehdúhjáa diityéké iñétsihdyu pééme tsícyoomíwuúvu. ");
INSERT INTO boaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aaméhjáa péhíjcyánáa tsaapi juuvávyú Jetsóoke nééhií: —Ávyéjuubej, ó imíllé úúmaye o péhijcyáné kiávú u péhullévújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Áánélliihyéhjáa neébe: —Muurá iyámé íjcyarómé óówamu íhyéjúnema téhejújɨ́ pañe icyúwaki. Áhdure wahpéjté ijcyá icyúwáítsɨ́hjɨma. Áánetu íñe Mɨ́amúnáájpidívúu o ípívyééveebe tsá tahjyáúbamáyé o íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ehdúhjáa iñétsihdyu neebe tsáápiíkye: —Muúbej, óókéréjuco duráávye. Áánélliihyéhjáa neébe: —Ávyéjuúbej, óvíi ihdyu múijyú llihíyó óhdivu dsɨ́jɨvé botsíi uukéréjuco o úráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Óvi ihdyu tsamééré ɨ́mɨájɨ́jtó wáájácutúmé cúúújcatsí ɨdsɨ́jɨ́vécoóca. Áánetu ú úwááboó Píívyéébé avyéjutu íjcyáné uwáábojúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Áánetúhjáa idyé tsijpi néé dííbyeke: —Ávyéjuúbej, téhdure ó imíllé uukéréjuco o úraavyéne. Áánéllii tujkénú tahájkímuke ó pítyájcóteéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Áánélliihyéhjáa neebe dííbyeke: —Muurá múúne caajáíhcyú túkévéjtsoobe tsá kiá ɨ́ɨ́tetú caajáhó tsatújkeve pééiyóné ityútávájtsóíyónélliíhye. Ehdu nééne tsúúca Píívyéébé avyéjúejte íjcyarómé tsíñéhjɨríyé íjcyame tsá dííbyé avyéjúejte íjcyatúne. Ehdúhjáa diityéké Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ááné boonétúhjáa 70-meváké iújcúmeke wálloobe míítyétsícyutsáké pacóómivávú dííbyé ɨhde ditye iúwáábo mɨ́amúnáake. ");
INSERT INTO boaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Áámekéhjáa neébe: —Ɨ́mɨáánéjuco ávyétá mityámé mɨ́amúnaa Píívyéébé avyéjúejte ditye íjcyáíyóné uwááboju úwáábómeíiyóme. Árónáa tééné wákimyéi múnaa uwáábojte áyáhreé. Áánéllii ihdyu múu táúmeí páné aabájaabéré íjcyaabe Píívyéébeke dibye mítyámeke uwáábojtéké ipícyo ditye iúwáábo mɨ́amúnáake dííbyé avyéjúejte ditye íjcyáíñé uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ahdícyane íñe ámúhakye ó wallóó oohímye éllevu obééjáwuúmuke mewállóóiyódú muhdú ámúhakye dárɨ́ɨ́véímye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aame tsá ámuha metsájtyéityú ámúhá cahpámyuu, ámúha dsɨ́ɨ́dsɨɨ, ámúhá túhápaajɨ́nee, éhdune. Áhdure tsá ámuha juuvávú tsaatémá tsíñéhjɨri meíhjyúváityúne. Tsapéhdúré méúlleco. ");
INSERT INTO boaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aame ámuha tsájaavu meúújetécooca múu tééja múnáake nééhií: “A ámuha méíjcyaraj. Óvíi Píívyéébe ámúhakye pɨ́aabó ímí ámuha meíjcyaki.” ");
INSERT INTO boaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aane tééja múnaa ámúhakye ímí wáátsúcúpéjtsóhajchíí Píívyéébe ímí pɨ́ááboó diityéke. Áánetu ditye ámúhakye cátúhtsópéjtsóhajchíí múu ɨ́hvejtsó diityéké ɨɨná néétumére. ");
INSERT INTO boaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Áánetu ámúhakye ímí wáátsúcúpéjtsómé jari múu ijcyáhi. Tsá múu tsííjyatuu, tsííjyatuu, péétúne. Aane óvíi diityéké ámuha mepɨ́áábóne áhdó diityéré ámúhakye ájcúne tájpí ámuha méijcyáhi. Muurá wákimyéi múnáajpi íwákimyéi áhdó ujcúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aane ámuha tsácoomívú meúújetécóómi múnaa ímí ámúhakye iwáátsúcúne májchotsóné mémájchoco panéváré ámúhakye ditye ájcune. ");
INSERT INTO boaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aame mébóhɨ́ɨ́tsoco técoomí múnáadítyú chéméméhjɨke. Áhdure méúúbálleco tsúúca Píívyéébe avyéjúejte ditye íjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Áánetu tsácoomí múnaa ámúhakye wáátsúcútúhajchíí múu ulléjɨjtónéj pɨɨnévú iíjcyáne nééhií: “Íñe ámúhá cóómi ííñú múúháj tuhááñeri íjcyane ámúhadívú muha mépíchóújcámeí ámúhá hallúrí ímityúné íjcyáné uubálle. ");
INSERT INTO boaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Aame ihdyu óvíi muhdú ámuha méijcyáhi. Muurá Píívyéébé avyéjúejte ámúha méijcyájúcóóiyáhi.” Ehdu méneeco diityéke. ");
INSERT INTO boaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aane ámúhakye o néé ehdu ámúhakye dárɨ́ɨ́vémeke muurá Píívyéébe ávyétá ɨhnáhó ɨ́cúbáhraá muhdú mɨ́amúnaa ícyahíjcyáné iímíbájchócooca Tsodóóma múnáadi ɨɨ́cúbáhráíñé ehnííñevu. ");
INSERT INTO boaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Máɨdáátsoju tsáma tene pájtyeíñé Coratsíii, Betsáidaa, íjcyácoomícyu múnáake! Muurá íñe méénúráítyúronéhjɨ́ o méénuhíjcyánée Tííroó, Tsidóoo, íjcyácoomícyuvu o méénuca tsúúca íimítyú ɨɨ́hvéjtsóne ɨ́mɨánejcúvuréjuco ditye ɨ́búwáávéiyóne. Áánemáa muurá íatérééjahjɨ́vú iújcámeíñe bállííjyuri ávúhcúiyómé teene ɨɨ́hvéjtsóné uubálle. ");
INSERT INTO boaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Áánéllii muurá ditye ɨ́cúbáhrámeíñé ehnííñevu ɨ́cúbáhrámeíimye diitye Coratsíii, Betsáidaa, íjcyácoomícyu múnaa muhdú mɨ́amúnaa ícyahíjcyáné Píívyéébe nihñéétsihvúré ímíbájchócoóca. ");
INSERT INTO boaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ahdu muurá téhdure Capenaóo múnáake pajtyéiñe múhdumé ‘mityámítyá’ tsíñáávehíjcyámeke. ¿Ɨjtsúcunúméubá ɨɨ́htsútúúvéiyóne? Áánerá íllure wágóóóveímye. ");
INSERT INTO boaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ahdícyane múhdumé ámúhakye lléébome muurá ookéjuco lléébone. Áánetu ámúhakye lléébotúmé téhdure oke tsá lléébotúne. Aane oke illéébótúneri téhdure okée wállóóbeke tsá ditye lléébotúne. Ehdúhjáa Jetsóó diityéké túkévejtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aanéhjáa diitye 70-meváké dibye uwáábovu wálloome mítyane imíjyúú iúwáábójétsihdyu iwájtsɨ́neri. Aaméhjáa dííbyeke nééhií: —Ávyéjuúbej, muurá naavémú múúhakye lléébohíjcyá tsaaté pañe íjcyámeke dimyémeri muha meíjchívyétsócoóca. ");
INSERT INTO boaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Áánélliihyéhjáa neebe diityéke: —Éée, tehdújuco teene tsúúca páñétúejpi Naavéné íjcyároobe táhjátsámeíñélliíhye. Muurá ó ájtyumɨ́ éhne múúne chijchi rórihcyódú dibye íévéhóówatu áákityéne. ");
INSERT INTO boaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Muurá ámúhá pañévú ó picyóó tatsɨ́jpá tamyémeri ámuha diibye mémunáajpi Naavéneke metáhjaki. Áánéllii tsá ɨɨná ámúhakye tútávájtsóityúne. Téhdure ííñimyémuma óóvɨmu íjcyarómé tsá ámúhakye tútávájtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Árónáa ihdyu mémítyájkímyeídí tééneri eene naavémú ámúhakye ávyejúúlléneri. Múu imítyájkímyeíiyódú ɨ́ɨ́vane Píívyéébekéré mítyajtsó tsúúca ámúha mémeháñé dííbyé waajácúháámɨtu cáátúvánélliíhye. Ehdúhjáa diityéké neébe. ");
INSERT INTO boaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aanéhjáa Cááni Píívyéébé Apííchó Jetsóoke ímíjyuuvu ájcuube dííbyeke dúúrúvaabe nééhií: —Ayúju Táácááni Píívyéébeéj, níjkyejɨɨ, ííñujɨɨ, íjcyáné aabájaabe u íjcyaábej, uke téhdújtsoobéré ó duurúvá ɨ́mɨáájú ɨ́dáátsojtédívú u bóhówátsohíjcyáné hallúvu. Áánetu tehdújuco tsá waajácu múnaa iíjcyane ɨ́tsúcunúmeíhíjcyámedívú u bóhówájtsotú teéne. Ahdícyane ihdyu, Lli, óvíi ehdu teene muhdú u tújkevééllédu. ");
INSERT INTO boaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ehdúhjáa Cááníkye idyúúrúvátsihdyu neébe: —Muurá ihdyu Llihíyó oke picyóó tajtyééveri mɨ́amúnáake iwáájácútso muhdú diityédítyú ɨɨ́jtsámeíñe. Tsá muurá múha wáájácutú dííbyé Hajchi o íjcyáábé ɨ́jtsaméi. Apáábyéré diibye Llihíyó waajácú muhdú o íjcyane. Áhdure idyé apáábyéré ó waajácú muhdú dibye íjcyane. Áhdure teene tsaatédívú o bóhówajtsóméré waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ehdúhjáa iñétsihdyu ímamyémuke ɨɨ́ɨ́téne neébe: —Maímijyu ihdyu ámuha meíjcyane o méénuhíjcyáné ámuha maájtyumɨ́me. ");
INSERT INTO boaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Muuráhjáa éíjyuúvú Píívyéébé ihjyú uubálle múnáama ɨ́htsutúmé avyéjujte oke ɨ́tsohíjcyará íñe ícyooca muhdú o méénuhíjcyáné ámuha maájtyumɨ́dú iájtyúmɨ́roki. Áhduréhjáa imíllerómé o íhjyúváné illéébone. Árónáacáa tsáhái téijyu o bóhówáávetúne. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsáijyúhjáa tsaapi taúhbájú uwááboobe dííbyeke imújtátsóro nééhií: —Uwááboóbej, ¿aca muhdú ó íjcyáiyá múijyú o dsɨ́jɨvéjúcóóítyúne bóhɨ́ o újcuki? ");
INSERT INTO boaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Áánélliihyéhjáa neébe: —¿Muhdútá nééne taúhbajuj? ");
INSERT INTO boaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Áánélliihyéhjáa neébe: —Muurá nééneé: “Múu wajyú Dípiivyéébé Díavyéjuube íjcyáábeke ávyeta dɨ́ɨ́ɨ́búutúré páneere muhdú u íjcyáneri dɨ́ɨ́jtsaméiyi. Áhdure múu pamévakéré wajyú muhdú u wájyúmeídyu.” ");
INSERT INTO boaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ehdúhjáa dibye néénéllii Jetsóó néé dííbyeke: —Éée, tehdújuco. Ahdícyane óvíi tehdu ú ijcyá múijyú u dsɨ́jɨvéjúcóóítyúne bóhɨ́ u újcuki. ");
INSERT INTO boaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Áánélliihyéhjáa ityáhjátsámeítyu tsiiñe neebe dííbyeke: —¿Aanéhaca caatyéké ó wájyúiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Áánélliihyéhjáa idyé Jetsóó néé dííbyeke: —Tsaapíi Jerotsaréetu Jericóovu péébeke naní múnaa imyéénúne dííbye éhnénéhjɨ́ dojtú pɨ́rune íwajyámúúnemájuco. Áánemáa péjucóómé dibye tétsiíyé dsɨjɨ́veri íjcyánáaáca. ");
INSERT INTO boaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Áánáacáa llúúváábe tééjuri péébe úújeté dííbyedívu. Áróóbedíi ɨ́ɨ́cúvétuube pajtyéíñúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Áhdurée duurúvájá pañe wákímyeíhíjcyaabe péébe dííbyeke ájtyúmɨ́roobe pajtyé tsapéhdúré dííbyedi ɨ́ɨ́cúvétuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Áánetúu Tsamááriá múnáajpi péébe dííbyeke iájtyúmɨ́ɨ́bedi mítyane ɨ́dáátsovéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aabée ihdyu dííbyeke ditye túúvátsonéhjɨ́ ityáábóne bɨ́ɨ́jɨnúhi. Áábekée ɨɨ́ɨ́judi tsajtyéébé tsaaté javu tépejco ityéhmeki. ");
INSERT INTO boaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ááné tsɨtsɨ́ɨ́vevúu tééja múnáájpikye iáhdóne neébe: Áánúke téhmeco. Aane néhi tsiiñe tsíeméné dííbyema u áhdóhajchíí o óómidyu uke ó óómíchoóhi. Ehdúu méénuube Tsamááriá múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Aanée caabyé diityédítyú tsíjpiiye íjcyároobe naní múnaa ɨ́cúbáhraíñúúbeke wajyúhi? ");
INSERT INTO boaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Áánélliihyéhjáa neebe Jetsóoke: —Íhya eenée dííbyedi ɨɨ́dáátsóvéne pɨ́ááboóbe. Áánélliihyéhjáa neebe dííbyeke: —Tehdújuco. Ahdícyane óvíi tehdu ú meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ááné boonétúhjáa idyé Jetsóó ímamyémuma péébe úújeté tsácoomíwuúvu. Átsihyíhjyáa íjcyalle Mááta tsaímíyé diityéké ihjyávú waatsúcúpejtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Áijyúhjáa dííllé naalle Maaríá Jetsóó lliiñévú ácuuvé dibye úwaabóné illéébúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Áánáacáhjáa diille Mááta tsíñehjɨ imyéénúneri íjcyalle Jetsóoke nééhií: —Ávyéjuúbej, ¿ɨ́veekí aalle táñaalle íñe o méénúnéhjɨtu tsá oke pɨ́áábotúne? Díñe bo okéi dille ɨpɨ́áábokij. ");
INSERT INTO boaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Áánélliihyéhjáa Jetsóó néé díílleke: —¿Aca ɨ́veekí eene tsíñehjɨ u méénúneríyé ú ijyácunú táuwáábori ɨ́ɨ́cúvétulle? ");
INSERT INTO boaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Muurá ihdyu tehdújuco Maaríá méénune tsá múha díílledívú cátúhtsóítyuróne. Ehdúhjáa Jetsóó néé Máátákeé. ");
INSERT INTO boaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aabéhjáa tsáijyu Píívyéébema iíhjyúvánetu nɨ́jkévánáa tsaapi ímamyémudítyú néé dííbyeke: —Ávyéjuúbej, cána múúhakye duwáábó muhdú múúne Píívyéébema meíhjyuváné éhnéhjáa Jóáa ímamyémuke úwaabódu. ");
INSERT INTO boaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Áánélliihyéhjáa neébe: —Íllu múu íhjyúváhi: Múúháj Caáni níjkyéjɨri u íjcyaábej, uke muha máávyéjujtsó dúúrúvamére. Aabe ihdyu díavyéjuvu múúhakye dúúcúne u ímillédú múúhakye túkevéjtsó ííñújɨri muha meíjcyámeke muhdú níjkyéjɨri u méénuhíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aabe óvíi múúhakye majchóvú ú ácuhíjcyá paíjyuváré tééne tájpí muha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Áhdure muha ímityúné meméénuhíjcyáné múúhadi dɨ́dáátsóvéne dábajɨ́ɨ́vé múúhakye ímityúné méénuhíjcyámedi muha meɨ́dáátsóvéne teene maábájɨ́ɨ́véhijcyádu. Áhdure múúhakye ɨ́hvéjtsótuubéré pɨ́áábohíjcyá mávaríjchojúúnevu muha metáhjátsámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ehdúhjáa diityéké iñétsihdyu tsiiñe neébe: —Muurá tsaapi ámuha menáhbévahíjcyaabe tsáijyu pécójpɨɨne ámúhadítyú tsáápiikye neetéiyáhi: “Muúbej, cána okéi óvi daacu ámúha májchotu táñahbévaabe tahjyávú wájtsɨ́ɨ́beke o májchótsoki. Ávyeta tsá ɨ́ɨ́néúbamá o íjcyatúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ehdu dibye néénéllii ícyuwájá pañétú nééíyoobe dííbyeke: “Tsáhájuco o píívyetétú uke o ájcune. Tsúúca muha mécuwáhi. Tsúúcajáne llééhowa wátájcámeíhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ehdu muurá ámúhadítyú tsaapi íñahbéváábeke iñééróne ájcúiyá dibye táúmeíñevu éhnííñevúré dibye ipátsáríjcyótuki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ahdícyane ihdyu múu táúmeí Píívyéébeke tééne tájpí ámuha meíjcyane ámúhakye dibye iájcuki. Métsúúraméí ímí ámuha meíjcyáíyóneri ámúhakye dibye ɨpɨ́ááboki. Áhdure métáuméí ámúhakye dibye ityúkévéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Muurá tééne tájpí iíjcyane táúmeímyeke ájcuúbe. Ímí iíjcyáíyóneri tsúúrámeímyeke pɨ́ááboóbe. Dííbyeke túkevéjtsoju táúmeímyeke túkévéjtsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Aca ijcyámé tsaate ámúhadítyú ɨ́jtsɨɨméné majcho táúmeícyooca nééwayúvúré ájcúiyóme? ¿A amóóbeke tetsɨ táúmeíñáa ájcúiyómé ííñimyédívúre? ");
INSERT INTO boaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Áhdure ¿aca ííhyúu táúmeítsɨke ájcúiyómé óóvɨhódívúre? ");
INSERT INTO boaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Muurá ámuha mɨ́amúnaa ímityúmé meíjcyarómé méimíllé ámúháj tsɨ́ɨ́meke ɨ́mɨáánevúré maájcune. Aanéjɨ́ɨ́ awáá muurá ámúháj Caani níjkyéjɨri íjcyaabe Íapííchó picyóó dííbyeke teene táúmeímyé pañévu. Ehdúhjáa Jetsóó úwaabó ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Íjcyaabéhjáa tsaapi naavéné ípañe íjcyaabe íhjyúvátuúbe. Aanéhjáa naavéneke dííbyé pañétú Jetsóó wáágóóné boone tsúúca ihjyúvaábe. Ááneríhjyáa mɨ́amúnaa ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Árónáacáhjáa Jetsóodítyú tsaate nééhií: —Aadi muurá naavémuke waagóohíjcyá tsaaté pañétú diitye naavémú avyéjuube Betsebóó pɨ́áábóneríye. ");
INSERT INTO boaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Áhduréhjáa tsijtye dííbyeke íllure mávárijchómé nehíjcyá dibye méénúráítyuróné íévéhoowávú imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Árónáacáhjáa diityé ɨ́jtsaméí iwáájácúne neébe: —Muurá tsáné avyéjujte tsajɨ́jtóré ɨ́jtsámeítyúmé ímityúné idyárɨ́ɨ́véjcatsíñe ílluréjuco ɨ́hvejtsóné íavyéju. Áhdure muurá tsája múnaa ímítyú idyárɨ́ɨ́véjcatsíñe ílluréjuco wáchájánújcatsíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ahdu ɨ́ɨ́vane muurá Naavéné ihyájkímukéré íwáágóoca íllure íavyéjú újóvéjtsóiyáhi. Ehdu íñe ámúhakye o néé naavémú avyéjuubévá Betsebóó oke pɨ́áábóneríyé diityéké o wáágóohíjcyáné ámuha óhdityu menéénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Áánetúhaca ¿múúbé pɨááborí ámúhá mamyémú waagóohíjcyá diitye naavémuke? Áyu cána oke menej. Tsá muurá ámuha menééítyuró Betsebóó pɨáábori ditye wáágóohíjcyáne. Íllure ámuha mémujtá ehdu meíhjyúváneri. ");
INSERT INTO boaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Muurá ihdyu Píívyéébe oke pɨ́áábóneri ó waagóohíjcyá naavémuke tsaaté pañétú téénetu ámuha méwáájácu tsúúca dííbyé avyéjú ííñújɨri ámúhama íjcyájúcooróne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Muurá ɨ́htsútúúbé jatu tsá ɨɨná múha tsájtyéítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Árónáa dííbyé ehnííñevu íjcyaabe dííbyedítyú dójtúiyá páneere dííbyé méénujcátsiháñe. Ááne dííbyé tsíeméné iímillédú méénúíyoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ehdu nééne muurá oke ɨpɨ́aabóné ímílletúmé táwákimyéí íllure imíllé óhdivu ityútávajtsóne. Aame tahñéjté íjcyáíyómeke íllure óhdityu mútátsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Átsihdyúhjáa idyé tsiiñe Jetsóó nééhií: Muurá múúne naavéné mɨ́amúnáájpí pañétú íjchívyeebe pehíjcyá iíjcyáitsíí néhcoobére. Aabe iíjcyáíyotsíí iájtyúmɨ́túnéllii íllu ɨ́jtsámeíhi: “Tsiiñe ó óómií bɨwáábé pañévúré ópée o íjchívyéébé pañévu.” ");
INSERT INTO boaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ahdújuco muurá óómiibye ájtyumɨ́váné diibye ípyée iíjchívyéébeke imíwu peevéébé éhne múu jaa llíjyahdu néébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Áánéllii múúne nahbévaabe tsijtye 7-meváké éhnííñevu ímítyúmeke diityémá tsiiñe iúcááve dííbyé pañévu. Áábeke muurá ɨ́hdée ɨɨ́cúbáhráné ehnííñevu ɨ́cúbáhraábe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ehdúhjáa Jetsóó néénáa tsáápille mɨ́amúnááj pɨɨnétú kéévánécoba nééhií: —¡Maímijyu ihdyu diille ukée ɨtsɨ́ɨ́máváábeke píívyétsolle íjcyanej! ");
INSERT INTO boaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Áánélliihyéhjáa neébe: —Éée, tehdújuco. Áhdure ¡maímijyu Píívyéébé uwááboju cáhcujtsómé íjcyanej! ");
INSERT INTO boaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Téijyúhjáa mítyane mɨ́amúnaa píhcyaavé Jetsóodívu. Áámekéhjáa úwááboobe nééhií: —Ámuha muurá ícyooca íjcyáné mɨ́amúnaa ímityúme. Aame ¿ɨ́veekí ámuha méimíllé méénúráítyuróné o méénune ámuha oke mecáhcújtsómejɨ́ɨ́vari? Óvíi ihdyu Píívyéébé ihjyú uubálle múnáajpíi Jonáake pájtyedu nééne oke pájtyénetu ámuha méwaajácú diibyéjuco mɨ́amúnáake o pájtyetétsoobe o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Muuráhjáa dííbyeke muhdú tene pájtyénetu Níínibé múnaa waajácú ɨ́mɨáánéjuco Píívyéébe dííbyeke wálloóne. Ahdu muurá Mɨ́amúnáájpidívúu o ípívyéévéébeke tene pájtyénetu mɨ́amúnaa waajácuú dityée iímíjpyeténe ipájtyeté Píívyéébe oke wálloóne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aane muurá Píívyéébe mɨ́amúnaa muhdú ícyahíjcyáné ímíbájchócooca tsáápille tsííñé iiñújɨ múnáalle ámúhadívú néétsoó ámuha mecáhcútsohíjcyátunévu. Muuráhjáa tsíhyullétú tsaalle Tsaromóó uwáábó illééboki. Aallée muurá ímí cáhcujtsóhi. Áánáa ¿ɨ́veekí dííbyeúvú ehnííñevu o íjcyaabe o úwaabóné tsá ámuha mecáhcútsohíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Téhdure muurá Níínibé múnáaúvú ámúhadívú néétsoóhi. Muuráhjáa Jonáá diityéké úwaabóné icyáhcújtsóne ímíjpyetéme. Áánáa ¿ɨ́veekí dííbyeúvú ehnííñevu o íjcyaabe o úwaabóné tsá ámuha mecáhcútsohíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tsá muurá peete tsíeménevu maávohjácóítyuróne. Muurá ihdyu cáámevu íboohówátsihvu mépicyóó tene iájchúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ahdu muurá ámúhá hálluúúné peetédú nééneri ɨ́mɨáánéré ámuha meɨ́ɨ́téneri metsúúrámeíhajchíí téénetúré ámuha mébóhówaúcúnuúhi. Áánetu ímityúnéré ámuha meɨ́ɨ́téneri metsúúrámeíhajchíí téhdure téénetúré ámuha mébóhówaúcúnuúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Áánéllii téɨɨbúwá méíjcyaco ɨ́mɨáájú ámuha tsúúca mewáájacúné múhdurá meúráávyétuki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Muurá ténejcu wáájacúmé ímityúné méénújúcootúmé ɨ́ɨ́né imíjyaúréjucó íjcyane éhne múúne peete ájchúcunúnej tééveri meíjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ehdúhjáa Jetsóó úwáábóné boone paritséómuube dííbyeke tsajtyé ihjyávú imájchótsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aabéhjáa íhyójtsɨ níjtyámeítyuube májchóneri diibye paritséómuube ullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Ámuha muurá ámúhaj pi hállúre méímíbáchómeíhijcyáhi. Árónáa ámúhá ɨ́jtsaméí ímityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tsá muurá ámuha mewáájácúmeítyúne! ¿Aca tsá ámuha mewáájácutú téhdure méɨ́jtsaméí metéhmémeíiyóné méjpi menítyámeíhijcyádúre? Muuráhjáa ɨ́mɨáámé meíjcya Píívyéébe meke ípívyejtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Áánéllii múu íjpií, ɨ́ɨ́jtsaméii, íjcyane tehmé ímí iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Máɨdáátsoju ámuha paritséómuke tene pájtyeíñej! Muurá tehdújúcooro Píívyéébeke ámuha meɨ́ɨ́cúvehíjcyáné ámúha bájtsoháñeri. Árónáa ¿ɨ́veekí tsá ámuha meɨ́jtsámeítyú dííbyeke mewájyúíyóneri? Áhdure ¿ɨ́veekí tsá ámuha mɨ́amúnáama ímíñeúvú meíjcyatúne? Tsá muurá tsáneeríyé dííbyeke meúráávyéne tsiiñe meɨ́hvéjtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ahdícyane máɨdáátsoju ámúhakye tene pájtyeíñej! Muurá ámuha méimíllé pihcyáávejááné pañe íboohówátsɨhjɨ́ríyé meíjcyane. Áhdure ámuha méimíllé mɨ́amúnaa ámúhakye ávyejúúlléne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Áámeke ámúhakye taúhbájú uwáábojtémá máɨdáátsoju tene pájtyeíñej! Muurá ímityúmé ámuha meíjcyárómeke mɨ́amúnaa ɨ́ɨ́tehíjcyá pánehjɨ́dú ɨ́mɨáámeúvúdú éhne múúne níjkyéné pañe nehníwu néérone pánehjɨ́dú hallu imíwu meɨ́ɨ́tedu. ");
INSERT INTO boaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ehdúhjáa Jetsóó néénéllii taúhbájú uwáábojtédítyú tsaapi néé dííbyeke: —Uwááboóbej, ehdu aatyéké u nééneri múúhadívú ú wáájatsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Áánélliihyéhjáa neébe: —¡Téhdure ámúhakye ɨdátsó pajtyéiñe! Muurá ámuha íllure métúhútsohíjcyá mɨ́amúnáake ámúhá ɨ́jtsaméityúré ámuha meújcúné uwáábori. Muurá ámuha meíjcyarómé tsá tehdu meíjcyatú eene ámuha meúwáábohíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ahdícyane máɨdáátsoju ámúhakye tene pájtyeíñej! ¿Ɨ́veekí ámuha éíjyuúvúu Píívyéébé ihjyú uubálle múnáake ámúhá ɨhdé múnáaúvú dsɨ́jɨ́vétsohíjcyámé nijkyénetu diityéúvu náávé ménícyohíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ehdu ámuha meméénúnetu muurá méwaajácú ámúhá ɨhdé múnáaúvúu ícyahíjcyajɨ́jtóré ámuha meúraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Muurá Píívyéébe nééhií: “Ó pícyoó o túkévéjtsóneri ɨ́hdétújuco iwáájacúné úúbálléímyeke. Téhdure ó pícyoó uwáábojtéke. Áámedítyú muurá tsaatédí ɨ́cúbáhraímye. Tsíjtyeke dsɨ́jɨ́vétsoímye.” Ehdúu Píívyéébe nééhií. ");
INSERT INTO boaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aane muurá téhdure ícyooca íjcyáné mɨ́amúnáake dómájcoó ííñujɨ́ɨ ípívyéévétsihdyu ícyoocávú Píívyéébé ihjyú uubálle múnáake tsaate dsɨ́jɨ́vétsohíjcyáné dibye diityémá ímíbájchoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Muuráhjáa Abéeke íñahbéré dsɨ́jɨ́vétsóné boone tsíjtyeke ámúhá ɨhdé múnáaúvú dsɨ́jɨ́vetsóhi. Muuráhjáa Tsacaríake dsɨ́jɨ́vetsómé duurúvájama Píívyéébé ɨɨcúvé cóvátsómeíhíjcyáné waɨ́jɨ́ ráhoúcunútsihvu. Aane ámúhakye o néé íñe ícyooca íjcyáné mɨ́amúnáake téhdure tééné ímibájchó dómájcoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ahdícyane máɨdáátsoju ámúhakye tene pájtyeíñej! Muurá ɨ́mɨáájú mɨ́amúnaa wáájácúiyóné ¿ɨ́veekí ámuha métúhútsohíjcyá tsíhdyuréjuco meúwáábóneri? Ditye teene icyáhcújtsóne úráávyéiyóné ámuha métúhútsohíjcyáhi. Aane muurá ámuha meíjcyarómé tsá ímíñeúvú teene meúráávyetúne. ");
INSERT INTO boaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ehdúhjáa Jetsóó íhjyuváné taúhbájú uwáábojtémá paritséómuke tsaríwu pajtyéhi. Aaméhjáa dííbyeke panévatu dilló tsane dibye múhdurá áñújcúhajchíí dííbyedítyú ímityúné iíhjyúvároki. ");
INSERT INTO boaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Téijyúhjáa ávyétá mityáné mɨ́amúnaa píhcyaavémé wájócójcatsíñáa Jetsóó néé ímamyémuke: —Téɨɨbúwá méíjcyaco aatye paritséómú bañú múnaa ɨ́mɨáámeúvúdú íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Muurá téévéneúvú méénúmeíyóné tsá tétsihvúré nɨ́jkéváityúne. Muurá pámeere ɨɨná méénuhíjcyáné bóhówááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Múha wáájácútúnáa ámuha mɨ́jcóhó pañévú meíhjyúvaróné waajácúméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ámuúha táñahbémuj, tsá múu íllityétú mɨ́amúnáadi apááñéré méjpi dsɨ́jɨ́vétsóíyómedi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Áánetu ihdyu múu íllityé Píívyéébedi múijyú ámuha meíjchívyéítyuwa cúújúwá pañévú ámúhakye wáágóóíyóóbedi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Muurá 5-meva coomɨ́mú mɨ́jɨ́hwuúcúré áhdómeíyómeke téhmeébe. ");
INSERT INTO boaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aabe muurá téhdure waajácú ámúhá níwáujɨ́ɨ́né múhdújɨvá íjcyane. Áánéllii tsá múu ɨ́ɨ́nerí íllityétúne. Muurá diitye coomɨ́mú ehnííñevu ámuha méwajyúmeíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Muurá Mɨ́amúnáájpidívúu o ípívyéévéébeke iúraavyéné tóónútúmeke ó bóhówájtsoó níjkyéjɨ múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Áánetu íllure tóónuhíjcyámeke tsá o bóhówájtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Muurá íñe Mɨ́amúnáájpidívúu o ípívyéévéébedítyú ímityúné íhjyúvárómedi Píívyéébe ɨɨ́dáátsóvéne teene ábájɨɨvéhi. Áánetu ihdyu dííbyé Apííchotu ímityúné íhjyúvámedi tsá dibye múijyú ɨ́dáátsóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ehdúhjáa iñétsihdyu neébe: —Tsaate ámúhakye pihcyáávejááné tehméjtema ámúhá iiñújɨ́ avyéjujté éllevu tsájtyécooca tsá múu íjyácunútú muhdú iíhjyúváíñeri. ");
INSERT INTO boaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Muurá ihdyu Píívyéébé Apííchóré ámúhakye túkévéjtsoó ámuha meíhjyúvaki. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Téijyúhjáa tsaapi mɨ́amúnááj pɨɨnévú néé dííbyeke: —Ávyéjuúbej, táñáhbeke diñe dibye oke idyówajcáro múhtsí wáábyuta múhtsíj caani pícyohíjcyánetu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Árónáacáhjáa Jetsóó néé dííbyeke: —¿Aca múha oke picyóó téeméné ímibájchoobe o íjcyaabe ámúhtsikye o dówajcároki? ");
INSERT INTO boaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsá múu mítyane iéhnéváíyóneri úmúúpívyetúne. Tsá muurá mítyane meéhnéváne tájpí tsaímíyé meíjcyáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ehdúhjáa dííbyeke iñééné boonétú pámeekéré iúwaabóné úúbálleebe ehnéva múnáájpidítyu. Íllúhjáa neébe: —Íjcyaabée tsaapi ehnéva múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Áábe bájtsoháñée mítyane néévánetu íllu ɨ́jtsámeííbye: “¿Aca kiávú íñe ó aahɨ́vétsoó tabájtsó áyánejɨ́ɨ́vari?” ");
INSERT INTO boaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Árónemáa neébe: “Óubá éhne teene ááhɨ́vétsámeíhíjcyaja o wácávyáhcóne éhnííñevu mítyájácoba o áméjtsójá pañévú ó pícyoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ááne íllu ó ɨ́jtsáméiíhi: Ícyooca ihdyu tsá ɨɨná óhdityu pɨ́htotúne. Áánéllii pevétaréjuco ɨ́búwajɨ́ɨ́ o íjcyaíñé óhdityu o májchoíñé, o ádoíñé, pɨ́htójúcóótúnélliíhye.” ");
INSERT INTO boaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ehdúu dibye ɨ́tsámeíhíjcyárónáa Píívyéébe néé dííbyeke: “Tsá mɨ́a u wáájácúmeítyúne. Muurá ípyejco tsúúca ú dsɨ́jɨ́veéhi. ¿Ácooca eene u éhnévahíjcyánécoba muhdúíhyaja?” ");
INSERT INTO boaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ehdu muurá pajtyéiñe íhdyunéré éhnévahíjcyámema. Aame Píívyéébedívú ɨ́dátsóhreé. ");
INSERT INTO boaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ehdúhjáa diityéké iñétsihdyu Jetsóó néé ímamyémuke: —Tsá múu apááñeríyé ɨ́jtsámeítyú ɨ́ɨ́ne tájpí iíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tsá apááñéré majchoo, wájyamuu, íjcyáne tájpí meíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cáhawáá méɨjtsúcunu muhdú wahpéjté íjcyane. Tsá muurá ditye múijyú wákímyeítyú tééne tájpí iíjcyaki. Pane tsá ditye imájchó pícyootúne. Árome ijcyá Píívyéébe tájpi. Aanéjɨ́ɨ́ muurá diityé ehnííñevu ámuha mɨ́amúnaa méwajyúmeíhi. Áámeke tsá ámúhakye dibye ɨ́ɨ́netú pɨ́htótsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Aca íjcyaabe tsaapi ámúhadítyú éhnííñevu icyáámenúné ímílleebe iiye cáámenútsámeííyoóbe? Tsáhaá. ");
INSERT INTO boaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Muurá tsane túhúúturóné tsá ámuha meméénúítyuróne. Aanéjɨ́ɨ́ tsá múu ɨ́jtsámeítyú tsane imyéénúiyóné ámuháyé mepíívyetéíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Téhdure cáhawáá méɨjtsúcunu wajcóháñé múhdutú iiye tsaímíyé píívyehíjcyáné pevétáré íjcyaróne. Muuráhjáa ávyéjuube Tsaromóoúvú tsijtye ávyéjujté ehnííñevu íjcyáróóbé avyéjú wajyámu ímí tsá úújetétú teene wajcóháñe ímivu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ehdu muurá Píívyéébe tsaímíyé téhmehíjcyá wajcóháñé wahájchotáré iímí íjcyane íllúhwuúré tsúúca chémene. Aabéjɨ́ɨ́ awáá muurá ámúhakye éhnííñevu tsaímíyé téhmehíjcyáhi. Ehdu teéne, ámuúha cáhcujtsópítyúné mɨ́amúnaaj. ");
INSERT INTO boaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ehdu nééne tsá múu áábímyeítyú tééne tájpí ámuha meíjcyane tsáijyu ámúhadítyú pɨ́htórónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Muurá ihdyu Píívyéébeke cáhcújtsotúmé áábímyeí ɨpɨ́htócoóca. Árónáa muurá ámúháj Caani Píívyéébe waajácú ɨɨná ámúhadítyú pɨ́htone. ");
INSERT INTO boaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Áánéllii múu ámuha mepɨ́htóróneri ɨ́ɨ́cúvetúmé tsúúrámeí múhdutú tsaímíyé Píívyéébeke iúráávyéne dííbyé avyéjuvu iúcáávéíyóneri. Áijyu ihdyu tsá ámúhakye dibye ɨ́ɨ́netú pɨ́htótsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Muurá ámuha tahñéjté ɨ́dátsó éhne múúne obééjámú áyáméwu íjcyadu. Árome tsá múu ɨ́ɨ́nerí áábímyeítyúne. Muurá ámúháj Caani Píívyéébe imíllé ámúhakye iújcune íavyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Áánéllii múu ámúhá tsíeméné iñáhjɨ́hénúne pɨ́aabó ɨ́dáátsóméhjɨke. Muurá íñe ííñújɨri múhajchótá íjcyáityúné ámuha meéhnéváne tsaímíyé meícyahíjcyádú nééne ijcyá níjkyéjɨri múijyú muhdú íjcyáityúmé ámuha meíjcyaíñe. Téhulle muurá meíjcyane tsá tútáváávéityúne. Muurá ííñújɨri naní múnaa ámúhakye tútávátsohíjcyádú nééne tsáhájuco téhulle íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Muurá kénejcú éhnííñevu ímí ámúhakye pájtyénéjcuríyéjuco ámuha meɨ́ɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ahdícyane ímíñeúvú meíjcyátsííívyéne oke météhmeco éhne múúne ávyéjuube tsaatétsí táábávájcatsíñé wañéhjɨri íjcyáábeke íúníu múnaa téhmehíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Muurá múúne téhmehíjcyámé dibye llééhówatu díllóvácooca ɨ́ɨ́cúi ipááyúcuki. ");
INSERT INTO boaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ehdu muurá íavyéjúúbe ɨ́jtsóré íjcyámedívú dibye wájtsɨme ɨ́ɨ́né imíjyaú ijcyá dííbyema. Muurá iwájtsɨdu tsaímíyé diityéké imájchótsómema nahbévájcatsííbye. ");
INSERT INTO boaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maímijyu ihdyu ditye íjcyane tsáijyu múu pécójpɨɨnéuba mityá cóójɨ́háñé pañévú tsáároobe tsaímíyé dííbyeke téhmehíjcyámeke dibye ájtyumɨ́váme. ");
INSERT INTO boaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Muurá tsája múnáajpi múijyú naní múnáajpi tsááiñe iwáájácuca cúwátuube ihjya téhméjá pañévú tsá dibye úcáávéítyuró iñániki. ");
INSERT INTO boaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ahdícyane meíjcyátsííívyéne méɨ́tsohíjcyaco o tsááiñe. Muurá ámuha meɨ́jtsámeítyúnáa Mɨ́amúnáájpidívúu o ípívyééveebe tsiiñe ó tsaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ehdúhjáa Jetsóó néénéllii Péédoro néé dííbyeke: —Ávyéjuúbej, ¿a múúhakyéré ú úwáábohíjcyaj, mityá pámeekérej? ");
INSERT INTO boaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Árónáacáhjáa tsiiñe neébe: —Muurá tsaapi tsaímíyé íavyéjúúbema wákímyeííbyeke pícyoobe ihyájkímú tehméébedívu. Aabe muurá diityéké ímí ɨ́ɨ́cuvé ɨ́ɨ́né tájpí ditye íjcyáíñéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ahdícyane maímijyu dibye íjcyane íwákimyéiyi íjcyáábeke íavyéjuube ájtyumɨ́vaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Muurá ɨ́mɨááné ámúhakye o néé ɨ́mɨáábé íjcyáábeke íavyéjuube ihñévú téhmetsóne. ");
INSERT INTO boaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Áánetu íjcyaabe tsaapi ímítyuube íavyéjuube ‘ɨ́ɨ́cúi óómíityúné’ iñééne íwákimyéí ɨɨbúwá íjcyátuúbe. Ehdu néébe muurá íllure ihyájkímuke imyéénúne iímillédú wañéhjɨ́neríyé pehíjcyá llíyíícyáveebére. ");
INSERT INTO boaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aabe muurá ehdu ícyahíjcyánáa íavyéjuube óómiibye tuvááová dííbyeke dibye ɨ́jtsótúnáaáca. Áábeke ílluréjuco dibye ɨ́cúbahráné tsaate íwákimyéi múnaa ímítyúmeke imyéénudu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ehdu muurá íavyéjuube íúníu múnáake ɨ́cúbahrá dibye ímillédú dííbyé wákimyéí imyéénúiyóné wáájácurómé tehdu méénútúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Áánetu iwáájácútúné hallúríyé ímityúné méénúmeke ɨhtsútáré ɨ́cúbáhraábe. Muurá mepɨ́áábómedi méijyácunú ímí ditye íjcyáíyóneri. Áhdure tsíeménevu meníwáávémedi méijyácunú ímí ditye téhméíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Muuráhjáa ííñujɨ́vú o tsáá táhallútú mɨ́amúnaa itsárílléjcatsíki. Aane ihdyu múhdutúiyó tééné pañéjuco meé. ");
INSERT INTO boaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Muurá o ɨ́cúbáhrámeíñé nɨ́jcáutu ó dsɨ́jɨ́veéhi. Aane ávyeta múhduúvúrá ó ɨjtsúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Aca ámuha méɨjtsúcunú tsaímíyé mɨ́amúnaa iíjcya o tsááne ííñujɨ́vu? Muuráhjáa ihdyu o tsáá mɨ́amúnaa tsajɨ́jtóré ɨ́jtsámeítyúmé táhallútú itsárílléjcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aane muurá ícyoocátú tsané múnaa íjcyarómé tsarílléjcátsií táhallútu. Muurá tsaatédítyú ímunáajte oke cáhcújtsóhajchíí tsaatétsí cáhcújtsótumútsí tsarílleé diityéke. Áánetu diityétsíyé cáhcújtsóhajchíí ímunáajte tsarílleé diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Muurá cááni tsarílleé íllíkye oke dibye cáhcújtsóné hallútu. Áhdure ílli tsarílleé cááníkyeé. Áhdure ɨ́dsɨ tsarílleé tsɨ́ɨ́juke. Áhdure tsáápille íaajáké tsarílleéhi. Ehdu muurá panéjcuvávú mɨ́amúnaa tsarílléjcátsií táhallútu. ");
INSERT INTO boaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Téhduréhjáa tsiiñe Jetsóó néé diityéke: —Muurá ámuha nuhba áábatéhíjcyánéjcutu ojtso bóhówáávécooca menéé maálleíñe. Ahdújuco tene állene. ");
INSERT INTO boaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Áhdure tsíñejcútú kííjyeba tsáácooca ámuha menéé píjcyaba íjcyaíñe. Ahdújuco tene íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ehdu muurá ɨ́mɨáámeúvúdú ámuha méwaajácú muhdú néijyu muhdɨ́ɨ́vané cóójɨ íjcyaíñe. Árome ¿ɨ́veekí tsá ámuha mewáájácutú okée iwálloone Píívyéébe páhduváré nénehjɨ imyéénúneri ámúhakye úúballéjúcohíjcyaróne? ");
INSERT INTO boaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Ɨ́veekí tsá ámuha meɨ́jtsámeítyú ɨ́mɨáámé ámuha meíjcyáíyóneri? ");
INSERT INTO boaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tsaate múu ámúhadítyú ímítyunéhjɨ́ ditye ímíbájchóhullévú tsíjtyeke tsájtyéhajchíí ímíñeúvú cánáájánújcatsí téhullévúi iúújetétúné ɨhde ávyéjujtédívú ámuha mecúvéhoojánútsójcatsítyuki. ");
INSERT INTO boaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tsá muurá cúvéhóójatu ámuha meíjchívyéítyuró páneere ámuha maáhdótúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Téijyúhjáa tsaate Jetsóo éllevu ipyééne úúballé Píívyéébeke ɨɨ́ɨ́cúvéné iyámeke ditye dsɨ́jɨ́vétsohíjcyáhajtsɨ́vú Piráátó tsaate Gariréa múnáadívú llííhyánútsómé tujpácyó iyámé tujpácyoma mújtane. ");
INSERT INTO boaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Áámekéhjáa neébe: —¿Aca ámuha méɨjtsúcunú ehdu diityéké tene pájtyene tsíjtyé ehnííñevu ímityúmé ditye íjcyánélliíhye? ");
INSERT INTO boaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Muurá téhdure ámuha pámeere méɨ́cúbáhráméií diityédúré ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne Píívyéébé icyánejcúvú meɨ́búwáávétúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ácooca ¿muhdú ámuha méɨjtsúcunú Jerotsarée múnáadítyúu 18-meváké ‘Tsiroée’ némeíñé nupáhyéjú úníuri íjcyaja cáámé cóhnaúvú nééja áámune? ¿A dityée éhnííñevu ímityúmé íjcyánéllii aamúné diityéke? ");
INSERT INTO boaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Muurá téhdure ámuha pámeere méɨ́cúbáhráméií diityédúré ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne Píívyéébé icyánejcúvú meɨ́búwáávétúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ehdúhjáa Jetsóó iñétsihdyu tsiiñe diityéké úwááboobe nééhií: —Tsaapíhjyáa íúmɨhé pañétú higyéérahe ibájtsohe néévápítyuhe úújéjehíjcyaráhi. ");
INSERT INTO boaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Árónemáhjáa tééné tehméébeke neébe: “Tsúúca 3 pijcyábájuco íhye tsá néévápityúne. Áánéllii ílluréjuco dihllo. Báñú úmɨhé pañétú teéhe.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Árónáacáhjáa tépallí tehméébé néé dííbyeke: “Ávyéjuúbej, cána óvíi íñé pijcyábá méɨ́jtsoráhi. Óvíi ó wápɨ́jcoó tehe iñéévaki. ");
INSERT INTO boaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsáijyu múu tehdu meméénúneri néévahe. Tehe néévátúhajchíí botsíi ílluréjuco meílloíñe.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Áhduréhjáa tsáijyu wáyeéévejcóójɨ́ úwááboobe pihcyáávéjá pañe íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Áánáacáhjáa tétsihyi tsáápille naavéné ípañe íjcyalle 18 píjcyájuco íbájui ipátúúvétúneri chémehíjcyalle. ");
INSERT INTO boaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Áállekéhjáa Jetsóó ɨpɨ́úváne nééhií: —Tsúúca ú bohɨ́jucóóhi, muúllej. ");
INSERT INTO boaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ehdúhjáa néébere díílleke dócárájcónetu ɨ́mɨááné tsúúca íbájui pátúúvelle íjyócuuvé tsatújkevéjuco. Aalléhjáa duurúvá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aanéhjáa pihcyáávéjá tehméébeke tsárí pajtyé ɨ́veekí wáyeéévejcóójɨ́ dibye díílleke bóhɨɨtsóne. Aabéhjáa tétsii íjcyámeke nééhií: —Muurá ijcyáné 6 coojɨ́vá wákimyéíjcyoojɨ́jɨ. Ájcoojɨ́jɨ́ ámuha métsááiyá dííbye éllevu dibye ámúhakye ibóhɨ́ɨ́tsoki. Tsá wáyeéévejcóójɨ́ ámuha dííbye éllevu metsááítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ehdúhjáa dibye néénéllii Jetsóó néé dííbyeke: —Bañú múnáajpi u íjcyaabe pánehjɨ́dú ɨ́mɨáábeúvúdú uú. ¿Aca tsá wáyeéévejcóójɨ́ íjcyaróné ámúha jéémú dóhjɨ́vámeke ámuha meíjchotéítyuró téhí pañétu? ");
INSERT INTO boaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ehdu nééne muurá áámye téhdure Aavaráaúvúj tsɨɨménémúháábéelle íjcyalle ɨ́dátsó chémehíjcyá 18 píjcyájuco naavéné ípañe íjcyaabéré díílleke tehdu méénúneri. Áálleke ¿aca tsá mepɨ́áábóítyuró wáyeéévejcóójɨ́ íjcyaróne? ");
INSERT INTO boaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ehdúhjáa dibye nééneri pámeere dííbyeke múnáátsohíjcyámé núcójpɨvéhi. Áánetúhjáa ihdyu tsijtye mítyane ímíjyuuvé dibye díílleke pɨ́áábóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Téhduréhjáa Jetsóó néé diityéke: —¿Aca ɨ́ɨ́netú íñe tsiiñe ámúhakye ó úwááboó Píívyéébé avyéju? ");
INSERT INTO boaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Muurá dííbyé avyéjú éhne múúne mojtáátsá neeváú kémúútúróúwu mebájtsou mítyáhécoba kéémevédu. Aahe muurá wájcáváné hallúvú wahpéjté pɨ́htobáhi. Ahdu muurá teene Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Téhduréhjáa neébe: —¿Aca ɨ́ɨ́netú íñe tsiiñe Píívyéébé avyéjú ó úwáábóiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Muurá tsáápille haríínállíjyutu pááa imyéénúcooca áyánéwu tééné ooríchotu pícyooróné páneeréjuco óórichódú teene Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aanéhjáa Jetsóó Jerotsaréevu péébe juuváyí íjcyácoomíjɨ múnáake úwááboobéré pehíjcyáhi. Áhduréhjáa patsɨ́hjɨvárí íjcyájáhjɨ múnáake úwááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Áábekéhjáa tsaate nééhií: —Ávyéjuúbej, ¿a uhjéméré pájtyéteéhi? ");
INSERT INTO boaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Áánélliihyéhjáa neébe: —Ɨ́hnáhó íuráávyé néérojɨ́jtó múu úraavyé Píívyéébé avyéjuvu ámuha meúújetéijɨ́jto. Muurá mítyame imíllerá iúcaavéné téénevu. Árome tsá úcáávéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Muurá téɨɨbúwájɨ́ néétume áachi iímillédú íjcyámé hallúvú ávyéjuube ihjyá lleehówá wátaahácoóhi. Ááné boone llééhowa wátótóhcoméré neéhi: “Ávyéjuúbej, múúhakye paayúcu.” Árónáa nééiíbye: “Tsá ámúhakye o wáájácutúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Áánéllii neeímyé dííbyeke: “Áánerá úúma tsaméhjɨ́ mémáchohíjcyáhi. Áhdure muurá múúhá comíñeri úwááboobéré ú pehíjcyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ehdu ditye néérónáa nééiíbye: “Muuráhjané ámúhakye o néé ámúhakye o wáájácutúne. Ahdícyane méɨɨne óhdityu ímityúmé ámuha meíjcyame.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ehdu Píívyéébe waagóoó dííbyeke cáhcújtsótúmeke. Aame kémuélletúré ɨ́ɨ́teé Píívyéébé avyéjuri dííbyé ihjyú uubálle múnaa Aavaráaa, Itsáaa, Jacóóboo, íjcyámeke. Áijyu ílluréjuco ditye tááiñe íhwáñe ɨɨ́hdónema. ");
INSERT INTO boaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ehdu waagóojtéréjuco íjcyánáa pahúllevátú tsijtye ímí Píívyéébeke cáhcujtsómé dííbyedívú píhcyááveé dííbyema iíjcya íavyéjuri. ");
INSERT INTO boaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Áijyu muurá íñe ícyooca ɨdáátsóméhjɨúvú nééme ávyéjúúteéhi. Áánetu ɨ́htsutúmé ícyooca íjcyarómé téijyu ɨ́dáátsónuúhi. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Téijyúhjáa paritséómú tétsihvu wájtsɨme néé dííbyeke: —Dípye íchihdyu tsiéllevu. Muurá Heróódé imíllé uke ɨdsɨ́jɨ́vetsóne. ");
INSERT INTO boaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Áánélliihyéhjáa neebe diityéke: —Mepééne dííbyeke ávyétá muubérá íjcyáábeke mene: “Óvíikyévá ihdyu nɨjkévaabe naavémuke tsaaté pañétú iwáágóóne chéméméhjɨke ibóhɨ́ɨ́tsohíjcyánetu.” ");
INSERT INTO boaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tsá muurá Píívyéébé ihjyú uubálle múnáajpi dsɨ́jɨ́véítyuró Jerotsaréé tsiéllevúre. Óvíi ihdyu múhajchótá ó ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ámuúha Jerotsarée múnaaj, ihdyújuco tsáma ¿ɨ́veekí ámuha íllure mellííhyánúpétsohíjcyáné íhjyú uubálle múnáake Píívyéébe ámúha éllevu wállóórómeke? Uwáábojtéké dibye ámúha éllevu wállóórómedi ¿ɨ́veekí íllure ámuha méɨ́cúbáhrahíjcyá néwayúúnevu maáámúneri? Muurá ó imíllerá ámúhakye o újcune éhne múúne cáraca ɨ́ɨ́tsɨ́ɨ́méwuúmuke íhñúwáácyú lliiñévú újcudu. Árónáa ¿ɨ́veekí tsá ámuha meímíllehíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ááné déjúcotu muurá ámúha cóómí ápajyúréjuco cóévaíñe. Áhdure ámúhakye o néé oke ámuha maájtyumɨ́júcóóityúné múijyú tsiiñe o tsááiñévújuco. Téijyu muurá ámuha oke maájtyúmɨ́ne méneéhi: “Maímijyu áánu Píívyéébe mémeri tsááneéj.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsáijyúhjáa idyé wáyeéévejcóójɨ́ Jetsóó péé paritséómú avyéjúúbe jávú dííbyema imájchoki. ");
INSERT INTO boaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Áábekéhjáa diitye paritséómú hállúváábohíjcyá tétsihyi íjpi óóríñeri chémeebe íjcyánéllii ‘áádikye éhne íjcyoojɨ bóhɨ́ɨ́tsóiíbye’ iñéénema. ");
INSERT INTO boaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aaméhjáa taúhbájú uwáábojtémá íjcyámeke neébe: —¿A wáyeéévejcóójɨ́ tsaapi chéméébeke mébóhɨ́ɨ́tsóiyáhi, mityá tsáhaáj? ");
INSERT INTO boaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ehdúhjáa dibye néérónáa tsá ditye ɨɨná néétune. Aanéhjáa awáá tsúúca diibye íjpi óórííbyeke ibóhɨ́ɨ́tsóne neebe ílluréjuco dibye ipyéékií. ");
INSERT INTO boaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Átsihdyúhjáa neebe diitye paritséómuke: —¿Aca ámúhá ocájí ámúha ɨ́ɨ́júuba wáyeéévejcóójɨ́ wáhyéjú pañévú áákityéébeke tsá ámuha meújcúítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ehdúhjáa dibye nééne tsá ditye píívyetétú muhdú iáñujcúne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Áhduréhjáa tsáijyu wañéhjɨvu tsaate míñutsómé imíllé íboohówátsɨhjɨ́vúré iácuuvéne. Aanéhjáa Jetsóó múhdurá ɨɨ́jtsúcunúne diityéké úwááboobe nééhií: ");
INSERT INTO boaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Tsaate múu ámúhakye ityáábávájcatsíñé wañéhjɨvu míñútsócooca tsá ɨ́hdére ácúúvetú íboohówátsihvu tsáijyu múúne tsijtye ámúhá ehnííñevu ávyejúúmé wájtsɨ́mekéréjuco ditye tétsihvu ácújcóné boone íatéréétsihvúréjuco ámuha maácúúvéneri menúcójpɨ́vétuki. ");
INSERT INTO boaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Áánéllii múu tsaate íwañéhjɨvu ámúhakye míñútsócooca úújeté ihdícyátsihvúré diitye wañéhjɨ múnaa ámúhakye iájtyúmɨ́cooca íboohówátsihvu iácujcároki. Áijyu ihdyu tsá ɨ́ɨ́nerí ámuha menúcójpɨ́vétsámeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Muurá iiye ɨ́htsutúmé ávyéjujte iíjcyane némeíhijcyámé núcójpɨ́vétsáméiíhi. Áánetu ɨdáátsóméhjɨúvú tsaɨ́ɨ́buwáré íjcyame ávyéjúúteéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ehdúhjáa diityéké iúwáábótsihdyu neebe dííbyekée íwañéhjɨvu míñútsóóbeke: —Tsá múu majchóvú míñútsotú ɨ́htsútúméhjɨkéré uke ditye pɨ́ámeíiñe u ímíllénélliihyére. Téhdure tsá múu míñútsotú dihyákímudúnéré múhdumé tsijtye úúma náhbévahíjcyámekére. ");
INSERT INTO boaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Múu téhdure míñutsó ɨ́dáátsóméhjɨke íjpíítyu tsátsɨhjɨ íjcyátúróméhjɨma hállúvátúméhjɨke ámúhakye ditye pɨ́ámeíiyóné ɨ́jtsámeítyúmére. Muurá Píívyéébere ámúhakye áhdoó dibye ímillédú ámuha meíjcyame medsɨ́jɨvémé tsiiñe mebóhɨ́ɨ́coóca. ");
INSERT INTO boaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ehdúhjáa Jetsóó néénéllii tsaapi néé dííbyeke: —Maímijyu ihdyu diitye Píívyéébé avyéjuvu úcaavémé íjcyanej. ");
INSERT INTO boaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ehdúhjáa dibye néénéllii Jetsóó tsaapi wáñehjɨ́vaténetu úwááboobe nééhií: —Tsaapíhjyáa iwáñehjɨ́vaténevu míñutsó mítyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ááme éllevúhjáa íúníu múnáájpikye dibye wálloobe neeté diityéke: “Tsúúcajávané majcho baabáhi. Waávané mepééne mémajchótej.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Árónáacáhjáa tsá ditye ímílletú ipyééneé. Tsaapíhjyáa íllure néé dííbyeke: “Ohné tsaatédítyú íiiñújɨ́ o áhdone ó imíllé o úújeténe. Áánéllii tsá oke dibye téhméityúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Áánetúhjáa tsijpi nééhií: “10-meváké ócájímuke o áhdómeke ícyooca ó imíllé o wáájáculléné muhdú ditye wákímyeíñe. Áánéllii tsá oke dibye ɨ́jtsójúcóóityúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Áánetúhjáa tsijpi nééhií. “Botsíi o táábávaabe muhdú ó peéhi. Tsáhái o péétune.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Éhduréhjáa ditye népejtsóné ióómíñe úúbálleebe íavyéjúúbeke. Aanéhjáa dííbyeke tsárí pájtyeebe néé diibye íúníu múnáájpiíkye: “Ané cána míñutsóté ɨ́dáátsóméhjɨkéréjuco íjpi ímítyuméhjɨ́ ímíñeúvú iúllene píívyetétúméhjɨma hállúvátúméhjɨke.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ahdújucóhjáa imíñútsójétsihdyu tsáábe nééne dííbyeke: “Ayúju ávyéjuúbej, tsúúca ó míñútsojéhi. Árónáa íñe jaa tsáhái wáhpetúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Áánélliihyéhjáa íavyéjuube nééhií: “Ané cána tsíjtyekéi míñutsótej. ");
INSERT INTO boaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tsáhájuco tujkénúu o míñútsorómé májchóváityúne.” Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Aanéhjáa mítyane mɨ́amúnaa dííbyeke úráávyehíjcyámeke neébe: —Muurá oke úráávyerómé oke iwájyúné ehnííñevu méwámyuma ihyájkímukéré wájyúhajchíí tsá ditye ɨ́mɨááné tahñéjté íjcyatúne. Áhdure iiye éhnííñevu iwájyúmeíhajchíí tsá ditye tahñéjté íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Áhdure oke iúráávyéné déjúcotu ɨɨ́cúbáhrámeíiyóné ímílletúmé tsá tahñéjté íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿Aca ámuha jaa meméénu tsá tujkénú meéévéítyuró múhduná ámúha dsɨ́ɨ́dsɨ́ íjcyane tene úújetéhajchíí botsíi ámuha meméénuki? ");
INSERT INTO boaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Muurá dsɨɨdsɨ úújetétúnáa ámuha meméénuróné menɨ́jkévátúneri tsijtye uuhɨ́vatéiyá ámúhadi. ");
INSERT INTO boaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Muurá nééiyóme: “Éje, íjtyémeíhjyáa íñe ánúmeíyómé tsá pánéévétsotúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Áhdure ¿aca tsáné avyéjúúbé tsodáhómú 10,000-meváré íjcyame tsíjpí tsodáhómú 20,000-meva íjcyámema imyéénújcatsí tsá tujkénú ɨ́jtsámeíítyuró téhdúmema diityéké ityáhjáítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Muurá téhdúmema ɨɨ́hnáhóóítyúrónéllii tsíhyulléréi ditye íjcyánáa wállójcatsíiyómé diityé éllevu ditye iñééte imyéénújcatsíjyúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ehdu nééne muurá tsaate iímillédú iícyahíjcyáné ɨ́hvéjtsotúmé tsá tahñéjté íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Muurá cánááma iíímuma iíjcyánéllii meke pɨ́aabóhi. Áánetu iíímútuca tsá ɨ́ɨ́netú tene meke pɨ́áábóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pane mebájtso ííñujɨ meúménúíyónéúbatu tsá meke tene pɨ́áábóítyuróne. Áánéllii tehdu nééne ílluréjuco mewáágóone. Aane ihdyu óvíi ámúhadítyú lléébome icyáhcújtsóne tehdu ijcyáhi. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Téijyúhjáa ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyámema tsijtye ímityúmé píhcyaavé dííbyedívú dííbyé uwáábó illéébúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Áámedítyúhjáa paritséómuma taúhbájú uwáábojte nééhií: —¿Aca ɨ́veekí aadi ímítyúmedívú nahbéváhi? ");
INSERT INTO boaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Ehdúhjáa dííbyedítyú ditye íhjyúvánéllii obééjá mújtánetu iúwaabóné neébe: —¿Aca ámúha jéémú obééjámú 100-meva íjcyámedítyú tsaapi mújtaca tsá ámuha 99-meváréjuco íjcyámeke íúmɨhéj pɨɨnévú mepícyóóne dííbyeke menéhcóítyuróne? Muurá ámuha ménéhcóiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Áábeke muurá ámuha maájtyúmɨ́cooca mítyane meímíjyúúvéne ááhɨvu ámuha mewájtsɨdu mépihjyúcúiyá ámuha menáhbévahíjcyámeke ditye téhdure iímíjyúúve mújtáróóbeke ámuha maájtyúmɨ́neri. ");
INSERT INTO boaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ahdu muurá Píívyéébe níjkyéjɨri íjcyaabe mítyane ímíjyuuvé tsaapi ímítyúné pañévú mújtároobe tsiiñe ímíjpyetéébedi. Muurá ímí íjcyámedi iímíjyúúné ehnííñevu ímíjyúúveebe mújtároobe tsiiñe ímíjpyetéébedi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Téhduréhjáa dsɨ́ɨ́dsɨ́jɨtu diityéké iúwaabóné neébe: —¿Aca tsáápílledi 10-jɨva dsɨɨdsɨ íjcyánetu tsajɨ wágóóóveca tsá dille choocówu peetéj tééveri llíjyaalléré néhcóítyuróne? Muurá néhcóíyolle. ");
INSERT INTO boaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aajɨ muurá iájtyúmɨ́neri iímíjyúúvéne iñáállévahíjcyámeke pihjyúcúíyolle ditye téhdure iímíjyúúveki. ");
INSERT INTO boaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ehdu muurá ímityúné ícyahíjcyaabe teene ɨɨ́hvéjtsóne Píívyéébé icyánejcúvuréjuco ɨ́búwáávéébedi níjkyéjɨ múnaa mítyane ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Téhduréhjáa tsiiñe úwááboobe nééhií: —Íjcyamútsíhjyáa míítyétsi tsáápí hájchimútsi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Áámútsidítyúhjáa bóneebe néé cááníkyeé: “Llíhij, u dsɨ́jɨ́véné boone métsíeméné múhtsidívuréjuco cóéváíñetu ó imíllé apáhajchíí ícyoocájuco oke tsáneevu u ájcune.” Ahdújucóhjáa dibye ɨɨná néétuubéré ájcune diityétsikye tsahdúnéécu. ");
INSERT INTO boaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Átsihdyúhjáa wahájchotáré tétsii diibye bóneebe iíjcyáróne páneere ihñe nahjɨ́henúhi. Ááne dsɨ́ɨ́dsɨmáhjáa peebe cáánídityu tsíhyullévú tsííñé iiñújɨvu. Áhullévúhjáa teene ɨdsɨ́ɨ́dsɨ́ íllure ɨ́cúbáhraabe ímityúné iícyahíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aanéhjáa tsúúca páneere ɨdsɨ́ɨ́dsɨ́ átéréénéhjɨri dibye pɨ́rújtsónáa tééné iiñújɨri tsá majcho íjcyatúne. Áijyúhjáa ɨ́dátsó pevééberéjuco ícyahíjcyáné ɨ́ɨ́ne tájpí íjcyájúcóótuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Áánélliihyéhjáa tééné iiñújɨ múnáájpikye táúmeííbyé wákiméi. Aabéhjáa dííbyeke téhmetsó ímyeenímudívu. ");
INSERT INTO boaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aabéhjáa diityéké téhmehíjcyáábeke múha majchóvú ájcútuube ájyaba wájyújúcóótúnéllii imíllerá diityé éébuta imájchone. ");
INSERT INTO boaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Átsihvúhjáa ikímóóvémeíñe íllu ɨ́jtsámeííbye: “Ehdɨ́ɨ́vajúné tsáma áyáturómé llihíyó wákimyéi múnáadítyú majcho pɨ́htótúnáa ¿ɨ́veekí íchihvu ó dsɨ́jɨ́veehíubá ájyábari? ");
INSERT INTO boaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tsáhaá, oo éhne llihíyo éllevu o óómíñe dííbyeke ó neéhi: Llíhij, ¿ɨ́veekíhyana ihdyu Píívyéébe ímíllénejɨ́ɨ́ ímityúné ó meenúhi, áhdure u íjcyáróóbedívú ímíñejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ahdícyane tsáhájuco dɨ́jtsɨɨméné o íjcyáityúne. Díwákimyéi múnáajpíyéjuco o íjcyaíñe.” ");
INSERT INTO boaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ehdúhjáa ɨɨ́jtsámeídyújuco dibye óómiñe cáání éllevu. Aabéhjáa téhullévú péébeke tsíhyullétúré cááni iájtyúmɨ́ɨ́bedi mítyane ɨɨ́dáátsóvéne ɨ́ɨ́cúi icyáhdahɨ́róne ámabúcutéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Átsihvúhjáa ípyée ɨɨ́jtsámeídyújuco dibye cááníkye nééneé: “Llíhij, ¿ɨ́veekíhyana ihdyu Píívyéébe ímíllénejɨ́ɨ́ ímityúné ó meenúhi, áhdure u íjcyáróóbedívú ímíñejɨ́ɨ́vari? Ahdícyane tsáhájuco dɨ́jtsɨɨméné o íjcyáityúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ehdúhjáa dibye néérónáa cááni néé íúníu múnáake: “Ɨ́ɨ́cúi áánúke íwajyámúúnema ítyúhápaajɨ́vú meújcóne hójtsɨ́wápaajɨ́vú maájcú dibye ipícyámeíki. ");
INSERT INTO boaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Átsihdyu íujcávaabe ócájíwúuke médsɨ́jɨvétsó dííbyeke mewáñehjɨ́nuki. ");
INSERT INTO boaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Muurá íñe ‘tsúúcajáubáhjáa dsɨ́jɨ́veébe’ o néhíjcyánáa ɨ́dátsó kiátú bóhdɨ́vaabe méhdivu.” Ahdújucóhjáa ditye wáñehjɨ́vaténe. ");
INSERT INTO boaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Áijyúhjáa íñahbe ámíaabe úmɨhé pañétú óómiibye lleebúcunúvá wañéhjɨ́ ihjyárí íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ááneríhjyáa iúllévenúne kémuélletúré íúníu múnáájpikye ɨpɨ́uváne dílloobe ɨ́veekí ditye wáñéhjɨ́vaténe. ");
INSERT INTO boaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Áánélliihyéhjáa neébe: “Muurá díñahbe wajtsɨ́hi. Áánélliihyéne díícyááni lliihyánutsó íujcávaabe ócájíwúudívú dibyévané ɨɨná pájtyétuube kiátú bóhdɨ́vánéllii dííbyeke iwáñehjɨ́nuki.” ");
INSERT INTO boaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aanéhjáa ávyéta tsárí pajtyé dííbyeke. Aabéhjáa ɨ́hnáhó cáyobáávatéébé tsá áyánéwu ímílletú iááhɨvéné ihjyávu. Áánélliihyéhjáa cááni dííbye éllevu ipyééne cánáájanú dibye iááhɨ́veki. ");
INSERT INTO boaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Árónáacáhjáa neebe cááníkyeé: “Llíhij, muurá íñe múhdúné pijcyábá úúma ó wákímyeí uke táhjállétuubére. Áróóbeke tsá múijyú oke u ájcutú obééjá hájchíúbadívúré ehdu o wáñehjɨ́vaté o náhbévahíjcyámema. ");
INSERT INTO boaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aabe eene dááchikye ɨ́mɨáábekéjɨ́ɨ́ ú wáñehjɨ́nú íujcáváábeke jeemúdítyú u dsɨ́jɨ́vétsóóbé hallúrí ímityúné walléémudi dɨdsɨ́ɨ́dsɨ́ pɨ́rújtsójéébeke.” ");
INSERT INTO boaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Áánélliihyéhjáa cááni nééhií: “Ɨ́mɨáánéjuco, Lli, óóma tsatsííyé u ícyahíjcyáne. Aane muurá páneere tátsíeméné dihñe. ");
INSERT INTO boaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Áánetu ihdyu tehdújuco mewáñehjɨ́núné díñáhbeke ɨ́dátsó kiáhjɨ́ múhduháñé iícyahíjcyátsihdyu ‘tsúúcajáubá dsɨ́jɨ́veébe’ o néhíjcyánáa méhdivu bóhdɨ́váábeke.” Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Téhduréhjáa ímamyémuke úwááboobe nééhií: —Íjcyaabéhjáa ɨ́htsútuube ehnéva múnáajpi. Áábé úníu múnáajpíhjyáa ímítyuube íjcyáábé hallúvú tsaate úúballé diibye íavyéjúúbeke dibye ímítyú téhmehíjcyáné dííbyé tsíeméne. ");
INSERT INTO boaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Áánélliihyéhjáa íavyéjuube ɨpɨ́úváábeke nééhií: “¿Ɨ́veekí ímityúné mɨ́amúnaa díhyallúvú úúballéhi? Ahdícyane oke ímíñeúvú duubállé muhdú tátsíeméné u téhmehíjcyáne. Átsihdyu tsáhájuco óóma u wákímyeíityúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ehdúhjáa íavyéjuube néénetu íllu ɨ́jtsámeííbye: “Aane ¿muhdú íñe ó íjcyaá oke táavyéjuube wáágóoóbe? Tsá muurá o píívyetétú tsííñé wákimyéí o méénune. Pane núcójpɨ́tsó teene tsíjtyeke pɨáábó o táúmeíñe tájpí o íjcyáiyóne.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ehdúhjáa ɨɨ́jtsámeíyóne neébe: “Tsúúca ó waajácú muhdú o méénuíñe. Oo éhne ó pɨ́ááboó táavyéjúúbedítyúu iñáhjɨ́henúné áhdohíjcyátúmeke néhi dibye oke wáágóócooca diityéréjuco oke ɨpɨ́ááboki.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ehdúhjáa ɨɨ́jtsámeíñe pɨ́úvaabe tsáápiitsádí diityéké eenée íavyéjúúbedítyú iñáhjɨ́henúné áhdohíjcyátúmeke. Áánemáhjáa o méénuíñe. Oo éhne ó pɨ́ááboó táavyéjúúbedítyúu iñ tujkénú tsáábeke neébe: “¿Acáa múhduná táavyéjúúbedítyú u náhjɨ́henúné tsáhái u áhdotúne?” ");
INSERT INTO boaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Áánélliihyéhjáa neébe: “100-hoojáváa oríívó duurúbájpacyóné ó ujcúhi.” Áánélliihyéhjáa neébe: “Éée, íñée muurá u cáátunúné téhdunéjuco. Árónáa cána ɨ́ɨ́cúi béháámɨtúréjuco picyo 50-hoojávaréjuco u áhdotúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ááné boonétúhjáa idyé tsijpi tsáábeke neébe: “¿Ácooca uu múhduná tsáhái u áhdotú ávyéjúúbeke?” Áánélliihyéhjáa neébe: “100-babyáváa tríígo ó ujcúhi.” Áánélliihyéhjáa neébe: “Éée, íñée muurá u cáátunúné téhdunéjuco. Árónáa cána ɨ́ɨ́cúi béháámɨtúréjuco caatúnú 80-babyávaréjuco u áhdotúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ehdúhjáa ávyéjúúbé úníu múnáajpi ímityúné meenúhi. Aanéhjáa bóónétu íavyéjuube iwáájácúneri ullévenú dííbyedi ayájú tujkévé ehdu imyéénuíñé dibye ɨ́jtsámeíñeri. Ehdu muurá íñe ɨ́mɨájɨ́jtó úráávyémé ehnííñevu ténejcu wáájácutúmé tujkévééné ɨ́jtsámeíñé tsíjtyema iñáhbévájcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aane ihdyu ámúhakye o néé íñe ííñújɨri ámuha meéhnevámé tsíjtyeke mepɨ́áábo néhi ámuha medsɨ́jɨ́vécooca Píívyéébe ámúhakye iúcúpéjtso múijyú muhdú íjcyáityúmé dííbyema ámuha meíjcyáíhullévu. ");
INSERT INTO boaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muurá wahdɨ́ɨ́váné wákimyéivu tsaatéké mepícyoome ímí wákímyeíhajchíí méwaajácú téhdure éhnííñevu íjcyáné wákimyéí ímí ditye méénúiyóne. Áánetu teene átérééné wákimyéí múhdurá méénuhíjcyámé muurá éhnííñevu íjcyane téhdure dárɨ́ɨ́véiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aane muurá íñe ííñújɨri ámuha meéhnéváneri ɨ́mɨáánéré ámuha meméénútúhajchíí téhdure Píívyéébé wákimyéí múhdurá ámuha médárɨɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Téhdure tsíjtye éhné ímíñeúvú ámuha metéhmétúhajchíí muurá ámúhá wáábyuta íjcyaróné tsá múha ámúhadívú ɨ́hvéjtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Muurá tsá míítyétsima tsaapi ímí wákímyeíítyuróne. Muurá tsáápiikye éhnííñevu iwájyúúbedíyé ɨɨ́ɨ́cúvéne tsá tsíjpihdi dibye ɨ́ɨ́cúvéítyuróne. Áánéllii tsá tene ímityú Píívyéébeke meúraavyémé metsúúrámeíñé medsɨ́ɨ́dsɨ́váíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ehdúhjáa Jetsóó úwaabóné paritséómú illéébóne íllure uuhɨ́vaté dííbyedi tééneri itsúúrámeíhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Áámekéhjáa neébe: —Bañú múnaa ámuha meíjcyámeke mɨ́amúnaa ɨtsúcunúhijcyá ɨ́mɨáámédu. Árónáa Píívyéébe waajácú ámúhá ɨ́jtsaméi. Muurá mɨ́amúnaa mítyájkímyeíñé tsarílleébe. ");
INSERT INTO boaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Muuráhjáa Jóáa bóhówáávétúné hajchótá Píívyéébé taúhbaju íhjyú uubálle múnáaúvú úwáábohíjcyánéréi mɨ́amúnaa úráávyehíjcyáhi. Ááné boonétúu ihdyu diibye Jóááuvúréjuco úwaabóné ɨ́mɨáájú Píívyéébe mɨ́amúnáake íavyéjuvu újcúné uwááboju. Áánélliihyée mítyame tsúúrámeíhijcyá téénevu iúcáávéíñeri. ");
INSERT INTO boaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Muurá ííñújɨma páneere íévéhóówari íjcyanéhjɨ́ wágóóóveéhi. Áánetu Píívyéébé uwááboju tsá múijyú wágóóóvéityúne. Muurá muhdú tene néhdújuco tene pájtyeíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Muurá tsaapi méwakye ɨɨ́hvéjtsóne tsíjpíllekéréjuco táábávaabe ímityúné meenú ɨ́veekí mewa ímíubááné íjcyánáa tsíjpíllemáyéjuco iíjcyáneri. Áhdure tsaapi wáágóólleke táábávaabe ímityúné meenú ɨ́veekí ájyu ímíubááné íjcyánáa dííllema iíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Téhduréhjáa tsiiñe Jetsóó úwááboobe nééhií: —Íjcyaabéhjáa tsaapi ɨ́htsútuube ehnéva múnáajpi tsanééré ɨ́mɨá wajyámuunévú úcámeíhíjcyaábe. Áábekéhjáa ɨɨná pɨ́htótuube paíjyuváré wáñehjɨ́vatéhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Áánáacáhjáa Ráátsaro áhllávatéébé ácuúcunúhijcyá dííbyé já lleehówá úmɨ́wari. ");
INSERT INTO boaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aabéhjáa ɨ́dátsó úmúúpívyehíjcyá díbye májchónetu baavu dójcówaahyéjɨ́ imájchóíyóneri. Áábedívúhjáa oohímyé ipíhcyáávéne pɨ́hjahíjcyá dííbye áhllaháñe. ");
INSERT INTO boaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aabéhjáa ílluréjuco dsɨ́jɨvéne. Áábe ɨ́ɨ́buúhjáa níjkyéjɨ múnaa tsajtyé Píívyéébe éllevu Aavaráá íjcyáhullévu. Ááné boonétúhjáa dííbyeréjuco ɨ́htsútuube ehnéva múnáajpi dsɨ́jɨ́véébeke tsaímíyé cuuúme. ");
INSERT INTO boaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Áábe ɨ́ɨ́buúhjáa úújeté Píívyéébeke cáhcújtsotúmé ɨ́cúbáhrámeíhullévú cúújúwá pañévu. Áhulléhjáa ɨ́cúbáhrámeííbyé ájtyumɨ́ Aavaráake Ráátsaro dííbyemájuco íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Áábedíhjyáa wáníjcyámeííbyé nééhií: “Múúhá ɨhdé múnáajpi Aavaráaj, óhdi ihdyu dɨ́dáátsóvéne aabye Ráátsaróké diñe oke dibye íhyójtsɨ́wáubáré nújpácyotu imúriúcúneri táhnɨ́jɨwa ɨpɨ́pajchóvaki. Ávyeta íñe cúújúwá allóócó tsáhájuco o áábúcutúne.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Áánélliihyéhjáa Aavaráá néé dííbyeke: “Cáhawáá, Lli, dɨtsáávé ɨ́ɨ́né imíjyaúhjáa u íjcyane u dsɨ́jɨ́vétúné ɨhde. Áánetúu muurá áánu Ráátsaro ɨ́dátsó ɨ́cúbáhrámeíhíjcyaabe íñe ícyooca ɨ́ɨ́né imíjyaúréjucó íjcyane. Áánetu ihdyu ú ɨ́cúbáhráméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aabe pɨáábó u táúmeíyónáa ijcyáné íñe múúhadítyú ámuha meráhoúcunútsihdyu íéverááhó ápíchó nééne kiátú mepájtyéne meúújéjcatsííyónejɨ́ɨ́vari. Muurá íñejcúrí íjcyame tsá píívyetétú énejcúvú ipájtyene. Áhdure énejcúrí íjcyame tsá píívyetétú íñejcúvú ipájtyene.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ehdúhjáa Aavaráá néénéllii neébe: “Uu muurá Aavaráá múúhá ɨhdé múnáajpi u íjcyaabe ihdyu óvíjyuco aabye Ráátsaróké wallo ííñujɨ́vú llihíyoke pámeere tahájkímuma dibye iúwáábotéki. ");
INSERT INTO boaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ijcyámé 5-meva táñahbému. Áámeke ó imíllé dibye wáájácútsoténe íllúhaca ɨ́cúbáhraméí íjcyánáa ɨ́veekí ímityúné o ícyahíjcyáné nɨ́jcaúvú o úújetéébé o ɨ́cúbáhrámeídyú ditye ɨɨ́cúbáhrámeítyuki.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ehdúhjáa dibye néérónáa Aavaráá néé dííbyeke: “Árónáa muurá ijcyáné diityédí Píívyéébé waajácúháámɨ́ íñe ɨ́cúbáhraméityu úúbálleháámɨ́ dííbyé ihjyú uubálle múnaápe Moitséémú cáátúnuháámɨ. Téhaamɨ óvíi iéévéne cáhcujtsómé ipájtyetéki.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ehdúhjáa Aavaráá néérónáa neébe: “Ihdyúhde ɨ́mɨááné ijcyájúcooróné diityémá uwááboju. Árónáa ihdyu mee dsɨjɨ́ve múnáadítyú tsiiñe bóhɨɨbe diityéké úwáábotéébeke botsíi cáhcújtsóiyóme. Aaca ihdyu ɨ́mɨááné ímityúné iícyahíjcyáné ɨɨ́hvéjtsóne ɨ́búwáávéiyómé ɨ́mɨánejcúvuréjuco.” ");
INSERT INTO boaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Áánélliihyéhjáa Aavaráá nééhií: “Árónáa muurá Píívyéébé ihjyú uubálle múnaápe Moitséémú cáátúnúné uwááboju icyáhcújtsótúhajchíí téhdure tsá ditye cáhcújtsóítyuró dsɨ́jɨ́vémedítyú tsaapi tsiiñe ibóhówáávéne úwááboróne.” ");
INSERT INTO boaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Áhduréhjáa tsiiñe ímamyémuke neébe: —Tsá ííñújɨri mávaríjchojúúné pɨ́htóityú mɨ́amúnáake tútávájtsoíñe. Árónáa ihdyu máɨdáátsoju tene pájtyeíñé ímichi ténehjɨ́vú diityéké ɨ́búwátsohíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Muurá botsíi oke cáhcujtsómé ɨ́dátsó tsɨɨmédúréi néémedítyú tsaatéké ímítyunévú ɨ́búwátsohíjcyámekéubá múu íjkyééháñetu néwáyúcobáné ióhbáñúmeke wájojcó móóá pañévú ápíchó diityé úmɨwa nééné ɨhdétu. ");
INSERT INTO boaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Áánéllii téɨɨbúwá meíjcyáne ámúhá nahbe ímityúné méénúúbeke mébóíjcyuco. Aabe teene ɨɨ́hvéjtsóne ɨ́mɨánejcúvú tsiiñe ɨ́búwáávéhajchíí ílluréjuco máábájɨ́ɨ́veco ímityúnée dibye méénune dííbyedi meɨ́dáátsóvénema. ");
INSERT INTO boaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tsáijyu múúne 7-ijyúvá tsájcoojɨ méénúíyoobe ímityúne. Áhdúijyúvá dibye ámúhadívú ɨ́dátsójkímyeíhajchíí múu ɨ́dáátsové dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Áábekéhjáa ímamyémú nééhií: —Múúhakye pɨáábó éhnííñevu muha mecáhcújtso Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Áánélliihyéhjáa neébe: —Muurá mojtáátsá neeváúwúudúné áyánéwu ímí Píívyéébeke ámuha mecáhcújtsoca eehe úmehe ámuha ménééiyá étsihdyu tehe ityábáávyéne móóáj pɨɨnétú iíjyócúúvetéki. Ahdújuco muurá tehe íjyócúúvetéiyóné tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","¿Aca ámúhá úníu múnáajpi úmɨhé pañe caajárí tsáijyu ócájimu téhméúbari iíjcyátsihdyu ááhɨ́véébeke ámuha mémáchótsópéjtsóiyáhi? Tsáhaá. ");
INSERT INTO boaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Muurá íllure ámuha ménépéjtsóiyá dííbyeke: “Majchóréjuco meénu. Aane u nɨ́jkevádú ú pícyoó tujkénú muha memájchoki. Ááné boonétúi ú májchoóhi.” Éhdure muurá ámuha ménééiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Áhdure ¿aca ámuha dííbyeke météhdújtsóiyá ámuha metáuhbánéré dibye méénúné hallúvu? Tsáhaá. ");
INSERT INTO boaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ehdu téhdure Píívyéébe ámúhakye pícyóóné wákimyéí ámuha menɨ́jkévácooca tsá múu íjyácunútú dibye ámúhakye téhdújtsóíyóneri. Íllure múu nééhií: “Tsá muurá ɨ́mɨá ɨɨcúve múnaa muha méíjcyatú múúhakye dibye táuhbánéré muha meméénúnélliíhye.” Éhdure múu nééhií. Ehdúhjáa neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aabéhjáa Jerotsaréevu péébe pajtyé Tsamááriámá Gariréá iñújɨ́ɨ́cutu. ");
INSERT INTO boaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Aabéhjáa tsácoomíwuúvú úújeténáa dííbye éllevu 10-meva tsáá íjpi chájaavéme. Ároméhjáa kémuéllevúré iwájtsɨ́ne dííbyedi wáníjcyámeímyé kéévánécoba nééhií: —¡Jétsoj, Jetsóoj, múúhadi dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Áánélliihyéhjáa diityéké ɨ́ɨ́teebéré nééhií: —Tsúúca muurá ámuha mébohɨ́jucóóhií. Aame cáhawáá llúúvájtedívú méúújétsámeítyej. Ahdújucóhjáa ditye pééne tsaímiyéjuco néémeé. ");
INSERT INTO boaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Áámedítyúhjáa Tsamááriá iiñújɨ múnáajpi oomí Píívyéébeke dúúrúvaabére. Aabéhjáa Jetsóó lliiñévú ɨmɨ́móúúvéne dííbyeke téhdujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Áábekéhjáa Jetsóó nééhií: —¿Aca tsá pámeere ámuha mebóhɨɨtúne? Muurá íñe tsííñé iiñújɨ múnáajpi u íjcyároobe ú oomí Píívyéébeke u téhdújtsoki. Áánetu ¿kiá tsijtye? ");
INSERT INTO boaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ehdúhjáa iñétsihdyu neebe dííbyeke: —Wa díjyócúúvéne dipyej. Tsúúca ú bohɨ́ɨ́ Píívyéébeke u cáhcujtsódú íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aanéhjáa Jetsóoke paritséómú dilló múijyú Píívyéébé avyéjú bóhówááveíñe. Áánélliihyéhjáa neébe: —Tehdu Píívyéébé avyéjú bóhówááveróné ámuha maájtyúmɨ́íyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Áánéllii tsá múha nééítyuróne: “Íñe Píívyéébé avyéju.” Muurá ihdyu ijcyájúcooróné ámúhama. ");
INSERT INTO boaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ehdúhjáa diityéké iñétsihdyu neebe ímamyémuke: —Muurá ámuha méijyácúnuú Mɨ́amúnáájpidívúu o ípívyéévéébeke ámuha maájtyumɨ́júcóóíyóneri. Ehdu ámuha meɨ́jtsámeíyónáa tsáhái ámúhadívú o bóhówáávéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Muurá ámúhakye tsaate neéhi: “Tsúúca Mépájtyetétsoobe tsájucóóhií.” Árónáa tsá múu cáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Muurá chijchi rórihcyóné maájtyumɨ́dú pámeere ájtyúmɨɨ́ Mɨ́amúnáájpidívúu o ípívyééveebe o tsáábeke. ");
INSERT INTO boaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Árónáa ihdyu ɨhnáhooíñé ícyooca íjcyáné mɨ́amúnaa óhdi ɨ́cúbahráne. Tsá oke ditye cáhcújtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Muuráhjáa Noéé íjcyáijyu íjcyáné mɨ́amúnaa íjcyadúré íjcyaímyé o tsááiñe ɨ́jtsotúme. Áánáa tsúúca ó tsaá Mɨ́amúnáájpidívúu o ípívyééveébe. ");
INSERT INTO boaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Muuráhjáa téijyu íjcyáné mɨ́amúnaa iímillédúré ícyahíjcyá majchóháñeri, adóháñeri, táábávajcátsiyi. Áánáacáa ihdyu Noéé tsúúca ɨhmɨ́ɨ́né pañévú úcáávénáa ííñujɨ páneere caajávéjucóóhií. Ááneríi pámeere cáhcújtsotúmé óuuvé imájcanúneri. ");
INSERT INTO boaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Áhdurée muurá pajtyéné Róo íjcyáijyu íjcyámeke Tsodóóma múnáake. Muuráhjáa téhdure iímillédú ícyahíjcyámé majchóháñeri, adóháñeri, náhjɨ́heri, úmɨhéneri, ánuméiyi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Áánélliihyée muurá Píívyéébe dííbyeke néé dibye iíjchívye técoomítyu. Áhdújucóo dibye íjchíívyéné boone Píívyéébe cúújuwa ɨ́jcaáyóneri técoomi áiivyéne. ");
INSERT INTO boaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ahdu muurá Mɨ́amúnáájpidívúu o ípívyééveebe ó tuvááóvaá mɨ́amúnáake iímillédúré íjcyámeke tsiiñe o tsáijyu. ");
INSERT INTO boaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Áijyu ihjyátú tsiéllé íjcyame tsá ihñénéhjɨ éllevu péjúcóóityúne. Áhdure íúmɨhérí íjcyame tsá ihjyávú péjúcóóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cáhawáá méɨjtsúcunu muhdúhjáa diibye Róó táábake tene pájtyene idyéjú dille révoúcunúné déjúcotu. ");
INSERT INTO boaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Muurá ííñújɨri iímillédú iíjcyáneríyé tsúúrámeíhijcyámé tsá pájtyetéityúne. Áánetu ihdyu teene ɨɨ́hvéjtsóne ookéréjuco úraavyémé pájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Muurá tsiiñe o tsáácooca míítyétsi cúwámútsidítyú tsáápiikye o újcúnetu tsijpi coévaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Áhdure tsaatépɨ́ cáátsómúpɨdítyú tsáápílleke o újcúnetu tsíjpille coévaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Téhdure tsaatétsí íúmɨhé pañe íjcyámútsidítyú tsáápiikye o újcúnetu tsijpi tétsihvúré coévaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ehdúhjáa Jetsóó néénéllii ímamyémú nééhií: —¿Aame kiávú úújéteéhi? Áánélliihyéhjáa neébe: —Muurá éhne múúne tsíeméjpí dsɨ́jɨ́véébedívú áñumu píhcyaavédú tahñéjté óhdivu píhcyááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Áhduréhjáa Jetsóó tsiiñe ímamyémuke úwááboobe úúballé ímítyúnéhjɨ́ ímibájchoobe ímítyuube íjcyáábedítyú tééneri diityéké itsápɨ́jtso Píívyéébema iíhjyúvahíjcyánetu ditye ióóchévétuki. ");
INSERT INTO boaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Íllúhjáa neébe: —Íjcyaabée tsácoomíyí ímítyúnéhjɨ́ ímibájchoobe ímítyuube Píívyéébeke ávyejúúllétuúbe. Aabéhjáa tsá ímí pɨ́áábohíjcyatú mɨ́amúnáake. ");
INSERT INTO boaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Áábekée técoomíyí íjcyalle pííbájyulle néé tsaatémá ímityúné dille dáárɨ́ɨ́véjcatsíñé dibye iímíbájcho dííllema. ");
INSERT INTO boaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ehdúu múhajchótájucó dille dííbyeke pɨáábó táúmeíyóneri tsá dibye ɨ́ɨ́cúvehíjcyatúne. Áánéj pɨɨnévúhjáa íllu ɨ́jtsámeííbye: “Píívyéébeke o ávyejúúllétúnéllii tsáháturo mɨ́amúnáake o pɨ́áábóiyóné oke ávyetúne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Árónáa aalle pííbájyulle íjyévé éhnííñevúré oke pátsáríjcyónéllii óvíjyuco díílleke o pɨ́ááboíñé oke dille ipátsárijcyójúcóótuki.” ");
INSERT INTO boaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ehdúhjáa iúúbálléne neébe: —Ehdúu pɨ́ɨ́névúi pɨ́ááboobe ímítyúnéhjɨ́ ímibájchoobe ímítyuube íjcyároóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aanéjɨ́ɨ́ ¿aca tsá ámuha mewáájácutú Píívyéébe ihñéjteke pɨ́ááboíñé dííbyeke pɨáábó táúmeíhíjcyámeke? ¿Mityá ámuha méɨjtsúcunú ditye pɨáábó táúmeíñeri dibye ɨ́ɨ́cúvetúne? ");
INSERT INTO boaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tsáhaá. Muurá pɨ́áábóiibye diityéké teenémáye. ¿Aca íhya mɨ́amúnaa ímí cáhcújtsómedívú ó wájtsɨɨ́ Mɨ́amúnáájpidívúu o ípívyééveebe tsiiñe ííñujɨ́vú o tsáácoóca? Ehdúhjáa neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Téhduréhjáa tsaate ɨ́mɨáámedi idíllómeíñe tsíjtyeke éhdɨɨvállehíjcyámeke úwááboobe úúballé tsaatétsí Píívyéébema íhjyúvánetu. Íllúhjáa neébe: —Tsáijyúu míítyétsi péé duurúvajávú píívyéébema iíhjyúvaki. Tsaapíi paritseómuúbe. Áánetúu tsijpi ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aanée paritséómuube Píívyéébema íhjyúvaabe nééhií: “Ayúju Tápiivyéébej, uke ó téhdujtsó ɨ́mɨáábé o íjcyáné hallúvu. Tsá muurá tsíjtyedu ímítyuube o íjcyatú naní múnáajpi. Tsá múijyú ihdícyámema o dómácójcatsítyúne. Pane tsá aabye ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyaabe ímítyuube íjcyadu o néétune. ");
INSERT INTO boaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Muurá tsáné tsemáánari míjcyoojɨ́cú májchótuube úúma ó ihjyúvahíjcyáhi. Téhdure muurá 10-jɨva o dsɨ́ɨ́dsɨ́vánetu tsájɨ́hcoba ó dówacárohíjcyá uke o ɨ́ɨ́cuvéne.” Ehdúu Píívyéébema ihjyúvaabe paritséómuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Áánetúu diibye ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyaabe tsá cáámevu icyárúúvéne Píívyéébema íhjyúvatúne. Íllurée kímóóvémeííbyé ɨ́jpɨ́újɨtu iíllaáyómeíñe nééhií: “Ayúju Tápiivyéébej, óhdi ihdyu dɨ́dáátsóvéne dábajɨ́ɨ́vé táimítyu. Muurá imítyuube ó ijcyáhi.” Ehdúu ihjyúvaabe Píívyéébema ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aane muurá dííbyeke tsúúca Píívyéébe ímíbájchóóbé hallúrí tsáhájuco íimítyú íjcyatúne. Áánetu tsíjpiikye tsá dibye ímíbájchotúne. Ehdu muurá iiye ɨ́htsutúmé iíjcyane némeíhijcyámé núcójpɨ́vétsáméiíhi. Áánetu ihdyu ɨdáátsóméhjɨúvú nééme ávyéjúúteéhi. Ehdúhjáa Jetsóó úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aanéhjáa dííbye éllevu ɨ́ɨ́tsɨ́ɨ́meke tsivámé dibye Píívyéébeke pɨáábó ityáúmeí diityé hallúvu. Árónáacáhjáa ímamyémú diityéké néé ɨ́ɨ́nevú ditye ɨ́ɨ́tsɨ́ɨ́meke tsívane. ");
INSERT INTO boaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Árónáacáhjáa Jetsóó diitye tsɨɨméké ɨpɨ́úváne néé ímamyémuke: —Óvi ihdyu tsiváme. ¿Ɨ́veekí ámuha mécátuhtsóhi? Muurá diitye tsɨɨme íjcyadu néémé wáábyuta Píívyéébé avyéju. ");
INSERT INTO boaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aane ɨ́mɨáánetúré ámúhakye o néé éhne múúne teetsɨ tsɨ́ɨ́mene meke cáhcujtsódú Píívyéébeke cáhcújtsotúmé tsá dííbyé avyéjúejte íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aanéhjáa tsáijyu tsáné avyéjuube Jetsóoke nééhií: —Uwááboóbej, ɨ́mɨáábé ú íjcyaabe cána oke diñe ¿muhdú ó íjcyáiyóné múijyú o dsɨ́jɨvéjúcóóítyúne bóhɨ́ o újcuki? ");
INSERT INTO boaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Áánélliihyéhjáa neébe: —¿Aca ɨ́veekí eene oke ú dilló ɨ́mɨáábedi? Muurá ihdyu apáábyéré Píívyéébe ɨ́mɨáábe. ");
INSERT INTO boaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Muurá ú waajácú dííbyé taúhbajúúné nééneé: “Tsá múu ihdícyámema dómácójcatsítyúne. Tsá múu mɨ́amúnáake dsɨ́jɨ́vétsotúne. Tsá múu nánívatúne. Tsá múu állíuutúne. Múu avyéjuullé díícyáánimútsikye.” ");
INSERT INTO boaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ehdúhjáa Jetsóó néénéllii neébe: —Muuráhjáa ihdyu táayáábedítyúré tehdújuco o ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Áánélliihyéhjáa Jetsóó nééhií: —Árónáa ijcyánéi tsane u méénúiyóne. Cáhawáá dítsíeméné náhjɨ́hénúne pɨáábó ɨ́dáátsóméhjɨkej. Áijyu ihdyu ú avyéjúúteé níjkyéjɨri íjcyaabe Píívyéébé avyéjuvu. Aane cáhawáá ehdu méénúne ookéréjuco duráávyej. ");
INSERT INTO boaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ehdúhjáa Jetsóó nééne kimóhcó pajtyé dííbyeke mítyane dibye éhnévánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Áábekéhjáa ɨɨ́ɨ́téne Jetsóó nééhií: —Muurá mítyane éhnevámé ɨ́htsútúnetu Píívyéébé avyéjuvu úcáávéiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¿Aca muhdú caméélló ánéétóhéjutu pajtyéiyáhi? Áhdure ¿aca muhdú diitye ehnéva múnaa Píívyéébé avyéjuvu úcáávéiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ehdúhjáa dibye néénéllii tétsihyi íjcyame nééhií: —¿Aca ihdyu múhdutúrá pájtyetéiyóme? ");
INSERT INTO boaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Áánélliihyéhjáa neébe: —Ɨ́mɨáánéjucóhde mɨ́amúnaa tsá píívyetétú iiye ipájtyetétsámeíñe. Árónáa Píívyéébe piivyété diityéké ipájtyetétsóné ɨɨná dííbyedívú túhúútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Áánélliihyéhjáa Péédoro nééhií: —Ávyéjuúbej, muuráhjáa páneere muha meɨ́hvéjtsóne uukéréjuco méúraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Áánélliihyéhjáa Jetsóó nééhií: —Ɨ́mɨáánetúré ámúhakye o néé páneere íijcyátsɨ́hjɨma imúnáake cáánimuu, íñahbémuu, méwamyuu, ɨ́ɨ́tsɨɨ́mee, íjcyámeke tsánejcúvú ɨɨ́hvéjtsóne Píívyéébé wákiméí méénume muurá ɨ́ɨ́né imíjyaú íjcyaá ííñújɨri. Aame újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ tsɨ́ɨ́jɨréjuco ííñujɨ Píívyéébe ípívyéjtsójɨ́ hallúrí iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ehdúhjáa iñétsihdyu Jetsóó ímamyémuke íhdyúétsihvu idyóbeúcúmeke nééhií: —Mepéé íñe Jerotsaréevu. Ácoomívú muurá Mɨ́amúnáájpidívúu o ípívyéévéébedítyú tsúúcajátújuco Píívyéébé ihjyú uubálle múnaa néhijcyáné oke pájtyeéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Muurá oke llúúvájté avyéjujtémá taúhbájú uwáábojte ɨ́hvéjtsoó jodíómú íjcyátúmé hójtsɨ́ pañévu. Aame óhdi iúúhɨ́vaténe oke úníchíhcyuméré iwápáájcóóbeke ílluréjuco dsɨ́jɨ́vétsoíñe. Ároobe tsiiñe ó bóhɨɨ́ 3 coojɨ́vatu. ");
INSERT INTO boaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ehdúhjáa Jetsóó ímamyémuke nééne tsá ditye áyánéwu wáájácutú ɨ́ɨ́nerí dibye íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aabéhjáa ímamyémuma péébe Jericóój pɨɨhɨ́ríjyuco íjcyánáa juuvá úníuri hállúvátuube ácuúcunúúbé táúmeí pɨáábo. ");
INSERT INTO boaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aabéhjáa mítyane tééneri mɨ́amúnaa pájtyénéllii dilló ɨ́ɨ́nerí ditye úllene. ");
INSERT INTO boaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Áánélliihyéhjáa úúballémé Natsarée múnáajpi Jetsóoma ipyééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Áánélliihyéhjáa dííbyedi wáníjcyámeííbyé nééhií: —¡Jétsoj, Jetsóoj, Dabíiúvúj tsɨɨménémúhaabe u íjcyaábej, óvíjyuco ihdyu óhdi dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ehdúhjáa dibye néénéllii tsuullérí pééme dííbyeke uhbá cúúvéhulléré dibye iíjcyaki. Árónáacáhjáa éhnííñevúré tsiiñe neébe: —¡Dabíiúvúj tsɨɨménémúhaabe u íjcyaabe óvíjyuco ihdyu óhdi dɨ́daatsóve! ");
INSERT INTO boaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Áánélliihyéhjáa Jetsóó iíjyócúúvéne néé ditye itsíva dííbyeke. Áhdújucóhjáa ditye tsíváábeke dibye nééneé: —¿Ɨɨná ú imílléhi? ");
INSERT INTO boaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Áánélliihyéhjáa neébe: —Ávyéjuúbej, ó imíllé o hálluváne. ");
INSERT INTO boaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Áánélliihyéhjáa neébe: —Tehdújuco. Oke u cáhcujtsódú íjcyaabe tsúúca ú hallúváhi. ");
INSERT INTO boaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ehdúhjáa Jetsóó néénemáyé ɨɨtéjúcoóbe. Aabéhjáa dííbyemáyéjuco pééne Píívyéébeke dúúrúvaabére. Aanéhjáa tsijtye iájtyúmɨ́ne téhdure duurúvá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aanéhjáa Jetsóó ímamyémuma úújeté Jericóovu. ");
INSERT INTO boaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ácoomíyíhjyáa ehnéva múnáajpi Tsakyéó ííñújɨ́ avyéjúúbé wáábyuta dsɨ́ɨ́dsɨke áhdótsohíjcyámé avyéjuube íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aabéhjáa imíllerá Jetsóoke iájtyumɨ́ne. Árónáacáhjáa tsá dibye píívyetétú dííbyeke iájtyumɨ́né mɨ́amúnááj pɨɨne íjcyáábeke báhrí iñéénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Áánélliihyéhjáa ɨ́ɨ́cúi dibye pééíhyullévú dsɨɨnéríyé ipyééne néríívyeebe uméheri dííbyeke iájtyúmɨki. ");
INSERT INTO boaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Áánáacáhjáa Jetsóó tétsihdyu pájtyeebe tééhé nɨ́jcáuri íjcyáábeke iájtyúmɨ́ne nééhií: —Tsákej, Tsakyéoj, ɨ́ɨ́cúi niitye úúma o péékií. Muurá ó imíllé dihjyárí o cúwane. ");
INSERT INTO boaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Áánélliihyéhjáa ɨ́ɨ́cúi iñíítyéne tsajtyéébé ihjyávú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ááneríhjyáa mɨ́amúnaa ihjyúvá Jetsóodi ɨ́veekí ímítyuube íjcyáábe jávú dibye pééneri. ");
INSERT INTO boaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Áánélliihyéhjáa diibye Tsakyéó iíjyócúúvéne néé Jetsóoke: —Ávyéjuúbej, tátsíeménetu tsahdúnéécú ó dówajcároó ɨ́dáátsóméhjɨke. Áánetu tsaatékée o állíñe pevétsííyé o áhdótsohíjcyáné ó óómíchoó éhnííñevújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Tehdújuco, muurá Aavaráaúvúj tsɨɨménémúhaabe u íjcyáábedívú tsúúca uwááboju wajtsɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Muuráhjáa Mɨ́amúnáájpidívú o ípívyééveebe o tsáá ímítyúné pañévú mújtámeke o pájtyetétsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ehdúhjáa Jetsóó úwaabó mɨ́amúnáake. Aaméhjáa Jerotsaréevu pɨ́ɨ́hɨ́náa mɨ́amúnaa ɨ́jtsámeí tsúúca Píívyéébé avyéjú bóhówááveíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","Áámekéhjáa úwááboobe nééhií: —Tsaapíhjyáa ɨ́htsútúméejpi íjcyaabe tsícyoomívú ipyééíñé ɨhde 10-meváké íúníu múnáadítyú ipíhjyúcúmeke dsɨ́ɨ́dsɨdívú iwájtúne nééhií: “Ééneri méwákímyeícyó téhulle o íjcyáné hajchóta.” Ehdúhjáa diityéké ipítyájcoíñúne técoomívú memévatéébé íhcyóómí avyéjuube iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Árónáacáhjáa dííbyé cóómi múnaa tsá ímílletú diityé avyéjuube dibye íjcyane. Áánélliihyéhjáa tsaatéké wallóómé dííbye déjutu ditye iñéé íhcyóómí avyéjuube dibye íjcyane múha ímílletúne. ");
INSERT INTO boaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Árónáacáhjáa tsúúca meménúmé páñétúejpi íhcyóómí avyéjuube dibye iíjcyaki. Átsihdyúhjáa óómiibye teene íhcyóómivu. Aabéhjáa iwájtsɨdu pihjyúcú íúníu múnáake dsɨ́ɨ́dsɨdívúu iwájtuíñúmeke múhduná ditye llíyaatétsóné iwáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Áábekéhjáa ímí wákímyeííbyé nétujkénúhi: “Ávyéjuúbej, éhnée óhdivu u pícyoíñúne dsɨ́ɨ́dsɨ́ ó llíyaatétsóhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Áánélliihyéhjáa íavyéjuube néé dííbyeke: “Tehdújuco. Muurá eene múhdurá néérone ímí ú tehméhi. Áánéllii uke ó pícyoó 10 coomívá avyéjuube u íjcya ɨ́mɨáábé u íjcyánélliíhye.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Áhduréhjáa tsijpi nééhií: “Ávyéjuúbej, éhnée óhdivu u pícyoíñúne dsɨ́ɨ́dsɨ́ téhdure ó llíyaatétsóhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Áánélliiyéhjáa idyé neebe dííbyeke: “Tehdújuco. Áánéllii téhdure ɨ́mɨáábé u íjcyáábeke ó pícyoó 5 coomívá avyéjuube u íjcyaki.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Áánetúhjáa tsijpi nééhií: “Ávyéjuúbej, íñe dɨdsɨ́ɨ́dsɨ́ éhnée óhdivu u pícyoíñúné o pícyohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ópée ó waajácú ímítyuube u íjcyaabe díwákimyéí hallúvujɨ́ɨ́ dsɨ́ɨ́dsɨ́jɨke ú ékéévehíjcyáne. Muuráhjáa ɨ́htsútúnetu o llíyaatétsóné ɨ́mɨátsíí ú újcúiyáhi. Aanée o wáájácúne íllure ó picyóó dɨdsɨ́ɨ́dsɨke.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Áánélliihyéhjáa íavyéjuube néé dííbyeke: “Aanée idyé ímítyuube o íjcyane wájácú u néébe ¿ɨ́veekí tsá u pícyootú dsɨɨdsɨ téhmémeíhíjcyájá pañévú tétsihvu ditye wákímyeíchóné óóma llíyaatéíyoki? ¿Ɨ́veekí ímítyuube uú?” ");
INSERT INTO boaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ehdúhjáa dííbyeke iñétsihdyu tétsihyi íjcyámeke neébe: “Áánúdityu eene dsɨɨdsɨ medójtúcúne maájcú eenée ihñe pámé ehnííñevúré llíyaatétsóóbeke.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Áánélliihyéhjáa nééme dííbyeke: “Ávyéjuúbej, árónáa tsúúca mítyanéjuco dííbye dsɨ́ɨ́dsɨ.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Áánélliihyéhjáa neébe: “Ehdu múúne mémeenúhi. Muurá ihñe llíyaatétsómeke éhnííñevu tsiiñe máajcú ditye illíyaatétsoki. Áánetu pevénéré pícyohíjcyámedítyú médojtúcúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Téhdure eene avyéjuube o íjcyane iímíllétúne oke múnáátsohíjcyámeke ííllevu metsíváne o ɨ́ɨ́ténáa médsɨ́jɨvétso.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ehdúhjáa diityéké iúwáábóné boone Jetsóó péé ímamyémuma Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Aaméhjáa úújeté Bepajéema Betáániá coomícyú úníuri oríívo bájú íjcyátsihvu. Átsihdyúhjáa míítyétsikye ímamyémudítyú ɨ́pɨɨhɨ́ré coomívú iwáállóómútsikye neébe: —Cána écoomi ɨ́pɨɨhɨ́ré cóómityu óóma méujcúté íayáne ɨ́ɨ́júwúukej. Múikyé dííbyedi úllétuube dóhjɨ́váábeke metsíñaáyóne métsívaco. ");
INSERT INTO boaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aane tsaate ámúhtsikye ‘ɨ́véébeké ámuhtsi métsíñaáyó’ néhajchíí méneéco: “Ávyéjuubéne múhtsikye néénélliíhye.” ");
INSERT INTO boaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ahdújucóhjáa péémutsi dibye néhdújuco úújeténé dííbyedívu. ");
INSERT INTO boaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Áábekéhjáa dityétsí tsíñaáyórónáa áábájajte nééhií: —¿Ɨ́véébeké ámuhtsi métsíñaáyóhi? ");
INSERT INTO boaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Áánélliihyéhjáa neemútsi: —Ávyéjuubéne múhtsikye néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aamútsíhjyáa tsajtyéjucóó dííbyeke. Áábé hallúhjáa wájyamúúnevu ɨɨ́hbóne Jetsóoke nérijcyáróme. ");
INSERT INTO boaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Áijyúhjáa dibye péijyu juuva mɨ́amúnaa ɨhbó íwajyámuunévu. ");
INSERT INTO boaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","Aaméhjáa dííbyeke úraavyémé tsúúca oríívó bajúvú pɨ́ɨ́hɨme méénúráítyuróné dibye méénuhíjcyáné hallúvú Píívyéébeke dúúruvámé kéévánécoba wáñécohíjcyá: —¡Ñóóooj! Átsihdyúhjáa nehíjcyáme: —¡Maímijyu áánu Píívyéébe mémeri tsááneéj! ¡Ahdícyane metsu ímíjyuuri Píívyéébeke maávyéjújtsoki! ");
INSERT INTO boaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ehdúhjáa ditye néénáa tsaate paritséómú diityé pañe íjcyame néé Jetsóoke: —Ávyéjuúbej, aatye díuráávye múnáake duhba ditye cúúvéhulléré iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Árónáacáhjáa neébe: —Muurá ditye dáíívyérónáa néwayúúneréjuco íhjyúcunúiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aabéhjáa tsúúca Jerotsarééj pɨɨhɨ́vú ímamyémuma úújetéébé tétsihdyu técoomi ɨɨ́ɨ́téne kímoovéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Áánemáhjáa neébe: —Múhdutú ihdyu ámuha Jerotsarée múnaa méwaajácúiyá Píívyéébema ámuha tsaímíyé meíjcyáiyóné íjcyájúcooróne. Árónáa tsá tene ámúhadívú bóhówáávéityú ámuha mecáhcújtsótúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Muurá ámúhakye ímityúné pájtyeéhi. Ámúhá munáá ámúha cóómí ɨmɨ́cáávéne ámúhakye méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aame ámúhakye ɨdsɨ́jɨ́vétsóne páneere ámúhá jaaháñé wácávyáhcoó Píívyéébe ámúhakye pɨ́aabójúcooróné ámuha metáhjállehíjcyáné déjúcotu. Ehdúhjáa neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Aabéhjáa duurúvájá pañévú iúcáávéne náhjɨ́hénújcatsímyeke téjá pañétu ibóáyóne nééhií: —Muurá Píívyéébé waajácúháámɨtu nééneé: “Íjya tahjya tééjá lliiñévú mɨ́amúnaa óóma íhjyúvahíjcyáijya.” Aaja ¿ɨ́veekí ámuha naní múnáá jaríyéjuco medíllone? ");
INSERT INTO boaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aanéhjáa paíjyuváré tééjá pañévú dibye úwaabóné tsaríllehíjcyámé llúúvájté avyéjujtee, taúhbájú uwáábojtee, tsijtye avyéjujtee, íjcyame. Aaméhjáa ɨ́tsámeíhijcyá ɨ́ɨ́né hallútú dííbyeke ɨdsɨ́jɨ́vétsóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Árónáacáhjáa tsá ɨ́ɨ́né hallútú ditye dííbyeke méénúítyuró mítyaméhjáa ímí dííbyé uwáábó ɨ́jtsúcunúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Aabéhjáa Jetsóó duurúvájá pañévú pajtyéteju úwáábónáa llúúvájté avyéjujtee, taúhbájú uwáábojtee, túkevéjtsojtee, íjcyame itsááne dííbyeke nééhií: —¿Aca múúbé ɨhtsúturí u íjcyaabe eene ehdu nénehjɨ ú méénuhíjcyáhi? Cána múúhakye duubállej. ");
INSERT INTO boaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Áánélliihyéhjáa neebe diityéke: —Áyu cána téhdure ámúhakye ó díllone oke máañújcuj. ");
INSERT INTO boaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Acáa múha nééjuri Jóááuvu tsótsohíjcyá cáhcújtsómeke? ¿A Píívyéébépeé, mityá mɨ́amúnaárée nééjuri? ");
INSERT INTO boaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Áánélliihyéhjáa tsamééré néjcatsíhi: —Muurá ‘Píívyéébée nééjuri tsótsohíjcyaábe’ menéhajchíí meke nééíyoóbe: “Áábekéráhjáa ¿ɨ́veekí tsá ámuha mecáhcújtsotúne?” ");
INSERT INTO boaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Áánetu ‘mɨ́amúnaárée nééjuri’ menéhajchíí meke diitye mɨ́amúnaa tééné hallútú dsɨ́jɨ́vétsóiyá néwayúúnevu iáámúneri. Muurá paméváré cáhcujtsó ɨ́mɨáánéjucóo Píívyéébé ihjyú uubálle múnáajpi diibye Jóáa íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ehdúhjáa nééneri iñúhnévéne nééme iwáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Áánélliihyéhjáa Jetsóó néé diityéke: —Aanéjɨ́ɨ́va idyé ámúhakye ó úúbálleé múúbé ɨhtsúturí o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Téhduréhjáa tsiiñe úwááboobe nééhií: —Tsaapíhjyáa íúmɨhe bajtsó tsanééré óóvaá. Ápallívúhjáa tsaatéké ityéhmétsoíñúne peebe tsiéllevu tsúúcaja téhulle iíjcyáíhullévu. ");
INSERT INTO boaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Áhullétúhjáa tsúúca tépalli néévane iwáájácútsihvu wálloobe íúníu múnáájpikye dííbyema ditye iwállóóro téénetu dííbye éhné íjcyadúne. Ahdújucóhjáa pééróóbeke ditye méénúpéjtsónetu dibye óómiñe íéveébe. ");
INSERT INTO boaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Áánélliihyéhjáa tsíjpiikye dibye wállóóróóbeke téhdure iúhbáne méénúpejtsóme. Aabéhjáa idyé oomí íéveebére. ");
INSERT INTO boaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Áróné pañéhjáa tsíjpiikye dibye wállóóbeke téhdure ditye túúvátsónetu ílluréjuco dibye wááneé. ");
INSERT INTO boaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Áánéhjáa diibye úmɨhé aabájaabe nééhií: “¿Aane muhdúí íñe teéne? Áyu cána hájchíwu mítyane o wájyúróóbekéréjuco o wálloókij. Dííbyeke íhya avyéjúúlléiyóme.” ");
INSERT INTO boaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ehdúhjáa iñééne íllíkyeréjuco dibye wállóóbeke iájtyúmɨ́ne néjcatsímye: “Aabye muurá íllíyéjuco íñe cááníñúiyóne. Áánéllii metsu dííbyekéréjuco medsɨ́jɨ́vétso mehnéréjuco tene iíjcyaki.” ");
INSERT INTO boaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ahdújucóhjáa tétsihdyu kémuéllevu itsájtyéébeke ditye dsɨ́jɨ́vetsóne. Ehdúhjáa Jetsóó iúúbállétsihdyu nééhií: —¿Aane íñe diibye tépallí aabájaabe itsáácooca muhdú méénuú diityéké eenée íúmɨhévú dibye téhmétsoíñúmé ímityúné dárɨ́ɨ́vémeímyeke? ");
INSERT INTO boaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Muurá diityéké tééné hallútú ɨdsɨ́jɨ́vétsóne tsíjtyekéréjuco dibye téhmétsoíñé tépallívu. Ehdúhjáa Jetsóó néénéllii tétsihyi íjcyame nééhií: —Óvíi ihdyu Píívyéébe múúhakye tehmé tehdu muha meíjcyátuki. ");
INSERT INTO boaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Áánélliihyéhjáa Jetsóó diityédívú ɨɨ́ɨ́téne nééhií: —¿Aca muhdú nééiyóné Píívyéébé waajácúháámɨtu íllu nééhií: Tsaúpe nééwayu jááháñé wákimyéi múnaa iñéhnílléne waagóórou pícyámeí ímichi tééutu jaa éjkéiu? ");
INSERT INTO boaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aane muurá teeu nééwayúdú o néébé uwááboju cáhcújtsotúmé mújtaáhi. Áámedívú o cáyobáávatécooca ílluréjuco ditye wágóóóveíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ehdúhjáa Jetsóó taúhbájú uwáábojtémá llúúvájté avyéjujtéké múu lléboobódú úwaabóné iwáájácúne imíllerómé téijyúré dííbyeke iékeevéne. Árónáacáhjáa íllityémé mɨ́amúnáadi. ");
INSERT INTO boaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aaméhjáa ɨ́mɨáámédú tsaatéké dííbye éllevu wallóó ditye dííbyeke ávyéjúúbedítyú díllone dibye múhdurá áñújcúhajchíí tééné hallútú dííbye éllevu itsájtyéroki. ");
INSERT INTO boaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aaméhjáa neeté dííbyeke: —Uwááboóbej, muha muurá méwaajácú tehdújuco u úwáábohíjcyáné keená Píívyéébe mɨ́amúnáadívú tújkevééllejɨ́jtó tsijtye múhdurá úhdivu ɨ́jtsúcunúróneri ɨ́ɨ́cúvétuubére. ");
INSERT INTO boaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aabe cána múúhakye diñe díicyánéjcutuj: ¿A tehdújuco ávyéjuube romáánómuube íjcyáábé wáábyuta dsɨ́ɨ́dsɨke ditye áhdótsohíjcyáné maáhdóiyóne, mityá tsáhaáj? ");
INSERT INTO boaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Ehdúhjáa ímityúné ɨɨ́jtsámeíñemáyé ditye nééne Jetsóó iwáájácúne néé diityéke: —¿Ɨ́veekí ehdu ámuha oke médárɨɨvéhi? Áyu cána oke méuujétsó dsɨ́ɨ́dsɨjɨ́vuj. Ahdújucóhjáa ditye úújétsojɨ ɨɨ́ɨ́téne neébe: ¿Aca múhúmɨ náávé eéne? Áhdure ¿mumémé eene tééjɨtu? Áánélliihyéhjáa néémeé: —Tséétsá húmɨ nááve. Áábe méméré íñe tééjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Áánélliihyéhjáa Jetsóó néé diityéke: —Ané wa ihdyu diibye Tséétsáke mááhdohíjcyá dííbye éhnéjuco íjcyanévu. Áánetu ihdyu Píívyéébeke máácuhíjcyá dííbyé wáábyuta íjcyanévu. ");
INSERT INTO boaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ehdúhjáa dííbyeke dárɨ́ɨ́verómé tsá píívyetétú dííbyedívú iñéétsóiyóne. Aaméhjáa ehdu dibye nééneri iúllévenúne tsá ɨɨná íhjyuvájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ááné boonéhjáa tsadotséómudítyú tsaate péé dííbye éllevu medsɨ́jɨvémé tsiiñe mebóhɨɨne cáhcújtsotúme. ");
INSERT INTO boaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aaméhjáa néé dííbyeke: —Uwááboóbej, Moitséeúvúhjáa muurá néé tsaapi méwadívú tsɨ́ɨ́mávátuube dsɨ́jɨ́véhajchíí íñahbéréjuco díílleke táábávaíñe dííbyeréjuco ɨtsɨ́ɨ́máva díílledívú íñáhbeúvúu tsɨ́ɨ́máváiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aanée ijcyámé 7-meva tsané nahbému. Áámedítyúu ámíaabe ityáábávárólléjtane dsɨ́jɨvé tehdu tsɨ́ɨ́mávátuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ááné boonée bóneebe díílleke táábávároobe téhdure dsɨ́jɨvé tsɨ́ɨ́mávátuubére. ");
INSERT INTO boaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ááné boonée tsijtye bónejte díílleke táábávarómé téhdure dsɨ́jɨvé tsɨ́ɨ́mávatúme. ");
INSERT INTO boaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ááne nihñévúrée díílleréjuco dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aane cána múúhakye diñe ¿cáábyé taabá ímichi dille íjcyaíñé tsiiñe ditye bóhɨ́ɨ́coóca? ");
INSERT INTO boaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Áánélliihyéhjáa Jetsóó néé diityéke: —Muurá ihdyu ííñújɨri íjcyame táábávácatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Áánetu ɨ́mɨáámé dsɨ́jɨvémé tsiiñe bóhɨɨme níjkyéjɨri iíjcyácooca tsáhájuco táábávájcatsíityúne. Tsíhdyuréjuco ditye íjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aame tsáhájuco dsɨ́jɨ́véityú Píívyéébej tsɨ́ɨ́mé íjcyame níjkyéjɨ múnaáduréjuco néémeé. ");
INSERT INTO boaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muurá ɨ́mɨááné dsɨ́jɨvémé tsiiñe bóhɨɨ́hi. Muuráhjáa Moitséeúvú teene úúballé úméhéwu péétécunúné pañétú Píívyéébe dííbyeke íllu nééneé: “Aavaráaa, Itsáaa, Jacóóboo, íjcyámé Piivyéébé ó ijcyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ehdúu Píívyéébe néénetu méwaajácú ditye íjcyane. Muurá ditye íjcyátuca tsá dibye nééítyuró diityé Piivyéébé iíjcyane. Muurá dííbyedívú tsá múha dsɨ́jɨ́vetú tétsɨ́hjɨ́ daíhañe. ");
INSERT INTO boaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ehdúhjáa diityéké dibye néénéllii tsaate taúhbájú uwáábojtédítyú nééhií: —Uwááboóbej, tehdújuco u nééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aaméhjáa tsáhájuco dííbyeke tsiiñe díllotúne. ");
INSERT INTO boaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Áijyúhjáa idyé Jetsóó néé diityéke: —¿Aca muhdú ɨ́ɨ́vane ámuha ménehíjcyá Críjto Dabíiúvúj tsɨɨménémúhaabe íjcyaíñe? ");
INSERT INTO boaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ááneráhjáa dííbyeúvú íjcyároobe dííbyedítyú néé íwaajácuháámɨtu: Ávyéjuubée néé Táavyéjúúbeke: “Cána táúniúvúi diicya dímunáake o táhjáné hajchóta.” ");
INSERT INTO boaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ehdúhjáa muurá Dabíiúvú dííbyeke Íavyéjúúbedi dillóhi. Aane ¿muhdú dííbyeúvúj tsɨɨménémúhaabe íjcyáiibye Críjtoó? Ehdúhjáa Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aabéhjáa pámeere lléébónáa néé ímamyémuke: —Téɨɨbúwá tsáma méíjcyaco. ");
INSERT INTO boaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tsá múu ɨ́ɨ́vatú eene aatye taúhbájú uwáábojte mɨ́amúnaa diityéké iávyejúúllekíyé cááméjácobájɨvu úcámeíhíjcyánetu. Muurá pihcyáávejááné pañe imíllémé íboohówátsɨhjɨ́vúré iácuuvéne. Áhdure wañéhjɨ pañe imíllémé íimítsɨhjɨ́vúré imájchone. ");
INSERT INTO boaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aame pííbájyujte walléémudítyú dótuhíjcyá diityé jaaháñe. Ááné nucójpɨ́ muurá cááménécóbaúvú ihjyúvahíjcyarómé Píívyéébema. Ehdu muurá dárɨ́ɨ́vémeímyeke Píívyéébe ɨ́cúbáhraáhi. Ehdúhjáa Jetsóó néé ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Aabéhjáa duurúvájá pañe íjcyánáa mɨ́amúnaa picyóócunú dsɨ́ɨ́dsɨke Píívyéébé wáábyuta. Ehnéva múnaáhjáa mítyanéhjɨ́ picyóóhií. ");
INSERT INTO boaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Áánáacáhjáa pííbájyulle ɨ́dátsó picyóó mɨ́jɨ́hwuúcúre. ");
INSERT INTO boaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aanéhjáa ɨɨ́ɨ́téne neébe: —Ámuúhaj, muurá áámye pííbájyulle ɨ́dátsó néérolle picyóó pámé ehnííñevúre. ");
INSERT INTO boaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Muurá tsijtye dsɨ́ɨ́dsɨ́varómé picyóó uhjénéhjɨ́re. Áánetu pícyoolle páneere tééne tájpí iíjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Téijyúhjáa tsaate ímamyémudítyú ihjyúvá duurúvaja imíwu néwayúúnetu méénúmeíñeri, ditye bóhbánuhíjcyánéhjɨtu imíwu teja ícyáávétsámeíñéhjɨri. ");
INSERT INTO boaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Áánélliihyéhjáa Jetsóó nééhií: —Ároja muurá wácávyáhcáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ehdúhjáa dibye néénéllii dííbyeke néémeé: —Uwááboóbej, ¿aca múijyú pajtyéiñe eene múúhakye u néhíjcyanéhjɨ? ¿Aca ɨ́ɨ́netú muha méwaajácuú tsúúca tehdu tene pájtyeíñe? ");
INSERT INTO boaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Áánélliihyéhjáa neébe: —Ehdu nééme tsáma wajácútsi méíjcyaco ámuha maállítsámeítyuki. Muurá o tsááiñe tsúúca pɨ́ɨ́hɨ́cooca íjcyaímyé mítyame óhdi díllómeímye. Aame nehíjcyaá diibyéjuco Críjto iíjcyane. Árómeke mécáhcújtsodíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Téhdure pahúlleváré méénujcátsí íjcyáné uubállé ámuha mellééboóhi. Áróneri méíllityédíñe. Pane méɨjtsúcunúdí téijyu tsúúca o bóhówááveíñe. Tsáhái téijyu o bóhówáávéityúne. Árónáa ihdyu ehdu nénehjɨ tujkénú pájtyeéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Muurá tsáné iiñújɨ múnaa tsííñé iiñújɨ múnáama méénújcátsiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Áhdure ávyétá ɨhnáhó ííñujɨ vááúméiíhi. Áijyu íjcyaíñé ájyabááne, cheméháñé, pahúlleváre. Áhdure íévéhoowávú apííchó nénehjɨ bóhówááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ehdu nénehjɨ pájtyéíñé ɨhde cáhcújtsotúmé ámúhakye ɨɨ́cúbáhrámeke tsájtyeé pihcyáávejááné pañévú muhdú ámuha meícyahíjcyáné ámúhakye idílloki. Áhdure ámúhakye ííñújɨ́ avyéjujté éllevu itsájtyémeke cuvéhoojánuímye. Ehdu muurá ámúhakye mɨ́amúnaa dárɨ́ɨ́veé oke ámuha meúráávyéné déjúcotu. ");
INSERT INTO boaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ááné hóówari ámuha táuwááboju diityéké méúwááboóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Árónáa ihdyu tsá ámuha meíjyácunúityú muhdú ámuha diityémá meíhjyúváíñeri. ");
INSERT INTO boaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Muurá ihdyu ámúhakye ó ájcuú muhdú ámuha diityéké meúwáábóíñé tujkévejúvu. Áijyu ámúhakye múnáátsohíjcyámé íllure ámuha maálliñe néhijcyámé ámúhadívú táhjátsáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Muurá ámúháj caanímú, ámúhá nahbémú, ámúha hájkímú, tsijtye ámuha menáhbévahíjcyároméhjɨ́ ámúhakye téijyu ímityúné dárɨ́ɨ́veéhi. Muurá tsaatéké ámúhadítyú dsɨ́jɨ́vétsoímye. ");
INSERT INTO boaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ehdu muurá oke cáhcújtsotúmé ámúhakye tsarílleé oke ámuha mecáhcújtsóné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Árónáa tsá ámúhá níwáujɨ́ɨ́né íjcyárónetu tsájɨ́ubáré wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ahdícyane ihdyu ámuha panéváré maáábúcúhajchíí mépájtyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Áhdure tsííñé iñújɨ́ɨ́ne múnaa Jerotsaréé mɨ́caavéné ámuha mewáájácúcooca múu néé tsúúca técoomi wágóóóveíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Áijyu méwáácunúcó cáméhbaúnevu Jodéá iiñújɨ múnaa ámuha meíjcyame. Áhdure técoomí múnaa óvíi néhi wáácunú tsiéllevu. Aane íúmɨhé pañe íjcyame íoomíjyúcohdí técoomívu. ");
INSERT INTO boaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ehdu íjcyaíñé ɨ́cúbáhraméí mɨ́amúnáama ditye ímityúné dárɨ́ɨ́vémeíhíjcyáné déjúcotu Píívyéébé waajácuháámɨtu tene némeídyújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Máɨdáátsoju tsáma tene pájtyeíñé téijyu walléémú éévájtema tsijtye ñohñójtéréi ɨ́ɨ́tsɨ́ɨ́méwuúmú íjcyámeke! Muurá ávyétá kimóhcó nééné ɨ́cúbáhraméí pájtyeé téijyu ííñújɨri íjcyáné mɨ́amúnáadívú Píívyéébe cáyobáávatécoóca. ");
INSERT INTO boaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tsaatéké muurá dsɨ́jɨ́vétsoímyé méénujcátsí pañe. Áánetu tsíjtyeke tsajtyéimye tsíñéhjɨ́ iñújɨɨnévu. Ááné boone jodíómú íjcyátúné mɨ́amúnaáréjuco teene Jerotsaréé cáávácuíñé Píívyéébe diityédívú técoomi ɨ́hvéjtsóné hajchótá tétsihyi iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aane ehdu nénehjɨ pájtyéné boone nuhba cóójɨ́ejpii, péjcóejpii, mɨ́ɨ́curuu, íjcyane múhduréjucó íjcyaíñe. Téhdure ávyétá ɨhnáhó móañe nóhjɨ́neri cáhcújtsotúmé íllítyeéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Éhdúcóbaúvú nénehjɨ ííñújɨri íjcyácooca muurá mɨ́amúnaa iíllityéneri ílluréjuco wájácúrátúúúveíñe. Ehdu páneere íévéhóówari ɨ́htsútunéhjɨ́ íjcyane mujtáraba íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Áijyu ihdyu Mɨ́amúnáájpidívúu o ípívyééveebe páneere táɨhtsútú táavyéjuma ojtsó pañétú ó bóhówááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ehdu tene pájtyécooca múu íllure ímíjyuuvéhi. Muurá tééné boone tsúúca ámuha máállíjchuú múhdurá ámuha meícyahíjcyánetu. Áijyu ihdyu tsaímiyéjuco ámuha meíjcyaíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Téhduréhjáa tsiiñe diityéké neébe: —Cáhawáá méɨjtsúcunu higyééráhema tsííñé uméhééné muhdú íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Muurá téhehjɨ béhjɨ́vácooca tsúúca méwaajácú píjcyaba pɨ́ɨ́hɨne. ");
INSERT INTO boaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ahdu ííñújɨri ténehjɨ íjcyácooca méwaajácuco tsúúca Píívyéébé avyéjú bóhówáávéíñe éévé úújeténe. ");
INSERT INTO boaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aane ɨ́mɨááné ámúhakye o néé ehdu nénehjɨ pájtyeíñé íñéi ííñújɨri páhdure mɨ́amúnaa íjcyápíñáaáca. ");
INSERT INTO boaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Muurá ííñújɨma páneere íévéhóówari íjcyanéhjɨ́ wágóóóveéhi. Áánetu íñe ámúhakye o néhijcyáné tsá múijyú wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Áánéllii tsáma téɨɨbúwá méíjcyaco tsiiñe o tsáábe ámúhakye o túvaaóvátu llíyiicyáveháñeri, tsíñéhjɨri, ámuha meíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Muurá iímillédúré íjcyámeke ó ábájɨ́néjcuú éhne múúne iyáábeke dahpe ábájɨ́nejcúdu. ");
INSERT INTO boaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Áánéllii múu téɨɨbúwá iíjcyáne Píívyéébema paíjyuváré ihjyúvá ténehjɨ ámúhakye imújtátsótuki. Áijyu ihdyu ámuha méúújéteé óhdivu Mɨ́amúnáájpidívúu o ípívyéévéébedívú ɨ́ɨ́nerí núcójpɨ́vetúme. ");
INSERT INTO boaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ehdúhjáa Jerotsaréeri íjcyaabe Jetsóó duurúvájá pañévú úwáábohíjcyáhi. Aabéhjáa meííjyunúdú pehíjcyá oríívo bájú íjcyátsihvu tétsii icyúwaki. ");
INSERT INTO boaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aanéhjáa paíjyuváré cúúvénetúré mɨ́amúnaa pehíjcyá duurúvajávú dííbyé uwáábó illéébúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Téijyúhjáa pajtyété wañéhjɨ́ óórítyúne pááá máchómeíhíjcyáné wañéhjɨ́ lleeváríjyuco íjcyánáa llúúvájté avyéjujtémá taúhbájú uwáábojte ɨ́jtsámeí muhdú Jetsóoke ɨdsɨ́jɨ́vétsoíñe. Árónáacáhjáa íllityémé mɨ́amúnáadi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Áánáacáhjáa Jóóda Ijcarióóté pañévú tsúúca Naavéné úcaavé tsaapi Jetsóó mamyémúejpi íjcyáábé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aabéhjáa péé diitye llúúvájté avyéjujtémá duurúvájá tehméjte éllevu diityémá ipítyácójcatsí muhdú dííbyedívú iékéévétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ááneríhjyáa iímíjyúúvéne imíllémé dííbyeke iáhdone. ");
INSERT INTO boaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Áánélliihyéhjáa ɨ́jtsámeíjyúcoobe mítyane mɨ́amúnaa íjcyátútsihvu dííbyedívú iékéévétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aanéhjáa tsúúca teene pajtyété wañéhjɨ́ óórítyúne pááá máchómeíhíjcyáné wañéhjɨ́ pañe tsájaatsá múnaa obééjake dsɨ́jɨ́vétsohíjcyáné wañéhjɨ́ lleevájucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Áijyúhjáa Péédorómá Jóáámútsikye Jetsóó nééhií: —Mééma mémeenúté wañéhjɨ májchó memájchoki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Áánélliihyéhjáa neemútsí dííbyeke: —¿Aane kiávú ú imíllé muhtsi meméénune? ");
INSERT INTO boaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Áánélliihyéhjáa neébe: —Ámuhtsi Jerotsaréevu mepéémutsi tsaapi llíyííhyori nújpáñújéébedívú meúújetéébema mepééne tééja múnáájpikye méneéhi: “Múúhá uwááboobéne múhtsikye néé kiává íchii tsaho mɨ́jcoho íjcyane tééhó pañévú dibye múúhama pajtyété wañéhjɨ májchó májchóihyo.” ");
INSERT INTO boaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Áánéllii ámútsikye úújétsóiibye córɨ́ɨ́hócoba néého tsúúca ímíbájchómeíhyó cáámééɨ́jɨri íjcyahóvu. Ááhó pañévú méméénuco. ");
INSERT INTO boaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ahdújucóhjáa péémutsi dibye néhdújuco iúújeténe tééhó pañévú méénune majcho. ");
INSERT INTO boaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aanéhjáa tsúúca ditye májchóíñe éévé úújetédú majchójúcoobe ímamyémuma. ");
INSERT INTO boaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Átsihvúhjáa diityéké neébe: —Ímí ó ɨjtsúcunú íñe pajtyété wañéhjɨ májchó ámúhama o májchone nihñéréjuco. Tsúúca muurá ámúhadívú ó dsɨ́jɨ́veéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aane tsáhájuco tsiiñe ámúhama o wáñehjɨ́vatéityú íñe pajtyété wañéhjɨ. Árónáa ihdyu páneere muhdú óhdityu úúbállémeíhijcyáné oke pájtyéné boone tsaméhjɨ́ Píívyéébé avyéjuríyéjuco meíjcyame mewáñehjɨ́vatéiñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ehdúhjáa iñétsihdyu ado iékéévéne téhdújtsoobe Píívyéébeke. Áánemáhjáa neébe: —Áju, íñe pámeere maádo. ");
INSERT INTO boaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Muurá tsáhájuco tsiiñe ámúhama o ádóityú íñe óóvajpácyó Píívyéébé avyéjuri tsaméhjɨ́ meíjcyáiñévújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Átsihdyúhjáa idyé pááaho iékéévéne téhdújtsoobe Píívyéébeke. Áánemáhjáa idyóhdáhɨ́nunévú diityéké iwájtúne neébe: —Íñe tájpi náávé íjcyane memájcho. Ehdu paíjyuváré méméénuhíjcyaco ámuha mepájtyeté o ɨ́cúbáhrámeíñé ámuha meɨ́tsaavéne. ");
INSERT INTO boaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Téhduréhjáa teene adóvú diityéké iájcúne neébe: —Íñe tátyujpácyo náávé íjcyane úúballé muhdú ámuha meícyahíjcyáné pityájcoju tádsɨjɨ́veri tsíhdyuréjuco cápáyóóveíñé ámuha mepájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aane muurá íchihyi mééma majchórí diibye óhdivu méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Muuráhjáa ihdyu tsúúcajátújuco óhdityu tene némeídyújuco oke tene pájtyeíñé Mɨ́amúnáájpidívúu o ípívyéévéébeke. Árónáa ihdyu máɨdáátsoju tene pájtyeíñé eene óhdivu méénútsóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ehdúhjáa Jetsóó néénéllii díllójcatsímyé caabyé diityédítyú dííbyedívú méénútsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Átsihdyúhjáa táhjájcatsímyé caabyé diityédítyú ɨ́ɨhtsútuube íjcyáíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Árónáacáhjáa Jetsóó néé diityéke: —Muurá ííñújɨri ávyéjujte imíllé ityáuhbáné téénetu diityéké mɨ́amúnaa ɨ́htsútujtédí idílloki. Ááne ɨtsúcunúhijcyámé tehdújuco imyéénune. ");
INSERT INTO boaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tsá múu tehdu néétune. Muurá ihdyu ɨdáátsóóbeúvú néébe tsaímíyé tsíjtyeke ɨ́ɨ́cúvehíjcyaabe ɨ́htsútuube ijcyá pámé túkevéjtsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Aca caabyé ɨ́htsútuube ávyéjuúbe? ¿A eene tsaímíyé ácuúcunúúbeke tsaapi majchótú ɨ́ɨ́cúveébe? ¿Mityá eene dííbyeke ɨ́ɨ́cúveébej? Muurá mɨ́amúnaa ɨjtsúcunú eene tsaímíyé ácuúcunúúbeke tsijtye ɨ́ɨ́cúveebe ɨ́htsútuube íjcyane. Áánetu ihdyu eene ɨ́ɨ́cúvehíjcyaabédú o néébe ámúhama ó ijcyá ámúhakye o pɨ́ááboki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Muurá ávyétá imítyú nénehjɨ oke pátyehíjcyárónáa ímí ámuha óóma méijcyá oke ɨ́hvéjtsotúme. ");
INSERT INTO boaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Áánéllii ámúhakye ó picyóó Llihíyóo oke pícyohdu avyéjujte ámuha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Áámema muurá ɨ́ɨ́né imíjyaú ámúhama ménahbévájcátsií táavyéjuri. Aame ámuha ijraéémú 12-hava íjcyámedítyú cáhcújtsótúmema méímíbájchoó muhdú ditye ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ehdúhjáa iñétsihdyu Jetsóó Tsimóoke nééhií: —Tsímoj, Naavéné Píívyéébeke táúmeí ámúhadítyú iñéhco caabyé ɨ́mɨáábé íjcyáábeke éhne múúne tríígotu iímí menéhcodu. ");
INSERT INTO boaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Árónáa tsúúca díhyallúvú ó táúmeí pɨáábó oke u ɨ́hvéjtsótuki. Aabe ihdyu óvíi díñahbémuke ú pɨ́aabó téhdure ditye ímí oke iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Áánélliihyéhjáa neebe dííbyeke: —Tehdújuco, Ávyéjuúbej, ɨ́mɨááné tsá uke o ɨ́hvéjtsóityúne. Muura uke ditye cúvéhoojánúcooca óómájuco ditye meke cúvéhoojánuíñe. Áhdure uke ditye dsɨ́jɨ́vétsócooca óómájuco ditye meke dsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Árónáa muurá, Tsimo, ípyejcójuco oke u úráávyeróné u tóónuíñé cáracái májtsívátúné ɨhde 3-ijyúva. ");
INSERT INTO boaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Átsihdyúhjáa tsiiñe neebe diityéke: —Éíjyúu muurá ámúhakye uwáábovu o wállóócooca o néé ámúha dsɨ́ɨ́dsɨma tsípaajɨ́jɨ́ ámúháj túhápaajɨ́né ámuha metsájtyétuki. ¿A téijyúu tsáneetu ámuha méviióhi? Áánélliihyéhjáa néémeé: —Tsáháa muha ɨ́ɨ́netú mevííotúne. ");
INSERT INTO boaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Áánélliihyéhjáa neebe diityéke: —Árónáa ícyooca métsajtyécó ámúha dsɨ́ɨ́dsɨɨ, ámúhá nɨɨtsúmuu, íjcyane. Áánetu nɨ́tsuwáávatúmé óvíi hállúeja íwajyámú iñáhjɨ́hénúne ɨ́nɨɨtsúwá ujcúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","38","Áánélliihyéhjáa néémeé: —Ávyéjuúbej, íjcyawáácú míwáácu múúhadi. Áánélliihyéhjáa neébe: Íhya téhduwáácújuco. Muurá tsúúca oke pajtyéiñe tsúúcajátújucóo Píívyéébé waajácúháámɨtu íllu óhdityu tene néhdújuco: “Muurá ímítyúmé raahórí itsájtyéébeke téhdure ímítyúúbedi dílloímye.” Ehdúhjáa óhdityu tene némeídyújuco muurá oke tene pájtyeiñe. ");
INSERT INTO boaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ehdúhjáa ímamyémuke iñétsihdyu ipyéhijcyádú oríívo bájú íjcyátsihvu péébema téhdure péémeé. ");
INSERT INTO boaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Átsihvúhjáa iúújetédú neebe diityéke: —Píívyéébema méihjyúvaco ámuha mávaríjchojúúnevu metáhjátsámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ehdúhjáa iñééne ɨ́ɨ́neebe diityédítyú éhne múúne nééwayu maáámune úújeténé hajchóta. Átsihvúhjáa ɨmɨ́móúúvene Píívyéébema ihjyúvaabe nééhií: —Ayúju Táácáániíj, muhdú u néhajchíí óvíjyacóóné o ɨ́cúbáhrámeíñe. Árónáa idyé tsá o ímillédú u méénúityúne. Wa ihdyu muhdú u ímillédú óóma meénuj. ");
INSERT INTO boaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Áábedívúhjáa níjkyéjɨ múnáajpi bóhówaavé dííbyeke ɨpɨ́ááboki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aabéhjáa ɨ́hnáhó tééneri ávyevécunúúbé Píívyéébema íhjyúvaabe tówaane waapé tújpácyoma. ");
INSERT INTO boaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Átsihdyúhjáa ímamyému éllevu péébe úújeté dííbyeke ikímóóvéne pávyeenúmé cuwárí íjcyámedívu. ");
INSERT INTO boaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Áámekéhjáa neébe: —¿Muhdúami ɨ́ɨ́vane ámuha mécuwaj? Maájkyéne méihjyúvá Píívyéébema mávaríjchojúúnevu ámuha metáhjátsámeítyuki. ");
INSERT INTO boaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ehdúhjáa dibye néénáa tsúúca mítyame mɨ́amúnaa wajtsɨ́ tétsihvu. Áámekéhjáa Jóóda tsuullé tsaapi dííbyé mamyémúejpi íjcyaábe. Aabéhjáa dííbyedívú iwájtsɨ́ne chohchócú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Áánélliihyéhjáa neébe: —¿Aca muhdú eene, Joda, oke u chóhchóneri óhdivu ú méénutsó Mɨ́amúnáájpidívúu o ípívyéévéébedívu? ");
INSERT INTO boaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aanéhjáa ɨɨ́ɨ́téne ímamyémú néé dííbyeke: —Ávyéjuúbej, métsu aatyéké meméénu ménɨɨtsúmuri. ");
INSERT INTO boaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Árónáacáhjáa tsúúca tsaapi diityédítyú llúúvájté avyéjúúbé úníu múnáájpí núúmɨho ɨ́mɨánéjcúeho wállórɨhjúcúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Áánélliihyéhjáa Jetsóó néé dííbyeke: —Óvi íjcyaábe. Óvi ihdyu muhdú oke meenúme. Ehdúhjáa néébere cámahjácó dííbyé núúmɨho. ");
INSERT INTO boaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Átsihdyúhjáa llúúvájté avyéjujtee, duurúvájá tehméjtee, túkevéjtsojtee, íjcyámeke neébe: —¿Aca muhdú éhne múúne ímityúné méénuhíjcyáábe éllevu ditye tsáhdu ámuha metsáá taéllevu nɨɨtsúmuma, cávaájcoháñema? ");
INSERT INTO boaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Áánerá íhyajchótá ámúhama duurúvájá pañe o íjcyáábeke keená muhdú ámuha oke meméénuhíjcyáne. Árónáa ihdyu ícyooca tsúúca ámúhaj tééveri Naavéné kyéhéjkímyeíhi. Ehdúhjáa neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Áábekéhjáa tsúúca iékéévéébeke llúúvájté avyéjúúbe jávú ditye tsájtyéébeke Péédoro úráávyeebe pehíjcyá diityé kemúellére. ");
INSERT INTO boaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Áijyúhjáa lláhajtsɨ́vú tsaate icyújuwááñúnetu pɨ́hmɨhíjcyáme élletu téhdure pɨ́hmɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Áánáacáhjáa tétsíí wákimyéi múnáalle pɨhmɨ́rí íjcyáábedítyú nééhií: —Áánúu muurá téhdure Jetsóoma ícyahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Árónáacáhjáa íllure ityóónúne neébe: —Tehdu, muulle, o wáájácúnejɨ́ɨ́ dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ááné boonéwuúréhjáa idyé tsijpi dííbyeke nééhií: —Uu éhne téhdure diityéejpi. Árónáacáhjáa neébe. —Tsáha muúbej, tehdu diityéejpi o íjcyáábejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ááné boonéhjáa idyé tsíjpiiyéjuco nééneé: —Ɨ́mɨááné muurá áánu diibyéjuco Jetsóomáa ícyahíjcyaabe Gariréa múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Áánélliihyéhjáa idyé neébe: —Tehdu, muube, o wáájácúúbedíjɨ́ɨ́ óóma ú ihjyúváhi. Ehdúhjáa dibye néénáa tsúúca cáraca májtsiváhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Áánélliihyéhjáa Jetsóó dííbyeke révoúcunúhi. Áánetúhjáa ɨ́tsááveebe dibyée nééneé: “¿Muurá ípyejco cáracái májtsívátúné ɨhde 3-ijyúvá ú tóónuú oke u úráávyeróne?” ");
INSERT INTO boaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aabéhjáa tétsihdyu áachívú ipyééne ávyétá ɨhnáhó tááhií. ");
INSERT INTO boaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Áánáacáhjáa Jetsóoke téhmeme dííbyedi iúúhɨ́vaténe meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dííbyé hálluúúcúhjáa iwátájcóóbeke iwábáájcóne néémeé: —¿Cána waajácú múha uke méénunej? ");
INSERT INTO boaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Áánemáhjáa éhnííñevúré uuhɨ́vatémé dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Ááné tsɨtsɨ́ɨ́vevúhjáa túkevéjtsojtee, llúúvájté avyéjujtee, taúhbájú uwáábojtee, íjcyame ipítyácócatsíhíjcyátsihvu dííbyeke itsájtyéébeke nééhií: —¿A ɨ́mɨááné diibyéjuco uu mɨ́amúnáake pájtyetétsoóbe? Cána múúhakye duubállej. Áánélliihyéhjáa neébe: —Muurá diibyéjuco o íjcyane ámúhakye o néérone tsá ámuha mecáhcújtsóityúne. ");
INSERT INTO boaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pane ámúhakye o díllone ámuha maáñújcúne oke maácádsɨ́jcaáyokíjɨ́ɨ́va oke médillóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aane cáhawáá óvíi ícyoocátú Mɨ́amúnáájpidívúu o ípívyééveebe ɨ́htsútuube Píívyéébé úníuri ó ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ehdúhjáa dibye néénéllii nééme dííbyeke: —¿Áánélliihyéhaca ihdyu ɨ́mɨááné Píívyéébé Hajchi uú? Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. ");
INSERT INTO boaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ehdúhjáa dibye néénéllii néjcatsímye: —Ɨ́ɨ́nélliihyécó tsijtye éhnííñevu dííbyé hallúvú úúbálléiyáhi. Muurá íñe melléébóneríyé ímityúné ihjyúvaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aanéhjáa páméhcobáré Jetsóoke tsajtyé tééné iiñújɨ́ ávyéjuube Pirááto éllevu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Átsihvúhjáa dííbyé úmɨwávú dííbyedívú iñéétsóro néémeé: —Áánu mɨ́amúnáake ííbórɨ́nuubéré pehíjcyáhi. Nehíjcyaabe meeva ɨ́veekí ávyéjuube Tséétsa romáánómuubéré íjcyáábé wáábyuta dsɨ́ɨ́dsɨke ditye áhdotsóné maáhdohíjcyáne. Téhdure nehíjcyaabe mɨ́amúnáakévá ipájtyetétsoíñe. Áhdure nehíjcyaabe muuhává jodíómú avyéjuube iíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Áánélliihyéhjáa Piráátó néé dííbyeke: —¿Ava ɨ́mɨááné uu jodíómú avyéjuúbej? Áánélliihyéhjáa neébe: —Éée, diibyéjuco oó. ");
INSERT INTO boaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Áánélliihyéhjáa Piráátó néé llúúvájté avyéjujtémá pámeere tétsii tsijtye íjcyámeke: —Áánerá tsá dibye ɨ́ɨ́né imítyúné méénúturóne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Árónáacáhjáa tsɨ́jpánécoba néémeé: —Áánerá pámeere Jodéá iiñújɨ múnáake ííbórɨ́nuubéré pehíjcyá múhdurá iúwáábóneri. Muuráhjáa Gariréá iiñújɨ múnáadítyú tújkénuube íñe téénema íílléjuco tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ehdúhjáa ditye néénéllii Piráátó dilló diityéké ɨ́mɨááné Gariréa múnáajpi dibye íjcyáhajchíí iwáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aanéhjáa téhulle múnáajpíjyuco dibye íjcyane ditye néénéllii wálloobe dííbyeke tééné iiñújɨ́ avyéjuube Heróóde éllevu. Téijyúhjáa téhulle Jerotsaréeri diíbye. ");
INSERT INTO boaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aabéhjáa mítyane ímíjyuuvé Jetsóoke iájtyúmɨ́neri. Tsúúcajájucóhjáa dibye ímílleróné dííbyeke iájtyumɨ́né dííbyedítyú ditye íhjyúvahíjcyáné illéébónema. Imílléroobéhjáa iájtyumɨ́né dibye méénúráítyuróné méénune. ");
INSERT INTO boaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Áánemáhjáa mítyane panéváré dílloobe dííbyeke. Árónáacáhjáa tsá dibye áñújcutúne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Áijyúhjáa idyé tétsihyi llúúvájté avyéjujtémá taúhbájú uwáábojte íjcyame ímityúné dííbyé hallúvú úúballéhi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Áábedíhjyáa diibye Heróódé ítsodáhómuma iúúhɨ́vaténemáyé ujcó ávyéta ímí nééné wajyámuunévú ávyéjuube múúne úcáávéné wajyámuunévu. Áábekéhjáa tsiiñe wálloobe Pirááto éllevu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Téijyúhjáa diibye Piráátoma Heróódemútsí wajyújcatsí ɨ́hdée néhníllécatsíhíjcyáromútsi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aanéhjáa Piráátó pihjyúcú pámeere mɨ́amúnáake llúúvájté avyéjujtémá tsijtye avyéjujtéke. ");
INSERT INTO boaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Áámekéhjáa neébe: —Ámuha íñe áánúke taéllevu métsivá dibyévá mɨ́amúnáake ímítyú dárɨ́ɨ́vehíjcyáné ámuha menéénema. Áábeke muurá íñe ámuha meɨ́ɨ́téneríyé ó dílloráhi. Árónáa tsá dibye ímítyuube íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Muurá Heróódé íjcyároobe tsá wáájácutú ɨ́ɨ́né imítyú dibye méénune. Áánéllii muurá íñe óómíchoobe tsiiñe meéllevu dííbyeke. Aabe ɨ́ɨ́né hallútú dsɨ́jɨ́véíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Áánéllii íllure dííbyedívú o méénútsóne ó ácádsɨ́jcaáyoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ehdúhjáa Piráátó néé paíjyuváré tsáápiikye cúvéhóójari íjcyámedítyú pajtyété wañéhjɨ́ pañe iíchívyétsohíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Árónáacáhjáa pámeere néé kéévánécoba: —¡Tsá muha meímílletú Jetsóoke maácádsɨ́jcaáyóne! ¡Barabáakéré muha méimíllé meíjchívyetsóne! ");
INSERT INTO boaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ácoocáhjáa diibye Barabáake cuvéhoojánúmé ávyéjujtéké dibye ímityúné dárɨ́ɨ́vehíjcyáné hallútu, téhdure dibye mɨ́amúnáake dsɨ́jɨ́vétsohíjcyáné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Aanéhjáa Piráátó Jetsóoke iácádsɨ́jcaáyóné iímílléne tsiiñe diityémá íhjyúvárónáa éhnííñevúré néémeé: —¡Wa ihdyu wátyétyehcútsó páwachékevu dííbyekej! ");
INSERT INTO boaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Áánélliihyéhjáa tsiiñe neébe: —¿Aca ɨ́ɨ́né imítyúné méénuúbe? Keenéiyó o wáájacúné dibye ímityúné méénune tééné hallútú ɨdsɨ́jɨ́véiyóne. Áánéllii ihdyu íllure dííbyedívú o méénútsóne ó ácádsɨ́jcaáyoóhi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Árónáacáhjáa mítyane imíllémé dííbyedívú dibye wátyétyéhcutsóne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Áánélliihyéhjáa awáá diibye Piráátó ílluréjuco dííbyeke ɨ́hvejtsóné diityé hójtsɨ́ pañévú ditye iímillédú imyéénuki. Áánemáhjáa Barabáakéréjuco dibye íjchívyetsóné ímítyuube íjcyánéllii ditye cúvéhoojánúróóbeke. ");
INSERT INTO boaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aaméhjáa Jetsóoke páwachékevu iwátyétyéhcúíhullévú tsájtyeme cábuuvé Tsirééne múnáajpi Tsimóó íúmɨhétú óómííbyedívu. Áábekéhjáa íhbutsómé Jetsóoke iwátyétyéhcúíwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Áijyúhjáa mítyane mɨ́amúnaa Jetsóoke úraavyéhi. Mítyaméhjáa walléémú dííbyeke táámere pééhií. ");
INSERT INTO boaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Áámekéhjáa ɨɨ́ɨ́téne neébe: —Ámuúha Jerotsaréé walléémuj, oke mékímóóvedíñe. Ámuháyé ihdyu mékímóóveméi. Pane ámúháj tsɨ́ɨ́mekéré ihdyu mékimóóve. ");
INSERT INTO boaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Muurá ɨ́cúbáhraméí íjcyácooca ajchímú íjcyáné walléémú ímíjyúúveé ɨtsɨ́ɨ́mávátúneri. ");
INSERT INTO boaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Muurá teene ɨ́cúbáhraméí íjcyácooca muhdú imyéénu mɨ́amúnaa neé muhdícyánéjcurí diityé hallúvú cáméhbaúné úhnóbáiyóné apáhajchíí ɨdsɨ́jɨ́ve ápíchó diityéké tene pájtyéíyóné ɨhdétu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Muurá íñe ɨ́ɨ́né imítyú o méénútúróóbedi óhdi ɨ́cúbahráme. Aaméjɨ́ɨ́ mityáubá ámúhakye ditye méénuíñé awáá múhdurá ámuha menéémeke. ");
INSERT INTO boaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Téhduréhjáa téijyu míítyétsi ímítyúmútsikye tsajtyémé tsaíjyú dííbyema ɨdsɨ́jɨ́vétsoki. ");
INSERT INTO boaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aanéhjáa tsúúca ‘Niwáupáájɨ’ némeítsihvu iúújetétsóóbeke wátyétyehcúmé páwachékevu. Áábé úníutúhjáa panéjcuvátú íjcyáwachékéécutu wátyétyehcúmé diityétsí ímítyúmútsikye. ");
INSERT INTO boaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Áijyúhjáa neebe Jetsóo: —Íjtyédi, Lli, dɨ́daatsóve. Muurá tsá ditye wáájácutú ɨɨná imyéénune. Áánáacáhjáa tsodáhómú néhcójcatsí caatyé dííbyé wajyámúúné újcuíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aanéhjáa mítyane mɨ́amúnaa ɨ́ɨ́tehíjcyánáa ávyéjujte dííbyedi iúúhɨ́vaténe néjcatsíhi: —Tsíjtyeke muurá pátyetétsohíjcyaábe. Aabe cána óvíi pájtyetétsámeí ɨ́mɨááné diibyéjuco Críjto mɨ́amúnáake pájtyetétsóííbyeke Píívyéébe pícyoobe iíjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Áhduréhjáa idyé tsodáhómú dííbyedi iúúhɨ́vaténemáyé bíínójpácyó kiwátyetu dííbyeke íjchoráhi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aaméhjáa néé dííbyeke: —Áyu cána bo pájtyetétsaméí ɨ́mɨááné diibyéjuco jodíómú avyéjuube u íjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Áánemáhjáa dííbyé nííwáú caamééhullétú téwachéketu picyóómé gríéégomuu, romáánómuu, jodíómuu, éhdúmé ihjyúrí íllu icyáátunúne: “Áánu jodíómú avyéjuúbe.” ");
INSERT INTO boaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Áhduréhjáa dííbyé úníutu ímítyumútsí íjcyámútsidítyú tsaapi iúúhɨ́vaténemáyé néé dííbyeke: —Áyu cána bo ɨ́mɨááné diibyéjuco mɨ́amúnáake u pájtyetétsóiibye u íjcyáhajchíí meke pájtyetétsoj. ");
INSERT INTO boaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Áánélliihyéhjáa íñahbéébé néé dííbyeke: —¿Aca tsá eene u íllityú Píívyéébeke? ¿A tsá u wáájácutú máhallúrí ímityúné íjcyane? ");
INSERT INTO boaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Muurá ihdyu tehdújuco meɨ́cúbáhrámeíñé ímityúné meméénuhíjcyáné déjúcotu. Áánetu muurá áánú hallúrí tsá ɨ́ɨ́né imítyú íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ehdúhjáa íñahbéébeke iñétsihdyu neebe Jetsóoke: —Oke ihdyu dɨ́tsááveco díavyéjuri u íjcyácoóca. ");
INSERT INTO boaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Áánélliihyéhjáa neebe dííbyeke: —Tehdújuco. Muurá ɨ́mɨááné uke o néé óóma u íjcyaíñé táavyéjuri. ");
INSERT INTO boaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Téijyúhjáa cójɨ́jpɨɨnétú ííñujɨ ííjyunú cuuvé tujkévevújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tsáhájucóhjáa nuhba ájchutúne. Áijyúhjáa duurúvájá pañétú páñétúétsíí watájcó wájyámúwácoba dóchéreevé tsahdúnéécú apáhajchíí wajɨ́tahnécu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Áánáacáhjáa Jetsóó ávyétá ɨhnáhó íllu wáníjcyámeíhi: —Llíhij, Llihíyoj, oke duúcu. Ehdúhjáa iñééne dsɨ́jɨ́veébe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aanéhjáa tétsihvu ditye téhmétsoobe tsodáhómú avyéjuube teene iájtyúmɨ́ne Píívyéébeke dúúrúvaabe nééhií: —Ɨ́mɨáánéjucóha ihdyu áánu tsá ɨ́ɨ́né imítyú méénuhíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Téhduréhjáa tsijtye tétsihyi íjcyame tééneri itsájúréévéne ílluréjuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Áánetúhjáa dííbyeke náhbévahíjcyámema Gariréatúu dííbyema tsááme walléémú kémuélletúré ɨ́ɨ́tehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Téijyúhjáa íjcyaabe ɨ́mɨáábé Jodéá iiñújɨri íjcyacóómí Arimatéa múnáajpi Jotséé pítyácojcátsi múnááejpi íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aabéhjáa ɨ́tsohíjcyá Píívyéébé avyéjuri iíjcyaíñe. Áánélliihyéhjáa tsá dibye úcáávetú íñahbéjté pítyácojcátsi múnaa Jetsóoke dsɨ́jɨ́vétsóné pañévu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aabéhjáa Piráátoke táúmeí dííbyeúvú ɨɨtémeho icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aabéhjáa téwachéketu iñíítyétsóne wájyámúbari ɨbɨ́ɨ́jɨ́núne cuuú nééwájɨtu béhéjure bóhdómeíhyéjú pañévú tsaatékéi ditye cúúútúhéjú pañévu. ");
INSERT INTO boaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dityéhjáa wáyeéévéjcóójɨ́ ɨhde ímíbájkímeíhíjcyajcóójɨ́ cúúuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aanéhjáa diitye Gariréatúu dííbyema tsááné walléémú ɨ́ɨ́ténáa cúúuúbe. ");
INSERT INTO boaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aaméhjáa ihjyáhañévú ipyééne pácúúcújpacyóné iújcúne wáyéeevéhíi teene wáyeéévejcóójɨ́ Píívyéébé taúhbaju néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","2","Aanéhjáa tsíijyu cúúvénetúré tsííñé tsemáánaréjuco déjúcóóvejcóójɨ́ tsiiñe pééme ɨɨtécunú níkyéhéjú watájcó nééwayu tsítsiíyéjuco ijcyane. ");
INSERT INTO boaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aaméhjáa téhejú pañévú iúcáávéne ɨ́ɨ́terá pevétsíiyéjuco Jetsóó ɨɨtémeho íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ááneríhjyáa iíllityéne wájácúrátúuuvémé ájtyumɨ́ míítyétsi tsɨtsɨ́wu íwajyámúúné néémutsi íjyócuuvévámútsikye. ");
INSERT INTO boaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Áámútsidíhjyáa iíllityéne cáhnóbámeke neemútsi: —¿Aca ɨɨná ámuha níkyehéjú ménehcó tehdu íchii íjcyácóóbekéjɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tsúúca bóhɨɨ́be. Cahawáá méɨtsáávé Gariréaríi ámúhama iíjcyácooca muhdú ámúhakye dibye néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Muuráhjáa nehíjcyaabe Mɨ́amúnáájpidívú ípívyéévéébedívú tsaapi ímítyúmeke ájcume dííbyeke páwachékevu dsɨ́jɨ́vétsóroobe 3 coojɨ́vatu tsiiñe ibóhɨɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ehdúhjáa dityétsí néénetu ɨ́tsaavémé ɨ́mɨáánée tehdu dibye néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aaméhjáa ióómíñe úúbálleté 11-meváréjuco dííbyé mamyémú íjcyámeke. Áhduréhjáa tsíjtyéhjɨke dííbyekée náhbévahíjcyámeke úúballéme. ");
INSERT INTO boaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","12","Aanéhjáa tsá dííbyé mamyémú cáhcújtsotúne. Ɨjtsúcunúméhjáa íllure ditye álliñe. Áánetúhjáa Péédoro dsɨɨnéríyé níkyéhejúvú ipyééne téhejú pañévú iúcáávéne ɨɨté ɨ́mɨááné dííbyekée ditye bɨ́ɨ́jɨ́núné wajyámubááneréjuco téhejú pañe íjcyane. Ááneríhjyáa iúllévenúne ílluréjuco dibye óómiñe. Ílluméhjáa diityéké úúballé dibye tsúúca bóhɨɨ́ne: Maaría Madarénaa, Jóáánaá, tsííñé Maaríá Jacóóbój tsɨɨ́juu, tsíjtyehjɨɨ, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aanéhjáa téijyúré Jetsóó bóhɨjcóójɨ́ dííbyemáa ícyahíjcyámedítyú tsaatétsí péé Jerotsaréetu Emaóovu 11 kiróómetro técoomítyú íjcyácoomívu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aamútsíhjyáa juuváyí íhjyúvamútsíyé pehíjcyá muhdú dííbyeke tene pájtyéneri. ");
INSERT INTO boaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Áánáacáhjáa diityétsidívú bóhówááveebe diityétsimájuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aanéhjáa Píívyéébe diityétsikye íhyálluúúné pívyétéjtsomútsí tsá wáájácutú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Áámútsikyéhjáa neébe: —¿Aca ɨ́ɨ́nerí íhjyúvamútsíyé ámuhtsi metsáhíjcyamútsí muhdú kehdóvémútsiúvu? ");
INSERT INTO boaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Áánélliihyéhjáa ‘Créopa’ némeííbyé néé dííbyeke: —Áánerá pámeere waajácú ɨɨná Jerotsaréeri pájtyene. Aane muhdú úhduubéréjuco tsá u wáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Áánélliihyéhjáa Jetsóó néé diityétsikye: —¿Aca ɨɨná pajtyéhi? Áánélliihyéhjáa neemútsí: —Muurá dsɨ́jɨ́vetsómé Natsarée múnáájpi Jetsóoke ɨ́htsútuube Píívyéébé ihjyú uubálle múnáajpi íjcyaabe panéváré méénuhíjcyáábeke. Áábekée Píívyéébe wájyúúbeke téhdure tsaate mɨ́amúnaa ímí ɨjtsúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Áábekée llúúvájté avyéjujtémá tsííñé avyéjujte ɨ́hvejtsó ditye ɨdsɨ́jɨ́vétso páwachékevu iwátyétyéhcúneri. ");
INSERT INTO boaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Muháa méɨjtsúcunúrá diibyéjuco muha ijraéémuke pájtyetétsóiibye íjcyane. Aane íñe tsúúca 3 coojɨ́vájuco mee dibyée dsɨ́jɨ́vétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Árónáacáne walléémú cúúvénetúré níkyehéjú úújejémé múúhakye néé dííbyé ɨɨtémehóvané téhejú pañe íjcyájúcootúne. Áámedívuváne níjkyéjɨ múnáajtétsí bóhówáávemútsí diityéké néé tsúúca dibye bóhɨɨ́ne. Ááneríñe muha méullévenúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ááné boonétuné idyé tsijtye téheju úújéjerómeváne ɨ́mɨááné tsá ájtyúmɨtúne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Áánélliihyéhjáa neebe diityétsikye: —¡Aca ihdyu eene tsá ámuhtsi mewáájacúpityúne! ¿Aca muhdúikyé ámuhtsi mécáhcújtsoó muhdúhjáa tene pájtyeíñé ɨ́hdéjuco iwáájacúné Píívyéébé ihjyú uubálle múnaa néhijcyáne? ");
INSERT INTO boaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Aca ámuha méɨjtsúcunú mɨ́amúnáake pájtyetétsóiibye ɨ́cúbáhrámeítyuubéré ávyéjuutéiyóne? ");
INSERT INTO boaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ehdúhjáa diityétsikye iñééne úúbálleebe ímíñeúvú páneere muhdúhjáa dííbyeke tene pájtyeíñé tsúúcajátújuco Píívyéébé waajácúháámɨtu dííbyé ihjyú uubálle múnaa cáátúnuhíjcyáne. Moitsééhjáa cáátúnúhaamɨ́jɨ́ pañétú muhdú tene nééne úúbállétujkénuube diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Áánáacáhjáa tsúúca úújetémé Emaóovu ípyée ipyécoomívu. Átsihvúhjáa Jetsóó pítyajcó diityétsikye pééiibyédu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Árónáacáhjáa dííbyeke neemútsi: —Múhtsimáyéi cuwa ípyejcoj. Muurá cúvéhréjuco teéne. Áhdújucóhjáa dibye cóeváné diityétsima. ");
INSERT INTO boaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aabéhjáa diityétsima májchoobe pááaho iékéévéne téhdujtsó Píívyéébeke. Áánemáhjáa tsahdúnéécú idyóhdahɨ́róne ájcuube diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Áánetúhjáa botsíi wájácúméíívyemútsí éhne múu cuwátú ájkyevádu. Aamútsíhjyáa bótsíi dííbyeke wáájácúrónáa tsúúca kiávú peíñuube diityétsidítyu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ááné boonéhjáa néjcatsímútsi: —¡Áyúú, ehdúhacáne ɨ́ɨ́vane juuváyí dibye meke Píívyéébé waajácúháámɨtu íjcyanéhjɨ́ úúballéné ɨ́ɨ́né imíjyaú méɨ́ɨ́búutu meke pajtyéhi! ");
INSERT INTO boaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aamútsíhjyáa teenémáyé tsiiñe oomí Jerotsaréevu páñétúejte dííbyé mamyémuma tsijtye íjcyáme éllevu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Áámútsikyéhjáa népejtsóme: —Ávyéjuubéha Jetsóó ɨ́mɨááné tsúúca bohɨ́jucóóhií. Tsimóodívuva bóhówááveébe. ");
INSERT INTO boaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Áánélliihyéhjáa úúbállemútsí muhdú téhdure diityétsidívú dibye bóhówaavéné juuvávyu. Áhduréhjáa úúbállemútsí dibye pááaho idyóhdahɨ́róne diityétsikye ájcúnetu botsíi dííbyeke iwáájacúne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aaméhjáa tééné úbállejcátsiyi íjcyánáa Jetsóó tsiiñe diityédívú ibóhówáávéne néé diityéke: —Ámuúhaj, o tsájucóóhií. Maímijyu ihdyu ámuha meíjcyanej. ");
INSERT INTO boaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ááneríhjyáa itsájúréévéne íllityémé naavénekéré iwáábyúnema. ");
INSERT INTO boaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Árónáacáhjáa neebe diityéke: —¿Ɨ́veekí ámuha múhdurá meɨ́jtsámeíñe méíllityé oke cáhcújtsotúme?. ");
INSERT INTO boaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Éje, cáhawáá oke meɨ́ɨ́té táhójtsɨ́cuma tájtyúhaácyuj. Muurá diibyéjuco oo Jetsóo. Cáhawáá oke médomájcoj. Muurá naavéné tsá íjpííma íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ehdúhjáa iñééne úújétsoobe diityéké dityée dííbyeke wátyétyéhcunéhjɨ́ íhyójtsɨ́cutu, íjtyúháácyutu, íjcyanévu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ááneríhjyáa ímíjyúúverómé tsá cáhcújtsotúne. Áámekéhjáa neébe. —¿A ijcyáné majcho ámúhadi o májchokij?. ");
INSERT INTO boaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Áánélliihyéhjáa ajcúmé amóóbevííú wáhjámeíñema íímúhójpacyóvu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aanéhjáa ditye ɨ́ɨ́téneríyé idyóóné hallúvú ádoobe teene íímúhojpácyo. ");
INSERT INTO boaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Átsihdyúhjáa neebe diityéke: —Éhnée ámúhakye o néhijcyáné muurá íñe tsúúca oke pajtyéhi. Ehdúu oke tene pájtyeíñé muurá Píívyéébé ihjyú uubálle múnáajpi Moitséé caatúnúhi. Áhduréhjáa tsijtye dííbyé ihjyú uubálle múnaa caatúnúhi. Áhdure Tsááamóháámɨtu caatúváne. ");
INSERT INTO boaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ehdúhjáa dibye néénetu botsíi waajácúmé ɨ́mɨááné tehdújuco Píívyéébé waajácúháámɨtu tene nééneé. ");
INSERT INTO boaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","Átsihdyúhjáa idyé neébe: —Muuráhjáa óhdityu nééne mɨ́amúnáake o pájtyetétsoobe o ɨ́cúbáhrámeíñe o dsɨ́jɨ́veebe 3 coojɨ́vatu tsiiñe o bóhɨ́ɨ́be mémeri táuwááboju Jerotsaréetu tújkeváné páné iñújɨ́ɨ́ne múnáake úwáábómeíiñe, ditye íimítyú ɨɨ́hvéjtsóne Píívyéébé icyánejcúvuréjuco ɨɨ́búwááve diityé imítyú iábájɨ́ɨ́vémeíki. ");
INSERT INTO boaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ááné uwááboju pahúllevávú ámuha métsújaúcuúhi. ");
INSERT INTO boaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Áánéllii ámúha éllevu ó wálloó Llihíyóo Íapííchovu ámúhakye iájcuíñé nééneé. Aane íchihdyu Jerotsaréetúréi météhmeco ámúhá pañévú tene iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Ehdúhjáa diityéké ipítyájcótsihdyu técoomítyú diityémá peebe Betáániávu. Átsihvúhjáa íhyójtsɨcu iíhbúcúne diityé hallúvú pɨáábo ityáúmeíñe diityédítyú péjúcoobe níjkyejɨvu. ");
INSERT INTO boaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ááné boonéhjáa tsiiñe Jerotsaréevu oomímyé ímíjyuuri dííbyeke dúúrúvamére. ");
INSERT INTO boaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aaméhjáa paíjyuváré duurúvájá pañévú duurúvahíjcyá Píívyéébeke. Áyu tehdújuco.");
INSERT INTO boaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iíjcyadúréhjáa ihdyu Críjto ícyahíjcyá ipíívyema íjcyátuube muhdú Píívyéébe íjcyane bóhówájtsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aabéhjáa dííbyere Píívyéébe íjcyaabe ícyahíjcyá páné ɨhdéene íjcyaíñéi íjcyátúnáaáca. ");
INSERT INTO boaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aabéhjáa ípívyejtsó páneere íñe múhduná íjcyane. Tsáháhjáa ɨɨná iiye ípívyéévetúne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Áánéllii dííbyedi ijcyáné múijyú dsɨ́jɨ́véítyúne bóhɨ. Áhdure ijcyáné ɨ́mɨá uwááboju dííbyedi pámeere mɨ́amúnaa tééne tájpí íjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aane peetédú nééne muurá bóhówaúcunú ííñújɨ́ hallúrí mɨ́amúnaa teene wáájácutúmé éhne múúne cúúvétsii íjcyadu néémedívu. Aame tsá píívyetétú teene ɨɨ́hvetétsóiyóne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Aanée íjcyaabe tsaapi ‘Jóáaá’ némeííbye. Áábekéhjáa Píívyéébe picyóó Jetsocríjtó uwááboju peetétú nééne dibye mɨ́amúnáake iúúbálle ditye icyáhcújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Árónáacáa tsá diibye Jóáa Jetsocríjtó íjcyatúne. Muuráhjáa ihdyu dííbyé uubálle múnáajpíyé diíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aane Jetsocríjtodi ɨ́mɨáájú íjcyane tsá álliu íjcyatúne. Áánevúu mɨ́amúnáake iwáájácútso tsaabe ííñujɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aamée mɨ́amúnaa ííñújɨri íjcyame diibye páneere ípívyéjtsóóbeke tsá wáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aabée imúnáállii tsááróóbeke tsá ditye wáátsúcúpéjtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Árónáacáa ijcyámé tsaate ímí dííbyeke iwáátsúcúpéjtsóóbeke cáhcujtsóme. Aame ihdyu ɨ́mɨááné Píívyéébej tsɨ́ɨ́me. ");
INSERT INTO boaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Árónáa tsá íñe mɨ́amúnaa metsɨ́ɨ́mávahíjcyádú meke dibye tsɨ́ɨ́mávatúne. Muurá ihdyu meke dibye ímíbajchómé méijcyá dííbyej tsɨ́ɨ́me. ");
INSERT INTO boaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Muuráhjáa Críjto apáábyéré Píívyéébé Hajchi ɨ́mɨáábé íjcyaabe Mɨ́amúnáájpidívú iípívyéévéne méjpɨɨne úlléjeebe mɨ́amúnáake wajyúhi. Áábé ámɨ́tsaráhcóo muurá máájtyumɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aabée bóhówáávéébedítyú tsojtsó múnáajpi Jóáa nééhií: —Áánúdityu éhne ámúhakye ó nehíjcyá táehnííñevu ɨ́htsútuube íjcyaabe íjcyaíñe. Muuráhjáa ihdyu iíjcyadúré ícyahíjcyaabe ipíívyema íjcyátuube ói o íjcyátúné ɨhdéjuco. ");
INSERT INTO boaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Áábej tééveri Píívyéébe meke pɨ́áábohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Muuráhjáa Moitséeúvuj tééveri méénuube ítyaúhbaju téénetu mɨ́amúnaa iwáájácu muhdú dííbyema iíjcyáiyóne. Áánetúu Jetsocríjtoj tééveri meke iwájyúne ɨ́mɨáájuvu ájcuúbe. ");
INSERT INTO boaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aane muurá tsá múha ájtyúmɨtú Píívyéébeke. Apáábyéré Ílli ájtyumɨ́ dííbyeke. Aabée múúhakye waajácutsó dííbyedívu. Ehdúu Jóáa Jetsóodítyú nééhií. ");
INSERT INTO boaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Téijyúhjáa avyéjujte Jerotsaréetu wallóó llúúvájtema ɨ́pɨáábojtéké tsojtsó múnáajpi Jóáá éllevu ditye idíllo dííbyeke muubá dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Áánélliihyée úúbálleebe muubá iíjcyane. Neebépeé: —Tsá Críjto o íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Áánélliihyée néémeé: —¿Aca ihdyu múúberá uú, mityá Eríá uu Píívyéébé ihjyú uubálle múnáajpíi u íjcyaábej? Áánélliihyée neébe: —Tsáhaá. Áánélliihyée tsiiñe néémeé: —Áánéllii diibyéjuco uu éhneváa Píívyéébé ihjyú uubálle múnáajpi tsááiíbye. Áánélliihyée neébe: —Tsá diibye o íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Áánélliihyée néémeé: —¿Aca ihdyu múúberá uú? Muurá muha méimíllé meúúballéné múúhakyéne wállóómeke muubá u íjcyane. Bo ihdyu múúhakye duubálle muubá u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Áánélliihyée botsíi Jóáa nééhií: —Oo muurá éhne ɨ́ɨ́néubárá píívyétúné iiñújɨri kéévánécóbaúvú o úwááboobe ó nehíjcyáhi: “Méímibáávyé ímityúné ámuha meícyahíjcyánetu tsaímiyéjuco ámuha meíjcyámeke Ávyéjuube iájtyumɨ́vaki.” Ehdúhjáa o úwááboíñé muurá tsúúcajátújuco Píívyéébé ihjyú uubálle múnáajpi Itsaíá úúballéne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ehdúu dibye néénéllii diitye eenée paritséómú dííbye éllevu wálloome néé dííbyeke: —Aanéhaca ¿múha nééjuri ɨ́veekí ú tsótsohíjcyá idyé Críjto u íjcyáábejɨ́ɨ́va, pane Píívyéébé ihjyú uubálle múnáadítyú Eríáuba u íjcyáábejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Áánélliihyée Jóáa nééhií: —Muurá ihdyu ɨ́mɨááné nújpácyori ó tsótsohíjcyá mɨ́amúnáake. Áánetu táehnííñevu ɨ́htsútuube íjcyaabe tsúúca ámúhama íjcyáróóbeke ámuha mewáájácútuube óhdityu cámááveé éhnííñevu iúwááboki. Áábeke muurá tsá íjtyúhápáájɨ́ubáré o tácórɨúcúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ehdúu pajtyéné Betáábarávú Joodáá ehnéjcuvu diibye Jóáa tsótsohíjcyáhullévu. ");
INSERT INTO boaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ááné tsijcyóójɨ́ɨ diibye tsojtsó múnáajpi Jóáa Jetsóó dííbye éllevu péébeke iájtyúmɨ́ne nééhií: —Éje ámuúhaj, áánu muurá obééjádú néébe Jetsóoke Píívyéébe wallóó dibye mɨ́amúnáá imítyuháñé iímíbájchoki. ");
INSERT INTO boaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Áánúdityúu muurá éhne ámúhakye ó nehíjcyáhi: “Táhboone íjcyáiibye táehnííñevu ɨ́htsútuube íjcyaabe óikyée o íjcyátúné ɨhdéjuco ícyahíjcyaábe.” ");
INSERT INTO boaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Téhdurée idyé tujkénú tsá o wáájácutú diibyéjuco meɨ́tsohíjcyaabe dibye íjcyane. Aanée ihdyu ɨ́mɨááné dííbyé ɨhde ó tsótsohíjcyá mee ijraéémudítyú cáhcújtsómeke. ");
INSERT INTO boaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ehdúu iñétsihdyu neébe: —Téhdurée dííbyeke o tsójtsóijyu ó ájtyumɨ́ Píívyéébé Apííchó ɨ́juuúdú cáámetu dííbyedívú níítyene. ");
INSERT INTO boaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aanée téhdure tsá o wáájácúítyuró diibyéjuco meɨ́tsohíjcyaabe íjcyane. Árónáacáa ihdyu Píívyéébe o tsótsohíjcyáiñévú oke pícyoobe oke nééhií: “Tsáápiikye u tsójtsóóbedívú níjkyéjɨtu Táapííchó níítyene u ájtyúmɨ́netu ú waajácuú diibyéjuco mɨ́amúnáá pañévú Táapííchó pícyóóiibye íjcyane.” ");
INSERT INTO boaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ahdújucóo ɨ́mɨááné dííbyeke o tsójtsóijyu o ájtyumɨ́ne. Áánéllii o néé diibyéjuco Píívyéébé Hajchi dibye íjcyane. Ehdúu neebe tsojtsó múnáajpi Jóáaá. ");
INSERT INTO boaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ááné tsijcyóójɨ́ɨ tétsihyíyé muhtsi imámyemútsima dibye íjcyánáa tééneri Jetsóó tsiiñe pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Áánélliihyée tsiiñe neébe: —Éje, aadi muurá obééjádú néébe Jetsóoke Píívyéébe wálloóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ehdúu Jóáa dííbyedítyú néénéllii muhtsi dííbyemáyéjuco mepééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Áánáacáa idyéjú révoúcunúúbé múhtsikye nééhií: —¿Ɨɨná ámuhtsi ménehcóhi? Áánélliihyée muhtsi menééhií: —Uwááboóbej, ¿aca kiá ú ícyahíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Áánélliihyée neebe múhtsikye: —Cáhawáá óóma mepe ámuhtsi mewáájácu kiá o ícyahíjcyáne. Ahdújucóo muhtsi cúvéhréjuco néénáa dííbyema mepéémutsi téhullévú méííjyunúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Muhtsíi Jóáádityu Jetsóomáyéjuco mepééne Tsimóo Péédoró nahbe Aderéema. ");
INSERT INTO boaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aanée diibye Aderéé íñahbe Tsimóoke neetéhi: —Muúbe muhtsi máájtyumɨ́jucóó Críjto mɨ́amúnáake pájtyetétsóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ehdúu iñééne tsajtyéébé dííbyeke Jetsóo éllevu. Áábekée Jetsóó népejtsóhi: —Uu éhne Tsimóó Jonáá hajchi. Árónáa téhdure dimyémé íjcyaá Péédoro ‘nééwayu’ nééiyóne. Ehdúu neebe Jetsóó Tsimóoke. ");
INSERT INTO boaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ááné tsijcyóójɨ́ɨ Jetsóó imíllé ipyééne Gariréá iiñújɨvu. Aabée téhullévú péébe Betsáidá múnáajpi Perípeke iájtyúmɨ́ɨ́beke nééhií: —Muúbe ookéréjuco duráávye. ");
INSERT INTO boaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Téhdurée diityétsí Aderéema Péédorómútsí técoomí múnáajtétsi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Áijyúrée idyé diibye Perípé Natanaée éllevu ipyééne neetéhi: —Muúbej, muha muurá máájtyumɨ́jucóó éhnéhjáa Píívyéébé ihjyú uubálle múnáajpi Moitséeúvú dííbyé taúhbaju icyáátúnuhíjcyáhaamɨ́jɨtu dííbyedítyú cáátúnuhíjcyáábeke. Téhduréhjáa muurá tsíjtyehjɨ Píívyéébé ihjyú uubálle múnaa caatúnú dííbyedítyu. Aabe Jetsóó Natsarée múnáajpi íjcyaabe Jotséé hajchi. ");
INSERT INTO boaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ehdúhjáa Perípé Natanaéeke néénéllii neébe: —¿A ɨ́mɨááne? ¿Aca íhya Natsaréeri ijcyámé tsaate ɨ́mɨááme? Áánélliihyéhjáa Perípé nééhií: —Cáhawáá majo u ájtyúmɨ dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aamútsíi péémutsi úújeténáa Natanaéeke Jetsóó iájtyúmɨ́ne nééhií: —Áánújuco páñétúejpi ijraéémuube ɨ́mɨáábé íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Áánélliihyée Natanaéé néé dííbyeke: —¿Aca kiátú eene oke ú waajácúhi? Áánélliihyée Jetsóó nééhií: —Muuráhjané ihdyu úhdivu Perípé úújetétúné ɨhdéjuco uke o ájtyumɨ́né higyééráhé déjúcori u íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Áánélliihyée Natanaéé nééhií: —Uwááboóbej, uu éhne Píívyéébé Hajchi muuha ijraéémú avyéjuube u íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Áánélliihyée neebe dííbyeke: —Higyééráhé déjúcoríñe u íjcyane uke o néénélliihyéré oke ú cáhcujtsóhi. Mityái éhnííñevu uke o úllévenútsoíñej. ");
INSERT INTO boaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ehdúu iñétsihdyu neebe dííbyeke: —Muurá ɨ́mɨááné ámúhakye o néé Mɨ́amúnáájpidívúu o ípívyéévéébe éllevu cáámetu níjkyéjɨ múnaa iñíítyéne tsiiñe néríívyémeke ámuha maájtyúmɨíñe. Ehdúu Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ááné boonée 3 coojɨ́vatu Gariréá iiñújɨri íjcyacóómí Canáa múnáajpi ityáábáváné wañéhjɨ́ meenú técoomívu. Áánevúhjáa Jetsóój tsɨɨjúké ditye míñútsolle tétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Áhdurée Jetsóoke míñutsómé muuha ímamyémuma. ");
INSERT INTO boaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Áijyúu teene wañéhjɨ ádó bíínojpácyó óúúvénéllii Jetsóoke tsɨɨju nééhií: —Éje, tsúúca bíínojpácyó diityédívú óuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Árónáacáa neebe díílleke: —¿Aanéha, Wa, muhdú ɨ́ɨ́vane oke ú úúballéhi? Tsáhái muurá ɨɨná o méénúíñe éévé úújetétúne. ");
INSERT INTO boaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ááróneríi ɨ́ɨ́cúvétulle tétsíí wákimyéi múnáake nééhií: —Ámúhakye dibye néhdu méméénuco. ");
INSERT INTO boaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Áijyúu ijcyáné tétsihyi 6-hova néwayúúnetu méénúmeíñé lliyíhyóóné téhójɨ́ pañévúu tamúnaa iímíbájchómeííñé nujpácyóóné pícyohíjcyahóhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Áánáacáa tsúúca neebe tétsíí wákimyéi múnáake: —Cána eene llíyihyóóné nújpátyu méwahpétsoj. Ahdújucóo ditye wáhpetsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Átsihdyúu neebe diityéke: —Áyu cána áyánéwu meújcúne báñéjúúbeke meíjchoj. Ahdújucóo iújcúne ditye íjchone. ");
INSERT INTO boaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aanée adúcuube imyéwu nújpacyóo íjcyaróné bíínójpacyóvú dibye ípívyéévétsojpácyo. Aanée tsá dibye wáájácutú kiátú ditye téjpacyo újcune. Apáámyérée tétsíí wákímyéi múnaa waajácú ípyée iñújpáñújénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Aanée báñéjuube wañéhjɨ múnáájpikye ɨpɨ́úváne nééhií: —¿Acáne, muube, muhdú ɨ́ɨ́vane ɨ́mɨájpácyóhacáne íjcyánáa peíyé átérééjpácyotu meke ú ijchóhi? Áánerá múúne tujkénú ɨ́mɨájpácyó meíjchone óuuvédú botsíi ihdícyájpácyotúréjuco meíjchone. Ehdúu neebe íbañéjuube wañéhjɨ múnáájpiíkye. ");
INSERT INTO boaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ehdúu Jetsóó méénúráítyuróné méénútujkénú Gariréari íjcyacóómí Canáavu. Ááneríi waajácútsoobe íavyéjú ɨ́htsutúné íjcyane. Áánetúu muha ímamyémú mécáhcujtsó ɨ́mɨááné diibyéjuco Críjto mɨ́amúnáake pájtyetétsoobe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ááné pajtyétavúu Capenaóovu muha dííbyema mepéémema téhdure pééme tsɨɨ́juu, íñahbémuu, íjcyame. Ácoomíyíi tsúcájá muha méijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aanée pajtyété wañéhjɨ́ llééváíñéllii muha mepéé dííbyema Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Áijyúu duurúvájá pañévú mɨ́amúnaa nahjɨ́hénuhíjcyá ócájímuke, obééjámuke, ɨ́júúmuke. Áánetúu tsijtye dsɨ́ɨ́dsɨke cápáyócócatsíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aanée Jetsóó múhdurá ɨɨ́jtsúcunúne watsíhcyuúúhó imyéénúneri diityéké boáyó tééjá pañétú páneere íñahjɨ́hemájuco. Dsɨ́ɨ́dsɨkée cápáyócócatsíhíjcyámedívú teene wácháájcoóbe. Áánemáa diityé metsáwááné wájójcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Áánetúu ɨ́júúmú nahjɨ́he múnáake neébe: —¡Méijchívyetso íñe páneere íjyá pañétu! ¿Ɨ́veekí Táácááni ja ámuha méípívyejtsó náhjɨ́hejávuréjuco? ");
INSERT INTO boaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ehdúu dibye néénetu muha méɨ́tsaavé Píívyéébé waajácúháámɨtu tene tsátsihdyu nééneé: “Dihjya o wájyúneri ó dsɨ́jɨ́véiyáhi.” ");
INSERT INTO boaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ááné boonétúu tsaate néé dííbyeke: —¿Aca múha nééjuri ehdu ú meenúhi? Cána méénúráítyuróné meenu muha mewáájácu múɨhtsúturí u íjcyaabe ehdu u méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Áánélliihyée neébe. —Cáhawáá íjya duurúvaja méwácavyáhcó 3 coojɨ́vatúré tsiiñe o pánéévétsoki. ");
INSERT INTO boaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Áánélliihyée nééme dííbyeke: —¿Aca muhdú 46 pijcyábáa ditye wákímyeíjyá ú pánéévétsoó 3 coojɨ́vatu? Tsáháubá éhajchótatu u pánéévétsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Árónáacáa ihdyu Jetsóó ihjyúvá dííbyeke ditye dsɨ́jɨ́vétsoíñéré iñééiyóne. Íjpííyée meménuube duurúvajávu. ");
INSERT INTO boaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ehdúu dibye nééne muha méɨ́tsaavé ɨdsɨ́jɨ́vétsihdyu dibye bóhɨ́ɨ́coóca. Áijyúu muha mécáhcujtsó ehdúhjáa dííbyema tene pájtyeíñé tsúúcajátújuco Píívyéébé waajácúháámɨtu cáátúnúmeíñé ɨ́mɨáánéjuco dibye múúhakye néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aabée Jerotsaréeri pajtyété wañéhjɨ́ pañe méénúráítyúronéhjɨ́ méénúnetu mítyame cáhcujtsó ɨ́mɨááné diibyéjuco Críjto íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Árónáacáa waajácuube ɨ́mɨáánetúré dííbyeke ditye cáhcújtsotúné diityé ɨ́jtsaméí ityúhúúllétúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tsáháa múha dííbyeke muhdú mɨ́amúnaa ɨ́jtsámeíñé úúbálléítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Íjcyaabée tsaapi paritséómuube Nicodéémó ɨ́htsútuube íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aabée tsápejco Jetsóo éllevu itsááne néé dííbyeke: —Uwááboóbej, muha méwaajácú múúhá uwáábovúu Píívyéébe uke wálloóne. Aabe úúma íjcyánéllii muurá ú méénuhíjcyá méénúráítyúronéhjɨ́ múha méénúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Áánélliihyée Jetsóó nééhií: —Ɨ́mɨáánetúré uke o néé béhnétu u tsɨ́ɨ́mávámeítyúhajchíí tsá Píívyéébé avyéjúejpi u íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Áánélliihyée neebe dííbyeke: ¿Aca múhdutú keeméjuco meíjcyaabe tsiiñe méétsɨ́ɨ́jú ɨ́ɨ́búwá pañévú méúcáávéiyá dille meke ɨtsɨ́ɨ́máva bɨwáhdúré tsɨ́ɨ́mene meíjcyaki? ");
INSERT INTO boaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Áánélliihyée Jetsóó nééhií: —Ɨ́mɨááné uke o néé Píívyéébé Apííchoj tééveri ímíbaavyémé béhnétu tsɨ́ɨ́mávámeítyúmé tsá dííbyé avyéjúejte íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Muurá mɨ́amúnaa tsɨ́ɨ́mávámé pañe diityé ɨ́jtsaméíyé ijcyáhi. Áánetu Píívyéébé Apííchó ɨ́ɨ́jtsaméí cápáyoácómé ténejcúriyéjuco ɨ́jtsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ahdícyane tsájúréévedí tsiiñe metsɨ́ɨ́mávámeíñé uke o nééneri. ");
INSERT INTO boaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Muurá íñe uke o nééne kííjyebádu. Tsá muurá ámuha mewáájácutú kiátú kííjyeba tsááne kiávú péhijcyáne. Tehdu muurá Píívyéébé Apííchó maájtyúmɨ́turóné meke ímíbajchóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Áánélliihyée Nicodéémó nééhií: —¿Muhdúami íhya tsáma teénej? ");
INSERT INTO boaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Áánélliihyée Jetsóó néé dííbyeke: —¿Aca muhdú ijraéémú uwááboobe u íjcyaabe tsá u wáájácutú uke o nééneé? ");
INSERT INTO boaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Muurá ɨ́mɨááné o ájtyumɨ́né ímí o wáájacúné íñe ámúhakye ó úúballéhi. Árone ¿ɨ́veekí tsá ámuha mecáhcújtsotúne? ");
INSERT INTO boaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Muurá ííñújɨri íjcyánéhjɨtu ámúhakye ó úwáábohíjcyá ámuha ímíñeúvú mewáájácúroki. Árónáa íllure ámúhakye túhútsohíjcyáne. Aanéjɨ́ɨ́ awáá muhdú ámuha méwaajácuú Píívyéébé icyánéjcutu ámúhama o íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tsá muurá múha úújetú dibye íjcyáhulle. Apáábyéré ihdyu Mɨ́amúnáájpidívúu o ípívyééveebe téhullé múnáájpi o íjcyánéllii ó waajácú téhulle. ");
INSERT INTO boaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Muuráhjáa ɨ́ɨ́néubárá píívyétúné iiñújɨri iíjcyácooca Moitséeúvú picyóó úméhéí nɨ́jcáutu ííñimyéké úwááñéityu iñíjcyóóbeke páñétúejpi ɨ́hdome dííbyeke ɨɨ́ɨ́téne ɨdsɨ́jɨ́vétuki. Ahdu muurá oke Mɨ́amúnáájpidívúu o ípívyéévéébeke páwachéketu pícyooímyé oke cáhcujtsómé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ iújcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Muuráhjáa Píívyéébe mítyane mɨ́amúnáake iwájyúnéllii Ílli apáábyéré íjcyáábeke wallóó ííñujɨ́vú dibye ɨdsɨ́jɨ́ve diityé wájyuri ditye iwágóóóvétu teene cáhcujtsómé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ iújcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tsáháa Píívyéébe oke wállootú mɨ́amúnáake ɨɨ́cúbáhraki. Muuráhjáa ihdyu oke wálloobe tajtyééveri diityéké ipájtyetétsoki. ");
INSERT INTO boaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aane oke Píívyéébé Hájchikye cáhcújtsómé hallúrí tsá ɨɨná íjcyatúne. Áánetu apáábyéré dííbyé Hajchi o íjcyáábeke cáhcújtsótúmeke ɨ́cúbáhráiíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ehdu pajtyéiñe peetédúu o néébe ííñujɨ́vú o tsááne cáhcújtsotúmé ímityúné méénuhíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Muurá ímityúné méénuhíjcyámé íllure oke tsaríllé ɨ́mɨáájuvu diityéké o wáájácútsóíyónáaáca. Aame tsá ímílletú óhdivu ɨpɨ́ɨ́hɨne diityé imítyú o bóhówajcáróné iímíllétúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Áánetu ihdyu ímí iíjcyane ímilléméjuco taéllevu tsááne téénetu tsijtye iwáájácu ɨ́mɨááné Píívyéébe ímillédú ditye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ehdúu Jetsóó nééné boonétú muha mepéé Jodéá iiñújɨvu. Áhullée muha meíjcyánáa dibye úwaabóné cáhcujtsóméjuco tsójtsómeíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ááné tujkéveríhjyáa idyé tsojtsó múnáajpi Jóáa téhdure uwáábohíjcyá Enóori Tsaríí cóómíj pɨɨhɨ́rí íjcyácóómiyi. Áábedívúhjáa mɨ́amúnaa píhcyáávémedítyú dííbyé uwáábó cáhcújtsómeke tsótsohíjcyaabe tétsihdyu íjcyáhityu. ");
INSERT INTO boaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Téijyúu tsáhái dííbyeke ditye cúvéhoojánutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aanéhjáa tsáijyu dííbyé mamyémudítyú tsaate tsíjtyema táhjácatsíhijcyá muhdú meímíjpyeténeri. ");
INSERT INTO boaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Áánáacáhjáa diibye Jóááke ímamyémú nééhií: —Uwááboóbej, éhnée Joodáá ehnéjcuri maájtyúmɨ́ɨ́bedítyú múúhakye u úúbállehíjcyaabéha téhdure tsótsohíjcyáábe éllevu mítyame pehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Áánélliihyéhjáa neebe diityéke: —Muurá ihdyu Píívyéébe dííbyeke pícyóóné wákimyéíjyuco dibye méénune. ");
INSERT INTO boaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Áánetúu oke pícyoobe dííbyé ɨhde mɨ́amúnáake o úwáábohíjcyaki. Áánélliihyée muurá ámúhakye ó nehíjcyá Críjto o íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Muurá múúne taabává wañéhjɨ́ pañe diibye taabáva múnáajpi méwama ɨ́ɨ́né imíjyaú ijcyáhi. Ááneri muurá diityétsikye náhbenúmé ímíjyuuvéhi. Ahdu ó ímíjyuuvé mítyane tsúúca Críjto mɨ́amúnáake pájtyetétsoobe íjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Diibye ihdyu táehnííñevu ávyéjúúteéhi. Áánetu ihdyu ɨ́dáátsoobéré ó ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Muuráhjáa Píívyéébedítyú dibye tsáánéllii tsá múha dííbyé ɨhtsútuvu úújetétúne. Áánetu ihdyu ɨ́jɨ́ejpíyé o íjcyánéllii ó ihjyúvahíjcyá mɨ́amúnaa íhjyuvádúre. ");
INSERT INTO boaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Áánetu ihdyu diibye Píívyéébeke iwáájácúnéllii dííbyé uwááboju mɨ́amúnáake úúbálleróné tsá ditye cahcútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Árónáa ijcyámé tsaate dííbyeke cáhcujtsóme. Aame bóhówátsohíjcyá ɨ́mɨááné dííbyé ihjyu álliu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Muuráhjáa Píívyéébe wálloobe úúbállehíjcyá dííbyé uwááboju dííbyé pañe Íapííchó íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aabée diibye Íllíkye iwájyúnéllii dííbyé hójtsɨ́ pañévú ɨ́hvejtsó páneere íñe múhdúné tsíeméné íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aabe Píívyéébé Hájchikye cáhcujtsómé újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. Áánetu dííbyeke cáhcújtsótúmeke Píívyéébe ɨ́cúbahrámé tsá tééne bóhɨ́ újcúityúne. Ehdúhjáa neebe tsojtsó múnáajpi Jóáaá. ");
INSERT INTO boaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aanée diibye Jóáá ehnííñevu Jetsóoke mɨ́amúnaa úráávyehíjcyámedítyú cáhcujtsómé tsójtsótsámeíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Árónáacáa ihdyu tsá dibye páñetu tsótsohíjcyatúne. Múúhayée ímamyémú métsótsohíjcyáhi. Aanéhjáa tsúúca paritséómú waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Áánetúu muha méoomí Jodéá iiñújɨtu bɨwáhullévúré Gariréá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","Aamée muha Tsamááriá iiñújɨtu mepájtyeme méúújeté tééné iiñújɨri íjcyacóómí Tsicáá úniúvú Jacóóboúvúhjáa ílli Jotséeke ájcútsihvu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Átsihyíi núpahyéjú ‘Jacóóbó nupáhyéju’ némeíhyéjú úniúvú Jetsóó wáyéeevé juuváyí muha metsááneri pávyeenúúbe. Téijyúu tsúúca cójɨ́jpɨɨnéélléjuco meé. ");
INSERT INTO boaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Áánáacáa muha mepéé técoomívú majchó áhdovu. Ááné hallúríhjyáa teene Tsamááriá múnáalle téhejútú nújpañúvállekéváa Jetsóó nééhií: —Muúlle, oke dijcho. ");
INSERT INTO boaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Áánélliihyéváa neélle: —¿Aca muhdú ɨ́ɨ́vane oke nújpacyo ú táúmeí Tsamááriá múnáalle o íjcyálleke jodíómuube u íjcyaábe? Muurá jodíómú tsá íhjyúvatú Tsamááriá múnáama. ");
INSERT INTO boaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Áánélliihyéváa neebe díílleke: —Muurá Píívyéébema múhtsikye u wáájácuca téhdure oke ú táúmeíiyá pɨáábó íñe uke nújpacyo o táúmeídyu. Aaca uke ó ájcúiyá bohɨ́ nujpácyovu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Áánélliihyéváa neelle dííbyeke: —¿Aca kiátú u úcújpacyóvú oke ú ájcúiyá teene bohɨ́ nujpácyovu wáábyáúúbamáyé u íjcyáábejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Muurá íñe núpahyéjú pañéwu méɨhdé múnáajpíi Jacóóboúvú méhdivu pícyoíñuhéju. Téhejútúhjáa muurá ɨ́ɨ́tsɨ́ɨ́mema iádóhéjutu téhdure ijyéémuke íchohíjcyaábe. Aane ¿aca dííbyeúvú ehnííñevu uú? ");
INSERT INTO boaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Áánélliihyéváa neébe: —Árónáa téhejútú ádorómé tsiiñe adópívyenúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Áánetu óhdi íjcyáné nujpácyó ádome tsá múijyú ádópívyenúityúne. Muurá o ájcúné nujpácyó óuuvératu diityé pañe íjcyajpácyó diityéké ímíjpyetétsómé újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Áánélliihyéváa neelle dííbyeke: —Ávyéjuúbej, ané cána oke daacu téjpacyótú múijyú o ádópívyenújúcóótuki, pane íñe núpáhyejúvú tsiiñe o tsájúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Áánélliihyéváa neébe: —Ané dítyájɨkéi duucúte. ");
INSERT INTO boaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Áánélliihyéváa neélle: —Tehdu o tájɨ́vállejɨ́ɨ́ kiá íjcyáábeke ó újcúteéhi. Áánélliihyéváa idyé neebe díílleke: —Tehdújuco u néérone. ");
INSERT INTO boaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Árónáa muurá 5-mevákéjuco u tájɨváne. Muurá ícyooca tsíjpiimáyéjuco u íjcyaabe idyé tsá ɨ́mɨá tajɨ ijcyatúne. Áánéllii ɨ́mɨááné u néé u tájɨ́vatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ehdúváa Jetsóó díílleke néénéllii neelle dííbyeke: —Ávyéjuúbej, úubá mɨ́a Píívyéébé ihjyú uubálle múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Muuráhjáa múúha ɨhdé múnáaúvú éhbáu cáméhbáutu Píívyéébeke dúúrúvahíjcyátsihdyu muha téhdure méduurúvahíjcyá dííbyeke. Aane ámuha jodíómú ¿ɨ́veekí ménehíjcyá apááñéreva Jerotsaréetu dííbyeke medúúrúváiyóne? ");
INSERT INTO boaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Áánélliihyéváa neebe díílleke: —Muurá ihdícyátsihdyúréjuco ámuha dííbyeke medúúrúváíñe éévé tsúúca úújetéhi. Áánéllii tsáhájuco ámuha apátsihdyúré eene u nétsihdyuu, Jerotsaréetuu, íjcyane Méécááni Píívyéébeke medúúruváityúne. Aane cáhawáá oke cahcújtsoj. ");
INSERT INTO boaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Muurá ámuha Tsamááriá múnaa ímíñeúvú mewáájácútúúbeke méduurúvahíjcyáhi. Áánetu ihdyu muuha jodíómú ímí mewáájácúúbeke méduurúvahíjcyá ɨ́mɨááné múúhaj tééveri mɨ́amúnaa pájtyetéiñe muha mewáájácúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aane muurá ɨ́mɨááné Méécááni Píívyéébeke dúúrúvahíjcyámé ícyooca dííbyeke duurúvaá ɨ́ɨ́ɨ́búuri. Tehdu dííbyeke medúúruváné imílleébe. ");
INSERT INTO boaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tsá muurá dibye íjpííma íjcyatúne. Áábeke ihdyu óvíi múhdumé dúúruvámé duurúvahíjcyá ɨ́ɨ́ɨ́búuri. ");
INSERT INTO boaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ehdúváa Jetsóó néénéllii neélle: —Tehdújuco, muurá ɨ́mɨááné ó waajácú Críjto tsááiñe mɨ́amúnáake ipájtyetétsoki. Aabe ihdyu óvíi itsáácooca múúhakye ímíñeúvú waajácutsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Áánélliihyée neebe díílleke: —Muurá diibyéjuco Críjto o íjcyaabe íñe úúma o íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ehdúu díílleke dibye néénáa tsúúca muha méwajtsɨ́hi. Aamée muha méullévenú dibye dííllema íhjyúváneri. Aanée tsá muha tsáápíuba medíllotú ɨ́ɨ́nerí dityétsí íhjyúvájcatsíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Átsihdyúu diille Tsamááriá múnáalle tétsihvúré ílliyííhyó iwááoíñúne dsɨɨnéríyé ímunáácoomívú ipyéénemáhjáa neetéhi: —Ámuúhaj, éhtsíhyi muubáhjáubá íjcyaabe oke néé páneere muhdú o ícyahíjcyáné kiátúhjáubá iwáájacúne. Tsáijyu múu Críjto diíbye. ¡Cáhawáá metsu meúújetékij! ");
INSERT INTO boaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Áánélliihyéhjáa tsáácunúmé múúha éllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Áijyúu dííbyeke muha méneerá dibyéi imájchoki. ");
INSERT INTO boaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Árónáacáa neébe: —Tsáhái o májchotúne. Ijcyáné muurá ihdyu tamájchó ámuha mewáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Áánélliihyée muha ménéjcatsíhi: —Tsaatéubáhjané tsúúca dííbyeke májchotsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Áánélliihyée neebe múúhakye: —Muurá ihdyu teenéjuco tamájchódú nééne okée wálloobe Píívyéébé wákimyéí o méénune muhdú dibye ímillédú tene óóma ɨnɨ́jkévaki. ");
INSERT INTO boaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Áánáa muhdú ámuha ménehíjcyá 4 nuhbávatúi bajtsóháñé maááhɨ́vétsoíñe. Cáhawáá meɨ́ɨ́té teene bajtsóháñé múúne kéémedu nééme mɨ́amúnaa ɨ́dátsó wágóóóvéiyóné ɨ́mɨájɨ́jtó diityéké pájtyetétsóiyóné meúúbállétuca. ");
INSERT INTO boaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muurá teene bajtsóháñé ááhɨ́vétsohíjcyamédú nééme úwááboméré péhijcyámé újcuú tééne áhdo. Áhdure ditye úwaabóné cáhcujtsómé újcuú tééne áhdó múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. Ááneri bajtsó múnáama iñéévá ááhɨ́vétsohíjcyamédú nééme uwáábojte tsaméhjɨ́ ímíjyúúveéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Muurá tsaate nééhií: “Tsaate bájtsóne néévá múúne tsíjtyeréjuco ááhɨ́vetsóne.” ");
INSERT INTO boaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aanée muurá ámúhakye ó wallóó tehdu éhne múúne tsaate bájtsóne néévá tsíjtyeréjuco ááhɨ́vétsonédú nééme éllevu, tsúúcajáa tsaate úwaabójúcooróné cáhcújtsótúme éllevu ámuha tsiiñe meúwaabóné botsíi tsaímiyéjuco ditye icyáhcújtsoki. Ehdúu Jetsóó néé múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mítyamée téijyu teene Tsamááriátú tsááme cáhcujtsó Jetsóoke eenéhjáa dille ‘páneere muhdú o ícyahíjcyáné oke neébe’ néénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aamée néé dííbyeke diityémái dibye iíjcyaki. Áánélliihyée muha técoomíyí méijcyá míjcyoojɨ́cu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Áijyúu éhnííñevu mítyame cáhcujtsó dííbyeke dibye úwaabóné illéébónema. ");
INSERT INTO boaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aamée néé diille imúnáálleke: —Tsá apááñéré múúhakyée u néénetu muha mecáhcújtsotúne. Muurá tsúúca muha páñetu mélleebó dibye úwaabóne. Áánetu ɨ́mɨááné muha mécáhcujtsó diibyéjuco Críjto íjcyane mɨ́amúnáake Pájtyetétsoóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Átsihdyúu téhdune míjcyoojɨ́cutu muha mepéé Tsamááriá iiñújɨtu Gariréá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aanée muha mepéhíjcyánáa Jetsóó néé Píívyéébé ihjyú uubálle múnáájpikye imúnaa ávyejúúlléityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Árónáacáa Gariréá iiñújɨ múnaa ímí dííbyeke waatsúcúpejtsó Jerotsaréeríi pajtyété wañéhjɨri ditye úlléjénáa dibye méénúráítyúronéhjɨ́ méénune iájtyúmɨ́nélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Átsihdyúu muha tsiiñe méoomí Canáavu tétsihvúu nújpacyo bíínójpacyóvú dibye ípíívyéévétsócoomívu. Áánáacáhjáa tsaapi ávyéjúúbé hajchi Capenaóori íjcyaabe cheméhi. ");
INSERT INTO boaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aanéhjáa tsúúca Jodéá iiñújɨtu muha metsááme teene Gariréá iiñújɨríjyuco meíjcyane diibye ávyéjuube iwáájácúne tsáá Jetsóo éllevu. Aabée néé dííbyeke dííbyema ihjyávú ipyééne dibye íllíkye ibóhɨ́ɨ́tso ávyeta dsɨjɨ́veríjyuco íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Áánélliihyée neebe dííbyeke: —Ámuha muurá tsá oke mecáhcújtsóítyuró méénúráítyúronéhjɨ́ o méénuhíjcyátuca. ");
INSERT INTO boaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Árónáacáa neébe: —Ávyéjuúbej, árónáa ihdyu hájchíwu dsɨ́jɨ́vétúné hajchótá ɨ́ɨ́cúi óóma tahjyávú pééne bohɨ́ɨ́tso. ");
INSERT INTO boaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Áánélliihyée neebe dííbyeke: —Tehdújuco, tsúúca muurá ícyooca bohɨ́júcoobe daáchi. Ahdícyane wa dipyej. Ahdújucóo dibye óómiñe dííbyeke icyáhcújtsónema. ");
INSERT INTO boaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aabéhjáa ihjyávú úújetéébeke íúníu múnaa népejtsóhi: —Tsúúca daachi bohɨ́jucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Áánélliihyéhjáa dílloobe múijyú dibye bóhɨɨ́ne. Áánélliihyéhjáa néémeé: —Iijyúijyu révóóvéébedi dííbyeke pajtyéné áíívyeé. ");
INSERT INTO boaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ehdúhjáa ditye úúbállénetu ɨ́tsááveebe ávyetáa tééne ééveri Jetsóó dííbyeke nééne tsúúca ílli bóhɨ́jucóóne. Áánélliihyée téhdure pámeere ihyájkímú cáhcujtsó Jetsóoke. ");
INSERT INTO boaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ehdúu Jetsóó méénúráítyuróné meenú Jodéá iiñújɨtu muha Gariréá iiñújɨvu meóómimye tétsihyi meíjcyánáaáca. Téénemáa botsíi tétsihvu míijyúcúréi méénuube méénúráítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ááné boonétúu muha tsiiñe dííbyema Jerotsaréevu méuubámyenú wañéhjɨvu. ");
INSERT INTO boaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Áánáacáa técoomíyí tsátsii ‘Obééjámú lleehówa’ némeítsíí úníuri nújpacyo páábáwu heeberéómú ihjyúrí ‘Betéjda’ némeííba. ");
INSERT INTO boaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Áábá hallúríi 5-wava nújúwáwuúné íjcyáwáhjɨ́ pañétú hállúvátuméhjɨ́, úllétuméhjɨ́, íjpi vááúmeítyuméhjɨ́, téhmehíjcyá teeba nóhjɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsáijyúhjáa níjkyéjɨ múnáajpi iñíítyéne téébáwu nóhjɨhíjcyáhi. Aanéhjáa dibye nóhjɨ́né boone tujkénúré éniivyéméjuco ímípyetéhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Téijyúu íjcyaabe diityé pañe ávyetáhjáa 38 pijcyábájuco chémehíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aabée tódsɨúcunúúbeke Jetsóó ɨɨ́ɨ́téne waajácú téhajchótájuco dibye chémehíjcyáne. Áábekée neébe: —Muúbe ¿muhdúami ú ijcyaj? ¿A ú imíllé u bóhɨɨ́ne? ");
INSERT INTO boaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Áánélliihyée neébe: Ééero Ávyéjuúbej, árónáa tsá o píívyetéhíjcyatú nújpacyo nóhjɨ́cooca ɨ́ɨ́cúi tujkénú o éníívyéiyóne. Íhya ihdyu tsaate oke pɨ́ááboca o éníívyéne ó bohɨ́júcóóiyáhi. Tehdu o méénúíyónáa tsijtye táɨhdéré éníívyehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Áánélliihyée Jetsóó néé dííbyeke: —Ané wa ílluréjuco eene dɨ́ɨ́hbotámá dipye dihjyávuj. ");
INSERT INTO boaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ehdúu dííbyeke dibye néénemáyé tsúúca ibóhɨ́ɨ́ne ɨ́ɨ́hbotámá péjúcoóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Téijyúu wáyeéévejcóójɨ́ íjcyánáa dibye ɨ́ɨ́botámá pééne ávyéjujte ɨɨ́ɨ́téne néé dííbyeke: —Muúbe, tsá eene dɨ́ɨ́hbota íjcyoojɨ wáyeéévejcóójɨ́ u tsájtyéítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Áánélliiyée neébe: —Árónáacáne oke bóhɨ́ɨ́tsoobe néé téénema o péékií. ");
INSERT INTO boaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Áánélliihyée néémeé: —¿Aca muubá íjcyaabe ɨ́veekí wáyeéévejcóójɨ́ uke táuhbáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Árónáacáa tsá dibye wáájacújúcootú caabyé dííbyeke bóhɨɨtsóné mítyanée mɨ́amúnaa íjcyámé pañe Jetsóó íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ááné boonétúu Jetsóó dííbyeke duurúvájá pañe iájtyúmɨ́ɨ́beke nééhií: —Muúbej, tsúúca muurá ú bohɨ́jucóóhií. Aabe ɨ́mɨááberéjuco díícyaco. Tsiiñe ímityúné meenújúcohdí éhnííñevu íjcyane uke ipájtyétuki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ehdúu Jetsóó dííbyeke nétsihdyu péébéhjáa botsíi úúballé ímíñeúvú avyéjujtéké Jetsóó dííbyeke bóhɨɨtsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ááné hallútúu imíllerómé téijyúré Jetsóoke ɨdsɨ́jɨ́vetsóne ɨ́veekíváhjáa wáyeéévejcóójɨ́ dííbyeke dibye bóhɨ́ɨ́tsóné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Árónáacáa neebe diityéke: —Muurá Llihíyó paíjyuváré meke pɨ́áábohíjcyádújuco o pɨ́aabóné ihdícyáijyúre. ");
INSERT INTO boaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ehdúu dibye nééne éhnííñevu diityéké tsárívyetsómé imíllerá dííbyeke ɨdsɨ́jɨ́vetsóne. Tsáháa apááñéré taúhbaju néhdu wáyeéévejcóójɨ́ dibye íjcyátúné hallútú ditye dííbyeke dsɨ́jɨ́vétsóítyuróne. Téhdurée Píívyéébeke icyáánívahíjcyáábé tujkévevu iíjcyane dibye néhíjcyáné hallútú imíllémé dííbyeke ɨdsɨ́jɨ́vetsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ehdúu éhnííñevúré ditye Jetsóoke pátsáríjcyónéllii neebe diityéke: —Muurá ɨ́mɨááné tsá Píívyéébé Hajchi o íjcyaabe ɨɨná o méénúítyuró oore o ɨ́jtsámeídyu. Muurá ihdyu Llihíyó méénúiyónéjuco o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aabe oke iwájyúnéllii waajácútsohíjcyá páneevúré muhdú imyéénúiñévu. Muurá tajtyééveri éhnííñevu tsíñehjɨ dibye méénúneri ámuha méullévénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Muurá Llihíyó dsɨ́jɨ́vémeke bóhɨɨtsódú o ímíllémeke o bóhɨ́ɨ́tsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Tsá muurá Llihíyó mɨ́amúnaa muhdú ícyahíjcyáné diityémá ímíbájchóityúne. Muuráhjáa oke neebe teene o méénu pámeere oke iávyéjújtso dííbyeke iávyéjujtsódúre. Aane oke ávyéjújtsotúmé téhdure tsá diibye okée wállóóbeke ávyéjújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Muurá ɨ́mɨáánetúré ámúhakye o néé íñe o néhijcyáné lléébome okée wállóóbeke cáhcujtsómé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ újcuíñe. Áámé hallúrí tsáhájuco ɨɨná íjcyáityúne. Muurá iwágóóóvéíyónetu tsúúca pajtyémé ímí Píívyéébema iícyáíñejcúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ahdícyane ɨ́mɨááné ámúhakye o néé wágóóóvéiyómé Píívyéébé Hajchi o íjcyáábé uwááboju lléébóíñe éévé tsúúca úújeténe. Aane ɨ́mɨááné cáhcujtsómé tsá wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Muurá Llihíyodítyú tsááne múijyú medsɨ́jɨvéjúcóóítyúne bóhɨ. Áánevúu oke ájcuube oke cáhcújtsómeke o ájcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Muuráhjáa Mɨ́amúnáájpidívú o ípívyéévéébeke neebe mɨ́amúnaa muhdú ícyahíjcyáné diityémá o ímíbájchoki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Métsájúréévedí ehdu ámúhakye o nééneri. Muurá ɨ́mɨááné iéévé úújetéijyu pámeere dsɨ́jɨ́vehíjcyámé íhñijkyénetu ijchívyeé pámeekéré o pɨ́úvácoóca. Áámedítyú ɨ́mɨánéjcúu úráávyehíjcyámé tsáhájuco muhdú íjcyáityúne. Áánetu íimítyunéjcúrée úráávyehíjcyámé ɨ́cúbáhráméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Muurá tsá ɨɨná oore táɨ́jtsaméiyi o méénúítyuróne. Okée wálloobe Llihíyóré oke néhdújuco mɨ́amúnaa muhdú íjcyanéjuco o néhijcyáne. Tsá oore o ímillédú o méénuhíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Muurá oore muubá o íjcyane o némeícyá tsá múha oke cahcújtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Muuráhjáa tsojtsó múnáajpi Jóáa óhdityu nehíjcyá ɨ́mɨáánéjuco muubá o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Áábe éllevúu muurá ámuha tsaatéké méwallóó ditye óhdityu idíllo dííbyeke. Áánélliihyée úúbálleebe ɨ́mɨááne muubá o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Árónáacáa tsá dibye úúbállénetúré o wáájácúmeítyú Píívyéébedítyú o tsááneé. Árónáa ihdyu o néé tehdújucóo óhdityu dibye néhijcyáné ámuha mecáhcújtsóne mepájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Muuráhjáa ámúhakye waajácútsoobe ɨ́mɨá uwáábojúvú éhne múúne peetéj tééveri tsíeméné maájtyumɨ́né mewáájacúdu. Aanée dibye úwáábohíjcyáné muurá wahájchotáré ímí ámuha méɨjtsúcunúráhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Árónáa dibyée oke bóhówátsohíjcyáné éhnííñevu páñetu ó bóhówátsámeíhijcyá páneere okée Llihíyó níwaavéné o méénuhíjcyáneri. Téénetu muurá ámuha méwaajácújúcoorá ɨ́mɨáánée oke dibye wálloóne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aabe ámuha maájtyúmɨ́túroobe óhdityu nehíjcyá ɨ́mɨáánéjucóo oke iwálloóne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Áábé uwááboju tsá ámúhakye úcáávehíjcyatú dííbyeke ámuha mecáhcújtsótúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Muurá ámuha mééévehíjcyará Píívyéébé waajácuháámɨ́ muhdú óhdityu néhijcyáné ámuha múijyú medsɨ́jɨvéjúcóóítyúne bóhɨ́ meújcúroki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Árónáa tsá ámuha meímílletú oke mecáhcújtsóne óhdivu meɨ́hvéjtsámeíñé téénevu ámúhakye o ájcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Árónáa tsá o íjyácunútú mɨ́amúnaa oke ávyéjújtsóíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Muurá ó waajácú múhdurá ámuha menééme Píívyéébeke mewájyutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Muuráhjáa diibyéjuco Llihíyó nééjuri ííñujɨ́vú o tsáábé uwáábori tsá ámuha meɨ́ɨ́cúvehíjcyatúne. Ááne eene tsijtye ɨ́ɨ́ɨ́búwaríyé ámúha éllevu itsááne íhdityúré újcune úwáábóneríyé ámuha méɨ́ɨ́cúvehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Muhdú ámuha oke mécáhcújtsóiyá kiá eene ámuha tsamééré maávyéjútsócatsíhijcyáné íjcyánáaáca? Tééneríyé ámuha meíjcyame tsá meɨ́ɨ́cúvehíjcyatú apáábyéré íjcyaabe Píívyéébe ámúhakye ávyéjújtsóíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aane méɨjtsúcunúdí ámúhá imítyú ámúhá hallúvú Llihíyoke o úúbálleíñe. Muuráhjáa ihdyu Moitséeúvúré tsúúca ámúhá hallúvú úúballé dííbyé uwááboríi ámuha mepájtyetéiñe meɨ́tsúcunúhíjcyároóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Muuráhjáa dibye úwaabóné ímí ámuha mecáhcújtsoca idyé téhdure ímí oke ámuha mécáhcújtsóiyáhi. Muuráhjáa óhdityu íjcyáné uwááboju caatúnuhíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ááné uwáábóo ámuha ímí mecáhcújtsómejɨ́ɨ́ ¿muhdú mécáhcújtsóiyá ámúhakye o néhijcyáne? Ehdúu neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ááné boonétúu dííbyema muha mepéé Gariréá unéú tsaúúré ‘Tibééria’ némeíú tsiñéjcuvu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Áijyúu mítyane mɨ́amúnaa múúhakye úraavyé méénúráítyuróné chéméméhjɨke dibye bóhɨ́ɨ́tsohíjcyáné iájtyúmɨ́nélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Téijyúu pajtyété wañéhjɨ́ tsúúca llééváíñáa muha caméhbaúvú mepééme téhbaú déjucóvú meúújetétsihvu ácúúveébe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Áánemáa diitye mɨ́amúnáake ɨɨ́ɨ́téne neebe Perípeke: —¿Aca kiátú íñe majcho méújcuú íjtyéke memájchótsoki? ");
INSERT INTO boaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ehdúu neebe muhdú dííbyeke dibye iáñújcuki. Waajácúroobée muhdú imájchótsoíñé diityéke. ");
INSERT INTO boaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aanée dibye díllónéllii Perípé nééhií: —Muurá 200-jɨvámá majcho meújcuróné tsá úújetéítyuró diityédívú áyánéwuújɨ́ maájcúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Áánélliihyée Tsimóo Péédoró nahbe Aderéé néé Jetsóoke: —Áánúwúudíhya 5-hova tsebáádatu méénúmeíñé paáhóónema míítyétsi amóóbemútsi. Árónáacáubá tsá tene úújetéítyuró áyámedívujɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Árónáacáa Jetsóó nééhií: —Méne pámeere iáhcúbaki. Ahdújucóo muha menéénéllii ditye áhcubáné 5,000-meváubáhjáa íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aabée teene páahóóné iékéévéne téhdujtsó Píívyéébeke. Áánemáa múúhakye dibye ájcune muha méwajtú pámeekére. Áhdurée amóóbemútsikye muha mewájtune úújeté pámehdívúre. ");
INSERT INTO boaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aanée pámeere tsaímíyé óóvéné boone múúhakye neébe. —Cóeene mepíhcyú tene iwágóóóvétuki. ");
INSERT INTO boaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ahdújucóo pátyeevéné muha mepíhjyucúné 12-rujtsívá úvérujtsíñe wáhpe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ehdúu méénúráítyuróné Jetsóó méénune iájtyúmɨ́ne tsaate néjcatsíhi: —Ɨ́mɨáánéha diibyéjuco áánu Píívyéébé ihjyú uubálle múnáajpi éhneváa ííñujɨ́vú tsááiíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Áánemáa imíllerómé peecútéré dííbyeke páñétúejpi ávyéjúúbedívú ipícyoóne. Aanée iwáájácúne múúhadítyú iiye peebe cáméhbaúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ááné iijyúnuvúu muha dííbyé mamyémú mepéé mɨ́ɨ́neri Capenaóovu tsíñejcúéuri íjcyácoomívu. Áijyúu tsúúca péjcóhréjuco néénáa tsá Jetsóó múúhama íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Áánáacáa mítyane nohjɨ ávyétá ɨhnáhó kííjyeba íjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aamée muha pɨ́ɨ́nééuríjyuco meíjcyame máájtyumɨ́ dibye tsááne nújpácyó hallúrí úlleebéré múúhá tujkévetu. Ááneríi muha méíllityéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Árónáacáa neebe múúhakye: —Oóre, méíllityédíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Áánélliihyée muha méujcú dííbyeke mɨ́ɨ́né pañévu. Aamée tsúúca muha méúújeté muháa mepétsihvu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ááné tsijcyóójɨ́hjáa múúha déjuvu ɨ́tsaavémé apáámɨ́rée mɨɨne íjcyámɨri muha mepéémema Jetsóó péétune. ");
INSERT INTO boaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Áánáacáhjáa tsɨ́mɨhjɨ Tibéériá cóómityu tsámɨhjɨ wajtsɨ́ dibyée Píívyéébeke ityéhdújtsóne áyaróné majcho mítyámedívú úújetétsótsííj pɨɨhɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aanéhjáa tétsihyi dííbyeke iájtyúmɨ́túnéllii témɨ́hjɨri pééme múúha déjutu Capenaóovu dííbye néhcovu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aamée tsúúca múúhadívú úújetémé dííbyeke nééhií: —Uwááboóbej, ¿acáa múijyúrá u tsáá ííllevu? ");
INSERT INTO boaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Árónáacáa neebe diityéke: —Ɨ́mɨááné ámúhakye o néé ámúhakyée o májchótsónélliihyéré oke ámuha menéhcohíjcyáne. Tsá ámuha oke menéhcohíjcyatú méénúráítyúronéhjɨ́ o méénune ɨɨná nééiyóné ámuha mewáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tsá múu íjyácunútú majchórí múhajchótá ámuha tééne tájpí meíjcyáíñeríjɨ́ɨ́vari. Múu táuwáábori ijyácunú teene majchódú nééne múijyú ámuha medsɨ́jɨvéjúcóóítyúne bóhɨ́ meújcúíñeri. Áánevúu muurá ámúhakye o ájcu Llihíyó oke meménuube mɨ́amúnáájpidívú ó ípívyeevéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Áánélliihyée nééme dííbyeke: —¿Aanéhaca muhdú muha Píívyéébe ímilléné méméénúiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Áánélliihyée neebe diityéke: —Muurá imílleebe okée dibye wállóónéllii ííñujɨ́vú o tsáábeke ámuha mecáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Áánélliihyée néémeé: —¿Aca ɨɨná díwákimyéi? Ané cána méénúráítyuróné meenu uke muha mecáhcújtso diibyéjuco mɨ́amúnáake pájtyetétsóiibye u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Muuréváhjáa múúhá ɨhdé múnáaúvú manáá májchohíjcyá ɨ́ɨ́néubárá píívyétúné iiñújɨri iíjcyácoóca. Muurá Píívyéébé waajácúháámɨtu nééneé: “Píívyéébe diityé éllevu majcho dójcotsó níjkyéjɨtu.” ");
INSERT INTO boaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ehdúu Jetsóoke ditye néénéllii neébe: —Ɨ́mɨáánéjucóo Moitséeúvú tsá diityéké ácuhíjcyatú majchóvú téijyu. Muuráhjáa ihdyu Llihíyóré dócótsohíjcyá diityé éllevu teene ‘manáa’ némeíñe májcho. Aabe muurá imíllé ámúhakye iájcune teene majchódú nééne múijyú ámuha medsɨ́jɨvéjúcóóítyúne bóhɨɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Muuráhjáa teene majchódú o néébeke níjkyéjɨtu oke wálloobe ííñujɨ́vú mɨ́amúnáake tééne bóhɨɨvu o ájcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Áánélliihyée nééme dííbyeke: —Ávyéjuúbej, ané ihdyu múúhakye paíjyuváré dáácuhíjcyá téeméne májchotu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Áánélliihyée neébe: —Oo muurá teene majchódú o néébe múijyú medsɨ́jɨvéjúcóóítyúne bóhɨɨvu ó ajcúhi. Aane ɨ́mɨááné oke cáhcujtsómé tsáhájuco muhdú éhnííñevu tsaímíyé iíjcyáíyóneri ɨ́jtsámeítyú éhne múúne memájchóne maádóne tsiiñe maájyabáávatémé memájchóíyóneri maádóíyóneri meɨ́jtsámeídyu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Árónáa ihdyu íñe ámúhakye o néhijcyádú ¿ɨ́veekí ámuha tsá oke mecáhcújtsotú ɨ́mɨááné diibyéjuco o íjcyáábeke tsúúca ámuha oke maájtyúmɨróme? ");
INSERT INTO boaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Muurá Llihíyó nééjuri oke cáhcújtsómeke tsá o cátúhtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tsáháa níjkyéjɨtu oke dibye wállootú o ímilléné o méénuki. Muuráhjáa ihdyu o tsáá oke dibye táuhbáné o méénuki. ");
INSERT INTO boaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aabe tsá ímílletú ópée o pájtyetétso óhdivu dibye ɨ́hvéjtsómedítyú tsaate wágóoovéne. Imílleebe páneere nihñéétsihvúré tsíhdyuréjuco ímíbáávyécooca pámeere pájtyeténe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Muurá imílleebe okée dibye wállóóbeke cáhcujtsómé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ újcune. Muurá dsɨ́jɨ́vémeke ó bóhɨ́ɨ́tsoó páneere tsíhdyuréjuco ímíbáávyécoóca. ");
INSERT INTO boaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Ehdúu Jetsóó majchódú néébe níjkyéjɨtu itsááne diityéké néénetu dííbyeke cáhcújtsotúmé dííbyedítyú nééhií: —Áánerá aabye Jotséé hajchi Jetsóó wájácú cáánímútsikye menéébe ¿muhdú ɨ́ɨ́vane néé níjkyéjɨtu itsááneé? ");
INSERT INTO boaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Áánélliihyée neebe diityéke: —Ayécó óhdityu ámuha meíhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Muuráhjáa Llihíyó oke wálloobe mɨ́amúnáake óhdivu ɨ́búwájtsótuca tsá múha pájtyetéítyuróne. Aane muurá oke cáhcujtsómé dsɨ́jɨ́vémeke ó bóhɨ́ɨ́tsoó páneere tsíhdyuréjuco ímíbáávyécoóca. ");
INSERT INTO boaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Muurá Píívyéébé ihjyú uubálle múnáájpí waajácúháámɨtu nééneé: “Píívyéébere diityéké úwaabóhi.” Ehdu dibye úwaabóné lléébome oke úraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Árónáa tsá múha ájtyúmɨtú dííbyeke. Apáábyéré ihdyu ó ájtyumɨ́ dííbyeke dííbyedítyúu o tsáánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aane ɨ́mɨááné ámúhakye o néé oke cáhcujtsómé tsúúca újcune múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Áánevu majchódú o néébe ó ajcúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Muuráhjáa ámúhá ɨhdé múnáaúvú ɨ́ɨ́néubárá píívyétúné iiñújɨri iíjcyácooca ‘manáa’ némeíñé májchorómé dsɨ́jɨ́vehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Áánetu íñe ícyooca ó ihjyúvahíjcyá tsííñere níjkyéjɨ́ene íjcyáne májchori, teene májchome múijyú dsɨ́jɨ́véítyúne májchori. ");
INSERT INTO boaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aabe ó ijcyá teenée majchódú o néébe níjkyéjɨtu o tsáábe mɨ́amúnáake bohɨ́ɨ́vú o ájcuúbe. Aane bohɨ́ɨ́vú o ájcuube mɨ́amúnaa ipájtyeté ó dsɨ́jɨ́veéhi. Áánéllii táuwááboju majchódú nééne cáhcujtsómé tsá múijyú dsɨ́jɨvéjúcóóityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ehdúu Jetsóó néénetu tsaate múhdurá ɨɨ́jtsámeíñe néjcatsíhi: —Ɨɨnáami aabye ehdu meke nehíjcyaj. ¿Aca muhdú meke íhyéécovu dóótsóíyoóbe? ");
INSERT INTO boaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Áánélliihyée neebe diityéke: —Muurá ɨ́mɨááné Mɨ́amúnáájpidívúu o ípívyéévéébe héécó dóótume tsá újcúityú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. Téhdure tátyujpácyó ádotúmé tsá újcúityú tééne bóhɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Áánetu ihdyu táhyééco dóóme téhdure tátyujpácyó ádome újcuú tééne bóhɨ. Muurá oke cáhcujtsómé dsɨ́jɨ́vémeke ó bóhɨ́ɨ́tsoó páneere tsíhdyuréjuco ímíbáávyécoóca. ");
INSERT INTO boaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Muurá tájpi ɨ́mɨá májcho. Áhdure tátyujpácyó ɨ́mɨá ádo. ");
INSERT INTO boaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Áánéllii téneecu óóveme ímí óóma nahbévájcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Muurá Llihíyó okée wálloobe ɨ́mɨááné ijcyáhi. Áábe tájpí ó ícyahíjcyáhi. Áánéllii oke cáhcujtsómé tatyájpí ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ehdu íñe ó nehíjcyá tsííñére májchoma níjkyéjɨtu o tsááneé. Aane májchome újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bohɨ. Tsá ‘manáa’ némeíñe májchódú tene néétu éhnée méɨhdé múnáaúvú teene májchorómé dsɨ́jɨ́vehíjcyáne májchódu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ehdúu Jetsóó úwaabó Capenaóovu pihcyáávéjá pañévu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aanée muha meíjcyarómé mewáájácútúnéllii ménéjcatsíhi: —Tsáháubá múha lléébóítyuró muhdú tuhúwu dibye úwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ehdúu téénetu muha meíhjyuváné iwáájácúne neebe múúhakye: —¿A múhdurá ámúhakye pajtyéné o úwaabóne? ");
INSERT INTO boaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Awááréjucóubá Mɨ́amúnáájpidívúu o ípívyééveebe ámuha meɨ́ɨ́téneríyé cáámevu ópée o tsáhullévú o pééca múhduréjuco ámuha meíjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Muurá ihdyu Píívyéébé Apííchoj tééveríyé méujcú múijyú medsɨ́jɨvéjúcóóítyúne bóhɨ. Tsá meere teene meújcúítyuróne. Aane íñe ámúhakye o néhijcyáné Píívyéébedítyú tsááne ɨ́mɨááné meke ajcú tééne bóhɨɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Árónáa ijcyámé tsaate ámúhadítyú teene icyáhcújtsóiyóné ímílletúme. Ehdúu neebe Jetsóó ɨ́hdéjuco caatyé dííbyeke cáhcújtsóityúné iwáájácúnema. Áhdurée waajácuube ɨ́hdéjuco caabyé dííbyedívú méénútsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Áánélliihyée neébe: —Ehdúu mɨ́amúnaa múhdurá nééne o wáájácúne ó nehíjcyá Llihíyó óhdivu ɨ́búwájtsótuca múha pájtyetéítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ehdúu dibye nétsihdyu múúhama péhíjcyámedítyú mítyame ílluréjuco dííbyeke ɨɨ́hvéjtsóne pééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Áánetúu múúhakye neébe: —¿A téhdure idyé ámuha méimíllé oke meɨ́hvéjtsóne óhdityu mepééneé? ");
INSERT INTO boaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Áánélliihyée Tsimóo Péédoro nééhií: —Ávyéjuúbej, ¿aca múhdivú muha mecátsɨ́páávéne uke méɨ́hvéjtsóiyá apááñéré díuwááboju múijyú medsɨ́jɨvéjúcóóítyúne bóhɨɨvu meke ájcúnáaáca? ");
INSERT INTO boaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Muurá muha tsúúca uke mécáhcujtsóhi. Aame muha méwaajácú ɨ́mɨááné diibyéjuco Píívyéébé Hajchi mɨ́amúnáake u pájtyetétsoobe Críjto u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Áánélliihyée neebe múúhakye: —Muuráhjáa ámúhakye ó ujcú ámúhakye o mámyénuki. Árónáa íjcyaabe tsaapi ámúhadítyú ímítyuube ávyétá naavéné íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ehdúu Jetsóó néé Tsimóó hajchi Jóódáke iñéérone múúháejpi íjcyároobéhjáa dííbyedívú méénútsoíñé iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ááné boonétúu muha Jetsóoma mépehíjcyá pahúlleváré Gariréá iiñújɨri. Tsáháa dibye ímílletú Jodéá iiñújɨri iíjcyane téhullé ávyéjujtée dííbyeke dsɨ́jɨ́vétsóllehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Árónáacáa téijyu ‘nújuwááné wañéhjɨ’ némeíñé lleeváríjyuco íjcyánéllii íñahbémú néé dííbyeke: —Wa bo ihdyu dipye Jodéá iiñújɨvu ukée cáhcujtsómé téhulle íjcyame iájtyúmɨ méénúráítyúronéhjɨ́ u méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Muurá ehdu nénehjɨ méénuhíjcyaabe tsá téévéneúvú méénúítyuró dííbyeke pame wáájacúné iímílléhajchííjyu. Aanéjɨ́ɨ́va wa ihdyu méénuhíjcyá uke mɨ́amúnaa iwáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ehdúu íñahbémú Jetsóoke néé dííbyeke téhdure icyáhcújtsótúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Áánélliihyée neebe diityéke: —Árónáa téhullévú o pééíñe éévéi tsá úújetétúne. Ámuha ihdyu mépiivyété ihdícyáijyúré téhullévú mepééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Muurá ámuha tsamééré ɨ́jɨ múnaa meíjcyame tsá metsárílléjcatsítyú tsahdúré ámuha menéénélliíhye. Áánetu oke tsaríllémé ditye ímityúné ícyahíjcyáné diityédívú o bóhówátsohíjcyáné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Áánéllii wái ámuháyé méuubámyenuj. Óvíi ihdyu taéévé úújeté o péékií. ");
INSERT INTO boaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ehdúu Jetsóó íñahbémuke iñééne coévá tétsihvúré Gariréá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aabée bóónétúi íñahbému déjutu teene wañéhjɨvu péébema muha mepééhií. Árónáacáa tsá boohówáneúvu dibye úújetétúne. Wáájácúratúnée tétsii diíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Áijyúu ávyéjujte néhcohíjcyá dííbyeke. Díllohíjcyámée pamévakéré caabyé dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Áábedítyúu mɨ́amúnaa ihjyúvahíjcyá páhduváre. Tsaatée nehíjcyá ɨ́mɨáábé dibye íjcyane. Árónáacáa tsijtye nehíjcyá ímítyuube íjcyaabe íllure mɨ́amúnáake állihíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ehdúu dííbyedi téévéneúvúré ihjyúvahíjcyámé ávyéjujtédí iíllityénema. ");
INSERT INTO boaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aabée Jetsóó wañéhjɨ́ pɨ́néévénáa duurúvájá pañévú úwaabóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aanée imíwu dibye úwáábóneri diitye ávyéjujte iúllévenúne néé dííbyedítyu: —¿Aca kiátú aadi ehdɨ́ɨ́vaíñé wáájacúné waajácúháámɨ́ubárée ɨ́ɨ́tehíjcyáábejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Áánélliihyée neebe diityéke: —Tsá oore táɨ́ɨ́búwá ɨ́jtsaméityu o újcune o úwáábotúne. Muurá ihdyu okée wállóóbé uwáábóré teéne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aane cáhawáá óvíi dibye ímillédú íjcyame waajácú kiátú tsááné uwáábó o méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muurá tsaate íhdityúré iújcune úwaabó diityéké mɨ́amúnaa iávyéjújtsokíye. Áánetu ihdyu okée wállóóbeke iávyéjujtsóné ímillémé ɨ́mɨááné tehdújuco úwáábohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muuráhjáa Píívyéébe muhdú ámuha meíjcyáíñé taúhbajúvú ámúhakye ajcú Moitséeúvuj tééveri. Árónáa muurá tsá ámuha tsaatéubáré tene néhdu meíjcyatúne. Aame ¿ɨ́ɨ́né hallútú ámuha méimíllé oke mellííhyanúne? ");
INSERT INTO boaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Áánélliihyée tétsii íjcyame néé dííbyeke: —Naavénéhaca dípañe. ¿Aca múha uke imíllé illííhyanúne? ");
INSERT INTO boaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Áánélliihyée neebe diityéke: —Ááneráhjáa tsáneere wáyeéévejcóójɨ́ tsáápiikye o bóhɨɨtsóné múhdurá ámúhakye pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Árónáacáa muurá Píívyéébe Moitséeúvuj tééveri méénútúróné taúhbaju ámúhá ɨhdé múnáaúvú méénuhíjcyádújuco wápíj tsɨɨméneke ámuha tsáijyu wáyeéévejcóójɨ́ íjcyaróné mekíhdyahɨ́rótsohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ehdu muurá téhdure ámuha méméénuhíjcyá tsáijyu wáyeéévejcóójɨ́ íjcyaróné teene taúhbaju ámuha mewáágóótuki. Aame ¿ɨ́veekí muhdú ámuha menééne óhdi méijyácunúhijcyá tsáápiikyérée téjcoojɨ o bóhɨ́ɨ́tsóné hallútu? ");
INSERT INTO boaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tsá múu peecútéré tsáápiikye ‘íllu uú’ néétune. Ɨ́mɨááné múu dibye íjcyanéjuco nééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ehdúu Jetsóó néénéllii Jerotsarée múnaa néjcatsíhi: —¿Aca tsá éhne áábyeke ditye néhcohíjcyatú ɨdsɨ́jɨ́vétsoki? ");
INSERT INTO boaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Áróóbeke ¿keená tsaatéubáré ɨɨná nééneé? Áánélliihyéubá bo ávyéjujte íjcyarómé cáhcujtsó ɨ́mɨááné diibyéjuco mɨ́amúnáake pájtyetétsóiibye Críjto dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Árónáacáubá tsá diibye íjcyatúne. Muurá méwaajácú kiá múnáajpí dibye íjcyane. Muurá ihdyu mɨ́amúnáake pájtyetétsóiibye tsáácooca tsá múha wáájácúityú kiátú dibye tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ehdúu Jetsóodítyú ditye íhjyuváné iwáájácúne duurúvájá pañévú iúwáábótsihvu neébe: —¿A ámuhává éhne méwaajácú kiá múnáajpí o íjcyane? Árónáacáa tsá oore táɨ́ɨ́búwaríyé o tsáátune. Muuráhjáa o tsáá ɨ́mɨáábé íjcyáábeke ámuha mewáájácútuube oke wállóónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Áánetu ihdyu ó waajácú dííbyeke okée wállóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ehdúu Jetsóó nééné hallútú imíllerómé dííbyeke iékeevéne. Árónáacáa tsá ditye ékéévetú iéévéi úújetétúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Áróóbekée tsijtye mítyame cáhcujtsómé néjcatsíhi: —¿Aca íhya tsijpi itsááca áánú ehnííñevu méénúráítyúronéhjɨ́ méénúiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aanéhjáa dibye méénuhíjcyánéhjɨri mɨ́amúnaa íhjyúvahíjcyáné paritséómú lleebóhi. Aanéhjáa múhdurá llúúvájté avyéjujtémá diityéké pájtyénéllii wallóómé duurúvájá tehméjteke dííbye éllevu ditye iékéévéébeke itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aamée dííbyedívú wájtsɨ́náa pámeekéré neébe: —Tsá ámúhama múhajchótá o íjcyáityúne. Muurá wahájchotáré o íjcyátsihdyu ó oomíjyúcoó okée wállóóbe éllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Áijyu muurá ámuha oke menéhcorómé tsá maájtyúmɨ́ityú kiá o íjcyáhullévú ámuha meúújetéítyúrónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Áánélliihyée tsaate néjcatsíhi: —¿Aca íhya kiávú péébeke maájtyumɨ́júcóóityúné eene neébe? Íhya mityá íñe kiáhjɨ́ tsííñé iiñújɨ múnáá pañe memúnaa jodíómú mújtáme éllevúréjuco dibye pééiñe. ");
INSERT INTO boaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Aca íhya tsáma muhdú nééiñe eene meke neebe dííbyeke menéhcorómé dibye íjcyáhullévú meúújetéítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aanée nihñéejcóójɨréjuco tsúúca teene wañéhjɨ́ pájtyéijcyóójɨ́ Jetsóó kéévánécoba nééhií: —Tsaate ádópivyémé taéllevu metsa o íjchoki. ");
INSERT INTO boaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muurá Píívyéébé waajácúháámɨtu nééne oke cáhcújtsómé ɨ́buúúné pañévú téhiñe ípívyééveíñé íñujpácyó bohɨ́ɨ́vú ájcúnéj tehíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ehdúu nehíjcyaabe dííbyeke cáhcújtsómé pañévú Píívyéébé Apííchó úcaavéné diityéké túkévéjtsoíñé iñééiyóne. Árónáacáa tsáhái téijyu tene tsááíñe éévé úújetétú diibyée Jetsóó teene wállóóiibye íavyéjuvúi óómítyúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aanée tsaate dibye íhjyuváné illéébóne nééhií: —Ɨ́mɨáánéha diibyéjuco aabye éhneváa Píívyéébé ihjyú uubálle múnáajpi tsááiíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Téhdurée tsijtye nééhií: —Diibyéjuco muurá aabye Críjto éhneváa mɨ́amúnáake pájtyetétsóiíbye. Árónáacáa tsijtye nééhií: —Árónáa Gariréá iiñújɨ múnáajpi tsá Críjto íjcyáítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Muurá Píívyéébé waajácúháámɨtu nééne Dabíiúvúj tsɨɨménémúhaabe dibye íjcyaíñé dííbyeúvúhjáa ícyahíjcyacóómí Berée múnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ehdúu mɨ́amúnaa páhduváré ɨ́jtsámeí Jetsóodítyu. ");
INSERT INTO boaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Áijyúu tsaate imíllerá dííbyeke iékeevéne. Árónáacáa tsá ditye tehdu méénutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aanée diitye duurúvájá tehméjté dííbyeke iékééve tsáárome íévejtéré oomíhi: Aaméhjáa diitye paritséómuma llúúvájté avyéjujtédívú úújetémeke népejtsóme: —¿Kiávújuco diíbyej? ¿Ɨ́veekí tsá ámuha metsívatúne? ");
INSERT INTO boaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Áánélliihyéhjáa néémeé: —¿Muhdú ɨ́ɨ́né hallútú méékééveé túútaváné íhjyúváábekéjɨ́ɨ́vari? Tsá muurá múha múijyú tehdu íhjyúvatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Áánélliihyéhjáa nééme diityéke: —Áánélliihyéha íllure ámuha dííbyedívú máállítsámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tsá muurá avyéjujte íjcyárómedítyú tsaatéubáré cáhcújtsotú dííbyeke. Téhdure muha meíjcyarómé tsá mecáhcújtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Apáámyéré ihdyu ímityúmé Píívyéébé taúhbaju wáájácutúmé ɨjtsúcunú diibyéjuco Críjto íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Ehdúhjáa ditye néénéllii diityéejpi Nicodéémó tsápejcóo Jetsóoke ááhɨ́véjeebe néé diityéke: —Muurá taúhbaju néé tsá peecútéré tsáápihdívú meɨ́cúbáhrátsóityú dibye ɨɨná méénune ímíñeúvú mewáájácútúhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Áánélliihyéhjáa nééme dííbyeke: —¡Úubá bo téhdure Gariréá iiñújɨ múnáajpij! Cáhawáá Píívyéébé waajácuháámɨ́ dehve u wáájácu tsá muurá Gariréá iiñújɨ múnáadítyú dííbyé ihjyú uubálle múnáajpi íjcyaíñé némeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ehdúhjáa dííbyeke iñééne ihjyáhañévuréjuco ditye pééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Áánetúu Jetsóoma muha mepéé oríívo bájú íjcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aamée idyé tsíjcyoojɨ tsiiñe muha méoomí duurúvajávu. Átsihvúu mɨ́amúnaa dííbyedívú píhcyáávémeke iácúúvéne úwááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Áánáacáa taúhbájú uwáábojtémá paritséómú tsivá ájyúma íjcyárolle tsíjpiima íjcyálleke ityúvááólleke. ");
INSERT INTO boaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Áállekée Jetsóó tééjá pañe íjcyáábe éllevu itsájtyéne dííbyeke néémeé: —Uwááboóbej, áámye ájyúma íjcyárolle tsíjpiima íjcyálleke muha métuvááóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muuráhjáa Moitséeúvú taúhbaju néé ehdu nééné walléémuke medsɨ́jɨ́vétsoíñé néwayúúnevu maáámúneri. ¿Ácooca muhdú u néé téénetu? ");
INSERT INTO boaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Áánélliihyée íllure icyánóóvéne íhyójtsɨ́wari caatúnuube ííñujɨ. Ehdúu Jetsóoke nééme muhdú dibye nééne dííbyé hallúvú iúúbálléroki. ");
INSERT INTO boaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aanée éhnííñevúré ditye dillónéllii icyánohjúcunútsihdyu neébe: —Ané óvíi ihdyu ámúhadítyú múijyúubá ímityúné méénuhíjcyátuube áámútujkénú díílleke. ");
INSERT INTO boaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ehdúu iñééne tsiiñe icyánóóvéne caatúnuube ííñujɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aanée ehdu dibye néérónáa waajácúmé ímityúmé iíjcyane. Aamée ílluréjuco tsáápiitsádí péécunúne. Tujkénúu kéémejte péécunúhi. Ááné boonée iiyéjuco dille cóeváné tétsihvu Jetsóó úniúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aanée Jetsóó icyánohjúcunútsihdyu ɨɨtécunú iiyéjuco tétsihyi íjcyálleke. Áállekée neébe. —¿Aca kiávújuco íñe díhyallúvuné úúballéme? ¿A tsá íñe uke muhdú ditye méénúityúne? ");
INSERT INTO boaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Áánélliihyée neélle: —Íhya tsáhaj. Áánélliihyée idyé Jetsóó nééhií: —Téhdure o íjcyároobe tsá muhdú uke o méénúityúne. Ahdícyane wa dipyej. Tsiiñe ihdyu ímityúné meenújúcohdíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ááné tsiíjyúu tsiiñe mɨ́amúnáake úwááboobe nééhií: —Muurá peetédú o néébe ííñújɨri o íjcyáábej tééveri mɨ́amúnaa ɨ́mɨá uwááboju waajácuú peetédú nééne bohɨ́ɨ́vú diityéké ájcune. Aane oke cáhcujtsómé tsáhájuco éhne múu cúúvétsihyi íjcyadu ímítyúné pañe íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Áánélliihyée paritséómú néé dííbyeke: —¿Aca ɨ́veekí eene ehdu uure ú némeíhi? Tsá muurá múha uke cáhcújtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Áánélliihyée neébe: —Áánerá ɨ́mɨááné o nééhií. Muurá ó waajácú kiátúhjáa o tsáhullévú o pééiñe. Aane tsá ámuha mewáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Muurá mɨ́amúnáá ɨ́jtsaméíyé ámúhá pañe íjcyánéllii ehdu óhdityu ámuha méɨ́jtsámeíhi. Áánetu ihdyu tsáhái ícyooca múhdityú o néétu muhdú ditye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Muurá muhdú mɨ́amúnaa ícyahíjcyáné diityémá o ímíbájchoca ó nééiyá ɨ́mɨáánéjuco muhdú ditye ícyahíjcyáne. Árónáa tsá oore o méénúítyuróne. Okée wálloobe Llihíyoma muhtsi méméénúiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Muurá ámúhá taúhbaju néé míítyétsi ɨɨná pájtyene úúbállécooca mecáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ahdu muurá íñe ó némeíhijcyá ɨ́mɨááné muubá o íjcyane. Áábeke oke Llihíyó waajácú okée wálloóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ehdúu Jetsóó néénéllii nééme dííbyeke: —¿Aca kiá diibye Díícyáánií? Áánélliihyée neébe: —Oke ámuha mewáájácúmejɨ́ɨ́ méwaajácúiyá Llihíyoke. Muurá oke ámuha mewáájácuca téhdure méwaajácúiyá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ehdúu Jetsóó úwaabó duurúvájá pañe Píívyéébé ɨɨcúvé dsɨɨdsɨ pícyámeíhíjcyátsihyi íjcyámeke. Áróóbekée téijyu tsá múha ékéévetú iéévéi úújététúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ááné boonétúu idyé tsiiñe neebe diityéke: —Tsúúca muurá ámúhadítyú o péjúcoóhi. Áábeke ámuha oke menéhcorómé tsá maájtyúmɨ́ityúne. Ámuha médsɨ́jɨ́veé ámuhá imítyuháñé ímíbáávyetúmére. Áánéllii o péhullévú tsá óhdivu ámuha meúújetéityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ehdúu Jetsóó néénéllii tétsihyi íjcyame néjcatsíhi: —Dsɨ́jɨ́vétsámeíiibyéubáhaja. Íjcyátúnéllii neebe dííbyedívú meúújetéityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Áánélliihyée neebe diityéke: —Ámuha muurá mɨ́amúnaa ɨ́jɨ múnaáre. Áánetu tsá ɨ́jɨ múnáajpi o íjcyatúne. Muuráhjáa ihdyu níjkyéjɨtu o tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Áánéllii ámúhakye o néé diibyéjuco mɨ́amúnáake o pájtyetétsóóbeke cáhcújtsotúmé íimítyú ímíbáávyetúméré dsɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Áánélliihyée nééme dííbyeke: —¿Aca muubá uú? Áánélliihyée neébe: —Muurá tsúúca ámúhakye ó nehíjcyá muubá o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aane téhdure múhdurá ámuha meícyahíjcyáné ámúhakye ó nééiyáhi. Árónáa okée wálloobe ɨ́mɨáábé íjcyánéllii oke dibye néénere ámúhakye ó nehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ehdúu Jetsóó Cááni Píívyéébedítyú diityéké úúbálleróné tsá ditye wáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Áámekée idyé neébe: —Muurá Mɨ́amúnáájpidívúu o ipívyéévéébeke páwachékevu ámuha mewátyétyéhcúcooca botsíi méwaajácuú muubá o íjcyane. Tsá táɨ́jtsaméityúré o újcune ámúhakye o néhíjcyatúne. Muurá ihdyu Llihíyó oke néénere ó nehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Muurá diibye okée wálloobe tsá kiá óhdityu íjcyatúne. Aabe tsá oke ɨ́hvéjtsotú dibye ímilléné o méénuhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ehdúu dibye néénetu mítyame cáhcujtsó dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Áámekée neébe: —Muurá íñe ámúhakye o néhijcyáné ámuha mecáhcújtsóne tehdu meíjcyáhajchíí ɨ́mɨááné tahñéjté ámuha méíjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aame ámuha ɨ́mɨá uwááboju tsúúca mewáájacúmé múhdurá ámuha meícyahíjcyánetu méímíjpyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Áánélliihyée nééme dííbyeke: —Áánerá muha Aavaráaúvúj tsɨɨménémúhaabe meíjcyámeke ¿ɨ́veekí u néé ɨ́ɨ́netú muha meímíjpyetéiñe tehdu múhójtsɨ́ pañé muha meíjcyámekéjɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Áánélliihyée neébe: —Muurá ɨ́mɨááné ímityúné méénuhíjcyámé tsá ímí íjcyatú éhne múúne tsíjtyé hójtsɨ́ pañe íjcyame íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Muurá tsaaté hójtsɨri íjcyaabe tsá diityéejpi íjcyatúne. Áánetu ihdyu diityé hajchi diityéejpi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ahdu Píívyéébé Hajchi o íjcyaabe ámúhakye ímítyúnetu o ímíjpyetétsómé ɨ́mɨááné ámuha méímíjpyéteéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ɨ́mɨáánéjucóhde ámuha Aavaráaúvúj tsɨɨménémúhaabe meíjcyarómé méimíllehíjcyá oke medsɨ́jɨ́vetsóné íñe ámúhakye o úwaabóné ámuha mecáhcújtsóiyóné meímíllétúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Muurá ihdyu Llihíyó oke túkévéjtsóneri ámúhama ó ihjyúvahíjcyáhi. Ahdu muurá ámúháj caani ámúhakye túkévejtsódújuco ámuha meícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Áánélliihyée nééme dííbyeke: —Áánerá ihdyu múúhá ɨhdé múnáajpi Aavaráaúvú múúháj caáni. Áánélliihyée Jetsóó néé diityéke: —Muurá ɨ́mɨááné dííbyeúvúj tsɨɨménémúhaabe ámuha meíjcyaca dííbyeúvúu ícyahíjcyádú ámuha méíjcyáiyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aaca muurá íñe Píívyéébe oke túkévéjtsóneri ámúhakye o úwáábohíjcyáné hallútú tsá ámuha oke medsɨ́jɨ́vétsóítyuróne. Tsáháa muurá ehdu Aavaráaúvú néétune. ");
INSERT INTO boaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Árónáa ihdyu ámúháj caani íjcyadújuco ámuúha. Áánélliihyée nééme dííbyeke: —Áánerá íjcyaabe tsáápiiye múúháj caani Píívyéébeé. Tsá tsijpi múúháj caani íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Áánélliihyée Jetsóó néé diityéke: —Muurá ɨ́mɨááné Píívyéébe ámúháj caani íjcyaca oke ámuha méwájyúiyáhi. Muuráhjáa dííbyedítyú o tsáá oke dibye wállóónélliíhye. Tsáháa táɨ́ɨ́búwaríyé o tsáátune. ");
INSERT INTO boaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aabe ámúhakye o úwaabóné ¿ɨ́veekí tsá ámuha melléébohíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Muurá ihdyu ámúháj caani Naavéné íjcyánéllii dibye ímillédú ámuha méméénuhíjcyáhi. Muuráhjáa iípívyeevédújuco ímítyuube diibye dsɨ́jɨvétso múnáajpi. Áábé pañe tsá ɨ́mɨá ɨ́jtsaméí íjcyatúne. Apááñéré álliu dííbyé pañe íjcyáábedítyú ímichi teene tsahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","46","Ahdu ámuha menéénéllii tsá meímílletú ɨ́mɨááné ámúhakye o néhíjcyaróné mecáhcujtsóne. Áánetu ihdyu tsá múha oke nééítyuró ímítyuube o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muurá ihdyu ɨ́mɨááné Píívyéébeéjté íjcyame imíllé dííbyé uwááboju illéébone. Áánetu ámuha dííbyeéjté meíjcyátúnéllii tsá meímílletú teene melléébone. ");
INSERT INTO boaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ehdúu Jetsóó néénéllii nééme dííbyeke: —Ihdyúha ɨ́mɨáánéjuco muha menéhijcyáné Tsamááriá iiñújɨ múnáajpi u íjcyáábé pañe naavéné íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Áánélliihyée neébe: —Áánerá tsá tápañe naavéné íjcyatúne. Muurá ihdyu ɨɨná o méénúneri Llihíyoke ó ávyéjútsohíjcyáhi. Áánetu ámuha tsá oke maávyejúúlletúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aane tsá o íjyácunútú oke ámuha maávyéjújtsóíyóneri. Árónáa ihdyu Llihíyó imíllerá oke ámuha maávyéjujtsóne. Aabe ihdyu óvíi muhdú néé oke ávyejúúllétúmeke. ");
INSERT INTO boaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aane ɨ́mɨááné ámúhakye o néé o néhijcyáné cáhcujtsómé múijyú dsɨ́jɨvéjúcóóityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Áánélliihyée nééme dííbyeke: —Ɨ́mɨáánéhaca dípañe naavéne. Muurá eene ɨ́nehjɨ́réjucó u íhjyuváne. Ááneráhjáa Aavaráaúvuma Píívyéébé ihjyú uubálle múnaa ɨ́htsutúmé íjcyároméhjɨ́ dsɨ́jɨ́vehíjcyáhi. Aanáa muhdú ɨ́ɨ́vane u néé u néhijcyáné cáhcujtsómé múijyú dsɨ́jɨ́véityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Aca diibye méɨhdé múnáajpi Aavaráaúvú ehnííñevu uú? Áhdure ¿aca diitye Píívyéébé ihjyú uubálle múnáaúvú ehnííñevu uú? Ááneráhjáa diitye íjcyarómé dsɨ́jɨvéhi. Aanéjɨ́ɨ́ tehdu múha uke cáhcújtsóíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Áánélliihyée neébe: —Ihdyu tehdújuco ɨ́mɨááné oore o ávyéjújtsámeíhíjcyaca tsá múha oke cáhcújtsóítyuróne. Aaca idyé tsá tene ímíítyuróne. Árónáa ihdyu Llihíyóré oke ávyéjútsohíjcyá eene ámúhá Piivyéébé dibye íjcyane ámuha menéhíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Áróóbeke tsá ímí ámuha mewáájácutúne. O ihdyu ó waajácú dííbyeke. Muurá dííbyeke o wáájácutúné o nééca ámuháduíyó oo állíu múnáajpi. Árónáa ɨ́mɨááné dííbyeke o wáájácúnéllii oke dibye nééne ó cáhcútsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Muuráhjáa diibye méɨhdé múnáajpi Aavaráaúvú ímí ɨjtsúcunú o tsááiñe ɨ́mɨááné iwáájácúnélliíhye. Ááneríi mítyane ímíjyúúveébe. ");
INSERT INTO boaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ehdúu Jetsóó néénéllii néémeé: —¿Aca muhdú 50 pijcyábá u íjcyáábejɨ́ɨ́ ú waajácú Aavaráaúvuke? ");
INSERT INTO boaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Áánélliihyée neébe: —Ɨ́mɨáánetúré ámúhakye o néé dííbyeúvúikyée íjcyátúnáacájuco o ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ehdúu dibye néénéllii néwayúúné éhkebámé dííbyeke iáámúroki. Árónáacáa diityédítyú duurúvájá pañétú múijyúrá wáájácúratúné ijchívyeébe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Téhdurée tsátsihdyu muha Jetsóoma mepájtyénáa ájtyúmɨɨbe hállúvátúúbekéhjáa tsɨɨju tsɨ́ɨ́maváábeke. ");
INSERT INTO boaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Áábedítyúu muha menéé dííbyeke: —Uwááboóbej, ¿acáa ɨ́veekí áánúke íllu tsɨɨju tsɨ́ɨ́maváhi? ¿A cáánímútsí imítyú déjúcotu, mityá dííbyé imítyú déjúcotúrej? ");
INSERT INTO boaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Áánélliihyée neebe múúhakye: —Tsáháa dííbyé imítyú déjúcotu ehdu dibye íjcyatúne. Áhdurée tsá cáánímútsí imítyú déjúcotu tene íjcyatúne. Muuráhjáa ihdyu dííbyeke o ɨ́ɨ́tétsónej tééveri Píívyéébe ɨ́htsútuube íjcyane iwáájácúmeí ehdu píívyeébe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aane ó imíllé okée wálloobe níwaavéné o íjcyáné hajchótá o méénune. Muurá meííjyunúcooca tsá múha wákímyeíjyúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Muurá peetédú o néébe ííñújɨri o íjcyáné hajchótá ɨ́mɨáájú mɨ́amúnáadívú ó bóhówátsohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ehdúu iñééne ííñújɨ́ hallúvú iúníñeri ííñuba ityátsájcóneri diibye hállúvátúúbeke íhyálluúúcú tááboóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Áánemáa neebe dííbyeke: —Díllójcámeítyé éhne ‘dityée wálloóne’ nééiyóné ‘Tsiroée’ némeííbáwúutu. Ahdújucóo dibye téébatu iíllójcámeíjyéne óómiñe tsaímiyéjuco ɨ́ɨ́teébe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Áábekéhjáa wáájácuhíjcyámé iájtyúmɨ́ne néjcatsíhi: —¿Aca tsá éhne áánu hállúvátuube ácuúcunúúbé pɨáábó táúmeíhíjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Áánélliihyéhjáa tsaate nééhií: —Diibyéjuco. Áánetúhjáa tsijtye nééhií: —Diibyéjɨ́ɨ́vari. Tsíjpiíye. Árónáa ihdyu paabéjuco diíbye. Árónáacáhjáa dííbyere páñetu nééhií: —Muurá diibyéjuco oó. ");
INSERT INTO boaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Áánélliihyéhjáa nééme dííbyeke. —¿Aane múhdutú tsúúca ú ɨɨtéhi? ");
INSERT INTO boaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Áánélliihyéhjáa neébe: —Okée Jetsóó iúúniyi ííñuba ityátsájcóneri táhálluúúcú ityáábóne wallóó ‘Tsiroée’ némeííbáwúutu o íllójcámeítyeki. Ahdújucóo o péébe o íllójcámeíñe tsúúca ó ɨɨtéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Áánélliihyéhjáa nééme dííbyeke: —¿Aane kiá diíbye? Áánélliihyéhjáa neébe: —Tsá o wáájácutú kiá ícyooca dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aabéhjáa tsaímiyéjuco ɨ́ɨ́téébeke tsajtyémé paritséómu éllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Áijyúu Jetsóó dííbyeke ímíjpyetétsó wáyeéévejcóójɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Áánélliihyéhjáa tsiiñe dillómé dííbyeke múhdutú dibye ɨ́ɨ́téjucóóne. Áánélliihyéhjáa neébe: —Okée Jetsóó ííñuba iúúrúnúneri táhálluúúcú táábone o íllójcámeíñe tsúúca ó ɨɨtéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Áánélliihyéhjáa paritséómudítyú tsaate nééhií: —Áánélliihyéhaca tsá dibye Píívyéébedítyú tsáátune. Keená dibye wáyeéévejcóójɨ́ ávyejúúlléne. Áánetúhjáa tsijtye nééhií: —Árónáa ímítyuube tsá méénúítyuró méénúráítyúronéhjɨ. Ehdúhjáa paritséómú páhduváré Jetsóodítyú ɨ́jtsámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aaméhjáa diibye hállúvátuubée ícyahíjcyaabe tsaímiyéjuco ɨ́ɨ́téébeke tsiiñe nééhií: —¿Aanéhaca diibye eene uke ímíjpyetétsoobe muubá íjcyane ú ɨjtsúcunúhi? Áánélliihyéhjáa neébe: —Ihdyu ó ɨjtsúcunú Píívyéébé ihjyú uubálle múnáajpi dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Aanéhjáa tsaate diityédítyú tsá cáhcújtsotú diibyéjuco hállúvátuubée ícyahíjcyaabe dibye íjcyane. Áánemáhjáa cáánímútsikye ɨpɨ́úvámútsikye néémeé: —¿Ava diibyéjuco áánu éhneváa hállúvátúúbeke ámuhtsi metsɨ́ɨ́mávaabe íñe múhdutú tsaímiyéjuco ɨ́ɨ́tene? ");
INSERT INTO boaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Áánélliihyéhjáa neemútsi: —Éée, diibyéjuco. ");
INSERT INTO boaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Árónáa ihdyu tsá muhtsi mewáájácutú múha dííbyeke ímíjpyetétsóne. Aane tsɨ́ɨ́menécojɨ́ɨ́ tuhúúlleéhi. Cáhawáá ihdyu medílló ámúhakye dibye iúúbálle muhdú iímíjpyeténe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ehdúhjáa cáánímutsi néé diityéké diibyéjuco Jetsóó Críjto íjcyane néémekéhjáa pihcyáávéjá pañétú iwáágóoíñé ditye pítyájcámeíñé apííchori. ");
INSERT INTO boaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Áánélliihyéhjáa neemútsí dííbyekéré ditye idílloki. ");
INSERT INTO boaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ehdúhjáa cáánímutsi néénéllii tsiiñe ɨpɨ́úváábeke néémeé: —Píívyéébekéré tehdújtso, tsá idyé Jetsóoke. Muurá muha méwaajácú ímítyuube dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Áánélliihyéhjáa neebe diityéke: —Árónáa tsáháturo o wáájácutú ímítyuube dibye íjcyane. Apááñéré ó waajácú ɨ́mɨáánée hállúvátuube o ícyahíjcyáábeke oke dibye ímíjpyetétsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Áánélliihyéhjáa tsiiñe nééme dííbyeke: —¿Acáa muhdú uke ímíjpyetétsoóbe? ");
INSERT INTO boaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Áánélliihyéhjáa neébe: —Muuráhjané tsúúca ámúhakye ó úúballéhi. ¿Ɨ́veekí ámuha méimíllé tsiiñe ámúhakye o úúballéné ámuha mecáhcújtsokíjɨ́ɨ́vari? ¿Mityá ámuha méimíllé dííbyeke meúraavyéne? ");
INSERT INTO boaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ehdúhjáa dibye néénéllii ílluréjuco ditye dííbyeke iúhbáne nééneé: —Wa ihdyu uure dííbyeke duráávyej. Muurá ihdyu muha Moitséeúvú uwáábóré méúraavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Muurá muha méwaajácú dííbyeúvumáa Píívyéébe íhjyúvahíjcyáne. Áánetu eene u néébeke tsá muha mewáájácutú kiátúhjáa tsáábe muubá íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Áánélliihyéhjáa neebe diityéke: —¿Aca muhdú ɨ́ɨ́vane tsá ámuha mewáájácúityú kiátúhjáa tsáábe oke ímíjpyetétsóóbeke? ");
INSERT INTO boaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Muurá ímityúmé Píívyéébeke pɨáábó táúmeíyóné tsá dibye lléébóítyuróne. Áánetu ihdyu ɨ́mɨááné dííbyeéjté íjcyame dibye ímillédú ícyahíjcyámej tééveri tehdɨ́ɨ́vanéhjɨ́ méénuúbe. ");
INSERT INTO boaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tsá muurá múijyú mehdu nééme hállúvátúméhjɨke ímíjpyetétsóné mewáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aane muurá diibye okée ímíjpyetétsoobe Píívyéébedítyú itsáátuca tsá tehdɨ́ɨ́vanéhjɨ́ méénúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ehdúhjáa dibye néénéllii nééme dííbyeke: ¿Aca muhdú eene ɨ́daatsónée ímítyuube u píívyeebe ú imíllé múúhakye u úwaabóne? Ehdúhjáa néémere dííbyeméikye ijchívyetsó pihcyáávéjá pañétu. ");
INSERT INTO boaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aanée tsúúca Jetsóó waajácúhi. Áábekée tsáijyu iájtyúmɨ́ɨ́be neébe: —¿Aca ɨ́mɨááné ú cáhcujtsó Píívyéébé Hájchikye? ");
INSERT INTO boaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Áánélliihyée neébe: —Ávyéjuúbej, oke duubállé caabyé dibye íjcyane o cáhcújtso dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Áánélliihyée neébe: —Diibyéjuco muurá íñe úúma o íhjyuváne. Aane tsúúca oke u ájtyumɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Áánélliihyée dííbyé lliiñévú ɨmɨ́móúúvéne neébe: —Ávyéjuúbej, uke ɨ́mɨááné ó cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ááné boonée Jetsóó nééhií: —Muuráhjáa ííñujɨ́vú o tsáá muhdú mɨ́amúnaa ícyahíjcyáné diityéké o wáájácutsóvaábe. Ópée o tsáá ɨ́mɨáájú wáájácutúmé éhne múúne hállúvatúmé íjcyadu néémeke o wáájácútsoki. Áhdurée o tsáá panéváré iwáájacúné ɨ́tsúcunúhíjcyámeke o néé ɨ́mɨá uwááboju ditye wáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Áánélliihyée paritséómú tétsihyi íjcyame nééhií: —¿Áca muha tehdu hállúvatúmé íjcyadu? ");
INSERT INTO boaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Áánélliihyée neebe diityéke: —Árónáa ámuha diityédú menééca tsá ɨɨná ámúhá hallúrí íjcyáítyuróne. Áánetu ámuha páneere mewáájacúné menémeíhíjcyánéllii ámúhá hallúrí ijcyáné ímityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Muurá naní múnaa obééjámú mɨ́jcó pañévú llééhówatu úcáávetúmé ihdícyátsihdyúré úcaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Áánetu ihdyu diityé tehméébé úcaavé lleehówatu tééwá tehméébé pááyúcúcoóca. Aabe diityéké pɨ́úvácooca íjkyéétu waajácúme. Aaméjuco témɨjcó pañétú áachívú dííbye déjutu íjchivyécunúne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aabe kiávú diityéké tsúúlléhullévú úraavyémé dííbyeke iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Áánetu tsíjtyere diityéké pɨ́úváhajchíí tsá ditye péétune. Íllure wááme ditye pɨ́úvárónáa diityéké iwáájácútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ehdúu Jetsóó diityéké nééne tsá ditye wáájácutú ɨɨná iñééiyóné obééjámú mɨjcótú dibye íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aanée ditye lléébótúnéllii tsiiñe neebe íboohówájɨ́jtori: —Oo muurá ɨ́mɨááné teene obééjámú mɨ́jcó lleehówádu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Aabéikyée o tsáátúné ɨhde naní múnaádú nééme úwáábohíjcyá tsɨ́jɨjtóríye. Árómé uwáábóo tsá mɨ́amúnaa obééjámúdú nééme cáhcútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aane ɨ́mɨááné llééhowádú o néébeke cáhcujtsómé tajtyééveri pájtyetéhi. Aame ɨ́ɨ́né imíjyaú ijcyá éhne múúne obééjámú ítyehméébema íjcyame íjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muurá naní múnáajpi íllure ɨ́cúbahrá obééjámuke. Áánetúu tsá o tsáátu tehdu mɨ́amúnáake o méénuki. Ópée o tsáá diityéké o pájtyetétso ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ ditye iújcuki. ");
INSERT INTO boaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aabe ɨ́mɨááné páñétúejpi oo oke cáhcujtsómé obééjámúdú néémé tehméébe. Muurá obééjámú tehméébé diityé wájyuri ɨ́cúbáhrámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Áánetu áhdólliihyéré diityéké téhmehíjcyaabe tsá ímí téhmetúne. Muurá oohííbyé dɨ́ɨ́vaabe diityéké idyóó tsáábedítyú dibye wááné boone tsáápiikye dibye tábejcárónetu wáchájaavémé ílluréjuco mújtane pahúllevávu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ehdu muurá diityéjtane waabe ditye áhdónélliihyéré téhméroóbe. Aabe tsá diityédí íjyácunútú ihñéjté ditye íjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Áánetu ihdyu páñétúejpi diityé tehméébé íjcyadu tahñéjté tehméébé o íjcyámema muha méwaajácújcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ahdu téhdure Llihíyoma muhtsi méwaajácújcatsíhi. Aabe tahñéjte wájyuri ó ɨ́cúbáhráméií ditye iwágóóóvétuki. ");
INSERT INTO boaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Téhdure ijcyámé tsijtye jodíómú íjcyáturómé tahñéjté íjcyaímye. Áámeke ó pihjyúcuú pámeere oke cáhcujtsómé tsamééréjuco íjcyámé tehméébé o íjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Muurá Llihíyó oke wajyú diityé wájyuri o dsɨ́jɨ́veebe tsiiñe o bóhɨ́ɨ́ííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tsá muurá múha oke dsɨ́jɨ́vétsóítyuróne. Muurá ihdyu o ímíllénélliihyéré o ɨ́hvéjtsámeííbyé ó dsɨ́jɨ́veéhi. Ároobe tsiiñe ó bóhɨɨ́hi. Ehdu táúmɨwa Llihíyóo néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ehdúu Jetsóó néénetu páhduváré ɨ́jtsámeímyé dííbyedítyu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tsaatée nééhií: —Muurá áábyé pañe naavéné íjcyáábé ɨ́jtsaméí mújtáábeke ¿ɨ́veekí ámuha mécáhcútsohíjcyá állíuuháñé dibye íhjyuváne? ");
INSERT INTO boaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Árónáacáa tsijtye nééhií: —Tsáháubá ehdu naavéné ípañe íjcyaabe íhjyúváítyuróne. Pane ¿aca naavéné ípañe íjcyame hállúvátúmeke ímíjpyetétsóiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Áhdurée tsáijyu Jerotsaréeri muha úúníjyá pañe meíjcyánáa duurúvaja Píívyéébé wáábyuta íjcyaja iwáñehjɨ́nuhíjcyajcóójɨ́ wáñehjɨ́núme. ");
INSERT INTO boaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Áánáacáa Jetsóó patyéíñuhíjcyá tsátsii tééjá lleehówá úmɨwa ‘Tsaromóo’ némeítsihyi. ");
INSERT INTO boaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Áábedívúu ɨmɨ́cáávéne néémeé: ¿Aanéhaca íñe múhajchótá múúhadívú tsá u wáájácútsámeíityúne? Bo ihdyu apáhajchíí ɨ́mɨááné diibyéjuco Críjto u íjcyáhajchíí múúhakye duubállej. ");
INSERT INTO boaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Áánélliihyée neebe diityéke: —Tsúúca muurá ámúhakye ó nehíjcyará diibyéjuco o íjcyane. Árone tsá ámuha oke mecáhcútsohíjcyatúne. Téhdure muurá Llihíyo mémeri méénúráítyuróné o méénúneri ó bóhówátsómeíhíjcyará diibyéjuco o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Árone tsá ámuha oke mecáhcútsohíjcyatú táobééjámúdú nééme tahñéjté ámuha meíjcyátúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Muurá ihdyu tahñéjté oke waajácú oke icyáhcújtsónélliíhye. Áámeke téhdure ó waajácúhi. Aame ímí tehdújuco oke uráávyehíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Áánéllii diityéké ó ájcuú múijyú ditye dsɨ́jɨvéjúcóóítyúne bóhɨɨvu ditye iwágóóóvétuki. Áámeke tsá múha óhdityu dójtúcúityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Muurá Llíhíyó okée diityédívú téhmétsoobe pámé ehnííñevu ɨ́htsútuúbe. Áábedítyú tsá múha diityéké dójtúcúityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Muurá muhtsi Llihíyoma tsáápiiyéro. ");
INSERT INTO boaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ehdúu Jetsóó néénéllii tsiiñe éhkebámé néwayúúné dííbyeke téúhjɨri ɨdsɨ́jɨ́vétsóroki. ");
INSERT INTO boaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Árónáacáa neebe diityéke: —Áánerá Llihíyó oke pɨ́áábóneri ámúhama méénúráítyuróné o méénuhíjcyáábeke ¿ɨ́ɨ́né hallútú ámuha méimíllé oke medsɨ́jɨ́vetsóne? ");
INSERT INTO boaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Áánélliihyée nééme dííbyeke: —Tehdu tééné hallútú uke muha medsɨ́jɨ́vétsóíñejɨ́ɨ́vari. Muurá ihdyu ɨ́veekí mɨ́amúnáajpi u íjcyaabe Píívyéébedi u díllómeíñé hallútúré uke muha médsɨ́jɨ́vétsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Áánélliihyée neebe diityéke: —Áánerá ámúhá taúhbaju íjcyáháámɨtu Píívyéébe nééhií: “Ámuha méijcyá ohdu.” ");
INSERT INTO boaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aane muurá dííbyé uwáábó icyáhcujtsóné úráávyémeke ɨ́mɨáánéjuco dibye íwaajácúháámɨtu nééne dííbyedu ditye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aanéjɨ́ɨ́ muhdú dííbyerée oke ííñujɨ́vú wálloobe tehdu oore dííbyé Hajchi o íjcyane o néénejɨ́ɨ́vari. Aane ¿ɨ́veekí ámuha méɨjtsúcunú ímityúné Píívyéébedítyú o íhjyuváne? ");
INSERT INTO boaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ihdyu méénúráítyúronéhjɨ́ ámúhama o méénuhíjcyáné dííbyedítyú tsáátuca tehdújuco ɨ́mɨááné ámuha tsá oke mecáhcújtsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aane ihdyu okée dibye wálloone ámuha mecáhcújtsótúrónáa mécahcújtsó o méénuhíjcyanéhjɨ́ dííbyedítyú tsááne ámuha mewáájácu Llihíyoma muhtsi tsáápihdyúré meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ehdúu Jetsóó nééné hallútú idyé imíllerómé dííbyeke iékeevéne. Árónáacáa pállójcoobe diityéke. ");
INSERT INTO boaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Áábemáa tsiiñe muha mepéé Joodáá ehnéjcuvu tsojtsó múnáajpíi Jóááuvu tsótsohíjcyáhullévu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Áijyúu mítyane mɨ́amúnaa dííbyedívú píhcyaavémé néjcatsíhi: —Tsáháa muurá áánu méénuhíjcyádú Jóááuvu méénúráítyúronéhjɨ́ méénuhíjcyatúne. Árónáacáhjáa ihdyu ɨ́mɨáánéjuco díbyeúvú dííbyedítyú úúbállehíjcyáne. Ehdúu nééme Jetsóodítyu. ");
INSERT INTO boaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Áábekée mítyame tétsíi múnaa cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Áijyúhjáa ‘Ráátsaro’ némeííbyé Betáániárí íñáállemúpɨma Maaríaa, Máátaá, íjcyámúpɨma íjcyaabe cheméhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Diillée muurá Maaríá Ávyéjuube Jetsóój tuháácyú pácúúcújpácyori imúríjchóne paacyú íhñíwácori. ");
INSERT INTO boaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Aamúpɨ́hjáa wallóó tsaatéké Jetsóo éllevu dibye náhbévahíjcyaabe ɨ́hnáhó chéménélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aamée úúballévánetu neébe: —Árone dibye dsɨ́jɨvéné tsá ɨɨná íjcyatúne. Ihdyu Píívyéébe ɨ́htsútuube íjcyaabe iávyéjújtsámeíkíyé ehdu dííbyeke pajtyéne. Áhdure dííbyé Hajchi o íjcyaabe téénej tééveri o ávyéjújtsámeíki. Ehdúu neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mítyanée ɨvámeííbyé diityéké Máátaá, Maaríaa, Ráátsaroo, íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aabée Ráátsaro ɨ́hnáhó chémene ditye úúbállérónáa míjcyoojɨ́cúi ijcyá tétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Átsihdyúu botsíi neebe múúhakye: —Métsu tsiiñe mepéé Jodéá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Áánélliihyée muha menéé dííbyeke: —Uwááboóbej, muuráhjáa éíjyure téhullé múnaa uke imíllerá ɨ́dsɨ́jɨ́vetsóné néwayúúnevu iáámúneri. Áhullévú muhdú ú imíllé mepééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Áánélliihyée neébe: —Muurá cóójɨ ímí máájtyumɨ́hi. Áánéllii cóójɨ úllémeke tsá ɨɨná pájtyetúne. ");
INSERT INTO boaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Áánetu pejco úlleme cábóhcámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Átsihdyúu idyé múúhakye neébe: —Muurá ihdyu ménahbéébé Ráátsaro íllure cuwáhi. Áróóbeke ó ákyéjtsóteé téhullévú meúújetédu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Áánélliihyée muha menééhií: —Ávyéjuúbej, áánélliihyéhaca bóhɨ́ɨ́iibye ehdu idyé íllure cúwaábe. ");
INSERT INTO boaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ehdúu muha menéé ɨ́mɨá cúwáré dibye nééne meɨ́jtsúcunúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Árónáacáa botsíi ímíñeúvú neebe múúhakye: —Muurá ihdyu ɨ́mɨááné tsúúca Ráátsaro dsɨ́jɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Árónáa íllure ó ímíjyuuvé dibye dsɨ́jɨ́vénáa téhulle o íjcyátúneri éhnííñevu ámuha oke mécáhcújtsoki. Ahdícyane cáhawáá metsu meúújetékij. ");
INSERT INTO boaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ehdúu Jetsóó múúhakye néénéllii Tomáá dííbyere ‘Jemééro’ némeííbyé nééhií: —Ané wa ihdyu metsu pámeere mepéé dííbyema téhullévú medsɨ́jɨ́veki. ");
INSERT INTO boaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aanée Betáániávú muha meúújeténáa úúballémé Jetsóoke tsúúca 4 coojɨ́vájuco pájtyene Ráátsaróúvuke ditye cúúúnetu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Teenée Betáánia Jerotsaréetu míñéécú kiróómetrój pɨɨnévu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aanéhjáa mítyame péé diityépɨ́ Máátámúpɨke iñáhbénuki. ");
INSERT INTO boaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aanéhjáa diille Mááta tsúúca tétsihyíjyuco muha meíjcyane iwáájácúne cáhdahɨ́ró Jetsóoke. Áánetúhjáa Maaríá ááhɨvu coéváhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Aallée Mááta néé dííbyeke: —Ávyéjuúbej, úpée u íjcyaca táñahbe dsɨ́jɨ́véítyúroobe tsúúca dsɨ́jɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Árónáa ihdyu ó waajácú Píívyéébe uke pɨ́ááboíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Áánélliihyée neebe díílleke: —Díñahbe bóhɨɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Áánélliihyée neélle: —Éée, ɨ́mɨááné ó waajácú dibye bóhɨɨíñé páneere tsíhdyuréjuco ímíbáávyéijyu pámeere dsɨ́jɨvémé bóhɨ́ɨ́coóca. ");
INSERT INTO boaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Áánélliihyée Jetsóó nééhií: —Muurá dsɨ́jɨ́vémeke ó bóhɨɨtsóhi. Áánéllii pámeere oke cáhcujtsómé dsɨ́jɨ́verómé bóhɨɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aame tsá wágóóóvéityúne. ¿A ú cáhcujtsó uke o nééneé? ");
INSERT INTO boaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Áánélliihyée neélle: —Éée Ávyéjuúbej, ó cáhcujtsó diibyéjuco éhneváa íñe ííñujɨ́vú tsááiibye Críjto Píívyéébé Hajchi u íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ehdúu iñééne Mááta íñaalle Maaría éllevu ipyééne áábánéwu neetéhi: —Muúllej, Uwááboobe éhtsíhyi íjcyaabe uke pɨ́uváhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Áánélliihyéhjáa ɨ́ɨ́cúi peelle dííbyeke iúújetéki. ");
INSERT INTO boaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Téijyúu tsáhái muha meúújetétú técoomívu. Kémúélléhréikyée muuha Mááta múúhadívú úújetétsihyi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aanéhjáa Maaríá diityépɨke náhbenúmé ɨ́ɨ́ténáa ijchívyeíñú peecútére. Aanéhjáa ɨjtsúcunúmé íñáhbeúvuke ikímóóvéne dille íjchívyeíñúne. Áánemáhjáa úraavyémé díílleke. ");
INSERT INTO boaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aallée múúhadívú wájtsɨlle Jetsóó lliiñévú ɨmɨ́móúúvéne néé dííbyeke: —Ávyéjuúbej, úpée u íjcyaca táñahbe dsɨ́jɨ́véítyúroobe tsúúca dsɨ́jɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ehdúu iñééne taálle. Téhdurée dííllema pééme tááhií. Aanée Jetsóoke kímóhcó pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aabée néé diityéke: —¿Kiátúhjáa ámuha mécuuú dííbyeúvuke? Áánélliihyée néémeé: —Cáhawáá metsu meúújeté ténijkye. ");
INSERT INTO boaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Ehdúu ditye nétsiu Jetsóó táánéllii néjcatsímye: —Mítyanée muurá wájyuube dííbyeúvuke. ");
INSERT INTO boaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Áánetúu tsaate nééhií: —Áánerá hállúvátúméhjɨke ɨ́ɨ́tétsohíjcyaabée ¿ɨ́veekí tsá múhdúubá méénutú dííbyeúvuke dibye ɨdsɨ́jɨ́vétuki? ");
INSERT INTO boaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aamée dííbyeúvú níjkyé hallúvú muha meúújeténáa tsiiñe Jetsóó kímoovéhi. Áijyúu teene níkyehéjú wátájcámeí mítyau nééwayúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aanée neebe diityéke: —Cána eeu nééwayu méɨɨnétsoj. Árónáacáa dííbyeúvú naalle Mááta nééhií: —Ávyéjuúbej, árónáacáubá tsúúca toocújúcoóbe. Muurá tsúúca 4 coojɨ́vájuco mee díbyeúvúu dsɨ́jɨ́vétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Áánélliihyée neébe: —Muuráhjané idyé uke o néé oke u cáhcújtsóhajchíí Píívyéébé ɨhtsútú u ájtyúmɨíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ehdúu dibye néénéllii awáá ɨ́ɨ́netsómé teeu nééwayu. Áánáacáa cáámevu icyárúúvéne Cááníma íhjyúvaabe nééhií: —Ayúju Táácáániíj, uke ó téhdujtsó páneere uke o nééne oke u lléébohíjcyáné hallúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Muurá ó waajácú oke u lléébohíjcyáne. Ehdu íñe uke o néé íjtye mɨ́amúnaa icyáhcújtso ɨ́mɨáánée oke u wálloóne. ");
INSERT INTO boaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ehdúu Cááníma iíhjyúvátsihdyu tsɨ́jpánécoba neébe: —¡Rátsa Ráátsaroj, díjchivye eene níkyéhéjú pañétu! ");
INSERT INTO boaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ehdúu dibye néénemáyé ijchívyéjúcoobe dityéhjáa bɨ́ɨ́jɨ́núnéhjɨmáye. Áánélliihyée neebe diityéke: —Métsiñu eene ɨ́bɨɨjɨ́nuháñe. ");
INSERT INTO boaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ehdúu dibye méénune iájtyúmɨ́néllii Maaríama péémedítyú mítyame cáhcujtsó dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Áánetúu cáhcújtsotúmé paritséómu éllevu ipyééne úúbálletéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ááné lliiñétúhjáa píhcyaavémé pámeere llúúvájté avyéjujtémá tsijtye páñétúejte ávyéjujte ipítyácójcatsí muhdú dííbyeke imyéénuíñe. Aaméhjáa néjcatsíhi: —¿Aca muhdú íñe méméénuú dííbyeke? Muurá ɨ́mɨááné méénuhíjcyaabe méénúráítyúronéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Muurá éhdure dííbyeke meɨ́hvéjtsóhajchíí pámeere dííbyekéréjuco ávyejúúlleíñe. Áijyu muurá romáánómú méhdivu icyáyobáávaténe íñe méduurúvaja iwácávyáhcóne méhdi ɨ́cúbáhráiyáhi. Ehdúhjáa néjcatsímye. ");
INSERT INTO boaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Áijyúu tééné pijcyábari diityédítyú tsaapi piañétúejpi llúúvájté avyéjuube íjcyaabe Caipáá néé diityéke: —Ávyétá muutérá mɨ́a ámuha ɨ́ɨ́néubárá wáájácutúme. ");
INSERT INTO boaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Muurá ihdyu tehdújuco tsáápiiye dsɨ́ɨ́véiyóné pámeere meóúúvéíyóné ɨhdétu. ");
INSERT INTO boaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ehdúhjáa neebe Caipáá Píívyéébere ɨ́jtsámeíchóneri Jetsóó dsɨ́jɨ́veíñé jodíómu wájyuri. Tsáháhjáa íhdityúré iújcune ehdu dibye néétune. ");
INSERT INTO boaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Árónáacáa tsá apáámye wájyuríyé dibye dsɨ́jɨ́vetúne. Téhdurée dsɨ́jɨ́veebe pámeere múhdumé Píívyéébej tsɨ́ɨ́mé ííñújɨri íjcyame dííbyeke cáhcujtsómé ipájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aanée téijyu pítyácójcatsímyé muhdú dííbyeke ɨdsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Áánélliihyée tsáhájuco dibye boohówáneúvú péhíjcyatú mɨ́amúnááj pɨɨ́ne. Áábemáa muha mepéé Jodéá iiñújɨtu Eeparaíivu ɨ́ɨ́néubárá píívyétúné iiñújɨ́j pɨɨhɨ́rí íjcyácoomívu. Ácoomíyíi muha méícyahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Áijyúu lleeváríjyuco pajtyété wañéhjɨ́ muháa ténevá pijcyábádú mewáñehjɨ́vatéhijcyáne. Ááné ɨhdéjucóo hállúécoomíjɨ múnaa péécunúné Jerotsaréevu muhdú iícyahíjcyáné iímíbájchómeíki. ");
INSERT INTO boaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aaméhjáa duurúvájá pañe íjcyame Jetsóoke iájtyúmɨ́íyóneri íjcyame néjcatsíhi: —¿Muhdú ámuha méɨjtsúcunúhi? ¿Aca íhya tsááiíbye, mityá tsáhaáj? ");
INSERT INTO boaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Áánáacáhjáa paritséómú llúúvájté avyéjujtémá pámeekéré néé ditye kiá Jetsóó íjcyane iwáájácúcooca ɨ́ɨ́cúi diityéké iúúbálle ditye dííbyeke iékééveki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aanée téijyu íhyojtsɨ́tú tsájcoojɨ́turéjuco teene pajtyété wañéhjɨ́ llééváíñáa Jetsóoma muha mepéé Betáániávu dibyée bóhɨ́ɨ́tsoobe Ráátsaro íjcyácoomívu. ");
INSERT INTO boaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Áijyúu diitye Ráátsarómú mítyane majcho meenú dííbyeke idyúúruváne. Áánevúu Mááta ájcune máchohíjcyamútsí diibye Jetsóoma. ");
INSERT INTO boaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Áánáacáa ‘náádoó’ némeíñé pacúúcujpácyó mítyane áhdótsámeíjpácyó itsíváne Maaríá múrijchó Jetsóój tuháácyu. Áánemáa páácyulle íhñíwácoríyé dííbyeke. Aanée pájá pañéré imyéwu cuvááhií. ");
INSERT INTO boaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ájpacyó hallútúu múúhadítyú tsaapi Jetsóodívúhacáa méénútsóiibye Tsimóó hajchi Jóóda Ijcarióóté néé múúhakye: —¿Aca ɨ́veekí éjpacyo tsá menáhjɨ́hénutú 300-jɨva tsáné pijcyábá wákimyéi áhdodúné tééne dsɨ́ɨ́dsɨri ɨ́dáátsojtéké mepɨ́áábóíyoki? ");
INSERT INTO boaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Árónáacáa tsá ɨ́mɨááné ɨ́dáátsojtéké ɨpɨ́áábóíyóneri iíjyácunúnéllii ehdu dibye néétune. Ihdyúhacáa múúhama dsɨ́ɨ́dsɨke ityéhmehíjcyánetu iñánihíjcyánélliihyéré imílléroobe téjpacyo náhjɨ́hénúmeíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Áábekée Jetsóó nééhií: —Óvi ihdyu oke téjpacyórí múríjcholle. Muurá ihdyu oke ditye cúúúcooca oke itsójtsóiyónéjuco dille méénune. ");
INSERT INTO boaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tsá diitye ɨ́dáátsojte kiávú ámúhadítyú pééityúne. Áánetu tsá paíjyuváré ámúhama o íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aanéhjáa mítyame tsúúca waajácú Betáániárí dibye íjcyane. Áánélliihyée tsáácunúmé dííbye éllevu. Áhduréhjáa imíllémé Ráátsaróké iájtyumɨ́né dsɨ́jɨ́véébekée dibye bóhɨ́ɨ́tsóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Téijyúhjáa llúúvájté avyéjujte néjcatsí téhdure Ráátsaróké ɨdsɨ́jɨ́vétsóiyóné ɨ́veekí dííbyeke Jetsóó bóhɨ́ɨ́tsónéllii mítyane mɨ́amúnaa dííbyekéréjuco icyáhcújtsóne úráávyéné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Ááné tsiíjyúu Jerotsaréevu muha mepéénáa técoomíyí mítyame pahúllevá múnaa teenéhjáa pajtyété wañéhjɨvu péémeé. Aaméhjáa Jetsóó tsááne iwáájácúne wájyuhóónema dííbyeke cáhdahɨ́rómé íllu wáñécohíjcyáhi: —¡Ñóóooj, maímijyu áánu ijraéémú Piivyéébe mémeri tsááneéj! Ehdúhjáa nehíjcyámé iwáñéjcónema. ");
INSERT INTO boaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Áijyúu bóhdɨɨbe íayáne ɨ́ɨ́jú hallúrí tsúúcajátújucóhjáa Píívyéébere íwaajácúháámɨtu íllu néhdújuco: ");
INSERT INTO boaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ámuúha Tsióó cóómi múnaaj, méíllityédíñe. Ámuha éllevu ámúhá avyéjuube tsáá íayáne ɨ́ɨ́jú hájchí hallúri. ");
INSERT INTO boaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ehdúu dííbyedítyú némeíñé tujkénú tsá muha mewáájácutú ɨɨná tene nééiyóne. Árónáacáa bóónétu cáámevu dibye iávyéjuuté péénetu muha méɨ́tsaavé teenéhacáa nééiyóné ehdu dííbyedítyú tene néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aanée tétsihyi íjcyame úúbállehíjcyá muhdúhjáa Ráátsaro dsɨ́jɨ́véébeke dibye bóhɨɨtsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aanée teene méénúráítyuróné dibye méénune iwáájácúnéllii mítyame cáhdahɨ́ró dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Áámekée ɨɨ́ɨ́téne paritséómú néjcatsíhi: —Ehdɨ́ɨ́vane, ámuúhaj. Muurá mítyane mɨ́amúnaa dííbyekéréjuco úraavyéne. Aane tsá mepíívyetétú muhdú meméénune. ");
INSERT INTO boaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Áijyúu Jerotsaréeri pajtyété wañéhjɨri muha meíjcyámé pañe ijcyámé gríéégomu. ");
INSERT INTO boaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aamée Gariréá iiñújɨri Betsáida íjcyácóómi múnáajpi Perípe éllevu itsááne nééhií: —Muúbej, muha méimíllé Jetsóoke maájtyumɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aanée Perípé Aderéeke úúballéné tsamútsíjyuco úúballéné Jetsóoke. ");
INSERT INTO boaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Áánélliihyée neebe diityétsikye: —Tsúúca muurá Mɨ́amúnáájpidívúu o ípívyééveebe o ávyéjuutéíñe éévé úújetéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Muurá ɨ́mɨááné ámúhakye o néé tríígó neeváú mebájtsou dsɨ́jɨ́veúdú iíjcyátsihdyu ííñeu mítyanéjuco llííyaaténe. Ahdu ó dsɨ́jɨ́veé mítyame Píívyéébé avyéjúejte iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muurá muhdú ɨ́jɨɨri iícyahíjcyajɨ́jtóré ímillémé wágóóóveéhi. Áánetu ímityúné imyéénuhíjcyáné ɨ́hvejtsómé újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ahdícyane tsaate tahñéjté iíjcyane iímílléhajchíí óvíi ookéréjuco úraavyéne. Muurá oke ɨ́ɨ́cúvehíjcyámeke Llihíyó ávyéjújtsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ehdúu iñétsihdyu neébe: —Muhdú íhya múhduúvúrá ícyooca táɨ́ɨ́buwa. ¿Aane muhdú íñe teéne? Óubá Llihíyoke ó táúmeíiyá ɨɨná oke pájtyénetu dibye oke ipájtyetétsoki. Tsáhaá. Muuráhjáa ímichi téénéllii oke wálloóbe. ");
INSERT INTO boaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Átsihdyúu neébe: —Ayúju Llihíyoj, óvíi ihdyu ú bóhówájtsómeíhi. Áánélliihyée níjkyéjɨtu Píívyéébe nééhií: —Tsúúca muurá ó bóhówájtsómeíhi. Árónáa éhníínevu tsiiñe ó bóhówájtsóméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aanée tétsihyi íjcyame illéébóne nééhií: —Chijchi ihjyúváhi. Áánetúu tsijtye nééhií: —Níjkyéjɨ múnáajpi dííbyema ihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Áánélliihyée neebe diityéke: —Áánerá ihdyu ámúhakye iñéérone ookéré neébe. ");
INSERT INTO boaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aane tsúúca mɨ́amúnaa ímityúmé iíjcyanévú néétsámeííñe éévé úújetéhi. Téhdure ííñújɨ́ avyéjuube Naavéné tsúúca táhjátsáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Muurá oke cáámetu wátyétyéhcuímyé pámeere óóma iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ehdúu bóhówájtsoobe Jetsóó muhdú ditye dííbyeke dsɨ́jɨ́vétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Áánélliihyée nééme dííbyeke: —Áánerá muha mélléébohíjcyá Píívyéébé waajácúháámɨtu ditye éévehíjcyáné mɨ́amúnáake pájtyetétsóiibye Críjto muhdú íjcyáityúne. Áánáa muhdú u néé u dsɨ́jɨ́veíñé Mɨ́amúnáájpidívúu u ípívyééveébe. ¿Mityá tsíjpiiyéí diíbyej? ");
INSERT INTO boaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Áánélliihyée neébe: —Muurá ihdyu peetédú o néébe wahájchotáwuúré ámúhama ó íjcyaáhi. Áánéllii ɨ́mɨáámeréjuco meíjcyá ámúhama o íjcyánej tééveri péjcodu nééne ímityúné ámúhakye idyómájcótuki, ámuha éhne múúne cúúvétsihyi íjcyame wáájácúmeítyúmé íjcyadu meíjcyátuki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ahdícyane peetédú o néébedi ɨ́mɨá uwááboju íjcyane mécahcújtsó tééneréjuco ámúhadítyú ibóhówaúcunúki. Ehdúu Jetsóó diityéké iñétsihdyu péébe tsáhájuco tsiiñe diityédívú bóhówáávetúne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mítyáméj pɨɨnévú méénúráítyúronéhjɨ́ dibye méénuhíjcyárónáa tsaate tsá dííbyeke cáhcútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ehdúhjáa ditye cáhcújtsóityúné Píívyéébe nééne dííbyé ihjyú uubálle múnáajpi Itsaíá cáátunúné nééhií: Píívyéébeéj, ¿a ijcyámé tsaate méuwáábori ɨ́ɨ́cuvémej? Muurá tsúúca ú úújetsójúcoorá diityéké dɨ́ɨhtsútuvu. ");
INSERT INTO boaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Muuráhjáa ɨ́mɨááné tsá ditye cáhcútsohíjcyatú dííbyeke. Íllúhjáa idyé tsiiñe caatúnuube Itsaía: ");
INSERT INTO boaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Píívyéébere ihdyu diityéké pívyétejtsó hállúvatúmé íjcyadu nééme ɨ́ɨ́buúúné wáájácúmeítyúmé iájtyumɨ́júcooróné illéébójúcooróné ‘ehdúhaáca’ iñéétuki, aame diibyéjúcooro diityéké ímítyúnetu ímíjpyetétsóíyóóbedi ɨɨ́ɨ́cúvétuki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ehdúhjáa neebe Jetsóodítyú Itsaía Píívyéébé ihjyú uubálle múnáajpi tsúúcajátújuco dííbyé ɨhtsútú iátyúmɨhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Áróné pañée mítyame cáhcujtsó tamúnaa jodíómú Jetsóoke ávyéjujte íjcyáróméhjɨmájuco. Aamée dííbyeke icyáhcújtsoróné tsá pámehdívúré bóhówáávétsotú paritséómú diityéké pihcyáávéjá pañétú wáágóóíyóné apííchori. ");
INSERT INTO boaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Imíllerómée ímí Píívyéébema iíjcyane. Árónáacáa éhnííñevu imíllémé mɨ́amúnáamáyé ímí iíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Áijyúu Jetsóó kéévánécoba nééhií: —Muurá oke cáhcujtsómé tsúúca cáhcujtsó Llihíyoke okée wállóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Áhdure oke ájtyumɨ́mé tsúúca ájtyumɨ́ dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Muuráhjáa peetédú nééne ɨ́mɨá uwáábójuma o tsáá ííñujɨ́vú teene cáhcujtsómé éhne múu cúúvétsii íjcyadu ímítyúné pañe iíjcyájúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aane íñe o úwaabóné illéébójúcooróné cáhcújtsótúmeke tsá o nééítyuró ímityúmé ditye íjcyane. Tsáháa o tsáátu mɨ́amúnáadi o ɨ́cúbáhraki. Ópée o tsáá diityéké o pájtyetétsoki. ");
INSERT INTO boaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Árónáa ihdyu muhdú mɨ́amúnaa ícyahíjcyáné ímíbájchómeícyooca íñe o úwáábohíjcyáné iéhdɨɨválléne cáhcújtsotúmé tééné déjúcotu néétsáméiíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aane íñe ámúhakye o néhíjcyanéhjɨ́ tsá táɨ́jtsaméityúré o újcune o néhíjcyatúne. Muurá ihdyu Llihíyó okée wálloobe oke néhdújuco ámúhakye o úwáábohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aane ɨ́mɨááné dííbyé uwááboju lléébome újcuú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. Ehdu ámúhakye ó nehíjcyá Llihíyó oke néhdújuco. Ehdúu neebe Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aanée teene pajtyété wañéhjɨ́ lleeváríjyuco íjcyánáa tsúúca waajácuube mɨ́amúnáama ííñújɨri iícyahíjcyátsihdyu Cáání éllevu ióómiíñe. Aabée mítyane múúhakye iwájyune úújétsohíjcyá múúhadítyú ipyétsihvújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Áánáacáhjáa tsúúca Tsimóó hajchi Jóóda Ijcaríóóté ɨ́ɨ́búwá pañévú Naavéné úcaavé dibye dííbyedívú méénútsóíñé ɨ́jtsaméima. ");
INSERT INTO boaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aabée Jetsóó waajácú Cááni Píívyéébe éllevu tsiiñe ióómiíñe. Téhdurée waajácuube dííbyeke dibye pícyoone páné avyéjuubéré dibye iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aabée majchórí muha meíjcyánáa hállúeja íwajyámú ityácórɨ́ɨ́véne ípáácyuméibávú ɨ́jpɨɨnétú chíaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Áánemáa llíyíhlló pañévú nújpacyo ipícyójpácyori múúháj tuhááñé iñíjtyúne páácyuube eenée íjpɨɨnétú ichíáávéhbari. ");
INSERT INTO boaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aanée Tsimóo Péédoróké dibye níjtyúíyónáa neébe: —Ávyéjuúbej, ¿aca muhdú ɨ́ɨ́vane oke ú níjtyuú tájtyúhaacyu cáábyekérá uke o níjtyúíyóóbeke? ");
INSERT INTO boaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Áánélliihyée neébe: —Tehdújuco. Árónáa tsá u wáájácutú ɨ́veekí ehdu o méénune. Aane ihdyu cáhawáá óvíi ú waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Áánélliihyée neebe Péédoro: —Árónáa tsá oke u níjtyúítyuróne. Muurá ihdyu uke ó níjtyúiyáhi. Árónáacáa neebe dííbyeke: —Muurá uke o níjtyútuca tsá u íjcyáítyuró táavyéjúejpi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Áánélliihyée idyé neebe Péédoro: —Ávyéjuúbej, aanéjɨ́ɨ́va tsá apááñéré tájtyúhaacyu u níjtyúityúne. Téhdure oke nijtyu táhníwáuma táhójtsɨcu. ");
INSERT INTO boaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Áánélliihyée Jetsóó néé dííbyeke: —Muurá iávúhcútsihdyu íjchivyémé íjtyúhaacyúréjuco níjtyámeíñé íjpi ííñuvájúcóótúnélliíhye. Ahdu muurá ícyooca ímíhyero ámuúha. Árónáa tsá pámeére. ");
INSERT INTO boaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ehdúu neebe múúhadítyúhacáa tsaapi dííbyedívú méénútsoíñé iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ehdúu múúháj tuhááñé iñíjtyúne tsiiñe íwajyámuvu iúcáávéne ácúúveebe múúháj pɨɨnévú ípyée iácuúcunúhíjycyátsihvu. Áánemáa neebe múúhakye: —¿A ámuha méwaajácú ɨ́veekí ehdu ámúhakye o méénune? ");
INSERT INTO boaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Muurá ámuha oke médíllohíjcyá Uwáábóóbemáyé Ávyéjuube o íjcyane. Aane diibyéjuco o íjcyáábeke ihdyu tehdújuco ámuha oke medíllohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Muurá ɨ́mɨááné Uwáábóóbemáyé Ávyéjuube o íjcyároobe ámúháj tuhááñé ó nijtyúhi. Aane ihdyu óvíi tehdu ámuha ménítyúcatsíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Muurá ehdu ó meenú tehdu ámuha pamévakéré maávyejúúlleki. ");
INSERT INTO boaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Muurá ɨ́mɨááné ámúhakye o néé tsáné avyéjúúbé úníu múnáajpi tsá diibye íavyéjúúbé ehnííñevu íjcyatúne. Áhdure tsaate tsáápiikye tsiéllevu wálloobe tsá diityé ehnííñevu íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ehdu ámúhakye o néhijcyáné ámuha melléébóne tehdu meícyáhajchíí muurá ɨ́ɨ́né imíjyaú ámuha meíjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Árónáa tsá pámeere tehdu ámuha meíjcyáityúne. Muurá ó waajácú caatyé ɨ́mɨááné tahñéjté íjcyane. Árónáa ihdyu tehdújuco tene pájtyeíñé tsúúcajátújucóo Píívyéébe íwaajácúháámɨtu íllu néhdújuco: “Dííbyema muhtsi memáchohíjcyároobe óhdivu méénútsoóhi.” ");
INSERT INTO boaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ehdu oke tene pájtyeíñé ɨ́hdétújuco ámúhakye o úúballéné néhi tene pájtyéijyu ámuha oke mecáhcújtso ɨ́mɨááné diibyéjuco o íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aane ɨ́mɨááné o néé íñe ámúhakye o wállóómeke ímí iwáátsúcúpéjtsómedi ɨ́ɨ́cuvémé idyé muurá ookéjuco ɨ́ɨ́cuvéne, áhdure Llihíyó okée wállóóbekéjuco ditye ɨ́ɨ́cuvéne. ");
INSERT INTO boaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ehdúu Jetsóó múúhakye iñétsihdyu múhduúvúrá illíñémuúcunúmeíñe tsiiñe nééhií: —Muurá ɨ́mɨááné ámúhadítyú tsaapi óhdivu méénútsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aanée tsá muha mewáájácutú cáábyedítyú dibye nééneé. Áánélliihyée muha íllure méɨ́ɨ́téjcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Téijyúu muha memájchónáa mítyane dibye oke ɨ́vámeííbyé dííbyé úníuri ó ácuúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Áábekée oke Tsimóo Péédoro néé o díllo dííbyeke ímichi cáábyedítyú ehdu dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ahdújucóo dííbyeke áábánéwu o nééneé: —Ávyéjuúbej, ¿aca caabyé ímichi úhdivu méénútsoóhi? ");
INSERT INTO boaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Áánélliihyée neébe: —Pááaho o ééníyohóvú o ájcuúbe. Ehdúu néébere iééníyohóvú ajcú Tsimóó hajchi Jóóda Ijcarióóteke. ");
INSERT INTO boaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Áijyúu tsúúca dííbyé pañévú Naavéné úcaavéné iwáájácúne Jetsóó néé dííbyeke: —Wa bo ɨ́ɨ́cúi ɨɨná u méénuíñé meénuj. ");
INSERT INTO boaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ehdúu dibye nééne tsá muha dííbyema majchórí meíjcyámedítyú tsáápíubáré wáájácutú ɨ́veekí ehdu dibye dííbyeke nééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tsaatée ɨjtsúcunú dsɨ́ɨ́dsɨ́ tehméébé dibye íjcyánéllii ehdu dibye nééne wañéhjɨ́ wáábyuta tsíeméné dibye iáhdoki. Áhdurée ɨjtsúcunúmé ɨ́dáátsojtéké dibye dsɨ́ɨ́dsɨtu ájcúiyóné ehdu dibye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aanée diibye Jóóda Jetsóó pááahóvú ájcune imájchóne múúhadítyú péjucóó tépejco. ");
INSERT INTO boaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Áábe déjuvúu Jetsóó nééhií: —Ícyooca ihdyu Mɨ́amúnáájpidívúu o ípívyééveebe ó ávyéjúúteé Píívyéébé avyéjú iwáájácúmeíki. ");
INSERT INTO boaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aane lléváhréjuco muhtsi maávyéjútsójcatsíiñe Píívyéébema. ");
INSERT INTO boaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Muurá ámúhakye o pícyoíñúmé oke ámuha menéhcorómé tsá maájtyúmɨ́ityú áátsɨɨméjuco ámuha meíjcyaróme. Aane ámúhá avyéjujtékée o néhdu tsá ámuha ícyooca mepééityú o péhullévu. ");
INSERT INTO boaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ahdícyane ámúhakye ó táuhbá muhdú ámúhakye o wájyudu ámuha mewájyújcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Muurá ɨ́mɨááné ámuha mewájyúcatsíhajchíí téénetu pámeere mɨ́amúnaa waajácuú ɨ́mɨááné tahñéjté ámuha meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ehdúu Jetsóó néénéllii Tsimóo Péédoro néé dííbyeke: —Ávyéjuúbej, ¿aca kiávú ú peéhi? Áánélliihyée neébe: —Ícyooca tsáhái óóma u pééityúne. Árónáa bóónétúi oke ú úráávyeéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Áánélliihyée Péédoro néé dííbyeke: —Ávyéjuúbej, ¿Aca ɨ́veekí tsá ícyooca úúma o pééityúne? Muurá téhdure ó dsɨ́jɨ́véiyá diwájyuri. ");
INSERT INTO boaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Áánélliihyée neébe: —¿Aca ɨ́mɨááné u néé tawájyuri u dsɨ́jɨ́véiyóne? Muurá ɨ́mɨáánetúré uke o néé ípyejco cáracái májtsívátúnáa oke u úráávyeróóné u tóónuíñé 3-ijyúva. ");
INSERT INTO boaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aane ihdyu ɨ́ɨ́nerí maáábímyeídíñe. Llihíyoma múhtsidívú mécátsɨpááve. ");
INSERT INTO boaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Muurá dibye íjcyáhulle ijcyáné meíjcyáíyotsɨ́hjɨ. Muurá tene íjcyátuca idyé ó nééiyá tene íjcyatúne. Árónáa ijcyáne. Áánéllii o péé téhullévú ámúhá ɨhde o ímíbájchoki. ");
INSERT INTO boaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aane o ímíbáávyetsódú ámuha tahñéjteke ó ujcúvaá tsatsíhyí meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muurá ámuha méwaajácú kiávú o pééiñe. Áhdure ámuha méwaajácú muhdú téhullévú ámuha meúújetéiñe. ");
INSERT INTO boaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ehdúu múúhakye Jetsóó néénéllii Tomáá nééhií: —Ávyéjuúbej, tsá muha mewáájácutú kiávú u pééiñe. Téhdure tsá muha mewáájácutú muhdú téhullévú meúújetéiñe. ");
INSERT INTO boaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Áánélliihyée neebe dííbyeke: —Oo muurá téhullévú úújeténe júúvádú o néébedi ɨ́mɨá uwááboju íjcyane cáhcujtsómé ujcú múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ. Aame tajtyééveri úújeté Llihíyodívu. ");
INSERT INTO boaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Muurá ámuha oke mewáájácúhajchíí tsúúca téhdure méwaajácú Llihíyoke. Tsúúca muurá ámuha máájtyumɨ́ dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Áánélliihyée Perípé nééhií: —Ávyéjuúbej, cána múúhakye dájtyumɨ́tsó Díícyáánidívú muha tééneri meíjyácunújúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Áánélliihyée neebe dííbyeke: —¿Aca muhdú íhyajchótá ámúhama o íjcyáábeke tsá oke u wáájacúpityúne? Muurá oke ájtyumɨ́mé tsúúca ájtyumɨ́ Llihíyoke. Aanéjɨ́ɨ́ ¿muhdú Llihíyodívú ámúhakye o ájtyúmɨ́tsóiyóné oke u nééhií? ");
INSERT INTO boaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Aca tsá u cáhcújtsotú dííbyema tsáápihdyúré muhtsi meíjcyane? Muurá dííbyere tajtyééveri ámúhakye úwáábohíjcyáhi. Tsá ɨɨná óhdityúré o újcune o méénuhíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aane ihdyu mécahcújtsó tsáápihdyúré muhtsi Llihíyoma meíjcyane. Pane eene méénúráítyúronéhjɨ́ ámuha meɨ́ɨ́ténáa o méénuhíjcyánéúbatu bo oke mécahcújtsoj. ");
INSERT INTO boaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Muurá ɨ́mɨááné ámúhakye o néé oke ímí cáhcujtsómé téhdure o méénuhíjcyádú méénúráítyúronéhjɨ́ méénuíñe. Muurá Llihíyodívú o úújetéébé téhullétú diityéké o pɨ́aabómé éhnííñevu íjcyanéhjɨ́ méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aane panéváré ámuha dííbyeke tamyémeri metáúmeímyeke ó pɨ́ááboó tééneri dííbyé ɨhtsútú o bóhówájtsoki. ");
INSERT INTO boaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ahdícyane panéváré pɨáábó tamyémeri ámuha metáúmeíñetu ámúhakye ó pɨ́ááboóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aane óvíi ɨ́mɨááné ámuha oke mewájyúhajchíí mélleebó muhdú ámuha meíjcyaíñé ámúhakye o néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Muurá Llihíyoke ó táúméií dibye ámuha éllevu iwállo Íapííchó ámúhakye tene ɨpɨ́áábohíjcya panévatúré ímí ámuha meíjcyaki. Aane tsá ámúhadítyú kiá íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Muurá teene ɨ́mɨájɨjtóvú meke waajácutsóhi. Aane tsá úcáávéityú ɨ́jɨ́ene úráávyehíjcyámé pañévú teene ditye wáájácútúnélliíhye. Áánetu ihdyu ámuha tsúúca méwaajácú ámúhama tene íjcyánélliíhye. Aane ámúhá pañévú úcááveéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ahdícyane tsá ámúhakye o ɨ́hvéjtsóityúne. Muurá tsiiñe ámúha éllevu ó tsaáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aabe lléváhréjuco ɨ́jɨɨtu o péébeke tsáhájuco múha oke ájtyúmɨ́ityúne. Árónáa ihdyu ámuha oke máájtyúmɨɨ́ o bóhɨhdu ámuha mebóhɨ́ɨ́íñélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aane cáhawáá óvíi ámuha méwaajácú muhdú Llihíyoma muhtsi meíjcyane, téhdure muhdú ámúhama tsame meíjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Aane ihdyu óvíi oke wájyume lleebó muhdú diityéké o néhijcyáne. Ááneri úújétsoímyé ɨ́mɨááné oke iwájyune. Áámedívú o wáájácútsámeímyeke muhtsi Llihíyoma méwájyuúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ehdúu Jetsóó néénéllii tsijpi Jóóda Ijcarióóté íjcyátuube néé dííbyeke: —Ávyéjuúbej, ¿aca ɨ́veekí múúhadívúré ú waajácútsáméií tsíjtyedívú wáájácútsámeítyuúbe? ");
INSERT INTO boaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Áánélliihyée neébe: —Muurá oke wájyume o nééne lléébómedívúré ó waajácútsáméiíhi. Áámeke Llihíyó iwájyúne diityé pañévú Íapííchó pícyoó téénej tééveri ímí tsaméhjɨ́ diityémá muha menáhbévájcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muurá o nééne lléébotúmé tsá oke wájyutúne. Ehdu íñe ámúhakye o néhijcyáné tsá táɨ́jtsaméí íjcyatúne. Muurá ihdyu okée wálloobe Llihíyóré ehdu ámúhakye nehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Aane íñe ámúhakye ó nehíjcyá ámúhama o íjcyáné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Árónáa bóónétu Llihíyó Íapííchó ámúha éllevu wálloonéréjuco ámúhakye pɨ́ááboíñé panévatúre. Aane ámúhakye túkévéjtsoó muhdú ámuha meíjcyaíñé ámúhakye o úwáábohíjcyánetu. Téhdure tsíñehjɨ́vú ámúhakye waajácútsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aane ámúhakye o pícyoíñúmé tadyéjuvu ehdícyáróné pañe ímíñeúvú méíjcyaco ɨ́ɨ́nerí ɨ́jtsámeítyúme. Árónáa tsá ámúhakye o néétu mɨ́amúnaa ímíjyútsócatsíhijcyádú nééné ɨ́jtsaméima ámúhakye o pícyoíñuíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aane muurá ámúhakye ó nehíjcyá lléváhréjuco ámúhadítyú o péébe idyé tsiiñe ámúha éllevu o tsááiñe. Aane ɨ́mɨááné ámuha oke mewájyúhajchíí méímíjyúúveé Llihíyó táehnííñevu ɨ́htsútuube íjcyáábe éllevu o pééneri. ");
INSERT INTO boaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aane ámúhakye ó úúballé ɨ́hdéjuco néhi tehdu tene pájtyéijyu ámuha mecáhcújtso ɨ́mɨááné o néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aane íñe nihñéréjuco ámúhama o íhjyuváne. Tsúúca muurá ííñújɨ́ avyéjuube átéréejpíyé íjcyároobe tawáábyú tsáábe pɨ́ɨ́hɨ́jucóóhií. ");
INSERT INTO boaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Áábedívú ihdyu ó ɨ́hvéjtsáméií Llihíyó ímillédújuco pámeere mɨ́amúnaa iwáájácu ɨ́mɨááné dííbyeke o wájyúnéllii dibye oke néhdújuco o íjcyaíñe. Ahdícyane ílluréjuco metsu mepéékií. Ehdúu neebe múúhakye Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Aabée tsiiñe múúhakye úwááboobe nééhií: —Oo muurá óóvahédu. Áánetu Llihíyó tééhé tehméébédu. ");
INSERT INTO boaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aabe dówacárohíjcyá tahñéjté íjcyájúcóórómedítyú táuwááboju bóhówaúcunútúmeke éhne múúne teehe óóváhetu néévahíjcyátúwajcájɨ́ tééné tehméébé wáágóohíjcyádu. Áánetu ihdyu ɨ́mɨáánéjuco tahñéjté íjcyámedítyú táuwáábó bóhówaúcunúmeke pɨ́ááboobe éhnííñevu ímí ditye teene iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Muurá tsúúca ámúhakye o úwáábohíjcyánej tééveri ámuha méímíbaavyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ahdícyane óóma ámuha meíjcyame óhdityu médówáávedíñe. Muurá úméhetu téwajca víúúvewájcá tsá néévájúcootúne. Ahdu muurá óhdityu ámuha medówáávéhajchíí tsá ɨ́mɨá uwááboju ámúhadítyú bóhówaúcunújúcóóityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aane óóvahédú oó. Áánetu ámuha tééhéwajcánédu. Aame óhdityu ámuha medówáávétúhajchíí ɨ́mɨá uwááboju ámúhadítyú bóhówaúcúnuúhi. Áánetu óhdityu ámuha medówáávéhajchíí tsá Píívyéébe ímillédú ámuha meíjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aame ílluréjuco ámuha mewágóóóveíñé éhne múúne teene óóváhetu néévahíjcyátúwajcájɨ́ mewáhdáhɨnúné mecóvajtsódu. ");
INSERT INTO boaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Muurá tahñéjté ámuha meíjcyame óhdityu dówáávetúméré ímí táuwááboju meɨ́jtsúcunúhajchíí tehdújuco ámuha meíjcyaíñe. Aame ámuha pɨáábó metáúmeíñevu ámúhakye ó ájcuúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Muurá ɨ́mɨá uwááboju ámúhadítyú bóhówaúcunúhajchíí ɨ́mɨááné Llihíyoke ámuha máávyéjújtsoóhi. Aame ámuha méíjcyaá ɨ́mɨááné táuráávye múnaa. ");
INSERT INTO boaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Muurá ámúhakye mítyane ó wajyú Llihíyó oke wájyudu. Áánéllii oke méɨ́hvéjtsodíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Muurá tátyaúhbajúúné ámuha melléébóne tehdu meícyáhajchíí ámúhakye ó pɨ́ááboó íñe Llihíyó taúhbajúúné o lléébónéllii oke dibye pɨ́áábohíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ehdu íñe ámúhakye ó nehíjcyá tsaméhjɨ́ tééneri meímíjyúúveki. ");
INSERT INTO boaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Áánéllii ámúhakye ó nehíjcyá ámúhakye o wájyudu ámuha mewájyújcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Muurá o dsɨ́jɨ́véneri ámúhakye ó úújétsoó mítyane ámúhakye o wájyune. Tsáhájuco muurá tsiiñe muhdú éhnííñevu mewájyune meúújétsóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aane íñe ámúhakye o néhijcyáné ámuha melléébóne tehdu meícyáhajchíí ɨ́mɨááné táñahbévajte ámuha méijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Áámeke tsá ámúhakye o díllotú táwákimyéi múnáadi. Muurá tsáné avyéjúúbé wákimyéi múnaa tsá wáájácutú muhdú íavyéjuube ɨ́jtsámeíñe. Áánéllii ihdyu ámúhakye o néé táñahbévajte ámuha meíjcyane íñe páneere muhdú oke Llihíyó úwáábohíjcyáné ámúhakye o úúbállehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tsáháa oke ámuha menéhcoobe íñe ámúhama o íjcyatúne. Muuráhjáa ihdyu oore ámúhakye ó ujcú tahñéjté ámuha meíjcyámedítyú ɨ́mɨá uwááboju ibóhówaúcunú múijyú nɨ́jkéváityúne. Aame ámuha Llihíyoke tamyémeri panévá pɨáábó metáúmeícyooca ámúhakye pɨ́áábóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Áánéllii ámúhakye o néé ámuha mewájyújcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Aane ámuha oke mecáhcújtsóné hallútú tsaate ámúhakye tsárílléhajchíí múu ɨ́tsaavé okée itsárillédújuco ditye ámúhakye tsárilléne. ");
INSERT INTO boaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Muurá ditye íjcyadu ámuha meíjcyaca ámúhakye wájyúiyóme. Árónáacáa diityédítyú ámúhakye o újcúnéllii ámúhakye tsarílleímyé diityédú ámuha menéjúcóótúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aane cáhawáá méɨjtsúcunu éhnée tsáné avyéjúúbé wákimyéi múnáajpi íavyéjúúbé éhnííñevu íjcyáítyuróné ámúhakye o nééneé. Aane muurá oke ɨɨ́cúbahrádúré ámúhadi ɨ́cúbáhraímye. Muurá táuwáábó illééboca idyé ámuha meúwaabóné lléébóiyóme. ");
INSERT INTO boaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ehdu páhduváré ámúhakye dárɨ́ɨ́veímyé tahñéjté ámuha meíjcyáné hallútú okée wálloobe Píívyéébeke iwáájácútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Muuráhjáa diityé uwáábovu o tsáátuca tsá oke ditye tsárílléítyuróne. Aacáa tsá diityé hallúrí ímityúné íjcyáítyuróne. Árónáa ícyooca diityé hallúrí teene ɨ́veekí oke cáhcújtsotúmé íllure oke tsáríllehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tsá idyé apáábyekéré oóke, muurá Llihíyomájuco múhtsikye ditye tsárilléne. ");
INSERT INTO boaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Muurá diityéj pɨɨnévú méénúráítyúronéhjɨ́ o méénuhíjcyátuca tsá diityé hallúrí ɨɨná íjcyáítyuróne. Árónáa ténehjɨ múubárá méénúítyuróné o méénuhíjcyáné ájtyumɨ́júcoorómé ¿ɨ́veekí íllure múhtsikye tsaríllehíjcyá Llihíyoma? ");
INSERT INTO boaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Árónáa ihdyu tehdújuco oke ditye tsárilléné dííbyé waajácúháámɨtu íllu tene néhdújuco: “Ɨ́ɨ́né imítyú o méénútúróóbeke oke tsarílléme.” ");
INSERT INTO boaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Árone ihdyu óvíi Píívyéébé Apííchó ámúha éllevu o wálloonéréjuco ámúhakye túkévejtsóné táuwáábó ámuha meméénuki. ");
INSERT INTO boaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ahdícyane óvíi ámuha teene méméénuhíjcyá íñée táwákimyéí o tújkénútsihdyu óómaye ámuha meícyahíjcyádú íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ehdu íñe ámúhakye ó nehíjcyá ámuha meíjcyátsííívyéne oke meɨ́hvéjtsótuki. ");
INSERT INTO boaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Muurá ámúhakye waagóoímyé pihcyáávejááné pañétu. Áhdure tsaatéké ámúhadítyú ɨdsɨ́jɨ́vétsone ɨjtsúcunúimye tehdújuco Píívyéébe ímillédú imyéénune. ");
INSERT INTO boaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ehdu muurá dárɨ́ɨ́vémeíimye Llihíyoma múhtsikye iwáájácútúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aane íñe ámúhakye ó úúballé néhi tene pájtyéijyu ámuha meɨ́tsááveki. Tsáháa éíjyu ámúhakye teene o úúbálletú ámúhamáyéikyée o íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aabe ícyooca tsúúca ámúhadítyú o péjúcoó okée wállóóbe éllevu. Árónáa tsá tsáápíuba ámúhadítyú oke díllotú kiávú o pééiñe. ");
INSERT INTO boaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","¿Muhdú ámuha kehdóvéméhjɨúvú ámúhakye o úúbállénélliíhye? ");
INSERT INTO boaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Árónáa ihdyu tehdújuco ámúhadítyú o pééiñe. Muurá o péétuca tsá Píívyéébé Apííchó ámúha éllevu tsááítyuró ámúhakye ɨpɨ́ááboki. Áánéllii ó peé ámúha éllevu teene o wálloóki. ");
INSERT INTO boaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Muurá téénej tééveri mɨ́amúnaa waajácuú ímityúmé iíjcyane. Téhdure waajácuímyé ɨ́mɨájɨ́jtó cáhcujtsómé ímíjpyetéiñe. Téhdure waajácuímyé teene cáhcújtsótúmema Llihíyó muhdú ditye ícyahíjcyáné ímíbájchoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Muurá ímityúmé tsá oke cáhcújtsotúne. Aame wágóóóveé tééné déjúcotu. ");
INSERT INTO boaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aame idyé waajácuú Llihíyo éllevu o péénetu ɨ́mɨááné apááñéré táuwááboju icyáhcújtsóneri mɨ́amúnaa dííbyedívú úújetéiyóne. Aabe ámúhadítyú o péébeke tsáhájuco oke ámuha maájtyúmɨ́ityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Téhdure waajácuímyé Píívyéébe mɨ́amúnaa muhdú ícyahíjcyáné diityémá ímíbájchóijyu dííbyeke cáhcujtsómé pájtyetéiñe tsúúca ííñújɨ́ avyéjuube Naavéneke o táhjánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Aane íjcyaróné mítyane ámúhakye o nééiyóne. Árónáa tsá ámuha mewáájácúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Muurá ihdyu Píívyéébé Apííchó ɨ́mɨááné ámúha éllevu itsáácooca ámúhakye waajácútsoó keená ɨ́mɨááné íjcyanévu. Tsá íhdityúré iújcune tene ámúhakye úwáábóityúne. Muurá ihdyu Píívyéébere nééne ámúhadívú bóhówájtsoíñé panéváré muhdú pájtyeíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aane táuwáábojúvú ámúhakye iwáájácútsónej tééveri oke ávyéjújtsoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Muurá Llihíyórero oó. Áánéllii ó nehíjcyá tahñévúré dííbyé Apííchó ámúhakye wáájácútsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Aabe muurá lléváhréjuco ámúhadítyú o péébeke tsáhájuco oke ámuha maájtyúmɨ́ityúne. Árónáa idyé llévá ámuha oke tsiiñe máájtyúmɨɨ́ Llihíyo éllevu o pééíñé ɨhde. ");
INSERT INTO boaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ehdúu Jetsóó néénéllii múúhadítyú tsaate néjcatsíhi: —¿Aca íhya muhdú iñééiyóné ehdu meke neébe? ");
INSERT INTO boaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tétsii tsá mewáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aanée dííbyeke muha medíllóiyóné iwáájácúne neebe múúhakye: —Éhnené ámúhakye ‘lléváhréjuco ámúhadítyú o pééiñe, árónáa idyé llévá ámuha oke máájtyúmɨɨ́’ o nééne muurá ámuha médíllójcatsíhi. ");
INSERT INTO boaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Muurá ɨ́mɨááné ámúhakye o néé ávyétá ɨhnáhó ámuha oke mekímóóveíñe. Ááné tujkéveri muurá oke cáhcújtsotúmé íllure ímíjyúúveéhi. Árónáa ihdyu ámuha mekímoovéné ámúhama nɨjkévaá ímíjyuuvúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Muurá walle ɨtsɨ́ɨ́máváijyu avyérí ɨ́cúbáhrámeíhi. Árónáa tsɨ́ɨ́mene tsúúca íjchívyéné boone tsáhájuco dille ávyevéjúcootúne. Ílluréjuco dille ímíjyuuvéné tsɨ́ɨ́méneke iújcúneri. ");
INSERT INTO boaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ahdu muurá ámúhadítyú o pééneri ámuha mékímóóveéhi. Árónáa llévá ámuha oke máájtyúmɨ́neri meímíjyuuvéné tsá múha muhdú méénúityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aane téijyu pɨáábó tsáhájuco oke ámuha metáúmeíityúne. Llihíyokéréjuco ámuha tamyémeri metáúmeíiñe ámúhakye dibye ɨpɨ́ááboki. ");
INSERT INTO boaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Aane muurá tsáhái ámuha metáúmeítyúne. Cáhawáá métáuméí ámúhakye dibye pɨ́áábóneri ámuha meímíjyúúveki. ");
INSERT INTO boaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Áhdurée idyé tsiiñe neebe múúhakye: —Muurá ámúhakye ó úúbállehíjcyá tsíeménéhjɨj tééveri. Aane cáhawáá ícyooca ímíñeúvú Llihíyodítyú ámúhakye o úúbálleki. ");
INSERT INTO boaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dííbyekéréjuco ihdyu ámuha metáúmeíiñe pɨáábó tamyémeri. Tsáhájuco ámúhama o táúmeíityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Muurá mítyane ámúhakye wájyuube oke iwájyudu dííbyedítyúu o tsááne ámuha mecáhcújtsóne téhdure oke mewájyúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Muuráhjáa dííbyedítyú ííñujɨ́vú o tsáábe éllevu tsúúca ó oomíjyúcoóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ehdúu Jetsóó néénéllii muha menéé dííbyeke: —Ícyooca ihdyu botsíi ímíñeúvú múúhakye ú úúballéhi. Tsáhájuco tsíeménéhjɨj tééveri múúhakye u úúbálletúne. ");
INSERT INTO boaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aane muha méwaajácú ɨ́mɨááné páneere u wáájácúúbeke tsá múha uke úwáábóítyuróne. Áánéllii muha mécáhcujtsó ɨ́mɨáánéjucóhjáa Píívyéébedítyú u tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Áánélliihyée neebe múúhakye: —¿A ícyooca botsíi ámuha mécáhcujtsóhi? ");
INSERT INTO boaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Árónáa tsúúca óhdityu ámuha metsújááveéhi. Ááné boone ooréjuco o cóévaíñe. Árónáa tsá oore o íjcyatúne. Muurá Llihíyoma ó ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ehdu íñe ámúhakye ó nehíjcyá óhdivu ámuha mecátsɨ́páávéne ɨ́ɨ́nerí maáábímyeítyuki. Ihdyúhde tehdújuco ííñújɨri ámuha meɨ́cúbáhrámeíiñe. Árónehjɨ́vú métáhjátsámeídíñe. Muurá tsúúca tééjɨ́ imítyú ámúhama ó tahjáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ehdúu iñétsihdyu Jetsóó cáámevu icyárúúvéne nééhií: —Ayúju Táácáániíj, wa ícyooca oke Dááchikye dávyejújtsó dɨ́ɨhtsútú óhdityu ibóhówaúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Muuráhjáa oke ú picyóó pámé avyéjuubéré o íjcyaabe múhdúmekéhjáa u újcúmeke o ájcu múijyú ditye dsɨ́jɨvéjúcóóítyúne bóhɨɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aane muurá apáábyéré ɨ́mɨá Piivyéébé u íjcyáábema oke Dááchikye íñée ííñujɨ́vú u wállóóbeke wáájacúmé újcuú tééne bóhɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aabe íñe uke ɨ́jɨɨtu ó bóhówátsohíjcyá dɨ́ɨhtsútú okée u níwaavéné o méénuneri. Aane tsúúca ó nɨjkéváhi. ");
INSERT INTO boaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ahdícyane ihdyu, uu Táácááni, óvíi oke ú ávyéjujtsó meíjcya éhnée ííñujɨ́i íjcyatúnáa meícyahíjcyádu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Muurá ííñújɨri íjcyámedítyú tahñéjté íjcyáímyeke u újcúmeke tsúúca úhdivu ó waajácutsóhi. Muuráhjáa tsúúcajátújuco dihñéjté íjcyame íñe díuwááboju o úwaabóné tsúúca cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aame tsúúca waajácú páneere o méénuhíjcyáné úhdityúré tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Muurá okée u níwaavéné o úwáábohíjcyáné imílléme. Aame cáhcujtsó ɨ́mɨáánée oke u wállóónéllii o tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ahdícyane uke ó táúmeí pɨáábó dihñéjtéjuco íjcyame táhójtsɨri íjcyámé hallúvu. Áánetu uke cáhcújtsótúmé hallúvú tsá o táúmeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Muurá pámeere tahñéjté íjcyame téhdure dihñéjté íjcyámedítyú táavyéjú bóhówaúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Áámedítyú tsúúca ó peé diéllevu. Áámeke ihdyu, Táácááni ɨ́mɨáábé u íjcyaabe, tehme dɨ́ɨhtsúturi táhójtsɨri íjcyame ímí tsaméhjɨ́ tsajɨ́jtóré ɨɨ́jtsámeí íñe meíjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Muurá ííñújɨri diityémá o íjcyaabe dɨtsɨ́jpari diityéké ó téhmehíjcyáhi. Aame ijcyá pámeére. Árónáa tsáápiiye diityédítyú wágóoové tsúúcajátújucóo díwaajácúháámɨtu tene néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Áámeke ihdyu ííñújɨri diityémá o íjcyáné hajchótá ó úwáábohíjcyá ditye iímíjyu íñe o ímijyúdu. Aabe tsúúca diityédítyú ó oomíjyúcoó diéllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Muurá díuwááboju diityéké o úwáábómeke ɨ́jɨ́enéré úraavyémé tsaríllé téénéejpi o íjcyátúúbeke ditye úráávyénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Árónáa tsá uke o néétu diityéké diityédítyú u ɨ́ɨ́nétsoki. Íllure uke o néé Naavéné diityéké mújtátsóíyónetu u téhmeki. ");
INSERT INTO boaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tsá muurá ííñújɨ́éneri o ɨ́ɨ́cúvetú téénéejpi o íjcyátúnélliíhye. Áhdure tsáhájuco ditye tééneri ɨ́ɨ́cúvetú tsúúca oke iúráávyénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Áámeke ihdyu díuwáábójuj tééveri éhnííñevu dímibájchó tsaímiyé uke ditye iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Muurá ó wálloó diityéké uwáábovu ɨ́jɨ́enéré úráávyémé pañévú íñée diityé pañévú oke u wállohdu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Muuráhjáa diityéké ó ímíbáávyetsó ɨ́mɨájɨ́jtó icyánejcúvú ávyeta diityédí o íjyácunúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Aane tsá uke pɨáábó o táúmeítyú apáámyéré óóma íjcyámé hallúvu. Téhdure ó táúmeí ditye táuwááboju úwaabóné lléébome oke cáhcújtsóímyé hallúvu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","23","Aame diityémá íñe meíjcyadu tsame íjcyame iwáájácu oke u wájyudu diityéké téhdure u wájyune. Áámema ímí menáhbévájcatsí téénetu ɨ́jɨ́ icyánéjcú úraavyémé icyáhcújtso ɨ́mɨáánée oke u wálloóne. Muurá oke u bóhówátsohíjcyádúré idyé diityéké ó bóhówátsohíjcyá ditye ímí tsame iíjcya meíjcyadu. ");
INSERT INTO boaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ahdícyane, Lli, uke ó táúmeí dihñéjté táhójtsɨri íjcyame óóma táavyéjuri iíjcyaki. Muuráhjáa ííñujɨ́i u ípívyéjtsótúné ɨhdéjuco oke u ávyéjútsohíjcyáné oke u wájyúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aabe Táácááni ɨ́mɨáábé u íjcyaabeke muurá ɨ́jɨ́ icyánéjcú úraavyémé tsá uke wáájácutú íñe uke o wáájacúdu. Áánetu ihdyu íjtye tsúúca ímí uke waajácú okée u wállóóbeke icyáhcújtsónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Áámeke tsúúca ó waajácutsó úhdivu. Áánetúréi diityéké éhnííñevu o wáájácútsoíñé pámeere pahúllevávú mewájyújcatsíki. ");
INSERT INTO boaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ehdúu Jetsóó Cááníma íhjyúvátsihdyu muha dííbyema mépajtyé ‘Tsedoróo’ némeíñé téhiwánɨjke tsíñejcúvu. Ánejcúríi oríívo bájú ijcyáné lliiñévú muha méúújetéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Átsiípye Jóóda Jetsóodívú méénútsóiibye waajácú paíjyuvárée tétsihvu muha dííbyema meúújetéhíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Átsihvúu tsívaabe tsodáhómuma duurúvájá tehméjteke llúúvájté avyéjujtémáhjáa paritséómú wállóómeke. Áámée ímyéénujcátsiháñema, ipyééteháñema, tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Aanée Jetsóó iwáájácúne diityé éllevu ipyééne néé diityéke: —¿Muucá ámuha ménehcóhi? ");
INSERT INTO boaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Áánélliihyée nééme dííbyeke: —Muha Natsarée múnáájpi Jetsóoke ménehcóhi. Áánélliihyée neébe: —Oo muurá diíbye. Téijyúu diityé pañe diibye Jóóda dííbyedívú méénútsóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aanée ehdu Jetsóó diityéké néénetu idyéjuéhnejcúvú óómiyómé áákityéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Áámekée tsiiñe neébe: —¿Ɨ́mɨááné muucá ámuha ménehcóhi? Áánélliihyée néémeé: —Éje, Jetsóoke muha ménehcó Natsarée múnáájpiíkye. ");
INSERT INTO boaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Áánélliihyée neebe diityéke: —Tsúúcajáne muurá ámúhakye ó néé diibye o íjcyane. Aane ihdyu ámuha oke meméénúhajchíí médómájcodí íjtyékeé. ");
INSERT INTO boaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ehdúu pajtyéné dííbyerée íllu néhdújuco: “Úpée, Lli, u újcume táhójtsɨri íjcyámedítyú tsá tsáápíuba wágóóóvetúne.” ");
INSERT INTO boaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Áánáacáa Tsimóo Péédoro ɨ́nɨɨtsúwá iwávɨ́tsuúcúne wállórɨhjɨ́cú llúúvájté avyéjúúbé úníu múnáajpi ‘Máácoó’ némeííbyé núúmɨho ɨ́mɨánéjcúeho. ");
INSERT INTO boaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Árónáacáa Jetsóó néé dííbyeke: —Ɨ́veekíami ehdu ú meénuj. Pícyo dɨ́nɨɨtsúwa. ¿Aca tsá u wáájácutú Llihíyóo néhdújuco o ɨ́cúbáhrámeíiñe? ");
INSERT INTO boaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aamée diitye tsodáhómuu, íavyéjuúbee, duurúvájá tehméjtee, íjcyame tsúúca Jetsóoke iékéévéébeke dohjɨ́núhi. ");
INSERT INTO boaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Áánemáa tsajtyémé dííbyeke Caipáá baabe Anáa jávu. Téijyúu tééné pijcyábari diibye Caipáá páñétúejpi llúúvájté avyéjuúbe. ");
INSERT INTO boaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Diibyée muurá diityéké nehíjcyá pámeere óúúvéíyóné ɨhdétú tehdújuco tsaapi dsɨ́jɨ́veíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Aanée Jetsóoke ditye tsájtyéébeke o úráávyéébema idyé Tsimóo Péédoro péé óóma páñétúejpi llúúvájté avyéjuube oke wájácú néébema. Áánélliihyée oke pajtyétsoobe ihjyá llahájtsɨ́ míhllémeíñetu páñevu Jetsóoma o úcááveki. ");
INSERT INTO boaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Áánetúu diibye Péédoro coévá llééhowávúré áachí éhnejcúvu. Áánélliihyée ó ihjyúvá llééhówá tehméllema dibye téhdure iúcááveki. Áánélliihyée botsíi pajtyétsolle dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aallée néé dííbyeke: —¿Aca tsá Jetsóó mamyémúejpi u íjcyatúne? Áánélliihyée neébe: —Tsáhaá, tsíjpiiye oó. ");
INSERT INTO boaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Téijyúu tsuucówu tene néénéllii llúúvájté avyéjúúbé úníu múnáama tehméjté icyújuwááñúwatu pɨ́hmɨ́me élletu idyé pɨ́hmɨɨbe Péédoro. ");
INSERT INTO boaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Áánáacáa llúúvájté avyéjuube Anáá dilló Jetsóoke ɨɨná dibye úwáábohíjcyáne. Áhdurée dílloobe ímamyémú ɨɨná méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Áánélliihyée neebe dííbyeke: —Muurá duurúvájá pañévú téhdure pihcyáávejááné pañévú mɨ́amúnááj pɨɨnévú ó úwáábohíjcyáhi. Tsá muurá múijyú téévéneúvú o íhjyúvahíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aanéjɨ́ɨ́ muhdú oke ú dillóhi. Cáhawáá dillo táuwááboju lléébúcunúhíjcyámeke ditye uke iñéé ɨɨná o úwáábohíjcyáne. Muurá íchihyi ijcyámé tsaate teene lléébúcunúhijcyáme. ");
INSERT INTO boaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Áánélliihyée duurúvájá tehméébé néé dííbyeke: —¿Ɨ́veekí ehdu ú áñujcú llúúvájté avyéjúúbeke? Ehdúu néébere wábáajcáró dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Áánélliihyée Jetsóó nééhií: —¿Aca ó allíhi? Cána oke diñej. Muurá ɨ́mɨááné o nééhií. Aanéjɨ́ɨ́ ¿ɨ́veekí oke ú wábáajcóhi? ");
INSERT INTO boaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Átsihdyúu Jetsóoke diibye Anáá wallóó dóhjɨ́uri páñétúejpi llúúvájté avyéjuube Caipáa éllevúréjuco. ");
INSERT INTO boaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Áánáacáa tétsihíyéi Péédoro pɨhmɨ́rí diityéj pɨɨne íjcyáábeke néémeé: —¿Aca tsá áádí mamyémúejpi u íjcyatúne? Áánélliihyée ityóónúne neébe: —Tsáhaá, tsíjpiiye oó. ");
INSERT INTO boaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Áánélliihyée llúúvájté avyéjúúbé úníu múnáadítyú dibyée íñúúmɨho wáhdahɨ́róóbé jééeebe nééhií: —Ááneráhjané diityémá oríívó bájú lliiñe u íjcyáábeke ó ájtyumɨ́hi. ");
INSERT INTO boaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Árónáacáa tsiiñe íllure tóónuúbe. Áánáacáa tsúúca cáraca májtsiváhi. ");
INSERT INTO boaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aanée tétsihdyu Caipáá jatu tsajtyémé Jetsóoke tééné iiñújɨ́ avyéjuube Pirááto jávu. Áánáacáa tsúúca métsɨ́tsɨɨvéhi. Áijyúu dííbyeke tsájtyeme tsá úcáávetú tééjá pañévú tééneríváa ímítyújtsámeímyé teene wañéhjɨ májchó imájchójúcóítyúrónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Áánélliihyée Piráátó diityé éllevu iíjchívyéne néé diityéke: —¿Aca ɨɨná ímityúné áánu méénune ámuha méúúballé dííbyé hallúvu? ");
INSERT INTO boaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Áánélliihyée nééme dííbyeke: —Muurá dibye ímítyuube íjcyátuca tsá muha metsíváítyuró diéllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Áánélliihyée neébe: —Ané wa ihdyu metsájtyéébeke meméénú muhdú ámuha jodíómú taúhbaju néhduú. Áánélliihyée nééme dííbyeke: —Árónáa tsá muha metáúhbáítyuró tsaaté dsɨ́jɨvétsovu. ");
INSERT INTO boaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ehdúu pajtyéné dííbyerée Jetsóó muhdú idsɨ́jɨ́veíñé néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Áábekée Piráátó ihjyá pañévú ɨpɨ́úváábeke nééhií: —¿A uu jodíómú avyéjuúbe? ");
INSERT INTO boaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Áánélliihyée neebe dííbyeke: —¿A uure ehdu oke u nééhií, mityá tsaate uke néhijcyánéré oke u néé? ");
INSERT INTO boaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Áánélliihyée Piráátó nééhií: —Tsá muurá jodíómuube o íjcyatúne. Muurá ihdyu dimúnaáré llúúvájté avyéjujtémá ¿ɨ́ɨ́né hallútútá uke tsiva taéllevuj? ¿Ɨɨnétáhjáa ímityúné ú meénuj? ");
INSERT INTO boaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Áánélliihyée neébe: —Tsá ííñújɨ́ene táavyéjú íjcyatúne. Muurá ííñújɨ́ avyéjúejpi o íjcyaca támamyémú táhallútú méénúiyá oke ditye iékéévétuki. ");
INSERT INTO boaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Áánélliihyée Piráátó néé dííbyeke: —¿Áánélliihyéhaca ihdyu diibyéjuco uu ávyéjuúbe? Áánélliihyée neébe: —Éée, diibyéjuco oo ɨ́mɨáájuvúu mɨ́amúnáake o wáájácútso ííñujɨ́vú o tsɨ́ɨ́mávámeííbye. Aane ímilléméjuco táuwááboju illéébóne cáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Áánélliihyée Piráátó nééhií: —¿Aca ɨɨná teene ɨ́mɨááju? Ehdúu dííbyeke iñééne ihjyá pañétú iíjchívyéne neebe dííbyeke tsívámeke: —Áánerá tsá dibye ímítyuube íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Muurá ámuha paíjyuva pajtyété wañéhjɨ́ pañe cúvéhóójari íjcyámedítyú tsáápí hallúvú méihjyúváábeke ó ichívyétsohíjcyáhi. Aane ¿íhya ámuha méimíllé diibye ámúhá avyéjúúbeke o ácádsɨ́jcaáyóné téijyu? ");
INSERT INTO boaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ehdúu Piráátó néérónáa páméhcobáré nééhií: —¡Tsáhaá, tsá dííbyeke u ácádsɨ́jcaáyóityúne! ¡Barabáakéré u íjchívyetsóné muha méimílléhi! Ácoocáa diibye Barabáá ávyétá imítyuube íjcyaabe cúvéhóójari téijyu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aanée ehdu ditye néénéllii awáá Piráátó ílluréjuco Jetsóodívú táuhbáné ítsodáhómuke ditye dííbyeke iwátsíhcyuki. ");
INSERT INTO boaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aamée ánetóónetu cháhiiwa imyéénuwávú ávohjácó dííbyeke. Áánemáa dííbyeke uácómé wájyamu duujɨ́nuúdú nééjácobávu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Áánemáa dííbyé úniúvú iíjcyáne íllu wáñécohíjcyáme: —¡Ñóóooj, maímijyu áánu jodíómú avyéjuúbej! Ehdúu iwáñéjcóne néémere wábáácohíjcyá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aanée tsiiñe Piráátó dííbyekée tsájtyéme éllevu ipyééne nééhií: —Cáhawáá ííllevu dííbyeke o íjchívyétso ámuha mewáájácu ɨ́mɨááné dibye ímítyuube íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ehdúu iñééne Jetsóoke dibye pɨ́úvaabe úújeté diityé úmɨwávú ánetóóné chahííwavu ditye ávohjácónema. Téhdurée wájyamu duujɨ́nuúdú nééjavu ditye úácójama diíbye. Áábedítyúu neebe Piráátó diityéke: —Éje, áánu muuráhaja. ");
INSERT INTO boaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Áábekée llúúvájté avyéjujtémá duurúvájá tehméjté iájtyúmɨ́ne kéévánécoba nééhií: —¡Áábyedívú wátyétyehcútsó páwachékevu! ¡Tsáma wátyétyéhcútsoco! Áánélliihyée neebe Piráátó diityéke: —Wa ihdyu metsájtyéébeke ámuháyé méwátyetyéhcuj. Tsá muurá ímítyuube dibye íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Áánélliihyée nééme dííbyeke: —Árónáa ihdyu múúhá taúhbaju néhdújuco dibye dsɨ́jɨ́veíñé ɨ́veekí Píívyéébé Hájchidi dibye díllómeíhíjcyáné déjúcotu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ehdúu ditye nééneri Piráátó mítyane íllityéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Áánemáa tsiiñe ihjyá pañévú itsájtyéébeke neébe: —¿Aca kiá múnáajpí uú? Aanée tsá dibye áñújcutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Áánélliihyée neebe dííbyeke: —¿Aca ɨ́veekí tsá oke u áñújcutúne? ¿Aca tsá u wáájácutú o nééjuri páwachékevu uke ditye wátyétyéhcúiyóne? Téhdure ¿a tsá u wáájácutú uke téénetu o pájtyetétsóiyóne? ");
INSERT INTO boaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Áánélliihyée neebe Jetsóo: —Ávyeta muurá tsá muhdú oke u méénúityuró Píívyéébe ímíllétuca. Muurá íñe diéllevu oke tsívame díehnííñevu ímityúné meenúhi. ");
INSERT INTO boaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ehdúu Jetsóó néénéllii Piráátó imíllerá dííbyeke iácádsɨ́jcaáyóne. Árónáacáa nééme kéévánécoba dííbyeke: —Muurá áádikye u ácádsɨ́jcaáyóhajchíí tsá páñétúejpi avyéjuube Tséétsáma ímí u íjcyáityúne. Muurá iiye ávyéjúúbedi díllómeímyé íllure ehdɨ́ɨ́vallé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ehdúu ditye néénéllii ihjyá pañétú ijchívyétsoobe Jetsóoke. Áánemáa ácúúveebe íavyéjú ijyáwá néwayúúnetu níjcyómeíñé hallúvu. Tétsíi mémée heeberéómú ihjyúrí Gabááta. ");
INSERT INTO boaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Téijyúu cójɨ́jpɨɨne péjcore teene pajtyété wañéhjɨ́ llééváíñáaáca. Áijyúu Piráátó néé diityéke: —¡Aabye ámúhá avyéjuúbe! ");
INSERT INTO boaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Árónáacáa kéévánécoba néémeé: —¡Wa ihdyu dííbyedívú wátyétyehcútsó páwachékevu dibye ɨdsɨ́jɨ́veki! Árónáacáa neebe diityéke: —Árónáa tsáháubá ámuha jodíómú avyéjúúbedívú o wátyétyécútsóítyuró páwachékevu. Ehdúu dibye néérónáa llúúvájté avyéjujte néé dííbyeke: —¡Árónáa íjcyaabe apáábyéré páñétúejpi múúhá avyéjuube Tséétsaá! ");
INSERT INTO boaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ehdúu éhnííñevúré ditye néénéllii ílluréjuco Piráátó ɨ́hvejtsóné diityédívú ditye dííbyeke iwátyétyéhcu páwachékevu. Áábekée tsajtyémé iwátyétyéhcúíhullévu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Aabée Jetsóó tsajtyé dííbyeke ditye wátyétyéhcúíwachéké ‘Niwáupáájɨ’ némeítsíí heeberéómú ihjyúrí ‘Góógota’ némeítsihvu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Áábekée tétsihvu wátyétyehcúmé téwachékevu. Áhdurée téijyu tsaatétsikye wátyétyehcúmé dííbyé úníutu panéjcuváácutu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Áijyúu Piráátó néé ditye téwachéketu ipícyo íllu nééneé: “Jetsóó Natsarée múnáajpi jodíómú avyéjuúbe.” ");
INSERT INTO boaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aanée mítyame éévehíjcyá pɨ́hɨ́ré tétsii Jerotsaréetu íjcyánélliíhye. Caatúvánée heeberéómuu, gríéégomuu, romáánómuu, éhdúmé ihjyúri. ");
INSERT INTO boaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ehdúhjáa Piráátó cáátúnúnéllii dííbye éllevu llúúvájté avyéjujte ipyééne néé dííbyeke: —Tsáháa u cáátúnúítyuró jodíómú avyéjuube dibye íjcyane. Úpée ú caatúnúiyá iiye jodíómú avyéjúúbedi dibye díllómeíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Árónáacáhjáa neébe: —Árónáacáa tsúúca o cáátunúné óvi éhduréjuco. ");
INSERT INTO boaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aanée tsodáhómú dííbyeke iwátyétyehcúné ɨnɨ́jkevádú dííbyé wajyámúúné wátújcatsíhi. Áánetúu tsaja cááméjácoba tsá ditye píívyetétú muhdú iácújcatsíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Áánélliihyée néjcatsímye: —Íjyáhcoba tsá medóváájcóityúne. Metsu menéhco muucá tene dómajcómé teeja itsájtyeki. Ehdúu pajtyéné tsúúcajátújucóhjáa Píívyéébé waajácúháámɨtu íllu tene néhdújuco: “Táwajyámúúné wátújcatsímye. Áánetu ícyaaméjácóbá hallúvú nehcómé muhnéjá teja íjcyaíñe.” Ahdújucóo ɨ́mɨááné tsodáhómú méénune. ");
INSERT INTO boaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Áijyúu tétsihyi dííbyéj tsɨɨ́juu, dííllé naállee, Créopá taaba Maaríaa, Maaría Madarénaa, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Téhdurée ɨvámeíwu oke dibye néhíjcyaabe tsɨ́ɨ́jú úníuri o íjyócunúúbeke ɨɨ́ɨ́téne neebe díílleke: —Wáhaj, aadi muurá tsaapi daáchi. ");
INSERT INTO boaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Átsihdyúu oke neébe: —Aalle, muube, dɨ́ɨ́tsɨ́ɨ́juú. Áánélliihyée tahjyávuréjuco díílleke o tsájtyene. ");
INSERT INTO boaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Aanée téijyu tsúúca páneere pájtyéíñe éévé úújeténé Jetsóó iwáájácúne nééhií: —Ó ádóiyáhi. Ehdúu neebe tsúúcajátújucóhjáa Píívyéébé waajácúháámɨtu tene néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Áánélliihyée bíínójpácyó kiwátyé llíyíhlló pañe íjcyánetu wájyámúɨhdsɨ́dú nééne iééniyóné úméhéí nɨ́jcáutu ipícyóóne cújuuvémé dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aanée ɨɨ́ɨ́hátsihdyu neébe: —Áyu, ícyooca ihdyu páneere nɨjkéváhi. Ehdúu iñétsihdyu ílluréjuco dibye dsɨ́jɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ááné tsiíjyúu pajtyété wañéhjɨ́ llééváíñéllii tsá ditye ímílletú ɨ́témehóóné téwachékéjɨtúré íjcyane. Áánélliihyée nééme Piráátoke dibye ityáúhba ítsodáhómuke ditye ítyájkiííñé iwáíhyáñu ɨ́ɨ́cúi ditye ɨdsɨ́jɨ́ve ditye tétsihdyu iñíítyétsómeke tsiéllevúréjuco ipícyoóki. ");
INSERT INTO boaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ahdújucóo dibye néénéllii tsodáhómú pééme wáíhyañúné Jetsóó úníutu panéjcuvátú íjcyámútsí tájkiííñe. ");
INSERT INTO boaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Áánetúu Jetsóoke ditye wáíhyáñúíyónáa tsáhájuco dibye bóhɨɨtúne. Áánélliihyée tsáhájuco ditye wáíhyáñutú dííbyé tájkiíícyu. ");
INSERT INTO boaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Árónáacáa tsodáhó dííbyeúvuke íáámɨ́hotu cáváajcáró aamúbari. Áhejútúu tújpácyoma nújpacyo ijchívyéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ehdúu ɨ́mɨááné tene pájtyene o ájtyumɨ́né íñe ó úúballéhi. Aane ihdyu óvíi ámuha mécáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ehdúu Jetsóoke tsodáhómú ítyájkiíícyú tsá wáihyáyotú tsúúcajátújucóhjáa Píívyéébe íwaajácúháámɨtu íllu néhdújuco: “Tsá dííbyeke tsátsííuba ditye wáihyáyóityúne.” ");
INSERT INTO boaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Téhdure téhaamɨ́tú nééneé: “Ditye cáváájcóóbeke ɨ́ɨ́teímye.” ");
INSERT INTO boaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ááné boonéhjáa Arimatéá cóómi múnáajpi Jotséé ávyéjujté apííchoríi teevétaríyé Jetsóoke úráávyehíjcyaabe táúmeí Piráátoke dííbyeúvú ɨɨtémeho icyúúuki. Ahdújucóo dibye ájcune dibye icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Téijyúhjáa dííbye éllevu Nicodéémó tsáá tsáijyúu pejco Jetsóoma íhjyúvájeébe. Aabéhjáa tsivá mííraá, áároee, íjcyáné pacúúcuma úméváné duurúbajpácyó 30-áámú íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ááneríhjyáa wájyámubááné imúríjchóne bɨ́ɨ́jɨ́numútsí dííbyeúvuke dityée ɨ́ɨ́témeho icyúúu méénuhíjcyádújuco. ");
INSERT INTO boaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aanéhjáa dííbyeúvuke ditye wátyétyéhcúné úníuri bajtsóháñé íjcyátsihdyu níkyehéjú béhéjure tsaatékéi ditye pícyóótuhéju. ");
INSERT INTO boaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Áhejú pañévúhjáa dííbyeke cúúumútsí pɨ́hɨ́ré tétsihdyu téheju néénélliíhye. Ehdúhjáa meenúmé wáyeéévéjcóójɨ́ ɨhde ditye ímíbáchómeíhíjcyajcóójɨ́ tsíijyu téjcoojɨ íjcyáíñélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Aanéhjáa teene wáyeéévéjcóójɨ́ boonétú tsííñé tsemáánaréjuco déjúcóóvejcóójɨ́ Maaría Madaréná péé pejcójuco Jetsóó nijkye úújetélle. Aalléhjáa úújeté téhejú watájcó nééwáyúcoba ɨ́ɨ́nétsámeíñevu. ");
INSERT INTO boaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Áánélliihyéhjáa ɨ́ɨ́cúi dsɨɨnéríyé tsáálle Tsimóo Péédorómá muhtsi meíjcyámútsikye neeváhi: —¡Ávyéjúúbeúvú ɨɨtémehóha újcujémé níkyéhéjú pañétu! ¡Aane tsá mewáájácutú kiávú ditye tsájtyene! ");
INSERT INTO boaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Áánélliihyée muhtsi téhullévú mepéé dsɨɨnéríye. ");
INSERT INTO boaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Aanée ɨ́ɨ́cúi o dsɨ́ɨ́neebe Péédoró ɨhdéré o úújetéébé téhejú pañévú úcáávétuube íúmɨ́watúré ó dújuúcunú ɨ́bɨɨjɨ́nubááneréjuco téhejú pañe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Áánáacáa botsíi Péédoro tadyéjutu wájtsɨɨbe tsapéhdú úcaavé páñééhejúvu. Aabée idyé ájtyumɨ́ wájyámubááneréjuco téhejú pañe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Íhdyúebárée íhñíwau bɨ́ɨ́jɨ́númeíbá béwánúmeíbá ájtyúmɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Áábe déjutúu o úcááveebe teene o ájtyúmɨ́ne botsíi ó cáhcujtsó ɨ́mɨááné Jetsóó bóhɨɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aanée tsáhái tsijtye wáájácutú ehdúhjáa dibye bóhɨɨíñé tsúúcajátújuco Píívyéébe néhijcyáné dííbyé waajácúháámɨtu cáátuváné iéévehíjcyaróne. ");
INSERT INTO boaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ehdúu muhtsi teene maájtyúmɨ́ne ílluréjuco meóómiñe. ");
INSERT INTO boaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Áánetúu Maaría Madaréná tsiiñe níkyéhejúvú péélléváa táállere téhejú pañe dújúcohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aalléváa ájtyumɨ́ míítyétsi níjkyéjɨ múnáajtétsí tsɨ́tsɨ́j íwajyámúúné néémutsi ácuúcunúné Jetsóó ɨɨtéméhó boonééhájtsɨri panéjcuváácuri íhñíwáú icyánéjcurii, íjtyúháácyú icyánéjcurii, ehdu. ");
INSERT INTO boaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aamútsiváa néé díílleke: —Muúllej, ¿ɨ́ɨ́nerí ú tahíjcyáhi? Áánélliihyéváa neelle diityétsikye: —Ávyéjúúbé ɨɨtémehóha kiávú ditye tsájtyéneri ihdyu ó tahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ehdúváa iñétsihdyu révoúcunúllé ájtyumɨ́ tsaapi íjyócunúúbeke. Árónáacáváa tsá dille wáájácutú Jetsóó dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aabéváa idyé néé díílleke: —Muúllej, ¿aca muucá u néhcolle eene ú tahíjcyáhi? Áánélliihyéváa tétsii íjcyane bajtsó tehméébekéré iwáábyúne neélle: —Tsáijyúne múu uure ɨ́ɨ́témeho tsítsihvu u ɨ́ɨ́nétsóhajchíí ihdyu oke duubállé kiávúhjané u pícyoone o tsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Árónáacáváa dílloobe imyémeri díílleke. Áánélliihyéváa dííbyedívú iwááne ‘¡Rabónij!’ neelle muuha heeberéómú ihjyúrí ‘Ávyéjuúbej’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Áánélliihyéváa neebe díílleke: —Oke dácádsɨ́jcaáyo. Tsáhái muurá cáámevu Llihíyo éllevu o péétune. Áánéllii tahñéjte éllevu pééne duubállé tsúúca o pééiñe Mépiivyéébe éllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ahdújucóhjáa dille múúha éllevu itsááne múúhakye úúballéváné dííbyeke iájtyumɨ́ne. Áhdurée úúbállelle muhdú dibye díílleke nénehjɨ. ");
INSERT INTO boaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aanée téjcoojɨ́ré tsemááná tújkévajcóójɨ́ pejco muha tsatsíhyí tsájá pañe. Aamée cóhpé muha méwátajcó llehówááné tsíjtyé apííchori. Áánetúhjáa Jetsóó múhdutú iúcáávéne múúhakye nééhií: —¡Ámuúhaj! ¿A ámuha méíjcyaraj? ");
INSERT INTO boaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ehdúu múúhakye iñééne úújétsoobe íhyójtsɨ́cutúu ditye wátyétyehcúné añúííhyóhejúcuvu. Téhdurée tsaapi cáváajcáróhejúvú múúhakye úújétsoóbe. Ááneríi mítyane muha méímíjyuuvé Jetsóoke maájtyúmɨ́neri. ");
INSERT INTO boaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Átsihdyúu neebe múúhakye: —Óvíi ímí ámuha méijcyáhi. Ókée ííñujɨ́vú ámúha éllevu Llihíyó wállohdu idyé ámúhakye ó wallóó táuwááboju wáájácútúme éllevu. ");
INSERT INTO boaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ehdúu néébere múúhakye ɨɨ́bátsúhcúne nééhií: —Óvíi ámúhá pañévú Píívyéébé Apííchó úcaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Muurá tsaate ímityúné méénune diityémá ámuha meímíbájchómé hallúrí tsáhájuco tene íjcyáityúne. Áánetu diityémá ámuha meímíbájchótúmé hallúrí íjcyaíñé diityé imítyu. ");
INSERT INTO boaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ehdúu Jetsóó múúhadívú bóhówáávénáa tsá Tomáá múúhama íjcyatú dííbyere ‘Jemééro’ némeííbye. ");
INSERT INTO boaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Áábekée muha meúúbállérónáa neebe múúhakye: —Dííbyé hojtsɨ́cutu añúííhyóhejúcú íjcyáneri táhójtsɨwa o úácótúhajchíí tsá o cáhcújtsóityú dííbyeke. Áhdure dityée cáváájcóhéjuri o úácótúhajchíí tsá o cáhcújtsóityúne. Ehdúu neebe Tomáá múúhakye. ");
INSERT INTO boaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Átsihdyúu 8 coojɨ́vatu tsiiñe muha tsájá pañe meíjcyánáa tsúúca múúhamájuco diibye Tomáa. Aanée idyé cóhpé muha lléhowááné mewátájcónáa tsiiñe Jetsóó múúha éllevu iúcáávéne néé múúhakye: —¡Ámuúhaj! ¿A ámuha méíjcyaraj? ");
INSERT INTO boaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Átsihdyúu Tomáake neébe: —Ayúwa díhyójtsɨwa duácó íñe añúííhyóhejúcú táhójtsɨ́cutu íjcyánerij. Téhdure ú uácoó íñée oke ditye cáváájcóhéjuri. Ááne tsá éhnííñevúré cáhcújtsótuube u íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Áánélliihyée Tomáá botsíi icyáhcújtsóne nééhií: —¡Ɨ́mɨáánéjuco Tápiivyéébé uu Táavyéjuúbe! ");
INSERT INTO boaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Áánélliihyée Jetsóó néé dííbyeke: —Oke u ájtyúmɨ́nemáyé botsíi ú cáhcujtsó o bóhɨɨ́ne. ¡Maímijyu ihdyu ditye íjcyane iájtyúmɨ́turóné cáhcujtsóme! Ehdúu Jetsóó nééhií. ");
INSERT INTO boaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aabée mítyane méénúráítyúronéhjɨ́ muha ímamyémú meɨ́ɨ́ténáa méénuhíjcyáné tsá páneere o cáátúnutúne. ");
INSERT INTO boaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Árónáa ihdyu téénetu tsáneetsa ó caatúnú ámuha mecáhcújtso ɨ́mɨáánée diibyéjuco Críjto Píívyéébé Hajchi mɨ́amúnáake pájtyetétsoobe íjcyane. Áánéllii dííbyeke cáhcujtsómé tsá wágóóóvéityúne. ");
INSERT INTO boaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ááné boonétúu tsiiñe Jetsóó bóhówaavé múúhadívú ‘Tibééria’ némeíñé unéú úníuri muha ílluume meíjcyámedívu: ");
INSERT INTO boaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tsimóo Péédoroo, Tomáá dííbyere ‘Jemééro’ némeííbyee, Gariréá iiñújɨri íjcyacóómí Canáa múnáajpi Natanaéee, Tsebedéó hájchimútsí muhtsii, tsíjtyetsíi múúháejtétsii, éhdúmedívu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Áijyúu Tsimóo Péédoro ‘ói ó tsɨ́nuutéhi’ néénéllii muha menééhií: —Métsu bo tsaméhjɨ́ mepéékií. Ahdújucóo muha mɨ́ɨ́neri mepééme tépejco metsɨ́nuurómé tsá metáávatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aanée tsúúca metsɨ́tsɨ́ɨ́vénáa tééú úníuri íjcyáábeke muha máájtyúmɨrómé tsá mewáájácutú dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aabée múúhakye nééhií: —¿A ámuha métaávaj? Áánélliihyée muha menééhií: —Tsáhaá, keenéiyóhaja. ");
INSERT INTO boaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Áánélliihyée neebe múúhakye: —Cáhawáá tsíñejcu metsɨ́nuj. Ahdújucóo ténejcu muha metsɨ́nuume meújcune mítyane ámómeke. Aamée ávyétá padúúcú néémeke tsá muha meɨ́hnáhootú meíjchívyetsóné mɨ́ɨ́né pañévu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Áánáacáa dííbyeke o wáájácúne Péédoróké o nééhií: —¡Áánerá Ávyéjuube Jetsóó aábye! Ehdúu o néénemáyé Péédoro ɨ́ɨ́cúi íwajyámuvu iúcáávéne cátsíñiivyé tééú pañévú dííbye éllevu ipyéékií. ");
INSERT INTO boaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Áánetúu ihdyu muha choocói tsɨ́nucóóhó llícyúhcoméré mepéé 100 éévetá hajchótáubáhjáa muha íúníutu meíjcyame. ");
INSERT INTO boaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aamée muha meíjchivyémé máájtyumɨ́ tétsihyi cúújúwatu amóóbé wáhjámeíñé úníuri pááaho íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Áánáacáa Jetsóó néé múúhakye: —Ámúhaj táávatu tsaatéké metsíva. ");
INSERT INTO boaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Áánélliihyée Péédoro tsɨ́nucóóhó amómema lliúcú íjchivu 153-meva íjcyámema. Árómé padúúcuríi tsá técooho móhtóbatúne. ");
INSERT INTO boaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Átsihdyúu neebe múúhakye: —Ayúwa mémajchóvaj. Aanée tsá tsáápíuba díllotú dííbyeke múha dibye íjcyane pámeerée dííbyeke muha mewáájácúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Áámekée múúhakye amóóbeke páááhoma wájtuúbe. ");
INSERT INTO boaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ehdúu Jetsóó tsiiñe múúhadívú bóhówaavé tsúúca pápihchúú ijyúvájuco ípyée ɨdsɨ́jɨ́vétsihdyu bóhɨɨ́be. ");
INSERT INTO boaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aanée muha memájchóné nɨ́jcáutu neebe Tsimóo Péédoróke: —Tsímoj, Jonáá hajchi u íjcyaabe, ¿a ɨ́mɨááné oke ú wajyú íjtye díñahbéjté oke wájyúné ehnííñevu? Áánélliihyée neébe: —Éée Ávyéjuúbej, muurá ú waajácú uke o wájyune. Áánélliihyée Jetsóó nééhií: —Ané óóma táuráávye múnáake téhmeco éhne múúne obééjámuke ditye téhmedu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Átsihdyúu idyé tsiiñe neébe: —Tsímoj, Jonáá hajchi u íjcyaabe, ¿a ɨ́mɨááné oke ú wajyúhi? Áánélliihyée neébe: —Éée Ávyéjuúbej, muurá ú waajácú uke o wájyune. Áánélliihyée idyé neébe: —Ané óóma táuráávye múnáake téhmeco éhne múúne obééjámuke ditye téhmedu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Átsihdyúu tsiiñe neébe: —Tsímoj, Jonáá hajchi u íjcyaabe, ¿a ɨ́mɨááné oke ú wajyúhi? Aanée Péédoróké ɨ́dátsó pajtyé 3-ijyúvájuco bɨwáánéré dibye díllone. Aabée nééhií: —Ávyéjuúbej, muurá tsá ɨɨná u túhúlletúne. Aabe muurá ú waajácú ɨ́mɨááné uke o wájyune. Áánélliihyée idyé neebe dííbyeke: —Ané óóma táuráávye múnáake téhmeco éhne múúne obééjámuke ditye téhmedu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Muurá u óváhtsáné hajchótá uure díwajyámuunévú u újcámeíñe ú úllehíjcyá u ímílléhulléhjɨ. Aabe u kéémécooca muurá tsíjtyeréjuco uke díwajyámuunévú iújcóóbeke tsájtyeíñé u ímíllétúróhullévu. ");
INSERT INTO boaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Átsihdyúu idyé neebe dííbyeke: —Aabe wa ihdyu ehdu uke o néérónáa oke duráávyej. Ehdúu Jetsóó néé Péédoróké dibye iwáájácu muhdú dííbyeke iúráávyéné nɨ́jcaúvú ɨdsɨ́jɨ́véneri dibye Píívyéébé ɨhtsútú bóhówájtsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aanée tétsihdyu Péédoro révoúcunú Jetsóo déjutu ɨvámeíwuúu oke dibye néébe o péébeke. Ópée muurá dííbyé úníuri nihñéré majchórí muha meíjcyánáa o íjcyaabe ó dilló dííbyeke caabyé múúhadítyú dííbyedívú méénútsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Áábekée Péédoro oke ɨɨ́ɨ́téne néé Jetsóoke: —Ávyéjuúbej, ¿ácooca áánu muhdú íjcyaáhi? ");
INSERT INTO boaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Áánélliihyée neébe: —Muurá o ímílléhajchíí tsá dibye dsɨ́jɨvéityú múijyú tsiiñe o tsááiñévújuco. Árónáa óvíjyacóóné tééneri u ɨ́jtsámeíñe. Wa ihdyu oke duráávyej. ");
INSERT INTO boaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ehdúu Jetsóó óhdityu nééné uubállé tsújaavé cahcújtso múnáadi múijyúváhjáa o dsɨ́jɨvéjúcóóítyúné uubálle. Árónáacáa ihdyu tsá tehdu dibye néétune. Muuráhjáa ihdyu íllure neebe dibye ímílléhajchíí o íjcyaíñé múijyú dibye tsááiñévújuco. Áánemáa neebe tééneri Péédoro ɨɨ́jtsámeíjyúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aane íñe tsaapi Jetsóo mámyé o íjcyaabe íhyaamɨ ó caatúnú muhdúhjáa páneere dibye méénuhíjcyanéhjɨ́ o ájtyúmɨɨbe dibye úwáábohíjcyanéhjɨ́ o lléébone. Aane méwaajácú íhyaamɨ́tú cáátuváné ɨ́mɨááné íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Áhdure íjcyaróné mítyane tsíñehjɨ Jetsóópe ɨ́jɨɨri iíjcyácooca méénuhíjcyanéhjɨ. Aane muurá páneere mecáátúnuca ííñujɨ́vú tsá waajácúhaamɨ́né úújetéítyuróne. Áyu tehdújuco.");
INSERT INTO boaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Muúbe Téóópiroj, ɨ́hdée diéllevu o cáátúnúháámɨ́ pañe ó úúballé páneere muhdúhjáa Cáání éllevu níjkyejɨ́vú ipyétsihvújuco Jetsóó úwááboobéré méénuhíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Muuráhjáa ímamyémuke iújcúmeke Píívyéébé Apííchoj tééveri níwááveebe ɨɨná ditye méénúiñévu. ");
INSERT INTO boaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Áámedívúhjáa muurá ɨ́dsɨjɨ́vé boone bóhówáávehíjcyaabe 40 coojɨ́vá hajchótá ɨ́mɨáánéjuco dibye bóhɨɨne ditye iwáájácuki. Áámekéhjáa Píívyéébé avyéjutu úwáábohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aabéhjáa néé diityéke: —Jerotsaréetúi kiávú mépehdíñe. Météhmecói tétsihdyu Llihíyóo ámúhakye iájcuíñé néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ɨ́mɨáánéjucóo Jóáa tsótsohíjcyáné nújpácyori. Áánetu ihdyu lléváhréjuco ámúhá pañévú Píívyéébé Apííchó úcááveíñe. Ehdúhjáa neebe Jetsóó ímamyémuke. ");
INSERT INTO boaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aaméhjáa tsiiñe dííbyema idyóbéévétsihvu néé dííbyeke: —Ávyéjuúbej, ¿a ícyooca tsiiñe ú ímíbáávyétsoó méiiñújɨ́ tsíjtyé hójtsɨ́ pañe iíjcyájúcóótuki? ");
INSERT INTO boaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Áánélliihyéhjáa neébe: —Tsá ámuha teene mewáájácúítyuró múúcoocá Llihíyó tehdu méénuíñe. Óvíi ihdyu múijyú iímílléijyu méénuube páneere dííbyé hójtsɨri íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Áánetu ihdyu dííbyé Apííchó ámúhadívú níítyene ámúhá pañévú úcáávécooca ámuha tééné ɨhnáhoori méúwááboó óhdityu íjcyáné uwááboju Jerotsarée múnáakee, Jodéá iiñújɨ múnáakee, Tsamááriá iiñújɨ múnáakee, íjcyane. Aane téhdure tsújááveé pahúllevá múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ehdúhjáa diityéké iñétsihdyu Jetsóó ditye ɨ́ɨ́téneríyé tsúúca cáámevu wátyóhɨɨvéhi. Aabéhjáa ojtsó pañévú tsúúca tévééveíñúúbeke tsáhájuco ditye ájtyúmɨtúne. ");
INSERT INTO boaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aaméhjáa cáámevu dibye péhullévúré ɨ́ɨ́tehíjcyárónáa míítyétsi ávyéta tsɨ́tsɨ́ íwajyámúúcú néémutsi bóhówaavé diityédívu. ");
INSERT INTO boaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aamútsíhjyáa néé diityéke: —Ámuúha Gariréá iiñújɨ múnaa, ¿aca ɨɨná caame ámuha méɨ́ɨ́tehíjcyáhi? Muurá ámúhama ícyahíjcyaabe Jetsóó péjucóó ámúhadítyú níjkyejɨ́vu. Aabéjuco idyé tsiiñe tsááiñe muhdúhjané ámuha meɨ́ɨ́ténáa ipyéhduú. Ehdúhjáa neemútsí diityéke. ");
INSERT INTO boaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aaméhjáa oríívó bájú ijcyátsihyi iíjcyátsihdyu oomí Jerotsaréevu. Pɨ́hɨ́réhrée técoomítyú téhbaju múhajchótá wáyeéévejcóójɨ́ meúlléiyóné jodíómú taúhbaju nééné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aaméhjáa técoomívú úújeté ípyée iícyahíjcyajávú cáámééɨ́jɨri íjcyáné mɨjcóhovu. Ílluuméhjáa diítye: Péédoroo, Jacóóboo, Jóáaá, Aderéee, Perípee, Tomáaa, Baatoroméee, Matéoo, tsijpi Apéó hajchi Jacóóboo, tsáha múnaa cananíjtámúejpi Tsimóoo, Jacóóbó nahbe Jóódaá, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aaméhjáa paíjyuváré dóbéévehíjcyá tééhó pañévú Píívyéébema iíhjyúvaki. Áámemáhjáa ijcyámé Jetsóó nahbémuu, tsɨɨ́juu, tsijtye walléémuu, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Áijyúhjáa Péédoro íñahbéjté 120-meva íjcyáméj pɨɨnévú iíjyócúúvéne néé diityéke: —Ámuúha táñahbémuj, tsúúca pajtyéné éhnéhjáa Píívyéébé waajácúháámɨtu Jóóda pɨ́áábóneri Jetsóoke ditye ékééveíñé cáátúnúmeíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ehdúhjáa muurá dibye dííbyedívú méénútsoíñé tsúúcajátújuco Píívyéébé Apííchó néhijcyáné Dabíiúvuj tééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Diibyée muurá Jóóda Jetsóó mamyémú meíjcyáméejpi tsaméhjɨ́ɨ dííbyema mewákímyeíhíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aabée ímityúné méénune ditye áhdóne dsɨ́ɨ́dsɨ́ dibye wájójcoíñúné iújcúnemma ahdómé tsátsii ííñujɨ. Ááné boonétúhjáa muurá iiye dsɨ́jɨ́vétsómeííbyé áákityé apáhajchíí íhbáu áachívújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aanéhjáa Jerotsarée múnaa iwáájácúne dityée áhdotsíí meménú Atséédama ‘Tújpácyo Ájtsɨ’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Muurá Tsááamóháámɨtu téénetu nééneé: Íávajáréjuco dííbye ja cóévájari tsáhájuco múha íjcyáityúne. Téhdure idyé tsiiñe nééneé: Tsíjpiiyéjuco dííbyé wákimyéivu cápáyóóveíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ahdícyane muurá ijcyámé tsaate éhnée Jóáa Jetsóoke tsójtsoobe cáámevu pétsihvújuco meke náhbénuhíjcyáme. Áámedítyú ihdyu óvíi méujcú tsáápiikye dibyée ɨ́mɨááné ɨdsɨ́jɨ́vétsihdyu bóhɨɨne úúbállehíjcyáííbyeke. Ehdúhjáa neebe Péédoro. ");
INSERT INTO boaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ahdújucóhjáa míítyétsikye ditye pevénéréi mémenúné tsáápiikye diityétsidítyú iújcuki. Tsáápíhjyáa Jotséé dííbyere ‘Batsabáa’ némeííbyé téhdure Jójto imyémé íjcyaábe. Áánetúhjáa tsijpi Matía. ");
INSERT INTO boaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Áámútsí hallúvúhjáa íllu Píívyéébema ihjyúváme: —Ayúju Ávyéjuúbe Píívyéébeéj, uu muurá pámé ɨ́buwáánéré ú waajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Aabe ihdyu ú waajácú caabyé u tújkevélleebe íjtyétsidítyú úcááveíñé díhjyú uwááboobe iíjcya Jóódáuvúu íimítyú nɨ́jcaúvú úújetéébé cápayóóve. ");
INSERT INTO boaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ehdúhjáa Píívyéébema iíhjyúvátsihdyu nehcómé diityétsidítyú cáábyeké iújcuíñe. Aanéhjáa úújeté Matíadívu. Aabéjucóhjáa úcaavéné 11-meváréjuco íjcyame Píívyéébé uwááboju úwááboméré péhíjcyáímyé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aaméhjáa pámeere tsijtye cahcújtso múnáama ‘Pejtecojtée’ némeíñé wañéhjɨj cóójɨ́ dóbeevéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Áánáacáhjáa peecútéré éhne múúne tsɨ́jpáné kiijyébá tsááne íhjyuvádú nééne tsáá cáámetu. Aanéhjáa ávyeta wádóoové pájá pañére. ");
INSERT INTO boaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Árónáacáhjáa tsúúca cúújúwaj péétédú ‘nɨwáhnɨ́wá’ tsáápitsá hallúvú bóhówaavéne. ");
INSERT INTO boaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ehdúhjáa diityé pañévú Píívyéébé Apííchó úcaavéné diityéké ihjyúvatsó tsíjtyéhjɨ́ ihjyúháñeri ditye lléébótúrójúhjɨri. ");
INSERT INTO boaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Téijyúhjáa ijcyámé tsijtye jodíómú tétsihyi Jerotsaréeri Méécáánikye muhdú ɨɨ́jtsúcunúdú úráávyehíjcyámé panévá iñújɨ́ɨ́netu tsáámeé. ");
INSERT INTO boaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aaméhjáa mítyane tétsii íhjyuba íjcyane illéébóne diityédívú píhcyaavéhi. Aaméhjáa úvánujcátsí tsaatétsáhjɨ́ɨ ditye íhjyúvájúhjɨri íhjyuváné illéébónema. ");
INSERT INTO boaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ááneríhjyáa úváhtúuuvémé néjcatsíhi: —¿Aca tsá éhne íjtye Gariréa múnaa íjcyatúne? ");
INSERT INTO boaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Aca muhdú ɨ́ɨ́vane ávyeta meíhjyúvájúhjɨri ihjyúváme? ");
INSERT INTO boaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Muurá íñe íchii mee panévá iñújɨ́ɨ́ne múnaa Páátiaa, Méédia, Eráaa, Metsopotáámiaa, Jodéaa, Capadóótsiaa, Póótoó, Áátsiaa, Pírííjiaa, Pajpííriaa, Ejíhtoo, Tsirééné tujkéveri íjcyane Áápirícaa, éhdúné iñújɨ́ɨ́ne múnaa. Áhdure ijcyámé Róómátu tsáámedítyú tsaate páñétúejte jodíómu. Téhdure ijcyámé jodíómú íjcyáturómé diityé uwáábó úráávyehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Áhdure ijcyámé Créétama Aráábiá múnaa. Ílluume íñe mélleebó muhdú Píívyéébé ɨhtsútú diityéké íhjyúvatsóné meíhjyúvájúhjɨri. ");
INSERT INTO boaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aaméhjáa tééneri úllévenúmé idyé tsiiñe néjcatsíhi: —¿Muhdúami íhya tsáma teénej? ");
INSERT INTO boaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Árónáacáhjáa tsaate diityédí iúúhɨ́vaténe nééhií: —Íllure llíyíícyavéme. ");
INSERT INTO boaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Áánélliihyéhjáa diitye 11-mevádítyú Péédoro iíjyócúúvéne kéévánécoba néé diityéke: —Ámuúha tamúnaa íñe múhdumé Jerotsarée múnáama tsijtye íjcyamej, cáhawáá ámúhama o íhjyuváné ímíñeúvú mélleebúcunuj. ");
INSERT INTO boaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tsá muha mellíyíícyávetú eene ámuha múúhadítyú menéhduú. Muurá llíyiicyáve múnaa íjcyarómé tsá ícyooca ááméjutúréi nuhba íjcyánáa llíyíícyávetúne. Aanéjɨ́ɨ́ awáá muhdú muha méllíyíícyáveéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Muuráhjáa Píívyéébé ihjyú uubálle múnáajpi Joéé íñe ícyooca pájtyénetu nééhií: ");
INSERT INTO boaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Muurá nihñéré mɨ́amúnáá pañévú Táapííchó ó pícyoóhi. Ááméj tsɨɨménémúháábé ɨ́ɨ́búwá déjúcotu táuwááboju ijchívyeéhi. Ováhtsámú naavédú nénehjɨ ɨ́ɨ́téné pañe diityémá ó ihjyúvaáhi. Áánetu kéémémuma ó ihjyúvaá ityúwaháñé pañe. ");
INSERT INTO boaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ehdu ó ájcuú Táapííchotu pámeere múhdumé táɨɨcúve múnaa íjcyámeke wajpíímumáyé walléémuke. Aame táuwáábó méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Áijyu caame iévéhoowávú ó úújétsoó páhduváré nénehjɨ meúllévenúnéhjɨ. Áánetu ííñújɨri íjcyaíñé tééné uubálleháñé mítyane méénujcátsiháñé pañe tújpacyo wágóóóveíñe. Áhdure íjcyaíñé panéváré áíívyéne ójtso. ");
INSERT INTO boaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Muurá cóójɨ́ejpi nuhba áábáteéhi. Áánetu péjcóejpi íjcyaá tújpacyóduréjuco. Ehdu páhduváré nénehjɨ pájtyeé Ávyéjuube Jetsóó tsááiñe ávyétá ɨhtsútú nééíñé úmɨ́wari. ");
INSERT INTO boaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aane pámeere múhdumé dííbyedi tsúúrámeíhijcyámé ihdyu pájtyéteéhi. Ehdúhjáa Joéej tééveri Píívyéébe nééhií. ");
INSERT INTO boaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ahdícyane, ámuúha tamúnaa ijraéémuj, cáhawáá mélleebúcunu tsiiñe ámúhakye o nééiñe: Muurá ámuháyé méwaajácú Jetsóó Natsarée múnáajpi íjcyáábej tééveríi Píívyéébe panéváré méénúráítyúronéhjɨ́ méénuhíjcyáné ámúháj pɨɨnévu. Tééneríi muurá meke úújetsójúcóóroobe ɨ́mɨááné Píívyéébe dííbyeke wálloóne. ");
INSERT INTO boaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Áróóbedívúu ámuha ímítyúmeke méméénutsó páwachékevu mewátyétyéhcútsóneri Píívyééberéhjáa ihdyu tsúúcajátújuco néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Áróóbekée muurá dííbyere Píívyéébe bóhɨɨtsó tsúúca dsɨ́jɨ́véjúcóóróóbeke. Muuráhjáa tsá muhdú dsɨjɨ́vé dííbyeke méénúítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Muuráhjáa Dabíiúvú dííbyedítyú nééhií: Paíjyuvárée Ávyéjuube óómaye ú ícyahíjcyáhi. Aabe muurá oke ú téhmehíjcyá ɨ́ɨ́nerí o íllityétuki. ");
INSERT INTO boaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ááneri mítyane o ímíjyúúveebe uke ó duurúvahíjcyaáhi. Áánéllii o dsɨ́jɨ́vécooca tsaímíyé úúma ó íjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Muurá tsá tabóhɨ́ u ɨ́hvéjtsóityú tene iwágóóóveki. Áhdure tsá u ɨ́hvéjtsóityú dɨ́ɨɨcúve múnáájpikye mítyane u wájyúúbej pi ɨ́cúbáhrámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Muuráhjáa oke ú waajácutsó ɨ́mɨájɨjtóvu. Aabe mítyane ó ímíjyuuvé óóma u íjcyánélliíhye. Ehdúhjáa Dabíiúvú néé Jetsóodítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Aabéhjáa muurá diibye Dabíiúvú dsɨ́jɨ́véébeke ditye cúúune ícyoocápí dííbyeúvú nijkye ijcyáhi, ámuúha táñahbémuj. ");
INSERT INTO boaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Muuráhjaa Píívyéébé ihjyú uubálle múnáajpi íjcyáábeúvú ɨ́mɨááné waajácú Píívyéébe dííbyeke néhijcyáné dííbyeúvúj tsɨɨménémúhaabe llíyaatémedítyú Críjto ávyéjuutéiñe díbyeúvúu ávyéjuutédu. ");
INSERT INTO boaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ehdúhjáa tene pájtyeíñé ɨ́hdétújuco iwáájacúdú íjcyáábeúvú nehíjcyá Críjto ɨdsɨ́jɨ́vétsihdyu bóhɨɨbe wágóóóvéityúne. Áhduréhjáa nehíjcyáábeúvú dííbyej pi muhdú íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ahdújucóo muurá dííbyeke Píívyéébe bóhɨɨtsóne. Aane muha pámeere méwaajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Áábekée Píívyéébe ílluréjuco ávyéjujtsóne. Áábej tééveri muurá íñe ícyooca Cááni Íapííchó múúhá pañévú picyóó dííbyekéhjáa iñéhdújuco. Aane íñe páneere ámuha maájtyumɨ́né, melléébone, Pííyéébedítyúré tsáá Ílli Jetsóoj tééveri dibye méénune. ");
INSERT INTO boaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Íllúhjáa muurá tsiiñe Dabíiúvú nééhií: Ávyéjuubée néé táavyéjúúbeke: Íchihvu táúniúvú diicya dímunáake úúma o táhjáné hajchóta. Ehdúhjáa néébeúvu. Árónáacáhjáa ihdyu tsá dibye íhdityu íhjyúvatúne. Muuráhjáa tsá dibye cáámevu níjkyejɨ́vú péétu Críjto péhduú. ");
INSERT INTO boaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aane ihdyu ámuha pámeere tamúnaa ijraéémú méwaajácúiyá Píívyéébée Mépájtyetétsoobe Críjtoke pícyóóbeke ámuha páwachékevu medsɨ́jɨ́vétsóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ehdúhjáa Péédoro nééne diityéké múhdurá pájtyénéllii pámeere diitye uwáábojtéké nééhií: —¿Aanéhaca íñe muhdúí muúha, ámuúha múúhá nahbémuj? ");
INSERT INTO boaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Áánélliihyéhjáa Péédoro néé diityéke: —Ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne ɨ́mɨáámeréjuco meíjcyá ámúhá imítyú ámúhá hallúrí iíjcyájúcóótuki. Ááne métsójtsótsaméí Jetsocríjto mémeri Píívyéébe ámúhá pañévú ipícyo Íapíícho. ");
INSERT INTO boaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Aane muurá íñe ɨ́hdétújucóo úúbállémeíhijcyáné pámeere ámúháj tsɨɨménémúháábema ámúhá wáábyuta. Téhdure pámeere pahúllevá múnáake Méécááni Píívyéébe wábyújtsómé wáábyuta teéne. ");
INSERT INTO boaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ehdúhjáa Péédoro diityéké iúwáábótsihdyu nééhií: —Ɨ́mɨánejcúvuréjuco mepájtyé mɨ́amúnaa ímityúné ícyahíjcyánetu. ");
INSERT INTO boaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ahdújucóhjáa múhdumé dííbyé uwáábó cáhcújtsodúmé tsójtsótsámeíñe. Áijyúhjáa tsúúca cahcújtso múnaa llíyaatémé 3,000-mevájuco. ");
INSERT INTO boaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aaméhjáa diityé uwáábó úraavyémé tsaímíyé náhbévájcatsímyé tsatsíhvú idyóbéévéne Píívyéébema ihjyúvahíjcyáhi. Téhduréhjáa Jetsóó dsɨjɨ́vé ɨɨ́tsaavéné pááaho iwátújcatsíñé máchohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aanéhjáa ímí ɨjtsúcunúme. Áámemáhjáa uwáábojte méénúráítyúronéhjɨ́ méénuhíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aaméhjáa tsaímíyé iñáhbévájcatsíñe panévatúré pɨ́áábócatsíhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ihñénéhjɨ́hjáa iñáhjɨ́hénúne pɨ́áábohíjcyámé pɨ́htómeke. ");
INSERT INTO boaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aaméhjáa paíjyuváré dóbéévehíjcyá duurúvajávú Píívyéébeke idyúúrúvaki. Tsaímíyéhjáa ihjyáháñeri íjcyame Jetsóó dsɨjɨ́vé ɨɨ́tsaavéné pááaho iwátújcatsíñé máchohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ehdúhjáa Píívyéébeke ditye dúúrúvahíjcyáné tsijtye ímí ɨjtsúcunúhi. Aaméhjáa éhnííñevu llíyaaté Píívyéébé pɨáábori tsúúca pájtyetéme. ");
INSERT INTO boaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tsájcuuvéhjáa Péédorómútsí Jóááma péé duurúvajávú Píívyéébema ditye íhjyúvahíjcyáne ééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Áijyúhjáa tsaapi tsɨ́ɨ́ménedítyújuco úllétúúbeke pícyohíjcyámé tééjá lleehówavu ‘Imíwu’ némeítsihvu dibye ityáúmeíhíjcya dsɨ́ɨ́dsɨke tééjá pañévú úcáávémeke. ");
INSERT INTO boaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aabéhjáa diityétsikye táúmeí dsɨ́ɨ́dsɨke tééjá pañévú úcáávémútsikye. ");
INSERT INTO boaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Áánélliihyéhjáa dííbyedívú ɨɨ́ɨ́téne neemútsi: —Éje, cáhawáá múhtsikye dɨhtej. ");
INSERT INTO boaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aanéhjáa ɨjtsúcunúúbé dityétsí tsíeménevu ájcuíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Árónáacáhjáa Péédoro néé dííbyeke: —Tsá muhtsi medsɨ́ɨ́dsɨ́vatúne. Árónáa ihdyu uke muhtsi mépɨ́ááboóhi. Ahdícyane Natsarée múnáájpi Jetsocríjto mémeri díjyócúúvéne duhlle. ");
INSERT INTO boaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ehdúhjáa néébere ɨ́mɨánéjcúéhójtsɨtu iékéévéébeke íjyócujcárónemáyé tsúúca ímíjpyetéébe. ");
INSERT INTO boaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Aabéhjáa tsaímiyéjuco úlleebe cáhtsíñíbaabéré diityétsima úcaavé tééjá pañévú Píívyéébeke dúúrúvaabére. ");
INSERT INTO boaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aanéhjáa tétsihyi íjcyame ájtyumɨ́ ímíhyéjuco úlleebe Píívyéébeke dúúruváne. ");
INSERT INTO boaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Aanéhjáa waajácúmé diibyéjuco duurúvájá lleehówaríi ‘Imíwu’ némeítsihyi ácuúcunúúbé pɨáábó táúmeíhíjcyaabe dibye íjcyane. Ááneríhjyáa ávyeta ullévenúmé dííbyedi. ");
INSERT INTO boaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aabéhjáa tsúúca ímíjpyetéébé tsá ɨ́hvéjtsotú diityétsí Péédorómútsikye. Ááneríhjyáa mɨ́amúnaa itsájúréévéne dsɨɨnécunú diityé éllevu duurúvájatu tsátsii ‘Tsaromóo’ némeítsihyi íjcyáme éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Áámekéhjáa Péédoro iájtyúmɨ́ne nééhií: —Ámuúha tamúnaaj, ¿aca muhdú ɨ́ɨ́vane ámuha meúllévenúne múhtsidyívú méɨɨté tehdu múhtsí ɨhnáhooríyé muhtsi meméénúneríjɨ́ɨ́vari? Áhdure ¿aca ɨ́mɨájtétsí muhtsi meíjcyánéllii tehdu mémeenúhi? ");
INSERT INTO boaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Muuráhjáa téhdure méɨhdé múnáaúvú Aavaráaa, Itsáaa, Jacóóboo, éhdume cáánívahíjcyaabe Mépiivyéébé Ílli Jetsóoke tééneri ávyéjútsohíjcyá éhnée ámuha ávyéjujté hójtsɨ́ pañévú meɨ́hvéjtsóóbeke. Muuráhjáa Piráátó dííbyeke ácádsɨ́jcaáyóíyónáa tsá ámuha meímílletúne. ");
INSERT INTO boaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Diibyée ɨ́mɨáábé hallúvú íhjyúvatúmé ámuha cáábyerá dsɨ́jɨvétso múnáájpí hallúvúré méihjyúvá dibye iíjchívyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ehdúu ámuha mélliihyánutsó diibyéjuco meke bohɨ́ɨ́vú ájcúúbedívu. Áróóbekée muurá Píívyéébe bóhɨɨtsóhi. Aane muha méwaajácúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Áábeke muhtsi mecáhcújtsónéllii muurá íñe áánu ímíjpyeté dííbye mémeri dííbyé ɨhnáhoori ámuha meɨ́ɨ́téneríye. ");
INSERT INTO boaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ahdícyane, ámuúha tamúnaaj, muurá ó waajácú ɨ́mɨáánéjucóo ámuha pámeere ámúhá avyéjujtémá dííbyeke medsɨ́jɨ́vetsóné ámúhá ɨ́buúúné aabáte. ");
INSERT INTO boaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Árónáacáa ihdyu tehdújuco dibye ɨ́cúbáhrámeíñé tsúúcajátújucóo Píívyéébe íhjyú uubálle múnáaj tééveri néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Áánéllii ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne Píívyéébé icyánejcúvuréjuco méɨ́buwáávé ténehjɨ ámúhama iábájɨ́ɨ́vémeí ímí Píívyéébema ámuha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Muurá meéllevu wállóóiibye Ílli Jetsocríjtoke tsúúcajátújucóo meke dibye pájtyetétsoíñé iñéébeke meke dibye iújcúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Aabe muurá níjkyéjɨri íjcyaá páneere muhdúhjáa Píívyéébe íhjyú uubálle múnáaj tééveri tsúúcajátújuco iñéhijcyáné ímíbáávyétsóné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","Íllúhjáa muurá Moitséeúvú néé méɨhdé múnáaúvuke: “Ávyéjuube Píívyéébe méhdityu pícyoó tsaapi íhjyú uubálle múnáajpi íjcyáííbyeke íñée oke ipícyohdu. Áábeke ihdyu tsáma méllééboco. Muurá dííbyeke cáhcújtsotúmé wágóóóveéhi.” ");
INSERT INTO boaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Áhduréhjáa tsijpi Píívyéébé ihjyú uubálle múnáajpi Tsamoéeúvú ihjyúvahíjcyá íñe ícyooca muhdú pájtyénéhjɨtu. Áábeúvú boonéhjáa idyé tsijtye íjcyáméhjɨúvú ihjyúvahíjcyá téénetu. ");
INSERT INTO boaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ehdúhjáa muurá Píívyéébe íhjyú uubálle múnáaj tééveri nehíjcyá meeke pámeekére. Muuráhjáa méɨhdé múnáaúvuma pámeekéré meke ɨpɨ́ááboíñé Aavaráaúvuke íllu neébe: “Pámeere ííñújɨ́ cuwáábema íjcyaíñé pɨáábó dɨ́jtsɨɨménémúháábej tééveri.” ");
INSERT INTO boaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Muuráhjáa Píívyéébe Íllíkye wallóó tujkénú mee ijraéémuke dibye ɨpɨ́áábo méimítyuháñé meɨ́hvéjtsoki. Ehdúhjáa neebe Péédoro. ");
INSERT INTO boaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aanéhjáa Péédorómútsí Jóááma mɨ́amúnáama íhjyúvahíjcyárónáa tsáácunúmé llúúvájteé, duurúvájá tehméjté avyéjuúbee, tsadotséómuu, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aaméhjáa cayóbáávaté Jetsóópe dsɨ́jɨ́veebe bóhɨhdu idyé tsijtye dsɨ́jɨvémé bóhɨɨíñé dityétsí úwáábónetu. ");
INSERT INTO boaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aaméhjáa iékéévémútsikye cuvéhoojánú cúvéhréjuco tene néénélliíhye. Aamútsíhjyáa téhulléré tsɨ́tsɨɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Árónáacáhjáa diityétsí uwáábó lléébúcunúhíjcyámedítyú mítyame cáhcújtsómemáubáhjáa tsúúca úújetémé 5,000-mevájuco tsamééré wajpíímu. ");
INSERT INTO boaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aanéhjáa awáá tsíjcyoojɨ píhcyaavéjucóómé Jerotsaréevu ávyéjujtee, túkevéjtsojtee, taúhbájú uwáábojtee, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Áámemáhjáa ijcyámé llúúvájté avyéjujte Anáaa, Caipáaa, Jóáaá, Arejáádoroo, éhdume. Téhduréhjáa ijcyámé diityéjééejte. ");
INSERT INTO boaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Aaméhjáa diitye ávyéjujte néé Péédorómútsikye ditye iíjchívyétsóne itsíva diityé éllevu. Ahdújucóhjáa ditye tsájtyémútsikye ditye nééneé: —¿Aca ɨ́ɨ́né ɨhtsúturí ámuhtsi méénúráítyuróné méméénuhíjcyáhi, pane mumémeríhyaja? ");
INSERT INTO boaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Áánélliihyéhjáa Péédoro Píívyéébé Apííchó ípañe íjcyaabe néé diityéke: —Ámuúha tamúnaa íjraéémú avyéjujtej, ámuha íñe múhtsikye médilló éhnée íayáábedítyújuco úllétuube áánu muhdú ímíjpyeténé ámuha mewáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Áánéllii ícyooca muhtsi ámúhakye méúúbálleé teéne. Muurá ihdyu Píívyéébere ímíjpyetétsó dííbyeke éhnée ámuha páwachékevu Natsarée múnáajpi Jetsóoke medsɨ́jɨ́vétsóóbeke ibóhɨ́ɨ́tsóóbe mémeri. ");
INSERT INTO boaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Muuráhjáa diibyéjuco éhne múúne ímichi nééwáyutu jaa éjkedu néébeke ámuha meéhdɨɨválléroobe ícyooca ijcyá páñetúejpi teene jaa ímichi páñétúétsihdyu éjkedu néébeé. ");
INSERT INTO boaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tsá tsijpi íjcyatú meke pájtyetétsoóbe. Tsáháa muurá tsíjpiikye Píívyéébe méménutú mɨ́amúnáake pájtyetétsóííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ehdúhjáa dityétsí íhjyúváneri diitye ávyéjujte ullévenúhi. Aaméhjáa waajácú dityétsí ɨ́dátsó nééméejtétsí íjcyane tsáijyúubáré waajácúhaamɨ́né ɨ́ɨ́tehíjcyátumútsi. Árónáacáhjáa ɨ́tsaavémé Jetsóomáa dityétsí ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aanéhjáa dityétsí ímíjpyetétsoobe tétsihyi íjcyánéllii tsáhájuco ditye ɨɨná néétu diityétsidítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Áánélliihyéhjáa ílluréjuco ditye wálloone diityétsikye tétsihdyu. Ááné boonéhjáa tsamééréjuco íhjyúvájcatsíñé muhdú diityétsikye imyéénúíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Néjcatsímyéhjápeé: —¿Aanéhaca íñe muhdú méméénúiyá diityétsikye? Muurá pámeere Jerotsarée múnaa waajácú méénúráítyuróné dityétsí méénune. Aane muhdú metóónúíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Árónáa ihdyu metsu meíllívyéébo diityétsikye dityétsí éhnííñevu Jetsóodítyú íjcyáné uwááboju pámehdívúré tsújaúcútúné ɨhde. ");
INSERT INTO boaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ahdújucóhjáa tsiiñe ɨpɨ́úvámútsikye ditye ávyeta bóijcyúné dityétsí iúwaabójúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Árónáacáhjáa neemútsí diityéke: —Cáhawáá méɨ́jtsaméí keená ímí Píívyéébe ɨ́jtsúcunúne. ¿A ámúhakyéré muhtsi melléébóne dííbyeke tsá melléébóitúne? ");
INSERT INTO boaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tsáháubá muhtsi meɨ́hvetéítyuró Jetsóodítyú íjcyáné uwááboju meúwáábohíjcyánetu dibyée iúwáábóne méénuhíjcyanéhjɨ́ muhtsi maájtyúmɨ́nélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ehdúhjáa dityétsí néénéllii ibóíjcyúróne ílluréjuco ditye ɨ́hvejtsóné diityétsikye. Tsáháhjáa ditye píívyetétú muhdú diityétsikye imyéénúiyóné tsáápiikyéhjáa dityétsí ímíjpyetétsónéllii mítyame Píívyéébeke ávyéjújtsónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aanéhjáa diibye dityétsí ímíjpyetétsoobe 40 pijcyábá ehnííñevújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aamútsíhjyáa tsúúca ditye ácádsɨ́jcaáyomútsí íñahbéjte éllevu ipyééne úúballé páneere muhdú llúúvájté avyéjujtémá túkevéjtsojte diityétsikye nééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Áánélliihyéhjáa tsaméhjɨ́ íllu Píívyéébema ihjyúváhi: —¡Ayúju múúhá Avyéjuube Píívyéébeéj, uu muurá ú ijcyá páneerée iévéhóówari íjcyánéhjɨma ííñujɨ, nújpacyo, múhdúné tsíeméné íjcyane, u ípívyéjtsoóbe! ");
INSERT INTO boaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aabée muurá dɨ́ɨɨcúve múnáajpi Dabíiúvudi Díapííchó íjcyánej tééveri u nééhií: ¿Ɨ́veekí tsííñé iñújɨ́ɨ́ne múnaa páhduváré idyárɨ́ɨ́véjcatsíñe ɨ́tsámeíhijcyá ɨ́ɨ́netú diityéké pɨ́áábóítyúnéhjɨri? ");
INSERT INTO boaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Muurá ávyéjujte pítyácócatsíhijcyá Ávyéjuube Críjtoke imyéénuki. Ehdúhjáa muurá u néé Dabíiúvuj tééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aanée muurá téénéllii ícyoomívú píhcyáávehíjcyámé Heróódee, Póótsio Piráátoo, tsííñé iiñújɨ múnaa, muuha ijraéémú avyéjujtee, ijcyame Daachi Jetsóoke imyéénu múúhakyée pájtyetétsóííbyeke u wállóóbeke. ");
INSERT INTO boaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Áábekée meenúmé tsúúcajátújucóhjáa ihdyu u néhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","30","Aame muurá u ɨ́ɨ́ténáa téhdure múúhakye méénúllehíjcyáhi. Áánéllii ihdyu óvíi múúhakye ú túkévejtsó dɨ́ɨhtsútuuri muha meúwáábohíjcya díuwááboju ɨ́ɨ́nerí íllityétúme. Áhdure múúhakye pɨáábó muha méénúráítyúronéhjɨ́ chéméméhjɨke mebóhɨ́ɨ́tsohíjcya Daachi Jetsóo mémeri. ");
INSERT INTO boaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ehdúhjáa Píívyéébema iíhjyúvánetu ditye nɨ́jkévánáa tétsii diityémá uuvécunúhi. Aanéhjáa Píívyéébé Apííchó diityé pañe íjcyame ɨ́ɨ́nerí núhnévetúmé úwáábohíjcyá dííbyé ihjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Aaméhjáa pámeere cahcújtso múnáama tsajɨ́jtóré ɨ́jtsámeímyé tsá néhíjcyatú ihñénéhjɨ́ íhdyúenéhjɨ́ íjcyane. Tsáápiitsá éhnéhjáa pámé wáábyutáré ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aaméhjáa diitye uwáábojte úúbállehíjcyá Ávyéjuubée Jetsóó ɨdsɨ́jɨ́vétsihdyu bóhɨɨ́ne. Áámekéhjáa Píívyéébe mítyane pɨ́áábohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Aaméhjáa pámeere cahcújtso múnáama ímí pɨ́áábócatsíhijcyá ɨ́ɨ́netú pɨ́htótsójcatsítyúme. Tsaatéhjáa íiñújɨ́ɨ́nema, ihjyáháñema, íjcyame ténehjɨ iñáhjɨ́hénúne dsɨ́ɨ́dsɨ́ pihjyúcuhíjcyá uwáábojtédívu. ");
INSERT INTO boaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Áánetújucóhjáa ditye ácuhíjcyáné tsaate diityédítyú pɨ́htómeke. ");
INSERT INTO boaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Áijyúhjáa íjcyaabe diityédítyú Revítámuube Jotséé Chííperévúhjáa ditye tsɨ́ɨ́mávaábe. Áábekéhjáa uwáábojte iúúhɨnúné meménú Benabéedívú ‘ímijyújtsoóbe’ nééiyóne. ");
INSERT INTO boaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aabéhjáa íiiñújɨ́ iñáhjɨ́hénúne áhdovu ajcú diitye uwáábojtéke. ");
INSERT INTO boaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Áhduréhjáa Ananíamútsí mewa Tsapíírama íiiñújɨ́ iñáhjɨ́hénúne áhdotu tsane iújcúnéj coéénevu diitye uwáábojtéké ajcú pánéhjɨ́jtaráhdu. Aanéhjáa mewa waajácú dibye muhdú méénune. ");
INSERT INTO boaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Áábekéhjáa Ananíake Péédoro nééhií: —¿Aca ɨ́veekí Naavéné uke ɨ́búwájtsónej péévé muhdú ú meenú díiiñújɨ áhdo? ¿Ááne pánehjɨ́dú ú tsivá cóeéne? Ú imíllé múúhakye u álliñe tehdújuco Píívyéébé Apííchó ímillédú u méénune muha meɨ́jtsúcunúroki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Aca muhná teene ííñujɨ? Ááneráa dihñe teéne. Ááne áhdóo dihñéreíyo. Tsáháa tsane u újcúnéj coééné u tsíváítyuró pánéhjɨ́jtaráhdu. Aanéhaca idyé múúhakyéré u állíñejɨ́ɨ́vari. Muurá téhdure Píívyéébeke ú allíhi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ehdúhjáa Péédoro néénemáyé Ananíá ílluréjuco dsɨ́jɨ́veebe áákityéné baavújuco. Ááné uubálléhjáa lléébome mítyane íllityéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ááhoúvukéhjáa ováhtsámú ɨbɨ́ɨ́jɨ́núne tsajtyé icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ááné boonétúhjáa mewa wajtsɨ́ ɨɨná ájyúke pájtyene wáájácútulle. ");
INSERT INTO boaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Áállekéhjáa idyé Péédoro népejtsóhi: —¿A téhdunéjucóo ílluunéré ámuhtsi menáhjɨ́henúné ámúhtsí iiñújɨ? Áánélliihyéhjáa neélle: —Éée, téhdunéjucópeé. ");
INSERT INTO boaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Árónáacáhjáa Péédoro néé díílleke: —¿Ɨ́veekíhjyáa ehdu ámuhtsi mémeenúhi? ¿Aca ámuhtsi méɨjtsúcunú Píívyéébé Apííchó wáájácúítyuróne? Éje, aatye muurá tsáá dítyájɨúvuke icyúúújétsihdyu. Aame muurá ícyooca uukéréjuco cúúutéiñe. ");
INSERT INTO boaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ehdúhjáa dibye néénemáyé tsúúca dsɨ́jɨ́velle áákityé dííbyé lliiñévu. Áálledívúhjáa diitye ováhtsámú wajtsɨ́ ɨ́ɨ́témehóvuréjuco. Áálleúvukéhjáa idyé itsájtyéne cuuúmé ájyú úníutu. ");
INSERT INTO boaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ehdúhjáa Ananíamútsikye méwama tene pájtyéneri cahcújtso múnaa mítyane íllityéhi. Áhduréhjáa tsijtye teene iwáájácúne íllityéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aanéhjáa diitye uwáábojte dóbéévehíjcyá duurúvájá pañévú tsátsii ‘Tsaromóo’ némeítsihvu. Aaméhjáa méénuhíjcyá mítyane méénúráítyúronéhjɨ́ mɨ́amúnááj pɨɨnévu. ");
INSERT INTO boaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Áámekéhjáa cáhcújtsotúmé diityémá náhbévahíjcyáturómé ímí ɨjtsúcunúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Téijyúhjáa idyé tsijtye wajpíímumáyé walléémú cóbéévehíjcyá duurúvájá pañéahcujtsó Píívyéébeke. Aaméhjáa éhnííñevu mítyaméjuco llíyaaténe. ");
INSERT INTO boaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Áánetúhjáa chéméméhjɨke ɨ́ɨ́hbotáháñeri ijchívyetsómé hulléjɨjtónéj pɨɨnévú tééneríváa Péédoro pájtyéébe náávéubáré diityé hallútú pájtyéneri ditye ibóhɨɨ́ki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Téhduréhjáa idyé íúníúécoomíjɨ múnaa Jerotsaréeri íjcyáábe éllevu tsívahíjcyá chéméméhjɨke. Áhduréhjáa tsívahíjcyámé naavémú ípañe íjcyame ɨ́cúbáhrámeíhíjcyámeke dibye ibóhɨ́ɨ́tsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aanéhjáa páñétúejpi llúúvájté avyéjúúbema tsadotséómú nomíutáává diitye uwáábojtédi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Áánélliihyéhjáa diityéké cuvéhoojánúme. ");
INSERT INTO boaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Árónáacáhjáa tépejco níjkyéjɨ múnáajpi cúvéhóójá llehówááné ipááyúnetu iíjchívyétsómeke néé ditye mɨ́amúnáake duurúvájá pañévú iúwááboté muhdú Píívyéébeke meúraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ahdújucóhjáa ditye cúúvénetúré tééjá pañévú ipyééne úwaabóne. Áánáacáhjáa diibye páñétúejpi llúúvájté avyéjuube íñahbénu múnáama pihjyúcú túkevéjtsojtéke. Áánemáhjáa tehmé múnáake wallóómé diityé éllevu cúvéhóójá pañétú ditye iújcutéki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aaméhjáa pééme úújeté íávajávuréjuco. ");
INSERT INTO boaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Áánélliihyéhjáa ióómíñe néémeé: —Muha méúújetérá cúúveja cóhpé wátájcámeíjyá tehmé múnaa lléhowááné téhmehíjcyámedívu. Áronáa muha lléhowááné mépaayú dáíháñeréjuco tsaatéubáré pañe íjcyájúcootúne. ");
INSERT INTO boaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ehdúhjáa ditye úúbálléneri diibye páñétúejpi llúúvájté avyéjuúbee, duurúvájá avyéjuúbee, tsijtye llúúvájteé, íjcyame iúllévenúne néjcatsíhi: —¿Aca kiávú pééiyóme? ");
INSERT INTO boaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Árónáacáhjáa tsaapi téhullétú tsáábe néé diityéke: Áánerá éhnéijyu ámuha mecúvéhoojánúmé éhlle duurúvájá pañe uwááboríjyuco. ");
INSERT INTO boaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Áánélliihyéhjáa tehmé múnáá avyéjuube péé tsaatémá diityé éllevu. Aaméhjáa diityéké ɨ́cúbáhratúmé tsajtyé mɨ́amúnaa néwayúúnevu diityéké áámúíyóné apííchori. ");
INSERT INTO boaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Aaméhjáa diitye ávyéjujtédívú wájtsɨ́tsómeke páñétúejpi llúúvájté avyéjuube nééhií: —Ááneráhjáa muha ámúhakye mébóijcyú ámuha meúwaabójúcóótu eene ámuha meíhjyúvahíjcyáábedítyú íjcyáné uwááboju. Árónáa ¿ɨ́veekí éhnííñevúré ámuha méúwaabóhi? ¿Ɨveekí ámuha Jerotsaréeri dííbyé uwááboju metsújaúcúne méimíllé dibyée dsɨ́jɨvéné múúhá hallúvú mewátyanúne? ");
INSERT INTO boaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Áánélliihyéhjáa Péédoro nééhií: —Árónáa ihdyu Píívyéébe múúhakye néhdújuco muha meméénune mɨ́amúnaa múúhakye bóíjcyúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Muuráhjáa téhdure méɨhdé múnáaúvú dííbyeke cáánívahíjcyaabe Mépiivyéébé Jetsóoke bóhɨɨtsó éhnée páwachékevu ámuha mewátyétyéhcútsoobe dsɨ́jɨ́véébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Áábekée muurá dibye ávyéjuutétsoobe ícyooca ijcyá dííbyé úníuri Ávyéjuube Pájtyetétsoobe íjcyáábej tééveri mee ijraéémú ímityúné meícyahíjcyáné meɨ́hvéjtsóne ɨ́mɨánejcúvuréjuco meɨ́búwááve ténehjɨ máhallúrí iíjcyájúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aane muurá Píívyéébé Apííchó múúhadívú bóhówajtsóné íñe muha meúúbállehíjcyáhi. Muurá ɨ́mɨááné dííbyeke mecáhcújtsómé pañe dííbyé Apííchó ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ehdúhjáa Péédoro nééne diityéké cáyobáávatétsómé imíllerá diityéké ɨdsɨ́jɨ́vetsóne. ");
INSERT INTO boaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Árónáacáhjáa paritséómuube ‘Gamariée’ némeííbyé taúhbájú uwááboobe íjcyáábeke mɨ́amúnaa ávyejúúllehíjcyaabe diityéj pɨɨnétú iíjyócúúvéne néé dityéi iíjchívyétso áachívú wahájchotáwu diitye uwáábojtéke. ");
INSERT INTO boaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ááné boonéhjáa neebe diityéke: —Ámuúhaj, téɨɨbúwá tsáma méíjcyaco. Ááne ímíñeúvú meɨ́jtsámeítsihdyu aatyéké méméénuco ámuha meméénúíhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Muuráhjáa ‘Téoda’ némeííbyé ɨtsúcunúmeíhijcyá ɨ́htsútuube iíjcyane. Áábemáhjáa muurá ijcyámé mɨ́amúnaa 400-meva. Áróóbekéhjáa tsaate dsɨ́jɨ́vétsóné boone pámeere dííbyema íjcyarómé pahúllevávú tsújaavé tétsɨ́hjɨ́ daíhañéréjuco. ");
INSERT INTO boaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Téhduréhjáa Gariréa múnáajpi Jóódáke pajtyéné mɨ́amúnáake ditye éévehíjcyáijyu. Áábemáhjáa muurá téhdure mítyame íjcyáróóbeke idyé dsɨ́jɨ́vetsóme. Ááné boonéhjáa dííbyema íjcyarómé ílluréjuco wáhchájabáne. ");
INSERT INTO boaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Áánéllii ámúhakye o néé diityéké éhnííñevu ámuha mepátsárijcyójúcóótuki. Muurá ihdyu ɨ́mɨááné mɨ́amúnáadítyúré tsááné uwááboju ditye úwáábohíjcyáhajchíí diityémá nɨjkévaíñé muhdú ámuha diityéké meméénútúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Áánetu Píívyéébedítyú tsááné uwááboju íjcyáhajchíí tsá ámuha muhdú meméénúityúne. Áánéllii téɨɨbúwá meíjcya. Tsá tene ímityú Píívyéébeke ámuha ímityúné medárɨɨvéne. ");
INSERT INTO boaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ahdújucóhjáa dííbyeke ditye lléébone. Árónáacáhjáa ihdyu diitye uwáábojtéké ɨpɨ́úvámeke wátsihcyúme. Áámekéhjáa iácádsɨ́jcaáyo tsiiñe bóijcyúmé ditye iúwaabójúcóótu Jetsóodítyú íjcyáné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aaméhjáa péé imíjyúwu Píívyééberéhjáa ihdyu ɨ́hvejtsódújuco Jetsóodítyú íjcyáné uwáábójú hallútú núcójpɨ́tsó ɨɨ́cúbáhrámeíyónnáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aaméhjáa ɨ́hvéjtsotúmé éhnííñevúré pajcóójɨváré úwáábohíjcyá duurúvájá pañévu. Téhduréhjáa tsíjtyeke ihjyáhañévúré úwááboméré pehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Aanéhjáa téijyu tsúúca mítyaméjuco cahcújtso múnaa llíyaaténe. Áánáacáhjáa tsaate jodíómú íjcyarómé gríéégómú ihjyúrí íhjyuvámé imúnáadítyú nehíjcyá dityéváa pííbájyujtéké panévatúré pɨ́áábohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Áánélliihyéhjáa diitye méjtúhatyu míítyétsi íjcyame uwáábojte pámeere cahcújtso múnáake ipíhjyúcúmeke nééhií: —Muurá íñe Píívyéébé uwááboju muha meúwaabómé tsá tsíñéhjɨri metúhújkímyeíítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Áhdícyane, ámuúha múúhá nahbémuj, ámúhadítyú tsaate ɨ́mɨáámé 7-meváké menéhcóne téénevu mepícyó Píívyéébé Apííchó diityéké túkévétsohíjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Áánetu ihdyu muha dííbyeke pɨáábó metáúmeíñe dííbyé uwááboju méúwáábohíjcyaáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ehdúhjáa ditye nééne ímí tehdújuco ɨɨ́jtsúcunúnéllii meménújucóómé Ejtéébake Píívyéébé Apííchó túkévéjtsóneri ímí dííbyeke úráávyehíjcyáábeke. Áábé hallúvúhjáa meménúmé íllúúmeke: Perípee, Próócoroo, Nicanóoo, Timóoo, Paméénaa, Ajtiokíía múnáajpi Nicoráá jodíómuube íjcyátúroobée diityé uwááboju tujkénú iúráávyehíjcyátsihdyu Jetsóokéréjuco cáhcújtsoóbee, éhdúmeke. ");
INSERT INTO boaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Áámekéhjáa tsajtyémé diitye uwáábojté éllevu. Áámé hallúvúhjáa íhyójtsɨne ipícyóóne táúmeímyé pɨáábo. ");
INSERT INTO boaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ehdúhjáa Píívyéébé uwááboju Jerotsaréevu tsújaavéné mítyame cáhcujtsómé éhnííñevu llíyaatéhi. Áhduréhjáa mítyame llúúvájtedítyú cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Áijyúhjáa Ejtéébá méénuhíjcyá méénúráítyúronéhjɨ́ Píívyéébe pɨ́áábóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Áábemáhjáa táhjácatsíhijcyámé tsaate pihcyááveja ‘ɨɨcúve múnaa íjcyájúcootúme’ némeíjya múnáama Tsirééne múnaa, Arejadríía múnaa, Tsiríítsiá iiñújɨ múnaa, Áátsiá iiñújɨ múnaa, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ároméhjáa tsá dííbyeke táhjatú Píívyéébé Apííchóré túkévéjtsóneri dibye íhjyúvahíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Áánélliihyéhjáa ahdómé tsaatéké ditye dííbyé hallúvú iállíñe iñéé dibyéváa Píívyéébeé, Moitséeúvuu, íjcyámútsidítyú ímityúné íhjyuváne. ");
INSERT INTO boaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ehdúhjáa ditye nééne túkevéjtsojtémá taúhbájú uwáábojtéké muhdú dárɨɨvémé awáá diibye Ejtéébake iékéévéébeke tsajtyé ávyéjujté éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Áábélliihyéhjáa nehcómé tsíjtyeke dííbyé hallúvú ditye iálliki. Aaméhjáa néé dííbyedítyu: —Áánu ímityúné ihjyúvahíjcyá duurúvájatuu, Píívyéébé taúhbájutuu, íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Áhdure nehíjcyaabe Natsarée múnáajpívá Jetsóó duurúvaja iwáchájánúne Moitséeúvú uwáábó cápáyoácoíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ehdúhjáa ditye néénéllii ávyéjujtémá tsijtye tétsihyi ácújcatyémé ɨɨtécunú diibye Ejtééba húmɨ́ amɨ́tsárahcówu níjkyéjɨ múnáájpí humɨ́du. ");
INSERT INTO boaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Áábekéhjáa páñétúejpi llúúvájté avyéjuube nééhií: —¿Ava ɨ́mɨááné ehdu teénej? ");
INSERT INTO boaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Áánélliihyéhjáa neebe diityéke: —Ámuúha tamúnaaj, cáhawáá ámúhakye o nééne mélleebúcunuj. Muuráhjáa Mépiivyéébé ɨ́htsútuube íjcyaabe bóhówaavé méɨhdé múnáajpi Aavaráaúvudívú Haráavúi dibye péétúné ɨhde Metsopotáámiá iiñújɨri íjcyáábedívu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Áábekéhjáa neébe: “Pámeere dihyájkímuke díiiñújɨma dɨ́hvéjtsóne peeco uke o wállóóné iiñújɨvu.” ");
INSERT INTO boaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ahdújucóhjáa muurá dibye íiiñújɨ́ Caadéatu péébe úújeténé Haráavu. Ááné boonétúhjáa cááni dsɨ́jɨ́vétsihdyu Píívyéébere tsivá dííbyeke íñe ícyooca meíjcyáné iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Aanéhjáa ɨ́mɨááné dííbyeúvuke iájcuíñé iñéérónáa tsáhái dibye dííbyeke ájcutú tééné iiñújɨvu. Árónáacáhjáa ihdyu neebe dibye dsɨ́jɨ́véné boone iájcuíñé dííbyéj tsɨɨménémúháábekéréjuco díbyeúvúi tsɨ́ɨ́mávátúrónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Áhduréhjáa neebe dííbyeúvudítyú llíyaaténéj tsɨɨménémúhaabe tsííñé iiñújɨri tsíjtyé hójtsɨ́ pañe íjcyame ɨ́cúbáhrámeíiñe 400 píjcyá hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Téhduréhjáa Píívyéébe néé diityédítyu: “Eene kééné iiñújɨ múnáá hójtsɨrí ditye íjcyámema teene ó ímíbájchoóhi. Ááné boone ó ijchívyétsoó téhullétú diityéké ookéréjuco ditye ɨɨ́ɨ́cúve íchihvu.” ");
INSERT INTO boaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Muuráhjáa Píívyéébe Aavaráaúvuma muhdú dibye íjcyáíñé pityájcoju imyéénéne néé pámeere dííbyéj tsɨɨménémúhaabe ikíhdyahɨ́rótsámeíki. Ahdújucóhjáa dibye méénune ílli Itsáake ɨtsɨ́ɨ́máváábeke 8 coojɨ́vá dibye íjcyátsihvu. Áhduréhjáa diibye ílli Itsáaréjuco méénune íllíkye Jacóóboke. Aabéhjáa idyé Jacóóbó meenú téhdure ɨ́ɨ́tsɨ́ɨ́meke 12-nevá dohjɨ́ba múnaa mee ijraéémú ɨhdéejtéké ɨtsɨ́ɨ́mávámeke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Aaméhjáa diitye méɨhdé múnaa Jacóóboúvuj tsɨ́ɨ́mé nomíutáávahíjcyá íñahbe Jotséedi. Áánemáhjáa dííbyedívú tsaatéké ditye náhjɨ́henúmé tsajtyé dííbyeke Ejíhtó iiñújɨvu. Áróóbekéhjáa ihdyu Píívyéébe pɨ́áábohíjcyá panéváré dííbyeke pátyehíjcyánéhjɨtu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Aanéhjáa dííbyeke dibye túkévéjtsónej péévéré teene Ejíhtó iiñújɨ́ avyéjuube Paraóó ímí dííbyeke pícyohíjcyáhi. Muuráhjáa dííbyeke pícyoobe íiiñújɨ́ túkevéjtsoobe íjcyaabe téhdure páneere dííbyé tsíeméné tehméébé dibye iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Áijyúhjáa muurá mítyane mɨ́amúnaa ɨ́cúbáhrámeí ájyábari Ejíhtó iiñújɨɨ, Canaáá iiñújɨɨ, íjcyájɨ́ɨ́cu múnaa. Tsáháhjáa téijyu méɨhdé múnáaúvudi majcho íjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Árónáacáhjáa Jacóóboúvú Ejíhtó iiñújɨri tsátsii majcho íjcyane iwáájácúne wallóó ɨ́ɨ́tsɨɨme méɨhdé múnáaúvuke ditye téhullétú tsane iújcutéki. ");
INSERT INTO boaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ááné hallúvúhjáa tsiiñe péémedívú botsíi Jotséé waajácútsámeí diitye íñahbémudívu. Átsihdyúhjáa diibye Ejíhtó iiñújɨ́ avyéjuube waajácújucóó caatyé múnáajpi dibye íjcyane. Áánélliihyéhjáa neebe dibye ɨpɨ́úva pámeekéré imúnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ahdújucóhjáa Jotséé pɨ́uváné cááni Jacóóboke pámeere ihyájkímú 75-meva íjcyámema. ");
INSERT INTO boaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aaméhjáa téhulle ícyahíjcyámé pámeere dsɨ́jɨvé 12-nevá dohjɨ́ba múnaápe mee ijraéémú ɨhdéejte íjcyame diibye cááni Jacóóbomájuco. ");
INSERT INTO boaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Áámeúvukéhjáa tétsihdyu icyúúúrómeke tsúúcajátú tsiiñe iáábyúne tsajtyémé Tsikyéevu diibyéhjáa Aavaráaúvú Hamóoúvúj tsɨ́ɨ́medítyú áhdóné nijkyénetu icyúúuki. ");
INSERT INTO boaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Aanéhjáa Píívyéébe Aavaráaúvuke pítyájcóne éévé tsúúca pɨ́ɨ́hɨ́náa memúnaa éhnííñevu llíyaaté mityáméjuco teene Ejíhtó iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Áijyúhjáa tsíjpiiyéjuco úcaavéné tééné iiñújɨ́ avyéjúúbedívú Jotséeúvuke wáájácútuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aabéhjáa iállíñe ɨ́cúbáhrahíjcyá diityédi. Áánemáhjáa nehíjcyaabe ditye ɨ́ɨ́tsɨ́ɨ́méwuúmuke iwáámíuhíjcya béhnére ɨtsɨ́ɨ́máváméwuújɨke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Téijyúhjáa Moitséeúvú tsɨ́ɨ́mávámeííbyeke Píívyéébe ímí ɨjtsúcunúhi. Áábéwúukéhjáa cáánímutsi téhmehíjcyá pápihchúú nuhbáva. ");
INSERT INTO boaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Áábéwúukéhjáa tsúúca dityétsí wáágoójúcóóróóbeke Ejíhtó iiñújɨ́ avyéjúúbé ajyúwá iújcúúbeke keemévetsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Áábekéhjáa ditye úwááboobe waajácú páneere diityé múnaápe wáájácuhíjcyanéhjɨ. Aabéhjáa ávyétá tujkéveebe ɨɨná imyéénúnetu, iíhjyúvánetu, panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aabéhjáa 40 pijcyábájuco íjcyaabe ɨ́jtsámeí imúnáake iááhɨ́vetéiñe. ");
INSERT INTO boaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aabéhjáa téhullévú péébe cábuuvé Ejíhto múnáajpi memúnáájpidi ɨ́cúbáhrahíjcyáábedívu. Áábekéhjáa lliihyánuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Áijyúhjáa ɨjtsúcunúúbé memúnáaúvú tsúúca wáájacúné dííbyej tééveri Píívyéébe diityéké ditye ɨ́cúbáhrámeíhíjcyánetu íjchívyétsoíñe. Árónáacáhjáa ihdyu tsáhái ditye wáájácutúne. ");
INSERT INTO boaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ááné tsijcyóójɨ́hjáa idyé úújetéébé tsamútsíyé memúnáajtétsí méénújcatsímútsidívu. Áámútsikyéhjáa imílléroobe idyówajcáróne. Árónemáhjáa neebe diityétsikye: ¿Ɨ́veekí ámuhtsi tsané múnáajtétsíyé meíjcyamútsí méméénújcatsíhi? ");
INSERT INTO boaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Árónáacáhjáa ímichi cáábyedítyú tene tújkévaabe diibye Moitséeke nééhií: “¿Múha uke picyóó ímítyúnéhjɨ́ ímibájchoobe u íjcyaki? ");
INSERT INTO boaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mityá oke ú lliihyánuú éhnéijyu Ejíhto múnáájpikye u llííhyanúdu?” ");
INSERT INTO boaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ehdúhjáa dibye néénetu ílluréjuco Moitséé wááneé. Aabéhjáa úújeté Madiáá iiñújɨvu. Aabéhjáa téhulle tsííñé iiñújɨri íjcyaabe tsɨ́ɨ́mavá míítyétsikye téhullétú ityáábáválledívu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Aanéhjáa 40 pijcyábájuco dibye ɨ́ɨ́néubárá píívyétúné iiñújɨri íjcyánáa níjkyéjɨ múnáajpi bóhówaavé dííbyedívú úméhéwu péétécunúné pañe ‘Tsinaíi’ némeíhbáúj pɨɨhɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Ááneríhjyáa mítyane ullévenúúbe. Áánélliihyéhjáa ímíñeúvú ɨɨ́ɨ́te dibye pɨ́ɨ́hɨ́vérónáa Píívyéébe dííbyeke nééhií: “Oo ámúhá Piivyéébé ó ijcyá dɨ́ɨhdé múnáaúvúu Aavaráaa, Itsáaa, Jacóóboo, íjcyame oke cáánívahíjcyaábe.” Ááneríhjyáa iíllityéne úúvécunúúbé tsáhájuco tsiiñe ɨ́ɨ́tetúne. ");
INSERT INTO boaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Áábekéhjáa tsiiñe neébe: “Díjtyúhápaajɨ́né tácorɨ́jcó íñe úhdivu o bóhówáávénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Muurá ó waajácú tahñéjté Ejíhtori íjcyame wánícyámeíhijcyáné ɨɨ́cúbáhrámeíñeri. Áámeke dijtyééveri o íjchívyétso íñe úhdivu ó bóhówaavéhi. Ahdícyane uke ó wallóó tééné iiñújɨvu.” ");
INSERT INTO boaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ehdúhjáa Píívyéébe néé Moitséeke éhnéhjáa memúnáajtétsiúvú ‘¿múha uke picyóó ímítyúnéhjɨ́ ímibájchoobe u íjcyaki?’ nééróóbeke. Píívyééberéhjáa ihdyu néé úméhéwu péétécunúné pañe níjkyéjɨ múnáajpi dííbyedívú bóhówáávéébej tééveri dibye memúnáaúvuke iíjchívyétsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ahdújucóhjáa méénúráítyúronéhjɨ́ imyéénúnej tééveri dibye íjchívyetsóné méɨhdé múnáaúvuke Ejíhtó iiñújɨtu. Aaméhjáa ɨ́ɨ́néubárá píívyétúné iiñújɨvu pééme Tújpáñe Móóa pajtyé nújpacyo dówáávéjɨ́jtori. Aabéhjáa téhulle 40 pijcyábá íjcyaabe méénuhíjcyá méénúráítyúronéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aabéhjáa mee imúnáadítyú nééhií: “Píívyéébere muurá pícyoó méhdityu íhjyú uubálle múnáájpikye íñe o íjcyadu nééííbyeke. Aabe ihdyu nééne méllééboco.” Ehdúhjáa néébeúvu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aabéhjáa muurá ɨ́ɨ́néubárá píívyétúné iiñújɨri méɨhdé múnáaúvuma íjcyáábedívú níjkyéjɨ múnáajpi bóhówaavé ‘Tsinaíi’ némeíhbaúvú. Áábemáhjáa iíhjyúváne ájcuube dííbyeke Píívyéébé taúhbaju cáátúnúmeíñevu dibye iájcu méɨhdé múnáaúvuke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Áróóbekéhjáa tsá ditye cáhcútsohíjcyatúne. Ílluréhjáa dííbyeke ityáhjálléne tsiiñe imíllerómé ióómiñe Ejíhtó iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Áánemáhjáa dííbyé nahbe Aróoke néémeé: “Mééma meenu Píívyéébedu néméhjɨke piéhullévúré meóómícyooca meke ditye ityúkévéjtsoki. Kiávú íñe díñahbe Moitséé úújeté mekée Ejíhtó iiñújɨtu iíjchívyétsónema.” ");
INSERT INTO boaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ahdújucóhjáa ditye níjcyone jééú ocájíwuúdú néébeke. Áábekéhjáa ɨ́ɨ́cúvehíjcyámé iyámeke illííhyánúméhjɨdi. Ááneríhjyáa mítyane ímíjyuuvémé iiye iñíjcyóóbeke ɨɨ́ɨ́cúvehíjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Áánélliihyéhjáa ílluréjuco Píívyéébe diityéké ɨ́hvejtsóné ditye awáá idyúúrúvahíjcya caame íévéhóówari íjcyáméhjɨke. Muurá dííbyé ihjyú uubálle múnáájpí waajácúháámɨtu nééneé: ¿Acáa ámuha ijraéémú oke méɨ́ɨ́cúvehíjcyá iyámeke mellííhyánúmedi 40 pijcyábá ɨ́ɨ́néubárá píívyétúné iiñújɨri ámuha meíjcyácoóca? ");
INSERT INTO boaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tsáhaá. Muuráhjáa oke ɨ́ɨ́cúvetúmé ámuha méɨ́ɨ́cúvehíjcyá ámuháyé meméénúméhjɨke. Áánemáa ámuha métsatyéhijcyá níjcyotáábé Moróoke ihjyáwúuma. Áhdurée ámuha métsatyéhijcyá níjcyotáábé mɨ́ɨ́cúruwa Rejpáake Píívyéébedi ámuha medíllónema. Áánéllii ámúhakye ámúhá iiñújɨtu o íjchívyétsómeke ó wálloó Babiróóníá iiñújɨ́ ehnííñevu. Ehdúhjáa muurá Píívyéébé ihjyú uubálle múnáajpi caatúnúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aanéhjáa muurá téhulle ɨ́ɨ́néubárá píívyétúné iiñújɨri méɨhdé múnáaúvudi íjcyaja iyámé mɨɨhénetu méénúmeíjyá duurúvaja dityéhjáa Píívyéébé taúhbaju cáátúnúmeíñé newáyuwááné pícyohíjcyaja. Ehdúhjáa méénuube Moitséeúvú Píívyéébe dííbyeke néhdújuco muhdúhjáa iájtyumɨ́du. ");
INSERT INTO boaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aajájucóhjáa dityéúvú ɨ́ɨ́netsóné tsííñé iiñújɨvu Píívyéébéhjáa Jotsoéeúvuma tééjɨ múnáake ibótoácóne dííbyeke ájcujɨ́vu. Áájaréikyéhjáa ícyahíjcyá Dabíiúvú íjcyáné hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Aanéhjáa diibye Dabíiúvú waajácú ímí Píívyéébe dííbyeke pɨ́aabóne. Áánélliihyéhjáa imílléroobe imyéénune béhja Jacóóboúvúu téhdure cáánívahíjcyaabe Píívyéébé wáábyuta teeja iyámé mɨɨhénetu méénúmeíjyá cápayóóve. ");
INSERT INTO boaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Áronéhjáa íllíyéjuco Tsaromóoúvú méénune teéja. ");
INSERT INTO boaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Árónáa Píívyéébe tsá íjcyatú apááñéré duurúvaja mɨ́amúnaa méénújá pañe. Muurá ihdyu ihdícyátsɨhjɨ́ríyé diíbye. Muurá íllu dííbyé ihjyú uubálle múnáajpi nééhií: ");
INSERT INTO boaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Níjkyéjɨri táavyéjú ijyáwá hallúrí o íjcyaabe ó ejécunú páneere ííñujɨ. Aanéjɨ́ɨ́va ¿muhdɨ́ɨ́váne já ámuha óóma méméénuú tétsihyi o íjcyaki? ");
INSERT INTO boaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aanéjucóo páneere múhdúné tsíeméné íjcyane o ípívyejtsóne. Ehdúhjáa neebe Píívyéébe íhjyú uubálle múnáájpij tééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Árónáa ámuha ávyétá nuuhéjujte meíjcyámé ɨ́buúúné éhne Píívyéébeke wáájácútúmé ɨ́buúúnédu. Aame ámuha Píívyéébé Apííchó nééné tsihdyúré méícyahíjcyá méɨhdé múnáaúvúu ícyahíjcyádúre. ");
INSERT INTO boaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Acáa cáábyeké Píívyéébé ihjyú uubálle múnáadítyú méɨhdéejtéúvú pevénéré ɨɨtécunúhijcyáhi? Muuráhjáa lliihyánuhíjcyámé ɨ́mɨáábé Críjto ííñujɨ́vú tsááiñe úúbállehíjcyárómeke. Aabée muurá Críjto tsááróóbeke ámuháyéjuco mellííhyanúne. ");
INSERT INTO boaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Muuráhjáa tsúúca ámúhama níjkyéjɨ múnáaj tééveri Píívyéébé taúhbaju íjcyájúcooróné tsá ámuha melléébohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ehdúhjáa Ejtéébá néénéllii dííbyedívú cayóbáávatémé íhwáñeene ɨɨ́hdónema. ");
INSERT INTO boaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aanéhjáa diibye Ejtéébá Píívyéébé Apííchó ípañe íjcyaabe ájtyumɨ́ níjkyéjɨri Píívyéébe íavyéjuri íjcyáábé úníuri Jetsóó íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aabéhjáa nééhií: —Muurá ó ájtyumɨ́ Mɨ́amúnáájpidívúu ípívyééveebe níjkyéjɨri Píívyéébé úníuri íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ehdúhjáa dibye néérónáa íllure íñúhejúúné iwátájcóne dííbyé tujkévetu túruuvémé íhjyúcunúmére. ");
INSERT INTO boaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Aaméhjáa técoomítyú tsiéllevu itsájtyéébeke áámuhíjcyá néwayúúnevu. Aaméhjáa íwajyámúúné ityácórɨ́jcámeíjyahjɨ́vú téhmetsó tsaapi ováhtsá ‘Tsáoro’ némeííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aabéhjáa Ejtéébá ditye áámúroobéré Píívyéébema íllu ihjyúváhi: “Ávyéjuúbej, tabóhɨ́ duúcu.” ");
INSERT INTO boaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Átsihdyúhjáa ɨmɨ́móúúvéne kéévánécoba neébe: “Ávyéjuúbej, dɨ́ɨ́cúvedí íñe íjtye ímityúné méénúróneri.” Ehdúhjáa iñétsihdyu dsɨ́jɨ́veébe. Aanéhjáa Tsáoro ímí ɨjtsúcunú ditye dííbyeke llííhyanúne. ");
INSERT INTO boaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Téijyúhjáa Jerotsaréeri cahcújtso múnaa ɨ́cúbáhrámeíiñe tujkéváhi. Áánetúhjáa tsújaavémé Jodéá iinújɨri. Tsaatéhjáa péé Tsamááriá iiñújɨvu. Árónáacáhjáa ihdyu uwáábojte tsá kiávú péétune. ");
INSERT INTO boaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Aanéhjáa ímí Píívyéébeke úraavyémé diibye Ejtéébaúvuke kímóóveméré cuuúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ááné tujkéveríhjyáa diibye Tsáoro cahcújtso múnáake wajpíímumáyé walléémuke ɨ́cúbáhraabéré ihjyáháñetu tsajtyé icyúvéhoojánuki. ");
INSERT INTO boaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Árónáacáhjáa Jerotsaréetu pehíjcyámé pahúlleváré úwáábomére. ");
INSERT INTO boaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Áánetúhjáa Perípé Tsamááriá iiñújɨri íjcyácoomívú ipyééne téhdure úúbállehíjcyá diibyéjuco Críjto Mépájtyetétsoobe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Áábedívúhjáa mítyane mɨ́amúnaa píhcyaavémé lleebúcunúhijcyá dibye úwaabóne. Aaméhjáa ɨ́ɨ́tehíjcyá méénúráítyúronéhjɨ́ dibye méénune. ");
INSERT INTO boaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tsaaté pañétúhjáa naavémuke dibye wáágoómé íhjyúcunúméré diityé pañétú ichívyehíjcyáhi. Áhduréhjáa íjpi vááúmeítyúméhjɨma úllétúméhjɨke ímípyetétsohíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ááneríhjyáa técoomí múnaa mítyane ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Áijyúhjáa íjcyaabe tétsihyi ‘Tsimóo’ némeííbyé ápííchoóbe. Aabéhjáa álliibyéré pehíjcyá teene Tsamááriá múnáake. Nehíjcyaabéhjáa pane iwáájacúne. ");
INSERT INTO boaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Áábedítyúhjáa ícyátújtsɨɨméné íllure diityéké dibye íapííchori álliñéhjɨ́ icyáhcújtsóne nehíjcyáhi: —Áánúhaca ihdyu Píívyéébé ɨhnáhoóma. ");
INSERT INTO boaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Áánetúhjáa ihdyu Perípé Píívyéébé avyéjutu íjcyáné uwááboju Jetsocríjtodítyújuco pájtyene úwaabóné cáhcujtsómé tsójtsótsámeí wajpíímuu, walléémuu, íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Áhduréhjáa diibye ápííchoobe Tsimóó íjcyároobe icyáhcújtsóne ílluréjuco tsójtsótsámeíñe. Aabéhjáa Perípema íjcyaabe ullévenúhijcyá méénúráítyúronéhjɨ́ dibye méénúneri. ");
INSERT INTO boaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aanéhjáa diitye Tsamááriá iiñújɨ múnaa tsúúca Píívyéébeke cáhcujtsóné uwáábojte Jerotsaréeri íjcyame iwáájácúne wallóó diityé éllevu Péédorómútsikye Jóáámaá. ");
INSERT INTO boaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aamútsíhjyáa téhullévú ipyééne diityé hallúvú pɨáábó táúmeí Píívyéébeke dííbyé Apííchó diityé pañévú iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsáháikyéhjáa diityé pañévú tene úcáávetú ditye Jetsóo mémeri tsójtsótsámeíjyúcóórónáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Áánélliihyéhjáa diityé hallúvú íhyójtsɨcu ipícyóóne dityétsí Píívyéébeke pɨáábó táúmeíñé tujkéveri botsíi dííbyé Apííchó úcaavé diityé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ehdúhjáa dityétsí méénune diibye Tsimóó iájtyúmɨ́ne néé diityétsikye iáhdóiyóné dsɨ́ɨ́dsɨdívu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Neebéhjápeé: —Cána oke maájcú éénevu ooréjuco tsaaté hallúvú táhójtsɨcu o pícyóóné tujkéveri Píívyéébé Apííchó diityé pañévú iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Áánélliihyéhjáa Péédoro néé dííbyeke: —¿Ɨ́veekí múhdurá dɨ́ɨ́jtsaméi? Muurá teene dɨdsɨ́ɨ́dsɨmáyé ú wágóóóvéiyáhi. Úubá ú ɨjtsúcunú Píívyéébe téénevu meke ájcune maáhdóiyóné dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Muurá tsá díwáábyuta tene íjcyatú Píívyéébe uke tújkevééllétúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ahdícyane eene ímityúné u ɨ́jtsámeíñé dɨ́hvéjtsóne dííbyeke pɨáábó táuméi. Tsáijyu múúne úhdi ɨɨ́dáátsóvéne ábájɨ́ɨ́veebe ímityúné u ɨ́jtsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Muurá ó waajácú ímityúné dípañe íjcyane éhne múúne iyáábé nijpáyú nehníwu néhdu nééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ehdúhjáa Péédoro diibye Tsimóoke néénéllii neebe dííbyeke: —Ané táhallúvú Píívyéébeke pɨáábó métáuméí eene oke u néhdu tene oke ipájtyétuki. ");
INSERT INTO boaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ehdúhjáa Píívyéébé ihjyu Tsamááriá iiñújɨri patsɨ́hjɨvá múnáake iúwáábótsihdyu óómimútsí Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Átsihdyúhjáa níjkyéjɨ múnáajpi diibye Perípeke nééhií: —Dípye Jerotsaréetu Gáátsávu pééju ɨ́ɨ́néubárá píívyétúné iiñújɨtu pájtyéjuri. ");
INSERT INTO boaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ahdújucóhjáa téhullévú péébe cábuuvéné Etiopíía múnáajpi eonóócodívú tééné iiñújɨ́ avyéjuulle ‘Cadáátse’ némeílle dsɨ́ɨ́dsɨ́ tehméébedívu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aabéhjáa Píívyéébeke Jerotsaréevu idyúúrúvájétsihdyu íijchíémɨri íiiñújɨvu óómiibye ééveebéré pehíjcyá Píívyéébé ihjyú uubálle múnáajpi Itsaíaúvú waajácuháámɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Áánáacáhjáa Píívyéébé Apííchóré diibye Perípeke nééhií: —Éhmɨ íjchíemɨ duhjéte. ");
INSERT INTO boaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ahdújucóhjáa péébe lléébúcunúné dibye éévene. Áábekéhjáa neébe: —¿A ú waajácú ɨɨná nééiyóné u éévehíjcyáne? ");
INSERT INTO boaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Áánélliihyéhjáa neébe: —Tsáhaá. Múhdutú ó waajácuú múha oke úwáábónejɨ́ɨ́vari. Ehdúhjáa iñééne pɨ́úvaabe dííbyeke íijchíémɨ́ pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aanéhjáa Píívyéébé ihjyu cáátúnúmeíñé dibye éévehíjcyáné íllu nééhií: Obééjake múúne illííhyánu ditye tsájtyedu tsajtyémé dííbyeke. Aabe pevétsɨhjɨ́dú íjcyáábeke dsɨ́jɨ́vetsómé éhne múúne obééjáwu pevétsɨhjɨ́dú íjcyáábeke ditye nɨ́ɨ́tsudu. ");
INSERT INTO boaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Áábeke ɨdátsó meenúme. Aabe ííñújɨri tsá íjcyájúcootúne. Aane íñe ¿múha téijyú múnáadítyú úúbálléiyá muhdúhjáa téijyu mɨ́amúnaa ícyahíjcyáne? Ehdúhjáa nééne éévehíjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Átsihdyúhjáa neebe Perípeke: —Cána oke ímíñeúvú duubállé múhdityúhjáa ehdu Píívyéébé ihjyú uubálle múnáajpi nééneé. ¿A íhdityu, mityá tsíjpihdítyúpeé? ");
INSERT INTO boaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Áánélliihyéhjáa teene dibye éévehíjcyánetu úwááboobe dííbyeke ɨ́mɨáájú Jetsóodítyú íjcyáné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aamútsíhjyáa péhíjcyamútsí úújeté tsátsii nújpacyo íjcyátsihvu. Átsihvúhjáa diibye eonóócó néé Perípeke: —¡Éje, íchiíhya nújpacyo! ¿Aca tsá oke apáhajchíí u tsójtsóítyuróne? ");
INSERT INTO boaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Áánélliihyéhjáa Perípé néé dííbyeke: —Ihdyu tehdújuco ɨ́mɨááné u cáhcújtsóhajchííjyu. Áánélliihyéhjáa neébe: —Muurá ɨ́mɨááné ó cáhcujtsó Jetsocríjtó Píívyéébé Hajchi íjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Áánélliihyéhjáa Perípé néé dibye íijchíemɨ idyáíívyétsoki. Áámɨtúhjáa iñíítyéne peemútsí teene nújpácyó pañévú Perípé dííbyeke itsójtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Átsihdyúhjáa dityétsí íjchívyénáa Píívyéébé Apííchóré tsajtyéjucóó Perípeke. Áábekéhjáa tsáhájuco eonóócó ájtyúmɨtúne. Átsihdyúhjáa iiyéjuco dibye péhijcyáné tsaímijyúúre. ");
INSERT INTO boaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Áánáacáhjáa diibye Perípé Atsóótó cóómiyíjyuco. Aabéhjáa pacóómiváríyé úwááboobéré péhíjcyaabe úújeté Tsetsaréavu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ááné tujkéveríhjyáa Tsáoro lliihyánúllehíjcyá cahcújtso múnáake. Aabéhjáa péé llúúvájté avyéjúúbe éllevu waajácuháámɨ́ ityáúmeíki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aanéhjáa dibye ájcúháámɨma peebe Damájcori íjcyáné pihcyáávejááné avyéjujté éllevu néhcoobéré Críjtodítyú íjcyáné uwááboju úráávyehíjcyámeke Jerotsaréevu itsájtye wajpíímumáyé walléémuke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aabéhjáa téhullévú juuváyí péébe tsúúca técoomívú pɨ́ɨ́hɨ́rónáa dííbyedívú peete cádiivyé cáámetu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aanéhjáa dííbyeke baavu ɨ́jcaáyóóbeke Jetsóó dibye ájtyúmɨ́tuubéré nééhií: —¡Tsáoj, Tsááoroj! ¿Ɨ́veekíami oke ú pátsárícyohíjcyaj? ");
INSERT INTO boaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Áánélliihyéhjáa neébe: —¿Múha uu Ávyéjuúbej? Áánélliihyéhjáa neébe: —Oo Jetsóó oke u pátsárícyohíjcyaábe. Árónáa muurá uure ú tútávátsámeíhijcyá éhne múúne ócáji naatsóú íñúbɨ́jcóne iiye tútávájtsámeídyu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ááneríhjyáa Tsáoro íllityéébé úúvécunúúbéré nééhií: —Ávyéjuúbej, ¿aanéhaca ɨɨná ú imíllé o méénune? Áánélliihyéhjáa Jetsóó dibye ájtyúmɨ́tuubéré nééhií: —Wa ihdyu dipye kiávúhjané u péhullévu. Téhullévúi uke neeímyé ɨɨná u méénuíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ááneríhjyáa dííbyema pééme mítyane íllityé ditye ájtyúmɨ́tuubéré dííbyema íhjyúváneri. ");
INSERT INTO boaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Aabéhjáa baatu iíjyócúúvétsihdyu tsáhájuco hállúvatúne. Áábekéhjáa patóhcoríyéjuco ditye úújetétsóné teene Damájcovu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aabéhjáa téhulle pápihchúúj coojɨ́vá hállúvátuube íjcyaabe tsá majchóubáré, adóubáré, méénutúne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Áijyúhjáa tétsii tsaapi cahcújtso múnáajpi Ananíá íjcyáábedívú Jetsóó naavédú nééne ibóhówajcárótsihvu dilló dííbyeke. Áánélliihyéhjáa neébe: —¿Muhdúhaja, Ávyéjuúbej? ");
INSERT INTO boaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Áánélliihyéhjáa neebe dííbyeke: —Cáhawáá ‘Ɨ́mɨánéjcu’ némeíñé ulléjɨjtóvú pééne Jóóda ja dillo Táátsó múnáajpi ‘Tsáoro’ némeííbyekej. Muurá tééjari íjcyaabe pɨáábó táúmeíhijcyá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aabe téhdure naavédú nééne ɨɨ́ɨ́téné pañe ájtyumɨ́ dííbyé hallúvú díhyójtsɨcu u pícyoone dibye tsiiñe ihállúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ehdúhjáa Jetsóó néénéllii Ananíá nééhií: —Ávyéjuúbej, mítyame oke úúbállehíjcyá dibyévá Jerotsaréeri díuwááboju cáhcújtsómeke ímityúné méénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aabe muurá eene ííllevu tsáá llúúvájté avyéjujte nééjuri cahcújtso múnáake itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Árónáacáhjáa Jetsóó nééhií: —Wa ihdyu dipye dííbye éllevuj. Muurá téhdure óhdityu íjcyáné uwááboju úwááboobéré pehíjcyaá tsííñé iñújɨ́ɨ́ne múnáake íavyéjujtéhjɨmájuco. Áhdure ámuha imúnaa ijraéémuke úwáábóiíbye. ");
INSERT INTO boaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Áábeke ó waajácútsoó muhdú dibye tééné déjúcotu ɨ́cúbáhrámeíiñe. ");
INSERT INTO boaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ehdúhjáa Jetsóó néénéllii péjúcoobe Ananíá diibye Tsáoro íjcyajávu. Aabéhjáa tééjá pañévú iúcáávéne dííbyé hallúvú íhyójtsɨcu ipícyóóne néé dííbyeke: —Muúbej, Avyéjuube Jetsóó éhneváa juuváyí u tsáánáa úhdivu bóhówááveebe oke wallóó diéllevu uuva tsiiñe u hállúváábé pañévú Píívyéébé Apííchó iúcááveki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ehdúhjáa Ananíá néénemáyé íhyálluúúcú pañétú amóóbé mɨɨhédú nééne áákityéné boone hállúvájúcoóbe. Aabéhjáa ílluréjuco tsójtsótsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Átsihdyúhjáa botsíi imájchóne tsɨ́jpanúúbe. Aabéhjáa teene Damájcori íjcyáné cahcújtso múnáama múhdúj coojɨ́várá ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Átsihdyúhjáa tsúúca úwáábótujkénuube diityé pihcyáávejááné pañévu. Aabéhjáa nehíjcyá ɨ́mɨááné Jetsóó Píívyéébé Hajchi íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ááneríhjyáa pámeere iúllévenúne néjcatsíhi: —¿Acáa tsá áánu éhne cahcújtso múnáake ímityúné dárɨ́ɨ́vehíjcyatú Jerotsaréeri? Diibyéjuco muurá íñe ííllevu tsááne llúúvájté avyéjujté éllevu tsaatéké itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ehdúhjáa ditye néjcatsíyónáa éhníínevúré iúwáábóné pañe nehíjcyaabe ɨ́mɨááné diibyéjuco Jetsóó Críjto íjcyane. Ááneríhjyáa íllure tsájúréévétsoobe imúnaa jodíómuke teene Damájcori íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Átsihdyúhjáa diitye imúnaa íjcyarómé pítyácójcatsí dííbyeke illííhyánúroki. ");
INSERT INTO boaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Áánemáhjáa pécóhajchótá cójɨ́hajchótá téhmehíjcyarómé técoomí llehówááné dííbyeke illííhyánuki. Árónáacáhjáa waajácújúcoobe teéne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Áábekéhjáa cahcújtso múnaa úvérújtsí pañévú iúácóóbeke pejco niityétsó técoomí míhlletátú áachívújuco. Ehdúhjáa pállójcoobe Tsáoro ditye llííhyánúíyónetu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aabéhjáa Jerotsaréevu úújetéébé imíllerá iñáhbévájcatsíñé técoomíyí íjcyáné cahcújtso múnáama. Áróóbedíhjyáa íllure íllityéme. Tsáháikyéhjáa ditye wáájácutú dibye téhdure cáhcujtsójucóóné Jetsóoke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Áábekéhjáa Benabéé uwáábojté éllevu itsájtyéébedívú waajácutsó diityéké ímíñeúvu. Úúbálleebéhjáa diityéké muhdú Jetsóó juuváj pɨɨnévú dííbyedívú bóhówáávéébema iíhjyúvátsihdyu péébe dííbyedítyú íjcyáné uwááboju Damájco múnáake ɨ́ɨ́nerí íllityétuube úúbállehíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aabéhjáa Jerotsaréeri íjcyaabe diityémá úwááboobéré pehíjcyá tsijtye imúnaa cáhcújtsótúmeke ɨ́ɨ́nerí íllityétuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aanéhjáa tsaate imúnaa íjcyarómé gríéégómú ihjyúriyéjuco íhjyuvámé dííbyema ityáhjájcatsíñe lliihyánúllehíjcyá dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aanéhjáa íñahbéjté cahcújtso múnaa iwáájácúne tsajtyé dííbyeke Tsetsaréavu. Átsihdyúhjáa wallóómé dííbyeke Táátsóvuú. ");
INSERT INTO boaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Áijyúhjáa Jodéaa, Gariréaa, Tsamááriaa, íjcyáné iñújɨ́ɨ́neri íjcyáné cahcújtso múnaa tsaímiyéjuco íjcyane Píívyéébé Apííchóré diityéké pɨ́áábóneri. Aaméhjáa éhnííñevu llíyaatéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Téhduréhjáa Péédoro pahúlleváré ááhɨ́veebéré péhíjcyaabe úújeté Ríídári íjcyáné cahcújtso múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aabéhjáa téhulle ájtyúmɨté ‘Enéa’ némeííbyeke 8 pijcyábájuco íjpi vááúmeítyúneri chémehíjcyáábeke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Áábekéhjáa neébe: —Muúbej, tsúúca Jetsocríjtó uke bóhɨɨtsóhi. Ahdícyane dácúúvéne ílluréjuco dicyúwá dímibájcho. Ahdújucóhjáa dibye téijyúré ácuuvéne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aanéhjáa Ríídaá, Tsaróoo, íjcyácoomícyu múnaa iájtyúmɨ́ne muhdúhjáa iícyahíjcyanéhjɨ́ ɨɨ́hvéjtsóne Jetsóokéréjuco cáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Téijyúhjáa íjcyalle cahcújtso múnáalle Jóópéri Tabítá gríéégómú ihjyúrí ‘Dóócaá’ némeílle. Aalléhjáa ávyétá ɨ́mɨáállé íjcyalle pɨ́áábohíjcyá ɨ́dáátsóméhjɨke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aalléhjáa téijyu chémelle dsɨ́jɨvéhi. Áálleúvukéhjáa iñíjtyúne picyóómé cáámééɨ́jɨri íjcyáné mɨ́jcóhó pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Áijyúhjáa diibye Péédoro íjcyacóómí Ríída pɨ́hɨ́ré teene Jóópétuú. Aanéhjáa cahcújtso múnaa dibye kiá íjcyane iwáájácúne wallóó míítyétsikye dííbye éllevu. Aamútsíhjyáa neeté dííbyeke: —Uuva ú peé ɨ́ɨ́cúi múúha éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ahdújucóhjáa dibye pééne diityétsimájuco técoomívu. Aabéhjáa úújetéébeke tsajtyémé teene mɨ́jcóhó pañévú kiá tééhoúvú íjcyáhullévu. Áánáacáhjáa tétsihyi pííbájyujte walléémú máátyóri íjcyame úújétsópejtsó dííbyeke dílleúvúhjáa dsɨ́cohíjcyáné wajyámuunévu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ááné boonétúhjáa pámeekéré áachívú iíjchívyétsóne Píívyéébema ihjyúvaabe ɨmɨ́móúúvénema. Aabéhjáa díílleúvudívú ɨ́ɨ́teebéré nééhií: —Tabítaj, múúhama dacúúve. Ehdúhjáa dibye néénemáyé ɨɨtéjúcoólle. Aalléhjáa dííbyeke iájtyúmɨ́ne tsúúca ácuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Áállekéhjáa íhyójtsɨ́cutu iékéévéne íjyócujcároóbe. Áánemáhjáa cahcújtso múnáama pííbájyujtéké ɨpɨ́úváne úújétsoobe tsúúca bóhɨ́ɨ́lledívu. ");
INSERT INTO boaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aanéhjáa teene Jóópé múnaa mítyame iwáájácúne cáhcujtsó Jetsóoke. ");
INSERT INTO boaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Átsihdyúhjáa Péédoro coéváhíi tsúcájá técoomívú ‘mɨ́ɨ́héné ímibájchoóbe’ némeííbyé Tsimóo jávu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Íjcyaabéhjáa Tsetsaréari ‘Conéério’ némeííbyé tsáha múnaa ‘Itariáno’ némeíñé tsodáhómú avyéjuube íjcyaábe. ");
INSERT INTO boaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aabéhjáa paíjyuváré Píívyéébeke pɨáábó ityáúmeíñe ícyahíjcyá muhdú dibye ímillédu. Pámeemáyéhjáa ihyájkímuma duurúvahíjcyámé dííbyeke. Áhduréhjáa jodíómuke pɨ́áábohíjcyaabe panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aabéhjáa tsájcuuve naavédú nééne ɨɨ́ɨ́téné pañe ájtyumɨ́ níjkyéjɨ múnáajpi dííbye éllevu tsááneé. ");
INSERT INTO boaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Aabéhjáa dííbyeke díllónéllii íllityécunúúbéré dííbyedívú ɨ́ɨ́teebéré nééhií: —¿Muhdúhaja, Ávyéjuúbej? Áánélliihyéhjáa neébe: —Muurá Píívyéébe ímí ɨjtsúcunú pɨáábó dííbyeke u táúmeíhijcyáne. Áhdure ímí ɨjtsúcunúúbé ɨ́dáátsóméhjɨke u pɨ́áábohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ahdícyane Jóópévu tsaatéké wallo ditye iújcuté Tsimóoke dííbyere ‘Péédoro’ némeííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Téhulle muurá diibye tsijpi Tsimóó ‘mɨ́ɨ́héné ímibájchoóbe’ némeííbye ja únéú úníuri íjcyájari. Diibye uke neé ɨɨná u méénuíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ehdúhjáa níjkyéjɨ múnáajpi Conééríoke iñééne pééné boone pɨ́úvaabe míítyétsi íúníu múnáajtétsikye. Áhduréhjáa pɨ́úvaabe tsaapi tsodáhó ímí Píívyéébeke úráávyehíjcyáábeke ityújkevéélléébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Áámekéhjáa ímíñeúvú iúúbálléne wálloobe teene Jóópévu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aaméhjáa péhijcyámé tsíijyu tsúúca técoomíj pɨɨhɨ́ríjyuco íjcyánáa Péédoro nériivyé já hallúvú Píívyéébema iíhjyúva cójɨ́jpɨɨnéjuco íjcyáíñáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Téijyúhjáa mítyane ajyábáávatéébe. Áábemáhjáa ditye majcho méénúné hajchótá tétsii íjcyáábedívú naavédú nééne bóhówaavéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ááné pañéhjáa ájtyúmɨɨbe cáámetu wájyámúbácobádú nééne téjtyóhjɨtu dóhjɨváné dííbyedívú níítyene. ");
INSERT INTO boaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Áhbácóbá pañéhjáa pañévámé pamévá jodíómú dóótúné iyáme. ");
INSERT INTO boaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Áámedívúhjáa dibye úllévenúrónáa Píívyéébe dííbyeke nééhií: —Aatyédítyú bo tsaatéké llííhyánúmeke tsájtyéne didyoj. ");
INSERT INTO boaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Árónáacáhjáa neébe: —Tsáha, Avyéjuúbej, tehdúi múijyú ehdɨ́ɨ́váméhjɨke o dóónejɨ́ɨ́ doorátujtéke. ");
INSERT INTO boaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Árónáacáhjáa neebe dííbyeke: —¿Ɨ́veekí doorátujtédívú ú meménú ɨ́mɨáámé íjcyámeke? ");
INSERT INTO boaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ehdúhjáa dííbyeke Píívyéébe néé pápihchúúijyúva. Ááné boonéhjáa tsiiñe piéhullévúré pééne cáámevu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ááneríhjyáa dibye ɨ́tsámeíhíjcyánáa tsúúca llééhowávú wajtsɨ́jucóómé Conééríó walló múnaa dibye íjcyaja dílloméré péhijcyáme. ");
INSERT INTO boaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Aaméhjáa dilló tééjari dibye íjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aabéhjáa tééné ɨ́jtsaméiyíyéi íjcyánáa tsiiñe Píívyéébé Apííchó néé dííbyeke: —Pápihchúúmeva uke nehcóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Diityémá peeco ɨɨná néétuubére. Muurá oore ó wallóó diityéké diéllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ahdújucóhjáa dibye diityé éllevu ipyééne nééneé: —¿A oke ámuha ménehcóhi? ¿Aca muhdú néénéllii ímichi ámuha metsáá taéllevu? ");
INSERT INTO boaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Áánélliihyéhjáa nééme dííbyeke: —Ihdyu muha metsáá tsodáhómú avyéjuube Conéério ɨ́mɨáábé Píívyéébe ímillédú ícyahíjcyáábeke ámúha múnaa jodíómú ímí ɨ́tsúcunúhíjcyaabe nééjuri. Dííbyekéváa níjkyéjɨ múnáajpi néé dííbye jávú u pééne dííbyema u íhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ehdúhjáa ditye néénéllii Péédoro diityéké néé dityéi icyúwa tépejco tétsii. Átsihdyúhjáa botsíi tsíjcyoojɨ diityémá péébeke tsaate cahcújtso múnaa nahbénúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aaméhjáa tsíijyu úújeté Tsetsaréavu eenée Conéério ihyájkímuma íñahbévajtéké ɨpɨ́úvámema dííbyeke téhmehíjcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aanéhjáa Péédoro dííbye jávú ááhɨ́véíyóné ɨhdéré iíjchívyeíñúne dííbyé úmɨwávú mɨ́móúúvetéébé dííbyeke idyúúrúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Árónáacáhjáa Péédoro dííbyeke nééhií: —Díjyocúúve. Muurá úhdure oo mɨ́amúnáajpi. ");
INSERT INTO boaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ehdúhjáa dííbyema íhjyúvaabéré tééjá pañévú úcááveebe úújeté mítyane mɨ́amúnaa tétsihvu píhcyáávémedívu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Áámekéhjáa neébe: —Amuúhaj, muurá ámuha méwaajácú tsá múijyú jodíómuube tsííñé iiñújɨ múnáájpiima iñáhbévájcatsíñe dííbyé já pañévú úcáávéítyuróne. Árónáa Píívyéébe oke néé tsaatéké átéréejtédí o díllótuki. ");
INSERT INTO boaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ahdújuco muurá íñe o tsááne ‘tsiíjyu’ néétuubéré oke ámuha mepɨ́úvánélliíhye. Aane ícyooca ó imíllé o wáájacúné muhdú néénéllii ímichi ámuha oke mepɨ́uváne. ");
INSERT INTO boaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Áánélliihyéhjáa Conéério néé dííbyeke: —Ícyoocáa cuuve íchihyi tahjyárí májchótuube Píívyéébema o íhjyúvahíjcyáábedívú tsaapi óhdivu bóhówaavé ávyeta íwajyámú áchaúcunúúbe. Áánetu tsúúca mee pɨ́ɨ́néehójtsɨ́j coojɨ́vájuco. ");
INSERT INTO boaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aabée oke nééhií: “Píívyéébe muurá lleebó dííbyema u íhjyúvahíjcyáne. Téhdure ímí ɨ́jtsúcunúúbé ɨ́dáátsóméhjɨke u pɨ́áábohíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Áánéllii wallo tsaatéké Jóópévu ditye iújcuté Tsimóoke dííbyere ‘Péédoro’ némeííbyeke. Téhulle muurá diibye tsijpi Tsimóó ‘mɨ́ɨ́héné ímibájchoóbe’ némeííbye ja únéú úníuri íjcyájari. Aabe ihdyu óvíi itsáácooca úúma ihjyúváhi.” ");
INSERT INTO boaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ehdúu oke dibye néénéllii diéllevu ó wallóó uke ditye iújcutéki. Aabe ihdyu tehdújuco u tsááne ímí tsame meíjcya Píívyéébema. Aane ícyooca muha méimíllé Píívyéébée uke níwaavéné múúhakye u úúballéne. ");
INSERT INTO boaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Áánélliihyéhjáa Péédoro nééhií: —Ícyooca ihdyu ɨ́mɨááné ó waajácú Píívyéébe pámeekéré tsahdúré wájyune. ");
INSERT INTO boaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Muurá tsííñé iñújɨ́ɨ́ne múnáadítyú múhdumé dibye ímillédú íjcyámeke ímí ɨjtsúcunúúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muuráhjáa tsúúcajátújuco dííbyere Píívyéébe muuha ijraéémú ɨhdéejtéúvuke néhijcyáné tsaímíyé dííbyema meíjcyáíñé uwááboju mééma íjcyaíñé pámé Avyéjuubéré íjcyaabe Jetsocríjtoj tééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aane muurá ámuha páneere méwaajácú muhdúhjáa múúhá iiñújɨ́ Gariréatu tene tújkeváné éhnée Jóááuvu iúwáábóne tsótsohíjcyáné boonétu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Muuráhjáa Jetsóó Natsarée múnáajpi íjcyáábé pañévú Píívyéébe Íapííchó picyóó dibye tééné ɨhnáhoori ibóhɨ́ɨ́tsohíjcya naavéné túkevéjtsójú pañe íjcyame ɨ́cúbáhrámeíhíjcyámeke. Ehdúu muurá ɨ́mɨáánéjuco dibye méénuhíjcyáné Píívyéébe dííbyema íjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aane muurá muha méwaajácú páneere muhdúhjáa dibye méénuhíjcyáné Jodéá iiñújɨrii, Jerotsaréerii, íjcyane. Ááné boonétúu dííbyeke lliihyánúmé páwachékevu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Áróóbekée Píívyéébe 3 coojɨ́vatu tsiiñe ibóhɨ́ɨ́tsóóbeke bóhówajcáró múúhadívu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Árónáacáa tsá pamévadívúré dibye bóhówáávetúne. Muuráhjáa ihdyu tsúúcajátújuco Píívyéébe múúhakye dííbyé uubállé muha meméénúímyeke méménúmedívúré bóhówááveébe. Áábemáa muurá muha mémajchóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Áijyúu múúhakye níwááveíñuube muha meúwáábo ɨ́mɨáájú pámeekéré mɨ́amúnáake. Áhdurée neebe muha meúúbálle Píívyéébée dííbyeke néhdújuco pámeere dsɨ́jɨvéjúcóóróméhjɨma muhdú ditye ícyahíjcyáné dibye ímíbájchoíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Téhduréhjáa muurá tsúúcajátújuco Píívyéébé ihjyú uubálle múnaa néhijcyáné dííbyeke cáhcújtsómé imítyuháñé ábájɨ́ɨ́vémeíiñe. Ehdúhjáa neebe Péédoro. ");
INSERT INTO boaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Aabéhjáa íuwáábó pɨ́néévénáa tsúúca Píívyéébé Apííchó úcaavé pámeere múhdumé dibye úwaabóné cáhcújtsómé pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ááneríhjyáa imúnaa dííbyemáa pééme ullévenú jodíómú íjcyátúrómé pañévú Píívyéébé Apííchó úcáávéneri. ");
INSERT INTO boaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Aaméhjáa lleebúcunú Píívyéébeke ditye dúúruváné tsíjtyéhjɨ́ ihjyúháñé iwáájácútúrójúhjɨri. ");
INSERT INTO boaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Áámekéhjáa neebe Péédoro: —Tsúúca muurá diityé pañe ijcyáné Píívyéébé Apííchó íñe mépañe iíjcyadu. Áánéllii tsúúca piivyétémé itsójtsótsámeíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ehdúhjáa iñééne neebe ílluréjuco ditye itsójtsótsámeí dííbyedívú Jetsocríjto mémeri. Áábekéhjáa nééme dibyéi diityémá iíjcya tsuucájááneúvu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aanéhjáa Jodéari íjcyáné uwáábojtémá tsijtye cahcújtso múnaa waajácújucóó jodíómú íjcyáturómé tsúúca Píívyéébé uwááboju cáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Áánáacáhjáa Péédoro oomíjyucóó Jerotsaréevu. Áábedítyúhjáa tsaate cahcújtso múnaa íjcyájúcoorómé ɨ́hdééné taúhbaju úraavyémé ihjyúvahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Aaméhjáa néé dííbyeke: —¿Acáa ɨ́veekí memúnaa jodíómú íjcyátúmeke ááhɨ́veebéré u péébe diityémá ú máchohíjcyáhi? ");
INSERT INTO boaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Áánélliihyéhjáa úúbálleebe páneere ídyéjúcotu muhdúhjáa dííbyema tene pájtyene. ");
INSERT INTO boaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Neebéhjápeé: —Muuráhjáa ihdyu Jóópéri o íjcyaabe Píívyéébema o íhjyúvahíjcyánáa óhdivu naavédú nééne bóhówáávéné pañe ó ájtyumɨ́ wájyámúbácobádú nééne téjtyóhjɨtu dóhjɨváné cáámetu óhdivu níítyene. ");
INSERT INTO boaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Áánevúu o úllévenúróne botsíi ímíñeúvú o ɨ́ɨ́teebe ó ájtyumɨ́ tééné pañe pamévá iyámé doorátujte íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Áámedívúu o ɨ́ɨ́tehíjcyárónáa Píívyéébe oke nééhií: “Aatyédítyú bo tsaatéké llííhyánúmeke tsájtyéne didyoj.” ");
INSERT INTO boaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Árónáacáa o nééhií: “Tsáha, Ávyéjuúbej, tehdúi múijyú ehdɨ́ɨ́váméhjɨke o dóónejɨ́ɨ́ doorátujtéke.” ");
INSERT INTO boaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Áánélliihyée oke neébe: “¿Ɨ́veekí doorátujtédívú ú mémenúné ɨ́mɨáámé íjcyámeke?” ");
INSERT INTO boaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ehdúu oke pápihchúúijyúvá dibye nééné boone piéhullévúré pééne cáámevu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ááné tujkéveríhjyáa tsúúca o íjcyajávú wajtsɨ́jucóómé pápihchúúmeva Tsetsaréatu ditye taéllevu wálloóme. ");
INSERT INTO boaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Áámemájucóo o pééne Píívyéébé Apííchóré oke túkévéjtsóneri ɨɨná néétuubére. Áábemájucóo idyé íjtye 6-meva óóma úújeténé oke pɨ́úváábe jávu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aabée múúhakye úúballé níjkyéjɨ múnáajpíváa idyé dííbyedívú ihjyávú ibóhówáávéne dííbyeke nééneé: “Jóópévu tsaatéké wallo ditye iújcuté Tsimóoke dííbyere ‘Péédoro’ némeííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Diibye ihdyu uke neé muhdú ámuha dihyájkímuma mewágóóóvéíyónetu mepájtyetéiñe.” Ehdúu múúhakye úúbálleébe. ");
INSERT INTO boaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ááné boonétúu diityéké o úwáábómé pañévú Píívyéébé Apííchó úcaavé éhnée mépañévú iúcaavédu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Téijyúu ó ɨ́tsaavé éhnée Ávyéjuube Jetsóó íllu nééneé: “Ɨ́mɨáánéjucóo Jóáa tsótsohíjcyáné nújpácyori. Áánetu ihdyu ámúhá pañévú Píívyéébé Apííchó úcááveéhi.” Ehdúu Jetsóó nééne ó ɨ́tsaavé téénetu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Muuráhjáa dííbyeke ditye cáhcújtsónéllii Píívyéébé Apííchó diityé pañévú úcaavé éhnée mépañévú iúcaavédu. Ehdúu Píívyéébe iímillédú méénune tehdu muhdú o méénúíyónejɨ́ɨ́vari. ");
INSERT INTO boaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ehdúhjáa Péédoro Jerotsaréeri íjcyáné cahcújtso múnáake néénéllii tsáhájuco ɨɨná ditye néétú dííbyeke. Aaméhjáa Píívyéébeke dúúruvámé nééhií: —Píívyéébéhaca téhdure jodíómú íjcyátúrómeke wajyúhi. Muurá eene muhdúhjáa iícyahíjcyáné ɨɨ́hvéjtsóne ɨ́mɨánejcúvú pajtyémé múijyú ɨdsɨ́jɨvéjúcóóítyúne bóhɨ́ iújcuki. Ehdúhjáa nééme Jerotsaréeri íjcyáné cahcújtso múnaa. ");
INSERT INTO boaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Muuráhjáa Ejtéébaúvuke ditye dsɨ́jɨ́vétsóné boone téhdure tsijtye cahcújtso múnáake ímityúné dárɨɨvéme. Áánetúhjáa tsaate wáá Peníítsiávuu, ‘Chíípere’ némeíñé caapáhovuu, Ajtiokííavuu, íjcyane. Aaméhjáa téhulle úwáábohíjcyá Críjtodítyú íjcyáné uwááboju apáámyekéré imúnaa jodíómuke. Tsáháhjáa tsíjtyeke ditye úwáábohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Árónáacáhjáa tsijtye Chííperétú tsááné cahcújtso múnáama Tsirééne múnaa Ajtiokííavu wájtsɨme úwaabóvá jodíómú íjcyátúrómeke. ");
INSERT INTO boaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Áámekéhjáa Píívyéébe pɨ́aabómé muhdú iícyahíjcyanéhjɨ́ ɨɨ́hvéjtsóne dííbyekéréjuco cáhcujtsóne. ");
INSERT INTO boaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Aanéhjáa Jerotsaréeri íjcyáné cahcújtso múnaa iwáájácúne wallóó Benabéeke téhullévu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Aabéhjáa téhullévú úújetéébé waajácú muhdú ɨ́mɨááné Píívyéébe diityéké pɨ́aabóne. Ááneríhjyáa mítyane ímíjyúúveebe diityéké túkévétsohíjcyá ditye ímíñeúvú Jetsóoke iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ehdúhjáa diityéké neebe ímí Píívyéébe cáhcújtsóóbeke dííbyé Apííchó túkévétsohíjcyaábe. Aabéhjáa úwáábóneri tsijtye cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Átsihdyúhjáa Táátsóvu peebe Tsáoró néhcovu. Áábekéhjáa téhullétú iújcújéébema tsiiñe óómimútsí Ajtiokííavu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aamútsíhjyáa tétsíí cahcújtso múnáama tsáné pijcyábá íjcyamútsí úwáábohíjcyá diityéke. Áijyúhjáa botsíi cahcújtso múnáake dillómé ‘Crijtiánómudi’ Críjtó uráávye múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Áánáacáhjáa uwáábojtédítyú tsaate Píívyéébé ihjyú uubálle múnaa íjcyame péé Jerotsaréetu Ajtiokííavu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Áámedítyúhjáa ‘Agáábo’ némeííbyé diityéj pɨɨnévú iíjyócúúvéne néé ájyaba íjcyaíñé ííñújɨri Píívyéébé Apííchó túkévéjtsóneri iwáájacúne. Ahdújucóhjáa tene íjcyane Cáráóódio ávyéjuube íjcyáijyu. ");
INSERT INTO boaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Áánélliihyéhjáa Ajtiokííari íjcyáné cahcújtso múnaa ɨ́jtsámeí muhdú tsáápiitsa ɨpɨ́ááboíñé Jodéari íjcyáné cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ahdújucóhjáa ditye méénune. Áánemáhjáa diityétsí Benabéemútsikye Tsáorómá wallóómé téhulle íjcyáné cahcújtso múnáá túkevéjtsojté éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Áijyúhjáa ávyéjuube Heróódé ímityúné dárɨɨvé tsaate cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Diibyéhjáa muurá nééjuri Jóáá nahbe Jacóóboke lliihyánúmé icyáváájcóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aanéhjáa ímí pajtyé imúnaa jodíómú Jetsóoke cáhcujtsótúmeke. Átsihdyúhjáa neebe Péédorókeréjuco ditye iékééveki. Ehdúhjáa meenúmé pajtyété wañéhjɨ́ pañe óórítyúne pááá máchómeíhíjcyáijyu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Áábekéhjáa icyúvéhoojánúúbedívú téhmétsoobe tsodáhómú 16-meva íjcyámeke ditye ityéhme pɨ́ɨ́néehójtsɨ́mevátsáhjɨdi. Áánemáhjáa ɨ́jtsámeííbyé tééné pajtyétavúi iíjchívyétsóóbedívú iúújétsoíñé tsíjtyeke ditye muhdú iñéékií. ");
INSERT INTO boaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Áábé hallúvúhjáa cahcújtso múnaa pɨáábó táúmeíhijcyá Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Aanéhjáa tsɨtsɨ́ɨ́vevu diibye Heróódé dííbyedívú tsíjtyeke úújétsóíyo péjcó cúwaabe panéjcuváácutu úwááñéhityu tsodáhomútsidítyú dóhjɨ́vaábe. Áánetúhjáa tsijtye imyéénuhíjcyádú téhmé péjcové tééjá lleehówa. ");
INSERT INTO boaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Árónáacáhjáa níjkyéjɨ múnáajpi dííbyedívú úújetéébedítyú peete cádiúcunú páneere teene cúvéhóójá pañe. Aabéhjáa dííbyeke cávíhyiñú ‘muúbe, dájkyeé’ néébere. Ehdúhjáa dibye néénemáyé úwááñehi córɨ́ɨ́veíñú dííbyé hótsɨ́jkejɨ́ɨ́cutu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Áábekéhjáa neebe dibye íwajyámúúné iímíbájkímyeíñe íjtyúhápaajɨ́nevu iújcámeíki. Ahdújucóhjáa ímíbájkímyeííbyeke neébe: —Ayúwa díwajyámú hállúejávú dávóóveíñúne dicha tadyéjurij. ");
INSERT INTO boaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ahdújucóhjáa dííbye déjutu péébe ɨjtsúcunú ɨ́mɨááné íjcyátúneúvúdu. Ɨjtsúcunúúbéhjáa naavédú néénere ɨɨ́ɨ́téné pañe iájtyumɨ́ne. ");
INSERT INTO boaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Árónáacáhjáa tsúúca pajtyémútsí tujkénúetsíii, hallúvúetsíii, téhmehíjcyámútsikye. Átsihdyúhjáa úújetémútsí ulléjɨjtóvuréjuco meíjchívyéné lleehówá úwáñewáánetu méénúmeíwavu. Aawáhjáa iiye diityétsima páyúúvénetu íjchívyemútsí tsamútsíi peerá teene ulléjɨ́jtori diibye níjkyéjɨ múnáájpiíma. Aabéhjáa tétsihdyu ílluréjuco dííbyedítyú pééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Átsihvúhjáa botsíi ɨ́mɨááné íjcyane iwáájácúne neébe: —¿Aca muhdú íñe ɨ́mɨááné Píívyéébe níjkyéjɨ múnáájpikye taéllevu wallóó oke dibye ipájtyetétso Heróódé hójtsɨ́ pañétu? Áhdure oke pájtyetétsoobe tamúnaa íjcyarómé oke iímillédú méénúíyónetu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ehdúhjáa nééneri ɨ́jtsámeííbyéré péé Jóáa dííbyere ‘Máácoó’ némeííbyéj tsɨɨju Maaría jávu. Áijyúhjáa tééjavu cahcújtso múnaa ipíhcyáávéne Píívyéébema ihjyúvahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Áánáacáhjáa llééhówatu áachí éhnéjcutu díllohíjcyaabe diityéke. Áánélliihyéhjáa bádsɨ́jcaja ‘Róódeé’ némeíllé iíjchívyeíñúne úújeté múha íjcyane iwáájácuki. ");
INSERT INTO boaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aalléhjáa Péédorój ké illéébóne mítyane ímíjyuuvéhi. Áánemáhjáa dííbyekéi pááyúcútulléré ɨ́ɨ́cúi tsiiñe ióómíñe úúbálleté diityéke. ");
INSERT INTO boaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Árónáacáhjáa díílleke népejtsóme: —Ílluréubá ú meívatéhi. Tsáháubá diibye íjcyatúne. Níjkyéjɨ múnáajpíyéubá dííbyé uubállema tsáábeke ú nééhií. ");
INSERT INTO boaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Áánáacáhjáa Péédoro éhnííñevúré díllohíjcyá llééhówatu. Áábekéhjáa botsíi ipááyúcúúbedi mítyane ullévenúme. ");
INSERT INTO boaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Áámekéhjáa íhyójtsɨríyé neebe ditye cúúvéhulléré iíjcyaki. Átsihdyúhjáa úúbálleebe diityéké muhdú Píívyéébe dííbyeke cúvéhóójatu íjchívyetsóne. Átsihdyúhjáa neebe diityéke: —Aane tsáma méúúbálleco Jacóóboke tsijtye cahcújtso múnáama. Ehdúhjáa iñééne tsiéllevúréjuco dibye pééne diityédítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aanéhjáa tsɨtsɨ́ɨ́vevu tsodáhómú eenée dííbyeke téhmehíjcyámé úvánujcátsí múhdutú kiávú dibye pééneri. ");
INSERT INTO boaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ááme éllevúhjáa diibye Heróódé wallóó tsaatéké ditye teene cúvehóójá iúújeté dííbyeke. Aaméhjáa ájtyúmɨ́túnéllii ímíñeúvú diitye tehmé múnáake idíllóróne ílluréjuco dibye llííhyánutsóné diityédívu. Áánemáhjáa teene Jodéá iiñújɨtu peebe Tsetsaréavu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Aabéhjáa tsaríllehíjcyá Tííróma Tsidóó coomícyu múnáake. Ároméhjáa dííbyé iiñújɨtúré majcho iúcuhíjcyánéllii imíllé dibye diityémá ímíjyuuvéne. Áánélliihyéhjáa tsaméhjɨ́ ímíñeúvú ipítyácójcatsíñe péé dííbyé pɨááboobe Bárájto éllevu. Áábekéhjáa nééme dibye Heróódeke iñéé dibye diityémá iímíjyúúveki. Aanéhjáa ímí ɨɨ́jtsúcunúnéllii neetéébé dííbyeke dibye diityémá iímíjyúúveki. ");
INSERT INTO boaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Áánélliihyéhjáa diityéké ééveebe kéjcoojɨ́ diityémá iíhjyúvaíñe. Ájcoojɨ́hjáa úújetédú íavyéjú wajyámuvu iúcáávéne íavyéjú ijyáwá hallúvú ácúúveebe diityémá iíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ááneréjucóhjáa tsaate kéévánécoba nééneé: —Aabye muurá eene íhjyúvaabéubá tsá mɨ́amúnáajpi íjcyatúne. ¡Píívyééberéubá diíbye! ");
INSERT INTO boaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ehdúhjáa ditye néénemáyé níjkyéjɨ múnáajpi Heróódeke baavu ɨɨ́jcaáyóóbeke chémetsóhi. Aabéhjáa ílluréjuco dsɨ́jɨvéné iúúvaténeri. Ehdúhjáa dííbyeke pajtyéné ɨ́veekí Píívyéébeke ávyéjújtsotúmé mɨ́amúnaa dííbyekéré ávyéjujtsóné ímí dibye ɨ́jtsúcunúné déjúcotu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Áijyúhjáa Píívyéébé uwááboju éhnííñevu tsújaavé pahúllevá múnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Áánetúhjáa Benabéemútsí Tsáorómá oomíjyucóó Ajtiokííavu tétsíí cahcújtso múnaa Jerotsaréeri íjcyáné cahcújtso múnáake pɨ́áábóne dsɨ́ɨ́dsɨdívú diityéké iájcújétsihdyu. Aamútsíhjyáa tsajtyé Jóááke dííbyere ‘Máácoó’ némeííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Áijyúhjáa Ajtiokííari íjcyáné cahcújtso múnáama ijcyámé Píívyéébé ihjyú uwáábojte ílluúme: Diibye Benabéee, Tsimóó dííbyere ‘Cúúvéébeé’ némeííbyee, Tsirééne múnáajpi Róótsioo, Manaéé Gariréá iiñújɨ́ avyéjuube íjcyaabéhjáa Heróódema tsaíjyú píívyeébee, Tsáoroo, éhdume. Áámedítyúhjáa tsaate úwáábohíjcyá Jetsóoke cáhcújtsótúmeke. Áánetúhjáa tsijtye úwáábohíjcyá tsúúca dííbyeke cáhcújtsómeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Aaméhjáa tsájcoojɨ májchotúmé Píívyéébeke dúúrúvámeke dííbyé Apííchó nééhií: —Óóma mémeménú Benabéemútsikye Tsáorómá tsúúcajátújucóo diityétsidyítyú o ɨ́jtsámeíñé wákimyéí diityétsí imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ahdújucóhjáa diityétsí hallúvú íhyótsɨne ipícyóóne ditye táúmeíñé pɨáábó Píívyéébeke. Átsihdyúhjáa ipítyájcómútsikye ílluréjuco ditye wálloóne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aamútsíhjyáa Píívyéébé Apííchó túkévéjtsóneri péé Tsereóótsiávu. Átsihdyúhjáa tsahííyí peemútsí ‘Chíípere’ némeíñé caapáhovu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Aamútsíhjyáa ‘Tsaramína’ némeí mujcóvú úújetémútsí úwaabójucóó Píívyéébé ihjyu imúnaa jodíómú pihcyáávejááné pañévu. Áámútsimáhjáa ɨ́pɨááboobe Jóáa péé dííbyere ‘Máácoó’ némeííbye. ");
INSERT INTO boaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aaméhjáa teene caapáhori péhijcyámé Páápó coomívú úújetémé tétsii ájtyumɨ́ tsaapi imúnáajpi Bajetsóoke ápííchoobe íjcyáábeke. Diibyéhjáa íllure iállíñe nehíjcyá Píívyéébé icyánéjcú uubállé imyéénuhíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Aabéhjáa ícyahíjcyá ávyéjuube Tsééjio Páorómá ímí dííbyema iñáhbévácatsíhíjcyánélliíhye. Diibyéhjáa ávyéjuube pɨ́uvá Benabéemútsikye Píívyéébé uwááboju illéébúcunúné iímíllenélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aamútsíhjyáa dííbyeke úwáábórónáa diibye ápííchoobe dííbyere ‘Erííma’ némeííbyé tsá ímílletú dibye cáhcujtsóné Píívyéébé ihjyu. Áánemáhjáa íllure téénetu bóíjcyuube dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Áánélliihyéhjáa Tsáoro dííbyere Páávoro íjcyáábé pañe Píívyéébé Apííchó íjcyaabe dííbyedívú ɨɨ́ɨ́téne nééhií: —Muúbej, uu muurá állíu múnáajpi Naavénéj tsɨɨméné u íjcyaabe átéréejpi. ");
INSERT INTO boaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Aabe ¿múijyúikyé ú ɨ́hvéteé eene Ávyéjúúbedítyú íjcyáné uwááboju ɨ́mɨáájú u tútávátsohíjcyánetu? ");
INSERT INTO boaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ahdícyane ícyooca Píívyéébere nééjuri tsáhájuco u hállúváityúne. Ehdúhjáa dibye néénemáyé tsáhájuco dibye állúvatúne. Áánemáhjáa tsaatéké neebe ditye itsájtye dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Aanéhjáa ávyéjuube Tsééjio Páoro iájtyúmɨ́ne ílluréjuco cáhcujtsóné Píívyéébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Átsihdyúhjáa Páávoro íñahbénujtétsima Páápótu péé tsahííyí Pajpííriá iiñújɨri íjcyacóómí Pééjévuú. Áámútsidítyúhjáa tétsihdyu Jóáa oomí Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ááné boonéhjáa iiyéjuco péémutsi úújeté Ajtiokííavu Pitsíídiá iiñújɨri íjcyácoomívu. Aamútsíhjyáa téhulle wáyeéévejcóójɨ́ íjcyamútsí péé imúnáá pihcyáávejávu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Áánáacáhjáa tééjá avyéjujte Píívyéébé ihjyu iéévene ɨnɨ́jkevádú néé tsaatéké ditye idíllo dityétsí íhjyúváíhajchííjyu. Áánélliihyéhjáa nééme diityétsikye: —¿Ava tsá ámúhtsidi tsáné túkevéjtsoju íjcyatú múúhakye ámuhtsi menééiyóne? Tenévá íjcyáhajchíí múúhakye mene. ");
INSERT INTO boaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Áánélliihyéhjáa diibye Páávoro iíjyócúúvéne íhyójtsɨri néé ditye cúúvéhulléré iíjcyaki. Átsihdyúhjáa neebe diityéke: —Ámuúha tamúnaa ijraéémuj, cáhawáá ímíñeúvú mélleebúcunu ámúhakye o nééiñe íñe múhdumé Píívyéébeke ámuha maávyejúúllémeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Muuráhjáa méɨhdé múnáaúvú Piivyéébé idyé íjcyaabe ihñéjté Ejíhtó iiñújɨri íjcyámeke llíyaatétsó diityékée iñéhdújuco. Áámekéhjáa muurá ɨ́ɨhnáhoori ijchívyétsoobe tééné iiñújɨtu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aaméhjáa múhdurá ícyahíjcyáronéhjɨ́ iáábúcúne diityéké pɨ́áábohíjcyaabe panévatúré 40 píjcyá hajchótá ditye ɨ́ɨ́néubárá píívyétúné iiñújɨri ijcyácoóca. ");
INSERT INTO boaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ááné boonéhjáa Canaáá iiñújɨvúréjuco péémeke idyé dibye pɨ́áábónej tééveríyé táhjahíjcyámé 7 coomíva múnaa tééné iiñújɨri íjcyámeke. Diityékéhjáa ibóáyóné boone iiyéjuco ditye cáávácuhíjcyáné diityé iñújɨ́ɨ́ne. Ehdúhjáa muurá méénuhíjcyámé Píívyéébé pɨááboríye. ");
INSERT INTO boaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Áámekéhjáa túkévétsohíjcyaabe ímítyúnéhjɨ́ ímibájcho múnáaj tééveri 450 píjcyá hajchótá íhjyú uubálle múnáajpi Tsamoéeréjuco íjcyájcoojɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aaméhjáa idyé táúmeí Píívyéébeke dibye imyéménu tsáápiikye diityé avyéjuube íjcyáííbyeke dibye diityéké ityúkévéjtsoki. Ahdújucóhjáa dibye mémenúné ‘Bejamíi’ némeíñé dohjɨ́ba múnáajpi Tsíí hajchi Tsaóoke dibye iíjcya ávyéjuube 40 píjcyá hajchóta. ");
INSERT INTO boaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Áábekéhjáa iíjchívyétsóné boone Dabíikyéréjuco dibye tsiiñe pícyoone diityé avyéjuube dibye iíjcyaki. Dííbyedítyúhjáa muurá neébe: “Ópée o tújkevéélléébeke ó ájtyumɨ́ Itsaíí hajchi Dabíikye.” ");
INSERT INTO boaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Diibyéhjáa muurá Dabííj tsɨɨménémúháábedítyú Píívyéébe meménú Jetsóoke mee ijraéémuma pámé Pájtyetétsoobe íjcyáábeke tsúúcajátújucóhjáa iñéhdújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Áábé ɨhdéhjáa Jóáa úwáábohíjcyá memúnaa ijraéémuke. Aabéhjáa nehíjcyá ímítyú iícyahíjcyánéhjɨ́ ɨɨ́hvéjtsóne ditye ɨ́mɨánejcúvuréjuco ipájtyéne ílluréjuco itsójtsótsámeíki. ");
INSERT INTO boaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aabéhjáa teene íuwáábó nɨjkévaríjyuco íjcyaabe nééhií: “Tsá muurá o íjcyatú eene ámuha meɨ́tsúcunúhíjcyaábe. Táhboonétúi ihdyu úwáábóiíbye. Áábeke muurá tsá íjtyúhápáájɨ́ubáré o tácórɨúcúítyuróne.” ");
INSERT INTO boaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ehdúhjáa iñétsihdyu Páávoro nééhií: —Ámuúha, Aavaráaúvúj tsɨɨménémúháábema múhdumé tsíjtye múnaa Píívyéébeke cáhcujtsómej, muurá pajtyété uwááboju méwáábyuta. ");
INSERT INTO boaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Muuráhjáa Jerotsaréeri íjcyame memúnaa íavyéjujtémáyé tsá wáájácutú diibyéjuco Mépájtyetétsoobe Jetsóó íjcyane ténevá wáyeéévéjcoojɨ́vadúné Píívyéébé ihjyú uubálle múnáá uwááboju dííbyedítyú íhjyuváné éévehíjcyaróme. Aamée muurá íllure ɨ́cúbahrá dííbyedi tsúúcajátújuco tene dííbyedítyú némeídyújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tsáháturóhjáa ɨ́ɨ́né imítyúné dibye méénutú tééné hallútú ditye dííbyeke llííhyánúiyóne. Árónáacáhjáa nééme Piráátoke dibye illííhyánútso dííbyedívu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ehdúhjáa dííbyedítyú tene cáátúnúmeídyújuco ditye méénune dííbyeke. Áábeúvú ɨɨtémehóhjáa tsíjtyeréjuco páwachéketu iñíítyétsóne cúúune. ");
INSERT INTO boaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Áróóbekée muurá Píívyéébere bóhɨɨtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aabéhjáa píváijyúvá bóhówáávehíjcyá Gariréatúhjáa Jerotsaréevu dííbyema péhíjcyámedívu. Aame muurá íñe úúbállehíjcyá mɨ́amúnáake dííbyedítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Aane íñe ámúhakye muha méúúbállehíjcyá ɨ́mɨá uwááboju tsúúcajátújucóhjáa méɨhdé múnáaúvuke úúbállémeíhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Muuráhjáa meke diityéúvúj tsɨɨménémúháábeke iñéhdújuco Píívyéébe bóhɨɨtsóné Jetsóoke. Muurá Tsááamóháámɨtu nééneé: “Uu Hájchíwu u íjcyáábeke uke ó bóhɨɨtsóhi.” ");
INSERT INTO boaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ehdúhjáa Píívyéébe néé dííbyeke ibóhɨ́ɨ́tsoíñé dííbyej pi ɨɨ́cúbáhrámeítyuki. Áhdure idyé tsiiñe neébe: “Ámúhakye ó pɨ́ááboó panévatúré Dabíiúvukée o néhdújuco.” ");
INSERT INTO boaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Téhdure idyé tsiiñe Tsááamóháámɨtu nééneé: “U íjcyátúcoocájɨ́ɨ́va néhi dɨ́ɨɨcúve múnáajpi íjcyáábej pi tóócuúhi.” ");
INSERT INTO boaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Aanéhjáa muurá diibye Dabíiúvuke Píívyéébe iñéhdújuco ímí ɨ́ɨ́cúvehíjcyáné mɨ́amúnáake dibye íjcyáijyu íjcyámeke. Aabéhjáa muurá dsɨ́jɨ́véébeke cááníúvú úníutu ditye cúúúúbej pi ɨ́cúbáhrámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Áánetúu Jetsóoke Píívyéébe bóhɨ́ɨ́tsóóbej pi tsá ɨ́cúbáhrámeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Aane ihdyu ámuha tamúnaa méwaajácúiyá diibyée dsɨ́jɨ́vénej tééveri tsúúca pámeere mɨ́amúnáá imítyuháñé Píívyéébe ábájɨ́ɨ́véné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aane muurá íñe múhdumé dííbyeke cáhcújtsómé imítyuháñé tsúúca ábájɨ́ɨ́vémeíhi. Áánetu teene cáhcújtsotúmé Píívyéébéhjáa Moitséeúvuj tééveri méénúné taúhbajúré úráávyehíjcyámé imítyuháñé tsá ábájɨ́ɨ́vémeítyúne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ahdícyane téɨɨbúwá méíjcyaco. Ámúhakye pajtyédíñé éhnéhjáa Píívyéébé ihjyú uubálle múnaa íllu nééneé: ");
INSERT INTO boaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ámuúhaj, múúnedi íllure úúhɨ́vatéhijcyámej, wa ihdyu méwágóóóvecoj. Muurá ɨ́htsútuube Píívyéébe o íjcyaabe panéváré o méénune tsaate ámúhakye úúballéjúcooróné tsá ámuha mecáhcútsohíjcyatúne. ");
INSERT INTO boaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ehdúhjáa Páávoro pihcyáávéjá pañévú úwáábóné tsujáávevu tsaate dííbyeke néé tsiiñe dibye wáyeéévejcóójɨ́ itsááne iúwááboki. ");
INSERT INTO boaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Áánemáhjáa diityétsima nahbévahíjcyámé Píívyéébeke ímí úráávyehíjcyámé jodíómuu, tsijtye jodíómú íjcyátúmedítyuu, íjcyame. Áámekéhjáa túkévétsohíjcyamútsí Jetsóodítyú íjcyáné uwááboju dityétsí úwaabóné ímí diityéké búuuvémé diityétsikye náhbévámeke. Aamútsíhjyáa nehíjcyá diityéké Píívyéébé pɨáábori ímí ditye iúráávye dííbyeke. ");
INSERT INTO boaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Átsihdyúhjáa tsííñé tsemáánaréjuco déjúcóóvéneri wáyeéévejcóójɨ́ íllúhwu pácoomí múnaáré dóbééverá Píívyéébé uwááboju illéébúcunúki. ");
INSERT INTO boaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ááneríhjyáa avyéjujte mítyane iñómíutááváne Páávoródítyú ihjyúvá dííbyé uwáábó icyátúhtsónema. ");
INSERT INTO boaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Áámekéhjáa núhnévétumútsíyé diibye Páávorómá Benabéemútsí nééhií: —Muurá ihdyu tehdújúcooro íñe Píívyéébé uwááboju Jetsóodítyú íjcyane mee jodíómudítyú úwáábómeí tujkénújúcooróné tsá ámuha meímílletú mecáhcújtsóne meímíbaavyéné múijyú medsɨ́jɨvéjúcóóítyúne bóhɨ́ ámuha meújcuki. Áánéllii muhtsi mepéé jodíómú íjcyátúme éllevu diityékeréjuco muhtsi meúwááboki. ");
INSERT INTO boaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Muurá Píívyéébe íhjyú uubálle múnáaj tééveri nééhií: Ukée ó picyóó peetédú u néébedítyú pajtyété uwááboju itsújááve pámeere ííñújɨri íjcyáné mɨ́amúnáadívu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ehdúhjáa dityétsí nééneri jodíómú íjcyatúmé ímíjyuuvéhi. Aaméhjáa nehíjcyá Jetsóodítyú íjcyáné uwááboju ɨ́mɨááné íjcyane. Áánemáhjáa cáhcujtsómé eenée múhdumé múijyú ɨdsɨ́jɨ́véítyúne bóhɨ́ iújcúíñejcúvuréjuco pájtyeme. ");
INSERT INTO boaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ehdúhjáa tééné iiñújɨri úwáábómeíñé Ávyéjúúbedítyú íjcyáné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Árónáacáhjáa pihcyáávéjá túkevéjtsojtémá ɨ́htsutúmé íjcyáné walléémú néé técoomí avyéjujtéké diityémá tsaméhjɨ́ iíjchívyétso diityétsikye tétsihdyu. Ahdújucóhjáa ditye íjchívyetsóné diityétsikye tééné iiñújɨtu páhduváré idyárɨ́ɨ́vémútsikye. ");
INSERT INTO boaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Áánélliihyéhjáa ílluréjuco dityétsí diityédívú íjtyúhááñe ííñú ipíchóújcóne pééne Icóónióvu. ");
INSERT INTO boaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Árónáacáhjáa ihdyu tétsíi múnaa múhdumé tsúúca Jetsóoke cáhcújtsómé pañe Píívyéébé Apííchó íjcyame mítyane ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aamútsíhjyáa Páávorómútsí Benabéema teene Icóóníori íjcyáné pihcyáávéjá pañévú úwáábohíjcyáné mítyame cáhcujtsó imúnaa jodíómu. Áhduréhjáa tsíjtye múnaa íjcyarómé cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Árónáacáhjáa tsaate jodíómú cáhcújtsotúmé bóijcyú jodíómú íjcyátúmeke ditye icyáhcújtsótuki. Aaméhjáa ditye néhdújuco tsáríllehíjcyáné cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Áróné pañéhjáa tsúúcajái tétsii íjcyamútsí úwáábohíjcyá Píívyéébedívú icyátsɨ́páávéne ɨ́ɨ́nerí núhnévétumútsi. Áámútsikyéhjáa pɨ́ááboobe dííbyé ɨhnáhoori dityétsí méénúráítyúronéhjɨ imyéénuki. ");
INSERT INTO boaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Áánáacáhjáa técoomí múnaa ílluréjuco dówaavéne. Tsaatéhjáa pajtyé uwáábojté icyánejcúvu. Áánetúhjáa tsijtye coévá cáhcújtsótúmema. ");
INSERT INTO boaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Áánélliihyéhjáa jodíómuu, tsijtye jodíómú íjcyátúmee, íjcyame íavyéjujtémá pítyácójcatsí diityétsikye páhduváré idyárɨ́ɨ́vémútsikye néwayúúnevu iáámuíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Aanéhjáa iwáájácúne úmɨ́vamútsí Ricaóóniá iiñújɨvu. Aamútsíhjyáa úwáábohíjcyá tééné iiñújɨri Ríítaraa, Déébeé, íjcyácoomícyuri. ");
INSERT INTO boaNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Téhduréhjáa úwáábohíjcyamútsí hállúcuri íjcyámeke. ");
INSERT INTO boaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Aanéhjáa Ríítarárí íjcyaabe tsaapi ɨtsɨ́ɨ́mávámeítsihdyújuco úllétuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aabéhjáa lleebúcunúhijcyá Páávoro úwaabóne. Áábekéhjáa Páávoro iájtyúmɨ́ne waajácú dibye ɨ́mɨááné cáhcujtsóné Píívyéébe dííbyeke ímíjpyetétsoíñe. ");
INSERT INTO boaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Áánélliihyéhjáa neebe dííbyeke: —Díjyocúúve. Ahdújucóhjáa iíjyócúúvénemáyé dibye úllene. ");
INSERT INTO boaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ááneríhjyáa teene Ricaóóniá iiñújɨ múnaa iúllévenúne néé íhjyúrií: —¡Píívyéébemútsíhya íñe méhdivu niityé mɨ́amúnáajtétsidívú iípívyéévénema! ");
INSERT INTO boaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ehdúhjáa iñééne Benabéeke meménúmé ‘Jóópite’ némeíñé mɨɨcúrúwake icyáánívahíjcyáábe déjutu. Áánetúhjáa Páávoróké meménúmé tsijpi ‘Meecóório’ némeíñé mɨɨcúrúwa déjutu ímichi dibye íhjyúvahíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Áijyúhjáa diibye ‘Jóópite’ némeíñé mɨɨcúrúwake cáánívahíjcyaabe llúúváábé duurúvaja técoomí lleehówá úníuríye. Aabéhjáa tsivá ócájimútsikye wajcóháñetu iícyáávétsómútsikye. Áámútsikyéhjáa tsaméhjɨ́ imíllerá illííhyanúné tééneri Páávorómútsikye ɨɨ́ɨ́cúveki. ");
INSERT INTO boaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Aanéhjáa iwáájácúne íwajyámúúné dóváríjcyómeímútsí tsárí ehdu ditye méénúiyóné diityétsikye pájtyénélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Áánemáhjáa ɨ́ɨ́cúi diityé éllevu ipyééne neemútsi: —¿Aca ɨ́veekí ámuha ehdu mémeenúhi? Áánerá ámuhádúré muhtsi mɨ́amúnáajtétsi. Aamútsíi muurá íñe ámúha éllevu muhtsi metsáá ámúhakye meúwáábo ehdu nénehjɨ ámuha meúráávyehíjcyáné meɨ́hvéjtsóne Píívyéébekéréjuco ámuha meúráávye páneerée íévéhóówari íjcyánéhjɨma ííñujɨ tééjɨ́ hallúrí íjcyáméhjɨmájuco nújpácyó pañe íjcyámeke ípívyéjtsóóbeke. Diibye ihdyu meke bohɨ́ɨ́vú ajcúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dííbyerée muurá éíjyuúvú mɨ́amúnáake ɨ́hvejtsómé ícyahíjcyá iímillédu. ");
INSERT INTO boaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Árónáacáa ɨ́ɨhnáhoovu diityéké úújétsoobe panévatúré diityéké ɨpɨ́áábóneri. Dííbyere muurá mééma nííjyáhañe állétsóneri mebájtsoháñé tsaímíyé píívyene meóóvéne méícyahíjcyá tsaímijyúúre. ");
INSERT INTO boaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ehdúhjáa dityétsí néérónáa imíllerómé diityétsikye ɨɨ́ɨ́cuvéné ócájimútsikye icyóvájtsóneri. Árónemáhjáa ɨ́hvejtsóme. ");
INSERT INTO boaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Áánáacáhjáa tétsihvu wajtsɨ́mé tsijtye jodíómú Ajtiokííaa, Icóónioo, íjcyácoomícyutu tsáámeé. Aaméhjáa diityétsí hallúvú diityéké állívánéllii Páávoróké aamúmé néwayúúnevu. Áábekéhjáa ‘tsúúca dsɨ́jɨ́veébe’ iñééne lliúcuíñúmé técoomítyú ɨ́ɨ́wávuú. ");
INSERT INTO boaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Áábé hallúvúhjáa tétsíí cahcújtso múnaa mɨ́caavérónáa iácúúvéne tsiiñe peebe diityémá técoomívu. Ááné tsiíjyúhjáa Déébévuréjuco dityétsí pééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Aamútsíhjyáa téhulle úwaabóné mítyame cáhcujtsóhi. Átsihdyúhjáa óómimútsí úwáábomútsíyé Ríítaraa, Icóónioo, Ajtiokííaa, éhdú coomívari ijcyáné cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Diityékéhjáa tsápɨ́tsohíjcyamútsí ditye ímíñeúvú iúráávye Jetsóoke icyáhcujtsóne. Áhduréhjáa nehíjcyamútsí diityéké ɨ́mɨáánéjuco mítyane meɨ́cúbáhrámeíñé nɨ́jcáutu meúcaavéné Píívyéébé avyéjuvu. ");
INSERT INTO boaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Téijyúhjáa meménuhíjcyamútsí pacóómivárí íjcyáné cahcújtso múnáá túkevéjtsojte íjcyáímyeke. Ááné boonéhjáa tsaméhjɨ́ májchotúmé Píívyéébema ihjyúvá dííbyeréjuco diityéké ityúkévéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Aamútsíhjyáa Pitsíídiá iiñújɨtu péémutsi úújeté Pajpííriá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Aamútsíhjyáa Pééjéri iúwáábohíjcyátsihdyu idyé péé Atááriá coomívu. ");
INSERT INTO boaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Átsihdyúhjáa íwákimyéí ɨnɨ́jkévátsihdyu tsahííyiyéjuco dityétsí óómiñe Ajtiokííavu, tétsihdyúu teene Píívyéébé wákimyéivu diityétsikye ditye wállótsihvu. ");
INSERT INTO boaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Aamútsíhjyáa cahcújtso múnáake úúballé muhdú Píívyéébe diityétsikye panévatúré pɨ́áábohíjcyáne. Áhduréhjáa úúbállemútsí dibye pɨ́áábóneri jodíómú íjcyáturómé cáhcujtsóné Jetsóodítyú íjcyáné uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Áámemáhjáa tsúcájá íjcyamútsi. ");
INSERT INTO boaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Áijyúhjáa tsaate Jodéá iiñújɨtu teene Ajtiokííavu pééme tétsíí cahcújtso múnáake úwáábohíjcyá Moitséeúvú uwááboju néhdu kíhdyahɨ́rótsámeítyúmé pájtyetéityúne. ");
INSERT INTO boaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ááneríhjyáa diityémá Páávorómútsí táhjájcatsíhi. Ááné boonétúhjáa tsamééréjuco cahcújtso múnaa íhjyúvájcatsíñé dityétsí Jerotsaréevu tsaatémá ipyééne idyé iíhjyúva tééneri técoomí cahcújtso múnáá túkevéjtsojtémá uwáábojte íjcyámema. ");
INSERT INTO boaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Aaméhjáa pééme pajtyé Peníítsiámá Tsamááriá iñújɨ́ɨ́cutu. Aaméhjáa úúballé imúnáake jodíómú íjcyatúmé Píívyéébeke cáhcujtsóné muhdú iícyahíjcyanéhjɨ́ ɨɨ́hvéjtsónema. Ááneríhjyáa tétsíí cahcújtso múnaa mítyane ímíjyuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Aaméhjáa Jerotsaréevu úújetémeke tétsíí cahcújtso múnaa tsaímíyé waatsúcúpejtsóhi. Áámekéhjáa úúballémé páneere muhdú Píívyéébe diityéké pɨ́áábohíjcyáné panévatúre. ");
INSERT INTO boaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Áijyúhjáa tsaate paritséómudítyú tsúúca Críjtoke cáhcújtsorómé nééhií: —Múu eene jodíómú íjcyatúmé cáhcújtsómedívú ikíhdyahɨ́rótsóne táuhbá ditye Moitséeúvú uwááboju iúráávyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Áánélliihyéhjáa pámeere uwáábojtémá túkevéjtsojte dóbeevé tééneri iíhjyúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aaméhjáa mítyane tééneri táhjájcatsíñé nɨ́jcáutu Péédoro iíjyócúúvéne nééhií: —Ámuúha táñahbémuj, muurá ámuha méwaajácú tsúúcajátújucóhjáa oke Píívyéébe ámúhadítyú imyéménúúbeke pícyoone o úúbállehíjcya ɨ́mɨáájú pajtyéteju jodíómú íjcyátúrómeke ditye téhdure icyáhcújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Aabée muurá Píívyéébe ɨɨná túhúúllétuube téhdure diityé pañévú picyóó Íapííchó mépañévúu ipícyohdu. Ááneríi úújétsoobe téhdure diityéké iwájyune. ");
INSERT INTO boaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Áámekée ímíbájchoobe Críjtoke ditye cáhcújtsónéllii muhdúhjáa meke iímíbajchódu. ");
INSERT INTO boaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ehdúu Píívyéébe diityéké ímíbajchó Críjtoke ditye cáhcújtsónélliíhye. Áámeke ¿ɨ́veekí ámuha méimíllé íllure metúhujtsóné méɨhdé múnáaúvúu íjcyarómé ímí úráávyehíjcyánejɨ́ɨ́va ditye iúráávye Moitséeúvú uwááboju, pane meíjcyarómé tene néhdu meíjcyáíyónejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Aame muurá tsaméhjɨ́ diityémá tsúúca mépájtyetéjucóó apááñéré Críjtóo méhdi ɨɨ́dáátsóvéne mééma méénune mecáhcújtsónélliíhye. Tsá ɨ́nehjɨ́ meméénúneri mepájtyetétúne. ");
INSERT INTO boaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ehdúhjáa Péédoro néénéllii cúúvéhulléréjuco ditye lléébúcunúné Páávorómútsí úúballéné muhdúhjáa Píívyéébe méénúráítyúronéhjɨ́ diityétsij tééveri méénuhíjcyáné jodíómú íjcyátúrómé pañe. ");
INSERT INTO boaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","14","Aamútsíhjyáa ɨ́hveténé boone Jacóóboréjuco nééneé: —Ámuúha táñahbémuj, cáhawáá idyé táicyánéjcutu ámúhakye o néé peíyené Tsimóo Péédoro meke úúballéjucóóné muhdúhjáa Píívyéébe téhdure jodíómú íjcyátúrómedívú íuwááboju úújetétsóné múhdumé teene cáhcujtsómé dííbyeéjté iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Muuráhjáa dííbyé ihjyú uubálle múnaa cáátunúné íllu nééhií: ");
INSERT INTO boaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","Bóónétu tsiiñe ó tsaá Dabíiúvú avyéjúu tútávaavéné dííbyéj tsɨɨménémúháábemáyéjuco o ímíbájcho téénetu pámeere mɨ́amúnaa iwáájácúne Píívyéébé icyánejcúvuréjuco ɨɨ́búwááve múhdumé dííbyé wáábyutájté íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ehdu neebe Píívyéébe tsúúcajátújucóo ɨɨ́jtsámeíñe. Ehdúhjáa Píívyéébé ihjyú uubálle múnaa caatúnúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Áánéllii ámúhakye o néé tsáháubá menééítyuró jodíómú íjcyáturómé Píívyéébeke úráávyémeke ditye Moitséeúvú uwááboju iúráávye diityéké tééneri metúhújtsótuki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Árónáa ihdyu íllure mécaatúnuú diityémá ditye ílluune imyéénújúcóótuki: Tsá ditye dóóityú níjcyotájteke ɨ́ɨ́cúvémeíñé iyámeke; tsá ditye tsíjtyéhjɨma dómácójcatsíityúne; tsá ditye dóóityú dótsohcáorii, majcánurii, dsɨ́jɨ́véné iyámeke; tsá ditye dóóityú tújpacyo. ");
INSERT INTO boaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muuráhjáa tsúúcajátújuco pacóómiváríyé tsaate úwáábohíjcyáné téénetu Moitséeúvú uwááboju néhdújuco. Aanéjuco muurá ténevá wáyeéévéjcoojɨ́vádú éévémeíhijcyáné pihcyáávejááné pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ehdúhjáa Jacóóbó néénéllii pámeere tétsíí cahcújtso múnaa, uwáábojtee, túkevéjtsojtee, íjcyame néé tsaatéké íhdityu iwállooíñé Ajtiokííavu Páávorómútsima. Áánemáhjáa meménúmé Tsíírámútsikye Jóódáma dííbyere ‘Batsabáa’ némeííbyema ityújkevééllémútsikye. ");
INSERT INTO boaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Áámútsimáhjáa waajácuháámɨ́ iwállóháámɨ́ pañe néémeé: “Muha íílle pámeere cahcújtso múnaa meíjcyame ámúha éllevu íhjyu méwallóó jodíómú ámuha meíjcyatúmé Tsííriá iiñújɨri íjcyacóómí Ajtiokííari ámuha meíjcyáme éllevu, áhdure hállúcu múnáa éllevu. Áhdure idyé Tsiríítsiá iiñújɨ múnáá wáábyuta téhaámɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Aame muha méwaajácújucóó muha mewállootúméré ámúha éllevu ipyééne íllure ámúhakye máváríchohíjcyáne. Ámúhakyévá muurá nehíjcyámé Moitséeúvú uwááboju néhdu ámuha mekíhdyahɨ́rótsámeíki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Áánéllii muha ímíñeúvú meɨ́jtsámeíñe múúhadítyú meméménúmútsikye méwallóó ámúha éllevu muha maávyejúúllehíjcyamútsí Páávorómútsima. ");
INSERT INTO boaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Diityétsíi muurá Páávorómútsí ápíchó néérónehjɨ́vú pájámeíhijcyá Máavyéjuube Jetsocríjtoke iwájyúnélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Áámútsima muha méwallóó ámúha éllevu Tsíírámútsikye Jóódámaá. Aamútsí ihdyu óvíi ímíñeúvú ámúhakye néé muhdú téhaamɨ́ pañe íjcyáné túkevéjtsoju nééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Aane mítyane ámúhakye muha metúhújtsótu apáhdyúré Píívyéébé Apííchó múúhakye túkévéjtsóneri ámúhakye muha menééhií: ");
INSERT INTO boaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tsá múu dóótu níjcyotájteke ɨ́ɨ́cúvémeíñé iyámeke. Áhdure tsá múu dóótu dótsohcáorii, majcánurii, dsɨ́jɨ́véné iyámeke. Tsá múu tsíjtyéhjɨma dómácójcatsítyúne. Áhdure tsá múu tújpacyo dóótune. Aane tehdu ámuha meíjcyáhajchíí ímí tehdújuco ámuha meíjcyaíñe. Áyu wáí meíjcyaj.” Ehdúhjáa iñéhaamɨ wallóómé Ajtiokííari íjcyáné cahcújtso múnáa éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aanéhjáa tsúúca técoomívú iúújeténe ipíhjyúcúmeke ájcumútsí téhaamɨ́vu. ");
INSERT INTO boaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Áhaamɨ́hjáa iéévéne mítyane ímíjyuuvéme. ");
INSERT INTO boaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ááné boonétúhjáa diityéké úwáábomútsí Píívyéébé ihjyu diityéké tééneri éhnííñevu itsápɨ́jtsoki. Piivyétemútsíhjyáa iúwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aamútsíhjyáa tsúcájáhréjuco diityémá iíjcyátsihdyu úúballé diityéké ílluréjuco ióómiíñe. Áánélliihyéhjáa pítyajcómé dityétsí tsaímíyé ióómiki. ");
INSERT INTO boaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Árónáacáhjáa Tsííra tétsihvúré cóévánáa Jóóda iiyéjuco óómiñe. ");
INSERT INTO boaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Áhduréhjáa Páávorómútsí coévá tétsihvúré Ajtiokííavu. Aamútsíhjyáa tétsíi múnáama úwáábohíjcyá Píívyéébé uwááboju. ");
INSERT INTO boaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Átsihdyúhjáa pívájcoojɨ́vájuco pájtyénetu Páávoro Benabéeke nééhií: —Cána majo ááhɨ́vemútsíyé mepéé éhnée Jetsóodítyú íjcyáné uwááboju úwáábomútsíyé mepéhíjcyá coomíjɨri íjcyáné cahcújtso múnáake mewáájácu muhdújuco ditye úraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Áijyúhjáa Benabéé imíllerá tsiiñe Jóáa pééne diityétsima dííbyere ‘Máácoó’ némeííbye. ");
INSERT INTO boaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Árónáacáhjáa Páávoro tsá ímílletú dibye pééne diityétsima dibyéhjáa Pajpííriá coomívú diityétsidítyú cóévánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ááné hallútúhjáa ɨtsɨ́pájújcatsíñe ílluréjuco dityétsí dówaavéne. Ááné boonéhjáa Benabéé diibye Máácóke iújcúúbema péé tsahííyí Chííperévu. ");
INSERT INTO boaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Áánetúhjáa Páávoro Tsíírákeréjuco újcune dííbyema ipyéékií. Áámútsí hallúvúhjáa tétsíí cahcújtso múnaa Píívyéébeke pɨáábó táúmeí ímí dityétsí ipyéékií. ");
INSERT INTO boaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Aamútsíhjyáa pehíjcyá Tsííriámá Tsiríítsiá iñújɨ́ɨ́curi íjcyáné cahcújtso múnáake tsápɨ́jtsomútsíye. ");
INSERT INTO boaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Aamútsíhjyáa Páávorómútsí Tsííráma úújeté Déébeé, Ríítaraa, íjcyácoomícyuvu. Átsiíhjyáa ájtyúmɨmútsí tsaapi cahcújtso múnáajpi Timotéoke. Dííbyéj tsɨɨjúhjáa jodíómulle íjcyalle idyé cahcújtso múnáalle. Áánetúhjáa cááni gríéégómuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Áábedítyúhjáa Timotéodítyú tétsíí cahcújtso múnaa nehíjcyá ɨ́mɨáábé dibye íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Áábekéhjáa Páávoro imíllé itsájtyene dibye iñáhbénu dííbyeke. Árónáacáhjáa pámeere waajácú cááni gríéégómuube íjcyánéllii dibye kíhdyahɨ́rótsámeítyúne. Áánélliihyéhjáa tujkénúi dííbyedívú kíhdyahɨ́rótsoobe imúnaa jodíómú méénuhíjcyádú tééné hallútú diityémá ímityúné iíjcyátuki. ");
INSERT INTO boaNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aaméhjáa ipyéhíjcyátsɨ́hjɨ múnáake úúbállehíjcyá muhdú Jerotsaréeri íjcyáné uwáábojte túkevéjtsojtémá diityéké úwáábohíjcyáné muhdú cahcújtso múnaa íjcyáiyóne. ");
INSERT INTO boaNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aanéhjáa illéébóne Píívyéébeke cáhcujtsómé llíyaaté éhnííñevu mítyaméjuco. ");
INSERT INTO boaNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Aaméhjáa Píívyéébé ihjyu Áátsiá iiñújɨ́ úwáábóíyónáa dííbyé Apííchóré diityéké túkévéjtsónej péévé tsá ditye úwáábotú tééné iiñújɨ múnáake. Áánélliihyéhjáa Pírííjiámá Garáátsiá iñújɨ́ɨ́cutúré pajtyéme. ");
INSERT INTO boaNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Aaméhjáa Míítsiá iiñújɨ́ watsíívyevu úújetémé imíllerá ipyééne Bitííniá iiñújɨvu. Arónáacáhjáa téénere Píívyéébé Apííchó Jetsóópe diityéké ájcune túkévéjtsónej péévé idyé tsá ditye téhullévú péétune. ");
INSERT INTO boaNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Áánélliihyéhjáa tsapéhdú Míítsiá iiñújɨtu pájtyeme úújeté ‘Tóróóaá’ némeí mujcóvújuco. ");
INSERT INTO boaNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Átsihvúhjáa Páávoródívú pejco naavédú nééne bóhówáávéné pañe Matsedóóniá iiñújɨ múnáajpi dííbyeke nééhií: “Muúbej, Matsedóóniá iiñújɨvu metsááne múúhakyéréjuco méuwáábo.” ");
INSERT INTO boaNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ehdúu nééne dííbyedívú bóhówáávéné boonétú muha mepéé téhullévú Píívyéébere múúhakye wállóhullévú muha meúwááboki. ");
INSERT INTO boaNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Aamée Tóróóatu muha tsahííyí mepéé tsapéhdú Tsamotáráátsiá caapáhovújuco. Ááné tsiíjyúu muha méúújeté Néááporívu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Átsihdyúu muha mecóhbaavémé méúújeté romáánómúhjáa Matsedóóniá iiñújɨ́ pañévú íhcyóómi ípívyéjtsocóómí Pirípovu tééné iiñújɨ́ avyéjú coomívu. Ácoomíyíikyée tsúcájá muha méícyahíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Aamée muha wáyeéévejcóójɨ́ mepéé Píívyéébema ditye íhjyúvahíjcyátsihvu téhí úniúvu. Átsihvúu muha méúwaabó walléémuke múúhadívú píhcyáávémeke. ");
INSERT INTO boaNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Áámé pañée íjcyalle Tiatíírá cóómi múnáalle Ríídia ɨ́mɨá wajyámúúné duujɨ́nuúdú néjáhjɨ́ nahjɨ́he múnáalle. Aalléhjáa ihdyu tsúúcajátújuco Píívyéébeke úráávyehíjcyárolle botsíi dííbyere pɨ́áábóneri cáhcujtsó Jetsóodítyú íjcyáné uwááboju Páávoro úwaabóne. ");
INSERT INTO boaNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aallée ílluréjuco tsójtsótsámeíñé pámeemáyé ihyájkímuma. Ááné boonétúu múúhakye neélle: —Áyu cána tahjyávú mepe ɨ́mɨááné Píívyéébeke o cáhcujtsóné ámuha menéhajchííjyu. Ehdúu múúhakye iñééne ihjyávú itsájtyémeke tétsihvúréi coévátsolle. ");
INSERT INTO boaNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Áhdurée tsáijyu Píívyéébema ditye íhjyúvahíjcyáhullévú muha mepééme méúújeté bádsɨ́jcájadívú naavénéhjáa ípañe íjcyáábej tééveríyé ɨɨná pájtyeíñé wáájácuhíjcyálledívu. Aalléhjáa tsaaté hójtsɨ́ pañe íjcyalle mítyane dsɨ́ɨ́sɨke úcuhíjcyá diityémá tééné hallúvu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Aallée múúha déjutu tsáálle nehíjcyáhi: —Íjtye muurá ɨ́htsútuube Píívyéébé wákimyéi múnaa ámúhakye pajtyéteju úwáábohíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ehdúu múúhakye nehíjcyalle píváijyúvájuco. Áánéj taíchoríi Páávoro ílluréjuco úhbane dííllé pañe íjcyaabe naavéneke. Íllúu neébe: —Uke o néé Jetsocríjto mémeri áállé pañétú u íjchívyeki. Ahdújucóo dibye íjchivyéné teenémáyé díílledítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Áánélliihyée íavyéjujte ɨ́ɨ́né hallúvucó ɨdsɨ́ɨ́dsɨvájúcóóítyúné maatyóbá diityétsí Páávorómútsikye iékéévéne tsajtyé técoomí avyéjujté éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","Áámútsikyée diityédívú iúújetétsóne néémeé: Íjtyetsi jodíomútsí ¿ɨ́veekí méhcóómí pañe páhduváré nénehjɨ úwáábohíjcyá tehdu mee romáánómú teene mecáhcújtsóíyónejɨ́ɨ́vari? ");
INSERT INTO boaNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ááneréjucóo pámeere nééne ɨ́mɨááné tehdu dityétsí méénuhíjcyáne. Áánélliihyée awáá ávyéjute diityéké táuhbá ditye íwajyámúúné ityácórɨ́jcómútsikye iwápáájcoki. ");
INSERT INTO boaNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ahdújucóo ditye diityétsikye imyéénúne icyúvéhoojánúmútsidívú téhmetsóné tééjá tehméébeke. ");
INSERT INTO boaNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Áánélliihyéhjáa tsíhyooja pañe íjcyáhóójá pañévú iúácómútsikye úméhewávú ɨ́hdótsoobe ítyújkejɨ́ɨ́netu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Aamútsíhjyáa téhoojá pañe íjcyamútsí Píívyéébema ihjyúvahíjcyá pécójpɨɨnéjuco meíjcyárónáaáca. Téhduréhjáa dííbyeke idyúúruváné dityétsí májtsiváné tsijtye teene cúvéhóójari íjcyame lleebúcunúhijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Árónáacáhjáa peecútéré tétsii úúvécunúneri lléhowááné páhyúbáné tujkéveri pámeere tééjari íjcyámedítyú úwáñehííñé cóhrɨbáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Áánáacáhjáa tééjá tehméébé icyúwátsihdyu ájkyeebe ɨɨtécunú páneere lléhowááné páyújcatyéne. Aanéhjáa ɨjtsúcunúúbé tsúúca ditye úmɨváne. Áánélliihyéhjáa ícyávaájcó újcuube illííhyánúmeíki. ");
INSERT INTO boaNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Árónáacáhjáa Páávoro nééhií: —Ehdu bo méénúmeídíñej, íjtyérero muúha. ");
INSERT INTO boaNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Áánélliihyéhjáa peete ɨpɨ́úváne ɨ́ɨ́cúi diityétsi éllevu peebe íllityécunúúbére. Áánemáhjáa mɨ́móúúvetéébé diityétsí lliiñévu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Áánemáhjáa ílluréjuco dibye iíjchívyétsómútsikye nééneé: —¿Aca muhdú ó pájtyetéiyáhi? ");
INSERT INTO boaNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Áánélliihyéhjáa dííbyeke neemútsi: —Ávyéjuube Jetsocríjtoke pámeere dihyájkímuma mécahcújtsó ámuha mépájtyetéki. ");
INSERT INTO boaNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ehdúhjáa dííbyeke iñétsihdyu úwáábomútsí dííbyeke pámeere ihyájkímumájuco. ");
INSERT INTO boaNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Aabéhjáa tépejco nijtyú diityétsikye ditye túúvátsonéhjɨ. Áánemáhjáa ílluréjuco dibye diityétsidívú tsójtsótsámeíñé diitye ihyájkímumájuco. ");
INSERT INTO boaNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Átsihdyúhjáa diityétsikye ihjyávú itsájtyémútsikye májchotsóme. Aaméhjáa mítyane ímíjyuuvé Píívyéébeke tsúúca icyáhcújtsóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ááné tsɨtsɨ́ɨ́vevúhjáa técoomí avyéjujte wallóó tehmé múnáake ditye iñééte diibye cúúvéjá tehméébeke ílluréjuco dibye iíjchívyétso diityétsikye. ");
INSERT INTO boaNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ahdújucóhjáa ditye dííbyeke nééténéllii neebe Páávoróke: —Ávyéjujtévá néé ámúhtsikye o íjchívyétsoki. Ahdícyane wa ílluréjuco mepej. ");
INSERT INTO boaNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Árónáacáhjáa Páávoro néé diityéke: —Muurá íñe múhtsikye ɨɨná néétuméré mɨ́amúnááj pɨɨnévú iwápáájcómútsikye cuvéjaanú romáánómúejtétsí téhdure muhtsi meíjcyáné waajácúháámɨma meíjcyámútsikye. Aame ¿ɨ́veekí imíllé múhtsikye iíjchívyetsóné teevétaríye? Aane tsá muhtsi áyánéwu meímílletúne. Óvíi ihdyu iiye itsááne múhtsikye ijchívyetsóváme. ");
INSERT INTO boaNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ehdúhjáa dityétsí nééne úúbálletémé ávyéjujtéke. Ááneríhjyáa mítyane íllityémé romáánómúejtétsí iíjcyáné waajácúháámɨma dityétsí íjcyáneri. ");
INSERT INTO boaNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Áánélliihyéhjáa diityétsi éllevu ipyééne ɨ́dátsójkímyeímyé diityétsidívu. Áánemáhjáa choocóréjuco ditye wálloone técoomítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aamútsíhjyáa teene cúúvéjatu íjchívyemútsí Ríídiá javu úújetémútsí cahcújtso múnáake itsápɨ́tsohíjcyátsihdyu ílluréjuco pééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Aaméhjáa Páávoroo, Tsííraá, Timotéoo, éhdume péhijcyámé pajtyé Ajpííporii, Aporóóniaa, íjcyácoomícyutu. Átsihdyúhjáa pééme Tetsaróónicávú úújetétsihyi íjcyaja imúnaa jodíómú pihcyááveja. ");
INSERT INTO boaNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Áájá pañévúhjáa wáyeéévejcóójɨ́ Páávoro imyéénuhíjcyádú úwaabóhi. Ehdúhjáa ténevá wáyeéévéjcoojɨ́vádú úwáábohíjcyaabe pápihchúúijyúva. ");
INSERT INTO boaNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Úúbállehíjcyaabéhjáa diityéké Pííyéébé ihjyú uubálle múnaáhjáa cáátúnuhíjcyáné néhdújuco Críjto ɨɨ́cúbáhrámeítsihdyu dsɨ́jɨ́veebe tsiiñe bóhɨɨ́ne. Téhduréhjáa nehíjcyaabe diityéke: —Muurá diibyéjuco Jetsóó Mépájtyetétsoobe íjcyáábedítyú ámúhakye o úúbállehíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ehdúhjáa Páávoro néénéllii tsaate imúnáadítyú tsúúca cáhcujtsómé diityémá nahbévahíjcyáhi. Téhduréhjáa mítyame gríéégómudítyú cáhcujtsó ɨ́mɨáámé íjcyame tsúúcajátújuco Píívyéébeke úráávyehíjcyáme. Áhduréhjáa diityédítyú walléémú avyéjúméhjɨúvú nééme cáhcujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ááneríhjyáa tééjá túkevéjtsojte cáhcújtsotúmé iñómíutááváne juváñeri átéréejte óvéhe múnaa péhíjcyámeke iújcúmema técoomí múnáake iííbórɨ́nútsihdyu Jatsóo jávú péé Páávorómútsi néhcovu diityétsikye itsájtye técoomí avyéjujté éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Aaméhjáa diityétsikye iájtyúmɨ́túnéllii diibye Jatsóokéréjuco tsijtye cahcújtso múnáama tsájtyene diityé éllevu. Áámekéhjáa diityédívú iúújetétsóne néémeé: —Éhne mɨ́amúnáake tútávátsohíjcyamútsíhya Páávorómútsí Tsíírama wájtsɨ́mútsikye áánu Jatsóó ihjyávú tsaímíyé iwáátsúcúpéjtsóne tsaméhjɨ́juco íhjyuváné ímityúné mee romáánómú avyéjúúbé taúhbajúúnetu. Nehíjcyámé tsijpívá ávyéjuube íjcyane Jetsóo. ");
INSERT INTO boaNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ehdúhjáa ditye nééne técoomí avyéjujtémá tsijtye tétsii íjcyámeke múhdurá pajtyéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Árónáacáhjáa diitye Jatsóómú múu áhdómeídyú meenú ditye iácádsɨ́jcaáyo diityéke. Ahdújucóhjáa ditye ácádsɨ́jcaáyóne. ");
INSERT INTO boaNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Áijyúhjáa tépejco cahcújtso múnaa ijchívyetsó Páávoroo, Tsííraá, íjcyámútsikye diityétsí ipyéé Beréavu. Áámutsíhjyáa téhullévú iúújetédú péé imúnáá pihcyáávejávu. ");
INSERT INTO boaNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tsáháhjáa tétsíi múnaa Tetsaróónicá múnaádú néétune. Ímíhyéhjáa lleebúcunúhijcyámé dityétsí úwaabóne. Aaméhjáa néhcohíjcyá Píívyéébé ihjyú uubálle múnaápe cáátúnuhíjcyánéhjɨ́ pañe iwáájácu ɨ́mɨááné tehdújuco dityétsí úwáábohíjcyáhajchííjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Áámedítyúhjáa mítyame cáhcujtsó jodíómuu, gríéégómuu, íjcyame wajpíímumáyé avyéjúméhjɨúvú nééné walléému. ");
INSERT INTO boaNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aanéhjáa tsúúca Tetsaróónicárí íjcyame jodíómú waajácú Páávoro Beréari úwáábohíjcyáné Píívyéébé ihjyu. Áánélliihyéhjáa téhullévú ipyééne tsiiñe iibórɨ́nutémé diityéke. ");
INSERT INTO boaNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Áánélliihyéhjáa ɨ́ɨ́cúi wallóómé Páávoróké dibye ipyéé móóá úniúvú tétsihvúré Beréavu Timotéomútsí Tsííráma cóévánáaáca. ");
INSERT INTO boaNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Áábekéhjáa pícyohjémé Atéénavu. Aaméhjáa óómímyeke neebe ditye iñéé ɨ́ɨ́cúi dityétsí ipyéé dííbye éllevu. ");
INSERT INTO boaNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Áámútsikyéhjáa téhmeebe ɨ́ɨ́tehíjcyá mítyane técoomíyí ditye dúúrúvahíjcyáné níjcyotájteke. ");
INSERT INTO boaNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aanéhjáa múhdurá ɨɨ́jtsúcunúnéllii tééneri ihjyúvahíjcyaabe imúnáama tsijtye Píívyéébeke dúúrúvahíjcyámema pihcyáávéjá pañévu. Ihdícyátsɨhjɨ́vúhjáa icyábúúvémema ihjyúvahíjcyaabe tééneri. ");
INSERT INTO boaNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Áábemáhjáa ‘epicóóreo’ némeíñé uwááboju úráávyehíjcyámema tsijtye ‘ejtóico’ némeíñé uwááboju úráávyehíjcyámé ihjyúvahíjcyáhi. Áámedítyúhjáa tsaate néjcatsíhi: ¿Muhdúami tsáma áánu íhjyuwábá meke nehíjcyaj? Áánetúhjáa tsijtye nééhií: —Tsííñé piivyéébémú ihjyú uubálle múnáajpíubá diíbye. Ehdúhjáa nehíjcyámé Páávoródítyú dibyée Jetsóó dsɨ́jɨ́veebe bóhɨ́ɨ́bedítyú íjcyáné uwááboju úúbállehíjcyánélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Áábekéhjáa tsajtyémé ipítyácócatsíhíjcyátsihvu ‘Areóópago’ némeítsihvu. Áánemáhjáa dííbyeke néémeé: —¿Aca tsá múúhakye u wáájácútsóítyuró ímíñeúvú béhné uwáábójuma u tsáánevu? ");
INSERT INTO boaNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Muurá múúhakye u néhijcyáné tsáhái tsáijyúubáré muha melléébotúne. Áánéllii muha méimíllé mewáájacúné ímíñeúvú ɨɨná nééiyóné múúhakye u néhijcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ehdúhjáa dííbyeke nééme Atééna múnáama tsííñé iiñújɨ múnaa íjcyame. Aaméhjáa ɨ́ɨ́nerí íjcyatúmé paíjyuváré úbállécatsíhijcyá páhduváré nééné uwáábó illéébone. ");
INSERT INTO boaNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Áámekéhjáa Páávoro nééhií: —Ámuúha Atééna múnaaj, muurá ó waajácú ámuha panéváré tsíñehjɨ mecáánívahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Muuráhjáa ámuha medúúrúvahíjcyátsɨhjɨ́rí o péhíjcyaabe ó ájtyumɨ́ ɨɨcúvé waɨ́jɨ́ hallútú íllu nééne cáátúnúmeíñe: “Mewáájácútúné Piivyéébé wáábyuta.” Aane muurá dííbyedítyú ámúhakye ó úwáábohíjcyá eene dííbyeke wáájácutúméré ámuha medúúrúvahíjcyáábedítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Diibye ihdyu Píívyéébe páneerée múhdúné tsíeméné ípívyéjtsoóbe. Diibyée muurá ípívyejtsó ííñújɨma páneere íévéhóówari íjcyanéhjɨ. Áánéllii páneere ijcyá dííbye tájpíye. Aabe tehdu apátsiíyé íjcyáíyónejɨ́ɨ́ mɨ́amúnaa méénúné duurúvájá pañe. Muurá ihdyu ihdícyátsɨhjɨ́ríyé diíbye. ");
INSERT INTO boaNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Aabe tsá mutájpí íjcyatúne. Muurá ihdyu dííbyedítyúré tsááne bóhɨɨma méijcyáhi. Áhdure panéváré íñe múhduná tééne tájpí meícyahíjcyáné dííbyedítyúré tsááhií. ");
INSERT INTO boaNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Muuráhjáa tsáápihdítyúré íñe múhdumé ííñújɨri meíjcyámeke llíyaatétsoóbe. Áánemáa ɨ́hdétújuco dibye éévecúné kiáhjɨ́ meíjcyaíñé múijyúhaja. ");
INSERT INTO boaNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ehdúu méénuube dííbyedi meɨ́tsámeíhíjcyáné nɨ́jcáutu ɨ́htsútúnetu mewáájácu méhdityu kiá íjcyátúróóbeke. ");
INSERT INTO boaNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Muurá dííbyedítyúré tsááne bóhɨɨma méijcyá éhnéhjáa tsaate íllu néhduú: “Muha méijcyá Píívyéébej tsɨ́ɨ́me.” ");
INSERT INTO boaNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Aane tsúúca dííbyej tsɨ́ɨ́mé meíjcyame tsá meɨ́jtsúcunúítyuró eene panévatúré mɨ́amúnaa óórótuú, nééwáyutuu, dsɨ́ɨ́dsɨtuu, nícyohíjcyánehjɨ́dú Píívyéébe nééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Muuráhjáa ihdyu éíjyuúvú pevénéré ɨɨtécunúhíjcyaabe mɨ́amúnaa iwáájácútúné hallúrí ehdu méénuhícyáne. Árónáa ícyooca pámeere mɨ́amúnáake neebe ímityúné meícyahíjcyáné meɨ́hvéjtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Muurá muhdú meícyahíjcyáné iwáájacúdú mééma ímíbájchóiibye ípyée imyéménuube Jetsóoj tééveri. Aanée muurá meke waajácútsoobe dííbyeke ibóhɨ́ɨ́tsóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ehdúhjáa Páávoro dsɨ́jɨvémé tsiiñe bóhɨ́ɨ́netu íhjyúváneri íllure tsaate uuhɨ́vaté dííbyedi. Áánetúhjáa tsaate nééhií: —Muha ihdyu méimíllé tsíijyu tsiiñe téénetu u íhjyuváné melléébúcunúne. ");
INSERT INTO boaNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","34","Áámedítyúhjáa tsúúca tsaaté múnaa cáhcujtsómé dííbyema nahbévahíjcyáhi. Áámemáhjáa íjcyaabe Dioníítsio teene ‘Areóópago’ némeítsihvu dóbéévehíjcyáméejpi. Áhduréhjáa ‘Dáámari’ némeíllema tsíjtyehjɨ ijcyá diityéma. ");
INSERT INTO boaNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Aanéhjáa Páávoro teene Atéénatu péébe úújeté Coríítovu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Átsihdyúhjáa aahɨ́vetéébé imúnáajpi Akíírake Póótó iiñújɨ múnáájpiíkye. Téijyúhjáa téhdure botsíi wajtsɨ́ɨ́bé Itááriá iiñújɨtu mewa Piritsíírama, Ávyéjuubeváa Cáráóódio pámeere Róómári íjcyáné jodíómú íjchívyeíñé néénetu tsáámutsi. ");
INSERT INTO boaNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Aanéhjáa Páávoro diityétsimáyéjuco íjcyane diityétsikye íwákimyéityu ɨpɨ́áábo téeméné wákimyéí imyéénuhíjcyánélliíhye. Aaméhjáa méénuhíjcyá cuwájaanédú nééné nujúwááne. ");
INSERT INTO boaNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Áijyúhjáa ténevá wáyeéévéjcoojɨ́vádú pehíjcyaabe imúnaa jodíómú pihcyáávejávu. Aabéhjáa úwáábohíjcyá Jetsóodítyú íjcyáné uwááboju imúnáama tsijtye imúnaa íjcyáturómeke ditye icyáhcújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Áánáacáhjáa tsúúca Tsíírámutsi Timotéoma wajtsɨ́ Matsedóóniá iiñújɨtu. Áijyúhjáa Páávoro tsanééríyé uwáábori íjcyaabe nehíjcyá imúnáake diibyéjuco Jetsóó dityée téhmehíjcyaabe Críjto Mépájtyetétsoobe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ehdúhjáa dibye néérónáa dííbyedítyú nehníwu ihjyúváme. Áánélliihyéhjáa ílluréjuco dibye diityédítyú ipyéé íwajyámú wátsóújcoobéré nééneé: —Árone tsáma ámúhá hallúriyéjuco teene ámuha medsɨ́jɨ́vécooca meɨ́cúbáhrámeíiñe. Tsá táhallúrí tene íjcyatúne. Ahdícyane jodíómú íjcyátúróme éllevúréjuco o pééiñe diityékeréjuco o úwááboki. ");
INSERT INTO boaNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ehdúhjáa iñééne ílluréjuco dibye tééjatu íjchivyéne. Átsihdyúhjáa péébe úújeté Jójto jávú teenéhjáa pihcyáávéjá úníuríyé íjcyaabe tsúúcajátújuco Píívyéébeke dúúrúvahíjcyáábe jávu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Áijyúhjáa teene pihcyáávéjá avyéjuube ‘Críjpoó’ némeííbyé cáhcujtsó Jetsóodítyú íjcyáné uwááboju pámeere ihyájkímuma. Aaméhjáa tsójtsótsámeíhi. Áhduréhjáa tsijtye Coríító cóómi múnáadítyú cáhcujtsómé tsójtsótsámeíhi. ");
INSERT INTO boaNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Átsihdyúhjáa Páávoródívú tsápejco Jetsóó naavédú nééné pañe ibóhówáávéne néé dííbyeke: —Imíchi díícyáne éhnííñevu dúwááboco ɨ́ɨ́nerí íllityétuubére. ");
INSERT INTO boaNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ijcyámé mítyame ícyoomíyí tahñéjté íjcyaímye. Áánéllii ehdu uke o nééhií. Áábeke o íjcyátúcoocájɨ́ɨ́va múha uke muhdú méénuúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ahdújucóhjáa tsáné pijcyábáj pɨɨnévú tétsii Coríítori íjcyaabe diityéké úwáábohíjcyáné Píívyéébé ihjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Áijyúhjáa Acááyá iiñújɨ́ avyéjuube Garióó íjcyánáa tsaate imúnaa jodíómú cáhcújtsotúmé ipítyácójcatsíñe Páávoróké ékeevéhi. Áábekéhjáa tsajtyémé diibye ávyéjúúbe éllevu dibye ímítyunéhjɨ́ ímíbáchohíjcyátsihvu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Áánemáhjáa dííbyé hallúvú úúballémé dííbyeke. Nééméhjápeé: —Áánu métaúhbaju nééné tsɨjɨ́jtoríyé mɨ́amúnáake úwááboobéré pehíjcyá dityévá Píívyéébeke idyúúrúvaki. ");
INSERT INTO boaNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ehdúhjáa Páávoró hallúvú ditye úúbállénéllii dibye íhjyúváíyóné ɨhdéré diibye ávyéjuube Garióó diityéké nééhií: —Ihdyúhde tehdújúcooíyó dííbyema o ímíbájchóiyóné dibye ímítyuné méénuca. ");
INSERT INTO boaNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Áánetu ámúhá taúhbaju nééné tsɨjɨ́jtoríyé dibye tsáápihdítyú íjcyáné uwááboju úwáábohíjcyáhajchíí wa ihdyu ámuháyé chooco méímíbáchojcátsij. Tsá o ímílletú átéréenéhjɨ́ o ímíbajchóne. ");
INSERT INTO boaNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ehdúhjáa iñééne ílluréjuco dibye diityéké wálloone tétsihdyu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Árónáacáhjáa pihcyáávéjá avyéjuube Tsójtenéké tsaate gríéégomu iékéévéébeke wápáajcó diibye ávyéjúúbé úmɨwávu. Áróneríhjyáa tsá dibye ɨ́ɨ́cúvetúne. ");
INSERT INTO boaNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Aanéhjáa Coríítori tsúcájá Páávoro ícyahíjcyáhi. Aabéhjáa tétsihvu ‘Tséékeréa’ némeí mujcóvú béérómeí tsanéhjáa ɨ́mɨáánetúré imyéénuíñé iñééné uubálle. Ehdúhjáa méénúmeííbyé Tsííriá iiñújɨvu ipyéétúné ɨhde. Átsihdyúhjáa botsíi tétsíí cahcújtso múnáake ipítyájcóne peebe Akííramútsima tsahííyí teene Tsííriá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Aaméhjáa Éépetsóvú úújeté tétsihvu Akííramútsí mewa Piritsíírama cóéváítsihvu. Átsihvúhjáa Páávoro imúnaa jodíómú pihcyáávejávú péébe úwaabó tééjavu píhcyáávémeke. ");
INSERT INTO boaNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Áábekéhjáa neerómé dibye tsuucájááneúvú dityémá iíjcyaki. Árónáacáhjáa tsá dibye ímílletúne. ");
INSERT INTO boaNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Áánemáhjáa diityéké pítyájcoobe nééhií: —Árónáa ó imíllé o pééne Jerotsaréevu. Aabe óvíi Píívyéébe ímílléhajchíí tsiiñe ámúhakye ó uujéváhi. Ehdúhjáa iñééne péjúcoobe tsahííyí teene Éépetsótu. Áánetúhjáa Akííramútsí dííbyedítyú coévá tétsihvu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Aabéhjáa Tsetsaréavu úújetéébé tétsihdyu botsíi péé Jerotsaréeri íjcyáné cahcújtso múnáa éllevu. Átsihdyúhjáa peebe Ajtiokííavu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Átsihyíhjyáa tsúcájá iíjcyátsihdyu idyé tsiiñe pehíjcyaabe Garáátsiámá Pírííjiá iñújɨ́ɨ́curi íjcyáné cahcújtso múnáake tsápɨ́jtsoobéré técomívádu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Áijyúhjáa Arejadrííá cóómi múnáajpi jodíómuube Apóóró teene Éépetsóvú wajtsɨ́hi. Aabéhjáa ɨ́mɨá uwááboobe íjcyaabe mítyane waajácú Píívyéébé ihjyu. ");
INSERT INTO boaNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","26","Aabéhjáa úwáábohíjcyá muhdú Jetsóoke meúráávyejɨ́jtó tsaate dííbyeke úwaabóne. Úwáábohíjcyaabéhjáa apááñéré Jóáápe tsótsohíjcyánetu íjcyáné uwáábó iwáájacúné imúnáá pihcyáávéjá pañévú ɨ́ɨ́nerí núhnévétuubére. Aanéhjáa dibye nɨ́jkevádú Akííramútsí dííbyeke ihjyávú itsájtyéne botsíi ímíñeúvú úwaabó muhdúhjáa Píívyéébe Jetsóoj tééveri mééma méénune. ");
INSERT INTO boaNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aabéhjáa imíllé Acááyá iiñújɨvu ipyééneé. Aanéhjáa cahcújtso múnaa ímí ɨɨ́jtsúcunúnéllii caatúnú waajácuháámɨ́ téhullé cahcújtso múnáa éllevu ditye tsaímíyé iwáátsúcúpéjtso dííbyeke. Aabéhjáa téhullévú úújetéébé Píívyéébere túkévéjtsóneri pɨ́áábohíjcyá mítyane cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Aabéhjáa imúnaa jodíómuke nehíjcyá diibyéjuco Jetsóó Críjto Mépájtyetétsoobe íjcyane Píívyéébé waajácúháámɨtúu tene néhdújuco. Ehdúhjáa dibye néénéllii tsáhájuco ditye ɨɨná néétune. ");
INSERT INTO boaNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aabéhjáa Coríítori íjcyánáa Páávoro íjchí iiñújɨri péhíjcyaabe úújeté Éépetsóvu. Átsihyíhjyáa ijcyámé tsaate Píívyéébé cahcújtso múnaa Jóááúvú uwáábó úráávyehíjcyáme. ");
INSERT INTO boaNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Áámekéhjáa neébe: —¿A ámuhápe Píívyéébeke mecáhcújtsótujkénúijyu tsúúca dííbyé Apííchó ámúhá pañévú úcaavéhi? Áánélliihyéhjáa néémeé: —Tehdu muha mewáájácúnejɨ́ɨ́va dííbyé Apííchó íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Áánélliihyéhjáa neebe diityéke: —¿Acáa ɨ́ɨ́né uwáábórá ámuha mecáhcújtsóne métsójtsótsámeíhi? Áánélliihyéhjáa néémeé: —Mu ihdyúu éhne Jóááuvu tsótsohíjcyáné uwáábo. ");
INSERT INTO boaNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Áánélliihyéhjáa neébe: —Ɨ́mɨáánéjucóhdée diibye Jóáa tsótsohíjcyáné ímityúné iícyahíjcyanéhjɨ́ ɨ́hvéjtsómeke. Árónáacáa ihdyu diityéké nehíjcyaabe dííbyé boone Mépájtyetétsoobe Jetsóó úwáábóííbyeke ditye icyáhcújtsoki. ");
INSERT INTO boaNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Áánélliihyéhjáa botsíi Jetsóoke icyáhcújtsóne tsiiñe tsójtsótsámeímyé dííbye mémeri. ");
INSERT INTO boaNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Áámé hallúvúhjáa Páávoro tsáápiitsá hallúvú íhyójtsɨ ipícyóóne Píívyéébema íhjyúváné tujkéveri dííbyé Apííchó diityé pañévú úcaavéhi. Aaméhjáa tsíjyúhjɨri illéébótúrójúhjɨri Píívyéébeke duurúvahíjcyáhi. Áhduréhjáa téénere túkévéjtsóneri úúbállehíjcyámé dibyée diityédívú íuwááboju bóhówajtsóne. ");
INSERT INTO boaNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Aaméhjáa diitye Píívyéébé Apííchó diityé pañévú úcaavémé 12-meva. ");
INSERT INTO boaNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Aanéhjáa Páávoro pápihchúú nuhbává imúnaa jodíómú pihcyáávéjá pañévú úwáábohíjcyá ɨ́ɨ́nerí núhnévétuubére. Aabéhjáa mɨ́amúnáake téɨ́búwátsohíjcyá Píívyéébé avyéjú icyánejcúvu. ");
INSERT INTO boaNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Árónáacáhjáa tsaate tsá ímílletú icyáhcujtsóne. Aaméhjáa nehníwu ihjyúvahíjcyá teene Jetsóodítyú íjcyáné uwáábotu pámé úmɨwávúre. Áánélliihyéhjáa Páávoro diityédítyú péé pámeemáyé cahcújtso múnáama ‘Tirááno’ némeííbyé uwáábojávu. ");
INSERT INTO boaNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aabéhjáa tééjavúréjuco diityéké úwáábohíjcyáné míñéécú pijcyába. Aanéhjáa tsúúca pámeere Áátsiá iiñújɨ múnaa lleebójucóó Jetsóodítyú íjcyáné uwááboju dibye úwáábohíjcyáne. Áhduréhjáa tsijtye jodíómú íjcyáturómé tsúúca lleebóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Áijyúhjáa dííbyej tééveri Píívyéébe méénuhíjcyá mítyane méénúráítyúronéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ávyetáhjáa dííbyé miñúbajáánema íwajyámúúné chéméméhjɨ éllevu ditye tsájtyéróneri tsúúca bóhɨhíjcyáme. Tsaaté pañéhjáa naavémú íjcyároméhjɨ́ ichívyehíjcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Áijyúhjáa tsaate téhullé múnaa jodíómú naavémuke tsaaté pañétú íchívyétsohíjcyámé imíllerá Jetsóo mémeríyéjuco iíjchívyetsóne. Aaméhjáa néjcatsíhi: —Méneé tsaaté pañétú ditye iíjchívye éhne Páávoro úwáábohíjcyaabe Jetsóo mémeri. ");
INSERT INTO boaNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ehdúhjáa imíllerómé imyéénune jodíómuube Etséébá llúúvájté avyéjúúbej tsɨ́ɨ́mé 7-meva íjcyame. ");
INSERT INTO boaNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Aaméhjáa tehdu méénúrónáa tsáápí pañétú diibye naavéné nééhií: —Muurá ó waajácú Jetsóoke. Áhdure ó waajácú muubá Páávoro íjcyane. Áánetu ¿muutá ámuúha? ");
INSERT INTO boaNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ehdúhjáa néébere diibye mɨ́amúnáajpi naavéné ípañe íjcyaabe diityéké méénúnetu ílluréjuco ditye wááne tééjá pañétú íévejtéhjɨréjuco wájyamúúvatúmé dibye túúvátsónéhjɨma. ");
INSERT INTO boaNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aanéhjáa pámeere Éépetsó múnaa jodíómumáyé tsijtye jodíómú íjcyátúmé iwáájácúneri mítyane iíllityéne Jetsóoke ávyéjujtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Áhduréhjáa tsaate cáhcujtsójúcóómedítyú úúbállehíjcyá ɨ́hdéhjáa ímityúné iícyahíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Áánetúhjáa ápííchojte ténéhjɨ́ waajácúhaamɨ́né ílluréjuco cóvajtsóné pámeere ɨ́ɨ́téneríye. Ááné pañéhjáa ɨjtsúcunúmé dsɨɨdsɨ wágóoovéné 50 míi. ");
INSERT INTO boaNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ehdúhjáa téijyu Jetsóodítyú íjcyáné uwááboju tsújaavé pámehdívúre. ");
INSERT INTO boaNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ááné boonétúhjáa Páávoro ɨ́jtsámeí Matsedóóniámá Acááyá iñújɨ́ɨ́cú iááhɨ́vetétsihdyu botsíi Jerotsaréevu ipyééiñe. Áhduréhjáa nehíjcyaabe teene Jerotsaréetu ipyééiñe Róómávuú. ");
INSERT INTO boaNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Áánélliihyéhjáa ɨ́hde wálloobe ɨ́pɨáábojtétsikye Matsedóóniávú Timotéoma Erájtomútsikye. Áánetúikyéhjáa tsúcájá coévaabe Áátsiá iiñújɨvu. ");
INSERT INTO boaNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aabéhjáa Jetsóodítyú íjcyáné uwááboju úwáábohíjcyáné hallútú cáhcújtsotúmé páhduváré dárɨ́ɨ́vehíjcyá cahcújtso múnáake. ");
INSERT INTO boaNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tsaapíhjyáa ‘Deméétrio’ némeííbyedítyú tujkéváne. Diibyéhjáa nícyohíjcyá úwáñewáánetu ‘Diána’ némeíñé níjcyota píívyélledi idíllone idyúúrúvahíjcyája nááve. Ááné hallúvúhjáa mítyane dsɨɨdsɨ́vahíjcyámé pámeere íwákimyéi múnáama. ");
INSERT INTO boaNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aabéhjáa pámeere múhdumé téeménéhjɨ́ wákímyeíhíjcyámeke ipíhjyúcúne nééhií: —Muurá ámuha méwaajácú íñe mewákímyeímyé tsaímíyé meícyahíjcyáné ɨ́ɨ́netú pɨ́htotúme. ");
INSERT INTO boaNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aane ¿ɨ́veekí Páávoro nehíjcyá íñe menícyohíjcyámé píívyéébe íjcyatúne? Ehdu iñééneri muurá mítyámekéjuco dibye tsíñejcúvúré ɨ́búwajtsóne. Aane muurá tsá apátsiíyé íchii Éépetsórí dibye tehdu méénutúne. Muuráhjáubá páneeréjuco Áátsiá iiñújɨri ehdu dibye méénune. ");
INSERT INTO boaNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Aane múhdurá teene méémaá. Muurá méwákimyéí tééne tájpíjyuco meícyahíjcyáné méhdivu wágóóóvéiyáhi. Áhdure diille ɨ́htsútulle píívyélleke Áátsiá múnáama pámeere ííñújɨri íjcyáné mɨ́amúnaa dúúrúvahíjcyálle ja tsáhájuco bóhówaúcunújúcóóítyuróne. ");
INSERT INTO boaNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ehdúhjáa dibye néénéllii tsijtye icyáyobáávaténe íllu wáñejcóhi: —¡Ñóóooj, ehdɨ́ɨ́vájullé tsáma ɨ́htsútulle Epéétsiómú piivyéllé Diánaj! Ehdúhjáa iwáñéjcóne néémeé. ");
INSERT INTO boaNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Áijyúhjáa ihdyu kiávú técoomíyí mɨ́amúnaa iibórɨ́nújcatsíhi. Áánáacáhjáa Matsedóóniá múnáajtétsí Gááyóma Arijtáácomútsí Páávoróké náhbénuhíjcyámútsikye lliúcuíñúmé ditye píhcyáávehíjcyájá pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Áájá pañévúhjáa Páávoro ipyééne diityémá íhjyúvatéíyónáa tsá cahcújtso múnaa dííbyeke ɨ́hvéjtsotúne. ");
INSERT INTO boaNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Áhduréhjáa tsaate Áátsiá iiñújɨ múnaa ávyéjujte dííbyeke wáájacúmé néé tsaatéké ditye iñéé dííbyeke téhullévú dibye ipyéétuki. ");
INSERT INTO boaNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Áánáacáhjáa ihdyu mɨ́amúnaa iibórɨba teene pihcyááveri íjcyame. Aanéhjáa mítyame tsá wáájácutú ɨ́ɨ́nélliihyé ímichi ipíhcyaavéne. ");
INSERT INTO boaNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Áánáacáhjáa tsaate jodíómú imúnáajpi Arejáádoróké cátujcú dibye diityé úmɨwávú ipyééne iíhjyúvaki. Ahdújucóhjáa iíhjyúva dibye íhyójtsɨri diityéké néérone cúúvéhulléréjuco ditye iíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Árónáacáhjáa ‘dáij’ néétune tsiiñe íllu wáñécohíjcyáme: —¡Ñóóooj, ehdɨ́ɨ́vájullé tsáma ɨ́htsútulle Epéétsiómú piivyéllé Diánaj! Ehdúhjáa iwáñéjcóne nehíjcyámé míñéécu hóórá hajchótá jodíómuube dibye íjcyane iwáájácúnema. ");
INSERT INTO boaNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Áámekéhjáa técoomí avyéjuube idyáíívyétsómeke nééhií: —Ámuúha tamúnaa íñe Éépetsórí meíjcyamej, pámeere muurá waajácú éhnée cáámetu áákityéné neewáyú píívyélle Diánadi medíllóné duurúvaja méhójtsɨ́ pañe íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aane tehdu múha tóónúíyónejɨ́ɨ́vari. Áánéllii ílluréjuco metáchúúréévéne cúúvéhulléréjuco meíjcya. Aame ɨɨná mémeenújúcohdí ímíñeúvú ɨ́jtsámeítyúme. ");
INSERT INTO boaNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muurá íjtyétsikye ííllevu ámuha metsívamútsí tsá ɨ́ɨ́né imítyúné méénutúne. Áhdure tsá dityétsí méduurúvaja tútávájtsotúne. Aamútsí muurá tsá ɨɨná ímityúné íhjyúvatú mépiivyélledítyu. ");
INSERT INTO boaNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ahdícyane Deméétrio íwákimyéi múnáama tsaatédítyú ímityúné iíjyácunúhajchíí óvíi péé ténéhjɨ́ ímibájcho múnáa éllevu teene iímíbájchoki. Muurá téénéllii ijcyáné ténéhjɨ́ ímibájchotsɨ́hjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Áánetu ávyétá ɨhnáhó nééne íjcyáhajchíí múu ɨ́hvejtsó páñétúéhullévú tene iímíbáávyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Muurá ícyooca ápíchó nééne máhallúrí téénetu menéétsámeíiyóne. Tsá muurá ɨɨná menééítyuró íñe ícyooca pájtyene páñétúejte meke dílloca. ");
INSERT INTO boaNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ehdúhjáa iñééne ílluréjuco dibye diityéké tsújaúcúne. ");
INSERT INTO boaNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Aaméhjáa iííbórɨ́nújcatsíñetu ɨ́hvetédú Páávoro cahcújtso múnáake ipíhjyúcúne túkévejtsóhi. Átsihdyúhjáa diityéké ipítyájcóne Matsedóóniá iiñújɨvúréjuco dibye pééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Aabéhjáa téhullé cahcújtso múnáake ááhɨ́veebe diityéké tsápɨ́tsohíjcyáhi. Átsihdyúhjáa péébe Gréétsiá iiñújɨvu iúújetétsihyi ijcyá pápihchúú nuhbáva. ");
INSERT INTO boaNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Aabéhjáa tsahííyí Tsííriá iiñújɨvu pééíyónáa tsaate imúnaa dííbyedítyú ímityúné pítyájcámeíñé iwáájácúne ɨ́jtsámeííbyé Matsedóóniá iiñújɨvúré tsiiñe ióómiíñé íjchityu. ");
INSERT INTO boaNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Áábemáa o pééíñáa múhtsikye náhbénuímyé múhtsí ɨhdéjuco Tóróóavu ipyééne téhullétú múhtsikye téhmeténé ílluúme: Beréa múnáajpi Tsóópatee, Tetsaróónicá múnáajtétsí Arijtáácomútsí Tsegóódomaa, Déébé múnáajpi Gááyoó, Timotéoo, Áátsiá iiñújɨ múnáajtétsí Tííkicyómútsí Tóróópimómaa, éhdume. ");
INSERT INTO boaNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Áánetúikyée muhtsi mecóévamútsí óórítyúne pááá májchómeíhíjcyáné wañéhjɨ́ pajtyétavu botsíi Pirípotu tsahííyí mepéémutsi méúújeté tsáhojtsɨ́j coojɨ́vatu diityédívú Tóróóavu. Átsihyíi muha méijcyá tsané tsemáána. ");
INSERT INTO boaNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Aamée muha tsemááná déjúcóóvejcóójɨ́ medóbéévéne pááa mémajchó Jetsóó dsɨjɨ́vé meɨ́tsaavéne. Áijyúu Páávoro úwaabó ávyeta pécójpɨɨnévújuco tsíijyu muha mepéjúcóóíñélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Téijyúu muha médóbeevé cáámééhó pañévú peetéháñej tééveri. ");
INSERT INTO boaNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Áánáacáa ováhtsáwu ‘Éóótico’ némeííbyé ácuúcunúhijcyá páhoowa nétsihyi. Aabéhjáa icyúwaíñúné hallúrí baavu áákityéébé dsɨ́jɨvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Áánélliihyée Páávoro ɨ́ɨ́cúi iñíítyéne dííbyeke iámabúcúne nééhií: —Méíllityédíne. Muurá ihdyu bóhɨ́ɨ́roóbe. ");
INSERT INTO boaNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Átsihdyúu tsiiñe cáámevu néríívyéébema muha pááa mémajchó Jetsóó dsɨjɨ́vé meɨ́tsaavéne. Ááné boonétúu idyé tsiiñe íuwáábó cámahjácoobe tsɨ́tsɨjnécu. Átsihdyúu ílluréjuco muha mepééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Áánetúu tétsíi múnaa ihjyáhañévuréjuco péémema diibye ováhtsáwu pééneri mítyane ímíjyuuvéme. ");
INSERT INTO boaNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Aamée muha mepéjúcóónáa Páávoro múúhadítyú coévá tétsihvúré Tóróóavu íjchityúré ipyéé Atsóovu. Áánetúu muha ɨ́hde cúújúwámɨri mepééme méúújeté técoomívú tétsihdyu dííbyeke muha meújcuki. ");
INSERT INTO boaNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aamée muha técoomítyú dííbyeke meújcuíñútsihdyu mepééme méúújeté Mitiréénevu. ");
INSERT INTO boaNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Átsihdyúu muha mepééme tsíijyu ‘Kííoó’ némeíñé caapáhó tujkévetu mepájtyeme tsíjcyoojɨ méúújeté ‘Tsáámoó’ némeíñé caapáhó mujcóvu. Ámujcótúu muha mepájtyeme mécúwaté Trojíírióvu. Ááné tsiíjyúu botsíi muha méúújeté Miréétovu. ");
INSERT INTO boaNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ehdúu muha mepéhíjcyánáa Páávoro ɨ́jtsámeí Jerotsaréeri muha Pejtecojtéé wañéhjɨ́ mepájtyeíñe. Áánélliihyéikyée tsá dibye ímílletú muha Áátsiá iiñújɨri íjcyacóómí Éépetsóvú mepééne ɨ́ɨ́cúi muha téhullétú meóómíítyúrónélliíhye. ");
INSERT INTO boaNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Aabée Miréétori íjcyaabe pɨ́uvá Éépetsórí íjcyáné cahcújtso múnáá túkevéjtsojtéke. ");
INSERT INTO boaNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Áámekée neébe: —Ámuha muurá méwaajácú muhdúhjáa Áátsiá iiñújɨvu o wátsɨ́tujkénúijyu o ícyahíjcyáne. ");
INSERT INTO boaNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Muuráhjáa tamúnaa jodíómú íjcyarómé oke páhduváré dárɨ́ɨ́véneri támeííbyéré Píívyéébé wákimyéí ó méénuhíjcyá ɨɨná néétuubére. ");
INSERT INTO boaNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Árónáacáa tsá o ɨ́hvetétú ámúhakye pɨ́ááboíñé patsɨ́hjɨvávúré úwááboobéré o péhíjcyánetu. ");
INSERT INTO boaNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Aabée ámúhakye pámeekéré tamúnaa íjcyátúróméhjɨma ó nehíjcyá ímityúné ámuha meícyahíjcyáné meɨ́hvéjtsóne Máavyéjuube Jetsocríjtoke mecáhcújtso ímí Píívyéébema ámuha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Aabe íñe ícyooca tsiiñe o péé Jerotsaréevu Píívyéébé Apííchó oke túkévéjtsóneri muhdú táúmɨwa íjcyane wáájácútuúbe. ");
INSERT INTO boaNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Muurá pahúlleva o péhíjcyá coomíjɨvu téénere Píívyéébé Apííchó tsúúca oke waajácutsójúcoorá Jerotsaréevu oke ditye cúvéhoojánuube o ɨ́cúbáhrámeíiñe. ");
INSERT INTO boaNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Áróneri tsá o áábímyeítyúne. Apááñéré ihdyu ó imíllerá Píívyéébée meke iwájyúne mééma mepájtyetéiñe méénúné uwáábojúvú Jetsóó oke níwááveíñúné o nɨ́jkeváne. ");
INSERT INTO boaNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ahdícyane ámúhakye o néé íñe múhdúméj pɨɨnévú Píívyéébé avyéjutu íjcyáné uwááboju úwááboobéré o péhijcyámé ámuha oke maájtyumɨ́júcóóityúne. ");
INSERT INTO boaNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Téhdure ámúhakye o néé ámuha mewágóóóvéhajchíí tsá táhallúrí tene íjcyáityúne. ");
INSERT INTO boaNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Muurá tsúúca páneere ámúhadívú ó bóhówajtsójúcoorá muhdú Píívyéébé ɨ́jtsaméí íjcyane. ");
INSERT INTO boaNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ahdícyane tsáma téɨɨbúwá méíjcyaco ámuha uwáábojte meíjcyame. Ímíñeúvú météhmeco cahcújtso múnáake Íllíi Jetsóó tujpácyó wágóóóvénej tééveri dibye újcúmeke. Muuráhjáa diityédívú ámúhakye níwááveebe Íapííchoj tééveri diityé túkevéjtsojte ámuha meíjcyaki. ");
INSERT INTO boaNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Árónáa ó waajácú íchihdyu o pééné boone tsaate múhdurá iúwáábóneri íllure diityéké tútávájtsoíñé éhne múúne oohííbyé obééjámuke tútávajtsódu. ");
INSERT INTO boaNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Áhdure íjcyaímyé tsaate ámúhadítyúré ɨ́mɨá uwááboju tsɨjɨ́jtoríyé átéréenéhjɨ́ úwááboímye. Ááneri íllure cahcújtso múnáake mújtátsoímye. ");
INSERT INTO boaNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Áánéllii tsáma téɨɨbúwá méíjcyaco éhnée pápihchúú pijcyábá hajchótá támaatyóú o wáágóóne ámúhakye o úwáábohíjcyáné meɨ́tsáávénema. ");
INSERT INTO boaNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ahdícyane ámuha Píívyéébeéjté meíjcyame óvíi dííbye tájpiyéjuco ámuha meíjcyane meke iwájyúne dibye ácuhíjcyáné uwáábójú pañe ɨ́htsutúmeréjuco. ");
INSERT INTO boaNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Cáhawáá méɨjtsúcunuj, tsáháa muurá o íjyácunútú oke tsaate dsɨ́ɨ́dsɨdívú áhdoobe ehnéva múnáajpi o íjcyaabe ɨ́mɨá wajyámuma o íjcyáíyóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Muuráhjáa ámuháyé wájácú menééne oore tsáávanéréi ó wákímyeíhijcyá óóma íjcyámema muha mepɨ́htone meújcuki. ");
INSERT INTO boaNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aabée muurá ámúhakye panévatúré ó úwáábohíjcyá muhdú mewákímyeíiyóné ɨ́dáátsóméhjɨke mepɨ́áábo éhnéhjáa Ávyéjuube Jetsóó íllu néhijcyáné o ɨ́tsáávénema: “Muurá tsaatéké tsíeménevu ájcume ímíjyúúvéiyá ditye ájcume ímíjyúúvéné ehnííñevu.” ");
INSERT INTO boaNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ehdúu diityéké iñétsihdyu Páávoro Píívyéébema iíhjyúva mɨ́móúúvénéllii muha téhdure mémɨ́móuuvéhi. ");
INSERT INTO boaNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Áábekée pámeere ikímóóvéne ámábiñúhi. ");
INSERT INTO boaNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Aamée múúhakye pícyohjé cúújúwamɨ́vú dibyée ‘tsáhájucóubá tsiiñe oke ámuha maájtyúmɨ́ityúne’ nééneri kímóóvemére. ");
INSERT INTO boaNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Aamée muha tétsihdyu mepéé tsapéhdú ‘Cóoó’ némeíñé caapáhovu. Ááné tsiíjyúu muha méúújeté ‘Róódaá’ némeíñé caapáhovu. Átsihdyúu botsíi muha méúújeté Páátarávu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Átsihvúu muha tsɨ́ɨ́mɨvúréjuco mepájtyene Peníítsiá iiñújɨvu péémɨvu. Áámɨríyéjucóo muha mepééneé. ");
INSERT INTO boaNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Aamée muha ‘Chíípere’ némeíñé caapáhó náníñéjcuri meɨ́ɨ́teíñútsihdyu mepéhijcyámé méúújeté Tsííriá iiñújɨvu. Aaméikyée muha Tííró mujcójuvu mécátsúúveté tétsihvu tsane pííchuta iíjchívyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Átsihyíi muha tsaate cahcújtso múnáake maájtyúmɨtémemái méijcyá tsáné tsemáána. Aamée Páávoróké néé dibye Jerotsaréevu ipyéétu Píívyéébé Apííchóréhjáa diityéké túkévéjtsóneri. ");
INSERT INTO boaNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aamée muha técoomíyí téhajchótá meíjcyánetu mepéémeke pícyohjémé pámeere mújcojúvu. Áámemáa muha pámeere memɨ́hmóúbáne Píívyéébema méihjyúváhi. ");
INSERT INTO boaNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Átsihdyúu muha ílluréjuco diityéké mepítyájcóne meúcaavéné cúújúwámɨ́ pañévu. Ááné tujkéveríjyucóo ditye óómiñe ihjyáhañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Aamée muha Tíírótu nihñéréjuco tsahííyí mepééme mécátsúúveté Toremáidávu. Átsihyíi íjcyáné cahcújtso múnáadívú muha meúújetémema méijcyá tsájcoójɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ááné tsiíjyúu muha mepééme méúújeté Tsetsaréavu. Aamée muha mepéé Perípe jávú cahcújtso múnáá túkevéjtsojtéhjáa 7-meva íjcyámedítyú uwáábori úllehíjcyáábe jávu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Áábej tsɨ́ɨ́mée pɨ́ɨ́néehójtsɨ́meva walléémú tájɨ́vatúmé íjcyame úúbállehíjcyá Píívyéébere diityéké ájcúné ɨ́jtsaméiyi ɨɨná pájtyeíñé iwáájacúne. ");
INSERT INTO boaNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aamée muha tétsihyi tsúcájáhréjuco meícyahíjcyánáa Píívyéébé ihjyú uubálle múnáajpi Agáábó wajtsɨ́ tétsihvu Jodéatu tsáábeé. ");
INSERT INTO boaNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Aabée múúhakye ááhɨ́veebe Páávoró ocájɨmɨ́ɨ́hé iújcúmɨ́ɨ́heri íhyójtsɨcuu, íjtyúhaácyuu, íjcyane ichíácómeíñe nééhií: —Píívyéébé Apííchó muurá nehíjcyá ílluva ditye íñe ócájɨ́mɨ́ɨ́hé aabájáábeke Jerotsaréevu ichíjchúúbeke ɨ́hvéjtsoíñé tsííñé iiñújɨ múnáá hójtsɨ́ pañévu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ehdúu dibye néénéllii muha teene Tsetsaréa múnáama méneerá Páávoróké dibye ipyéétu téhullévu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Árónáacáa múúhakye neébe: —¿Ɨ́ɨ́nerí ámuha mekímoovéné ɨ́dátsó oke pajtyéhi? Tehdu apááñéré oke ditye chíjchúíñejɨ́ɨ́vari. Óvíi néhi ihdyu oke illííhyánúhajchíí lliihyánúmé Ávyéjuube Jetsóoke o cáhcújtsóné hallútu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ehdúu múúhakye dibye néénéllii muha dííbyeke menééhií: —Óvíikyéhde muhdú Píívyéébe ímillédú ú ijcyáhi. ");
INSERT INTO boaNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Átsihdyúu muha ílluréjuco meímíbájkímyeíñe mepééne Jerotsaréevu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Áámemáa múúhama tsaate cahcújtso múnaa péé Tsetsaréatu. Aamée muha méúújeté Chííperé múnáajpi tsúúcajátújucóhjáa Píívyéébeke cáhcújtsoobe Natsóo jávu. ");
INSERT INTO boaNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Átsihdyúu muha Jerotsaréevu meúújetémeke tétsíí cahcújtso múnaa tsaímíyé waatsúcúpejtsóhi. ");
INSERT INTO boaNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ááné tsiíjyúu muha Páávorómá máaahɨ́veté Jacóóboke. Áánáacáa tétsihyi pámeere cahcújtso múnáá túkevéjtsojte. ");
INSERT INTO boaNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Áámedívúu muha meúújetémeke Páávoro úúballé ímíñeúvú muhdúhjáa Píívyéébe jodíómú íjcyátúrómé pañévú dííbyej tééveri méénuhíjcyanéhjɨ. ");
INSERT INTO boaNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Áánélliihyée duurúvámé Píívyéébeke ávyéjújtsomére. Áánemáa nééme dííbyeke: —Ehdɨ́ɨ́vane, muúbej. Muurá múhdúné mɨ́amúnáajpíjyúcooró memúnaa jodíómudítyú cáhcujtsójúcoorómé úraavyépí Píívyéébée Moitséeúvuj tééveri ájcúné taúhbajúúne. ");
INSERT INTO boaNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aame nehíjcyá úhdityu uuva u úwáábohíjcyáné téénetu múu bóijcyúdú pámeekéré jodíómú tsííñé iiñújɨri íjcyámeke ditye tééneri ɨɨ́ɨ́cuvéjúcóótuki. Áhdurévá ú nehíjcyá ditye ɨ́hdéuvúu iícyahíjcyajɨ́jtó ɨɨ́hvéjtsóne ɨ́ɨ́tsɨ́ɨ́meke ikíhdyahɨ́rotsójúcóótuki. ");
INSERT INTO boaNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aane íñe ¿muhdúí teéne? Muurá íñe tsúúca íchihyi u íjcyane iwáájácúcooca píhcyááveímye. ");
INSERT INTO boaNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Áánéllii ú méénuú uke muha menéhduú. Ijcyámé íchihyi múúhadítyú pɨ́ɨ́néehójtsɨ́meva wajpíímú ípyée ɨ́mɨáánetúré imyéénuíñé iñéénéi méénutúme. ");
INSERT INTO boaNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Áámema tsaméhjɨ́ meúcújcatsíñe méímíbájchótsaméí duurúvájá lluuváábedívú memúnaa méénuhíjcyádu. Ááné boonétú ú áhdoó diityémá ditye ibyéérómeíki. Áijyu úhdityu íhjyúvahíjcyarómé neé álliúré íjcyáneri iíhjyúvahíjcyáne. Áhdure neeímyé Píívyéébée Moitséeúvuj tééveri ájcúné taúhbajúúné téhdure u úraavyéne. ");
INSERT INTO boaNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Áánetúu ihdyu tsúúca muha mécaatúnú jodíómú íjcyáturómé Jetsóoke cáhcujtsómé ílluune imyéénútuki: Tsá ditye níjcyotájteke ɨ́ɨ́cúvémeíñé iyámeke dóóityúne; tsá ditye tújpacyo dóóityúne; tsá ditye dóóityú dótsohcáorii, majcánurii, dsɨ́jɨ́véné iyámeke; tsá ditye tsíjtyéhjɨma dómácójcatsíityúne. Ehdúu nééme Páávoróke. ");
INSERT INTO boaNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ahdújucóo dibye diityémá pɨ́ɨ́néehójtsɨ́mevámá iúcújcatsíñe pééneé. Aaméhjáa úcaavé duurúvájá pañévú iúúbálle tééjá tehméébeke múhdúj coojɨ́vatú iímíbájchómeíñé ɨnɨ́jkévaíñé botsíi páñétúétsihvu Píívyéébeke ɨɨ́ɨ́cúvéíñé iyáábeke itsájtyeki. ");
INSERT INTO boaNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Aanéhjáa tsáné tsemáánatu ɨnɨ́jkévaíñé ditye nééne tsúúca nɨjkévaríjyuco íjcyánáa Áátsiá iiñújɨtu tsááné jodíómú ájtyumɨ́ dííbyeke duurúvájá pañe íjcyáábeke. Áábekéhjáa pámeere tétsii íjcyámema páhduváré idyárɨ́ɨ́vétsihdyu ékeevéme. ");
INSERT INTO boaNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Áánemáhjáa kéévánécoba néémeé: —¡Ámuúha ijraéémuj, metsááne múúhak